﻿USE sofia;
DROP TABLE IF EXISTS sofia.kne_vpl;
CREATE TABLE kne_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kne_vpl WRITE;
INSERT INTO kne_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sin damodamo, pinarsuan Diyos din daga ya am-in din wada ed daya. ");
INSERT INTO kne_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Asi et din daga ay nay yan baken naolnos dowan iwed abe di maila, tan mabolinget ya nalilim-otan si napigsa ay dalloyon. Ngem wadas di din Ispiriton Diyos ay mangil-ila. ");
INSERT INTO kne_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Idi siya di, inbilin Diyos ay pomat-a, et pinmat-a. ");
INSERT INTO kne_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Idi inila na ay napat-a, napnek sisya. Pag nan pansianen din napat-a ya din mabolinget. ");
INSERT INTO kne_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nginadanana din napat-a si kaagawan ya din mabolinget si labi. Idi nakdeng pay din labi et kasin mapat-a, say damo ay agew. ");
INSERT INTO kne_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Asi kanan Diyos, “Mawada di mangodwa sin danom ta maitken din danom ay wada ed kayang sin danom ay wada sin daga.” ");
INSERT INTO kne_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","8","Et natongpal, tan inamag na din nginadananas daya ay maikasinan din danom ed kayang sin danom ed dallem. Idi nakdeng kasin din labi yan kasin mapat-a, say maikadwa ay agew. ");
INSERT INTO kne_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Pag ibilin Diyos ay maolnong din danom ay wada sin labaw di daga ta mabonsian din lota, et natongpal. ");
INSERT INTO kne_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Din lota ay sana, say nginadananas daga, ya din naolnong ay danom, nginadananas baybay. Et napnek sisya sin nangilaanas di. ");
INSERT INTO kne_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Asi na pag ibilin ay mawada amin ay kalasin di gomabay isnan lota, ay kaman din natnateng ya din kakaiw, din manlames ya din waday bin-i na. ");
INSERT INTO kne_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ginmabay da tet-ewa, et napnek si Diyos sin nangilaana. ");
INSERT INTO kne_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Makdeng pay din labi yan kasin mapat-a, say maikatlo ay agew. ");
INSERT INTO kne_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nankali si Diyos kasin yan kanana, “Mawada di silsilaw ed daya ta say maikasin din kaagawan ya labi ya ta mailasin abe di agew ya tawen ya siya abe din deam ya tiyagew ");
INSERT INTO kne_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ya ta wada abey maninggaw sin daga.” Et natongpal. ");
INSERT INTO kne_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nan-amag si Diyos si doway napigsa ay silaw. Din kapigsaan, siya di din agew, et say mansey-ang sin kaagawan, yan din maikadwa pay et din bowan ay say maningtinggaw sin labi. Inamag na abe din tatalaw. ");
INSERT INTO kne_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","In-amag na am-in dana ed daya ta tinggawan da din daga ");
INSERT INTO kne_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","sin kaagawan ya siya abe sin labi ta say maikasin din mapat-a ya din mabolinget. Et napnek sin nangilaana. ");
INSERT INTO kne_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Makdeng pay din labi yan kasin mapat-a, say maikap-at ay agew. ");
INSERT INTO kne_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Asi pag kanan Diyos, “Mawada di am-in ay kalasin di matago sin baybay ya din mantaytayaw abe ed daya.” ");
INSERT INTO kne_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Et say namarsuaan Diyos sin am-in ay kalasin di nigay ya odom ay manbeey sin baybay, pati din dadakke ya kaeegyat, ya am-in abe ay kalasin di titit ed daya. Idi inila na din pinarsua na ay sana, napnek sisya. ");
INSERT INTO kne_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Binindisyonanas daida ay mangwani, “Man-ganak kayo ta omad-ado kayo sin baybay ya sin daga.” ");
INSERT INTO kne_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Makdeng pay din labi yan kasin mapat-a, say maikalima ay agew. ");
INSERT INTO kne_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Pag kanan Diyos en mawada di am-in ay kalasin di parsua isnan lota, din matalaken ya atap ay animal, din mankodkodap ya manbodbodos, et natongpal. ");
INSERT INTO kne_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Inamag Diyos daida am-in, yan napnek sin nangilaana. ");
INSERT INTO kne_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Pag nan kanan, “Manparsua takos ipogaw ay kaman si datako ta say daida di makaoway sinan lobong ya din am-in ay parsua ay wadas na.” ");
INSERT INTO kne_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Et pinarsuan Diyos di ipogaw ay lalaki ya babai, yan kaman sisya met laeng di iso da. ");
INSERT INTO kne_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Binindisyonanas daida ay mangwani, “Man-ganak kayo ta omad-ado kayo ta mapno nan lobong. Makaoway kayo abe sin nigay ya titit ya amin abe ay parsua sinan labaw di daga. ");
INSERT INTO kne_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Din lames di kakaiw ya odom ay mais-is-ek et idawat ko en dakayo ta say kanen yo. ");
INSERT INTO kne_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Din kanen aben di titit ya am-in ay parsua ay mantee sin daga et din am-in ay kalasin di maata ay gomabay.” Et natongpal. ");
INSERT INTO kne_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Inilan Diyos am-in di pinarsua na yan napnenapnek sisya tan maptemapteng. Makdeng pay din labi yan kasin mapat-a, say maikan-em ay agew. ");
INSERT INTO kne_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Siya di san nakdengan di namarsuaan Diyos sin daga ya din am-in ay wadas di ya din am-in abe ay wada ed daya. ");
INSERT INTO kne_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Domateng pay din maikapito ay agew et say nan-ibbayan Diyos, tan enggay nakdeng din obla na. ");
INSERT INTO kne_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binindisyonana din agew ay nay et tinodingana ta mailasin sin odom ay agew, tan say nangisaldengana sin obla na ay namarsuas am-in. ");
INSERT INTO kne_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Naey pay di dad-at ay maipanggep sin naamag sin lobong ya din am-in ay wada ed daya idi nakdeng ay pinarsuan Diyos. ");
INSERT INTO kne_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Sin damo, maga pay laeng di mola ay ginmabay ya bin-i si sinmimit, tan maga pay laeng di pinawadan Diyos si odan. Maga abe di ipogaw si mangsokay isnan daga. ");
INSERT INTO kne_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ngem olay mo siya di ay maga di odan, wada pay dedan di danom ay mapmapo sin dallem ay say mamasas lota. ");
INSERT INTO kne_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Siya na di inyat Diyos ay nangamag sin ipogaw. Nan-as tapok et say pinke nas awak na. Pag nan isib-ok sin eng na din leng-ag ay mangidawat si biyag, et pag matago din ipogaw. ");
INSERT INTO kne_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Idi siya di, waday insaganan Diyos ay mayat ay daga ta panbeeyan din ipogaw ay inamag na. Din daga ay sana, wada ed Eden ay maibanda sin belaan di agew. ");
INSERT INTO kne_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Say nangipagabayan Diyos sin am-in ay kalasin di kaiw ay din mayat di boya na ya din makan abe di lames na. Sin gawan di daga ay sana, waday kaiw ay mo mangan di ipogaw sin lames na, matago das eng-enggana. Wada abey kaiw ay mo mangan das di et ammoan da din siged ya lawa. ");
INSERT INTO kne_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Din daga ed Eden ay sana, say nangipay-an Diyos sin ipogaw ay inamag na ta ay-ayowanana ay kosto. ");
INSERT INTO kne_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Tinogonas sisya ay nangwani, “Mabalin ay mangan ka sin am-in ay lames di kaiw ay wadas na ");
INSERT INTO kne_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","powira din esay kaiw ay pangammoam sin siged ya lawa, tan sin agew ay panganam sidi, sigurado ay makedngan ka ay matey yan maisian ka abe en sak-en.” ");
INSERT INTO kne_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Pag kanan Diyos si nemnem na, “Baken siged mo man-es-esa din lalaki ay nay. Man-amagak ngarud si kabadang na ay maibagay en sisya.” ");
INSERT INTO kne_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Asi na pay en alaen am-in ay animal ya titit ay inamag na sin lota et in-ey na sin lalaki ta ngadananas daida. Olay sino ay inpangadana en daida yan say ngadan da tet-ewa. ");
INSERT INTO kne_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Et say napoan di ngadngadan di am-in ay matalaken ya atap ay animal ya titit. Ngem magay mabalin si pan-ib-ib-an en Adan. ");
INSERT INTO kne_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Idi siya di, inpaseyep Diyos sisya. Idi naseseyep pay, kinaana di esay tadlang na, et pag nan iamag din lamlames sin nangaanana. ");
INSERT INTO kne_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","25","Asi na pay alaen din tadlang ay kinaana et nanbalinenas babai. Bomangon pay din lalaki, wada et din babai ay in-ey Diyos en sisya. Nakalabos da ay dowa, ngem adi da mabain. Kanan din lalaki, “Si naey pay di bagay ko, tan din tong-ak et tong-a na met laeng, ya din lamlames ko et lamlames na abe. Ngadanak sisyas babai, tan napo sin lalaki.” Say gapo na ay taynan di lalaki da ama na en ina na ta ibeey na din asawa na, et manbalin das es-esa. ");
INSERT INTO kne_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Asi et wada di eweg ay kasisikapan sin am-in ay atap ay pinarsuan Diyos. Waday esay agew, kanan din eweg sin babai, “Ay siya od ay inbagan Diyos ay maiparit ay mangan kayo sin olay sino ay lames di kaiw ay wadas na?” ");
INSERT INTO kne_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kanan din babai ay sinombat, “Inbagan Diyos ay mabalin ay mangan kami sin am-in ay lames di kaiw ");
INSERT INTO kne_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","powira din wada sin gawan di daga ay nay. Kanana en mo kanen mi di ono giwiten mi anggoy, matey kami.” ");
INSERT INTO kne_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Asi et kanan din eweg, “Ay siya mo matey kayo? ");
INSERT INTO kne_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Say inbagan Diyos sa en dakayo tan ammo na ay mo mangan kayos di, mais-o kayo en sisya, et ammoen yo din siged ya lawa.” ");
INSERT INTO kne_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Pag kasin isin-eng din babai din lames di kaiw ay doy. Siged ya mam-is di kailaana, dowan kananas nemnem na en siged ay kapoan di panlaingana, isonga nan-a sin lames di kaiw et kinana. Asi na indawtan si asawa na yan kinana abe. ");
INSERT INTO kne_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Idi kosto ay kinan da, inawatan da din napasamak en daida, yan dinlaw da ay nakalabos da. Nan-a da ngarud si bolong di kaiw ay igos et dinait da ta say panlingeb da sin awak da. ");
INSERT INTO kne_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Idi masmasdem pay, dinnge da ay manmandan si Diyos sin daga ay kad-an da, et intabonan da sin kakakkaiwan. ");
INSERT INTO kne_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Asi et kinalian Diyos din lalaki yan kanana, “Intoy kad-am?” ");
INSERT INTO kne_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Sinongbatan din lalaki, “Dinngek ay manmandan ka sin daga ay nay, et enak nantabon tan nakalabosak yan emegyatak en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kanan Diyos en sisya, “Intoy nangammoam ay nakalabos ka? Ay tan nangan ka sin lames di kaiw ay inparit ko en dakayo?” ");
INSERT INTO kne_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kanan din lalaki ay sinombat, “Din babai dedan ay in-alim en sak-en. Sisya di nangidawat sin lames di kaiw ay doy, et kinan ko.” ");
INSERT INTO kne_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Asi pag kanan Diyos sin babai, “Apay nga say inamag mo di?” Sinongbatan din babai, “Inmietek tomet din eweg, isonga kinan ko din lames di kaiw ay doy.” ");
INSERT INTO kne_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pag kanan Diyos sin eweg, “Maitken ka sin am-in ay parsua tan dosaek sik-a. Enggana sin kateyam, manbodbodos ka yan makiokmon moy lota. ");
INSERT INTO kne_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Manipod abe ed wani, man-ib-ibaw kayo sin babai ya siya abe sin ipoli yo. Katem din mokod di poli na, ngem din poli na pay et pis-itenan toktok mo.” ");
INSERT INTO kne_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kanan aben Diyos sin babai, “Aped na ay omad-ado di ligat mo, namnamed no man-anak ka, ngem aklongam pay dedan si asawam yan sisya di mangituray en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Asi kanan Diyos sin lalaki, “Gapo ta pinatim din asawam yan nangan ka sin inparit ko, lomawlawa din lota. Masapol ay manligat ka ay mangsokay ta way omanay si kanen yo enggana ay mapospos di biyag mo, ");
INSERT INTO kne_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","tan mawada di pagat ya am-in ay kalasin di lawlawa ay logam et mangan kayo sin owat gomabgabay ay mola. ");
INSERT INTO kne_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Katet-ewa na, masapol ay manling-et ka ay man-obla ta say waday kanen yo enggana ay mantaoli ka sin lota. Tan napo kas lota, et mo matey ka, lota met laeng di panbalinam.” ");
INSERT INTO kne_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","21","Makdeng pay ay inbaga na di, en nan-as kopkop di animal et inamag nas bado et inpabado na en daida. Et si Adan, nginadananas asawa na si Eva, tan sisya din napowakan di am-in ay ipogaw. ");
INSERT INTO kne_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Idi siya di kanan Diyos si nemnem na, “Nais-o din lalaki ya babai en datako, tan inammoan da din siged ya din lawa. Gapo ta say inyat da di, sigaak mo man-a da abe sin lames di kaiw ay mangidawat si biyag. Tan mo say kanen da di, matago da ay eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Isonga pag pakaanen Diyos daida sin siged ay daga ed Eden ta en da oblaen din lota, tan lota met laeng di inamag Diyos si awak di lalaki ed idi. ");
INSERT INTO kne_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Asi na ibaa di kaeegyat ay gogowardiya ay napod langit ta siliban da din segpan di daga ed Eden ay naibanda sin belaan di agew. Tinood na abe di man-ganggangab ya manposposipos ay kampilan sin segpan, et say manawsawad sin danan ay emey sin kaiw ay mangidawat si biyag ta maga polos di omasag-en. ");
INSERT INTO kne_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Pag siya di et nandaag da Adan en Eva ay asawa na et mawad-an sisya. Idi nan-anak pay, lalaki, et nginadananas Cain ay nangwani, “Binadangan Diyos sak-en ay mangipabelas lalaki.” ");
INSERT INTO kne_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Man-anak pay kasin, esa abe ay lalaki, et nginadanan das Abel. Idi nadakdake din sin-agi ay sana, nankinalasi di obla da. Si Abel di nangay-ayowan sin karnero da. Si Cain pay et nansamsama. ");
INSERT INTO kne_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Idi namingsan, nan-as Cain sin naom ay lames di inis-ek na et indatona en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Mo si Abel pay yan nanpilis malames ay besag di karnero, et indatona en Diyos din kamayatan ay parti na ay waday taba na. Idi inilan Diyos din indaton da ay sana, napnek en Abel ya din indatona, ");
INSERT INTO kne_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ngem adi napnek en Cain ya din indatona. Isonga palalo di bonget Cain yan manmimidoot. ");
INSERT INTO kne_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Asi et nginalat Diyos sisya yan kanana, “Apay nga manmimidoot kas bonget mo? ");
INSERT INTO kne_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mo doy ya kosto di inamag mo koma, inawat ko abe din indaton mo. Ngem gapo ta lawa din inamag mo, nakasaganas Satanas ay manolisog en sik-a kasin. Laydena ay awisen sik-a ay manbasol, isonga masapol ay abakem sisya.” ");
INSERT INTO kne_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Idi siya di, nakingalat si Cain sin iyogtana ay si Abel yan kanana, “En ta sin dontog.” Idi nadipos da, binigla na ay pinse din iyogtana. ");
INSERT INTO kne_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Siya pay di kanan Diyos en Cain, “Intoy kad-an iyogtan mo ay si Abel?” “Toan adi. Ay tan sak-en od di makaammo en sisya?” kanana. ");
INSERT INTO kne_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Asi et kanan Diyos, “Apay nga say inamag mo di? Inilak din dadan iyogtan mo ay inmayos sin lota, yan kaman mankedaw ay maibaes. ");
INSERT INTO kne_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Isonga din lota met laeng di kapoan di dosam, tan sinepsepana din dadan iyogtan mo. ");
INSERT INTO kne_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Manipod ed wani, mo way is-ek mo sin lota et matiltil ya manngidngid. Pilit abe ay lomikeliked kas owaoway sinan daga, tan mamaga di kosto ay ilim.” ");
INSERT INTO kne_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Idi dinngen Cain din inkeddeng Diyos ay dosa na, kanana, “Adiak kaya din dosa ay sana, tan nalabes ay madagsen. ");
INSERT INTO kne_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nay et ay omipakaan ka sin lota, yan maisianak abe en sik-a. Maga abe di kosto ay ilik, mo adi lomikelikedak si owaoway sinan daga. Mo wada pay di mangabet en sak-en, pomse da.” ");
INSERT INTO kne_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","“Aga met a,” kanan Diyos, “tan mo way mamse en sik-a, maibaes si biyag di pito ay ipogaw.” Et minalkaanas Cain ta adi peslen di mangabet en sisya. ");
INSERT INTO kne_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Pag komaan si Cain sin kad-an Diyos et inmey ed Nod ay esay ili ay naibanda sin belaan di agew mo ed Eden. ");
INSERT INTO kne_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Idi siya di, nangasawa si Cain et nan-anak da si lalaki ay nginadanan da si Enok. Pag man-amag sisya si siyodad, et inngadana din ngadan di anak da ay si Enok sin siyodad ay doy. ");
INSERT INTO kne_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nangasawa abe si Enok et waday anak na ay manngadan si Irad ay say aman en Mehujael. Si Mehujael et sisya di aman en Metusael ay say nangin anak en Lamek. ");
INSERT INTO kne_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Dowa di asawan Lamek ay da Ada en Zilla. ");
INSERT INTO kne_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","In-anak Ada si Jabal ay say nangipoli si mantaltalaken si animal ya manbebbeey si tolda. ");
INSERT INTO kne_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Si Jubal din iyogtan Jabal ay nangipoli si omaayam si gitara ya tongali. ");
INSERT INTO kne_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Inmanak abe si Zilla et nangadanan si Tubal Cain, et sisya abe di nangipoli si manpanpanday si nankakalasi ay laminta ay bronsi ya landok. Wada di agin Tubal Cain ay babai ay manngadan si Naama. ");
INSERT INTO kne_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Sin namingsan, inayagan Lamek din dowa ay asawa na yan kanana en daida ay nangikanta, “Dakayo ay asawak ay da Ada en Zilla, dengngen yo kod nan enak ikanta. Waday nanakit en sak-en ay baro, et pinsek ay inbaes ko. ");
INSERT INTO kne_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si Cain, mo waday mamse en sisya, maibaes si biyag di pito ay ib-a, ngem si sak-en pay et mo pomse da, pitopolo ya pito di matey. Siya man sa.” ");
INSERT INTO kne_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Idi nan-anak kasin da Adan si esa ay lalaki, kanan asawa na, “Indawtan Diyos sak-en si anak ay lalaki ta waday maiskat en Abel ay pinsen Cain.” Siya di et nginadanana si Set din anak na ay doy. ");
INSERT INTO kne_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Idi nangasawa si Set et doy bemela din anak da, nginadanana si Enos. Din timpo ay doy et say nangilogian di ipogaw ay mangosal sin ngadan Diyos sin panaydayawan da en sisya. ");
INSERT INTO kne_vpl VALUES ("GN5_1a","002_5_1a","GEN","5","1a","1a","Naey di listaan di polin Adan. ");
INSERT INTO kne_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Idi nantawen si Adan si 130, binmala di anak na ay is-iso na, et nginadananas Set. ");
INSERT INTO kne_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Natago pay laeng si Adan si 800 ay tawen yan waday odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Idi waday 930 ay tawena, natey. ");
INSERT INTO kne_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Si Set abe, idi nantawen si 105, binmala di anak na ay si Enos. ");
INSERT INTO kne_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Makdeng di, natago pay laeng si Set si 807 ay tawen yan waday odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Asi matey ay mantawen si 912. ");
INSERT INTO kne_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Idi mantawen pay si Enos si 90, binmala di anak na ay si Kenan. ");
INSERT INTO kne_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nanbiyag pay laeng si Enos si 815 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Idi waday 905 ay tawena, natey. ");
INSERT INTO kne_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Idi mantawen abe si Kenan si 70, naianak si Mahalalel. ");
INSERT INTO kne_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Makdeng di, natago pay laeng si Kenan si 840 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Asi matey ay mantawen si 910. ");
INSERT INTO kne_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Idi mantawen pay si Mahalalel si 65, naianak si Jared. ");
INSERT INTO kne_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Makdeng di, nanbiyag pay laeng si Mahalalel si 830 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Asi matey ay mantawen si 895. ");
INSERT INTO kne_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Idi mantawen pay si Jared si 162, naianak si Enok. ");
INSERT INTO kne_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Makdeng di, natago pay laeng si 800 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Asi matey ay 962 di tawena. ");
INSERT INTO kne_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Idi 65 di tawen Enok, naianak si Metusela. ");
INSERT INTO kne_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nanipod sidi, siged di pakikadkadwaana en Diyos si 300 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Idi mantawen si 365, ");
INSERT INTO kne_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","makikadkadwa pay laeng en Diyos, et namaiwed, tan inan Diyos sisya. ");
INSERT INTO kne_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Idi mantawen pay si Metusela si 187, naianak si Lamek. ");
INSERT INTO kne_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Manipod sidi, natago pay laeng si Metusela si 782 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mantawen sisya si 969, asi matey. ");
INSERT INTO kne_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Idi nantawen pay si Lamek si 182, binmala di anak na ay lalaki, ");
INSERT INTO kne_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","et nginadananas Noe ay nangwani, “Din anak ay nay, palaglag-anena din ligat tako ay mangobla sin lota ay inpalawlawan Diyos.” ");
INSERT INTO kne_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Manipod sin naianakan Noe, natago pay laeng si Lamek si 595 ay tawen yan wada abey odom ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Asi matey ay mantawen si 777. ");
INSERT INTO kne_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Si Noe pay, idi enggay nantawen si 500, asi man-ganak si tolo ay lalaki ay da Sem en Ham ya si Jafet. ");
INSERT INTO kne_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Idi siya di, inmad-ado di ipogaw sinan daga yan inmad-ado abe din anak da ay babai. ");
INSERT INTO kne_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Idi inilan di anan-ak di Diyos din kinabasang di babbabai ay sana, nanpili das layden da ay asawaen. ");
INSERT INTO kne_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Asi et kanan Diyos, “Adi anosan din Ispiritok san iyat di ipogaw ay eng-enggana, tan owat dan ipogaw dedan, isonga mo emey di sin-gasot ya dowanpo ay tawen, pap-engek din panbiyagan das nan daga.” ");
INSERT INTO kne_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Sin siya di ay timpo ay nandaagan di anan-ak di Diyos ya din inasawa da ay babbabai yan sin omon-onod ay tawen abe, say binmelaan di ipogaw ay palalo ay dadakke. Din ipogaw ay sana et ad-adoy naidaddad-at ay maipanggep sin inam-amag da ed nabaon. ");
INSERT INTO kne_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Idi inilan Diyos ay palalo ay lawlawa di am-amagen di ipogaw ya lawa abe di nemnemnemen das kankanayon, ");
INSERT INTO kne_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","mansakit di nemnem na yan manbabbabawi ay namarsuas ipogaw sinan daga. ");
INSERT INTO kne_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yan kanana, “Dosaek din ipogaw ay sana ay pinarsuak, pati din animal ya titit, ta maga di mabay-an isnan labaw di daga, tan nay et ay manbabawiak ay namarsua en daida.” ");
INSERT INTO kne_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ngem napnek pay si Diyos en Noe. ");
INSERT INTO kne_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Naey di dad-at ay maipanggep en sisya. Waday toloy anak Noe ay lalaki ay da Sem en Ham ya si Jafet. Sin doy ay timpo, eng-enggay na si nalinteg ay ipogaw ay magay nankolangana. Siged abe di pakikadkadwaana en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mo din odom pay ay ipogaw, peteg ay lawa di ogali da sin pangilan Diyos yan masepsep ay mandinadael da. ");
INSERT INTO kne_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Idi inilan Diyos ay pag lawa di am-amagen di ipogaw, ");
INSERT INTO kne_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","kanana en Noe, “Ninemnem ko ay gedngan di biyag di am-in ay ipogaw, tan enggay napno nan lobong si lawa ay inam-amag da. Awni et dadlonak dosaen daida pati din lobong. ");
INSERT INTO kne_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Man-amag ka ngarud si dakdake ay daong ono bapor ay ad-adoy kowarto na. Makneg ay tabla di iamag mo. Asi ka allidan si niket sin nanbinas-il. ");
INSERT INTO kne_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Din kadakdake na pay et 450 ay piya di kaando na, 75 ay piya di kaannawa na, ya 45 ay piya di kakayang na. ");
INSERT INTO kne_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Amagem si toloy galado yan atpam ya taangam si 18 ay polgada. Man-amag ka abes pantew sin dingding na. ");
INSERT INTO kne_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Say iyat mo di, tan awni et lebngek din lobong et matey am-in di waday leng-ag na sin labaw di daga. ");
INSERT INTO kne_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ngem mo sik-a pay, waday ikarik en sik-a. Mo makdeng din daong ay sana, senggep kayo ay sin-asawa pati din an-ak yo ya din as-awa da. ");
INSERT INTO kne_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ipasgep yo abe di manparis sin am-in ay kalasin di animal ya mantaytayaw, pati manbodbodos ya mankodkodap, ta way iyat da ay matago. ");
INSERT INTO kne_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Man-olnong kayo abe si am-in ay kalasin di makan et ipenpen yo sin daong ta way kanen yo ya kanen aben di animal ya titit ay sana.” ");
INSERT INTO kne_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Siya sa di inbilin Diyos en Noe, et tinongpal na am-in. ");
INSERT INTO kne_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Idi makdeng pay din daong, kanan Diyos en Noe, “Senggep kayo am-in ay pamilya, tan sik-a anggoy di ammok sin labaw di daga ay nalinteg di ogali na. ");
INSERT INTO kne_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ipasgep yo abe di manparis sin am-in ay kalasin di animal ay maibilang ay kadodogis. Mo din maibilang ay nalinis pay, ipasgep yo di sagpipito ay manparis. ");
INSERT INTO kne_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Siya abe sin am-in ay kalasin di titit, ipasgep yo di sagpipito ay manparis. Say iyat mo di ta way iyat da am-in ay man-ganak ya maad-ado kasin isnan daga. ");
INSERT INTO kne_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tan mo emey di pito ay agew, ibaak di odan, et iweswes na ay mandeges si opatapolo ay agew ya labi enggana ay malned am-in ay pinarsuak isnan labaw di daga.” ");
INSERT INTO kne_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Say inbagan Diyos di, et inamag Noe amin di naitogon en sisya. ");
INSERT INTO kne_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Enem ay gasot di tawen Noe sin sinenggepana sin daong. ");
INSERT INTO kne_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Daida ay sin-asawa ya din an-ak da ay da Sem en Ham ya si Jafet ya din as-awa da et sinenggep da am-in ta way iyat da ay mangilsot sin lebeng. ");
INSERT INTO kne_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Inmey abe sin kad-an da Noe di manparis ay am-in ay kalasin di animal ya titit, pati manbodbodos ya mankodkodap, waday maibilang ay nalinis, wada abey kadodogis, ");
INSERT INTO kne_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","et nakisgep da am-in, tan siya met laeng di inbilin Diyos. Et asi pag in-eb Diyos. ");
INSERT INTO kne_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Malabas pay di pito ay agew, dinmateng tet-ewa din lebeng. ");
INSERT INTO kne_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Naitompong sin pitsa 17 di maikadwa ay bowan sin maikan-em ay gasot ay tawen Noe. Sin siya di ay agew, binomtak din poon di obbog ya ginawang et kabela am-in di danom sin oneg di daga. Kabokat abes Diyos sin kad-an di danom ed kayang ");
INSERT INTO kne_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","et logiana ay mandeges. ");
INSERT INTO kne_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ngem mo da Noe pay, laton ay sinesenggep da am-in ay pamilya sin daong, ");
INSERT INTO kne_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","16","pati am-in ay kalasin di animal ya titit ay inbilin Diyos, ay din maayew ya din atap, din dadakke ya din kinittoy ay lalaki ya babai. ");
INSERT INTO kne_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Intoltoloy din odan ay dinmegedeges si opatapolo ay agew ya labi dowan dinmakdake din danom enggana ay tomay-apew din daong. ");
INSERT INTO kne_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Intoltoloy din danom pay laeng ay domakdake et tinmay-atay-apew din daong sin labaw di danom. ");
INSERT INTO kne_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Neyneyna et nalim-otan am-in di kakayangan ay dontog ");
INSERT INTO kne_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","enggana ay nasurok ay opat ay depa di kalosong di danom sin kayang di dontog ay sana. ");
INSERT INTO kne_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Et nalned am-in di ipogaw ya am-in abe ay animal ya titit isnan labaw di daga. ");
INSERT INTO kne_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Olay sino ay manlengleng-ag et natey, ");
INSERT INTO kne_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","tan dinosan Diyos daida. Din naipowira anggoy et da Noe ya din naitapi en daida sin daong. ");
INSERT INTO kne_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Et kinmakaman din lebeng sin daga si sin-gasot ya limapolo ay agew. ");
INSERT INTO kne_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Idi siya di, laton ay ninemnem Diyos da Noe ya am-in ay animal ay nakisgep en daida sin daong. Yan inbaa nay napigsa ay dagem ta madageman din daga. ");
INSERT INTO kne_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pintet aben Diyos din bemelbelaan di danom sin oneg di daga yan inpasaldeng na abe din odan. Et pag ilogin din danom ay matyadan. ");
INSERT INTO kne_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Idi nalabas di sin-gasot ya limapolo ay agew, binmaba din danom ");
INSERT INTO kne_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","enggana ay sinmeeng din daong sin esay dontog sin kadondontogan ed Ararat. Say naamag di sin pitsa 17 di maikapito ay bowan. ");
INSERT INTO kne_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Neyneyna matmatyadan din danom enggana ay nabonsian din toktok di dontog sin omona ay agew di maikasinpo ay bowan. ");
INSERT INTO kne_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Makdeng abe di opatapolo ay agew, binokatan Noe din inamag na ay tawa ");
INSERT INTO kne_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","et inbolos nay gayang. Din gayang ay sana et adi nantattaoli sin daong mo adi et oway di in-inmeyana engganas namgaan din daga. ");
INSERT INTO kne_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Inbolos na abey kalapati ta say pangammoana mo binmaba din danom, ");
INSERT INTO kne_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ngem gapo ta deda ay nanalbeng din daga yan maga di dintenganas ompaana, nantaoli sin daong. In-adawan Noe din takkay na ta say ompaan din kalapati et inpasgep na kasin. ");
INSERT INTO kne_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nanseed pay laeng si pito ay agew, asi na kasin pabelaen. ");
INSERT INTO kne_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Malablabi pay, nantaoli ay nangidateng si kapotpoting na ay tobon di kaiw ay olivo. Et say nangammoan Noe ay enggay binmaba din danom sin daga. ");
INSERT INTO kne_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Idi inmey abe di pito ay agew, inbolos na kasin din kalapati, ngem adi nantaoli. ");
INSERT INTO kne_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Idi wada pay di enem ay gasot ya esay tawen en Noe sin omona ay agew di damo ay bowan, enggay natdok din danom sin labaw di daga. Kinaan Noe din odom ay atep din daong ta way iyat na ay mangisin-eng ay kosto, et inila na ay mammamgaan din lota. ");
INSERT INTO kne_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sin pay pitsa 27 di maikadwa ay bowan, enggay namgaan din daga, ");
INSERT INTO kne_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","et kanan Diyos en Noe, ");
INSERT INTO kne_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Bomala kayo am-in sin daong, dakayo ay sin-asawa ya din aan-ak yo ya din asawa da. ");
INSERT INTO kne_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pabelaen yo abe am-in ay titit ya animal ta say mansisian da ya man-anak da ta way iyat da ay omad-ado kasin sin daga.” ");
INSERT INTO kne_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Siya di et binmela da Noe ay sinpamilya, ");
INSERT INTO kne_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","yan siya abe din animal ya titit ay nakitettee en daida sin daong et nankokoyog da insigon sin kalasi da. ");
INSERT INTO kne_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Idi siya di, nan-amag si Noe si altar. Pag man-as saes-a sin am-in ay kalasin di animal ya titit ay maibilang ay nalinis et pinooana sin altar ay sana ay mangidaton en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Idi sinongsong Diyos din seng-ew di indaton Noe en sisya, kananas nemnem na, “Laton, adiak kasin dosaen din daga begew sin amagen di ipogaw, tan ammok ay lawlawa pay dedan din nemnemnemen da manipod sin kakitkittoy da. Isonga adiak ipidpidwa ay dosaen din am-in ay manlengleng-ag ay kaman din inyat ko ed wani. ");
INSERT INTO kne_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Engganas deda nan lobong, wada di pinag-eesek ya pinag-aani, omatongana ya temeg-inana, deam ya tiyagew, ya din kaagawan ya labi.” ");
INSERT INTO kne_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Binindisyonan Diyos si Noe ya din an-ak na ay mangwani, “Man-ganak kayo ta omad-ado kayo kasin isnan lobong. ");
INSERT INTO kne_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Manipod ed wani, emegyat en dakayo am-in ay kalasin di atap ay animal, pati manbodbodos ya mankodkodap ya am-in abe ay mantaytayaw ed daya ya mantettees baybay, tan idawat ko en dakayo di lebbeng ay mangituray en daida. ");
INSERT INTO kne_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Manipod ed wani abe, mabalin ay isida yo di olay sino en daida ay kaman din in-inyat yo ay mangan sin kompormi ay gomabgabay, tan ipalobos ko ay mangan kayo sin am-in. ");
INSERT INTO kne_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Din iparit ko anggoy ay isida yo et din karni ay deda pay laeng di dada na, tan din dada et say kad-an di biyag na. ");
INSERT INTO kne_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","“Nabanol abe di biyag yo ay ipogaw, tan inamag kos dakayo ay mais-o en sak-en met laeng. Isonga mo sinoy manpeses ipogaw, keddengak ay man-ikaro, tan mo waday animal ay manpeses ipogaw, dosaek ta say kateyana. Mo wada abey ipogaw ay manpeses ib-a na, ipogaw met laeng di mamse en sisya. ");
INSERT INTO kne_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Isonga adi kayo manpespese mo adi et man-ganak kayo ta way iyat yo ay omad-ado yan maiwaras kayo isnan daga.” ");
INSERT INTO kne_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kanan aben Diyos en Noe ya din an-ak na, ");
INSERT INTO kne_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Wada di ikarik en dakayo ya din ipoli yon to. ");
INSERT INTO kne_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Mailak-am abe am-in ay parsua ay nakibela en dakayo sin daong. ");
INSERT INTO kne_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Din ikarik en dakayo et siya na. Manlogi ed wani, adiak kasin lebngen nan daga ta malned amin ay matmatago ya madadael am-in din wadas na. ");
INSERT INTO kne_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","“Din pangammoan yo ay komakaman si eng-enggana nan inkarik en dakayo ya sin am-in abe ay parsua ");
INSERT INTO kne_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","et waday ipeey ko ay badkong ono abonga ed kayang, ta say sinyal di inkarik ay nay. ");
INSERT INTO kne_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Siya di, basta waday ipadateng ko ay liboo ed kayang yan maila di badkong sidi, ");
INSERT INTO kne_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","17","ilaek abe yan nemnemek din inkarik en dakayo ya am-in abe ay matmatago ay maga kasin di lebeng ay kateyan di am-in ay matmatago. Siya adi di sinyal di inkarik en dakayo ya sin am-in abe ay parsua.” ");
INSERT INTO kne_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Da naey di anak da Noe ay binmela sin daong, da Sem en Ham ya si Jafet. (Din si Ham ay nay et say nangipoli en Canaan.) ");
INSERT INTO kne_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Din toloy anak na ay nay et daida di napowakan di am-in ay ipogaw isnan labaw di daga. ");
INSERT INTO kne_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Si Noe et say damo ay mantaltalon ay nan-esek si obas. ");
INSERT INTO kne_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Idi namingsan, nabeteng sin ininom na ay danom di obas ay naamag si arak. Siya et di nanlalabos ay naseyep sin beey da ay tolda. ");
INSERT INTO kne_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Idi inilan Ham ay aman Canaan ay nanlalabos si ama da, kabela et ena ibaga sin aag-i na. ");
INSERT INTO kne_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Pag et man-as da Sem en Jafet si nagayad ay bado et igaley da en ama da. Nanbindayangan da ay insasampay da sin padanga da. Pag dan mansansanod ay sinenggep sin beey da ay nangaley en ama da ta say adi da ilaen sisya ay nanlalabos. ");
INSERT INTO kne_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Idi naimosngan si ama da yan inammoana din inamag Ham ay say anongos ay anak na, ");
INSERT INTO kne_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","kanana, “Awni man et madosa si Canaan ya manbalin ay kababaan ay bag-en di aag-i na. ");
INSERT INTO kne_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","27","Ngem sapay koma ta madaydayaw si Diyos ay din Diyos en Sem. Paannawaen koma aben Diyos din dagan Jafet ya makilak-am koma sin bindisyon ay gon-oden Sem. Siya man et maibag-en si Canaan en daida ay dowa.” ");
INSERT INTO kne_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nanipod sin nanlebngan Diyos sin daga, natago si Noe si 350 ay tawen pay laeng. ");
INSERT INTO kne_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Indasana di 950 ay tawen, asi matey. ");
INSERT INTO kne_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Idi siya di, es-esa di kalin di am-in ay ipogaw isnan daga. ");
INSERT INTO kne_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Idi manbiyahi da pay ay emey sin kad-an di belaan di agew, waday dinatngan da ay annawa ay tanap ed Sinar et nan-ili das di. ");
INSERT INTO kne_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Idi namingsan, nanngangalat da yan kanan da, “En tako mandamilis linang ta way amagen tako si beey tako.” Et say inyat da di. Inset da ay nangioto sin linang ta komenteg, et aspalto abe di inpakpak da. ");
INSERT INTO kne_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Asi da kanan, “Man-amag tako et si siyodad ay way beey ay omdas ed daya ta say madayaw tako ya adi tako mansisian sin labaw di daga.” ");
INSERT INTO kne_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Osdongan pay Diyos din siyodad ya din nakayang ay beey ay am-amagen da, ");
INSERT INTO kne_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","kanana, “Mo say iyat da sa ed wani tan es-esay nemnem ya kali da, maga di adi da kabaelan sin tapin di agew. ");
INSERT INTO kne_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","En tako ngarud isdi ta pankinalasien tako di kali da ta say adi da mankinaawatan.” ");
INSERT INTO kne_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Et say inamag Diyos di, et pag mansisian din kaipoipogaw sin labaw di daga yan adi da intoloy ay nangamag sin siyodad ay doy. ");
INSERT INTO kne_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Say begew ay nginadanan da din ili ay doy si Babel ono Babilonia, tan say nangipankinalasian Diyos sin kalin di ipogaw. Et nanlogi isdi, enggay naiwarawaras da sin intiro ay lobong. ");
INSERT INTO kne_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Si Tera et say aman da Abram en Nahor ya si Haran. Si Haran pay di aman Lot. ");
INSERT INTO kne_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Asi et natey si Haran sin ili na ay Ur ay sakop di Babilonia idi deda pay laeng si ama na. ");
INSERT INTO kne_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nakiasawa abes da Abram en Nahor. Din asawan Nahor et si Milca ay pangpangoan Isca ay anak Haran, yan din asawan Abram et si Sarai. ");
INSERT INTO kne_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Asi et maga di anak da Abram, tan basig din asawa na. ");
INSERT INTO kne_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Idi namingsan, inayagan Tera din anak na ay si Abram ya din apo na ay si Lot ay anak en Haran ya din innapo na ay si Sarai ay asawan Abram, et kinmaan da ed Ur ay sakop di Babilonia ta emey da koma ed Canaan. Ngem idi sinmawang da ed Haran, nan-ili das di. ");
INSERT INTO kne_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Et say ili ay nateyan Tera idi nantawen si 205. ");
INSERT INTO kne_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Waday esay agew, kanan Diyos en Abram, “Taynam din ilim ya toton-od mo ta emey ka sin ili ay itdok en sik-a. ");
INSERT INTO kne_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Paad-adoek to din polim ta manbalin das madayaw ya napigsa ay nasyon. Bindisyonak sik-a abe si amin ay pansigdan, et madamag di ngadan mo isnan daga ta say sik-a abe di kapoan di bindisyon di odom. ");
INSERT INTO kne_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Din mangamag si siged en sik-a et bindisyonak, ngem din manglaslasoy pay en sik-a et dosaek. Begew abe en sik-a, mabindisyonan di kaipoipogaw sin am-in ay ili.” ");
INSERT INTO kne_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Sin nangwanian Diyos sidi, pitopolo ya lima di tawen en Abram. Pinati na din inbilin Diyos et kinmaan ed Haran. ");
INSERT INTO kne_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Inkoyog na si asawa na ay si Sarai ya din kaanakana ay si Lot ya am-in abe din bag-ena ya din gamgameng na ay emey ed Canaan. Idi sinmawang das di, ");
INSERT INTO kne_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","nandad-an da enggana ed Sekem sin kad-an di inayan ay kaiw en More. Din kaiw ay nay di panaydayawan din taga-Canaan ay man-ili pay laeng isdi sin didiyosen da. ");
INSERT INTO kne_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Say nanpailaan Diyos en Abram yan kanana, “Si naey din daga ay idawat ko sin polim.” Pag mantopog si Abram si bato et man-amag si altar ay pangidatonanas animal en Diyos ay nanpaila en sisya. ");
INSERT INTO kne_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Idi siya di, komaan da Abram sidi et manpaabagatan da engganas domateng da sin kadondontogan sin nan-gawaan di Betel ya Ai. Nankampo das di si nabaybayag, et nan-amag kasin si Abram si altar, et nankararag en Diyos sidi. ");
INSERT INTO kne_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Asi manlobwat kasin da Abram et man-etaetan da ay manpaabagatan ed Negev ay wada sin sakop di Canaan met laeng. ");
INSERT INTO kne_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Domteng pay di betil ed Canaan, intoloy da ay nanpaabagatan ay emey ed Egipto ta mantetee das di si mabaybayag, tan enggay nasepsep din betil ed Canaan. ");
INSERT INTO kne_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Idi nganngani ay domateng da ed Egipto, kanan Abram en asawa na ay si Sarai, “Mapmapteng ka kayman ay babai. ");
INSERT INTO kne_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Adi pay mo ilaen daka sin taga-Egipto, kanan da en sin-asawa ta et pomse da ta asi daka asawaen. ");
INSERT INTO kne_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Isonga ibagam ay sin-iyogtan ta ta balbalang adi da pomse mo adi et mayat di iyat da en sak-en begew en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Idi dinmateng da pay ed Egipto, inilan tet-ewa din omili ay peteg ay mapteng si Sarai. ");
INSERT INTO kne_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Et din odom ay oopisyal di ari, init-ek da din kinapintas na sin ari. Isonga inpaayag na ta maitapi sin kabebbeey na. ");
INSERT INTO kne_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Manbegew en sisya, siged di inyat di ari en Abram et indawtanas ad-ado ay karnero, kalding, baka, dangki, kamel, ya bag-en. ");
INSERT INTO kne_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Asi et pinaligat Diyos si kaeegyat ay sakit din ari ya am-in da ay bemebeey begew en Sarai ay asawan Abram. ");
INSERT INTO kne_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Isonga inpaayag din ari si Abram yan kanana en sisya, “Apay nga adim inbaga ay sin-asawa kayo? ");
INSERT INTO kne_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Apay nga inbagam anggoy ay sin-agi kayo et intolok mo ay ibeey kos sisya? Naey si asawam. Ayagam ta komaan kayo damdama!” ");
INSERT INTO kne_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Et inbilin din ari sin sosoldado na ta itlod das daida sin beddeng di ili. Siya di kinmaan da Abram ay sin-asawa et intakin da abe din am-in ay gamgameng da. ");
INSERT INTO kne_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Sin kad-an da Abram ed Egipto, enggay binmaknang sisyas karnero, kalding, baka, palata, ya balitok. Sin kinmaanana pay sidi, nantaoli ed Negev sin abagatan di Canaan ay nangitakin en asawa na ya am-in di gamgameng na. Nakeey abe din kaanakana ay si Lot. ");
INSERT INTO kne_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Manipod ed Negev, intoltoloy da ay manpatongdo ay nansepsepad sin inil-ili engganas domateng da sin nankampoan da ed idi ay nan-gawaan di Betel ya Ai. ");
INSERT INTO kne_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Say kad-an abe di inamag Abram ay altar ed idi, isonga idi sinmawang das di, nandayaw si Abram en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Si Lot pay et ad-ado abey baka, karnero ya kalding na. Wada abey pamilya na ya babag-ena. ");
INSERT INTO kne_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Siya di mankolang din panpastolan das animal da tan nankoykoyog da ay dowa. ");
INSERT INTO kne_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Et say nan-iibawan din panpaspastolen da ay dowa. Wada abe di Canaaneo ya Perezeo ay man-ilis di. ");
INSERT INTO kne_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Idi siya di, inayagan Abram si Lot yan kanana en sisya, “Adi koma man-iibaw din babag-en ta, tan sin-ama ta damdama. ");
INSERT INTO kne_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Piliem ngarud din laylaydem ay daga ta mansian ta. Mo sin kannigid di emeyam, emeyak abe sin kannawan. Mo din kannawan pay di piliem, emeyak abe sin kannigid.” ");
INSERT INTO kne_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tamangen pay Lot din nandinmang ay daga, inila na ay maymayat din nanbinas-il di ginawang ay Jordan engganad Zoar, tan nabaknang si danom ay kaman din siged ay daga ed Eden ono ed Egipto. Tan daan pay laeng dosaen Diyos din ili ay Sodoma ya Gomorra ay wadas di. ");
INSERT INTO kne_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Isonga say pinili na din intiro ay mapteng ay tanap ed Jordan. Tinaynan das Abram et inmey da sin patag di belaan di agew. ");
INSERT INTO kne_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","13","En da nakiili sin ipogaw sidi sin tanap, et in-amag dan tolda ay pankampoan da sin asag-en ed Sodoma ay ilin di lawlawa ay ipogaw ay ad-adoy basol da en Diyos. Da Abram pay et nantetee da sin sakop di Canaan. ");
INSERT INTO kne_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Idi kinmaan da Lot, kanan Diyos en Abram, “En ka mantamang ed amyanan ya ed abagatan ya sin belaan di agew ya siya abe sin diposan di agew. ");
INSERT INTO kne_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tan am-in ay matamang mo et idawat ko en sik-a ya din polim ta say daga yo si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Paad-adoek abe din polim si kaman din tapok ay adi kabilang. ");
INSERT INTO kne_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","En ka ngarud mandan sin intiro ay daga ay sana ta boyaem, tan idawat ko am-in en sik-a.” Say inkarin Diyos en Abram. ");
INSERT INTO kne_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Et pag komaan da Abram sidi et man-etan da ed Hebron ay asag-en sin inayan ay kakaiw en Mamre. Et say nangamaganas esa ay altar ay pangidatonanas animal en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Et pinos da Kedorlaomer am-in din makan ya odom ay gamgameng ed Sodoma ya Gomorra et intagtag da. ");
INSERT INTO kne_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Intagtag da abe din kaanakan Abram ay si Lot ya din gamgameng na, tan ed Sodoma met laeng di nan-iliana. ");
INSERT INTO kne_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Idi siya di waday linmayaw ay en nangisodsod si am-in en Abram ay din Hebreo ay mantetee sin asag-en di inayan ay kakaiw en Mamre. Din si Mamre ay sana ya din ag-i na ay da Escol en Aner et Amorreo da. Nakigait da am-in en Abram. ");
INSERT INTO kne_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Idi inammoan Abram ay nakidpap da din kaanakana ay si Lot, inayagana din nabayag ay babag-ena ay nalaing ay makigobat ta en da atikoen din nangitagtag en sisya. Tolon gasot ya sinpo ya wao da am-in. Inatiko das daida enggana ay indasan da ed Dan. ");
INSERT INTO kne_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Asi godwaen Abram din ipogaw na et senggep da sin kad-an da Kedorlaomer sin labi et inabak das daida. Inatiko da enggana ed Hoba ay amyanan di Damascus, ");
INSERT INTO kne_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","et insalakan das Lot ya din odom ay ipogaw ay intagtag da Kedorlaomer, pati babai ya lalaki. Tinaoli da abe am-in din naakew ay gamgameng. ");
INSERT INTO kne_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Idi somaa pay da Abram ay napo sin nangabakan da en da Kedorlaomer ya din iib-a na ay aari, en inabat din ari ed Sodoma sin tanap ed Save ay kanan da abe en Tanap di Ari. ");
INSERT INTO kne_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Wada abes Melkizedek ay ari ed Salem ay en nangabet en da Abram ay nangitakin si makan ya inom para en sisya. Gapo ta sisya din padin di Kangatoan ay Diyos, ");
INSERT INTO kne_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","binindisyonanas Abram ay nangwani, “Sapay koma ta bindisyonan daka sin Kangatoan ay Diyos ay namarsua ed daya ya sin daga. ");
INSERT INTO kne_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Sapay koma abe ta madaydayaw si owaoway din Kangatoan ay Diyos ay namadang en sik-a ay nangabak sin kaibaw mo.” Asi pag idawat Abram en sisya din inkasinpon di gamgameng ay tinaoli na. ");
INSERT INTO kne_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Asi komali din ari ed Sodoma yan kanana en Abram, “Olay mo okaem amin din gameng, basta itaolim anggoy din ipogaw ko.” ");
INSERT INTO kne_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kanan Abram ay sinombat, “Isapatak en Yahweh, din Kangatoan ay Diyos ay namarsua ed daya ya sin daga, ");
INSERT INTO kne_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ay maga polos di alaek sin gameng mo, olay owat sinolid ono iket di sinilas tan into et ya kanam en sik-a di nangipabaknang en sak-en. ");
INSERT INTO kne_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Isonga maga polos di alaek powira din kinan anggoy di ipogaw ko ya din bingay di iib-ak ay nay ay da Aner en Escol ya si Mamre.” ");
INSERT INTO kne_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Idi nakdeng amin dadi, waday inpailan Diyos en Abram ay kaman iitaw, yan dinnge nas Diyos ay mangmangwani, “Ay Abram, adi ka emeg-egyat, tan salaknibak sik-a sin am-in ay kaeegyat. Dakdake abe di gon-gona ay idawat ko en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Kanan pay Abram, “Aw ay Kangatoan ay Diyos, ngem sino ngin di pansigdak, tan nay et ay maga pay laeng di indawat mo ay anak ko, yan din bag-en ko anggoy ay si Eliezer ay taga-Damascus di manawid sin am-in ay gameng ko.” ");
INSERT INTO kne_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Asi et kanan Diyos, “Baken si sana di manawid sin gameng mo, mo adi et din kosto ay anak mo.” ");
INSERT INTO kne_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Asi na ibala si Abram yan kanana, “Tangadem ed daya yan bilangem din talaw mo kabaelam, tan say kaad-adon di bilang di polim.” ");
INSERT INTO kne_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Et dadlon pinatin Abram din kanan Diyos, isonga inbilang Diyos ay nalinteg sisya. ");
INSERT INTO kne_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Pag kanan Diyos en sisya, “Sak-en si Diyos ay nangipango en sik-a ay komaan ed Ur ay sakop di Babilonia ta idawat ko en sik-a din daga ay nay ta say okaem.” ");
INSERT INTO kne_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","“Aw, Kangatoan ay Diyos,” kanan Abram, “ngem intoy pangammoak pay ay okaek?” ");
INSERT INTO kne_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kanan pay Diyos en sisya, “Omya kas bomalasang ay baka ya kalding ya bomaro ay karnero ay sagtotoloy tawena ya doway kalasin di kalapati.” ");
INSERT INTO kne_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Et inan Abram dadi et in-ey na en Diyos. Pag nan biiken din awak di animal et in-olnos na sin doway linya ay nanpatpatag. Ngem mo din awak di kalapati pay, adi na ginodwa. ");
INSERT INTO kne_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Idi madadwes pay di dadakke ay titit ay mangan koma sin karni, inab-abo na. ");
INSERT INTO kne_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Idi madipdipos pay din agew, naimayet si Abram si seyep na et nilikob di kaeegyat ay mabolinget. ");
INSERT INTO kne_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Asi pag kanan Diyos en sisya, “Kadi man et mangili din polim sin ilin di natken ay ipogaw ta maibag-en da en daida ya mapaligatan da enggana ay emey di opat ay gasot ay tawen. ");
INSERT INTO kne_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Asiak dosaen din nakin bag-en en daida et komaan din polim isdi ay mangitaktakin si ad-ado ay gamgameng. ");
INSERT INTO kne_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Ngem emey pay dedan sin pitlon di ganak, asi da mantaoli sin ili ay nay, ta dowan masepsep din kinamanagbasol di Amorreo ay man-ilis na et kapilitan ay dosaek daida. Siya sa di mapasamak sin polim, ngem mo sik-a pay, makamakay ka, asi ka matey et iponpon daka. Laton ay adi ka edasan din ligat ay doy,” kanan Diyos. ");
INSERT INTO kne_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Idi nadipos pay din agew yan enggay nalabi, wada et di nanpaila ay pan-otoan ay kaman banga ay binmebelaan di asok ya apoy, et nalabas sin gawan di doway linya ay karni. ");
INSERT INTO kne_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Say nangisiglotan Diyos sin inkari na en Abram ay nangwani, “Kadi man et idawat ko sin polim amin din daga ay nay ay manlogi sin ginawang ay Nile ed Egipto enggana sin ginawang ay Eufrates.” ");
INSERT INTO kne_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Idi nantettee da Abram ed Canaan si sinpo ay tawen, maga pay laeng di anak da en Sarai ay asawa na. Ngem waday balasang ay bag-en Sarai ay taga-Egipto ay manngadan si Hagar. Isonga kanan Sarai en Abram, “Olay en ka daagen din bag-en ko ay nay balbalang mo man-anak, ta say maibilang si anak ta, tan nay binasig Diyos sak-en.” Et inaw Abram, isonga inpolang Sarai din bag-ena en sisya ta say maikadwa ay asawa na. ");
INSERT INTO kne_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Idi siya di, nandaag tet-ewa da Abram en Hagar, et nawad-an si Hagar. Idi nadlaw na ay masikog sisya, linaslasoy na si Sarai. ");
INSERT INTO kne_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Pag kanan Sarai en Abram, “Basol mo nan lawa ay am-amagen di bag-en kon sak-en. Sak-en kayman di nangipalobos ay daagem, ngem ed wani ay ammo na ay nawad-an sisya, doy et ay lomaslasoy. Sapay koma ta osigen Diyos mo sino en daita di akin basol.” ");
INSERT INTO kne_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kanan Abram, “Bag-en mos sisya et mabalin ay amagem di laydem.” Pag et palaloan Sarai ay paligaten si Hagar, isonga linmayaw. ");
INSERT INTO kne_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Dintengan di anghel Diyos sisya sin kad-an di esay obbog sin lugar ay magay omili sin danan ay emey ed Shur. ");
INSERT INTO kne_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kanan din anghel, “Hagar ay bag-en Sarai, intoy napoam ya intoy emeyam?” Songbatana pay yan kanana, “Ilaylayawak si Sarai ay apok.” ");
INSERT INTO kne_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Pag kanan din anghel Diyos en sisya, “Mantaoli ka sin apom ta mansilbi ka en sisya. ");
INSERT INTO kne_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Paad-adoek din apom et adi dan kabilang. ");
INSERT INTO kne_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Lalaki di ianak mo et ngadanam si Ismael, tan pinatgan Diyos din kararag mo ay nanpakpakaasi. ");
INSERT INTO kne_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ngem din ianak mo ay sana et kaman atap ay dangki. Kaibaw na amin ay ipogaw, yan amin ay ipogaw et ibawen da abes sisya. Olay abe din aag-i na et ibilang na ay kalaban.” ");
INSERT INTO kne_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Pag et waday inpangadan Hagar en Diyos ay kangalat na. Kanana, “Sik-a din Diyos ay Makaila,” tan kananas nemnem na, “Inilak si Diyos ay omil-ila ngem nay matmatagoak pay laeng.” ");
INSERT INTO kne_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Siya din gapo ay nangadanan din obbog ay sana sin nan-gawaan di Kades ya Bered si Beer-lahai-roi ono Obbog di Matmatago ay Omil-ila. ");
INSERT INTO kne_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Idi man-anak pay, lalaki, et nginadanan Abram si Ismael. ");
INSERT INTO kne_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Waopolo ya enem ay tawen en Abram sin nangianakan Hagar sin anak na ay sana. ");
INSERT INTO kne_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Idi nantawen si Abram si siyamapolo ya siyam, nanpaila kasin si Diyos en sisya yan kanana, “Sak-en di Manakabalin ay Diyos. Patiem sak-en si owaoway ta iwed di kolkolang sin kinaogalim. ");
INSERT INTO kne_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tan ipatet-ewak din inkarik en sik-a ay paad-adoek din polim.” ");
INSERT INTO kne_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Idi dinngen Abram di, nandokmog ay nanyakog-ong, dowan itoloy Diyos ay nangwani, ");
INSERT INTO kne_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Siya na di itolag kon sik-a. Manipod ed wani, baken si Abram di ngadan mo, mo adi et si Abraham, tan panbalinek sik-a ay mapowakan di omili sin ad-ado ay nasyon. ");
INSERT INTO kne_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Paad-adoek din polim ta maiwaras da sin kailiili, yan wada abe en daida di man-ari.” ");
INSERT INTO kne_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kanan aben Diyos, “Adi polos masoksokatan din intolag ko en sik-a mo adi komakaman si eng-enggana, tan siya met laeng di itolag ko sin polim. Sak-en di Diyos ay daydayawem ya siya abe din polim si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Idawat ko abe en sik-a am-in din ili ay nay ed Canaan ay naibilangam ay mangili ed wani ta say tawiden din polim ay eng-enggana, yan sak-en met laeng di Diyos ay dayawen da.” ");
INSERT INTO kne_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Intoloy Diyos ay nangwani en Abraham, “Mo sik-a pay ya din ganakem, masapol ay onodan yo din intolag ko en sik-a. ");
INSERT INTO kne_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","11","Si naey di sinyal ay pangipailaan yo ay on-onodan yo din intolag ko. Masapol ay makogit amin di lalaki en dakayo. ");
INSERT INTO kne_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Manlogi ed wani, siyat yon kogiten amin di bemela ay lalaki sin maikawao ay agew na, pati din bag-en ay maianak sin beey yo ya siya abe din bag-en ay laklakoan yo si mangili. ");
INSERT INTO kne_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Dadlon yon kogiten amin dadi, tan say sinyal ay pangipailaan yo ay maibilang kayo sin komakaman ay intolag ko. ");
INSERT INTO kne_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ngem mo wada pay di baken nakogit en dakayo, maipowira en dakayo ay ipogaw ko, tan nilabsing na od dedan din intolag ko.” ");
INSERT INTO kne_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kanan aben Diyos en Abraham, “Mo si asawam pay ay si Sarai, manlogi ed wani baken si Sarai di ngadana mo adi et si Sara. ");
INSERT INTO kne_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bindisyonak sisya ta way iyat na ay man-anak ta sisya di mangipabelas anak yo ay lalaki. Din tapin di bindisyon ko abe et omad-ado din polin di anak na ta maiwaras da sin kailiili, yan wada abe en daida di man-ari.” ");
INSERT INTO kne_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Idi dinngen Abraham din kanan Diyos ay sana, nandokmog ay nanyakog-ong dowan et masis-iyek ay mangwanis nemnem na, “Ay mabalin aya ay way ganakek tan nay et ay sin-gasot di tawen ko yan si Sara abe et siyamapolo di tawena.” ");
INSERT INTO kne_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Pag nan kanan en Diyos, “Mo mabalin koma, ta bindisyonam abe din anak ko ay si Ismael.” ");
INSERT INTO kne_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","“Aw pay dedan,” kanan Diyos, “ngem wada met pay laeng di ianak Sara ay lalaki et ngadanan yos Isaac. Daida met sin poli na di manawid sin intolag ko en sik-a ay adi masoksokatan. ");
INSERT INTO kne_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ngem dinngek pay kayman din kindaw mo maipanggep en Ismael, isonga sigurado ay bindisyonak sisya ta maad-ado abe din poli na. Tan man-anak si sinpo ya dowa ay pangolo yan din poli na abe, omad-ado da sin madamdamag ay nasyon da. ");
INSERT INTO kne_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ngem din kaiturongan pay di inkarik en sik-a et si Isaac ay ianak en asawam sin siya na ay timpo sin omali ay tawen.” ");
INSERT INTO kne_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Makdeng pay ay makingalat si Diyos en Abraham, kinmaan. ");
INSERT INTO kne_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Yan si Abraham pay, tinongpal na ay dagos din inbilin Diyos en sisya. Tan sin siya di ay agew, kinogit nas Ismael ya am-in din bag-ena ay lalaki ay naianak sin beey na ya am-in abe ay nilakoana. Sin doy met laeng ay agew, nanpakogit abes Abraham, isonga nandededsan da am-in ay nakogit. Siyamapolo ya siyam ay tawen Abraham sin nakogitana. Si Ismael abe ay anak na et mantawen si sinpo ya tolo. ");
INSERT INTO kne_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Idi mabaybayag, nanpailas Diyos kasin en Abraham sin nankamkampoan da sin kad-an di inayan ay kakaiw en Mamre. Din inyat na ay naamag et tinmotokdo si Abraham sin belaan di tolda na, tan enggay alas dosi yan palalo ay man-atong din agew. ");
INSERT INTO kne_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Manmeswat pay sisya, kambaw wada et di tolo ay lalaki ay pinmipika sin dagas. Dinalas na ay en nangabet et mandokmog ay manyakog-ong yan kanana, ");
INSERT INTO kne_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Apo, anosan yo adi ta maspad kayo sin beey mi ay nay, tan naeyak sina ay mansilbi en dakayo. ");
INSERT INTO kne_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Man-illeng kayo kod sin poon di kaiw ay nay ta dowanak en man-as danom ay iowas yo sin siki yo. ");
INSERT INTO kne_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Enak aben man-otos kanen yo ta way ikileg yo sin pandanan yo si awni. Tan malaydanak sin inmalian yos na.” “Aw kod kayman,” kanan da. ");
INSERT INTO kne_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Pag dalasen Abraham ay mantaoli sin tolda yan kanana en Sara, “Dalasem kod! Oma ka sin kasigedan ay arina tako ta man-oto kas ad-ado ay tinapay tan way bisita tako.” ");
INSERT INTO kne_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pag managtag ay en manpili sin malames ay olbon sin baka na, et indawat na sin esay baa na ta dalasena abe ay mangisagana. ");
INSERT INTO kne_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Idi naoto am-in, nan-a abes gatas ya odom ay makan et nakiey na sin karni sin kad-an di bisita na sin poon di kaiw ay doy. Et insango na en daidas di. ");
INSERT INTO kne_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Idi nakakan da pay, kanan da en Abraham, “Into pay si Sara ay asawam?” “Dooy sin tolda yan,” kanana. ");
INSERT INTO kne_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Pag kanan di esa en daida ay si Diyos, “Mo emey di siyam ay bowan, ipailak din kabaelak en dakayo, yan say pan-anakan asawam si anak yo ay lalaki.” Sin nangwanianas di, kambaw wada si Sara sin likod na sin pantew di tolda ay mandengdenge. ");
INSERT INTO kne_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mo da Abraham en Sara yan enggay nakay das nabakes da, et si Sara yan enggay adi mabalin ay man-anak. ");
INSERT INTO kne_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Isonga nasiyek sin nemnem na ay nangwani, “Ay siya mo mabalin ay lak-amek din ragsak di man-anak? Tan enggay nabakesak met, yan nakay abes asawak.” ");
INSERT INTO kne_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Asi et kanan Diyos en Abraham, “Apay nga nasiyek si asawam? Apay nga kananas nemnem na en adi mabalin ay man-anak tan enggay nabakes? ");
INSERT INTO kne_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ay siya mo waday adak kabaelan ay amagen? Tet-ewa met din inbagak ay ipailak din kabaelak en dakayo mo emey di siyam ay bowan, yan say pan-anakan Sara si anak yo ay lalaki.” ");
INSERT INTO kne_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Asi et insaot Sara tan emegyat iman, yan kanana, “Aga kadi, adiak nasiyek.” “Nasiyek ka met,” kanan Diyos ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Idi kinmaan din tolo ay bisita, nanpa-Sodoma da, et nakeey si Abraham ay nangitlod en daida. Os-osdongan da pay ed Sodoma, ");
INSERT INTO kne_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","kanan Diyos si nemnem na, “Olay adiak bokbokodan din enak amagen mo adi et ipaammok en Abraham. ");
INSERT INTO kne_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tan sisya di mangipoli sin ad-ado ay ipogaw ay man-ili sin madayaw ya napigsa ay nasyon. Manbegew abe en sisya, mabindisyonan am-in di ipogaw isnan lobong. ");
INSERT INTO kne_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pinilik abes sisya ta bilinena din ganakena ta onodan das sak-en ya amagen da din siged ya kosto. Tan mo say iyat da di, tongpalek abe din intolag ko en sisya.” ");
INSERT INTO kne_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Isonga kanan Diyos en Abraham, “Peteg ay madagsen din maipabasbasol sin man-ili ed Sodoma ya Gomorra, tan enggay nalabes di basbasol das di. ");
INSERT INTO kne_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Enak ngarud ilaen mo tet-ewa din dinamag ko ay maipanggep en daida ta say ammoek ta asiak dosaen.” ");
INSERT INTO kne_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Idi nakdeng ay kanan Diyos di, inmey din doway gait na ed Sodoma, et nataynan si Diyos sin kad-an Abraham. ");
INSERT INTO kne_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Inmasag-en si Abraham en sisya yan kanana, “Apo, ay pakidosam aya din siged sin lawa? ");
INSERT INTO kne_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mo kaspangarigan waday limapolo ay adi nakibasol sin odom, ay bakasem aya din intiro ay ili da? Aga ngin, tan mabalin siguro ay seg-angam daida am-in begew sin limapolo ay magay basol na. ");
INSERT INTO kne_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Adi ngin mabalin ay pakidosam din siged sin lawa, tan mo say iyat mo kayman, adi pay is-om din amagem sin siged ya sin lawa. Adi met mabalin ay say amagem di, tan sik-a kayman di mangokom sin amin ay ipogaw isnan daga, yan kapilitan ay kosto di iyat mo ay mangokom.” ");
INSERT INTO kne_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kanan Diyos ay sinombat, “Mo waday datngak ay limapolo ay ipogaw ed Sodoma ay adi nakibasol sin kailian da, laton ay seg-angak din intiro ay ili begew en daida.” ");
INSERT INTO kne_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kanan aben Abraham, “Pasinsiyaam kod ay Apo din kinatoled ko ay mangitoloy, tan owatak ipogaw ay napo sin lota yan iwed di kalebbengak ay mangibagas olay sino en sik-a. ");
INSERT INTO kne_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ngem into et ya waday opatapolo ya lima ay nalinteg ay ipogaw, ay bakasem pay laeng din intiro ay ili gapo ta kolang di lima anggoy?” “Maga,” kanan Diyos ay sinombat. “Adiak pay dosaen din ili da mo waday datngak ay opatapolo ya lima ay ipogaw ay adi naitapi sin basol di odom.” ");
INSERT INTO kne_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nankali kasin si Abraham yan kanana, “Mo kaspangarigan wada di opatapolo anggoy?” “May ngarud,” kanan Diyos, “mo wada di opatapolo, adiak pay dosaen din ili da.” ");
INSERT INTO kne_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kanan Abraham kasin, “Apo, adi ka kod omibongbonget sin nay ay kasinak ibaga en sik-a. Ngem into et ya wada anggoy di tolonpo?” “Mo way datngak ay tolonpo, adiak dosaen din ili da,” kanan aben Diyos. ");
INSERT INTO kne_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kanan kasin Abraham, “Apo, pasinsiyaam kod kasin din kinatoled ko, tan wada pay di ibagak. Mo kaspangarigan dowanpo anggoy di datngam?” “Mo dowanpo di wadas di, adiak aben dosaen din ili da,” kanan Diyos. ");
INSERT INTO kne_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kasin pay nankalis Abraham yan kanana, “Apo, adi ka kod omibongbonget, tan si naey met di omanongos ay ibagak. Into et ya sinpo anggoy di wada?” Kanan Diyos, “Olay mo sinpo anggoy ay siged di datngak isdi, laton ay adiak dosaen din ili da begew en daida.” ");
INSERT INTO kne_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Idi nakdeng pay din ngalat da, kinmaan si Diyos et sinmaas Abraham. ");
INSERT INTO kne_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Idi sinmawang din doway anghel ed Sodoma sin siya di ay labi, wadas Lot ay tinmotokdo sin kad-an di segpan di ili. Idi inila nas daida, ena inabat. Et mandokmog ay manyakog-ong sin sangoanan da yan kanana, ");
INSERT INTO kne_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Apo, naeyak ay mansilbi en dakayo. Omali kayo kod ed bebbeey ta say pangowasan yo sin siki yo. Maseyep kayo abes di ta asi kayo masapa ay manlobwat si bigat.” “Aga,” kanan da. “Olay din plaza di kaseypan mi.” ");
INSERT INTO kne_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ngem pinilit Lot ay nakisaa da en sisya. Domateng da pay sin beey na, tinogon Lot din bag-ena ta mandono das mam-is ay makan, pati tinapay ay iwed di labadura na. Idi naoto am-in, nangan da. ");
INSERT INTO kne_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Daan da pay maseyep yan sinmawang amin din lallalakin di ili, pati nanakay ya babbaro. Nilikob da din beey ");
INSERT INTO kne_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","yan binogawan das Lot ay nangwani, “Into pay da din sangailim ay doy? Ipabela mo man ta piliten mi ay alaen din kinalalaki da.” ");
INSERT INTO kne_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Binmel-ay si Lot et in-eneb na. ");
INSERT INTO kne_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Pag nan kanan en daida, “Pangaasi yo kod ay iib-a. Adi yo kod amagen san lawa, tan nalabes damdama. ");
INSERT INTO kne_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Naey pay din doway balasang ko ay iwed pay laeng di nangas kinababai da. Olay ibelak si daida ta oway di iyat yo en daida. Basta bay-an yo nan lallalaki ay sangailik, tan kapilitan ay bantayak daida.” ");
INSERT INTO kne_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Dowan da et kanan, “Komaan kas sa! Ay siya mo way lebbeng mo ay mamilin en dakami? Owat ka et aben mangili. Iay-ayed mo man tan into et mo masepsep di iyat mi en sik-a mo din sangailim ay sana.” Siya di et kaitodon da en Lot ta en da koma piliten din pantew. ");
INSERT INTO kne_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ngem din doway lalaki sin oneg, kabokat da sin pantew et kaigoyod da en Lot ay mangisgep dowan dan kasin in-eb. ");
INSERT INTO kne_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pag da pay godaben am-in din wada sin bel-ayan ta adi da makadteng sin pantew. ");
INSERT INTO kne_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Pag dan kanan en Lot, “Mo waday anak yo, innapo yo ya ton-od yos nan ili, en ka ayagan ay dagos ta komaan kayo am-in, ");
INSERT INTO kne_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tan bakasen mi nan ili. Dinngen dedan Diyos din madagsen ay maipabasbasol sin ipogaw isna, isonga inbaa nas dakami ta bakasen mi nan ili da.” ");
INSERT INTO kne_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Idi siya di, inmey si Lot sin kad-an di doway lalaki ay naikaising sin an-ak na yan kanana, “Dalasen yo ta komaan takos na, tan bakasen Diyos nan ili tako.” Ngem adi da inkaskaso tan kanan da en solsologenas daida et anggoy. ");
INSERT INTO kne_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Idi pomatpat-a pay, dagdagen din anghel si Lot ay nangwani, “Dalasem ay! Ayagam si asawam ya din doway balasang yo ta komaan kayo ay dagos ta adi kayo maitapi sin dosan di ili ay nay.” ");
INSERT INTO kne_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mandowadowa si Lot pay laeng ay manlobwat, ngem begew din seg-ang Diyos, kaitakkay din anghel en daida ay sin-asawa ya din doway anak da ay balasang et inpango da sin beddeng di ili. ");
INSERT INTO kne_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Asi kanan di esa ay anghel, “Dalasen yo ay lomayaw ta emey kayo sin dontog ay doy. Adi kayo mansepsepad sin tanap. Adi kayo aben manwingwingi mo adi et mandagas kayo ay managtag sin dontog tan into et ya makidosa kayo.” ");
INSERT INTO kne_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ngem kanan Lot, “Dakey kod ay Apo. ");
INSERT INTO kne_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Dakdake kayman di seg-ang yo ay mangisalakan en dakami. Ngem palalo met ay addawi din dontog. Daanak domateng yan mad-asanak sin dosa et mateyak met laeng. ");
INSERT INTO kne_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Isonga mo mabalin, olay din kitkittoy ay ili ay doy di emeyan mi koma, tan baken palalo ay addawi. Ipalobos yo kod ta say emeyan mi ta maga di mapasamak en dakami. Tan maila ay kitkittoy ay ili dedan.” ");
INSERT INTO kne_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Aw,” kanan din esay anghel. “Awek din kindaw mo ay sana et ipowirak din ili ay inbagam. ");
INSERT INTO kne_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ngem dalasen yo, managtag kayo, tan adiak makailogi sin amagek engganas domateng kayo.” Siya di din begew ay nangadanan din ili ay doy en Zoar, tan kanan Lot en kitkittoy ay ili. ");
INSERT INTO kne_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Idi maag-aggew, sinmawang si Lot ed Zoar. ");
INSERT INTO kne_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Asi et kaekgas si Diyos si manbidbidang ay bato ay makwani en sulfur ed Sodoma ya Gomorra. ");
INSERT INTO kne_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Et napooan am-in ay wada sin tanap ya din doway ili ay doy, pati am-in di ipogaw ya am-in abe ay gomabgabay isdi. ");
INSERT INTO kne_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nakidosa abe din asawan Lot, tan nanwingi et nanbalin si sinan ipogaw ay asin. ");
INSERT INTO kne_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Sin kasin napat-a, nasapas Abraham ay emey sin kad-an di nanngalatan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Domateng pay isdi, inosdongana ed Sodoma ya ed Gomorra ya din annawa ay tanap isdi, yan inila nay masde ay asok ay komaykayang ay kaman din asok ay napo sin panpooan das apog. ");
INSERT INTO kne_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Gapo ta emegyat si Lot ay manbeey ed Zoar, nantikid sin kadondontogan. Inkoyog na din dowa ay balasang ay an-ak na et nanbeey da si esa ay liyang. ");
INSERT INTO kne_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Sin namingsan, kanan din pangpangoan, “Enggay makmakay si ama ta yan magay lalaki isnan daga si pakiasawaan ta. ");
INSERT INTO kne_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Betengen ta et sisya asi tan daagen ta mantoltoloy din poli tako babaen en ama.” ");
INSERT INTO kne_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Et bineteng das ama da sin labi ay sana, pag makidaag din pangpangoan ay anak na, ngem adi ammon Lot din napasamak. ");
INSERT INTO kne_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kasin pay mapat-a, kanan din pangpangoan sin iyogtana, “Nakidaagak en ama ta ed labi. Ed wani, betengen ta kasin ta sik-a abe di makidaag ta say mawadaan ta ay dowa si anak babaen en sisya.” ");
INSERT INTO kne_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Bineteng da kasin si ama da sin labi ay sana et nakidaag din iyogtan, ngem adi na ammo din nakidaagan di anak na. ");
INSERT INTO kne_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Et nawad-an din dowa ay an-ak Lot babaen sin mismo ay ama da. ");
INSERT INTO kne_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nan-anak din pangpangoan si lalaki ay nginadanana si Moab, et say nangipoli sin Moabita ay wada ed wani. ");
INSERT INTO kne_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nan-anak abe din iyogtan si lalaki ay nginadanana si Ben-Ammi ay say napoan di makwani en Ammonita ed wani. ");
INSERT INTO kne_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Idi siya di, binindisyonan Diyos si Sara et tinongpal na din inkari na en sisya. ");
INSERT INTO kne_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tan olay mo enggay nakay si Abraham, nawad-an met laeng si asawa na. Sin kosto ay timpo ay inbagan Diyos di nangianakana si anak da ay lalaki. ");
INSERT INTO kne_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nginadanan Abraham din anak da si Isaac, ");
INSERT INTO kne_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","et sin maikawao ay agew na, kinogit nas sisya ay nanongpal sin inbilin Diyos en sisya. ");
INSERT INTO kne_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sin-gasot di tawen Abraham sin binmelaan Isaac. ");
INSERT INTO kne_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Mo si Sara abe, kanana en, “Indawtan Diyos sak-en si gapo ay panragsakak ya pansiyekak, isonga makisiyek abe am-in din mannge sin nay ay naamag en sak-en. ");
INSERT INTO kne_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tan ed idi, ay siya mo way mangwani en Abraham en manpasosos asawa na? Ngem naey pay di inpabelak ay anak mi sin nakayana.” ");
INSERT INTO kne_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Neyneyna dinmakdakes Isaac et pinsot ina na. Sin kosto ay agew ay napsotana, inpaltian Abraham si ad-ado ay animal. ");
INSERT INTO kne_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Asi et inilan Sara din anak Abraham en Hagar ay taga-Egipto ay manis-iyek en Isaac ");
INSERT INTO kne_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","yan kanana en Abraham, “Pakaanem san bag-en ya din anak na ay sana, tan sigaak ay makitawid di anak di bag-en sin kinabaknang mo ta mongsanen koman anak ta ay si Isaac.” ");
INSERT INTO kne_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Palalo ay mansakit di nemnem Abraham sin nangwanian Sara isdi, tan anak na met iman abe si Ismael. ");
INSERT INTO kne_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ngem kanan Diyos en sisya, “Adi ka madandanagan begew sin bag-en mo ya din anak na, mo adi et amagem din inbagan asawam, tan si Isaac pay dedan di kaiturongan di intolag ko maipanggep sin polim. ");
INSERT INTO kne_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ngem gapo ta anak mo met laeng si Ismael, paad-adoek abe din ganakena ta pon-en day intiro ay nasyon.” ");
INSERT INTO kne_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Sin kasin napat-a, nasapa ay nan-as Abraham si makan ya sopot ay lalat ay napay-an si danom et inpatilid na en Hagar. Pag nan pakaanen sisya ya din anak na. Kinmaan da Hagar et nanlikeliked da sin lugar ay magay omili ed Beerseba. ");
INSERT INTO kne_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Idi naabos din baon da ay danom, tinaynana din anak sin poon di esay kitkittoy ay kaiw. ");
INSERT INTO kne_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","En tinmokdo sin baken onay addawi tan kananas nemnem na, “Adiak maitoled ay ilaen din anak ko ay matey.” Pag nan ilogi ay man-oga. ");
INSERT INTO kne_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dinngen Diyos din ogan di anak et kanan din anghel na ed langit, “Hagar, apay mo? Adi ka madanagan, tan dinngen Diyos din ogan di anak. ");
INSERT INTO kne_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","En ka et itakkayan ta bomangon, tan paad-adoek din poli na.” ");
INSERT INTO kne_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pag ipailan Diyos en Hagar di esay obbog. Pinay-an Hagar din sopot ay lalat si danom et nan-inomena din anak na. ");
INSERT INTO kne_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Inay-ayowanan Diyos din anak enggana ay nadakdake. Nantee sin lugar ay magay omili ed Paran yan nanbalin si nalaing ay pomapana. ");
INSERT INTO kne_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Idi inmey di pigay tawen, kanan Diyos en padasenas Abraham. Isonga inayaganas sisya ay nangwani, “Ay Abraham.” “Ay way ibagam, Apo?” kanana ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pag kanan Diyos, “Ayagam san es-esa ay anak mo, ay si Isaac ay laydelaydem, et emey kayo sin dontog ay itdok en sik-a sin sakop di Moria ta say pamseam ya panpooam sin anak mo ay sana ta idaton mon sak-en.” ");
INSERT INTO kne_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mapat-a pay, nasapas Abraham ay en nangaiw si panpoo na et inpag-ena sin dangki na. Asi na ayagan si Isaac ya doway bag-en et nalobwat da ay emey sin lugar ay inbagan Diyos en sisya. ");
INSERT INTO kne_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sin maikatlo ay agew, tinamang Abraham din dontog ay emeyan da ");
INSERT INTO kne_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","yan kanana sin doway bag-en, “Mantee kayos na ay mamanbantay sin dangki ta dowan kamin emey sin anak kos di ay mandayaw en Diyos. Asi kami mantaoli.” ");
INSERT INTO kne_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Siya di et inan Abraham din kaiw ay itongo na sin daton et inpasakbat na en Isaac. Ina na abe di pantago nas apoy ya din bangig na et nadipos da ay dowa. Idi mandad-an da pay, ");
INSERT INTO kne_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","nankalis Isaac yan kanana, “Ay ama!” “Sino di?” kanan Abraham. “Naey di pantagos apoy ya kaiw, ngem into ngay din anak di karnero ay idaton ta?” kanan Isaac. ");
INSERT INTO kne_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“Si Diyos met laeng di makaammos di,” kanan Abraham ay sinombat. Et intoloy da ay dowa ay mantikid. ");
INSERT INTO kne_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Somawang da pay sin lugar ay inbagan Diyos ay emeyan da, nan-amag si Abraham si altar ay panpooanas idatona en Diyos et in-olnos na din kaiw sin sapew na. Pag nan baloden si Isaac ay anak na yan inpatang na sin kaiw. ");
INSERT INTO kne_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Asi na pay itag-ay din bangig na ta peslena koma din anak na. ");
INSERT INTO kne_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ngem kabogaw din anghel en Diyos ay napod langit yan kanana, “Ay Abraham, Abraham!” “Apay mo?” kanana ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Dakey! Adim pespeslen san anak mo, tan nay inammoak ay dadlon mon patien si Diyos, tan sana ay adim kinayyawan din laydelaydem ay anak mo en sisya,” kanana. ");
INSERT INTO kne_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Idi siya di, nanmeswat si Abraham yan inila na di karnero ay bomaro ay naisagwed di sakngod na sin pangan di kitkittoy ay kaiw. Isonga ena ina et say insokat na sin anak na ay indatona en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Pag nan ngadanan din lugar ay doy si “Si Diyos di Mangil-ila.” Yan enggana ed wani way mangwani, “Sin dontog en Diyos, say pangil-ilaana sin kasapolan.” ");
INSERT INTO kne_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Siya di inpidwan din anghel en Diyos ed langit ay nankali yan kanana en Abraham, ");
INSERT INTO kne_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Sak-en ay si Diyos, isapatak sin awak ko ay gapo ta pinatim sak-en yan adim kinayyawan din es-esa ay anak mo, dadlonak bindisyonan sik-a ");
INSERT INTO kne_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","yan paad-adoek din polim ta kaman din kaad-adon di talaw ed daya ya din darat sin benget di baybay. Abaken da pay din kaibaw da. ");
INSERT INTO kne_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Am-in abe ay ipogaw isnan labaw di daga, mankedaw das bindisyon ko begew sin polim ay sana. Mapasamak amin dana gapo ta pinatim din inbilin ko en sik-a,” kanan Diyos. ");
INSERT INTO kne_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Idi nakdeng ay kanan Diyos di, nantaolis da Abraham ay en nanag-os sin doway bag-en, et nankokoyog da ay somaa ed Beerseba, tan say kad-an da Abraham pay laeng. ");
INSERT INTO kne_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Idi nantawen si Sara si sin-gasot ya dowanpo ya pito, ");
INSERT INTO kne_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","natey ed Hebron sin sakop di Canaan, et niladingitan Abraham sisya. ");
INSERT INTO kne_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Pag nan iponpon sin liyang ay wada sin daga ay nilakoana sin man-ilis di ay Heteo. Din daga ay sana, wada ed Makpela ay asag-en ed Mamre (ay lak-am di Hebron met laeng), ");
INSERT INTO kne_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","et say nilakoan Abraham ta say pangiponponana sin minatay na. ");
INSERT INTO kne_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Enggay nakay si Abraham, yan bininbindisyonan Diyos sisya sin amin ay inam-amag na. ");
INSERT INTO kne_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Siya di, kanan Abraham sin kangatoan ay bag-ena ay din makaammo sin amin ay gamgameng na, “Kapayem nan poyong ko ta mansapata ka. ");
INSERT INTO kne_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Tan laydek ay mansapata ka en Yahweh ay Diyos ay manturay ed langit ya sin daga ta adi ka manpilis asawaen din anak ko ay si Isaac sin babassang isnan ed Canaan ay panbeeyan tako, ");
INSERT INTO kne_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","mo adi et emey ka sin ili ay napoak ay kad-an di toton-od ko ta man-ila kas di si balasang ta say asawaena.” ");
INSERT INTO kne_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Sinongbatan din bag-ena yan kanana, “Et intoy iyat ko ngay mo sigaan din balasang ay komaan sin ili na ay makiali en sak-en isna? Ay asiak koyogen din anak mo ay emey sidi?” ");
INSERT INTO kne_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kanan aben Abraham, “Dakey, adi mabalin ay iey mo din anak kos di, ");
INSERT INTO kne_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","tan si Yahweh ay Diyos di amin ay wada ed langit yan tinogonas sak-en ta komaanak sin ilik ya taynak din toton-od kos di. Inkari na abe ay nangisapata ay idawat na din ili ay nay sin polik. Sisya met laeng di mangibaa sin anghel na ay bomadang en sik-a ta way iyat mo ay omas asawan anak ko sin babassang isdi. ");
INSERT INTO kne_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Yan mo sigaana pay ay makialis na, mawaswas din isapatam ay sana. Basta adim koyogen anak kos di,” kanan Abraham. ");
INSERT INTO kne_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Siya di et kinapay din bag-en ay sana din poyong en Abraham ay apo na yan nansapata ay amagena din intogona en sisya. ");
INSERT INTO kne_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Pag nan isagana di sinpo ay kamel din apo na et inkarga na am-in ay kalasin di nankamamayat ay maidatdateng. Asi da manlobwat sin kakoyog na ay emey sin ilin Nahor ay agin Abraham sin sakop di Mesopotamia. ");
INSERT INTO kne_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Idi dinmateng da sin segpan di ili, pinadokmog da din kamel sin dagas di obbog ay wadas di. Tan enggay masmasdem yan say oras ay en panaksakdoan di babbabai. ");
INSERT INTO kne_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Asi nankararag ay nangwani, “Sik-a ay Yahweh ay Diyos di apok ay si Abraham, sapay koma ta bomadang ka ed wani ta matongpal din inkarim sin apok. ");
INSERT INTO kne_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tan naeyak sina sin kad-an di obbog yan doy ay omal-ali din babassang ay man-ilis na ay en manakdo. ");
INSERT INTO kne_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Sapay koma ta mo kanak sin balasang en, ‘Ibabam kod san kolim ta man-inomak,’ yan kanana en, ‘Aw adi, asiak aben isakdoan din kamel mo,’ sapay koma ta din mangwanis di et siya di din pinilim ay asawaen Isaac. Mo say mapasamak, say pangammoak ay am-amagem din inkarim en Abraham ay apok,” kanana ay nangikararag. ");
INSERT INTO kne_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Daan pay makdeng din kararag na yan sinmawang si Rebeka ay nanasakbat si koli ay isaksakdo na. Din si Rebeka ay nay et anak en Betuel ay anak da Milca en Nahor ay agin Abraham. ");
INSERT INTO kne_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Kagkagam-is ay balasang ay maga pay laeng di nangiwit en sisya. Nanballalong sin kad-an di obbog et nanakdo. Idi mantaoli pay sisya, ");
INSERT INTO kne_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","dalasen din bag-en en Abraham ay en nangabat yan kanana, “Man-inomak kod issa.” ");
INSERT INTO kne_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Aw adi ay apo,” kanana. Kaibaba sin koli sin padanga na ta way iyat na ay man-inom. ");
INSERT INTO kne_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Makainom pay, kanan Rebeka, “Enak aben isakdoan san kamel mo ta man-inom da si kosto.” ");
INSERT INTO kne_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kaisodag sin nabay-an sin koli sin balonglong ay pan-in-inoman di animal et katagtag ay kasin manakdo. Inpidwapidwa na enggana ay naiinoman am-in din kamel, ");
INSERT INTO kne_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","dowan pay ginmiginek din bag-en Abraham ay sana ay mangisisin-eng en sisya ta ammoana mo tet-ewa ay inturong Diyos sisya sin kosto ay asawaen Isaac. ");
INSERT INTO kne_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Idi nakdeng ay insakdoan din balasang din kamel, nan-a din lalakis nangina ay aritos ay balitok ya doway dadakke ay gading ay balitok et in-amag na en sisya. ");
INSERT INTO kne_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Pag nan kanan, “Sinoy si amam? Ibagam kod abe mo nawaya din beey yo ta say pan-iyanan mi sin gagait ko.” ");
INSERT INTO kne_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kanan din balasang ay sana, “Si amak yan si Betuel ay anak da Nahor en Milca. ");
INSERT INTO kne_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Way nawaya abe ay pan-iyanan yos di, yan wada pay di sakati ay kanen di kamel yan ad-adoy allogangi abe ay kaseypan da.” ");
INSERT INTO kne_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Idi dinngen din lalaki din kanan di balasang ay sana, nandokmog ay nandayaw en Diyos ");
INSERT INTO kne_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","yan kanana, “Madayaw ka ay Yahweh, sik-a ay Diyos di apok ay si Abraham, tan inpailam kasin din komakaman ay seg-ang ya badang mo en sisya. Yan mo sak-en pay, inpangom sin beey di toton-od na.” ");
INSERT INTO kne_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Managtag pay si Rebeka ay somaa yan dinad-at na en da ina na din naamag. ");
INSERT INTO kne_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Wada abe din agin Rebeka ay si Laban. ");
INSERT INTO kne_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Idi inila na din aritos ya din in-gagading na ya dinnge na abe din inpadamag na, katagtag sin obbog ay en nangabat sin bisita da ay sana. Dinatngana din bag-en Abraham ay pinmipika sin kad-an di kamel, ");
INSERT INTO kne_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","yan kanana, “Sik-a ay binindisyonan Diyos, apay nga pomipika kas sa? En tako ed bebbeey tan way insaganak ay pan-iyanan yo ya pantean aben di kamel yo.” ");
INSERT INTO kne_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Domateng da pay sin beey, inpasgep Laban si daida. Kinaana din kargan di kamel ya insakatianas daida. Asi na aben iyaan din bisita nas danom ta owasan da din siki da. ");
INSERT INTO kne_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Pag nan isango di kanen da. Asi et kanan din bag-en Abraham, “Awni kod. Adiak mangan enggana ay ibagak din panggep ko ay inmalis na.” “May, ibagam,” kanan Laban. ");
INSERT INTO kne_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kanan da Laban en Betuel ay sinombat, “Maga di maibaga mi, tan enggay inpailan Diyos din laydena. ");
INSERT INTO kne_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Itakin yo ngarud si Rebeka sin ili yo ta say asawaen din anak di apom, tan siya met laeng di intogon Diyos.” ");
INSERT INTO kne_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Sin kabigatana, nansagana si Rebeka ya din babassang ay bag-ena, et nangabayo da sin kamel da. Asi da manlobwat ay makiey sin bag-en Abraham. ");
INSERT INTO kne_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Idi dinmateng da ed Canaan, kadatdateng pay Isaac sin ili da ed Negev sin abagatan di Canaan, tan napo ed Beer Lahai Roi. ");
INSERT INTO kne_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Malablabi pay, binmel-ay si Isaac ay en manlikliked sin dagdagas di beey da dowan mankarkararag. Manmeswat pay, tinamang nay nangakabayos kamel ay omal-ali. ");
INSERT INTO kne_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Idi inilan aben Rebeka si Isaac, kababa sin kamel ");
INSERT INTO kne_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","yan dinamag na sin bag-en, “Sino din lalaki ay doy ay omas-asag-en ay omabet?” “Din anak di apok,” kanana ay sinombat. Isonga nilingban Rebeka din mata nas sokdong, tan say ogalin di babassang isdi. ");
INSERT INTO kne_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Datngan da pay si Isaac, dinad-at din bag-en en Isaac amin di inamag na. ");
INSERT INTO kne_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Et inbeey Isaac si Rebeka sin tolda ay nanbeeyan ina na ed idi. Dakdake abe din layad na en sisya. Siya et di, naliwliwa di nemnem na, tan nansaksakit iman nemnem na manlogi sin nateyan ina na. ");
INSERT INTO kne_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Si Abraham pay et enggay insakngod nay peweg na, tan nantawen si sin-gasot ya pitopolo ya lima, asi matey. Et en naitapi din ab-abiik na sin ab-abiik di ap-apo na. ");
INSERT INTO kne_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Inponpon din anak na ay da Isaac en Ismael sin naiponponan Sara ay asawa na sin liyang ed Makpela ay asag-en ed Mamre, tan siya met laeng din daga ay nilakoan Abraham ed idi en Efron ay anak Zohar ay Heteo. ");
INSERT INTO kne_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Mo si Isaac pay, opatapolo di tawena sin nan-asawaan da en Rebeka ay iyogtan Laban ay anak Betuel (ay esay Arameo ay napod Mesopotamia). ");
INSERT INTO kne_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Asi et inmey di pigay tawen yan maga pay laeng di anak na. Isonga nankararag si Isaac en Diyos ay mankedaw si anak da. Dinngen Diyos din kararag na et nawad-an si Rebeka si singin. ");
INSERT INTO kne_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Sin daan da pay laeng bemelaan, nansinikil da sin eges na, isonga kananas nemnem na, “Apay nas mapaspasamak en sak-en mo?” Et nankararag en Diyos ay nangipoot. ");
INSERT INTO kne_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kanan Diyos en sisya, “Din singin ay liton mo, man-ganak das man-ili si doway nasyon, ya din doway nasyon ay sana et mankinontra da. Napigpigsa din esa mo din esa, yan din inoona et mansilbi sin inoodi.” ");
INSERT INTO kne_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Idi man-anak pay si Rebeka, singin ay lalaki tet-ewa di binmala. ");
INSERT INTO kne_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Din inmon-ona, manbalanga di awak na yan balbonan ay kaman kopkop di animal, isonga nginadanan das Esau. ");
INSERT INTO kne_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Din maikadwa pay, nanpapakod sin mokod di inoona sin binmelaan da, isonga nginadanan das Jacob. Waday enemapolo ay tawen en Isaac sin naianakan da. ");
INSERT INTO kne_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Idi nadakdake da ay dowa, linmaing si Esau ay manganop yan pag sin kada di em-emeyana. Si Jacob pay yan nanemneman ay ipogaw ay mameey. ");
INSERT INTO kne_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Din laylayden Isaac et si Esau, tan ak-aklongana din an-anopana. Si Rebeka pay yan laylaydenas Jacob. ");
INSERT INTO kne_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sin namingsan, sinmaas Esau ay napo sin kada yan dinatnganas Jacob ay manengdengdeng si manbalanga ay bokel. Palalo ay mandagaang, ");
INSERT INTO kne_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","isonga kanana en Jacob, “Omya ka kod sin manbalanga ay sana tan nay kamanak matey si dagaang ko.” (Gapo sin kinwanin Esau ay sana, bindayan da abe si Edom.) ");
INSERT INTO kne_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Asi et kanan Jacob, “Ipolang mo agan-o en sak-en din lebbeng mo ay besag, asiak iyaan sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Aw a, tan magay silbi na met laeng mo mateyak si dagaang,” kinwanin Esau. ");
INSERT INTO kne_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kanan pay Jacob, “Mansapata ka ngarud.” Siya di nansapatas Esau ay nangipolang sin lebbeng na ay besag en Jacob. ");
INSERT INTO kne_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Et pag idawtan Jacob si tinapay ya sin manbalanga ay dinengdeng ay sana. Nangan, asi mapika et madipos. Say inyat Esau di ay nangipalasoy sin lebbeng na koma ay besag. ");
INSERT INTO kne_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Idi siya di, wada kasin di betil sin ili, baken din betil ed idi sin timpon Abraham. Et inmey si Isaac sin kad-an Abimelek ay arin di Filisteo ed Gerar. ");
INSERT INTO kne_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ngem nangon-ona ay nanpaila si Diyos en Isaac yan siya na di inbaga na, “Adi ka em-emey ed Egipto. Mantee ka sin daga ay ibagak ay panteam. ");
INSERT INTO kne_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mantee ka sin daga ay nay et wadaak ay mangadkadwa en sik-a ya bindisyonak sik-a. Idawat ko amin din daga ay nay en sik-a ya sin polim ta say tongpalek din karik en amam ay Abraham. ");
INSERT INTO kne_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Paad-adoek din polim ay kaman din kaad-adon di talaw ed daya ya idawat kon daida amin din daga ay nay. Mabindisyonan abe din kaipoipogaw sin amin ay nasyon begew sin ipolim. ");
INSERT INTO kne_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Bindisyonak sik-a tan pinatin Abraham sak-en yan tinongpal na amin ay linteg ya bilin ko.” ");
INSERT INTO kne_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Gapo sidi, nantee si Isaac ed Gerar. ");
INSERT INTO kne_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Idi nandamag din lallalaki ed Gerar si maipanggep sin asawa na, inbaga na en iyogtana si Rebeka. Emegyat ay mangibaga en asawa na tan into et mo peslen da begew en Rebeka ta asawaen da, tan napintas dedan sisya. ");
INSERT INTO kne_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nabayag ay nantees Isaac isdi. Waday esay agew ay nan-osdong si Abimelek sin tawa, inila na et da Isaac en Rebeka ay nandadaag. ");
INSERT INTO kne_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Inpaayag na si Isaac yan kanana, “Kambaw asawam yan apay nga inbagam en iyogtan mo?” Songbatan Isaac yan kanana, “Tan ninemnem ko ay amangan mo pomse da gapo en sisya.” ");
INSERT INTO kne_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kanan Abimelek, “Apay nas inyat mo? Nalaka koma ay dinaag di esay ipogaw ko si asawam et sik-a et di gapo si bomasolan mi.” ");
INSERT INTO kne_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Isonga kanan Abimelek ay namagbaga sin amin ay ipogaw na, “Matey di olay sino ay mangamag si lawa sin lalaki ay nay ono si asawa na.” ");
INSERT INTO kne_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nanmola si Isaac sin daga ay sana sin doy met laeng ay tawen et nan-apit si mamin gasot ay kaad-adon di inmola na. Binindisyonan Diyos sisya ");
INSERT INTO kne_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","et natapian ay natapian din sanikwa na enggana ay binmaknabaknang sisya. ");
INSERT INTO kne_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Inmad-ado di karnero, baka ya bag-ena, isonga inapalan din Filisteo. ");
INSERT INTO kne_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tinab-okan das lota amin din sakdoan ay kinaotan di babag-en ama na ay Abraham sin timpo na. ");
INSERT INTO kne_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Pag kanan Abimelek en Isaac, “Masapol ay komaan kas nan ili mi tan nay enggay napigpigsa ka mo dakami.” ");
INSERT INTO kne_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Et kinmaan si Isaac sin ili ay doy yan nankampo sin tanap ed Gerar et isdi ay nantee. ");
INSERT INTO kne_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kinaotan kasin Isaac din sakdoan ay kinaotan ama na ay Abraham sin timpo na ya tinab-okan din Filisteo sin nateyana. Inpangadana met laeng din inpangadan Abraham en daida. ");
INSERT INTO kne_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Idi enggay nakay si Isaac dowan komapsot mata na, inayagana si Esau ay pangpangoan ay anak na yan kanana, “Ay anak ko.” “Apay mo!” kanan Esau. ");
INSERT INTO kne_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","4","Kanan aben Isaac, “Alaem san panam ta en ka manganop ta asi ka ioto din kalasin di sida ay laylaydek. Mo makakanak pay, asiak bindisyonan sik-a, tan enggay nakayak yan nganngani samet di kateyak.” ");
INSERT INTO kne_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Sin nangibagaan Isaac isdi, kambaw wadas Rebeka ay nanannge. Madipos pay si Esau ay en manganop, ");
INSERT INTO kne_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","pag kanan Rebeka en Jacob, “Kadkadngek din inbagan amam sin pangpangoan mo. Kanana en, ");
INSERT INTO kne_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘En ka manganop ta man-oto kas mam-is ay isidak ta asiak bindisyonan sik-a sin sangoanan Diyos, tan nganngani samet di kateyak,’ kanana en sisya. ");
INSERT INTO kne_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dengngem ngarud ay kosto din itogon ko en sik-a ta estem ay amagen. ");
INSERT INTO kne_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Emey ka sin pastolan tako ta pomili kas doway anak di kalding ay mankalalames. Ialim isna ta iotok din kalasin di sida ay laylayden amam ");
INSERT INTO kne_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ta iey mo en sisya ta say sik-a di bindisyonana.” ");
INSERT INTO kne_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Asi et kanan Jacob, “Aw a, ngem si Esau yan balbonan. Mo sak-en pay yan nalinis di kodil ko. ");
INSERT INTO kne_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mo komapay si ama, maammoana ay sak-en, et adi pay kananas nemnem na en owatak laslasoyen sisya et sokatana din bindisyonas baos.” ");
INSERT INTO kne_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ngem kanan ina na, “Olay sak-en di manglak-am sin baos na. Basta tongpalem din ibagak ta en ka et alan din kalding ay sana.” ");
INSERT INTO kne_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Idi siya di pinatin Jacob et ena ina, et in-oton ina na din kalasin di sida ay laylayden ama na. ");
INSERT INTO kne_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pag alan Rebeka din kasigedan ay badon Esau ay indolina sin beey et indawat na en Jacob ta say ibado na. ");
INSERT INTO kne_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ina na abe din kopkop di kalding et inlibot na sin takkay ya tenged na. ");
INSERT INTO kne_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Pag nan idawat en sisya din mam-is ay sida ya odom ay makan ay inoto na ta iey na en ama na. ");
INSERT INTO kne_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Idi indateng pay Jacob sin kad-an ama na, kanana, “Naeyak ay ama.” “Sino ka od ay anak ko?” kanan ama na. ");
INSERT INTO kne_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","“Sak-en si Esau ay besag mo. Naey di indateng ko ay sida ay intogon mo en sak-en. Ibangon mo kod ta mangan ka ta asi ka bindisyonan sak-en,” kanan Jacob. ");
INSERT INTO kne_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kanan aben ama na, “Aye! Indateng mo kayman ay dagos mo?” “Aw, tan binmadang si Yahweh ay Diyos mo,” kanan Jacob ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Asi et kanan Isaac, “Omasag-en ka ay anak ko ta kapayek sik-a ta say pangammoak mo tet-ewa ay sik-as Esau.” ");
INSERT INTO kne_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Omasag-en pay si Jacob, kinapay ama na yan kanana, “Kaman din kalin Jacob san kalim, ngem din takkay mo pay et kaman din takkay en Esau.” ");
INSERT INTO kne_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Say inbaga na di tan adi na iman naimatonan ay si Jacob begew sin balbonan ay takkay na. Bindisyonana koma, ");
INSERT INTO kne_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ngem kanana kasin ay nangipoot, “Ay si Esau ka tet-ewa?” “Aw yan,” kanan Jacob. ");
INSERT INTO kne_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“Mo siya sa, ialim san sida ta manganak ta asiak bindisyonan sik-a,” kanan ama na. Et inyaan Jacob sisya. Idi makakan si Isaac ya makainom sin arak ay in-ey Jacob, ");
INSERT INTO kne_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","kanana, “Omali kas na ay anak ko ta omongo ka.” ");
INSERT INTO kne_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Omasag-en pay si Jacob ta ongoanas sisya, sinongsong ama na din bado na yan binindisyonana ay nangwani, “Nabanglo ka kayman ay anak ko, tan din banglom et kaman din banglon di kada ay binindisyonan Diyos. ");
INSERT INTO kne_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Sapay koma ta omanay en sik-as owaoway din odan ay ibaan Diyos ay mapod daya ya mayat abe di gabay di olay sino ay is-ek mo isnan daga. Sapay koma ta paad-adoen Diyos din apitem ya ta ad-ado abey tapeyem. ");
INSERT INTO kne_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sapay koma abe ta manturay ka en daida ay man-ili sin odom ay nanasyon ta mansilbi da en sik-a. Olay din aag-im ay anak en inam et mandokmog da en sik-a, tan sik-a di mangituray abe en daida. Sapay koma abe ta mabaosan din mamaos en sik-a dowan pay mabindisyonan din mamindisyon en sik-a.” Say kanan Isaac na ay namindisyon en Jacob ay anak na. ");
INSERT INTO kne_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Idi siya di, nanlobwat si Jacob ed Beerseba ay emey ed Haran. ");
INSERT INTO kne_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nalabian sin danan, isonga nan-iyan sin esay lugar ay dinatnganas di. Nan-as bato ta say ipongana et pag bomaktad yan maseyep. ");
INSERT INTO kne_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Idi siya di nan-iitaw yan inila nay agdan ay natotood sin daga ay omdas ed langit, yan wada day anghel en Diyos ay somaksakyab ya omag-agpas sidi. ");
INSERT INTO kne_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Wada abes Diyos ay pinmipika sin kad-ana yan kanana, “Sak-en si Yahweh ay Diyos da Abraham en Isaac. Awni man et idawat ko en sik-a ya sin polim din daga ay sana ay binmabaktadam. ");
INSERT INTO kne_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Yan din polim ay sana, maad-ado da ta kaman din kaad-adon di tapok isnan daga et paannawaen da din beddeng di ili da sin amin ay banda. Manbegew abe en sik-a ya din ipolim, mabindisyonan amin di kaipoipogaw isnan lobong. ");
INSERT INTO kne_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Dadlon aben tet-ewa ay wadaak en sik-as kankanayon ta ay-ayowanak sik-a sin olay intoy em-emeyam. Asiak aben itlod sik-a ay mantaoli isnan ili ay nay. Adiak pay taynan sik-a, mo adi et tongpalek amin di inkarik en sik-a,” kanan Diyos. ");
INSERT INTO kne_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Siya et di kabangon si Jacob yan kanana, “Wada baw si Diyos sina yan adiak dinlaw sin dinmatngak.” ");
INSERT INTO kne_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Gapo ta emegyat sisya, kanana, “Inayan pay din lugar ay nay tan panbebbeeyan baw en Diyos. Adi pay isna met laeng din segpan ed langit.” ");
INSERT INTO kne_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Idi mapat-a pay, nasapas Jacob ay binmangon yan tinood na din bato ay inpongana ta say panginemnemnemana sin naamag. Asi na sinoyatan si lana ay mangidaton en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Et nginadanana din ili sin kad-ana si Betel, tan Luz din ngadana ed idi. ");
INSERT INTO kne_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Asi pag mansapata en Diyos ay mangwani, “Sik-a ay Diyos, mo komoyog ka ya omay-ayowan ka sin nay ay pandad-anak, yan mo omya ka sin makan ya bado ay kasapolak, ");
INSERT INTO kne_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ya mo laton ay mantaoliak sin beey en amak, ikarik ay sik-a anggoy ay Yahweh di Diyos ko. ");
INSERT INTO kne_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Din bato pay ay nay ay tinood kos na et say pandaydayawan di ipogaw en sik-a. Am-in abe di idawat mo en sak-en yan itaolik di inkasinpo na en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Idi inmey di esay bowan, ");
INSERT INTO kne_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","kanan Laban en sisya, “Ammok kayman ay mansin-ama ta, ngem lagboak sik-a pay dedan. Ibagam ngarud mo sinoy laydem si lagbom.” ");
INSERT INTO kne_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","17","Wada di doway anak Laban ay babassang ay da Lea en Raquel. Din pangpangoan ay si Lea, nakapoy din mata na. Mo din iyogtana pay ay si Raquel, mapmapteng di awak na yan napintas sisya. ");
INSERT INTO kne_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Gapo ta laydelayden Jacob si Raquel, kanana, “Man-oblaak en sik-a si pito ay tawen mo itay-on mo ay asawaek si Raquel.” ");
INSERT INTO kne_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kanan pay Laban, “Agpos et kayman mo sik-a di mangasawa mo din odom ay ipogaw. Olay isna ngarud di panteteam ay man-obla.” ");
INSERT INTO kne_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Isonga pito ay tawen di nan-ob-oblaan Jacob ta way iyat na ay mangasawa en Raquel, ngem kaman owat sinkaattikan ay agew din panlikna na begew sin layad na en sisya. ");
INSERT INTO kne_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Asi pag kanan Jacob en Laban, “Idawat mo et en sak-en din anak mo ta ibeey kos sisya, tan nakdeng din tawen ay tolagan ta.” ");
INSERT INTO kne_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Siya di et inayagan Laban am-in din kailiana ta manpalti da sin kasal di anak na. ");
INSERT INTO kne_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ngem sin siya di ay labi, imbis ta si Raquel di ipasgep na koma sin kad-an Jacob ta say daagena, inpasgep nas Lea. Et dinaag Jacob sisya. ( ");
INSERT INTO kne_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Indawat aben Laban en Lea di esay bag-ena ay balasang ay si Zilpa ta say kabadang na.) ");
INSERT INTO kne_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Idi bomangon pay si Jacob sin napat-aana, kambaw si Lea di wada. Isonga inmey si Jacob en Laban yan kanana, “Apay nga say inyat mo di? Si Raquel met di inlagboak. Apay nga sinikapam sak-en?” ");
INSERT INTO kne_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kanan Laban ay sinombat, “Baken min ogali kayman isna ay pangon-onaen ay mangiasawa sin iyogtan mo din pangpangoan. ");
INSERT INTO kne_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Awni ta malabas din dominggo ay nay ta makdeng din palpaltien mi para sin kasal. Asiak aben idawat si Raquel en sik-a ta asawaem, dalo et mo man-obla kas pito kasin ay tawen.” ");
INSERT INTO kne_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Inaw Jacob din kanan Laban ay sana, et idi nakdeng din makadominggo ay doy, indawat Laban din anak na ay si Raquel en sisya ta asawaena. ( ");
INSERT INTO kne_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Indawat na abe en Raquel din bag-ena ay balasang ay si Bilha ta say kabadang na.) ");
INSERT INTO kne_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Et dinaag aben Jacob si Raquel, et say laylaydena mo si Lea. Asi pag man-obla en Laban si pito kasin ay tawen. ");
INSERT INTO kne_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Idi siya di, ninemnem Diyos si Raquel. Sinongbatana din kararag na et mabalin ay man-anak sisya. ");
INSERT INTO kne_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Et doy ay nanliton, et idi bemela yan lalaki. Asi kanan Raquel si ragsak na, “A siya, kinaan Diyos di kaibabainak tan inyaanas sak-en si anak.” ");
INSERT INTO kne_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Siya di nginadanana din anak na ay doy si Jose ay mangwani, “Sapay koma ta tapian Diyos din anak ay nay si esa pay ay lalaki.” ");
INSERT INTO kne_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Idi nakdeng ay naianak si Jose, kanan Jacob en Laban, “May, palobosam kod sak-en ta somaaak sin ilik. ");
INSERT INTO kne_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Palobosam aben asawak ya din an-ak mi ay in-ob-oblaak sin nansilsilbiak en sik-a ta somaa kami. Ammom met damdama di kasiged di inyaat ko ay nansilsilbi en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Idi wada pay da Jacob sin danan, waday aanghel ay nangabet en daida. ");
INSERT INTO kne_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Idi inilan Jacob, kanana, “Da naey baw din sosoldadon Diyos.” Et nginadanana din lugar ay doy si Mahanaim. ");
INSERT INTO kne_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Idi siya di, wada day bag-en ay inpaon-onan Jacob ed Edom ay kad-an di pangpangoana ay si Esau. ");
INSERT INTO kne_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Tinogonas daida ay nangwani, “Ibaga yo sin pangpangoan ko en naey di ipadamag Jacob ay mansilsilbi en sisya ay apo na. Ibaga yo abe en nakitetteeak en da Laban enggana ed wani tan nataktakak si nabayag sidi. ");
INSERT INTO kne_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ibaga yo pay en nabaknangak si baka, dangki, karnero, kalding, ya babag-en. Asi yo ibaga en enggay ninas ipadamag ko en sisya ay apok ta mo mabalin koma, siged di nemnem na en sak-en.” ");
INSERT INTO kne_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Inmey din babag-en ay en nangibaga en Esau sin inbilin Jacob en daida. Idi nantaoli da pay, kanan da ay nangisodsod, “Inabat mi din pangpangoan mo sin danan. Omon-onod ay ena abten sik-a ay mangoykoyog si opat ay gasot ay lalaki.” ");
INSERT INTO kne_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Idi dinngen Jacob din insodsod da ay sana, peteg ay inmegyat ya madanagan, isonga ginodwa na din kabeweg na pati din animal na et nansianenas daida, ");
INSERT INTO kne_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","tan ninemnem na ay mo labanen Esau din esay grupo, mabalin ay makalayaw din esay grupo. ");
INSERT INTO kne_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Makdeng pay di, nankararag ay nangwani, “Sik-a ay Yahweh ay Diyos apok ay Abraham ya si amak ay Isaac, dengngem kod nan kedawek, tan sik-a met laeng di nangibilin en sak-en ay mantaoliak sin kosto ay ilik ya toton-od ko ta asi ka pasigeden biyag ko. ");
INSERT INTO kne_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Adiak maikari sin dakdake ay tolong ay indawdawat mo en sak-en ay mansilsilbi en sik-a. Ngem tinmolong ka pay dedan, tan sin nan-agadangak sin ginawang ay Jordan ed idi, sokod anggoy di itaktakin ko. Ed wani pay et doway grupon di ipogaw ya gamgameng ko di wada. ");
INSERT INTO kne_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Itoloy mo ngarud san tolong mo ta salaknibam dakami en Esau ay pangpangoan ko, tan nay ay omal-ali yan emegyatak tan mo et peslenas dakami am-in, pati din sin-iin-a. ");
INSERT INTO kne_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ngem sik-a pay, inkarim ay pasigedem biyag ko ya paad-adoem aben polik ta kaman din kaad-adon di darat sin benget di baybay.” ");
INSERT INTO kne_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Idi nakdeng ay nankararag si Jacob, pinmili sin animal na ay idawat na en Esau, ");
INSERT INTO kne_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","21","et inpaon-ona na sin odom ay babag-ena, tan kanana en say iabog na en sisya ta balbalang mo pasinsiyaanas sisya sin pan-abtan da. Mo si Jacob pay, nantettee sin pankampoan da sin kad-an di ginawang ay Jabbok. ");
INSERT INTO kne_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Idi daan pay laeng mapat-a sin siya di ay labi, binmangon si Jacob et inayagana din doway asawa na ya din doway bag-ena ay babai ya din sinpo ya esa ay anak na ta ipaagadang nas daida sin ginawang ay sana. ");
INSERT INTO kne_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Asi na aben ipaagadang am-in din nabay-an ay gamgameng na ");
INSERT INTO kne_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","et nataynan sisya ay eng-enggay na. Idi siya di, wada et di sinmawang ay lalaki ay nakidama en sisya engganas dandani ay mapat-a. ");
INSERT INTO kne_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Idi pasalen din lalaki ay sana ay adi makaabak en Jacob, kadespeg sin lipad na et naikomsiw. ");
INSERT INTO kne_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Asi na kanan, “Omibolos ka kod, tan enggay mapatpat-a.” Ngem kanan Jacob, “Sigaak, adiak ibolos sik-a enggana ay bindisyonam sak-en.” ");
INSERT INTO kne_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“Sinoy ngadan mo?” kanan din lalaki. “Si Jacob,” insongbat na. ");
INSERT INTO kne_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Pag kanan din lalaki, “Manlogi ed wani, baken Jacob di ngadan mo mo adi et Israel, tan ed idi way inabak mo ay ib-am ay ipogaw, yan ed wani abe, nakidama ka en Diyos yan nangabak ka.” ");
INSERT INTO kne_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kanan pay Jacob, “Ibagam kod abe din ngadan mo.” Ngem kanan din lalaki, “Dakey, adi ka damdamagen ngadan ko.” Asi na pag bindisyonan si Jacob et madipos. ");
INSERT INTO kne_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Et nginadanan Jacob din lugar ay sanas Peniel, tan kanana, “Nansango kami baw en Diyos, yan matmatagoak pay laeng.” ");
INSERT INTO kne_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Maag-aggew sin kinmaanan Jacob ed Peniel, yan manpilpilay ay mandad-an begew sin naikomsiw ay lipad na. ");
INSERT INTO kne_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Say gapo na ay mo way paltien din Israelita, adi da isida sin lamlames di lipad enggana ed wani, tan din lamlames ay sana din dinespeg di kinadaman Jacob. ");
INSERT INTO kne_vpl VALUES ("GN35_22b","002_35_22b","GEN","35","22b","22b","Da naey di ngadngadan di sinpo ya dowa ay anak en Jacob. ");
INSERT INTO kne_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Din in-anak en Lea et si Ruben (ay din besag en Jacob), si Simeon, si Levi, si Juda, si Issakar, ya si Zebulun. ");
INSERT INTO kne_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Din in-anak pay en Raquel et da Jose en Benjamin. ");
INSERT INTO kne_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Din in-anak abe en Bilha ay bag-en Raquel et da Dan en Naftali. ");
INSERT INTO kne_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Din anak abe en Zilpa ay bag-en en Lea et da Gad en Aser. Am-in din anak Jacob ay sana et naianak da ed Mesopotamia. ");
INSERT INTO kne_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Intoloy da Jacob ay nanbeey ed Canaan ay ilin ama na ed idi. ");
INSERT INTO kne_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Naey pay di dad-at ay maipanggep sin naamag sin an-ak na ya ap-o na ay manlogi sin napasamak en Jose. Idi mantawen si Jose si sinpo ya pito, nakikoykoyog sin aag-i na ay din an-ak en da Bilha en Zilpa ay asawan ama na. Daida di mangay-ayowan sin karnero ya kalding da. Yan waday insodsod na en ama na maipanggep sin inam-amag da ay lawa. ");
INSERT INTO kne_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Si Israel pay, say laylaydena ay anak si Jose, tan say naianak sin enggay nakayana. Siya di waday inpaamag na ay nagayad ya naaltian ay bado et indawat na en Jose. ");
INSERT INTO kne_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Idi inammoan din aag-i na ay sisya di laylayden ama da, kaliliget das sisya, isonga kabobonget di iyat da ay makingalat en sisya. ");
INSERT INTO kne_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sin namingsan, waday iniitaw Jose yan dinad-at na sin aag-i na ");
INSERT INTO kne_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ay nangwani, “Dengngen yo kod nan iniitaw ko. ");
INSERT INTO kne_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Wada tako kano am-in sin payew ay manlablabed sin inani tako yan natood kano din nilabed ko. Din nilabed yo pay kano yan nilikob da din nilabed ko et nandokmog da en sisya.” ");
INSERT INTO kne_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sin nanngean das di, kanan din aag-i na ay sana, “Ay kanam en manbalin kas ari ta iturayam dakami? Ay ado paabe na!” Et nasepsep ay malmaliget da en sisya begew din iniitaw na ay sana ya din inbaga na maipanggep sidi. ");
INSERT INTO kne_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Idi siya di, nan-iitaw kasin si Jose yan kasinan dinad-at sin aag-i na. Kanana, “Wada di kasinak iniitaw, yan inilak kano din agew ya din bowan ya sinpo ya esa ay talaw ay nandodokmog en sak-en.” ");
INSERT INTO kne_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Dinad-at na abe din iniitaw na ay sana en ama na, ngem niyamyaman ama na ay nangwani, “Ay maney pay sas iitaw! Ay kanam en dakami en inam ya din aag-im yan mandokmog kami en sik-a?” ");
INSERT INTO kne_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Siya di inapalan din aag-i nas sisya, ngem nemnenemnemen ama na mo sinoy layden ay kalien din iniitaw Jose ay sana. ");
INSERT INTO kne_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Waday namingsan ay inmey din aag-in Jose ed Sekem ta en da ipastol din animal das di. ");
INSERT INTO kne_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kanan Jacob en Jose, “Laydek ay emey ka ed Sekem ay pangipaspastolan di papangoam sin karnero ya kalding.” “Aw adi,” kanana ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","“En ka ilaen mo laton ay maga di napasamak en daida ya din pastol da. Asi ka mantaoli ay en mangibaga en sak-en,” kanan ama na. Et inpalobwat nas Jose sin tanap ed Hebron ay emey ed Sekem. Somawang pay ed Sekem, ");
INSERT INTO kne_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","inilan di esay lalakis sisya ay lomikeliked sin kad-an di pastolan, yan kanana, “Sinoy an-anapem?” ");
INSERT INTO kne_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“An-anapek din aag-ik ay mangipaspastol sin karnero ya kalding da. Ay ammom di kad-an da?” kanan Jose ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kanan pay din lalaki, “Enggay nadipos da met, ngem didinngek ay kanan da en emey da ed Dotan.” Siya et di, inkanayon Jose ay emey ed Dotan, et dintengana din aag-i nas di. ");
INSERT INTO kne_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Idi tinamang das sisya ay omas-asag-en, nantotolag din odom ay peslen da. ");
INSERT INTO kne_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kanan da, “Sana din ad-adoy iitaw na. ");
INSERT INTO kne_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Peslen tako et ta egasen tako sin esay bobon. Mabalin ay kanan tako en pinsen di maangat ay animal. Asi tako ilan mo siya ay temet-ewa din iniitaw na.” ");
INSERT INTO kne_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ngem idi dinngen Ruben ay pangpangoan da din plano da ay sana, inandiyana ay nangwani, “Adi tako peslen damdama! ");
INSERT INTO kne_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Olay egasen tako anggoy sin bobon ay nay isnan lugar ay magay omili, tan lawa mo sakitan tako.” Say inbaga na di, tan panggep na ay ena enaten si Jose sin bobon ta ipasaa na en ama na. ");
INSERT INTO kne_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Domateng pay si Jose sin kad-an di aag-i na, kagamdot da en sisya et kakaan da sin naaltian ay bado na. ");
INSERT INTO kne_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Pag da en egasen sin bobon ay sana ay iwed danom na. ");
INSERT INTO kne_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Makdeng pay di, tinmokdo da ay mangan. Ngem magas Ruben tan waday inmeyana. Idi mangmangan da, tinamang day grupon di ipogaw ay polin Ismael ya polin Midian ay omas-asag-en ay napod Gilead. Nakakargaan din kamel das nangina ay kalkalasin di bangbanglo ya balsamo ay en da ilako ed Egipto. ");
INSERT INTO kne_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Siya di, kanan Juda, “Magay pansigdan tako met mo peslen takon iyogtan tako ya asi tako isaot din inyat na ay natey. ");
INSERT INTO kne_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Olay ilako tako et sin polin Ismael ay doy da ta adi tako peslen, tan iyogtan tako met dedan ay anak ama tako.” ");
INSERT INTO kne_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Inaw din aag-in Juda din inbaga na ay sana. Idi dinmateng din man-ilaklako ay doy, innat das Jose sin bobon et inlako da en daidas dowanpo ay palata et intakin da ed Egipto. ");
INSERT INTO kne_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mantaoli pay si Ruben sin bobon ay napo sin inmeyana, naiwed si Jose. Kabisngit sin bado na tan palalo ay mansakit nemnem na. ");
INSERT INTO kne_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Pag en maitapi sin aag-i na yan kanana, “Naiwed si iyogtan tako ngay! Intoy iyat ko pay?” ");
INSERT INTO kne_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Idi siya di, pinse day kalding et insiblaw da din nagayad ay badon Jose sin dada na. ");
INSERT INTO kne_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pag dan paiey en ama da yan inpaibaga da ay mangwani, “Dinteng mi nan nagayad ay bado. Biliem kod mo siya na din badon di anak mo.” ");
INSERT INTO kne_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Naimatonan ama da ay dagos yan kanana, “Siya met! Ay kambaw binisngibisngit ya kinan di maangat ay animal si Jose ay anak ko!” ");
INSERT INTO kne_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kabisngit sin mismo ay bado na et manbados naamag si sako ta ipaila nay sakit di nemnem na. Nabayag ay inladingitanas Jose. ");
INSERT INTO kne_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Olay mo inmali am-in di anak na ay en mangliwliwa en sisya, siya met laeng ay adi kaliwliwa, tan kanana, “Bay-an yo, itoltoloy ko ay mangiladingit sin anak ko engganay mateyak ya maitapiak en sisya sin kad-an di ab-abiik di natey.” ");
INSERT INTO kne_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sin siya di ay timpo, tinaynan Juda din aag-i na ay lallalaki sin kadondontogan et en nanbeey sin asag-en di lalaki ay taga-Adullam ay manngadan si Hira. ");
INSERT INTO kne_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Isdi ay inilan Juda di Canaaneo ay babai ay anak Sua et inasawa na. ");
INSERT INTO kne_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nawad-an et in-anak na di lalaki ay nginadananas Er. ");
INSERT INTO kne_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nan-anak kasin si esay lalaki yan nginadananas Onan. ");
INSERT INTO kne_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nan-anak pay kasin si esa ay lalaki yan nginadananas Sela. Wada da ed Akzib sin nangianakana. ");
INSERT INTO kne_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Inpaasawan Juda di esa ay babai ay manngadan si Tamar sin inoona ay anak na ay si Er. ");
INSERT INTO kne_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ngem lawlawa di ogalin Er sin pangilan Diyos, isonga pinse nas sisya. ");
INSERT INTO kne_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pag kanan Juda en Onan, “Asawaem din tinaynan di pangpangoan mo, tan siya met di lebbeng na ay amagem ay bayaw na ta man-ipotot ka para sin natey ay pangpangoan mo.” ");
INSERT INTO kne_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ngem gapo ta ammon Onan ay adi maibilang ay anak na din ipotot na, ipogit na sin lota din similya na mo mandaag da en Tamar ta adi na ipototan din pangpangoana. ");
INSERT INTO kne_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Basol sin pangilan Diyos din doy ay am-amagen Onan, isonga pinse na abes sisya. ");
INSERT INTO kne_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Idi siya di, kanan Juda en Tamar ay innapo na, “Somaa ka pay laeng sin beey amam, ngem adi ka makias-asawa ta sed-em ay madakdake si Sela.” Say kanana di tan madandanagan into et mo matey abes Sela ay kaman din pangpangoana. Et sinmaas Tamar sin beey da ama na. ");
INSERT INTO kne_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Idi malabas di katawetawen, natey din anak Sua ay asawan Juda. Makdeng pay din timpo ay nangiladladingitanan asawa na, nantikid ed Timna ay panpokpokisan da si karnero na. Nankoyog da sin gayyem na ay si Hira ay taga-Adullam. ");
INSERT INTO kne_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Idi nadamag Tamar ay inmey din katogangana ed Timna ta en da manpokis sin karnero na, ");
INSERT INTO kne_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","sinokatana din bado na ay badon di balo. Kinomotana din ropa na yan en tinmokdo sin segpan di ili ay Enaim ay say danan ay emey ed Timna. Say ninemnem na di, tan ammo na ay enggay nadakdake si Sela, ngem adi pay laeng ipaasawan Juda en sisya. ");
INSERT INTO kne_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Idi inilan Juda sisya, inpagarup na en esa ay hostess, tan kinomotana din mata na. ");
INSERT INTO kne_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Et sinmag-en si Juda en sisya sin igid di kalsada yan tinolag na ay mandaag da, tan adi na inmatonan ay sisya baw din innapo na. Pag kanan Tamar, “Sino ngin di idawat mon sak-en ta asi ta mandaag?” ");
INSERT INTO kne_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kanan Juda, “Ibaak to di mangidawat en sik-a si anak di kalding ko.” Songbatan pay Tamar yan kanana, “Laydek mo omya ka si mangipasigurado ay idawat mo sa.” ");
INSERT INTO kne_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Idi sinalodsod Juda mo sinoy laydena ay alaen, say kindaw na din singsing, bilko ya din baston Juda. Indawat na dadi et nandaag da yan nasikogan si Tamar. ");
INSERT INTO kne_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Idi sinmaas Tamar, kinaana din in-abbong nas ropa na yan inosal na kasin din badon di nalasang. ");
INSERT INTO kne_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Idi inbaan Juda si Hira ta ena idawat din kalding ya taoliena din singsing, bilko ya baston, iwed si Tamar ay dintengana. ");
INSERT INTO kne_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nandamag si Hira sin lallalaki ed Enaim yan kanana, “Into din hostess ay doy ay manseseed sin segpan di ili?” Ngem kanan da, “Maga met di hostess isna.” ");
INSERT INTO kne_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Isonga nantaoli sin kad-an Juda yan kanana, “Iwed met din babai ay nadtengak yan kanan abe din omilis di en maga polos di kaman nidi di obla na ay babai sin isdi.” ");
INSERT INTO kne_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Pag kanan Juda, “Mo siya sa, olay bay-am ta oka na din ina na ay pakasiguradoana, tan adi pay somiyek da et di ipogaw. Olay tan inpaitolod ko met din anak di kalding ay nay yan magas sisya.” ");
INSERT INTO kne_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Malabas pay di tolo ay bowan, waday nangipadamag en Juda ay masikog si Tamar tan nakikamalala. Inbilin ngarud Juda ay ibela das Tamar ta pooan da. ");
INSERT INTO kne_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Idi inbela das Tamar, waday inpaibaga na sin katogangana ay kanana, “Din akin oka isnan singsing, bilko ya baston yan say aman din sikog ko ay nay. Imatonam kod mo sinoy akin oka en dana.” ");
INSERT INTO kne_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Asi pag imatonan Juda ay oka na dadi et kanana, “Nalinlinteg iman din babai ay doy mo sak-en, tan adiak iman inpaasawas Sela ay anak ko en sisya.” Et adi na kasin dinaag si Tamar. ");
INSERT INTO kne_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Idi domteng din timpo ay pan-anakan Tamar, naammoan ay singin din sikog na. ");
INSERT INTO kne_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Sin panpalpaligatana, inpabelan din esay moyang din takkay na et tinngel din manpapaanak din takkay na ay sana, pag nan galotan si manbalanga ay sinolid. Kanana, “Sinay di nangon-ona.” ");
INSERT INTO kne_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ngem innat din moyang din takkay na yan namangpango din kasingina. Et kanan din manpapaanak ay masmasdaaw, “Apay nga sik-a et di nangon-ona?” Et nginadananas Perez. ");
INSERT INTO kne_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Pag omonod din nagalotan di takkay nas manbalanga ay sinolid et nginadanan das Zera. ");
INSERT INTO kne_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mo si Jose pay, indateng din polin Ismael ed Egipto et inlako das sisya en Potifar ay kapitan di gogowardiyan di ari. ");
INSERT INTO kne_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Gapo ta wadas Diyos en sisya, siged di pantongpalan di olay sino ay am-amagena yan nakitettee sin beey di among na. ");
INSERT INTO kne_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Idi inilan Potifar ay wadas Diyos en sisya ay mangipaspasiged sin pantongpalan di amin ay am-amagena, ");
INSERT INTO kne_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","napnek en sisya, yan dinotokanas sisya ay kakoykoyog ya kabadang na. Intalek na abe en sisya din beey na ya am-in di gamgameng na ta sisya di makaammo. ");
INSERT INTO kne_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nanipod sidi, binindisyonan Diyos si Potifar ya am-in da ay bemeey begew en Jose, yan pinasiged na ya inpaad-ado na amin di gamgameng na sin beey na ya daga na. ");
INSERT INTO kne_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Gapo ta intalek Potifar en Jose am-in di gamgameng na, maga di masapol ay nemnemnemena powiray makan. Asi et gowapo abe si Jose yan mapmapteng di awak na. ");
INSERT INTO kne_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Isonga baken nabayag yan inaklongan asawan Potifar sisya yan kanana, “En ta mandaag.” ");
INSERT INTO kne_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngem sigaana ay nangwani, “Lawa damdama na! Ammom ay maga di siyat asikasoen among ko sin beey ay nay mo wadaak isna, tan dinotokana od sak-en ay makaammo sin am-in ay gamgameng na. ");
INSERT INTO kne_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nais-o abe din lebbeng ko sin beey ay nay sin lebbeng na yan maga met iman di kinayyawana en sak-en powiras sik-a, tan sik-a di asawa na. Isonga adi mabalin ay amagek san lawa ay ibagbagam, tan bomasolak en Diyos.” ");
INSERT INTO kne_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Yan olay mo ipilit din asawan Potifar ay mangawis en sisyas inag-agew, inpapasnek na pay dedan ay manigaan ya adi aben makikadkadwa en sisya. ");
INSERT INTO kne_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Idi siya di, waday namingsan ay sinenggep si Jose sin beey ta amagena din obla na, yan kambaw maga di odom ay bag-en sidi. ");
INSERT INTO kne_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Siya et di kaipakod din asawan Potifar sin bado na yan kanana, “En ta mandaag ay!” Ngem katagtag si Jose et binmela, isonga nataynan din bado na sin takkay din babai. ");
INSERT INTO kne_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Idi inilan din babai ay tinaynana din bado na sin nanagtagana ay binmela, ");
INSERT INTO kne_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kaayag sin babag-ena yan kanana en daida, “Ilaen yo kadi! In-alin asawak san Hebreo ta ibabbainas datako! Sinenggep isnan kowartok ta pilitena komas sak-en, ngem nankilaladak. ");
INSERT INTO kne_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Idi siya di, katagtag ay binmela, ngem kambaw tinaynana din bado na ay nay sin kad-ak.” ");
INSERT INTO kne_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Indolin din babai din bado ay doy sin kad-ana engganay sinmaas Potifar ay among Jose. ");
INSERT INTO kne_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Asi na aben isodsod en sisya ay nangwani, “Din doy bag-en ay Hebreo ay in-alim sina, sinenggep sin kowartok ta pilitena komas sak-en. ");
INSERT INTO kne_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ngem nankilaladak, isonga katagtag ay binmela yan tinaynana din bado na ay nay sin kad-ak.” ");
INSERT INTO kne_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Idi dinngen din among Jose din insodsod asawa na, palalo di bonget na. ");
INSERT INTO kne_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kaipadpap en Jose et kaipabalod sin kad-an di balod di ari. Et say nantetteana. ");
INSERT INTO kne_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngem olay sin balodan, wada pay si Diyos en sisya ay mamadbadang, isonga mapnek din gowardiya en sisya. ");
INSERT INTO kne_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Inpolang na ngarud en Jose din gagait na ay balod ya din amin ay maamag sin balodan. ");
INSERT INTO kne_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Siya di, basta obla ay naitalek en Jose, adi masapol ay asikasoen din gowardiya, tan wadas Diyos en Jose ay mamadbadang en sisya, isonga siged amin di pantongpalan din am-amagena. ");
INSERT INTO kne_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Idi nabaybayag, waday doway opisyal di ari ed Egipto ay binmasol en sisya, ay din ap-apon di mantagtagay si tapey ya din ap-apon di man-ot-otos tinapay. Isonga inbonget nas daida ");
INSERT INTO kne_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","et inpabalod na sin balodan ay partin di beey di kapitan di gowardiya ay kad-an Jose met laeng. ");
INSERT INTO kne_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Gapo ta nangato ay opisyal din dowa ay nay, dinotokan din kapitan si Jose ay mansilbi en daida. Idi nabaybayag da sin balodan, ");
INSERT INTO kne_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","waday esay labi ay nan-iitaw da ay dowa, yan ammo da ay way layden din iniitaw da ay kalien. ");
INSERT INTO kne_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Idi mapat-a, inmey si Jose sin kad-an da. Inila na ay madandanagan da ");
INSERT INTO kne_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","yan kanana en daida, “Apay nga mansasadot kayo ed wani?” ");
INSERT INTO kne_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“Aw ngarud, tan nan-iitaw kami ay dowa ed labi, yan maga polos di makaiolog sin layden di iitaw mi ay kalien,” kanan da. “Si Diyos anggoy di mangidawat si laing ay mangiolog sin iitaw. Ibaga yo kod en sak-en din iniitaw yo ay sana,” kanan Jose. ");
INSERT INTO kne_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nangon-ona din mantagtagay ay nandad-at yan kanana, “Siya na din iniitaw ko. Wada kanoy wakan di obas sin sangok ");
INSERT INTO kne_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ay toloy panga na. Idi katobtobo na, nanbonga yan nanlames. Sinkaattikan abe yan naom din lames na. ");
INSERT INTO kne_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Gapo ta iin-genak baw din tasan di ari, pinogopog ko din obas yan inpespes ko din danom na sin tasa ay sana. Asiak en itagay sin ari. Siya sa di iniitaw ko.” ");
INSERT INTO kne_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","“Siya na di olog na,” kanan Jose ay nanongbat. “Din toloy panga na ay doy yan toloy agew di, ");
INSERT INTO kne_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","tan mo malabas di toloy agew, pasinsiyaan daka sin ari yan pataolien daka sin sigod ay oblam ta kasin kan itagtagay din inomena ay kaman din inyaat mo ed idi. ");
INSERT INTO kne_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mo kasin pay somiged di biyag mos di, pangaasim kod ta nemnemem sak-en yan ibagam kod sin ari din maipanggep en sak-en ta mo mabalin koma, ibolosanas sak-en sin balodan ay nay. ");
INSERT INTO kne_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tan pilit ay inmitagtag da dedan sin ilin di Hebreo, yan olay isnan ed Egipto, maga polos di inamag ko si omanay si maibalodak,” kanan Jose. ");
INSERT INTO kne_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Idi dinngen din ap-apon di man-ot-otos tinapay din siged ay olog di iitaw di kadwa na, kanana abe en Jose, “Mo din iniitaw ko pay, wada kanoy tolo ay baskit ay napay-an si tinapay ay inaagtok. ");
INSERT INTO kne_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Din nakin kayang et napnos am-in ay kalasin di tinapay ay para sin ari. Asi et wada baw di titit ay mangmangan sin tinapay ay sana.” ");
INSERT INTO kne_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kanan aben Jose, “Din olog aben di iniitaw mo et siya na. Din toloy baskit yan toloy agew met laeng, ");
INSERT INTO kne_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","tan mo emey di toloy agew, ipapoton din ari din toktok mo. Asi daka ibay-at sin posti et kanen di titit din lamlames mo.” ");
INSERT INTO kne_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sin maikatlo ay agew, nanpalti din ari ta silibrarana din agew ay naianakana, et inpaayag na am-in di tuturay di ili. Asi na aben ipaayag sin kad-an da din ap-apon di mantagtagay ya din ap-apon di man-ot-otos tinapay. ");
INSERT INTO kne_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Din ap-apon di mantagtagay, pinataoli na tet-ewa sin sigod ay obla na. ");
INSERT INTO kne_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mo din kadwa na pay, inpabay-at na sin posti. Et natongpal am-in din kanan Jose. ");
INSERT INTO kne_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Asi et dadlon nilinglingan din ap-apon di mantagtagay si Jose. ");
INSERT INTO kne_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Malabas pay di doway tawen, nan-iitaw abe din ari ed Egipto. Wada kanos sisya ay pinmipika sin benget di ginawang ay Nile, ");
INSERT INTO kne_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","yan inila na kanoy pito ay baka ay malames ya mankanapteng ay binmela sin danom, et man-alab das di. ");
INSERT INTO kne_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Idi siya di wada kasin di pito ay baka ay binmela, ngem nabigobigot da ay mabilang din tatadlang da. Inmey da kano sin kad-an di pito ay mankalalames, ");
INSERT INTO kne_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","yan kakan da sin mankalalames ay sana. Pag igibek din ari. ");
INSERT INTO kne_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Idi kasin naseyep sisya, nan-iitaw kasin, yan inila na kanoy pito ay leg-ey sin esay poon ay namoslingan di lames na. ");
INSERT INTO kne_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Maaw-awni kano abe yan sinmimit ya ginmabay di pito abe ay leg-ey ay nanakpes di lames na tan kinset di man-atong ay dagem. ");
INSERT INTO kne_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Yan kaikom-ot da sin namoslingan di lames na. Asi kasin bomangon din ari yan kambaw iitaw anggoy. ");
INSERT INTO kne_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Idi mapat-a pay, madandanagan sisya, isonga inpaayag na am-in din nalaing ay manpontos ya mankotom sin ili da ed Egipto ta damagena en daida mo sinoy layden din iitaw na ay kalien. Ngem idi dinad-at na en daida, maga di makaibaga sin olog na en sisya. ");
INSERT INTO kne_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Idi siya di, kanan din mantagtagay, “Apo Ari, manemnem ko din nankolangak ed idi. ");
INSERT INTO kne_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Inbonget mos sak-en ya din ap-apon di man-ot-otos tinapay. Et inpabalod mos dakami sin kad-an di beey di kapitan di gowardiya. ");
INSERT INTO kne_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Waday esay labi ay nan-iitaw kami ay dowa yan ammo mi ay waday layden din iniitaw mi ay kalien. ");
INSERT INTO kne_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wada abey baro ay Hebreo ay bag-en di kapitan di gowardiya ay naitapian mi sin balodan. Idi dinad-at mi en sisya din iniitaw mi, inbaga na din laydena ay kalien. ");
INSERT INTO kne_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yan natongpal iman din inbaga na, tan mo sak-en yan inmipataoli ka sin sigod ay oblak, ngem din kadwak pay et inpabay-at mos sisya.” ");
INSERT INTO kne_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Idi dinngen din ari din inbagan di mantagtagay ay sana, inpaayag nas Jose et dalasen da ay en mangibolos sin balodan. Idi nanpapokis ya nansokat pay sisya, sinenggep sin kad-an di ari. ");
INSERT INTO kne_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kanan din ari, “Waday iniitaw ko, yan maga polos di makaiolog. Isonga inpaayag kos sik-a tan basta dengngem kano di iitaw yan ammom di laydena ay kalien.” ");
INSERT INTO kne_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Sinombat si Jose yan kanana, “Adiak kabaelan, ngem si Diyos pay et kabaelana ay mangiolog ay kosto.” ");
INSERT INTO kne_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pag kanan din ari, “Din iitaw ko pay et pinmipikaak kano sin benget di ginawang ay Nile, ");
INSERT INTO kne_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","yan inilak di pito ay baka ay mankalalames ya mankanapteng ay binmela sin danom, et ilogi da ay man-alab sin benget di ginawang. ");
INSERT INTO kne_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ngem siya et di, wada kasin di pito ay baka ay binmela, ngem nabigobigot da ay mabilang tadlang da. Lawlawa da ay baka. Maga polos di inil-ilak si kaman dadi sin intiro ay Egipto. ");
INSERT INTO kne_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Din doy da ay nabigobigot ay baka, kakan da sin mankalalames, ");
INSERT INTO kne_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ngem maga di kailasinana ay kinan da, tan siya met laeng ay nabigobigot da. Pagak igibek. ");
INSERT INTO kne_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Idi naseyepak kasin, nan-iitawak kasin yan inilak kanoy pito ay leg-ey sin esay poon ay namoslingan di lames na. ");
INSERT INTO kne_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Maaw-awni abe yan sinmimit ya ginmabay di pito abe ay leg-ey ay nanakpes di lames na tan kinset di man-atong ay dagem. ");
INSERT INTO kne_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Asi kaikom-ot da sin namoslingan di lames na. Dinad-at ko din doway iitaw ko ay nay sin nalalaing ay manpontos, ngem maga en daida di makaiolog.” ");
INSERT INTO kne_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kanan pay Jose, “Apo Ari, inpaiitaw Diyos en sik-a din doway iitaw mo ay sana ta maammoan din amagenan to. Man-iso di olog da ay dowa. ");
INSERT INTO kne_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Din pito ay baka ay malames ya din pito ay leg-ey ay namoslingan di lames na et pito ay tawen din olog dadi. ");
INSERT INTO kne_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Din pito abe ay baka ay nabibigot ya din pito ay leg-ey ay kinset di dagem et pito ay tawen di betil. ");
INSERT INTO kne_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kaman met laeng din inbagak ed kaonyan, ay inpaammon Diyos en sik-a din amagenan to. ");
INSERT INTO kne_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tan wadan to di pito ay tawen ay aped na ay ad-adoy lames di molmola ya kakaiw sin intiro ay ili ay Egipto. ");
INSERT INTO kne_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Asi maisokat di pito abe ay tawen ay betil, et maliw-an din siged ay biyag sin nangon-ona ay tawen, tan enggay maabosan din ili ay nay si makan. ");
INSERT INTO kne_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Et adi manemnem din kinabaknang di ili sin nangon-ona ay tawen, tan palalo ay kaeegyat din betil ay maodi. ");
INSERT INTO kne_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Siya sa din olog di iitaw mo. Din nangipidwaam abe ay nan-iitaw, laydena ay kalien en enggay kineddengan Diyos din maamag ay nay yan adi aben mabayag di katongpalana. ");
INSERT INTO kne_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Isonga din iyat mo koma ay apo, man-ila kas nanemneman ya nalaing ay ipogaw ta say makaammo sin ili ay nay. ");
INSERT INTO kne_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mandotok ka abes tuturay ay en mansingil sin inkaliman di anien di ipogaw sin omali ay pito ay tawen ay siged di apit. ");
INSERT INTO kne_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Iyaam abe daida si lebbeng da ay mangiolnong sin inkalima ay sana ta idolin da ya bantayan da sin inil-ili. ");
INSERT INTO kne_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tan mo say iyat mo di, mawaday reserba takos makan yan maga di madagaangan mo domteng din pito ay tawen ay betil,” kanan Jose. ");
INSERT INTO kne_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Idi siya di, inaboloyan din ari ya din tuturay di ili din planon Jose ay sana ");
INSERT INTO kne_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","yan kanan din ari en daida, “Magan samet di datngen takos odom ay ipogaw ay kawadaan di Ispiriton di Diyos.” ");
INSERT INTO kne_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pag nan kanan en Jose, “Sik-a met laeng di nangipaammoan Diyos sin amin dana, isonga magan samet di mas nanemneman ya nalaing mo sik-a. ");
INSERT INTO kne_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Sik-a ngarud di makaammo sin tuturay ko ay nay, ya am-in abe di ipogaw ko et patien da din ibagam. Sak-en anggoy di nangatngato mo sik-a. ");
INSERT INTO kne_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Et nay dotokak sik-a ay man-gobernador isnan intiro ay ili ay Egipto.” ");
INSERT INTO kne_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Sin nangwanian di aris di, kinaana din singsing na ay naigolitan di malkan di ari et inpeey na sin gomot Jose. Nanbadoena abe sin kasisigedan ay nagayad ay bado yan kinekeanas balitok. ");
INSERT INTO kne_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Indawat na abe en sisya din maikadwa ay kalisa na ta say panloganana yan wada abey mamangpango mo sisya ay manbogbogaw, “Iay-ayedan yo! Iay-ayedan yo!” Siya sa din inyat di ari ay nangdotok en Jose ay man-gobernador sin intiro ay ili ed Egipto. ");
INSERT INTO kne_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kanana abe en sisya, “Sak-en di ari pay laeng, ngem tet-ewa pay dedan ay maga polos di man-gido mo adim ipalobos.” ");
INSERT INTO kne_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Nginadanana abes Jose si Zafenat Panea ay ngadan di taga-Egipto, asi na iyaan si balasang ay asawa na. Din balasang ay sana et si Asenat ay anak en Potifera ay padi ed Heliopolis. Tolonpo di tawen Jose sin nangilogiana ay mansilbi sin ari ed Egipto. Et en nanlikliked sin intiro ay ili ay Egipto. ");
INSERT INTO kne_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sin pito ay tawen ay siged di apit, ");
INSERT INTO kne_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","inpaolnong Jose din inanin di ipogaw sin esa ya esa ay ili et inpadolina sin agamang das di. ");
INSERT INTO kne_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Aped na ay tinmapog din naidolin ay kaman din kaad-adon di darat sin benget di baybay, isonga inpasaldeng Jose ay mangipabilang sin maipenpenpen. ");
INSERT INTO kne_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sin daan domteng di betil, namidwa ay nan-anak din asawan Jose ay si Asenat. ");
INSERT INTO kne_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Din besag da ay lalaki et nginadanan Jose si Manasses, tan kanana, “Inpalingling Diyos en sak-en din ligat ko ya din toton-od ko.” ");
INSERT INTO kne_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Lalaki abe din maikadwa, et nginadanan Jose si Efraim, tan kanana, “Inyaan Diyos sak-en si anan-ak sin ili ay nay ay napaligatak.” ");
INSERT INTO kne_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Idi siya di, tinmet-ewa din inpadton Jose. Idi nakdeng din pito ay tawen ay siged di apit, naisokat din pito ay tawen ay betil. Wada abey betil sin odom ay kailiili, ngem ed Egipto pay, sobra pay laeng di makan. ");
INSERT INTO kne_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Idi madagaangan abe din taga-Egipto, en da nankedaw si kanen da sin ari, yan kanan din ari, “En kayo ilan si Jose yan patien yo amin ay ibaga na.” ");
INSERT INTO kne_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Idi nasepsep din betil sin intiro ay ili ed Egipto, inpabokat Jose din kaagaagamang et nan-ilakos makan sin taga-Egipto. ");
INSERT INTO kne_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ad-ado abey ipogaw ay inmey ed Egipto ay napo sin addawi ay il-ili ta en da manaoy en Jose, tan nakaro abe din betil sin kad-an da. ");
INSERT INTO kne_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Idi inammoan Jacob ay wada di pansaoyan si makan ed Egipto, kanana sin an-ak na, “Adi tako owat tomotokdo, ");
INSERT INTO kne_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","tan wada kano di makan ed Egipto. En kayo kod manaoy sidi ta adi tako matey si dagaang.” ");
INSERT INTO kne_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","5","Siya di inmey din sinpo ay papangoan Jose ed Egipto ta en da manlakos kanen da, tan nakaro abe din betil ed Canaan. Ngem si Benjamin pay ay kosto ay iyogtana, adi pinalobosan Jacob ay makeey tan emegyat into et ya waday mapasamak en sisya. Domateng pay din aag-in Jose ed Egipto, naitapi da sin odom ay kaipoipogaw ay en nanaoy. ");
INSERT INTO kne_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Gapo ta si Jose di gobernador di ili, ya sisya met laeng di nangilaklakos makan sin napo sin odom ay kailiili, en da mandokmog ay manyakog-ong en sisya. ");
INSERT INTO kne_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Idi inilan Jose din aag-i na, naimatonana ay dagos, ngem nginalat nas daida ay kaman dan mangili yan kanana ay namodtak, “Intoy napoan yo?” “Napo kami ed Canaan ay en manaoy,” kanan da ay sinombat, ");
INSERT INTO kne_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","tan kambaw adi da naimatonan sisya. ");
INSERT INTO kne_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Pag nemnemen Jose din iniitaw na ed idi ay maipanggep en daida yan kanana, “Ispay kayon samet! Inmali kayo isna ta siimen yo din ili mi ay nay mo waday pankapoyana.” ");
INSERT INTO kne_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Aga met ay apo,” kanan da. “Ibilang min awak mi ay bag-en mo yan tet-ewa met ay din panggep mi anggoy ay inmalis na et ta manlako kamis kanen mi. ");
INSERT INTO kne_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Siag-i kami am-in. Tet-ewa met nan ibagbaga mi, baken kamin ispay.” ");
INSERT INTO kne_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“Ado na! Inmali kayo isna ta siimen yo nan ili mi,” kanan Jose ay sinombat. ");
INSERT INTO kne_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Asi da et kanan, “Apo, dakami din anak di esay nakay ay manbeey ed Canaan. Sinpo ya dowa kami koma ay siag-i, ngem nataynan din inoodi sin kad-an ama mi yan namaga abe din esa.” ");
INSERT INTO kne_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Iso met,” kanan pay Jose. “Ispay kayo tet-ewa. ");
INSERT INTO kne_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ngem padasek dakayo mo tet-ewa din inbaga yo. Isapatak sin ngadan di ari ay adi kayo komakkaan isna mo adi omali din iyogtan yo ay sana. ");
INSERT INTO kne_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pomili kayos esa en dakayo ta ena ton-oden dowan pay mataynan din odom sin balodan engganas maammoak mo tet-ewa din inbaga yo. Mo baken pay tet-ewa, say dadlonak pangammoan ay ispay kayo.” ");
INSERT INTO kne_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Idi nakdeng ay inbaga na di, inpabalod nas daida si toloy agew. ");
INSERT INTO kne_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sin maikatlo ay agew, kanan Jose en daida, “Sak-en di ipogaw ay mamati en Diyos, isonga adiak peslen dakayo dalo et mo onodan yo din ibagak. ");
INSERT INTO kne_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mo tet-ewa ay matalek kayo ay ipogaw, olay esa di mataynan isnan balodan. Din odom pay en dakayo et mabalin ay en yo isaa din lakoan yo ay makan sin madagdagaangan ay pamilya yo. ");
INSERT INTO kne_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ngem masapol ay koyogen yo din inoodi ay iyogtan yos na ta say mangipaneknek sin katet-ewan di inbaga yo ta say adiak peslen dakayo.” Inaw da din kanan Jose ay sana ");
INSERT INTO kne_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","yan kanan da ay manngangalat, “Nay mapalpaligatan tako ed wani begew sin inamag tako sin iyogtan tako ed idi. Tan inila tako gamin din ligat na ya din sakit di nemnem na sin nan-adawagana en datako ngem tineteweng tako dedan. Siyan samet di begew ay naabotan tako sin ligat ay nay.” ");
INSERT INTO kne_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kanan aben Ruben, “Inbagak dedan en dakayo ay adi yo amagen di lawa en sisya, ngem adi yon tomet inkaskaso. Yan nay et ay ikaro tako din nateyana.” ");
INSERT INTO kne_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Say inbaga da di tan adi da iman ammo ay maawatan Jose din kali da, tan nanipod sin dinmatngan das di, waday inayagan Jose ay mangiol-olog. ");
INSERT INTO kne_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Siya di et kinmaan si Jose ay en man-oga. Idi mabalin ay makakali, nantaoli sin kad-an da yan inkasinas Simeon, et inpabalod na sin sangoanan da am-in. ");
INSERT INTO kne_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Idi siya di, binilin Jose din babag-ena ta pon-en da din sakon di aag-i nas bakakew ya ta ikosnong da din pilak ay inbayad di esa ya esa sin sako na. Inbilina abe ay iyaan das baon ay omanay sin danan. Idi nakdeng di, ");
INSERT INTO kne_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","inpakargan din aag-i na din nilakoan da ay bakakew sin dangki da et manlobwat da. ");
INSERT INTO kne_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Idi nalabi, naspad da sin danan ta say pan-iyanan da. Bokatan pay di esa din sako na ta pakanenan dangki na, yan kambaw wada et din pilak na ay naisasapew sin bakakew. ");
INSERT INTO kne_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kinaliana din aag-i na yan kanana, “Ilan yo kadi! Intaoli dan pilak ko! Naey sinan sakok.” Isonga palalo ay madandanagan da, yan man-asisin-eng das egyat da yan kanan da, “Ay apaw na! Sino ngin na ay inamag Diyos en datako?” ");
INSERT INTO kne_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Domateng da pay sin kad-an ama da ed Canaan, insodsod da en sisya am-in di napasamak en daida. ");
INSERT INTO kne_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kanan da, “Binmodtak din gobernador ed Egipto ay nakingalat en dakami. Pinabasol nas dakami ay man-is-ispay kano sin ili da. ");
INSERT INTO kne_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Insongbat mi en, ‘Baken kamin ispay, tet-ewa met din ibagbaga mi. ");
INSERT INTO kne_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sinpo ya dowa kami koma ay siag-i ay anak di esay nakay ed Canaan, ngem namaga din esa yan din kotit pay, nataynan sin kad-an ama mi,’ kanan mi en sisya. ");
INSERT INTO kne_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Siya di et kanan din gobernador ay sana, ‘Din pangammoak ay tet-ewa din ibagbaga yo et mataynan din esa en dakayos na dowan isaan din odom din bakakew para sin madagdagaangan ay pamilya yo. ");
INSERT INTO kne_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Asi kayo mantaolis na ay mangitakin sin inoodi ay iyogtan yo ay sana ta say pangammoak ay baken kayon ispay. Asiak ipataoli din nababalod ay agi yo et olay intoy em-emeyan yos na ay manlakos kanen yo,’ kanana,” kanan din aag-in Jose ay nangistorya. ");
INSERT INTO kne_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Idi inbokbok da din insako da, wada et din pilak ay inbayad da ed Egipto et inmegyat da am-in, pati din ama da ay si Jacob. ");
INSERT INTO kne_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kanan Jacob en daida, “Adi pay neyneyna yan abosen yo din anak ko. Namaga si Jose, namaga abes Simeon, yan nay et ay layden yo ay itagtag abes Benjamin. Sak-en met laeng di mapaligatan issa.” ");
INSERT INTO kne_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Siya di, kanan Ruben en ama na, “Mo adiak itaolis Benjamin en sik-a, olay peslem din doway anak ko ay lalaki. Basta italek mo en sak-en, itaolik met laeng.” ");
INSERT INTO kne_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ngem inandiyan Jacob ay nangwani, “Adi mabalin ay makeey si Benjamin en dakayo, tan natey din pangpangoana yan sisya pay di es-esa ay anak ko. Mo itakin yo sin emeyan yo yan waday mapasamak en sisya, mateyak si sakit di nemnem ko, tan enggay nakayak.” ");
INSERT INTO kne_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Idi siya di, kinmarkaro din betil ed Canaan, ");
INSERT INTO kne_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","engganas inabos da Jacob din sinaoyan da ed Egipto. Pag nan kanan sin an-ak na, “Mantaoli kayo ed Egipto ta en kayo manlakos at-atik ay kanen tako.” ");
INSERT INTO kne_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Asi et kanan Juda, “Aw a, ngem din turay ay doy ed Egipto yan dadlonan pinaegyat dakami ay nangwani, ‘Adi yon ipidpidwa ay manpaila en sak-en mo adi yo itakin din iyogtan yo.’ ");
INSERT INTO kne_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mo ipalobos mo ay makeey din iyogtan mi, en kami manlakos kanen tako. ");
INSERT INTO kne_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mo sigaam pay, bal-o na ay adi kami emey, tan inbagan dedan din turay ay adi mabalin ay kasin min ilaen sisya mo maga din iyogtan mi.” ");
INSERT INTO kne_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kanan pay Jacob, “Dakayo di gapon di ligat ko ay nay, tan inbaga yon tomet en sisya ay way esay agi yo.” ");
INSERT INTO kne_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","“Aw kayman,” kanan da ay sinombat, “ngem inpidwapidwan din turay ay sana ay manalodsod maipanggep en dakami ya din pamilya mi. ‘Ay dedas ama yo? Ay wada pay di agi yo?’ kanana. Kapilitan ay songbatan mi din salodsod na. Ay tan ammo mi ay ibaga na ay ton-oden mis Benjamin?” ");
INSERT INTO kne_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kanan aben Juda en ama da, “Ipalobos mo kod ay makikoyog en sak-en ta emey kami ay dagos ta say adi tako mabtil. ");
INSERT INTO kne_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Isapatak ay owayak en sisya. Mo adiak itaoli en sik-a, olay pabasolem sak-en si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Mo doy ya adi koma nataktak din emeyan mi, namidwa koma ay inmey ya nantaoli kami.” ");
INSERT INTO kne_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Siya di et kanan ama da en daida, “Mo siya sa, man-a kayo ngarud sin kasigedan ay wadas nan ili tako ta say itakin yo ay idatdateng sin gobernador. Din alaen yo yan balsamo, anig, kakalasin di bangbanglo, mirra, ya din kanginaan ay lames di kaiw. ");
INSERT INTO kne_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Doblien yo abe din itakin yo ay pilak, tan masapol ay itaoli yo din naipeey sin sako yo. Siguro, owat kamali di. ");
INSERT INTO kne_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Itakin yo aben iyogtan yo ta emey kayo ay dagos. ");
INSERT INTO kne_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Sapay koma ta iturong din Manakabalin ay Diyos di nemnem din gobernador ta seg-anganas dakayo yan ipalobos na ay makisaas da Benjamin en Simeon. Mo sak-en pay, mo kapilitan ay maawananak si anak ko, maawananak dedan.” ");
INSERT INTO kne_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Siya di inan din siag-i din maidatdateng sin gobernador ya din pilak et nanlobwat da ay emey ed Egipto ay nangikoyog en Benjamin. Domateng da pay sidi, en da nanpaila en Jose. ");
INSERT INTO kne_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Idi inilan Jose ay wadas Benjamin, kanana sin bag-en ay makaammo sin beey na, “Itlod mo da naey sin beey ko et pomalti kas isida mi ay animal, tan makialas dosi da en sak-en.” ");
INSERT INTO kne_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tinongpal din bag-en din intogon Jose ay sana, et initlod na din siag-i sin beey na. ");
INSERT INTO kne_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Domatdateng da pay sin beey, emegyat da yan kanan das nemnem da, “Inpaitlod nas datakos na tan begew din pilak ay naitaoli sin sako tako ed idi. Dompap dan samet ta panbalinen das datako ay bag-ena ya alan dan dangki tako.” ");
INSERT INTO kne_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Idi sinmawang da sin pantew di beey, kanan da sin bag-en Jose, ");
INSERT INTO kne_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Apo, wada kod di ibaga mi. Inmali kamis na sin namingsan ay en nanlakos makan. ");
INSERT INTO kne_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Asi et idi naspad kami sin danan ta man-iyan kamis di, binokatan mi din sako mi, yan siya di nangammoan mi ay naisapesapew sin sakon di esa ya esa din kosto ay pilak ay inbayad mi. Nay ay itaoli mi en sik-a, ");
INSERT INTO kne_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","yan wada abey intakin mi ay bayad di kasin min lakoan. Toan adi mo sinoy nangipeey sin pilak sin sako mi.” ");
INSERT INTO kne_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“Laton, adi kayo emeg-egyat,” kanan din bag-en ay sinombat. “Din Diyos yo ay Diyos aben ama yo di nangipeey sin sako yo, tan inawat ko met kayman din bayad yo.” Pag komaan ay en mangayag en Simeon et indateng na sin kad-an da. ");
INSERT INTO kne_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Asi na ipasgep daida sin beey et iyaanas danom ta owasan dan siki da. Pinakana abe din dangki da. ");
INSERT INTO kne_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mo din siag-i pay, insagana da din idawat da en Jose mo somaa sin alas dosi, tan inammoan da ay makiokob da en sisya. ");
INSERT INTO kne_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Domateng pay si Jose, nandokmog ya nanyakog-ong da ay nangidawat sin indateng da. ");
INSERT INTO kne_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kinomosta nas daida et pag nan kanan, “Ay deda din ama yo ay nakay ay inbaga yo en sak-en ed idi? Ay mabikas pay laeng?” ");
INSERT INTO kne_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Aw yan, din baam ay si ama mi et laton ay mabikas pay laeng,” kanan da ay sinombat dowan dan kasin mandokmog ay mangidayaw en sisya. ");
INSERT INTO kne_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Idi inilan pay Jose din iyogtana ay si Benjamin, kanana, “Si sana baw din inoodi ay inbaga yo.” Et kanana en Benjamin, “Ay anak ko, sapay koma ta bindisyonan dakan Diyos.” ");
INSERT INTO kne_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Sin nangwanianas di, binigla na ay kinmaan, tan adi makaitpe sin palalo ay iliw na sin iyogtana yan makaog-oga. Isonga inmey sin kowarto na et en nan-oga. ");
INSERT INTO kne_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pag mandaop et nantaoli sin kad-an di aag-i na ay mangiitpe sin oga na. Kanana sin bag-en, “Mangan kami et.” ");
INSERT INTO kne_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Et talatalen da din maisango en daida. Ang-anggoy Jose sin esay lamisaan yan din aag-i na pay sin esa. Wada da abey taga-Egipto ay naikakasin sin esay lamisaan, tan eweeween di taga-Egipto ay makikikan sin Hebreo. ");
INSERT INTO kne_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Idi inilan pay din siag-i din inyat da ay naipatokdo, man-asisin-eng da ay masmasdaaw, tan nadapat da ay nanlogi sin kapangoanan enggana sin kaanongosan. ");
INSERT INTO kne_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Naiyaan da abes napili ay makan ay napo sin lamisaan Jose, yan mamin lima din naidawat en Benjamin mo din odom en daida. Et nakikan ya nakiinom da en Jose engganay nabsonabsog da. ");
INSERT INTO kne_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Idi siya di, binilin Jose din bag-en ay makaammo sin beey na yan kanana, “Pon-em din sako das makan et isapew mo din pilak di esa ya esa sin sako na. ");
INSERT INTO kne_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pakisapew mo abe din tasak ay palata sin sakon di inoodi.” Et say tinongpal na di. ");
INSERT INTO kne_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mapat-a pay, nasapa din bag-en ay mangipalobwat sin siag-i, et kinmaan da am-in, pati din dangki da. ");
INSERT INTO kne_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Idi owat dan inmad-addawi sin siyodad, kanan Jose sin bag-en ay sana, “En ka atikoen din ipogaw ay doy. Mo edasam daida, siya na di kanam. ‘Apay nga sinobalitan yo din siged ay inyat apok en dakayo si lawa? ");
INSERT INTO kne_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Apay nga inakew yo din tasa na ay palata? Madagsen dis basol yo, tan say pan-in-inomana ya os-osalena abe ay manpontos.’” ");
INSERT INTO kne_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Idi indasan din bag-en din siag-i, inbaga na en daida din intogon Jose ay sana. ");
INSERT INTO kne_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Et kanan da ay sinombat, “Sino ngin di layden nisa ay kalien ay apo? Ammon Diyos ay maga polos di inamag mis kaman nisa. ");
INSERT INTO kne_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ammom met ay sin napoan mi ed Canaan, intaoli mi en sik-a din pilak ay dinteng mi sin sako mi. Isonga sino ngin di pangwaniam en inakew mi di palata ono balitok sin beey di apom? ");
INSERT INTO kne_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","May, anapem ngarud. Mo wada din tasa sin olay sino en dakami, olay peslen yos sisya yan panbalinem si dakami ay bag-en mo.” ");
INSERT INTO kne_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kanan pay din bag-en, “May ngarud, ngem olay mo din nangakew anggoy di maibag-en en sak-en. Din odom pay et mabalin ay nawaya da.” ");
INSERT INTO kne_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Siya di et kaibaba da sin sako da et esa en mamokat. ");
INSERT INTO kne_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Inset din bag-en ay nanganap ay manlogi sin pangpangoan enggana sin inoodi, yan dintengana din tasa sin sakon Benjamin. ");
INSERT INTO kne_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kabisngit din siag-i sin bado da begew si sakit di nemnem da. Asi da kasin ikarga din sako sin dangki da et mantaoli da sin siyodad. ");
INSERT INTO kne_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Idi dinmateng da Juda ya din iib-a na sin beey en Jose, dedas di et nanyakog-ong da en sisya. ");
INSERT INTO kne_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Pag na et kanan, “Apay nga inyat yo di? Ammo yo koma dedan ay din nangato di saad na ay kaman sak-en et mabalin ay pontosana mo sinoy nangakew.” ");
INSERT INTO kne_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Sinongbatan Juda yan kanana, “Sinoy isongbat mi ngin? Intoy iyat mi ngin ay mangipaila ay maga di basol mi? Tan si Diyos met laeng di mangipail-ila ay waday nanbasolan mi ed idi. Olay manbalin kami am-in ay bag-en mo, baken anggoy din nantengan yo sin tasa.” ");
INSERT INTO kne_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kanan pay Jose, “Aga met a! Ay siya mo say iyat ko di? Din nanga anggoy sin tasa di bag-en ko. Mo din odom pay, maga di mapasamak en daida. Mabalin ay somaa kayo en ama yo.” ");
INSERT INTO kne_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Sin nanngeanas di, inmasag-en si Juda en Jose yan kanana, “Ay apo, sik-ay mais-iso sin ari, ipalobos mo kod ta ibagak din wadas nemnem ko. Adi ka kod omibongbonget.” ");
INSERT INTO kne_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Pag nan itoloy ay mangwani, “Siya di ay apo, mo taynak din iyogtan kos na yan adiak idateng en amak, matey si sakit di nemnem na, tan enggay nakay sisya yan din iyogtan mi ay nay di naimongsanan di layad na. ");
INSERT INTO kne_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mo sak-en pay, nansapataak abe en makaammoak en sisya, yan inbagak en ama mi ay mo adiak itaoli din anak na en sisya, sak-en di pabasolena si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Isonga mo mabalin ay apo, sak-en di maisokat sin iyogtan ko ay maibag-en en sik-a ta way iyat na ay makisaa sin odom ay aag-i na. ");
INSERT INTO kne_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tan adiak met mabalin ay mantaoli en amak mo iwed din iyogtan ko ay koyogek. Adiak aben maanosan ay mangila sin palalo ay sakit di nemnem na.” ");
INSERT INTO kne_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Sin nanngean Jose sidi, adi makaitpe sin likna na sin sangoanan di babag-ena, isonga binilinas daida ta komaan da am-in. Siya di et ang-anggoy da Jose sin aag-i na sin nangipaammoanas awak na en daida. ");
INSERT INTO kne_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Pag kaogoog si Jose et dinngen din taga-Egipto ay wada sin beey, yan pag dan ipadamag sin beey di ari. ");
INSERT INTO kne_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Asi pag kanan Jose sin aag-i na, “Sak-en si Jose. Ay deda pay laeng si amak?” Ngem adi da makasongbat, tan enggay nasngang da sin egyat da en sisya. ");
INSERT INTO kne_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Siya et di, kanan Jose en daida, “Omasag-en kayo kod.” Idi inmasag-en da pay, kanana, “Sak-en din iyogtan yo ay si Jose ay inlako yo en daida ay nangiali en sak-en isnan ed Egipto. ");
INSERT INTO kne_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ngem adi kayo madanagan. Adi yo aben pabasbasolen awak yo, tan si Diyos pay dedan di nangipaon-ona en sak-en isna ta way iyat di mabmabtil ay ipogaw ay matago. ");
INSERT INTO kne_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tan ed wani di maikadwa ay tawen anggoy di betil, wada pay di lima ay tawen ay iwed di maapit. ");
INSERT INTO kne_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Isonga inamag Diyos di nakaskasdaaw. Inpaon-onanas sak-en en dakayo ta way iyat yo ay makalsot sin betil ay nay ta itoltoloy yo sin poli yo ay matago sinan daga. ");
INSERT INTO kne_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Baken met si dakayo di nangibaa en sak-en isna mo adi et si Diyos. Nanbalinena abes sak-en si kangatoan ay opisyal di ari ta sak-en di mangituray sin odom ay oopisyal ya sin intiro ay ili ay nay. ");
INSERT INTO kne_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Dalasen yo ngarud ay mantaoli en ama tako ta ibaga yo ay si naey di kanan Jose ay anak na: ‘Nanbalinen Diyos sak-en ay mangituray sin intiro ay ili ed Egipto, isonga omali kayo ay dagos, ");
INSERT INTO kne_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","dakayo sin an-ak mo ya din ap-om, pati din karnero, kalding, baka, ya odom ay gamgameng yo. Mabalin ay mantee kayo sin sakop di Gosen ay asag-en sin kad-ak ");
INSERT INTO kne_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ta way iyat ko ay mangay-ayowan en dakayo. Tan wada pay laeng di limay tawen ay betil, yan sigaak ay mankolang kayo sin pamilya yo ya din talaken yo.’” ");
INSERT INTO kne_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Pag nan itoloy ay mangwani, “Ed wani, dakayo am-in pati si Benjamin, maimatonan yo ay dadlon sak-en si Jose. ");
INSERT INTO kne_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","En kayo ngarud ibaga en ama tako din kaipogaw ko isnan ed Egipto ya din am-in ay inila yo. Asi yo dalasen ay mangikoyog isna.” ");
INSERT INTO kne_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Idi kanan Jose di, kakawe en Benjamin et man-oga dowan aben man-ogas Benjamin ay nangawe en sisya. ");
INSERT INTO kne_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Man-og-oga abe ay nangawe ya nangongo sin odom ay aag-i na. Et pag dan makingalat en sisya. ");
INSERT INTO kne_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Idi dinamag din ari ya din tuturay na ay sinmawang din aag-in Jose, manragsak da am-in, ");
INSERT INTO kne_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","yan kanan din ari en Jose, “Ibagam sin aag-im ta kargaan da din animal da ta mantaoli da ed Canaan ");
INSERT INTO kne_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ta asi da ton-oden si ama yo ya din pamilya da ay mantaolis na. Tan idawat ko en daida din kasigedan ay daga isnan ed Egipto et aped nas panbiyagan da. ");
INSERT INTO kne_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ibagam abe en daida ta man-itakin das kalisa ay napos na ta say panloganan di as-awa da ya din anak da ta mo domateng das di, asi da ayagan da ama yo ta omali da am-in isna. ");
INSERT INTO kne_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Adi da madanagan ay manaynan sin bonag das di, tan mo domateng das na, maidawat en daida din kasigedan ay bonag sin intiro ay ili ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Idi inbagan Jose sin aag-i na ay anak Jacob din kanan di ari, pinati da. Indawat Jose en daida din kakalisa ay intogon di ari, pati baonen da sin danan. ");
INSERT INTO kne_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Inyaana abe din esa ya esa en daidas baro ay paris ay bado, ngem mo si Benjamin pay, lima ay paris ay bado di indawat na en sisya, pati toloy gasot ay palata ay pilak. ");
INSERT INTO kne_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Din inpaw-it na abe para en ama na et sinpo ay dangki ay nakargaan sin kasigedan ay gamgameng ed Egipto ya sinpo kasin ay dangki ay bomalasang ay nakargaan si bakakew, tinapay, ya odom ay makan ay kasapolan da sin danan. ");
INSERT INTO kne_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Idi naisagana am-in, pinalobwat Jose din aag-i na ay nangwani, “Adi kayo od man-iibaw ya manpinabasol sin danan.” ");
INSERT INTO kne_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Pag dan komaan ed Egipto et nantaoli da sin kad-an ama da ed Canaan. ");
INSERT INTO kne_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Sin dinmatngan da, kanan da, “Matmatago baw si Jose! Manturay sisya sin intiro ay ili ed Egipto!” Sin nanngean Jacob sidi, nasngang et adi na patien din inbaga da. ");
INSERT INTO kne_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ngem idi dinad-at da en sisya amin di inbagan Jose en daida yan inila na abe din kakalisa ay inbaan Jose ta say panloganan da ay emey ed Egipto, nailit-ingan sisya ");
INSERT INTO kne_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","yan kanana, “Matmatago baw pay laeng si Jose ay anak ko. Masapol ay enak ilaen sisya ta asiak matey.” ");
INSERT INTO kne_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Asi pag balkoten da Jacob din bonag da et nanlobwat da ay nangitakin abe sin talaken da. Inmey da agan-o ed Beerseba et say nangidatonan Jacob si aanimal en Diyos, ay din Diyos ay dinaydayaw ama na ay si Isaac. ");
INSERT INTO kne_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Idi malabi, waday inpailan Diyos en sisya ay kaman iitaw. Kanana, “Jacob, Jacob!” “Naeyak,” insongbat na. ");
INSERT INTO kne_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Sak-en si Diyos ay dinaydayaw amam. Adi ka emeg-egyat ay emey ed Egipto, tan paad-adoek din polim isdi. ");
INSERT INTO kne_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Koyogek sik-a ay emey ed Egipto et asiak itaoli din polim met laeng sin ili ay nay. Et mo matey ka, wadas Jose ay mangila en sik-a.” ");
INSERT INTO kne_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Idi napat-a, nanlobwat da Jacob ed Beerseba. Inpalogan din an-ak nas sisya ya din sin-iin-a sin kakalisa ay inbaan din ari ed Egipto. ");
INSERT INTO kne_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Intakin da abe din talaken da ya din odom ay gamgameng ay inling-etan da sin nantettean da ed Canaan, et inmey da ed Egipto. Nakeey abe am-in din ganak Jacob ");
INSERT INTO kne_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ay din an-ak na ya din ap-o na. ");
INSERT INTO kne_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Din bilang di ganak na ay nakeey ed Egipto et enemapolo ya enem, powira din as-awan di an-ak na. ");
INSERT INTO kne_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Mo maibilang koma abe din doway anak en Jose ay naianak ed Egipto, emey ay pitopolo di bilang di pamilyan Jacob ay inmey sidi. ");
INSERT INTO kne_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Idi dandani ay domateng da, inpaon-onan Jacob si Juda sin kad-an Jose ta ena damagen din danan ay emey ed Gosen. Mantaoli pay si Juda, pag dan emey. ");
INSERT INTO kne_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Si Jose abe, inpasagana nan kalisa na ta ena abten si ama na. Man-asiila da pay, kakawes Jose en sisya et nan-ogas nabayag. ");
INSERT INTO kne_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Pag kanan ama na, “Ed wani yan nakasaganaak ay matey, tan laton ay inilak sik-a yan ammok ay sibibiyag ka pay laeng.” ");
INSERT INTO kne_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pag kanan Jose sin aag-i na ya odom ay mimbron di pamilyan ama na, “Emeyak sin ari ta ipaammok ay inmali kayo ay pamilyan amak ya aag-ik ay napod Canaan. ");
INSERT INTO kne_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ibagak en sisya ay manpaspastol kayo yan inkoyog yo din aanimal yo ya am-in ay sanikwa yo. ");
INSERT INTO kne_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mo paayag nas dakayo ya damagena di obla yo, ");
INSERT INTO kne_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ibaga yo ay manpaspastol kayo manipod pay sin kakitkittoy yo engganad wani ay kaman met laeng din oblan di ap-apo tako ed idi. Say ibaga yo di ta say ipalobos na ay mantee kayo isnan Gosen, tan sigsigaan di taga-Egipto di amin ay manpaspastol.” ");
INSERT INTO kne_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Et nanpilis Jose si lima sin aag-i na. Inkoyog nas daida sin kad-an di ari yan kanana, “Dinmateng da amak ya din aag-ik. Napo dad Canaan yan inkoyog da amin ay animal ya sanikwa da. Wada dad wani ed Gosen.” Pag nan iam-ammo din lima ay aag-i na sin ari. ");
INSERT INTO kne_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Sinalodsod din ari di obla da yan kanan da ay sinombat, “Apo ari, manpaspastol kami ay kaman met laeng din ap-apo mi. ");
INSERT INTO kne_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Inmali kamis na tan palaloy betil ed Canaan yan enggay magay pangipastolan mi sin animal mi. Pangaasim kod, apo, ta palobosam dakami ay manteed Gosen.” ");
INSERT INTO kne_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pag kanan din ari en Jose, “Ed wani, inmali dan sik-a si amam ya din aag-im. ");
INSERT INTO kne_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Naitalek met en sik-a nan daga ay Egipto, et makaammo ka ay mangidawat si pantean da. Idawat mo ed Gosen ay kamayatan ay lugar isnan Egipto. Mo waday makabael en daida, dotokam ay mangayowan sin aanimal ko.” ");
INSERT INTO kne_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Makdeng pay di, inkoyog Jose si ama na sin sangoanan di ari. Kinablaawan Jacob din ari, ");
INSERT INTO kne_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","pag kanan din ari, “Pigay tawen mo?” ");
INSERT INTO kne_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yan kanan Jacob ay sinombat, “Nanbiyagak si 130 ay tawen ay owat nanlikliked isnan daga. Naligligat ya ap-aptik di biyag ko mo din ap-apok ed idi.” ");
INSERT INTO kne_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Idi siya di, binindisyonan Jacob din ari, asi nan taynan. ");
INSERT INTO kne_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Et indawtan Jose si ama na ya din aag-i na si daga da ed Rameses ay kamayatan ay lugar ed Egipto, tan say inbilin din ari. ");
INSERT INTO kne_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Indawtana abes daida ya amin ay mimbron di pamilyan ama na si kanen da insigon sin kaad-ado da. ");
INSERT INTO kne_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Enggay maga polos di makan sin kailiili, tan kinmaro din betil et enggay kinmapsot din ipogaw ed Egipto ya Canaan. ");
INSERT INTO kne_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Si Jose pay yan tinopog na amin ay pilak ed Egipto ya Canaan ay inlako das makan et in-ey na sin palasyon di ari. ");
INSERT INTO kne_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Idi naabos amin din pilak di taga-Egipto ya taga-Canaan, inmey din taga-Egipto en Jose yan kanan da, “Idawtam kod dakami si makan. Adi ka koman baybay-an dakami ay matey si dagaang, tan nay enggay naabos pilak mi.” ");
INSERT INTO kne_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kanan aben Jose, “Mo naabos amin di pilak yo, iali yo din animal yo ta sokatak si makan.” ");
INSERT INTO kne_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Et in-ey dan Jose din kabayo, baka, karnero ya dangki da yan sinokatanas makan. Indawtanas daida si kanen da sin tawen ay sana et say sokat din amin ay animal da. ");
INSERT INTO kne_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Idi domteng sin maisned ay tawen, inmey da kasin en Jose yan kanan da, “Apo, adi mi maisaot ay enggay naabos din pilak mi yan enggay inam din aanimal mi. Enggay maga polos di maidawat min sik-a malaksig sin awak ya daga mi. ");
INSERT INTO kne_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Adim koman ipalobos ay matey kami si dagaang. Sokatam paabe din awak ya daga mi si makan. Olay manbalin kami ay bag-en din ari ya okaena din dagdaga mi, basta idawtam dakami si makan ay katagoan mi ya bin-i ay is-ek mi ta adi mataynan nan daga ay magay mantee.” ");
INSERT INTO kne_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Et linakoan Jose amin ay daga ed Egipto para sin ari. Kapilitan ay inlakon din taga-Egipto din taltalon da gapo sin palalo ay betil et inokan din ari amin ay daga. ");
INSERT INTO kne_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Amin abe ay ipogaw ed Egipto yan nanbalin da ay bag-en din ari. ");
INSERT INTO kne_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Say adi anggoy linakoan Jose din dagan di papadi, tan indawdawtan din aris daida si kanen da et adi masapol ay ilako dan daga da. ");
INSERT INTO kne_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Idi siya di, kanan Jose sin kaipoipogaw, “Enggay linakoak dakayo ya din daga yo para sin ari. Nay di bin-i ay is-ek yo. ");
INSERT INTO kne_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sin pinag-aani, masapol ay idawat yo din inkaliman di apit yo. Din mabay-an, mabalin ay say osalen yo ay bin-i yo ya kanen din pamilya yo.” ");
INSERT INTO kne_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kanan da ay sinombat, “Insalakan mo din biyag mi et manbalin kami ay bag-en din ari mo say panlaydam, apo.” ");
INSERT INTO kne_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Et nanbalinen Jose ay linteg ed Egipto ay okaen din ari din inkaliman di apit, yan say linteg da engganad wani. Anggoy nas adi inokan din ari din dagan di papadi. ");
INSERT INTO kne_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Et nantee ngarud din polin Israel ay manngadan abes Jacob ed Egipto sin lugar ay Gosen. Binmaknang da yan inmad-ado abe din an-ak da. ");
INSERT INTO kne_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sinpo ya pito ay tawen di nantean Jacob ed Egipto enggana ay nantawen si 147. ");
INSERT INTO kne_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Idi dandani ay matey, inpaayag nas Jose ay anak na yan kanana, “Wada kod di kedawek en sik-a. Kapayem nan poyong ko ta isapatam ay adi ka omikaot isnan Egipto. ");
INSERT INTO kne_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Laydek ay omiey ka sin naikaotan di ap-apok et omikaot kas di ta maitapiak en daida.” Kanan Jose ay nanongbat, “Aw ama, amagek san kedkedawem.” ");
INSERT INTO kne_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Pag kanan Jacob, “Isapatam ay tongpalem.” Et nansapatas Jose, pag mandokmog si Jacob sin toktokan di katri na ay nan-iyaman en Diyos. ");
INSERT INTO kne_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Malabas pay di timpo, naipaammo en Jose ay mansakit si ama na. Et intakina din dowa ay lalaki ay anak na, da Manasses en Efraim. ");
INSERT INTO kne_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Idi naipaammo en Jacob ay dinmateng si Jose ay anak na, inkaligatana ay binmangon sin katri na. ");
INSERT INTO kne_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Pag nan kanan en Jose, “Nanpaila din Manakabalin ay Diyos en sak-en ed Luz ay sakop di Canaan yan kanana ay namindisyon en sak-en, ");
INSERT INTO kne_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘Paad-adoek to din an-ak mo et manbalin din polim si dadakke ay nanasyon. Idawat ko en daida din daga ay nay ta okaen das eng-enggana.’” ");
INSERT INTO kne_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Pag itoloy Jacob ay nangwani, “Ibilang ko ay anak ko din dowa ay lalaki ay anak mo ay naianak isnan Egipto sin daanak pay laeng omalis na. Ibilang kos daida ay kaman din mismo ay anak ko ay da Ruben en Simeon. ");
INSERT INTO kne_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mo wada pay di maianak ay an-ak mo, adi dan maibilang ay anak ko mo adi et anak mo. Mapo en da Manasses en Efraim di tawiden da.” ");
INSERT INTO kne_vpl VALUES ("GN48_9b","002_48_9b","GEN","48","9b","9b","Pag kanan Jacob, “Ialim daida ta bindisyonak.” ");
INSERT INTO kne_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Sin doy ay timpo, enggay kinmapsot din matan Jacob gapo sin kanakay na et enggay nadabodab din pangila na. Insag-en Jose din an-ak na et kinawe ya inongoanas daida. ");
INSERT INTO kne_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Kanan Jacob en Jose, “Adiak ninamnama ay mailak pay laeng sik-a, ngem nay ay inpalobos Diyos ay mailak abe din an-ak mo.” ");
INSERT INTO kne_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kinaan Jose din anan-ak sin peweg ama na pag manyakog-ong sin lota. ");
INSERT INTO kne_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Pag itakkayan Jose si daida et insag-ena en Jacob. Din kannawana en Efraim ta maipatag sin kannigid Jacob yan din kannigid na en Manasses ta maipatag sin kannawan ama na. ");
INSERT INTO kne_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ngem nansawasien Jacob din takkay na et din kannawan di inkapay na en Efraim ay iyogtan yan din kannigid na en Manasses ay pangpangoan. ");
INSERT INTO kne_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Baken mayat sin pannemnem Jose din inila na ay nangikapayan ama na sin kannawan ay takkay na sin toktok Efraim, isonga in-etana ay inpakapay en Manasses din takkay ama na. ");
INSERT INTO kne_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kanana, “Baken sa ay ama tan sinay din pangpangoan et say pangikapayam sin kannawan mo.” ");
INSERT INTO kne_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ngem kanan ama na, “Anak, ammok ay manbalin to abe ay dakdake ay nasyon din polin Manasses. Ngem wadwada di dayaw din iyogtana et manbalin to din poli na ay napigpigsa ay nanasyon.” ");
INSERT INTO kne_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Et binindisyonanas daida sin agew ay doy yan kanana, “Awni et osalen din Israelita din ngadan yo sin panbindisyonan da. Kanan dan to, ‘Panbalinen koman Diyos dakayo ay kaman da Efraim en Manasses.’” Siya di din kanana ay nangon-onaena din ngadan Efraim. ");
INSERT INTO kne_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","2","Idi siya di, inayagan Jacob ay manngadan abe si Israel din an-ak na yan kanana, “Malikob kayo ay an-ak ko ta dengngen yo di ibagak, tan ipaammok di mapasamak en dakayo sin tapin di agew.” ");
INSERT INTO kne_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Sik-a ay Juda, dayawen ya manyakog-ong din aag-im en sik-a ya seem din bagang di kalaban mo. ");
INSERT INTO kne_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Maiarig kas layon ay peslena di depapena asi mantaoli sin pantabtabonana. Kaman kan layon ay man-inat ay bomaktad yan magay makaitoled ay manistorbo. ");
INSERT INTO kne_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mansososkat ay manturay din polin Juda enggana ay maiskat di esa ay maikari ay mangawat sin bowis di nanasyon ya tongpalen das sisya. ");
INSERT INTO kne_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Itaked na din dangki na sin poon di kamayatan ay obas ya labaana din bado na si arak di obas. ");
INSERT INTO kne_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Din kolor di mata na yan maymayat mo din arak di obas. Din bab-a na abe yan mankilat mo din gatas.” ");
INSERT INTO kne_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Idi nakdeng ay natey si ama da, nanngangalat din aag-in Jose yan kanan da, “Into et ya malmaliget pay laeng si Jose en datako et ibaes na din lawa ay inamag tako en sisya ed idi?” ");
INSERT INTO kne_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Isonga inbaa day en mangibaga en Jose, “Sin daan kateyan ama tako, ");
INSERT INTO kne_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","inbaga na iman en mankedaw kami koma en sik-a ta pakawanem dakami sin basbasol mi en sik-a ed idi. Isonga pasinsiyaam paabe din basbasol mi ay baan Diyos ay dinaydayaw amam.” Idi dinngen Jose din inpadnge da ay sana, nan-oga. ");
INSERT INTO kne_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Asi pag emey din aag-i na sin kad-ana et nanyakog-ong da en sisya ay nangwani, “Naey kami ay bag-en mo.” ");
INSERT INTO kne_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ngem kanan Jose en daida, “Adi kayo emeg-egyat. Ay siya mo sak-en si Diyos ta dosaek dakayo? ");
INSERT INTO kne_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Lawlawa kayman din panggep yo ay amagen en sak-en ed idi, ngem nanbalinen Diyos si mapteng. Tan nay ay naisalakan di ad-ado ay ipogaw begew sin napasamak ay doy. ");
INSERT INTO kne_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Iwed di pan-egyatan yo, tan laton ay ay-ayowanak dakayo ya din aan-ak yo.” Say inbagan Jose en daida san mayat ay kali ta tomalna di nemnem da. ");
INSERT INTO kne_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Intoltoloy Jose ay nanbeey ed Egipto, pati din pamilyan ama na, enggana ay mantawen si sin-gasot ya sinpo. ");
INSERT INTO kne_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Indasana din anak di apon Efraim ay anak na, yan sinaklot na abe din an-ak en Makir ay anak en Manasses. ");
INSERT INTO kne_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Idi siya di, kanana sin aag-i na, “Dandani din kateyak, ngem laton ay ay-ayowanan Diyos dakayo et ipango nas dakayo ay komaan sin ili ay nay ta emey kayo sin ili ay insapata na ay idawat en da Abraham en Isaac ya si Jacob.” ");
INSERT INTO kne_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Pag nan togonen daida ta isapata da ay itakin dan tong-a na mo ipangon Diyos daida sin ili ay sana. Et insapata da. ");
INSERT INTO kne_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Idi siya di, natey si Jose ay mantawen si sin-gasot ya sinpo. Et binalsamo da din bangkay na et inponpon da ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Sin inmeyan Jacob ed Egipto, intakina din an-ak na ya din pamilya da. Da naey di ngadan din lallalaki ay an-ak Jacob ay manngadan abes Israel: ");
INSERT INTO kne_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","da Ruben, Simeon, Levi, Juda, ");
INSERT INTO kne_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulun, Benjamin, ");
INSERT INTO kne_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad ya si Aser. ");
INSERT INTO kne_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Pitopolo di bilang am-in din polin Jacob mo maitapis da Jose ay enggay wada ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Idi nalabas di ad-ado ay tawen, natey am-in da Jose ay siag-i ya din am-in ay katawenan da ay napo ed Canaan. ");
INSERT INTO kne_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ngem din poli da pay ay makwani en Israelita yan paspas da ay inmad-ado et naganaganak da, isonga enggay mapno da sin ili ay kad-an da ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Idi siya di, nasokatan di turay ed Egipto et nanturay di esa ay ari ay magay ammo nas maipanggep en Jose. ");
INSERT INTO kne_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kanan din ari ay sana sin oopisyal na, “Dengngen yo nan ibagak. Ilan yo nan Israelita et pomigpigsa da tan nay omad-ad-ado da. Dilikado di kasasaad tako. ");
INSERT INTO kne_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Masapol ay mannemnem takos pamosposan ta adi dan masepsep ay omad-ado. Tan adi pay mo wada et di gobat, ya asi dan badangan din kaibaw tako et pag dan ikanayon ay lomayaw.” ");
INSERT INTO kne_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Idi siya di, nandotok das mankakekedse ay kapatas ay mangipilit si madagsen ay obla sin Israelita ta say mapaligatan ya madismaya da. Et inpaamag da en daida din siyodad ay Pitom ya Rameses ay say pan-idoldolinan din ari si makan ya odom ay kasapolan da. ");
INSERT INTO kne_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ngem olay mo intoy iyat di taga-Egipto ay mamalpaligat sin Israelita, masepsep pay dedan ay omad-ado ya maiwarwaras da. Begew sina, madandanagan ya malmaliget din taga-Egipto en daida, ");
INSERT INTO kne_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","et pinalaloan da din inpaobla dan daida ay adi da polos sineg-angan. Din nankadadagsen ay oblan di man-amag si beey ay kaman din mankiwar ya mandamili si linang ya olay abe din am-in ay kalasin di obla sin payew yan inpilit dan daida. Isonga peteg ay kinmaseseg-ang din biyag di Israelita. ");
INSERT INTO kne_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ngem adi pay laeng mapnek din ari et inpaayag na din doway babai ay Hebreo ay da Sifra en Pua, tan daida di manpapaanak. ");
INSERT INTO kne_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Kanana en daida, “Mo waday paanaken yo ay Hebreo ya ilan yo ay lalaki di anak na, peslen yo din moyang, ngem mo babai yan bay-an yo.” ");
INSERT INTO kne_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Asi et din manpapaanak et patgen ya egyatan das Diyos, isonga adi dan tinongpal din inbilin di ari. Binay-an da ay matago din am-in ay moyang, olay din lalaki. ");
INSERT INTO kne_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Idi siya di, inpaayag din ari din dowa ay sana ay manpapaanak et kanana, “Apay nga say inamag yo na? Apay nga adi yon pinse din maianak ay lallalaki?” ");
INSERT INTO kne_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ngem kanan da ay nanongbat, “Baken tomet kaman din babai ay taga-Egipto din babai ay Hebreo, tan nalaka pay di iyat da ay man-anak, isonga makdeng ay makaanak da asi domateng din manpapaanak.” ");
INSERT INTO kne_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Gapo isdi, binindisyonan Diyos din dowa ay manpapaanak ay sana et naganak da. Din Israelita abe yan nasepsep ay naad-ado ya pinmigpigsa da. ");
INSERT INTO kne_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Idi siya et di, kanan din ari ay nangibilin sin am-in ay ipogaw na, “Am-in ay lalaki ay ianak di Hebreo, masapol ay en yo itep-a sin ginawang ay Nile, ngem bay-an yo pay din babai ta matago da.” ");
INSERT INTO kne_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Sin timpo ay sana, waday sin-asawa ay polin Levi, et nan-anak da. ");
INSERT INTO kne_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kasin pay nawad-an din babai et nan-anak si lalaki. Idi inila na ay siged ya kagam-is din moyang, inset na ay nangitabtabon. Ngem idi inmey di tolo ay bowan, ");
INSERT INTO kne_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","nadakdake din moyang et naligatan si ina na ay mangitabon ed bebbeey da. Isonga nan-a si baskit, asi na allidan si niket ta adi segpen di danom. Pag nan ikosnong din moyang et ena intabon sin katantanobongan sin benget di ginawang. ");
INSERT INTO kne_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Sin baken onay addawi, wada din manang di moyang ay mangil-ila mo sinoy mapasamak sin iyogtana. ");
INSERT INTO kne_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Maaw-awni pay, wada et din babai ay anak di ari ay en man-ames sin ginawang ay doy. Din babalasang ay baa na pay yan mandaddad-an da sin benget di ginawang. Idi inilan din anak di ari din baskit sin kad-an di tanobong, inpaa na sin esa ay baa na. ");
INSERT INTO kne_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Idi bokatana din baskit ay sana, inila na et din moyang ay man-og-oga, isonga naseg-angan sisya. Kanana, “Anak baw di Hebreo na.” ");
INSERT INTO kne_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Asi et somag-en din manang di moyang sin anak di ari yan kanana, “Ay laydem ta man-ayagak si Hebreo ay ina ay mamaspasoso para en sik-a?” ");
INSERT INTO kne_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Aw kod, emey ka,” kanan din anak di ari ay sinombat et ena inayagan si ina da. ");
INSERT INTO kne_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Idi domateng sisya, kanan din anak di ari, “Alaem nan moyang ta ayowanam para en sak-en ta asiak lagboan sik-a.” Pag nan isaa et inayowanana. ");
INSERT INTO kne_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Idi mapsot din moyang, in-ey na sin anak di ari et tinagibi na. Kananas nemnem na, “Si Moses di ngadana tan kinay-at ko sin danom.” ");
INSERT INTO kne_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Idi nalabas di ad-ado ay tawen, enggay nadakdake si Moses. Sin namingsan, inmey sin kad-an di kapoliana ay Hebreo, et naseg-angan ay nangila sin ligat da begew sin madagsen ay ipaob-oblan di taga-Egipto en daida. Sin kawada nas di, inila na di esa ay taga-Egipto ay manopsoplit si esa ay Hebreo ay kapoliana. ");
INSERT INTO kne_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kamokimokilang pay si Moses, yan idi inila na ay magay mangil-ila en sisya, kapese sin taga-Egipto ay sana, asi na ikaot sin kadaratan. ");
INSERT INTO kne_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kabigatana pay, nanpasyal kasin si Moses sin kad-an di gagait na ay Hebreo, yan inila na di dowa ay Hebreo ay man-ib-ibaw. Kanan Moses sin akin basol, “Apay nga bokboksingem di gait mo?” ");
INSERT INTO kne_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Kasongbat et din lalaki ay sana yan kanana, “Ay tan sino ka od? Ay sinoy nangidawat si kalintegam ay mangituray ya mangowis en dakami? Ay kanam abe en pomse ka ay kaman din inyat mo sin taga-Egipto ay doy?” Gapo isdi, inmegyat si Moses, tan kananas nemnem na, “Kambaw way nangila sin inamag ko.” ");
INSERT INTO kne_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Idi naammoan din ari din napasamak, pinanggep na ay ipapse si Moses, ngem kalayaw si Moses ed Midian et isdi ay nantetee. Sin namingsan ay tinmotokdos Moses sin kad-an di bobon, ");
INSERT INTO kne_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","wada et ay domateng din pito ay babai ay an-ak din padi ed Midian ay mangipainom sin karnero ya kalding ama da. Pinnopinno da din pan-in-inoman di animal da. ");
INSERT INTO kne_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Dowan et somawang di lallalaki ay manpaspastol abe yan kaipakaan da sin babbabai ay sana. Kapika si Moses et ena binadangan din babbabai, pag nan painomen din karnero ya kalding da. ");
INSERT INTO kne_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Idi somaa da, kanan Reuel ay ama da, “Yan nay dagos nasapa kayo ed wani mo?” ");
INSERT INTO kne_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","“Aw, tan waday taga-Egipto ay binmadang idi pakaanen din odom ay manpaspastol si dakami dowana et iman isakdoan ya painomen din animal tako,” kanan da ay nanongbat. ");
INSERT INTO kne_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Pag kanan ama da, “Yan into ngin sisya? Apay nga tinaynan yos di? En kayo ayagan ta makikan en datako.” ");
INSERT INTO kne_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","En da inayagan si Moses, pag et awisen Reuel ay makitee en daida. Emey pay di timpo, inpaasawan Reuel din anak na ay si Zippora en sisya. ");
INSERT INTO kne_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Man-anak pay si Zippora yan lalaki, et nginadanan Moses si Gersom, tan kananas nemnem na, “Mangiliak pay kayman isnan natken ay ili.” ");
INSERT INTO kne_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Inmey pay di piga ay tawen, natey din ari ed Egipto, ngem deda pay dedan ay naibabag-en din Israelita, et enggay ay manbaybayeweng da ya man-ad-adawag da en Diyos begew sin madagsen ay ligat da. ");
INSERT INTO kne_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dinngen Diyos din bayeweng da dowana et nemnemen din intolag na en da Abraham, Isaac ya en Jacob. ");
INSERT INTO kne_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Masmaseg-ang abe ay mangil-ila sin ligat da. ");
INSERT INTO kne_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Sin namingsan, ipaspastol Moses sin lugar ay magay omili din kakarneron Jetro ay katogangana ay padi ed Midian. Asi na et ibas-il daida enggana ay dinmateng da sin dontog ay Sinai ay panpailaan Diyos. ");
INSERT INTO kne_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Isdi ay nanpaila en sisya din anghel Diyos ay kaman apoy ay manbidbidang sin gawan di esay kaiw. Inilan Moses ay manbidbidang din kaiw ngem adi kapooan, ");
INSERT INTO kne_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","isonga kananas nemnem na, “Nakaskasdaaw et abe di mo, enak kod ilan mo apay nga adi kapooan din kaiw ay doy.” ");
INSERT INTO kne_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Idi ilan Diyos ay somag-en si Moses, nankali sin gawan di manbidbidang ay kaiw yan kanana, “Moses, Moses.” Sinongbatan Moses yan kanana, “Sino di ibagam ay Apo.” ");
INSERT INTO kne_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Pag kanan Diyos, “Issa ka, adi ka somagsag-en. Kaanem san sandal mo tan nasantoan ay lugar nan kad-am. ");
INSERT INTO kne_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Sak-en din Diyos ay dinaydayaw amam ya siya abe sin aap-om ay da Abraham, Isaac ya si Jacob.” Idi dinngen Moses di, kaopop sin mata na tan emegyat ay mangila en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kanan Diyos ay nangitoloy, “Inilak ay palalo di iyat din taga-Egipto sin ipogaw ko. Dinngek din adawag da ay mankedkedaw si badang begew sin pamalpaligatan di mankakekedse ay kapatas da, et masmaseg-angak en daida. ");
INSERT INTO kne_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Isonga binmabaak ta isalakan kos daida sin naibabag-enan da ed Egipto ta ipangok daida si annawa ya siged ay ili ay magabay di mola, sin ilin di Canaaneo, Heteo, Amorreo, Perezeo, Heveo ya Jebuseo. ");
INSERT INTO kne_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Dadlonak dinnge din adawag di Israelita yan inilak din pamalpaligatan di taga-Egipto en daida. ");
INSERT INTO kne_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Isonga emey ka ta ibagam sin ari ay palobosana din ipogaw ko ta koyogem daida ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ngem kanan Moses, “Ay siya mo sinoak ta sak-en di makingalat sin ari ya mangibela sin Israelita ed Egipto?” ");
INSERT INTO kne_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Songbatan pay Diyos yan kanana, “Wadaak to ay mangadkadwa en sik-a. Kadi et mandayaw kayo en sak-en sin dontog ay nay mo ipangom din ipogaw ko ay komaan ed Egipto. Say pangammoam ay sak-en si Diyos ay nangibaa en sik-a.” ");
INSERT INTO kne_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kanan Moses, “Mo ibagak sin Israelita en, ‘Inbaan din Diyos di aap-o tako si sak-en,’ yan kanan da ay mansalodsod, ‘Sinoy ngadana?’ sinoy ibagak ngin en daida?” ");
INSERT INTO kne_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kanan Diyos, “Sak-en di nawawadas kankanayon. Siya nay ibagam en daida, ‘Din manngadan si Nawawadas Kankanayon di nangibaa en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Si Yahweh ay Diyos di aap-o tako ay da Abraham, Isaac ya si Jacob di nangibaa en sak-en,’ kanam en daida, tan siya na di komakaman ay ngadan ko et say pangwanin di amin ay ipogaw en sak-en si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Emey ka ta topogem din papangolon di Israelita yan ibagam na, ‘Nanpaila en sak-en si Yahweh ay Diyos di aap-o tako ay da Abraham, Isaac ya si Jacob yan kanana en inila na din mapaspasamak en dakayo isnan Egipto. ");
INSERT INTO kne_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Inkari na ay isalakana si dakayo sin ligat ay laklak-amen yo isnan Egipto ta ipango na si dakayo sin mayat ay ili ay magabay di mola, sin ilin di Canaaneo, Heteo, Amorreo, Perezeo, Heveo ya Jebuseo.’ ");
INSERT INTO kne_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Patien to din papangolon di Israel din ibagam et koyogem daida ta emey kayo sin ari ed Egipto. Siya na di ibaga yo en sisya, ‘Nanpaila si Yahweh ay Diyos di Hebreo en dakami, isonga palobosam kod dakami ta en kami man-idaton en Yahweh ay Diyos mi sin lugar ay magay omili. Masapol ay mandad-an kami si tolo ay agew ay emey sidi.’ ");
INSERT INTO kne_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ngem ammok ay adi palobosan din ari si dakayo mo magay mapasamak ay kapilitana. ");
INSERT INTO kne_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Isonga ipailak to din nakaskasdaaw ay panakabalin ko sin iyat ko ay manosa sin taga-Egipto ta say ipalobos nas dakayo. ");
INSERT INTO kne_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Iturong ko abe di siged ay pannemnem di taga-Egipto sin ipogaw ko ta adi dan owat komaan ay magay maidawat en daida. ");
INSERT INTO kne_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tan din babbabai ay Israelita et emey da sin katokmang da ay taga-Egipto ya olay sino ay babbabai ay taga-Egipto ay makibebeey en daida ta en da mankedaw si bado ya al-altin di awak ay balitok ya palata. Ipaosal yo dana sin an-ak yo et say iyat yo ay mangikaan sin kinabaknang di taga-Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ngem kanan Moses, “Ngem intoy iyat ko ngin mo adi patien din Israelita din ibagak ya kanan da en adi ka nanpaila en sak-en?” ");
INSERT INTO kne_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Pag et kanan Diyos, “Sino san iin-genam?” “Sokod,” kanan Moses. ");
INSERT INTO kne_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Idi siya di kanan Diyos, “Itep-am sin lota.” Idi intep-an Moses din sokod, nanbalin si eweg isonga katagtag si Moses. ");
INSERT INTO kne_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ngem kanan Diyos en sisya, “Depapem. Ig-en mo sin iko na.” Idi sinipdot Moses din iko na, nanbalin kasin si sokod. ");
INSERT INTO kne_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Pag kanan Diyos, “Sinay di ipailam ta say patien din Israelita ay nanpaila en sik-a si Yahweh ay din Diyos di aap-o da ay da Abraham, Isaac, ya si Jacob.” ");
INSERT INTO kne_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kasin binilin Diyos si Moses yan kanana, “Isoksok mo din takkay mo sin tak-ep di badom.” Say inyat tet-ewan Moses yan idi kaanena, natalektekan si mankilat ay kakaman andap dowan et mankokolad ay dadlon naapiktalan si kaeegyat ay sakit di kodil. ");
INSERT INTO kne_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Pag kanan Diyos, “Isoksok mo kasin sin badom.” Insoksok Moses asi nan kaanen, yan idi ilaena, nailatonan et kaman met laeng din kodil di odom ay partin di awak na. ");
INSERT INTO kne_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Idi siya di, kanan Diyos, “Mo adi dan mamati sin damo ay sinyal, mabalin ay mamati da sin maikadwa. ");
INSERT INTO kne_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ngem no adi da pay laeng mamati sin dowa ay nakaskasdaaw ay sinyal ay nay ta adi dan patien din ibagam, man-a kas danom sin ginawang ay Nile ta isiit mo sin lota. Mo amagem di, manbalin si dada din danom.” ");
INSERT INTO kne_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ngem kanan Moses, “Apo, man-ibaa ka kod si odom tan manipod pay laeng ed idi yan bakenak nalaing ay mankali. Olay ed wani ay nakikalkali ka en sak-en, bakenak met laeng maapat.” ");
INSERT INTO kne_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pag et kanan Diyos, “Ay sino od di nangamag si tepek di ipogaw? Sino di namarsua sin naomel ya nateweng ono din nagodab ya baken nagodab? Ay baken ayan si sak-en ay Diyos? ");
INSERT INTO kne_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","May, emey ka et. Laton ay tolongak sik-a et itdok di kosto ay ibagam.” ");
INSERT INTO kne_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ngem kanan pay laeng Moses, “Apo, pangaasim kod ta man-ibaa ka si odom.” ");
INSERT INTO kne_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Gapo isdi, nanbonget si Diyos yan kanana en Moses, “Wada met si Aaron ay agim ay Levita. Ammok ay nalaing sisya ay mankali. Katet-ewa na, wada ay omal-ali ay mangabat en sik-a et peteg di ragsak na ay mangila en sik-a. ");
INSERT INTO kne_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Mabalin met ay makikali ka en sisya ta itdom di ibaga na. Tolongak to si dakayo et ibagak to di amagen yo ya ibaga yo. ");
INSERT INTO kne_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Si Aaron di makikalkali sin ipogaw para en sik-a et kaman sik-a di Diyos ay mangibilbilin sin ibaga na. ");
INSERT INTO kne_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Itakin mo san sokod mo ta say osalem ay man-amag si nakaskasdaaw.” ");
INSERT INTO kne_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Idi makdeng di, nantaoli si Moses sin kad-an katogangana ay Jetro yan kanana, “Palobosam kod sak-en ay mantaoli ed Egipto ta enak ilan mo deda ay matmatago din aag-ik ay Israelita sidi.” Pinalobosan Jetro sisya et nanpinakada da. ");
INSERT INTO kne_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Idi wada pay laeng si Moses ed Midian, nakikali si Diyos en sisya yan kanana, “Mantaoli ka ed Egipto tan enggay natey amin din manpangpanggep ay mamse en sik-a.” ");
INSERT INTO kne_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Idi siya di, nanlobwat da Moses ay emey ed Egipto. Inkoyog na si asawa na ya din aan-ak da, et nangabayoenas daida si dangki. Intakina abe din sokod ay kanan Diyos en itakina. ");
INSERT INTO kne_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Sin siya di ay timpo, nakikali si Diyos en Aaron yan kanana, “En ka abaten si Moses sin lugar ay magay omili.” Pag en aspoen Aaron si Moses sin dontog ay panpailaan Diyos et inongoana. ");
INSERT INTO kne_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Inistoryan Moses en Aaron am-in din inbagan Diyos sin nangibilinana ay mantaolis sisya ed Egipto ya din nakaskasdaaw ay inbilin Diyos ay amagena. ");
INSERT INTO kne_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Pag dan mankoyog ay emey ed Egipto. Idi dinmateng das di, inpaayag da am-in din papangolon di Israelita, ");
INSERT INTO kne_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","et dinad-at Aaron en daida din amin ay inbagan Diyos en Moses. Pag aben ipailan Moses da doy ay nakaskasdaaw sin sangoanan da. ");
INSERT INTO kne_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Idi inilan din kaipoipogaw, pinati da et nanyakog-ong da ay nandayaw en Diyos, tan naammoan da ay masmaseg-ang si Diyos ay mangil-ila sin ligat da. ");
INSERT INTO kne_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Inmey da Moses en Aaron sin kad-an di ari ed Egipto yan kanan da, “Inbagan Yahweh ay Diyos di Israelita en palobosam din ipogaw na ta en da manfiesta ay pangdayaw dan sisya sin lugar ay magay omili.” ");
INSERT INTO kne_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ngem kanan din ari, “Ay tan sino od san si Yahweh? Ay ken am-ammok sisya ta tongpalek san kanana? Aga! Adiak ipalobos.” ");
INSERT INTO kne_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Songbatan pay da Moses en Aaron yan kanan da, “Ngem nakikali met en dakami din Diyos ay daydayawen mi ay Hebreo, isonga palobosam dakami ay mandan si tolo ay agew sin lugar ay magay omili ta say en mi pan-idatonan en sisya. Mo adi kami amagen sa, dosaenas dakami et matey kami si sakit ono gobat.” ");
INSERT INTO kne_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ngem kanan din ari en daida, “Adi mabalin ay sangawen yo din ipogaw sin obla da. Masapol ay itoloy san babag-en din obla da! ");
INSERT INTO kne_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Enggay inmad-ado kayo et mo din taga-Egipto yan kanan yo en isaldeng yo din obla yo?” ");
INSERT INTO kne_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Sin doy ay agew, binilin din ari din kakapatas ya din Israelita ay nadotokan ay mangimanmandar sin gagait da. ");
INSERT INTO kne_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Kanana, “Manipod ed wani, adi kayon idawdawtan din Israelita si garami ay mailaok sin madamili ay maiamag si beey. Daida di man-anap si garami, ");
INSERT INTO kne_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ngem adi mabalin ay mabawasan si olay esa din kaad-adon di dinamili ay am-amagen da. Nasadot da dedan, isonga kanayon ay ibagbaga da en palobosak daida ta en da man-idaton sin Diyos da. ");
INSERT INTO kne_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Idawtan yos daida si nadagdagsen ay obla ya adi yon pasalsaldengen daida ta say magay timpo da ay mandenge si owat etek ay istorya.” ");
INSERT INTO kne_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Inmey din kakapatas ya din man-imanmandar sin kad-an di Israelita yan kanan da, “Inbilin din ari en manipod ed wani yan adi min idawtan dakayo si garami. ");
INSERT INTO kne_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Inbaga na ay dakayo di man-anap, ngem masapol ay adi mabawasan din kaad-adon di dinamili ay amagen yo.” ");
INSERT INTO kne_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Gapo sin bilin ay doy, enggay likeden da din intiro ay Egipto ay man-anap si garami. ");
INSERT INTO kne_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Talaga ay inpapilit din kakapatas ay amagen da din sigod ay kabibilang di dinamili ay am-amagen da idi maidawdawtan da pay laeng si garami. ");
INSERT INTO kne_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Pakakkaasien din kakapatas ay soplisopliten din Israelita ay nadotokan ay man-imanmandar. Kanan da, “Apay nga baken kosto di kabibilang di inpaamag yo ed nasdem ya ed wani ay baken kaman ed idi?” ");
INSERT INTO kne_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Inmey din man-imanmandar sin ari yan kanan da ay nanriri, “Apo ari, apay ngin ay say iyat yo na en dakami? ");
INSERT INTO kne_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Maga met di idawat din oopisyal mo ay garami en dakami yan ipilit da ay amagen mi din sigod ay kaad-adon di am-amagen mi ay dinamili. Dowan da et soplisopliten dakami mo kolang din amagen mi, ngem daida met di akin basol.” ");
INSERT INTO kne_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ngem kanan et din ari ay nanongbat, “Sadot! Nasadot kayo ay man-obla, isonga kanan yo en palobosak dakayo ay en man-idaton sin Diyos yo. ");
INSERT INTO kne_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Itoloy yo et ay man-obla. Magay garami ay maidawat en dakayo, ngem masapol pay dedan ay amagen yo din sigod ay kaad-adon di dinamili si esay agew.” ");
INSERT INTO kne_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nailan din man-imanmandar ay dilikado di kasasaad da gapo sin inbagan di ari ay doy. ");
INSERT INTO kne_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Idi kosto ay komaan da, inabat das da Moses en Aaron ay manseseed en daida. ");
INSERT INTO kne_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kanan da en da Moses, “Sapay koma ta dosaen Diyos dakayo, tan nay dakayo dedan di gapo ay linmawlawa di pannemnem din ari ya oopisyal na en dakami. Waday rason da ay mamse en dakami begew sin inyat yo.” ");
INSERT INTO kne_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Gapo isdi, en kasin nankararag si Moses en Diyos yan kanana ay nanriri, “Apo, ilaem kod san inyat mo sin ipogaw mo. Doy et ay nasepsep di ligat da! Apay ngin ay inmibaa ka asi ka pay say iyat na? ");
INSERT INTO kne_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tan manlogi sin nangibagaak sin ari sin inbilin mo, nasepsep et ay pinalpaligat na din ipogaw mo, yan maga polos di naibadang mon daida!” ");
INSERT INTO kne_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Pag kanan Diyos ay nanongbat en Moses, “Mailam ed wani di amagek sin ari, tan ipailak din panakabalin ko et mapilitan ay mangipabolos sin ipogaw ko. Awni et bakenan owat pabolosan mo adi et dagdagenas daida ay komaan.” ");
INSERT INTO kne_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kanan aben Diyos en Moses, “Sak-en si Yahweh. ");
INSERT INTO kne_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Sin nanpailaak en da Abraham, Isaac ya si Jacob, inpaammok ay sak-en din Manakabalin ay Diyos, ngem adiak inpaammo din ngadan ko ay Yahweh en daida. ");
INSERT INTO kne_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ngem inkarik en daida ay idawat ko din daga ay Canaan olay mo sin doy ay timpo yan owat dan mangili sin ili ay doy. ");
INSERT INTO kne_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ed wani ay dinngek din adawag di Israelita ay binabag-en di taga-Egipto et manemnem ko din intolag ko ay doy. ");
INSERT INTO kne_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Isonga say ibagam na sin Israelita, ‘Siya na di kanan Diyos: Sak-en si Yahweh. Badangak dakayo ta mawayawayaan kayo sin namabag-enan di taga-Egipto en dakayo. Ipailak di panakabalin ko sin iyat ko ay manosa en daida ta maisalakan kayo. ");
INSERT INTO kne_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ngem dakayo pay, panbalinek dakayo si ipogaw ko et sak-en di Diyos yo. Awni et maammoan yo ay sak-en si Yahweh ay Diyos yo ay nangipawaya en dakayo sin nankaliligat ay obla ay inpapapilit di taga-Egipto. ");
INSERT INTO kne_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Iey kon to si dakayo sin ili ay inkarik en da Abraham, Isaac ya si Jacob et idawat ko en dakayo. Sak-en si Yahweh.’” ");
INSERT INTO kne_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Inbagan Moses na sin Israelita ngem adi dan inkaskaso tan enggay nadismadismaya da gapo sin palalo ay ligat ay laklak-amen da. ");
INSERT INTO kne_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Pag kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“En ka ibaga sin ari ed Egipto ay ipalobos na din Israelita ay komaan sin ili na.” ");
INSERT INTO kne_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ngem kanan Moses, “Mo adi pinatin din Israelita din inbagak, adi pay namnamed din ari, tan bakenak met nalaing ay mankali.” ");
INSERT INTO kne_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ngem kanan Diyos en Moses, “Dengngem nan ibagak. Panbalinek sik-a ay kaman Diyos sin pangilan di ari et si Aaron ay agim di kaman mamadto ay makikalkali para en sik-a. ");
INSERT INTO kne_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ibagam en sisya amin ay inbilin ko ta ibaga na sin ari ay ipalobos na din Israelita ay komaan isnan Egipto. ");
INSERT INTO kne_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ngem sepsepek ay pakentegen din nemnem di ari ta adi nan ikaskaso si dakayo et amagek di ad-ado ay nakaskasdaaw isnan Egipto. ");
INSERT INTO kne_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Dosaek daida ta pagak ipango din ipogaw ko ta komaan das na. ");
INSERT INTO kne_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Say pangammoan to din taga-Egipto ay sak-en tet-ewa si Diyos mo lak-amen da din dosa ay idawat ko ya ipangok din ipogaw ko ay komaan isnan Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Pinatin da Moses en Aaron din inbagan Diyos en daida. ");
INSERT INTO kne_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mantawen si Moses si 80 yan 83 en Aaron sin timpo ay sana ay nakikalkalian da sin ari. ");
INSERT INTO kne_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Binilin Diyos da Moses en Aaron yan kanana, ");
INSERT INTO kne_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Mo kasapolan din ari di nakaskasdaaw ay pamaneknek yo, ibilin mo en Aaron ta itep-a na din sokod na sin sangoanan di ari et manbalin si eweg.” ");
INSERT INTO kne_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Inmey da Moses en Aaron sin kad-an di ari et tinongpal da din inbilin Diyos. Nanbalin tet-ewa si kaeegyat ay eweg din sokod Aaron idi itep-a na sin sangoanan di ari ya din oopisyal na. ");
INSERT INTO kne_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Idi siya di, inayagan din ari din nankalalaing ay ipogaw na ya mansalsalamangka et tinadon da din inamag Aaron. ");
INSERT INTO kne_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Intep-a da din sokod da yan nanbalin abe si eweg. Ngem kaiseksek din sokod Aaron sin amin ay sokod da. ");
INSERT INTO kne_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ngem olay mo siya di, tinmet-ewa din inbagan Diyos en da Moses en Aaron ay ipakenteg din ari din nemnem na et adi nan pinati da Aaron en Moses. ");
INSERT INTO kne_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Idi makdeng di, kanan Diyos en Moses, “Talaga ay natangken din nemnem di ari et doy ay adi nan palobosan din Israelita. ");
INSERT INTO kne_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Isonga si agsapa, alaem din sokod ay nanbalin si eweg et en ka abaten sisya mo emey sin ginawang ay Nile. Sed-em sin benget na. ");
INSERT INTO kne_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Siya na di ibagam en sisya, ‘Inbaan Yahweh ay Diyos di Hebreo si sak-en ay mangibaga en sik-a ta palobosam din ipogaw na ay en mandayaw en sisya sin lugar ay magay omili, ngem nay enggana ed wani yan adi ka pay laeng pinalobosan daida. ");
INSERT INTO kne_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Isonga ed wani kanan Diyos en maammoam mo sino sisya begew sin amagena. Ilam, tan nay iseppat ko nan sokod ko sin ginawang et manbalin si dada. ");
INSERT INTO kne_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Sigaan to di taga-Egipto ay manginom tan matey dan nigay et palalo di agob din danom.’” ");
INSERT INTO kne_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kanan Diyos en Moses, “Ibagam en Aaron ta itdek na din sokod na sin amin ay kad-an di danom ed Egipto: sin ginawang ya kanal ya din odom pay ay kad-an di danom. Mo siya di manbalin si dada amin ay danom ed Egipto, pati din wadas panpaypay-an si danom ay kaiw ya bato.” ");
INSERT INTO kne_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tinongpal da Moses en Aaron din inbilin Diyos. Sineppat Aaron din danom sin ginawang sin sangoanan di ari ya oopisyal na, pag manbalin si dada. ");
INSERT INTO kne_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nanbalin si dada abe amin ay danom ed Egipto et natey amin ay nigay, isonga palalo di agob din danom et sigaan da ay manginom. ");
INSERT INTO kne_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ngem tinadon abe din ipogaw di ari ay mansalsalamangka, isonga natongpal din inpadton Diyos ay pakekentegen din ari din nemnem na. Tineteweng na din inbagan da Moses en Aaron ");
INSERT INTO kne_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","et kataynan en daida. Pag mantaoli sin palasyo. Olay din napasamak ay nay et adi na inkaskaso. ");
INSERT INTO kne_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Din ipogaw pay yan nankotkot da sin ig-igid di ginawang ay Nile, tan adi mabalin ay inomen din danom sin ginawang. ");
INSERT INTO kne_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Idi nakdeng ay nanbalinen Diyos din ginawang si dada, inmey di pito ay agew. ");
INSERT INTO kne_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Idi makdeng di, kanan Diyos en Moses, “Emey ka sin ari ta kanam en sisya, ‘Siya na di inbagan Diyos: Palobosam din ipogaw ko ta en da mandayaw en sak-en, ");
INSERT INTO kne_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","tan mo sigaam, dosaek din ilim et pawadaek di ad-ado ay tokak. ");
INSERT INTO kne_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapno din ginawang ay Nile si ad-ado ay tokak et somakyat da ay emey sin palasyom ya sin kowartom et pomatok da sin katrim. Emey da abe sin beey di oopisyal ya ipogaw mo dowan dan pomatok sin pan-ot-otoan ya banga yo. ");
INSERT INTO kne_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Pomatok da en sik-a ya sin am-in ay oopisyal ya ipogaw mo.’” ");
INSERT INTO kne_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kanan Diyos en Moses, “Ibagam en Aaron ta ikayang na din sokod na sin patag di ginawang, kanal ya posong ta somakyat din ad-ado ay tokak ta mapno da sin amin ay sakop di Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Inkayang Aaron din sokod na sin amin ay bandan di kad-an di danom et nawada tet-ewa di ad-ado ay tokak, isonga pag tokak di maila sin amin ay ilin di Egipto. ");
INSERT INTO kne_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ngem say inyat aben din mansalsalamangka et inpasakyat da di ad-ado ay tokak ay napo sin ginawang. ");
INSERT INTO kne_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Inpaayag din ari da Moses en Aaron yan kanana, “Ikararag yo en Diyos ta pakaanena nan ad-ado ay tokak ta palobosak din ipogaw mo ay en man-idaton en Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kanan Moses, “Mabalin ay ikararagak sik-a ya din oopisyal ya ipogaw mo. Basta ibagam mo pig-an et komaan to amin ay tokak sin kad-an yo malaksig din wadas ginawang ay Nile.” ");
INSERT INTO kne_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“Si bigat,” kanan din ari ay nanongbat et pag kanan Moses, “May, si bigat, ta say maammoam ay magay makaiso en Yahweh ay Diyos mi. ");
INSERT INTO kne_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Komaan dan to din tokak ay napno sin kad-am, ya sin kad-an di oopisyal ya ipogaw mo et maga di mabaybay-an malaksig din wadas ginawang ay Nile.” ");
INSERT INTO kne_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tinaynan da Moses en Aaron din ari et nankararag si Moses en Diyos ta pakaanena din ad-ado ay tokak ay say dosa ay indawat na sin ari. ");
INSERT INTO kne_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Pinatgan Diyos din kararag Moses et natey amin ay tokak ay wada sin bebbeey, bel-ayan ya papayew. ");
INSERT INTO kne_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tinopog din taga-Egipto dadi et dadakke ay bonton di naitopogan da, isonga palalo ay man-akoo din ili. ");
INSERT INTO kne_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Idi ilan pay din ari ay enggay natey amin din tokak, kinmenteg kasin din nemnem na et tinmet-ewa din inpadton Diyos ay adi na patpatien da Moses en Aaron. ");
INSERT INTO kne_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Idi siya di, kanan Diyos en Moses, “Ibagam en Aaron ta iseppat na din sokod na sin lota ta manbalin si tilang din tapok sin amin ay ili ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Inseppat Aaron din sokod na et nanbalin tet-ewa si tilang din amin ay tapok ed Egipto et napno da sin amin ay ipogaw ya animal. ");
INSERT INTO kne_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pinadas din mansalsalamangka ay tadonen, ngem adi dan kabaelan. Enggay pag way tilang sin amin ay sakop di Egipto, ");
INSERT INTO kne_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","isonga kanan din mansalsalamangka sin ari, “Naamag na begew sin panakabalin Diyos.” Ngem makenteg pay laeng din nemnem di ari, isonga adi na pinatpati da Moses en Aaron ay kaman met laeng din inpadton Diyos ay mapasamak. ");
INSERT INTO kne_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Makdeng pay di, kanan Diyos en Moses, “Masapa ka si bigat ta en ka abaten din ari sin ginawang yan ibagam en sisya, ‘Siya na di inbilin Diyos: Palobosam din ipogaw ko ay en mandayaw en sak-en, ");
INSERT INTO kne_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","tan mo sigaam, dosaek sik-a et pawadaek di ad-ado ay lallaeg ta mapno da en sik-a ya sin oopisyal ya ipogaw mo. Awni et mapno di lallaeg sin bebbeey di taga-Egipto et pag lallaeg di maila sin lota. ");
INSERT INTO kne_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ngem ilisik ed Gosen ay kad-an di ipogaw ko et maga di lallaeg si mailas di. Amagek dana ta pangammoan yo ay sak-en si Diyos ay mangam-amag sin nay mapaspasamak ed wani isnan ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Idomak din ipogaw ko sin ipogaw mo et mapasamak din nakaskasdaaw ay nay si bigat.’” ");
INSERT INTO kne_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Inpawadan Diyos di ad-ado ay lallaeg ay napno sin palasyo ya beey di oopisyal di ari et kinmadodogis din ili ay Egipto dowan madadael din molmola da. ");
INSERT INTO kne_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pinaayagan din ari da Moses en Aaron yan kanana, “En kayo man-idaton sin Diyos yo, ngem sin ili ay nay di pan-idatonan yo.” ");
INSERT INTO kne_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ngem kanan Moses ay nanongbat, “Naligat met mo say amagen mi sa, tan abigen din taga-Egipto din pan-idatonan mis animal en Yahweh ay Diyos mi. Adi pay mo ilaen da din pan-idatonan mi, palalo ay masnit da et pigpigen das dakami. ");
INSERT INTO kne_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Masapol ay mandan kami si tolo ay agew ay emey sin lugar ay magay omili ta isdi ay man-idaton kami en Yahweh ay Diyos mi, tan say inbilina.” Kanan din ari, ");
INSERT INTO kne_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","“Palobosak dakayo ay en man-idaton en Yahweh ay Diyos yo sin lugar ay magay omili mo baken palalo ay addawi di emeyan yo. Ikararagan yo ngarud si sak-en ta makaan nan ligat ay nay.” ");
INSERT INTO kne_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Kanan Moses ay nanongbat, “Mo komaanak, mankararagak ay dagos en Diyos ta mo si bigat, komaan amin ay lallaeg sin kad-am ya sin oopisyal ya ipogaw mo. Ngem adim koma kasin ietekan si dakami ya adim iparit din kaipoipogaw ay en mandayaw en Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Tinaynan Moses din ari et nankararag en Diyos, ");
INSERT INTO kne_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","yan pinatgan Diyos din kararag na. Tinaynan din ad-ado ay lallaeg din ari ya din oopisyal ya ipogaw na et magay olay esay lallaeg si nabay-an. ");
INSERT INTO kne_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ngem olay mo siya di, pinakenteg kasin din ari din nemnem na et adi nan palobosan din ipogaw ay komaan. ");
INSERT INTO kne_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Binilin kasin Diyos si Moses yan kanana, “Emey ka sin ari ta ibagam nan sisya, ‘Siya na di kanan Yahweh ay Diyos di Hebreo, “Palobosam din ipogaw ko ta en da mandayaw en sak-en.” ");
INSERT INTO kne_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mo adi ka pay laeng palobosan daida, ");
INSERT INTO kne_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ilaen yon to di iyat Diyos sin animal yo ay wada sin pastolan. Mapisti dan to din kabayo, dangki ya kamel yo. Siya abe sin baka, karnero ya kalding yo. ");
INSERT INTO kne_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ngem idoman pay Diyos din animal di Israelita et maga di olay esa ay matey en daida.’” ");
INSERT INTO kne_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Tinodingan Diyos di agew ay kapasamakan nadi yan kanana, “Si bigat di pangamagak isna sin ili ay nay.” ");
INSERT INTO kne_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Sin kabigatana, siya tet-ewa di inamag Diyos tan napisti da din animal ay ipaspastol di taga-Egipto ngem maga polos di natey sin animal di Israelita. ");
INSERT INTO kne_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nan-ibaa din ari si en nanpoot et naammoan da ay maga polos di natey sin animal di Israelita. Ngem olay mo siya di, inpapati na ay adi nangipalobos sin Israelita. ");
INSERT INTO kne_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Pag kanan Diyos en da Moses en Aaron, “Man-gamet kayo si dap-o ta isapowak Moses ed kayang sin sangoanan di ari ");
INSERT INTO kne_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","et manbalin si tapok ay maiwaras sin intiro ay Egipto. Gapo sidi, maboyoyan amin ay ipogaw ya animal.” ");
INSERT INTO kne_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Say inyat da tet-ewa et nan-a da si dap-o sin pantongtongoan, asi dan emey sin kad-an di ari. Insapowak Moses ed kayang, et pag maboyoyan amin din ipogaw ya aanimal. ");
INSERT INTO kne_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Olay abe din mansalsalamangka et adi dan binaelan ay somango en Moses, tan naitapi da sin amin ay taga-Egipto ay naboyoyan. ");
INSERT INTO kne_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ngem sinepsep Diyos ay inpakenteg din nemnem di ari et adi na pay dedan pinati da Moses en Aaron ay kaman met laeng din inbagan Diyos en Moses. ");
INSERT INTO kne_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Makdeng pay di, kanan Diyos en Moses, “Masapa ka si bigat ta en ka ibaga na sin ari, ‘Siya nay kanan Yahweh ay Diyos di Hebreo: Palobosam din ipogaw ko ta en da mandayaw en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tan mo adim patien, idawat ko di kaeegyat ay dosa en sik-a ya sin oopisyal mo pati sin ipogaw mo ta say pangammoan yo ay magay makaiso en sak-en isnan intiro ay lobong. ");
INSERT INTO kne_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Katet-ewa na, mabalin ay ed wani yan pawadaek di pisti ay mangolpi en dakayo am-in. ");
INSERT INTO kne_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ngem inpalobos ko ay matago kayo ta ipailak din panakabalin ko ya maammoan din ngadan ko sin intiro ay lobong. ");
INSERT INTO kne_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Gapo ta deda ay palpaligatem ya adi kan palobosan din ipogaw ko, ");
INSERT INTO kne_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","pawadaek di kaeegyat ay dalalo ay adi pinadpadasan di taga-Egipto manipod sin ap-apo da enggana ed wani. Mapasamak na si bigat sin kaman nina ay oras. ");
INSERT INTO kne_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Isonga ibilin mo sin ipogaw mo ta isidom da amin ay animal ya sanikwa yo ay wada sin payew ya nom-a, tan peslen di dalalo amin ay ipogaw ya animal ay adi naisidom.’” ");
INSERT INTO kne_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pinatin di odom ay opisyal di ari din inpaibagan Diyos et dinalas da ay inpasidom din babag-en ya animal da. ");
INSERT INTO kne_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ngem adi pinatin di odom isonga kabay-an da sin babag-en ya animal da sin payew ya nom-a. ");
INSERT INTO kne_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Idi siya di kanan Diyos en Moses, “Itdek mo din sokod mo ed daya ta mandalalo isnan Egipto ta peslena amin ay animal ya ipogaw ay wada sin payew ya nom-a, pati din molmola ay wadas di.” ");
INSERT INTO kne_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Idi initdek tet-ewan Moses din sokod na ed daya, ");
INSERT INTO kne_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","mankido ya mandalalo begew sin panakabalin Diyos dowan makimat din lota. Magay is-iso na di ay pewek si napasamak ed Egipto manipod ed bayag. ");
INSERT INTO kne_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Dinadael di dalalo amin ay wada sin payew ya nom-a sin intiro ay Egipto. Natey amin ay ipogaw ya animal ay adi nansidom. Dinadael na amin ay mola dowan naspak amin ay kaiw. ");
INSERT INTO kne_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ed Gosen anggoy ay kad-an di Israelita di magay dalalo. ");
INSERT INTO kne_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Inpaayag din ari da Moses en Aaron yan kanana, “Nakabasolak baw ed wani. Si Diyos di kosto, ngem dakami sin ipogaw ko di baken kosto. ");
INSERT INTO kne_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mankararag ka kod en Diyos tan nay enggay palalo nan dalalo ya kido. Laton ay palobosak dakayo et komaan kayo ay dagos.” ");
INSERT INTO kne_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Pag kanan Moses, “Mo bemelaak sin siyodad, ikayang ko din takkay ko ay mankararag en Diyos et somaldeng din dalalo ya kimat. Say pangammoan yo ay si Diyos di akin oka isnan lobong. ");
INSERT INTO kne_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ngem ammok ay sik-a ya din oopisyal mo et adi yo pay laeng banolen ya egyatan si Yahweh ay Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Gapo sin napasamak ay sana, nadadael amin din mola ay nansabong pati din sabog, tan enggay ay nandawa. ");
INSERT INTO kne_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ngem laton pay din bakakew, tan maod-odi ay maom. ");
INSERT INTO kne_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Tinaynan Moses din ari et binmela sin siyodad. Inkayang na din takkay na ay nankararag en Diyos et sinmaldeng din dalalo ya kimat, siya abe sin odan. ");
INSERT INTO kne_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Idi ilan din ari ay sinmaldeng din odan, dalalo ya kimat, kinmedse kasin. Inpakenteg na din nemnem na yan in-onod abe din oopisyal na ");
INSERT INTO kne_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","et adi na pinalobosan din Israelita, tan say inpaipadton dedan Diyos en Moses ay say amagen din ari. ");
INSERT INTO kne_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kasin kanan Diyos en Moses, “Emey ka sin ari, tan pinakenteg ko din nemnem na, olay abe sin oopisyal na ta ipailak en daida din nakaskasdaaw ay panakabalin ko. ");
INSERT INTO kne_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Inamag ko di ta say dad-aten yo sin an-ak ya ap-o yo din inamag ko ta say maibabain din taga-Egipto begew sin nakaskasdaaw ay inamag ko ya ta say pangammoan yo ay sak-en si Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kasin pay emey da Moses en Aaron sin ari yan kanan da, “Siya na di kanan Yahweh ay Diyos di Hebreo, ‘Pig-an pay di panpakombabaam en sak-en? Palobosam din ipogaw ko ay en mandayaw en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tan mo sigaam, awni et ipaalik si bigat di ad-ado ay dodon isnan Egipto. ");
INSERT INTO kne_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Maisak-eb da sin daga ay kaman tolda et adi kaila din lota begew sin kaad-ado da. Dowan dan kanen amin ay molmola yo ay binay-an di pewek ya dalalo, pati din kakaiw ay nabay-an. ");
INSERT INTO kne_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mapno da abe sin amin ay beey mo ya sin beey di oopisyal ya ipogaw mo. Polos ay magay is-iso nina si napasamak si inilan di aam-a ya aap-o yo ed idi enggana ed wani.’” Makdeng pay di, tinaynan Moses din ari. ");
INSERT INTO kne_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Asi pay kanan din oopisyal di ari en sisya, “Ay pig-an ngin ay isaldeng nisa ay mangidawdawat si problima en datako? Pangaasim ta palobosam et dedan din Israelita ta emey da mandayaw en Yahweh ay Diyos da. Ay adim pay laeng nadlaw ay enggay nadadael nan ili tako ay Egipto?” ");
INSERT INTO kne_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Isonga inpaayag din ari da Moses en Aaron et kanana en daida, “Mabalin baw ay emey kayo ta en kayo mandayaw sin Diyos yo. Ngem sino da di emey?” ");
INSERT INTO kne_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Songbatan pay Moses yan kanana, “Emey kami am-in pati din anan-ak, nankakay ya nankababkes ya din amin ay animal mi, tan masapol ay en kami manfiesta ay pangdayaw mi en Yahweh ay Diyos mi.” ");
INSERT INTO kne_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Idi siya di, kanan din ari, “Isapatak en Yahweh ay adiak ipalobos ay ikoyog yo din babbabai ya an-ak yo tan ammok ay natken di panggep yo. ");
INSERT INTO kne_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Isonga adi mabalin! Dakayo ay lallalaki anggoy di emey ay en mandayaw en Diyos mo say layden yo.” Makdeng pay ay ibaga na di, kaipakaan en da Moses en Aaron. ");
INSERT INTO kne_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Idi siya di, kanan Diyos en Moses, “Ikayang mon takkay mo sin patag di daga ay Egipto ta emey di ad-ado ay dodon ta kanen da amin di mola ay binay-an di dalalo.” ");
INSERT INTO kne_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tinongpal Moses di et inkayang na din sokod na, pag ipawadan Diyos di dagem ay napo sin naibandas belaan di agew. Nandagedagem si sin-agew ya sinlabi. Mapat-a pay, indateng din dagem ay sana di kadodododon ");
INSERT INTO kne_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","et nanwaras da sin amin ay lugar di Egipto. Enggay nadi si kaposkolan ay kaad-adon di dodon si naila ed idi ya olay pay sin omal-ali ay timpo. ");
INSERT INTO kne_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Enggay mangitit di ila da sin lota ay tinomkapan da, et kinan da amin ay binay-an di dalalo, pati din lames da. Maga polos di maila si manbibiyag ay kaiw ono mola ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Gapo isdi, naagagan din ari et kaipaayag en da Moses en Aaron. Pag nan kanan, “Nanbasolak kayman en Yahweh ay Diyos yo pati en dakayo. ");
INSERT INTO kne_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Pangaasi yo kod ta pakawanen yos sak-en olay mamingsan anggoy. Ikararag yo kod en Yahweh ay Diyos yo ta ipasaldeng na nan kaeegyat ay dosa.” ");
INSERT INTO kne_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Idi siya di, tinaynan Moses din ari et nankararag en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Pag et ipawadan Diyos di napigsa ay dagem ay napo sin diposan di agew. Indagem din amin ay dodon et inturong na ed baybay ay Mandalangdang. ");
INSERT INTO kne_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ngem pinakenteg Diyos pay dedan din nemnem di ari et adi nan pinalobosan din Israelita. ");
INSERT INTO kne_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Asi kanan Diyos en Moses, “Ikayang mo san takkay mo et palalo ay bomolinget sin amin ay kad-an di taga-Egipto ta say masapol ay mankapokap da.” ");
INSERT INTO kne_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Inkayang Moses din takkay na et siya tet-ewa ay palalo ay binmolinget ed Egipto si tolo ay agew. ");
INSERT INTO kne_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Enggay magay iyat di taga-Egipto ay bemela sin beey da, tan polos ay adi da makaila sin gagait da. Ngem laton pay ay mapat-a sin kad-an di Israelita. ");
INSERT INTO kne_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Inpaayag kasin din ari da Moses en Aaron yan kanana, “May, emey kayo ay mandayaw en Diyos yo. Olay ikoyog yo din babbabai ya anan-ak yo, ngem bay-an yo amin din karnero, kalding ya baka yo.” ");
INSERT INTO kne_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ngem kanan Moses sin ari, “Masapol ay ipalobos mo ay itakin mi abe din aanimal mi ta say waday pooan mi ay idaton en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Adi mabalin ay taynan mi di olay esa sin animal mi tan masapol ay din animal mi ay nay di en mi panpilian si idaton mi en Diyos. Esa pay, adi mi pay laeng ammo mo sino di animal ay idaton mi en Diyos enggana ay domateng kamis di.” ");
INSERT INTO kne_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ngem inpakenteg Diyos din nemnem di ari et adi na inpalobos din Israelita ay komaan. ");
INSERT INTO kne_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Isonga kanana et ay namodtak en Moses, “Komaan kas na! Adi ka kasin manpappaila en sak-en, tan mo kasin kan manpaila et papsek sik-a.” ");
INSERT INTO kne_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“Tet-ewa san kanam,” kanan Moses, “tan adi kan to ilaen kasin si sak-en.” ");
INSERT INTO kne_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Sigod ay inbagan Diyos en Moses, “Sinay di maodi ay dosa ay idawat ko sin ari ed Egipto ya sin ipogaw na. Mo makdeng di, sigurado ay palobosana si dakayo. Katet-ewa na, awni et dagdagena si dakayo amin ay komaan.” ");
INSERT INTO kne_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Idi siya di, kanan Moses sin ari, “Siya na di inbagan Diyos, ‘Sin gawan di labi, malabasak to ed Egipto ");
INSERT INTO kne_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","et matey amin ay besag ay lalaki sin anak di taga-Egipto. Maitapi din pangpangoan ay anak di ari ay say maisokat koma ay manturay enggana sin anak di bag-en ay man-gilgiling, pati din besag di animal da. ");
INSERT INTO kne_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kadi et omanoga dan to amin ay ipogaw isnan Egipto. Maga polos di nadnadnge si kaman nidi ay oga nanipod ed bayag ya olay sin tapin di agew. ");
INSERT INTO kne_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ngem sin kad-an pay di Israelita, maga polos di mapasamak ay lawa en daida ya sin animal da. Siya nay pangammoan yo sin iyat Diyos ay mangikasin sin Israelita sin taga-Egipto.’” ");
INSERT INTO kne_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Kanan Moses ay nangipaanongos, “Kadi et omali dan to amin din oopisyal mo ay mandokmog ya manpakaasi en sak-en ta koyogek amin din ipogaw ko ay komaan isna et komaanak tet-ewa.” Idi makdeng ay ibagan Moses di, palalo di bonget na ay nanaynan sin ari. ");
INSERT INTO kne_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ngem inbabagan pay dedan Diyos en Moses na, “Adi dakan to patpatien sin ari ay mapasamak dadi ta way iyat ko ay mangamag si ad-ado ay nakaskasdaaw ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Inamag da Moses en Aaron am-in dana ay nakaskasdaaw sin sangoanan di ari, ngem inpakenteg Diyos di nemnem na, isonga adi nan pinalobosan din Israelita ay komaan. ");
INSERT INTO kne_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Siya na di inbilin Diyos en da Moses en Aaron ed Egipto, ");
INSERT INTO kne_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Din bowan ay nay di manbalin ay damo ay bowan di tawen para en dakayo et say onodan yo si tinawtawen. ");
INSERT INTO kne_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ibaga yo sin intiro ay gimong di Israelita ta siya na di amagen da si tinawtawen: Mo domteng din maikasinpo ay agew sin siya na ay bowan, masapol ay manpili din aam-an di pamilya si sag-eesa ay karnero ono kalding para en daida ay pamilya. ");
INSERT INTO kne_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Mo di esa ay pamilya yan at-atik da et sobra di esay karnero para en daida, masapol ay makitapi da sin kaasag-enan ay kaaruba da et man-a da si animal ay komosto sin kaad-ado da, maibasar sin kabaelan di esa ay kanen. ");
INSERT INTO kne_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Din maosal ay animal et masapol ay bomaro ay karnero ono kalding ay esay tawena yan masapol abe ay mapteng ay maga polos di kolang na. ");
INSERT INTO kne_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Esten yo ay mangay-ayowan enggana ay malablabi sin maikasinpo ya opat ay agew di natodingan ay bowan. Say pamaltian di amin ay Israelita sin pinili da ay animal. ");
INSERT INTO kne_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Masapol ay man-a da sin dada na et say iponas da sin nan-inigid ya ngaton di pantew di beey ay pangisidaan da. ");
INSERT INTO kne_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Sin labi ay doy, ipangan da si manpait ay nateng ya tinapay ay magay labadura na din naidawis ay karni. ");
INSERT INTO kne_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Adi yon isidsida mo baken nas-et ay naoto ya adi yon ilambong. Masapol ay dinawis ay sibobokel. Adi yon tadtadtaden ay isian din toktok, siki ya eges na. ");
INSERT INTO kne_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Masapol ay magay baybay-an yo. Mo waday mabay-an enggana sin agsapa, masapol ay pooan yo. ");
INSERT INTO kne_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Masapol ay paspasan yo ay mangan yan nakababado kayo ay nakasagana ay mandan. Iaamag yo din sandal yo ya eegnan yo din sokod yo. Siya di di fiesta ay makwani en Nalabas ay amagen yo ta panginemnemneman yo sin inamag ko ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Sin labi ay sana, mandanak to ed Egipto et peslek amin ay besag ay lalaki ay anak di ipogaw ya animal et say panosaak sin amin ay didiyosen di Egipto. Sak-en si Diyos. ");
INSERT INTO kne_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ngem din dada ay iponas yo sin pantew di pangilasinak sin beey ay kad-an yo, ta mo malabasak ya ilaek din dada ay sana, maga di lawa ay mapasamak en dakayo, olay mo dosaek din amin ay taga-Egipto. ");
INSERT INTO kne_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Masapol ay silibraren yos eng-enggana din agew ay nay ay fiesta ay pangnemneman yo sin inamag ko.” ");
INSERT INTO kne_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kanan aben Diyos, “Sin oneg di pito ay agew, adi kayon mangmangan si tinapay ay waday labadura na, tinapay ay magay labadura na et anggoy di kanen yo. Sin damo ay agew, kaanen yo amin ay labadura sin beey yo. Tan mo wada di mangan si tinapay ay way labadura na sin lak-am di pito ay agew ay sana, masapol ay maipowira sin ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sin damo ya maodi ay agew, masapol ay matopog kayo amin ay mandayaw en Diyos. Masapol ay adi kayon man-obla sin da sana ay agew. Man-oto et enggay di mabalin ay amagen yo. ");
INSERT INTO kne_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Masapol ay silibraren yo din fiesta ay nay ay makwani en Tinapay ay Magay Labadura na, tan din damo ay agew na et say agew ay pangipangoak en dakayo ay komaan ed Egipto. Isonga silibraren yo din agew ay nay si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Manlogi sin kalablabian di maikasinpo ya opat di damo ay bowan enggana sin kalablabian di maikadowanpo ya esa ay agew, masapol ay mangan kayos tinapay ay magay labadura na. ");
INSERT INTO kne_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Masapol ay magay labadura sin beey yo sin lak-am di pito ay agew ay sana. Tan mo waday mangan si tinapay ay waday labadura na, Israelita ono mangili, masapol ay maipowira sin ipogaw ko.” ");
INSERT INTO kne_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Idi siya di inayagan Moses din papangolon di Israelita yan kanana, “En kayo manpili si sag-eesa ay bomaro ay karnero ono kalding ay para sin papamilya yo ta paltien yo para sin fiesta ay makwani en Nalabas. ");
INSERT INTO kne_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Manposngi kayo si pingin di hisopo ta isiwsiw yo sin napalanggana ay dadan di karnero, asi yon iponas sin nan-inigid ya ngaton di pantew di beey yo. Masapol ay maga di bemelbela sin beey da enggana ay mapat-a. ");
INSERT INTO kne_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mo sokisoken Diyos din ili ay en manosa sin taga-Egipto ya ilaena din dada sin hamban di pantew yo, labsana din beey yo et adi nan ipalobos ay senggep sin beey yo din anghel ay mangidateng si pese ta peslena si dakayo. ");
INSERT INTO kne_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Masapol ay tongpalen yo din bilin ay nay, enggana abe sin ipoli yo. ");
INSERT INTO kne_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Amagen yo din seremonia ay nay mo domateng kayo sin lugar ay inkarik ay idawat kon dakayo. ");
INSERT INTO kne_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mo damagen din an-ak yo ya kanan da, ‘Ay sinoy olog ngin nan am-amagen tako?’ ");
INSERT INTO kne_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kanan yo en daida, ‘Sinay di daton ay pangnemneman tako sin inamag Diyos sin kawada mi ed Egipto, tan pinse na din taga-Egipto ngem nilabsana pay din bebbeey tako ay Israelita.’” Idi nakdeng ay dinngen din Israelita din bilbilin ay nay, nanyakog-ong da ay nandayaw en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Idi siya di, inmey da et tinongpal da din inbilin da Moses en Aaron. ");
INSERT INTO kne_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Idi domteng sin gawan di labi, pinsen Diyos din amin ay pangpangoan ay lalaki sin an-ak di taga-Egipto. Natey din pangpangoan ay anak di ari ay maiskat koma ay manturay enggana sin pangpangoan ay anak di balod sin balodan. Natey abe amin ay besag di animal da. ");
INSERT INTO kne_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Sin labi ay doy, kabanangon din ari ya din oopisyal na ya din amin ay taga-Egipto, tan pag waday natey sin amin ay beey et omanoga da sin intiro ay Egipto. ");
INSERT INTO kne_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Sin labi ay doy, pinaayagan din ari da Moses en Aaron yan kanana, “May! Emey kayo! Koyogen yo amin ay Israelita ta komaan kayo isnan ili mi. En kayo mandayaw en Diyos, tan say kindaw yo. ");
INSERT INTO kne_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Olay itakin yo amin ay karnero, kalding ya baka yo ay kaman din kindaw yo ta emey kayo et. Ikararag yo kod abe en Diyos ta bindisyonana si sak-en.” ");
INSERT INTO kne_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Man-aagag din taga-Egipto ay mangipakaan sin Israelita, tan kanan da, “Mo adi kayo komaan et sigurado ay matey kami amin.” ");
INSERT INTO kne_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Pinnon din Israelita din pan-ot-otoan da si daan maoto ay tinapay ay magay labadura na dowan dan sengten si lopot, asi dan sakbaten. ");
INSERT INTO kne_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Inamag din Israelita din inbilin Moses et nankedaw da si al-altin di awak ay balitok ya palata ya bado. ");
INSERT INTO kne_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Inturong Diyos di siged ay nemnem di taga-Egipto sin Israelita, isonga kaidawadawat din taga-Egipto sin kedawen da. Dakdake ay kinabaknang din inan di Israelita sin taga-Egipto. ");
INSERT INTO kne_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nanlobwat din Israelita ed Rameses et nandad-an da ay manturong ed Succot. Emey ay 600,000 di bilang din lallalaki ay adi makibilang din babbabai ya anan-ak. ");
INSERT INTO kne_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ad-ado abe di baken Israelita ay naikoyog en daida ya ad-ado ay karnero, kalding ya baka. ");
INSERT INTO kne_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Sin nan-ibbayan da, inoto da din tinapay ay intakin da ay napod Egipto. Magay labadura na, tan bigla dedan ay naipakaan da ed Egipto, isonga magay timpo da ay mangisagana si baon da ono tinapay ay waday labadura na. ");
INSERT INTO kne_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nantee din Israelita si 430 ay tawen ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Sin agew ay pap-eng di 430 ay tawen, kinmaan amin din tribun di ipogaw Diyos ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Sin doy ay labi, naninsinlabi ay binanbantayan Diyos din Israelita sin nangibelaana en daida ed Egipto. Siya na di gapo ay maninsinlabi ay manbantay din Israelita mo domteng din pangnemneman da sin agew ay nay, et say maitawtawid ay linteg sin an-ak ya ap-o da. ");
INSERT INTO kne_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Kanan Diyos ay nangibilin en da Moses en Aaron, “Siya na di linteg ay onoden yo sin fiesta ay makwani en Nalabas: Adi makikan di baken Israelita sin maisagana ay makan sin fiesta ay nay. ");
INSERT INTO kne_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mo wada di nanlako si bag-en ya pinakogit na, mabalin ay makikan din bag-en ay sana. ");
INSERT INTO kne_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ngem adi mabalin ay makikan di owat sangaili ono malaglagboan ay man-obla. ");
INSERT INTO kne_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Masapol ay sin oneg di beey di panganan yo. Adi yon ibelbela din karni ya adi yon gopgopaken din tong-a. ");
INSERT INTO kne_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Masapol ay maitapi amin ay Israelita. ");
INSERT INTO kne_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mabalin ay maitapi di baken Israelita ngem masapol ay nakogit amin ay lalaki sin pamilya na. Ngem adi mabalin ay makitapi di adi nakogit sin fiesta ay makwani en Nalabas. ");
INSERT INTO kne_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Sinay di linteg ay masapol ay onodan di Israelita ya baken Israelita ay wada sin ili yo.” ");
INSERT INTO kne_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tinongpal din am-in ay Israelita din inbilin Diyos en da Moses en Aaron. ");
INSERT INTO kne_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Sin doy met laeng ay agew, inpangon Diyos din am-in ay tribun di Israelita ay komaan ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Idaton yo amin ay pangpangoan ay anak en sak-en, tan okak amin ay lalaki ay besag di Israelita ya siya abe sin besag di animal da.” ");
INSERT INTO kne_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Pag kanan Moses sin ipogaw, “Awni et ipangon Diyos dakayo sin dagan di Canaaneo ay insapata na ay idawat en dakayo ya sin ap-apo yo. Et mo okaen yo din daga ay doy, ");
INSERT INTO kne_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","masapol ay idaton yo en sisya din besag ay lalaki sin an-ak yo. Okan aben Diyos amin ay besag ay lalaki sin an-ak di animal yo, ");
INSERT INTO kne_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ngem mo din anak di dangki yan masapol ay man-idaton kayo si bomaro ay karnero ta say maisobot sidi ono kaman say maisokat ay maidaton. Ngem mo sigaan yo ay manokat sin dangki, masapol ay gotloen yo din tenged na ay say iyat yo ay mamse. Masapol ay man-idaton kayo si maisobot sin amin ay pangpangoan ay lalaki ay an-ak yo. ");
INSERT INTO kne_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mo sin tapin di agew ya pooten din an-ak yo di gapo na ay am-amagen yo dana, siya na di ibaga yo, ‘Tan ed idi yan naibabag-en kami ed Egipto, ngem winayawayaan Diyos dakami ay inbela begew sin nakaskasdaaw ay panakabalina. ");
INSERT INTO kne_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Idi pakekentegen din ari ed Egipto din nemnem na et sigaana ay mangipalobos en dakami, pinsen Diyos amin ay kapangoanan ay lalaki sin anak di taga-Egipto ya anak di animal da. Siya na di gapo ay maidaton amin ay kapangoanan ay lalaki sin an-ak di animal ya waday maidaton ay maisobot para sin amin ay lalaki ay kapangoanan sin anak di ipogaw. ");
INSERT INTO kne_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Siya na di kaman sinyal ay maipeey sin takkay ya kitong ay mangipanpanemnem sin inyat Diyos ay nangipango en datako ay komaan ed Egipto babaen sin nakaskasdaaw ay panakabalina.’ Say ibaga yo di sin an-ak yo,” kanan Moses en daida. ");
INSERT INTO kne_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Idi pinakaan din ari ed Egipto din Israelita, adi inturong Diyos daida sin kaaptikan ay danan ay mandan ed Filistia, tan kanan Diyos sin nemnem na, “Adiak layden ay manbabawi da et mantaoli da ed Egipto mo waday mangobat en daida.” ");
INSERT INTO kne_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Inturong Diyos daida sin lugar ay magay omili ay manturong ed baybay ay Mandalangdang. Wada di intaktakin da ay armas da sin nandad-anan da. ");
INSERT INTO kne_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Intakin Moses din tong-an Jose tan say dadlon inpaisapatan Jose sin Israelita ay nangwani, “Mo domteng din timpo ay ipangon Diyos dakayo ay komaan isnan Egipto, dadlon yon itakin din tong-ak.” ");
INSERT INTO kne_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tinaynan din Israelita ed Succot et nankampo da ed Etam sin benget di lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Sin nandad-anan da, wada di kaman posti ay natotood ay liboo ay mangon-on-ona, tan say inyat Diyos ay mangipango en daida. Mo sin labi, manbalin si kaman posti ay apoy et mangon-ona ay manilsilaw sin danan da, isonga mabalin ay mandad-an da sin labi ya kaagawan. ");
INSERT INTO kne_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Kanayon ay wada din apoy ya liboo ay mangipangpango en daida sin labi ya kaagawan. ");
INSERT INTO kne_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Idi siya di, kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ibagam sin Israelita ta mantaoli kayo ed Pihahirot ay nan-gawaan di Migdol ya baybay ay Mandalangdang sin asag-en ed Baal Zefon ta mankampo kayos di. ");
INSERT INTO kne_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Tan ipagarup din ari ay naiaw-awan kayo ay lomikeliked et naskok kayo sin kadardaratan. ");
INSERT INTO kne_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Pakentegek din nemnem di ari et apayawenas dakayo, ngem awni et abakek din ari ya sosoldado na et say kailaan di panakabalin ko. Say pangammoan din taga-Egipto ay sak-en si Diyos.” Et pinatin din Israelita din naibilin en daida. ");
INSERT INTO kne_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Idi naammoan din ari ay enggay linmayaw din Israelita, nanbaliw kasin din nemnem na ya siya abe sin oopisyal na. Kanan da, “Ay sino ngin nas inamag tako? Inpalobos tako et din Israelita et magay bag-en tako.” ");
INSERT INTO kne_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Inpaisaganan din ari din kaman kalisa ay logana ay pakigobat ya din sosoldado na. ");
INSERT INTO kne_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Inkoyog na amin ay logan ay pakigobat pati din enem ay gasot ay kasigedan ay nanloganan di sag-eesa ay opisyal di soldado na. ");
INSERT INTO kne_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","9","Gapo ta inpakenteg Diyos din nemnem di ari ed Egipto, inapayaw na din Israelita ay nangipappailas toled da ay komaan, et indasan das daida sin nankamkampoan da sin benget di baybay ay Mandalangdang sin asag-en ed Pihahirot ya Baal Zefon. ");
INSERT INTO kne_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Idi tamangen din Israelita ay enggay omas-asag-en din ari ya din sosoldado na, inmegyat da et nankararag da ay mankedaw si badang Diyos. ");
INSERT INTO kne_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nanriri da en Moses yan kanan da, “Ay tan magay kaikaotan mi ed Egipto isonga in-alim dakami isnan lugar ay magay omili ta say kateyan mi? ");
INSERT INTO kne_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Inbaga mi met dedan ed Egipto en olay bay-am dakami ay maibag-en sin taga-Egipto. Agpos et pay laeng di komakaman ay bag-en isdi mo din matey isnan lugar ay magay omili.” ");
INSERT INTO kne_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ngem kanan Moses en daida, “Adi kayon emegyat. Papigsaen yo di nemnem yo tan ed wani ay agew, ilaen yo di iyat Diyos ay mangisalakan en dakayo. Awni et adi kayo kasin mail-ila din taga-Egipto ay ilaen yo ed wani. ");
INSERT INTO kne_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Adi kasapolan ay mankoti kayo, tan si Diyos di makilaban para en dakayo.” ");
INSERT INTO kne_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Idi siya di kanan Diyos en Moses, “Apay nga mankedkedaw kayo si badang? Ibagam sin Israelita ta itoloy yo et ay mandan. ");
INSERT INTO kne_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ikayang mo san sokod mo sin patag di baybay ta mansian din danom ta say mamgaan di pandanan di Israelita ay manbalasat sin baybay. ");
INSERT INTO kne_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Sepsepek ay pakentegen din nemnem di taga-Egipto et apayawen da si dakayo ta say maila din panakabalin ko begew sin iyat ko ay mangabak sin ari ya sin amin ay sosoldado na. ");
INSERT INTO kne_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Say pangammoan din taga-Egipto ay sak-en si Diyos mo abakek daida.” ");
INSERT INTO kne_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Idi siya di, nan-etan sin likod din anghel Diyos ay mangipangpango sin Israelita. Olay din kaman posti ay liboo sin sango da yan nan-etan sin likod ");
INSERT INTO kne_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","et nantee sin nan-gawaan di taga-Egipto ya Israelita. Sin labi ay sana nanbalin din kaman posti ay liboo si silaw sin kad-an di Israelita, ngem inpabolinget na din kad-an di taga-Egipto, isonga adi da mabalin ay mansinag-en sin labi ay doy. ");
INSERT INTO kne_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Inkakayang Moses din takkay na ay inpaturong sin baybay et inpawadan Diyos di napigsa ay dagem ay napo sin naibandas belaan di agew ay nangipasian sin danom. Naninsinlabi ay nandagdagem et namgaan din gawan di baybay, ");
INSERT INTO kne_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","isonga namgaan di nandanan din Israelita ay nanbalasat sin baybay et kaman dingding din danom ay nansian sin nan-inigid. ");
INSERT INTO kne_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Din taga-Egipto ay nangabakabayo ya nanlogan si para gobat et inapayaw da din Israelita sin gawan di baybay. ");
INSERT INTO kne_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ngem sin parbangon, inosdongan Diyos manipod sin kad-an di kaman posti ay liboo ya apoy din taga-Egipto et kinibtot na si daida. ");
INSERT INTO kne_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Inlotlot na din pilid di logan da, isonga maligatan da ay mangapayaw sin Israelita. Inmegyat din taga-Egipto et kanan da, “Komaan tako et isna tan nay baw ay si Diyos di makilaban para sin Israelita!” ");
INSERT INTO kne_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Idi siya di kanan Diyos en Moses, “Ikayang mon takkay mo sin patag di baybay ta mantaoli din danom ta malned din taga-Egipto pati din kabayo ya logan da.” ");
INSERT INTO kne_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Inkayang Moses din takkay na sin patag di baybay et nantaoli din danom sin sigod ay kad-ana idi kosto ay pomatpat-a. Pinadas din taga-Egipto ay komaan sin danom ngem intep-an Diyos daida sin gawan di baybay. ");
INSERT INTO kne_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nalned amin din taga-Egipto pati din kabayo ya logan da et magay nabay-an si olay esa en daida. ");
INSERT INTO kne_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ngem namgaan pay di nandanan din Israelita sin timpo ay nanbalasat da sin baybay tan kaman dingding sin nan-inigid din danom ay nansian. ");
INSERT INTO kne_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Sin agew ay doy, insalakan Diyos din Israelita sin taga-Egipto, et inila da din natenatey ay taga-Egipto sin benget di baybay. ");
INSERT INTO kne_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Sin nangilaan da sin nakaskasdaaw ay panakabalin Diyos sin inyat na ay nangabak sin taga-Egipto, inmegyat da ya nantalek da en Diyos yan siya abe ay nantalek da en Moses ay baa na. ");
INSERT INTO kne_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Pag kantaen da Moses ya din Israelita din kanta ay nay ay pangidayaw da en Diyos. “Sik-a ay Diyos di idayaw ko isnan kansiyon ko, tan nakaskasdaaw din inyat mo ay nangabak sin kalaban mo, tan inilned mo sin baybay din sosoldado ya kabayo. ");
INSERT INTO kne_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Sik-a ay Diyos di pankamangak, tan begew sin inyat mo et naisalakanak. Sik-a ay Diyos di idayaw ko, Diyos ay dinaydayaw di ap-apo, din kinangatom et say ikankansiyon ko. ");
INSERT INTO kne_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Si Yahweh di ngadan mo ay en ka inpaammo, mo maipanggep si gobat, palaloy laing mo. ");
INSERT INTO kne_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","En ka et intep-a sin baybay ay annawa din sosoldadon di Egipto pati din loglogan da. Nalned din kalaingan ay ap-apon di soldado da ed baybay ay Mandalangdang ay kanan da. ");
INSERT INTO kne_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Sin malosong ay baybay et nalim-otan da, kaman dan bato ay nalned sin lanad na. ");
INSERT INTO kne_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Kaeegyat san bikas di takkay mo, Apo, tan mekmekena tet-ewa amin ay kalaban mo. ");
INSERT INTO kne_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Madaydayaw ka sin panakabalin mo ay nangabak sin kalaban mo. Kaman apoy din bonget mo, et kaman dan garami ay domapo. ");
INSERT INTO kne_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Sinib-okam din baybay et nansian din danom, danom ay man-oy-oyas et natood ay kaman bonton, kaman dan kinmenteg ay ginminek din dalloyon. ");
INSERT INTO kne_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Din kalaban mi yan kanan da, ‘Apayawen tako ta depapen takos daida, asoten tako din kampilan tako et maabak da. Alaen tako amin ay sanikwa da, panbibingayan tako din gamgameng da.’ ");
INSERT INTO kne_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ngem esay sib-ok mo yan nalned dan taga-Egipto, nalned da ay kaman ismay sin kaeegyat ay baybay. ");
INSERT INTO kne_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Magay didiyosen si makaiso en sik-a ay Apo, tan magay makaiso sin kinasantom ya kinasiged mo, maga abe di makaamag sin nakaskasdaaw ay inyat mo.” ");
INSERT INTO kne_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Makdeng pay di, si Miriam ay esay mamadto ay manang da Aaron et nan-as tambol. In-onod din amin ay babbabai et nanambol da dowan dan mansala. ");
INSERT INTO kne_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Inkantaan Miriam daida yan kanana, “Idayaw takos Diyos isnan kansiyon tako. Nakaskasdaaw din inyat na ay nangabak sin kalaban tako, tan inilned na sin baybay din sosoldado ya kabayo.” ");
INSERT INTO kne_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Makdeng pay di inpangon Moses din Israelita et tinaynan da din baybay ay Mandalangdang. Nanturong da sin lugar ay magay omili ay manngadan si Shur. Nandad-an das di si tolo ay agew, ngem magay danom si dinteng da. ");
INSERT INTO kne_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Pag dan domateng ed Mara, ngem adi kainom di danom isdi tan palalo ay manpait. Siya nay gapo na ay nangadanan din lugar ay nay si Mara. ");
INSERT INTO kne_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kanan din ipogaw ay nanriri en Moses, “Into ngin di inomen tako?” ");
INSERT INTO kne_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Siya di nankararag si Moses ay manpabadang en Diyos, et pag ipailan Diyos di esay kaiw ay say intep-an Moses sin danom et pag somiged et mabalin ay mainom. Isdi ay pinadas Diyos daida ya inbilina di kosto ay amagen da. ");
INSERT INTO kne_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kanana en daida, “Mo patien yos sak-en et amagen yo din kosto sin pangilak ya tongpalen yo din am-in ay bilbilin ko, adiak ipalak-am en dakayo din saksakit ay inpalak-am ko si taga-Egipto. Tan sak-en si Diyos ay mangagas en dakayo.” ");
INSERT INTO kne_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Intoloy da ay nandan enggana ay sinmawang da ed Elim ay kad-an di sinpo ya dowa ay obbog ya pitopolo ay kaiw ay palma. Isdi ay nankampo da sin asag-en di danom. ");
INSERT INTO kne_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Tinaynan din amin ay Israelita ed Elim, et sin maika-15 di maikadwa ay bowan manipod sin nanaynanan da ed Egipto, dinmateng da ed Sin ay esay lugar ay magay omili sin nan-gawaan di Elim ya Sinai. ");
INSERT INTO kne_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Sin lugar ay sana, nanriri da amin en da Moses en Aaron ");
INSERT INTO kne_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ay nangwani, “Olay et koman pinsen Diyos dakami ed Egipto. Sin isdi, mabalin ay mansida kamis karni ya mangan kamis kompormi ay layden mi enggana ay mabsog kami. Ngem inpango yo dedan dakami ay komaan isdi ta matey kami amin si dagaang isnan lugar ay magay omili.” ");
INSERT INTO kne_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","5","Pag kanan Diyos en Moses, “Dengngem na: awni et pawadaek di ad-ado ay makan ay mapo ed daya ay kaman odan. Masapol ay inagew ay bemela din ipogaw ta man-olnong das omanay ay kanen da si esay agew. Sin maikan-em ay agew, masapol ay mamidwa di kaad-adon di olnongen da mo din sigod ya masapol ay otoen da. Say ibilin ko dana ta padasek daida mo onodan da met laeng din bilbilin ko.” ");
INSERT INTO kne_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","7","Makdeng pay ay ibagan Diyos di, kanan da Moses en Aaron sin Israelita, “Sin malablabi ya agsapa, ipailan Diyos din panakabalina ta pangammoan yo ay sisya tet-ewa di nangipango en dakayo ay komaan ed Egipto. Tan dinnge na din ad-ado ay riri yo en sisya. Aw, tet-ewa ay si Diyos di nanririan yo ay baken dakami, tan owat kamin baa ay mantongtongpal sin bilina.” ");
INSERT INTO kne_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kanan Moses ay nangitoloy, “Si Diyos di mangidawat si karni en dakayo sin malablabi ya tinapay sin agsapa olay intoy kaad-adon di layden yo, tan dinnge na din riri yo en sisya. Katet-ewa na, si Diyos di ib-ibawen yo sin panririan yo en dakami.” ");
INSERT INTO kne_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Pag kanan Moses en Aaron, “Ibagam sin amin ay Israelita ta omali da amin ay makisango en Diyos, tan dinnge na din ad-ado ay riri da.” ");
INSERT INTO kne_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Idi mankalkali pay laeng si Aaron sin amin ay Israelita, sinagong da din lugar ay magay omili, et pag dan ilaen din koniniing en Diyos sin liboo. ");
INSERT INTO kne_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Pag kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Dinngek din ririn di Israelita isonga ibagam na en daida: Sin malablabi, mawada di karni ay sida da. Sin agsapa, mabsog da abes tinapay. Maamag na ta say pangammoan da ay sak-en si Yahweh ay Diyos yo.” ");
INSERT INTO kne_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Malablabi pay tet-ewa, domanateng di ad-ado ay titit et enggay tinmapog da sin lota sin kampon di Israelita. Sin agsapa abe, pag dono din nanniliked sin kampo. ");
INSERT INTO kne_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Idi mamgaan pay din dono, waday naipayapayag sin kadaratan ay naingpis ay kakaman andap. ");
INSERT INTO kne_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Idi ilaen din Israelita, kanan da ay nan-asibaga, “Ay sino pay na?” tan adi da ammo mo sino di. Pag kanan Moses, “Sinay din makan ay indawat Diyos en dakayo. ");
INSERT INTO kne_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Kanan Diyos en man-olnong kayo si maikosto sin kasapolan yo. Sag-eesa ay salop sin esa ay mimbron di pamilya.” ");
INSERT INTO kne_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Say inamag tet-ewa din Israelita di. Waday odom ay nan-olnong si ad-ado yan wada abey at-atik, ");
INSERT INTO kne_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ngem idi sokaten da, baken nansobra din nangolnong si ad-ado yan baken nankolang din nangolnong si at-atik. Pag naikostokosto din inolnong da. ");
INSERT INTO kne_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kanan Moses en daida, “Magay man-idolin si para si bigat.” ");
INSERT INTO kne_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ngem adi pinatin din odom si Moses et nan-idolin da. Sin kabigatana, nabigisan dowan nabangnges ay man-agob din indolin da, et manbonget si Moses gapo sin inamag da. ");
INSERT INTO kne_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Inagsapa ay nan-olnong da insigon sin kaad-adon di kasapolan da. Din mabay-an sin lota yan matenaw mo mansey-ang. ");
INSERT INTO kne_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Sin maikan-em ay agew, mamidwa mo din sigod ay kaad-adon di ol-olnongen da di alaen da, isonga sagdodowa ay salop si esay ipogaw. Nasinop amin din papangolon di Israelita et inbaga da en Moses. ");
INSERT INTO kne_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Pag kanan Moses en daida, “Inbilin Diyos ay mo si bigat yan nabanol ay agew ay pan-ibbayan para en Diyos, isonga magay man-obla. Man-oto kayo ed wani sin amin ay layden yo ay otoen. Idolin yo din mabay-an para si bigat.” ");
INSERT INTO kne_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Tinongpal da din bilin Moses et indolin da din mabay-an para sin kabigatana, yan laton ay adi nabigis ono nabangnges. ");
INSERT INTO kne_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kanan Moses, “Say kanen yo sa ed wani, tan ed wani di makwani en agew ay pan-ibbayan tako ay para en Diyos. Magay maa ed wani si makan sin lota. ");
INSERT INTO kne_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Man-olnong kayo sin enem ay agew si makan, ngem sin maikapito et maga, tan say agew ay pan-ibbayan.” ");
INSERT INTO kne_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Sin maikapito ay agew, wada pay laeng di binmela ay en man-a koma si makan, ngem maga polos di inila da. ");
INSERT INTO kne_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pag kanan Diyos en Moses, “Ay pig-an pay di panongpalan yo si ibagak? ");
INSERT INTO kne_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nenemnemen yo ay sak-en ay Diyos di nandotok si esay agew ay pan-illengan yo, isonga idawat ko sin maikan-em ay agew di kanen yo si dowa ay agew. Magay omaddawi sin beey na sin maikapito ay agew mo adi et mantetee kayo sin beey yo.” ");
INSERT INTO kne_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nanlogi isdi, adi da man-obla sin maikapito ay agew. ");
INSERT INTO kne_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Nginadanan di Israelita si manna din makan ay doy ay mapod daya. Din kailaana yan mankilat ya kinittoy ay kaman bokel yan kaman tinapay ay nalaokan si anig di katamtamana. ");
INSERT INTO kne_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kanan Moses, “Inbilin Diyos ay man-idolin tako sin manna ay nay ta waday pangil-ilaan din poli tako sin makan ay indawdawat Diyos sin kawada takos lugar ay magay omili sin nangipangoana en datako ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kanan Moses en Aaron, “Man-a kas koli ta pey-am si esay salop ay manna. Igtom to sin Baol di Tolagan Diyos ta way pangil-ilaan din aap-o tako.” ");
INSERT INTO kne_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sin kosto ay timpo, inonodan Aaron din inbilin Diyos en Moses, et inpeey na sin sangoanan di nadampilak ay bato ay naigolitan di bilbilin Diyos sin Baol ta say kaidolinana. ");
INSERT INTO kne_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Manna di kinkinan din Israelita si opatapolo ay tawen enggana ay dinmateng da ed Canaan ay say nan-ilian da. ");
INSERT INTO kne_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Tinaynan din am-in ay Israelita din kadardaratan ed Sin, et nan-etaetan da ay maibasar sin inbilin Diyos enggana ay domateng da ed Refidim, et pag dan mankampos di. Ngem magay danom sidis pan-inoman da. ");
INSERT INTO kne_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Isonga nanriri da en Moses ay mangwani, “Iyaam dakamis danom ay inomen mi.” Asi et kanan Moses ay nanongbat, “Apay nga ririen yos sak-en? Apay magay talek yo en Diyos ta padpadasen yos sisya?” ");
INSERT INTO kne_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ngem palalo ay manbigaw din ipogaw ay sana, isonga intoltoloy da ay nanrirriri en Moses ay mangmangwani, “Apay nga inbelam dakami ed Egipto? Ay kambaw in-alim dakami sina ta peslem dakami ya din an-ak mi ya talaken mi si bigaw!” ");
INSERT INTO kne_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Idi siya di, inpasnek Moses ay nankararag en Diyos et kanana, “Ay sino ngin di iyat ko sin ipogaw ay nay? Nay dandani et ay pigpigen das sak-en!” ");
INSERT INTO kne_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kanan Diyos en Moses, “Ikoyog mo din odom ay papangolon di Israelita ta mangon-ona kayo. Itakin mo din sokod ay inseppat mo sin ginawang ay Nile. ");
INSERT INTO kne_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Awni et wadaak ay pomipika sin bato sin sangoanan yo sin dontog ay Sinai. Iseppat mo san sokod mo sin bato et bemelan to di danom ta way inomen din ipogaw ay sana.” Say inyat tet-ewan Moses di ay iniilan di papangolon di Israelita. ");
INSERT INTO kne_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Asi et nginadanan Moses din lugar ay sana si Massa ya Meriba, tan nanriri din Israelita dowan dan pinadpadas si Diyos ay nangwani, “Into ngin si Diyos?” ");
INSERT INTO kne_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Idi wada pay laeng din Israelita ed Refidim, inmey din Amalekita ay mangobat en daida. ");
INSERT INTO kne_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Et kanan Moses en Josue, “Manpili ka si lallalaki ta en yo gobaten din Amalekita si bigat. Wadaak to sin toktok di dontog ay mangikakayang sin sokod ay kanan Diyos en itakin ko.” ");
INSERT INTO kne_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tinongpal Josue din inbilin Moses et inmey da ginobat din Amalekita. Mo pay da Moses en Aaron ya si Hur, nanikid da sin toktok di dontog. ");
INSERT INTO kne_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mo ikayang Moses din takkay na, mangab-abak din Israelita, ngem mo ibaba na, mangab-abak abe din Amalekita. ");
INSERT INTO kne_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Idi nabbay din takkay Moses, nan-as da Aaron en Hur si bato ay tomokdoana et pinmipika da ay sag-eesa da ay nangikakayang sin takkay Moses enggana ay nadipos din agew. ");
INSERT INTO kne_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Idi say inyat da di, inabak da Josue din Amalekita. ");
INSERT INTO kne_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Pag kanan Diyos en Moses, “Isolat mo din kadad-atan di nangabakan yo ta waday pangnemnemneman yo. Ibagam en Josue ay awni et dosaek din Amalekita ta maga di kaingadngad-anan da.” ");
INSERT INTO kne_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Asi pay man-amag si Moses si altar et nginadanana “Si Diyos di bandilak!” ");
INSERT INTO kne_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Pag nan kapayen din altar yan kanana, “Si naey di kaman bandila ay mangipaila ay itoltoloy Diyos ay mangobat sin Amalekita si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Binmala si Moses ay en nangabat en katogangana et nanyakog-ong sin sangoanana yan inongoana. Makdeng pay ay man-asidamag da si kasasaad di esa ya esa, sinenggep da sin tolda ay nanbeeyan Moses. ");
INSERT INTO kne_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Pag dad-aten Moses en katogangana amin din inamag Diyos sin ari ed Egipto ya din ipogaw na begew sin Israelita. Dinad-at na amin din ligat da sin danan ya din inyat Diyos ay nangisalakan en daida. ");
INSERT INTO kne_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Palalo di ragsak Jetro sin nanngeana sin amin dana ay siged ay inam-amag Diyos para sin Israelita. ");
INSERT INTO kne_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Kanana, “Madaydayaw si Diyos ay nangisalakan en dakayo sin taga-Egipto ya din ari da. ");
INSERT INTO kne_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ed wani, ammok ay napigpigsa si Diyos mo din amin ay didiyosen, tan insalakana din Israelita sin taga-Egipto ay nanglaslasoy ya namalpaligat en daida.” ");
INSERT INTO kne_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Pag idawat Jetro di maidaton en Diyos ay mapooan ya odom ay datdaton. Makdeng pay di, si Aaron ya din amin ay papangolon di Israel et nan-ookob dan da katogangan Moses sin sangoanan Diyos. ");
INSERT INTO kne_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Idi kasin napat-a, tinmokdo si Moses ay mangikeddeng sin kason di kaipoipogaw. Inalibongbongan din kaipoipogaw sisya manlogi sin agsapa enggana sin malabi. ");
INSERT INTO kne_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Idi inilan katogangan Moses din amin ay am-amagena para sin kaipoipogaw, kanana, “Ay maney pay sas am-amagem para sin ipogaw. Apay dedan ay es-esam yan manlogi sin agsapa engganas malabi ay waday mangikamang si kaso dan sik-a?” ");
INSERT INTO kne_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Kanan Moses ay sinombat, “Tan omali da din ipogaw ay mangammo si layden Diyos. ");
INSERT INTO kne_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Mo wada di man-iibaw, omali dan sak-en et ikeddeng ko mo sino di kosto yan ibagak abe din bilbilin ya linteg Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kanan Jetro, “Baken kosto sas iyat mo. ");
INSERT INTO kne_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Palpaligatem anggoy san awak mo, siya abe sin ipogaw. Tan palalo ay nadagsen sas oblam et adi kan kabaelan mo ang-anggoy mo. ");
INSERT INTO kne_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Dengngem nan ibagak et tolongan dakan Diyos. Din oblam et panakaawak din ipogaw ay mangibaga en Diyos sin problima da. ");
INSERT INTO kne_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Sik-a di mangitdon daida sin bilbilin ya linteg Diyos ya din ogali ay onodan da koma ya din odom ay lebbengen da ay amagen. ");
INSERT INTO kne_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ngem siya na abe di amagem koma. Manpili ka en daida si nalaing ay lallalaki ay emegyat en Diyos, matalek ya adi mabalin ay mapasoksokan. Isaad mos daida ay mangasikaso sin ipogaw ay mabingabingay si sagsisinlibo, sagsisin-gasot, saglilimapolo ya sagsisinpo. ");
INSERT INTO kne_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Daida di kanayon ay mangowis sin ipogaw. Ikamang dan sik-a din nadadagsen ay kaso ngem daida di mangikeddeng sin nalalag-an. Mo siya di, lomag-an din oblam tan badangan das sik-a. ");
INSERT INTO kne_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Mo say amagem di ya siya met laeng di bilin Diyos, adi kan to maligatan ya somaa abe din kaipoipogaw ay mapnek di nemnem da.” ");
INSERT INTO kne_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Pinatin Moses din inbagan katogangana. ");
INSERT INTO kne_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nanpili sin Israelita si makabael et dinotokanas daida ay mangipangolo sin ipogaw ay mabingabingay si sagsisinlibo, sagsisin-gasot, saglilimapolo ya sagsisinpo. ");
INSERT INTO kne_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Et kanayon ay kinedkeddengan da din kason di kaipoipogaw. Din nadagsen, inkamang da en Moses, ngem din nalag-an yan kineddengan da. ");
INSERT INTO kne_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Makdeng pay di, nanpakada si Jetro en Moses et nantaoli sin ili na. ");
INSERT INTO kne_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Tinaynan din Israelita ed Refidim et dinmateng da sin lugar ay magay omili ed Sinai, sin damo ay agew di maikatlo ay bowan manipod sin kinmaanan da ed Egipto. Nankampo da sin asag-en di dontog ay Sinai ");
INSERT INTO kne_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","et pag manikid si Moses sin dontog ay en mangabet en Diyos. Nakikali si Diyos en Moses sin dontog, et inbilina di ibagan Moses sin Israelita ay polin Jacob ay kanana, ");
INSERT INTO kne_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Inila yo din inamag ko ay Diyos yo sin taga-Egipto. Ngem dakayo pay, inayowanak dakayo ay in-alis na babaen sin panakabalin ko ay kaman din iyat di titit ay agila ay mangayowan sin anak na mo iloglogi da ay mantayaw. ");
INSERT INTO kne_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Mo dadlon yon patpatien sak-en ya tongtongpalen yo din intolag ko en dakayo, dakayo di piliek ay nabanol ay ipogaw ko, olay mo katet-ewa na et okak met laeng amin ay ipogaw isnan lobong. ");
INSERT INTO kne_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Dakayo abe di iturayak ay naidadaton en sak-en ya papadi ay mansilsilbi en sak-en ay Ari yo.” ");
INSERT INTO kne_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Makdeng pay di, nanballalong si Moses, pag nan topogen din papangolon di Israelita et inbaga na en daida din am-in ay inbilin Diyos. ");
INSERT INTO kne_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Idi inbagan Moses di, nantitimpoyog amin din ipogaw ay nangwani, “Amagen mi amin ay inbagan Diyos.” Et say en inbagan Moses en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Idi siya di, kanan Diyos en Moses, “Bomabaak to sin kad-am ay maikoyog si naposkol ay liboo ta say dengngen din ipogaw ay makikalkaliak en sik-a ya patien daka manipod ed wani.” Idi dinad-at Moses din inbagan di ipogaw, ");
INSERT INTO kne_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","pag kanan Diyos, “En ka ibaga sin ipogaw ta ilogi dad wani ay manlinis enggana si bigat, ta say nalinis da ay mandayaw en sak-en. Masapol ay labaan da din bado da. ");
INSERT INTO kne_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Masapol ay nakasagana da tan mo si loman, bomabaak isnan dontog ay Sinai ay iilaen din kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Markaam di beddeng sin nanniliked di dontog ta say kapap-engan di ipogaw. Ibagam en daida ta adi dan mantiktikid sin dontog ono somag-en ay mandan sin poona, tan mo waday mangamag sidi et masapol ay matey. ");
INSERT INTO kne_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Panaen ono pigpigen yo ta adi kayo omasag-en. Olay ipogaw ono animal di somag-en et masapol ay matey, ngem mo wada ay dengngen yo din tanggoyob, mabalin ay somag-en din kaipoipogaw sin dontog.” ");
INSERT INTO kne_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Nanballalong si Moses sin dontog et inbaga na sin ipogaw ay mansagana da ay mandayaw en Diyos, isonga nilabaan da din bado da. ");
INSERT INTO kne_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kanan Moses, “Masapol ay nakasagana kayo si loman yan adi kayon daddaagen din asawa yo enggana ay makdeng di.” ");
INSERT INTO kne_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Sin kaagsapaan di maikatlo ay agew, mankido dowan mankimat pag et mawada di naposkol ay liboo sin dontog. Dinnge da abe di napigsa ay tanggoyob et manpayegpeg din kaipoipogaw si egyat da. ");
INSERT INTO kne_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Pag ipangon Moses daida et inmey da amin sin poon di dontog ay Sinai ta en da abaten si Diyos. ");
INSERT INTO kne_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Enggay nalim-otan si asok din dontog ay Sinai tan kaman apoy di inyat Diyos ay nanpaila sin binmabaanas di. Komaykayang din asok ay kaman din asok di mapoppooan ay dontog, et enggay manpayegpeg dan ipogaw si egyat da. ");
INSERT INTO kne_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dowan aben pomigsa ay pomigsa din tanggoyob. Idi mankali si Moses et songbatan Diyos yan kaman kido din kali na. ");
INSERT INTO kne_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Binmaba si Diyos sin toktok di dontog ay Sinai, pag nan ayagan si Moses. Idi nantikid si Moses, ");
INSERT INTO kne_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","kanan Diyos en sisya, “En ka ibaga sin ipogaw ta adi dan lablabsan din beddeng tan mo kanan da et en somag-en da ay mangila en sak-en. Ad-ado di matey mo say iyat da. ");
INSERT INTO kne_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Olay din papadi et dosaek mo somag-en da ay baken dan nalinis.” ");
INSERT INTO kne_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kanan Moses ay nanongbat, “Laton ay adi mantikid din ipogaw, tan doy met ay inbabagam en markaan mi di beddeng sin nanniliked di dontog ta maiparit di somag-en, tan nasantoan gapo ta say pinilim ay panpappailaam.” ");
INSERT INTO kne_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ngem kanan Diyos en sisya, “Olay mo siya sa, emey ka pay dedan ta ikoyog mo si Aaron ay omalis na. Dadlon mon ibaga sin papadi ya ipogaw ta adi dan padpadasen ay omali ono malabas sin beddeng, tan dosaek daida mo say amagen da.” ");
INSERT INTO kne_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Et pag manballalong si Moses ay mangibaga sin inbilin Diyos. ");
INSERT INTO kne_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Idi makdeng di, pag mankalis Diyos yan kanana, ");
INSERT INTO kne_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Sak-en si Yahweh ay Diyos yo ay nangipango en dakayo ay komaan ed Egipto ay naibabag-enan yo. ");
INSERT INTO kne_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Adi kayo mandaydayaw si odom ay diyos mo adi sak-en et anggoy. ");
INSERT INTO kne_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Adi kayon man-am-amag ono mankitkitikit si daydayawen yo sin kompormi ay kaman din wadad daya, wadas nan lota ono wada sin danom. ");
INSERT INTO kne_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Adi kayon manyakog-ong ono mandayaw en daida, tan sak-en si Yahweh ay Diyos yo et adiak ipalobos ay waday ikadkadwa yon sak-en ay daydayawen yo. Dosaek di mangontra en sak-en ya din poli na enggana sin anak di apo na. ");
INSERT INTO kne_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ngem ipailak pay di layad ko sin manglaylayad en sak-en ya manongpal sin bilbilin ko engganas maikapiga ay libo ay apo. ");
INSERT INTO kne_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Adi yon os-osalen din ngadan ko si owat magay silbi na, tan sak-en si Yahweh ay Diyos yo et dadlonak dosaen din adi mamanol sin ngadan ko. ");
INSERT INTO kne_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Banolen yo din agew ay pan-ibbayan ta ikasin yo ay agew para en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Enem ay agew di pan-oblaan yo, ");
INSERT INTO kne_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ngem din maikapito ay agew et pan-ibbayan ay naidaton en sak-en. Isonga maga di man-obla sin agew ay doy, olay din an-ak ya bag-en yo, din animal yo ya din mangili ay wada sin ili yo. ");
INSERT INTO kne_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tan sak-en ay Diyos et pinarsuak sin enem ay agew din daga, ed daya, din baybay ya din amin ay wada en daida, ngem nan-ibbayak sin maikapito ay agew, isonga tinodingak di ay say agew ay pan-ibbayan ay mailasin para en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Patgen yos da ama en ina yo ta say omando di biyag yo sin daga ay idawat ko en dakayo. ");
INSERT INTO kne_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Adi kayo manpespese. ");
INSERT INTO kne_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Adi kayon daddaagen di baken yon asawa. ");
INSERT INTO kne_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Adi kayon mangak-akew. ");
INSERT INTO kne_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Adi kayon mantistigo ay man-etek. ");
INSERT INTO kne_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Adi kayon gamgamgaman din beey di ib-a yo, din asawa na, baa na, baka ya dangki na ya odom pay ay sanikwa na.” ");
INSERT INTO kne_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Manpayegpeg din ipogaw si egyat da idi dengngen dan kido ya tanggoyob dowan dan ilaen din kimat ya omas-asok ay dontog, isonga adi da sinmag-en sin dontog. ");
INSERT INTO kne_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Et kanan da en Moses, “Olay sik-a et di makikali en dakami et laton ay patien mi. Basta baken si Diyos tan adi pay matey kami.” ");
INSERT INTO kne_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ngem kanan Moses ay nanongbat, “Adi kayon emegyat tan inmali si Diyos ta ilaena mo tet-ewa ay patien yos sisya ya itoltoloy yo ay manongpal sin bilina ta adi kayon manbasol.” ");
INSERT INTO kne_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ngem nantettee dan ipogaw sin ad-addawi et enggay Moses si sinmag-en sin naposkol ay liboo ay kad-an Diyos. ");
INSERT INTO kne_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Adi yon sakitan ono paligaten di mangili. Nemnemnemen yo ay nanbalin kayo abe ay mangili ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Adi yon paligaten di nalasang ya naolila, ");
INSERT INTO kne_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","tan mo say iyat yo, sak-en ay Diyos et songbatak din adawag da ay mankedaw si badang ko. ");
INSERT INTO kne_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Bomongetak et peslek dakayo sin gobatan ta malasang din asawa yo ya maolila abe din an-ak yo. ");
INSERT INTO kne_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Mo man-iotang kayo sin nabibiteg ay ipogaw ko, adi kayon manpapatpatang ay kaman din iyat di manpapaotang. ");
INSERT INTO kne_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Mo waday ina yo di tak-ep di bado na gapo ta say sinyal di tolagan ay bayadana din inotang na, masapol ay itaoli yo mo malablabi, ");
INSERT INTO kne_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","tan enggay na si pansalina si tengnin sin labi. Mo magay igaley na, intoy iyat na pay ay maseyep? Mo mankedaw adi si badang ko, badangak tan managseg-angak. ");
INSERT INTO kne_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Adi yo laslasoyen si sak-en ay Diyos ya adi yo aben palawlawaen din pangolon di ili yo.” ");
INSERT INTO kne_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Pag kanan Diyos en Moses ay nangitoloy, “En ka ayagan da Aaron en Nadab ya si Abihu ya pitopolo ay papangolon di Israelita ta mantikid kayos na, ngem adi kayon somag-en sin kad-ak mo adi et mandokmog kayo ed dagdagas ay mandayaw en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Sik-a et anggoy di somag-en en sak-en, tan adi mabalin ay somag-en din odom. Mo din kaipoipogaw pay, iparit ko ay mantikid da sin dontog ay nay.” ");
INSERT INTO kne_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","En inbagan Moses sin ipogaw din amin ay bilin ya linteg Diyos yan kanan da amin ay sinombat, “Siya, tongpalen mi amin ay inbagan Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Et insolat Moses amin din bilbilin Diyos. Sin kabigatana, nasapa ay nan-amag si altar ay pan-idatonan sin poon di dontog. Tinood na di sinpo ya dowa ay bato ay para sin sinpo ya dowa ay tribun di Israelita. ");
INSERT INTO kne_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Pag nan ibaa di babbaro ta pooan da di maidaton en Diyos ya man-idaton da abe si odom ay baka ay say pan-ookoban di ipogaw ya makikadkadwaan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Pinalapalangganan Moses din kagodwan di dadan di animal ay naidaton, asi nan iwalsi din kagodwa na sin altar. ");
INSERT INTO kne_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Pag nan alaen din naisolatan di intolag Diyos ay nanlaon sin bilbilina et inpigsa na ay mangibasa ta dengngen din kaipoipogaw. Idi makdeng ay ibasan Moses, kanan din ipogaw, “Tongpalen mis Diyos et amagen mi amin din inbilina.” ");
INSERT INTO kne_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Idi siya di, inan Moses din napalanggana ay dada et inwalsi na sin ipogaw dowanan kanan, “Din dada ay nay di mangipaneknek sin intolag Diyos ya mangipaila ay nakitolag kayo ay tongpalen yo dana ay bilbilin.” ");
INSERT INTO kne_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Makdeng pay di, kanan Diyos kasin en Moses, “Mantikid kas nan kad-ak ay dontog et mantee kas na, ta idawat ko di dowa ay nadampilak ay bato ay nangisolatak sin bilbilin ko ta maitdo sin kaipoipogaw.” ");
INSERT INTO kne_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Nansaganas da Moses en Josue ay kabadang na ta mantikid da sin dontog ay kad-an Diyos. ");
INSERT INTO kne_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ngem kanana ay nangibilin sin papangolon di Israelita, “Sed-en yos dakami isnan kampo enggana ay mantaoli kami. Nay da Aaron en Hur ay kamangen yo mo waday adi yon pankinaawatan.” ");
INSERT INTO kne_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Intoloy Moses ay nantikid sin dontog ay Sinai yan wada et di liboo ay nanlikob sin dontog. ");
INSERT INTO kne_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Naipaila din somili ay kinadiyos Yahweh ay binmaba sin toktok di dontog. Din nangilan di Israelita yan kaman apoy ay manbidbidang sin toktok di dontog. Enem ay agew ay nililikob di liboo din dontog. Pag sin maikapito ay agew dinngen Moses din kalin Diyos sin kad-an di liboo ay mangay-ayag en sisya. ");
INSERT INTO kne_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Et nantikid si Moses sin dontog enggana ay nalingban sin liboo yan nantee isdi si opatapolo ay agew ya labi. ");
INSERT INTO kne_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Idi domateng si Moses, kanan Diyos en sisya, ");
INSERT INTO kne_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ibagam sin Israelita ta man-idawat da si daton ay para en sak-en yan awatem mo sino di layden da ay idawat. ");
INSERT INTO kne_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ibagam abe ta man-amag das tolda ay makiteteeak en dakayo ");
INSERT INTO kne_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","yan onodan da din amin ay inbilin ko ay iyat na ay maamag, pati din kaamagan di am-in ay maosal isdi. ");
INSERT INTO kne_vpl VALUES ("EX25_10a","003_25_10a","EXO","25","10a","10a","Man-amag kayo abe si baol ay kaiw ay acacia di amag na. ");
INSERT INTO kne_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Man-amag kayo si kaleb na ay natanig ay balitok ay 45 ay polgada di kaando na ya 27 ay polgada di kaannawa na. ");
INSERT INTO kne_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Man-a kayo si napitpit ay balitok ta man-amag kayo si dowa ay sinan kerubim ");
INSERT INTO kne_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","sin dowa ay soni, ngem masapol ay maikanayon sin kaleb. ");
INSERT INTO kne_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Din iyat yo et pomipika da ay mansasagong sin dowa ay sonin di kaleb yan nandedepa din payak da ay mamapayong sin baol. ");
INSERT INTO kne_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ikosnong yo sin baol din dowa ay nadampilak ay bato ay naisolatan di bilin Diyos asi yon ikaleb. ");
INSERT INTO kne_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Isdi ay makikaliak en sik-a et dengngem din kalik sin ngaton di kerubim ta ibagak amin din bilbilin ko ta itdom sin Israelita. ");
INSERT INTO kne_vpl VALUES ("EX25_23a","003_25_23a","EXO","25","23a","23a","Man-a kayos acacia ta amagen yo si lamisaan. ");
INSERT INTO kne_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Masapol ay maipapatang din tinapay ay maidaton en sak-en sin lamisaan ay nay ta say wada sin sangoanak si kankanayon. ");
INSERT INTO kne_vpl VALUES ("EX25_31a","003_25_31a","EXO","25","31a","31a","Man-amag kayo abe si patangan di silaw ay balitok. ");
INSERT INTO kne_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Asi kayo man-amag si pito ay silaw ay ipeey yo sin sakpaan di silaw isnan patangan, yan iamag yo ta masilawan din sango. ");
INSERT INTO kne_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ilaem ta dadlon yon onodan din plano ay naipailan sik-a sin dontog.” ");
INSERT INTO kne_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ayagam si agim ay Aaron ya din an-ak na ay da Nadab, Abihu, Eleazar ya si Itamar. Ikasin mos daida sin odom ay Israelita ta daida di papadi ay mansilbi en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Iamagam si Aaron si bado ay maibagay sin kinabanol ya kinangaton di saad na ay padi. ");
INSERT INTO kne_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ayagam amin din inyaak si laing ay mandait ta mandait das badon Aaron ay say mapili ay padi ay mansilbi en sak-en. ");
INSERT INTO kne_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ibagam ta amagen da nan odom ay tapin di osal Aaron: din maitak-ep sin pagewan, din naabel ay sinadlay ay kanan da en efod, nagayad ay bado, din naabel ay osalen ay maidallem, apongot ya din balikes. ");
INSERT INTO kne_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Man-a ka si dowa ay nabanol ay bato ay din kanan da en karnelia ta ikitikit mo din ngadan di sinpo ya dowa ay lallalaki ay an-ak Israel. ");
INSERT INTO kne_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Sag-eenem ay ngadan di maisolat si esa ay bato yan ilaem ta maiolnos din iyat da ay maisolat ay manlogi sin pangpangoan enggana sin anongos. ");
INSERT INTO kne_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Iamag mo dana sin sadlayan di efod ta say mangialagey sin sinpo ya dowa ay tribun di Israelita. ");
INSERT INTO kne_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Man-amag kas osalen din kangatoan ay padi sin pagew na ta say pangammoana sin layden Diyos. Kaman met laeng din naosal si efod di maiamag isna ya siya abe sin borda na. ");
INSERT INTO kne_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Masapol ay sagsisiyam ay polgada di kaannawa ya kaando na mo maikolpi sin gawa na. ");
INSERT INTO kne_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Iamag mo di opat ay linya ay nankababanol ay bato. Ipeey mo sin damo ay linya di rubi, topasio ya garnet. ");
INSERT INTO kne_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Sin maikadwa, sag-eesa ay bato ay esmeralda, safiro ya diamante. ");
INSERT INTO kne_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Sin maikatlo, sag-eesa ay bato ay hasinto, agate ya amatista, ");
INSERT INTO kne_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","yan sin maikap-at, sag-eesa ay bato ay berilio, karnelia ya jaspe. Masapol ay balitok di kaikapetan din batbato ay nay. ");
INSERT INTO kne_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Sag-eesa ay maitiktik din ngadngadan di an-ak Israel sin sinpo ya dowa ay nay ay bato ta say mangialagey sin amin ay tribun di Israel. ");
INSERT INTO kne_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Mo senggep si Aaron sin Nasantoan ay Kowarto, osalena san naikitikitan di ngadngadan di tribun di Israelita ta say nemnemnemek din ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ipeey mo sin tak-ep di pagewan din makwani en Urim ya Tummim tan say pangammoana sin laydek ay amagen di Israelita, isonga masapol ay osalenas kanayon mo senggep sin Nasantoan ay Kowarto.” ");
INSERT INTO kne_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kanan aben Diyos en Moses, “Man-amag ka si bronsi ay palanggana ya bronsi met laeng ay patangana. ");
INSERT INTO kne_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Ipeey mo sin nan-gawaan di Tolda ya altar yan pey-am si danom. ");
INSERT INTO kne_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Say pan-owasan da Aaron ya din an-ak na sin takkay ya siki da ");
INSERT INTO kne_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","ta asi dan senggep sin Tolda ono somag-en sin altar ta pooan day idaton da en Diyos. Masapol ay owasan da din takkay ya siki da ta adi dan matey. Masapol ay onodan da na si eng-enggana ya siya abe sin poli da.” ");
INSERT INTO kne_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Idi nakdeng ay nakikali si Diyos en Moses sin dontog ay Sinai, indawat na en sisya din dowa ay nadampilak ay bato ay naisolatan di bilbilina. Si Diyos ay mismo di nangisolat. ");
INSERT INTO kne_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Idi sed-esed-en din ipogaw si Moses yan mabayag ay mantaoli, inalibongbongan da si Aaron yan kanan da, “Man-amag ka et si didiyos ay mangipango en datako, tan adi mi ammo mo sinoy naamag en Moses ay sana ay nangipango en datako ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Songbatan pay Aaron yan kanana, “Iali yo ngarud din aritos di asawa ya an-ak yo.” ");
INSERT INTO kne_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Et kinaan da tet-ewa din balitok ay aritos da yan indawat da en Aaron. ");
INSERT INTO kne_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tinenaw Aaron din aritos da, pag nan sokogen ya ilinis ay amagen si sinan olbon ay baka. Idi siya et di, kanan din ipogaw, “Sinay di diyos tako ay Israelita ay nangipango en datako ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Makdeng pay di, nan-amag si Aaron si altar sin sangoanan di balitok ay sinan baka yan kanana, “Mo si bigat, manfiesta tako ta mandayaw tako en Diyos.” ");
INSERT INTO kne_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Sin kabigatana, nan-idateng da si aanimal ay idaton da. Pinooan da ay indaton din odom yan pinalti da ay para sin pan-ookoban da ay isida din odom. Nanpennek da ay nangan ya nan-iinom enggana ay nabetebeteng da et dowan dan nansasala ya nandadaag, olay baken dan sin-asawa. ");
INSERT INTO kne_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Idi siya di, kanan Diyos en Moses, “Dalasem ay manballalong, tan doy ay nanbasol ya dinokogan das sak-en din ipogaw ay inpangom ay kinmaan ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nasangaw da ay dagos sin danan ay inbagak ay pandanan da. Doy et ay nan-amag da si sinan olbon ay baka ay balitok ay say daydayawen da ya pan-idatonan da dowan da et kanan en say diyos ay nangipango en daida ay komaan ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ammok ay adi kayamyaman dadis ipogaw, ");
INSERT INTO kne_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","isonga adi ka makibiyang en sak-en ta peslek daida, tan nay palaloy bonget ko en daida, ta sik-a ya din polim di paad-adoek ta manbalin kayos madayaw ay nasyon.” ");
INSERT INTO kne_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ngem nanpakpakaasi si Moses en Yahweh ay Diyos na et kanana, “Pangaasim kod, Apo, ta adi kan palalo ay mabonget sin ipogaw mo ay inpangom ay komaan ed Egipto begew sin nakaskasdaaw ay panakabalin mo. ");
INSERT INTO kne_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Adi pay kanan et din taga-Egipto en planom baw ay ipango din ipogaw mo ta peslem amin daida isnan kadondontogan ta iwed polos di mabay-an. Pangaasim koma ta ibabawim san bonget mo ta adi kan pespeslen daida. ");
INSERT INTO kne_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nemnemem koma din insapatam sin baam ay da Abraham en Isaac ya si Jacob en paad-adoem din poli da ay kaman din kaad-adon di talaw ed daya ya din inkarim en idawtam daida si daga ay oka das eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Idi siya et di, inbabawin Diyos din inbaga na en panosaana sin ipogaw na. ");
INSERT INTO kne_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Inan Moses din doway nadampilak ay bato ay nasolatan din nanbinas-il sin bilbilin Diyos et nanballalong ay mantaoli sin kad-an di gagait na. ");
INSERT INTO kne_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Si Diyos ay mismo di nangamag sin nadampilak ay bato ya nangikitikit sin bilbilina. ");
INSERT INTO kne_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Dinngen Josue din ngalawngaw di ipogaw, isonga kananan Moses, “Manngalawngaw da sin kampo ay kaman way man-gogobat.” ");
INSERT INTO kne_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ngem kanan Moses, “Baken met bogaw di nangabak ono adawag di naabak san madnge mo adi et kaman dan mankankanta.” ");
INSERT INTO kne_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Idi dandani ay domateng da et sin kampo da, inilan Moses din sinan baka ya din ipogaw ay mansasala, isonga palaloy bonget na, pag na et ipigpig sin poon di dontog din nadampilak ay bato ay iin-genana. ");
INSERT INTO kne_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Tinenaw na din sinan baka, asi nan gilingen enggana ay napino ay kaman dap-o, pag nan ilaok sin danom, asi na inpainom sin Israelita. ");
INSERT INTO kne_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Makdeng pay di, kanan Moses en Aaron, “Intoy inyat aya da nan ipogaw en sik-a et nay pinalobosam daida ay mangamag isnan palalo ay madagsen ay basol?” ");
INSERT INTO kne_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Kanan Aaron ay nanongbat, “Apo, adi ka koman omibonget, tan ammom met dedan ay panam-ayen da ay man-amag si lawa. ");
INSERT INTO kne_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tan kanan da, ‘Man-amag ka kod si didiyos ay mangipango en datako, tan adi mi ammo mo sinoy naamag en Moses ay doy ay nangipango en datako sin kinmaanan tako ed Egipto.’ ");
INSERT INTO kne_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Et kindaw ko din balitok ay aritos da, yan idi intep-ak sin apoy, pag et maamag si sinan baka.” ");
INSERT INTO kne_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Inammoan Moses ay pinalobosan Aaron din ipogaw ay mangamag si nalabes ya kaibabainan da sin kaibaw da. ");
INSERT INTO kne_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Pinmika sin segpan di kampo, pag nan kanan ay nangibogaw, “Omalis na amin din laydena ay mangonod en Diyos.” Et natopog amin din Levita sin kad-ana. ");
INSERT INTO kne_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kanana en daida, “Inbilin Yahweh ay Diyos di Israelita ay alaen yo din kampilan yo ta sokisoken yo nan kampo, manipod sin segpan ay nay enggana sin esay segpan sin gedeng di kampo, ta peslen yo din aag-i, gagayyem ya katokmang yo.” ");
INSERT INTO kne_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tinongpal din Levita di, et pinse da di emey ay tolo ay libo ay lallalaki sin agew ay doy. ");
INSERT INTO kne_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Pag kanan Moses sin Levita, “Ed wani ay agew, indaton yo di awak yo ay mansilbi en Diyos gapo ta tinongpal yo din laydena et pinse yo din nanbasol, olay pay mo anak yo ya agi yo, isonga bindisyonan Diyos dakayo.” ");
INSERT INTO kne_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Sin kabigatana, kanan Moses sin ipogaw, “Madagsen di basol yo, ngem mantikidak ed wani sin dontog ta enak kod makikali en Diyos bareng mo pakawanena si dakayo.” ");
INSERT INTO kne_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Et kasin inmey si Moses sin kad-an Diyos yan kanana, “Madagsen kayman san inamag din ipogaw, tan nan-amag das balitok ay didiyosen et say dinaydayaw da, ");
INSERT INTO kne_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ngem pangaasim kod ta pakawanem daida. Ngem mo adi mabalin, olay kaanem din ngadan ko sin libro ay nangisolatam si ngadngadan di ipogaw mo.” ");
INSERT INTO kne_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ngem kanan Diyos en Moses, “Din nakabasol en sak-en et anggoy di kaanek di ngadan da sin librok. ");
INSERT INTO kne_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Emey ka et ta ipangom daida sin lugar ay inbagak en sik-a. Nemnemnemem ay wada din anghel ko ay mangipango en sik-a. Ngem domteng to di agew ay dosaek da san ipogaw gapo sin basol da.” ");
INSERT INTO kne_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Adi nabayag et inpawadan Diyos di sakit ay nangidateng si pisti sin ipogaw gapo sin nangipaamagan da en Aaron si sinan baka ay balitok. ");
INSERT INTO kne_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kasin nakingalat si Diyos en Moses yan kanana, “Taynan yo nan lugar ay nay, dakayo ya din ipogaw ay inpangom manipod ed Egipto, ta emey kayo sin ili ay inkarik en da Abraham en Isaac ya si Jacob ay idawat ko sin poli da. ");
INSERT INTO kne_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Man-ibaaak si anghel ay mangipango en dakayo et pakaanek to din Canaaneo, Amorreo, Heteo, Perezeo, Heveo, ya Jebuseo. ");
INSERT INTO kne_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Emey kayo sin sana ay daga ay nabaknang ya magabay di mola, ngem adiak makikoyog en dakayo tan makenteg di nemnem yo ay ipogaw, tan into et mo peslek amin dakayo sin danan.” ");
INSERT INTO kne_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Idi dinngen din ipogaw san kaeegyat ay damag, palalo di ladingit da et insaldeng da ay mangosal sin nankababanol ay osal da, ");
INSERT INTO kne_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","tan binilin Diyos si Moses ay mangibaga en daida, “Natangken di nemnem yo ay ipogaw, isonga mo makikoyogak si olay sinkaattikan en dakayo, amangan mo peslek dakayo amin. Ed wani, kaanen yo din nankababanol ay osal yo ta nemnemek mo into di iyat ko en dakayo.” ");
INSERT INTO kne_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Siya di din gapo ay adi inos-osal din Israelita din nabanol ay osal da manipod sin kinmaanan da sin dontog ay Sinai. ");
INSERT INTO kne_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Din kanayon ay am-amagen Moses mo domateng da si esay lugar ay pankampoan da et alaena din Tolda ay para en Diyos et isaad na sin ad-addawi sin lasin di kampo da. Nginadanana si Tolda ay Panpappailaan Diyos, et isdi di emeyan di ipogaw mo way layden da ay damagen en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mo senggep si Moses sin Tolda ay sana, mantee di esa ya esa sin segpan di mismo ay kampo na ay mamoboya enggana ay senggep. ");
INSERT INTO kne_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mo nakasgep si Moses, bomaba ay dagos din liboo ay natotood sin segpan di Tolda et kaman mapmapo sin kad-an di liboo ay sana din kalin Diyos ay makikali en Moses. ");
INSERT INTO kne_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Isonga mo ilaen din ipogaw ay wada din liboo ay matood sin segpan di Tolda, manyakog-ong da. ");
INSERT INTO kne_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mismo ay si Diyos di makingalat en Moses ay ropan ropa ay kaman din iyat di ipogaw ay makikali si gayyem na. Mo makdeng di ngalat da, mantaoli si Moses sin kampo. Ngem mataynan sin Tolda din baro ay kabadang na ay si Josue ay anak Nun. ");
INSERT INTO kne_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kanan Moses en Diyos, “Tet-ewa kayman ay pinilim sak-en ay mangipango en da nay ay ipogaw, ngem adi ka met inbaga mo sino di ibaam ay komoyog. Kanam abe en dadlon kan am-ammo ya malaydan ka en sak-en ");
INSERT INTO kne_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","isonga mo tet-ewa na, ibagam koma ngarud din planom ta say ammoak di iyat ko ay mansilbi en sik-a ya masepsep ay malaydan ka. Nemnemnemem koma ay pinilim dana ay ipogaw ay inbilang mo ay ipogaw mo.” ");
INSERT INTO kne_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Kanan Diyos ay nanongbat, “May ngarud, koyogek ya badangak dakayo ta way iyat yo ay mangabak sin kaibaw yo ya asi kayo man-illeng sin ili ay emeyan yo.” ");
INSERT INTO kne_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kanan kasin Moses, “Mo adi kan komoyog, adi ka koman pakaanen dakami isnan lugar ay nay. ");
INSERT INTO kne_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Into ngin di pangilasinan di odom ay ipogaw en malaylaydan kan sak-en ya din ipogaw mo ay nay mo adi kan komoyog? Mo koyogem dakami, say pangammoan da ay naitken kami sin odom ay ipogaw isnan lobong.” ");
INSERT INTO kne_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Kanan Diyos en Moses, “Gapo ta dadlonak am-ammos sik-a ya malaylaydanak en sik-a, matongpal san kedkedawem.” ");
INSERT INTO kne_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Nanpakaasi kasin si Moses yan kanana, “Pangaasim kod ta ipalobos mo ay ilaek di kinadiyos mo.” ");
INSERT INTO kne_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Songbatan pay Diyos yan kanana, “Ipailak din amin ay kinasiged ko en sik-a ya ibagak abe en sik-a din ngadan ko ay Yahweh, tan ipailak din seg-ang ko sin laydek ay pangipailaan. ");
INSERT INTO kne_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ngem adi mabalin ay ilaem din ropak, tan binmal-o ay matey di ipogaw ay mangila sin ropak, ");
INSERT INTO kne_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ngem pomika ka sin bato ay nay sin kad-ak. ");
INSERT INTO kne_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta mo ilabas ko din mankoniniing ay kinadiyos ko, ilingeb kos sik-a sin nanbaetan di napitak ay bato, asiak isalin din takkay ko sin matam enggana ay malabasak. ");
INSERT INTO kne_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mo malabasak, asiak kaanen din takkay ko ta say ilaem din edeg ko ay baken din ropak.” ");
INSERT INTO kne_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Idi makdeng di, kanan Diyos en Moses, “Mantiktik kas dowa ay nadampilak ay bato ay kaman din indawat ko sin damo ta pangisolatak kasin sin insolat ko sin damo ay ginopak mo. ");
INSERT INTO kne_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Mansagana ka ay mantikid sin dontog ay Sinai sin agsapa si bigat ta sem-ed ka sin toktok di dontog. ");
INSERT INTO kne_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Adi ka man-itaktakin si gait mo yan masapol ay magay ipogaw si maila sin olay into ay partin di dontog. Masapol abe ay maga di karnero ono baka ay naipastol sin poon di dontog.” ");
INSERT INTO kne_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Dadlon tinongpal Moses din inbilin Diyos. Nasapa sin kabigatana et nantiktik si dowa ay nadampilak ay bato ay intikid na sin dontog ay Sinai. ");
INSERT INTO kne_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Binmaba si Diyos sin dontog ay kinoyog di liboo et pinmika sin kad-an Moses, pag nan ibaga din ngadana ay si Yahweh. ");
INSERT INTO kne_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Nalabas sin sangoanan Moses pag nan kanan, “Sak-en si Yahweh, Diyos ay managseg-ang. Bakenak nalaka ay bomonget mo adi et managlayadak ya matalekak. ");
INSERT INTO kne_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Adiak linglingan di inkarik sin niliblibo ay ipogaw et pakawanek di pankolkolangan da, din panlablabsingan da sin bilbilin ko ya odom ay basbasol da. Ngem adiak ipalobos ay mailsot di nakabasol ay ipogaw di dosa mo adi et dosaek engganas anak di apo na.” ");
INSERT INTO kne_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Dagos ay nanyakog-ong si Moses ay mandayaw en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Kanana, “Apo, mo tet-ewa ay malaydan ka en sak-en, pangaasim ngarud ta koyogem dakami. Tet-ewa kayman ay makenteg di nemnem da nan ipogaw ay nay, ngem pangaasim kod ta pakawanem din basol ya lawa ay ogali mi ta ibilang mos dakami ay ipogaw mo.” ");
INSERT INTO kne_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kanan Diyos en Moses, “Ed wani, wada di itolag ko en dakayo ay Israelita. Amagek di nakaskasdaaw sin pangiilaan yo ay adi naam-amag sin olay sino ay ili isnan daga. Et ilaen din kaipoipogaw ay makiilian yo din nakaskasdaaw ay amagek para en dakayo. ");
INSERT INTO kne_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tongpalen yo din ibilin ko en dakayo ed wani. Awni et pakaanek din Amorreo, Canaaneo, Heteo, Perezeo, Heveo ya Jebuseo mo domateng kayo sin ili da. ");
INSERT INTO kne_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Annadan yo ta adi kayon makitolag ay makikadwa sin ipogaw ay datngan yos di, tan mo say amagen yo et kaman tagdey ay mangiturong si kadadaelan yo. ");
INSERT INTO kne_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Dadaelen yo din altar da, gemken yo din tinootood da ay bato ay pandaydayawan da dowan yon potoen din posti ay pangidaydayaw da en Asera ay didiyosen da. ");
INSERT INTO kne_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Adi kayon mandaydayaw si odom ay diyos, tan sak-en ay Diyos et adiak ipalobos ay waday ikadkadwa yon sak-en ay dayawen. ");
INSERT INTO kne_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Adi kayon makitoltolag ay makikadwa sin ipogaw isdi, tan mandaydayaw da si ad-ado ay didiyosen di pagano. Tan mo man-idaton da ya awisen das dakayo ay makiragragsak, into et mo masolisog kayo ay makikan sin naidaton si didiyosen da.” ");
INSERT INTO kne_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Nakitees Moses en Diyos sin dontog si opatapolo ay agew ya labi ay adi polos nangnangan ya nan-in-inom. Isdi ay insolat na sin doway nadampilak ay bato din Sinpo ay Bilin ay siya din intolag Diyos sin Israelita. ");
INSERT INTO kne_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Idi nanballalong ay napo sin dontog ay Sinai, iin-genana din dowa ay bato ay naisolatan di bilbilin Diyos, yan adi na ammo ay mankoniniing din ropa na gapo sin nakikaliana en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Inmegyat si Aaron ya din amin ay Israelita ay somag-en idi inila da din mankoniniing ay ropan Moses. ");
INSERT INTO kne_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ngem inayagan Moses daida, isonga sinmag-en si Aaron ya din papangolon di Israelita, et nakikali si Moses en daida. ");
INSERT INTO kne_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Maaw-awni pay, sinmag-en amin ay Israelita en Moses et inbaga nan daida amin din bilbilin ay inbagan Diyos sin dontog ay Sinai. ");
INSERT INTO kne_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Idi makdeng ay ibagan Moses en daida din inbilin Diyos, nilingbana din ropa na si sokdong. ");
INSERT INTO kne_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Sin tonggal somag-enana ay makikali en Diyos yan kaanena din sokdong na. Isonga mo bemela ay mangibaga sin Israelita sin inbilin Diyos, ");
INSERT INTO kne_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ilaen da ay mankoniniing din ropa na. Mo makdeng yan lingbana din ropa na enggana ay makikali kasin en Diyos. ");
INSERT INTO kne_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Tinongpal din Israelita amin din obla ay inbilin Diyos en Moses ay amagen da. ");
INSERT INTO kne_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Idi en pinaneknekan Moses mo kosto din inyat da, et siya ay tinongpal da din inbilin Diyos, isonga binindisyonanas daida. ");
INSERT INTO kne_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Naisaad din Tolda ay Panpappailaan Diyos sin pitsa 1 di damo ay bowan sin maikadwa ay tawen manipod sin kinmaanan da ed Egipto. ");
INSERT INTO kne_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Idi insaad Moses din Tolda, tinood na din posti et pag nan ikapet din bagbag ya din odom ay manbabag ay amag na. In-amag na din kaosod ya lagat, ");
INSERT INTO kne_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","et pag nan iakbong din Tolda ay lalat di animal ay say maiatep ya maibobong. Tinongpal na amin din inbilin Diyos ay iyat na ay mangiamag sin Tolda. ");
INSERT INTO kne_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Inkosnong na sin Baol din dowa ay bato ay naisolatan di sinpo ay bilin, pag nan iamag din kaiw ay pangiegnan. Makdeng pay di, in-amag na din kaleb di Baol. ");
INSERT INTO kne_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Inpasgep na din Baol sin Tolda, pag nan iamag din kurtina ay manasalin sin kowarto ay kad-an di Baol, tan say inbilin Diyos. ");
INSERT INTO kne_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Inpasgep na abe din lamisaan sin Tolda et inpeey na sin naibanda si amyanan sin lasin di kurtina. ");
INSERT INTO kne_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Inpatang na sin lamisaan ay sana din tinapay ay maidaton en Diyos, tan siya din inbilina. ");
INSERT INTO kne_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Inpasgep na din patangan di silaw sin Tolda sin naibandas abagatan, sin sagang di lamisaan, ");
INSERT INTO kne_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","et pag nan iamag din silaw sin sangoanan Diyos ay kaman met laeng din inbilin Diyos en sisya. ");
INSERT INTO kne_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","In-amag Moses din balitok ay altar sin Tolda sin sangoanan di kurtina ");
INSERT INTO kne_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","et nan-ipoo si nabanglo ay insinso, tan say inbilin Diyos. ");
INSERT INTO kne_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","In-amag na abe di kurtina sin segpan di Tolda, ");
INSERT INTO kne_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","pag man-amag sin lasin di kurtina si altar ay pan-idatonan si mapooan. Say pangipooan da si datdaton ay animal ya lames di inani da. ");
INSERT INTO kne_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Inpeey na din palanggana sin nan-gawaan di Tolda ya altar et piney-ana si danom ay pan-owasan, ");
INSERT INTO kne_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ta say pan-owasan Moses ya da Aaron sin an-ak na sin takkay ya siki da. ");
INSERT INTO kne_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Inbilin Diyos ay man-owas da mo senggep da sin Tolda ono somag-en da sin altar. ");
INSERT INTO kne_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Makdeng pay di, in-amag Moses din kurtina ay nanliked sin Tolda ya altar ay kaman say alad na, pag nan ibitin di kurtina sin segpan di alad ay sana et say nakdengan din obla ay kaisaadan di Tolda. ");
INSERT INTO kne_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Idi makdeng di, nilikmot din liboo din Tolda et napno sin somili ay kinadiyos en Yahweh, ");
INSERT INTO kne_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","isonga adi nakasgep si Moses. ");
INSERT INTO kne_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Sin am-in ay nan-etaetanan di Israelita, nantetee da si esa ay lugar enggana ay komayang din liboo sin Tolda. Mo komayang, asi da manlobwat ay man-etan. ");
INSERT INTO kne_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Sin kaagawan, maila da din liboo ay kaipailaan di kawadan Diyos sin ngaton di Tolda. Sin labi pay, maila da di apoy sin kad-an di liboo. Nailan di Israelita din liboo ya apoy ay sana sin am-in ay nandad-anan da. ");
INSERT INTO kne_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Inayagan Diyos si Moses sin Tolda ay Panpappailaana et nakikali en sisya. ");
INSERT INTO kne_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Binilina ta ibaga na dana sin Israelita: Mo waday man-idawat si daton, masapol ay baka, karnero ono kalding. ");
INSERT INTO kne_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Mo maipanggep si daton ay mapooan, da naey di maonodan. Mo baka di idaton da, masapol ay mapteng ay bomaro ay magay kaoyawana. Iey na sin segpan di Tolda ta awaten Diyos. ");
INSERT INTO kne_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Kapayen din ipogaw din toktok di maidaton ay mapooan et maawat din daton ay sana ta maisobot sin biyag na ya malinisan din basbasol na. ");
INSERT INTO kne_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Paltiena din baka et pag alaen din papadi ay an-ak Aaron din dada na ta idaton da en Diyos. Mo makdeng di, isoyat da din dada sin opat ay solin di altar sin segpan di Tolda. ");
INSERT INTO kne_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Lalatena din animal asi na tadtaden. ");
INSERT INTO kne_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Din papadi pay yan olnosen da din kaiw sin altar, asi dan tetengan. ");
INSERT INTO kne_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Pag dan ipatang din natadtad ay karni sin apoy, pati din toktok ya tabtaba. ");
INSERT INTO kne_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Owasan din nanpalti din eg-eges ya sikin di animal et ipoon din papadi din intiro ay animal sin altar ta say daton ay mapooan ay mansengseng-ew para en Diyos. ");
INSERT INTO kne_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Inbilin Diyos en Moses ");
INSERT INTO kne_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ay ibaga na sin Israelita ay mo wada di manbasol ay mangamag si iparit di linteg Diyos ngem adi na in-gagara, masapol ay tongpalena da nay ay bilbilin. ");
INSERT INTO kne_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Mo manbasol di kangatoan ay padi et maibilang ay nanbasol abe din kaipoipogaw, masapol ay man-a din padi ay sana si bomaro ay baka ay magay kolang na ta ena idaton en Diyos ta say malinisan din doy ay basol na. ");
INSERT INTO kne_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Iey na din baka sin pantew di Tolda ay Panpappailaan Diyos et asi na ikapay din takkay na sin toktok di baka et paltiena sin sangoanan Diyos. ");
INSERT INTO kne_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Asi man-a sin dadan di napalti et isgep na sin oneg di Tolda. ");
INSERT INTO kne_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Mo wadas sisya sin oneg, isiwsiw nan gomot na sin dada et asi na pay iwalsi si mamin pito sin sangoanan Diyos sin sangon di kurtina ay nanasalin sin Kasasantoan ay Kowarto. ");
INSERT INTO kne_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Pag nan iponas din odom ay dada sin kaman sakngod sin solin di altar ay panpoppooan si insinso ay wada met laeng sin oneg di Tolda. Mo makdeng di, isoyat na din am-in ay nabay-an ay dada sin naisaadan di altar ay panpoppooan si daton ay wada sin pantew di Tolda. ");
INSERT INTO kne_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ilasina abe din am-in ay taban di eg-eges di baka ay napalti, ");
INSERT INTO kne_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","din dowa ay batin ya din taba da pati din kamayatan ay partin di atey na ");
INSERT INTO kne_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ay kaman met laeng di iyat da ay mangaan sin taban di baka ay idaton da ay pan-ookoban ya makikadkadwaan da en Diyos, asi na pooan sin altar ay doy. ");
INSERT INTO kne_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ngem alaena din kopkop, am-in ay lames, din toktok, din eg-eges ay adi nasosotan ya din sikin di animal, ");
INSERT INTO kne_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","et iey na ay pooan si kaiw sin lasin di pankamkampoan da ay maiwaswasitan di dap-o, tan say ibilang da ay nalinis ay lugar maibasar sin linteg da. ");
INSERT INTO kne_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Kanan Diyos en da Moses en Aaron, ");
INSERT INTO kne_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Ibaga yo na sin Israelita: Sin amin ay animal, siya dana di mabalin ay kanen yo: ");
INSERT INTO kne_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Din nagisgis di kokod na ya mangaga kasin si nakdeng ay kinana. ");
INSERT INTO kne_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Ngem waday animal ay mangaga kasin si kinana ono nagisgis di kokod na ay adi yo kanen. Maiparit din kamel ya din atap ya naamo ay koneho, tan olay mo gagaen da kasin di kanen da baken nagisgis di kokod da. ");
INSERT INTO kne_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Maiparit abe din besaang, tan olay mo nagisgis din kokod na, adi na kasin gagaen di kinana et kadodogis ay kanen yo. ");
INSERT INTO kne_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Adi yo isidsida dana ya adi yo aben giwgiwiten din bangkay da. Ibilang yo ay kadodogis dana. ");
INSERT INTO kne_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Sin wadas danom, da nay di mabalin ay isida yo: din amin ay waday siksik ya balidbid na, olay wadas baybay ono ginawang. ");
INSERT INTO kne_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","12","Ngem olay sino ay wada sin danom ay magay siksik ono balidbid na, ibilang yo ay palalo ay kadodogis et adi yo isidsida ono olay giwiten din bangkay da. ");
INSERT INTO kne_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","“Sak-en si Yahweh ay nangipango en dakayo ay komaan ed Egipto ta sak-en di Diyos yo, isonga masapol ay nasantoan kayo tan nasantoanak. ");
INSERT INTO kne_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Siya sa di bilin ko maipanggep sin animal, titit, amin ay manbibiyag sin danom ya amin ay mankodkodap sin lota. ");
INSERT INTO kne_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Masapol ay mailasin yo di nalinis ya kadodogis, mo sino di mabalin ay maisida ya din maiparit sin amin ay matmatago ay parsua.” ");
INSERT INTO kne_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Inpaammon Diyos en Moses dana ay bilbilin ");
INSERT INTO kne_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","ta tongpalen din Israelita. Mo lalaki di ianak na, pito ay agew ay maibilang sisya ay kadodogis ay kaman din panriglaana. ");
INSERT INTO kne_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sin maikawao ay agew, masapol ay makogit din anak. ");
INSERT INTO kne_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Din ina, palabasena di tolonpo ya tolo pay ay agew, asi maibilang ay nalinis et makdeng di kinmadodogisana gapo sin dada ay binmalbala. Maiparit ay giwitena di olay sino ay maibilang ay nasantoan ya adi mabalin ay senggep sin nasantoan ay Tolda enggana ay makdeng din agew ay kalinisana. ");
INSERT INTO kne_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mo babai di ianak na, sinpo ya opat ay agew di kaibilangana ay kadodogis ay kaman din panriglaana. Ngem palabasena pay di enemapolo ya enem ay agew, asi maibilang ay nalinis. ");
INSERT INTO kne_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Mo mapospos din agew ay kalinisana sin nangianakana si babai ono lalaki, masapol ay man-iey si bomaro ay karnero ay mantawen si esa sin padi ay wada sin segpan di Tolda ta say maidaton ay mapooan. Man-idawat abe si anak di pagaw ono kalapati ay say maidaton ay manglinis sin basol na. ");
INSERT INTO kne_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Idaton din padi para sin babai et maibilang sisya ay nalinis et makdeng di kinmadodogisana gapo sin dada ay binmala en sisya. Siya na di maibilin sin babai ay man-anak. ");
INSERT INTO kne_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mo adi na kabaelan di bomaro ay karnero, man-idawat si dowa ay kalapati ono pagaw. Din esa yan maosal ay daton ay mapooan yan din esa et maidaton ay manglinis sin basbasol na. Amagen din padi din seremonia ay panglinis sin babai et maibilang ay nalinis sin sangoanan di linteg. ");
INSERT INTO kne_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Binilin Diyos da Moses en Aaron yan kanana, ");
INSERT INTO kne_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Mo waday maila sin kodil di esay ipogaw ay lomat-ed ono bomalanga ono bayang yan manbalin si sakit di kodil ay makaalis, masapol ay manpaila en Aaron ono esa sin papadi ay an-ak na. ");
INSERT INTO kne_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Esten din padi ay ilaen din bayang na. Mo kinmilat din book sin kad-an di bayang ya naoneg din bayang mo din kodil na, din sana yan kaeegyat ay sakit di kodil et ipaammon din padi ay maibilang sisya ay kadodogis sin sangoanan di linteg. ");
INSERT INTO kne_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Din ipogaw ay waday sakit na ay kaeegyat ay sakit di kodil, masapol ay manbado si nabisngibisngit. Adi na sagsagaysayen din book na ya kopopana din nanallem ay partin di ropa na yan ibogaw na ay kanana, ‘Kadodogisak, kadodogisak.’ ");
INSERT INTO kne_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Maibilang sisya ay kadodogis enggana ay makaan din sakit di kodil na et mantee sin lasin di kampo ay addawi sin ipogaw.” ");
INSERT INTO kne_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Inbagan Diyos en Moses ");
INSERT INTO kne_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","da nan bilbilin maipanggep sin seremonia ay amagen di ipogaw ay nakaan di kaeegyat ay sakit di kodil na. Sin agew ay maibilang sisya ay nalinisan sin sakit di kodil ay sana, koyogen das sisya ay emey sin padi. ");
INSERT INTO kne_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Bomala din padi et ena ilaen sisya sin lasin di kampo. Mo nakaan din sakit na, ");
INSERT INTO kne_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ibilin din padi ay man-ialis sisya si dowa ay titit ay maibilang ay nalinis, kaiw ay sidro, manbalanga ay lopot ya pingin di hisopo. ");
INSERT INTO kne_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ibilin din padi ay mapalti din esa ay titit yan sayangen da din dada na si dinamili ay banga ay napey-an si kasaksakdo ay danom di obbog. ");
INSERT INTO kne_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Makdeng di, alaena din esa ay titit, sidro, manbalanga ay lopot ya hisopo ay isiwsiw na sin dadan di napalti ay titit. ");
INSERT INTO kne_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Mamin pito ay walsiana sin dada din ipogaw ay malinlinisan sin sakit di kodil na, pag nan ipaammo en maibilang ay nalinis din ipogaw ay sana. Ibolos pay din padi din matmatago ay titit. ");
INSERT INTO kne_vpl VALUES ("LV14_8a","004_14_8a","LEV","14","8a","8a","Makdeng di, din ipogaw ay sana ay maibilang ay nalinis yan masapol ay labaana din bado na, koskosana amin din book na ya man-ames, et pag maibilang sisya ay nalinis. ");
INSERT INTO kne_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Idi nakdeng din nateyan di dowa ay anak en Aaron begew sin indaton da en Diyos ay baken nasantoan, nginalat Diyos si Moses ");
INSERT INTO kne_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","yan kanana, “Ibilin mo en agim ay Aaron ay baken kompormi mo adi et anggoy sin kostokosto ay timpo di senggepana sin Kasasantoan ay Kowarto ay wada sin likod di kurtina. Tan isdi san panpappailaak babaen si liboo sin ngaton di kaleb di Baol di Tolagan. Et mo adi na tongpalen din bilin ay nay, matey sisya ay magay dowadowa. ");
INSERT INTO kne_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","5","Da naey di masapol ay amagen Aaron ta asi senggep sin Kasasantoan ay Kowarto. Masapol ay manbado sin mankilat ay bado ay natodingan para sin agew ay nay ay siya da din nagayad ay bado, potot, bilko ya apongot. Ngem siyat man-ames ta asi na ibado, tan nasantoan da nay ay bado. Asi man-a si bomaro ay baka ay maidaton ta malinisan di basol. Man-a abe si bomaro ay karnero ay mapooan ay maidaton. Awatena pay sin Israelita di dowa ay bomaro ay kalding ay maidaton ta malinisan di basol ya bomaro ay karnero ay mapooan ay maidaton. ");
INSERT INTO kne_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Mo kedngen Aaron ay idaton din baka ta maisobot sin biyag na ya malinisan din basol na ya siya abe din pamilya na, ");
INSERT INTO kne_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","masapol ay man-a si sinkapalanggana ay man-ganggangab ay oling ay napo sin altar, asi aben man-as dowa ay gamet ay napino ay insinso et isgep na sin Kasasantoan ay Kowarto. ");
INSERT INTO kne_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Isdi sin sangoanan Diyos, ipeey na din insinso sin man-ganggangab ay oling ta salinan din asok na din kaleb di Baol di Tolagan et adi na maila ta say adi matey sisya. ");
INSERT INTO kne_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Asi en omas sisya sin dadan di baka et isiwsiw na din gomot na et walsiana din kagodwan di kaleb ay wada sin patag na ya siya abe ay walsiana din sangoanan di Baol si mamin pito. ");
INSERT INTO kne_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Et mo pay ta makdemakdeng di, paltiena abe din kalding ay maidaton ta malinisan din basbasol di kaipoipogaw. Alaena din dadan di animal ay doy et iey na abe sin Kasasantoan ay Kowarto. Et say onodana met laeng din inyat na ay nangiwalsi sin dadan di baka sin kaleb ya sangoanan di Baol. ");
INSERT INTO kne_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Siya na ngarud di amagen Aaron ta say malinisan din Kasasantoan ay Kowarto ay kinmadodogis begew sin basbasol ya nankolkolangan din Israelita. Kaman nina abe di masapol ay amagena sin Nasantoan ay Kowarto, tan wada sin gawan di pankamkampoan yo ay maibilang ay kadodogis. ");
INSERT INTO kne_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Manlogi sin senggepan Aaron sin Kasasantoan ay Kowarto ay mangamag sin seremonia ay manglinis si kadodogis, maiparit ay wada di odom ay ipogaw sin Nasantoan ay Kowarto enggana ay bemelas sisya. Et mo makdeng ay amagena din seremonia ay nay para sin mismo ay awak na, pamilya na ya sin ipogaw, ");
INSERT INTO kne_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","emey sin altar ay panpoppooan si daton et amagena abe di seremonia ay manglinis abe sin altar. Say amagena ngarud et oma sin dadan di napalti ay baka ya kalding et iponas na sin am-in ay kaman sakngod di altar. ");
INSERT INTO kne_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Isiwsiw na abe din gomot na sin dada et walsiana din altar si mamin pito. Siya sa di amagena ta linisana din altar ay kinmadodogis begew sin basol di ipogaw ta say panbalinena ay nasantoan.” ");
INSERT INTO kne_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Mo pay ta ikdeikdeng Aaron din seremonia ay manglinis sin Kasasantoan ay Kowarto, din Nasantoan ay Kowarto ya din altar, iey na din matmatago ay kalding sin kad-an di altar ay panpoppooan si daton. ");
INSERT INTO kne_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","22","Asi na ikapay din dowa ay takkay na sin toktok di kalding dowanan ipodno din am-in ay nankolkolangan ya nanbasbasolan di Israelita ta mait-an sin animal ay doy. Makdeng pay di yan waday nadotokan ay ipogaw ay en mangibolos sin kalding sin addawi ay lugar ay magay omili ta say iey din kalding din am-in ay basbasol di Israelita isdi. ");
INSERT INTO kne_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Asi pag senggep si Aaron sin Tolda et kaanena am-in din bado ay inosal na ay sinenggep sin Kasasantoan ay Kowarto ta taynanas di. ");
INSERT INTO kne_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Asi en man-ames sin esa ay nasantoan ay lugar et ibado na kasin din sigod ay osal na si kinapadi. Siya di yan bemela ay mangidaton si mapooan ta maisobot sin biyag na ya malinisan din basol na ya siya abe din am-in ay Israelita. ");
INSERT INTO kne_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Da nay di bilbilin ay masapol ay matongpal si eng-enggana. Sin maikasinpo ay agew di maikapito ay bowan, din Israelita ya mangili ay makitee en daida yan masapol ay itpe da din dagaang da ya adi da man-obla. ");
INSERT INTO kne_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Tan sin agew ay doy, maamag di seremonia ay panglinis en daida ta maisobot sin biyag da ya malinisan din basol da sin sangoanan Diyos. ");
INSERT INTO kne_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Maibilang ay nasantoan din agew ay sana et masapol ay itpe da din dagaang da ya adi da polos man-obla. Masapol ay tongpalen da dana ay bilin si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kinalin Diyos si Moses et kanana, ");
INSERT INTO kne_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Ibagam en Aaron ya sin an-ak na ya sin am-in ay Israelita, ‘Naey di inbilin Diyos: ");
INSERT INTO kne_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Olay sino ay Israelita ay man-idaton si baka, karnero ono kalding si kompormi ay lugar et bomasol tan maibilang ay pinomse, isonga makeddengan ay maipowira sin iib-a na ay ipogaw en Diyos. Din amagena koma et iey na din animal sin segpan di Tolda ay Panpappailaan Diyos ta maidaton en sisya. ");
INSERT INTO kne_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Siya ngarud na san maibilin ta say manlogi ed wani, din aanimal ay idatdaton di Israelita sin lasin di pankamkampoan da et maiey sin padi sin segpan di Tolda ta say maidaton en Diyos ay say makikadkadwaan da en sisya. ");
INSERT INTO kne_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Asi en walsian di padi si dada din altar en Diyos ay wada sin segpan di Tolda, asi na aben pooan din taba ta mansengseng-ew ay say panlaydan en Diyos. ");
INSERT INTO kne_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Masapol ay isaldeng da ay idatdatonan din sinsinan kalding sin lasin di pankamkampoan da, tan din panaydayawan da sin sinan didiyos ay nay et kaman dan makikamkamalala. Din bilin ay nay et masapol ay tongpalen da ya siya abe sin poli da si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘Mo sino en dakayo ay Israelita ono mangili ay makitetee en dakayo di mangisida si dada, dokogan Diyos sisya et ipowira na sin ipogaw na. ");
INSERT INTO kne_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Tan din dada di mangidawat si biyag di awak. Din dada abe di inbilin Diyos ay maiwalsi sin altar ay manglinis sin basbasol yo, tan din dada et say pansobot si biyag. ");
INSERT INTO kne_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Siya na di begew ay inbilin Diyos sin am-in ay Israelita ay adi da mansida si dada ya siya abe din mangili ay makitetee en daida.’” ");
INSERT INTO kne_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Ibagam sin am-in ay Israelita, ‘Naey di kanan Diyos: Sak-en si Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Adi yo on-onodan din ogalin di taga-Egipto ay nakitetean yo ed idi ono din ogalin di ipogaw ed Canaan ay say pangipangoak en dakayo, ");
INSERT INTO kne_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","mo adi et tongpalen yo din linlinteg ko ya din am-in ay ibilin ko en dakayo. Et mo say amagen yo di, gon-oden yo di tet-ewa ay biyag. Nay kasinak ibaga ay si sak-en si Yahweh ay Diyos yo.’” ");
INSERT INTO kne_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Ibagam sin am-in ay Israelita, ‘Naey di inbilin Diyos: Masapol ay nasantoan kayo, tan sak-en si Yahweh ay Diyos yo et nasantoanak. ");
INSERT INTO kne_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘Mo man-ani kayo sin payew yo, adi yon palaloan ay anien din wadas benget na ya sageyen din nilabsan yo. ");
INSERT INTO kne_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mo manbolas kayo abe si obas, adi yon taolien di nilabsan yo ya piditen di nag-as. Bay-an yo abe iman ta waday okan di nabiteg ya mangili. Sak-en si Yahweh ay Diyos yo, et siya say kanak. ");
INSERT INTO kne_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘Siya abe ay masapol ay adi yon ak-akewan, sosowitiken ono iet-etekan di ib-a yo. ");
INSERT INTO kne_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Adi yo aben os-osalen din ngadan ko ay mantistigo si baken kosto ta adi maibabain di ngadan ko, tan sak-en si Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘Mo wada abe di poldiyaen yo, adi yo taktaken ay mangidawat si lagbo da olay pay mo sinlabi, tan mo taktaken yo et kaman yo met laeng sinowitik ono inakewan si daida. ");
INSERT INTO kne_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Adi yo aben babbaosan di naomel ono sapatien di nagodab, mo adi et patgen ya egyatan yo si sak-en ay Diyos yo, tan sak-en si Yahweh. ");
INSERT INTO kne_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘Mo wada di kasoen yo, din kosto koma di iyat yo ay mangowis. Adi yon pabpaboran di nabiteg yan adi yo aben palaloan ay patgen di baknang. ");
INSERT INTO kne_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Mo mantistigo kayo, adi yo aben palawlawaen di ib-a yo ono amagen di olay sino ay baken kosto ay maiturong sin makeddengan da ay matey. Sak-en si Diyos ay nangibagas na. ");
INSERT INTO kne_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘Mo wada di pansaksakitan di nemnem yo si ib-a yo, adi yo ililiget, mo adi et mankakapya kayo ta say adi kayo manbasbasol begew en daida. ");
INSERT INTO kne_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Adi yo aben ibabbaes di lawa si ib-a yo ono ililiget si daida, mo adi et laylayden yo di ib-a yo ay kaman din pananglayad yo sin awak yo. Sak-en si Diyos et siya say kanak en dakayo. ");
INSERT INTO kne_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘Adi kayo manpasip-ok ono manpatolong si man-gengey, tan komadodogis kayo begew met laeng en daida. Say patien yo din nay inbagak, tan sak-en si Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘Mo pay abe din nankakay ya nankababkes, patgen ya dayawen yos daida. Patgen yo ay sipapakombaba si sak-en ay Diyos yo, tan sak-en si Yahweh. ");
INSERT INTO kne_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘Adi yo palpaligaten din mangili ay makiili en dakayo. ");
INSERT INTO kne_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Di iyat yo pay et ibilang yo ay kaman dedan ib-a yo ay Israelita. Laylayden yo si daida ay kaman din pananglayad yo sin awak yo. Nemnemen yo koma ay mangili kayo abe ed Egipto ed idi. Sak-en si Yahweh ay Diyos yo ay nangibilin sina. ");
INSERT INTO kne_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“‘Adi yo sowitiken di ib-a yo si baken kosto ay panlokod, kiloan ono salopan, ");
INSERT INTO kne_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","mo adi et din kosto di osalen yo. Tan si sak-en si Yahweh ay Diyos yo ay nangibela en dakayo ed Egipto. ");
INSERT INTO kne_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kasinak kanan en sak-en si Yahweh ay Diyos yo. Tongpalen yo am-in ay linteg ya bilin ko.’” ");
INSERT INTO kne_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Kanan Diyos, “Mo waday ipogaw ay manpasip-ok, dokogak sisya et ipowirak sin amin ay ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kanayon koma ay onodan yo di nasantoan ay kabibiyag, tan sak-en si Yahweh ay Diyos yo.” ");
INSERT INTO kne_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ibagam sin am-in ay Israelita, ‘Naey da di tinodingan Diyos ay fiesta ay say masinopan ya pandaydayawan yo en sisya.’” ");
INSERT INTO kne_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘Mabalin ay man-obla kayo si enem ay agew, ngem nemnemnemen yo ay sin maikapito ay agew, maga di man-obla, tan din agew ay nay et naitoding para en Diyos. Isonga olay mo into di kad-an yo, siya na di agew ay pan-ibbayan yo ya say masinopan yo ay mandayaw en Diyos.’” ");
INSERT INTO kne_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘Naey da din nasantoan ay fiesta ay inbilin Diyos, et say masinopan yo ay mandayaw en sisya sin kostokosto ay agew ay tinodingana. ");
INSERT INTO kne_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Din fiesta ay makwani en Nalabas et manlogi sin kadiposan di agew sin pitsa 14 sin damo ay bowan, ");
INSERT INTO kne_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","et mo pay ta sin pitsa 15 et siya abe di panlogian di fiesta ay makwani en Tinapay ay Magay Labadura na. Manlogis na ay agew et adi kayo mangmangan si tinapay ay wada di labadura na si pito ay agew. ");
INSERT INTO kne_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Maga abe di en mangamag sin obla na sin damo ay agew sin pito ay agew ay doy mo adi et masinop kayo ay mandaydayaw. ");
INSERT INTO kne_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Siya abe ay sin pito ay agew ay doy, inag-agew ay man-idaton kayo si mapooan para en Diyos. Mo sin maikapito ay agew abe, adi yon amagen di obla yo mo adi et masinop kayo kasin ta mandaydayaw kayo. ");
INSERT INTO kne_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","“‘Et mo wada kayo sin ili ay idawat ko en dakayo, iey yo sin padi din omona ay tan-ay mo man-ani kayo. ");
INSERT INTO kne_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Itan-ang na ay mangidaton en Diyos ta say awaten Diyos si dakayo. Amagen din padi na sin kabigatan di agew ay pan-ibbayan. ");
INSERT INTO kne_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Sin iso na met laeng ay agew, omiey kayo sin padi si bomaro ay karnero ay esa di tawena ya magay kolang na ta pooana ay mangidaton en Diyos. ");
INSERT INTO kne_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Tapian yo abe din daton ay iey yo en sisya si dowa ay kilo ay arina ay malaokan si mantikan di olivo. Mo mapooan dana ay daton, mansengseng-ew ay panlaydan en Diyos. Pakoyogan yo din daton ay nay si esay litro ay arak. ");
INSERT INTO kne_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Et mo pay ta adi yo pay laeng inikdeng dadi, adi kayon mangmangan sin kaan-ani yo olay mo maata, naiilog ono naoto si tinapay. Olay intoy ili ay kad-an yo, masapol ay tongpalen yo ya siya abe din poli yo si eng-enggana.’” ");
INSERT INTO kne_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘Manlogi sin agew ay pangidatonan yo sin omona ay nasingay ay apit yo, manbilang kayo si opatapolo ya siyam ay agew. ");
INSERT INTO kne_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Et mo sin maikalimapolo ay agew ay say kabigatan di maikapito ay agew ay pan-ibbayan, man-idaton kayo en Diyos si tinapay ay inoto yo sin baro ay apit yo. ");
INSERT INTO kne_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Dowa ay tinapay ay naoto si sagdodowa ay kilo ay arina di iey yo sin padi ta itan-ang na ay mangidaton. ");
INSERT INTO kne_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Wada abe di datdaton ay mapooan ay itapi yo sin doy ay tinapay. Din maitapi et pito ay lalaki ay karnero ay magay kolang da ay sag-eesay tawen da, esa abe ay bomaro ay baka ya dowa ay bomaro ay karnero, pati din makidaton ay makan ya arak. Mapooan am-in dana ta mansengseng-ew ay panlaylaydan Diyos. ");
INSERT INTO kne_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Masapol abe ay man-idaton kayos esa ay lalaki ay kalding ay manglinis si basol yo ya dowa ay lalaki ay karnero ay saes-a di tawena ay say pan-ookoban yo ya makikadkadwaan yo en Diyos. ");
INSERT INTO kne_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Din nay dowa ay karnero et pakitan-ang di padi sin tinapay ay say nasantoan ay maidaton en Diyos para sin papadi. ");
INSERT INTO kne_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Sin doy met laeng ay agew, adi yo amagen di obla yo mo adi et masinop kayo ay mandaydayaw. Sinay ay bilin et masapol ay tongpalen yo ya siya abe din poli yo si eng-enggana, olay mo into di panbebeeyan yo. ");
INSERT INTO kne_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘Mo man-ani kayo sin payew yo, adi yo palaloan ay anien din wadas benget na ya sageyen di labsan yo. Bay-an yo ta waday okan di nabiteg ya mangili. Tongpalen yo na tan sak-en si Yahweh ay Diyos yo.’” ");
INSERT INTO kne_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","“‘Din omona ay agew sin maikapito ay bowan et nabanol ay agew ay pan-ibbayan yo. Mo dengngen yo di tanggoyob, masinop kayo ay mandayaw. ");
INSERT INTO kne_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Adi yon amagen di obla yo, mo adi et en kayo man-idaton si mapooan para en Diyos.’” ");
INSERT INTO kne_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","“‘Mo manpitsa 10 sin maikapito ay bowan, siya na di agew ay malinisan di basbasol di ipogaw. Sin siya di ay agew, adi kayo mangan, mo adi et masinop kayo ay mandayaw ya man-idaton si mapooan para en Diyos. ");
INSERT INTO kne_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Adi kayo aben man-obla sin agew ay nay, tan siya na ay agew di kalinisan di basol yo sin sangoanan Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mo sino ay Israelita di mangan si kompormi sin isna ay agew et maipowira sin iib-a na ay ipogaw en Diyos, ");
INSERT INTO kne_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","et mo sino abe di man-obla, si Diyos ay mismo di manosa en sisya ta matey. ");
INSERT INTO kne_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Masapol ay tongpalen yo na ay bilin ya siya abe din poli yo si eng-enggana, olay mo intoy ili ay kad-an yo. ");
INSERT INTO kne_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Manlogi sin kadiposan di agew sin pitsa 9 enggana sin kabigatana ay kadiposan aben di agew, ibilang yo ay nabanol na ay agew ay pan-ibbayan ya adi yo abe panganan si olay sino.’” ");
INSERT INTO kne_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","43","“‘Mo makdeng ay man-ani kayo, silibraren yo din fiesta ay makwani en Ab-abong ay pandaydayawan yo en Diyos. Pito ay agew di kabayag na ay manlogi sin maikasinpo ya lima ay agew di maikapito ay bowan. Sin damo ay agew, adi yo amagen di obla yo, mo adi et masinop kayo ay mandayaw. Man-a kayo si kamayatan ay prutas, tobon di palma, pangan di masaybog ay kaiw, ya napintas ay molmola ay gomabay sin kad-an di ginawang, et ilogi yo ay mansilibrar sin fiesta. Inagew ay man-idaton kayo si mapooan para en Diyos si pito ay agew. Et mo pay ta sin maikawao ay agew, masinop kayo ay mandaydayaw kasin ya man-idaton kayo abe si mapooan. Adi yo amagen di obla yo sin agew ay nay. Masapol abe ay man-iyan kayo am-in ay Israelita sin amagen yo ay ab-abong sin nay pito ay agew ta say maammoan di poli yo ay nanbebeeyen Diyos din aap-o da si ab-abong sin nangibelaana en daida ed Egipto. Tongpalen yo na ay bilin ya siya abe din poli yo si eng-enggana. Siya na di kanan Yahweh ay Diyos yo. “‘Si da doy ngarud din nasantoan ay fiesta ay masapol ay tongpalen yo. Nabanol dadi ay masinsinopan ya pandaydayawan yo panggep si pan-idatonan si makan, apit, arak, daton ay mapooan, ya odom ay daton para en Diyos sin kosto ay agew ay maibagayan da. Maitapi dadi ay fiesta sin agew ay pan-ibbayan, et di maitapi abe sin datdaton yo ay doy et din sigod pay dedan ay idatdaton yo ay mapos nemnem yo ya din inkari yo ay datdaton en Diyos.’” ");
INSERT INTO kne_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Siya dadi din bilbilin ay inbagan Moses sin Israelita ay maipanggep sin amin ay nasantoan ay fiesta ay pandayawan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ibilin mo sin Israelita ta iali day kamayatan ay lana ay napo sin napespesan ay lames di olivo sin Tolda ay Panpappailaak. Amagen da di ta say kanayon ay manbidbidang din silaw ");
INSERT INTO kne_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","4","ay wada sin Nasantoan ay Kowarto sin sangon di kurtina ay nanasalin sin Baol di Tolagan. Minasdem ay tetengan Aaron din silaw ay nay ay naipeey sin patangan di silaw ay balitok ta say maninsinlabi ay manbidbidang sin sangoanak. Din bilin ay nay et masapol ay tongpalen yo ya siya abe din poli yo si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Man-a ka si sinpo ya dowa ay kilo sin kamayatan ay arina ta otoem si sinpo ya dowa ay tinapay. ");
INSERT INTO kne_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Asi ka pay sag-eenemen ay dapaten si dowa ay linya ay maipatang da sin lamisaan ay napakpakan si natanig ay balitok sin sangoanak. ");
INSERT INTO kne_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Man-ipeey ka abe si natanig ay insinso sin dowa ay linya ta say mapooan ay maidaton en sak-en et kaman say sokat din tinapay. ");
INSERT INTO kne_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sinabado ay wada di tinapay ay madapat sin sangoanak. Siya na di lebbengen di Israelita si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Din tinapay ay nay et okan da Aaron ya din poli na. Kanen da sin Nasantoan ay Kowarto tan say kasasantoan si bingay da sin daton ay mapooan para en sak-en.” ");
INSERT INTO kne_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Inbilin Diyos en Moses ay ibaga na sin Israelita, “Naey di kanan Diyos. ‘Adi kayo man-amag si sinan didiyos. Adi kayo aben mantood ya mantikitik si bato ta say dayawen yo. ");
INSERT INTO kne_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Say tongpalen yo pay et din bilbilin ko maipanggep sin agew ay pan-ibbayan ya nasantoan ay fifiesta ya patgen yo din Tolda ay Panpappailaak. Sak-en si Yahweh ay Diyos yo ay nangibagas na. ");
INSERT INTO kne_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“‘Mo tongtongpalen yo din linteg ya bilbilin ko, ");
INSERT INTO kne_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ibaak din odan sin kosto ay timpo ta manlames din mola ya kaiw sin daga yo. ");
INSERT INTO kne_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Omad-ado di apiten yo et man-an-ani kayo pay laeng sin timpon di panagbobolas si obas ya siya abe ay manbolbolas kayo pay laeng sin timpon di panagbabangkag. Wada am-in di makan ay masapol yo et maga di pandandanagan yo ay manbibiyag sin daga yo. ");
INSERT INTO kne_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“‘Siya abe ay panturayek di talna sin ili yo, et maseyep kayo ay maga di pan-egyatan yo tan kaanek din maangat ay aanimal sin kad-an yo ya maga abe di en mangobat en dakayo. ");
INSERT INTO kne_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Iso na abe dedan ay mo waday en yo gobaten, atikoen ya peslen yos daida. ");
INSERT INTO kne_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Tan mo san lilima en dakayo et abaken da di sin-gasot ya di sin-gasot yan abaken day sinpo ay libo. ");
INSERT INTO kne_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Bindisyonak abe si dakayo et omad-ado ya mabonat kayo et siya abe ay tongpalek din intolag ko en dakayo. ");
INSERT INTO kne_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ad-adon to di apiten yo et omanay si esay tawen ya mansobsobra pay et iwasit yo di odom ay baak ta waday pangipenpenan yo sin baro ay apiten yo. ");
INSERT INTO kne_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Makibeeyak en dakayo et adiak polos taynan si dakayo, ");
INSERT INTO kne_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","mo adi et kadkadwaek dakayo si kanayon. Sak-en di bigbigen yo ay Diyos yo yan si dakayo di ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Sak-en si Yahweh ay Diyos yo ay nangibela en dakayo ed Egipto ta adi kayon maibabag-en si oway, et dinadael ko din panakabalin da ay kaman mangitatamed en dakayo ta say maiwayaan kayo ya makaan di panbainan yo.’” ");
INSERT INTO kne_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","15","“Siya abe ay kanan Diyos, ‘Mo sigaan yo ay tongpalen din linteg ya bilin ko ya labsingen yo abe din intolag ko, ");
INSERT INTO kne_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","dosaek si dakayo babaen si adi kaagasan ay sakit ya podot ay gomodab ya omin-inot ay pomse. Mo man-esek kayo abe yan sayang, tan din mangobat en dakayo di mangan sin lames da. ");
INSERT INTO kne_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Iso na abe ay pandokogak si dakayo ta say din mangililiget ya mangobat en dakayo di mangabak ya mangituray en dakayo. Palalo abe di egyat yo, et tomagtag kayo olay mo magay mangatiko en dakayo. ");
INSERT INTO kne_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“‘Et mo makdeng am-in dadi ay ligat yan adi yo pay laeng patien sak-en, dosaek si dakayo si mamin pito di dagsena begew sin basbasol yo. ");
INSERT INTO kne_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Siya abe ay kaanek di begew ay palalo di panlaslastogan yo. Panbalinek ed langit ay kaman landok ta magay odan ya din lota si kaman gambang ta maga di tomobo si mola, ");
INSERT INTO kne_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","et mo man-obla kayo, owat maabos di pigsa yo, tan adi gomabay di molmola sin daga yo ya olay abe din kakaiw yan adi da manlames.’” ");
INSERT INTO kne_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Siya dana di bilin ya linteg ay inbagan Diyos en Moses sin kawada na ed dontog ay Sinai ta ibaga na abe sin Israelita. ");
INSERT INTO kne_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Inbagan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ipaalim din Levita ta dotokam daida ay kabadang Aaron ay padi. ");
INSERT INTO kne_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","8","Daida di makaammo sin obla sin Tolda ay Panpappailaak. Ay-ayowanan da din am-in ay maosal sidi ya amagen da abe din panlebbengan da para sin odom ay Israelita. Say iyat da ay mansilbi en Aaron ya sin intiro ay gimong. ");
INSERT INTO kne_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Din obla anggoy ay amagen di Levita et din pansilbian da en Aaron ya din aan-ak na ay lalaki. ");
INSERT INTO kne_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Mo da Aaron ya din an-ak na ay sana, dotokam daida ay mansilbi ay papadi. Mo sino di baken nadotokan yan amagena din oblan di padi et makeddengan ay matey.” ");
INSERT INTO kne_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Ibagam na sin Israelita: Mo waday lalaki ono babai ay mangikari si nabanol ay kari ay mangidaton si awak na ay mansilbi en Diyos, ");
INSERT INTO kne_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","masapol ay adi man-in-inom si arak ono olay sino ay bemeteng. Adi aben man-inom si danom di obas ya sokan di obas. Maiparit abe en sisya din lames di obas ya pasas. ");
INSERT INTO kne_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Sin oneg di timpo ay inkari nay awak na ay mansilbi en Diyos, adi mabalin ay mangan si olay sino ay napo si obas, olay bokel ono okis na. ");
INSERT INTO kne_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Sin intiro ay timpo ay inkari na ay pansilbiana en Diyos, masapol ay adi polos mapokisan, tan maibilang sisya ay nasantoan enggana ay makdeng din timpo ay inkari na. ");
INSERT INTO kne_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Sin intiro ay timpo ay inkari na, adi aben mabalin ay somag-en si natey, ");
INSERT INTO kne_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","olay pay mo si ama na, ina ono agi na. Masapol ay adi na pakadodogisen din awak na, tan ipailan din book na ");
INSERT INTO kne_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ay indatonay awak na ay mansilbi en Diyos. ");
INSERT INTO kne_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Siya na di linteg ay onodan di nangikari ay mangidaton si awak na en Diyos mo makdeng din timpo ay inkari na ay pansilbiana: Koyogen das sisya sin segpan di Tolda ");
INSERT INTO kne_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","yan idawat na din datona en Diyos. Tolo ay animal ay magay kaoyawana di idatona. Masapol di bomaro ay karnero ay mantawen si esa ta maidaton ay mapooan, esay bomalasang ay karnero ay mantawen si esa ta maidaton para sin basbasol na ya kalakian ay karnero para sin daton ay pan-ookoban da ya makikadkadwaan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Man-idawat abe si esay baskit ay tinapay ay magay labadura na–naposkol ay tinapay ay nalaokan si mantikan di olivo ya naingpis ay napay-an si mantikan di olivo. Maitapi abe din naitoding ay daton ay arina ya arak. ");
INSERT INTO kne_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ipailan din padi dana sin sangoanan Diyos et idatona din daton para sin basbasol di ipogaw ay sana ya din daton ay mapooan. ");
INSERT INTO kne_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Idatona abe din kalakian ay karnero ay say maidaton ay pan-ookoban da ya makikadkadwaan da en Diyos pati din esay baskit ay tinapay ya din daton ay arina ya arak. ");
INSERT INTO kne_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Emey sin segpan di Tolda din ipogaw ay nangidaton si awak na yan koskosana din toktok na, asi na itep-a sin apoy ay naipatangan din daton ay pan-ookoban da ya pakikadkadwaan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Alaen din padi din naoto ay padangan di karnero et ipag-ena sin ipogaw ay sana pati din esa ay naposkol ay tinapay ya esa ay naingpis ay kankanen. ");
INSERT INTO kne_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Pag itan-ang din padi dana sin sangoanan Diyos tan nasantoan ay daton. Intoding di linteg ay okan din papadi dana pati din pagew ya opo. Mo makdeng di, mabalin ay man-inom si arak din ipogaw ay sana.” ");
INSERT INTO kne_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Inbilin Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ibagam en Aaron ya din an-ak na ay lalaki ta say kanan da na mo bindisyonan da din Israelita: ");
INSERT INTO kne_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Sapay koma ta bindisyonan ya ay-ayowanan Diyos dakayo. ");
INSERT INTO kne_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Sapay koma ta ipailan Diyos di layad ya seg-ang na en dakayo. ");
INSERT INTO kne_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Sapay koma ta siged di amagen Diyos en dakayo ta say siged ya natalna abe di biyag yo.’” ");
INSERT INTO kne_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Pag kanan Diyos, “Mo din ngadan ko di os-osalen da Aaron ay mamindisyon sin Israelita, bindisyonak abes daida.” ");
INSERT INTO kne_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Manipod sin agew ay naiamagan din Tolda ay Panpappailaan Diyos, nawada di liboo ay nanlikmot sin Tolda. Sin labi yan kaman apoy di kailaan din liboo ay sana. ");
INSERT INTO kne_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mo basta komayang din liboo, taynan din Israelita din nankampoan da, et asi da kasin mankampo mo intoy lugar ay bomabaan din liboo. ");
INSERT INTO kne_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Taynan da din kampo da mo say ibilin Diyos yan iamag da abe mo say ibilina. Mo basta mantee din liboo sin kayang di Tolda, adi dan taytaynan din kampo da. ");
INSERT INTO kne_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Mo mabayag di pantean din liboo sin kayang di Tolda, siya abe di kabayag da ay mankampo ay nanongpal sin bilin Diyos. ");
INSERT INTO kne_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mo mamingsan yan owat at-atik ay agew di pantean din liboo sin kayang di Tolda, et mantee da ya man-etan da insigon sin ibilin Diyos. ");
INSERT INTO kne_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Mo mamingsan, mantee din liboo manlogi sin malablabi enggana sin agsapa anggoy, et malobwat da ay komaan mo basta komayang din liboo. Olay sino ay timpo et man-etan da mo komayang din liboo. ");
INSERT INTO kne_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Olay doway agew, esay bowan, esay tawen ono mabaybayag pay, adi da man-et-etan mo mantetee din liboo sin kayang di Tolda. Ngem mo komayang yan man-etan da. ");
INSERT INTO kne_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Mankampo ya man-etan da insigon sin ibilin Diyos en Moses. ");
INSERT INTO kne_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Sin pitsa baintin di maikasinpo ya opat ay bowan manlogi sin kinmaanan di Israelita ed Egipto, kinmayang din liboo manipod sin Tolda ay Naidolinan di Tolagan. ");
INSERT INTO kne_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Pag dan manlobwat ay komaan sin lugar ay magay omili ed Sinai, et nan-etaetan da enggana ay somaldeng din liboo sin lugar ay magay omili ed Paran. ");
INSERT INTO kne_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Sin nanlobwatan da sin dontog ay Sinai ay panpappailaan Diyos, nandad-an das tolo ay agew. Inpangpango da din Baol di Tolagan Diyos ta man-anap das pankampoan da. ");
INSERT INTO kne_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Mo taynan dan kampo da, wada sin kayang ay patag da din liboo ay kailaan di kawadan Diyos. ");
INSERT INTO kne_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Wada et di odom ay ipogaw ay nakibewbeweg sin Israelita, yan palalo di aklong da ay mansidas karni. Olay abe din Israelita et kanan da, “Wada koma di karni ay sida tako. ");
INSERT INTO kne_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ed Egipto et nan-om-oma takos nigay ay magay bayad na. Wada pay di kasimon, sandya, danggo, siboyas ya bawang. ");
INSERT INTO kne_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ngem ed wani yan magay gan-ganas tako ay mangmangan, tan kanayon ay din manna ay nay di kankanen tako.” ");
INSERT INTO kne_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Dinngen Moses din am-in ay ririn din kaipoipogaw ay wada sin pantew di kampo da ay tolda. Idi siya di, palalo di bonget Diyos et nadismaya si Moses. ");
INSERT INTO kne_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Pag nan kanan en Diyos, “Apay ngin ay say inyat mo na en sak-en? Ay lawlawa di inamag ko sin pangilam? Apay nga inpabiyang mo en sak-en din kaipoipogaw ay nay? ");
INSERT INTO kne_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Baken met sak-en di nangamag ono nakin anak en daida. Apay nga inbagam ay sak-en di mangayowan ay kamanak para ay-ayowan si moyang ay ab-abaek ay iey sin daga ay inkarim sin aam-a da? ");
INSERT INTO kne_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Intoy enak pangaan si karni ay para sin kaipoipogaw ay nay? Kanayon ay manmaymayotmot da ay mangwani, ‘Omya ka si karni.’ ");
INSERT INTO kne_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Adiak kabaelan mo es-esak ay mangayowan sinan kaipoipogaw. Palalo ay madagsen na ay maipaobla en sak-en. ");
INSERT INTO kne_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Mo kaman dana di paamag mo en sak-en, pangaasim ta pomse ka et ta say adiak nam-osen din kaitoloyan di ligat ay nay.” ");
INSERT INTO kne_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Kanan Diyos en Moses, “Manpili ka ngarud si pitopolo ay lalaki ay mabigbig di kaipogaw da sin papangolon di Israelita. Pasinop mos daida sin Tolda ay Panpappailaak ta isdi ay makipika da en sik-a. ");
INSERT INTO kne_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Bomabaak ay en makingalat en sik-a. Yan ibingayak daida sin indawat kon sik-a ay Ispirito. ");
INSERT INTO kne_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Badangan das sik-a ay mangay-ayowan sin kaipoipogaw ta baken kan es-esa.” ");
INSERT INTO kne_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Pag bemela si Moses et inbaga na sin kaipoipogaw din inbilin Diyos. Inayagana din pitopolo ay papangolo et inpapika nas daida ay linikob da din Tolda. ");
INSERT INTO kne_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Asi bomabas Diyos ay napo ed langit ay naikoyog sin liboo et nakingalat en Moses. Pag nan ibingay din Ispirito ay wadan Moses sin pitopolo ay papangolo. Idi sinenggep din Ispirito en daida, nan-ipadto da, ngem adi dan inpidpidwa. ");
INSERT INTO kne_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mo sin pitopolo ay papangolo, wada et di dowa en daida ay manngadan si Eldad ya Medad ay nataynan sin kampon di kaipoipogaw ay adi inmey sin Tolda ay Panpappailaan Diyos. Sinenggep abe din Ispirito en daida, pag da et man-ipadto. ");
INSERT INTO kne_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Idi siya di katagtag di esa ay baro yan inbaga na en Moses din inam-amag da Eldad en Medad. ");
INSERT INTO kne_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Wada et si Josue ay anak Nun ay namadbadang en Moses manlogi sin kabaro na yan kanana en Moses, “Apo, ipasaldeng mos daida!” ");
INSERT INTO kne_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Pag kanan Moses, “Adi ka koman madanagan begew sin panangisakit mo en sak-en. Laydek ay am-in koma ay ipogaw en Diyos et maidawtan das Ispirito na ta man-ipadto da ay kaman dan mamadto.” ");
INSERT INTO kne_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Idi nakdeng di, nantaolis da Moses ya din pitopolo ay papangolon di Israelita sin nankampoan da. ");
INSERT INTO kne_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Pag et bigla ay pawadaen Diyos di dagem ay nangidateng si titit ay napo sin baybay. Tolo ay piya manipod sin lota di kakayang di pantayawan da yan madad-an si esay agew manipod sin kampo di kaannawan di kad-an da sin nanniliked di kampo. ");
INSERT INTO kne_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Sin sidi ay agew, naninsin-agew da ay nandepdepap olay sin nalabi. Say inamag da kasin sin kabigatana. Esa ya esa et nan-olnong si sinlibo ay kilo ono nasurok. Pinalti da asi da pay inbilag ay nanniliked sin kampo da. ");
INSERT INTO kne_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nanpalti da abes insida da, ngem idi daan da pay laeng okmonen, nansakiten Diyos daidas kaeegyat, tan palalo di bonget na. ");
INSERT INTO kne_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kibrot Hattaava di ngadan din ili ay nay, tan say nangiponponan da sin ipogaw ay palalo di aklong das karni. ");
INSERT INTO kne_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Idi wada din Israelita ed Hazerot, pinispis-oy da Miriam en Aaron si Moses gapo sin Cusita ay inasawa na. ");
INSERT INTO kne_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kanan da, “Ay siya mo si Moses anggoy di nankalkalian Diyos? Wada met abe di inpaibaga na en daita.” Dinngen Diyos din inbaga da ay sana. ");
INSERT INTO kne_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ngem di katet-ewa na, napakombaba si Moses, sisya di kapakombabaan ay ipogaw isnan daga. ");
INSERT INTO kne_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Kakali et si Diyos en da Moses, Aaron ya si Miriam yan kanana, “Omali kayo ay tolo sin Tolda ay Panpappailaak.” Et inmey da. ");
INSERT INTO kne_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Pag bomaba si Diyos ay naikoyog si natotood ay liboo et pinmika sin segpan di Tolda. Inayaganas da Aaron en Miriam et sinmag-en da ay dowa yan ");
INSERT INTO kne_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","kanana, “Dengngen yo nan ibagak. Mo waday mamadto en dakayo, ipaammok en sisya din wadas nemnem ko babaen si iitaw ya kaman iitaw. ");
INSERT INTO kne_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ngem baken say iyat ko en Moses ay baak, tan matalek ay mangay-ayowan sin amin ay ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Sangosango ay makikaliak en sisya yan baken bontiya mo adi et maawatan di iyat ko ay makikali en sisya. Inila na pay sak-en. Natoled kayo et kayman ay mamispis-oy en Moses ay baak.” ");
INSERT INTO kne_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Palalo di bonget Diyos en daida et kinmaan. ");
INSERT INTO kne_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Idi komaan din liboo sin Tolda, bigla et ay nawada di kaeegyat ay sakit di kodil en Miriam et kinmilakilat ay kaman andap din kodil na. Sin nangilaan Aaron sin kaeegyat ay sakit di kodil en Miriam, ");
INSERT INTO kne_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","kanana en Moses, “Pangaasim ay apok ta adi ka koman domosa isnan nanbasolan mi gapo si kinaong-ong mi. ");
INSERT INTO kne_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Adi ka koman ipalobos ay manbalin sisya si kaman liton ay enggay nanatey ya nadodonot din awak na sin binmelaana.” ");
INSERT INTO kne_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Et nanpakaasi si Moses en Diyos ay kanana, “Pangaasim kod ay Diyos ta agasam si Miriam.” ");
INSERT INTO kne_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Pag kanan Diyos en Moses, “Mo kaspangarigan tinogpaan ama na din ropa na, masapol ay lak-amena di panakaibabaina si pito ay agew. Isonga masapol ay panteen yos sisya sin lasin di kampo si pito ay agew ta asi yo pataolien.” ");
INSERT INTO kne_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Et inpabela da si Miriam sin lasin di kampo si pito ay agew yan adi da kinmaan din Israelita enggana ay naitaolis sisya. ");
INSERT INTO kne_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Makdeng pay di, tinaynan da ed Hazerot et nan-etan da sin lugar ay magay omili ed Paran. ");
INSERT INTO kne_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Pag kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Manpili kas sinpo ya dowa ay lalaki ay emey ed Canaan ay mansiim sin daga ay idawat ko en dakayo. Sag-eesa ay pangolo di mangialagey sin sinpo ya dowa ay tribu.” ");
INSERT INTO kne_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Tinongpal Moses din inbilin Diyos et pag nan ibaas daida. Napo da sin lugar ay magay omili ed Paran. Am-in da et papangolon di Israelita. ");
INSERT INTO kne_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Idi inbaan Moses daida, kanana, “Manpaamyanan kayo sin ed Negev ay akin abagatan ay sakop di Canaan, asi yo ikanayon ay emey sin kabilbiligan. ");
INSERT INTO kne_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Esten yo ay ilaen mo intoy ison din daga ay sana ya din ipogaw ay mantetees di mo napigsa ono nakapsot da maipanggep si gobat, mo ad-ado ono at-atik da. ");
INSERT INTO kne_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ilaen yo abe mo mayat ono lawlawa din daga ay pantetean da, mo intoy ison din siyodad ay kad-an da, mo naaladan si batbato din nanniliked ono aga. ");
INSERT INTO kne_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ilaen yo abe mo magabay di mola ya mo waday kakaiw ono maga. Mo mantaoli kayo, man-idateng kayo si lames di nais-ek sidi.” Say kanana di, tan sin timpo ay doy di panlogian di obas ay maom. ");
INSERT INTO kne_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Idi siya di nanlobwat din lallalaki ay naibaa. Nanpaamyanan da ay mangil-ila sin daga manipod sin lugar ay magay omili ed Zin enggana ed Rehob ay asag-en ed Lebo Hamat. ");
INSERT INTO kne_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nandan da omona ed Negev et dinmateng da ed Hebron ay kad-an da Ahiman, Sesai ya Talmai. Da naey di palaloy kadadakke da ay ipogaw ay makwani en Anakim. (Nangon-ona ay nabangon nan Hebron si pito ay tawen, asi mabangon di Zoan ed Egipto). ");
INSERT INTO kne_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Idi dinmateng da sin tanap ed Escol, nanpoto das esa ay pangan di obas ay namengyet di lames na. Dowa ay ipogaw di nangaksiw et wada pay di odom ay in-genan da ay prutas ay makwani en granada ya igos. ");
INSERT INTO kne_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Nangadanan ay Tanap ed Escol din ili ay nay begew sin namengyet ay obas ay pinosngin di Israelita. ");
INSERT INTO kne_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Idi nakdeng di opatapolo ay agew, nantaoli din lalaki ay naibaa ay mansiim sin daga. ");
INSERT INTO kne_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nantaoli da sin kad-an da Moses en Aaron ya din am-in ay Israelita ed Kades ay wada sin lugar ay magay omili ed Paran. Inpadamag da en daida din inil-ila da ya inpaila da aben lames di kaiw ay indateng da. ");
INSERT INTO kne_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kanan da en Moses, “Inmey kami et inila mi din daga ay nangibaaam en dakami. Naammoan mi ay maymayat ay daga ay magabay di mola. Naey di tapin di lames di gomabay sidi. ");
INSERT INTO kne_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ngem din ipogaw ay mantetees di et napigsa da yan dadakke abe din siyodad ay kad-an da et nanliked di batbato ay alad da. Inila mi pay din higanti ay Anakim ay wadas di. ");
INSERT INTO kne_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mantetee din Amalekita sin akin abagatan; din Heteo, Jebuseo, ya Amorreo et mantetee da sin il-ili ay kabilbiligan; yan din Canaaneo et wada da abe sin benget di Baybay ay Mediterranean ya sin benget di Ginawang ay Jordan.” ");
INSERT INTO kne_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Pag et paginken Caleb din ipogaw sin kad-an Moses yan kanana, “Masapol ay en tako gobaten si daida ta okaen tako din daga, tan masiguradok ay kabaelan tako.” ");
INSERT INTO kne_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ngem din lallalaki ay ginait Caleb et kanan da, “Adi takon kabaelan ay abaken din ipogaw sidi, tan napigpigsa da mo datako.” ");
INSERT INTO kne_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Et pinalawlawa da sin Israelita din ili ay en da inila. Kanan da, “Kaman pomse din daga ay doy, tan nalaka ay matey di man-ilis di. Yan dadaddadakke am-in ay ipogaw ay inila mi. ");
INSERT INTO kne_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Wada abes di din hihiganti ay Anakim ay palaloy kadadakke da. Din panlikna mi sin awak mi et kaman kamin owat dodon et siya abe di pangila da en dakami.” ");
INSERT INTO kne_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Sin labi ay doy, palaloy ogan di am-in ay Israelita. ");
INSERT INTO kne_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Am-in da et nanriri da en da Moses en Aaron et kanan da, “Agpos et mo natey kami ed Egipto ono isnan lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Apay nga ipangon Diyos datakos sa ay daga ta peslen das datako? Depapen da din asawa ya an-ak tako. Maymayat et mo mantaoli tako ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Pag kanan di esa ya esa en daida, “Manpili tako et si mangipangolo en datako ay mantaoli ed Egipto!” ");
INSERT INTO kne_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Pag mandokmog da Moses en Aaron ay manyakog-ong sin sangoanan di kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Da Josue abe ay anak Nun en Caleb ay anak Jefane ay en nakisiim ed Canaan yan kabisngit da sin mismo ay bado da begew sin sakit di nemnem da ");
INSERT INTO kne_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","8","yan kanan da sin ipogaw, “Maptemapteng din daga ay en mi inila ya magabay di molas di. Mo siged di pangilan Diyos en datako, ipango nas datakos di et idawat na en datako din daga ay doy. ");
INSERT INTO kne_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Adi yo konkontraen si Diyos ya adi kayo emegyat sin ipogaw ay mantetees di, tan nalaka ay abaken tako. Wadas Diyos en datako et enggay inabak na din sinan didiyos ay manalsalaknib en daida. Isonga adi kayo emegyat.” ");
INSERT INTO kne_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ngem dandani ay pigpigen din gimong di kaipoipogaw si daida, asi et bigla ay inila da din mankoniniing ay kinadiyos en Yahweh ay nanpaila sin kayang di Tolda ay Panpappailaana. ");
INSERT INTO kne_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Kanan Diyos en Moses, “Aye pay di kabayag di lomaslasoyan dana ay ipogaw! Ay daetan abey panigaan da ay mantalek en sak-en yan ad-adoy nakaskasdaaw ay sinyal ay inpailak en daida! ");
INSERT INTO kne_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Awni man ta dosaek daida si kaeegyat ay sakit ay ikatey da, ngem asiak pay paad-adoen din an-ak mo ya napigpigsa da mo daida ed wani.” ");
INSERT INTO kne_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ngem kanan Moses en Diyos, “Inpangom dana ay ipogaw ay komaan ed Egipto begew sin panakabalin mo. Mo dosaem daida ed wani, adi pay maammoan din taga-Egipto ");
INSERT INTO kne_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","et ibaga da sin man-ilis na. Da naey pay et enggay nadamag da ay wada ka ay Diyos en dakami. Ammo da ay dadlon kan manpappaila babaen sin liboo ay somaldeng sin kayang ay pinapatag nas dakami. Ammo da pay ay ipangpangom dakami sin nandad-anan mi, tan mo kaagawan, waday natotood ay liboo yan mo sin malabi waday manbidbidang ay apoy. ");
INSERT INTO kne_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ed wani mo peslem am-in nan ipogaw mo, adi pay ibagan di ipogaw sin il-ili ay nakadnge sin maipanggep en sik-a ");
INSERT INTO kne_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ay adi ka kabaelan ay mangipango sin daga ay inkarim ay idawat mo, isonga pinsem daida sin lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Kedawen mi ngarud ay Diyos ay ipailam din panakabalin mo ta amagem din inkarim ed idi ay kanam, ");
INSERT INTO kne_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Sak-en ay Diyos et bakenak nalaka ay bomonget mo adi et komakaman din napalalo ay layad ko. Pakawanek abe di basol yo ya din komonkontraan yo en sak-en. Ngem olay mo siya sa, dosaek pay dedan di nakabasol enggana sin maikatlo ya maikap-at ay kapototan begew sin basbasol di aam-a da.’ ");
INSERT INTO kne_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kedawek ngarud ay pakawanem koma din basbasol dana ay ipogaw begew sin napalalo ya adi manbalbaliw ay seg-ang ya layad mo ay kaman din inyat mo ay namakpakawan en daida manipod sin kinmaanan da ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Sinmongbat si Diyos et kanana, “Amagek din kindaw mo et pakawanek si daida sin am-in ay basbasol da. ");
INSERT INTO kne_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","23","Ngem tet-ewa pay dedan ay maga di olay esa en daida ay nanigaan en sak-en ay makasgep sin ili ay inkarik ay idawat ko sin aam-a da. Tan naila da din mankoniniing ay kinadiyos ko ya din nakaskasdaaw ay inam-amag ko ed Egipto ya sin lugar ay magay omili, ngem inpidwapidwa da pay laeng ay namadpadas sin anos ko. Sinigaan da abe ay tongpalen sak-en. Isonga maga polos en daida di makasgep sin ili ay doy. Dadlon tet-ewa na ay kaman met laeng din katet-ewa na ay matmatagoak ya napno din intiro ay daga sin kinadiyos ko. ");
INSERT INTO kne_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ngem gapo ta adi in-onod Caleb ay bag-en ko di nemnem na en daida et inpapasnek na ay mangonod en sak-en, awni et ipangok sisya sin ili ay ena inila, et okaen din aan-ak ya aap-o na. ");
INSERT INTO kne_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ngem gapo ta isdi ay tanap di pantetean din Amalekita ya Canaaneo, mantaoli kayo si bigat sin dinan yo ta emey kayo sin lugar ay magay omili. Onoden yo din danan ay emey sin Baybay ay Mandalangdang.” ");
INSERT INTO kne_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Kanan Diyos en da Moses en Aaron, ");
INSERT INTO kne_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ay daetan pay di romiriririan da san lawlawa ay ipogaw! Enggay naomaak sin ad-ado ay mayotmot da. ");
INSERT INTO kne_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ibagam ngarud en daida ay dadlon temet-ewa nan isapatak ay kaman din katet-ewan di kamatagok: Din dinngek ay inbaga yo et siya met laeng di amagek en dakayo. ");
INSERT INTO kne_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Am-in kayo ay naibilang sin sinsos ay mantawen si dowanpo ono nasurok et matey ya maiwalang din awak yo isnan lugar ay magay omili begew sin nanririan yo en sak-en. ");
INSERT INTO kne_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Maga di olay esa en dakayo ay makasgep sin ili ay insapatak ay panbalinek si panbeeyan yo malaksid da Caleb en Josue. ");
INSERT INTO kne_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Inbaga yo ay madpap din aan-ak yo, ngem awni et ipangok daida sin daga ay sinigaan yo, et daida din mantetees di. ");
INSERT INTO kne_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ngem mo dakayo pay, maiwalang din awak yo sinan lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Din aan-ak yo et man-etaetan das na ay manlikeliked si opatapolo ay tawen. Daida di mangikaro sin dosa begew sin nanokogan yo en sak-en enggana ay matey kayos nan lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Nam-osen yo din dosan di basbasol yo si opatapolo ay tawen, et say pangammoan yo mo intoy ison di biyag yo mo kontraek dakayo. Opatapolo ay agew di nansiiman yo sin daga ay doy, yan esa ay tawen di kaibilangan di esa ay agew. ");
INSERT INTO kne_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Isapatak ay dadlonak tongpalen dana en dakayo ay lawlawa ay ipogaw, dakayo ay nantitimpoyog ay mangontra en sak-en. Awni man et matey kayo am-in isnan lugar ay nay ay magay omili. Sak-en si Diyos ay nangibagas na.” ");
INSERT INTO kne_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Pag pansakiten Diyos din inbaan Moses ay en nansiim et natey da, tan baken tet-ewa din inpadamdamag da maipanggep sin ili ay inmeyan da et say begew ay nanriri din kaipoipogaw si maikontra en Moses. ");
INSERT INTO kne_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Sin daida ay sinpo ya dowa ay en nansiim, da Josue en Caleb anggoy di adi natey. ");
INSERT INTO kne_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Idi inpaammon Moses na sin Israelita, napalaloy ladingit da. ");
INSERT INTO kne_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Sin kabigatana, nasapa da ay nanikid sin kadondontogan. Kanan da, “Nakabasol tako kayman, ngem nay ay nakasagana tako ed wani ay emey sin lugar ay inkarin Diyos.” ");
INSERT INTO kne_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ngem kanan Moses, “Apay nga adi yo tongpalen din bilin Diyos? Adi kayo mangabak. ");
INSERT INTO kne_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","43","Magas Diyos en dakayo, tan sinigaan yo ay omonod en sisya. Adi kayo ngarud em-emey, tan mo makigobat kayo sin Amalekita ya Canaaneo, abaken ya peslen das dakayo.” ");
INSERT INTO kne_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ngem olay mo siya sa, inpilit da pay dedan ay emey sin kadondontogan, olay mo nataynan sin kampo da si Moses ya din Baol di Tolagan Diyos. ");
INSERT INTO kne_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Idi siya di, nanballalong din Amalekita ya Canaaneo ay mantetee sin kadondontogan. Linaban da et inabak dan Israelita, isonga kaapayaw dan daida enggana ed Horma. ");
INSERT INTO kne_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Da Kora, Datan, Abiram ya si On et kinontra das Moses. Si Kora et anak Izar, si Izar ay nay et anak Kohat, yan si Kohat et Levita. Da Datan en Abiram et sin-iyogtan da ay anak Eliab. Si On abe et anak Pelet. Da Datan, Abiram ya si On et polin Ruben. ");
INSERT INTO kne_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Wada abey 250 ay papangolon di Israelita ay naitapi sin opat ay nay. Da naey ay papangolo et sigod ay nadotokan da ay mangialagey sin gimong et mabigbig di kaipogaw da. ");
INSERT INTO kne_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Natopog da am-in sin sangoanan da Moses en Aaron et pag dan kanan, “Palalo ay ipapangato yon kaipogaw yo. Am-in met ay Israelita ay naitatapi sin gimong et nasantoan da, et wadas Diyos en datako am-in. Apay nga inbilang yon awak yo ay nangatngato mo din odom ay ipogaw Diyos?” ");
INSERT INTO kne_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Sin nanngean Moses sidi, kalakob-o sin lota ay mankararag. ");
INSERT INTO kne_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Pag nan kanan en da Kora, “Si bigat sin agsapa, ipaammon Diyos en datako mo sino di nasantoan ay ipogaw na ay pinili na ay omasag-en en sisya. Din ipalobos Diyos ay omasag-en sin kad-an di altar et si dooy di pinili na. ");
INSERT INTO kne_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Say onodan yo dana ay Kora ya din gagait mo. Si bigat sin agsapa, man-a kayos pay-an yos man-ganggangab ay oling ya insinso, asi yo iey sin altar sin sangoanan Diyos. Din pilien Diyos en dakayo et sisya di nasantoan. Dakayo et adi ay Levita di palalo ay nangipapangato sin kaipogaw yo!” ");
INSERT INTO kne_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Intoloy Moses ay nangibaga en Kora, “Dengngen yo ta waday ibagak en dakayo ay Levita. ");
INSERT INTO kne_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Din Diyos di Israelita et inlasinas dakayo sin odom ay Israelita ta say dakayo di makasag-en en sisya ay mangamag sin obla sin Tolda ay Panpappailaana. Dakayo di dinotokana ay mangialagey sin gimong ay mansilbi en daida. Apay adi omanay dana en dakayo? ");
INSERT INTO kne_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Enggay inpangato nas sik-a ya din iib-am ay Levita, tan inpalobos na ay somag-en kayo en sisya. Ed wani layden yo pay laeng ay alaen din turay di kinapadi! ");
INSERT INTO kne_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Din inkalim ya din inkalin di gagait mo ay maikontra en Aaron et si Diyos di konkontraen yo.” ");
INSERT INTO kne_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Pag pinaayagan Moses da Datan en Abiram, ngem kanan da, “Sigaan mi ay omali! ");
INSERT INTO kne_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Enggay nalabes di inyat mo, tan inpakaan mos dakami sin maymayat ay daga ed Egipto ay gomabayan di am-in ay mais-ek ta peslem dakami isnan lugar ay magay omili. Ed wani et yan sepsepem ay mamilibilin en dakami? ");
INSERT INTO kne_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Adi ka pay inmipango sin sigesiged ay ili ay gomabayan di am-in ay mais-ek ya adi ka pay indawtan dakamis payew ya daga ay nas-ekan si obas. Yan ed wani pay, laydem ay ietekan dakami? Ado paabe na! Adi kami omali!” ");
INSERT INTO kne_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Pag et palalo ay binmonget si Moses et kanana en Diyos, “Adi ka aw-awaten di olay sino ay idaton dana ay ipogaw. Maga di inamag ko ay lawa sin olay esa en daida ya maga pay di inak ay olay koman dangki ay talaken da.” ");
INSERT INTO kne_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Pag kanan Moses en Kora, “Mo si bigat, masapol ay omali ka ya din 250 ay gagait mo sin Tolda ay Panpappailaan Diyos. Wada abes di si Aaron. ");
INSERT INTO kne_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Esa ya esa en dakayo et alaena din panpey-ana si man-ganggangab ay oling ya insinso, asi na iey sin altar. Siya abe di iyat Aaron.” ");
INSERT INTO kne_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Tinongpal da et pag dan man-a si pinay-an das man-ganggangab ay oling ya insinso et en da nakipika en da Moses en Aaron sin segpan di Tolda ay Panpappailaan Diyos. ");
INSERT INTO kne_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Tinopog aben Kora din intiro ay gimong. Idi wada da ay nakisagang en da Moses en Aaron sin segpan di Tolda, nanpaila et din mankoniniing ay kinadiyos Yahweh sin am-in ay wadas di. ");
INSERT INTO kne_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Pag kanan Diyos en da Moses en Aaron, ");
INSERT INTO kne_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Addawian yo din kaipoipogaw ay sana ta peslek daida ay dagos.” ");
INSERT INTO kne_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ngem nandokmog ay nanyakog-ong da Moses en Aaron ay nangwani, “Sik-a ay Diyos di napoan di biyag di am-in ay way leng-ag na. Ay manbonget ka aya sin amin da nan kaipoipogaw olay mo es-esa anggoy di nakabasol?” ");
INSERT INTO kne_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ibagam sin kaipoipogaw ta omaddawi da sin toldan da Kora en Datan ya si Abiram.” ");
INSERT INTO kne_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Kinoyog Moses din papangolon di Israelita ay inmey sin kad-an da Datan en Abiram. ");
INSERT INTO kne_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kanana sin kaipoipogaw, “Omaddawi kayo sin tolda ay kad-an san lawlawa ay ipogaw! Adi yon sagsagiden di kompormi ay bonag da ta adi kayon maitapi en daida ay madosa begew sin basbasol da.” ");
INSERT INTO kne_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Idi siya di, tinongpal da din inbagan Moses et inaddawian da din tolda ay kad-an da Kora, Datan ya si Abiram. Binmela da Datan en Abiram ya din aasawa ya aan-ak da et pinmika da sin segpan di tolda da. ");
INSERT INTO kne_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Pag kanan Moses, “Ed wani, say pangammoan yo ay si Diyos di nangibaa en sak-en ay mangamag sin amin dana. Baken sak-en di akin nemnem. ");
INSERT INTO kne_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Mo matey dana ay ipogaw ay maga di mapasamak ay panosaan Diyos en daida, say pangammoan yo ay adi inbaan Diyos sak-en. ");
INSERT INTO kne_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ngem mo wada di nakaskasdaaw ay amagen Diyos ay maga di kais-iso na, say pangammoan yo ay da naey ay ipogaw et linaslasoy ya sinigaan das Diyos. Di mapasamak et man-ekang din lota ay mangokmon en daida ya amin ay sanikwa da, et maonog da ay sibibiyag sin kad-an di natey.” ");
INSERT INTO kne_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Idi nakdeng ay inbagan Moses na, nan-ekang din lota ay kad-an da Datan en Abiram. ");
INSERT INTO kne_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Kaman waday tepek din lota ay nangokmon en daida ya sin pamilya da. Am-in abe din gagait Kora ya din sanikwa da et naitapi da ay inokmon din lota. ");
INSERT INTO kne_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Sibibiyag da ay inmey ed dallem sin kad-an di natey ay naitapi din amin ay sanikwa da. Nan-omot din lota, et maga da ay mail-ila. ");
INSERT INTO kne_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Sin nanngean din odom ay Israelita sin kilalad da, katanagtag da ay kinmaan et kanan da ay nangibogaw, “Dalasen yo tan mo makionog tako!” ");
INSERT INTO kne_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Idi nakdeng di, wada et di manbidbidang ay apoy ay napo en Diyos, et pag mapooan din 250 ay lalaki ay nangidaton si insinso. ");
INSERT INTO kne_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Pag kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ibagam en Eleazar ay anak Aaron ay padi ta ena kaanen am-in din bronsi ay palanggana ay wada sin kad-an di bangkay di napooan ay lalaki ya iwalang na din man-ganggangab ay oling sin natken ay lugar, tan din palanggana ay sana et nasantoan da. ");
INSERT INTO kne_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Nanbalin da ay nasantoan tan naosal da ay naidatonan di insinso sin sangoanan Diyos. Alaena ngarud din palangganan di lallalaki ay natey begew sin basol da ta pitpitena enggana ay omingpis ta say maamag si pankaleb sin altar. Manbalin ay sinyal ono pannemneman di Israelita.” ");
INSERT INTO kne_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","40","Idi siya di, tinongpal Eleazar ay padi am-in ay inbilin Diyos en sisya babaen en Moses. Tinopog na am-in din bronsi ay palanggana ay inosal din lalaki ay napooan. Inpapitpit na enggana ay inmingpis et inamag das kaleb di altar. Say mangipanemnem sin Israelita ay maga en daida di mabalin ay man-ipoo si insinso sin sangoanan Diyos malaksid di polin Aaron. Tan mo waday mangipoo, matey ay kaman din napasamak en da Kora ya din gagait na. ");
INSERT INTO kne_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Sin kabigatana, nanriri kasin din am-in ay Israelita en da Moses en Aaron ay nangwani, “Dakayo di namse sin odom ay ipogaw Diyos.” ");
INSERT INTO kne_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Idi matoptopog da ta say pabasolen das da Moses en Aaron, sinagong da et din Tolda ay Panpappailaan Diyos yan kambaw wada et din liboo ay nanlingeb. Nanpaila abe din mankoniniing ay kinadiyos en Yahweh. ");
INSERT INTO kne_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Pag emey da Moses en Aaron sin sangoanan di Tolda ");
INSERT INTO kne_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","et kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Addawiam dana ay ipogaw ta peslek ay dagos.” Pag et mandokmog da Moses en Aaron ay manyakog-ong. ");
INSERT INTO kne_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kanan Moses en Aaron, “Alaem din palangganam ta pay-am si man-ganggangab ay oling ay mapo sin altar, asi ka pay-an si insinso. Dalasem ay emey sin kad-an di ipogaw ta amagem din seremonia ay manglinis sin basbasol da. Tan enggay inpailan Diyos din bonget na yan nanlogi di kaeegyat ay sakit.” ");
INSERT INTO kne_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Tinongpal Aaron din inbagan Moses. Ina na din palanggana na et nanagtag ay inmey sin gawan di natotopogan di ipogaw. Enggay nanlogi din sakit ay man-inalis sin kaipoipogaw, ngem indatona din insinso ta malinisan basbasol da. ");
INSERT INTO kne_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Din inamag Aaron ay nay di nangipasaldeng sin nateyan di ipogaw yan wadas sisya ay pinmipika sin nan-gagawaan di sibibiyag ya natey ay ipogaw. ");
INSERT INTO kne_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Sinpo ya opat ay libo ya pito ay gasot di natey ay ipogaw begew sidi ay sakit ay adi maibilang din natey begew sin inamag da Kora. ");
INSERT INTO kne_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Idi sinmaldeng din kaeegyat ay nay ay sakit, nantaoli si Aaron sin kad-an Moses sin segpan di Tolda ay Panpappailaan Diyos. ");
INSERT INTO kne_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ibagam sin Israelita ta man-a da si sinpo ya dowa ay sokod, sag-eesa sin pangolon di sinpo ya dowa ay tribu, ta idawat da en sik-a. Isolat mo din ngadan di esa ya esa ay pangolo sin sokod na. ");
INSERT INTO kne_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Isolat mo abe din ngadan Aaron sin sokod ay mangialagey sin Levita, tan masapol ay waday sag-eesa ay sokod ay napo sin papangolon di am-in ay tribu. ");
INSERT INTO kne_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ipeey mo dana sin Tolda ay Panpappailaak sin sangoanan di Baol di Tolagan ay pangab-abatak en sik-a. ");
INSERT INTO kne_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Tomobo din sokod di ipogaw ay piliek, et say iyat ko ay mangipasaldeng sin kanayon ay panrirririan di Israelita ay maikontra en dakayo.” ");
INSERT INTO kne_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Siya di nakingalat si Moses sin gagait na ay Israelita et din pangolon di esa ya esa ay tribu yan indawat day sag-eesa ay sokod da, isonga sinpo ya dowa am-in mo maitapi din sokod Aaron. ");
INSERT INTO kne_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Inpeey Moses din am-in ay sokod sin Tolda ay Panpappailaan Diyos sin sangoanan di Baol di Tolagan. ");
INSERT INTO kne_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Sin kabigatana, sinenggep si Moses sin Tolda yan inila na ay tinmobo din sokod Aaron ay nangialagey si Levita. Baken owat tinmobo mo adi et nanbonga yan nanlames si naom ay almond. ");
INSERT INTO kne_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Inbelan Moses am-in din sokod ay napo sin sangoanan Diyos et inpaila na sin Israelita. Inila da din napasamak et esa ya esa yan alaena din sokod na. ");
INSERT INTO kne_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Pag kanan Diyos en Moses, “Itaolim din sokod Aaron sin sangoanan di Baol di Tolagan. Masapol ay maidolin na ay sinyal sin komonkontra ay Israelita ta ammoan da ay matey da mo adi da isaldeng ay manmaymayotmot ay maikontra en sak-en.” ");
INSERT INTO kne_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Tinongpal Moses din inbilin Diyos. ");
INSERT INTO kne_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Idi siya di, kanan din Israelita en Moses, “Enggay et baw sa! Matey kami am-in! ");
INSERT INTO kne_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tan mo sino di omasag-en sin Tolda ay Panpappailaan Diyos et matey. Adi pay say kateyan tako am-in!” ");
INSERT INTO kne_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Binilin Diyos da Moses en Aaron ");
INSERT INTO kne_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","ay ipaammo da din bilbilin ay nay sin Israelita. Kanana, “Man-idawat kayo en da Moses en Aaron si mandalangdang ay bomalasang ay baka ay magay kolang na ya adi pay laeng napakpakoan, ");
INSERT INTO kne_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ta idawat da en Eleazar ay padi. Pag waday mangiey sin baka sin lasin di kampo, et paltiena sin sangoanan Eleazar. ");
INSERT INTO kne_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Pag isiwsiw Eleazar din gomot na sin dada na ta iwalsi na sin sangoanan di Tolda si mamin pito. ");
INSERT INTO kne_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Masapol ay mapooan am-in din partin di animal ay din kopkop, lamlames, dada ya eges ay iniilan di padi. ");
INSERT INTO kne_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Pag man-a din padi si nabanglo ay kaiw ay makwani en sidro ya pingin di hisopo ya manbalanga ay lopot ta itapi na ay ipoo. ");
INSERT INTO kne_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Mo makdeng pay di, masapol ay labaana din bado na ya man-ames, asi pag mabalin ay senggep sin kampo, ngem maibilang pay dedan ay kadodogis enggana sin malablabi. ");
INSERT INTO kne_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Siya abe sin ipogaw ay nangipoo sin baka. Masapol ay labaana din bado na ya boyatana si danom din awak na, ngem maibilang abe ay kadodogis enggana sin malablabi. ");
INSERT INTO kne_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Pag alaen di esay lalaki ay baken maibilang ay kadodogis din dap-on di napooan ay baka ta ipeey na sin lugar ay maibilang ay nalinis sin lasin di kampo. Maigto dana ta say osalen din Israelita ay mangisagana sin danom ay maosal ay panglinis sin maibilang ay kadodogis. ");
INSERT INTO kne_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Din ipogaw ay mangakop sin dap-o yan masapol ay labaana din bado na, ngem maibilang pay dedan ay kadodogis enggana sin malablabi. Din linteg ay nay et masapol ay on-onodan din Israelita ya mangili ay makitetee en daida si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Siya na di linteg ay maonodan mo waday matey sin oneg di pankampoana ay tolda. Olay sino ay ipogaw ay wada sin tolda sin timpon di nateyana ya mo sino abe ay senggep sidi yan maibilang da ay kinmadodogis si pito ay agew. ");
INSERT INTO kne_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Olay sino abe ay koli ya banga ay baken nakakaleban et maibilang abe ay kinmadodogis. ");
INSERT INTO kne_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Mo wada abe di ipogaw sin lasin di kampo yo ay managid si bangkay di pinse da ono gandat na ay natey ono tong-an di ipogaw ono kaot, maibilang ay kinmadodogis si pito ay agew. ");
INSERT INTO kne_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Din amagen yo ta say madalosan din maibilang ay kinmadodogis et siya dana. Masapol ay man-a kayo si dap-on din manbalanga ay baka ay panglinis ta ipeey yo si koli, asi yon pay-an si danom ay napos obbog. ");
INSERT INTO kne_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Pag man-a di esay ipogaw ay maibilang ay nalinis si pingin di hisopo ta isiwsiw na sin danom ay sana, asi nan walsian din tolda ya bonbonag ya din amin ay ipogaw ay wadas di. Masapol abe ay walsiana mo waday ipogaw ay managid si tong-an di ipogaw, kaot, pinse da ay ipogaw ono gandat na ay natey. ");
INSERT INTO kne_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Masapol ay walsian din ipogaw ay maibilang ay nalinis din maibilang ay kinmadodogis sin maikatlo ya maikapito ay agew ta say makdeng ay malinisan sin maikapito ay agew. Sin siya di ay agew, din ipogaw ay kinmadodogis et masapol ay labaana din osal na ya man-ames ta maibilang ay nalinis sin malablabi. ");
INSERT INTO kne_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mo din naibilang ay kinmadodogis yan adi na amagen din seremonia ay kalinisana, komakaman ay kadodogis, tan baken nawalsian sin danom ay panglinis. Masapol ay maipowira sin gagait na ay Israelita, tan inpakadodogis na din Tolda ay Panpappailaan Diyos.” ");
INSERT INTO kne_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Sin damo ay bowan, dinmateng din intiro ay gimong di Israelita sin ed Zin ay magay omili et pag dan mankampo ed Kades. Isdi ay lugar di nateyan ya naiponponan Miriam. ");
INSERT INTO kne_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Magay danom sidi, isonga natopog din ipogaw ay manriri en da Moses en Aaron ");
INSERT INTO kne_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","yan kanan da, “Agpos et koma mo naitapi kami ay natey sin toton-od mi ay dinosan Diyos sin sangoanan di Tolda. ");
INSERT INTO kne_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Apay nga inpangom dakamis nan lugar ay magay omili? Ay kanam en ta isna kami ay matey ya siya abe sin aanimal mi? ");
INSERT INTO kne_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Apay dedan ay tinon-od yos dakami ed Egipto, asi kayo ipangos dakami isnan lawlawa ay lugar ay maga polos di gomabay ay mola? Maga di bakakew, igos, obas ya granada dowan et maga polos di danom ay inomen!” ");
INSERT INTO kne_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tinaynan da Moses en Aaron din kaipoipogaw et inmey da sin segpan di Tolda ay Panpappailaan Diyos. Nandokmog da ay nanyakog-ong, pag da et ilaen din mankoniniing ay kinadiyos en Yahweh. ");
INSERT INTO kne_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Pag kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Alaem din sokod ay wada sin sangoanan di Baol ta topogen yon Aaron din amin ay Israelita. Mo wada am-in din ipogaw ay mangiila, ngalaten yo din bato ay sana ta bomala di danom. Siya say amagen yo ta say bomala di danom isnan bato ta waday pan-inoman din ipogaw ya din animal da.” ");
INSERT INTO kne_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Tinongpal Moses din inbagan Diyos et ina na din sokod. ");
INSERT INTO kne_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Tinopog da Moses en Aaron din am-in ay Israelita et pag kanan Moses, “Dengngen yo nan ibagak, dakayo ay nariri ay ipogaw! Ay piliten yos dakami ay mangipabala si danom isnan bato ta waday inomen yo?” ");
INSERT INTO kne_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Idi siya di kaiseppat si Moses si namin dowa sin sokod na sin bato, pag et kabala di ad-ado ay danom, et say nan-inoman din kaipoipogaw ya din animal da. ");
INSERT INTO kne_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ngem niyamyaman Diyos da Moses en Aaron et kanana, “Gapo ta nakapsot di pammati yo yan adi yon binigbig din nasantoan ay panakabalin ko sin pangiilaan di Israelita, baken dakayo di mangipangolo isnan ipogaw ay emey sin daga ay inkarik ay idawat kon daida.” ");
INSERT INTO kne_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Napasamak na ed Meriba ay say nanririan di Israelita en Diyos et say nangipailaana sin kinasanto na. ");
INSERT INTO kne_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Pag dan komaan am-in din Israelita ed Kades et sinmawang da sin dontog ay Hor ");
INSERT INTO kne_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","sin beddeng di Edom. Sin isdi, kanan Diyos en da Moses en Aaron, ");
INSERT INTO kne_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Adi makasgep si Aaron sin daga ay inkarik ay idawat ko sin Israelita, tan matey sisya gapo ta adi yo inonodan ay dowa din bilin ko sin kawada yo ed Meriba. ");
INSERT INTO kne_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ayagam si Aaron ya din anak na ay si Eleazar ta mantikid kayo sin dontog ay Hor. ");
INSERT INTO kne_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Pag kan kaanen din badon di padi ay inbabadon Aaron ta ipabadom en Eleazar, tan isdi ay matey si Aaron.” ");
INSERT INTO kne_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Tinongpal Moses din inbilin Diyos, et inilan din am-in ay Israelita din nantikidan da sin dontog ay Hor. ");
INSERT INTO kne_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Pag kaanen Moses din badon Aaron et inpabado na en Eleazar. Sidi ay natey si Aaron sin toktok di dontog, pag aben manballalong da Moses en Eleazar. ");
INSERT INTO kne_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Naammoan din intiro ay gimong di Israelita ay natey si Aaron, et nanladingit da si tolonpo ay agew. ");
INSERT INTO kne_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Idi siya di kinmaan din Israelita sin dontog ay Hor et inonod da din danan ay emey sin Baybay ay Mandalangdang ta say likawen da din ili ay Edom. Ngem sin kawada da sin danan, enggay ay adi makaanos din ipogaw, isonga ");
INSERT INTO kne_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","nanriri da en Diyos ya en Moses. Kanan da, “Apay nga inpangom dakami ay komaan ed Egipto ta say matey kamis nan lugar ay magay omili ay maga di makan ya mainom? Enggay naoma kamis nan makan ay lawlawa.” ");
INSERT INTO kne_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Idi siya di pag et ipawadan Diyos di nagitaan ay kaeweeweg sin kad-an da et ad-ado di natey tan kinat da. ");
INSERT INTO kne_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Pag emey din ipogaw sin kad-an Moses et kanan da, “Nanbasol kami kayman begew sin kinali mi ay maikontra en Diyos ya en sik-a. Ngem pangaasim kod ta ikararag mon Diyos ta pakaanena da nan eweg isnan kad-an tako.” Idi siya di inkararagan Moses din ipogaw. ");
INSERT INTO kne_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Pag bilinen Diyos si Moses ta man-amag si sinan eweg ay bronsi ta itakap na si posti ta mo sino di katen di eweg yan tangadena di et maagasan. ");
INSERT INTO kne_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Tinongpal Moses, et nan-amag si sinan eweg ay intakap na si posti, yan tet-ewa ay am-in din kinat di eweg ay nanangad isdi yan naagasan da. ");
INSERT INTO kne_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Idi siya di, intoloy din Israelita ay nandad-an enggana ay domateng da sin tanap ed Moab sin igid di ginawang ay Jordan sin demang na ed Jerico. Et nankampo das di. ");
INSERT INTO kne_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Sin timpo ay doy, wada di ari ed Moab ay manngadan si Balak ay anak en Zippor. Idi nadamag na din kaad-adon di Israelita ya din inyat da ay nangabak sin Amorreo, ");
INSERT INTO kne_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","palalo di egyat na et siya abe sin ipogaw ay iturayana. ");
INSERT INTO kne_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Idi siya di kanan din Moabita sin papangolo ed Midian, “Awni kadi et abosen da nan ad-ado ay ipogaw am-in ay wadas nan kad-an tako ay kaman dan baka ay man-alab sin pastolan.” ");
INSERT INTO kne_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Pag man-ibaa si Balak si en mangayag en Balaam ay anak en Beor ay wada ed Petor ay asag-en di ginawang ay Eufrates sin ili ed Amaw. Kanana ay nangibaga, “Laydek ay ammoam ay wada di kaipoipogaw ay napo ed Egipto ay napno da sin inil-ili et nankampo da sin dagdagas di ili mi. ");
INSERT INTO kne_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Palalo ay ad-ado da mo dakami, isonga pangaasim ta omali ka ta baosam daida ta say abaken mi ya pakaanen mis daida. Ammok ay mo waday bindisyonam ay ipogaw et temet-ewa ay mabindisyonan yan mo waday baosam et mabaosan abe.” ");
INSERT INTO kne_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Inmey din papangolon di Moabita ya Midianita et intakin da di pilak ay ilagbo da en Balaam ta baosana din Israelita. Idi sinmawang da sin kad-an Balaam, inbaga da en sisya din inbagan Balak. ");
INSERT INTO kne_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Pag kanan Balaam, “Maseyep kayos na ed wani ay labi ta mo si bigat, ibagak en dakayo mo sino di inbagan Diyos en sak-en.” Isonga naseyep din papangolo ay sana sin beey Balaam. ");
INSERT INTO kne_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Sin labi ay doy, nginalat Diyos si Balaam ay kanana, “Ay sino nan lallalaki ay sangailim?” ");
INSERT INTO kne_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Sinbat Balaam ay kanana, “Inbaan Balak ay ari ed Moab ta ibaga dan sak-en ");
INSERT INTO kne_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ay wada di ad-ado ay ipogaw ay napo ed Egipto ay napno sin intiro ay daga. Laydena ay enak baosan daida ta say abakena ya pakaanenas daida.” ");
INSERT INTO kne_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Pag kanan Diyos en Balaam, “Adi ka makiey en daida ya adi ka aben babbaosan din Israelita, tan nakdeng ay binibindisyonak daida.” ");
INSERT INTO kne_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Sin kabigatana, inmey si Balaam sin kad-an di inbaan Balak et kanana, “Somaa kayo et, tan adi palobosan Diyos sak-en ay maikoyog en dakayo.” ");
INSERT INTO kne_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Pag dan mantaoli sin kad-an en Balak et inbaga da ay adi layden Balaam ay makiey en daida. ");
INSERT INTO kne_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Idi siya di, nan-ibaa kasin si Balak si papangolo ay ad-ad-ado ya nangatngato di saad da mo din nangon-ona ay inbaa na. ");
INSERT INTO kne_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Inmey da en Balaam et inpaammo da na ay inbagan Balak: “Pangaasim kod ta dadlon kan omali. ");
INSERT INTO kne_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ad-ado di idawat kon sik-a ay gon-gona ya tongpalek am-in ay ibagam. Omali ka koma ta baosam da dooy ay ipogaw.” ");
INSERT INTO kne_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ngem kanan Balaam, “Olay mo idawat Balak en sak-en di am-in ay palata ya balitok ay wada si palasyo na, adiak mabalin ay labsingen si olay at-atik din bilin Yahweh ay Diyos ko. ");
INSERT INTO kne_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ngem olay mo siya sa, maseyep kayos na ed wani ay labi ay kaman din inyat di namangpango ay naibaa ta say maammoak mo wada pay di odom ay ibagan Diyos en sak-en.” ");
INSERT INTO kne_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Sin labi ay doy, nakingalat kasin si Diyos en Balaam et kanana, “Gapo ta inmali din lallalaki ay nay ta en daka ayagan, mansagana ka ta makiey ka, ngem din ibagak anggoy di tongpalem.” ");
INSERT INTO kne_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","22","Sin kabigatana, nakiey si Balaam sin papangolon di Moabita ay kakoyog na din dowa ay baa na. Ngem manbonget si Diyos begew sin nakieyan Balaam. Isonga idi wadas da Balaam sin danan ay nangakabayo sin dangki na, wada din anghel Diyos ay pinmipika ta sawadenas sisya. ");
INSERT INTO kne_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Idi ilaen pay din dangki din anghel ay pinmipika ay nananggen si kampilan, nanliglig sin danan et kinombas sin papayew. Sinoplit Balaam din dangki et inpataoli na sin danan. ");
INSERT INTO kne_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Pag man-etan din anghel sin nailipitan di danan sin nan-gawaan di dowa ay inobasan ay naaladan si batog. ");
INSERT INTO kne_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Idi ilaen din dangki din anghel, nansaldet sin batog et naipit din sikin Balaam, isonga sinoplit na kasin. ");
INSERT INTO kne_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Namangpango kasin din anghel et en pinmipika sin nailipitan di danan ay maga polos di pandanan sin nanbinas-il. ");
INSERT INTO kne_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Idi siya et di, idi ilaen din dangki din anghel yan kalakpap. Binmonget si Balaam et nilogiana ay sopliten din dangki sin sokod na. ");
INSERT INTO kne_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Pag pankalien Diyos din dangki et kananan Balaam, “Ay sino ngin di inamag ko si gapo ay sinmoplitam si namitlo?” ");
INSERT INTO kne_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Kanan Balaam, “Aw a, tan panbalbalinem sak-en ay kaman magay nemnem na. Kaman et mo way intakin kos kampilan ta peslek sik-a ed wani!” ");
INSERT INTO kne_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kanan din dangki ay sinombat, “Ay baken ayan sak-en met laeng din dangki ay nangabkabayoam ed idi engganad wani? Ay wada aya di inam-amag kos kaman nina ed idi en sik-a?” Et kanan Balaam, “Iwed met kitdi.” ");
INSERT INTO kne_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Pag ipailan Diyos en Balaam din anghel na ay pinmipika sin danan ay nananggen si kampilan, isonga kalakpap si Balaam sin lota. ");
INSERT INTO kne_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Kanan din anghel, “Apay nga sinoplit mo din dangkim si namitlo? Inmaliak ay manawad en sik-a, tan baken kosto mo emey kas di. ");
INSERT INTO kne_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Inmila din dangkim et namitlo ay nilisianas sak-en. Mo adi nanlisi et sigurado ay pinsek sik-a koma yan binay-ak pay sisya!” ");
INSERT INTO kne_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Pag kanan Balaam sin anghel, “Nanbasolak kayman. Adiak ammo ay wada ka ay pinmipika sin danan ta sawadem sak-en. Mantaoliak adi mo kanam en lawa di emeyak isdi.” ");
INSERT INTO kne_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ngem kanan din anghel, “Mabalin ay makiey ka sin lallalaki ay nay, ngem say ibagam et enggay din itogon ko en sik-a ay ibagam.” Idi siya di nakeey si Balaam en daida. ");
INSERT INTO kne_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Et siya dana di inpadton Balaam: “Inmayag din ari ed Moab ay si Balak. Din kadondontogan ed Syria sin naibanda si belaan di agew di napoak. Kanana, ‘Omali ka ta baosam din Israelita.’ ");
INSERT INTO kne_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ngem kanak abe en sisya: Ay mabalin aya ay baosak din adi binaosan Diyos ay namarsua ono mankaliak si lawa ay maikontra en daida yan si Diyos pay et maga di inkeddeng na ay dosa da? ");
INSERT INTO kne_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mo wadaak sin kadondontogan, tamtamangek daida, manipod sin kabatbatoan et os-osdongak daida. Daida di nasyon ay omalagey si bokbokod da, tan naitken da, waday nanlasinan da. ");
INSERT INTO kne_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Din Israelita et kaman tapok di kaiarigan da, tan adi kabilang di kaad-ado da. Mo mateyak yan sapay koma ta kaman met laeng din kateyan da ay nalinteg di kabibiyag da.” ");
INSERT INTO kne_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Pag et kanan Balak en Balaam, “Apay ngin sas inamag mo? Inayagak sik-a ta say baosam din kaibaw ko, ngem din inamag mo et binindisyonam daida.” ");
INSERT INTO kne_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Sinombat si Balaam yan kanana, “Din inbagan anggoy Diyos en sak-en di mabalin ay ibagak.” ");
INSERT INTO kne_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Tinamang Balaam din Israelita ay natopotopog din kampon di esa ya esa ay tribu. Siya et di, sin-gep din Ispiriton Diyos sisya ");
INSERT INTO kne_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","yan kanana ay nan-ipadto, “Siya na di ipadton Balaam ay anak Beor ay nalawag di pangila na ");
INSERT INTO kne_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ya makadnge sin ibagbagan Diyos. Adiak naseyep yan inilak di kaman iitaw ay inpailan Diyos ay Manakabalin Am-in. Siya na di inilak: ");
INSERT INTO kne_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Mapmapteng din tolda ay panbebbeeyan di Israelita. ");
INSERT INTO kne_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Maiarig das annawa ay kakakkaiwan ay palma ya garden sin benget di ginawang. Kaman da aben manseng-ew ay kaiw ay makwani en aloe ay inmolan Diyos ya kaman dan nakayang ay sidro sin benget di danom. ");
INSERT INTO kne_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mansobsobran to di danom da, isonga masibsibogan ay kosto din imola da. Nangatngaton to din ari da mo si Agag ya maidayaw din panturayana.” ");
INSERT INTO kne_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Idi makdeng di, inpadto na abe na, “Siya na di ipadton Balaam ay anak Beor ay nalawag di pangila na ");
INSERT INTO kne_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ya makadnge sin ibagbagan Diyos ay Kangatoan ya nakaawat sin inpaammo na. Waday inpailan Diyos ay Manakabalin Amin idi binmabaktadak, ngem adiak naseyep. ");
INSERT INTO kne_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Il-ilaek din mapasamak ed Israel sin tapin di agew. Wadan to di ari ay bomala ed Israel ay kaman talaw ono bolalakaw di koniniing na. Abakena din sosoldadon di Moab ya am-in ay an-ak Set.” ");
INSERT INTO kne_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Pag kanan Diyos en Moses, “Manikid ka sin dontog ay Abarim ta en ka tamangen din daga ay idawat ko sin Israelita. ");
INSERT INTO kne_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Mo makdeng ay ilaem et matey ka abe ay kaman si Aaron ay manong mo, ");
INSERT INTO kne_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","tan adi yo inonodan din bilin ko sin lugar ay magay omili ed Zin. Idi nanriri din ipogaw en sak-en, adi yo binigbig din nasantoan ay panakabalin ko sin pangiilaan di kaipoipogaw.” (Meriba din ngadan di obbog ed Kades sin lugar ay magay omili ed Zin.) ");
INSERT INTO kne_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Kanan Moses, ");
INSERT INTO kne_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Sik-a ay Yahweh, Diyos ay poon di biyag di am-in ay way leng-ag na, sapay koma ta mandotok kas pangolon da nan ipogaw ");
INSERT INTO kne_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ay kabaelana ay mangipango en daida sin am-in ay am-amagen da, ta say din ipogaw mo yan baken dan kaman karnero ay maga di mangayowan en daida.” ");
INSERT INTO kne_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Pag kanan Diyos en Moses, “Piliem si Josue ay anak Nun tan kabaelana, et ikapay mo din takkay mo sin toktok na ay mangipaila ay sisya di napili ay mangipangolo. ");
INSERT INTO kne_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ipapikam sin sangoanan Eleazar ay padi ya sin intiro ay gimong ta say ipaammom en daida ay sisya di maiskat en sik-a. ");
INSERT INTO kne_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ibingay mon sisya din odom ay lebbeng mo ta say tongpalen din am-in ay Israelita. ");
INSERT INTO kne_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Si Eleazar di pangammoana sin am-in ay panlaydak babaen sin pangosalana sin Urim ya Tummim. Si naey di amagen Eleazar ay mangitdo en Josue ya din am-in ay Israelita sin am-in ay amagen da.” ");
INSERT INTO kne_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Tinongpal Moses din inbilin Diyos en sisya et inpapika na si Josue sin sangoanan Eleazar ay padi ya sin intiro ay gimong. ");
INSERT INTO kne_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Inkapay na din takkay na sin toktok Josue, et pag nan ipaammo ay si Josue din maisokat en sisya. ");
INSERT INTO kne_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","5a","Naisolat sin libro ay nay din inbagbagan Moses sin Israelita sin kawada da sin tanap ay magay omili sin lak-am di Moab ay naibanda si belaan di agew sin ginawang ay Jordan. Din kosto ay kad-an da yan asag-en ed Suf ay nan-gawaan di Paran, Tofel, Laban, Hazerot ya Dizahab. ");
INSERT INTO kne_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Sinpo ya esa ay agew di pandad-anan manipod sin dontog ay Sinai enggana ed Kades Barnea mo idan sin kadondontogan ay ili ed Edom. ");
INSERT INTO kne_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Sin damo ay agew di maikasinpo ya esa ay bowan sin maikaopatapolo ay tawen manipod sin kinmaanan da ed Egipto, inbagan Moses din amin ay inbilin Diyos ay ibaga na en daida. ");
INSERT INTO kne_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Napasamak na idi nakdeng ay inabak da Moses da Ari Sihon ay Amorreo ay mangituray ed Hesbon ya si Og ay ari ed Basan ay mangituray ed Astarot ya Edrei. ");
INSERT INTO kne_vpl VALUES ("DT1_5b","006_1_5b","DEU","1","5b","5b","Dadlon inpalawag Moses da nan linteg Diyos ay nangwani, ");
INSERT INTO kne_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Sin kawada tako sin dontog ay Sinai, kanan Yahweh ay Diyos tako, ‘Aped na ay nabayag di nantean yo sin kad-an di dontog ay sana. ");
INSERT INTO kne_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Topien yo din tolda yo ta manlobwat kayo. Emey kayo sin kadondontogan ay panbeeyan di Amorreo ya siya abe sin nandinmang ay il-ili: din tanap ed Jordan, din kadondontogan ya nababa ay bilbilig, din abagatan di Canaan ya din benget di baybay ay Mediterranean. Emey kayo abe ed Canaan, ed Lebanon enggana sin dakdake ay ginawang ay Eufrates. ");
INSERT INTO kne_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Sak-en ay Diyos yo et insapatak ay idawat ko am-in din daga ay nay sin ap-apo yo ay da Abraham en Isaac ya si Jacob ya siya abe sin poli da. En kayo et okaen.’” ");
INSERT INTO kne_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Intoloy Moses ay nangwani, “Idi natey amin din enggay makabael ay makigobat sin timpo ay kinmaanan da ed Egipto, ");
INSERT INTO kne_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","kanan Diyos en sak-en, ");
INSERT INTO kne_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Malabas kayo ed wani ed Ar ay sakop di Moab. ");
INSERT INTO kne_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Asag-en kayo sin ilin di Ammonita ay polin Lot, ngem adi yon palpaligaten ono gobgobaten daida, tan maga polos di idawat kon dakayo sin sakop di ili da, tan nakdeng ay indawat ko en daida.’” ");
INSERT INTO kne_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Idi nalabas tako ed Moab, kanan Diyos en datako, ‘Agadangen yo ed wani din ginawang ay Arnon tan nay ay ipalobos ko ay abaken yo din Amorreo ay si Sihon ay ari ed Hesbon ta okaen yo din ili na. Gobaten yo ta ilogi yo ay okaen din iturayana ay ili. ");
INSERT INTO kne_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Ed wani ay agew, ilogik ay paegyaten en dakayo din amin ay ipogaw isnan intiro ay daga. Gapo sin madamag da maipanggep en dakayo et manpayegpeg das egyat da sin domatngan yo.’ ");
INSERT INTO kne_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Idi wada tako ed Kedemot, waday inbaak en Ari Sihon ay mangituray ed Hesbon, ay mangipaammo sin siged ay nemnem tako en daida. Siya na di inpaibagak, ");
INSERT INTO kne_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Ipalobos mo kod ay malabas kami isnan ilim. Laton ay mantartaros kami sin kalsada ay baken oway di em-emeyan mi sin lak-am di iturayam. ");
INSERT INTO kne_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Amin abe ay kanen ya inomen mi ay mapo en dakayo yan bayadan mis kosto. Say kedawen mi anggoy din pamalobos mo ay mandan kami isnan ili yo ");
INSERT INTO kne_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","enggana ay agadangen mi din ginawang ay Jordan ta emey kami sin ili ay indawat Yahweh ay Diyos mi en dakami. Ipalobos mo koma ay kaman din inyat di polin Esau ed Seir ya din polin Moab ay man-ili ed Ar.’ ");
INSERT INTO kne_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ngem adi pinalobosan Ari Sihon si datako, tan inpakenteg Diyos din nemnem na ta way iyat Diyos ay mamadang en datako ay mangabak en sisya ta okaen tako din ili na ay sinakop tako pay laeng engganad wani. ");
INSERT INTO kne_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Idi siya di, kanan Diyos en sak-en, ‘Ed wani ay agew, ipolang ko en dakayo da Sihon ta abaken yo, isonga ilogi yo ed wani ay okaen din ili na.’ ");
INSERT INTO kne_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Idi inmabat da Sihon ya din sosoldado na ed Jaas, ");
INSERT INTO kne_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ginobat tako et pinse takos sisya ya din an-ak na ya din amin ay sosoldado na, tan indawtan Diyos datako si pigsa ay mangabak en daida. ");
INSERT INTO kne_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Inabak tako amin din ili ay sakop di iturayana et pinse tako amin ay ipogaw isdi, amin ay lallalaki, babbabai ya anan-ak, isonga maga polos di nabay-an en daida. ");
INSERT INTO kne_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Ngem ina tako din aanimal ya odom ay sanikwa da. ");
INSERT INTO kne_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Begew sin pigsa ay indawat Diyos, inabak tako am-in din il-ili manipod ed Aroer enggana sin inil-ili sin benget di tanap ed Arnon ya olay sin siyodad isdi enggana ed Gilead. Maga polos di ili ay adi tako inabak, olay nabaked di alad na. ");
INSERT INTO kne_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Ngem inbilin Diyos ay adi tako emey sin ilin di Ammonita ya din ili sin benget di ginawang ay Jabbok enggana sin il-ili sin kadondontogan, isonga say tinongpal tako.” ");
INSERT INTO kne_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“Sin doy ay timpo, nanpakaasiak en Diyos ay nangwani, ");
INSERT INTO kne_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘Diyos ay Kangatoan, nay nilogiam ay ipaila en sak-en ay baam din kinangatom ya panakabalin mo. Maga polos di odom ay diyos ed langit ono isnan daga ay makaamag sin nakaskasdaaw ay inamag mo. ");
INSERT INTO kne_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Ipalobos mo kod ay agadangek din ginawang ay Jordan ta ilaek din siged ay ili sin bas-il na ay din mayat ay kadondontogan ya ed Lebanon.’ ");
INSERT INTO kne_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ngem gapo dedan en dakayo et inbonget Diyos sak-en, isonga adi na inpalobos ay madmangak. Kanana en sak-en, ‘Kosto! Adi ka kasin ibagbaga sa. ");
INSERT INTO kne_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Mantikid ka et sin dontog ay Pisga ta tamangem din manniliked sin amin ay banda. Owat kan tamangen din ili ay inkarik, tan adiak ipalobos ay agadangem din ginawang ay Jordan. ");
INSERT INTO kne_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Isonga dotokam si Josue ya papigsaem din nemnem na ta say maisokat en sik-a ay mangipangolo sin ipogaw ta okaen da din daga ay tamangem.’” ");
INSERT INTO kne_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Pag itoloy Moses ay nangwani, “Dakayo amin ay Israelita, dengngen yo da nan linteg Diyos ay itdok en dakayo. Tongpalen yo dana ta say matago kayo ya okaen yo din ili ay idawat Yahweh ay Diyos di ap-apo tako en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Adi yon taptapian ono kolkolangan da nan bilbilin Diyos ay ibagak en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Dadlon yo met inila din napasamak ed Baal Peor sin nanosaan Diyos sin amin ay gagait yo ay nandayaw en Baal ay sinan didiyos di taga-Peor, ");
INSERT INTO kne_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ngem binay-ana pay dakayo am-in ay nangipapati ay adi nanokog en sisya, isonga nay deda ay sibibiyag kayo ed wani. ");
INSERT INTO kne_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Initdok amin din linteg Diyos ay inbilina ay itdok en dakayo ta tongpalen yo mo domateng kayo sin ili ay en kayo gobaten ta okaen yo. ");
INSERT INTO kne_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Esten yo ay onodan dana ay linteg, et dayawen din am-in ay nasyon si dakayo, tan mo dengngen da di maipanggep en dana ay linteg et kanan da, ‘Magay makaiso si nemnem ya laing dana ay ipogaw.’ ");
INSERT INTO kne_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Maga polos di odom ay ili ay mais-o di diyos da en Diyos tako, olay intoy kadakdake na ay ili. Tan si Diyos ay daydayawen tako et asag-en en datako ay manongsongbat sin kararag tako mo kasapolan tako din badang na. ");
INSERT INTO kne_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Maga abe di makaiso sin kinalinteg di bilbilin Diyos ay itdok en dakayo ed wani ay agew. ");
INSERT INTO kne_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“Ngem ilaen yo ta esten yo ay nemnemnemen din amagen yo ta adi yon polos linglinglingan amin din inil-ila yo. Itdo yo sin anak ya apo yo ");
INSERT INTO kne_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","din maipanggep sin agew ay doy ed Sinai idi nasinop kayo sin sangoanan Diyos sin nangwaniana en sak-en, ‘Sinopem din kaipoipogaw ta dengngen da din ibagak ta say maitdoan da ay mangegyat ya mangipateg en sak-en sin intiro ay biyag das nan daga ya say itdo da abe sin anak da.’ ");
INSERT INTO kne_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Et doy ay sinmag-en kayo sin poon di dontog ay nililikmot di mangitit ay asok ya naposkol ay liboo ay say kad-an di apoy ay enggay kaman domateng ed daya di bidang na. ");
INSERT INTO kne_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Daddad-aten yo din inyat na ay nakikali en dakayo ay kaman mapmapo din kali na sin kad-an di apoy, et dinnge yo ngem adi yon inila di iso na. ");
INSERT INTO kne_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Inbaga nan dakayo ay tongpalen yo din sinpo ay bilin ay insolat na si dowa ay nadampilak ay bato, tan say iyat yo ay manongpal sin intolag na en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Sin doy ay timpo, binilin Diyos sak-en ta itdok en dakayo din linteg na ta say onodan yo mo domateng kayo sin daga ay dandani ay datngen yo ta okaen yo.” ");
INSERT INTO kne_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Magay inila yo si olay sino ay kais-oan Diyos sin nakikalkaliana en dakayo sin kad-an di apoy sin dontog ay Sinai. ");
INSERT INTO kne_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Isonga siliban yo ta adi kayon bomasol ay man-amag si sinan ip-ipogaw ay lalaki ono babai, ");
INSERT INTO kne_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","18","ono mais-o di ila na si olay sino ay animal, mankodkodap, manbodbodos, titit ono nigay. ");
INSERT INTO kne_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Adi kayon masolsolisog ay mandayaw si olay sino ay matangad ed daya ay kaman din agew, bowan ya talaw ay tinodingan Diyos para sin am-in ay ipogaw isnan daga. ");
INSERT INTO kne_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Tan insalakan pay Diyos si dakayo sin palalo ay nanligligatan yo ed Egipto ta maikasin kayo ay ipogaw na ay kaman ed wani. ");
INSERT INTO kne_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Begew en dakayo, inbonget Yahweh ay Diyos takos sak-en, isonga insapata na ay adiak makaagadang sin ginawang ay Jordan et adiak makadateng sin ili ay ipatawid na en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Mateyak isna ay ili et adiak makaagadang ed Jordan, ngem dakayo pay et dandani ay man-agadang kayo et okaen yo din mayamayat ay ili ay idawat Diyos en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ilaen yo ta adi yon linglinglingan din intolag Yahweh ay Diyos yo en dakayo. Adi kayo polos man-am-amag si olay sino ay daydayawen yo, ");
INSERT INTO kne_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","tan inayan si Diyos ay kaman manbidang ay apoy yan iparit na ay waday ikadkadwa yo en sisya ay daydayawen.” ");
INSERT INTO kne_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Intoloy Moses ay nangwani, “Nemnemen yo kod din napaspasamak ed nabaon sin daan yon bomalaan. Olay damagen yo si amin ay solin di daga. Manlogi sin namarsuaan Diyos si ipogaw enggana ed wani, ay wada aya di napasamak ay kaman din nakaskasdaaw ay napasamak en dakayo? ");
INSERT INTO kne_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Magay odom ay nasyon si nakadnge sin kalin Diyos ay mapmapo sin kad-an di apoy yan nabiyag pay laeng. ");
INSERT INTO kne_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Magay odom ay diyos ay nangisalakan ay mismo si ipogaw na ay binag-en di odom ay nasyon ay kaman din inila yo ay inyat Yahweh ay Diyos tako ed Egipto. Inpaila na din panakabalina begew sin nakaskasdaaw ya kaeegyat ay inam-amag na ya din namadpadasana en datako ya nanalsalaknibana en datako sin gobatan. ");
INSERT INTO kne_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Inpailan Yahweh amin da nan nakaskasdaaw ay nay ta paneknekanan dakayo ay sisya anggoy di Diyos ay magay odom. ");
INSERT INTO kne_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Dinnge yo din kali na ay mapmapod daya ta bagaanas dakayo. Isnan daga abe yan inpaila na din kaeegyat ay apoy ay nangipaammos kawada na et dinnge yo din kali na ay mapmapo sin kad-an di apoy ay sana. ");
INSERT INTO kne_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Gapo sin layad na sin ap-apo yo, siya din gapo ay pinili nas dakayo ya sisya ay mismo di nangipango en dakayo ay komaan ed Egipto babaen sin nakaskasdaaw ay panakabalina. ");
INSERT INTO kne_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Inpakaana di ipogaw ay napigpigsa ya ad-ad-ado mo dakayo sin il-ili da ta ipatawid na en dakayo ay kaman ed wani. ");
INSERT INTO kne_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Isonga ed wani ay agew, nemnemen yo ta adi yon linglingan ay magay odom si Diyos ed langit ya isnan daga. ");
INSERT INTO kne_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Onodan yo din nay bilbilina ay ipalawag ko en dakayo ta say mayat di biyag yo ya siya abe sin an-ak yo ya itoltoloy yo ay mantee sin daga ay idawat Yahweh ay Diyos yo en dakayo si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Pinaayagan Moses din kaipoipogaw, et idi nasinop da amin, kanana, “Dakayo am-in ay Israelita, dengngen yo nan bilbilin ya linteg Diyos ay ibagak en dakayo ed wani ay agew ta dadlon yon ad-adalen ya on-onodan. ");
INSERT INTO kne_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Wada di intolag Apo Diyos en datako sin dontog ay Sinai. ");
INSERT INTO kne_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Baken sin ap-apo tako anggoy di nangitolagan Diyos isna mo adi et pati si datako am-in ay wadas na ed wani. ");
INSERT INTO kne_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Dadlon nakisango si Diyos en dakayo et dinnge yo din kali na ay mapmapo sin kad-an di apoy sin dontog. ");
INSERT INTO kne_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Sin doy ay timpo, wadaak ay pinmipika sin nan-gawaan di kad-an Diyos ya en dakayo et sak-en di nangibagbaga en dakayo sin ibagan Diyos, tan emegyat kayo sin apoy, isonga adi kayon nantikid sin dontog. “Et siya na din kanan Diyos: ");
INSERT INTO kne_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Sak-en si Yahweh ay Diyos yo ay nangipango en dakayo ay komaan ed Egipto ay naibabag-enan yo. ");
INSERT INTO kne_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Adi kayo mandaydayaw si odom ay diyos mo adi sak-en et anggoy. ");
INSERT INTO kne_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Adi kayo man-am-amag ono mankitkitikit si daydayawen yo sin kompormi ay kaman din wadad daya, wadas nan lota ono wada sin danom. ");
INSERT INTO kne_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Adi kayon manyakog-ong ono mandayaw en daida, tan sak-en si Yahweh ay Diyos yo et adiak ipalobos ay waday ikadkadwa yon sak-en ay daydayawen yo. Dosaek di mangontra en sak-en ya din poli na enggana sin anak di apo na. ");
INSERT INTO kne_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Ngem ipailak pay din layad ko sin manglaylayad en sak-en ya manongpal sin bilbilin ko engganas maikapiga ay libo ay kapototan. ");
INSERT INTO kne_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Adi yon os-osalen din ngadan ko si owat magay silbi na, tan sak-en si Yahweh ay Diyos yo et dadlonak dosaen din adi mamanol sin ngadan ko. ");
INSERT INTO kne_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Banolen yo din agew ay pan-illengan ta ikasin yo ay agew para en sak-en, tan siya na din inbilin ko en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Enem ay agew di pan-oblaan yo, ");
INSERT INTO kne_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ngem din maikapito ay agew et pan-ibbayan ay naidaton en sak-en. Isonga maga di man-obla sin agew ay doy, olay din an-ak ya bag-en yo, din animal yo ya din mangili ay wada sin ili yo. Tan masapol ay man-illeng din babag-en yo ay kaman dakayo sin agew ay doy. ");
INSERT INTO kne_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Nemnemnemen yo ay naibag-en kayo abe ed Egipto, ngem sak-en ay si Yahweh ay Diyos yo di nangipawaya en dakayo babaen sin nakaskasdaaw ay pigsa ya panakabalin ko, isonga ibilin ko en dakayo ay banolen yo din agew ay pan-illengan. ");
INSERT INTO kne_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Patgen yos da ama en ina yo tan say bilin ko ay Diyos yo en dakayo ta say omando di biyag yo ya mayat di pantongpalan di amagen yo sin daga ay idawat ko en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Adi kayon manpespese. ");
INSERT INTO kne_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Adi kayon daddaagen di baken yon asawa. ");
INSERT INTO kne_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Adi kayon mangak-akew. ");
INSERT INTO kne_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Adi kayon mantistigo si baken tet-ewa. ");
INSERT INTO kne_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Adi kayon gamgamgaman din asawan di ib-a yo, din beey na, daga na, baa na, baka ya dangki na ya odom pay ay sanikwa na.” ");
INSERT INTO kne_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“Da nay din bilin ya linteg Yahweh ay Diyos yo ay intogona ay itdok en dakayo ta onodan yo sin daga ay awni et okaen yo. ");
INSERT INTO kne_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Sin intiro ay biyag yo ya siya abe sin biyag di ipoli yo, masapol ay dayawen yo si Diyos ya tongpalen yo amin din linteg na ay ibagak en dakayo ed wani ta say omando di biyag yo. ");
INSERT INTO kne_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Dengngen yo ay Israelita yan ilaen yo ta tongpalen yo dana ta say somiged di biyag yo ya omad-ado kayo sin nabaknang ay daga ay magabay di mola ay kaman din inkarin Yahweh ay Diyos di ap-apo tako. ");
INSERT INTO kne_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Dengngen yo na ay Israelita! Si Yahweh et anggoy di Diyos tako, magay odom. ");
INSERT INTO kne_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Imongsan yo din am-in ay nemnem, laing ya bikas yo ay manglaylayad en Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Igto yo koma sin nemnem yo amin da nan linteg ay ibagak ed wani ay agew en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Masapol ay esten yo ay itdo dana sin anak yo et ibagbaga yo mo wada kayo sin bebbeey yo ono sin danan, mo man-illeng kayo ono sin pan-ob-oblaan yo. ");
INSERT INTO kne_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Igading yo sin takkay yo ya ibedbed yo sin kitong yo ta panginemnemneman yo. ");
INSERT INTO kne_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Isolat yo sin hamban di pantew yo ya sin segpan di ili yo.” ");
INSERT INTO kne_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“Tongpalen Diyos din inkari na sin ap-apo yo ay da Abraham, Isaac ya si Jacob et idawat na en dakayo din lugar ay nankababaknang ya dadakke di siyodad na ay adi yon insaad. ");
INSERT INTO kne_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Din bebbeey yan napno si kasapolan ay adi yon inligatan, din daga et namolaan si obas ya kakaiw ay olivo ay baken dakayo di nangimola, yan wada amin di layden yo ay kanen. Et mo idateng Diyos dakayo sin lugar ay sana ");
INSERT INTO kne_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","siliban yo ta adi yon linglinglingan si Diyos ay nangwayawaya en dakayo sin naibabag-enan yo ed Egipto. ");
INSERT INTO kne_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Daydayawen yo si Yahweh ay Diyos yo et sisya anggoy di dayawen ya pansapataan yo. ");
INSERT INTO kne_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Masapol ay adi yon daydayawen di sinan didiyos ay daydayawen di odom ay il-ili ay nanniliked en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Tan si Diyos ay wada sin kad-an yo et iparit na ay waday ikadkadwa yon sisya ay dayawen. Mo pabongeten yo gapo sin pandayawan yos didiyosen, kaman apoy din bonget na ay manosa en dakayo enggana ay maiwed kayo sin labaw di daga. ");
INSERT INTO kne_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Adi kayon padpadasen si Yahweh ay Diyos yo ay kaman din inyat yo ed Massa. ");
INSERT INTO kne_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Masapol ay dadlon yon patien din bilin ya linteg ay indawat na en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Say amagen yo din kosto ya siged sin pangilan Diyos ta say mayat di pantongpalan yo ya maisokat kayo ay mangoka sin nabaknang ay daga ay inkarin Diyos sin ap-apo yo. ");
INSERT INTO kne_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Mo say iyat yo di, pakaanen Diyos amin din kaibaw yo, tan say inkari na. ");
INSERT INTO kne_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Mo sin tapin di agew ya mansalodsod din an-ak yo ya kanan da, ‘Apay ngin ay inbilin Yahweh ay Diyos tako ay tongpalen tako am-in dana ay linteg?’ ");
INSERT INTO kne_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","kanan yo en daida, ‘Ed idi yan binag-en din ari ed Egipto si dakami, ngem inmisalakan si Diyos babaen sin nakaskasdaaw ay panakabalina. ");
INSERT INTO kne_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Dadlon min inila din nakaskasdaaw ya kaeegyat ay inamag na sin taga-Egipto ya sin ari da ya oopisyal na. ");
INSERT INTO kne_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Ngem dakami pay yan inpango nas dakami ay komaan isdi ta idawat nan dakami nan lugar ay nay ay inkari na sin ap-apo tako. ");
INSERT INTO kne_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","25","Inbilin Diyos ay tongpalen tako amin din bilbilina ya dayawen takos sisya. Mo ipapasnek tako ay mangon-onod sin linteg na, kanayon ay ay-ayowanana ya pabaknangena din ili tako ay kaman din inyat na en datako ed wani dowan aben kosto di pakikadkadwaan tako en sisya.’” ");
INSERT INTO kne_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Kanan Moses ay nangitoloy, “Inpangon Yahweh ay Diyos yo si dakayo ta okaen yo din daga ay nay ay dandani ay datngan yo, tan pakaanena din ad-ado ay man-ili sin isdi. Awni et pakaanena din man-ili sin pito ay ili ay napigpigsa ya ad-ad-ado mo si dakayo. Daida din makwani en Heteo, Gergeseo, Amorreo, Canaaneo, Perezeo, Heveo ya Jebuseo. ");
INSERT INTO kne_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Mo enggay ipaabak Diyos daida en dakayo, masapol ay peslen yos daida amin. Adi kayon makitolag ay makikadwa ono maseg-angan en daida. ");
INSERT INTO kne_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Adi kayon makias-asawa en daida ya adi yon ipaasawa din anak yo, ");
INSERT INTO kne_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","tan awisen dan anak yo ay manokog en Diyos ta mandayaw da sin didiyosen da. Dosaen Diyos dakayo ay dagos mo say maamag di. ");
INSERT INTO kne_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Isonga dadaelen yo din altar da ya gemken yo din tinootood da ay bato ay pandaydayawan da. Potoen yo din posti ay pangidaydayaw da en Asera dowan yon pooan din didiyosen da. ");
INSERT INTO kne_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Say amagen yo na tan dakayo din inkakasin Yahweh ay Diyos yo ay ipogaw na. Pinili nas dakayo sin amin ay ipogaw isnan lobong et inbilang nas dakayo ay nabanol ay ipogaw na. ");
INSERT INTO kne_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Baken din kaad-ado yo di gapo ay laylayden ya pinilin Diyos dakayo, tan dakayo din kaat-atikan ay ipogaw isnan lobong. ");
INSERT INTO kne_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Di gapo na et laylayden Diyos dakayo ya matalek sisya ay manongpal sin inkari na sin ap-apo tako, isonga inosal na din panakabalina ay nangwayawaya en dakayo sin naibabag-enan yo sin turay din ari ed Egipto. ");
INSERT INTO kne_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Say pangammoan yo ay si Yahweh ay Diyos yo et tet-ewa ay Diyos ya matalek. Tongpalena din inkari na ya kanayon ay ipaila na din layad na sin manglayad en sisya ya manongpal sin bilina enggana sin maikapiga ay libo ay kapototan. ");
INSERT INTO kne_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ngem dadlonan dosaen ay dagos din mangililiget en sisya. ");
INSERT INTO kne_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Isonga ilaen yo ta tongpalen yo da nan bilbilin ay ipaammok en dakayo ed wani ay agew.” ");
INSERT INTO kne_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“Masapol ay esten yo ay manongtongpal sin amin da nan bilin ay ipaammok en dakayo ed wani ay agew ta say matago kayo, omad-ado kayo ya okaen yo din daga ay inkarin Diyos sin ap-apo yo. ");
INSERT INTO kne_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Nemnemnemen yo din inyat Diyos ay nangipangpango en dakayo si opatapolo ay tawen sin lugar ay magay omili. Begew sin ligligat ay linaklak-am yos di, initdoanas dakayo ay mangibaba sin nemnem yo ya pinadpadas nas dakayo ta maammoan mo panggep yo ay tongpalen din bilina ono maga. ");
INSERT INTO kne_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Inpalobos Diyos ay madagaangan kayo, asi nan pakanen dakayo si manna ay adi yon kinkinan ed idi, olay abe sin ap-apo yo. Say inyat na di ta say maitdoan kayo ay manpakombaba ya ammoan yo ay baken makan et anggoy di katagoan di ipogaw mo adi et masapol da abe di amin ay ibagbagan Diyos. ");
INSERT INTO kne_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Laton met ay adi nadonot din bado yo ya adi linmadag din siki yo sin opatapolo ay tawen ay nandad-anan yo. ");
INSERT INTO kne_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Nemnemen yo ay bagbagaan ya sopliten Diyos si dakayo ay kaman din iyat di esay ama ay mamagbaga sin anak na. ");
INSERT INTO kne_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Isonga masapol ay tongpalen yo din bilin Diyos. Onodan yo din laydena dowan yon patgen ya egyatan sisya. ");
INSERT INTO kne_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Tan inpangon Yahweh ay Diyos yo si dakayo si mayamayat ay daga ay ad-ado di ginawang ya obbog na ay manandanom sin dontog ya tanap. ");
INSERT INTO kne_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Din ili ay nay et mayat di molmola ay kaman din bakakew, sabog, obas, igos, granada ya olivo yan ad-ado abe di anig isdi. ");
INSERT INTO kne_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Din dontog yan mabalin ay panminasan si landok ya gambang. Adi kayon mankolang isdi tan wada amin ay masapol yo. ");
INSERT INTO kne_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Isonga mo domateng kayos di yan mangan kayo ay kosto, man-iyaman kayo en Yahweh ay Diyos yo sin mayamayat ay daga ay indawat nan dakayo.” ");
INSERT INTO kne_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Siliban yo ta adi yon pandokdokogan si Yahweh ay Diyos yo begew sin pamaybay-an yo sin bilbilina ay ibagak en dakayo ed wani. ");
INSERT INTO kne_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Mo mawada amin di layden yo ay kanen ya makaisaad kayo si mankanapteng ay beey yo ");
INSERT INTO kne_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ya mo omad-ado di baka, karnero, palata ya balitok yo ya omad-ado di odom ay sanikwa yo, ");
INSERT INTO kne_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ilaen yo ta adi ngomato di nemnem yo ta adi kayon linglinglingan si Yahweh ay Diyos yo ay nangwayawaya en dakayo sin naibabag-enan yo ed Egipto. ");
INSERT INTO kne_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Inay-ayowananas dakayo sin kawada yo si annawa ya kaeegyat ay lugar ay magay omili ay kad-an di ad-ado ay nagitaan ay eweg ya gayaman. Din lugar ay sana et namgaan ay magay dandanom na, ngem inpabela na di danom sin moling ay bato ta waday pan-inoman yo. ");
INSERT INTO kne_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Pinakanas dakayo si manna sin lugar ay magay omili, makan ay adi yon tinamtamtaman ed idi ya olay din ap-apo yo. Inamag na di ta say ipababa na di nemnem yo ya padasenas dakayo, ngem sin odi na et binindisyonanas dakayo. ");
INSERT INTO kne_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Isonga adi yon kanan en binmaknang kayo sin bokod yo ay pigsa ya kabaelan. ");
INSERT INTO kne_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Nemnemen yo ay si Diyos anggoy di mangidawat si kabaelan yo ay bomaknang, tan say panongpalana sin intolag na sin ap-apo yo ed idi ay kaman met laeng ed wani. ");
INSERT INTO kne_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ibabagak en dakayo ed wani ay sigurado ay dosaen Yahweh si dakayo mo pandokogan yos sisya ay Diyos yo ta mandayaw ya mansilbi kayo si odom ay didiyosen. ");
INSERT INTO kne_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Mo adi yon patien sisya, dosaenas dakayo ay kaman din iyat na sin ipogaw si odom ay ili ay awni et datngen yo.” ");
INSERT INTO kne_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Kanan Moses ay nangitoloy, “Dengngen yo ay Israelita: Agadangen yo ed wani ay agew din ginawang ay Jordan et okaen yo din ilin di ipogaw ay ad-ad-ado ya napigpigsa mo dakayo. Dadakke di siyodad isdi ay nankakakayang di alad da. ");
INSERT INTO kne_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Nankakakayang ya napipigsa abe di man-ili sin isdi et nadamag ay magay makaabak en daida begew sin kadadakke da. ");
INSERT INTO kne_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Ngem ed wani et ilaen yo ay mangon-ona si Diyos mo dakayo et kaman mabidang ay apoy ay manadael sin kalaban yo ta nalaka di iyat yo ay mangabak en daida, tan say inkari na. ");
INSERT INTO kne_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Ngem mo makdeng ay pakaanen Diyos daida, adi yon it-it-ek din awak yo en tinolongan Diyos dakayo gapo sin kinalinteg yo, tan pakaanen Diyos din man-ilis di gapo sin basbasol da.” ");
INSERT INTO kne_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“Dengngen yo ay Israelita nan ibilin Yahweh ay Diyos yo ay onodan yo: Laylayden yo si Yahweh ay Diyos yo, imongsan yo din nemnem yo ay mansilbi en sisya, ");
INSERT INTO kne_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ya patien yo din bilina ay ibagbagak en dakayo ed wani ta say pansigdan yo. ");
INSERT INTO kne_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Si Yahweh ay Diyos tako di akin oka ed daya ya am-in ay wadas di, siya abes nan daga ya amin ay wadas na. ");
INSERT INTO kne_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Ngem olay mo siya di, palalo di layad Diyos sin ap-apo yo, isonga dakayo ay poli da di pinili na ay ipogaw na ay baken din odom ay ipogaw isnan daga, et siya sa di kasasaad yo enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Isaldeng yo ngarud ay mangipakenteg sin nemnem yo ta say manang-awat ya managtongpal kayo en Diyos. ");
INSERT INTO kne_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Tan si Yahweh ay Diyos yo di kangatoan ay Diyos ya Apo. Madamdamag di kinangato na, nakaskasdaaw ya kaeegyat di panakabalina, maga di pabpaborana, ya adi mabalin ay mapasoksokan. ");
INSERT INTO kne_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ikalintegana din naolila ya nalasang ay babbabai. Laylaydena abe din mangili ay makitetee en datako et idawtanas daida si bado ya kanen da. ");
INSERT INTO kne_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Isonga ipaila yo di layad yo sin mangili, tan sin kawada yo ed Egipto et mangili kayos di. ");
INSERT INTO kne_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Patgen ya egyatan yo si Yahweh ay Diyos yo ta sisya anggoy di daydayawen ya pansilbian yo. Itoltoloy yo ay mantalek en sisya ya sisya anggoy di pansapataan yo. ");
INSERT INTO kne_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Idaydayaw yos sisya tan sisya di bigbigen yo ay Diyos yan inila yo ay mismo din nakaskasdaaw ya kaeegyat ay inamag na para en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Idi inmey din ap-apo yo ed Egipto, owat dan pitopolo, ngem ed wani yan nay inpaad-adon Diyos dakayo ay kaman din kaad-adon di talaw.” ");
INSERT INTO kne_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Intoloy Moses ay nangwani, “Tongpalen yo amin ay inbilin ko ed wani ay agew ta say makaagadang kayo sin ginawang ay Jordan ya ta kabaelan yo ay okaen din daga ay datngan yo. ");
INSERT INTO kne_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Mo say iyat yo et omando di biyag yo sin daga ay inkarin Diyos sin ap-apo yo ya sin poli da. Din daga ay doy et nabaknang ya magabay di mola. ");
INSERT INTO kne_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Baken kaman ed Egipto din daga ay awni et okaen yo, tan mo manmola kayo sin kawada yo ed Egipto et masapol ay manling-et kayo ay manibsibog, ");
INSERT INTO kne_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ngem din daga ay dandani ay okaen yo et kadondontogan ya tanap ay sibsibogan di odan. ");
INSERT INTO kne_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Kanayon ay ay-ayowanan Diyos din daga ay sana sin amin ay agew di tawen. ");
INSERT INTO kne_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Mo tongtongpalen yo da nan ibilin ko en dakayo ed wani ay agew ta laylayden yos Yahweh ay Diyos yo ya imongsan yo din nemnem yo ay mansilbi en sisya, ");
INSERT INTO kne_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ipawada na di odan sin kosto ay timpo ta say kanayon ay way anien yo ya wada abey obas ay amagen yos arak ya olivo ay panpespesan yos lana. ");
INSERT INTO kne_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Gomabay abe din sakati ay para sin animal yo. Wadan to amin din layden yo ay kanen sin daga ay doy. ");
INSERT INTO kne_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“Adi yon linglinglingan da nan bilbilin. Igading yo sin takkay yo ya ibedbed yo sin kitong yo ta say mangipanemnem en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","It-itdo yo sin an-ak yo mo mantoktokdo kayo sin beey yo ono manmandan kayo sin danan ya mo bomaktad ya bomangon kayo. ");
INSERT INTO kne_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Isolat yo sin hamban di pantew yo ya sin segpan di ili yo. ");
INSERT INTO kne_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Mo tongtongpalen yo dana, omando di biyag yo ya biyag di an-ak yo sin daga ay inkarin Apo Diyos sin ap-apo yo ya mantee kayos di si eng-enggana ay kaman din kawadan di daya ay kankanayon sin kayang di daga. ");
INSERT INTO kne_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“Manpili kayo ed wani ay agew mo sino di layden yo, mo say layden yo din bindisyon ono dosa. ");
INSERT INTO kne_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Mabindisyonan kayo mo patien yo din bilbilin ay itdok en dakayo ed wani. ");
INSERT INTO kne_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Ngem madosa kayo mo adi yon patien yan masangaw kayo ay mandayaw si didiyosen ay adi yon dinaydayaw ed idi. ");
INSERT INTO kne_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Dandani ay agadangen yo din ginawang ay Jordan ta en yo okaen din daga ay indawat Yahweh ay Diyos yo en dakayo. Mo enggay inoka yo ya mantee kayos di, ");
INSERT INTO kne_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","masapol ay dadlon yon tongpalen amin din linteg ay ibagak en dakayo ed wani ay agew.” ");
INSERT INTO kne_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Kanan Moses, “Mo mantapos di tonggal maikapito ay tawen, masapol ay adi yon singsingilen mo waday adi nabayadan ay inpaotang yo sin gagait yo. ");
INSERT INTO kne_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Siya na di amagen yo: Amin ay waday inpaotang na sin gait na ay Israelita yan masapol ay adi dan singsingilen mo domteng din timpo ay tinodingan Diyos ay kaponasan di amin ay otang. ");
INSERT INTO kne_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Mabalin ay singilen yo din otang di mangili, ngem masapol ay ponasen yo din otang di gagait yo ay Israelita. ");
INSERT INTO kne_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Maga koma di mabiteg en dakayo, tan bindisyonan Diyos dakayo sin daga ay idawat na en dakayo ");
INSERT INTO kne_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","dalo et mo ipakat yo din kabaelan yo ay manongtongpal sin bilbilina ay ipalawag kon dakayo ed wani. ");
INSERT INTO kne_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Inkarin Diyos en pabaknangenas dakayo et dakayo di mangiotang sin odom ay ili, isonga baken yon kasapolan ay man-otang. Maga di mangituray en dakayo mo adi et dakayo di mangituray sin ad-ado ay ili. ");
INSERT INTO kne_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Mo waday nabiteg ay gait yo ay Israelita ay man-ili sin olay into ay ili sin daga ay indawat Diyos en dakayo, adi yon paidaman mo kasapolana din badang yo. ");
INSERT INTO kne_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Malaydan kayo et koma ay mangipaotang sin kasapolana. ");
INSERT INTO kne_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Adi yon ipaidam din badang yo gapo ta nemnemnemen yo ay dandani din tawen ay tinodingan Diyos en pamonasan yo si otang di gagait yo. Tan mo say nemnem yo di ya man-adawag en Diyos gapo ta pinaidaman yo et maibilang ay basol yo. ");
INSERT INTO kne_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Maga koma di sakit di nemnem yo mo adi et naimposoan di iyat yo ay bomadang ta say bindisyonan Diyos din amin ay obla yo. ");
INSERT INTO kne_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Kanayon ay wada di Israelita ay nabiteg ya makasapol si tolong, isonga ibilin ko en dakayo ay maragsakan kayo ay mangidawat sin kasapolan da.” ");
INSERT INTO kne_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","“Mo wada di olay sino ay ipogaw, lalaki ono babai, sin kompormi ay ili ay indawat Yahweh ay Diyos yo en dakayo yan labsingena din intolag Diyos ");
INSERT INTO kne_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","et mandayaw da ya mansilbi da si sinan didiyos ono sin agew, bowan ya talaw ay maikontra sin bilin Diyos, ");
INSERT INTO kne_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","masapol ay esten yo ay paneknekan. Mo mapaneknekan ay tet-ewa ay wada en dakayo ay Israelita di nangamag si kaman nina ay madagsen ay basol, ");
INSERT INTO kne_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","iey yo di ay ipogaw sin lasin di ili ta pigpigen yo enggana ay matey. ");
INSERT INTO kne_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Makeddengan ay matey di esa ay ipogaw mo wada di dowa ono tolo ay manistigo sin basol na, ngem adi mabalin ay peslen yo mo es-esa anggoy di tistigo. ");
INSERT INTO kne_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Masapol ay din tistigo di mangon-ona ay mamigpig sin nakabasol, asi din odom ay ipogaw. Say iyat yo na ay mangaan sin basol sin kad-an yo.” ");
INSERT INTO kne_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“Mo okaen yo din daga ay indawat Yahweh ay Diyos yo, masapol ay adi yo tadtadonen din kaliliget na ay am-amagen di sigod ay omilis di. ");
INSERT INTO kne_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","11","Masapol ay maga polos en dakayo di mangidaton si anak da ay mapooan. Adi yo aben ipalobos ay wada en dakayo di manpontos, mankotom, mansapo, mansip-ok, man-gengey ya manboyon. ");
INSERT INTO kne_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Kaliliget Diyos di mangamag si kaman dana et say gapo ay pakaanena dana ay ipogaw sin domatngan yo. ");
INSERT INTO kne_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Masapol ay magay ikadkadwa yo en Diyos ay dayawen mo adi et napodno kayo en sisya.” ");
INSERT INTO kne_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Pag kanan Moses, “Din ipogaw sin ili ay dandani ay okaen yo et mamatpati da si man-gengey ya mansip-ok, ngem adi ipalobos Yahweh ay Diyos yo ay amagen yo di. ");
INSERT INTO kne_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Awni kadi et mawaday mamadto ay kaman sak-en ay ibaan Diyos en dakayo. Kailian takos sisya ay Israelita. Masapol ay patien yo di amin ay ibagbaga na. ");
INSERT INTO kne_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Tan sin agew ay nasinopan yo sin poon di dontog ay Sinai, nanpakaasi kayo ta adi makikali si Diyos en dakayo ya adi yon ilaen din kaman apoy ay panpailaana tan emegyat kayo ay matey, ");
INSERT INTO kne_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","isonga kanan Diyos en sak-en, ‘Kosto din ibagbaga da. ");
INSERT INTO kne_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Awni et man-ibaaak si mamadto ay kaman sik-a ay kailian da ay Israelita. Ibagak to en sisya di ibaga na et ibaga na sin ipogaw amin ay ibilin ko. ");
INSERT INTO kne_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Mankali ay panakaawak ko et ibaga na din paibagak en sisya, isonga dosaek din adi mamati en sisya. ");
INSERT INTO kne_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Ngem mo wada di natangsit di nemnem na ay mangwani en pankalkaliak sisya ngem din ibagbaga na et adiak inpaibaga, masapol ay matey. Siya abe din man-ipadto ay mangwani en sisya di pankalkalian di odom ay diyos.’ ");
INSERT INTO kne_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Siguro ay salodsoden yo sin nemnem yo mo intoy iyat ay mangilasin mo inpakalin Diyos ono maga. ");
INSERT INTO kne_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Say pangammoan yo ay baken napon Diyos din ibagbagan di mangwani en mamadto mo adi temet-ewa din ipadto na. Din ipogaw ay sana et ipapangato nan awak na ay mangibagbagas napo sin nemnem na, isonga adi yon egyatan sisya ya din ibaga na.” ");
INSERT INTO kne_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","“Mo makdeng ay peslen Yahweh ay Diyos yo din man-ili sin daga ay idawat na en dakayo et enggay inoka yo din siyodad da ya beey da ya logian yo ay mantees di, ");
INSERT INTO kne_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","3","pankatloen yo din daga ay sana yan lokoden yo din kaaddawin di il-ili isdi. Asi kayo todingan di sag-eesa ay siyodad ay nalaka ay emeyan di ipogaw olay intoy kad-ana. Amagen yo di ta mo waday nakapese si gait na, kompormi di lomayawana ay pankamangan sin tolo ay siyodad ay sana et laton ay adi maan-ano. ");
INSERT INTO kne_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Din maibagbagas na et din nakapese si bakenan kaibaw ay adi na in-gagara. ");
INSERT INTO kne_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Mo kaspangarigan waday doway ipogaw ay emey sin kada ay mangaiw ya man-getgetad din esa, asi et makaan din wasay sin paek na ya pontaana din kadwa na yan matey, mabalin ay kompormi di panagtagana sin tolo ay siyodad ay sana et adi maan-ano. ");
INSERT INTO kne_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Mo owat es-esa di siyodad ay pankamangan, asi palalo ay addawi, adi pay edasan din mangibaes ay agin di natey et peslenas bonget na din ipogaw ay sana ay magay basol na. Tan din katet-ewa na et adi nan ginagara ay namse sin kadwa na tan bakenan inibaw. ");
INSERT INTO kne_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Siya na di gapo ay ibilin ko ay man-itoding kayo si tolo ay siyodad. ");
INSERT INTO kne_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","9","“Mo esten yo ay onodan amin ay ibilin ko ed wani ay agew ya laylayden yo si Yahweh ay Diyos yo dowan kayon ibasar din iyat yo ay manbiyag sin amin ay itdo na, paannawaena din sakop di daga yo ay kaman din insapata na sin ap-apo yo. Idawat na abe en dakayo amin din daga ay inkari na en daida. Mo matongpal di, masapol ay manpili kayo kasin si tolo ay siyodad ay maitapi sin siyodad ay pankamangan. ");
INSERT INTO kne_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","Say amagen yo na ta magay matey si bakenan basol sin daga ay idawat Diyos en dakayo ya adi kayon bomasol ay manpese. ");
INSERT INTO kne_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“Ngem mo kaspangarigan waday ipogaw ay man-ed sin kaliliget na et peslena, asi mankamang sin siyodad ay pankamangan, ");
INSERT INTO kne_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","ipadpap din papangolo sin ili na ta ipolang da sin ag-in di pinse na ay akin lebbeng ay mangibaes ta peslen da. ");
INSERT INTO kne_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Adi kayon seg-angan di kaman nidi, tan masapol ay daosan yo di makapeses magay basol na sin kad-an yo ay Israelita ta say mayat di kabibiyag yo.” ");
INSERT INTO kne_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“Adi kayon padendendenen din sigod ay gedeng di dagan di kailian yo sin daga ay idawat Diyos en dakayo.” ");
INSERT INTO kne_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“Adi omanay di es-esa ay tistigo ay mangipaneknek ay binmasol di esa ay ipogaw. Masapol di dowa ono tolo ay mangipaneknek. ");
INSERT INTO kne_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Mo waday mantistigo yan pabasolena di gait na si baken tet-ewa ta say makedngan si madagsen ay dosa, ");
INSERT INTO kne_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","masapol ay emey da ay dowa sin es-esa ay tinodingan Diyos ay pandaydayawan ta din papadi ya howis ay nadotokan di mangosig en daida. ");
INSERT INTO kne_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Masapol ay esten da ay mangosig sin kaso ay sana et mo mapaneknekan ay baken tet-ewa din pamabasol din esa sin ib-a na ay Israelita, ");
INSERT INTO kne_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","din nangipabasol di mangibaklay sin dosa ay dosan koman di pinabasol na. Say amagen yo na ta somaldeng di kaman nina ay basol. ");
INSERT INTO kne_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Tan mo dengngen din kaipoipogaw din napasamak, emegyat da ay mangamag abe si kaman nina ay basol. ");
INSERT INTO kne_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Adi kayon maseg-angan sin kaman dana ay pasamak. Sinay di iyat yo: biyag di bayad di biyag, mata si mata, bab-a si bab-a, takkay si takkay ya siki si siki.” ");
INSERT INTO kne_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“Mo waday nakeddengan ay matey ya maibay-at si posti gapo sin basol na, ");
INSERT INTO kne_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","adi yo baybay-an din bangkay na sin posti ay maninsinlabi. Masapol ay maiponpon sin agew ay sana met laeng, tan mo waday maibay-at si posti, say kailaan di nanosaan Diyos en sisya. Ikaot yo ta say adi komadodogis din daga ay ipatawid Diyos en dakayo.” ");
INSERT INTO kne_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“Mo wada di lalaki ay mangasawa, asi et mabaybayag yan laydena ay isian si asawa na gapo ta waday naammoana ay makagapo si panigaana, masapol ay idawtana si kasolatan ay pangisianana, asi nan pakaanen sin beey na. ");
INSERT INTO kne_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","Mo kaspangarigan makiasawa kasin din babai ");
INSERT INTO kne_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ya asi et aben sigaan kasin din nangasawa et idawtana si kasolatan ay pangisianana ya pakaanena sin beey na ono kaspangarigan matey din maikadwa ay asawa na, ");
INSERT INTO kne_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","adi mabalin ay taolien din damo ay asawa na tan maibilang ay kinmadodogis din babai ay sana. Palalo ay lawa sin pangilan Diyos mo taoliena din asawa na. Adi kayon man-amag si kaman nina ay basol sin daga ay idawat Yahweh ay Diyos yo.” ");
INSERT INTO kne_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“Adim bosbosalan di baka ay mangigatgatin ay mangirik si pagey ta waday iyat na ay mangan. ");
INSERT INTO kne_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“Mo waday sin-iyogtan ay lallalaki ay mantees esay beey ya matey din waday asawa na yan magay anak da, adi mabalin ay makiasawa din nalasang si odom mo baken din agin asawa na. Lebbeng na ay asawaen din kabsat di natey din asawan agi na. ");
INSERT INTO kne_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Maibilang din damo ay anak da ay anak din natey ta say mantoltoloy din katontonan di poli na sin Israelita.” ");
INSERT INTO kne_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","Intoloy Moses, “Mo enggay inoka yon daga ay idawat Yahweh ay Diyos yo et dakayo di man-ilis di, ");
INSERT INTO kne_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","esa en mangipeey sin damo ay apit na si baskit ta iey na sin es-esa ay lugar ay napili ay pandayawan. ");
INSERT INTO kne_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Emey kayo sin padi ay mansilsilbi sin doy ay timpo yan kanan yo en sisya, ‘Ed wani ay agew, ibagak sin sangoanan Yahweh ay Diyos tako ay wadaak isnan daga ay insapata na sin ap-apo ay idawat nan datako.’ ");
INSERT INTO kne_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","“Alaen din padi din baskit ta ipeey na sin sangoanan di altar ay pan-idatdatonan en Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Mo makdeng di, kanan yo sin sangoanan Diyos, ‘Si apok et esay Arameo ay owat lomikeliked ay intakina din pamilya na ay inmey ed Egipto. At-atik di bilang da ay inmey isdi ngem inmad-ado da et nanbalin da si madamdamag ya napigsa ay nasyon. ");
INSERT INTO kne_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Pinalpaligat din taga-Egipto si dakami dowan dan panbalinen dakami si bag-en ay pan-oblaen si nankadadagsen. ");
INSERT INTO kne_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Pag kami et man-adawag ay mankedaw si badang en sik-a ay Diyos ay dinaydayaw di ap-apo. Dinngem din adawag mi et inilam din ligat mi ya kaseseg-ang ay kasasaad mi. ");
INSERT INTO kne_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Insalakam si dakami sin naibabag-enan mi ed Egipto babaen sin nakaskasdaaw ay pigsam ya panakabalin mo ya sin ad-ado ay kaeegyat ya nakaskasdaaw ay inam-amag mo. ");
INSERT INTO kne_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","In-alim dakami isna et indawat mo nan maymayat ay daga ay magabay di mola. ");
INSERT INTO kne_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Isonga nay ed wani yan in-alik nan damo ay apit ko sin daga ay indawat mo.’ Mo makdeng pay di yan ipayag yo din baskit sin sangoanan Yahweh ay Diyos yo ta mandayaw kayo en sisya. ");
INSERT INTO kne_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Asi kayo manragragsak begew sin am-in ay maymayat ay indawat Diyos en dakayo ya sin pamilya yo. Ilaen yo abe ta makiragsak din Levita ya mangili ay makiili en dakayo.” ");
INSERT INTO kne_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","Kanan Moses, “Ed wani ay agew, bilbilinen Diyos dakayo ta tongpalen yo din amin ay linteg na, isonga ipasnek yo ya imongsan yo di amin ay nemnem yo ay manongpal. ");
INSERT INTO kne_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Ed wani ay agew, binigbig yo ay sisya di Diyos yo yan inkari yo ay onodan yos sisya ya patien yo amin ay linteg ya bilbilina. ");
INSERT INTO kne_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Ed wani ay agew, inbilang Diyos dakayo ay nabanol ay ipogaw na tan say inkari na, dalo et mo tongpalen yo amin din linteg na. ");
INSERT INTO kne_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Panbalinenas dakayo ay napigpigsa mo din odom ay nasyon ay pinarsua na ta say madaydayaw kayo ya panbalinenas dakayo ay nasantoan ay ipogaw na, tan siya din inkari na.” ");
INSERT INTO kne_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“Mo adi kayon ipapasnek ay manongpal sin bilin Diyos ay naisolat sin libro ay nay ya adi kayon banolen din peteg ay nangato ya kaeegyat ay ngadan Yahweh ay Diyos yo, ");
INSERT INTO kne_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","pawadaena en dakayo ya sin ipoli yo di adi kaagasan ay sakit ya kaeegyat ay mapasamak ya pisti ay adi kaipasaldeng. ");
INSERT INTO kne_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","Ipalak-am na kasin en dakayo din nilak-am yo ed Egipto ay kaeegyat ay sakit et adi kayo polos maagasan. ");
INSERT INTO kne_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","Ipawada na abe amin ay kalasin di sakit ya pisti ya kaeegyat ay mapasamak ay adi naibaga isnan libro ay naisolatan di linteg Diyos enggana ay matey kayo amin. ");
INSERT INTO kne_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","Olay mo omad-ado kayo ay kaman din talaw ed daya, at-atik pay dedan di mabay-an en dakayo, tan adi yon tinongtongpal si Yahweh ay Diyos yo. ");
INSERT INTO kne_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","Mo intoy ison di ragsak Diyos ay nangipasiged sin biyag yo ya nangipaad-ado en dakayo, siya met laeng sin iyat na ay manosa en dakayo ta maabos kayo. Awni et mapilitan kayo ay komaan sin daga ay okaen yo. ");
INSERT INTO kne_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","Pansisianen Diyos dakayo ay iwaras sin amin ay ili sin amin ay solin di lobong et mansilbi kayo si sinan didiyos ay kaiw ya bato di amag na ay adi yo dinaydayaw ed idi enggana abe sin ap-apo yo.” ");
INSERT INTO kne_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","Danay din inbilin Diyos en Moses ay itolag na sin Israelita sin kawada da ed Moab ay maitapi sin intolag Diyos en daida ed dontog ay Sinai. ");
INSERT INTO kne_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","Pinaayagan Moses amin din Israelita, pag nan kanan en daida, “Inila yo ay mismo din inyat Diyos sin ari ed Egipto ya sin oopisyal na ya sin amin ay ipogaw na. ");
INSERT INTO kne_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","Inila yo din kaeegyat ay dosa ya nakaskasdaaw ay inam-amag Diyos pati din nakaskasdaaw ay sinyal ay inpappaila na. ");
INSERT INTO kne_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","Ngem enggana pay laeng ed wani yan adi indawat Diyos en dakayo di nemnem ay makaawat, mata ay makaila ya inga ay makadnge. ");
INSERT INTO kne_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","Sin opatapolo ay tawen ay nangipangpangoan Diyos en dakayo sin lugar ay magay omili, adi nabisbisngit din bado ya sapatos yo. ");
INSERT INTO kne_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","Magay tinapay si kinkinan yo ya arak ay inin-inom yo, ngem indawat Yahweh amin ay masapol yo ta say ammoen yo ay sisya di Diyos yo. ");
INSERT INTO kne_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","“Idi dinmateng tako sin lugar ay nay, ginobat da Sihon ay ari ed Hesbon ya si Og ay ari ed Basan si datako, ngem inabak takos daida. ");
INSERT INTO kne_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","Ina tako din daga da et nanbibingayan din tribun da Ruben en Gad ya kagodwan di tribun Manasses. ");
INSERT INTO kne_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","“Isonga ipapasnek yo ay manongpal sin amin ay linteg ay intolag Diyos en dakayo ta say kosto di pantongpalan di amin ay amagen yo. ");
INSERT INTO kne_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","Ed wani ay agew, nay wada kayo amin sin sangoanan Yahweh ay Diyos yo. Wada amin ay papangolo ya oopisyal, lallalaki, ");
INSERT INTO kne_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","babbabai ya anan-ak. Wada abe da din mangili ay makitetee en dakayo ay pangakkaiwen yo ya panaksakdoen yo. ");
INSERT INTO kne_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","Wada kayo amin isna ta isapata yo ay awaten ya tongpalen yo din intolag Diyos en dakayo ");
INSERT INTO kne_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","ta manipod ed wani yan ibilang nas dakayo ay ipogaw na ya sisya di dayawen yo ay Diyos ay kaman din inkari na sin ap-apo yo ay da Abraham, Isaac ya si Jacob. ");
INSERT INTO kne_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","Nan itolag Diyos ay ibagak en dakayo ya din isapata yo ay tongpalen yo et baken datako anggoy ");
INSERT INTO kne_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","ay pinmipika isnan sangoanan Diyos di makilak-am mo adi abe din ipoli tako ay maisoksokat en datako sin tapin di agew.” ");
INSERT INTO kne_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Kanan Moses ay nangitoloy, “Nanpiliek dakayo si layden yo mo sino di pilien yo sin bindisyon ono dosa, et wada ay nemnemen yo na mo lak-amen yo am-in da nan bindisyon ya dosa sin tapin di agew ya pansisianen Diyos dakayo et maiwaras kayo si odom ay il-ili. ");
INSERT INTO kne_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","Ngem mo dakayo ya din ipoli yo yan manbabawi kayo ta sagongen yos Diyos yan imongsan yo din amin ay nemnem yo ay manongpal sin bilbilina ay ibagak en dakayo ed wani, ");
INSERT INTO kne_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","seg-angan Diyos si dakayo. Ayaganas dakayo sin lugar ay naiwarasan yo et sinopenas dakayo ta pasigedena din biyag yo. ");
INSERT INTO kne_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Olay mo nansisian kayo ay inmey sin kaaddawian ay partin di lobong et sinopen ya pataolien pay dedan Yahweh ay Diyos yo si dakayo ");
INSERT INTO kne_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ta okaen yo kasin din daga ay nanbebeeyan di ap-apo yo ed idi. Awni et panbalinen Diyos dakayo ay mas ad-ado ya mas maymayat din biyag yo mo din ap-apo yo. ");
INSERT INTO kne_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Idawat Yahweh ay Diyos yo di manakaawat ya managtongpal ay nemnem ta imongsan yo din amin ay nemnem yo ay manglaylayad en sisya ta matagotago kayo. ");
INSERT INTO kne_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Et mo siya di, ipabanes en Yahweh ay Diyos yo din dosa sin kaibaw yo ay mangililiget ya mamalpaligat en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Patien yo kasin sisya ya onodan yo din amin ay bilbilina ay ibagak ed wani ay agew en dakayo. ");
INSERT INTO kne_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Aped na ay bindisyonan Yahweh ay Diyos yo din amin ay amagen yo et paad-adoena din ganak yo, animal ya apit yo, tan malaydan kasin sisya ay mangipasiged sin biyag yo ay kaman din inyat na sin ap-apo yo ed idi. ");
INSERT INTO kne_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Ngem masapol ay onodan yos sisya ya tongpalen yo amin din linteg na ay naisolat sin libro ay nay. Masapol abe ay imongsan yo din amin ay nemnem yo ay mamati ya mandayaw en sisya. ");
INSERT INTO kne_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“Din ibilin ko en dakayo ed wani et baken naligat ay maawatan ya tongpalen. ");
INSERT INTO kne_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Baken met wada ed langit ta kanan yo en, ‘Sino ngin di somakyab ed kayang ay en manga ta iali nas na ta say dengngen ya tongpalen tako?’ ");
INSERT INTO kne_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Baken aben wada sin labes di baybay ta kanan yo en, ‘Sino ngin di mangagadang sin baybay ay en manga ta way iyat tako ay mannge ya tongpalen tako?’ ");
INSERT INTO kne_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Aga met, tan wada isnan mismo ay kad-an yo et ammo yo ya mabalin ay ibaga yo, isonga kabaelan yo ay tongpalen. ");
INSERT INTO kne_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Nemnemen yo, tan nay panpiliek dakayo ed wani ay agew. Sino di pilien yo? Ay layden yo ay matagotago ya komagam-is di biyag ono madosa ya matey? ");
INSERT INTO kne_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Mo tongpalen yo din bilbilin Diyos ay ibagak ed wani ay agew en dakayo ta ipaila yo din layad yo en sisya sin panongtongpalan yo sin laydena ya bilbilina, matagotago ya omad-ado kayo yan bindisyonanas dakayo sin ili ay emeyan yo ay okaen. ");
INSERT INTO kne_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Ngem mo sigaan yo ay dengngen ya tongpalen ta masangaw kayo ay mandayaw si didiyosen, ");
INSERT INTO kne_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","ibagbagak ed wani ay agew ay madosa kayo et adi kayon bomayag ay mantee sin nay dandani ay okaen yo ay daga sin bas-il di ginawang ay Jordan. ");
INSERT INTO kne_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Nawaya kayo ay manpili si layden yo mo din biyag ono pese, ya mo bindisyon ono dosa. Ayagak din langit ya daga ay manistigo ay nanpiliek dakayo mo pilien yo din biyag ono pese, bindisyon ono dosa. Say pilien yo koma din biyag ta matagotago kayo ya din ipoli yon to. ");
INSERT INTO kne_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Ipaila yo din layad yo en Yahweh ay Diyos yo, patien yos sisya ya ipapasnek yo ay mansilbi en sisya ay adi mankeykeyat ta say matagotago kayo ya din ipoli yo sin daga ay insapatan Diyos ay idawat na sin ap-apo yo ay da Abraham, Isaac ya si Jacob.” ");
INSERT INTO kne_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Intoloy Moses ay nankali sin sangoanan di Israelita yan kanana, ");
INSERT INTO kne_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Sin-gasot ya dowanpo di tawen ko ed wani. Enggay nakayak et adiak kabaelan ay mangipango en dakayo ya dowan et inbagbagan Diyos ay adiak agadangen din ginawang ay Jordan. ");
INSERT INTO kne_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Si Yahweh ay Diyos yo di mangipango en dakayo et peslena din man-ili sin daga ay datngan yo ta okaen yo din daga da. Si Josue di mangipango en dakayo tan say inbagan Diyos. ");
INSERT INTO kne_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Awni et dosaen Diyos da sana ay ipogaw ay kaman din inyat na ay namse en da Sihon en Og ay arin di Amorreo et dinadael na din ili da. ");
INSERT INTO kne_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Idawtan Diyos dakayo si pigsa ay mangabak en daida, ngem masapol ay amagen yo en daida din am-in ay inbilin ko. ");
INSERT INTO kne_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Papigsaen yo din nemnem yo ya tomoled kayo. Adi kayon emeg-egyat en daida tan si Yahweh ay Diyos yo di mangoykoyog en dakayo, et adi na polos taytaynan ono pandokdokogan dakayo.” ");
INSERT INTO kne_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Idi makdeng pay di, inpaayag Moses si Josue, pag nan kanan en sisya sin sangoanan di amin ay Israelita, “Papigsaem din nemnem mo ya adi kan emeg-egyat, tan sik-a di mangipango en da nay ay ipogaw ta en da okaen din daga ay insapatan Diyos sin ap-apo da ay idawat na en daida. ");
INSERT INTO kne_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Laton tan si Diyos ay mismo di mangipango ya mangoyog en dakayo. Adi kayon emegyat ono madismaya, tan adi na polos taytaynan ono pandokdokogan dakayo.” ");
INSERT INTO kne_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Insolat Moses amin din linteg Diyos si esa ay libro et inset na ta maga di malabsan. ");
INSERT INTO kne_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","Idi nakdeng ay insolat na, binilina din papadi ay Levita ay makaammo ay manggen sin Baol di Tolagan Diyos et kanana en daida, ");
INSERT INTO kne_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Alaen yo din libro ay nay ay naisolatan di linteg ta itakdo yo sin Baol di Tolagan Yahweh ay Diyos yo ta mantee isdi ay say tistigo mo dokogan yos Diyos.” ");
INSERT INTO kne_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Indaniw Moses din intiro ay kanta ay nay sin sangoanan di Israelita. ");
INSERT INTO kne_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“Dengngen yo ay langit ya daga din nay enak ibaga. ");
INSERT INTO kne_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Din pamagbagak et sapay koma ta kaman odan ya dono ay manibsibog sin daga. Kaman koman odan ay manibsibog sin naganos ay mola ya mamasbasa sin logam ay kagabgabay na. ");
INSERT INTO kne_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Idaydayaw ko din ogalin Diyos ay wada ed daya, dakayo ay ipogaw na et dad-aten yo din kinangato na. ");
INSERT INTO kne_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Si Diyos di komakaman ay pankamangan yo, am-in ay amagena et nalinteg ya kosto. Matalek ay adi manbalbaliw sisya, maga polos di ipaksaw na. ");
INSERT INTO kne_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Ngem baken kayon matalek ay ipogaw na, enggay adi kayo maibilang ay anak na, tan managbasol ya makaetek kayo, et say kaibabainan yo. ");
INSERT INTO kne_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Ay siya baw na di isobalit yo en Yahweh ay Diyos yo? Naong-ong kayo ya magay nemnem yo! Sisya di Ama yo ya namarsua en dakayo, sisya di nangipaad-ado en dakayo! ");
INSERT INTO kne_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Nemnemen yo ed bayag, damagen yo sin am-a yo mo sino di naamag. ");
INSERT INTO kne_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Idi nansisianen Diyos ay Kangatoan din kaipoipogaw isnan daga, indawtana din amin ay nasyon si daga da, inkeddeng na di pantean di esa ya esa ta say din naitoding ay dagan di Israelita et omanay sin kaad-ado da. ");
INSERT INTO kne_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Ngem pinili na din polin Jacob ay ipogaw na. ");
INSERT INTO kne_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Sin lugar ay magay omili et dintenganas daida, sin kadardaratan ay kad-an di dagem ay napigsa. Sinalaknibana ya inayowanana si daida, inbilang nas daida ay nabanol en sisya. ");
INSERT INTO kne_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Kaman din iyat di agila ay mangitdo sin anak na sin damo ay tomayawan da, nakasagana din payak na ay manikpaw mo ilaena ay mag-as da. ");
INSERT INTO kne_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Ang-anggoy Diyos ay nangipango sin ipogaw na, magay odom ay diyos si nanolong en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Sin kadondontogan et nanturayenas daida, pinakpakana sin amin ay maapit sin payew ya nom-a. Ad-ado di anig sin kabatbatoan ay in-ina da. Olay isdi yan gomabay din olivo ay nannan-aan das mantika. ");
INSERT INTO kne_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Napnek da sin gatas di baka ya kalding da, ya sin karnin di mankalalames ay animal da. Pag din kamayatan ay bakakew di inani da ya kam-isan ay arak din danom di obas da. ");
INSERT INTO kne_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","Binmaknang din ipogaw Diyos et kinmedse da, nanpennek da ay nangan et tinmaba da. Dinokogan da si Diyos ay namarsua en daida, sinigaan da din manakabalin ay mangisalakan en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Nan-imon si Diyos tan waday odom ay daydayawen da, binmonget begew sin sinan didiyos da. ");
INSERT INTO kne_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Baken si Diyos mo adi et anito di indatdatonan da, baro ay sinan didiyos ay adi dinaydayaw di ap-apo da. ");
INSERT INTO kne_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Dinokogan das Diyos ay nangidawat si biyag da, din komakaman ay pankamangan da. ");
INSERT INTO kne_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Binmonget si Diyos ay nangila sin inamag da, et nilaksig nas daida ay an-ak na. ");
INSERT INTO kne_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Kanana, ‘Adiak badangan daida ta ilaek mo intoy pantongpalan da, tan adi da matalek ya pag lawa di am-amagen da. ");
INSERT INTO kne_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Nan-imonak sin sinan didiyos ay daydayawen da, binmongetak begew sin didiyosen da ay baken tet-ewa. Pan-aposek ya pabongetek daida begew si kaipoipogaw ay laslasoyen da ay mo maipanggep en sak-en et magay ammo da. ");
INSERT INTO kne_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Awni et bomidang ay kaman apoy din bonget ko, amin ay wadas nan daga et mapooan to. Olay abe din kad-an di natey ed Sheol ay kanan da ya din naisaadan di dontog isnan daga. ");
INSERT INTO kne_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","Ibonton ko en daida di paspasamak ay lawlawa, amin ay panak et maiturong en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Awni et matey das betil, podot ya sakit ay magay agas na. Ibaak di mankaaangat ay animal ya nagitaan ay eweg ay mangat en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Ad-adoy matey si gobat ay maiwalang sin kalsada. Olay sin beey da, matey das palalo ay egyat da. Matey din babbaro ya babalasang, momoyang ya naobanan. ");
INSERT INTO kne_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","Peslek koma amin si daida ta malinglingan da sin labaw di daga. ");
INSERT INTO kne_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Ngem adiak layden ay manlastog din kaibaw da. Into et mo kanan da en inabak da din ipogaw ko ay baken sak-en di nanosa,’ kinwanin Diyos ay namarsua. ");
INSERT INTO kne_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","Ngem adi maawatan din Israelita, tan maga polos di nemnem da. ");
INSERT INTO kne_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Adi da ammo di gapo ay naabak da, adi da maawatan din napasamak en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Apay nga inabak di es-esa di sinlibo? Apay nga inabak di dodowa di sinpo ay libo? Tan binaybay-an Yahweh ay Diyos da, din komakaman ay pankamangan da et dinokoganas daida. ");
INSERT INTO kne_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Ammon din kalaban da ay baken manakabalin din diyos da ay kaman din Diyos di Israelita. ");
INSERT INTO kne_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Palalo ay lawlawa di nemnem din kalaban da ay kaman din ipogaw ed Sodoma ya Gomorra. Kaman dan obas ay manpait ya makasabidong di lames na, ");
INSERT INTO kne_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","kaman arak ay mapos gitan di eweg di kaiarigan da. ");
INSERT INTO kne_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","Adi linglingan Diyos din inamag di kalaban da, sedsed-ena din kosto ay timpo ay panosaana en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Kinwani na, ‘Sak-en di man-ibaes ya manobalit en daida. Domteng di timpo ay maabak da, asag-en di timpo ay madosa da.’ ");
INSERT INTO kne_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Ikalintegan Diyos din ipogaw na mo ilaena ay enggay nakapsot da. Seg-angana din mansilsilbi en sisya mo ilaena ay magay kabaelan da ya kaman magay nabay-an, bag-en ya baken bag-en, en daida. ");
INSERT INTO kne_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Asi na damagen en daida, ‘Et into ngin din didiyosen ay nantalkan yo? ");
INSERT INTO kne_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","Indatdatonan yos daida si arak ya tabtaba. May kod adi, mankedaw kayo si badang da. Ilaen tako mo siya ay omali da. ");
INSERT INTO kne_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Magay odom si tet-ewa ay Diyos mo adi et sak-en. Amagek di laydek, mo enak peslen ono tagoen. Mabalin ko ay pansakiten asiak agasan met laeng. Magay makatopap mo waday laydek ay dosaen. ");
INSERT INTO kne_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Ikayang ko din takkay ko ay mansapata. Isapatak sin awak ko ay matmatago si eng-enggana, ");
INSERT INTO kne_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ay mo palidek din somilsilap ay kampilan ko, dadlonak ilaen ta nalinteg di iyat ko ay mangokom ya manobalit sin lomiliget ay kaibaw ko. ");
INSERT INTO kne_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","Malamos din panak si dada da, olay din nasogatan ya balod et matey da. Ad-adoy peslek sin kampilan ko, magay mabay-an sin papangolon di kalaban ko.’ ");
INSERT INTO kne_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","Dakayo ay kaipoipogaw isnan daga, makiragsak kayo sin ipogaw na, tan si Diyos et dosaena din namse sin baa na. Sisya di manobalit sin amin ay kalabana, ngem pakawanena din basol di ipogaw na.” ");
INSERT INTO kne_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Indaniw Moses ya si Josue ay anak Nun din kanta ay nay ta dengngen din Israelita. ");
INSERT INTO kne_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Idi nakdeng ay inbagan Moses sin Israelita din bilbilin Diyos ay nay, kanana en daida, ");
INSERT INTO kne_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","“Ilaen yo ta dadlon yon nemnemen ya tongpalen amin da nan bilbilin ay inbagak en dakayo ed wani ay agew. Itdo yo sin an-ak yo ta ipapasnek da ay tongpalen din bilbilin Diyos. ");
INSERT INTO kne_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Danay ay nait-itdo et baken owat kali ay magay olog na mo adi et say poon di biyag yo. Tongpalen yo dana ta omando di biyag yo sin daga ay okaen yo mo agadangen yo din ginawang ay Jordan.” ");
INSERT INTO kne_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Sin doy met laeng ay agew, kanan Diyos en Moses, ");
INSERT INTO kne_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Emey ka ed Abarim ay kadondontogan sin ili ed Moab ay wada sin demang di Jerico. Mantikid ka sin dontog ay Nebo ta tamangem din ili ay Canaan ay siya din idawat ko sin Israelita. ");
INSERT INTO kne_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","Matey ka sin isdi ay dontog ay kaman din napasamak en Aaron ay agim ed dontog ay Hor, ");
INSERT INTO kne_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","tan nan-isoen yo ay adi kayon inpaila di talek yo en sak-en sin sangoanan di Israelita. Inbabain yos sak-en sin sangoanan di kaipoipogaw idi wada kayo sin kad-an di danom ed Meriba ay asag-en ed Kades ay sakop di lugar ay magay omili ay makwani en Zin. ");
INSERT INTO kne_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Tamangem anggoy ngem adi ka makadateng sin lugar ay sana ay idawat ko sin Israelita.” ");
INSERT INTO kne_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Idi dandani ay matey si Moses ay nankalkalian Diyos, da nay di inbaga na ay bindisyon sin Israelita: ");
INSERT INTO kne_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","“Napo si Diyos ed Sinai ay dontog na, kaman din bomalaan di agew sin patag na ed Edom din nanpailaana, manipod sin dontog ay Paran, siney-angana din ipogaw na. Adi kabilang ay anghel di kakoyog na, iin-genana di manbidbidang ay apoy sin kannawana. ");
INSERT INTO kne_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Laylayden Diyos ya silibana din ipogaw na, isonga manyakog-ong tako sin sangoanana ya tongpalen tako din bilbilina. ");
INSERT INTO kne_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Tongpalen tako din linteg ay inpolang Moses en datako tan say kapatgan ay sanikwan di ili tako. ");
INSERT INTO kne_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Idi nasinop din tribun di Israelita ya din papangolo da, si Diyos di nanbalin ay ari da.” ");
INSERT INTO kne_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","Mo maipanggep sin tribun Ruben, kinwanin Moses na: “Adi koman malitaw din polin Ruben olay mo at-atik da.” ");
INSERT INTO kne_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Mo maipanggep sin polin Juda, siya na di kinwani na: “Sik-a ay Yahweh, dengngem kod din adawag da, itapim koma si daida sin odom ay tribu ay iib-a da. Sik-a koma di mangipabikas en daida, badangam koma ta abaken dan kaibaw da.” ");
INSERT INTO kne_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Mo maipanggep sin tribun Levi, siya na abe di kinwani na: “Ipaammom ay Diyos din laydem babaen sin Urim ya Tummim, ipaammom sin Levita tan daida nan matalek ay baam. Pinadas mos daida ed Massa et pinaneknekam ay matalek da sin kad-an di danom ed Meriba. ");
INSERT INTO kne_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Nanlaslasinen da din pantongpalan da en sik-a mo din layad da sin ama ya ina da, aag-i ya an-ak da. Matalek da sin intolag mo et tinongpal da din bilbilin mo. ");
INSERT INTO kne_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Itdoan da din ipogaw mo ay mantongpal sin linteg mo, daida di mangipoo sin sangoanam si insinso ya mangidaton si animal ay mapooan sin altar mo. ");
INSERT INTO kne_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","Sik-a ay Diyos, bindisyonam kod ta pomigsa din tribu da. Sapay koma ta mapnek ka sin amin ay am-amagen da. Dosaem koma din kalaban da ya adim ipalobos ay kasin dan pomigsa.” ");
INSERT INTO kne_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Maipanggep sin tribun Benjamin yan kinwani na: “Sinay din tribu ay laylayden Diyos ya ay-ayowanana. Silsilibanas daida si kasinsin-agew na ya makitee en daida.” ");
INSERT INTO kne_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Mo maipanggep abe sin tribun Jose, kinwani na: “Bindisyonan koman Diyos si odan din daga da ya obbog ay mapo sin oneg di daga. ");
INSERT INTO kne_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","Mabindisyonan da koma si kamayatan ay lames di kaiw da ay maomaom sin poon da ya maapit sin timpo da. ");
INSERT INTO kne_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","Mapno koma din kadaanan ay dontog da sin kamayatan ay molmola. ");
INSERT INTO kne_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Amin koma ay siged di mawada sin ili da, bindisyon ay mapmapo sin kinasiged Diyos ed daya ay sin manbidbidang ay kitkittoy ay kaiw di nanteana. Maidawat koma dana ay bindisyon sin polin Jose tan sisya di nangipangolo en daida ay siag-i. ");
INSERT INTO kne_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Din pigsan Jose et kaman pigsan di bomaro ay baka, kaman waday sakngod na ay kaman sakngod di atap ay baka. Din piga ay libo ay polin Manasses ya kalibolibo ay polin Efraim ay an-ak na et maiarig da sin kaeegyat ay sakngod ay sana. Daida di idanggol na sin kalabana enggana ay maidenden da sin benget di daga.” ");
INSERT INTO kne_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Mo maipanggep sin tribun da Zebulun en Issakar, kinwani na: “Sapay koma ta somiged di biyag da, sin am-in ay panbibiyahian da. Et olay mo mantetee da sin ili da, sapay koma ta bomaknang da. ");
INSERT INTO kne_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Awisen da din odom ay ipogaw sin dontog da et idaton das di din kosto ay daton da. Sin baybay ya darat sin igid na di kapkapoan di panbaknangan da.” ");
INSERT INTO kne_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Mo maipanggep abe sin tribun Gad, kinwani na: “Madaydayaw si Diyos ay nangipaannawa sin ili da, kaman layon si Gad ay manseseed sisya ta bisngibisngitena din takkay ono toktok di depapena. ");
INSERT INTO kne_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Pinili da ay okaen din kasigedan ay partin di daga, kaman bingay di pangolo di naidawat en daida, tan din linteg Diyos et tinongpal da sin nasinopan di papangolon di Israelita.” ");
INSERT INTO kne_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Sinay abe di kanana maipanggep sin tribun Dan: “Kaman bomaro ay layon din tribun Dan ay pomadtok ay mapo ed Basan.” ");
INSERT INTO kne_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Mo maipanggep sin tribun Naftali, siya na abe di kanana: “Begew sin seg-ang Diyos en daida, aped na ay mabindisyonan da. Enggana sin abagatan et sakopen da manipod sin lebeng ay Galilea.” ");
INSERT INTO kne_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Mo maipanggep pay sin polin Aser, kinwani na: “Ad-ado di bindisyon da mo din odom ay Israelita. Daida koma di laylayden di aag-i da, ya omad-ado koma di olivo sin daga da. ");
INSERT INTO kne_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Masalakniban koma si landok ya bronsi ay pasbol din ili da ta maga di pandandanagan da enggana ay mapospos di biyag da. ");
INSERT INTO kne_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","Dakayo am-in ay ipogaw na, magay makaiso sin Diyos yo, agadangena ed daya ta ena badangan dakayo. Maila din kinangato na tan maikoyog sin liboo. ");
INSERT INTO kne_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Si Diyos ay magay logiana di kanayon ay pankamangan yo. Kanayon ay nakasagana din takkay na ay manalaknib en dakayo. Din kaibaw yo ay datngan yo et inab-abo na, inbilina ay peslen yo amin daida. ");
INSERT INTO kne_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Isonga dakayo ay polin Jacob et natalna di biyag yo, ad-ado di makan ya arak sin kad-an yo, masibsibogan si odan ay mapod daya din daga yo, et maga di pandandanagan yo. ");
INSERT INTO kne_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Din kalaban yo, awni et manpakpakaasi da et dakayo di mangituray en daida.” ");
INSERT INTO kne_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Makdeng pay ay bindisyonan Moses din Israelita, nantikid sin dontog ay Nebo et dinmateng sin toktok di dontog ay Pisga sin naibandas belaan di agew ed Jerico. Isdi ay inpailan Diyos en sisya din intiro ay ili manipod sin sakop di Gilead enggana sin amyanan ay maidawat sin polin Dan, ");
INSERT INTO kne_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","din amin ay sakopen di polin Naftali ya din sakop di polin da Efraim en Manasses. Inila da abe amin din sakopen di polin Juda enggana sin baybay ay Mediterranean, ");
INSERT INTO kne_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","pati din naibandas abagatan ya din tanap manipod ed Jerico ay kaad-adoan di kaiw ay palma enggana ed Zoar. ");
INSERT INTO kne_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Pag kanan Diyos en Moses, “Dooy din daga ay insapatak en da Abraham, Isaac ya si Jacob ay idawat ko sin ap-o da. Ipailak en sik-a ngem adiak ipalobos ay makadateng kas di.” ");
INSERT INTO kne_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Natey si Moses ay baan Diyos ed Moab ay kaman din inbagan Diyos ay mapasamak. ");
INSERT INTO kne_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Inponpon Diyos sisya sin tanap ed Moab sin demang na ed Betpeor, ngem magay makaammo sin kosto ay naiponponana enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Mantawen si Moses si sin-gasot ya dowanpo sin nateyana, ngem adi kinmapkapsot din mata na ya adi naknaksayan din pigsa na. ");
INSERT INTO kne_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Nanladingit din Israelita si tolonpo ay agew sin tanap ed Moab. ");
INSERT INTO kne_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Mo si Josue ay anak Nun et naidawtan si palalo ay laing ay napon Diyos sin nangapayan Moses ay nangdotok en sisya. Pinatin din Israelita sisya et tinongpal da din bilbilin Diyos en daida ay inpaibaga na en Moses. ");
INSERT INTO kne_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Magay odom ay mamadto ed Israel si makaison Moses ay nakikali en Diyos si sangosango. ");
INSERT INTO kne_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Magay odom ay nankalkalian Diyos si nakaamag sin nakaskasdaaw ay inpaamag Diyos en sisya sin sangoanan di ari ed Egipto ya amin ay oopisyal ya ipogaw na. ");
INSERT INTO kne_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Magay odom ay nakaamag sin nakaskasdaaw ya kaeegyat ay inam-amag na sin sangoanan di am-in ay Israelita. ");
INSERT INTO kne_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Idi natey si Moses, kinalin Diyos si Josue ay kabadang Moses ya anak aben Nun. ");
INSERT INTO kne_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Kanan Diyos en sisya: “Enggay natey din baak ay si Moses, isonga mansagana ka ta ipangom din am-in ay Israelita. Agadangen yo san ginawang ay Jordan et emey kayo sin daga ay idawat ko en dakayo. ");
INSERT INTO kne_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Idawat ko san intiro ay daga ay gatinan di siki yo ay kaman din inkarik en Moses ed idi. ");
INSERT INTO kne_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Din beddeng di daga ay idawat ko et manlogi sin lugar ay magay omili ed abagatan enggana sin kadondontogan ed Lebanon sin amyanan; manlogi abe sin kad-an di dakdake ay ginawang ay Eufrates sin bomanda sin belaan di agew, maitapi abe din am-in ay ilin di Heteo, enggana sin baybay ay Mediterranean ed kadiposan di agew. ");
INSERT INTO kne_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Maga di makaabak en sik-a si gobat engganas kateyam. Kankanayon ay wadaak en sik-a ay kaman din kawadak en Moses. Adiak polos taytaynan sik-a. ");
INSERT INTO kne_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","“Isonga papigsaem din nemnem mo ya tomoled ka, tan sik-a di mangipango sin kaipoipogaw ay nay ta okaen yo san daga ay inkarik ed bayag sin ap-apo yo. ");
INSERT INTO kne_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ngem masapol ay dadlon kan papigsaen din nemnem mo ya adi kan emeg-egyat. Masapol abe ay adi ka masangsangaw mo adi et dadlon mon patien din am-in ay inbilin Moses ay baak en dakayo. Mo say iyat mo di, siged di pantongpalam olay intoy em-emeyam. ");
INSERT INTO kne_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Kanayon abe ay ibasbasam din libro ay naisolatan dana ay linteg. Ilaem ta inagew ya linabi ay ad-adalem ya nemnemnemem ta say estem ay onodan din am-in ay linaona. Mo say amagem na, sigurado ay somiged di biyag mo ya mayat di pantongpalan di am-in ay amagem. ");
INSERT INTO kne_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Isonga adim linglinglingan kanak, din inbagak en sik-a. Masapol ay papigsaem din nemnem mo ya tomoled ka. Adi ka aben emeg-egyat ya madisdismaya, tan sak-en si Yahweh ay Diyos mo et kankanayon ay kadkadwaek sik-a olay mo intoy em-emeyam.” ");
INSERT INTO kne_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Idi siya di, kanan Josue ay nangibilin sin papangolo, ");
INSERT INTO kne_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Manliked kayo sin am-in ay kampon di gagait yo ta ibaga yo ay mansagana das omanay ay baon da, tan sin maikatlo ay agew, manbalasat tako sin ginawang ay Jordan ta en tako okaen din daga ay inkarin Diyos en datako.” ");
INSERT INTO kne_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Sin nankakampoan di Israelita ed Acacia, inbaan Josue di dowa ay lalaki ta en da siimen din daga ed Canaan, namnamed din siyodad di Jerico. Idi dinmateng sidi din dowa ay ispay, en da nan-iyan sin beey di esa ay babai ay manngadan si Rahab ay mangiab-abang si awak na. ");
INSERT INTO kne_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Ngem inammoan baw din ari ed Jerico ay waday dinmateng ay Israelita sin siya di ay labi ay en mansiim sin ili da. ");
INSERT INTO kne_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Isonga nan-ibaa si en nakikali en Rahab. Kanan da, “Ispay kano din dowa ay lalaki ay inmali isnan beey mo. Ipabelam ta depapen mis daida.” ");
INSERT INTO kne_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","“Aw, tet-ewa ay waday lallalaki ay inmali sina, ngem adiak ammo mo intoy napoan da. Enggay met ay kinmaan da sin oras ay nadiposan di agew sin daan pay laeng main-eb din segpan di siyodad. Adiak kayman ammo di inmeyan da. Ngem mo dalasen yo ay mangonod en daida, siguro edasan yos daida sin danan.” Say kanan Rahab di, ngem di katet-ewa na, wada da sin toktok di beey ay ginagab-onana si tobon di magey ay ibilbilag na. ");
INSERT INTO kne_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Idi nakabela din baan di ari sin siyodad, kasin dan in-eb din segpan, dowan aben dalasen din baan di ari ay en mangonod sin ispay enggana ay dinmateng da sin pan-agadangan sin ginawang ay Jordan. ");
INSERT INTO kne_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Daan pay laeng maseyep din dowa ay ispay idi nantaoli si Rahab sin toktok di beey ay kad-an da. ");
INSERT INTO kne_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","Kanana en daida, “Ammok ay idawat Diyos en dakayo ay Israelita din daga ay kad-an mi. Peteg di egyat mi am-in ay man-ilis na en dakayo. ");
INSERT INTO kne_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Tan nadamag mi ay pinamgaan Diyos din Baybay ay Mandalangdang sin sangoanan yo idi tinaynan yo ed Egipto. Dinamag mi abe ay pinse yo din dowa ay arin di Amorreo ay da Sihon en Og sin belaan di agew di Jordan. ");
INSERT INTO kne_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Isonga peteg kayman di egyat mi am-in en dakayo idi dinnge mi danay ay damag. Nakaan di toled mi, tan si Yahweh ay Diyos yo et say tet-ewa ay Diyos ed langit ya isnan daga. ");
INSERT INTO kne_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Gapo ta tinolongak dakayo ed wani, kedawek abe en dakayo ta isapata yo sin ngadan Yahweh ay seg-angan yo din pamilyak. Ipaila yo aben sak-en di sinyal ");
INSERT INTO kne_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ay ilisi yo da amak en inak, din am-in ay aag-ik ya din pamilya da ta adi kami matey.” ");
INSERT INTO kne_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Kanan din ispay ay nanongbat, “Olay dosaen Diyos si dakami mo waday mapasamak en dakayo. Basta adim ibagbaga si olay sino din am-amagen mi, matalek kami ay manongpal sin kindaw mo et mayat di iyat mi en dakayo mo domteng din timpo ay idawat Diyos din daga ay nay en dakami.” ");
INSERT INTO kne_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Din beey Rahab et naisaad sin nakayang ay binatog da ay alad di siyodad, isonga nan-ioy-oy si tali sin tawa ta pandanan din ispay ay lomayaw. ");
INSERT INTO kne_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Idi daan da pay laeng komaan, kanan Rahab en daida, “En kayo sin kadondontogan et mantabon kayos di si tolo ay agew ta say adi edasan din inbaan di ari si dakayo. Awni ta makataoli da, asi kayo aben somaa.” ");
INSERT INTO kne_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Kanan da ay nanongbat, “Tongpalen mi din inbagam ay isapata mi ");
INSERT INTO kne_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","dalo et mo amagem dana: mo omali kami ay mangobat en dakayo, ioy-oy mo kasin din nay manbalanga ay tali ay say pan-alos-osan mi ed wani ay lomayaw. Sinopem abe da amam en inam, din aag-im ya din pamilya da sin nay beey mo. ");
INSERT INTO kne_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Mo wadan to di bomala en dakayo sin beey ay nay, basol na mo peslen das sisya, baken min basol. Ngem mo wada di mamse en dakayo sin oneg di beey ay nay, dakami di makabasol. ");
INSERT INTO kne_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Mo pay ta ibagam si odom din am-amagen mi, mawaswas din insapata mi.” ");
INSERT INTO kne_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Inaw Rahab din inbaga da yan binadanganas daida ay lomayaw. Sin dinmatngan di timpo, pag na kasin ioy-oy din manbalanga ay tali sin tawa. ");
INSERT INTO kne_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Inmey din dowa ay ispay sin kadondontogan et nantabon das di. Mo pay abe din inbaan di ari et en da inan-anap daida sin am-in ay lugar enggana sin maikatlo ay agew, ngem adi dan dintengan. Isonga pag da et mantaoli ed Jerico. ");
INSERT INTO kne_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Nanballalong din dowa ay ispay et nan-agadang da sin ginawang. En da inpadamag en Josue di am-in ay napaspasamak en daida. ");
INSERT INTO kne_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Kanan da, “Sigurado ay idawat Diyos di pigsa tako ay mangabak sin intiro ay daga. Di katet-ewa na et peteg di egyat di am-in ay ipogaw sidi ya nakaan di toled da ay makigobat en datako.” ");
INSERT INTO kne_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Sin kabigatana, nasapa si Josue ya din am-in ay Israelita ay binmangon et tinaynan da din nankampoan da ed Acacia. En da nankampo sin sag-en di Jordan ta panpan-edan da sin timpo ay pan-agadangan da. ");
INSERT INTO kne_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Sin maikatlo ay agew, nanliked din papangolo sin kampo. ");
INSERT INTO kne_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Kanan da sin ipogaw, “Mo ilaen yo din papadi ay mamabatawil sin Baol di Tolagan Yahweh ay Diyos tako, manlobwat kayo ay dagos ta onoden yos daida. ");
INSERT INTO kne_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Daida di mangipango sin danan, tan damdamo yo pay laeng sina. Ngem ilaen yo pay ta adi kayo omas-asag-en sin Baol di Tolagan. Addawian yo si pasal di esay kilometro.” ");
INSERT INTO kne_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Kanan aben Josue sin ipogaw, “Isagana yo di awak yo ta say nadalos kayo sin pangilan Diyos. Tan si bigat, waday nakaskasdaaw ay amagen Diyos para en datako.” ");
INSERT INTO kne_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Binilina abe din papadi ay namabatawil sin Baol di Tolagan ta ion-ona da, et natongpal am-in ay inbaga na. ");
INSERT INTO kne_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","Timpon di pinag-aani idi napasamak am-in dana. Dakdake din danom sin ginawang et malmalbeng pay din benget na. Idi siya di, tinaynan din ipogaw din nankampoan da ta man-agadang da. Namangpango din papadi ay namabatawil sin Baol di Tolagan. Idi inpisok din papadi din siki da sin danom, ");
INSERT INTO kne_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","pag et kasaldeng ay man-ayos din danom sin kad-an di ili ay makwani en Adam ay addawi di kad-ana ed naongdo sin sag-en di Zaretan. Nabonton din danom sidi ay kaman nakayang ay dingding. Isonga namaga di danom ay man-ayos ay emey sin makwani en Natey ay Baybay, et nakabalasat din Israelita sin asag-en ed Jerico. ");
INSERT INTO kne_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Idi madama ay manbalbalasat din ipogaw ay manmandan sin nanamgaan ay lota, inpipika aben din papadi ay namabatawil si Baol di Tolagan sin nanamgaan ay lota sin gawan di Jordan enggana ay nakabalasat da am-in. ");
INSERT INTO kne_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Idi nakabalasat am-in ay Israelita sin Jordan, kanan Diyos en Josue, ");
INSERT INTO kne_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Mandotok kayo si sinpo ya dowa ay lalaki ay mangialagey sin esa ya esa ay tribun di Israelita, ");
INSERT INTO kne_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","et bilinen yos daida ta man-a da si sag-eesa ay bato sin gawan di ginawang ay pinmipikaan din papadi et iey da sin pankampoan yo si labi.” ");
INSERT INTO kne_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Idi siya di, dinotokan da Josue di sinpo ya dowa ay lalaki, asi na pinaayagan ");
INSERT INTO kne_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","et kanana en daida, “Emey kayo sin kad-an di papadi ay namabatawil sin Baol di Tolagan Yahweh ay Diyos tako et en kayo mantilid si sag-eesa ay bato ay alaen yo sin ginawang para sin tribu ay ialageyan yo. ");
INSERT INTO kne_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Din batbato ay sana et say mangipanpanemnem sin ipogaw maipanggep sin nakaskasdaaw ay inamag Diyos sina. Et mo damagen din ganak yo sin tapin di agew mo sinoy silbin din bato ay nay, ");
INSERT INTO kne_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","dad-aten yo en daida din inyat Diyos ay nangipasaldeng sin danom ed Jordan ay man-ayos idi inbalasat tako din Baol di Tolagan Diyos et kanan yo en din bato ay nay di kanayon ay mangipanpanemnem en datako ay Israelita sin inam-amag Diyos sina.” ");
INSERT INTO kne_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Tinongpal din lallalaki din inbagan Josue et inamag da am-in din inbilin Diyos. Nan-a da si sinpo ya dowa ay bato sin gawan di ginawang, sag-eesa para sin tribun di Israelita, et en da inpayag sin lugar ay pankampoan da. ");
INSERT INTO kne_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Idi siya di, inbagan Diyos en Josue ");
INSERT INTO kne_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","ay bilinena din papadi ay namabatawil sin Baol di Tolagan ta komaan da sin ginawang. ");
INSERT INTO kne_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Siya tet-ewa di inyat Josue, ");
INSERT INTO kne_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","et idi kosto ay nakabalasat din papadi sin ginawang, intoloy kasin din danom ay man-ayos et nanlepyas sin benget na ay kaman din sigod ay inyaat na. ");
INSERT INTO kne_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Sin pitsa 10 di damo ay bowan, idi nanbalasat din Israelita ed Jordan, pag da en mankampo ed Gilgal ay bomanda sin belaan di agew ed Jerico. ");
INSERT INTO kne_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Isdi din nanoodan da Josue sin sinpo ya dowa ay bato ay ina da ed Jordan. ");
INSERT INTO kne_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Kanan Josue sin Israelita, “Mo damagen din ganak yo sin tapin di agew mo sinoy silbin din bato ay nay, ");
INSERT INTO kne_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","dad-aten yo en daida din inyat Diyos ay nangipasaldeng sin danom ed Jordan ay man-ayos, et nanbalasat din Israelita sin nanamgaan ay lota. ");
INSERT INTO kne_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Si Yahweh ay Diyos tako ay mismo di nangamag sina ay kaman din inyat na ed idi ay pinamgaana din Baybay ay Mandalangdang ta say makabalasat kami. ");
INSERT INTO kne_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Begew sina, ammoan am-in di ipogaw isnan daga di dakdake ay panakabalin Diyos, et kankanayon abe ay idaydayaw yos sisya.” ");
INSERT INTO kne_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Pag kanan Diyos en Josue, “Man-a kayo si bato ay moling ta amagen yo ay gipan ta kogiten yo am-in ay lalaki ay Israelita.” ");
INSERT INTO kne_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Tinongpal ngarud Josue din inbilin Diyos et kinogit da am-in ay lalaki sin lugar ay makwani en Dontog ay Pankogitan. ");
INSERT INTO kne_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Inamag da na tan olay mo nakogit am-in ay lalaki ay nakibala ed Egipto, magay nakogit sin lallalaki ay naianak sin opatapolo ay tawen ay nandad-anan da sin lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Asi et kanan Diyos en Josue, “Ed wani ay agew, enggay kinaan ko di poon di panglaslasoyan da en dakayo ay din nakabag-enan yo ed Egipto.” Siya di din begew ay nangadanan din lugar ay doy si Gilgal enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Sin nankakampoan di Israelita ed Gilgal, sin tanap ay naisasag-en ed Jerico, sinilibraran da din fiesta ay makwani en Nalabas sin masdem di maikasinpo ya opat ay agew di bowan. ");
INSERT INTO kne_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Sin kabigatana, en da nan-ani sin kapaypayewan ay wadas di. Di odom ay inani da et nilagitan da. Di odom pay et in-oto das tinapay ay magay labadura na. Siya na di nangon-ona ay nanganan da si makan ay naapit ed Canaan. ");
INSERT INTO kne_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Manlogi sin agew ay sana, din apit da ed Canaan di kinkinan da, tan enggay sinmaldeng din manna ay mapmapo ed daya. ");
INSERT INTO kne_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Idi wada pay laeng da Josue sin sag-en di Jerico, bigla et ay inila na di esa ay lalaki ay pinmipika sin sangoanana ay nananggen si kampilan. Inmasag-en si Josue et kanana, “Ay esa ka sin soldado mi, ono esa ka ay kaibaw mi?” ");
INSERT INTO kne_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","“Aga, sak-en di pangolon di sosoldadon Diyos,” kanan din lalaki ay sana. Kadokmog ay nanyakog-ong si Josue sin lota ay nangdayaw en sisya. “Esaak ay baam, apo. Nasasaganaak ay manongpal sin bilin mo,” kanan Josue. ");
INSERT INTO kne_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Kanana en Josue, “Kaanem san sandal mo, tan nasantoan ay lugar nan kad-am.” Et pinatin Josue din inbaga na. ");
INSERT INTO kne_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Iin-eb da din segpan di Jerico, dowan da aben binabantayan ta say adi makasgep din Israelita. Olay din omili sidi et magay makasgep ono makabela en daida. ");
INSERT INTO kne_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Kanan Diyos en Josue, “Pangabakek dakayo mo gobaten yo nan Jerico et pasokoen yo din ari ya din natoled ay sosoldado na. ");
INSERT INTO kne_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Di iyat yo, sik-a ya din sosoldadom et likeden yo san siyodad si mamingsan si esa ay agew. Say iyat yo na si enem ay agew. ");
INSERT INTO kne_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Wada di pito ay padi ay mamanggen si tanggoyob ay mangon-ona mo din Baol di Tolagan. Sin maikapito ay agew, mananggoyob din pito ay padi ay sana dowan yon liklikeden san siyodad si mamin pito. ");
INSERT INTO kne_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Pag mananggoyob din papadi si mabayag di bongog na. Mo dengngen yo di, manbogaw kayo am-in si napigsa, et pag makosokos din nakayang ay batog ay alad di siyodad. Asi kayo et kadoritso ay senggep sin siyodad.” ");
INSERT INTO kne_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Idi siya di, inayagan Josue din papadi et binilinas daida ay kanana, “Pito en dakayo di manggen si tanggoyob et dakayo di mangon-ona isnan linya. Omonod en dakayo din papadi ay mamabatawil sin Baol di Tolagan.” ");
INSERT INTO kne_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Asi na aben bilinen din sosoldado na ay mangwani, “Ilogi yo ay mangliked sin siyodad. Din odom en dakayo et manpowisto kayo sin sangoanan din papadi ta man-gowardiya kayo sidi.” ");
INSERT INTO kne_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","9","Pinati da din inbilin Josue. Nangon-ona din sosoldado sin linya, naisned en daida din papadi ay mamoypoyot sin tanggoyob da. Omon-onod abe din papadi ay namabatawil sin Baol di Tolagan ya naod-odi din sosoldado ay mamanbantay sin likodan. Sin panliklikedan da, adi somalsaldeng din ayoweng di tanggoyob. ");
INSERT INTO kne_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ngem inbilin Josue sin sosoldado na ay maga polos di mankalkali en daida enggana ay ibaga na. ");
INSERT INTO kne_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Namingsan ay inliked da din Baol di Tolagan sin siyodad, asi da pay mantaoli sin kampo da. ");
INSERT INTO kne_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Sin kabigatana, nasapa si Josue ay binmangon et inolnos na kasin din grupo ay sana ay en mangliked sin siyodad. Idi siya di, tinilid din papadi din Baol di Tolagan ");
INSERT INTO kne_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","et liniked da kasin din siyodad ay kaman din inyat da sin damo: nangon-ona din sosoldado ay gowardiya sin sangoanan, maisned en daida din papadi ay manangtanggoyob, omon-onod abe din papadi ay namabatawil sin Baol di Tolagan, et naodi din sosoldado ay gowardiya sin likodan. Adi polos sinmalsaldeng din ayoweng di tanggoyob sin panliklikedan da. ");
INSERT INTO kne_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Liniked da din siyodad si namingsan sin nay maikadwa ay agew, asi da mantaoli sin kampo da. Say inam-amag da na enggana sin maikan-em ay agew. ");
INSERT INTO kne_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Sin maikapito ay agew nasapa da am-in ay binmangon et liniked da din siyodad ay kaman met laeng sin damo. Ngem sin doy ay agew anggoy di nanglikedan da si namin pito. ");
INSERT INTO kne_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Idi nakdeng ay liniked da din siyodad si namin pito, nansagana din papadi ay mananggoyob. Dowan abe bilinen Josue din ipogaw ay mangwani: “Manbogaw kayo, tan indawat Diyos en datako din siyodad ay nay!” ");
INSERT INTO kne_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Asi et itoloy Josue ay mangwani, “Masapol ay dadaelen yo din siyodad ya peslen yo am-in ay matmatago ay wadas di ta kaman daton para en Diyos. Ngem adi yo pay pespeslen si Rahab ya din papartido na, tan intabona iman din ispay tako. ");
INSERT INTO kne_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Maga polos di al-alaen yo sin am-in ay inbagak ay dadaelen yo; tan mo say iyat yo di, dakdake ay ligat di mapasamak sin kampo tako. ");
INSERT INTO kne_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ilasin yo abe am-in ay palata ya balitok ya din naamag si bronsi ya landok para en Diyos. Maidolin am-in danay sin pan-idoldolinan sin gameng na.” ");
INSERT INTO kne_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Idi nakdeng ay inbilin Josue dana, nananggoyob din papadi. Idi dinngen di ipogaw din ayoweng din tanggoyob, inpigsa da ay nanbogaw, et pag makosokos din alad di siyodad. Nanagtag din sosoldadon di Israelita ay sinenggep sin siyodad et inabak da. ");
INSERT INTO kne_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Pinse da sin kampilan da am-in ay ipogaw sin siyodad, lalaki ya babai, moyang ya naket-eng. Pinse da abe din am-in ay animal: baka, karnero, ya dangki. ");
INSERT INTO kne_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Idi siya di, kanan Josue sin dowa ay ispay, “Emey kayo sin beey din babai ay namadang en dakayo et ibela yos sisya ya din pamilya na ta tongpalen yo din insapata yo ay amagen yo.” ");
INSERT INTO kne_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Inmey da tet-ewa et inbela da si Rahab, da ama na en ina na, ya siya abe din aag-i na ya odom ay wada sin beey na. In-ey da am-in daida sin sag-en di kampon di Israelita ta say adi da maan-ano. ");
INSERT INTO kne_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Asi et pinooan din sosoldadon di Israelita din siyodad enggana ay dinmap-o di am-in ay wadas di, ngem naipowira din balitok ya pilak ya din naamag si bronsi ya landok, tan en da indolin sin pan-idoldolinan sin gameng Diyos. ");
INSERT INTO kne_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ngem insalakan pay Josue si Rahab ya din am-in ay aag-i na, tan intabona iman din ispay ay inbaa na ed Jerico. (Et nakiili da Rahab ed Israel enggana ed wani.) ");
INSERT INTO kne_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Idi nakdeng ay nadadael din siyodad, kanan Josue, “Dosaen Diyos di olay sino ay mamadpadas ay mangibangon kasin sin alad ya eneb di siyodad ay nay: Mo isaad na din fondasyona, matey din besag na. Mo amagena abe din eneb na, matey din anongos na.” ");
INSERT INTO kne_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Naipaila tet-ewa di kawadan Diyos en Josue, et nandindinamag din kinangato na sin intiro ay ili. ");
INSERT INTO kne_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Palalo din bonget Diyos sin Israelita, tan wada en daida di nanglabsing sin bilina ay adi da manman-a si okaen da sin alikamen ay naikeddeng ay madadael ono mailasin para en Diyos. Si Akan ay anak Carmi ya apon Zabdi sin polin Zera ay napo sin tribun Juda et linabsing na din bilin Diyos ay sana. ");
INSERT INTO kne_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Adi ammon Josue din naamag ay sana idi nan-ibaa si sosoldado na ay napo ed Jerico ta en da siimen din siyodad di Ai, esa ay ili ay wada sin belaan di agew mo ed Betel ay asag-en ed Bet-aven. Tinongpal din naibaa din bilin Josue, ");
INSERT INTO kne_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","et idi nantaoli da, kanan da en sisya, “Adi masapol ay emey tako am-in ay en mangobat isnan siyodad di Ai. Olay owat dowa ono tolo ay libo ay sosoldado et anggoy di ibaam tan kitkittoy ay ili.” ");
INSERT INTO kne_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Isonga emey ay tolo ay libo ay sosoldado anggoy di en nangobat, ngem naabak da et kapilitan ay nanagtag da. ");
INSERT INTO kne_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Inapayaw din sosoldadon di Ai daida manipod sin segpan di siyodad enggana sin panpan-aan si bato et pinse da di tolonpo ya enem ay sosoldadon di Israelita sin panbalballalongan da. Begew sin napasamak ay doy, nakaan di toled din Israelita ya peteg di egyat da. ");
INSERT INTO kne_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Idi siya di, sinmag-en da Josue ya din papangolon di Israelita sin Baol di Tolagan Diyos et binisngit da din bado da dowan dan pay-an din toktok da si dap-o ay mangipaila sin sakit di nemnem da, asi da manlokbob sin lota enggana sin masdem. ");
INSERT INTO kne_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Idi manlolokbob da, kanan Josue ay man-adawag, “Kangatoan ay Diyos, aye pay na si inyat mo en dakami. Ay tan in-alim baw dakami sina ta ipapsem dakami sin Amorreo? Agpos et baw mo pag min intetee sin bas-il di Jordan. ");
INSERT INTO kne_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Apo, adiak et ammo di maibagak ed wani ay naabakan mi isnan kagobat mi. ");
INSERT INTO kne_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Mo dengngen din taga-Canaan ya din odom ay man-ili sina ay naabak kami, awni et lomikob da et peslen da am-in dakami. Et mo say maiyat sa, adi pay kanan di ipogaw en adim baw kabaelan ay manalaknib sin ipogaw mo.” ");
INSERT INTO kne_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Asi et kanan Diyos en da Josue, “Ipikam. Pagaten yo ay manlolokbob sin lota? ");
INSERT INTO kne_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Ay adi yon ammo ay binmasol nan Israelita en sak-en? Linabsing da din inbilin ko ay adi kayo manman-a si okaen yo sin alikamen ay naikeddeng ay madadael ono mailasin para en sak-en. Wada din inakew da ay intatabon da sin kad-an di odom ay bonag da, yan insaot da. ");
INSERT INTO kne_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Say begew na ay adi kayo makaabak isnan kagobat yo. Kapilitan ay naabak da tan inkeddeng ko ay madosa da. Adiak aben badbadangan dakayo enggana ay dadaelen yo din alikamen ay inbagak en dakayo ay adi yo al-alaen. ");
INSERT INTO kne_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","En ka et ibaga sin ipogaw ta dalosan dan awak da ya mansagana da ay manpaila en sak-en si bigat, tan sak-en si Yahweh ay Diyos yo ay Israelita et kanak en daida, ‘Wada en dakayo di nangidodolin sin inbagak ay dadaelen yo. Adi kayo polos makaabak isnan kagobat yo enggana ay iwasit yo dasa.’ ");
INSERT INTO kne_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Isonga ibagam en daida ay si bigat sin agsapa, bomala am-in ay tribun di Israelita ta mapili mo sino di binmasol. Bomala abe din tonggal partido sin tribu ay mapili, din tonggal pamilya sin partido ay mapili, ya din saes-a ay mimbron di pamilya. ");
INSERT INTO kne_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Din ipogaw ay mapili ya madtengan ay mangidodolin sin alikamen ay inbagak en dadaelen yo et peslen yos daida ay sinpamilya, asi yon pooan ay maitapi sin am-in ay bonag da, tan linabsing na din bilin ko et palalo ay inbabaina di am-in ay Israelita.” ");
INSERT INTO kne_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Sin kabigatana, nasapa si Josue ay nangipaayag sin am-in ay tribun di Israelita. Naiparang da sin sangoanan Diyos et napili din tribun Juda. ");
INSERT INTO kne_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Naiparang abe din am-in ay kapototan sin tribun Juda et napili si Zera. Naiparang abe din am-in ay pamilya sin kapototan Zera et napili san pamilyan Zabdi. ");
INSERT INTO kne_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Naiparang abe din pamilyan Zabdi et napili si Akan ay anak Carmi ya apon Zabdi. ");
INSERT INTO kne_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Kanan Josue, “Anak, dayawem si Yahweh ay Diyos tako ay Israelita et ipodnom di tet-ewa ay inamag mo. Din kosto di ibagam en sak-en, adim isassaot.” ");
INSERT INTO kne_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Kanan Akan, “Tet-ewa kayman ay nanbasolak en Yahweh ay Diyos tako. ");
INSERT INTO kne_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Sin tinopog mi ay gamgameng, wada di inilak ay mapmapteng ay nagayad ay bado ay napo ed Babilonia, dowa ay kilo ay palata, ya kagodwan di kilo ay balitok. Inaklongak danay isonga inak. Wada da ay inkakaot ko sin oneg di toldak ay naidadallem din palata.” ");
INSERT INTO kne_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Nanagtag din lallalaki ay inbaan Josue et inmey da sin kampon Akan. Dinteng da tet-ewa din inkakaot Akan, et naidadallem din palata sin naikaotan da. ");
INSERT INTO kne_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Inbela da sin tolda et in-ey da sin kad-an da Josue ya din am-in ay Israelita, asi da ipayag sin sangoanan Diyos. ");
INSERT INTO kne_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Idi siya di, in-ey Josue ya din am-in ay Israelita si Akan ya din am-in ay inakew na sin tanap ay makwani en Ligat. Intakin da din an-ak na, din baka, dangki ya karnero na, din tolda na ya am-in ay bonag na. ");
INSERT INTO kne_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Idi wada das di, kanan Josue, “Gapo ta pinaligat mos dakami, paligaten aben Diyos sik-a.” Pag et pigpigen din am-in ay ipogaw si Akan enggana ay natey. Pinigpig da abe din pamilya na, asi da pooan daida ay maitapi sin bonag da. ");
INSERT INTO kne_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Ginab-onan das daida sin ad-ado ay bato ay wada pay laeng sidi enggana ed wani. Isonga nginadanan da din lugar ay sana si Ligat et say ngadana enggana ed wani. Idi enggay natey si Akan, nakaan et din bonget Diyos. ");
INSERT INTO kne_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Asi et kasin kanan Diyos en Josue, “Adi ka emegyat ya madisdismaya. Ayagam et din am-in ay sosoldadom ta en yo kasin gobaten ed Ai. Awni et ipaabak ko en dakayo din ari ya din ipogaw na et okaen yo din siyodad ya din daga da. ");
INSERT INTO kne_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Kaman din inyat yo sin siyodad di Jerico ya din ari na di iyat yo sin siyodad di Ai ya din ari na. Ngem ed wani, mabalin yo ay alaen din alikamen ya animal para en dakayo. Isonga mansagana kayo ta en kayo mantabon sin likodan di siyodad asi kayo kabigla ay mangobat en daida sidi.” ");
INSERT INTO kne_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","En nansagana tet-ewa da Josue ta en da gobaten ed Ai. Di inyat na et pinili na di tolonpo ay libo sin kalalaingan ay sosoldado na et inbaa nas daida sin labi. ");
INSERT INTO kne_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Kanana ay namilin en daida, “En kayo mantabon sin baken onay addawi sin likodan di siyodad. Mansasagana kayos di ay makilaban. ");
INSERT INTO kne_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Sak-en pay ya din odom ay sosoldado, en mi sag-enen din siyodad, et mo omali din sosoldadon di Ai ay gomobat, managtag kami ay mantaoli ay kaman din inyat tako sin damo. ");
INSERT INTO kne_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Omapayaw da tan kanan da en itagtagtagan mis daida ay kaman sin damo enggana ay omaddawi da sin siyodad. ");
INSERT INTO kne_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Asi kayo aben kabela sin nantatabonan yo et gobaten yo san siyodad. Laton ay ipaabak Yahweh ay Diyos tako en dakayo. ");
INSERT INTO kne_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Et mo makdeng ay inabak yo, kapoo kayo ay dagos sin siyodad ay kaman din inbilin Diyos. Siya na din bilin ko en dakayo.” ");
INSERT INTO kne_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Idi siya di, inbaan Josue din tolonpo ay libo ay sosoldado, et en da nantabon sin bomanda sin diposan di agew ed Ai sin nan-gawaan di Ai ya Betel et nanseed das di. Si Josue pay, en naseyep sin kampo da. ");
INSERT INTO kne_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Sin kabigatana, nasapa si Josue ay binmangon et sininop na din sosoldado na et nanlobwat da ay emey ed Ai. Inpangon Josue ya din papangolon di Israelita daida, ");
INSERT INTO kne_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","et inmey da sin sag-en di segpan di siyodad. Nankampo da sin bomanda sin amyanan. Esa ay tanap di nan-gawaan da sin siyodad di Ai. ");
INSERT INTO kne_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Inbilin Josue ay en mantabon di lima ay libo sin sosoldado sin bomanda sin kadiposan di agew sin siyodad, sin nan-gawaan di Ai ya Betel. ");
INSERT INTO kne_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Naiolnos din sosoldado ay en makigobat. Din kaad-adoan en daida, nanpowisto da sin amyanan di siyodad et din odom, nanpowisto da abe sin bomanda sin kadiposan di agew sin siyodad. Ngem si Josue pay, en nantee sin tanap sin labi ay doy. ");
INSERT INTO kne_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Sin kabigatana, inilan din arin di Ai din sosoldadon Josue. Nan-aagag sisya ya din sosoldado na ay binmela et nanturong da sin tanap ay Jordan ta en da gobaten din sosoldadon di Israelita sin lugar met laeng ay nangobatan da sin damo. Ngem adi na ammo ay wada baw di nakasagana ay mangobat sin ili na ay mapo sin likodan di siyodad. ");
INSERT INTO kne_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Agin tatagtag si Josue ya din sosoldado na ay manturong sin kadardaratan. ");
INSERT INTO kne_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Idi siya di, naayagan amin ay lalaki sin siyodad ta en da makiapayaw sin sosoldadon di Israelita. Inonod das daida enggana ay inmaddawi da sin siyodad. ");
INSERT INTO kne_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Am-in ay lalaki ed Ai et en da nakiapayaw, isonga nataynan din siyodad ay nabobokatan din segpan ya maga di nabay-an ay mamantay. ");
INSERT INTO kne_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Asi et kanan Diyos en Josue, “Ikayang mo san gayang mo ta tedkena ed Ai, tan ipaabak ko din siyodad ay sana en dakayo.” Tinongpal Josue din inbagan Diyos. ");
INSERT INTO kne_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Idi inkayang na din gayang na, kabela din sosoldado ay nantatabon et nanagtag da ay inmey sin siyodad, et inabak da dowan dan pooan. ");
INSERT INTO kne_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","21","Idi manwingi din sosoldadon di Ai, inila da et din asok di mapoppooan ay ili da ay komaykayang ed daya. Inilan aben da Josue ya din sosoldado na din asok, et say nangammoan da ay enggay inabak din gagait da din siyodad ya enggay pinooan da. Isonga nantaoli da sin panagtagtagan da et ilogi da ay mamse sin kagobat da. Mo din sosoldadon di Ai, maga et di iyat da ay lomayaw, tan din Israelita ay ap-apayawen da et nantaoli da baw ay en mangobat en daida. ");
INSERT INTO kne_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Din Israelita ay en namoo sin siyodad et nanballalong da ay en naitapi sin gobatan. Siya di, linikob din dowa ay grupon di Israelita din sosoldadon di Ai. Maga di nakalayaw en daida tan natey da am-in, ");
INSERT INTO kne_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","powira din ari da. Dinpap da din ari et in-ey da en Josue. ");
INSERT INTO kne_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Pinsen din Israelita din am-in ay kagobat da sin kadardaratan ay en nangapayawan di sosoldadon di Ai en daida. Idi nakdeng di gobat sidi, nantaoli da ed Ai et pinse da abe am-in ay wadas di. ");
INSERT INTO kne_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","26","Intoltoloy Josue ay inkakayang din gayang na ay naituturong ed Ai, et adi na inbabbaba enggana ay natey am-in ay ipogaw ay wadas di. Emey ay sinpo ya dowa ay libo di bilang di lallalaki ya babbabai ay omili ed Ai ay natey sin agew ay sana. ");
INSERT INTO kne_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Inan din Israelita din aanimal ya am-in ay bonag sin siyodad ta say okaen da, tan say inbilin Diyos en Josue. ");
INSERT INTO kne_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Pinooan da Josue din siyodad di Ai et tinaynan da ay nabakas, et kaman nidi di iso na enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Mo din arin di Ai, pinse da et inbay-at Josue sin kaiw. Binaybay-an da din awak na sidi enggana ay masdem. Idi dandani ay madipos din agew, inbilin Josue ay ipababa da din awak na. Inamag da di et intep-a da sin lota sin segpan di siyodad. Asi da et tab-okan si dadakke ay bato et wada pay laeng ay nabobonton sidi enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Nadamag Adonizedek ay ari ed Jerusalem ay inabak ya dadlon binakas Josue ed Ai ya pinse na din ari da ay kaman din inyat na ed Jerico ya din ari da. Nadamag na abe ay nakikapya din taga-Gibeon sin Israelita et nakiili da en daida. ");
INSERT INTO kne_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Palalo di danag na tan dakdake ay ili ed Gibeon ay kaman din dadakke ay siyodad ay iturayan di aari. Dakdake pay mo ed Ai yan nankalalaing ay makigobat din amin ay lallalaki isdi. ");
INSERT INTO kne_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Gapo sidi, nanpatolong si Adonizedek en da Hoham ay ari ed Hebron, Piram ay ari ed Jarmut, Jafia ay ari ed Lakis ya Debir ay ari ed Eglon. ");
INSERT INTO kne_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Siya na di inpaibaga na: “Bomadang kayo kod ay mangobat sin taga-Gibeon, tan doy nakikapya da en Josue ya din Israelita.” ");
INSERT INTO kne_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Da nay ay lima ay arin di Amorreo ay aari ed Jerusalem, Hebron, Jarmut, Lakis ya Eglon yan nan-es-esa din sosoldado da et nantikid da ed Gibeon. Linikob da, pag dan gobaten. ");
INSERT INTO kne_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Idi siya di, pinakaammoan din lallalaki ed Gibeon si Josue sin kampo da ed Gilgal ay kanan da, “Adi ka koman baybay-an dakami ay mansilsilbi en dakayo. Kagosam kod ay en bomadang ya omisalakan tan nay manbabadang din aari sin il-ili sin kadondontogan ay mangobat en dakami.” ");
INSERT INTO kne_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Et nanlobwat da Josue ed Gilgal yan inkoyog na amin din sosoldado na pati din katoledan ay sosoldado. ");
INSERT INTO kne_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Kanan Diyos en sisya, “Adi ka emegyat tan pangabakek sik-a. Maga polos di makabael ay lomaban en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Manipod ed Gilgal, nanlablabis da Josue ay inmey ed Gibeon et nabiglaan din Amorreo. ");
INSERT INTO kne_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Inolaw Diyos daida sin nangilaan da sin sosoldadon di Israelita et ad-adoy pinsen da Josue en daida ed Gibeon. Inapayaw das daida enggana sin ballalongan ed Bet-horon. Intoltoloy da ay namse sin Amorreo enggana sin abagatan ed Azeka ya Makkeda. ");
INSERT INTO kne_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Idi ilaylayawan din Amorreo din Israelita sin ballalongan ed Bet-horon, inpaodan Diyos di dadakke ay dalalo en daida enggana ed Azeka et ad-ado di natey. Ad-ad-ado di pinsen di dalalo mo din pinsen di Israelita si kampilan. ");
INSERT INTO kne_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Sin agew ay doy ay namadangan Diyos sin Israelita ay mangabak sin Amorreo, nakikali si Josue en Diyos sin sangoanan di Israelita. Kanan Josue, “Sik-a ay agew, somaldeng ka sin patag nan Gibeon. Sik-a ay bowan, somaldeng ka sin patag di tanap ay Aijalon.” ");
INSERT INTO kne_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Sinmaldeng tet-ewa din agew ya bowan enggana ay inabak din Israelita din kalaban da. Naisolat dana sin Libron Jashar. Sinmaldeng din agew sin gawa nad daya et nataktak si dandani ay esay agew din kadiposana koma. ");
INSERT INTO kne_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Maga polos di kaman nidi ay pinatgan Diyos di kalin di esay ipogaw, olay ed idi ono manipod sin agew ay doy, tan makilablaban dedan si Diyos para sin Israelita. ");
INSERT INTO kne_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Makdeng pay di, nantaolis Josue ya din amin ay Israelita sin kampo da ed Gilgal. ");
INSERT INTO kne_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Idi nabayag, pinangabak Diyos din Israelita sin am-in ay kagobat da et indawtanas daida si talna. Si Josue pay, enggay nakay sin timpo ay sana, ");
INSERT INTO kne_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","isonga inpaayag na din mangialagey sin am-in ay Israelita: din nankakay di ili, papangolo, hohowis ya oopisyal. Pag nan kanan, “Nay enggay nakayak et dandani di timpok. ");
INSERT INTO kne_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Laydek ay ipanemnem en dakayo din am-in ay inamag Yahweh ay Diyos tako sin nanasyon begew en datako, tan inila tako ay mismo di inyat na ay nakigobat para en datako. ");
INSERT INTO kne_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Enggay inpatawid ko sin tribu yo din am-in ay dagan di nanasyon ay inabak tako ya daan pay maabak. Naibingay am-in en dakayo manlogi sin ginawang ay Jordan sin bandas belaan di agew enggana sin baybay ay Mediterranean sin diposan di agew. ");
INSERT INTO kne_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Awni et mismo ay si Yahweh ay Diyos yo di mangipakaan en daida sin domatngan yo et okaen yo din daga da ay kaman din inkari na. ");
INSERT INTO kne_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Isonga esten yo ay mangonod sin am-in ay linaon din libro ay naisolatan di linteg Moses. Adi kayo masangsangaw si olay at-atik. ");
INSERT INTO kne_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Adi kayo makikadkadwa sin nabay-an ay ipogaw ay makiili en dakayo. Ilaen yo abe ta adi kayo mankarkararag sin diyos da ono os-osalen din ngadan di diyos da ay mansapata. Adi kayo mandokmog ay mandayaw en daida, ");
INSERT INTO kne_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","mo adi et ipapasnek yo ay mantalek ya mansilbi en Diyos ay kaman san inyaat yo enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“Nemnemen yo ay pinakaan Diyos din dadakke ya napipigsa ay nasyon ay dinatngan yo, et enggana ed wani, maga di nakabael ay nangabak en dakayo. ");
INSERT INTO kne_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Olay es-esa en dakayo yan kabaelana ay ipalayaw di sinlibo, tan si Yahweh ay Diyos tako di makigobgobat para en dakayo ay kaman din inkari na. ");
INSERT INTO kne_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Isonga mo banolen yon biyag yo, ilaen yo ta ipapasnek yo ay manglaylayad en sisya. ");
INSERT INTO kne_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“Tan mo dokogan yo si Yahweh ay Diyos tako ya makikadwa kayo sin nabay-an ay man-ili isna ya makiasawa kayo en daida, ");
INSERT INTO kne_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","sigurado ay adi itoloy Diyos ay mangipakaan sin nanasyon ay datngan yo. Manbalin da ay kaman tagdey ono bito ay kaknaan yo. Maiarig da abe si mansakit ay soplit sin edeg yo ya pagat ay manbek sin mata yo enggana ay maga en dakayo di mabay-an isnan mayamayat ay daga ay indawat Yahweh ay Diyos tako. ");
INSERT INTO kne_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Ed wani, enggay dandani di timpok. Dakayo pay, dadlon ammon di esa ya esa ay indawat Diyos din am-in ay inkari na ay pansigdan yo. Tinongpal na am-in ay inkari na, magay olay esa ay adi nan tinongpal. ");
INSERT INTO kne_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","16","Ngem mo kas-ano di kinamatalek na ay nanongpal sin am-in ay kari na, siya met laeng di iyat na ay mangipatongpal sin inbaga na ay dosa. Tan mo labsingen yo din intolag nan dakayo et mandayaw ya mansilbi kayo si odom ay diyos, bomonget sisya yan dosaenas dakayo. Adi mabayag yan iwed en dakayo di mabay-an isnan mayamayat ay daga ay indawat na.” ");
INSERT INTO kne_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Idi siya di, inpasinop Josue din am-in ay tribun di Israelita ed Sekem. Inpaayag na abe din nankakay di ili, papangolo, hohowis ya oopisyal, et nasinop da am-in sin sangoanan Diyos. ");
INSERT INTO kne_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Kanan Josue sin amin ay ipogaw, “Siya na di ibagan Yahweh ay Diyos tako ay Israelita: ‘Ed nabaon, nan-ili din aap-o yo pati da Tera ay aman da Abraham en Nahor sin bas-il di ginawang ay Eufrates, yan nandaydayaw das odom ay diyos. ");
INSERT INTO kne_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Siya di, inayagak si Abraham ay apo yo sin daga ay sana, et inpangok sin intiro ay daga ed Canaan. Inpaad-adok abe din poli na babaen en Isaac ay anak na ay indawat ko en sisya.’ Siya din kinwanin Diyos. ");
INSERT INTO kne_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“Isonga ed wani, patgen ya egyatan yo koma si Diyos, dowan naimposoan ya napasnek di iyat yo ay mansilbi en sisya. Iwasit yo abe din sinan didiyos ay dinaydayaw di ap-apo yo ed Mesopotamia ya ed Egipto ta si Diyos et anggoy di pansilbian yo. ");
INSERT INTO kne_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ngem mo sigaan yo ay mansilbi en sisya, masapol ay pilien yo ed wani ay agew mo sino di pansilbian yo, mo din diyos ay dinaydayaw di aap-o yo ed Mesopotamia ono din daydayawen di Amorreo ay akin daga isnan kad-an yo ed wani. Mo sak-en pay ya din pamilyak, si Diyos di pansilbian mi.” ");
INSERT INTO kne_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Kanan din ipogaw ay sinombat, “Adi mi polos dokdokogan si Yahweh ta mansilbi kamis odom ay diyos, ");
INSERT INTO kne_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","tan si Yahweh ay Diyos tako di nangipango sin ap-apo tako ay komaan ed Egipto ay naibabag-enan da. Sisya di nangam-amag sin da dooy ay nakaskasdaaw ay inila tako. Sinilibanas datako sin am-in ay nandad-anan tako ya sin am-in ay ipogaw ay nilabsan tako. ");
INSERT INTO kne_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Inpakaana am-in din Amorreo ay man-ili sin daga ay nay ay dinatngan tako, isonga dakami abe et mansilbi kami en Yahweh, tan sisya di Diyos tako.” ");
INSERT INTO kne_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","20","Ngem kanan Josue sin ipogaw, “Adi yon kabaelan ay mansilbi en Diyos, tan nasantoan sisya et iparit na ay waday ikadkadwa yon sisya ay daydayawen. Isonga mo taynan yos sisya ta mansilbi kayos diyos di odom ay nanasyon, adi nan pakawanen din basbasol yo. Olay mo siged di inyat na en dakayo ed idi, kontraena ya dosaenas dakayo enggana ay mamaga kayo.” ");
INSERT INTO kne_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","“Aga, mansilbi kamin Diyos,” kinwani da ay sinombat. ");
INSERT INTO kne_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Kanan Josue en daida, “Dakayo met laeng di manistigo ay pinili yo ay mansilbi en Diyos.” “Aw, dakami di tistigo,” kinwani da. ");
INSERT INTO kne_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","“Iwasit yo ngarud din sinan didiyos di odom ay nasyon ay wadan dakayo yan ikari yo ay magay dayawen yo mo adi si Yahweh ay Diyos tako ay Israelita,” kanan Josue ay nangibilin. ");
INSERT INTO kne_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Pag kanan din ipogaw ay nanongbat, “Mansilbi kami en Yahweh ay Diyos tako et tongpalen mi din bilbilina.” ");
INSERT INTO kne_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Sin siya di ay agew, inamag Josue di tolagan para sin kaipoipogaw yan initdo na din linlinteg ya bilbilin ay onodan da. ");
INSERT INTO kne_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Insolat na dana sin libro ay naisolatan di linteg Diyos. Pag man-a si dakdake ay bato et tinood na sin poon di dakdake ay kaiw sin kad-an din nasantoan ay lugar isdi ed Sekem. ");
INSERT INTO kne_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Pag nan kanan sin kaipoipogaw, “Ilan yo nan bato ay nay ay say manbalin ay tistigo tako, tan dinnge na am-in din inbagan Diyos en datako. Isonga say mangipanemnem en dakayo mo kontraen yos Diyos.” ");
INSERT INTO kne_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Idi nakdeng ay inbagan Josue di, inpasaa na din ipogaw et esa en inmey sin bingay na ay daga. ");
INSERT INTO kne_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Idi siya di, natey si Josue ay anak Nun ay baan Diyos. Sin-gasot ya sinpo di tawena sin nateyana. ");
INSERT INTO kne_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Inponpon da sin tawid na ay daga ed Timnatsera sin kadondontogan ed Efraim sin bomandas amyanan di dontog ay Gaas. ");
INSERT INTO kne_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Nansilsilbi din Israelita en Diyos sin kamatagon Josue. Olay sin nakdeng ay nateyana, intoltoloy da pay ay nansilsilbi en sisya idi wada pay laeng din papangolo da ay mismo ay nakaila sin amin ay nakaskasdaaw ay inam-amag Diyos para en daida. ");
INSERT INTO kne_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Idi inpasaan Josue din nasinop ay Israelita, esa en inmey ay mangoka sin bingay na ay daga. ");
INSERT INTO kne_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Nansilsilbi din Israelita en Diyos sin kamatagon Josue. Olay sin nakdeng ay nateyana, intoltoloy da pay ay nansilsilbi en sisya idi wada pay laeng din papangolo da ay mismo ay nakaila sin amin ay nakaskasdaaw ay inam-amag Diyos para en daida. ");
INSERT INTO kne_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Din nay baan Diyos ay si Josue ay anak Nun yan natey idi mantawen si sin-gasot ya sinpo. ");
INSERT INTO kne_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Naiponpon sin bingay na ay daga ed Timnatsera sin kadondontogan ed Efraim ay wada sin amyanan di dontog ay Gaas. ");
INSERT INTO kne_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Natey abe din dededsana ay doy et din naiskat en daida ay poli da yan adi da am-ammo si Diyos ya din inam-amag na para en daida ay Israelita. ");
INSERT INTO kne_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Pag da et mandayaw en da Baal et inamag da din lawa sin pangilan Diyos. ");
INSERT INTO kne_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","13","Dinokogan das Yahweh ay dinaydayaw di ap-apo da ya nangipango en daida ay komaan ed Egipto, et inpabonget das sisya sin nanaydayawan dan Baal ya en Astarte ay din sinan didiyos ay daydayawen di inil-ili sin nanniliked. ");
INSERT INTO kne_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Gapo si bonget Diyos sin Israelita, inpalobos na ay omali di manpos si molmola ya gamgameng da. Inpalobos na abe ay abaken din nanniliked ay kalaban das daida et enggay adi binaelan din Israelita ay manalaknib sin ili da. ");
INSERT INTO kne_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Kanayon ay kontraen Diyos daida sin amin ay pakigobatan da ay kaman din inbaga na ay amagena, et palalo ay naligatan da. ");
INSERT INTO kne_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Makdeng pay di, insaad Diyos di papangolo ay nangisalakan en daida sin manpos si gamgameng da. ");
INSERT INTO kne_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Ngem adi da inkaskaso da nay ay papangolo mo adi et kaman dan nakibabbabai, tan tinaynan das Yahweh ay Diyos da ta mandayaw das odom ay diyos. Baken dan kaman din ap-apo da ay nangon-onod sin bilin Diyos, tan sinkaattikan yan nasangaw da et adi da tinongtongpal. ");
INSERT INTO kne_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Binadbadangan Diyos amin din nanbalinena ay pangolo da et insalsalakanas daida sin kalaban da enggana ay sibibiyag din papangolo ay sana, tan sineg-angan Diyos din ipogaw na sin nan-ad-adawagan da begew sin napalpaligatan da. ");
INSERT INTO kne_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Ngem mo matey din pangolo da, taolien da din sigod ay am-amagen da yan mas pay nakarkaro din amagen da mo din am-a da sin panaydayawan ya pansilsilbian da sin sinan didiyos. Sinigaan da ay manokog sin lawa ay ipapati da ay am-amagen. ");
INSERT INTO kne_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Siya di, palalo ay inpabonget din Israelita si Diyos. Kanana, “Gapo ta nilabsing da din intolag ko sin ap-apo da ya adi dan omikaskaso, ");
INSERT INTO kne_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","adiak pakaanen din ipogaw ay adi pay laeng inpakaan Josue sin kamatago na. ");
INSERT INTO kne_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Daida di osalek sin iyat ko ay mamadas sin Israelita ta maammoak mo patien da din bilin ko ay kaman din ap-apo da.” ");
INSERT INTO kne_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Kinwanin Diyos di, tan sigod ay inpalobos na ay mantetee dadi ay ipogaw ed Canaan. Adi na inpakaan ay dagos ono inpaabak en Josue. ");
INSERT INTO kne_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Inamag din Israelita din lawa sin pangilan Yahweh ay Diyos da, tan nilinglingan das sisya et nansilbi da en da Baal en Asera. ");
INSERT INTO kne_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Palalo din bonget Diyos sin Israelita, isonga pinalobosana ay iturayan Cusan Risataim ay ari ed Mesopotamia si daida si wao ay tawen. ");
INSERT INTO kne_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Pag manpakaasi din Israelita en Diyos, et dinotokanas Otniel ay anak Kenaz ay iyogtan Caleb ta say mangisalakan en daida. ");
INSERT INTO kne_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Sin-gep din Ispiriton Diyos sisya et inpangolo na din Israelita. Ginobat na din ari ed Mesopotamia et nangabaken Diyos sisya. ");
INSERT INTO kne_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Et tinmalna din ili da si opatapolo ay tawen enggana ay natey si Otniel. ");
INSERT INTO kne_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Kasin inamag din Israelita din lawa sin pangilan Diyos, isonga pinapigsan Diyos si Eglon ay ari ed Moab mo din Israelita. ");
INSERT INTO kne_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Nakitolag si Eglon sin Ammonita ya Amalekita et nanbabadang da ay nangobat sin Israelita et sinakop da ed Jerico, din siyodad ay kaad-adoan di palma. ");
INSERT INTO kne_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Inturayan Eglon din Israelita si sinpo ya wao ay tawen. ");
INSERT INTO kne_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Siya di, nanpakaasi kasin din Israelita en Diyos et nandotok si mangisalakan en daida. Pinili na si Ehud ay esa ay nakannigid ay anak Gera ay polin Benjamin. Inbaan din Israelita sisya ay mangiey si bowis da en Eglon ay ari ed Moab. ");
INSERT INTO kne_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Idi nakdeng ay natey si Ehud, say inamag kasin din Israelita din lawa sin pangilan Diyos. ");
INSERT INTO kne_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Gapo sidi, inpalobos Diyos ay abaken Jabin daida. Si Jabin ay nay yan Canaaneo ay ari ed Hazor. Si Sisera ay manbeey ed Haroset ay ilin di Gentil di komander din sosoldado na. ");
INSERT INTO kne_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Waday 900 ay kalisan Jabin ay para gobat ay landok di amag na, yan palalo di inyat na ay namaligat sin Israelita si dowanpo ay tawen, isonga nanpakaasi dan Diyos ta badanganas daida. ");
INSERT INTO kne_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Sin doy ay timpo, si Debora ay esa ay mamadto ya asawan Lappidot di pangolo ed Israel. ");
INSERT INTO kne_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Kaadoan ay tomokdos sisya sin poon di makwani en Palman Debora sin nan-gawaan di Rama ya Betel sin kadondontogan ed Efraim. Isdi di emeyan din Israelita ay mangikamang sin problima da. ");
INSERT INTO kne_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Inpaayag na si Barak ay anak Abinoam, ay taga-Kedes ay siyodad ed Naftali yan kanana, “Wada di inbilin Yahweh ay Diyos di Israelita en sik-a. Kanana en ipangoloam di sinpo ay libo ay lallalaki ay mapo sin tribun da Naftali en Zebulun ta emey kayo ed dontog ay Tabor. ");
INSERT INTO kne_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Iturong nan to si Sisera ay komander di sosoldadon Jabin ta ena gobaten dakayo sin ginawang ay Kison. Ikoyog na din sosoldado na ya kalisa ay para gobat, ngem pangabaken Diyos sik-a.” ");
INSERT INTO kne_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Kanan Barak ay nanongbat, “Emeyak mo komoyog ka, ngem mo adi kan komoyog, adiak emey.” ");
INSERT INTO kne_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Kanan Debora, “May ngarud, koyogek sik-a. Ngem baken sik-a di maidayaw sin pangabakam, tan awni et babai di pangipapsean Diyos en Sisera.” Et kinoyog Debora si Barak ay inmey ed Kedes. ");
INSERT INTO kne_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Inpaayag Barak din tribun da Zebulun en Naftali et nakikoyog en sisya di sinpo ay libo ay lallalaki yan nakikoyog abe si Debora. ");
INSERT INTO kne_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Sin doy ay timpo, in-amag Heber ay Kineo din tolda ay kampo na sin asag-en ed Kedes sin asag-en di dakdake ay kaiw ed Zaanannim. Naisian sisya sin gagait na ay Kineo ay polin Hobab ay bayaw Moses. ");
INSERT INTO kne_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Idi naipaammo en Sisera ay inmey si Barak sin dontog ay Tabor, ");
INSERT INTO kne_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","inpasinop na din 900 ay kalisa na ay para gobat ya din amin ay soldado na. Nanlobwat da ed Haroset ay ilin di Gentil et inmey da sin ginawang ay Kison. ");
INSERT INTO kne_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Kanan Debora en Barak, “Dalasem, emey ka! Tan ed wani ay agew, pangabaken Diyos sik-a, tan sisya di mangipango en sik-a et abakem si Sisera.” Idi siya di, nanlobwat da Barak sin dontog ay Tabor et nanballalong da ya din sinpo ay libo ay soldado na. ");
INSERT INTO kne_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Idi dinmateng da, kinibtot Diyos da Sisera ya din amin ay soldado na pati din nanlogan si kalisa ay para gobat. Kaagpas et si Sisera sin kabayo na yan katagtag. ");
INSERT INTO kne_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Inapayaw da Barak din kalisa ay para gobat ya sosoldadon Sisera enggana ed Haroset ay ilin di Gentil et pinse da amin daida. Maga di olay esa ay nakalasat. ");
INSERT INTO kne_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Si Sisera pay yan nanagtag ay inmey sin toldan Jael ay asawan Heber ay Kineo, tan gayyem dedan Jabin ay ari ed Hazor din pamilyan Heber. ");
INSERT INTO kne_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Inabat Jael si Sisera sin bel-ayan di tolda yan kanana, “Senggep ka sin toldak, adi ka emegyat.” Sinenggep tet-ewa si Sisera yan ginaleyan Jael. ");
INSERT INTO kne_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Kanan Sisera, “Pangaasim kod ta omya kas at-atik ay danom tan nay palalo ay manbigawak.” Linokatan Jael din sopot ay lalat ay naipey-an di gatas et nan-inomena si Sisera, asi na ginaleyan kasin. ");
INSERT INTO kne_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Kanan Sisera, “Mantee ka sin pantew ta mo waday mandamag mo waday inmali ay ipogaw yan ibagam ay maga.” ");
INSERT INTO kne_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Palalo di boway Sisera et nas-et di seyep na. Pag man-as Jael si martilyo ya pasek di tolda yan nan-in-inayad ay sinmag-en en sisya. Pinasekana din toktok na enggana ay nantaros din pasek sin lota et natey. ");
INSERT INTO kne_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Idi malabas si Barak ay mangan-anap en Sisera, inabat Jael sisya yan kanana, “Senggep ka ta ipailak din lalaki ay an-anapem.” Sinenggep si Barak yan inila nas Sisera ay nanatey ay napasekan din toktok na. ");
INSERT INTO kne_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Sin doy ay agew, inabak Diyos si Jabin ay ari ed Canaan sin sangoanan di Israelita. ");
INSERT INTO kne_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Idi siya di, pinaspasan din Israelita ay nangobat en Jabin enggana ay dadlon dan inabak. ");
INSERT INTO kne_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Kasin inamag din Israelita din lawa sin pangilan Diyos, isonga inpalobos na ay iturayan din Midianita si daida si pito ay tawen. ");
INSERT INTO kne_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Napigpigsa din Midianita mo din Israelita et palalo ay pinalpaligat da, isonga nantabon da si liyang ya odom ay mabalin ay pantabonan da sin kadondontogan. ");
INSERT INTO kne_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Kanayon ay mo pinag-eesek di Israelita, itompong abe din Midianita, Amalekita ya odom ay tribu ay napo sin naibandas belaan di agew ay mangobat en daida. ");
INSERT INTO kne_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Mankampo da sin dagan di Israelita et dadaelen da din molmola enggana sin abagatan ay asag-en ed Gaza. Maga polos di bay-an da si kanen din Israelita. Maga di olay karnero, baka ono dangki. ");
INSERT INTO kne_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Intakin da abe din babaka ya tolda da et kaman dan dodon ay adi kabilang di kaad-ado da pati din kamel da. Dinadael da din ili ");
INSERT INTO kne_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","enggana ay peteg ay binmiteg ya kinmaseseg-ang din Israelita. Pag manpakaasi din Israelita en Diyos. ");
INSERT INTO kne_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Idi nankedaw das badang Diyos begew sin Midianita, ");
INSERT INTO kne_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","nan-ibaa si mamadto ay nangibaga en daida, “Siya na di kanan Yahweh ay Diyos di Israelita, ‘Winayawayaak dakayo ed Egipto ay naibabag-enan yo. ");
INSERT INTO kne_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Insalakan kos dakayo sin taga-Egipto ya sin am-in ay namalpaligat en dakayo sin ili ay nay. Pinakaan kos daida sin inmalian yo et indawat ko en dakayo din daga da. ");
INSERT INTO kne_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Inbagak en dakayo ay sak-en si Yahweh ay Diyos yo ya adi kayon dayawen din sinan didiyos di Amorreo ay akin daga isnan kad-an yo ed wani, ngem adi kayon inmikaskaso.’” ");
INSERT INTO kne_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Makdeng pay di, wada din anghel Diyos ay dinmateng ed Ofra et tinmokdo sin poon di esay dakdake ay kaiw ay okan Joas ay polin Abiezer. Man-ir-irik si Gideon ay anak na sin kad-an di panpespesan si obas ta adi ilaen din Midianita. ");
INSERT INTO kne_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Nanpailan sisya din anghel en Diyos yan kanana, “Wadas Diyos en sik-a, natoled ya napigsa ay lalaki.” ");
INSERT INTO kne_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Ngem kanan Gideon, “Apo, mo wadas Diyos en dakami, apay ngin ay siya na di napasamak en dakami? Apay ngin ay magay inamag Diyos ay nakaskasdaaw ay kaman din dinaddad-at di aam-a mi ay inam-amag na ed idi sin nangipangoana en daida ay komaan ed Egipto? Nay pay ed wani yan binaybay-an Diyos dakami et inpalobos na ay iturayan din Midianita dakami.” ");
INSERT INTO kne_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Pag et kanan Diyos ay nangibilin en sisya, “Osalem san pigsam ta en ka isalakan din Israelita sin pangiturayan din Midianita. Mismo ay sak-en di mangibaa en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Songbatan pay Gideon yan kanana, “Ngem Apo, intoy iyat ko ay mangisalakan sin Israelita? Dakami ay sintoton-od di kakapsotan sin polin Manasses yan sak-en abe di kababaan sin pamilya mi.” ");
INSERT INTO kne_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Ngem kanan Diyos en sisya, “Kabaelam tan kadwaek sik-a. Awni et nalaka di iyat mo ay mangabak sin Midianita ay kaman dan owat esay ipogaw.” ");
INSERT INTO kne_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Kanan Gideon, “Mo malaylaydan ka en sak-en, paneknekam kod ay sik-a tet-ewa si Diyos. ");
INSERT INTO kne_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Pangaasim ta adi ka pay laeng komakkaan ta enak man-a si makan ay idaton kon sik-a.” “May, isnaak enggana ay mantaoli ka,” kanana. ");
INSERT INTO kne_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Sinmaa si Gideon et nanparti si bomaro ay kalding ay in-oto na. Nanmasa si sinpo ay kilo ay arina et inamag nas tinapay ay magay labadura na. Inpeey na si baskit din karni yan inpeey na si banga din sabaw, pag nan iey sin anghel sin poon di kaiw. ");
INSERT INTO kne_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Kanan din anghel en sisya, “Ipatang mo sin bato din karni ya tinapay ay sana, asi kan sodagan sin sabaw.” Tinongpal Gideon din naibaga en sisya. ");
INSERT INTO kne_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Idi makdeng di, insagid din anghel din otdok din sokod ay iin-genana sin karni ya tinapay. Kabidang et di apoy sin bato ay namoo sin karni ya tinapay, pag et bigla ay mamaga din anghel. ");
INSERT INTO kne_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Say nangammoan Gideon ay din anghel Diyos din inila na, et peteg di egyat na ay nangwani, “Diyos ay Kangatoan, inilak ay sangosango din anghel mo!” ");
INSERT INTO kne_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Ngem kanan Diyos en sisya, “Talna koma di wadan sik-a. Adi kan emegyat tan laton ay adi kan matey.” ");
INSERT INTO kne_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Et nan-amag si Gideon isdi si altar ay para en Diyos ay nginadanana si Yahweh et Poon di Talna. Olay ed wani, wada pay laeng ed Ofra ay dagan di polin Abiezer. ");
INSERT INTO kne_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Sin labi ay doy, kanan Diyos en Gideon, “Alaem din maikadwa ay bomaro ay bakan amam ay mantawen si pito. Bakasem din altar ay inamag amam para en Baal yan poyoem din posti ay pangidaydayaw dan Asera ay naitatakdo. ");
INSERT INTO kne_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Asi kan man-amag si kosto ay altar para en Diyos sin labaw di nakayang ay pankamangan ay nay. Mo makdeng di, osalem din pinoyom ay posti ay pangidaydayaw dan Asera ay pangipooam sin idaton mo ay baka.” ");
INSERT INTO kne_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Intakin Gideon di sinpo sin babag-ena et tinongpal na din inbilin Diyos. Ngem gapo ta emegyat sin aag-i na ya kailiana, baken sin kaagawan di nangamagana mo adi et sin labi. ");
INSERT INTO kne_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Idi binmangon din man-ili sin agsapa, inila da ay nadadael din altar Baal pati din posti ay pangidaydayaw dan Asera ay tinatakdo na. Inila da abe din bomaro ay baka ay naidaton sin kabarbaro ay altar. ");
INSERT INTO kne_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Kanan da ay nan-asibaga, “Sino ngata di nangamag isna?” Idi dinamdamag da, naammoan da ay si Gideon ay anak Joas di nangamag. ");
INSERT INTO kne_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Kanan da en Joas, “Ibelam din anak mo ta peslen mi, tan dinadael na din altar Baal yan gintad na din posti ay pangidaydayaw mi en Asera ay naitatakdo.” ");
INSERT INTO kne_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Ngem kanan Joas en daida, “Apay ngin ay isakit yo ya salakniban yo si Baal? Adi pay laeng pomat-a yan matey di mangisakit en sisya. Mo tet-ewa ay diyos si Baal, bay-an yo ta ikalinteganay awak na tan altar na di nadadael.” ");
INSERT INTO kne_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Manipod isdi, nginadanan das Gideon si Jerubbaal begew sin nangwanian Joas en “Bay-an yo ay salakniban Baal di awak na, tan altar na di nadadael.” ");
INSERT INTO kne_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Makdeng pay di, nasinop din Midianita, Amalekita ya din odom ay tribu ay napo sin naibandas belaan di agew. Inagadang da din ginawang ay Jordan et nankampo da sin tanap ay Jezreel. ");
INSERT INTO kne_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Idi siya di, sinenggep din Ispiriton Diyos en Gideon et nananggoyob ay nangayag sin lallalaki ay polin Abiezer ta omonod dan sisya. ");
INSERT INTO kne_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Nan-ibaa abe si nangipaammo sin intiro ay polin Manasses ay makigobat da, siya abe sin polin da Aser, Zebulun ya Naftali et nantikid da ay nangaspo en sisya. ");
INSERT INTO kne_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Pag kanan Gideon en Diyos, “Laydek ay paneknekan mo osalem sak-en ay mangisalakan sin Israelita ay kaman din inkarim. ");
INSERT INTO kne_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Ipayag ko ngarud nan dotdot di karnero sin lota ay pan-ir-irikan si bakakew ta mo din dotdot anggoy di mabasa si dono yan nanamgaan din lota, say pangammoak ay tet-ewa ay osalem sak-en ay mangisalakan sin Israelita.” ");
INSERT INTO kne_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Et dadlon say napasamak. Idi binmangon si Gideon ay nasapa sin kabigatana, pinespesana din dotdot di karnero et napno di esay malokong sin dono. ");
INSERT INTO kne_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Idi siya di, kanan Gideon en Diyos, “Adi ka kod omibongbonget ta palobosam sak-en isnan maodi ay ibagak. Pangaasim kod ta ipalobos mo pay di esa ay pamaneknek babaen sin dotdot. Ed wani, say mabasa koma din lota yan say mamgaan din dotdot.” ");
INSERT INTO kne_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Sin isdi ay labi, say inyat tet-ewan Diyos et sin kabigatana, nabasa si dono din lota yan nanamgaan din dotdot di karnero. ");
INSERT INTO kne_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Sin agsapa ay doy, nasapa ay binmangon da Jerubbaal ono Gideon ya din sosoldado na et en da nankampo sin kad-an di obbog ay nangadanan si Harod. Nankampo abe din Midianita sin tanap sin asag-en di dontog ay More ay amyanan di kad-an da. ");
INSERT INTO kne_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Kanan Diyos en Gideon, “Palalo ay ad-ado san soldadom. At-atik anggoy di osalek ay mangabak sin Midianita tan into et mo kanan da en nangabak da begew sin kinapigsa da. ");
INSERT INTO kne_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Ibagam en daida ay mo wada di emegyat yan komaan sin dontog ay Gilead ta somaa.” Et sinmaa di 22,000 yan nabay-an di 10,000. ");
INSERT INTO kne_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Kanan kasin Diyos en Gideon, “Ad-ado pay laeng san soldadom. Iballalong mos daida sin kad-an di danom ta isdi ay ikasin ko di makiey en sik-a. Mo din ibagak en maikoyog en sik-a yan itakin mo, ngem din ibagak en adi makiey yan adi kan itaktakin.” ");
INSERT INTO kne_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Idi siya di, inpangon Gideon daida sin kad-an di danom, pag kanan Diyos en sisya, “Ikasin mo din mandokmog ay man-inom sin maniplat sin danom ay kaman din iyat di aso.” ");
INSERT INTO kne_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Tolo ay gasot di lallalaki ay nangigaok sin takkay da asi dan inomen, et din odom pay yan nandokmog da ay nan-inom. ");
INSERT INTO kne_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Pag kanan Diyos en Gideon, “Say osalek nan tolo ay gasot ay lallalaki ay mangisalakan en dakayo ya mangabak sin Midianita. Pasaaem amin din odom.” ");
INSERT INTO kne_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Siya di, inpaipayag Gideon din baon ya tanggoyob din odom ay Israelita et inpasaa nas daida, ngem din tolo ay gasot pay et inpakodana ta mataynan da sin kad-ana. Din kampon di Midianita yan wada sin tanap sin gowab di kad-an da. ");
INSERT INTO kne_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Idi malabi, kanan Diyos en Gideon, “Manballalong kayo sin kampon di Midianita ta en kayo gobaten daida, tan badangak si dakayo et abaken yos daida. ");
INSERT INTO kne_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Ngem mo emegyat ka, ayagam si Pura ay kabadang mo ta emey kayo sin kampo da. ");
INSERT INTO kne_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Mo dengngem din ibagbaga da et tomoled ka ay mangobat en daida.” Et inmey da Gideon en Pura sin asag-en di kampon di kalaban da. ");
INSERT INTO kne_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Kaman dan dodon ay adi kabilang ay naiwaras sin tanap din Midianita, Amalekita ya tribu ay napo sin naibandas belaan di agew. Kaman aben darat sin benget di baybay di kaad-adon din kamel da. ");
INSERT INTO kne_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Idi dinmateng da Gideon, waday dinnge na ay mangis-istorya sin gayyem na si iitaw na. Kanan din sana ay man-istorya, “Iniitaw ko en wada kano di tinapay ay sabog ay napolag sin kampo tako yan dinalapos na din esa ay tolda et natokang ay naiaplag sin lota.” ");
INSERT INTO kne_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Kanan et din gayyem na, “Inayan pay sa! Magay odom si olog na mo adi et din kampilan Gideon ay Israelita ay anak Joas. Ipaabak Diyos en sisya din Midianita ya si datako am-in.” ");
INSERT INTO kne_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Idi dinngen Gideon din iitaw di esa ay sana ya din olog na, nandokmog ay nandayaw en Diyos. Pag dan mantaoli sin kampo da ay Israelita yan kanana, “Mansagana kayo tan ipaabak Diyos en datako din sosoldado ay Midianita.” ");
INSERT INTO kne_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Nankatloena din tolo ay gasot ay sosoldado na, asi na idawtan daida si sag-eesa ay tanggoyob ya koli ay nailingeban di silaw. ");
INSERT INTO kne_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Kanana ay nangibilin en daida, “Ilaen yo ta onodan yo din amagek mo domatengak sin igid di kampo da. ");
INSERT INTO kne_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Mo mananggoyob kami sin gagait ko, mananggoyob kayo abe sin nanniliked di kampo da, asi kayon kanan ay mangibogaw, ‘Para en Diyos ya si Gideon.’” ");
INSERT INTO kne_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Dinmateng si Gideon ya din sin-gasot ay soldado na sin igid di kampo idi daan pay laeng di gawan di labi sin kosto ay owat nansinokat din gowardia. Nananggoyob da asi da pag gopaken din koli ay iin-genan da, ");
INSERT INTO kne_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","et say inyat abe din dowa ay bonggoy ay gagait da. Esa en nanggen si silaw sin kannigid ya tanggoyob sin kannawan dowan dan manbogaw ay kanan da, “Kampilan para en Diyos ya si Gideon!” ");
INSERT INTO kne_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Magay nan-et-etan en daida sin inmalageyan da ay nanlikob sin kampo. Tomanagtag amin din Midianita dowan dan manngalawngaw. ");
INSERT INTO kne_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Sin doy nananggoyoban da Gideon ya din tolo ay gasot ay soldado na, nan-iibawen Diyos din Midianita sin kampo da et tinmagtag da ay nanturong ed Zerera enggana ed Bet-sitta ya ed Abel-mehola ay asag-en ed Tabbat. ");
INSERT INTO kne_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Idi kasin inamag din Israelita din lawa sin pangilan Diyos, inpalobos na ay iturayan din Filisteo si daida si opatapolo ay tawen. ");
INSERT INTO kne_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Sin doy ay timpo, waday lalaki sin tribun Dan ay manngadan si Manoa ay taga-Zora ay basig di asawa na. ");
INSERT INTO kne_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Nanpaila din anghel Diyos sin babai yan kanana, “Adi kan nan-an-anak ed idi, ngem awni et mawad-an ka et ianak mo di esa ay lalaki. ");
INSERT INTO kne_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Ilaem ta adi ka polos man-in-inom si arak ono kompormi ay nabobodan ya adi ka mangmangan si ibilang di linteg ay baken nalinis. ");
INSERT INTO kne_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Mo bemela din anak yo, masapol ay adi kayon pokpokisan, tan naidadaton ay mansilbi en Diyos manipod sin kaianakana enggana sin kateyana. Sisya di mangilogi sin kaisalakanan di Israelita sin turay di Filisteo.” ");
INSERT INTO kne_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Kanan Manoa sin anghel Diyos, “Ibagam kod di ngadan mo ta dayawen mis sik-a mo matongpal din inbagam.” ");
INSERT INTO kne_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Ngem kanan din anghel, “Apay nga damagen yo din ngadan ko? Palalo adi ay nakaskasdaaw.” ");
INSERT INTO kne_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Pag man-a si Manoa si bomaro ay kalding ya daton ay arina et indatona sin altar Diyos ay mangam-amag si ad-ado ay nakaskasdaaw. ");
INSERT INTO kne_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","21","Idi komaykayang din apoy sin altar, inilan da Manoa din anghel Diyos ay maid-idsan sin apoy ay komaykayang. Say nangammoan Manoa ay anghel Diyos baw din lalaki ay doy. Et kalakpap da ay sin-asawa sin lota. Idi makdeng di, adi nanpaila kasin din anghel Diyos en daida. ");
INSERT INTO kne_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Pag kanan Manoa en asawa na, “Adi pay matey ta tan inila ta si Diyos.” ");
INSERT INTO kne_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Ngem kanan asawa na ay sinombat, “Mo panggep Diyos ay mamse en daita, adi na koman inawat din daton ta. Adi na koman inpaila ya inbaga am-in dadi en daita.” ");
INSERT INTO kne_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Idi siya di, nan-anak tet-ewa din babai si lalaki et nginadanana si Samson. Dinmakdake din anak ay sana et binindisyonan Diyos. ");
INSERT INTO kne_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Sin kawadan Samson sin kampon di tribun Dan sin nan-gawaan di Zora ya Estaol, nilogian din Ispiriton Diyos ay tignayen sisya. ");
INSERT INTO kne_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Sin esa ay agew, nanballalong si Samson ed Timna et isdi ay inila na di esay babai ay Filisteo. ");
INSERT INTO kne_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Sinmaa yan kanana en da ama na en ina na, “Waday inilak ay babai ay Filisteo ed Timna ay naipketan di matak. En kayo koman makikali tan laydek ay asawaen.” ");
INSERT INTO kne_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Ngem kanan da ama na, “Apay nga mangasawa kas anak di baken nakogit ay Filisteo? Ay tan maga aya di mapilim si kapolian tako ono iib-a tako ay Israelita?” Ngem kanan Samson en ama na, “Sisya met di laydek ay ton-oden yo ta asawaek.” ");
INSERT INTO kne_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Adin ammon da aman Samson ay si Diyos di mangiturturong en sisya ay mangamag isna ta way iyat na ay manglaban sin Filisteo ay madama ay mangiturturay sin Israelita. ");
INSERT INTO kne_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Et kinoyog Samson da ama na en ina na ay nanballalong ed Timna. Idi manmandan da sin kad-an di kaob-obasan isdi, wada et di manngangaed ay bomaro ay layon ay en mangabet en sisya. ");
INSERT INTO kne_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Bigla ay inpapigsan din Ispiriton Diyos si Samson, isonga olay magay armas na yan binisngibisngit na din layon ay kaman owat olbon di kalding di inyat na. Ngem adi na inis-istoryan da ama na din inamag na. ");
INSERT INTO kne_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Pag manballalong ay en makikali sin babai et nalaydalaydan sisya. ");
INSERT INTO kne_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Nalabas pay di piga ay timpo et kasin inmey si Samson ta asawaena din babai. Kinombas sin danan ta ilaena din layon ay pinse na, kambaw nanbeey di anig yan nalamsan. ");
INSERT INTO kne_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Et nan-a si kinkinana sin danan. Idi domateng sin kad-an da ama na, inyaanas daida et kinan da abe. Ngem adi na inbagbagan daida ay ina na sin bangkay di layon. ");
INSERT INTO kne_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Inmey da sin beey di babai et nanparti si Samson isdi tan say ogali das di ay iyat di mangasawa. ");
INSERT INTO kne_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Idi inilan din Filisteo sisya, nan-ibaa das tolonpo ay lalaki ay mangadkadwa en sisya. ");
INSERT INTO kne_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Siya et di, kanan Samson en daida, “Manbontiyaak, et mo mapontosan yo sin oneg di pito ay agew ay ragragsak, idawtak dakayo si tolonpo ay mayamayat ay lopot ya tolonpo ay paris ay nangina ay bado. ");
INSERT INTO kne_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Mo adi kayon makapontos, dakayo di omya si tolonpo ay lopot ya tolonpo ay bado.” Kanan abe din Filisteo, “May kod kayman, ibagam san bontiyam ta dengngen mi.” ");
INSERT INTO kne_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Pag kanan Samson, “Nawaday makan ay napo sin mangamangan, Nawaday mam-is ay napo sin kapipigsaan.” Inmey di tolo ay agew yan adi dan makasongbat. ");
INSERT INTO kne_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Sin maikap-at ay agew, kanan da sin asawan Samson, “Sikapam si asawam ta ibaga nan sik-a di songbat din bontiya na. Mo sigaam, pooan mis sik-a ya din pamilyam ta matey kayo am-in. Ay inmayag kayo baw ta pabitegen yos dakami?” ");
INSERT INTO kne_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Inmey si asawan Samson sin kad-ana et nan-og-oga ay nangwani, “Malmaliget ka baw en sak-en! Baken tet-ewa ay laylaydem sak-en, tan waday bontiyam sin kailiak yan adi kan inbaga di songbat nan sak-en.” Kanan Samson, “Adiak to pay inbaga en da amak en inak, apay nga ibagak en sik-a?” ");
INSERT INTO kne_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Ngem adi sinmaldeng ay nan-og-oga sin pito ay agew ay doy ay ragragsak, et kanayon ay damdamagena en sisya, isonga sin maikapito ay agew, inbagan Samson. Pag aben ibagan asawa na sin kailiana. ");
INSERT INTO kne_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Idi dandani ay madipos di agew sin maikapito, kanan din man-ili en Samson, “Ay baken anig di kakam-isan? Ay baken od layon di kapipigsaan?” Kanan Samson en daida, “Mo adi kayon in-alado din bakak, Adi kayo koman nasongbatan din bontiyak.” ");
INSERT INTO kne_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Pag et senggep en sisya din Ispiriton Diyos ay nangipapigsa en sisya et nanballalong ed Askelon. Pinse na di tolonpo ay lalaki ay Filisteo et ina na din bado da ay say indawat na sin nanongbat sin bontiya na. Makdeng pay di, sinmaa ed beey da ama na, tan palalo di bonget na begew sin napasamak. ");
INSERT INTO kne_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Din asawa na pay yan inpaasawa da sin lalaki ay nangadkadwa en sisya sin kasal na. ");
INSERT INTO kne_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Idi baken onay nabayag, sin pinag-aanis bakakew, nan-as Samson si anak di kalding ta ena ilaen si asawa na. Kanana, “Senggepak sin kowarton asawak,” ngem adi pinalobosan din aman di babai. ");
INSERT INTO kne_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Kanan katogangana, “Kanak to met en palalo ay kalkaliget mos sisya, isonga inpaasawak sin gayyem mo. Olay et adin say asawaem din iyogtana, tan doy laton ay napinpintas et abe.” ");
INSERT INTO kne_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Siya et di, kanan Samson en daida, “Ed wani, bakenak basol mo intoy amagek sin kailian yo ay Filisteo.” ");
INSERT INTO kne_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Pag et kabela yan en nandepap si tolon gasot ay atap ay aso, asi nan sinagdodwas daida ay in-galot din iko da dowanan igalot di sag-eesa ay silaw sin iko da. ");
INSERT INTO kne_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Tinetengana pag nan ibolosan daida sin minolaan di Filisteo si bakakew, et pag napooan din naani ya daan maani, pati kaob-obasan ya kakakkaiwan ay olivo. ");
INSERT INTO kne_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Idi damagen pay din Filisteo mo sino di nangamag sidi, naammoan da ay si Samson ay innapo dad Timna, tan inpaasawan katogangana din asawa na sin gayyem na. Pag mantikid din Filisteo et pinooan da ay pinse da asawan Samson ay sin-ama. ");
INSERT INTO kne_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Idi siya di, kanan Samson en daida, “Gapo ta say inamag yo na, adiak somaldeng enggana ay ibaes ko din inyat yo.” ");
INSERT INTO kne_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Palalo di inyat na ay nanglaban en daida, et ad-ado di pinse na. Makdeng pay di, nanballalong et nantee si esay liyang sin deppas ed Etam. ");
INSERT INTO kne_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","En nankampo din Filisteo ed Juda et in-olnos dan sosoldado da sin asag-en ed Lehi, ");
INSERT INTO kne_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","isonga kanan din man-ili ed Juda, “Apay ngin ay inmali kayo ay mangobat en dakami?” Songbatan pay din Filisteo yan kanan da, “Inmali kami ay en manpap en Samson ta ibalod mi ya ibaes mi din inamag nan dakami.” ");
INSERT INTO kne_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Siya di inmey di tolon gasot ay lalaki ay taga-Juda sin liyang sin deppas ed Etam et kanan da en Samson, “Ay adi ka ayan ammo ay din Filisteo di mangituray en datako? Ay sino ngin nas inamag mo en dakami?” Ngem kanan Samson, “Inbaes ko met anggoy din inyat da en sak-en.” ");
INSERT INTO kne_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Pag dan kanan, “Inmali kami ay mamalod en sik-a ta ipolang daka sin Filisteo.” Idi siya di, kanan Samson en daida, “Ikari yo ngarud en sak-en ay baken dakayo ay mismo di pomse.” ");
INSERT INTO kne_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Et kanan da ay nanongbat, “Aw, adi dakan peslen. Baloden mi anggoy sik-a ay ipolang en daida.” Et binalod das Samson si dowa ay baro ay lobid, pag dan ibela sin liyang. ");
INSERT INTO kne_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Idi dinmateng da ed Lehi, tomanagtag din Filisteo dowan dan bomanogaw ay mangaspo en sisya. Ngem kasegep en sisya din Ispiriton Diyos et bigla ay pinmigsa. Pag kasokpot sin lobid ay naibabalod en sisya et kaman owat sinolid ay naatongan. ");
INSERT INTO kne_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Inila na et di makneg ay patang di dangki yan kapidit et say inosal na ay namse si sinlibo ay Filisteo. ");
INSERT INTO kne_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Pag nan kanan, “Babaen si patang di dangki, pinsek di sinlibo ay lalaki. Tinob-on kos daida adi.” ");
INSERT INTO kne_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Makdeng pay di yan kaitep-a sin patang. Din lugar ay napasamakan nina et nangadanan si Ramat Lehi. ");
INSERT INTO kne_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Palalo di bigaw Samson, isonga kanana ay nan-adawag en Diyos, “Indawat mo kayman nan nakaskasdaaw ay nangabakak, ngem ay mateyak ed wani si bigaw ko ta dompap da nan baken nakogit ay Filisteo?” ");
INSERT INTO kne_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Pag et pantekangen Diyos din longog ed Lehi et kabala di danom. Idi man-inom pay si Samson, nantaoli din bikas na. Et say gapo ay nangadanan si En Hakorre din obbog ay doy ay wada enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Inpangoloan Samson din Israelita si dowanpo ay tawen sin timpo ay nangiturayan di Filisteo sin ili da. ");
INSERT INTO kne_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Sin namingsan, inmey si Samson ed Gaza ay esa ay siyodad di Filisteo. Isdi ay inaspo na di esay babai ay mangiab-abang si awak na et dinaag na. ");
INSERT INTO kne_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Idi ammoan din taga-Gaza ay wadas Samson isdi, linikob da din lugar ay doy et binantayan da ay naninsinlabi. Magay inamag da sin labi ay doy, tan kanan da ay nantotolag, “Bantayan tako enggana ay pomat-a ta asi takon peslen.” ");
INSERT INTO kne_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Ngem enggana anggoy si gawan di labi di nanteean Samson isdi. Idi bomangon pay, kabit-in sin liteb di siyodad pati din nanbabag ay landok et nakioksot din dowa ay posti na. Sinakbat na am-in ay magay nabaybay-an et in-ey na sin toktok di dontog ay nangoosdong ed Hebron. ");
INSERT INTO kne_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Baken nabayag yan waday laylayden Samson ay babai sin tanap ay Sorek ay manngadan si Delila. ");
INSERT INTO kne_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Inmey din papangolon di Filisteo en sisya yan kanan da, “Sikapam si Samson ta ammoem di makagapo sin nakaskasdaaw ay bikas na ya mo intoy iyat mi ay mangabak ta baloden mi ta pan-oblaen mis madagsen. Asi kamin idawtan sik-a si sagsisinpo ya esa ay gasot ay palata.” ");
INSERT INTO kne_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Idi siya di, kanan Delila en Samson, “Pangaasim kod ta ibagam en sak-en di poon san nakaskasdaaw ay bikas mo. Mo kaspangarigan way manglayad ay mamalod en sik-a, intoy iyat na ngin ta say maabak ka?” ");
INSERT INTO kne_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Kanan Samson, “Mo bomalod da si pito ay baro ya baken nango ay lobid di pana, komapsotak ay kaman din odom ay ipogaw.” ");
INSERT INTO kne_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","9","Indawtan di papangolon di Filisteo si Delila si pito ay baro ay lobid di pana. Wada abey lallalaki ay nantabonen Delila si esa ay kowarto. Binalod nas Samson, asi na kanan ay nangibogaw, “Samson, sana day Filisteo!” Ngem kasokpot si Samson sin lobid et kaman sinolid ay naatongan, isonga adi da inammo di poon din nakaskasdaaw ay bikas na. ");
INSERT INTO kne_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Pag kanan Delila en Samson, “Apay ngin ay omiet-etek ka ay owat kan pan-ay-ayaman sak-en? Ibagam kod mo intoy iyat ay mamalod en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Kanan Samson, “Mo bomalod da si baro ay lobid ay adi naos-osal, komapsotak ay kaman met laeng din amin ay ipogaw.” ");
INSERT INTO kne_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Nan-as Delila si baro ay lobid et binalod nas Samson, asi kabogaw ay nangwani, “Samson, sana day Filisteo!” Waday lallalaki ay manseseed sin esa ay kowarto, ngem kasokpot si Samson sin lobid et nag-as da sin takkay na ay kaman owat sinolid. ");
INSERT INTO kne_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Pag kanan Delila, “Engganad wani, pan-ay-ayamam sak-en ay adi ka ibaga di tet-ewa. Ibagam adi mo intoy iyat da ay mamalod en sik-a.” Kanan Samson, “Mo makiabel mo sin sinolid din pito ay apid di book ko ya isetset mo, komapsotak et mais-oak si odom ay ipogaw.” ");
INSERT INTO kne_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Inpaseyep Delila sisya, asi nan abelan din pito ay apid ay book na et insetset na si sanat, asi na kanan ay nangibogaw, “Samson, sana day Filisteo!” Kabangon si Samson et kagoyod sin book na sin tilar. ");
INSERT INTO kne_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Pag kanan Delila, “Intoy iyat na ngin ay kanam en laylaydem sak-en ngem adi ka met ibaga di tet-ewa? Namitlo ay in-etekam sak-en ngem adi ka pay laeng ibaga di gapo ay napigsa ka.” ");
INSERT INTO kne_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Inag-agew ay damdamagena et enggay naoma si Samson, ");
INSERT INTO kne_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","isonga neyney na yan inbaga na di tet-ewa. Kanana, “Adi polos napokpokisan nan book ko, tan naidatonak ay mansilbi en Diyos manipod sin naianakak. Komapsotak mo mapokisanak et mais-o din pigsak si kompormi ay ipogaw.” ");
INSERT INTO kne_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Idi pasalen pay Delila ay tet-ewa din inbagan Samson, inpaammo na sin papangolon di Filisteo. “Omali kayo kasin, tan inbaga na di tet-ewa,” kanana. Inmey da et intakin da din pilak. ");
INSERT INTO kne_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Binakwan Delila din toktok Samson et inpaseyep na, asi nan-ayag si namokis sin book na ay naapid si nankapito. Say nanlogian di kinmapsotana enggana ay nakaan din bikas na. ");
INSERT INTO kne_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Pag kanan Delila ay nanbogaw, “Samson, sana day Filisteo!” Binmangon yan kananas nemnem na, “Kabaelak ay bomolos ay kaman met laeng ed idi.” Ngem adi na ammo ay tinaynan Diyos sisya. ");
INSERT INTO kne_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Dinpap din Filisteo si Samson, pag dan sokiten din dowa ay mata na, asi dan iballalong ed Gaza. Kinadinaan das bronsi et nan-gilgilingen das bakakew sin balodan. ");
INSERT INTO kne_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Ngem ginmabay kasin din book na. ");
INSERT INTO kne_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Idi siya di, nasinop din papangolon di Filisteo ta manragsak da ya man-idaton das ad-ado ay animal en Dagon ay diyos da. Kanan da ay nangikanta, “Inabak tako si Samson ay kaibaw tako, tan tinmolong din diyos tako.” ");
INSERT INTO kne_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","25","Idi enggay mabetbeteng da, kanan da ay nangibogaw, “Ibala yo si Samson ta paragsakenas datako!” Inbala da si Samson sin balodan et inpapika da sin nan-gawaan di tokod. Sin namoyboyaan din kaipoipogaw en sisya, nankanta da ay nangidaydayaw sin diyos da. Kanan da, “Inpalobos din diyos tako ay abaken tako din kaibaw ay nanadael sin daga tako ya namse si ad-ado ay gait tako.” ");
INSERT INTO kne_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Idi siya di, kanan Samson sin anak ay mangitaktakkay en sisya, “Ipakapay mon sak-en din tokod ay nananggen isnan beey tan laydek ay mansadag.” ");
INSERT INTO kne_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Napno din beey si lallalaki ya babbabai yan wadas di amin din papangolon di Filisteo. Wada abey toloy libo ay ipogaw sin balkon ay mamoyboya en Samson. ");
INSERT INTO kne_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Pag kanan Samson ay nankararag en Diyos, “Diyos ay Kangatoan, nemnemem kod sak-en. Pangaasim kod ta papigsaem sak-en si para mamingsan anggoy. Ipalobos mo kod ta mamingpingsan ay baesak da nan Filisteo sin inyat da sin doway matak.” ");
INSERT INTO kne_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Pag kapayen Samson din doway tokod sin gawa ay dadlon nananggen sin timplo, din kannawan sin esa yan din kannigid sin esa. ");
INSERT INTO kne_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Pag nan kanan, “Ipalobos mo koma ay makikateyak en dana ay Filisteo!” Inpeey na am-in ay pigsa na ay nangitodon et pag matokang din timplo ay nanab-ok sin papangolo ya din amin ay ipogaw ay wadas di. Isonga ad-ad-ado di pinsen Samson sin timpo ay nateyana mo sin odom ay agew ay nanbibiyagana. ");
INSERT INTO kne_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Nanballalong din aag-i na ya toton-od na ay en nangisaa sin bangkay na, et inponpon da sin naipay-an Manoa ay ama na sin nan-gawaan di Zora ya Estaol. Dowanpo ay tawen di nangipangoloan Samson sin Israelita. ");
INSERT INTO kne_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Ed bayag, sin timpon di papangolo ay insaad Diyos ay manturay ed Israel, waday sin-asawa ay polin Efrata ay da Elimelec en Naomi ay taga-Betlehem ay sakop di Juda. Dodoway anak da ay da Malon en Kilion. Idi domteng di betil sin ili da, en da nanbeey ed Moab. Sin kawada das di, ");
INSERT INTO kne_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","natey si Elimelec et tinaynana si Naomi ya din dowa ay anak da. ");
INSERT INTO kne_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Din an-ak da ay nay et nangasawa das Moabita ay babbabai ay da Orpa en Ruth. Idi malabas di emey ay sinpo ay tawen, ");
INSERT INTO kne_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","natey abes da Malon en Kilion et nataynan si Naomi ay namaga din an-ak na ya si asawa na. ");
INSERT INTO kne_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Idi wada da pay laeng ed Moab, dinamag Naomi ay binindisyonan Diyos din ipogaw na si mayat ay apit, isonga nansagana da ay mantaoli sin ili na ay kakoyog na din dowa ay innapo na. ");
INSERT INTO kne_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Tinaynan da din ili ay nantetean da, ngem idi wada da sin danan ay emey ed Juda, ");
INSERT INTO kne_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","kanan Naomi en daida, “Somaa kayo sin beey da ina yo et sapay koma ta seg-angan Yahweh si dakayo ay kaman din kasiged yo en sak-en ya sin natey ay an-ak ko. ");
INSERT INTO kne_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Sapay koma ta ipalobos na ay makiasawa kayo kasin ya mawad-an kayo si pamilya.” Pag nan ongoan daida, ngem nan-oga da ");
INSERT INTO kne_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","yan kanan da en sisya, “Aga, makisaa kami en sik-a sin kad-an di kailiam.” ");
INSERT INTO kne_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ngem kanan Naomi, “Dakayo ay anak ko, masapol ay somaa kayo. Sinoy gapo ay makisaa kayo en sak-en? Ay siya mo man-anakak pay laeng si mangasawa en dakayo? ");
INSERT INTO kne_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Somaa kayo et tan nay enggay nabakesak et adi mabalin ay makiasawaak. Olay pay mo kanak en way namnamak ta makiasawaak ed wani ay labi ya man-anakak, ");
INSERT INTO kne_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ay tan sed-en yo enggana ay madakdake da? Ay adi kayo mangasawa begew en daida? Ay an-ak ko, adi mabalin. Mansakit kayman di nemnem ko isnan napasamak en dakayo gapo ta dinokogan Diyos sak-en.” ");
INSERT INTO kne_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Nan-oga da kasin din innapon Naomi, pag ongoan Orpa sisya ta manpakada et sinmaa, ngem pinopomket pay si Ruth en sisya. ");
INSERT INTO kne_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Kanan Naomi, “Somaa ka et adi abe. Ilam si abbilat mo et sinmaa sin kad-an di kailiana ya didiyosen da.” ");
INSERT INTO kne_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ngem kanan Ruth, “Adi ka kod kedawen di panaynanak en sik-a. Ipalobos mo koma ay makieyak en sik-a olay intoy em-emeyam. Makiteeak en sik-a olay intoy panbeeyam. Din kailiam et say kailiak ya din Diyos mo et say Diyos ko. ");
INSERT INTO kne_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Mo intoy kateyam, say kateyak abe ya kaiponponak. Olay domosas Diyos mo ipalobos ko di olay sino ay makagapo si pansianan ta, malaksig si pese.” ");
INSERT INTO kne_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ginminek si Naomi idi ilaena ay ipapatin Ruth ay makiey en sisya. ");
INSERT INTO kne_vpl VALUES ("RT1_19a","009_1_19a","RUT","1","19a","19a","Et intoloy da ay nandan enggana ay dinmateng da ed Betlehem. ");
INSERT INTO kne_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Waday lalaki ay manngadan si Elkana ay polin Efraim ay man-ili ed Rama sin kadondontogan ay sakop di Efraim. Sisya din anak Jeroham ay anak Elihu ay anak Tohu ay anak Zuf. ");
INSERT INTO kne_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Dowa di asawan Elkana ay da Hanna en Peninna. Waday an-ak Peninna ngem basig pay si Hanna. ");
INSERT INTO kne_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Tinawtawen ay emey da Elkana ed Shilo ay en mandayaw ya man-idaton en Diyos ay Kangatoan ay Turay. Sin isdi, da Hofni en Finehas ay an-ak Eli di papadi ay mansilsilbi en Diyos. ");
INSERT INTO kne_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Tonggal man-idaton si Elkana, idawtanas da Peninna ya din an-ak na si sag-eesa ay bingay da sin karni. ");
INSERT INTO kne_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Ngem si Hanna pay, dobli di bingay na tan laydelaydena iman sisya olay mo binasig Diyos. ");
INSERT INTO kne_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Kanayon ay sinsiniten Peninna ay karibal na et pasadotena gapo sin kaiwed di anak na. ");
INSERT INTO kne_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Kanayon ay say mapasamak nas tinawtawen. Tonggal emey da sin beey Diyos, pasadoten Peninna si Hanna enggana ay man-oga ya sigaana ay mangan. ");
INSERT INTO kne_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Et kanayon abe ay damagen Elkana, “Apay nga man-og-oga ka ya sigaam ay mangan? Sinoy gapo ay kanayon ay pansasadotam? Ay bakenak ayan napatpateg en sik-a mo sinpo ay anak?” ");
INSERT INTO kne_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Sin namingsan ay kawada da sin beey Diyos ed Shilo, kapika si Hanna sin nakdengan da ay nangan. Palalo di ladingit na, isonga man-og-oga ay nankararag en Diyos. Sin nangam-amaganas di, wada din padi ay si Eli sin tomoktokdoana sin sag-en di pantew di Timplon Diyos. ");
INSERT INTO kne_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Kanan Hanna ay nansapata, “Diyos ay Kangatoan ay Turay, maseg-ang ka kod paabe ta nemnemem sak-en sinan ligat ko. Mo seg-angam sak-en ay bag-en mo ta omya ka si anak ay lalaki, ikarik ay idaton kos sisya ay mansilbi en sik-a si tongpal biyag na et adi polos mapokpokisan.” ");
INSERT INTO kne_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Intoltoloy Hanna ay nankarkararag en Diyos si nabayag yan iilaen Eli din tepek na. ");
INSERT INTO kne_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Adi madnge din kararag na tan adi na ipigsa, ngem maila din tepek na ay mantitiyam et inpagarup Eli en nabeteng, ");
INSERT INTO kne_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","isonga kananan sisya, “Ay nabeteng ka? Pig-an pay ay maimosngan ka ya isaldeng mo san kabebeteng mo?” ");
INSERT INTO kne_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Ngem kanan Hanna ay sinombat, “Apo, adiak met damdaman nabeteng tan adiak polos nan-in-inom si arak ono kompormi ay bemeteng, ngem ipappapas ko anggoy ay mangibaga si liknak en Diyos. ");
INSERT INTO kne_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Adi ka koman ipagarup en magay silbi na ay babai nan baam, tan palalo di ladingit ko ay mankarkararag.” ");
INSERT INTO kne_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Pag kanan Eli, “Emey ka ay natalna di nemnem mo. Sapay koma ta idawat Diyos ay daydayawen tako ay Israelita din kedkedawem.” ");
INSERT INTO kne_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Songbatan pay Hanna yan kanana, “Sapay koma ta itoloy mo san seg-ang mo en sak-en.” Pag komaan et en nangan yan namaga din sakit di nemnem na. ");
INSERT INTO kne_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Nasapas da Elkana sin pamilya na ay binmangon sin kabigatana. Idi makdeng ay mandayaw da en Diyos, sinmaa da ed Rama. Dinaag Elkana si Hanna ay asawa na et pinatgan Diyos din kararag na. ");
INSERT INTO kne_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Nawad-an et man-anak pay yan lalaki ay nginadananas Samuel tan kanana, “Kindaw ko iman en Diyos.” ");
INSERT INTO kne_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Dinomteng kasin din timpo ay emeyan da Elkana ay sinpamilya ed Shilo ta man-idaton sin maidatdaton si tinawen ya ta tongpalena din inkari na. ");
INSERT INTO kne_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Ngem adi nakiey si Hanna tan kanana en asawa na, “Awni ta mapsot din anak ta asiak iey sin beey Diyos ta isdi ay mantee si tongpal biyag na.” ");
INSERT INTO kne_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","“May ngarud,” kanan Elkana ay nanongbat, “mo intoy kosto si pannemnem mo, say amagem. Mantetee ka enggana ay posotem. Sapay koma ta ipatongpal Diyos san karim.” Et nantee si Hanna sin beey da ay namaspasoso ya nangay-ayowan sin anak na. ");
INSERT INTO kne_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Makdeng pay ay posotena si Samuel, in-ey da sin beey Diyos ed Shilo olay mo an-anak pay laeng sisya. Nan-itakin das bomaro ay baka ay toloy tawena, sinpo ay kilo ay arina ya arak ay naipeey si sopot ay lalat. ");
INSERT INTO kne_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Idi makdeng ay paltien da din baka, in-ey da din anak sin kad-an Eli. ");
INSERT INTO kne_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Pag kanan Hanna en sisya, “Wada kod di ibagak en sik-a ay apo. Ay manemnem mo si sak-en? Sak-en adi din babai ay doy ay pinmipikas na ay mankarkararag en Diyos. ");
INSERT INTO kne_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Kindaw kon Diyos din anak ay nay yan nay iman ay pinatgana din kararag ko. ");
INSERT INTO kne_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Isonga ed wani, idaton kos sisya ta mansilbi en Diyos engganas tongpal biyag na.” Makdeng pay di, dinaydayaw da si Diyos isdi. ");
INSERT INTO kne_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Kanan Hanna ay nankararag, “Palaloy layad ko begew en Diyos Apo! Tan inmipangato ya indawat nay bikas ko. Mabalin ay siyekak din kalaban ko, maragsakanak tan tinmolong si Diyos Apo. ");
INSERT INTO kne_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Magay nasantoan ay kaman din Diyos tako, maga polos di makaiso. Magay odom ay komakaman ay pankamangan tako mo adi et si Diyos Apo. ");
INSERT INTO kne_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Adi kayon palpalaloan san panlaslastogan yo, isaldeng yo san natangsit ay panagkalkali yo. Tan si Diyos ay makaammo si amin et okomena amin ay inam-amag di ipogaw tet-ewa. ");
INSERT INTO kne_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Din napipigsa ay soldado et magotlo din pana da, ngem din nakapsot et pomigsa da. ");
INSERT INTO kne_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Din mansobsobra ed idi si kanen da, makilagbo dad wani ta mangan da. Ngem din madagdagaangan ed idi et laton da ed wani. Din basig et nakaanak si pito da, ngem din ina ay ad-adoy anak na et nataynan ay magay olay esa. ");
INSERT INTO kne_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Si Diyos et ena peslen ya biyagen, ipababa nay ipogaw sin kad-an di natey ya kasinan tagoen. ");
INSERT INTO kne_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Waday pabitegena, waday pabaknangena, waday ipababa na, wada abey ipangato na. ");
INSERT INTO kne_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Din nababa ya kaseseg-ang di kasasaad da, et ipangato na ya kaanenan kaibabainan da. Pakitokdoenas daida sin ipogaw ay way banol na, et nangato ay turay di pangisaadana en daida. Din naisaadan di lobong, si Diyos di akin oka, sisya di nangisaad isnan daga. ");
INSERT INTO kne_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Ay-ayowanana din biyag di ipogaw na, ngem din managbasol et sin mabolinget ay kad-an di natey di panturongan da, tan adi mabalin ay matago di ipogaw si bokbokod na ay pigsa. ");
INSERT INTO kne_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Dadlon abaken Diyos din kalabana, tan kaman kido ay mapod daya ay bomaba sin kad-an da. Kadi et okomena am-in ay ipogaw isnan daga. Idawtanas panakabalin din ari ay pinili na ta say sisya di pangabakena.” ");
INSERT INTO kne_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Idi makdeng di, sinmaas da Elkana ed Rama, ngem nataynan si Samuel ay anak da ed Shilo ta mansilbi en Diyos sin babaen Eli ay padi. ");
INSERT INTO kne_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Tinawtawen ay man-amag si Hanna si nagayad ay bado ay idawat nan Samuel mo maikoyog en asawa na ay man-idaton sin idatdatonas tinawtawen. ");
INSERT INTO kne_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Pag bindisyonan Eli da Elkana ay sin-asawa yan kanana, “Sapay koma ta idawtan Diyos dakayo sin asawam ay nay si odom ay anak ay kasokat din indaton yo ay nay ay mansilbi en sisya.” Makdeng pay di yan sinmaa da. ");
INSERT INTO kne_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Pag bindisyonan tet-ewan Diyos si Hanna et indawtanas tolo ay anak ay lalaki ya dowa ay babai. Mo si Samuel pay et nadakdakdake ay mansilsilbi en Diyos. ");
INSERT INTO kne_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Nasepsep abe ay laylayden Diyos ya din kaipoipogaw sisya. ");
INSERT INTO kne_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Sin timpo ay doy ay nansilsilbian Samuel en Diyos sin babaen Eli, at-atik anggoy di inpaammo ono inpailan Diyos babaen si pankalkaliana. ");
INSERT INTO kne_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Sin esay labi, si Eli ay enggay magodgodab yan naseseyep sin kowarto na. ");
INSERT INTO kne_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Si Samuel pay yan naseyep sin Timplo ay kad-an di Baol di Tolagan. Idi dandani ay parbangon yan manbidbidang pay laeng din silaw, ");
INSERT INTO kne_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","kinalian Diyos si Samuel. Songbatan pay Samuel yan kanana, “Aw, apo, sanaak.” ");
INSERT INTO kne_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Kabangon pay yan nanagtag sin kad-an Eli ay kanana, “Naeyak ay apo tan doy inmayag ka.” Ngem kanan Eli, “Adiak met inayagan sik-a. Mantaoli ka et ta en ka maseyep.” Siya di, en kasin binmaktad si Samuel. ");
INSERT INTO kne_vpl VALUES ("S13_6","010_3_6","1SA","3","6","7","Kinalian kasin Diyos si Samuel. Adi na pay laeng ammo ay si Diyos din nankali, tan adi polos nakikalkali en sisya ed idi. Isonga kabangon ay inmey sin kad-an Eli yan kanana, “Kinaliam sak-en et naeyak ay apo.” Kanan Eli, “Ay anak ko, adiak met kinalian sik-a. Mantaoli ka ay maseyep.” ");
INSERT INTO kne_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Kasin kinalian Diyos si Samuel si maikapitlo et kabangon yan inmey kasin sin kad-an Eli yan kanana, “Inmayag ka ay apo et naeyak.” Pag et nemnemen Eli ay si Diyos din mangalkali sin anak, ");
INSERT INTO kne_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","isonga kananan sisya ay nangibilin, “Mantaoli ka sin kaseyseypam, et mo kalian daka kasin yan kanam ay manongbat, ‘Apo Diyos, sino di? Nay mandengdengeak ay baam.’” Et siya di, en binmaktad kasin si Samuel. ");
INSERT INTO kne_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","En pinmikas Diyos sin kad-an Samuel yan kinaliana ay kaman sin damo. “Samuel, Samuel,” kinwani na. Songbatan pay Samuel yan kanana, “Sino di? Tan nay mandengdengeak ay baam.” ");
INSERT INTO kne_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Pag kanan Diyos en sisya, “Dengngem nan ibagak: Domteng to di agew ay waday kaeegyat ay amagek sin Israelita et makibtot amin ay mannge. ");
INSERT INTO kne_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Sin doy ay timpo, dadlonak ipatongpal am-in ay inbabagak maikontra sin pamilyan Eli. ");
INSERT INTO kne_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Indadaan ko en sisya en keddengak din pamilya na ay madosa ay eng-enggana, tan din an-ak na yan inmipalawlawa da. Ammon Eli na ay am-amagen da ngem adi na inpasaldeng daida. ");
INSERT INTO kne_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Gapo sidi, insapatak ay adi polos mabalin ay mapakawan din basbasol di pamilyan Eli babaen si animal ya odom ay maidaton.” ");
INSERT INTO kne_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Binmaktad si Samuel enggana ay naaggew et pag nan bokatan din pantew di beey Diyos. Emegyat ay manad-at en Eli sin naipaammo en sisya, ");
INSERT INTO kne_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","ngem kinalian Eli sisya ay kanana, “Ay anak ko ay Samuel.” “Sinoy ibagam?” kanan Samuel ay nanongbat. ");
INSERT INTO kne_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Kanan Eli ay nandamag, “Sinoy inbagan Diyos en sik-a? Ibagam amin ay magay isaot mo, tan palalo ay dosaen dakan Diyos mo way olay sino ay isaot mo.” ");
INSERT INTO kne_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Et inbagan Samuel ay magay insassaot na. Pag kanan Eli, “Diyos sisya et amagena din kosto sin pangila na.” ");
INSERT INTO kne_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Kinadkadwan Diyos si Samuel sin nadakdak-ana et inpatet-ewan Diyos amin din inbaga na, ");
INSERT INTO kne_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","isonga inammoan din amin ay ipogaw sin intiro ay Israel ay pankalkalian Diyos sisya. ");
INSERT INTO kne_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Nabayag di kawadan din Baol di Tolagan sin siyodad ay Kiriat Jearim. Wadas di si dowanpo ay tawen. Sin doy ay timpo, nanladladingit amin din Israelita ya nan-ad-adawag dan Diyos. ");
INSERT INTO kne_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Pag kanan Samuel en daida, “Mo tet-ewa ay sagongen yo si Diyos, dokogan yo ngarud din didiyosen di odom ay il-ili ya iwasit yo din rebolto ay kais-isoan Astarte. Imongsan yo abe di nemnem yo en Diyos yan sisya anggoy di pansilbian yo. Mo say iyat yo, isalakanas dakayo sin Filisteo.” ");
INSERT INTO kne_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Et inwasit din Israelita din rebolto ay kais-is-oan da Baal en Astarte yan si Diyos et anggoy di dinaydayaw da. ");
INSERT INTO kne_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Idi siya di, inbilin Samuel ay masinop amin din Israelita ed Mizpa ta manpakaasis sisya en Diyos para en daida, ");
INSERT INTO kne_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","tan ed Mizpa di nantean Samuel ay nangituray en daida. Et nasinop das di yan nanakdo das danom ay insoyat da sin sangoanan Diyos. Sin doy ay agew, initpe day dagaang da yan kanan da, “Nanbasol kami en Diyos.” ");
INSERT INTO kne_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Idi nadamag din Filisteo ay nasinop din Israelita ed Mizpa, nanlobwat din papangolo da ya din sosoldado da ta en da gobaten din Israelita. Inmegyat din Israelita sin nanngean da. ");
INSERT INTO kne_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Kanan dan Samuel, “Adi ka somaldeng ay mankarkararag en Yahweh ay Diyos tako ta isalakanas datako sin Filisteo.” ");
INSERT INTO kne_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Pinaltin Samuel di mansossoso ay olbon di karnero yan inpoo na ay sibobokel ay indatona en Diyos. Nankararag ay nankedaw si badang Diyos sin Israelita yan pinatgan Diyos din kararag na. ");
INSERT INTO kne_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Idi man-idatdaton pay laeng si Samuel, enggay dinmateng din Filisteo ay mangobat sin Israelita. Ngem inpawadan Diyos di kaeegyat ay man-agodood ay kido ay nangibtot ya nangolo en daida. Tinmanagtag din Filisteo et nansisian da. ");
INSERT INTO kne_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Pag bomala din lallalaki ay Israelita ed Mizpa yan inapayaw da din Filisteo engganad Betcar et ad-adoy pinse da sin danan. ");
INSERT INTO kne_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Idi makdeng di, nan-a si Samuel si bato ay tinood na sin nan-gawaan di Mizpa ya Sen, yan nginadananas Ebenezer tan kanana, “Sinay di panginemnemneman sin badang Diyos en datako.” ");
INSERT INTO kne_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Naabak din Filisteo et adi da kasin in-inmey sin sakop di Israel tan kanayon ay kinonkontran Diyos daida sin timpo ay sibibiyag si Samuel. ");
INSERT INTO kne_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Idi makay si Samuel, dinotokana din an-ak na ay papangolon di Israel. ");
INSERT INTO kne_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Si Joel din pangpangoan yan si Abias din iyogtana, daida di pangolo ed Beerseba. ");
INSERT INTO kne_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Ngem adi dan inonodan ogalin ama da, tan din pilak anggoy di ginamgamgaman da et inawat da di pasoksok, isonga baken kostoy inyaat da ay nangowis. ");
INSERT INTO kne_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Idi siya di, natopog din papangolon di Israel et inmey da en Samuel ed Rama. ");
INSERT INTO kne_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Kanan da en sisya, “Enggay ay nakay ka asi et nan an-ak mo yan adi dan onodan din ogalim, isonga mandotok ka et si ari ay mangituray en dakami ta kaman kamin din odom ay ili ay way ari da.” ");
INSERT INTO kne_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Adi linayad Samuel din nankedawan das ari, isonga nankararag en Diyos, ");
INSERT INTO kne_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","ngem kanan Diyos en sisya, “Awem amin din ibagan di ipogaw en sik-a. Baken sik-a di sinigaan da mo adi et sak-en di sinigaan da ay ari da. ");
INSERT INTO kne_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Manipod pay dedan sin nangipangpangoak en daida ay komaan ed Egipto, dinokogan das sak-en et nandaydayaw das odom ay sinan didiyos yan nay et ay say iyat da aben sik-a din kanayon ay inam-amag dan sak-en. ");
INSERT INTO kne_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Isonga pagostoam iman din layden da, ngem dadlon kan idadaan ya ilawlawag di iyat di ari ay mangituray en daida.” ");
INSERT INTO kne_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Inbagan Samuel sin kaipoipogaw ay mankedkedaw si ari din amin ay inbagan Diyos en sisya. ");
INSERT INTO kne_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Kanana ay nangilawlawag, “Siya na di amagen di ari yo en dakayo: panbalinenan to ay sosoldado na din aan-ak yo ay lalaki. Mansilbi din odom ay manlogan si kalisa ay para gobat, mangabayo din odom, yan din odom abe et daida din managtag ay mamangpango mo din nanlogan si kalisa ay pakigobat. ");
INSERT INTO kne_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Panbalinena din odom ay mangipangolo si sagsisinlibo yan din odom et mangipangolo si saglilimapolo. Pilitena abe din an-ak yo ay mangalado sin papayew na ya man-apit sin molmola na. Daida abe di man-amag si armas ya kasapolan sin kalisa na. ");
INSERT INTO kne_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Panbalinena abe din an-ak yo ay babbabai ay para man-am-amag si bangbanglo ya para oto ay mansilbi en sisya. ");
INSERT INTO kne_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Alaena din kamayatan ay papayew yo ya minolaan yos obas ya olivo ta idawat na sin oopisyal na. ");
INSERT INTO kne_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Masapol ay man-idawat kayo si inkasinpon di anien yo ya borasen yo ay obas para sin oopisyal ay mansilsilbi sin palasyo na ya odom pay ay oopisyal na. ");
INSERT INTO kne_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Alaena din babag-en yo, baka ya kamel yo ay man-obla para en sisya. ");
INSERT INTO kne_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Alaena abe di inkasinpon di karnero ya kalding yo. Pati si dakayo et manbalin ay bag-ena. ");
INSERT INTO kne_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Awni et sin timpo ay kapasamakan nidi, asi kayo pay manpakpakaasi begew sin ari ay pinili yo, ngem sigaan Diyos ay mannge en dakayo.” ");
INSERT INTO kne_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Ngem adi inkaskason din ipogaw din inbagan Samuel, isonga kanan da, “Aga, layden mi di ari ay mangituray en dakami ");
INSERT INTO kne_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","ta kaman kami aben din odom ay ili ay iturayan di ari ta say mangipangolo en dakami ay makigobat.” ");
INSERT INTO kne_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Dinngen Samuel amin ay inbaga da et ena idad-at en Diyos. ");
INSERT INTO kne_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Kanan Diyos ay nanongbat, “Tongpalem din kedkedawen da ta idawtam daidas ari.” Idi makdeng di, inpasaan Samuel amin din ipogaw. ");
INSERT INTO kne_vpl VALUES ("S19_1a","010_9_1a","1SA","9","1a","1a","Wada et di mabigbig ay baknang ay manngadan si Kis sin tribun Benjamin. ");
INSERT INTO kne_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Wada abey nadakdake ay anak na ay si Saulo ay mabikas ya gowapo. Nagogowapos sisya mo din am-in ay kailiana ay Israelita ya nakaykayang pay si esay piya mo si daida am-in. ");
INSERT INTO kne_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Sin namingsan, tinmagtag di odom ay dangkin Kis, et kanana en Saulo ay anak na, “Man-ayag kas esa ay baa ay gait mo ta en kayo anapen din dangki.” ");
INSERT INTO kne_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Kambaw sakbay din agew ay doy, waday inpaammon Diyos en Samuel ay kanana, ");
INSERT INTO kne_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Si bigat sin kaman nina ay oras, waday ibaak en sik-a ay lalaki ay napo sin sakop di Benjamin. Soyatam din toktok na si lana ay mangipaila ay dinotokak sisya ay mangituray sin ipogaw ko ay Israelita. Isalakanas daida sin panakabalin di Filisteo, tan inilak din napalpaligatan da ya dinngek din adawag da.” ");
INSERT INTO kne_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Sin kosto ay nangilaan Samuel en Saulo, kanan Diyos en sisya, “Si naey di inbagak en sik-a. Sisya di mangituray sin ipogaw ko.” ");
INSERT INTO kne_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","“Mangon-ona ka ay manballalong ed Gilgal. Sem-ed kas di si pito ay agew. Asiak datngan dakayo ta man-idatonak si animal ay mapooan ya datdaton abe ay pakikadkadwaan tako en Diyos. Asiak aben ibaga en sik-a din amagem.” ");
INSERT INTO kne_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Baken nabayag yan pinaayagan Samuel din kaipoipogaw ta matopog da ed Mizpa ay mandayaw en Diyos. ");
INSERT INTO kne_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Pag nan kanan en daida, “Siya na di kanan Yahweh ay Diyos tako ay Israelita: ‘Inpangok si dakayo ay komaan ed Egipto ta mawayaan kayo sin pamabag-enan da ya sin odom ay ipogaw ay mamalpaligat en dakayo.’ ");
INSERT INTO kne_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Ngem nay ed wani yan dinokogan yos Diyos yo ay nangisalakan en dakayo sin amin ay ligligat yo, tan kindaw yo ay idawtak dakayo si ari yo. May ngarud, mo say kanan yo, magrupo kayo ay manpaila sin sangoanan Diyos insigon sin tribu ya pamilya yo.” ");
INSERT INTO kne_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Idi siya di, inayagan Samuel di tonggal tribu sin sango, et pinilin Diyos din tribun Benjamin. ");
INSERT INTO kne_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Pag saes-aen Samuel ay ayagan sin sango din papamilya sin tribun Benjamin et napili din pamilyan Matri. Nantongpalana yan si Saulo ay anak Kis di napili, ngem idi anapen das sisya, iwed ay maila da, ");
INSERT INTO kne_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","isonga kanan da en Diyos, “Ay inmalis sisya?” Pag kanan Diyos ay nanongbat, “Wadas Saulo ay nantatabon sin likod di nakapin ay karga.” ");
INSERT INTO kne_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Katagtag da ay en nangayag en sisya et idi nakipipika en daida, say nangilaan da ay nakaykayang si esay piya mo daida amin. ");
INSERT INTO kne_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Pag kanan Samuel sin kaipoipogaw, “Si nay di lalaki ay pinilin Diyos. Magay makaiso si olay esa en datako.” Idi siya di, bomanogaw da ay nangwani, “Matagotago din ari!” ");
INSERT INTO kne_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Pag kanan Samuel sin kaipoipogaw, “Tinongpal ko amin ay inbaga yo et nay insaad ko di ari ay mangituray en dakayo. ");
INSERT INTO kne_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Ed wani, nay din ari ay pinili yo ay kindaw yo et nay insaad Diyos ay mangituray en dakayo. ");
INSERT INTO kne_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Siged di pantongpalan yo mo say amagen yo dana, dakayo ya din ari yo: dayawen ya patgen yos Yahweh ay Diyos tako, mansilbi ya mantongpal kayon sisya ya adi kayon konkontraen din bilina. ");
INSERT INTO kne_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Ngem no adi kayon tongpalen si Diyos ta kontraen yo din bilbilina, dosaena abes dakayo ya din ari yo ay kaman din inyat na sin aap-o yo. ");
INSERT INTO kne_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Ed wani, iginek yo ta ilaen yo di nakaskasdaaw ay amagen Diyos. ");
INSERT INTO kne_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Ed wani et tiyagew ay pinag-aani si bakakew, ay baken siya? Mankararagak en Diyos ta mankido ya man-odan, et say pangammoan yo en madagsen ay basol yo en Diyos din nankedawan yos ari.” ");
INSERT INTO kne_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Nankararag si Samuel et sin doy met laeng ay agew, mankido dowan man-odan, isonga din kaipoipogaw yan inmegyat dan Diyos ya en Samuel. ");
INSERT INTO kne_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Kanan da en Samuel, “Pangaasim kod ay apo ta ikararagam dakami en Yahweh ay Diyos mo ta adi kami matey. Inammoan mi ed wani ay malaksig sin odom pay ay basbasol mi, nanbasol kami baw kayman sin nankedawan mi si ari.” ");
INSERT INTO kne_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Ngem kanan Samuel, “Adi kayon emegyat. Olay mo siya di ay madagsen di nanbasolan yo en Diyos, adi kayon dokogan sisya, mo adi et imongsan yo din amin ay nemnem yo ay mansilbi en sisya. ");
INSERT INTO kne_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Adi kayon masangsangaw si sinan didiyos ay adi makabadang ya makaisalakan en dakayo, tan magay silsilbin dadi. ");
INSERT INTO kne_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Gapo sin madaydayaw ay ngadan Diyos, adi nan baybay-an dakayo, tan ninemnem na ay panbalinenas dakayo ay ipogaw na. ");
INSERT INTO kne_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Mo maipanggep en sak-en, sapay koma ta adi ipalobos Diyos ay bomasolak en sisya gapo sin panliwayak ay mangikararag en dakayo. Say amagek et koma din mangitdoak en dakayo sin kosto ya siged. ");
INSERT INTO kne_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Ngem masapol ay egyatan ya patgen yos Diyos. Ipapasnek yo ya imongsan yo din amin ay nemnem yo ay mansilbi en sisya. Nemnemen yo din nakaskasdaaw ay inam-amag na para en dakayo. ");
INSERT INTO kne_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Ngem mo ipapati yo ay mangamag si lawa, matey kayo am-in, pati din ari yo.” ");
INSERT INTO kne_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Idi siya di, pinilin Saulo di tolo ay libo sin lalaki ay Israelita. Dowa ay libo di kinmoyog en sisya ed Micmas ya sin kadondontogan ay ili ay Betel yan sinlibo di gait Jonatan ed Gibea ay sakop di tribun Benjamin. Inpasaa na amin din odom. ");
INSERT INTO kne_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Pinsen Jonatan din kapitan di sosoldado ay Filisteo ay nankampo ed Geba et dinamag din Filisteo. Pag ibilin Saulo ay mananggoyob da ta matopog amin ay Hebreo ta makigobat da. ");
INSERT INTO kne_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Naipadamag sin amin ay Israelita din namsean Saulo sin kapitan di sosoldadon di Filisteo ya din pangililigetan din Filisteo en daida, isonga pinati dan naibilin ay maitapi da en da Saulo ed Gilgal. ");
INSERT INTO kne_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Natopog din Filisteo ta gobaten da din Israelita et waday tolo ay libo ay kalisa ay para gobat, enem ay libo ay nangabayo ya adi kabilang ay sosoldado ay kaman din kaad-adon di darat sin benget di baybay. En da nankampo ed Micmas sin naibandas belaan di agew ed Bet-aven. ");
INSERT INTO kne_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Idi ilaen din Israelita ay masmaskok da ya dilikado di kasasaad da, nantabon day odom sin liyang, longog, abot, batbato ya bobon. ");
INSERT INTO kne_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Din odom yan inagadang da din ginawang ay Jordan et inmey da sin sakop di Gad ya Gilead. Nataynan si Saulo ed Gilgal, ngem enggay manpayegpeg das egyat da din sosoldado ay kadwa na. ");
INSERT INTO kne_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Nanseed si pito ay agew tan siya din inkeddeng Samuel, ngem iwed pay laeng si Samuel ay domateng ed Gilgal et enggay ilogin din sosoldadon Saulo ay mansisian. ");
INSERT INTO kne_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Isonga kanan Saulo, “Iali yo din daton ay mapooan ya din datdaton ay pakikadkadwaan tako en Diyos.” Et indatona din mapooan. ");
INSERT INTO kne_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Idi kakkakdeng na ay nangidaton, pag et domateng si Samuel et inabat Saulo ay kinablaawan. ");
INSERT INTO kne_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Ngem kanan Samuel, “Ay sino pay nas inamag mo?” Kanan Saulo ay nanongbat, “Tan enggay to met ay tomaynan din sosoldado yan maga ka pay laeng sin timpo ay inbagam ay domatngam dowan et masinsinop din Filisteo ed Micmas. ");
INSERT INTO kne_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Kanak en gobaten din Filisteo si sak-en isnan Gilgal yan adiak pay laeng nankedaw si seg-ang Diyos, isonga ninemnem ko en kapilitan ay idaton ko din daton ay mapooan.” ");
INSERT INTO kne_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Ngem kanan Samuel, “Inoong-ong sas inamag mo. Adi kan tinongpal din inbilin Yahweh ay Diyos mo en sik-a. Mo tinongpal mo koma et insaad Diyos sik-a ya din polim ay mangituray isnan Israel si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Ngem ed wani, adi mantoltoloy din panturayam, tan waday pinili ya dinotokan Diyos ay peteg ay laydelaydena ay mangipangolo sin ipogaw na gapo ta adi ka tinongpal din bilina.” ");
INSERT INTO kne_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Sin namingsan, kanan Samuel en Saulo, “Sak-en di inbaan Diyos ay nangdotok en sik-a ay man-ari sin ipogaw na ay Israelita, isonga ed wani dengngem din ipaammon Diyos. ");
INSERT INTO kne_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Siya na di kanan Diyos ay Kangatoan ay Turay, ‘Dosaek din Amalekita, tan ginobat din aap-o da din Israelita sin napoan da ed Egipto. ");
INSERT INTO kne_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Ed wani, en kayo gobaten din Amalekita ta golpien yo ay dadaelen amin ay sanikwa da. Magay palobosan yo ay matago en daida. Peslen yo amin ay lalaki, babai, anak ya moyang pati din baka, karnero, kamel ya dangki.’” ");
INSERT INTO kne_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Idi siya di, ginobat Saulo din Amalekita manipod ed Havila engganad Shur ay naibandas belaan di agew ed Egipto. ");
INSERT INTO kne_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Dinpap na ay sibibiyag si Agag ay arin di Amalekita yan pinse das kampilan amin din ipogaw na. ");
INSERT INTO kne_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Ngem adi pinsen Saulo ya din sosoldado na si Agag ya din kamayatan ay kakarnero ya baka, din kalamesan sin an-ak di baka ya karnero, ya din amin ay nabanol et adi dan ginolpi ay dinadael. Ngem say dinadael da din amin ay lawlawa ay magay silbi na. ");
INSERT INTO kne_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Idi siya di, nankali si Diyos en Samuel yan kanana, ");
INSERT INTO kne_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Manbabawiak ay nangisaad en Saulo ay ari. Dinokoganas sak-en et adi nan tinongpal din bilin ko.” Manbonget si Samuel et naninsinlabi ay nankararag en Diyos sin labi ay doy. ");
INSERT INTO kne_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Sin kabigatana, nasapa si Samuel ay en nanganap en Saulo, ngem waday nangibaga ay inmey si Saulo ed Carmel yan waday tinood nas di ay panginemnemneman da en sisya, pag manballalong ay emey ed Gilgal. ");
INSERT INTO kne_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Idi datngen Samuel sisya, kanan Saulo, “Bindisyonan daka koman Diyos. Tinongpal ko din inbilina.” ");
INSERT INTO kne_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Ngem kanan Samuel, “Et apay ngarud san madmadngek ay kalin di karnero ya kangan di baka?” ");
INSERT INTO kne_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Kanan Saulo ay nanongbat, “Inan din sosoldado sin Amalekita. Adi dan pinse din kamayatan sin karnero ya baka ta maidaton en Yahweh ay Diyos mo, ngem pinse mi amin din odom.” ");
INSERT INTO kne_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","“Iginek mo!” kanan Samuel en Saulo. “Ibagak en sik-a di inpaammon Diyos en sak-en ed labi.” “Dad-atem kod,” kanan Saulo ay nanongbat. ");
INSERT INTO kne_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Kanan Samuel, “Ed idi, inbilang mo ay nababa ka, ngem ed wani et sik-a di ari sin amin ay tribun di Israel. Dinotokan dakan Diyos ay ari ay mangituray en daida. ");
INSERT INTO kne_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Kanana ay nangibaa en sik-a, ‘Emey ka ta peslem amin din Amalekita, daida ay managbasol ay ipogaw. Gobatem enggana ay peslem amin daida.’ ");
INSERT INTO kne_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Ngem apay nga adi kan tinongpal din inbilin Diyos? Apay nga inalistoam ay nan-a sin sinamsam mo ay sanikwa da et inamag mo di baken kosto sin pangilan Diyos?” ");
INSERT INTO kne_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Kanan Saulo, “Ngem nantongpalak met en Diyos. Inmeyak sin nangibaaana en sak-en et pinsek amin din Amalekita et insaak si Agag ay ari da. ");
INSERT INTO kne_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Inan din sosoldado di baka ya karnero et in-ali da din kamayatan ta maidaton en Yahweh ay Diyos mo isnan ed Gilgal.” ");
INSERT INTO kne_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ngem kanan Samuel ay nanongbat, “Ay malaydan aya si Diyos sin daton ay mapooan ya odom ay datdaton ono din pantongpalan si inbaga na? Maymayat pay laeng di mantongpal en sisya mo din man-idaton si kamayatan ay karnero. ");
INSERT INTO kne_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Tan din adi pantongpalan en sisya et kaman met laeng din kadagsen di basol di mansip-ok, mankotom ya manpontos. Din mangipapangato abe si nemnem na ay adi mangikaskaso sin ibagan Diyos et kaman met laeng din basol di mandaydayaw si sinan didiyos di kadagsen di basol na. Gapo ta sinigaam din inbagan Diyos, sigaana abes sik-a ay man-ari.” ");
INSERT INTO kne_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Pag kanan Saulo en Samuel, “Nanbasolak kayman tan adiak tinongpal din bilin Diyos ya din bilin mo. Inmegyatak to met sin ipogaw, isonga tinongpal ko din layden da. ");
INSERT INTO kne_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Pangaasim kod ta pomakawan ka ya komoyog ka ay mantaoli ed Gilgal ta way iyat ko ay mandaydayaw en Diyos.” ");
INSERT INTO kne_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Ngem kanan Samuel en sisya, “Adiak makiey en sik-a tan sinigaam din kalin Diyos et sinigaana abes sik-a ay man-ari sin Israelita!” ");
INSERT INTO kne_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Idi nandokog si Samuel ay komaan koma, kapeden si Saulo sin bado na yan pag et mabisngit. ");
INSERT INTO kne_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Kanan Samuel en sisya, “Ed wani ay agew, sinoktoban Diyos di turay mo ay ari isnan Israel et indawat na si ib-am ay sigsiged mo sik-a. ");
INSERT INTO kne_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Din madaydayaw ay Diyos ay pantalkan di Israelita et adi mabalin ay man-etek ono manbalbaliw, tan baken ipogaw ta manbalbaliw di nemnem na.” ");
INSERT INTO kne_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Kanan Saulo ay nanongbat, “Nanbasolak kayman, ngem pangaasim kod ta komoyog ka sin enak pandayawan en Yahweh ay Diyos mo ta adi madadael di dayaw ko sin sangoanan di nankakay di ili ya am-in ay Israelita.” ");
INSERT INTO kne_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Isonga kinoyog Samuel si Saulo ay nantaoli et nandaydayaw si Saulo en Diyos. ");
INSERT INTO kne_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Pag kanan Samuel, “Iali yo si Agag ay arin di Amalekita sin sangoanak.” Magay danag Agag ay sinmag-en tan kananas nemnem na, “Sigurado ay inlasat ko din pomsean da ay emegyatak.” ");
INSERT INTO kne_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Ngem kanan Samuel, “Begew sin kampilan mo yan ad-adoy babbabai ay napokawan si anak, isonga si inam abe di maawanan si anak.” Pag betbebetbeten Samuel si Agag et pinse na sin sangoanan Diyos ed Gilgal. ");
INSERT INTO kne_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Makdeng pay di, inmey si Samuel ed Rama ngem sinmaa pay si Saulo ed Gibea. ");
INSERT INTO kne_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Engganas nateyan Samuel, adi na inil-ila kasin si Saulo, olay mo nanladladingit manbegew en sisya. Si Diyos abe yan mansakit di nemnem na ya babawiena di nangisaadanan Saulo ay ari ed Israel. ");
INSERT INTO kne_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Idi siya di, kanan Diyos en Samuel, “Ay maney pay sas pangiladladingitam en Saulo, tan nay sinigaak di pan-ariana isnan Israel. Ibaak sik-a sin kad-an Jesse ay taga-Betlehem, isonga pon-em din sakngod ay panpeypey-an si lana ta emey ka. Tan pinilik di esa sin an-ak na ta say man-ari.” ");
INSERT INTO kne_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ngem kanan Samuel, “Intoy iyat ko ngin ay emey yan mo dengngen Saulo et pomse?” Kanan Diyos, “Man-a ka si bomalasang ay baka yan kanam en inmey kas di ay man-idaton en Diyos. ");
INSERT INTO kne_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Ayagam si Jesse sin pan-idatonam ta asiak itdo di amagem. Dotokam ay man-ari din piliek.” ");
INSERT INTO kne_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Tinongpal Samuel din inbilin Diyos. Idi dinmateng ed Betlehem, manpayegpeg din papangolon di ili ay mangabat en sisya yan kanan da ay nansalodsod, “Apo, ay mayat di panggep mo en dakami sin inmaliam ay nay?” ");
INSERT INTO kne_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Kanan Samuel ay sinombat, “Aw. Inmaliak ay man-idaton en Diyos. Linisan yo din awak yo ta makiali kayo sin pan-idatonak.” Pag nan amagen din seremonia ay panglinis en da Jesse sin an-ak na ay lalaki et inayaganas daida sin pan-idatonana. ");
INSERT INTO kne_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Idi dinmateng da, inilan Samuel si Eliab ay anak Jesse yan kananas nemnem na, “Sigurado ay si naey ay nakipipikas na sin sangoanan Diyos din pinili na.” ");
INSERT INTO kne_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Ngem kanan Diyos en Samuel, “Adi kan say nemnemen din kailaana ono kakayang na tan sinigaak sisya. Din pangilak et baken nais-o sin pangilan di ipogaw. Din ipogaw et din kailaana di pangibasaran da, ngem sak-en ay Diyos et say ilaek din nemnem.” ");
INSERT INTO kne_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Pag ayagan Jesse si Abinadab et inpalabas na sin sangoanan Samuel, ngem kanan Samuel, “Baken met say pinilin Diyos.” ");
INSERT INTO kne_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Inpalabas aben Jesse si Samma, ngem kanan Samuel, “Olay sinay et baken say pinilin Diyos.” ");
INSERT INTO kne_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Pito din an-ak Jesse ay inpalabas na sin sangoanan Samuel, ngem kanana, “Maga met en daida di pinilin Diyos. ");
INSERT INTO kne_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Ay anggoy dana si an-ak mo?” kanana ay nansalodsod. Kanan Jesse ay nanongbat, “Wada pay laeng din kaiyogtanan, ngem wada ay mangay-ayowan si karnero.” Kanan Samuel, “En ka ipaayag tan adi takon ilogi ay man-idaton ya mangan enggana ay domateng.” ");
INSERT INTO kne_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Et siya di, nan-ibaa si nangayag et dinmateng yan kambaw gowapo ya nasalon-at di kailaana. Pag kanan Diyos, “Pomika ka ta bokbokam si lana ay mangipaila ay nadotokan, tan sisya di pinilik.” ");
INSERT INTO kne_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Et siya di, inan Samuel din lana ay naipeey si sakngod et insoyat nan sisya sin sangoanan di aag-i na. Kasegep din Ispiriton Diyos en David, et manipod isdi ay agew, kinadkadwa na ya inturturayanas sisya. Makdeng pay di, sinmaa si Samuel ed Rama. ");
INSERT INTO kne_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Kinmaan din Ispiriton Diyos en Saulo, pag ibaan Diyos di anito ay mamaligat en Saulo. ");
INSERT INTO kne_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Kanan din mansilsilbi en sisya, “Ammo mi ay waday anito ay inbaan Diyos ay mamalpaligat en sik-a. ");
INSERT INTO kne_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Mo ibaam dakami, en kami man-anap si lalaki ay nalaing ay mantokar si arpa ta mo paligaten daka sin anito, mantokar et mailatonan ka.” ");
INSERT INTO kne_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Et binilin Saulo si daida ay man-anap si nalaing ay mantokar si arpa ta iey dan sisya. ");
INSERT INTO kne_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Dinomteng et di timpo ay natopog din Filisteo ed Soco ay sakop di Juda ta makigobat da. Nankampo da ed Efes Dammin sin nan-gawaan di Soco ya Azeka. ");
INSERT INTO kne_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Da Saulo abe sin Israelita, nankampo da sin tanap ed Ela et sidi ay nansagana da ay makigobat sin Filisteo. ");
INSERT INTO kne_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Wada din Filisteo sin esay dontog yan din Israelita abe sin esa, et way nan-gawaan da ay tanap. ");
INSERT INTO kne_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Wada et di mangialagey sin Filisteo ay manngadan si Goliat ay taga-Gat. Binmela sin kampon di Filisteo ta karitena din Israelita. Siyam ay piya di kakayang na, ");
INSERT INTO kne_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","nanhelmet si bronsi yan bronsi met laeng di salida na ay emey ay limapolo ya pito ay kilo. ");
INSERT INTO kne_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Nagadingan si bronsi di siki na yan sinasadlayana di bronsi ay gayang. ");
INSERT INTO kne_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Din potan di gayang na ay sana yan dakdake ay kaman din os-osalen di man-abel yan emey ay pito ay kilo di dagsen din landok ay tadem na. Waday soldado ay mamangpangpango ay para egen sin kasay na. ");
INSERT INTO kne_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","En sinangon Goliat din sosoldadon di Israelita yan kanana ay nangibogaw, “Apay nga malinya kayo ay makigobat? Esaak met ay Filisteo yan dakayo din bag-en Saulo. Manpili kayo si esa ay makilaban en sak-en. ");
INSERT INTO kne_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Mo omabak ta pomse, manbalin kami ay bag-en yo, ngem no abakek ta peslek, dakayo di manbalin ay bag-en mi et mansilbi kayo en dakami.” ");
INSERT INTO kne_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Intoloy din Filisteo ay sana ay nangwani, “Ed wani met laeng, karitek din sosoldadon di Israelita. Manpili kayo si makilaban en sak-en!” ");
INSERT INTO kne_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Idi dinngen da Saulo ya din amin ay Israelita din sana, palalo di egyat ya dismaya da. ");
INSERT INTO kne_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Si David yan anak Jesse ay polin Efrata. Ed Betlehem ay lak-am di Juda di ili da. Waday wao ay lalaki ay an-ak Jesse yan enggay nakay sisya sin timpo ay nanturayan Saulo. ");
INSERT INTO kne_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Din tolo ay kapangoanan sin an-ak Jesse yan naikoyog da en Saulo sin gobatan. Si Eliab di ngadan din kapangoanan, pag si Abinadab, pag si Samma. ");
INSERT INTO kne_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Si David di inoodi. Naikoyog din tolo ay kapangoanan en Saulo, ");
INSERT INTO kne_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","ngem si David pay yan mantinaoli ay emey sin kad-an Saulo ya somaa ay mangayowan sin karneron ama da. ");
INSERT INTO kne_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Sin oneg di opatapolo ay agew, binigat ya minasdem ay kariten Goliat din Israelita. ");
INSERT INTO kne_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Sin esay agew, kanan Jesse en David, “Dalasem ta iey mo nan sinpo ay kilo ay doom ya sinpo ay tinapay sin kad-an da manong mo. ");
INSERT INTO kne_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Idawat mo abe nan sinpo ay nabanol ay makan sin kapitan di bonggoy da. En ka kod ilaen mo kas-ano din aag-im yan mo mantaoli ka, man-isaa kas pamaneknek ay mapo en daida ay mayat di kasasaad da. ");
INSERT INTO kne_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Wadas da Saulo ya din amin ay lalaki ay Israelita sin tanap ed Ela ay makigobgobat sin Filisteo.” ");
INSERT INTO kne_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Nasapas David sin kabigatana ay nangipolang sin kakarnero si esa ay manpaspastol, pag nan alaen din karga na et inmey ay nantongpal sin inbilin Jesse. Dinmateng sin kad-an di sosoldado idi kosto ay emey da sin powisto da et ipigpigsa da din ibogbogaw da ay para gobat. ");
INSERT INTO kne_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Nanpowisto da ay man-asisagang din Israelita ya Filisteo. ");
INSERT INTO kne_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Inpayag David din karga na sin man-idoldolin si kasapolan di sosoldado, pag katagtag ay emey sin kad-an di aag-i na sin gobatan et sinalodsod na di kasasaad da. ");
INSERT INTO kne_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Idi makikalkali sin aag-i na, wada et si Goliat ay pinmika sin sangoanan di gagait na yan manbogaw kasin ay mangarit sin Israelita ay kaman din sigod ay am-amagena, et dinngen David. ");
INSERT INTO kne_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Tinmagtag din Israelita si egyat da sin nangilaan da sin lalaki ay sana. ");
INSERT INTO kne_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Kanan da ay nan-asibaga, “Ilaen yo, kanayon ay kariten din ipogaw ay sana si datako ay Israelita. Gon-gonaan kano din ari si dakdake ay kinabaknang di mamse sin ipogaw ay doy yan ipaasawa na abe din anak na ya adi manbayad si bowis din pamilyan ama na.” ");
INSERT INTO kne_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Kanan David ay nansalodsod sin katakdo na ay lallalaki, “Sinoy gon-gonan di mamse sin Filisteo ay nay ta adi maibabain di Israel? Siya mo sino san adi nakogit ay Filisteo ay mangarkarit sin sosoldadon di matmatago ay Diyos.” ");
INSERT INTO kne_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Et dinad-at dan sisya kasin din is-istoryaen da ay lagbon di mamse en Goliat. ");
INSERT INTO kne_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Dinngen Eliab ay din kapangoanan ay manong David din pakikalkaliana sin lallalaki et palaloy bonget na ay nanyamyam en sisya. Kanana, “Apay nga inmali kas na? Sino di mangayowan sin at-atik ay doy ay karnero sin lugar ay magay omili? Nalastog ka dedan ya lawlaway nemnem mo, ammok ay inmali ka anggoy ay manboyas man-gogobat.” ");
INSERT INTO kne_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Kanan David, “Ay sino od di inamag ko? Ay maiparit aya di pankaliak?” ");
INSERT INTO kne_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Kinmaan si David sin kad-an manong na et siya met laeng di ena dinamag sin odom ay lallalaki yan iso na met laeng di songbat da ay kaman din inbagan di odom. ");
INSERT INTO kne_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Nandinamag din inbagan David enggana ay naibagan Saulo et inpaayag nas David. ");
INSERT INTO kne_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Kanan David en Saulo, “Madaydayaw ay ari, maga koma di emegyat sin Filisteo ay doy, tan sak-en ay bag-en mo di en makilaban en sisya.” ");
INSERT INTO kne_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Kanan Saulo ay nanongbat, “Adim kabaelan din Filisteo ay doy tan an-anak ka pay laeng yan sisya pay et nakigobgobat manipod sin kabaro na.” ");
INSERT INTO kne_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ngem kanan David, “Apo ari, sak-en di mangay-ayowan sin kakarneron amak yan mo waday layon ono odom ay atap ay animal ay mangitagtag sin anak di karnero, ");
INSERT INTO kne_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","apayawek ay labanen ta isalakan ko din anak di karnero. Mo somagong yan kapedenak sin bagang na ta pat-oak enggana ay matey. ");
INSERT INTO kne_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Wada day pinsek ay layon ya odom ay atap ay animal et siya met laeng di amagek sin adi nakogit ay doy ay Filisteo ay mangarkarit sin sosoldadon di matmatago ay Diyos. ");
INSERT INTO kne_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Insalakan Diyos sak-en si layon ya odom ay atap ay animal et sisya met laeng di mangisalakan en sak-en sin Filisteo ay doy.” Kanan Saulo, “Mo siya ngarud sa, emey ka et sapay koma ta si Diyos di mangadkadwa en sik-a.” ");
INSERT INTO kne_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Inpabadon Saulo en David din mismo ay bado na ay maidallem sin salida, indawat na abe din salida na ya helmet na ay bronsi. ");
INSERT INTO kne_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Idi in-amag David dadi, asi nan isiket din kampilan yan ipadas na ay idad-an, maikawa tan adi nan inpaingsa. Kanana en Saulo, “Maikawaak tan bakenak dedan nairuam,” isonga kinaana. ");
INSERT INTO kne_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Pag nan alaen din sokod na ay manpaspastol yan en nanpili si lima ay mayat ay bato sin ginawang et inpeey na sin sopot na. Iin-genana din palsiit na ay sinmag-en sin Filisteo. ");
INSERT INTO kne_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Intoltoloy aben Goliat ay nangabat en David yan mamangpangpango din nananggen si kasay na. ");
INSERT INTO kne_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Idi estena ay ilaen si David, nilaslasoy na tan inila na ay an-anak pay laeng ay gowapo ya nasalon-at di kailaana. ");
INSERT INTO kne_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Kanana en David, “Ay siya mo asoak ta pat-o di iabat mon sak-en?” Et inbayos na sin didiyosena din baos na en David. ");
INSERT INTO kne_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Kanana, “Omali kas na ta idawat ko san awak mo sin titit ya atap ay animal ta isida da!” ");
INSERT INTO kne_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Kanan aben David, “Kampilan ya gayang di armas mo ay makilaban en sak-en, ngem sak-en pay ay makisango en sik-a et panakaawak Yahweh ay Kangatoan ay Turay. Sisya din Diyos ay daydayawen di sosoldadon di Israel ay kinarit mo. ");
INSERT INTO kne_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ed wani ay agew, ipaabak Diyos sik-a en sak-en ta peslek sik-a ya potoak san toktok mo. Ed wani ay agew, idawat ko din bangkay di sosoldado ay Filisteo sin titit ya atap ay animal ta kanen da ta say pangammoan di intiro ay lobong ay wada di Diyos ed Israel. ");
INSERT INTO kne_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Say pangilaan di amin ay natopog isna ay adi kasapolan Diyos di gayang ya kampilan ay mangisalakan sin ipogaw na, tan si Diyos di makigobat et ipaabak nas dakayo am-in en dakami.” ");
INSERT INTO kne_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Intoltoloy Goliat ay sinmag-en yan katagtag si David ay nangabat en sisya sin panlabanan da. ");
INSERT INTO kne_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Kinawet na di bato sin sopot na et inpalsiit na en Goliat. Napontaan din kitong na yan linosok din bato din toktok na et natokang ay nanlakob-o sin lota. ");
INSERT INTO kne_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Isonga inabak David din Filisteo ay sana, olay mo palsiit anggoy ya bato di armas na, tan maga di kampilan si intatakina. ");
INSERT INTO kne_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Katagtag si David et pinmika sin kad-an di bangkay Goliat, pag nan oksoten din kampilan Goliat ay say inpoto na sin toktok na met laeng. Idi ilaen din Filisteo ay natey din itangtangsit da, katanagtag da ay lomayaw. ");
INSERT INTO kne_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Pag bomanogaw din taga-Israel ya taga-Juda ay nangapayaw en daida sin danan ay manturong ed Saaraim enggana sin segpan di ili da ed Gat ya Ekron, et kawanalang di nasogatan ay Filisteo sin danan enggana sin ili da ay doy. ");
INSERT INTO kne_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Inmey si David ed Nob sin kad-an Ahimelek ay padi. Manpayegpeg sisya ay nangabat en David yan kanana, “Apay nga es-esam ay magay intakin mos gait mo?” ");
INSERT INTO kne_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Kanan David ay nanongbat, “Waday nangibaaan din ari en sak-en yan inbilina ay adiak ibagbaga si olay sino din inpaamag na en sak-en. Mo maipanggep sin ipogaw ko yan binilin kos daida ay man-aabat kami si esa ay lugar. ");
INSERT INTO kne_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Sinoy makan ay wadan sik-a ed wani? Omya ka kod si lima ay tinapay ono kompormi ay makan ay wadas sa.” ");
INSERT INTO kne_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Kanan din padi, “Magay odom ay tinapay mo adi et anggoy din tinapay ay naidaton en Diyos. Mabalin ay kanen yo mo adi nakidadaag si babbabai din sosoldadom.” ");
INSERT INTO kne_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Kanan David, “Sigurado met kitdi ay adi dan nakidaag tan kanayon ay say iyat mi mo waday emeyan mi. Adi kamin makidadaag olay mo baken nasantoan ay gapo di biyahi mi, isonga masepsep et ed wani ay importanti ay gapo di naibaaan mi.” ");
INSERT INTO kne_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Et siya di, indawat din padi en David din nasantoan ay tinapay tan anggoy nas wada. Kakakkaana sin lamisaan ay kaipatpatangan di tinapay ay maidaton en Diyos, tan sinokatanas kaot-oto. ");
INSERT INTO kne_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Idi nantaoli si Saulo ay napo sin nakigobatan da sin Filisteo, waday nangwani en sisya en wadas David sin lugar ay magay omili ed En Gedi. ");
INSERT INTO kne_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Siya di, pinilin Saulo di tolo ay libo ay kalalaingan ay soldado ed Israel, et en da inanap da David sin asag-en di makwani en Deppas di Atap ay Kalding. ");
INSERT INTO kne_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Idi wada da sin danan, dinmateng da sin liyang ay asag-en si kodal di karnero, et sinenggep si Saulo ta en mankatilyas. Kambaw wadas da David ya din ipogaw na sin dogon di liyang ay sana. ");
INSERT INTO kne_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Kanan da en sisya, “Gondaway mo na! Tan inbagan Diyos ay ipolang na din kaibaw mo en sik-a ta oway di iyat mo en sisya.” Siya et di, inin-inayad David ay inmasag-en ay adi dinlaw Saulo, et pinotoana din gayadan di naloyong ay bado na. ");
INSERT INTO kne_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Idi nakdeng di, mansakit di konsensia na begew sin namotoana sin badon Saulo, ");
INSERT INTO kne_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","et kanana sin ipogaw na, “Sapay koma ta domosas Diyos mo sakitak ono peslek din apok, tan dinotokan iman Diyos sisya ay man-ari.” ");
INSERT INTO kne_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Begew sin inbaga na ay doy, tinopap na din ipogaw na ay makilaban en Saulo. Idi siya di, kinmaan si Saulo sin liyang ta madipos koma. ");
INSERT INTO kne_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Ngem binmala abes David yan kinaliana ay nangwani, “Apo ari!” Nanwingi si Saulo, et pag mandokmog si David ay nanyakog-ong ");
INSERT INTO kne_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","yan kanana, “Apay nga patiem di kanan di odom ay ipogaw en waday panggep ko ay mamse en sik-a? ");
INSERT INTO kne_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ed wani ay agew et mismo ay inilan di matam ay inpalobos Diyos ay peslek sik-a koma isnan liyang. Sinogsogan pay di odom sak-en ay mamse en sik-a, ngem adiak inamag, tan kanak si nemnem ko en adiak man-amag si lawa en sik-a tan dinotokan dakan Diyos. ");
INSERT INTO kne_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Ilaem kadi ay ama nan poton di badom ay ginedged ko sin gayada na ngem adiak pinses sik-a. Say pangilaam koma ay maga di panggep ko ay mangamag si lawa ono makilaban en sik-a. Maga met di lawa si inamag ko en sik-a, ngem nay et ay omap-apayaw ka tan laydem ay pomse. ");
INSERT INTO kne_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Sapay koma ta okomen Diyos daita ay dowa ta sisya di manobalit sin lawa ay inam-amag mo en sak-en, ngem adiak polos sakitan sik-a. ");
INSERT INTO kne_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Wada di apat ay kanana, ‘Din mangamag si lawa et din lawa ay ipogaw,’ isonga adiak sagiden sik-a. ");
INSERT INTO kne_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Ay sinoak od ay ap-apayawen din arin di Israel ta peslena? Kamanak met owat nanatey ay aso ono kaman tilang. ");
INSERT INTO kne_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Si Diyos di mangokom ya mangikeddeng mo sino en daita di binmasol. Ilaena koma na ay maam-amag ta somalaknib sin panakabalin mo.” ");
INSERT INTO kne_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Idi nakdeng ay inbagan David di, kanan Saulo ay nanpoot, “Ay sik-a ay anak ay David san mankalkali?” Pag nan ipigsa ay nan-oga. ");
INSERT INTO kne_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Kanana, “Nalinteg ka mo sak-en tan siged di inyat mo en sak-en, ngem lawa di inam-amag ko en sik-a. ");
INSERT INTO kne_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Inpailam ed kaonyan din mayat ay ogalim en sak-en, tan inpalobos Diyos ay oway di iyat mo koman sak-en, ngem adi ka pinomse. ");
INSERT INTO kne_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Manmano di ipogaw ay mo datngan day kaibaw da yan ipalobos da ay makalayaw ay adi naan-ano. Sapay koma ta gon-gonaan dakan Diyos ay kosto sin siged ay inyat mo en sak-en ed wani. ");
INSERT INTO kne_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Enggay ammok ay dadlon kan man-ari ed Israel et manturay kas mabayag. ");
INSERT INTO kne_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Isonga mansapata ka sin ngadan Diyos ay adi kan peslen din polik ta say adi malinglingan din ngadan ko ya din ngadan amak.” ");
INSERT INTO kne_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Et nansapatas David. Pag somaas Saulo, ngem nantaolis da David ya din ipogaw na sin nantabonan da. ");
INSERT INTO kne_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Waday odom ay lallalaki ay taga-Zif ay inmey en Saulo ed Gibea yan inbaga da ay wadas David ay mantabtabon sin bilig ay Hakila sin benget di lugar ay magay omili. ");
INSERT INTO kne_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Nanballalong ay dagos si Saulo sin lugar ay magay omili ed Zif. Kinoyog na di tolo ay libo ay napili ay soldadon di Israel ta anapen das David, ");
INSERT INTO kne_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","et nankampo da sin kad-an di kalsada sin bilig ay Hakila met laeng. Idi dinngen David ay inonod da Saulo si daida sin lugar ay doy, ");
INSERT INTO kne_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","inbaa nay ispay et pinaneknekan da ay tet-ewa ay wadas da Saulo. ");
INSERT INTO kne_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Inmey ay dagos si David yan inila na din kad-an di nankampoan da Saulo. Tinamang na din kaseyseyepan da Saulo en Abner ay anak Ner ay komander din sosoldadon di ari. Din kaseyseyepan Saulo yan wada sin nan-gawaan di sosoldado na. ");
INSERT INTO kne_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Idi siya di, nandamag si David en Ahimelek ay Heteo ya si Abisai ay anak Zeruyas ya agin Joab. Kanana, “Sino di komoyog ay emey sin kampon Saulo?” “Sak-en,” kanan Abisai ay sinombat. ");
INSERT INTO kne_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Sin doy ay labi, sin-gep da David en Abisai din kampon Saulo. Wadas Saulo ay naseseyep yan naipapadsek din gayang na sin toktokana. Naseseyep abe si Abner yan siya abe sin sosoldado na ay nangigagawa en sisya. ");
INSERT INTO kne_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Kanan Abisai, “Inpalobos Diyos ay peslem din kaibaw mo ed wani ay labi, isonga ipalobos mo koma ta idoyok ko en sisya din gayang na enggana ay maipadsek sin lota. Mamingsan anggoy ay doyokek, adi masapol ay mamidwa.” ");
INSERT INTO kne_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Ngem kanan David, “Adi kan pespeslen, tan sigurado ay dosaen Diyos di mamse sin dinotokana ay ari. ");
INSERT INTO kne_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Sigurado ay si Diyos met laeng ay mismo di mamse en sisya sin tapin di agew. Mabalin ay owat matey ono matey sin gobatan. ");
INSERT INTO kne_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Ngem sapay koma ta iaddawin Diyos ay peslek din dinotokana ay ari. Ngem alaen ta din gayang ya panpeypey-anas danom ta komaan ta.” ");
INSERT INTO kne_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Et inan David din gayang ya panpeypey-an si danom sin kad-an di toktokan Saulo, asi da kinmaan en Abisai. Magay nakaila ono nangammo sin napasamak. Maga abey binmangon. Nas-et di seyep da, tan si Diyos dedan di nangiturong. ");
INSERT INTO kne_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Makdeng pay di, nanbalasat da David sin tanap yan inmey da sin toktok di esay bilig. Nan-inaddawi da en da Abner ya din sosoldadon Saulo. ");
INSERT INTO kne_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Pag nan kanan ay nangibogaw en daida, “Abner, apay nga adi kan somongbat?” Songbatan pay Abner yan kanana, “Sino ka ay bomogbogaw ay mamalaga sin ari?” ");
INSERT INTO kne_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Kanan aben David, “Ay baken tet-ewa ay natoled ka ay ipogaw yan magay makaiso en sik-a isnan Israel? Apay ngarud ay adi kan binantayan din ari ay apom? Wada met di kakkaey na issa ay mamse en sisya. ");
INSERT INTO kne_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Lawa sas inyat mo. Dadlon tet-ewa ay lebbeng na ay matey kayo am-in, tan adi yo dedan binantayan din apo yo ay dinotokan Diyos ay manturay. Estem ay ilaen. Intoy kad-an din gayang di ari ya din panpeypey-an si danom ay wada koma sin toktokana?” ");
INSERT INTO kne_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Inmatonan Saulo din kalin David yan kanana, “Anak ko ay David, ay sik-a san mankalkali?” Songbatan pay David yan kanana, “Aw, sak-en, Apo ari!” ");
INSERT INTO kne_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Pag nan itoloy ay nangwani, “Apay ngin ay at-atikoem pay laeng sak-en ay baam? Ay wada aya di basol ko en sik-a?” ");
INSERT INTO kne_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Pag kanan Saulo, “Baken kosto di inamag ko. Mantaoli ka, anak ko ay David. Laton ay adiak kasin sakitan sik-a, tan inpailam ed wani ay agew di panangipateg mo sin biyag ko. Tet-ewa kayman ay naong-ongak et dakdake ay kamali di inamag ko.” ");
INSERT INTO kne_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Kanan David ay nanongbat, “Naey din gayang mo ay apo ari. Man-ibaa ka sin ipogaw mo si manga. ");
INSERT INTO kne_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Sapay koma ta gon-gonaan Diyos di nalinteg ya napodno ay ipogaw. Ed wani ay agew, indawat Diyos di gondaway ko ay mamse en sik-a, ngem sinigaak ay namse en sik-a ay dinotokana. ");
INSERT INTO kne_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Ed wani ay agew, inpailak di panangipateg ko sin biyag mo et sapay koma ta patgen aben Diyos din biyag ko et omisalakan sin amin ay ligat.” ");
INSERT INTO kne_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Pag kanan Saulo, “Sapay koma ta bindisyonan dakan Diyos, anak ko ay David. Siged di pantongpalan di am-in ay amagem.” Pag komaan si David yan sinmaa abe si Saulo. ");
INSERT INTO kne_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Sin namingsan, nan-gogobat din Filisteo ya Israelita sin dontog ay Gilboa yan ad-adoy natey sin Israelita. Linmayaw din odom pati da Saulo sin aan-ak na. ");
INSERT INTO kne_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Ngem indasan din Filisteo si daida et pinse da din tolo ay an-ak Saulo ay da Jonatan en Abinadab ya si Malkisua. ");
INSERT INTO kne_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Napigsa di laban sin kad-an Saulo, isonga olay sisya et pinontaan di panan di kalaban da yan naoneg di sogat na. ");
INSERT INTO kne_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Kanana sin baro ay para egen si salida na, “Asotem san kampilan mo ta pomse ka ta adi da pomaligat asi da pomse din adi nakogit ay Filisteo.” Ngem palalo di egyat din baro ay sana et sinigaana ay mamse, isonga kaa si Saulo sin mismo ay kampilana et sisya met laeng di namse sin awak na. ");
INSERT INTO kne_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Idi ilan din baro ay sana ay natey si Saulo, kapese abe sin awak na sin bokod na ay kampilan. ");
INSERT INTO kne_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Et siya di di inyat Saulo ay natey sin agew ay doy pati din tolo ay an-ak na, din man-eg-egen si salida na ya din amin ay sosoldado na. ");
INSERT INTO kne_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Inmey din papangolon di am-in ay tribun di Israelita en David sin kad-ana ed Hebron yan kanan da en sisya, “Siag-i tako met. ");
INSERT INTO kne_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Olay ed idi ay si Saulo pay laeng di ari tako, sik-a di nangipangpangolo sin nakigobgobatan di Israelita yan inkarin Diyos ay sik-a di mangay-ayowan ya mangituray sin ipogaw na.” ");
INSERT INTO kne_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Sin kawadan din am-in ay papangolon di Israelita sin kad-an Ari David ed Hebron, nakitolag en daida sin sangoanan Diyos, et sinoyatan da din toktok na si lana ay mangipaila ay insaad das sisya ay ari ed Israel. ");
INSERT INTO kne_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Tolonpo di tawena sin naisaadana ay ari yan nanturay si opatapolo ay tawen. ");
INSERT INTO kne_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Inturayana ed Juda si pito ya kagodwa ay tawen sin kawada na ed Hebron yan inturayana ed Israel ya Juda si tolonpo ya tolo ay tawen sin inmeyana ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Idi nakdeng ay naisaad si David ay ari, inmey sisya ya din sosoldado na ed Jerusalem et ginobat da din Jebuseo ay man-ilis di. Kanan din Jebuseo sin nemnem da en adi kabaelan David ay senggep sin kad-an da, isonga kanan da en sisya, “Adi kan makasgep, tan olay din pilay ya nagodab et kabaelan das sik-a ay sawaden.” ");
INSERT INTO kne_vpl VALUES ("S25_7","011_5_7","2SA","5","7","8","Sin agew ay doy, kanan David sin sosoldado na, “Mo sinoy mayad ay mangabak sin Jebuseo, masapol ay mandan da sin osok ay mapo sin sakdoan ed dallem ta say makadateng da sin kad-an din doy ay napilay ya nagodab ay kanan da, ay kalkaliget ko.” Siya na di gapo ay wada nan apat ay kanana, “Adi makasgep sin Timplo din napilay ya nagodab.” Idi siya di, inabak David din naaladan ay partin di siyodad ay makwani en Zion ");
INSERT INTO kne_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","et nanbeey sidi. Pag nan ngadanan si Siyodad en David. Inpasaad na kasin din kabeebeey sin siyodad manipod ed Millo enggana sin palasyo et inpaalad na din nanniliked. ");
INSERT INTO kne_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Nantoltoloy ay pinmigsa din turay en David tan wada en sisya si Yahweh ay say Diyos ay Kangatoan ay Turay. ");
INSERT INTO kne_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Inpasinop kasin David din napili ay sosoldadon di Israel yan waday tolonpo ay libo. ");
INSERT INTO kne_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Inkoyog nas daida amin ed Baala ay sakop di Juda ta alaen da din Baol di Tolagan Diyos ay naingadan din ngadan Diyos ay Kangatoan ay Turay ay tinmotokdo sin trono na sin ngaton di kerubim. ");
INSERT INTO kne_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Inkarga da si baro ay kariton, pag dan ikaan sin beey Abinadab ay wada sin toktok di bilig. Da Uzza en Ahio ay an-ak Abinadab di nannandan ay nangiturturong sin kariton, ");
INSERT INTO kne_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","yan si Ahio di wada sin sango. ");
INSERT INTO kne_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Si David abe ya din amin ay Israelita yan inpakat da amin ay kabaelan da ay mankanta ya mansala ay mangidaydayaw en Diyos. Dowan da aben manambol, mangangsa, ya mantokar si arpa, gitara ya odom pay ay kalasin di matokar. ");
INSERT INTO kne_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Idi dinmateng da sin kad-an di pan-ir-irikan Nacon, naikados din baka, isonga pinden Uzza din Baol di Tolagan. ");
INSERT INTO kne_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Binmonget si Diyos et pinse nas Uzza ay dagos isdi met laeng, sin kad-an di Baol, tan adi binanol Uzza din kinasanton di Baol. ");
INSERT INTO kne_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Mansakit di nemnem David sin nanosaan Diyos en Uzza gapo sin bonget na, et manipod sidi ay timpo enggana ed wani, nangadanan din lugar ay doy si Perez Uzza. ");
INSERT INTO kne_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Siya et di, inmegyat si David en Diyos yan kanana, “Intoy iyat ko pay ay mangitakin sin Baol di Tolagan?” ");
INSERT INTO kne_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Gapo sidi, ninemnem David ay adi na itakin din Baol ed Jerusalem ay makwani en Siyodad David. Inliglig na sin danan et in-ey na sin beey Obed Edom ay taga-Gat. ");
INSERT INTO kne_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Kinmakaman sidi din Baol di Tolagan Diyos si tolo ay bowan yan binindisyonan Diyos si Obed-Edom ya din intiro ay pamilya na. ");
INSERT INTO kne_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Naipaammo en Ari David ay binindisyonan Diyos din pamilyan Obed Edom ya din amin ay sanikwa na gapo sin Baol di Tolagan, isonga inmey da David ta alaena din Baol ta iey na ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Idi owat dan nandan si enem ay kiyang din lallalaki ay nanggen sin Baol di Tolagan, inpasaldeng David daida, pag man-idaton en Diyos si esa ay bomaro ay baka ya esay malames ay karnero. ");
INSERT INTO kne_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Idi intoloy da ay mandan, inpakat David di kabaelana ay mansala ay manaydayaw en Diyos. Sin nansalsalaana, nanbabado si mankilat ay sinadlay ay makwani en efod. ");
INSERT INTO kne_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Siya et di, in-ey David ya din amin ay Israelita din Baol di Tolagan ed Jerusalem yan nanbogbogaw ya nananggoyob da gapo si ragsak da. ");
INSERT INTO kne_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Idi wada ay idatdateng da sin siyodad din Baol di Tolagan, nan-osdong sin tawa si Mikal ay anak Saulo. Inila na si David ay mansalsala ya mantabtab-oy ay mangidaydayaw en Diyos yan linaslasoy na sin nemnem na. ");
INSERT INTO kne_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Inisgep da din Baol di Tolagan sin Tolda ay in-amag David ay kaipey-ana. Pag man-idaton si David si daton ay mapooan ya daton ay pan-ookoban da ya makikadkadwaan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Idi makdeng ay man-idaton, inosal na din ngadan Diyos ay Kangatoan ay Turay ay namindisyon sin kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Winarasana abe amin din ipogaw, lallalaki ya babbabai si sag-eesa ay tinapay, esay tadtad ay dinawis ay karni ya esa ay kalasin di mam-is ay tinapay ay nalaokan si pasas. Idi makdeng di, sinmaa amin din ipogaw. ");
INSERT INTO kne_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Idi sinmaas David ta ena bindisyonan din pamilya na, binmela si Mikal ay anak Saulo ay en nangabat en sisya. Kanana, “Kaman kayman inngatom di dayaw mo ay arin di Israel ed wani ay agew! Tan nanlabos ka sin sangoanan di babassang ay babag-en di oopisyal mo. Kaman kan ipogaw ay magay nemnem na.” ");
INSERT INTO kne_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Songbatan David yan kanana, “Baken para en daida din inamag ko mo adi et nansalaak ay pangidaydayaw ko en Diyos ay namili en sak-en ay mangituray sin ipogaw na ay Israelita. Baken si amam ono din pamilya na di pinili na. Itoltoloy kon to ay mansala ay mangidayaw en Diyos ");
INSERT INTO kne_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","et mas ibabak din awak ko mo din kanam ay sana. Mabalin ay kanam en magay kowintak, ngem omidayaw dan to din babassang ay inbagam.” ");
INSERT INTO kne_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Et begew sin napasamak ay nay, adi polos nan-anak si Mikal ay anak Saulo engganas nateyana. ");
INSERT INTO kne_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Idi siya di, tinmalna din iturayan David, tan inpasaldeng Diyos din amin ay kalabana. ");
INSERT INTO kne_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Idi wadas sisya ay manbeey sin palasyo na, kanana en Natan ay din pankalkalian Diyos, “Ilaem kadi, sak-en yan manbeeyak si palasyo ay napili ay kaiw di amag na, ngem din Baol di Tolagan Diyos yan owat tolda di beey na.” ");
INSERT INTO kne_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Kanan Natan ay sinombat sin ari, “Amagem adi mo sino di nemnemnemem, tan laton ay wadas Diyos ay mangadkadwa en sik-a.” ");
INSERT INTO kne_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Ngem sin labi ay sana, nakikali si Diyos en Natan yan kanana, ");
INSERT INTO kne_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“En ka ibaga en David ay baak, ‘Siya na di kinwanin Diyos: Baken sik-a di mangisaad si panbeeyak. ");
INSERT INTO kne_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Adiak polos nantee si beey manipod sin nangipangoak sin Israelita ay kinmaan ed Egipto engganad wani, tan tolda di nanbebbeeyak ay nan-etaetan sin inil-ili. ");
INSERT INTO kne_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Sin amin ay nakikoykoyogak sin Israelita ay ipogaw ko, adiak polos nansalsalodsod sin papangolo ay dinotdotokak ay mangay-ayowan en daida mo apay nga adi da man-amag si panbeeyak ay napili ay kaiw di amag na.’ ");
INSERT INTO kne_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Isonga ed wani, kanam en David ay baak, ‘Siya na di kanan Diyos: Esa ka ay manpaspastol si karnero, ngem inayagak ya dotokak sik-a ay mangituray sin Israelita ay ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Kanayon ay kinadkadwak sik-a ya inabak ko am-in ay kalaban mo sin en ka nakigobgobatan. Ipangatok sik-a ay kaman da din madaydayaw ay ipogaw isnan lobong. ");
INSERT INTO kne_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Siya abe ay pinilik di lugar ay panbeeyan di Israelita ay ipogaw ko yan insaad kos daida ta mawadaan das kabokbokodan da ay pantean. Isdi, maga di manistolbo ya mamalpaligat en daida ay kaman ed idi, ");
INSERT INTO kne_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","manipod sin nandotokak si mangipangolo en daida. Ipasaldeng ko din kalaban mo et mawadaan kas talna. Ikarik abe ay isaad ko din polim ay ari ta mansososkat da ay manturay. ");
INSERT INTO kne_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Mo matey ka ya maiponpon ka ay maitapi sin ap-apom, isaad kon to din esay polim ay maisokat en sik-a et papigsaek din turay na. ");
INSERT INTO kne_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Sisya di mangisaad si Timplo ay panbeeyak yan ilaek ta din panturayan di poli na et maga polos di patingga na. ");
INSERT INTO kne_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Sak-en di manbalin ay ama na et sisya di anak ko. Dosaek mo man-amag si lawa ay kaman din iyat di ama ay manoplit si anak na. ");
INSERT INTO kne_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Ngem itoltoloy ko ay mangipaila si komakaman ay layad ya seg-ang ko en sisya. Adiak ibabawi ay kaman din inyat ko en Saulo et kinaan kos sisya ta sik-a di man-ari. ");
INSERT INTO kne_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Mantoltoloy din polim ay man-ari sin pangiilaak si eng-enggana.’” ");
INSERT INTO kne_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Inpaammon Natan en David amin din naipadto ay nay. ");
INSERT INTO kne_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Idi inmey di timpo, ginobat Ari David din Filisteo. Inabak nas daida et inpasaldeng na din turay da sin ili da. ");
INSERT INTO kne_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","Inabak na abe din Moabita. Din inamag na en daida sin nakdengan di gobat et inpabaktad nas daida ay dinalapat sin lota. Pag nan ibilin ay lokoden din sosoldado nas daida si tali ta peslen da din dowa ay inkatlo ya bay-an da ay matago din inkatlo. Siya et di nanpaituray din Moabita en David et nanbaybayad das bowis en sisya. ");
INSERT INTO kne_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Inabak aben David da Hadadezer ay anak Rehob ay ari ed Zoba ay sakop di Syria. Ginobat nas daida idi wada da Hadadezer sin danan ay en mangipapigsa kasin sin turay na sin kad-an di ginawang ay Eufrates. ");
INSERT INTO kne_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","Dinpap da David di sinlibo ya pito ay gasot ay soldado ay nangakabayo ya dowanpo ay libo ay mandad-an. Binay-ana di kabayo ay omanay si sin-gasot ay kalisa, ngem pinilay na din odom. ");
INSERT INTO kne_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Idi inbaan din taga-Syria ay wadad Damascus di sosoldado ay tomolong en Ari Hadadezer, ginobat aben da David si daida et pinse da di 22,000. ");
INSERT INTO kne_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","Pag nan isaad di kakampon di sosoldado sin ili da. Siya et di inturayana din taga-Syria et nanbaybayad das bowis en sisya. Et olay intoy inmeyan David ay nakigobat, nangabaken Diyos sisya. ");
INSERT INTO kne_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","Inan David din kasay ay balitok ay okan din papangolon di sosoldadon Hadadezer et in-ey na ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","Ad-ado abe di ina na ay bronsi sin siyodad ay Beta ya Berotai ay inturayan Hadadezer. ");
INSERT INTO kne_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","Idi nadamag Ari Toi ed Hamat ay inabak David din am-in ay soldadon Hadadezer, ");
INSERT INTO kne_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","inbaa nas Joram ay anak na ta pakomostaana ya padayawana begew sin nangabakana. Tan namin ado ay nan-gobat da Toi en Hadadezer. Idi dinmateng si Joram, waday sagsagot ay indawat na en David ay balitok, palata ya bronsi di amag da. ");
INSERT INTO kne_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","Indaton David am-in dana en Diyos, pati din palata ya balitok ay ina na sin nanasyon ay inabak na ");
INSERT INTO kne_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","ay ed Edom, Moab, Ammon, Filistia ya Amalek. Indatona abe en Diyos din tapin di kinabaknang ay sinamsam na en Hadadezer. ");
INSERT INTO kne_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Idi pinsen David ya din sosoldado na di 18,000 ay taga-Edom sin tanap ay Asin, masepsep ay mandindinamag din pigsa na. ");
INSERT INTO kne_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Insaad na di kampon di sosoldado sin il-ili da ed Edom et nanpaituray am-in di taga-Edom en sisya. Et olay intoy in-inmeyan David, nangabaken Diyos sisya. ");
INSERT INTO kne_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Inturayana din intiro ay Israel et in-inset na ay nanturay ta say kosto ya nalinteg di maamag sin am-in ay ipogaw na. ");
INSERT INTO kne_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Sin namingsan, kanan David, “Ay wada pay laeng di nabay-an sin pamilyan Saulo? Mo wada, laydek ay ipaila di seg-ang ko begew en Jonatan.” ");
INSERT INTO kne_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Sin doy ay timpo, wada di baa sin pamilyan Saulo ay manngadan si Ziba. Inayagan da ta manpaila en David, pag nan kanan en sisya, “Ay sik-a si Ziba?” Songbatana pay yan kanana, “Aw apo, naeyak ay mansilbi en sik-a.” ");
INSERT INTO kne_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Kanan din ari ay nansalodsod, “Ay maga di nabay-an sin pamilyan Saulo si mabalin ay pangipailaak si seg-ang ay kaman din seg-ang Diyos?” Kanan Ziba ay nanongbat, “Wada pay laeng di esa sin an-ak Jonatan ay napengkey di dowa ay siki na.” ");
INSERT INTO kne_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","“Intoy kad-ana?” pinoot din ari. “Wada sin beey Makir ay anak Ammiel ed Lodebar,” kanan Ziba. ");
INSERT INTO kne_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Et inpaayag Ari David sisya. ");
INSERT INTO kne_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Idi domateng si Mefiboset ay anak Jonatan ay anak Saulo sin kad-an David, nanyakog-ong ay mangipaila si pangdayaw na. Kanan David, “Ay sik-a si Mefiboset?” Songbatana pay yan kanana, “Aw apo, sak-en nan baam.” ");
INSERT INTO kne_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Kanan David, “Adi ka emegyat tan laton ay seg-angak sik-a begew en Jonatan ay amam. Itaolik amin en sik-a din dagan Saulo ay apom yan awisek sik-a ay makikan en sak-en si kanayon.” ");
INSERT INTO kne_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Nanyakog-ong kasin si Mefiboset yan kanana, “Ay siya mo sinoak ay baam ta siya na di kinasiged mo en sak-en? Kamanak met nanatey ay aso ay magay silbi na.” ");
INSERT INTO kne_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Pag ayagan din ari si Ziba ay baan Saulo yan kanana, “Idawat ko en Mefiboset ay apon di apom din amin ay sanikwan Saulo ya din pamilya na. ");
INSERT INTO kne_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Sik-a, din an-ak mo ya baam di mangobla sin daga para sin pamilyan Saulo ay apom, asi kayon idawat di maapit ta way kanen da. Ngem si Mefiboset pay et makikan en sak-en si oway.” (Waday sinpo ya lima ay lalaki ay an-ak Ziba ya dowanpo ay baa na.) ");
INSERT INTO kne_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Kanan Ziba sin ari, “Apo ari, tongpalek ay baam di olay sino ay ipaamag mo.” Et nakikikan si Mefiboset en David ay kaman esa sin an-ak na. ");
INSERT INTO kne_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Waday baron Mefiboset ay si Mica di ngadana. Nanbalin ay baan Mefiboset din amin ay pamilya ya baan Ziba. ");
INSERT INTO kne_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Nanbeey ed Jerusalem si Mefiboset ay napengkey di doway siki na yan kanayon ay nakikikan sin ari. ");
INSERT INTO kne_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Idi manlogi di tawen, sin timpo ay makigobgobatan di aari, inbaan David si Joab pati din iib-a na ay papangolon di soldado ya din sosoldadon di Israel ay en makigobat. Inabak da din Ammonita et linikob da din siyodad ay Rabba, ngem si David pay yan nataynan ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Waday esay masdem ay binmangon si David et en nanlikliked sin nasingpa ay atep di palasyo, pag na et osdongan di babai ay man-am-ames yan napintas din babai ay sana. ");
INSERT INTO kne_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Nan-ibaa si David si mangammo mo sino din babai ay sana et naammoana ay si Batseba ay anak Eliam ya asawan Urias ay Heteo. ");
INSERT INTO kne_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Idi siya et di, nan-ibaa si David si en nangayag en Batseba yan inmey sin kad-ana din babai ay sana et dinaag na. (Kakkakdeng na ay nangitongpal sin seremonia ay kalinisana begew sin binowan ay sakit di babai.) Idi nakdeng din nandaagan da sin ari, sinmaa si Batseba. ");
INSERT INTO kne_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Idi baken onay nabayag, nadlaw na ay masikog et nan-ibaa si mangipaammo en David. ");
INSERT INTO kne_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Gapo isdi, inpaibagan David en Joab ay pasaaena si Urias ay Heteo, et inbaan Joab ay emey sin kad-an David. ");
INSERT INTO kne_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Idi domateng si Urias, nandamag si David si maipanggep en Joab ya din sosoldado ya mo intoy ison din gobat. ");
INSERT INTO kne_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Makdeng pay di, kanana en Urias, “Somaa ka ta en ka ilan si asawam.” Kinmaan si Urias sin palasyo yan waday regalo ay inpatolod din ari sin beey na. ");
INSERT INTO kne_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Ngem adi sinmaa, mo adi et nakiseyep sin amin ay baan di apo na sin segpan di palasyo. ");
INSERT INTO kne_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Idi ammoan David ay adi sinmaa si Urias, kanana, “Apay nga adi ka sinmaa yan nabayag ay inmaddawi ka sin beey mo?” ");
INSERT INTO kne_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Kanan Urias en David, “Adi mabalin ay somaaak ay en mangan, man-inom ya manaag en asawak, tan din sosoldadon di Israel ya Juda yan wada da sin gobatan ya say kad-an met laeng din Baol di Tolagan. Din pangolok abe ay si Joab ya din iib-a na ay papangolo yan wada da ay mankamkampo sin nadontog. Isapatak ay adiak polos amagen di kaman nisa.” ");
INSERT INTO kne_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Idi siya di kanan David en sisya, “Mantee kas na ed wani ta si bigat asiak ibaas sik-a ay mantaoli.” Et nantee si Urias ed Jerusalem sin doy ay agew. Sin kabigatana, ");
INSERT INTO kne_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","inawis David sisya ay makikan ya makiinom et bineteng na, ngem sin labi, nakiseyep si Urias sin baan di apo na ay ari et adi sinmaa. ");
INSERT INTO kne_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Sin kabigatana nansolat si David en Joab et inpaw-it na en Urias. ");
INSERT INTO kne_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Siya na di nilaon din solat na, “Ipasangom si Urias sin lugar ay kapigsaan di gobat, asi kayon kataynan ta say kateyana.” ");
INSERT INTO kne_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Et siya di, inbaan Joab si Urias sin lugar ay kapigsaan di kalaban. ");
INSERT INTO kne_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Idi bomala din sosoldado sin siyodad ay nangobat en da Joab, natey din odom ay papangolon di soldadon David, pati si Urias ay Heteo. ");
INSERT INTO kne_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Idi dengngen din asawan Urias ay natey sisya, inladladingitana. ");
INSERT INTO kne_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Makdeng pay din timpo ay pangiladingitana, inpaayag David sin beey na et nanbalinena ay asawa na yan nan-anak si lalaki. Ngem baken nalaydan si Diyos sin inamag David. ");
INSERT INTO kne_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Idi siya di, inbaan Diyos si Natan sin kad-an David. Idi domateng sin kad-ana, kanana, “Wada di dowa ay lalaki sin esa ay ili. Nabaknang din esa yan nabiteg din esa. ");
INSERT INTO kne_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Din baknang ay sana yan ad-adoy baka ya karnero na, ");
INSERT INTO kne_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","ngem din nabiteg pay yan maga polos di sanikwa na malaksig di esay kitkittoy ay bomalasang ay karnero ay nilakoana. Inay-ayowanana ya dinakdake na sin beey na ay kadwan din an-ak na. Din kankanena di ipakana, pan-inomena sin tasa na ya bakbakwaena, tan inbilang na ay esa sin an-ak na. ");
INSERT INTO kne_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Sin namingsan, waday dinmateng ay sangailin din baknang ay sana. Sigaana di kapartian di esa sin animal na, ngem say ina na et din bomalasang ay karneron di nabiteg et say pinalti na ay inpasango sin bisita na.” ");
INSERT INTO kne_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Palalo di bonget David sin baknang, isonga kanana, “Isapatak sin matmatago ay Diyos ay masapol ay matey din ipogaw ay nangamag si kaman nisa. ");
INSERT INTO kne_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Gapo sin inamag na ay magay seg-ang na, masapol abe ay mamin opat di kaad-adon di ibayad na sin ina na.” ");
INSERT INTO kne_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Pag kanan Natan en David, “Sik-a din ipogaw ay doy! Siya na di kanan Yahweh ay Diyos di Israelita: Nanbalinek sik-a ay arin di Israel ya insalakan kos sik-a sin panakabalin Saulo. ");
INSERT INTO kne_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Indawat kon sik-a din iturayana ya din aasawa na et nanbalinek sik-a ay ari ed Israel ya Juda. Mo kolang dana, dobliek pay koma di kaad-adon di idawat kon sik-a. ");
INSERT INTO kne_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Apay pay laeng ay adi kan tinongpal din bilin ko? Apay nga inamag mo di kaman nina ay basol? Inpapsem si Urias sin gobatan. Inpapsem sin Ammonita, asi ka pay posen si asawa na. ");
INSERT INTO kne_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Isonga ed wani, sin tonggal sinkapoli ay apom, wadan to ay wada di matey si kampilan, tan adi ka tinongpal sak-en yan pinos mo din asawan Urias. ");
INSERT INTO kne_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Isapatak en sik-a ay pawadaek sin pamilyam di mangidawat si panligatam. Sin pangiilaam et ipolang kon to din aas-awam si ib-am et daagenas daida ay sipaparang sin kaagawan. ");
INSERT INTO kne_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Inlimed mo ay inamag, ngem awni et ipaamag ko sin pangiilaan di amin ay Israelita.” ");
INSERT INTO kne_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Pag kanan David en Natan, “Nanbasolak kayman en Diyos.” Songbatan pay Natan yan kanana, “Pinakawan Diyos sik-a sin basol mo et adi kan matey. ");
INSERT INTO kne_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Ngem gapo ta dadlon kan nilaslasoy si Diyos isnan inamag mo, matey din anak mo.” ");
INSERT INTO kne_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Idi sinmaa si Natan, nansakiten Diyos din anak da David sin asawan Urias. ");
INSERT INTO kne_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Nanpakpakaasi si David en Diyos ta mailatonan din anak. Adi nangnangan et en nanlaklakob-o ay maninsinlabi sin lota. ");
INSERT INTO kne_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Pinadpadas din oopisyal na sin palasyo ay pabangonen sisya, ngem sinigaana ay bomangon ya makikan en daida. ");
INSERT INTO kne_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Sin maikapito ay agew, natey din anak. Emegyat din oopisyal David ay mangibaga en sisya, tan kanan das nemnem da, “Idi matmatago pay laeng din anak, adi ikaskason David din ibaga tako. Intoy iyat tako pay ay mangibaga ay natey din anak na? Amangan mo lawa di amagena sin awak na.” ");
INSERT INTO kne_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Inilan David ay man-aayasak din oopisyal na, yan naawatana ay natey din anak, isonga nansalodsod ay kanana, “Ay natey din anak?” “Aw,” kanan da ay nanongbat. ");
INSERT INTO kne_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Idi siya di, binmangon si David yan nan-ames, nansagaysay ya nansokat. Pag en mandaydayaw sin beey di Diyos. Idi nantaoli sin palasyo, nankedaw si kanena et nangan. ");
INSERT INTO kne_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Kanan din oopisyal na ay nansalodsod, “Adi kamin maaw-awatan nan am-amagem. Idi matmatago din anak, inog-ogaam ya adi kan nangnangan, ngem ed wani ay natey yan binmangon ka ya nangan ka.” ");
INSERT INTO kne_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Kanana ay nanongbat en daida, “Idi matmatago din anak, inog-ogaak ya init-itpek di dagaang ko, tan kanak si nemnem ko en mo maseg-ang si Diyos en sak-en ya ipalobos na ay matago din anak. ");
INSERT INTO kne_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Ngem ed wani ay natey din anak, sinoy gapo pay laeng ay itpek di dagaang ko? Ay siya mo mabalin ay tagoek sisya? Sin tapin di agew, enak datngen sisya, ngem adi mabalin ay mantaolis sisya en sak-en.” ");
INSERT INTO kne_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Makdeng pay di, niliwliwan David si asawa na ay Batseba. Nandaag da et nawad-an yan nan-anak si lalaki ay nginadanana si Solomon. ");
INSERT INTO kne_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Kinantan David din kanta ay nay sin nangisalakanan Diyos en sisya sin amin ay kalabana ya sin panakabalin Saulo. ");
INSERT INTO kne_vpl VALUES ("S222_2","011_22_2","2SA","22","2","3","Kanana, “Si Yahweh ay Diyos ko di omisalakan. Maiarig si dontog ay enak pantabonan ono dakdake ay bato ay enak pankamangan. Mo wadaak en sisya, magay pan-egyatan, tan kaman mayat ay pantabonan ay adi makasgep di kalaban. Kaman ko aben salida ay somalaknib sin lawa, napigsa ay omisalakan sin ipogaw ay magay seg-ang da. ");
INSERT INTO kne_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Mankedawak si badang Diyos et omisalakan sin kalaban ko. Lebbeng na ay madayaw si Diyos Apo. ");
INSERT INTO kne_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Nan pese et kaman dalloyon ay nanepyasepyat en sak-en, kaman layos ay dandani ay mangianod en sak-en. ");
INSERT INTO kne_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Kamanak napolipolan si tali ay omigoyod sin kad-an di natey, din pese yan nangisagana si kaknaak koma ay tagdey. ");
INSERT INTO kne_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","Sin palalo ay ligat ko, kindaw ko din badang Yahweh ay Diyos ko, et sin Timplo na, dinnge na din adawag ko. ");
INSERT INTO kne_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Binindisyonan Diyos sak-en gapo sin kinalinteg ko, indawat nay gon-gonak tan maga di basol ko. ");
INSERT INTO kne_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Tan nantongtongpalak sin laydena, adiak binmasol ay nanokog en sisya. ");
INSERT INTO kne_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Tinongtongpal ko amin ay linteg na, magay linabsing ko ay bilina. ");
INSERT INTO kne_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Sin sangoanan Diyos, magay maipabasol en sak-en, tan inaddawiak di enak panbasolan. ");
INSERT INTO kne_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Isonga idawat na di gon-gonak gapo sin kinalinteg ko, tan ammo na ay maga di basol ko. ");
INSERT INTO kne_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","Sin ipogaw ay matalek, ipaila na ay matalek sisya, ipaila na din kinasanto na sin magay kaoyawana. ");
INSERT INTO kne_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Sin nalinis et maila din kinalinis na, ngem sin nasikap ay manowitik si ib-a na, nalaing si Diyos ay mangabak en sisya. ");
INSERT INTO kne_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Isalakana din napakombaba, ngem ipababa na din mangipapangatos awak na. ");
INSERT INTO kne_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","Si Yahweh ay Diyos ko di silaw ko, silawana din mabolinget ay danan ko.” ");
INSERT INTO kne_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Idi dandani ay matey si David, kanana ay nangibilin en Solomon ay anak na, ");
INSERT INTO kne_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“Dandani di kateyak, isonga papigsaem di nemnem mo ya tomoled ka. ");
INSERT INTO kne_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Tongpalem din ipaamag Diyos en sik-a ya din amin ay linteg ya bilin ay naisolat sin linteg Moses ta say mayat di pantongpalan di am-in ay amagem olay intoy em-emeyam. ");
INSERT INTO kne_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Mo say iyat mo di, tongpalen Diyos din inkari na en sak-en. Tan kanana en mo ipakat din polik din kabaelan da ay mangonod en sisya ya esten da ay manongpal sin bilbilina, kanayon ay wada en daida di manturay ed Israel si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Idi siya di, natey si David et naiponpon sin sakop di Jerusalem ay nangadanan si Siyodad en David. ");
INSERT INTO kne_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Nanturay ed Israel si opatapolo ay tawen, pito ay tawen sin kawada na ed Hebron yan tolonpo ya tolo ay tawen sin inmeyana ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Et say naisokat ay nan-ari si Solomon ay anak na yan pinmigsa din kinaturay na. ");
INSERT INTO kne_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Inpailan Solomon din layad na en Diyos et tinongpal na din bilbilin David ay ama na, ngem asi et nan-idaton si animal ya nan-ipoo si insinso sin pandaydayawan ay wada sin dodontog. ");
INSERT INTO kne_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Sin namingsan, inmey si Solomon ay nan-idaton ed Gibeon, tan say kad-an din inbilang da ay kabanolan ay pandaydayawan. Sinlibo ay animal di indatonas di. ");
INSERT INTO kne_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Sin isdi ay lugar, nanpailas Diyos en Solomon sin labi babaen si iitaw yan kanana, “Mankedaw kas kompormi ay laydem ay kedawen en sak-en.” ");
INSERT INTO kne_vpl VALUES ("K13_6","012_3_6","1KI","3","6","7","Kanan Solomon ay nanongbat, “Yahweh ay Diyos ko, inpappailam din dakdake ya adi manbalbaliw ay layad ya seg-ang mo en David ay amak ay baam, tan inpapasnek na ay mansilbi en sik-a. Nalinteg abe ya siged sin pangiilaam. Intoltoloy mo ay nangipaila si dakdake ay seg-ang mo en sisya tan indawtam si anak ay maisokat en sisya ay manturay ed wani ay agew. Et nay nanbalinem sak-en ay ari ta say maisokatak en amak ay David, ngem an-anakak pay laeng et adiak ammo di iyat ko ay manturay. ");
INSERT INTO kne_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Naeyak sin kad-an di pinilim ay ipogaw mo yan palalo ay ad-ado da ay adi kabilang. ");
INSERT INTO kne_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Isonga idawtam kod sak-en si laing ta say kosto di iyat ko ay mangituray sin ipogaw mo ya ammok ay mangilasin si siged ya lawa, tan naligat ay iturayan nan ipogaw ay palalo ay ad-ado.” ");
INSERT INTO kne_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Nalaydan si Diyos sin kindaw Solomon ay doy, ");
INSERT INTO kne_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","isonga kanana en sisya, “Gapo ta say kindaw mo na ay baken ando ay biyag ono kinabaknang para en sik-a ya baken din kateyan di kalaban mo, mo adi et din laing ay mangilasin si siged, ");
INSERT INTO kne_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","patgak sa ay kindaw mo. Idawtak sik-a si laing ya kabaelan ay mangilasin si kosto et maga polos di makaiso en sik-a ed idi engganad wani ya olay sin tapin di agew. ");
INSERT INTO kne_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Olay abe din adim kindaw et idawat ko. Idawtak sik-a si kinabaknang ya dayaw sin intiro ay biyag mo ay magay makaiso sin odom ay ari. ");
INSERT INTO kne_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Mo tongpalem din bilbilin ya linteg ko ay kaman din inyat amam ay David, paandoek abe din biyag mo.” ");
INSERT INTO kne_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Pag bomangon si Solomon et say nangammoana ay iitaw baw di. Inmey ed Jerusalem et en pinmika sin sangoanan di Baol di Tolagan Diyos. Isdi, nan-idaton si mapooan ya daton ay pan-ookoban da ya makikadkadwaan da en Diyos. Pag manpalti si ad-ado para sin am-in ay opisyal na. ");
INSERT INTO kne_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Baken nabayag, wada et di dowa ay mangilaklakos kinababai da ay inmey sin ari. ");
INSERT INTO kne_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Kanan din esa, Apo ari, es-esa ay beey di pantetean mi sin babai ay nay. Yan idi wadas sisya sin beey ay kad-ak, nan-anakak si lalaki. ");
INSERT INTO kne_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Sin katlo na, nan-anak abes sisya si lalaki. Magay odom ay ipogaw sin beey ay doy mo adi et dakami anggoy ay dowa. ");
INSERT INTO kne_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Sin esay labi, natey din anak na tan tinap-ilana. ");
INSERT INTO kne_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Idi naseseyepak, binmangon sin gawan di labi et nansokatena din dowa ay moyang. Say inpadaag nan sak-en din anak na yan say dinaag na din anak ko. ");
INSERT INTO kne_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Idi binmangonak sin kabigatana yan pansosoek koma din anak ko, inilak et ay nanatey. Ngem idi estek ay imatonan, nailak ay baken met din anak ko. ");
INSERT INTO kne_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Nankali abe din esay babai yan kanana, “Aga! Say natey din anak mo et anak ko din matmatago.” Et nansongbat da sin sangoanan di ari. ");
INSERT INTO kne_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Pag kanan din ari, “Kanan din esa en anak na din matmatago yan anak din esa din natey, ngem siya met laeng abe din ibagbagan di esa.” ");
INSERT INTO kne_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Idi siya di kanana, “Man-iali kayo si kampilan.” Idi indateng da, ");
INSERT INTO kne_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","kanana ay nangibilin, “Godwaen yo din matmatago ay anak ta panbingayan da.” ");
INSERT INTO kne_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Ngem gapo sin palalo ay layad ya seg-ang din tet-ewa ay akin anak, kanana sin ari, “Apo, pangaasim ta adi yo peslen. Olay idawat yo en sisya.” Din esa pay yan kanana, “May et, godwaen yo. Olay magay mangoka en dakami.” ");
INSERT INTO kne_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Pag kanan din ari, “Adi yo peslen din moyang mo adi et idawat yo sin namangpango ay babai. Sisya di tet-ewa ay akin anak.” ");
INSERT INTO kne_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Idi dinngen din amin ay Israelita din inkeddeng di ari, palalo ay pinatpateg ya dinaydayaw das sisya, tan naila da ay waday laing na ay napon Diyos ay mangikeddeng si kostokosto sin kaskasos. ");
INSERT INTO kne_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Kaman din kaad-adon di darat sin igid di baybay din kaad-adon di ipogaw ed Juda ya Israel. Napnek da ay nangnangan ya nan-in-inom et naragsak da. ");
INSERT INTO kne_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Inturayan Solomon din amin ay nasyon manipod sin ginawang ay Eufrates engganad Filistia ya sin beddeng di Egipto. Nanbowis ya nansilbi dan Solomon sin intiro ay timpon di biyag na. ");
INSERT INTO kne_vpl VALUES ("K14_34","012_4_34","1KI","4","34","34","Nadamag di kaariari sin intiro ay lobong din kinalaing Solomon et nan-ibaa das ipogaw ay en nandenge en sisya. ");
INSERT INTO kne_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Idi dinngen Hiram ay ari ed Tiro ay nadotokan si Solomon ay maisokat en Ari David ay ama na, nan-ibaa si panakaawak na ay emey en Solomon. Si Hiram ay nay yan nabayag ay gayyem en David. ");
INSERT INTO kne_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Idi nantaoli da din inbaan Hiram, siya na di inpaibagan Solomon, ");
INSERT INTO kne_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“Ammom ay adi nasangon amak ay David ay mangisaad si timplo ay pandayawan di ipogaw en Yahweh ay Diyos na gapo ta kanayon ay ginobgobat di odom ay nasyon enggana ay nangabaken Diyos sisya sin amin ay kalabana. ");
INSERT INTO kne_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Ngem ed wani, indawtan Yahweh sak-en si talna sin amin ay soli tan maga di kalaban ono lawa ay pasamak. ");
INSERT INTO kne_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Isonga panggep ko ay mangisaad si timplo ay pandaydayawan di ipogaw en sisya ay kaman din inbaga na en amak ay David. Kanana, ‘Din anak mo ay isaad ko ay maisokat en sik-a ay manturay di mangamag si timplo ay pandaydayawan dan sak-en.’ ");
INSERT INTO kne_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Isonga man-ibaa kas ipogaw mo ay en man-getad si sidro ed Lebanon para en sak-en. Mantinolong din ipogaw ta, ta asiak idawat en sik-a din lagbon di ipogaw mo, olay pigay ibagam, tan ammom ay maga en dakami di makaiso sin laing di taga-Sidon ay man-getad si kaiw.” ");
INSERT INTO kne_vpl VALUES ("K15_10","012_5_10","1KI","5","10","10","Et siya di, inpaiey Hiram amin din kasapolan Solomon ay nabanglo ay kaiw ay makwani en sidro ya bebe. ");
INSERT INTO kne_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","Et pag isaganan di karpintiron da Solomon en Hiram pati din taga-Gebal din tabla ya bato ay kasapolan sin maamag ay timplo. ");
INSERT INTO kne_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Inlogin Solomon ay nangisaad sin Timplo sin maika-480 ay tawen manipod sin kinmaanan di Israelita ed Egipto, sin maikap-at ay tawen ay panturayana ed Israel. Inlogi na sin maikadwa ay bowan ay kanan da en Ziv. ");
INSERT INTO kne_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Kanan Diyos en Solomon, ");
INSERT INTO kne_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","“Mo maipanggep sin Timplo ay nay ay am-amagem, ipatongpal ko babaen en sik-a din inkarik en amam ay David mo ipapasnek mo ay tongpalen amin ay linteg ya bilin ko. ");
INSERT INTO kne_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Et makiteeak sin ipogaw ko ay Israelita ya adiak baybay-an daida.” ");
INSERT INTO kne_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Et siya di, inamag Solomon din Timplo enggana ay nakdeng. ");
INSERT INTO kne_vpl VALUES ("K16_38b","012_6_38b","1KI","6","38b","38b","Pito ay tawen di nangamagan Solomon sin Timplo ay sana. ");
INSERT INTO kne_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Idi siya di, inpaayag Ari Solomon am-in ay papangolon di tribu ya pamilyan di Israelita ta matopog da ed Jerusalem ta en da alaen din Baol di Tolagan Diyos ed Zion ay makwani en Siyodad David ta itikid da sin Timplo. ");
INSERT INTO kne_vpl VALUES ("K18_2","012_8_2","1KI","8","2","2","Nasinop da am-in sin kad-an di ari sin timpon di fiesta ay makwani en Pansidoman sin maikapito ay bowan ay makwani en Etanim. ");
INSERT INTO kne_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Idi dinmateng da am-in, tinilid din papadi din Baol di Tolagan, ");
INSERT INTO kne_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","et in-ey da sin Timplo. In-ey aben din papadi ya odom ay Levita din Tolda ay Panpappailaan Diyos ya din am-in ay maosal sidi. ");
INSERT INTO kne_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Pag masinop da Solomon ya din am-in ay Israelita sin sangoanan di Baol et nan-idaton das adi kabilang ay baka ya karnero. ");
INSERT INTO kne_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Makdeng pay di, inpasgep din papadi din Baol di Tolagan Diyos sin Timplo et inpeey da sin Kasasantoan ay Kowarto sin pinapayongan di payak di kerubim, tan say lebbeng na ay kad-ana. ");
INSERT INTO kne_vpl VALUES ("K18_9","012_8_9","1KI","8","9","9","Magay odom si naigto sin Baol mo adi et din dowa ay nadampilak ay bato ay inigton Moses sin kawada na sin dontog ay Sinai. Isdi di nangipaammoan Diyos sin intolag na sin Israelita sin nakdeng ay kinmaanan da ed Egipto. ");
INSERT INTO kne_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Idi kinmaan din papadi sin Timplo, napno si liboo ");
INSERT INTO kne_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","ay mankoniniing begew sin kawadan Diyos, isonga adi da kasin makasgep ay mangitoloy sin am-amagen da. ");
INSERT INTO kne_vpl VALUES ("K18_12","012_8_12","1KI","8","12","12","Pag kanan Solomon ay nankararag, “Sik-a ay Diyos et kinwanim en naposkol ya mabolinget ay liboo di panbeeyam. ");
INSERT INTO kne_vpl VALUES ("K18_13","012_8_13","1KI","8","13","13","Nay di inpasaad ko ay maptemapteng ay timplo ay panbeeyam si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("K18_14","012_8_14","1KI","8","14","14","Idi wadas di din intiro ay gimong di Israelita ay pinmipika, sinagong din ari si daida, et pag nan bindisyonan daida. ");
INSERT INTO kne_vpl VALUES ("K18_15","012_8_15","1KI","8","15","15","Kanana, “Madaydayaw si Yahweh ay Diyos di Israelita. Babaen sin panakabalina, tinongpal na din inkari na en amak ay David. ");
INSERT INTO kne_vpl VALUES ("K18_16","012_8_16","1KI","8","16","16","Tan kanana, ‘Manipod sin agew ay nangipangoak sin Israelita ay ipogaw ko ay komaan ed Egipto, magay pinilik ay siyodad sin intiro ay Israel ay kaisaadan di Timplok ay pandaydayawan da en sak-en. Ngem pinilik si David ay mangituray sin Israelita ay ipogaw ko.’ ");
INSERT INTO kne_vpl VALUES ("K18_17","012_8_17","1KI","8","17","17","Layden amak ay David ay man-amag si timplo ay panbeeyan Yahweh ay Diyos di Israelita, ");
INSERT INTO kne_vpl VALUES ("K18_18","012_8_18","1KI","8","18","18","ngem kanan Diyos en sisya, ‘Kosto di ninemnem mo tan laydem kayman ay man-amag si timplo ay pandayawan da en sak-en. ");
INSERT INTO kne_vpl VALUES ("K18_19","012_8_19","1KI","8","19","19","Ngem baken sik-a di mangamag sin Timplo mo adi et din anak mo ay ipolim to. Sisya di mangisaad sin Timplo ay panbeeyak.’ ");
INSERT INTO kne_vpl VALUES ("K18_20","012_8_20","1KI","8","20","20","Tinongpal Diyos din kari na tan nay sak-en di naisokat en David ay amak ay manturay isnan Israel ay kaman met laeng din inkari na. Natongpal abe ay inamag ko din Timplo ay panbeeyan ya maidaydayawan Yahweh ay Diyos di Israelita. ");
INSERT INTO kne_vpl VALUES ("K18_21","012_8_21","1KI","8","21","21","Waday inpaisaganak isdi ay kaipay-an din Baol ay naidolinan di intolag Diyos sin ap-apo tako sin nangipangoana en daida ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Pag pomika si Solomon sin sagang di altar sin sangoanan di intiro ay gimong di Israelita yan nandepa ay nangisagang sin takkay na ed langit. ");
INSERT INTO kne_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","Kanana, “Sik-a ay Yahweh ay Diyos di Israelita, magay odom ay Diyos si makaiso en sik-a ed daya ya isnan daga. Dadlon kan tongpalen din intolag mo ya ipailam din adi manbalbaliw ay layad ya seg-ang mo sin ipogaw mo ay mangitoltoloy ay mangimongsan si amin ay nemnem da ay mansilbi en sik-a. ");
INSERT INTO kne_vpl VALUES ("K18_24","012_8_24","1KI","8","24","24","Tinongpal mo din inkarim en amak ay David ay baam. Ed wani ay agew, sik-a ay mismo di nanongpal babaen sin panakabalin mo. ");
INSERT INTO kne_vpl VALUES ("K18_25","012_8_25","1KI","8","25","25","“Yahweh, sik-a ay Diyos ay daydayawen di Israelita, sapay koma ngarud ta tongpalem abe din esa ay inkarim en amak ay mantoltoloy ay wadan to di dotokam sin poli na ay manturay isnan Israel, dalo et mo esten da ay manongpal en sik-a ay kaman din inyat na. ");
INSERT INTO kne_vpl VALUES ("K18_26","012_8_26","1KI","8","26","26","Isonga ed wani, kedawek en sik-a ay Diyos di Israelita ta tongpalem kod na ay inkarim en amak ay David ay baam. ");
INSERT INTO kne_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","“Ngem ay tet-ewa aya ay mantee ka isnan daga? Mo din kangatoan ay langit yan adi dakan malaon, adi pay masepsep et nan inamag ko ay Timplo. ");
INSERT INTO kne_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Ngem olay mo siya di, dengngem kod ay Diyos ko nan kararag ko ay baam ay mankedaw si seg-ang mo. Dengngem kod nan kararag ya adawag ko isnan sangoanam ed wani ay agew. ");
INSERT INTO kne_vpl VALUES ("K18_29","012_8_29","1KI","8","29","30","Bantayam kod nan Timplo si inag-agew ya nilablabi tan sinay di lugar ay pinilim ay panbeeyam ya pandayawan da en sik-a, isonga dengngem koma di kararag ko ya din ipogaw mo ay Israelita mo mankararag kami ay manasagang isnan Timplo. Issan ed langit ay kad-am dengngem koma din kararag mi ya pakawanem dakami. ");
INSERT INTO kne_vpl VALUES ("K18_41","012_8_41","1KI","8","41","41","“Olay din mangili ed addawi ay baken Israelita ay ipogaw mo, et omali da begew sin kinangaton di ngadan mo. ");
INSERT INTO kne_vpl VALUES ("K18_42","012_8_42","1KI","8","42","42","Tan mandinamag to sin kailiili din panakabalin mo ay mangamag si olay sino ay laydem. Mo omali da ay mankararag ay manasagang isnan Timplo, ");
INSERT INTO kne_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","dengngem koma issan ed langit ay kad-am din kararag da ta patgam amin ay kedawen da ta say maammoan di amin ay ipogaw isnan daga si sik-a et egyatan ya patgen das sik-a ay kaman din iyat di Israelita ay ipogaw mo. Et maammoan da abe ay din Timplo ay nay ay inamag ko yan say panbeeyam ya pandaydayawan di ipogaw en sik-a. ");
INSERT INTO kne_vpl VALUES ("K18_44","012_8_44","1KI","8","44","44","“Mo en makigobat din ipogaw mo, olay intoy pangibaaam en daida ya mankararag da ay nakasango isnan siyodad ay pinilim ya sin Timplo ay inamag ko ay panbeeyam, ");
INSERT INTO kne_vpl VALUES ("K18_45","012_8_45","1KI","8","45","45","dengngem koma ed langit din kedawen da ta pangabakem daida. ");
INSERT INTO kne_vpl VALUES ("K18_46","012_8_46","1KI","8","46","46","Mo manbasol da en sik-a tan magay ipogaw ay adi manbasol, et bomonget kan daida ya bay-am ay abaken din kalaban da ya itakin da sin ili da ay addawi ono asag-en; ");
INSERT INTO kne_vpl VALUES ("K18_47","012_8_47","1KI","8","47","47","ngem no sin lugar ay naibalodan da ya manbabawi da et ipodno da din basol da, dengngem koma din kararag da. ");
INSERT INTO kne_vpl VALUES ("K18_48","012_8_48","1KI","8","48","48","Dengngem koma din kararag da mo tet-ewa ay manbabawi da ya sagongen das sik-a sin ili ay naibalodan da ya sagangen da din daga ay indawat mo sin ap-apo da, ya din pinilim ay siyodad ya Timplo ay inamag ko ay panbeeyam. ");
INSERT INTO kne_vpl VALUES ("K18_49","012_8_49","1KI","8","49","49","Dengngem koma din kararag da issan ed langit ay kad-am ta maseg-ang kan daida. ");
INSERT INTO kne_vpl VALUES ("K18_50","012_8_50","1KI","8","50","50","Pakawanem koma din ipogaw mo sin amin ay nanbasolan dan sik-a ta iturong mo ay seg-angan din nangibalod en daida. ");
INSERT INTO kne_vpl VALUES ("K18_51","012_8_51","1KI","8","51","51","Tan daida din mismo ay ipogaw mo ay inpangom ay komaan ed Egipto ay nanlak-aman das palalo ay ligat ay maiarig si manbidbidang ay apoy. ");
INSERT INTO kne_vpl VALUES ("K18_52","012_8_52","1KI","8","52","52","Sapay koma ta maseg-ang ka ya kanayon ay dengngem din adawag ya kararag ko ay baam ya din ipogaw mo ay Israelita. ");
INSERT INTO kne_vpl VALUES ("K18_53","012_8_53","1KI","8","53","53","Tan mismo ay sik-a ay Kangatoan ay Diyos yan pinilim daida sin amin ay nasyon isnan daga ta daida di manbalin ay ipogaw mo ay kaman din inbagam en Moses ay baam sin nangipangoam sin ap-apo mi ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("K18_54","012_8_54","1KI","8","54","54","Idi nakdeng ay nankararag si Solomon, pinmika sin sangoanan di altar ay nandokmogana ay nangikayang sin takkay na. ");
INSERT INTO kne_vpl VALUES ("K18_55","012_8_55","1KI","8","55","55","Pinmika et inbogaw na ay namindisyon sin intiro ay gimong di Israelita. Kanana, ");
INSERT INTO kne_vpl VALUES ("K18_56","012_8_56","1KI","8","56","56","“Madaydayaw si Diyos ay nangidawat si pan-illengan din Israelita ay ipogaw na ay kaman din inkari na. Magay olay esa ay adi natongpal sin inkari na en Moses ay baa na. ");
INSERT INTO kne_vpl VALUES ("K18_57","012_8_57","1KI","8","57","57","Sapay koma ta si Yahweh ay Diyos tako yan kanayon ay komadkadwa ay kaman din inyat na sin aam-a tako. Sapay koma ta adi na taytaynan ya baybay-an si datako. ");
INSERT INTO kne_vpl VALUES ("K18_58","012_8_58","1KI","8","58","58","Sapay koma ta iturong nas datako ay mangonod sin amin ay laydena ya mantongpal sin linteg ya bilbilina ay inpaammo na sin ap-apo tako. ");
INSERT INTO kne_vpl VALUES ("K18_59","012_8_59","1KI","8","59","59","Sapay koma ta kanayon ay nemnemen Diyos dana ay inkararag ko en sisya ta kanayon ay seg-angana din ipogaw na ay Israelita ya din ari da sin kasapolan das inag-agew. ");
INSERT INTO kne_vpl VALUES ("K18_60","012_8_60","1KI","8","60","60","Et mo siya di, maammoan di ipogaw sin amin ay ili isnan lobong ay si Yahweh anggoy di Diyos ay magay odom. ");
INSERT INTO kne_vpl VALUES ("K18_61","012_8_61","1KI","8","61","61","Masapol koma ngarud ay imongsan yo din nemnem yo en Yahweh ay Diyos tako ta kanayon ay tongtongpalen yo din linteg ya bilbilina ay kaman ed wani.” ");
INSERT INTO kne_vpl VALUES ("K19_1","012_9_1","1KI","9","1","1","Idi kindeng Solomon din Timplo ay panbeeyan Diyos ya din palasyo, ya din amin ay laydena ay amagen, ");
INSERT INTO kne_vpl VALUES ("K19_2","012_9_2","1KI","9","2","2","nanpaila kasin si Diyos en sisya ay kaman din inyat na ed Gibeon. ");
INSERT INTO kne_vpl VALUES ("K19_3","012_9_3","1KI","9","3","3","Kanan Diyos en sisya, “Dinngek din kararag mo en sak-en et nanbalinek ay nasantoan din Timplo ay inamag mo babaen sin manteeak isdi si eng-enggana. Kanayon ay ayowanak ya salaknibak din Timplo ay doy. ");
INSERT INTO kne_vpl VALUES ("K19_4","012_9_4","1KI","9","4","4","Mo sik-a pay, mo kaman kan si amam ay David ta nalinteg ya kosto di amagem sin pangiilaak, ya patiem amin ay linteg ya ibilin ko, ");
INSERT INTO kne_vpl VALUES ("K19_5","012_9_5","1KI","9","5","5","tongpalek to din inkarik en amam ay David ay mantoltoloy di panturayan di poli na isnan Israel si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("K19_6","012_9_6","1KI","9","6","6","Ngem mo sik-a ya din an-ak mo yan adi yon tongpalen din linteg ya bilbilin ko en dakayo ya mansilbi ya mandayaw kayo si sinan didiyos, ");
INSERT INTO kne_vpl VALUES ("K19_7","012_9_7","1KI","9","7","7","taynak to nan Timplo ay intoding ko ay panbeeyak. Pakaanek abe din Israelita sin lugar ay indawat ko en daida et palalo ay laslasoyen di odom ay nasyon si daida. ");
INSERT INTO kne_vpl VALUES ("K19_8","012_9_8","1KI","9","8","8","Dadlon mabakas din Timplo ay nay et masdaaw to di malabas. Kanan da, ‘Apay ngata ay say inamag Diyos na isnan ili ya Timplo ay nay?’ ");
INSERT INTO kne_vpl VALUES ("K19_9","012_9_9","1KI","9","9","9","Et kanan di odom ay manongbat, ‘Tan dinokogan das Yahweh ay Diyos da ay nangipango sin ap-apo da ay kinmaan ed Egipto. Sinagong da di odom ay diyos ta say pansilbian ya daydayawen da, et say gapo ay inpalak-am Diyos amin dana ay ligat en daida.’” ");
INSERT INTO kne_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Idi dinngen din reyna ed Seba din mandinamag ay laing Solomon ay napo en Diyos, ena pinadas si Solomon si nankaliligat ay salodsod. ");
INSERT INTO kne_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Ad-ado di inkoyog na ay baa. Kinoyog na abe di ad-ado ay kamel ay nailoganan di ad-ado ay bangbanglo, balitok ya nankangingina ay bato. Idi dinmateng da sin siyodad, inmey sin kad-an Solomon et sinalodsod na amin ay manemnem na. ");
INSERT INTO kne_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Sinongbatan Solomon am-in et adi polos naligatan ay nangilawlawag en sisya. ");
INSERT INTO kne_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Idi dinngen din reyna din kinalaing Solomon ya inila na din inamag na ay palasyo, ");
INSERT INTO kne_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","din makan ay maisagana sin lamisaana, din panakaolnos di oopisyal na, din mansilsilbi ya din nabanol ay osal da, din man-itagtagay si arak ya din aanimal ay inpaidatdaton Solomon ay mapooan sin Timplon Diyos, palalo ay nasdaaw sisya. ");
INSERT INTO kne_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Kanana, “Tet-ewa baw din dinngek sin ilik maipanggep sin inam-amag mo ya laing mo. ");
INSERT INTO kne_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Ngem adiak pinati dana enggana ay inmaliak et inilak ay mismo. Di katet-ewa na baw et kolang pay si kagodwa din naipadamag en sak-en, tan din laing ya kinabaknang mo et addawi ay nasurok mo din naipadamag. ");
INSERT INTO kne_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Nagasat da din aasawam ya din oopisyal mo ay kanayon ay wada sin sangoanam ay mandengdenge sin kinalaing mo. ");
INSERT INTO kne_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Madaydayaw koma si Yahweh ay Diyos mo ay nangipaila si layad na en sik-a ya nangisaad en sik-a ay ari isnan Israel. Gapo sin adi manbalbaliw ay layad Diyos sin Israelita, insaad nas sik-a ay ari ta mantoltoloy di siged ya kinalinteg.” ");
INSERT INTO kne_vpl VALUES ("K110_10","012_10_10","1KI","10","10","10","Idi nakdeng di, indawtan din reyna si Solomon si nasurok ay opat ay libo ay kilo ay balitok, ad-ado ay bangbanglo ya nankangingina ay bato. Si doy di kaad-adoan ay bangbanglo ay inawat Solomon. ");
INSERT INTO kne_vpl VALUES ("K110_11","012_10_11","1KI","10","11","11","Malaksig isdi, nan-idateng abe din bapor Hiram ay nankarkarga si balitok ay napo ed Ofir, ad-ado ay mankakakneg ay kaiw ay makwani en almug ya nankababanol ay bato. ");
INSERT INTO kne_vpl VALUES ("K110_12","012_10_12","1KI","10","12","12","Inosal din ari din kaiw ay nay ay para posti sin Timplon Diyos ya sin palasyo. Naamag abe si gitara ya arpa ay osalen din mantoktokar. Da nay ay almug di kamayatan ay kaiw ay naidateng ed Israel. Magay odom ay naila si kaman dadi enggana ed wani. ");
INSERT INTO kne_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","Indawat Ari Solomon am-in ay kindaw din reyna ed Seba malaksig sin odom ay sagot ay indawat na. Makdeng pay di, sinmaa din reyna ay nangikoyog sin baa na. ");
INSERT INTO kne_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Ad-ado di laydelayden Solomon ay mangili ay babbabai. Baken anggoy din anak di ari ed Egipto, mo adi et nangasawa pay si babai ay Heteo ya Ammonita ya Moabita, ya taga-Edom ya Sidon. ");
INSERT INTO kne_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Inasawa nas daida olay mo inbilin Diyos sin Israelita ay adi da makiasawa si mangili tan daida di mangawis en daida ay mandayaw sin diyos da. Ngem palalo pay dedan di layad Solomon en daida. ");
INSERT INTO kne_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Pito ay gasot di asawa na ay anak di ari ya wada abey tolo ay gasot ay nababa di kasasaad da. Daida di gapo ay dinokoganas Diyos, ");
INSERT INTO kne_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","tan idi nakay sisya, inawis da ay mandayaw si odom ay diyos et naksayan din layad na en Diyos ay baken kaman si David ay ama na. ");
INSERT INTO kne_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Nandayaw en Astarte ay daydayawen di taga-Sidon ya si Molek ay say kadodogis ay diyos di Ammonita. ");
INSERT INTO kne_vpl VALUES ("K111_6","012_11_6","1KI","11","6","6","Nanbasol si Solomon tan adi nan inmongsan di pammati na en Diyos. Baken kaman din inyat David ay ama na. ");
INSERT INTO kne_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Nan-amag si pandaydayawan en Kemos ay kadodogis ay diyos di Moabita ya si Molek ay kadodogis ay diyos di Ammonita sin dontog ay naibandas belaan di agew ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Say inyat na met laeng sin odom ay mangili ay asawa na ta say waday pan-ipooan das insinso ya pan-idatonan da sin sinan didiyos da. ");
INSERT INTO kne_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Olay mo namin dowa ay nanpaila en Solomon si Yahweh ay Diyos di Israelita ya inbilina ay adi mandayaw si odom ay diyos, adi pinatin Solomon sisya mo adi et dinokogana. Isonga binmonget si Diyos ");
INSERT INTO kne_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","yan kanana, “Gapo ta siya na di inamag mo ya adi kan tinongpal din intolag ya inbilin ko, soktobak din turay mo et idawat ko si esa ay opisyal mo. ");
INSERT INTO kne_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Ngem gapo en David ay amam, adiak amagen sin kamatagom mo adi et sin timpon di anak mo. ");
INSERT INTO kne_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Olay mo siya di, adiak golpien ay kaanen en sisya din intiro ay ili. Idawtak si esay tribu ay iturayana begew en David ay baak ya begew abe ed Jerusalem ay pinilik ay panbeeyak.” ");
INSERT INTO kne_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Wada abey esa ay opisyal Solomon ay nangontra en sisya, si Jeroboam ay anak Nebat ay taga-Zereda ed Efraim. Si Zerua ay esa ay balo di ina na. ");
INSERT INTO kne_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Sin namingsan ay enggay nadipos si Jeroboam ed Jerusalem, wadas Ahias ay pankalkalian Diyos ay taga-Shilo ay nangabat en sisya sin kalsada. Ang-anggoy da ay dowa. ");
INSERT INTO kne_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Idi nan-abat da, kakaan din mamadto ay sana sin baro ay tak-ep di bado na asi na binisngit ay nansinpo ya dowa. ");
INSERT INTO kne_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Kanana en Jeroboam, “Alaem nan sinpo ay bisngit di badok tan kanan Yahweh ay Diyos di Israelita en sik-a, ‘Alaek din iturayan Solomon et idawat kon sik-a di sinpo ay tribu. ");
INSERT INTO kne_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","Mabay-an en Solomon di esa ay tribu begew en David ay baak ya begew ed Jerusalem ay siyodad ay pinilik sin intiro ay Israel. ");
INSERT INTO kne_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","Amagek na gapo ta dinokoganas sak-en et nandayaw en Astarte ay diyos di taga-Sidon ya si Kemos ay diyos di Moabita. Dinayaw na abe si Molek ay diyos di Ammonita et adi na inamag din kosto sin pangiilaak. Adi nantongpal sin linteg ya bilbilin ko ay baken kaman din inyat David ay ama na. ");
INSERT INTO kne_vpl VALUES ("K111_34","012_11_34","1KI","11","34","34","Ngem adiak kaanen amin en Solomon din iturayana, tan insaad kos sisya ay man-ari engganas tongpal biyag na begew en David ay baak ay pinilik ya nantongpal sin bilbilin ko. ");
INSERT INTO kne_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Alaek din iturayan di anak Solomon et idawat kon sik-a din sinpo ay tribu. ");
INSERT INTO kne_vpl VALUES ("K111_36","012_11_36","1KI","11","36","36","Idawat kon esa sin anak na ay sana ta mo si David ay baak et mantoltoloy ay waday poli na ay manturay ed Jerusalem ay pinilik ay siyodad ay panbeeyak ya pandayawan di ipogaw en sak-en.’” ");
INSERT INTO kne_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Pinanggep Solomon ay peslen si Jeroboam ngem tinmagtag ed Egipto. Nankamang en Sisak ay ari et nantees di enggana ay natey si Solomon. ");
INSERT INTO kne_vpl VALUES ("K111_41","012_11_41","1KI","11","41","41","Din inam-amag ya laing Solomon yan naisolat sin libro ay napaoloan si Kaistoryaan di Biyag Solomon. ");
INSERT INTO kne_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Opatapolo ay tawen ay nantee ed Jerusalem sin nangiturayana sin amin ay tribun di Israelita. ");
INSERT INTO kne_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Naiponpon sin naaladan ay partin di siyodad ay kanan da en Siyodad en David sin nateyana, et din anak na ay si Rehoboam di naisokat en sisya. ");
INSERT INTO kne_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Idi siya di, inmey si Rehoboam ed Sekem, tan say nasinopan amin ay papangolon di Israelita ta isaad das sisya ay man-ari. ");
INSERT INTO kne_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Wada pay laeng si Jeroboam ay anak Nebat ed Egipto ay kinamang na sin nangilayawana en Solomon. Idi dinnge na di, nantaoli ed Israel. ");
INSERT INTO kne_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Inpaayag din Israelita si Jeroboam et nankokoyog da am-in ay inmey en Rehoboam yan kanan da, ");
INSERT INTO kne_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“Palalo ay pinmalpaligat si amam. Madagsen abe di inpaob-obla na en dakami, ngem no palag-anem din obla mi ed wani, mansilbi kami en sik-a ay kosto.” ");
INSERT INTO kne_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Kanan Rehoboam ay nanongbat, “Somaa kayo ta asi kayon mantaoli mo malabas di tolo ay agew.” Et sinmaa da. ");
INSERT INTO kne_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Nakikali si Rehoboam sin papangolo ay nansilsilbi en Solomon idi matmatago pay laeng. Kanana ay nanpoot, “Sino di maibaga yo ay isongbat ko sin ipogaw?” ");
INSERT INTO kne_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","“Mo ed wani ay agew yan manpakombaba ka en da nay ay ipogaw ya patgam din kedkedawen da, mansilbi da en sik-a si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Ngem sinigaan Rehoboam din inbagan di nankakay ay papangolo et nakikali sin mansilsilbi en sisya ay katawenana. ");
INSERT INTO kne_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","“Sinoy maibaga yo ay isongbat ko sin kanan di ipogaw ay palag-anek din obla da?” kanana. ");
INSERT INTO kne_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Kanan din babbaro ay sana ay katawenana, “Siya na di isongbat mo: Dakdakdake di palpal-iking ko mo din gitang amak. ");
INSERT INTO kne_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Mo madagsen di inpabaklay na en dakayo, madagdagsen pay di ipabaklay ko. Mo sinoplit nas dakayo, latiko di iablat ko en dakayo.” ");
INSERT INTO kne_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Malabas pay di tolo ay agew, inmey da Jeroboam sin kad-an Rehoboam ay ari tan say inbaga na en daida. ");
INSERT INTO kne_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Bogtak di inyat Rehoboam ay nanongbat sin ipogaw. Sinigaana din inbagan di nankakay et say inonodana din inbagan di babbaro. ");
INSERT INTO kne_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Kanana, “Mo madagsen di inpabaklay amak en dakayo, mas madagdagsen pay di ipabaklay ko. Mo sinoplit nas dakayo, latiko di iablat ko en dakayo.” ");
INSERT INTO kne_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Adi inkaskason din ari din kedkedawen di ipogaw, tan si Diyos di nangiturong ta matongpal din inbaga na en Jeroboam ay anak Nebat ay inpaipadtona en Ahias ay taga-Shilo. ");
INSERT INTO kne_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Idi ilaen din amin ay Israelita ay adi patgan din ari din inbaga da, kanan da ay nanongbat sin ari, “Maipababa koma si David ya din pamilya na. Ay sino od di pansigdan ay indawat na en dakami? Somaa kami ay Israelita! Bay-an daka ay polin David ay makaammo sin mismo ay pamilyam.” Et sinmaa din Israelita. ");
INSERT INTO kne_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Magay nabay-an si iturayan Rehoboam mo adi anggoy din Israelita ay man-ili ed Juda. ");
INSERT INTO kne_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Inbaan Ari Rehoboam si Adoniram ay kapatas di obla ay inkapilitan ta makingalat sin Israelita, ngem pinigpig da enggana ay natey. Gapo isdi, kalogan si Rehoboam sin kalisa na et linmayaw ay emey ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Manipod sidi, kanayon ay kontraen din Israelita ay man-ili sin amyanan din panturayan di polin David. ");
INSERT INTO kne_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Idi ammoen din Israelita ay sana ay nantaoli si Jeroboam, inpaayag da sin nasinopan da et say insaad da ay ari da am-in ay tribun Israel. Din tribun Juda anggoy di kinmakaman ay namigbig sin turay di polin David. ");
INSERT INTO kne_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Inpaalad Jeroboam si batog din ili ay Sekem ed Efraim ay kadondontogan et nantees di. Asi nan tinaynan et ena aben inaladan ed Penuel. ");
INSERT INTO kne_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Ngem kanan Jeroboam si nemnem na, “Mo kanayon ay em-emey din ipogaw ko ed Jerusalem ay en man-idaton sin Timplo, sigurado ay manbaliw to di nemnem da et kasin dan manpaituray en Rehoboam ay ari ed Juda. Mo say maamag di, domteng to di timpo ay pomse da.” ");
INSERT INTO kne_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Siya di, idi nakdeng ay nankedaw si pamagbaga, nan-amag si dowa ay sinan baka ay balitok. Pag nan kanan sin ipogaw, “Palalo ay maligatan kayo ay mantikid ed Jerusalem. Naey da din diyos yo ay nangipango en dakayo ay Israelita ay komaan ed Egipto.” ");
INSERT INTO kne_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Inpeey na din esa ay sinan baka ed Betel yan din esa ed Dan. ");
INSERT INTO kne_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Et nanbasol din ipogaw, tan nandaydayaw da ed Betel ya ed Dan. ");
INSERT INTO kne_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Nan-amag abe si Jeroboam si pandayawan sin toktok di dodontog, ya nandotok si papadi ay olay baken Levita. ");
INSERT INTO kne_vpl VALUES ("K112_32","012_12_32","1KI","12","32","33","Dowana et todingan ay fiesta din pitsa 15 di maikawao ay bowan ay kaman din masilibraran ed Juda. Sin agew ay doy, nantikid sin inamag na ay altar ed Betel, ya sisya ay mismo et nan-ipoo si daton isdi para sin dowa ay sinan baka ay inamag na. Insaad na abe ed Betel din papadi ay nansilsilbi sin inamag na ay pandayawan sin toktok di dontog. ");
INSERT INTO kne_vpl VALUES ("K114_1","012_14_1","1KI","14","1","1","Sin doy ay timpo, nansakit si Abias ay anak Jeroboam. ");
INSERT INTO kne_vpl VALUES ("K114_2","012_14_2","1KI","14","2","2","Idi siya di, kanan Jeroboam sin asawa na, “Emey ka ed Shilo sin kad-an di pankalkalian Diyos ay nangipadto ay man-ariak ed Israel, ngem masapol ay ilibak mo di kaipogaw mo ta adi da ammoan ay sik-a si asawak. ");
INSERT INTO kne_vpl VALUES ("K114_3","012_14_3","1KI","14","3","3","Man-itakin ka si sinpo ay tinapay, odom ay makan, ya anig ta emey ka sin kad-ana, et ibaga na di mapasamak sin anak.” ");
INSERT INTO kne_vpl VALUES ("K114_4","012_14_4","1KI","14","4","4","Tinongpal asawan Jeroboam din inbaga na et dinagdagos na ay inmey sin beey Ahias ed Shilo. Sin doy ay timpo, nagodab si Ahias tan enggay nakay. ");
INSERT INTO kne_vpl VALUES ("K114_5","012_14_5","1KI","14","5","5","Ngem inbabagan Diyos en sisya ay wada ay emey din asawan Jeroboam ay mangilibak sin kaipogaw na ay mansalodsod maipanggep sin sakit di anak da. Inbagan aben Diyos di isongbat na. ");
INSERT INTO kne_vpl VALUES ("K114_6","012_14_6","1KI","14","6","6","Isonga idi dinngen Ahias din danegdeg di dapana sin segpan yan kanana, “Senggep ka. Ammok ay sik-a si asawan Jeroboam. Apay nga panggep mo ay sikapan sak-en ta say adiak ilasinan sik-a? Waday lawa ay ipadamag ko en sik-a. ");
INSERT INTO kne_vpl VALUES ("K114_7","012_14_7","1KI","14","7","7","En ka ibaga en Jeroboam ay siya na di inbagan Yahweh ay Diyos di Israelita, ‘Pinilik sik-a sin kaipoipogaw et insaad kos sik-a ay mangituray sin Israelita ay ipogaw ko. ");
INSERT INTO kne_vpl VALUES ("K114_8","012_14_8","1KI","14","8","8","Sinoktobak din turay di polin David et indawat kon sik-a ngem baken kan kaman si David ay baak. Tan si David yan tinongpal na din bilbilin ko ya inpapasnek na ay nangonod sin laydek et say inamag na anggoy din kosto sin pangilak. ");
INSERT INTO kne_vpl VALUES ("K114_9","012_14_9","1KI","14","9","9","Madagdagsen di basbasol mo mo din amin ay namangpango mo sik-a. Dinaydayaw mo di natenaw ay balitok ay naamag si sinan didiyos. Dadlon ka aben dinokogan ya linaslasoy sak-en, isonga binmongetak en sik-a. ");
INSERT INTO kne_vpl VALUES ("K114_10","012_14_10","1KI","14","10","10","Gapo isdi, ipalak-am ko sin pamilyam di lawa ay mapasamak. Peslek amin ay lalaki sin polim, nakay ono anak. Kaman din iyat di manpoos logit di iyat ko sin polim enggana ay maabos da. ");
INSERT INTO kne_vpl VALUES ("K114_11","012_14_11","1KI","14","11","11","Kanen di aso din polim ay matey sin siyodad yan kanen di titit din matey sin away.’ Siya na di inbagan Diyos.” ");
INSERT INTO kne_vpl VALUES ("K114_12","012_14_12","1KI","14","12","12","Intoloy Ahias ay nangibaga sin asawan Jeroboam, “Somaa ka ed wani. Sin kosto ay oras ay domatngam sin ili yo, matey din anak yo. ");
INSERT INTO kne_vpl VALUES ("K114_13","012_14_13","1KI","14","13","13","Iladingitan di amin ay Israelita asi dan iponpon. Sisya anggoy di mayat di iyat na ay maiponpon sin polin Jeroboam, tan anggoy na si napnekan Apo Diyos ay daydayawen di Israelita. ");
INSERT INTO kne_vpl VALUES ("K114_14","012_14_14","1KI","14","14","14","Wadan to di isaad Diyos ay man-ari isnan Israel et say mangabos sin pamilyan Jeroboam. Baken mabayag mo adi et mapasamak ay dagos.” ");
INSERT INTO kne_vpl VALUES ("K114_17","012_14_17","1KI","14","17","17","Idi nakdeng ay nankali din mamadto, sinmaa din asawan Jeroboam ed Tirza. Idi kosto ay senggep sin pantew, natey din anak da. ");
INSERT INTO kne_vpl VALUES ("K114_18","012_14_18","1KI","14","18","18","Pag dan iponpon et nanladladingit am-in ay Israelita ay kaman met laeng din inpaibagan en Ahias ay pankalkaliana. ");
INSERT INTO kne_vpl VALUES ("K114_19","012_14_19","1KI","14","19","19","Din odom ay naamag sin timpon Jeroboam ay kaman din nakigobatana ya din inyat na ay nanturay et naisolat da sin libro ay kaistoryaan di biyag di aari ed Israel. ");
INSERT INTO kne_vpl VALUES ("K114_20","012_14_20","1KI","14","20","20","Dowanpo ya esa ay tawen di nanturayan Jeroboam, pag matey et naiponpon. Naisokat ay nan-ari si Nadab ay anak na. ");
INSERT INTO kne_vpl VALUES ("K114_21","012_14_21","1KI","14","21","21","Mo pay ed Juda, opatapolo ya esa di tawen Rehoboam ay anak Solomon sin naisaadana ay ari. Nanturay si sinpo ya pito ay tawen ed Jerusalem ay din siyodad ay pinilin Diyos sin amin ay tribun di Israelita ay say panbeeyana. Si Naama ay Ammonita di ina na. ");
INSERT INTO kne_vpl VALUES ("K114_22","012_14_22","1KI","14","22","22","Lawa di inam-amag din man-ili ed Juda sin pangilan Diyos. Gapo sin basol da, nasursurok di inyat da ay nangipabonget en sisya mo din ap-apo da. ");
INSERT INTO kne_vpl VALUES ("K114_23","012_14_23","1KI","14","23","23","Sin amin ay toktok di dontog ya poon di kaiw ay mayat si panlidoman, nan-am-amag da abe si pandayawan da si sinan didiyos. Nantootood da abes bato ay pandaydayawan da ya posti ay pangidaydayaw da en Asera ay didiyosen da. ");
INSERT INTO kne_vpl VALUES ("K114_24","012_14_24","1KI","14","24","24","Asi et naisepsep ay waday mantee sin pandaydayawan da ay mangilaklako sin kinalalaki ya kinababai da. Inamag da amin ay kadodogis sin pangilan Diyos ay kaman din am-amagen di sigod ay man-ili ay inpakaan Diyos ta maisokat da ay Israelita. ");
INSERT INTO kne_vpl VALUES ("K114_25","012_14_25","1KI","14","25","25","Sin maikalima ay tawen ay nanturayan Rehoboam, ginobat Sisak ay arin di Egipto ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("K114_26","012_14_26","1KI","14","26","26","Ina na amin ay gameng sin Timplo ya sin palasyo pati da din kasay ay nam-es si balitok ay inpaamag Solomon. ");
INSERT INTO kne_vpl VALUES ("K114_29","012_14_29","1KI","14","29","30","Kanayon abe ay nan-gogobat da Rehoboam en da Jeroboam. Mo din odom ay napasamak sin nanturayan Rehoboam ya din am-in ay inamag na, naisolat da sin libro ay kaistoryaan di biyag di aari ed Juda. ");
INSERT INTO kne_vpl VALUES ("K114_31","012_14_31","1KI","14","31","31","Idi natey si Rehoboam, naitapi sin naiponponan di aap-o na sin Siyodad en David. Naisokat ay nan-ari si Abias ay anak na. ");
INSERT INTO kne_vpl VALUES ("K115_2a","012_15_2a","1KI","15","2a","2a","Tolo ay tawen di nanturayan Abias ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("K115_3","012_15_3","1KI","15","3","3","Inamag na amin din basol ay inam-amag ama na. Baken kaman si apo na ay David ay naimongsan di nemnem na en Yahweh ay Diyos na. ");
INSERT INTO kne_vpl VALUES ("K115_8","012_15_8","1KI","15","8","8","Idi natey si Abias, naiponpon sin naidolinan di aap-o na sin Siyodad en David. Si Asa ay anak na di naisokat ay nan-ari, ");
INSERT INTO kne_vpl VALUES ("K115_10","012_15_10","1KI","15","10","10","et nanturay ed Jerusalem si opatapolo ya esa ay tawen. Si Maaca ay anak Absalom di apo na ay babai. ");
INSERT INTO kne_vpl VALUES ("K115_11","012_15_11","1KI","15","11","11","Si Asa yan kaman si apo na ay David. Inamag na din kosto sin pangilan Diyos. ");
INSERT INTO kne_vpl VALUES ("K115_12","012_15_12","1KI","15","12","12","Inpakaana din lallalaki ya babbabai ay mangilaklakos awak da ay mantee sin pandaydayawan sin dodontog. Kinaana abe din sinan didiyos ay inam-amag di aap-o na. ");
INSERT INTO kne_vpl VALUES ("K115_14","012_15_14","1KI","15","14","14","Adi na kinaan din pandaydayawan ay wada sin dodontog, ngem naimomongsan di nemnem na ay mansilbi en Diyos sin intiro ay biyag na. ");
INSERT INTO kne_vpl VALUES ("K115_16","012_15_16","1KI","15","16","16","Sin timpon da Asa en Baasa ay ari ed Israel, kanayon ay nan-gogobat da. ");
INSERT INTO kne_vpl VALUES ("K115_24","012_15_24","1KI","15","24","24","Idi natey si Asa, naiponpon sin naipayagan di aap-o na sin Siyodad en David, et naisokat ay man-ari si Jehosafat ay anak na. ");
INSERT INTO kne_vpl VALUES ("K115_25","012_15_25","1KI","15","25","25","Mo ed Israel abe, naisaad ay ari si Nadab ay anak Jeroboam. Naamag na sin maikadwa ay tawen ay nanturayan Asa ed Juda, et inturayana ed Israel si dowa ay tawen. ");
INSERT INTO kne_vpl VALUES ("K115_26","012_15_26","1KI","15","26","26","Iniso na din ogalin ama na, tan lawa di inam-amag na sin pangilan Diyos ya inpango na din Israelita ay manbasol. ");
INSERT INTO kne_vpl VALUES ("K115_27","012_15_27","1KI","15","27","27","Asi et wadas Baasa ay anak Ahias ay polin Issakar ay nanplano ay mamse en Nadab. Et inpapati na ay namse sin nanlikoban Nadab ya din sosoldadon di Israelita ed Gebbeton ay ilin di Filisteo. ");
INSERT INTO kne_vpl VALUES ("K115_28","012_15_28","1KI","15","28","28","Pag maisokat, et sisya di nanturay ed Israel. Naamag na sin maikatlo ay tawen ay nanturayan Asa ed Juda. ");
INSERT INTO kne_vpl VALUES ("K115_29","012_15_29","1KI","15","29","29","Idi nanturay sisya, dagos ay pinse na din am-in ay pamilyan Jeroboam. Iwed di olay es-esa ay nabay-an, ay siya met laeng di inpaipadton Diyos en Ahias ay pankalkaliana ay taga-Shilo. ");
INSERT INTO kne_vpl VALUES ("K115_30","012_15_30","1KI","15","30","30","Naamag na begew sin basbasol Jeroboam ya din nangiturongana abe sin Israelita ay manbasol ay say binmongetan Yahweh ay Diyos da. ");
INSERT INTO kne_vpl VALUES ("K116_25","012_16_25","1KI","16","25","25","Ngem lawa di inam-amag Omri sin pangilan Diyos yan madagdagsen pay di basbasol na mo din amin ay nangon-ona ay nanturay mo sisya. ");
INSERT INTO kne_vpl VALUES ("K116_26","012_16_26","1KI","16","26","26","Inonodana amin din inamag Jeroboam ay anak Nebat ya inpangoloana din Israelita ay nanbasol, isonga binmonget si Yahweh ay Diyos da gapo sin magay silbi na ay sinan didiyos ay daydayawen da. ");
INSERT INTO kne_vpl VALUES ("K116_28","012_16_28","1KI","16","28","28","Idi natey si Omri yan naiponpon ed Samaria et si Ahab ay anak na di naisokat ay ari. ");
INSERT INTO kne_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","Din naisaadan Ahab ay anak Omri ay man-ari ed Israel yan naitompong sin maika-38 ay tawen ay nanturayan Asa ay ari ed Juda. Dowanpo ya dowa ay tawen di nanbeeyana ed Samaria ay mangituray sin Israelita. ");
INSERT INTO kne_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Nakarkaro di basol ay inam-amag Ahab ay anak Omri mo din nanturturay ay nangon-ona mo sisya. ");
INSERT INTO kne_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Baken napnek sin nangam-amagana si kaman din basol Jeroboam ay anak Nebat. Inasawa na abe si Jezebel ay anak Etbaal ay ari ed Sidon et nansilbi ya nandayaw en Baal. ");
INSERT INTO kne_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Nan-amag si altar ay para en Baal sin timplon Baal ay inamag na ed Samaria. ");
INSERT INTO kne_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Tinood na abe di posti ay pangidaydayaw da en Asera. Nasursurok pay din inamag Ahab ay nangipabonget en Diyos mo din amin ay nangon-ona mo sisya ay nan-ari ed Israel. ");
INSERT INTO kne_vpl VALUES ("K116_34","012_16_34","1KI","16","34","34","Sin timpon Ahab, binangon kasin Hiel ay taga-Betel din alad ya eneb ed Jerico. Et natongpal din inpaipadton Diyos en Josue ay anak Nun, tan idi nakdeng ay insaad na din fondasyona, natey si Abiram ay besag na, yan idi inamag na din eneb na, natey abe si Segub ay anongos na. ");
INSERT INTO kne_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Waday mamadto ay manngadan si Elias ay taga-Tisbe ay sakop di Gilead. Inmey en Ahab yan kanana, “Begew sin panakabalin Yahweh ay matmatago ay Diyos di Israelita ay pansilsilbiak, magay dono ono odan isnan omal-ali ay tawen enggana ay ibagak.” ");
INSERT INTO kne_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Idi makdeng di, kanan Diyos en Elias, ");
INSERT INTO kne_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","“Komaan kas na. Emey ka sin naibandas belaan di agew ta en ka mantabon sin asag-en di kitkittoy ay ginawang ay Kerit sin naibandas belaan di agew ed Jordan. ");
INSERT INTO kne_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Say pan-inomam din ginawang ay doy yan binilin ko din gayang ay man-iey da si kanem.” ");
INSERT INTO kne_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Tinongpal na din inbagan Diyos et inmey sin kad-an di ginawang ay Kerit et nantees di. ");
INSERT INTO kne_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Inagsapa ya minasdem ay man-idateng din gayang si karni ya tinapay yan sin ginawang di pan-in-inomana. ");
INSERT INTO kne_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Baken nabayag yan namgaan din ginawang tan adi nan-od-odan sin daga ay doy. ");
INSERT INTO kne_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Pag kanan Diyos en sisya, ");
INSERT INTO kne_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Emey ka ay dagos ed Zarefat ay sakop di Sidon ta mantee kas di. Binilin ko di esay balo isdi ta panganen daka.” ");
INSERT INTO kne_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Et inmey ed Zarefat. Idi dinmateng sin segpan di ili, waday balo ay mangakkaiw. Kanana sin babai ay sana, “Man-inomak kod si danom yo.” ");
INSERT INTO kne_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Idi em-emey din babai yan kanana, “Omya ka kod abe si esa ay tinapay.” ");
INSERT INTO kne_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Kanan din babai ay nanongbat, “Ammon Yahweh ay Diyos mo ay maga polos di tinapay ko. Wada anggoy di sinkagamet ay arina sin koli ya at-atik ay mantikan di olivo sin garapon. Mangakkaiwak ta waday pan-oto mi yan say longbos na dis kanen mi sin anak ko ay lalaki et sigurado ay matey kamis dagaang.” ");
INSERT INTO kne_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Ngem kanan Elias en sisya, “Adi kan madanagan. Somaa ka et ta en ka man-oto si kanen yo. Ngem pangon-onaem ay omioto si kitkittoy ay tinapay sin arina yo ta ialim, asi kan man-oto sin mabay-an si kanen yo sin anak mo. ");
INSERT INTO kne_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Tan siya na di kanan Yahweh ay Diyos di Israelita, ‘Kadi et baken maabos din arina sin koli ya din mantika sin garapon enggana ay sak-en ay Diyos et ipawadak di odan.’” ");
INSERT INTO kne_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Sinmaa et tinongpal na din inbagan Elias. Et waday inmanay ay kinkinan da Elias ya din sin-ina si inag-agew, ");
INSERT INTO kne_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","tan tinmet-ewa din kalin Diyos ay inbagan Elias et adin naab-abos din arina sin kaipaypay-ana ya din mantika sin garapon. ");
INSERT INTO kne_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Idi baken nabayag, nansakit din anak di balo ay sana yan kinmaro ay kinmaro enggana ay natey. ");
INSERT INTO kne_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Kanan din babai en Elias, “Sik-a ay ipogaw Diyos, sino pay di gapo ay say inamag mo nan sak-en? Ay inmali ka ay mangipanemnem en Diyos sin basbasol ko ta say matey din anak ko?” ");
INSERT INTO kne_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Kanan Elias ay nanongbat, “Ialim san anak mo.” Et ina na sin balo din anak, pag nan iey sin kowarto ed ngato ay panteteana et inpabaktad na sin katri na. ");
INSERT INTO kne_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Kanana ay nanpakaasi en Diyos, “Yahweh ay Diyos ko, ay olay nan balo ay pakidagdagosak yan paligatem tan nay adi kan naseg-ang sin anak na?” ");
INSERT INTO kne_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Pag lomakbab si Elias si namitlo sin awak di anak dowan mankararag en Diyos ay kanana, “Yahweh ay Diyos ay daydayawek, pangaasim kod ta tagoem nan anak ay nay.” ");
INSERT INTO kne_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Pinatgan Diyos din kararag Elias et natago kasin din anak. ");
INSERT INTO kne_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Binakwan Elias et inbaba na ay en indawat en ina na yan kanana, “Ilaem, natago din anak mo.” ");
INSERT INTO kne_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Kanan din babai ay nanongbat en Elias, “Napaneknekak ed wani ay ipogaw Diyos sik-a et din kalin Diyos ay ibagam yan tet-ewa.” ");
INSERT INTO kne_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","Nalabas pay di kaageagew et dinomteng sin maikatlo ay tawen, kanan Diyos en Elias, “En ka manpaila en Ahab et pawadaek di odan.” ");
INSERT INTO kne_vpl VALUES ("K118_2a","012_18_2a","1KI","18","2a","2a","Et inmey si Elias ay nanpaila en Ahab. ");
INSERT INTO kne_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Idi inila na si Elias yan kanana, “Wada ka baw, sik-a ay namalpaligat sin Israelita.” ");
INSERT INTO kne_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Ngem kanan Elias, “Baken sak-en di namalpaligat sin Israelita. Sik-a et adi ya din pamilyan amam, tan linablabsing yo din bilbilin Diyos yan nandaydayaw kayo en Baal. ");
INSERT INTO kne_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Ed wani, ibilin mo sin amin ay ipogaw isnan intiro ay Israel ta en da omabat sin dontog ay Carmel. Itakin mo abe din 450 ay mamadton Baal ya din 400 ay mamadton Asera ay pakpakanen Jezebel.” ");
INSERT INTO kne_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Et pinakaammoan Ahab din ipogaw sin intiro ay Israel et natopog da sin dontog ay Carmel, pati da din mamadto ay sana. ");
INSERT INTO kne_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Sinmag-en si Elias sin amin ay ipogaw yan kanana, “Pig-an pay ay isaldeng yo ay pankakadwaen din pammati yo? Mo si Yahweh di Diyos, say dayawen yo. Mo si Baal di Diyos et say dayawen yo.” Ngem ginmiginek din kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Pag kanan Elias, “Es-esaak anggoy ay nabay-an sin mamadton Diyos, ngem waday 450 ay mamadton Baal. ");
INSERT INTO kne_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Man-a kayos dowa ay bomaro ay baka. Alaen da din esa ta partien da ya tadtaden da, asi dan ipatang sin kaiw ay pangipooan ngem adi dan tetengan. Isaganak abe din esa et ipatang ko sin kaiw ay pan-ipooan ngem adiak aben tetengan. ");
INSERT INTO kne_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Mo makdeng di, mankararag kayo sin diyos yo yan mankararagak abe en Yahweh. Din manongbat si kararag ay mangipawadas apoy yan sisya di tet-ewa ay Diyos.” Et inbogaw din amin ay ipogaw ay apolbalan da din inbaga na. ");
INSERT INTO kne_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Siya di, kanan Elias sin mamadton Baal, “Manpili kayo si esa sin baka ta mangon-ona kayo ay mangisagana tan ad-ado kayo. Mankararag kayo sin diyos yo, ngem adi yon tetengan.” ");
INSERT INTO kne_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Et ina da din baka yan insagana da. Nankararag da en Baal manipod sin agsapa enggana sin alas dosi. “Ay Baal, songbatam kod nan kararag mi,” kanan da ay nangibogbogaw dowan dan manaytayaw ay manliked sin altar ay inamag da, ngem magay nanongbat sin kararag da. ");
INSERT INTO kne_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Idi man-gawa pay di agew, inlogin Elias ay siniten daida ay kanana, “Ibogaw yo pay. Diyos met si Baal. Amangan mo way naoneg ay nemnemnemena ono ad-adoy am-amagena, mo adi ya way inmeyana. Tan mo et naseseyep ya masapol ay bangonen.” ");
INSERT INTO kne_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Inpigpigsa da din bogaw da dowan da et egden din awak da si kampilan ya gayang enggana ay mantedted din dada da tan say ogali da. ");
INSERT INTO kne_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Intoltoloy da ay nanbogbogaw ya nankalkali ay kaman dan naboge enggana ay dandani ay alas tres ay timpon di pan-idatonan, ngem dowan et magay nannge ya nanongbat sin kararag da. ");
INSERT INTO kne_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Makdeng pay di, kanan Elias sin kaipoipogaw, “Omasag-en kayos na.” Et sinmag-en da en sisya. Nilogiana ay nangamag sin nadadael ay altar ay nandayawan da en Diyos ed idi. ");
INSERT INTO kne_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Nan-a si sinpo ya dowa ay bato, sag-eesa para sin tribun di polin Jacob ay nginadanan Diyos si Israel. ");
INSERT INTO kne_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Say inosal na da san bato ay nan-amag si altar ay pan-idatonan si animal en Diyos. Nankaot si kanal ay nanliked sin altar. Din kalosong din kanal yan laonena di nganngani ay opat ay galon ay danom. ");
INSERT INTO kne_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Piney-ana si kaiw din altar asi nan tinadtad din baka et inpatang na sin kaiw. Pag nan kanan en daida, “Pon-en yo di opat ay koli si danom ta isodag yo sin naidaton ya sin kaiw.” Et tinongpal da. ");
INSERT INTO kne_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","“Say iyat yo kasin,” kanana et pinidwa da. Binilina kasin daida et say inyat da si maikapitlo. ");
INSERT INTO kne_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Nan-ayos din danom sin altar et napno din kanal. ");
INSERT INTO kne_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Idi domteng din oras ay pan-idatonan, sinmag-en si Elias ay din mamadton Diyos sin altar yan kanana ay nankararag, “Sik-a ay Yahweh, Diyos ay dinaydayaw da Abraham, Isaac ya Israel, ipailam koma ed wani ay agew ay sik-a din Diyos ed Israel ya sak-en din baam, et inamag ko amin dana tan say inbilin mo. ");
INSERT INTO kne_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Songbatam koma ay Diyos nan kararag ko ta say mapaneknekan nan kaipoipogaw ay sik-a ay Yahweh si Diyos ay mangitaoli sin pammati da en sik-a.” ");
INSERT INTO kne_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Pag et kaekgas si Diyos si apoy et pinooana amin din naidaton, kaiw ya bato. Nakset din lota yan namgaan din kanal ay nanliked sin altar. ");
INSERT INTO kne_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Idi inilan din kaipoipogaw di, kalakpap da yan kanan da, “Si Yahweh di Diyos, si Yahweh anggoy di Diyos.” ");
INSERT INTO kne_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Idi siya di, binilin Elias daida, “Depapen yo din mamadton Baal. Adi yon ipalobos ay waday makalayaw.” Dinpap das daida et inpaiballalong Elias sin ginawang ay Kison yan isdi ay pinse nas daida. ");
INSERT INTO kne_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Idi makdeng di, kanan Elias en Ahab, “En ka mangan ya man-inom tan sanay madngek ay omal-ali ay napigsa ay odan.” ");
INSERT INTO kne_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Et en nangan ya nan-inom si Ahab, ngem si Elias yan nantikid sin toktok di dontog ay Carmel, pag manyakog-ong ay nangidomog sin ropa na sin nan-gawaan di peweg na ay mankararag. ");
INSERT INTO kne_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Pag nan kanan sin baa na, “En ka tamangen din baybay.” Inmey din bag-ena ay nantamang asi nantaoli yan kanana, “Maga polos met di mailak.” Namin pito ay inbaan Elias din baa na. ");
INSERT INTO kne_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Sin maikapito ay nantaoliana yan kanana, “Waday liboo ay kaman kadakdaken di adpan di ipogaw ay komaykayang sin baybay.” Binilin Elias din bag-ena, “En ka ibaga en Ahab ta manlogan sin kalisa na ta somaa tan into et mo edasan di odan ya adi makalsot din kalisa na.” ");
INSERT INTO kne_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Sinkaattikan yan binmolinget ed kayang si liboo, nandagem ya nilogiana ay mandeges. Nanlogan si Ahab sin kalisa na ta somaa ed Jezreel. ");
INSERT INTO kne_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Siya et di, nawada en Elias di panakabalin Diyos et binilkoana din bado na asi nanagtag enggana sin beddeng di Jezreel yan inonaana si Ahab. ");
INSERT INTO kne_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Dinad-at Ari Ahab en Jezebel ay asawa na amin din inamag Elias ya din namseana sin amin ay mamadton Baal. ");
INSERT INTO kne_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Idi dinngen Jezebel di, waday inbaa na en Elias ay nangibaga, “Mo adiak amagen en sik-a din inamag mo sin mamadton Baal sin kaman nina ay oras si bigat, olay pomse da din diyos.” ");
INSERT INTO kne_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Inmegyat si Elias et linmayaw ta say adi da peslen. Intakina din baa na et inmey da ed Beerseba ay sakop di Juda yan tinaynanas di. ");
INSERT INTO kne_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","Naninsin-agew si Elias ay nandad-an ay inmey sin kadardaratan. Waday dintengana ay kaiw et tinmokdo sin sidom na yan inkararag na ay matey koma. Kanana, “Sik-a ay Diyos, enggay adiak maanosan na, isonga taoliem kod nan biyag ko tan maga met laeng di naitkenak sin aap-ok.” ");
INSERT INTO kne_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Idi makdeng di yan binmaktad et naseyep sin sinidoman di kaiw. Idi siya di, wada et di anghel ay nangiwit en sisya yan kanana, “Bomangon ka ta mangan ka.” ");
INSERT INTO kne_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Manmokilang pay, wada di inila na ay tinapay sin kad-an di toktok na ay naoto sin man-atong ay bato ya esay koli ay danom, et nangan ya nan-inom pag bomaktad kasin. ");
INSERT INTO kne_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Nantaoli kasin din anghel Diyos et giniwit na yan kanana, “Bomangon ka ta mangan ka tan addawi di pandad-anam.” ");
INSERT INTO kne_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Binmangon si Elias et nangan ya nan-inom. Pinmigsa sin kinana ay sana et nandan si opatapolo ay agew ya labi enggana ay dinmateng ed Sinai ay nanpappailaan Diyos. ");
INSERT INTO kne_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Sinenggep si esa ay liyang et isdi ay naseyep sin labi. Kanan Diyos en sisya, “Sinoy am-amagem isna ay Elias?” ");
INSERT INTO kne_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Kanan Elias, “Inpakat ko din amin ay kabaelak ay nansilsilbi en sik-a ay Yahweh, Diyos ay Manakabalin Amin, ngem din Israelita yan dinokogan da din intolag mo. Dinadael da din aaltar mo yan pinse da amin din pankalkaliam, et sak-en anggoy di nabay-an yan nay layden da abe ay pomse.” ");
INSERT INTO kne_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Kanan Diyos en sisya, “Bomala ka ta pomika ka sin sangoanak sin toktok di dontog tan sak-en ay Diyos et nganngani ay malabasak.” Idi siya di, wada et di napigsa ay dagem ay nangosokos sin dontog et napitapitak dan bato, ngem maga si Diyos ay naikoyog sin dagem. Idi sinmaldeng din dagem, nanyegyeg, ngem magas Diyos sin yegyeg. ");
INSERT INTO kne_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Makdeng din yegyeg yan way apoy, ngem magas Diyos sin apoy. Idi makdeng din apoy, waday nainayad ay ayasak. ");
INSERT INTO kne_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Idi dengngen Elias din ayasak, in-opop na din tak-ep di bado na sin ropa na, pag bomala et pinmika sin segpan di liyang. Pag et waday kali ay kanana, “Sinoy am-amagem isna ay Elias?” ");
INSERT INTO kne_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Kanan Elias, “Yahweh, Diyos ay Manakabalin Am-in, inpakat ko di amin ay kabaelak ay nansilsilbi en sik-a, ngem din Israelita yan nilinglingan da din intolag mo. Dinadael da din aaltar mo yan pinse da amin sin kampilan din pankalkaliam et sak-en anggoy di nabay-an yan nay layden da abe ay pomse.” ");
INSERT INTO kne_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Kanan Diyos en sisya, “Mantaoli ka sin dinan mo ta emey ka sin kadardaratan ed Damascus. Mo domateng kas di, emey ka sin siyodad ta dotokam si Hazael ay man-ari ed Syria ");
INSERT INTO kne_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","yan dotokam abes Jehu ay anak Nimsi ay man-ari ed Israel. Dotokam si Eliseo ay anak Safat ay taga-Abel Mehola ay say maisokat en sik-a ay mamadto. ");
INSERT INTO kne_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Din makalisi sin kampilan Hazael, peslen ton Jehu yan din makalisi en Jehu et peslen Eliseo. ");
INSERT INTO kne_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Ngem bay-ak di pito ay libo ay Israelita. Daida din adi nandayaw en Baal ya adi nang-ongo sin rebolto na.” ");
INSERT INTO kne_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Inmey si Elias et dintengana si Eliseo ay man-al-alado. Waday sinpo ya dowa ay paris ay napakoan ay baka ay on-onodena yan sisya di mangial-alado sin maodi ay paris. Kinaan Elias din tak-ep di bado na yan in-amag na en Eliseo. ");
INSERT INTO kne_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Kataynan si Eliseo sin baka na et inonod nas Elias yan kanana, “Palobosam kod sak-en ay en manpakada omona en da amak en inak ta asiak makikoyog en sik-a.” Kanan Elias ay nanongbat, “Emey ka adi. Adiak pilpiliten sik-a.” ");
INSERT INTO kne_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Siya di, tinaynan Eliseo et sinmaa. Ina na din ial-alado na ay baka et pinalti na. Say intongo na din alado ya pako ay nangiotoana sin karni pag nan idawat sin ipogaw et kinan da. Idi makdeng di, inmonod en Elias et nansilbi en sisya ay kabadang na. ");
INSERT INTO kne_vpl VALUES ("K120_42","012_20_42","1KI","20","42","42","Kanan din mamadto sin ari, “Siya na di ipaammon Diyos en sik-a. Gapo ta inpawayam din kineddengak ay matey koma, ikaroam sin biyag mo. Matey abe din sosoldadom gapo ta inpalobos mo ay matago din sosoldado na.” ");
INSERT INTO kne_vpl VALUES ("K120_43","012_20_43","1KI","20","43","43","Sin nanngeanas di, sinmaa din ari ed Samaria ay mansasadot ya mabmabonget. ");
INSERT INTO kne_vpl VALUES ("K121_1","012_21_1","1KI","21","1","1","Malabas pay di timpo, waday napasamak manbegew sin kaob-obasan Nabot ay taga-Jezreel. Din daga na ay nay et asag-en sin palasyon Ahab ed Jezreel ay ari ed Samaria. ");
INSERT INTO kne_vpl VALUES ("K121_2","012_21_2","1KI","21","2","2","Sin namingsan, kanan Ahab en Nabot, “Idawat mon sak-en din minolaam si obas ta eskak si natnateng tan asag-en sin palasyok. Sokatak si mas maymayat ay kaobasan ono lakoak mo say laydem. Bayadak olay piga di kanam.” ");
INSERT INTO kne_vpl VALUES ("K121_3","012_21_3","1KI","21","3","3","Ngem kanan Nabot, “Pangaasim apo. Iparit Diyos ay idawat kon sik-a din daga ay nay, tan tinawid ko sin ap-apok.” ");
INSERT INTO kne_vpl VALUES ("K121_4","012_21_4","1KI","21","4","4","Mansasadot ya mabmabonget si Ahab ay sinmaa gapo sin inbagan Nabot. Binmaktad sin katri na ay nanasango sin dingding yan sigaana ay mangan. ");
INSERT INTO kne_vpl VALUES ("K121_5","012_21_5","1KI","21","5","5","Idi sinenggep si Jezebel ay asawa na, kanana, “Ay sinoy gapo ay masmasadot ka ya sigaam ay mangan?” ");
INSERT INTO kne_vpl VALUES ("K121_6","012_21_6","1KI","21","6","6","Kanan Ahab, “Gapo sin inbagan Nabot. Tan kanak en lakoak din ineskanas obas ono sokatak mo say laydena ngem kanana et en adi mabalin ay idawat nan sak-en.” ");
INSERT INTO kne_vpl VALUES ("K121_7","012_21_7","1KI","21","7","7","Kanan asawa na, “Ay baken ayan sik-a di ari isnan Israel? Bomangon ka et ta mangan ka ya manragsak ka. Alaek din inobasan Nabot para en sik-a.” ");
INSERT INTO kne_vpl VALUES ("K121_8","012_21_8","1KI","21","8","8","Et nan-amag si solat asi nan inpirma din ngadan ya pirman Ahab, pag nan ipatolod sin oopisyal ya mabigbig ay omili ed Jezreel. ");
INSERT INTO kne_vpl VALUES ("K121_9","012_21_9","1KI","21","9","9","Siya na din nilaon din solat: “Man-ibilin kayo si agew ay pangitpean si dagaang ta sinopen yo din kaipoipogaw yan patokdoen yo si Nabot sin sango. ");
INSERT INTO kne_vpl VALUES ("K121_10","012_21_10","1KI","21","10","10","Man-ipatokdo kayo si doway bayanggodaw sin sangoanana ay mangipabasol en sisya ay binaosanas Diyos ya din ari. Pag kayon ibala sin lasin di siyodad ta pigpigen yo ay peslen.” ");
INSERT INTO kne_vpl VALUES ("K121_11","012_21_11","1KI","21","11","11","Inamag din oopisyal ya mabigbig ay omili din inbilin Jezebel sin solat ay inpatolod na en daida. ");
INSERT INTO kne_vpl VALUES ("K121_14","012_21_14","1KI","21","14","14","Makdeng pay di yan inpakaammo dan Jezebel en natey si Nabot. ");
INSERT INTO kne_vpl VALUES ("K121_15","012_21_15","1KI","21","15","15","Idi nadamag Jezebel ay natey si Nabot, kanana en Ahab, “Emey ka ta en ka okaen din inobasan Nabot ay taga-Jezreel ay sinigaana ay ilakon sik-a, tan enggay natey sisya.” ");
INSERT INTO kne_vpl VALUES ("K121_16","012_21_16","1KI","21","16","16","Idi dinngen Ahab ay natey si Nabot, kapika et inmey ay en nangoka. ");
INSERT INTO kne_vpl VALUES ("K121_17","012_21_17","1KI","21","17","17","Pag kanan Diyos en Elias ay taga-Tisbe, ");
INSERT INTO kne_vpl VALUES ("K121_18","012_21_18","1KI","21","18","18","“Manballalong ka ay dagos ta en ka ilan si Ari Ahab. Wadad wani sin inobasan Nabot tan laydena ay okaen. ");
INSERT INTO kne_vpl VALUES ("K121_19","012_21_19","1KI","21","19","19","Ibagam en sisya ay siya na di inbagan Diyos, ‘Makdeng baw ay peslem sisya yan alaem din sanikwa na? Sin mismo ay lugar ay nanildilan di aso sin dadan Nabot, isdi met laeng di panildilan di aso sin dadam.’” ");
INSERT INTO kne_vpl VALUES ("K121_20","012_21_20","1KI","21","20","20","Pinatin Elias din intogon Diyos. Idi inilan Ahab sisya, kanana, “Dinteng mo baw sak-en, sik-a ay omiibaw.” “Aw yan,” kanan Elias ay nanongbat. “Et gapo ta inpakat mon kabaelam ay mangamag si lawa sin pangilan Diyos, ");
INSERT INTO kne_vpl VALUES ("K121_21","012_21_21","1KI","21","21","21","siya na di kanana en lak-amem ay dosa. Keddengan daka ay matey ya siya abe sin am-in ay pamilyam ay lalaki. Maga polos di mabay-an. ");
INSERT INTO kne_vpl VALUES ("K121_22","012_21_22","1KI","21","22","22","Di katet-ewa na et dosaen daka ay kaman din inyat na sin polin Jeroboam ay anak Nebat ya polin Baasa ay anak Ahias, tan binmonget si Diyos begew sin nangipangoloam sin Israelita ay manbasol. ");
INSERT INTO kne_vpl VALUES ("K121_23","012_21_23","1KI","21","23","23","Mo maipanggep en Jezebel, kanan Diyos en kanen di asos sisya sin poon di alad ay batog di ili ay Jezreel. ");
INSERT INTO kne_vpl VALUES ("K121_24","012_21_24","1KI","21","24","24","Olay sino abe ay naipoli en sik-a yan matey sin siyodad et kanen di aso. Mo pay din matey sin away et kanen di titit.” ");
INSERT INTO kne_vpl VALUES ("K121_27","012_21_27","1KI","21","27","27","Sin nanngean Ahab isdi, binisngit nan bado na, et en nanbado si sako ay say inosal na olay sin labi. Init-itpe nay dagaang na yan kanayon ay masmasadot ya nadadagsenan. ");
INSERT INTO kne_vpl VALUES ("K121_28","012_21_28","1KI","21","28","28","Pag kanan Diyos en Elias, ");
INSERT INTO kne_vpl VALUES ("K121_29","012_21_29","1KI","21","29","29","“Ay inilam di inyat Ahab ay nangipababa si nemnem na sin sangoanak? Gapo ta say inyat na di, adiak ipalak-am din dosa ay nay sin pamilya na sin timpo na mo adi et sin timpon di anak na.” ");
INSERT INTO kne_vpl VALUES ("K122_29","012_22_29","1KI","22","29","29","Siya di, inmey da Ari Ahab en Ari Jehosafat ay en makigobat ed Ramot. ");
INSERT INTO kne_vpl VALUES ("K122_30","012_22_30","1KI","22","30","30","Kanan Ahab en Jehosafat, “Mo ilogi tako ay makigobat, ibadom din osal di ari, ngem mo sak-en pay, ilimed ko mo sinoak.” Et naitapi din arin di Israelita sin gobatan ay adi maimatonan. ");
INSERT INTO kne_vpl VALUES ("K122_34","012_22_34","1KI","22","34","34","Ngem naitompong ay waday soldadon di Syria ay nangibinat sin pana na yan napontaan si Ari Ahab sin nansisilpoan di salida na. “Aney! Napontaanak!” kanan Ahab sin mangiturturong sin kalisa na. “Manbowilta ka ta omaddawi ta!” ");
INSERT INTO kne_vpl VALUES ("K122_35","012_22_35","1KI","22","35","35","Pomigsa ay pomigsa din gobat dowan pay si Ahab yan inpapika da sin kalisa na ay makisasango sin sosoldadon di Syria. Intoltoloy din dada na ay omay-ayos enggana ay nabasa din det-an di kalisa. Idi malablabi, natey. ");
INSERT INTO kne_vpl VALUES ("K122_36","012_22_36","1KI","22","36","36","Idi dandani ay madipos din agew, nan-asibogaw da ay nangwani, “Somaa di esa ya esa sin kosto ay ili na.” ");
INSERT INTO kne_vpl VALUES ("K122_37","012_22_37","1KI","22","37","37","Siya na di nateyan Ahab ay ari ed Israel. Pag dan iey din awak na ed Samaria et inponpon da. ");
INSERT INTO kne_vpl VALUES ("K122_38","012_22_38","1KI","22","38","38","Waday posong isdi ay pan-amsan di babbabai ay nangilaklako sin awak da. Say nangowasan da sin kalisan Ahab ay para gobat et dinildilan di aso din dada na ay say inbagan Diyos ay maamag. ");
INSERT INTO kne_vpl VALUES ("K122_40","012_22_40","1KI","22","40","40","Idi nakdeng di, naisokat ay ari si Ahazias ay anak na. ");
INSERT INTO kne_vpl VALUES ("K122_41","012_22_41","1KI","22","41","41","Sin maikap-at ay tawen ay nanturayan Ahab ed Israel, naisaad ay ari ed Juda si Jehosafat ay anak Asa. ");
INSERT INTO kne_vpl VALUES ("K122_42","012_22_42","1KI","22","42","42","Mantawen si Jehosafat si 35 sin nanbalinana ay ari yan nanturay ed Jerusalem si 25 ay tawen. Si Azuba ay anak Silai di ina na. ");
INSERT INTO kne_vpl VALUES ("K122_43","012_22_43","1KI","22","43","43","Inamag na din kosto sin pangilan Diyos ay kaman si Asa ay ama na, ngem adi nan dinadael din pandaydayawan di ipogaw si sinan didiyos ay wada sin dodontog, et intoltoloy da ay nan-ipoo si daton ya insinso isdi. ");
INSERT INTO kne_vpl VALUES ("K122_44","012_22_44","1KI","22","44","44","Sin nanturturayan Jehosafat, nakikapya sin ari ed Israel. ");
INSERT INTO kne_vpl VALUES ("K122_50","012_22_50","1KI","22","50","50","Natey si Jehosafat et naiponpon ay naitapi sin aap-o na sin siyodad apo na ay David. Si Jehoram ay anak na di naisokat en sisya ay nan-ari. ");
INSERT INTO kne_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","Idi dandani ay alaen Diyos ed langit si Elias babaen si alinposapos, manmandan da en Eliseo ay napod Gilgal. ");
INSERT INTO kne_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","Kanan Elias en Eliseo, “Isna ka tan inbaan Diyos sak-en ed Betel.” Ngem kanan Eliseo, “Isapatak sin matmatago ay Diyos ya en sik-a ay adiak taynan sik-a.” Et nankoyog da ay inmey ed Betel. ");
INSERT INTO kne_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","Wada di grupon di mamadto ay mantee isdi ay inmey en Eliseo yan kanan da, “Ay ammom ay alaen Diyos din apom ay isian en sik-a ed wani ay agew?” Kanan Eliseo, “Aw, ammok ngem adi takon ap-apaten sa.” ");
INSERT INTO kne_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","Kanan kasin Elias en Eliseo, “Mataynan kas na tan inbilin Diyos ay emeyak ed Jerico.” Ngem kanan Eliseo, “Isapatak sin matmatago ay Diyos ya en sik-a ay adiak taynan sik-a.” Et nankoyog da ay inmey ed Jerico. ");
INSERT INTO kne_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","Wadas di di mantee ay grupon di mamadto ay nansalodsod en Eliseo, “Ay ammom ay alaen Diyos din apom et isianan sik-a ed wani ay agew?” Kanan Eliseo, “Aw, ammok ngem adi takon ap-apaten sa.” ");
INSERT INTO kne_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","Pag kanan Elias en Eliseo, “Mataynan kas na tan inbilin Diyos ay emeyak ed ginawang ay Jordan.” Ngem kanan Eliseo, “Isapatak sin matmatago ay Diyos ya en sik-a ay adiak taynan sik-a.” ");
INSERT INTO kne_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Intoloy da ay nandan yan waday grupon di mamadton Diyos ay inmonod en daida ed Jordan. Sinmaldeng da Elias en Eliseo sin benget di ginawang yan wada da din mamadto sin baken onay addawi ay mangiila en daida. ");
INSERT INTO kne_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Kinaan Elias din tak-ep di bado na asi na kinopin, pag nan iseppat sin danom yan nansian din danom et namgaan di dinan da Elias ay nanbalasat. ");
INSERT INTO kne_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Idi nakabalasat da, kanan Elias en Eliseo, “Sinoy laydem ay idawat ko asiak maiaddawi en sik-a?” Kanan Eliseo, “Idawtam kod sak-en si dobli ay bingay sin panakabalin mo.” ");
INSERT INTO kne_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Kanan Elias, “Naligat san kedkedawem ngem matongpal sa mo mailam sak-en sin kaisianak en sik-a, ngem no maga et adi maidawat en sik-a.” ");
INSERT INTO kne_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Idi manmandan da dowan dan mankalkali, bigla et ay nawada di manbidbidang ay kalisa ya kabayo ay nandan sin nan-gawaan da, pag ikayang di alinposapos si Elias ed daya. ");
INSERT INTO kne_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Inilan Eliseo et binogawanas Elias ay kanana, “Ama, ama! Napigsa ay manalaknib isnan Israel!” Manipod sidi yan adi na kasin inil-ilas Elias. Kabisngit si Eliseo sin bado na gapo si sakit di nemnem na. ");
INSERT INTO kne_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Pinidit na din nag-as ay tak-ep di badon Elias pag mantaoli sin benget di ginawang ay Jordan. ");
INSERT INTO kne_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Inseppat na sin danom din nag-as ay badon Elias yan kanana, “Intoy kad-an pay Yahweh ay Diyos en Elias?” Idi sineppat na din danom, nansian et nandan ay nanbalasat. ");
INSERT INTO kne_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Kanan din grupon di mamadto ay napod Jerico ay nangiilan sisya, “Wada en sisya din panakabalin Elias.” En da inabat, pag dan manyakog-ong sin sangoanana. ");
INSERT INTO kne_vpl VALUES ("K24_1","013_4_1","2KI","4","1","1","Sin namingsan, inmey en Eliseo din asawan di esa ay pankalkalian Diyos ay esa sin grupon di mamadto yan kanana, “Apo, natey si asawak. Ammom met ay pinatpateg na si Diyos, ngem ed wani yan inmali din nangiotang. Magay ibayad ko, isonga kanana en alaena din doway lalaki ay anak ko ta panbalinenas bag-ena.” ");
INSERT INTO kne_vpl VALUES ("K24_2","013_4_2","2KI","4","2","2","Kanan Eliseo ay nansalodsod, “Sinoy maibadang ko en sik-a? Ibagam kod di wada ay sanikwam sin beey mo.” Kanan din babai, “Apo, maga polos malaksig si at-atik ay lanan di olivo.” ");
INSERT INTO kne_vpl VALUES ("K24_3","013_4_3","2KI","4","3","3","Kanan Eliseo, “En ka manbolod sin am-in ay tinokmang mo si ad-ado ay koli ay magay naigto. ");
INSERT INTO kne_vpl VALUES ("K24_4","013_4_4","2KI","4","4","4","Mo idateng mo sin beey yo, senggep kayo sin aan-ak mo ta in-eb yo, pag kayon ilogi ay pey-an si lana din amin ay koli et din mapno yan ikasin yo.” ");
INSERT INTO kne_vpl VALUES ("K24_5","013_4_5","2KI","4","5","5","Tinaynan din babai si Eliseo yan sinenggep sisya ya din aan-ak na sin beey da et inin-eb da. Idawdawat din aan-ak na din koli dowanan peypey-an. ");
INSERT INTO kne_vpl VALUES ("K24_6","013_4_6","2KI","4","6","6","Idi napno da amin din koli, kanana sin esa ay anak na, “Man-iali kayo si esa.” Ngem kanan da, “Enggay nisa.” Idi siya di, sinmaldeng din lana ay man-ayos. ");
INSERT INTO kne_vpl VALUES ("K24_7","013_4_7","2KI","4","7","7","Binmela din babai ay en nangipaammo en Eliseo yan kanan Eliseo en sisya, “En ka ilako din lana ta say ibayad mo sin otang mo. Omanay din mabay-an ay panbiyag yo sin an-ak mo.” ");
INSERT INTO kne_vpl VALUES ("K24_8","013_4_8","2KI","4","8","8","Sin namingsan ay inmeyan Eliseo ed Sunem, inayagan di esay baknang ay babai ta makikan sin beey da. Manipod isdi, kanayon ay maspad ay makikan mo emey isdi ay ili. ");
INSERT INTO kne_vpl VALUES ("K24_9","013_4_9","2KI","4","9","9","Kanan din babai sin asawa na, “Masiguradok ay nasantoan ay ipogaw Diyos din lalaki ay doy ay kanayon ay mandagdagos sin beey ta. ");
INSERT INTO kne_vpl VALUES ("K24_10","013_4_10","2KI","4","10","10","Man-amag ta si kitkittoy ay kowarto sin ngato, asi tan pey-an si katri, lamisaan, tokdoan ya pansilawan ay osalena ta isdi ay mandagdagos mo omali isnan beey ta.” ");
INSERT INTO kne_vpl VALUES ("K24_11","013_4_11","2KI","4","11","11","Sin namingsan ay inmey si Eliseo isdi, en binmaktad sin akin ngato ay kowarto. ");
INSERT INTO kne_vpl VALUES ("K24_12","013_4_12","2KI","4","12","12","Kanana en Gehazi ay baa na, “En ka ayagan din babai.” Inayagana et en pinmika din babai sin kad-ana. ");
INSERT INTO kne_vpl VALUES ("K24_13","013_4_13","2KI","4","13","13","Kanan Eliseo en Gehazi, “Ibagam en sisya mo sino di maitolong ko ay isobalit isnan kinasiged na en daita. Amangan mo laydena ay enak makikali sin ari ono sin komander di sosoldado para en sisya.” Ngem kanan din babai, “Wada met amin ay kasapolak isnan ilik ay kad-an di kakailiak.” ");
INSERT INTO kne_vpl VALUES ("K24_14","013_4_14","2KI","4","14","14","Dinamag Eliseo en Gehazi, “Sino ngin ngarud di maidawat ko?” Kanan Gehazi, “Magay anak da yan enggay nakay si asawa na.” ");
INSERT INTO kne_vpl VALUES ("K24_15","013_4_15","2KI","4","15","15","Pag kanan Eliseo, “Ayagam sisya.” Inayagana et pinmika din babai sin segpan. ");
INSERT INTO kne_vpl VALUES ("K24_16","013_4_16","2KI","4","16","16","Kanan Eliseo, “Sin siya na ay timpo sin omali ay tawen, manbakwa ka si anak ay lalaki.” Ngem kanan din babai, “Apo, ipogaw daka en Diyos isonga adi ka koman iet-etekan nan mansilbi en sik-a.” ");
INSERT INTO kne_vpl VALUES ("K24_17","013_4_17","2KI","4","17","17","Ngem nawad-an din babai et nan-anak si lalaki sin kaman nidi ay timpo sin inmali ay tawen ay kaman din inbagan Eliseo. ");
INSERT INTO kne_vpl VALUES ("K24_18","013_4_18","2KI","4","18","18","Dinmakdake din anak yan sin namingsan inmonod en ama na ay wada sin kad-an di man-an-ani. ");
INSERT INTO kne_vpl VALUES ("K24_19","013_4_19","2KI","4","19","19","Idi siya et di, bigla ay kinalianas ama na yan kanana, “Aney! Din toktok ko!” Pag kanan ama na sin esa ay bag-ena, “Iey mo en ina na.” ");
INSERT INTO kne_vpl VALUES ("K24_20","013_4_20","2KI","4","20","20","Binakwan din bag-en ay in-ey sin inan di anak et binabakwan ina na enggana ay alas dosi, pag et matey din anak. ");
INSERT INTO kne_vpl VALUES ("K24_21","013_4_21","2KI","4","21","21","In-ey na din anak sin akin ngato ay kowarto, pag nan pabaktaden sin kaseyseyepan din mamadton Diyos. Binmala et in-eb na. ");
INSERT INTO kne_vpl VALUES ("K24_22","013_4_22","2KI","4","22","22","Inayagana si asawa na yan kanana, “Pangaasim kod ta man-ibaa kas na si esa ay bag-en ya dangki ta emeyak ay dagos sin kad-an din ipogaw Diyos, asiak mantaoli.” ");
INSERT INTO kne_vpl VALUES ("K24_23","013_4_23","2KI","4","23","23","Kanan asawa na ay mandamag, “Sinoy gapo ay emey ka en sisya ed wani ay agew yan baken beskan di bowan ay pan-idatonan tako ono agew ay pan-illengan?” Ngem kanan din babai, “Olay adi.” ");
INSERT INTO kne_vpl VALUES ("K24_24","013_4_24","2KI","4","24","24","Inpaiamag na din silyan di dangki yan nangabayo, pag na et kanan sin bag-ena, “Dagdagem din dangki. Adi kan pan-inayaden begew en sak-en mo adiak ibaga.” ");
INSERT INTO kne_vpl VALUES ("K24_25","013_4_25","2KI","4","25","25","Et inmey sin kad-an di mamadton Diyos sin dontog ay Carmel. Idi tinamang Eliseo din babai sin addawi pay laeng, kananan Gehazi ay baa na, “Dooy ay omal-ali din babai ay taga-Sunem. ");
INSERT INTO kne_vpl VALUES ("K24_26","013_4_26","2KI","4","26","26","Dalasem, managtag ka ay en mangabat ta damagem mo mayat met laeng di kasasaad na, si asawa na ya din anak da.” Idi dinamag Gehazi, kanan din babai ay nanongbat, “Mayat amin.” ");
INSERT INTO kne_vpl VALUES ("K24_27","013_4_27","2KI","4","27","27","Idi domateng sin kad-an Eliseo sin dontog, kapakod sin sikin Eliseo. Itodon koman Gehazi ngem kanan Eliseo, “Bay-am, tan palaloy ladingit na, ngem nay adi inpaammon Diyos en sak-en di gapo na.” ");
INSERT INTO kne_vpl VALUES ("K24_28","013_4_28","2KI","4","28","28","Kanan din babai, “Apo, adiak met nankedaw en sik-a si anak yan kanak abe en adi ka koman omietek ay mangidawat si pannamnamaak.” ");
INSERT INTO kne_vpl VALUES ("K24_29","013_4_29","2KI","4","29","29","Binilin Eliseo si Gehazi ay kanana, “Bilkoam san badom ta itagtag mo nan sokod ko ta ipatang mo sin ropan di anak. Adi kan somalsaldeng ay mangkablaaw mo waday abatem yan mo kablaawan das sik-a, adi ka masapol ay songbatan.” ");
INSERT INTO kne_vpl VALUES ("K24_30","013_4_30","2KI","4","30","30","Ngem kanan din inan di anak, “Isapatak en sik-a ya din matmatago ay Diyos ay adiak taynan sik-a.” Isonga pinmika si Eliseo et nakikoyog en sisya. ");
INSERT INTO kne_vpl VALUES ("K24_31","013_4_31","2KI","4","31","31","Nangon-ona si Gehazi ay inpatang na din sokod sin ropan di anak, ngem magay mailas nanbaliwana ay kailaana ay mabiyag isonga nantaoli ay en nangabat en Eliseo yan kanana, “Adi met binmangon din anak.” ");
INSERT INTO kne_vpl VALUES ("K24_32","013_4_32","2KI","4","32","32","Idi somawang si Eliseo, wada din anak ay naipapabaktad sin katri na yan magay biyag na. ");
INSERT INTO kne_vpl VALUES ("K24_33","013_4_33","2KI","4","33","33","Sinenggep pag nan in-eb et ang-anggoy da ay dowa sin anak, pag mankararag en Diyos. ");
INSERT INTO kne_vpl VALUES ("K24_34","013_4_34","2KI","4","34","34","Pag lomakpap sin awak di anak dowanan itakap din tepek, mata ya takkay na sin tepek, mata ya takkay di anak et inmatong din awak di anak. ");
INSERT INTO kne_vpl VALUES ("K24_35","013_4_35","2KI","4","35","35","Kinmaan si Eliseo ay mandinad-an sin kowarto asi kasin lomakpap sin awak di anak. Kaakbis din anak si namin pito yan kiniyat na din mata na. ");
INSERT INTO kne_vpl VALUES ("K24_36","013_4_36","2KI","4","36","36","Inpaayag Eliseo en Gehazi din babai ay taga-Sunem. Idi domateng yan kanana, “Alaem nan anak mo.” ");
INSERT INTO kne_vpl VALUES ("K24_37","013_4_37","2KI","4","37","37","Sinenggep et nanyakog-ong ay nandokmog sin sangoanan Eliseo, asi na alaen din anak na, pag bomala. ");
INSERT INTO kne_vpl VALUES ("K24_42","013_4_42","2KI","4","42","42","Sin namingsan, waday lalaki ay napod Baal Salisa ay nangiey en Eliseo si kaap-apit na ay mais ay naidamdam ya dowanpo ay tinapay ay napo sin sabog ay nangon-onaen da ay inani. Kanan Eliseo sin baa na, “Ipakan mo dana sin papasolot ko ay mamadto.” ");
INSERT INTO kne_vpl VALUES ("K24_43","013_4_43","2KI","4","43","43","“Ngem adi met omanay sa si sin-gasot ay ipogaw,” kanana ay sinombat. Kanan aben Eliseo, “Idawat mo od en daida, tan inbagan Diyos ay mangan da ay kosto yan wada pay di mabay-an.” ");
INSERT INTO kne_vpl VALUES ("K24_44","013_4_44","2KI","4","44","44","Siya di, insango na en daida et tinmet-ewa din inbagan Diyos, tan nangan da am-in yan wada abey nabay-an. ");
INSERT INTO kne_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Wada di si Naaman ay komander di sosoldadon din ari ed Syria. Madaydayaw ay ipogaw yan peteg ay binanbanol din apo na tan gapo en sisya, nangabaken Diyos ed Syria. Natoled ay soldado ngem nakaptan si kaeegyat ay sakit di kodil. ");
INSERT INTO kne_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Sin namingsan ay ginobat din taga-Syria ed Israel, waday balod da ay balasitang ay Israelita et nanbalin sisya ay bag-en din asawan Naaman. ");
INSERT INTO kne_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Kanan din balasitang sin apo na ay babai, “Mo en koman manpaila din apok sin pankalkalian Diyos ed Samaria et agasana din sakit di kodil na.” ");
INSERT INTO kne_vpl VALUES ("K25_4","013_5_4","2KI","5","4","4","Inmey si Naaman sin kad-an di ari et dinad-at na din inbagan di balasitang ay Israelita. ");
INSERT INTO kne_vpl VALUES ("K25_5","013_5_5","2KI","5","5","5","Kanan din ari, “Mabalin, emey ka. Mansolatak sin ari ed Israel.” Et inmey si Naaman yan nan-itakin si sinpo ay talento ay palata, pitopolo ay kilo ay balitok ya sinpo ay paris ay bado. ");
INSERT INTO kne_vpl VALUES ("K25_6","013_5_6","2KI","5","6","6","Indawat na din solat sin ari ed Israel yan siya nay kanan din solat: “Nay di solat ay mangipaammo ay inbaak nan si Naaman ay mansilsilbi en sak-en ta agasam din sakit di kodil na.” ");
INSERT INTO kne_vpl VALUES ("K25_7","013_5_7","2KI","5","7","7","Idi binasan din ari ed Israel din solat, kabisngit sin bado na yan kanana, “Apay nga inbaan san ari ed Syria nan kaeegyat di sakit di kodil na yan kanana en agasak? Ay Diyosak aya ta kabaelak ay mamse ya manago kasin? Gandat ay man-an-anap si pan-gapoana ay omibaw.” ");
INSERT INTO kne_vpl VALUES ("K25_8","013_5_8","2KI","5","8","8","Idi dinngen Eliseo, ay mamadton Diyos, ay siya na di napasamak, nan-ibaa si nangibaga sin ari, “Apay nga binisngit mo din badom? Ibaam din lalaki ay sana en sak-en ta maammoana ay waday pankalkalian Diyos isnan Israel.” ");
INSERT INTO kne_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Et siya di, nanlogan da Naaman sin kalisa na ay inmey sin beey Eliseo et sinmaldeng da sin kad-an di segpan. ");
INSERT INTO kne_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Waday inbaan Eliseo ay nangibaga en Naaman, “En ka man-ames si mamin pito sin ginawang ay Jordan et maagasan din kodil mo ya malinisan.” ");
INSERT INTO kne_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Ngem palaloy bonget Naaman ay kinmaan yan kanana, “Inpagarup ko ay en omabat ya mankararag en Yahweh ay Diyos na, asi nan iwasawas din takkay na sin patag di sakit ko ta maagasan! ");
INSERT INTO kne_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Ay baken ayan nalinlinis di danom ed Abana ya Farfar ay ginawang ed Damascus mo din amin ay danom isnan Israel? Ay adiak malinisan mo say pan-amsak?” ");
INSERT INTO kne_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Ngem inmey sin kad-ana din baa na yan kanan da, “Mo naligat koma di ipaamag din mamadton sik-a, ay adim ayan amagen? Ay sino od abey adi kan pangamagan issan kanana en ‘Man-ames ka ta dadlon maagasan din kodil mo’?” ");
INSERT INTO kne_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Et tinongpal Naaman din inbagan di mamadton Diyos. Nanballalong sin ginawang ay Jordan et en nantab-en sidi si namin pito. Pag maitaoli din sigod ay kodil na yan nalinis ay kaman kodil di moyang. ");
INSERT INTO kne_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Nantaolis sisya ya din amin ay kinoyog na sin kad-an Eliseo. En da pinmika sin sangoanana yan kanana, “Ed wani yan inammoak ay magay odom ay Diyos isnan intiro ay lobong mo adi et anggoy din Diyos di Israel. Pangaasim koma, apo, ta awatem nan isagot ko.” ");
INSERT INTO kne_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Ngem kanan din mamadto ay nanongbat, “Isapatak en Diyos ay matmatagos eng-enggana ay pansilsilbiak ay maga polos di awatek.” Ipilit Naaman ngem sinigaana. ");
INSERT INTO kne_vpl VALUES ("K25_17","013_5_17","2KI","5","17","17","Kanan Naaman, “Mo sigaam, ipalobos mo kod ay isaak di kaad-adon di lota ay kabaelan di dowa ay kabayo ay kalgaen, tan manlogi ed wani, maga di idaton ko ay mapooan ya odom ay datdaton mo baken si Diyos di pangidatonak. ");
INSERT INTO kne_vpl VALUES ("K25_18","013_5_18","2KI","5","18","18","Ngem sapay koma ta pomakawan si Diyos mo makisgepak sin ari mi ay apok sin timplon Rimmon ay diyos mi ya makidokmogak en sisya sin sangoanan Rimmon.” ");
INSERT INTO kne_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","“Somaa ka ay natalna di nemnem mo,” kanan Elias. Siya di, nanlobwat da Naaman ay somaa. Adi da onay inmaddawi ");
INSERT INTO kne_vpl VALUES ("K25_20","013_5_20","2KI","5","20","20","yan kanan Gehazi ay baan Eliseo sin nemnem na, “Palalo di kinaanos din apok sin taga-Syria ay doy. Adi na et inawat din idawdawat na. Isapatak en Diyos ay apayawek daida ta enak mankedaw.” ");
INSERT INTO kne_vpl VALUES ("K25_21","013_5_21","2KI","5","21","21","Et inapayaw Gehazi da Naaman. Idi tinamang Naaman sisya ay managtagtag ay omasag-en, kadisaag sin kalisa na et inabat na yan kanana, “Sinoy napasamak?” ");
INSERT INTO kne_vpl VALUES ("K25_22","013_5_22","2KI","5","22","22","Kanan Gehazi, “Maga, ngem inmibaa din apok tan waday dinmateng ay dowa ay mimbro sin grupon di mamadto ay napo sin kadondontogan ed Efraim. Pangaasim kod ta idawtam daida si esay talento ay palata ya doway paris ay bado.” ");
INSERT INTO kne_vpl VALUES ("K25_23","013_5_23","2KI","5","23","23","Kanan Naaman, “Pangaasim ta alaem nan dowa ay talento.” Inpilit Naaman et inpeey na si dowa ay sako din dowa ay talento ay palata ya doway paris ay bado. Inpag-ena si dowa ay baa na et in-on-ona da en Gehazi. ");
INSERT INTO kne_vpl VALUES ("K25_24","013_5_24","2KI","5","24","24","Idi domateng si Gehazi sin bilig ay kad-an di beey da en Eliseo, ina na sin dowa ay baa din in-genan da et indolina sin beey, pag nan ibaas daida ay mantaoli. ");
INSERT INTO kne_vpl VALUES ("K25_25","013_5_25","2KI","5","25","25","Makdeng pay di, inmey sin kad-an Eliseo ay apo na. “Gehazi, intoy inmeyam?” kanan Eliseo yan kanan Gehazi ay nanongbat, “Maga met di inmeyak, apo.” ");
INSERT INTO kne_vpl VALUES ("K25_26","013_5_26","2KI","5","26","26","Ngem kanan Eliseo, “Inilak sin nemnem ko din nandisaagan di lalaki sin kalisa na ay en nangabat en sik-a. Baken kosto ay timpo ed wani ay pangaan si pilak ono pangawatan si bado, daga ay namolaan si olivo ya obas, animal ya baa. ");
INSERT INTO kne_vpl VALUES ("K25_27","013_5_27","2KI","5","27","27","Ed wani, komapet si eng-enggana en sik-a ya sin polim din sakit Naaman.” Idi kinmaan si Gehazi sin kad-an Eliseo, kinapet di kaeegyat ay sakit di kodil et kinmilakilat din kodil na ay kaman andap. ");
INSERT INTO kne_vpl VALUES ("K26_1","013_6_1","2KI","6","1","1","Sin namingsan, kanan din grupon di mamadto en Eliseo, “Palalo ay nalipit nan pakibebbeeyan min sik-a. ");
INSERT INTO kne_vpl VALUES ("K26_2","013_6_2","2KI","6","2","2","Palobosam kod dakami ay emey ed Jordan ta en kami manpoyo si sag-eesa ay kaiw ay iamag takos beey.” Kanan Eliseo, “Aw a, emey kayo.” ");
INSERT INTO kne_vpl VALUES ("K26_3","013_6_3","2KI","6","3","3","Nanpakaasi di esa en makiey si Eliseo et nakiey en daida. ");
INSERT INTO kne_vpl VALUES ("K26_4","013_6_4","2KI","6","4","4","Inmey da ed Jordan et nilogian da ay nanpoyos kaiw. ");
INSERT INTO kne_vpl VALUES ("K26_5","013_6_5","2KI","6","5","5","Idi man-getgetad din esa, nalokmos din wasay et nag-as sin posong, isonga kanana, “Apo, ay ta et na! Intoy iyat ko pay yan owat kon binolod?” ");
INSERT INTO kne_vpl VALUES ("K26_6","013_6_6","2KI","6","6","6","Kanan Eliseo, “Intoy nag-asana?” Idi initdon din lalaki, nanpoto si Eliseo si kitkittoy ay pingin di kaiw ay intep-a na sin posong yan pag et tomay-apew din wasay. ");
INSERT INTO kne_vpl VALUES ("K26_7","013_6_7","2KI","6","7","7","“Alaem!” kanan Eliseo et inan din lalaki. ");
INSERT INTO kne_vpl VALUES ("K26_8","013_6_8","2KI","6","8","8","Sin doy ay timpo, ginobat din ari ed Syria din Israelita. Nakikali sin oopisyal na et pinili na din ili ay en da gobaten. ");
INSERT INTO kne_vpl VALUES ("K26_9","013_6_9","2KI","6","9","9","Ngem nan-ibaas Eliseo si en mangidadaan sin ari ed Israel ay bantayan da koma din lugar ay doy tan planon din taga-Syria ay en gobaten. ");
INSERT INTO kne_vpl VALUES ("K26_10","013_6_10","2KI","6","10","10","Isonga inbaan din ari ed Israel di sosoldado ta gowardiyaan da di ay lugar. Namin piga ay napasamak di. ");
INSERT INTO kne_vpl VALUES ("K26_11","013_6_11","2KI","6","11","11","Palalo di bonget din ari ed Syria, isonga inayagana din oopisyal na yan kanana, “Sino en dakayo di manglilipot ay nan-isodsod sin ari ed Israel?” ");
INSERT INTO kne_vpl VALUES ("K26_12","013_6_12","2KI","6","12","12","Kanan di esa, “Apo ari, maga en dakami ngem si Eliseo ay mamadto ed Israel di mangibagbaga sin ari, olay pay din ibagam sin oneg di kowartom.” ");
INSERT INTO kne_vpl VALUES ("K26_13","013_6_13","2KI","6","13","13","Kanan din ari, “En kayo anapen di kad-ana ta man-ibaaak si en manpap en sisya.” Wada di nangibaga en wadad Dotan ");
INSERT INTO kne_vpl VALUES ("K26_14","013_6_14","2KI","6","14","14","et nan-ibaa si ad-ado ay soldado ay nangabayo ya nanlogan si kalisa ay para gobat. Labi di inmeyan da et nilikob da din ili. ");
INSERT INTO kne_vpl VALUES ("K26_15","013_6_15","2KI","6","15","15","Nasapa ay binmangon sin kabigatana din baan Eliseo. Idi bomala, inila na di ad-ado ay sosoldado pati din nangakabayo ya nangakalisa ay nanglikob sin ili. Kanana en Eliseo, “Apo, inayan et na! Sino pay di amagen ta?” ");
INSERT INTO kne_vpl VALUES ("K26_16","013_6_16","2KI","6","16","16","Kanan din mamadto, “Adi ka emegyat tan ad-ad-ado di gait ta mo si daida.” ");
INSERT INTO kne_vpl VALUES ("K26_17","013_6_17","2KI","6","17","17","Pag nan kanan ay nankararag, “Sik-a ay Yahweh, bokatam kod din mata na ta ilaena.” Binokatan Diyos din mata na et inila na ay napno din dodontog si omap-apoy ay kabayo ya kalisa ay para gobat ay nanglikob en Eliseo. ");
INSERT INTO kne_vpl VALUES ("K26_18","013_6_18","2KI","6","18","18","Idi sinmag-en din kalaban da, kanan Eliseo ay nankararag, “Apo Yahweh, godabem kod da nan ipogaw ay nay.” Pinatgan Diyos din kararag Eliseo et ginodab nas daida. ");
INSERT INTO kne_vpl VALUES ("K26_19","013_6_19","2KI","6","19","19","Idi siya di, inmey si Eliseo sin kad-an da yan kanana, “Baken sinay di danan ya ili ay kad-an din an-anapen yo. Omonod kayon sak-en ta itdok di kad-ana.” Et inpango nas daida ed Samaria. ");
INSERT INTO kne_vpl VALUES ("K26_20","013_6_20","2KI","6","20","20","Idi enggay sinenggep da sin siyodad, kanan Eliseo ay nankararag, “Yahweh, bokatam kod din mata da.” Binokatan Diyos din mata da et idi manmokilang da, kambaw wada da sin oneg di alad ed Samaria! ");
INSERT INTO kne_vpl VALUES ("K26_21","013_6_21","2KI","6","21","21","Idi inilan din ari ed Israel daida, kanana en Eliseo, “Apo, ay peslek daida? Ay mayat mo peslek daida?” ");
INSERT INTO kne_vpl VALUES ("K26_22","013_6_22","2KI","6","22","22","Ngem kanan Eliseo, “Adi yon pespeslen. Olay din depapen yo sin gobatan et adi yon peslen. Agpos et mo idawtan yos daida si kanen ya inomen da ta asi da mantaoli sin apo da.” ");
INSERT INTO kne_vpl VALUES ("K26_23","013_6_23","2KI","6","23","23","Siya et di inpaisaganan din ari di ad-ado ay makan et idi makakan ya makainom da, inbaa nas daida ay mantaoli sin apo da. Et say nangisaldengan din gugrupon di soldado ay taga-Syria ay en mamalpaligat sin Israelita. ");
INSERT INTO kne_vpl VALUES ("K213_14","013_13_14","2KI","13","14","14","Nansakit si Eliseo si nakaro yan idi dandani ay matey, en inilan Jehoas ay ari ed Israel. Nan-oga din ari yan kanana, “Ay amak, ay amak! Sik-a di napigsa ay nanalsalaknib isnan Israel.” ");
INSERT INTO kne_vpl VALUES ("K213_15","013_13_15","2KI","13","15","15","Kanan Eliseo ay nangibilin en sisya, “Man-a ka si pana ya bala na.” Nan-a si Jehoas, ");
INSERT INTO kne_vpl VALUES ("K213_16","013_13_16","2KI","13","16","16","yan binilin Eliseo ay binatena din pana et tinongpal na yan kinapay Eliseo din takkay na. ");
INSERT INTO kne_vpl VALUES ("K213_17","013_13_17","2KI","13","17","17","Binilin Eliseo ay bokatana din tawa ay naisagang ed Syria ta ipana na din iin-genana et say inyat na tet-ewa. Pag kanan Eliseo, “Sik-a di maiarig si panan Diyos ay pangabak na sin taga-Syria. Gobatem to daida ed Afek enggana ay dadlon kan abaken daida.” ");
INSERT INTO kne_vpl VALUES ("K213_18","013_13_18","2KI","13","18","18","Idi makdeng di, inbilin Eliseo ay alaena din odom ay pana ta ipana na sin lota. Namitlo ay pinanan din ari din lota yan pag somaldeng. ");
INSERT INTO kne_vpl VALUES ("K213_19","013_13_19","2KI","13","19","19","Manbonget et si Eliseo yan kanana, “Pinanam koma si namin lima ono namin enem ta say dadlon mon abaken din taga-Syria. Ngem ed wani, namin tolo anggoy ay abakem daida.” ");
INSERT INTO kne_vpl VALUES ("K213_20","013_13_20","2KI","13","20","20","Pag matey si Eliseo et naiponpon. Idi siya di, tinawtawen ay gobaten din Moabita din Israelita. ");
INSERT INTO kne_vpl VALUES ("K213_21","013_13_21","2KI","13","21","21","Sin namingsan, waday en nangiponpon si minatay da. Inila da et di bonggoy di tollisan ay Moabita yan kaitep-a da sin bangkay sin naiponponan Eliseo pag dan katagtag. Idi kosto ay naigiwit din bangkay sin tong-an Eliseo, natago et din natey ay sana et pinmika. ");
INSERT INTO kne_vpl VALUES ("K217_1","013_17_1","2KI","17","1","1","Sin maikasinpo ya dowa ay tawen ay nanturayan Ahaz ay ari ed Juda, naisaad si Hoshea ay anak Ela ay man-ari ed Israel. Ed Samaria di nangisaadan dan sisya ay ari et nanturay si siyam ay tawen. ");
INSERT INTO kne_vpl VALUES ("K217_2","013_17_2","2KI","17","2","2","Nanbasol en Diyos ngem baken kaman din inam-amag di aari ed Israel ay sinokatana. ");
INSERT INTO kne_vpl VALUES ("K217_3","013_17_3","2KI","17","3","3","Ginobat Salmaneser ay ari ed Assyria et sinmoko si Hoshea, isonga tinawen ay nanbaybayad si bowis en sisya. ");
INSERT INTO kne_vpl VALUES ("K217_4","013_17_4","2KI","17","4","4","Ngem sin namingsan, waday inbaan Hoshea en So ay ari ed Egipto ta manpatolong yan insaldeng na abe ay manbayad si tinawtawen ay bowis. Idi inammoan Salmaneser, inpadpap ya inpaibalod nas sisya. ");
INSERT INTO kne_vpl VALUES ("K217_5","013_17_5","2KI","17","5","5","Pag nan gobaten din intiro ay Israel et nilikob da ed Samaria si tolo ay tawen. ");
INSERT INTO kne_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","Sin maikasiyam ay tawen di nanturayan Hoshea, enggay sinakop din arin di Assyria ed Samaria et inkoyog na ed Assyria din Israelita ay balod na. Nanteeenas daida ed Hala, din odom sin asag-en di ginawang ay Habor ay sakop di Gozan yan din odom sin il-ili ed Media. ");
INSERT INTO kne_vpl VALUES ("K217_7a","013_17_7a","2KI","17","7a","7a","Napasamak amin dana gapo ta nanbasol din Israelita en Yahweh ay Diyos da. ");
INSERT INTO kne_vpl VALUES ("K217_13","013_17_13","2KI","17","13","13","Inpanemnem Diyos din linteg na sin man-ili ed Israel ya Juda ya binagbagaanas daida babaen sin amin ay mamadto ya pankalkaliana ta dokogan da din lawa ay am-amagen da ya tongpalen da amin din linteg ay inbilina sin ap-apo da. ");
INSERT INTO kne_vpl VALUES ("K217_14","013_17_14","2KI","17","14","14","Ngem adi dan ikaskaso tan kinmenteg di nemnem da ay kaman din ap-apo da ay adi nantalek en Yahweh ay Diyos da. ");
INSERT INTO kne_vpl VALUES ("K217_15","013_17_15","2KI","17","15","15","Adi dan tinongpal din bilbilina ya din intolag na sin ap-apo da yan adi da aben inkaskaso din pamagbaga na. Nandaydayaw da si didiyosen ay magay silsilbi na et nanbalin da abes magay silsilbi na. Inonodan da din am-amagen di odom ay nasyon ay nandinmang olay mo inbilin Diyos ay adi da amagen di. ");
INSERT INTO kne_vpl VALUES ("K217_16","013_17_16","2KI","17","16","16","Dinokogan da amin din bilbilin Yahweh ay Diyos da et nan-amag da si dowa ay sinan baka ay nam-es si balitok ay dinaydayaw da ya nantood da si posti ay pangidaydayaw da en Asera. Nandaydayaw da sin tatalaw yan dinayaw da abe si Baal. ");
INSERT INTO kne_vpl VALUES ("K217_17","013_17_17","2KI","17","17","17","Indaton da din an-ak da ay mapooan dowan da et mansip-ok, man-gengey ya manpontos, et enggay inmongsan dan nemnem da ay nangam-amag si lawa sin pangilan Diyos, isonga inpabonget das sisya. ");
INSERT INTO kne_vpl VALUES ("K217_18","013_17_18","2KI","17","18","18","Palalo di bonget Diyos sin Israelita et inpakaanas daida sin sangoanana. Say nabay-an din tribun Juda, ");
INSERT INTO kne_vpl VALUES ("K217_19","013_17_19","2KI","17","19","19","ngem olay din tribun Juda yan adi dan tinongpal din bilina, tan inonodan da din ogali ay inonodan di Israelita. ");
INSERT INTO kne_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Sin maikatlo ay tawen ay nanturayan Hoshea ay anak Ela ay ari ed Israel, nanlogi ay nanturay ed Juda si Hezekias ay anak Ahaz. ");
INSERT INTO kne_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Mantawen si dowanpo ya lima sin nanbalinana ay ari yan nanturay ed Jerusalem si dowanpo ya siyam ay tawen. Si Abia ay anak Zekarias di si ina na. ");
INSERT INTO kne_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Din siged sin pangilan Diyos di inam-amag na ay kaman si apo na ay si David. ");
INSERT INTO kne_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Dinadael na din pandaydayawan sin dodontog, ginmek na din tinootood da ay bato ay inbilang da ay inayan, ya pinoyo na din posti ay pangidaydayaw da en Asera. Minekmek na abe din bronsi ay sinan eweg ay inamag Moses ay kanan da en Nehustan, tan enggay et ay pan-idatonan di ipogaw si ipoo da ay insinso. ");
INSERT INTO kne_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Nantalek si Hezekias en Yahweh ay Diyos di Israelita. Magay makaiso en sisya sin aari ay namangpango ya naisokat en sisya. ");
INSERT INTO kne_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","Adi polos nankeykeyat mo adi et intoltoloy na ay nantalek ya nantongpal sin bilbilin ay inpaammon Diyos en Moses. ");
INSERT INTO kne_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Kinadkadwan Diyos sisya et kosto amin di nantongpalan di inam-amag na. Kinontra na din ari ed Assyria et sinigaana ay paituray en sisya. ");
INSERT INTO kne_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Inabak na abe din il-ilin di Filisteo, olay kakitkittoyan ay sitio ya siya abe din naaladan ay siyodad, engganad Gaza ya din nandinmang ay il-ili. ");
INSERT INTO kne_vpl VALUES ("K218_13","013_18_13","2KI","18","13","13","Sin maikasinpo ya opat ay tawen ay nanturayan Hezekias, en ginobat Sennakerib ay ari ed Assyria am-in din naaladan ay siyodad ed Juda et inabak na. ");
INSERT INTO kne_vpl VALUES ("K218_14","013_18_14","2KI","18","14","14","Isonga sin kawada na ed Lakis inpatolod Hezekias di solat en sisya ay kanana, “Baken baw kayman kosto di inyat ko. Pangaasim ta komaan kayo isnan ilik ta bayadak olay sino ay ibagam.” Din insongbat Sennakerib et manbayad komas Hezekias si sinpo ay libo ay kilo ay palata ya sinlibo ay kilo ay balitok. ");
INSERT INTO kne_vpl VALUES ("K218_15","013_18_15","2KI","18","15","15","Isonga inpaw-it Hezekias am-in din palata ay naidodolin sin Timplon Diyos ya sin naidodolinan di kinabaknang sin palasyo. ");
INSERT INTO kne_vpl VALUES ("K218_16","013_18_16","2KI","18","16","16","Kinaana abe din balitok ay inpakpak na sin eneb ya hamban di pantew sin Timplon Diyos et inpatolod na abe en Sennakerib. ");
INSERT INTO kne_vpl VALUES ("K218_17a","013_18_17a","2KI","18","17a","17a","Idi siya di, inbaan Sennakerib din tolo ay kangatoan ay opisyal di sosoldado na ay emey sin kad-an Hezekias ed Jerusalem et inkoyog da di dakdake ay bonggoy di sosoldado ay nanlobwat ed Lakis. ");
INSERT INTO kne_vpl VALUES ("K218_28","013_18_28","2KI","18","28","28","Pinmika din komander yan kanana ay nangibogaw sin kalin di Hebreo, “Dengngen yo nan inbagan di madaydayaw ay ari ed Assyria. ");
INSERT INTO kne_vpl VALUES ("K218_29","013_18_29","2KI","18","29","29","Kanana, ‘Siliban yo ta adi ietekan Hezekias si dakayo, tan adi nan kabaelan ay isalakan dakayo. ");
INSERT INTO kne_vpl VALUES ("K218_30","013_18_30","2KI","18","30","30","Adi kayo aben maietekan mo awisenas dakayo ay mantalek en Diyos ya mo kanana en isalakan Diyos dakayo et adi na ipalobos ay abakek si dakayo. ");
INSERT INTO kne_vpl VALUES ("K218_33","013_18_33","2KI","18","33","33","Ay siya mo waday diyos di olay sino ay nasyon ay nangisalakan si ipogaw na ta say adiak makaabak en daida?’” ");
INSERT INTO kne_vpl VALUES ("K219_1","013_19_1","2KI","19","1","1","Idi dinngen Ari Hezekias di, kabisngit sin bado na ay mangipaila sin sakit di nemnem na, pag manbado si makelsang ay sako yan inmey sin Timplo. ");
INSERT INTO kne_vpl VALUES ("K219_2","013_19_2","2KI","19","2","2","Inbaa nas da Eliakim ay pangolon di mangas-asikaso sin palasyo, si Sebna ay sekretaryon di palasyo ya din papangolon di papadi, et nanbado das sako ay inmey sin mamadto ay si Isaias ay anak Amoz. ");
INSERT INTO kne_vpl VALUES ("K219_3","013_19_3","2KI","19","3","3","Kanan da en sisya, “Siya na di kanan Hezekias: ‘Timpon di ligat ed wani ay agew, madosdosa ya maibabain tako. Kaman din dandani ay bomalaan di anak ngem magay pigsan din ina ay mangipabala. ");
INSERT INTO kne_vpl VALUES ("K219_4","013_19_4","2KI","19","4","4","Inbaan din ari ed Assyria din komander di sosoldado na yan sapay koma ta dinngen Yahweh ay Diyos mo din inbagbaga na ay manglaslasoy en sisya ay matmatago ay Diyos ta dosaena begew isdi ay kinali na. Isonga ikararagam koma din nabay-an ay kailian tako.’” ");
INSERT INTO kne_vpl VALUES ("K219_5","013_19_5","2KI","19","5","5","Idi dinmateng din oopisyal ay inbaan Ari Hezekias yan dinngen Isaias din inbaga da, ");
INSERT INTO kne_vpl VALUES ("K219_6","013_19_6","2KI","19","6","6","kanana en daida, “Ibaga yo sin apo yo ay siya na di inbagan Diyos: ‘Adi kan emegyat sin inbagan di baan di ari ed Assyria ay manglaslasoy en sak-en. ");
INSERT INTO kne_vpl VALUES ("K219_7","013_19_7","2KI","19","7","7","Iturong kon to di nemnem na ta say mo dengngena di baken kosto ay ipadamag di esa ay baa na, somaa, et isdi ay ipapsek si kampilan.’” ");
INSERT INTO kne_vpl VALUES ("K219_14","013_19_14","2KI","19","14","14","Idi inawat Hezekias din solat ay naipaw-it en sisya, binasa na, pag emey sin Timplon Diyos. Inoklag na din solat sin sangoanan Diyos, ");
INSERT INTO kne_vpl VALUES ("K219_15","013_19_15","2KI","19","15","15","yan kanana ay nankararag, “Sik-a ay Yahweh ay Diyos mi ay Israelita, wada ka ay tinmotokdo sin tronom sin nan-gawaan di dowa ay kerubim. Sik-a et anggoy di Diyos ay makaammo sin am-in ay nasyon isnan daga, tan sik-a di namarsua sin daga ya am-in ay wada ed daya. ");
INSERT INTO kne_vpl VALUES ("K219_16","013_19_16","2KI","19","16","16","Ed wani, Apo, ilaem kod din mapaspasamak en dakami. Dengngem abe din inbagan Sennakerib ay manglaslasoy en sik-a ay matmatago ay Diyos. ");
INSERT INTO kne_vpl VALUES ("K219_17","013_19_17","2KI","19","17","17","Tet-ewa iman ay begew sin aari ed Syria, naabosan di odom ay nasyon si omili ya nadadael di daga da. ");
INSERT INTO kne_vpl VALUES ("K219_18","013_19_18","2KI","19","18","18","Din aari ay nay et inwasit da abe din didiyosen da sin apoy et napooan da, tan baken dan tet-ewa ay diyos mo adi et owat bato ya kaiw ay inamag di ipogaw si sinan didiyos. ");
INSERT INTO kne_vpl VALUES ("K219_19","013_19_19","2KI","19","19","19","Isonga Yahweh ay Diyos mi, pangaasim ta isalakan mos dakami sin panakabalin nan ari ay nay, ta say pangammoan din omili sin am-in ay nasyon isnan daga ay sik-a et anggoy ay Yahweh di Diyos.” ");
INSERT INTO kne_vpl VALUES ("K219_20","013_19_20","2KI","19","20","20","Idi siya di, nan-ibaa si Isaias ay anak Amoz si en nangibaga en Hezekias ay dinngen Yahweh ay Diyos di Israelita din kararag na maipanggep en Sennakerib ay ari ed Assyria ");
INSERT INTO kne_vpl VALUES ("K219_32","013_19_32","2KI","19","32","32","et siya na di inbagan Diyos maipanggep en sisya: “Adi makasgep sin siyodad ay nay yan magay pana ay iturong nas na. Adi omasag-en di sosoldado na ay en mangobat. Maga abe di mangamag si somakyaban da ay manadael sin alad di siyodad. ");
INSERT INTO kne_vpl VALUES ("K219_33","013_19_33","2KI","19","33","33","Adi polos makasgep isnan ili, tan awni et mantaoli sin nandanana ay inmali. Sak-en si Diyos ay nangibaga. ");
INSERT INTO kne_vpl VALUES ("K219_34","013_19_34","2KI","19","34","34","Salaknibak ya isalakan ko din siyodad ay nay ta say madayawak ya matongpal din inkarik en David ay baak.” ");
INSERT INTO kne_vpl VALUES ("K219_35","013_19_35","2KI","19","35","35","Sin labi ay doy, waday anghel Diyos ay inmey sin kampon di taga-Assyria yan pinse na di 185,000 ay sosoldado da. Idi bomangon din gagait da sin napat-aana, inila da din am-in ay natey. ");
INSERT INTO kne_vpl VALUES ("K219_36","013_19_36","2KI","19","36","36","Siya di, tinopin da Sennakerib ay ari ed Assyria din tolda da et nantaoli da ay en nantee ed Nineve. ");
INSERT INTO kne_vpl VALUES ("K219_37","013_19_37","2KI","19","37","37","Sin namingsan ay wadas sisya ay mandaydayaw sin timplon Nisrok ay diyos na, pinsen da Adrammelek en Sarezer ay an-ak na et pag dan lomayaw ay emey ed Ararat. Et si Esarhaddon ay esa ay anak na di naisokat en sisya ay nan-ari. ");
INSERT INTO kne_vpl VALUES ("K220_1","013_20_1","2KI","20","1","1","Sin doy ay timpo, nansakit si Ari Hezekias yan enggay kaman matey. En inilan din mamadto ay si Isaias ay anak Amoz yan kananan sisya, “Inbilin Diyos en olnosem di amin sin beey mo tan adi ka mailatonan, et matey ka.” ");
INSERT INTO kne_vpl VALUES ("K220_2","013_20_2","2KI","20","2","2","Siya di, sinagong Hezekias din dingding yan kanana ay nankararag, “Sik-a ay Diyos, nemnemem koma ay inpapasnek ko ay mansilbi en sik-a ya inpakat ko di amin ay kabaelak ay nangamag si kosto sin pangilam.” ");
INSERT INTO kne_vpl VALUES ("K220_3","013_20_3","2KI","20","3","3","Pag palalo ay man-anog-og. ");
INSERT INTO kne_vpl VALUES ("K220_4","013_20_4","2KI","20","4","4","Tinaynan Isaias din ari, ngem idi wada pay laeng sin gawan di bel-ayan di palasyo yan kanan Diyos en sisya en ");
INSERT INTO kne_vpl VALUES ("K220_5","013_20_5","2KI","20","5","5","mantaoli sin kad-an Hezekias ay mangiturturay sin ipogaw Diyos ta ibaga na en sisya, “Siya na di inbagan Yahweh ay say Diyos ay dinaydayaw David ay apom: ‘Dinngek din kararag mo ya inilak din nan-og-ogaam, et agasak sik-a. Sin maikatlo ay agew manipod ed wani, emey ka sin Timplo. ");
INSERT INTO kne_vpl VALUES ("K220_6","013_20_6","2KI","20","6","6","Paandoek pay si sinpo ya lima ay tawen di biyag mo ya isalakan kos sik-a ya din siyodad ay nay sin panakabalin di ari ed Assyria. Salaknibak din siyodad ay nay ta say madayawak ya matongpal din inkarik en David ay bag-en ko.’” ");
INSERT INTO kne_vpl VALUES ("K220_7","013_20_7","2KI","20","7","7","Makdeng pay di, binilin Isaias din baa ay kakoyog di ari ta tapalan da si igos din boyoy na. Tinongpal da et naagasan. ");
INSERT INTO kne_vpl VALUES ("K220_8","013_20_8","2KI","20","8","8","Sin daan pay laeng maagasan, kanan Hezekias ay nandamag en Isaias, “Into ngin di pangammoak ay agasan Diyos sak-en et makaeyak sin Timplo sin maikatlo ay agew?” ");
INSERT INTO kne_vpl VALUES ("K220_9","013_20_9","2KI","20","9","9","Kanan Isaias, “Siya na di sinyal ay ipailan Diyos ay pangammoam ay tongpalena din inkari na: Piliem di laydem mo manballalong si sinpo ay paskitan din alidong sin pan-orasan ono mantikid si sinpo ay paskitan.” ");
INSERT INTO kne_vpl VALUES ("K220_10","013_20_10","2KI","20","10","10","Kanan Hezekias, “Baken nakaskasdaaw mo manballalong si sinpo ay paskitan, isonga laydek ay mantikid.” ");
INSERT INTO kne_vpl VALUES ("K220_11","013_20_11","2KI","20","11","11","Idi siya di, nankararag si Isaias et inpatikid Diyos din alidong si sinpo ay paskitan manipod sin gedeng na sin agdan ay in-amag Ari Ahaz. ");
INSERT INTO kne_vpl VALUES ("K220_12","013_20_12","2KI","20","12","12","Sin timpo ay doy, nadamag Merodak Baladan ay ari ed Babilonia ay anak Baladan ay nansakit ya nailatonan si Hezekias, isonga inbaa na di mangiey si solat ya sagot en sisya. ");
INSERT INTO kne_vpl VALUES ("K220_13","013_20_13","2KI","20","13","13","Sinangailin Hezekias din naibaa et inpaila na en daida din am-in ay indodolina ay kinabaknang ay siya da din palata ya balitok, nankinalasi ay bangbanglo ya nangina ay balsamo, din armas ya salida na, ya am-in di odom ay gameng na. Magay adi na inpaila en daida sin am-in ay kalasin di kinabaknang na ay wada sin palasyo ya ili ay panturayana. ");
INSERT INTO kne_vpl VALUES ("K220_14","013_20_14","2KI","20","14","14","Idi siya di, inmey din mamadto ay si Isaias en Hezekias yan kanana ay nandamag, “Intoy napoan dadi ay ipogaw, ya sinoy kanan da en sik-a?” “Napo da sin addawi ay ili ay Babilonia,” kanan Hezekias ay nanongbat. ");
INSERT INTO kne_vpl VALUES ("K220_15","013_20_15","2KI","20","15","15","“Yan sinoy inila da sin palasyom?” kanan Isaias. “Inila da am-in. Maga di kinabaknang ko ay adiak inpaila en daida,” insongbat Hezekias. ");
INSERT INTO kne_vpl VALUES ("K220_16","013_20_16","2KI","20","16","16","Pag kanan Isaias, “Siya na di ipaammon Diyos en sik-a: ");
INSERT INTO kne_vpl VALUES ("K220_17","013_20_17","2KI","20","17","17","‘Awni man et domteng di timpo ay maiey ed Babilonia am-in din wada sin palasyom pati am-in abe ay indodolin di aap-om engganad wani. Maga di mabay-an. ");
INSERT INTO kne_vpl VALUES ("K220_18","013_20_18","2KI","20","18","18","Di odom abe ay polim et maiey da ed Babilonia ta mansilbi da sin palasyon di ari.’” ");
INSERT INTO kne_vpl VALUES ("K220_19","013_20_19","2KI","20","19","19","Din pangawat Hezekias isnan inpadton Isaias et mayat ya natalna di kasasaad di panturayana engganas tongpal biyag na, isonga kanana, “Mayat di inpaibagan Diyos en sik-a.” ");
INSERT INTO kne_vpl VALUES ("K220_20","013_20_20","2KI","20","20","20","Am-in di odom ay inam-amag Hezekias ay kaman din toled na ay makigobat, din nangamagana si tangkin di danom ya din inosok na ay kanal di danom ay emey sin siyodad et naisolat da sin libro ay kaistoryaan di biyag di aari ed Juda. ");
INSERT INTO kne_vpl VALUES ("K220_21","013_20_21","2KI","20","21","21","Idi matey si Hezekias, din anak na ay si Manasses di naisokat ay nan-ari. ");
INSERT INTO kne_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Sinpo ya dowa di tawen Manasses sin naisaadana ay ari, et nanturay ed Jerusalem si limapolo ya lima ay tawen. Si Hefziba di ina na. ");
INSERT INTO kne_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","Lawa di inam-amag na sin pangilan Diyos, tan inon-onodana din kadodogis ya kalkaliget Diyos ay ogalin di nanasyon ay inpakaan Diyos sin daga ay sinakop din Israelita. ");
INSERT INTO kne_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Insaad na kasin din pandaydayawan sin dodontog ay dinadael Hezekias ay ama na. Wada abey inamag na ay altar ay pandaydayawan dan Baal ya sinabatana ay posti ay pangidaydayaw dan Asera ay kaman din inyat Ahab ay ari ed Israel. Nandokdokmog abe ay mandaydayaw sin katalatalaw. ");
INSERT INTO kne_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Waday insaad na ay aaltar ay pandaydayawan da si sinan didiyos sin oneg di Timplon Diyos sin lugar ay inbagan Diyos ay panbeeyana ya pandaydayawan di ipogaw en sisya. ");
INSERT INTO kne_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Sin dowa ay lugar sin bel-ayan di Timplo, nan-amag abe si aaltar ay pan-ipooan das insinso ay pangidaydayawan da sin katalatalaw. ");
INSERT INTO kne_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Peteg ay madagsen di basbasol na ay say binmongetan Diyos, tan indatona ay inpoo din mismo ay anak na. Manpontos, mankotom ya dowan aben manpasip-ok ya manpatolong si man-gengey. ");
INSERT INTO kne_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Isonga inpaibagan Diyos sin mamadto ay mansilsilbi en sisya, ");
INSERT INTO kne_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","“Peteg ay kadodogis di inam-amag Manasses ay ari ed Juda. Addawi ay lawlawa di basbasol na mo din taga-Canaan ed idi. Begew abe sin ad-ado ay sinan didiyos ay dinaydayaw na, inpango na din taga-Juda ay manbasol. ");
INSERT INTO kne_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","Isonga sak-en ay Yahweh ay Diyos di Israelita et waday kaeegyat ay pasamak ay ipadateng ko ed Jerusalem ya sin kailiili ed Juda ay kasngangan di mannge. ");
INSERT INTO kne_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Dosaek ed Jerusalem ay kaman met laeng din inyat ko en da Ari Ahab ed Israel ya din poli na. Maabosan ed Jerusalem si omili ay kaman palato ay ponasan da pag dan baliktaden. ");
INSERT INTO kne_vpl VALUES ("K221_14","013_21_14","2KI","21","14","14","Din ipogaw ay mabay-an et taynak daida ta dadlon abaken di kalaban da ya itagtag da am-in ay kinabaknang da. ");
INSERT INTO kne_vpl VALUES ("K221_15","013_21_15","2KI","21","15","15","Amagek dana sin ipogaw ko, tan lawa di inam-amag da sin pangilak ay mangipabonget en sak-en manipod sin kinmaanan di ap-apo da ed Egipto enggana ed wani.” ");
INSERT INTO kne_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Wao di tawen Josias sin naisaadana ay ari, et nanturay ed Jerusalem si tolonpo ya esa ay tawen. Say si ina na si Jedida ay anak Adayas ay taga-Bozkat. ");
INSERT INTO kne_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Kosto di inamag na sin pangilan Diyos, tan tinadtadona si David ay apo na et inpapasnek na ay nansilbi en Diyos ay adi nasangsangaw. ");
INSERT INTO kne_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Idi siya di, inpaayag Ari Josias am-in din papangolon di ipogaw ed Juda ya ed Jerusalem, ");
INSERT INTO kne_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","et nankokoyog da ay inmey sin Timplon Diyos. Nakiey abe din papadi ya mamadto ya am-in din man-ili ay nabibiteg ya siya abe din babaknang. Idi wada da ay mandengdenge, inbasa na am-in din naisolat sin Libron di Tolagan ay dinteng da sin Timplon Diyos. ");
INSERT INTO kne_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Pag en pomika sin kad-an di postin di Timplo et inkari na en Diyos ay patienas sisya ya imongsana din am-in ay nemnem na ay mangonod sin linlinteg ya bilbilina ta say matongpal din intolag Diyos ay naisolat sin libro ay doy. Et pag ikarin din kaipoipogaw ay tongpalen da abe din intolag Diyos. ");
INSERT INTO kne_vpl VALUES ("K223_21","013_23_21","2KI","23","21","21","Pag nan ibilin sin kaipoipogaw ay silibraran da din fiesta ay makwani en Nalabas ta say madayaw si Yahweh ay Diyos da ay kaman din naisolat sin Libron di Tolagan. ");
INSERT INTO kne_vpl VALUES ("K223_22","013_23_22","2KI","23","22","23","Naamag na ed Jerusalem sin maika-18 ay tawen ay nanturayan Ari Josias. Di inyat da ay nangsilibrar sin fiesta ay nay ay Nalabas et maga di kais-iso na sin timpon di olay sino ay ari ed Israel ya ed Juda manipod sin timpon di papangolo. ");
INSERT INTO kne_vpl VALUES ("K223_24","013_23_24","2KI","23","24","24","Wada pay di odom ay inamag Josias. Inpakaana ed Jerusalem ya sin kailiili ed Juda am-in ay manpontos ya mansip-ok, din sinan didiyos ya rebolto ay wada sin beey di ipogaw, ya olay sinoy odom ay inos-osal da ay kadodogis sin pangilan Diyos. Inamag na di ta say matongpal din bilbilin ay naisolat sin libro ay dinteng Hilkias ay kangatoan ay padi sin Timplon Diyos. ");
INSERT INTO kne_vpl VALUES ("K223_25","013_23_25","2KI","23","25","25","Magay makaiso en Josias sin aari ay namangpango ya naisokat en sisya ay nangimongsan sin am-in ay nemnem ya bikas na ay mansilbi en Diyos maibasar sin am-in ay naisolat sin linteg Moses. ");
INSERT INTO kne_vpl VALUES ("K223_26","013_23_26","2KI","23","26","26","Ngem adi nabaew din palalo ay bonget Diyos sin man-ili ed Juda begew sin lawa ay inam-amag Manasses. ");
INSERT INTO kne_vpl VALUES ("K223_27","013_23_27","2KI","23","27","27","Isonga kanan Diyos, “Ipakaan ko din taga-Juda sin sangoanak ay kaman din inyat ko sin taga-Israel. Dokogak abe din pinilik ay siyodad ay Jerusalem ya din Timplo ay nay ay inbagak en panbeeyak.” ");
INSERT INTO kne_vpl VALUES ("K223_28","013_23_28","2KI","23","28","28","Din odom ay inam-amag Josias et naisolat da sin libro ay kaistoryaan di biyag di aari ed Juda. ");
INSERT INTO kne_vpl VALUES ("K223_29","013_23_29","2KI","23","29","29","Idi ari pay laeng sisya, inpangon Ari Neco ed Egipto di ad-ado ay soldado ay en tomolong sin ari ed Assyria sin kad-an di ginawang ay Eufrates. Inmey da Josias ay en mangipasaldeng koma sin taga-Egipto, ngem idi nan-abat da ed Megiddo, pinse das sisya sin gobatan. ");
INSERT INTO kne_vpl VALUES ("K223_30","013_23_30","2KI","23","30","30","Inpalogan din kakoyog na din awak na si kalisa et insaa da ed Jerusalem, pag dan ipayag sin naiponponana ay sanikwa na. Et pag pilien din kaipoipogaw si Jehoahaz ay anak Josias ay maisokat en sisya, et sinoyatan dan toktok na si lana ay mangisaad en sisya ay ari. ");
INSERT INTO kne_vpl VALUES ("K223_36a","013_23_36a","2KI","23","36a","36a","Mantawen si Jehoyakim si dowanpo ya lima sin naisaadana ay ari, et nanturay ed Jerusalem si sinpo ya esa ay tawen. ");
INSERT INTO kne_vpl VALUES ("K223_37","013_23_37","2KI","23","37","37","Tinadona din inyat di ap-apo na ay nangam-amag si lawa sin pangilan Diyos. ");
INSERT INTO kne_vpl VALUES ("K224_1","013_24_1","2KI","24","1","1","Sin timpo ay nanturturayan Jehoyakim, ginobat Nebukadnezzar ay ari ed Babilonia din ili ay Juda. Kapilitan ay nanpaituray si Jehoyakim en sisya si tolo ay tawen, ngem idi makdeng di yan kinontra nas sisya. ");
INSERT INTO kne_vpl VALUES ("K224_2","013_24_2","2KI","24","2","2","Isonga nan-ibaa si Diyos si ad-ado ay bonggoy di tollisan ay taga-Babilonia, Syria, Moab ya Ammon ay mangobat en Jehoyakim ta dadaelen da ed Juda ay kaman din inpaibagan Diyos sin mamadto ay baa na. ");
INSERT INTO kne_vpl VALUES ("K224_3","013_24_3","2KI","24","3","3","Inbilin Diyos ay mapasamak dana sin ipogaw ed Juda ta mapakaan da sin sangoanana gapo sin amin ay basbasol Ari Manasses, ");
INSERT INTO kne_vpl VALUES ("K224_4","013_24_4","2KI","24","4","4","pati din namseana si ad-aad-ado ay ipogaw ay magay basol da. Gapo sin nangiyatanas di, sigaan Diyos ay mamakawan en sisya. ");
INSERT INTO kne_vpl VALUES ("K224_6","013_24_6","2KI","24","6","6","Idi natey si Jehoyakim, naisokat ay nan-ari si Jehoyakin ay anak na. ");
INSERT INTO kne_vpl VALUES ("K224_10","013_24_10","2KI","24","10","10","Sin doy ay timpo, ginobat din oopisyal Nebukadnezzar ed Jerusalem et nilikob da. ");
INSERT INTO kne_vpl VALUES ("K224_11","013_24_11","2KI","24","11","11","Idi madama ay liklikoben da din ili, inmey si Nebukadnezzar ay mismo ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("K224_12","013_24_12","2KI","24","12","12","Sin maikawao ay tawen ay nanturayan Nebukadnezzar, sinmoko en sisya si Jehoyakin, si ina na, din baa na, din papangolon di sosoldado na ya oopisyal na, et nanbalinenas daida ay balod. ");
INSERT INTO kne_vpl VALUES ("K224_13","013_24_13","2KI","24","13","13","Inan Nebukadnezzar amin ay gameng sin Timplon Diyos ya sin palasyo ya din amin ay bonag ay balitok ay inam-amag Ari Solomon para sin Timplon Diyos et tinmet-ewa amin din inbagan Diyos. ");
INSERT INTO kne_vpl VALUES ("K224_14","013_24_14","2KI","24","14","16","Intakina ay balod ed Babilonia amin ay ipogaw ed Jerusalem ay waday kowinta na: si Jehoyakin, si ina na, din aas-awa na, am-in ay oopisyal ya mabigbig ay ipogaw, am-in ay sosoldado ay pito ay libo di kabibilang da, ya sinlibo ay karpintiro, manpanday ya nankalalaing ay man-amag si kompormi. Danay ay sinlibo et kabaelan da am-in ay makigobat. Di kabibilang da amin ay naitakin ed Babilonia yan sinpo ay libo. Say nataynan anggoy din kabibitegan sin ili. ");
INSERT INTO kne_vpl VALUES ("K224_17","013_24_17","2KI","24","17","17","Insokat Nebukadnezzar si Mattanias ay pangamaen Jehoyakin ay say man-ari ed Juda yan nginadanana si Zedekias. ");
INSERT INTO kne_vpl VALUES ("K224_20","013_24_20","2KI","24","20","20","Am-in dana ay napasamak sin man-ili ed Jerusalem ya Juda, namnamed din nangipakaanan Diyos en daida sin sangoanana, et natongpal begew sin bonget Diyos en daida. ");
INSERT INTO kne_vpl VALUES ("K225_1","013_25_1","2KI","25","1","1","Sin pitsa 10 di maikasinpo ay bowan sin maikasiyam ay tawen ay nanturayan Zedekias, inmey si Nebukadnezzar ay ari ed Babilonia ya din amin ay sosoldado na ed Jerusalem. Nankampo da sin lasin di siyodad et nan-amag das somakyaban da sin nanniliked ta way iyat da ay manadael sin alad na. ");
INSERT INTO kne_vpl VALUES ("K225_2","013_25_2","2KI","25","2","2","Nilikob da din siyodad enggana sin maikasinpo ya esa ay tawen ay nanturayan Zedekias. ");
INSERT INTO kne_vpl VALUES ("K225_3","013_25_3","2KI","25","3","3","Sin pitsa 9 di maikap-at ay bowan, kinmaro din betil sin siyodad et enggay magay makan. ");
INSERT INTO kne_vpl VALUES ("K225_4","013_25_4","2KI","25","4","4","Sin agew ay doy, nilokawan din kalaban da din batog ay alad di siyodad. Idi nalabi, pag et lomayaw si Zedekias ya amin ay sosoldado na sin labi olay mo nililikob din taga-Babilonia si daida, tan nandan da sin liteb sin nan-gawaan di dowa ay batog sin asag-en di garden di ari et tinmagtag da ay nanturong sin tanap ed Jordan. ");
INSERT INTO kne_vpl VALUES ("K225_5","013_25_5","2KI","25","5","5","Ngem inapayaw din taga-Babilonia si daida et indasan da sin tanap ed Jerico. Nansiasian din sosoldadon Zedekias et tinaynan das sisya, ");
INSERT INTO kne_vpl VALUES ("K225_6","013_25_6","2KI","25","6","6","isonga dinpap din taga-Babilonia sisya et in-ey da en Nebukadnezzar ed Ribla et isdi ay kineddenganas sisya. ");
INSERT INTO kne_vpl VALUES ("K225_7","013_25_7","2KI","25","7","7","Pinse da din lallalaki ay an-ak na sin sangoanana pag dan boldingan sisya. Kinadinaan da si bronsi et in-ey da ed Babilonia. ");
INSERT INTO kne_vpl VALUES ("K225_8","013_25_8","2KI","25","8","8","Sin pitsa 7 di maikalima ay bowan, sin maika-19 ay tawen ay nanturayan Ari Nebukadnezzar ed Babilonia, inmey ed Jerusalem si Nebuzaradan ay komander di gowardiyan di ari. ");
INSERT INTO kne_vpl VALUES ("K225_9","013_25_9","2KI","25","9","9","Pinooana din Timplon Diyos, din palasyo ya amin ay importanti ay bebbeey isdi. ");
INSERT INTO kne_vpl VALUES ("K225_10","013_25_10","2KI","25","10","10","Binakas abe din sosoldado na din alad di siyodad. ");
INSERT INTO kne_vpl VALUES ("K225_11","013_25_11","2KI","25","11","11","Inpakaan Nebuzaradan ed Babilonia din amin ay ipogaw ay nataynan sin siyodad, din nanaynan sin kakailian da ta maitapi da sin taga-Babilonia, ya din man-ili abe sin away di siyodad. ");
INSERT INTO kne_vpl VALUES ("K225_12","013_25_12","2KI","25","12","12","Ngem binay-ana din kabibitegan ta daida di man-obla sin kaobasan ya papayew. ");
INSERT INTO kne_vpl VALUES ("K225_21b","013_25_21b","2KI","25","21b","21b","Siya di din kaistoryaan di nanbalinan di taga-Juda ay balod sin addawi ay ili. ");
INSERT INTO kne_vpl VALUES ("R115_1","014_15_1","1CH","15","1","1","Inpaamag Ari David di bebbeey sin Siyodad David para en daida ay sinpamilya. Pag aben mansagana si pantean din Baol di Tolagan Diyos et in-amag na di tolda ay kaidolinana. ");
INSERT INTO kne_vpl VALUES ("R115_2","014_15_2","1CH","15","2","2","Pag nan kanan, “Din Levita et anggoy di mabalin ay manggen sin Baol di Tolagan, tan daida di pinilin Diyos ay manggen ya mansilbi en sisya si eng-enggana.” ");
INSERT INTO kne_vpl VALUES ("R115_3","014_15_3","1CH","15","3","3","Pag ipasinop David ed Jerusalem din am-in ay Israelita ta iey da din Baol di Tolagan sin insagana na ay kaipay-ana. ");
INSERT INTO kne_vpl VALUES ("R115_4","014_15_4","1CH","15","4","4","Inpaayag na abe din polin da Aaron en Levi ta masinop da. ");
INSERT INTO kne_vpl VALUES ("R115_11","014_15_11","1CH","15","11","11","Pag nan ayagan da Zadok en Abiatar ay papadi ya da Uriel, Asayas, Joel, Semayas, Eliel ya si Amminadab ay Levita. ");
INSERT INTO kne_vpl VALUES ("R115_12","014_15_12","1CH","15","12","12","Kanana en daida, “Dakayo met di papangolon di papamilya sin tribun Levi. Dakayo ya din iib-a yo ay Levita, amagen yo din masapol ay tongpalen yo ta say maibilang kayo ay nalinis, ta asi kayo iali din Baol di Tolagan Yahweh ay Diyos di Israelita isnan lugar ay insaganak ay kaipay-ana. ");
INSERT INTO kne_vpl VALUES ("R115_13","014_15_13","1CH","15","13","13","Tan din gapo ay dinosan Diyos dakami sin damo ay nangialian mi koma sin Baol et maga kayos di ay nanggen, et adi mi tinongpal din kosto ay maonodan ay iyat na ay maegnan.” ");
INSERT INTO kne_vpl VALUES ("R115_14","014_15_14","1CH","15","14","14","Siya di, tinongpal din papadi ya Levita din maonodan ta maibilang da ay nalinis ta say mabalin ay it-an da din Baol di Tolagan. ");
INSERT INTO kne_vpl VALUES ("R115_15","014_15_15","1CH","15","15","15","Pag batawilen din Levita, tan say inbilin Diyos en Moses ay iyat na ay masakbat. ");
INSERT INTO kne_vpl VALUES ("R115_16","014_15_16","1CH","15","16","16","Binilin aben David din papangolon di Levita ta mandotok da sin odom ay iib-a da si mankanta ya mantokar si kalalayad ay tokar sin arpa, gitara ya gangsa. ");
INSERT INTO kne_vpl VALUES ("R116_1","014_16_1","1CH","16","1","1","Inisgep da din Baol di Tolagan sin tolda ay insaganan David ay kaipey-ana. Pag dan man-idaton si daton ay mapooan ya daton ay pan-ookoban da ya makikadkadwaan da en Diyos. ");
INSERT INTO kne_vpl VALUES ("R116_2","014_16_2","1CH","16","2","2","Idi makdeng di, inosal David din ngadan Diyos ay namindisyon sin kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("R122_1","014_22_1","1CH","22","1","1","Kanan Ari David, “Isnan to di kaisaadan di Timplon Diyos et isna di altar ay pan-idatonan di Israelita sin daton ay mapooan.” ");
INSERT INTO kne_vpl VALUES ("R122_2","014_22_2","1CH","22","2","2","Inbilin David ay masinop din mangili ay nakiili ed Israel, et wada di dinotokana en daida ay mantiktik si bato ay maisagana para sin maamag ay Timplo. ");
INSERT INTO kne_vpl VALUES ("R122_3","014_22_3","1CH","22","3","3","Nan-idawat abe si ad-ado ay landok ay maamag si lansa ay para sin liteb ya pandakig. Ad-ado abe di indawat na ay bronsi ay adi kabilang di kilo na. ");
INSERT INTO kne_vpl VALUES ("R122_4","014_22_4","1CH","22","4","4","Nan-isagana abe si adi kabilang ay troso ay din kanan da en sidro, tan ad-ado di in-ey din taga-Sidon ya taga-Tiro en David. ");
INSERT INTO kne_vpl VALUES ("R122_5","014_22_5","1CH","22","5","5","Tan kanan David, “Si Solomon ay anak ko yan an-anak pay laeng ay maga di padas na yan masapol ay magay ison di kamapteng na ay mandinamag isnan lobong din amagena ay beey Diyos, isonga masapol ay isaganak din masapol.” Et siya di, insaganan David din ad-ado ay masapol para sin kaamagan di Timplo sakbay ay matey sisya. ");
INSERT INTO kne_vpl VALUES ("R122_6","014_22_6","1CH","22","6","6","Pag nan ipaayag din anak na ay si Solomon et inbilina ay man-amag si timplo para en Diyos. ");
INSERT INTO kne_vpl VALUES ("R129_1","014_29_1","1CH","29","1","1","Kanan Ari David sin intiro ay gimong, “Din anak ko ay si Solomon et anggoy na si pinilin Diyos, ngem an-anak pay laeng ya maga di padpadas na. Ngem din maamag yan dakdake ay obla, tan baken palasyo ay panbeeyan di ipogaw mo adi et timplo ay para en Diyos. ");
INSERT INTO kne_vpl VALUES ("R129_2","014_29_2","1CH","29","2","2","Inpakat ko di am-in ay kabaelak ay nangisagana sin maiamag sin Timplon Diyos ay daydayawek–balitok, palata, bronsi, landok, kaiw ya nankinalasi ay nankababanol ay bato. ");
INSERT INTO kne_vpl VALUES ("R129_3","014_29_3","1CH","29","3","3","Maitapi sin danay ay insaganak, man-idawatak pay ed wani si balitok ya palata ay mapo sin kabokbokodak ay gameng gapo sin layad ko sin Timplon Diyos ay daydayawek. ");
INSERT INTO kne_vpl VALUES ("R129_4","014_29_4","1CH","29","4","4","Man-idawatak si tolo ay libo ay talento ay kanginaan ay balitok ya pito ay libo ay talento ay natanig ay palata ay maipakpak sin dingding di Timplo ");
INSERT INTO kne_vpl VALUES ("R129_5","014_29_5","1CH","29","5","5","ya para sin am-in ay maamag ay pakasapolan si palata ya balitok. Ed wani, sino da di malaydan ay man-idawat si sagot ay mansilbi en Diyos?” ");
INSERT INTO kne_vpl VALUES ("R129_6","014_29_6","1CH","29","6","6","Idi siya di, nanbolontaryo da ay nan-idawat din papangolon di pamilya, din oopisyal di tribu, din kakapitan di soldado ya din manbanbantay si sanikwan di ari. ");
INSERT INTO kne_vpl VALUES ("R129_7","014_29_7","1CH","29","7","7","Danay di indawdawat da para sin maisaad ay Timplo: lima ay libo ay talento ya 84 ay kilo ay balitok, sinpo ay libo ay talento ay palata, sinpo ya wao ay libo ay talento ay bronsi ya sin-gasot ay libo ay talento ay landok. ");
INSERT INTO kne_vpl VALUES ("R129_8","014_29_8","1CH","29","8","8","Am-in ay wadaan si nankababanol ay bato yan nan-idawat da sin pan-idoldolinan si pilak di Timplo ay ay-ayowanan Jehiel ay polin Gerson. ");
INSERT INTO kne_vpl VALUES ("R129_9","014_29_9","1CH","29","9","9","Et naragsakan din kaipoipogaw tan naimposoan ya silalayad di inyat da ay nan-idawat para en Diyos. Olay aben si Ari David et palalo di ragsak na. ");
INSERT INTO kne_vpl VALUES ("R129_10","014_29_10","1CH","29","10","10","Pag kanan David ay nangidaydayaw en Diyos sin sangoanan di gimong, “Sik-a ay Yahweh ay Diyos ay dinaydayaw Jacob ay apo mi, sapay koma ta madayaw ka si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("R129_11","014_29_11","1CH","29","11","11","Wadan sik-a di banol ya panakabalin, kinadiyos ya kinangato, mankoniniing ka ay magay makaiso. Tan okam am-in ay wada ed langit ya isnan daga ya sik-a din ari, sik-a din kangatoan ay turay. ");
INSERT INTO kne_vpl VALUES ("R129_12","014_29_12","1CH","29","12","12","Dayaw ya kinabaknang, sik-ay napoana, sik-ay mangituray sin am-in ay wada. Wadan sik-a di turay ya panakabalin ay mangipangato ya mangipapigsa sin am-in. ");
INSERT INTO kne_vpl VALUES ("R129_13","014_29_13","1CH","29","13","13","Man-iyaman kamin sik-a ay Diyos ed wani. San madaydayaw ay ngadan mo di idaydayaw mi.” ");
INSERT INTO kne_vpl VALUES ("R129_26","014_29_26","1CH","29","26","26","Inturayan David ay anak Jesse din intiro ay Israel ");
INSERT INTO kne_vpl VALUES ("R129_27","014_29_27","1CH","29","27","27","si opatapolo ay tawen. Pito ay tawen di nanteanad Hebron yan tolonpo ya tolo ay tawen sin inmeyana ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("R129_28","014_29_28","1CH","29","28","28","Enggay nakay si David asi matey, et ginanas na di ando ay biyag, dayaw ya kinabaknang. Si Solomon ay anak na di naiskat en sisya ay nan-ari. ");
INSERT INTO kne_vpl VALUES ("R229_12","015_29_12","2CH","29","12","12","Da nay din Levita ay wadas di: sin polin Coat, da Mahat ay anak Amasai en Joel ay anak Azarias; sin polin Merari, da Kis ay anak Abdi en Azarias ay anak Jehallelel; sin polin Gerson, da Joa ay anak Zimna en Eden ay anak Joa; ");
INSERT INTO kne_vpl VALUES ("R229_13","015_29_13","2CH","29","13","13","da Simri en Jeuel sin polin Elizafan yan da Zekarias en Mattanias sin polin Asaf; ");
INSERT INTO kne_vpl VALUES ("R229_14","015_29_14","2CH","29","14","14","sin polin Heman, da Jehuel en Simei yan da Semayas en Uzziel sin polin Jedutun. ");
INSERT INTO kne_vpl VALUES ("R229_15","015_29_15","2CH","29","15","15","Sininop da din aag-i da ay Levita et inamag da din seremonia ay panglinis da. Idi nakdeng di, inamag da abe din seremonia ay panglinis sin Timplo ay kaman din naibaga sin linteg Diyos ay inbilin di ari ay amagen da. ");
INSERT INTO kne_vpl VALUES ("R229_16","015_29_16","2CH","29","16","16","Sinenggep din papadi sin oneg di Timplo ta amagen da din seremonia ay panglinis. Inbala da am-in ay baken nalinis et in-ey da sin bel-ayan di Timplo. Inbalan din Levita dana ay bonbonag et in-ey da sin alnap ay Kidron. ");
INSERT INTO kne_vpl VALUES ("R229_17","015_29_17","2CH","29","17","17","Inlogi da nan seremonia ay panglinis sin pitsa uno, sin damo ay bowan. Idi domteng sin maikawao ay agew di bowan, kindeng da enggana sin damo ay kowarto ay segpan sin Timplo. Nan-obla da pay si wao ay agew et sinpo ya enem ay agew di nan-oblaan da ay nangisagana sin Timplo ay pandayawan. ");
INSERT INTO kne_vpl VALUES ("R229_18","015_29_18","2CH","29","18","18","Siya na di inpaammon din papadi en Ari Hezekias, “Enggay kindeng mi din kalinisan di intiro ay Timplo, din altar ay pan-idatdatonan si mapooan ya din am-in ay maos-osal isdi ya din lamisaan ay kaipatpatangan di maidaton ay tinapay ya din am-in ay maos-osal isdi. ");
INSERT INTO kne_vpl VALUES ("R229_19","015_29_19","2CH","29","19","19","Intaoli mi am-in din bonag ay inbalan Ari Ahaz sin timpo ay nanokogana en Diyos et nilinisan mi ya insagana mi ta maosal para en Diyos. Wada da ed wani sin sangoanan di altar Diyos.” ");
INSERT INTO kne_vpl VALUES ("R236_11","015_36_11","2CH","36","11","11","Dowanpo ya esa di tawen Zedekias sin naisaadana ay ari yan nanturay ed Jerusalem si sinpo ya esa ay tawen. ");
INSERT INTO kne_vpl VALUES ("R236_12","015_36_12","2CH","36","12","12","Say inamag na din lawa sin pangilan Yahweh ay Diyos na yan adi nanpakombaba en Jeremias ay nankalkalian Diyos. ");
INSERT INTO kne_vpl VALUES ("R236_13","015_36_13","2CH","36","13","13","Kinontra na abe si Ari Nebukadnezzar ay nangipasapata en sisya sin ngadan Diyos en adi komonkontra. Inpakenteg na di nemnem na et sinigaana ay manbabawi ya managong en Yahweh ay Diyos di Israelita. ");
INSERT INTO kne_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Naisepsep abe din am-in ay papangolon di padi ya din kaipoipogaw ay nanokog en Diyos et in-onod da din am-in ay kadodogis ya kababain ay am-amagen di odom ay nasyon et inpakadodogis da din Timplo ed Jerusalem ay nanbalinen Diyos ay mismo ay nasantoan. ");
INSERT INTO kne_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Intoltoloy Yahweh ay Diyos di ap-apo da ay mamagbaga en daida babaen sin pinilpili na ay ipogaw ay nankalkaliana, tan maseg-ang sin ipogaw na et laydena ay isalakan daida ya din Timplo na. ");
INSERT INTO kne_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","Ngem nilaslasoy da din inbabbaan Diyos ay nankalkaliana ya din kali na enggana ay binmonget sisya sin ipogaw na et enggay maga di pamosposan. ");
INSERT INTO kne_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Say gapo ay inbaa na din ari ed Babilonia ay namse sin babbaro ya babalasang, nankakay ya nankababkes, olay sin Timplo. Inpolang Diyos daida am-in en Nebukadnezzar. ");
INSERT INTO kne_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Ina na am-in ay bonag sin Timplon Diyos, dadakke ono kinittoy ya am-in ay kinabaknang ay wadas di. Ina na abe din kinabaknang di ari ya din oopisyal na et in-ey na am-in ed Babilonia. ");
INSERT INTO kne_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Pinooan da din Timplon Diyos ya dinadael da din alad di Jerusalem. Pinooan da am-in din palasyo yan dinadael da am-in ay nabanol ay bonag isdi. ");
INSERT INTO kne_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Din adi da pinse si kampilan yan intakina ed Babilonia et nanbalinena ay bag-ena ya bag-en din aan-ak na enggana ay say naisokat ay nanturay din ari ed Persia. ");
INSERT INTO kne_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","Et say natongpalan din inpaipadton Diyos en Jeremias ay kanana en mataynan ya manbalin si magay silbi na din daga da si pitopolo ay tawen ay kaman din bilang di adi dan nanongpalan sin linteg di agew ay pan-illengan. ");
INSERT INTO kne_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Sin damo ay tawen ay nanturayan Cyrus ay ari ed Persia, natongpal din inpaipadton Diyos en Jeremias, tan tinignay Diyos din ari et waday inpaisolat na ay bilin ay naipaammo sin intiro ay iturayana. ");
INSERT INTO kne_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","Siya na di naisolat, “Siya na di bilin Cyrus ay ari ed Persia: Insaad Yahweh ay Diyos ed langit si sak-en ay mangituray isnan intiro ay daga yan dinotokanas sak-en ay mangamag si Timplo ay pandayawan di ipogaw en sisya ed Jerusalem ay lak-am di Juda. Ed wani, emey kayo ay ipogaw Diyos ed Jerusalem. Sapay koma ta si Diyos di komoyog en dakayo.” ");
INSERT INTO kne_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","1","Sin damo ay tawen ay nanturayan Cyrus ay ari ed Persia, inturong Diyos di nemnem na ay mangipaammo si esa ay bilin ta matongpal din inpaibagan Diyos en Jeremias. Siya na di inpaisolat din ari ay maibasa sin intiro ay iturayana: ");
INSERT INTO kne_vpl VALUES ("ER1_2","016_1_2","EZR","1","2","2","“Siya na di ibilin ko, sak-en si Cyrus ay ari ed Persia: Si Yahweh ay Diyos ed langit di nangisaad en sak-en ay mangituray isnan intiro ay lobong yan dinotokanas sak-en ay man-amag si timplo na ed Jerusalem ay sakop di Juda. ");
INSERT INTO kne_vpl VALUES ("ER1_3","016_1_3","EZR","1","3","3","Si Diyos koma di wada en dakayo ay ipogaw na. Emey kayo ed Jerusalem ta amagen yo din Timplon Yahweh ay Diyos di Israelita, din Diyos ay wada ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","Din katokmang di nabay-an ay ipogaw Diyos sin kailiili ay kad-an da ed wani yan masapol ay man-idawat da si palata, balitok, din odom ay kasapolan da ya aanimal malaksig sin bolontaryo ay datdaton para sin Timplon Diyos ed Jerusalem.” ");
INSERT INTO kne_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Idi siya di, am-in di ipogaw ay inturong Diyos di nemnem na, pati din papangolo sin papamilyan di tribun da Juda en Benjamin, din papadi ya Levita et nanlobwat da ay en mangamag sin Timplon Diyos ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Nan-idawat amin din tinokmang da si tolong da ay palata, balitok, nabanol ay rigalo, aanimal ya odom ay kasapolan da, malaksig sin rigalo ay maidaton sin Timplo. ");
INSERT INTO kne_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","Dowan aben itaolin Ari Cyrus din mallokong ya odom ay bonbonag ay sigod ay naosal sin Timplon Diyos ay inan Nebukadnezzar ay inpeey na sin timplon di sinan didiyos ay dinaydayaw na. ");
INSERT INTO kne_vpl VALUES ("ER2_1","016_2_1","EZR","2","1","1","Ad-ado di napo sin probinsiya ay pilit ay in-ey Ari Nebukadnezzar ed Babilonia ed idi. Nantaoli da sin mismo ay ili da ed Jerusalem ya Juda ");
INSERT INTO kne_vpl VALUES ("ER2_2a","016_2_2a","EZR","2","2a","2a","ay kinoyog da Zerubbabel en Jesua ay papangolo da. ");
INSERT INTO kne_vpl VALUES ("ER2_68","016_2_68","EZR","2","68","68","Idi dinmateng da sin kad-an di Timplon Diyos ed idi ed Jerusalem, waday datdaton ay insagot di odom ay papangolon di pamilya ta say itolong da sin kasin kaamagan di Timplo sin sigod ay naisaadana. ");
INSERT INTO kne_vpl VALUES ("ER2_69","016_2_69","EZR","2","69","69","Nan-idawat da insigon sin kabaelan da et naipeey sin naidolinan di pilak para sin Timplo. Din indawat da et 500 ay kilo ay balitok, 2,800 ay kilo ay palata ya 100 ay naloyong ay badon di padi. ");
INSERT INTO kne_vpl VALUES ("ER2_70","016_2_70","EZR","2","70","70","Pag en manbeey din papadi, Levita, mankankanta, gogowardiya ya odom ay mansilsilbi sin Timplo sin il-ili da. Din nabay-an ay Israelita et en da aben manbeey sin il-ili da. ");
INSERT INTO kne_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Sin maikapito ay bowan, nan-es-esa din Israelita ay natopog ed Jerusalem ay napo sin il-ili ay enggay nanbeeyan da. ");
INSERT INTO kne_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Si Jesua ay anak Jozadak ya din gagait na ay papadi ya si Zerubbabel ay anak Sealtiel ya din aag-i na et inamag da din altar Diyos ay daydayawen di Israelita ta pangipooan da si datdaton insigon sin naisolat sin linteg Moses ay ipogaw Diyos. ");
INSERT INTO kne_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Olay mo emegyat da sin baken Judio ay nanbeey isdi ay daga, inamag da pay dedan din altar sin sigod ay naiamagana ed idi. Idi makdeng, inagsapa ya minasdem ay nan-idaton da si daton ay mapooan. ");
INSERT INTO kne_vpl VALUES ("ER3_6","016_3_6","EZR","3","6","6","Nilogian da ay man-idaton en Diyos si daton ay mapooan sin pitsa uno di maikapito ay bowan olay mo adi pay laeng nalogian ay maisaad din Timplo. ");
INSERT INTO kne_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Idi siya di, nan-idawat din ipogaw si pilak ay mailagbo sin karpintiro ya odom ay oblantis. Nan-idawat da abe si makan, mainom ya lanan di olivo ta isokat da sin taga-Sidon ya Tiro si nabanglo ay kaiw ay makwani en sidro ay mapod Lebanon. Ianod da sin baybay enggana ed Joppa tan say inpalobos Cyrus ay ari ed Persia. ");
INSERT INTO kne_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Sin maikadwa ay bowan di maikadwa ay tawen manipod sin dinmatngan da ed Jerusalem sin sigod ay naisaadan di Timplon Diyos, da Zerubbabel ay anak Sealtiel, Jesua ay anak Jozadak ya din aag-i da ay papadi ya Levita yan nilogian da ay nan-obla. Nakiobla amin din kakailian da ay naibalod ed Babilonia ay nantaoli ed Jerusalem. Dinotokan da din Levita ay mantawen si dowanpo ya nasurok ay mangimandar sin kaisaadan di Timplon Diyos. ");
INSERT INTO kne_vpl VALUES ("ER4_1","016_4_1","EZR","4","1","1","Idi damagen din mangililiget si taga-Juda ya Benjamin ay am-amagen din nantaoli ay naibalod ay Israelita din Timplon Yahweh ay Diyos di Israelita, ");
INSERT INTO kne_vpl VALUES ("ER4_2","016_4_2","EZR","4","2","2","inmey da en Zerubbabel ya din papangolon di pamilya yan kanan da, “Tolongan mis dakayo ay mangamag sin Timplo, tan mandaydayaw kami abe en Diyos ay daydayawen yo et nan-idatdaton kami en sisya manipod sin timpon Esarhaddon ay ari ed Assyria ay nangibaa en dakami isna.” ");
INSERT INTO kne_vpl VALUES ("ER4_3","016_4_3","EZR","4","3","3","Ngem kanan da Zerubbabel, Jesua ya din papangolon di pamilya, “Adi kayon makibiyang sin kaamagan di Timplon di Diyos mi. Inbilin Ari Cyrus ay ari ed Persia ay dakami anggoy di mangamag.” ");
INSERT INTO kne_vpl VALUES ("ER4_4","016_4_4","EZR","4","4","4","Idi siya di, nilogian din man-ilis di ay daga ay dismayaen ya egyaten din taga-Juda ta adi dan itoloy ay amagen din Timplo. ");
INSERT INTO kne_vpl VALUES ("ER4_5","016_4_5","EZR","4","5","5","Dowan da et pasoksokan din oopisyal ed Persia ta matopap din plano da. Say inam-amag da di manipod sin nanturayan Cyrus enggana sin timpon Darius ay ari ed Persia. ");
INSERT INTO kne_vpl VALUES ("ER4_24","016_4_24","EZR","4","24","24","Sinmaldeng din obla sin maisasaad ay Timplon Diyos enggana sin maikadwa ay tawen ay nanturayan Darius ay ari ed Persia. ");
INSERT INTO kne_vpl VALUES ("ER5_1","016_5_1","EZR","5","1","1","Sin timpo ay doy, waday dowa ay mamadto ay da Zekarias ay polin Iddo en Haggai. Nan-ipadto da ay namagbaga sin taga-Juda ya Jerusalem babaen sin panakabalin Diyos ay daydayawen di Israelita, ay mangidaldalan en daida. ");
INSERT INTO kne_vpl VALUES ("ER5_2","016_5_2","EZR","5","2","2","Idi siya di, intoloy kasin da Zerubbabel ay anak Sealtiel ya si Jesua ay anak Jozadak ay mangamag sin Timplon Diyos ed Jerusalem, et tinolongan din mamadto si daida. ");
INSERT INTO kne_vpl VALUES ("ER5_3","016_5_3","EZR","5","3","3","Asi et inmey da Tattenai ay gobernador di probinsiya ay makwani en Demang di Eufrates, en Setar Bozenai ya din iib-a da ay opisyal ed Jerusalem yan kanan da ay nanpoot, “Sinoy nangidawat si kalebbengan yo ay mangisaad sin Timplo ay sana ya mangisagana sin am-in ay maosal sidi? ");
INSERT INTO kne_vpl VALUES ("ER5_4","016_5_4","EZR","5","4","4","Sino abe di ngadngadan di ipogaw ay mangam-amag?” ");
INSERT INTO kne_vpl VALUES ("ER5_5","016_5_5","EZR","5","5","5","Ngem laton ay wadas Diyos ay mangil-ila sin papangolon di Judio, et ninemnem din oopisyal ay adi da ipasaldeng din Judio enggana ay mansolat da en Darius ya awaten day songbat na. ");
INSERT INTO kne_vpl VALUES ("ER6_13","016_6_13","EZR","6","13","13","Idi inawat da Gobernador Tattenai en Setar Bozenai ya din iib-a da ay opisyal din bilin Ari Darius, inset da ay nanongpal. ");
INSERT INTO kne_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Et paspas din inyat di papangolon di Judio ay nangamag sin Timplo, tan napapigsa di nemnem da begew sin inkaskasaban din pankalkalian Diyos ay da Haggai en Zekarias. Kindeng da din Timplo ay kaman din inbilin Diyos ay daydayawen di Israelita ya inbilin aben da Cyrus, Darius ya Artaxerxes ay aari ed Persia. ");
INSERT INTO kne_vpl VALUES ("ER6_15","016_6_15","EZR","6","15","15","Nakdeng sin pitsa 3 di bowan ay kanan da en Adar, sin maikan-em ay tawen ay nanturayan Ari Darius. ");
INSERT INTO kne_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Pag dan idaton. Naragsakan din papadi, Levita ya amin din iib-a da ay Israelita ay nantaoli ay naibalod ed addawi, ");
INSERT INTO kne_vpl VALUES ("ER6_17","016_6_17","EZR","6","17","17","et nan-idaton da si 100 ay bomaro ay baka, 200 ay kalakian ay karnero ya 400 ay bomaro ay karnero. Nan-idaton da abe si sinpo ya dowa ay bomaro ay kalding ta say malinisan din basbasol di am-in ay Israelita, sag-eesa para sin tonggal tribu. ");
INSERT INTO kne_vpl VALUES ("ER6_18","016_6_18","EZR","6","18","18","In-olnos da abe din papadi ya Levita sin grupo da insigon sin naisolat sin libron Moses ta say naolnos di iyat da ay mansilbi en Diyos ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("ER6_19","016_6_19","EZR","6","19","19","Sin pitsa 14 di damo ay bowan, sinilibraran din nantaoli ay Israelita din fiesta ay makwani en Nalabas. ");
INSERT INTO kne_vpl VALUES ("ER6_20","016_6_20","EZR","6","20","20","Inamag din papadi ya Levita din seremonia ay kaibilangan da ay nalinis maibasar sin linteg da et nalinisan da, isonga pinaltin din Levita din karnero ay maidaton sin fiesta ay makwani en Nalabas para sin nantaoli ay Israelita, para sin gait da ay papadi ya para sin mismo ay awak da. ");
INSERT INTO kne_vpl VALUES ("ER6_21","016_6_21","EZR","6","21","21","Et nangan da din nantaoli ay Israelita ya din amin ay nanokog sin ogalin di pagano ay tinokmang da ta sagongen das Yahweh ay Diyos di Israelita. ");
INSERT INTO kne_vpl VALUES ("ER6_22","016_6_22","EZR","6","22","22","Pito ay agew ay nanragragsak da ay nangsilibrar si fiesta ay makwani en Tinapay ay Magay Labadura na. Nalaydan da tan inturong Diyos din nemnem di ari ed Persia ay tomolong en daida sin naamagan di Timplon Diyos ay daydayawen di Israelita. ");
INSERT INTO kne_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","1","Siya na di inistoryan Nehemias ay anak Hacalias. Sin bowan di Kislev, sin maikadowanpo ay tawen ay nanturayan Artaxerxes ay ari ed Persia, wadaak ed Susa ay kapital di ili. ");
INSERT INTO kne_vpl VALUES ("NH1_2","017_1_2","NEH","1","2","2","Inmali si Hanani ay esa ay agik ay napod Juda yan waday kakoyog na ay odom ay lallalaki. Nandamagak en daida maipanggep sin Judio ay napilit ay naiey ed addawi ay nantaoli ya maipanggep ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","Kanan da ay sinombat, “Dakdake di probliman din kaipoipogaw ay nantaoli ed Juda dowan laslasoyen din ipogaw ay wadas di si daida. Tan nadadael pay laeng din alad ed Jerusalem ya adi naamag din eeneb na nanipod sin napooan da.” ");
INSERT INTO kne_vpl VALUES ("NH1_4","017_1_4","NEH","1","4","4","Sin nanngeak isna, tinmokdoak ay man-og-oga. Nanladingitak ya initpek din dagaang ko si piga ay agew dowanak mankararag en Diyos ed langit. ");
INSERT INTO kne_vpl VALUES ("NH1_5","017_1_5","NEH","1","5","5","Kanak ay nankararag, “Yahweh ay Diyos ed daya, madaydayaw ya kaeegyat ay Diyos. Managtongpal ka sin intolag mo ya adi manbalbaliw din layad mo sin manlaylayad en sik-a ya mantongpal sin bilbilin mo. ");
INSERT INTO kne_vpl VALUES ("NH1_6","017_1_6","NEH","1","6","6","Sapay koma ta ilaem ya dengngem sak-en ay baam sin ikarkararag kos inag-agew ya nilablabi maipanggep sin mansilsilbi en sik-a ay din ipogaw mo ay Israelita. Nanbasol kami kayman ay Israelita, nanbasolak ya siya abe sin pamilyak. ");
INSERT INTO kne_vpl VALUES ("NH1_7","017_1_7","NEH","1","7","7","Nadagsen di nanbasolan mi en sik-a ya adi kamin tinongtongpal din bilbilin ya linteg mo ay inbilin mo en Moses ay baam. ");
INSERT INTO kne_vpl VALUES ("NH1_8","017_1_8","NEH","1","8","8","Nemnemem koma din nay ay inbagam en Moses, ‘Mo adi yon itoltoloy ay mantalek en sak-en, ipaaddawik dakayo ta mantee kayo sin odom ay il-ili. ");
INSERT INTO kne_vpl VALUES ("NH1_9","017_1_9","NEH","1","9","9","Ngem no sagongen yo si sak-en ya tongpalen yo din bilbilin ko, itaolik dakayo sin lugar ay pinilik ay pandayawan yo en sak-en, olay naiwaras kayo sin kaaddawian ay partin di lobong.’ ");
INSERT INTO kne_vpl VALUES ("NH1_10","017_1_10","NEH","1","10","10","“Apo Diyos, danay din mansilsilbi en sik-a ya ipogaw mo ay insalakan mo babaen sin nakaskasdaaw ay panakabalin mo. ");
INSERT INTO kne_vpl VALUES ("NH1_11","017_1_11","NEH","1","11","11","Dengngem kod nan kararag ko ay baam ya kararag di iib-ak ay mansilsilbi en sik-a ay malaydan ay mangidayaw en sik-a. Iturong mo koma din nemnem di ari ta say mayat di pantongpalan di amagek ed wani ay agew ta maseg-ang en sak-en.” Sin doy ay timpo yan sak-en di ap-apon di man-itagtagay si arak sin ari. ");
INSERT INTO kne_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","1","Idi inmey di opat ay bowan, waday namingsan ay mangmangan din ari yan inpailak ay masmasadotak sin nangitagayak en sisya si arak. Maga polos di nangilaana ay masmasadotak ed idi, ");
INSERT INTO kne_vpl VALUES ("NH2_2","017_2_2","NEH","2","2","2","isonga kanana ay nanpoot en sak-en, “Apay nga masmasadot ka yan baken ka met mansakit? Siguro ay wada di panladladingitam.” Palalo di egyat ko, ");
INSERT INTO kne_vpl VALUES ("NH2_3","017_2_3","NEH","2","3","3","ngem kanak sin ari, “Apo Ari, matagotago ka koma si eng-enggana! Adiak maitabon din ladingit ko gapo ta din siyodad ay naiponponan di ap-apok yan enggay nadadael ya napooan din eneb na.” ");
INSERT INTO kne_vpl VALUES ("NH2_4","017_2_4","NEH","2","4","4","Kanan din ari en sak-en, “Sino ngarud di laydem?” Nankararagak en Diyos ed langit, ");
INSERT INTO kne_vpl VALUES ("NH2_5","017_2_5","NEH","2","5","5","pagak kanan sin ari, “Mo say laydem ay apo ari ya maseg-ang ka en sak-en ay baam, ipakpakaasik ay ipalobos mo koma ay emeyak sin siyodad sin sakop di Juda ay naiponponan di ap-apok ta enak amagen kasin.” ");
INSERT INTO kne_vpl VALUES ("NH2_6","017_2_6","NEH","2","6","6","Sin nangwaniak sidi, wada din reyna ay nakitotokdo sin ari. Dinamag din ari mo kas-ano di kabayag ko sin emeyak ya mo pig-an di pantaoliak et idi inbagak, pinalobosanas sak-en. ");
INSERT INTO kne_vpl VALUES ("NH2_7","017_2_7","NEH","2","7","7","Nanpakpakaasiak ta pakoyoganas sak-en si solat na ay emey sin gogobernador sin probinsiya sin demang di ginawang ay Eufrates ta ipalobos da ay malabasak ay emey ed Juda. ");
INSERT INTO kne_vpl VALUES ("NH2_8","017_2_8","NEH","2","8","8","Nankedawak abe si solat na en Asaf ay mangay-ayowan sin kada ay okan di ari ta idawtanas sak-en si kaiw ay maamag si eneb di Timplo, eneb sin alad di siyodad ya sin beey ay panteak. Pinatgan din ari dana ay kindaw ko tan sineg-angan Diyos sak-en. ");
INSERT INTO kne_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","11","Inmeyak ed Jerusalem et nanteeak isdi si tolo ay agew. ");
INSERT INTO kne_vpl VALUES ("NH2_16","017_2_16","NEH","2","16","16","Maga di opisyal ay makaammo sin inmeyak ya am-amagek, tan adiak inbagbaga sin papadi, papangolo, oopisyal ya olay sino ay Judio ay makioblan to. ");
INSERT INTO kne_vpl VALUES ("NH2_17","017_2_17","NEH","2","17","17","Idi siya di, kanak en daida, “Maila yo din problima tako, nadadael ed Jerusalem yan napooan din eeneb na. Bangonen tako kasin din alad di siyodad ta adi takon maibabain.” ");
INSERT INTO kne_vpl VALUES ("NH2_18","017_2_18","NEH","2","18","18","Dinad-at ko abe en daida din inyat Diyos ay daydayawek ay nangipaila si seg-ang na en sak-en ya din inbagan di ari. Kanan da ay sinombat, “Ilogi tako et ay mangamag.” Et inlogi da din nay ay nabanol ay obla. ");
INSERT INTO kne_vpl VALUES ("NH2_19","017_2_19","NEH","2","19","19","Ngem idi dinngen da Sanballat ay taga-Bet Horon, si Tobia ay opisyal ay Ammonita ya si Gesem ay Arabo, sinis-iyekan ya nilaslasoy das dakami. Kanan da, “Ay sino nan am-amagen yo? Ay konkontraen yo aya din ari?” ");
INSERT INTO kne_vpl VALUES ("NH2_20","017_2_20","NEH","2","20","20","Kanak ay nanongbat en daida, “Idawat Diyos ed langit di kosto ay pantongpalan din obla mi. Dakami di mansilsilbi en sisya et ilogi mi ay mangamag sin alad, ngem dakayo pay, magay kalebbengan yo ay maitapi en dakami ay Judio ya mangituray en dakami ya magay biyang yo sin ogali mis na.” ");
INSERT INTO kne_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","1","Idi nadamag Sanballat ay bangbangonen mi kasin din alad di siyodad, palalo di bonget na et inlogi na ay nanglaslasoy en dakami ay Judio. ");
INSERT INTO kne_vpl VALUES ("NH4_2","017_4_2","NEH","4","2","2","Kanana sin sangoanan di gagait na ya sosoldado ed Samaria, “Sino aya di layden da nan kakkaasi ay Judio ay ipaila isnan am-amagen da? Ay kabaelan da aya ay bangonen kasin din alad yan kedngen da si esay agew? Ay man-idaton da? Ay mabalin aya ay itaoli da din napooan ay bato sin nadadael ay alad?” ");
INSERT INTO kne_vpl VALUES ("NH4_3","017_4_3","NEH","4","3","3","Kanan din tinatakdo na ay si Tobia ay Ammonita, “Sino pay di silbin san am-amagen da ay alad et? Olay bewet di somakyab et madadael din batog da.” ");
INSERT INTO kne_vpl VALUES ("NH4_4","017_4_4","NEH","4","4","4","Siya et di kanak ay nankararag, “Diyos mi, dengngem kod nan kararag mi tan nay laslasoyen das dakami. Itaolim koma en daida din pangoy-oyaw da. Wada koma di manga sin sanikwa da ya mangibalod en daida ay mangiaddawi sin ili da. ");
INSERT INTO kne_vpl VALUES ("NH4_5","017_4_5","NEH","4","5","5","Adim koman pakawanen ya linglingan din basbasol da tan inoy-oyaw da din man-am-amag sin alad di siyodad.” ");
INSERT INTO kne_vpl VALUES ("NH4_6","017_4_6","NEH","4","6","6","Et inamag mi din nadadael ay alad enggana ay nagodwa din kakayang na, tan inpakat din ipogaw din amin ay kabaelan da ay nan-obla. ");
INSERT INTO kne_vpl VALUES ("NH4_7","017_4_7","NEH","4","7","7","Palalo di bonget da Sanballat, Tobia, ya din Arabo, Ammonita ya taga-Asdod sin nanngean da ay maitoltoloy ay maamag din alad ed Jerusalem ya dandani ay makdeng din nadadael sin alad. ");
INSERT INTO kne_vpl VALUES ("NH4_8","017_4_8","NEH","4","8","8","Idi siya di, nantotolag da amin ay gobaten ya goloen da ed Jerusalem. ");
INSERT INTO kne_vpl VALUES ("NH4_9","017_4_9","NEH","4","9","9","Ngem nankararag kami en Diyos mi ya nandotok kami si manbantay sin kaagawan ya labi. ");
INSERT INTO kne_vpl VALUES ("NH4_10","017_4_10","NEH","4","10","10","Asi et waday inkankantan din ipogaw ed Juda ay kanana, “Enggay nabbanabbay tako, Tan nay palalo ay ad-ado di naiwalang ay batbato. Ay siya mo kabaelan tako ay mangdeng isnan alad tako?” ");
INSERT INTO kne_vpl VALUES ("NH4_11","017_4_11","NEH","4","11","11","Dowan aben kanan din kalaban mi, “Adi dan maila ono maammoan ay omas-asag-en tako, et mabiglaan da. Tan wada tako ay dagos sin kad-an da ay mamse en daida et adi matoloy din obla da.” ");
INSERT INTO kne_vpl VALUES ("NH4_12","017_4_12","NEH","4","12","12","Ngem kanayon ay omal-ali din Judio ay katokmang da ay mangibaga sin lawa ay panggep da en dakami. ");
INSERT INTO kne_vpl VALUES ("NH4_13","017_4_13","NEH","4","13","13","Gapo isdi, inpowistok din tonggal pamilya ay manbantay sin likod di adi nakdeng ay alad. Kampilan, gayang ya pana di armas da. ");
INSERT INTO kne_vpl VALUES ("NH4_14","017_4_14","NEH","4","14","14","Nadlaw ko ay madanagan din ipogaw, isonga kanak en daida ya sin papangolo ya oopisyal, “Adi kayon emegyat en daida. Nemnemen yo si Diyos ay kaeegyat ya manakabalin amin yan makilaban kayo para sin aag-i, an-ak, asawa ya beey yo.” ");
INSERT INTO kne_vpl VALUES ("NH4_15","017_4_15","NEH","4","15","15","Naammoan din kalaban mi ay ammo mi din plano da ya tinopap Diyos. Idi siya di, intoloy mi ay nangamag sin alad. ");
INSERT INTO kne_vpl VALUES ("NH4_16","017_4_16","NEH","4","16","16","Manipod sidi ay agew, man-obla din kagodwan di ipogaw ko yan manbantay din kagodwa ay nakaarmas si kampilan, gayang, pana ya salida. Tinolongan din oopisyal amin din ipogaw ed Juda ");
INSERT INTO kne_vpl VALUES ("NH4_17","017_4_17","NEH","4","17","17","ay man-am-amag sin alad. Din manbonbonag si maosal yan nakaegen si armas din esay takkay da yan say osalen da ay man-obla din esa. ");
INSERT INTO kne_vpl VALUES ("NH4_18","017_4_18","NEH","4","18","18","Amin ay man-obla yan insisiket da din kampilan da. Makitatakdo abe en sak-en din manangtanggoyob. ");
INSERT INTO kne_vpl VALUES ("NH4_19","017_4_19","NEH","4","19","19","Pagak kanan sin kaipoipogaw, sin papangolo ya oopisyal da, “Ando nan alad ay am-amagen tako et nan-inaddawi tako, ");
INSERT INTO kne_vpl VALUES ("NH4_20","017_4_20","NEH","4","20","20","isonga mo dengngen yo din tanggoyob, omali kayo ay tomolong tan si Diyos di makilaban para en datako.” ");
INSERT INTO kne_vpl VALUES ("NH4_21","017_4_21","NEH","4","21","21","Inag-agew ay siya di di inamag mi, manbantay ay nakaarmas din kagodwa yan man-obla din kagodwa. Ilogi mi sin pomatpat-a enggana ay maila din talaw sin labi. ");
INSERT INTO kne_vpl VALUES ("NH4_22","017_4_22","NEH","4","22","22","Sin doy ay timpo, inbagak abe sin lallalaki ya katolongan da ay mantee da sin oneg di siyodad sin labi ta bantayan da din siyodad sin labi yan man-obla da sin kaagawan. ");
INSERT INTO kne_vpl VALUES ("NH4_23","017_4_23","NEH","4","23","23","Mo si sak-en ya din aag-ik, baak ya gogowardiya ay omon-onod en sak-en, adi kamin kakkaanen din bado mi sin labi. Kanayon abe ay nakaegen kami si armas. ");
INSERT INTO kne_vpl VALUES ("NH6_1","017_6_1","NEH","6","1","1","Nadamag da Sanballat, Tobia, Gesem ya din odom ay mangililiget en dakami ay kindeng mi din alad et enggay magay giswang na. (Ngem daan kami pay laeng iamag din eneb na.) ");
INSERT INTO kne_vpl VALUES ("NH6_2","017_6_2","NEH","6","2","2","Idi siya di, pinakaammoan da Sanballat en Gesem sak-en ay man-aabat kami sin esa ay ili sin tanap ed Ono. Ngem waday lawa ay panggep da en sak-en, ");
INSERT INTO kne_vpl VALUES ("NH6_3","017_6_3","NEH","6","3","3","isonga nan-ibaak si nangipaammo sin nay ay songbat ko en daida, “Nabanol di am-amagek, isonga adi mabalin ay manballalongak. Adiak layden ay somaldeng din obla begew sin enak pangabatan en dakayo.” ");
INSERT INTO kne_vpl VALUES ("NH6_4","017_6_4","NEH","6","4","4","Namin opat ay siya met laeng di inpakaammo da en sak-en, ngem kanayon ay iso met laeng din songbat ko en daida. ");
INSERT INTO kne_vpl VALUES ("NH6_5","017_6_5","NEH","6","5","5","Sin maikalima ay nan-ibaa si Sanballat, inpaw-it na sin baa na di nakalokat ay solat ");
INSERT INTO kne_vpl VALUES ("NH6_6","017_6_6","NEH","6","6","6","ay kanana, “Inbagan Gesem en sak-en ay waday ipadpadamag da isnan nandinmang ay nasyon ay panggep yo kano ay Judio ay labanen din mangiturturay en dakayo et say gapo ay am-amagen yo din alad. Kanan da abe en panggep mo ay man-ari ");
INSERT INTO kne_vpl VALUES ("NH6_7","017_6_7","NEH","6","7","7","et tinolag mo di odom ay mamadto ay mangipaammo ed Jerusalem ay sik-a di ari ed Juda. Sigurado ay madamag din ari na, isonga omali ka ta pankalian ta.” ");
INSERT INTO kne_vpl VALUES ("NH6_8","017_6_8","NEH","6","8","8","Inpaw-it ko di songbat ko yan kanak, “Amin din ibagbagam yan magay katet-ewa na, tan sik-a met laeng di akin nemnem issa.” ");
INSERT INTO kne_vpl VALUES ("NH6_9","017_6_9","NEH","6","9","9","Pinadpadas da amin ay egyaten dakami ta madismaya kami ya adi maitoloy din obla, ngem kanak ay nankararag, “Apo Diyos, papigsaem kod dakami ed wani.” ");
INSERT INTO kne_vpl VALUES ("NH6_10","017_6_10","NEH","6","10","10","Sin namingsan, inmeyak sin beey Semayas ay anak Delayas, ay anak Mehetabel tan adi makabala sin beey na. Kanana, “En ta man-abat sin Timplon Diyos. Man-eneb ta tan wada da di manpanggep ay mamse en sik-a sin labi.” ");
INSERT INTO kne_vpl VALUES ("NH6_11","017_6_11","NEH","6","11","11","Ngem kanak en sisya, “Ay siya mo naeegyatanak ta lomayawak ya enak mantabon sin Timplo? Aga, adiak emey!” ");
INSERT INTO kne_vpl VALUES ("NH6_12","017_6_12","NEH","6","12","12","Naammoak ay adi nankali si Diyos en sisya mo adi et pinasoksokan da Tobia en Sanballat ta egyatenas sak-en. ");
INSERT INTO kne_vpl VALUES ("NH6_13","017_6_13","NEH","6","13","13","Linagboan da ay mangegyat en sak-en ta bomasolak mo onodak di et madadael di dayaw ko ya maibabainak. ");
INSERT INTO kne_vpl VALUES ("NH6_14","017_6_14","NEH","6","14","14","Siya di, kanak ay nankararag, “Apo Diyos, adi ka koman linglinglingan din nay inamag da Tobia en Sanballat, siya abe sin babai ay mamadto ay si Noadias ya din odom ay mamadto ay en nangeg-egyat en sak-en, ta dosaem daida.” ");
INSERT INTO kne_vpl VALUES ("NH6_15","017_6_15","NEH","6","15","15","Limapolo ya dowa ay agew din naamagan di alad, et nakdeng sin pitsa 25 di bowan ay Elul. ");
INSERT INTO kne_vpl VALUES ("NH6_16","017_6_16","NEH","6","16","16","Idi nadamag din kalaban mi sin nandinmang ay nasyon, inmegyat da am-in ya nadismaya da, tan naila da ay nakdeng din obla babaen sin tolong Diyos. ");
INSERT INTO kne_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Sin maikapito ay bowan, enggay nanbeebeey din Israelita sin il-ili da. Nan-es-esa da ay natopog sin plaza sin kad-an di segpan di siyodad ay makwani en Danom. Inpaibala da en Ezra ay padi ya maestron di linteg din naisolatan di linteg Moses ay din bilbilin Diyos para sin Israelita. ");
INSERT INTO kne_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Isonga sin pitsa 1 sin maikapito ay bowan, inbalan Ezra din naisolatan di linteg sin sangoanan di natopog ay kaipoipogaw, ay lallalaki ya babbabai ya anan-ak ay makaawat. ");
INSERT INTO kne_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Inbasa na sin sangoanan di kaipoipogaw sin plaza sin sangoanan di segpan ay makwani en Danom. Inlogi na ay nangibasa sin napat-a enggana ay nan-gawa yan inpapasnek din amin ay ipogaw ay nandenge. ");
INSERT INTO kne_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Inoklag Ezra din libro ay iniilan di kaipoipogaw, tan nakaykayang din pinmipikaana mo daida. Idi lokatana, pinmika da am-in. ");
INSERT INTO kne_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Kanan Ezra, “Madaydayaw si Yahweh ay manakabalin ay Diyos.” Inkayang din amin ay ipogaw din takkay da yan kanan da, “Amen! Amen!” Pag dan mandokmog ay manyakog-ong ay nanaydayaw en Diyos. ");
INSERT INTO kne_vpl VALUES ("NH8_7a","017_8_7a","NEH","8","7a","7a","Pag dan pomika din ipogaw et inpalawag da Jesua ay Levita en daida din linteg. ");
INSERT INTO kne_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","In-olog da din linteg, asi dan inlawlawag ta maawatan din kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Omanoga din ipogaw sin nanngean da sin linteg, pag kanan da Nehemias ay gobernador, Ezra ay padi ya maestron di linteg, ya din Levita ay mangit-itdo sin ipogaw, “Nasantoan din agew ay nay ay para en Yahweh ay Diyos yo, isonga adi kayon manladingit ya man-oga.” ");
INSERT INTO kne_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Kanan Nehemias, “Somaa kayo ta manragsak kayo ay mangan ya man-inom yan idawtan yo din magay sagana na. Nasantoan din agew ay nay para en Diyos, isonga adi kayon manladingit, tan din ragsak yo sin panaydayawan yo en Diyos di pomigsaan di nemnem yo.” ");
INSERT INTO kne_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","Et sinmaa am-in din ipogaw ay en nanragsak ay nangan ya nan-inom. Indawtan da abe din gagait da. Palalo di ragsak da, tan naawatan da din dinnge da ay naibasa. ");
INSERT INTO kne_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","1","Sin pitsa 24 di iso met laeng ay bowan, natopog din Israelita ta itpe da din dagaang da. Nanbado da si sako ya piney-an da si tapok din toktok da ay mangipaila si ladingit da. ");
INSERT INTO kne_vpl VALUES ("NH9_2","017_9_2","NEH","9","2","2","Kinmasin din Israelita sin mangili et pinmika da ay nangipodno ya nangibabawi sin basbasol da ya basbasol di aap-o da. ");
INSERT INTO kne_vpl VALUES ("NH9_3","017_9_3","NEH","9","3","3","Emey ay tolo ay oras ay naibasa en daida din linteg Yahweh ay Diyos da. Tolo ay oras abe ay pinmipika da ay nangipodno sin basbasol da ya nandaydayaw dan Yahweh ay Diyos da. ");
INSERT INTO kne_vpl VALUES ("NH9_5","017_9_5","NEH","9","5","5","Idi siya di, kanan din Levita ay da Jesua, Kadmiel, Bani, Hasabneyas, Serebias, Hodias, Sebanias ya si Petahias, “Pomika kayo ta idaydayaw yo si Yahweh ay Diyos yo.” Pag dan kanan ay nangikararag, “Maidaydayaw ka koma si eng-enggana olay mo adi omanay di kalin di ipogaw ay mangidayaw ay kosto sin kinangaton di ngadan mo. ");
INSERT INTO kne_vpl VALUES ("NH9_6","017_9_6","NEH","9","6","6","Sik-a anggoy di Diyos. Pinarsuam ed daya ya ed langit pati din tatalaw ay wadas di. Pinarsuam din daga ya din baybay ya din amin ay wada en daida. Indawtam daida amin si biyag yan daydayawen daka sin adi kabilang ay aanghel ed langit. ");
INSERT INTO kne_vpl VALUES ("NH9_7","017_9_7","NEH","9","7","7","“Sik-a si Yahweh ay Diyos ay namili en Abram. Sik-a di nangipango en sisya ay komaan ed Ur ay lak-am di Babilonia ya nangipangadan en sisya si Abraham. ");
INSERT INTO kne_vpl VALUES ("NH9_8","017_9_8","NEH","9","8","8","Napaneknekam ay matalek sisya et intolag mon sisya ay idawat mo sin ipoli na din dagan di Canaaneo, Heteo, Amorreo, Perezeo, Jebuseo ya Gergeseo. Et tinongpal mo din karim tan nalinteg ka. ");
INSERT INTO kne_vpl VALUES ("NH9_9","017_9_9","NEH","9","9","9","“Inilam din ligat di ap-apo mi ed Egipto ya dinngem din adawag da ay mankedaw si badang mo sin kawada da sin Baybay ay Mandalangdang. ");
INSERT INTO kne_vpl VALUES ("NH9_10","017_9_10","NEH","9","10","10","Inpailam di ad-ado ay nakaskasdaaw sin inyat mo ay nanosa sin Faraon ya din amin ay oopisyal ya ipogaw sin ili na, tan ammom di inyat da ay namaligat sin ipogaw mo. Ginon-od mo di dayaw ay wada en sik-a enggana pay laeng ed wani. ");
INSERT INTO kne_vpl VALUES ("NH9_11","017_9_11","NEH","9","11","11","Nansianem din baybay sin sangoanan da et namgaan di nandanan da. Ngem intep-am din mangap-apayaw en daida sin baybay et kaman dan bato ay nalned sin napigsa ay danom. ");
INSERT INTO kne_vpl VALUES ("NH9_12","017_9_12","NEH","9","12","12","Sin kaagawan yan inpangom daida babaen si liboo, sin labi yan sinilawam din danan da babaen si apoy. ");
INSERT INTO kne_vpl VALUES ("NH9_13","017_9_13","NEH","9","13","13","Manipod ed langit yan binmaba ka sin dontog ay Sinai et isdi ay nakikali ka en daida. Indawat mo en daida din linteg ya bilbilin mo ay kosto ya nalinteg. ");
INSERT INTO kne_vpl VALUES ("NH9_14","017_9_14","NEH","9","14","14","“Inbilin mon daida ay banolen da din agew ay pan-ibbayan yan inpaammom din linteg ya bilbilin mo babaen en Moses ay baam. ");
INSERT INTO kne_vpl VALUES ("NH9_15","017_9_15","NEH","9","15","15","Sin nandagaangan da, pinakan mos daida si tinapay ay napod daya. Sin nanbigawan da, indawtam daida si danom ay napo sin dakdake ay bato. Inbagam en daida ay en da okaen din daga ay insapatam ay idawat mo en daida. ");
INSERT INTO kne_vpl VALUES ("NH9_16","017_9_16","NEH","9","16","16","Ngem tinmangsit din ap-apo mi et sinigaan da ay tongpalen din bilin mo. ");
INSERT INTO kne_vpl VALUES ("NH9_17","017_9_17","NEH","9","17","17","Sinigaan da ay mangonod sin bilin mo yan nilinglingan da din nakaskasdaaw ay inam-amag mo sin sangoanan da. Begew sin makenteg ay nemnem da, nanpili da si mangipango en daida ta mantaoli da koma sin naibag-enan da ed Egipto. Ngem sik-a din Diyos ay manangpakawan, managseg-ang, kanayon ay managlayad ya baken nalaka ay bomonget. Isonga adi kan dinokogan daida ");
INSERT INTO kne_vpl VALUES ("NH9_18","017_9_18","NEH","9","18","18","olay mo nan-amag da si sinan baka asi dan kanan en si doy din diyos ay nangipango en daida ay komaan ed Egipto ya olay mo ininsolto das sik-a begew sin kasisinit ay inam-amag da. ");
INSERT INTO kne_vpl VALUES ("NH9_19","017_9_19","NEH","9","19","19","Gapo sin dakdake ay seg-ang mo, adi kan binaybay-an daida sin lugar ay magay omili. Adi kan kinakkaan din kaman posti ay liboo ya apoy ay nangipangpango en daida sin kaagawan ya labi. ");
INSERT INTO kne_vpl VALUES ("NH9_20","017_9_20","NEH","9","20","20","Indawat mo en daida din siged ay Ispiritom ta say maitdoan da sin masapol ay amagen da. Pinakan mos daida si manna ya pinainom mos daida. ");
INSERT INTO kne_vpl VALUES ("NH9_21","017_9_21","NEH","9","21","21","Opatapolo ay tawen ay indawdawat mo din kasapolan da sin lugar ay magay omili. Maga polos di nankolang ay kasapolan da, adi nadondonot din bado da ya adi aben linmatlat-ed din siki da. ");
INSERT INTO kne_vpl VALUES ("NH9_22","017_9_22","NEH","9","22","22","“Nangabakem daida et inabak da di aari ya din ipogaw da et inbingay mo sin ipogaw mo din daga da. Inoka da ed Hesbon ay inturayan Sihon ya ed Basan ay inturayan Og. ");
INSERT INTO kne_vpl VALUES ("NH9_23","017_9_23","NEH","9","23","23","Inpaad-adom din anak da ay kaman din kaad-adon di talaw ed daya ya inpangom daida sin daga ay inkarim sin ap-apo da. ");
INSERT INTO kne_vpl VALUES ("NH9_24","017_9_24","NEH","9","24","24","Inmey din an-ak da et inoka da din daga, tan binadangam daida ay mangabak sin man-ili ed Canaan et inpakaan mo din omili isdi. Indawtam daida si kabaelan ay mangabak sin omili ya din ari da ya mangamag si layden da ay amagen en daida. ");
INSERT INTO kne_vpl VALUES ("NH9_25","017_9_25","NEH","9","25","25","Inabak din ipogaw mo di siyodad ay nas-et di alad da ya daga ay magabay di mola. Inoka da di bebbeey ay napno si kinabaknang, naamag ay sakdoan, kaob-obasan, kakakkaiwan ay olivo ya kakaiw ay manlames. Nangan da si am-in ay layden da et tinmaba da. Ginan-ganas da din nakaskasdaaw ay bindisyon mo en daida. ");
INSERT INTO kne_vpl VALUES ("NH9_26","017_9_26","NEH","9","26","26","“Ngem adi dakan tinongpal ya kinontra das sik-a. Dinokogan da din linteg mo ya pinse da din mamadto ay inbaam ay mamagbaga en daida ta mantaoli da en sik-a. Nadagsen di basol da ay nankalkali si maikontra en sik-a. ");
INSERT INTO kne_vpl VALUES ("NH9_27","017_9_27","NEH","9","27","27","Siya din gapo ay inpalobos mo ay abaken din kalaban da ya paligaten das daida. Ngem idi naligatan da, nankedaw da si badang mo et dinngem ed daya. Gapo sin dakdake ay seg-ang mo, indawtam daida si mangisalakan en daida sin kalaban da. ");
INSERT INTO kne_vpl VALUES ("NH9_28","017_9_28","NEH","9","28","28","Ngem idi sinmaldeng di ligat da, inamag da kasin di lawa sin pangilam. Isonga binay-am daida ay abaken din kalaban da et inturayan das daida. Idi nankedaw da kasin si badang mo, dinngem ed daya et insalakan mos daida. Kanayon ay kaman nidi di naam-amag. ");
INSERT INTO kne_vpl VALUES ("NH9_29","017_9_29","NEH","9","29","29","“Binagbagaam daida ta mantongpal da sin linteg mo, ngem inpapangato dan nemnem da et adi dan tinongpal. Sinigaan da ay manongpal sin linteg mo, olay mo say poon di biyag da din panongpalan das di. ");
INSERT INTO kne_vpl VALUES ("NH9_30","017_9_30","NEH","9","30","30","Katawetawen ay inan-anosam ay namagbaga en daida babaen sin mamadto ay nankalkaliam, ngem tineteweng da. Isonga inpalobos mo ay iturayan din odom ay nasyon daida. ");
INSERT INTO kne_vpl VALUES ("NH9_31","017_9_31","NEH","9","31","31","Ngem olay mo siya di, adi ka pinses daida amin ya adi kan nilinglingan, gapo ta managseg-ang ya managlayad ka ay Diyos. ");
INSERT INTO kne_vpl VALUES ("NH9_32","017_9_32","NEH","9","32","32","“Sik-a din nakaskasdaaw, manakabalin ya kaeegyat ay Diyos. Tongpalem di itolag mo ya adi manbalbaliw din layad mo, isonga adi ka koman ibilang ay nalag-an nan laklak-amen mi ay ligat. Nilaklak-am mi am-in sin aari mi, oopisyal, papadi, mamadto, ap-apo mi ya din amin ay ipogaw mo manipod sin nanturturayan di aari ay taga-Assyria engganad wani. ");
INSERT INTO kne_vpl VALUES ("NH9_33","017_9_33","NEH","9","33","33","Nalinteg ka sin amin ay nanosaam en dakami, tan managtongpal ka sin inbagam, ngem nanbasol kami. ");
INSERT INTO kne_vpl VALUES ("NH9_34","017_9_34","NEH","9","34","34","Din aari, papangolo, papadi ya ap-apo mi yan adi dan tinongpal din linteg mo. Adi dan inkaskaso din linteg mo ya pamagbagam en daida. ");
INSERT INTO kne_vpl VALUES ("NH9_35","017_9_35","NEH","9","35","35","Mayat di kabibiyag ay inpalak-am mo en daida sin annawa ay daga ay inturayan da ay magabay di mola. Ngem olay mo siya di, adi dan dinokdokogan din lawa ay ogali da ta mansilbi dan sik-a. ");
INSERT INTO kne_vpl VALUES ("NH9_36","017_9_36","NEH","9","36","36","Ed wani yan nay naibabag-en kami isnan ili ay indawat mo sin ap-apo mi ta say kapoan di kanen mi ya amin ay pansigdan ay magon-od mi. ");
INSERT INTO kne_vpl VALUES ("NH9_37","017_9_37","NEH","9","37","37","Gapo sin basbasol mi, din aari ay insaad mo ay mangituray en dakami di kaidawtan din maapit. Mabalin ay amagen da di olay sino ay layden da en dakami ya sin aanimal mi et palalo ay maligligatan kami. ");
INSERT INTO kne_vpl VALUES ("NH9_38","017_9_38","NEH","9","38","38","Ngem olay mo siya di di napasamak, man-amag kami ay Judio si kasolatan ay masapataan ay pirmaan din papangolo, Levita ya papadi mi.” ");
INSERT INTO kne_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Sin ili ay Uz, waday lalaki ay manngadan si Job. Magay maipabasol en sisya ya kosto di ogali na, tan pinatpateg na si Diyos ya inaddawiana amin ay lawa. ");
INSERT INTO kne_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Waday an-ak na ay pito ay lalaki ya tolo ay babai. ");
INSERT INTO kne_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Wada abey 7,000 ay karnero na, 3,000 ay kamel, 1,000 ay baka, 500 ay dangki ya ad-ado ay bag-en. Sisya di kababaknangan sin bomandas belaan di agew. ");
INSERT INTO kne_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Mansinoskat da ay manpalti din an-ak na ay lalaki yan man-asiayag da. Kanayon abe ay ayagan da din aag-i da ay babbabai. ");
INSERT INTO kne_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Mo tonggal makdeng din ragragsak da, masapa si Job ay man-idaton si animal ay mapooan para sin esa ya esa ay anak na ta say malinisan da. Kanayon ay amagena di tan kananas nemnem na en amangan mo binaosan das Diyos sin nemnem da yan say binmasolan da. ");
INSERT INTO kne_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Sin namingsan ay nasinop din aanghel sin sangoanan Diyos, nakikoyog si Satanas en daida. ");
INSERT INTO kne_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Kanan Diyos en sisya, “Intoy napoam?” Kanana ay sinombat, “Sinokisok ko din intiro ay daga.” ");
INSERT INTO kne_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Pag kanan Diyos, “Sinoy pannemnem mo en Job ay mansilsilbi en sak-en? Magay makaiso en sisya sin intiro ay daga. Magay maipabasol en sisya tan kosto di ogali na. Patgenas sak-en ay Diyos ya ad-addawiana di lawa.” ");
INSERT INTO kne_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Ngem kanan Satanas ay nanongbat, “Ay siya mo dayawen dakan Job mo magay gapo na? ");
INSERT INTO kne_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Kanam adi mon sik-a ay mismo di nanalsalaknib en sisya ya din pamilya na pati amin ay sanikwa na. Binindisyonam amin ay obla na ya inpaad-adom din animal na et naiwaras da sin intiro ay daga. ");
INSERT INTO kne_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Padasem kadi ay kaanen din sanikwa na ta ilaem mo adi daka et baosan ay sangosango.” ");
INSERT INTO kne_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Pag kanan Diyos, “May, amagem din laydem sin amin ay sanikwa na, ngem adi kan sagsagiden sisya ay mismo.” Et siya di, kinmaan si Satanas sin sangoanan Diyos. ");
INSERT INTO kne_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Sin namingsan, manragragsak din an-ak Job sin beey di pangpangoan da. ");
INSERT INTO kne_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Sin agew ay doy, dinmateng et sin beey Job di mangipadamag en Job ay kanana, “Idi ial-alado mi din babaka ya man-al-alab dan dangki sin asag-en mi, ");
INSERT INTO kne_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","kadateng da et din taga-Sabe yan ina da amin daida. Pinse da din babag-en mo et sak-en anggoy di nabay-an ay mangipadamag en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Mankalkali pay laeng di yan domateng di esay bag-en yan kanana, “Nakimat din kakarnero ya manpaspastol et sak-en anggoy di nabay-an ay mangipaammo en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Mankalkali pay laeng di, kadateng abey esay bag-en yan kanana, “Waday tolo ay bonggoy di Kaldeo ay inmali yan ina da amin ay kamel ya pinse da amin din bag-en mo. Sak-en anggoy di nabay-an ay mangipaammo en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Mankalkali pay laeng din lalaki ay sana yan domateng et di esa ay kanana, “Manragragsak din an-ak mo sin beey di pangpangoan da ");
INSERT INTO kne_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","yan kadateng et di kaeegyat ay alinposapos ay napo sin kadardaratan. Dinadael na din beey et natab-okan da. Natey da amin et sak-en anggoy di nabay-an ay mangipaammo en sik-a.” ");
INSERT INTO kne_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Idi siya di, kapika si Job yan kabisngit sin bado na gapo si ladingit na. Kinoskosana din book na, asi pag manpakleb sin lota ay mangdayaw en Diyos ");
INSERT INTO kne_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","yan kanana, “Magay intakin ko sin binmalaak en inak yan maga abey itakin ko mo mateyak. Si Diyos di nangidawat et sisya met laeng di nanaoli. Madaydayaw si Diyos.” ");
INSERT INTO kne_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Olay mo siya di di napasamak, adi nanbasol si Job ya adi na aben pinabasol si Diyos. ");
INSERT INTO kne_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Sin esay agew, kasin nasinop din aanghel sin sangoanan Diyos yan wada si Satanas ay naitapi en daida. ");
INSERT INTO kne_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Kanan Diyos en sisya, “Intoy napoam?” Kanana ay sinombat, “Sinokisok ko din intiro ay daga.” ");
INSERT INTO kne_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Pag kanan Diyos, “Sinoy pannemnem mo en Job ay mansilsilbi en sak-en? Magay makaiso en sisya sin intiro ay daga. Magay maipabasol en sisya tan kosto di ogali na. Patgenas sak-en ay Diyos ya ad-addawiana di lawa. Pinatodonam sak-en ay mamaligat en sisya olay magay gapo na, ngem inpapasnek na pay dedan ay mangitoltoloy sin kosto ay ogali na.” ");
INSERT INTO kne_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Ngem kanan Satanas, “Idawat di ipogaw amin ay wada en sisya ta maisalakan di biyag na. ");
INSERT INTO kne_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Ngem padasem ay paligaten din awak na et sigurado ay baosan daka.” ");
INSERT INTO kne_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Pag kanan Diyos, “May, ipalobos ko ay amagem di laydem en sisya ngem adi ka pespeslen.” ");
INSERT INTO kne_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Siya et di kinmaan si Satanas sin sangoanan Diyos et nansakitena si Job. Nabayabayangan manipod dapan enggana sin toktok na. ");
INSERT INTO kne_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Nan-a si pit-ing di banga ay ikoskoskos na sin bayang na sin tomotokdoana ay dap-o sin basuraan. ");
INSERT INTO kne_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Kanan din asawa na en sisya, “Ay itoltoloy mo pay laeng din kosto ay ogalim? Adi ka et baosan si Diyos ta olay matey ka.” ");
INSERT INTO kne_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Ngem kanan Job, “Kaman magay nemnem mo. Awaten tako din bindisyon Diyos, ngem apay nga manmayotmot tako sin ligat?” Olay kas-ano di ligat Job, adi nankali si lawa. ");
INSERT INTO kne_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Idi dinngen din gagayyem Job din napasamak ay ligat na, nantotolag da ay en liwliwaen sisya. Di ngadan da yan si Elifaz ay taga-Teman, Bildad ay taga-Sua, ya si Zofar ay taga-Naama. ");
INSERT INTO kne_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","Idi tamangen da sin baken onay addawi, istay adi dan maimatonan sisya. Nan-oga da ya binisngit da din bado da dowan dan sapokan din toktok das tapok. ");
INSERT INTO kne_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","Nakitotokdo da en sisya sin lota si pito ay agew ya labi, ngem magay nankalkali tan inila da ay palalo di ligat na. ");
INSERT INTO kne_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Idi siya di, nankali si Job et binaosana din agew ay naianakana. ");
INSERT INTO kne_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Kanana, ");
INSERT INTO kne_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","“Din nankalalaing ay manbaos ay makabael ay manbalaga sin kaeegyat ay bowaya sin baybay, binaosan da koma din agew ay sana. ");
INSERT INTO kne_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","9","Adi koma binmala din batakagan ay nansilaw sin pinmat-aana. Maga koma di nantongpalan di nansedsed-an din agew ay sana sin pinmat-aana. Adi koman natoloy din kaaggewana. ");
INSERT INTO kne_vpl VALUES ("JB3_10","019_3_10","JOB","3","10","10","Mabaosan koma din labi ay sana tan adi na tinopap di binmalaak sin eges en inak, ta adiak koman lak-amen dana ay ligat. ");
INSERT INTO kne_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Apay nga adiak et natey sin eges inak ono sin binmalaak? ");
INSERT INTO kne_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","Apay nga binmakwa pay laeng si inak ya nansosoak? ");
INSERT INTO kne_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","Ta mo nateyak et koma, ed wani yan man-il-illengak. ");
INSERT INTO kne_vpl VALUES ("JB3_20","019_3_20","JOB","3","20","20","Apay nga matago pay laeng di ipogaw ay palalo di ligat ya ladingit da? ");
INSERT INTO kne_vpl VALUES ("JB3_21","019_3_21","JOB","3","21","21","Laylayden da ay matey, ngem baken say maamag en daida. Nasursurok din iyat da ay manganap sin pese mo din gaget di manganap si naitabon ay kinabaknang. ");
INSERT INTO kne_vpl VALUES ("JB3_22","019_3_22","JOB","3","22","22","Et palalo di ragsak da mo datngen dan pese ya maiponpon da. ");
INSERT INTO kne_vpl VALUES ("JB3_23","019_3_23","JOB","3","23","23","Apay nga matago pay laeng di ipogaw ay sinalinan Diyos di masakbayana? ");
INSERT INTO kne_vpl VALUES ("JB3_24","019_3_24","JOB","3","24","24","Adiak makakan begew sin ladingit ko. Kaman omayos ay danom din kaad-adon di bayeweng ko. ");
INSERT INTO kne_vpl VALUES ("JB3_25","019_3_25","JOB","3","25","25","Amin din emeg-egyatak et tinmet-ewa da. ");
INSERT INTO kne_vpl VALUES ("JB3_26","019_3_26","JOB","3","26","26","Magay talnak ya pan-illengak ya magay pap-eng di problimak.” ");
INSERT INTO kne_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Idi siya di, nankali si Elifaz ay taga-Teman yan kanana, ");
INSERT INTO kne_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","“Anosam koma din ibagak en sik-a tan adiak makaitpe si kalik. ");
INSERT INTO kne_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","Nemnemem din ad-ado ay initdoam ya din binadbadangam ay magay kabaelan da. ");
INSERT INTO kne_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","Pinapigsam abe sin kalim din nadismaya ya nadadagsenan sin ligat da. ");
INSERT INTO kne_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","Ngem ed wani ay sik-a di maligatan yan adi kan maanosan. ");
INSERT INTO kne_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Patpatgem si Diyos ya magay maipabasol en sik-a, et lebbeng na ay mantalek ya mannamnama ka. ");
INSERT INTO kne_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","Nemnemem kod na. Ay wada aya di magay basol na ay dosaen Diyos ta matey? ");
INSERT INTO kne_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","Siya na di inilak: Din mangimola si basol ya problima et lawa di apiten da. ");
INSERT INTO kne_vpl VALUES ("JB4_9","019_4_9","JOB","4","9","9","Tan kaman napigsa ay dagem din bonget Diyos ay manadael en daida.” ");
INSERT INTO kne_vpl VALUES ("JB5_8","019_5_8","JOB","5","8","8","“Mo sak-en si sik-a, mankamangak en Diyos et ibagak din ligat ko. ");
INSERT INTO kne_vpl VALUES ("JB5_9","019_5_9","JOB","5","9","9","Adi takon maawatan din nakaskasdaaw ay am-amagena ya adi somaldeng ay mangamag si kaman dana. ");
INSERT INTO kne_vpl VALUES ("JB5_10","019_5_10","JOB","5","10","10","Pawadaena di odan sin daga et danomana din papayew. ");
INSERT INTO kne_vpl VALUES ("JB5_11","019_5_11","JOB","5","11","11","Ipangato na din napakombaba ya isalakana din mapalpaligatan. ");
INSERT INTO kne_vpl VALUES ("JB5_12","019_5_12","JOB","5","12","12","Adi na ipalobos ay matongpal din planon di nasikap. ");
INSERT INTO kne_vpl VALUES ("JB5_13","019_5_13","JOB","5","13","13","Et makna da sin tagdey ay daida met laeng di nangamag.” ");
INSERT INTO kne_vpl VALUES ("JB6_1","019_6_1","JOB","6","1","1","Idi songbatan Job yan kanana, ");
INSERT INTO kne_vpl VALUES ("JB6_2","019_6_2","JOB","6","2","2","“Mo koma ta matimbang din ladingit ya ligligat ko ");
INSERT INTO kne_vpl VALUES ("JB6_3","019_6_3","JOB","6","3","3","et nadagdagsen da mo din darat sin baybay, isonga adi kayo koma masdaaw mo oway di inbagbagak. ");
INSERT INTO kne_vpl VALUES ("JB6_8","019_6_8","JOB","6","8","8","Mo dengngen koman Diyos din kararag ko ta ipalobos na din kedkedawek en sisya. ");
INSERT INTO kne_vpl VALUES ("JB6_9","019_6_9","JOB","6","9","9","Maymayat et koma mo pomse. ");
INSERT INTO kne_vpl VALUES ("JB6_10","019_6_10","JOB","6","10","10","Mo say iyat na koma et maragsakanak olay mo palalo di ligat ko. Tan adiak polos nilabsing din bilbilin di Nasantoan ay Diyos. ");
INSERT INTO kne_vpl VALUES ("JB6_11","019_6_11","JOB","6","11","11","Into pay di bikas ko ay mantoltoloy ay matago mo maga met laeng di namnamak? ");
INSERT INTO kne_vpl VALUES ("JB6_28","019_6_28","JOB","6","28","28","Ominengneng kayo kod ta paneknekan yo mo man-et-etekak en dakayo. ");
INSERT INTO kne_vpl VALUES ("JB6_29","019_6_29","JOB","6","29","29","Enggay nalabes kayo. Isaldeng yo koma san baken kosto ay ibagbaga yo. Adi yo pabasolen sak-en tan maga di basol ko. ");
INSERT INTO kne_vpl VALUES ("JB6_30","019_6_30","JOB","6","30","30","Ay siya mo man-et-etekak ya adiak ammo ay mangilasin si siged ya lawa? ");
INSERT INTO kne_vpl VALUES ("JB7_1","019_7_1","JOB","7","1","1","“Din biyag di ipogaw isnan daga et maiarig si biyag di soldado ay naligat ya mapilitan ay mansilbi ya kaman biyag di makilaglagbo. ");
INSERT INTO kne_vpl VALUES ("JB7_2","019_7_2","JOB","7","2","2","Kaman din bag-en ay manseseed si kasdemana ya din makilaglagbo ay manseseed si lagbo na. ");
INSERT INTO kne_vpl VALUES ("JB7_3","019_7_3","JOB","7","3","3","Binowan ay magay silbin di panagbiyag ko, linablabi ay ladingit di laklak-amek. ");
INSERT INTO kne_vpl VALUES ("JB7_4","019_7_4","JOB","7","4","4","Mo bomaktadak, laydek ay maaggew koma. Ngem ando din labi et owatak bomalibalin enggana ay pomat-a. ");
INSERT INTO kne_vpl VALUES ("JB7_5","019_7_5","JOB","7","5","5","Pag bayang amin nan awak ko. Enggay nabigis ya nadanoman da. ");
INSERT INTO kne_vpl VALUES ("JB7_6","019_7_6","JOB","7","6","6","Paspas ay malabas nan agew ay panbiyagak, mapospos nan agew ko yan magay namnamak. ");
INSERT INTO kne_vpl VALUES ("JB7_7","019_7_7","JOB","7","7","7","“Nemnemem koma ay Diyos ay owat kaman dagem nan biyag ko. Enggay napap-eng di ragsak ko. ");
INSERT INTO kne_vpl VALUES ("JB7_8","019_7_8","JOB","7","8","8","Din omil-ila ed wani, awni et adi dan to omila. Olay mo omanap ka, magaak ay datngem. ");
INSERT INTO kne_vpl VALUES ("JB7_9","019_7_9","JOB","7","9","9","Din ipogaw ay matey et kaman din liboo ay maomas ya malitaw, tan adi kasin mantaoli. ");
INSERT INTO kne_vpl VALUES ("JB7_10","019_7_10","JOB","7","10","10","Adi mantaoli sin beey na et enggay maliw-an sisya.” ");
INSERT INTO kne_vpl VALUES ("JB8_1","019_8_1","JOB","8","1","1","Nankali abe si Bildad ay taga-Sua yan kanana, ");
INSERT INTO kne_vpl VALUES ("JB8_2","019_8_2","JOB","8","2","2","“Pig-an pay ay somaldeng ka issan ad-ado ay ibagbagam ay kaman owat dagem? ");
INSERT INTO kne_vpl VALUES ("JB8_3","019_8_3","JOB","8","3","3","Ay siya mo ikillon Diyos ay Manakabalin din nalinteg ya baliktadena din kosto? ");
INSERT INTO kne_vpl VALUES ("JB8_4","019_8_4","JOB","8","4","4","Binmasol met din an-ak mo et dinosanas daida begew sin basol da. ");
INSERT INTO kne_vpl VALUES ("JB8_5","019_8_5","JOB","8","5","5","Kamangem et koma si Diyos ay Manakabalin Amin ta mankedaw ka si seg-ang na. ");
INSERT INTO kne_vpl VALUES ("JB8_6","019_8_6","JOB","8","6","6","Mo tet-ewa ay nalinteg ka ya nalinis di nemnem mo, sigurado ay badangan dakan Diyos ya itaoli na amin ay namaga en sik-a. ");
INSERT INTO kne_vpl VALUES ("JB8_7","019_8_7","JOB","8","7","7","Din sigod ay kasasaad mo et kaman kan nabiteg mo mais-o sin kinabaknang mo sin tapin di agew.” ");
INSERT INTO kne_vpl VALUES ("JB9_1","019_9_1","JOB","9","1","1","Songbatan pay Job yan kanana, ");
INSERT INTO kne_vpl VALUES ("JB9_2","019_9_2","JOB","9","2","2","“Ammok kayman ay tet-ewa sa, ngem intoy iyat di ipogaw ay mangibaga sin sangoanan Diyos ay magay basol na? ");
INSERT INTO kne_vpl VALUES ("JB9_3","019_9_3","JOB","9","3","3","Mo waday mangipadas ay makisongbat en Diyos et adi na masongbatan di olay esa sin nilibo ay salodsod na. ");
INSERT INTO kne_vpl VALUES ("JB9_4","019_9_4","JOB","9","4","4","Nalaing ya manakabalin si Diyos, isonga magay makabael ay lomaban en sisya. ");
INSERT INTO kne_vpl VALUES ("JB9_5","019_9_5","JOB","9","5","5","Bigla ay etanena din dontog ya tokangena gapo sin bonget na. ");
INSERT INTO kne_vpl VALUES ("JB9_6","019_9_6","JOB","9","6","6","Panyegyegena din daga et maikiweg din tokod na. ");
INSERT INTO kne_vpl VALUES ("JB9_7","019_9_7","JOB","9","7","7","Mabalin ay bilinena din agew ya talaw ta adi da bomala. ");
INSERT INTO kne_vpl VALUES ("JB9_8","019_9_8","JOB","9","8","8","Ang-anggoy na ay nangipawada ed daya ya nangigatin sin dalloyon sin baybay. ");
INSERT INTO kne_vpl VALUES ("JB9_9","019_9_9","JOB","9","9","9","Insaad na abe din grupon di talaw ed daya ay kaman din salibobo, ad-ado, todong, ya odom pay. ");
INSERT INTO kne_vpl VALUES ("JB9_10","019_9_10","JOB","9","10","10","Adi takon maawatan din nakaskasdaaw ay am-amagena ya adi somaldeng ay mangam-amag si nakaskasdaaw. ");
INSERT INTO kne_vpl VALUES ("JB9_11","019_9_11","JOB","9","11","11","“Mo malabas sin kad-ak, adiak mailas sisya. ");
INSERT INTO kne_vpl VALUES ("JB9_12","019_9_12","JOB","9","12","12","Alaena din laydena et magay makalapped en sisya. Magay makaitoled ay mangibaga en sisya, ‘Sinoy am-amagem issa?’ ");
INSERT INTO kne_vpl VALUES ("JB9_13","019_9_13","JOB","9","13","13","Adi na teppen din bonget na, et inabak na din kalabana ay binmadang sin dragon ay si Rahab. ");
INSERT INTO kne_vpl VALUES ("JB9_14","019_9_14","JOB","9","14","14","“Sinoak ngarud ay makisongbat en sisya? Intoy panganapak ngata si isongbat ko? ");
INSERT INTO kne_vpl VALUES ("JB9_15","019_9_15","JOB","9","15","15","Olay magay basol ko, iwed met laeng maamag ko isonga manpakpakaasiak et anggoy en Diyos. ");
INSERT INTO kne_vpl VALUES ("JB9_16","019_9_16","JOB","9","16","16","Olay pay pinaayagak sisya sin pangokoman ya tinongpal na, ammok ay adi na met laeng dengngen din salodsod ko. ");
INSERT INTO kne_vpl VALUES ("JB9_17","019_9_17","JOB","9","17","17","Olay magay gapo na, inpawada na di mansisilpo ay ligat ko. ");
INSERT INTO kne_vpl VALUES ("JB9_18","019_9_18","JOB","9","18","18","Adi na inpalobos ay makaleng-agak, tan pinno nan biyag ko si ladingit ya sakit di nemnem. ");
INSERT INTO kne_vpl VALUES ("JB9_19","019_9_19","JOB","9","19","19","Mo kanak en ipakat ko di bikas ko, magay makaiso sin bikas na. Mo idarum ko, ay sino di makaiparang en sisya sin pangokoman? ");
INSERT INTO kne_vpl VALUES ("JB9_20","019_9_20","JOB","9","20","20","Olay mo magay basol ko, makeddenganak pay dedan begew sin kalik. ");
INSERT INTO kne_vpl VALUES ("JB9_21","019_9_21","JOB","9","21","21","Magay basol ko ngem adiak sakiten di biyag ko, tan enggay naomaak ay manbibiyag. ");
INSERT INTO kne_vpl VALUES ("JB9_22","019_9_22","JOB","9","22","22","Tan iso met laeng. Olay nakabasol tako ono maga et nan-iiso ay peslen Diyos datako.” ");
INSERT INTO kne_vpl VALUES ("JB11_1","019_11_1","JOB","11","1","1","Nankali abe si Zofar ay taga-Naama yan kanana, ");
INSERT INTO kne_vpl VALUES ("JB11_2","019_11_2","JOB","11","2","2","“Ay siya mo magay manongbat issan ad-ado ay kali? Ay maibilang di ipogaw ay nalinteg mo paad-adoenan kali na? ");
INSERT INTO kne_vpl VALUES ("JB11_3","019_11_3","JOB","11","3","3","Ay kanam en paginkem dakami sin ad-ado ay kalim ya maga di mamagbaga en sik-a sin panglaslasoyam en Diyos? ");
INSERT INTO kne_vpl VALUES ("JB11_4","019_11_4","JOB","11","4","4","Kanam en tet-ewa din ibagbagam ya nalinis ka sin pangiilaan Diyos. ");
INSERT INTO kne_vpl VALUES ("JB11_5","019_11_5","JOB","11","5","5","Ngem mo mankali koma si Diyos ta songbatan daka, ");
INSERT INTO kne_vpl VALUES ("JB11_6","019_11_6","JOB","11","6","6","ta ipaammo na di laing ay naligat ay maawatan di ipogaw, maammoam ay nalaglag-an pay laeng din dosa ay indawat nan sik-a mo din basol mo. ");
INSERT INTO kne_vpl VALUES ("JB11_7","019_11_7","JOB","11","7","7","“Ay maawatam di naoneg ay banag maipanggep en Diyos ya maawatam ay kosto din panakabalina? ");
INSERT INTO kne_vpl VALUES ("JB11_8","019_11_8","JOB","11","8","8","Din ammon Diyos et nangatngato mo ed daya ya naon-oneg mo din kad-an di natey. Ay siya mo makad-as ka ono maawatam? ");
INSERT INTO kne_vpl VALUES ("JB11_9","019_11_9","JOB","11","9","9","Din kinangaton Diyos et dakdake mo nan daga ya annawa mo din baybay. ");
INSERT INTO kne_vpl VALUES ("JB11_10","019_11_10","JOB","11","10","10","“Mo depapen ya ibalod nas sik-a ono idarum daka sin pangokoman, maga polos di makalapped en sisya. ");
INSERT INTO kne_vpl VALUES ("JB11_11","019_11_11","JOB","11","11","11","Ammo na di kinasikap di ipogaw ya il-ilaena din basol da et adi na liw-an. ");
INSERT INTO kne_vpl VALUES ("JB11_12","019_11_12","JOB","11","12","12","Mabalin ay lomaing di naong-ong ay ipogaw mo maianak ay naamo din atap ay animal. ");
INSERT INTO kne_vpl VALUES ("JB11_13","019_11_13","JOB","11","13","13","Isonga pasigedem san nemnem mo ta mankararag ka en Diyos. ");
INSERT INTO kne_vpl VALUES ("JB11_14","019_11_14","JOB","11","14","14","Mo dokogam din lawa ay ogalim ya adi kan ipalobos ay mantee di basol sin beey mo, ");
INSERT INTO kne_vpl VALUES ("JB11_15","019_11_15","JOB","11","15","15","magay panbainam ya pan-egyatam ay somango sin kaipoipogaw.” ");
INSERT INTO kne_vpl VALUES ("JB12_1","019_12_1","JOB","12","1","1","Kanan Job ay nanongbat, ");
INSERT INTO kne_vpl VALUES ("JB12_2","019_12_2","JOB","12","2","2","“Dakayo met kayman din nalaing ay ipogaw et mo matey kayo, makikatey di laing en dakayo. ");
INSERT INTO kne_vpl VALUES ("JB12_3","019_12_3","JOB","12","3","3","Ngem wada abe di nemnem ko ay kaman si dakayo. Magay nanlasinan yo en sak-en, tan ammon di amin ay ipogaw din amin ay inbaga yo. ");
INSERT INTO kne_vpl VALUES ("JB12_4","019_12_4","JOB","12","4","4","Somis-iyek din gagayyem ko olay mo nalintegak ay ipogaw ay magay maipabasol en sak-en. Nankararagak met en Diyos et sinongbatana. ");
INSERT INTO kne_vpl VALUES ("JB12_5","019_12_5","JOB","12","5","5","Magay ligat yo yan somisiyek kayo. Palpaligaten yo di ipogaw ay nganngani ay matokang. ");
INSERT INTO kne_vpl VALUES ("JB12_6","019_12_6","JOB","12","6","6","Ngem din mangakew yan natalna di biyag da. Siya abe sin adi emegyat en Diyos ya say diyos da din bikas da. ");
INSERT INTO kne_vpl VALUES ("JB13_1","019_13_1","JOB","13","1","1","“Din amin ay inbagbaga yo et dinngek abe ya maawatak. ");
INSERT INTO kne_vpl VALUES ("JB13_2","019_13_2","JOB","13","2","2","Ammok abe din ammo yo, magay nanlasinan yo. ");
INSERT INTO kne_vpl VALUES ("JB13_3","019_13_3","JOB","13","3","3","Ngem si Diyos ay Manakabalin Amin di laydek ay kasongbat ko ta makinilawagak en sisya. ");
INSERT INTO kne_vpl VALUES ("JB13_4","019_13_4","JOB","13","4","4","Dakayo et man-etek kayo ay mangwani en waday binmasolak. Kaman kayon doktor ay magay mailatonan ay agasana. ");
INSERT INTO kne_vpl VALUES ("JB13_5","019_13_5","JOB","13","5","5","Agpos et gominek kayo tan siya say kostos amagen yo. ");
INSERT INTO kne_vpl VALUES ("JB13_6","019_13_6","JOB","13","6","6","Dengngen yo et din iyat ko ay manpalawag maipanggep en sak-en.” ");
INSERT INTO kne_vpl VALUES ("JB13_20","019_13_20","JOB","13","20","20","“Way dowa ay banag ay kedawek en sik-a ay Diyos, et adiak padasen ay itabonan sik-a. ");
INSERT INTO kne_vpl VALUES ("JB13_21","019_13_21","JOB","13","21","21","Isaldeng mo koma ay pomalpaligat ya ipalobos mo koma ta baken palalo di egyat ko ay makisango en sik-a. ");
INSERT INTO kne_vpl VALUES ("JB13_22","019_13_22","JOB","13","22","22","Mankali ka ta songbatak ono sak-en di mankali ta songbatam. ");
INSERT INTO kne_vpl VALUES ("JB13_23","019_13_23","JOB","13","23","23","Piga aya di inamag ko ay basol? Ipaammom kod di binmasolak ya nankolkolangak. ");
INSERT INTO kne_vpl VALUES ("JB14_1","019_14_1","JOB","14","1","1","“Amin ay ipogaw et aptik ya naligat di biyag da. ");
INSERT INTO kne_vpl VALUES ("JB14_2","019_14_2","JOB","14","2","2","Kaman dan sabsabong ay gomabay ngem si awni et malaylay da. Kaman da aben alidong di liboo ay sinkaattikan yan malabas ya mamaga. ");
INSERT INTO kne_vpl VALUES ("JB14_3","019_14_3","JOB","14","3","3","Mo kaman nidi di kasasaad ko, apay nga omila ka ay Diyos ta okomem sak-en sin sangoanam? ");
INSERT INTO kne_vpl VALUES ("JB14_4","019_14_4","JOB","14","4","4","Adi met mabalin ay pabalaen di nalinis sin kadodogis. ");
INSERT INTO kne_vpl VALUES ("JB14_5","019_14_5","JOB","14","5","5","Kineddengam di bilang di agew ya bowan ay panbiyagan di ipogaw. Kineddengam di kaandon di biyag da et adi mabalin ay mabaliwan. ");
INSERT INTO kne_vpl VALUES ("JB14_6","019_14_6","JOB","14","6","6","Adi ka koman il-ilaen daida. Baybay-am koma ay ganasen da din naligat ay biyag da mo mabalin. ");
INSERT INTO kne_vpl VALUES ("JB14_7","019_14_7","JOB","14","7","7","“Mo mapoyo di kaiw et waday namnama na ay mabiyag ya mansaringit. ");
INSERT INTO kne_vpl VALUES ("JB14_8","019_14_8","JOB","14","8","8","Olay mo mabayag ta kaman natey din lamot ya poona, ");
INSERT INTO kne_vpl VALUES ("JB14_9","019_14_9","JOB","14","9","9","ngem no masibogan et mansaringit ya gomabay ay kaman baro ay mola. ");
INSERT INTO kne_vpl VALUES ("JB14_10","019_14_10","JOB","14","10","10","Ngem no matey di ipogaw, mamaga di bikas na. Mo enggay nasokpot di leng-ag na, into pay di kad-ana? ");
INSERT INTO kne_vpl VALUES ("JB14_11","019_14_11","JOB","14","11","11","Kaman din posong ya ginawang ay matdok, ");
INSERT INTO kne_vpl VALUES ("JB14_12","019_14_12","JOB","14","12","12","say kaiarigan di ipogaw ay matey et adi kasin bomangon enggana ay mamaga amin ay wadad daya. ");
INSERT INTO kne_vpl VALUES ("JB14_13","019_14_13","JOB","14","13","13","“Apo Diyos, omitabon ka koma sin kad-an di natey enggana ay makaan din bonget mo, ta asi kan ikeddeng di timpo ay nemnemem kasin sak-en. ");
INSERT INTO kne_vpl VALUES ("JB14_14","019_14_14","JOB","14","14","14","Mo matey di ipogaw, ay matago kasin? Mo tet-ewa koma na, maanosak nan timpon di ligat ko et namnamaek ay mabaroan to di biyag ko.” ");
INSERT INTO kne_vpl VALUES ("JB19_1","019_19_1","JOB","19","1","1","Pag kanan Job, ");
INSERT INTO kne_vpl VALUES ("JB19_2","019_19_2","JOB","19","2","2","“Pig-an pay di somaldengan yo ay pomalpaligat ya domisdismaya begew sin ibagbaga yo? ");
INSERT INTO kne_vpl VALUES ("JB19_3","019_19_3","JOB","19","3","3","Ay magay bain yo et namin piga ay inmin-insolto kayo? ");
INSERT INTO kne_vpl VALUES ("JB19_4","019_19_4","JOB","19","4","4","Olay kaspangarigan waday inpaksaw ko, ay sino ngin di biyang yo? ");
INSERT INTO kne_vpl VALUES ("JB19_5","019_19_5","JOB","19","5","5","Kanan yo en sigsiged kayo mo sak-en et ibilang yo nan naibabainak ay mangpaneknek si basol ko. ");
INSERT INTO kne_vpl VALUES ("JB19_6","019_19_6","JOB","19","6","6","Ay adi kayo ayan ilan ay si Diyos di nangikeddeng si baken kosto en sak-en? Et naknaak sin tagdey na. ");
INSERT INTO kne_vpl VALUES ("JB19_7","019_19_7","JOB","19","7","7","Mo manpakaasiak begew sin mapalpaligatak, maga di somongbat. Adi mapatgan din kedkedawek ay nalinteg koma di maikeddeng en sak-en. ");
INSERT INTO kne_vpl VALUES ("JB19_8","019_19_8","JOB","19","8","8","Sinawad Diyos sak-en ya inpabolinget na din pandanak et adiak makalosot. ");
INSERT INTO kne_vpl VALUES ("JB19_9","019_19_9","JOB","19","9","9","Kinaana amin ay kinabaknang ko ya dinadael na din dayaw ko. ");
INSERT INTO kne_vpl VALUES ("JB19_10","019_19_10","JOB","19","10","10","Sin amin ay pansagongak yan pomaligat enggana ay mateyak. Maopay abe din namnamak ay kaman kaiw ay nagabot ya nalaylay. ");
INSERT INTO kne_vpl VALUES ("JB19_11","019_19_11","JOB","19","11","11","Palalo din bonget na en sak-en et omibilang ay kalabana. ");
INSERT INTO kne_vpl VALUES ("JB19_12","019_19_12","JOB","19","12","12","Di kaiarigana et inbaa na di sosoldado ay gomobat. Linmikob da ay kamanak wada sin siyodad et nan-amag das somakyaban da ay manadael sin alad na, ngem din katet-ewa na yan owat tolda di kad-ak. ");
INSERT INTO kne_vpl VALUES ("JB19_13","019_19_13","JOB","19","13","13","“Inpaaddawi nan sak-en din toton-od ya gagayyem ko ");
INSERT INTO kne_vpl VALUES ("JB19_14","019_19_14","JOB","19","14","14","et tinmaynan da. ");
INSERT INTO kne_vpl VALUES ("JB19_15","019_19_15","JOB","19","15","15","Linmingling din sasangailik yan omibilang din babag-en ko ay mangiliak. ");
INSERT INTO kne_vpl VALUES ("JB19_16","019_19_16","JOB","19","16","16","Mo waday ayagak en daida yan adi da somongbat, olay mo manpakpakaasiak ay bomadang koma. ");
INSERT INTO kne_vpl VALUES ("JB19_17","019_19_17","JOB","19","17","17","Adi itoled asawak ay manongsong sin leng-ag ko. Sigaan da abe ay somag-en din toton-od ko. ");
INSERT INTO kne_vpl VALUES ("JB19_18","019_19_18","JOB","19","18","18","Olay din anan-ak yan lomaslasoy da ya somisiyek da mo omila da. ");
INSERT INTO kne_vpl VALUES ("JB19_19","019_19_19","JOB","19","19","19","Omibilang da ay kadodogis din kasag-enan ay gagayyem ko yan linmaksig da din ipatpateg ko. ");
INSERT INTO kne_vpl VALUES ("JB19_20","019_19_20","JOB","19","20","20","Enggay owat kodil di namobongon sin tong-ak et nganngani di kateyak. ");
INSERT INTO kne_vpl VALUES ("JB19_21","019_19_21","JOB","19","21","21","“Maseg-ang kayo paabe ay gagayyem ko tan nay dinmosa si Diyos. ");
INSERT INTO kne_vpl VALUES ("JB19_22","019_19_22","JOB","19","22","22","Apay nga pomaligat kayo abe ay kaman din am-amagen Diyos? Ay adi kayo pay laeng mapnek ay pomalpaligat? ");
INSERT INTO kne_vpl VALUES ("JB19_23","019_19_23","JOB","19","23","23","Mo wada komay mangisolat sin ibagbagak ta mailibro da. ");
INSERT INTO kne_vpl VALUES ("JB19_24","019_19_24","JOB","19","24","24","Ono maitiktik si bato asi mapey-an si ismay ta say komakaman si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("JB19_25","019_19_25","JOB","19","25","25","Ngem mo sak-en pay, ammok ay matmatago din Somalaknib. Sisya di maodi ay mankali et ipaneknek na isnan daga ay magay basol ko. ");
INSERT INTO kne_vpl VALUES ("JB19_26","019_19_26","JOB","19","26","26","Olay madadael nan kodil ko gapo si sakit, ammok ay mailak to si Diyos. ");
INSERT INTO kne_vpl VALUES ("JB19_27","019_19_27","JOB","19","27","27","Ilaen to nan mismo ay mata ay baken odom. Ay apaw nan palalo ay layad ko ay matongpal koma di. Kaman enggay namagay pigsan di nemnem ko.” ");
INSERT INTO kne_vpl VALUES ("JB31_1","019_31_1","JOB","31","1","1","“Inkarik ay adiak manemnem di lawa mo ilaek di esa ay balasang. ");
INSERT INTO kne_vpl VALUES ("JB31_2","019_31_2","JOB","31","2","2","Sino ngin di gon-gona ay idawat Diyos ed langit ay Manakabalin Amin? ");
INSERT INTO kne_vpl VALUES ("JB31_3","019_31_3","JOB","31","3","3","Ay baken ayan ligat di ipalak-am na sin mangam-amag si lawa? ");
INSERT INTO kne_vpl VALUES ("JB31_4","019_31_4","JOB","31","4","4","Ammon met Diyos din am-amagek tan il-ilaena amin ay gonay ko. ");
INSERT INTO kne_vpl VALUES ("JB31_5","019_31_5","JOB","31","5","5","“Isapatak ay adiak nakitimtimpoyog si makaetek ya maga polos di in-etekak. ");
INSERT INTO kne_vpl VALUES ("JB31_6","019_31_6","JOB","31","6","6","Olay timbangen Diyos sak-en sin kosto ay timbangana et maila na ay maga di maipabasol en sak-en. ");
INSERT INTO kne_vpl VALUES ("JB31_7","019_31_7","JOB","31","7","7","Mo nasangawak sin kosto ay danan ono nan-gamgamak si inilak ono namansaan si basol nan takkay ko, ");
INSERT INTO kne_vpl VALUES ("JB31_8","019_31_8","JOB","31","8","8","olay madadael din molak ono odom ay ipogaw di mangan sin apit ko. ");
INSERT INTO kne_vpl VALUES ("JB31_9","019_31_9","JOB","31","9","9","“Mo inarem ko di asawan di tinokmang ko ta sinsin-ed ko sin segpan da, ");
INSERT INTO kne_vpl VALUES ("JB31_10","019_31_10","JOB","31","10","10","olay mansilbi si asawak si odom ay ipogaw ono daagen di odom ay lalaki. ");
INSERT INTO kne_vpl VALUES ("JB31_11","019_31_11","JOB","31","11","11","Tan nadagsen di ay basol et lebbeng na ay madosaak sin sangoanan di linteg. ");
INSERT INTO kne_vpl VALUES ("JB31_12","019_31_12","JOB","31","12","12","Kaman mabidang ay apoy ay dadlon manadael en sak-en ya siya abe sin sanikwak. ");
INSERT INTO kne_vpl VALUES ("JB31_13","019_31_13","JOB","31","13","13","“Mo waday bag-en ko ay nanriri en sak-en yan adiak pinatgan din kalintegana, ");
INSERT INTO kne_vpl VALUES ("JB31_14","019_31_14","JOB","31","14","14","into pay di ibagak mo somangoak en Diyos sin pangokomana? ");
INSERT INTO kne_vpl VALUES ("JB31_15","019_31_15","JOB","31","15","15","Si Diyos di namke en sak-en sin eges en inak yan si Diyos met laeng di nangamag abe sin babag-en ko. ");
INSERT INTO kne_vpl VALUES ("JB31_16","019_31_16","JOB","31","16","16","“Adiak inpaidam di badang ko sin nabiteg ya adiak inpalobos ay komaseseg-ang di biyag din nankalalasang. ");
INSERT INTO kne_vpl VALUES ("JB31_17","019_31_17","JOB","31","17","17","Adiak met binaybay-an din naolila ay mandagdagaang yan sak-en anggoy di mangmangan. ");
INSERT INTO kne_vpl VALUES ("JB31_18","019_31_18","JOB","31","18","18","Tan manipod ed idi, kanayon ay idawdawat ko din masapol da. ");
INSERT INTO kne_vpl VALUES ("JB31_19","019_31_19","JOB","31","19","19","Mo waday inilak ay nabiteg ay adi makalako si bado na, ");
INSERT INTO kne_vpl VALUES ("JB31_20","019_31_20","JOB","31","20","20","indawtak si bado ay napo sin dotdot di karnerok ta say adi maskaw et palalo di iyamana. ");
INSERT INTO kne_vpl VALUES ("JB31_21","019_31_21","JOB","31","21","21","Mo waday sinowitik ko ay olila gapo ta ammok ay mangabakak sin pangokoman, ");
INSERT INTO kne_vpl VALUES ("JB31_22","019_31_22","JOB","31","22","22","olay magotlo nan takkay ko ta maisian sin padangak. ");
INSERT INTO kne_vpl VALUES ("JB31_23","019_31_23","JOB","31","23","23","Ngem adiak maamag di kaman nidi tan emegyatak sin domosaan Diyos ya gapo sin kinangato na. ");
INSERT INTO kne_vpl VALUES ("JB31_24","019_31_24","JOB","31","24","24","“Polos met ay adiak nantalek sin kinabaknang ko ");
INSERT INTO kne_vpl VALUES ("JB31_25","019_31_25","JOB","31","25","25","ya adiak malaydan sin ad-adoy sanikwak. ");
INSERT INTO kne_vpl VALUES ("JB31_26","019_31_26","JOB","31","26","27","Adiak inongoan din takkay ko ay mangdayaw sin agew ay napigsa di silaw na ya din bowan ay mapteng di kailaana. Adiak polos nasolisog ay nandayaw en daida. ");
INSERT INTO kne_vpl VALUES ("JB31_28","019_31_28","JOB","31","28","28","Mo say inyat ko koma, makeddenganak koma ay matey, tan bakenak napodno en Diyos ay wadad ngato. ");
INSERT INTO kne_vpl VALUES ("JB31_29","019_31_29","JOB","31","29","29","“Adiak maragsakan sin domteng ay ligat ya lawa ay pasamak sin biyag di mangililiget en sak-en. ");
INSERT INTO kne_vpl VALUES ("JB31_30","019_31_30","JOB","31","30","30","Adiak inkarkararag di kateyan da tan mo say iyat ko et bomasolak. ");
INSERT INTO kne_vpl VALUES ("JB31_31","019_31_31","JOB","31","31","31","Ammon di amin ay mansilsilbi en sak-en ay maga di sinangailik ay nandagaang. ");
INSERT INTO kne_vpl VALUES ("JB31_32","019_31_32","JOB","31","32","32","Adiak binay-an ay maseyep da sin kalsada din nanbibiyahi mo adi et sinangailik daida. ");
INSERT INTO kne_vpl VALUES ("JB31_33","019_31_33","JOB","31","33","33","Bakenak met kaman din odom ay ilimed da di basol da. ");
INSERT INTO kne_vpl VALUES ("JB31_34","019_31_34","JOB","31","34","34","Adiak in-giginek ya adiak aben nanpopokok anggoy sin beey ko, tan adiak egyatan di mabalin ay ibagan di ipogaw ono lomaslasoyan di aag-ik. ");
INSERT INTO kne_vpl VALUES ("JB31_35","019_31_35","JOB","31","35","35","“Wada koma di mannge en sak-en, tan isapatak ay dadlon tet-ewa din am-in ay inbagak. Sapay koma ta somongbat si Diyos ay Manakabalin Amin. Mo maisolat koma din pamabasol di kalaban ko ta maipaila en sak-en, ");
INSERT INTO kne_vpl VALUES ("JB31_36","019_31_36","JOB","31","36","36","malaydanak ay mangitakap sin badok ono mangibedbed ta ilaen di kaipoipogaw. ");
INSERT INTO kne_vpl VALUES ("JB31_37","019_31_37","JOB","31","37","37","Adiak mabain ay somango en Diyos ta ipaammok en sisya amin ay inamag ko. ");
INSERT INTO kne_vpl VALUES ("JB31_38","019_31_38","JOB","31","38","38","“Mo pinnos ko koma din daga ay molmolaak, ");
INSERT INTO kne_vpl VALUES ("JB31_39","019_31_39","JOB","31","39","39","ono kinan ko di apit ay adiak binayadan ya say begew ay nateyan di akin oka, ");
INSERT INTO kne_vpl VALUES ("JB31_40","019_31_40","JOB","31","40","40","olay say gomabay di logam ya pagat sin dagak imbis ay bakakew ya sabog.” Say nakdengan di inbagan Job. ");
INSERT INTO kne_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Idi siya di, sinongbatan Diyos si Job babaen si napigsa ay dagem yan kanana, ");
INSERT INTO kne_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","“Sino ka ay mangipalawlawa sin sirib ko? Ipaammom sin kalim ay magay ammom. ");
INSERT INTO kne_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","Ipailam di kinalalakim ta songbatam din salodsod ko. ");
INSERT INTO kne_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","“Intoy kad-am idi insaad ko nan lobong? May kod, mankali ka mo waday ammom. ");
INSERT INTO kne_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","Sino di nangikeddeng si lokod na? Sino di nanlokod si kaannawa na? Ammom amin na, ay baken siya? ");
INSERT INTO kne_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","Intoy naisaadan din tokod di daga? Sinoy nangiamag sin naisaadana? ");
INSERT INTO kne_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","Sin parbangon di agew ay doy, nan-es-esa ay nankanta din tatalaw ya nanbogaw din aanghel gapo si ragsak da. ");
INSERT INTO kne_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","“Sino di nangin-eb ta matngel din baybay idi kabala sin oneg di daga? ");
INSERT INTO kne_vpl VALUES ("JB38_9","019_38_9","JOB","38","9","9","Sak-en di nangipabado si liboo sin baybay et nilikomotak si bolinget. ");
INSERT INTO kne_vpl VALUES ("JB38_10","019_38_10","JOB","38","10","10","Insaad ko di beddeng din baybay et sinaradoak din eneb na. ");
INSERT INTO kne_vpl VALUES ("JB38_11","019_38_11","JOB","38","11","11","Et inbilin ko sin baybay, ‘Engganas sa et anggoy di gedeng mo. Iparit ko ay labsan din napigsa ay dalloyon mo din gindeng ko.’ ");
INSERT INTO kne_vpl VALUES ("JB38_16","019_38_16","JOB","38","16","16","“Ay inmey ka aya sin obbog sin oneg di baybay? Ay pinadas mo ay nandan sin lanad na? ");
INSERT INTO kne_vpl VALUES ("JB38_17","019_38_17","JOB","38","17","17","Ay naipailan sik-a din segpan di mabolinget ay kad-an di natey? ");
INSERT INTO kne_vpl VALUES ("JB38_18","019_38_18","JOB","38","18","18","Ay ammom di kadakdaken din daga? Somongbat ka mo ammom dana. ");
INSERT INTO kne_vpl VALUES ("JB38_19","019_38_19","JOB","38","19","19","Ay ammom di panbeeyan di pat-a ya bolinget? ");
INSERT INTO kne_vpl VALUES ("JB38_20","019_38_20","JOB","38","20","20","Ay kabaelam ay ipangos daida sin somaaan da? ");
INSERT INTO kne_vpl VALUES ("JB38_21","019_38_21","JOB","38","21","21","Mo siya ay kabaelam, adi pay wada ka sin timpo ay naparsuaan di lobong. Enggay nakanakay ka baw kayman!” ");
INSERT INTO kne_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Kanan Job ay nanongbat en Diyos, ");
INSERT INTO kne_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","“Ammok ay magay adi kan kabaelan ay amagen et matongpal amin ay laydem. ");
INSERT INTO kne_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","Dinamag mo mo sinoak ay mangipalawlawa sin sirib mo olay magay ammok. Tet-ewa baw kayman ay din inbagbagak yan banag ay nakaskasdaaw ya adiak maawatan. ");
INSERT INTO kne_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Kanam en dengngek din ibagam ya songbatak din salodsod mo. ");
INSERT INTO kne_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Ed idi kayman, nadamdamag ko anggoy di maipanggep en sik-a, ngem ed wani mailak sik-a ay mismo. ");
INSERT INTO kne_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Isonga ibabawik din amin ay inbagak et nay tinmotokdoak sin tapok ya dap-o ay mangipaila ay manbabawiak.” ");
INSERT INTO kne_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","7","Idi nakdeng din inbagan Diyos en Job, kanana en Elifaz ay taga-Teman, “Mabongetak en sik-a ya sin dowa ay gagayyem mo tan baken kosto di inbaga yo maipanggep en sak-en, ay baken kaman si Job ay mansilsilbi en sak-en. ");
INSERT INTO kne_vpl VALUES ("JB42_8","019_42_8","JOB","42","8","8","Isonga ed wani, en kayo man-a si pito ay bomaro ay baka ya pito ay kalakian ay karnero. Asi kayo emey en Job ta man-idaton kayo si daton ay mapooan para en dakayo. Ikararaganas dakayo et awatek din kararag na ta adiak dosaen dakayo sin lebbeng na ay dosa yo, tan baken kosto di inbaga yo maipanggep en sak-en ay baken kaman si Job.” ");
INSERT INTO kne_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","Tinongpal da Elifaz en Bildad ya si Zofar din inbilin Diyos ay amagen da et pinatgan Diyos din kararag Job. ");
INSERT INTO kne_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Idi nakdeng ay inkararagan Job din gagayyem na, inpabaknang Diyos kasin sisya et nandobliena din sigod ay kinabaknang na. ");
INSERT INTO kne_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Pag emey sin beey na amin din aag-i na ya din sigod ay gagayyem na ta en da makikan ya makiragsak en sisya. Nakirikna da ya niliwliwa da sin ligat ay inpalak-am Diyos en sisya. Saes-a da ay nan-idawat si pilak ya singsing ay balitok. ");
INSERT INTO kne_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Ad-ad-ado di bindisyon Diyos en Job sin odi na mo sin damo, et nawad-an si 14,000 ay karnero, 6,000 ay kamel, 2,000 ay baka ya 1,000 ay dangki. ");
INSERT INTO kne_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Nabindisyonan pay si pito ay anak ay lalaki ya tolo ay babai. ");
INSERT INTO kne_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","Nginadanana si Jemima din pangpangoan, si Kezia din maikadwa, yan si Keren-Happuk din maikatlo. ");
INSERT INTO kne_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","Magay babai isnan intiro ay lobong ay napinpintas mo din an-ak Job ay sana. Tinawidan aben Job ay ama das daida ay kaman din lallalaki ay aag-i da. ");
INSERT INTO kne_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Idi nakdeng di, natago pay si Job si 140 ay tawen et naila na pay din ap-o na ya olay din an-ak di ap-o na. ");
INSERT INTO kne_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Et enggay nakay sin nateyana. ");
INSERT INTO kne_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Nagasat di ipogaw ay kaman nina di ogali na: din pamagbagan di lawa ay ipogaw et sigaana yan adi na tadonen din kabibiyag da. Adi aben makikadkadwa en daida, tan si Diyos di laslasoyen da. ");
INSERT INTO kne_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Mo adi et din kalin Diyos di ad-adalena, tan siya na di panragragsakana. Inagew ya linabi et nemnemnemena et kanayon ay say on-onodana. ");
INSERT INTO kne_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Isonga amin di sino ay amagena et mayat di pantongpalana. Magmagabay ay kaiw di kaiarigana, sin benget di ginawang et say kad-ana. Adi mangmango di tobo na et manlames sin timpo na. ");
INSERT INTO kne_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ngem din managbasol et baken kaman nina, kaman teg-ap ay itayaw di dagem di kaiisoan da. ");
INSERT INTO kne_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Tan sin agew ay pangokoman Diyos en daida, iwed polos di ipambal da. Keddengan Diyos dadi ay madosa, ikasina sin gimong di nalinteg ay ipogaw na. ");
INSERT INTO kne_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Tan din nalinteg et ay-ayowanan Diyos si daida, ngem din managbasol pay et maiturong das dosa. ");
INSERT INTO kne_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Apay nga nanplano din nanasyon si magay silbi na? Apay nga panggep da ay labanen si Diyos ay wada ed daya? ");
INSERT INTO kne_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Din aari isnan daga, nasinop ya nansagana da ta gobaten da si Diyos ya din ari ay dinotokana. ");
INSERT INTO kne_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Kanan da, “Labanen tako din turay da ta en tako makawaya.” ");
INSERT INTO kne_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ngem masis-iyek si Diyos sin trono na ed daya ay manglaslasoy en daida. ");
INSERT INTO kne_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Pag nan yamyaman si daida et palalo di egyat da sin manpoos ay bonget na. ");
INSERT INTO kne_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Kanana, “Din pinilik ay ari et insaad ko ed Zion ay nasantoan ay dontog ko.” ");
INSERT INTO kne_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kanan din ari, “Ibagak din bilin Diyos Apo. Kananan sak-en, ‘Sik-a din anak ko. Ed wani ay agew, ipailak ay sak-en si tatang mo. ");
INSERT INTO kne_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Mo mankedaw ka, amin ay nasyon et idawat ko, amin ay wadas nan daga et tawid mo. ");
INSERT INTO kne_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Awni et dadlon kan abaken daida, ay kaman din kalakan di kagopakan di kalamba.’” ");
INSERT INTO kne_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Isonga dakayo ay aari ya turay isnan daga, dengngen yo nan pamagbaga. ");
INSERT INTO kne_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Emegyat kayo ya patgen yo si Diyos koma sin mansilsilbian yo en sisya. ");
INSERT INTO kne_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Mandokmog kayo sin anak na ya manpakombaba kayo tan amangan mo bigla ay bomonget din Apo et sigurado ay matey kayo. Nagasat amin ay komamang en Diyos Apo. ");
INSERT INTO kne_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Sik-a ay Diyos, ilaem kod di kaad-adon di komonkontra, din kaibaw ko et ad-ado da. ");
INSERT INTO kne_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Lomaslasoy da pay ay kankanan da, “Ilaen yo et adi man badangan Diyos sisya.” ");
INSERT INTO kne_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Ngem kaman kan kasay ay salaknib ko, isonga laton ay abakek din kaibaw ko. Idawat mo kasin din dayaw ko, et papigsaem nan nemnem ko. ");
INSERT INTO kne_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Mo man-adawagak ay mankedaw si badang mo, songbatam sak-en sin nasantoan ay dontog mo. ");
INSERT INTO kne_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ed labi, inbaktad ko ta maseyepak, et laton ay maga di nandanagak enggana sin kasinak binmangonan, tan wada ka ay mangay-ayowan. ");
INSERT INTO kne_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Olay mo linmilikob di kalibolibo ay kagobat ko, adiak emegyat tan sik-a di salaknib ko. ");
INSERT INTO kne_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Diyos ay Apok, dalasem ta omisalakan ka. Tan din kagobat ko et kanayon ay dinosdosam daida et kinakaan mo san kabaelan da. ");
INSERT INTO kne_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Sik-a anggoy di makaisalakan, sapay koma ta din ipogaw mo et bindisyonam. ");
INSERT INTO kne_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Sik-a ay Diyos ay mangitonton sin kalintegak, somongbat ka kod mo mankararagak. Magay nanposiposak ed idi sin napaligatak, ngem gapo sin tolong mo, naiwayaanak. Ed wani, someg-ang ka ay Apo, ta dengngem kasin nan adawag ko. ");
INSERT INTO kne_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Dakayo ay ipogaw, pig-an ngin di somaldengan yo ay manglaslasoy ya mangibabain sin kaipogaw ko? Apay nga laylayden yo pay laeng din magay silbi na ya on-onodan yo din baken tet-ewa? ");
INSERT INTO kne_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Nemnemen yo ay si Diyos et inkasina din matalek ya nadiyosan ay ipogaw para en sisya, isonga din karkararag ko et dengdengngena. ");
INSERT INTO kne_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Manpayegpeg kayo komas egyat yo ya isaldeng yo san basol yo. Mo bomaktad kayo ta maseyep kayo, mannemnem kayo ay kosto. ");
INSERT INTO kne_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Mantalek kayo en Yahweh ay Diyos tako ya idawat yo en sisya di kosto ay daton yo. ");
INSERT INTO kne_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Ad-ado di mangwani, “Sino di mangipasiged sin biyag tako?” O Diyos, ipailam kod en dakami din layad ya seg-ang mo. ");
INSERT INTO kne_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Dakdakdake din ragsak ko ay indawat mo mo din ragsak di ad-adoy inani na ya din ad-adoy danom di obas ay arak na. ");
INSERT INTO kne_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Mo ibaktad ko ay maseyep, natalna di nemnem ko, tan sik-a anggoy, Yahweh, di salaknib ko. ");
INSERT INTO kne_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","2","Arik ya Diyos ko, patgam koma nan kararag ko, dengngem kod nan bayeweng ya adawag ko, tan sik-ay pankararagak, Apo. ");
INSERT INTO kne_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Inagsapa ay madngem din kararag ko, inagsapa ay ipaammok en sik-a din kedaw ko, yan sedsed-ek din songbat mo. ");
INSERT INTO kne_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Tan sik-a ay Diyos, kaliliget mo din lawa, adim ipalobos ay makitee di managbasol en sik-a. ");
INSERT INTO kne_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","6","Din mangipapangatos awak na yan adi makasag-en en sik-a, tan am-in ay mangam-amag si lawa— din maetek, manglilipot, ya makapese si ib-a na— kaliliget mo ya dosaem daida. ");
INSERT INTO kne_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ngem gapo sin adi manbalbaliw ay layad mo, mabalin ay makasgepak sin nasantoan ay Timplo. Patgek ya emegyatak en sik-a, Apo, et mandayawak sin sana ay beey mo. ");
INSERT INTO kne_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Omipango ka kod, Apo, begew sin kinalinteg mo, itdom kod din pandanak ay kosto, tan ad-adoy kalaban ko. ");
INSERT INTO kne_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Din kalaban ko yan adi matalek di kali da, tan say an-anapen da din panadaelan das gait da. Kaman naisasagana ay kaot din tepek da. Pag boladas din kali da. ");
INSERT INTO kne_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Ay Diyos, keddengam ya dosaem komas daida ta mantaolin daida din lawa ay panggep da. Sin sangoanam, pakaanem komas daida, tan nanbasol ya kinontra das sik-a. ");
INSERT INTO kne_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ngem manragsak koma din mankamang en sik-a, et kanayon ay mankanta da si ragsak da. Salaknibam koma ay Diyos din manglaylayad en sik-a, et gapon sik-a, tet-ewa ay manragsak da. ");
INSERT INTO kne_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Tan bindisyonam din manongtongpal en sik-a. Din layad mo yan kaman kasay ay salaknib da. ");
INSERT INTO kne_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Adi ka kod yomamyam ya domosdosa, Apo, begew sin bonget mo. ");
INSERT INTO kne_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Maseg-ang ka ta pabikasem kasin nan awak ko, tan enggay kinmapsotak, palalo nan sakit ko. ");
INSERT INTO kne_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Palalo abe ay magolo nan nemnem ko. Pig-an pay ay pasaldengem nan ligat ko? ");
INSERT INTO kne_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Somagong ka kod ta omisalakan ka, Apo, gapo sin adi manbalbaliw ay layad mo. ");
INSERT INTO kne_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Tan sin kad-an di natey, magay mannemnem en sik-a, sin isdi magay mandayaw en sik-a. ");
INSERT INTO kne_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Gapo sin ladingit ko, kinmapsokapsotak. Linablabi ay man-og-ogaak sin kaseyseyepak, et mabasbasa din pongan ko si lowak. ");
INSERT INTO kne_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Begew sin kalaban ko, kinmapsot nan matak, tan linmadaladag da gapo si kaoogak. ");
INSERT INTO kne_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Dakayo ay mangam-amag si lawa, omaddawi kayo, tan dinngen Diyos din adawag ko, ");
INSERT INTO kne_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","et sigurado ay patgana din kararag ko. ");
INSERT INTO kne_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Maabak din kalaban ko et emegyat da. Dalasen da ay lomayaw gapo si bain da. ");
INSERT INTO kne_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Yahweh ay Diyos ko, komamangak en sik-a. Omisalakan ya somalaknib ka koma, tan din kalaban ko yan omapayaw da. ");
INSERT INTO kne_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Mo adi kan tomolong, dompap da, sin lugar ay magay omisalakan yan omiey da. Kaman dan layon, bomisngibisngit da. ");
INSERT INTO kne_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Yahweh ay Diyos ko, mo waday binmasolak si gait ko, ");
INSERT INTO kne_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","mo way nilipotak ay gayyem ko ono pinos ko din sanikwan di kalaban ko ay maga di gapo, ");
INSERT INTO kne_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","olay bay-am ay dompap din kalaban ko. Bay-am ay pomse da ya taynan da din bangkay ko sin lota. ");
INSERT INTO kne_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Pomika ka koma, Apo, gapo sin bonget mo ta sangoem din mabonget ay kalaban ko. Man-gonay ka ta bomadang ka, Diyos ko, tan waday timpo ay pangokomam ay inkeddeng mo. ");
INSERT INTO kne_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Sinopem din ipogaw sin kailiili ta likoben das sik-a. Tomokdo kad langit ay mangituray en daida. ");
INSERT INTO kne_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Sik-a di mangokom si am-in ay ipogaw, Apo. Ibagam di ikeddeng mon sak-en ta maammoan ay magay basol ko. ");
INSERT INTO kne_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Ammom di am-in ay panggep ya nemnem yan kosto am-in ay amagem. Topapem din mangamag si lawa yan gon-gonaam din nalinteg di ogali da. ");
INSERT INTO kne_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Isalakan Diyos din managtongpal en sisya. Sisya di somalaknib ay kaman kon salida. ");
INSERT INTO kne_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Nalinteg si Diyos sin pangokomana, kanayon ay dosaena din mangamag si lawa. ");
INSERT INTO kne_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Mo adi manbabawi di ipogaw, palidena din kampilana ya isagana na din pana na. ");
INSERT INTO kne_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Alaena din mankatatadem ay armas na yan ipaturong na din bomidbidang ay pana na. ");
INSERT INTO kne_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Ilaem din iyat di managbasol ay mannemnem si lawa. Manplanos manproblimaan ya ietekanay iib-a na. ");
INSERT INTO kne_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ngem sisya met laeng di makna sin bito ay inamag na para sin gagait na. ");
INSERT INTO kne_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Madosa gapo met laeng sin lawa ay am-amagena tan din panakitanas odom yan mantaoli met laeng en sisya. ");
INSERT INTO kne_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Diyos ay Kangatoan, man-iyamanak sin kinalinteg mo. Mankantaak ay mangidaydayaw sin ngadan mo. ");
INSERT INTO kne_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Diyos ay Apo mi, din panakabalin mo et maila sin intiro ay daga, din maidaydayawam et omabot ed daya! ");
INSERT INTO kne_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Olay din anan-ak ya momoyang ay mansossoso et ikankanta da din nabanol ay ngadan mo. Begew sina, gominek da din kaibaw mo. ");
INSERT INTO kne_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Mo tangadek ed daya ay inamag mo et mailak din bowan ya talaw ay insaad mo, ");
INSERT INTO kne_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Masmasdaawak et kankanak sin nemnem ko, “Sino aya di kasasaad di ipogaw ta nemnemnemem? Ay tan nabanol da od ta as-asikasoem?” ");
INSERT INTO kne_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Ngem insaad mo ay nababbaba si at-atik mo din nailangitan ay parsua. Kaman din dayaw di ari et indayaw mos daida, ");
INSERT INTO kne_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","tan inpaituray mo en daida din am-in ay wada. ");
INSERT INTO kne_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Iturayan da din matalaken ay karnero ya baka ya din atap ay aanimal sin kada. ");
INSERT INTO kne_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Siya abe din titit ay mantaytayaw ed daya, din nigay ay wada sin baybay ay annawa. ");
INSERT INTO kne_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Diyos ay Apo mi, din panakabalin mo et maila sin intiro ay daga. ");
INSERT INTO kne_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Naimposoan ay man-iyamanak en sik-a, Apo, dad-atek am-in din nakaskasdaaw ay inamag mo. ");
INSERT INTO kne_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Diyos ay Kangatoan, gapon sik-a palaloy ragsak ko, mankantaak ay mangidaydayaw sin ngadan mo. ");
INSERT INTO kne_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Lomayaw dan kalaban ko mo sangoen daka, matokang da ya matey da. ");
INSERT INTO kne_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Tan din iyat mo ay mangokom yan kosto, inkeddeng mo ay magay basol ko. ");
INSERT INTO kne_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Dinosam din ipogaw sin kailiili ay mangam-amag si lawa, pinonas mo et malinglingan das eng-enggana. ");
INSERT INTO kne_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Din kalaban mi, namingpingsan ay naabak da. Binakas mo din siyodad da, et malinglingan das eng-enggana. ");
INSERT INTO kne_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Ngem sik-a pay ay Diyos, magay pap-eng di panturayam. Insaad mo din tronom ay pangokomam. ");
INSERT INTO kne_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Am-in ay ipogaw isnan labaw di daga, Nalinteg ya kosto di iyat mo en daida. ");
INSERT INTO kne_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Din ipogaw ay paligaten di iib-a da, sik-a ay Diyos di pankamangan da sin timpon di ligat da. ");
INSERT INTO kne_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Talken daka sin nangammo en sik-a, tan adi kan baybay-an din mankamang en sik-a. ");
INSERT INTO kne_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Mankanta kayo ay mangidaydayaw en Diyos ay manturay ed Zion. Dad-aten yo din inamag na sin am-in ay nasyon. ");
INSERT INTO kne_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Adi linglingan Diyos din mapalpaligat ya din adawag da, et dosaena din mamalpaligat en daida. ");
INSERT INTO kne_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Maseg-ang ka ay Apo, ilaem nan pomalpaligatan di kaibaw ko. Sin pese omisalakan ka koma, ");
INSERT INTO kne_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","ta sin sangoanan di ipogaw ed Jerusalem, idaydayaw kos sik-a ya manragsakak tan inmisalakan ka. ");
INSERT INTO kne_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Din nanasyon yan nankaot da si bito ay nag-asan da yan siya met laeng di naknaan da. ");
INSERT INTO kne_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Inpaammom mo sino ka ay Apo babaen sin nalinteg ay panangokom mo. Ngem din mangam-amag si lawa, kaman tagdey ay mangna en daida din mismo ay am-amagen da. ");
INSERT INTO kne_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Pese di pantongpalan di mangam-amag si lawa. Katet-ewa na, am-in ay nanigaan en Diyos et say pantongpalan da. ");
INSERT INTO kne_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Ngem din kakkaasi, baken kanayon ay mabaybay-an da, adi aben makaan din namnama da. ");
INSERT INTO kne_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Apo, man-gonay ka koma, adi ka ipalobos ay makalisi di ipogaw en sik-a. Sinopem din nanasyon ta okomem daida. ");
INSERT INTO kne_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Apo, kibtotem man daida ta ammoen da ay owat dan ipogaw tet-ewa. ");
INSERT INTO kne_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Ay Diyos, apay nga omaddawi kan dakami? Apay nga mantabon ka sin timpon di ligat mi? ");
INSERT INTO kne_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Nangato di nemnem di ipogaw ay lawa, din kakkaasi yan palpaligaten da. Sapay koma ta makna da sin bito ay inamag da. ");
INSERT INTO kne_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Tan din mangam-amag si lawa ya mangamgamgam si baken dan oka et it-it-ek da din kabaelan da ay manongpal sin layden da. Sigaan daka ay Diyos ya palawlawaen das sik-a. ");
INSERT INTO kne_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Gapo sin kinangaton di nemnem da, adi da pagan-anos sik-a, tan magay lugar mo ay Diyos sin nemnem da. ");
INSERT INTO kne_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Matongpal din layden da sin am-in ay amagen da, ngem din pangokomam yan naligat ay maawatan da, laslasoyen da am-in din kalaban da. ");
INSERT INTO kne_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Kanan das nemnem da en maga polos di panligatan da ono mapasamak ay lawa en daida. ");
INSERT INTO kne_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Makabaos ya makaetek da. Eg-egyaten da abe din iib-a da ya nalaka ay mankali das kinekedse ya lawa. ");
INSERT INTO kne_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Sin asag-en di ili yan mantabon da ta manseed das peslen da, olay magay gapo na. ");
INSERT INTO kne_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Maiarig das layon ay man-eset ay mantabon, ta din kakkaasi yan en da depapen. Manganop di esa ay kaiarigan da, tan en da depapen din magay kabaelan da ay makna sin tagdey da. ");
INSERT INTO kne_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Gapo sin panakabalin da, din kakkaasi et abaken da. ");
INSERT INTO kne_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Kanan das nemnem da, “Adi pagan-anon Diyos din napasamak isna, tan nandokog et adi omila.” ");
INSERT INTO kne_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Dosaem koma ay Diyos dana ay mangam-amag si lawa, adi ka baybay-an din palpaligaten da. ");
INSERT INTO kne_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Magay rispito dan sik-a din mangam-amag si lawa, tan kanan das nemnem da en adi ka dosaen daida. ");
INSERT INTO kne_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Ngem katet-ewa na, iilaem din ligat di palpaligaten da, et nakasagana ka ay mamadang en daida, tan sik-ay pankamangan di kakkaasi ya naolila. ");
INSERT INTO kne_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Pakapsotem koma din mangam-amag si lawa, estem ay dosaen daida enggana ay ikaro da am-in ay basol da. ");
INSERT INTO kne_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Sik-a ay Diyos, magay patinggan di panturayam, ngem din manaydayaw si didiyosen, maponas da isnan ili ay dagam. ");
INSERT INTO kne_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Dengngem din kararag di kakkaasi et papigsaem din nemnem da. ");
INSERT INTO kne_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Ikalintegam di kakkaasi ya naolila ta magay ipogaw ay mangeg-egyat si iib-a da. ");
INSERT INTO kne_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Si Diyos di pankamangak. Ngem apay nga kanan yo en lomayawak ta kamanak titit ay sin dontog di emeyak? ");
INSERT INTO kne_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Kanan yo, “Doy ay isagsaganan din managbasol din pana da, panaen da sin mabolinget din nalinteg di ogali na. ");
INSERT INTO kne_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Mo mabakas di olnos, sino pay di maamag na din nalinteg di ogali na?” ");
INSERT INTO kne_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Wadas Diyos sin nasantoan ay Timplo na, ed langit di panturayana. Am-in ay ipogaw yan il-ilaena, ammo na am-in din am-amagen da. ");
INSERT INTO kne_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Din nalinteg ya managbasol yan timbangena, kaliliget na din malaylaydan ay mamalpaligat si iib-a na. ");
INSERT INTO kne_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Sin managbasol yan paodanena din man-gangab ay oling ya asufre ay kanan da. Man-atong ay dagem di dosa da. ");
INSERT INTO kne_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Tan nalinteg si Diyos et din siged ay ogali di laydena. Awni et ilaen di nalinteg sisya. ");
INSERT INTO kne_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Sik-a ay Diyos, bomadang ka koma, tan nay enggay magay nalinteg di ogali na, magay matalek si olay esa. ");
INSERT INTO kne_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Am-in ay ipogaw, man-asieetek da. Kaman mayat din kali da ngem baken baw tet-ewa. ");
INSERT INTO kne_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Apo, paginkem et koma din mangpaspasablog si ib-a da ya mangit-it-ek si awak da. ");
INSERT INTO kne_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Kanan da, “Babaen sin kali mi, magon-od mi di layden mi. Ibaga mi di layden mi, magay makaipasaldeng en dakami.” ");
INSERT INTO kne_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Ngem kanam, Apo, “Man-gonayak ed wani, tan mapalpaligat ya manbaybayeweng din kakkaasi. Idawat ko en daida din talna ay an-anapen da.” ");
INSERT INTO kne_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Apo, matalek ka sin insapatam. Din karim yan palata di ena kaiarigan, ay namin pito ay nalinisan. ");
INSERT INTO kne_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Am-in ay soli, likeden din mangam-amag si lawa, say it-it-ek di kaipoipogaw din kaloloya. Ngem sik-a ay Diyos, kanayon ay somalaknib ka sin ipogaw ay sana. ");
INSERT INTO kne_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Apo, kas-anoy kabayag na ay bomaybay-an ka? Ay bomaybay-an ka si eng-enggana? Pig-an pay ay somagong ka? ");
INSERT INTO kne_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Pig-an ay mapap-eng nan panlak-amak si ligat ko ya innagew ay ladingit ko? Kas-anoy kabayag nan omam-amisan di kalaban ko? ");
INSERT INTO kne_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Nemnemem komas sak-en, Yahweh ay Diyos ko, ya patgam din kararag ko. Omipabikas ka ta adi masokpot nan leng-ag ko. ");
INSERT INTO kne_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Adim ipalobos ay kanan da en inmabak da et begew sidi yan manragsak da. ");
INSERT INTO kne_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Ngem mantalekak sin adi manbalbaliw ay layad mo, manragsakak to sin panangisalakan mo. ");
INSERT INTO kne_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Mankantaak ay mangidaydayaw en sik-a, Apo, gapo sin inpailam en sak-en ay kinasiged mo. ");
INSERT INTO kne_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Kanan din naong-ong sin nemnem da, “Ay siya mo waday Diyos tet-ewa?” Kadodogis sin pangilan Diyos din lawa ay am-amagen da, dadlon makadadael din kabibiyag da. Magay olay esa si kosto di am-amagena. ");
INSERT INTO kne_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Si Diyos ed langit, os-osdongana di ipogaw isnan daga ta ilaena mo waday masirib en daida ay manganap ta ammoan das sisya. ");
INSERT INTO kne_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Ngem man-iiso da am-in ay lawlawa, tan din kosto ay danan et tinaynan da. Magay mangam-amag si kosto, maga di olay esa. ");
INSERT INTO kne_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Kanan Diyos ay nangibaga, “Ay daetan pay dana ay mangam-amag si lawa! Pig-an ngin di pannemneman da? Din pamalpaligatan da sin ipogaw ko et nalaka en daida ay kaman din kalakan di mangokmon si kanen da. Sigaan da abe ay mankararag en sak-en ay Diyos da koma.” ");
INSERT INTO kne_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Ngem peteg to di kibtot ya egyat da mo ilaen da ay salakniban Diyos din ipogaw na. ");
INSERT INTO kne_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Laslasoyen abe din ipogaw ay lawa din planon di nabibiteg ay magay kowinta na, ngem si Diyos pay et salaknibanas daida. ");
INSERT INTO kne_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Sapay koma ta si Yahweh ay manbeey ed Zion sin Timplo na et isalakana din Israelita ay ipogaw na. Am-in ay polin Israel et maragsakan da koma mo ipataolin Diyos din sigod ay kinabaknang da. ");
INSERT INTO kne_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Apo Diyos, sino ngin di waday kalebbengana ay senggep sin Timplom? Sino ngin di maikari ay mandayaw en sik-a sin nasantoan ay dontog mo ay Zion? ");
INSERT INTO kne_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Din makasgep et din kanayon ay manongtongpal en sik-a ya pag kosto am-in di am-amagena. Mo mankali abe et tet-ewa ya naimposoan di ibagbaga na. ");
INSERT INTO kne_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Adi na aben palawlawaen di iib-a na ono man-istoryas lawa maipanggep sin katokmang na. Iwed abe di amagena ay lawa en daida. ");
INSERT INTO kne_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Ibilang na ay magay pateg da din dinokogan Diyos begew sin basol da, ngem din mangipateg en Diyos et say bigbigena. Dadlonan tongpalen din inkari na olay mo siya na di begew si maligatana. ");
INSERT INTO kne_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Mo manpaotang sisya, maga iman di patang na. Adi aben mapasoksokan ay mantistigo si baken tet-ewa ay maikontra sin magay basol na. Din am-in ay manadon sina, magay lawa ay maamag en daida. ");
INSERT INTO kne_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Sik-a ay Diyos, somalaknib ka koma, tan din pankamangak et sik-a. ");
INSERT INTO kne_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Tet-ewa din inbagak ay sik-a di Diyos ko, sik-a anggoy di kapoan di siged isnan biyag ko. ");
INSERT INTO kne_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Din matalek ay ipogaw mo isnan daga, bigbigek din sigesiged ay ogali da et maragsakanak ay makikadkadwa en daida. ");
INSERT INTO kne_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Din mangdayaw si didiyosen, ad-ado ay ligat di en da lak-amen. Adiak maitapi en daida ay mangidaton si dada, sigaak abe ay mangibaga sin ngadan di didiyosen da. ");
INSERT INTO kne_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Ibilang kos sik-a, Apo, ay nabanol ay tawid ko, mapon sik-a am-in ay masapol ko. Sik-a di makaammo sin biyag kon to. ");
INSERT INTO kne_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Maymayat di inpatawid mo et palalo di ragsak ko. ");
INSERT INTO kne_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Man-iyamanak, Apo, tan bomagbaga ka. Olay sin labi et omitdo nan konsinsiya. ");
INSERT INTO kne_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Adiak emegyat, tan ammok ay komadkadwa ka, kankanayon abe ay bomadbadang ka. ");
INSERT INTO kne_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Isonga palalo di ragsak ko ya natalna di nemnem ko. ");
INSERT INTO kne_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Tan adi ka tomaynan sin kaot ko, adi ka aben ipalobos ay madonot nan awak ko, sak-en ay matalek ay bag-en mo. ");
INSERT INTO kne_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Din danan ay maiturong sin biyag et en ka itdo, makikadwaak en sik-a isonga peteg di ragsak ko. ");
INSERT INTO kne_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Sik-a ay Diyos, dengngem kod nan kararag ko ay manpakpakaasi si badang mo ta iturong mo kod din kosto, tan naimposoan nan kararag ko. ");
INSERT INTO kne_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ikeddeng mo koma ay maga di basol ko, tan ammom din kostokosto. ");
INSERT INTO kne_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ammom di wadas nemnem ko. Mo sin labi yan pomadas ka, Apo, mailam ay magay basol ko. Magay binmasolak begew sin tepek ko, ");
INSERT INTO kne_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","ay kaman din am-amagen di odom ay gagait ko. Din kedse da abe et baken say tinadtadon ko, mo adi tinongtongpal ko din inbagam ay bilbilin mo. ");
INSERT INTO kne_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Say kanayon ay inonodak din laydem, Apo, maga polos di nilabsing ko. ");
INSERT INTO kne_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Mankararagak en sik-a, Apo, tan patgam din kararag ko, isonga dengngem ta songbatam nan kararag ko. ");
INSERT INTO kne_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ipailam kod din nakaskasdaaw ay layad mo, tan sik-a di mangisalakan babaen sin panakabalin mo sin am-in ay mangan-anap si pankamangan da mo ilayawan da din kaibaw da. ");
INSERT INTO kne_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Bomantay ka ay kaman din iyat mo sin kabanolan ay gameng mo. Somalaknib ka sin payak mo ");
INSERT INTO kne_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","ta adi omdas din kalaban ko ay mankakekedse, tan nay linmikob da et layden da ay pomse. ");
INSERT INTO kne_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Magay seg-ang da ya natangsit di kali da. ");
INSERT INTO kne_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Enggay linmikob da, am-in ay emeyak yan wada da. Manseseed das mayat ay timpo ta pomse da. ");
INSERT INTO kne_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Kaman dan layon ay manseseed si kanen da, tan mantabon da ta manseed das doklosen da. ");
INSERT INTO kne_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Apo, din kalaban ko yan sangoem koma ta say abakem daida. Babaen sin kampilan mo, omisalakan ka sin mangam-amag si lawa. ");
INSERT INTO kne_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Babaen sin panakabalin mo, omisalakan ka koma sin ipogaw ay naimongsan di nemnem da sin gamgameng ay wadas nan daga. Mapnek da koma sin insaganam para en daida. Mansobsobra koma din an-ak da, ya wada abey mabay-an para sin apo da. ");
INSERT INTO kne_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Mo sak-en pay, mailak to din ropam, Apo, gapo ta magay lawa ay inamag ko. Mo bomangonak et manragsakak to gapo sin kawadam, Apo. ");
INSERT INTO kne_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Laylaydek si Yahweh ay Diyos ko, sisyay poon di bikas ko. ");
INSERT INTO kne_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Maiarig si dakdake ay bato ay enak pankamangan ono dontog ay enak pantabonan, tan napigsa ay omisalakan. Mo wadaak en sisya, magay pan-egyatan. Kasay ay somalaknib di ena kaiarigan, kaman aben mayat ay pantabonan ay adi makasgep di kalaban. ");
INSERT INTO kne_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Mankedawak si badang Diyos et omisalakan sin kalaban ko. Lebbeng na ay madayaw si Diyos Apo. ");
INSERT INTO kne_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","5","Din pese yan nangisagana si kaknaak koma ay tagdey. Kamanak napolipolan si tali ay omigoyod sin kad-an di natey, kaman omianod ay layos ono kaeegyat ay dalloyon ay domalapos. ");
INSERT INTO kne_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Sin palalo ay ligat ko, kindaw ko din badang Yahweh ay Diyos ko, et sin Timplo na, dinnge na din adawag ko. ");
INSERT INTO kne_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Pag manyegyeg ya naikiweg din daga, din naisaadan di dontog yan nagon-gon da gapo sin palalo ay bonget na. ");
INSERT INTO kne_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Bomalbala di asok sin eng na ya manbidbidang ay apoy sin tepek na. ");
INSERT INTO kne_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Binokatana ed langit et binmaba, waday mangitit ay liboo sin dallem di siki na. ");
INSERT INTO kne_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Binmaba ay nanlogan si kerubim, napigsa ay tinmayaw babaen sin payak di dagem. ");
INSERT INTO kne_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Binongona din awak na si bolinget, naposkol ay liboo ay nanapnos danom di nanlikmot. ");
INSERT INTO kne_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Waday kimat sin sangoanana, dalalo ya somilsilap ay apoy di inpawada na, din mangitit ay liboo yan nilosot da. ");
INSERT INTO kne_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Si Diyos ay kangatoan et nadnge din kali na, kaman kido ay mapo ed daya. ");
INSERT INTO kne_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Inosal na din pana na et nansisian din kalabana. Nankimatena et nanagtag da. ");
INSERT INTO kne_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Din lanad di baybay yan nabonsian da, siya abe sin naisaadan di daga, idi inpailan Diyos din palalo ay bonget na. ");
INSERT INTO kne_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ed langit ay kad-an Diyos, inadawa nas sak-en, et kinmay-at sin malosong ay danom. ");
INSERT INTO kne_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Sin omililiget ay kalaban ko, inmisalakan sisya, tan nankapipigsa da et magay bael kon daida. ");
INSERT INTO kne_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Dinmoklos da sin timpon di ligat ko, ngem wadas Diyos ay salaknib ko. ");
INSERT INTO kne_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Gapo sin layad nan sak-en, inmisalakan sisya, et inmiey sin lugar ay nawaya. ");
INSERT INTO kne_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Binindisyonan Diyos sak-en gapo sin kinalinteg ko, indawat nay gon-gonak tan magay basol ko. ");
INSERT INTO kne_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Tan inon-onodak din ogali ay laydena, yan adiak dinokogan sisya. ");
INSERT INTO kne_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Tinongtongpal ko din linteg na, magay nilabsing ko ay bilina. ");
INSERT INTO kne_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Sin sangoanan Diyos, magay maipabasol en sak-en, tan inaddawiak di enak panbasolan. ");
INSERT INTO kne_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Isonga gon-gonaanas sak-en tan nalintegak, ammo na ay magay binmasolak. ");
INSERT INTO kne_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Sin ipogaw ay matalek, ipailan Diyos ay matalek sisya, ipaila na din kinasanto na sin magay kaoyawana. ");
INSERT INTO kne_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Sin nalinis et maila din kinalinis na, ngem sin nasikap ay manowitik si ib-a na, nalaing si Diyos ay mangabak en sisya. ");
INSERT INTO kne_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Isalakana din napakombaba, ngem ipababa na din mangipapangatos awak na. ");
INSERT INTO kne_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Si Yahweh ay Diyos ko di silaw ko, silawana din mabolinget ay danan ko. ");
INSERT INTO kne_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Gapo sin badang na, abakek di ad-ado ay kalaban ko, alad di ili yan makalay-at ko. ");
INSERT INTO kne_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Sinay ay Diyos yan kostokosto di amagena, maila ay pag tet-ewa di inbagbaga na. Sin am-in ay mankamang en sisya, kaman kasay ay salaknib da. ");
INSERT INTO kne_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Magay odom ay Diyos mo adi et din Apo. Magay odom ay pankamangan mo adi et si Diyos tako. ");
INSERT INTO kne_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Sisya si Diyos ay mangidawdawat si pigsak, bantayana din pandanak et magay pan-egyatak. ");
INSERT INTO kne_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Pinapigsa na din sikik et kaman din kapigsan di ogsa, et olay sin kakayangan ay dontog, adiak maisokba. ");
INSERT INTO kne_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Din iyat ko ay makigobat yan itdo na ta say kabaelak ay mangosal si bronsi ay pana. ");
INSERT INTO kne_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Sinmalaknib ya inmisalakan sisya, pinmigsaak gapo sin badang na. Magay pandanagak gapo sin panakabalina. ");
INSERT INTO kne_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Pinasiged mo din pandanak et inmannawa, isonga adiak naisokba. ");
INSERT INTO kne_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Inapayaw ko din kalaban ko ya dinpap kos daida, adiak sinmaldeng enggana ay namaga da. ");
INSERT INTO kne_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Adi da nakabangon sin nangtodokak en daida, sin sangoanak yan naiwalang da. ");
INSERT INTO kne_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Tan din pigsak ay makigobat yan indawat na, inabak ko din kalaban ko begew en sisya. ");
INSERT INTO kne_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Inturong Diyos et din kalaban ko yan tinmagtag da, din omililiget yan pinsek daida. ");
INSERT INTO kne_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Nan-adawag da ngem magay binmadang en daida. Nanpakpakaasi dan Diyos ngem adi na pinatgan kararag da. ");
INSERT INTO kne_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Minekmek kos daida et nanbalin das kaman lota ay sin dagem, nalaka ay maitayaw da. In-gatigatin kos daida ay kaman pitek sin kalsada. ");
INSERT INTO kne_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Inmisalakan si Diyos sin ipogaw ay kinmonkontra, sin nanasyon, nanbalinenas sak-en ay pangolo da, ipogaw ay adiak am-ammo, yan nay iturayak daida. ");
INSERT INTO kne_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Manyakog-ong din nanasyon sin sangoanak, tongpalen da ay dagos mo dengngen dan ibagak. ");
INSERT INTO kne_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Enggay namaga din toled da, et manpayegpeg das egyat da ay bomala sin nantatabonan da. ");
INSERT INTO kne_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Matagotago din Apo! Madaydayaw din salaknib ko! En yo et daddad-aten din kinangaton Diyos ay mangisalakan en sak-en. ");
INSERT INTO kne_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Binmadang et inabak kon kalaban ko, inpaiturayanan sak-en din ipogaw ay ad-ado. ");
INSERT INTO kne_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Sin mankakekedse ay kalaban ko, inmisalakan sisya, yan insaad nas sak-en ay nangatngato mo daida. ");
INSERT INTO kne_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Isonga sin kaipoipogaw, idaydayaw kos sisya, mankantaak ay mangidaydayaw sin ngadana. ");
INSERT INTO kne_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Dadlonan pangabaken din ari ay pinili na, ya ipaila na din adi manbalbaliw ay layad na en David ya din poli na si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Am-in ay wada ed daya et kanayon ay ipappaila da din panakabalin Diyos ay nangamag en daida. ");
INSERT INTO kne_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Din kaagawan ya labi et ipaammo day kinadiyos na, siya abe di iyat di maisned ay labi ya agsapa. ");
INSERT INTO kne_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Olay mo gomiginek da ya magay madnge ay ibaga da, ");
INSERT INTO kne_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","ngem din ipaammo da et kaman kali ay madnge sin intiro ay daga. Din agew et in-amagan Diyos si panteana ed daya. ");
INSERT INTO kne_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Kaman naragsak ay kaas-asawa na ono din napigsa ay managtag ay malaydan ay makilongba, say kaiarigan din agew mo bomala sin agsapa. ");
INSERT INTO kne_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Bomala sin esa ay soli ed daya enggana ay domateng sin esa abe ay soli na, et maga di makalisi sin atong na. ");
INSERT INTO kne_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Din kalin Diyos et kostokosto, magay kaoyawana, baro ay biyag ya pigsan di nemnem di idawdawat na. Din inpaammon Diyos ay pinaneknekana et kosto ay pantalkan tan dadlon tet-ewa. Say mangipalaing sin kolang di adal na. ");
INSERT INTO kne_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Din bilbilin Diyos et kosto di ibagbaga na, am-in ay mangonod et maragsakan da. Magay kinalawan di am-in ay linteg na, kaman silaw sin nemnem di ipogaw mo maawatan da. ");
INSERT INTO kne_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Din pamatpatgan di ipogaw en Diyos et dadlon nasantoan ya nadalos. Din panaydayawan da en sisya et mantoltoloy si eng-enggana. Am-in ay ikeddeng Diyos et kosto da tan polos ay magay pabpaborana. ");
INSERT INTO kne_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Din kalin Diyos et nabanbanol mo din balitok ay kanginaan, mammam-is abe mo din anig ay kam-isan. ");
INSERT INTO kne_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Babaen sin kalim, ay Diyos, mabagbagaanak, et dakdake di gon-gonak sin panongtongpalak. ");
INSERT INTO kne_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Magay makanemnem sin am-in ay ipaksaw na, namnamed din adi na ammo ay basol na. Sapay koma ay Diyos ta pomakawan ka. ");
INSERT INTO kne_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Adi ka koma aben ipalobos ay igagarak ay manbasol en sik-a ya omituray din basol ay kaman nisa. Et mo siya di, magay maipabasol en sak-en, et mailisiak si basol ay nadagsen. ");
INSERT INTO kne_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Sapay koma ay Diyos ta malaydan kas nan kali ya nemnem ko, sik-a ay pankamangak ya manobot ko. ");
INSERT INTO kne_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Sapay koma ta patgan Diyos din kararag mo sin timpon di ligat mo. Si Diyos ay dinaydayaw Jacob, salaknibana komas sik-a. ");
INSERT INTO kne_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Manipod ed Zion sin Timplo na, padatngena koman sik-a din badang na. ");
INSERT INTO kne_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Sapay koma ta am-in ay datdaton mo yan nemnemena, malaydan koma sin animal ay mapooan ay idaton mon sisya. ");
INSERT INTO kne_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Sapay koma ta idawat na din laydelaydem ya matongpal am-in ay planom. ");
INSERT INTO kne_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Ibogaw mi di ragsak mi mo mangabak kan to, ingato mi din bandila tako ta idaydayaw mi si Diyos Apo. Sapay koma ta patgana am-in ay kararag mo. ");
INSERT INTO kne_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Ed wani, ammok ay pangabaken Diyos din ari ay pinili na. Ed langit ay nasantoan ay kad-ana, songbatana din kararag di pinili na, et pangabakena babaen sin panakabalina. ");
INSERT INTO kne_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Din odom yan mantalek da sin para gobat ay kalisa da, din odom yan mantalek da sin kabayo da, ngem datako pay yan mantalek tako sin panakabalin Yahweh ay Diyos tako. ");
INSERT INTO kne_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Da doy ay ipogaw et maisokba da, ngem datako pay, napigsa tako ay pomika. ");
INSERT INTO kne_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Apo, pangabakem koma din ari ya patgam koma mo mankararag kami. ");
INSERT INTO kne_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Apo, manragragsak din ari tan pinapigsam sisya, nangabakem et palaloy ragsak na. ");
INSERT INTO kne_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Pinatgam din kararag na et indawat mo din laydena. ");
INSERT INTO kne_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Inmey kan sisya ya ad-ado ay bindisyon di inkoyog mo, sin toktok na, korona ay balitok di inpeey mo. ");
INSERT INTO kne_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Biyag di kindaw nan sik-a, yan indawat moy biyag ay eng-enggana. ");
INSERT INTO kne_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Madaydayaw din ari gapo sin badang mon sisya, nanbalinem ay nangato ya mandinamag di ngadana. ");
INSERT INTO kne_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Wadan sisya din bindisyon mos eng-enggana, gapo sin kawadam, palalo di ragsak na. ");
INSERT INTO kne_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Diyos ay Kangatoan, mantalek din ari en sik-a, gapo sin layad mo, mantoltoloy di panturayana. ");
INSERT INTO kne_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Depapen din ari am-in din kalabana ya am-in ay malmaliget en sisya. ");
INSERT INTO kne_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Apo ari, sin timpo ay panpailaam, mabidang ay apoy di kaiarigam. Kaman okmonen Diyos daida, tan kanen di apoy daida gapo sin bonget na. ");
INSERT INTO kne_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Ponasem din poli da isnan daga et maga polos di mabay-an en daida. ");
INSERT INTO kne_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Manplano da si naikontra en sik-a, ngem maga polos di pantongpalan da, ");
INSERT INTO kne_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","tan panaem ropa da et managtag da. ");
INSERT INTO kne_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Sik-a ay Diyos, ipailam koma din panakabalin mo, ta mankanta kami ay mangidaydayaw sin bikas mo. ");
INSERT INTO kne_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Diyos ko, Diyos ko, apay nga tinmaynan ka? Ay daetan pay di adawag ko ay manpatolong en sik-a, ngem magay mas-ed kos badang mo tan kambaw inmaddawi ka. ");
INSERT INTO kne_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Inag-agew ya linablabi ay man-ad-adawagak en sik-a, Apo, ngem adim polos songbatan nan kararag ko, isonga adi inmon-onina nan ligat ko. ");
INSERT INTO kne_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Ngem ammok pay dedan ay Ari ka ay nangato. Sik-ay daydayawen di Israelita tan nasantoan ka ay Apo. ");
INSERT INTO kne_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Din ap-apo mi ed bayag et sik-a di nantaltalkan da et siya met kayman ay insalakan mos daida. ");
INSERT INTO kne_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Inlisim daida sin am-in ay kaeegyat idi nankararag da et adi da nadisdismaya idi sik-ay nantalkan da. ");
INSERT INTO kne_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Ngem mo sak-en, baken ipogaw di omibilangan di iib-a mo adi et kaman bigis ay magay silbi na ay sigaan ya laslasoyen da. ");
INSERT INTO kne_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Am-in ay omil-ila et somis-iyek da. Manwegweg da dowan dan omitidtidla. ");
INSERT INTO kne_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Kanan da, “Mo siya ay si Diyos di nantalkam, apay ngarud ay adi dakan badangan? Mo tet-ewan kanam ay laylayden daka, into ngin di mangisalakan en sik-a?” ");
INSERT INTO kne_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Ngem sik-a met ay Diyos di inmay-ayowan sin naianakak, siya abe sin kamoyang ko ay nansossosoak. ");
INSERT INTO kne_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Naitalekak en sik-a manlogi sin naianakak, sik-a din Diyos ko manipod sin naisikogak. ");
INSERT INTO kne_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Adi ka koma tomaytaynan tan din problimak et adi makakkaan. Mo adi ka bomadang, magay odom si enak pankamangan. ");
INSERT INTO kne_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Din linmilikob ay kaibaw ko, palalo ay ad-ado da. Kaman dan mabonget ay baka ed Basan ay nankapipigsa. ");
INSERT INTO kne_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Kaman manngangaed ay layon ay manatakaw si tepek da, nasasagana da ay komat ta pomse da. ");
INSERT INTO kne_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Isonga din bikas ko et enggay maga ay kaman danom ay naiwasit sin lota. Enggay namaga di pigsak, tan kaman naikomsiw din am-in ay tong-ak. Kaman natonaw ay allid din namnamak ya toled ko, tan enggay naabakak sin peteg ay egyat ko. ");
INSERT INTO kne_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Enggay namgaan di bagang ko, din dilak et naipket sin tepek ko. Binaybay-am sak-en sin lota ta masokpot di leng-ag ko. ");
INSERT INTO kne_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","San bonggoy di makedse ay ipogaw et linmikob da, atap ay aso ay omas-asag-en di kaiarigan da. Din sikik ya takkay ko et tinodok da. ");
INSERT INTO kne_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Am-in abe ay tong-ak et mabalin ay bilangen da, din kalaban ko et ominenengneng da. ");
INSERT INTO kne_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Din badok et nanbibingayan da, din naloyong pay et nanbinonotan da. ");
INSERT INTO kne_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Sik-a ay Diyos, baken koma sin addawi di panteam, dalasem pay et koma ay en bomadang. ");
INSERT INTO kne_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Es-esa et anggoy di biyag ko, omisalakan ka kod sin kampilan di kaibaw ko, tan maangat da ay kaman natiwel ay aso. ");
INSERT INTO kne_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Salaknibam sak-en tan kaman dan layon ay en omisida ono atap ay baka ay kaeegyat di sakngod na. ");
INSERT INTO kne_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Idad-at kon to din maipanggep en sik-a sin gimong di aag-i, idaydayaw kos sik-a sin kasinsinopan mi: ");
INSERT INTO kne_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","“Dakayo am-in ay mamatpateg en Diyos, idaydayaw yos sisya, dakayo ay polin Jacob, bigbigen yo din kinangato na. Dakayo am-in ay Israelita, patgen ya dayawen yos sisya. ");
INSERT INTO kne_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Tan adi binaybay-an Diyos din kakaasi ya maligligatan, idi inmey da en sisya, adi nan dinokdokogan, et din ad-adawag da, ena aben sinongbatan.” ");
INSERT INTO kne_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Begew sin inam-amag mo et idaydayaw kos sik-a sin sangoanan di am-in ay mamigbig en sik-a, et idawat ko abe din daton ay en ko insapata. ");
INSERT INTO kne_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Mangan din nabibiteg enggana ay mabsog da, din mangan-anap en Diyos et idayaw das sisya, sapay koma ta matagotago da si eng-enggana. ");
INSERT INTO kne_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Am-in ay nasyon isnan daga et bigbigen da ay si Diyos di kosto ay daydayawen da, isonga am-in ay tribu et mansagong da ay en mandayaw en sisya. ");
INSERT INTO kne_vpl VALUES ("PS22_28","