﻿USE sofia;
DROP TABLE IF EXISTS sofia.knb_vpl;
CREATE TABLE knb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES knb_vpl WRITE;
INSERT INTO knb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mamona Yisasi Kalaisina aginagomogami amaki hane. Yisasiꞌa Teviti nofipiti kano maineanagino Tevitiꞌa Apalahamu nofipiti kanoe. Apalahamuꞌa Yisasina aginagomo maine. ");
INSERT INTO knb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apalahamuꞌa Aisakina nefaꞌe. Aisakiꞌa Yekopuna nefaꞌe. Yekopuꞌa Yutagami konagamogami neꞌamafaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yutaꞌa Pelesigani Silagani neꞌanafa maineanagino itaꞌanimo agia Tamaꞌe. Pelesiꞌa Hesalonina nefaꞌe. Hesaloniꞌa Lamana nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamaꞌa Aminatapina nefaꞌe. Aminatamiꞌa Nasonina nefaꞌe. Nasoniꞌa Salamonina nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamoniꞌa Poasina nefa maineanagino itaꞌamo agia Lahapuꞌe. Poasiꞌa Opetina nefa maineanagino itaꞌamo agia Lutiꞌe. Opetiꞌa Yesina nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesiꞌa Tevitina nefa maineanagino Tevitiꞌa Isaleli veaꞌmogami ala sauve kanoꞌami maineane. Tevitiꞌa Solomonina nefa maineanagino itaꞌamoꞌa hagoteno Yulia a maineane. ");
INSERT INTO knb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoniꞌa Lehopoamina nefaꞌe. Lehopoamiꞌa Apiana nefaꞌe. Apiaꞌa Asana nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaꞌa Yehosafatina nefaꞌe. Yehosafatiꞌa Yeholamina nefaꞌe. Yeholamiꞌa Usiana nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiaꞌa Yotamina nefaꞌe. Yotamiꞌa Ahasina nefaꞌe. Ahasiꞌa Hesekiana nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiaꞌa Manasena nefaꞌe. Manaseꞌa Emonina nefaꞌe. Emoniꞌa Yosaiyana nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaiyaꞌa Yehoiyakiniꞌene ani koganamogami neꞌamafaꞌe. Ani kanafina Papiloni kotega vayaꞌmoꞌya tu huteꞌya Isaleli veala amavaleꞌya Papiloni kotega nofi mo hu-ma-tageꞌya miya oꞌali aliꞌya ali-mainae. ");
INSERT INTO knb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ani veaꞌmoꞌya Papiloni kotega nofi huma-tageꞌya miya oꞌali aliꞌyana aliꞌya mainayanagino Yehoiyakinina Sealitielona nefaꞌe. Sealitieloꞌa Selapapelina nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selapapeliꞌa Apiutana nefaꞌe. Apiutaꞌa Eliakimana nefaꞌe. Eliakimaꞌa Asolana nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asolaꞌa Satokina nefaꞌe. Satokiꞌa Akimina nefaꞌe. Akimiꞌa Eliutina nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutiꞌa Eleasana nefaꞌe. Eleasaꞌa Matanana nefaꞌe. Matanaꞌa Yekopuna nefaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekopuꞌa Yosefena nefa maineanagino Yosefeꞌa Maliana anauꞌamoꞌagino ani aꞌmoꞌa Yisasina ategeꞌya agaifena Kalaisiꞌe* huꞌya Anumaya Kotiꞌa taugafa aligatigahe hu-tenea kanoe huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Apalahamuꞌa hagoteno maineno falitegeꞌya haenagaꞌa fotiniꞌa (14) aginagomoꞌya maime maime haiꞌya mo falitageno anile Tevitiꞌa evaꞌyi huno maineno falitegeꞌya haenagaꞌa fotiniꞌa (14) aginagomoꞌya maime maime haigeꞌya Papiloni vayaꞌmoꞌya eꞌya Isaleli veaꞌmogamina nofi hu-ma-tageꞌya miya oꞌali aliꞌyana aliꞌya mainageno haenagaꞌa fotiniꞌa (14) aginagomoꞌya maime maime haigeno Kalaisiꞌa falote hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisasi Kalaisima atenea kea mage huno hu-maine itaꞌamo agia Maliaꞌe Yosefete ago hage-malenaya munalagino nagola vene ofaenea munaꞌmoꞌa aipaene maine. Anumaya Kotina Alu Aotage Avamuꞌaleti aipaene hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefeteꞌma, hage-malenaya kanoa, fatago kano maineanagino havigu Maliaꞌa agaye huyafenagiꞌna kesi atalesue agesa havimaine. ");
INSERT INTO knb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","Ani kehena agesa havige havigeteno faeno maineno himona ageana Anumayamo ensole kanoa evaꞌyi huno mage huno hie “Yosefegae, Tevitina neꞌamogae, kolia ohuka Maliaꞌa akamoꞌagi afaꞌa avalo. Anumaya Kotina Alu Aotage Avamuꞌaleti aipaene maineanagino neꞌnafaꞌne ategahie. Ani nafaꞌneꞌmoꞌa agaiꞌa veaꞌmogamina kefo yaꞌamimo nofi hu-matenea veala ali kalu heno amaugafa ali-gatisiafe agia Yisasiꞌe huka malegane.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Nayona Anumayamo aune kanomo avayafiti mage huno hama-pai-maineane “Haviho nagola vene ofaenesia munaꞌmoꞌa aipaene huteno neꞌnafaꞌne ategahie. Ani nafaꞌnemo agia mage huꞌya ayegahae Imanueliꞌe huꞌya ayegahae.” huno hu-maineane. “Tagai kefina ani agimoꞌa Anumaya Kotiꞌa tagaiꞌene maine.” huno hu-maine. Yisasina atenea yupa ani kemoꞌa ago falote huno tamage hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefeꞌa ani himona ageteno aupiti hetino Anumayamo ensole kanomoꞌma hapaiya kea havino akave maleteno “Maliaga aꞌnimogae.” huno ali-tene. ");
INSERT INTO knb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yosefeꞌa ani afena “Aꞌnimogae” huteno alave yana ohuno afaꞌa maineꞌana ani nafaꞌnea ategeno Yosefeꞌa agia Yisasiꞌe huno malene. ");
INSERT INTO knb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helotiꞌa Yutia kotega ala sauve kano mainea kanafina Yisasina Petelehemu osi Yutia kumate atene. Atetegeꞌya haenagaꞌa yage vaꞌyi nehilegati kanale haviꞌyaꞌami hanea vayaꞌmoꞌya Yelusalemu evaꞌyi hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Evaꞌyi huteꞌya mage huꞌya hae “Menima atea nafaꞌnea, Yuta* vayaꞌmogami sauve kanoa, hanate atene? Nagola haegafa kaꞌnefila yagema evaꞌyi nehilegati evaꞌyi higeta ageteta ‘Ago atene.’ huta agai agi alisaga hugahe neꞌone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hageno sauve kanoa Helotiꞌene mukiꞌa Yelusalemu mainaya veaꞌnene ani kea haviteꞌya atali talu hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Atali talu hageno Helotiꞌa mukiꞌa mono note kava vayafeꞌene kahegi kema havilinaya anagafeꞌene ke higeꞌya agaite ageno mage huno hama-vige “Anumaya Kotiꞌma taugafa ali-gatigahema hu-tesia kanoa hana kumate ategahie?” huno hama-vi-ge-maine. ");
INSERT INTO knb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hama-vi-gegeꞌya mage huꞌya hae “Ani nafaꞌnea Petelehemu ategahie. Nayona Anumaya Koti aune kanomoꞌa mage huno kae-maleneane ");
INSERT INTO knb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kagaya Petelehemu kumaꞌmoga Yutia kotega mainananagi Yutia kumaꞌyaga ago amakaseka hai-mainananagino kagaipiti ala kava kanoa falote huteno nagai veala Isaleli* veate kava yakaigahie.’ huno kae-maleneane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hageno Helotiꞌa yage vaꞌyi nehilegati emainaya kanale haviꞌyaꞌami hanea vayaꞌyagahena kesi huno ke higeꞌya ageno “Ani haegafa kaꞌnefila na yu falote hu-maine?” huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hama-vigeteno Petelehemu hu-ma-tegahe mage huno hie “Utama ani nafaꞌnehena ati-yetama age-faloteꞌma hinutamahena etetama me naha-paigeꞌna nagaiꞌenena aniꞌa huꞌna agia molisaga hano.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Higeꞌya sauve kanomo kea haviteꞌya mogayana yagema vaꞌyi nehilegati age-mainaya kaꞌnefimoꞌa uhagote-ma-teno viaꞌyamo ani nafaꞌnema mainea nomo amupale umaineno amave-li-maine. ");
INSERT INTO knb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amave-ligeꞌya ageteꞌya amaipamoꞌa kanale higeꞌya tusiꞌa muse hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Muse hu-teteꞌya ani nopi hai-faleꞌya agayana ani nafaꞌnegi itaꞌamoꞌa Maliaꞌagi huꞌana mainaꞌageꞌya mogeteꞌya mopafi mope huꞌya agia alisaga nehuꞌya kuꞌamifiti muse yana amigahe monegi manaꞌage taꞌnefagi kule fuki kana huno manaꞌage mea tinagi huꞌya aminae. ");
INSERT INTO knb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Amiteꞌya himona agayana Anumaya Kotiꞌa himonafi mage huno hama-paiye “Heloti mainesilega etetama oꞌviho” huno higeꞌya alu kate uteꞌya kumaꞌamilega umainae. ");
INSERT INTO knb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kanale haviꞌyaꞌami hanea vayala utageno Yosefeꞌa Anumayamo ensole kanoa himonafi agegeno mage huno hie “Hetika nafaꞌnene itaꞌamoꞌene Isipi kotega tamaiya-yetama viho. Anilega umainegeꞌna nagayama eteꞌna hisugetama etetama egahae. Helotiꞌa kagai nafaꞌnehe ati-yeno haesia ke nehie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Higeno Yosefeꞌa ani himona ageteno aupaꞌa hetino nafaꞌnene itaꞌamoꞌene ani kegela anavaleno Isipi kotega ugahe umainae. ");
INSERT INTO knb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ani kotega ayaꞌaya kanagefa umainageno Helotiꞌa falitegeꞌya neꞌataleꞌya emainae. Ani yafena nayona Anumayamoꞌa aune kanomo avayafiti mage huno hu-maineane “Isipi kotegati nagaiꞌni nafaꞌnea ke hisugeno egahie” huno hu-maineane. Nayoma hu-mainea kemoꞌa ani yupa ago efalote huno tamage hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helotiꞌa agesa havitenoꞌe “Ani kanale haviꞌyaꞌami hanea vayaꞌmoꞌya aye-navataga hae.” huno tusiꞌa ke vai-maine. Kanale haviꞌyaꞌami hanea vayaꞌmogami kea haviteno “Yisasiꞌa ani augafa kafuꞌa hane.” huno nagoꞌa vayala hu-ma-tegeꞌya Petelehemu kumateꞌene atupa kumaꞌyagaleꞌene mukiꞌama yaufa tole (2) kafua ohunaya neꞌnafaꞌneyaga “Hamaegeꞌya faliho.” huno hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Yelemaiyaꞌa nayona Anumaya Koti aune kanomoꞌa mage huno hu-maineane “Lama kumategati mukiꞌa veaꞌmoꞌya ala kefiti ke huꞌya hamau huꞌya avi-taya kea vayaꞌmoꞌya havimainae. Leselina aginagomogami nafaꞌneyagahe tusiꞌa avi-tegeꞌya nafaꞌneyagaꞌama faliya yafe veaꞌmoꞌya aipa ali falu hutayanagi tusi avi-te-maine.” huno hu-maineane. Ani yupa nayoma hu-mainea kemoꞌa ago efalote huno tamage hie. ");
INSERT INTO knb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helotiꞌa falitegeno Yosefeꞌa Isipi kotega maineno himonafi Anumayamo ensole kanomona agegeno mage huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Hetika nafaꞌnene itaꞌamoꞌene neꞌanavaleka Isaleli kotega viho. Kagai nafaꞌnema haesaya amakesa haviya vayala ago faliye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Higeno Yosefeꞌa hetino nafaꞌnene itaꞌamoꞌene neꞌanavaleno Isaleli kotega umainae. ");
INSERT INTO knb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Umainagi “Helotiꞌa ago falitegeno agaiꞌa nafaꞌnemoꞌa Akelausiꞌa Yutia kotega kava hu-maine.” huꞌya haya kea Yosefeꞌa haviteno koli huno “Anilega oꞌugahue.” huteno himonafina “Anilega oꞌviho.” huno hia kea haviteno Kalili umaine. ");
INSERT INTO knb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kalili viana osi kumala Nasaleti uno maine. Nayona Anumaya Koti amaune vayaꞌmoꞌya Yisasifena mage huꞌya hu-mainayane “Agaya Nasaleti kano maine.” huꞌya hugahae huꞌya hu-mainayane Ani yupa nayoma hu-mainaya kemoꞌa ago efalote huno tamage hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti fale-mate Yoniꞌa evaꞌyi huno Yutia kaꞌme kotega maineno Anumaya Koti kea hu-haleno hama-pai-maine. ");
INSERT INTO knb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yoniꞌa mage huno hie Anumaya Kotiꞌma ikapinaga kava yagaisia yamoꞌa aupaꞌa evaꞌyi hugahie. Evaꞌyi hugahigi tamakaya tamakuꞌa aiyahae hutama kefo yatamia “Nagoꞌene ohugahune.” hutama ataleho huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ani kema hisia kanomofena nayona Anumaya Koti aune kanomoꞌa, Aisayaꞌa mage huno hu-maineane “Kaꞌme kotegati nago kanomoꞌa keha keha huno mage hugahie ‘Anumayamo esia kamaꞌa ali hilato hutama ali fatago hiho.’ huno hugahie.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoniꞌa kemolo afumo ayolagefaleti fakaꞌni-male kena fai-line. Fai-lineno pulamakao augafaleti amuꞌnofila aye-talako huno ki-lineno kaveꞌa keꞌnuꞌene tumemo timaꞌaene neneane. ");
INSERT INTO knb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ani kanafina Yelusalemu veaꞌnene Yutia kotega veaꞌnene nagoꞌa Yotani ti agegayalega hanea kumate veaꞌnene Yoni mainelega umainae. ");
INSERT INTO knb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yotani titega emaineꞌya kefo yaꞌamihena hu-falote hageno Yoniꞌa ani Yotani tipi tina fale-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tina fale-neꞌama-tegeꞌya Falasia* vayaꞌene Satiusi* vayaꞌene “Ti fale-la-tesie.” huꞌya neꞌageno Yoniꞌa amaketeno mage huno hie “Tamakaya osifaꞌveyagamo nafaꞌneyaga mainagi tamakaya havigeꞌage vayaꞌmogatama Anumaya Kotiꞌa kaiyekema hu-lama-tesigetama tamaugafa tamakata aisia kanamoꞌa aupaꞌa efalote hisia yafena ‘Faletama viho.’ kea ta tamaha-pai-maine? ");
INSERT INTO knb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Hagotetama kefo yatamihema tamakuꞌa ai-yahae hu-mainesaya yana nave-lisageꞌna tina fale-lama-tegahue. Tamakaya ‘Apalahamu nafaꞌneyaga mainone.’ hutama ohiho. Nagaya tamaha-nepauve Anumaya Kotiꞌa ma yafatetila Apalahamu nafaꞌneyaga afaꞌa talo hileꞌasine. ");
INSERT INTO knb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tamakaya yosa kana hutama mainayanagi menia Anumaya Kotiꞌa tuna alino yosamo aipale maleneno kanale alagama oꞌayenesia yosa atagino atafi hagaꞌyu huno kaegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tamakuꞌa ai-yahae hutama kefo yatamia atalegeꞌna nagaya titeti fale-nelama-toanagino nakavela nago kanoma esiana Alu Aotage Avamutetiꞌene ataletiꞌene fale-lama-tegahie. Ani kanomoꞌa tusiꞌa tokiyaꞌa hanea kanogino nagaila ago nagase-maineanagiꞌna nagaya afa kano mainoanagiꞌna agai aiyale ayesuana onategahie. ");
INSERT INTO knb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Agaya sipeti ayopaꞌa ali-lineno vitimo anoꞌyaꞌa fuhu hale-taleno alagaꞌa alino nopi halaꞌya hu-malegahigi anoꞌyaꞌa ata tegelege nehia atafi kae-talegahie. Ani avinamoꞌma hu-mainea kava huno veala fako faka hugahie huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ani kanafina Yisasiꞌa “Yoni ayapiti tina fale-natesie.” huno Kalili kotegatila ataleno Yotani titega umaine. ");
INSERT INTO knb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yoniꞌa Yisasifena “Tina fale-oka-tegahue. Nagaila kagaya tina fale-na-tanageno kanale hileꞌasine naꞌa higeka nagaifena ‘Tina fale-nato.’ huka nehane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Higeno Yisasiꞌa Yonifena mage huno hie “Menia aniꞌa hisanana kanalele. Tima fale-na-tesanana mukiꞌa Anumaya Kotina fatago kavaꞌa alitaꞌa lama hugahuꞌe.” huno higeno Yoniꞌa Yisasi ke akave maleno tina fale-tene. ");
INSERT INTO knb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tina fale-neꞌategeno Yisasiꞌa aupaꞌa tipiti aivati huno ageana ikamoꞌa ai-hagalo higeno Alu Aotage Avamuꞌmoꞌa nama kana huno agaitega elavi-maine. ");
INSERT INTO knb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ageho enelavigeno ikapinagati age aino mage huno hie “Ma kanoa nagaiꞌni nafaꞌnehena agaifena aluya huno nahau nayamopafina nenagea neꞌnimofena agaifena aluya huꞌna musemaꞌa nehue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Anumaya Kotina Alu Aotake Avamuꞌamoꞌa Yisasina veaꞌne omai kaꞌme kotega avaleno vigeno Sataniꞌa Yisasife “Havi kava huo.” huno aye-vataga hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Umaiyana fotiꞌa (40) yupagefa felugaene kegeꞌene kavela oneno maigeno tusiꞌa agate-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Agategeno Sataniꞌa agaite uvaꞌyi huno mage hie “Kagaya Anumaya Koti nafaꞌnema mainenukahena ma yafaꞌyaga hapaigeno maya hapaeno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Higeno Yisasiꞌa mage huno hie Anumaya Koti avopi kemoꞌa mage huno hu-maineane “Veaꞌmoꞌya mayaꞌageꞌma nesayana kanaleꞌya huꞌya omaigahagi mukiꞌa Anumaya Kotiꞌma hu-mainea kene haviꞌya nenesageno amaku nafaꞌnemoꞌa kanaleꞌya huno maigahie. huno hu-maineane.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sataniꞌa Yisasina Yelusalemu tusiꞌa ala kumate avaleno ala mono nomo agotofule motene. ");
INSERT INTO knb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Moteteno mage huno hapaiye “Kagaya Anumaya Koti nafaꞌnema mainenukahena ma nomo agotofuleti mopafi asaga hulavigeꞌna agano. Anumaya Koti avopiti kemoꞌa mage hu-maineane ‘Anumaya Kotiꞌa ensole vayaꞌahe ‘Kava hiho.’ huno hu-ma-tesigeꞌya amayateti kavalesaga hu-lisageka tavisanageno yafatela kaiyamona aye kofa ohugahieꞌ huno hu-maineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Higeno Yisasiꞌa kenonaꞌa mage huno hie “Nagoꞌene Anumaya Koti avopina mage huno kae-maleneane ‘Anumaya Kotikamona afa yafena ‘Tokiya kava huo.’ huka aye-vataga ohuo.’ huno hu-maineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Higeno Sataniꞌa Yisasina avaleno nago ala agoꞌyafi haiteno mukiꞌa ma mopafima hanea ala kumaꞌyagaene afenoꞌyamaꞌaene ave-li-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aveliteno Yisasife mage huno hie “Kagaya nagaifema ‘Tusiꞌa ala kano mainananagiꞌna kagai kagi alisaga nehue.’ huka kagesama havi namika mopafi kaleꞌyama ayesanageꞌnahena mukiꞌa ani kumaꞌyagaene afenoꞌyaꞌene kava yagaisanafe kamino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Higeno Yisasiꞌa mage huno hie Sataniga* mai haleka amulega vuo. Anumaya Koti avopi kae-malenaya kemoꞌa mage huno hu-maineane “Anumaya Kotikamona akaiꞌagefe ‘Tusiꞌa ala kano maine.’ huka kagesa havi havi huka agai agia alisaga huka agai aliꞌyamaꞌage alio huno hu-maineane.” huno hapai-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Higeno Sataniꞌa anile ataleno vigeno ensole anagaꞌmoꞌya Yisasina meya huꞌya kava hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yisasiꞌa “Yonina nofi hu-tenae.” huꞌya haya kea ago haviteno Kalili kotega umaine. ");
INSERT INTO knb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Viana Nasaletia ataleno Kapaneamu umaine. Ani kumala Kalili ti kotumona agegayale haneanagino Sepuluni nofi veaꞌmogamiꞌene Napatali veaꞌmogamiꞌene koꞌamiꞌa haneane. ");
INSERT INTO knb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nayona Anumaya Kotiꞌa aune kanoꞌamona, Aisaya avayafiti mage huno hu-maineane ");
INSERT INTO knb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepuluni nofi veaꞌmogamiꞌene Napatali veaꞌmogamiꞌene mainesaya kaiyaga ala tikotu visaya katega haneanagiꞌya Yotani lina takaeꞌya vaaya kotega, Kalilie, Yuta veaꞌne omainaya veaꞌmoꞌya nemaiya kumale. ");
INSERT INTO knb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ani kotega mukiꞌa veamoꞌya hani yapi mainayanagino menima aye-hale-matesia yana age-mainae. Mukiꞌa veaꞌmoꞌya afaꞌa maineꞌya faligahe hayanagi Anumaya Koti kemoꞌa ago aye-vasa hu-matene.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ani yupa Yisasiꞌa aepa heno Anumaya Koti kanale mono kea hu-haleno hama-pai-maine. Mage huno hie “Ikapinagati Anumaya Koti kava yagaisia yana aupaꞌa evaꞌyi hugahigi tamakaya tamakuꞌa aiyahae hutama kefo yatamia ataleho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kalili ti kotumo agegayalega neꞌuno Saimonina, nago agia Pitaꞌe, aganaꞌamo agia Etaluene anakeana noyame kuꞌya nehaꞌa kanolatana maineꞌana ala kukonogo hagaꞌyu huꞌana ti kotupi nemalaꞌageno anake-maine. ");
INSERT INTO knb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Anaketeno Yisasiꞌa mage huno hana-paiye “Nakave eꞌo. Nakave eꞌageꞌna noyame kuꞌyama haꞌa avamete huꞌna veaꞌne amavalesaꞌa auꞌava yana tanavelino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Higeꞌana aupaꞌa kukonogoꞌania neꞌataleꞌana Yisasi akave umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Vaꞌageno Yisasiꞌa anakeana Sepetina netalamaꞌamoꞌagani Yemesigani Yonigania tipi kalefi neꞌanafaꞌene maiꞌana kukonogo nefakaꞌniꞌageno Yisasiꞌa momaketeno anakaife ke hie. ");
INSERT INTO knb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ke higeꞌana aupaꞌa Sepetiꞌa neꞌanafaꞌene tipi kalene neꞌataleꞌana akave umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisasiꞌa mukiꞌa Kalili kotega ute ete huno mono nopi Anumaya Koti kava yagai-latesia kanale mono kea mo hama-nepaino mukiꞌa kaliꞌamima hanea veaꞌnene mukiꞌa veaꞌmogami amaugafama ali haviya nehia yana alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Alino kanaleꞌma hu-ma-tea avagemoꞌa mukiꞌa Silia kotega ute ete higeꞌya haviteꞌya mukiꞌa veaꞌmoꞌya kalima aliya veaꞌnene alu kali alu kalima aligeno amaugafa amakata neꞌaiya veaꞌnene Satani Avamuꞌma* amakuꞌafi mainea veaꞌnene mananiꞌya neꞌamakia kali veaꞌnene amaiya amaya avayu hu-lavi-mainea veaꞌnene amavaleꞌya Yisasite ageno alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Alino kanale hu-ma-tegeꞌya kasagoꞌya veaꞌnea Kalilitiꞌene naya-toleꞌa kumaꞌyagaletiꞌene Yelusalemutiꞌene Yutiatiꞌene alulega mainaya veaꞌnea Yotani tina takaeꞌya Yisasina akave umainae. ");
INSERT INTO knb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisasiꞌa mukiꞌa alitalu hu-mainaya veaꞌnea amaketeno agoꞌyafi haino mopale mainegeꞌya agaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya Yisasitega emainae. ");
INSERT INTO knb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ageno Yisasiꞌa avayafiti mage huno hie. ");
INSERT INTO knb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mukiꞌa yaꞌamima omalenea veaꞌmoꞌya “Tagupi nagoꞌa kanale yana omaleanagita tagaitia kanale kavala ohugahunagi Anumaya Kotiꞌa taya hisie.” huꞌya hisaya veaꞌmogamina Anumaya Kotiꞌa amakaila kava yagai-ma-tegahigi ani yafena muse hutama maiho. ");
INSERT INTO knb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hamaumana halesigeꞌya hamau huꞌya nemaisaya veaꞌmoꞌya Anumaya Kotiꞌa amaya huno amaipa falu hisia yana amamisia yafena muse huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Amaugafama aliꞌya nohaiya veaꞌmogamina Anumaya Kotiꞌa haenagaꞌa mukiꞌa mopa amamisia yafena muse huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anumaya Kotiꞌa fatago hu-mainea kavafena “Nelahaigeno ani yafena laga nele.” huꞌya hisaya veaꞌmoꞌya Anumaya Kotiꞌa amamu hisigeꞌya maisaya fatago kavaꞌma amamisia yafe muse huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mukiꞌa veaꞌmoꞌya nagoꞌa neꞌamafugamife kalagi ai-mateꞌya hamau hu-neꞌamatesaya veaꞌmogamina Anumaya Kotiꞌa aniꞌa huno kalagi aino hauna hu-matesia yafena huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mukiꞌa veaꞌmoꞌya Anumaya Koti kema akave malesaya yafena tole amakesama ohavinaya veaꞌmoꞌya Anumaya Kotima agesaya yafena muse huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Neꞌamafugamifena “Nagoke tamaku tamakesale maiho.” huꞌya nehisaya veaꞌmogamina Anumaya Kotiꞌa “Nagai nafaꞌneyaga mainae.” huno hu-matesia yafena muse huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nagoꞌa veaꞌmoꞌya fatagoma huꞌya mainesageꞌya nagoꞌa veaꞌmoꞌya amaipa kafa he-mateꞌya ali-haviyama hu-ma-tesageꞌya maisayana Anumaya Kotiꞌa amakaiꞌma kava yagai-ma-tenea yafena muse huꞌya maisae. ");
INSERT INTO knb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tamakaya nakaveꞌma nemalageꞌya tamaketeꞌya kamuge hu-lama-teꞌya ali-haviya hu-nela-mateꞌya “Ma kavala havi kava nehae.” huꞌya havigema hu-lama-tesagetama afaꞌa muse nehutama maiho. ");
INSERT INTO knb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aniꞌama hu-lama-taya kavala nayona Anumaya Koti amaune vayaꞌmogamina aniꞌa hu-ma-tenayane. Ani kavaꞌma hu-lama-tesaya kanafina ikapinaga anonaꞌa kasagoꞌya yaꞌyaga alisaya yafena tamaipamoꞌa kanale nehinagetama muse hiho. ");
INSERT INTO knb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tamakaya ma mopale veaꞌmogamina hagama nehamaiya sole kana hutama mainae. Solemoꞌa hagama nehia yamaꞌama haꞌno hisigetama hanaꞌa hutama hagama nehia yamaꞌa ali falote hugahae? Hagama nehia yamaꞌamoꞌa ago yagu yaguma hisiana afa ya kana hinageꞌya ani Solea veaꞌmoꞌya faitega ai-tagu-fe-talesageꞌya amaiyaleti ute ete huꞌya aye-lata-pegahae. ");
INSERT INTO knb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tamakaya mukiꞌa ma mopama hanea kotega kaꞌni kana veaꞌne mainae. Ala kumaꞌma agoꞌyafima hanesiana fala okigahianagiꞌya mukiꞌa veaꞌmoꞌya agegahae. ");
INSERT INTO knb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nagoꞌa veaꞌmoꞌya lamua hanagaliꞌya susufanefinaga aiso hu-nomalagi nopinaga aye-halesigeꞌya veaꞌmoꞌya agesayafe ani lamua sipale nemalae. ");
INSERT INTO knb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Naꞌa hu-mainegi tamakaya ani kava hutama lamumoꞌa aye-hale-ma-tea kava hutama Yisasi kea hama-paitama kanale kavala veaꞌmogami amaule hisageꞌya ageteꞌya ikapinaga mainea Nelamafa agia alisaga hugahae. ");
INSERT INTO knb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tamakaya ma lamakesa ohaviho “Nayona Mosese kahegi kene amaune vayamoꞌya hu-mainaya kene Yisasiꞌa ali-talegahe emaine.” hutama ohiho. Nagaya ani yaꞌyaga aliꞌna oꞌatalegahugi ani kea ali falote hisugetama “Tamage nehie.” hutama hisayafe emainoe. ");
INSERT INTO knb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nagaya tamagelafa huꞌna tamaha-nepauve ma mopaene ikaꞌene fanane hugaꞌanagi kahegi kefi mukiꞌa osi osi oꞌagemo avoꞌyaga afaꞌa hanegahie. Nagoke ya kanoꞌagela fanane ohugahigi mukiꞌama hu-mainaya kemoꞌa falote huno tamage-lafa hugahie. ");
INSERT INTO knb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tamage-lafa hu-mainayafe nagoꞌa veaꞌmoꞌya ani kahegi kea osi kanoꞌa “Akavela omalegahunema.” huꞌya alu veaꞌmogamife “Aniꞌa hiho.” huꞌya hisaya veaꞌmoꞌya Anumaya Kotiꞌa kava yagai-mainea kumatela osi nafaꞌne kana veaꞌne maigahagi nagoꞌa veaꞌmoꞌya mukiꞌa kahegi kema ali hipoꞌya huꞌya “Ma kava hiho.” huꞌya hama-paisayana Anumaya Kotiꞌa kava yagai-mainea kumatela ala huno agase-mainea amakiene veaꞌne maigahae. ");
INSERT INTO knb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nagaya tamagelafa huꞌna tamaha-nepauve Falasia* vayaꞌene kahegi kema havilinaya anagaꞌene hu-mainaya fatago kavala tamakaya agasetama tusiꞌa kanale hu-mainea fatago kavaꞌma ohisayana amuha ohunayanagino tokiyatamia omaleneanagitama Anumaya Kotiꞌa kava yagai-mainea kumatela haitama omaigahae. ");
INSERT INTO knb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tamakaya ago havilinae nayoma mainaya veaꞌmogamina mage huꞌya hama-pai-mainayane “Veala hamaetama fali-oꞌamateho. Veaꞌma haemaetama fali-matesayana kaiyeke hu-lama-tegahae.” huꞌya hu-mainayane. ");
INSERT INTO knb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nagi nagaya menia tamaha-nepauve nagoꞌa veaꞌmoꞌya neꞌamafufema amaipa kafa hetesayana Anumaya Kotiꞌa kaiyeke hu-ma-tegahie. Nagoꞌa veaꞌmoꞌya neꞌamafufema “Havi kavakeꞌya nehana kano mainane.” huꞌya hisayana ala kaiyekele he-tigahae. Nagoꞌa veaꞌmoꞌya neꞌamafufema “Kagaya aifoꞌnafo kano mainane.” huꞌya hisayana hani yapima tegelege nehia atafi ugahae. ");
INSERT INTO knb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Naꞌa nehaya yafe tamakaya Anumaya Kotina nago yama amigahena mono nopi haitama mainetama “Veha nenafuna haviya hu-tenoanagino aipamoꞌa haviya nehie.” huka kagesa haviteka Anumaya Kotina amisana yana anile neꞌataleka negafutega tanaipa mo-li-falu hutetana eteka esanaꞌamoga amisana yana Anumaya Kotina memio. ");
INSERT INTO knb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nago kanomoꞌa “Havi kava huna-tananagiꞌna kaiyekea hu-gategahe nehue.” huno kavalenoꞌma vinagetana neꞌutana “Nenafuga kaipa falu hisia yana kamigahue.” huka hapaiyo. Aniꞌa ohisanana kavaleno kaiyekema hu-gatesia kanomote vinageno haviteno ati kanomo ayapi katesigeno kavaleno nofila mo hu-gategahie. ");
INSERT INTO knb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nofila mo hu-gategahigi tamage tamaha-nepauve kaiyekema hu-gatenea kanomoꞌma “Mone namio.” huno hu-mainesia monema oꞌaminesanana nofipitila ataleka omegane huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tamakaya nayo kea ago havimainae mage huno hu-maineane “Kumai he kavala ohiho.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nage hu-maineanagi nagaya menia tamaha-nepauve nagoꞌa veaꞌmoꞌya nago aꞌmona aulagafiti age haꞌye huno “Ani aꞌmofena naꞌa hu-ga-tegahue.” huno aguꞌafinaga havino haꞌyema hiana ani atela ago kumai kava hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tamaga kaiyaga tamaulagamoꞌma agea yafema kefo kavaꞌma hisaya tamaku tamakesa tamamisigetama ani tamaulaga ali faꞌyitama atalesagenoꞌa nago tamaugafa atupaꞌa omalenea yafe kanaleꞌya hutama maigahae. Aniꞌama ohinutamahena muki tamaugafa hanimo aguꞌafi tegelege nehia atafi hagaꞌyu hu-lama-talegahie. ");
INSERT INTO knb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tamaga tamayaꞌmoꞌma tamavayu huno kefo kava hisaya tamaku tamakesama tamamisigetama ani tamayana he-fakalitama ataleho. Naꞌafene? Nago tamaugafa atupaꞌa omalenea yafe kanaleꞌya hutama maigahae. Aniꞌama ohinutamahena muki tamaugafa hanimo aguꞌafi tegelege nehia atafi hagaꞌyu hu-lama-talegahie. ");
INSERT INTO knb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nayona mani kea hagetama havimainae. “Nagoꞌa vayaꞌmoꞌyama aꞌamima hu-tesayana ani vayaꞌmoꞌya aꞌamimofena ‘Ago hu-negatoe.’ huno avona kaeno amino.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hu-maineanagi nagaya menia tamaha-nepauve aꞌamoꞌma kumai ohenesigeno anauꞌamoꞌma atalesigeno ani aꞌmona alino kumai nehia a kana hu-tene. Nago kanomoꞌa anima atalenea aꞌma aliteana ani kanomoꞌene kumai he yana nehie. ");
INSERT INTO knb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nago kea nayoma hama-pai-mainaya kea ago havimainagi naꞌa hu-maine “Kagaya ‘Anumayamo aufina tamage nehuanagiꞌna naꞌa hugahue.’ huka hisanana fatago huka ani kavala huo.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hu-maineanagi nagaya tamaha-nepauve tamakaya “Anumaya Koti aufina tamage nehue.” hutama ohiho. Tamakaya “Ikamo agile tamage nehue.” hutama ohiho. Ikapinaga Anumaya Kotiꞌa kava yagai-mainea kuma hanegetama agaife nehae. ");
INSERT INTO knb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tamakaya “Mopamo agile tamage nehue.” hutama ohiho. Ani mopalega Anumaya Kotiꞌa aiya haꞌyo hu-maleno mainea mopa hane. Tamakaya “Yelusalemu kumaꞌmo agle tamage nehue.” hutama ohiho. Ani Yelusalemu kumala ala sauvetimoꞌa Anumaya Koti kava yagai-mainea kuma hane. ");
INSERT INTO knb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tamakaya “Nanuteti huꞌna lamage nehue.” hutama ohiho. Tamakaya tamayolagefahena “Anupa nayolegefaene tuhi nayolegefaene falote hino.” hutama hisaya tokiyatamia omalegi ani kea ohiho. ");
INSERT INTO knb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“E,” hinutamahena ani keꞌage hiho. “Aꞌao.” hinutamahena ani keꞌage hiho. Nago kenema hisayana Kefo Avamuꞌmoꞌa ani kea ali falote nehie. ");
INSERT INTO knb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nayona mani kea hagetama ago havimainagi “Nago kanomoꞌa kaulagama ai-lagatisigekahena ani kanomo aulaga anonaꞌa ai-lagatio. Kaveꞌma ai-halalima hisigekahena anonaꞌa agaila aniꞌa huka avela ai-halali huo.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hu-maineanagi nagaya tamaha-nepauve nago kanomoꞌa havi kavaꞌma hu-ga-tesigekahena kaꞌyona oꞌamio. Nago kanomoꞌa kagalamesaleꞌma kaiko-lisigekahena nago kaiyagakaꞌa mai-yahae hugeno kaiko-lino. ");
INSERT INTO knb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nago kanomoꞌma “Haviya hu-natea kanoe.” huno kaiyekema hu-gateno “Anonaꞌa kagaiꞌa siota namio.” huno hisigekahena ala yasi siotakaene amio. ");
INSERT INTO knb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nago kava kanomoꞌa tokiyaꞌage ke huno “Afenoꞌyaniꞌa nago kilomita alika vuo.” huno hisigekahena ani kilomita mogaseka nagoꞌene tole kilomita alika vuo. ");
INSERT INTO knb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nago kanomoꞌma “Nago yaka namio.” hunoꞌma hisigekahena afaꞌa hagaꞌyu huka amio. Nago kanomoꞌma “Namisanageꞌna yoka aliteꞌna eteꞌna kamigahugi namio.” huno hisigekahena afaꞌa amio. ");
INSERT INTO knb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nayoma hama-pai-mainaya kemoꞌa ago havimainagi “Kumatamile mainesaya nelama-fugamifena tamahau tamayamopafi tamahainagetama kame vayatamihena tamaipa kafa he-mateho.” huꞌya hu-mainayane. ");
INSERT INTO knb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hu-mainayanagi nagaya menia tamaha-nepauve “Kame veatamimofena tamahau tamayamopafi tamahaino. Haviya hu-nelamataya veaꞌmogamina ‘Amaya huo.’ hutama Anumayamotega havigo.” ");
INSERT INTO knb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ani kavaꞌma hisayana ikapinaga mainea Nelamafana nafaꞌneꞌa maigahae. Anumaya Kotiꞌa kanale veaꞌneleꞌene havi veaꞌneleꞌene yagemona hu-tegeno nago avamete huno aye-hale-matene. Anumaya Kotiꞌa fatago nehaya veaꞌneleꞌene havi kava nehaya veaꞌneleꞌene kola hu-tegeno nago avamete huno kola neꞌaiye. ");
INSERT INTO knb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Veaꞌmoꞌya tamakaifema hamau amayamopafi neha-mainagetamahena tamakaya aniꞌa hutama amakaifema tamahaisiana ani kavamoꞌa afa yanagino anonatamia oꞌaligahae. Kefo kava nehuꞌya amaugafaleti takisi mone neꞌaliya vayaꞌmoꞌya aniꞌa kavala nehae. ");
INSERT INTO knb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nelamafuꞌenekeꞌyama kea kea nehisaya yana afa yanagi. Yisasi ke ohavinaya veaꞌmoꞌya aniꞌa kavala nehae. Kame vayatamimoꞌene kea kea hiho. ");
INSERT INTO knb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikapinaga Nelamafaꞌa ala huno kanale kavakeꞌya hu-maineanagitama tamakaya aniꞌa augafa veaꞌne mainetama ala hutama kanale kavakeꞌya nehutama maiho. ");
INSERT INTO knb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yisasiꞌa mage huno hu-maine “Havigu tamakaya veaꞌmogami amaufima kanale kava nehisageꞌya ‘Nageteꞌya kanale kano maine.’ huꞌya hisae.” hutama nehae. Ani kavala hisayana anonatamia hai ali-mainagi ikapinaga mainea Nelamafaꞌa kanale kava haya yafe anonatamia otamamigahie. ");
INSERT INTO knb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ani yafe tamakaya kafuma hisaya veala amaya hutamama amamigahena ala kefiti keha keha hutama oꞌamamitama kesi ako hutama amamiho. Nagoꞌa vagala vayaꞌmoꞌya mono nopiꞌene kategaene “Veaꞌmoꞌya tageteꞌya ‘Kanale kava nehae.’ huꞌya takia alisaga hisae.” huꞌya keha keha huteꞌya vaya amaya nehayanagi nagaya tamagelafa huꞌna tamaha-nepauve kanale anonaꞌamia hai ali-mainayanagino Anumaya Kotiꞌa nago yana oꞌamamigahie. ");
INSERT INTO knb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kagaya kafuma hisaya veaꞌma amaya hugahena tamaga kayamoꞌa hauga kayamo hisia yana oꞌagesigeka kesi momaya huo. ");
INSERT INTO knb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kesi ako huka veaꞌmoꞌya onagesagi huka amaya hisanana ani yakaꞌa Anumaya Koti, Negafaꞌa, kesi kavaꞌma nehaya yana neꞌagea kanomoꞌa age-maineanagino kanaleꞌya huno anonakaꞌa kamigahie. ");
INSERT INTO knb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nunamuma hutama havigegahena vagala vayaꞌmoꞌya nehaya kava hutama Anumaya Kotina havi-okeho. Ani vayaꞌmoꞌya mono nopiꞌene ka agegayaleꞌene “Muki veaꞌmoꞌya tagesae.” huꞌya hetiꞌya Anumayamotega havinegae. Nagaya tamagelafa huꞌna tamaha-nepauve vayaꞌmoꞌya anonaꞌamia hai ali-mainae. ");
INSERT INTO knb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ali-mainagi kagaya oꞌagesaya kava huno mainea Nelafana Anumayamotegama havigegahena nokafinaga fita ki-maleteka maineka falakika havigesanageno Negafaꞌa kesi kavaꞌma haya yama neꞌagea kanomoꞌa ani yana ageteno anonakaꞌa kamigahie. ");
INSERT INTO knb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nunamuma hugahena Anumayamo kema nohaviya veaꞌmoꞌya havinegaya kavala hutama kasagoꞌya afa keyaga hutama havi-okeho. Ani veaꞌmoꞌya ayaꞌaya nunamu ke nehuꞌya mage huꞌya amakesa nehaviye “Ayaꞌaya ke huta havigesunageno havigahie.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nehagi amakaya nehaya kavala amakave omaleho. Nelamafama havi-oketama maiya kanafina nago yatamima omalene hutama haya yatamia ago havimaineafe nagoꞌene tutu hu-oꞌateho. ");
INSERT INTO knb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Anumayamotega havigenutamahena mage hutama havigeho “Ikapinaga mainana Nelafaga kagai kagimoꞌa alu aotage huno hanesie. ");
INSERT INTO knb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kava yagaisana kanamoꞌa efalote hisie. Kahaisia kavala ikapinaga nehagi mopaleꞌenena kahaisia kavala hisae. ");
INSERT INTO knb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Meni kanafina nesuna kavela tamio. ");
INSERT INTO knb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tagaya havi kavaꞌma hu-la-tenaya veala aige amateta kefo yaꞌamia atale-ma-tona kava huka kefo yatia aige-tateka atale-lato. ");
INSERT INTO knb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kana yapiꞌene Sataniꞌma aye-lavataga hisia yapiꞌene tavaleka otato. Sataniꞌa ‘Kefo kava hiho.’ hunoꞌma hu-la-tesigeka tahaꞌmaika tavalesaga huo.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Huteno mage huno hie tamakaya havi yama hu-lamatenaya veala aigeꞌama-tetetama kefo yaꞌamima atale-ma-tesayana ikapinaga mainea Nelamafaꞌa aniꞌa huno kefo yatamia aige-tamateno atale-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Atale-lama-tegahigi tamakaiꞌma ali-havi yama hu-lama-tenaya veafena aigeꞌama-tetama kefo yaꞌamima atale-oꞌama-tesayana ikapinaga mainea Nelamafaꞌa aniꞌa huno kefo yatamia aige-tama-teno atale-otamategahie. ");
INSERT INTO knb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tamakaya Anumaya Kotitegama havigegahena kavela mositama mainutama tamaugosa kalaguꞌnagu ohiho. Vagala veaꞌmoꞌya ani kava huꞌya amaugosafina hapaene taꞌnefaene faleteꞌya mage nehae “Veaꞌmoꞌya tageteꞌya kaveꞌma mosi-mainona kavala tagegahae.” huꞌya nehayanagi tamagelafa huꞌna tamaha-nepauve naꞌa kava nehaya veaꞌmoꞌya anonaꞌamia hai ali-mainae. Tamakaya aniꞌa kavala ohiho. ");
INSERT INTO knb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Tamakaya Anumayamotegama havigegahena kaveꞌma mositama nemainutama titeti tamaugosa alitama masavema falesayana mukiꞌa veaꞌmoꞌya kaveꞌma mosisaya yafena ohavigahagi mai falakino mainea Nelamafaꞌa falakino hanea yana agaiꞌage neꞌageafe anonatamia tamamigahie. ");
INSERT INTO knb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Monetamiene afenoꞌyatamienena ma mopale halaꞌya ohiho. Halaꞌya hu-malenesageno toto ayeno hakaꞌnomoꞌya ali haviya higeꞌya veaꞌmoꞌya notamifi haiꞌya ani yatamia musufa aligahae. ");
INSERT INTO knb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Naꞌa hugahagi ma mopafi yafena tamakesa havi havi ohutama haenagama ikapinaga kanale yama alisaya yafe meni kanafina Anumayamofe tamakesa havi havi hutama maiho. Ikapinaga mukiꞌa yama malesayana totona ayeno okasaligahie. Hakaꞌnomoꞌa ali haviya ohugahie. Nagoꞌa musufa veaꞌmoꞌya ani kumatela musufa yana ohugahae. ");
INSERT INTO knb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Muse yatamima malenesaya kumatefe tamakesa havi havi hutama ani kumate umaigahae. ");
INSERT INTO knb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Tamaulagamoꞌa tamakupinaga aye halesia lamu hane. Tamaulagamoꞌa kanale yama huno agesiana tamakupinaga ai-hale-mainegi tamaulagamoꞌma kefo yama agesiana tamakupinaga hani-ki-maine. Ai-hale mainesia yamoꞌa tamakupima asu hisigenoꞌa hani kiteno ala hanikefa kino aye-talako hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nagoke kanomoꞌa “Tole kava kanolatamo aliꞌya kanoꞌania maisue.” huno ohisie. Naꞌama hisiana nago kava kanomofena “Nahaiya kano mainane.” huno hu-tegahianagi nago kava kanomofena “Hai vaiteno naipa nagata aiya kano mainane.” huno hugahie. Nago kava kanomona aguꞌa amiteno nago kanomofena “Falote onahaiya kava nehane.” huno hugahie. Tamakaya aniꞌa hutama Anumaya Kotifeꞌene moneheꞌenena ali lokaeꞌana “Kava yagai-natesaꞌe.” hutama ohiho. ");
INSERT INTO knb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ani yafe nagaya tamaha-nepauve kanaleꞌya hutama maisaya yaꞌene kave nesaya yaꞌene ti nesaya yaꞌene tamakesa havime havime oꞌviho. Tamaugafale kena failisaya yafeꞌenena tamakesa havi havi ohiho. Kave neyana aifa letale yanagi tamahaimula kanaleꞌya hutama maisaya ya hane. Kena fai-lisana yana amegale yanagi veaꞌnea tokiyaꞌage ya mainae. ");
INSERT INTO knb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Haleꞌyama vaiyatete nehaya namayaga ageho. Amakaya avina yana nofaiye. Kavela hoyafinagati aliꞌya nopina mo nomalagi ikapinaga mainea nelamafaꞌa kavela neꞌamamigi tamakaya Anumaya Koti aulagafina namayaga amakasetama mainaya veaꞌne mainayafe tamakaiꞌenena kava yakai-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tamakaipitila nago kanomoꞌa “Ofaliꞌna nagoꞌene maime maime haigahue.” huno tokiyaꞌage agesama havisiana anima havisia katela hanaꞌa huno falote hugahie? Aꞌao falote ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Naꞌa higetama kenatamihena tamakesa havi havi nehae? Ageho talapinaga vilasiyamoꞌya haiꞌya ausea nehae. Aliꞌyana aliꞌya kenaꞌamia talo huꞌya fai-noꞌaligi kanale kenaꞌamia hanegeꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nagaya tamaha-nepauve nayoma mainea ala sauve kanotamia Solomoniꞌa kanale kenaꞌa fai-lianagi ma vilasiyamoꞌa kanaleꞌya huno agase-maine. ");
INSERT INTO knb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tala yana meni kanafina hoyafina haneanagi ega hataga huꞌya atafi kae-talegahagi Anumaya Kotiꞌa ani tala yana kava yagaigeno kanaleꞌya huno hanegi tamakaya mukiꞌa veaꞌmogatama nagaifena tamakupi maletama tamametitia osi kanoꞌa nehayanagi Anumaya Kotiꞌa aniꞌa huno tamakaila kenatamia alino hilato hu-lamategahie. ");
INSERT INTO knb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ani yafe “Kaveꞌene tiꞌene na ya negahune?” hutama tusiꞌa tamakesa havi havi ohiho. “Na kena fai-ligahune?” hutama tamakesa ohaviho. ");
INSERT INTO knb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ani augafa yafena Anumaya Koti kema nohaviya veaꞌmoꞌya amakesa havi havi huꞌya nemaigi ikapinaga Nelamafaꞌa nesaya yaꞌene kena fai-lisaya yaꞌenefena ago havimaine. ");
INSERT INTO knb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Havimaineafe tamakaya hagotetama Anumaya Kotiꞌma kava yagaisia kumate visaya yafeꞌene agaiꞌama nehaiya fatago kavaꞌma hisaya yafeꞌene tamakesa havi havi hisayana Anumaya Kotiꞌa ani yaꞌene mukiꞌa kavetamiene kenatamienena tamamiteno ani kumatela tamavaleno tamategahie. ");
INSERT INTO knb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Naꞌa hu-maineafe “Ega hanaꞌa hugahune?” hutama tamakesa ohaviho. Egama efalote hisiana tamakesa havi havi hisaya yaꞌenena efalote hugahie. Nagoke yupa falote hisia kana yana ani yupa kanoꞌage tamakesa haviho. ");
INSERT INTO knb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nelamafufena “Naꞌa maꞌa hana kano mainane.” hu-oꞌateho. Aniꞌama ohisagenoꞌa Anumaya Kotiꞌa tamakaifena “Havi kava haya veaꞌne mainae.” huno hu-otama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tamakaya ani veafema “Naꞌa maꞌa hana kano mainane.” hutama hisayana ani augafa keleti Anumaya Kotiꞌa tamakaila aniꞌa hu-lama-tegahie. Ma mopaleꞌma nelama-fugamima hu-ma-tesaya kavala Anumaya Kotiꞌa tamakaila ani kava hu-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tagaya tagaiti taguꞌafima hanea yana oꞌageneta alu veaꞌnehena “Havi veaꞌne mainae.” huta hisuna yafena Yisasiꞌa mage huno hu-maine “Negafu aulagafina osiꞌa havi yana hanegeka neꞌagananagi naꞌa higeka kagaikaꞌa kaulagafina nagola muki yosa-lapagefa haneanagi ‘Omalene.’ huka nehane? ");
INSERT INTO knb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Naꞌa higeka nega-fufena ‘Kaulagafitila havi yana ali-talegahue.’ huka nehananagi kagaikaꞌa kaulagafina nagola muki yosa-lapagefa hane. ");
INSERT INTO knb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaguꞌafinaga hanea yana agelama ohuneka kavayaleti havige huka vagala kano maineka kagaikaꞌa kaulagafitila muki yosa-lapagefa ali-taleteka kanaleꞌya huka ageteka negafu aulagafina osiꞌa havi yana ali-talegane huno hie. ");
INSERT INTO knb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tamakaya Anumaya Kotina alu aotage yana alitama kalamogamina oꞌamamiho. Amamisayana mahaiye huꞌya tamakaila akafu tamanigahae. Afumogamina kanale sesua hagaꞌyu hutama oꞌamamiho. Amamisayana amaiyaleti ayeꞌya hapa kaligahae.” ");
INSERT INTO knb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Anumayamotega nago yafema havigesagenoꞌa afaꞌa tamamigahie. Nago yafema atiyesagenoꞌa ali falote hugahie. Fitaleꞌma akalu kaluma hisagenoꞌa Anumaya Kotiꞌa yaki-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mukiꞌa havigesaya veaꞌmoꞌya aligahae. Ati ayesaya veaꞌmoꞌya ali falote hugahae. Fitaleꞌma akalu kaluma hisagenoꞌa Anumaya Kotiꞌa yaki-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hana kanomoga nafaꞌnekamoꞌma mayahema kahavi-gesigeka nefaga yafana alika amigane? Aꞌao ani yana oꞌamigane. ");
INSERT INTO knb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Noyamehema kahavi-gesigeka nefaga osifaꞌvea alika amigano? Aꞌao ani yana alika oꞌamigane. ");
INSERT INTO knb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oꞌamiganagi tamakaya havi veaꞌne mainayanagitama nafaꞌnetamimona kanale yana neꞌamamiyanagi ikapinaga mainea nelamafaꞌa tusiya huno tamakase-maineanagitama havigesagenoꞌa kanale yana tamamigahie. ");
INSERT INTO knb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Veafe “Maꞌa kava hu-latesae.” hutama hisaya kavala ani kavakeꞌya alu veaꞌnea hu-mateho. Ani yafena Moseseꞌene Anumaya Koti amaune vayaꞌmoꞌyaene hu-mainaya kahegi kemona aepaꞌa hane. ");
INSERT INTO knb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Anumaya Koti kumateꞌma visayana osi fia kanoꞌafi ugahae. Hani-ki-mainea kumapi tegelege nehia atafi visaya kaana ala hiꞌyenagefa haneno ala kakefa hanegeꞌya kasagoꞌya veaꞌmoꞌya yoꞌyo huꞌya ani katela neꞌvagi tamakaya osi fia kanoꞌafi hai-faleho. ");
INSERT INTO knb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Agola maige maige hisuna kumateꞌma visaya kaana osi fia kanoꞌa haneanagiꞌya kasageke huꞌya ani katela kasagoꞌya veala noꞌvae. ");
INSERT INTO knb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nagoꞌa vayaꞌmoꞌya “Anumaya Koti ke hu-haleta nehuna vaya mainone” huꞌya havigegeꞌyama hisaya vayafena kaꞌyeho. Yuna afu kana vaya mainagetama neꞌagayanagi amakusafinaga kaveꞌage afu kana vaya mainae. ");
INSERT INTO knb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tamakaya amakaipima falote nehia kavala agetetama aepaꞌa hana augafa vaya mainae hutama havigahae. Ave nofite timaꞌa hanea alaga tagisifi? Aꞌao otagigahie. Avetanafa hanea uveꞌuve inomote hagaꞌage yosalaga motaga molagisio? Otagigahie. ");
INSERT INTO knb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Otagigahigi kanale yosamoꞌa kanale yosalaga neꞌayegi havi yosamoꞌa havi yosalaga neꞌaye. ");
INSERT INTO knb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kanale yosamoꞌa havi yosalaga noꞌayeanagino havi yosamoꞌa kanale yosalaga oꞌayegahie. ");
INSERT INTO knb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mukiꞌa yosamoꞌya kanale yosalaga oꞌayesayana atagiꞌya atafi kae-talegahae. ");
INSERT INTO knb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Naꞌa hinagetama havigegeꞌyama huꞌya falote nehisaya vayapiti falote hisia kavala agetetama aepaꞌa “Hana augafa vaya mainae.” hutama havigahae. ");
INSERT INTO knb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mukiꞌa veaꞌmoꞌya nagaifena “Anumayatimogae Anumayatimogae.” huꞌya hisaya veala Anumaya Kotiꞌma kava yagai-mainea kumatela ohaigahagi ikapinaga mainea Nenafana hau-mainesia kavaꞌma nehisaya veaꞌmoꞌya ani kumatela umaigahae. ");
INSERT INTO knb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anumaya Kotiꞌa kaiyekema hu-matesea yupa kasagoꞌya veaꞌmoꞌya nagaifena mage huꞌya hugahae “Anumayatimogae Anumayatimogae tagaya kagai kagile Anumaya Koti kea hu-haleta nehunane. Kagai kagile Kefo Avamula neꞌanatita tokiya avame yana amave-nelunane.” huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hugahayanagi nagaya ani yupa mage huꞌna hugahue “Tamakaila otamaketafa hu-mainoane. Kefo yakeꞌya hugetama omai veaꞌnegi nagaitegatila mai-haletama viho huꞌna hugahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nagoꞌa veaꞌmoꞌya anima hu-mainoa kea haviꞌya ali hipoꞌya huge huge huꞌya nago kanale agu agesaene kanomo avamete nehae. Ani kanomoꞌa noma kiana yafa agotofule ki-malene. ");
INSERT INTO knb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ki-malenegenoꞌa koꞌma aino tima hogino tokiyaꞌage yasimoꞌa tusiya huno nona ali-lagape aigahe hianagi yafa agotofule ki-malenea yafe alino lagapea ai-oꞌatalene. ");
INSERT INTO knb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Alino lagapea ai-oꞌatalenegi nagoꞌa veaꞌmoꞌya nagai kema haviteꞌya ali hipoꞌya ohayana agesama omalea kanomo avamete nehae. Ani kanomoꞌa ti kahaepapi nomaꞌa ki-malene. ");
INSERT INTO knb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ki-malenegeno koꞌma aino tima hogino tokiyaꞌage yasimoꞌa alino ani nona ali lagape aino mopafi atalegeno tusiya huno haviya hu-lavi-maine huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yisasiꞌa mani kea hu-haꞌno hutegeꞌya kahegi kema havilinaya anagaꞌmoꞌya nehaya augafa ke kana huno ohunegi tokiya yamaꞌa hanea kanomo ke kana hia yafe mukiꞌa veaꞌmoꞌya tusiꞌa amamaꞌyo ai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nagi Yisasiꞌa agoꞌyalegati tavigeꞌya kasagoꞌya veala akave umainae. ");
INSERT INTO knb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Akave neꞌvageno nagola fugitayamo augafa alino haꞌyagino atalako hu-mainea kanoa Yisasite eno ape huno mage huno havige “Anumayamoga kahaisigekahena nagaila alika hilato hu-natateꞌasine.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Higeno Yisasiꞌa ayana haꞌyo huno augafale avate hu-lineno mage huno hie “Nagaya nahaigeꞌna kaugafamoꞌa menia kanale hino huꞌna nehue.” huno higeno anile aupaꞌa kaliꞌa haꞌno hu-tene. ");
INSERT INTO knb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yisasiꞌa mage huno hapaiye “Ali hilato hu-ga-toa yafena nago kanoa haꞌopaika mono nopi kava kanomote* uka kalikaꞌama ali kanale hu-ga-toa kema mukiꞌa veaꞌmoꞌya havinuꞌyahena kagaya mono nopi kava kanomoꞌa kaugafa kamota huno kage-tesigeka kaugafama ali hilato hu-ga-toa yafena Moseseꞌma ‘Ma yama Anumaya Kotina amio.’ huno hu-mainea yana Anumaya Kotitega atalo.” huno tokiyaꞌage ke hapaiye. ");
INSERT INTO knb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yisasiꞌa Kapaneamu uvaꞌyi higeno nagola Lomu ati vayate kava kanomoꞌa mage mo havige “Anumayamoga naya hisano? Aliꞌya kanoꞌnimoꞌa muki augafa avayu hu-lavigeno tusi agata aigeno nopi nemaiye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Higeno Yisasiꞌa mage huno hie “Nagaya kaliꞌa mo aliꞌna kanale hu-tegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Higeno Lomu ati vayate kava kanomoꞌa mage hie “Anumayamoga nagaya kanale ohunoa kanomoni nopi esanana okategahigi afaꞌa malegati aliꞌya kanoꞌnimo kaliꞌahena keꞌa hu-tesanageno kaliꞌa falu hu-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nagaya kava kano mainoe. Nagaiꞌma kava yagai-natenea kanoa anale nagaseno maigeꞌna nagaya aniꞌa huꞌna nagoꞌa ati vayatela kava huꞌna mainoe. Nago kanomofema ‘Vuoma.’ hugenoꞌa umaine. ‘Enoma.’ hugenoꞌa emaine. Aliꞌya kanoꞌnihe ‘Naꞌa huo.’ hugenoꞌa aniꞌa hu-maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisasiꞌa ani kea haviteno agesa kuꞌmoꞌa tusiya huteno akaveꞌma neꞌvaya veaꞌmogamifena mage huno hie “Tamage tamaha-nepauve ma kanomoꞌa tusiya huno nagaifena havino agupi maleno ametitia hu-maine. Ma kanomoꞌma hia ya huꞌya nagaifema haviꞌya amakupi maleꞌya ametiti hu-mainaya veala mukiꞌa Yuta veaꞌne mainaya kumatela oꞌagenoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tamaha-nepauve mukiꞌa veaꞌmoꞌya yagemoꞌma tavi nefalelegatiꞌene evaꞌyi nehilegatiꞌene Anumaya Kotiꞌma kava yagai-mainea kumatela taginagomoꞌya Apalahamuꞌene Aisakiꞌene Yekopuꞌene siale mo maineꞌya kavela negahae. ");
INSERT INTO knb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Negahagi nagoꞌa Yuta veaꞌmogamina nayoma Anumaya Kotiꞌa “Kava yagaisua kumate maigahae.” huno hu-maineanagi agaifema haviꞌya amakupi omalaya yafe Anumaya Kotiꞌa amavaleno hani yapi amatalesigeꞌya anifi avi neꞌateꞌya amave kemoꞌa hugahae huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yisasiꞌa Lomu ati vayate kava kanomofe mage huno hie “Nokalega eteka vuo. Aliꞌya kanokama ali falu hu-tesua kea havika kagupi maleka kametiti hana kea hu-ga-tegahue.” huno higeno ani kema hia kana kanoꞌale ani aliꞌya kanoꞌa kanale hu-tene. ");
INSERT INTO knb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yisasiꞌa Pita nopinaga umaineno ageana Pitana aꞌamona itaꞌamo alekanoa tusiꞌa amukonako kali alino mainegeno moge-maine. ");
INSERT INTO knb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mogeteno ayate avate nehigeno amuko-nako kaliꞌamoꞌa agola kanale hu-tetegeno ani aꞌmoꞌa hetino kavela kaeno amamine. ");
INSERT INTO knb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ani unena mukiꞌa ani kumate veaꞌmoꞌya vayaꞌamima Kefo Avamuꞌmo amakusafima mainea veala amavaleꞌya Yisasite ageno Yisasiꞌa Kefo Avamuꞌmogamifena hu-mategeꞌya amataleꞌya vageno mukiꞌa kali veala alino kanale hu-matene. ");
INSERT INTO knb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Naꞌa hu-maineafe nayona Anumaya Koti aune kanomoꞌa, Aisaiyaꞌa hu-mainea kemoꞌa agola falote huno tamage hie. Mage huno hu-maineane “Agaya agaiꞌa kalima neꞌaluna yana ali-talene. Taugafamoꞌa fulu fuluma nehuno akavima nohia yaꞌene ago ali-talene.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kasagoꞌya veaꞌmoꞌya Yisasite meye-kove hageno Yisasiꞌa agaiꞌaene tokaeꞌya nemaiya anagafe mage huno hie “Tikotumona atu faliga vigetao.” huno higeꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Umainageno nagola kahegi kema havilinea kanomoꞌa Yisasite eno mage huno hie “Hu-mave-lina kanomoga mukiꞌa kumate visanana nagaya kakave ugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Higeno Yisasiꞌa kenonaꞌa mage huno hapaiye “Kepu yagamoꞌya faesaya komuꞌamia mopafinaga hanegi namamogamina noꞌamia haneanagi ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna faesua noniꞌa omalene.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nagola agai kema nehavia kanomoꞌa mage huno hie “Anumayanimogae nenafana falisigeꞌna aliꞌna he-vai-teteꞌna kakavela ugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Higeno Yisasiꞌa mage huno kenonaꞌa hapaiye “Atalo nagai kea ohavinesaya veala amaku amamemoꞌa fali-mainaya veaꞌmoꞌya falia kanomona aliꞌya he-vai-tegahae amakaiꞌami yanagi kagaya nakave eno.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisasiꞌa tipi kalefi haisaga hu-maigeꞌya agaiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya agaiꞌene umainae. ");
INSERT INTO knb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Neꞌvageno aupaꞌa anileti ala yasimoꞌa neꞌaligeno timoꞌa ai-galato huno ani tipi kalefi haiyanagi Yisasiꞌa aufaeno maine. ");
INSERT INTO knb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Faeno mainegeꞌya agaiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya agafa huꞌya mage huꞌya hae “Kava kanomogae kava kanomogae tagaya ti nakaita falisuna kava nehunagi Anumayamoga hetika taugafa ali-gatio.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hageno mage huno hama-vi-ge “Naꞌa higetama kolia nehae? Nagaifena havitama tamakupi maletama tamametitima nehaya yamoꞌa aupa nehio?” huno huteno hetino ani limofeꞌene yasimofeꞌene tokiyaꞌage ke huno “Taga huo.” huno higeꞌana alava hu-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Alava haꞌageꞌya mukiꞌamoꞌya amamaꞌyoma aiya yafena mage hae “Mani kanoa hana augafa kano mainegeno timoꞌene yasimoꞌene keꞌa haviteꞌya akave nemalae?” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ala tikotuna takaeꞌya ame kaiyaga agegayamona Kelasasa* veaꞌne mainalega uvaꞌyi hae. Uvaꞌyi hageꞌana tole kanolana Kefo Avamuꞌyaga anakuꞌafi mainea kanolana matimatipinagati Yisasite emainaꞌe. Ani kanolatana tusi aifoꞌnafo nehaꞌa yafe veaꞌmoꞌya koli huꞌya ani katela noꞌvayane. ");
INSERT INTO knb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Oꞌvageꞌana ani kanolatana ala kefiti mage huꞌana haꞌe “Anumaya Kotina neꞌamogae naꞌa hu-laꞌategahe neꞌane? Taꞌagata aisia kanamoꞌa falote ohunegi taꞌagata aisia kava hu-laꞌategahe neꞌano?” ");
INSERT INTO knb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Haꞌageꞌya kasagoꞌya afuyagamoꞌya aluꞌale maineꞌya kavela nenae. ");
INSERT INTO knb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nenageꞌya Kefo Avamuꞌmoꞌya Yisasife mage huꞌya hu-mainae “Anakusafinagatiꞌma hu-latesanana ani afuyagamo amakuꞌafi hu-lategeta vamano.” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Havigageno Yisasiꞌa “Anifi viho.” huno higeꞌya ani Kefo Avamuꞌmoꞌya ani kanolatamogani anakuꞌafitila hati-laviꞌya afuyagamogami amakupi hai-falageꞌya ani afuyagamoꞌya amaiya-yeꞌya nagola aulufi kapi taviteꞌya tipi asaga hu-laviꞌya ti nakaiꞌya fali haꞌno hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Fali haꞌno hageꞌya ani afuyagale kava vayaꞌmoꞌya ageteꞌya faleꞌya ala kumate mainaya veaꞌmogamife “Kefo Avamuꞌmoꞌya anakuꞌafi mainea kanolatamoganina na kava na kava hu-nateno higeta neꞌone.” huꞌya hama-pai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hageꞌya ani ala kumateꞌma mainaya veaꞌmoꞌya ani ya agegahe eꞌya Yisasina megeteꞌya “Tagai kumala neꞌataleka alu kumate vuo.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yisasiꞌa tipi kalefi haisaga hu-maino tikotumona takaeno agaiꞌa kumatega eteno umaine. ");
INSERT INTO knb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Umainegeꞌya nagoꞌa vayaꞌmoꞌya nago kanomona aiya aya fali-mainea kanoa hagifanale faeno mainegeꞌya avaleꞌya Yisasite emainae. Ageno Yisasiꞌa ageteno mage huno agesafinaga havimaine “Ma vayaꞌmoꞌya nagaife haviꞌya amakupi maleꞌya amametiti nehae.” huno agesa haviteno ani kali kanohe mage huno hapaiye “Nafaꞌneꞌnimoga kaha-nepauve menia kolia ohuo nagaya ago aige-ka-teꞌna kefo yakaꞌa atale-nega-toe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Higeꞌya kahegi kema havi-linaya anagaꞌmoꞌya amakaiꞌami amakuꞌafiti mage huꞌya hae “Ma kanomoꞌa Anumaya Kotife hu-haviya hu-neꞌate.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hageno Yisasiꞌa amakupinaga haviya kea haviteno mage huno hie “Naꞌa higetama tamakaya tamakesafinaga havi kea nehae? ");
INSERT INTO knb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nagayama huteꞌna hisua kea hana kemo kanaꞌagela hu-maine? ‘Aige-ka-teꞌna kefo yakaꞌa atale-neka-toe.’ huꞌna hisua kemoꞌo? Ifi kali kanomofe ‘He-ti-ka ka vuo.’ huꞌna hisua kemoꞌe? ");
INSERT INTO knb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna ma mopale maineꞌna aige-tama-teꞌna kefo yatamia atale-lama-tesua tokiyaꞌnia hane hutama havisaya yafe nago kavala huꞌna tamave-ligahue.” huno kalima neꞌalia kanomofena mage huno hie “Hetika hagifanaka neꞌalika nokalega vuo.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Higeno hetino nomaꞌalega umaine. ");
INSERT INTO knb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Naꞌa higeꞌya mukiꞌa alitalu hu-mainaya veaꞌmoꞌya ageteꞌya tusi amamaꞌyo aiteꞌya Anumaya Kotiꞌma tokiya yaꞌama vayaꞌmogamima amamia yafena Anumaya Koti agia alisaga hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Anile neꞌamataleno vilegati nago kanomo agia Matiuꞌe musufaya huno vaya amaugafaleti takisi mone ali-liteno nehia kanoa opisi nomaꞌale mopale mainegeno Yisasiꞌa ani kanoa mogeteno mage huno hie “Kagaya nakave eno.” huno higeno Matiuꞌa hetino Yisasina akave umaine. ");
INSERT INTO knb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Vigeno Yisasiꞌa Matiu nopi umaineno kave negahe musufayama huꞌya amaugafaleti takisi mone neꞌaliya vayaꞌene nagoꞌa kefo yama nehaya vayaꞌene ani nopi Yisasiꞌene agaiꞌenema tokaeꞌya nemaiya anagaꞌaene tokaeꞌya maineꞌya ne-mainae. ");
INSERT INTO knb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nenageꞌya Falasia vayaꞌmoꞌya Yisasiꞌenema tokaeꞌya nemaiya anagafe mage huꞌya hae “Naꞌa higeno tamakaiꞌma hu-lamave-nelia kanomoꞌa amaugafaleti takisi monema neꞌaliya vayaꞌene kefo yama nehaya vayaꞌenena kavela nene?” huꞌya hama-vigae. ");
INSERT INTO knb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hageno Yisasiꞌa ani kea ago haviteno mage huno hama-paiye “Kalima noꞌaliya veaꞌmoꞌya tota kanomotega oꞌugahagi kali veaꞌmoꞌyage tota kanomotega ugahae. ");
INSERT INTO knb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nagaya aniꞌa huꞌna ‘Fatago veaꞌne mainone.’ huꞌya nehisaya veaꞌnehe ke hugahe nagaya omenogi kefo yama nehaya veaꞌnehe ke hugahe emainoe. Anumaya Kotiꞌa agaiꞌa hu-mainea kea mage huno hu-maineane Afu heꞌya kolamaꞌa takiꞌya naminaya yafena onahaunegi kalagi ai-ma-taya yafekeꞌya nenahaiye huno hu-maineane. Hu-maineanagitama tamakaya ani kemo aepaꞌa mo havilama hutetama ani kavala hiho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yoni anagaꞌmoꞌya Yisasite mage huꞌya me havigae “Tagaya Yoni anagaꞌmogataene Falasia vayaꞌene nagoꞌa kavela mo-nesunanagi naꞌa higeꞌya kagaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya mukiꞌa kavela nenae?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hageno Yisasiꞌa mage huno hie “Nago kanoa aꞌama faiꞌya esagenoꞌa avaya hesia imu kisia yupa vayaꞌamoꞌyaene mainesigeꞌya ani vayaꞌmoꞌya hamauna hu-tesao? Aꞌao hamauna hu-oꞌategahayanagiꞌya haenagaꞌa nago kanama falote hisigeꞌya kame vayaꞌmoꞌya aꞌma alisia kanoa atafa huꞌya amakaipiti avale-talesageꞌya ani kanale vayaꞌamoꞌya hamau hu-teteꞌya mosigahae. ");
INSERT INTO knb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nago kanomoꞌa haegafa kena alino atafa kenalela maleno ohatigahie. Maleno hatisiana haegafa kena atalaga huno ali haviya hugahie. ");
INSERT INTO knb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nagi nago kanomoꞌa haegafa nofi alagamo timaꞌa* atafa mememo augafa ti keꞌayopina takino oꞌvaigahie. Takino vaisiana timaꞌamoꞌa kaꞌnuka hesigeno ti kena falo huno taki-lavinageno ti kena ali haviya hugahie. Haegafa nofi alagamo timaꞌa hefino haegafa meme augafamo ti keꞌayopi takino vaino. Aniꞌa hisayana tiꞌene keꞌayoꞌene kanaleꞌya huno hanegahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisasiꞌa ani kea nehigeno nagola soka kanomoꞌa Yisasi aiyafi aleꞌya meyeno Yisasina mage huno hapaiye “Munaꞌniꞌamoꞌa ago fali-mainegi kagaya kayana augafale me malesanageno fali-mainefitila eteno he-tisie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Higeno Yisasiꞌa hetino anilega vigeꞌya agaiꞌenema tokaeꞌya nemaiya anagala akave umainae. ");
INSERT INTO knb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Neꞌvageno nago aꞌmoꞌa tuelufuꞌa (12) kafu aigu nopinaga mukiꞌa kanale nemaiya aꞌmoꞌa Yisasina akavelegati eno kenaꞌamo atupale mevate hie. ");
INSERT INTO knb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Avate neꞌalino agupi mage huno hie “Kenaꞌaleke avate alisugeno kaliꞌnimoꞌa haꞌno hu-nategahie.” huno avate neꞌalie. ");
INSERT INTO knb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Avate higeno Yisasiꞌa mai-yahae huno ani aꞌmona ageteno mage huno hapaiye “Ma aꞌmoga kolia ohuo nagaifema havika kagupi maleka kametitima hana yamo kagaila alino kanale hu-negate.” huno higeno aupaꞌa kaliꞌamoꞌa kanale hu-tene. ");
INSERT INTO knb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Kanale hu-tegeno Yisasiꞌa soka kanomo note uvaꞌyi huno hamau nehuꞌya kapufama haya veaꞌnene avima ataya veaꞌnene ali-talu huꞌya maineꞌya tusi ke-yesoma haya kea haviteno mage huno hie “Viho mani munala fali lavata ohunegi afaꞌa faeno maine.” huno hama-paiye. Higeꞌya ani munaꞌma faligeꞌya age-mainaya yafenagiꞌya kigi hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hu-teteꞌya kumatega umainageno Yisasiꞌa nopinaga haino ani munaꞌmo ayate atafa nehigeno aupaꞌa hetie. ");
INSERT INTO knb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","He-ti-teanagi Yisasiꞌma hia yamo avagemoꞌa ute ete higeꞌya mukiꞌa ani kotega veaꞌmoꞌya havi-mainae. ");
INSERT INTO knb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisasiꞌa ani kumala ataleno neꞌvigeꞌana tole kanolana anaulaga asu hu-mainea kanolana akave neꞌuꞌana ala kefiti mage haꞌe “Kagaya Tevitina aginagomogae taꞌagaila kahau hu-laꞌato.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nehaꞌageno Yisasiꞌa nopinaga hai-falegeꞌana anaulaga asu hu-mainea kanolana agaite aꞌageno Yisasiꞌa ani kanolafena mage huno hana-vige “Nagaya tanaulaga aliꞌna hale-lanatesua tokiyaꞌnia hanea yafena tanakupina malenaꞌao?” huno higeꞌana “E, Anumayamogae kagaya aniꞌa hu-laꞌatateꞌasine.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nage haꞌageno Yisasiꞌa anaulagale aya maleno mage hie “Tanakaya nagaife havitana tanakupi malaꞌa yafe hu-lana-tegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Higeꞌana ani kanolamogani anaulagamoꞌa ai-gali hu-maine. Higeno Yisasiꞌa anakaifena tokiyaꞌage ke huno kahegi ki-nateno mage huno hie “Mani yama hu-lana-toa yafena nagoꞌa veala hamaꞌopaiꞌo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hianagi ani kanolamogania uꞌana mukiꞌa ani kotega veaꞌmogamina Yisasiꞌma hu-na-tea avagea hu-liteꞌana hu-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ani tole kanolana utaꞌageno nago kanomona Kefo Avamuꞌmoꞌa* aguꞌafi maineno avefuꞌna alino ai-yahae higeno agea noꞌaiya kanoa Yisasite avaleꞌya ae. ");
INSERT INTO knb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ageno Yisasiꞌa agema noꞌaiya kanomo aguꞌafiti Kefo Avamula anati-talegeno agea aino kea kea higeꞌya alitalu hu-mainaya veaꞌmoꞌya ageteꞌya tusiꞌa amamaꞌyo neꞌaiꞌya mage hae “Mani augafa kavala nayona Isaleli kotega oꞌagenaya kavale.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hayanagi Falasia vayaꞌmoꞌya mage huꞌya hae “Pielesepuliꞌa Kefo Avamuꞌyagale kava hu-mainea kanomoꞌa tokiya amigeno Kefo Avamuꞌmona anati-neꞌatale.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisasiꞌa ala kumateꞌene nagoꞌa ala kumaꞌyagaleꞌene osi kumaꞌyagaleꞌene neꞌuno mono nopi huge amave-lige huno Anumaya Koti kava yagai-ma-tesia kanale mono kea hama-nepaino mukiꞌa kalia alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hu-neꞌama-teno kasagoꞌya melitalu hu-mainaya veala amaketeno hau hu-ma-tene. Ani veaꞌmoꞌya kana yapi mainageno amakesa kuꞌmoꞌa tusiya higeꞌya sipi sipi kana huꞌya mainayanagi kava yagaisaya vayala omainaya yafe Yisasiꞌa kalagi ai-matene. ");
INSERT INTO knb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Kalagi ai-mateteno Yisasiꞌa agaiꞌenema tokaeꞌya nemaiya anagafe mage huno hama-paiye “Nagai kema havisaya veala kasagoꞌya kaveꞌmoꞌma hoyafima afule-mai-lemai hia kava hu-maineanagi hoyafima aliꞌya alisaya veala osi kanoꞌa mainayafe ani hoyamona Nefafena havigegeno nagoꞌa aliꞌya veala hu-matesie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisasiꞌa agaiꞌa tuelufuꞌa (12) anagaꞌamogamife ke higeꞌya ageno tokiyaꞌa amamine. Mukiꞌa Kefo Avamuꞌma veaꞌmogami amakusafiti anati-talesaya tokiyaene mukiꞌa kalima aliꞌya kanale hu-matesaya tokiyaene amamine. ");
INSERT INTO knb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Agaiꞌa tuelufuꞌa (12) anagaꞌamogami amakia hagote kanomo agia Saimoniꞌe nago agia Pitaꞌe aganaꞌamoꞌa Etaluꞌe Yemesigani Yonigania Sepeti nafaꞌnelataꞌene Filipiꞌene Patolomayuꞌene Tomasiꞌene amaugafaleti takesi mone neꞌalia kanoa Matiuꞌene Yemesiꞌa, Alafiusi nafaꞌne. Tatiusiꞌene Saimoni Selotiꞌene Yutasi Isakaliotiꞌa haenaga Yisasina agesi huno kame ya hu-tesia kanoe. ");
INSERT INTO knb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisasiꞌa ani tuelufuꞌa (12) anagaꞌa hu-neꞌamateno mage huno hama-paiye tamakaya Yuta vea omainaya veaꞌmogamitela oꞌviho. Samelia veaꞌmogami kumaꞌyagaleꞌene oꞌviho. ");
INSERT INTO knb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Oꞌugahagi tamakaya vaꞌyagi mainaya sipi sipi afuyaga kana hu-mainaya Yuta veate viho. ");
INSERT INTO knb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Neꞌutama mani ke hu-haletama hama-paiho “Anumaya Kotiꞌa kava yagai-lama-tesia kanamoꞌa ago aupaꞌa falote hugahie.” hutama hiho. ");
INSERT INTO knb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nehutama kali veaꞌnea ali kanale hu-matetama fali-mainesaya veala ali heꞌnelitama fugitaya amake-mainesia veala ali kanale hu-neꞌama-tetama Kefo Avamula veaꞌmogami amakusafinagatila amanati-taleho. Nagaya kanale yana afaꞌa nelamamuanagi anonaꞌa oꞌalinoane. Aniꞌa hutama anonaꞌa monea oꞌalitama afaꞌa amaya hiho. ");
INSERT INTO knb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tamakaya tamia alaga monene haesa monene kutamifina ai-oꞌaliho afaꞌa viho. ");
INSERT INTO knb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tamakaya kama visalega kutamia oꞌalitama oꞌviho. Tole kena oꞌaliho. Tamaiya noꞌene ayopatamiene alitama oꞌviho. Nagai aliꞌyama alisaya yateti veaꞌmoꞌya anonaꞌa kaveꞌma tamamisayana tama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tamakaya nago ala kumatelo osi kumatelo uvaꞌyi hisagenoꞌma nago kanomoꞌma kanale yama hu-lama-teno fatago kavaꞌma hisia kanoene maiho. Fae-litetama ohutama ataletama visaya yupa ani nopinagati viho. ");
INSERT INTO knb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tamakaya nago nopima hai-falenutamahena hagotetama mage hutama hiho “Ma nopi mainaya veaꞌmogatama Anumaya Kotiꞌa yuna hesaya tamaku tamakesa tamamisie.” hutama hu falu fala hu-mateho. ");
INSERT INTO knb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hu-matesageꞌya ani nopi mainesaya veaꞌmoꞌya fatago kavaꞌma nehisaya veaꞌma mainesagenoꞌa Anumaya Kotiꞌa yuna hesaya amakesa amamigahianagi aniꞌa augafa veaꞌnema omainesayana anima yuna hesaya yana oꞌaligahae. ");
INSERT INTO knb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nagoꞌa veaꞌmoꞌya tamavaleꞌya noꞌamifima otama-teꞌya ketamima ohavisagetamahena ani kumala neꞌataletama “Havi kava hae.” hutama tamaiyafima hanesia kugukege yana ai-fopo hu-neꞌataletama alu kumate viho. ");
INSERT INTO knb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tamage-lafa huꞌna tamaha-nepauve Anumaya Kotiꞌa kaiyekema hu-matesia kanafina Sotomu mainaya veaꞌmoyaene Komola mainaya veaꞌmoyaene amaugafa amagata aigahianagi tamakaiꞌma falu fala hu-otama-tesaya kumate veaꞌmoꞌya anima kaiyeke hu-ma-tesia yupa tusiya huno amagata aigahie. ");
INSERT INTO knb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Haviho nagaya tamakaila hu-lama-togetama sipi sipi kana hutama afai kala kana kaveꞌage veaꞌne mainesaya amuꞌnopi hu-lama-tesugetama visageꞌya hu-haviya hu-lama-tesagetama osifaꞌvemo kalope lavino neꞌvia avamete hutama tamakesaene vayalagi nama kana hutama kefo yana ohutama yuna hetama maiho. ");
INSERT INTO knb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tamaugafa ali haviya hu-lama-tesaya vayafena kaꞌyeho. Vayaꞌmoꞌya tamavaleꞌya kanisole vayate kaiyeke mo hu-lama-teꞌya mono nopina kaꞌyona tamamigahae. ");
INSERT INTO knb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tamakaya nagai kema akave malenaya yafe tamakaila Kamani kava vayateꞌene ala Sauve vayateꞌene kaiyekea hu-lama-tesaya yafe tamavaleꞌya amaufi tama-tesagetama nagai kanale mono kea hama-paisageꞌya nagoꞌa Yuta veaꞌne omainaya veaꞌnene havigahae. ");
INSERT INTO knb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tama-valeꞌyama kaiyekema hu-lama-tesaya yate tama-tesagetama kolia ohutama “Kenonaꞌamia naꞌane hisune?” hutama tamakesa kuꞌmoꞌa ohiho. Ani yupa kanoꞌa Anumaya Kotiꞌa “Mage hiho.” huno tamaha-painagetama hugahae. ");
INSERT INTO knb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tamakaitamigeꞌya ani kea ohugahagi Nelamafa Avamuꞌmoꞌa ani kea tamakaila tamavayafiti hugahie. ");
INSERT INTO knb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ani kanafina veaꞌmoꞌya amakaiꞌami nepuꞌamimona kame vayaꞌamimote amavaleꞌya visageꞌya “Hamaegeꞌya faliho.” huꞌya hugahae. Nefaꞌa nafaꞌneyagaꞌa ani kava hu-ma-tegahae. Nafaꞌneyagamoꞌya itaꞌafoꞌamimogamina ali-yahae huꞌya kamea hu-ma-teteꞌya “Hamaetama faliho.” huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nagima neꞌayaya yafe mukiꞌa veaꞌmoꞌya amaipa kafa he-lama-tegahagi nagoꞌa veaꞌmoꞌya nagai kema meni kanaleti aepa heꞌya atafa huꞌya tokiya hume hume neꞌvisageꞌna nagaya eteꞌnama esua kanafina nagai kema atafa hu-linaya veaꞌmogamina Anumaya Kotiꞌa amaku amamena ali-gatigahie. ");
INSERT INTO knb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Veaꞌmoꞌya havi kavaꞌma hu-lama-tesagetama ani kumala neꞌataletama nago kumate viho. Tamage-lafa huꞌna tamaha-nepauve mukiꞌa Isaleli kumatela oꞌunesageno ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna egahue. ");
INSERT INTO knb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nago sugulufi mainesia nafaꞌnemoꞌa hu-ve-nelia kanoꞌamona oꞌagasenea yanagino aniꞌa huno nago aliꞌya kanomoꞌa kava kanoꞌamona oꞌagasene. ");
INSERT INTO knb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sugulufi mainesia nafaꞌnemoꞌa hu-ve-nelia kano kana huno maisiana kanaleꞌya hugahie. Aniꞌa huno aliꞌya kanomoꞌa kava kanoꞌamoꞌene nago avamete huno maisiana kanale hugahie. Nagaifena mage huꞌya hu-mainae “Pielesepulia Kefo Avamuꞌyagale kava kanoꞌami maine.” huꞌya hu-haviya hu-nenateꞌya aliꞌya veaꞌnimogamina tusiya huꞌya kamuge hatageꞌya vai-lama-tegahae. ");
INSERT INTO knb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ali haviya hu-lama-tegahayanagi amakaifena kolia ohiho. Aiso hu-mainea yamona Anumaya Kotiꞌa mukiꞌa alino fufute atalegahie. Falaki-mainesia yamona Anumaya Kotiꞌa mukiꞌa veaꞌmogami amaulagafi ali-falote hugahie. ");
INSERT INTO knb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hanipinaga tamaha-pai-mainoa kea yagefi hama-paiho. Sumi sumi huꞌya tamaha-pai-mainaya kea kuma amuꞌnopiti ala kefiti keha keha hutama hiho. ");
INSERT INTO knb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amega tamaugafaꞌage he-falisaya veafena kolia ohiho. Ani vayaꞌmoꞌya tamaku tamameꞌenema tamahae falisaya tokiyaꞌamia omalene. He-faliteno hanimo aguꞌafi ata tege-lege nehia yapi tamaku tamameꞌene tamaugafaene he-falisia tokiya hanea kanoa, Anumaya Kotifeke, tusiya hutama kolia hiho. ");
INSERT INTO knb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tolea osi namalatana nagoke haesa moneleti miya nehayanagi nagoke ani nama kanoꞌa afaꞌa ofalinegi ikapinaga Nelamafaꞌa “Falisie.” huno ohinagenoꞌa ofaligahie. ");
INSERT INTO knb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Tamakaya mukiꞌa namayaga agasetama veaꞌnea ala yaga mainae. Anumaya Kotiꞌa mukiꞌa hanea tamayolagefa ago hapalino havilinea yafe kolima hisaya yana neꞌataletama afaꞌa maiho. ");
INSERT INTO knb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yisasiꞌa mage huno hie “Nagoꞌa kanomoꞌa veaꞌmogami amaulagafi nagaifema ‘Yisasina naguꞌa amitafa hu-mainoe.’ huno hu-falote hisigeꞌnahena nagaya ikapinaga mainea Nenafa aulagafina agaifena ‘Nagai nafaꞌne maine.’ huꞌna hu-falote hugahue. ");
INSERT INTO knb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hu-falote hugahuanagi nagoꞌa veaꞌmoꞌya veaꞌmogami amaulagafima nagaifena ‘Naguꞌa amitafa ohunoe.’ hunoꞌma hu-falote hisigeꞌna nagaya ikapinaga mainea Nenafa aulagafina ani kanohena ‘Oꞌagenoa kano maine.’ huꞌna hugahue.” ");
INSERT INTO knb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tamakaya na tamakesa nehaviye? “Ma mopale taipa falu huta maisuna yana tamigahe Yisasiꞌa emaine.” hutama nehao? Aꞌao nagayama emainoafenagitama tamakaya tuma hisaya yatetila falu hutama omaigahae. ");
INSERT INTO knb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Omaigahagi nagaya emainoafe nago afamopina nafaꞌneꞌamoꞌa nefana kame hu-tesigeno munaꞌamoꞌa itaꞌamona kamea hu-tesigeno anofeloꞌamoꞌa anauꞌamona itaꞌamoꞌene apasesaꞌa yamoꞌa falote hugahie. ");
INSERT INTO knb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nagoꞌa veaꞌmoꞌya nagai kea akave nemalayafe amakai afamola kame vayaꞌa maigahae. ");
INSERT INTO knb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nagoꞌa veaꞌmoꞌya itaꞌafoꞌamimofema “Afa veaꞌne mainagi Yisasiꞌa tamakase-mainea kanogiꞌna nagula aminoe.” huꞌya ohisaya veaꞌmoꞌya nagai nafaꞌne maisaya avametela ohune. Nagoꞌa veaꞌmoꞌya nafaꞌneꞌamimofeꞌene munaꞌamimofeꞌene “Afa vea mainagi Yisasiꞌa tamakase-mainea kanogiꞌna naguꞌa aminoe.” huꞌya ohisaya veaꞌmoꞌya nagai nafaꞌne maisaya avametela ohunae. ");
INSERT INTO knb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nagaila nagatama aisigeꞌna falisua yafema nagoꞌa veaꞌmoꞌya “Aniꞌa hugahune.” huꞌya amakaiꞌami yafaga yosa kofiꞌya nakave visaya amakesa ohavisaya veaꞌmoꞌya nagai nafaꞌne maisaya avametela ohunae. ");
INSERT INTO knb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nagoꞌa veaꞌmoꞌya maiyaꞌamima atafa huꞌya ali-talakoma hu-lisayana maiyaꞌamimoꞌa falino afaya hapaegahigi nagoꞌa veaꞌmoꞌyama nagaifema hamainageꞌya maiyaꞌamima atalesaya veaꞌmoꞌya maiyaꞌamia ali-gatisugeꞌya agola maige maige hugahae. ");
INSERT INTO knb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nagoꞌa veaꞌmoꞌya tamakaiꞌma tamavaleꞌya falu falama hu-lama-tesayana nagaila aniꞌa huꞌya navaleꞌya falu fala hu-nenatae. Nagaiꞌma navaleꞌyama falu fala hu-natesayana hu-na-tenea kanomona aniꞌa huꞌya falu fala hu-neꞌatae. ");
INSERT INTO knb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nagoꞌa veaꞌmoꞌya nago kanomona ageteꞌya Anumaya Koti ke hu-haleno nehia kanoma mainesigeꞌya falu falama hu-tesayana ani veaꞌmogamina Anumaya Kotiꞌa hu-haleno nehisia vayaꞌmogami amamisia avamete amamigahie. Nagoꞌa veaꞌmoꞌya nago kanomona ageteꞌya fatago auꞌava yama nehisia kanoma mainesigenoꞌma falu fala hu-tesiana ani veaꞌmogamina Anumaya Kotiꞌa fatago kanomo alisia avamete amamigahie. ");
INSERT INTO knb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nagoꞌa veaꞌmoꞌya nagola afa kanoa Yisasi kema nehavisia kanoma mainesigeꞌya yasi lima amisayana tamage huꞌna tamaha-nepauve ani veaꞌmoꞌya anonaꞌamia fanane ohugahianagiꞌya afaꞌa miyaꞌamia aligahae. ");
INSERT INTO knb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisasiꞌa tuelufuꞌa (12) agaiꞌaenema tokaeꞌya nemaiya anagaꞌmogamina huge ama-ve-lige huteno alu kumate kumate Anumaya Koti kea mo hama-paino hu-mave-li-maine. ");
INSERT INTO knb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Yoniꞌa ti fale neꞌamatea kanoa nofipi maineno Kalaisiꞌma hia kavafena haviteno nagoꞌa agaiꞌa anagala Yisasife havigegahe hu-ma-tegeꞌya mage huꞌya me hae “Kagaya egahiema hu-mainaya kano emainapi alu kanohe agava maisune?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hageno Yisasiꞌa mage huno hie “Tamakaya utama haviya yaꞌene agaya yaꞌene Yonina mo hapaiho. ");
INSERT INTO knb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma ya agone hutama hiho amaulaga asu hu-mainea veaꞌmoꞌya amaulaga neꞌagae. Amaiya haviya hu-mainea veaꞌmogami amaiyamoꞌa kanale hu-mate. Fugitaya amake-mainea veala kanale hu-mate. Amakesa tile-mainea veala eteꞌya nehaviye. Fali-mainaya veala hetiꞌya mainae. Afenoꞌami omalenea veala Anumaya Kotina kanale keꞌa nehaviye. ");
INSERT INTO knb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nagai kehema tole amakesa ohavisaya veaꞌmoꞌya kanaleꞌya huꞌya maigahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yoniꞌma hu-ma-tegeꞌya aya veaꞌmoꞌya neꞌvageno Yisasiꞌa anile mainaya veaꞌmogamina Yonife mage huno hamavige “Tamakaya kaꞌme kotega na ya mogegahe neꞌvae? Nago kanoa yasimoꞌa hopa kana huno ali fagagi mainea kanomona agegahe neꞌvao? ");
INSERT INTO knb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ifi na ya agegahe umainae? Kanale kena fai-linesia kano agegahe neꞌvao? Aꞌao kanale kena fai-linesaya vayala kaꞌme kotega omaigahagi sauve kanomo nopi maigahae. ");
INSERT INTO knb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na ya agegahe neꞌvae? Anumaya Koti aune kano agegahe neꞌvao? Ifi tamage tamaha-nepauve mukiꞌa amaune vayaꞌmogamina amakase-mainea kanoa Yoni maine. ");
INSERT INTO knb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yonife huꞌya nayona Anumaya Koti autaꞌmafina mage huꞌya kae-malenayane ‘Haviho nagaya Anumaya Kotiꞌna aliꞌya kanoꞌnimona hu-tesugeno uhagotegatenoꞌma visana kana valino ali-hilato huga-tegahie.’ huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tamage huꞌna tamaha-nepauve Yoniꞌa ti fale-neꞌamatea kanomoꞌa mukiꞌa ma mopale vayaꞌmogamina ago amakase-maineanagino nagoꞌa afa veaꞌmoꞌya Anumaya Kotife ‘Kava yagailato.’ huꞌya hu-mainesaya veala Yonina ago agase-mainae. ");
INSERT INTO knb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yoniꞌa ti fale-neꞌamatea kanomoꞌa kea hama-pai-mainea kanaleti aepa heꞌya tokiyaꞌami hanea veaꞌmoꞌya Anumaya Kotiꞌma kava yagai-lama-tesia yafe tokiyaꞌage huꞌya ‘Ani yapi maigahune.’ huꞌya hu-mainayanagi nagoꞌa vayaꞌmoꞌya tusiya huꞌya ani yafena kame nehae. ");
INSERT INTO knb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mukiꞌa kanafina Moseseꞌene Anumaya Koti amaune vayaꞌene kea hu-haleꞌya hu-mainayanagino Yoniꞌa evaꞌyi hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ani vayaꞌmoꞌya nagoꞌma esia kanomofena, Ilaiyaꞌe kanomofena ago tamaha-pai-mainayanagi ‘Yoniꞌa ani kano maineꞌ hutama havinutamahena havigahae. ");
INSERT INTO knb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tamakesama hanesia veaꞌmogatama haviho. ");
INSERT INTO knb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Meni kanafima mainaya veaꞌmogatamahena hanaꞌa veaꞌne mainae huꞌna tamaha-paisue? Ma ma hisua augafa nafaꞌneyagamoꞌya mainaya avamete hutama mainae. Ani nafaꞌneyagamoꞌya veaꞌne alitalu huꞌya mainalega maineꞌya alu nafaꞌneyagahena ke huꞌya mage huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Yaveꞌya aikolunana tamakaya amoa noꞌayae. Tagaya tahau hisuna yagame nehunana tamakaya avia noꞌatae.’ huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yoniꞌa ti fale-ma-te kanomoꞌa kaveꞌene haviliꞌene mosino emainegeꞌya amakaya ‘Satani Avamula aguꞌafina maine.’ huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hayanagi ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna tina kavela me nenogetama nagaifena ‘Kaveꞌene tiꞌene neno haꞌno hugeno omai kano maineno musufaya huꞌya amaugafaleti takisi neꞌaliya vayaꞌene kefo yama nehaya vayaꞌene vayaꞌamoꞌya mainae.’ huꞌya hu-mainae. Hayanagi Anumaya Kotina kanale agu agesama hanea yapiti kanale yana falote hu-maineafe vayaꞌmoꞌya ‘Fatago kava nehie.’ huꞌya hu-mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisasiꞌa mani kea huteno aepa heno agayama tokiya avame yama higeꞌya age-mainaya kumaꞌyagaletiꞌene ani kumate veaꞌmoꞌya kefo yaꞌamia neꞌataleꞌya amakuꞌa ai-yahae huꞌya akave nohaya yafe Yisasiꞌa tokiyaꞌage ke huno mage hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Avoꞌneo Kolasini mainaya veaꞌmogatamaene Petesaita mainaya veaꞌmogatamaene tusiya huꞌna tamakaifena nahau nehue. Tamakai kumapina nagaya tokiyaꞌage avameꞌyana ago huanagi tamaipa ai-yahae ohayanagiꞌna ani tokiyaꞌage avame yama Taiyaene Saitoniene huleꞌasina ani kumate veaꞌmoꞌya kefo yaꞌamihena ago amaipa ai-yahae huꞌya kefo yama hu-mainaya yafena kayavo kena fai-liꞌya taꞌnefafi maileꞌasine. ");
INSERT INTO knb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nagaya tamaha-nepauve Anumaya Kotiꞌa kaiyekema hu-ma-tesia kanafina Taiya mainaya veaꞌnene Saitoni mainaya veaꞌnene amaugafa amagata yana aligahayanagi tamakaya tusiya hutama nagoꞌene tamaugafa tamagata yana aligahae. ");
INSERT INTO knb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tamakaya Kapaneamu mainaya veaꞌmogatama ‘Taugafa alita anale haigahune.’ hutama nehao? Aꞌao afete tavitama tamakaye nehinagetama maigahae. Tamakai kumapi hu-mainoa tokiyaꞌage avame yana Sotomu kumateꞌma huleꞌasina ani kumate veaꞌmoꞌya amakuꞌa ai-yahae hu-mainaleꞌasina atafina fanane ohaleꞌasine. ");
INSERT INTO knb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tamaha-nepauve Anumaya Kotiꞌma kaiyeke hu-ma-tesia yupa Sotomu mainaya veala amaugafa amakata aigahianagi tamakaya amakasetama tusiya huno tamaugafa tamakata aigahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ani yupa Yisasiꞌa nunamuna mage huno hie “Nenafagae mukiꞌa ma mopafi yaꞌene ikapinaga yaꞌene kava yagai-mainana Anumayamoga kanale kava nehane. Nagoꞌa veaꞌmoꞌya ‘Havi haviꞌyati hanea vea mainone.’ huꞌya nehaya veaꞌmogamifena ohavisae huka fala-ki-malenane. ‘Ala avo nopi umainona vea mainone.’ huꞌya hisaya veaꞌmogamifena ohavisae huka fala-ki-malenanagi ‘Inamu nafaꞌne kana huta mainone.’ huꞌya nehaya veala ago amaveli-mainana yafena aluya huꞌna musekaꞌa nehue. ");
INSERT INTO knb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Nenafagae kagai kagu kagesamo hia kava huka ani kavala hu-mainane.” huno nunamuna hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Veaꞌmogamifena mage huno hu-maine “Nenafaꞌa mukiꞌa lokiya ago namine. Mukiꞌa veaꞌmoꞌya nagaila neꞌamonina aepaꞌnia ohavinagi Nenafaꞌa agaiꞌage nagai aepaꞌa haviline. Havilinegi mukiꞌa veaꞌmoꞌya Nenafa aepaꞌa ohavinae. Aniꞌa huꞌna nagaiꞌnige neꞌamoꞌna Nenafa aepaꞌa havilineꞌna nahaisia veaꞌmogamina hu-mave-lisugeꞌya Nenafana aepaꞌa havigahae. ");
INSERT INTO knb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tamakaya tusi aliꞌya neꞌalitama kana yama ali-mainaya veaꞌmogatama nagaitega egeꞌna mai-falu hisaya yana tamamino. ");
INSERT INTO knb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nagai aliꞌya aligeta tokaeta vaiyamano. Nagaya kayone kano maineꞌna naugafa aliꞌna ohai kano mainoafe aepaꞌnia havisageꞌna tamakuꞌamoꞌma mai-falu hisia yana tamamigahue. ");
INSERT INTO knb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tamakaya nagaiꞌene ai-lokaetama vaiyesayana kana ohugahianagitama yoꞌyo hutama vaiyegahae.” ");
INSERT INTO knb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nago Sapati yupa Yisasiꞌene agaiꞌaene tokaeꞌya nemaiya anagaꞌaene nago atili hoya amuꞌnopi neꞌvageno anagaꞌamogamina amakategeꞌya ani atilia kaleteꞌya takiꞌya ne-mainae. ");
INSERT INTO knb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nenageꞌya nagoꞌa Falasia vayaꞌmoꞌya amaketeꞌya Yisasifena mage huꞌya hae “Ago kagaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya Sapati yupama katile-malenaya yana ali haviya nehae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hageno Yisasiꞌa mage huno hie “Tamakaya Tevitina agava huꞌya umainaya vayaꞌene amaka-te-mainea yamo kea hapalitama ohavinao? ");
INSERT INTO knb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Amakategeno Tevitiꞌa Anumaya Koti nopi hai-faleno ‘Afa vayaꞌmoꞌya onesageꞌya mono nopi kava vayaꞌmoꞌya amakaiꞌamige negahae.’ huꞌya katile-malenaya maya Tevitiꞌa agaiꞌaene tokaeꞌya emainaya vayaꞌenena ne-mainae. ");
INSERT INTO knb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tamakaya kahegi kema kae-malenaya avopima hanea kea hapalitama ohavinao? Mage huno hu-maine mono note kava vayaꞌmoꞌya mukiꞌa Sapati yupa aliꞌyaꞌamia neꞌaliꞌya Sapatimo kahegi kemona atagayayanagi Anumaya Kotiꞌa ‘Kefo ya haya vaya mainae.’ huno ohune. ");
INSERT INTO knb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tamaha-pauve Anumaya Koti ala mono nomona agase-mainea kanoa nagaiꞌniꞌa ma mainoe. ");
INSERT INTO knb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nayona Anumaya Koti autaꞌmafina mage huꞌya kae-malenayane. ‘Nagaya Anumaya Kotiꞌna sipi sipia hetama kolama takiꞌya nenamiya kavafena nonahaigeꞌna kalagi ai-ma-tesaya yafeke nenahaiye.’ huꞌya kae-malenayane. Kae-malenagi tamakaya ani kema havilamama hu-mainaleꞌasina kefo yama ohunaya vayafena ‘Kefo ya nehae.’ hutama ohaleꞌasine. ");
INSERT INTO knb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna Sapati yupa kava yagai-mainoe.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ani kumala neꞌataleno mono nopi haino maine. ");
INSERT INTO knb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Maineno ageana nago kanoa aya avayu hu-lavi-mainea kanoa anile maine. Mainegeꞌya nagoꞌa vayaꞌmoꞌya Yisasiꞌa havi kavaꞌma hisiafene huꞌya ati neꞌayeꞌya Yisasife mage huꞌya hae “Sapati yupa kali kanoa alino kanale hu-tesia yana kanale yano?” huꞌya Yisasina havinegeꞌya amata hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yisasiꞌa mage huno hie “Nagola hana kanomoga afukama Sapati yupama komufi tavi-mainesigeka ago hevayu huka faitega ategano? E aniꞌa hugane. ");
INSERT INTO knb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Veaꞌmoꞌya afua agaseꞌya ala yaga mainaya yafenagiꞌya kahegi kemoꞌa ‘Sapati yupa kanale ya hu-ma-teho.’ huno hu-maine.” ");
INSERT INTO knb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Huteno ani ayama avayu hulavi-mainea kanomofe mage huno hapaiye “Kayana aipi huo.” huno higeno aipi hiana nago kaiyaga ayaꞌmoꞌma hia kava huno kanale hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kanale hianagi Falasia vayaꞌmoꞌya mono nopitila ataleteꞌya hati-laviꞌya melitalu huꞌya huge havige huteꞌya “Yisasina hanaꞌa huta haesunageno falisie?” huꞌya vege hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yisasina haegahema huge havige haya kea ago haviteno ani kumala neꞌataleno vigeꞌya kasagoꞌya veaꞌmoꞌya akave vageno mukiꞌa kali veaꞌmogamina kaliꞌamia alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hu-ma-teteno mage huno hie “Nagai aepaꞌa veala hamaꞌopaiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mani kema hia kemofena nayona Aisaiyaꞌa Anumaya Kotina aune kanomo hu-mainea kemoꞌa falote huno tamage hie. Mage huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Anumaya Kotiꞌa mage huno hie ageho mani kanoa nagai aliꞌya kano maisia yafe ago hapali-tenoe. Ani kanohena aluya huꞌna musena nehuꞌna nahau-mainea kanoe. Nagaya Avamuꞌnia amisugeno nagayama fatago huꞌna yagai-matesua kehena mukiꞌa Yuta vea omainaya veala hama-paigahie. ");
INSERT INTO knb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Agaya kea oꞌvaino ala kenake ohugahigi katega veaꞌmoꞌya nagola agea ohavigahae. ");
INSERT INTO knb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nagoꞌma fagagi mainesia hopama alino kofa ohuno aniꞌa huno fulu fuluma hu-mainaya veaꞌmoꞌmogamina kaꞌyona oꞌamamigahie. Asu hugahema hisia kaꞌnila asu ohuno aniꞌa huno fulu fuluma hu-mainaya veaꞌmoꞌmogamina kaꞌyona oꞌamamigahianagino agaiꞌa fatago kavala huge huge hisiana ani fatago kavaꞌamoꞌa havi kavaꞌmona agaseno haigahie. ");
INSERT INTO knb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Haisiana muki mopale Yuta vea omainaya veaꞌmoꞌya agai agihe haviꞌya amakupi maleꞌya amametiti hugahae. ");
INSERT INTO knb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nago kanomona Kefo Avamuꞌmoꞌa* aguꞌafi maineno aulaga alino asu huno avefuꞌna alino ai-yahae higeno agea noꞌaiyanagiꞌya Yisasite avaleꞌya ageno Yisasiꞌa ani Kefo Avamula anati-talegeno vigeno ani kanomoꞌa aulaga age-gali huno ageteno agea aino kea kea hie. ");
INSERT INTO knb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ani kava higeꞌya alitalu hu-mainaya veaꞌmoꞌya ageteꞌya tusi amamaꞌyo ai-mainae. Amamaꞌyo aigeꞌya mage hae “Mani kanomoꞌa Tevitina aginagomo maineo? Anumaya Kotiꞌa taugafa ali-gatigahema hutea kano maineo?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hageꞌya Falasia vayaꞌmoꞌya haviteꞌya mage hae “Pielesepuliꞌa Kefo Avamuꞌyagale kava hu-mainea kanomoꞌa tokiyaꞌa amigeno Kefo Avamuꞌmona anati-neꞌatale.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hageno Yisasiꞌa amakupi haviya amaku amakesa ago haviteno mage hie “Mukiꞌa nagoke kotega veaꞌmoꞌya aye-fako huꞌya tuma hisayana ani kotega veaꞌnene haviya hu-lavigahae. Nago kumate afamopina aye-fako huꞌya ‘Alu vaya mainone.’ huꞌya tuma hisayana ani kumaꞌene afamoꞌene haviya hu-lavigahae. ");
INSERT INTO knb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sataniꞌa agaiꞌa aliꞌya Avamuꞌyagamona anati-talesiana agaiꞌa nofi vayaꞌma aye-fako huꞌya ‘Alu vaya mainone.’ huꞌya hisayana Sataniꞌa kava yagaisia tokiyaꞌa hanaꞌa huno hanegahie? ");
INSERT INTO knb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nagaifena ‘Kagaya Pielesepulimo tokiyaleti anati-neꞌatalane.’ hutama hayanagi tamakaitami anagatamimoꞌa Kefo Avamula anati-talageno Pielesepulimo amakaila amaya nehio? Ani anagatamia amakaiꞌami manima haya kea ali fako huꞌya tamave-neliye. ");
INSERT INTO knb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tamage nagaya Anumaya Koti Avamuꞌmo tokiyaleti ani Kefo Avamuꞌyaga anati-neꞌataloafe Anumaya Kotiꞌa kava yagaisia kanamoꞌa tamakaitela ago emaine. ");
INSERT INTO knb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nagola tokiyaꞌage kanomoꞌma nomaꞌafima nago kanomoꞌa musufa ya hugahe vinunoꞌa hagoteno ani tokiya kanomona nofiteti ki-teteno afenoꞌyamaꞌa musufa yana hugahie. Nagaya aniꞌa hu-mainoafe Satanina agaseꞌna nofiteti ki-teteꞌna agai Avamula ago anati-talenoe. ");
INSERT INTO knb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nagoꞌa veaꞌmoꞌya nagai kanapa veaꞌne omaisayana kame vayaꞌniꞌa mainae. Sipi sipiꞌnima naya huꞌya ali-taluma ohisaya veaꞌmoꞌya amanati-neꞌatalae.” ");
INSERT INTO knb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Naꞌa hu-maineafe nagaya tamaha-nepauve mukiꞌa alu kefo ya alu kefo yaꞌene hu-haviya hu-neꞌataya yaꞌene Anumaya Kotiꞌa aigeꞌama-teno ani kefo yaꞌamia atale-ma-tegahianagi nagoꞌa veaꞌnemoꞌya Alu aotage Avamuꞌmofema hu-haviya hu-tesayana Anumaya Kotiꞌa aigeꞌma-teno ani kefo yaꞌamia atale-oꞌama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nagoꞌa veaꞌmoꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonihema hu-haviya hu-natesayana Anumaya Kotiꞌa aigeꞌama-teno ani kefo yaꞌamia atale-ma-tegahianagi nagoꞌa veaꞌmoꞌya Alu Aotage Avamuꞌmofema hu-haviya hu-tesayana Anumaya Kotiꞌa aigeꞌamateno ani kefo yaꞌamia meni kanafiꞌene haenagama falote hisia kanafiꞌene agola atale-oꞌama-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kanale yosama hanesigenoꞌa alagaꞌamoꞌenena kanaleꞌya hugahie. Havi yosama hanesigenoꞌa alagaꞌamoꞌenena haviya hugahie. Veaꞌmoꞌya yosalaga ageteꞌya kanale yosalaga hanesigeꞌyahena ‘Kanale yosa hane.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tamakaya osifaꞌvemo nafaꞌneyagamogatama havi vayalagitama hanaꞌa hutama kanale kea hugahae? Veaꞌmoꞌya amaku amakesafinaga havateteno ai-vali-lavi-mainea kea amavayafiti hu-falote nehae. ");
INSERT INTO knb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Fatago huꞌya mainaya veaꞌmoꞌya kanale amaku amakesa havilineꞌya kanale kavala nehayanagi kefo yama nehaya veaꞌmoꞌya havi amaku amakesa havi-lineꞌya havi kavakeꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nagaya tamaha-nepauve Anumaya Kotiꞌa veala kaiyekema hu-ma-teno ali fako hisia yupa mukiꞌa veaꞌmoꞌya amakesa ohavi ke huꞌya hu-haviya hu-ma-tenesaya kehena Anumaya Kotiꞌa hama-vi-gegahie. ");
INSERT INTO knb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hu-mainesana keleti Anumaya Kotiꞌa kagaifena ‘Havi kavala ohunane.’ huno hu-ga-tegahianagi hu-mainesana keleti ‘Kefo ya hu-mainane.’ huno hu-ga-tegahie.” ");
INSERT INTO knb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nagoꞌa kahegi kema havilinaya anagaꞌene Falasia vayaꞌene Yisasife mage huꞌya hae “Huma-ve-nelina kanomogae tokiya avame yana tavelio.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hageno Yisasiꞌa mage huno hama-paiye “Ma kanafima mainaya veaꞌmoꞌya tusiya huꞌya havi veaꞌne mainae. Anumaya Kotina amakaveꞌno hu-tenaya veaꞌne mainae. ‘Tokiyaꞌage avame yana tavelio.’ hutama nehayanagi alu avame yana Anumaya Kotiꞌa otamamigahigi nagoke avame yake tama-ve-ligahie. Nayoma mainea Anumaya Koti aune kanoa Yonaꞌma hu-mainea avame yamaꞌage tama-ve-ligahue. ");
INSERT INTO knb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonana ala noyamemoꞌa asaga huno nakaigeno tagufa (3) kegeꞌene felugaene aipafinaga mainea kava huꞌna ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna he-vai-natesageꞌna tagufa (3) kegeꞌene felugaene mopafinaga maigahue. ");
INSERT INTO knb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive kumate mainaya veaꞌmogamina Yonaꞌa Anumaya Koti kea hama-paigeꞌya kefo yaꞌamihena amaipa aiyahae hu-mainagi haviho menia Yonana agase-mainea kanoa ma mainegetama tamakaya kefo yatamihena tamaipa ai-yahae nohae. Tamaipa ai-yahae nohayafe Anumaya Kotiꞌa kaiyekema hu-lama-tesia kanamoꞌa nayoma Ninive kumate mainaya veaꞌmoꞌya hetiꞌya menia ma kanafima mainaya veaꞌmoꞌya kefo yama hu-mainaya yafena hu-falote hu-lama-tegahae. ");
INSERT INTO knb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nagola alu haupalegati emainea sauve aꞌmoꞌa mopamona atupaleti eno Solomonina kanale agu agesaene kanomo kea me havigahe emaine. Emaineanagi haviho Solomonina agase-mainea kanoa ma mainegetama tamakaya agai kea nohaviye. Nohaviyafe Anumaya Kotiꞌa kaiyekema hu-lama-tesia yupa ani aꞌmoꞌa hetino menia ma kanafima mainetama kefo yama nehutama agai kema nohaviya yafena hu-falote hu-lama-tegahie.” ");
INSERT INTO knb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nagola Kefo Avamuꞌmoꞌa vaya aguꞌafi haino maineleti ataleno viaꞌyamo hau hu-mainea kopinaga mo vaiyatete huno mai-faluma hisia kumafena ati yegeteana mai-falu hisia kumala oꞌagene. ");
INSERT INTO knb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Oꞌageno “Hagoteꞌna maigeꞌna emainoa agu nopi eteꞌna umaigahue.” huno huteno mogeana ani agu nopina vayala omaigeno ago sese huno kanale ya hu-malenegeno moge-maine. ");
INSERT INTO knb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mogeteno eteno viaꞌyamo seveniꞌa (7) kefo yaꞌamimoꞌma agase-mainaya Kefo Avamuꞌyaga momavaleno egeꞌya ani agu nopi hai-faleꞌya mainageno hagoteno ani kanomoꞌa nagoke Kefo Avamuꞌmo agu nopina mainegeno haviya huno maineanagino menia kasagoꞌya Kefo Avamuꞌmo agu nopina haiꞌya maigeno tusiꞌa kefo yatafa huno maine. Ani kavala menima mainetama kefo yama nehaya veaꞌmogatama hu-lama-tegahie huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisasiꞌa mani kea veaꞌmogamina hama-nepaigeꞌya itaꞌamoꞌene aganaꞌamoꞌyaene “Kea me hapaisune.” huꞌya kumatega emainae. ");
INSERT INTO knb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Emainageno nago kanomoꞌa Yisasife mage huno me hapaiye “Itakamoꞌene kaganakamoꞌyaene kea kaha-paigahe kumate me hetiꞌya mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Higeno Yisasiꞌa mage huno hie “Itaꞌnimoꞌene naganaꞌnimoꞌyaenena taꞌya mainae?” huno havi-ge. ");
INSERT INTO knb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Havigeteno agaiꞌaenema tokaeꞌya nemaiya anagatega ayana hagaꞌyu huno mage huno hie “Ageho itaꞌnimoꞌya naganaꞌnimoꞌya ma mainae. ");
INSERT INTO knb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ikapinagama mainea Nenafana haiya kava huꞌya avayama ali hipoꞌya nehaya veaꞌmoꞌya nagaila itaꞌnimoꞌya naganaꞌnimoꞌya nasaꞌnimoꞌya mainae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ani yupa Yisasiꞌa nopinagati hati-lavino tikotumo agegayalega mopale umaine. ");
INSERT INTO knb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mopale mainegeꞌya kasagoꞌya veaꞌmoꞌya agaitega melitalu huꞌya yageꞌyage haya yafe tipi kalefi hai-saga huno mainegeꞌya yageꞌyage haya veala ti agegayalega hetiꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Heti-mainageno Yisasiꞌa alu ke alu kea avame kefiti mage huno hama-pai-maine. “Nago kanomoꞌa viti avina faigahe alino vie. ");
INSERT INTO knb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Viaꞌyamo ani avina alino ai-he-lafino nefaigeno nagoꞌa avinamoꞌa kapi tavino hanegeno namayagamoꞌya nageno haꞌno hie. ");
INSERT INTO knb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nagoꞌa avinamoꞌa yafa mopafi taviteno osi mopa hanea yafe aupaꞌa hage-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hagetegeno yagemoꞌa hetino amuko-nako higeno hafuꞌya omalea yafe fayoteno asagali-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nagoꞌa avinayagamoꞌa avetaꞌnafa ino hanea amuꞌnopi tavino hageanagi avetaꞌnafa hanea inoꞌene tokaeno hageteno avetaꞌnafa inomoꞌa ayetegeno haviya hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nagoꞌa avinamoꞌa kanale mopafi tavino hageteno alagaꞌama ayeana nagoꞌa yosalela tetiꞌa (30) alaga ayegeno nagoꞌa yosalela sikisitiꞌa (60) alaga ayegeno nagoꞌa yosalela kasagoꞌya alaga vani hataletiꞌa (100) ayeno vasai-mai vasai-mai hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mani kea tamakesama hanesigetamahena havilama hutama haviho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage huꞌya havigae “Naꞌa higeka avame kefitila veaꞌmogamina hama-nepaine?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hageno Yisasiꞌa mage hie “Tamakaya Anumaya Kotiꞌa kava yagai-lama-teneanagitama falaki mainea kemona Anumaya Kotiꞌa tamaya higetama ago havi-linagi mukiꞌa veaꞌmoꞌya avame kema hama-paisugeꞌya amakesa havigahayanagi haviteꞌya havilama huꞌya ohavigahae. ");
INSERT INTO knb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Havilama huꞌya havilinaya veaꞌmogamina Anumaya Kotiꞌa nagoꞌene havisaya yana amamisigeꞌya havilama huꞌya havigahagi ‘Hai nehavune.’ huno hisaya veaꞌmogamina havilinayamaꞌa hamanafalegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ani veaꞌmoꞌya neꞌagayanagi agelama huꞌya oꞌagegahae. Amakesa havigahayanagi haviteꞌya havilama huꞌya ohavisayafe avame kefiti hama-nepauve. ");
INSERT INTO knb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ani kavaꞌma nehaya yafena Aisaiyaꞌa Anumaya Koti aune kanomoꞌa hu-mainea kemoꞌa ago falote huno tamage hie. Mage huno hu-maineane “Tamakaila tamakesamoꞌa havime havime haigahianagi ani kemona aepaꞌa havilama hutama ohavigahae. Tamaulagamoꞌa ageme geme haigahianagi nago yana agelama hutama ohugahae. ");
INSERT INTO knb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kemona aepaꞌa ohavisaya yafe amaku amakesa omale veaꞌne mainae. Amakesamoꞌa ani ke ohavisiafene huno amakesamoꞌa tile-maine. Amaulagamoꞌa ani yana oꞌagesayafene huno ago asu hu-maine. Havigu ani kea haviꞌya amakuꞌa ai-yahae huꞌya nagaitega esageꞌna ali hilato hu-lama-teyafene.” huno higeꞌya kae-malenayane. ");
INSERT INTO knb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Anumaya Kotiꞌa tamakaila tamaulaga kanaleꞌya hutama neꞌagaya yaꞌene tamakesama nehaviya yaꞌene tamaminea yafena tusiꞌa muse hutama maiho. ");
INSERT INTO knb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tamage huꞌna tamaha-nepauve “Nayona mukiꞌa mainaya amaune vayaꞌene fatago kavaꞌma hu-mainaya vayaꞌene tamakayama neꞌagaya yana ‘Agesune.’ huꞌya hayanagi oꞌagenae. Nehaviya kea ‘Havisune.’ huꞌya hayanagi ohavinayane.” huno hama-pai-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Avina yama fai-malenea kanomo avame kemona aepaꞌa hu-falote huꞌna tamaha-paisue. ");
INSERT INTO knb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kapima tavi-mainea avinamoꞌa maꞌa hu-maine nagoꞌa veaꞌmoꞌya Anumaya Koti kava yagai-latesia kea haviteꞌya havilama ohageno Sataniꞌa eno amakuꞌafiti anima fai-malenea kea ali-talene. ");
INSERT INTO knb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Yafa mopafima tavi-mainea avinamoꞌa maꞌa hu-maine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviꞌya muse huteꞌya aupaꞌa atafa hayanagi hafuꞌya mopafi otavia yamoꞌa alige atalege veaꞌne maineꞌya osi kana kanoꞌa osiꞌa haviꞌya amakupi maletageꞌya nagoꞌa veaꞌmoꞌya ani kea heꞌya fala-negiya yafe havi kanamoꞌma amakaite falote nehiana aupaꞌa Anumaya Koti kea neꞌatalae. ");
INSERT INTO knb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Avetaꞌnafa ino hanea amuꞌnopima tavi-mainea avinamoꞌa maꞌa hu-maine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviteꞌya ma mopafi mukiꞌa yaꞌyagaꞌamihena amakesa haviꞌya moneꞌamiene yokaloꞌamienefe kalagi aigeno ani yaꞌyagamoꞌa Anumaya Koti kea alino aiso hu-malegeꞌya atalageno alagamoꞌa aye he-lafino lama nohie. ");
INSERT INTO knb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kanale mopafima tavi-mainea avinamoꞌa maꞌa hu-maine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviteꞌya havilama hageno anifiti alaga mukiꞌa aye he-nelafie. Nagoꞌa veaꞌmoꞌya nagoke avina yosalela kasagoꞌya vani hataletiꞌa (100) aye-maine. Nagoꞌa veaꞌmoꞌya nagoke avina yosalela sikisitiꞌa (60) alaga aye-maine. Nagoꞌa veaꞌmoꞌya nagoke avina yosalela tetiꞌa (30) alaga aye-maine.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisasiꞌa nago avame kea mage huno hama-paiye. Anumaya Kotiꞌa kava yagai-lama-tesia yamoꞌa maꞌa hu-maine nago kanomoꞌa kanale avina yana hoyaꞌafina fai-malene. ");
INSERT INTO knb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Fai-malenegeꞌya veaꞌmoꞌya faeꞌya mainageno kame kanomoꞌa havi inoꞌmo alaga alino ani hoyafi ai-he-lafino umaine. ");
INSERT INTO knb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Utegeno haenaga ani viti alagamoꞌa neꞌayegeno havi ino talamoꞌa anifiti hageno nagopi hai-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Haigeꞌya aliꞌya vayaꞌmoꞌya hoyamona nefate mage huꞌya mo hae “Ala kanomogae kanale avinama hoyakaꞌafima fai-malananagi naꞌa higeno havi ino talamoꞌa anifitila falote nehie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Havigageno hoyamona nefaꞌa mage huno hie “Nagola kame kanomo mani kavala me hu-malene.” huno higeꞌya aliꞌya vayaꞌmoꞌya mage huꞌya havigae “Tagaya kanale uta havi inona vakai-talesuno?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Havigageno ani hoyamona nefaꞌa mage hie “Aꞌao, mo vakai-talesayana havigu kanale avinaene vakai-taleyafenagi ataleho. ");
INSERT INTO knb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Atalegeꞌana nagopi tokaeꞌana haneꞌo. Kaveꞌma afule yupa hoya aliꞌya vayaꞌnia mage huꞌna hama-paigahue ‘Hagotetama ino talana hakaitama atafi kaesayafe haꞌya kitetama nemaletama anile kanale avinamo yosaꞌa alitalu hutama kave noniꞌafi maleho.’ huꞌna hugahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisasiꞌa nagola avame kea hama-paino mage huno hie “Anumaya Koti kava yagai-lamatesia yamoꞌa maꞌa hu-maine nago kanomoꞌa masatati avina alino hoyafi fai-malene. Ani yosamo avina kanoꞌa oꞌagemo avina kanoꞌa haneanagino mukiꞌa alu alagayagamoꞌya ani alaga kanoꞌa agasageno osi hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nago kanomoꞌa ani avina kanoꞌa alino hoyafi fai-malegeno hageno ala huteno mukiꞌa hoyafima hanea yosayaga agaseno yosa haigeꞌya namayagamoꞌya me kale-maineꞌya ani yosamo akopale noꞌamia kigahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisasiꞌa nago avame kea mage huno hama-paiye “Anumaya Kotiꞌa kava yagai-lama-tesia yamoꞌa kai-hamema hale-negia avamete hu-maine. Nago aꞌmoꞌa ani kai-hamema halegisia yana alino taliꞌa (3) ala yopafi taꞌnefa falauvaꞌene ali havigu higeno haenagaꞌa mukiꞌa taꞌnefa palauvamoꞌa halegi-maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisasiꞌa melitalu haya veaꞌmogamina mukiꞌa kema hama-paiya kea avame kegeꞌya hama-nepaino nagola kea hu-falote huno hamaꞌopaine. ");
INSERT INTO knb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ani kavaꞌma hia yafena nagola Anumaya Koti aune kanomoꞌa hu-mainea kemoꞌa ago falote huno tamage hie. Ani kea mage huno hu-maineane “Nagaya avame kea hu-falote nehuꞌna nayoma ma mopama taloma hu-malenea kanaletiꞌma fala-ki-mainea kea menia hama-paigahue.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yisasiꞌa anima melitalu hu-mainaya veala amataleno nopinaga vigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage huꞌya me hae “Havi inomoꞌma hoyafima falote nehia avame kemona aepaꞌa hu-halegeta havimano.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hageno Yisasiꞌa kenonaꞌamia mage huno hie “Kanale avinama fai-malenea kanoa ikapinagati emainoa kanoa vayaꞌmo natenea kanoa nagaya mainoe. ");
INSERT INTO knb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mukiꞌa ma mopa ani hoyae. Anumaya Kotife ‘Kava yagai-lato.’ huꞌya nehaya veala ani kanale avina mainae. Satani kema akave nemalaya veala havi ino mainae. ");
INSERT INTO knb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kame kanoa havi inoma fai-malenea kanoa Sataniꞌe. Kaveꞌma afulesia yupa ma mopama haꞌno hisia kanae. Mani hoyafi aliꞌya vayala Anumaya Kotina ensole vayaꞌae. ");
INSERT INTO knb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ani havi inoma alitalu huꞌya mukiꞌa atafi kae-talesaya yana ma mopama haꞌno hisia yupa aniꞌa hugahae. ");
INSERT INTO knb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ikapinagati emainoa kanoa vayaꞌmo natena kanomonia ensole vayaꞌnia hu-ma-tesugeꞌya mukiꞌa veaꞌmoꞌya neꞌamafugamina ‘Kefo kava hiho.’ huꞌya ali haviyama hu-mainesaya veaꞌnene Anumaya Koti kema ali-tagae-mainesaya veaꞌnene Anumaya Kotiꞌa kava yagai-mainea yapitila amavaleꞌya hagaꞌyu hu-talegahae. ");
INSERT INTO knb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ala atagefafi hagaꞌyu hu-ma-talegahae. Ani atamoꞌa teno neꞌamasagalisigeꞌya amakata yana neꞌaliꞌya avovo huꞌya avi neꞌateꞌya amave kemoꞌa hugahae. ");
INSERT INTO knb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Havi veaꞌnea atafina kaegahayanagi fatago amaku amakesaene veala Neꞌamafaꞌa kava yagai-mainea kumatela hai-faleꞌya maineꞌya yagemoꞌma aye halea kava hugahae. Agesama hanesia kanomoꞌa havilama huno havisie.” ");
INSERT INTO knb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anumaya Kotiꞌa kava yagai-mainea yamoꞌa maꞌa hu-maine nagola mone keꞌayola hoyafi he-vai-malenaya avamete hu-maine. He-vai-malenegeno nago kanomoꞌa mopafiti moli-falote huteno eteno anifi he-vai-maleteno tusi muse huno aupaꞌa “Ma mopa miya hisugeno nagai ya hapaesie.” huno mukiꞌa afenoꞌyamaꞌa moli meli huno monea aliteno ani mopa miya hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Anumaya Kotiꞌa kava yagai-mainea yamoꞌa maꞌa hu-maine. Nago kanomoꞌa kitana kana yafena atiyege yegeteno nagola miyamoꞌa hai-mainea kitana kana yana alino falote hu-maine. Higeno “Ala mone namio.” huno higeno mukiꞌa afenomaꞌa moli meli huno mukiꞌa yamaꞌa ataleteno monea alino ani kitana kana yana miya hu-malene. ");
INSERT INTO knb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nago kene hugahue. Anumaya Kotiꞌa kava yagai-mainea yamoꞌa maꞌa hu-maine nagola noyame kukonagoma ti kotupima hagaꞌyu hu-talegenoꞌa alu noyamea alu noyamea hagagino fale-mainea avamete hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ani kukonagopina hiya higeꞌya ti agegayalega he-vayu huꞌya maleneꞌya kanale noyameyaga yopafi yogiꞌya nemaleꞌya havi noyameꞌa aliꞌya hagaꞌyu hu-neꞌatalae. ");
INSERT INTO knb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma mopama haꞌno hisia yupa ani kava hugahae. Ensole vayaꞌmoꞌya kefo yama hu-mainesaya veaꞌnene fatago kavaꞌma hu-mainesaya veaꞌnene amuꞌnopiti ali fako hugahae. ");
INSERT INTO knb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huteꞌya ani kefo veala amavaleꞌya tusiꞌa ata nelesia atafi hagaꞌyu hu-talesageno atamoꞌa teno neꞌamasagalisigeꞌya amakata aisigeꞌya avovo huꞌya amave kemo nehuꞌya avitegahae. ");
INSERT INTO knb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisasiꞌa mage huno hama-vige “Tamakaya mani kemona aepaꞌa havilinafi ohavinae?” huno higeꞌya “E, havilinone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hageno mage huno hama-paiye “Tamakaya mono kea havilinaya vayaꞌmogatama menia nagai kea nehaviya veaꞌne mainagi aniꞌa hutama nayoma Anumaya Koti kea hu-mainaya kene menima tamaha-nepauva kea Anumaya Kotiꞌa kava yagai-lama-tesia kenena havitetama ala afeno nomona nefaꞌa atafa kanale yaꞌene haegafa kanale yaꞌene nopiti alino neꞌamamia avamete hutama atafa kene yaufa kene hu-haletama hiho.” ");
INSERT INTO knb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisasiꞌa ani avame kea hu-haꞌno huteno ani kumala ataleno umaine. ");
INSERT INTO knb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Uteno ko aepaꞌalega Nasaleti uvaꞌyi huno mono nopi haino Anumaya Koti kea hama-paigeꞌya mukiꞌa veaꞌmoꞌya atali talu huteꞌya mage hae “Mani kea haviꞌyaꞌami hanea vayaꞌmogami avamete kea mukiꞌa hanateti alia ke nehie? Ayapitiꞌma tokiyaꞌa avame yama hu-mainea tokiyaꞌa hanateti ali-maine? ");
INSERT INTO knb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mani kanoa noma negia kanomo nafaꞌneo? Malia nafaꞌneo? Yemesiꞌene Yosefeꞌene Saimoniꞌene Yutasiꞌenena aganaꞌamoꞌya mainao? ");
INSERT INTO knb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mukiꞌa asaꞌamoꞌya tagaiꞌene nagopi mainagi agaya mukiꞌa tokiya yana hanateti ali-maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huteꞌya amaipa kafa heteꞌya amakaveꞌno hu-tageno Yisasiꞌa mage huno hie “Anumaya Koti kema nehisia kanomoꞌa mukiꞌa kumateꞌma mono kema hama-paisiana agia alisaga hugahayanagi agaiꞌa afamoꞌene no kumaꞌale veaꞌnenena agia alisaga ohugahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Higeno agaife haviꞌya amakupi maleꞌya amametitima ohaya yafe ani kumatela kasagoꞌya tokiya avame yana ohune. ");
INSERT INTO knb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ani kanafina Helotiꞌa sauve kanogino Yisasiꞌa mukiꞌama hu-mainea kavaꞌmona avageꞌa havimaine. ");
INSERT INTO knb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Haviteno Helotiꞌa agaiꞌa aliꞌya vayaꞌahe mage huno hie “Ma kanoa Yoniꞌe, tima fale-neꞌama-tea kanoa, fali-mainefitila ago heti-maineafe ayapitila tokiyaꞌage avame yana nehie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Helotina aganaꞌamo agia Filipiꞌe. Filipi aꞌmo agia Helotiasiꞌe. Helotiꞌa Helotiasina kumai a ali-tenea yafe Yoniꞌa Helotife mage huno hie “Anumaya Koti kea ali-tagaeka ali-tenane.” huno hu-mainea yateti Helotiꞌa Yonina atafa huno tokiya nofiteti nofi kiteteno kina nopi hu-tene. ");
INSERT INTO knb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nofi huteteno Helotiꞌa Yonifena “Haesugeno falisie.” huno hianagi mukiꞌa veaꞌmogamife koli hu-maine. Ani veaꞌmoꞌya Yonifena “Aune kano maine.” huꞌya haya yafe ohaene. ");
INSERT INTO knb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ohaenegi nago yupa, Helotina atenea kanahe, huꞌya muse hu-taya yupa nagoꞌa veaꞌmoꞌya Helotiꞌene melitalu hu-mainageno Helotiasina munaꞌamoꞌa mukiꞌa veaꞌmogami amuꞌnopi amoa aye-maine. Neꞌayegeno anima ayea yafena Helotiꞌa tusiya huno musena hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nehuno ani munafena mage huno hie “Nagaya tamage Anumaya Koti aulagafi kaha-nepauve kahaisia yafena hisanageꞌna afaꞌa kamigahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Higeno ani munaꞌmona itaꞌamoꞌa nagoꞌa agu agesa amiteno mage huno hie “Yoniꞌa ti fale-neꞌama-tea kanomo ageꞌya fakalika agenopaꞌa ai-fakalika yopafi maleteka me namio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Higenoꞌa ala sauve kanomo aipamoꞌa tusiꞌa kanaꞌage higeno Anumaya Koti aulagafima huno lokiya vai-malea yafeꞌene mainaya vayaꞌamofeꞌene agesa haviteno aliꞌya vayaꞌahe mage hie “Ani munaꞌmo kea ali hipoꞌya hiho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Huteno aliꞌya vayaꞌa hu-mategeꞌya kina nopinaga Yonina ageꞌya mo fakali-talenae. ");
INSERT INTO knb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Fakaliteꞌya hatagama haya anumaꞌa yopafi maleteꞌya ani munala aliꞌya memigeno itaꞌamotega alino umaine. ");
INSERT INTO knb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoni anagaꞌmoꞌya augafaꞌa me hipoꞌya huꞌya mo he-vai-teteꞌya Yisasina mo hapai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hapaigeno Yisasiꞌa ani kea haviteno tipi kalefi haisaga hu-maino kaꞌme kotega umaine. Vigeꞌya mukiꞌa veaꞌmoꞌya ani kea haviteꞌya kumaꞌamileti mopafi akave uꞌya anile umainae. ");
INSERT INTO knb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yisasiꞌa tipi kalefiti hati-lavino ti agegayalaga maineno ageana kasagoꞌya melitalu hu-mainaya veaꞌmogamina amaketeno kalagi ai-mateno kali neꞌaliya veala alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Une kigeꞌya agaiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya agaite mage huꞌya me hae “Tagaya vaya omai kaiyaga mainonanagino hani-kisia yafe mukiꞌa veaꞌmogamina hu-ma-tesanageꞌya kumaꞌma hanesilega ute ete huꞌya nesaya kavela miya hisae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hageno Yisasiꞌa mage huno hama-paiye “Naꞌa hinageꞌya ugahae? Tamakaitami kavela amamiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Higeꞌya mage hae “Tagaipina osi kave kanoꞌa hane faefuꞌa (5) mayaene tole noyame kanoꞌagi huno hane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hageno “Ani kavela alitama eho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Huteno Yisasiꞌa mage hie “Mukiꞌamogatama alitalu hute hute hutama apete mopale maiho.” huno higeꞌya mopale mainageno Yisasiꞌa faefuꞌa (5) mayaene tole noyamene alino ikapinaga age-saga huno Anumaya Kotitega huno muse huteno ani maya kolino agaiꞌaenema tokaeꞌya nemaiya anagaꞌa amamigeꞌya mukiꞌa veala amamite amamite hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hageꞌya mukiꞌa nageno amamu higeꞌya atalaya atupa-tapaꞌa aliꞌya tuelufuꞌa (12) kula ai-hava-te-mainae. ");
INSERT INTO knb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kaveꞌma naya vayaꞌyaga faefu tauseniꞌa (5,000) vemoꞌya ne-mainae. Ne-mainagi aꞌne nafaꞌneꞌamia ohapalinae. Ohavunamaꞌa aꞌne nafaꞌnene ne-mainae. ");
INSERT INTO knb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Netageno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌmogamina mage huno hama-paiye “Tamakaya nagaila nataletama tipi kalefi haisaga hu-maitama atu kaiyaga hagotetama utegeꞌna nagaya veala hu-ma-tesugeꞌya viho.” ");
INSERT INTO knb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hu-ma-tegeꞌya utageno agaiꞌage Anumayamotega havigegahe agoꞌyafi haino agaiꞌage mainegeno hani-ki-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hani-ki-geno tipi kalea ti amuꞌnopi utegeno yasimoꞌa aulegati eno ani lipi kalea molino mo ai-yahae me ai-yahae hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Koti avametega Yisasiꞌa timo agupile aiya aiyeme aiyeme tipi kalema hanelega umaine. ");
INSERT INTO knb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Neꞌvigeꞌya ani anagaꞌmoꞌya Yisasiꞌa ti agupileꞌma aiya ayeme ayeme eaꞌyana ageteꞌya tusiꞌa amamaꞌyo aiteꞌya mage hae “Hakalo neꞌefi?” huꞌya “Avovo.” hae. ");
INSERT INTO knb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Avovo nehageno aupaꞌa Yisasiꞌa mage huno hie “Kolia ohutama maiho. Nagaya neꞌogi tokiyaꞌage hutama maiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Higeno Pitaꞌa kenonaꞌa mage huno hie “Anumayamogae kagayama mainenuka nagaifena ‘Timo agupile kaiya ayeme yeme eno.’ huka hugeꞌna vano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Higeno Yisasiꞌa Pitafe mage hie “Kagaya elavika eno.” huno hapaigeno Pitaꞌa tipi kalefitila hati-lavino timo agupile aiya ayeme yeme Yisasitega ugahe hie. ");
INSERT INTO knb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ugahe hianagi ala yasimoꞌma tokiyaꞌage huno eaꞌyate ageteno koli huno tipi hapaꞌnesia ya huteno mage hie “Anumayamogae naugafa ali-gatio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Higeno aupaꞌa Yisasiꞌa ayana hagaꞌyu huno Pitana atafa huteno mage huno hie “Kagaya nagaifena havika osi kanoꞌa kagupina maleka kametitia hu-mainana kanomogae naꞌa higeka tole kagesa nehavine?” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Naꞌa huteꞌana tipi kalefi haisaga hu-maiꞌageno yasimoꞌa taga hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Taga higeꞌya tipi kalefima mainaya vayaꞌmoꞌya Yisasife muse huꞌya agia alisaga huꞌya mage hae “Tamage kagaya Anumaya Koti nafaꞌne mainane.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ani ti kotuꞌmona takaeꞌya Kenesale kotega uvaꞌyi hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vigeꞌya ani kumate veaꞌmoꞌya Yisasina age-lama huꞌya ageteꞌya alu kumate kumate ke huꞌya mage hae “Kali veala amavaletama eho.” huꞌya hageꞌya kali veala amavaleꞌya Yisasite emainae. ");
INSERT INTO knb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kali neꞌaliya veaꞌmoꞌya emaineꞌya Yisasife mage huꞌya havigae “Kenakamo atupalekeꞌya avate hisune.” huꞌya nehuꞌya avate hu-mainaya veaꞌmogamina kalimoꞌa kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Ani yupa nagoꞌa Falasia vayaꞌene kahegi kema havilinaya anagaꞌene Yelusalemuti Yisasite eꞌya mage huꞌya hae “Naꞌa higeꞌya kagaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya taginagomogami kea ali-tagaeꞌya kaveꞌma negahena amayana sese nohae?*” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hageno Yisasiꞌa kenonaꞌamia mage hie Naꞌa higetama tamakinagomogami auꞌavala akaveꞌma malaya yafe Anumaya Koti kahegi kea ago neꞌatagayae? ");
INSERT INTO knb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anumaya Kotiꞌa agaiꞌa autaꞌmafina mage huno hu-maineane. “Tamakaya itatami afotamimogami amakia alisaga nehutama keꞌamia veganokano ohutama amaiyaꞌafinaga maiho. Nago kanomoga itakafokamona kamugema vaitenukahena faligane.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Hu-maineanagi tamakaya mage hutama nehae “Nago kanomoꞌa itaꞌafoꞌamogani anaya hisia monema hanesigenoꞌma itaꞌafoꞌamoganima anaya ohinunoꞌa mage huno hisie ‘Ani monea Anumaya Kotina amisua yane huꞌna hu-mainoe.’ huno hinunoꞌa nefana aya huno agia alisaga ohisie.” hutama nehae. Ani ke nehutama tamakinagomogami auꞌavala akaveꞌma malaya yafe “Anumaya Koti kea afa ya kana nehie.” nehutama alitama neꞌatagayae. ");
INSERT INTO knb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Tamakaya vagala vaya mainae. Aisaiyaꞌa Anumaya Koti aune kanomoꞌa tamakaifena tamage huno Anumaya Koti autaꞌmafina mage huno hu-maineane “Ani nofi veaꞌmoꞌya amavayaleti nagai nagia alisaga nehagi amakuꞌamoꞌa aluꞌale hanegeꞌya ani kavala nehae. ");
INSERT INTO knb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ma mopafi veaꞌmoꞌya malenaya kahegi kehena ‘Mamona Anumaya Koti ke hanegi akave maleho.’ huꞌya nehayanagi nagai nagia alisaga nehayanagi afa kava maiꞌya nehae.” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yisasiꞌa agaite esae huno kasagoꞌya veaꞌmogamifena ke higeꞌya ageno mage huno hie “Tamakaya mani kea havilama hutama haviho. ");
INSERT INTO knb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nagola tamavayafima nesaya yamoꞌa tamakuꞌamona alino oniꞌyaꞌagela ohugahigi tamavayafitiꞌma hati-lavisia yamo ali-falote hisigeno tamakuꞌamoꞌa oniyaꞌagela hugahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya Yisasife mage huꞌya hae “Falasia vayaꞌmoꞌya ani kea haviteꞌya amaipa kafa he-gataya kea ago havimainano?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hageno Yisasiꞌa mage huno hama-paiye “Ikapinaga mainea Nenafaꞌa okalinesia yana agaiꞌa mevakaino hafuꞌyaene tagasi hugahie. ");
INSERT INTO knb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tamakaya mani vayafena tamakesa ohaviho. Amaulaga asu hu-mainea vaya mainae. Nagoꞌma aulaga asu hu-mainea kanomoꞌa nago aulaga asu hu-mainea afaluꞌamona avaleno vaiyesiana tolemogania komufi asaga hu-lavigaꞌe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Higeno Pitaꞌa Yisasife mage hie “Kagaya mani avame kemo aepaꞌa hugeta havimano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Higeno Yisasiꞌa mage huno hie “Tamakaya meni kanaene havilama ohunetama nehao? ");
INSERT INTO knb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tamakaya ohavinao? Mukiꞌa yama tamavayafi nageno tamakuꞌafina oꞌunogi tamaipafike taviteno haenagaꞌa aifayolagafi tavino afa ya kana nehie. ");
INSERT INTO knb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Afa ya kana nehianagi nago yana tamavayafitiꞌma hati-lavia kemoꞌa tamakupiti falote huno tamakuꞌamona alino oniꞌyaꞌagela nehie. ");
INSERT INTO knb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tamakuꞌafinagati efalote hia yana maꞌa huno falote nehie kanale ohu tagu tagesa nehavuna yaꞌene vaya he-fali kavaꞌene alu kanomo aꞌne avayu hu yaꞌene aꞌne munaꞌnele kumai he yaꞌene musufaya hu yaꞌene havige hu-ma-te yaꞌene kamuge vai-ma-te yaꞌene taguꞌafitila ali falote nehie. ");
INSERT INTO knb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Naꞌama haya yafe tamakupina oniꞌyaꞌagela tamahau-mainegi veaꞌmoꞌya amayama sese ohuꞌya kaveꞌma naya yamoꞌa amakupina oniꞌyaꞌagela ohugahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisasiꞌa nemaiya kumala ataleno Taiya kotegaene Saitoni kotegaene umaine. ");
INSERT INTO knb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Umainegeno nagola anile mainea Kenani aꞌmoꞌa, Yuta vea omainea aꞌmoꞌa, agaife ke huno mage me hie “Ala kanomogae, Tevitina aginagomoga, nagaila kahau hunato. Kefo Avamuꞌmoꞌa nagai munala aguꞌafi faleno maineno tusi havi kava hu-neꞌa-te.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Higeno Yisasiꞌa nagola osi ke kanoꞌa ohunegi agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya agaife mage me hae “Ani aꞌmoꞌa tagai takave neꞌeno tusiya huno keha keha nehuno tutu nehigi kagaya hu-tegeno vino.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yisasiꞌa mage hie “Isalelima vaꞌyagi-mainea sipi sipileke Anumaya Kotiꞌa hu-na-tegeꞌna emainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Higeno ani aꞌmoꞌa Yisasi aiyafi aleꞌya meye-maineno mage huno hie “Ala kanomogae naya huo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Higeno Yisasiꞌa mage huno hie “Havigu nafaꞌneyagamogami kave hama-faleꞌya kalamogami amamisagi nagaya Isaleli veala amataleꞌna alu vayaꞌne amaya hisuana haviya hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Higeno ani aꞌmoꞌa mage huno hie “Ala kanomogae tamage nehananagi kalamogamina neꞌamafaꞌya nenageꞌya kalamoꞌya sipaletiꞌma asaga hu-lavia atupaꞌa yogiꞌya nenae. Kagaya ani kava huka nagaya Isaleli a omainogi osiꞌa nahaꞌmao.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Higeno Yisasiꞌa mage hie “Aꞌmogae tusiya huka nagaifena havika kagupi maleka kametiti hanafe nahavigana yana kamigahue.” huno nehigeno ani kana kanoꞌale munaꞌamona kanale hu-tene. ");
INSERT INTO knb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisasiꞌa ani kumala ataleno Kalili ti kotumo agegayalega uteno nago agoꞌyafi haino mopale maine. ");
INSERT INTO knb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mainegeꞌya kasagoꞌya veala agaite melitalu nehuꞌya aiya avayu hu-mainea veaꞌnene aiya aya haviya hu-mainea veaꞌnene amaulaga asu hu-mainea veaꞌnene age tagaꞌne-mai veaꞌnene nagoꞌa kali veaꞌnene amavaleꞌya Yisasina aiyafi mematageno alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kanale hu-ma-tegeꞌya mukiꞌa veala agayana higeꞌya tusiꞌa amamaꞌyo ai-mainae. Age tagaꞌne-mai veaꞌmoꞌya kaiyeke hageꞌya amaiya amayamo kayagi-mai veaꞌmogamina amaiya amayaꞌmoꞌa kanale higeꞌya amaiya haviya hu-mainea veaꞌmogami amaiyamoꞌa kanale higeꞌya neꞌvageꞌya amaulaga asu hu-mainea veaꞌmogami amaulagamoꞌa kanale higeꞌya amaulaga age-mainae. Naꞌama haya yate ageteꞌya Isaleli veaꞌmogami Anumaya Koti agia alisaga hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe ke higeꞌya ageno mage hie “Mani veaꞌmoꞌya taliꞌa (3) yupa nagaiꞌene mainageno nesaya kaveꞌamia omalea yafe nahau hu-neꞌama-toe. Havigu amatalesugeꞌya katega nevisageno amakatesigeꞌya amaugetuꞌnatu huꞌya takatiyafena nonahaiye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage huꞌya hapaiye “Mani kotega vaya omai kotegagi hanateti kosa hesia maya alita ani veaꞌnea amamisune?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hageno Yisasiꞌa mage huno hama-vige “Tamakaya naꞌmagi maya hane?” huno higeꞌya mage hae “Tagaya seveniꞌa (7) mayaꞌage hanegi nagola osi noyame kanoꞌa hane.” huꞌya hapaiye. ");
INSERT INTO knb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hageno Yisasiꞌa mukiꞌa veafena “Mopale maiho.” huno hama-paigeꞌya mopale mainae. ");
INSERT INTO knb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mopale mainageno Yisasiꞌa ani seveniꞌa (7) mayaene noyamene alino Anumayamotega muse huno havigeteno kolite kolite huno agaiꞌaenema tokaeꞌya nemaiya anagala amamigeꞌya mukiꞌa veaꞌmogamina amaminae. ");
INSERT INTO knb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amamigeꞌya mukiꞌa veala nageno amamu higeꞌya atalaya maya atupayaga agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya alitalu huteꞌya seveniꞌa (7) kupi ai-hava-te-mainae. ");
INSERT INTO knb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ani kaveꞌma ne-mainaya veneꞌnea fo tauseniꞌa (4,000) vemoꞌya ne-mainae. Nafaꞌneyagaꞌamiene aꞌneyagaꞌamiene nayanagi ohapalinae. ");
INSERT INTO knb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Netageno Yisasiꞌa hu-mategeꞌya utageno agaiꞌa tipi kalefi haisaga hu-maino Magatana kaiyaga umaine. ");
INSERT INTO knb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falasia vayaꞌene Satiusi vayaꞌene Yisasina meye-vataga hisayafe mage huꞌya me hae “Kagaya ikapinagati tokiya avame yana hugeta agamano.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hageno Yisasiꞌa mage huno hie “Unena tamakaya mage nehae ‘Ikamoꞌa haesa hianagino ega kanale yage falote hugahie.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Natepiti hetitama mage nehae siaꞌmoꞌa okomaꞌage huno ikamoꞌa ai-haesa hianagino ‘Menia yasimoꞌene koꞌmoꞌene falote hugahie.’ hutama nehae. Tamage tamakaya ikana neꞌagetama ‘Naꞌa hugahie.’ hutama fako nehayanagi meni kanafima falote hia yana age-lama hutama noꞌagae. ");
INSERT INTO knb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tamakaya meni kanafima mainaya veaꞌmogatama tusiya hutama kefo veaꞌne mainae. Anumaya Kotina tamakaveꞌno hu-neꞌataya veaꞌne mainae. Tamakaya ‘Tokiya avame yana hugeta agamano.’ hutama nagaifena hayanagi nagaya nago avame yana ohugahuanagi Yonama hu-tenea tokiya avame yamaꞌage tamave-ligahie.” huno huteno Yisasiꞌa amataleno umaine. ");
INSERT INTO knb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya tikotuna lakaeꞌya vayana amake-kaniꞌya nagoꞌa maya oꞌaliꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oꞌaliꞌya vageno Yisasiꞌa mage huno hama-paiye “Tamakaya Falasia vayaꞌmoꞌyaene Satiusi vayaꞌmoꞌyaene amakupi hanea yana age-lama ohuꞌya amavayaleti havigema nehaya yana kai hame hale-negia avamete huno halegino alakefa hisia yafena kaꞌye ho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Higeꞌya ani vayaꞌmoꞌya amakaiꞌami huge havige huꞌya mage hae “Tagaya maya oꞌalita emainona yafe nehie.” huꞌya amakaiꞌami hae. ");
INSERT INTO knb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Hayanagi Yisasiꞌa ani vayaꞌmoꞌya haya kea ago haviteno amakaife mage hie “Naꞌa higetama ‘Kavetia alita omenone.’ hutama tamakaitamia huge havige nehae. Tamakaya nagaifena osi kanoꞌa havitama tamakupi maletama tamametitia hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tamakesa omalegetama havilama nohao? Faefuꞌa (5) mayama faefu tauseniꞌa (5,000) vemoꞌya ne-mainaya yafena tamakesa nohavio? Netagetama naꞌmagi kupi atalaya maya atupayaga ai-mainone hutama nohavio? ");
INSERT INTO knb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tamakaya seveniꞌa (7) maya kanoꞌa fo tauseniꞌa (4,000) vemoꞌya netagetama naꞌmagi kupi aitama havate-mainone hutama tamakesa nohavio? ");
INSERT INTO knb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nagaya mayahena tamaha-opainogi. Naꞌa higetama ohavinae? Tamakaya Falasia vayaꞌene Satiusi vayaꞌene amakusafinaga hanea yana agelama ohuneꞌya amavayaleti havigema nehaya yana kai hamemo hale-negia avamete huno halegino alakefa hia yafena kaꞌye ho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mani kema higeꞌya haviyana Yisasiꞌa afaꞌa “Kai hame maya hale-negia yafe tamaugafa kaꞌye ho.” huno ohunegi agaya “Falasia vayaꞌene Satiusi vayaꞌmoꞌya nehaya kehe kaꞌye ho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisasiꞌa Sisalia Filipai kaiyaga uvaꞌyi huno agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hama-vige “Veaꞌmoꞌya nagaifena, ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌnihena taꞌe huꞌya nehae?” huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hamavi-gegeꞌya kenonaꞌa mage huꞌya hae “Nagoꞌa vayaꞌmoꞌya kagaifena Yoniꞌe, ti fale-neꞌamatea kano, maine huꞌya hageꞌya nagoꞌa veaꞌmoꞌya kagaifena Ilaiya maine huꞌya hageꞌya nagoꞌa veaꞌmoꞌya Yelemaiya maine huꞌya hageꞌya nagoꞌa veaꞌmoꞌya nayo Anumaya Koti aune kanoa fali-mainea kano maine huꞌya nehae.” huꞌya hapai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hapaigeno Yisasiꞌa amakaifena mage huno hama-vige “Tamakaya nagaifena taꞌe hutama nehae?” huno hamavi-ge. ");
INSERT INTO knb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hamavi-gegeno Saimoni Pitaꞌa mage huno hie “Kagaya Kalaisigae, Anumaya Kotiꞌma taugafa ali-gatigahe hu-ga-tenea kano mainane. Haimuꞌaene mainea Anumaya Koti neꞌamoga mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Higeno Yisasiꞌa Pitafena mage huno hapaiye “Saimonigae, Yona nafaꞌnemoga, mani kea hanafe Anumaya Kotiꞌa muse hisana yana kamine. Nagola ma mopafi kanomoꞌa ani yana kaveꞌotinegi ikapinaga mainea Nenafa kave-li-maine. ");
INSERT INTO knb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nagaya kaha-nepauve kagaya Pitagae ani kagimo aepaꞌa yafamogae. Kagaya yafa kana nehananagiꞌna nagaya mukiꞌa amakuꞌa naminaya veala mani yafaꞌmo agupile no kana huꞌna ki-malenesugeꞌya vayaꞌma hamae-nefalisaya tokiyaꞌamia anima ki-malesua nona alino haviya ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nagaya Anumaya Kotiꞌma kava yagai-mainea kumaꞌma yakisana ki nofila kamigahue. Kagaya ma mopafi maineka ‘Ma yana atafa hutama tokiya vaiho.’ huka hisanana Anumaya Kotiꞌa agaiꞌenena ikapinaga ‘Ani yana atafa hu-liho.’ huno hugahie. Kagaya ma mopafi nago yafema ‘Afaꞌa ataleho.’ hukama hisanana Anumaya Kotiꞌa agaiꞌenena ikapinaga aniꞌa hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe tokiyaꞌage ke huno mage hie “Tamakaya nagoꞌa veala nagaifena ‘Kalaisiꞌe, Anumaya Kotiꞌma taugafa aligatigahe hutenea kanoa ma maine.’ hutama hama-opaiho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ani yupa Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafena haenagama falote hisia yamofe aepa heno amave-li-maine. Mage huno hie “Nagaya Yelusalemu visugeꞌya ala vayaꞌene mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene tusiꞌa nagata aisia kava hu-nateteꞌya nahaesageꞌna faligahue. Falisugeꞌya komufi he-vai-natesageꞌna tole yupa maiꞌna tagufa kanale fali-mainesufitila hetigahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Higeno Pitaꞌa Yisasina faitega avaleno moteneno aepa heno Yisasife mage hie “Anumaya Kotiꞌa ani kavala ohisaya amaku amakesa amamisie. Anumayanimogae kagaila ani kavala hu-okatesae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Higeno Yisasiꞌa mai-yahae huno Pitafena mage huno hie “Satanigae mai halenato kagaya nagai naguꞌa ali haviya hugahe nehanagi kagaya Anumaya Koti havimainea aguꞌagesa kanaleꞌya huka nohavinagi vayaꞌmoꞌya kaha-paiya amaku amakesa nehavine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafena mage huno hama-paiye “Nagoꞌa veaꞌmoꞌya nagai nakaveꞌma visaya amakesa havinuꞌyahena amaugafama aliꞌya hai yana amakaveꞌno hu-teteꞌya nagaiꞌma nagata aisigeꞌna falisua kava hisaya amakesa haviteꞌya yafaga yosa kofiꞌya nakave aliꞌya visae. ");
INSERT INTO knb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nagoꞌa veaꞌmoꞌya maiyaꞌamima atafa huꞌya ali-talakoma hu-lisayana maiyaꞌamimoꞌa falino afaya hapaegahigi nagoꞌa veaꞌmoꞌya nagaifema hamainageꞌya maiyaꞌamima atalesaya veaꞌmoꞌya maiyaꞌamia ali-gatisugeꞌya agola aliꞌya maigahae. ");
INSERT INTO knb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nagoꞌa veaꞌmoꞌya mukiꞌa ma mopafi mone afenoꞌyaꞌyaga aliteꞌya maineꞌya falisayana agola maige maige hisaya haimula ago atalenayanagiꞌya ali-mainaya mone afenoꞌamimoꞌa hanaꞌa huno amaya hugahie? Aꞌao amaya ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia Nenafaꞌa tokiya hale yamaꞌaene Anumaya Kotina ensole vayaꞌamoꞌyaene eteꞌna esua kanafina mukiꞌa veaꞌmoꞌya ma mopaleꞌma hu-mainesaya yateti anonaꞌa amamigahue. ");
INSERT INTO knb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tamage-lafa huꞌna tamaha-nepauve nagoꞌa veala maleꞌma hetiꞌya mainaya veala aupaꞌa ofaligahayanagiꞌya hagoteꞌya nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonina Anumaya Kotiꞌa kava yagai-mainea yapi maineꞌna esugeꞌya nagegahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yisasiꞌa sikisiꞌa (6) kana maiteno Pitana Yemesina Yonigamina amavaleno ayaꞌaya agoꞌyafi hai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Haiꞌya mainageno Yisasina augosamoꞌa alino alu augosa kaligeno augosafitila yage kana huno ai-vasa nehigeno kenaꞌamoꞌa efeꞌage huno alave alave hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ageho tole kanolana nayoma fali-mainaꞌa kanolana Moseseꞌene Ilaiyaꞌene Yisasiꞌene kea kea nehaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nehaꞌageno Pitaꞌa Yisasife mage hie “Anumayamogae tagaya male maunana kanaleꞌya hie. Kahaisigekahena katega nona taliꞌa (3) ki-lama-tesue kagaila nagolagi Mosesena nagolagi Ilaiyana nagolagi huno hanesie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ani kea hanepaigeno nagola hale yamaꞌaene siaꞌmoꞌa evaꞌyi huno alino aiso hu-mategeno siapinagati ala kefiti age aino mage huno hie “Mani kanoa nagai nafaꞌnegi nahau nayamopafi nenagea kanogi agaifena aluya huno nenahaigi agai kea haviho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya koli huꞌya amamaꞌyo aigeꞌya mopafi amakoꞌya aiye-mainae. ");
INSERT INTO knb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amakoꞌya aiyeꞌya mainageno Yisasiꞌa avate eno mage hie “Kolia ohiho. Hetiho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Higeꞌya age-saga huꞌya agayana Yisasiꞌa agaiꞌage mainegeꞌya age-mainae. ");
INSERT INTO knb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ageteꞌya agoꞌyafiti enelaviꞌya Yisasiꞌa kahegi mateno mage huno hie “Anima agaya yafena nagoꞌa veaꞌnea hamaꞌopainegeꞌna ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna fali-mainesufiti hetisua yupa hama-paigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Higeꞌya agaiꞌaenema lokaeꞌya nemaiya anagaꞌmoꞌya mage huꞌya havigae “Naꞌa higeꞌya kahegi kema havilinaya anagaꞌmoꞌya ‘Ilaiyaꞌa hagoteno neꞌesigeno Anumaya Kotiꞌa taugafa ali-gatisia kanoa egahie.’ huꞌya nehayane?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Havigageno Yisasiꞌa mage huno hie “Tamage Ilaiyaꞌa hagoteno egahianagino mukiꞌa yana alino kanaleꞌya huno talo tala hugahie. ");
INSERT INTO knb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hugahianagi tamaha-nepauve Ilaiyaꞌa ago emaineanagi agaila age-lama ohuꞌya hamaiya kava huꞌya agaila havi kava hu-tenaya kavala aniꞌa huꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonina ali haviya hu-natesageno naugafa nagata aigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mani kema hiana “Yoniꞌa tima fale-neꞌamatea kanomofe hie.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yisasiꞌene agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mukiꞌa veala melitalu huꞌya mainale evaꞌyi hageno nago kanomoꞌa Yisasite mepe hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Yisasifena mage huno hie “Anumayamogae kagaya neꞌnafaꞌneꞌnimona kahau huto. Ani nafaꞌneꞌnia mananiꞌya neꞌagegeno augafamona ali haviya nehigeno mukiꞌa yupa ata taꞌnekino tipi asaga hu-nelavino nehie. ");
INSERT INTO knb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naꞌa nehigeꞌna kagaiꞌene tokaeꞌya nemaiya anagakamogamite avaleꞌna oana aliꞌya kanale hu-tesaya amukoꞌamia omalene.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Higeno Yisasiꞌa mage huno hama-paiye “Vae tamakaya meni kanafima mainaya veaꞌmogatama nagaifena havitama tamakupi maletama tametitia ohutama fatago hutama nomaiye. Aniꞌa haya yafe kasalo nenahaegi naꞌmagi yupa tamakaiꞌenena mainesugetama nagaifena havitama tamakupina malegahae? huno nehuno ani nafaꞌnemo nefafe ‘Nafaꞌnekaꞌa avaleka eno.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Higeno avaleno egeno Yisasiꞌa anima agupi mainea Kefo Avamufena ke-makino ‘Ataleka hati-lavio.’ huno hutegeno hati-lavigeno aupaꞌa ani nafaꞌnemona kanale hu-tene.” ");
INSERT INTO knb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya amakaiꞌamige Yisasite mage huꞌya me havigae “Tagaila naꞌa higeno Kefo Avamuꞌma anatisuna amukotia omale?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Hageno Yisasiꞌa mage huno hama-paiye “Nagaifema havitama tamakupi maletama tamametiti haya yatamimoꞌa osi hu-mainea yafe ani kava hisaya amukotamia omalene. E, nagaya tamage-lafa huꞌna tamaha-nepauve tamakaya osi kanoꞌa oꞌagemo avina kanoꞌa Masatati avinamoꞌma hia kava hutama nagaifena havitama tamakupi malaleꞌasina ma agoꞌyamofena mage hutama hapaisagenoꞌa ‘Hetika alule vuo.’ hisagenoꞌa ani agoꞌyamoꞌa agola vileꞌasine. Nagaifema havitama tamakupi malesayana tamakaya nago aliꞌyafena ‘Amuha ohunone.’ hutama ohugahagi mukiꞌa tokiya kavala iohugahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kalili kotega alitalu huꞌya mainageno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hama-paiye “Osi kanaꞌa maitesugeno nago kanomoꞌa nagesi huno ikapinagati emainoa kanoa vayaꞌmo natenea kanomonina kame vayaꞌmogami amayapi navaleno nategahie. ");
INSERT INTO knb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Natesigeꞌya nahaesageꞌna falisugeꞌya he-vaina-tesageꞌna tole yupa komufi maiteꞌna tagufa (3) molisia kanale eteꞌna he-tigahue.” huno higeꞌya ani kehena agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya havigeno kanaꞌage hamau-maine. ");
INSERT INTO knb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nago yupa Yisasiꞌene agaiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya Kapaneamu evaꞌyi hageꞌya mono noma ali fatago hisaya monea vaya amaugafaleti takesi neꞌaliya vayaꞌmoꞌya Pitate mage huꞌya me havigae “Tamakaila hu-lamave-nelia kanomoꞌa ani mono note monea neꞌataleo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hageno Pitaꞌa mage hie “E, ani monea neꞌatale.” huno nehuno nopinaga hai-falegeno Yisasiꞌa hagoteno mage huno havige “Saimonigae naꞌane kagesa nehavine. Ma mopale sauve vayaꞌmoꞌya vaya amaugafaleti takesi monea aliꞌya tagami neꞌamamiye? Mukiꞌa amakaiꞌami kotega vayateti neꞌalio ifi alu vayaꞌmogamiteti neꞌaliyo?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Havigegeno Pitaꞌa mage huno hie “Alu vayatetila afaꞌa neꞌaliye.” huno higeno Yisasiꞌa mage hie “Tamage hane. Aniꞌa huꞌya amakaiꞌami kotega vayaꞌmogami amaugafaletila takesi noꞌaliye. Aniꞌa huta lagaya Anumaya Koti anaga mainonagi tagaitetila takesia oꞌalisae. ");
INSERT INTO knb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Oꞌaligahayanagi havigu naꞌa hisunageꞌyahena amaipamoꞌa haviya hugahayanagika kagaya ti kotute visanaꞌamoga noyame hukua atalesanageno tavisigeka hagote noyamema avayuma hinuka avaya ali aka hu-lineka nagola monea agegane. Ani monea alika ani vayala memamisanageꞌya tolemogatiꞌa taꞌaugafaleti takesi monea aligahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ani yupa Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya Yisasite mage huꞌya me havigae “Hana kanomo muki vayala amakaseno Anumaya Koti kava yagai-mainea kumatela uhakote-mainea kanoa maigahie.” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Havigageno Yisasiꞌa nago osi nafaꞌnea ke higeno egeno mukiꞌa vayaꞌmogami amuꞌnopi avaleno he-ti-tene. ");
INSERT INTO knb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","He-ti-teneno mage huno hie “Nagaya tamage-lafa huꞌna tamaha-nepauve tamakayama tamakuꞌa ai-yahae hutama nafaꞌnemoꞌyama amaugafa aliꞌya nohaiya kava hutama osi nafaꞌnemogami avamete ohisayana Anumaya Kotiꞌma kava yagai-mainea kumatela hai ofalegahae.” ");
INSERT INTO knb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nago kanomoꞌa agaiꞌa augafama alino ohaino osi nafaꞌnemo avamete maisiana ani kanomoꞌa nagoꞌa veala amakaseno Anumaya Koti kava yagai-mainea kumatela hagote kano maigahie. ");
INSERT INTO knb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nagoꞌa veaꞌmoꞌya nagaifema huꞌya ma ma osi nafaꞌnema avaleꞌya falu fala hu-tesayana nagaiꞌenena navaleꞌya falu fala hu-nenatae. ");
INSERT INTO knb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nagoꞌa veaꞌmoꞌya nagoꞌma nagaife haviꞌya amakupi malenaya anagapiti nago osi kanohema “Kefo yama huo.” huꞌya hisayana tusiꞌa kefo kava nehayanagiꞌna tusiꞌa kana ya amamigahue. Ala yafakefaleti ani kanomo ageꞌyafi maleꞌya nofi ki-teteꞌya hage lipi hagaꞌyu hu-talageno ti nakaino falisiana ani kana yamoꞌa afa ya kana ya haneanagi nagaya tusiꞌa kana ya amamigahue. ");
INSERT INTO knb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Avoꞌnio ma mopale veaꞌmogatama tusi nahau hu-nelama-toe. Mopafi mainaya kanafina “Kefo yama hiho.” huꞌya aye-mavataga hisaya yana falote hugahianagi nagoꞌa veaꞌmoꞌya “Kefo yama hiho.” huꞌya aye-mavataga hisaya veafena “Avoꞌnio kefo kava nehananagika kana yana aligane.” huꞌna tusi nahau hu-nelama-toe. ");
INSERT INTO knb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kayaꞌene kaiyamoꞌene “Kefo yama huo.” huꞌana kavaleꞌana havi kapima katesaꞌagekahena ani kaiya kayana ai-fakalika hagaꞌyu hutalo. Hagaꞌyu hu-talesanana kanalele. Kaugafa haviya hu-mainesia kano maisanana kanalelagika haꞌno ohu kahaimuka hanesia kano maiyo. Havigu tole kayano tole kaiyao kefo ya hisana kagesa kaminegeka kefo yama hu-mainesana yafe kavaleno hani yapi agola tegelege nehia atafi hagaꞌyu hu-gatalegahie. ");
INSERT INTO knb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kaulagamoꞌa agesia yamoꞌma kefo ya hisana kagesama kaminageka ani kaulaga ali faꞌyika hagaꞌyu hutalo. Ali faꞌyi-talesanana kanalele. Nagoke kaulaga hanesigeno kanale haꞌno ohu kahaimula kamisigeka alika maigananagi havigu tole kaulagamoꞌa kefo ya hisana kagesa kaminegeka kefo yama hisanafe hani yapi tegelege nehia atafi kavaleno hagaꞌyu hu-ga-talegahie. ");
INSERT INTO knb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Tamakaya kaꞌye ho. Havigu nagoꞌa osi anagaꞌnihe “Afa ya kana veaꞌne mainae.” hutama huyafenagi nagaya mage huꞌna tamaha-nepauve ani osi anagala ensole vayaꞌamimoꞌya ani nafaꞌneꞌyagale kava neꞌyagaiꞌya mukiꞌa yupa ikapinaga maineꞌya Nenafa aufina neꞌagae. ");
INSERT INTO knb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Na tamakesa nehaviye? Nago kanomoꞌa vani hataletiꞌa (100) afu mainefiti nagola fanane higeno ani afumona nefaꞌa mukiꞌa afuꞌa talapinaga amataleno talapinaga viaꞌyamo nagokeꞌma fanane hu-mainea afuꞌahe ati-yeno yeno ali falote hisio? E, fananema hisigenoꞌa aniꞌa huno ati-yegahie. ");
INSERT INTO knb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nagaya tamage-lafa huꞌna tamaha-nepauve agoꞌma fanane hu-mainesia afuma ali falote huno avalesiana tusiꞌa muse hugahie. Naiti nainiꞌa (99) afuyagaꞌahena muse hianagi nagokeꞌma fanane hu-mainesia afuma ali falote hu-tenoꞌa tusiya huno musena hugahie. ");
INSERT INTO knb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Naꞌa hu-mainegi ikapinaga mainea Nelamafaꞌa nagola osi anagaꞌa fanane hisia yafena nohaiye. ");
INSERT INTO knb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kafu-kaganaꞌma kefo yama hu-ga-tesigeka tanakaya tokaetana mainetana kefo yama hu-mainesia yana avelio. Ave-lisanageno kagai kema haviteno kefo yama hisifitila aguꞌa ai-yahae hisigeka avaleka kagaika kametega ategane. ");
INSERT INTO knb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ateganagi kekama ohavisigekahena nagokepi tole kanola anavaleka vinuka tolefi (2) tagufa (3) vayaꞌmoꞌya hu-ga-tenea yana ageteꞌya hu-falote huꞌya fako huꞌya ani kanomona aumono maleho. ");
INSERT INTO knb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aumono maletesageno ani kanoꞌmoꞌma nagoꞌene amakai kema ohavisigeka kagaya Yisasife haviꞌya melitaluma huꞌya maisaya veapi avaleka ugeꞌya aumonola maleho. Aumonoꞌma malesageno ani vayaꞌmogami kema ohavisigeka kagaya mage huka huto “Yisasi kea ohavi vaya kana hana kanomoga tagaiꞌenena eomaika kahaote maiyo.” huka huto. ");
INSERT INTO knb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ani kema hu-tesayana tamage-lafa huꞌna tamaha-nepauve tamakaya ma mopale mainayana “Ma ya atafa hutama tokiya vaiho.” hutama hisayana Anumaya Kotiꞌa ikapinaga aniꞌa huno “Ani yana atafa hiho.” hu-lokiya vaigahie. Tamakaya ma mopale mainetama nago yafema “Afaꞌa ataleho.” hutama hisayana Anumaya Kotiꞌa ikapinaga aniꞌa hugahie. ");
INSERT INTO knb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Eteꞌna nago kea tamaha-nepauve mopafi mainetama tole kanolaganima nago yafema nagoke anaku anakesaleꞌma mainenuꞌana ani yafena Anumaya Kotitega havigesaꞌageno ikapinaga mainea Neꞌanafaꞌa anamigahie. ");
INSERT INTO knb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","E, tole (2) kanofi tagufa (3) vayapi nagai nagileꞌma haviꞌya melitalu hisayana nagaya nagaiꞌniꞌa amuꞌnoꞌamifina maigahue huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pitaꞌa Yisasite eno mage huno hie “Anumayamogae naꞌmagi kana nafuꞌnaganana kefo yana hu-na-tesigeꞌna ani kefo yamaꞌahe aigeꞌateꞌna atale-tesue? Seveniꞌa (7) yupa kefo yama hu-na-tesigeꞌna aigeꞌateꞌna atale-tesuo?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Havigegeno Yisasiꞌa mage huno hapaiye “Kagaifena seveniꞌa (7) yupa ani kavala huo huꞌna nohugi nagaya mage huꞌna nehue kasagoꞌya yupa ohavunamaꞌa kanale havi yama hu-ga-tesigeka aniꞌa huka ohavunamaꞌa kana aigeꞌateka ataleto huꞌna nehue.” ");
INSERT INTO knb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anumaya Kotife “Kava yagai-nato.” huꞌya hu-mainesaya veaꞌmoꞌya ma kava nehae. Nago kumate sauve kanomoꞌa agai aliꞌya veafe mage huno hie “Yoka kaminoa moneꞌniꞌa anonaꞌnia fatago hutama namiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Huteno fatago hugahe nago kanoa avalegeno eno aminea yatefe anonaꞌa ohavunamaꞌa monegefa, nago kanomoꞌma fifitiniꞌa (15) kafu aliꞌya alino ne-mainea augafa mone eteno anonaꞌa amisia yana hane. ");
INSERT INTO knb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Haneanagi monema amisia amukoꞌa omalegeno kava kanomoꞌa mage huno hie “Kagaikaene akamoꞌene nafaꞌnekaene afenoꞌyakaene alu kanomote atalegeno miya hisigeꞌna kagaiteti anonaꞌa monea alino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Higeno ani aliꞌya kanomoꞌa kava kanomo aiyafi aleꞌya meyeno mage huno hie “Naꞌa ohuka kahau hu-na-teka ako huka nagava mainegeꞌna nagaya haenagaꞌa naminana yatela anonakaꞌa mukiꞌa kamigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Higeno ala kava kanomoꞌa aliꞌya kanoꞌahena tusiꞌa hau hu-teteno anonaꞌama oꞌamia yafena aigeꞌateno atale-tene. ");
INSERT INTO knb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Atale-teanagi ani aliꞌya kanomoꞌa hati-lavino viaꞌyamo tokaeꞌana aliꞌya neꞌaliꞌa kanomona moge-maine. Ani kanomoꞌa nago yupa agaifena mage huno hie “Nagoke Sotama aliꞌyana aliꞌya nenaya augafa mone yoka namio.” huno higeno amianagi anonaꞌa oꞌamine. Oꞌaminea yafe ani kava kanomoꞌma hau hu-tenea kanomoꞌa ani afaluꞌamona ageꞌyafi atafa hu-lineno mage huno hie “Kagaila yoka kaminoa yana anonaꞌa mukiꞌa yaniꞌa aupaꞌa namio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Higeno aliꞌya tokaeꞌana neꞌaliꞌa kanomoꞌa aleꞌya ayeno mage hie “Naꞌa ohuka ataleka afaꞌa kahau hu-na-teka ako huka nagava mainegeꞌnao. Haenaga anonakaꞌa kamigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Higeno ani kanomoꞌa mage huno hie “Aꞌao naꞌa kehena nonahaiyafe nofi nopi hu-ga-tesugeka maineka haenaga anonaꞌa namiteka nofi nopitila ataleka maigane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Higeꞌya nagoꞌa tokaeꞌyama aliꞌya neꞌaliya veaꞌmoꞌya naꞌama hia yafena haviteꞌya amaipamoꞌa haviya higeꞌya kava kanomote mukiꞌa hu-mainea kavafena mo falote hae. ");
INSERT INTO knb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mo falote hageno ala kava kanomoꞌa atale-tenea aliꞌya kanoꞌahe ke higeno egeno mage huno ha-paiye “Kagaya tusiya huka havi aliꞌya kano mainane. Hagoteka nagaifena avi metanageꞌna anonakaꞌa aigekateꞌna atalega-tenoe. ");
INSERT INTO knb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nagaya kagaifena nahau hu-ga-toanagi naꞌa higeka ani avamete kavala ohuka kagaya tokaeka aliꞌya neꞌalina kanohena kahauna hu-oꞌatane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huteno kava kanomoꞌa tusiꞌa hai-vaiteno kina nopi avaleno viaꞌyamo kaꞌyo amisaya vayaꞌmogami amayapi ategeno mage hie “Tusi agata ya amitegeno haenagaꞌa mukiꞌa yaniꞌa anonaꞌa namitesigetama atalegeno vino.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yisasiꞌa mage huno hu-maine “Tamakaya tamafu-tamakanaꞌya kefo yama hu-lama-tesagetamahena amegatila hu kanale ohutama tamage hutama tamaipa kanale yapiti aigeꞌamatetama atale-oꞌama-tesayana ikapinaga mainea Nenafaꞌa aniꞌa huno ani mukiꞌamogatamina kinama hu-tenea avamete huno hu-lamategahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisasiꞌa mukiꞌa mani kema hu haꞌnoma nehunoꞌa Kalili kotega ataleno Yotani limoꞌa ame kaiyaga Yutia kotega uvaꞌyi hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mukiꞌa veaꞌmoꞌya Yisasi akave vageno kaliꞌamia alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nagoꞌa Falasia vayaꞌmoꞌya Yisasite eꞌya kanale ohunea kema hisiafene huꞌya nagola aye-vataga hisaya kea mage huꞌya havigae “Nago kanomoꞌa aꞌamoꞌma nehia kavafe atalesia agesama hisigenoꞌa kanalelagino atalesio? Kahegi kemoꞌa ani yafena naꞌane nehie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Hageno Yisasiꞌa kenonaꞌamia mage huno hie Tamakaya Anumaya Koti avona hapalitama ohavinao? Mage huꞌya kae-malenayane Anumaya Kotiꞌa ehe yupa aepa heno vene aꞌene talo hu-maleteno mage hie “Vene aꞌene talo humalenoafe nago kanomoꞌma itaꞌafoꞌamoma ataleno aꞌamoꞌene ai-lokaeno maisiana ani tolemogania nagoke anaugafa kaligaꞌe.” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naꞌa hu-maineafe nagoꞌene tolea omainaꞌagi menia nagoke anagufa kaliꞌana mainesaꞌageno Anumaya Kotiꞌa anakaila alino hagelafi-na-teneanageno nago mopale kanomoꞌa ani alavelamogani mai yaꞌania alino apase oꞌana-tesie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Higeꞌya Falasia vayaꞌmoꞌya Yisasife mage huꞌya havigae “Naꞌa higeno Moseseꞌa nagola kahegi kefina ma kea huno taha-pai-maineane ‘Vemoꞌa aꞌamona avo kaeno neꞌamino hu-tesigeno haꞌno huno ugahie.’ huno hu-maineane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hayanagi Yisasiꞌa mage huno hama-paiye “Nayona ehela ani yafena Anumaya Kotiꞌa malegeno omalenea kavala haneanagi tamakaya ke ohavitama veganokano haya yafe Moseseꞌa aꞌma atalesaya kaana tama-ve-li-maineane. ");
INSERT INTO knb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nagaya tamaha-nepauve nago kanomona aꞌamoꞌma kumaima ohenesigenoꞌma anauꞌamoꞌa neꞌataleno nago aꞌma alisiana ani kanomoꞌa kumai kano maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya Yisasina mage huꞌya hapaiye “Alavemoꞌya tokaeꞌya maisaya auꞌava yamofe tusiꞌa tokiya kema hanesigetahena afaꞌa neyaꞌve maineta aꞌnea oꞌalisune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hageno Yisasiꞌa mage huno hama-paiye “Haya kea tamage nehagi mukiꞌa neyaꞌvemoꞌya aꞌnema oꞌalisaya amukoꞌamia omaleneanagino Anumaya Kotiꞌa tokiya amaminea vayaꞌmoꞌyage aꞌnea oꞌaligahae. ");
INSERT INTO knb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nagoꞌa neyaꞌvemoꞌya aꞌnema oꞌalisaya tokiyaꞌamia hane. Ani vayapitila nagoꞌa neyaꞌvemoꞌya itaꞌaꞌmimo ama-tenea yupa amakayamoꞌma faꞌyi-talenesaya vayaꞌma mainesayana aꞌnea oꞌaligahae. Nagoꞌa neyaꞌvema alu vayaꞌmoꞌyama amakayamoꞌma faꞌyi-talenesaya vayaꞌmoꞌya aꞌnea oꞌaligahae. Nagoꞌa vayaꞌmoꞌya ‘Anumaya Kotiꞌa kava yagai-la-tesie.’ huꞌya amakesa havi-mainesaya vayaꞌmoꞌya Yisasi kema hama-paisaya yafenagiꞌya ‘Aꞌnea oꞌaligahune.’ huꞌya hugahae. Ani kema havilinesia kanomoꞌa ani kava hisie.” ");
INSERT INTO knb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Veaꞌmoꞌya osi osi nafaꞌneyaga Yisasife “Aya maleno amakaife Anumayamotega havigesie.” huꞌya amavaleꞌya neꞌageꞌya agaiꞌaene tokaeꞌya nemaiya anagamoꞌya ageteꞌya “Naꞌa kavala ohiho.” huꞌya ke-amaki-mainae. ");
INSERT INTO knb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ke-amakiyanagi Yisasiꞌa mage huno hie “Amatalegeꞌya nagaitega eho. Nafaꞌneyaga nagaite esaya yafena kahegi oꞌama-teho. Naꞌa huꞌya nafaꞌnemogami avamete maisaya veaꞌmoꞌya mage hugahae ‘Tagaya tokiyatia omalenegi Anumaya Kotiga kava yagai-lato.’ huꞌya hugahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anumaya Kotiꞌa hamaꞌmaesia yafe ayana amaugafale maleteno neꞌamataleno alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nago kanomoꞌa Yisasiteka eno mage huno havige “Hu-mave-nelina kanomogae nagaya hana augafa kanale kava huteꞌna agola maige maige hisua nahaimula alisue?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Havigegeno Yisasiꞌa kenonaꞌa mage huno hie “Naꞌa higeka kanale auꞌavafena nahavi-negane? Nagoke kanoa Anumaya Kotiꞌa agaiꞌage kanale kano maine. Agola maige maige hisana kahaimuꞌma alinukahena Anumaya Koti kahegi kea akave malo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Higeno Yisasifena mage huno havige “Hanaꞌa kahegi kehe nehane?” huno higeno Yisasiꞌa mage huno hie “Vayala haegeno ofalino. Kumai he yana ohuo. Musufayana ohuo. ‘Ma kanoa havi kava nehie.’ huka havigea hu-oꞌato. ");
INSERT INTO knb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Itakafokamo kea oꞌatagaeka anakia alisaga huo. Kagaika kaugafahena kahaiya avamete huka aniꞌa huka negafu augafahena kahaino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Higeno ani kanomoꞌa mage huno hie “Nagaya mukiꞌa ani kea akave nemaloe. Na yamo nagoꞌa kosa he-ona-tene? Na yaꞌene hisue?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Higeno Yisasiꞌa mage huno hie “Nago kavaꞌene hisanana kosa he-ga-tesigeka fatago kano maigane. Mukiꞌa malenana mone afenoꞌyaꞌyagaka alika fako faka huka moneꞌamima omalenesia veaꞌne amamisanageno Anumaya Kotiꞌa ikapinaga hanea afenoꞌyana kamigahie. Afenoꞌyaꞌyagaka amamite amamite huteka nakave eno.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Higeno ani kanomoꞌa ani kea haviteno mone afenomaꞌamoꞌma kasagoꞌma hu-mainea yafe oꞌatalesia agesa haviteno aipamoꞌa tusi kanaꞌage higeno umaine. ");
INSERT INTO knb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vigeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hie “Tamage huꞌna tamaha-nepauve mukiꞌa mone afenoꞌyaꞌamima hanesia veaꞌmoꞌya tusiꞌa kasageke huꞌya Anumaya Kotife ‘Kava yagai-lato.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nagoꞌene tamaha-nepauve nagola pulumaka kana afumo agia kemolomoꞌa nekaꞌyamo kapima hai-falesiana afaꞌa yoꞌyo huno hai-falegahianagi mukiꞌa mone afenoꞌyaꞌamima hanesia veaꞌmoya Anumaya Kotife ‘Kava yagai-lato.’ huꞌya kasageke-voke hugahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya amamaꞌyo neꞌaiꞌya mage huꞌya hae “Naꞌama hu-mainesiana Anumaya Kotiꞌa hana veaꞌmogami amaku amame ali-gatigahie?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hageno Yisasiꞌa neꞌamakeno mage hie “Veaꞌmogamina amukoꞌamia omaleneanagiꞌya ohugahayanagi Anumaya Kotiꞌa mukiꞌa kavala hisia amukoꞌa haneanagino afaꞌa huno ali-gatigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nage higeno Pitaꞌa mage huno hie “Havio tagaya mukiꞌa yatia ataleteta kakave neꞌonagi tagaya na ya aligahune?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Higeno Yisasiꞌa mage huno hama-paiye “Tamage huꞌna tamaha-nepauve haegafa kanamoꞌa mukiꞌa yana yaufa ya falote hisigeꞌna nagaya ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna kava yagaisuafe tusiꞌa tokiya hale yamaꞌa hanea siale mainesugetama tamakaya nakave nehaya vayaꞌmogatama tuelufuꞌa (12) siale mainetama tuelufuꞌa (12) Isaleli nofi veaꞌmogamina kava yagai-ma-tegahae. ");
INSERT INTO knb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mukiꞌa veaꞌmoꞌya nagaifema haviꞌya veaꞌmogamina nagai kema hama-paigahena noꞌamiene nepuꞌamiene amasaꞌamiene itaꞌafoꞌamiene nafaꞌneꞌamiene hoyaꞌamiene amataleꞌya visagenoꞌa Anumaya Kotiꞌa anonaꞌamia atalenesaya yaꞌene vani hataletiꞌa (100) mani yaꞌyaga amamiteno maige maige hisaya hamaimuꞌene amamigahie. ");
INSERT INTO knb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Meni kanafina hagoteꞌya mainesaya veaꞌmoꞌya ani kanafina haenagalafa maigahagi meni kanafima haenagalafa mainesaya veaꞌmoꞌya ani kanafina hagoteꞌya maigahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anumaya Kotiꞌa kava yagai-mainea yamoꞌa maꞌa hu-maine. Nofi alagamo hoyamona nefaꞌa kege aluganale ani hoyafi aliꞌya alisaya vayafe ke hugahe umaine. ");
INSERT INTO knb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uno mage hie “Nagoke yupa kanoꞌa aliꞌyama alisageꞌnahena nagoke vani (1) kina tamamite tamamite hugahue.” huno higeꞌya nagoke amaipa hageno hoyafi hu-ma-tegeꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Umainageno yagemoꞌa naeni (9) kilokile haigeno vaya atagu-nefaya kumapi viana nagoꞌa vayala afaꞌa hetiꞌya mainageno momake-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Momaketeno mage hie “Tamakaiꞌenena nofi alagamo hoyaꞌnifi aliꞌya molisageꞌna miyana fatago huꞌna tamamigahue.” huno higeꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Umainageno yagemoꞌa amuꞌnokaꞌno higeno aniꞌa hu-maine. Yagemoꞌa alitulu huno lavigeno aniꞌa huno nagoꞌa vayafe “Aliꞌya moliho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Higeno unena aupaꞌa velo hugahe higeno nagoꞌa vayala afaꞌa heti-mainageno momaketeno mage huno hie “Naꞌa higetama ayaꞌaya kanagefa heti-taletama afaꞌa mainae?” huno hamavi-ge. ");
INSERT INTO knb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hamavi-gegeꞌya mage hae “Nago kanomoꞌa aliꞌyana otamigeta afaꞌa mainone.” huꞌya hageno “Kanalelagi tamakaya nagai hoyafi aliꞌyana moliho.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hama-paigeꞌya mo-neꞌaligeno une velo hilega nofi alagamo hoyamona nefaꞌa agaiꞌa aliꞌya kava kanohe mage huno hapaiye “Aliꞌya vayafe ke hugeꞌya egeka miyana amamio. Haenagama amavaloa vayaꞌmogami miyana amamiteka hagoteꞌnama amavale-mainoa vayala haenaga amamio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Higeꞌya une avavema amavalea vayaꞌmoꞌya ageno nagoke vani kina amamite amamite hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Amamite amamite higeꞌya hagotenoꞌma amavalegeꞌya aliꞌyama meli-mainaya vayaꞌmoꞌya mage huꞌya amakesa haviye “Ala miya aligahune.” huꞌya haviyanagi nagoke vani kinageꞌya ali-mainae. ");
INSERT INTO knb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Aliteꞌya hoyamona nefafena tusiya huꞌya kea-makiꞌya mage hae “Haenagama amavale-mainana vayala yagemoꞌa osi kana kanoꞌa nagoke kana nehigeꞌya aliꞌyana meli-mainagi tagaya afaꞌa hetita omainonagi tusiꞌa amukonako hia aliꞌya ali-mainonanagi nagoke avamete havi miya nelamine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hageno ani hoyamona nefaꞌa amuꞌnoꞌamifi mainea kanohe mage huno hie “Nenafuga havio nagaya havi kavala hu-notama-toe. Natema tamaha-vi-gogetama ‘E, nagoke vani kina aligahune.’ hutama hagetila naꞌa higetama mani kea nehae? ");
INSERT INTO knb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Aliꞌyama alitama aliya monea alitama notamilega viho. Nagaya nahaiya avamete huꞌna haenagama amavaloa vayaꞌene nago avamete miyana nelamamue. Nagaiꞌni yanagi haile. ");
INSERT INTO knb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ani monea nagaiꞌniꞌa mone. ‘Nagayama hugahue.’ huꞌna hisua yafena ‘Ohuo.’ hutama nehao? Nagaya vayaꞌma kauva yafe tamaipa haviya nehao?” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yisasiꞌa mage hie “Nagaya aniꞌa hugahue. Haenagalafa mainesaya veala hagoteꞌya maigahae. Hagoteꞌya mainesaya veala haenagalafa taviꞌya maigahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Yelusalemu haigahe katega neꞌuno Yisasiꞌa tuelufuꞌa (12) anagaꞌamogamina amahaote amavaleno moma-teteno mage huno hie “Haviho tagaya Yelusalemu haisunageꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia nagaila nagesi hinageꞌya mono note kava vayaꞌmoꞌyaene kahegi kema havilinaya anagaꞌene kame vayaꞌmogami amayapi navaleꞌya na-teteꞌya ‘Haegeno falino.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yuta vea omainaya vayate navaleꞌya momamisageꞌya nagaye hisifa kea hu-nateꞌya hu-haviya hu-na-teteꞌya hegi kaꞌyoteti nahaeteꞌya yafaga yosale nili nahaeꞌya asaisageꞌna faligahue. Falisugeꞌya he-vai-natesageꞌna tole yupa komufi maiteꞌna tagufa (3) kanale fali-mainesufitila Anumaya Kotiꞌa ali he-ti-na-tegahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sepetina aꞌamoꞌa netalamaꞌaene Yisasite eꞌya ani aꞌmoꞌa nago yafe havigegahe aiyafi aleꞌya meye-maine. ");
INSERT INTO knb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aye-mainegeno Yisasiꞌa mage huno havige “Naꞌa hu-gatesue?” huno higeno mage huno hie “Kava yagaisana kumate umainesanageꞌana mani tole neꞌnimogania kavate maineꞌana nagoꞌmoꞌa tamaga kayatega maisigeno nagoꞌmoꞌa hauga kayatega maisie.” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Havigegeno Yisasiꞌa mage huno netalamaꞌamogania hana-paiye “Nahavi-gea yana ohavinaꞌe. Falisua yana satuꞌage hu-mainea timo avamete ti hanea keꞌayopiti negahugi tanakaya kanale negaꞌo?” huno higeꞌana “E, tokiyatiꞌa haneanagitaꞌa negahuꞌe.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Haꞌageno mage huno hie “Tamage satuꞌage hu-mainea tina negaꞌanagi ala vaya mainelega tamaga nayategaene hauga nayategaene siale maisaya yana nagaiꞌni yana omalenegi Nenafaꞌa ani yana nagoꞌa vayafe ago talo tala huno fatago hu-ma-tene.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Higeꞌya teniꞌa (10) anagaꞌamoꞌya ani kea haviteꞌya ani kanolafe amaipa haviꞌya haviya hu-na-tenae. ");
INSERT INTO knb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yisasiꞌa “Nagaitega eho.” huno higeꞌya ageno mage huno hie “Ma mopale ala kava vayaꞌmoꞌya ‘Tusiꞌa ala vaya mainone.’ huꞌya Yuta vea omainaya veafe ke amama-kiꞌya aliꞌya ke hu-ma-teꞌya kava vayaꞌmogami avamete nehae. ");
INSERT INTO knb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Naꞌa nehayanagi tamakaya ani kavala ohiho. Tamakaipina ‘Nagi hanea kanoma maigahue.’ huno hisia kanomoꞌa aliꞌya kanotami maino. ");
INSERT INTO knb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘Uhagoteꞌna maigahue.’ huno hisia kanomoꞌa mone oꞌali aliꞌya kanotami maino. ");
INSERT INTO knb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna vayaꞌmoꞌya naya huꞌya kanaleꞌya hu-na-tesaya yafe omenogi nagaya amaya huꞌna aliꞌya kanoꞌami maisua yafe emainoanagiꞌna mukiꞌa veaꞌmoꞌya kefo yama hageno ai-gagi-ma-tenea yapiti kalu he-ma-tesua miya atalesua yafe faligahe emainoe.” ");
INSERT INTO knb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya Yeliko kumala ataleꞌya ugahe hageꞌya kasagoꞌya veaꞌmoꞌya amakave umaine. ");
INSERT INTO knb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Neꞌvageꞌana tole anaulaga asu hu-mainea kanolamogania kate mopale mainanageꞌya “Yisasiꞌa tanakaseno neꞌvie.” haya kea haviteꞌana ala kegefafiti mage huꞌana haꞌe “Anumayamogae, Tevitina aginagomogae, taꞌagaila kahauna hu-laꞌato.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Haꞌageꞌya umainaya veaꞌmoꞌya kenama-kiꞌya “Ke ohutana maiꞌo.” huꞌya hayanagi nagoꞌene ala kefiti keha keha haꞌe “Anumayamogae, Tevitina aginagomogae, kahauna hulaꞌato.” huꞌana keha keha haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Haꞌageno Yisasiꞌa haviteno aupaꞌa anile heti-maineno “Naꞌa hu-lana-tesue hugetana nehaꞌe?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Higeꞌana “Museka nehuꞌagi taꞌagaya etetaꞌa taꞌaulaga agesuꞌe hutaꞌa nehuꞌe.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Haꞌageno Yisasiꞌa kalagi ai-na-teno anaulagale aya malegeꞌana aupaꞌa anaulaga neꞌageꞌana Yisasi akave vaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Yelusalemu aupaꞌa uvaꞌyi hugahe Petafasi umainae. Petafasi kumala Olivi yosa hanea agoꞌyamona agegayalega hanegeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagapiti tole kanolana hu-na-teno mage huno hana-paiye “Atu kumate utana aupaꞌa hosi kana afumo agia tokigi ani tokimona itaꞌamoꞌene nafaꞌneꞌaene aye-tenayanagitana agegaꞌe. Agetetana kalu hetana avaletana male eꞌo. ");
INSERT INTO knb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nagoꞌa vayaꞌmoꞌyama tanahavi-gesagetana mage hutana hiꞌo ‘Kava kanotimoꞌa nago aliꞌya aligahe higetaꞌa neꞌoꞌe.’ hutana hama-paisaꞌageꞌya aupaꞌa lanamigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hiana ani yupama haya kavala Anumaya Koti aune kanomoꞌa nayoma hu-mainea kemoꞌa agola falote huno tamage hie. Mage huno kae-maleneane ");
INSERT INTO knb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Yelusalemu veaꞌmogamina mage huka hama-paiyo “Agegeho menia tamakaite kava yagai-lama-tesia kanoa augafa alino ohaino hosi kana afumo agia tokimo nafaꞌnemo agupifi maiteno eneꞌe.” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tole Yisasiꞌene tokaeꞌana nemaiꞌa kanolana uꞌana Yisasiꞌma hana-paiya kea mo haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ani hosi kana afumo nafaꞌnene itaꞌamoꞌene Yisasitega anavaleꞌana kenaꞌania anaugafaleti hateꞌana ani afumo agupile yakai-malaꞌageno Yisasiꞌa anile haino maine. ");
INSERT INTO knb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Haino maiteno neꞌegeꞌya mukiꞌa veaꞌmoꞌya “Ala kano neꞌe.” huꞌya nagoꞌamoꞌya amaugafaleti kenaꞌamia hateꞌya visia katela yakaiteꞌya yosa akopa kofa huꞌya katela yakai-tenae. ");
INSERT INTO knb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hagoteꞌya vaya veaꞌmoꞌyaene akave aya veaꞌmoꞌyaene mage huꞌya hae “Taugafa ali-gatisana kanoa Teviti aginagomogae kanale ya huka neꞌane. Anumayamo aliꞌya aligahe hanageno hu-ga-tenea kanoa Anumaya Kotiꞌa kanale manu kamino kaya hu-maine. Anafinaga mainea Anumaya Kotiꞌa taugafa ali-gatisiafe musena hisune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yisasiꞌa Yelusalemu hai-falegeꞌya anile mainaya veaꞌmoꞌya atali talu nehuꞌya mage hae “Mani kanoa ta neꞌe?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nehageꞌya alitalu hu-mainaya veaꞌmoꞌya mage huꞌya hae “Mani kanoa Nasaleti Yisasiꞌe Kalili kotegati emainea aune kano neꞌe.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisasiꞌa ala mono nopi hai-faleno ageana ani nopi mainaya veaꞌmoꞌya monehe ke huꞌya neꞌaliya veaꞌnene afaꞌa miyama nehaya veaꞌnene “Mai haleho.” huno nehuno vayaꞌmoꞌya alu kote nehanea monea neꞌaliꞌya ani kotegama nehanea monea neꞌamamiya veaꞌmogami folamoa ali-talegeno aige helafige hie. Higeno kugofa kana nama miya nehaya veala ani mono nopi mopale mainaya sipa aniꞌa huno ali-talegeno ai-helafi-lavigeno amanati-tale-tene. ");
INSERT INTO knb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mage huno hie “Anumaya Koti autaꞌmafina mage huno kae-maleneane ‘Nagai nona mukiꞌa veaꞌmoꞌya Anumaya Koti agi ayeꞌya nunamu hisaya no hane.’ huno kae-maleneanagi tamakaya musufa yama nehaya kava hugahe ma nopina emainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yisasiꞌa ala mono nopi mainegeꞌya nagoꞌa amaulaga asu hu-mainea veaꞌnene amaiya avayu hu-mainea veaꞌnene agaite ageno ani kaliꞌamia alino kanale hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Alino kanale hu-ma-teanagi ala mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene mono nopi mainaya nafaꞌneyagamoꞌya Yisasifena “Teviti nafaꞌnemogae, taugafa ali-gatigahe hu-ga-tenea kanomogae.” huꞌya kema haya kenefena Yisasiꞌma kanale auꞌava yama hia yafeꞌene haviꞌya amaipa haviya hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Amaipa haviya huteꞌya Yisasifena mage hae “Kagaya mani kema haya kea havilinano?” huꞌya havigageno Yisasiꞌa mage huno hie “E, tamakaya Anumaya Koti avona hapalitama ohavinao? mage hu-maineane ‘Anumaya Kotiga osi nafaꞌneyagaene nute nafaꞌnemogami amavayafitila kagai kagia kanaleꞌya huꞌya alisaga hisayafe hu-ma-tenane.’ huno kae-maleneane.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mani kea huteno ala kumatetila ataleno ani kegela Petani kumate mo faene. ");
INSERT INTO knb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Faeteno kotigeno Petania neꞌataleno Yelusalemu ugahe neꞌvigeno Yisasina aga-te-maine. ");
INSERT INTO knb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aga-tegeno ka haigilega nagola fiki yosa hanegeno ageteno ani yosa aepale mogeana alagaꞌa omalegeno haisaꞌage hanegeno mogeteno Yisasiꞌa ani yosahe mage huno hie “Namo yosa hetika maiyo. Agola kagai kaugafafitila nagola alaga falote ohisie.” huno higeno aupaꞌa fayo-te-maine. ");
INSERT INTO knb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yisasiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ageteꞌya tusiꞌa amamaꞌyo aigeꞌya mage huꞌya hae “Naꞌa higeno ani fiki yosamoꞌa aupaꞌa fayo-nelie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hageno Yisasiꞌa mage huno hama-paiye “Lamage huꞌna tamaha-nepauve Anumaya Kotifena tole lamakesa ohavitama ‘Mukiꞌa yama hisanana kanalelageka hateꞌasine.’ hutama tamakupi maletama tametiti hisayana fiki yosama hu-toa kavaꞌene nagoꞌa kavaꞌenena hugahae. Ma agoꞌyamofena ‘Kofa hu-lavika ala ti kotumo amuꞌnopi mo hetika maiyo.’ hutama hapaisagenoꞌa ketamia akave maleno ugahie. ");
INSERT INTO knb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mukiꞌa yafema ‘Anumaya Kotitega havigesunana kanaleꞌya huno tamigahie.’ hutama tamakupi maletama tamametiti hisayana afaꞌa amamigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisasiꞌa ala mono nopi umaineno alitalu huꞌya maiya vayala hu-mave-neligeꞌya mono note kava vayaꞌmoꞌyaene ala vayaꞌene agaitega mage huꞌya me hae “Hana augafa ala kanomo hu-gategeka mani kavala menehane? Tokiya yakaꞌa ta kamine?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Havigageno Yisasiꞌa mage huno hie “Nagaya aniꞌa huꞌna nago yafema tamaha-vigesugetamama naha-paisageꞌnahena ala kanomo hu-na-tegeꞌna emainoa kanomo agia tamaha-paigahue. ");
INSERT INTO knb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoniꞌma tima fale-ma-tenea yana Anumaya Koti hu-tegeno ani kavala me-nehifi afa vayaꞌmoꞌya hu-tageno tina me fale-mateneo? Hu-falote hutama naha-paiho.” huno hu-maine. Higeꞌya “Naꞌa maꞌa hugahune.” huꞌya mohu mehu huteꞌya mage hae. “Anumaya Koti hu-tegeno emaine.” huta hisunagenoꞌa Yisasiꞌa “Naꞌa higetama agai kea tamakupina nomalae?” huno hugahie. ");
INSERT INTO knb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hugahiafe tagaya “Afa vayaꞌmoꞌya hutageno emaine.” huta hisunageꞌyahena mukiꞌa veaꞌmoꞌya “Yoniꞌa Anumaya Koti aune kano maine.” huꞌya ago havimainaya yafe ali haviya hu-la-tegahae huꞌya mohu mehu nehae. ");
INSERT INTO knb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huteꞌya Yisasifena kenonaꞌa mage huꞌya hae “Tapiga hu-tene? Tagaya ohavinone.” huꞌya hageno Yisasiꞌa mage huno hama-paiye “Nagaya aniꞌa huꞌna hana kanomo hu-na-tegeꞌna emainoe huꞌna tamaha-opaigahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na tamakesa nehaviye? Nago kanomoꞌa tole neꞌnafaꞌneꞌa mainaꞌanagino neꞌanafaꞌa hagote nafaꞌneꞌahe mage huno mo hie “Nafaꞌneꞌnimogae meni yupa nofi alagamo hoyafi aliꞌyana molio.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Higeno nafaꞌneꞌamoꞌa mage huno hie “Oꞌugahue.” huno huteno haenagaꞌa agu ai-yahae huno aliꞌyana moli-maine. ");
INSERT INTO knb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Neꞌanafaꞌa haenaga nafaꞌneꞌahena ani ke huno hapaigeno mage huno hie “Nagaya moligahue.” huno huteno oꞌune. ");
INSERT INTO knb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hana nafaꞌnemo nefa kea ali hipoꞌya hu-maine? huno hama-vi-gegeꞌya “Hagote nafaꞌnemoꞌe.” huꞌya hageno Yisasiꞌa mage huno hie “Tamage-lafa huꞌna tamaha-nepauve musufayama nehuꞌya vaya amaugafaleti takesi mone ali-liteꞌya nehaya vayaꞌene moli hu-liteꞌya nehaya aꞌneyagaene hagoteꞌya tamakaseꞌya Anumaya Kotifena ‘Kava yagai-lato.’ huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoniꞌa hu-haleno huno fatago hutama maisaya kaana tamave-lianagi tamakaya agai kea havitama tamakupi maletama tamametitia ohunagi musufayama nehuꞌya vaya amaugafaleti takisi mone ali-liteꞌya nehaya vayaꞌene moli hu-liteꞌya nehaya aꞌnene Yoni kea haviꞌya amakupina malenae. Amakupi malagetama tamakaya agetetama haenagaꞌa kefo yatamihena tamaipa aiyahae hutama tamakuꞌa oꞌamitama agai kea tamakupina omalenae.” ");
INSERT INTO knb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yisasiꞌa “Nagola avame kea haviho.” huno mage huno hama-paiye Nago kanomoꞌa vaini nofi alagamo hoya kali-maleteno kegiꞌya hu-gove hu-maleteno ani alagayagama vaiteno aye-latigeno timaꞌamoꞌma lavisia komua kafiteno yagainoꞌma nemaiya nona anafi ki-maleteno noꞌagea vayafe “Etama hoyaꞌnifina yagaitama maineho. Ani nofiꞌmo alagafitila ali fako hutama nagoꞌa aliho.” huno hu-ma-teteno alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Umainegeno afuma nelea kanafina ani hoyamona nefaꞌa nagoꞌa aliꞌya vayala hu-ma-tegeꞌya kava vayatega nagoꞌa vaini nofi alaga aligahe umainae. ");
INSERT INTO knb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Vageꞌya hoyale kava vayaꞌmoꞌya ani vayala amatafa huꞌya nago kanoa kaꞌyo amiteꞌya nago kanomona tavata haeteꞌya nago kanomona yafa kaꞌyoteti hae-mainae. ");
INSERT INTO knb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hamayageꞌya utageno hoyamona nefaꞌa eteno nagoꞌa kasagoꞌya aliꞌya vayaꞌa hu-ma-tegeꞌya vayana hoyaleꞌma kava yagai-mainaya vayaꞌmoꞌya ani kavakeꞌya hu-ma-tenae. ");
INSERT INTO knb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hu-ma-tageno hoyamona nefaꞌa eteno agaiꞌa nafaꞌnea hu-tegahe mage huno hie “Nafaꞌneꞌnimo kea havigahae.” huno hu-teno hu-tegeno ani hoyalega umaine. ");
INSERT INTO knb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Vigeꞌya ani hoyafima kava vayaꞌmoꞌya ageteꞌya mage huꞌya hae “Mamona mani hoyamona nefa nafaꞌne. Nefaꞌma falisigenofena mani nafaꞌnemoꞌa hoyaꞌa aligahianagita agaila ago haegetao. Haesunageno falisigeno mani hoya tagai ya hapaegahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Huteꞌya avaleꞌya hoyafinagatila ai-halatu huꞌya malaga hagaꞌyu hu-taleteꞌya haeyageno fali-maine huno hie. ");
INSERT INTO knb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","41","Huteno mage hie “Naꞌa hayanagi hoyamona nefaꞌa naꞌa hu-ma-tegahie?” huno hama-vigegeꞌya mage huꞌya hae “Eteno hoyaꞌafima kava yagai-mainaya vayala tavata me-hamaesigeꞌya faligahae. Fali haꞌno hisageno alu vayafe ‘Hoyaꞌnifina kava me yagaiho.’ huno hugahie.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hageno Yisasiꞌa mage huno hama-paiye ani yafena Anumaya Koti avopina ago hapali-mainao? Mage huno hu-maineane “Vayaꞌmoꞌya yafa noma kigahena nago yafafena ‘Haviya hu-maine.’ huꞌya atalenayanagi haenagaꞌa ani yafamofena ‘Tusiꞌa kanale yafane.’ huꞌya nomo aye-tagenale malenae. Anumayamoꞌa ani avamete hu-mainegeta ageteta tusiꞌa kanaleꞌyanagino tamaꞌyo aiya kava nehie huta nehune.” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Kae-malenegi mukiꞌa veamoꞌya ani yafateꞌma asaga hu-lavisayana amaugafamoꞌa atalaga huno haviya hu-lavigahianagi ani yafamoꞌa vaya amaugafaleꞌma asaga hu-lavisiana ai-latapeno ai-talaga talago hu-talegahie. Naꞌa huyafe tamaha-nepauve Anumaya Koti kava yagai-mainea yana tamayapitila tamaha-faleno alu veaꞌmogami amayapi malegahie. Kanale alagaꞌma ayesaya veaꞌmogami amayapi malegahie huno hie. ");
INSERT INTO knb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Higeꞌya mono note kava vayaꞌene Falasia vayaꞌene haviteꞌya “Tagaife mani avame kea nehie.” huꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Haviteꞌya “Menia avaleta kina nopi ategahune.” huꞌya hayanagi veaꞌmoꞌya Yisasife “Aune kano maine.” huꞌya haya yafe vaya amauhe koli huꞌya atalenae. ");
INSERT INTO knb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Yisasiꞌa nagoꞌene mukiꞌa vayafe avame kea mage huno hie Anumaya Koti kava yagai-mainea kumate maꞌa hu-maine nagola sauve kanomoꞌa agaiꞌa nafaꞌnemoꞌa a aligahe higeno nefaꞌa ala kave talo tala hugahe hie. ");
INSERT INTO knb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Agaiꞌa aliꞌya vayala hu-ma-tegahe mage huno hie “Kema hu-ma-tenoa vayatega utama hama-paisageꞌya ani imuma ki-maloa kavela me nesae.” huno hu-ma-tegeꞌya uꞌya mo hama-paiyana ani vayaꞌmoꞌya imulena omesaya ke hae. ");
INSERT INTO knb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hageno eteno nagoꞌene alu aliꞌya vayaꞌa hu-ma-teno mage huno “Tamakaya utama kema hu-ma-toa veafe mage hutama hama-paiho Tamakaya haviho nagaya ve pulamakaene tali oꞌvai afuꞌniene ago heꞌna mukiꞌa yana ago talo tala hu-malenogi tamakaya a alisia imule eho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Higeꞌya ani aliꞌya vayala uꞌya mani kea mo hama-paiyanagi ani veaꞌmoꞌya ohavisaya ke huꞌya ataleꞌya vageꞌya nagoꞌa veala hoyaꞌamilega vageꞌya nagoꞌa veala mone aliꞌyaꞌamile vageꞌya nagoꞌa vayaꞌmoꞌya ani aliꞌya vayala amatafa huꞌya hamayageꞌya fali-mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Naꞌa hageno sauve kanomo aipamoꞌa haviya higeno agaiꞌa ati vayaꞌa hu-ma-tegeꞌya uꞌya mo hamaeꞌya haꞌno hu-taleteꞌya no kumaꞌamia kaeꞌya haꞌno hu-talenae. ");
INSERT INTO knb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hu-talageno ala sauve kanomoꞌa aliꞌya vayaꞌahena mage huno hama-paiye “A alisia imua ago kiꞌna talo tala hu-malogi ‘Eho.’ huꞌnama hu-ma-toa veala amakaiꞌamia kanale huꞌya omesaya avamete hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naꞌa hu-mainagi tamakaya kamo avayaleꞌma momakesaya veafena ‘A alisia imule eho.’ hutama hiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Higeꞌya aliꞌya vayaꞌmoꞌya anima katega momakaya veala haviya hu-mainaya veaꞌnene kanale veaꞌnene amavaleꞌya melitalu hageno mukiꞌa sauve kanomo nafaꞌnemoꞌma aꞌma alisia imulela ani nopina me hiya hae. ");
INSERT INTO knb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hageno sauve kanomoꞌa amakegahe ani nopi haino mogeana nago kanomoꞌa aꞌma alisia kanaleꞌma fai-neꞌaliya augafa kena fai-oꞌalinegeno moge-maine. ");
INSERT INTO knb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mogeteno ani kenama fai-oꞌalinea kanohena mage hie “Nenafugae naꞌa higeka a alisia kanaleꞌma nefaiya kena ofaika ma nopina emainane?” huno havigegeno ani kanomoꞌa kea ohuno maine. ");
INSERT INTO knb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Afaꞌa maigeno sauve kanomoꞌa agaiꞌa aliꞌya vayafe mage huno hama-paiye “Aiya ayate nofi kitetama asaga hutama haniꞌyapinaga malaga hagaꞌyu hu-talegeno avi-neꞌateno avekemo nehinageno agaiꞌa augafahe kalagi aino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Anumaya Kotiꞌa kasagoꞌya veafe kea hianagi mukiꞌa veala omageꞌya nagoke nagoke huyo-gi-malenea veaꞌneꞌage ehai-nefalae. ");
INSERT INTO knb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falasia vayaꞌmoꞌya neꞌuꞌya “Hanaꞌa huta Yisasiꞌma hisia keletila atafa hisune?” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Huteꞌya keꞌamima nehaviya vayaꞌene Heloti vayaꞌene Yisasite hu-ma-tageꞌya ani vayaꞌmoꞌya mage huꞌya mo hae “Humave-nelina kanomogae tagaya havunana kagaya tamageꞌage kano mainane. Kava vayaꞌene afa vayaꞌenefena kagesa ohavika nagoke kate tamagegeꞌya nehuka Anumaya Koti kea hama-nepainane. ");
INSERT INTO knb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nagi takisi he yatela kava kanoa Sisana kanale amigahuno ifi oꞌamisune? Na kagesa nehavipi? Taha-paiyo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hageno Yisasiꞌa havi kavaꞌma hisaya amaku amakesa ago amaketeno “Vagala vaya mainagi amegati afa ke nehae. Naꞌa higetama nagaila aye-navataga hutama natafa hisaya yafena nahavi-negae? ");
INSERT INTO knb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nagola takisima nehaya alaga monea alitama naveliho.” huno higeꞌya aliꞌya ave-li-mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aveligeno mage huno hie “Mani alaga monelela ta augosaene ta agiene hane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Higeꞌya “Sisa augosaene agiene hane.” huꞌya hae. Hageno Yisasiꞌa mage hie “Sisana agaiꞌa yanagi agaila amiho. Nagi Anumaya Kotina agaiꞌa yana agaila amiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Higeꞌya anima kesi kateꞌma vaiyaya vayaꞌmoꞌya anima hia kehena amamaꞌyo aigeꞌya ataleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ani kanafina nagoꞌa Satiusi vayaꞌmoꞌya* Yisasitega emainae. Ani Satiusi vayaꞌmoꞌya mage nehaya vayale “Fali-mainaya vayala eteꞌya he-otigahae.” huꞌya nehaya vayale. ");
INSERT INTO knb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Vayalegiꞌya Yisasina mage huꞌya me havigae “Humave-nelina kanomogae Moseseꞌa mage huno hu-maineane ‘Nago kanomoꞌa nafaꞌnema oꞌate kanomoꞌa aꞌama ataleno falisigenoꞌa aganaꞌamoꞌa ani aala ali-tesigeno fali-mainea kanomofe huno anonaꞌa nafaꞌnea atesie.’ huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Seveniꞌa (7) koganamoꞌya tagaipina mainayanagino nepuꞌamimoꞌa aala ali-teneanagino nafaꞌnea oꞌate kano maineno faligeno anile aganaꞌamoꞌa aꞌamona ali-tene. ");
INSERT INTO knb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ali-teanagi nafaꞌnea oꞌate kano maineno faligeno anile aganaꞌamoꞌa eteno ali-tene. Aniꞌa hute hute hayanagi mukiꞌa seveniꞌa (7) konagamoꞌya ani aala ali-tayanagi nafaꞌneꞌamia oꞌateꞌya afaꞌa fali-mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Faltageno haenagalafa ani aala fali-maine. ");
INSERT INTO knb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Seveniꞌa (7) konagamoꞌya ani aala ali-tenayanagiꞌya fali-mainesafitiꞌma hetisaya kanafina hana kanomo ani aala alikahie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Havigageno Yisasiꞌa mage huno hama-paiye Anumaya Koti kema kae-malenaya kene tokiya yamaꞌaenefena havilama hutama ohaviya yafe tamakaya havi lamakesageꞌya nehaviye. ");
INSERT INTO knb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Veaꞌmoꞌya fali-mainesafitiꞌma hetisaya kanafina nago vemoꞌa aꞌnea oꞌaligahianagi aꞌmoꞌa venena oꞌaligahie. Ensole vaya kana huꞌya maigahae. ");
INSERT INTO knb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Fali-mainaya veaꞌma he-ti-saya kea Anumaya Kotiꞌa tamakaifema hu-mainea kea avopina mage huno hu-mainea kea hapalitama ohavinao? ");
INSERT INTO knb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mage huno hu-maine “Nagaya Anumaya Kotiꞌna Apalahamunagi Aisakinagi Yekopugami Anumaya Kotiꞌami mainoe.” huno hu-maineane. Ani anagala fali-mainayanagi “Anumaya Kotiꞌamimoꞌna mainoe.” huno hu-maineafe amaku amamemoꞌa ofalinegi afaꞌa mainae huno mani kea hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Higeꞌya melitalu hu-mainaya veaꞌmoꞌya haviteꞌya anima hia kehena amamaꞌyo ai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yisasiꞌma hia kehena Satiusi vayaꞌmoꞌya kea ohuꞌya maiya yafe Falasia vayaꞌmoꞌya haviteꞌya Yisasite melitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Maiya vayaꞌmogami amuꞌnopina nagola kahegi kema havilinea kanomoꞌa Yisasina aye-vataga hugahe mage huno havige. ");
INSERT INTO knb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Hu-lave-nelina kanomogae hana kahegi kemo mukiꞌa kahegi kemona amakaseno uhagoteno tokiyaꞌage kea hane?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Havigegeno Yisasiꞌa mage hie “Anumaya Kotiꞌa alakamofena tusiya huno kahaino. Kaguꞌafinagatiꞌene kagu kametetiꞌene kahaino. Aliꞌyama neꞌalina himamukaene kagesama nehavina yaꞌenena ami haꞌno huka amio. ");
INSERT INTO knb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mani kemoꞌa uhagoteno amakase-mainea ke hane. ");
INSERT INTO knb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Anileꞌma molia kemoꞌa ani kemoꞌma hia avamete hu-mainea kemoꞌa mage huno hu-maine ‘Kagaikaꞌa kaugafahema kahaisia avamete mukiꞌa veaꞌmogami amaugafahena kahaino.’ huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mukiꞌa Anumaya Koti amaune vayaꞌmogami kene Mosese kemoꞌenena ani tole kefi aepaꞌa hane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Falasia vayala melitalu hageno Yisasiꞌa mage huno hama-vige “Kalaisifena naꞌane tamakesa nehaviye? Ta nafaꞌne maine?” huno higeꞌya “Teviti nafaꞌne maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hageno “Naꞌa higeno Tevitiꞌa Avamuꞌmo hapaiya ke huno Kalaisifena ‘Anumayanimogae.’ hunoꞌma hu-maineana ani kemo aepaꞌahena naꞌane hutama nehae? Tevitiꞌa mage huno hu-maineane ");
INSERT INTO knb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Anumaya Kotiꞌa Anumayanimofena mage huno hie ‘Tamaga nayatega, ala vaya mainalega hanea siale emainesanageꞌna kame vayakaꞌa kaiyafinaga ama-tesugeꞌya kagaifena ‘Ago tagasane.’ huꞌya hugahae.’ huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tevitiꞌa Kalaisifena ‘Anumayaniꞌa mainane.’ huno hu-maineanagi naꞌa higeno Tevitiꞌa haenagama atesia aginagomofena ‘Anumayaniꞌa mainane.’ huno hu-maineane?” huno hama-vi-ge. ");
INSERT INTO knb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hama-vi-geanagi nago kanomoꞌa kenonaꞌa nago kea ohunegi ani kanaleti aepa heꞌya koliꞌa huꞌya nago yafena haviokenae. ");
INSERT INTO knb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Yisasiꞌa melitaluma hu-maiya vayafeꞌene agaiꞌaenema tokaiꞌya nemaiya anagafeꞌenena mage huno hie kahegi kema havilinaya anagaꞌene Falasia vayaꞌene Mosese kea huge hama-velige nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nehayanagi tamaha-paiya kea akave malegahayanagi kefo yama nehaya kavaꞌamia tamakaveꞌno hu-teho. Amakaya ala kenakea nehayanagi amakaiꞌamima haya kemona akave nomalae. ");
INSERT INTO knb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Kahegi kea akave maleho.” huꞌya mukiꞌa veaꞌmogamina kanaꞌage yakefa amayoꞌnalela nemaleꞌya nehagi amaya hugahena nagoꞌke amakinagoa maleꞌya amaya ohageꞌya tusiꞌa kana yakefa neꞌaliye. ");
INSERT INTO knb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mukiꞌama nehaya kavaꞌamia “Veaꞌmoꞌya tagesae.” huꞌya Anumayamo kae-malenea kea hanea keꞌayola veaꞌmoꞌya agesayafe ala keꞌayola talo huꞌya yagamusago kana huꞌya hamanile ko nefiꞌya kena atupaꞌamile ayaꞌaya konagali nofila aye-maleneꞌya hu-neꞌaliyane. ");
INSERT INTO knb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nehuꞌya mono nopiꞌene imuleꞌene “Ala vayaꞌage nemaiya siale maigahune.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Vaya atagu-nefaya kumapi mo-vaiyatete nehuꞌya “Naꞌa vaya mainae huꞌya ali falu fala hu-la-tesae.” huꞌya nehayane. ");
INSERT INTO knb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nehayanagi nagaya tamakaifena “Ala tisa kanomogae.” huꞌya ohiho. Tamakaila nagoke huge lama-ve-lige hisia kanotami nagaya mainogi tamakaya nagoke avamete mainetama nagoke konaga kana maiho. ");
INSERT INTO knb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma mopafi mainetama nago kanomofena “Nelafaꞌe.” hutama ohiho. Tamakai Nelamafaꞌa nagoke ikapinaga maine. ");
INSERT INTO knb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tamakaifena nagoꞌa veaꞌmoꞌya “Kava kanotimogae.” huꞌya ohiho. Kalaisiꞌa agaiꞌage kava kanotamia maine. ");
INSERT INTO knb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tusiꞌa ala kanoa tamakaipima mainesiana aliꞌya kanotami kana huno maino. ");
INSERT INTO knb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nagoꞌa veaꞌmoꞌya amakaiꞌami amaugafama aliꞌya haisagenoꞌa Anumaya Kotiꞌa “Osi kano maiyo.” huno hu-tegahianagi nagoꞌa veaꞌmoꞌya “Osi kano mainoe.” huno hisigenofena Anumaya Kotiꞌa agia alisaga huno anale malegahie huno hie. ");
INSERT INTO knb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Avoꞌnio kahegi kema havilinaya anagaꞌmogatamaene Falisia vayaꞌmogatamaenena vagala vayalagi kaꞌye ho. Anumaya Kotiꞌa kava yagai-mainea yapi veaꞌmoꞌya ugahe nehayanagi “Oꞌviho.” hutama katile-neꞌamatae. Tamakaya “Ani nopi ohaigahune.” hutama haleti nagoꞌa veaꞌmoꞌya “Hai falegahune.” huꞌya haya veaꞌmogamifena “Hai-ofalegahae.” hutama katile-neꞌamatae. ");
INSERT INTO knb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Avoꞌnio kahegi kema havilinaya anagaꞌmogatamaene Falasia vayaꞌmogatamaenena vagala vayalagi kaꞌye ho. Tamakaya hagelimo agegayalegaene mopafiꞌene vai-neꞌayetama “Nagoke kanomo Yuta vayaꞌmogati mono kea havisie.” hutama huge ave-lige nehayanagi kefo yafe hu-ve-nelitama havi kapi avaletama atageno tamakayama haya kavala tamakaila tamakaseno tusiꞌa kefo yana nehianagino hani yapi tegelege nehia atafi tamakaiꞌene ugahie. ");
INSERT INTO knb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Avoꞌnio tamakaila tamaulaga asu hu-mainegetama veafena “Kaana tamave-ligahune.” hutama nehaya vayaꞌmogatama kaꞌye ho. Mage hutama nehae “Nagoꞌa veaꞌmoꞌya ‘Ala mono nomo agile hu-lokiya vaiꞌna tamagelafa nehue.’ hunoꞌma hisiana ‘Afa ke kana hu-maine.’ hutama hu-mainagi nagoꞌa veaꞌmoꞌya ‘Ani mono nopima kanileta yafatetiꞌma talo hu-malenaya yamo agile hu-lokiya vaiꞌna tamagelafa nehue.’ hunoꞌma hisiana ani kema hisia kanomoꞌa hia kea hu-lama huno hino.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tamakaila tamaulagamoꞌa asu hu-mainegetama aifoꞌnafo vaya mainae. Na yamo ala yana hane? Ani kanileta yafateti talo hu-malenaya yano? Ifi ani mono nomoꞌa ala yakefa haneo? Aꞌao anima kanileta yafateti talo hu-malenaya yana mono nopinaga malenaya yafekeꞌya alu aotage yana hane. Naꞌa hu-maineafe mono nomoꞌa agaseno ala yakefa hane. ");
INSERT INTO knb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tamakaya mage hutama nehae “Nagoꞌa veaꞌmoꞌya ‘Mono nopi sipi sipi heꞌya nemalaya folamo* hanea yate agi ayeꞌna hu-lokiya vaiꞌna tamagelafa nehue.’ huno hisiana afa ya kana ke nehigi hesaya yafe folamole nemalaya sipi sipihena nagoꞌa veaꞌmoꞌya ‘Agi ayeꞌna tamagelafa hu-lokiya vaiꞌna nehue.’ huno hisia kemona ani veaꞌmoꞌya hu-mainesaya kemona akave maleꞌya hiho.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nehayanagi tamaulaga asu hu-mainea vea mainae. Na yamo ala yana hane? Anumaya Kotina sipi sipi amisaya yano ifi muse yama nemalaya folamoa ala yane? E, folamoa ala ya hane. Nagoꞌa sipi sipia ani folamole nemalayafe alu aotage sipi sipi haneanagino folamoa tusiꞌa ala yane. ");
INSERT INTO knb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nagoꞌa veaꞌmoꞌya “Folamomo agi neꞌayone.” huꞌya hisaya veaꞌmoꞌya mukiꞌa yama ani folamoleꞌma nemalaya yafeꞌene nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nagoꞌa veaꞌmoꞌya “Ala mono nomo agi ayeꞌna hu-lokiya vaiꞌna tamagelafa nehue.” huꞌyama hisayana ani mono nomofeꞌene ani nopima mainea Anumaya Kotifeꞌene nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nagoꞌa veaꞌmoꞌya “Ikamo agile hu-lokiya vaiꞌna tamagelafa nehue.” huꞌyama hisayana Anumaya Kotina siaꞌaene ani yateꞌma mainea kanomofeꞌene nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Avoꞌnio kahegi kema havilinaya anagaꞌmogatamaene Falasia vayaꞌmogatamaene vagala vayalagi kaꞌye ho. Tamakaya supu tala yaꞌene atuꞌene hefi kana yaꞌene osi osi yana alitama teniꞌa (10) haꞌya malenafiti nagoke haꞌya Anumaya Kotina neꞌamiyanagi kahegi kefina ala yamona aepaꞌa neꞌatalae. Fatago hutama kaiyeke hu-matesaya yaꞌene kayone hutama maisaya yaꞌene Anumaya Kotife havitama lamakupi maletama tamametiti hisaya yaꞌene ago neꞌatalae. Hagotetama ani aepaꞌa hanea kea hutetama anile supu tala yaꞌene atuꞌene hefi kana yaꞌene alitama teniꞌa (10) haꞌya malenafiti nagoke haꞌya Anumaya Kotima amisayana kanaleꞌya hugahie. ");
INSERT INTO knb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tamaulaga asu hu-mai veala “Nakave eho.” hutama nehaya veaꞌmogatama tamakaya mage nehae “Osi osi havigafa nesuna tipina maineanagita onegahune.” hutama neꞌatalayanagi ala hosia nesaya tipina mainegetama netama nenakaiye. ");
INSERT INTO knb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Avoꞌnio kahegi kema havilinaya anagaꞌmogatamaene Falasia vayaꞌmogatamaene vagala vayalagi kaꞌye ho. Amega lamaugafale kava hutama masutamiene yopatamiene amega kaiyagaꞌa sese nehayanagi tamakupinaga musufa yama nehaya yaꞌene tamaugafa age lama-haꞌye nehaya yatamiene hiya hu-lama-teneanagi sesela nohae. ");
INSERT INTO knb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tamaulagamoꞌa asu hu-mainea Falasia vayaꞌmogatama hagotetama ti kemo ayopinagaene yopamo ayopinagaene seseꞌma hisayana amega kaiyagaenena oniꞌyaꞌagela ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Avoꞌnio kahegi kema havilinaya anagaꞌmogatamaene Falasia vayaꞌmogatamaene vagala vayalagi kaꞌye ho. Tamakaya maꞌa nehae vaya komuleꞌma mopama ayeꞌya ali-masave huꞌya ali konagali hu-malayanagi ani komufinaga vayala kasaligeno ayamufama ali yogita huno havi yama hu-lavia avamete kava nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nehayanagi tamakayaenena ani kavakeꞌya hutama mainae. Veaꞌmoꞌya amega tamaugafale nelamakeꞌya “Fatago veaꞌne mainae.” huꞌya nehayanagi tamakupinaga havigema nehaya yatamiene kefo yama nehaya yatamiene kasago hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Avoꞌnio kahegi kema havilinaya anagaꞌmogatamaene Falasia vayaꞌmogatamaene vagala vayalagi kaꞌye ho. Anumaya Koti amaune vayaꞌene fatago kavaꞌma hu-mainaya veaꞌnenema faligeꞌya he-vai-ma-tenaya komulega tamakaya kanagune hu-maletama mainae. ");
INSERT INTO knb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mainetama mage hutama nehae “Tagaya tototimoꞌya mainaya kanafima mainoteꞌasina Anumaya Koti amaune vayala hamaonageꞌya ofalileꞌasine.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ani kema nehaya kemoꞌa “Amaune vayala hamayageꞌya fali-mainaya vayaꞌmogami nafaꞌneꞌamimogata mainone.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nehayanagi tamakinagomoꞌya kefo yama hu-mainaya kavala tamakaya nagoꞌene hisageno hiya hisie. ");
INSERT INTO knb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tamakaya osifaꞌvemogatamae. Osifaꞌveyagamo nafaꞌnemogatama Anumaya Kotiꞌa “Hanimo aguꞌafi agola tamakata aisia kumate umaiho.” huno kaiyekema hu-lama-tesiana hanaꞌa hutama faletama ugahae? ");
INSERT INTO knb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ani yafe nagaya amaune vayaꞌene havi haviꞌyaꞌami hanea vayaꞌene hu-lama-ve-neliya vayaꞌene tamakaiteꞌma hu-ma-tesugeꞌya esagetamahena nagoꞌamogamina yafaga yosale nili hetama asaisageꞌya faligahae. Nagoꞌamogamina mono nopinaga hegi kaꞌyoteti hamaetama ali-haviya hu-matesageꞌya alu kumate kumate faleꞌya ugahae. ");
INSERT INTO knb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hamaesageꞌya falisaya yafe ma mopafina mukiꞌa fatago veaꞌmogamina ago hamayageꞌya fali-mainaya kolamoꞌa Evoloꞌa kefo yana ohunea kanoꞌagi hagoteꞌya hayageno falitegeꞌya nagoꞌa hamaeme hamaeme ageno haꞌno higeꞌya haenagalafa Pelakia nafaꞌnea Sekalaiyana ala mono nomo kegiꞌyamo amuꞌnopi yafa folamole heti-mainegeꞌya hayageno fali-mainegi tamakaya menima mainaya veaꞌmogatama agoꞌma hu-mainaya kefo yamo anonaꞌamia aligahae. ");
INSERT INTO knb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tamage huꞌna tamaha-nepauve ago hamayageꞌya fali-mainagi tamakaya menima mainaya veaꞌmogatama agoꞌma hu-mainaya kefo yamo anonaꞌamia tamakaya aligahae. ");
INSERT INTO knb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Vaeha Yelusalemu mainaya veaꞌmogatama tamakaya Anumaya Koti amaune vayala nehamaetama Anumaya Koti hu-ma-tegeꞌya tamakaitega aya vayala yafa kaꞌyoteti tavata hamae-mainagi nagaya mukiꞌa yupa a kokolemoꞌma nafaꞌneꞌama agekoꞌnafinaga alitaluma nehia avamete huꞌna tamakaila nagaya nagaiꞌniꞌalega alitalu hu-lama-tegahe nehugetama tamakaya “Aniꞌa kavala ohuo.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Nehagi haviho na ma mainaya kumafena Anumaya Kotiꞌa ago neꞌataleno “Aoteꞌyamaꞌae.” huno hu-maineanagitama menia nagoꞌene onagegahagi “Anumayamo aliꞌya aligahe higeno hu-tenea kanoa Anumaya Kotiꞌa kanale manua amisie.” huꞌya hisaya kanafina nagoꞌene nagaila nagegahae huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisasiꞌa ala mono nona neꞌataleno vigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ayaꞌamoꞌya ala mono noꞌyaga ave-liye. ");
INSERT INTO knb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ave-ligeno Yisasiꞌa mage huno hie “Tamakaya mukiꞌa ma noꞌyaga neꞌagao? Tamage huꞌna tamaha-nepauve ani nomo yafaꞌyaga mukiꞌa alino lagape ai-talesigeno aposi-lavigeno nago yafamoꞌa nago yafamo agupifina ai-kalo huno omaigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisasiꞌa Olivi yosa hanea agoꞌyamo agegayalega haino mopale mainegeꞌya agaiꞌaenema tokaeꞌya nemaiya anagala amakaiꞌamige mage huꞌya me hae “Na kanafi ani yamoꞌa falote hugahie? Hana augafa tokiya avame yamo esana kanaene ma mopama haꞌno hisia kanaene faloteꞌma hisia yana taveligahie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hageno Yisasiꞌa mage huno hie Nagoꞌa veaꞌmoꞌya havigema tamaha-paisagetama ohavisaya yafe kaꞌye ho. ");
INSERT INTO knb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kasagoꞌya vayaꞌmoꞌya nagai nagi ayeꞌya nagoke nagokeꞌmoꞌya “Tamaugafa ali-gatisua yafe Anumaya Kotiꞌa hu-na-tegeꞌna neꞌue.” huꞌya hisageꞌya kasagoꞌya veaꞌmoꞌya amakai kea haviteꞌya amakave malegahae. ");
INSERT INTO knb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Malegahagi “Nagoꞌa kotega kame nehae. Nagoꞌa kotega tu hugahe nehae.” huꞌya tamaha-paisagetamahena kolia ohiho. Ani yaꞌyagamoꞌa hagoteno falote hugahianagi ma mopama haꞌno hisia kanamoꞌa aupaꞌa huno falote ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nagoꞌa vayaꞌmoꞌya alu vayaꞌenena kamea hugahae. Ala kotega vayaꞌene nago ala kotega vayaꞌene kamea hugahae. Kasagoꞌya alu kote kotega tusiꞌa kafu nehuꞌya amakatesia kanaene falote hisigeno tusiꞌa imila aligahie. ");
INSERT INTO knb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ani yaꞌyagamoꞌa afaꞌa aꞌnemoꞌya nafaꞌnema ategahe hageno aepa heno agatama neꞌaiya avamete kava hugahianagi haenagaꞌa tusiꞌa tamakata aisia yana falote hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tamakaya nakaveꞌma neꞌaya yafe tamatafa huꞌya ali haviya hu-lama-teteꞌya tama-haesagetama faligahae. Nagima neꞌayaya yateti kasagoꞌya vayaꞌmoꞌya amaipa kafa he-lama-tegahae. ");
INSERT INTO knb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Amaipa kafa he-lama-tesaya yateti kasagoꞌya veaꞌmoꞌya nagaifena haviꞌya amakupi maleꞌya amametitima nehaya yana ataleꞌya nagoꞌa veala amakesi huꞌya amaipa kafa he-lama-tegahae. ");
INSERT INTO knb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kasagoꞌya havige amaune vayaꞌmoꞌya havige hisageꞌya kasagoꞌya veaꞌmoꞌya amakai kea haviteꞌya amakave malegahae. ");
INSERT INTO knb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kefo yama nehaya yamoꞌma ala hisigeno nagoꞌa veaꞌmoꞌya nagoꞌamimogamifema hamau amayamopafi nehamaiya yamoꞌa osi hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Osi hugahigi nagoꞌa veaꞌmoꞌya nagai kema atafa huꞌya tokiyaꞌage hume humema visageꞌnahena nagaya eteꞌnama esua kanafina nagai kema atafa hu-linesaya veaꞌmogamina Anumaya Kotiꞌa amaku amamena ali-gatigahie. ");
INSERT INTO knb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anumaya Kotiꞌma kava yagai-mainea yafe kanale mono kea mukiꞌa ma mopafi veaꞌmogamina hama-paisageꞌya havitesageno ma mopamoꞌa haꞌno hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yisasiꞌa mage huno hie nayoma mainea aune kanoa Tanioloꞌa tusi havi yana, ma mopa alino hagagitalesia yamoꞌa tamaꞌyo aisia kava falote hisia yafe taha-pai-maine. Anima hu-mainea kema hapalitama havisamogatama havilama hiho. Ani yamoꞌa alu aotage yapi he-ti-mainesigetama agegahae. ");
INSERT INTO knb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Agenutamahena Yutia mainesaya veaꞌmogatama tamaiyayetama agoꞌyalega faletama viho. ");
INSERT INTO knb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nagoꞌa veaꞌmoꞌya nogatofule haiꞌya mainesaletila afenoꞌyaꞌamima alisaya yafena eteꞌya nopinaga ohaiho. ");
INSERT INTO knb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nagoꞌa veamoꞌya hoyafinaga mainesaletila eteꞌya kenaꞌamima alisaya yafena notega oꞌviho. ");
INSERT INTO knb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Avoꞌnio ani kanafina amaipaene aꞌnene nute ani-linesaya nafaꞌnemogami itaꞌamimoꞌyaenefena tusiꞌa nahau nehie. ");
INSERT INTO knb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nehigi nunamuna mage hutama havigeho “Tani koꞌma tisia ikateꞌene Sapati yupaenena ani yamoꞌa falote ohinageta faleta oꞌvisune.” hutama havigeho. ");
INSERT INTO knb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ani kanafina tusiꞌa kana yamo falote hugahie. Eheꞌma Anumaya Kotiꞌa ma mopama taloma hu-malenea kanaletiꞌene meni kanafiꞌene ani avamete ala kana yamoꞌa falote ohuneane. Falote ohuneanagi tusiꞌa kana yamo ala hutesigeno haenagaꞌa aniꞌa huno falote ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anumaya Kotiꞌa ani havi kanama alino aupa hu-malene. Aniꞌama ohileꞌasina mukiꞌa veaꞌmoꞌya falileꞌasinagi. Anumaya Kotiꞌa haigenoꞌma hapali-ma-tenea veafe agesa havino amaugafama ali-gatisia yafe ani kanaꞌa alino aupa hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ani kanafina nagoꞌa veaꞌmoꞌya mage huꞌya hugahae “Anumaya Kotiꞌma taugafa aligatigahie huno hutenea kanoa ma mainegi ageho. Atu mainegi ageho.” huꞌyama hisagetamahena “Tamage nehae.” hutama tamametitia ohiho. ");
INSERT INTO knb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ani kanafina nagoꞌa havigeꞌage amaune vayaꞌene “Nagaya Anumaya Kotiꞌa tamaugafa aligatigahie huno hu-na-tenea kano mainoe.” huꞌya havigema hisaya vayaꞌenena evaꞌyi huꞌya veaꞌmogamina aye-mavataga hugahe tokiyaꞌage avame yana hugahayanagi Anumaya Kotiꞌa haꞌye higeno hapali-ma-tenea veaꞌmoꞌya ani kea ohavigahae. ");
INSERT INTO knb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tamage ani yana falote ohunaya kanafi mani kea ago tamaha-paugi haviho. ");
INSERT INTO knb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nagoꞌa veaꞌmoꞌya “Ani kanoa kaꞌme kotega maine.” huꞌya hisagetamahena oꞌviho. “Nopinaga maine.” huꞌyama hisagetamahena ani kea havitama tamametitia ohiho. ");
INSERT INTO knb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna eteꞌna esua yamoꞌa maꞌa hugahie yagema vaꞌyi nehilegati aulumaya kotino aupaꞌa mukiꞌa kotega ai-vasa nehia avamete huꞌna nagaya eteꞌna egahue. ");
INSERT INTO knb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Afuma fali-mainea kefafima hakikimoꞌya yage yage huꞌya alitaluma nehaya avamete huꞌna ikapinagati emainoa kanomoꞌna mukiꞌa veaꞌmogami amuꞌnopi egahue. ");
INSERT INTO knb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ani havi kanamoꞌma haꞌno hisigenoꞌa yagemoꞌa hani-kinageno ikamoꞌa ai-vasa ohugahie. Kaꞌnefiꞌmoꞌa ikatetila atafai-lavigahie. Ikateꞌma hanea yamoꞌa alu kate kate huno vaiyegahie. ");
INSERT INTO knb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ani yaꞌyagamoꞌa haꞌno hutesigeꞌna ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna esua alekana yana ikate falote hisigeꞌya mukiꞌa ma mopafima mainaya veaꞌmoꞌya hamau huꞌya avi-tegahae. Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna ikapinagati siate elavisugeꞌya nagegahae. Tusiꞌa tokiya yaniꞌaene tusiꞌa hale yaniꞌaene esugetama nagegahae. ");
INSERT INTO knb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nagetesageꞌna ensole vayaꞌnia hu-ma-tesugeꞌya ala ufe kemo nehinageꞌya yagemoꞌma tavi nefalelegatiꞌene evaꞌyi nehilegatiꞌene aluga aluga haupalegatiꞌene mukiꞌa ma mopafi nagaiꞌniꞌa nahaꞌye higeꞌna hapali-ma-tenoa veaꞌnea amavalesageꞌya aluga aluga ma mopamona atupaleti melitalu hugahae. ");
INSERT INTO knb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yisasiꞌa nagoꞌene mage huno hie fiki yosamoꞌa nago avame yana tamave-ligahigi ageho. Ani yosamoꞌa hagoteno akopapiti agusasima ayeno amuꞌmalesigetamahena “Anuna neꞌvalea kanamoꞌa ago falote hugahie.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Naꞌa hugahianagi manima tamaha-nepauva kuguva yama agenutamahena “Yisasiꞌa esia kanamoꞌa ago aupa higeno fiate hetino maineanagino ago egahie.” hutama tamakesa havigahae. ");
INSERT INTO knb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nagaya tamage huꞌna tamaha-nepauve meni kanafima mainaya veaꞌnea ofalinesageno ani yamoꞌa falote hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ikaꞌene ma mopaene fanane hugahianagi nagai kemoꞌa fanane ohugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Manima tamaha-nepauva kanama falote hisia kanahena nago kanomoꞌa ohavine. Ikapinaga mainaya ensole vayaꞌmoꞌyaenena ohavinae. Anumaya Kotina nafaꞌneꞌamoꞌnaenena ani kanama falote hisia kanahena ohavinoe. Ohavinogi Nenafaꞌa agaiꞌage haviline. ");
INSERT INTO knb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna eteꞌna esua kanafima mainesaya veaꞌmoꞌya nayoma Noaꞌma mainea kanafima mainaya veaꞌmoꞌya hu-mainaya avamete kava hugahae. ");
INSERT INTO knb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Timoꞌa yaufa hoꞌokinea kanafima mainaya veaꞌmoꞌya kavela neneꞌya tina neneꞌya nehuꞌya aꞌnema aliyamoꞌene vele uyamoꞌene mukiꞌa kanafina ani yafekeꞌya amakesa havi havi huꞌya mainageno Noaꞌa ala tipi kalefi haisaga hu-maigeno tusiꞌa lina hogino mukiꞌa ani veaꞌnea alino haviya higeꞌya agola fali haꞌno hu-mainayane. Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna eteꞌna esua kanafima mainesaya veaꞌmoꞌya nayona Noaꞌma mainea kanafima mainaya veaꞌmoꞌya hu-mainaya avamete kavala hugahae. ");
INSERT INTO knb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tamage tamaha-nepauve nagayama eteꞌna esua kanaleꞌma tole vekalatana nagola hoyafima aliꞌya neꞌalisaꞌagenofena Anumaya Kotiꞌa nagoke neꞌavaleno nagola alita-ye-talegahie. ");
INSERT INTO knb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tole atalama tokaeꞌana aliꞌya neꞌalisaꞌagenofena Anumaya Kotiꞌa nagoke neꞌavaleno nagola alita-ye-talegahie. ");
INSERT INTO knb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Anumayatamimoꞌa evaꞌyima hisia kanahena ohavinagi tamakesa havige havige hutama kava yagaitama maiho. ");
INSERT INTO knb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tamage huꞌna tamaha-nepauve nomona nefaꞌa musufa kanomoꞌa nomaꞌafima ehai-falesiana kegela na kanalelo huno agoꞌma havimainesiana yagaino mainageno musufa kanomoꞌa nomaꞌafina ehaino ofalegahie. ");
INSERT INTO knb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tamakaiꞌenena talo tala hutama maiho. “Menia omegahie.” hutama hisaya kana kanoꞌale ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna egahue. ");
INSERT INTO knb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Anumayamoꞌa mage huno hie aliꞌya kanoa kanale agu agesa hanea kanoa aliꞌyamaꞌale agegeno alige aligema nehia kanoa tamakaipina hanate maine? Naꞌama nehisia kanomofena kava kanomoꞌa mage huno hugahie “Mukiꞌa aliꞌya veatela yagai-maineka kavela fako huka mukiꞌa kanafina amamite amamite huo.” huno hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hugahianagi haenagama ani ala kanomoꞌa eteno esiana hapai-mainea augafa kavaꞌma nehinunofena ani aliꞌya kanomoꞌa muse hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tamage huꞌna tamaha-nepauve naꞌama nehisia aliꞌya kanomofena kava kanomoꞌa mage hugahie “Mukiꞌa yaniꞌa kava yagaiyo.” huno hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Hugahianagi ani aliꞌya kanomoꞌa kefo yama nehisia kanoma mainenunofena agaiꞌa agesa mage hunoꞌma havisiana “Kava kanoꞌnia menia hivi huno omegahie.” huno nehuno agaiꞌa yagai-mainesia veneꞌnegi munaꞌnegi nehamaeno ala kanomo kaveꞌene haviliꞌenena neneno aneginagi hugahie. ");
INSERT INTO knb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ani kavala maino nehisiana “Omegahie.” huno hisia yupamo kana kanoꞌale ani kava kanoa egahie. ");
INSERT INTO knb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Enunofena ani havi kavaꞌma maino nehisia kanomona kaꞌyo kevea amiteno alino haviya hu-teteno mage hugahie “Vagala vayaꞌene amakupi haviꞌya omaleꞌya amegati nehaviya vayaꞌene maiyo.” huno hu-tesigeno visiaꞌamo anilega avia mo neꞌateno ave kemoꞌa tusiya hugahie. ");
INSERT INTO knb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Anumaya Kotiꞌma kava yagai-mainea yamo aepa hesia kanamoꞌa maꞌa hugahie Yisasiꞌa avame kea mage huno hie nago kanomoꞌa aꞌnea meni kanoꞌa ali-mainea kanoa egahe higeꞌya teniꞌa (10) vele omainaya munaꞌnemoꞌya lamuꞌamia neꞌaliꞌya katega neꞌuꞌya avalegahe umainae. ");
INSERT INTO knb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vayana faefuꞌa (5) munaꞌnemoꞌya aifoꞌnafo hageꞌya faefuꞌa (5) munaꞌnemoꞌya kanale havi haviꞌyamia hane. ");
INSERT INTO knb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ani aifoꞌnafo munaꞌnemoꞌya kanaleꞌya huꞌya lamua aliꞌya vayanagi ata kaesaya tina oꞌaliꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Vageꞌya kanale havi haviꞌyaꞌamima hanea munaꞌnemoꞌya kanaleꞌya huꞌya lamuma hanagalisaya tina keꞌayopi taki-liꞌya lamuꞌamiene aliꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Umainageno ani aꞌma alisia kanoa aupaꞌa omegeꞌya ani munaꞌnemoꞌya agava-mainageno amau lokotoko higeꞌya faeꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Faeꞌya mainageno kege amuꞌnona nagola ala kemoꞌa mage huno hie “Aꞌma alisia kanoa ago neꞌegi tamakaya kategati movaletama eho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Higeꞌya mani teniꞌa (10) veleꞌma omainaya munaꞌnemoꞌya hetiꞌya lamuꞌamia hanagaliꞌya talo tala hae. ");
INSERT INTO knb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hageꞌya aifoꞌnafo munaꞌnemoꞌya kanale havi haviꞌyamima hanea munaꞌnehena mage huꞌya hae “Tagai lamumoꞌa ago asu hisia kava nehigi atama nelea tina keꞌayopitamifiti takitama tamiho.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Hageꞌya kanale havi haviꞌyamima hanea munaꞌnemoꞌya kenonaꞌamia mage huꞌya hae “Tagaiꞌene tamakaiꞌenema aye halesuna timoꞌa kosa ohenegi tamakaya afeno nopiti mo miya hiho.” huꞌya hama-paiye. ");
INSERT INTO knb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hageꞌya ani timaꞌa miya hugahe vageno aꞌma alisia kanoa anile egeꞌya talo talaꞌma hu-malaya munaꞌnemoꞌya agaiꞌene ala kave negahe nopinaga hai-falageno fita agola ki-malene. ");
INSERT INTO knb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ki-malenegeꞌya haenaga aifonafo munaꞌnemoꞌya mage huꞌya me hae “Ala kanomogae ala kanomogae fita yaki-la-to.” huꞌya me hae. ");
INSERT INTO knb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Me hageno aꞌma alisia kanomoꞌa mage huno kenonaꞌamia hie “Aꞌao tamage huꞌna tamaha-nepauve no-tama-koa anaga emainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yisasiꞌa mage huno hie “Nagayama esua yupamona kanaꞌaenena ohavinaya yafe menia kava yagaiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yisasiꞌa Anumaya Kotiꞌa kava yagai-mainea yamoꞌa maꞌa hu-maine “Nago kava kanomoꞌa ayaꞌaya kotega ugahe nehuno aliꞌya vayaꞌamofena ke higeꞌya ageno monea ali fako huno amamite amamite hie. ");
INSERT INTO knb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aliꞌya aepaꞌamia ageteno nago kanomona faefu tauseni kina (K5,000) amino nago kanomona tole tauseni kina (K2,000) amino nago kanomona vani tauseni kina (K1,000) amino huno amamite amamite huteno alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Umainegeno faefu tauseni kinama (K5,000) amigeno ali-mainea kanomoꞌa ani moneleti aliꞌya aligeno aꞌva monea nago faefu tauseni kina (K5,000) aliteno teni tauseni kina (K10,000) higeno ali-maine. ");
INSERT INTO knb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ali-geno tole tauseni kinama (K2,000) ali-mainea kanomoꞌa ani moneleti aliꞌya aligeno aꞌva monea nago tole tauseni kina (K2,000) aliteno foꞌa tauseni kina (K4,000) higeno ali-maine. ");
INSERT INTO knb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ali-geno vani tauseni kinama (K1,000) ali-mainea kanomoꞌa ani monea alino mopafi kafino kava kanomo monea he-vai-malene. ");
INSERT INTO knb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ani aliꞌya vayaꞌmogami kava kanomoꞌa ayaꞌaya kanagefa umaiteno eteno eno mage hie ‘Monema fako huꞌna tamaminoa monea naꞌmagi mone malenae?)’ huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hama-vigegeno faefu tauseni kinama (K5,000) aminea kanomoꞌa teni tauseni kina (K10,000) alino neꞌeno mage huno hie ‘Kava kanomogae musekaꞌa nehugi faefu tauseni kinama (K5,000) naminapitila eteꞌna aꞌva monene alugeno teni tauseni kina (K10,000) hane.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Higeno kava kanomoꞌa mage huno hie ‘Kagaya kanale kano maineka kanaleꞌya huka osi mone kanoꞌa kaminofitila efi efi huka aliꞌyana alinageno ala hu-maineafe ala yakefa kagaila kava yagaisanafe kamigahue. Nopinaga ehaigetaꞌa tokaetaꞌa muse hutaꞌa maiꞌano.’ huno hie ");
INSERT INTO knb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Higeno tole tauseni kinama (K2,000) aminea kanomoꞌa mage huno me hie ‘Kava kanomogae musekaꞌa nehugi kagaya tole tauseni kina (K2,000) naminapitila aꞌva monene tole tauseni kina (K2,000) higeꞌna aliꞌna neꞌoe.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Higeno kava kanomoꞌa ani kanomofena mage huno hie ‘Kagaya kanale kano maineka kanaleꞌya huka osi mone kanoꞌa kaminofitila efi efi huka aliꞌyana alinageno ala hu-maineafe ala yakefa kagaila kava yagaisana yafe kamigahue. Nopinaga ehaigetaꞌa tokaetaꞌa muse hutaꞌa maiꞌano.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Higeno vani tauseni kinama (K1,000) aminea kanomoꞌa eno mage hie ‘Kava kanomogae musekaꞌa nehugi kagaya keꞌage kanoa alu kanomo yana alika kaugafa hegeka omai kano mainane. Nago kanomoꞌa hoyaꞌafima kali-malenea yaꞌene alika negeka omai kano mainane. ");
INSERT INTO knb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mainanafe kolikaꞌa huꞌna vani tauseni kinama (K1,000) naminanaꞌmaga mopafi kafiꞌna he-vaiꞌna ka-tenoanagiꞌna menia kagaikaꞌa yanagiꞌna negamue.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Higeno kava kanomoꞌa ani aliꞌya kanohena mage hie ‘Kagaya havi kanoe. Feluꞌage aliꞌya kano mainane. Kagaya ago nehavine nago kanomoꞌma hoyaꞌafima kali-malenea yaꞌene aliꞌna negeꞌna omai kano mainoa yafena kagaya ago havimainano? ");
INSERT INTO knb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Naꞌa higeka monema nemalaya nopina moneꞌnima malenateꞌasina menia nagaya nagoꞌa aꞌva monene aluleꞌasine. ");
INSERT INTO knb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vani tauseni (K1,000) kinaꞌnia hafaletama teni tauseni kinama (K10,000) malenea kanomona amiho. ");
INSERT INTO knb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nagaya tamaha-nepauve nagoꞌa yaꞌamima hanesia veaꞌmogamina nagoꞌene amamisigeno kasago hu-ma-tegahianagi nagoꞌa yaꞌamima omalenesia veaꞌmogamina ali-linesaya yamaꞌa hamana-falegahie. ");
INSERT INTO knb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ani havi kavaꞌma nehisia aliꞌya kanomona hani yapinaga avaletama hagaꞌyu hu-talesageno tusiya huno avia neꞌateteno avekemoꞌa hugahie.’ huno hie.” ");
INSERT INTO knb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yisasiꞌa nagoꞌene mage huno hie Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna kava yagaigahema esuana tokiyaꞌage hale yaniꞌaene ensole vayaꞌene tokiyaꞌage hale yaniꞌaleti kava yagaisua siale maigahue. ");
INSERT INTO knb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mainesugeꞌya mukiꞌa kotega veaꞌmoꞌya nagaite melitalu hisageꞌna sipi sipile neꞌyagaiya kanomoꞌma memene sipi sipiene ali fakoma nehia avamete huꞌna mukiꞌa veala ali fako hugahue. ");
INSERT INTO knb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ali fako huteꞌna sipi sipiyaga tamaga nayatega neꞌamateꞌna memeyaga hauga nayatega amategahue. ");
INSERT INTO knb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Amateteꞌna ala sauve kanomoꞌna tamaga nayategama amatesua veafena mage huꞌna hugahue “Nenafaꞌa kanale manua tamaminea vealagi eho. Ma mopama taloma hu-mainea kanaleti aepa heno tamakaife huno talo tala hu-maleteno kava yagai-mainea kumatelagi emaiho.” huꞌna hugahue. ");
INSERT INTO knb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Nagaila nagaꞌma tegetama kavela naminae. Tifema nagegetama afaꞌa naminae. Natu kanoma ogetama navaletama falu fala hu-natetama notamifina na-tenae. ");
INSERT INTO knb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kenaꞌnima omalegetama kena fai-natenae. Kalima alugetama navaletama yagai-natenae. Kinafima mainogetama nagegahena emainayane. Naꞌa kavaꞌma hu-mainayafe talo hu-lama-tenea kumatela emaiho.” huꞌna hugahue. ");
INSERT INTO knb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hugeꞌya tamaga nayategama fatago kavaꞌma nehaya veaꞌmoꞌya mage huꞌya hugahae “Anumayamogae na yu kagala tegeta kageteta kavela kaminone? Na yu tifena kagegeta tina kaminone? ");
INSERT INTO knb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na yu natu kanoa evaꞌyi hanageta alita kanale huta ka-tenone? Na yu kenakaꞌa omalegeta kena kaminone? ");
INSERT INTO knb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na yu kalia alinageta kage-mainone? Na yu kinafina mainanageta mo kage-mainone?” huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Huꞌya hisageꞌna ala kava kanomoꞌna kenonaꞌamia mage hugahue “Tamagelafa huꞌna tamaha-nepauve tamakaya amakima omale naganaꞌnimogamima ani kavaꞌma hu-ma-tayana nagai ani kavala hu-natenae.” huꞌna hugahue. ");
INSERT INTO knb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hugahuanagi haoga nayatega veafena mage huꞌna hugahue “Tamakaya hu-haviya hu-matenoa kefo kavakeꞌya nehaya veaꞌmogatama mai-haletama viho. Sataniꞌene aliꞌya vayaꞌaenena agola tegelege nehia atafi maisaya kumala ago talo hu-malenogi ani kumate agola umaiho. ");
INSERT INTO knb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nagaila nagaꞌma liana kavela onaminae. Tifema nagegetama tina onaminae. ");
INSERT INTO knb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Natu kanoma ogetama navaletama falu fala hu-ona-tenae. Kenaꞌnima omalegetama kena fai-ona-tenae. Kalima alugetamao kinafima maugetamao me onagegenayane.” huꞌna hugahue. ");
INSERT INTO knb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hisugeꞌya kenonaꞌnia mage huꞌya hugahae “Anumayamogae na yu kagala tegeta kage-mainone? Na yu tifena kagegeta kage-mainone? Na yu natu kanoa anageta kage-mainone? Na yu kenakaꞌa omalegeta kage-mainone? Na yu kalia alinageta kage-mainone? Na yu kinafina mainanageta kage-mainone? Tagayama kage-mainoteꞌasina ago kaya hu-mainoteꞌasine.” huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hisageꞌna nagaya eteꞌna amakaifena mage hugahue “Tamagelafa huꞌna tamaha-nepauve tamakaya amakima omalenea naganaꞌnimogamina ani kavaꞌma hu-oꞌama-tayana namona nagaiꞌene hu-ona-tenayane.” huꞌna hugahue. ");
INSERT INTO knb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Huteno kefo yama nehaya anonaꞌamia hu-ma-tenageꞌya agola amakata aisia hani yapi maisaya kumate ugahagi fatago kavaꞌma hu-mainesaya veaꞌmoꞌya ofaliꞌya agola maige maige hisaya kumate ugahae huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yisasiꞌa mukiꞌa mani kea hu haꞌno huteno agaiꞌaenema lokaeꞌya nemaiya anagafena mage huno hie “Tamakaya ago havimainae tole kana mainesunageꞌya kafuꞌahe kafuꞌahe Anumaya Kotiꞌa taginagomogami amaugafama ali-gati-mainea kanahe* alitalu huꞌya imua kigahae. Ani imuma kisaya kanafina ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌnia natafa huꞌya yafaga yosale nili heꞌya nasasaigeꞌna faligahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mono note kava vayaꞌene Yuta vayatamaene ala mono note uhagote-mainea kava kanoa, Kaiyafasiꞌe ani kanomo nopi, melitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Maineꞌya mage hae “Hanaꞌa huta agesi huta Yisasina atafa huta haesunageno falisie? ");
INSERT INTO knb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ala imuma kisaya kanafina atafa ohugahune. Atafa hisunageꞌya veaꞌmoꞌya havigu tusiꞌa ke huꞌya tu huyafenagita atalegahune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yisasiꞌa Petani viana nayona fugitaya age-mainea kanomo agia Saimoniꞌe kanomo nopi umaine. ");
INSERT INTO knb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Umainegeno nago aꞌmoꞌa yafa keꞌayola alilino anileꞌma eana ani keꞌayoꞌma taloma hu-malenaya yafamo agia alapasata. Ani li keꞌayopina nagola tusiꞌa miyamaꞌa hanea masavena manaꞌage tina haneanagino Yisasiꞌa kave maino nenegeno ani aꞌmoꞌa Yisasi anupi ani masavena takino fale-tene. ");
INSERT INTO knb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Takino fale-neꞌa-tegeꞌya Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya ageteꞌya ke vaiꞌya mage hae “Naꞌa higeno mani manaꞌage masavena afaꞌa neꞌatale? ");
INSERT INTO knb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ani masavena nago kanomoꞌma miya hileꞌasina tusiꞌa mone aliteta ani masaveteti monea afenoꞌamima omalenea veaꞌne amamuteꞌasine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hageno Yisasiꞌa ani kea haviteno mage huno hie “Kea oꞌama-kitama afaꞌa ataleho. Havige nehagi nagaila tusiꞌa kanale kava hu-nena-te. ");
INSERT INTO knb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Moneꞌamima omale veaꞌmoꞌya mukiꞌa kanafina tamakaiꞌenekeꞌya maigahayanagi nagaya tamaikaiꞌenena mukiꞌa kanafina omaigahue. ");
INSERT INTO knb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mani aꞌmoꞌa masavena naugafaleꞌma takino fale-nena-teana afaꞌa ofaliꞌna mainogeno masavema faleꞌya he-vai-na-tesaya avamete huno fale-nena-te. ");
INSERT INTO knb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tamage huꞌna tamaha-nepauve mukiꞌa ma mopafi veapima nagaifena kanale mono kema hama-paisafina mani aꞌmoꞌma hia kavafeꞌenema hama-paisageꞌya mukiꞌa veaꞌmoꞌya agaifena amakesa havigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Higeno Yutasi Isakaliotiꞌa Yisasina tuelufuꞌa (12) anagaꞌene tokaeno nemaiya kanogino neꞌamataleno viaꞌamo mono note kava vayate umaine. ");
INSERT INTO knb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Uvaꞌyi huno mage huno hie “Agesi huꞌna tamave-lisugetama Yisasima atafa hisayana na kano namigahae?” huno higeꞌya muse huteꞌya aupaꞌa tetiꞌa (30) siliva alaga mone aminae*. ");
INSERT INTO knb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Amigeno Yutasiꞌa vaya kulata oꞌaiya yate kesi kateti Yisasina movalesigeꞌya atafa hisaya kafe ati-ye-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hale oki kai-hamema nenaya kanamona hagote kanale Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya Yisasife mage huꞌya me havigae “Anumaya Kotiꞌa Yuta vaya amaugafama ali-ga-ti-mainea kanahe kagesa havisana kavela hana nopi mo-lalo tala hisune hunageka nehane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hageno Yisasiꞌa mage huno hama-paiye “Ala kumate uvaꞌyi hutama nago kanomote mage hutama mo hiho ‘Hu-lave-nelia kanomoꞌa mage hie ‘Falisua kanamoꞌa ago aupa higeꞌna kagai nopi nagaiꞌenema tokaeꞌya nemaiya anagaꞌaene Anumaya Kotiꞌa Yuta vaya amaugafama ali-ga-ti-mainea kanahe tagesa havisuna kavela nesune huꞌna nehueꞌ huno hie.’ hutama hiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya Yisasiꞌma hama-paiya avamete huꞌya ani kavela mo-lalo tala hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Talo tala hu-malageꞌya yagemoꞌma tavi faleamaꞌa Yisasiꞌa tuelufuꞌa (12) anagaꞌaene kave negahe folamole mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Maineꞌya kavela nenageno Yisasiꞌa mage huno hie “Tamage huꞌna tamaha-nepauve nagaiꞌenema mainafitila nago kanomoga nagesi huka nahaesana yatela vai-neꞌayane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Higeꞌya anagaꞌamoꞌya amaipa haviya huteꞌya agaifena mage huꞌya havigae “Anumayamogae nagaife nehano?” huꞌya nagoke nagokeꞌmoꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Havigageno Yisasiꞌa mage huno hie “Nagaiꞌenema nagoke yopafiti ayateti vayagofinoꞌma nenea kanomo nagesila huno nahaesia yatela vai-neꞌaye. ");
INSERT INTO knb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna nagaife huꞌya Anumaya Koti avopina kae-malenaya kate ugahuanagi vayaꞌmoꞌya havisagi huno nagesi hisia kanomofena avoꞌnio nahau hanagi kagaya kaꞌyeka maiyo huꞌna nehue. Ani kanomoga itakamoꞌma okateneleꞌasina kanale hileꞌasine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Higeno Yutasiꞌa agesiꞌma hisia kanomoꞌa mage huno hie “Hu-lave-nelina kanomogae nagaife nehano?” huno higeno Yisasiꞌa mage huno hapaiye “Kagaya kagaika ago hu-falote nehane.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kavela nenageno Yisasiꞌa kai-hame kana maya alino nunamu huno muse huteno kolite kolite huno agaiꞌaenema tokaeꞌya nemaiya anagala neꞌamamino mage huno hie “Mamona nagaiꞌni naugafagi alitama neho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nagola vaini nofi alagamo ti* hanea keꞌayola aliteno nunamu huno muse huteno amamite amamite nehuno mage huno hie “Mukiꞌamogatama neho. ");
INSERT INTO knb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ma lina nagaiꞌa kolaniꞌae. Nahaesageꞌna falisugeno kolaniꞌamoꞌa tamakaifene huno take take hu-lavisiafe haegafa kea, Anumaya Kotiꞌene hagelafitama maisaya kea* ali fatago hugahianagino Anumaya Kotiꞌa ani kolatetifene huno kasagoꞌya veaꞌmogami kefo yaꞌamia aige-ama-teno atale-ma-tegahie. ");
INSERT INTO knb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nagaya tamaha-nepauve menia nagaya vaini nofi alagamo tina* nagoꞌene onegahuanagiꞌna Nenafaꞌa kava yagai-mainea kumate umaineꞌna haegafa nofi alagamo tina* eteꞌna tamakaiꞌene tokaeꞌna maineꞌna negahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Higeꞌya nagola yagamea huteꞌya Olivi yosa hanea agoꞌyafi hai-mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yisasiꞌa mage huno hama-paiye “Tamakaya mukiꞌamogatama meni kegela nagaiꞌma hu-na-tesaya kavafena nagaifema havitama tamakupi maletama tamametiti nehaya yana ataletama asaga hu-lavisagi nayona ani yafena mage huno kae-maleneane ‘Nagaya sipi sipi kava kanoa haesugeꞌya sipi sipiyaga atagufeꞌya faleꞌya ute ete hugahae.’ huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kae-maleneanagi fali-mainesufiti Anumaya Kotiꞌa alino he-ti-na-tesigeꞌna Kalili uhagote-lama-teꞌna ugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Higeno Pitaꞌa kenonaꞌa mage huno hie “Hu-ga-tesaya yafema mukiꞌa anagaꞌmoꞌya kagaifema haviꞌya amakupi maleꞌya amametiti nehaya yama ataleꞌyama falesageꞌnahena nagaya mukiꞌa kanafina kataleꞌna ofalegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Higeno Yisasiꞌa kenonaꞌa mage huno hie “Pitaga tamage kaha-nepauve meni kegela kokolemoꞌa agea oꞌainesigeka tagufa (3) kanale ‘Nagaya oꞌagenoa kanoeꞌ huka avane hugane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Higeno Pitaꞌa mage huno hie “Kagaiꞌene nahaesageꞌna faligahuanagiꞌna kagai kagia avanena huꞌna ali fala okigahue.” huno higeꞌya mukiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya nagoke kegeꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yisasiꞌa amakaiꞌene viaꞌamo Ketesemani uvaꞌyi huteꞌya Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafena mage huno hie “Tamakaya male maineho. Nagaya amule visuaꞌamoꞌna nunamuna huꞌna havigegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pitaꞌene Sepeti nafaꞌnetalaꞌene amavaleno viana aipamoꞌa kanaꞌage higeno haumanamoꞌa halegeno kasageke nehie. ");
INSERT INTO knb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huteno mage huno hama-paiye “Nahau nayamopamoꞌa tusiꞌa kanaꞌage nehigeꞌna ago falisua kava nehugi male mainetama kava yagaitama maineho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Osiꞌa viaꞌamo Anumayamotega ke huno havigegahe mopafi agoꞌya moyeno maineno nunamuna mage huno havige “Nagaya ago falisua kava nehugeno ani havi kanamoꞌa satuꞌage hu-mainea tima hanea keꞌayola kahaisigekahena ani keꞌayola naha-fale-talo. Nagai nagu nagesa akave omaleka afaꞌa kahaisia yana huo.” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Havigeteno momakeana agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya faeꞌya mainageno Pitafena mage huno mo hie “Vae kagaya aupa yage kanoꞌa kava oꞌyagaika mainano? ");
INSERT INTO knb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sataniꞌa aye-lama-vataga hisigeno tamakuꞌamoꞌa ‘Ohugahue.’ huno tokiyaꞌage hugahianagi amega tamaugafamoꞌa tokiyaꞌa afaꞌa omaleneanagino ‘Hugahue.’ huno hisia yana hugahigi Satani kema ohavisaya yafena kava yagaitama mainetama Anumayamotega ke hutama havigeho.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Huteno amataleno viaꞌamo tole (2) kanale nagoꞌene nunamuna mage huno havige “Nenafagae nagaya falisua kava hugeno ani havi kanamoꞌa satuꞌage hu-mainea tima hanea keꞌayola kahaisigekahena ani keꞌayola naha-fale-talo huꞌna nehuanagi afaꞌa kahaisia yana huo.” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Havigeteno eteno momakeana amau tokotoko higeꞌya faeꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Faeꞌya mainageno tagufa (3) kanale nunamuna nagoꞌene ani avamete huno havige-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Havigeteno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagate eteno mage huno mo hama-vige “Mai-falu hutamage faetama mainao? Haviho kanaꞌniꞌa ago falote nehie. Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemonia nagesi huno navaleno kefo yama nehaya vayaꞌmogami amayapi natesigeꞌya nahaegahe nehae. ");
INSERT INTO knb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mukiꞌamogatama hetitama vigetao. Ageho nagesi huno nahaesia kanoa ago neꞌegi vigeta mogamano.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ani kea nehigeno Yutasiꞌa tuelufuꞌa (12) anagaꞌaene tokaeno nemaiya kanomoꞌa evaꞌyi higeꞌya agaiꞌene mukiꞌa vayala, mono note kava vayaꞌene nagoꞌa Yuta vayatamaenema hu-matea vayaꞌenena, ayaꞌaya naepege naepege huꞌya muki kaꞌyoꞌene aliꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Agesi huno Yisasima haesaya avame yama huno amavalea kanomoꞌa ani vayafena mage huno hama-paiye “Atakoꞌma hisua kanoa haesaya kano mainegi atafa hutama tokiyaꞌage hutama avaletama viho.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hama-paiteno Yutasiꞌa aupaꞌa Yisasite viaꞌamo mage hie “Hulave-nelina kanomogae.” nehuno atako hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Atako higeno Yisasiꞌa mage huno hie “Nenafugae hugahema esana yana aupaꞌa huo.” huno higeꞌya ani vayaꞌmoꞌya Yisasina atafa huꞌya aye-talako hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atafa nehageno nagola agaiꞌaenema he-ti-maiya kanomoꞌa ayaꞌaya naepeꞌa he-vayu huno ala mono noteꞌma uhagote mainea kava kanomona aliꞌya kanoꞌamona agesa ai-fakali-talegeno asaga hu-lavi-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ai-fakali-talegeno Yisasiꞌa ani kanomofena mage huno hie “Ayaꞌaya naepekaꞌa tafugepi eteka vaiyo. Ayaꞌaya naepeleti tu hisaya vayaꞌmoꞌya ayaꞌaya naepeleti hamaesageꞌya faligahae. ");
INSERT INTO knb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kagaya ohavinano? Nagaya Nenafategama ke huꞌna havigesuana seveti tauseniꞌa (70,000) ensole vayaꞌa nahauke heꞌya tuma hisaya yafena hu-ma-tesigeꞌya egahae. ");
INSERT INTO knb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Egahayanagi naꞌama hisagenoꞌa hanaꞌa huno nagaifena ‘Naꞌa kavala hu-tesageno faligahiema.’ huꞌya Anumaya Koti avopima kae-malenaya kemoꞌa falote huno tamagea hugahie?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anileꞌma melitalu hu-maiya vayafena Yisasiꞌa mage huno hie “Tamakaya nagaifena ‘Vaya hamaeno musufaya nehia kano maine.’ hutama ayaꞌaya naepene muki kaꞌyoꞌene alitama natafa hugahena neꞌao? Nagaya mukiꞌa kanafina efi efi huꞌna tamakaiꞌene ala mono nopina maineꞌna mono kea tamaha-pauvanagi naꞌa higetama natafa ohunayane? ");
INSERT INTO knb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ohunayanagi nayoma mainaya amaune vayaꞌmoꞌya kae-malenaya kemoꞌa falote huno tamage hisia yafe mukiꞌa mani kavala hutama natafa nehae.” huno hie. Higeꞌya mukiꞌa agaiꞌaenema tokaeꞌya nemaiya anagala neꞌataleꞌya fale haꞌno hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yisasima atafa haya vayaꞌmoꞌya avaleꞌya ala mono note uhagote-mainea kava kanomo* note, Kaiyafasi note, avaleꞌya vageꞌya kahegi kema havilinaya anagaꞌene Yuta vayatamaene alitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitaꞌa akave anatino vianagi avatela oꞌunegi ago aluꞌale umaineno ala mono note hagote kava kanomo nomo haupale uvaꞌyi huno hai-faleno maineno ati vayaꞌene mopale maineno “Yisasina hu-tesaya yana agesue.” huno umaine. ");
INSERT INTO knb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mono note kava vayaꞌene mukiꞌa kanisole vayaꞌene Yisasiꞌma haesaya kaiyeke hu-tegahe nagoꞌa vaya “Kefo kava higeta age-mainone.” huꞌya havige hu-tesaya vayafe ati-ye-mainae. ");
INSERT INTO knb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Atiyayana omaigeꞌya kasagoꞌya vayaꞌmoꞌya havige huꞌya Yisasifena huteꞌya haenaga tole kanolatana he-tiꞌana Yisasifena mage huꞌana haꞌe “Ma kanomoꞌa mage huno hu-maine ‘Nagaya Anumaya Kotina ala mono nomaꞌa aliꞌna lagape ai-taleꞌna tagufa (3) kanale ani nona eteꞌna ki-talegahue.’ huno hu-maine.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Haꞌageno ala mono note hagote kava kanomoꞌa heti-maineno Yisasina mage huno havige “Kagaifena na augafa kea nehae? Kaiyekema hu-ga-taꞌa kemo anonaꞌania hu-falote huka nohane?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Higeno Yisasiꞌa avaya tukino ke ohuno maineno nago ke kanoꞌa ohune. Ohigeno ala mono note hagote kava kanomoꞌa eteno mage huno havige “Haimuꞌaene Anumaya Koti aufima kaha-vi-goa kea tamage huka taha-paiyo. Kagaya Anumaya Kotiꞌa taugafa ali-gatigahema hu-ga-tenea kanoa, Kalaisiga, mainano? Kagaya Anumaya Kotina nafaꞌneꞌamoga mainano?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Havigegeno Yisasiꞌa hu-falote huno mage huno hie “E, kagaya ani kema hanana hai nehane. Tamage ani kano mainoe. Tamaha-nepauve tamakaya haenaga ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna tusiꞌa himamuꞌa hanea Anumaya Kotina aya tamaga kaiyaga hanea siale maineꞌna ikate hanea siate esugetama nagegahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Higeno ala mono note hagote kava kanomoꞌa ani kea haviteno aipamoꞌa tokiyaꞌage higeno kenaꞌa alino hatata nehuno mage huno hie “Anumaya Kotife hu-haviya hu-neꞌatea kea hai havunanagiꞌya nagoꞌa vayaꞌmoꞌya kaiyekea hu-oꞌatesae. Tamakaya Anumaya Kotife hu-haviya hu-neꞌatea kea ago haviye. ");
INSERT INTO knb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hai havunagi na tamakesa nehaviye?” huno higeꞌya mage hae “Anonaꞌa alisia yafe haesageno falisie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Huteꞌya nagoꞌa vayaꞌmoꞌya Yisasi augosafi amavetuꞌna he-neꞌateꞌya amayateti aiko-ligeꞌya nagoꞌamoꞌya amayana ali atale-lineꞌya aiko neliꞌya mage huꞌya havigae “Kalaisigae kaune laga huka taha-paiyo taꞌya negahayae?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitaꞌa nomo haupalega mopale mainegeno nago aliꞌya munaꞌmoꞌa eaꞌamo Pitafe mage huno hie “Kagaya Kalili Yisasiꞌene tokaeka nemaina kano mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Higeno Pitaꞌa avane huno mukiꞌa vaya amaufi “Aꞌao, ani kanoa oꞌagenoa kanohe maika nehane.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Huteno fiatega umainegeno nago aliꞌya munaꞌmoꞌa megeteno anile he-ti-mainaya vayafe mage huno hie “Mani kanoa Nasaleti Yisasiꞌene vai-neꞌayea kanoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Higeno Pitaꞌa nagoꞌene eteno “Aꞌao Anumayamo aufi tamage nehue oꞌagenoa kanomofe nehane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Osiꞌa mainegeꞌya anile he-ti-maiya vayaꞌmoꞌya Pitafena mage huꞌya me hae “Tamage kagaya Kalili kano mainananagika kavefuꞌna ali-yahae higeka kema nehana yana tave-linageta havune agai anagapi kano mainane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hageno Pitaꞌa mage huno hie “Nagaya tamakema ohisugenoꞌa Anumaya Kotiꞌa nahaesie. Anumaya Koti aulagafi tamage huꞌna tamaha-nepauve tamakayama nehaya kanoa nagaya oꞌagenoa kanoe.” huno nehigeno kokolemoꞌa age ai-maine. ");
INSERT INTO knb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Agea aigeno Pitana agesamoꞌa aikalo higeno Yisasiꞌma hapaigeno havi-mainea kea mage huno hu-maineane “Kokolemoꞌa agea oꞌainesigeka kagaya tagufa (3) kanale avane huka nagaifena ali fala-kigane.” huno hu-mainea kemoꞌa Pitana agesamoꞌa aikalo higeno haviteno hati-lavino viaꞌamo tusiꞌa avi mo-te-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Koꞌma alino ha-neleana mukiꞌa mono note kava vayaꞌene Yuta vayaꞌmogami vayatamaene Yisasina haesageno falisia kea huge havige hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huteꞌya Yisasina nofi kiteteꞌya ala kamani kava kanoa, Pailatite, avaleꞌya ayapi motenae. ");
INSERT INTO knb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yutasiꞌa Yisasina agesi huno kame yama hu-tea kanomoꞌa ageana Yisasina kaiyekema hu-teteꞌya “Faligahie.” huꞌya haya yana ageteno aipamoꞌa kanaꞌage higeno eteno aminaya monea tetiꞌa (30) siliva alaga monea* alino ala mono note kava vayaꞌene Yuta vayatamaene momamine. ");
INSERT INTO knb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mo neꞌamamino mage huno hie “Nagaya tusiꞌa kefo yama huꞌna kefo yama ohunea kanomona agesila huꞌna kame yana hu-toanagino afa yafe faligahie.” huno higeꞌya ani vayaꞌmoꞌya mage hae “Kahaote yakae. Tagai yana omalenegi kagaikaꞌa yane.” huꞌya hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hu-tageno Yutasiꞌa ani yafa monea ala mono nopi hagaꞌyu hu-neꞌataleno viaꞌamo agaiꞌa ayapiti nofila alino anoꞌmu mo-ye-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mo-yegeꞌya mono note kava vayaꞌmoꞌya ani monea aliteꞌya mage huꞌya hae “Mani monea ‘Vaya haesageno falisie.’ huꞌya ali hage-mainaya monegita alita ala mono note monenena omalesune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Huteꞌya aliꞌya haꞌya kiteꞌya “Mani monea hapaleti susufane talo nehia kanomo mopa miya hugahune. Ani mopa natu vaya he-vai-ma-tesuna mopa hanegahie.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naꞌa huteꞌya ani mopamo agia kolamo tavi-mainea mopae huꞌya agia malenayanagino meni kanafina ani agimoꞌa hanegeꞌya neꞌayae. ");
INSERT INTO knb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Naꞌama hayana nayona aune kanoa Yelemaiyaꞌma hu-mainea kemoꞌa ani kanafina falote huno tamage hie. Mage huno hu-maineane “Ani tetiꞌa (30) silva alaga monea* Isaleli vayaꞌmoꞌya ‘Haesageno falisigeta ani monea kamigahune.’ huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Anumayamo naha-pai-mainea kava huꞌya ani monea aliꞌya hapaleti susufanema talo nehia kanomo mopa miya hu-mainae.” huno hu-maineane. Ani mopama miya hu-mainaya yupa ani kemoꞌa falote huno tamagea hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisasiꞌa ala kava kanoa, Pailatite, he-ti-mainegeno Pailatiꞌa Yisasifena mage huno havi-ge “Kagaya Yuta veaꞌmogami Sauveꞌami mainano?” huno havigegeno Yisasiꞌa mage hie “Kagaikaꞌa mani kea hai nehane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Higeꞌya mono note kava vayaꞌene Yuta vayatamaene “Maꞌa avamete kefo ya hu-maineane.” huꞌya hu-tayanagi Yisasiꞌa kenonaꞌamia ohune. ");
INSERT INTO knb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ohigeno Pailatiꞌa nagoꞌene mage huno hie “Mukiꞌa kefo yama nehana yana ali-faloteꞌma nehayana nohavino?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Higeno Yisasiꞌa kenonaꞌa nagola osi kea ohigeno Pailatiꞌa amaꞌyo ai-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kafuꞌahe kafuꞌahe Anumaya Kotiꞌa amaugafama ali-gati-mainea kanahe amakesa haviꞌya imua negiyanagino Pailatiꞌa mukiꞌa ani imu negia kanafina nagoꞌa nofi hu-matageꞌya nemaiya vayapiti vayaꞌyagamoꞌya haesagama huꞌya “Agaya esie.” huꞌya haya kanohe nofipitila “Hai haꞌno hanagi vuo.” huno hu-neꞌatea kanae. ");
INSERT INTO knb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ani kanafina nago kanomo agia Palapasiꞌe vayala tavata nehamaya kanoa kina nofipi maineane. ");
INSERT INTO knb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Maineanagiꞌya vayaꞌyagamoꞌya melitalu hageno Pailatiꞌa mage huno hama-vige “Palapasife ‘Hai haꞌno hanagi vuo.’ huꞌna hisuo ifi nagaya Yisasife, veaꞌmoꞌya ‘Anumaya Kotiꞌa taugafa ali-gatigahema hu-tenea kano maine.’ huꞌya nehaya kanomofe, ‘Hai haꞌno hanagi vuo.’ huꞌna hisue? Tafe musena nehae?” huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Higeꞌya Yisasima atafa huꞌyama avaleꞌya emainaya vayaꞌmoꞌya ma amakesa haviye “Mukiꞌa vayala Yisasina agai ke nehaviꞌya tagai kea nohaviye.” huꞌya nehayanagiꞌya Yisasifena amaipamoꞌa haviya higeꞌya Pailatite avaleꞌya metalaya yafe Pailatiꞌa agesa haviteno hama-vige. ");
INSERT INTO knb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Huteno kaiyeke hu-ma-tesia siale mainegeno aꞌamoꞌa nago kanomofe “Mage huka hapaiyo.” huno hu-tegeno eaꞌamo mage huno hie “Akamoꞌa mage huno hie ‘Namona fatago kanogi afaꞌa atalo. Nagaya meni kegela tusiya huno koli nagesa hia himona agaitela age-mainoe.’ huno higeꞌna me kaha-nepauve.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mono note kava vayaꞌene Yuta vayatamaene mukiꞌa veafe mage huꞌya mo hama-paiye “Mage hutama hiho ‘Yisasina haegeno falino. Tagaya Palapasife nofipitila haꞌno hisie huta nehune.’ hutama hiho.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hageno Pailatiꞌa vayaꞌyagahe nagoꞌene mage huno hie “Tole kanolata mainaꞌagi hana kanohe ‘Hai haꞌno hanagi vuo.’ huꞌna hisue?” huno higeꞌya “Palapasina afaꞌa atalegeno eno.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hageno Pailatiꞌa mage huno hama-vige “Ma kanomofena amakaya ‘Anumaya Kotiꞌa taugafa ali-gatigahema hu-tenea kanoe.’ huꞌya nehaya kanoa naꞌa hu-tesue?” huno hama-vige. Higeꞌya mukiꞌa veaꞌmoꞌya “Yafaga yosale nili hetama asaigeno falino.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hageno Pailatiꞌa mage huno hama-vige “Naꞌa higetama ani kea nehae? Hanaꞌa kefo yama hu-maine?” huno hianagi eteꞌya aliꞌya alapi ataleꞌya ala kefiti mage huꞌya hae “Yafaga yosale nili hetama asaigeno falino.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hageno Pailatiꞌa “Nagai kea ohaviyanagiꞌya tu hugahe nehae.” huno agesa haviteno mage huno hie “Ani fatago kanomo kolamoꞌa nagaipina kumila omalegahigi tamakaitamifi kumitamia hanegahie.” huno nehuno tina alino ani vayaꞌmogami amaule ayana sese hie. ");
INSERT INTO knb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sese higeꞌya mukiꞌa veaꞌmoꞌya mage huꞌya hae “Haesanageno falisia kumiꞌmoꞌa tagayaene nafaꞌnetimoꞌyaene afaꞌa aligahune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hageno Pailatiꞌa Palapasina nofipitila avaleno neꞌataleno Yisasina agata aisifa kaꞌyoteti haifu amiteno Yisasina ati vaya amayapi ateteno “Yafaga yosale nili hetama asaigeno falino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ala kava kanomo ati vayaꞌmoꞌya Yisasina avaleꞌya ala kava kanomo no haupalega umaineꞌya mukiꞌa amakaiꞌenema nemaiya ati vayafe ke hageꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ayaꞌamoꞌya Yisasina kenaꞌa asagi-taleteꞌya akaya ateꞌya “Ala kano mainane.” huꞌya hisaya yafe ayaꞌaya haesa kena fai-tenae. ");
INSERT INTO knb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Fai-teteꞌya avetaꞌnafaꞌage nofiteti tumano kula talo huteꞌya anutela vai-teteꞌya kupaga kaꞌyona tamaga ayapi amiteꞌya amaleꞌya neꞌayeꞌya hu-haviya hu-teteꞌya kigi hu-teꞌya kamuge hatageꞌya vai-neꞌa-teꞌya mage huꞌya hae “Felugae. Yuta veaꞌmogami ala sauve kanomogae.” huꞌya kigi hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Augafale amavetuꞌna he-teteꞌya anutela kupaga kaꞌyoteti aiko-li-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hu-haviya hu-teteꞌya kigi hu-neꞌa-teꞌya haesa kena hate neꞌa-taleteꞌya agaiꞌa kena fai-teteꞌya yafaga yosale nili hegahe avaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yisasina avaleꞌya kategama vayana Sailini Saimoniꞌene mo-fotu huteꞌya ati vayaꞌmoꞌya motafa huꞌya tokiyaꞌage ke huꞌya “Yafaga yosa Yisasi akave kofika vuo.” huꞌya hu-tageno alino vie. ");
INSERT INTO knb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Vigeꞌya Yisasina Kologota kumale, ani agimoꞌa tagai kefina anu ayamufae huꞌya nehaya kumate avaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ani ati vayaꞌmoꞌya “Haesunageno falisiana agata ai yafenagita agatama oꞌaisia tina nesie.” huꞌya nehuꞌya ani atuꞌage timo agia gala. Ani atuꞌage tiꞌene nofi alagamo tiꞌene nagopi ali havigu huteꞌya aliꞌyama amiyana Yisasiꞌa ani lina neno agegeana higeno masu hugeno atalene. ");
INSERT INTO knb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Onegeꞌya yafaga yosale nilia heꞌya asai-maleteꞌya kenaꞌa fako huꞌya aligahe musufa yama nehaya yokalo lageno amakasesaya vayaꞌmoꞌya ali-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aliteꞌya mopale maineꞌya kava yagaiꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Anutela kaiyekema hu-taya kema kaeꞌya malaya avomoꞌa mage huno hie “Mani kanoa Yuta veate ala Sauve kanoe.” huꞌya kaeꞌya malenae. ");
INSERT INTO knb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kae-maleteꞌya Yisasiꞌene tole kanolatana vaya nehamaeꞌana musufa ya nehaꞌa kanolatana nago kanoa tamaga kaiyagaꞌa haeꞌya asai-maleꞌya nago kanoa haoga kaiyagaꞌa haeꞌya asai-maleꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hu-malenageꞌya kateꞌma ute ete huꞌya agasaya veaꞌmoꞌya amakeꞌya kaꞌyo neꞌaiꞌya “Kefo kano maine.” huꞌya kigi yokalofiti hu-haviya hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mage huꞌya hae “Oho kagaya ‘Ala mono nona aliꞌna lagape ai-taleteꞌna tagufa (3) kanale eteꞌna ki-talegahue.’ huka nehana kano mainane? Kagaya Anumaya Koti nafaꞌne mainenukahena menia yafaga yosa ataleka elavika kagaikaꞌa kaugafa aligatio.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hageꞌya mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene Yuta vayatamaene aniꞌa huꞌya kamuge hatageꞌya vai-neꞌateꞌya hu-haviya hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mage huꞌya hae “Nagoꞌa veala amaugafa ali-negatia kanogi agaiꞌa augafa naꞌa higeno ali-nokatie? Isaleli veaꞌmogami Sauve kanoꞌamima mainenunofena yafaga yosaletila ataleno elavinageta agamano. Agesunana ‘Kagaya lamage nehane.’ huta tametitia hugahune. ");
INSERT INTO knb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Agaya Anumaya Kotife ametiti nehuno mage huno hu-maineane ‘Nagaya Anumaya Koti nafaꞌnemoꞌnae.’ huno nehianagino Anumaya Kotiꞌa agaifema hainagenoꞌa menia augafa ali-gatisie.” huꞌya hu-haviya hu-tenae. ");
INSERT INTO knb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Agaiꞌenema musufa kanolatama yafaga yosaleꞌma asai-malaya kanolatamoganienena aniꞌa huꞌana Yisasina hu-haviya hu-tenaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Anile yagemoꞌa euno amuꞌnokaꞌno higeno hale-mainea yamoꞌa haꞌno higeno mukiꞌa kotega tusiꞌa hani-kino viaꞌamo une kanalega eteno ali hale-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Une kanalega Yisasiꞌa ala kefiti ke huno agaiꞌa kefiti mage huno hie “Eli Eli lema sapakatani.” huno hie. Tagaiti kefina mage huno hie “Anumaya Kotiꞌnimogae Anumaya Kotiꞌnimogae naꞌa higeka nagaila nenatalane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Higeꞌya nagoꞌa anile heti-mainaya veaꞌmoꞌya haviteꞌya mage huꞌya hae “Ilaiyafe ke nehie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hageno nago kanomoꞌa aiya-yeno viaꞌamo hava koꞌyafa kana yana alino atuꞌage nofi alagamo tipi ayeteno alino viaꞌamo kupaga kaꞌyote maleno ani hava koꞌyafa kana yana kiteno “Yisasiꞌa mayu mayu huno nesie.” huno amine. ");
INSERT INTO knb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amigeꞌya nagoꞌamoꞌya mage huꞌya hae “Atalo, agava mainesunageno Ilaiyaꞌa esiaꞌamo yafaga yosaletila mevaleno elavisiaꞌamo augafama ali-gatisia yafe esio. Agetetae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hageno Yisasiꞌa nagoꞌene ala kefiti nehuno agu nafaꞌnea atalegeno vigeno fali-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Faligenofena ala mono nopi asai-malenaya kenagefa* ayaꞌaya ala kenagefamoꞌa Yisasiꞌma falia kana kanoꞌale ani kenamoꞌa analeti aepa heno tavigeno amuꞌnopiti hatata hu-lole huno mo-talegeno imila aligeno yafaꞌyagamoꞌa aposi-lavi-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Higeꞌya veaꞌma he-vai-ma-tenaya komumoꞌa ai-hagalo higeꞌya kasagoꞌya veala, Anumaya Kotina amakuꞌama amitafa huteꞌya fali-mainaya veala, he-ti-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","He-tigeꞌya ani veala komufitila hetigeno Yisasiꞌa fali-mainefiti he-ti-mainea yupa Yelusalemu vageꞌya mukiꞌa veaꞌmoꞌya amake-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ati vayaꞌene kava kanoene Yisasiteꞌma yagaiꞌya maiya ati vayaꞌmoꞌya imiꞌma alia yaꞌene alu ya alu yama falote hia yana ageteꞌya tusiꞌa amamaꞌyo aigeꞌya mage huꞌya hae “Tamage huno mani kanoa Anumaya Koti nafaꞌne-lafa maine.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nagoꞌa aꞌneyaga Yisasina aya hugahe Kaliliti akave emainaya aꞌneyaga aluꞌale hetiꞌya maineꞌya age-mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nagoꞌamogami amakia osi Yemesiꞌene Yosefegani itaꞌanimoꞌa Maliaꞌe Magatala kumate Maliaꞌene tole Sepeti nafaꞌnelatamaꞌamogani itaꞌanimoꞌene anifina mainae. ");
INSERT INTO knb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Yagemoꞌa tavi falegahe higeno Yosefeꞌa Alimatia kumate kanoa, ala moneꞌa hanea kanoa Yisasi ke havino akave nemalea kanogino Pailatite mage huno me havige “Yisasina augafaꞌa aligahe nehue.” huno havigegeno Pailatiꞌa “E” higeno ati vayaꞌahe “Yisasi augafa aliꞌya Yosefena amiho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hapaigeno Yosefeꞌa augafa alino me-maleneno kenaleti aigalaki kalaki huno haꞌya kino anoꞌvai-tene. ");
INSERT INTO knb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Anoꞌvai-teteno alino alino viaꞌamo agaiꞌma he-vai-tesaya yafe higeꞌya he falegeꞌya kafi-malenaya yafakapi Yisasina mo he-vai-tene. He-vai-teteno ani yafa kamo avayaleꞌma ai-lilesia yafana, ala yafakefa ayetu-feno anile mo ai-lile-maleteno umaine. ");
INSERT INTO knb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Vigeꞌana Magatala Maliaꞌene hamoꞌamoꞌene anile mopale maineꞌana he-vai-tea yafa kana age-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Sapati kanahe haviꞌya kavela talo tala hu-maleꞌya faeteꞌya kotigeꞌya ala mono note kava vayaꞌene Falasia vayaꞌene ala kanoa Pailatite mage huꞌya me hae “Ala kanomogae tagaya ago havune anima havigeꞌage kanomoꞌa afaꞌama mainea kanafina mage huno taha-pai-maine ‘Nagaya tagufa (3) kanale maiteꞌna komufitila he-tigahue.’ huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nage hu-maineafe kagaya tokiyaꞌage ke hugeꞌya ani yafa kamona ai-lileꞌya tokiya vai-malesageno tagufa (3) kanafina tokiyaꞌage huꞌya yagaisae. Havigu agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ani komufiti Yisasi augafa musufaya huꞌya aliꞌya uteꞌya veafe ‘Fali-mainefitila agaiꞌa he-tino umaine.’ huꞌya hama-paisageno ani kema hisaya kemoꞌa hagoteno hu-mainea kemona agasegahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hageno Pailatiꞌa mage huno hie “Kava yagaisaya ati vayala tamamisugetama ani komule amavaletama moma-tesageꞌya yagai-lama hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Higeꞌya vayaꞌyamoꞌya ani yafa kateꞌma malenaya yafana fukiteti aye-gaꞌmaeꞌya ai-lileteꞌya nagoꞌa ati vayafe “Yagaiho.” huꞌya hu-ma-tenae. ");
INSERT INTO knb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sapati kanamoꞌa haꞌno hu-tegeno Sota yupa kola otinegeꞌya Magatala Maliaꞌene hamoꞌamoꞌene he-vai-taya komulega agegahe umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Neꞌvaꞌageno tusiꞌa imi aligeno Anumayamo ensole kanoa ikapinagati elavino ani yafakefa ayetu-fe-neꞌataleno agupile mopale maine. ");
INSERT INTO knb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mainegeno augosamoꞌa aulumayaꞌma alia kava huno aye-vasa higeno kenaꞌamoꞌa efeꞌage huno alave alave hu-maine. ");
INSERT INTO knb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Higeꞌya he-vai-taya yafakateꞌma yagaiꞌya maiya ati vayaꞌmoꞌya ani ensole kanoa ageteꞌya atili huꞌya amakoꞌya faiteꞌya fali-mainaya vaya kana hu-mainae. ");
INSERT INTO knb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hageno ensole kanomoꞌa ani atalafena mage huno hie “Tanakaila tanamaꞌyoa oꞌaino. Nagaya ago havimainoe tanakaya Yisasina, yafaga yosale nilima heꞌya asai-malenaya kanohe ati-neꞌayaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mafina omainegi fali-mainefitila ago heti-maine. Tamaha-pai-mainea kemoꞌa falote higeno ago he-ti-mainegi etana malenaya kumala ma hanegi megeꞌo. ");
INSERT INTO knb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Megetetana tanaiyayetana agaiꞌaenema tokaeꞌya nemaiya anagala mage hutana mo hama-paiꞌo ‘Yisasiꞌa ofalino afaꞌama maineno tamaha-pai-mainea kea haviho. Uhagotela-mateno Kalili ago umainegi anilega neꞌutama Yisasina mogeho.’ hutana hiꞌo. Hai tanaha-pauve.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Higeꞌana tolemogania anamaꞌyoa neꞌaiꞌana musena nehuꞌana anaiyayeꞌana agaiꞌaenema tokaeꞌya nemaiya anaga mo hama-paigahe umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Neꞌvaꞌageno anile aupaꞌa Yisasiꞌene fotu mo haꞌageno Yisasiꞌa mage huno hanapaiye “Neꞌaꞌo?” huno higeꞌana eꞌana aiyale metafa huꞌana ali soso haꞌe. ");
INSERT INTO knb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Haꞌageno Yisasiꞌa mage huno hie “Tanamaꞌyoa oꞌaitana mage hutana nafuꞌnaganagamina mo hama-paiꞌo ‘Kalili neꞌutama anilega mo nagegahae.’ hutana hama-paiꞌo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tole atalana yaufa neꞌvaꞌageꞌya nagoꞌa komuleꞌma yagai-maiya ati vayala ala kumate uꞌya ala mono note kava vayafena mukiꞌa yama faloteꞌma hia yafena mo hama-paiye. ");
INSERT INTO knb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mo hageꞌya ala mono note kava vayaꞌene Yuta vayatamaene melitalu huꞌya huge havige huteꞌya hu-haꞌya kiteꞌya ani ati vayaꞌmogamina ala mone hageꞌya neꞌamamiꞌya “Mani kea hutama falote ohisaya yafe ma monea negeno haꞌno hino.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Huteꞌya mage huꞌya hae “Tamakaya veafena mage hutama hiho ‘Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya kege ayaꞌamoꞌya faeta mainonageꞌya augafa musufaya huꞌya aliꞌya vae.’ hutama hiho. ");
INSERT INTO knb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ala kamani kanomoꞌa mani kema haya kea haviteno kema tamama-kisiana tagaya ali fala-ki-lama-teta ‘Amakaipina kea omale.’ huta alu kema hapaisunanagenoꞌa kea-otamama-kigahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hageꞌya ati vayaꞌmoꞌya ani monea aliteꞌya ma ma hama-paiya kemo akave malageno mukiꞌa Yuta vea mainalega mani kemoꞌa ute ete huno menia aniꞌa huno hane. ");
INSERT INTO knb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yisasina aleveniꞌa (11) anagaꞌmoꞌya Kalili agoꞌyalega umainae. ");
INSERT INTO knb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Valegati Yisasina mogeteꞌya agia alisaga hayanagi nagoꞌamoꞌya tole amakesa havimainae. ");
INSERT INTO knb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","19","Yisasiꞌa ani vaya mainale emaineno mage huno hie “Anumaya Kotiꞌa ikategaene mopafiꞌene tusiꞌa kava yagaisua tokiya yana ago namiafe tamakaya mukiꞌa ma mopaene mopaene neꞌutama nagai kea hama-paigeꞌya amakuꞌa namisagetamahena Nenafa agileꞌene nafaꞌneꞌamoni nagileꞌene Alu Aotage Avamumo agileꞌene tina fale-ma-teho. ");
INSERT INTO knb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tina fale-ma-tetama nagayama tamaha-pai-mainoa kea ‘Akave maleho.’ hutama huge hama-velige hiho. Tamage nagaya tamakaiꞌene mukiꞌa kanafina maime maime neꞌvisugeno ma mopama haꞌno hisia kanamoꞌa falote hugahianagiꞌna otama-talegahue.” huno Yisasiꞌa hu-maine.");
INSERT INTO knb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yisasi Kalaisiꞌa Anumaya Kotina neꞌamofena kanale kea mage huno aepa hie. ");
INSERT INTO knb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anumaya Koti aune kanoa Aisaiyaꞌa mage huno kaemaleneane Anumaya Kotiꞌa mage huno hie “Haviho ke hamapaisia kanoꞌnia Yisasi aulega hagoteꞌna hutesugeno kana valino hilato hugahie. ");
INSERT INTO knb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kaꞌme kotegati nago kanomoꞌa keha keha huno mage hugahie “Anumayamo esia kana ali hilato hutama fatago hiho.” huno humaineane. ");
INSERT INTO knb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoniꞌa ti faleneꞌamatea kanoa evaꞌyi huno kaꞌme kotega maineno mage huno hie “Tamakaya tamakuꞌa aiyahae hutama kefo yatamia ‘Nagoꞌene ohugahune.’ hutama ataletesageꞌna tina falelamatesugeno Anumaya Kotiꞌa kefo yatamia aigetamateno atalelamategahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ani yupa Yelusalemu veaꞌene Yutia kotega veaꞌene Yoni mainelega umaineꞌya kefo yaꞌamihena hufalote hageno Yoniꞌa Yotani lipi tina falematene. ");
INSERT INTO knb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoniꞌa kemolu afumo ayolagefaleti kenaꞌa fakaꞌnino failineno amuꞌnofila pulamakamo augafaleti ayetalako huno kilineno kaveꞌa kenuꞌene tumemo timaꞌaene neneane. ");
INSERT INTO knb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mage huno hamapaiye “Nakavela nago kanoa ago egahie. Ani kanoa tusiꞌa tokiya yamaꞌa hanea kanogino nagaila ago nagaseno maigeꞌna nagaya afa kano mainoanagiꞌna agai aiyale ayesuana onategahie. ");
INSERT INTO knb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nagaya titeti falenelamatoanagino ani kanomoꞌa Anumaya Kotina Alu Aotage Avamuꞌaleti falelamategahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ani kanafina Yisasiꞌa Kalili kotega hanea kumala Nasaleti kumateti egeno Yoniꞌa Yisasina Yotani lipi tina faletene. ");
INSERT INTO knb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tina faleneꞌategeno Yisasiꞌa tipinagati aivati huno aupaꞌa ageana ikamoꞌa aihagalo higeno Anumaya Koti Alu Aotage Avamuꞌmoꞌa nama kana huno agaitega elavimaine. ");
INSERT INTO knb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Elavigeno ikapinagati nagola agea aino mage huno hie “Kagaya nagaiꞌni nafaꞌnemoga kagaifena aluya huno nahau nayamopafi nenagea neꞌnimoga kagaifena aluya huꞌna musekaꞌa nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Anumaya Kotina Alu Aotage Avamuꞌamoꞌa Yisasina veaꞌne omai kaꞌme kotega anatino umaine. ");
INSERT INTO knb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Umainegeno Sataniꞌa* Yisasife “Havi kava huo.” huno ayevataga higeno fotiꞌa (40) yupa Yisasiꞌa ani kotega afela afuyagaene mainegeꞌya ensole anagaꞌmoꞌya meya huꞌya kava hutenae. ");
INSERT INTO knb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yonina nofi hutenageno Yisasiꞌa Kalili kotega Anumaya Koti kanale kea mo hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yisasiꞌa mage huno hie “Anumayamo malenea kanamoꞌa ago evaꞌyi humainegi Anumaya Koti yagailamatesia kanamoꞌa aupaꞌa evaꞌyi hisia yafe tamakaya tamakuꞌa aiyahae hutama kefo yatamia ataletetama nagaifena kanale kea humainea kemoꞌa ‘Tamage humaine.’ hutama tamakupi maletama tamametitia hiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yisasiꞌa Kalili ti kotumo agegayalega neꞌuno Saimonina aganaꞌamoꞌene Etaluꞌene anakeana noyame kuꞌya nehaꞌa kanolana maineꞌana ala kukonogo ti kotupi hagaꞌyu huꞌana nemalaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yisasiꞌa mage huno hanapaiye “Nakave eꞌo. Nakave esaꞌageꞌna noyame kuꞌyama haꞌa kava huꞌna vaya kuꞌya hulanategahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Higeꞌana aupaꞌa kukonogoꞌania neꞌataleꞌana Yisasi akave umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Vaꞌageno Yisasiꞌa nagoꞌene neꞌuno Sepetina netalamaꞌamogania Yemesiꞌene Yoniꞌene tipi kalefi maineꞌana kukonogo nefakaꞌniꞌageno Yisasiꞌa monake. ");
INSERT INTO knb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Anaketeno Yisasiꞌa ke higeꞌana Sepetia neꞌanafaꞌene aliꞌya vayaꞌaene tipi kalefiti neꞌamataleꞌana Yisasina akave vaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kapaneamu kumate taviteꞌya Yisasiꞌa Sapati yupa mono nopi haino Anumaya Koti ke humavelie. ");
INSERT INTO knb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Humaveligenoꞌa agai kemoꞌa toꞌkiya yamaꞌa hanea kanomo ke kana hia yafena tusiꞌa amamaꞌyo aigeꞌya mage hae “Nagoꞌa kahegi kema havilinaya anagaꞌmoꞌya nehaya avamete ke nehie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Anile nago kanoa Kefo Avamuꞌmoꞌa aguꞌafi falemainea kanoa mono nopi emaine. ");
INSERT INTO knb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Emaineno ala kenake huno mage hie “Avo Yisasigae Nasaleti kumate nafaꞌnemoga naꞌa hulategane? Tagaila tahaeka falilategahe emainano? Nagaya kagaifena ago havimainoe kagaya alu aotage kanoa Anumaya Koti hugatenea kano mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Higeno Yisasiꞌa Kefo Avamufena tokiyaꞌage ke huno mage hie “Kea ohuka maiyo. Mani kanoa ataleka agusafinagati vuo.” huno hutene. ");
INSERT INTO knb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Higeno ani Kefo Avamuꞌmoꞌa moyege meyege huteteno kasageke hia kava huteteno alakenake huno agusafiti ataleno hatilavimaine. ");
INSERT INTO knb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vigeꞌya mukiꞌa vayala amamaꞌyo aigeꞌya huge havige huꞌya mage hae “Na kava nehie? Na augafa haekafa ke nehie? Tusiꞌa toꞌkiyaleti anumayaꞌage ke higeꞌya Kefo Avamuꞌmoꞌya agai kea ali hipoꞌya huꞌya hatilaviꞌya vae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hageno Yisasiꞌma humainea avagemoꞌa mukiꞌa Kalili kotega ute ete higeꞌya mukiꞌa veaꞌmoꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yisasiꞌa Yemesiꞌene Yoniꞌene mono nona ataleꞌya anileti Saimonigani Etalugani nopinaga umainae. ");
INSERT INTO knb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Umainageno Saimonina aꞌamona itaꞌamo alekanoa amukonako kali neꞌaligeno Yisasiꞌa uvaꞌyi higeꞌya aupaꞌa ani alekanohe Yisasina hapaimainae. ");
INSERT INTO knb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hapaigeno Yisasiꞌa agaite eno ayate alino hetitegeno amukonako kaliꞌamoꞌa agola kanale hutegeno kavela kaeno amamine. ");
INSERT INTO knb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Unena yagea tavifalegahe higeꞌya veaꞌmoꞌya kasagoꞌya kali veaꞌnea Kefo Avamuꞌmoꞌya amakuꞌafima ali haviya nehia veaꞌnea Yisasite amavaleꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mukiꞌa ani kumate veala fiate elitalu humainae. ");
INSERT INTO knb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yisasiꞌa havigu havagu kali neꞌaliya veaꞌnene ali hilato humateno mukiꞌa Kefo Avamuꞌmola amakuꞌafiti amanatitalegeꞌya Kefo Avamuꞌmoꞌya Yisasina agoꞌma agemainaya yafe Yisasiꞌa mage huno hamapaiye “Mani yafena kea ohiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Natena tani kotigeno Yisasiꞌa hetino ani nona ataleno vaya omai kotega umaineno nunamuna humaine. ");
INSERT INTO knb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Umainegeꞌya Saimoniꞌene nagoꞌa anagaꞌamoꞌyaene agaife aiyaka maeꞌya agaitega uꞌya mage huꞌya mo hae “Mukiꞌa veaꞌmoꞌya kagaifena katineꞌayae.” huꞌya hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hapaigeno Yisasiꞌa mage huno hamapaiye. “Alu kumate kumate vigetao nagaya mono kea mo hamapaigahue. Mono kema hamapaisua yafe nagaya emainoe.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mukiꞌa Kalili kotega viaꞌyamo mono nopi Anumaya Koti kea hamapaino Kefo Avamula veaꞌmogami amakuꞌafiti amanatitalene. ");
INSERT INTO knb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nagola fugitayamo augafa alino haꞌyagino atalako humainea kanomoꞌa Yisasite mepe huno mage huno hapaiye “Kahaisigekasina nagaila ago ali hilato hunatateꞌasine.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Higeno Yisasiꞌa kalagi aiteteno ayana haꞌyo huno augafale avate nehuno mage huno hie “Nahaigeꞌna kaugafamoꞌa menia kanale hino huꞌna nehue.” huno higeno anile aupaꞌa kaliꞌamoꞌa haꞌno hutene. ");
INSERT INTO knb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Haꞌno hutetegeno Yisasiꞌa mage huno hapaiye “Aupaꞌa visanaꞌamoga ali hilato hugatoa yafena nago kanoa haꞌopaika mono nopi kava kanomote uka mukiꞌa veala kalikaꞌama aliꞌna kanale hugatoa kema havinuꞌyahena mono nopi kava kanomoꞌa kaugafa kamota huno kagetesigeka kaugafama ali kanale hugatoa yafena Moseseꞌa ‘Ma yama Anumaya Kotina amio.’ huno humainea yana Anumaya Kotina momio.” huno toꞌkiyaꞌage ke hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hapaiyanagi ani kanomoꞌa viaꞌamo kanaleꞌma hutea avagea alu kumate kumate hamapaigeꞌya kasagoꞌya veaꞌne haviteꞌya “Kalitia alino kanale hulatesie.” huꞌya Yisasite emainae. Aya yafe Yisasiꞌa fufuꞌyate visia kana omalegeno amataleno vaya omai kotega umainegeꞌya alu kumateti kumateti veala Yisasite emainae. ");
INSERT INTO knb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yisasiꞌa aupa kana kanoꞌa maiteno Kapaneamu kumate eteno nomaꞌafi “Emaine.” haya kea veaꞌmoꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Haviteꞌya veaꞌmoꞌya melitalu hageno nomaꞌafiꞌene nosiꞌmekaenena hiya higeꞌya nagoꞌa veala fiategaenena maisaya yana omalegeno Yisasiꞌa Anumaya Koti kanale mono kea hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hamanepaigeꞌya foꞌa (4) vayaꞌmoꞌya nago kanoa aiya aya falimainea kanoa hagifanale avaleꞌya faeteteꞌya Yisasite avaleꞌya ae. ");
INSERT INTO knb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ayana kasagoꞌya vea hiya haya yafe kana omalegeꞌya nogatofulega haiteꞌya Yisasi maineamaꞌaleti hanae yosa alisaga humaleneꞌya ani hagifanale kali kanoa atalageno Yisasina avate elavimaine. ");
INSERT INTO knb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Elavigeno Yisasiꞌa “Ma vayaꞌmoꞌya nagaife haviꞌya amakupi maleꞌya amametiti hae.” agesa haviteno kali kanohe mage hie “Nafaꞌneꞌnimoga nagaya kahanepauve ago aigekateꞌna kefo yakaꞌa atalegatoe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Higeꞌya kahegi kema havilinaya anagaꞌmoꞌya anile mopale emaineꞌya amakaiꞌami amakuꞌafiti mage hae “Naꞌa higeno mani kea nehie? Ma kanomoꞌa Anumaya Kotifena huhaviya huneꞌate. Nagoꞌa vayaꞌmoꞌya aigetateꞌya kefo yatia ataleotategahayanagi Anumaya Kotiꞌa agaiꞌage aigetateno kefo yatia atalelatesia kanoa maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hageno Yisasiꞌa aupaꞌa amakuꞌafinaga haviya kea agupi ago haviteno mage huno hie “Naꞌa higetama mani kea tamaku tamakesafinaga nehaviye? ");
INSERT INTO knb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nagayama huꞌna hisua kea hana kemo kanaꞌagela humaine? ‘Aigekateꞌna kefo yakaꞌa atalenegatoe.’ huꞌna hisua kemoꞌo? Ifi kali kanomofe ‘Hetika hagifanakaꞌa alisaga hulika vuo.’ huꞌna hisua kemoꞌo? ");
INSERT INTO knb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna ma mopale maineꞌna kefo yafe aigetamateꞌna kefo yatamia atalelamatesua tokiyaꞌnia hanea yafema havisaya yafe nago kavala huꞌna tamaveligahue.” nehuno kalima alia kanohena mage huno hie “Hetika hagifanakaꞌa neꞌalika nokalega vuo.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Higeno ani kali kanomoꞌa aupaꞌa mukiꞌa vea amaulagafi hetino hagifanaꞌa neꞌalino hatilavimaine. Hetino via yafe mukiꞌa melitalu huꞌya mainaya veaꞌmoꞌya tusiꞌa amamaꞌyo aigeꞌya Anumaya Koti agia alisaga nehuꞌya mage huꞌya hae “Menia ma yupa noꞌagona tokiyaꞌage yana neꞌagone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yisasiꞌa amataleno Kalili tikotumo agegayalega neꞌvigeꞌya mukiꞌa veaꞌmoꞌya agaitega molitalu hageno Yisasiꞌa humavelie. ");
INSERT INTO knb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Vilegati nago kanoa mogeana ani kanomo agia Livaiꞌe Alafiusi nafaꞌnea mogeanagi Livaiꞌa musufa ya huno vaya amaugafaleti takisi mone aliliteno nehia kanogino opisi nomaꞌale mopale mainegeno Yisasiꞌa ani kanoa mogeteno mage huno hapaiye “Kagaya nakave eno.” huno higeno Livaiꞌa hetino Yisasina akave umaine. ");
INSERT INTO knb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Haenaga Yisasiꞌa Livaina nomaꞌafi kave mo nenegeꞌya mukiꞌa musufaya huꞌya amaugafaleti takisi mone neꞌaliya vayaꞌene nagoꞌa kefo yama nehaya vayaꞌene Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌyaene ani nopina tokaeꞌya maineꞌya kavela nenae. Ani yupa kasagoꞌya vayaꞌmoꞌya Yisasi kea haviteꞌya akave umainae. ");
INSERT INTO knb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yisasiꞌa ani kefo yama nehaya vayaꞌene vaya amaugafaleti takisi miya neꞌaliya vayaꞌene kave nenegeꞌya nagoꞌa kahegi kema havilinaya Falasia vayaꞌmoꞌya mogeteꞌya Yisasiꞌene tokaeꞌya nemaiya anagafe mage huꞌya hae “Naꞌa higeno Yisasiꞌa amaugafaleti takisi monema neꞌaliya vayaꞌene kefo yama nehaya vayaꞌenena kavela nene?” huꞌya hamavigae. ");
INSERT INTO knb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hamavigageno Yisasiꞌa ani kea ago haviteno kenonaꞌamia mage huno hamapaiye “Afaꞌa kalima noꞌaliya veaꞌmoꞌya tota kanalega oꞌugahagi kali veake tota kanalega ugahae. ‘Fatago vea mainone.’ huꞌya nehaya veafe ke hugahe nagaya omenogi kefo yama nehaya veafe ke hugahe emainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nago yupa Yoniꞌene tokaeꞌya nemaiya anagaꞌmoꞌyaene Falasia vayaꞌmoꞌyaene* kave monesiya yafe nagoꞌa vayala Yisasite eꞌya mage huꞌya havigae “Naꞌa higeꞌya Yoniꞌene tokaeꞌya nemaiya anagaꞌene Falasia vayaꞌene kavela mosiꞌya nemaiyanagi kagaiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya kavela nege nege huꞌya nemaiye?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hageno Yisasiꞌa mage huno hie “Nago kanomo aꞌma faiꞌya esageno avaya heno nesia imu kisia yupa vayaꞌamoꞌyaene toꞌkaeꞌyama maisayana ani vayaꞌmoꞌya kavela mosisao? Aꞌao ani kanoa maineanagiꞌya moꞌosigahae. ");
INSERT INTO knb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Moꞌosigahagi haenaga alu kana falote hisigeꞌya kame vayamoꞌya aꞌma alisia kanoa atafa huꞌya amakaipiti avalesageꞌya ani kanafina mainesaya vayaꞌamoꞌya hamau huteteꞌya mosigahae. ");
INSERT INTO knb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nago kanomoꞌa haegafa kena alino atafa kenalela maleno ohatigahie. Maleno hatisiana haegafa kenamoꞌa taga huno ali haviya hugahie. ");
INSERT INTO knb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nago kanomoꞌa haegafa nofi alagamo timaꞌa takino atafa mememo augafa ti keꞌayopina otakigahie. Takisiana ani limoꞌa kaꞌnuka hesigeno ti kena falo huno takilavinageno ani liꞌene keꞌayoꞌene ali haviya hugahie. Haegafa nofi alagamo timaꞌa hefino haegafa meme augafamo ti keꞌayopi takino vaino.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nago Sapati yupa Yisasiꞌene agaiꞌaenema tokaeꞌya nemaiya anagaꞌene atili hoyafi neꞌuꞌya atilia kalemainae. ");
INSERT INTO knb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Negalageꞌya nagoꞌa Falasia vayaꞌmoꞌya ageteꞌya Yisasife mage huꞌya hae “Ago Sapati yupahena nagalu humalenaya kea neꞌatagayae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hageno Yisasiꞌa mage huno hie “Tamakaya Tevitiꞌa agaiꞌma avagi huꞌya vaya vayaꞌene amakategeꞌya humainaya yafena nayoma kaemalenaya kea hapalitama ohavinayanagitama nehao? ");
INSERT INTO knb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Amakategeno Anumaya Koti nopi haino afa vayaꞌmoꞌya onegahae mono note kava vayala* amakaiꞌamige negahae.’ huꞌya nagalu humalenaya kavela Anumaya Koti aulagale malenaya kaihame maya Tevitiꞌa neneno tokaeꞌya umainaya vayaꞌaene amamigeꞌya nemainae.” huno humaine. Ani kanafina Apiataꞌa ala mono note uhagote mainea kava kano mainea kanafine. ");
INSERT INTO knb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yisasiꞌa Falasia vayafe mage huno hamapaiye “Vayaꞌmoꞌya maifalu hisaya kana Anumaya Kotiꞌa Sapati kana talo humalenegi veaꞌmoꞌya ani kanamona atafa hisaya yafe veala talo ohune. ");
INSERT INTO knb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna Sapati kanamona kava yagaimainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yisasiꞌa nago yupa mono nopi haino mainegeno nago kanoa ayamo falimainea kanoa anile maine. ");
INSERT INTO knb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mainegeꞌya nagoꞌa vayaꞌmoꞌya Yisasiꞌma havi kavaꞌma hisiafene huꞌya amata huꞌya mainageno “Yisasiꞌa Sapati yupa ani kali kanoa alino kanale hutesio.” huꞌya Yisasina amata huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Amata huꞌya mainageno Yisasiꞌa ayama falimainea kanomofe mage huno hapaiye “Hetika vaya amuꞌnopi me hetio.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hapaiteno Yisasiꞌa amata huꞌya maiya vayafena mage huno hie “Tamahavigoe Sapati yupama hisaya yafena mono kemoꞌa naꞌane humaine? Sapati yupa vayala aliꞌya kanale humategahao ifi ali haviya humategahae? Sapati yupa veala amavaleꞌya avina me matesao ifi veala tavata hamaegahae?” huno hamavigegeꞌya kea ohuꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kea ohuꞌya maigeno Yisasiꞌa mukiꞌa vaya amaulagafi moge mege hiana mukiꞌamogami amakuꞌmoꞌa atalako hia yafe aipamoꞌa kana higeno kali kanomofe mage huno hapaiye “Kayana aipi huo.” huno higeno aipi hiana ayamoꞌa kanale hutene. ");
INSERT INTO knb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kanaleꞌma hutea yafena Falasia vayaꞌmoꞌya mono nona neꞌataleꞌya Heloti vayaꞌene alitalu huꞌya huge havige huteꞌya “Yisasina hanaꞌa huta haesunageno falisie.” huꞌya vege humainae. ");
INSERT INTO knb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yisasiꞌene agaiꞌaenema tokaeꞌya nemaiya anagaꞌaene Kalili ti kotumo agegaya neꞌvageꞌya kasagoꞌya veaꞌne Kaliliti akave vae. Yutiatiꞌene Yelusalemutiꞌene Itumeatiꞌene Yotani tifaligati veaꞌnene Taiyatiꞌene Saitonitiꞌene mukiꞌa veala Yisasiꞌma hia avageꞌa haviteꞌya agaitega vae. ");
INSERT INTO knb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Neꞌvageno agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hamapaiye “Mukiꞌa alitalu haya veaꞌmoꞌya nagaila ayenatunefayafe tipi kalea talo tala hunateho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kasagoꞌya veala kaliꞌamia alino kanale humatea yafe mukiꞌa kali veaꞌmoꞌya Yisasi augafale avate hugahe ayetufeliꞌya vae. ");
INSERT INTO knb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Neꞌvageꞌya Kefo Avamuꞌmoꞌya vea amakusafi maineꞌya ageteꞌya Yisasina aulegati mopafi amakoꞌya meyeꞌya ala kenake huꞌya mage hae “Kagaya Anumaya Kotina nafaꞌneꞌamoga mainane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hageno Yisasiꞌa tokiyaꞌage ke huno mage hie “Ani kea nagoꞌa veala hamaopaiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yisasiꞌa agoꞌyafi haiteno haiya vayafe ke higeꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ageno ani vayapiti tuelufuꞌa (12) vaya hapalimateteno agaiꞌaenema tokaeꞌya maisaya yafeꞌene agai kema huhaleꞌya hisaya yafeꞌene hapalimatene. Hapaliteno tokiyaꞌa neꞌamamino Kefo Avamula veaꞌmogami amakusafiti amanatitalesaya yafeꞌene hapalimatene. Mage huno hamapaiye “Nagai kema havigeꞌna hulamatoa vayala (Aposolo vaya)* maiho.” huno hapalimatene. ");
INSERT INTO knb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ani tuelufuꞌa (12) anagaꞌmogami amakia Saimoniꞌe kanomo agia Yisasiꞌa Pitaꞌe huno malene. ");
INSERT INTO knb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yemesiꞌene aganaꞌamoꞌa Yoniꞌene Sepetina neꞌamogania Yisasiꞌa anakia Poanesiꞌe huno malene. Ani anakimoꞌa tagai kefina monagemoꞌma hia avamete huꞌana tokiyaꞌage ke nehaꞌa kanolatane huno anakia malene. ");
INSERT INTO knb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Etaluꞌe Filipiꞌe Patolomiuꞌe Matiuꞌe Tomasiꞌene Yemesiꞌa Alafiusi nafaꞌnene Tatiusiꞌene Saimonina hamoꞌamoꞌa nago agia Selotiꞌe. ");
INSERT INTO knb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yutasi Isakaliotiꞌa Yisasina haenagaꞌa agesi huno kame vaya amayapi avaleno atesia kanoe. ");
INSERT INTO knb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisasiꞌa nomaꞌalega umainegeꞌya mukiꞌa veala Yisasite elitalu hageno Yisasiꞌaene tokaeꞌya nemaiya anagaꞌene kave negahe haya yapi veala mehiya hageꞌya onenae. ");
INSERT INTO knb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Agaiꞌa konaga afamoꞌamoꞌya haviteꞌya Yisasife “Aifonafo nehie.” huꞌya Yisasina avalegahe emainae. ");
INSERT INTO knb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yelusalemu kumateti kahegi kema havilinaya anagaꞌmoꞌya Yisasife mage huꞌya mehae “Kefo Avamuꞌma kava humainea kanoa Pielesepulimoꞌa agupi maineno tokiya amigeno Kefo Avamula anatineꞌatale.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hageno Yisasiꞌa haviteno “Nagaite eho.” huno ke higeꞌya ageno avame kefiti mage huno hamapaiye “Sataniꞌa hanaꞌa huno Satanina anatitalegahie? ");
INSERT INTO knb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nagoke kotega veaꞌmoꞌya ali fako huꞌya “Alu vea mainone.” huꞌya tuma hisayana ani kotega veaꞌnenena haꞌno hugahae. ");
INSERT INTO knb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nagoke afamoꞌmoꞌya ali fako huꞌya “Alu anaga mainone.” huꞌya tuma hisayana ani afamola haꞌno hugahae. ");
INSERT INTO knb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Haꞌno hugahagi Satani anagaꞌmoꞌya ali fako huꞌya “Alu vaya mainone.” huꞌya hisayana Satani kava yagaisia tokiyaꞌa omalegahianagino haviya huno haꞌno hugahie. ");
INSERT INTO knb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nagola tokiya kanomoꞌa nomaꞌafima yagaino mainesigenoꞌa nago kanomoꞌa musufa yama hugahe vinunoꞌa hagoteno ani tokiya kanomona nofiteti kitalako huteteno afenoꞌyamaꞌa musufa yana hugahie. ");
INSERT INTO knb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Naꞌa humaineafe nagaya tamage huꞌna tamahanepauve veaꞌmoꞌya mukiꞌa alu kefo yama alu kefo yaꞌene huhaviya humate yaꞌene hisayana Anumaya Kotiꞌa aigetamateno kefo yana atalelamategahianagi nagoꞌa veaꞌmo Alu Aotage Avamufema huhaviya hutesayana Anumaya Kotiꞌa aigeoꞌamategahianagi ani kefo yamaꞌa hanege hanege huno hanegahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Higeꞌya “Kefo Avamuꞌmoꞌa Yisasiꞌna agupi maine.” huꞌya haya kehe Yisasiꞌa ani kea huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yisasina itaꞌamoꞌene aganaꞌamoꞌyaene eꞌya kumatega me hetiꞌya maineꞌya nago kanoa hutageno Yisasife ke hie. ");
INSERT INTO knb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ke higeꞌya mukiꞌa veala elitalu huꞌya Yisasina aiyafi mopale maineꞌya agaife mage huꞌya hae “Itakamoꞌene kaganakamoꞌyaene kumatega emaineꞌya kagaife ke nehae.” huꞌya hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hapaigeno Yisasiꞌa mage huno hie “Itaꞌnimoꞌene naganaꞌnimoꞌya taꞌya mainae?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hamavigeno agaiꞌenema mopale mainaya veala momake memake huno amaketeno mage huno hie “Itaꞌnimoꞌyaene naganaꞌnimoꞌyaenena ma ma nagaiꞌene mopale mainae. ");
INSERT INTO knb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anumaya Koti kema haviteꞌya haiya kavaꞌma nehaya veala itaꞌnimoꞌya naganaꞌnimoꞌya nasaꞌnimoꞌya mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yisasiꞌa tikotumo agegayalega umaineno nagoꞌene humaveligeꞌya kasagoꞌya veaꞌnea agaite elitalu huꞌya yageꞌyage haya yafe tipi kalefi haisaga humaino mopale maiteno ti amuꞌnopi umainegeꞌya yageꞌyage haya veaꞌmoꞌya ti agegayalega hetiꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Hetiꞌya mainageno Yisasiꞌa alu ke alu kea avame kefiti mage huno hamapaiye “Haviho nago kanomoꞌa avina hanaigahe vie. ");
INSERT INTO knb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Avina yamaꞌa alino aihelafino nehanaigeno nagoꞌa avinamoꞌa kapi tavino hanegeꞌya namayagamoꞌya me neꞌya haꞌno hae. ");
INSERT INTO knb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nagoꞌa avinamoꞌya yafa mopafi taviteꞌya osiꞌa mopa hanea yafe aupaꞌa hagemainae. ");
INSERT INTO knb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hagayanagi yagemoꞌa teno amukonako higeno hafuꞌya omalea yafe fayoteꞌya asagaliye. ");
INSERT INTO knb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nagoꞌa avinamoꞌa avetanafa inomo amuꞌnopi tavino hageteno avetanafa inoꞌene tokaeꞌana haiteteꞌana avetanafa inomoꞌa ayetegeno haviya higeno alagaꞌa falote ohune. ");
INSERT INTO knb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Falote ohunegi nagoꞌa avinamoꞌa kanale mopafi tavino hageteno ala huno alaga ayeana nagoꞌa avinamoꞌa tetiꞌa (30) alaga ayegeno nagoꞌa avinamoꞌa sikisitiꞌa (60) alaga ayegeno nagoꞌa yosalela kasagoꞌya vani hataletiꞌa (100) alaga ayeno vasaimai vasaimai humaine. ");
INSERT INTO knb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tamakesama hanesigetama havilama hutama haviho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mukiꞌa veala utageꞌya agaiꞌa tuelufuꞌa (12) anagaꞌamoꞌyaene nagoꞌa veaꞌene ani avame kemona aepaꞌahe havigae. ");
INSERT INTO knb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Havigageno Yisasiꞌa mage huno hamapaiye “Tamakaila Anumaya Kotiꞌa kava yagailamatenea yafe falakimainea kea Anumaya Kotiꞌa tamaya hinagetama havigahagi nagai kema nohaviya veala avame kekeꞌya hamanepauve. ");
INSERT INTO knb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ani veaꞌmoꞌya ageme geme nehaiyanagi agelama huꞌya oꞌagegahae. Havime havime nehaiyanagi havilama huꞌya ohavigahae. Havilama ohisaya yafe avame kea hamanepauve. Havigu havilama huꞌya amakuꞌa aiyahae hisageno Anumaya Kotiꞌa aigeꞌamateno kefo yaꞌami atalemateyafe nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yisasiꞌa mage huno hie “Mani avame kea havilama ohunao? Mukiꞌa avame kea hanaꞌa hutama havigahae?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Avina yama hanaigahe via kanomoꞌa Yisasife kanale mono kea nefaiye. ");
INSERT INTO knb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nagoꞌa veaꞌmoꞌya kapi tavimainea avinamo avamete mainageno kanale kea faimalegeya maineꞌya Anumaya Koti kea haviyanagi amakupi omalesaya yafe Sataniꞌa amakupitila ani kea melitalene. ");
INSERT INTO knb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aniꞌa huno yafa mopafima tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviꞌya aupaꞌa atafa huteꞌya muse hae. ");
INSERT INTO knb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Muse hayanagi hafuꞌyamoꞌa mopafi otavinea yamoꞌa alige atalege veaꞌne maineꞌya osi kana kanoꞌa osiꞌa haviꞌya amakupi maletageno havi kanama falote nehiano Anumayamo kema haviya yafe veaꞌmoꞌya ali haviya humatesaya kanamoꞌma amakaite falote nehiano aupaꞌa Anumaya Koti kea neꞌatalae. ");
INSERT INTO knb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Nagoꞌa avina avetanafa hanea inomo agusafi tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviteꞌya ma mopafi mukiꞌa yaꞌyagaꞌamihena amakesa haviꞌya moneꞌamima yokaloꞌamihena kalagi aigeꞌya ani yaꞌyagamoꞌa Anumaya Koti kea aliꞌya ayetalako huteꞌya atalageno alaga aye helafino tama nohie. ");
INSERT INTO knb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tama nohianagi kanale mopafima tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviꞌya amakupi malageno ani alaga mukiꞌa aye henelafie. Nagoꞌa veaꞌmoꞌya nagoke avina yosalela tetiꞌa (30) alaga ayemainae. Nagoꞌa veaꞌmoꞌya nagoke avina yosalela sikisitiꞌa (60) alaga ayemainae. Nagoꞌa avina yosalela vani hataletiꞌa (100) alaga ayemainae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hamapaiya yafe Yisasiꞌa mage huno hamavige “Nagoꞌa veaꞌmoꞌya lamua hanagaliꞌya susufaneletila aiso hunemalao ifi sipa kapinaga hanagaliꞌya aiso hunemalae? Aꞌao aihalesia yafe sipale hanagaliꞌya nemalae. ");
INSERT INTO knb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Haenagaꞌa mukiꞌa falakimainesia yamoꞌa efalote hugahie. Mukiꞌa kesi kava nehisaya yamoꞌa efalote hinageꞌya veaꞌmoꞌya agegahae. ");
INSERT INTO knb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tamakesama hanesimogatama havilama hutama haviho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Huteno mage huno hie “Anumaya Koti kema havisaya yafena tamakesa havilama hutama haviho. Havisaya kea akave malesageno nagoꞌa kene tamahapaisigetama havigahae. ");
INSERT INTO knb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Havilama huno havilinesia kanomona Anumaya Kotiꞌa nagoꞌene havisia yana amigahianagi ‘Ago havilinoe.’ huno nehisia kanomona havilinesiamaꞌa hafalegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Yisasiꞌa mage huno hie “Anumaya Koti kava yagaimainea yamoꞌa maꞌa humaine. Nago kanomoꞌa avina yana hoyafi hanaemaleteno kegela mo faeteno feluga hetiteno huge hugeteana ani avinamoꞌa hanaꞌa huno falote huno ala nehia yamona aepaꞌa ani kanomoꞌa oꞌagene. ");
INSERT INTO knb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Oꞌagenegi afaꞌa mopamoꞌa agaiꞌageꞌya nuna amigeno aifalo huno hageteno haisa falote huteno haenaga alaga ayeno afu nele. ");
INSERT INTO knb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Akavi huteno afuma nelea kanamoꞌa ago evaꞌyi hia yafe aupaꞌa viaꞌyamo naepeleti hataga humaine. ");
INSERT INTO knb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisasiꞌa mage huno hie “Anumaya Kotiꞌa kava yagaimainea yamoꞌa hanaꞌa maine? Naꞌane huꞌna maꞌa huno hane huꞌna avame kefitila tamahapaisue? ");
INSERT INTO knb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ma ma osi alagamo hia avamete humaine. Ani alagamo agia masatatie. Ani osi osi alagamoꞌa nagoꞌa yosalagama negaliya yosalagamoꞌa agaseno osi kanoꞌa hane. ");
INSERT INTO knb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Osi osi humaineanagi kalimaletegeno hageno haiteno ala yosagefa haino mukiꞌa hoyafima hanea yosayaga amakaseno ayaꞌaya humainegeꞌya namayagamoꞌya akopatela noꞌamia me negiye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisasiꞌa aniꞌa huno kasagoꞌya avame kea alumo alumo huno amakupima havisaya avamete kea hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yisasiꞌa vayaꞌyagaene maineno mukiꞌa kema hamapaiya kea avame kegeꞌya hamahapaiyanagi agaiꞌaenema tokaeꞌya nemaiya anagala amahaote mainageno hufalote huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ani yupa yagemoꞌa tavifalegahe higeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hie “Tikotumona atu faliga vigetao.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Higeꞌya mukiꞌa elitalu humainaya veala neꞌamataleꞌya tipi kalefi haisaga humaiꞌya Yisasina avaleꞌya vageno nagoꞌa tipi kaleyagamoꞌya agai tipi kalene tokaeꞌya vae. ");
INSERT INTO knb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Neꞌvageno tusiꞌa yasimoꞌa alino timona aikalato kalato huno tipi kalefi atalegeno tipi kalefi havategahe hie. ");
INSERT INTO knb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Havategahe higeno Yisasiꞌa tipi kalemona akavelega tala yosale afita aino faemainegeꞌya agafa huꞌya mage hae “Hulavenelina kanomogae tikotupi asaga hulavita ti nakaita falisunageka kahauna huotategano?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hageno Yisasiꞌa hetino ani limofeꞌene yasimofeꞌenena tokiyaꞌage ke huno “Taga huo.” higeno yasimoꞌene timoꞌenena taga huꞌana alava humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Alava higeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hie “Naꞌa higetama kolia nehae? Nagaife havitama tamakupi maletama tamametiti nehaya yamoꞌa kaleꞌyo humaineo?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hamavigegeꞌya amamaꞌyo aiteꞌya huge havige huꞌya mage hae “Ma kanoa taꞌe? Yasimoꞌene timoꞌene agai kea haviteꞌya akave nemalae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kalili ala tikotuna takaeꞌya ame agegayamona Kelasa* vea mainalega uvaꞌyi hae. ");
INSERT INTO knb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yisasiꞌa ani tipi kalea neꞌataleno ti agegayalega neꞌvigeno nago kanomona Kefo Avamuꞌmo agupi mainea kanomoꞌa matimatipinagati Yisasite emaine. ");
INSERT INTO knb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ani kanoa yafakapinaga nomaꞌa hanegeno anifinaga mainegeꞌya tokiyaꞌage seni nofiteti kitesaya vayala omainae. ");
INSERT INTO knb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vayaꞌmoꞌya seni nofiteti aiya ayaꞌene kisalu kimalenageno ani nofila aigalu heneꞌataleno aiyafi nofila yafateti ailatapegeno nofila aikaꞌno higeno “Ako huka maiyo” huꞌya hapaisaya tokiyaꞌamima hanea vayala omainae. ");
INSERT INTO knb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Omaigeno ani kanomoꞌa nateꞌene kegeꞌene efi efi huno matimatipinagaene agoꞌyaleꞌene maineno tusi aviteno avovo nehuno yafateti agaiꞌa augafa aige talaga talagoma humainea yamoꞌa amumoꞌa tusiya humaine. ");
INSERT INTO knb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ani kanomoꞌa Yisasina ayaꞌayate neꞌegeno ageteno aiyayeno eno aiyafi aleꞌya meyeno mopafi maineno alisoso huneꞌate. ");
INSERT INTO knb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yisasiꞌa mage huno hie “Kefo Avamuꞌmogae agusafinagatila hatilavio.” huno hutea yafe ani kanomoꞌa ala kegefafiti mage huno hie “Yisasigae, ago tagaseno anale mainea Anumaya Kotina neꞌamogae, naꞌa hunategahe nehane? Musekaꞌa nehugi nagata aisia kavala huonato.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Higeno Yisasiꞌa ani kanohena mage huno hie “Kagai kagia tagae?” huno havigegeno “Nagia Kasagoꞌya-moꞌnae. Mukiꞌa Kefo Avamuꞌmoꞌya nagupi haifaleꞌya mainaya yafe nagia Kasagoꞌyamoꞌnae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huteno Yisasifena mage huno hie “Musekaꞌa nehue ma kumatetila Kefo Avamula humatesanageꞌya alulega oꞌvisae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nehigeꞌya kasagoꞌya afuyagamoꞌya agoꞌyafi maineꞌya kave nenae. ");
INSERT INTO knb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nenageꞌya Kefo Avamuꞌmoꞌya Yisasife mage huꞌya havigae “Ani afuyagamo amakuꞌafi hulategeta vamano.” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Havigageno Yisasiꞌa “Aniꞌa hiho.” huno higeꞌya Kefo Avamuꞌmoꞌya ani kanomo agupitila hatilaviꞌya afuyagamogami amakupi haifalageno ani afuyagamoꞌya amaiyayeꞌya nagola aulufi kapi taviteꞌya tipi asaga hulaviꞌya ti nakaiꞌya fali haꞌno humainae. Afua tu tauseniꞌa (2,000) afuyaga fali haꞌno humainae. ");
INSERT INTO knb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Fali haꞌno hageꞌya ani afuyagale kava neꞌyagaiya vayala faleꞌya ala kumatega mainaya veaꞌneheꞌene hoyafinaga mainaya veaꞌneheꞌene “Naꞌa maꞌa higeta neꞌone.” huꞌya hamapaigeꞌya ani veala “Hia yana agesune.” nehuꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yisasite eꞌya kasagoꞌya Kefo Avamuꞌmoꞌma agupifiti hatilavino via kanomona agesa akalo higeno kenaꞌa failino anile mopale mainegeꞌya megeteꞌya koli hae. ");
INSERT INTO knb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yisasiꞌma humainea kavaꞌma agemainaya veaꞌmoꞌya naꞌa maꞌa huno Kefo Avamula agupima mainea kanoa alino kanale hutea yafeꞌene afuyagama humatea yafeꞌene hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hamapaigeꞌya ani veaꞌmoꞌya Yisasifena “Tagaila tataleka ago vuo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","19","Hageno Yisasiꞌa ugahe tipi kalefi haisaga hunemaigeno Kefo Avamuꞌma agupiti ataleno umainea kanomoꞌa Yisasifena “Kagaiꞌene visuꞌe.” huno havigegeno Yisasiꞌa “Aꞌao kagaya nokalega visanaꞌamoga mukiꞌa Anumayamoꞌma aigekateno hugatea yafena vayakamogamina mo hamapaiyo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Higeno ani kanomoꞌa viaꞌyamo teniꞌa (10) ala kumaꞌyaga hanea kotega uno Yisasiꞌma hutea yafena hamapaigeꞌya mukiꞌa veaꞌmoꞌya amamaꞌyoa aimainae. ");
INSERT INTO knb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisasiꞌa tipi kalefi asaga humaino tina lakaeno eteno ti agegayalega egeꞌya muki veaꞌmoꞌya agaite melitalu humainae. ");
INSERT INTO knb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Emainageno nagola soka kanoa, Yailasiꞌe nehaya kanoa, emaineno Yisasina mogeteno aiyafi mope humaine. ");
INSERT INTO knb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mope humaineno tokiyaꞌage huno Yisasina mage huno havige “Vae nagai munala faligahe ayaya neꞌaigi kaya mo maletesanageno kanale hutesie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Higeno Yisasiꞌa agaiꞌene vigeꞌya veala yageꞌyage huꞌya akave umainae. ");
INSERT INTO knb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vageno tuelufuꞌa (12) kafua mukiꞌa kanale aigu nopinaga nemaiya aala anile maine. ");
INSERT INTO knb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nagoꞌa tota vayate ute ete hugeteana agataiya kavala hageno moneꞌama amaminea yamoꞌa haꞌno higeno ani kaliꞌa nago kanomoꞌa ali kanale huoꞌatenegi kaliꞌamoꞌa ala humaine. ");
INSERT INTO knb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ani aꞌmoꞌa Yisasi avagea haviteno ani yageꞌyageꞌma haya veapi Yisasina akavelegati kenaꞌale mevate hie. ");
INSERT INTO knb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Avate nehuno agesa mage huno havie “Kenaꞌale avate nehisugeno kaliꞌnimoꞌa haꞌno hunategahie.” huno agesafinaga havimaine. ");
INSERT INTO knb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Haviteno aniꞌa higeno aupaꞌa kolamoꞌa taꞌnegeno augafafinaga malegeno ageana kaliꞌamoꞌa ago kanale hutene. ");
INSERT INTO knb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kanale huteanagi Yisasiꞌa “Nagoꞌa tokiyaꞌnia ago nataleno vie.” huno agesafinaga haviteno anifima alitalu humainaya veaꞌmogami amuꞌnopi maiyahae huno mage hie “Ta kenaꞌnilela mevate hie?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌamoꞌya mage hae “Mukiꞌa veala yageꞌyage hageka neꞌaganagi naꞌa higeka na kea hamavinegane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hageno Yisasiꞌa moge mege huno avate hia kanohe ati ayemaine. ");
INSERT INTO knb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ati neꞌayegeno ani aꞌmoꞌa kaliꞌa ago kanale hutegeno agea yafe koli huno atili huteno aiyafi mope huno Yisasiꞌma hutea yafena tamage huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hapaigeno Yisasiꞌa mage huno hie “Aꞌmogae nagaifema havika kagupi maleka kametiti hanageno ago kalikaꞌamoꞌa kanale hugategi kaipamoꞌa yasi nehinageka afaꞌa vuo. Kalikaꞌa agola haꞌno hie.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hanepaigeꞌya nagoꞌa vayala soka kanoa, Yailasi notegati mage huꞌya me hapaiye “Munakamoꞌa ago falimainegi ataleka kava kanomona kasalo haegi nagoꞌene havioko.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hageno Yisasiꞌa hapaiya kehena ohavisia agesa haviteno soka kanohena mage huno hie “Kolia ohuka nagaife havika kagupi maleka kametiti huo.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mukiꞌa veafena omeho huneꞌamateno Pitaꞌene Yemesiꞌene nepuꞌamoꞌa Yoniꞌene amavaleno umainae. ");
INSERT INTO knb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Soka kanomo note uvaꞌyi huꞌya agayana mukiꞌa veala tusiꞌa avineꞌatageno Yisasiꞌa nopi haifaleno amakaifena mage huno hie “Naꞌa higetama tusiꞌa avianeꞌatae? Ma munala ofalinegi afaꞌa faeno maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mani kea higeꞌya veaꞌmoꞌya faligeꞌyama agaya yafe kigiꞌa hutageno “Kumatega hatilavitama viho.” huno higeꞌya kumatega hatilavigeno Yisasiꞌa itaꞌafoꞌamoganiene agaiꞌaenema vaya anagaꞌene amavaleno falimainea munaꞌma malalega amavaleno haimaine. ");
INSERT INTO knb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Haino umaineno ayate atafa hulineno agaiꞌa kefiti mage huno hie “Talita kumi.” huno hie. Tagaiti kefina “Ma munaꞌmoga kahanepaugi hetio.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Higeno aupaꞌa ani munaꞌmoꞌa hetino ute ete hie. Ago ala munalagino tuelufuꞌa (12) kafuꞌa hanea munalagino hetino ute ete higeꞌya anile mainaya veaꞌmoꞌya amamaꞌyo aiye. ");
INSERT INTO knb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Amamaꞌyo aigeno Yisasiꞌa tokiyaꞌage ke huno “Anima agaya yafena veala hamaꞌopaiho” huno kahegi neꞌamateno “Kavela amiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisasiꞌa ani kumala ataleno viaꞌamo ko aepaꞌalega vigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya akave umainae. ");
INSERT INTO knb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapati yupa mono noꞌamifi haino Anumaya Koti kea mukiꞌa vayala hamapaigeꞌya haviteꞌya amamaꞌyo aigeꞌya mage huꞌya hae “Mukiꞌa havi haviꞌyana hanateti alia kea nehie? Ayapitila tokiyaꞌage avame yama humainea tokiyaꞌa hanateti alimaine? ");
INSERT INTO knb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mani kanoa no negia aliꞌyate kano maineanagi Malia nafaꞌne mainegi Yemesiꞌene Yoseseꞌene Yutasiꞌene Saimoniꞌenena aganaꞌamoꞌya mainagi asaꞌamoꞌya tagaiꞌene nagopi mainae.” huꞌya huteꞌya amaipa kafa heteꞌya amakaveꞌno hutenae. ");
INSERT INTO knb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Amakaveꞌno hutayanagi Yisasiꞌa mage huno hie “Anumaya Koti kema nehia kanomoꞌa mukiꞌa kumate mono huhaleno hamapaisiana agia alisaga nehagi kumaꞌale maisiana agaiꞌa afamoꞌene no kumaꞌale vayaꞌenena agia alisaga ohugahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mani kumatela ala tokiya avame yana ohunegi afaꞌa nagoke nagoke kali vayake aya malegeno kanale humatene. ");
INSERT INTO knb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kanale humatenegi afaꞌa mukiꞌa veala agaife haviꞌya amakupi maleꞌya amametiti ohaya yafe Yisasiꞌa amaꞌyo aigeno alu kumate kumatela vaiyeno monola hamapaino humaveli maine. ");
INSERT INTO knb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yisasiꞌa tuelufuꞌa (12) anagaꞌamogamife ke higeꞌya ageno mukiꞌa Kefo Avamuꞌma veaꞌmogami amakupiti amanatitalesaya tokiya amamiteno mage hie “Tole ali lokaete lokaete hutama viho.” huno humatene. ");
INSERT INTO knb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Huneꞌamateno mage huno hie “Kama visayana ayopatamige alilitama viho. Kutamiene mayaene monetamiene alitama oꞌviho. ");
INSERT INTO knb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamaiya nona vaigahayanaki tole siota vaioꞌaliho.” ");
INSERT INTO knb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nagoꞌene mage huno hie “Nago nopima haifalenutamahena ani nopi faetama maitama hutetama amataletama alu kumatela viho. Faelitetama ohiho. ");
INSERT INTO knb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nagoꞌa kumateꞌma visageꞌya veaꞌmoꞌya ali falu falama huotamateꞌya ‘Tamakai kema ohavigahune.’ huꞌya hisagetama ani kumala neꞌataletama ‘Havi kava hae.’ hutama hisaya yafe tamaiyafima hanesia kugukege mopa aihehe huneꞌataletama viho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hamapaigeꞌya ani vayala neꞌuꞌya mukiꞌa veaꞌnehe mage huꞌya hae “Kefo yatamihena havitama tamakaye nehinagetama tamakuꞌa aiyahae hiho.” huꞌya hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hamapaiꞌya mukiꞌa Kefo Avamula veaꞌmogami amakupitila amanati neꞌataleꞌya kasagoꞌya kali veala amaugafale masavena falematageno kanale humatene. ");
INSERT INTO knb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ani kanafina Yisasi avagemoꞌa ala higeno nagola sauve kanomo agia Helotiꞌe anima haya kea havimaine. Nagoꞌa veaꞌmoꞌya Yisasifena mage huꞌya hae “Ma kanoa tima falematea Yoniꞌe falimainefiti hetimaine. Hetimaineafe tokiyaꞌa hanegeno ma tokiya aliꞌyana neꞌalie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hageꞌya nagoꞌa veaꞌmoꞌya Yisasifena mage huꞌya hae “Ma kanoa Ilaiya maine.” huꞌya hageꞌya nagoꞌa veaꞌmoꞌya “Aune kanoa nayo amaune vaya kana nehie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hageno Helotiꞌa haviteno mage huno hie “Yonina haeho huꞌna hugeꞌya ageꞌya hataga hutalenaya kanoa faliteno komufiti hetimaine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Helotina aganaꞌamo agia Filipiꞌe. Filipi aꞌmo agia Helotiasiꞌe. Helotiꞌa Helotiasina kumai a alitenea yafe Yoniꞌa Helotife mage huno hie “Anumaya Koti kea atagaeka kaganakamo aala kumai a alitenane.” huno hia yafe Helotiꞌa vayala humategeꞌya Yonina motafa huꞌya avaleꞌya kina nopi hutenayane. ");
INSERT INTO knb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Hutenageno Helotiasiꞌa Yonifena tusi hai vaiteteno haesageno falisia agesa havino maiyanagi Helotiꞌa agesa mage huno havimaine “Yoniꞌa kefo yana ohuno fatago kanoa alu aotage kano maine.” huno havilinea yafe Yonifena koli huno “Ohaegahae.” huno auꞌneꞌvaino agai kea haviteno agesa kuꞌmo nehuno tole agesa havino afaꞌa muse huno keꞌa nehaviane. ");
INSERT INTO knb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nago yupa Helotina atenea kanamoꞌa falote higeno Helotiꞌa ala imu kimaleteno mukiꞌa kamani kava vayaꞌene ati kava vayaꞌene Kalili kotegama afenomaꞌa kasago humainea vayaꞌyagaene ke higeꞌya imulega emainae. ");
INSERT INTO knb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Emainageno Helotiasina munaꞌamoꞌa eno amoneꞌayegeno Helotiꞌene vayaꞌamoꞌyaene neꞌageꞌya tusiꞌa musemaꞌa hageno Helotiꞌa ani munaꞌmofena mage huno hie “Kahaisia yafena afaꞌa hisanageꞌna kamigahue. ");
INSERT INTO knb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Anumaya Koti aulagafi kahanepauve nagoꞌa yafema nahavigesanana afaꞌa kamigahue. Mone fenoꞌenefema nehuka mopaenefema hisanana afaꞌa nagai yaꞌyaga haneanagiꞌna amuꞌnopiti ali fako huꞌna kamigahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Higeno ani munaꞌmoꞌa viaꞌamo itaꞌamofena mage huno havige “Na kanohe ke huꞌna havigesue?” huno higeno itaꞌamoꞌa mage huno hie “Yoniꞌa ti falemate kanomo ageꞌya fakaliteka anumaꞌa aifakalika me namio huka hapaiyo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Higeno aiyayeno ala sauve kanomotega viaꞌamo mage huno hapaiye “Aupaꞌa ti falemate Yonina ageꞌya fakaliteka anumaꞌa yopafi maleka me namio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Higeno ala sauve kanomoꞌa haviteno aipamoꞌa tusiꞌa kanaꞌage higeno Anumaya Koti aulagafima huno lokiya vaimalea yafeꞌene maiya vayafeꞌene agesa haviteno mage huno hie “Ani munaꞌmo kea he falaꞌokigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Higeno aupa kanoꞌa nago ati kanoꞌa huteno mage huno hapaiye “Yonina ageꞌya mo fakalika anumaꞌa alika eno.” huno higeno kina nopi viaꞌamo Yoni ageꞌya mo fakalitalene. ");
INSERT INTO knb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Fakaliteno anumaꞌa yopafi maleno alino eaꞌamo ani munaꞌmona memigeno itaꞌamona alino amine. ");
INSERT INTO knb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Amigeꞌya Yoniꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya ani kea haviteꞌya uꞌya augafaꞌa moliꞌya yafakapi mo hevaitenae. ");
INSERT INTO knb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposolo vayala Yisasitega eteꞌya mukiꞌa humainaya kavaꞌene humaveliya kene eꞌya me hapaimainae. ");
INSERT INTO knb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Me hanepaigeꞌya mukiꞌa veaꞌmoꞌya agaitega neꞌuꞌya neꞌeꞌya maiꞌya hageno Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya kaveꞌamima nesaya kanaꞌamia omalea yafe Yisasiꞌa mage huno hie “Egeta tagaitige kaꞌme kotega umaifalu hamano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Higeꞌya amakaiꞌamige tipi kalefi haisaga humaiꞌya kaꞌme kotega ugahe umainae. ");
INSERT INTO knb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Vageꞌya mukiꞌa veaꞌmoꞌya amaketeꞌya amaugosafina ago agemainaya vayalegiꞌya kumaꞌamileti mopafi amaiya yeꞌya uhagoteꞌya ani kaꞌme kotega uvaꞌyi humainae. ");
INSERT INTO knb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Uvaꞌyi hageno Yisasiꞌa tipi kalefiti asaga hulavino ageana mukiꞌa veaꞌnea elitalu humaiya veala amaketeno agesa mage huno havie “Ma veaꞌnea sipi sipi kana huꞌya mainayanagi kava yagaisaya vayala omainae.” huno agesama havia yafe kalagi aimateno alu ke alu kea hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Hamanepaigeno yagemoꞌa tavi falegahe higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya agaite eꞌya mage huꞌya hae “Ma kumala vaya omai kuma hanegeno yagemoꞌa tavi falegahe nehiafe ma veala humatesanageꞌya uꞌya nagoꞌa veaꞌmogami hoyafitiꞌene notegatiꞌene nesaya kaveꞌamia mo miya hisae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hageno Yisasiꞌa mage huno hamapaiye “Tamakaya tamakaitami nesaya kavela amamiho.” huno higeꞌya agaifena mage huꞌya hae “Nago kanomoꞌa tu hataletiꞌa (200) kanafi aliꞌya aliteno ani moneleti kosa hesia maya miya ohileꞌasine. Tagaya ani moneleti mo miya hulita ani maya memamisune hunageka nehano?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hageno Yisasiꞌa mage huno hie “Mogeho naꞌmagi maya hane?” huno higeꞌya uꞌya mogayana higeꞌya “Faefuꞌa (5) mayagi tole noyamegi huno hane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hageno Yisasiꞌa mage hie “Mukiꞌamogatama alitalu hute hute hutama kanale apepate mopale maiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Higeꞌya fifitiꞌa (50) veala nagopi alitalu huꞌya maigeꞌya vani hataletiꞌa (100) veala nagopi alitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yisasiꞌa faefuꞌa (5) mayaene tole noyamene aliteno anafinaga agesaga huno neꞌageno Anumaya Kotitega ani kavefe huno muse huteno maya kofa huno agaiꞌaenema tokaeꞌya nemaiya anagala amamigeꞌya aliꞌya fako hutele huꞌya veala neꞌamamigeno tole noyamene kolino mukiꞌa veaꞌma nesayafe amamine. ");
INSERT INTO knb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Amamigeꞌya mukiꞌamoꞌya neꞌya amamu hae. ");
INSERT INTO knb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Amamu higeꞌya atalaya mayaene noyamene atupatapaꞌa alitalu huꞌya kupi aiteꞌya tuelufuꞌa (12) kupi aigeno havatemaine. ");
INSERT INTO knb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ani kaveꞌma nemainaya vayala faefu tauseniꞌa (5,000) vemoꞌya nemainae. ");
INSERT INTO knb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aupaꞌa Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe mage huno hie “Tamakaya nagaila nenataletama hagotetama tipi kalefina haisaga humaitama atu kaiyaga Petesaita kumatega utegeꞌna nagaya veala humatesugeꞌya viho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Viho humategeꞌya utageno Yisasiꞌa Anumayamotega ke huno havigegahe agoꞌyafi haimaine. ");
INSERT INTO knb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Haino mainegeno hanikigeno tipi kalemoꞌa tikotumona amuꞌnopi utegeno Yisasiꞌa agaiꞌage ti agegayale maine. ");
INSERT INTO knb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Maineno ageana amaulegati yasimoꞌa eaꞌamo tipi kalemona meyetu fegeteana oꞌvigeno Yisasiꞌa ageteno kotigahe hia avametega ti kotumona agupile viaꞌamo amakaitela momakasegahe hie. ");
INSERT INTO knb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amakasegahe ti agupile vianagi eneꞌegeꞌya ageteꞌya amakesa mage huꞌya haviye “Hakalo neꞌefi?” nehuꞌya “Avovo.” hae ");
INSERT INTO knb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Avovo huꞌya tusiꞌa koli huteꞌya atali talu hayanagi aupaꞌa amakaifena mage huno hie “Kolia ohutama maiho. Nagaya neꞌogi tokiya vaitama maiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huteno tipi kalefi haino amakaiꞌene nemaiyana yasimoꞌa taga higeꞌya ani vayaꞌmoꞌya tusiꞌa amamaꞌyoge humainae. ");
INSERT INTO knb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yisasiꞌa tokiyaꞌaleti kaveꞌma amaminea yafena amakuꞌamoꞌa haꞌyagino atalako higeꞌya aepaꞌa havilama ohunae. ");
INSERT INTO knb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ti kotuna takaeꞌya Kenesale kotega uvaꞌyi huteꞌya hatilaviꞌyama vayana tipi kalea nofiteti ayetenae. ");
INSERT INTO knb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tipi kalefiti hatilavino neꞌvigeꞌya aupaꞌa veaꞌmoꞌya Yisasina augosafina agemainae. ");
INSERT INTO knb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ageteꞌya note note amaiyayeꞌya ute ete huꞌya kali veala hagifanale amavaleꞌya “Yisasiꞌa ma kumate maine.” huꞌya haya kea haviteꞌya agaite amavaleꞌya etele humainae. ");
INSERT INTO knb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yisasiꞌa vilega osi kumatelo ala kumatelo talapinagao kali veala amavaleꞌya kuma amuꞌnopi momateneꞌya Yisasifena mage huꞌya havigae “Kanale kenakamo atupalela avate hisuno?” huꞌya hateꞌya avate humainaya veala kalimoꞌa kanale humatene. ");
INSERT INTO knb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nagoꞌa Falasia vayaꞌene kahegi kema havilinaya anagaꞌene Yelusalemuti Yisasite emainae. ");
INSERT INTO knb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Emaineꞌya agayana nagoꞌa Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya amayana sese ohuꞌya kavela nenageꞌya amakemainae*. ");
INSERT INTO knb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Falasia vayaꞌagela omainagi mukiꞌa Yuta veaꞌmoꞌyaene amakinagomoꞌya humainaya kava akave maleꞌya amayama seseꞌma ohayana kavela onenagi sese huteꞌyage nenae. ");
INSERT INTO knb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Situatega ugeꞌyama enuꞌya tima ofalesayana onegahagi tina faleteꞌyage amaugafamoꞌa hilato hutegeꞌya kavela nenae. Ani yamaꞌagelomagi nayona vayaꞌmoꞌya kahegi kea tokiyaꞌage huꞌya humainaya kehe haviꞌya masuene yopaene susufanene mukiꞌa sese nehae. ");
INSERT INTO knb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Falasia vayaꞌene kahegi kema havilinaya anagaꞌene Yisasife mage huꞌya me hae “Naꞌa higeꞌya kagaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya taginagomogami kavala neꞌataleꞌya ani kea atagaeꞌya kaveꞌma negahena amayana sese nohae?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hageno Yisasiꞌa kenonaꞌamia mage hie “Tamakaya vagala vaya mainae. Aisaiyaꞌa Anumaya Koti aune kanomoꞌa tamakaifena tamage huno Anumaya Koti autaꞌmafina mage huno humaineane ‘Ani nofi veaꞌmoꞌya amavayaleti huꞌya nagai nagia alisaga nehayanagi amakuꞌamoꞌa alulega hanegeꞌya aniꞌa kavala nehae. ");
INSERT INTO knb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Amakaya ma mopafi veaꞌmogami amavayafiti humainaya kahegi kehe mage humainayane ‘Mani kea Anumaya Koti ke hanegi akave maleho.’ huꞌya humainayanagi nagai nagia alisaga hisaya kavala ohuꞌya afa kava maiꞌya nehae.’ huno kaemaleneane. ");
INSERT INTO knb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anumaya Koti kahegi kea ataletama veaꞌmoꞌya malenaya kea akave nemalae. ");
INSERT INTO knb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Huteno nagoꞌene mage huno hie “Tamakaitami tamakinagomogami kavaꞌma akave nemalaya yafe Anumaya Koti kahegi kea ago atalenae. ");
INSERT INTO knb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseseꞌa mage huno humaineane ‘Tamakaya itatami afotamimogami amakia alisaga nehutama keꞌamia veganokanola ohutama amaiyaꞌafinaga maiho. Nagoꞌa veaꞌmoꞌya itaꞌafoꞌamimogamima kamugema vaimatesayana faligahae.’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Humaineanagi tamakaya mage hutama hae ‘Nago kanomoꞌa itaꞌafoꞌamogani anaya hisia monema hanesigenoꞌa itaꞌafoꞌamoganina anayama ohinunoꞌa mage huno hisie ‘Ani monea Anumaya Kotina amisua yane huꞌna humainoe.’ huno hinunofena itaꞌafoꞌamoganina nagoꞌene anayama ohisiana kanalele.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ani kema haya yafe tamakinagomogami kavala akave malenayafe Anumaya Koti kehena ‘Afa yane.’ hutama mukiꞌa ani kavala nehae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yisasiꞌa kasagoꞌya veala agaite esaya yafe nagoꞌene ke higeꞌya ageno mage huno hie “Tamakaya mani kea havilama hutama haviho. ");
INSERT INTO knb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nagoꞌa nesaya yamoꞌma tamavayafi visia yamoꞌa tamakuꞌafina oniꞌya otamahaugahigi tamakuꞌafitiꞌma hatilavisia yamo ali falote hisigeno tamakuꞌamoꞌa oniꞌyaꞌagela hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huteno neꞌamataleno nopinaga haino mainegeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya Yisasife mage huꞌya hae “Kagaya mani avame kemona aepaꞌa hugeta havimano.” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Havigageno Yisasiꞌa mage huno hie “Tamakaiꞌenena havilama ohutama nehao? Tamakaya ohavinao mukiꞌa yana tamavayafima nesaya yamoꞌa oniꞌya otamahaugahie. ");
INSERT INTO knb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tamavayafi nayaꞌamoꞌa tamakuꞌafina oꞌuno afaꞌa tamaipafike taviteno haenagaꞌa aifayolagafina taviteno afa ya kana nehie.” huno hie. Mani kema hiana mukiꞌa kavela afaꞌa nesaya kavekeꞌya hane huno hie. ");
INSERT INTO knb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Huteno mage huno hie “Nagoꞌa yama tamavayafitiꞌma hatilavisia kemoꞌa tamakuꞌamona alino oniꞌyaꞌage nelamahaiye. ");
INSERT INTO knb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Veaꞌmogati taguꞌafitiꞌma efalote hia yamoꞌa maꞌa huno ali falote nehie kanale ohunea tagu tagesa nehavuna yaꞌene aꞌne munaꞌnene kumai he yaꞌene musufaya hu yaꞌene vaya hamaefali yaꞌene alu kanomo aꞌne amavayu hu yaꞌene alu kanomo yafe age haꞌye hu yaꞌene kefo yaꞌene havige huno savale savala hu yaꞌene age lamahaꞌye nehaya yaꞌene veamogami taipa havita haviya huneꞌamatona yaꞌene veafe havige humate yaꞌene taugafa alita hai yaꞌene kema ohavi yaꞌene taguꞌafitila ali falote nehie. ");
INSERT INTO knb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mukiꞌa ani kefo yama nehaya yana tamakuꞌafiti efalote hia yamo tamakuꞌafina oniꞌyaꞌagela humaine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisasiꞌa ani kumala neꞌataleno Taiya kumaꞌmo kaiyaga umaineno agaiꞌama anileꞌma emainea yafena veaꞌmoꞌya ohavisae huno nago nopi haino maiyanagi afaꞌa agaiꞌa falaꞌokigahie. Veaꞌmoꞌya ago haviye. ");
INSERT INTO knb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aupaꞌa nago aꞌmoꞌa Yisasi avagea haviteno eno aiyafi aleꞌya meyemaine. Ani aꞌmo munaꞌmona agupi Kefo Avamula mainea alagino. ");
INSERT INTO knb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Isaleli vea omainea alagino Kaliki ke nehuno Fonisia nofi ale. Silia kotega alagino munaꞌamona agupi mainea Kefo Avamu* anatitalesie huno aukaꞌya huno havige. ");
INSERT INTO knb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yisasiꞌa mage huno hie “Nafaꞌnemoꞌya hagoteꞌya kavela negahae. Havigu nafaꞌnemogami kavela hamanafaleta kalayagamogami amamisunana haviya hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Higeno ani aꞌmoꞌa mage huno hie “Anumayamogae tamage hananagi nafaꞌnemoꞌya nenageno osi atupaꞌa sipaleti asaga hulavia yana kalamoꞌya yogiꞌya nenae. Kagaya ani kava huka nagaya Isaleli a omainoanagi osiꞌa nahaꞌmao.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Higeno Yisasiꞌa ani afena mage huno hapaiye “Kekaꞌa ago hanageꞌna havuafe nokalega vuo. Kefo Avamuꞌmoꞌa munakamona ago ataleno vie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Higeno nomaꞌalega viaꞌamo mogeana Kefo Avamuꞌmoꞌa ago ataleno vigeno munaꞌamoꞌa kanale huno sipale faemainegeno itaꞌamoꞌa mogemaine. ");
INSERT INTO knb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisasiꞌa Taiya kumala ataleno aiyahae huno Saitoni kumala agaseno viaꞌamo teniꞌa (10) kuma hanelega mogaseno Kalili ti agegayalega uvaꞌyi humaine. ");
INSERT INTO knb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uvaꞌyi higeꞌya veaꞌmoꞌya nagola yuna aifo kanoa Yisasitega avaleꞌya vayana ani aifo kanomoꞌa hagifali ke nehatagegeꞌya Yisasife mage huꞌya hae “Augafale kayateti avate hisane.” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yisasiꞌa ani kanoa neꞌavaleno veala amataleno faitega anakaiꞌanige umaineꞌana aya avoyaleti aifo kanomona agesafi vaiteno avetuꞌna heno ayateti avefuꞌnale avatemalene. ");
INSERT INTO knb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Malegeno anafinaga agesaga huno “Vaeha ausoꞌnio.” huteno agaifena agaiꞌa kefiti mage huno hie “Efata.” huno hie. Tagai kefina “Kagesa akalo hino.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Higeno agesamoꞌa akalo higeno avefuꞌnamoꞌa kanale higeno aikalo huno kea kea hie. ");
INSERT INTO knb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yisasiꞌa mage huno hie “Nagoꞌa veala mani yafena hamaꞌopaiho.” huno kahegi mateanagi ani kea huꞌya atile male huꞌya mukiꞌa veaꞌmogami amakesale mohu mehu humainae. ");
INSERT INTO knb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hageꞌya haviya veaꞌmoꞌya tusiꞌa amamaꞌyo aigeꞌya mage hae “Mukiꞌa yana aligeno kanale kanale nehie. Yuna aifo vayala aya malegeꞌya kea nehaviye. Aifo vayala keꞌamia ali falote huneꞌamamie.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Nago yupa kasagoꞌya veaꞌmoꞌya alitalu huꞌya maiyana nesaya yana omalegeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafe ke higeꞌya ageno mage hie “Mani veala tagufa (3) yupa nagaiꞌene mainageno nesaya kaveꞌamia omalea yafe nahau huneꞌamatoe. ");
INSERT INTO knb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nagoꞌa veala ayaꞌaya kotegati emainagi havigu amatalesugeꞌya katega neꞌvisageno amakatesigeꞌya amaugetunatu huꞌya takatiyafena nonahaiye.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya mage huꞌya hapaiye “Mauna kola vaya omai kolagi hanateti maya alita ani veaꞌnea amamisune?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hageno Yisasiꞌa mage huno hamavige “Tamakaya naꞌmagiꞌa maya hane?” huno higeꞌya mage hae “Tagaipina seveniꞌa (7) mayaꞌage hane.” huꞌya hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hageno Yisasiꞌa muki veafena “Mopale maiho.” huno higeꞌya mopale mainageno Yisasiꞌa ani seveniꞌa (7) maya alino Anumayamotega muse huno havigeteno aposite aposite huteno agaiꞌaenema tokaeꞌya nemaiya anagala amamigeꞌya mukiꞌa veapina vaya kaimainae. ");
INSERT INTO knb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nagoke okasi noyame kanoꞌa hanegeno Yisasiꞌa Anumayamotega ani noyamehe muse huteno “Amamite amamite hiho.” huno higeꞌya vaya kaimainae. ");
INSERT INTO knb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kaigeꞌya mukiꞌa veaꞌnea nageno amamu higeꞌya atalaya maya atupayaga Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya alitalu huteꞌya seveniꞌa (7) kupi aihavatemainae. ");
INSERT INTO knb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ani kaveꞌma naya veneꞌnea fo tauseniꞌa (4,000) vayaꞌmoꞌya nemainae. Netageno Yisasiꞌa humategeꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Utageno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌene tipi kalefi haisaga humaiꞌya Talamanuta kumatega umainae. ");
INSERT INTO knb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falasia vayaꞌmoꞌya Yisasite eꞌya agaiꞌene ke vaiꞌya ayevataga hisaya yafe mage huꞌya hae “Kagaya ikapinagati tokiyaꞌage avame yana hugeta agamano.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hageno Yisasiꞌa aipa havino kanaꞌage huteno mage huno hie “Naꞌa higetama meni kanafima mainaya veaꞌmogatama tokiyaꞌage avame yafena nahavinegae? Tamage tamahapaisua kea haviho meni kanafima mainaya veaꞌmogatamina tokiyaꞌage avame yana tamaveotigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huteno neꞌamataleno tipi kalefi haisaga humaino atu faliga ugahe umaine. ");
INSERT INTO knb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yisasiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya tima lakaeꞌya vayana amakekaniꞌya nagoke maya kanoꞌa aliꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aliꞌya vayanagino Yisasiꞌa mage huno hamapaiye “Tamakaya Falasia vayaꞌene Helotiꞌene amakupima hanea yana agelama ohuneꞌya amavayaleti havigema nehaya yamoꞌa kaihamemo halenegia avamete huno halegino alakefa hisia yafena kaꞌye ho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Higeꞌya ani vayaꞌmoꞌya amakaiꞌamia huge havige nehuꞌya mage hae “Tagaya maya oꞌalita emainona yafe nehie.” huꞌya amakaiꞌamia hae. ");
INSERT INTO knb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hageno Yisasiꞌa ani vayaꞌmoꞌya haya kea ago haviteno mage hie “Naꞌa higetama ‘Kavetia alita omenone.’ hutama tamakaitamia huge havige nehae. Tamakesa havilama hutama ohavinao? Tamakuꞌamoꞌa tilemainegetama nohavio? ");
INSERT INTO knb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Tamaulaga haneanagi agelama nohao? Tamakesa haneanagi havilama nohao? Faefuꞌa (5) maya aliꞌna apositeꞌna faefu tauseniꞌa (5,000) veyagama amaminoa yafena tamakekanitama mainao? Naꞌmagi kupi atupatapa aimalageno havatemaine?” huno hamavigegeꞌya “Tuelufuꞌa (12) kule.” huꞌya hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hageno mage huno hie “Seveniꞌa (7) maya aliꞌna apositeꞌna fo tauseniꞌa (4,000) vaya amamugeꞌya neteꞌya naꞌmagi kupi atupatapa aigeno havatemaine?” huno hamavigegeꞌya “Seveniꞌa (7) kule” huꞌya hapaiye.” ");
INSERT INTO knb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hageno mage huno hie “Naꞌa higetama nohaviye?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Petesaita kumate uvaꞌyi hageꞌya veaꞌmoꞌya nagola aulaga asu humainea kanoa avaleꞌya Yisasite neꞌeꞌya mage huꞌya hae “Musekaꞌa nehunagi augafale avate huo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hageno Yisasiꞌa aulagama asu humai kanoa ayate alino kumala ataleno avaleno malaga viaꞌamo aulagafi avetuꞌna heteno aya nemaleno mage huno havige “Nago yana neꞌagano?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Higeno agesaga huno ageana higeno mage huno hie “Veala neꞌagogeꞌya yosa kana huꞌya vaiyatete nehae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Higeno Yisasiꞌa nagoꞌene aniꞌa huno ayana aulagale malegeno aulagamoꞌa kanale higeno agemaine. Aulaga age haleno muki yana kanaleꞌya huno agemaine. ");
INSERT INTO knb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Agegeno Yisasiꞌa mage huno hie “Ma kumatela oꞌuka eteka nokalega vuo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌene Sisalia Filipai kotega hanea kumate ugahe katega neꞌuno mage huno hamavige “Veaꞌmoꞌya nagaifena taꞌe huꞌya nehae?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hamavigegeꞌya kenonaꞌa mage huꞌya hae “Nagoꞌa veaꞌmoꞌya kagaifena ‘Tima fale neꞌamatea Yoniꞌe.’ huꞌya hageꞌya nagoꞌa veaꞌmoꞌya ‘Ilaiya maine.’ huꞌya hageꞌya nagoꞌa veaꞌmoꞌya ‘Anumaya Kotina aune kanoꞌa maine.’ huꞌya nehae.” huꞌya hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hapaigeno Yisasiꞌa mage huno hamavige “Tamakaya nagaifena taꞌe hutama nehae?” huno hamavigegeno Pitaꞌa kenonaꞌa mage huno hie “Kagaya Kalaisigae Anumaya Kotiꞌa taugafa aligatigane huno hugatenea kano mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Higeno Yisasiꞌa amaumono maleno mage huno hie “Mani kea nagoꞌa veala hamaopaiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ani yupa Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafena haenagama falote hisia yafe aepa heno hamapaino mage huno hie “Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna tusiya huꞌna nagata yana alisugeno Yuta vayatamaene mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene amakaveꞌno hunateꞌya nahaesageꞌna falisugeꞌya komufi hevainatesageno naugafamoꞌa tole yupa maitenageꞌna tagufa kanale falimainesufitila eteꞌna hetigahue.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hufalote huno hamapaigeno Pitaꞌa Yisasina faitega avaleno mage huno mo hapaiye “Kagaya ani kea ohuo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Higeno Yisasiꞌa maiyahae huno nagoꞌa agaiꞌaenema tokaeꞌya nemaiya anagala amaketeno Pitafe keamakino mage huno hie “Sataniga mai halenato kagaya Anumaya Koti havimainea aguꞌagesa kanaleꞌya huka nohavinagi vayaꞌmoꞌya kahapaiya amaku amakesa nehavine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Huteno kasagoꞌya alitalu haya veaꞌnene agaiꞌaenema tokaeꞌya nemaiya anagafeꞌene ke higeꞌya ageno mage huno hamapaiye “Nagoꞌa veaꞌmoꞌya nakave visaya amakesa havinuꞌyahena amaugafama aliꞌya hai yana amakaveꞌno huteteꞌya nagaiꞌma nagata aisigeꞌnama falisua avamete amakesa haviteꞌya yafaga yosa kofiꞌya nakave visae. ");
INSERT INTO knb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nagoꞌa veaꞌmoꞌya hamaimuꞌma hanesigeꞌya mai yaꞌamima atafa hutalako hisagenoꞌa ani yamoꞌa fanane hugahianagi nagoꞌa veaꞌmoꞌya nagaife huꞌya nagai kanale mono kema hamapaisaya yafema mai yaꞌamiene hamaimuꞌamiene atalesagenoꞌa ani mai yaꞌami aligatisigeꞌya agola maigahae. ");
INSERT INTO knb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nago kanomoꞌa mukiꞌa ma mopafi afeno yama alisia yafe faliteno agola maige maige hisia haimuꞌa atalesiana alimainea mone afeno yamoꞌa hanaꞌa huno haꞌmaegahie? Aꞌao haꞌomaegahie ");
INSERT INTO knb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Falitesigenofena agola maige maige hisia haimula eteno alisia yafe mukiꞌa ma mopafi mone fenoꞌyana afaꞌa atalegahianagi aya ohugahie. ");
INSERT INTO knb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nagoꞌa veaꞌmoꞌya meni kanafina kefo yama nehaya veaꞌnene, Anumaya Koti kema ataleteꞌya alu kate neꞌvaya veaꞌnene, maineꞌya nagai kene nagaiꞌnienefema huꞌya ‘Aoteꞌyamaꞌae.’ hunatesageꞌna nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna esua yupa Nenafana tokiya hale yamaꞌaene alu aotage ensole anagaꞌmoꞌyaene eteꞌna esuana aniꞌa huꞌna ani veaꞌnehena nagaye huꞌna ‘Tamahaoteꞌyatamie.’ huꞌna humategahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisasiꞌa mage huno hamapaiye “Tamage huꞌna tamahanepauve maleꞌma hetiꞌya mainaya veala nagoꞌamogatama ofalinesageno hagoteno Anumaya Koti kava yagaisia yamoꞌa himamu yamaꞌaene efalote hinagetama agetetama haenaga faligahae.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yisasiꞌa sikisiꞌa (6) kana maiteno Pitana Yemesina Yonigamina amavaleno ayaꞌaya agoꞌyafi haiꞌya amakaiꞌamige maineꞌya agayana Yisasi augafamoꞌa alino alu augafa kalimaine. ");
INSERT INTO knb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kenaꞌamoꞌa mopafima mainaya veaꞌmoꞌya sese nehageno efeꞌage nehia avamete ohunegi tusiya huno efeꞌage huno alave alave humaine. ");
INSERT INTO knb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tole kanolatana Moseseꞌene Ilaiyaꞌene evaꞌyi huꞌana Yisasiꞌene kaiyeke nehaꞌageꞌya agemainae. ");
INSERT INTO knb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pitaꞌa Yisasife mage huno hie “Hulavenelina kanomogae tagaya male maunana kanale nehie. Tagaya katega nona tagufa (3) kilamatesune kagaila nagolagi Mosesena nagolagi Ilaiyana nagolagi huta kilamatesune.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tusiya huꞌya kolima haya yafe Pitaꞌa ‘Naꞌane ke hisue?’ huno agesa havigeno mani kea humaine. ");
INSERT INTO knb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ani kea hanepaigeno agola siaꞌmoꞌa evaꞌyi huno melino aiso humategeno ani siapinagati age aino mage huno hie “Mani nafaꞌnea nagai nafaꞌnegi naguꞌafifena nenahaiya nafaꞌnegi agai kea haviho.” huno siapinagati humaine. ");
INSERT INTO knb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Higeꞌya aupaꞌa moge mege huꞌya agayana nagoꞌa vayala omaigeno Yisasiꞌa agaiꞌage mainegeꞌya agemainae. ");
INSERT INTO knb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ageteꞌya agoꞌyafitila enelaviꞌya Yisasiꞌa kahegi maleno mage huno hamapaiye “Manima agaya yafena nagoꞌa veaꞌnea hamaꞌopaiho. Haenagama nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna falimainesufiti hetisua yupa hamapaigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Higeꞌya ani kemo akave maleꞌya hamaꞌopainagi “Falimainesufitila eteꞌna hetigahue.” huno hia kemo aepaꞌahe atiyeꞌya amakaiꞌami huge havige hae. ");
INSERT INTO knb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mage huꞌya Yisasina havigae “Naꞌa higeꞌya kahegi kema havilinaya anagaꞌmoꞌya Ilaiyaꞌa hagoteno etesigeno Anumaya Kotiꞌa hutesigeno taugafa aligatisia kanoa egahie huꞌya humainae?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hageno Yisasiꞌa mage huno hie “Tamage Ilaiyaꞌa hagoteno eno mukiꞌa yana melino talo tala hugahie. Aniꞌa huꞌya nagaifena Anumaya Koti autaꞌmafina kaemalenayane “Ikapinagati emainoa kanoa vayaꞌmo natenea kanomonina amakaveꞌno hunateꞌya ali haviya hunatesageno naugafa nagata aigahie.” huꞌya nagaifena humainayane. ");
INSERT INTO knb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tamahanepauve Ilaiyaꞌa ago egeꞌya Anumaya Koti autaꞌmafina kaemalenaya avamete huꞌya amakaiꞌamia hamaiya avamete agaila havi kavala hutenae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nagoꞌa agaiꞌaenema tokaeꞌya nemaiya anagatega evaꞌyi huꞌya agayana kasagoꞌya veala anile alitalu humainageꞌya kahegi kema havilinaya anagaꞌmoꞌya Yisasiꞌenema tokaeꞌya nemaiya anagaꞌene mo huhaviya me huhaviya huꞌya kea vaiye. ");
INSERT INTO knb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Neꞌvaigeno mukiꞌa veaꞌmoꞌya Yisasina ageteꞌya tusi muse nehuꞌya amaiyayeꞌya moli falu fala hutenae. ");
INSERT INTO knb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yisasiꞌa mage huno hamavige “Naꞌafene hutama mo huhaviya me huhaviya nehae?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Higeno nagola anile maiya kanomoꞌa mage huno hie “Humavenelina kanomogae Kefo Avamuꞌmoꞌa nafaꞌneꞌnimona agupi haimaineno nafaꞌneꞌnimo avayale maihiya humainegeꞌna kagaitega avaleꞌna neꞌoe. ");
INSERT INTO knb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Neꞌogi Kefo Avamuꞌmoꞌa atafa huteno atalegeno takatino faemainegeno agalemoꞌa selu selu nehigeno ave kume neganeno augafamoꞌa apipupapu nehigeꞌna kagaiꞌenema tokaeꞌya nemaiya anagafe ‘Kefo Avamula anatitaleho.’ huꞌna huana ya hugeteꞌya anatioꞌatalenae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Higeno Yisasiꞌa mage huno hie “Ae meni kanafima mainaya veaꞌmogatama nagaifena havitama tamakupina omalenetama tamametitia nohaya veaꞌmogatama naꞌmagi kanafi tamakaiꞌenena mainesugetama havigahae? Ohaviya yafena kasalo nenahae. Naꞌmagi kanafi tamakaiꞌenena kanaleꞌya huꞌna ako huꞌna maisue? Nagaitega avaletama eho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Higeꞌya avaleꞌya ageno Kefo Avamuꞌmoꞌa Yisasina ageteno ani nafaꞌnemona alino kigepagige hia kava huteteno ali takatitalegeno ani nafaꞌnemoꞌa mopafi asaga hulavino kasegase nehigeno agalemoꞌa selu selu humaine. ");
INSERT INTO knb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Higeno Yisasiꞌa nefafena mage huno havige “Naꞌmagi kanafi aniꞌa haumaine?” huno havigegeno nefaꞌa mage huno hie “Osi nafaꞌne mainegeno aniꞌa haumaine. ");
INSERT INTO knb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mukiꞌa kanafina Kefo Avamuꞌmoꞌa ayelakatitalegeno atafiꞌene tipiꞌene haefalisia kava nehigeꞌna kagaya kanale humainenuka kahau hulateka tahaꞌmao.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Higeno Yisasiꞌa mage huno hie “Naꞌa higeka nagaifena kanale humainenuka nahaꞌmao huka nehane? Nagaifema agupi maleno ametiti nehia kanomoꞌa mukiꞌa yana alu ya alu yana afaꞌa hileꞌasinagi.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Higeno aupaꞌa ani nafaꞌnemona nefaꞌa mage huno hie “Nagaya kagaifena nagupi maleꞌna nametiti nehuanagi nagupi maleꞌna nametiti hua yanimoꞌa aupa nehigi alika ayaꞌaya hunato.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hanepaigeꞌya veala tusiya huꞌya amaiyayeꞌya elitalu hageno Yisasiꞌa neꞌamakeno Kefo Avamufena kemakino mage huno hie “Kagaya Kefo Avamuꞌmogae agesama ailileka avaya alilu kimainana Kefo Avamuꞌmogae hai kahapauve agupitila hatilavika vuo. Nagoꞌa kanafina nagoꞌene agupina haiofalo.” huno hutene. ");
INSERT INTO knb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Higeno Kefo Avamuꞌmoꞌa ala kenake nehuno ani nafaꞌnemona tusiya huno alino kigepagige hia kava huteteno hatilavino ataleno vigeno ani nafaꞌnemoꞌa fali vaya kana huno faemainegeꞌya kasagoꞌya veaꞌmoꞌya “Ago falimaine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nehageno Yisasiꞌa ayate alino avalesaga hutegeno hetimaine. ");
INSERT INTO knb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Haenaga Yisasiꞌene nopinaga haino mainegeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya amakaiꞌamige maineꞌya mage huꞌya havigae “Tagaya ya hugetonana ani Kefo Avamula naꞌa higeta anatioꞌatalenone?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hageno Yisasiꞌa mage huno hamapaiye “Maꞌa augafa Kefo Avamula alu yatetila oꞌanatigahagi Anumaya Kotitega ke huta havigesaya yatetike anatigahae.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ani kumala neꞌataleꞌya Kalili kotegama vayana “Veaꞌmoꞌya visua kumafena ohavisae.” huno higeꞌya ako huꞌya falakiꞌya neꞌvageno agaiꞌaenema tokaeꞌya nemaiya anagala Yisasiꞌa mage huno humavenelie “Ikapinagati emainea kanoa vayaꞌmo atenea kanoa agaila atafa huꞌya avaleꞌya vaya amayapi atesageꞌya haesageno faligahie. Faliteno hevaitesageno tole yupa komufi maiteno tagufa (3) kana falimainesifitila hetigahie.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anima hamapaiya kea havilama ohaya yafe koliꞌa huꞌya haviokenae. ");
INSERT INTO knb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapaneamu evaꞌyi huteꞌya Yisasiꞌa nopi haino maineno amakaife mage huno hamavige “Katega naꞌane kea kea hume hume emainae?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Katega neꞌeꞌya ma ke hume emainae “Kagaya ala kano mainapi nagaya kagaseꞌna ala kanoa mainoe?” huꞌya huge havige hume aya kehenagiꞌya kea ohuꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mainageno Yisasiꞌa mopale maineno “Egeꞌna tamahapaino.” huno higeꞌya tuelufuꞌa (12) anagala ageno mage huno hamapaiye “Nago kanomoꞌa ‘Ala kanoma maisue.’ hinunofena haenagalafa maineno mukiꞌa veala kayo kayoꞌma humatesiana ala kano maigahie.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Huteno nagola okasi nafaꞌnea avaleno amuꞌnoꞌamifi hetiteneno avalesaga huno anukilineno mage huno hie “Nagoꞌa veaꞌmoꞌya nagaifema haviꞌya maꞌa augafa osi nafaꞌnema avaleꞌya falu fala hisayana nagaiꞌene navaleꞌya falu fala hunenatae. Nagaiꞌma navaleꞌya falu fala hisayana hunatenea Nenafaꞌene avaleꞌya falu fala huneꞌatae.” ");
INSERT INTO knb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoniꞌa mage huno humaineane “Hulavenelina kanomoga tagaya agonana nago kanomoꞌa kagai kagile Kefo Avamula vea amakusafinagatila anatineꞌatalegeta neꞌageteta takaveꞌma nohia yafe ‘Aniꞌa ohuo.’ huta ‘Aꞌao.’ hutenone.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yisasiꞌa Yonife mage huno hapaiye. “Ani kanoa alitama ‘Aꞌao.’ huoꞌateho. Nagoꞌa veaꞌmoꞌya nagai nagile tokiyaꞌage aliꞌyama alisayana aupaꞌa nagaifena huhaviyana huonategahae. ");
INSERT INTO knb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Veaꞌmoꞌya kamema huotatesayana tagai kanapa maigahae. ");
INSERT INTO knb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tamage tamahanepauve nagoꞌa veaꞌmoꞌya tamakayama Kalaisi nafaꞌnema mainaya yafe yasi tima tamamisagetama nesayana anonaꞌa kanale miya aligahae.” ");
INSERT INTO knb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nagola osi nafaꞌneꞌni, nagaife havino agupi maleno ametiti nehisia nafaꞌnehema nagoꞌa veaꞌmoꞌya ‘Kefo yama huo.’ huꞌya havi kapima avaletesayana tusiꞌa havi kava nehayanagiꞌna tusiꞌa kana ya amamigahue. Ala yafagefaleti ani kanomo ageꞌyafi maleꞌya nofi kiteteꞌya hage lipi hagaꞌyu hutalesayana afa ya kana kana ya haneanagi nagaya tusiꞌa kana ya amamigahue. ");
INSERT INTO knb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Kayamoꞌa ‘Kefo yama huo.’ huno kavaleno havi kapima katesigekahena ani kayana aifakalitalo. Aifakalitalesanana kanale hugahie. Kaugafamoꞌa haviya humainesia kanoma maisanana haꞌno ohisia kahaimula hanesia kano maigane. Havigu tole kaya hanenageka kefo ya hisana kagesa kaminegeka kefo yama humainana yafe kavaleno hani yapi agola tegelege nehia atafi hagaꞌyu hugatalegahie. ");
INSERT INTO knb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kaiyamoꞌa ‘Kefo yama huo.’ huno kavaleno havi kapima katesigekahena ani kaiya aifakalika atalo. Aifakalitalesanana kanale hugahie. Kaugafa haviya humai kano maisanana haꞌno ohu kahaimula hanesia kano maigane. Havigu tole kaiyamoꞌa kefo ya hisana kagesa kaminegeka kefo ya humainana yafe kavaleno hani yapi agola tegelege nehia atafi hagaꞌyu hugatalegahie. ");
INSERT INTO knb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kaulagamoꞌma agea yafema kefo yama hisana kagesa kaminagekahena ani kaulaga ali faꞌyika atalo. Ali faꞌyitalesanana kanale hugahie. Nagoke kaulaga hanesigeno Anumaya Kotiꞌa kava yagaimainea kumatela umaigananagi havigu tole kaulagamoꞌa kefo ya hisana kagesa kaminegeka kefo ya humainana yafe hani yapi tegelege nehia atafi kavaleno hagaꞌyu hugatalegahie. ");
INSERT INTO knb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Anima ata legelege nehia kumapi veaꞌmoꞌya ani atafi mainageno kani kafaꞌamimoꞌa ofalisigeno atamoꞌa asua ohugahie. ");
INSERT INTO knb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hagema kavete falea avamete huno veala mukiꞌamogatamina ataleti falelamategahie. ");
INSERT INTO knb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hagea kanale ya haneanagi hagaꞌageꞌma nehia yamaꞌa haꞌnoma hisiana hanaꞌa hutama hagaꞌageꞌma nehia yamaꞌa ali falote hugahae? Hage kana yana tamakuꞌafi hanesigetama alava hutama nagoke tamaku tamakesale kigi yokalo hutama maiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisasiꞌa ani kola neꞌataleno Yutia kotega viaꞌamo Yotani timoꞌa ame kaiyaga uvaꞌyi huno mainegeꞌya mukiꞌa veala agaite melitalu hageno nehia kava huno nagoꞌene hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hamanepaigeꞌya nagoꞌa Falasia vayaꞌmoꞌya Yisasite eꞌya ase ohisea kema hisiafene huꞌya nagola ayevataga hisaya kea mage huꞌya havigae “Nago kanomoꞌa aꞌama atalesia agesa hisigenoꞌa kahegi kemoꞌa ‘Afaꞌa atalegahie.’ huno humaineo?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hageno Yisasiꞌa kenonaꞌamia mage huno hamavige “Mosese kahegi kemoꞌa ani yafena naꞌane humaine?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Higeꞌya mage huꞌya hae “Moseseꞌa nagola kahegi kefina mage huno tahapaimaine ‘Vemoꞌa aꞌamona avo kaeno neꞌamino hutesigeno haꞌno huno ugahie.’ huno humaineane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hayanagi Yisasiꞌa mage huno hamapaiye “Tamakaya ke ohavitama veganokano haya yafe Moseseꞌa aꞌma atalesaya kea kaemaleneane. ");
INSERT INTO knb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","Kaemaleneanagi Anumaya Koti avopina mage huno humaineane ‘Ehe yupa Anumaya Kotiꞌa vene aꞌene talo humaleneane. Vene aꞌene talo humalenea yafe nago kanomoꞌma itaꞌafoꞌamoganima anataleno aꞌamoꞌene ailokaeno maisiana ani tolemogania nagoke anaugafa kaligaꞌe.’ huno humaineane. Naꞌa humaineafe nagoꞌene tolelatana omaigaꞌagi nagoke anaugafa kaliꞌana maigaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anumaya Kotiꞌa ago alino hagelafimaleneanagino nagola ma mopale kanomoꞌa ani alavelatana mai yaꞌania alino apase oꞌanatesie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mani kea huteno nopinaga haino maineno agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ani kehena havinegae. ");
INSERT INTO knb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Havigageno mage huno hie “Nago kanomoꞌa aꞌama ataleno alu aꞌma aliana ani kanomoꞌa kumai kava huno hagote aꞌamona ali haviya huneꞌate. ");
INSERT INTO knb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nagi nago aꞌmoꞌma anauꞌamoma ataleno alu veleꞌma viana ani aꞌmoꞌa kumai kava nehie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Veaꞌmoꞌya nafaꞌneꞌamia avaleꞌya Yisasite “Aya malese.” huꞌya neꞌageꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya “Naꞌa ohiho.” huꞌya kemamakimainae. ");
INSERT INTO knb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yisasiꞌa kema amamakiya yana ageteno haivaimateno mage huno hie “Nafaꞌneyaga amatalegeꞌya nagaitega eho. Ka heakioꞌamateho. Nafaꞌne avamete maiya veaꞌmoꞌya mage nehae ‘Tagaitige maunana tokiyatia omalegi Anumaya Koti kava yagailatesie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tamagelafa huꞌna tamahanepauve nafaꞌne avamete maisaya veaꞌmoꞌya ‘Tagaitige maunana tokiyatia omaleafe Anumaya Kotiꞌa kava yagailatesie.’ huꞌya ohisayana Anumaya Kotiꞌa kava yagaimainea kumatela oꞌugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huteno Yisasiꞌa ani nafaꞌneyaga amavaleno amanukilineno “Anumaya Kotiꞌa kanale manua tamamisie.” huno amaugafale ayana malene. ");
INSERT INTO knb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yisasiꞌa katega ugahe nehigeno nago kanomoꞌa aiyayeno eaꞌamo aule aleꞌya meyeno mage huno havige “Kagaya kanale ya huka humavenelina kanomogae hanaꞌa huteꞌna agola maige maige hisua nahaimula alisue?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Higeno Yisasiꞌa mage huno hie “Naꞌa higeka nagaifena ‘Kanale kano mainane.’ huka nehane? Anumaya Kotiꞌa agaiꞌage kanale kanoa maine. ");
INSERT INTO knb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kagaya Anumaya Koti kahegi kea havilinane ani kemoꞌa mage huno humaine ‘Vayala haegeno ofalino. Kumai he yana ohuo. Musufa yana ohuo. ‘Ma kanomoꞌa havi kava nehie.’ huka havigehena kena oꞌvalo. Havigea ayevataga huka alu veaꞌmo yana oꞌalio. Itakafokamo kea ‘Kahaoteꞌyakaꞌae.’ ohuo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Higeno ani kanomoꞌa mage huno hie “Hulavenelina kanomogae nagaya nafaꞌnema mainoa kanaleti aepa heꞌna mukiꞌa ani kema hana kea akave nemaloane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Higeno Yisasiꞌa ani kanoa ageana agaifena hau ayamopafima haiya yafena ageteno mage huno hie “Nagoꞌa yafena kosa heꞌokatene. Nago kavaꞌene huo. Mukiꞌa malenana mone afenoꞌyakaꞌa alika fako huka moneꞌamima omalenesia veaꞌnema amamisanagenoꞌa Anumaya Kotiꞌa ikapinaga afenoꞌyana kamigahie. Afenoꞌyakaꞌa fako huka amamite amamite huteka nakave eno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Higeno ani kanomoꞌa ani kea havianagi mone afenomaꞌama kasago humainea yafe oꞌatalesia agesa haviteno augosamoꞌa atili kaegeno aipamoꞌa tusi kanaꞌage higeno ataleno umaine. ");
INSERT INTO knb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Vigeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagala moge mege huno neꞌamakeno mage huno hie “Mukiꞌa mone afenoꞌyaꞌamima hanesia veaꞌmoꞌya kasageke humaiꞌya humaiꞌya Anumaya Kotife ‘Kava yagailato.’ huꞌya hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ani kehena amamaꞌyoa aiyanagi Yisasiꞌa nagoꞌene mage huno hie “Nafaꞌneꞌnimogatama veaꞌmoꞌya kasageke humaiꞌya humaiꞌya Anumaya Kotifena ‘Kava yagailato.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nagola pulumaka kana afumo agia kemolumoꞌa nekaꞌyamo kapima haifalesiana afaꞌa yoꞌyo huno haifalegahianagi mukiꞌa mone afenoꞌyamaꞌa hanesia kanomoꞌa Anumaya Kotifena ‘Kava yagainato.’ huno kasageke huno haifalegahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Haviya anagaꞌmoꞌya tusiꞌa amamaꞌyo aigeꞌya mage huꞌya hae “Naꞌama humainesiana hana veaꞌmogami amaku amame Anumaya Kotiꞌa aligatigahie?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hageno Yisasiꞌa amakeke huno amakemaineno mage huno hie “Veaꞌmogamina tokiyaꞌamia omaleneanagiꞌya ohugahayanagi Anumaya Kotiꞌa mukiꞌa kava hisia tokiyaꞌa haneanagino afaꞌa aligatigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Higeno Pitaꞌa mage huno hie “Havio tagaya mukiꞌa yatia ataleteta kagai kakavela neꞌone.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Higeno Yisasiꞌa mage huno hapaiye “Tamage huꞌna tamahanepauve mukiꞌa veaꞌmoꞌya nagaifema huꞌya nagai kanale mono kema veaꞌmogamima mo hamapaigahena noꞌamiene nepuꞌamiene amasaꞌamiene itaꞌamiene neꞌamafaꞌene nafaꞌneꞌ-amiene mopaꞌamiene amataleꞌya visagenoꞌa Anumaya Kotiꞌa mopale mainaya kanafima atalenesaya noꞌamiene nepuꞌamiene amasaꞌamiene itaꞌamiene nafaꞌneꞌamiene mopaꞌamiene nagoꞌene nagoꞌene ohavunamaꞌa ya aliteꞌya huhaviyama humatesaya yaꞌene aliteꞌyagi haenagaꞌa maige maige hisaya hamaimula amamigahie. ");
INSERT INTO knb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Meni kanafima hagoteꞌya mainaya veala ani kanafina haenagalafa maigahayanagi meni kanafima haenagalafa mainaya veala ani kanafina hagoteꞌya maigahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yelusalemu haigahena katega neꞌuꞌya Yisasiꞌa hagoteno vigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya amamaꞌyo aiꞌya neꞌvageꞌya amakave vaya veaꞌmoꞌya koli nehageno Yisasiꞌa eteno nagoꞌene tuelufuꞌa (12) anagaꞌamogamina amahaote amavaleno momateneno haenagama agaila hutesaya yafena hamanepaiye. ");
INSERT INTO knb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mage huno hie “Haviho tagaya Yelusalemu haisunageꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia natafa huteno mono note kava vayaꞌmogami amayapiꞌene kahegi kema havilinaya anagaꞌmogami amayapiꞌene natesigeꞌya nagaifena ‘Afaꞌa falisie.’ huꞌya Yuta vea omainaya vayaꞌmogami amayapi navaleꞌya nategahae. ");
INSERT INTO knb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Natesageꞌya nagaye hisifa ke hunateꞌya amavetuꞌna henenateꞌya hegi kaꞌyoteti haifu namiteꞌya nahaesageꞌna yafaga yosale faligahue. Falisugeꞌya hevainatetesageꞌna tole yupa komufinaga maiteꞌna tagufa (3) kanale falimainesufitila hetigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepeti nafaꞌnelatana Yemesiꞌene Yoniꞌene Yisasite eꞌana mage huꞌana havigaꞌe “Hulavenelina kanomogae nago yafe kahavigesuꞌageka ani yana hulaꞌato.” huꞌana havigaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Haꞌageno Yisasiꞌa mage huno hanavige “Naꞌa hulanatesue?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Higeꞌana mage huꞌana haꞌe “Tokiya hale yakaꞌafima umaisanagetaꞌa taꞌagaya kavate mainesuꞌageka ‘Nagoꞌmoga tamaga nayatega maiyo.’ huteka ‘Nagoꞌmoga hauga nayatega maiyo.’ huka hulaꞌato.” huꞌana havigemainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Havigaꞌanagi Yisasiꞌa mage huno hanapaiye “Nahavigaꞌa yafena ohavinaꞌe. Falisua yana satuꞌage humainea ti kana humainea ti hanea keꞌayopitila negahugi tanakaya naꞌaleꞌasino onaꞌaleꞌasine? Nagaila falenatesaya yamoꞌa, nagatama aisia yatetila tanakaila ani yateti falelanatesagetanahena afaꞌa aligaꞌo?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Higeꞌana “E, tokiyatiꞌa haneanagitaꞌa aniꞌa hugahuꞌe.” huꞌana haꞌageno Yisasiꞌa mage huno hie “Tamage satuꞌage humainea tina negaꞌanagi falenatesaya yamoꞌa nagatama aisia yateti falelanategahae. ");
INSERT INTO knb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Falelanategahayanagi ala vayaꞌma mainalega tamaga nayategaene hauga nayategaenena siale maisaya yana nagai yana omalegi Anumaya Kotiꞌa agaiꞌa ani yana ago nagoꞌa vayafe huno talo tala huno ali fatago humatene.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Higeꞌya teniꞌa (10) anagaꞌmoꞌya ani kea haviteꞌya Yemesigani Yoniganina amaipa haviꞌya haviya hunatenae. ");
INSERT INTO knb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yisasiꞌa “Nagaitega eho.” huno higeꞌya ageno mage huno hie “Ma mopafi ala kava vayaꞌmoꞌya ‘Tusiꞌa ala vaya mainone.’ huꞌya Yuta vea omainaya veafe ke amamakiꞌya aliꞌya ke humateꞌya kava vayaꞌmo nehaya avamete kava nehae. ");
INSERT INTO knb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Naꞌa nehayanagi tamakaya aniꞌa kavala ohiho. Tamakaipima ‘Nagi hanea kanoma maigahue.’ huno hisia kanomoꞌa aliꞌya kanotami maino. ");
INSERT INTO knb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","‘Uhagoteꞌna maigahue.’ huno hisia kanomoꞌa miya oꞌali aliꞌya kanotami maino. ");
INSERT INTO knb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna veaꞌmoꞌya naya huꞌya ali kanale hunatesaya yafene huꞌna omenogi nagaya amaya huꞌna aliꞌya kanoꞌami maisuafene huꞌna emaineꞌna mukiꞌa veaꞌmoꞌya kefo yama nehaya yamo aigagimatenea yapiti alikalu hematesuafe miya atalesue huꞌna faligahe emainoe.” ");
INSERT INTO knb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌene kasagoꞌya veaꞌnene Yeliko kumate uvaꞌyi huteꞌya ani kumala mogaseꞌya ugahe nehageno nagola aulaga asu humainea kanomo agia Patimeusiꞌa Timeusi nafaꞌnegino ka agegayale mopale maineno monehe aukaꞌya huge huge huno maine. ");
INSERT INTO knb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Nasaleti Yisasiꞌa ago neꞌe” huꞌya haya kea haviteno ke huno mage huno hie “Yisasigae, Tevitina aginagomogae nagaila kahau hunato.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Higeꞌya kasagoꞌya veaꞌmoꞌya kemakiꞌya “Ke ohuka maiyo.” huꞌya hayanagi nagoꞌene ke huno “Tevitina aginagomogae nagaila kahau hunato.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Higeno Yisasiꞌa anile mo hetimaineno mage huno hie “Hapaigeno eno.” huno higeꞌya ani kanohe ke huꞌya mage huꞌya hae “Kaguꞌa ali lokiya vaika aupaꞌa hetio. Kagaife ke nehie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hageno ayaꞌaya yasi kenaꞌa asagi neꞌataleteno aupaꞌa hetino Yisasite vie. ");
INSERT INTO knb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vigeno Yisasiꞌa mage huno hie “Naꞌa hugatesue?” huno higeno aulagama asu humai kanomoꞌa mage huno hie “Humavenelina kanomogae naulaga agesue huꞌna nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Higeno Yisasiꞌa mage huno hapaiye “Afaꞌa vuo nagaifema havika kagupi maleka kametitima hana yateti ago aliꞌna kanale hugatoe.” huno higeno aupaꞌa aulagamoꞌa kanale higeno Yisasi akave umaine. ");
INSERT INTO knb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yelusalemua aupate hanegeꞌya tole osi kumatalana Petafasiene Petaniene hanea kumate umainae. Ani kumatalana Olivi yosa hanea agoꞌyamo agegayalega hane. Anile maineꞌya Yisasiꞌa tole agaiꞌaenema tokaeꞌana nemaiꞌa kanolatana hunateno mage huno hanapaiye “Atu kumate utetana atupa note hosi kana afumo agia tokimo nafaꞌnea ayetenayanagitana agegaꞌe. Ani tokimo nafaꞌnea vayala oꞌamavalenea tokie. Kalu hetana avaletana male eꞌo. ");
INSERT INTO knb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Neꞌeꞌageꞌya nagoꞌa vayaꞌmoꞌya ‘Naꞌa higetana naꞌa kavala nehaꞌe?’ huꞌya hisagetanahena mage hutana hiꞌo ‘Kava kanotimoꞌa nago aliꞌya aligahe higetaꞌa neꞌoꞌanagino aliꞌyamaꞌa aliteno aupaꞌa eteno tamamigahie.’ hutana hamapaiꞌo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Higeꞌana ani kanolatana uꞌana ani tokimo nafaꞌnea no fiate ayetageno ka agegayale hetino mainegeꞌana mogefalote huteꞌana nofila alikalu hemainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nehaꞌageꞌya nagoꞌa anile hetimainaya vayaꞌmoꞌya mage huꞌya hae “Naꞌa higetana tokimo nafaꞌnea kalu nehaꞌe?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hageꞌana Yisasiꞌma “Nage hutana hiꞌo.” hunoꞌma hia kea hamapaiꞌageꞌya ani vayaꞌmoꞌya “Afaꞌa tokia avaletana viꞌo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hageꞌana ani tokimo nafaꞌnea Yisasite avaleꞌana evaꞌyi huteꞌana kenaꞌania anaugafaleti hateꞌana ani afumo agupile yakaimalaꞌageno Yisasiꞌa anile haino maine. ");
INSERT INTO knb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Maigeꞌya mukiꞌa veapiti nagoꞌamoꞌya amaugafaleti kenaꞌamia hateꞌya via katela yakaigeꞌya nagoꞌamoꞌya haisa hanete hanete yosayaga kofanafa huꞌya katela yakaimalageno Yisasiꞌa ani kate afumo agupifina maiteno umaine. ");
INSERT INTO knb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hagoteꞌya vaya veaꞌmoꞌyaene haenagama vaya veaꞌmoꞌyaene ala kenake kefiti mage huꞌya hae “Alamogae taugafa aligatisana kanoa kanaleꞌya huka neꞌane. Anumayamo aliꞌya alisana yafe hugategeka emainana kanomoga Anumaya Kotiꞌa kanale manu kamino kaya humaine. ");
INSERT INTO knb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Taginagomoꞌa Tevitiꞌe nayona kava hunoꞌma yagaimainea avamete kavala eteno aniꞌa huno falote hugahie. Ani yafena muse higetao. Anafinaga Anumaya Kotiꞌa taugafa aligatisia kanohe muse hisune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yisasiꞌa Yelusalemu uvaꞌyi huteno ala mono nopi umaineno mukiꞌa mono nopima hanea yana ako huno ageliteno huno ageteno neꞌataleno hani kisia avamete higeno ataleno tuelufuꞌa (12) anagaꞌaene Petaniga vae. ");
INSERT INTO knb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Faeteꞌya kotigeꞌya Petania ataleꞌya neꞌvageno Yisasina agatemaine. ");
INSERT INTO knb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Agategeno nagola haisa afaꞌa hanea fiki yosamoꞌa aluꞌale hanegeno ageteno alagaꞌahe mogegahe ani yosamo aepale uno mogeana alagaꞌa omalegeno haisayagaꞌage hane. Ani fiki yosamoꞌa alagaꞌama neꞌayea kanamoꞌa yaufa falote ohune. ");
INSERT INTO knb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mogeteno Yisasiꞌa ani yosahena mage huno hie “Namo yosa hetika maiyo. Agola kagai kaugafa veaꞌmoꞌya nagoꞌene onegahae.” huno huhaviya hutegeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ani kea havimainae. ");
INSERT INTO knb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yelusalemu evaꞌyi huteꞌya Yisasiꞌa ala mono nopi haino mone aliꞌya neꞌaliya veaꞌnene afaꞌa miyama nehaya veaꞌnene “Maihaleho.” huno amanatineꞌataleteno nagoꞌa veaꞌmoꞌya alu kotegama nehanea monea neꞌaliꞌya ani kotegama nehanea monea neꞌamamiya veaꞌmogami folomoa alitalegeno aige helafige higeno kugofa kana namama miya nehaya veaꞌmogami sipaꞌamia aniꞌa huno alitalegeno aihelafilavimaine. ");
INSERT INTO knb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Afenoma aliliteꞌya nehaya veafena mage hie “Ala mono no kumapina afenona alitama ute ete ohiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huteno mage huno hamapaiye “Anumaya Kotiꞌma humainea kemoꞌa autaꞌmafina mage huno kaemaleneane ‘Nagai nona mukiꞌa kotega veaꞌmoꞌya Anumaya Koti agi ayeꞌya havigesaya no hane.’ huno kaemaleneanagi tamakaya musufa yama nehaya veaꞌmogami nomo avamete kava hutama falakitama musufa ya hugahe ma mono nopina emainae.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Higeꞌya mono note kava vayaꞌmoꞌyaene kahegi kema havilinaya anagaꞌmoꞌyaene Yisasiꞌma hia ke haviteꞌya muki veaꞌmoꞌya Yisasiꞌma hamapaiya kema haviteꞌya amamaꞌyoma aiya yafe koli huteꞌya “Hanaꞌa huta haesune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hayanagi Yisasiꞌa anagaꞌamoꞌyaene hani kigeꞌya Yelusalemua ataleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yisasiꞌa faeteno natena agaiꞌaenema tokaeꞌya nemaiya anagaꞌaene kate vayana anima alaga oꞌayenea fiki yosa mogayana hafuꞌyayagafiti amagino haisamoꞌa amagiteno fayo temaine. ");
INSERT INTO knb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yisasiꞌa ani yosahema humainea kehena Pita agesamoꞌa hao higeno haviteno Yisasife mage huno hie “Humavenelina kanomogae ago fiki yosama huhaviya hutana yosamoꞌa ago faꞌyotemaine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Higeno Yisasiꞌa mage huno hamapaiye “Anumaya Kotifena mage hutama hiho ‘Kagaya mukiꞌa yana hateꞌasine.’ hutama tamakupi maletama tamametiti hisayana tamage huꞌna tamahanepauve Anumaya Kotifena tole lamakesa ohavitama ‘Havigesua yana falote hugahie.’ hutamama hisagenofena ani yamoꞌa falote hugahie. Ani kavaꞌma hisia kanomoꞌa ma agoꞌyahena ‘Ma agoꞌyamoga kofa hulavika ala tikotumo amuꞌnopi ufaemaiyo.’ huno hapaisigenofena akave maleno aniꞌa hugahie. ");
INSERT INTO knb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ani yafe mage huꞌna tamahanepauve mukiꞌa yafena Anumaya Kotitega havigesayana ‘Anumaya Kotiꞌa kanaleꞌya huno lamigahie.’ hutama tamakesa havisagenofena afaꞌa tamamigahie. ");
INSERT INTO knb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Tamakaya hetitama Anumaya Kotitegama ke hutama havigegahena hagotetama kefo yama hulamatenesaya veafena aigeꞌamatetama kefo yaꞌamia atalematesagenofena ikapinaga mainea Nelamafaꞌa kefo yatamia aigetamateno atalelamategahie. ");
INSERT INTO knb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yelusalemu alehate evaꞌyi hayana Yisasiꞌa ala mono no kumapi ute ete nehigeꞌya mono note kava vayaꞌmoꞌyaene Yuta vayatamaene kahegi kema havilinaya anagaꞌene agaitega evaꞌyi hae. ");
INSERT INTO knb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Evaꞌyi huteꞌya mage huꞌya hae “Hana augafa ala kanomo hugategeka mani kavala me nehane? Himamu yakaꞌa ta kamine?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hageno Yisasiꞌa kenonaꞌamia mage huno hie “Nagaya hagoteꞌna nago yafena tamahavigesugetama nahapaisageꞌna nagaya ani yama talo nehua himamuꞌnima hanea navagea tamahapaigahue. ");
INSERT INTO knb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoniꞌa tima fale neꞌamatea yana Anumaya Koti hutegeno ani kavala me nehifi afa vayaꞌmoꞌya hutageno lina faleneꞌamate? Tamakaya hufalote hutama nahapaiho.” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Higeꞌya “Naꞌa maꞌa hugahune.” huꞌya mohu mehu huteꞌya mage hae “Anumaya Koti hutegeno emaine.” huta hisunagenoꞌa Yisasiꞌa “Naꞌa higetama agai kea havitama tamakupina nomalae?” huno hugahie. ");
INSERT INTO knb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hugahianagita mukiꞌa veaꞌmoꞌya Yonifena “Anumaya Koti aune kano maine.” huꞌya tokiyaꞌage kema nehaya yafe tagaya “Afa vayaꞌmoꞌya hutageno emaine.” huta hisunagenofena kelamakigahie huta koli nehune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kolia nehuꞌya Yisasifena mage huꞌya hae “Tagaya ohavinonanagita hufalote huta kahaꞌopaigahune.” huꞌya hageno Yisasiꞌa mage huno hie “Nahaꞌopaisayana nagayaenena aniꞌa huꞌna hufalote huꞌna ani yama taloma nehua himamuꞌnima hanea navagea tamahaꞌopaigahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisasiꞌa aepa heno avame kea mage huno hamapaiye nago kanomoꞌa vaini* nofi alaga hoya humaleteno kegiꞌya hugove humaleneno ani alagayagamo timaꞌa ayelatisigeno timaꞌamoꞌa tavino umaisia komua kafiteno yagaiꞌyama maisaya nona anafi kimaleteno alu vayafe ke huno “Etama hoyaꞌnile me yagaitama maineho. Ani nofiꞌmo alagafitila aye fako hutama nagoꞌa aliho.” huno humateteno alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Umaineno fuma nelea kanafina ani hoyamona nefaꞌa nagola aliꞌya kanoa hutegeno ani vaini hoyaleꞌma neꞌyagaiya vayatega alaga aligahe umaine. ");
INSERT INTO knb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Vigeꞌya hoyaleꞌma neꞌyagaiya vayaꞌmoꞌya ani aliꞌya kanoꞌamona atafa huꞌya kaꞌyo amiteꞌya mage hae “Okamigahunagi kagaya eteka vuo.” huꞌya hageno eteno umaine. ");
INSERT INTO knb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eteno vigeno hoyamona nefaꞌa alu aliꞌya kanoꞌa hutegeno viana aniꞌa huꞌya atafa huꞌya anu aliteꞌya tusiꞌa agaye hisifa kava hutenae. ");
INSERT INTO knb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hutageno vigeno eteno alu aliꞌya kanoꞌa hutegeno ani hoyafi viana atafa huꞌya hayageno falimaine. Falitegeno hoyamona nefaꞌa kasagoꞌya aliꞌya vayaꞌyaga humategeꞌya vageꞌya nagoꞌa aliꞌya vayala amatafa huꞌya nehamaeꞌya nagoꞌa kuyafa neꞌamataleꞌya nagoꞌa tefa hamae falimainae. ");
INSERT INTO knb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mukiꞌa vageno hau ayamopafima nehaiya nafaꞌneꞌa agaiꞌage maigeno nefaꞌa mage huno hie “Nafaꞌneꞌnimo kea havigahae.” huteno hutegeno haenagalafa ani hoyalega umaine. ");
INSERT INTO knb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Vigeꞌya ani hoyafima yagaimainaya vayaꞌmoꞌya mage huꞌya hae “Mamona mani hoyamona nefa nafaꞌne. Nefaꞌma falisigenofena mani nafaꞌnemoꞌa hoyaꞌa aligahianagita ago haegetao. Haesunageno falisigeta mani hoya tagai ya hapaegahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Huteꞌya atafa huꞌya hayageno faligeꞌya augafaꞌa aliꞌya hoyafinagati ai halatu huꞌya malaga hagaꞌyu hutalenae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Huteno Yisasiꞌa mage huno hamavige “Naꞌa hayanagino hoyamona nefaꞌa hanaꞌa humategahie? Eno hoyaꞌafima yagaimainaya vayala tavata me hamaesigeꞌya faligahae. Fali haꞌno hisageno alu vayafe “Tamakaya hoyalela kava me yagaiho.” huno humategahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nagoꞌene Yisasiꞌa mage huno hie “Manima Anumaya Koti avopima hanea kea ago hapalitama havimainao? Mage huno humaineane ‘Vayaꞌmoꞌya yafa noma kiyana nago yafafena ‘Haviya humaine.’ huꞌya atalayanagi ani yafamoꞌa haenagaꞌa ‘Tusiꞌa kanale yafanagino amakaseno haimainea yafane.’ huꞌya nomo ayetagenale malenae. ");
INSERT INTO knb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anumayamoꞌa aniꞌa humaineanagita neꞌageta tusiꞌa kanale ya hane huta nehune.’ huꞌya kaemalenayane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yisasiꞌa mani kea higeꞌya mono note kava vayaꞌmoꞌya “Mani avame kema hiana tagaife nehie.” huꞌya amakesa haviteꞌya mage hae “Avaleta kina nopi ategahune.” huꞌya hayanagi alitalu humainaya veafe koli huteꞌya Yisasina ataleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nagoꞌa Falasia vayaꞌene nagoꞌa Heloti vayaꞌene humatageꞌya Yisasiꞌma havigaya keleti ayevataga huꞌya atafa huꞌya haegahe Yisasi mainelega umainae. ");
INSERT INTO knb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Umaineꞌya mage huꞌya havigae “Humavenelina kanomogae tagaya ago havunana kagaya tamageꞌage kano mainane. Amakima hanea vayaꞌene amakima omale vayaꞌenefena nagoke katekeꞌya havi neꞌamamika kelamage nehuka Anumaya Koti kea tahanepainane. Takisi monema ataleyatela Sisaꞌa kava kanomotega kanale atalesuno ifi oꞌatalesune? huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hageno Yisasiꞌa amakupinagama haviya kea ago haviteno “Vagala vaya mainetama amegati ke nehae. Naꞌa higetama nagaila ayenavataga hutama natafa hisaya yafena nahavinegae? Nagola alaga monea alitama me namigeꞌna agano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Higeꞌya nagola alaga monea aliꞌya memigeno ageteno mage huno hamavige “Mani alaga monelela ta augosaene ta agiene hane?” huno hamavigegeꞌya “Sisa augosaene agiene hane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hageno Yisasiꞌa mage hie “Sisana agaiꞌa yana agaila amiho. Nagi Anumaya Kotina agaiꞌa yana agaila amiho.” huno higeꞌya ani kehena amamaꞌyo aimaine. ");
INSERT INTO knb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nagoꞌa Satiusi vayaꞌmoꞌya* Yisasitega emainae. Ani vayaꞌmoꞌya mage nehaya vayale “Falimainaya vayala eteꞌya heotigahae.” huꞌya nehaya vayale. ");
INSERT INTO knb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Vayalegiꞌya Yisasina me havigeꞌya mage huꞌya hae “Humavenelina kanomogae Moseseꞌa tagaifena mage huno kaemaleneane ‘Nago kanomona nepuꞌamoꞌa nafaꞌneꞌa oꞌate kanoa aꞌama ataleno falinagenoꞌa aganaꞌamoꞌa ani aala aliteneno agoꞌma falimainea kanomofe anonaꞌa nafaꞌne atesie.’ huno kaemaleneane. ");
INSERT INTO knb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nago kanafina seveniꞌa (7) konaga mainayanagino nepuꞌamimoꞌa aala aliteneanagino nafaꞌnea oꞌate kano maineno falimaine. ");
INSERT INTO knb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Falitegeno anile aganaꞌamoꞌa ani aala aliteana nafaꞌnea aniꞌa huno oꞌatenea kano falitegeno anile aganaꞌamoꞌa aniꞌa humaine. ");
INSERT INTO knb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mukiꞌa seveniꞌa (7) konagamoꞌya aliteme aliteme ayana nafaꞌnea oꞌateꞌya fali haꞌno hageno haenagalafa ani aala falimaine. ");
INSERT INTO knb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Seveniꞌa (7) konagamoꞌya ani aala alitenayanagi falimainesafitiꞌma hetisaya kanafina hana kanomo ani aala aligahie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Havigageno Yisasiꞌa mage huno hamapaiye “Anumaya Koti kefima kaemalenea kene tokiya yamaꞌaenefena havilama hutama ohaviya yafe tamakaya havi tamakesageꞌya nehaviye. ");
INSERT INTO knb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Veaꞌma falimainesafiti hetisaya kanafina ensole vaya kana huꞌya vemoꞌya aala oꞌaligahae. Aꞌmoꞌyaenena vea oꞌaligahae. ");
INSERT INTO knb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Falimainaya veaꞌma eteꞌya hetisaya yafe nahavinegao? Mosese kaemalenea avopima ohapalinao? Nagola osi yosaleꞌma ala ata anefela leanagi ani osi yosa otene.” huno kaemalenea kea ohavinao? Anumaya Kotiꞌa ani kanafina Mosesefena mage huno humaineane “Nagaya Apalahamunagi Aisakinagi Yekopugami Anumaya mainoe.” huno humaineane. ");
INSERT INTO knb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ani anagala falimainayanagi “Nagaya Anumaya Kotiꞌamimoꞌna mainoe.” huno humainea yafena amaku amamemoꞌa ofalinegi afaꞌa mainaya yafe ani kea humaine. Tamakaya veaꞌmoꞌya heꞌotigahae hutama nehaya kea havige nehae.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nago kanoa kahegi kema havilinea kanomoꞌa anile eno huge havige haya kea haviana Yisasiꞌa kanale kema huhaleno hamapaiya kea me haviteno Yisasifena mage huno havige “Anumaya Koti kahegi kefitila hana kemo mukiꞌa kemona agaseno uhagoteno tokiyaꞌage kea hane?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Havige-geno Yisasiꞌa mage huno hie “Uhagoteno tokiyaꞌageꞌma humainea kemoꞌa mage huno humaine ‘Isaleli vayala* haviho Anumayamoꞌa tagaiti Anumaya Kotiꞌa agaiꞌage mainegi nagoꞌa Anumaya omaine. Kagaya Anumaya Kotikamofena kahau kayamopafina tokiyaꞌage huno kahaino. Mukiꞌa kagesama havisana yaꞌene kagu kamema havisana yaꞌene aliꞌya neꞌalina kayamufaene tokiyaꞌage huka Anumaya Kotina amio.’ ");
INSERT INTO knb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anile nago kea mage huno humaineane ‘Mukiꞌa vayafena tusiya huno kahau kayamopafi kahaino. Kagaika kaugafahema kahaisia avamete aniꞌa huno alu veaꞌmogami amaugafahena kahaino.’ Menima tole kema kahapauva kemoꞌa mukiꞌa Anumaya Koti kahegi kemona ago amakasemainea ke hane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Higeno ani kahegi kema havilinea kanomoꞌa Yisasifena mage huno hie “Humavenelina kanomogae tamage nehane. Nagoke Anumaya Koti mainegi nagoꞌa Anumaya Koti omaiye. ");
INSERT INTO knb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Omaigi tagaya mukiꞌa tahau tayamopafi tokiyaꞌage huno tahaisigeta mukiꞌa tagesama havisuna yaꞌene tagu tamema havisuna yaꞌene aliꞌya neꞌaluna tayamufaene tokiyaꞌage huta mukiꞌa Anumaya Kotina amisune. Amiteta mukiꞌa veafena tahau tayamopafi tahainageno tagaiti laugafahema tahaisia avamete aniꞌa huta alu veaꞌmogami amaugafahena tahaisie. Naꞌama hisuna yamoꞌa mukiꞌa alu kavala amakasemaine. Nayona veaꞌmoꞌya ‘Anumaya Kotina muse yana neꞌamune.’ huꞌya nagola sipi sipi heꞌya neꞌamiꞌya nago sipi sipia atafi kae salaꞌmana aineꞌataleꞌya nehaya yamona menima kahapauva kemoꞌa ani kavala ago agasemaine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisasiꞌa anima huhalenoꞌma hia kea haviteno “Haviꞌyamaꞌaene kano maineafenagino nahapaiye.” huno agesafinaga haviteno kenonaꞌa mage huno hie “Ani kema hana kemoga aupaꞌa Anumaya Kotife ‘Kava yagainato.’ huka hugane.” huno hie. Higeꞌya vayaꞌyagamoꞌya haviteꞌya koli huꞌya Yisasina nagoꞌene haviokenae. ");
INSERT INTO knb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisasiꞌa ala mono nopi mo humavenelino mage huno hamavige “Kahegi kema havilinaya anagaꞌmoꞌya naꞌa higeꞌya Kalaisifena, ‘Anumaya Kotiꞌa hutenea kanomofena Tevitina aginagomoꞌa mopale kano maine?’ huꞌya nehae.” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hamavinegeno mage hie “Tevitiꞌa Anumaya Kotina Alu Aotage Avamumo hapaiya kea mage huno humaineane ‘Anumaya Kotiꞌa Anumaya-niꞌamofena mage huno humaine ‘Tamaga nayatega, ala vaya mainalega hanea siale emainesanageꞌna kame vayakaꞌa kaiyafinaga amatesugeꞌya kagaife ‘Ago tagasane.’ huꞌya hugahae.’ huno kaemaleneane. ");
INSERT INTO knb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tevitiꞌa Kalaisife ‘Anumayaniꞌa mainane.’ huno humainegi naꞌa higeno Tevitiꞌa haenagama atesia aginagomofena ‘Anumayaniꞌamoga mainane.’ huno humaineane?” huno hamavige. Higeꞌya mukiꞌa alitalu humainaya veaꞌmoya Yisasi kea haviteꞌya tusiꞌa muse hae. ");
INSERT INTO knb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yisasiꞌa hamapaiya kefiti mage huno hamapaiye “Kahegi kema havilinaya anagafena kaꞌyeho. Ani vayaꞌmoꞌya ayaꞌaya kena failiya yafena ‘Nelagafi notagafi?’ huꞌyama haya yafena tusiya huno nehamaiye. Vaya atagu nefaya kumapi mo vaiyatete nehuꞌya ‘Naꞌa vaya mainae.’ huꞌya ‘Ali falu fala hulatesae.’ huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mono nopiꞌene imuleꞌene ‘Ala vayaꞌageꞌma nemaiya sialekeꞌya maigahune.’ huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ani vayaꞌmoꞌya keto aꞌneyagahena ‘Mono nopima atalesaya monea tamiho.’ huꞌya nehuꞌya noꞌamifima hanea yaꞌyaga musufaya huꞌya moneꞌamia ali haꞌno nehaya vayalagiꞌya. Vayaꞌyaga ayemavataga huꞌya ‘Kanale vaya mainae.’ huꞌya hisae huꞌya ayaꞌaya nunamu nehayane. Aniꞌama nehaya vayaꞌmoꞌya havi miyana tusiya huno amaugafa amagata aisia yaꞌene aligahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisasiꞌa mono nopi mone neꞌatalaya kaiyaga maineno monema atalaya veala amakeana moneꞌamima hanea veaꞌmoꞌya “Monetia Anumaya Kotina amigahune.” huꞌya ala mone pokisifina atalenae. ");
INSERT INTO knb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Atalageno nagola moneꞌa omale keto aꞌmoꞌa tole osi haesa monea metalene. Ani haesa yafatalamogania tokayaꞌagenoꞌa vani toya kana humaine. ");
INSERT INTO knb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yisasiꞌa ani yana ageteno agaiꞌaenema tokaeꞌya nemaiya anagafe ke higeꞌya ageno mage huno hamapaiye “Nagaya tamagelafa huꞌna tamahanepauve ma ma moneꞌa omale keto aꞌmoꞌa hagoteꞌyama metalaya veaꞌmogamina amakaseno ala mone metale. ");
INSERT INTO knb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Metaleneanagi moneꞌamima hanea veaꞌmoꞌya aliꞌyamaꞌa omalenea monegiꞌya havigu malenaya monegiꞌya afaꞌa metalayanagi ani aꞌmoꞌa mukiꞌa yamaꞌa ali haꞌno huno metale. Mukiꞌa kaveꞌama alino nesia moneꞌa mukiꞌa alino metale.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisasiꞌa ala mono nona neꞌataleno vigeno nagola agaiꞌaenema tokaeno nemaiya kanomoꞌa mage hie “Hulavenelina kanomogae male ago. Ala yafana kanale yafaꞌyagaleti kimalenaya kanale noꞌyaga hanegeka neꞌagane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Higeno Yisasiꞌa mage huno hie “Kagaya mani kanaleꞌnale ala noꞌyaga neꞌagano? Ani mukiꞌa yafaꞌyaga alino lagape aitalesigeno aposilavisianagi nago yafamoꞌa nago yafamo agupifina aikalo huno omaigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yisasiꞌa Olivi yosa hanea agoꞌyamo agegayalega haino mopale maineno ageana ala mono nona atu kaiyaga hanegeno neꞌagegeꞌya Pitaꞌene Yemesiꞌene Yoniꞌene Etaluꞌene Yisasiꞌma mainelega emainae. ");
INSERT INTO knb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Eꞌya Yisasife mage huꞌya havigae “Ani yafa nomoꞌa tagapema aisia kana na kanafine? Hana augafa tokiya avame yamo ani kanama faloteꞌma hisia kanafina taveligahie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hageno Yisasiꞌa mage huno hie “Nagoꞌa vayaꞌmoꞌya havigema lamahapaisagetamahena ohavisaya yafe kaꞌye ho. ");
INSERT INTO knb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mukiꞌa vayaꞌmoꞌya nagai nagia neꞌayeꞌya ‘Anumaya Kotiꞌa tamaugafa aligatisuna yafe hulategeta neꞌone.” huꞌyama hisayana kasagoꞌya veaꞌne havige ayemavataga hugahae. ");
INSERT INTO knb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Nagoꞌa kotega kamema nehae.” huꞌya hisagetamaene “Kotamile-gaenema kamema nehae” huꞌyama tamahapaisagetamahena kolia ohiho. Ani yaꞌyagamoꞌa hagoteno falote hugahianagi ma mopama haꞌno hisia kanamoꞌa yaufa falote ohune. ");
INSERT INTO knb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nagoꞌa vayaꞌmoꞌya alu vayaꞌenena kamea hugahae. Ala kotega vayaꞌene nago ala kotega vayaꞌenena kamea hugahae. Kasagoꞌya alu kote kotela tusiꞌa imila aligahie. Alu kote kotela tusiꞌa kafu nehuꞌya amakatesia kanamoꞌa falote hugahie. Ani yaꞌyagamoꞌa afaꞌa aꞌnemoꞌya nafaꞌnema ategahema hageno aepa heno amagata neꞌaiya avamete kava hugahianagi haenagaꞌa tusiꞌa tamagata yamo falote hugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tamakaitamia kava yagailama hiho. Nagoꞌa veaꞌmoꞌya tamakaila tamavaleꞌya kanisole vayate kaiyekea hulamategahae. Mono nopi tamavaleꞌya kaꞌyona mo lamamigahae. Nagai nakaveꞌma haya yafe tamavaleꞌya ala kava vayateꞌene amakasemainea sauve vayateꞌene tamavaleꞌya hetilamatesageꞌya kaiyekea hulamatesagetama nagai kanale mono kea hamapaigahae. ");
INSERT INTO knb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hamapaigahayanagi hagoteꞌya Yisasi kanale mono kea aliꞌya ute ete huꞌya mukiꞌa kote veaꞌmogamina hamapaitesageno ma mopamoꞌa haꞌno hugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tamavaleꞌyama kaiyeke hulamatesaya kanafina kema hisaya yafena “Naꞌane huta hugahuneꞌ hutama tamakesa kuꞌmoꞌa ohutama afaꞌa viho. Ani kanafina kanale kema hisaya kea Anumaya Kotiꞌa tamahapainagetama hugahae. Ani kea tamakai kea omalegi Anumaya Koti Alu Aotage Avamuꞌmoꞌa huno lamakesa hinagetama hugahae. ");
INSERT INTO knb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ani kanafina veaꞌmoꞌya amakaiꞌami nepuꞌamimona kame vayaꞌamimote amavaleꞌya visayaꞌamoꞌya ‘Hamaegeꞌya faliho.’ huꞌya hugahae. Nefaꞌa nafaꞌneyagaꞌa aniꞌa humategahae. Nafaꞌneꞌamimoꞌya itaꞌafoꞌamimoꞌene-na aliyahae huꞌya kamea humateteꞌya ‘Hamaetama faliho.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nagima neꞌayaya yafe mukiꞌa veaꞌmoꞌya haviꞌya amaipa kafa helamategahae. Nagoꞌa veaꞌmoꞌya nagai kemona meni kanaleti aepa heꞌya atafa huꞌya tokiyaꞌage hume hume neꞌvisageꞌna Yisasiꞌna eteꞌnama esua kanafina nagai kema atafa hulinesaya veaꞌmogamina Anumaya Kotiꞌa amaku amamena aligatigahie. ");
INSERT INTO knb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yisasiꞌa nagoꞌene mage huno hie tusiꞌa havi yana ma mopa alino hagagitalesia yana alu aotage yapi hetimainesigetama agegahae. Anima tamamaꞌyoma aisia yama agenuta-mahena Yutia mainaya veaꞌmogatama tamaiyayetama agoꞌyalega viho. Ani Yisasiꞌma humainea kema hapalitama havisamogatama havilama hutama haviho. ");
INSERT INTO knb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nagi nago kanomoꞌa nogatofuleꞌma haino maineno ani kema havinunofena tavino nomaꞌafinagati haifaleno nagoꞌa yana oꞌalino. Afaꞌa aiyayeno vino. ");
INSERT INTO knb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nagoꞌa veaꞌmoꞌya hoyafinagama mainesaletila kenaꞌamima aligahena notega eteꞌya oꞌviho. ");
INSERT INTO knb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Avoꞌnio ani kanafina tusiꞌa havi yamo falote hugahie. Amaipaene aꞌnene nute anilinesia nafaꞌnemogami itaꞌamimoꞌyaenefena tusiꞌa nahau nehie. ");
INSERT INTO knb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Anumaya Kotitega nunamuna mage hutama havigeho “Ani havi yamoꞌa tani koꞌma ikate tisia kanafina falote ohisie.’ hutama havigeho. ");
INSERT INTO knb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ani kanafina tusiꞌa kana ya falote hugahie. Eheꞌma Anumaya Kotiꞌa ma mopama talo humalenea kanafiꞌene meni kanafiꞌenena aniꞌa ala kana yana falote ohuneanagi tusiꞌa ala kana yamoꞌa nagoꞌene haenagaꞌa aniꞌa huno falote ohugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Anumaya Kotiꞌa ani havi kanama alino aupa ohileꞌasina mukiꞌa veaꞌmoꞌya falileꞌasinagi Anumaya Kotiꞌa haigenoꞌma hapalimatenea veafe agesa havino amaugafa aligatisia yafe ani kanaꞌa alino aupa hugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ani kanafina nagoꞌa veaꞌmoꞌya mage hugahae “Anumaya Kotiꞌma taugafa aligatigahie huno hutenea kanoa ma mainegi ageho. Atu mainegi ageho.” huꞌya hisagetamahena “Tamage nehae.” hutama havitama tamametitia ohiho. ");
INSERT INTO knb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ani kanafina nagoꞌa havigeꞌage amaune vayaꞌene “Nagaya Anumaya Kotiꞌma tamaugafa aligatigahie huno hunatenea kano mainoe.” huno havige hisia kanoene evaꞌyi huꞌya veaꞌmogamina ayemavataga hugahe tokiyaꞌage avame yana hugahayanagi Anumaya Kotiꞌa haꞌye huno hapalimatenea veaꞌmoꞌya ohavigahae. ");
INSERT INTO knb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ohavigahagi falote ohunaya kanafina ago tamahapaimainogi kaꞌyetama maiho. ");
INSERT INTO knb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ani havi kanamoꞌa haꞌno hutesigeno yagemoꞌa hanimaꞌage hinageno ikamoꞌa aivasa ohugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kaꞌnefiꞌmoꞌya ikatetila atafailavigahie. Ikateꞌma hanea yaꞌyagamoꞌya kanage kanage huno alu kate kate vaiyegahie. ");
INSERT INTO knb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mukiꞌa ani yamoꞌa falote hutesigeꞌna ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna ikapinagatila siate elavisugeꞌya nagegahae. Tusiꞌa tokiyaꞌniene tusiꞌa hale yaniꞌaene esugetama nagegahae. ");
INSERT INTO knb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nenagesageꞌna ensole vayaꞌnia humatesugeꞌya yagemoꞌma tavi nefalelegatiꞌene evaꞌyi nehilegatiꞌene aluga aluga haupalegatiꞌene mukiꞌa mopaene mopaene nagaiꞌniꞌa nahaigeꞌna hapalimatenoa veaꞌnea aluga aluga mukiꞌa ma mopamona atupaletiꞌene ikamo atupaletiꞌene amavalesageꞌya melitalu hugahae. ");
INSERT INTO knb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yisasiꞌa mage huno hie “Fiki yosamoꞌa nago avame ya tamaveligahigi ageho. Ani yosamoꞌa hagoteno akopapitiꞌma agusasiyeno amuꞌma malesigetamahena ‘Anuna valesia kanamoꞌa falote hugahe nehie.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Naꞌa hugahayanagi manima tamahanepauva kuguva yama agenutamahena “Yisasiꞌa esia kanamoꞌa ago aupa higeno fiate hetino maineanagino ago egahie.’ hutama tamakesa havigahae. ");
INSERT INTO knb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nagaya tamage huꞌna tamahanepauve meni kanafima mainaya veala ofalinesageno ani yamoꞌa falote hugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ikaꞌene mopaene fanane hugahianagi nagai kemoꞌa fanane ohugahie. ");
INSERT INTO knb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Manima tamahapauva kanama falote hisia kanahena nago kanomoꞌa ohavine. Ikapinaga mainaya ensole vayaꞌmoꞌya ohavinae. Anumaya Kotina nafaꞌneꞌamoꞌna ani kanama falote hisia kanahena ohavinoanagi nenafaꞌa agaiꞌage haviline. ");
INSERT INTO knb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tamakaya ani kanama falote hisia kanahena ohavinaya yafe tamaula ofaetama tamakaitamile yagaiho. ");
INSERT INTO knb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nago kava kanomoꞌma hia kava huno Yisasiꞌa egahie. Ani kava kanomoꞌa aliꞌya vayaꞌamofena ‘Ma aliꞌyana alu aliꞌya alu aliꞌyana tamahaote tamahaote yagaitama maiho.’ huneꞌamateno “Fiateꞌma mainamoga kagaikaꞌa yagaiyo.” huneꞌateno ataleno alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Naꞌa humaineafe tamakaya aniꞌa hutama yagaiho. Nomona nefaꞌma esia kanahena ohavinae. Une esio? Kege amuꞌnopi esio? Kokolemoꞌa age neꞌaisigeno esio? Ifi nate esio? Esia kanahena ohavinaya yafe kava yagaitama maiho. ");
INSERT INTO knb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Faetama mainesageno havigu aupaꞌa esigetama tamakaye hu yafenagi kaꞌyetama maiho. ");
INSERT INTO knb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mani kea tamakaifema hua kea mukiꞌa veaꞌmogamife nehugi kava yagaitama tokiyaꞌage hutama maiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ani kanafina tole yupa maiteꞌya kafuꞌahe kafuꞌahe Anumaya Kotiꞌma amakinagomo amaugafama aligatimainea yafe* alitalu huꞌya hale oki kaihamena nenaya imu kigahe nehageꞌya mono note kava vayaꞌmoꞌyaene kahegi kema havilinaya anagaꞌene Yisasina haesaya kea kesi ako huꞌya atafa hisaya yafe ke huge havige humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mage huꞌya hae “Mukiꞌa veala imuleꞌma alitalu huꞌya maisafima Yisasina atafama hisunageꞌya mukiꞌa veaꞌmoꞌya ageteꞌya ke huꞌya atile male huꞌya tu hugahae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yisasiꞌa Petani umaineno nayona fugitaya agemainea kanomo agia Saimoniꞌe kanomo nopi umaine. Mopale umaineno kave nenegeno nago aꞌmoꞌa anile eno manaꞌage masavena havatemai yafa keꞌayola alilino emaine. Ani keꞌayopina nagola tusiꞌa monele hanea masavena manaꞌage tina hane. Ani limo agia natie. Ani keꞌayoꞌma taloma hia yafamo agia alapasata yafane. Ani aꞌmoꞌa masave keꞌayola alino aitagino Yisasi anupi takino faletene. ");
INSERT INTO knb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Faletegeꞌya nagoꞌa anile mainaya vayaꞌmoꞌya ageteꞌya ke vaiꞌya mohu mehu nehuꞌya mage huꞌya hae “Naꞌa higeno mani aꞌmoꞌa manaꞌage masavena afaꞌa neꞌatale? ");
INSERT INTO knb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nago kanomoꞌma miya hileꞌasina tali hataleti kina (K300) aluteꞌasine. Aliteta ani masavete monea alita afenoꞌamima omalenea veaꞌnea amamuteꞌasine.” huꞌya ani aꞌmofena “Kefo kava talo hane.” huꞌya kemakimainae. ");
INSERT INTO knb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ke neꞌamakigeno Yisasiꞌa mage huno hie “Agaila afaꞌa ataleho. Naꞌa higetama kea neꞌamakiye? Ani aꞌmona aipamoꞌa haviya hisia kava nehagi nagaila tusiꞌa kanale kava hunenate. ");
INSERT INTO knb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Afenoꞌamima omalenea veaꞌmoꞌya mukiꞌa kanafina tamakaiꞌene maigahayanagitama amaya hisaya tamakesama havisayana amaya hugahayanagi nagaya tamakaiꞌenena mukiꞌa kanafina omaigahue. ");
INSERT INTO knb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ani aꞌmoꞌa amukoꞌa hanegeno ani kavala hagoteno afaꞌa ofaliꞌna mainogeno masavema faleꞌya hevainatesaya masavena agola fale nenate. ");
INSERT INTO knb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tamage huꞌna tamahanepauve mukiꞌa ma mopafi veapima Yisasifena kanale mono kema hamapaisayana ani aꞌmoꞌma hia kavafeꞌenena hamapaisageꞌya mukiꞌa veaꞌmoꞌya agaife amakesa havi havi huꞌya maigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ani kanafina Yutasi Isakaliotiꞌa tuelufuꞌa (12) anagaꞌaene nemaiya kanomoꞌa viaꞌamo Yisasina agesi huno momavalesigeꞌya metafa hisaya yafe mono note kava vayatega umaine. ");
INSERT INTO knb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Viaꞌamo mo hamapaigeꞌya ani kea haviteꞌya tusiꞌa muse huteꞌya ‘Mone kamigahune.’ huꞌya hapaitageno Yutasiꞌa vaya kuluta oꞌai yate kesi kateti momavaleno esigeꞌya Yisasina haesaya kafe atiyemaine. ");
INSERT INTO knb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hale oki kaihame kana maya nenaya kanamoꞌa ehe kanale Anumaya Kotiꞌa Yuta vaya amaugafama aligatimainea kanahe amakesa nehaviya imuma kigahena sipi sipi heꞌya kiꞌya nenaya kanamoꞌa falote higeꞌya Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya Yisasina mage huꞌya havigae “Hanatega kahaisia kumatela Anumaya Kotiꞌa amaugafama aligatimainea kanahe kagesa havisana kavela mo lalo tala hisune?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hageno Yisasiꞌa tole kanolatana hunateno mage huno hanapaiye “Ala kumate neꞌviꞌageno ti keꞌayoꞌma alino esia kanoene fotu hutetana akave viꞌo. ");
INSERT INTO knb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Akave neꞌviꞌageno haino mo falesia nopi haitana ani nomona nefafe mage hutana havigeꞌo ‘Hulavenelia kanomoꞌa mage hie ‘Hanate ayenalagimalenana nona hane? Yoka namisanageꞌna nagaiꞌene tokaeꞌya nemaiya anagaꞌniene Anumaya Kotiꞌa amaugafama aligatimainea kanahe tagesa havisuna kavela nesune?’ huno hie.’ hutana havigeꞌo. ");
INSERT INTO knb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hisaꞌagenoꞌa folamo huno anale kimalenea nona ago alino hilato humaleneanagino ala nona tanavelisigetana kavetia talo tala hiꞌo.” huno hanapaiye. ");
INSERT INTO knb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Higeꞌana ala kumate vaꞌana Yisasiꞌma hia kemoꞌa mukiꞌa falote higeꞌana ageteꞌana Anumaya Kotiꞌa amaugafa aligatimainea kanahe amakesa havi havi hisaya kavela talo tala humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Talo humalenaꞌageꞌya yagemoꞌma tavi faleamaꞌa Yisasiꞌa tuelufuꞌa (12) anagaꞌamoꞌyaene emainae. ");
INSERT INTO knb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mopale emaineꞌya kavela nenageno Yisasiꞌa mage huno hie “Tamage huꞌna tamahanepauve nagaiꞌenema kaveꞌma nenaya anagaꞌmogatama tamakaipiti kesi nahaesaya yatela nago kanomoꞌa vaineꞌaye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Higeꞌya ani anagaꞌmoꞌya amaipa haviya huteꞌya agaifena amahaote amahaote mage huꞌya hae “Nagaife nehano?” higeꞌya “Nagaife nehano?” higeꞌya huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Havigageno Yisasiꞌa mage huno hie “Tamakaya tuelufuꞌa (12) anagaꞌnimogatama tamakaipiti nagokeꞌmoga kesi nahaesaya katela vaineꞌayane. Ani kanomoꞌa nagaiꞌene nagoke yopafiti kaihame kana maya ali vayagofino nene. ");
INSERT INTO knb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemonihena Anumaya Koti autaꞌmafima kaemalenaya avamete kava hugahuanagi vayaꞌmoꞌya havisagi huno nagesi hunatesia kanomofena ‘Avoꞌnio nahau hanagi kagaya maigaꞌyeka mainekao.’ huꞌna nehue. Ani kanomoga itakamoꞌa okateneleꞌasina tusiꞌa kanale kava hileꞌasine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ani kavela nenageno Yisasiꞌa kaihame kana maya alino nunamu huteno muse huno havigeno kolite kolite huno neꞌamamino mage huno hie “Aliho. Mamona nagaiꞌni naugafae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nagola vaini nofi alagamo ti* hanea keꞌayola aliteno nunamu huno muse huno havigeno alino amamite amamite higeꞌya nemainae. ");
INSERT INTO knb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nenageno Yisasiꞌa mage huno hie “Mamona nagaiꞌni kolane. Vayaꞌmoꞌya nahaesageꞌna falisugeno kolaniꞌamoꞌa takilavino mukiꞌa veafene huno takilavisia yafe Anumaya Kotiꞌa hulokiya vaino alino halegafilamatenea kemo* aepamoꞌa alino fatago hugahie. ");
INSERT INTO knb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tamage huꞌna tamahanepauve menia nagaya vaini nofi alagamo timaꞌa* nagoꞌene onegahuanagiꞌna Anumaya Kotiꞌma kava yagaimainea kumate umaineꞌna haegafa nofi alagamo tina* eteꞌna negahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Higeꞌya yagamea nagola huteꞌya Olivi yosa hanea agoꞌyafi haimainae. ");
INSERT INTO knb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yisasiꞌa mage huno hamapaiye “Tamakaya mukiꞌamogatama nagaife havitama tamakupi maletama tamametiti nehaya yana ataletama asaga hulavisagi nayona ani yafe kaemaleneane ‘Nagaya sipi sipi kava kanoa haesugeꞌya sipi sipiyaga atagufeꞌya falegahae.’ huno kaemaleneane. ");
INSERT INTO knb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kaemaleneanagi falimainesufiti Anumaya Kotiꞌa alino hetinatesigeꞌna Kalili uhagotelamateꞌna visugetama nakave egahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Higeno Pitaꞌa kenonaꞌa mage huno hie “Mukiꞌa anagala kagaifema haviꞌya amakupi maleꞌya amametiti nehaya yama ataleꞌya falesageꞌnahena nagaya aniꞌa ohugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Higeno Yisasiꞌa mage huno hie “Tamage huꞌna kahanepauve meni kegela kokolemoꞌa tole kanale agea oꞌainesigeka kagaya tagufa (3) kanale mage hugane ‘Nagaya oꞌagenoa kanoe.’ huka avane hunategane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Higeno Pitaꞌa tokiyaꞌage ke huno hie “Kagaiꞌene nahaesageꞌna faligahuanagiꞌna kagai kagihena avanena huꞌna fala okigahue.” huno higeꞌya mukiꞌa anagaꞌmoꞌya nagoke kegeꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Huteꞌya Ketesemani uvaꞌyi hageno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagafena mage huno hie “Tamakaya male maineho. Nagaya Anumaya Kotitega nunamu huꞌna havigegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitaꞌene Yemesiꞌene Yoniꞌene amavaleno viana aepa heno aipamoꞌa kanaꞌage higeno haumana halegeno kasageke hie. ");
INSERT INTO knb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Huteno mage huno hamapaiye “Nahau nayamopamoꞌa tusiꞌa kanaꞌage nehigeꞌna ago falisua kava nehugi male mainetama kava yagaitama maineho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Osiꞌa viaꞌamo nunamu huno havigegahe mopafi agoꞌya moyeno maineno nunamuna mage huno havige “Kahaisigekahena falisua kanaꞌnia alitalesane huꞌna kahavinegoe. ");
INSERT INTO knb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nenafagae kagaya mukiꞌa yana kanale hateꞌasine. Nagaya falisua kava nehugi ani havi kanamoꞌa satuꞌage hia ti kana tima hanea keꞌayola nahafaletalo. Afaꞌa nagai nagu nagesa akave ohuka kahaisia yana afaꞌa huo.” huno havige. ");
INSERT INTO knb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Havigeteno viaꞌamo momakeana agaiꞌaenema tokaeꞌya nemaiya anagala faeꞌya mainageno Pitafena mage huno hie “Saimonigae faekage mainano? Vae kagaya aupa kana kanoꞌa kava oꞌyagaikage mainano? ");
INSERT INTO knb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sataniꞌa ayelamavataga hisigeno tamakuꞌamoꞌa ‘Ohugahue.’ huno tokiyaꞌage humaineanagi afaꞌa amega tamaugafamoꞌa tokiyaꞌa omaleneanagino ‘Hugahue.’ huno hisia yana hugahigi Satani kema ohavisaya yafena kava yagaitama mainetama Anumayamotega ke hutama havigeho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huteno amataleno viaꞌamo Anumayamotega havigea kea aniꞌa huno nagoꞌene mo havige. ");
INSERT INTO knb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Havigeteno eteno momakeana amau tokotoko higeꞌya faeꞌya mainageno momakeanagi “Vae tagaya naꞌane hisune?” hugeꞌya amakesaguꞌmo humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hageno Yisasiꞌa eteno eaꞌamo tagufa (3) kanale amakaifena mage huno hamavige “Maifalu hutamage faetama mainao? Hailagino kanaꞌnia ago falote nehie. Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemonia nagesi huno navaleno kefo yama nehaya vayaꞌmogami amayapi natesigeꞌya nahaegahe nehae. ");
INSERT INTO knb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mukiꞌamogatama hetitama vigetao. Ageho nagesi huno nahaesia kanoa ago neꞌegi vigeta mogamano.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisasiꞌa mani kea nehigeno aupaꞌa Yutasiꞌa tuelufuꞌa (12) anagaꞌaenema tokaeno nemaiya kanomoꞌa evaꞌyi higeꞌya agaiꞌene mukiꞌa vayaꞌyagaene mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene nagoꞌa Yuta vayatamaenema humataya vayaꞌmoꞌya ayaꞌaya naepege naipege huꞌya muki kaꞌyoꞌene aliꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Agesi huno Yisasina haesaya yama amavalisea kanomoꞌa vayaꞌyagahena mage huno hamapaiye “Atakoꞌma hisua kanoa haesaya kano mainegi atafa hutama tokiyaꞌage hutama avaletama viho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yutasiꞌa evaꞌyi huno Yisasite eaꞌamo mage hie “Hulavenelina kanomogae.” nehuno atako me hie. ");
INSERT INTO knb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Atako higeꞌya ageteꞌya vayaꞌyagamoꞌya Yisasina atafa huꞌya ayetalako humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atafa nehageno nagola agaiꞌaenema hetimaiya kanomoꞌa ayaꞌaya naepeꞌa hevayu huno ala mono note hagote kava kanomo aliꞌya kanoꞌamo agesa aifakalitalegeno asaka hulavimaine. ");
INSERT INTO knb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aifakalitegeno Yisasiꞌa mage huno hie “Tamakaya nagaifena ‘Vaya nehamaeno musufaya nehia kano maine.’ hutama nagaiꞌma natafa hugahena ayaꞌaya naepene muki kaꞌyoꞌene alitama neꞌao? ");
INSERT INTO knb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mukiꞌa kanafina efiꞌefi huꞌna tamakaiꞌene maineꞌna ala mono nopina mono kea huhaleꞌna nehuanagi nagaila natafa ohunayanagi afaꞌa kanalele. Nayoma kaemalenaya kemoꞌa falote huno tamage hisia yafe menia natafa nehae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Higeꞌya mukiꞌa agaiꞌaenema tokaeꞌya nemaiya anagala neꞌataleꞌya fale haꞌno humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Nago neyamoꞌa aye ohati kena kenalafamaꞌage failino Yisasi akave umainegeꞌya agaila atafa hugahe hageno kenaꞌa hateno neꞌataleno augafa alapaꞌage aiyayeno faleno umaine. ");
INSERT INTO knb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yisasina avaleꞌya ala mono notela hagote kava kanomote ageꞌya mono note kava vayaꞌyagaene Yuta vayatamayagaene kahegi kema havilinaya anagaꞌene alitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitaꞌa akave anatino vianagi avatela oꞌunegi aluꞌale umaineno ala mono notela hagote kava kanomo nomo haupale uvaꞌyi huno ati vayaꞌene mopale umaineno atale tota huno maine. ");
INSERT INTO knb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mono note kava vayaꞌmoꞌyaene mukiꞌa kanisole vayaꞌene Yisasiꞌma haesaya kaiyekema hutegahena nagoꞌa vayaꞌmoꞌya “Kefo kavala higeta agemainone.” huꞌya hutesaya vayafe atiyayana omainae. ");
INSERT INTO knb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Omaigeꞌya kasagoꞌya vayaꞌmoꞌya havige huꞌya Yisasifena hayanagi amakai kemoꞌa nago katela ohunagi alu ke alu ke maiꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Nagoꞌa vayaꞌmoꞌya hetiꞌya havige huꞌya Yisasifena mage huꞌya hae “Tagaya agaiꞌama humainea kea havilinone mage huno humaine ‘Nagaya vayaꞌmoꞌyama kimalenaya ala mono nona aliꞌna lagape aitaleꞌna tagufa (3) kanafi ani nona eteꞌna vayaꞌmoꞌya nokiya avamete no ali hetigahue.’ huno higeta havilinone.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hayanagi ani kemoꞌa nago avamete kea ohunagi alu ke alu ke maiꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hageno ala mono notela hagote kava kanomoꞌa amuꞌnoꞌamifi hetimaineno Yisasina mage huno havige “Na augafa ke kagaifena nehae? Kagaifena kaiyekema hunegatayana kenonaꞌamia hufalote huka nohane?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Havigeanagi Yisasiꞌa kea ohuno avaya lukino maineno nagola osi ke kanoꞌa ohutafa huno mainegeno ala mono notela hagote kava kanomoꞌa eteno nagoꞌene havige “Kagaya Anumaya Kotiꞌa taugafa aligatigahema hugatenea kano mainano? Kagaya agima alisaga nehaya Anumaya Kotina nafaꞌneꞌamoga mainano?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Havigegeno Yisasiꞌa hufalote huno hie “E, nagaya ani kano mainoanagitama tamakaya haenagaꞌa Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemonia tusiꞌa tokiya yamaꞌa hanea Anumaya Kotina tamaga ayatega hanea siale maineꞌna ikate hanea siate esugetama nagegahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Higeno ala mono notela hagote kava kanomoꞌa ani kea havigeno aipamoꞌa tokiyaꞌage higeno kenaꞌa alino hatata nehuno mage huno hie “Tagaya hai havunanagiꞌya nagoꞌa vayaꞌmoꞌya kaiyekea huoꞌatesae. ");
INSERT INTO knb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anumaya Kotifema huhaviya hutea kea ago nehavigi. Na tamakesa nehaviye?” huno higeꞌya mage huꞌya hae “Tamage nehane anona yamaꞌa alisia yafe haesageno falisie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Huteꞌya nagoꞌa vayaꞌmoꞌya Yisasina amavetuꞌna heneꞌateꞌya aulagafi aiso huteneꞌya aikoneliꞌya mage huꞌya havigae “Kaune kema nehana kanomoga tahapaiyo taꞌya negahayae?” huꞌya havinegeꞌya ati vayaꞌmoꞌya amayateti aikolimainae. ");
INSERT INTO knb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pitaꞌa nomo haupalega afetega mainegeno ala mono notela hagote kava kanomona aliꞌya munaꞌmoꞌa anile emaineno ageana Pitaꞌa ata lota nehigeno ani munaꞌmoꞌa megeteno Pitana agesagali maineno mage huno hie “Kagayaenena Nasaleti Yisasiꞌene vaiyatete nehana kanoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Higeno Pitaꞌa avane huno “Aꞌao nagaya ani kanoa oꞌagenoa kanohe maika nehane.” huno nehuno fiate neꞌvigeno anile kokolemoꞌa agea aimaine. ");
INSERT INTO knb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Fiate mainegeno ani munaꞌmoꞌa mogeteno anile hetimaiya vayafena mage huno hie “Mani kanoa Yisasi anagapiti kanoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Higeno Pitaꞌa nagoꞌene eteno “Aꞌao nagaya ani kanoa omainoe.” huno hie. Osi kana kanoꞌa maigeꞌya anile hetimaiya vayaꞌmoꞌya mage huꞌya hae “Tamage kagaya Kalili kano mainana yafe agaiꞌene vaiyatete nehana kano mainane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hageno Pitaꞌa mage huno hie “Nagaya tamagema ohisugenoꞌa Anumaya Kotiꞌa nahaesie. Anumaya Koti aulagafina tamage huꞌna tamahanepauve tamakayama haya kanoa nagaya oꞌagenoa kanoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nehigeno aupaꞌa hagoteno agema aiya kokolemoꞌa anile viaꞌamo agea aigeno Pitana agesamoꞌa aikalo higeno Yisasiꞌma hapaigeno havimainea kea mage huno humaineane “Kokolemoꞌa tole kanale agea oꞌainesigeka kagaya tagufa (3) kanale avane huka nagaifena ‘Noꞌagoa kano maine.’ huka hugane huno humainea kemoꞌa Pita agesamoꞌa aikalo higeno haviteno tusiꞌa avitemaine. ");
INSERT INTO knb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kola alino halegeꞌya mukiꞌa mono note kava vayaꞌene Yuta vayatamaene kahegi kema havilinaya anagaꞌene kanisole vayaꞌene Yisasina haesageno falisia kea huge havige huteꞌya Yisasina nofi kiteteꞌya ala kamani kava kanole, Pailatite* avaleꞌya ayapi motenae. ");
INSERT INTO knb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Motageno Pailatiꞌa Yisasifena mage huno hie “Kagaya Yuta veaꞌmogami Sauve kano mainano?” huno havigegeno Yisasiꞌa mage hie “Kagaikaꞌa ani kea hai nehane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Higeꞌya mono note kava vayaꞌmoꞌya kasagoꞌya kea “Maꞌa kefo kava humainane.” huꞌya hutenae. ");
INSERT INTO knb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Huneꞌatageno Pailatiꞌa nagoꞌene mage huno hie “Havio mukiꞌa kefo yama nehana yana ali falote nehagi kagaya kenonaꞌamia naꞌa higeka nohane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hianagi Yisasiꞌa kenonaꞌa nagola osi ke kanoꞌa ohigeno Pailatina amaꞌyo aimaine. ");
INSERT INTO knb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kafuꞌahe kafuꞌahe Anumaya Kotiꞌa amaugafama aligatimainea kanahe amakesa haviꞌya imua negiyanagino Pailatiꞌa mukiꞌa ani imu kisaya kanafina nagoke nofi hutegeno nemaiya kanoa vayaꞌyagamoꞌya haesaga huꞌya “Agaya esie.” huꞌya haya kanohe nofipitila “Hai haꞌno hanagi vuo.” huno huneꞌatea kanae. ");
INSERT INTO knb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ani kanafina nago kanomo agia Palapasiꞌe kamani vayaꞌene tuma nehaya vayaꞌene maineno tuma haya kanafina vayala tavata nehamaeyaya vayaꞌene mainegeꞌya kina nopi avaleꞌya hutenayane. ");
INSERT INTO knb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hutenayanagiꞌya vayaꞌyagamoꞌya Pailatife mage huꞌya me hae “Mukiꞌa imuma kina kanafima nehana kavala hulato.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hageno Pailatiꞌa mage huno hamavige “Nagaya Yisasifena Yuta veate Sauve kanomofe ‘Hai haꞌno hanagi vuo.’ huꞌna hisugetama musena hugahao?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Higeꞌya mono note kava vayaꞌmoꞌya ma amakesa haviye “Mukiꞌa veala Yisasi kegeꞌya nehaviꞌya tagai kea nohaviye.” huteꞌya ani yafe Yisasifena amaipamoꞌa haviya huteteꞌya Pailatite avaleꞌya ageno Pailatiꞌa ani yafe agesa nehavino humaine. ");
INSERT INTO knb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Havianagi mono note kava vayaꞌmoꞌya mukiꞌa vayaꞌmogami amaipa moyeꞌya mage huꞌya hamapaiye “Mage hutama hiho ‘Palapasina atalesanageno afaꞌa esie.’ hutama hiho.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hageno Pailatiꞌa vayaꞌyagahena mage huno hamavige “Aniꞌa hisuana ma kanomofe tamakaya Yuta vayate Sauve kano maine hutama nehaya kanomofena naꞌa hutesue?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hamavigegeꞌya mukiꞌa vayaꞌmoꞌya ala kefiti mage huꞌya hae “Yafaga yosale nili hetama asaigeno falino.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hageno Pailatiꞌa mage huno hamavige “Naꞌa higetama na kea nehae? Hanaꞌa augafa kefo kava humaine?” huno hianagi amakaya eteꞌya aliꞌya alapi ataleꞌya ala kefiti mage huꞌya hae “Yafaga yosale nili hetama asaigeno falino.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hageno Pailatiꞌa mukiꞌa vayaꞌmoꞌya muse hisaya kava hugahue huno Palapasina nofipiti avaleno neꞌataleno Yisasina agata aisifa kaꞌyoteti haifu amiteno Yisasina ati vaya amayapi ateteno “Yafaga yosale nili hetama asaigeno falino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ati vayaꞌmoꞌya Yisasina avaleꞌya ala kava kanomo no haupalega umaineꞌya mukiꞌa amakaiꞌene nemaiya ati vayafe ke hageꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Emaineꞌya Yisasina akaya ategahe “Ala kano mainane.” huꞌya hisaya yafe ayaꞌaya haesa kena aliꞌya faiteteꞌya avetaꞌnafaꞌage nofi aliꞌya mo aigalaki me aigalaki huꞌya tumano kula talo huꞌya Yisasina anute vaitenae. ");
INSERT INTO knb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vaiteteꞌya aepa heꞌya huhaviya hutegahena mage huꞌya hae “Felugae. Yuta vayaꞌmogami sauve kanomogae.” huꞌya akaya atae. ");
INSERT INTO knb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Neꞌateꞌya anute kaꞌyoteti nagoꞌene nagoꞌene huꞌya aikoneliꞌya augafale amavetuꞌna heneꞌateꞌya amaleꞌya ayeꞌya mopale maineꞌya “Ala kano mainane” huꞌya ayevataga vatago humainae. ");
INSERT INTO knb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kigi huneꞌateꞌya haesa kena hateneꞌataleteꞌya agaiꞌa kena faiteteꞌya yafaga yosale nili hegahe avaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kategama vayana Saimoniꞌene fotu humainae. Ani kanoa Sailini kumate kanoe. Alekasataꞌene Lufasiganiene neꞌanafaꞌe. Ani Saimoniꞌa hoyafinagati kate eneꞌvigeꞌya ati vayaꞌmoꞌya tokiyaꞌage ke huꞌya “Kaiyayeka yafaga yosa melika vuo.” huꞌya hageno molino umaine. ");
INSERT INTO knb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Alino vigeꞌya Yisasina avaleꞌya vayaꞌamoꞌya Kologota kumate uvaꞌyi hae. Ani kumaꞌmo agimoꞌa tagaiti kefina anu ayamufa kumale huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ani ati vayaꞌmoꞌya “Haesunageno falisiana agata ai yafenagita agatama oꞌaisia tina amisunageno nesie.” huꞌyama hayana anima agata oꞌaisia timo agia mea. Meaꞌene nofi alagamo tiꞌene nagopi ali havigu huteꞌya aliꞌya amiyana Yisasiꞌa ani tifena “Aꞌao.” huno onene. ");
INSERT INTO knb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Onegeꞌya yafaga yosale nili heꞌya asaimaleteꞌya kenaꞌa fako huꞌya aligahe musufa yama nehaya yokalo lageꞌya amakasaya vayaꞌmoꞌya alimainae. ");
INSERT INTO knb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Natena naeni (9) kiloki yagemoꞌa anale hai vaꞌyi higeꞌya Yisasina yafaga yosalela nilia maleꞌya heteꞌya asaimainae. ");
INSERT INTO knb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Asaiteꞌya “Ma kava higeta haune.” huꞌya kaemalenae “Mani kanoa Yuta veate ala Sauve kanoe.” huꞌya kaeꞌya malenae. ");
INSERT INTO knb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Kaemaleteꞌya Yisasiꞌene tole kanolatana vaya nehamaeꞌana musufa yama nehaꞌa kanolatana nago kanoa Yisasina tamaga kaiyagaꞌa haeꞌya asaimaleꞌya nago kanoa haoga kaiyagaꞌa haeꞌya asaimaleꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Humalenageꞌya kateꞌma ute ete huꞌya agasaya vayaꞌmoꞌya amakeꞌya kaꞌyo aiꞌya “Kefo kano maine.” huꞌya kigi yokalofiti huhaviya huneꞌateꞌya mage huꞌya hae “Oho kagaya ‘Ala mono nona aliꞌna lagape aitaleteꞌna tagufa (3) kanafi eteꞌna kitalegahue.’ huka nehana kano mainane? ");
INSERT INTO knb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Menia kagaya yafaga yosa neꞌataleka kagaikaꞌa elavika kaugafa aligatio.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hageꞌya mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene amakaiꞌami vayaꞌmoꞌyaene aniꞌa huꞌya kamuge hatageꞌya vaineꞌateꞌya mohu mehu huꞌya huhaviya huneꞌateꞌya mage huꞌya hae “Nagoꞌa vea amaugafa aligatimainegi naꞌa higeno agaiꞌa augafa ali nokatie. ");
INSERT INTO knb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kalaisiga Isaleli vayate Sauve kanoꞌamimoga yafaga yosa neꞌataleka elavigeta agamano. Agesunana kagaifena havita tagupi maleta tametitia hugahune.” huꞌya huhaviya huneꞌatageno agaiꞌenema yafaga yosaleꞌma asaimalaya musufa kanolatamoganienena aniꞌa huꞌana Yisasina huhaviya hutenaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yagemoꞌa euno amuꞌnokaꞌno higeno halemainea yamoꞌa haꞌno higeno mukiꞌa kotega tusiꞌa hanikino viaꞌamo une kanalega eteno ali halemaine. ");
INSERT INTO knb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Une kanalega Yisasiꞌa ala kefiti ke huno agaiꞌa kefiti mage huno hie “Eli Eli lema sapakatani.” huno hie. Tagaiti kefina mage huno hie “Anumaya Kotiꞌnimogae, Anumaya Kotiꞌnimogae naꞌa higeka nagaila nenatalane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Higeꞌya nagoꞌa anile hetimaiya veaꞌmoꞌya haviteꞌya mage huꞌya hae “Ilaiyafe ke nehigi haviho.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hageno nago kanomoꞌa viaꞌamo hava koꞌyafa kana yana alino atuꞌage nofi alagamo tipi ayeteno alino viaꞌamo kupaga kaꞌyote maleno ani hava koꞌyafa kana yana kiteno “Yisasiꞌa mayu mayu huno nesie.” huno neꞌamino mage huno hie “Agava maineta agesune Ilaiyaꞌa yafaga yosaletila mevaleno elavisifi agegahune.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Higeno Yisasiꞌa ala kegefa huteno falimaine. ");
INSERT INTO knb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Faligenoꞌa ala mono nopima ala kena ayaꞌaya kenagefama asaimalenaya kenamoꞌa Yisasiꞌma falia kana kanoꞌale analeti aepa heno amuꞌnopiti hatata hulole hulavino mo talene. ");
INSERT INTO knb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ati vayate kava kanomoꞌa Yisasina aulega hetimaineno Yisasiꞌa kema huteno falia yana ageteno mage huno hie “Tamage huno mani kanoa Anumaya Koti nafaꞌnelafa maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nagoꞌa aꞌneyaga aluꞌale maineꞌya agemainae. Nagoꞌamogami amakia, osi Yemesiꞌene Yosefegani itaꞌanimoꞌa Maliaꞌe Salomiꞌagi Magatala kumate Maliaꞌagi huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yisasiꞌa Kalilima mainea kanafina ani aꞌneyagamoꞌya akave vaiyatete nehuꞌya kavela kaeꞌya neꞌamiyane. Mukiꞌa aꞌneyaga Yisasiꞌene Yelusalemu tokaeꞌya umainaya aꞌneyaga aluꞌale hetiꞌya maineꞌya Yisasina agemainae. ");
INSERT INTO knb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sapati yupahe haviꞌya talo tala hisaya kanagino yagemoꞌa lavi falegahe higeno Yosefeꞌa Alimatia kumate kanoa Yuta kanisolefi nemaiya kanoa evaꞌyi hie. Ani kanoa Anumaya Kotiꞌma kava yagaisia kanahe muse huno agava nehia kanogino kolia ohuno Pailatite viaꞌamo mage huno havige “Yisasina augafaꞌa aligahe nehue.” huno mo havige. ");
INSERT INTO knb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Havigegeno Pailatiꞌa “Aupaꞌa ago falimainegeka nehano? Avoꞌnio namaꞌyo aiye.” huno agesa nehavino nagoꞌa ati vayate kava yagaimainea kanohe ke higeno egeno “Yisasiꞌa ago falimaineo?” huno havige. ");
INSERT INTO knb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Havigegeno ati vayate kava kanomoꞌa “E, ago falimaine.” huno higeno Pailatiꞌa Yosefena mage huno hapaiye “Kanalelagi augafa afaꞌa moligane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Higeno Yosefeꞌa viaꞌamo kaꞌyo muki ayaꞌaya kena molino viaꞌamo augafa yafaga yosaleti alino maleneno kenaleti augafalela aigalaki kalaki huno haꞌya kiteno alino viaꞌamo hefalegeꞌya kafimalenaya yafakapi Yisasina hevaiteteno avayaleꞌma aililesia yafana ayetufeno anile mo aililemalene. ");
INSERT INTO knb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magatala Maliaꞌene Yosefena itaꞌamoꞌa Maliaꞌene maineꞌana hevaitea yafa kaana agemainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapati yupamoꞌa haꞌno higeꞌya Yemesina itaꞌamoꞌa Maliaꞌe hamoꞌamoꞌa Magatala kumate alagi Salomiꞌene Yisasina augafale manaꞌage masaveteti faletegahe ani masavena aliꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sota yupa yagemoꞌa yaufa nehaigeꞌya ani aꞌneyaga komulega vae. ");
INSERT INTO knb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kategama vayana amakaiꞌamige kea hume hume umainae “Komumo avayaleꞌma aililemalea yafana ta taya huno avayaletila alino avayu huno faitega atalelategahie?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nehuꞌya agesaga huꞌya agayana ani ala yafakefa ago alikelitalageno faitega hanegeꞌya agemainae. ");
INSERT INTO knb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ageteꞌya ani yafakapinaga hai faleꞌya mogayana nago neyana aya tamaga kaiyaga mopale mainegeꞌya agayana ani kanomoꞌa ayaꞌaya efe kena failinegeꞌya ageteꞌya tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Amamaꞌyo neꞌaigeno ani kanomoꞌa mage huno hie “Tamakaila tamamaꞌyoa oꞌaino. Tamakaya Nasaleti Yisasife ati neꞌayae. Yafaga yosale nilima heꞌya asaimalaya kanohe ati neꞌayayanagi agaya falimainefiti ago hetimaine. Mafina omainegi ani kanoma malaya kumala ma hanegi ageho. ");
INSERT INTO knb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tamakaya utama Yisasiꞌenema tokaeꞌya nemaiya anagaꞌene Pitaꞌene mage hutama hamapaiho “Yisasiꞌa ofalino afaꞌa mainenoꞌma tamahapaimainea kemoꞌa ago uhagotelamateno Kalili umainegi anilega neꞌutama Yisasina mogeho.” huno hamanepaiye. ");
INSERT INTO knb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Higeꞌya amakaya atili huteꞌya amamaꞌyo aigeꞌya yafakapitila hatilaviꞌya amaiyayeꞌya vayanagi kolima haya yafe nagoꞌa vayala ani kea hamaopainae. ");
INSERT INTO knb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sota yupa nate alakefafi Yisasiꞌa falimainefitila hetino viaꞌamo hagoteno Magatala kumate Malia mainelega uvaꞌyi higeno agemaine. Nayona ani aꞌmo agupina seveniꞌa (7) Satani Avamula mainegeno Yisasiꞌa anatitaleneane. ");
INSERT INTO knb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Ani Maliaꞌa ageteno viaꞌamo Yisasiꞌenema tokaeꞌya nemaiya anagala mogeana tusiꞌa hamau huꞌya avineꞌatageno ani aꞌmoꞌa mage huno mo hamapaiye “Yisasiꞌa falimainefitila ago hetigeꞌna nagaya agaila ago ageteꞌna neꞌoe.” huno hamapaigeꞌya haviteꞌya “Havige nehane.” huꞌya amametitia ohunae. ");
INSERT INTO knb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Haenagaꞌa ani vayapitila tolemogania kumala ataleꞌana katega neꞌvaꞌageno Yisasiꞌa evaꞌyi higeꞌana agemainaꞌe. ");
INSERT INTO knb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ageteꞌana ani kanolatana eteꞌana vayaꞌanimoꞌya mainalega vaꞌaꞌamogani “Yisasiꞌa naꞌa kano agoꞌe.” huꞌana mo nehaꞌana ani vayaꞌmoꞌya “Havige nehaꞌe.” huꞌya haviꞌya amametitia ohunae. ");
INSERT INTO knb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Haenagaꞌa aleveniꞌa (11) anagala kave maiꞌya nenageno Yisasiꞌa evaꞌyi huno maineno amakaya vayaꞌmoꞌyama haya kemoꞌa “Yisasiꞌa falimainefitila ago hetigeta agemainone.” huꞌya haya kema havisaya yafena amakuꞌamoꞌa tilegeꞌya haviꞌya amametitima ohaya yafe Yisasiꞌa ke memamakie. ");
INSERT INTO knb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kemamakiteno mage huno hamapaiye “Mukiꞌa kotega utama nagai kanale mono kea alitama veaꞌmogamina mo hamapaiho. ");
INSERT INTO knb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hamapaisageꞌya nagoꞌa veaꞌmoꞌya ani kehena ‘Tamage nehae.’ huꞌya haviꞌya amakupi maleꞌya amametiti hisagetama tina falematesageno Anumaya Kotiꞌa amaku amamena aligatigahianagi nagoꞌa veaꞌmoꞌya ani kehena ‘Havige nehae.’ huꞌya haviꞌya amakupi omalesaya veafena Anumaya Kotiꞌa ‘Hani yapi tegelege nehia atafi viho.’ huno humategahie. ");
INSERT INTO knb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nagai kema haviꞌya amakupi maleꞌya ametiti hisaya veaꞌmoꞌya ani tokiyaꞌage avame yana hugahae nagai nagile Kefo Avamula vea amakupitila amanati neꞌataleꞌya amaku amakesafiti ohavinesaya kefitila alu amake alu amakea aigahae. ");
INSERT INTO knb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Veaꞌma akafu neꞌamanisia osifaꞌvema atafa hisayana amaugafa amagata oꞌaisigeꞌya ofaligahae. Vayaꞌma nefalia posini lima nesayana amaugafa amagata oꞌaisigeꞌya ofaligahae. Kalima neꞌaliya vayaꞌmogami amaugafaleꞌma amayama malesagenoꞌa kaliꞌamimoꞌa kanale humategahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yisasiꞌa, Anumayatimoꞌe mani kea hamapaitegeno ikapinaga avalesaga higeno haino Anumaya Kotina tamaga ayatega umaine. ");
INSERT INTO knb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Umainegeꞌya Yisasiꞌene tokaeꞌya nemaiya anagala mukiꞌa kotega ute ete huꞌya Yisasi mono kea hamanepaigeno Anumayamoꞌa amakaiꞌene vaiyeno amaya huno tokiya yamaꞌaleti “Ani kea tamage nehae.” huꞌya veaꞌmoꞌya havisaya yafe kasagoꞌya tokiya avame yana humainae. Mani kema hua kea tamage.");
INSERT INTO knb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofilasiga ala kava kanomoga mukiꞌa vayaꞌmoꞌya Yisasiꞌma tagai amuꞌnopi humainea yana ago kaemalenae. ");
INSERT INTO knb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yisasi kema hamanepaiya vayaꞌmoꞌya ehe kanale aepa heꞌya ani yana ageteꞌya tamahapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Mukiꞌama kahapaiya kemona aepaꞌa kelamake ke havisa-nafe nagaya kanaleꞌya huꞌna havilama huꞌna havilinoafe fatago huꞌna kaeꞌna kamigahue huꞌna nehue. ");
INSERT INTO knb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nagi Yutia kotega ala kava kanomo agia Helotiꞌe kava yagaino mainea kanafina nago kanomo agia Sekalaiyaꞌe mono note kava kano maineanagino Apaisa nofi kano mai-geno aꞌamoꞌa Eloni nofi vayapiti falote humaineane. Ani aꞌmo agia Ilisapetiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ani alavelatana Anumaya Koti aulagafina fatago huꞌana mai-neꞌana mukiꞌa Anumayamo kahegi kea haviꞌana akave maleꞌana havi kavala ohunaꞌane. ");
INSERT INTO knb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ilisapetiꞌa namo a maineafe nafaꞌneꞌania omai alavelata kosuna alekano lemainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Apaisa nofi vayaꞌmoꞌya aliꞌya alisaya kana Sekalaiyaꞌa Anumaya Koti aulagafi aliꞌyamaꞌa neꞌaligeꞌya mono nopi kava vayaꞌmoꞌya Sekalaiyafe “Kagayae.” huꞌya hageno Sekalaiyaꞌa Anumaya Koti mono nopi maineno manaꞌage yana kaesalamana Anumaya Kotina huneꞌateane. ");
INSERT INTO knb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Halinamo manaꞌa Anumaya Kotina neꞌamigeꞌya mukiꞌa veaꞌne-yaga kumatega maineꞌya Anumaya Kotitega havigemainae. ");
INSERT INTO knb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Havigageno Sekalaiyaꞌa mono nopi mainegeno Anumayamo ensole kanomoꞌa agaite efalote huno manaꞌage ata kaemalea folamole* tamaga kaiyagaꞌa me hetimainegeno agemaine. ");
INSERT INTO knb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekalaiyaꞌa ani kanoa ageteno atali talu huno koli humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Koli hianagi ani kanomoꞌa mage huno hie “Sekalaiyaga kolia ohuka afaꞌa maiyo. Nunamuma humainana yafena Anumaya Kotiꞌa ago havianagino akamoꞌa Ilisapetiꞌa ne nafaꞌne atesigeka agia Yoniꞌe huka malo. ");
INSERT INTO knb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kagaya tusiꞌa muse nehisanageꞌya mukiꞌa veaꞌmoꞌya ani nafaꞌnema falote hisia yafena tusiꞌa muse hugahae. ");
INSERT INTO knb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ani nafaꞌnemoꞌa Anumaya Koti aulagafina ala agiene kano maineno havilina onegahia-nagino atenea kanaleti aepa heno Anumaya Koti Alu Aotage Avamuꞌmoꞌa aguꞌafina hiya hugahie. ");
INSERT INTO knb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hiya hisigeno mukiꞌa Isaleli kumate veaꞌnemoꞌya agai kea haviteꞌya amakuꞌa aiyahae huꞌya amakaiꞌami Anumaya Kotitega ugahae. ");
INSERT INTO knb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anumayamo aulega hagoteno Ilaiyaꞌma humainea kavaꞌene aminea tokiꞌyaꞌaene vigeꞌya amafaheꞌya agai kea haviteꞌya amakuꞌa aiyahae huꞌya nafaꞌneꞌamihena amakesa havigahae. Veganokano nehaya veaꞌneꞌmoꞌya agai kea haviteꞌya amakuꞌa aiyahae huꞌya fatago veaꞌneꞌmoꞌya humainaya kanale kea havigahae. Aniꞌama hisayafe veaꞌneyaga Anumayamoꞌma esiafe amakuꞌa talo tala huꞌya maigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Higeno Sekalaiyaꞌa mage huno hie “Tamage nehapi havige nehane? Nagaya kosunagiꞌna aꞌnimoꞌa alekano lemaineanagitaꞌa hanaꞌa hutaꞌa ani kea havisuꞌe?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Higeno ensole kanomoꞌa mage huno hie “Nagaya Kepalieliꞌnae Anumaya Koti aule hetiꞌna mainogeno Anumaya Kotiꞌa ani kanale kema kahapaisuafene huno hunategeꞌna emainoe. ");
INSERT INTO knb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Havio nagai kemoꞌma haenagaꞌa efaloteꞌma huno tamage hisigeka keꞌnia ohavinanafe menia tugogekamoꞌa tileno atalako hinageka kaiyekea ohugananagika kema hua kemoꞌa efalote huno tamage hisia kanale tugogekamoꞌa akalo hinageka kagea aikalo hugane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Higeꞌya kumate mainaya veaꞌmoꞌya Sekalaiyafe agava huge hugeteꞌya ayaꞌaya kanagefa Anumaya Koti noma hunalagimale nopima maiya yafe “Naꞌa higeno aupaꞌa nome.” huꞌya amakesa haviꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mainageno ani nopinagati hatilaviana kaiyekea nohie. Kaiyekema ohia yafe veaꞌmoꞌya amakesa mage huꞌya havimainae “Nopinaga maiya yamo alu ya agemai kano maine.” huꞌya havigeno ani kanomoꞌa ayateti avameꞌname huno kea hamapaiya-nagi avayamoꞌa tuki maine. ");
INSERT INTO knb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tuki mainegeno aliꞌyamaꞌama haꞌno hia kanale nomaꞌalega umaine. ");
INSERT INTO knb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Umainegeno haenagaꞌa aꞌamoꞌa, Ilisapetiꞌa aipaene maineno faefuꞌa (5) ikana falakino maineno mage hie “Anumayamoꞌa kanale ya hunatene. Nageteno veaꞌmogami amaulagafina nagayema humainoa yana ago alitalene.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisapetiꞌa aipaene mainea ikana sikisiꞌa (6) ika agasetegeno Anumaya Kotiꞌa nago ensole kanoa, Kepalielina, nago Kalili kotega hanea kumala, Nasaleti hutene. ");
INSERT INTO knb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anumaya Kotiꞌa nagola vene ofaenea munate Kepalielina hutegeno umaine. Ani munaꞌmo agia Maliaꞌe. Yosefena agaite hagemalenaya munale. Yosefena aginagomo agia Tevitiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kepalieliꞌa Maliate eno mage huno hie “Mainano? Anumaya Kotiꞌa kagaila muse nehia munaꞌmoga Anumayamoꞌa kagaiꞌene maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Higeno anima hia kehena Maliaꞌa tusi amaꞌyo neꞌaino ma agesa havimaine “Ani kea naꞌane ke me nahapaiye?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Higeno ensole kanomoꞌa agaife mage huno hie “Maliaga kolia ohuo. Anumaya Kotiꞌa kagaifena aipa kanale hunegate ");
INSERT INTO knb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Havio kagaya kaipa ya huteka ne nafaꞌne ateteka agia Yisasiꞌe huka malo. ");
INSERT INTO knb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Ani nafaꞌnemoꞌa agi hanesia kano mainesigeꞌya veaꞌmoꞌya ‘Anale mainea Anumaya Koti nafaꞌne maine.’ huꞌya hugahae. Aginagomoꞌa, Teviti kava yagaimainea tokiyaꞌa Anumaya Kotiꞌa amisigeno Yekopu nofi veate agola kava yagaino maineno kava yagaisia tokiyaꞌa hanege hanege huno hanesigeno haꞌno ohugahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Higeno Maliaꞌa ensole kanomofe mage huno hie “Hanaꞌa huꞌna aniꞌa hisue? Nagaya velela omainoa muna mainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Higeno ensole kanomoꞌa agaife mage huno hie “Anumaya Kotina Alu Aotage Avamuꞌamoꞌa kagaite emaisigeno anale mainea Anumaya Kotina tokiyaꞌamoꞌa aiso hugatesigeka maineka nafaꞌnea ategane. Atesanana alu aotage kanale nafaꞌne mainesigeꞌya veaꞌmoꞌya ani nafaꞌnehena ‘Anumaya Kotina neꞌamo maine.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Havio neꞌitakamoꞌa, Ilisapetiꞌa, alekano lemaineanagi aipaene maineanagino ne nafaꞌne ategahie. ‘Namo a maine.’ huꞌya humainaya alekanomoꞌa aipaene mainea ikamaꞌa sikisiꞌa (6) ika agasemaine. ");
INSERT INTO knb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anumaya Kotiꞌa tagaya ohuteꞌasina yanagi afaꞌa hugahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Higeno Maliaꞌa mage huno hie “Nagaya ago Anumayamo aliꞌya muna mainoe. Hana kemoꞌa kanalelagino nagaitela falote hunategahie.” huno hie. Higeno ensole kanomoꞌa anileti neꞌataleno umaine. ");
INSERT INTO knb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maliaꞌa ani kanafina hetino aiyayeno agoꞌyafi haino Yutia kotega hanea kumate umaine. ");
INSERT INTO knb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uvayi huno Sekalaiya nopi hai faleno Ilisapetina falu fala hutene. ");
INSERT INTO knb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Falu fala huneꞌategeno Ilisapetiꞌa Maliaꞌma hia kea nehavigeno aipafima mainea nafaꞌnemoꞌa kanage kanage higeno Anumaya Koti Alu Aotage Avamuꞌmoꞌa Ilisapetina aguꞌafina hiya higeno Ilisapetiꞌa ala kefiti mage huno hie “Kagaya mukiꞌa aꞌneyaga amakaseka mainanageno Anumaya Kotiꞌa kanale muse ya kamianagika atesana nafaꞌnea kanale muse ya alimainea nafaꞌne kaipafina maine. ");
INSERT INTO knb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nagaya hanaꞌa a mainogeka Anumayaniꞌamona itaꞌamoga nagaitega neꞌane. ");
INSERT INTO knb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Havio hu falu fala hunatana kea nagesafi nehavugeno naipafinaga mainea nafaꞌnemoꞌa tusi muse nehuno kanage kanage nehie. ");
INSERT INTO knb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kagaya Maliaga Anumayamo ensole kanomoꞌa kahapaiya kea ago tamage huno falote hugahie huka ago havika kagupi maleka kametiti humainanafe Anumaya Kotiꞌa muse hisana yana ago kamine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Maliaꞌa mage huno hie “Nagu nafaꞌnemoꞌa Anumayamo agi alisaga nehigeno nagu namena alinegatia Anumaya Kotiniꞌamofena tusi muse nehue. ");
INSERT INTO knb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Muse nehuanagiꞌna nagaya afa munalagiꞌna aliꞌya munaꞌa mainoanagi agaiꞌa nagaila kalagi ainateanagiꞌna ani nafaꞌnea atesugeꞌya mukiꞌa veala meni veaꞌnene haenagama falote hisaya veaꞌnene nagaifena ‘Ma aꞌmona Anumaya Kotiꞌa tusiꞌa muse hisia ya aminea ale.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tusi tokiyaꞌa hanea kanomoꞌa nagaila kanale ya hunatene. Ani kanomo agia ‘Kanale alu aotage kano.’ maine huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Agaife ‘Ala kanoꞌni maine.’ huꞌya humai-naya veaꞌmofena menima mainaya veaꞌnene haenaga veaꞌmogamifeꞌene tusiꞌa kalagi aimaine. ");
INSERT INTO knb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ayateti tokiya aliꞌyana alimaineanagino ‘Tagaya ala veaꞌne mainone.’ huꞌya amakuꞌafinaga nehaviꞌya amaugafa aliꞌya haimainaya amakesa haviya veaꞌmogamina amanatitalene. ");
INSERT INTO knb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tokiyaꞌage kava vayala alino mopafi amataleneanagi amakima omale veaꞌmogamina amakia alisaga humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Amakuꞌafinaga amakaꞌ-nelea veaꞌmogamina kanale yana kasagoꞌya alino amamigeno amamu higeꞌya havatemainae. Mukiꞌa yaꞌamima hanea veala oꞌamamino humategeꞌya ataleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Taginagomoꞌa Apalahamuꞌene agaiꞌa nofi veaꞌnene haenagama falote hisaya veaꞌnenefe mage huno hie ‘Kalagi ailamategahue.’ huno nayona humainea kele menia agesa haviteno Isaleli kumate aliꞌya vayaꞌamogamina amaya humaine.” huno Maliaꞌa humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliaꞌa Ilisapetiꞌene tagufa (3) ika maiteno kumaꞌalega eteno umaine. ");
INSERT INTO knb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisapetina inamu ya alitegeno ne nafaꞌne atene. ");
INSERT INTO knb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Atetegeꞌya agaiꞌa kumate veaꞌnene agaiꞌa nofi veaꞌnene Anumaya Kotiꞌa kalagi aitenea yafena haviteꞌya tusiꞌa muse humainae. ");
INSERT INTO knb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Nago sota maiteꞌya ani ne nafaꞌnemona agoya anoꞌya taga hisia ya agegahune huꞌya emaineꞌya nefate hamoꞌya hugahe agia Sekalaiyaꞌe huꞌya malegahe nehageno itaꞌamoꞌa “Aꞌao agia Yoniꞌe huta malegahune.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Higeꞌya veaꞌmoꞌya mage huꞌya hae “Naꞌa higeka ani agia nemalane? Tanakai nofi veaꞌmoga-mina aniꞌa amakia omalene.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nefa tugokemoꞌa tilemainegeno agema oꞌaiya yafe avameꞌname huꞌya “Na agi malegane?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Havigageno avameꞌname huno “Avo kaesua ya namiho.” huno higeꞌya amigeno “Agia Yoniꞌe.” huno kaegeꞌya ageteꞌya vayaꞌmoꞌya “Nohaya kava hie.” huꞌya amamaꞌyoa aiye. ");
INSERT INTO knb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ani agia kaemaletegeno aupaꞌa Sekalaiya tugokemoꞌa akalo higeno avefuꞌnamoꞌa ayaꞌaya higeno kaiyekea huno Anumaya Koti agia alisaga hie. ");
INSERT INTO knb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ani kumate veaꞌmoꞌya tusiꞌa amamaꞌyo aigeꞌya ani yafena ke hu atile male hageno ani kemoꞌa mukiꞌa Yutia agoꞌya hanea kumatega ute ete higeꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Haviteꞌya veaꞌmoꞌya haviꞌya amakupi maleteꞌya mage huꞌya hae “Anumayamoꞌa aya hugahe agaiꞌene maineafe haenagaꞌa mani nafaꞌnemoꞌa hanaꞌa hisia nafaꞌne maigahie?” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","Nefaꞌa, Sekalaiyana aguꞌafi Anumaya Kotina Alu Aotage Avamuaꞌamoꞌa me hiya huno havatemainegeno Anumaya Koti aune kano kana huno mage hie “Isaleli veaꞌmogati Anumaya Kotiꞌa agaiꞌa veaꞌnele me laya huno taugafa aligatimainea yafe agia alisaga hisune. ");
INSERT INTO knb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tevitiꞌa Anumaya Kotina aliꞌya kanoꞌamo nofi anagapiti nago tokiyaꞌage kanoa taugafa aligatisia kano ali hetitene. ");
INSERT INTO knb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ani kea Anumaya Kotiꞌa nayona alu aotage aune vayaꞌamogami amavayafiti hu falote humaineane. ");
INSERT INTO knb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mage huꞌya humainae ‘Kame vayatimoꞌya ago tatafa hulinaya vayaꞌmogamiꞌene tagaife amaipa kafa henelataya vayaꞌmogami amayapitila tavaleno taugafa aligatigahie.’ ");
INSERT INTO knb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anumaya Kotiꞌa taginagomofe ‘Aigetamateꞌna tamaya hugahue.’ huno humainea yana hugahie. Alu aotage huno alino hagelafilateneafe agesa havi havi huno agekani otategahie. ");
INSERT INTO knb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Alino hagelafilatenea kemona hulokiya vaino taginagomona Apalahamufe humaineane. Nayoma humainea kea menia ani kava hisiafe hie. ");
INSERT INTO knb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Anima hulokiya vaimalenea kemoꞌa mage huno humaine ‘Nagaya kame vayatamimogami amayapitila tamavalesaga huꞌna tamaugafa aligatisugetama tamakaya kolia ohutama mukiꞌa kanafina tamahaimula hanesigetama kefo yatamia omale veaꞌnea fatago kavaꞌage hutama nagai naulela aliꞌyaniꞌa aligahae.’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","78","Humaineanagi kagaya Yoniga nafaꞌneꞌnimogae haenagaꞌa kagaifena ‘Anafinaga mainea Anumaya Kotina aune kanoꞌa mainane.’ huꞌya hugahae. Kagaya uhagoteka Anumayamo visia kana talo tala hugane. Anumaya Kotiꞌa tagaifena tusiya huno kalagi ailateneafe agaiꞌa veaꞌnea kefo yaꞌamia agetamateno ataleꞌamateno amaku amamena aligatisiafe humavelisanageꞌya havigahae. Monafinagati halemainea kanoa falote huno tagaiteꞌma esiana ani kava hugahie. ");
INSERT INTO knb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hani yapi maineta faligahe humainona veaꞌmogata ayevasa hulateno ako huta maisuna kate tategahe egahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ani nafaꞌnemoꞌa ala huno agu agesamoꞌa tokiyaꞌage higeno kaꞌme kotega umaiteno Isaleli veaꞌmogami amaulagale efalote higeꞌya agemainae. ");
INSERT INTO knb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ani kanafina nago kava kanomo agia Sisa Ogasatasiꞌe mage huno humaine “Mukiꞌa Lomu kamanimoꞌya kava yagaimainesaya kumate veala amaki me ayegeꞌya kaeho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Higeno ani kanafina hagote kanale aepa heꞌya amakia kaemainayane. Ani kanafina nago osi kava mainea kanomo agia Kuiliniusiꞌe ani kanoa Silia kotega kava yagaino nemaiya kanoe. ");
INSERT INTO knb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","4","Mukiꞌa vayala amaki aligahe hageꞌya mopa aepaꞌamilega umainae. Yosefena aginagomoꞌa Tevitiꞌma maineafe Yosefeꞌa Kalili kotega hanea kumala Nasaleti kumaꞌa ataleno Petelehemu, Tevitina atenea kumate umaine. ");
INSERT INTO knb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maliana hagemalenaya munala aipaene mainegeꞌana “Taꞌagi alisae.” huno avaleno umaine. ");
INSERT INTO knb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ani kumate umainaꞌageno inamu yana alitene. ");
INSERT INTO knb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maliaꞌa yage nafaꞌneꞌa ne nafaꞌne ateteno mukiꞌa faesia nona hiya higeno pulamakamo nopi ateteno kupi asaga huno aiteno pulamakamoꞌya kave nenaya yopafi faetene. ");
INSERT INTO knb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ani kegela sipi sipi kava vayala talapinaga maineꞌya sipi sipiyagale kava yagaiꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mainageno anile Anumaya Koti ensole kanomoꞌa egeno Anumayamo tokiya hale yamaꞌamoꞌa aivasa hulino egeꞌya ageteꞌya koli humainae. ");
INSERT INTO knb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hageno ensole kanomoꞌa mage huno hie “Kolia ohutama mainetama haviho nagaya kanale kaiyekea tamahapaigahe aliꞌna neꞌoe. Tusiꞌa muse hisaya kea tamahapaisugeꞌya mukiꞌa veaꞌmoꞌya havigahae. ");
INSERT INTO knb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Meni kegela Teviti kumatela tamaugafa aligatisia kanoa ago neꞌate. Ani kanomo agia Anumaya Kalaisiꞌe, Anumaya Kotiꞌma taugafa aligatigahema hutenea kanoe. ");
INSERT INTO knb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ani nafaꞌnea kupi aiteteno pulamakamo kave nenea yopafi faeteneanagitama mogetetama ‘Ma yafema hia yana ago falote humaine.’ hutama hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Higeꞌya mukiꞌa ensole vayaꞌyaga ani kanomote aupaꞌa melitalu huꞌya Anumaya Koti agia alisaga nehuꞌya mage huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anumayatimogae anafinaga mainane huta kagi alisaga nehunageka mopale mainaya veaꞌmogamina kaipa falu humatesana veaꞌmoꞌya amaipa falu huꞌya kanaleꞌya huꞌya maigahae.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensole vayaꞌmoꞌya neꞌamataleꞌya ikapinaga haigeꞌya sipi sipi kava vayaꞌmoꞌya ke mohu mehu huꞌya mage hae “Petelehemu vigetao Anumayamoꞌa tahapaiya yana mogegahune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Amaiyayeꞌya agegahe vaayana Maliagani Yosefegania nafaꞌneꞌania afumo kave nenea yopafi faeteteꞌana mainaꞌageꞌya mogemainae. ");
INSERT INTO knb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mogeteꞌya ensole vayaꞌmoꞌya ani nafaꞌnehema hamapaiya kea mukiꞌa veaꞌnea hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hamapaigeꞌya mukiꞌa havimainaya veaꞌꞌmoꞌya sipi sipi kava vayaꞌmoꞌyama hamapaiya kehena tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amamaꞌyo aiyanagi Maliaꞌa mukiꞌa yama humainea kavala aguꞌafi maleneno agesa havino maine. ");
INSERT INTO knb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mainegeꞌya sipi sipi kava vayaꞌmoꞌya eteꞌya kumaꞌamilega neꞌuꞌya agoꞌma hamapaigeꞌya haviteꞌya agemainaya yafena Anumaya Kotitega muse huꞌya agia alisaga hume hume vae. ");
INSERT INTO knb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yisasina atetegeꞌya nago sota maiteꞌya agoya anoꞌya tagama haya kanale* agia Yisasiꞌe huꞌya malenae. Ani agia oꞌatenegeno itaꞌamoꞌa aipa yana ohunegeno ensole kanomoꞌa ani agia malenea agie. ");
INSERT INTO knb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Itaꞌamoꞌene nafaꞌnene faeꞌana hali hutaꞌageno Moseseꞌma humainea kemo akave maleꞌana Yisasina avaleꞌana Anumaya Kotina amigahe Yelusalemua haimainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Anumaya Koti ke kaemalenaya kefina mage huno humaine “Mukiꞌa yage ne nafaꞌneyaga Anumaya Kotina alu aotage nafaꞌneꞌa maisie.” huꞌya kaemalenayane. ");
INSERT INTO knb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kaemalenayana Anumaya Kotitega muse ya amigahe haimainaꞌe. Anumaya Koti ke kaemalenaya kefina mage huno humaine “Tole nama haefatalapi tole ala namalata amigahae.” huꞌya kaemalenayane. ");
INSERT INTO knb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Ani kanafina nagola Yelusalemu mainea kanomo agia Simioniꞌe. Fatago kano maineno Anumaya Koti kea akave nemalea kanoa Isaleli veaꞌmogami amaugafa aligatisia kanomo esiafe agava mainegeno Alu Aotage Avamuꞌmoꞌa agaiꞌene maineno mage huno hapaiye “Aupaꞌa ofaligananagika Anumaya Kotiꞌma amaugafa aligatigahema hutesia kanoa ageteka faligane.” huno hapaimaineane. ");
INSERT INTO knb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Hapaimaineanagino ala mono nopi avaleno egeno anile mainegeꞌana Yisasina itaꞌafoꞌamogania mono kemo avaya ali hipoꞌya huꞌana avaleꞌana aꞌageno ani kanomoꞌa Yisasina avaleno anukilineno Anumaya Koti agia alisaga humaine. ");
INSERT INTO knb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Avalelineno Simeoniꞌa mage huno hie “Anumayamoga hagoteka nahapaimainana nafaꞌnea menia ani nafaꞌnemoꞌa tagaila taugafama aligatisia kanoa neꞌagoafe naipamoꞌa kanale hinageꞌna aliꞌya kanokamonia ‘Falio.’ hisanageꞌna falisue. ");
INSERT INTO knb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","Mukiꞌa veaꞌmogami amaulagafina anima taugafa aligatisia kanoa tavelinanagino ani kanomoꞌa kagaikaꞌa Isaleli veaꞌmogamina amakia alisaga huteno Yuta veala omainaya veaꞌmogamina aye vasa humateno kagai kea hamapaigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yisasina itaꞌafoꞌamogania Simeoniꞌa ani nafaꞌnehema hia kehena tusi anakesa havi havi humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Haꞌageno Simeoniꞌa kanale manu anamino ani nafaꞌnemo itaꞌamoꞌa, Maliafena mage huno hie “Havio Anumaya Kotiꞌa mani nafaꞌnea huteneafe mukiꞌa Isaleli kumate veaꞌnea nagoꞌamogamina ali lakatineꞌamataleno nagoꞌamogamina ali hetimategahe hutegeno emaine. Anumaya Kotiꞌa nagola alegana ya kana huno hanesiafe hutegeno emaineanagi mukiꞌa veaꞌmoꞌya agaifena ‘Kahaoteꞌyakae.’ huꞌya hugahae. Hugahayanagi mukiꞌa veaꞌmoꞌya amaku amakesa haviya kemoꞌa falote humategahie. Maliaga haenagaꞌa kagaila kahaumanamoꞌa tusiya huno halegahie.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ani mono nopina nagola Anumaya Koti aune aala maine. Ani aꞌmo agia Anaꞌe nefa agia Fanueliꞌe. Anakai nofi veaꞌnea Asa nofi veaꞌne mainae. Ani aala alekano maine. Yauva a mainea kanafina neveꞌene seveniꞌa (7) kafu mainegeno neveꞌa falitegeno megusa heno maino haimainea kafua eiti foꞌa (84) kafu maine. Ani aꞌmoꞌa mono nona oꞌataleno anifi mukiꞌa kanafina kegeꞌene felugaene Anumaya Koti agia alisaga nehuno kavela mosino Anumaya Kotitega havinegeane. ");
INSERT INTO knb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ani aꞌmoꞌa anile evaꞌyi huno Yisasina megeteno Anumaya Kotifena tusi muse huteteno mukiꞌa Yelusalemu veaꞌnea amaugafa aligatisia kanohe agava mainaya veala Yisasifena hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yisasina itaꞌafoꞌamogania mono kema hamanepaiya kavala haꞌno huteteꞌana Kalili uꞌana kumaꞌanilega Nasaleti umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yisasiꞌa ala huno tokiyaꞌage nafaꞌne maineno kanale agu agesaene nafaꞌne mainegeno Anumaya Kotiꞌa agaiꞌene maineno kayone hu yana amine. ");
INSERT INTO knb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isaleli kotega veaꞌnea mukiꞌa kafuꞌahena Anumaya Kotiꞌma amaugafa aligatimainea yafe amakesa hao hisia imu negigeꞌana* Yisasina itaꞌafoꞌamogania mukiꞌa kafuleꞌma ani imulega Yelusalemuga umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Vaꞌageno Yisasiꞌa tuelufuꞌa (12) kafuꞌa hanegeꞌana mukiꞌa kafule nehaꞌa kava huꞌana Yelusalemu ani imulega haimainae. ");
INSERT INTO knb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anima imuma kiya kanamoꞌa haꞌno higeꞌya itaꞌafoꞌamogania noꞌamilega aepa heꞌya ugahe hageno ani nafaꞌnea Yisasiꞌa oꞌuno afaꞌa Yelusalemu mainegeꞌana maiya yafena ohavinaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Nagoꞌa vayatiene katega neꞌvifi?” huꞌana nago yupa kate uteꞌana kegela agai nofi vayaꞌamogami amuꞌnoꞌamifiꞌene nefugami amuꞌnoꞌamifiꞌene atiyaꞌana oꞌagenaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Oꞌagetafa huteꞌana atiyegahe Yelusalemu alehate eteꞌana umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tagufa (3) feluga atiyegetaꞌana oꞌageꞌana ala mono nopi haiꞌana mogaꞌana anile ala humaveli vayaꞌene mopale maineno amakai ke haviteno anonaꞌamia hamavige. ");
INSERT INTO knb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hamavigegeꞌya mukiꞌa ani kema haviya vayaꞌmoꞌya kenonaꞌahena tokiyaꞌage agesama hanea yafena tusiya huꞌya amamaꞌyoa aimainae. ");
INSERT INTO knb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Amamaꞌyoa neꞌaigeno itaꞌafoꞌamogania mogeteꞌana anamaꞌyo neꞌaiꞌana itaꞌamoꞌa mage hie “Neꞌnimoga naꞌa higeka ma kavala hu nelaꞌatane? Negafaꞌene taꞌaipa havitaꞌa kanaꞌage hutaꞌa kagaifena katineꞌayoꞌe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Higeno Yisasiꞌa anakaifena “Naꞌa higetana nagaifena natineꞌayaꞌe? Nagaya Nenafa nopina aliꞌya alisua yafe nenahaiye huꞌna hua kea nohaviꞌafio?” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Higeꞌana agayama hia kea havilama ohunaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Havilama ohaꞌageno Yisasiꞌa anakaiꞌene tavino Nasaleti umaineno anakai ke haviteno akave malegeno itaꞌamoꞌa mukiꞌa humainea kavala alino aguꞌafi malene. ");
INSERT INTO knb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Malegeno Yisasiꞌa ala hutegeno kanale aku agesamoꞌa ala higeno Anumaya Kotiꞌene veaꞌmoꞌyaene tusiꞌa muse hutenae. ");
INSERT INTO knb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taipiliasi Sisaꞌa mukiꞌa Lomu veaꞌnela ala kava maine. Fifitiniꞌa (15) kafu ala kava kano maigeno ani kanafina Potiusi Pailatiꞌa Yutia kotega Gavana kava kano maigeno Helotiꞌa Kalili Kavana kava kano maigeno aganaꞌamoꞌa Filipiꞌa Ituliaene Talakonaitisiene Gavana kava kano maigeno Laiseniasiꞌa Apilini Gavana kava kano maigeno huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mainageꞌana ani kanafina Anasiꞌagi Kaiyafasiꞌagi ala mono note kava kanolata mainaꞌanagino ani kanafina Sekalaiya nafaꞌnea, Yoniꞌa kaꞌme kotega umainegeno Anumaya Kotiꞌa nago ke hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yoniꞌa ani kanafina Yotani ti agegaya kumaꞌyagale uno Anumaya Koti kea hamapaino mage huno hie “Kefo yatamihe tamakuꞌa aiyahae hutama ‘Nagoꞌene ohugahune.’ hutama vigeꞌna tina falelamatesugeno Anumaya Kotiꞌa kefo yatamia aigetamateno atalelamateno.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nayona Anumaya Koti aune kanomoꞌa, Aisaiyaꞌa, mage huno kaemaleneane “Kaꞌme kotegati nago kanomoꞌa keha keha huno mage hugahie ‘Anumayamo esia kamaꞌa ali hilato hutama ali fatago hiho. ");
INSERT INTO knb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Otufina male havatetama osi agoꞌyaene ala agoꞌyaene kafilava higeno tavino afete hanesie. Ugayagi egayagi humainea kamona ali fatago nehutama yafama hanea kaꞌene ali fatago hulama hiho. ");
INSERT INTO knb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mukiꞌa veala Anumaya Koti amaku amamena aligatisia yana agegahae.’ huno kaemaleneane.” ");
INSERT INTO knb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mukiꞌa veala Yonitega “Ti falelatesie.” huꞌya neꞌageno Yoniꞌa amakaife mage huno hamapaiye “Tamakaya osifaꞌveyagamo nafaꞌneyaga mainetama, havigeꞌage vayaꞌmogatama, Anumaya Kotiꞌma kaiyeke hulamatesigeno tamaugafa tamagata aisia kanaꞌa aupaꞌa efalote hisia yafena ‘Faletama viho.’ kea ta tamahapaimaine? ");
INSERT INTO knb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hagotetama kefo yatamihena tamakuꞌa aiyahae humainayafe tamakaitami kanale kava humainesaya yafema navelisayana tina falelamategahue. Tamakaya ‘Apalahamu nafaꞌneyaga mainone.’ hutama ohiho. Nagaya tamahanepauve Anumaya Kotiꞌa ma yafatetila Apalahamu nafaꞌneyaga kanale talo hileꞌasine. ");
INSERT INTO knb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tamakaya yosa kana humainayanagi menia Anumaya Kotiꞌa tuna alino yosamo aipalela maleneno kanale alagama oꞌayenea yosa atagino atafi hagaꞌyu huno kaegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Higeꞌya mukiꞌa veaꞌmoꞌya mage huꞌya havigae “Tagaya na kava hisune?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yoniꞌa mage huno hie “Nago kanomoga tole siotama hanesigekahena siotaꞌa omalesia kanoa nagola afaꞌa amio. Kaveꞌama hanesia kanomoꞌa aniꞌa huno kaveꞌa omalesia kanomona afaꞌa amino.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nagoꞌa vayala amaugafaleti takisi mone neꞌaliya vayaꞌmoꞌya “Ti falelatesie.” huꞌya emaineꞌya agaife mage huꞌya hae “Hulaveli kanomoga tagaya naꞌa hisune?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hageno amakaifena mage hie “Ala kava kanomoꞌma ‘Naꞌa mone aliho.’ hisia kate aliho. Afa moneꞌamienena oꞌaliho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nagoꞌa ati vayaꞌmoꞌya mage huꞌya havigae “Tagaya naꞌa hisune?” huꞌya hageno amakaifena mage hie “Tamakaya veala hamaetama moneꞌamia oꞌaliho. Havigea hutama alu moneꞌamia ali oꞌamateho. Alisaya moneꞌage muse hutama aliho.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mukiꞌa veaꞌmoꞌya Anumaya Kotiꞌa amaugafama aligatigahe hutesia kanohe “Aupaꞌa egahie.” huꞌya agava maineꞌya Yonifena tusiꞌa amaku amakesa haviꞌya “Yoniꞌa ani Kalaisiꞌe haya kano mainefi?” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hageno Yoniꞌa kenonaꞌamia mage huno hie “Nagaya titeti fale nelamatoanagino haenagama nago kano esiana Alu Aotage Avamutetiꞌene ataletiꞌene falelamategahie. Ani kanomoꞌa tusiꞌa tokiyaꞌa hanea kanogino nagaila ago nagasemaineanagiꞌna nagaya afa kano mainoanagiꞌna agai aiyale ayesuana onategahie. ");
INSERT INTO knb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Agaya sipeti ayopaꞌa alilineno vitimo anoꞌyaꞌa fu huno haletaleno alagaꞌa alino nopi halaꞌya humalegahigi anoꞌyaꞌa ata tegelege nehia atafi kaetalegahie. Ani avinamoꞌma hia kava huno veala fako faka hugahie.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mani kene alu ke alu kene Anumaya Kotina kanale keꞌa hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Helotiꞌa Gavana kanomoꞌa mukiꞌa kefo ya humainea yafeꞌene aganaꞌamo aala Helotiasina kumai heno vigeno alitenea yafeꞌene Yoniꞌa aufi ke ayesali huno humainea keleti Helotiꞌa mukiꞌa kefo ya humainea yana agaseno Yonina nofi hutene. ");
INSERT INTO knb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Nofila hu oꞌatenegeno Yoniꞌa mukiꞌa veala tina fale neꞌamategeno Yisasiꞌa anile egeno agaila fale neꞌategeno Anumaya Kotitega ke huno havigegeno ikamoꞌa aihagalo higeno Alu Aotage Avamuꞌmoꞌa nama kana huno agaitega enelavigeno ikapinagati age aino mage huno hie “Kagaya nagaiꞌni nafaꞌnemoga kagaifena aluya huno nahau nayamopafi nenagea neꞌnimoga kagaifena aluya huꞌna musekaꞌa nehue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisasiꞌa tetiꞌa (30) kafuꞌa hanegeno aliꞌyamaꞌa aepa hemaine. Mukiꞌa veaꞌmoꞌya agaifena “Yosefe nafaꞌne maine.” huꞌya hae. Yosefena nefa agia Heliꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helina nefa agia Matataꞌe. Matatana nefa agia Livaiꞌe. Livaina nefa agia Melekiꞌe. Melekina nefa agia Yanaiꞌe. Yanaina nefa agia Yosefeꞌa. ");
INSERT INTO knb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefena nefa agia Matatiasiꞌa. Matatiasina nefa agia Amosiꞌa. Amosina nefa agia Nahumiꞌa. Nahumina nefa agia Esaliꞌa. Esalina nefa agia Nagaiꞌa. ");
INSERT INTO knb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaina nefa agia Matiꞌe. Matina nefa agia Matatiasiꞌe. Matatiasina nefa agia Semeniꞌe. Semenina nefa agia Yosekiꞌe. Yosekina nefa agia Yotaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yotana nefa agia Yoananaꞌe. Yoananana nefa agia Lesae. Lesana nefa agia Selupapeliꞌe. Selupapelina nefa agia Sealitieloꞌe. Sealitielona nefa agia Neliꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nelina nefa agia Melekiꞌe. Melekina nefa agia Atiꞌa. Atina nefa agia Kosamaꞌe. Kosamana nefa agia Elamatamaꞌe. Elamatamana nefa agia Eaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eana nefa agia Yosuꞌae. Yosuꞌana nefa agia Eliesaꞌe. Eliesana nefa agia Yolimaꞌe. Yolimana nefa agia Matataꞌe. Matatana nefa agia Livaiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livaina nefa agia Simioniꞌe. Simionina nefa agia Yutaꞌe. Yutana nefa agia Yosefeꞌe. Yosefena nefa agia Yonamaꞌe. Yonamana nefa agia Eliakimaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimana nefa agia Meleaꞌe. Meleana nefa agia Menaꞌe. Menana nefa agia Matataꞌe. Matatana nefa agia Natanaꞌe. Natanana nefa agia Tevitiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tevitina nefa agia Yesiꞌe. Yesina nefa agia Opetiꞌe. Opetina nefa agia Poasiꞌe. Poasina nefa agia Salamoniꞌe. Salamonina nefa agia Nasoniꞌa. ");
INSERT INTO knb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonina nefa agia Aminatapiꞌe. Aminatapina nefa agia Atamiꞌe. Atamina nefa agia Aniꞌe. Anina nefa agia Hesaloniꞌe. Hesalonina nefa agia Pelesiꞌe. Pelesina nefa agia Yutaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yutana nefa agia Yekopuꞌe. Yekopuna nefa agia Aisakiꞌe. Aisakina nefa agia Apalahamuꞌe. Apalahamuna nefa agia Telaꞌe. Telana nefa agia Nahoꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahona nefa agia Selukiꞌe. Selukina nefa agia Leuꞌe. Leuna nefa agia Pelekeꞌe. Pelekena nefa agia Epeꞌe. Epena nefa agia Selaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selana nefa agia Kainaniꞌe. Kainanina nefa agia Apakasatiꞌe. Apakasatina nefa agia Siemiꞌe. Siemina nefa agia Noaꞌe. Noana nefa agia Lamekaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekana nefa agia Metuselaꞌe. Metuselana nefa agia Enokiꞌe. Enokina nefa agia Yaletiꞌe. Yaletina nefa agia Mahalaleliꞌe. Mahalalelina nefa agia Kenaniꞌe. ");
INSERT INTO knb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenanina nefa agia Enosiꞌe. Enosina nefa agia Setiꞌe. Setina nefa agia Atamuꞌe. Atamuna nefa agia Anumaya Kotiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Anumaya Kotina Alu Aotage Avamuꞌamoꞌa Yisasina aguꞌafi hiya higeno Yisasiꞌa Yotani tina atalenoꞌma neꞌviana Alu Aotage Avumuꞌmoꞌa veaꞌne omai kaꞌme kotega avaleno motegeno fotiꞌa (40) yupa mainegeno Sataniꞌa Yisasina “Havi kava ho.” huno ayevataga humaine. Ayevataga huge huge nehigeno Yisasiꞌa kavela ani fotiꞌa (40) kanafina oneno afaꞌa mainegeno tusiꞌa agatemaine. ");
INSERT INTO knb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sataniꞌa Yisasife mage hie “Kagaya Anumaya Koti nafaꞌnema mainenukahena ma yafana hapaigeno maya hapaeno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Higeno Yisasiꞌa kenonaꞌa mage huno hapaiye “Anumaya Koti avopiti kemoꞌa mage humaineane ‘Vayaꞌmoꞌya mayaꞌage nesayana kanaleꞌya huꞌya omaigahae.’ huno humaineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sataniꞌa Yisasina anale avaleno viaꞌyamo aupaꞌa mukiꞌa ma mopafi hanea ala kumaꞌyagaene afenoꞌyamaꞌaene avelimaine. ");
INSERT INTO knb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aveliteno Sataniꞌa agaifena mage hie “Mani kanale kumaꞌyaga kavama yagaisana tokiya kamigahue. Ani kava yagaisia tokiyaꞌa nagaiꞌni ya haneanagiꞌna nagaya nahaisia kanomona afaꞌa amigahue. ");
INSERT INTO knb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kagayama nagaifema ‘Tusiꞌa ala kano mainane.’ huka naiyafi ape huka ala nagi namitesanageꞌna ani kavama yagaisana tokiya kamigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yisasiꞌa kenonaꞌa mage huno hie “Anumaya Koti avopi kaemalenaya kemoꞌa mage huno humaineane ‘Anumaya Kotikamona agaiꞌagefe ‘Tusiꞌa ala kano maine.’ huka kagesa havi havi huka agia alisaga huka agai aliꞌyamaꞌage alio.’ huno humaineane.” huno hapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sataniꞌa Yisasina Yelusalemu avaleno ala mono nomo agotofule ateneno mage huno hapaiye “Kagaya Anumaya Koti nafaꞌnema mainenukahena ma nomo agotofuleti mopafi asaga hulavio. ");
INSERT INTO knb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Anumaya Koti avopiti kemoꞌa mage humaineane ‘Anumaya Kotiꞌa ensole vayaꞌahe ‘Kava hiho.’ huno humatesigeꞌya amayateti kavalesaga hulisageka tavisanageno yafatela kaiyamona aye kofa ohugahieꞌ huno humaineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Higeno Yisasiꞌa kenonaꞌa mage huno hie “Anumaya Koti avopiti kemoꞌa mage humaineane ‘Anumaya Kotikamo tokiya ayevataga ohuo. Afa yafe ‘Tokiya kava huo.’ huka ohuo.’ huno humaineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Higeno Sataniꞌa mukiꞌa alu ya alu ya huno ayevataga hugeteana higeno Yisasina ataleno nagoꞌa kanale ayevataga hisia kanalefe agava maine. ");
INSERT INTO knb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yisasiꞌa Alu Aotage Avamuꞌmo tokiyaꞌaene Kalili kotega egeno agai avagemoꞌa ani kotega ute ete higeꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mono noꞌyagaꞌamifi huge amavelige higeꞌya mukiꞌa veaꞌmoꞌya agai agi alisaga humainae. ");
INSERT INTO knb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yisasiꞌa Nasaleti maino ala humainea kumate uno Sapati yupa mukiꞌa kanale nehia kava huno mono nopi hai faleno Anumaya Koti ke hapaligahe hetimaine. ");
INSERT INTO knb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hetimainegeno Anumaya Kotina aune kanoꞌamo Aisaiya kaemalenea autaꞌma aliꞌya amigeno vakayeno hapalino autaꞌmafiti kea mage huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anumayamoꞌa Alu Aotage Avamuꞌamona nagaite hutegeno nagaiꞌene emainegeꞌna mukiꞌa yamaꞌa omale veaꞌmogamina agaiꞌa kanale ke hamapaisuafeꞌene kina humainaya veaꞌne kalu hematesuafeꞌene amaulaga asu humainaya veaꞌne aligali humatesuafeꞌene amakaiꞌami amaugafahe tusiꞌa kalagi aiꞌya mai haviya humainaya veaꞌne amaugafa aligatisuafeꞌene Anumaya Kotiꞌa tokiyaꞌa namiteno hunategeꞌna emainoe. ");
INSERT INTO knb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nagaya menia ma kanafina Anumayamoꞌa tamakaife kalagi ailamatesia kanaꞌa ago efalote humaine huꞌna tamahapaisuafe nagaila hunategeꞌna emainoe.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Huteno avona alino ailileteno kava kanoa amiteno mopale mainegeꞌya mukiꞌa mono nopi mainaya veaꞌmoꞌya Yisasi aulagafi aulu heꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mainageno aepa heno mage huno hie “Menia ma ma kaemalenea kea tamakai tamakesale ago egetama havigeno ago efalote huno tamage hie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Higeꞌya mukiꞌa veaꞌmoꞌya “Tamage hane.” huꞌya avayafitiꞌma hia ke haviteꞌya muse haya kehe amakesa havi havi huꞌya mage hae “Mamona Yosefe nafaꞌnefi?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hageno Yisasiꞌa amakaife mage huno hie “Tamage, tamakaya ma ma haya kea nagaife mage hugahae ‘Tota kanomoga kagaika kaugafa hagoteka ali hilato hugeta agamano. Kapaneamu kumate ‘Naꞌa maꞌa kava hie.’ hageta havimainona yana male kagaika kumate hugeta agamano.’ hutama hugahae. ");
INSERT INTO knb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tamagelafa huꞌna tamahanepauve nagola Anumaya Koti ke hamanepaiya kanomoꞌa agaiꞌa vayaꞌamogami amuꞌnopi mainegeꞌya veaꞌamoꞌya ‘Ala kanomo kegi havigetao.’ huꞌya ohugahae. ");
INSERT INTO knb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Nagaya tamage huꞌna tamahanepauve nayona Ilaiyaꞌma mainea kanafina tagufa (3) kafugi sikisiꞌa (6) ikanagi huno kola oꞌaigeꞌya ani Isaleli kotega mainaya veaꞌmoꞌya tusiꞌa amakateno kaveꞌamia omalene. Ani kanafina mukiꞌa megusa aꞌneyaga Isaleli kotega mainayanagi Anumaya Kotiꞌa agaiꞌa aune kanomona, Ilaiyana, ani megusa aꞌnele hu oꞌatenegi nago Salefati kumate mainea megusa aꞌmote hutegeno umaine. Ani kumala Saitoni kotega hane. ");
INSERT INTO knb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nayona Ilaisaꞌma mainea kanafina mukiꞌa fugitaya amakemainea veala Isaleli kotega mainayanagi ani veaꞌnefitila nagoꞌa veala kanale hu oꞌamatenegi alulega mainea kanoa, Nemaniꞌe, Silia mainea kanomona agaiꞌage fugitayama agemainea yana kanale huteneane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Higeꞌya ani kea haviteꞌya mukiꞌa mono nopi mainaya vayaꞌmoꞌya tusiya huꞌya ke vaiꞌya hamai vaitenae. ");
INSERT INTO knb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hamai vaiteteꞌya hetiꞌya Yisasina atafa huꞌya kumapiti avayu huꞌya avaleꞌya ani kumaꞌma kimalenaya agoꞌyale haiteꞌya ani agoꞌyafiti aye lakatiꞌya hagaꞌyu hutalegahe humainae. ");
INSERT INTO knb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hayanagi Yisasiꞌa mukiꞌa veaꞌne mainaya amuꞌnopiti afaꞌa amataleno ago alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yisasiꞌa nagola Kalili hanea kumate Kapaneamu taviteno Sapati yupa Anumaya Koti ke hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hamapaigeꞌya agai kemoꞌa tokiya yamaꞌa hanea kanomo ke kana hia yafe tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anile nago kanoa Kefo Avamuꞌmoꞌa aguꞌafi mainea kanoa mono nopi maineno “Avovo.” huno alakenake humaine. ");
INSERT INTO knb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Mage huno hie “Avo Yisasiga Nasaleti nafaꞌnemoga na ya hulategane? Tagaila tahaeka falilategahe emainano? Nagaya kagaila ago kagemainoe kagaya kanale alu aotage kanoa Anumaya Kotiꞌa hugatenea kano mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Higeno Yisasiꞌa Kefo Avamufe tokiyaꞌage ke huno mage hie “Ke ohuka afaꞌa maiyo. Mani kanoa ataleka agusafinagatila hatilavio.” huno higeno ani Kefo Avamuꞌmoꞌa mukiꞌa veaꞌne mainaya amuꞌnopi ani kanomona mopafi ayelakatino agoꞌya fai neꞌateno agusafitila hatilavino vianagi ani kanomona ali haviya hu oꞌatene. ");
INSERT INTO knb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hatilavigeꞌya mukiꞌa veaꞌmoꞌya tusi amamaꞌyo aigeꞌya huge havige huꞌya mage hae “Naꞌane ke hie? Tusi tokiyaꞌaleti tokiyaꞌage ke higeꞌya Kefo Avamuꞌyagamoꞌya agai ke hipoꞌya huꞌya hatilavie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hageno Yisasiꞌma hia kavaꞌmo avagemoꞌa mukiꞌa ani kumaꞌyagalega ute ete higeꞌya mukiꞌa veaꞌmoꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Yisasiꞌa hetino mono nona ataleno Saimonina nomaꞌafinaga umainegeno Saimonina aꞌamona itaꞌamo alekanoa tusiꞌa amukonako kali alino mainegeꞌya Yisasife “Melika kanale huto.” huꞌya havigageno avate uno ani kaliꞌahe ke amakigeno ani kaliꞌamoꞌa ataleno vigeno aupaꞌa ani alekanomoꞌa hetino kavela amine. ");
INSERT INTO knb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ani unena yagemoꞌa tavi falegahe higeꞌya mukiꞌa ani kumate veaꞌmoꞌya vayaꞌamima alu kali alu kali alimainaya veala amavaleꞌya Yisasite ageno mukiꞌa nagoke nagokeꞌmogamina amaugafale aya maleno kaliꞌamia alino kanale humatene. ");
INSERT INTO knb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Alino kanale humatetegeꞌya nagoꞌa veala amakusafiti Kefo Avamuꞌmoꞌya amataleꞌya neꞌuꞌya ala kefiti mage huꞌya hae “Kagaya Anumaya Kotina neꞌamoga mainane.” huꞌya hageno Yisasiꞌa ke neꞌamamakigeꞌya agaife Anumaya Kotiꞌa “Amaugafa aligatigahie huno hutenea kanoa ma maine.” huꞌya havilinayafe Yisasiꞌa “Nagoꞌene osi kea ohiho.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Natena tani ko tigeno Yisasiꞌa amataleno veaꞌne omai kotega umainegeꞌya mukiꞌa veaꞌmoꞌya agaifena atiyeꞌya ayeꞌya agaite uvaꞌyi huꞌya mage huꞌya hae “Tataleka oꞌuka tagaiꞌene maisane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hayanagi Yisasiꞌa mage huno hamapaiye “Nagaila Anumaya Kotiꞌa kava yagaisia kanale keꞌa alu kumate kumate ute ete huꞌna hamapaigahue. Anumaya Kotiꞌa ani aliꞌyatefe hunategeꞌna emainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yisasiꞌa mukiꞌa Yutia kumaꞌyagalega ute ete huno mono nopi Anumaya Koti kea hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nago yupa Yisasiꞌa Kenesaleti* tikotumo agegayalega hetimainegeꞌya mukiꞌa veaꞌmoꞌya Anumaya Koti ke havigahe meligovegave hutenae. ");
INSERT INTO knb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hutageno Yisasiꞌa ageana tole tipi kale ti agegayalega avayu huꞌya maleteꞌya noyame kuꞌyama nehaya vayala ani tipi kalea ataleꞌya kukonago sese humainae. ");
INSERT INTO knb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sese nehageno Yisasiꞌa Saimoni tipi kalefi haisaga humaino maineno mage hie “Saimoniga ti agegaya neꞌataleka osiꞌa tipi vuo.” huno hapaiteno ani tipi kalefi haino mopale maineno mukiꞌa alitalu humainaya veaꞌmogamina kea hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hamapaiteno Saimonife mage hie “Tipi kalekaꞌa ti amuꞌnopi ayetufeka kotumona augelifi kukonagokaꞌa ataleka noyame kuꞌya huo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Higeno Pitaꞌa Yisasife mage huno hapaiye “Ala kanomogae tagaya kegela noyame kuꞌya huge hugetonana noyamea oꞌalunageno ko timaine. Oꞌalinonagi kagayama hana kemo akave maleꞌna kukonagona malegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Ani kukonagona tipi maleana kasagoꞌya noyame hai falegeno kukonagomoꞌa kanaꞌage huno atalaga hisia kava higeꞌya nago tipi kalefi mainaya vaya amakaiꞌene tokaeꞌya aliꞌya neꞌaliya vayafe amayateti avameꞌname huꞌya “Etama taya hiho.” huꞌya hageꞌya emainae. Eteꞌya ani tole lipi kalelatapina noyamea aliꞌya male havatageno kanaꞌage huno hapaꞌnesia kava humaine. ");
INSERT INTO knb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni Pitaꞌa ani yana ageteno Yisasina aiyafi aleꞌya ayemaineno mage hie “Anumayamogae nagaya kefo kava nehua kano mainogi nagaila nataleka vuo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimoniꞌene agaiꞌaene mainaya vayaꞌmogamina noyamemoꞌma havateno hiya hia yafena tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimoniꞌene aliꞌya neꞌaliꞌa kanolatana, Sepeti nafaꞌnelatane, Yemesiꞌene Yoniꞌene aniꞌa huꞌana tusiꞌa anamaꞌyo aiꞌageno Yisasiꞌa Saimonife mage hie “Menia kolia ohuo. Noyame kuꞌyama hana avamete Anumaya Kotiꞌa agola maisaya hamaimula amamigahe veaꞌne kuꞌya hugane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Higeꞌya tipi kalea aliꞌya kahaepatega nemaleꞌya mukiꞌa yaꞌyaga neꞌataleꞌya Yisasina akave umainae. ");
INSERT INTO knb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nagi nago yupa Yisasiꞌa nago ala kumate mainegeno nago fugitayamo augafa alino haꞌyagino atalako humainea kanoa maineno Yisasina ageteno agaitega eno mopafi agoꞌya ayemaineno mage huno havige “Anumayamoga kahaisigekahena nagaila ago alika hilato hunatateꞌasine.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Higeno Yisasiꞌa ayana haꞌyo huno augafale avate hulineno mage huno hie “Nagaya nahaigeꞌna kaugafamoꞌa menia kanale hino huꞌna nehue.” huno higeno anile aupaꞌa kaliꞌa haꞌno hutene. ");
INSERT INTO knb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yisasiꞌa mage huno hapaiye “Ali hilato hugatoa yafena nago kanoa haꞌopaika mono nopi kava kanomote uka mukiꞌa veala kalikaꞌama kanale hugatoa kema havinuꞌyahena mono nopi kava kanomoꞌa kaugafa kamota huno kagetesigeka kaugafama ali hilato hugatoa yafena Moseseꞌma ‘Ma yama Anumaya Kotina amio.’ huno humainea yana Anumaya Kotitega atalo.” huno tokiyaꞌage ke hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hapaiyanagi kalima alino kanale hutea kemoꞌa ute ete higeꞌya kasagoꞌya veaꞌmoꞌya haviteꞌya “Agai ke havita kalitia alino kanale hulatesie.” huꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Emainayanagi Yisasiꞌa ani veala neꞌamataleno veaꞌne omai kotega umaineno Anumayamotega ke huno havige havige huno maine. ");
INSERT INTO knb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nagi nago yupa Yisasiꞌa humaveli hamaveli nehigeꞌya mukiꞌa Falasia vayaꞌene kahegi kemo aepaꞌama havilinaya anagaꞌene Yelusalemutiꞌene mukiꞌa Kalili kumaꞌyagaletiꞌene Yutia kumaꞌyagaletiꞌene eꞌya avate mopale maineꞌya havimainageno kali veaꞌne kanale humatesia tokiyaꞌa Anumayamoꞌa amigeno Yisasipi hane. ");
INSERT INTO knb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Anile nagoꞌa vayaꞌmoꞌya nago kanomona aiya aya falimainea kanoa hagifanale faeno mainegeꞌya avaleꞌya “Yisasi avate motegahune.” huꞌya hayanagi kasagoꞌya veaꞌmoꞌya hiya humainaya yafe kana omalegeꞌya amega nogatofule haiteꞌya hanae yosa alisaga humaleneꞌya ani hagifanale faeno mainea kali kanoa mukiꞌa veaꞌmogami amuꞌnopi atalageno Yisasi avate tavimaine. ");
INSERT INTO knb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tavigeno Yisasiꞌa “Ma vayaꞌmoꞌya ago nagaife haviꞌya amakupi maleꞌya amametiti nehae.” agesa haviteno kali kanohe mage huno hie “Nenafuga kahanepauve nagaya ago aigekateꞌna kefo yakaꞌa atale negatoe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Higeꞌya kahegi kemo havilinaya anagaꞌene Falasia vayaꞌene haviteꞌya amakaiꞌami amakuꞌafiti mage huꞌya hae “Mani kanoa Anumaya Kotife huhaviya hutea kanoa taꞌe? Nagoꞌa vayaꞌmoꞌya aigetateꞌya kefo yatia atale otategahayanagi Anumaya Kotiꞌa agaiꞌage aigetateno kefo yatia atalelatesia kano maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hageno Yisasiꞌa amakupi haya kea ago nehavino mage huno hie “Naꞌa higetama mani kea tamaku tamakesafinaga nehae? ");
INSERT INTO knb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nagayama huteꞌna hisua kea hana kemo kanaꞌage humaine? ‘Aigekateꞌna kefo yakaꞌa atalenegatoe.’ huꞌna hisua kemopi? Kali kanomofe ‘Hetika ka vuo.’ huꞌna hisua kemoꞌe? ");
INSERT INTO knb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nagayama ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna ma mopale maineꞌna aigetamateꞌna kefo yatamia atalelamatesua tokiyaꞌnia hane hutama havisaya yafe nago kava huꞌna tamaveligahue.” huno kalima neꞌalia kanomofe mage huno hie “Hetika hagifanaka neꞌalika nokalega vuo.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Higeno ani kalima neꞌalia kanomoꞌa aupaꞌa mukiꞌa veaꞌmogami amaulagafi hetino faeno nemaiya hagifanaꞌa neꞌalino Anumaya Koti agia alisaga hume hume nomaꞌalega umaine. ");
INSERT INTO knb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na kava higeꞌya mukiꞌa alitalu humainaya veaꞌmoꞌya ageteꞌya tusi amamaꞌyo aigeꞌya Anumaya Koti agia alisaga nehuꞌya mage huꞌya hae “Meni kanalela aluꞌa ya neꞌagone.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Anile neꞌamataleno vilegati nago kanoa agia Livaiꞌe musufa huno vaya amaugafaleti takisi mone aliliteno nehia kanoa opisi nomaꞌale mopale mainegeno Yisasiꞌa ani kanoa mogeteno mage huno hie “Kagaya nakave eno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Higeno Livaiꞌa hetino mukiꞌa yamaꞌa neꞌataleno Yisasina akave umaine. ");
INSERT INTO knb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livaiꞌa nomaꞌafina tusiꞌa kave Yisasina kaetegeꞌya mukiꞌa musufa huꞌya amaugafaleti takisi mone neꞌaliya vayaꞌene nagoꞌa vayaꞌene ani nopi Yisasiꞌene tokaeꞌya maineꞌya kavela nemainae. ");
INSERT INTO knb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nemainageꞌya Falasia anagaꞌene kahegi kemo havilinaya anagaꞌene Yisasiꞌenema tokaeꞌya nemaiya anagahe kalugalu ke nehatageꞌya mage huꞌya nehae “Naꞌa higetama tamakaya amaugafaleti takisi monema neꞌaliya vayaꞌene kefo yama nehaya vayaꞌenena kavela maitama nenae?” huꞌya hamavigae. ");
INSERT INTO knb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hageno Yisasiꞌa kenonaꞌamia mage huno hamapaiye “Kalima noꞌaliya veaꞌnea tota kanomotega oꞌugahagi kali veaꞌmoꞌyage tota kanomotega ugahae. ");
INSERT INTO knb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","‘Fatago veaꞌne mainone.’ huꞌya nehaya veaꞌnehena ke hugahe omenogi nagaya kefo yama nehaya veaꞌnehe ‘Tamakuꞌa aiyahae hiho.’ huꞌna hamapaigahe emainoe.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vayaꞌmoya mage huꞌya nehae “Yoniꞌenema tokaeꞌya nemaiya vayaꞌene Falasia vayaꞌene mukiꞌa kanalela kavela mosiꞌya Anumayamotega havige havige huꞌya nemaiyanagi kagaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya mukiꞌa kaveꞌene tiꞌene nege nege nehae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Hageno Yisasiꞌa mage huno hie “Nago kanoa aꞌama faiꞌya esakenoꞌa avaya hesia imu kisia yupa vayaꞌamoꞌyaene toꞌkaeꞌya mainesigeꞌya ani vayaꞌyaga kavela mosisafio? Aꞌao moꞌosigahayanagiꞌya haenagaꞌa alu kana falote hisigenoꞌa kame vayamoꞌya aꞌma alisia kanoa atafa huꞌya amakaipiti avaletalesageꞌya ani kanale mainesaya vayaꞌamoꞌya hamau huteteꞌya mosigahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisasiꞌa nago avame kea mage huno hamapaimaine “Nago kanomoꞌa haegafa kena alino laga huteno atafa kenalela maleno ohatigahie. Maleno hatisiana haegafa kena laga huno ali haviya hugahie. Haegafa kenamoꞌa atafa kenalela nagoke avamete ohune. ");
INSERT INTO knb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nago kanomoꞌa haegafa nofi alagamo timaꞌa* atafa mememo augafa ti keꞌayopina takino oꞌvaigahie. Takino vaisiana timaꞌamoꞌa kaꞌnuka hesigeno ti kena falo huno takilavinageno ti kena ali haviya hugahie. ");
INSERT INTO knb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Naꞌa hugahiafe haegafa nofi alagamo timaꞌa hefino haegafa meme augafamo ti keꞌayopi takino vaimaleno. ");
INSERT INTO knb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kaꞌnuka hemainea nofi alagamo timaꞌa nemainaya veaꞌneꞌmoꞌya haegafa nofi alagamo timaꞌahena ohamaigeꞌya mage huꞌya hae ‘Kaꞌnuka hemainea nofi alagamo timaꞌahena nelahaiye.’ huꞌya humainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nago Sapati kanale Yisasiꞌene agaiꞌaene tokaeꞌya nemaiya anagaꞌaene nago atili hoya amuꞌnopi neꞌuꞌya anagaꞌamoꞌya nago atilia kaleꞌya atafaiꞌya nae. ");
INSERT INTO knb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nenageꞌya nagoꞌa Falasia vayala anile mainaleti ageteꞌya mage huꞌya hae “Sapati kanama katilemalenaya yana naꞌa higetama ani kavala nehae?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hageno Yisasiꞌa mage huno hie “Tamakaya Tevitiꞌene avagi huꞌya umainaya vayaꞌene amakatemainaya yafena hapalitama ohavinafio? ");
INSERT INTO knb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Amakategeno Tevitiꞌa Anumaya Koti nopi hai faleno ageana ‘Afa vayamoꞌya onesageꞌya mono nopi kava vayaꞌmoꞌya amakaiꞌamige negahae.’ huꞌya katilemalenaya maya Anumaya Koti aulagale malenaya kaihame alino neneno avagi huꞌya emainaya vayala amamine. Tamakaya ani kea hapalitama ohavinafio?” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yisasiꞌa mage huno hie “Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna Sapati kana kava yagaimainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nago Sapati yupa Yisasiꞌa mono nopi haino mono ke hamanepaigeno nago kanoa tamaga aya avayu hulavimainea kanoa anile maine. ");
INSERT INTO knb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mainegeꞌya nagoꞌa kahegi kema havilinaya anagaꞌene Falasia vayaꞌene Yisasiꞌa havi kavaꞌma hisiafene huꞌya ati neꞌayeꞌya “Yisasiꞌa Sapati kanale ani kali kanoa alino kanale hutesifi huotesifi?” huꞌya Yisasina amata huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mainageno Yisasiꞌa ani vayaꞌmoꞌyama haviya amaku amakesa ago haviteno ayama avayu hulavimainea kanomofe mage huno hapaiye “Hetika vayaꞌmogami amuꞌnoꞌamifi me hetio.” huno higeno hetino anile me hetimaine. ");
INSERT INTO knb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Me hetimainegeno Yisasiꞌa amata huꞌya maiya vayafe mage huno hie “Tamahavinegoe Sapati yupahe mono kemoꞌa naꞌane ke nehie? Sapati yupa veaꞌne ali hilato humatesifi alino haviya humategahie ifi Sapati yupa veaꞌnea amavaleno avina me mategahafi ifi veala tavata hamaegahie?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hamavigeteno mukiꞌa vayaꞌmogami amaulagafi ageno ute ete nehuno kali kanomofe mage huno hapaiye “Kayana aipi huo.” higeno aipi hiana ayamoꞌa ago kanale hute. ");
INSERT INTO knb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hutegeꞌya amata huꞌya maiya vayaꞌmoꞌya tusiya huꞌya amaipa kafa heteteꞌya “Yisasina na kava hutesune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nago yupa Yisasiꞌa Nefatega nunamu huno havigegahe agoꞌyafi haino ani kegela Anumaya Kotitega ke huno havige havige nehigeno kola ali halemaine. ");
INSERT INTO knb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kola alino halegeno agaiꞌenema tokaeꞌya nemaiya anagaꞌamofe ke higeꞌya ageno ani anagapiti tuelufuꞌa (12) anaga hapalimateteno “Nagai kema nehavigeꞌna hunelamatoa anagala Aposolo anaga maiho.” huꞌna hapalinelamatoe. ");
INSERT INTO knb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Anima agaiꞌene tokaeꞌya nemaiya anagaꞌamogami amakia Saimoniꞌe kanomo agia Yisasiꞌa Pitaꞌe huno malene. Pitana aganaꞌamoꞌa Etaluꞌe, Yemesiꞌe Yoniꞌe Filipiꞌe Patolomayuꞌe Matiuꞌe, Tomasiꞌe, Yemesiꞌa Alafiusi nafaꞌne Saimonina hamoꞌamoꞌe nago agia Selotiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yutasiꞌa Yemesi nafaꞌne, Yutasi Isakaliotiꞌa haenaga ani kanomoꞌa Yisasina agesi huno kame hutesia kanoe. ");
INSERT INTO knb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Yisasiꞌa agaiꞌenema tokaeꞌya nemaiya anagaꞌaene tavino otufi hetimainegeꞌya nagoꞌa kasagoꞌya agai kema nehaviya veaꞌnea Yutiatiꞌene Yelusalemutiꞌene hage limo agegayalega tole kumatalana Taiyaene Saitonitiꞌene kasagoꞌya vea elitalu huꞌya agai kea nehaviꞌya “Kalitia alino kanale hulatesie.” huꞌya emainageno Yisasiꞌa Kefo Avamuꞌyaga veaꞌmogami amakupiti amanati neꞌataleno alino kanale humatene. ");
INSERT INTO knb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tokiyaꞌamoꞌa efalote higeno mukiꞌa veaꞌnea alino kanale humategeꞌya mukiꞌa veaꞌmoꞌya ageteꞌya augafale avate hugahe hae. ");
INSERT INTO knb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisasiꞌa agesaga huno agaiꞌene toꞌkaeꞌya nemaiya anagaꞌamogamina neꞌamakeno mage huno hie “Mukiꞌa yatamima omalenaya veaꞌnemogatama Anumaya Kotiꞌa tamakaila kava yagai nelamatea yafe musena hiho. ");
INSERT INTO knb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tamakaila menia tamakaꞌma nelea veaꞌmogatama haenagaꞌa nesageno tamamu hisiafe musena hiho. Menia tamakaya avi neꞌataya veaꞌnemogatama haenagaꞌa kigi hisayafe musena hiho. ");
INSERT INTO knb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemonima nakave nemalayafe veaꞌnemoꞌya amaipa kafa helamateꞌya ‘Aluꞌale maiho.’ hulamateꞌya kamuge vailamateꞌya ‘Otahaiya kagi hane.’ huꞌya hisagetamahena tamakaya ani kanafina afaꞌa muse hutama maiho. ");
INSERT INTO knb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aniꞌama hulamatenaya veaꞌneꞌmogamina amakinagomoꞌya nayona Anumaya Koti amaune vayaꞌmogamina aniꞌa huꞌya humatenayane. Aniꞌama hisaya kanafina haenagaꞌa ikapinaga umainetama anonaꞌa kasagoꞌya ya alisayafe tamaipa kanale hutama muse hiho. ");
INSERT INTO knb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Avoꞌnio mukiꞌa yatamima hanea veaꞌneꞌmogatama tamakaya kaꞌye ho. Tamaipa kanale hisia yana hai ali mainae. ");
INSERT INTO knb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Avoꞌnio tamakaya menia mukiꞌa yama nelamamuꞌma nehaya veaꞌmogatama tamakaya kaꞌye ho. Haenagaꞌa tusiꞌa lamakategahie. Avoꞌnio menia kigima hutama nemaiya veaꞌnemogatama kaꞌye ho. Haenagaꞌa tamahau nelagitama avia ategahae. ");
INSERT INTO knb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Avoꞌnio veaꞌmoꞌya ‘Ala vaya mainae.’ huꞌya tamaki alisaga nehisaya anagala kaꞌye ho. Aniꞌama humainaya veaꞌnemogamina amakinagomoꞌya nayona aniꞌa huꞌya havigeꞌage amaune vayamogami amaki alisaga humainayane.” ");
INSERT INTO knb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nagai kema havisaya veaꞌmogatama ‘Kame veaꞌnetamimofena tamahau tamayamopafi tamahaino. Amaipa kafama henelamataya veaꞌnemogamina kanale kava humateho.’ ");
INSERT INTO knb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","‘Anumaya Kotiꞌa ali haviya hugatesie.’ huꞌya nehaya veaꞌmogamife ‘Kanale ya amamio.’ huka Anumayamotega ke huka havigo. Hu haviya hunegatesaya veaꞌnemogamifena ‘Amaya huo.’ huka Anumayamotega havigo. ");
INSERT INTO knb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nago kanomoꞌma kagalamesaleꞌma kaikolisigekahena ‘Nago kaiyaga nagalamesaleꞌene naikolio.’ hisanageno kaikolisie. Nago kanomoꞌma ala yasi siotakama musufama alisigekahena nago siotakaꞌa afaꞌa kaufila ohuo. ");
INSERT INTO knb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nago kanomoꞌma ‘Nago yakahema namio.’ hisigekahena afaꞌa hagaꞌyu huka amio. Kagai yama alimainesia kanomofena ‘Eteka namio.’ huka tokiya kea hu oꞌato. ");
INSERT INTO knb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Veaꞌneyagahe ‘Ma kava hulatesae.’ hutama hisaya kavala ani kavakeꞌya alu veaꞌnea humateho. ");
INSERT INTO knb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Veaꞌmoꞌya hamau amayamopafi tamakaifena nehamainagetamahena tamakaya aniꞌa hutama amakaifena tamahaisia yana afa yanagi anonaꞌa oꞌaligahae. Kefo yama nehaya veaꞌnemoꞌya aniꞌa huꞌya amahau amayamopafima amahaiya veafena nehamaiye. ");
INSERT INTO knb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kanale kavaꞌma hulamataya veaꞌnemogamina aniꞌa hutama kanale ya humatesayana ani yana afa yanagitama anonaꞌa oꞌaligahae. Kefo yama nehaya veaꞌnemoꞌya aniꞌa kavala nehae. ");
INSERT INTO knb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‘Eteno namigahie.’ hutama hutetama amisaya veala yoka amisayana afa yanagitama anonaꞌa oꞌaligahae. Kefo yama nehaya veaꞌmoꞌya nagoke augafa ya alisayafe kefo yama nehaya veaꞌneꞌamimona yoka neꞌamamiye. ");
INSERT INTO knb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anumaya Kotiꞌa kefo veaꞌnemoꞌyaene agaifena musema nohaya veaꞌnemogamifeꞌene kayone huneꞌamatea yafe tamakaya ani kava hutama kame veaꞌnetamihena tamahau tamayamopafi nelamahaisigetama kanale kavakeꞌya humateho. ‘Anonaꞌa nago yana oꞌaligahune.’ hutama hamaisia yana amamiho. Naꞌama hisayana haenagaꞌa Anumaya Kotiꞌa kasagoꞌya anonaꞌa tamamisigetama ala Anumaya Koti kana hutama nafaꞌneyagaꞌa maigahae. ");
INSERT INTO knb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nelamafaꞌma hauma huneꞌamatea kavala aniꞌa hutama tamahauna humateho.” ");
INSERT INTO knb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nelamafufena ‘Naꞌa maꞌa hana kano mainane.’ hu oꞌateho. Aniꞌama ohisagenoꞌa Anumaya Kotiꞌa tamakaifena ‘Havi kava haya veaꞌne mainae.’ huno hu otamategahie. Nelamafugamina kaiyekema hu oꞌamatesayana Anumaya Kotiꞌa tamakaila kaiyekea hu otamategahie. Haviya hulamatenesia kanomona aigeꞌatetama kefo yamaꞌa ataleteho. Aniꞌa hisagenoꞌa Anumaya Kotiꞌa kefo yatamia aigetamateno atalelamategahie. ");
INSERT INTO knb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nelamafugamima amamisaya kavala Anumaya Kotiꞌa aniꞌa huno lamamigahie. Tamakaila kutamifina aye talako huno havatesia kava huno ku ailamategahie. Ma mopaleꞌma nelamafugamima humatesaya kavala Anumaya Kotiꞌa tamakaila ani kava hulamategahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nago avame kea mage huno hie “Nagoꞌma aulaga asu humainesia kanomoꞌa nago aulaga asu humainesia nefaluna avaleno kanale vaiyesaꞌafi? Aꞌao avalenoꞌma vaiyesiana tolemogania komufi asaga hulavigaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nago sugulufi mainesia nafaꞌnemoꞌa huveli kanoꞌamona oꞌagaseneanagino mukiꞌa huvenelia yamaꞌa havilama hulineno huvelimainea kano kana huno maigahie.” ");
INSERT INTO knb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tagaya tagaiti taguꞌafima hanea yana ageteta alu veaꞌnehena “Havi veaꞌne mainae.” huta hisuna yafe Yisasiꞌa mage huno hie “Naꞌa higeka negafu aulagafina osiꞌa havi yana hanegeka neꞌagananagi kagaikaꞌa kaulagafina nagola muki yosalapagefa hanegeka ‘Omale.’ huka nehane? ");
INSERT INTO knb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Naꞌa higeka negafufena ‘Kaulagafitila havi yana alitalegahue.’ huka hananagi kagaika kaulagafina nagola muki yosalapagefa hanegeka ‘Omalene.’ huka nehane? Kaguꞌafinaga hanea yana agelama ohuneka kavayaleti havige huka vagala kano maineka kagaikaꞌa kaulagafitila muki yosalapagefa alitaleteka negafu aulagafina kanale neꞌageka osiꞌa havi yana alitalegane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kanale yosamoꞌa havi yosalaga noꞌayegi havi yosamoꞌa kanale yosalaga noꞌaye. ");
INSERT INTO knb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Noꞌayegi veaꞌmoꞌya yosalaga ageteꞌya kanale yosalaga hanesigeꞌyahena ‘Kanale yosa hane.’ huꞌya hugahae. Avetaꞌnafa yosaletila kaimona hataga ohugahae. Avetaꞌnafa nofitetila fulutu alaga avayu huꞌya notagiye. ");
INSERT INTO knb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Fatago huꞌya mainaya veaꞌmoꞌya kanale amaku amakesa havilineꞌya kanale kavala nehayanagi kefo ya nehaya veaꞌmoꞌya havi amaku amakesa havilineꞌya havi kavakeꞌya nehae. Veaꞌmoꞌya amaku amakesafinaga havateteno aivalilavimainea kea amavayafiti hu falote nehae.” ");
INSERT INTO knb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nagaifena afa kava nehune hutama ‘Anumayatimogae, Anumayatimogae.’ hutama nehayanagi tamahapauva kea ali hipoꞌya nohae. ");
INSERT INTO knb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nagoꞌa veaꞌmoꞌya nagaite neꞌeꞌya nagai ke havige havige huꞌya ali hipoꞌya nehaya veaꞌmogamina maꞌa augafa veaꞌne mainae huꞌna tamaveligahue. ");
INSERT INTO knb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nago kanomoꞌa noma kigahena ayaꞌaya komu kafiteno yafana anifinaga maleteno u posia ani komufinaga yafa agotofule maleteno aye talako huno nona kimalegeno timoꞌa tusiꞌa li hogino ani note eanagi tokiyaꞌage no kimaleneafe anima hogino ea timoꞌa alino lagape aioꞌatalene. ");
INSERT INTO knb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ali lagape aioꞌatalenegi nagoꞌa veaꞌmoꞌya nagai ke haviteꞌya ali hipoꞌya nohaya veaꞌmoꞌya maꞌa veaꞌne mainae. Nago kanomoꞌa noma kiana amega komu kafiteno fulu fulu posi ayeno nona kimalenegeno timoꞌa hogino ani note eana aupaꞌa ani nomaꞌa ali lagape aino mopafi atalegeno tusiya huno haviya hulavimaine.” ");
INSERT INTO knb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisasiꞌa mukiꞌa humainea kea veala hamapaigeꞌya havitageno Kapaneamu umaine. ");
INSERT INTO knb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nago Lomu ati vayate kava humainea kanomoꞌa agaiꞌa aliꞌya kanoꞌa tusiya huno nehaiya kanoꞌagino tusiꞌa kali alino ago faligahe hie. ");
INSERT INTO knb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Faligahe nehigeno ati vayate kava humainea kanomoꞌa Yisasi avagea haviteno nagoꞌa Yuta vayate ala vayaꞌmoꞌya humateno mage humaine “Nagayama hua kea Yisasina havigeho ‘Musekaꞌa nehugi kanale eka aliꞌya kanoꞌnia ali kanale huto huno hie.’ hutama havigeho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nage higeꞌya neꞌuꞌya Yisasite uvaꞌyi huꞌya tutu huꞌya mage hae “Ani kava kanomoꞌa tagaiti Yuta vayaꞌmogatife aluya huno nehaigeno mono notia kilatene. Ani yafe kanale kano mainegi afaꞌa haꞌmaisanana katesia kava hugane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Yisasiꞌa amakaiꞌene tokaeno viaꞌamo nomaꞌale uvaꞌyi hugahe nehageno Lomu ati vayate kava humainea kanomoꞌa vayaꞌamogamife “Mage hutama hiho.” huno humategeꞌya Yisasite eꞌya mage huꞌya mehae “Mage hie ‘Anumayamoga kasalo kahaesigekahena atalo. Nagaya kanale ohunoa kanomoni noniꞌafi esanana okategahie huꞌna ani yafe kagaitega oꞌunogi afaꞌa menia aliꞌya kanoꞌnimona kaliꞌahena keꞌa hutesanageno kanale hutesie huꞌna nehue. ");
INSERT INTO knb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nagaya kava kano mainoe. Nakaiꞌma kava yagainatenea kanoa anale nagaseno maineanagi nagaya aniꞌa huꞌna nagoꞌa ati vayatela kava huꞌna mainoe. Nago kanomofe ‘Vuoma.’ hugenoꞌa umaine. ‘Enoma.’ hugenoꞌa emaine. Aliꞌya kanoꞌnihe ‘Naꞌa huo.’ hugenoꞌa aniꞌa humaine.’ huno hie.” huꞌya hapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hapaigeno Yisasiꞌa ani kea haviteno agesaguꞌmoꞌa tusiya huteno kasagoꞌya akaveꞌma umainaya veaꞌmogamifena mage huno hie “Tamahanepauve ma kanomoꞌa tusiya huno nagaifena havino agupi maleno ametiti humaine. Ma kanomoꞌma hia ya huꞌya nagaifema haviꞌya amakupi maleꞌya ametiti humainaya veala mukiꞌa Yuta veaꞌne mainaya kumatela oꞌagenoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Higeꞌya humatenea vayaꞌmoꞌya notega eteꞌya uꞌya mogayana ani aliꞌya kanoa ago kanale huno mainegeꞌya mo gemainae. ");
INSERT INTO knb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yisasiꞌa osi kanaꞌa maiteno agaiꞌene tokaeꞌya nemaiya anagaꞌaene mukiꞌa veaꞌnene Neni kumate umainae. ");
INSERT INTO knb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ani kumala kegiꞌya humalenaya fiate neꞌvageꞌya nagola falimainea kanoa aliꞌya hevaitegahe emainae. Anima falimainea neyamona itaꞌamoꞌa aiya nagoke nafaꞌneꞌagino itaꞌamoꞌa megusa alagiꞌya ani yafe mukiꞌa ani kumate veaꞌmoꞌya ani aꞌmo akave umainae. ");
INSERT INTO knb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Neꞌvageno Anumayamoꞌa ani aꞌmona ageteno tusiꞌa hau huteteno mage huno hapaiye “Kagaya kahauma huka avima atana yana haꞌno huka afaꞌa maiyo.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hapaiteno alilinaya hagifanale motafa hulineno hagifanama aliꞌya aya vayala anile hetimainageno Yisasiꞌa mage hie “Ma neyamoga hetio huꞌna nagaya kahanepauve.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Higeno anima falimainea neyamoꞌa hetino kaiyekea aepa henoꞌma nehiana Yisasiꞌa avaleno itaꞌamona amine. ");
INSERT INTO knb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Amigeꞌya mukiꞌa veaꞌnemoꞌya tusiꞌa amamaꞌyo aiteꞌya Anumaya Koti agia alisaga nehuꞌya mage hae “Anumaya Koti ala aune kanoa tagai amuꞌnopina ago emaine. Anumaya Kotiꞌa mukiꞌa veaꞌa amaugafa aligatigahe emaine.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yisasiꞌa aniꞌama hia avagemoꞌa mukiꞌa Yutia kotegaene alu kotegaene ute ete humaine. ");
INSERT INTO knb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoni kema nehaviya vayaꞌmoꞌya Yisasi avagea Yonina hapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Hapaigeno Yoniꞌa agaiꞌene tokaeꞌya nemaiya anagapiti tole kanolafe ke higeꞌana agaite aꞌageno Anumayamotega hunateno “Mage hutana havigeꞌo.” huno hanapaiye “Kagaya egahiema humainaya kano emainapi alu kanohe agava maisune?” hutana havigeꞌo. huno hie. ");
INSERT INTO knb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Higeꞌana ani tole kanolatana Yisasitega eꞌana mage huꞌana haꞌe “Yoniꞌa tima fale neꞌamatea kanomo hulaꞌategetaꞌa kagaitega neꞌoꞌe. Mage hutana havigeꞌo huno taꞌahapaiye ‘Kagaya egahie huꞌya humainaya kano mainapi alu kanohe agava maisune.’ huno hie.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ani kanafina Yisasiꞌa mukiꞌa alu kali alu kali alimainaya veaꞌnene Kefo Avamula amakusafinaga mainea veaꞌnene ali hilato humatene. Amaulaga asu humai veaꞌnea amaulaga agesaya ya humatene. ");
INSERT INTO knb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Anakaifena kenonaꞌania mage huno hie “Tanakaya utana agaꞌa yaꞌene haviꞌa yaꞌene Yonina hapaiꞌo. Amaulaga asu humainea veaꞌmoꞌya amaulaga neꞌagae. Amaiya haviya humainea veaꞌmogami amaiyamoꞌa kanale humate. Fugitaya amakemainea veala kanale humate. Amakesa tilemainea veala eteꞌya nehaviye. Falimainaya veala hetiꞌya mainae. Afenoꞌami omalenea veala Anumaya Kotina kanale keꞌa nehaviye hutana hapaiꞌo. ");
INSERT INTO knb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nagai kehema tole amakesa ohavisaya veaꞌmoꞌya kanaleꞌya huꞌya maigahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoniꞌma hunategeꞌana emainaꞌa kanolatana utaꞌageno Yisasiꞌa anile mainaya veaꞌmogamina Yonife mage huno hamavige “Tamakaya kaꞌme kotega utama na ya agegahe neꞌvae? Nago vemoꞌa hopa kana huno yasimoꞌa ali fagagi mainea kanomona agegahe neꞌvafio? ");
INSERT INTO knb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ifi na ya agegahe neꞌvae? Kanale kena failinesia kanoa kaꞌme kotega agegahe neꞌvafio? Aꞌao kanale kena failinesaya vayala kanale kave nege nege nehaya vayala kaꞌme kotega omainagi ala kanomona kanale nomaꞌafi maigahae. ");
INSERT INTO knb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na ya agegahe neꞌvae? Anumaya Koti aune kano agegahe neꞌvafio? Tamage tamahapauve mukiꞌa Anumaya Koti aune vayaꞌmogamina amakasemainea kanoa Yoni maine. ");
INSERT INTO knb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yonife nayona Anumaya Koti autaꞌmafina mage huꞌya kaemalenayane ‘Haviho nagaya Anumaya Kotiꞌna aliꞌya kanoꞌnimona hagoteꞌna hutogeno uhagotegateno visana kana valino ali hilato hugategahie.’ huno kaemaleneane. ");
INSERT INTO knb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tamahapauve Yoniꞌa mukiꞌa ma mopale atenaya vayaꞌmogamina ago amakasemaineanagino nagoꞌa afa veaꞌmoꞌya Anumaya Kotife ‘Kava yagailato.’ huꞌya humainaya veala Yonina ago agasemainae. ");
INSERT INTO knb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","30","Kasagoꞌya veala musufaya nehuꞌya vaya amaugafaleti takisi neꞌaliya vayaꞌene Yoni humainea kaiyekea haviteꞌya ‘E, Anumaya Kotiꞌa ‘Naꞌa maꞌa huo.’ huno humainea kea fatago ke huno hie.’ hutageno Yoniꞌa tina falemateanagi Falasia vayaꞌene kahegi kema havilinaya anagaꞌene ‘Anumaya Kotiꞌma ‘Naꞌa maꞌa hiho.’ humainea kehe tagaifena ohune.’ Yoniꞌma falematea tina ofalegahune.” huꞌya amakaveꞌno hutenae. ");
INSERT INTO knb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Meni kanafima mainaya veaꞌmogatamahena hana augafa veaꞌne mainae huꞌna tamahapaisue? ");
INSERT INTO knb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ma ma hisua augafa nafaꞌneyagamoꞌya mainaya kava hutama mainae. Ani nafaꞌneyagamoꞌya veaꞌne alitalu huꞌya mainalega maineꞌya alu nafaꞌneyagahena ke huꞌya mage huꞌya hae ‘Yaveꞌya aikolunana tamakaya amoa noꞌayae. Tagaya tahau hisuna yagame nehunana tamakaya avia noꞌatae.’ huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yoniꞌa ti fale neꞌamatea kanomoꞌa kaveꞌene haviliꞌene mosino emainegetama tamakaya ‘Satani Avamula aguꞌafina maine.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hayanagi ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna tina kavela nenogetama nagaifena ‘Kaveꞌene tiꞌene neno haꞌno hugeno omai kano maineno musufaya nehaya vayaꞌene amaugafaleti takisi neꞌaliya vayaꞌene kefo yama nehaya vayaꞌene vayaꞌamoꞌya mainae.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hayanagi Anumaya Kotiꞌna kanale agu agesama hanea kavala akaveꞌma neꞌvaya veaꞌmoꞌya ‘Fatago kava nehie.’ huꞌya nehae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nagola Falasia kanoa Saimoniꞌe Yisasife “Nagaiꞌene kavela meno.” huno higeno Yisasiꞌa kave mo negahe Falasia kanomo nopi haino mopale maine. ");
INSERT INTO knb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Haino mainegeno nagola kumai aala ani kumate nemaiyanagino “Yisasiꞌma Falasia kanomo nopiti kave negahe umaine.” huꞌya haya kea haviteno manaꞌage masavena havatemai yafa keꞌayo alilino emaine. Ani keꞌayoꞌma talo hia yafamo agia alapasatae. ");
INSERT INTO knb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yisasi akavelega aiyafi umaineno Yisasife “Ala kano mainane.” nehuno aiyafi ape huno avi neꞌategeno aunumoꞌa takilavino Yisasi aiyale tavigeno agaiꞌa ayolagefaleti aye haꞌmino alisoso hu neꞌateno aiyale atako nehuno manaꞌage masaveteti faletene. ");
INSERT INTO knb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fale neꞌategeno kema humainea Falasia kanomoꞌa ani aꞌmoꞌma hia kavala ageteno agesafinaga mage huno havie “Ma kanomoꞌa Anumaya Koti aune kanoma maineleꞌasina aiyaleꞌma alisoso hutea aꞌmofena ago havileꞌasine. Ani aꞌmoꞌa tusiꞌa kefo yamaꞌage nehia a maine.” huno nehavie. ");
INSERT INTO knb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Agesafinaga ani kea nehavigeno Yisasiꞌa agaife mage huno hie “Saimonigae nago kea kahapaisue.” huno higeno “Hulavenelina kanomogae nahapaigeꞌna havino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Higeno Yisasiꞌa mage huno hie “Nagola moneꞌa hanea kanomote tole kanolatamogania uꞌana nagoꞌmoꞌa ‘Vani hataleti kina (K100) namigeꞌna alino.’ higeno nagoꞌmoꞌa teni kina (K10) namigeꞌna alino. Alitetaꞌa anonaꞌa haenaga megamiꞌano huꞌana haꞌageno anamigeꞌana aliꞌana umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Uteꞌana haenagaꞌa anonaꞌama amisaꞌa monea kosa ohegeꞌana oꞌamiꞌageno ‘Kanalelagi onamitana ataleꞌo.’ huno humaine. Ani kema humainea yafena ani tole kanolatalapitila hana kanomo monema aminea kanohena tusia musena huno hau ayamopafina haugahie?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimoniꞌa mage hie “Nagesa havuana ala monema alimainea kanohe atalo hunoꞌma hutea kanomoꞌa tusiꞌa muse huno hau ayamopafi haugahie.” huno higeno Yisasiꞌa mage huno hie “Tamage hane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ani kea huteno maiyahae huno ani aꞌmona agemaineno Saimonina mage huno hapaiye “Kagaya mani aꞌmona ago. Nagaya kagai nopi ogeka naiya sese huonatanageno ma aꞌmoꞌa agaiꞌa aunuleti naiya sese hunateteno agaiꞌa ayolagefaleti ali hau hunenate. ");
INSERT INTO knb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kagai nopi ogeka nagaila naugafalela alisoso hu onatenanagi ma aꞌmoꞌa naiyalela eno aluya huno alisoso hunenate. ");
INSERT INTO knb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kagaya afa masavetetila nanupina fale onatenanagi mani aꞌmoꞌa manaꞌage masaveteti naiyalela falenatene. ");
INSERT INTO knb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ani yafe kahanepauve mani aꞌmoꞌa kefo yamaꞌamoꞌa kasago humainegeno Anumaya Kotiꞌa ago aigeꞌateno ataletea yafe tusiya huno hau ayamopafi haumaineanagino osi kefo yamaꞌama hanea kanomona Anumaya Kotiꞌa ani kefo yamaꞌa aigeꞌateno ataletesiana osiꞌa hau ayamopafina haugahie.” ");
INSERT INTO knb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yisasiꞌa mage huno ani afena hie “Nagaya kefo yakaꞌa ago aigekateꞌna atalegatoe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","50","Agaiꞌaene tokaeꞌya mopale mainaya veaꞌmoya sumi sumi kefiti mage huꞌya hae “Mani kanoa hanaꞌa kano maineno ‘Kefo yakaꞌa aigekateꞌna atalegatoe.’ huno nehie.” huꞌya hae. “Nagaifena havika kagupi maleꞌka kametiti hanafe kagu kamena ago aligatigatogi kamena male falu huka vuo.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Yisasiꞌa osi kanaꞌa maiteno ala kumaꞌyagaleꞌene osi kumaꞌyagaleꞌene vaiyatete huno Anumaya Koti kava yagaimatesia kanale mono kea hamapaimaine. Agaiꞌa tuelufuꞌa (12) anagaꞌaene nagoꞌa aꞌneyagaene Yisasiꞌa amakupitiꞌma Kefo Avamuꞌma anatitaleno kaliꞌamima alino kanale humatenea aꞌneyagaene agaiꞌaene vaiyatete humainae. Nago aꞌmo agia Magatala Maliaꞌe. Yisasiꞌa hagoteno seveniꞌa (7) Kefo Avamuꞌyaga aguꞌafiti anatitalenea ale. ");
INSERT INTO knb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nago aꞌmo agia Yoanaꞌe Heloti nopi kava kanomo alagi. Ani kava kanomo agia Susaꞌe. Nago aꞌmo agia Susanaꞌe nagoꞌa aꞌneyagaene Yisasiꞌene vaiyatete nehuꞌya ani aꞌneyagamoꞌya amakaiꞌami moneꞌamifiti Yisasiꞌene anagaꞌamogamiꞌene amaya humainae. ");
INSERT INTO knb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mukiꞌa alu kumateti kumateti veala Yisasite melitalu hageno Yisasiꞌa nago avame kea hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mage huno hie “Nago kanomoꞌa avina faigahe alino vie. Avina alino aihelafino nefaigeno nagoꞌa avinamoꞌa kapi tavino hanegeno veaꞌmoꞌya ani avinale amaiya ayeꞌya ute ete hageno namayagamoꞌya nageno haꞌno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nagoꞌa avinamoꞌa yafa mopafi taviteno hageana tina omalea mopafinagino eteno fayoteno asagalimaine. ");
INSERT INTO knb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nagoꞌa avinayagamoꞌa avetaꞌnafa ino hanea amuꞌnopi tavino hageteno avetaꞌnafa hanea inoꞌmoꞌa ayetegeno haviya humaine. ");
INSERT INTO knb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nagoꞌa avinamoꞌa kanale mopafi tavino hageteno alagaꞌama ayeana nagoke yosalela kasagoꞌya alaga vani hataletiꞌa (100) ayeno vasaimai vasaimai humaine.” huno hie. Ani kea huteno ala ke huno mage hie “Mani kea tamakesama hanesigetamahena havilama hutama haviho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Agaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya ani avame kemo aepaꞌahe havigae. ");
INSERT INTO knb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Havigageno Yisasiꞌa mage hie “Tamakaya Anumaya Kotiꞌa kava yagailamateneafe kemoꞌa falaki mainea kea Anumaya Kotiꞌa tamaya higetama ago havilinagi mukiꞌa veaꞌmoꞌya avame kema hamapaisugeꞌya amakesa havigahagi haviteꞌya havilama huꞌya ohavigahae. Veaꞌmoꞌya neꞌagayanagi agelama huꞌya oꞌagegahae. ");
INSERT INTO knb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mani avame kemona aepaꞌa hu falote huꞌna tamahapaisue. Mani avinamoꞌa Anumaya Koti ke kana humaine. ");
INSERT INTO knb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kateꞌma tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya Anumaya Koti kea havitageno Sataniꞌa mage hie ‘Amakupi aliꞌya omalesageno Anumaya Kotiꞌa amaku amamena ali okatisie.’ huno amakupitila ani kea alitalene. ");
INSERT INTO knb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yafa mopafima tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviꞌya muse huꞌya atafa hayanagi hafuꞌya mopafi otavia yamoꞌa alige atalege veaꞌne maineꞌya osi kanaꞌa osiꞌa haviꞌya amakupi maletageno havi kanama amakaiteꞌma falote nehiana aupaꞌa Anumaya Koti kea neꞌatalae. ");
INSERT INTO knb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Avetaꞌnafa ino hanea amuꞌnopi tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya Anumaya Koti kea haviteꞌya ma mopafi mukiꞌa yaꞌyagaꞌamihe amakesa haviꞌya moneꞌamiene yokaloꞌamienefe kalagi aiteꞌya ani yaꞌyagaꞌamimo Anumaya Koti kea alino aiso humalegeꞌya atalageno alagaꞌamoꞌa aye helafino lama nohie. ");
INSERT INTO knb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kanale mopafima tavimainea avinamoꞌa maꞌa humaine nagoꞌa veaꞌmoꞌya tokiyaꞌage amaku amakesa hanegeya Anumaya Koti kea haviteꞌya aliꞌya amakupi maleꞌya atafa hu talako huꞌya mainaya veaꞌmoꞌya ani alagaꞌa mukiꞌa aye henelafie.” ");
INSERT INTO knb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Anumaya Koti ke nehaviyafe Yisasiꞌa mage huno hamapaiye “Nagoꞌa veaꞌmoꞌya lamua hanagaliꞌya susufaneleti aiso hu nemalafi ifi sipa kapinaga hanagaliꞌya aiso hu nemalae? Aꞌao lamua hanagaliteꞌya esaya veaꞌmoꞌya ani lamule agesayafe sipale nemalae. ");
INSERT INTO knb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ani yafe haenagaꞌa mukiꞌa falakimainesia yamoꞌa efalote hugahie. Mukiꞌa kesi kava nehaya yamoꞌa efalote hinageꞌya veaꞌmoꞌya agegahae. ");
INSERT INTO knb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ani yafe Anumaya Koti ke havisaya yafena tamakesa havitama havilama hutama haviho. Havilama huno havilinesia kanomona Anumaya Kotiꞌa nagoꞌene havilisia yana amigahianagi nagoꞌamoꞌya ‘Ago havilinoe.’ huno hisia kanomona havilinesiamaꞌa hanafaletalegahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yisasina itaꞌamoꞌene aganaꞌamoꞌyaene agegahe ayanagi kasagoꞌya veaꞌmoꞌya hiya huꞌya maigeno Yisasiꞌma mainea avatela omenae. ");
INSERT INTO knb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Omenagi nago kanomoꞌa Yisasife mage hie “Itakamoꞌene kaganakamoꞌyaene kagai kagegahe emaineꞌya kumatega hetiꞌya mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Higeno kenonaꞌa mage huno hie “Mukiꞌama Anumaya Koti kema haviꞌya akave nemalaya veala itaꞌnimoꞌya naganaꞌnimoꞌya mainae.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nago yupa Yisasiꞌenema tokaeꞌya nemaiya anagaꞌene tipi kalefi haisaga humaiꞌya neꞌuꞌya Yisasiꞌa mage huno hamapaiye “Tikotumona atu faliga vigetao.” huno higeꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yaufa neꞌvageno Yisasiꞌa aukalokalo higeno faemainegeno tusiꞌa yasimoꞌa tina mevaleno tipi kalefi atalegeno ani lipi kalefina havatesia kava higeꞌya mukiꞌamoꞌya haviya hisaya kava humainae. ");
INSERT INTO knb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Huteꞌya Yisasiꞌa faemainegeꞌya mogafa huꞌya mage hae “Kava kanomogae, kava kanomogae tagaya ti nakaita falisuna kava nehunageka notagane.” huꞌya hageno hetino ani limofeꞌene yasimofeꞌene tokiyaꞌage ke huno “Taga huo.” huno higeno yasimoꞌene timoꞌene taga huꞌana alava humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Alava hutegeno Yisasiꞌa agaiꞌaene tokaeꞌya nemaiya anagafe mage huno hamavige “Nagaifena havitama tamakupi maletama tamametitima haya yana hanate atalae?” huno higeꞌya koli huꞌya tusiꞌa amamaꞌyo neꞌaiꞌya huge havige huꞌya mage hae “Mani kanoa taꞌe? Timoꞌene yasimoꞌene keꞌa haviteꞌya akave malae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kaliliti ala tikotuna takaeꞌya ame kaiyaga agegayamona Kelasasa* veaꞌne mainalega uvaꞌyi hae. ");
INSERT INTO knb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yisasiꞌa tipi kalea ataleno ti agegayalega neꞌuno ageana nagola ala kumate kanoa Kefo Avamuꞌyagamoꞌya aguꞌafi mainaya kanoa Yisasite emaine. Ani kanoa ayaꞌaya kanafi kenaꞌa fai oꞌalino nopina nomaiyane. Matimatipikeꞌya nemaiya kanoe. ");
INSERT INTO knb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ani kanomoꞌa Yisasina ageteno mopafi agoꞌya ayemaineno ala kefiti mage hie “Yisasiga tagasenoꞌma anale mainea Anumaya Kotina nafaꞌneꞌamoga naꞌa hunategahe neꞌane? Musekaꞌa nehugi nagata aisia kavala hu onato.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Higeno Yisasiꞌa Kefo Avamufe mage huno hie “Agusafitila hatilavio.” huno higeno Kefo Avamuꞌmoꞌya mukiꞌa kanafina ani kanomona atafa nehigeꞌya kava neꞌyagaiya vayaꞌmoꞌya aiya ayapi seni nofiteti kisalu kitayanagi ani nofila aikaꞌnokaꞌnu huneꞌataleana Kefo Avamuꞌmoꞌya afai kotega anatigeno faleno neꞌviane. ");
INSERT INTO knb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yisasiꞌa ani kanohe mage hie “Kagai kagia tagae?” huno higeno mage hie “Nagai nagia kasagoꞌyamoꞌnae.” huno hie. Naꞌafene kasagoꞌya Kefo Avamuꞌmoꞌya aguꞌafima hai falemainayafe “Nagia kasagoꞌyamoꞌnae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ani Kefo Avamuꞌmoꞌya Yisasifena mage hae “Hanikimainea kumapina tagaila hulategeta oꞌvamano.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nehageꞌya kasagoꞌya afuyagamoꞌya agoꞌyafi maineꞌya kave nenageno ani Kefo Avamuꞌmoꞌya Yisasifena mage huꞌya hae “Amuga afuyagamo amakuꞌafina hulategeta vamano.” huꞌya havigageno Yisasiꞌa “Aniꞌa hiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Higeꞌya ani Kefo Avamuꞌmoꞌya ani kanomo aguꞌafitila hatilaviꞌya afuyagamogami amakupi hai nefalayana ani afuyagamoꞌya amaiyayeꞌya nagola aulufi kapi taviteꞌya tipi asaga hulaviꞌya ti nakaiꞌya fali haꞌno humainae. ");
INSERT INTO knb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fali haꞌno hageꞌya ani afuyagale kava vayaꞌmoꞌya ani afuyaga tima nakaiꞌya fali haꞌnoma haya yana ageteꞌya faleꞌya ala kumate mainaya veaꞌmogamifeꞌene hoyafinaga mainaya veaꞌmogamifeꞌene “Naꞌa maꞌa higeta neꞌone.” huꞌya hamapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hageꞌya ani veaꞌmoꞌya humainea yama agegahe Yisasite eꞌya Kefo Avamuꞌmoꞌma agusafiti ataleno umainea kanomona agesa akalo higeno kenaꞌa failino Yisasi aiyafi mopale mainegeꞌya megeteꞌya koli humainae. ");
INSERT INTO knb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yisasiꞌma humainea yama agemainaya veaꞌmoꞌya “Naꞌa maꞌa huno Kefo Avamuꞌmogamina agusafi mainea kanomona alino kanale hutene.” huꞌya hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hamapaigeꞌya mukiꞌa Katalaga kumate veaꞌmoꞌya Yisasifena tusiꞌa koli huteꞌya “Tagaila tataleka vuo.” huꞌya hageno Yisasiꞌa amataleno emainelega ugahe tipi kalefi haisaga humaine. ");
INSERT INTO knb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Haisaga hunemaigeno Kefo Avamuꞌmoꞌma agusafiti hatilavino umainea kanomoꞌa Yisasifena “Kagaiꞌene ugahe nehue.” huno higeno Yisasiꞌa “Aꞌao kagaya eteka nokalega uka mukiꞌa Anumaya Kotiꞌma hugatenea yafena veaꞌneyaga mo hamapaiyo.” huno higeno ani kanomoꞌa viaꞌyamo mukiꞌa ala kumaꞌale veaꞌmogamina Yisasiꞌma hutea yafena hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisasiꞌa eteno egeꞌya mukiꞌa veaꞌmoꞌya agava maineꞌya tusiꞌa muse huꞌya falu fala hutenae. ");
INSERT INTO knb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Falu fala huneꞌatageno nago kanoa Yailasiꞌe nehaya kanoa emaine. Ani kanoa soka kano maineanagino Yisasi aiyafi mepe humaineno tutu nehuno Yisasina mage huno havige “Noniꞌalega egetaꞌa vaꞌano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ani kanomoꞌa aiya nagoke munaꞌa maine. Ani munala kafuꞌa tuelufuꞌa (12) kafuꞌa hanea munala faligahe ayaya neꞌaigeno “Noniꞌalega eno.” huno tutu higeno Yisasiꞌa anilega vigeꞌya veaꞌmoꞌya yageꞌyage huꞌya aulega akavelega huꞌya akave umainae. ");
INSERT INTO knb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vageno ani veaꞌnefiti nago aꞌmoꞌa tuelufuꞌa (12) kafu aigu nopinaga mukiꞌa kanale nemaiya aala nagoꞌa vayaꞌmoꞌya aliꞌya kanale hu oꞌataleꞌasine. ");
INSERT INTO knb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ani aꞌmoꞌa Yisasina akavelagati eno kenaꞌamo atupale avate aligeno aupaꞌa kolamaꞌamoꞌa taꞌnemaine. ");
INSERT INTO knb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Taꞌnegeno Yisasiꞌa mage huno humaine “Ta kenaꞌnilela mevate humaine?” huno higeꞌya mukiꞌamoꞌya “Tagaya naꞌa ohunone.” huꞌya hageno Pitaꞌa mage hie “Kava kanomoga mukiꞌa veaꞌmoya yageꞌyage huꞌya kaulegati kakavelagati nehagi naꞌa higeka mani kea hamavinegane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yisasiꞌa mage huno hie “Tamage huꞌna nehue nago kanomoꞌa kenaꞌnile avate higeꞌna nagaya nagesa nehavugeno navate aligeno nagoꞌa tokiyaꞌnimoꞌa ago nataleno umaine.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hapaigeno ani aꞌmoꞌa “Falakigahe huanagi ago nagane.” huno atili huteno Yisasi aiyafi mepe humaineno mukiꞌa veamogami amaulagafi “Naꞌa maꞌa huꞌna kali alimainoafe avate alugeno kaliꞌniꞌa aupaꞌa kanale hunate.” huno hapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hapaigeno Yisasiꞌa mage huno hapaiye “Ma aꞌmoga nagaife kagupi maleka kametiti hanafe kanale negahaiye kagaya kaipamoꞌa yasi nehinageka vuo.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ani kea nehigeno nago kanomoꞌa soka kanomo notegati anile evaꞌyi huno Yailasife mage huno hie “Munakamoꞌa ago falimainegi ataleka kava kanomona kasalo haegi nagoꞌene havioko.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yisasiꞌa ani kea haviteno Yailasife mage huno hie “Kolia ohuka afaꞌa nagaife kagupi maleka kametiti hisanageno munakaꞌa falimainefitila hetigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Soka kanomo note uvaꞌyi huno Yisasiꞌa mukiꞌa veaꞌnehe “Omeho.” huno Pitaꞌene Yoniꞌene Yemesiꞌene ani munaꞌmo itaꞌafoꞌamoꞌene amavaleno ani nopi haimainae. ");
INSERT INTO knb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mukiꞌa veaꞌmoꞌya ani munaꞌma falimainea yafena tusiꞌa avi neꞌatageno Yisasiꞌa mage huno hie “Avia oꞌateho mani munala falilavata ohunegi afaꞌa faeno maine.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ani munala faligeꞌyama agemainaya yafena ani veaꞌmoꞌya Yisasina kigiꞌa hutenae. ");
INSERT INTO knb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kigi hutayanagi Yisasiꞌa ani munaꞌmo ayate atafa nehuno mage hie “Ma munaꞌmoga hetio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nehigeno agu nafaꞌnea eteno egeno aupaꞌa hetie. Hetigeno Yisasiꞌa mage hie “Nagoꞌa nesia kavela amiho.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Itaꞌafoꞌamogania ani yana ageteꞌana tusiꞌa anamaꞌyo aimaiꞌanagi Yisasiꞌa mage hie “Nago kanomona ma ma hua yafena hamaopaiꞌo.” huno kaheginatene. ");
INSERT INTO knb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisasiꞌa tuelufuꞌa (12) anagaꞌamofe ke higeꞌya ageno mukiꞌa Kefo Avamuꞌyagama veaꞌmogami amakusafiti amanatitalesaya tokiyaene kalima aliꞌya kanale humatesaya tokiyaene amamine. ");
INSERT INTO knb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Amamiteno Anumaya Kotiꞌma kava yagaisia yafe hamapaigahe kalima hamaemainea yana aliꞌya kanale humatesayafe humatene. ");
INSERT INTO knb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Huneꞌamateno mage huno hamapaiye “Kama visayafena ayopatamiene kutamiene mayatamiene monetamiene alitama oꞌviho. Tole kena oꞌaliho. Alu nopi alu nopi faelitetama ohiho. ");
INSERT INTO knb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nago nopima hai falenutamahena ani nopi faetama maitama amataletama alu kumatela viho. Faelitetama ohiho. ");
INSERT INTO knb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nagoꞌa kumate veaꞌmoꞌya falu falama huotamatesagetamahena ani kumala neꞌataletama ‘Havi kava hae.’ hutama tamaiyafima hanesia kugukege yana aifopo huneꞌataletama viho.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hamapaitegeꞌya alu kumate kumate neꞌuꞌya mukiꞌa kumatela Anumaya Kotina kanale keꞌa hamanepaiꞌya kaliꞌamia aliꞌya kanale huneꞌamateꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ani kanafina Helotiꞌa sauve kanogino Yisasiꞌa mukiꞌama humainea kavaꞌmo avagema haviana nagoꞌa veaꞌmoꞌya ani yana ageteꞌya “Yoniꞌa falimainefiti ago hetimaine.” huꞌya hageꞌya nagoꞌa veaꞌmoꞌya “Ilaiyaꞌa eteno falote humaine.” huꞌya hageꞌya nagoꞌa veaꞌmoꞌya “Nayoma Anumaya Kotina aune kanoꞌa falimainefiti hetimaine.” huꞌya haya yafe Helotiꞌa ani kea haviteno agu agesamoꞌa anilega vigeno “Hana veaꞌmogami kemo tamagea nehafi?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Huteno Helotiꞌa mage hie “Nagaya aliꞌya vayaꞌniꞌa humatogeꞌya Yonina ageꞌya ago fakalitalageno falimaine. Naꞌa maꞌa kava nehie huꞌya avagema humainaya kanoa taꞌe?” huno nehuno Yisasima agesia kafena ati ayemaine. ");
INSERT INTO knb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolo anagala eteꞌya “Naꞌa maꞌa kava huteta neꞌone.” huꞌya Yisasina me hapaigeno Yisasiꞌa haviteno ani anagaꞌa amavaleno Petesaita kumatega ugahe katega umainae. ");
INSERT INTO knb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Neꞌvageꞌya mukiꞌa veaꞌmoꞌya haviteꞌya akave agaitega ageno Yisasiꞌa falu fala humateteno Anumaya Kotiꞌma kava yagaisia yafe hamapaiteno kalima neꞌaliya veala alino kanale humatene. ");
INSERT INTO knb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Une kigeꞌya tuelufuꞌa (12) anagaꞌamoꞌya Yisasite mage me hae “Tagaya vaya omai kaiyaga mainonafe mukiꞌa veaꞌmogamina humatesanageꞌya hanesia kumateꞌene noma hanesilegaene ute ete huꞌya faesaya nofeꞌene nesaya yafeꞌene atiyesae.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hageno Yisasiꞌa mage huno hamapaiye “Tamakaitami kavela amamiho.” huno hamapaigeꞌya mage hae “Utama mukiꞌa mainaya veaꞌmogami kavela miya hiho huka nehano? Tagaipina osi kave kanoꞌa hane faefuꞌa (5) mayaene tole noyame kanoꞌagi huno hane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Anifima mainaya vayala faefu tauseniꞌa (5,000) vayaꞌyaga mainayanagi Yisasiꞌa agaiꞌenema tokaeꞌya nemaiya anagaꞌamogamife mage huno hamapaiye “Hamapaigeꞌya fifitiꞌa (50) veaꞌne ‘Alitalu hutama maite maite hutama mopale maiho.’ hutama hamapaiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hamapaigeꞌya aniꞌa hute hute huꞌya mopale mainae. ");
INSERT INTO knb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yisasiꞌa faefuꞌa (5) maya neꞌalino tole noyamene neꞌalino huteno ikapinaga agesaga huno Anumaya Kotitega huno muse huteno ani mayaene noyamene koliteno agaiꞌenema tokaeꞌya nemaiya anagaꞌa amamigeꞌya mukiꞌa veala amamite amamite humainae. ");
INSERT INTO knb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Amamite amamite hageꞌya mukiꞌa nageno amamu higeꞌya atalaya atupatapaꞌa aliꞌya tuelufuꞌa (12) kula aihavatemainae. ");
INSERT INTO knb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nago yupa Yisasiꞌa agaiꞌage Anumaya Kotitega havinegegeꞌya agaiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya avate mainageno mage huno hamavige “Veaꞌmoꞌya nagaifena taꞌe huꞌya nehae?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hamavigegeꞌya kenonaꞌa mage huꞌya hae “Nagoꞌa veaꞌmoꞌya kagaifena ‘Ti faleneꞌamatea Yoni maine.’ huꞌya hageꞌya nagoꞌa veaꞌmoꞌya kagaifena ‘Ilaiya maine.’ huꞌya hageꞌya nagoꞌa veaꞌmoꞌya ‘Anumaya Koti aune kanoa nayo ago falimainea kano falimainefiti eteno hetimaine.’ huꞌya nehae.” huꞌya hapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hapaigeno Yisasiꞌa amakaifena mage huno hamavige “Tamakaya nagaifena taꞌe hutama nehae?” huno hamavigegeno Pitaꞌa mage huno hie “Kagaya Kalaisigae Anumaya Kotiꞌa taugafa aligatigahe hugatenea kano mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Higeno Yisasiꞌa tokiyaꞌage ke huno “Mani kea nagoꞌa veala hamaopaiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yisasiꞌa mage huno hamapaiye “Soka vayaꞌene mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene nagaila ikapinagati emainoa kanoa vayaꞌmo natenea kanomonihena ‘Kahaoteꞌyakae.’ huꞌya hunatesageno tusiꞌa nagata aisigeꞌya nahaesageꞌna faligahue. Falisugeꞌya komufi hevainatesageꞌna tole yupa maiꞌna tagufa kanale falimainesufiti hetigahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Alitalu humaiya veaꞌnene agaiꞌaene tokaeꞌya nemaiya anagaꞌenefe mage huno hie “Nagoꞌa veaꞌmoꞌya nagai nakaveꞌma visaya amakesa havinuꞌyahena amaugafama aliꞌya hai yana amakaveꞌno huteteꞌya nakaiꞌma nagata aisigeꞌna falisua kava hisaya amakesa haviteꞌya yafaga yosa kanaꞌaene kanaꞌaene kofiꞌya nakave aliꞌya visae. ");
INSERT INTO knb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nagola veaꞌmoꞌya maiyaꞌamima atafa huꞌya ali talakoma hulisayana maiyaꞌamimoꞌa falino afaya hapaegahigi nagoꞌa veaꞌmoꞌyama nagaifema hamainageꞌya maiyaꞌamima atalesaya veaꞌmoꞌya maiyaꞌamia aligatisugeꞌya agola aliꞌya maigahie. ");
INSERT INTO knb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nagola veaꞌmoꞌya mukiꞌa ma mopale mone fenoꞌyaga aliteꞌya maineꞌya falisagenoꞌa agola maige maige hisaya haimula ago atalenayanagiꞌya alimainaya mone fenoꞌamimoꞌa hanaꞌa huno amaya hugahie? Aꞌao amaya ohugahie. ");
INSERT INTO knb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nagoꞌa veaꞌmoꞌya keꞌniꞌaene nagaiꞌenefema amakaye huꞌya ‘Aoteꞌyamaꞌae.’ huꞌya hunatesayana nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna esua kanafina tokiya hale yaniꞌaene Nenafana tokiya hale yamaꞌaene alu aotage ensole anagaꞌamoꞌyaenema eteꞌna esuana aniꞌa huꞌna ani veaꞌnehena nagaye huꞌna ‘Tamahaoteꞌyatamie.’ humategahue. ");
INSERT INTO knb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tamagelafa huꞌna tamahanepauve nagoꞌa veala maleꞌma hetimainaya veaꞌmoꞌya aupaꞌa ofaligahayanagiꞌya hagoteꞌya Anumaya Kotiꞌma kava yagaisia kanaꞌamoꞌma efalote hisia yana agegahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisasiꞌa mani kea huteno seveniꞌa (7) kana maiteno Pitana Yonina Yemesigamina amavaleno Anumayamotega ke huno havigegahe agoꞌyafi haimainae. ");
INSERT INTO knb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Haimainageno Yisasiꞌa Anumayamotega ke huno havinegegeno augosamoꞌa alino alu augosa kaligeno kenaꞌamoꞌa efeꞌage huno alave alave humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Tole kanolatana nayo falimainaꞌa kanolatana Moseseꞌene Ilaiyaꞌene tokiya hale yaꞌene maineꞌana Anumaya Kotiꞌa Yisasifema “Naꞌa maꞌa huka Yelusalemu faligane.” huno hutenea kehe Yisasiꞌene kea kea humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ani kaiyekea nehageꞌya Pitaꞌene anagaꞌamoꞌyaene amaukalokalo higeꞌya faemainafiti aupaꞌa hetiꞌya agayana Yisasiꞌa tokiya hale yamaꞌaene avate tokaeꞌana hetimaiꞌa kanolataꞌene amakemainae. ");
INSERT INTO knb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Neꞌamakageꞌana ani lole kanolatana Yisasina ataleꞌana ugahe nehaꞌageno Pitaꞌa Yisasife mage hie “Anumayamoga tagaya male maunana kanale ya hie. Katega nona taliꞌa (3) kilamatesune. Kagaila nagolagi Mosesena nagolagi Ilaiyana nagolagi huno hanesie.” huno hianagi agesa havilama ohuno ani kea hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hanepaigeno nago siaꞌmoꞌa evaꞌyi huno alino aiso humategeꞌana Mosesegani Ilaiyagania ani siapi falaꞌageꞌya Pitaꞌene anagaꞌamoꞌyaene tusiꞌa koli humainae. ");
INSERT INTO knb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Koli nehageno siapinagati ala kefiti age aino mage huno hie “Mani kanoa nagaiꞌni nafaꞌne ago hapaliꞌna hutenoa nafaꞌnegi agai kea haviho.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hamapaigeꞌya ani kea haviteꞌya agayana Yisasiꞌa agaiꞌage mainegeꞌya ageteꞌya ke ohuꞌya mainayanagiꞌya ani kanafina nagoꞌa veala hamaꞌopainae. ");
INSERT INTO knb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Faeteꞌya kotigeꞌya Yisasiꞌene Pitaꞌene Yoniꞌene Yemesiꞌene ani agoꞌya neꞌataleꞌya elavigeꞌya kasagoꞌya veaꞌmoꞌya Yisasi agegahe emainae. ");
INSERT INTO knb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aya veaꞌnefiti nago kanomoꞌa hetino ala kefiti mage huno hie “Humavenelina kanomoga tusiya huꞌna kahavinegoe. Aiya nagoke ne nafaꞌneꞌniꞌagi mego. ");
INSERT INTO knb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kanaꞌaene kanaꞌaene Kefo Avamuꞌmoꞌa agusafinaga haimainegeno nafaꞌneꞌnimoꞌa ala kegefafiti ke nehigeno Kefo Avamuꞌmoꞌa aige hafalege huneꞌategeno avayafitila efeꞌage agalemoꞌa selu selu nehigeno augafa alino haviya nehuno aupaꞌa ataleno oꞌvisia kava nehie. ");
INSERT INTO knb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naꞌa higeꞌna kagaiꞌene tokaeꞌya nemaiya anagakaꞌmogamife ani Kefo Avamula nafaꞌneꞌnimo agusafinagati anatitalesae huꞌna hamavige hamavige hugetoana amuha ohunaya yafe anati oꞌatalenae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Higeno Yisasiꞌa mage huno hamapaiye “Vae tamakaya meni kanafima mainaya veaꞌmogatama nagaife havitama tamakupi maletama tametiti ohutama fatago hutama nomaiye. Aniꞌa haya yafe kasalo nenahaegi naꞌmagi yupa tamakaiꞌenena mainesugetama nagaife tamakupi malegahae?” nehuno ani nafaꞌnemo nefafe “Nafaꞌnekaꞌa avaleka eno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Higeno ani nafaꞌnea yaufa avaleno neꞌegeno Kefo Avamuꞌmoꞌa alino mopafi ailakatitalegeno faemaineno kasegase nehigeno Yisasiꞌa ageteno Kefo Avamuꞌmofe kemakino “Ataleka hatilavio.” huno hutegeno hatilavigeno ani nafaꞌnea alino kanale huteteno nefana amine. ");
INSERT INTO knb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Amigeꞌya mukiꞌa anile mainaya veaꞌmoꞌya ageteꞌya Anumaya Kotina tokiya yamaꞌahe tusiꞌa atalitalu huꞌya amamaꞌyo aiyanagi Yisasiꞌa agaiꞌenema tokaeꞌya nemaiya anagaꞌamogamife mage huno hie “Menima hisua kea tamakesa havilama hutama haviho. Osi kanaꞌa maitesugeno nago kanomoꞌa nagesi hinageꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia kame vayaꞌmogami amayapi navaleꞌya nategahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Higeꞌya ani kemona aepaꞌamoꞌa ago falakimaineafe havilama ohunagi koli huꞌya ani kemo aepaꞌahena haviokenae. ");
INSERT INTO knb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya “Tagaipima uhakotemainea kanotia ta maine?” huꞌya huteꞌya ani yateti ke vaimainae. ");
INSERT INTO knb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yisasiꞌa amakaipima hanea amaku amakesa ago haviteno nagola osi nafaꞌnea avaleno avate hetitene. ");
INSERT INTO knb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ateteno mage huno hamapaiye “Nagoꞌa veaꞌmoꞌya nagaifema huꞌya ma osi nafaꞌne avaleꞌya falu fala hutesayana nagaiꞌene navaleꞌya falu fala hunatae. Nagaiꞌma navaleꞌya falu fala hunatesayana hunatenea kanoene avalemainae. Tamakaipina ‘Osiꞌa afa kano kana huꞌna mainoe.’ huno hisia kanomoꞌa tamakaila tamakaseno kava kano maine.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoniꞌa mage huno hie “Kava kanomoga tagaya agonana nago kanomoꞌa kagai kagi neꞌayeno Kefo Avamula veaꞌmogami amakusafinagati amanatigeta ageteta kagaiꞌenema kakave nohia yafe ‘Aniꞌa ohuo.’ huta nagalu huneꞌatone.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Higeno Yisasiꞌa agaife mage huno hie “Ani kanoa alitama nagalu hu oꞌateho. Vaya nagoꞌmo kamema hu otamatesiana nelamafuꞌya mainae.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yisasiꞌa ikapinaga haisia kanamoꞌa aupa higeno Yelusalemu visia agesa havino tokiya vaiteno katega umaine. ");
INSERT INTO knb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nagoꞌa anagaꞌa talo tala hisaya yafe hagoteno humategeꞌya nago Samelia kumate uꞌya vayafe mage huꞌya hae “Yisasiꞌa egahigi mukiꞌa yana talo tala hiho.” huꞌya mo hamapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samelia kumate veaꞌmoꞌya Yisasiꞌa Yelusalemu ugahe hia yafe amakesa haviteꞌya mage huꞌya hae “Tagaya avaleta ali falu fala hu oꞌategahune.” huꞌya hae*. ");
INSERT INTO knb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Agaiꞌenema toꞌkaeꞌana nemaiꞌa kanolatana Yemesigani Yonigani ani kavaꞌma haya kavala ageteꞌana mage haꞌe “Vae Anumayamoga kahaisiana taꞌagaya ikapinagati atahe ke hisuꞌageno ata maleno ani veala asagalisie?” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Haꞌageno Yisasiꞌa maiyahae huno keꞌanamakiteno “Aꞌao aniꞌa ohiꞌo.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Huteno anileti neꞌataleꞌya alu kumatega umainae. ");
INSERT INTO knb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Katega neꞌuꞌya nago kanomoꞌa Yisasifena mage huno humaine “Mukiꞌa kumate visanana nagaya kakave ugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Higeno Yisasiꞌa kenonaꞌa mage huno hapaiye “Kepu yagamoꞌya faesaya komuꞌamia mopafinaga hanegi namamogamina noꞌamia haneanagi ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna faesua noniꞌa omale.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nago kanohe mage huno hapaiye “Nakave eno.” huno higeno mage huno humaine “Alanimogae nenafana falisigeꞌna aliꞌna hevaiteteꞌna kakavela ugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Higeno Yisasiꞌa mage huno kenonaꞌa hapaiye “Atalo nagai kea ohavinesaya veala amaku amamemaꞌamo falimainaya veaꞌmoꞌya falia kanomona aliꞌya hevaitegahae amakaiꞌami yanagi kagaya neꞌataleka veaꞌmogamite Anumaya Koti kava yagaimatesia kaiyekea mukiꞌa veaꞌmogamina hamapaiyo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nago kanomoꞌa hetino mage huno hapaiye “Alanimogae kagai kakave malegahe huanagi natalegeꞌna nenafa nopi mainaya veala nayana amamite amamite huteꞌna kakavela vano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Higeno Yisasiꞌa kenonaꞌa mage huno hapaiye “Nagoꞌa veamoꞌya avina yama kaligahena amakavelega maiyahae huꞌya moge mege hinuꞌyahena Anumaya Kotiꞌa aniꞌa hisaya veafena ‘Nagai aliꞌya alitama veamogamite kava yakaisua kea hamapaiho.’ huno ohugahie.” ");
INSERT INTO knb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","2","Anile Anumayamoꞌa sevetituꞌa (72) vaya hapaliteno “Nagaiꞌnima visua kumate ali lokaete lokaete hutama uhagotetama neꞌviho.” huno humategahe amakaife mage huno hamapaiye “Nagai kema havisaya veala kasagoꞌya kaveꞌma hoyafi afulemailemai hia kava humainegi hoyafima aliꞌya alisaya veala osiꞌa veaꞌne kanoꞌa mainayafe ani hoyamona nefafe havigegeno nagoꞌa aliꞌya vayala kaveꞌma alisayafe humatesie. ");
INSERT INTO knb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tamakaya neꞌutama haviho tamakaya sipi sipi nafaꞌne kana hutama mainagi nagaila ago amakaveꞌno hunenataya veala afai kala kana kaveꞌage veaꞌne mainaya amuꞌnopi hulamatesugetama ugahae. ");
INSERT INTO knb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ugahagi monetamiene kutamiene tamaiya noꞌene alitama oꞌviho. Katega neꞌvisaya veaꞌnenena ayaꞌayate maitama kaiyekea ohiho. ");
INSERT INTO knb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nago nopima hai falenutama hagotetama mage hutama hiho ma nopima mainaya veaꞌmogatamina ‘Anumaya Kotiꞌa tamaipa falu hisaya tamaku tamakesa tamamisie.’ hutama hiho. ");
INSERT INTO knb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aipa falu hisia agesaene kano ani nopima mainesiana Anumaya Kotiꞌa aipa falu hisia agesa amigahigi aniꞌa kana kanoma omainesiana aipa falu hisia yana oꞌaligahie. ");
INSERT INTO knb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ani nopi mainetama nesaya yama tamamisagetama afaꞌa neho. Nagai aliꞌya alisaya anonaꞌa nesaya yana afaꞌa alisayana kanale hugahie. Alu nopi alu nopi faelitetama ohiho. ");
INSERT INTO knb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nago kumateꞌma visageno falu fala hulamateteꞌya tamamisaya kavela afaꞌa neho. ");
INSERT INTO knb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ani kumateꞌma mainesaya kali veala ali kanale humatetama mukiꞌa veafe mage hutama hamapaiho ‘Anumaya Kotiꞌa kava yagailamatesia kana ago efalote huno aupa humaine.’ hutama hamapaiho. ");
INSERT INTO knb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Nago kumateꞌma visageꞌya falu fala hu otamatesagetama ani kumala ataletama veaꞌmoꞌyama mainesaya katega utama mage hiho ‘Havi kava hae. Tamakai kumapiti kugukege yana taiyalegati aifopo hutalegahunagi tamakaya havilama hutama haviho Anumaya Kotiꞌa kava yagaisia kanamoꞌa ago efalote huno aupa humaine.’ hutama hamapaiho. ");
INSERT INTO knb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nagaya tamahanepauve Anumaya Kotiꞌa kaiyekema hulamatesia kanafina Sotomu mainaya veaꞌmogami amaugafa amagata aigahigi tamakaiꞌma falu fala hu otamatesaya kumate veaꞌmoꞌya tusiya huno amakaseno amaugafa amagata aigahie.” ");
INSERT INTO knb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Avoꞌnio Kolasini mainaya veaꞌmogatamaene Petesaita mainaya veaꞌmogatamaene tusiya huꞌna tamakaifena nahau nehue. Tamakai kumapi nagaya tokiya avameꞌyana ago huanagi tamaipa aiyahae ohageno ani tokiya avameꞌyana Taiyaene Saitoniene huleꞌasine ani kumate veaꞌmoꞌya kefo yaꞌamihena ago amaipa aiyahae huꞌya kefo yama humainaya yafena kayavo kena failiꞌya taꞌnefafi mopale maileꞌasine. ");
INSERT INTO knb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anumaya Kotiꞌa kaiyekema humatesia kanafina Taiya mainaya veaꞌnene Saitoni mainaya veaꞌnene amaugafa amagata yana aligahayanagi tamakaya tusiya hutama nagoꞌene tamaugafa tamagata yana aligahae. ");
INSERT INTO knb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tamakaya Kapaneamu mainaya veaꞌmogatama ‘Taugafa alita anale haigahune.’ hutama nehao? Aꞌao afete tavitama tamakaye nehinagetama maigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nagoꞌene humatenea vayaꞌmogamife mage huno hamapaiye “Tamakai kema havisaya veaꞌmoꞌya aniꞌa huꞌya nagai kea havigahae. Tamakaifema ‘Tamahaoteꞌyatamie.’ hisaya veaꞌmoꞌya aniꞌa huꞌya nagaifena ‘Kahaoteꞌyakae.’ huꞌya hunategahae. Nagaife ‘Kahaoteꞌyakae.’ hisaya veaꞌmoꞌya aniꞌa huꞌya hunatenea kanomofena ‘Kahaoteꞌyakae.’ huꞌya hutegahae huno hamapaigeꞌya umainae.” ");
INSERT INTO knb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Uteꞌyama ayana ani sevetituꞌa (72) vayala muse huꞌya eꞌya mage hae “Anumayamoga tagaya kagai kagileti Kefo Avamuꞌa humatonageꞌya tagai ke akave malae.” huꞌya me hae. ");
INSERT INTO knb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hageno Yisasiꞌa amakaifena mage huno hie “Nagaya agoana Sataniꞌa ikateti aulumaya alia kava huno aupaꞌa asaga hunelavigeꞌna agoe. ");
INSERT INTO knb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Haviho nagaya tokiya ago tamaminoe. Nagoꞌa yamoꞌa tamakaila alino haviya otamahaugahie. Satani tokiyamona agasesaya tokiya ago tamaminoe. Vaya anigeno nefalia osifaꞌvene yapaveꞌene tamaiyaleti ayelatapesayana nagaiꞌni tokiya ago tamaminoafe otamahaegahie. Nagoꞌa yamoꞌa tamakaila ali haviya otamahaugahie. ");
INSERT INTO knb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tokiyaꞌnia ago tamaminogi Kefo Avamula amakasesaya tokiya tamaminoa yafena musena ohutama Anumaya Kotiꞌa tamakima ikapinaga kaemalenea yafena tusiꞌa muse hiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ani kanafina Alu Aotage Avamuꞌmoꞌa tusiya huno muse hisia agu agesa amigeno Yisasiꞌa muse nehuno mage huno hie “Nenafagae mukiꞌa ma mopafi yaꞌene ikapinaga yaꞌene kava yagaimainana Anumayamoga kanale kava nehane. Ma ma hamapauva kea nagoꞌa ‘Mukiꞌa yafena havilinoa kano mainoe.’ huꞌya haya veaꞌmogamifena ohavisae huka falakimalenane. ‘Ala avo nopi umainona vea mainone.’ huꞌya hisaya veaꞌmogamifena ohavisae huka falakimalenanagi ‘Inamu nafaꞌne kana huta mainone.’ huꞌya humainaya veala ago huhaleka amavelimainanafe aluya huꞌna musekaꞌa nehue. E, Nenafagae kagai kagu kagesamoꞌa aniꞌa humainegeka ani kavala humainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Veaꞌmogamifena mage huno humaine “Nenafaꞌa mukiꞌa lokiya ago namine. Mukiꞌa veaꞌmoꞌya nagaila neꞌamonina aepaꞌnia ohavinagi Nenafaꞌa agaiꞌage nagai aepaꞌa haviline. Havilinegi mukiꞌa veaꞌmoꞌya Nenafa aepaꞌa ohavinae. Nagaiꞌnige neꞌamoꞌna havilineꞌna nahaisia veaꞌmogamina humavelisugeꞌya Nenafa aepaꞌa havigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yisasiꞌene toꞌkaeꞌya nemaiya anagaꞌmoꞌya amahaote mainageno Yisasiꞌa mage huno hamapaiye “Anumaya Kotiꞌa tamaulagama neꞌagaya yana ago tusiꞌa kanale ya ago tamamia yafena tusiꞌa muse hutama maiho. ");
INSERT INTO knb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tamahapauve nayona mukiꞌa mainaya amaune vayaꞌene sauve vayaꞌyagaene tamakayama neꞌagaya yana ‘Agesune.’ huꞌya hayanagi oꞌagenae. Havilinaya kea ‘Havisune.’ huꞌya hayanagi ohavinae.” huno hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nagoꞌa kahegi kema havilinea kanomoꞌa hetino Yisasina ayevataga huno mage huno havige “Humavenelina kanomogae nagaya hanaꞌa huteꞌna agola maige maige hisua nahaimula alisue?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Havigegeno Yisasiꞌa mage hie “Anumaya Koti autaꞌmafina naꞌane huꞌya kaemalenae? Kagaya hapaliteka ani kemo aepaꞌa naꞌane huka nehavine?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Havigegeno mage hie “Ani kemoꞌa mage humaine ‘Ala Anumaya Kotikamofena tusiya huno kahaino. Kaguꞌafinagatiꞌene kahaino. Kagu kameꞌene amio. Aliꞌya neꞌalina himamukaene amio. Kagesama nehavina yana amio. Kagaika kaugafahema kahaisia avamete mukiꞌa veamogami amaugafahena kahaino.’ huno humaineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Higeno Yisasiꞌa mage hie “Kagai kemoꞌa tamage huka nehane mukiꞌa kanafina ani kava huge huge hisanana maige maige hisana kahaimula aligane.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Higeno ani kanomoꞌa agesafinaga mage huno havie “Yisasiꞌa nagaife kanale kagesa hanea kano mainane.” huno hisiafene huno havige “Mukiꞌa veala tagamife nehane?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Havigegeno Yisasiꞌa mage hie “Nago Yuta kanoa Yelusalemu kumala ataleno Yeliko kumatega ugahe katega neꞌvigeꞌya nagoꞌa musufa vayaꞌmoꞌya katega ageteꞌya atafa huꞌya mukiꞌa afenomaꞌa hanafaleteꞌya aikolimainae. Aikoliteꞌya ataleꞌya vageno falisia kava huno maine. ");
INSERT INTO knb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mainegeno ani yupa mono note kava kanoa ani kate taviana ani kanoa mo neꞌageno agaseno ka agegayalega umaine. ");
INSERT INTO knb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Umainegeno nago Yuta kanoa Livai nofi kanoa aniꞌa huno mo neꞌageno agaseno nago kaiyaga ka agegayalega umaine. ");
INSERT INTO knb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Naꞌa haꞌageno nagola Samelia kanoa kame kanoꞌamoꞌa anile neꞌeleti megeteno tusiꞌa hau hutene. ");
INSERT INTO knb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hau huteteno avate umaineno masave tiꞌene nofi alagamo tiꞌene haemalaya amupina takino haꞌya kiteteno avaleno agaiꞌa toki afumo agupifi ateteno avaleno viaꞌyamo natu vaya nefayaya nopi moteneno kanale huno kava hutene. ");
INSERT INTO knb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kava huteno mainegeno ko tigeno ani nomona nefana tole kina neꞌamino mage huno hapaiye ‘Kagaya kanaleꞌya huka mani kanoa kava huto. Nagoꞌa monekamoꞌma ani kanoleꞌma haꞌno hisigeꞌna nagaya eteꞌna anonakaꞌa kamigahue.’ huno hapaiye.” ");
INSERT INTO knb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisasiꞌa anima hia kea hu haꞌno hugahe mage hie “Naꞌa humainagi na kagesa nehavine? Taliꞌa (3) vayala agaseꞌya vageno hana kanomo musufa vayaꞌmoꞌya hae-malenaya kanomona alino kanapa vayaꞌmoya nehaya kavala hu-tene?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Higeno ani kahegi kema havilinea kanomoꞌa mage hie “Tusiꞌa hau hutenea kanomoꞌa kanapa vaya kana kavala hutene.” huno higeno Yisasiꞌa agaifena mage hie “Kagaya visanaꞌamoga mukiꞌa kanafina aniꞌageꞌya huo.” huno hapai-maine. ");
INSERT INTO knb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisasiꞌene agaiꞌaenema tokaeꞌya nemaiya anagala katega neꞌvageno Yisasiꞌa nago kumate vigeno nago aꞌmo agia Mataꞌe Yisasina avaleno nomaꞌafinaga umaine. ");
INSERT INTO knb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Umainegeno Matana negana agia Maliaꞌe Yisasina aiyafi mopale emaineno Yisasiꞌma hia kaiyekea nehavie. ");
INSERT INTO knb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Havino mainegeno nunaꞌamoꞌa, Mataꞌa, mukiꞌa kavela talo tala hiana agesamoꞌa tole-lole higeno Yisasite eno mage huno hie “Anumayamogae naganaꞌnimoꞌa natalegeꞌna nakaiꞌnige kavela tusiya huꞌna neꞌalugi ani yafena kagesa nohavino? Hapaigeno me naya hino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Higeno Yisasiꞌa mage huno hie “Mataga mukiꞌa yafena kagesamoꞌa tole-lole huka aliꞌyana neꞌalinana havi kava nehane. ");
INSERT INTO knb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nagoke yamaꞌage alisana kagesa havige havige huka maiyo. Maliaꞌa ani yafena agesa havi havi huno atafa nehigi ani yana nago kanomoꞌa hana-ofalegahie.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nago yupa Yisasiꞌa nago kotega maineno Anumaya-motega ke huno havige-maine. Havigeteno agaiꞌaene tokaeno nemaiya anagapiti nago kanomoꞌa mage huno havige “Anumayamogae Yoniꞌene tokaeꞌya nemaiya anagaꞌmogamina humavelimainea kavala huka ‘Naꞌa maꞌa hutama nunamuna hiho.’ huka hulavelio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Higeno Yisasiꞌa mage huno hie “Nunamuma hinutamahena mage hutama hiho ‘Nelafaga kagai kagimoꞌa alu aotage huno hanesie. Kava yagaisana kanamoꞌa efalote hisie. ");
INSERT INTO knb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mukiꞌa kanafima nesuna kavela tamio. ");
INSERT INTO knb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tagaya havi kavaꞌma hulatenaya veala aigeꞌamateteta kefo yaꞌamia atalematona kava huka kefo yatia aigetateka atalelato. Sataniꞌma ayelavataga hisia katela tavaleka otato.’ hutama hiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hamapaiteno mage huno hie “Hana kanomoga kege amuꞌnona negafute uka mage huka hugane ‘Nenafugae taliꞌa (3) maya yoka namisano? ");
INSERT INTO knb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","7","Nago nenafuꞌa kategati eana nesia yana omalegi kanale namisano?’ hukama hisanageno negafuꞌa nomaꞌafinagati make huno kahapaisio ‘Kasalo nenahaegi natalo. Fita ago ki-maleteꞌna nafaꞌneyagaꞌniene ago fae-mainonanagita nagaya hetiꞌna nahavigana yana okamigahue.’ huno hisio? ");
INSERT INTO knb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aꞌao tamahanepauve ‘Negafuꞌma mainoe.’ huno hisia yafena oꞌamigahigi tutuꞌma hia yafe hetino havigea yana amigahie.” ");
INSERT INTO knb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ani yafe tamahanepauve Anumaya Kotitega nago yafema ke hutama havigesagenoꞌa ago tamamigahie. Nago yafema atiyesagenoꞌa afaꞌa tamaveligahie. Fitaleꞌma akalu-kaluma hisagenoꞌa Anumaya Kotiꞌa yakilamategahie. ");
INSERT INTO knb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mukiꞌa havigesaya veaꞌmoya aligahae. Atiyesaya veaꞌmoya ali falote hugahae. Fitaleꞌma akalu-kalu hisaya veaꞌmogamina fita yakimategahie. ");
INSERT INTO knb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hana kanomoga nafaꞌnekamoꞌa noyamehema kahavigesigeka nefaga osifaꞌvea alika amigano? Aꞌao ani yana alika oꞌamigane. ");
INSERT INTO knb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kokole amufema kahavigesigeka yapavena alika amigano? Aꞌao ani yana alika oꞌamigane. ");
INSERT INTO knb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oꞌamiganagi tamakaya havi veaꞌne mainayanagitama nafaꞌnetamimona kanale ya amamiyanagi ikapinaga mainea nelamafaꞌa tusiya huno tamakase-maineanagitama havigesageno Alu Aotage Avamuꞌa tamamigahie. ");
INSERT INTO knb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nago kanomona Kefo Avamuꞌmoꞌa* aguꞌafi mainegeno avefuꞌna alino aiyahae higeno agea noꞌaiyane. Yisasiꞌa ani Kefo Avamula anati-talegeno vigeno ani kanomoꞌa age aino kea kea higeꞌya alitalu hu-mainaya veaꞌmoꞌya ageteꞌya tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amamaꞌyo neꞌaigeꞌya nagoꞌa veaꞌmoꞌya mage hae “Pielesepuliꞌa Kefo Avamuꞌyagale kava hu-mainea kanomoꞌa tokiyaꞌa amigeno Kefo Avamuꞌmona anati-neꞌatalie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hageꞌya nagoꞌa vayaꞌmoꞌya aye-vataga hugahe mage hae “Monafinagati avame yana hugeta tokiyakaꞌa agamano.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hageno Yisasiꞌa amakupinagama ma haviya amaku amakesa ago haviteno mage hie “Nagoke kotega veaꞌmoꞌya aye fako huꞌya tuma hisayana ani kotega veaꞌnene haviya hu-lavigahae. Nago afamo aye fako huꞌya ‘Alu vaya mainone.’ huꞌya tuma hisayana ani afamola haviya hu lavigahae. ");
INSERT INTO knb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sataniꞌa anagaꞌaenema aye fako huꞌya ‘Alu vaya mainone.’ amakaiꞌami tuma hisayana Satani kava yagaisia tokiya hanaꞌa huno hanegahie? Aꞌao tokiyaꞌa omalegahie ani yafe tamakaya nagaifena ‘Pielesepulimoꞌa tokiya kamigeka ani yateti Kefo Avamula neꞌanatine.’ hutama nehayanagi havige nehae. ");
INSERT INTO knb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nagaifena ‘Kagaya Pelesepulimo tokiyaleti anati neꞌatalane.’ hutama hayanagi tamakaitami anagatamia Kefo Avamula amanati-talageno Pielesepulimo amakaila amaya nehio? Ani anagatamia amakaiꞌami manima haya kea ali fako huꞌya tamaveneliye. ");
INSERT INTO knb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tamage nagaya Anumaya Koti tokiyaleti ani Kefo Avamula anati neꞌataloe. Ani yafe Anumaya Kotiꞌa kava yagaisia yana tamakaitela ago emaine. ");
INSERT INTO knb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nagola tokiyaꞌage kanomoꞌma nomaꞌafima ati keveꞌa alino yagai-maleno maisiana mukiꞌa yamaꞌamoꞌa kanale huno hanegahie. ");
INSERT INTO knb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nagola tokiyaꞌage kanomoma eno ani tokiyaꞌage kanoenema tuma hisaꞌana tokiyaꞌage kanomoꞌa agasesiana hagote kanomoꞌma ametitima huno mainea ati keveꞌa melino ani kanomo afeno yamaꞌa musufa alino vayaꞌamogami amamite amamite hugahie. ");
INSERT INTO knb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nagoꞌa veaꞌmoꞌya nagai kanapa veaꞌne omaisayana kame vayaꞌniꞌa mainae. Nagoꞌa veaꞌmoꞌya sipi sipiꞌniꞌama naya huꞌya ali-taluma ohisayana amanati neꞌatalae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nago Kefo Avamuꞌmoꞌa vaya aguꞌafi haino maineleti ataleno viaꞌyamo hau hu-mainea kopinaga mo vaiyatete huno mai-faluma hisia kumafe ati neꞌaye. Ati ayegeteana mai-falu hisia kumala omalegeno “Hagoteꞌna maigeꞌna emainoa aguꞌafi eteꞌna mo maigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Uno mogeana ani agupi ago sese huno kanaleꞌya hu-malenegeno mogemaine. ");
INSERT INTO knb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mogeteno eteno viaꞌyamo seveniꞌa (7) kefo kavaꞌamimoꞌma agase-mainea Kefo Avamuꞌyaga momavaleno egeꞌya ani agupi hai-faleꞌya mainageno hagotenoꞌa ani kanomoꞌa nagoke Kefo Avamuꞌmoꞌa aguꞌafima mainegeno haviya huno maineanagino menia mukiꞌa Kefo Avamuꞌmoꞌya aguꞌafina haiꞌya maigeno tusiꞌa kefo ya hutafa huno maine.” ");
INSERT INTO knb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mani kema higeꞌya anifima alitalu hu-mainaya veaꞌnefiti nago aꞌmoꞌa ala kefiti mage huno hie “Katetenoꞌma numa kaminea aꞌmona Anumaya Kotiꞌa tusiꞌa muse huno haiya yana amine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Higeno Yisasiꞌa mage huno hie “Ani aꞌmoꞌa musena hugahianagi Anumaya Koti kema haviꞌya akave malesaya veaꞌmoꞌya tusiꞌa muse hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mukiꞌa veala agaite melitalu hageno mage huno hamapaiye “Menia ma kanafima mainaya veaꞌmoꞌya tusiya huꞌya kefo veaꞌne mainae. ‘Tokiyaꞌage avame yana tavelio.’ huꞌya hayanagi Anumaya Kotiꞌa ani yana oꞌamamigahigi nagoke avame yana nayoma mainea aune kanoa Yonama hutenea tokiya avame yana tamaveligahie. ");
INSERT INTO knb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonana noyamemoꞌa asaga huno nakaigeno taliꞌa (3) yupa aipafinaga maineafe Ninive mainaya veaꞌmoꞌya avame yana amaveli-maineane. Nagaya ikapinagati emainoa kano vayaꞌmo natenea kanomoꞌna menia ma kanafima mainaya veaꞌmogamina nagaya aniꞌa kavala hisua kavaꞌniꞌa avame yana tamaveligahue. ");
INSERT INTO knb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nagola alu haupalegati emainea sauve aꞌmoꞌa mopamona atupaleti eno Solomoniꞌa kanale agu agesaene kanomo kea havigahe emaineanagi haviho Solomonina agase-mainea kanoa ma mainegetama tamakaya agai kea nohaviye. Nohaviyafe Anumaya Kotiꞌa kaiyekema hulamatesia yupa ani aꞌmoꞌa hetino menia ma kanafima mainaya veafe kefo kava hutama agai kema ohavinaya yafena hu falote hulamategahie. ");
INSERT INTO knb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive kumate mainaya veaꞌmogamina Yonaꞌa Anumaya Koti kea hamapaigeꞌya kefo yaꞌamihena amaipa aiyahae hu-mainagi haviho menia Yonana agase-mainea kanoa ma mainegetama tamakaya kefo yatamihena tamaipa aiyahae nohae. Tamaipa aiyahae nohayafe Anumaya Kotiꞌa kaiyekema hulamatesia kanamoꞌa Ninive kumate nayoma mainaya veaꞌmoꞌya hetiꞌya menia ma kanafima mainaya veaꞌmoꞌya havi kava hu-mainayafe hu falote hulamategahae.” ");
INSERT INTO knb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Veaꞌmoꞌya lamua hanagaliteꞌya nopinaga hanesia komufinaga omalegahae. Susufaneletila aiso ohugahagi ani nopima hai falesaya veaꞌmoꞌya agesayafe sipale nemalae. ");
INSERT INTO knb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tamaulagamoꞌa tamakupinaga aivasa hisia lamu hane. Tamaulagamoꞌa kanale yama agesiana tamakupinaga aivasa hu-mainegi tamaulagamoꞌa kefo yama agesiana tamakupinaga haniki-maine. ");
INSERT INTO knb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tamakesa havilama hiho ‘Nagupinaga aivasa hu-maine.’ hutamama hisayana asu huno haniki-mainesia yafe hisagi kava yagaitama maiho. ");
INSERT INTO knb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mukiꞌa tamaugafa aivasa hisigeno nagoke kaiyaga hanima okisiana lamumoꞌma aivasa hia avamete mukiꞌa lamakupinaga tusiya huno aivasa hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nagola Falasia kanomoꞌa Yisasifena mage huno hie “Menia kagaya nagaiꞌene kavela me negane.” huno higeno Yisasiꞌa kave mo negahe Falasia kanomo nopi haino mopale maine. ");
INSERT INTO knb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mainegeno ani Falasia kanomoꞌa mogeana Yisasiꞌa kaveꞌma negahena ayana sese ohuno* mopale maiya yafena agesa havi havi huno maine. ");
INSERT INTO knb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mainegeno Yisasiꞌa mage huno hapaiye “Tamakaya Falasia* vayaꞌmogatama amega kava hutama masutamiene yopatamiene amega kaiyagaꞌa sese nehagi tamakupina musufa yaꞌene kefo yatamiene hiya hulamatenegetama sesela nohae. ");
INSERT INTO knb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tamakaya aifoꞌnafo vaya mainageno Anumaya Kotiꞌa amega kaiyagaꞌage talo nehuno agusafinaga talo ohuneo? ");
INSERT INTO knb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Masutamiene yopatamienema hanesia kavela kasagoꞌya yaꞌamima omalenesia veaꞌmogamima amamisayana tamakuꞌamoꞌa oniꞌyaꞌage ohugahie. ");
INSERT INTO knb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Avoꞌnio Falasia vayaꞌmogatama kaꞌyeho. Tamakaya supu tala yaꞌene atuꞌene hefi kana yaꞌene osi osi yana alitama teniꞌa (10) malenafiti nagoke Anumaya Kotina neꞌamitama nehayanagi fatago hutama maisaya yaꞌene Anumaya Kotifema lamahaisia yaꞌene ago atalenae. Hagotetama fatago hutama mainetama Anumaya Kotifena tamahau tamayamopafi tamahau-maineanagitama haenagaꞌa supu tala yaꞌene atuꞌene hefi kana yaꞌene teniꞌa (10) malenafiti nagoke Anumaya Kotina amisayana kanale hugahie. ");
INSERT INTO knb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Avoꞌnio Falasia vayaꞌmogatama kaꞌyeho. Mono nopima neꞌutama ‘Kava vayayaga nemaiya sialefekeꞌya maigahune.’ hutama veaꞌne atagu nefaya kumapina ‘Nagaifena ala kano mainane huꞌya hisae.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Avoꞌnio tamakaya kaꞌyeho. Tamakaya vaya hevaimatenaya komu kana hutama mainae. Tamakuꞌamoꞌa oniꞌyaꞌage higetama falaki-mainageꞌya veaꞌmoꞌya oniꞌyaꞌage yama hanea komufi vaya hevaitenaya komule oꞌageꞌya ute ete nehae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Higeno nagola kahegi kema havilinea kanomoꞌa kenonaꞌa mage huno hapaiye “Hulavenelina kanomogae ani kema hanana tagaiꞌenefe tagaye hia ke nehane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Higeno mage huno hie kahegi kema havilinaya vayaꞌmogatama tamakaifeꞌene nehugi avoꞌnio kaꞌyeho. Tamakaya kahegi ke malenaya ke hutama tusiꞌa kanaꞌage ya mukiꞌa veaꞌmogami amayoꞌnale malenetama amaya hugahena nagoꞌke tamakinagoa maletama amaya ohageꞌya tusiꞌa kana yakefa neꞌaliye. ");
INSERT INTO knb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Avoꞌnio kaꞌyeho. Tamakinago-moꞌya Anumaya Koti amaune vayaꞌa hamayageꞌya fali-mainayanagitama tamakaya anima fali-mainaya amaune vayaꞌmogami komulega vilasi hoya maitama nehae. ");
INSERT INTO knb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vilasi hoya maitama nehayafe “Tamakinagomoꞌya amaune vayala hamayageꞌya fali-mainaya yafena kanale kava humainae.” hutama nehae. ");
INSERT INTO knb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anumaya Kotiꞌa kanale agu agesaene kanomoꞌa mage huno humaine “Nagaya nagaiꞌni amaune vayaꞌene Aposolo vayaꞌene amakaipina visageꞌya nagoꞌa veaꞌmoꞌya ali haviya humateꞌya nagoꞌa veaꞌmoꞌya hamaesageꞌya faligahae.” ");
INSERT INTO knb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hamayageꞌya fali-mainaya yafe ma mopama talo hu-mainoa kanafina aepa heꞌya mukiꞌa kafua amaune vaya hamayageꞌya fali-mainagi tamakaya meni kanafima mainaya veaꞌmogatama amakaiꞌma humatenaya havi kavaꞌmo anonaꞌamia aligahae. ");
INSERT INTO knb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hagoteno Epolona haegeno fali-maineane. Nagoꞌa hamaeme hamaeme ageno haꞌno hutegeꞌya haenagalafa Sekalaiyana ala mono no kegiꞌyamo amuꞌnopi yafa folamole heti-mainegeꞌya hayageno fali-maineane. Nagaya tamage huꞌna tamahanepauve hamayageꞌya fali-mainagi tamakaya menima mainaya veaꞌmogatama hu-mainaya havi kavaꞌmo anonaꞌamia aligahae. ");
INSERT INTO knb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Avoꞌnio kahegi kema havilinaya anagaꞌmogatama kaꞌye ho. Mukiꞌa Yisasi kea havimainayanagi veaꞌmoꞌya ohavisae hutama fita ki-maletetama yakisaya ki nofila ago alitama atalenae. Tamakaya “Ani nopi ohaigahune.” hutama haleti nagoꞌa veaꞌmoꞌya “Hai falegahune.” huꞌya haya veaꞌmogamife “Hai ofalegahae.” hutama katile neꞌamatae huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yisasiꞌa ani nopiti hati-lavigeꞌya mukiꞌa kahegi kema havilinaya anagaꞌene Falasia vayaꞌene akave neꞌuꞌya tusiya huꞌya amaipa kafa heteteꞌya amata huꞌya alu yafe alu yafe agaila havige havige nehuꞌya mage hae “Agaiꞌama hisia keleti atafa huta kaiyekea hutegahune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ani kava higeꞌya ohavunamaꞌa veaꞌmoꞌya alitalu humainaya yapina nagoꞌa veaꞌmogami amaiya aye latapemo huꞌya mainageno Yisasiꞌa agaiꞌenema tokaeꞌya nemaiya anagaꞌamogamife nagoꞌa veaꞌnenefe mage huno hie “Falasia vayaꞌmoꞌya amakupima hanea yana agelama ohuꞌya amavayaleti havigema nehaya yafena kaꞌyeho. Ani yana kai hamemoꞌma halegia kava huno halegino alakefa hugahie. Tamakaya ani yafena kaꞌyeho. ");
INSERT INTO knb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aiso humainea yamona Anumaya Kotiꞌa mukiꞌa alino fufute atalegahie. Falaki-mainesia yamona Anumaya Kotiꞌa mukiꞌa veaꞌmogami amaulagafi ali falote hugahie. ");
INSERT INTO knb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hanipinaga hu-mainesaya kea veaꞌmoꞌya yagefi havigahae. Notamifinaga sumi sumi hutama hu-mainesaya kea kuma amuꞌnopiti ala kefiti keha keha huꞌya hugahae.” ");
INSERT INTO knb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nenafugatama tamahanepauve amega tamaugafaꞌage hefalisaya veafena kolia ohiho. Ani veaꞌmoꞌya tamaku tamameꞌene tamahae falisaya himamuꞌamia omalene. ");
INSERT INTO knb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“Hana kanomofe kolia hisune?” hutama hayanagiꞌna tamahapaigahue. Hefalitenoꞌma hanimo aguꞌafi ata tegelege nehia yapi tamaku tamamema hagaꞌyu hulama-talesia tokiyaꞌama hanea kanoa, Anumaya Kotifeke tusiya hutama koliꞌa hiho huꞌna tamahanepaugi Anumaya Kotifeke koliꞌa hiho. ");
INSERT INTO knb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“Faefuꞌa (5) osi osi namayaga tole haesa moneleti miya nehayanagi Anumaya Kotiꞌa ani nama nagokefena agelaꞌokanino amakaifena agesa havi havi huno mainegi tamakaitamifiti nagokeꞌmoga mukiꞌa namayaga agasetama mainayanageꞌya veaꞌnea ala yaga mainae. Anumaya Kotiꞌa mukiꞌa hanea tamayolagefa ago hapalino haviline. Kolima hisaya yana neꞌataletama afaꞌa maiho. huno hie.” ");
INSERT INTO knb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Tamahanepauve nago kanomoꞌma veaꞌmogami amaulagafi nagaifema “Yisasina naguꞌa amitafa humainoe.” huno hu falote hisigeꞌna nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna Anumaya Koti ensole anagaꞌmogami amaulagafina agaifena “Nagai nafaꞌne maine.” huꞌna hu falote hugahue. ");
INSERT INTO knb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hu falote hugahugi nago kanomoꞌma veaꞌmogami amaulagafi nagaifema “Naguꞌa amitafa nohue.” hunoꞌma hufalote hisigeꞌna nagaya Anumaya Koti ensole anagaꞌmogami amaulagafina ani kanohena “Oꞌagenoa kano maine.” huꞌna hugahue. ");
INSERT INTO knb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nagoꞌa veaꞌmoꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonihema hu-haviya hunatesayana Anumaya Kotiꞌa aigeꞌamateno ani kefo yaꞌamia atalemategahigi veaꞌmoꞌya Alu Aotage Avamuꞌmofema hu-haviya hutesayana Anumaya Kotiꞌa aipa haviya huno aigeꞌamateno ani kefo yaꞌamia ataleoꞌamategahie. ");
INSERT INTO knb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nagai kema huhaletama hisaya yafena kaiyeke hulamategahae. Tamavaleꞌya mono nopi ala kaiyeke hulamate vayate visagetama kolia hutama “Kenonaꞌamia naꞌane ke hisune?” hutama tamakesa kuꞌmoꞌa ohiho. ");
INSERT INTO knb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ani yupa kanoꞌa Alu Aotage Avamuꞌmoꞌa “Mage hiho.” huno tamahapainagetama hugahae. ");
INSERT INTO knb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anima alitalu hu-mainaya veapiti nago kanomoꞌa Yisasina mage huno havige “Humavenelina kanomogae nepuꞌnimona hapaigeno nelaꞌafaꞌma ataleno fali-mainea afenopiti fako huno nagoꞌa namisie.” huno havinege. ");
INSERT INTO knb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Havigegeno kenonaꞌa Yisasiꞌa mage huno hapaiye “Nagaya kaiyekea huꞌna fako hisua kanoa omainoe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hapaiteno Yisasiꞌa amakaifena mage huno hie “Tamakaya maihao hutama maiho. Alu kanomo yafena agetama tamahaꞌyea ohiho. Nago kanomoꞌa kasagoꞌya afenomaꞌa haneanagi ani afenomaꞌamoꞌa kanaleꞌya huno maisia haimula oꞌamigahie.” ");
INSERT INTO knb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nago avame kea mage huno hamapaiye “Tusiꞌa afenomaꞌa hanea kanomona hoyaꞌafina tusiya huno alaga aye-maine. ");
INSERT INTO knb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aye-mainegeno agesafinaga mage huno havimaine ‘Na ya hisue? Kaveꞌnia aliꞌna halaꞌya hisua nona omaleanagiꞌna hanaꞌa hisue?’ ");
INSERT INTO knb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Maꞌa hisue. Yu noꞌyagaꞌniꞌa tagape aitaleteꞌna ala noꞌyaga kasagoꞌya kigahue. Kiteꞌna mukiꞌa kaveꞌniꞌaene afenoꞌyaniꞌaene anifi halaꞌya hu-malegahue. ");
INSERT INTO knb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hu-maleteꞌna nagaiꞌnihena mage huꞌna hugahue ‘Nagu nagesamoga mukiꞌa kafua nesua kaveꞌene afenoꞌyaniꞌaene ago halaꞌya hu-malenogi menia nagaya maifalu huꞌna maineꞌna kaveꞌniene tiniꞌaene nege nege nehuꞌna muse huꞌna maigahue.’ huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hianagi Anumaya Kotiꞌa agaifena mage huno humaine ‘Ani kava hana kavala aifoꞌnafo kano kana kano mainananagika meni kegela kahaimula kahafalesugeka faligane. Falitesanageꞌya talo tala humalenana afenoꞌyagakaꞌa taꞌya aligahae?’ huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Huteno Yisasiꞌa mage huno hie nagoꞌa veaꞌmoꞌya amakaiꞌami amaugafa aliꞌya haisaya yafe mone afenoꞌamia halaꞌya nehayanagi Anumaya Kotiꞌa musema hisia kavala aliꞌya halaꞌya nohayafe ani kanomoꞌma humainea kava kana veaꞌne mainae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tuelufuꞌa (12) anagaꞌamogamife mage huno hamapaiye “Ani yafena nagaya tamahanepauve kanale hutama maisaya yaꞌene kave nesaya yaꞌene ti nesaya yaꞌene tamakesa havi havi ohiho. Tamaugafale kena failisaya yafeꞌene tamakesa havi havi ohiho. ");
INSERT INTO knb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kave neyana aifa letale yanagi kahaimuna kanaleꞌya huka maisana yana kanale ya hane. Kena failisana yana amegale yanagi veaꞌnea tokiya ya mainae. ");
INSERT INTO knb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hakiki namayaga ageho. Amakaya avina yana ofaiꞌya kavela hoyafinagatila noꞌaliye. Kave malesaya noꞌamiene yu noꞌamiene omaleneanagi Anumaya Kotiꞌa kavela afaꞌa neꞌamamie. Tamakaya namayaga amakase-mainaya veaꞌne mainayafe tamakaiꞌene kava yagailamategahie. ");
INSERT INTO knb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tamakaitamifitila nago kanomoꞌa ‘Ofaliꞌna nagoꞌene maime maime haigahue.’ huno tokiyaꞌage agesa havisiana anima havia katela hanaꞌa huno falote hugahie? Aꞌao falote ohugahie ");
INSERT INTO knb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ohugahigi ani osi ya kanoꞌa ohaleꞌasine naꞌa higetama nagoꞌa maisaya yafena tamakesa havime havime nehaiye? ");
INSERT INTO knb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ageho talapinaga hanea vilasiyamoꞌya haiꞌya ausea nehae. Aliꞌyana aliꞌya kenaꞌamia talo huꞌya fainoꞌaligi kanale kenaꞌami hanegeꞌna nagaya tamahanepauve nayoma mainea ala sauve kanotamia Solomoniꞌa kanale kenaꞌa failianagi ma vilasiyamoꞌya kanaleꞌya huꞌya agase-mainae. ");
INSERT INTO knb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tala yana meni kanafina hoyafina haneanagi ega hataga huꞌya atafi atalegahagi Anumaya Kotiꞌa ani tala yana kava yagaigeno kanaleꞌya humainegi tamakaya mukiꞌa veaꞌmogatama nagaifena tamakupi maletama tamametitia osi kanoꞌa nehagi Anumaya Kotiꞌa aniꞌa huno tamakaila kenatamia alino hilato hulamategahie. ");
INSERT INTO knb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ani yafe ‘Kaveꞌene tiꞌene na ya negahune?’ hutama tusiꞌa tamakesa havi havi ohiho. ");
INSERT INTO knb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Naꞌa yafena ma mopale mainaya veaꞌmoꞌya Anumaya Koti kema nohaviya veala amakesa havi havi huꞌya nemaigi Nelamafaꞌa nesaya yaꞌene kena failisaya yaꞌenefena ago havimaine. ");
INSERT INTO knb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Havimaineafe tamakaya ani kavala ohutama Anumaya Kotiꞌma kava yagaisia kumate visayafe tamakesa havi havi hutama maisayana Anumaya Kotiꞌa ani yaꞌene mukiꞌa kavetamiene kenatamiene tamamiteno ani kumatela tamavaleno tamategahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nenafugatama tamakaya osi kanoꞌa sipi sipia mainagi kolia ohiho. Nelamafaꞌa kava humainea kumatela utama visageno kava yagailama-tesigetama maisayafe agesa havino mainegi kolia ohiho. ");
INSERT INTO knb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ani agesa havimaineanagitama afenoꞌyatamia alitama afenoꞌyaꞌami omalesia veaꞌmogami amamiho. Na kava hisayana ikapinaga muse yatamia talo hugahae. Ani ikapinaga muse yana haꞌno ohugahie. Musufaya nehaya vayaꞌmoya musufayama hugahena ani kumatela oꞌugahae. Hakaꞌnomoꞌa ali haviya ohugahie. ");
INSERT INTO knb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Muse yatamima malenesaya kumatefe tamakesa havi havi hutama ani kumate visaya tamaku tamakesa havitama maigahae. ");
INSERT INTO knb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yisasiꞌa mage huno hie “Ala kanoma esiafe kenatamia alitama aupa hutama failinetama tamamu nofila hulinetama kaꞌnitamia aye haletama maiho. ");
INSERT INTO knb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nagoꞌa aliꞌya vayaꞌmoꞌya ala kanoꞌamimofe agava maisaya kava hutama maiho. Ani ala kanomoꞌa aꞌma alisia imulegati eteno no fitaꞌaleꞌma me kalu-kalu hisigeꞌya aupaꞌa hetiꞌya yakitesayafe agava mainae. Tamakaya aniꞌa hutama nagava maiho. ");
INSERT INTO knb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ala kanoma emainea kanafina hetiꞌya maineꞌya agavama mainaya aliꞌya vayaꞌamoꞌya tusiꞌa muse huꞌya maigahae. Tamage tamahanepauve ani ala kanomoꞌa kenaꞌa ali aupa huno failineno aliꞌya vayaꞌahe ‘Mopale maiho.’ huno humateteno kavela amamite amamite hugahie. ");
INSERT INTO knb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kege amuꞌnopi esio? Kokolemoꞌa agea oꞌainesigeno esio? Esigenofena hetiꞌya agava maisaya aliꞌya veaꞌmoꞌya tusiꞌa muse hugahae. ");
INSERT INTO knb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tamage huꞌna tamahanepauve nomona nefaꞌma musufaya hisia kanomoꞌa nomaꞌafi ehai falesia kanahema havimaineleꞌasina nomaꞌa ataleno oꞌvigeno nomaꞌafina ehaino musufayana ohileꞌasine. ");
INSERT INTO knb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tamakaiꞌenena talo tala hiho. ‘Menia omegahie.’ hutama hisaya kana kanoꞌale ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna egahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitaꞌa mage huno humaine “Anumayamogae tagaifekeꞌya ani avame kaiyekea tahanepaino ifi mukiꞌa veaꞌne havisae?” huno havigemaine. ");
INSERT INTO knb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Anumayamoꞌa mage huno humaine “Aliꞌya kanomoꞌa kanale agu agesa hanea kanoa aliꞌyamaꞌa agegeno alige alige nehia kanoa tamakaipina hanate maine? Aniꞌama humainea kanomofe kava kanomoꞌa mage hugahie ‘Mukiꞌa aliꞌya veate yagai-maineka kavela fako faka huka mukiꞌa kanafina amamite amamite huo.’ huno hugahie. ");
INSERT INTO knb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hugahigi haenagaꞌa ani ala kanomoꞌa eteno esigenoꞌa hapai-mainea augafa kavaꞌma hinagenofena ani aliꞌya kanomoꞌa muse hugahie. ");
INSERT INTO knb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tamage huꞌna tamahanepauve aniꞌama humainesia aliꞌya kanomofena ala kanomoꞌa mage hugahie ‘Mukiꞌa yaniꞌa kava yagaiyo.’ huno hugahie. ");
INSERT INTO knb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Hugahianagi ani aliꞌya kanomoꞌa agaiꞌa agesafinaga mage huno havisiana ‘Kava kanoꞌnia menia hivi huno omegahie.’ nehuno agaiꞌa aliꞌyate kava yagai-mainesia vegi munaꞌnegi nehamaeno ala kanomo kavela tina neno havilina neno aneginagi nehuno ‘Omegahie.’ huno hisia yupaene kanaꞌaene kava kanoa egahie. Enunoꞌa ani havi kavaꞌma humainea kanomona kaꞌyo kevia ami-maleteno alino haviya huteteno mage hugahie nagaiꞌma veganokano hunenataya veaꞌnene umaiyo huno hutegahie. ");
INSERT INTO knb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nago aliꞌya kanomoꞌa agaiꞌa ala kava kanomona haiya kavafena ago havitenoꞌagi kava kanomona haiya kavala ohuno talo talaꞌma ohunesiana ala kava kanomoꞌa agaila alakefa huno haegahie. ");
INSERT INTO knb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Haegahigi nago aliꞌya kanomoꞌa ala kanomona haiya kavafema ohavino havi kavaꞌma maino nehisigenoꞌa ala kava kanomoꞌa ako huno haegahie. Mukiꞌa yama ali-mainaya veafena ‘Anonaꞌa etetama mukiꞌa yaniꞌa namiho.’ huno hugahie. Mukiꞌa yamaꞌa amamigeꞌya ali-mainesaya veafena ‘Anonaꞌa aꞌva monene etetama menamiho.’ huno hugahie.” ");
INSERT INTO knb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yisasiꞌa mage huno hie “Nagaya ma mopafi ata kaesugeno tesia yafe emainoe. Ani atamoꞌa aupaꞌa tesie huꞌna nagu nagesa nehavue. ");
INSERT INTO knb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nahaesagenofena nagaila tusiꞌa nagata aigahie. Aupaꞌa huꞌya onahaesaya yafe nagu nagesa havua nagesamoꞌa hivi huno talavaꞌnote. ");
INSERT INTO knb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tamakaya na tamakesa nehaviye? ‘Ma mopale taipa falu huta maisuna yana tamigahe Yisasiꞌa emaine.’ hutama nehafi? Aꞌao nagaya tamakaila ali fako hisua yafe emainoe. ");
INSERT INTO knb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Meni kanafina aepa heꞌya faefuꞌa (5) afamola nagoke nopi nemaisaletila tolemogania (2) taliꞌamogamina (3) kame humategaꞌe. Taliꞌamoꞌya (3) tolemoganina (2) kame hunategahae. ");
INSERT INTO knb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mago afamotalamogania nefaꞌa agaiꞌa nafaꞌnemona kame hutesigeno nafaꞌneꞌamoꞌa agaiꞌa nefana kamea hutegahie. Nago tayametalamogania itaꞌamoꞌa munaꞌamona kame hutenageno munaꞌamoꞌa itaꞌamona kamea hutegahie. Vemona itaꞌamoꞌa anofeloꞌamona kame hutenageno anofeloꞌamoꞌa aniꞌa huno nevena itaꞌamona kamea hutegahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Alitalu humainaya veaꞌmogamifena mage hie “Tamakaya yagemoꞌma tavi nefalelegati siaꞌmoꞌma evaꞌyi higetamahena aupaꞌa mage nehae ‘Ko aigahe nehie.’ hutama nehageno ani yana tamage huno falote nehie. ");
INSERT INTO knb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Oko ikama agetetama ‘Amukoꞌage hugahe nehie.’ hutama nehageno ani yana tamage huno falote nehie. ");
INSERT INTO knb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tamakuꞌafina havitama omaletama amegati kea nehaya vagala veala tamakaya mopale yaꞌene ikate yaꞌene agelama hutama neꞌagayanagi naꞌa higetama meni kanafima falote hia kavala agelama hutama noꞌagae?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Naꞌa higetama fatago kavafena tamakaitamia tamakesa havilama hutama nohaviye? ");
INSERT INTO knb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nago kanomoꞌma ‘Haviya hunatanageꞌna kaiyeke hugategahe nehue.’ hunoꞌma kavaleno vinagetana kaiyekema havi kanomoteꞌma ugahema neꞌutana ‘Nenafuga kaipa falu hisia yana kamigahue.’ huka hapaiyo. Aniꞌa ohisanana kavaleno kaiyekema hugatesia kanomote vinageno ani kea haviteno ati vayaꞌmogami ayapi katesigeno kavaleno nofila hugategahie. ");
INSERT INTO knb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nofi hugatesigekahena kaiyekema hugatenea kanomoꞌma ‘Mone namio.’ huno hu-mainesia yamaꞌa oꞌaminukahena nofi nopitila ataleka omegane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ani yupa nagoꞌa vayala Kalili vayafe Yisasina kea hapaigahe eꞌya mage hae “Ani Kalili vayaꞌmoꞌya Anumaya Koti muse yama amigahena sipi sipi nehageno Pailatiꞌa, kava kanomoꞌa, ati vaya humategeꞌya me hamayageꞌya faligeno kolaꞌamiene sipi sipi afuma haya kolaꞌamoꞌene nagopi tavi-maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hageno Yisasiꞌa mage huno hie “Kalili vayaꞌma fali-mainaya vayaꞌmogami kefo yaꞌamia nagoꞌa Kalili vayaꞌmogami kefo yaꞌamimona ago amakaseno hai-mainea yafe fali-mainae hutama tamakesa nehavio? ");
INSERT INTO knb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tamahapauve ani vayaꞌyaga kefo yaꞌamia ala huno otamakaseneanagi tamakaya kefo yatamihena tamakuꞌa aiyahae ohisayana aniꞌa hutama faligahae. ");
INSERT INTO knb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nago yupa Siloamu kumate ayaꞌaya nona tagape ailavino eitiniꞌa (18) vaya hamaegeꞌya fali-mainaya kea havilinao? Na tamakesa nehaviye ani vayaꞌmogami kefo yaꞌamimoꞌa nagoꞌa Yelusalemu mainaya veaꞌmogami kefo yaꞌami ago amakaseno hai-maineafe fali-mainae hutama tamakesa nehavio? ");
INSERT INTO knb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tamahanepauve anima fali-mainaya vayala kefo yaꞌamimoꞌa ala huno otamakasenegi tamakaya kefo yatamihena tamakuꞌa aiyahae ohisayana aniꞌa hutama faligahae.” ");
INSERT INTO knb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yisasiꞌa nago avame kea huno mage hie “Nago kanomoꞌa hoyaꞌafina figi yosa hane. Nago yupa alagaꞌa tagigahe vianagi alagaꞌa omale. ");
INSERT INTO knb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Omalegeno hoyafi aliꞌya neꞌalia kanomofe mage huno hie ‘Havio nagaya taliꞌa (3) kafu alaga aligahe ete ete huanagi alaga omalene. Oꞌayeneafe ani yosa atagi-talo. Naꞌa higeno mopamona limaꞌa afaꞌa nenegeꞌna alu yosa faisue huꞌna nehue.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Higeno hoyafi aliꞌya kanomoꞌa mage hie ‘Musekaꞌa nehugi ma kafuene atalegeꞌna hafuꞌyafina aipopoꞌma huꞌna afumo aifa kateꞌna maleꞌna agano. ");
INSERT INTO knb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Malesugeno nago kafuleꞌma alagaꞌa ayesio? Oꞌayesigeka afaꞌa atagi-talegane.’ huno humaine.” ");
INSERT INTO knb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nago Sapati yupa Yisasiꞌa nago mono nopi maineno humavenelie. ");
INSERT INTO knb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Humaveneligeno nagola kali neꞌalia alagino ani nopina maine. Ani aꞌmona aguꞌafina Kefo Avamula hai fale-maineno tusiꞌa kali neꞌamigeno eitiniꞌa (18) kafu ani kalia ali-maineanagino akaveꞌya ayamufamoꞌa fagagigeno hetino fatago huno nomaiyane. ");
INSERT INTO knb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisasiꞌa ageteno ke huno mage huno hie “Ma aꞌmogae kalikaꞌa ago ali neꞌataloe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nehuno ani aꞌmo augafale aya malegeno anile aupaꞌa akaveꞌya aifatago higeno hetino maineno Anumaya Koti agia alisaga humaine. ");
INSERT INTO knb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nehigeno ani mono nopi soka kanomoꞌa Yisasiꞌma Sapati kanaleꞌma hutea yafena aipa kafa heteteno mukiꞌa veafe mage huno hamapaiye “Aliꞌya kana sikisiꞌa (6) kana hanegi kalitima alino kanale hisie hinutamahena ani aliꞌya kanale eho. Sapati kana kalitami alilino kanale hulamatesia yafena omeho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Higeno Anumayamoꞌa kenonaꞌa mage huno hie “Tamakaya tamakuꞌafina havi omaletama amegati ke nehaya vagala vayaꞌmogatama tamakaya mukiꞌamogatama Sapati yupa toki afuene pulamakatamiene noꞌamifina mo kalu hetama ti amigahena amavaletama neꞌvayane. ");
INSERT INTO knb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naꞌa nehayanagi ma aꞌmona Apalahamu aginagomona Sataniꞌa eitiniꞌa (18) kafu nofi hutegeno kalia ali-maineafe Sapati yupa ani yana ali kalu hetaloa yafe ‘Havi kava hane.’ hutama nehao?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Higeꞌya kame vayaꞌamoꞌya tusiꞌa amakaye higeꞌya mukiꞌa veaꞌmoꞌya kanale kava hia yafe tusiꞌa muse humainae. ");
INSERT INTO knb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yisasiꞌa mage huno hie “Anumaya Kotiꞌma kava yagaisia kavaꞌmoꞌa ma kava humaine? Hanaꞌa huꞌna maꞌa augafa yana hane huꞌna tamahapaisue? ");
INSERT INTO knb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ma osi osi alagamoꞌma hia avamete nehie. Ani alagamo agia masatatie. Osi osi alagama nago kanomoꞌa alino hoyafima fai-malegeno hageteno haino haino ala yosagefa hanegeꞌya namayagamoꞌya akopale noꞌamia ki-mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nagoꞌene mage huno hie “Anumaya Kotiꞌma kava yagaisia kavafena hanaꞌa huꞌna maꞌa yana hane huꞌna tamahapaisue? ");
INSERT INTO knb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kaihamema hale negia avamete humaine. Nago aꞌmoꞌa ani kaihamema halegisia yana alino taliꞌa (3) ala yopafi taꞌnefa falauvaꞌene ali havigu higeno haenagaꞌa mukiꞌa taꞌnefa falauvaꞌmoꞌa halegi-maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisasiꞌa Yelusalemu ugahe osiꞌosi kumaꞌyagaleꞌene ala kumaꞌyagaleꞌene uno humavelie. ");
INSERT INTO knb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Humaveneligeno nago kanomoꞌa mage huno havige “Anumayamogae Anumaya Kotiꞌa naꞌmagi veaꞌne amaku amamena aligatigahie? Osiꞌa veaꞌnefi kasagoꞌya veaꞌne?” huno higeno Yisasiꞌa alitalu humainaya veaꞌmogamina mage huno hamapaiye “Anumaya Koti kumateꞌma visaya fiana osi fia kanoꞌa hane. Ani fiapima vinutamahena tamayamufa alitama tokiyaꞌage hutetama hai falegahae. Hai falegahagi kasagoꞌya veaꞌmoꞌya ‘Hai falesune.’ huꞌya hugahayanagi amukoꞌamia omaleneanagiꞌya hai ofalegahae. ");
INSERT INTO knb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Haenagaꞌa ani noteꞌma kava yagai-mainea kanomoꞌa hetino fita alino kilamatesigetama fiate heti-mainetama fitale aiko nelitama mage hutama hugahae ‘Anumayamogae fita yakilato.’ hutama hisagenoꞌa mage hugahie ‘Nagaya otamakenoane. Tamakaya hanategati aya veaꞌne neꞌae?’ huno hulamategahie. ");
INSERT INTO knb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hulamatesigetama mage hutama hugahae ‘Kagaiꞌene kavela nenonane. Tagai kumate kaiyekea tahapai-mainana kano mainane.’ hutama hugahae. ");
INSERT INTO knb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hugahayanagi mage huno hulamategahie ‘Ago tamahanepauve tamakaila otamakenoane. Hanategati aya veaꞌne neꞌae? Kefo kavakeꞌya ali falote hutama nehaya vealagi nagaitegatila mai-haletama viho.’ huno hulamategahie. ");
INSERT INTO knb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tamakaya mogesayana Apalahamuꞌene Aisakiꞌene Yekopuꞌene Anumaya Koti amaune vayaꞌene Anumaya Koti kumatela mainesagetama mogegahayanagi tamakaya anilela oꞌugahayanagitama malaga mainetama tusiya hutama avia neꞌatetama tamakaitami tamaugafahena tusiꞌa kalagi aigahae. ");
INSERT INTO knb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nagi mukiꞌa veaꞌmoꞌya yagemoꞌma tavi nefalelegatiꞌene evaꞌyi nehilegatiꞌene aluga aluga haupalegatiꞌene Anumaya Koti kumate melitalu huꞌya siale maineꞌya kavela negahae. ");
INSERT INTO knb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Haviho meni kanafina nagoꞌa veaꞌmoꞌya haenagalafa mainaya veaꞌmoꞌya uhagoteꞌya maigahae. Hagoteꞌya mainaya veaꞌmoꞌya haenagalafa maigahae.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Higeꞌya ani kanafina nagoꞌa Falasia vayaꞌmoꞌya mage me hae “Ma kumala ataleka alu kumate vuo. Helotiꞌa ala kava kanomoꞌa ago kahaegahe nehie.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hageno Yisasiꞌa mage hie “Tamakaya utama ani afai kalamona, kesi kate vaiyatete nehia kalamona, nagayama hisua kea mage hutama hapaiho ‘Havio nagaya osi kanaꞌa Kefo Avamula veaꞌmogami amakuꞌafiti ali-taleteꞌna kali veaꞌnene aliꞌna kanale humateteꞌna taliꞌa (3) kanale aliꞌyaniꞌa ali avaya ayegahue.’ huꞌna tamahapai-mainoa kea mo hapaiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hamapaiteno “Anumaya Koti aune kanomona alu kumatela ohaegahayanagiꞌya Yelusalemuge haegahae. Ani yafe nagaya meniene egaene olagaene kate vaiyegahue. ");
INSERT INTO knb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Vaeha Yelusalemu mainaya veaꞌmogatama tamakaya Anumaya Koti amaune vayaꞌyaga nehamaetama yafa kaꞌyo alitama Anumaya Koti humategeꞌya tamakaitega emainaya vayala yafa kaꞌyoteti tavata hamae-mainayanagi nagaya mukiꞌa yupa a kokolemoꞌa nafaꞌneꞌama agekoꞌnafinagama alitalu nehia avamete huꞌna tamakaila nagaya nagaiꞌniꞌale alitalu hulamategahe nehugetama tamakaya ‘Ani kavala ohuo.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haviho ma mainaya kumatefena Anumaya Kotiꞌa ago ataleno ‘Aoteꞌyamaꞌae.’ huno humaineanagitama menia nagoꞌene onagegahagi ‘Anumayamo aliꞌya aligahe higeno hutenea kanoa Anumaya Koti kanale manu amisie.’ huꞌya hisaya kanafi nagoꞌene nagegahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nago Sapati yupa Yisasiꞌa Falasia vayate kava humainea kanomo nopi kave mo nenegeꞌya nagoꞌa Falasia vayaꞌmoꞌya Yisasina ageꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mainageno nagola augafa halegimai kanoa, faligahe nehia kanoa, anile maine. ");
INSERT INTO knb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mainegeno Yisasiꞌa ani kanoa ageteno ani nopi mainaya Falasia vayaꞌene kahegi kema havilinaya vayaꞌene mage huno hamavige “Sapati kanafina kaliꞌamia alino kanale hutesia yana kanale yapi havi yane? Tamakai mono kemoꞌa naꞌane nehie?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hamavigegeꞌya ani vayaꞌmoꞌya nagola osi ke kanoꞌa ohuꞌya afaꞌa mainageno Yisasiꞌa ani kali kanoa atafa hulineno kaliꞌa alino kanale huteteno atalegeno umaine. ");
INSERT INTO knb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vigeno Yisasiꞌa mage huno hamavige “Hana kanomoga Sapati kanafima nafaꞌnekafi pulumakafi komufima tavi-mainesigetama ‘Sapati yupae.’ hutama anifinaga atalesafi ifi aupaꞌa amavayu hugahae?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hamavigegeꞌya mukiꞌa vayaꞌmoya kenonaꞌa kea ohuꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","“Kaveꞌma me neho.” huno ke higeꞌya emainaya vayaꞌmoꞌya “Ala kanomo nemaiya siale emaisune.” huꞌyama nehaya kavala Yisasiꞌa ageteno ani kavaꞌma nehaya yafena mage huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Nago kanomoꞌa kagaifema ‘Ala imuleꞌma eno.’ huno kema hinageka vinukahena ala kanomo nemaiya sialela uomaiyo. Havigu anile mainesanageno nago kanoa kagaseno mainesia ala kanomofe ke hinagenoꞌma emainesigeno kava kanomoꞌa kagaifena mage me hugahie ‘He-tio. Ala kanomo sialelagi kagaya omaiyo.’ huno hugatesigeka kagaye nehinageka akavelaga mo maigane. ");
INSERT INTO knb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nago kanomoꞌma kagaifema ‘Ala kave meno.’ huno kema hinageka vinukahena osi kanomo mainesile mo maiyo. Mopale mainesanageno kagaifema ke humainesia kanomoꞌa megagesiana hinagenoꞌa mage huno hugahie ‘Nenafugae malela omaika neꞌataleka ala kanomo siale haisaga humaika maiyo.’ huno hugategahie. Ani kema hisigeꞌya mukiꞌa anile mainesaya veaꞌmoꞌya kagai kagi alisaga hugahae. ");
INSERT INTO knb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nagoꞌa veaꞌmoꞌya ‘Ala vaya mainonanagita tagia alisaga hugahune.’ huꞌya hisagenoꞌa Anumaya Kotiꞌa ‘Afa vaya mainae.’ huno humategahigi nagoꞌa veaꞌmoꞌya ‘Tagia omale veaꞌne mainone.’ huꞌya hisagenoꞌa Anumaya Kotiꞌa ani veaꞌmogami amakia alisaga hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","“Kavela me neho.” huno ke humainea kanomofe Yisasiꞌa mage huno hie “Ala imuma kigahena mukiꞌa kameta negafuꞌene kafukaganaꞌene kagaika nofi vayaꞌene moneꞌamima hanesia veaꞌneheke ‘Kave me nesae.’ huka kea hu oꞌamato. Haenagaꞌa kagaife ‘Kave meno.’ huꞌya hisagekama mo nesanana anonakaꞌa hai ali-mainane. ");
INSERT INTO knb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","Hai ali-mainanagi ala imuma kigahena maꞌa veafe kea huo moneꞌamima omale veaꞌnegi amaugafa haviya humai veaꞌnegi amaiya haviya humai veaꞌnegi amaulaga asu humai veaꞌnegi huka ke hisanageno Anumaya Kotiꞌa muse yana kamigahie. Ani veaꞌmoꞌya anonaꞌa kavekale kamisaya amakula omalenea yafe kagaya muse hisanageno fatago humainaya veaꞌnema fali-mainesafiti hetisaya kanafina Anumaya Kotiꞌa agaiꞌa anonakaꞌa kamisigeka muse hugane.” ");
INSERT INTO knb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nago kanomoꞌa Yisasiꞌene maineno kave neneno Yisasi kea haviteno mage hie “Nagoꞌa veaꞌmoꞌya Anumaya Koti kava yagaisia kumate haiꞌya maineꞌya kavela neneꞌya tusiꞌa muse hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Higeno Yisasiꞌa mage huno hapaiye “Nago kanomoꞌa ala imu kigahe mukiꞌa veaꞌneyaga ‘Meneho.’ huno ke humaine. ");
INSERT INTO knb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ke humateteno imua ago kimaleteno aliꞌya kanoꞌamona hutegeno viaꞌyamo kema humatenea veaꞌnehe ‘Tamakaya eho. Mukiꞌa nesaya yana ago talo tala humalene.’ huno hamapai-maine. ");
INSERT INTO knb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hamapaigeꞌya ani mukiꞌa veala nagoke nagokeꞌmoꞌya mage hae ‘Tagaya oꞌugahune.’ huꞌya hae. Hageno nagoke kanomoꞌa mage hie ‘Nagola hoya yaufa miya humalenoanagiꞌna mogegahe nehue. Museka nehugi nagaya oꞌugahue.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Higeno nago kanomoꞌa mage hie ‘Nagaya teniꞌa (10) aliꞌya alisia pulumaka miya humaleneꞌna nehuanagiꞌna kanale aliꞌya neꞌalifi agegahe neꞌue. Museka nehugi nagaya oꞌugahue.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Higeno nago kanomoꞌa mage huno hie ‘Menia nagaya yaufa aꞌniꞌa alitenoanagiꞌna museka nehugi nagaya oꞌugahue.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nage hageno eteno ani aliꞌya kanomoꞌa kava kanomona mo hapaigeno ani kava kanomona aipamoꞌa haviya higeno aliꞌya kanoꞌamofe mage huno hapaiye ‘Kagaya aupaꞌa eteka uka kumate mainaya veaꞌnegi moneꞌamiꞌa omale veaꞌnegi aiya haviya humai veaꞌnegi aulaga asu humai veaꞌnegi aumiꞌya haviya humai veaꞌnegi amavaleka eno.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Higeno ani aliꞌya kanomoꞌa ani kava huteno eteno mage huno kava kanomona me hapaiye ‘Kagai kavaya ali hipoꞌya huanagi nagoꞌa siale maisaya yana afaꞌa hanegeno nokaꞌafina hiyala ohune.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Higeno ala kanomoꞌa aliꞌya kanoꞌahena mage huno hapaiye ‘Kagaya kumala neꞌataleka ala katega neꞌuka tala agegayalega nemaiya veaꞌnea ke huka amavayu huka amavaleka noniꞌafina memategeꞌya hiya hiho. ");
INSERT INTO knb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nagaya kahanepauve hagoteꞌna kema nehugeꞌyama omenaya veaꞌnea mukiꞌamoꞌya menia kavela meliꞌya onegahae.’ huno hie.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kasagoꞌya veaꞌmoꞌya Yisasiꞌene neꞌvageno maiyahae huno hamapaiye “Nagoꞌa veaꞌmoꞌya nagai nakaveꞌma egahena nefaꞌene itaꞌamoꞌene aꞌamoꞌene nafaꞌneꞌamoꞌene nepuꞌamoꞌene asaꞌamoꞌene aganaꞌamofeꞌenena ‘Afa vaya mainagi Yisasiꞌa tamakase-mainea yafe naguꞌa aminoa kano mainoe.’ huno ohisia kanomoꞌa nagai kea havino akave omale kano maine. ");
INSERT INTO knb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘Kanaleꞌya huꞌna maisua nahaimula afa ya hanegi Yisasiꞌa agasemai kanogiꞌna naguꞌa aminoe.’ huno ohisia kanomoꞌa nagai kea havino aꞌkave omale kano maine. ");
INSERT INTO knb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nagaila nagatama aisigeꞌna falisua yafema nago kanomoꞌa ‘Ani kava hugahue.’ huno agaiꞌa yafaga yosa kofino nakave visia agesa ohavisia kanomoꞌa nagai kea havino aꞌkave omale kano maine. ");
INSERT INTO knb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tamakaipiti nago kanomoga ‘Ala nokefa kigahue.’ kagesa havinukahena hagoteka ‘Ani noniꞌa kiꞌna avaya ayesua moneꞌnia hanefi?’ huka kagesa havi havi hugane. ‘Mukiꞌa kisua monea hane.’ huteka ani nona aepa heka kigane. ");
INSERT INTO knb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Hagotekama naꞌa ohinuka aepa heka amalagu aiteka posia ayesanageno monekaꞌa haꞌno hisigeka ani no kika avaya ayesana amukoka omalesigeꞌya mukiꞌa agesaya veaꞌmoꞌya kigika hugateꞌya ‘Ma kanomoꞌa nona aepa heno kianagi ani nona hivi huno ki haꞌno hisia amukoꞌa omalene.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nagi nagola sauve kanomoꞌa ‘Nago sauve kanoenema aepa heꞌna tu hugahue.’ huno agesama havinunofena hagoteno mage huno agesa havisie ‘Nagaya teni tauseniꞌa (10,000) ati vayaꞌnia mainagi nago sauve kanomoꞌa tueti tauseniꞌa (20,000) ati vayaꞌa mainayanagiꞌna tuma hisua himamuꞌnia haneo?’ huno agesa havigahie. ");
INSERT INTO knb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Agesa haviteno ‘Aꞌao tuma hisua himamuꞌnia omalene.’ hunoꞌma hinunofena agaiꞌene tuma hisaya vayaꞌmoꞌya ayaꞌayate mainesageno nagoꞌa vayala humateno mage huno hugahie ‘Mage hutama mo havigeho ‘Hanaꞌa hutaꞌa taꞌaipa ali falu hutaꞌa maisuꞌe.’ hutama mo havigeho.’ huno hamapaisigeꞌya mo havigegahae. ");
INSERT INTO knb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mo havigegahagi tamakaipitila nagoꞌa veaꞌmoꞌya mukiꞌa yaꞌamima amakaveꞌno hu oꞌatesayana nagai kea ohavi veaꞌne maigahae.” ");
INSERT INTO knb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tamakaya havilinae solea kanale ya haneanagi hagama nehia yamaꞌa haꞌnoma hisigetama hanaꞌa hutama hagama nehia yamaꞌa ali falote hugahae? ");
INSERT INTO knb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hagama nehia yamaꞌa omalesiana afa ya hanegi afumo aifaene aliꞌya ituyaꞌene hoyafi malesayana afovaꞌage ohugahigi veaꞌmoꞌya afaꞌa hagaꞌyu hutalegahae. Tamakesama hanesiana havilama hutama haviho. ");
INSERT INTO knb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vaya amaugafaleti takisi mone huhatiꞌya aliliteꞌya huꞌya musufayama nehaya vayaꞌene kefo yama hume hume nehaiya veaꞌnene Yisasi ke havigahe avate emainae. ");
INSERT INTO knb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Emainageꞌya Falasia vayaꞌmoꞌyaene kahegi kema havilinaya anagaꞌmoꞌyaene ageteꞌya mage huꞌya ke vaimainae “Ma kanomoꞌa kefo ya nehaya vayaꞌene tokaeno maineno kavela nene.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Nehageno Yisasiꞌa avame kea mage huno hamapaiye “Hana kanomoga tamakaipitila vani hataletiꞌa (100) afua mainefiti nagola fanane higeno ani afumona nefaꞌa mukiꞌa afuꞌa talapinaga amataleno viaꞌyamo nagokeꞌma fanane humainea afuꞌahe atiyeno yeno ageno ali falote hisifi? E, fananema hisigeno aniꞌa huno ati ayegahae. ");
INSERT INTO knb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Atiyeno agefalote huteno tusiꞌa muse huno ageꞌyafi aigagino avaleno umaine. ");
INSERT INTO knb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kumate uvaꞌyi huteno vayaꞌahe ke higeꞌya melitalu hageno mage hie ‘Fananema humainea afua ago agefalote huafe tamakaiꞌene nagaiꞌene muse hisune.’ huno humaine.” ");
INSERT INTO knb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yisasiꞌa hufalote huno mage hie “Ani kava huno mukiꞌa vani hataletiꞌa (100) veaꞌmoꞌya kefo yafe amakuꞌa aiyahae huꞌya fatago kava nehaya veafena Anumaya Kotiꞌa muse hugahianagi nagoke kanomoꞌa kefo yama hume hume nehaisiletiꞌma ‘Kefo yaniꞌa ataleꞌna nagaye higeꞌna aigagiꞌna Anumaya Kotitega eteꞌna naguꞌa amigahue.’ hunoꞌma hisigenofena Anumaya Kotiꞌa tusiꞌa muse hutegahie.” ");
INSERT INTO knb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nago aꞌmoꞌa teni (10) kina malenefiti nagola fanane higeno lamua hanagaliteno nomaꞌafina halafi huno atiyeno yeno ali falote humaine. ");
INSERT INTO knb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ali falote huteno vayaꞌahe ke higeꞌya melitalu hageno mage hie “Tamakaiꞌene nagaiꞌene muse hisune. Moneꞌnima fanane humainea monea ago atiyeꞌna yeꞌna ali falote hue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yisasiꞌa hufalote huno mage hie “Nagaya tamahanepauve ani kava huꞌya Anumaya Kotina ensole vayaꞌamoꞌya nagoke kanomoꞌma kefo yama hume hume nehaisiletiꞌma ‘Kefo yaniꞌahena nagaye higeꞌna aigagiꞌna Anumaya Kotitega eteꞌna naguꞌa neꞌamue.’ hunoꞌma hisigenofena ensole anagaꞌmoꞌya tusiꞌa muse hutegahae.” ");
INSERT INTO knb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisasiꞌa amakaifena mage huno hie nago kanomoꞌa nafaꞌnelatamaꞌa tole mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mainaꞌanagino haenaga nafaꞌnemoꞌa nefafe mage huno hapaiye “Nenafagae falisanana nagai ya hapaegahie huka hunatenana yana ago namio.” huno higeno nefaꞌa mukiꞌa yamaꞌa alino fako huno tole nafaꞌnelatamaꞌamokani anamine. ");
INSERT INTO knb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Anamitegeno haenaga nafaꞌneꞌamoꞌa osi kana kanoꞌa maiteno mukiꞌa mone afenoꞌyamaꞌa alino ayaꞌaya kotega umaineno hu osuꞌyate mone afenomaꞌa motale metale huno age haꞌye hu yateꞌene mone afenomaꞌa mukiꞌa atale haꞌno humaine. ");
INSERT INTO knb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mukiꞌa yamaꞌa haꞌno higeno ani kumatega ala kafu haya kanamoꞌa falote higeno nagoꞌa nesia yana omalegeno tusiꞌa agatemaine. ");
INSERT INTO knb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Agategeno nagola ani kumate kanomotega viaꞌyamo “Aliꞌyakaꞌa alisue.” huno havigegeno “E.” huteno talapinaga hutegeno viaꞌyamo afuꞌale kava yagaino maineno kaveꞌamia amamine. ");
INSERT INTO knb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Neꞌamamino mage hie “Vae nesua kavela omaleanagiꞌna afumo kavepiti haletiꞌnaꞌa nesue.” huno humaine. Hianagi nago kanomoꞌa nesia yana oꞌamine. ");
INSERT INTO knb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Oꞌamigeno agesamoꞌa hao higeno agesafinaga mage huno hie “Mukiꞌa nenafa aliꞌya veaꞌmoꞌya amamu hia no maineꞌya kasagoꞌya kavela nenageꞌna nagaya nagala legeꞌna maꞌa huꞌna falisua kavala nehue. ");
INSERT INTO knb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nehuafe hetiꞌna nenafatega uꞌna mage huꞌna hapaigahue ‘Nenafagae nagaya kefo ya hugatenoe. Kagaiꞌene Anumaya Kotiꞌene kefo ya hulanatoe. ");
INSERT INTO knb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nagaila natenana nafaꞌnekamoꞌnae huꞌna hisuana onategahianagiꞌna musekaꞌa nehugi aliꞌya kanokaꞌa maisua yafe navalo.’ huꞌna hugahue.” huno agesa havimaine. ");
INSERT INTO knb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Haviteno nefatega neꞌeno aluꞌale neꞌegeno nefaꞌa ageteno kalagi aino aiyayeno monukino atako humaine. ");
INSERT INTO knb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Atako nehigeno nafaꞌneꞌamoꞌa agaifena mage huno hie “Nenafagae nagaya kefo ya hugatoe. Kagaiꞌene Anumaya Kotiꞌene kefo ya hulanatoe. Nagaya natenana nafaꞌnekamoꞌnae huꞌna hisuana onategahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Higeno nefaꞌa aliꞌya veaꞌamofena mage huno hie “Aupaꞌa utama kanaleꞌyama humainea kukena alitama me vaiteho. Ayapi vaisia kihana vaitetama aiya noꞌene vaiteho. ");
INSERT INTO knb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ala pulumaka afovaꞌageꞌma humainesia afua hetama kisageta neneta musekase hutesune. ");
INSERT INTO knb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ma ma mainea nafaꞌneꞌnimoꞌa fali-mainefiti hetia yafeꞌene fananema hu-mainefiti efalote hia yafeꞌene musena hutesune.” huno higeꞌya aepa heꞌya tusi muse hutenae. ");
INSERT INTO knb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","Huneꞌatageno yage nafaꞌneꞌamoꞌa hoyafinagati eno note evaꞌyi nehuno haviana yagame haya yaꞌene amo ayaya kene me haviteno aliꞌya kanomofena ke higeno egeno mage huno havige “Na kava nehae?” huno havigemaine. ");
INSERT INTO knb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Havigegeno mage hie “Kaganakamoꞌa ago emaine. Augafamoꞌa kanaleꞌya higeno ea yafe negafaꞌa afovaꞌage afua hegeꞌya neneꞌya hafali ateꞌya mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","29","Higeno nepuꞌamoꞌa aipa haviya higeno “Nagaya nopinaga ohaigahue.” huno higeno nefaꞌa nopinagati eno mage hie “Musekaꞌa nehugi ehaiyo.” huno tutu higeno nefafe mage huno hapaiye “Havio nagaya kasagoꞌya kafua kagai aliꞌya alige-lige huꞌna kekaꞌa nago kanafina ‘Aꞌao.’ huꞌna ohunuanagika vayaꞌniꞌamogamiꞌene muse hisuna yana nagoke meme ataꞌauꞌa heka onamitafa hu-mainanane. ");
INSERT INTO knb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Onaminana yana ma nafaꞌnekamoꞌa mone fenoꞌyagakaꞌa alino kumai aꞌnele momi memi higeno monekaꞌa haꞌno higeno emainegeka afovaꞌage afua heka musekase huneꞌatane.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","Higeno nefaꞌa mage huno hie “Nafaꞌneꞌnimogae mukiꞌa kanafina nagaiꞌene nemainanagino mukiꞌa yaniꞌa kagai ya hanegi kaganakamoꞌa falino fanane humainefiti evaꞌyi hianagita muse huta taipamoꞌa kanale hinageta maisunana ani yamoꞌa kanale hulatesie.” huno hapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisasiꞌa agaiꞌaene tokaeꞌya nemaiya anagafe mage huno hamapaiye nagola tusiꞌa moneꞌa hanea kanomoꞌa ani afenomaꞌale kava nehea aliꞌya kanoꞌamoꞌa mainegeꞌya nagoꞌa vayala ayaꞌamoꞌya ani aliꞌya kanomofe akavelaga ke huꞌya mage hae “Kagai aliꞌyate kava kanomoꞌa mukiꞌa yakaꞌa alino motale metale humaine” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hageno moneꞌama hanea kanomoꞌa kava nehea aliꞌya kanoꞌamofena ke higeno egeno mage hie “Naꞌane huꞌya kagaifena nahanepaiye? Kagaila kava hisana tokiya ago kaminoafe kagaya hanaꞌa huka kava humainane? Huyogiteka menahapaiyo. Nagoꞌene kagaya mani aliꞌyana oꞌaligane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Higeno ani aliꞌya kanomona agu agesamoꞌa mage hie “Aliꞌyaniꞌa nahafalegahe higi hanaꞌa hisue? Hoya aliꞌya alisua tokiyaꞌnia omaleneanagiꞌna aukaꞌya hisugenoꞌa nagaye hugahianagiꞌna hanaꞌa hisue? ");
INSERT INTO knb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hisua yafena menia nagesa havue. Ani kava humatesugeno aliꞌyaniꞌama nahafalesigeꞌya anonaꞌa ani vayaꞌmoꞌya ‘Notifi emaiyo.’ huꞌya hugahae.” huno havimaine. ");
INSERT INTO knb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nagoꞌa ala kanoꞌamoteti nofi humainaya veafe amahaote amahaote ke higeꞌya ageno hagote kanomofena mage huno havige “Nagai kava kanomoꞌa naꞌmagi ya nofila hugatene?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Havigegeno mage hie “Nagaya vani hataletiꞌa (100) kalasini talamu nofila huanagi anonaꞌa oꞌaminoe.” huno higeno aliꞌya kanoꞌamoꞌa mage hie “Anima kae-malenea autaꞌma ma hanegi ani vani hataletie (100) huno hanea avona ayehananeka fifitiꞌae (50) huka kao.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nago kanomofena mage hie “Nofiꞌma humainana yana naꞌmagi ali-mainane?” huno higeno “Vani hataletiꞌa (100) alaisi kula nofi huanagi anonaꞌa oꞌaminoe.” huno higeno aliꞌya kanoꞌamoꞌa mage hie “Anima kae-malenea autaꞌma ma hanegi ani vani hataletia (100) ayehananeka eitiꞌae (80) huka kao.” huno humaine. Ani kavaꞌma hia yamoꞌa ma agesa havie “Haenagaꞌa aliyaniꞌama nahafalesigeꞌya ani vayaꞌmoꞌya mage hugahae ‘Notifi emaiyo.’ huꞌya hisayafenagiꞌna naꞌa kava hugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ani musufaꞌage aliꞌya kanomoꞌa agesa havi havi huno ani kava humainea yafe ala moneꞌama hanea kanomoꞌa mage hie “Kanale kagu kagesa hane.” huno humainegeno Yisasiꞌa mage huno hie “Ma mopale yafema muse nehaya veaꞌmoꞌya mone alisaya yafe amakesa havi havi huteꞌya aliyama aliyana hale yapi mainaya veala ago amakaseꞌya amakesaene veaꞌne mainae. ");
INSERT INTO knb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nagaya tamakaitamige tamahanepauve tamakaya ma mopale monea alitama veaꞌmogami amamisageꞌya nelamafuꞌya maisagetama falisaya yupa ani monea haꞌno hisigeno Anumaya Kotiꞌa maige maige hisaya nopina tamavaleno ali falu fala hulamategahie. ");
INSERT INTO knb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nagoꞌa veaꞌmoꞌya osi osi yate kanaleꞌya huꞌya yagaisayana ala yakefalela aniꞌa huꞌya kanaleꞌya huꞌya yagaigahayanagi nagoꞌa veaꞌmoꞌya osi osi yateꞌma kanaleꞌya huꞌya oꞌyagaisayana ala yakefalela aniꞌa huꞌya kanaleꞌya huꞌya oꞌyagaigahae. ");
INSERT INTO knb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tamakaya ma mopale monema kanaleꞌya hutama kava oꞌyagaisayana ikapinaga tama afenoꞌyateꞌma yagaisae huno otamamigahie. ");
INSERT INTO knb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tamakaya alu veaꞌmogami yateꞌma kanaleꞌya hutama kavama oꞌyagaisayana tamakaitami afenona otamamigahie. ");
INSERT INTO knb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nagoke aliꞌya kanomoꞌa ‘Tole kava kanolatamogani aliꞌya kanoꞌania maisue.’ huno ohisie. Aniꞌa hisiana nagoke kava kanomofe ‘Haivaino naipa nagata aiya kano mainane.’ huno hugahianagi nago kava kanomofena ‘Nahaiya kano mainane.’ huno hugahie. Nago kava kanomona aipa amiteno nago kava kanomofe ‘Falote onahaiya kava hana kano mainane.’ huno hugahie. Tamakaya aniꞌa hutama Anumaya Kotiꞌenefe ma mopale mone fenoꞌenefe ‘Ali lokaetana kava yagailateꞌo.’ hutama hisayana haviya hugahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falasia vayaꞌmoꞌya ani kea haviteꞌya mone fenofema nehamaiya yafena tusiya huꞌya kigiꞌa nehuꞌya kamuge hatageꞌya vaitenae. ");
INSERT INTO knb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kigi hutayanagi Yisasiꞌa amakaifena mage hie “Tamakaya veaꞌmogami amaulagafina ‘Fatago anaga mainone.’ hutama nehayanagi Anumaya Kotiꞌa tamakupina ago agelama huno agemaine. Age-maineanagiꞌya tamakaifema veaꞌmoꞌya tamakeꞌya ‘Tusiꞌa kanaleꞌnale kava nehae.’ huꞌya nehaya kavafena Anumaya Koti aulagafina hiꞌmanaꞌage hia kava nehae. ");
INSERT INTO knb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mukiꞌa kanafina vayaꞌmoꞌya Moseseꞌene Anumaya Koti amaune vayaꞌene humainaya kea haviyanagi Yoniꞌma falote humainea kanaleti aepa heꞌna Anumaya Koti kava yagailamatesia kanale mono kea tamahapaugetama mukiꞌa veaꞌmogatama ‘Anumaya Kotiꞌa kava yagailatesie.’ hutama hugahe tamayamufa aitama tusi ya maitama nehae. ");
INSERT INTO knb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ikaꞌene mopaene haꞌno hugahianagi Anumaya Koti kema kae-malenaya kemoꞌa nagoke kanoꞌa afa ya kanala ohugahie.” ");
INSERT INTO knb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nago kanomoꞌma aꞌama neꞌataleno alu aꞌma alisiana kumai kava humaine. Nagi nago aꞌma anauꞌamoꞌa atalesigenoꞌma mainesia aꞌma alu kanomoꞌma alisayana aniꞌa huno kumai kava humaine. ");
INSERT INTO knb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nago kanoa tusiꞌa moneꞌa hanea kanomoꞌa mukiꞌa kanafina kanaleꞌnale siotaꞌaene kava vayaꞌmoꞌya nehaya kava huno haesa kenaꞌaene failino maineno kanaleꞌnale kavekeꞌya neneane. ");
INSERT INTO knb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Neneanagino no fiamaꞌalela nago kanoa afenomaꞌa omale kanomona amumoꞌa augafa alino haꞌyagi-mainea kanoa mopale nemaiyane. Ani kanomo agia Lasalusiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ani kanomoꞌa agesa mage huno havimaine “Afenomaꞌa hanea kanomo nea kaveꞌmo atupa-napaꞌa yogiꞌna nesue.” huno huteno emainegeꞌya kalayagamoꞌya amutetila me haene haene humainae. ");
INSERT INTO knb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Naꞌa hageno maineno haenagaꞌa afenomaꞌa omale kanoa faligeꞌya ensole anagaꞌmoꞌya mevaleꞌya Apalahamu mainele motageno maine. Mainegeno moneꞌama hanea kanoa aniꞌa huno faligeꞌya aliꞌya mo hevaitenae. ");
INSERT INTO knb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mo hevaitageno haniki-mainea kumapi umaineno augafa agata tusiya huno aigeno maineno agesaga huno anafinaga ageana amuga aluꞌafi Apalahamuꞌene Lasalusiꞌene mainaꞌageno anakemaine. ");
INSERT INTO knb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Anaketeno mage huno ke hie “Vae Apalahamuga naginagomogae kagaya tusiya huka kahauna hunato. Kahau hunateka Lasalusina hutegeno eno aya aginagoleti tipina ayeteno navefuꞌnale malesigeno tani tani nahaisie. Nagaya tusiꞌa atafi mainogeno tusiꞌa nagata neꞌaiye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hianagi Apalahamuꞌa mage huno hie “Nafaꞌneꞌnimoga kagaya nayona mopaleꞌma kanaleꞌya huka mainana kanafina mukiꞌa kanaleꞌnale yakaꞌa ago ali-mainananagi Lasalusiꞌa mukiꞌa havi yamaꞌage ali-maine. Ani yafe kagesamoꞌa aikalo hinageka havio. Menia Lasalusiꞌa ma kumate egenoꞌa aipamoꞌa kanale huno yasi yasi higeno mainegeka kagaya kaugafa kagataenena mainane. ");
INSERT INTO knb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nago yana tagaya mauna kaiyagaene tamakaya mainaya kaiyagaene amuꞌnotifina Anumaya Kotiꞌa tusiꞌa ayo omale komugefa kafi-maleneanagiꞌya ma kumate mainaya veaꞌmoꞌya tamakaitega visaya amakesa haviꞌya usaga humaiꞌya oꞌugahae. Aniꞌa huꞌya kagaiꞌene mainaya veaꞌnea esaga humaiꞌya ma kaiyaga omegahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Higeno ani kanomoꞌa mage hie “Naginagomogae nagaya tusiya huꞌna tutu hugateꞌna kalagi neꞌauve. Lasalusina hutesanageno nenafa notega visie. ");
INSERT INTO knb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Visigeꞌya faefuꞌa (5) naganaꞌnimoꞌya mainageꞌna nagaya tusiꞌa nagata aiya kumate emainoafe kagaya Lasalusina hutegeno visiaꞌamo ala kefiti mage huno hisie ‘Tamaipama aiyahae ohinutamahena nagayama mainoa kumatela egahae.’ huno hamapaisie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Higeno Apalahamuꞌa mage hie “Amakaya Moseseꞌa humainea kene Anumaya Koti amaune vayaꞌmogami kene hanegi ani kemona hapaliꞌya havisae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Higeno moneꞌama hanea kanomoꞌa mage hie “Aꞌao, naginagomogae, Apalahamuga, nani kea ohavinayanagino nagola fali-mainea kanoma komufiti hetino amakaitega mo hamapaisigeꞌya kefo yaꞌamia ataleteꞌya amakaye huꞌya aigagiꞌya Anumaya Kotina amakuꞌa amigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Higeno Apalahamuꞌa agaifena mage hie “Moseseꞌma humainea kene Anumaya Koti amaune vayaꞌmoꞌya humainaya kene amakupima omalenesayana nagola fali-mainea kanomoꞌa komufitila hetino mo hamapaisiana ani kea haviꞌya amakupina omalegahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisasiꞌa agaiꞌaene tokaeꞌya nemaiya anagafe mage huno humaine kefo yama huo huno ayemavataga hisaya yana falote hugahianagi kefo yama hisaya kate tamavaleno visia kanomofena “Kefo kava nehananagika kana yana aligane.” ");
INSERT INTO knb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ani kanomoꞌa nagoꞌa osi anagaꞌnihe “Kefo yama huo.” huno hisiana tusiꞌa kefo kava nehianagiꞌna tusiꞌa kana ya amigahue. Ala yafakefaleti ani kanomo ageꞌyafi maleꞌya nofi kiteꞌya hage lipi hagaꞌyu hutalesayana ani kana yana afa avamete kana ya haneanagi nagaya tusiꞌa kana ya amigahue. ");
INSERT INTO knb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amigahuanagi tamakaya kaꞌye ho. Negafuꞌa kefo yama hinageka “Naꞌa kavala ohuo.” huka kemakio. Amakigeno agayama aguꞌa aiyahaeꞌma hinageka aigeꞌateka kefo yamaꞌa ataleto. ");
INSERT INTO knb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Negafuꞌa nagoke yupa seveniꞌa (7) kanaleꞌma kefo yama hugateteno ani kefo yafe “Naguꞌa aiyahae nehue.” huno hisigekahena kagaya aniꞌa huka seveniꞌa (7) kanale aigeꞌateka kefo yamaꞌa ataleto huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya Anumayamofe mage hae “Kagaife havita tagupi maleta tametiti nehuna yana kagaya nagoꞌene alika ayaꞌaya hulato.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hageno Yisasiꞌa mage hie “Tamakaya nagaifena havitama tamakupi maletama tamametiti nehaya kavala osi masatati yosamo alaga kanoꞌa hanea avamete hutama osiꞌa havitama tamakupi malesayana ma yosahe mage hutama hapaigahae ‘Ma yosamoga kagaya aepa muki tagasi huka ala tipi hageka haiyo.’ hutama hapaisageno tamakai kea akave malegahie.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tamakaipiti nago kanoa aliꞌya neꞌalia kanoꞌamoꞌa hoya aliꞌyapi, afu kava aliꞌyapi, ani aliꞌyana alino haꞌno huno esigenoꞌa ala kanomoꞌa ani aliꞌya kanohe mage huno hapaisio “Kagaya aupaꞌa me maifalu huka maineka kavela no.” huno hapaisio? ");
INSERT INTO knb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aꞌao ani kea ohugahianagino mage huno hugahie “Kagaya kaveꞌnia talo tala hunateka kenakaꞌa faiteka kaveꞌnia alika me namigeꞌna hagoteꞌna netesugeka kagaya haenaga negane.” huno hugahie. ");
INSERT INTO knb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Anima hapaiya kema akave malenea yafena ala kanomoꞌa “Kanale kava hanafe musekaꞌa nehue.” huno hisifi? Aꞌao aniꞌa ohugahie. ");
INSERT INTO knb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tamakaya aniꞌa hutama mukiꞌa tamahapai-mainoa aliꞌyana alitama avaya ayetetama mage hutama hiho “Tagaya kanale aliꞌya anaga omainone. Tagaiti aliꞌyanagita ago alune.” hutama hiho huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisasiꞌa Yelusalemu ukahe viana Sameliaꞌene Kaliliene amuꞌnopi katega umaine. ");
INSERT INTO knb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Nago kumate uvaꞌyi higeꞌya teniꞌa (10) fugita kali neꞌaliya vayala aluꞌale heti-maineꞌya ala kefiti mage hae “Yisasiga ala kano mainanagi tagaila kahau hulato.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hageno Yisasiꞌa amaketeno mage hie “Tamakaya mono nopi kava vayate utama tamaugafa momaveliho.” huno higeꞌya ani vayatega neꞌvageno katega amaugafamoꞌa eteno kanale humatene. ");
INSERT INTO knb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kanale humategeꞌya vafiti nagoke kanomoꞌa augafa ageana kanale higeno eteno katega viaꞌamo ala kefiti muse huno Anumaya Koti agi alisaga humaine. ");
INSERT INTO knb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Huteno Yisasite aiyafi mepe huno maineno aiyale alisoso nehuno “Kagaifena tusiꞌa musekaꞌa nehue.” huno hie. Aiyale alisosoma hia kanoa Sameliati kanoe. ");
INSERT INTO knb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yisasiꞌa ani kanoa ageteno mage hie “Nagesa havuana teniꞌa (10) vaya ago aliꞌna kanale humatenofi? huꞌna huanagi nainiꞌa (9) vayala hanate mainagekae? ");
INSERT INTO knb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Naꞌa higeꞌya ani vayaꞌyaga Anumaya Koti agia melisaga ohae? Mani nagoke kanoa alu kotegati emainea kanomoꞌa agaiꞌage Anumaya Koti agia melisaga nehie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yisasiꞌa ani kanomofena mage huno hapaiye “Kagaya hetika vuo. Nagaifema havika kagupi maleka kametiti hana yamo kagaila alino kanale hugate.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nagoꞌa Falasia vayaꞌmoꞌya mage huꞌya havigae “Na kanafi Anumaya Kotiꞌa aepa heno kava yagaigahie?” huꞌya hageno Yisasiꞌa mage huno humaine “Anumaya Kotiꞌma kava yagaisia kanama falote hisiana tamaulagamoꞌa oꞌagesia kava huno egahie. ");
INSERT INTO knb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Veaꞌmoꞌya ‘Malega hane. Amualega hane.’ huꞌya ohugahagi haviho Anumaya Kotiꞌa tamakaipi ago kava yagaino maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yisasiꞌa agaiꞌaene tokaeꞌya nemaiya anagafe mage huno hamapaiye “Haenagaꞌa nago kanama falote hisigetama mage hutama hugahae ‘Ikapinagati emainea kanoa vayaꞌmo atenea nafaꞌnemona nagoke yupa kanoꞌa agesune.’ hutama hugahayanagi afaꞌa oꞌagegahae. ");
INSERT INTO knb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Oꞌagegahagi nagoꞌa veaꞌmoꞌya ‘Amugalega mainegi ageho.’ nehuꞌya ‘Malega mainegi ageho.’ nehuꞌyama hisagetamahena amakavela oꞌviho. ");
INSERT INTO knb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna eteꞌna esua yamoꞌa maꞌa hugahie ikamoꞌa nago kaiyaga aupaꞌa aulumayaꞌmoꞌma nehia avamete huno mukiꞌa kotega aivasa nehinageꞌna nagaya eteꞌna egahue. ");
INSERT INTO knb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Egahuanagi hagoteꞌya meni kanafima mainaya veaꞌmoꞌya nagaifena ‘Kahaoteꞌyakae.’ huꞌya hunatesageno tusiya huno nagata aigahie. ");
INSERT INTO knb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea nafaꞌnemoꞌna eteꞌna esua kanafima mainaya veaꞌmoꞌya nayoma Noaꞌma mainea kanafima mainaya veaꞌmoꞌya humainaya kavala hugahae. ");
INSERT INTO knb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noaꞌma mainea kanafina kavela neneꞌya tina neneꞌya aꞌnema aliyamoꞌene vele uyamoꞌene mukiꞌa kanafina ani yafekeꞌya amakesa havi havi huꞌya mainageno Noaꞌa ala tipi kalefi haisaga humaigeno tusiꞌa lina hogino mukiꞌa ani veaꞌnea alino haviya higeꞌya ago fali haꞌno humainayane. ");
INSERT INTO knb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lotiꞌma mainea kanafina ani kava huꞌya kaveꞌene tiꞌene neneꞌya nagoꞌa yaꞌamia miya nehuꞌya hoya aliꞌyaꞌamia neꞌaliꞌya noꞌamia negiꞌya mukiꞌa kanafina ani yafekeꞌya amakesa havi havi humainayane. ");
INSERT INTO knb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ani amakesale mainageno Lotiꞌa Sotomua neꞌataleno umainea kanalela Anumaya Kotiꞌa ikapinagati tusiꞌa hiꞌmanaꞌage ata nelea yafaꞌyaga koꞌmopa hia kava huno asaga hulavino mukiꞌa veaꞌnea hamaegeꞌya fali-mainayane. ");
INSERT INTO knb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nagayama ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna eteꞌna esua kanafima mainesaya veaꞌmoꞌya nayona Loti mainea kanafima mainaya veaꞌmoꞌya humainaya kavala aniꞌa hugahae. ");
INSERT INTO knb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yisasiꞌma esia kanafina nagoꞌa veaꞌmoꞌya kumatega mainesaletila afenoꞌyaꞌamia alisaya yafena eteꞌya nopinaga ohaisae. Nagi aniꞌa huꞌya hoyafinaga mainesaya veaꞌmoꞌya eteꞌya noꞌamilegama hanesea afenoꞌya alisaya yafena oꞌvisae. ");
INSERT INTO knb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tamakaya Loti aꞌmoma hutenea kavafena tamakesa aikalo hinagetama havilama hutama haviho. ");
INSERT INTO knb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nagoꞌa veaꞌmoꞌya hamaimuꞌma hanesigeꞌya ‘Mai yatia atafa hutalako huligahune.’ huꞌya amakesama havisayana ani kanale mai yaꞌamimoꞌa fanane hugahianagi nagoꞌa veaꞌmoꞌya ‘Kanalelagita maisuna yatiene tahaimuene Yisasife tagesa nehavita afaꞌa atalegahune.’ huꞌya hisagenoꞌa kanaleꞌya huno mai yaꞌamia aligatimatesigeꞌya maige maige yana aliteꞌya agola maigahae. ");
INSERT INTO knb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tamahanepauve nagayama eteꞌna esua yupa ani kegela tole vekalatana nagoke sipale faeꞌana mainesaꞌagenofena Anumaya Kotiꞌa nagoke avalegahianagino nagola alitaye-talegahie. ");
INSERT INTO knb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Tole atalana tokaeꞌana aliꞌya neꞌalisaꞌageno Anumaya Kotiꞌa nagoke avalegahianagino nagoꞌmona alitaye-talegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Higeꞌya mage huꞌya havigae “Anumayamogae mani kavala hana kumate falote hugahie?” huꞌya havigageno Yisasiꞌa mage huno hamapaiye “Afumoꞌma fali-mainesia kefafina hakikimoꞌya yage yage huꞌya alitalu hunemaiyanagi ikapinagati kanomoꞌna aniꞌa huꞌna mukiꞌa veaꞌmogami amuꞌnopi egahue.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Yisasiꞌa mage hie “Mukiꞌa kanafina nunamuna hiho. ‘Kasalo tahae.’ hutama oꞌataleho. Ani kema havisaya yafe nagola huvame ke tamahapaigahue.” huno mage huno hie “Nago ala kumatela Yasi kanoa maine. Ani kanomoꞌa veaꞌnehe agesa havioꞌamamino Anumaya Kotifena koliꞌa nohiane. ");
INSERT INTO knb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nagola megusa alagino ani kumatela maineno mukiꞌa kanafina ani Yasi kanomote ete ete huno mage huno nehiane ‘Nago kanomoꞌa ali-haviya hunategi kagaya kaiyekeꞌnia havika fatago ho.’ huno havige. ");
INSERT INTO knb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Havige havige maino higeno ani Yasi kanomoꞌa hagote kanafina ‘Kaya ohugahue.’ huno hu-maineanagi eteno haenagaꞌa agu agesamoꞌa mage hie ‘Tamage huꞌna nagaya Anumaya Kotifeꞌene veafeꞌene kolia nohuanagi ma megusa aꞌmoꞌa nagaite ete ete hia yamoꞌa onahaiyanagiꞌna afaꞌa kaiyekeꞌa haviꞌna fatago hugahue. Aniꞌa ohisuana mukiꞌa yupa ete ete hisigeno tusiꞌa kasalo nahaegahie.’ huno humaine.” ");
INSERT INTO knb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yisasiꞌa mage huno hie “Fatago kava ohunea Yasi kanomoꞌma humainea kehena havilama hutama haviho. ");
INSERT INTO knb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Anumaya Kotiꞌma hisia yafena na tamakesa nehaviye? Agaiꞌa havinoꞌma hapalimatenea veaꞌmoꞌya nateꞌene kegeꞌene mage huꞌya havinegae ‘Ali-haviya hulataya veaꞌmogamina ageteka fatago huka kaiyekea humato.’ huꞌya havige havige hisageno ani kea havisio? E, afaꞌa havigahie. Ayaꞌaya kanagefa maiteno amaya hisio? Aꞌao tamahanepauve ali-haviya hu-neꞌamataya veaꞌmogamina aupaꞌa anonaꞌamia humategahie. Nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna eteꞌna esuana nagaifema haviꞌya amakupi maleꞌya ametiti nehaya veaꞌnea ma mopafina mainesao omainegahao?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Nagoꞌa veaꞌmoꞌya amakaiꞌami amaku amakesafiti “Kanale kava nehunageꞌya nagoꞌa veaꞌnea kefo kava nehaya anaga mainae.” huꞌya nehaya veaꞌmogamifena Yisasiꞌa avame ke huno mage huno hie “Tole kanolatamogania nunamu hugahe mono nopi haiꞌana umainaꞌe. Nago kanoa Falasia kanoe. Nago kanoa musufaya huno vaya amaugafaleti takisi mone aliliteno nehia kanoe. ");
INSERT INTO knb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falasia kanomoꞌa amuꞌnote mo hetino maineno Anumayamotega agaiꞌahe mage huno hie ‘Nagaya nagoꞌa veaꞌmoꞌya nehaya kavala nohue. Musufayama haya kavala nohue. Fatago ohunaya veaꞌmogami augafa kavala nohue. Aꞌnele kumai nehaya kavala nohue. Mama mainenoꞌma vaya amaugafaleti takisi mone aliliteno nehia kano kana ohunoe. Ani yafe musekaꞌa nehue. ");
INSERT INTO knb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mukiꞌa sotamo aliꞌyapina nagaya tole yupa kavela mosiꞌna maineꞌna mukiꞌa neꞌalua yapitila teniꞌama (10) malenofitila nagoke alitayeꞌna negamuane.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hianagi vaya amaugafaleti takisi monema aliliteno nehia kanomoꞌa aluꞌale maineno Anumaya Kotitega ke huno havigegahe hetimaineno ‘Nagaya kefo kano mainoe.’ huno ikapinaga agesaga ohuno ape huno havi kafa yonegino Anumaya Kotitega mage huno havige ‘Anumayamogae nagaya kefo kava hume hume nehauva kano mainoe. Nagaifena kalagi ainateka kahau hunato.’ huno havige.” ");
INSERT INTO knb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisasiꞌa mage huno hie “Nagaya tamahanepauve anima musufayama huno takisi monema aliliteno nehia kanomofena Anumaya Kotiꞌa ‘Fatago kano mainane.’ huno hutegeno nomaꞌalega eteno umaineanagi hagote kanomofena ani kea hu oꞌatene. Nagoꞌa veaꞌmoꞌya amakaiꞌami amaugafa aliꞌya haisayana Anumaya Kotiꞌa ‘Osi veaꞌne kanoꞌa mainae.’ huno humategahianagi nagoꞌa veaꞌmoꞌya ‘Osi veaꞌne kanoꞌa mainone.’ huꞌya hisayana Anumaya Kotiꞌa amakia alisaga hugahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nagoꞌa veaꞌmoꞌya osi osi nafaꞌneyaga Yisasite “Aya malesie.” huꞌya amavaleꞌya neꞌageꞌya agaiꞌaene tokaeꞌya nemaiya anagamoꞌya ageteꞌya “Naꞌa kavala ohiho.” huꞌya kemamaki-mainae. ");
INSERT INTO knb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kemamakiyanagi Yisasiꞌa ani nafaꞌneyagahe mage hie “Amatalegeꞌya nagaitega eho.” higeꞌya ageno mage hie “Nafaꞌneyaga nagaite esaya yafena kahegi oꞌamateho. Naꞌa huꞌya nafaꞌnemogami avamete maisaya veaꞌmoꞌya mage hugahae ‘Tagaya tokiyatia omalenegi Anumaya Kotiga kava yagailato.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tamagelafa huꞌna tamahanepauve nagoꞌa veaꞌmoꞌya nafaꞌne mainaya avamete maisaya veaꞌmoꞌya mage hugahae ‘Tagaila tokiyatia omaleanagika Anumaya Kotiga kava yagailato.’ huꞌya ohisayana Anumaya Kotiꞌma kava yagaisia kumatela oꞌugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nago kava kanomoꞌa mage huno havige “Kagaya kanaleꞌya huka humavenelina kanomoga nagaya hanaꞌa huteꞌna agola maige maige hisua nahaimula alisue?” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Havigegeno Yisasiꞌa kenonaꞌa mage huno hie “Naꞌa higeka nagaifena kanale kanoa mainane huka nehane? Anumaya Kotiꞌa agaiꞌage kanale kanoa maine. ");
INSERT INTO knb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kagaya Anumaya Koti kahegi kea ago havilinanagi ani kemoꞌa mage huno humaine ‘Kumai he yana ohuo. Vayala hamaegeꞌya ofaliho. Musufayana ohuo. ‘Ma kanomoꞌa havi kava nehie.’ huka havigea huoꞌato. Itakafokamo kea oꞌatagaeka anakia alisaga huo.’ huno humaineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Higeno ani kanomoꞌa mage hie “Nagaya nafaꞌnema mainoa kanaleti aepa heꞌna mukiꞌa ani kema hana kea akave nemaloane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Higeno Yisasiꞌa ani kea haviteno mage huno hie “Nago kavaꞌene huo. Mukiꞌama malenana mone fenoꞌyaꞌyagaka alika fako faka huka moneꞌamima omalenesia veaꞌne amamisanageno Anumaya Kotiꞌa ikapinaga hanea afenoꞌyana kagaila kamigahie. Afenoꞌyaꞌyagaka fako huka amamite amamite huteka nakave eno.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Higeno ani kanomoꞌa ani kea haviteno mone fenomaꞌamoꞌma kasagoꞌma humainea yafe oꞌatalesia agesa haviteno aipamoꞌa tusi kanaꞌage humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kanaꞌage higeno Yisasiꞌa ageteno mage huno hie “Mukiꞌa mone fenoꞌyaꞌamima hanesia veaꞌmoꞌya tusiꞌa kasageke huꞌya ‘Anumaya Kotife kava yagailato.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nagola pulumaka kana afumo agia kemolomoꞌa nekaꞌyamo kapima hai falesiana afaꞌa yoꞌyo huno hai falegahianagi mukiꞌa mone fenoꞌyamaꞌa hanesia kanomoꞌa Anumaya Kotife ‘Kava yagainato.’ huno kasageke-voke hugahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Higeꞌya ani kea haviteꞌya veaꞌmoꞌya mage huꞌya hae “Naꞌama hu-mainesiana Anumaya Kotiꞌa hana veaꞌmogami amaku amamemaꞌa aligatigahie?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hageno Yisasiꞌa mage hie “Veaꞌmogamina himamuꞌamia omaleneanagiꞌya ohugahayanagi Anumaya Kotiꞌa mukiꞌa kava hisia himamuꞌa haneanagino afaꞌa aligatigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nage higeno Pitaꞌa mage huno hie “Havio tagaya mukiꞌa yatia ataleteta kagai kakavela neꞌone.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Higeno Yisasiꞌa mage huno hamapaiye “Tamage huꞌna tamahanepauve mukiꞌa veaꞌmoꞌya Anumaya Kotiꞌa kava yagaisia keꞌa veaꞌnema mo hamapaigahena noꞌamiene aꞌamiene amasaꞌamiene nepuꞌamiene itaꞌafoꞌamimoꞌene nafaꞌneꞌamiene amataleꞌya visagenoꞌa Anumaya Kotiꞌa mopaleꞌma mainaya kanaleꞌma atalenaya yaꞌene nagoꞌene nagoꞌene anonaꞌa ohavunamaꞌa ya amamiteno haenagama falote hisia kanafina maige maige hisaya hamaimuꞌene amamigahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagala hamaote amavaleno momateneno mage huno hie “Haviho tagaya Yelusalemu haisunageꞌya mukiꞌa Anumaya Koti amaune vayaꞌmoꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonihema kae-malenaya kemoꞌa efalote huno tamage hugahie. ");
INSERT INTO knb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nagaila natafa huꞌya Yuta vea omainaya vayate navaleꞌya momamisageꞌya nagaye hisifa kea hunateꞌya hu-haviya hunateteꞌya amavetuꞌna henategahae. ");
INSERT INTO knb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hegi kaꞌyoteti nahaeteꞌya tavata nahaesageꞌya hevainatesageꞌna tole yupa komufina maiteꞌna tagufa kanale fali-mainesufitila eteꞌna hetigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hianagi Yisasiꞌene tokaeꞌya nemaiya anagaꞌmoꞌya keꞌa haviyanagi ani kemo aepamoꞌa falaki-mainea yafe havilama ohunae. ");
INSERT INTO knb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisasiꞌa Yeliko kumate uvaꞌyi hugahe mo aupa higeno nagola aulaga asu humainea kanomoꞌa kate mopale maineno monehe aukaꞌya hie. ");
INSERT INTO knb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aukaꞌya maino nehigeꞌya mukiꞌa veaꞌmoꞌya agaseꞌya eutele haya yafe “Naꞌa higeꞌya mukiꞌa veaꞌmoꞌya nagaseꞌya eneꞌvae?” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Higeꞌya “Nasaleti Yisasiꞌa neꞌegeꞌya kagaseꞌya eneꞌvae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hageno ala kegefafiti mage huno hie “Yisasiga Tevitina aginagomogae nagaila kahauna hunato.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Higeꞌya aulegama mainaya veaꞌmoꞌya kemakiꞌya “Ke ohuka maiyo.” huꞌya hayanagi nagoꞌene ala kefiti keha keha hie “Yisasiga, Tevitina aginagomogae kahauna hunato.” huno keha keha humaine. ");
INSERT INTO knb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Higeno Yisasiꞌa haviteno anile heti-maineno “Avaletama nagaite eho.” huno higeꞌya avaleꞌya ageno Yisasiꞌa “Naꞌa hugatesue hugeka nehane?” huno havigegeno “Musekaꞌa nehue nagaya eteꞌna naulaga agesua yafe nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Higeno Yisasiꞌa agaifena mage hie “Kaulaga agegali huo. Nagaifema havika kagupi maleka kametiti hanafe kaulagamoꞌa ago kanale hugate.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Higeno aupaꞌa ani kanomoꞌa agegali nehuno Yisasi akave neꞌeno Anumaya Koti agi alisaga nehigeꞌya mukiꞌa anile alitalu humainaya veaꞌmoꞌya ageteꞌya Anumaya Koti agia alisaga humainae. ");
INSERT INTO knb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisasiꞌa Yeliko kumate uvaꞌyi huteno agaseno alulega ugahe vie. ");
INSERT INTO knb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Neꞌvigeno ani kumatela nago kanomo agia Sakiusiꞌa musufaya huno vaya amaugafaleti takisi mone aliꞌyate kava kanogino moneꞌamoꞌa kasago humainea kanoe. ");
INSERT INTO knb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ani kanomoꞌa “Yisasiꞌa hanaꞌa augafa kano neꞌefigagiꞌna agesue.” huno hianagi aupa kanogiꞌya yage yage humainaya veaꞌmoꞌya agasageno “Hanaꞌa huꞌna Yisasina agesue?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yisasiꞌma visia katega aiyayeno uhagoteno nagola fiki yosafi moliteno haimaine. ");
INSERT INTO knb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Haino mainegeno Yisasiꞌa ani yosamo aepale neꞌeno agesaga huno ageteno Sakiusifena mage huno hie “Kagaya aupaꞌa elavio menia kagai nopi momaigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Higeno Sakiusiꞌa aiyayeno laviteno tusiꞌa muse huno Yisasina avaleno nomaꞌalega atene. ");
INSERT INTO knb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Avaleno vigeꞌya veaꞌmoꞌya aniꞌama hia yana ageteꞌya Yisasifena kalugalu ke vaiꞌya mage huꞌya hae “Kefo kavakeꞌya maino nehia kanomo nopinaga maigahe viana havi kava hie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hayanagi Sakiusiꞌa hetino Anumayamofe mage huno hie “Havio Anumayaniꞌamoga menia nagaya afenoꞌyaniꞌa amuꞌnopiti ali fako huꞌna moneꞌamima omale vaya amamigahue. Havigema huꞌna moneꞌamima musufa ali-mainoa monea eteꞌna foꞌa (4) malete malete huꞌna amamigahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Higeno Yisasiꞌa mage huno hapaiye “Kagaya Apalahamuna aginagomoga mainanagi menia anagakaene kagaiꞌene Anumaya Kotiꞌa tamaku tamamena ago alinegatie. ");
INSERT INTO knb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna fanane humainaya veafe amatiyeꞌna amaku amame aligatigahe emainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yisasiꞌa Yelusalemu uvaꞌyi hugahe higeꞌya veaꞌmoꞌya amaku amakesa mage huꞌya haviye “Anumaya Kotiꞌa kava yagaisia kanamoꞌa aupaꞌa falote hugahie.” huꞌya amakesa haviya yafe Yisasiꞌa mage huno nago avame kea hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Nago kava kanomoꞌa kava yagaisia tokiyaꞌa aligahe ‘Ayaꞌaya kotega mo maineꞌna aliteꞌna eteꞌna egahue.’ huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ayaꞌaya kotega ugahe nehuno teniꞌa (10) aliꞌya vayaꞌamogamife ke higeꞌya ageno monea ali-fako huno tueti (20) kina tueti (20) kina amamite amamite hie. Amamiteno mage huno hamapaiye ‘Mani moneleti aliꞌyana aligeno ali kosa nehenageꞌna nagaya eteꞌna ano.’ huno hamapai-maine. ");
INSERT INTO knb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hamapaiteno ataleno umainegeꞌya nagoꞌa vayaꞌamoꞌya ani kava kanomofe amaipa haviya huteteꞌya nagoꞌa aliꞌya vayala humatageꞌya mo humakesa huꞌya ‘Mage hutama hiho. Tagaya mani kanoma kavatima maisia yafena notahaiye hutama hiho.’ huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hageno ani kava kanomoꞌa kava yagaisia tokiyaꞌa ago moliteno ani kotegati eteno monema fako huno amaminea aliꞌya vayamogamife ‘Naꞌmagi mone halaꞌya humalenafi?’ huno havisia yafe amakaife ke hie. ");
INSERT INTO knb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ke higeno hagote kanomoꞌa evaꞌyi huno mage hie ‘Ala kanomogae kagaya tueti (20) kinama naminapitila eteꞌna nagoꞌene aliꞌya aliꞌna kosa hua monene tu hataleti (200) kina alugeno hane.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Higeno ala kanomoꞌa mage huno hie ‘Kagaya kanale kano mainane. Kanaleꞌya huka osi mone kanoꞌa kaminofitila efi efi huka aliꞌyana alinageno ala hiafe kagaila teniꞌa (10) ala kumate kava yagaisane huꞌna hapalinegatoe.’ huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Higeno anile kanoa eno mage huno hapaiye ‘Ala kanomogae kagaya tueti (20) kina naminapitila eteꞌna nagoꞌene aliꞌya aliꞌna kosa hoa monene vani hataleti (100) kina alugeno hane.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Higeno ani kanomofena ala kanomoꞌa mage huno hapaiye ‘Nagaya faefuꞌa (5) kumate kava yagaisane huꞌna hapalinegatoe.’ huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Higeno nago aliꞌya kanomoꞌa anile eno mage hie ‘Ala kanomogae tueti (20) kinama naminana monea afaꞌa omanafi haꞌya kiꞌna katenoanagiꞌna menia ma ma aliꞌna me negamue. ");
INSERT INTO knb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kagaya keꞌage kanoma mainananagiꞌna kolikaꞌa hue. Alu veaꞌmogami yana alika kaugafa hegeka omai kano mainananagika nago kanomoꞌa hoyaꞌafima kali-malenea yaꞌene alika negeka omai kanogiꞌna kolikaꞌa hue.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Higeno kava kanomoꞌa ani aliꞌya kanohena mage hie ‘Kagaya havi aliꞌya kano mainane. Kagaikaꞌa kemo eteno maiyahae huno kaiyekea hugategahie. Kagaya ago havimainane nagaya keꞌage kano mainoe. Alu veaꞌmogami yama aliꞌna naugafa hegeꞌna omai kano mainoanagiꞌna nago kanomoꞌma hoyaꞌafima kali-malenea yaꞌene aliꞌna negeꞌna omai kano mainoanagika kagaya nagaifena ago havimainano? ");
INSERT INTO knb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Naꞌa higeka monema nemalaya nopina moneꞌnia omaleka afaꞌa malenane. Monema nemalaya nopima malenateꞌasina menia nagaya nagoꞌa aꞌva monene aluleꞌasine.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anile hetiꞌya mainaya vayafe mage huno hie ‘Tueti (20) kinaꞌnia hafaletama tu hataleti (200) kinama malenea kanomona amiho.’ huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Higeꞌya amakaya kava kanomofena mage huꞌya hapaiye ‘Ala kanomogae ani kanomoꞌa tu hataleti (200) kina ago alino malene.’ huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hageno mage hie ‘Tamage huꞌna tamahanepauve nago yama hanesia veaꞌmogamina nagoꞌene amamigahigi nago yama omalesaya veaꞌmogamina alilinesamaꞌa hanafalegahie. ");
INSERT INTO knb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kame veaꞌniꞌamoꞌya nagaifena ‘Kavatima maisia yafena notahaiye.’ huꞌya humainaya veala amavaletama naulagale hamaegeꞌya faliho.’ huno hie.” ");
INSERT INTO knb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisasiꞌa anima hia kaiyekea huno haꞌno humaleteno Yelusalemu ugahe uhagoteno katega umaine. ");
INSERT INTO knb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Petafasiene Petaniene ani kumatalana Olivi yosa hanea agoꞌyamona agegayalega hanegeꞌya aupaꞌa uvaꞌyi hugahe hageno Yisasiꞌene tokaeꞌya nemaiya anagapiti tole kanolatana hunateteno mage huno hanapaiye “Atu kumate utana atupa notela hosi kana afumo agia tokigi ani tokimo nafaꞌnea ayetenayanagitana agegaꞌe. Ani tokimo nafaꞌnea vayala oꞌamavalenea tokigi kalu hetana avaletana male eꞌo. ");
INSERT INTO knb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nagoꞌa vayaꞌmoꞌya ‘Naꞌa higetana kalu hetana neꞌvaꞌe?’ huꞌya tanahavigesagetana mage hutana hiꞌo ‘Kava kanotimoꞌa nago aliꞌya aligahe higetaꞌa neꞌoꞌe.’ hutana hamapaiꞌo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hunatea kanolatamogania mogeteꞌana Yisasiꞌma hanapaiya yana ago moge falote humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","34","Ani tokimo nafaꞌnea kalu nehaꞌageꞌya ani afumo nefaꞌya megeteꞌya mage huꞌya hae “Naꞌa higetana tokimo nafaꞌnea kalu nehaꞌe?” huꞌya hageꞌana mage huꞌana haꞌe “Kava kanotimoꞌa aliꞌya aligahe higetaꞌa kalu nehoꞌe.” huꞌana hamapaiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Huteꞌana Yisasite avaleꞌana evaꞌyi huꞌana kenaꞌania anaugafaleti hateꞌana ani afumo agupile yakai-malaꞌageno Yisasiꞌa anile haino maine. ");
INSERT INTO knb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Haino maiteno katega neꞌvigeꞌya veaꞌmoꞌya “Ala kanoa neꞌie.” huꞌya amaugafaleti kenaꞌamia hateꞌya visia katela yakaitenae. ");
INSERT INTO knb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yisasiꞌa viaꞌyamo Olivi yosa hanea agoꞌyamona agegayalegati enelavigeꞌya mukiꞌama melitalu humainaya veaꞌnene agaiꞌenema tokaeꞌya nemaiya anagaꞌaene tokiya avameꞌyama higeꞌya age-mainaya yafe aepa heꞌya ala kefiti Yisasife muse nehuꞌya Anumaya Koti agia alisaga hume hume neꞌuꞌya mage hae ");
INSERT INTO knb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ala kava kanomogae kanaleꞌya huka neꞌane. Anumayamo aliꞌya aligahe hanageno hugategeka emainana kanomoga Anumaya Kotiꞌa kanale manu kamiteno kaya humaine. Ikapinaga amaipa falu hisaya yana hanesie. Anafi mainea Anumaya Kotina agai agia alisaga hisune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hageꞌya anima melitalu humainaya veapiti nagoꞌa Falasia vayala anifi maineꞌya Yisasife mage huꞌya hae “Humavenelina kanomogae kagaiꞌenema tokaeꞌya nemaiya anagakamogamifena ‘Kea ohutama maiho.’ huka hamapaiyo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hageno Yisasiꞌa mage hie “Nagaya tamahanepauve ani veaꞌmoꞌya kema ohuꞌya maisayana yafaꞌyagamoꞌya amakaiꞌami ani kea hugahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yelusalemu kumala aupate hanegeno Yisasiꞌa ageteno ani kumate veafe avite-maine. ");
INSERT INTO knb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Avia ateteno mage hie “Ma kea meni havisae huꞌna nehugi nagaya tamaipamoꞌa falu hisia yana tamamisua kano mainoe. Menima mainogetama ani yana falaki mainegetama noꞌagae. ");
INSERT INTO knb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nagola alu kana falote hisigeꞌya kame vayatamimoꞌya esayaꞌamoꞌya kegiꞌya lafi humalenaya kegiꞌyafi me kagi kagi nehuꞌya ali haviya hulamategahae. ");
INSERT INTO knb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Anumaya Kotiꞌa tamaya hugahe neꞌegetama agai kema ohaviya yafe kame vayatamimoꞌya tamakaiꞌene nafaꞌnetamiene mukiꞌa lafifima mainaya veaꞌnene falifalutisageꞌya yafatetiꞌma kimalenaya nona mukiꞌa ani yafamoꞌa mopafi helafilavigahie.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Yisasiꞌa ani kaiyekea huteno ala mono nopi hai faleno ageana ani nopi mainaya veaꞌmoꞌya monehe ke huꞌya neꞌaliya veaꞌmogamina aepa heno amanatigahe nehuno mage hie “Anumaya Koti autaꞌmafina mage huno kae-maleneane ‘Nagai nona mukiꞌa veaꞌmoꞌya Anumaya Koti agi ayeꞌya ke huꞌya havigesaya no hane.’ huno kae-maleneanagi tamakaya musufa yama hisaya kava hugahena ma nopi emainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mukiꞌa kanafina ani ala mono nopi hai faleno huge amavelige nehigeꞌya ani mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene mukiꞌa veate kava vayaꞌene Yisasima haesaya kafena atiyemainae. ");
INSERT INTO knb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ati maiꞌya ayayanagi mukiꞌa veaꞌmoꞌya agai kehema muse huꞌya agima alisaga haya yafe ala vayaꞌmoꞌya haesaya kana ageꞌya ali falote ohunae. ");
INSERT INTO knb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nago yupa Yisasiꞌa ala mono nopi maineno alitalu humainaya vayala humavelino Anumaya Koti kanale mono kea hamapaigeꞌya ani kumate vayatamaene mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene agaitega emainae. ");
INSERT INTO knb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mage huꞌya hae “Hana augafa ala kanomo hugategeka mani kavala me nehane? Tokiya yaka ta kamine?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Havigageno Yisasiꞌa mage huno hie “Nagaya hagoteꞌna nago yafena tamahavigegahue nagaila nahapaiho. Yoniꞌma tima falematenea yana Anumaya Kotiꞌa hutegeno ani kavala me nehifi afa vayaꞌmoꞌya hutageno lina fale neꞌamate? Hufalote hutama nahapaiho.” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","7","Higeꞌya “Naꞌa maꞌa hugahune.” huꞌya mohu mehu huteꞌya mage hae “Anumaya Koti hutegeno emaine.” hisunagenoꞌa Yisasiꞌa “Naꞌa higetama agai kea tamakupina nomalae?” huno hugahianagita tagaya “Afa vayaꞌmoꞌya hutageno emaine.” huta hisunana mukiꞌa veaꞌmoꞌya “Yoniꞌa Anumaya Koti aune kano maine.” huꞌya ago humainayafe “Yafa kaꞌyoteti tahaesageta faliyafene.” huꞌya mohu mehu huteꞌya Yisasifena kenonaꞌa mage huꞌya hae “Tapiga hutene? Tagaya ohavinone.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hageno Yisasiꞌa mage huno hamapaiye “Nagaya aniꞌa huꞌna hana kanomoꞌa hunategeꞌna emainoe huꞌna tamahaopaigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yisasiꞌa aepa heno veafe nago avame kea mage huno hamapaiye nago kanomoꞌa vaini nofi alaga hoya kali-maleteno noꞌagea vayafe mage hie “Etama hoyaꞌnilela yagaitama maineho. Ani nofiꞌmo alagafitila aye fako hutama aliho.” humateteno ayaꞌaya kanagefa umaigahe alu kotega umaine. ");
INSERT INTO knb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Afu nelea kanafina ani hoyamona nefaꞌa nago aliꞌya kanoꞌa hutegeno kava vayatega nagoꞌa vaini nofi alaga aligahe umaine. Vigeꞌya hoyale kava vayaꞌmoya atafa huꞌya aikoliteꞌya “Okamigahunagi ataleka vuo.” huꞌya hageno ataleno umaine. ");
INSERT INTO knb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Utegeno nagola kayo kayo kanoꞌa hutegeno viana aniꞌa huꞌya aikoliteꞌya agaye hisifa kava huteteꞌya “Okamigahunagi ataleka vuo.” huꞌya hageno ataleno umaine. ");
INSERT INTO knb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Utegeno eteno nagola kayo kayo kanoꞌa hutegeno viana aniꞌa huꞌya aikoligeno kolamoꞌa higeꞌya hoyafinagati avaleꞌya malaga hagaꞌyu hutalenae. ");
INSERT INTO knb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hagaꞌyu hutalageno hoyamona nefaꞌa agesafinaga mage huno havie “Hanaꞌa hisue? Nafaꞌneꞌnimona nahau nayamopafi nenahaiya nafaꞌneꞌnia hutesugeno visigeꞌya agai kea havisao?” huno havimaine. ");
INSERT INTO knb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Agesa haviteno hutegeno neꞌvigeꞌya ageteꞌya mage huꞌya hae “Mamona mani hoyamona nefa nafaꞌne. Nefaꞌma falisigenofena mani nafaꞌnemoꞌa hoyaꞌa aligahianagita agaila ago haegetao. Haesunageno falisigeta mani hoya tagai ya hapaegahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Huteꞌya hoyafinagati avaleꞌya hagaꞌyu hutaleteꞌya hayageno fali-maine. Yisasiꞌa mage hie “Naꞌa hayanagi hoyamona nefaꞌa naꞌa humategahie? ");
INSERT INTO knb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eteno hoyaꞌafima kava yagai-mainaya vayala tavata me hamaesigeꞌya faligahae. Fali haꞌno hisageno alu vayafe ‘Hoyaꞌnilela kava me yagaiho.’ huno hugahie.” huno hie. Higeꞌya anifima alitalu humainaya veaꞌmoꞌya mage hae “Avoꞌnio ani kavala ohisie.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hageno Yisasiꞌa nago kea mage huno hie “Kae-malenaya kemoꞌa mage huno humaineane ‘Vayaꞌmoꞌya yafa noma kigahena nago yafafena ‘Haviya humaine.’ huꞌya atalayanagi haenagaꞌa ani yafamoꞌa ‘Tusiꞌa kanale yafane.’ huꞌya nomo ayetagenale malenae.’ huꞌya kae-malenayane.” huno hie. Huteno amakeno ute ete hiana higeno mage huno hie “Agoꞌma kae-malenaya kemona aepaꞌa havilinao? ");
INSERT INTO knb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mukiꞌa veamoꞌya ani yafateꞌma asaga hulavisayana amaugafamoꞌa atalaga huno haviya hugahianagi ani yafamoꞌa vaya amaugafaleꞌma asaga hulavisiana ailatapeno aitalaga talago hutalegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Higeꞌya kahegi kema havilinaya anagaꞌene mono note kava vayaꞌene “Tagaife ani avame kea nehie.” huꞌya ago haviteꞌya “Menia avaleta kina nopi ategahune.” huꞌya hayanagi vaya amauhe koli huꞌya atalenae. ");
INSERT INTO knb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ataleꞌya ala tokiyaꞌama hanea kanomote kaiyeke hutesiafe Yisasifena kesi amata huꞌya maineꞌya agesaya vayala humatageꞌya moyevataga hisayafe ani vayala “Kanale fatago vaya mainone.” huꞌya fau nehuꞌya Yisasiꞌma hisia keleti atafa hugahe humainae. ");
INSERT INTO knb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Anima kesi kateꞌma vaiyaya vayaꞌmoꞌya mage huꞌya hae “Humaveli kanomogae tagaya havunana nehana kea fatago katekeꞌya hana kanoe. Nagi kava vayaꞌene afa vayaꞌene nagoke katekeꞌya hamapaika veaꞌma amaipa aye kea nohanagi tamage hutafa huka Anumaya Kotiꞌa ‘Ma kate vuo.’ huno hia kegeꞌya taveneline. ");
INSERT INTO knb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nagi takisi he yatela kava kanoa Sisana kanale amisupi oꞌamisune?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Havigageno Yisasiꞌa agaiꞌma ayevataga haya kea ago haviteno mage huno hamapaiye “Nagola alaga monea alitama naveliho.” higeꞌya aveligeno “Mani alaga monelela ta augosaene ta agiene hane?” huno higeꞌya “Sisa augosaene agiene hane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hageno Yisasiꞌa mage huno hie “Sisana agaiꞌa yanagi agaila amiho. Nagi Anumaya Kotina agaiꞌa yana agaila amiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Higeꞌya anima kesi kateꞌma vaiyaya vayaꞌmoꞌya “Vaya amaulagafi hisia keleti atafa hugahe hunanagi tokiya ke hianagita atafa ohugahune.” huꞌya nehuꞌya hia kehe amakesa havi havi huꞌya ke ohuꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Nagoꞌa Satiusi vayaꞌmoꞌya* Yisasitega emainae. Ani vayala mage nehaya vayale “Falimainaya vayala eteꞌya heotigahae.” huꞌya nehaya vayalagiꞌya Yisasite mage huꞌya me havigae “Humavenelina kanomoga Moseseꞌa tagaifena mage huno kae-maleneane ‘Nago kanoma nepuꞌamoꞌa nafaꞌneꞌa oꞌate kanomoꞌma aꞌama ataleno falisigenoꞌa aganaꞌamoꞌa ani aala aliteno maineno fali-mainesia kanomofe anonaꞌa nafaꞌne atesie.’ huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Seveniꞌa (7) konaga mainayanagino nepuꞌamimoꞌa aala aliteneanagino nafaꞌnea oꞌate kano maineno falimaine. ");
INSERT INTO knb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Falitegeno anile aganaꞌamoꞌa aliteana nafaꞌnea oꞌate kano falimaine. ");
INSERT INTO knb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Falitegeno anile aganaꞌamoꞌa eteno aniꞌa hute hute hayana mukiꞌa seveniꞌa (7) konagamoꞌya ani aala alitayana nafaꞌneꞌamia oꞌateꞌya afaꞌa falimainae. ");
INSERT INTO knb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Haenagalafa ani aala falimaine. ");
INSERT INTO knb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Seveniꞌa (7) konagamoꞌya ani aala alitenayanagi fali-mainesafitiꞌma hetisaya kanafina hana kanomo ani aala aligahie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Havigageno Yisasiꞌa mage huno hamapaiye “Ma mopafi mainaya veaꞌmoꞌya vea aligeꞌya aꞌne aligeꞌya nehayanagi haenagaꞌama falote hisia kanafina veaꞌmoꞌya amatea kavama agoꞌma huteꞌya maineꞌya fali-mainesafitiꞌma hetisaya kanafina vemoꞌya aꞌnea oꞌaligahae. Aꞌmoꞌyaenena vea oꞌaligahae. ");
INSERT INTO knb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ikapinaga ensole vaya kana huꞌya maisayafenagiꞌya nagoꞌene ofaligahae. Agoꞌma fali-mainafitila heti-mainayafe Anumaya Koti nafaꞌneyaga maigahae. ");
INSERT INTO knb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Fali-mainaya veaꞌmoꞌya hetisaya kea Moseseꞌa ago haviline. Nago osi yosale ala ata anefela leanagi ani osi yosa otene huno kae-malenea kefiti mage huno kae-maleneane ‘Anumaya Kotiꞌa Apalahamuꞌagi Aisakiꞌagi Yekopugami Anumaya Kotiꞌami mainoe.’ huno humaineane. Ani anagala fali-mainayanagi ‘Anumaya Kotiꞌami mainoe.’ huno humaineafe amaku amamemoꞌa ofaliꞌya afaꞌa mainae huno ani kea humaine. Anumaya Koti aulagafina ani anagala hamaimula afaꞌa hane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Higeꞌya nagoꞌa kahegi kema havilinaya anagaꞌmoꞌya agaifena mage hae “Humaꞌvenelina kanomoga kanale ke nehane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hageꞌya Satiusi vayaꞌmoꞌya koli huꞌya nagoꞌene haviokenae. ");
INSERT INTO knb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yisasiꞌa mage huno hamavige “Veaꞌmoꞌya Kalaisifena, Anumaya Kotiꞌma huꞌtenea kanomofena, ‘Tevitina aginagomoꞌa ma mopale kano maine?’ huꞌya haya kemona aepaꞌa naꞌane hae? ");
INSERT INTO knb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Anumaya Kotifena yagame kae-malenaya avona Tevitiꞌa mage huno humaineane ‘Anumaya Kotiꞌa Anumayanimofena mage huno humaine ‘Tamaga nayatega ala vaya mainalega siale mopale emainesanageꞌna kame vayakaꞌa kaiyafi amatesugeꞌya kagaife ‘Ago tagasane.’ huꞌya hugahae.’ huno kae-maleneane.’ ");
INSERT INTO knb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tevitiꞌa Kalaisife ‘Anumayaniꞌa mainane.’ huno humainegi naꞌa higeno Tevitiꞌa haenagama atesia aginagomofena ‘Anumayaniꞌa mainane.’ huno humaineane?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Mukiꞌa veaꞌnea maineꞌya havigeno Yisasiꞌa agaiꞌene tokaeꞌya nemaiya anagafe mage huno hie “Kahegi kema havilinaya anagafena kaꞌyeho. Ani anagaꞌmoꞌya ayaꞌaya kena failiya yafena ‘Nelagafi notagafi?’ huꞌya nehaya anagale. Vaya atagu nefaya kumapi mo vaiyatete nehuꞌya ‘Naꞌa vaya mainae huꞌya ali falu fala hulatesae.’ huꞌya nehuꞌya mono nopiꞌene imuleꞌene ‘Ala vayaꞌage alitalu huꞌya nemaiya yatekeꞌya maigahune.’ huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ani anagaꞌmoꞌya keto aꞌneyagahena ‘Mono nopima atalesaya monea tamiho.’ huꞌya nehuꞌya noꞌamifima hanea yaꞌyaga musufaya huꞌya moneꞌamia ali haꞌno nehaya anagalagiꞌya vayala ayemavataga huꞌya ‘Kanale anaga mainae.’ huꞌya hisae huꞌya ayaꞌaya nunamuna humainae. Aniꞌama nehaya anagaꞌmoꞌya havi miyana tusiya huno amaugafa amagata aisia yaꞌene aligahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisasiꞌa agesaga huno ageana veaꞌmoya moneꞌamimoꞌma haimainea veaꞌmoꞌya “Monetia Anumaya Kotina amigahune.” huꞌya pokisifi atalenae. ");
INSERT INTO knb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atalageno ageana nagola moneꞌa omale keto aꞌmoꞌa tole osi haesa monea anifi me vaimaine. ");
INSERT INTO knb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Me vaigeno Yisasiꞌa ageteno mage huno hie “Tamagelafa huꞌna tamahanepauve ma ma moneꞌa omale keto aꞌmoꞌa mukiꞌa hagoteꞌyama metalaya veaꞌmogamina amakaseno ala mone metale. ");
INSERT INTO knb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Metaleanagi moneꞌami-moꞌma haimainea veaꞌmoꞌya aliꞌyamaꞌa omalenea monegiꞌya, afaꞌa malenaya mone metalageno ani aꞌmoꞌa mukiꞌa kaveꞌma alino nesia moneꞌa mukiꞌa metale.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nagoꞌa vayaꞌmoꞌya ala mono nofena mage huꞌya hae “Anumaya Koti agi alisaga hugahe vayaꞌmoꞌya kanale yafana aliꞌya ma nona ali hilato huꞌya kimalenae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Hageno Yisasiꞌa mage huno hie “Ma ma neꞌagaya nona nago kanama falote hinagenoꞌa ani yafaꞌyaga mukiꞌa alino lagape aitalesigeno aposi-lavino tole yafamoꞌa nago yafamo agupile aikalo huno omaigahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Hulave nelina kanomogae na kanafi ani kavala hugahie? Hanaꞌa tokiya avameꞌya ani kanama faloteꞌma hisia kanafina taveligahie?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hageno Yisasiꞌa mage huno hie “Nagoꞌa veaꞌmoꞌya havigema tamahapaisagetama havisao? Ohavisaya yafe kaꞌye ho. Kasagoꞌya vayala nagai nagi ayeꞌya ‘Tamaugafa aligatisuna yafe Anumaya Kotiꞌa hulategeta neꞌone.’ huꞌya hisaya vayala evaꞌyi huꞌya ‘Yisasiꞌma eteno esia kanamoꞌa ago falote nehie.’ huꞌya hisagetama amakavela oꞌviho. ");
INSERT INTO knb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","‘Nagoꞌa kotega kame nehae. Nagoꞌa kotegaenema tu hugahe nehae.’ huꞌyama tamahapaisagetama kolia ohiho. Ani yaꞌyaga hagoteꞌya hugahayanagi ma mopama haꞌno hisia yaꞌyaga aupaꞌa vaꞌyi ohugahie. ");
INSERT INTO knb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nago nofi vayaꞌmoꞌya nagoꞌa nofi vayaꞌene kamea hugahae. Ala kotega vayaꞌene nago ala kotega vayaꞌene kamea hugahae. ");
INSERT INTO knb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tusiꞌa imila aligahie. Alu kotega alu kotega tusiꞌa kafu nehuꞌya amakatesia kanaene tusiꞌa kali alisaya kanaene falote hugahie. Ikapinagatila tusiꞌa lamamaꞌyo aisia tokiya avame yaꞌyaga falote hugahie. ");
INSERT INTO knb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma ma tamahapauva kemoꞌa falote ohunesigeꞌya tamakaya nagai nakaveꞌma nehayafe vayaꞌmoꞌya tamatafa huꞌya ali haviya hulamateteꞌya mono nopi kava vayateꞌene Kamani kava vayateꞌene kaiyekea hulamatesayafe tamavaleꞌya kina nopi tamategahae. ");
INSERT INTO knb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tamatesagetama ani kanafina nagai kea hamapaigahae. ");
INSERT INTO knb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hamapaigahagi kaiyekema hulamatesaya yupa ‘Naꞌane hugahune?’ hutama tamakesa ohaviho. ");
INSERT INTO knb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nagi nagaya nagaiꞌniꞌa ani kanafina kanale ke hisaya kea tamahapaisugetama hisageꞌya kame vayatamimoꞌya ‘Havige hae.’ huꞌya ketamia hefala okigahae. ");
INSERT INTO knb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hefala okigahagi ani kanafina itatamimogamiꞌene nelamafaꞌene neputamimoꞌyaene tamasatamimoꞌyaene tamakaitami afamoꞌene nelamafuꞌyaene tamakaifena ‘Ma mainae.’ huꞌya kaiyekema hulamatesaya yafena kame vayatamimogami amayapi tamavaleꞌya tamatesageꞌya nagoꞌamogatamina tamahaesagetama faligahae. ");
INSERT INTO knb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamakaya nagai nakaveꞌma nehayafe mukiꞌa veaꞌmoꞌya amaipa kafa helamategahae. ");
INSERT INTO knb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Aniꞌa hulama-tegahayanagi kanaleꞌya hutama maigahae. Tamayolegefafina nagola haviya ohugahigi tokiyaꞌage hutama hetitama maisayafe agola maige maige hisaya tamahaimula aligahae.” ");
INSERT INTO knb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kasagoꞌya kame ati vayaꞌmoꞌya Yelusalemu kumaꞌma kove kove hisagetama agesayana ani kumala ‘Ali hagagi-talegahae.’ hutama tamakesa havigahae. ");
INSERT INTO knb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Havisayana Yutia mainesaya veaꞌmogatama tamaiya-yetama agoꞌyalega viho. Yelusalemu mainesaya veaꞌmogatama tamaiya-yetama ani kumala ataletama viho. Hoyafinaga mainesaya veaꞌmoꞌya eteꞌya kumaꞌamilega omesae. ");
INSERT INTO knb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ani kanafina mukiꞌa Anumaya Koti kema kae-malenaya kemoꞌa falote huno tamage hisiafe Anumaya Kotiꞌa ani veala kefo yama humainaya anonaꞌa ali haviya humategahie. ");
INSERT INTO knb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ani kanafina amaipaene aꞌnene nute ani-linesia nafaꞌnemogami itaꞌamimoꞌyaenefe tusiꞌa nahau nehie. Ani kanafina Isaleli kumala tusiya huno haviya hugahie. Isaleli veaꞌmoꞌya kefo yama humainaya anonatamia Anumaya Kotiꞌa havi kavala hulamatesigetama tusiꞌa tamaugafa lamakata yana aligahae. ");
INSERT INTO knb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kame vayaꞌmoꞌya nagoꞌa veala ayaꞌaya naepeleti hataga hamaesageꞌya faligahae. Nagoꞌa veala nofi humateteꞌya amavaleꞌya alu kotega Yuta veaꞌne omainaya veaꞌmogami kotega momategahae. Yuta vea omainaya veaꞌmoꞌya eꞌya Yelusalemu kumala mukiꞌa amaiyaleti ayelata-pesageno aposi-lavigahie. Aposi-lavisigeꞌya ani Yuta vea omainaya veala anile emaige maige huꞌya maisageno Yuta vea omainaya veaꞌmoꞌya kava yagaisaya kanaꞌamia haꞌno hugahie.” ");
INSERT INTO knb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yisasiꞌa nagoꞌene mage huno hie “Yagene kaꞌnefiꞌene ikamoꞌene kugava kava huno alu kava humaveligahie. Nagi hage limoꞌa ayepafa hulino ute ete hisia yafena mukiꞌa kotega ma mopafi veala tusiꞌa amamaꞌyo aigahie. ");
INSERT INTO knb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ikateꞌma hanea yamoꞌya kanage kanage huꞌya alu kate kate visaya yafena mukiꞌa ma mopafima mainaya veaꞌmoya ‘Na ya falote hugahe nehie?’ huꞌya nehisageno amaipamoꞌa kanaꞌage nehinageno amaulagamoꞌa kagi kagi hinageꞌya asaga hulavigahae. ");
INSERT INTO knb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mukiꞌa ani yamaꞌa faloteꞌma hutesigeꞌna ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna siate elavisugeꞌya nagegahae. Tusiꞌa himamu yaniꞌaene tusiꞌa hale yaniꞌaene esugetama nagegahae. ");
INSERT INTO knb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ani kugava yaꞌyaga aepama heno esigetamahena ‘Taugafa aligatisia kanamoꞌa ago aupaꞌa falote hugahe nehie.’ hutama hetitama tamanuna alisaka hutama ageho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yisasiꞌa nago avame kea mage huno hamapaiye “Fiki yosaleꞌene afa yosaleꞌene ageho. ");
INSERT INTO knb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ani yosamoꞌa haegafa haisama falote higetamahena ‘Anuna neꞌvalea kana falote hugahie.’ hutama nehae. ");
INSERT INTO knb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aniꞌa hugahianagi anima tamahapauva kugava yama agenutamahena ‘Anumaya Kotiꞌa kava yagaisia kanamoꞌa ago falote hugahie.’ hutama havigahae. ");
INSERT INTO knb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nagaya tamage huꞌna tamahanepauve meni kanafima mainaya veaꞌnea ofalinesageno ani yaꞌyaga falote hugahie. ");
INSERT INTO knb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ikaꞌene ma mopaene ago fanane hugahianagi nagai kemoꞌa fanane ohugahie. ");
INSERT INTO knb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Tamakaitamile yagaiho. Havigu havili nelitetama nehutama havigu kave nesaya yafeꞌene tamaugafale yaꞌenefe tamakesa havi havi hisageno ani yamoꞌma aiso hulamatesiana ala kanomo kalifumoꞌma aupaꞌa hatea kava huno esigetamahena talo tala ohunesageno esigi kava yagaitama maiho. Yisasiꞌa mukiꞌa ma mopafi veaꞌmogami amaulagale evaꞌyi hinageꞌya atali-talu hugahae. ");
INSERT INTO knb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ani yafena tamakaitami nagoke nagokemogatama kava yagaiho. Mukiꞌa kanale tokiyama alisayafena nunamuna higeno ani tokiya tamamisigeno ani havi yama falote hisia kanafina Anumaya Kotiꞌa tamaugafa aligatisigetama ikapinagati emainoa kanoa vayaꞌmo natenea kanomoni naule hetigahae.” huno hamapai-maine. ");
INSERT INTO knb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yisasiꞌa mukiꞌa kanafina ala mono nopi haino maineno humavenelino mukiꞌa kegela Olivi yosa hanea agoꞌyafi haino nemaiyane. ");
INSERT INTO knb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Haino mainegeno koꞌma neleana mukiꞌa veala “Agai kema havigahune.” huꞌya mono nopina etele nehayane. ");
INSERT INTO knb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ala imu negiya kanamoꞌa meupa higeꞌya ani imule hale oki kaihamena nenayane. Ani imua kafuꞌahe kafuꞌahe Anumaya Kotiꞌma Yuta veaꞌmogami amakinago-mogamima amaugafa aligatimainea kanahe amakesa havi havi hisaya imu* alitalu huꞌya negiyane. ");
INSERT INTO knb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ani kanafina mono note hagote kava vayaꞌene kahegi kema havilinaya anagaꞌene Yisasina haesaya kafe atiyayanagi vaya amaulagahe koli humainae. ");
INSERT INTO knb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","5","Koli nehageno aupaꞌa Sataniꞌa* Yutasi aipafi hai fale-maine. Yutasi Isakaliotiꞌa Yisasina tuelufuꞌa (12) anagaꞌene nemaiya kanogino neꞌamataleno viaꞌamo mono note kava vayaꞌene mono note ati kava vayaꞌene kea kea huno mage hie “Nagaya hanaꞌa kateti agesila huꞌna tamahapaisugetama Yisasina atafa hugahae?” huno higeꞌya muse huteꞌya “Aniꞌama hisanageta mone hageta kamigahune.” huꞌya hapaimainae. ");
INSERT INTO knb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hapaigeno Yutasiꞌa “E, kanalele” huno huteno vaya kulata oꞌaiya yate kesi kateti Yisasina movalesigeꞌya atafa hisaya kafe ati ayemaine. ");
INSERT INTO knb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hale oki kaihamema nenaya kanamoꞌa hagote yupa falote hie. Ani yupa amaugafama aligatimainea yafe amakesa ali hao hisayafe nagola sipi sipi nafaꞌneꞌa hemainae. ");
INSERT INTO knb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yisasiꞌa Pitaꞌene Yoniꞌene hunateno mage hie “Utana Anumaya Kotiꞌma taginagomogami amaugafa aligatimainea yafe tagesa ali hao hisuna kavela utana talo tala hiꞌageta monamano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Higeꞌana “Hana nopi mo lalo tala hisuꞌe huꞌageka nehane?” huꞌana havigaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Haꞌageno Yisasiꞌa mage huno hanapaiye “Haviꞌo ala kumate utana nago kanomoꞌa ti kema hefilino visia kanoene mo fotu hutetana akave utana haisia nopi haitana ani nomona nefafe mage hutana havigeꞌo ‘Hulavenelia kanomoꞌa kagaife mage huno kahavige ‘Hana nopi nagaiꞌene tokaeꞌya nemaiya anagaꞌmoꞌyaene Anumaya Kotiꞌma taginagomogami amaugafama aligatimainea yafe tagesa ali hao hisuna kavela nesune?’ huno hie.’ hutana havigeꞌo. ");
INSERT INTO knb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Havigesaꞌageno folamo huno anayapi kimalenea nona ago alino hilato humalenea nona, ala nokefa, tanavelisigetana ani nopi kavetia talo tala hiꞌo.” huno hanapaiye. ");
INSERT INTO knb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hanapaigeꞌana vaꞌana hia kemoꞌa mukiꞌa falote higeꞌana Anumaya Kotiꞌa amaugafa aligatimainea kanahe amakesa havi havi hisaya kavela mo lalo tala humainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kave ne kanamoꞌa aupa higeꞌya Yisasiꞌene agaiꞌaene tokaeꞌya nemaiya anagaꞌmoꞌyaene kave negahe folamole mainae. ");
INSERT INTO knb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mainageno Yisasiꞌa mage huno hamapaiye “Anumaya Kotiꞌma taginagomogami amaugafama aligatimainea yafe tagesa ali hao hisuna kavela tamakaiꞌene tokaeta nesuna yafe tusiya huno nenahaiye. Neteꞌna tusiꞌa nagata aisigeꞌna faligahue. ");
INSERT INTO knb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tamahapauve ma kavela nagoꞌene ma mopafi maineꞌna onegahue. Anumaya Kotiꞌa agola tamaku tamamena aligatisigeꞌna ikapinaga eteꞌna negahue.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nagola nofi alagamo timo agia vainie. Yisasiꞌa ani lima hanea keꞌayola alino Anumayamotega muse huno havigeteno mage huno hamapaiye “Ma keꞌayola alitama nete nete hiho. ");
INSERT INTO knb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tamahanepauve menia ma vaini nofi alagamo tina* nagoꞌene onegahue. Anumaya Kotiꞌma kava yagaisia kanamoꞌma falote hinageꞌna eteꞌna negahue.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naꞌa huteno kaihamena alino nunamu huno muse huno havigeteno kolite kolite huno neꞌamamino mage huno hie “Mamona nagaiꞌni naugafae. Tamakaife huꞌna naugafa atalesugetama mukiꞌa kanafina aniꞌa hutama nete nete nehutama nagaifena tamakesa havi havi hutama maiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Higeꞌya ani kavela netageno vaini nofi alagamo tima* hanea keꞌayola alino aniꞌa huno Anumayamotega muse huno havigeteno alino amamite amamite nehuno mage huno hamapaiye “Ma lina nagai kolaniꞌae. Nahaesageꞌna falisuana kolaniꞌamoꞌa tamakaifene huno take take hulavisiafe haegafa kea, Anumaya Kotiꞌene hage-lafitama maisaya kea* alino fatago hugahie. ");
INSERT INTO knb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Haviho vayaꞌmoꞌya havisagi huno nagaila nagesi huno kame hunatesia kanomoꞌa nagaiꞌene tokaeno mainegetaꞌa nagokepiti kavela alitaꞌa nenoꞌe. ");
INSERT INTO knb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna Anumaya Kotiꞌma hunatenea kate ugahuanagi vayaꞌmoꞌya havisagi huno nagesi hunatesia kanomofena ‘Avoꞌnio nahau hanagi kagaya maigaꞌyo huꞌna nehue.’ huno humaine.” ");
INSERT INTO knb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Higeꞌya amakaiꞌami huge havige nehuꞌya mage hae “Ani kavala tagaipitila ta hugahie?” huꞌya mo havige me havige hae. ");
INSERT INTO knb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yisasiꞌenema tokaeꞌya nemaiya anagamoꞌya mage huꞌya hae “Ta tagaipina tagaseno ala kanoa maine?” huꞌya ani yateti ke vaimainae. ");
INSERT INTO knb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ke neꞌvaigeno Yisasiꞌa mage huno hie “Ma mopale ala kava vayamoꞌya kemamakiꞌya aliꞌya ke huneꞌamateꞌya ‘Tagaifela kayone huka kanale kava kanoe huꞌya hunatesae.’ huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nehayanagi tamakaya aniꞌa kavala ohiho. Tamakaipima agima hanesia kanomoꞌa osi nafaꞌnemoꞌma maiya avamete maisia kanomoꞌa kava kanotami maineno kayo kayo kano maisie. ");
INSERT INTO knb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta ala kava kanoa maine? Mopale maineno kavela nenea kanofi? Kavela hatino neꞌamamia kanofi? Afaꞌa mopale maineno kaveꞌma nenea kanoa ala kano mainegi nagaya tamakaiꞌene maineꞌna kayo kayo hunelamatoe. ");
INSERT INTO knb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nagaiteꞌma havi kanama falote higetamahena tamakaya onataletama nagaiꞌene mainayane. ");
INSERT INTO knb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ani yafena Nenafaꞌa nagaife ‘Kava yagaigane.’ huno hunatenea kava huꞌna tamakaila ‘Kava yagaigahae.’ huꞌna nelamamue. ");
INSERT INTO knb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Naꞌa hisugetama kavama yagaisua kumaꞌnilela umainetama nagaiꞌene kavela nenetama kava vayaꞌmogami siale mainetama teniꞌa (10) Isaleli nofi veaꞌmogamite kava yagaigahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","Saimonifena mage huno hie “Saimonigae, Saimonigae havio Sataniꞌa tamakayama nagaila natalesaya yafe tamakaila tamatafa huno ayelamavataga hisia yafe ‘Ani vayala namio.’ huno Anumaya Kotifena havigeanagi nagaya kagaifena Saimoniga nagaifema ‘Tusiꞌa tokiyaꞌa hane.’ huka kagupi maleka kametiti humainana kea oꞌatalesanafe Anumaya Kotitega ago havigogi kaguꞌa aiyahae huka vayakamoꞌya nagaifema amakupi maleꞌya amametiti hisayafe amaya huo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Higeno Saimoniꞌa kenonaꞌa mage huno hie “Alaniꞌamogae nagaya kagaiꞌene kina hulaꞌateteꞌya taꞌahaesagetaꞌa faligahuꞌe huꞌna nagu nagesa talo tala nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Higeno Yisasiꞌa kenonaꞌa mage huno hie “Pitaga kahanepauve meni kegela kokolemoꞌa agea oꞌainesigeka tagufa (3) kanale ‘Nagaya oꞌagenoa kanoe.’ huka avane hunategane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Huteno nagoꞌene mage huno hamapaiye “Monetamiene kutamiene tamaiya noꞌene oꞌalitama viho huꞌna hulamatogetama vayana nagoꞌa yafena aupa humainao?” huno higeꞌya “Aꞌao mukiꞌa yana kanaleꞌya huta alimainone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hageno nagoꞌene mage huno hie “Hagoteꞌna mani kea tamahapai-mainoanagi menia monetamima hanesimogatama alitama viho. Kutamima hanesi-mogatama alitama viho. Ayaꞌaya naepetamima omalesi-mogatama kenatamia alu kanomona amisageno anonaꞌa ayaꞌaya naepea tamamisie. ");
INSERT INTO knb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Naꞌafene nagaya tamahanepauve nayona Anumaya Koti kefima kae-malenaya kemoꞌa mage huno kae-maleneane ‘Vayaꞌyagamoꞌya agaifena mage hae ‘Havi kavakeꞌya nehia kano maine.’ huꞌya hae.’ huꞌya kae-malenayanagi nagaiꞌma hunatesaya kavaꞌma hisagenoꞌa ani kemoꞌa falote hisigeꞌya ‘Tamage humaineane.’ huꞌya hugahae.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Higeꞌya mage hae “Alatimogae ago tole ayaꞌaya naepea ma hane.” huꞌya hageno kenonaꞌamia mage hie “Haile.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisasiꞌa kumala ataleno mukiꞌa kanafi nehia kava huno Olivi yosa hanea agoꞌyafi haigeꞌya agaiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya akave haimainae. ");
INSERT INTO knb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ago anilega uvaꞌyi huteꞌya mage huno hamapaiye “Anumaya Kotitega nunamu hutama havigeho ‘Sataniꞌma ayelavataga hisia yapina tavaleka oꞌvuo.’ hutama havigeho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Ani kea huteno neꞌamataleno viaꞌamo vayaꞌmoꞌya yafama hagaꞌyu hutalageno neꞌvia avamete viaꞌamo aleꞌya moye maineno Anumayamotega mage huno havige “Nenafagae falisua kava nehugi kahaisigekahena ani havi kanamoꞌa satuꞌage hia ti kana ti hanea keꞌayola nahafalo. Afaꞌa nagai nagu nagesa akave ohuka kahaisia kavala huo.” huno havige-maine. ");
INSERT INTO knb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nehigeno ikapinagati nago ensole kanomoꞌa tokiya memine. ");
INSERT INTO knb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Memigeno Yisasiꞌa augafafinaga malageno ageana tusiꞌa kanaꞌage haiya yafe Anumayamotega nagoꞌene tusiya huno havinegegeno amuꞌnamoꞌa kolamoꞌma hia kava huno mopafina take take hulavimaine. ");
INSERT INTO knb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Take take nehigeno Anumayamotega havigeteno hetino mogeana agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya hamauma haya yafe ago fae-mainageno momake-maine. ");
INSERT INTO knb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Momaketeno mage huno hie “Ae faetamage mainao? Hetitama Sataniꞌa ayelama-vataga hisigetama asaga hu otavisaya yafena Anumayamotega nunamuna hutama havigeho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ani kea nehigeꞌya kasagoꞌya vaya evaꞌyi hageno Yutasiꞌa tuelufuꞌa (12) anagapi tokaeno nemaiya kanomoꞌa amavaleno Yisasina me tako hugahe emaine. ");
INSERT INTO knb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Neꞌegeno Yisasiꞌa mage huno hie “Yutasigae natako hisana yateti nagaila ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia nagesi huka kame vaya amayapi nategahe nehano?” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nehigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya haya kavala ageteꞌya mage hae “Alamogae ayaꞌaya naepeleti hamaesuno?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nehageno amakaipiti nago kanoa ala mono nopima hagote kava kanomona aliꞌya kanoꞌamona ayaꞌaya naepeleti tamaga kaiyaga agesa aifakali-talegeno asaga hulavimaine. ");
INSERT INTO knb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aifakaligeno Yisasiꞌa mage hie “Tu hisaya kavala ohiho.” huno nehuno ayana ani agesamo aepale maleno agesa alino kanale hutene. ");
INSERT INTO knb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Alino kanale huteteno mono note kava vayafeꞌene ala mono note ati kava vayafeꞌene Yuta vayatamaene agaiꞌma atafa hugahe aya vayaꞌmogamifeꞌene Yisasiꞌa mage huno hamapaiye “Tamakaya nagaifena ‘Vaya nehamaeno musufaya nehia kano maine.’ hutama ayaꞌaya naepene muki kaꞌyoꞌene alitama neꞌao? ");
INSERT INTO knb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nagaya mukiꞌa kanafina efi efi huꞌna tamakaiꞌene ala mono nopina nemauvanagi natafa ohunayane. Anumaya Kotiꞌa meni kana tamayapi malegetama Sataniꞌa hani yamo nefaꞌa aliꞌya alisia kanamoꞌa ago falote humaine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Atafa huꞌya mono note hagote kava kanomo* kumate avaleꞌya vageno Pitaꞌa akave anatino vianagi avatela oꞌunegi ago aluꞌale umaine. ");
INSERT INTO knb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Umainegeꞌya ani no kegiꞌya kovefi ata kae-maleteꞌya mopale mainageno Pitaꞌa amakaiꞌene mopale umaine. ");
INSERT INTO knb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ata anefete mopale mainegeno nagola aliꞌya munaꞌmoꞌa Pitana ageke huno ageteno mage hie “Ma kanoa Yisasiꞌene vaiyatete nehia kanoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Higeno Pitaꞌa avane huno mage hie “Aꞌao ma munaꞌmoga nagaya oꞌagenoa kanohe nehane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Osiꞌa maigeꞌya nago kanomoꞌa Pitana ageteno mage huno hie “Kagaya Yisasiꞌene tokaetana nemaiꞌa kano mainane.” huno higeno Pitaꞌa mage hie “Aꞌao ma neꞌmoga nagaya oꞌagenoa kanohe nehane.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Osiꞌa maigeꞌya nago kanomoꞌa tokiyaꞌage kefiti mage huno hie “Tamage huꞌna tamahanepauve ma kanoa Kalili kanoe. Yisasiꞌene vaiyatete nehia kano maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Higeno Pitaꞌa mage huno hie “Ma neꞌmoga nagaya ohavinoa kehe nehane.” huno nehigeno anile aupaꞌa kokolemoꞌa agea aimaine. ");
INSERT INTO knb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Age aigeno Anumayamoꞌa maiyahae huno Pitana ageke huno agegeno Pitana agesamoꞌa aikalo higeno Yisasiꞌma hapaigeno havimainea kea mage huno humaineane “Meni kegela kokolemoꞌa agea oꞌainesigeka kagaya tagufa (3) kanale avane huka nagaila ali falakigane.” huno humainea kehe Pitana agesamoꞌa aikalo higeno haviteno hatilavino viaꞌyamo tusiꞌa avi motemaine. ");
INSERT INTO knb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Yisasima atafa humainaya vayaꞌmoꞌya kigi huneꞌateꞌya akaya ateꞌya kaꞌyo aikoneliꞌya aulagafina kenaleti nofi kisalu kiteneꞌya mage huꞌya hae “Kaune laga nehana kanogi tahapaiyo taꞌya negahayae?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nagoꞌene alu ke alu ke huꞌya kigi huneꞌateꞌya akaya atenae. ");
INSERT INTO knb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kotigeꞌya Yuta vayaꞌmogami vayatamaene mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene kanisolefi melitalu huteꞌya Yisasina avaleꞌya anile umaineꞌya Yisasifena mage huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Tahapaiyo kagaya Anumaya Kotiꞌa taugafa aligatigahie huno hugatenea kano mainano?” huꞌya hageno Yisasiꞌa kenonaꞌamia mage hie “Nagayama tamahapaisugetamahena ‘Tamage nehane.’ hutama ani kea havitama tamakupina omalegahae. ");
INSERT INTO knb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nagaya nago kema tamahavigesugetamahena kenonaꞌania nahaꞌopaigahae. ");
INSERT INTO knb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Meni aepa heno ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna tusiꞌa himamuꞌa hanea Anumaya Kotina aya tamaga kaiyaga hanea siale umaineꞌna agola maige maige huꞌna maigahue.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Higeꞌya mukiꞌa anile melitalu huꞌya mainaya vayaꞌmoꞌya mage huꞌya hae “Kagaya ani kea nehananagi Anumaya Kotina nafaꞌneꞌamoga mainano?” huꞌya havigageno “Tamakaya nagaifena tamage nehae. ‘Ani kano mainane.’ hutama nehae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Higeꞌya mage hae “Agaiꞌa avayafiti ago haesuna kea hufalote higeta havune. Havigu nagoꞌa vayaꞌmoꞌya nagoꞌa kea agaifena tahapaiyafenagita alu vayaꞌmogamifena ke ohisune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mukiꞌa kanisolefi metalu huꞌya mainaya vayaꞌmoꞌya hetiꞌya Yisasina avaleꞌya ala kava kanoa, Pailatite umainae. ");
INSERT INTO knb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Avaleꞌya umaineꞌya aepa heꞌya “Ma kava huno kefo kavala humaine. Tagaya agonana mani kanomoꞌa tagai nofi vayafena mage hie ‘Kamani vayaꞌmogami kea neꞌataletama havi kava hiho.’ huno nehuno tagaifena ‘Takisi neꞌamamiya yana Sisana oꞌamiho.’ huno nehuno ‘Nagaya nagaiꞌniꞌa Kalaisiꞌna, Sauve kano mainoe.’ huno humaine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hageno Pailatiꞌa Yisasifena mage huno havige “Kagaya Yuta nofi vayaꞌmogami Sauveꞌami mainano?” huno havigegeno Yisasiꞌa mage hie “Kagaikaꞌa mani kea hai nehane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Higeno Pailatiꞌa mono note kava vayafeꞌene mukiꞌa alitalu huꞌya mainaya vayafeꞌene mage huno hamapaiye “Kefo kavaꞌma hu-mainesiafene huꞌna atiyoana nago yamaꞌa omale.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Higeꞌya tokiyaꞌage kefiti mage huꞌya hae “Mukiꞌa Yutia kotega ute ete nehuno veafena mage humaine ‘Kamani vayaꞌmogami kea neꞌataletama ma kava hiho.’ huno humaveligeꞌya veaꞌmoꞌya ‘Ani kava humategahune.’ huꞌya hae. Kaliliti ani kavala aepa heno hulino hulino menia male neꞌe.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailatiꞌa ani kea haviteno mage huno hamavige “Ani kanoa Kalili kano maineo?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hamavigegeꞌya “E, ani kumateti kanoe.” huꞌya hageno “Heloti kava yagaimainea kotegati kanoe.” huꞌya hageno haviteno hutegeno Helotite umaine. Ani kanafina Helotiꞌa Yelusalemu nemaiyane. ");
INSERT INTO knb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helotiꞌa Yisasina ageteno tusiꞌa muse hie. Avagema haviana “Tokiyaꞌage avameꞌya yana nagoꞌa hinageꞌna agesue.” huno nehuno ayaꞌaya kanale Yisasina agesia agesa havianagi noꞌageane. ");
INSERT INTO knb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yisasina ageteno mukiꞌa kehena havige havige hugeteana Yisasiꞌa nagola osi ke kanoꞌa ohune. ");
INSERT INTO knb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ke ohuno maigeꞌya mono note kava vayaꞌene kahegi kema havilinaya anagaꞌene anile hetiꞌya maineꞌya tusiꞌa ke nehuꞌya “Na kava ma kava huno kefo kavala humaine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hageno Helotiꞌene ati vayaꞌamoꞌyaene Yisasina huhaviya huteteꞌya kigi huteꞌya kamuge hatageꞌya vaineꞌateꞌya nagola kanale kena aliꞌya me faitetageno Helotiꞌa Yisasifena “Pailatite etetama avaletama viho.” huno humatene. ");
INSERT INTO knb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helotiꞌene Pailatiꞌene kame kanolata mainaꞌaleti ani yupa anakaya ali konaga ayemainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Pailatiꞌa mono note kava vayafeꞌene Yuta vayaꞌmogami kava vayafeꞌene vayaꞌyagamogamifeꞌene ke higeꞌya melitalu hageno mage huno hamapaiye “Tamakaya ma kanomofena ‘Kefo kava huno veafena ‘Kamani vayaꞌmogami kea neꞌataletama havi kava hiho.’ huno hamapai-maine.’ hutama nehutama nagaifena kaiyeke hutesane hutama avaletama ayanagi nagaya tamakai tamaulagafima havigoana ‘Kefo kavaꞌma humaine.’ hutama haya kavala tamage huno kefo kavala ohune huꞌna nehue. ");
INSERT INTO knb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","17","Aguꞌafina agoanagino Helotiꞌa aniꞌa huno ageana tagaitefe ‘Eteka vuo.’ huno hutegeno eanagi ageho mani kanoa falisia augafa kefo kavala ohuneafe afaꞌa kaꞌyo amiꞌna aumono maleteꞌna atalesugeno visie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hianagi mukiꞌa alitalu humainaya veaꞌmoꞌya ailulupeꞌya mage hae “Yisasina haegeno falino. Tagaya Palapasife nofipiti haꞌno hisie huta nehune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ani Palapasiꞌa ala kumate vayaꞌyagamofe mage hie “Kava vayaꞌene tu higetao.” huno huteno nago kanoa haegeno falimainea yateti avaleꞌya kina hutenaya kanogiꞌya agaife ani kea hae. ");
INSERT INTO knb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hageno Pailatiꞌa “Yisasina atalesugeno afaꞌa visie.” huno agesa havia yafe nagoꞌene ke huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hamavigegeꞌya ala kefiti mage hae “Yafaga yosale nili hetama asaigeno falino. Yafaga yosale nili hetama asaigeno falino.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hageno Pailatiꞌa nagoꞌene eteno mage hie “Naꞌa higetama ani kea nehae? Hanaꞌa kefo ya humaine? Nagaya atiyoana falisia kefo augafa kavala ohuneafe afaꞌa kaꞌyo amiꞌna aumono maleteꞌna atalesugeno visie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ani kea hianagi amakaya tusi tokiyaꞌage kefiti mage huꞌya hae “Yafaga yosale nili hetama asaigeno falino.” huꞌya tokiyaꞌage kegeꞌya hageno Pailatiꞌma hia kemona amakai kemoꞌa hefalaki-maine. ");
INSERT INTO knb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Keꞌamona hefalakigeno Pailatiꞌa haya ke haviteno Yisasifena “Yafaga yosale nili hetama asaigeno falino.” huno ati vayala hamapaimaine. ");
INSERT INTO knb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Palapasiꞌa vayafe “Kava vayaꞌene tu higetao.” huteno nago kanoa haegeno falimainea yateti avaleꞌya kina hutenaya kanoa tutu haya yafe Pailatiꞌa “Haꞌno hanagi vuo.” huno huteanagi mukiꞌa vayaꞌmoꞌya Yisasifena “Yafaga yosale nili hetama asaigeno falino.” huꞌya haya kemo akave malene. ");
INSERT INTO knb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yisasina avaleꞌya katega neꞌuꞌya Sailini Saimoniꞌene mo fotu humainae. Saimoniꞌa hoyafinagati kate eneꞌvigeꞌya ati vayaꞌmoꞌya motafa huꞌya yafaga yosa aliꞌya ayoꞌnale kofiteteꞌya “Yisasi akave kofika vuo.” huꞌya hutenae. ");
INSERT INTO knb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mukiꞌa veaꞌmoꞌya akave neꞌvageno aꞌnemoꞌya avi neꞌateꞌya hamau hume hume akave umainae. ");
INSERT INTO knb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Neꞌvageno Yisasiꞌa maiyahae huno amaketeno mage hie “Yelusalemu mainaya aꞌnemogatama nagaifene hutama avia oꞌateho. Avima ategahena tamakaitamihe neꞌatetama nafaꞌneyagatamimofeꞌene avia atemateho. ");
INSERT INTO knb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Haviho haenagaꞌa nago kana falote hisigeꞌya mage huꞌya hugahae ‘Namo aꞌnemogatama nafaꞌne oꞌatetama numa noꞌamisaya yafena tusiꞌa muse hutama maiho.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ani kanafina aepa heꞌya ala agoꞌyamofena mage huꞌya hugahae ‘Kolilavika aiso hulato.’ huꞌya hugahae. Osi agoꞌyahena ‘Mehi alika aiso hulato.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nagaya haegafa ata kana huꞌna mainoa kanoe. Kefo yana tamage huꞌna ohunoa kano mainogeꞌya mani kavala hunenatayanagi tamakaya avaifa ata kana hutama kefo kava nehaya veaꞌne mainayafe na kava hulamategahae?” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yisasina haegahe avaleꞌya neꞌuꞌya tolea kefo yama humainaꞌa kanolataꞌene hanaegahe anavaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Anu ayamufae huꞌya nehaya kumate avaleꞌya uteꞌya yafaga yosale nili haeꞌya asaimainae. Tole kefo yama humainaꞌa kanolatane nago kanoa Yisasina tamaga kaiyagaꞌa haeꞌya asaimaleꞌya nago kanoa haoga kaiyagaꞌa haeꞌya asaimaleꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yisasiꞌa Anumayamotega ke huno mage huno hie “Nenafagae mani vayaꞌmoꞌya kefo yama haya kavala ‘Naꞌa kava nehune.’ huꞌya havilama ohaya yafe aigeꞌamateka kefo yaꞌamia atalemato.” huno humaine. Higeꞌya ati vayaꞌmoꞌya kenaꞌa aligahe musufayama nehaya yokalo lageno amakaseno haiya kanomo alimaine. ");
INSERT INTO knb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aligeꞌya veala alitalu huꞌya hetiꞌya aulu heꞌya mainageꞌya kava vayaꞌmoꞌya kamuge hatageꞌya vaineꞌateꞌya mage hae “Nagoꞌa veala amaugafa aligatimainea kanogi Anumaya Kotiꞌma hau ayamopafi nehaiya kanoa taugafa aligatigahie huno hutenea kanoma mainesiana agaiꞌa augafa aligatino.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","38","Anuteꞌma kaeꞌya malaya avomoꞌa mage huno hie “Mani kanoa Yuta veate ala Sauve kanoe.” huꞌya kaeꞌya malenae. Malenageꞌya ati vayaꞌmoꞌya aniꞌa huꞌya kamuge hatageꞌya vaineꞌateꞌya atuꞌage nofi alagafiti tina neꞌamiꞌya mage hae “Kagaya Yuta vayate sauve kanoꞌamima mainesanana kagaikaꞌa kaugafa aligatio.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nagola kefo yama humainea kanoa yafaga yosale nili heꞌya asaimalaya kanomoꞌa Yisasifena hu-haviya huteno mage huno hie “Anumaya Kotiꞌma taugafa aligatigane huno hugatenesia kanoma mainenuka kagaikaene taꞌagaiꞌene yosaleti ali hakao hugeta tavimano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Higeno nagola kefo yama higeꞌya yafaga yosale nili heꞌya asaimalaya kanomoꞌa ani kea haviteno kemakino mage huno hie “Vae kagaya Anumaya Kotifena kolia nohuka ani kea nehano? Kefo yama humainoꞌa anonaꞌa nagopi taꞌagaila nilia laꞌahaeꞌya asailaꞌa-tenayanagitaꞌa faligahuꞌe. ");
INSERT INTO knb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Taꞌagaya kefo yatiꞌamo anonaꞌa fatago kava hayanagi ma kanoa nagola osi kefo yamaꞌa omalene.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nehuno ani kanomoꞌa Yisasifena mage huno hie “Yisasiga kava yagaigahema esana kanafina nagaifena kagesa havi namio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Higeno Yisasiꞌa kenonaꞌa mage huno hie “Tamagelafa huꞌna kahanepauve meni kanoꞌa nagaiꞌene kanale maige maige hisaya kumatela tokaetaꞌa umaigahuꞌe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Anile yagemoꞌa euno amuꞌnokaꞌno higeno halemainea yamoꞌa haꞌno higeno mukiꞌa kotega tusiꞌa hanikino viaꞌyamo une kanalega eteno ali halemaine. ");
INSERT INTO knb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ani hanimo aguꞌafinaga ala mono nopima asaimalenaya kenagefamoꞌa* amuꞌnopiti aipa hulole humaine. ");
INSERT INTO knb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aipa hulole higeno Yisasiꞌa ala kefiti mage huno hie “Nenafagae nagu nafaꞌnea kagai kayapi nemaloe” huno nehuno haimula atalegeno vigeno falimaine. ");
INSERT INTO knb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Faligeno ati vayate kava kanomoꞌa anile maineleti mukiꞌa yama hia kavala ageteno Anumaya Koti agi alisaga nehuno mage huno hie “Tamage mani kanoa kefo yana nohia kanoe.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","“Na kava hutesafi agetetae.” huꞌya melitalu humainaya veaꞌmoꞌya mukiꞌa humainea kavala ageteꞌya tusiꞌa hamau huneꞌateꞌya havi kafa yogime yogime noꞌamilega ataleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vayanagi mukiꞌa veaꞌmoꞌyaene Kaliliti akave emainaya aꞌneyagaene aluꞌale hetiꞌya maineꞌya hutaya kavala agemainae. ");
INSERT INTO knb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nagola fatago kanoa Yosefeꞌe, Yuta vayaꞌmogami Kanisolefi maineanagi “Yisasina haegahune.” huꞌya haya kehena “E, kanalele.” huno ohunea kanoa Yuta veaꞌmogami kotega Alimatiyae huꞌya nehaya kumate nemaiya kanogino Anumaya Kotiꞌma kava yagaisia kanahe muse huno agava nemaiya kanoe. ");
INSERT INTO knb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ani kanomoꞌa Pailatite viaꞌyamo mage huno havige “Yisasina augafaꞌa aligahe nehue.” huno havige. ");
INSERT INTO knb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Havigegeno Pailatiꞌa “E” higeno yafaga yosaleti haino ali hakao hulino elavino memaleneno kenaleti augafalela aigalaki kalaki huno haꞌya kiteno alino viaꞌyamo he falageꞌya kafimalenaya yafa kane, anifina vayala hevai oꞌamatenaya yafakapima alino mo hevaitene. ");
INSERT INTO knb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ani yupa Sapatihe haviꞌya talo tala hisaya kanagino Sapatia ago evaꞌyi hugahe higeno Yosefeꞌa ani kavala humaine. ");
INSERT INTO knb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Higeꞌya Kaliliti Yisasiꞌene tokaeꞌya emainaya aꞌneyaga Yosefe akave uꞌya yafakapima hevaitea yana mogemainae. ");
INSERT INTO knb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mogeteꞌya ayaꞌamoꞌya augafaleꞌma faletesaya yana manaꞌage tiꞌene masaveꞌene talo tala nehageno Sapati kanamoꞌa evaꞌyi higeꞌya kahegi kemo akave maleꞌya maifalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sota yupa kola otinegeꞌya ani aꞌneyaga ago talo tala humalenaleti manaꞌage masavena aliꞌya Yisasina hevaitenaya komulega umainae. ");
INSERT INTO knb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","Uꞌya mogayana komumo avayaleꞌma aiso humalaya yafana ago alikeli-talenageno avayalela omalegeꞌya ani yafakapi hai faleꞌya mogayana Yisasi augafa omalegeꞌya mogemainae. ");
INSERT INTO knb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Omalea yafe “Hanate hane?” huꞌya tusiꞌa amakesa nehavigeno anile tole kanolatana efeꞌage huno alave alave hia kena failiꞌana evaꞌyi haꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Evaꞌyi haꞌageꞌya aꞌneyagamoꞌya ageteꞌya tusi koli huꞌya ape hageꞌana ani tole kanolatamogania mage huꞌana haꞌe “Naꞌa higetama afaꞌa mainea kanohena falimainaya vayaꞌmogami matimatipina ati neꞌayae? Mafina omaigi fali-mainefitila ago hetino umaine. ");
INSERT INTO knb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kalili mainenoꞌma tamahapai-mainea kea tamakesa hinagetama haviho. ");
INSERT INTO knb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mage huno humaineane ‘Ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia kefo kava nehaya vayaꞌmoꞌya natafa huteꞌya yafaga yosale nili nahaeꞌya nasaisageꞌna faligahue. Falisugeꞌya komufi hevainatesageꞌna tole kana maiteꞌna fali-mainesufiti eteꞌna hetigahue.’ huno humaineane. Ani kehena tamakesa havitama havilama hutama haviho.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Haꞌageꞌya Yisasiꞌma humainea kehe amakesa haviteꞌya matimatila ataleꞌya vayaꞌamoꞌya agaya yaꞌene haviya kene Yisasina aleveniꞌa (11) anagaꞌamoꞌyaene nagoꞌa veaꞌene hamapai-mainae. ");
INSERT INTO knb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Magatala kumate Maliaꞌene Yohanaꞌene Yemesina itaꞌamoꞌa Maliaꞌene nagoꞌa aꞌneyagaene Yisasiꞌenema tokaeꞌya nemaiya anagala hamapai-mainae. ");
INSERT INTO knb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hamapaiyanagi amakesa haviteꞌya “Afa ke nehae.” huꞌya nehuꞌya amakupi maleꞌya amametitia ohunae. ");
INSERT INTO knb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amametitia ohayanagi Pitaꞌa hetino aiyayeno hevaitenaya yafakapi mope humaineno ageana Yisasina aye-gasagitenaya kenaꞌage mogeteno agesa havi havi huno nomaꞌalega eteno umaine. ");
INSERT INTO knb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ani kanafina Yisasiꞌenema tokaeꞌana nemaiꞌa kanolatana Emeasi kumate ugahe katega vaꞌana anima vaꞌa kamoꞌa Yelusamuti Emeasi umainea kamoꞌa osiꞌa ayaꞌayaꞌa aleveniꞌa (11) kilomita hane. ");
INSERT INTO knb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ani tole kanolatana katega neꞌuꞌana ani kanafima humainaya kavafe kea kea hume hume umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Neꞌuꞌana ani yafe kea kea hume hume neꞌuꞌana agaila havigegeno agaila havigegeno hume neꞌvaꞌageno Yisasiꞌa evaꞌyi huno anakave eno anakaiꞌene tokaeꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Neꞌuꞌya anakaya agaꞌanagi anaulaga alino aiso higeꞌana Yisasina agelama huꞌana oꞌagenaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Agelama ohaꞌageno Yisasiꞌa mage huno hanavige “Naꞌafe kea kea hume hume neꞌvaꞌe?” huno hanavigegeꞌana anile hetiꞌana maineꞌana anaugosa ayegatule-taleꞌana mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nago kanomo agia Kaliopasiꞌa mage huno hie “Kagaya Yelusalemu kumate natu kano mainano? Mukiꞌa natu umainaya veaꞌmoꞌya ani kanafima falote humainea kavala ago agemainayanagi kagaikage oꞌagenano?” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Higeno Yisasiꞌa mage huno hanavige “Na kavafe nehaꞌe?” huno hanavi-gegeꞌana mage huꞌana haꞌe “Nasaleti Yisasi kehena ohavino? Ani kanoa aune kano maineanagino Anumaya Koti aulagafiꞌene veaꞌmogami amaulagafiꞌene tusiya huno tokiyaꞌage yana talo nehuno tusiꞌa hetofa ke tahanepaiya kanoe. ");
INSERT INTO knb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tahanepaiya kanogi tagai mono note kava vayaꞌene kava vayatiene atafa huꞌya kaiyeke huteteꞌya ‘Faligane.’ huꞌya yafaga yosale nili haeꞌya asaigeno falimaine. ");
INSERT INTO knb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","23","Fali-maineanagi tagaya agaifena Anumaya Kotiꞌa taugafa aligatigahe hutegeno emainea kanoe huta tametiti nehune. Nago yana olaga kanoꞌa hae-mainayanagi menia tagaiꞌene nemaiya aꞌnemoꞌya natekefa hatilaviꞌya Yisasina hevaitenaya komulega mogayana Yisasina augafa omalegeꞌya mogeteꞌya eteꞌya eꞌya mage huꞌya me lahapaiye ‘Tagaya ensole kanolata agonageꞌana mage huꞌana tahapaiꞌe ‘Yisasiꞌa ago hetimaine.’ huꞌana haꞌa kea tahapaigeta neꞌone.’ huꞌya me hageta tagaya tusiya huta atalitalu humainone. ");
INSERT INTO knb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Atalitalu hunanagi nagoꞌa tagaiꞌene nemaiya vayaꞌmoꞌya ani komulega uꞌya mogayana aꞌneyagamoꞌyama haya kemoꞌa mukiꞌa tamage hae. Ani kavala humaineanagi Yisasina oꞌagenae.” huꞌana hapaiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hapaigeno Yisasiꞌa mage huno hie “Tanakaya tanakesa nohaviꞌe. Mukiꞌa kema Anumaya Koti amaune vayaꞌmoꞌyama kae-malenaya kea havilama hutana tanakupina omalenaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anima amaune vayaꞌmoꞌya mage huꞌya kae-malenayane ‘Anumaya Kotiꞌa taugafa aligatigahema hutesia kanomoꞌa tusiꞌa augafa agata aisia yana aliteno tokiya hale yamaꞌaene kumaꞌalega eteno ugahie.’ huꞌya kae-malenaya kea ohavinaꞌo?” huno hanavige. ");
INSERT INTO knb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nehuno Moseseꞌma kae-malenea kemona aepa heno mukiꞌa Anumaya Koti amaune vayaꞌmoꞌya agaifema kae-malenaya kemo aepaꞌa hugafino hanapaiye. ");
INSERT INTO knb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Hanapaigeꞌana ugahema vaꞌa kumatela ago uvaꞌyi haꞌageno Yisasiꞌa nagoꞌene hume hume ugahe hianagi anakaya atafa huꞌana mage haꞌe “Taꞌagaiꞌene faegane. Yagemoꞌa ago tavifalesigeno aupaꞌa hani kigahie.” huꞌana haꞌageno anakaiꞌene faigahe noꞌanifinaga haifalemaine. ");
INSERT INTO knb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","31","Haifaleno mopale maineno anakaiꞌene kave negahe kaihame kana maya alino nunamu huno muse huteno aposino neꞌanamigeno anile anaulagamoꞌa aigali higeꞌana Yisasina agelama nehuꞌana “Agayamagae.” huꞌana nehaꞌamaꞌa anile fanane higeꞌana nagoꞌene Yisasina noꞌagaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ani yafena anakaiꞌani mohu mehu huꞌana mage haꞌe “Vaeha taꞌagaya katega neꞌoꞌageno agaya kanale kea taꞌahapaino Anumaya Koti ke kae-malenaya autaꞌmafi hanea kemona aepaꞌa hugafino taꞌahapaigeno taꞌaipamoꞌa hetigeno taꞌaguꞌamoꞌa tusiꞌa muse hie.” huꞌana haꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Huteꞌana aupaꞌa hetiꞌana eteꞌana Yelusalemu vaꞌana Yisasina aleveniꞌa (11) anagaꞌamoꞌyaene nagoꞌa veaꞌyagaene alitalu huꞌya mainageꞌana momake-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Momakaꞌageꞌya mage huꞌya hanapaiye “Tamage Anumayatimoꞌa fali-mainefitila ago hetigeno Saimoniꞌa agemaine.” huꞌya hanapaiye. ");
INSERT INTO knb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hageꞌana anakaya kategama humainea kavaꞌmo avagea hamapaiꞌana mage haꞌe “Kaihame maya alino aponesigeno anile taꞌaulagamoꞌa aigali higetaꞌa Yisasina agelama hutaꞌa agoꞌe.” huꞌana hamapaiꞌe. ");
INSERT INTO knb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ani kea maiꞌana nehaꞌageno amuꞌnoꞌamifi mo hetimaineno mage huno nehie “Tamaipamoꞌa yasi nehinagetama maiho.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hamapaigeꞌya amakaya tusiꞌa koli nehuꞌya atalitalu haya yafe Yisasifena “Hakalo emaine.” huꞌya tusiꞌa koli hae. ");
INSERT INTO knb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Koli hageno Yisasiꞌa mage hie “Naꞌa higeno tamaipamoꞌa kanaꞌage nehie? Naꞌa higeno tamakesamoꞌa tole-lole nehae? ");
INSERT INTO knb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tamakaya nayaꞌene naiyaleꞌene ageho. Nagayamagae nagaiꞌniꞌa emainoe. Naugafalela navate hutama ageho. Hakaloꞌmona augafa ameꞌene ayamufaene omalenegi nagaila naugafa nameꞌene nayamufaene hanegi neꞌagao.” huno hamapaiye. ");
INSERT INTO knb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ani kea nehuno aiya ayana amavelie. ");
INSERT INTO knb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Amaveligeꞌya ageteꞌya tusiꞌa muse nehuꞌya “Tamage nehifi havige nehie?” huꞌya tole amakesa haviꞌya amakesa havi havi nehageno mage hie “Nesua kavela haneo?” huno hamavige. ");
INSERT INTO knb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Hamavi-gegeꞌya atafi kaemale noyame aliꞌya amigeno alino amaulagafi mata mata huno nemaine. ");
INSERT INTO knb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yisasiꞌa mage hie “Tamakaiꞌenema tokaeꞌna mainoa kanafina mage huꞌna tamahapai-mainoe ‘Mukiꞌa nagaifema Moseseꞌma kae-malenea kene Anumaya Koti amaune vayaꞌmoꞌya kaemalenaya kene Yagame Avopi kaemalenaya kene mukiꞌa anima kae-malenaya kemoꞌa falote huno tamage hugahie.’ huꞌna tamahapai-mainoane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Huteno anima kae-malenaya kemoꞌa amakesa halenegeꞌya havilinae. ");
INSERT INTO knb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Havilinageno “Mage huꞌya kae-malenayane ‘Anumaya Kotiꞌa tamaugafa aligatigahema hutesia kanomoꞌa tusiya huno agata aisigeno falisigeꞌya hevaitetesageno tole kana augafamoꞌa komufinaga haneteno fali-mainesifitila eteno hetigahie.’ ");
INSERT INTO knb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hetisigetama tamakaya Yelusalemu aepa hetama mukiꞌa mopale kumaꞌyagalega ute ete hutama mage hutama hamapaiho ‘Yisasiꞌa tamaku tamamena ago aligatiafe tamakesa havitama kefo yatamihena tamakuꞌa aiyahae hisagenoꞌa Anumaya Kotiꞌa aigetamateteno kefo yatamia atalelamategahie.’ hutama hamapaisayafe kae-malenayane. ");
INSERT INTO knb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mukiꞌa tamaulagafiti agemainaya kavafena hamapaiho. ");
INSERT INTO knb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Haviho nagaya Nenafaꞌma ‘Tamamigahue.’ huno humainea kanomona Alu Aotage Avamula tamakaite hutesugeno egahie. Egahianagi tamakaya mani ala kumate mainegeno eno anafinagati tokiya tamamisigetama alitetama nagaifena mo hamapaiho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Ani kea huteno amavaleno Petani kumate umaineno ayana alisaga huno mage huno hie “Anumaya Kotiꞌa tokiyaꞌaleti tamaya hisie.” huno nehigeno Anumaya Kotiꞌa avalegeno ikapinaga haimaine. ");
INSERT INTO knb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","Haigeꞌya Yisasi agia alisaga nehuꞌya tusiꞌa muse hume hume Yelusalemu eteꞌya umaineꞌya muki kanafina efi efi huꞌya ala mono nopi maineꞌya Anumaya Koti agia alisaga humainae.");
INSERT INTO knb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Eheꞌma Anumaya Kotiꞌma ma mopama taloma ohunea kanafina Yisasina nago agia Kemoꞌe huno maineane. Anumaya Kotiꞌene tokaeꞌana mainaꞌane. Ani Kemoꞌa, Yisasiꞌe, Anumaya Kotiꞌene nagoꞌya hu-mainaꞌane. ");
INSERT INTO knb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mainaꞌageno ehe kanafina ani kanoa Anumaya Kotiꞌene tokaeꞌana mainaꞌane. ");
INSERT INTO knb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anumaya Kotiꞌa hapaigeno Yisasiꞌa mukiꞌa yana talo hu-maleneane. Yisasiꞌa nago yana talo ohunea yana omalene. ");
INSERT INTO knb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ani Yisasiꞌa mukiꞌa veala hamaimu neꞌamamia kano maineanagino ani haimuꞌamoꞌa veala aye hale-ma-te yamaꞌa hane. ");
INSERT INTO knb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ani hale yamoꞌa haniki mainea yapina aye hale-mainegeno hani-ki-mainea yamoꞌa alino asu ohune. ");
INSERT INTO knb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anumaya Kotiꞌa nago kanoa hu-tegeno emaine. Ani kanomo agia Yoniꞌe. ");
INSERT INTO knb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ani kanoa hale yamo ke hama-paigahe emainegeꞌya agai keleti mukiꞌa veaꞌmoꞌya hale yafe “Tamage hane.” huꞌya agaife amakupi maleꞌya ametiti hisaya yafe emaine. ");
INSERT INTO knb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yoniꞌa hale yamona aepaꞌa omainegi afaꞌa hale yamona aepaꞌa hanea kanomofe hama-paigahe emaine. ");
INSERT INTO knb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ani tamage hale yamaꞌa ma mopale eno mukiꞌa veaꞌne aye hale-ma-tegahe emaine. ");
INSERT INTO knb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ani Yisasiꞌa ma mopama talo hu-malenea kano emaineanagi ma mopafi veaꞌmoꞌya ageteꞌya aepaꞌa havilama huꞌya ohavinae. ");
INSERT INTO knb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Agaiꞌa talo hu-malenea mopale emaineamagi agaiꞌa veaꞌmoꞌya avaleꞌya falu fala huꞌya oꞌavalenae. ");
INSERT INTO knb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Avaleꞌya oꞌatageꞌya nagoke nagokeꞌmoꞌya falu fala huꞌya Yisasina avale-mainaya veaꞌmoꞌya Yisasife amakupi maleꞌya amametiti nehaya veaꞌmogamina Yisasiꞌa tokiyaꞌaleti “Anumaya Koti nafaꞌneyagae.” huno hu-neꞌama-te. ");
INSERT INTO knb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ani veaꞌmoꞌya vayaꞌmo kolateti oꞌama-temagi Anumaya Kotiteti ama-tene. Vemo augafa ageno haꞌye hu yateti oꞌamatenegi Anumaya Kotiteti amatene. Veaꞌmoꞌya nafaꞌne atesaya amakesa haviya yateti oꞌamatemagi Anumaya Kotiteti amatene. ");
INSERT INTO knb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yisasina nago agiꞌa Kemona atetegeno ve maineno tagaiꞌene mainegeta agaila alu aotage tokiya hale yamaꞌa neꞌagone. Ani kanoa Anumaya Kotina aiya nagoke nafaꞌneꞌa maineamagino nefaꞌa agaiꞌa alu aotage tokiya hale yamaꞌa amigeno ali falu huno kayoneꞌage yaꞌene tamageꞌage hu yaꞌene agai aguꞌafina hiya hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoniꞌa keha keha nehuno agaife mage hie “Ma kanomofe nayona mage huꞌna tamaha-pai-mainoe haenagaꞌa nago kanoa nagaila onatenele mainea yafe nagaila ago nagase-mainea kanoa egahiema huꞌna tamaha-pai-mainoane.” ");
INSERT INTO knb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ali falu huno kayone yamaꞌa hiya hu-mainefiti tagaila mukiꞌamogatina taya huno kanale manu tamiteno nagoꞌa kanale manuene nelamie. ");
INSERT INTO knb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tamage Anumaya Kotiꞌa kahegi kema malenea kea Mosesena ayapi maleteno hapaigeno hama-pai-mainiamagi ali falu huno kayone yaꞌene tamage hu yaꞌene Yisasi Kalaisiteti neꞌalune. ");
INSERT INTO knb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nagoke kanomoꞌa Anumaya Kotina oꞌagene. Tamage mukiꞌa veala oꞌagenae. Aiya nagoke nafaꞌneꞌamoꞌa Anumaya Kotiꞌene nagoꞌya huꞌana mainaꞌamagino ani kanomoꞌa Nefa avate maineleti Nefana agaiꞌage tave-nelino aepaꞌa hu-gafino taha-pai-maine. ");
INSERT INTO knb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Isaleli vayaꞌmoꞌya Yelusalemu mainaleti Livae nofi vayaꞌene mono note kava vayaꞌene hu-ma-tageꞌya Yonife “Kagaya tagae?” hutama havigeho huꞌya hama-pai-mainae. Hama-paigeꞌya mo havigageno Yoniꞌa ma ke huno hama-nepaiye. ");
INSERT INTO knb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yoniꞌa ani ke fala-kino ohunegi ani kea hu falote huno mage huno hie “Nagaya Kalaisi, Anumaya Kotiꞌma taugafa ali-gatigahe hu-tenea kanoa nagaya omainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Higeꞌya “Ani kanoa omaimagi kagaya tagae? Ilaiyaga mainapi?” huꞌya havigageno “Aꞌao nagaya ani kanoa omainoe.” Yoniꞌa make huno higeꞌya “Nagi Anumaya Koti aune kano mainapi?” huꞌya hageno “Aꞌao.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Higeꞌya “Taha-paiyo kagaya tagae? Hu-la-tenaya vayaꞌmogamina kenonaꞌamima hama-paisuna kea kagesafiti kagaika aliꞌyafe naꞌane ke nehane?” huꞌya havi-negae. ");
INSERT INTO knb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nehageno Yoniꞌa kenonaꞌamilela mage huno hama-nepaiye “Nagaya ma kano mainoe. Nage aiꞌna kaꞌme kotegati keha keha hisua kano mainoe. Aisaiyaꞌa Anumaya Koti aune kanomoꞌa nayo hu-malenea kea mage huꞌna nehue ‘Anumaya visia kana alitama hilato hutama ali fatago hiho.’ huno hu-maineane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Anima havigesia kema aliꞌya vaya vayala Falasia vayaꞌmoꞌya hu-ma-tenae. ");
INSERT INTO knb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ani vayaꞌmoꞌya Yonife mage huꞌya havi-negae “Kalaisigaene Ilaiyagaene Anumaya Koti aune kanoenema omaineka naꞌa higeka tina fale neꞌamatane?” huꞌya havi-ge-mainae. ");
INSERT INTO knb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Havigageno Yoniꞌa kenonaꞌamilela mage hie “Ma nagaya titeti fale nelama-toamagi tamakaipina nagola oꞌagenaya kanoa he-ti-maine. ");
INSERT INTO knb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Heti-maineamagino ani kanomoꞌa haenagaꞌa egahie. Nagaya afa kano mainoamagiꞌna agai aiyalela ayesuana onategahie.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yoniꞌa Petani kumate Yotani timona atu kaiyaga maineno veaꞌne ti fale neꞌama-teno mani kea hu-mainea kehe mehavi-ge-mainae. ");
INSERT INTO knb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Faeteꞌya kotigeꞌya Yisasiꞌa Yonitega eneꞌegeno Yoniꞌa ageteno mage huno nehie “Ageho mani kanoa Anumaya Kotina Sipi sipi nafaꞌneꞌae. Haenagaꞌa haesageno falisia yateti ma mopale veaꞌmogamina kefo yaꞌamia ali-talesia yafe emaine. ");
INSERT INTO knb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ani kanomofe nayona mage huꞌna tamaha-pai-mainoe ‘Haenagaꞌa esia kanomoꞌa nagaila onatenele mainea yafe nagaila ago nagase-mainea kano egahie.’ huꞌna tamaha-pai-mainoane. ");
INSERT INTO knb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nagaya agaila aepaꞌa oꞌagenoanagi Isaleli veaꞌmogamina Yisasina amave-ligahe tina mo fale-ma-tesoe huꞌna emainoane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yoniꞌa mage huno hama-pai-maine “Anumaya Kotina Alu Aotage Avamuꞌamoꞌa nama kana huno ikapinagati elavino eaꞌyamo augafalela emainegeꞌna age-mainoe. ");
INSERT INTO knb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nagaya agaila oꞌagenoanagi Anumaya Kotiꞌa ti fale-ma-to yate hu-natenea kanogino mage hie ‘Kagaya agegane nagaiꞌni Alu Aotage Avamuꞌmoꞌa elavino nago vemo augafaleꞌma emaisigekama agesana vemoꞌa veaꞌmogamina Alu Aotage Avamuꞌaleti fale-ma-tegahie huka havigane.’ huno higeꞌna havi-mainoane. ");
INSERT INTO knb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nagaya ani kema hia yana ago age-mainoleti tamaha-nepauve ma kanoa Anumaya Kotina neꞌamo maine huꞌna nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Faeteꞌya kotigeꞌya Yoniꞌene agaiꞌaene tokaeꞌana nemaiꞌa kanolataꞌene eteꞌya he-tiꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","37","Yisasiꞌa neꞌvigeno Yoniꞌa ageke huno ageteno mage hie “Anumaya Koti Sipi sipi nafaꞌnea atu maine.” huno higeꞌana Yoniꞌene tokaeꞌana nemaiꞌa kanolatana ani kea haviteꞌana Yisasina akave neꞌvaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Akave neꞌvaꞌageno Yisasiꞌa mai-yahae huno anaketeno ke huno hana-vige “Naꞌafe neꞌaꞌe?” huno higeꞌana anakaya mage haꞌe “Lapaiga hanate nemaine?” huꞌana nehaꞌe. Lapai tagai kefina hu-mave-lina kanoe huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yisasiꞌa mage huno hie “Etana megeꞌo.” huno hana-paigeꞌana agaiꞌene neꞌvaꞌageno une kigeꞌana nomaꞌa mogeteꞌana ani kanalela agaiꞌene mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoni kema haviteꞌana Yisasi akaveꞌma umainaꞌa kanolatapitila nago kanomo agia Etaluꞌe ani kanoa Saimoni Pitana aganaꞌamoꞌe. ");
INSERT INTO knb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Etaluꞌa hagoteno nepuꞌamona Saimonife mo atiyeno mogefalote huteno mage huno hapaiye “Anumaya Kotiꞌma taugafa ali-gatigahema hu-tegeno emainea kanoa Kalaisina nagaya ago agoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Huteno Saimonina avaleno Yisasite neꞌvaꞌageno Yisasiꞌa ageke huno ageteno mage hie “Kagaya Saimoniga Yonina nemofogae kagai kagia mage huꞌna nemaloe Sifasigae Pitagae.” huno nehie. Ani agilatamogania nagoꞌya hu-mainaꞌe. Tagai kefina yafaꞌmogae huno malene. ");
INSERT INTO knb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Faeteꞌya kotigeno Yisasiꞌa Kalili visia agesa havino vilegati Filipina mogeteno mage huno hapaiye “Kagaya nakave eno.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipiꞌa Petesaita kumate kanoe. Ani kumala Etalugani Pitagani kumale. ");
INSERT INTO knb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipiꞌa Nataniolona moge-falote huteno mage huno hapaiye “Nago kanomofe Anumaya Koti amaune vayaꞌene Moseseꞌene mono autaꞌmafi kae-malenaya kanoa tagaya ago age-falote hunana agaya Nasaleti Yisasiꞌe Yosefena nafaꞌneꞌamo maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Higeno Natanioloꞌa mage huno hie “Nasaleti kanale yana falote hisifi? Falote ohugahie.” huno higeno Filipiꞌa mage huno hie “Eka mego.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hapaigeꞌana neꞌaꞌageno Yisasiꞌa Nataniolona ageteno mage hie “Ageho Isaleliti tama kanolafane. Mani kanoa nagola havigeꞌa omalenea kano maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Higeno Natanioloꞌa mage huno havinege “Nagai aepaꞌa na yu havimainanane?” huno havigegeno Yisasiꞌa mage hie “Filipiꞌa kagaila moge ohunegeka kagaya fiki yosamo aepale mainanageꞌna nagaya ago kage-mainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Higeno Natanioloꞌa mage hie “Hulaveli kanomoga Anumaya Koti nafaꞌne mainane. Kagaya Isaleli kotega ala sauve kano mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Higeno Yisasiꞌa Nataniolofe mage hie “Fiki yosamo aepale mainanageꞌna nagaya kage-mainoafe tamage nehane huka kagupi maleka kametiti nehano? Haenagaꞌa tusiꞌa ala kavaꞌyaga efalote hinageka agegane.” huno hapai-maine. ");
INSERT INTO knb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yisasiꞌa amakaife mage hie “Tamagelafa huꞌna tamaha-nepauve tamakaya ikamoꞌma ai-halenagetama neꞌagetama ikapinagati emainoa kano vayaꞌmo natenea kanomonilela Anumaya Kotina ensole anagaꞌamoꞌya naugafalela haiteꞌya laviteꞌya nehisagetama agegahae.” huno hama-nepaiye. ");
INSERT INTO knb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tole kana maiteꞌya Kalili hanea kumala Kenae nehaya kumate nago kanomoꞌa a aligahe higeno Yisasina itaꞌamoꞌa anima aꞌma aligahema hia nopi umaine. ");
INSERT INTO knb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Umainegeꞌya “Yisasiga kagaiꞌenema tokaeꞌya nemaiya anagakaene eho.” huꞌya ke hageꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Umaineꞌya nenageno nofi alagamo tina haꞌno higeno Yisasina itaꞌamoꞌa Yisasina mage huno hapaiye “Nofi alagamo tina haꞌno hie.” huno hanepaiye. ");
INSERT INTO knb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Higeno Yisasiꞌa mage hie “Aꞌoko ‘Naꞌa maꞌa huo.’ huka nahaꞌopaiyo kagai yana omalene. nagaya tokiyaꞌniꞌa amavelisua kanaꞌa falote ohune.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nehigeno Yisasina itaꞌamoꞌa kaveꞌma talo talaꞌma huꞌya amamiya veaꞌnehe mage huno hama-paiye “Nago kema hinagetama agai ke akave maleho.” huno hama-nepaiye. ");
INSERT INTO knb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuta vayaꞌmogami mono kemoꞌa mage humaine “Mukiꞌa kanalela mukiꞌa yana sese hutama ti faleho.” huno humaineane. Ani yafe sikisiꞌa (6) yafa ti keꞌayola vani hataletiꞌa (100) lita hanea keꞌayola anilela hane. ");
INSERT INTO knb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hanegeno Yisasiꞌa kaveꞌma talo talaꞌma huꞌya neꞌamamiya veaꞌnehe mage huno hama-paiye “Mani li keꞌayoꞌyakafina hefitama havateho.” huno hama-paigeꞌya hefi havate-mainae. ");
INSERT INTO knb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Havatageno “Kaveteꞌma kava yagai-mainea kanole osiꞌa hefitama alitama momiho.” huno higeꞌya hefiliꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hefiliꞌya momigeno ani kaveteꞌma kava yagai-mainea kanomoꞌa ani lina hagotenoꞌa titafa haniamagi haenagaꞌa eteno nofi alagamo ti hapaegeno neno akekeana higeno ani lina ea kamaꞌa oꞌageneamagi hefiꞌyama aliꞌyaꞌma aya veaꞌnemoꞌyage havimainae. Kaveteꞌma kava kanomoꞌa aꞌma alia kanohe ke huno mage huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Mukiꞌa vayaꞌyaga hagote kanalela hagaꞌage tina amamigeꞌya mageno amamu higeꞌya haviyama hia tina neꞌamamiya yamagi kagaya hagote kanalela afa li tamiteka haenaga hagaꞌage tina nelamine.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Manima taloma hia tokiya avame yana Yisasiꞌa hagote kanale Kalili hanea kumala Kenae huꞌya nehaya kumate ani kavala talo nehuno tusiꞌa ala tokiya hale yamaꞌaene amaveligeꞌya agaiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya ageteꞌya aliꞌya amakupi maleꞌya amametiti hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Naꞌa hu-maletegeꞌya Yisasiꞌene itaꞌamoꞌene aganaꞌamoꞌyaene agaiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌyaene Kapaneamu laviꞌya osi kanaꞌa anile mainae. ");
INSERT INTO knb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nago ala imua Anumaya Kotiꞌma Yuta veayaꞌmogami amakinagomogami amaugafama aligatimainea kanahe amakesa havi havi nehaya imu negiya kana evaꞌyi hugahe higeno Yisasiꞌa Yelusalemu haimaine. ");
INSERT INTO knb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yisasiꞌa ala mono nopi haino mogeana vayaꞌyagamoꞌya pulumaka afuma sipi sipi afuma namama malenageꞌya veaꞌmoꞌya miya hisaya yafe malenageno Yisasiꞌa mokemaine. magi nagoꞌa vayaꞌmoꞌya alu kotega nehanea monea neꞌaliꞌya ani kumateꞌma nehanea monea anonaꞌa amamisaya yafe folomole maleꞌya mopale mainageno momakemaine. ");
INSERT INTO knb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Momaketeno nofiteti alifagagi maleneno mukiꞌa vayaꞌma sipi sipima pulumaka afuyakaene mono nopiti ali helafi neꞌataleno monema ayeyahaeꞌma nehaya vayaꞌmogami folomoꞌamiene moneꞌamiene ali helafi-talene. ");
INSERT INTO knb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Namayagama miya nehaya vayafe mage huno hamapaiye “Alitama eviho. Mafina nenafa nona tamakaya alitama maketi kumala talo ohiho.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nehigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌamoꞌya avopima hanea kehe amakesa nehaviye. Ani kea mage huno haneane “Anumaya Koti nofena mukiꞌa kanale magesa havi havi huꞌna nokaꞌa kanaleꞌya huno hanesia yafe aluya huꞌna muse nehue.” huno kaemalenegeꞌya havimainayane. ");
INSERT INTO knb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Havimainayamagiꞌya Yuta vayaꞌmoꞌya eteꞌya havinegae “Aniꞌama hana kavala ta tokiyaleti nehane? Tokiyakaꞌa hane huta havisuna yafe nagola oꞌagenona tokiya avame yana hugeta agamano.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nehageno Yisasiꞌa kenonaꞌamia mage huno hama-paiye “Ma ala mono nona alitama lagape aitaletesageꞌna taliꞌa (3) kanale eteꞌna ani nona aliꞌna hetigahue.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Higeꞌya Yuta vayaꞌmoꞌya mage huꞌya hapaiye “Kekamoꞌa kanale ohia ke nehane taliꞌa (3) kanale ani nona aliꞌna hetigahue huka nehanamagi vayaꞌyagamoꞌya foti sikisiꞌa (46) kafufi mani nona kimalenaya none.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Huꞌya hageno Yisasiꞌa ani avame kea hiamagi ani mono nofema hiana agaiꞌa augafahe nehie. ");
INSERT INTO knb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yisasiꞌma falitenoꞌma he-ti-mainea kanafina agaiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya ani kema humainea kehena amakesa havimainae. Avopima hanea kene Yisasiꞌma humainea kene “Tamage humaineane.” huꞌya amakupi maleꞌya amametiti humainae. ");
INSERT INTO knb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Imuma negiya kanale Yisasiꞌa Yelusalemu maineno oꞌagenaya tokiya avame yana higeꞌya ageteꞌya mukiꞌa veaꞌnemoꞌya “Tamage nehie.” huꞌya amakupi maleꞌya amametiti humainae. ");
INSERT INTO knb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hayamagi Yisasiꞌa mukiꞌa veaꞌnemogami amakuꞌa ago amakea yafe aguꞌa noꞌamamie. ");
INSERT INTO knb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Naꞌafene amakupima hanea yana ago age-mainea yafe Yisasiꞌa mukiꞌa veaꞌmogamife “Tamakupima hanea yana naha-paiyo.” huno ohune. ");
INSERT INTO knb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nago Falasia kanoa Yuta vayate ala kava kanoꞌamimo agia Nikotimasiꞌe. ");
INSERT INTO knb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nago kegela ani kanomoꞌa Yisasite eno mage huno hie “Humave-nelina kanomoga tagaya ago havimainone kagaya humaveli hama-veli nehana kanomoga Anumaya Kotiꞌa hu-gategeka emainane. Kagaya oꞌagenaya tokiya avame yana nehane. Anumaya Kotiꞌa kagaiꞌene omaineleꞌasina aniꞌa kavala ohateꞌasine. Ani yafe tagaya ago havimainone Anumaya Kotiꞌa hu-gategeka emainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Higeno Yisasiꞌa mage huno hie “Tamage-lafa huꞌna kaha-nepauve anafinaga kanomoꞌma nago kanoma haegafa huno oꞌatesiana Anumaya Kotiꞌma kava yagai-mainea kumala oꞌagegahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Higeno Nikotimasiꞌa mage huno hie “Alopa kanomona hanaꞌa huno ateleꞌasine? Itaꞌamo aipafinaga eteno hai falesigeno nagoꞌene eteno atesie huka nehapio?” huno havinege. ");
INSERT INTO knb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Havigegeno Yisasiꞌa mage huno hie “Tamage-lafa huꞌna kaha-nepauve titetiꞌene Anumaya Koti Alu Aotage Avamuꞌmotetiꞌene oꞌatesiana Anumaya Kotiꞌma kava yagai-mainea kumatela oꞌugahie. ");
INSERT INTO knb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Amaugafama hanea veaꞌmoꞌya augafa hanesia nafaꞌne amategahayanagi Anumaya Kotina Alu Aotake Avamuꞌmoteti atesia kanomona Alu Aotage Avamuꞌmoꞌa haimula amigahie. ");
INSERT INTO knb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nagaya mani kema hua kea ‘Nagoꞌene eteka nato huka huo.’ huꞌna hua kehena havika kamaꞌyoa aika atali ohuo. ");
INSERT INTO knb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yasimoꞌa agaiꞌa hau yate alino visia yana kaulagamoꞌa oꞌagene. Afaꞌa uhuhu uhuhu hia keꞌa haviteka hanategatiꞌma aepa heno falote hia kaꞌene vaiyea kaꞌene oꞌagenane. Yasimoꞌma hia avamete huno Anumaya Kotina Alu Aotake Avamuꞌmoꞌa nago kanomona neꞌateana noꞌagone.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Higeno Nikotimasiꞌa mage huno havige “Ani yana hanaꞌa huno falote hugahie?” huno havinege. ");
INSERT INTO knb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Havigegeno Yisasiꞌa mage huno hie “Kagaya Isaleli veaꞌne hu-maveli hamaveli nehana kano mainanagi naꞌa higeka ohavinane? ");
INSERT INTO knb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tamage-lafa huꞌna kaha-nepauve age-mainona yafe kaha-nepauve havilinona yafe kaha-nepauvanagi mani kea tamakaveꞌno hu-neꞌatae. ");
INSERT INTO knb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nagayama ma mopale yafe ago kaha-nepauvanagi ‘Tamage nehane.’ huka havika kagupi maleka kametiti nohanagi ikapinaga yafema kaha-paisugeka hanaꞌa huka havika kagupina maleka kametitia hugane? ");
INSERT INTO knb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nago kanomoꞌa ikapinaga ohainegi nagaya ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna nagaiꞌniꞌage ikapinagatila ma mopafina elavi-mainoe. ");
INSERT INTO knb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moseseꞌa kaꞌme kotega maineno osifaꞌvea talo huteno yosale malegaꞌmaeno alisaga hu-mainea kavala menia aniꞌa huꞌya ikapinagati emainoa kanoa vayaꞌmo natenea kanomonina navaleꞌya alisaga hugahae. ");
INSERT INTO knb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Alisaga hisageno mukiꞌa veaꞌmoꞌya ‘Tamage nehie.’ huꞌya amakupi maleꞌya amametiti hisaya veaꞌmoꞌya agola maige maige hisaya hamaimula aligahae.” ");
INSERT INTO knb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anumaya Kotiꞌa aiya nagoke nafaꞌneꞌa maineanagi ma mopafi veaꞌnehe tusiya huno hau ayamopafi haigeno ani aiya nagoke nafaꞌneꞌa hu-tegeno elavino emaine. Emainegeta tagaya nagoke nagokeꞌmogata agaife tagupi maleta tametiti hisunana haniki-mai yapi tegelege nehia atafina oꞌugahunanagita agola maige maige hisuna tahaimula aliteta maigahune. ");
INSERT INTO knb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anumaya Kotiꞌa nafaꞌneꞌamona mopale veaꞌne kaiyeke hu-mateno nofi hu-matesia yatela hu-tegeno omenegi mopafi veaꞌne amaku amamemaꞌa ali-gatisiafene huno hu-tegeno emaine. ");
INSERT INTO knb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Emaineanagi nagoꞌa veaꞌmoꞌya Yesasifena amakupi maleꞌya amametiti haya veala Anumaya Kotiꞌa kaiyeke huno nofila hu oꞌama-tegahianagi nagoꞌa veaꞌmoꞌya Anumaya Kotina aiya nagoke nafaꞌnehe haviꞌya amakupi omaleꞌya amametiti nohaya yafe Anumaya Kotiꞌa ago kaiyeke hu-ma-teteno ago nofi hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kaiyekema hu-mate yamo aepaꞌamoꞌa maꞌa hu-maine, aye hale-ma-te kanoa ma mopafina ago emainegeꞌya veaꞌmoꞌya kefo yana nehuꞌya hani yapi maisaya yafe muse huꞌya hale yafena nohamaiya yafe Anumaya Kotiꞌa ago kaiyeke hu-ma-tene. ");
INSERT INTO knb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mukiꞌa kefo kava huge huge nehaya veaꞌmoꞌya hale yafena nohamaigeꞌya “Hale yapima visunageꞌya kefo yatia age-falote hugahae.” huꞌya hale yapina nomae. ");
INSERT INTO knb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tama kava nehaya veaꞌmoꞌya hale yapima neꞌeya mage nehae “Anumaya Kotiꞌa taya higeta kanale yana hu-mainonafe mukiꞌa veaꞌmoꞌya agesae.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Naꞌa hu-maleteno Yisasiꞌene agaiꞌaenema tokaeꞌya nemaiya anagaꞌene Yutia umaineꞌya nagoꞌa kana umaiteꞌya veaꞌnea mono tina fale-ma-tenae. ");
INSERT INTO knb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Fale-ma-tegeno Yoniꞌa Ainonie nehaya kumate maineno aniꞌa huno veaꞌnea fale-ma-tene. Ainoni kumala Salimie nehaya kumaꞌmo aupate hane. Kasagoꞌya tiꞌyaga anilega haneanagiꞌya veaꞌmoꞌya ete ete hageno tina fale-ma-tene. ");
INSERT INTO knb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yonina avaleꞌya nofipina oꞌatenageno ani lina fale-ma-tene. ");
INSERT INTO knb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yonienema tokaeꞌya nemaiya anagaꞌene nago Yuta kanoene mono tima fale yamo auꞌava yafe mohu mehu huꞌya ke vai-mainae. ");
INSERT INTO knb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ke vai-maleꞌya Yonitega mage huꞌya mo hane-paiye “Hulave nelina kanomoga Yotani limona ame haupalega kagaiꞌenema mainegeka agaifema taha-pai-mainana kanomoꞌa menia agaiꞌa tina fale neꞌa-ma-tegeꞌya mukiꞌa veaꞌmoꞌya agaitega utele nehae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hageno Yoniꞌa mage huno hie “Anumaya Kotiꞌa nagoꞌa veaꞌmogamina nago yana oꞌamamineleꞌasina oꞌalileꞌasine. ");
INSERT INTO knb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tamakaya agoꞌma hu-mainoa kea havilinae. Mage huꞌna hu-mainoe ‘Nagaya Anumaya Kotiꞌma taugafa ali-gatigahe hu-tenea kanoa omainogi nagaya uhagoteꞌna neꞌvisugeno agaya haenaga egahie.’ huꞌna hu-mainoe. ");
INSERT INTO knb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nago vemoꞌa aꞌma aliana agaiꞌa a maineanagi ayama hu-mainea kanomoꞌa agava huno aꞌma ali-mainea kea haviteno tusiꞌa muse nehie. Aniꞌama hia avamete huꞌna Yisasitega veaꞌma neꞌvaya yafena nagaya tusiꞌa muse nehue. ");
INSERT INTO knb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yisasi agimoꞌa nagaila nagaseno ala huno haigahianagi nagai nagimoꞌa afete tavigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yoniꞌa mage huno hie “Anafinagati elavi-mainea kanomoꞌa mukiꞌa yana amakase-maineanagi ma mopaletiꞌma efalote hu-mainea kanomoꞌa ma mopale kano maineno mopale yafeke kea nehie. Ikapinagati elavi-mainea kanomoꞌa mukiꞌa yana amakase-maine. ");
INSERT INTO knb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ikapinagati elavi-mainea kanomoꞌa age-mainea yafeꞌene havimainea yafeꞌene hama-nepaiyanagi nagoꞌa veaꞌmoꞌya ani kea haviꞌya amakupina nomalae. ");
INSERT INTO knb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nomalagi nagoke nagoke veaꞌmoꞌya hu-mainea kea haviꞌya amakupima malaya yafe ‘Anumaya Kotiꞌa tamageꞌage kano maine.’ huꞌya hu-lokiya neꞌvaiye. ");
INSERT INTO knb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anumaya Kotiꞌa hu-tenea kanomona Anumaya Kotiꞌa Alu Aotage Avamula nago haupa nago haupa huno oꞌaminegi mukiꞌa hiya huno aminegeno Anumaya Koti kea nehie. ");
INSERT INTO knb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Higeno nefaꞌa nafaꞌneꞌamofena tusiꞌa muse nehuno mukiꞌa kava yagaisia yana ayapi malene. ");
INSERT INTO knb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nagoꞌa veaꞌnemoꞌya nafaꞌneꞌamofema ‘Tamage nehie.’ huꞌya amakupi maleꞌya amametitima hayana agola maige maige hisaya hamaimula ago ali-mainayanagi nagoꞌa veaꞌmoꞌya nafaꞌneꞌamoꞌma hia kema akaveꞌma omalesayana ani hamaimula oꞌaligahae. Anumaya Kotiꞌa ani veaꞌmogamina aipa haviya hu-mateno kaiyeꞌkea ago hu-neꞌamate.” ");
INSERT INTO knb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","“Yisasiꞌa Yonina agaseno mukiꞌa veaꞌmogamina tina fale-ma-teno hai-maine.” huꞌya haya ke Falasia vayaꞌmoꞌya havimainae. Yisasiꞌa agaiꞌa tina fale oꞌama-tenegi agaiꞌaenema tokaeꞌya nemaiya anagaꞌamoꞌya fale-ma-tenae. ");
INSERT INTO knb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Falasia vayaꞌmoꞌya ago ani kea haviya yafe Yisasiꞌa haviteno Yutia neꞌataleno Kalili eteno ugahe amuꞌno kola mogaseno via kotega Samelia mo vaiyatete hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nago Samelia kumaꞌmo agia Sika. Ani kumala Yekopuꞌa Yuta vayaꞌmogami amakinagomoꞌa nafaꞌneꞌamona Yosefe aminea hoya hanelega hane. Yisasiꞌa ani kumate evaꞌyi hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yekopuꞌa ti he-nefia kagemuyola hanegeno yagemoꞌa amuꞌno-kaꞌno higeno Yisasiꞌa kama vaiye-mainea yafe kasalo haegeno ani kagemuyo ti avayale eno mopale maine. ");
INSERT INTO knb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mopale emainegeno nago Samelia aꞌmoꞌa ti he-figahe neꞌegeno Yisasiꞌa mage hie “Tina namigeꞌna nano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Yisasienema tokaeꞌya nemaiya anagaꞌmoꞌya anile omainagi kave miya hugahe ala kumatega umainae.) ");
INSERT INTO knb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yuta vayaꞌene Samelia vayaꞌene amakoꞌya huꞌya amahaote amahaote huꞌya nemaiya yafe ani Samelia aꞌmoꞌa mage huno hie “Kagaya Yuta kano mainanagi nagaya Samelia a mainogi naꞌa higeka nagaifena tina namigeꞌna nano huka nehane?” huno havinege ");
INSERT INTO knb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Higeno Yisasiꞌa mage huno hie “Kagaya Anumaya Kotiꞌma amuse yama kamisia yafema havimainateꞌasina tifena nagaila nahavi-gateꞌasine. Tima namio hia kanoma nagemainateꞌasina tifena nahaviganageꞌna maige maige hisana tina kamuleꞌasine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Higeno ani aꞌmoꞌa mage huno hie “Ala kanomoga ani li komua afe yapi hanegi tima he-fisana keꞌayola omalegi hanateti ani maige maige hisua tina he-fika namigane? ");
INSERT INTO knb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yekopuꞌa, taginagomo ani kagemuyola tamineane. Yekopuꞌa nafaꞌneyagaꞌaene agaiꞌa afuyagaene ani komufitila ne-mainae. ‘Agaila agase-mainoe.’ huka nehapio?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Higeno Yisasiꞌa mage huno hie “Mukiꞌa veala ma lipiti nesayana eteꞌya lifena amakegahianagi nagoke nagoke veaꞌmogamima amamisua timoꞌa amakusafinaga kapae nehagea ti kana huno lavige lavige hisigeꞌya maige maige hisaya hamaimula amamigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Higeno ani aꞌmoꞌa mage huno hie “Ala kanomogae ani lina namigeꞌna nano. Namisanageꞌna nagoꞌene onahaugahianagiꞌna malela tima he-figahena eteꞌna omano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Higeno Yisasiꞌa mage huno hie “Negavena mo ke hu-lika male eno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Higeno ani aꞌmoꞌa mage hie “Nenaveꞌa omaiye.” huno higeno Yisasiꞌa “Nenaveꞌma omaiyema hanana tamage nehane.” ");
INSERT INTO knb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Kagaya faefuꞌa (5) negaveꞌya mainayane meni kanafina nago vene mainananagi miya hu-ga-tenaya negaveꞌa omaine. Mani kea tamage huka naha-nepaine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Higeno ani aꞌmoꞌa mage huno hie “Ala kanomogae nagaya ago havimainoe kagaya Anumaya Kotina aune kanoꞌa mainane. ");
INSERT INTO knb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Taginagomoꞌya ma agoꞌyale* Anumaya Koti agia alisaga nehayanagi tamakaya Yuta vayaꞌmogatama ‘Yelusalemu Anumaya Koti agia alisaga nehaya kumala hane.’ hutama nehae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Higeno Yisasiꞌa mage huno hie “Ma aꞌmoga nagayama tamage huꞌna kaha-paisua ke havika kagupi ai-maleteka kametiti huo. Nago kana falote hinageno ma agoꞌyaleꞌene Yelusalemuene Anumaya Koti agia alisaga ohugahagi alu kumateti kumateti agia alisaga hugahae. ");
INSERT INTO knb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tamakaya Samelia veaꞌmogatama agima alisaga nehaya kanomona age-lama hutama oꞌagenae. Tagaya Yuta veaꞌmogata agima alisaga nehuna kanomofe havilama hu-mainona yafe agia alisaga nehune. Tamaugafa ali-gatisia kanoa Yuta vayapiti falote nehie. ");
INSERT INTO knb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nago kana falote hugahie. Ani kana ago falote hu-maine. Nenafa agima alisaga hisaya veaꞌmoya tamage huꞌya amaku amamemaꞌafiti Nenafa agi alisaga hisaya kanamoꞌa ago falote hu-maine. Nenafana amaku amamemaꞌafiti agima alisaga hisaya veaꞌnehe ati neꞌaye. ");
INSERT INTO knb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anumaya Kotiꞌa augafa omalenea avamula mainea yafe agai agima alisaga hugahena veaꞌmoya amaku amamemaꞌaleti tamage huꞌya agia alisaga hiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Higeno ani aꞌmoꞌa kenonaꞌa mage huno hie “Kalaisiꞌa, Anumaya Kotiꞌma taugafa ali-gatigahie huno hu-tesia kanoma esia kea nagaya ago havimainoe. Esiana mukiꞌa yafena taha-paigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Higeno Yisasiꞌa kenonaꞌa mage hie “Nagaya nevayaꞌna kakaiꞌenema maineꞌna kema nehua kanoa mani kano mainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mani kea nehigeꞌya agaiꞌaenema tokaeꞌya nemaiya anagala eteꞌya neꞌeꞌya Yisasiꞌma aꞌmoꞌenema kea kea haꞌaꞌyafe ageteꞌya tusi amakesa havi havi hayanagi nagoꞌamoꞌya “Naꞌafe nehane?” huꞌya aꞌmofena haviokenae. “Naꞌa higeka ma aꞌene kea kea nehane?” huꞌya Yisasina haviokenae. ");
INSERT INTO knb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ani aꞌmoꞌa ti kena neꞌataleno ala kumatega uno anifima mainaya veaꞌnehe mage huno hama-paiye “Mukiꞌa nayoma hu-mainoa yama naha-paiya kanoa etama megeho. Ani kanoa Anumaya Kotiꞌma taugafa ali-gatigahema hu-tenea kanofi?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Higeꞌya kumala neꞌataleꞌya Yisasitega emainae. ");
INSERT INTO knb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yaufa neꞌageꞌya Yisasiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya Yisasifena mage hae “Hulave-nelina kanomoga nesana yana hanegi no.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nehageno Yisasiꞌa mage huno hie “Nagaya oꞌagenaya kaveꞌnia hane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Higeꞌya ani anagaꞌamoꞌya amakaiꞌami huge havige huꞌya mage hu-mainae “Nago kanomo nesia kavela ago alino me mainefi?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hageno Yisasiꞌa mage huno hie “Nesua kavela ma hane hu-na-tenea kanomoꞌma haisia kavaꞌma huꞌna naminea aliꞌyana alivaya ayesua yana kaveꞌniꞌa hane. ");
INSERT INTO knb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Veaꞌmoꞌya nehaya ke mage hutama nehae ‘Foꞌa (4) ika maitesunageno afuma nelea kana falote hugahie.’ hutama nehafi? Nagaya tamaha-nepauve tamakaya hoyafina age-lama hutama ageho. Ani hoyafina ago afu-le-maine. Anima hia kava huꞌya veaꞌmoꞌya nagai kema haviꞌyama amakupi maleꞌya anametiti hisaya yafe ago afu-le-mainae. ");
INSERT INTO knb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Afuma leana Anumaya Koti kema havisaya yafe ayama hisia kanomoꞌa anonaꞌa aligahianagi aya hu-mainaya vayala amakupi maleꞌya amametiti hisayana agola maige maige hisaya hamaimula aligahae. Aligahayanagi ani hoyafima avina yama negalia kanomoꞌene afumalegeno ayama huno neꞌalia kanomoꞌene nagoꞌya huꞌana musena hugaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Manima agoꞌma hu-mainaya kea ‘Nago kanomoꞌa kali-malegeno nago kanomoꞌa nenaꞌa neꞌalie.’ huꞌya haya kea tamage nehae. ");
INSERT INTO knb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nehagi nagoꞌa veaꞌmoꞌya kasageke huꞌya anima nagai kema ohavinaya veaꞌmogamina Anumaya Koti ke ago hama-pai-mainagi tamakaya ayama hugahena ani vayate ago hu-lama-togetama hama-pai-mainayanagiꞌya amakupi malesagetama afaꞌa nenaꞌage aligahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ani aꞌmoꞌma hu-mainea kehe mukiꞌa Samelia veaꞌmoꞌya Yisasife haviꞌya amakupi maleꞌya amametiti nehae. Ani aꞌmoꞌa mage huno hu-maine “Mukiꞌa hu-mainoa yana ago naha-pai-maine.” huno hu-mainea kehe haviꞌya amakupi maleꞌya amametiti hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yisasite evaꞌyi huꞌya mage huꞌya hae “Tagaiꞌene maisane.” huꞌya havigageno Yisasiꞌa amakaiꞌene tole kana maine. ");
INSERT INTO knb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mainegeꞌya kasagoꞌya veaꞌmoꞌya agai kema haviya yafe amakupi maleꞌya amametiti nehae. ");
INSERT INTO knb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Amametiti nehuꞌya ani aꞌmofe mage huꞌya hapaiye “Menima kagai kema havuna yafe Yisasina taguꞌa amita tametiti nohunagi tagayama agai kema tagaiti haviteta tagupi maleta tametitia nehune. Menia nehavune mani kanoa ma mopale veaꞌmogati taugafa ali-gatigahe emaine.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Anile tole kana maiteno Yisasiꞌa ataleno Kalili umaine. ");
INSERT INTO knb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yisasiꞌa agaiꞌa nayona mage huno hu-maineane “Nago mono ke hama-nepaiya kanomoꞌa agaiꞌa vayaꞌamogamipi maineana vayaꞌamoꞌya ‘Ala kanomo kegi havigetao.’ huꞌya nohae.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hu-maineanagi Kalili evaꞌyi higeꞌya ani kumate veaꞌmoꞌya hu falu fala huteꞌya muse-kase hu-mainae. Naꞌafene ani veaꞌmoꞌya Yelusalemu ala imu ki-mainaya kanale Yisasiꞌma mukiꞌa yama hu-mainea yama moge-mainaya yafe hu falu fala huteꞌya musena hu-tenae. ");
INSERT INTO knb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Musena hutetageno Yisasiꞌa eteno Kalili hanea kumala Kena kumate uvaꞌyi hu-maine. Ani kumatela Yisasiꞌa tifena higeno nofi alagamo ti hapae-mainea kumale. Yisasiꞌa anile umainegeno nago kamani kava kanoa, Kapaneamu kumate kanogino, neꞌamoꞌa kali ali-maine. ");
INSERT INTO knb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kali neꞌaligeno nefaꞌa “Yisasiꞌma Yutiati ago Kalili emaine.” huꞌya haya kea haviteno aupaꞌa nafaꞌneꞌa neꞌataleno Yisasite eno mage huno hie “Nafaꞌneꞌniꞌa falisia kava nehigi melika kanale huto.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Higeno Yisasiꞌa mage huno hie “Tamakaya tokiya avame yama oꞌagenutamahena nagaifena tamakuꞌa havi onamitama tamametitia ohugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Higeno ani kamani kava kanomoꞌa mage huno hie “Ala kanomogae nafaꞌneꞌniꞌa ago faligahe nehigi afaꞌa kaiyayeka nagaiꞌene eno.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Higeno Yisasiꞌa mage hie “Kagaya afaꞌa vuo. Nafaꞌnekamoꞌa ofaligahigi afaꞌa maigahie.” huno higeno Yisasiꞌma hia kea havino akuꞌafi maleteno ametiti nehuno umaine. ");
INSERT INTO knb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Emainea kate eteno maitagifeno neꞌvigeno aliꞌya nafaꞌneꞌamoꞌya me fotu huteꞌya mage huꞌya hae “Kagaila nafaꞌnekamoꞌa ago kanale hu-tegeno maine.” huꞌya me-hae. ");
INSERT INTO knb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Me hageno “Na kanale aepa heno kanale hu-tene?” huno hamavi-gegeꞌya “Ega yagemoꞌa ali tagifeno nagokete evigeno ani amuko-nakoma haiya kalimoꞌa kanale hu-tene.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hageno nefaꞌa agesa haviteno mage hie “Tamage yagemoꞌa ani kanaꞌale eneꞌvigeno Yisasiꞌa ‘Nafaꞌneka ago kanale maine.’ huno naha-pai-maine.” huno nehuno agaiꞌaene mukiꞌa anagaꞌaene Yisasife haviꞌya amakupi maleꞌya amametiti hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisasiꞌa Yutiati eteno Kalili emaineno aniꞌama hia kavala napa tu (2) kanale tokiya avame yana hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Haenagaꞌa Yuta veaꞌmoꞌya ala imu Yelusalemu negiya kana falote higeno Yisasiꞌa anilega hai-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalemu kegiꞌyafi nago fiana sipi sipi afuyagamo fiana hane. Ani fiama hanelela ti kotuna male-maine. Ani li kotumo agia Yuta vayaꞌmogami* kefina Petesaitae. Ani kotutela faefuꞌa (5) fugagiꞌeta nona hane. ");
INSERT INTO knb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Mukiꞌa kali veala aulaga asu hu-mai anagaꞌene aiya avayu hu-mainea anagaꞌene aiyaꞌaya api hu-mai anagaꞌene ani fugagiꞌeta noꞌyagafi alitalu huꞌya fae-mainae. ");
INSERT INTO knb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nago anile nemaiya kanomona kaliꞌamoꞌa teti eitiꞌa (38) kafu hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisasiꞌa anima faeno mainea kanoa mogeteno “Mani kanoa ayaꞌaya kana kalia alino maine.” huno huteno mage hie “Kalikamoꞌma haꞌnoma hisia yafena muse nehapio?” huno havige-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Havigegeno kali kanomoꞌa Yisasife mage hie “Humave-nelina kanomoga tima aikalafuꞌma nehia kanaleꞌma naya huno navaleno tipi natesia vayala omaiya yafe nagaiꞌnige oanagi nagaila ago nagaseꞌya tipi aupaꞌa neꞌvae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Higeno Yisasiꞌa mage hie “Hetika fae omanakaꞌa neꞌalika ka vuo.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Higeno aupaꞌa kaliꞌamoꞌa kanale hu-tegeno hetino fae omanaꞌa neꞌalino ka umaine. Kanaleꞌma hu-tenea kana Sapati kanalele. ");
INSERT INTO knb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ani yafe Yuta vayaꞌmoꞌya kaliꞌama haꞌno hutea kanomofe mage hae “Meni kana Sapati kanalele. Naꞌa higeka faesana omanaka alika neꞌvane? Tagaiꞌma kahegi kemoꞌa Sapati kanalela ani kavala ohuo huno hu-maineane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hageno kenonaꞌamia mage hie “Kaliꞌniꞌa alino kanaleꞌma hu-na-tea kanomoꞌa mage huno naha-pai-maine ‘Fae omanakaꞌa neꞌalika vuo.’ huno hu-na-tene.” huno hie ");
INSERT INTO knb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Higeꞌya mage huꞌya havigae “Mani kanoa hana kanomo kaha-paigeka faesana omanaka alika neꞌvane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hayanagi mukiꞌa veaꞌma anile alitaluma hagenofena Yisasiꞌa aluꞌale ago umainegeno anima kaliꞌama haꞌnoma hutea kanomoꞌa mage hie “Oꞌagoa kanomo ani kea hu-natene.” huno ha-mapaiye. ");
INSERT INTO knb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Haenagaꞌa Yisasiꞌa kanale hu-tenea kanomona mono nopi mainegeno mogeteno mage hie “Kagaya ago menia kalikaꞌa haꞌno hu-ga-tegeka kanale huka mainanagi kefo kavala nagoꞌene ohuo. Kefo kavaꞌma hisanana nagoꞌa kana ya aligane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Higeno mani kanomoꞌa viaꞌyamo Yuta vayafena mage huno hama-paiye “Yisasiꞌa alino kanale hu-natenea kanoe.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hianagi Yisasiꞌma Sapati kanaleꞌma kaliꞌama alino kanaleꞌma hu-tenea yafena Yuta vayaꞌmoꞌya aepa heꞌya amaipa kafa heteꞌya Yisasina aliꞌya haviꞌya hu-neꞌatae. ");
INSERT INTO knb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yisasiꞌa mage huno hama-nepaiye “Nenafaꞌa mukiꞌa kanalela aliꞌyana neꞌaligeꞌna nagaiꞌenena aniꞌa huꞌna aliꞌyana neꞌalue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mani kehena Yisasiꞌa “Anumaya Kotiꞌa nagai Nenafaꞌe.” huno nehuno “Nagaya Anumaya Kotiꞌene nago kana kana hutaꞌa mainoꞌe.” hunoꞌma nehia kene Sapati kanale kahegi kema atagae-mainea yafeꞌene Yuta vayaꞌmoꞌya nagoꞌene ke vaiteꞌya “Haegahune.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yisasiꞌa mage huno hie “Tamage-lafa huꞌna tamaha-nepauve Nafaꞌneꞌamoꞌa agaiꞌage nagoke kavala nohianagi Nenafaꞌma nehia kavala age-maineafe ani kavala nehie. Nenafaꞌma nehia kavala Nafaꞌneꞌamoꞌa ani kavala nehie. ");
INSERT INTO knb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nenafaꞌa Nafaꞌneꞌamofena aguꞌafina nehaigeno agaiꞌma mukiꞌa nehia kavala ave-nelie. Ave-ligeno ala kavaꞌma ago hu-mainea kavala agaseno haenagaꞌa tusiꞌa ala kavakefa ave-linegetama agetama atali atalu hugahae. ");
INSERT INTO knb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nenafaꞌa fali-mainea vayala ali he-ti-mateno hamaimuꞌa neꞌamamianagino Nafaꞌneꞌamoꞌa aniꞌa huno haiya veaꞌmogamina hamaimula neꞌamamie. ");
INSERT INTO knb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nenafaꞌa nago kanomona fako hu noꞌateanagi mukiꞌa veala fako hu-ma-tesia tokiya yana Nafaꞌneꞌamona ago amine. ");
INSERT INTO knb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aminea yafe Nenafafema mukiꞌa veaꞌmoꞌya agima alisaga hayana aniꞌa huꞌya Nafaꞌneꞌamo agia alisaga hisae. Nagoꞌa veaꞌmoꞌya Nafaꞌneꞌamo agima alisaga ohisayana aniꞌa huꞌya hu-tenea Nenafa agiene alisaga nohae. ");
INSERT INTO knb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Magi nagaya tamage-lafa huꞌna tamaha-pauve nagoꞌa veaꞌmoꞌya keꞌniꞌa haviꞌya hu-natenea kanomofe ‘Tamage nehie.’ huꞌya amakupi maleꞌya amametiti hisayana ani veaꞌmogamina agola maige maige hisaya hamaimula ago ali-mainae. Ani veala hagoteꞌya fali-mai vaya kana huꞌya mainafiti hetiꞌya hamaimuꞌamia ali-mainae. Haenagaꞌa Anumaya Kotiꞌa kaiyeꞌkea hu oꞌama-tegahie. ");
INSERT INTO knb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tamage-lafa huꞌna tamaha-nepauve nago kanamoꞌma agoꞌma falote hisiana amaku amamemaꞌamoꞌa fali-mainaya veaꞌmoꞌya Anumaya Koti nafaꞌnemo ke haviteꞌya akave malesayana he-tiꞌya agola maigahae. Ani kana ago falote hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nenafana agaiꞌafi haimuꞌmo aepa haneanagi aniꞌa huno Nafaꞌneꞌamofena ‘Hamaimuꞌmona aepaꞌa maiyo.’ huno hu-tene. ");
INSERT INTO knb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nafaꞌneꞌamofena ikapinagati emainea kanoa vayaꞌmo atenea kanoginofe kaiyeꞌkema hu-ma-teno fako hu-ma-tesia tokiyaꞌa amine. ");
INSERT INTO knb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mani kehena atali ohiho. Nago kana falote hisiana mukiꞌa agoꞌma faligeꞌyama komufi he-vai-matenaya veaꞌmoꞌya Yisasini nagea havigahae. ");
INSERT INTO knb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Haviteꞌya ani komufinagati he-tiꞌya hati-lavisageꞌya kanale kava hu-mainesaya veaꞌnea hetiꞌya agola maigahayanagi kefo kava hu-mainesaya veaꞌnea he-tisageno Anumaya Kotiꞌa kaiyeꞌkea hu-ma-teteno kina hu-ma-tenageꞌya haviya hugahae. ");
INSERT INTO knb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nagaiꞌnige nago kavala nohuanagi Anumaya Kotiꞌa nahapai-mainea keleti kea fako hu-neꞌama-toe. Ani yafe fatago hulama huꞌna kea fako hu-neꞌama-toe. Nagaiꞌniꞌa nagesafiti ani kavala nohuanagi hu-na-tenea kanomoꞌa agaiꞌa huo hea kavaꞌage nehua yafe fatago hu-lama huꞌna kea fako hu-neꞌama-toe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","“Nagaiꞌnigeꞌma hu-haleꞌna aepaꞌaꞌnima tamaha-paisugenoꞌa keꞌnimoꞌa haviya hugahianagi nago kanomoꞌma nagaifema hu-haleno tamaha-nepaiyana nagaya ago havimainoe agayama nagaifema hia kea tamage nehie. ");
INSERT INTO knb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tamakaya vayala hu-matageꞌya Yonitega vageno Yoniꞌa nagaifena ke tamage tamaha-pai-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nagayama vayaꞌmoꞌya nagaifema hu-mainaya kea ‘Afa ke nehae.’ huꞌna huanagi tamakaya ani kea havisageno tamaugafa ali-gatisia yafe tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoniꞌa kaꞌni kana huno maineno hanagaligenoꞌma leana osi kanafi tamakaya agai kaꞌniꞌmoꞌma lea yafena musena hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Muse hu-mainayanagi nago tusiꞌa kanale yaꞌaene nagai aepaene tamave-li-maine. Ani yana ali-mainoa aliꞌyaniꞌae. Nenafa naminea aliꞌyama aliꞌna avaya-yesua yana Yoniꞌa nagaife hu-mainea kemo agase-mainegetama agetetama nagaifena havimainae. Ani aliꞌyaꞌniꞌa Nenafa hu-na-tenea yafe tamave-li-maine. ");
INSERT INTO knb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hu-na-tenea Nenafaꞌa nagaifena ago tamaha-pai-maineanagi tamakaya agaila ageꞌa ohavitama agai aufina oꞌagetama hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hu-tenea kanomofena ‘Tamage nehane.’ hutama tamakupina maletama tamametiti nohaya yafe Anumaya Koti kea tamakupina alitama nomalae. ");
INSERT INTO knb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Anumaya Koti kea nayo kae-malenaya avopi hapalitama ati-yetama ago age-mainae. ‘Ani avopitila agola maige maige hisuna tahaimula aligahune.’ hutama tamakesa havimainae. Ani avona nagaife huꞌya tamaha-pai-mainayanagi nagaitega esaya tamakesa nohaviye. Agola maige maige hisaya tamahaimula tamamisua yafena nagaitega nomae. ");
INSERT INTO knb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Veala muse hu-na-teyafene huꞌna nohuanagi tamakaifena nagaya ago havimainoe. Tamakaya tamakuꞌafina Anumaya Kotifena notama-haikeꞌna neꞌagoe. ");
INSERT INTO knb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nagaya Nenafa agile emainoanagi navaletama falu fala hutama nonatayanagi alu kanomoꞌa agaiꞌa agile esigetama afaꞌa avaletama ali falu fala hutegahae. ");
INSERT INTO knb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tamakaya ‘Alu vayatimo alu vayatimoꞌya muse hu-lateꞌya ala tagi lamisae.’ hutama nehayanagi Anumaya Kotiꞌa agaiꞌage mainegi alu Anumaya Kotiꞌa omaineanagitama Anumaya Kotiꞌa muse hu-lama-tesia yafena notamahaiye. Naꞌa nehayanagi hanaꞌa hutama nagaifena tamakupina maletama tamametitia hugahae? ");
INSERT INTO knb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tamakaya nagaife ma ke hutama ohaviho ‘Nefate kaiyekea hu-la-tegahie.’ hutama tamakesa ohaviho. Aꞌao, nagaya kaiyekea hu otama-tegahuanagino tamakayama taya hugahiema hutama nehaya kanomo, Moseseꞌma tamaha-paiya kemoꞌa kaiyekea hu-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosese kema havitama tamakupi maletama tamametitima haleꞌasina nagai kene aniꞌa hutama tamametitia haleꞌasine. Moseseꞌa nagaife huno kae-maleneafe aniꞌa haleꞌasine. ");
INSERT INTO knb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tamakaya Moseseꞌma kae-malenea kema havitama tamakupi maletama tamametitia ohunayanagitama hanaꞌa hutama nagai ke havitama tamakupi maletama tamametiti hugahae?” huno hamavi-nege. ");
INSERT INTO knb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Haenagaꞌa Yisasiꞌa tipi kalefi uno Kalili* li kotuna takaeno umaine. Ani li kotumona nago agia Taipiliasie.* ");
INSERT INTO knb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mukiꞌa veaꞌmoꞌya kaliꞌamima alino kanale hu-ma-teno tokiya avame yama higeꞌyama agaya yafe akave umainae. ");
INSERT INTO knb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Vageno Yisasiꞌene agaiꞌaenema tokaeꞌya nemaiya anagaꞌaene agoꞌyale haiꞌya mopale mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yuta vayaꞌmoꞌya Anumaya Kotiꞌma amakinagomogami amaugafama ali-gati-mainea yafe amakesa havisaya imu* kisaya kanaꞌa ago aupa hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisasiꞌa ageno ataleno ageana mukiꞌa veaꞌmoꞌya agaitega neꞌageno amaketeno Filipife mage hie “Hanateti ani veaꞌmoꞌyama nesaya kavela miya hugahune?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yisasiꞌa Filipina ayevataga huno mani kea nehuno agayama hugahema hia yana ago havimaineno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipiꞌa mage hie “Nago kanomoꞌa tu hataletia (200) kanale aliꞌyana aliteno miya alino ani monea ataleno kaveꞌma miya hisiana ma mukiꞌa veakefafina osi osi huꞌya kavela alite alite hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Higeno nago kanoa agaiꞌaenema tokaeꞌya nemaiya anagaꞌamogamipitila, Saimoni Pitana aganaꞌamoꞌa Etaluꞌa, mage huno hie “Nago nafaꞌnemoꞌa faefuꞌa (5) mayagi tole noyamegi huno ali-lino maine. Veakefamo alino ala higeno mani kavela osi kanoꞌa haneanagi hanaꞌa huno taya hisie?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Higeno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌamofe mage hie “Mukiꞌa veakefa ‘Mopale maiho.’ hutama hama-paiho.” huno hama-paiye. Ani kumala mukiꞌa apeꞌage hanea kumalagiꞌya mukiꞌa veakefa mopale mainae. Ani veala faefu tauseniꞌa (5,000) veneꞌne mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yisasiꞌa ani maya alino Anumaya Kotitega muse huno havigeteno mukiꞌa mopale mainaya veaꞌmogamina fako huno amamite amamite hu-maine. Noyamene ani kava higeno mukiꞌa veaꞌmoꞌya ani kavela nageno amamu hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nemamu hu-male-tageno Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌamofena mage hie “Mukiꞌa atupa-tapa kavela alitalu hu-tama maleho. Nagoꞌa osi osi atupa vitali vitali ohiho.” ");
INSERT INTO knb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Amakaya mukiꞌa veala faefuꞌa (5) maya kanoꞌafiti neteꞌya atalaya atupayaga alitalu huꞌya tuelufuꞌa (12) kula ai-havate-mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Anifiꞌma mainaya veakefamoꞌya Yisasiꞌma hu-mainea tokiya avame yana ageteꞌya mage hae “Tamage huno Anumaya Kotina aune kanoꞌa hu-tesigeno ma mopafima egahiema huno hu-mainea kanoa mama ago emaine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hageno Yisasiꞌa vayaꞌmoꞌyama hisaya kavala aguꞌafinaga mage huno havimaine “Mani vayaꞌmoya nagaila sauveꞌami maisua yafe navalegahe nehae.” huno nehuno neꞌamataleno agaiꞌage agoꞌyafi hai-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Yagemoꞌa lavi-falegeno une avamemaꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌamoꞌya ala ti agegayalega uteꞌya tipi kalefi asaga hu-maiꞌya Kapaneamu vayana Yisasiꞌa amakaiꞌenena oꞌune. Oꞌvigeꞌya yaufa uge uge huꞌya neꞌvageno hani ki-ma-tene. ");
INSERT INTO knb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ala yasigefamoꞌa eno tina melino mo ai-yahae me ai-yahae huno tusiya hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tusiya higeꞌya tipi kalefima mainaya vayaꞌmoꞌya yosaleti vailagai-liꞌya vayana nagoꞌa ayaꞌayaꞌa sikisiꞌa (6) kilomita ti kotuꞌmona amuꞌnopi neꞌuꞌya agayana Yisasiꞌa ti avoyale aiya ayeme ayeme tipi kalema hanelega neꞌegeꞌya ageteꞌya tusiya huꞌya kolia hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Koli nehageno Yisasiꞌa mage huno hama-paiye “Kolia ohiho mamona nagayae.” huno hama-nepaiye. ");
INSERT INTO knb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hama-paigeꞌya vayaꞌmoꞌya Yisasina tipi kalefi haisaga hu-maisia yafe muse nehuꞌya tipiti avalesaga nehae. Ani tipi kalemoꞌa visaya kumatela aupaꞌa uvaꞌyi hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Faeteꞌya kotigeꞌya tikotuꞌmona atu kaiyaga mainaya veaꞌmoꞌya ageteꞌya mage hae “Nagoke tipi kaleꞌage hanegeta age-mainone. Yisasiꞌenema tokaeꞌya nemaiya anagaꞌage ani lipi kalefi vayanagi Yisasiꞌa oꞌunegi ani vayala amakaiꞌamige umainae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ani kumala Yisasiꞌa Anumayamotega nunamu huno muse huteno kavela amamigeꞌya ne-mainaya kumate nagoꞌa lipi kaleyaga Taipiliasi kumateti anile neꞌae. ");
INSERT INTO knb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Neꞌeꞌya mukiꞌa veaꞌmoꞌya megayana Yisasiꞌenema tokaeꞌya nemaiya anagaꞌene omainageꞌya megeteꞌya tipi kalefi asaga hu-maiꞌya Kapaneamu Yisasife mo atiye-mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Atiyeme valegati atu kaiyaga umaineꞌya Yisasina mogeteꞌya mage hae “Hulave-nelina kanomoga na yu ma kumala meli-mainane?” huꞌya havinegae. ");
INSERT INTO knb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Havigageno Yisasiꞌa mage hie “Nagaya tamagelafa huꞌna tamaha-nepauve tamakaya kaveꞌma tamamugetama nageno tamamuꞌma hu-mainea yafe natia neꞌayayanagi nagaila tokiya avame yama hugetama age-mainaya yafena natia noꞌayae. ");
INSERT INTO knb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tamakaya kasalisia kavefena maitama ati oꞌayeho. Maige maigema hisaya kavefeꞌke maitama atiyeho. Nagaya Nenafaꞌa, Anumaya Koti hu-na-tenea kanomoꞌna ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna mani kavela tamamigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Higeꞌya mage huꞌya havinegae “Tagaya hanaꞌa huta Anumaya Koti aliꞌyana alisune?” huꞌya havinegae. ");
INSERT INTO knb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hageno Yisasiꞌa mage hie “Mani aliꞌyana Anumaya Kotiꞌa muse nehia aliꞌyane. Agayama hu-tegeno emainea nafaꞌnemofe tamakupi maletama tamametiti hisaya yafe muse nehie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Higeꞌya mukiꞌa veaꞌmoꞌya mage hae “Hana augafa tokiya avame yana tave-lisanageta ageteta tagupina maleta tametiti hisune? ");
INSERT INTO knb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nayona taginagomoꞌya vaya omai kotega maineꞌya nago kavela agia manae nehaya kave ne-mainayane huno kae-maleneane ‘Ikapinagati maya amamigeꞌya ne-mainae.’ huno kaemaleneane.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hageno Yisasiꞌa mage hie “Nagaya tamage-lafa huꞌna tamaha-nepauve ikapinagati elavi-mainea maya Moseseꞌa agaiꞌa oꞌamaminegi Nenafaꞌa ikapinagati tama maya menia nelamamie. ");
INSERT INTO knb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Anumaya Kotiꞌma tamamia mayamoꞌa maꞌa hu-maine nago kanoa ikapinagati ea maya mainea yafe ma mopale mainaya veala hamaimula amamine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Higeꞌya mage huꞌya hae “Ala kanomogae mukiꞌa kanalela ani maya tamige lamige huo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hageno Yisasiꞌa mage huno hama-nepaiye “Nagaya hamaimu amamisua maya mainoe. Nagaitegama esia veaꞌmoꞌya nagoꞌene amakala otegahae. Nagayama hu-lama-tesua yafe amakuꞌafi maleꞌya amametiti hisaya veaꞌmoꞌya tifena oꞌamakegahae. ");
INSERT INTO knb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nagaya ago tamaha-paugetama nagaila ago nagemainayanagi nagaya hu-lama-tesua yafena tamakupina maletama tamametitia nohae. ");
INSERT INTO knb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mukiꞌa Nenafaꞌma naminea veaꞌmoꞌya nagaitega egahae. Nago kanomoꞌma nagaitegama esigeꞌnahena ‘Eteka vuo.’ huꞌna hu oꞌategahue. ");
INSERT INTO knb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hu-na-tenea kanomoꞌma haisia kavaꞌma hisua yafe ikapinagatila hu-nategeꞌna emainoe. Nagaiꞌniꞌa nagesafiti kavala hugahe omenoe. ");
INSERT INTO knb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hu-na-tenea kanomoꞌma haisia kavaꞌma hisuana maꞌa hu-maine naminea veaꞌnefitila nagoke kanoꞌa fanane ohisageꞌna ma mopama haꞌnoma hisia kanafina mukiꞌa fali-mainesafiti ali he-ti-matesugeꞌya agola maige maige hugahae. ");
INSERT INTO knb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nenafaꞌa maꞌa yafe musena nehie mukiꞌa veaꞌmoꞌya nafaꞌneꞌamona neꞌageꞌya agayama hu-matesia yafe havilama huꞌya amakupi maleꞌya amametiti hisayana agola maige maige yana aligahae. Alitesageꞌna ma mopama haꞌno hisia kanafina nagaya fali-mainesafitila ali he-ti-ma-tesugeꞌya agola maige maige huꞌya maigahae.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yisasiꞌma “Nagaya ikapinagati elavi-mainoa maya mainoe.” huno hu-mainea kehe Yuta veaꞌmoꞌya Yisasifena ke vaiꞌya kasagoꞌya ke hu-tenae. ");
INSERT INTO knb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mage huꞌya nehae “Ma kanoa Yisasiꞌa, Yosefe nafaꞌnefi? Nefaꞌene itaꞌamoene ago age-mainone. Naꞌa higeno menia ‘Ikapinagati elavi-mainoa kano mainoe.’ huno nehie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hageno Yisasiꞌa kenonaꞌamia mage huno hie “Tamakaya tamakaitamifima kasagoꞌya kema hatagaya kea ataleho. ");
INSERT INTO knb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nago kanomoꞌa nagaitega agaiꞌa nomegi hu-na-tenea Nenafa avayu hinageno nagaitega enageꞌna nagaya ma mopama haꞌno hisia kanafina fali-mainesifiti ali he-ti-tesugeno haimula aligahie. ");
INSERT INTO knb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Anumaya Koti aune vayaꞌmoꞌya mage huꞌya kae-malenayane Mukiꞌa veaꞌmogamina Anumaya Kotiꞌa hu-maveli hamaveli hugahie huꞌya kae-malenayane. Mukiꞌa veaꞌmoꞌya Nenafaꞌma hu-mavelia kea haviteꞌya akave malenaya veaꞌmoꞌya nagaitega neꞌae. ");
INSERT INTO knb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nago kanomoꞌa Nenafana oꞌageneanagi Anumaya Kotitegati emainea kanomoꞌa agaiꞌage Nefana age-maine. ");
INSERT INTO knb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tamage-lafa huꞌna tamaha-nepauve nagaifema haviꞌya amakupi maleꞌya amametiti hu-mainaya veaꞌmoꞌya agola maige maige hisaya hamaimula ago ali-mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nagaya nagaiꞌniꞌa hamaimu amamisua maya mainoe. ");
INSERT INTO knb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ani tamakinagomoꞌya vaya omai kotega maineꞌya nago kaveꞌmo agia manae huꞌya nahaya kave ne-mainayanagi ago fali-mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Fali-mainayanagi maꞌa augafa ikapinagati elavia maya nesaya veaꞌmoꞌya ofaligahae. ");
INSERT INTO knb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nagaya Ikapinagati elavi-mainea maya mainoe. Ani mayamona haimuꞌa hane. Nagoꞌa veaꞌmoꞌya mani mayama nesayana agola maige maige hugahae. Ani maya nagaiꞌniꞌa naugafae. Ma mopaleꞌma mainaya veala agola maige maige hisaya yafe naugafa ataleteꞌna faligahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Higeꞌya Yuta vayaꞌmoya mani kehena ke vaiꞌya mage huꞌya hae “Mani kanomoꞌa hanaꞌa huno augafaꞌa taminegeta nesuna yafe nehie?” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nageno Yisasiꞌa mage hie “Nagaya tamage-lafa huꞌna tamaha-nepauve tamakayama ikapinagati emainoa kano vayaꞌmo na-tenea nafaꞌnemoni naugafaene kolaniꞌaenema onesayana maige maige hisaya tamahaimula tamakupina omalegahie. ");
INSERT INTO knb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nagoꞌa veaꞌmoꞌya naugafaene kolaniꞌaenema nesayana agola maige maige hisaya hamaimula ago ali-mainayanagiꞌna ma mopama haꞌno hisia kanafina fali-mainesafitila ali he-ti-ma-tegahue. ");
INSERT INTO knb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nagai naugafa, kave tama hane. Kolaniꞌaenena tama li hane. ");
INSERT INTO knb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nagoꞌa veaꞌmoꞌya naugafaene kolaniꞌaenema nesayana nagai nagupi mainageꞌna nagaya aniꞌa huꞌna amakai amakupina mainoe. ");
INSERT INTO knb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nenafaꞌa haimuꞌaene kanomoꞌa hu-nateneanagino nahaimula namigeꞌna mainoe. Nagoꞌa veaꞌmoꞌya nagai naugafama nesayana nagai tokiyafiti hamaimula aliteꞌya maigahae. ");
INSERT INTO knb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ikapinagati elavi-mainea maya maꞌa augafa maya hane. Yuta vayaꞌmogami amakinagomoꞌya ne-mainaya maya kana ohune. Ani maya neteꞌya ago fali-mainayanagi nagoꞌa veaꞌmoꞌya ikapinagati elavi-mainea mayama nesayana agola maige maige hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisasiꞌa mani kea Kapaneamu mono nopi huno hama-pai-mainea ke. ");
INSERT INTO knb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mukiꞌa akaveꞌma neꞌvaya veaꞌmoꞌya ani kea haviteꞌya mage huꞌya hae “Manima hu-mave-lia kemoꞌa tusiꞌa kana nelahaiye. Hana kanomo mani kea haviteno akave malesia amukoꞌa hane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hageno Yisasiꞌa ani kehena akaveꞌma neꞌvaya veaꞌmoꞌya kasagoꞌya kema haya kea ago aguꞌafinaga haviteno mage huno hie “Mani kemoꞌa otamahaifi? Natalesaya tamakesa nehavifio?” huno hamavi-nege. ");
INSERT INTO knb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nagayama, ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌna, eteꞌnama hagoteꞌna nemauva kumateꞌma visugetama nagesayana hanaꞌa hugahae? ");
INSERT INTO knb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anumaya Koti Avamuꞌmoꞌa maige maige hisaya tamahaimula nelamianagi tamakai tamaugafamoꞌa nagola kanale yana notamamie. Nagaya Anumaya Koti Avamuꞌmoꞌa naminea ke tamaha-pai-mainoe. Ani kemoꞌa maige maige hisaya tamahaimula nelamamie. ");
INSERT INTO knb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mani kea tamaha-pai-mainoanagi “Nagoꞌamogatama ani kehena tamakupina alitama nomalae.” huno nehuno nayoma aepa he-mainea kanafina Yisasiꞌa amakupi maleꞌya amametiti ohisaya veaꞌene agaiꞌama agesi huno kame ya hu-tesia kanoene ago haviline. ");
INSERT INTO knb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yisasiꞌa nagoꞌene mage hie “Ani yafe mage huꞌna tamaha-pai-mainoane nagoke veala amakaiꞌamia nagaitega omegahagi Nenafa esaya amaku amakesa amamisigeꞌya nagaitega egahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mani kema higeꞌya kasagoꞌya akaveꞌma umainaya veala eteꞌya mai-yahae huꞌya ataleꞌya umaineꞌya nagoꞌene agaiꞌenena me vai-oꞌayenae. ");
INSERT INTO knb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yisasiꞌa tuelufuꞌa (12) anagaꞌamogamife mage huno hamavi-nege “Tamakaya aniꞌa hutama nagaila natalegahao?” huno hamavi-nege. ");
INSERT INTO knb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hamavi-gegeno Saimoni Pitaꞌa kenonaꞌa mage hie “Anumayamoga hana kanomote visune? Kagai kemoꞌa maige maige hisuna tahaimula nelamie. ");
INSERT INTO knb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tagaya ago havilinone kagaya alu aotage kavaꞌage kanoa Anumaya Kotiꞌa hu-gategeka emainananagita kagaifena tagaya tagupi maleta tametitia ago hu-mainone.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Higeno Yisasiꞌa mage hie “Tamakaya tuelufuꞌa (12) anagaꞌnimogatamina nagaya ago hapali-lama-tenoamagi tamakaipina nago kanomoga Kefo Avamuꞌene mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mani kema hiana Yutasife hu-maine. Yutasiꞌa Saimoni Isakaliotina nafaꞌneꞌamoꞌe. Tuelufuꞌa (12) anagapiti Yisasina agesi huno kame ya hu-tesia kanohe hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ani kanafina Yutia kotega vayaꞌmoꞌya haesaya amakesa haviya yafe Yisasiꞌa Yutia vai-oꞌayeno Kalili kotega ute ete huno maine. ");
INSERT INTO knb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ala kana, fugagiꞌeta nopi maineꞌya imu negiya kana aupa nehie. ");
INSERT INTO knb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aupa higeꞌya Yisasina aganaꞌamoꞌya mage huꞌya hapaiye “Ma kumala neꞌataleka Yutia kotega ugeꞌya kakaveꞌma nehaya veala kagayama tokiyakaletiꞌma alina aliꞌyana ageho. ");
INSERT INTO knb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nago kanomoꞌa ‘Mukiꞌa veaꞌmoꞌya nagesae.’ huno kesi aliꞌyana noꞌalia yane. Kagaya ani tokiya aliꞌyana mukiꞌa ma mopale veaꞌmogami amaufi aligeꞌya ani aliꞌyakaꞌa ageho.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hayanagi ani aganaꞌamoꞌya agaifena haviꞌya amakupi maleꞌya amametitia ohunaya yafe ani kea hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yisasiꞌa mage hie “Aliꞌyaniꞌa amave-lisua kanaꞌniꞌa falote ohunegi tamakaya mukiꞌa kanalela tamakaiꞌma tamahaisia kavala hisaya kanatamilelagi afaꞌa haiho. ");
INSERT INTO knb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nagai ke nohaviya veaꞌmoꞌya tamakaifena musetami nehagi nagaya ‘Ase ohu kava nehae.’ huꞌna hama-pauva yateti nagaila amaipa kafa he-nenatae. ");
INSERT INTO knb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tamakaya Yelusalemu imulega viho. Nagaya aliꞌya kanaꞌniꞌa falote ohuneanagiꞌna ani yafe menia imulega oꞌugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ani kea hama-paiteno oꞌuno afaꞌa Kalili kotega maine. ");
INSERT INTO knb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aganaꞌamoꞌya imulega ago utageno Yisasiꞌa haenaga anilega hai-maine. Vaya amaulela oꞌunegi kesi fala-kino umaine. ");
INSERT INTO knb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","12","Falakino umainegeꞌya Yuta vayaꞌmoꞌya agayama imuleꞌma esiafene huꞌya moge mege hugetayana higeꞌya mage huꞌya hae “Ani kanoa hanate maine?” huꞌya hamavi-gageꞌya anifima alitalu hu-mainaya veaꞌmoꞌya Yisasifena sumi sumi huꞌya nagoꞌamoꞌya “Kanale kanoe.” huꞌya nehageꞌya nagoꞌamoꞌya “Vaya aye-mavataga hugeno omai kanoe.” nehageꞌya huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hayanagi Yuta vayaꞌmogamife koli haya yafe ani kea ala kea ohunagi osi kefiti sumi sumi huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ani imu kanamo amuꞌnopinaga Yisasiꞌa ala mono nopi haino hu-mave-li-maine. ");
INSERT INTO knb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hu-mave-neligeꞌya Yuta veaꞌmoꞌya tusiꞌa amamaꞌyo neꞌaiꞌya mage huꞌya hae “Mani kanoa hana avo nopi uno age-mainea kanomo avopitila taha-nepaiye? Avo nopina oꞌunea kanomoꞌa hanateti ani kea haviline?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hageno Yisasiꞌa kenonaꞌamia mage huno hama-paiye “Hu-mave-nelua yana nagesafiti tamaha-nopaugi nevaꞌyaꞌma hu-na-tegeꞌna emainoa kanomo naha-pai-mainea ke tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nagoꞌa veaꞌmoꞌya ‘Anumaya Kotina haisia kava hugahune.’ huꞌyama hisaya veaꞌmoꞌya ma ma hu-lamave-nelua kea nagesafiti tamaha-nepaufi Anumaya Kotiꞌa naha-pai-mainea ke tamaha-nepaufi havigahae. ");
INSERT INTO knb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Havigahayanagi nago kanomoꞌa agaiꞌa agesafiti kema hisia kanomoꞌa ‘Nagai nagi alisaga hisae.’ huno nehianagi nago kanomoꞌma ‘Nevaꞌyaꞌma hu-na-tenea kanomo agi alisaga hisae.’ huno hisia kanoa kanale agu agesaene kano mainea yafe havigea ohugahie. ");
INSERT INTO knb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moseseꞌa kahegi kea ago tamaha-pai-mainea ke tamakaitamifina nago kanomoga ani kemona akavela nomalane. Naꞌa higetama menia nagaila nahaegahena nehae?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Higeꞌya melitalu hu-mainaya veaꞌmoꞌya mage huꞌya hae “Kefo avamuꞌmo kagaila kagusafina maineno kavale-liteno nehie. Taꞌya kahaegahena nehageka nehane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hageno Yisasiꞌa mage huno hama-paiye “Nagaya nago tokiya aliꞌyama Sapati kanaleꞌma alua aliꞌyafe tamamaꞌyoa neꞌaiye. ");
INSERT INTO knb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moseseꞌa nayona ‘Nafaꞌnetamimona agoya amega augafaꞌa taga hu-taleho*.’ huno hama-pai-maine. Ani kavala agaiꞌa alino aepa ohenegi Mosesena aginagomoꞌya ani yana aliꞌya aepa he-mainae. Neꞌmoꞌma agoya anoꞌyaꞌa tagama hayana Sapati kanale taga hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tamakaya Moseseꞌma kahegi kema oꞌatagaesaya yafe Sapati kanalela neꞌmo agoya anoꞌyaꞌa taga nehayanagi naꞌa higetama nagayama Sapati kanalema nago kanoma mukiꞌa augafama aliꞌna hilatoma hua yafena tamahaiya vai-nena-tae? ");
INSERT INTO knb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Havigu ke nehae. Afaꞌa amega yate agetetama ‘Kefo kava nehane.’ hutama nehagi tama kava hisigetama agetetama kaiyekea hu-teho.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nagoꞌa Yelusalemu mainaya veaꞌmoya Yisasiꞌma hia ya ageteꞌya mage hae “Ma kanoa ala vayaꞌmoꞌyama haegahunema haya kanofi? ");
INSERT INTO knb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ageho vaya amaulagafina kea nehianagi nago yana hu noꞌatae. Kava vayaꞌmoꞌya ma kanomofe Anumaya Kotiꞌa veaꞌmogati taugafa ali-gatigahie huno hu-tegeno emainea kanoa mainea yafe havimainafi? ");
INSERT INTO knb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anumaya Kotiꞌa taugafama ali-gatigahema hu-tegeno emainea kanomofena ‘Hana kumateti emaine?’ huꞌya hugahayanagi ma kanoma ea kumala ago age-mainone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hageno Yisasiꞌa ala mono nopi haino maineno hu-mave-nelino ala kefiti mage huno hie “Tamakaya nagaifena ago havilama hutama nage-mainafi? Nagayama emainoa kumaꞌenefe havimainafi? Nagaya nagaiꞌni nagesafiti omenogi nagaiꞌma hu-natenea kanomoꞌa tokiyaꞌage kano maineanagitama tamakaya agaila oꞌagenae. ");
INSERT INTO knb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Oꞌagenayanagi nagaya agaiꞌene mainoleti hu-nategeꞌna emainoafenagiꞌna ago age-mainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Higeꞌya agaila atafa hugahe hayanagi falisia kanaꞌa yaufa falote ohunea yafe augafalela nago kanomoꞌa atafa ohune. ");
INSERT INTO knb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ohunayanagi mukiꞌa anifima mainaya veaꞌmoꞌya agaifena haviꞌya amakupi maleꞌya mage hae “Anumaya Kotiꞌma taugafa ali-gatigahema hu-tenea kanoma esiana ma mainea kanomoꞌma tokiya avame yama hu-mainea kavala agasesifi? Aꞌao oꞌagasegahie. Ma kanoa Anumaya Kotiꞌma taugafa ali-gatigahema hu-tegeno emainea kano maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nehageꞌya Falasia vayaꞌmoꞌya agaifema sumi sumiꞌma haya kea haviteꞌya mono note kava vayaꞌene Falasia vayaꞌene ati vayaꞌmogamina hu-ma-tageꞌya Yisasina me haesaya malesaya kava huꞌya avalegahe neꞌae. ");
INSERT INTO knb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Neꞌageno Yisasiꞌa mage huno hie “Osi kana kanoꞌa tamakaiꞌenena maiteꞌna hu-nategeꞌna emainoa kanolega ugahue. ");
INSERT INTO knb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tamakaya nagaifena natiyegahayanagi nagaila onagegahae. Visua kumatela tamakaya oꞌugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Higeꞌya Yuta vayaꞌmoꞌya amakaiꞌamifi huge havige huꞌya mage hae “Agayama ‘Nagaila onagegahaema.’ hia kumala hanamaꞌalegafiga hanegeno nehie? Agaya Kaliki kotega Yuta vayaꞌmogatina tataleꞌya umainaya kotega umaineno Kaliki vea hu-mave-li hamaveli hugahe nehifi? ");
INSERT INTO knb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Agayama hia kea ‘Tamakaya nagaila natiyegetesayana onagegahae. Visua kumatela oꞌugahae.’ hunoꞌma hia kemo aepaꞌa naꞌane huno nehie?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Imu kime haiꞌya mogi haꞌnoma haya kana tusiꞌa ala kanae. Ani kanale Yisasiꞌa he-tino ala kefiti mage hu-maine “Nagoꞌa veaꞌma tifema amakesia veala nagaite eꞌya tina me neho. ");
INSERT INTO knb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nagoꞌa veaꞌmoꞌya nagaife haviꞌya amakupi maleꞌya amametitia hisayana Anumaya Koti autaꞌmafina ani veaꞌmofe mage hu-maineane ‘Ofali tina kasagoꞌya timo aguꞌafina hava-te-maineno vali-lavino tavigahie.’ huno hu-maineane.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisasiꞌa anima hia kea “Alu Aotage Avamuꞌamofe hu-maine.” Ani Alu Aotage Avamula Yisasifema haviꞌya amakupi malesaya vaya amamite amamite hugahe nehie. Ani kema hia kanafina Yisasiꞌa yaufa ikapinaga ohainea yafe Alu Aotage Avamuꞌamoꞌa yaufa omenegeno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nagoꞌa alitalu hu-mainaya veaꞌmoya ani kea haviteꞌya mage hae “Tamage-lafa huno mani kanoa Anumaya Koti aune kano emaine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hageꞌya nagoꞌa veaꞌmoꞌya “Anumaya Kotiꞌa taugafa ali-gatigahe hu-tenea kano maine.” nehageꞌya nagoꞌa veaꞌmoꞌya “Anumaya Kotiꞌa taugafa ali-gatigahe hu-tenea kanomoꞌa Kalilitila falote ohugahie. ");
INSERT INTO knb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anumaya Koti autaꞌmafina mage huno kae-maleneane ‘Anumaya Kotiꞌa taugafa ali-gatigahema hu-tenea kanoa Tevitina aginagomo egahie. Tevitiꞌma Petelehemu nemaiya kumate ategahie.’ huno kae-maleneane.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ani veaꞌmoꞌya agaifena tolefi ali fako huꞌya alu ke alu ke nehae. ");
INSERT INTO knb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hageꞌya nagoꞌamoꞌya “Agaila atafa hiho.” huꞌya hayanagi nago kanomoꞌa augafalela atafa ohune. ");
INSERT INTO knb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ati vayala eteꞌya mono note kava vayateꞌene Falasia vayateꞌene vageꞌya mage huꞌya hamavigae “Naꞌa higetama avaletama nomae?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hageꞌya ati vayaꞌmoꞌya mage huꞌya hae “Yisasiꞌma hia kea nayona nago kanoꞌmoꞌa aniꞌa augafa kea ohigeta ohavinona yafe avaleta nomone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Hageꞌya Falasia vayaꞌmoꞌya mage hae “Tamakaiꞌenena ago aye-lamavataga hu-mainefi? ");
INSERT INTO knb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ifi nagoꞌa kava vayapi Falasia vayapi ‘Yisasifena haviꞌya amakupi maleꞌya amameti hu-mainae.’ huꞌya haya kea havimainafi? ");
INSERT INTO knb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aꞌao kava vayala aniꞌa ohunagi kahegi kema ohaviꞌyama alitaluma hu nemaiya veaꞌmogamina Anumaya Kotiꞌa hai vai-ma-teno haniki-mainesia yapina hu-mategahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Hageno Nikotimasiꞌa nayoma Yisasiteꞌma emainea kanomoꞌa amakaipi maineanagino mage hie “Tagai mono kemoꞌa mage huno hie ‘Hagotetama nofiꞌma hu-tesaya kanomona ‘Naꞌa maꞌa humainoe.’ huno hisia kea havitetama kefo kavaꞌma hu-mainesia kanomona nofila huteho.’ huno hu-maineane.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nehigeꞌya “Kagaya kagaiꞌenena Kaliliti kano mainapi? Anumaya Koti ke kae-malenaya kefina hapalika havilama huteka kagaiꞌenena havio Kaliliti nagola aune kano omegahie.” huno hu-maineane huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nehageꞌya mukiꞌa veaꞌmoꞌya atagu-feꞌya ataleꞌya kumaꞌamilega ute ete hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mukiꞌa veaꞌmoꞌya kumaꞌamilega ute ete hageno Yisasiꞌa Olivi yosa hanea agoꞌyafi hai-maine. ");
INSERT INTO knb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kegeꞌafiti Yisasiꞌa he-tino ala mono nopi umainegeꞌya veaꞌmoꞌya melitalu hageno Yisasiꞌa mopale maineno mono kea hama-nepaiye. ");
INSERT INTO knb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hama-nepaigeꞌya kahegi kema havilinaya anagaꞌene Falasia vayaꞌene nago ala alu vene moli nehigeꞌya ageteꞌya avaleꞌya alitalu hu-mainaya veaꞌmogami amaufi me he-ti-tenae. ");
INSERT INTO knb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Me he-ti-teteꞌya Yisasife mage huꞌya nehae “Hu-maveli kanomoga ma aꞌmoꞌa alu vene moli nehigeta ageteta avaleta neꞌone. ");
INSERT INTO knb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moseseꞌma kahegi kema taminea kemoꞌa maꞌa hu-maine ‘Ani kavaꞌma hisia aꞌmona yafateti haetama he-vai-teho.’ huno hu-mainegi ‘Kagaya naꞌane huka nehane?’ huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Agaifema mani kema hayana aye-vataga huꞌya nagoꞌa havige hisigeta atafa huta kaiyeke hu-tegahune.” huꞌya hayanagi Yisasiꞌa ape huno mopafi maineno aginagoleti avo negae. ");
INSERT INTO knb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Avo negaegeꞌya anileꞌma he-tiꞌya maineꞌya mani kema havige havigema haya vayafe Yisasiꞌa he-tino mage hie “Tamakaipitiꞌma nago osi kefo yakaꞌa omalenesia kanomoga hagoteka yafana hagaꞌyu huka mani aꞌmo augafalela aiko-lio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mage huteno eteno ape huno mopafi avo negae. ");
INSERT INTO knb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mani kema higeꞌya mukiꞌa atagu-feꞌya ute ete hageꞌya hagoteꞌya vayatamamoꞌya ataleꞌya vageꞌya haenaga mukiꞌamoꞌya ataleꞌya ute ete hageno Yisasiꞌa ape huno mainegeno ani aꞌmoꞌa aule he-tino maine. ");
INSERT INTO knb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mainegeno Yisasiꞌa he-tino ani aꞌmofena mage huno hie “Ma aꞌmogae mani vayala hanatega vae? Nago kanomoꞌa kagaila kaiyekema hu-gatesia kanoa omainefio?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Higeno mani aꞌmoꞌa mage hie “Aꞌao, ala kanomogae, nago kanoa omaine.” huno higeno Yisasiꞌa mage hie “Nagaya nagaiꞌenena kaiyekea hu okategahugi afaꞌa ugananagi eteka nagoꞌene kefo yana ohuo.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Haenagaꞌa Yisasiꞌa mono nopi alitalu hu-mainaya vayaꞌyagahe mage hu-maine “Nagaya ma mopafi veala aye hale-ma-tesua kano mainoe. Nagai nakaveꞌma malesaya veaꞌmogatama maige maige tamahaimula hanea hale yana alitetama haniki yapina ute ete ohugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Higeꞌya Falasia vayaꞌmoꞌya Yisasifena mage huꞌya hae “Kagaya kagaikaꞌa kehe hu-falote nehananagi kekahena havita tametiti ohugahune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hageno Yisasiꞌa mage huno hie “Tamage nagaya nagaiꞌniꞌahe kea nehuanagi hua kehena havitama tamameti hiho. Naꞌafene nagaya aepama heꞌnama emainoa kumaꞌene visua kaꞌene age-mainoanagitama tamakaya nagayama emainoa kumaꞌene visua kaꞌene oꞌagenae. ");
INSERT INTO knb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tamakaya ma mopafi veaꞌmogamina no maiyateti fako nehayanagi nagaya nago kanomo no maiyana fako nohue. ");
INSERT INTO knb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fako nohuanagi nagaya nago kanomoma fako hu neꞌa-tesugenofena kema hua kelela havitama tamameti hiho. Nagaya nagaiꞌnige fako nohuanagi hu-natenea Nenafaꞌa nagaiꞌene tole huno aliꞌyana neꞌalino fako nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tamakai mono kemoꞌa mage huno nehie ‘Tole kanolatamoganima keꞌanimoꞌma nagoke kateꞌma visiana keꞌanimoꞌa tamage hugaꞌe.’ hutama nehayane. ");
INSERT INTO knb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nagaya nagaiꞌniꞌahena kea hu-falote huꞌna nehugeno nagaiꞌma hu-nategeꞌna emainoa Nenafaꞌa nagaifena aniꞌa huno hu-falote nehie.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Higeꞌya haviteꞌya Falasia vayaꞌmoꞌya mage huꞌya havigae “Negafaꞌema hana kanoa hanate maine?” huꞌya havigageno Yisasiꞌa mage hie “Tamakaya nagaiꞌma onagenayana Nenafana aniꞌa hutama oꞌagenae. Nagaiꞌma nage-mainaleꞌasipa Nenafana aniꞌa hutama age-mainaleꞌasine.” ");
INSERT INTO knb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisasiꞌa mani kea ala mono nopina muse yama nemalaya kaiyaga maineno mani kea hu-mave-lianagi agayama falisia kanaꞌamoꞌa aupa ohunea yafe nago kanomoꞌa agaila atafa ohune. ");
INSERT INTO knb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yisasiꞌa eteno nagoꞌene mage hu-maine “Nagaya ago visugetama nagaifena natiyegahayanagi tamakaitami kefo yatamia oꞌataletama hanesigetama faligahae. Nagayama visua katela tamakaya oꞌugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Higeꞌya Yuta vayaꞌmoꞌya amakaiꞌamifina mage huꞌya hae “Nagayama visua katela tamakaya oꞌugahae hunoꞌma hia kemona aepaꞌa agaiꞌa augafa hae-faligahe nehifi?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hageno Yisasiꞌa mage huno hie “Tamakaya afetegati emainayanagi nagaya anafinagati emainoe. Tamakaya ma mopafiti emainayanagi nagaya ma mopafiti omenoe. ");
INSERT INTO knb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Naꞌafene nagaya tamakaila ago tamaha-pai-mainoe ‘Tamakaitami kefo yatamia oꞌatalesageno hanesigetama faligahae.’ huꞌna hu-mainoane. Tamakaifema nagaya ‘Maꞌa kano mainoe.’ huꞌna hu-mainoa kehe havitama tamakupi maletama tamametitima ohisayana kefo yatamia oꞌataletama hanesigetama faligahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Higeꞌya “Kagaya tagae?” huꞌya havigageno Yisasiꞌa mage hie “Nagaya laꞌnae huꞌna tamakaila hagoteꞌna tamaha-pai-mainoane. ");
INSERT INTO knb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tamakaifema kasagoꞌya kema, hu-lamateꞌna fako hisua kea hane. Nagaiꞌma hu-na-tegeꞌnama emainoa kanomoꞌa tamage keꞌage kano mainegeꞌna agaitegati nagaya havimainoa ke ma mopafi veaꞌmogatamina tamaha-nepauve.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ani kea Nefafema nehigeꞌyagi amakaya haviꞌya aepaliꞌya ohavinae. ");
INSERT INTO knb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ohavinaya yafe Yisasiꞌa mage hie “Tamakayama ikapinagati emainoa kanoa vayaꞌmo natenea kanomoꞌnina yafaga yosale alisagama hisaya kanafina tamakaya nagayama ‘Ani kano mainoe.’ huꞌna hu-mainoa yafe havilama hutama havigahae. Nagaya nagaiꞌni nagesafitila nago yana nohue. Aꞌao nagaila Nenafama hu-mainea keꞌage nehugetama nehavie. ");
INSERT INTO knb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nagaiꞌma hu-natenegeꞌna emainoa Nenafaꞌa nagaiꞌene maineno mukiꞌa kanalela agayama museꞌma hia kavaꞌma huafenagino nagaila nonatale.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Higeꞌya kasagoꞌya veaꞌmoꞌya Yisasiꞌma hia ke haviteꞌya amakupi maleꞌya amametiti nehae. ");
INSERT INTO knb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yisasiꞌa amakupima maleꞌya amametitima haya Yuta vayafena mage hie “Tamakaya nagai kema mukiꞌa kanafima akaveꞌma malesayana nagai ke havisaya anagaꞌniꞌa maigahae. ");
INSERT INTO knb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nagayama tamagema hua kema havilama hutama havisagenoꞌa ani ke-lamagemoꞌa tamakaila kanama lamahaiya yamoꞌa nofi hu-lama-tenaya yana haꞌno hisigetama afa vea maigahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Higeꞌya kenonaꞌa mage hae “Tagaya Apalahamu nofi vaya mainona yafe nagoꞌa vayaꞌmoꞌya nofila hu-la-tageta miya oꞌali aliꞌyana oꞌalinone. Naꞌa higeka tagaifena nofila hu-lama-tagetama miya oꞌali aliꞌyapi mainaya vea ali haꞌno hisugetama afa vaya kana hutama maigahae huka nehane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hageno Yisasiꞌa kenonaꞌamia mage hie “Tamage-lafa huꞌna tamaha-nepauve mukiꞌa veaꞌma kefo kavaꞌma taloma hisayana kefo yaꞌamimoꞌa nofi hu-ma-tegeꞌya miya oꞌali aliꞌya veaꞌne kana huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nagi miya oꞌali aliꞌya veala nagoꞌa afamopina agola omaigahayanagi atenea nafaꞌneꞌamoꞌa agola ani afamopi maigahie. ");
INSERT INTO knb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anumaya Koti Nafaꞌnemoꞌa kefo yatamimoꞌma tamatafa hu-mainea nofila alino lagama hu-taleana tamage huno ago alino laga hu-talegetama kanale hutama mainae. ");
INSERT INTO knb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nagaya ago havimainoe tamakaya Apalahamu nofi vaya mainayanagi nagai kemoꞌa tamakupina omalenea yafe nagaila nahaegahena nehae. ");
INSERT INTO knb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nagayama nehuana Nenafaꞌma nave-li-mainea yaꞌyagahe nehuanagi tamakaya tamakaitami nelamafa tamaha-pai-mainea kava nehae.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yisasiꞌa higeꞌya Yuta vayaꞌmoꞌya haviteꞌya mage hae “Nelafaꞌa Apalahamu maine.” huꞌya hageno Yisasiꞌa mage hie “Tamagema tamakaya Apalahamu nafaꞌneyagama mainaleꞌasina agayama nehia kavala talo haleꞌasine. ");
INSERT INTO knb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Talo haleꞌasinagi menia nagaya tamage kema Nenafategati havimainoa ke tamaha-pauva kanomonia naꞌa higetama nagaila nahaegahena nehae. Apalahamuꞌa naꞌa kavala ohunea yane. ");
INSERT INTO knb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tamakaya nelamafa nehia kava nehae.” huno higeꞌya “Itatimoꞌa moli hu-liteno huno otateneane. Tagaila Anumaya Kotiꞌa agaiꞌage nagoke nelafa maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hageno Yisasiꞌa mage hie “Tamagema Anumaya Kotiꞌa nelamafaꞌma maineleꞌasina nagaya Anumaya Kotitegati emainoa yafe nagaifena tamahaileꞌasine. Nagaiꞌniꞌa nagesafitila omenogi Anumaya Kotiꞌa agaiꞌa hu-na-tegeꞌna emainoe. ");
INSERT INTO knb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Naꞌa higetama kema hua kea havilama hutama nohaviye? Mani kemona aepaꞌamoꞌa maꞌa hu-maine tamakaya havisaya tokiyatamia omaleanegitama nagai kea ohavigahae. ");
INSERT INTO knb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tamakaila Sataniꞌa lama-tenea nelamafa agu agesa tokiyaꞌage hutama nelamafa akave nemalae. Aepama he-mainelegati vaya hamaeno fali-ma-tegeno omai kanoe. Ani kanomo agupina tamage kemoꞌa omalenegeno havigema hiana mukiꞌa kanale nehia kava nehie. Ani kanoa havigeꞌage kanoe. Mukiꞌa havigema hu yana Sataniꞌa agaiꞌafiti havigeꞌage kemona aepaꞌa maine. ");
INSERT INTO knb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nagaya lamakaifena tamageꞌage ke nehua yafe havilama hutama tamakupi maletama tamametitia nohae. ");
INSERT INTO knb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hana veaꞌmoga nageteka nagaifena ‘Kefo yakaꞌa hane.’ huka fako hu-nena-teka hu-falote hunategane? Aꞌao, aniꞌa ohugahae. Nagaya lamageꞌage kea huꞌna tamaha-nepauvanagi naꞌa higetama nagaifena tamakupina havi nomalae? ");
INSERT INTO knb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nagoꞌa veala Anumaya Koti nafaꞌneyaga maineꞌya Anumaya Koti kea nehaviyanagi tamakaya Anumaya Koti nafaꞌneyaga omainaya yafe nagai kea nohaviye.” ");
INSERT INTO knb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuta vayaꞌmoꞌya kenonaꞌa Yisasifena mage huꞌya hae “Tagaya kagaifena tamage nehune ‘Samelia kano mainane. Kefo Avamuꞌmoꞌa kagupina tamage maine.’ huta nehune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hageno Yisasiꞌa mage hie “Nagaipina Kefo Avamula omaine. Aꞌao nagaya Nenafa agi alisaga nehugetama lamakaya nagai nagia alitama afepinaga nemalae. ");
INSERT INTO knb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nagaya nagia alisaga nohuanagi nagoke kanomoꞌa nagai nagia alisaga hisia kano maine. Ani kanoa, Anumaya Kotiꞌe, kaiyekea hu-ma-tesia kano maine. ");
INSERT INTO knb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tamage-lafa huꞌna lamaha-pauve nagai kema akaveꞌma malesamoꞌya ofaligahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Higeꞌya Yuta vayaꞌmoꞌya mage hae “Ani kema hana yafena tagayama havunana kagaikaꞌa kagupi Kefo Avamula maine. Apalahamuꞌene nayona mainaya Anumaya Koti amaune vayaꞌmoꞌya fali-mainagi kagaya ‘Nagai ke akave malesamoꞌya ofaligahae.’ huka nehano? ");
INSERT INTO knb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Apalahamuꞌa taginagomona ‘Agase-mainoa kano mainoe.’ huka nehano? Apalahamuꞌa faligeꞌya Anumaya Koti aune vayala ago fali-mainae. Kagaya hanaꞌa augafa kano mainoe huka nehane?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hageno Yisasiꞌa mage hie “Nagaya nagima alisaga hisuana afa ya kana hugahianagi Nenafa tamakaya ‘Anumaya Kotitimo maine.’ hutama nehaya kanomoꞌa nagai nagia alisaga nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Alisaga nehianagi tamakaya agaila oꞌagetafa hu-mainae. Nagaya agaila ago age-mainogi ‘Agaiꞌma oꞌagenoe.’ huleꞌasina tamakai kana huꞌna havigeꞌage kano mauleꞌasinagi nagaya ago agaila age-mainoanagiꞌna agai kea akave nemaloe. ");
INSERT INTO knb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Apalahamuꞌa tamakinagomoꞌe nagayama ma mopaleꞌma falote hisua kanahe agesia yafena musena hu-maineanagi agetenoꞌa tusiꞌa muse hu-maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Higeꞌya Yuta vayaꞌmoꞌya kenonaꞌa mage hae “Kagaya fifitiꞌa (50) kafua ohunanagi kagaya vayatama omainane. Apalahamuna age-mainano?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hageno Yisasiꞌa mage hie “Tamage-lafa huꞌna tamaha-nepauve Apalahamuna oꞌatenele nagaya hagoteꞌna monafinaga mainoane.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ani kema hia yafe yafa kaꞌyoteti aliꞌya aiko-ligahe nehageno Yisasiꞌa fala-kino amataleno ala mono no kategati hati-lavino umaine. ");
INSERT INTO knb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisasiꞌa katega neꞌuno nago kanoa atenea kanalegati aulaga asu humai kano moge-maine. ");
INSERT INTO knb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mo neꞌagegeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage huꞌya havige-mainae “Hula-ve-nelina kanomoga ta hia kefo yamo alino aulaga asu hu-maine akaiꞌafi itaꞌafoꞌamoꞌa kefo ya haꞌa yamo aulagamoꞌa asu hu-mainefi?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Havigageno Yisasiꞌa mage hie “Mani kanomo itaꞌafoꞌamoꞌa akaiꞌaene kefo yama hia yamo alino aulaga asu ohunegi Anumaya Kotiꞌa tokiya yamaꞌa alino kanale hu-tesigeꞌya mukiꞌa veaꞌmoꞌya agesaya yafe aulagamoꞌa asu hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Menima yagema hanesiamaꞌaene hu-natenea kanomo aliꞌyana alige alige huta maisune. Hanima kisiana nago kanomoꞌa aliꞌyana oꞌaligahie. ");
INSERT INTO knb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Menima ma mopaleꞌma mainoa-maꞌahena nagaya ma mopafina kaꞌni aye-halesua kano mainoe.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mani kea huno nehuno avetuꞌna mopafi heteno mopaene ayegakalifeno aulagama asu hu-mainea kanomo aulagale malegaꞌmaetene. ");
INSERT INTO knb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Malegaꞌmaeteteno mage huno hapaiye “Kagaya Siloamu ti kotute mo sese huo. Ani li kotumo agia tagai kefina ‘Hu-tene.’ huꞌya nehae. Ani li kotute kaugosa mo sese huteka eteka eno.” huno higeno mo seseꞌma hiana aulagamoꞌa kanale higeno neꞌageno nomaꞌalega emaine. ");
INSERT INTO knb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nomaꞌalega egeꞌya agaiꞌa kumate vayaꞌene nayoma mani kanomoꞌa monehema aukaꞌya nehigeꞌya neꞌagaya veaꞌmoꞌyaene mage huꞌya hu-mainae “Ma kanoa nayoma felu maineno monehema aukaꞌya nehia kanofi alu kanoe?” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nehageꞌya nagoꞌa veaꞌmoꞌya “Ani kanoe.” nehageꞌya nagoꞌa veaꞌmoꞌya “Alu kanogi vuohe ani augafa kanomo nehigi.” huꞌya hageno agaiꞌa nehuno “Nagaya mani kano mainoe.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nehigeꞌya mukiꞌa veaꞌmoꞌya havige-mainae “Hanaꞌa hanageno kaulagamoꞌa kanale hu-maine?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Havigageno mage hie “Nago kanoa, Yisasiꞌe kanomoꞌa, hapa talo huteno alino naulagale maleteno ‘Siloamu ti kotutega kaugosa mo sese huo.’ huno higeꞌna naugosa mo sese huteꞌna agoana aupaꞌa naulaga age-mainoe.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Higeꞌya veaꞌmoꞌya “Ani kanoa hanate maine?” huꞌya hageno “Nagaya oꞌagenoe.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aulagama asu hu-mainea kanomona Falasia vayatega avaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yisasiꞌa hapama ali gakalifeteno ani kanomo aulagama alino kanaleꞌma hu-teneana Sapati kanae. ");
INSERT INTO knb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Falasia vayaꞌmoꞌya nagoꞌene mage huꞌya havigae “Hanaꞌa hanageno kaulagamoꞌa kanale hu-maine?” huꞌya hageno “Hapa ali gaꞌmaeno naulagale malegeꞌna mo sese hugeno naulagamoꞌa kanale higeꞌna age-mainoe.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Higeꞌya nagoꞌa Falasia vayaꞌmoꞌya mage hae “Ani kavaꞌma hia kanoa Sapati kanamona akave omalea yafe Anumaya Kotiꞌa ani kanoa hu-tegeno omene.” huꞌya nehageꞌya nagoꞌa vayaꞌmoꞌya mage hae “Kefo yamaꞌa hanesia kanomoꞌa ani tokiya avame yana talo ohileꞌasine.” huꞌya nehageꞌya huteꞌya tolefi ali fako hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Naꞌa huteꞌya aulagama asu hu-mainea kanoa eteꞌya havige-mainae “Ani kanoma kaulagama alino lamama hu-gatea kanohena naꞌane hu-mainane?” huꞌya hageno mage hie “Anumaya Koti aune kanoe.” nehie. ");
INSERT INTO knb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Higeꞌya Yuta vayaꞌmoꞌya “Mani kanoa aulagamoꞌa asu hu-maineanagi menia aulaga ago agegali hu-maine.” huꞌyama haya kehena “Havige nehae.” huꞌya haviꞌya amakupina maleꞌya amametitia ohuꞌya aulagama asu hu-mainea kanomona itaꞌafoꞌamoganifeꞌene ke hageꞌya emainaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Aꞌageꞌya itaꞌafoꞌamoganife mage huꞌya hana-vigae “Mani kanoa atenaꞌa kanafi aulagamoꞌa asu hu-mainea nafaꞌnetani maineano? Naꞌa higeno menia aulaga neꞌage?” huꞌya hana-vigae. ");
INSERT INTO knb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","21","Hanavi-gageꞌana itaꞌafoꞌamogania mage haꞌe “Taꞌagai nafaꞌne maineanagitaꞌa taꞌagaya ago age-mainoꞌe. Aulagama asu hu-mainea nafaꞌnema atenoꞌamaꞌa ago age-mainoꞌanagi aulagama age-maineamaꞌa oꞌagenoꞌe. Tapiga aulaga alino kali hu-teneafe tamakaya agai havigeho. Alopa ve maineanagino agaiꞌa tamaha-paigahie.” huꞌana nehaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Itaꞌafoꞌamogania Yuta vayafe koli huꞌana mani kea hu-mainaꞌe. Yuta vayaꞌmoꞌya kea hu-lokiya vaiꞌya mage hu-mainae “Nagoꞌa veaꞌmoꞌya ‘Yisasina Anumaya Kotiꞌa taugafa ali-gatigahema hu-tenea kanoa ma maine.’ huꞌya hisaya veaꞌmogamina agola mono nopitila amati-talegahune.” huꞌya hu-mainaya kehe koli nehuꞌana “Agaya alopa ve mainegi agai havigeho.” huꞌana hu-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nagoꞌene eteꞌya aulagama asu hu-mainea kanohe ke hageno egeꞌya mage hu-mainae “Kagaya Anumaya Koti aufi tamage-lafa huka kea huo. Tagaya agonana ani kanoa kefo kavaꞌage nehia kanoe.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hageno kenonaꞌamia mage huno hie “Nagaya oꞌagenogi agaya kefo kava nehia nepi nohia nepi oꞌagenogi nagokeꞌya kanoꞌama agoana hagotenoꞌa naulagamoꞌa asu humaineanagi menia naulaga agegali nehue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Higeꞌya mage huꞌya havigae “Naꞌa hu-ga-tene? Hanaꞌa huno kaulaga alino kali hu-ga-tene?” huꞌya havige-mainae. ");
INSERT INTO knb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Havigageno “Nagaya agoꞌma tamaha-nepauvana tamakaya keꞌniꞌa nohaviye. Naꞌa higetama etetama nahavi-negae? Tamakaiꞌenena agaiꞌaene tokaeꞌya nemaiya anagaꞌmogamipi maigahe nehao?” huno havige-maine. ");
INSERT INTO knb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Higeꞌya amakaya huꞌya akaya ateꞌya mage hae “Kagaikage Yisasienema tokaeka nemaina kanoa mainanagi tagaya Mosese kema nehavuna vayala anale haita mainone. ");
INSERT INTO knb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tagaya ago havimainone Anumaya Kotiꞌa Mosesena kea hapai-maineanagi ma kanomoꞌa hanategati emainenoꞌe tagaya agaila noꞌagonane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hageno aulagama asu hu-mainea kanomoꞌa mage hie “Avo namaꞌyo neꞌaiye. Tamakaya alu kegefa nehae. Tamakaya hanategatipiga emainea ke ohavinayanagi naulagama alino kali hu-na-tenea kano afa kanoa omaine. Anumaya Kotitegati emaine. ");
INSERT INTO knb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tagaya ago havimainone Anumaya Kotiꞌa kefo kava nehaya veaꞌmogami kea nohavie. Nagoꞌa veaꞌmoꞌya Anumaya Koti agi alisaga nehuꞌya agaiꞌma haiya kavaꞌma hisaya veaꞌmogami kea Anumaya Kotiꞌa havigahie. ");
INSERT INTO knb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Eheꞌma fusa kanafima ma mopama taloma hu-malenelegatiꞌma emaineana nago atenea kanalegati aulaga asu hu-mainea kanoa alino kali hu-tene huꞌya haya kea ohavinonane. ");
INSERT INTO knb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anumaya Kotiꞌma mani kanoma hu-tegenoꞌma omeneleꞌasina nago yana agaya ohisine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Higeꞌya kenonaꞌa mage hu-mainae “Kagaya kefo yapiti falote huka emainananagika tagaila menia hu-lave-ligahe nehano?” huꞌya nehuꞌya mono nopitila avaleꞌya kumatega hagaꞌyu hu-talenae. ");
INSERT INTO knb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yisasiꞌa mono nopitiꞌma anati-talaya kea haviteno ani kanoa atiyeno mogeteno mage hie “Kagaya ikapinagati emainea kanoa vayaꞌmo atenea kanomofena havika kagupi maleka kametitia nehano?” huno havige. ");
INSERT INTO knb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Havigegeno ani kanomoꞌa mage hie “Ani kanoa taꞌe? huka nehapi? Nagaila naha-paigeꞌna haviꞌna nagupi maleꞌna nametiti hano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Higeno Yisasiꞌa kenonaꞌa mage hie “Kagaya agaila ago neꞌagane. Ani kanoa menima kagaiꞌenema maineno kea kea nehaꞌane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Higeno ani kanomoꞌa mage huno hie “Ayeꞌnio Alamogae menia kagaifena haviꞌna nagupi maleꞌna nametiti nehue.” huno muse nehuno aiyafi aleꞌya aye-maineno Yisasi aiyale ali-soso nehuno agi alisaga nehie. ");
INSERT INTO knb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yisasiꞌa mage hie “Nagaya ma mopale veaꞌmogami fako hu-ma-tesua yafe emainoe. Ali fako hisugeꞌya amaulaga asu humai veaꞌmoꞌya amaulaga agesageno amaulagama hanea veaꞌmoꞌya amaulagama asu hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Higeꞌya nagoꞌa avate maiya Falasia vayaꞌmoꞌya anima hia kea nehaviꞌya agaifena mage huꞌya havigae “Tagaifena tamaulaga asu hu-maine huka nehano?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Havigageno Yisasiꞌa mage huno hie “Tamaulagamoꞌa asuma hu-mainesina kefo yatamia omalesinagi tamakaya ‘Taulagamoꞌa kali kali hu-maine.’ hutama haya yafe kefo yatamimoꞌa hane.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisasiꞌa mage huno hie “Nagaya tamage-lafa huꞌna tamaha-nepauve nagoꞌa vayaꞌmoꞌya sipi sipi kegiꞌyamo fiatetiꞌma hai ofaleꞌya afalegatiꞌma asaga hu-maiꞌya hai falesaya vayala musufa vaya mainae. ");
INSERT INTO knb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nago kanomoꞌma fiatetiꞌma hai nefalea kanoa sipi sipileꞌma kava neꞌyagaiya kano maine. ");
INSERT INTO knb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Fiateꞌma yagai-mainea kanomoꞌa ani kanoa ageteno yaki-tegeno fiateti hai falegeꞌya sipi sipiyagamoꞌya alenaga agea havimainaya yafe agaiꞌa sipi sipimogamina amakia hanete hanete hu-maineanagino amakia ayete ayete huno amavaleno kumatega neꞌvie. ");
INSERT INTO knb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Amavalenoꞌma kumatega neꞌunofena uhagoteno neꞌvigeꞌya ani kanomona alenaga agema havimainaleti lagiꞌya ani sipi sipimoꞌya akave neꞌvae. ");
INSERT INTO knb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nagi oꞌagenaya vayaꞌmogami amakavela oꞌugahae. Nagi ani kanomona alenaga agema ohavinaya yafe faleꞌya alulega ugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisasiꞌa mani avame kea hama-paiyanagi amakaya havilama huꞌya ohavinae. ");
INSERT INTO knb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ohaviyanagi Yisasiꞌa nagoꞌene eteno mage hu-maine “Tamage-lafa huꞌna tamaha-nepauve nagaya sipi sipimoꞌyama hai falesaya fiana nagaiꞌnige mainoe. ");
INSERT INTO knb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mainoanagi hagoteꞌyama emainaya vayala vayaꞌma nehamaeꞌya musufa yama nehaya vayalagiꞌya sipi sipiyagamoꞌya kema haya kea ohavinae. ");
INSERT INTO knb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma nagaya fia mainoe. Mainoanagitama nagoꞌa veaꞌmogatama etama nagaipi ehai falesageꞌna tamaku tamamena ali-gatisugetama hai faletama mainetama elavitetama haitetama nehutama nesaya yana aligahae. ");
INSERT INTO knb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Musufa kanomoꞌa musufa yana nehuno veala nehamaeno ali haviya hu-ma-tegahe neꞌeanagi nagaya kanaleꞌnale tamahaimu tamamigahe emainoe. Agola haꞌno ohu tamahaimula tamamigahe emainoe. ");
INSERT INTO knb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nagaya kanaleꞌnale sipi sipi kava kano maineꞌna sipi sipiꞌniꞌamogamina amaku amamemaꞌa ali-gatisua yafe faligahue. ");
INSERT INTO knb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nago kanomoꞌa yagaiteno mone neꞌalia kanoa sipi sipimona nefaꞌa omaine. Omaigeno afela kalamoꞌma egenoꞌa ani kanomoꞌa ataleno falegeno ani afela kalamoꞌa sipi sipimogamina akafu amanino mo hamae me hamae higeꞌya faleꞌya atagufeꞌya alulega ute ete nehae. ");
INSERT INTO knb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ani sipi sipileꞌma yagaino maineno monema neꞌalia kanomoꞌa sipi sipiyagahena agesa ohavino amataleno faleno umaine. ");
INSERT INTO knb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nagaya kanale sipi sipi kava kano mainoe. Nenafaꞌa aguꞌa namigeꞌna nagaya naguꞌa amugetaꞌa nehuꞌe. Naꞌa hu-mainoꞌa kava huꞌna sipi sipiyagaꞌnimoꞌya amakuꞌa namigeꞌna nagaya naguꞌa neꞌamamue. Nagaya sipi sipiꞌniꞌamogami amaku amamemaꞌa ali-gatisua yafe faligahue. ");
INSERT INTO knb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nagoꞌa sipi sipiyagaꞌniꞌa amahaote mainae. Mani sipi sipi kegiꞌyaꞌnifina omainayanagi ani afuyaga amavaleꞌnama esuana alenaga nage nehaviꞌya nagokeꞌage afuyakama maisayana nagokeꞌmoꞌna ani sipi sipiyagalela kava kano maigahue. ");
INSERT INTO knb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nagaya ‘Afaꞌa faligahue.’ huꞌna hua kehena Nenafaꞌa tusiya huno hau ayamopafi nehaiye. Naꞌafene? Nahaimula atalesugeno eteno namisigeꞌna he-tisuaꞌyafe nahaimula afaꞌa atalegahue. ");
INSERT INTO knb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nagoꞌa vayamoꞌya nahaimula naha-ofalegahae. Nagaya nagaiꞌniꞌage nahaimula atalegahue. Nahaimuꞌma atalesua tokiyaꞌniꞌaene ataleteꞌna eteꞌna alisua tokiyaꞌniꞌaene hane. Aniꞌama hisua kavaꞌmo kea Nenafaꞌa ago naha-pai-maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mani kema hia kea Yuta vayaꞌmoꞌya haviteꞌya tolefi ali fako hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kasagoꞌyamoꞌya mage hae “Kefo Avamuꞌmo agupi hai-mainegeno aifoꞌnafo nehigi naꞌa higetama keꞌa maitama havimainae?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Hageꞌya nagoꞌamoꞌya mage hae “Kefo Avamuꞌmoꞌa agupima maineleꞌasina maniꞌa augafa kea ohileꞌasine. Kefo Avamuꞌmoꞌa aulagama asu hu-mainea kanomo aulaga aligali hu-oꞌateleꞌasine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Nayona mono no kimaleteꞌya fita yaki-mainaya kanahe muse nehaya imu Yelusalemu ki-mainae. Ani imua yasi neꞌalia kanale negiyanagino ani kanalela Yisasiꞌa Anumaya Koti nopi umaineno Solomoni yasi neꞌalea nona aye-nagali-malenea kaiyaga neꞌvie. ");
INSERT INTO knb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mukiꞌa Yuta veaꞌmoꞌya meliꞌya amuꞌno huteꞌya maineꞌya mage hae “Tagu tagesamoꞌa tole-lole nehuno taipamoꞌa kanaꞌage nehigi. Menia hu-falote huka taha-paiyo kagaya Anumaya Koti hu-ga-tegeka emainana kano mainano?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Havigageno Yisasiꞌa mage huno hie “Nagaya agoꞌma tamaha-pai-mainogi nagaifena havitama tamakupi maletama tamametiti nohae. Nenafa naminea tokiya yateti aliꞌyana alugetama agayana ani yana nagaya Anumaya Koti hu-na-tegeꞌna emainoa kano mainoa yafe tama-ve-lianagi nagai sipi sipima omaiya yafe havitama tamakupina nomalae. ");
INSERT INTO knb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nomalayanagi nagai sipi sipiyagamoꞌya nagaila alenaga mage haviteꞌya nakave malageꞌna nagaya amakaila ago amake-mainoe. ");
INSERT INTO knb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Amaketeꞌna maige maige hisaya hamaimula ago amaminoanagiꞌya ofaligahae. Nagaila ago nayapi mainayanagino nago kanomoꞌa memavayu ohugahie. ");
INSERT INTO knb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nenafaꞌa ani sipi sipiyaga naminea kanogino mukiꞌa yana amakase-mainea kano mainea yafe alu kanomoꞌa Nenafa ayapitila haofalegahie. ");
INSERT INTO knb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenafaꞌene nagaiꞌniene nagoke mainoꞌe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Higeꞌya Yuta vayaꞌmoꞌya nagoꞌene yafa kaꞌyo aliꞌya haesaya kava nehae. ");
INSERT INTO knb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nehageno Yisasiꞌa mage huno hama-paiye “Nagaya mukiꞌa Nenafa naminea tokiya avame yana tamakai tamaulagafina ago hu-mainogi nagoke avameꞌyana hana avameꞌya hua yamo notamahaigetama nagaila yafatetila nahaegahena nehae?” huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hama-vi-gegeꞌya “Tokiya avame yama hu-mainana yafene huta yafatetila okahaegahunagi kagaya ma mopafi afa kano mainekagi ‘Anumaya Kotiꞌene nagoke mainoꞌe.’ hukama hanana Anumaya Kotina kalana ategana kema hana yateti kagaila yafa kaꞌyotetila kahaegahena nehune.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Hageno Yisasiꞌa mage hie tamakaitami mono kema kae-malenaya kemoꞌa mage hu-maineane “Anumaya Kotiꞌa mage hie ‘Tamakaitami Anumaya Kotigatama mainae.’ huno hie.” huꞌya kae-malenayane. ");
INSERT INTO knb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Ani Anumaya Koti kea kae-malenaya ke hanege hanege huno tamageꞌage hugahie. Anumaya Koti kema agoꞌma hama-paiya vayafena “Anumaya Kotigatama mainae.” huno hu-maineana nagaya Nenafafena “Nenahaiya kano mainane huno hu-na-tegeꞌna ma mopafina emainoema.” huꞌna nehuana naꞌa higetama “Nagaya Anumaya Kotina neꞌamoꞌnae.” huꞌnama hua kehena “Anumaya Kotina hu-haviya hu-neꞌatane.” hutama hu-nena-tae? ");
INSERT INTO knb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","“Nagaya Nenafa aliꞌyama oꞌaluleꞌasina nagaifena havitama tamakupi maletama tamametiti ohaleꞌasinagi kanale kava haleꞌasine. Nagaya kema hu-mainoa kehema havitama tamakupima omalenutamahena aliꞌyama ali-mainoa aliꞌyafena havitama tamakupi maletama tamametiti hiho. Naꞌa hisayana Nenafaꞌa nagaiꞌene maigeꞌna nagaya aniꞌa huꞌna agaiꞌene mainoꞌema huꞌna hua kea havilama hutama havigahae.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Higeꞌya nagoꞌene atafa huꞌya nofi hu-tegahe hayanagi amakaseno ago umaine. ");
INSERT INTO knb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uteno Yisasiꞌa eteno Yotani lina mo lakaeno Yoniꞌma lima fale-ma-tenea kumate mo maine. ");
INSERT INTO knb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mo mainegeꞌya mukiꞌa veaꞌmoꞌya melitalu huꞌya maineꞌya mage hae “Yoniꞌa keꞌama alino lokiya vaisia yana nagola malegeta oꞌagenonagi ma kanomofena mukiꞌa kema hu-mainea kemoꞌa tamage-lafa hu-maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mukiꞌa ani kumate veaꞌmoꞌya Yisasifena haviꞌya amakupi maleꞌya amametiti hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nago kanomo agia Lasalusiꞌe kali ali-maine. Ani kanoa Petani kumate kanoe. Mataꞌene aganaꞌamoꞌa Maliagani kumale. ");
INSERT INTO knb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ani Maliaꞌa nago yupa manaꞌage masavena Yisasina aiyale takino fale-teneno ayolagefaleti ali hau hu-teneane. Ani munaꞌmona asaꞌamoꞌa Lasalusi kali ali-maine. ");
INSERT INTO knb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kali alino mainegeꞌana ani tole nanukana-latamogania Yisasitega nago kano hu-taꞌageno mage mo hie “Alatimogae kagaikama kahau kayamopafima negahaiya kanoa kali neꞌalie.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hapaigeno Yisasiꞌa ani kema nehavinoꞌa mage hie “Lasalusiꞌa kali alino fae-maineanagi falisia yafe oꞌalinegi mani kalimoꞌa Anumaya Koti agi alisaga hisayafene huno ali-maine. Ani kalia Anumaya Koti nafaꞌnemo agi alisaga hisaya yafe falote hu-maine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisasiꞌa Mataꞌene aganaꞌamoꞌene Lasalusiꞌene ani anagafena tusiya huno hau ayamopafi nehaiya anagale. ");
INSERT INTO knb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","Yisasiꞌa Lasalusiꞌma kalima alia kea havianagi oꞌuno tole yupa afaꞌa nemaiya kumate maiteno agaiꞌaenema tokaeꞌya nemaiya anagaꞌahe mage huno hama-paiye “Yutia kotega eteta visune.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage hae “Hu-lave-nelina kanomoga menia Yuta vayaꞌmoꞌya yafateti aliꞌya kahaegahema haya kotega kagaya ani kotega nagoꞌene ugahe nehano?” huꞌya havinegae. ");
INSERT INTO knb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Havigageno Yisasiꞌa mopafi mainea kanaꞌamoꞌa haꞌno ohunea yafe kenonaꞌamia avame kea mage huno hie “Tuelufuꞌa (12) auva nagoke yagefina omalenefi? Veaꞌmoꞌyama yagefima vai-yesayana ma mopafi yagemoꞌa ai vasa humainea yafe asaga hu otavigahayanagi veaꞌmoꞌya kegeꞌma vaiyatete hisayana aye-vasa hu yamaꞌa amakupina omaleanagino vailino hamaegahie.” ");
INSERT INTO knb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yisasiꞌa mani kea huteno nago kea mage huno hu-maine “Tagaila kanapatia Lasalusiꞌa faeno maineanagiꞌna nagaya visuaꞌamoꞌna mogafa huꞌna avale he-ti-tegahue.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage hae “Alatimogae agayama kalima alino fae-mainesiana afaꞌa kanale hu-tegahie.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Hageno Yisasiꞌa mani avame kema hiana Lasalusiꞌa ago fali-maine huno nehianagi agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya ohavinaya yafe “Afaꞌa faeno mainegeno nehie.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hageno Yisasiꞌa ani avame kea neꞌataleno hu-falote huno hama-paiye “Lasalusiꞌa ago fali-maine. ");
INSERT INTO knb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tamakaya nagaifena havilama hutama ‘Tamage nehie.’ hutama tamakupi maletama tamametiti hisaya yafe omainogeno fali-maineanagiꞌna nagaya muse nehugi menia aligeta mogamano.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Higeno Tomasina, nago agia Titimasiꞌe, tagai kefina kuyave nafaꞌne, Yisasienema tokaeꞌya nemaiya anagafe mage hie “Mukiꞌamogata vigetao. Nagopi neꞌvisunageꞌya tahaesageta faligahune.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasalusina foꞌa (4) yupa komufi he-vai-tenageno Yisasiꞌa uvaꞌyi higeꞌya he-vai-tenaya kanahe hapaimainae. ");
INSERT INTO knb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Petaniti Yelusalemua tagufa (3) kilomita aupate hanea yafe mukiꞌa Yuta veaꞌmoꞌya Yelusalemutila etele huꞌya Matagani Maliaganina anasaꞌanimoꞌma fali-mainea yafe hamau hu-nateꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Emainageno Mataꞌa Yisasife “Neꞌe.” huꞌya haya kea haviteno katega viaꞌyamo mo fotu hu-mainegi Maliaꞌa nomaꞌafi maine. ");
INSERT INTO knb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mainegeno Mataꞌa Yisasife mage hie “Alanimoga kagayama maleꞌma mainateꞌasina nasaꞌnimoꞌa ofalileꞌasine. ");
INSERT INTO knb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ago havimainoe menia kagayama Anumaya Kotitega nago yafema havigesanana afaꞌa kamigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Higeno Yisasiꞌa mage huno hapaiye “Kasakamoꞌa fali-maineanagi eteno haimula alino he-tigahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Higeno ani munaꞌmoꞌa mage hie “E, nagaya ago havimainoe ma mopama haꞌnoma hisia kanafina mukiꞌa fali-mainaya veaꞌma he-tisaya kanafina eteno he-tino haimula aligahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Higeno Yisasiꞌa kenonaꞌa mage hie “Nagaya fali-mainaya veala amavale he-tiꞌna hamaimula amamisua kano mainoe. Nagaya maige maige hisaya hamaimu amami yamona aepaꞌa mainoe. Nagoꞌa veaꞌmoꞌya nagaife haviꞌya amakupi maleꞌya amametiti hisayana faliteꞌya hetiꞌya agola maige maige hisaya hamaimula aligahae. ");
INSERT INTO knb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nagoꞌa veaꞌmoꞌya afaꞌa maineꞌya nagaifena haviꞌya amakupi maleꞌya amametiti hu-mainaya veala maige maige hugahayanagiꞌya ofaligahae. Kagaya mani kea ago havilama huka kagupi maleka kametiti nehapi nohane?” huno havige. ");
INSERT INTO knb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Havigegeno ani munaꞌmoꞌa mage hie “E, Alanimoga nagaya nehaviꞌna ago nagupi maleꞌna nametiti hu-mainoe. Tamage nehae kagaya Kalaisigae* Anumaya Kotiꞌa hu-ga-tegeka taugafa ali-gatigahe ma mopafi elavisana kano emainane. Anumaya Koti nafaꞌne mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mataꞌa mani kea huteno eteno viaꞌyamo aganaꞌamona Maliana sumi sumi huno mage huno hapaiye “Hu-mave-nelia kanoa ago emaineno kagaife ke nehie.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hapaigeno Maliaꞌa ani kea haviteno aupaꞌa he-tino Yisasi mogegahe umaine. ");
INSERT INTO knb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Neꞌvigeno Yisasiꞌa kumatela omenegi Mataꞌene fotuma huꞌana kea keama haꞌalega maine. ");
INSERT INTO knb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mainegeꞌya Yuta veaꞌmoꞌya Maliaꞌene nopi maineꞌya hanauma hu-nateꞌyama emainaya veaꞌmoꞌya Maliaꞌa aupaꞌa he-tino kumatega via yafe agayana higeꞌya “Vae Maliaꞌa asaꞌamo komulega avitegahe neꞌvie.” huꞌya akave umainae. ");
INSERT INTO knb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Akave vageno Maliaꞌa Yisasi mainelega mogeteno aiyafi mope hu-maineno mage hie “Alanimogae kagayama maleꞌma mainateꞌasina nasaꞌnimoꞌa ofalileꞌasine.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hapaiteno avi neꞌategeno agaiꞌenema emainaya Yuta veaꞌmoꞌya aniꞌa huꞌya neꞌatageno Yisasiꞌa Maliana neꞌagegeno aipamoꞌa tusiya huno haviya hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aipamoꞌa haviya hu-mainefiti hama-vigeno mage hie “Hanate he-vai-tenae?” huno higeꞌya “Alatimoga eka mego.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nehageno Yisasiꞌa avi-te-maine. ");
INSERT INTO knb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Neꞌategeꞌya Yuta veaꞌmoꞌya mage hae “Ageho Lasalusifena tusiya huno hau ayamopafi nehaiye.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hageꞌya nagoꞌa veaꞌmoꞌya mage hae “Ma kanoa amaulagama asu hu-mainea veaꞌma aligali hu-neꞌamatea kanogi naꞌa higeno Lasalusina kaliꞌa alino kanale hu-tegeno ofalino afaꞌa maiyanagi fali-maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisasina aipamoꞌa nagoꞌene haviya higeno he-vai-tenaya komulega umaine. Ani komua yafa kapi he-vai-teteꞌya komumo avayalela ala yafateti aliꞌya ai-lile-malenae. ");
INSERT INTO knb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ai-lile-malenageno Yisasiꞌa mogeteno mage hie “Mani komumo avayaleti yafana ali-taleho.” huno higeno fali-mainea kanomo asaꞌamoꞌa, Mataꞌa, mage huno hie “Alaniꞌamogae mani kanoa ago he-vai-tageno foꞌa (4) yupa komufinaga haneanagino tusiꞌa hiꞌmana hugahie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Higeno Yisasiꞌa mage hie “Nagaya ago kaha-pai-mainofi? ‘Kagayama nagaifema tamage nehane huka kagupi maleka kametitima hisanana Anumaya Koti agi alisaga hisaya tokiya yana agegane huꞌna kaha-pai-mainofi?’ huno havinege.” ");
INSERT INTO knb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ani yafana ali-taletageno Yisasiꞌa anafinaga agesaga huno age-maineno mage hie “Nenafaga nunamuniꞌa ago havimainana yafe musekaꞌa nehue. ");
INSERT INTO knb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Havimainanagiꞌna nagaya mukiꞌa kanalema kahavi-goa kea nehavinagi afaꞌa menia manileꞌma mainaya veaꞌmoꞌya kagayama hu-na-tanageꞌna emainoa yafema ‘Tamage nehane.’ huꞌya amakupi maleꞌya ametiti hisaya yafe kahavi-negoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mani kea huteno ala kegefafiti mage hie “Lasalusiga he-tika elavio.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Higeno Lasalusiꞌa, fali-mainea kanoa, eteno he-tino elavigeꞌya aiyafima ayapima augosafima kenaletiꞌma aye-gasagi-malea kanoa elavigeno Yisasiꞌa mage huno hama-paiye “Kalu hetama atalegeno vino.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mukiꞌa Maliaꞌenema emainaya Yuta veaꞌmoꞌya Yisasiꞌma hia kavala ageteꞌya amakupi maleꞌya amametiti hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amakuꞌa amiyanagi nagoꞌa vayaꞌmoꞌya ataleꞌya Falasia vaya mainalega uꞌya Yisasiꞌma hia kavafena mo hama-pai-mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hama-paigeꞌya Falasia vayaꞌene ala mono note kava vayaꞌene Kanisole vayafe ke hageꞌya ageꞌya mage huꞌya hae “Ma kanoa kasagoꞌya tokiya avame yaꞌyaga nehigi naꞌa hisune? ");
INSERT INTO knb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Afaꞌama atalesunagenoꞌa mukiꞌa kanalela aniꞌageꞌyama hisigeꞌya mukiꞌa veaꞌmoꞌya ‘Tamage nehie.’ nehuꞌya haviꞌya amakupi maleꞌya amametiti hisageꞌya kava vayatia, Lomu vayaꞌmoꞌya eꞌya mukiꞌa veaꞌnene ala mono notiene ali haviya hugahae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hageno Kaiyafasiꞌa ani kafufina ala mono note hagote kava kano maineanagino ani vayapiti he-tino mage hie “Tamakaya tamaku tamakesa nomale. ");
INSERT INTO knb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tamakaya ohavinafi na ya kanale tamaya hisia yana hane? Mukiꞌa veati ali haviya hisafi nagoꞌke kanomoꞌa mukiꞌa veaꞌamogami anonaꞌa falisie?” huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ani kafufina Kaiyafasiꞌa ala mono note hagote kava kanogino mani kea Anumaya Kotiꞌa hapaigeno aune laga huno hu-maine. Agaiꞌa agesafiti ohune. Ani aunema laga hia aepaꞌamoꞌa mage hu-maine “Yisasiꞌa Yuta veaꞌmogamife huno faligahie. ");
INSERT INTO knb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Amakaiꞌamigetefena huno ofaligahigi alu kumate kumate mainaya Anumaya Koti nafaꞌneyaga amavaleno nagoke anaga hu-ma-tesigeꞌya maisaya yafe Yisasiꞌa faligahie.” ");
INSERT INTO knb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ani kanaleti aepa heꞌya Yuta vayaꞌmogami kava vayaꞌmoꞌya Yisasina haesaya kea huꞌya haviteꞌya huge havige hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ani yafe Yisasiꞌa nagoꞌene Yuta veaꞌmogami amaulagafina vai oꞌayenegi nago kumala Efalaimie huꞌya nehaya kumala vaya omai kola aupa hu-mainegeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌene anilega uꞌya mo mainae. ");
INSERT INTO knb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuta veaꞌmoꞌya kafuꞌahe kafuꞌahena Anumaya Kotiꞌma amakinagomogami amaugafama ali-gati-mainea yafe haviꞌya alitalu huꞌya imu negiyane. Ani imuma kisaya kanamoꞌa aupa higeꞌya mukiꞌa veaꞌmoꞌya mukiꞌa kumateti haiꞌya kahegi kemo hama-paiya kava huꞌya amaugafaene amakuꞌaene sese hugahe Yelusalemu umainae. Ago mo sese huteꞌya ani imuꞌamia nenae. ");
INSERT INTO knb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ala mono nopi molitalu huꞌya maineꞌya Yisasife moge mege huꞌya ati-yegetayana higeꞌya amakaiꞌamifi mo hama-vige me hamavige huꞌya mage hae “Naꞌane tamakesa nehaviye? Kaveꞌma nesutela egahifi omegahie?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hageꞌya ala mono note kava vayaꞌene Falasia vayaꞌene Yisasina atafa hugahe mage hu-mainae “Maꞌa hiho. Yisasiꞌma faesia kumaꞌma agenutamahena aupaꞌa ani kea alitama me laha-paiho.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yisasiꞌa Petani kumate, Lasalusiꞌa faligeꞌya he-vai-tenageno Yisasiꞌa molino he-ti-tenea kanomo kumate, uvaꞌyi hu-maine. Uvaꞌyi hiana ani kanafina Anumaya Kotiꞌma amakinagomogami amaugafama ali-gati-mainea yafe amakesa haviꞌya imuma kisaya kana sikisiꞌa (6) yupa maiteꞌya kigahe nehae. ");
INSERT INTO knb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hageno Yisasina musekase kave talo tala hu-teteno Mataꞌa alino amamite amamite nehigeno Lasalusiꞌa Yisasiꞌene siale mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mainageno Maliaꞌa nago kilo* manaꞌage masave hanea keꞌayola, tusiꞌa mone hanea masavemo agia natie nehaya masavena alino Yisasina aiyale taki haꞌno hu-teteno ayolagefaleti ali hau hu-neꞌa-tegeno ani masavemo manamoꞌa ani nopi haino hiya higeꞌya manaꞌa havimainae. ");
INSERT INTO knb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Nago kanoa, Yisasiꞌenema tokaeꞌya nemaiya anagapiti kanomo, agia Yutasi Isakaliotiꞌe. Ani kanomoꞌa haenagaꞌa Yisasina agesi huno kame ya hu-tesia kanomoꞌa mage hie “Naꞌa higeno mani manaꞌage masavena afaꞌa neꞌatale? Atalegeno nago kanomoꞌma miya hileꞌasipa tali hataleti (K300) kina aliteta mani masaveteti monea afenoꞌamima omalenea veaꞌne amamuteꞌasine.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mani kea moneꞌamima omalenea veafena hauma hu-neꞌa-matea yafena nohigi mukiꞌa kanalela monema hanea kutela agaiꞌa yagai-maineno musufa yama nehia yafe mani kea hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yisasiꞌa mage hie “Ma munala afaꞌa atalegeno ma masavena afaꞌa ali-lineno nagayama falisugeꞌya he-vai-natesaya kanalela mani masaveteti fale-na-tegahie. ");
INSERT INTO knb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Moneꞌamima omalenea veaꞌmoꞌya mukiꞌa yupa tamakaiꞌene maigahayanagi nagaya tamaikaiꞌenena mukiꞌa yupa omaigahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mukiꞌa Yuta veaꞌmoꞌya “Yisasiꞌa Petani kumateꞌma emaine.” huꞌya haya kea haviteꞌya ani kumate umainae. Yisasina agaiꞌage agegahe oꞌunagi Lasalusiꞌa fali-mainegeno ali he-ti-tenea kanoene anakegahe umainae. ");
INSERT INTO knb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lasalusiꞌa fali-mainefiti he-ti-mainea yafe mukiꞌa Yuta veaꞌmoꞌya nayoma nehaya monola neꞌataleꞌya Yisasina amakuꞌa amitafa huꞌya amametitima haya yafe ala mono note kava vayaꞌmoꞌya Lasalusiꞌene haesaya kea hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Faeteꞌya kotigeꞌya mukiꞌa veaꞌmoꞌya Anumaya Kotiꞌma amakinagomogami amaugafama ali-gati-mainea yafe imuma ki-malenale emaineꞌya “Yisasiꞌma Yelusalemu kumate egahie.” huꞌya haya kea havi-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Haviteꞌya Yisasiꞌene katega mo fotu hugahe tofe yosamona haisaꞌa kofa-nafa huꞌya aliꞌya umaineꞌya ala kefiti mage huꞌya hae “Tusiꞌa yate taugafa ali-gatisana kanoa kanaleꞌya huka neꞌane. Anumayamo aliꞌya alisana yafe hu-ga-tegeka emainana kanomoga Anumaya Kotiꞌa kanale manu kamiteno kaya hu-maine. Isaleli kotega yagai-ma-tenana sauve kanomoga Anumaya Kotiꞌa kaya hu-maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yisasiꞌa nago hosi kana afumo agia tokie nehaya afua age falote huteno agupifi haino maine. Aniꞌama hia kavala nayona Anumaya Koti kefina mage huꞌya kae-malenayane. ");
INSERT INTO knb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalemu veaꞌmogatama kolia ohutama ageho. Menia tamakaila sauve kanotamia yaufa tokimo agupifi haino maiteno egahie.” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yisasiꞌma aniꞌama hu-mainea yupa agaiꞌenema tokaeꞌya nemaiya anagaꞌmoꞌya anima kae-malenea kea ohavianagi haenagaꞌage Yisasiꞌma faliteno he-tino tokiya hale yamaꞌama hanea kumate haitegeꞌya amakesamoꞌa ai-kalo higeꞌya anima kae-malenea kene veaꞌmoꞌya ani yupama hu-tenaya kavafeꞌene havi-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yisasiꞌa Lasalusifema “Komufitila he-tio.” huno higeno fali-mainefitiꞌma he-ti-mainea yupa anileꞌma mainaya veaꞌmoꞌya ani kanafina “Yisasiꞌa naꞌa maꞌa kavala hu-maine.” huꞌya kea aliꞌya ute ete huꞌya hama-pai-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hama-paigeꞌya haviteꞌya anima tokiya avame yama hu-mainea kema haviya yafe mukiꞌa veaꞌmoꞌya katega Yisasiꞌene mo fotu hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hageꞌya Falasia vayaꞌmoꞌya amakaiꞌami amuꞌnoꞌamifina ani kehena mohu mehu huꞌya mage hu-mainae “Ageho mukiꞌa mopafi veaꞌmoꞌya Yisasina akave neꞌvayanagita atafa ohugahune.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nagoꞌa Kaliki veaꞌmoꞌya, Anumaya Koti agi alisaga hugahe, ani imu kaveꞌma nalega Yelusalemu hai-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ani Kaliki veaꞌmoꞌya Filipite umainae. Filipiꞌa Kalili hanea kumala Petesaita kumateti kano mainelega uꞌya mage hae “Musekaꞌa nehunagi tagaya Yisasina agegahe neꞌone.” huꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hageno Filipiꞌa viaꞌyamo Etaluna hapaiteꞌana ani lolemogani Yisasina mo hapai-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hapaiꞌageno Yisasiꞌa mage huno hana-paiye “Menia Ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia tusiya huꞌya nagai nagia ali-saga hisaya kanamoꞌa ago evaꞌyi hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tamage huꞌna tanaha-nepauve nagoke viti avinamoꞌma asaga hu-lavino mopafima ofalinunofena nagoke viti avinaꞌage hanegahigi nagi falinunofena ai-falo huno hageteno kasagoꞌya viti alagayaga aye helafigahie. ");
INSERT INTO knb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Naꞌa hugahianagi nagoꞌa veaꞌmoꞌyama mukiꞌa ma mopafi yafema amaugafama aliꞌya haiteꞌya hamaimuꞌamima atafa hisaya veaꞌmoꞌya faligahae. Faligahayanagi nagoꞌa veaꞌmoꞌyama ma mopale mainaya amaugafama aliꞌya haisaya yafema ‘Afa yanema.’ huꞌya hisaya veaꞌmogami hamaimuꞌmoꞌa haꞌno ohugahianagiꞌya maige maige huꞌya maigahae. ");
INSERT INTO knb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nagoꞌa veaꞌmoꞌyama nagaifema huꞌya aliꞌya alisayana nakave ege ege hisae. Nakaveꞌma esaya veaꞌmoꞌya maisua yate nagaiꞌene mainesageno Nenafaꞌa nagai aliꞌyama neꞌaliya veaꞌmogamina ala amaki amamigahie.” ");
INSERT INTO knb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yisasiꞌa mage huno nehie “Nagai naguꞌamoꞌa tusiya huno kanaꞌage nehigeꞌna kasagoꞌya nagesa nehavugi naꞌane huꞌna hisue? ‘Nenafaga menia nagai naugafaleꞌma faloteꞌma hugahema nehia yana ali-talo.’ hisufi? Aꞌao nagaya ani nagata aisia yapi maigahe emainoe. ");
INSERT INTO knb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nenafaga kagaika kagi alisaga huo.” huno nehigeno anile ikapinagati age aino mage huno hie “Nagia ago alis-aga hu-mainoane eteꞌna nagoꞌene nagia ali-saga hugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Higeꞌya melitalu hu-mainaya veaꞌmoꞌya agema aiya kea haviteꞌya nagoꞌamoꞌya mage huꞌya hae “Ikapinagati akali kalu nehie.” huꞌya hageꞌya nagoꞌa veaꞌmoꞌya mage huꞌya hae “Nago ensole kanomoꞌa ke me hanepaiye.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Hageno Yisasiꞌa mage huno hie “Ani agema aiya agea nagai naya hisia yafe nohigi mani kea tamakai tamaya hisia yafe nehie. ");
INSERT INTO knb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Menia ma kanafina Anumaya Kotiꞌa ma mopale veaꞌmogamina kaiyeke hu-ma-tegahie. Meni kanafima ma mopaleꞌma kava yagai-mainea kanoa, Satanina* ago anati-talegahie. ");
INSERT INTO knb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Anati-talegahigi ma mopaleti navalesaga huꞌya* nahaesageꞌya mukiꞌa veaꞌmoꞌya amakuꞌa namisaya yafe amavayu huꞌna nagaiꞌnilega amategahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ani avame kema huno hia kemoꞌa mage hu-maine “Ma yateti, yafaga yosale nahaesageꞌna faligahue.” huno hama-pai-maine. ");
INSERT INTO knb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hama-paigeꞌya veaꞌmoꞌya kenonaꞌa mage huꞌya hapai-mainae “Tagai monoꞌmoꞌa mage huno taha-pai-maine ‘Anumaya Kotiꞌma taugafa ali-gatigahema hu-tesia kanoa mukiꞌa kanafina maige maige hugahie.’ huno taha-pai-maineanagi naꞌa higeka ‘Ikapinagati emainoa kanoa vayaꞌmo natenea kanomonia yafaga yosale navalesaga hugahae.’ huka nehane? Anima ikapinagati emainea kanoa vayaꞌmo atenea nafaꞌnea ta maine?” huꞌya havigae. ");
INSERT INTO knb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Havigageno Yisasiꞌa kenonaꞌamia mage huno hie “Hale yamaꞌaene kanomoꞌa tamakaipina osi kana kanoꞌa maine. Hani kisia yana vaꞌyi huno aiso hu-lama-tesia yafe hale yama hanea kanale vaiyatete hiho. Hani-ki-mainea yapima mainaya veaꞌmoꞌya visaya kana oꞌagenae. ");
INSERT INTO knb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hale yamaꞌama hanea kanafina hale yamaꞌaene kanohe ‘Tamage nehane.’ hutama havitama tamakupi maletama tamametiti hiho. Aniꞌama hisayana hale yamo nafaꞌneyaga maigahae.” huno hama-pai-maine. Yisasiꞌa mani kea huteno neꞌamataleno mo fala-ki-maine. ");
INSERT INTO knb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mukiꞌa tokiya avameꞌyamo amaulagafi alianagi agaifena haviꞌya amakupina maleꞌya amametitia nohae. ");
INSERT INTO knb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ani yafe Anumaya Kotina aune kanoꞌa, Aisaiyaꞌa, hu-mainea kea falote huno tamage nehie. Mage huno hu-maineane “Anumayamoga manima hu-mainona kea taꞌya haviꞌya amakuꞌafina maleꞌya amametitia nehae? Anumayamoꞌa tokiya avame yamaꞌa amave-ligeꞌya hana veaꞌmoꞌya havilama nehae?” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Higeno amuha ohunayanagiꞌya Yisasifena haviꞌya amakupina maleꞌya amametitia ohunaya yafe Aisaiyaꞌa nagoꞌene mage huno humaineane ");
INSERT INTO knb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Amaulaga oꞌagesaya yafe Anumaya Kotiꞌa amaulaga ago alino asu hu-ma-tene. Amaku amakesa havilama ohisaya yafe ‘Yafa kana amanuꞌene veaꞌne maiho.’ hu-ma-tene. Havigu amakuꞌa ai-yahae huꞌya nagaitega eyafenagiꞌna ali hilato hu oꞌama-tegahue.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiyaꞌa Yisasina tokiya hale yamaꞌa ageteno Yisasife mani kea hu-maineane. ");
INSERT INTO knb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hu-maineanagi Yuta kava vayaꞌyagafitila kasagoꞌya vayaꞌmoꞌya Yisasife haviꞌya amakupi maleꞌya amametitia hayanagi Falasia vayaꞌmoꞌya mage hae “Mani kavaꞌma hisayana mono nopina omegahae huta nagalu hu-lama-tegahune.” huꞌya hu-mainaya yafe “Yisasina taguꞌa neꞌamune.” huꞌya hu-falote ohunae. ");
INSERT INTO knb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ani veamoꞌya Anumaya Kotiꞌa “Kanale kava nehae.” huno amakima alisaga hisia yafena nohamaigi veaꞌmoꞌya “Kanale kava nehae.” huꞌya amaki alisaga hisaya yafeke nehamaiye. ");
INSERT INTO knb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yisasiꞌa tokiyaꞌage ke hu-haleno mage hu-maine “Nagoꞌa veaꞌmogatama nagaifema tamage nehie hutama tamakupi maletama tamametitima hisayana nagaiꞌnigefena tamakupina maletama tamametitia hu-nona-tagi hu-na-tenea kanomofeꞌene hu-neꞌa-tae. ");
INSERT INTO knb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nagoꞌa veaꞌmoꞌyama nagaiꞌma nenagayana Nenafaꞌa hu-na-tenea kanoene age-mainae. ");
INSERT INTO knb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nagayama ma mopaleꞌma emainoana hale ya kana huꞌna emainoe. Nagoke nagoke veaꞌmoꞌya nagaifeꞌma haviꞌya amakupima maleꞌya amametitima hisayana haniki-mainea yapina omaigahae. ");
INSERT INTO knb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nagoꞌa veaꞌmogatama nagai kema havitetama nakaveꞌma omalesayana nagaya tamakaila kaiyekea hu otama-tegahue. Ma mopale veaꞌmogamina kaiyekea hu-ma-tegahue huꞌna omenogi ma mopale veaꞌmogamina amaugafa ali-gatigahue huꞌna emainoe. ");
INSERT INTO knb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nagoꞌa veaꞌmoꞌya nagaifeꞌma amakaveꞌnoma huꞌya nagai kema amakupima aliꞌya omalesayana hu-mainoa keꞌnimoꞌa fako hu-ma-tegahie. Ma mopama haꞌno hisia kanama evaꞌyima hisiana hu-mainoa keꞌnimoꞌa fako hu-ma-tegahie. ");
INSERT INTO knb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mani kea nagesafitila ali falote huꞌna tamaha-nopaugi hu-na-tenea Nenafa ‘Nage mage huka huo.’ huno naha-paiya keꞌage tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nagaya ago havilinoe agai kema havitama tamakupima maletama tamametitima hisayana ofalitama agola maige maige hisaya tamahaimula aligahae. Nani yafe Nenafaꞌa naha-pai-mainea kea tamaha-nepauve.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anumaya Kotiꞌma amakinagomogami amaugafama ali-gati-mainea yafe ala imu kigahe nehae.* Ani imu kisaya kanaꞌamimoꞌa aupa hugahe nehigeno Yisasiꞌa ma agesa havimaine “Ma mopa ataleꞌna Nenafatega visua kanamoꞌa ago evaꞌyi nehie.” huno nehuno mukiꞌa kanaleꞌma ma mopale maineꞌyama agai kema nehaviya veaꞌmogamifena tusiya huno hau ayamopafi nehaino agola haume haume haino mo fali-maine. ");
INSERT INTO knb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yisasiꞌenema tokaeꞌya nemaiya tuelufuꞌa (12) anagaꞌaene unena kavela nenageno Sataniꞌa Yutasifena “Havisigi huka agesi huka hama-pai-sanageꞌya Yisasina haesae.” huno agu agesa amine. Ani Yutasiꞌa nago agiꞌa Isakaliotiꞌa Saimonina nemofoꞌe. ");
INSERT INTO knb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sataniꞌa aniꞌama hisia agu agesa amigeno Yisasiꞌa ma agesa havimaine “Nenafaꞌa mukiꞌa tokiya ago nayapi maleneanagiꞌna Anumaya Kotiꞌa hu-na-tegeꞌna emainoafe eteꞌna Anumaya Kotitega haigahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nehuno kaveꞌma neneletila neꞌataleno he-tino ayaꞌaya kenaꞌa hateno nemaleno taulia alino amupi ai-gagino fai-line. ");
INSERT INTO knb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Fai-lineno tina alino yopafi taki-maleneno aepa heno agaiꞌa tuelufuꞌa (12) anagaꞌamogami amaiya agupia sese hu neꞌama-teno ai-gagi-linea taulileti alino hau hu-neꞌamate. ");
INSERT INTO knb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ali hau hu-ma-teme Saimoni Pitate vigeno Saimoni Pitaꞌa Yisasife mage hie “Alaniꞌamoga naigai naiya sese hu-na-tegahe nehano? Sese hu ona-tegane.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Higeno Yisasiꞌa mage hie “Kagaya nagayama nehua kavala menia ohavinanagi haenagaꞌa havilama huka havigane.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ha-paigeno Pitaꞌa Yisasifena mage hie “Kagaya naiya sese ohutafa huka sese ohugane.” huno higeno Yisasiꞌa kenonaꞌa mage hie “Kaiyama seseꞌma ohisuana nagaiꞌenena omaitafa huka omaigane.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Hapaigeno Saimoni Pitaꞌa mage hie “Alaniꞌamoga naꞌama hinageka naiyaꞌagela sese hu ona-teka nayaꞌene nanuꞌene sese hu-nato.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ha-paigeno Yisasiꞌa kenonaꞌa mage huno hapaiye “Nagoꞌa veaꞌmoꞌya mukiꞌa amaugafama sese hu-malenaya veala amaugafalela oniꞌyaꞌamia omaleno haigafaꞌage hamau-maineanagiꞌya amaiyaꞌage sese hugahae. Tamakaila kefo yama haya oniꞌyatamia omaleno haigafananamaꞌage hu-mainagi nagoke kanomona oniꞌyaꞌage hau-maine.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hama-paiteno Yisasiꞌa agaiꞌma agesiꞌma huno haegahema hia kanoa ago age-mainea yafe “Tamakaya mukiꞌamogatamina oniꞌyatamia omalene huꞌna nohue.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Amaiya sese hu-ma-teteno kenaꞌa alino vai-lino mopale maineno mage huno hama-vige “Nagayama hu-lama-toa kavala ago havilama nehafio? ");
INSERT INTO knb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tamakaya nagaifema ‘Hulave-nelina kanomogae.’ nehutama ‘Alatimogae.’ hutamama nehayana tamage hutama nehae. Nagaya ani kanoema hutama haya kano mainoe. ");
INSERT INTO knb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nagaya Alatamimoꞌna hu-lama-ve-neloa kanotamimoꞌna tamaiya sese hu-nelama-toe. Tamakaya aniꞌa hutama nelamafugami amaiya sese hu-ma-teho. ");
INSERT INTO knb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nagaya hisaya kavala ago tamave-neluafe tamakaya nagayama hu-lama-toa kavala aniꞌa hu-ma-teho. ");
INSERT INTO knb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nagaya tamagelafa huꞌna tamaha-nepauve aliꞌya kanoꞌamoꞌa kava kanoꞌamona agaseno omainegi kayo kayo kanoꞌamoꞌa hu-tenea kanomona agaseno omaine. ");
INSERT INTO knb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tamakaya mani kema havilamama hutetama mani kavaꞌma hisayana kanaleꞌya hutama maigahae. ");
INSERT INTO knb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nagaya ‘Kanaleꞌya hutama maigahaema.’ huꞌnama hua kea mukiꞌamogatamifena nohugi nagayama nahaigeꞌna huyo-gi-malenoa-maꞌamogamife nehaviꞌna mani kea nehue. Anumaya Koti kema nayoma kae-malenaya kemoꞌa mage hu-maineane ‘Nagaiꞌenema maineno kaveꞌma nenea kanomoꞌa aiya alisaga huno nagaila aye-nalata-pegahie.’ huno kae-maleneane. Kae-maleneanagi meni kanafina mani kemoꞌa efalote huno tamage hugahe nehie. ");
INSERT INTO knb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Haenagaꞌa mani kemoꞌma efalote hisigetama nagaifena mage hugahae ‘Agaya Anumaya Koti nafaꞌne maine.’ hutama havitetama tamakupima maletama tamametitima hisaya yafe menia ani kana yaufa falote ohunea kanafi tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tamage-lafa huꞌna tamaha-nepauve nagoꞌa veaꞌmoꞌya nagayama hu-ma-tesua veaꞌma amavaleꞌya falu falama hu-ma-tesayana nagaila aniꞌa huꞌya navaleꞌya falu fala hu-nena-tae. Nagaiꞌma navaleꞌyama falu fala hu-natesayana hu-na-tenea kanomona aniꞌa huꞌya avaleꞌya falu fala hu-neꞌatae.” ");
INSERT INTO knb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisasiꞌa mani kea hama-paitegeno aipamoꞌa kanaꞌage higeno agu agesama havia agesamoꞌa hivi huno talavate oꞌategeno mani kea hu-falote nehie “Lamage huꞌna tamaha-nepauve tamakaipitila nago kanomoga vayaꞌmo havisigi huka nagesi huka kame ya hu-na-tegane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Higeꞌya agaiꞌa tuelufuꞌa (12) anagaꞌamoꞌya oꞌaufi aꞌaufi hugetayana higeꞌya “Tafepiga nehie?” huꞌya mani kanomofena ohavinae. ");
INSERT INTO knb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ohavigeꞌna nagaya Yoniꞌna agaiꞌaenema tokaeꞌya nemaiya anagapi nemauvanagino hau ayamopafi nagaifena hau-mainea kanogiꞌna avate tokaetaꞌa mainoꞌe. ");
INSERT INTO knb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mainogeno Saimoni Pitaꞌa anuteti avameꞌname huno “Havigo.” huno naha-paino “Tafe nehane huka havigo.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Higeꞌna nagaya Yisasina avaꞌale mime uꞌna maineꞌna mage huꞌna havigoe “Alaniꞌamogae tafe nehane?” huꞌna havigoe. ");
INSERT INTO knb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Havigogeno Yisasiꞌa mage huno hie “Nagayama kaveꞌma aliꞌnama supufi ayeteꞌnama aliꞌna amisua kanoa nagesiꞌma hisia kano maine.” huno nehuno ani kavela alino supufi ayeteno Yutasiꞌa, Saimoni Isakaliotina nemofo amine. ");
INSERT INTO knb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ani kavela amigeno alitegeno Sataniꞌa aguꞌafinaga mo hai-faleno mainegeno Yisasiꞌa mage huno hapaiye “Kagaya aupaꞌa hisuema hisana kavala ago huo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Higeꞌya anileꞌma mopale mainaya vayaꞌmoꞌya Yisasiꞌa Yutasife hianagi ani kemona aepaꞌa nohaviye. ");
INSERT INTO knb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ohavinagi Yutasiꞌa mone pokisiꞌamile yagaino nemaiya kanogiꞌya nagoꞌa vayaꞌmoꞌya mage huꞌya amakesa nehaviye “Yisasiꞌa agaifena ‘Ala imule mo nesuna yana molika eno.’ huno nehifi ifi ‘Moneꞌamima omalenea vaya nagoꞌa mone molika amamio.’ huno nehifi?” huꞌya amakesa havimainae. ");
INSERT INTO knb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Havigeno Yutasiꞌa ani kavela aliteno aupaꞌa kumatega hati-laviana tusiꞌa hani ki-mainea yapi umaine. ");
INSERT INTO knb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutasiꞌa ago utegeno Yisasiꞌa mage huno hie “Menia ikapinagati emainoa kanoa vayaꞌmo natenea kanomoni nagia ali-saga hugahae. Nagaiꞌma nahaesageꞌna falisugenoꞌa Anumaya Kotiꞌa ala agi aligahie. ");
INSERT INTO knb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nagaya falisua yafe Anumaya Koti agima ali-saga hisayana Anumaya Kotiꞌa navalesigeꞌna agaiꞌene maigahue. Aupaꞌa navaleno tokiya hale yapi ala nagi namigahie. ");
INSERT INTO knb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nafaꞌneyagaꞌnia tamakaiꞌenena nagaya osi kana kanoꞌa maiteꞌna visugetama nagaifena natiyegahayanagi amuha ohunayanagitama visua kumatela oꞌugahae. Mani kea Yuta veaꞌmogami hama-pai-mainoanagiꞌna menia tamakaila tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Menia nagola ohavinaya kahegi kea tamaha-paigahugi haviho. Nelama-fugamifena tamahau tamayamopafi tamahaino. Amakaya aniꞌa huꞌya tamakaifena hamaisie. Nagayama tamakaifema nahau nayamopafima nahaiya kava hutama nelama-fugamifena tamahau tamayamopafi tamahaino. Amakaya aniꞌa huꞌya tamakaifena hamaisie. ");
INSERT INTO knb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nagi tamakaya mukiꞌa nelama-fugamifena tamahau tamayamopafima lamahaisiana muki veaꞌmoꞌya tamakaila lamaketeꞌya tamakaifena mage huꞌya hugahae ‘Yisasiꞌenema tokaeꞌya nemaiya anaga mainae.’ huꞌya hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimoni Pitaꞌa mage huno havige “Alaniꞌamogae hanatega ugane?” huno havigegeno Yisasiꞌa mage huno hie “Visua kumatela menia nakavela oꞌuganagi haenagaꞌage nakavela ugane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Higeno Pitaꞌa mage huno hie “Alaniꞌamogae nagaya na ya hinageꞌna menia kakavela oꞌugahe hugeka nehane? Nagaya kagaifene huꞌna nahaimula atalegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Higeno Yisasiꞌa mage huno havige “Kagaya nagaifene huꞌka kahaimula atalegano? Tamagelafa huꞌna kaha-nepauve hagoteno kokolemoꞌa agea oꞌainesigeka kagaya tagufa (3) kanale avane huka nagiꞌa alika fala-kigane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisasiꞌa mage huno hu-maine “Mukiꞌa veaꞌmogatama tamaipamoꞌa kanaꞌage huno tamakesa kuꞌmoꞌa ohino. Anumaya Kotife havitama tamakupi maletama tamametiti haya kava nehutama nagaifena havitama tamakupi maletama tametiti hiho. ");
INSERT INTO knb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nenafa nopina veala maisaya nona kasagoꞌya hane. Ani yama omalesina nagaya mani kea ohuleꞌasine. Nagaya kumatamia moliꞌna talo tala hu-lama-tegahe ugahue. ");
INSERT INTO knb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nagaya kumatamia mo lalo tala hu-maleteꞌna eteꞌna me lamavalesugetama visua kumatela visageta nagaiꞌene mo lokaeta maigahune. ");
INSERT INTO knb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tamakaya nagayama visua kumaꞌmo kana ago age-mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Higeno Tomasiꞌa mage huno hie “Alatimogae tagaya visana kumala oꞌagenone. Hanaꞌa huta ani kana agesune?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Higeno Yisasiꞌa mage huno hapaiye “Nagaya ikapinaga visaya kamona Nefaꞌnae. Nagaya ke-lamage kemona aepaꞌa mainoe. Nagaya agola maige maige yamo hamaimula aepaꞌa mainoafe nagoꞌa veaꞌmoꞌya Nenafatega visayana alu katetila oꞌugahagi nagaiteke esae. ");
INSERT INTO knb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tamakaya nagaiꞌma havimainaleꞌasipa Nenafafena aniꞌa hutama havileꞌasine. Tamakaya menia aepa hetama Nenafana ago havitetama age-mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Higeno Filipiꞌa mage huno hapaiye “Alanimogae negafana taveligeta agesunageno tagu tamemoꞌa tamu hisie.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Higeno Yisasiꞌa mage huno hapaiye “Filipigae ayaꞌaya kanale tamakaiꞌenena maime emainoana kagaya nagaila onagenano? Nagoꞌa veaꞌmoꞌya nagaiꞌma nage-mainayana aniꞌa huꞌya Nenafana age-mainae. Naꞌa higeka ‘Negafana lave-lio huka nehane?’ ");
INSERT INTO knb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nagaya Nenafa aguꞌafina maugeno Nenafaꞌa aniꞌa huno nagai naguꞌafina mainea yafena havika kagupina nomalano? Tamaha-pai-mainoa kea nagesafiti kea tamaha-opainoe. Aꞌao. Nenafaꞌa nagai nagupi maineno agaiꞌa aliꞌyamaꞌa neꞌalie. ");
INSERT INTO knb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nagaya Nenafa aguꞌafi maugeno aniꞌa huno Nenafaꞌa nagaila naguꞌafina maigetaꞌa hu-mainoꞌema huꞌnama hua kea havitama tamakupina maletama tamametiti hiho. Mani kema ohavinutama tamakaya mukiꞌa aliꞌyama ali-mainoa aliꞌyama age-mainesayana nagaifena havitama tamakuꞌafi ali maletama tamametiti hiho. ");
INSERT INTO knb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tamage-lafa huꞌna tamaha-nepauve nagoꞌa veaꞌmoꞌya nagaifema haviꞌya amakupi nemalaya veaꞌmoꞌya mukiꞌama ali-mainoa aliꞌyana aniꞌa huꞌya aligahae. Nagaya Nenafatega visua yafe anima alisaya aliꞌyamoꞌa ali-mainoa aliꞌyana agaseꞌya aligahae. ");
INSERT INTO knb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nafaꞌneꞌamonife huꞌya Nenafaꞌa agima ali-saga hisaya yafe tamakaya nagai kema havitetama nagai nagi ayetama mukiꞌa yafena naha-vi-gesageꞌna aniꞌa hu-lama-tegahue. ");
INSERT INTO knb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mukiꞌa yafema nagai nagima ayetama naha-vi-gesayana afaꞌa ani yana hu-lama-tegahue.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mani kea huteno mage hie “Tamakaya nagaifema tamahau tamayamopafima tama-haisigetamahena tamaha-pai-mainoa kemona akave malegahae. ");
INSERT INTO knb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Akave malesageꞌna Nenafatega havigesugeno tamaya hisia Avamula hu-tesigeno tamakaite eno agola tamakaiꞌene emaige maige huno maigahie. ");
INSERT INTO knb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ani Alu Aotage Avamula tamageꞌage kemona aepaꞌa maineno hulama-ve-ligahie. Mukiꞌa ma mopale yafema amaugafama aliꞌya nehaiya veaꞌmoya Alu Aotage Avamula ageꞌya havilama ohunaya yafe oꞌavalegahagi tamakaya ago age-lama hutama age-mainaya yafe tamakaiꞌenena emaineno tamakupi haino maigahie. ");
INSERT INTO knb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na yafe tama-talesugetama megusa nafaꞌne kana hutama omaigahayanagiꞌna tamakaitela eteꞌna egahue. ");
INSERT INTO knb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Okasi kanaꞌa ma mopale yafema amaugafama aliꞌya nehaiya veaꞌmoꞌya nagoꞌene onagegahayanagitama tamakaya nagegahae. Agola maige maige yamona aepaꞌa mainoafe tamakaya aniꞌa hutama maige maige hisaya tamahaimula alitama maigahae. ");
INSERT INTO knb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mainesageno Alu Aotage Avamuꞌmoꞌma esia kanafina nagaya Nenafaꞌene mainoanagitama tamakaya aniꞌa hutama nagaiꞌenena maisageꞌna nagaya aniꞌa huꞌna tamakaiꞌenema mainoa yafena havilama hutama havigahae. ");
INSERT INTO knb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nagoꞌa veaꞌmoꞌya nagai kema haviꞌya akave malenuꞌya nagaifena hamau amayamopafifna hamau-maine. Nagaifema hamau amayamopafima hamau-mainesia veaꞌmoꞌya Nenafaꞌa aniꞌa huno amakaifena hau ayamopafina nehaiye. Nehaigeꞌna nagaiꞌenena aniꞌa huꞌna nahau nayamopafina nenahaigeꞌna naguꞌa amamisugeꞌya nagaila nage-lama huꞌya nagegahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Higeno nago kanoa, Yutasi Isakalioti omagi, hamoꞌamoꞌa mage huno Yisasina havige “Alanimogae naꞌa higeka kagaya tagaila taulagafina kagaika aepakaꞌa tave-nelinagi mukiꞌa ma mopale yafema amaugafama aliꞌya nehaiya veaꞌmogami amaulagafina hu-falote huka ohunanane?” huno havinege. ");
INSERT INTO knb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Havigegeno Yisasiꞌa mage huno hie “Nagoꞌa veaꞌmoꞌyama nagaifema hamau amayamopafima hamaisigeꞌyahena nagai kemona akave malesagenofena Nenafaꞌa amakaifena aniꞌa huno hau ayamopafina haugahie. Nenafaꞌene nagaiꞌnienena amakaiꞌene emaigahuꞌe. ");
INSERT INTO knb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nagoꞌa veaꞌmoꞌya nagaifema hamau amayamopafima ohamaisiana nagai kemona akavela nomalae. Manima tamaha-nepauva kea nagaiꞌnige kea omalegi hu-na-tenea Nenafa ke hane. ");
INSERT INTO knb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tamakaiꞌenema maineꞌna mani kea ago tamaha-pai-mainoe. ");
INSERT INTO knb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tamaha-pai-mainoanagino Nenafaꞌa nagai nagileꞌma hu-tesia kanomoꞌa, tamayama hisia Alu Aotage Avamulagino emaineno mukiꞌa yana hulamave-liteno mukiꞌa tamaha-pai-mainoa kea alino tamakesa hao hinagetama havigahae. ");
INSERT INTO knb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tama-taleꞌna ugahe tamaipa falu hutama maisaya tamaku tamakesa nelamamue. Nagayama naipa falu huꞌna nemauva nagu nagesa nelamamue. Anima tamaipa falu hutama maisaya yama tamamua yana ma mopale veaꞌmoya amaipa falu nehaya ya kana ohunegi kanaꞌage tamaku tamakesa havitama kolia ohiho. ");
INSERT INTO knb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Tamataleꞌna uteꞌna eteꞌna tamakaitega egahuema.’ huꞌna tamaha-pauva kea ago havilinae. Nagaifema tamahau tamayamopafima nelamahaisigetamahena Nenafa mainelega visua yafena muse haleꞌasine. Nenafaꞌa nagaseno ala kano mainea yafe Nenafa mainelega visua yafena muse haleꞌasine. ");
INSERT INTO knb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tamataleꞌna visua kanafina nagaife havitama tamakupi maletama tamametitima hisaya yafe yaufa ani kana falote ohunea kanafi menia mani kea tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sataniꞌa, ma mopaleꞌma kava hu-mainea kanoa ago neꞌeanagiꞌna nagaya nagoꞌene kea ohugahue. Satanina tokiyaꞌamoꞌa nagaila onagaseneanagi Nenafa nahapai-mainea kava huꞌna faligahue. ");
INSERT INTO knb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nagayama Nenafafema nahau nayamopafi nenagea kavala ma mopale veaꞌmoꞌya havisaya yafe Nenafa naha-pai-mainea kava nehue. Hai nehugi vigetao.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yisasiꞌa mage huno hie “Nagaya tamage huꞌna vaini alagamo nofi maugeno Nenafaꞌa ani vaini alagamo nofi hoyalela yagai-maine. ");
INSERT INTO knb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Agaya mukiꞌa nagai vaini nofi akopaꞌmoꞌa alagama oꞌayea akopaꞌyaga atagi neꞌataleno alagama ayea akopaꞌyaga ‘Nagoꞌene alaga ayesie.’ huno aiꞌa alino hagalo nehie. ");
INSERT INTO knb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tamaha-pai-mainoa kemoꞌa tamakaila ago alino hagalo higeno oniꞌyatamia omalenegi kanale tamahau-maine. ");
INSERT INTO knb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tamakaya nagaiꞌenema ai-gaꞌmaesayana nagaya tamakaiꞌenena ai-gaꞌmaeꞌna maigahue. Nago vaini alagamo nofiꞌmo akopamoꞌma nofiteꞌma ai-okaꞌmaesiana alaga oꞌayegahie. Naꞌa hu-maineafe tamakaya nagaila navaꞌaleꞌma ai-okaꞌmaesayana tamakaya alaga oꞌayegahae. ");
INSERT INTO knb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nagaya vaini alagamo nofi maugetama tamakaya ani vaini alaga nofiꞌmo akopaꞌa mainae. Tamakaya nagaiꞌenema ai okaꞌmaesayana nagoꞌa kanale kavala ohugahae. Kanale kavaꞌma hinutamahena nagaiꞌene ai-kaꞌmaetama maiho. Nagoꞌa veaꞌmoꞌyama nagaiꞌenema ai-gaꞌmaeꞌya maisageꞌna nagayama amakaiꞌenema ai-kaꞌmaeꞌna maisuana kasagoꞌya nofi alagamo kaveꞌa ayegahae. ");
INSERT INTO knb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nagoꞌa veaꞌmoꞌya nagaiꞌenema ai-okaꞌmaesayana oꞌayea vaini nofiꞌmo akopaꞌma atagiꞌya hagaꞌyu hu-talagenoꞌma hagage nehia kava nehae. Ani akopayaga alitalu huꞌya atafi kae-talenae. ");
INSERT INTO knb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tamakaya nagaiꞌenema aigaꞌmaetama maisayana nagai kemoꞌa tamakupina hanesigetama nagoꞌa yafema naha-vi-gesayana naha-vi-gesaya yana hu-lama-tegahue. ");
INSERT INTO knb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tamakayama kasagoꞌya nofi alagamo kaveꞌma aye-gasagoꞌma hisaya yateti Nenafaꞌa ala agia aligahie. Alinagetama-nagitama tamakaya nagaiꞌenema tokaeꞌya nemaiya anaga maigahae. ");
INSERT INTO knb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nenafaꞌa nagaifena hau ayamopafi hau-mainea kava huꞌna tamakaifena aniꞌa huꞌna nahau nayamopafi nenahaiye. Nahau nayamopafima nenahaiya yamo aguꞌafinaga faletama maiho. ");
INSERT INTO knb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nagaya Nenafaꞌma hu-mainea kahegi kema haviꞌnama akave maloa yafe Nenafaꞌa nagaifena hau ayamopafina nehaiye. Tamakaya aniꞌa hutama hu-mainoa kahegi kea havitama akave malesayana tamakaifema nahau nayamopafi nenahaiya yamo aguꞌafinaga faletama maigahae. ");
INSERT INTO knb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nagai naguꞌafima muse yama hanea yana tamakai tamakupi male hava-telama-tesua yafe mani kea tamaha-pai-mainoane. ");
INSERT INTO knb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nahau-mainea kavala mage huꞌna nehue ‘Nagaya tamakaifema nahau nayamopafima nahaiya kava hutama nelama-fugamifena tamahau tamayamopafi tamahainageno aniꞌa huꞌya amakaya tamakaifena hamau amayamopafina hamaino.’ huꞌna tamaumonola nemaloe. ");
INSERT INTO knb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nago kanomoꞌma nefufema ‘Kagai kaugafama ali-gatisua yafene huꞌna nagaya faligahue.’ hunoꞌma hisiana mukiꞌa veaꞌmogami hamau amayamopafima nehamaiya kavala amakasegahie. ");
INSERT INTO knb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nagayama nehua kema akave malenutamahena nagaiꞌni nenafugatama maigahae. ");
INSERT INTO knb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nagaya tamakaifena ‘Aliꞌya vayaꞌnimogatama mainae.’ huꞌna nagoꞌene ohugahue. Nago aliꞌya kanomoꞌa kava kanoꞌamoma aliꞌyama alia aepaꞌa oꞌagenegi nagaya mukiꞌa yama Nenafaꞌma naha-pai-mainea kea ago tamaha-pai-mainoa yafe ‘Aliꞌya vayaꞌnimogatama mainae.’ huꞌna ohugahugi agoꞌma tamaha-nepauva yafe ‘Tamakaya nagai kanapa mainae.’ huꞌna nehue. ");
INSERT INTO knb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tamakaya nagaila nagetama hu-yoꞌokinagi nagaya hagoteꞌna tamakaila tamakeꞌna hu-yogiteꞌna tamakaitami utama Anumaya Koti haisia kava hisaya yafe hu-yogilama-tenoe. Aniꞌama hisaya yapiti alagaꞌa falote huteꞌya agola mainesagetama nagai nagileꞌma Nenafatega havigesayana mukiꞌa havigesaya yana tamamigahie. ");
INSERT INTO knb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kahegi kea mage huꞌna tamaumonola nemaloe nelama-fugamifena tamahau tamayamopafi tamahainageꞌya aniꞌa huꞌya tamakaifena hamau amayamopafi hamaino.” ");
INSERT INTO knb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ma mopale yafema amaugafama aliꞌya nehaiya veaꞌmoꞌya tamakaila kamema hu-lama-tesagetamahena tamakesa hao hinagetama haviho. Hagoteꞌya nagaila aniꞌa huꞌya kamea hu-na-tenayane. ");
INSERT INTO knb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tamakaya ma mopale veaꞌmoꞌya nehaya kavaꞌma hutama mainaleꞌasipa mani mopale veaꞌnemoꞌya hamau amayamopafi tamakaifena hamaileꞌasinagi nagaya ma mopafi vayapiti tamakeꞌna hu-yogi-malenoafe tamakaya mani mopale vea kana veaꞌne omainae. Na yafe ma mopale yafema amaugafama aliꞌya nehaiya veaꞌnemoꞌya amakesa nehaviꞌya kamea hu-nelama-tae. ");
INSERT INTO knb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nagaya mage huꞌna ago tamaha-pai-mainoe ‘Aliꞌya kanoꞌamoꞌa kava kanoꞌamona oꞌagasene.’ huꞌna hu-mainoane. Ani kehe tamakesa havitama maiho. Nagoꞌa veaꞌmoꞌya nagaiꞌma, tamakai kava kanotamimonima, aliꞌya haviyama hu-na-taya kava huꞌya aniꞌa huꞌya tamakaila aliꞌya haviya hu-lama-tegahayanagi nagoꞌa veaꞌmoꞌya nagai kema haviꞌya akave nemalesaya veaꞌmoꞌya tamakai kea aniꞌa huꞌya haviꞌya akave malegahae. ");
INSERT INTO knb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hu-na-tenea kanomona havilama huꞌya ohavinaya yafe ani kavala hu-lama-tegahae. Tamakaya nagai veaꞌnema mainaya yafenagiꞌya ani kavala hu-lama-tegahae. ");
INSERT INTO knb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nagaya eꞌnama kema hama-opauleꞌasina ‘Kefo katia hane.’ huꞌya ohaleꞌasine. Afaꞌa ago me hama-pauvanagi kefo yama hu-mainaya yafena kalagi aiteꞌya agasesaya katamia omalene. ");
INSERT INTO knb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nagaiꞌma kamema hu-na-tesaya veaꞌnemoꞌya Nenafaꞌene kamea hu-neꞌatae. ");
INSERT INTO knb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nagaya amakaipima maineꞌnama nagoꞌa veaꞌmoꞌyama tokiya kavaꞌma ohuleꞌasina ‘Kefo yatia hane.’ huꞌya ohaleꞌasinagi ago alugeꞌya ageteꞌya nagaiꞌene Nenafaꞌenena kamea hu-nelaꞌa-tae. ");
INSERT INTO knb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amakai kahegi kema kae-malenaya kemoꞌa nagaifena mage hu-mainayane ‘Havi kavala ohunegeꞌya kamea afaꞌa hu-neꞌa-tae.’ huꞌya kae-malenayane. Mani kemoꞌa ago falote huno tamage hisia yafe nagaila kamea hu-nena-tae. ");
INSERT INTO knb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nenafategati tamaya hisia vekaꞌa hu-tesugenoꞌma esiana tamageꞌage ke huno tamaha-paisia vekaꞌa, Alu Aotage Avamula Nenafategatiꞌma esiana nagaifena tamaha-paigahie. ");
INSERT INTO knb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tamaha-paigahianagitama nagaya aliꞌyama aepa heꞌna ali-mainoa kanaleti tamakayama nagaiꞌenema mainaya yafe nagaifena veaꞌmogamina hama-paigahae.” ");
INSERT INTO knb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yisasiꞌa mage huno hie “Nagaifema tamakupima ago malenaletiꞌma neꞌataletama alu kate oꞌvisaya yafe mani kea tamaha-pai-mainoe. ");
INSERT INTO knb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Amakaya tamakaila mono nopitila tamavaleꞌya tamanati-talegahae. Ani kanama esia kanafina nagoꞌa veaꞌmoꞌya tamakaila nelamahaeꞌya ma amakesa havigahae ‘Mani kavaꞌma nehunana Anumaya Kotina akave nemalone.’ huꞌya hugahae. ");
INSERT INTO knb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nenafaꞌene nagaiꞌenema amakuꞌa otaꞌaminaya yafe ani kavala hu-lama-tegahae. ");
INSERT INTO knb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ani kanama falote hisia kanafina tamaha-pai-mainoa kemoꞌa tamakesa ai-hagalo hinagetama havilama hisaya yafe menia mani kea tamaha-nepauve. Ehe kanafina tamakaiꞌenema mainoa yafe nayona ani kea tamaha-opainoane. ");
INSERT INTO knb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nagaiꞌma hu-na-tegeꞌna emainoa kanolega menia eteꞌna ugahuanagitama nago vekamoga nagaifena ‘Hanatega neꞌvane?’ huka nahavi-nokane. ");
INSERT INTO knb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nahavi-nokayanagi nagayama tamaha-pai-mainoa kehe tamakesa havitama tamahau nehae. ");
INSERT INTO knb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tamahau nehayanagi tamage-lafa huꞌna tamaha-nepauve nagayama oꞌvisuana tamaya hisia kanoa omegahigi nagayake uteꞌna tamaya hisia kanoa hu-tesugeno tamakaitegama esiana kanale kanaꞌa falote hu-lama-tegahie. ");
INSERT INTO knb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Efaloteꞌma hisiana tamaya hisia kanomoꞌa mukiꞌa ma mopale veaꞌmogami kefo yama nehaya aepaꞌamiene kanale kavaꞌma nehaya aepaꞌamiene Anumaya Kotiꞌa kaiyekema hu-ma-tesia yamo aepaꞌaene hu-falote hisigeꞌya haviteꞌya agegahae. ");
INSERT INTO knb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kefo yamo aepamofena tamaya hisia kanomoꞌa mage huno hugahie ‘Yisasifena havitama tamakupi maletama tamametiti nohaya yafe kefo yatamia hane.’ huno hugahie. ");
INSERT INTO knb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nagaya Nenafa mainelega eteꞌna ugahuanagitama nagoꞌene nagaila onagesayafe tamaya hisia vekamoꞌa kanale kavaꞌma hisaya yamo aepaꞌa hu-falote hinagetama havitetama agegahae. ");
INSERT INTO knb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Anumaya Kotiꞌa ma mopale kava kanoa, Satanina, ago kaiyekea hu-tenea yafe tamaya hisia vekaꞌa Anumaya Kotiꞌma kaiyekema hu-ma-tesia yamo aepamoꞌa hu-falote hinagetama havitetama agegahae. ");
INSERT INTO knb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nagaya kasagoꞌya kea tamaha-paigahe nehuanagi kanaꞌage hu-mainea yafe tamakaya havilama hutama ohavigahae. ");
INSERT INTO knb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ohavigahayanagi Anumaya Kotina tamageꞌage nehia Avamuꞌamoꞌma esiana agaiꞌalegati mukiꞌa Anumaya Koti tamageꞌage kea tamaha-paigahie. Agesafiti kea tamaha-opaigahianagino nehavia keꞌageꞌene haenagama esia kanafima falote hisia yamo kene tamaha-paigahie. ");
INSERT INTO knb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tamaha-painageno ani kanomoꞌa nagayama hu-mainoa kea tamakaila tamaha-paisia yafe nagai nagia tusiya huno ali-saga hugahie. ");
INSERT INTO knb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hugahianagi mukiꞌa Nenafaꞌma malenea yana nagaiꞌniꞌa yamaꞌage fatago huno hanea yafe mage hu-mainoe ‘Alu Aotage Avamuꞌmoꞌa amisua kea alino tamakaila me lamaha-paigahie.’ huꞌna hu-mainoe.” ");
INSERT INTO knb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Osi kana kanoꞌa nagoꞌene onagegahagi osi kana kanoꞌa maitetama etetama nagegahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Higeꞌya nagoꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌamoꞌya amakaiꞌamifina mage hae “Osi kana kanoꞌa onagegahae huno nehuno etetama osi kana kanoꞌa nagegahae huno nehunoꞌma nehia kemona aepaꞌamoꞌa hanaꞌa hu-maine? ‘Nenafatega visua yafe nehue.’ huno nehia kemona aepaꞌa nohavune. ");
INSERT INTO knb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Osi kanaꞌaema hia kemona aepaꞌa naꞌane huno nehie? Tagaya agayama hia kea nohavune.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nehuꞌya havigegahema haya kea Yisasiꞌa ago aguꞌafinaga haviteno mage huno hie “Hua kemoꞌa ‘Osi kana kanoꞌa nagaila onagegahagi etetama osi kanaꞌa maitetama nagegahaema.’ hua kehena tamakaya lamakaya tamakaitamifina mani kemona aepaꞌahe huge havige nehao? ");
INSERT INTO knb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tamage-lafa huꞌna lamaha-pauve tamakaya tamataleꞌnama visua yafena avia ategahayanagi ma mopale veaꞌmoꞌya muse hugahae. Tamakaila hagoteno tamahau hu-tesigetama haenagaꞌa ai-yahae hutama muse hugahae. ");
INSERT INTO knb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aꞌmoꞌma nafaꞌnema ategahema nehuno agatama aisia kana falote hisia yafe hauna hianagi nafaꞌnema ago atetenoꞌa ‘Nafaꞌnea ago atoe.’ huno muse nehuno agatama ai-mainea yafena age-kani-maine. ");
INSERT INTO knb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ani kanamoꞌa tamakaipina hane. Menia tamakaya tamahau nehayanagi eteꞌna tamakesugenoꞌa tamakupina muse yamoꞌa hiya hinageno nago kanomoꞌa ani muse yana tamaha-ofalegahie. ");
INSERT INTO knb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ani kanama evaꞌyima hisiana tamakaya nagaila nago yafena nahavi-okegahae. Tamage-lafa huꞌna tamaha-pauve nagaifema hutama nagai nagima ayetama nago yafema Nenafama havigesayana mukiꞌa havigesaya yana afaꞌa tamamigahie. ");
INSERT INTO knb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nayoꞌene meniene nagaifena nehutama nagia ayetama nagoke yafena Nenafana haviokenayane. Nagi menia muse yatamimoꞌma tamakupina hiya huno hanesia yafena nahavigegeꞌna tamamino.” ");
INSERT INTO knb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mani kea tamakaila avame kefi hu-maleꞌna tamaha-nepauvanagi haenagaꞌa mani avame kea nagoꞌene ohugahuanagiꞌna hu-falote huꞌna Nenafafena tamaha-paigahue. ");
INSERT INTO knb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Hu-falote hisugetama ani kanafina nagai nagile havigegahagi nagaya ‘Tamakaifena Nenafana havigegahue.’ huꞌna ohunogi tamakaya nagaifena tamahau tamayamopafi nelamahaiya yafe Nenafaꞌa tamakaifena hau ayamopafi nehainageno havigesaya yana agaiꞌa tamamigahie. Nagayama Anumaya Kotitegati emainoa kema tamakupi malenaya yafe Nenafaꞌa tamakaifena hau ayamopafi nehaiye. ");
INSERT INTO knb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nagaya Nenafaꞌene mainoleti ma mopafina emainoe. Menia nagaya mani mopa ataleꞌna Nenafatega ugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Higeꞌya agaiꞌaenema tokaeꞌya nemaiya anagaꞌmoꞌya mage hae “E, avame kefiti menia nohanagi hu-falote huka nehane. ");
INSERT INTO knb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Menia tagaya havunana kagaya mukiꞌa yana havimalenane. Mukiꞌa veaꞌmoꞌya amakupima haviya yana ago havimainana yafe nago kanomoꞌa nago yafena kahavi-okesie. Mukiꞌa yana havimainana yafe tagaya kagaifena Anumaya Kotitegati emainane huta tagupi malenone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yisasiꞌa kenonaꞌamilela mage huno hie “Meni tamakaya havitama tamakupina nemaletama tamametiti nehafio? ");
INSERT INTO knb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Haviho nago kanamoꞌa aupaꞌa egahema hia kanamoꞌa ago efalote hu-maine. Ani kanafina nagoke nagokeꞌmogatama nataletama kumatamile ute ete hugahae. Nataletama visageꞌna nagaiꞌnige maigahuanagi Nenafaꞌa nagaiꞌenena maine. ");
INSERT INTO knb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tamakuꞌa namitetama tamaipa falu hutama hilato hutama maisaya yafe mani kea tamaha-pai-mainoe. Ma mopale mainesageno nago kanaꞌage yamoꞌa falote hugahianagi kolia ohiho. Nagaya ma mopafi auꞌava yana ago agaseꞌna kava yagai-mainoe.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisasiꞌa mani kea huteno ikapinaga age-saga hu-maineno Anumayamotega mage huno hie “Nenafagae falisua kanaꞌnia ago efalote hie. Nekamoꞌna kagi ali-saga hisua yafe faliteꞌna he-tiꞌna kagaitega haisua yafe lokiya hale yania nekamonina namio. ");
INSERT INTO knb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nekamonia mukiꞌama naminana veaꞌmogamina agola maige maige hisaya hamaimuꞌamima amamisua yafe mukiꞌa veaꞌmote kava yagaisua tokiyaꞌnia ago naminane. ");
INSERT INTO knb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Anumaya Kotiga kagaikage ala tokiya kanoa tamagemona tamaꞌa nagokeꞌage Anumaya mainanagi veaꞌmoꞌya kagaifema havilama huꞌya maisayana hu-tenana kanoa ‘Yisasiꞌa veaꞌmogami amaku amamemaꞌa ali-gatisia kanoa ikapinagati emainea kano maine.’ huꞌya havilama hisayana maige maige hisaya hamaimula aligahae. ");
INSERT INTO knb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","5","Naminana tokiya hale yatetiꞌa ma mopalela kagia alisaga hu-mainoe. Naminana aliꞌyana ago aliꞌna avaya aye-mainoa yafe Nenafagae meni kanafina kagai kavate mainesugeka tokiya hale yaniꞌa namio. Ma mopama talo ohunana kanafina kagaiꞌene mainoanagiꞌna tokiya hale yania haneanagi menia eteka ani yana namio. ");
INSERT INTO knb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma mopafi veapitiꞌma naminana veaꞌmogamina ago aepakaꞌa hu-falote huꞌna hama-pai-mainoe. Ani veala kagaikaꞌa veaꞌnegika nagaila ago naminane. Naminanageꞌya ani veaꞌmoꞌya kagai kea atafa hu-linae. ");
INSERT INTO knb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Atafa hu-lineꞌya mukiꞌa naminana yana kagaikaꞌalegati emaine huꞌya menia ago havilinae. ");
INSERT INTO knb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Naminana kea ago amamugeꞌya ago atafa huꞌya havilama hulineꞌya nagayama kagaitegatiꞌma emainoa yafena tamage nehie huꞌya havilama hu-lineꞌya kagayama hu-na-tanageꞌna emainoa yafena amakupi maleꞌya amametiti nehae. ");
INSERT INTO knb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amakaifena Nenafagale ke huꞌna kahavi-negoe. Ma mopale yafema amaugafa aliꞌya nehaiya veafe Nenafagale menia kahavi-nokogi kagaikaꞌama naminana veaꞌnea kagai veaꞌne mainaya yafe naminana veafe kahavi-negoe. ");
INSERT INTO knb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nagai veala kagai veale. Kagai veala nagai vea mainageꞌya ani veaꞌnimoꞌyama nagai tokiyaleti haya kavala nehageꞌya mopale veaꞌmoꞌya ageteꞌya nagai nagia alisaga nehae. ");
INSERT INTO knb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ali-saga nehageꞌna menia ma mopaletila ataleꞌna kagaitega ugahuanagi nagaifema amakupi nemalaya veala ma mopafi maigahagi alu aotage Nenafaga kagaika kagileti naminana nagileꞌma hanea tokiyaleti auꞌvai-ma-tesanana taꞌagaya nagoke kanolatama mainoꞌa ya huꞌya amakaya nagoke kate maleꞌya nagoke veaꞌne maisae. ");
INSERT INTO knb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nagaya amakaiꞌene maineꞌna kagayama naminana nagileꞌma hanea tokiyaleti auꞌvai-ma-togeno nagoꞌmoꞌa hani-ki-mainea yapima tegelege nehia atafina oꞌugahagi Anumaya Koti kema kae-malenaya kemoꞌma efalote huno tamagema hisia yafe anima hani-ki-mainea yapima tegelege nehia atafima visia kanoa Yutasiꞌa agaiꞌage ugahie. ");
INSERT INTO knb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Menia eteꞌna kagaitega egahugi nagayama nehua muse yaniꞌamoꞌa amakai amakupina hava-tesia yafe ma mopale maineꞌna mani kea hama-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hama-nepaiꞌna kagai kea ago amaminogi nagaya ma mopafi kanoa omaiꞌnoe. Alu nagu nameꞌene kano mainogeꞌya amakaya nagayama hua kava huꞌya ma mopale veaꞌne kana vea omainae. Alu amaku amameꞌene veaꞌne mainaya yafe ma mopale veaꞌmoꞌya amakaife amaipa kafa he-ma-teꞌya kamea hu-neꞌama-tae. ");
INSERT INTO knb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kamea hu-neꞌama-tayanagi nagaya veaꞌnimogamifena ‘Ma mopaleti amavalesaga huo.’ huꞌna kahavi-nokogi ‘Sataniꞌma aye-mavataga hu yafe auꞌvai-mateka amaugafa ali-gatisanageꞌya kaꞌyeꞌya maisae.’ huꞌna kaha-vi-negoe. ");
INSERT INTO knb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nagaya ma mopale kanoa omaiꞌnoe. Alu nagu nameꞌene kano mainogeꞌya amakaya nagai kana huꞌya ma mopale veaꞌnea omainae. Alu amaku amameꞌene veane mainae. ");
INSERT INTO knb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mainayafe kagaika ke-lamage kekaleti alu aotage veaꞌne maisaya amaku amakesa amamio. Kagayama hu-mainana kemoꞌa tamageꞌage nehie. ");
INSERT INTO knb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kagaya ma mopafima nagaiꞌma hu-natanageꞌna emainoa kava huꞌna naminana veaꞌnea nagaya mopale veaꞌmogami amuꞌnopi ago hu-ma-tenoe. ");
INSERT INTO knb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nagi tamage huꞌya amaku amamemaꞌamona kagaila kamisaya yafe nagaya nagu namemaꞌamona kagaila negamue. ");
INSERT INTO knb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nagaiꞌenema mainaya veaꞌneꞌagefena kahavi-nokogi amakayama hisaya keleti nagaifema haviꞌya amakupi maleꞌya amametitima hisaya veafeꞌene kahavi-negoe. ");
INSERT INTO knb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nenafagae mage huꞌna kahavi-negoe kagaya nagaiꞌenema mainageꞌna nagaya kagaiꞌenema maugetaꞌama huꞌa kava huꞌya nagaifema amakupi malenaya veala nagoke vea kanoꞌa taꞌagaiꞌene maisageꞌya mukiꞌa mopale veaꞌmoꞌya kagayama hu-na-tanageꞌnama emainoa yafema haviꞌya amakupi maleꞌya amametiti hisae. ");
INSERT INTO knb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Taꞌagayama nagoke taꞌaipaleꞌma mauꞌa kava huꞌya nagoke amaipale maisaya yafe naminana tokiya hale yaniꞌa ago amaminoe. ");
INSERT INTO knb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Amakaya nagoke vea kanoꞌa mai-lama huꞌya maisaya yafe nagaya amakaiꞌenena maugeka kagaya nagaiꞌenena mainane. Kagaya hu-na-tanageꞌna emainoa yafema mukiꞌa mopale veaꞌmoꞌya havisaya yafeꞌene nagaifena kahau kayamopafi negahaigeka aniꞌa huka ma mopale veafeꞌene kahau kayamopafi kahau-mainea yama havisaya yafe kagai kema havimalenaya veaꞌmoꞌya nagoke vea kanoꞌa maisae. ");
INSERT INTO knb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nenafagae ma mopama taloma ohunana kanafina nagaifena kahau kayamopafi kahaigekama naminana tokiya hale yaniꞌa nagaiꞌma naminana veaꞌmoꞌya agesaya yafe nagaya maisua kumate maisae huꞌna nehue. ");
INSERT INTO knb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kanaleꞌya huka fatago hu-mainana Nenafagae ma mopale yafema amaugafa aliꞌya nehaiya veaꞌmoꞌya kagaila okagenagi nagaya ago kagaila kage-mainoafe ma ma mainaya veaꞌmoꞌya nagaiꞌma hu-na-tanageꞌna emainoa yafena ago haviꞌya ageꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nagaifema kahau kayamopafi kahau-mainea yana amakai amakupi malesana yafe aepakaꞌa hu-falote huꞌna hama-pai-mainoanagi nagoꞌene hama-paigahue. Nagaya amakupi maisua yafe aepakaꞌa ago hama-pai-mainoe.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisasiꞌa ani kea Anumayamotega havigeteno tuelufuꞌa (12) anagaꞌaene hati-laviꞌya Kitaloni lina mo laꞌkaeꞌya umainae. Atu kaiyaga nago olivi yosa kali-malenaya hoya hanegeꞌya Yisasiꞌa agaiꞌaenema tokaeꞌya nemaiya anagaꞌamoꞌyaene ani hoyafinaga umainae. ");
INSERT INTO knb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Umainayanagi mukiꞌa yupa Yisasiꞌa tuelufuꞌa (12) anagaꞌamoꞌyaenena ani hoyafinaga molitalu huꞌya nemaiya yafe Yutasiꞌa, agesiꞌma huno Yisasina kamema hu-tesia kanomoꞌa, ani hoya ago age-maineane. ");
INSERT INTO knb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Age-maineanagino Yutasiꞌa viaꞌyamo ala mono note kava vayateꞌene* Falasia vayateꞌene vigeꞌya mono note ati vayaꞌene Lomu ati vayaꞌene amigeno amavaleno ani hoyafinaga kaꞌniꞌene lamu kaꞌniꞌene tu hisaya yaꞌene aliꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ayanagi Yisasiꞌa mukiꞌa augafaleꞌma falote hugahema hia yana ago haviteno amakaite viaꞌyamo mo hama-vige “Tamakaya tafe atineꞌayae?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Higeꞌya kenonaꞌa mage huꞌya hae “Nasaleti Yisasife ati-yeta neꞌone.” huꞌya hageno Yisasiꞌa mage hie “Nagaya ma mainoe.” huno higeno agesiꞌma huno Yisasina kamema hu-tea kanoa, Yutasiꞌa, ani vayaꞌene tokaeno maine. ");
INSERT INTO knb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mainegeno Yisasiꞌa “Nagaya ma mainoe.” hunoꞌma hia yafe amakavelegati eteꞌya valega mo fae-laka-ti-mainae. ");
INSERT INTO knb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Fae-laka-ti-tageno Yisasiꞌa nagoꞌene eteno hama-vige “Tafe ati neꞌayae.” huno higeꞌya amakaya nehuꞌya “Nasaleti Yisasife ati neꞌayone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hageno Yisasiꞌa kenonaꞌamia mage hie “Nagaya ago tamaha-nepauve nagaya ma mainoe huꞌna nehue. Tamakaya nagaifema nati neꞌayenutamahena ma ma nagaiꞌenema mainaya vayala amatalegeꞌya afaꞌa viho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yisasiꞌa agoꞌma hu-mainea kea mage huno hu-maineane “Naminana veala nagoke kanoꞌa ata-oꞌayegahie.” huno hu-maineane. Anima hu-mainea kemoꞌa falote huno tamagema hisia yafe Yisasiꞌa “Amatalegeꞌya viho.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Higeno Saimoni Pitaꞌa ayaꞌaya naepeꞌa ali-lianagino alisagino ala mono note hagote kava kanomo aliꞌya kanoꞌa, Malakusina, ai-koligeno tamaga kaiyaga agesa aifa-kali-talegeno asaga hu-lavi-maine. ");
INSERT INTO knb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ai-fakaligeno Yisasiꞌa Pitafena hapaino “Ayaꞌaya naepekaꞌa tafugepi vaiyo. Naugafaene nagu name nagata aisia yaniꞌa satuꞌage hia tima hanea masu keꞌayola Nenafaꞌa naminegi nagaife onesie huka nehano?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lomu ati vayaꞌene ala kava kanoꞌamiene mono note ati vayaꞌene Yisasina atafa huꞌya nofi ki-mainae. ");
INSERT INTO knb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nofi k-iteteꞌya hagoteꞌya Anasite avaleꞌya umainae. Anasiꞌa Kaiyafasina aꞌamona nefa maineanagino Kaiyafasiꞌa ani kafufina ala mono note hagote kava kano maineane. ");
INSERT INTO knb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyafasiꞌa Yuta vayafe mage huno hama-pai-maineane “Kanalele nagoke kanomo mukiꞌa veaꞌmogamitefe huno falisie.” huno hu-maineane. ");
INSERT INTO knb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimoni Pitaꞌene nagola Yisasiꞌenema tokaeno nemaiya kanoꞌene* Yisasina akave anatiꞌana umainaꞌe. Neꞌvaꞌageno mono note kava kanomoꞌa ani Yisasiꞌenema tokaeno nemaiya kanomona ago age-mainea yafe agaya Yisasiꞌene ala mono note kava kanomo no kegiꞌya kovefinaga hai-fale-maine. ");
INSERT INTO knb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Haigeno Pitaꞌa fiate he-tino mainegeno anima Yisasiꞌenema tokaeno nemaiya kanomoꞌa fiateꞌma yagai-mainea munaꞌmofena mo hanepaino Pitana avaleno emaine. ");
INSERT INTO knb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Neꞌegeno fiateꞌma yagai-mainea munaꞌmoꞌa Pitafena mage huno havige “Kagaya mani kanomona tuelufuꞌa (12) vayapiti kano mainano?” huno havigegeno “Aꞌao nagaya ani vayapiti kanoa omainoe.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tusiꞌa yasimo higeꞌya aliꞌya vayaꞌene ati vayaꞌene ata kae-taleꞌya he-tiꞌya tota huꞌya mainageno Pitaꞌa amakaiꞌene atale he-tino augafa tota huno maine. ");
INSERT INTO knb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ala mono noteꞌma hagote kava kanomoꞌa Yisasifena “Kagaiꞌenema tokaeꞌya nemaiya anagakaheꞌene kagayama hu-ma-veli mainana keheꞌene naha-paiyo.” huno havinege. ");
INSERT INTO knb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Havigegeno Yisasiꞌa mage hie “Nagaya mukiꞌa veaꞌmogamina fufute hama-nepauvane. Mukiꞌa yupa Yuta veaꞌnea melitaluma haya mono nopiꞌene ala mono nopiꞌene hama-nepauvane. Fala-kiꞌna hama-opainoe. ");
INSERT INTO knb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Naꞌa higeka nagaila nahavi-negane? Nagai kema nehaviya vayafena hama-nepauva kehena hama-vigo. Nagayama hama-pai-mainoa kea ago havilinae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Higeno nago ati kanomoꞌa he-tino maineleti Yisasiꞌma mani kema nehiana augosafi ai-ko-nelino mage hie “Naꞌa higeka kagaya ala mono note hagote kava kanomo aulagafina mani kea nehane?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Higeno Yisasiꞌa kenonaꞌa mage hie “Kefo kema hu-mainesugekahena nagaya kefo kema hua kea hu-falote huka naha-paiyo. Nagayama kanale kema hu-mainesugekahena naꞌa higeka nai-ko-neline?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Higeꞌya nofiꞌma kitaya nofila kalu he-oꞌa-teneꞌya Anasiꞌa ala mono note hagote kava kanoa, Kaiyafasitega hu-tegeꞌya avaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Neꞌvageno Saimoni Pitaꞌa atale maineno ata lota huno mainegeꞌya agaife mage huꞌya hae “Kagaiꞌenena mani kanomona tuelufuꞌa (12) vayaꞌamopiti kano mainano?” huꞌya hageno Pitaꞌa avane huno mage hie “Aꞌao nagaya ani kanoa omainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Higeno ala mono noteꞌma hagote kava kanomo aliꞌya kanoꞌamona, Pitaꞌma agesama ai-fakali-talegeno asaga hu-lavi-mainea kanomo anagapiti kanomoꞌa mage huno hie “Kagaya Yisasiꞌene hoyafina mainaꞌageꞌna kage-mainoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Higeno Pitaꞌa nagoꞌene avane huno “Aꞌao nagaila onagenane.” huno higeno aupaꞌa kokolemoꞌa age ai-maine. ");
INSERT INTO knb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yisasina Kaiyafasi nopinagati Lomu kamanile ala kava kanomoꞌa kaiyekema hu-neꞌamatea note kegeꞌafiti avaleꞌya umainae. Yuta vayaꞌmogamina mono keꞌamimoꞌa mage huno hu-maine “Afa vayaꞌene tokaetama maisayana amakai kava hutama kefo vaya mainaya yafe ala imu kavela onegahae.” huno hu-mainea yafe Yuta vayaꞌmoꞌya ala imu kaveꞌma mo nesaya yafenagiꞌya ani nopina ohainae. ");
INSERT INTO knb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kumatega mainageno Pailatiꞌa, Lomu kamanile ala kava kanomoꞌa, amakaite eno mage huno hama-vige “Tamakaya naꞌane keleti mani kanoa kaiyekea hu-tegahae?” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Higeꞌya kenonaꞌa mage huꞌya hapaiye “Mani kanomoꞌma kefo kavaꞌma ohuneleꞌasipa avaleta kagaitela omoteꞌasine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hageno Pailatiꞌa eteno mage huno hama-paiye “Tamakaya avaletama tamakaitami mono keleti kaiyekea hu-teho tamakaitami yane.” huno hie. Higeꞌya Yuta vayaꞌmoꞌya mage huꞌya hu-mainae “Kagaya kamanimoga huka taumono malenana kemoꞌa nago kanoa haegeno ofalino.” huka hu-mainane* huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nayona Yisasiꞌa mage huno hu-maine “Nagayama falisua yana yafaga yosale nahaeꞌya nasaesageꞌna faligahue.” huno hu-maineane. Lomu kamani vayaꞌmoꞌyage vayala yafaga yosalela hamaeꞌya asaigeꞌya fali-mainae. Yisasiꞌa agoꞌma hu-mainea kemoꞌa falote huno tamage hisia yafe Yuta vayaꞌmoꞌya mani kea hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hageno Pailatiꞌa ataleno kaiyekema hu-neꞌama-tea nopinaga haino maineno Yisasife ke higeno vigeno mage huno havige “Kagaya Yuta veaꞌnogami sauve kano mainano?” huno havige. ");
INSERT INTO knb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Havigegeno Yisasiꞌa kenonaꞌa mage hie “Kagaya kagu kagesafiti mani kea nehapi ifi nagoꞌa vayaꞌmoꞌya nagaifena kaha-paigekahe nehano?” huno eteno havige. ");
INSERT INTO knb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Havigegeno Pailatiꞌa kenonaꞌa mage huno havige “Nagaya Yuta kano mainogeka nehano? Kagai nofi vayaꞌene ala mono note kava vayaꞌene kavaleꞌya nagaite neꞌaya yafena kagaya na havi kava hu-mainane huꞌna kahavi-negoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Higeno Yisasiꞌa kenonaꞌa mage hie “Nagaya kava yagaisua kumala ma mopafina omalene. Inagi ma mopafima kava yagaisua kumaꞌniꞌama haneleꞌasipa aliꞌya vayaꞌnimoꞌya kamea hageꞌya nagaila navaleꞌya Yuta vayaꞌmogami amayapina onataleꞌasine. Inagi nagaya kava yagaisua kumaꞌniꞌa ma mopafina omalene.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Higeno Pailatiꞌa mage huno hie “Ala sauve kano mainoe huka nehano?” huno higeno Yisasiꞌa kenonaꞌa mage hie “Kagaya nagaife ala sauve kano mainane hukama hana kea tamage nehane. Nagaya itaꞌnimoꞌma natenelegatiꞌma emaineana ke-lamaꞌage hu-falote hisua yafe ma mopafina emainogi ke-lamama haviꞌya amakupi malenaya veaꞌmoꞌya nagayama hua kea nehaviye.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Higeno Pailatiꞌa Yisasife mage hie “Ani ke-lamage kea naꞌane ke?” huno nehuno Pailatiꞌa hati-lavino kumatega viaꞌyamo Yuta vayate mage huno mo hama-paiye “Kefo kavaꞌma hia yana ati ayegetoana omalene. ");
INSERT INTO knb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tamakaya mukiꞌa yupa ala imuma kigahena naha-vigageꞌna nago kanoa kina nopitila afaꞌa avaleꞌna nelamamuanagi na yafe nelamahaiye Yuta veaꞌmogatamina sauve kanotamia afaꞌa atalesugeno visio?” huno hama-vige. ");
INSERT INTO knb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hama-vigegeꞌya ala kefiti mage huꞌya hae “Agaila neꞌataleka Palapasina tamisane.” huꞌya hu-mainae. Palapasiꞌa vaya nehamaeno musufa yamaꞌage hume hume nehaiya kano mainea kanohe hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailatiꞌa Yisasina avaleno “Nofi kaꞌyoteti haifu amiho.” huno hama-paigeꞌya haifu aminae. ");
INSERT INTO knb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","Amiteꞌya ati vayaꞌmoꞌya avetaꞌnafa nofiteti tumano kula talo huteꞌya anute vai-teteꞌya ala kava kanomo fai-neꞌalia augafa haesa kena vai-teneꞌya Yisasiꞌma he-tino mainele eꞌya Yisasifena “Felugae. Yuta vayaꞌmogami ala sauve kanomogae.” huꞌya nehuꞌya augosafi amayateti ainagolapeꞌya nehaeꞌya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hageno Pailatiꞌa kumatega hati-lavino eaꞌyamo alitaluma hu-mainaya Yuta vayafe mage huno hie “Atiyeꞌna agoana nagoke kefo ya kanoꞌa omalegeꞌna tamakaya mani kea havisae huꞌna avaleꞌna tamakaite hati-laviꞌna neꞌoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Higeno Yisasiꞌa kumategama hati-lavino eana avetaꞌnafa nofitetiꞌma talo hu-malaya tumano kula anute vai-teteꞌya haesa kena fai-tetageno hati-lavino elavigeno Pailatiꞌa mage huno hie “Ageho mani kanoa ma maine.” huno hama-pai-maine. ");
INSERT INTO knb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hama-paigeꞌya mono note kava vayaꞌmoꞌyaene ati vayaꞌene Yisasina ageteꞌya ala kegefafiti mage huꞌya hae “Yafaga yosale nili hetama asaigeno falino. Yafaga yosale nili hetama asaigeno falino.” huꞌya hae. Hageno Pailatiꞌa kenonaꞌamia mage huno hama-paiye “Tamakaitami avaletama yafaga yosalela nilia hetama asaiho. Nagaya nago kefo yamaꞌahena ati-yoana omaleanagiꞌna ohaegahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Higeꞌya Yuta vayaꞌmoꞌya kenonaꞌa mage huꞌya hapaiye “Yisasiꞌa agaiꞌahena mage huno hu-maine ‘Nagaya Anumaya Koti nafaꞌne mainoe.’ hunoꞌma hiana tagaipina kahegi kemoꞌa mage hu-maine ‘Maniꞌa augafa kema hisia kanomoꞌa falisie.’ huno hu-maineafe menia Yisasiꞌa mani kema hu-mainea yafe falisie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hageno Pailatiꞌa ani kea haviteno tusiya huno amaꞌyoa neꞌaiye. ");
INSERT INTO knb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Amaꞌyo aigeno Pailatiꞌa eteno kaiyekema nehavia nopinaga hai-faleno maineno Yisasifena mage huno havige “Kagaya hanategati emainane?” huno havigeanagi Yisasiꞌa kenonaꞌa ohune. ");
INSERT INTO knb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ohigeno Pailatiꞌa mage huno hapaiye “Kagaya naꞌa higeka nagelela noꞌaline? Nagaya tokiyaꞌniene kanogiꞌna ‘Kina nopitila atalegahae.’ huꞌnama hisuana afaꞌa katalegahae. ‘Yafaga yosale nili hetama asaigeno falino.’ huꞌnama hisuana aniꞌa hu-ga-tegahae. Kagaya mani kea nohavino?” huno havige. ");
INSERT INTO knb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Havigegeno Yisasiꞌa kenonaꞌa mage huno hapaiye “Anafinaga mainea Anumaya Kotiꞌa kagaiꞌma tokiyama okamineleꞌasipa nagaila natafa ohateꞌasinagi amakayama navaleꞌya kagai kayapima natenaya vayaꞌmogamina kefo yaꞌamimoꞌa kagai kefo yakamona agaseno kasagoꞌya kefo yaꞌami hane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Higeno Pailatiꞌa anima hia kea haviteno “Hanaꞌa huꞌna atalesugeno visie?” huno kafe ati-neꞌayegeꞌya Yuta vayaꞌmoꞌya ala kegefafiti mage huꞌya hu-mainae “Nagoke kanomoꞌa Yisasiꞌma hia kava huno agaiꞌahe ‘Nagaya ala sauve kanoma mainoe.’ hunoꞌma hisia kanomoꞌa Sisana kameꞌa maine. Kagaya mani kanoma atalesanageno visiana kagaya tagaila ala sauve kanotia, Sisana, kanapaꞌa omainane.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hageno Pailatiꞌa ani kema haya kea haviteno Yisasina avaleno hati-lavino kumatega elavino eaꞌyamo ala kaiyekema havi kanomo siale emaine. Ani siama malenaya aupaligahena Yuta vayaꞌmogami kefina Kapatae huꞌya nehae. Ani aupaligahena tagai kefina amalagu aiꞌya yafa malenaya aupaligae huta hugahune. ");
INSERT INTO knb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ani kanafina Anumaya Kotiꞌa amakinagomogami amaugafama ali-gati-mainea yafe Yuta veaꞌmoꞌya amakesa hao hinageꞌya havisaya yafe imu ki kanaꞌamimoꞌa aupa higeꞌya talo tala hisaya yafe yagemoꞌa euno amanutule evigeno Pailatiꞌa Yuta veaꞌmogamina mage huno hama-paiye “Ala sauve kanotamimona ageho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Higeꞌya amakaya ala kegefafiti mage huꞌya hae “Aoteꞌyamaꞌae. Aoteꞌyamaꞌae. Yafaga yosale nili hetama asaigeno falino.” huꞌya hageno Pailatiꞌa mage huno hama-paiye “Nagaya tamakai sauve kanotamia yafaga yosale nili heꞌna asaisue hugetama nehao?” huno higeꞌya mono note kava vayaꞌmoꞌya mage hae “Tagaila nago ala sauve kanotia omaine. Sisaꞌa agaiꞌage nagoke maine.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hageno Pailatiꞌa “Yisasina yafaga yosale nili hetama asaiho.” huno avaleno amayapi amamine. ");
INSERT INTO knb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yisasina avaleꞌya vageno haeꞌya asaisaya yafaga yosa agaiꞌa ko-fino anu ayamufae huꞌya nehaya agoꞌyalega umaine. Ani agoꞌyamo agia Yuta vayaꞌmogami kefina Kologotae huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ani agoꞌyafi avaleꞌya vayaꞌamoꞌya yafaga yosale nilia heꞌya asai-malenae. Tole kanolataꞌene hanaote yafaga yosale aluga aluga atupale hanaeꞌya asai-maleneꞌya Yisasina amuꞌnoꞌanifi nilia heꞌya asai-malenae. ");
INSERT INTO knb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Asai-maletageno Pailatiꞌa nago avona kaeno Yisasina nilima he-malaya yafaga yosale asai-malene. Ani avomoꞌa mage hie “Nasaleti Yisasiꞌe, Yuta vayaꞌmogami sauve kanoa ma maine.” huno kae-malene. ");
INSERT INTO knb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kae-malenegeꞌya Yisasiꞌma yafaga yosale asai-malenaya kaiyaga ala kumaꞌmo aupaꞌale haeꞌya asai-malayanagiꞌya mukiꞌa Yuta veaꞌmoꞌya ani avona hapaliꞌya havimainae. Pailatiꞌa tagufa (3) kefiti kae-malene. Yuta vayaꞌmogami kefitiꞌene Lomu vayaꞌmogami kefitiꞌene Kaliki vayaꞌmogami kefitiꞌene kae-malenegeꞌya hapaliꞌya havimainae. ");
INSERT INTO knb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Haviya yafe Yuta vayaꞌmogami mono note kava vayaꞌmoꞌya Pailatifena mage hae “Kagaya ‘Yuta vayaꞌmogamina ala sauve kanoꞌami ma maine.’ huka okaeka ma ke huka kao ‘Nagaya Yuta vayaꞌmogami ala sauve kanoꞌami mainoe hunoꞌma hia kanoa ma maine.’ huka kao.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hageno Pailatiꞌa mage hie “Kae-malenoa kea hai kae-malenoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ati vayaꞌmoꞌya Yisasina yafaga yosale nili heꞌya asai-maleteꞌya kenaꞌa foꞌa (4) hetaꞌma vaiꞌya ali-mainae. Ayaꞌaya siotaꞌaene aligahe agayana mukiꞌa analegati afetegama lavi-maineana aye ohati siota hane. ");
INSERT INTO knb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ohati siota hanea yafe ani ati vayaꞌmoꞌya kea mohu mehu huꞌya mage hae “Hatata ohuta afaꞌa musufa yama nehaya yokaloa kasi nelesunageno tagasesimoꞌa alisie.” huꞌya amakaiꞌami hu-mainae. Aniꞌama haya kavala Anumaya Koti kefima nayoma kae-malenaya kemoꞌa ago efalote huno tamage nehie. Anima nayoma kae-malenaya kemoꞌa mage humaineane “Kenaꞌniꞌa fako huꞌya neꞌaliꞌya nago kenaꞌniꞌa kasi yokalo-leꞌya amakasesimoꞌa aligahie.” huꞌya kae-malenayane. Kae-malenayanagiꞌya ati vayaꞌmoya mani kavala hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hageꞌya Yisasima asai-malenaya yafaga yosamo avatela Yisasina itaꞌamoꞌene nunaꞌamoꞌene he-ti-mainaꞌe. Anakaiꞌene Kalopasina aꞌamoꞌa Maliaꞌene hamoꞌamoꞌa Magatala kumate Maliaꞌene he-ti-mainae. ");
INSERT INTO knb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","He-ti-mainageno Yisasiꞌa itaꞌamona ageteno agaiꞌenema tokaeꞌya nemaiya anagapiti hau ayamopafima hau-mainea kanomoꞌna, Yoniꞌnae, itaꞌamo avate he-titaꞌa mainoꞌageno taꞌageteno itaꞌamofena “Aꞌmogae namona kagaikaꞌa nafaꞌnekaꞌae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Huteno nagaifena “Namona itakamoꞌe.” huno higeꞌna nagaya ani yupa Maliana yagaigahe noniꞌalega avaleꞌna umainoe. ");
INSERT INTO knb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ani kea huteno Yisasiꞌa “Mukiꞌa aliꞌyaꞌniꞌa ago aliꞌna haꞌno hue.” huno agesafinaga havimaine. Nayoma Anumaya Koti kema kae-malenaya kemoꞌa efalote huno tamagema hisia yafe mage hie “Life nenage.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Higeꞌya nofi alagafiti falote hia tina nagola havate-mai keꞌayola aliꞌya havagoꞌyafa kana yana ani lipi ayeteꞌya kaꞌyote vaiꞌya ali-saga huꞌya Yisasina avayale malenae. ");
INSERT INTO knb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Malageno Yisasiꞌa mayu mayu huno neteno mage hie “Nenafagae naha-pai-mainana aliꞌyana ago aliꞌna haꞌno hue.” huno nehuno ageꞌya ainamagino agu nafaꞌneꞌamo atalegeno vigeno fali-maine. ");
INSERT INTO knb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sapati yupahe talo tala hisaya yupagino ega ala Sapati kana falote hisia yafe Yuta vayaꞌmoꞌya anima yafaga yosaleꞌma hamae-malaya vayaꞌmogami amaugafamoꞌma Sapatileꞌma yafaga yosale hanesia yafena ohamaigeꞌya Pailatife mage huꞌya mo havigae “Ati vayaꞌmoꞌya amaiya ali kofa hisageꞌya aupaꞌa falisageꞌya hipoꞌya huꞌya aliꞌya visae.” huꞌya mo havigae. ");
INSERT INTO knb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hageno Pailatiꞌa ati vaya hama-paigeꞌya mogayana Yisasiꞌenema yafaga yosale asai-malaya kanolatamogani anaiya meli kofa hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ali kofa huteꞌya Yisasina megayana ago fali-mainegeꞌya megeteꞌya aiya ali kofa ohunae. ");
INSERT INTO knb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ali kofa ohageno nago ati kanomoꞌa keveꞌaleti Yisasina haohipafi meyegeno aupaꞌa ani keve kapitila kolamoꞌene timoꞌene taki-lavi-maine. ");
INSERT INTO knb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Taki-lavigenoꞌma age-mainea kanomoꞌa tamaha-nepaiye. Tamaha-nepaiya kea tamageꞌage ke hanea yafe agaiꞌa havilama hu-lineno tamaha-nepaiyafe tamakayaenena Yisasifena havitama tamakupi maletama tamametiti hisaya yafe tamageꞌage ke tamaha-nepaiye. ");
INSERT INTO knb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Nayona Anumaya Koti kema kae-malenaya kemoꞌa mage hu-maineane “Amakaya nago ayamufaꞌa ali kofa ohugahae.” huꞌya kae-malenayane. Nagi nagola Anumaya Koti kema kae-malenaya kemoꞌa mage huno hu-maineane “Haohipafina keveletiꞌma aye-mainea kanomona agegahae.” huꞌya kae-malenayane. Kae-malenaya kemoꞌa falote huno tamagema hia yafe mani kavala hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yosefeꞌa Alimatiyae huꞌya nehaya kumate nemaiya kanogino Yisasi ke havino akave nemalea kanogi Yuta vayafe koli huno Yisasifema ametiti nehia yana fala-ki-lineno mage huno Pailatina mo havige “Yisasina augafaꞌa aligahe nehue.” huno mo havige. Havigegeno Pailatiꞌa “E.” huno higeno Yosefeꞌa viaꞌyamo Yisasina augafaꞌa mo hipoꞌya huno alino emaine. ");
INSERT INTO knb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotimasiꞌa hagoteno Yisasite hanipinaga emainea kanomoꞌa Yosefena mo ha-maegahe kule fuki kana manaꞌage tina tole yosafiti he-fino ali havigu higeno manaꞌage tina falote higeno sigelile mo malegeno tetiꞌa (30) kilo falote higeno alino emaine. Ani tole yosalatamogani anakia meaꞌene aloꞌene alino emaine. ");
INSERT INTO knb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ani tole kanolatamogania vaꞌaꞌyamogani Yisasina augafaꞌa mo hipoꞌya huꞌana mopale maleneꞌana manaꞌage tina fale-teteꞌana kefe kana kenaleti augafalela ai-galaki galaki huꞌana haꞌya kiteꞌana aye-gasagi-malenaꞌe. Mukiꞌa yupa Yuta vayaꞌmoꞌya vayaꞌamima faligeꞌya aniꞌa huꞌya neꞌamataya kava hu-tenaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ani kaiyaga Yisasina yafaga yosale nilima heꞌya asai-malenaya kaiyaga nago hoya hane. Ani hoyafina nagola vayaꞌma he-vai-ma-tesaya yafa kana, yaufa kafi-malenayane. Anifina nago vayala he-vai-oꞌama-tenaya yafa kapi aliꞌya mo he-vai-tenae. ");
INSERT INTO knb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ani yupa Sapatihe haviꞌya talo tala hisaya kanafinagiꞌana ani matimatila aupateꞌma hanea yafe ani tole kanolatamogania Yisasina augafaꞌa aliꞌana anifi mo malenaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sota yupa kola otinegeno Magatala kumate Maliaꞌa natemaꞌa Yisasina he-vai-tenaya komulega umaine. Uno mogeana komumo avayaleꞌma aiso hu-malenaya yafana ago alike-li-talenageno avayalela omalegeno moge-maine. ");
INSERT INTO knb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mogeteno eteno aiya-yeno Yisasiꞌma nehaiya kanoene Saimoni Pitaꞌene mainaꞌale eno mage huno hana-paiye “Alatimona komufitila ago aliꞌya hanatepi atenae.” huno hana-paiye. ");
INSERT INTO knb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hana-paigeꞌana haviteꞌana Pitaꞌene Yisasiꞌma nehaiya kanoene Yisasi komulega umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anaiya-yeꞌana ani komulega vaꞌaleti Yisasiꞌma nehaiya kanomoꞌa Pitana agaseno aupaꞌa komule hagoteno umaine. ");
INSERT INTO knb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uteno mope hu-maineno ageana Yisasina aye-gasagi-tenaya kenaꞌage hanegeno ageanagi anifinaga hai-ofalene. ");
INSERT INTO knb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Hai-ofaleno mainegeno Saimoni Pitaꞌa akave eaꞌyamo ani komufinaga aupaꞌa hai-fale-maine. Haino mogeana nagoꞌa aye-gasagi-tenaya kena neꞌageno anuteꞌma ki-tenaya kenaene Yisasina augafaleꞌma aye-gasagi-tenaya kenaene nagopi tokaeno omalenegi aote kaiyaga aye-gafage-kino malenegeno haino moge-maine. ");
INSERT INTO knb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Neꞌagegeno Yisasiꞌma nehaiya kanomoꞌa komuleꞌma hagoteno umainea kanoa anifinaga hai-faleno mo neꞌageno komufitiꞌma he-ti-mainea yafe “Tamage nehie.” huno havino agupi maleno ametiti nehie. ");
INSERT INTO knb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ani kanafina mukiꞌa anagaꞌamoꞌya Anumaya Koti kema kae-malenaya kea havilama ohunae. Ani kemoꞌa mage huno hu-maine “Yisasiꞌa fali-mainesifiti he-tigahie.” huꞌya kae-malenaya kemona havilama ohunae. ");
INSERT INTO knb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Anakaya Yisasiꞌenema tokaeꞌana nemaiꞌa kanolatana anifinagati hati-laviꞌana noꞌanilega eteꞌana umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliaꞌa ani yafakamo avayale he-tino maineno avi neꞌateno ape huno ani komufinaga aulu heno neꞌage. ");
INSERT INTO knb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ageana tole ensole kanolatana efeꞌage kenaꞌani failiꞌana Yisasi augafama malenaya yate mopale mainaꞌe. Nago kanoa anuma malenalega maigeno nago kanoa aiyama malenalega maigeno hu-mainaꞌageno anake-maine. ");
INSERT INTO knb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Neꞌanakegeꞌana Maliafe mage haꞌe “Aꞌmogae naꞌa higeka avia neꞌatane?” huꞌana havigaꞌageno Maliaꞌa mage huno hie “Alaniꞌamona aliꞌyama mo malaya kumala oꞌagenoa yafe avi neꞌatoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nehuno mai-yahae huno ageana Yisasiꞌa he-ti-mainegeno ageanagi augosafina agelama ohune. ");
INSERT INTO knb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Agelama ohigeno Yisasiꞌa mage hie “Aꞌmogae naꞌa higeka avia neꞌatane? Tafe ati neꞌayane?” huno havigegeno Maliaꞌa agesafinaga mage huno hie “Ma kanoa hoyaleꞌma yagai-mainea kano maine.” huno agesafinaga nehavino mage huno hie “Musekaꞌa nehugi kagayama alika umainenukahena malenesana kumafena naha-paigeꞌna molino.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Higeno Yisasiꞌa mage huno hie “Maliao.” huno higeno ani aꞌmoꞌa maiyahae huno Yuta vayaꞌmogami kefiti mage huno hie “Laponae.” huno hie. Ani kemoꞌa takai kefina “Hu-lave-nelina kanomogae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Higeno Yisasiꞌa mage hie “Nenafa mainelega ohainogi natafa ohuka naganaꞌnimogamina mage huka mo hama-paiyo ‘Nagaiꞌene tamakaiꞌene Nelafatega haigahe nehue. Nagai Anumaya Kotitegaene tamakai Anumaya Kotitegaene haigahe nehue.’ huꞌka mo hama-paiyo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Higeno Magatala Maliaꞌa viaꞌyamo Yisasiꞌenema tokaeꞌya nemaiya anagaꞌamogamina mage huno hama-paiye “Nagaya Alaniꞌamona ago agoe.” huno nehuno “Nage mage huka hama-paiyo.” hunoꞌma hapaiya kea hama-pai-maine. ");
INSERT INTO knb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yisasiꞌa fali-mainefitiꞌma he-ti-mainea Sotamona hanipinaga Yisasina aleveniꞌa (11) anagaꞌamoꞌya Yuta vayafena koliꞌami huꞌya fita kiꞌya tokiyaꞌage hu-maleteꞌya nopinaga alitalu huꞌya mainae. Mainageno Yisasiꞌa evaꞌyi huno amuꞌnoꞌamifi me he-ti-maineno mage hie “Tamaipamoꞌa falu nehinagetama maiho.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hama-paiteno akaiꞌma ayapima nilima he-malenaya afuguꞌene haopafina kevema aye-mainaya afuguꞌene amave-neliye. Amave-ligeꞌya aleveniꞌa (11) anagaꞌamoꞌya Alaꞌamimona ageteꞌya amakuꞌamoꞌa tusiꞌa muse hia kava hae. ");
INSERT INTO knb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hageno Yisasiꞌa nagoꞌene mage hie “Tamaipamoꞌa falu nehinagetama maiho. Nenafaꞌa hu-na-tenea augafa kava huꞌna nagaya tamakaila hu-nela-matoe.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mani kema nehunoꞌa haimula fu huno neꞌamamino mage huno hie “Tamakaila Alu Aotage Avamula nelamamugi avaleho. ");
INSERT INTO knb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nagoꞌa veaꞌmogamina ai-geꞌama-tetama kefo yaꞌamima atale-ma-tesayana Anumaya Kotiꞌa aniꞌa huno ani kefo yaꞌamia ai-geꞌama-teno atale-ma-tegahie. Kefo yaꞌamima ai-geꞌama-tetama atale oꞌamatesaya veaꞌmogamina Anumaya Kotiꞌa kefo yaꞌamia ai-geꞌama-teno atale oꞌama-tegahie.” huno hama-paiye. ");
INSERT INTO knb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yisasiꞌma amakaite evaꞌyima hu-mainea yupa aleveniꞌa (11) anagaꞌafitila nago kanoa amakaiꞌenena omaine. Ani kanoa, Tomasiꞌe, nago agia Titimasiꞌe, tagai kefina kuyave nafaꞌne, ani kanoa omaine. ");
INSERT INTO knb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Omainegeꞌya amakaya “Tagaya Alatimona age-mainone.” huꞌya hane-paigenoꞌa Tomasiꞌa mage hie “Yisasina nilima he-malenaya afuguꞌma oꞌageꞌna, naginagoma nilimo kapima omaleꞌna haopafima keve honomuꞌma aye-malenaya afugupima nayama oꞌvainuꞌnahena mani kea aliꞌna nagupina maleꞌna nametitia ohugahue.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Seveniꞌa (7) kana maiteꞌya Yisasina aleveniꞌa (11) anagaꞌamoꞌya eteꞌya ani nopi mainageno Tomasiꞌa amakaiꞌene maine. Fita kiꞌya tokiyaꞌage hu-malayanagi Yisasiꞌa evaꞌyi huno amuꞌnoꞌamifi me he-ti-maineno mage hie “Tamaipamoꞌa falu nehinagetama maiho.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasifena mage hie “Kaginagoa male me maleka nayapi nafugula ago. Kayana nahaopaleꞌma hanea nafugupina vaika ago. Ageteka tole kagesama havina kagesa neꞌataleka nagaifena havika kagupi maleka kametiti huo.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Higeno Tomasiꞌa mage hie “Kagaya Alaniꞌamogae Anumaya Kotiꞌnimoga mainane.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Higeno Yisasiꞌa mage hie “Kagaya agoꞌma nagana yafe kagupina maleka kametitia nehananagi onagenesaya veaꞌnemoꞌyama haviꞌya amakupi maleꞌya amametitima hisaya veaꞌmoꞌya tusiꞌa muse hugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisasiꞌa aleveniꞌa (11) anagaꞌamogami amaulagafina aluꞌa aluꞌa tokiya avameꞌyaꞌyaga hu-maineanagi ani yana mukiꞌa mani autaꞌmafina okaenoe. ");
INSERT INTO knb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Okaenoanagi manima kae-maloa kea tamakaife huno Yisasiꞌa, Anumaya Kotina nafaꞌneꞌamoꞌa, tagu tamema ali-gatisia kano maine hutamama havitama tamakupi maletama tamametitima hisaya yafe kae-malenoane. Ani yafe havitama tamakupi maletama tamametiti hisayana Yisasi agileti agola maige maige hisaya tamahaimula aligahae huꞌna kae-malenoe. ");
INSERT INTO knb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Haenagaꞌa Yisasiꞌa eteno agaiꞌenema tokaeꞌya nemaiya anagaꞌamogami amaule ma kava huno Taipiliasi tikotumo agegayalega evaꞌyi hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Pitaꞌene, Tomasina nago agia Titimasiꞌe, tagai kefina kuyave nafaꞌne, Natanioloꞌa, Kalili hanea kumala Kena kumate kanoene, tole Sepeti nafaꞌnelataꞌa Yoniꞌene, aganaꞌamoꞌene, tole Yisasina aleveniꞌa (11) anagaꞌaene mainae. ");
INSERT INTO knb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mainageno Saimoni Pitaꞌa mage huno hama-pai-maine “Nagaya noyame kuꞌya hugahe neꞌue.” huno higeꞌya mage hae “Kagaiꞌene ugahune.” huꞌya hapaiteꞌya tipi kalefi hai-saga humaiꞌya ani kegela vayanagi nagoke noyamea oꞌalinae. ");
INSERT INTO knb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Oꞌaligeno yagea hai vaꞌyi hugahe nehigeno Yisasiꞌa ti agegayalega he-ti-maiyanagi agaiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya Yisasiꞌe huꞌya agelama ohunae. ");
INSERT INTO knb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Agelama ohageno Yisasiꞌa mage huno hama-vige “Vae nafaꞌneꞌnimogatama nagoꞌa noyamea neꞌalifi noꞌaliye?” huno hamavi-gegeꞌya “Aꞌao noꞌalune.” huꞌya hapai-mainae. ");
INSERT INTO knb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hapaigeno Yisasiꞌa mage huno hama-paiye “Tamakaya kukonagona tipi kalemona tamaga kaiyagamo haikanagati hagaꞌyu hutama malesayana noyamea aligahae.” huno hama-paigeꞌya kukonagona aniꞌa huꞌya hagaꞌyu hayana tusiꞌa noyame aligeno kanaꞌage higeꞌya alisaga hisaya yafena tusiꞌa ya hu-mainae. ");
INSERT INTO knb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yisasiꞌenema tokaeꞌya nemaiya anagapiti nehaiya kanoꞌamoꞌa Pitana mage huno hapaiye “Agaya Alatimoꞌe.” huno hapaiye. Hapaigeno Saimoni Pitaꞌa anima hia kea nehavino aupaꞌa augafale anoꞌya asagi-taleno aliꞌyana neꞌalileti eteno aupaꞌa alino vai-lino tipina asaga hu-lavino Yisasitega neꞌvie. ");
INSERT INTO knb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Vigeꞌya ani tipi kalea aluꞌalelomagi vani hataleti (100) mita aupaꞌale maineꞌya nagoꞌa Yisasiꞌenema tokaeꞌya nemaiya anagaꞌamoꞌya kukonagona avayu huꞌya ti agegayalega emainae. ");
INSERT INTO knb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ti agegayalega me maleteꞌya agayana ata nelegeno nago noyamene hame mayaene ani atafina hanegeꞌya age-mainae. ");
INSERT INTO knb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Neꞌagageno Yisasiꞌa mage huno hama-paiye “Menima aliya noyamefitila nagoꞌa alitama eho.” huno hama-pai-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hama-paigeno Saimoni Pitaꞌa tipi kalefi hai-saga hu-maino kukonagona avayu huno ti agegayalegama eana kasagoꞌya noyame, vani hataleti fifiti taliꞌa (153) noyameyaga ani kukonagopina hiya hu-maiyanagi ani kukonagomoꞌa ailagatoa ohune. ");
INSERT INTO knb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yisasiꞌa mage huno hama-paiye “Tamakaya etama kavela me neho.” huno hama-paigeꞌya agaiꞌenema tokaeꞌya nemaiya anaga amamaꞌyoma aiya yafe “Kagaya lagae.” huꞌya haviokenagi “Alatimo maine.” huꞌyama amakesafinaga haviya yafe haviokenae. ");
INSERT INTO knb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yisasiꞌa atale eaꞌyamo hame mayaene noyamene melino amamine. ");
INSERT INTO knb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yisasina komufima he-vai-tageno etenoꞌma he-ti-maineana tole yupa age-mainaleti eteno mani kavaꞌma hiana napa tali (3) kanale evaꞌyi higeꞌya agaiꞌenema tokaeꞌya nemaiya anagaꞌamogata taulagafiti age-mainone. ");
INSERT INTO knb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kavela netageno Yisasiꞌa Saimoni Pitana mage huno havige “Saimonigae Yoni nafaꞌnemoga kagaya ma vayala amakaseka nagoꞌene kaguꞌa nenamino?” huno havige. Havigegeno Pitaꞌa mage huno hie “E, Alaniꞌamogae kagaya ago nehavine kagaifena nenahaiye.” huno higeno Yisasiꞌa mage huno hapaiye “Kagaya nagai sipi sipi nafaꞌneyaga kavela amamio.” huno hapai-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hanepaino nagoꞌene mage huno hie “Saimonigae Yoni nafaꞌnemoga kaguꞌa havika ago nenamino?” huno havigegeno Pitaꞌa mage huno hapaiye “Kagaya ago nehavine nagaya kagaifena nenahaiye.” huno higeno Yisasiꞌa mage huno hapaiye “Kagaya sipi sipiyagaꞌnilela kava yagaiyo.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hapaiteno nagoꞌene napa tali (3) kanale mage huno havige “Saimonigae Yoni nafaꞌnemoga nagaifena negahaiyo?” huno higeno napa tali (3) kanaleꞌma “Kagaya nagaifena negahaiyo?” hunoꞌma havigea yafe Pita aipamoꞌa kanaꞌage higeno mage huno hie “Alaniꞌamogae mukiꞌa yana ago havi-mainane. Nagaya kagaifema nenahaiya yafena ago nehavine.” huno hapaigeno Yisasiꞌa mage huno hie “Kagaya sipi sipiyagaꞌnia kavela amamio.” huno hapai-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Hapaiteno mage hie “Tamage-lafa huꞌna kaha-pauve kagaya neyama maineka kamu nofila ki-takalo hu-maleteka ‘Visue.’ hukama hana kumatela neꞌvananagi haenagaꞌa kosunama lesanana kayana alisaga hu-linesanageꞌya nagoꞌa vayaꞌmoꞌya kenaka fai-ga-teteꞌya ‘Oꞌugahuema.’ hukama nehisana kumatela afaꞌa kavaleꞌya ugahae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Anima hia kemona aepaꞌamoꞌa mage huno hu-maine “Haenagaꞌa kefo vayaꞌmoꞌya katafa huꞌya kahaesagekama falisana yateti Anumaya Kotina ala agi amigane.” huno aepaꞌa huteno Yisasiꞌa Pitafena “Nakave eno.” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yisasiꞌene tokaeꞌya nemaiya anagapiti hau ayamopafima hau-mainea kanoa kaveꞌma ne-mainaya yupa Yisasina avaꞌale maineno mage huno havige-maineane “Alaniꞌamogae kagaila kagesiꞌma huno kamema hu-ga-tesia kanoa hana kanomoꞌe?” huno havigea kanomoꞌa Yisasiꞌene Pitagani anakave neꞌvigeno Pitaꞌa maiyahae huno age-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ageteno Pitaꞌa Yisasina mage huno havige “Alaniꞌamogae ani kanoa haenagaꞌa hana augafa kava hugahie?” huno havige. ");
INSERT INTO knb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Havigegeno Yisasiꞌa mage huno hapaiye “Nakaiꞌma nahaisigeꞌnama ma mopafima eteꞌna esua yupa afaꞌa mainesigeꞌnama esuana kagai yano? Kagaya nakave eno.” huno hapaiye. ");
INSERT INTO knb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hapaiya kemoꞌa anagaꞌamogamipina mani kema hia kemoꞌa ute ete higeꞌya mage hae “Yoniꞌa ofaligahie.” huꞌya hayanagi Yisasiꞌa “Ofaligahie.” huno hu-oꞌa-tenegi “Nagaiꞌma nahaisigeꞌna ma mopafima eteꞌna esua yupa afaꞌa mainesigeꞌnama esuana kagai yano?” huno hu-maine. ");
INSERT INTO knb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ani kema hayana Yoninihe hu-maine. Nagaya mukiꞌa Yisasiꞌma hu-mainea kavafena tamaha-nepaiꞌna avona kae-malenoe. Nagayama nehua kea tamage-lafa huꞌna havilinoa ke tamaha-nepauve. ");
INSERT INTO knb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisasiꞌa mukiꞌa alu ya alu yana hu-maineanagi nagoꞌa vayaꞌmoꞌya mani kema mukiꞌa nagoke nagoke avopima kayaleꞌasina mani avoꞌyagamoꞌa kasago higeꞌya malesaya kumaꞌmoꞌa mukiꞌa ma kotega nagesa havuana hiya hileꞌasine huꞌna nehue.");
INSERT INTO knb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofilasigae hagoteꞌna kaemalenoa autaꞌmafina Yisasiꞌma aepa heno ali-mainea aliꞌyaꞌene humaveli-mainea kene Anumaya Kotina Alu Aotage Avamuꞌmo tokiyaleti “Naꞌa maꞌa kava hiho.” huno Aposolo vayala* (agai kema nehavigeno humatenea vayala)* hamapaiteno ikapinaga haimainea yafeꞌene ago kaeꞌna kahapai-mainoe. ");
INSERT INTO knb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yisasiꞌa tusiꞌa augafa agataiya alino faliteno hetino Aposolo vayaꞌmogami amaulagale efalote huno fali-mainefitiꞌma hetino mainea yafena havise huno kasagoꞌya tokiya kavaꞌage humaine. Fotiꞌa (40) yupa mopafina maineno efalote huno amaveliteno amataleno uteno eteno efalote huno Anumaya Kotiꞌma kava yagaisia yafena hamapai-maine. ");
INSERT INTO knb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Amakaiꞌenema mainea kanafina mage huno hamapai-maine “Tamakaya Yelusalemu kumala ataletama oꞌviho. Nenafaꞌma ‘Nago kanoa tamamigahue.’ hunoꞌma humainea kanoa avaletetama viho. Nagaya ani kanohena ago tamahapai-mainoane. Yoniꞌa titeti falelamateneanagi tamakaya aupa kana kanoꞌa maisayana Nenafana Alu Aotage Avamuꞌamoteti falelamategahie.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ani yupa Aposolo anagaꞌmoꞌya alitalu huꞌya maineꞌya Yisasifena mage huꞌya havinegae “Alatimogae menia ma kanafina Lomu kamani vayaꞌmogami amayapitila Isaleli vayaꞌmogati hafaleka kagaikaꞌa kava yagailatesanageno tokiyaꞌage hisifi?” huꞌya havinegae. ");
INSERT INTO knb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Havigageno Yisasiꞌa mage huno hie “Nenafaꞌa agaiꞌa tokiyaleti ‘Ma kanaene mukiꞌa kanafiꞌene maꞌa kava hugahue.’ huno huteno yagai-mainegi agayama hisia yana tamakaya havisaya yana omalene. ");
INSERT INTO knb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Omalenegi Anumaya Kotina Alu Aotage Avamuꞌamoꞌma tamakaiteꞌma esiana tokiyaꞌa tamamisigetama nagai kea Yelusalemuene mukiꞌa Yutia kotegaene Samelia kotegaene mukiꞌa ma mopamo atupale mainaya veaꞌnenena nagaifena hamapaigahae.” huno humaine. Yisasiꞌa ikapinaga haimaine. ");
INSERT INTO knb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mani kea huno haꞌno huteno ageꞌya mainageno mopaleti haino haino haigeno nako siaꞌmoꞌa melino aiso hulino avaleno haimaine. ");
INSERT INTO knb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Haigeꞌya amakaya ikapinaga agesaga huꞌya ageꞌya maiya anayufi tole kanolatana efeꞌage kena failiꞌana efalote huꞌana amakaiꞌene anile heti-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hetiꞌana mage huꞌana haꞌe “Kalili kumate veaꞌmogatama naꞌa higetama heti-mainetama ikatela aulula maitama nehae? Yisasiꞌa tamataleno ikapinaga ago haiyanagi manima ikapinaga haiya avamete huno eteno elavisigetama agegahae.” huꞌana hamapai-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Amakaya Olivi yosa hanea agoꞌyaleti taviteꞌya aupaꞌale lagiꞌya vani kilomita vayaꞌamoꞌya Yelusalemua uvaꞌyi humainae. ");
INSERT INTO knb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Uvaꞌyi huteꞌya nemaiya nona folamo huꞌya ana yapi kimale nopi haiꞌya mainae. Haiꞌya mainaya vayaꞌmogami amakia Pitaꞌe Yoniꞌe Yemesiꞌe Etaluꞌe Filipiꞌe Tomasiꞌe Patolomiuꞌe Matiuꞌe Alafiusi nafaꞌnea Yemesiꞌe Saimoniꞌe kanomona nako agia Selotiꞌe Yutasiꞌa Yemesi nafaꞌnene haiꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ani vayaꞌene aꞌneyagaene Maliaꞌa Yisasina itaꞌamoꞌene Yisasina aganaꞌamoꞌyaene nagoke amaku amakesale maineꞌya mukiꞌa yupa Anumayamotega muse huꞌya nunamu humainae. ");
INSERT INTO knb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ani kanafina Yisasifema haviꞌya amakupi maleꞌya amametiti humainaya veala, vani hataleti tuetiꞌa (120) veaꞌne, mainageno Pitaꞌa amakai amuꞌnopi heti-maineno mage huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nafuꞌnaganagatama Anumaya Kotina Alu Aotage Avamuꞌamoꞌa Teviti avayafiti hufalote huno nayona Yutasife humaine. Yisasima atafa hisaya kama amavelisia kanohe, aune laga humaine. Ani kemoꞌa ago falote huno tamage humaine. ");
INSERT INTO knb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ani kanoa, Yutasiꞌe, Yisasiꞌenema tokaeta nemauna anagapi maineno Yisasi kea nehavigeno aliꞌyatela hutenea kano maine. ");
INSERT INTO knb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ani kanoa, Yutasiꞌe, kefo yama hia yamo anonaꞌa mone aliteno mopa miya humaleteno ani mopafi agoꞌya faigeno aipamoꞌa aitalaga higeno mukiꞌa aipamoꞌa helafi lavi-maine. ");
INSERT INTO knb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Helafi lavigeꞌya mukiꞌa Yelusalemuma mainaya veaꞌmoꞌya ani kea haviteꞌya ani mopamo agia amakaiꞌami kefina ‘Akelatama.’ huꞌya humainae. Tagai kefina ani agia ‘Kolama lavi-mainea kumale.’ huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tevitiꞌma yagamema humainea autaꞌmafina, Samupina, mage huno kae-maleneane ‘Agaiꞌama nemaiya kumala vaya omaino yu kuma hapaesie.’ huno kae-maleneane. Ani kemoꞌa nago kaiyaga mage huno humaineane ‘Alu kanomoꞌa agai aliꞌyatela alisie.’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ani yafe nago kanomoꞌma Yoniꞌa tima falematenea kanaleti aepa heno Anumayatia Yisasiꞌene tagaiꞌenema vaiyatete huno huno egenoꞌma Yisasiꞌa ikapinaga haimainea yupa tagaiꞌenema nemaiya vayapiti nago kanoa Yisasiꞌma fali-mainefitiꞌma heti-mainea kema hamapaisiafe ani aliꞌyatela alita hetitesune.” huno Pitaꞌa humaine. ");
INSERT INTO knb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Higeꞌya amakaya tole kanolafe “Anakayae.” huꞌya hageꞌana nago kanoa, Yosefe Pasapasiꞌe kanomona, nago agia Yasatusiꞌe, nago kanoa Matiasiꞌe huꞌya anakia ayemainae. ");
INSERT INTO knb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ayeteꞌya Anumayamotega mage huꞌya havinegae “Anumayamoga kagaya mukiꞌa vayaꞌmogami amakuꞌafina ago age-mainane. Yutasiꞌma haiya kavaꞌma huteno tataleno havi kapi umainea yafe anonaꞌale alu kanomoꞌa hetino Aposolo kano maisie huta nehune. Kagaya ani kanolatapitila hana kano ago hapalika huneꞌatane? Huneꞌatana kanoa tavelio.” huꞌya havinegae. ");
INSERT INTO knb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nunamuna huteꞌya anakia aote yate kaeteꞌya yopafi maleneꞌya nagoke avayu huꞌya agayana Matiasi agi avayu huteꞌya ani kanoa avaleꞌya hetitageno Aposolo vayapi maine. ");
INSERT INTO knb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yisasiꞌa ago falitegeꞌya seveniꞌa (7) sota maiteꞌya vitimo afulea kanahe muse haya imu kiya kanafina mukiꞌa Yisasi veala nago nopi alitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mainageno aupaꞌa ikapinagati ala age neꞌaino ala yasimoꞌma huhu huhu nehia kava huno age neꞌaino anima mainaya nopina me hiya humaine. ");
INSERT INTO knb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hiya higeꞌya agayana atamo anefe kana yamoꞌa hamaote hamaote amaugafale mo kaꞌmaemaine. ");
INSERT INTO knb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mo kaꞌmae-mainegeno Alu Aotage Avamuꞌmoꞌa eno mukiꞌamogami amakupina me hiya higeꞌya amakaya aepa heꞌya Alu Aotage Avamuꞌmo hamapaigeꞌya amaku amakesafiti nohaviya kea alu ke alu ke humainae. ");
INSERT INTO knb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nehageꞌya ani yupa kasagoꞌya Anumaya Koti kema nehaviya Yuta vayaꞌyaga mukiꞌa kotegati eꞌya Yelusalemu melitalu humainae. ");
INSERT INTO knb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ani vayaꞌmoꞌya ikapinagatiꞌma ala agegefa aigeꞌya haviteꞌya melitalu huꞌya haviyana ani nopima mainaya veaꞌmoꞌya alu ke alu ke maiꞌya nehageꞌya alu kotegatiꞌma emainaya veaꞌmoꞌya mage hae “Nagai ke nehie. Nagai ke nehie.” huꞌya tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Amamaꞌyo neꞌaiꞌya amakesa havi havi huꞌya mage hae “Mani kema nehaya vayaꞌmoꞌya Kalili vaya mainayanagi hanaꞌa huꞌya tagaiti itatimoꞌya nelafaꞌya nehageta nehavuna kefitila hageta nehavune. ");
INSERT INTO knb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Tagaya ma kumaꞌyagaleti emainone Patiaꞌene Mitiaꞌene Elamiene Mesopotemiaꞌene Yutiaꞌene Kapatosiene Potusiene Esiaꞌene Filigiaꞌene Pamafiliaꞌene Isipiene Sailinia aupaꞌale Lipia kotegatiꞌene Lomuene Kalitiene Alepiaꞌene naꞌa kotegati emainonagi Yuta vayaꞌene Yuta vayaꞌmogami Anumaya Kotiꞌamimo ke havilinaya vayaꞌene emainonagi tahaote tahaote ketifiti Anumaya Koti tokiyaleti humainea kavafe tahapai-mainae.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","13","Hageꞌya mukiꞌa veaꞌmoꞌya tusiꞌa amamaꞌyo neꞌaiꞌya tusiꞌa amakesa nehaviꞌya nagoꞌa veaꞌmoꞌya mage huꞌya hae “Ani kavaꞌmona aepaꞌa naꞌane?” huꞌya hayanagi nagoꞌa veaꞌmoꞌya havigu ke nehuꞌya mage hae “Amakaya havilina vaini nofi alagamo timaꞌa neteꞌya aneginagi nehae.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pitaꞌa aleveniꞌa (11) Aposolo vayaꞌene heti-maineno ala kefiti mage huno humaine Yuta nafuꞌnaganagatamaene Yelusalemuma mainaya veaꞌnene nago ke tamahapaigahugi haviho. ");
INSERT INTO knb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tamakaya tamakesa haviyana mani veaꞌmoꞌya havilina vaini li neꞌya aneginagi nehae hutama nehafi? Aꞌao menia natekefa naeni kiloki nehigi havilina onenae. ");
INSERT INTO knb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Onenagi menima agaya yafena nayona Anumaya Koti aune kanomoꞌa Yoeliꞌma humainea kemoꞌa mage huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Anumaya Kotiꞌa mage huno humaine “Mani kanamoꞌa aupaꞌama haꞌno hugahema hisia kanafina nagaya Alu Aotage Avamuꞌnimona mukiꞌa veaꞌnemogamina amamigahue. Amamisugeꞌya tamakai nafaꞌnemoꞌene munaꞌnemoꞌene Anumayamo avayafiti hamapai-mainea kea hisageꞌya neyaꞌvetamimoꞌya himona kana yaꞌyaga feluga neꞌagesageꞌya kosunatamimoꞌya himona agegahae. ");
INSERT INTO knb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","He, nagaya Alu Aotage Avamula aliꞌya veaꞌnimogamina vene aꞌnene amamisugeꞌya Anumayamo avayafitiꞌma hamapai-mainea kea tamahapaigahae. ");
INSERT INTO knb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nagaya ikateꞌene ma mopafiꞌene tokiya avameꞌyama hisua yana kolaꞌene ataene halinaene tamaveligahue. ");
INSERT INTO knb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tamavelitesugeno yagemoꞌa ayesu hinageno ikaꞌmoꞌa kolamaꞌage hisigeno Anumayamoꞌma esia kanafina tusiꞌa tokiyaꞌaene hale yamaꞌaene efalote hugahie. ");
INSERT INTO knb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Efaloteꞌma hinageꞌya mukiꞌa veaꞌmoꞌya Anumayamo agi neꞌayeꞌya ‘Kalagi ailato.’ huꞌya nehisageno Anumaya Kotiꞌa amaku amamena aligatigahie.” huno kae-maleneane. ");
INSERT INTO knb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isaleli vayaꞌmogatama nago kea tamahapaigahugi haviho “Nasaleti Yisasiꞌe, Anumaya Kotitegati emainea kano maine.” hutama havisaya yafe Anumaya Kotiꞌa aya higeno tusiꞌa tokiya avame yana tamakaipina ago ali falote higetama age-mainae. ");
INSERT INTO knb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Agayanagi Anumaya Kotiꞌa nayona havino “Naꞌa maꞌa hugahue.” huno haꞌya kimaleteno tamayapi ategetama Anumaya Kotiꞌa hutenea kava hutama ani kanoa, Yisasina, kefo vayaꞌene yafaga yosalela nilia hetama asaitetama hayageno fali-maine. ");
INSERT INTO knb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Falimaineanagi falimainea yamoꞌa atafa huno atakalo ohune. Anumaya Kotiꞌa anima agata yama alino falimainea yapitila kalu heno ali hetitene. ");
INSERT INTO knb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nayona Tevitiꞌa Yisasiꞌma falimainesifitiꞌma alino heti-tesia yafena mage huno humaineane “Mukiꞌa kanafina Anumayaniꞌamoꞌa nagaiꞌene maineno tamaga nayategama mainea yafena kolia ohugahue. ");
INSERT INTO knb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nagaiꞌenema nemaiya yafena nagu nafaꞌnemoꞌa tusiꞌa muse nehigeꞌna agia alisaga nehue. Yoka faliteꞌna hetigahue huꞌna nametitia nehue. ");
INSERT INTO knb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Anumaya Kotigae ‘Alu aotage kanoe.’ huka hunatenana kanomonia naugafa kasalisia yafe fali-mainaya veaꞌne mainaya kumatela natalesanageꞌna oꞌvisua yafe nametitia nehue. ");
INSERT INTO knb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kagaya agola maige maige hisua kana ago navelinageꞌna age-mainoafe kagaiꞌenema maisua yafena aluya huꞌna musena hugahue.” Teviti mani kea humaineane. ");
INSERT INTO knb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pitaꞌa nagoꞌene mage hie “Nenafugatama hufalote huꞌna tamahapaisue taginagomoꞌa Tevitiꞌa ago faligeꞌya hevaitenae. Hevaitenaya komua tagai amuꞌnopi hanegi akaiꞌahe mani kea ohuneane. ");
INSERT INTO knb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Ohunegi Anumaya Kotiꞌa agaife mage huno hulokiya vaino kea humaineane ‘Kagai kaginagomopiti nago kanomoꞌa hetino eteno kagai kumate veaꞌnea kava yagaimategahie.’ huno humaineane. Humaineanagi Tevitiꞌa Anumaya Koti aune kano maineanagino Kalaisiꞌa, Anumaya Kotiꞌma taugafa aligatigahe hutenea kanoa, fali-mainefiti hetigahie huno aune laga huno mage huno humaine. Kalaisife ‘Augafaꞌa kasalisia yafe fali-mainaya veaꞌne nemaiya kumatela oꞌategane.’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ani kanoa, Yisasina, Anumaya Kotiꞌa fali-mainefiti eteno ago alino hetitegeta age-mainona yafe tamahanepaune. ");
INSERT INTO knb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anumaya Kotiꞌa ali hetiteno avalesaga huno agaiꞌa tamaga aya kaiyagaꞌa uhagote mainaya vaya mainalega ateteno ‘Tamamigahue.’ hunoꞌma humainea kanoa, Alu Aotage Avamuꞌa, amigeno aliteno Yisasiꞌa ani Alu Aotage Avamula eteno lamigeta mani kavala hunagetama neꞌagae. ");
INSERT INTO knb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Tevitiꞌa mage huno humaineane Anumaya Kotiꞌa Anumayaniꞌamofena mage huno humaine ‘Tamaga nayatega uhagote mainaya vaya mainalega mopale emainesanageꞌna kame vayakaꞌa kaiyafi amatesugeꞌya ani kame vayaꞌmoꞌya kagaifena ago tagasane.’ huꞌya hugahae.” huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ani yafe Isaleli vayaꞌmogata havilama huta havisune. Ani Yisasina tamakayama yafaga yosalela nilia hetama asai-malenaya kanomofe Anumaya Kotiꞌa mage huno humaine ‘Ani kanomoꞌa Anumaya maineanagi nagaya hutogeno emainea kano maine.’ huno humaine.” huno nehie. Kasagoꞌya ve aꞌmoꞌya amakuꞌa aiyahae hageꞌya tina falematenae. ");
INSERT INTO knb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitaꞌma hia kemoꞌa amakupi ayegeꞌya haviteꞌya Pitaꞌene nagoꞌa Aposolo vayaꞌenefe mage huꞌya hae “Nelafugatama menia hanaꞌa hisune?” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hageno Pitaꞌa mage huno hie “Tamakaya mukiꞌamogatama tamakuꞌa aiyahae hutama egeta Yisasi Kalaisi agile tina falelamatano. Aniꞌama hisagenoꞌa Anumaya Kotiꞌa aigetamateno kefo yatamia atalelamateno Alu Aotage Avamula tamamigahie. ");
INSERT INTO knb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","‘Tamamigahue.’ huno humainea kea tamakaife nehigi tamakayaene nafaꞌnetamiene Yuta vea omainaya veaꞌnenefe mani kea huno mukiꞌa Anumaya Kotiꞌa kema humatesia veaꞌmogamife ‘Tamamigahue.’ humaineane.” huno Pita mani kea humaine. ");
INSERT INTO knb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitaꞌa mani kea nehuno alu ke alu ke huno kanaꞌye kanaꞌye huno mage huno hie “Meni kanafima mainaya veaꞌmoꞌya tusiꞌa kefo kava maiꞌya nehagi havigu tamakaya kefo kava huyafenagi atalegeno Anumaya Kotiꞌa tamaku tamamena aligatino.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Higeꞌya nagoꞌa veaꞌmoꞌya tali tauseniꞌa (3,000) veaꞌmoꞌya mani kea haviteꞌya aliꞌya amakupi maleꞌya amametiti hageꞌya ani yupa lina falematenae. Yisasife amakupi nemalaya veaꞌmoꞌya tokaeꞌya kanale kava nehae. ");
INSERT INTO knb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Lina falematageꞌya amakaya mukiꞌa yupa nago amaku amakesa haviꞌya Aposolo vayaꞌmogami kea haviꞌya hameꞌya maya kofa huꞌya nete nete nehuꞌya Anumayamotega muse huꞌya nunamuna nehae. ");
INSERT INTO knb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nehageꞌya mukiꞌa veaꞌmoꞌya tusiꞌa amamaꞌyo neꞌaigeꞌya Aposolo vayaꞌmoꞌya kasagoꞌya tokiya avame yana nehae. ");
INSERT INTO knb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mukiꞌa Yisasi kema haviꞌya amakupi maleꞌya amametitima humainaya veaꞌmoꞌya nagoke amaku amakesa haviꞌya mukiꞌa yaꞌyagaꞌamihena “Nagaiꞌnige yane.” huꞌya ohunagi “Mukiꞌa yana lagaiti ya hane.” huꞌya nehae. ");
INSERT INTO knb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mopaene afenoꞌyaꞌamienema hanea veaꞌmoꞌya atalageno alu kanomoꞌa miya higeꞌya monea aliteꞌya fako hute hute huꞌya kaveꞌamima omalenea veala amaminae. ");
INSERT INTO knb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Mukiꞌa kanafina nagoke amaku amakesa haviꞌya ala mono nopina neꞌuꞌya alu nopina alu nopina uꞌya hameꞌya maya kofa huꞌya kaveꞌene nete nete nehuꞌya muse huꞌya Anumaya Koti agia alisaga nehageꞌya mukiꞌa veaꞌnemoꞌya ageteꞌya “Kanale kava nehae.” huꞌya nehageno Anumayamoꞌa nago kanafina nago kanafina nagoꞌa veaꞌnea amaku amamena aligatiteno “Nagai ke nehaviya veaꞌene maiho.” huno humatene. ");
INSERT INTO knb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nago yupa une kanalega tali (3) kiloki Pitaꞌene Yoniꞌene nunamu hisaya kanamoꞌa aupa higeꞌana ala mono notega umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Neꞌvaꞌageꞌya vayaꞌmoꞌya nagola kali kanoa, atenelegati aiyamoꞌa haviya humainea kanoa, avaleꞌya emainae. Mukiꞌa kanafina anima aiyama haviya humainea kanomoꞌa ala mono nomo fiate mopale nemaiyane. Ani fiamo agia koganali fiane huꞌya agia neꞌayaya fiate maineno ala mono nopima vaya veafena “Monea namiho.” huno ayana haꞌya hulineno aukaꞌya nehia kanoe. ");
INSERT INTO knb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ani kanomoꞌa ageana Pitaꞌene Yoniꞌene ala mono nopi haigahe nehaꞌageno “Monea namitetanao.” huno aukaꞌya hunatene. ");
INSERT INTO knb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hunategeꞌana Pitaꞌene Yoniꞌene tokiyaꞌage aulu hemaineꞌana Pitaꞌa mage hie “Taꞌagaila taꞌago.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","7","Higeno ani kanomoꞌa “Nago ya namigahe nehaꞌe.” huno anakaila anakeke huno anake-mainegeno Pitaꞌa mage huno hie “Moneꞌniꞌa omalegi nagaipima hanea yana kamigahue Nasaleti Yisasi Kalaisi agile kahanepauve hetika ute ete huo.” huno nehuno tamaga ayate alino hetitegeno aupaꞌa aiyamoꞌene aleꞌyamoꞌene kanale hutegeno tokiya hau-maine. ");
INSERT INTO knb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tokiyaꞌage hautegeno hetino ute ete nehuno anakaiꞌene ala mono nopinaga nehaino haite asaga hulavite nehuno Anumaya Koti agia alisaga hume hume nehaiye. ");
INSERT INTO knb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Anumaya Koti agia alisaga huno haigeꞌya mukiꞌa veaꞌmoꞌya agayana higeꞌya “Vae mani kanoa mukiꞌa yupa ala mono nomona koganali fiate maineno aukaꞌya nehia kanogi.” huꞌya nehuꞌya alino kanaleꞌma hutenea yafena tusiꞌa amamaꞌyo aimainae. ");
INSERT INTO knb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Veaꞌmoꞌya amamaꞌyo neꞌaigeno ani kanomoꞌa Pitaꞌene Yoniꞌene anatafa huno ananukigeꞌya mukiꞌa veaꞌmoꞌya ala mono nomo haupale yasi alisia ya ayekalo humalenea nomo, agia Solomoni none huꞌya nehaya yate, amakaitega umainae. ");
INSERT INTO knb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Vageno Pitaꞌa ageteno mage huno humaine “Isaleli kumate vayaꞌmogatama naꞌa higetama atali talua nehae? Taꞌagaya taꞌagaitiꞌa tokiyaletiꞌene fatago humainoꞌa auꞌava yatetiꞌene ani kanoa alitaꞌa kanale hutoꞌageno ute ete nehie hutama taꞌagaila taꞌageneꞌasagalifi? ");
INSERT INTO knb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aꞌao. Taginagomogami Anumaya Kotiꞌa, Apalahamuꞌene Aisakiꞌene Yekopuene Anumaya Kotiꞌamimoꞌa, agaiꞌa aliꞌya kanoꞌamona, Yisasi, tokiya hale ya amigahe ani kanomona alino kanale hutenegi tamakaya ani Yisasina avaletama kame vayaꞌmogami amayapi atageno Pailatiꞌa Yisasife ‘Afaꞌa atalegahue.’ huno nehiana tamakaya Pailati aulagafi ‘Tagai kava kanoa omaigi agaya falisie.’ hutama tamakaveꞌno hutenae. ");
INSERT INTO knb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","15","Alu aotage kanoa fatago kavaꞌage nehia kanomona tamakaveꞌno huneꞌatetama vayaꞌma hamaeno fali neꞌamatea kanohe ‘Atalegeno eno.’ hutetama mukiꞌa veaꞌmogami hamaimuꞌmona aepaꞌa mainea kanomona hayageno falianagi Anumaya Kotiꞌa fali-mainefiti alino hetitegetaꞌa ago agetetaꞌa mani kea tamahanepauꞌe. ");
INSERT INTO knb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","‘Yisasiꞌa kanale hulaꞌatesia tokiya hane.’ hutaꞌa taꞌagupi malenoꞌa yafe manima neꞌagaya kanomona ago kanale hutetegeno aiyamoꞌa tokiya vaimaine. ‘Yisasiꞌa kanale hutesia tokiyaꞌa hane.’ hutaꞌa taꞌagupi malenoꞌa yateti tamakai tamaulagafi ago kanale hutegeno kanale huno maine. ");
INSERT INTO knb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tamage nenafugatama nagaya havuana tamakai kava vayatamimoꞌyaene Yisasiꞌma emainea aepaꞌaene havilama ohunetama Yisasina hae-mainae. ");
INSERT INTO knb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hae-mainaya yafe Anumaya Koti aune vayamogami amavayafitiꞌma humainaya kea mage humainayane ‘Nagaya tamaugafa aligatigahe hutenoa kanomoꞌa tusiꞌa agataya aliteno faligahie.’ huꞌya humainaya kemoꞌa efalote huno tamage humaine. ");
INSERT INTO knb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ani yafe kefo yatamia neꞌataletama tamakuꞌa aiyahae hisageno Anumaya Kotiꞌa kefo yatamia aye haꞌmi-talegahie. ");
INSERT INTO knb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aye haꞌmiteno agaiꞌalegati kanaleꞌma humatesia yana nelamamino Yisasina tamakaifema tamaugafa aligatigahie huno hutenea kanoa eteno tamakaitega hutenageno egahie. ");
INSERT INTO knb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hutegahianagi meni kanafina Yisasiꞌa ikapinaga maineno Anumaya Kotiꞌma mukiꞌa yana eteno haegafa yamaꞌage talo hisia yafe agava-maine. Mukiꞌa Anumaya Kotiꞌma nayoma mainaya amaune vayaꞌmoꞌya humainaya kemoꞌa efalote huno tamage humaineafe Yisasiꞌa eteno egahie. ");
INSERT INTO knb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moseseꞌa mage huno kaemaleneane ‘Anumaya Kotiꞌa tamakaipiti nagola aune laga hisia kanoa nagayama huaꞌya huno hisia kanoa ali hetitegahie. Hetitetenagenoꞌma agayama hisia kea haviho. ");
INSERT INTO knb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ani aune kanomo kema ohavisaya veaꞌmogamina Anumaya Kotiꞌa hamaeno fali haꞌno hinageꞌya Isaleli veapina omaigahae.’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Mukiꞌa Anumaya Koti amaune vayaꞌmoꞌya Samueliꞌene agai akavelegatiꞌma falote humainaya amaune vayaꞌyagaene menima mainona kanahe haviꞌya kae-malenayane. ");
INSERT INTO knb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tamakaya Anumaya Koti amaune laga nehaya vayaꞌmogami amakinagomogatama mainae. Anumaya Kotiꞌma Apalahamufe hulokiya vaino alino hagelafi lamatenea kea* huno tamakaiꞌenefe mani kea humaine. Anima hulokiya vaimalenea kemoꞌa mage huno humaineane ‘Nago tamakinagomoꞌa esiana mukiꞌa ma mopafi veaꞌmogamina kanale manua amamigahie.’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mukiꞌa manima humainaya kemoꞌa falote huno tamage hisia yafe Anumaya Kotiꞌa agaiꞌa aliꞌya nafaꞌneꞌamona alino hetitegetama tamakaya kefo yatamihe tamakuꞌa aiyahae hisageno tamaya huno kanale manua tamamisia yafe hagoteno tamakaitela hutegeno emaine.” Pitaꞌa mage huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pitagani Yonigani yaufa mani kea hama-nepaiꞌageꞌya mono note kava vayaꞌene mono note ati kava kanoene nagoꞌa Satiusi vayaꞌene eꞌya menakayana anakayama “Yisasiꞌma fali-mainefitila ago ali hetiteneanagino mukiꞌa veaꞌnea aniꞌa huꞌya fali-mainesafitila eteꞌya hetigahae.” huꞌana hamapaiꞌa yafe amaipa haviya nehae. ");
INSERT INTO knb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Amaipa haviya huteꞌya anatafa hagi “Ago une kianagita ega kaiyekea hunategahune.” huꞌya kina nopi anavaleꞌya monatenae. ");
INSERT INTO knb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Monatayanagi kasagoꞌya veaꞌnemoꞌya anakai kea haviteꞌya amakupi maleꞌya amametiti nehae. Faefu tauseniꞌa (5,000) veaꞌmoꞌya Yisasiꞌma hulatenea yafena haviꞌya amakupi maleꞌya amametitia nehae. ");
INSERT INTO knb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Faeteꞌya koꞌma neliana kava vayaꞌene vayatamaene kahegi kema havilinaya anagaꞌene Anasiꞌa ala mono note hagote kava kanomoꞌene agaiꞌa anagaꞌene Kaiyafasiꞌene Yoniꞌene Alekasataꞌene mukiꞌamoꞌya Yelusalemu alitalu humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Alitalu huteꞌya ani kanolatana anavaleꞌya amaufi hetinateneꞌya mage huꞌya hanavigae “Tanakaya hanaꞌa agimo tokiyaleti mani kavala humainaꞌe?” huꞌya hanavigae. ");
INSERT INTO knb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hana-vigageno Alu Aotage Avamuꞌmoꞌa Pitana agupina hiya higeno mage huno humaine Kava vayaꞌmogatamaene vayatamaene haviho. ");
INSERT INTO knb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mani aiyamoꞌa haviya humainea kanomona ali falu hutetana alitana kanale hutenaꞌe kea havisune hutama kaiyekea hulaꞌatetama na yateti mani kava nehaꞌe hutama taꞌahavi-negapi? ");
INSERT INTO knb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Taꞌa-havigayanagi mukiꞌamogatamaene mukiꞌa Isaleli veaꞌmoꞌyaene haviho. Nasaleti Yisasi Kalaisi agimoꞌa manima tamaufima heti-mainea kanomona alino kanale hutene. Ani Yisasina tamakaya yafaga yosale nilia hetama asaigeno fali-maineanagi Anumaya Kotiꞌa fali-mainefiti ago ali hetitene. ");
INSERT INTO knb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Anumaya Koti kemoꞌa autaꞌmafina mage huno humaine “Tamakaya yafa noma kiyana nago yafafena ‘Haviya hie.’ hutama atalayanagi menia ani yafamoꞌa tusiꞌa kanale yafane nomo ayetagenale ago malenae.” huno humaineane. Ani yafana Yisasife humaine. ");
INSERT INTO knb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ani kanomoꞌa agaiꞌage tagu tamena aligatigahie. Mukiꞌa mopafi veapitila nago kanomo agileti tagu tamena aliokatigahigi Yisasina agaiꞌage agileti tagu tamena aligatigahie huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pitagani Yonigania tokiyaꞌage ke haꞌageꞌya haviteꞌya mage hae “Vae mani kanolatana afa kanolata maineꞌana avo nopina oꞌunaꞌa kanolanagi hanaꞌa huꞌana tusiꞌa kanale kea nehaꞌe?” huꞌya amakesa havi havi nehuꞌya “Vae mani kanolatana Yisasiꞌene nemaiꞌa kanolatane.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hayanagi aliꞌana kanaleꞌma hutenaꞌa kanoa anakaiꞌene heti-mainegeꞌya agaya yafe nagoꞌa havige havagea huoꞌanatenae. ");
INSERT INTO knb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","“Kanisole vaya nopitila ataletana viꞌo.” huꞌya hunateteꞌya amakaiꞌamifi kea huge havige humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mage huꞌya hae “Ani tole kanolatana hanaꞌa hunatesune? Mama tokiya avame yana haꞌageꞌya mukiꞌa Yelusalemu nemaiya veaꞌmoꞌya ago age-mainagi hanaꞌa huta ali fala-kisune? ");
INSERT INTO knb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Havigu mani kemoꞌa alu kote kotega ute ete huyafenagi aluya huta ‘Nagoꞌene mani agia oꞌayeꞌo.’ huta kahegi-natesune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Anakaife ke hageꞌana aꞌageꞌya mage huꞌya anaumonola malenae “Yisasifena nagoꞌene veaꞌmogamina hamapaitana humaveotiꞌo.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hageꞌana Pitaꞌene Yoniꞌene kenonaꞌamia mage haꞌe “Na tamakesa nehaviye Anumaya Koti aulagafi mainoꞌagi ta kele akavela malesuꞌe? Tamakai kelepi Anumaya Koti kelele hutama nehafi na tamakesa nehaviye? Tamakaitami fako hutama haviho. ");
INSERT INTO knb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Taꞌagaya Yisasiꞌma humainea kavala agetaꞌa havimainoꞌa kavaꞌyaga fala okigahuꞌe.” huꞌana nehaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Haꞌageꞌya anaikolisaya amakesa haviyanagi mukiꞌa veaꞌmoꞌya humainaꞌa kavala ageteꞌya Anumaya Koti agi alisaga nehageꞌya mage hae “Anaiko-lisunana veaꞌmoꞌya kelama-kigahae.” huꞌya nagoꞌene anaumonola maleteꞌya anatalageꞌana umainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anima aiyama haviya humainea kanoma aliꞌana kanale hutenaꞌa kanomona kafuꞌa fotiꞌa (40) kafu humainea kanogiꞌya Anumaya Koti agi alisaga humainae. Yisasife amakupi malenaya veaꞌmoꞌya tokiya vaiꞌya Yisasi kema hufalote hisaya yafe Anumayamotega havige-mainae. ");
INSERT INTO knb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Anatalageꞌana anagaꞌanimoꞌya mainalega uteꞌana mukiꞌa ala mono note ala kava vayaꞌyagaene vayatamaene hanapaiya kea mo hamapai-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mo hamapaiꞌageꞌya haviteꞌya nagoke amakesa haviꞌya Anumayamotega ke huꞌya mage huꞌya havige-mainae “Kava yagai Anumayatimogae mopaene ikaꞌene hage liꞌene mukiꞌa anifima hanea yaꞌyagaene talo humalenana kanomogae. ");
INSERT INTO knb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Kagaya kagai aliꞌya kanoa, tototimoꞌa Tevitiꞌma avayafiti Alu Aotage Avamukaletila mage huka humainanane ‘Naꞌa higeꞌya Isaleli nofiꞌma omainaya veaꞌmoꞌya ‘Anumaya Kotiꞌene tu hugahune.’ huꞌya havigu ke huꞌya amaipa kafa hemainae? Ma mopafi kava vayaꞌene vayatamaene Anumayamofeꞌene agaiꞌa tagu tamemaꞌa aligatigahe hutenea kanomofeꞌene amaipa haviya nehuꞌya kea neꞌvaiye?’ huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mamona kelamage. Mani kumate alu aotage aliꞌya kanokaꞌa kagaikaꞌa taugafa aligatigahema hutenana kanomona kame hutesaya yafe Helotiꞌene Potiasi Pailatiꞌene Yuta vea omainaya vayaꞌyagaene Isaleli vayaꞌene alitalu huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kagayama nayoma huka ‘Naꞌa maꞌa hugahae.’ hukama havimainana kagesa aniꞌa hugahe alitalu humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Menia Anumayatimoga manima tagaifema hamae vainelateꞌya hu kolima latesaya kema haya kea nehavika tahaꞌmao. Tagaya kagai aliꞌya vaya mainonagi kagaya tahaꞌmaegeta kolia ohuta kagai kea tokiyaꞌage huta hamapaisune huta kahavinegone. ");
INSERT INTO knb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kayana maleka kali veala alika kanale huneꞌamateka kagaikaꞌa alu aotage nafaꞌnekamo agile tokiya avame yama hisuna tokiyakaꞌa lamio.” huꞌya Anumayamotega havinegae. ");
INSERT INTO knb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Havigageno Anumaya Kotiꞌa amakayama mainaya nona alino kosi kosi hutegeno Alu Aotage Avamuꞌmoꞌa amakupina me hiya humainegeꞌya Anumaya Koti kema tokiyaꞌage huꞌya hamapaisaya yafena kolia ohunae. Mukiꞌa Yisasina amakuꞌama aminaya veaꞌmoꞌya nagoke amaipale maineꞌya amaipa oꞌami aꞌami huꞌya mainae. ");
INSERT INTO knb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mukiꞌa Yisasi kema haviꞌya amakuꞌama aminaya veaꞌmoꞌya nagoke amaku amakesale maineꞌya nago kanomoꞌa agaiꞌage yafena ageteno “Nagaiꞌnige yane.” huno ohunegi “Mukiꞌa yana tagaiti yamaꞌage hane.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hageno tusiꞌa tokiyaꞌa amamigeꞌya Aposolo vayaꞌmoꞌya “Yisasiꞌa fali-mainefitila ago heti-maine.” huꞌya hamanepaigeno Anumaya Kotiꞌa kayone hisaya yana neꞌamamino amaya humaine. ");
INSERT INTO knb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Amaya higeꞌya amakai amuꞌnoꞌamifina kavefena kafua ohu veaꞌne maineꞌya mopaꞌamia hanea veaꞌnene noꞌamia hanea veaꞌnene “Alu kanomo miya hisie.” huꞌya hageꞌya monea amamigeꞌya aliꞌya Aposolo vayaꞌmogamina momamigeꞌya kaveꞌamima omalenea veaꞌmogamina amaya huꞌya amamite amamite humainae. ");
INSERT INTO knb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Nago kanoa Yosefeꞌe, nago agia Aposolo vayaꞌmoꞌya mage huꞌya malenae Panapasiꞌe huꞌya malenae. Ani agimoꞌa tagai kefina mage hie “Amaipa falu hisia ke nehia kanoe.” Ani kanomoꞌa Livai nofi kano maine. Saipalusi kumateti kanomoꞌa agaiꞌa mopa alu kano amigeno monea eteno amigeno ani monea alino Aposolo vaya me neꞌamamiane. ");
INSERT INTO knb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nago kanoa Ananaiyasiꞌe aꞌamo agia Safailaꞌe ani alavelatamogania nago mopaꞌania alu kano neꞌamiꞌana mone ali-mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aliteꞌana Ananaiyasiꞌa kesi nagoꞌa monea agaiꞌa alino fala-kigeno aꞌamoꞌa anima alia monea ago age-maine. Ananaiyasiꞌa nagoꞌa monea alino Aposolo vaya momamine. ");
INSERT INTO knb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Amamianagi Pitaꞌa agaifena mage hie “Ananaiyasigae Sataniꞌa* kefo kagu kagesa kamigeka kagaya ‘Mukiꞌa monea mama hane.’ huka nehanagi nagoꞌa monea ali fala-negika Alu Aotage Avamuꞌmofena havige huka ayevataga nehane. ");
INSERT INTO knb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mani mopa kagaika mopagika ‘Alu kanomo alisie.’ huka monea neꞌalika aniꞌa huka kagaika monegi naꞌa higeka ‘Havigea huꞌna ayevataga hugahue.’ huka kagu kagesafinaga nehane? Vayaꞌmona ayevataga ohunanagi Anumaya Koti ayevataga humainane.” huno nehie. ");
INSERT INTO knb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Higeno Ananaiyasiꞌa ani kea haviteno ailakatino fali-maine. Faligeꞌya neyaꞌvemoꞌya nago kena moliꞌya haꞌya kiteteꞌya aliꞌya komufi mo hevaitenae. Hevaitetageꞌya ani kanoma fali-mainea kea mukiꞌa veaꞌmoꞌya haviteꞌya tusiꞌa lagi tagiꞌya amake-mainae. ");
INSERT INTO knb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Haenagaꞌa taliꞌa (3) aova haꞌnoma nehiana aꞌamoꞌa ani fali-mainea kea ohavino egeno Pitaꞌa agaife mage hie “Manima hanea monea mopaletila hai ani kanoꞌa ali-mainaꞌo?” huno higeno “Tamage ani kanoꞌa al-imainoꞌe.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Higeno Pitaꞌa mage huno hie “Naꞌa higetana tanakaya tokaetana kea hutetana ‘Alu Aotage Avamuꞌmona ayevataga hugahuꞌe.’ hutana haꞌane? Agego anaukamoma agoꞌma aliꞌya mo hevaitaya vayala eteꞌya fiate me heti-maineꞌya kagaiꞌenena falisanageꞌya aliꞌya mo hevaigategahae.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nehigeno aupaꞌa ani aꞌmoꞌa Pita aiyafi ailakatino agoꞌya faiteno faligeꞌya neyaꞌveyagamoꞌya haiꞌya mogayana ani ala ago fali-mainegeꞌya moliꞌya anauꞌamoma hevaitale mo lokaeꞌya hevainatenae. ");
INSERT INTO knb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hevainatageꞌya Yisasina amakuꞌama aminaya veaꞌene mukiꞌa ani kema haviya veaꞌmoꞌyaene tusiꞌa lagitagiꞌya amake-maine. ");
INSERT INTO knb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo vayaꞌmoꞌya mukiꞌa vea amuꞌnopi kasagoꞌya tokiya avame yaꞌyaga hageꞌya age-mainae. Ageteꞌya Yisasina amakuꞌama aminaya veaꞌmoꞌya nagoke amaku amakesale maineꞌya ala mono nomo haupale yasi alisia ya ayekalo humalenea nomo agia Solomoni none ani nopi mukiꞌa kanafina molitalu humai humai nehayane. ");
INSERT INTO knb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","Nehageꞌya nagoꞌa veaꞌmoꞌya kolima haya yafe amakaiꞌenena mo lokaeꞌya uomainagi ani veaꞌmogami amaki alisaga humainae. Mukiꞌa veaꞌmoꞌya Yisasi kema haviꞌya amakupi maleꞌya amametitia huteꞌya amakaiꞌene mainae. ");
INSERT INTO knb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tokiya avameꞌyama humainea yafe mukiꞌa kalima hamaeya veala amavaleꞌya kate amateꞌya hagifanale maineꞌya mage hae “Pitaꞌma esiana agai amemo me halatu hamaesigeno kanale humategahie.” huꞌya kate momatenae. ");
INSERT INTO knb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Amatageꞌya mukiꞌa veaꞌmoꞌya Yelusalemu aupateꞌma hanea kumaꞌyagaleti kalima hamaeya veaꞌnene Satani avamuꞌmoꞌma amakupi fale-mainea veaꞌnene amavaleꞌya ageno mukiꞌa ago alino kanale humatene. ");
INSERT INTO knb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Mono noteꞌma hagote kava kanomoꞌene agaiꞌenema lokaeꞌya mainaya vayaꞌene Satiusi vayaꞌmoꞌyaene amaipa haviya humateteꞌya Aposolo vayala amatafa huꞌya amavaleꞌya kina nopi momatenae. ");
INSERT INTO knb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Amatenageno ani kegela Anumayamo ensole kanomoꞌa eno fita me yakino anifiti amavaleno kumatega neꞌuno mage huno hie “Tamakaya utama ala mono nopi hetitama veaꞌmoꞌyama haegafa huꞌya agola maige maige hisaya hamaimula alisaya kea hamapaiho” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Higeꞌya haviteꞌya natekefafi hetiꞌya uꞌya ala mono nopi veaꞌmogamina mo hamanepaiye. Hamanepaigeno ala mono note hagote kava kanomoꞌene agaiꞌenema lokaeꞌya nemaiya vayaꞌene ani kea ohaviꞌya neꞌataleꞌya Kanisole vayafeꞌene Isaleli nofi vayatamaenefe moge hageꞌya ageno ati vayafe “Kinama humatenona vayala momavaletama eho.” huꞌya hamapaimainae. ");
INSERT INTO knb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Me hageꞌya ati vayala kina nopi mogayana omaigeꞌya neꞌataleꞌya eteꞌya mage mo hae “Tagaya mogonana fita tokiyaꞌage alokileti hemaleneꞌya vayala kava yagaiꞌya kumate hetimainageta fita mo yakiteta kina nopima mogonana omainae.” huꞌya me humainae. ");
INSERT INTO knb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mehageꞌya ala mono note kava vayaꞌyagaene mono note ati kava kanoene mani kea haviteꞌya tusiꞌa amakesa havi havi huꞌya mage hae “Hanaꞌa huꞌya kina nopitila fanane humainae? Hanaꞌa humainea ya falote hugahie.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hageno nago kanomoꞌa mage huno me hamapaiye “Haviho kina nopima amataya vayala ala mono nopi hetiꞌya maineꞌya veaꞌmogamina humave-neliye.” huno me hie. ");
INSERT INTO knb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Me higeꞌya mono note ati kava kanomoꞌene ati vayaꞌaene uꞌya “Havigu amakai kema havimainesaya veaꞌmoꞌya yafateti tahaesageta falisunagi.” huꞌya amaikootiꞌya ako huꞌya amavaleꞌya emainae. ");
INSERT INTO knb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Amavaleꞌya ayaꞌamoꞌya Kanisole vaya amuꞌnopi me hetimatetageno ala mono note hagote kava kanomoꞌa mage huno hie. ");
INSERT INTO knb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tagaya Yisasife nagoꞌene veaꞌmogamina hamapaitama humaveotiho” huta tamakaila tamaumonola ago malonanagi tamakaya mukiꞌa Yelusalemu nemaiya veaꞌmogamina mani kea hamapaitama tagaifena ‘Ago Yisasina hae-malenaya vaya mainae.’ hutama hamapai-mainae.” huno hie. ");
INSERT INTO knb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hianagi Pitaꞌa nagoꞌa Aposolo vayaꞌene mage huꞌya nehae “Ma mopafi vayaꞌmogami kemona akave omalegahunagi tagaya Anumaya Koti kemo akave malegahune. ");
INSERT INTO knb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tamakaya Yisasina nagoke yafaga yosale asai-malageno fali-maineanagi Tototimo Anumaya Kotiꞌa fali-mainefiti ago ali hetitene. ");
INSERT INTO knb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ali hetiteteno avalesaga huno tamaga ayatega ategeno hagote kava kanoa tagu tamema aligatimainea kanoene mainea yafe tagaya Isaleli veaꞌmogata taguꞌa aiyahae hisuna tagesa tamisigeta taguꞌa aiyahae hisunageno aigetateno kefo yatia atalelategahie. ");
INSERT INTO knb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tagaya mani kea hisuna vaya mainonageno Alu Aotage Avamuꞌmoꞌa aniꞌa huno mani kea humaine. Mukiꞌa Anumaya Koti kema akave malenaya veaꞌmogamina Anumaya Kotiꞌa Alu Aotage Avamula ago amamine.” huno hie. Kamalieliꞌa kanisole vayaꞌmofe mage huno hie “Aposolo vayaꞌmogamina ako hutama amateho.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hageꞌyama mani kema haviya yafe amaipa amakata aiꞌya Aposolo vayala hamaesageꞌya falisaya amakesa nehaviye. ");
INSERT INTO knb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hamaegahayanagi nagola Falasia kanomo agia Kamalieliꞌe* mono humave-nelia kanogino Yuta vayaꞌmogami Kanisolefi mainegeꞌya mukiꞌa veaꞌmoꞌya agima alisaga nehaya kanogino ani kanomoꞌa hetino mage huno hie “Tahaote kea hugahunagi Aposolo vayala humategeꞌya kumatega hati-lavisageta kea hisune.” huno hie. ");
INSERT INTO knb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Higeꞌya hati-laviꞌya vageno mage huno Kanisole vayaꞌmogamife hie “Isaleli vayaꞌnimogatama mani vayaꞌmogamina nago yama humategahunema hinutama tamakesa havilama hutetama aniꞌa hiho. ");
INSERT INTO knb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nayona nago kanomo agia Teutasiꞌe evaꞌyi huno ‘Nagaya tokiyaꞌniꞌa hanea kano mainoe.’ huno higeꞌya fo hataletiꞌa (400) vayaꞌmoꞌya akavela vayanagi kamani kava vayatimoꞌya ago hayageno faligeꞌya akaveꞌma neꞌvaya vayala atagufeꞌya ute ete hageno aliꞌyamaꞌamoꞌa afa ya kana humaine. ");
INSERT INTO knb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Agai akavelega amakima negayaya kanafina Yutasiꞌe Kalili kanomoꞌa evaꞌyi huno kea hamapaigeꞌya nagoꞌa vayala akave neꞌvageno kava vayatimoꞌya Yutasina ago hayageno faligeꞌya akaveꞌma neꞌvaya vayala atagufeꞌya ute ete humainae. ");
INSERT INTO knb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Naꞌa humainaya yafe menia tamahapauve mani vayala amatalegeꞌya viho. Anima nehaya kea amakaiꞌami mopale vayaꞌmogami kema hanesigenoꞌa afaꞌa haꞌno hugahianagi Anumaya Koti kema hanesigetama tamakayama ali haviyama hisaya amukotamia omalene. Havigu lamakaya Anumaya Kotina kame hutetama agaiꞌene tu hutesagi.” huno humaine. ");
INSERT INTO knb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Higeꞌya Kamalieli ke haviꞌya “Tamage hane.” huteꞌya Aposolo vayafe ke hageꞌya ageꞌya nofi kaꞌyoteti haifu amamiteꞌya amaumono nemaleꞌya mage hae “Yisasifena nagoꞌene veaꞌmogamina hamaopaiho.” huꞌya humateteꞌya amatalageꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ani Kanisole vayala amataleꞌya neꞌuꞌya “Anumaya Kotiꞌa ago tamatea kava nehae.” huno tagaifena nehuno “Yisasi agima neꞌayaya yafe tamakaye hisifa kavala hisagetama amukotamia hanegahie.” huno humainea yafe tusiꞌa muse hume hume umainae. ");
INSERT INTO knb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mukiꞌa yupa ala mono nopiꞌene veaꞌmogami nopiꞌene mukiꞌa veaꞌmogamina Yisasifena hamapai-mainae. “Yisasina Anumaya Kotiꞌa taugafa aligatigahema hutenea kanoe.” huꞌya hamapai-mainae. ");
INSERT INTO knb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kasagoꞌya veaꞌmoꞌya Yisasi kea haviꞌya amakupi maleneꞌya amaku aminaya kanafina nagoꞌa ani veaꞌmoꞌya Kaliki ke havilinaya vea mainagi nagoꞌa veaꞌmoꞌya Hipalu ke havilinae. Kaliki kema havilinaya veaꞌmoꞌya mage hae “Tagai megusa aꞌneyaga havi kava hutama osi kanoꞌa kavela neꞌamamiyanagi Hipalu amakema neꞌaiya megusa aꞌneyaga kasagoꞌya kave neꞌamamiye.” huꞌya amaipa haviya huꞌya ke vai-mainae. ");
INSERT INTO knb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Kema vaiya yafe Yisasina tuelufuꞌa (12) Aposolo anagaꞌamoꞌya mukiꞌa Yisasina amakuꞌama aminaya veafe ke hageꞌya ageꞌya mage huꞌya hae “Havigu tagaya Yisasi ke hamanepauna aliꞌyatia ataleta kaveꞌma fako faka hisunana haviya huyafenagi nafuꞌnaganagatama tamakaitami amuꞌnotamifi atiyetama seveniꞌa (7) kanale amaku amakesaene vayaꞌma, mainesigenoꞌma Alu Aotage Avamuꞌmoꞌa amakupima hiya humainenageꞌya veaꞌamimogami amaulagafima kanale kavaꞌma nehisaya vayafe atiyetama ani aliꞌyatela humatesune. ");
INSERT INTO knb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Humategahunanagi tagaya mukiꞌa yupa nunamu huta havige havige nehuta Yisasi kea hamapaige hamapaige huta maigahune.” huꞌya humainae. ");
INSERT INTO knb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hageꞌya mukiꞌa veaꞌmoꞌya mani kea haviteꞌya muse nehuꞌya ani vayala hapaliꞌya humataya vayala Sitiveniꞌa, Yisasi kea aguꞌafi tokiyaꞌage huno malegeno Alu Aotage Avamuꞌmoꞌa agupina hiya humainea kanoene Filipiꞌene Polokolasiꞌene Nikanaꞌene Timoniꞌene Pamenasiꞌene Nikolasiꞌe. Nikolasiꞌa Atioku kanoa nayona Yuta nofi kanoa omaineanagi eaꞌyamo “Yuta vayaꞌmogami Anumaya Kotiꞌamimo ke aliꞌna nagupi malegahue.” huno Isaleli nofi vayapi maineane. ");
INSERT INTO knb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ani vayala amavalageꞌya Aposolo vayatega ageꞌya ani vayaꞌmogami amanute amaya maleꞌya nunamuna humatenae. ");
INSERT INTO knb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Anumaya Koti kemoꞌa mukiꞌa kotega ute ete higeꞌya kasagoꞌya Yelusalemu nemaiya veaꞌmoꞌya Yisasi kea haviꞌya amakupina malenae. Kasagoꞌya mono note kava vayaꞌyagaene aniꞌa huꞌya Yisasi kea aliꞌya amakupi maleꞌya amametiti humainae. ");
INSERT INTO knb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiveniꞌa tusiꞌa kanale kanogino kayone hisia yaꞌene tokiyaꞌaene agupina hiya humainegeno tusiya huno ani vayapina tokiya avame yana humaine. ");
INSERT INTO knb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aniꞌa nehianagi nagoꞌa vayaꞌmoꞌya hetiꞌya Sitiveniꞌene ke neꞌvaiye. Ani vayala miya oꞌali vaya maiteꞌya eteꞌya afaꞌa maineꞌya nago mono nopi neꞌvaya vayale. Sailinia vayaꞌene Alekasatalia vayaꞌene nagoꞌa vayala Silisia vayaꞌene Esia vayaꞌene Sitivenina ke vaitenae. ");
INSERT INTO knb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kea vaitayanagi Alu Aotage Avamumoꞌa haꞌmaegeno kanale agu agesaene kanomo kea amigeno humaine. Higeno amakai kemoꞌa Sitiveni kemona oꞌagasene. ");
INSERT INTO knb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Oꞌagasegeꞌya nagoꞌa vayafe “Sitivenifena havige hutesageta mone lamamigahune.” huꞌya hageꞌya ani vayala mage mo hae “Mani kanomoꞌa Mosesefeꞌene Anumaya Kotifeꞌene tusiya huno hu-haviya hunategeta havimainone.” huꞌya mo humainae. ");
INSERT INTO knb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mani kema haya yafe mukiꞌa vayaꞌmoꞌyaene vayatamaene kahegi kema havilinaya anagaꞌmogamina amakuꞌamoꞌa haviya higeꞌya Sitivenina motafa huꞌya Kanisole vayate avaleꞌya umainae. ");
INSERT INTO knb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Uteꞌya nagoꞌa havigema nehaya vayala amavaleꞌya hetimatageꞌya ani vayaꞌmoꞌya mage hae “Mani kanomoꞌa mukiꞌa yupa tagaila alu aotage mono notiene kahegi kene huno haviya hie. ");
INSERT INTO knb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Higeta havunana Yisasiꞌa Nasaleti kanomoꞌa ma ala mono nona aliꞌna lagaꞌya vaineꞌataleꞌna ‘Moseseꞌma tahapai-mainea kahegi kea ataletama alu kava hiho.’ huno higeta havimainone.” huꞌya hae. ");
INSERT INTO knb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nehageꞌya mukiꞌa Kanisolefi mainaya vayaꞌmoꞌya Sitivenina aulu hayana augosamoꞌa alave alave nehuno ensole vayaꞌmogami amaugosamoꞌma nehia kava higeꞌya age-mainae. ");
INSERT INTO knb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ala mono note hagote kava kanomoꞌa Sitivenifena mage huno havige “Mani kema hugataya kea tamage nehao?” huno havige. ");
INSERT INTO knb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Higeno Sitiveniꞌa mage huno humaine nenafagatamaene naganaꞌni-mogatamaene haviho. Taginagomoꞌa Apalahamuꞌe yaufa Halani kotega oꞌuno Mesopotemia kotega mainegeno tokiya hale yamaꞌaene Anumaya Kotiꞌa Apalahamute efalote humaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Efalote huteno mage huno hapaiye “Kagaika mopakaꞌaene vayakamogamiꞌenena neꞌamataleka kavelisua mopalega vuo.” huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Higeno Apalahamuꞌa anile Kalatia vayaꞌmogami mopa neꞌataleno Halani kotega umaineno anilega nefaꞌa falitegeno Anumaya Kotiꞌa eteno hutegeno tamakayama menima mainaya mopalela emaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Emaineanagi Anumaya Kotiꞌa agaiꞌa atafa hisia mopa nago atupa kanoꞌa ani mopa nagoke aiya malesia mopa oꞌaminegi “Haenagaꞌa kamigahue. Ani mopa atafa hulinesanageꞌya kagaipiti falote hisaya nafaꞌneyagamoꞌya aligahae.” huno hianagi ani kanafina Apalahamuꞌa namo kano maineane.* ");
INSERT INTO knb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Maineanagino Anumaya Kotiꞌa agaifena mage humaineane “Kagaikaꞌa kaginagomoꞌya Isaleli nofiꞌma omainaya vayaꞌmogami mopale visageꞌya ani vayaꞌmoꞌya amatafa huꞌya ‘Aliꞌyatia aliho.’ huꞌya tusi yate ali haviya humatesageꞌya ani mopalela fo hataletiꞌa (400) kafu maigahae.* ");
INSERT INTO knb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Maigahayanagi amatafama huꞌyama ‘Aliꞌyatima aliho.’ huꞌya humainaya vayaꞌmogamina nagaya kaiyeke humateteꞌna aliꞌna haviya humatesugeꞌya kagai kaginagomoꞌya ani kotegatila eteꞌya ma mopale emaineꞌya nagai nagia alisaga hugahae.” huno humaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Anumaya Kotiꞌa mage huno humaine “Nagai anagaꞌma maisaya yafe hagelafita maisuna kavala nafaꞌnekamogamina amakoya anoꞌya taga huo.” huno higeno Apalahamuꞌa Aisakina nafaꞌneꞌa ateteno napa eitiꞌa (8) kana maiteno agoya anoꞌya taga humaineane. Haenagaꞌa Aisakiꞌa nafaꞌneꞌa Yekopuna ategeno Yekopuꞌa haenagaꞌa tuelufuꞌa (12) nafaꞌneyaga tagai taginagomogamina amatene. ");
INSERT INTO knb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Ani Yosefena nepuꞌamoꞌya Yosefefe tusiꞌa amaipa kafa heteteꞌya avaleꞌya alu vayaꞌmogami neꞌamamiꞌya mone aligeꞌya Isipi kotega avaleꞌya vayanagi Anumaya Kotiꞌa agaiꞌene maineno kanama haiya yana alitaleno kanale agu agesa amigeno Isipi sauve kanoa, Felona, aulagale hetigeno Feloꞌa muse huno “Hagote kava kano maineka nagai noꞌyagaene mukiꞌa Isipi kotega kava yagaigane.” huno hutene. ");
INSERT INTO knb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Hutetegeno mainegeno Isipi kotegaene Kenani kotegaene nagola tusiꞌa kafu haya kana efalote higeꞌya tototimogamina kaveꞌamia omalegeꞌya tusiya huno amakala lemainae. ");
INSERT INTO knb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amakala legeno Yekopuꞌa “Isipi koteꞌma kavela hanema.” huꞌya haya kea haviteno nafaꞌneyagaꞌa hagoteno humategeꞌya kaveꞌma hanelega umainae. ");
INSERT INTO knb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Haenagaꞌa eteꞌya anile vageno Yosefeꞌa “Nagayae tamakanatamimoꞌna mainoe.” huno higeno Feloꞌa Yosefe afamofena havimaine. ");
INSERT INTO knb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Havitegeno Yosefeꞌa nefafena Yekopufeꞌene mukiꞌa anagaꞌa seveti faefuꞌa (75) anagaꞌaene ke higeꞌya Isipi kotega umainageno Yekopuꞌa anile faligeꞌya nafaꞌneyagaꞌaene tototimoꞌya fali-mainayane. ");
INSERT INTO knb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Faligeꞌya eteꞌya aliꞌya Sekemu kumala, Apalahamuꞌa moneleti Hamolo nafaꞌneyagamogami mopa miya higeno amigeno ali-mainea mopafi mo hevaitenae. ");
INSERT INTO knb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","Anumaya Kotiꞌa Apalahamufema hulokiya vai-malenea kemoꞌa fatago huno efalote hisia kanamoꞌa aupa higeꞌya tagai taginagomoꞌya Isipi kumatela falote huꞌya kasago humainageno alu sauve kanoa, Yosefefena oꞌagenea kanomo, eteno sauvea alino humaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Falote huno maineno tagai nofi vayala ayemavataga huno huhaviya huneꞌamateno “Nafaꞌneya-gatamia hamaesunageꞌya faligahae.” huno tokiyaꞌage ke humaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Higeno ani kanafina Mosesena itaꞌamoꞌa atetegeno Anumaya Kotiꞌa hau-mainea nafaꞌnegino itaꞌamogani nefagania taliꞌa (3) ikana noꞌanifinaga kava huꞌana ataꞌageno mainaꞌe. ");
INSERT INTO knb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kava huteteꞌana kumate atenaꞌageno Felo munaꞌmoꞌa ani nafaꞌnea avaleno agaiꞌa nafaꞌne kana huno yagai-maine. ");
INSERT INTO knb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yagaiteno avo nopi ategeno Isipi vayaꞌmoꞌyama havilinaya yana Mosesena huve-ligeno aliteno tusiya huno tokiyaꞌa haneteno kanale kea nehuno nehia kano maine. ");
INSERT INTO knb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Maineanagino fotiꞌa (40) kafu huteno mage hie “Isaleli vayaꞌnimogamina momakegahue.” huno agesa havimaine. ");
INSERT INTO knb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Haviteno mogeana nago Isipi kote kanomoꞌa Isaleli kanomona aiko-neligeno Moseseꞌa moli-neꞌataleno anonaꞌa ani Isipi kote kanoa haegeno fali-maine. ");
INSERT INTO knb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Faligeno Moseseꞌa ma agesa havimaine “Vayaꞌnimoꞌya mage huꞌya hugahae ‘Anumaya Kotiꞌa Mosese ayapiti taugafa aligatigahie.’ huꞌya hugahae.” huno agesa havianagi vayaꞌamoꞌya ani amakesa ohavinae. ");
INSERT INTO knb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ohavigeno Moseseꞌa faeteno mogeana tole Isaleli kanolatana tu nehaꞌageno monaketeno moli-neꞌanataleno mage huno hie “Nenafugatanae tanakaya nagoke konagalata mainaꞌagi naꞌa higetana tua nehaꞌe?” huno hie. ");
INSERT INTO knb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Higeno anima tuma aepa henoꞌma aganaꞌamoma aiko-lia kanomoꞌa Mosesena ayetu-nefeno mage huno hie “Kagaila tagaite kava kano maika kaiyeke fatago hu kano maiyo kea ta kahapaigeka aniꞌa nehane? ");
INSERT INTO knb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kagayama egama Isipi kanoma hayana kava huka nahaegahe nehano?” huno hie. ");
INSERT INTO knb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Higeno ani kema hia kehe Moseseꞌa faleno Mitiani kotega mo maineno ala aliteteno maineno haenagaꞌa tole ne nafaꞌnelata anatene. ");
INSERT INTO knb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Anilegama maiyana fotiꞌa (40) kafu maiteno Moseseꞌa kaꞌme kotega Sainai agoꞌyafi haino mainegeno nago osi yosalela ala ata anefela nelea yapiti nago ensole kanomoꞌa evaꞌyi higeno age-maine. ");
INSERT INTO knb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Ageteno amaꞌyo neꞌaino agelama hisue huno nehuno avate neꞌegeno Anumayamoꞌa anileti age aino mage huno hie “Nagaya kaginagomogamina Anumaya Kotiꞌami mainoe. Apalahamuꞌagi Aisakiꞌagi Yekopugami Anumaya Kotiꞌami mainoe.” huno higeno Moseseꞌa atali talu huteno ani yama nagoꞌene agesia yafena tusi koli huno oꞌagene. ");
INSERT INTO knb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Koli nehigeno Anumayamoꞌa mage huno hie “Mamona alu aotage mopa nagaiꞌniꞌa mopagika kaiya anona asagika maletekao. ");
INSERT INTO knb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nagayama nagai nofi vayaꞌma Isipi nemaiya veaꞌnimoga-mina ali haviyama humataya kavala ago age-mainoe. Avima atayana ago havimaineꞌna amaugafa aligatigahe emainogi. Kagaya eno Isipi kotega hugategahue.” huno Mosesefena hapai-mainea ke huno Sitiveniꞌa hamapai-maine. ");
INSERT INTO knb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mani Mosesefena nayona mage huꞌya humainae “Kagaila kava kano maineka kaiyekea ali fatago hugane huꞌya kea ta kahapaigeka aniꞌa nehane?” huꞌya amakaveꞌno hutenae. Anima amakaveꞌno hutaya kanomona osi yosaleꞌma vaꞌyima humainea ensole kanomoꞌa aya higeno Anumaya Kotiꞌa kava humateno amaugafama aligatisia yafe huteneane. ");
INSERT INTO knb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hutegeno Moseseꞌa Isipi kotega umaineno ani kotegati amavaleno fotiꞌa (40) kafu Isipi kumateꞌene haesa titeꞌene kaꞌme kotegaene kasagoꞌya tokiya avame yaꞌyaga humaineane. ");
INSERT INTO knb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ani Moseseꞌa Isaleli veaꞌmogamife mage huno hamapai-maine “Anumaya Kotiꞌa tamakai vayapiti nagayama huaꞌya huno aune laga hisia kanoa avaleno hetitegahie.” huno hamapai-maineane. ");
INSERT INTO knb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ani Moseseꞌa kaꞌme kotega maineno mono kema havigahema melitalu humainaya taginagomoꞌyaene maiteno Sainai agoꞌyafi haitegeno nago ensole kanomoꞌa evaꞌyi huno Anumaya Kotina tahaimuꞌma lamisia mono kea Mosesena hapaigeno Moseseꞌa taginagomogamina hamapai-maineane. ");
INSERT INTO knb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","Hamapai-mainegi taginagomoꞌya “Mosese kea akave omalegahune.” huꞌya amakaveꞌno huteteꞌya Isipi kotega eteꞌya visaya amakesa nehaviꞌya Elonife mage huꞌya humainae 