﻿USE sofia;
DROP TABLE IF EXISTS sofia.kmu_vpl;
CREATE TABLE kmu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kmu_vpl WRITE;
INSERT INTO kmu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mamona Yisasi Kalaisina aginagomogami amaki hane. YisasiꞋa Teviti nofipiti kano maineanagino TevitiꞋa Apalahamu nofipiti kanoe. ApalahamuꞋa Yisasina aginagomo maine. ");
INSERT INTO kmu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ApalahamuꞋa Aisakina nefaꞋe. AisakiꞋa Yekopuna nefaꞋe. YekopuꞋa Yutagami konagamogami neꞋamafaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","YutaꞋa Pelesigani Silagani neꞋanafa maineanagino itaꞋanimo agia TamaꞋe. PelesiꞋa Hesalonina nefaꞋe. HesaloniꞋa Lamana nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","LamaꞋa Aminatapina nefaꞋe. AminatamiꞋa Nasonina nefaꞋe. NasoniꞋa Salamonina nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","SalamoniꞋa Poasina nefa maineanagino itaꞋamo agia LahapuꞋe. PoasiꞋa Opetina nefa maineanagino itaꞋamo agia LutiꞋe. OpetiꞋa Yesina nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","YesiꞋa Tevitina nefa maineanagino TevitiꞋa Isaleli veaꞋmogami ala sauve kanoꞋami maineane. TevitiꞋa Solomonina nefa maineanagino itaꞋamoꞋa hagoteno Yulia a maineane. ");
INSERT INTO kmu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","SolomoniꞋa Lehopoamina nefaꞋe. LehopoamiꞋa Apiana nefaꞋe. ApiaꞋa Asana nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","AsaꞋa Yehosafatina nefaꞋe. YehosafatiꞋa Yeholamina nefaꞋe. YeholamiꞋa Usiana nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","UsiaꞋa Yotamina nefaꞋe. YotamiꞋa Ahasina nefaꞋe. AhasiꞋa Hesekiana nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","HesekiaꞋa Manasena nefaꞋe. ManaseꞋa Emonina nefaꞋe. EmoniꞋa Yosaiyana nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","YosaiyaꞋa YehoiyakiniꞋene ani koganamogami neꞋamafaꞋe. Ani kanafina Papiloni kotega vayaꞋmoꞋya tu huteꞋya Isaleli veala amavaleꞋya Papiloni kotega nofi mo hu-ma-tageꞋya miya oꞋali aliꞋya ali-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ani veaꞋmoꞋya Papiloni kotega nofi huma-tageꞋya miya oꞋali aliꞋyana aliꞋya mainayanagino Yehoiyakinina Sealitielona nefaꞋe. SealitieloꞋa Selapapelina nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","SelapapeliꞋa Apiutana nefaꞋe. ApiutaꞋa Eliakimana nefaꞋe. EliakimaꞋa Asolana nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","AsolaꞋa Satokina nefaꞋe. SatokiꞋa Akimina nefaꞋe. AkimiꞋa Eliutina nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","EliutiꞋa Eleasana nefaꞋe. EleasaꞋa Matanana nefaꞋe. MatanaꞋa Yekopuna nefaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","YekopuꞋa Yosefena nefa maineanagino YosefeꞋa Maliana anauꞋamoꞋagino ani aꞋmoꞋa Yisasina ategeꞋya agaifena KalaisiꞋe* huꞋya Anumaya KotiꞋa taugafa aligatigahe hu-tenea kanoe huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ApalahamuꞋa hagoteno maineno falitegeꞋya haenagaꞋa fotiniꞋa (14) aginagomoꞋya maime maime haiꞋya mo falitageno anile TevitiꞋa evaꞋyi huno maineno falitegeꞋya haenagaꞋa fotiniꞋa (14) aginagomoꞋya maime maime haigeꞋya Papiloni vayaꞋmoꞋya eꞋya Isaleli veaꞋmogamina nofi hu-ma-tageꞋya miya oꞋali aliꞋyana aliꞋya mainageno haenagaꞋa fotiniꞋa (14) aginagomoꞋya maime maime haigeno KalaisiꞋa falote hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisasi Kalaisima atenea kea mage huno hu-maine itaꞋamo agia MaliaꞋe Yosefete ago hage-malenaya munalagino nagola vene ofaenea munaꞋmoꞋa aipaene maine. Anumaya Kotina Alu Aotage AvamuꞋaleti aipaene hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","YosefeteꞋma, hage-malenaya kanoa, fatago kano maineanagino havigu MaliaꞋa agaye huyafenagiꞋna kesi atalesue agesa havimaine. ");
INSERT INTO kmu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","Ani kehena agesa havige havigeteno faeno maineno himona ageana Anumayamo ensole kanoa evaꞋyi huno mage huno hie “Yosefegae, Tevitina neꞋamogae, kolia ohuka MaliaꞋa akamoꞋagi afaꞋa avalo. Anumaya Kotina Alu Aotage AvamuꞋaleti aipaene maineanagino neꞋnafaꞋne ategahie. Ani nafaꞋneꞋmoꞋa agaiꞋa veaꞋmogamina kefo yaꞋamimo nofi hu-matenea veala ali kalu heno amaugafa ali-gatisiafe agia YisasiꞋe huka malegane.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Nayona Anumayamo aune kanomo avayafiti mage huno hama-pai-maineane “Haviho nagola vene ofaenesia munaꞋmoꞋa aipaene huteno neꞋnafaꞋne ategahie. Ani nafaꞋnemo agia mage huꞋya ayegahae ImanueliꞋe huꞋya ayegahae.” huno hu-maineane. “Tagai kefina ani agimoꞋa Anumaya KotiꞋa tagaiꞋene maine.” huno hu-maine. Yisasina atenea yupa ani kemoꞋa ago falote huno tamage hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","YosefeꞋa ani himona ageteno aupiti hetino Anumayamo ensole kanomoꞋma hapaiya kea havino akave maleteno “Maliaga aꞋnimogae.” huno ali-tene. ");
INSERT INTO kmu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","YosefeꞋa ani afena “AꞋnimogae” huteno alave yana ohuno afaꞋa maineꞋana ani nafaꞋnea ategeno YosefeꞋa agia YisasiꞋe huno malene. ");
INSERT INTO kmu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","HelotiꞋa Yutia kotega ala sauve kano mainea kanafina Yisasina Petelehemu osi Yutia kumate atene. AtetegeꞋya haenagaꞋa yage vaꞋyi nehilegati kanale haviꞋyaꞋami hanea vayaꞋmoꞋya Yelusalemu evaꞋyi hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","EvaꞋyi huteꞋya mage huꞋya hae “Menima atea nafaꞋnea, Yuta* vayaꞋmogami sauve kanoa, hanate atene? Nagola haegafa kaꞋnefila yagema evaꞋyi nehilegati evaꞋyi higeta ageteta ‘Ago atene.’ huta agai agi alisaga hugahe neꞋone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hageno sauve kanoa HelotiꞋene mukiꞋa Yelusalemu mainaya veaꞋnene ani kea haviteꞋya atali talu hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Atali talu hageno HelotiꞋa mukiꞋa mono note kava vayafeꞋene kahegi kema havilinaya anagafeꞋene ke higeꞋya agaite ageno mage huno hama-vige “Anumaya KotiꞋma taugafa ali-gatigahema hu-tesia kanoa hana kumate ategahie?” huno hama-vi-ge-maine. ");
INSERT INTO kmu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hama-vi-gegeꞋya mage huꞋya hae “Ani nafaꞋnea Petelehemu ategahie. Nayona Anumaya Koti aune kanomoꞋa mage huno kae-maleneane ");
INSERT INTO kmu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kagaya Petelehemu kumaꞋmoga Yutia kotega mainananagi Yutia kumaꞋyaga ago amakaseka hai-mainananagino kagaipiti ala kava kanoa falote huteno nagai veala Isaleli* veate kava yakaigahie.’ huno kae-maleneane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hageno HelotiꞋa yage vaꞋyi nehilegati emainaya kanale haviꞋyaꞋami hanea vayaꞋyagahena kesi huno ke higeꞋya ageno “Ani haegafa kaꞋnefila na yu falote hu-maine?” huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hama-vigeteno Petelehemu hu-ma-tegahe mage huno hie “Utama ani nafaꞋnehena ati-yetama age-faloteꞋma hinutamahena etetama me naha-paigeꞋna nagaiꞋenena aniꞋa huꞋna agia molisaga hano.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","HigeꞋya sauve kanomo kea haviteꞋya mogayana yagema vaꞋyi nehilegati age-mainaya kaꞋnefimoꞋa uhagote-ma-teno viaꞋyamo ani nafaꞋnema mainea nomo amupale umaineno amave-li-maine. ");
INSERT INTO kmu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amave-ligeꞋya ageteꞋya amaipamoꞋa kanale higeꞋya tusiꞋa muse hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Muse hu-teteꞋya ani nopi hai-faleꞋya agayana ani nafaꞋnegi itaꞋamoꞋa MaliaꞋagi huꞋana mainaꞋageꞋya mogeteꞋya mopafi mope huꞋya agia alisaga nehuꞋya kuꞋamifiti muse yana amigahe monegi manaꞋage taꞋnefagi kule fuki kana huno manaꞋage mea tinagi huꞋya aminae. ");
INSERT INTO kmu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","AmiteꞋya himona agayana Anumaya KotiꞋa himonafi mage huno hama-paiye “Heloti mainesilega etetama oꞋviho” huno higeꞋya alu kate uteꞋya kumaꞋamilega umainae. ");
INSERT INTO kmu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kanale haviꞋyaꞋami hanea vayala utageno YosefeꞋa Anumayamo ensole kanoa himonafi agegeno mage huno hie “Hetika nafaꞋnene itaꞋamoꞋene Isipi kotega tamaiya-yetama viho. Anilega umainegeꞋna nagayama eteꞋna hisugetama etetama egahae. HelotiꞋa kagai nafaꞋnehe ati-yeno haesia ke nehie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Higeno YosefeꞋa ani himona ageteno aupaꞋa hetino nafaꞋnene itaꞋamoꞋene ani kegela anavaleno Isipi kotega ugahe umainae. ");
INSERT INTO kmu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ani kotega ayaꞋaya kanagefa umainageno HelotiꞋa falitegeꞋya neꞋataleꞋya emainae. Ani yafena nayona AnumayamoꞋa aune kanomo avayafiti mage huno hu-maineane “Isipi kotegati nagaiꞋni nafaꞋnea ke hisugeno egahie” huno hu-maineane. Nayoma hu-mainea kemoꞋa ani yupa ago efalote huno tamage hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","HelotiꞋa agesa havitenoꞋe “Ani kanale haviꞋyaꞋami hanea vayaꞋmoꞋya aye-navataga hae.” huno tusiꞋa ke vai-maine. Kanale haviꞋyaꞋami hanea vayaꞋmogami kea haviteno “YisasiꞋa ani augafa kafuꞋa hane.” huno nagoꞋa vayala hu-ma-tegeꞋya Petelehemu kumateꞋene atupa kumaꞋyagaleꞋene mukiꞋama yaufa tole (2) kafua ohunaya neꞋnafaꞋneyaga “HamaegeꞋya faliho.” huno hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","YelemaiyaꞋa nayona Anumaya Koti aune kanomoꞋa mage huno hu-maineane “Lama kumategati mukiꞋa veaꞋmoꞋya ala kefiti ke huꞋya hamau huꞋya avi-taya kea vayaꞋmoꞋya havimainae. Leselina aginagomogami nafaꞋneyagahe tusiꞋa avi-tegeꞋya nafaꞋneyagaꞋama faliya yafe veaꞋmoꞋya aipa ali falu hutayanagi tusi avi-te-maine.” huno hu-maineane. Ani yupa nayoma hu-mainea kemoꞋa ago efalote huno tamage hie. ");
INSERT INTO kmu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","HelotiꞋa falitegeno YosefeꞋa Isipi kotega maineno himonafi Anumayamo ensole kanomona agegeno mage huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Hetika nafaꞋnene itaꞋamoꞋene neꞋanavaleka Isaleli kotega viho. Kagai nafaꞋnema haesaya amakesa haviya vayala ago faliye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Higeno YosefeꞋa hetino nafaꞋnene itaꞋamoꞋene neꞋanavaleno Isaleli kotega umainae. ");
INSERT INTO kmu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Umainagi “HelotiꞋa ago falitegeno agaiꞋa nafaꞋnemoꞋa AkelausiꞋa Yutia kotega kava hu-maine.” huꞋya haya kea YosefeꞋa haviteno koli huno “Anilega oꞋugahue.” huteno himonafina “Anilega oꞋviho.” huno hia kea haviteno Kalili umaine. ");
INSERT INTO kmu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kalili viana osi kumala Nasaleti uno maine. Nayona Anumaya Koti amaune vayaꞋmoꞋya Yisasifena mage huꞋya hu-mainayane “Agaya Nasaleti kano maine.” huꞋya hugahae huꞋya hu-mainayane Ani yupa nayoma hu-mainaya kemoꞋa ago efalote huno tamage hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti fale-mate YoniꞋa evaꞋyi huno Yutia kaꞋme kotega maineno Anumaya Koti kea hu-haleno hama-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","YoniꞋa mage huno hie Anumaya KotiꞋma ikapinaga kava yagaisia yamoꞋa aupaꞋa evaꞋyi hugahie. EvaꞋyi hugahigi tamakaya tamakuꞋa aiyahae hutama kefo yatamia “NagoꞋene ohugahune.” hutama ataleho huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ani kema hisia kanomofena nayona Anumaya Koti aune kanomoꞋa, AisayaꞋa mage huno hu-maineane “KaꞋme kotegati nago kanomoꞋa keha keha huno mage hugahie ‘Anumayamo esia kamaꞋa ali hilato hutama ali fatago hiho.’ huno hugahie.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","YoniꞋa kemolo afumo ayolagefaleti fakaꞋni-male kena fai-line. Fai-lineno pulamakao augafaleti amuꞋnofila aye-talako huno ki-lineno kaveꞋa keꞋnuꞋene tumemo timaꞋaene neneane. ");
INSERT INTO kmu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ani kanafina Yelusalemu veaꞋnene Yutia kotega veaꞋnene nagoꞋa Yotani ti agegayalega hanea kumate veaꞋnene Yoni mainelega umainae. ");
INSERT INTO kmu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yotani titega emaineꞋya kefo yaꞋamihena hu-falote hageno YoniꞋa ani Yotani tipi tina fale-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tina fale-neꞋama-tegeꞋya Falasia* vayaꞋene Satiusi* vayaꞋene “Ti fale-la-tesie.” huꞋya neꞋageno YoniꞋa amaketeno mage huno hie “Tamakaya osifaꞋveyagamo nafaꞋneyaga mainagi tamakaya havigeꞋage vayaꞋmogatama Anumaya KotiꞋa kaiyekema hu-lama-tesigetama tamaugafa tamakata aisia kanamoꞋa aupaꞋa efalote hisia yafena ‘Faletama viho.’ kea ta tamaha-pai-maine? ");
INSERT INTO kmu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Hagotetama kefo yatamihema tamakuꞋa ai-yahae hu-mainesaya yana nave-lisageꞋna tina fale-lama-tegahue. Tamakaya ‘Apalahamu nafaꞋneyaga mainone.’ hutama ohiho. Nagaya tamaha-nepauve Anumaya KotiꞋa ma yafatetila Apalahamu nafaꞋneyaga afaꞋa talo hileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tamakaya yosa kana hutama mainayanagi menia Anumaya KotiꞋa tuna alino yosamo aipale maleneno kanale alagama oꞋayenesia yosa atagino atafi hagaꞋyu huno kaegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","TamakuꞋa ai-yahae hutama kefo yatamia atalegeꞋna nagaya titeti fale-nelama-toanagino nakavela nago kanoma esiana Alu Aotage AvamutetiꞋene ataletiꞋene fale-lama-tegahie. Ani kanomoꞋa tusiꞋa tokiyaꞋa hanea kanogino nagaila ago nagase-maineanagiꞋna nagaya afa kano mainoanagiꞋna agai aiyale ayesuana onategahie. ");
INSERT INTO kmu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Agaya sipeti ayopaꞋa ali-lineno vitimo anoꞋyaꞋa fuhu hale-taleno alagaꞋa alino nopi halaꞋya hu-malegahigi anoꞋyaꞋa ata tegelege nehia atafi kae-talegahie. Ani avinamoꞋma hu-mainea kava huno veala fako faka hugahie huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ani kanafina YisasiꞋa “Yoni ayapiti tina fale-natesie.” huno Kalili kotegatila ataleno Yotani titega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","YoniꞋa Yisasifena “Tina fale-oka-tegahue. Nagaila kagaya tina fale-na-tanageno kanale hileꞋasine naꞋa higeka nagaifena ‘Tina fale-nato.’ huka nehane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Higeno YisasiꞋa Yonifena mage huno hie “Menia aniꞋa hisanana kanalele. Tima fale-na-tesanana mukiꞋa Anumaya Kotina fatago kavaꞋa alitaꞋa lama hugahuꞋe.” huno higeno YoniꞋa Yisasi ke akave maleno tina fale-tene. ");
INSERT INTO kmu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tina fale-neꞋategeno YisasiꞋa aupaꞋa tipiti aivati huno ageana ikamoꞋa ai-hagalo higeno Alu Aotage AvamuꞋmoꞋa nama kana huno agaitega elavi-maine. ");
INSERT INTO kmu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ageho enelavigeno ikapinagati age aino mage huno hie “Ma kanoa nagaiꞋni nafaꞋnehena agaifena aluya huno nahau nayamopafina nenagea neꞋnimofena agaifena aluya huꞋna musemaꞋa nehue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Anumaya Kotina Alu Aotake AvamuꞋamoꞋa Yisasina veaꞋne omai kaꞋme kotega avaleno vigeno SataniꞋa Yisasife “Havi kava huo.” huno aye-vataga hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Umaiyana fotiꞋa (40) yupagefa felugaene kegeꞋene kavela oneno maigeno tusiꞋa agate-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Agategeno SataniꞋa agaite uvaꞋyi huno mage hie “Kagaya Anumaya Koti nafaꞋnema mainenukahena ma yafaꞋyaga hapaigeno maya hapaeno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Higeno YisasiꞋa mage huno hie Anumaya Koti avopi kemoꞋa mage huno hu-maineane “VeaꞋmoꞋya mayaꞋageꞋma nesayana kanaleꞋya huꞋya omaigahagi mukiꞋa Anumaya KotiꞋma hu-mainea kene haviꞋya nenesageno amaku nafaꞋnemoꞋa kanaleꞋya huno maigahie. huno hu-maineane.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","SataniꞋa Yisasina Yelusalemu tusiꞋa ala kumate avaleno ala mono nomo agotofule motene. ");
INSERT INTO kmu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Moteteno mage huno hapaiye “Kagaya Anumaya Koti nafaꞋnema mainenukahena ma nomo agotofuleti mopafi asaga hulavigeꞋna agano. Anumaya Koti avopiti kemoꞋa mage hu-maineane ‘Anumaya KotiꞋa ensole vayaꞋahe ‘Kava hiho.’ huno hu-ma-tesigeꞋya amayateti kavalesaga hu-lisageka tavisanageno yafatela kaiyamona aye kofa ohugahieꞋ huno hu-maineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Higeno YisasiꞋa kenonaꞋa mage huno hie “NagoꞋene Anumaya Koti avopina mage huno kae-maleneane ‘Anumaya Kotikamona afa yafena ‘Tokiya kava huo.’ huka aye-vataga ohuo.’ huno hu-maineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Higeno SataniꞋa Yisasina avaleno nago ala agoꞋyafi haiteno mukiꞋa ma mopafima hanea ala kumaꞋyagaene afenoꞋyamaꞋaene ave-li-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aveliteno Yisasife mage huno hie “Kagaya nagaifema ‘TusiꞋa ala kano mainananagiꞋna kagai kagi alisaga nehue.’ huka kagesama havi namika mopafi kaleꞋyama ayesanageꞋnahena mukiꞋa ani kumaꞋyagaene afenoꞋyaꞋene kava yagaisanafe kamino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Higeno YisasiꞋa mage huno hie Sataniga* mai haleka amulega vuo. Anumaya Koti avopi kae-malenaya kemoꞋa mage huno hu-maineane “Anumaya Kotikamona akaiꞋagefe ‘TusiꞋa ala kano maine.’ huka kagesa havi havi huka agai agia alisaga huka agai aliꞋyamaꞋage alio huno hu-maineane.” huno hapai-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Higeno SataniꞋa anile ataleno vigeno ensole anagaꞋmoꞋya Yisasina meya huꞋya kava hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","YisasiꞋa “Yonina nofi hu-tenae.” huꞋya haya kea ago haviteno Kalili kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Viana Nasaletia ataleno Kapaneamu umaine. Ani kumala Kalili ti kotumona agegayale haneanagino Sepuluni nofi veaꞋmogamiꞋene Napatali veaꞋmogamiꞋene koꞋamiꞋa haneane. ");
INSERT INTO kmu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nayona Anumaya KotiꞋa aune kanoꞋamona, Aisaya avayafiti mage huno hu-maineane ");
INSERT INTO kmu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepuluni nofi veaꞋmogamiꞋene Napatali veaꞋmogamiꞋene mainesaya kaiyaga ala tikotu visaya katega haneanagiꞋya Yotani lina takaeꞋya vaaya kotega, Kalilie, Yuta veaꞋne omainaya veaꞋmoꞋya nemaiya kumale. ");
INSERT INTO kmu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ani kotega mukiꞋa veamoꞋya hani yapi mainayanagino menima aye-hale-matesia yana age-mainae. MukiꞋa veaꞋmoꞋya afaꞋa maineꞋya faligahe hayanagi Anumaya Koti kemoꞋa ago aye-vasa hu-matene.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ani yupa YisasiꞋa aepa heno Anumaya Koti kanale mono kea hu-haleno hama-pai-maine. Mage huno hie “Ikapinagati Anumaya Koti kava yagaisia yana aupaꞋa evaꞋyi hugahigi tamakaya tamakuꞋa aiyahae hutama kefo yatamia ataleho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kalili ti kotumo agegayalega neꞋuno Saimonina, nago agia PitaꞋe, aganaꞋamo agia Etaluene anakeana noyame kuꞋya nehaꞋa kanolatana maineꞋana ala kukonogo hagaꞋyu huꞋana ti kotupi nemalaꞋageno anake-maine. ");
INSERT INTO kmu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Anaketeno YisasiꞋa mage huno hana-paiye “Nakave eꞋo. Nakave eꞋageꞋna noyame kuꞋyama haꞋa avamete huꞋna veaꞋne amavalesaꞋa auꞋava yana tanavelino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","HigeꞋana aupaꞋa kukonogoꞋania neꞋataleꞋana Yisasi akave umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","VaꞋageno YisasiꞋa anakeana Sepetina netalamaꞋamoꞋagani Yemesigani Yonigania tipi kalefi neꞋanafaꞋene maiꞋana kukonogo nefakaꞋniꞋageno YisasiꞋa momaketeno anakaife ke hie. ");
INSERT INTO kmu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ke higeꞋana aupaꞋa SepetiꞋa neꞋanafaꞋene tipi kalene neꞋataleꞋana akave umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","YisasiꞋa mukiꞋa Kalili kotega ute ete huno mono nopi Anumaya Koti kava yagai-latesia kanale mono kea mo hama-nepaino mukiꞋa kaliꞋamima hanea veaꞋnene mukiꞋa veaꞋmogami amaugafama ali haviya nehia yana alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Alino kanaleꞋma hu-ma-tea avagemoꞋa mukiꞋa Silia kotega ute ete higeꞋya haviteꞋya mukiꞋa veaꞋmoꞋya kalima aliya veaꞋnene alu kali alu kalima aligeno amaugafa amakata neꞋaiya veaꞋnene Satani AvamuꞋma* amakuꞋafi mainea veaꞋnene mananiꞋya neꞋamakia kali veaꞋnene amaiya amaya avayu hu-lavi-mainea veaꞋnene amavaleꞋya Yisasite ageno alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Alino kanale hu-ma-tegeꞋya kasagoꞋya veaꞋnea KalilitiꞋene naya-toleꞋa kumaꞋyagaletiꞋene YelusalemutiꞋene YutiatiꞋene alulega mainaya veaꞋnea Yotani tina takaeꞋya Yisasina akave umainae. ");
INSERT INTO kmu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","YisasiꞋa mukiꞋa alitalu hu-mainaya veaꞋnea amaketeno agoꞋyafi haino mopale mainegeꞋya agaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya Yisasitega emainae. ");
INSERT INTO kmu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ageno YisasiꞋa avayafiti mage huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","MukiꞋa yaꞋamima omalenea veaꞋmoꞋya “Tagupi nagoꞋa kanale yana omaleanagita tagaitia kanale kavala ohugahunagi Anumaya KotiꞋa taya hisie.” huꞋya hisaya veaꞋmogamina Anumaya KotiꞋa amakaila kava yagai-ma-tegahigi ani yafena muse hutama maiho. ");
INSERT INTO kmu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hamaumana halesigeꞋya hamau huꞋya nemaisaya veaꞋmoꞋya Anumaya KotiꞋa amaya huno amaipa falu hisia yana amamisia yafena muse huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Amaugafama aliꞋya nohaiya veaꞋmogamina Anumaya KotiꞋa haenagaꞋa mukiꞋa mopa amamisia yafena muse huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anumaya KotiꞋa fatago hu-mainea kavafena “Nelahaigeno ani yafena laga nele.” huꞋya hisaya veaꞋmoꞋya Anumaya KotiꞋa amamu hisigeꞋya maisaya fatago kavaꞋma amamisia yafe muse huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","MukiꞋa veaꞋmoꞋya nagoꞋa neꞋamafugamife kalagi ai-mateꞋya hamau hu-neꞋamatesaya veaꞋmogamina Anumaya KotiꞋa aniꞋa huno kalagi aino hauna hu-matesia yafena huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","MukiꞋa veaꞋmoꞋya Anumaya Koti kema akave malesaya yafena tole amakesama ohavinaya veaꞋmoꞋya Anumaya Kotima agesaya yafena muse huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","NeꞋamafugamifena “Nagoke tamaku tamakesale maiho.” huꞋya nehisaya veaꞋmogamina Anumaya KotiꞋa “Nagai nafaꞋneyaga mainae.” huno hu-matesia yafena muse huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","NagoꞋa veaꞋmoꞋya fatagoma huꞋya mainesageꞋya nagoꞋa veaꞋmoꞋya amaipa kafa he-mateꞋya ali-haviyama hu-ma-tesageꞋya maisayana Anumaya KotiꞋa amakaiꞋma kava yagai-ma-tenea yafena muse huꞋya maisae. ");
INSERT INTO kmu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tamakaya nakaveꞋma nemalageꞋya tamaketeꞋya kamuge hu-lama-teꞋya ali-haviya hu-nela-mateꞋya “Ma kavala havi kava nehae.” huꞋya havigema hu-lama-tesagetama afaꞋa muse nehutama maiho. ");
INSERT INTO kmu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","AniꞋama hu-lama-taya kavala nayona Anumaya Koti amaune vayaꞋmogamina aniꞋa hu-ma-tenayane. Ani kavaꞋma hu-lama-tesaya kanafina ikapinaga anonaꞋa kasagoꞋya yaꞋyaga alisaya yafena tamaipamoꞋa kanale nehinagetama muse hiho. ");
INSERT INTO kmu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tamakaya ma mopale veaꞋmogamina hagama nehamaiya sole kana hutama mainae. SolemoꞋa hagama nehia yamaꞋama haꞋno hisigetama hanaꞋa hutama hagama nehia yamaꞋa ali falote hugahae? Hagama nehia yamaꞋamoꞋa ago yagu yaguma hisiana afa ya kana hinageꞋya ani Solea veaꞋmoꞋya faitega ai-tagu-fe-talesageꞋya amaiyaleti ute ete huꞋya aye-lata-pegahae. ");
INSERT INTO kmu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tamakaya mukiꞋa ma mopama hanea kotega kaꞋni kana veaꞋne mainae. Ala kumaꞋma agoꞋyafima hanesiana fala okigahianagiꞋya mukiꞋa veaꞋmoꞋya agegahae. ");
INSERT INTO kmu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","NagoꞋa veaꞋmoꞋya lamua hanagaliꞋya susufanefinaga aiso hu-nomalagi nopinaga aye-halesigeꞋya veaꞋmoꞋya agesayafe ani lamua sipale nemalae. ");
INSERT INTO kmu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","NaꞋa hu-mainegi tamakaya ani kava hutama lamumoꞋa aye-hale-ma-tea kava hutama Yisasi kea hama-paitama kanale kavala veaꞋmogami amaule hisageꞋya ageteꞋya ikapinaga mainea Nelamafa agia alisaga hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tamakaya ma lamakesa ohaviho “Nayona Mosese kahegi kene amaune vayamoꞋya hu-mainaya kene YisasiꞋa ali-talegahe emaine.” hutama ohiho. Nagaya ani yaꞋyaga aliꞋna oꞋatalegahugi ani kea ali falote hisugetama “Tamage nehie.” hutama hisayafe emainoe. ");
INSERT INTO kmu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nagaya tamagelafa huꞋna tamaha-nepauve ma mopaene ikaꞋene fanane hugaꞋanagi kahegi kefi mukiꞋa osi osi oꞋagemo avoꞋyaga afaꞋa hanegahie. Nagoke ya kanoꞋagela fanane ohugahigi mukiꞋama hu-mainaya kemoꞋa falote huno tamage-lafa hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tamage-lafa hu-mainayafe nagoꞋa veaꞋmoꞋya ani kahegi kea osi kanoꞋa “Akavela omalegahunema.” huꞋya alu veaꞋmogamife “AniꞋa hiho.” huꞋya hisaya veaꞋmoꞋya Anumaya KotiꞋa kava yagai-mainea kumatela osi nafaꞋne kana veaꞋne maigahagi nagoꞋa veaꞋmoꞋya mukiꞋa kahegi kema ali hipoꞋya huꞋya “Ma kava hiho.” huꞋya hama-paisayana Anumaya KotiꞋa kava yagai-mainea kumatela ala huno agase-mainea amakiene veaꞋne maigahae. ");
INSERT INTO kmu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nagaya tamagelafa huꞋna tamaha-nepauve Falasia* vayaꞋene kahegi kema havilinaya anagaꞋene hu-mainaya fatago kavala tamakaya agasetama tusiꞋa kanale hu-mainea fatago kavaꞋma ohisayana amuha ohunayanagino tokiyatamia omaleneanagitama Anumaya KotiꞋa kava yagai-mainea kumatela haitama omaigahae. ");
INSERT INTO kmu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tamakaya ago havilinae nayoma mainaya veaꞋmogamina mage huꞋya hama-pai-mainayane “Veala hamaetama fali-oꞋamateho. VeaꞋma haemaetama fali-matesayana kaiyeke hu-lama-tegahae.” huꞋya hu-mainayane. ");
INSERT INTO kmu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nagi nagaya menia tamaha-nepauve nagoꞋa veaꞋmoꞋya neꞋamafufema amaipa kafa hetesayana Anumaya KotiꞋa kaiyeke hu-ma-tegahie. NagoꞋa veaꞋmoꞋya neꞋamafufema “Havi kavakeꞋya nehana kano mainane.” huꞋya hisayana ala kaiyekele he-tigahae. NagoꞋa veaꞋmoꞋya neꞋamafufema “Kagaya aifoꞋnafo kano mainane.” huꞋya hisayana hani yapima tegelege nehia atafi ugahae. ");
INSERT INTO kmu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","NaꞋa nehaya yafe tamakaya Anumaya Kotina nago yama amigahena mono nopi haitama mainetama “Veha nenafuna haviya hu-tenoanagino aipamoꞋa haviya nehie.” huka kagesa haviteka Anumaya Kotina amisana yana anile neꞋataleka negafutega tanaipa mo-li-falu hutetana eteka esanaꞋamoga amisana yana Anumaya Kotina memio. ");
INSERT INTO kmu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nago kanomoꞋa “Havi kava huna-tananagiꞋna kaiyekea hu-gategahe nehue.” huno kavalenoꞋma vinagetana neꞋutana “Nenafuga kaipa falu hisia yana kamigahue.” huka hapaiyo. AniꞋa ohisanana kavaleno kaiyekema hu-gatesia kanomote vinageno haviteno ati kanomo ayapi katesigeno kavaleno nofila mo hu-gategahie. ");
INSERT INTO kmu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nofila mo hu-gategahigi tamage tamaha-nepauve kaiyekema hu-gatenea kanomoꞋma “Mone namio.” huno hu-mainesia monema oꞋaminesanana nofipitila ataleka omegane huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tamakaya nayo kea ago havimainae mage huno hu-maineane “Kumai he kavala ohiho.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nage hu-maineanagi nagaya menia tamaha-nepauve nagoꞋa veaꞋmoꞋya nago aꞋmona aulagafiti age haꞋye huno “Ani aꞋmofena naꞋa hu-ga-tegahue.” huno aguꞋafinaga havino haꞋyema hiana ani atela ago kumai kava hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tamaga kaiyaga tamaulagamoꞋma agea yafema kefo kavaꞋma hisaya tamaku tamakesa tamamisigetama ani tamaulaga ali faꞋyitama atalesagenoꞋa nago tamaugafa atupaꞋa omalenea yafe kanaleꞋya hutama maigahae. AniꞋama ohinutamahena muki tamaugafa hanimo aguꞋafi tegelege nehia atafi hagaꞋyu hu-lama-talegahie. ");
INSERT INTO kmu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tamaga tamayaꞋmoꞋma tamavayu huno kefo kava hisaya tamaku tamakesama tamamisigetama ani tamayana he-fakalitama ataleho. NaꞋafene? Nago tamaugafa atupaꞋa omalenea yafe kanaleꞋya hutama maigahae. AniꞋama ohinutamahena muki tamaugafa hanimo aguꞋafi tegelege nehia atafi hagaꞋyu hu-lama-talegahie. ");
INSERT INTO kmu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nayona mani kea hagetama havimainae. “NagoꞋa vayaꞋmoꞋyama aꞋamima hu-tesayana ani vayaꞋmoꞋya aꞋamimofena ‘Ago hu-negatoe.’ huno avona kaeno amino.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hu-maineanagi nagaya menia tamaha-nepauve aꞋamoꞋma kumai ohenesigeno anauꞋamoꞋma atalesigeno ani aꞋmona alino kumai nehia a kana hu-tene. Nago kanomoꞋa anima atalenea aꞋma aliteana ani kanomoꞋene kumai he yana nehie. ");
INSERT INTO kmu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nago kea nayoma hama-pai-mainaya kea ago havimainagi naꞋa hu-maine “Kagaya ‘Anumayamo aufina tamage nehuanagiꞋna naꞋa hugahue.’ huka hisanana fatago huka ani kavala huo.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hu-maineanagi nagaya tamaha-nepauve tamakaya “Anumaya Koti aufina tamage nehue.” hutama ohiho. Tamakaya “Ikamo agile tamage nehue.” hutama ohiho. Ikapinaga Anumaya KotiꞋa kava yagai-mainea kuma hanegetama agaife nehae. ");
INSERT INTO kmu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tamakaya “Mopamo agile tamage nehue.” hutama ohiho. Ani mopalega Anumaya KotiꞋa aiya haꞋyo hu-maleno mainea mopa hane. Tamakaya “Yelusalemu kumaꞋmo agle tamage nehue.” hutama ohiho. Ani Yelusalemu kumala ala sauvetimoꞋa Anumaya Koti kava yagai-mainea kuma hane. ");
INSERT INTO kmu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tamakaya “Nanuteti huꞋna lamage nehue.” hutama ohiho. Tamakaya tamayolagefahena “Anupa nayolegefaene tuhi nayolegefaene falote hino.” hutama hisaya tokiyatamia omalegi ani kea ohiho. ");
INSERT INTO kmu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“E,” hinutamahena ani keꞋage hiho. “AꞋao.” hinutamahena ani keꞋage hiho. Nago kenema hisayana Kefo AvamuꞋmoꞋa ani kea ali falote nehie. ");
INSERT INTO kmu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nayona mani kea hagetama ago havimainagi “Nago kanomoꞋa kaulagama ai-lagatisigekahena ani kanomo aulaga anonaꞋa ai-lagatio. KaveꞋma ai-halalima hisigekahena anonaꞋa agaila aniꞋa huka avela ai-halali huo.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hu-maineanagi nagaya tamaha-nepauve nago kanomoꞋa havi kavaꞋma hu-ga-tesigekahena kaꞋyona oꞋamio. Nago kanomoꞋa kagalamesaleꞋma kaiko-lisigekahena nago kaiyagakaꞋa mai-yahae hugeno kaiko-lino. ");
INSERT INTO kmu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nago kanomoꞋma “Haviya hu-natea kanoe.” huno kaiyekema hu-gateno “AnonaꞋa kagaiꞋa siota namio.” huno hisigekahena ala yasi siotakaene amio. ");
INSERT INTO kmu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nago kava kanomoꞋa tokiyaꞋage ke huno “AfenoꞋyaniꞋa nago kilomita alika vuo.” huno hisigekahena ani kilomita mogaseka nagoꞋene tole kilomita alika vuo. ");
INSERT INTO kmu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nago kanomoꞋma “Nago yaka namio.” hunoꞋma hisigekahena afaꞋa hagaꞋyu huka amio. Nago kanomoꞋma “NamisanageꞋna yoka aliteꞋna eteꞋna kamigahugi namio.” huno hisigekahena afaꞋa amio. ");
INSERT INTO kmu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nayoma hama-pai-mainaya kemoꞋa ago havimainagi “Kumatamile mainesaya nelama-fugamifena tamahau tamayamopafi tamahainagetama kame vayatamihena tamaipa kafa he-mateho.” huꞋya hu-mainayane. ");
INSERT INTO kmu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hu-mainayanagi nagaya menia tamaha-nepauve “Kame veatamimofena tamahau tamayamopafi tamahaino. Haviya hu-nelamataya veaꞋmogamina ‘Amaya huo.’ hutama Anumayamotega havigo.” ");
INSERT INTO kmu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ani kavaꞋma hisayana ikapinaga mainea Nelamafana nafaꞋneꞋa maigahae. Anumaya KotiꞋa kanale veaꞋneleꞋene havi veaꞋneleꞋene yagemona hu-tegeno nago avamete huno aye-hale-matene. Anumaya KotiꞋa fatago nehaya veaꞋneleꞋene havi kava nehaya veaꞋneleꞋene kola hu-tegeno nago avamete huno kola neꞋaiye. ");
INSERT INTO kmu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","VeaꞋmoꞋya tamakaifema hamau amayamopafi neha-mainagetamahena tamakaya aniꞋa hutama amakaifema tamahaisiana ani kavamoꞋa afa yanagino anonatamia oꞋaligahae. Kefo kava nehuꞋya amaugafaleti takisi mone neꞋaliya vayaꞋmoꞋya aniꞋa kavala nehae. ");
INSERT INTO kmu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","NelamafuꞋenekeꞋyama kea kea nehisaya yana afa yanagi. Yisasi ke ohavinaya veaꞋmoꞋya aniꞋa kavala nehae. Kame vayatamimoꞋene kea kea hiho. ");
INSERT INTO kmu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikapinaga NelamafaꞋa ala huno kanale kavakeꞋya hu-maineanagitama tamakaya aniꞋa augafa veaꞋne mainetama ala hutama kanale kavakeꞋya nehutama maiho. ");
INSERT INTO kmu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","YisasiꞋa mage huno hu-maine “Havigu tamakaya veaꞋmogami amaufima kanale kava nehisageꞋya ‘NageteꞋya kanale kano maine.’ huꞋya hisae.” hutama nehae. Ani kavala hisayana anonatamia hai ali-mainagi ikapinaga mainea NelamafaꞋa kanale kava haya yafe anonatamia otamamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ani yafe tamakaya kafuma hisaya veala amaya hutamama amamigahena ala kefiti keha keha hutama oꞋamamitama kesi ako hutama amamiho. NagoꞋa vagala vayaꞋmoꞋya mono nopiꞋene kategaene “VeaꞋmoꞋya tageteꞋya ‘Kanale kava nehae.’ huꞋya takia alisaga hisae.” huꞋya keha keha huteꞋya vaya amaya nehayanagi nagaya tamagelafa huꞋna tamaha-nepauve kanale anonaꞋamia hai ali-mainayanagino Anumaya KotiꞋa nago yana oꞋamamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kagaya kafuma hisaya veaꞋma amaya hugahena tamaga kayamoꞋa hauga kayamo hisia yana oꞋagesigeka kesi momaya huo. ");
INSERT INTO kmu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kesi ako huka veaꞋmoꞋya onagesagi huka amaya hisanana ani yakaꞋa Anumaya Koti, NegafaꞋa, kesi kavaꞋma nehaya yana neꞋagea kanomoꞋa age-maineanagino kanaleꞋya huno anonakaꞋa kamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nunamuma hutama havigegahena vagala vayaꞋmoꞋya nehaya kava hutama Anumaya Kotina havi-okeho. Ani vayaꞋmoꞋya mono nopiꞋene ka agegayaleꞋene “Muki veaꞋmoꞋya tagesae.” huꞋya hetiꞋya Anumayamotega havinegae. Nagaya tamagelafa huꞋna tamaha-nepauve vayaꞋmoꞋya anonaꞋamia hai ali-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ali-mainagi kagaya oꞋagesaya kava huno mainea Nelafana Anumayamotegama havigegahena nokafinaga fita ki-maleteka maineka falakika havigesanageno NegafaꞋa kesi kavaꞋma haya yama neꞋagea kanomoꞋa ani yana ageteno anonakaꞋa kamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nunamuma hugahena Anumayamo kema nohaviya veaꞋmoꞋya havinegaya kavala hutama kasagoꞋya afa keyaga hutama havi-okeho. Ani veaꞋmoꞋya ayaꞋaya nunamu ke nehuꞋya mage huꞋya amakesa nehaviye “AyaꞋaya ke huta havigesunageno havigahie.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nehagi amakaya nehaya kavala amakave omaleho. Nelamafama havi-oketama maiya kanafina nago yatamima omalene hutama haya yatamia ago havimaineafe nagoꞋene tutu hu-oꞋateho. ");
INSERT INTO kmu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Anumayamotega havigenutamahena mage hutama havigeho “Ikapinaga mainana Nelafaga kagai kagimoꞋa alu aotage huno hanesie. ");
INSERT INTO kmu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kava yagaisana kanamoꞋa efalote hisie. Kahaisia kavala ikapinaga nehagi mopaleꞋenena kahaisia kavala hisae. ");
INSERT INTO kmu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Meni kanafina nesuna kavela tamio. ");
INSERT INTO kmu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tagaya havi kavaꞋma hu-la-tenaya veala aige amateta kefo yaꞋamia atale-ma-tona kava huka kefo yatia aige-tateka atale-lato. ");
INSERT INTO kmu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kana yapiꞋene SataniꞋma aye-lavataga hisia yapiꞋene tavaleka otato. SataniꞋa ‘Kefo kava hiho.’ hunoꞋma hu-la-tesigeka tahaꞋmaika tavalesaga huo.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Huteno mage huno hie tamakaya havi yama hu-lamatenaya veala aigeꞋama-tetetama kefo yaꞋamima atale-ma-tesayana ikapinaga mainea NelamafaꞋa aniꞋa huno kefo yatamia aige-tamateno atale-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Atale-lama-tegahigi tamakaiꞋma ali-havi yama hu-lama-tenaya veafena aigeꞋama-tetama kefo yaꞋamima atale-oꞋama-tesayana ikapinaga mainea NelamafaꞋa aniꞋa huno kefo yatamia aige-tama-teno atale-otamategahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tamakaya Anumaya Kotitegama havigegahena kavela mositama mainutama tamaugosa kalaguꞋnagu ohiho. Vagala veaꞋmoꞋya ani kava huꞋya amaugosafina hapaene taꞋnefaene faleteꞋya mage nehae “VeaꞋmoꞋya tageteꞋya kaveꞋma mosi-mainona kavala tagegahae.” huꞋya nehayanagi tamagelafa huꞋna tamaha-nepauve naꞋa kava nehaya veaꞋmoꞋya anonaꞋamia hai ali-mainae. Tamakaya aniꞋa kavala ohiho. ");
INSERT INTO kmu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Tamakaya Anumayamotegama havigegahena kaveꞋma mositama nemainutama titeti tamaugosa alitama masavema falesayana mukiꞋa veaꞋmoꞋya kaveꞋma mosisaya yafena ohavigahagi mai falakino mainea NelamafaꞋa falakino hanea yana agaiꞋage neꞋageafe anonatamia tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Monetamiene afenoꞋyatamienena ma mopale halaꞋya ohiho. HalaꞋya hu-malenesageno toto ayeno hakaꞋnomoꞋya ali haviya higeꞋya veaꞋmoꞋya notamifi haiꞋya ani yatamia musufa aligahae. ");
INSERT INTO kmu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","NaꞋa hugahagi ma mopafi yafena tamakesa havi havi ohutama haenagama ikapinaga kanale yama alisaya yafe meni kanafina Anumayamofe tamakesa havi havi hutama maiho. Ikapinaga mukiꞋa yama malesayana totona ayeno okasaligahie. HakaꞋnomoꞋa ali haviya ohugahie. NagoꞋa musufa veaꞋmoꞋya ani kumatela musufa yana ohugahae. ");
INSERT INTO kmu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Muse yatamima malenesaya kumatefe tamakesa havi havi hutama ani kumate umaigahae. ");
INSERT INTO kmu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","TamaulagamoꞋa tamakupinaga aye halesia lamu hane. TamaulagamoꞋa kanale yama huno agesiana tamakupinaga ai-hale-mainegi tamaulagamoꞋma kefo yama agesiana tamakupinaga hani-ki-maine. Ai-hale mainesia yamoꞋa tamakupima asu hisigenoꞋa hani kiteno ala hanikefa kino aye-talako hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nagoke kanomoꞋa “Tole kava kanolatamo aliꞋya kanoꞋania maisue.” huno ohisie. NaꞋama hisiana nago kava kanomofena “Nahaiya kano mainane.” huno hu-tegahianagi nago kava kanomofena “Hai vaiteno naipa nagata aiya kano mainane.” huno hugahie. Nago kava kanomona aguꞋa amiteno nago kanomofena “Falote onahaiya kava nehane.” huno hugahie. Tamakaya aniꞋa hutama Anumaya KotifeꞋene moneheꞋenena ali lokaeꞋana “Kava yagai-natesaꞋe.” hutama ohiho. ");
INSERT INTO kmu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ani yafe nagaya tamaha-nepauve kanaleꞋya hutama maisaya yaꞋene kave nesaya yaꞋene ti nesaya yaꞋene tamakesa havime havime oꞋviho. Tamaugafale kena failisaya yafeꞋenena tamakesa havi havi ohiho. Kave neyana aifa letale yanagi tamahaimula kanaleꞋya hutama maisaya ya hane. Kena fai-lisana yana amegale yanagi veaꞋnea tokiyaꞋage ya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","HaleꞋyama vaiyatete nehaya namayaga ageho. Amakaya avina yana nofaiye. Kavela hoyafinagati aliꞋya nopina mo nomalagi ikapinaga mainea nelamafaꞋa kavela neꞋamamigi tamakaya Anumaya Koti aulagafina namayaga amakasetama mainaya veaꞋne mainayafe tamakaiꞋenena kava yakai-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tamakaipitila nago kanomoꞋa “OfaliꞋna nagoꞋene maime maime haigahue.” huno tokiyaꞋage agesama havisiana anima havisia katela hanaꞋa huno falote hugahie? AꞋao falote ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","NaꞋa higetama kenatamihena tamakesa havi havi nehae? Ageho talapinaga vilasiyamoꞋya haiꞋya ausea nehae. AliꞋyana aliꞋya kenaꞋamia talo huꞋya fai-noꞋaligi kanale kenaꞋamia hanegeꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nagaya tamaha-nepauve nayoma mainea ala sauve kanotamia SolomoniꞋa kanale kenaꞋa fai-lianagi ma vilasiyamoꞋa kanaleꞋya huno agase-maine. ");
INSERT INTO kmu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tala yana meni kanafina hoyafina haneanagi ega hataga huꞋya atafi kae-talegahagi Anumaya KotiꞋa ani tala yana kava yagaigeno kanaleꞋya huno hanegi tamakaya mukiꞋa veaꞋmogatama nagaifena tamakupi maletama tamametitia osi kanoꞋa nehayanagi Anumaya KotiꞋa aniꞋa huno tamakaila kenatamia alino hilato hu-lamategahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ani yafe “KaveꞋene tiꞋene na ya negahune?” hutama tusiꞋa tamakesa havi havi ohiho. “Na kena fai-ligahune?” hutama tamakesa ohaviho. ");
INSERT INTO kmu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ani augafa yafena Anumaya Koti kema nohaviya veaꞋmoꞋya amakesa havi havi huꞋya nemaigi ikapinaga NelamafaꞋa nesaya yaꞋene kena fai-lisaya yaꞋenefena ago havimaine. ");
INSERT INTO kmu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Havimaineafe tamakaya hagotetama Anumaya KotiꞋma kava yagaisia kumate visaya yafeꞋene agaiꞋama nehaiya fatago kavaꞋma hisaya yafeꞋene tamakesa havi havi hisayana Anumaya KotiꞋa ani yaꞋene mukiꞋa kavetamiene kenatamienena tamamiteno ani kumatela tamavaleno tamategahie. ");
INSERT INTO kmu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","NaꞋa hu-maineafe “Ega hanaꞋa hugahune?” hutama tamakesa ohaviho. Egama efalote hisiana tamakesa havi havi hisaya yaꞋenena efalote hugahie. Nagoke yupa falote hisia kana yana ani yupa kanoꞋage tamakesa haviho. ");
INSERT INTO kmu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nelamafufena “NaꞋa maꞋa hana kano mainane.” hu-oꞋateho. AniꞋama ohisagenoꞋa Anumaya KotiꞋa tamakaifena “Havi kava haya veaꞋne mainae.” huno hu-otama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tamakaya ani veafema “NaꞋa maꞋa hana kano mainane.” hutama hisayana ani augafa keleti Anumaya KotiꞋa tamakaila aniꞋa hu-lama-tegahie. Ma mopaleꞋma nelama-fugamima hu-ma-tesaya kavala Anumaya KotiꞋa tamakaila ani kava hu-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tagaya tagaiti taguꞋafima hanea yana oꞋageneta alu veaꞋnehena “Havi veaꞋne mainae.” huta hisuna yafena YisasiꞋa mage huno hu-maine “Negafu aulagafina osiꞋa havi yana hanegeka neꞋagananagi naꞋa higeka kagaikaꞋa kaulagafina nagola muki yosa-lapagefa haneanagi ‘Omalene.’ huka nehane? ");
INSERT INTO kmu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","NaꞋa higeka nega-fufena ‘Kaulagafitila havi yana ali-talegahue.’ huka nehananagi kagaikaꞋa kaulagafina nagola muki yosa-lapagefa hane. ");
INSERT INTO kmu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","KaguꞋafinaga hanea yana agelama ohuneka kavayaleti havige huka vagala kano maineka kagaikaꞋa kaulagafitila muki yosa-lapagefa ali-taleteka kanaleꞋya huka ageteka negafu aulagafina osiꞋa havi yana ali-talegane huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tamakaya Anumaya Kotina alu aotage yana alitama kalamogamina oꞋamamiho. Amamisayana mahaiye huꞋya tamakaila akafu tamanigahae. Afumogamina kanale sesua hagaꞋyu hutama oꞋamamiho. Amamisayana amaiyaleti ayeꞋya hapa kaligahae.” ");
INSERT INTO kmu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Anumayamotega nago yafema havigesagenoꞋa afaꞋa tamamigahie. Nago yafema atiyesagenoꞋa ali falote hugahie. FitaleꞋma akalu kaluma hisagenoꞋa Anumaya KotiꞋa yaki-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","MukiꞋa havigesaya veaꞋmoꞋya aligahae. Ati ayesaya veaꞋmoꞋya ali falote hugahae. FitaleꞋma akalu kaluma hisagenoꞋa Anumaya KotiꞋa yaki-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hana kanomoga nafaꞋnekamoꞋma mayahema kahavi-gesigeka nefaga yafana alika amigane? AꞋao ani yana oꞋamigane. ");
INSERT INTO kmu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Noyamehema kahavi-gesigeka nefaga osifaꞋvea alika amigano? AꞋao ani yana alika oꞋamigane. ");
INSERT INTO kmu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","OꞋamiganagi tamakaya havi veaꞋne mainayanagitama nafaꞋnetamimona kanale yana neꞋamamiyanagi ikapinaga mainea nelamafaꞋa tusiya huno tamakase-maineanagitama havigesagenoꞋa kanale yana tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Veafe “MaꞋa kava hu-latesae.” hutama hisaya kavala ani kavakeꞋya alu veaꞋnea hu-mateho. Ani yafena MoseseꞋene Anumaya Koti amaune vayaꞋmoꞋyaene hu-mainaya kahegi kemona aepaꞋa hane. ");
INSERT INTO kmu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Anumaya Koti kumateꞋma visayana osi fia kanoꞋafi ugahae. Hani-ki-mainea kumapi tegelege nehia atafi visaya kaana ala hiꞋyenagefa haneno ala kakefa hanegeꞋya kasagoꞋya veaꞋmoꞋya yoꞋyo huꞋya ani katela neꞋvagi tamakaya osi fia kanoꞋafi hai-faleho. ");
INSERT INTO kmu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Agola maige maige hisuna kumateꞋma visaya kaana osi fia kanoꞋa haneanagiꞋya kasageke huꞋya ani katela kasagoꞋya veala noꞋvae. ");
INSERT INTO kmu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","NagoꞋa vayaꞋmoꞋya “Anumaya Koti ke hu-haleta nehuna vaya mainone” huꞋya havigegeꞋyama hisaya vayafena kaꞋyeho. Yuna afu kana vaya mainagetama neꞋagayanagi amakusafinaga kaveꞋage afu kana vaya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tamakaya amakaipima falote nehia kavala agetetama aepaꞋa hana augafa vaya mainae hutama havigahae. Ave nofite timaꞋa hanea alaga tagisifi? AꞋao otagigahie. Avetanafa hanea uveꞋuve inomote hagaꞋage yosalaga motaga molagisio? Otagigahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Otagigahigi kanale yosamoꞋa kanale yosalaga neꞋayegi havi yosamoꞋa havi yosalaga neꞋaye. ");
INSERT INTO kmu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kanale yosamoꞋa havi yosalaga noꞋayeanagino havi yosamoꞋa kanale yosalaga oꞋayegahie. ");
INSERT INTO kmu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","MukiꞋa yosamoꞋya kanale yosalaga oꞋayesayana atagiꞋya atafi kae-talegahae. ");
INSERT INTO kmu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","NaꞋa hinagetama havigegeꞋyama huꞋya falote nehisaya vayapiti falote hisia kavala agetetama aepaꞋa “Hana augafa vaya mainae.” hutama havigahae. ");
INSERT INTO kmu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","MukiꞋa veaꞋmoꞋya nagaifena “Anumayatimogae Anumayatimogae.” huꞋya hisaya veala Anumaya KotiꞋma kava yagai-mainea kumatela ohaigahagi ikapinaga mainea Nenafana hau-mainesia kavaꞋma nehisaya veaꞋmoꞋya ani kumatela umaigahae. ");
INSERT INTO kmu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anumaya KotiꞋa kaiyekema hu-matesea yupa kasagoꞋya veaꞋmoꞋya nagaifena mage huꞋya hugahae “Anumayatimogae Anumayatimogae tagaya kagai kagile Anumaya Koti kea hu-haleta nehunane. Kagai kagile Kefo Avamula neꞋanatita tokiya avame yana amave-nelunane.” huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hugahayanagi nagaya ani yupa mage huꞋna hugahue “Tamakaila otamaketafa hu-mainoane. Kefo yakeꞋya hugetama omai veaꞋnegi nagaitegatila mai-haletama viho huꞋna hugahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","NagoꞋa veaꞋmoꞋya anima hu-mainoa kea haviꞋya ali hipoꞋya huge huge huꞋya nago kanale agu agesaene kanomo avamete nehae. Ani kanomoꞋa noma kiana yafa agotofule ki-malene. ");
INSERT INTO kmu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ki-malenegenoꞋa koꞋma aino tima hogino tokiyaꞋage yasimoꞋa tusiya huno nona ali-lagape aigahe hianagi yafa agotofule ki-malenea yafe alino lagapea ai-oꞋatalene. ");
INSERT INTO kmu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Alino lagapea ai-oꞋatalenegi nagoꞋa veaꞋmoꞋya nagai kema haviteꞋya ali hipoꞋya ohayana agesama omalea kanomo avamete nehae. Ani kanomoꞋa ti kahaepapi nomaꞋa ki-malene. ");
INSERT INTO kmu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ki-malenegeno koꞋma aino tima hogino tokiyaꞋage yasimoꞋa alino ani nona ali lagape aino mopafi atalegeno tusiya huno haviya hu-lavi-maine huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","YisasiꞋa mani kea hu-haꞋno hutegeꞋya kahegi kema havilinaya anagaꞋmoꞋya nehaya augafa ke kana huno ohunegi tokiya yamaꞋa hanea kanomo ke kana hia yafe mukiꞋa veaꞋmoꞋya tusiꞋa amamaꞋyo ai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nagi YisasiꞋa agoꞋyalegati tavigeꞋya kasagoꞋya veala akave umainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Akave neꞋvageno nagola fugitayamo augafa alino haꞋyagino atalako hu-mainea kanoa Yisasite eno ape huno mage huno havige “Anumayamoga kahaisigekahena nagaila alika hilato hu-natateꞋasine.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Higeno YisasiꞋa ayana haꞋyo huno augafale avate hu-lineno mage huno hie “Nagaya nahaigeꞋna kaugafamoꞋa menia kanale hino huꞋna nehue.” huno higeno anile aupaꞋa kaliꞋa haꞋno hu-tene. ");
INSERT INTO kmu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","YisasiꞋa mage huno hapaiye “Ali hilato hu-ga-toa yafena nago kanoa haꞋopaika mono nopi kava kanomote* uka kalikaꞋama ali kanale hu-ga-toa kema mukiꞋa veaꞋmoꞋya havinuꞋyahena kagaya mono nopi kava kanomoꞋa kaugafa kamota huno kage-tesigeka kaugafama ali hilato hu-ga-toa yafena MoseseꞋma ‘Ma yama Anumaya Kotina amio.’ huno hu-mainea yana Anumaya Kotitega atalo.” huno tokiyaꞋage ke hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","YisasiꞋa Kapaneamu uvaꞋyi higeno nagola Lomu ati vayate kava kanomoꞋa mage mo havige “Anumayamoga naya hisano? AliꞋya kanoꞋnimoꞋa muki augafa avayu hu-lavigeno tusi agata aigeno nopi nemaiye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Higeno YisasiꞋa mage huno hie “Nagaya kaliꞋa mo aliꞋna kanale hu-tegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Higeno Lomu ati vayate kava kanomoꞋa mage hie “Anumayamoga nagaya kanale ohunoa kanomoni nopi esanana okategahigi afaꞋa malegati aliꞋya kanoꞋnimo kaliꞋahena keꞋa hu-tesanageno kaliꞋa falu hu-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nagaya kava kano mainoe. NagaiꞋma kava yagai-natenea kanoa anale nagaseno maigeꞋna nagaya aniꞋa huꞋna nagoꞋa ati vayatela kava huꞋna mainoe. Nago kanomofema ‘Vuoma.’ hugenoꞋa umaine. ‘Enoma.’ hugenoꞋa emaine. AliꞋya kanoꞋnihe ‘NaꞋa huo.’ hugenoꞋa aniꞋa hu-maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","YisasiꞋa ani kea haviteno agesa kuꞋmoꞋa tusiya huteno akaveꞋma neꞋvaya veaꞋmogamifena mage huno hie “Tamage tamaha-nepauve ma kanomoꞋa tusiya huno nagaifena havino agupi maleno ametitia hu-maine. Ma kanomoꞋma hia ya huꞋya nagaifema haviꞋya amakupi maleꞋya ametiti hu-mainaya veala mukiꞋa Yuta veaꞋne mainaya kumatela oꞋagenoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tamaha-nepauve mukiꞋa veaꞋmoꞋya yagemoꞋma tavi nefalelegatiꞋene evaꞋyi nehilegatiꞋene Anumaya KotiꞋma kava yagai-mainea kumatela taginagomoꞋya ApalahamuꞋene AisakiꞋene YekopuꞋene siale mo maineꞋya kavela negahae. ");
INSERT INTO kmu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Negahagi nagoꞋa Yuta veaꞋmogamina nayoma Anumaya KotiꞋa “Kava yagaisua kumate maigahae.” huno hu-maineanagi agaifema haviꞋya amakupi omalaya yafe Anumaya KotiꞋa amavaleno hani yapi amatalesigeꞋya anifi avi neꞋateꞋya amave kemoꞋa hugahae huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","YisasiꞋa Lomu ati vayate kava kanomofe mage huno hie “Nokalega eteka vuo. AliꞋya kanokama ali falu hu-tesua kea havika kagupi maleka kametiti hana kea hu-ga-tegahue.” huno higeno ani kema hia kana kanoꞋale ani aliꞋya kanoꞋa kanale hu-tene. ");
INSERT INTO kmu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","YisasiꞋa Pita nopinaga umaineno ageana Pitana aꞋamona itaꞋamo alekanoa tusiꞋa amukonako kali alino mainegeno moge-maine. ");
INSERT INTO kmu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mogeteno ayate avate nehigeno amuko-nako kaliꞋamoꞋa agola kanale hu-tetegeno ani aꞋmoꞋa hetino kavela kaeno amamine. ");
INSERT INTO kmu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ani unena mukiꞋa ani kumate veaꞋmoꞋya vayaꞋamima Kefo AvamuꞋmo amakusafima mainea veala amavaleꞋya Yisasite ageno YisasiꞋa Kefo AvamuꞋmogamifena hu-mategeꞋya amataleꞋya vageno mukiꞋa kali veala alino kanale hu-matene. ");
INSERT INTO kmu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","NaꞋa hu-maineafe nayona Anumaya Koti aune kanomoꞋa, AisaiyaꞋa hu-mainea kemoꞋa agola falote huno tamage hie. Mage huno hu-maineane “Agaya agaiꞋa kalima neꞋaluna yana ali-talene. TaugafamoꞋa fulu fuluma nehuno akavima nohia yaꞋene ago ali-talene.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","KasagoꞋya veaꞋmoꞋya Yisasite meye-kove hageno YisasiꞋa agaiꞋaene tokaeꞋya nemaiya anagafe mage huno hie “Tikotumona atu faliga vigetao.” huno higeꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Umainageno nagola kahegi kema havilinea kanomoꞋa Yisasite eno mage huno hie “Hu-mave-lina kanomoga mukiꞋa kumate visanana nagaya kakave ugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Higeno YisasiꞋa kenonaꞋa mage huno hapaiye “Kepu yagamoꞋya faesaya komuꞋamia mopafinaga hanegi namamogamina noꞋamia haneanagi ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna faesua noniꞋa omalene.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nagola agai kema nehavia kanomoꞋa mage huno hie “Anumayanimogae nenafana falisigeꞋna aliꞋna he-vai-teteꞋna kakavela ugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Higeno YisasiꞋa mage huno kenonaꞋa hapaiye “Atalo nagai kea ohavinesaya veala amaku amamemoꞋa fali-mainaya veaꞋmoꞋya falia kanomona aliꞋya he-vai-tegahae amakaiꞋami yanagi kagaya nakave eno.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","YisasiꞋa tipi kalefi haisaga hu-maigeꞋya agaiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya agaiꞋene umainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","NeꞋvageno aupaꞋa anileti ala yasimoꞋa neꞋaligeno timoꞋa ai-galato huno ani tipi kalefi haiyanagi YisasiꞋa aufaeno maine. ");
INSERT INTO kmu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Faeno mainegeꞋya agaiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya agafa huꞋya mage huꞋya hae “Kava kanomogae kava kanomogae tagaya ti nakaita falisuna kava nehunagi Anumayamoga hetika taugafa ali-gatio.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hageno mage huno hama-vi-ge “NaꞋa higetama kolia nehae? Nagaifena havitama tamakupi maletama tamametitima nehaya yamoꞋa aupa nehio?” huno huteno hetino ani limofeꞋene yasimofeꞋene tokiyaꞋage ke huno “Taga huo.” huno higeꞋana alava hu-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Alava haꞋageꞋya mukiꞋamoꞋya amamaꞋyoma aiya yafena mage hae “Mani kanoa hana augafa kano mainegeno timoꞋene yasimoꞋene keꞋa haviteꞋya akave nemalae?” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ala tikotuna takaeꞋya ame kaiyaga agegayamona Kelasasa* veaꞋne mainalega uvaꞋyi hae. UvaꞋyi hageꞋana tole kanolana Kefo AvamuꞋyaga anakuꞋafi mainea kanolana matimatipinagati Yisasite emainaꞋe. Ani kanolatana tusi aifoꞋnafo nehaꞋa yafe veaꞋmoꞋya koli huꞋya ani katela noꞋvayane. ");
INSERT INTO kmu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","OꞋvageꞋana ani kanolatana ala kefiti mage huꞋana haꞋe “Anumaya Kotina neꞋamogae naꞋa hu-laꞋategahe neꞋane? TaꞋagata aisia kanamoꞋa falote ohunegi taꞋagata aisia kava hu-laꞋategahe neꞋano?” ");
INSERT INTO kmu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","HaꞋageꞋya kasagoꞋya afuyagamoꞋya aluꞋale maineꞋya kavela nenae. ");
INSERT INTO kmu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","NenageꞋya Kefo AvamuꞋmoꞋya Yisasife mage huꞋya hu-mainae “AnakusafinagatiꞋma hu-latesanana ani afuyagamo amakuꞋafi hu-lategeta vamano.” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Havigageno YisasiꞋa “Anifi viho.” huno higeꞋya ani Kefo AvamuꞋmoꞋya ani kanolatamogani anakuꞋafitila hati-laviꞋya afuyagamogami amakupi hai-falageꞋya ani afuyagamoꞋya amaiya-yeꞋya nagola aulufi kapi taviteꞋya tipi asaga hu-laviꞋya ti nakaiꞋya fali haꞋno hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Fali haꞋno hageꞋya ani afuyagale kava vayaꞋmoꞋya ageteꞋya faleꞋya ala kumate mainaya veaꞋmogamife “Kefo AvamuꞋmoꞋya anakuꞋafi mainea kanolatamoganina na kava na kava hu-nateno higeta neꞋone.” huꞋya hama-pai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","HageꞋya ani ala kumateꞋma mainaya veaꞋmoꞋya ani ya agegahe eꞋya Yisasina megeteꞋya “Tagai kumala neꞋataleka alu kumate vuo.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","YisasiꞋa tipi kalefi haisaga hu-maino tikotumona takaeno agaiꞋa kumatega eteno umaine. ");
INSERT INTO kmu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","UmainegeꞋya nagoꞋa vayaꞋmoꞋya nago kanomona aiya aya fali-mainea kanoa hagifanale faeno mainegeꞋya avaleꞋya Yisasite emainae. Ageno YisasiꞋa ageteno mage huno agesafinaga havimaine “Ma vayaꞋmoꞋya nagaife haviꞋya amakupi maleꞋya amametiti nehae.” huno agesa haviteno ani kali kanohe mage huno hapaiye “NafaꞋneꞋnimoga kaha-nepauve menia kolia ohuo nagaya ago aige-ka-teꞋna kefo yakaꞋa atale-nega-toe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","HigeꞋya kahegi kema havi-linaya anagaꞋmoꞋya amakaiꞋami amakuꞋafiti mage huꞋya hae “Ma kanomoꞋa Anumaya Kotife hu-haviya hu-neꞋate.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hageno YisasiꞋa amakupinaga haviya kea haviteno mage huno hie “NaꞋa higetama tamakaya tamakesafinaga havi kea nehae? ");
INSERT INTO kmu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nagayama huteꞋna hisua kea hana kemo kanaꞋagela hu-maine? ‘Aige-ka-teꞋna kefo yakaꞋa atale-neka-toe.’ huꞋna hisua kemoꞋo? Ifi kali kanomofe ‘He-ti-ka ka vuo.’ huꞋna hisua kemoꞋe? ");
INSERT INTO kmu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna ma mopale maineꞋna aige-tama-teꞋna kefo yatamia atale-lama-tesua tokiyaꞋnia hane hutama havisaya yafe nago kavala huꞋna tamave-ligahue.” huno kalima neꞋalia kanomofena mage huno hie “Hetika hagifanaka neꞋalika nokalega vuo.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Higeno hetino nomaꞋalega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","NaꞋa higeꞋya mukiꞋa alitalu hu-mainaya veaꞋmoꞋya ageteꞋya tusi amamaꞋyo aiteꞋya Anumaya KotiꞋma tokiya yaꞋama vayaꞋmogamima amamia yafena Anumaya Koti agia alisaga hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Anile neꞋamataleno vilegati nago kanomo agia MatiuꞋe musufaya huno vaya amaugafaleti takisi mone ali-liteno nehia kanoa opisi nomaꞋale mopale mainegeno YisasiꞋa ani kanoa mogeteno mage huno hie “Kagaya nakave eno.” huno higeno MatiuꞋa hetino Yisasina akave umaine. ");
INSERT INTO kmu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Vigeno YisasiꞋa Matiu nopi umaineno kave negahe musufayama huꞋya amaugafaleti takisi mone neꞋaliya vayaꞋene nagoꞋa kefo yama nehaya vayaꞋene ani nopi YisasiꞋene agaiꞋenema tokaeꞋya nemaiya anagaꞋaene tokaeꞋya maineꞋya ne-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","NenageꞋya Falasia vayaꞋmoꞋya YisasiꞋenema tokaeꞋya nemaiya anagafe mage huꞋya hae “NaꞋa higeno tamakaiꞋma hu-lamave-nelia kanomoꞋa amaugafaleti takisi monema neꞋaliya vayaꞋene kefo yama nehaya vayaꞋenena kavela nene?” huꞋya hama-vigae. ");
INSERT INTO kmu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hageno YisasiꞋa ani kea ago haviteno mage huno hama-paiye “Kalima noꞋaliya veaꞋmoꞋya tota kanomotega oꞋugahagi kali veaꞋmoꞋyage tota kanomotega ugahae. ");
INSERT INTO kmu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nagaya aniꞋa huꞋna ‘Fatago veaꞋne mainone.’ huꞋya nehisaya veaꞋnehe ke hugahe nagaya omenogi kefo yama nehaya veaꞋnehe ke hugahe emainoe. Anumaya KotiꞋa agaiꞋa hu-mainea kea mage huno hu-maineane Afu heꞋya kolamaꞋa takiꞋya naminaya yafena onahaunegi kalagi ai-ma-taya yafekeꞋya nenahaiye huno hu-maineane. Hu-maineanagitama tamakaya ani kemo aepaꞋa mo havilama hutetama ani kavala hiho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yoni anagaꞋmoꞋya Yisasite mage huꞋya me havigae “Tagaya Yoni anagaꞋmogataene Falasia vayaꞋene nagoꞋa kavela mo-nesunanagi naꞋa higeꞋya kagaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya mukiꞋa kavela nenae?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hageno YisasiꞋa mage huno hie “Nago kanoa aꞋama faiꞋya esagenoꞋa avaya hesia imu kisia yupa vayaꞋamoꞋyaene mainesigeꞋya ani vayaꞋmoꞋya hamauna hu-tesao? AꞋao hamauna hu-oꞋategahayanagiꞋya haenagaꞋa nago kanama falote hisigeꞋya kame vayaꞋmoꞋya aꞋma alisia kanoa atafa huꞋya amakaipiti avale-talesageꞋya ani kanale vayaꞋamoꞋya hamau hu-teteꞋya mosigahae. ");
INSERT INTO kmu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nago kanomoꞋa haegafa kena alino atafa kenalela maleno ohatigahie. Maleno hatisiana haegafa kena atalaga huno ali haviya hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nagi nago kanomoꞋa haegafa nofi alagamo timaꞋa* atafa mememo augafa ti keꞋayopina takino oꞋvaigahie. Takino vaisiana timaꞋamoꞋa kaꞋnuka hesigeno ti kena falo huno taki-lavinageno ti kena ali haviya hugahie. Haegafa nofi alagamo timaꞋa hefino haegafa meme augafamo ti keꞋayopi takino vaino. AniꞋa hisayana tiꞋene keꞋayoꞋene kanaleꞋya huno hanegahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","YisasiꞋa ani kea nehigeno nagola soka kanomoꞋa Yisasi aiyafi aleꞋya meyeno Yisasina mage huno hapaiye “MunaꞋniꞋamoꞋa ago fali-mainegi kagaya kayana augafale me malesanageno fali-mainefitila eteno he-tisie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Higeno YisasiꞋa hetino anilega vigeꞋya agaiꞋenema tokaeꞋya nemaiya anagala akave umainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","NeꞋvageno nago aꞋmoꞋa tuelufuꞋa (12) kafu aigu nopinaga mukiꞋa kanale nemaiya aꞋmoꞋa Yisasina akavelegati eno kenaꞋamo atupale mevate hie. ");
INSERT INTO kmu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Avate neꞋalino agupi mage huno hie “KenaꞋaleke avate alisugeno kaliꞋnimoꞋa haꞋno hu-nategahie.” huno avate neꞋalie. ");
INSERT INTO kmu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Avate higeno YisasiꞋa mai-yahae huno ani aꞋmona ageteno mage huno hapaiye “Ma aꞋmoga kolia ohuo nagaifema havika kagupi maleka kametitima hana yamo kagaila alino kanale hu-negate.” huno higeno aupaꞋa kaliꞋamoꞋa kanale hu-tene. ");
INSERT INTO kmu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Kanale hu-tegeno YisasiꞋa soka kanomo note uvaꞋyi huno hamau nehuꞋya kapufama haya veaꞋnene avima ataya veaꞋnene ali-talu huꞋya maineꞋya tusi ke-yesoma haya kea haviteno mage huno hie “Viho mani munala fali lavata ohunegi afaꞋa faeno maine.” huno hama-paiye. HigeꞋya ani munaꞋma faligeꞋya age-mainaya yafenagiꞋya kigi hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hu-teteꞋya kumatega umainageno YisasiꞋa nopinaga haino ani munaꞋmo ayate atafa nehigeno aupaꞋa hetie. ");
INSERT INTO kmu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","He-ti-teanagi YisasiꞋma hia yamo avagemoꞋa ute ete higeꞋya mukiꞋa ani kotega veaꞋmoꞋya havi-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","YisasiꞋa ani kumala ataleno neꞋvigeꞋana tole kanolana anaulaga asu hu-mainea kanolana akave neꞋuꞋana ala kefiti mage haꞋe “Kagaya Tevitina aginagomogae taꞋagaila kahau hu-laꞋato.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","NehaꞋageno YisasiꞋa nopinaga hai-falegeꞋana anaulaga asu hu-mainea kanolana agaite aꞋageno YisasiꞋa ani kanolafena mage huno hana-vige “Nagaya tanaulaga aliꞋna hale-lanatesua tokiyaꞋnia hanea yafena tanakupina malenaꞋao?” huno higeꞋana “E, Anumayamogae kagaya aniꞋa hu-laꞋatateꞋasine.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nage haꞋageno YisasiꞋa anaulagale aya maleno mage hie “Tanakaya nagaife havitana tanakupi malaꞋa yafe hu-lana-tegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","HigeꞋana ani kanolamogani anaulagamoꞋa ai-gali hu-maine. Higeno YisasiꞋa anakaifena tokiyaꞋage ke huno kahegi ki-nateno mage huno hie “Mani yama hu-lana-toa yafena nagoꞋa veala hamaꞋopaiꞋo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hianagi ani kanolamogania uꞋana mukiꞋa ani kotega veaꞋmogamina YisasiꞋma hu-na-tea avagea hu-liteꞋana hu-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ani tole kanolana utaꞋageno nago kanomona Kefo AvamuꞋmoꞋa* aguꞋafi maineno avefuꞋna alino ai-yahae higeno agea noꞋaiya kanoa Yisasite avaleꞋya ae. ");
INSERT INTO kmu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ageno YisasiꞋa agema noꞋaiya kanomo aguꞋafiti Kefo Avamula anati-talegeno agea aino kea kea higeꞋya alitalu hu-mainaya veaꞋmoꞋya ageteꞋya tusiꞋa amamaꞋyo neꞋaiꞋya mage hae “Mani augafa kavala nayona Isaleli kotega oꞋagenaya kavale.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hayanagi Falasia vayaꞋmoꞋya mage huꞋya hae “PielesepuliꞋa Kefo AvamuꞋyagale kava hu-mainea kanomoꞋa tokiya amigeno Kefo AvamuꞋmona anati-neꞋatale.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","YisasiꞋa ala kumateꞋene nagoꞋa ala kumaꞋyagaleꞋene osi kumaꞋyagaleꞋene neꞋuno mono nopi huge amave-lige huno Anumaya Koti kava yagai-ma-tesia kanale mono kea hama-nepaino mukiꞋa kalia alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hu-neꞋama-teno kasagoꞋya melitalu hu-mainaya veala amaketeno hau hu-ma-tene. Ani veaꞋmoꞋya kana yapi mainageno amakesa kuꞋmoꞋa tusiya higeꞋya sipi sipi kana huꞋya mainayanagi kava yagaisaya vayala omainaya yafe YisasiꞋa kalagi ai-matene. ");
INSERT INTO kmu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Kalagi ai-mateteno YisasiꞋa agaiꞋenema tokaeꞋya nemaiya anagafe mage huno hama-paiye “Nagai kema havisaya veala kasagoꞋya kaveꞋmoꞋma hoyafima afule-mai-lemai hia kava hu-maineanagi hoyafima aliꞋya alisaya veala osi kanoꞋa mainayafe ani hoyamona Nefafena havigegeno nagoꞋa aliꞋya veala hu-matesie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","YisasiꞋa agaiꞋa tuelufuꞋa (12) anagaꞋamogamife ke higeꞋya ageno tokiyaꞋa amamine. MukiꞋa Kefo AvamuꞋma veaꞋmogami amakusafiti anati-talesaya tokiyaene mukiꞋa kalima aliꞋya kanale hu-matesaya tokiyaene amamine. ");
INSERT INTO kmu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","AgaiꞋa tuelufuꞋa (12) anagaꞋamogami amakia hagote kanomo agia SaimoniꞋe nago agia PitaꞋe aganaꞋamoꞋa EtaluꞋe Yemesigani Yonigania Sepeti nafaꞋnelataꞋene FilipiꞋene PatolomayuꞋene TomasiꞋene amaugafaleti takesi mone neꞋalia kanoa MatiuꞋene YemesiꞋa, Alafiusi nafaꞋne. TatiusiꞋene Saimoni SelotiꞋene Yutasi IsakaliotiꞋa haenaga Yisasina agesi huno kame ya hu-tesia kanoe. ");
INSERT INTO kmu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","YisasiꞋa ani tuelufuꞋa (12) anagaꞋa hu-neꞋamateno mage huno hama-paiye tamakaya Yuta vea omainaya veaꞋmogamitela oꞋviho. Samelia veaꞋmogami kumaꞋyagaleꞋene oꞋviho. ");
INSERT INTO kmu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","OꞋugahagi tamakaya vaꞋyagi mainaya sipi sipi afuyaga kana hu-mainaya Yuta veate viho. ");
INSERT INTO kmu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","NeꞋutama mani ke hu-haletama hama-paiho “Anumaya KotiꞋa kava yagai-lama-tesia kanamoꞋa ago aupaꞋa falote hugahie.” hutama hiho. ");
INSERT INTO kmu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nehutama kali veaꞋnea ali kanale hu-matetama fali-mainesaya veala ali heꞋnelitama fugitaya amake-mainesia veala ali kanale hu-neꞋama-tetama Kefo Avamula veaꞋmogami amakusafinagatila amanati-taleho. Nagaya kanale yana afaꞋa nelamamuanagi anonaꞋa oꞋalinoane. AniꞋa hutama anonaꞋa monea oꞋalitama afaꞋa amaya hiho. ");
INSERT INTO kmu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tamakaya tamia alaga monene haesa monene kutamifina ai-oꞋaliho afaꞋa viho. ");
INSERT INTO kmu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tamakaya kama visalega kutamia oꞋalitama oꞋviho. Tole kena oꞋaliho. Tamaiya noꞋene ayopatamiene alitama oꞋviho. Nagai aliꞋyama alisaya yateti veaꞋmoꞋya anonaꞋa kaveꞋma tamamisayana tama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tamakaya nago ala kumatelo osi kumatelo uvaꞋyi hisagenoꞋma nago kanomoꞋma kanale yama hu-lama-teno fatago kavaꞋma hisia kanoene maiho. Fae-litetama ohutama ataletama visaya yupa ani nopinagati viho. ");
INSERT INTO kmu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tamakaya nago nopima hai-falenutamahena hagotetama mage hutama hiho “Ma nopi mainaya veaꞋmogatama Anumaya KotiꞋa yuna hesaya tamaku tamakesa tamamisie.” hutama hu falu fala hu-mateho. ");
INSERT INTO kmu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hu-matesageꞋya ani nopi mainesaya veaꞋmoꞋya fatago kavaꞋma nehisaya veaꞋma mainesagenoꞋa Anumaya KotiꞋa yuna hesaya amakesa amamigahianagi aniꞋa augafa veaꞋnema omainesayana anima yuna hesaya yana oꞋaligahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","NagoꞋa veaꞋmoꞋya tamavaleꞋya noꞋamifima otama-teꞋya ketamima ohavisagetamahena ani kumala neꞋataletama “Havi kava hae.” hutama tamaiyafima hanesia kugukege yana ai-fopo hu-neꞋataletama alu kumate viho. ");
INSERT INTO kmu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tamage-lafa huꞋna tamaha-nepauve Anumaya KotiꞋa kaiyekema hu-matesia kanafina Sotomu mainaya veaꞋmoyaene Komola mainaya veaꞋmoyaene amaugafa amagata aigahianagi tamakaiꞋma falu fala hu-otama-tesaya kumate veaꞋmoꞋya anima kaiyeke hu-ma-tesia yupa tusiya huno amagata aigahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Haviho nagaya tamakaila hu-lama-togetama sipi sipi kana hutama afai kala kana kaveꞋage veaꞋne mainesaya amuꞋnopi hu-lama-tesugetama visageꞋya hu-haviya hu-lama-tesagetama osifaꞋvemo kalope lavino neꞋvia avamete hutama tamakesaene vayalagi nama kana hutama kefo yana ohutama yuna hetama maiho. ");
INSERT INTO kmu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tamaugafa ali haviya hu-lama-tesaya vayafena kaꞋyeho. VayaꞋmoꞋya tamavaleꞋya kanisole vayate kaiyeke mo hu-lama-teꞋya mono nopina kaꞋyona tamamigahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tamakaya nagai kema akave malenaya yafe tamakaila Kamani kava vayateꞋene ala Sauve vayateꞋene kaiyekea hu-lama-tesaya yafe tamavaleꞋya amaufi tama-tesagetama nagai kanale mono kea hama-paisageꞋya nagoꞋa Yuta veaꞋne omainaya veaꞋnene havigahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tama-valeꞋyama kaiyekema hu-lama-tesaya yate tama-tesagetama kolia ohutama “KenonaꞋamia naꞋane hisune?” hutama tamakesa kuꞋmoꞋa ohiho. Ani yupa kanoꞋa Anumaya KotiꞋa “Mage hiho.” huno tamaha-painagetama hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","TamakaitamigeꞋya ani kea ohugahagi Nelamafa AvamuꞋmoꞋa ani kea tamakaila tamavayafiti hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ani kanafina veaꞋmoꞋya amakaiꞋami nepuꞋamimona kame vayaꞋamimote amavaleꞋya visageꞋya “HamaegeꞋya faliho.” huꞋya hugahae. NefaꞋa nafaꞋneyagaꞋa ani kava hu-ma-tegahae. NafaꞋneyagamoꞋya itaꞋafoꞋamimogamina ali-yahae huꞋya kamea hu-ma-teteꞋya “Hamaetama faliho.” huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nagima neꞋayaya yafe mukiꞋa veaꞋmoꞋya amaipa kafa he-lama-tegahagi nagoꞋa veaꞋmoꞋya nagai kema meni kanaleti aepa heꞋya atafa huꞋya tokiya hume hume neꞋvisageꞋna nagaya eteꞋnama esua kanafina nagai kema atafa hu-linaya veaꞋmogamina Anumaya KotiꞋa amaku amamena ali-gatigahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","VeaꞋmoꞋya havi kavaꞋma hu-lama-tesagetama ani kumala neꞋataletama nago kumate viho. Tamage-lafa huꞋna tamaha-nepauve mukiꞋa Isaleli kumatela oꞋunesageno ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna egahue. ");
INSERT INTO kmu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nago sugulufi mainesia nafaꞋnemoꞋa hu-ve-nelia kanoꞋamona oꞋagasenea yanagino aniꞋa huno nago aliꞋya kanomoꞋa kava kanoꞋamona oꞋagasene. ");
INSERT INTO kmu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sugulufi mainesia nafaꞋnemoꞋa hu-ve-nelia kano kana huno maisiana kanaleꞋya hugahie. AniꞋa huno aliꞋya kanomoꞋa kava kanoꞋamoꞋene nago avamete huno maisiana kanale hugahie. Nagaifena mage huꞋya hu-mainae “Pielesepulia Kefo AvamuꞋyagale kava kanoꞋami maine.” huꞋya hu-haviya hu-nenateꞋya aliꞋya veaꞋnimogamina tusiya huꞋya kamuge hatageꞋya vai-lama-tegahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ali haviya hu-lama-tegahayanagi amakaifena kolia ohiho. Aiso hu-mainea yamona Anumaya KotiꞋa mukiꞋa alino fufute atalegahie. Falaki-mainesia yamona Anumaya KotiꞋa mukiꞋa veaꞋmogami amaulagafi ali-falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hanipinaga tamaha-pai-mainoa kea yagefi hama-paiho. Sumi sumi huꞋya tamaha-pai-mainaya kea kuma amuꞋnopiti ala kefiti keha keha hutama hiho. ");
INSERT INTO kmu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amega tamaugafaꞋage he-falisaya veafena kolia ohiho. Ani vayaꞋmoꞋya tamaku tamameꞋenema tamahae falisaya tokiyaꞋamia omalene. He-faliteno hanimo aguꞋafi ata tege-lege nehia yapi tamaku tamameꞋene tamaugafaene he-falisia tokiya hanea kanoa, Anumaya Kotifeke, tusiya hutama kolia hiho. ");
INSERT INTO kmu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tolea osi namalatana nagoke haesa moneleti miya nehayanagi nagoke ani nama kanoꞋa afaꞋa ofalinegi ikapinaga NelamafaꞋa “Falisie.” huno ohinagenoꞋa ofaligahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Tamakaya mukiꞋa namayaga agasetama veaꞋnea ala yaga mainae. Anumaya KotiꞋa mukiꞋa hanea tamayolagefa ago hapalino havilinea yafe kolima hisaya yana neꞋataletama afaꞋa maiho. ");
INSERT INTO kmu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","YisasiꞋa mage huno hie “NagoꞋa kanomoꞋa veaꞋmogami amaulagafi nagaifema ‘Yisasina naguꞋa amitafa hu-mainoe.’ huno hu-falote hisigeꞋnahena nagaya ikapinaga mainea Nenafa aulagafina agaifena ‘Nagai nafaꞋne maine.’ huꞋna hu-falote hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hu-falote hugahuanagi nagoꞋa veaꞋmoꞋya veaꞋmogami amaulagafima nagaifena ‘NaguꞋa amitafa ohunoe.’ hunoꞋma hu-falote hisigeꞋna nagaya ikapinaga mainea Nenafa aulagafina ani kanohena ‘OꞋagenoa kano maine.’ huꞋna hugahue.” ");
INSERT INTO kmu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tamakaya na tamakesa nehaviye? “Ma mopale taipa falu huta maisuna yana tamigahe YisasiꞋa emaine.” hutama nehao? AꞋao nagayama emainoafenagitama tamakaya tuma hisaya yatetila falu hutama omaigahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Omaigahagi nagaya emainoafe nago afamopina nafaꞋneꞋamoꞋa nefana kame hu-tesigeno munaꞋamoꞋa itaꞋamona kamea hu-tesigeno anofeloꞋamoꞋa anauꞋamona itaꞋamoꞋene apasesaꞋa yamoꞋa falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","NagoꞋa veaꞋmoꞋya nagai kea akave nemalayafe amakai afamola kame vayaꞋa maigahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","NagoꞋa veaꞋmoꞋya itaꞋafoꞋamimofema “Afa veaꞋne mainagi YisasiꞋa tamakase-mainea kanogiꞋna nagula aminoe.” huꞋya ohisaya veaꞋmoꞋya nagai nafaꞋne maisaya avametela ohune. NagoꞋa veaꞋmoꞋya nafaꞋneꞋamimofeꞋene munaꞋamimofeꞋene “Afa vea mainagi YisasiꞋa tamakase-mainea kanogiꞋna naguꞋa aminoe.” huꞋya ohisaya veaꞋmoꞋya nagai nafaꞋne maisaya avametela ohunae. ");
INSERT INTO kmu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nagaila nagatama aisigeꞋna falisua yafema nagoꞋa veaꞋmoꞋya “AniꞋa hugahune.” huꞋya amakaiꞋami yafaga yosa kofiꞋya nakave visaya amakesa ohavisaya veaꞋmoꞋya nagai nafaꞋne maisaya avametela ohunae. ");
INSERT INTO kmu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","NagoꞋa veaꞋmoꞋya maiyaꞋamima atafa huꞋya ali-talakoma hu-lisayana maiyaꞋamimoꞋa falino afaya hapaegahigi nagoꞋa veaꞋmoꞋyama nagaifema hamainageꞋya maiyaꞋamima atalesaya veaꞋmoꞋya maiyaꞋamia ali-gatisugeꞋya agola maige maige hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","NagoꞋa veaꞋmoꞋya tamakaiꞋma tamavaleꞋya falu falama hu-lama-tesayana nagaila aniꞋa huꞋya navaleꞋya falu fala hu-nenatae. NagaiꞋma navaleꞋyama falu fala hu-natesayana hu-na-tenea kanomona aniꞋa huꞋya falu fala hu-neꞋatae. ");
INSERT INTO kmu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","NagoꞋa veaꞋmoꞋya nago kanomona ageteꞋya Anumaya Koti ke hu-haleno nehia kanoma mainesigeꞋya falu falama hu-tesayana ani veaꞋmogamina Anumaya KotiꞋa hu-haleno nehisia vayaꞋmogami amamisia avamete amamigahie. NagoꞋa veaꞋmoꞋya nago kanomona ageteꞋya fatago auꞋava yama nehisia kanoma mainesigenoꞋma falu fala hu-tesiana ani veaꞋmogamina Anumaya KotiꞋa fatago kanomo alisia avamete amamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","NagoꞋa veaꞋmoꞋya nagola afa kanoa Yisasi kema nehavisia kanoma mainesigeꞋya yasi lima amisayana tamage huꞋna tamaha-nepauve ani veaꞋmoꞋya anonaꞋamia fanane ohugahianagiꞋya afaꞋa miyaꞋamia aligahae. ");
INSERT INTO kmu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","YisasiꞋa tuelufuꞋa (12) agaiꞋaenema tokaeꞋya nemaiya anagaꞋmogamina huge ama-ve-lige huteno alu kumate kumate Anumaya Koti kea mo hama-paino hu-mave-li-maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","YoniꞋa ti fale neꞋamatea kanoa nofipi maineno KalaisiꞋma hia kavafena haviteno nagoꞋa agaiꞋa anagala Yisasife havigegahe hu-ma-tegeꞋya mage huꞋya me hae “Kagaya egahiema hu-mainaya kano emainapi alu kanohe agava maisune?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hageno YisasiꞋa mage huno hie “Tamakaya utama haviya yaꞋene agaya yaꞋene Yonina mo hapaiho. ");
INSERT INTO kmu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma ya agone hutama hiho amaulaga asu hu-mainea veaꞋmoꞋya amaulaga neꞋagae. Amaiya haviya hu-mainea veaꞋmogami amaiyamoꞋa kanale hu-mate. Fugitaya amake-mainea veala kanale hu-mate. Amakesa tile-mainea veala eteꞋya nehaviye. Fali-mainaya veala hetiꞋya mainae. AfenoꞋami omalenea veala Anumaya Kotina kanale keꞋa nehaviye. ");
INSERT INTO kmu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nagai kehema tole amakesa ohavisaya veaꞋmoꞋya kanaleꞋya huꞋya maigahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","YoniꞋma hu-ma-tegeꞋya aya veaꞋmoꞋya neꞋvageno YisasiꞋa anile mainaya veaꞋmogamina Yonife mage huno hamavige “Tamakaya kaꞋme kotega na ya mogegahe neꞋvae? Nago kanoa yasimoꞋa hopa kana huno ali fagagi mainea kanomona agegahe neꞋvao? ");
INSERT INTO kmu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ifi na ya agegahe umainae? Kanale kena fai-linesia kano agegahe neꞋvao? AꞋao kanale kena fai-linesaya vayala kaꞋme kotega omaigahagi sauve kanomo nopi maigahae. ");
INSERT INTO kmu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na ya agegahe neꞋvae? Anumaya Koti aune kano agegahe neꞋvao? Ifi tamage tamaha-nepauve mukiꞋa amaune vayaꞋmogamina amakase-mainea kanoa Yoni maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yonife huꞋya nayona Anumaya Koti autaꞋmafina mage huꞋya kae-malenayane ‘Haviho nagaya Anumaya KotiꞋna aliꞋya kanoꞋnimona hu-tesugeno uhagotegatenoꞋma visana kana valino ali-hilato huga-tegahie.’ huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tamage huꞋna tamaha-nepauve YoniꞋa ti fale-neꞋamatea kanomoꞋa mukiꞋa ma mopale vayaꞋmogamina ago amakase-maineanagino nagoꞋa afa veaꞋmoꞋya Anumaya Kotife ‘Kava yagailato.’ huꞋya hu-mainesaya veala Yonina ago agase-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","YoniꞋa ti fale-neꞋamatea kanomoꞋa kea hama-pai-mainea kanaleti aepa heꞋya tokiyaꞋami hanea veaꞋmoꞋya Anumaya KotiꞋma kava yagai-lama-tesia yafe tokiyaꞋage huꞋya ‘Ani yapi maigahune.’ huꞋya hu-mainayanagi nagoꞋa vayaꞋmoꞋya tusiya huꞋya ani yafena kame nehae. ");
INSERT INTO kmu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","MukiꞋa kanafina MoseseꞋene Anumaya Koti amaune vayaꞋene kea hu-haleꞋya hu-mainayanagino YoniꞋa evaꞋyi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ani vayaꞋmoꞋya nagoꞋma esia kanomofena, IlaiyaꞋe kanomofena ago tamaha-pai-mainayanagi ‘YoniꞋa ani kano maineꞋ hutama havinutamahena havigahae. ");
INSERT INTO kmu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tamakesama hanesia veaꞋmogatama haviho. ");
INSERT INTO kmu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Meni kanafima mainaya veaꞋmogatamahena hanaꞋa veaꞋne mainae huꞋna tamaha-paisue? Ma ma hisua augafa nafaꞋneyagamoꞋya mainaya avamete hutama mainae. Ani nafaꞋneyagamoꞋya veaꞋne alitalu huꞋya mainalega maineꞋya alu nafaꞋneyagahena ke huꞋya mage huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘YaveꞋya aikolunana tamakaya amoa noꞋayae. Tagaya tahau hisuna yagame nehunana tamakaya avia noꞋatae.’ huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","YoniꞋa ti fale-ma-te kanomoꞋa kaveꞋene haviliꞋene mosino emainegeꞋya amakaya ‘Satani Avamula aguꞋafina maine.’ huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hayanagi ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna tina kavela me nenogetama nagaifena ‘KaveꞋene tiꞋene neno haꞋno hugeno omai kano maineno musufaya huꞋya amaugafaleti takisi neꞋaliya vayaꞋene kefo yama nehaya vayaꞋene vayaꞋamoꞋya mainae.’ huꞋya hu-mainae. Hayanagi Anumaya Kotina kanale agu agesama hanea yapiti kanale yana falote hu-maineafe vayaꞋmoꞋya ‘Fatago kava nehie.’ huꞋya hu-mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","YisasiꞋa mani kea huteno aepa heno agayama tokiya avame yama higeꞋya age-mainaya kumaꞋyagaletiꞋene ani kumate veaꞋmoꞋya kefo yaꞋamia neꞋataleꞋya amakuꞋa ai-yahae huꞋya akave nohaya yafe YisasiꞋa tokiyaꞋage ke huno mage hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“AvoꞋneo Kolasini mainaya veaꞋmogatamaene Petesaita mainaya veaꞋmogatamaene tusiya huꞋna tamakaifena nahau nehue. Tamakai kumapina nagaya tokiyaꞋage avameꞋyana ago huanagi tamaipa ai-yahae ohayanagiꞋna ani tokiyaꞋage avame yama Taiyaene Saitoniene huleꞋasina ani kumate veaꞋmoꞋya kefo yaꞋamihena ago amaipa ai-yahae huꞋya kefo yama hu-mainaya yafena kayavo kena fai-liꞋya taꞋnefafi maileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nagaya tamaha-nepauve Anumaya KotiꞋa kaiyekema hu-ma-tesia kanafina Taiya mainaya veaꞋnene Saitoni mainaya veaꞋnene amaugafa amagata yana aligahayanagi tamakaya tusiya hutama nagoꞋene tamaugafa tamagata yana aligahae. ");
INSERT INTO kmu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tamakaya Kapaneamu mainaya veaꞋmogatama ‘Taugafa alita anale haigahune.’ hutama nehao? AꞋao afete tavitama tamakaye nehinagetama maigahae. Tamakai kumapi hu-mainoa tokiyaꞋage avame yana Sotomu kumateꞋma huleꞋasina ani kumate veaꞋmoꞋya amakuꞋa ai-yahae hu-mainaleꞋasina atafina fanane ohaleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tamaha-nepauve Anumaya KotiꞋma kaiyeke hu-ma-tesia yupa Sotomu mainaya veala amaugafa amakata aigahianagi tamakaya amakasetama tusiya huno tamaugafa tamakata aigahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ani yupa YisasiꞋa nunamuna mage huno hie “Nenafagae mukiꞋa ma mopafi yaꞋene ikapinaga yaꞋene kava yagai-mainana Anumayamoga kanale kava nehane. NagoꞋa veaꞋmoꞋya ‘Havi haviꞋyati hanea vea mainone.’ huꞋya nehaya veaꞋmogamifena ohavisae huka fala-ki-malenane. ‘Ala avo nopi umainona vea mainone.’ huꞋya hisaya veaꞋmogamifena ohavisae huka fala-ki-malenanagi ‘Inamu nafaꞋne kana huta mainone.’ huꞋya nehaya veala ago amaveli-mainana yafena aluya huꞋna musekaꞋa nehue. ");
INSERT INTO kmu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Nenafagae kagai kagu kagesamo hia kava huka ani kavala hu-mainane.” huno nunamuna hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","VeaꞋmogamifena mage huno hu-maine “NenafaꞋa mukiꞋa lokiya ago namine. MukiꞋa veaꞋmoꞋya nagaila neꞋamonina aepaꞋnia ohavinagi NenafaꞋa agaiꞋage nagai aepaꞋa haviline. Havilinegi mukiꞋa veaꞋmoꞋya Nenafa aepaꞋa ohavinae. AniꞋa huꞋna nagaiꞋnige neꞋamoꞋna Nenafa aepaꞋa havilineꞋna nahaisia veaꞋmogamina hu-mave-lisugeꞋya Nenafana aepaꞋa havigahae. ");
INSERT INTO kmu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tamakaya tusi aliꞋya neꞋalitama kana yama ali-mainaya veaꞋmogatama nagaitega egeꞋna mai-falu hisaya yana tamamino. ");
INSERT INTO kmu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nagai aliꞋya aligeta tokaeta vaiyamano. Nagaya kayone kano maineꞋna naugafa aliꞋna ohai kano mainoafe aepaꞋnia havisageꞋna tamakuꞋamoꞋma mai-falu hisia yana tamamigahue. ");
INSERT INTO kmu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tamakaya nagaiꞋene ai-lokaetama vaiyesayana kana ohugahianagitama yoꞋyo hutama vaiyegahae.” ");
INSERT INTO kmu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nago Sapati yupa YisasiꞋene agaiꞋaene tokaeꞋya nemaiya anagaꞋaene nago atili hoya amuꞋnopi neꞋvageno anagaꞋamogamina amakategeꞋya ani atilia kaleteꞋya takiꞋya ne-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","NenageꞋya nagoꞋa Falasia vayaꞋmoꞋya amaketeꞋya Yisasifena mage huꞋya hae “Ago kagaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya Sapati yupama katile-malenaya yana ali haviya nehae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hageno YisasiꞋa mage huno hie “Tamakaya Tevitina agava huꞋya umainaya vayaꞋene amaka-te-mainea yamo kea hapalitama ohavinao? ");
INSERT INTO kmu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Amakategeno TevitiꞋa Anumaya Koti nopi hai-faleno ‘Afa vayaꞋmoꞋya onesageꞋya mono nopi kava vayaꞋmoꞋya amakaiꞋamige negahae.’ huꞋya katile-malenaya maya TevitiꞋa agaiꞋaene tokaeꞋya emainaya vayaꞋenena ne-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tamakaya kahegi kema kae-malenaya avopima hanea kea hapalitama ohavinao? Mage huno hu-maine mono note kava vayaꞋmoꞋya mukiꞋa Sapati yupa aliꞋyaꞋamia neꞋaliꞋya Sapatimo kahegi kemona atagayayanagi Anumaya KotiꞋa ‘Kefo ya haya vaya mainae.’ huno ohune. ");
INSERT INTO kmu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tamaha-pauve Anumaya Koti ala mono nomona agase-mainea kanoa nagaiꞋniꞋa ma mainoe. ");
INSERT INTO kmu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nayona Anumaya Koti autaꞋmafina mage huꞋya kae-malenayane. ‘Nagaya Anumaya KotiꞋna sipi sipia hetama kolama takiꞋya nenamiya kavafena nonahaigeꞋna kalagi ai-ma-tesaya yafeke nenahaiye.’ huꞋya kae-malenayane. Kae-malenagi tamakaya ani kema havilamama hu-mainaleꞋasina kefo yama ohunaya vayafena ‘Kefo ya nehae.’ hutama ohaleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna Sapati yupa kava yagai-mainoe.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ani kumala neꞋataleno mono nopi haino maine. ");
INSERT INTO kmu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Maineno ageana nago kanoa aya avayu hu-lavi-mainea kanoa anile maine. MainegeꞋya nagoꞋa vayaꞋmoꞋya YisasiꞋa havi kavaꞋma hisiafene huꞋya ati neꞋayeꞋya Yisasife mage huꞋya hae “Sapati yupa kali kanoa alino kanale hu-tesia yana kanale yano?” huꞋya Yisasina havinegeꞋya amata hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","YisasiꞋa mage huno hie “Nagola hana kanomoga afukama Sapati yupama komufi tavi-mainesigeka ago hevayu huka faitega ategano? E aniꞋa hugane. ");
INSERT INTO kmu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","VeaꞋmoꞋya afua agaseꞋya ala yaga mainaya yafenagiꞋya kahegi kemoꞋa ‘Sapati yupa kanale ya hu-ma-teho.’ huno hu-maine.” ");
INSERT INTO kmu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Huteno ani ayama avayu hulavi-mainea kanomofe mage huno hapaiye “Kayana aipi huo.” huno higeno aipi hiana nago kaiyaga ayaꞋmoꞋma hia kava huno kanale hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kanale hianagi Falasia vayaꞋmoꞋya mono nopitila ataleteꞋya hati-laviꞋya melitalu huꞋya huge havige huteꞋya “Yisasina hanaꞋa huta haesunageno falisie?” huꞋya vege hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yisasina haegahema huge havige haya kea ago haviteno ani kumala neꞋataleno vigeꞋya kasagoꞋya veaꞋmoꞋya akave vageno mukiꞋa kali veaꞋmogamina kaliꞋamia alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hu-ma-teteno mage huno hie “Nagai aepaꞋa veala hamaꞋopaiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mani kema hia kemofena nayona AisaiyaꞋa Anumaya Kotina aune kanomo hu-mainea kemoꞋa falote huno tamage hie. Mage huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Anumaya KotiꞋa mage huno hie ageho mani kanoa nagai aliꞋya kano maisia yafe ago hapali-tenoe. Ani kanohena aluya huꞋna musena nehuꞋna nahau-mainea kanoe. Nagaya AvamuꞋnia amisugeno nagayama fatago huꞋna yagai-matesua kehena mukiꞋa Yuta vea omainaya veala hama-paigahie. ");
INSERT INTO kmu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Agaya kea oꞋvaino ala kenake ohugahigi katega veaꞋmoꞋya nagola agea ohavigahae. ");
INSERT INTO kmu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","NagoꞋma fagagi mainesia hopama alino kofa ohuno aniꞋa huno fulu fuluma hu-mainaya veaꞋmoꞋmogamina kaꞋyona oꞋamamigahie. Asu hugahema hisia kaꞋnila asu ohuno aniꞋa huno fulu fuluma hu-mainaya veaꞋmoꞋmogamina kaꞋyona oꞋamamigahianagino agaiꞋa fatago kavala huge huge hisiana ani fatago kavaꞋamoꞋa havi kavaꞋmona agaseno haigahie. ");
INSERT INTO kmu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Haisiana muki mopale Yuta vea omainaya veaꞋmoꞋya agai agihe haviꞋya amakupi maleꞋya amametiti hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nago kanomona Kefo AvamuꞋmoꞋa* aguꞋafi maineno aulaga alino asu huno avefuꞋna alino ai-yahae higeno agea noꞋaiyanagiꞋya Yisasite avaleꞋya ageno YisasiꞋa ani Kefo Avamula anati-talegeno vigeno ani kanomoꞋa aulaga age-gali huno ageteno agea aino kea kea hie. ");
INSERT INTO kmu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ani kava higeꞋya alitalu hu-mainaya veaꞋmoꞋya ageteꞋya tusi amamaꞋyo ai-mainae. AmamaꞋyo aigeꞋya mage hae “Mani kanomoꞋa Tevitina aginagomo maineo? Anumaya KotiꞋa taugafa ali-gatigahema hutea kano maineo?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","HageꞋya Falasia vayaꞋmoꞋya haviteꞋya mage hae “PielesepuliꞋa Kefo AvamuꞋyagale kava hu-mainea kanomoꞋa tokiyaꞋa amigeno Kefo AvamuꞋmona anati-neꞋatale.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hageno YisasiꞋa amakupi haviya amaku amakesa ago haviteno mage hie “MukiꞋa nagoke kotega veaꞋmoꞋya aye-fako huꞋya tuma hisayana ani kotega veaꞋnene haviya hu-lavigahae. Nago kumate afamopina aye-fako huꞋya ‘Alu vaya mainone.’ huꞋya tuma hisayana ani kumaꞋene afamoꞋene haviya hu-lavigahae. ");
INSERT INTO kmu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","SataniꞋa agaiꞋa aliꞋya AvamuꞋyagamona anati-talesiana agaiꞋa nofi vayaꞋma aye-fako huꞋya ‘Alu vaya mainone.’ huꞋya hisayana SataniꞋa kava yagaisia tokiyaꞋa hanaꞋa huno hanegahie? ");
INSERT INTO kmu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nagaifena ‘Kagaya Pielesepulimo tokiyaleti anati-neꞋatalane.’ hutama hayanagi tamakaitami anagatamimoꞋa Kefo Avamula anati-talageno Pielesepulimo amakaila amaya nehio? Ani anagatamia amakaiꞋami manima haya kea ali fako huꞋya tamave-neliye. ");
INSERT INTO kmu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tamage nagaya Anumaya Koti AvamuꞋmo tokiyaleti ani Kefo AvamuꞋyaga anati-neꞋataloafe Anumaya KotiꞋa kava yagaisia kanamoꞋa tamakaitela ago emaine. ");
INSERT INTO kmu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nagola tokiyaꞋage kanomoꞋma nomaꞋafima nago kanomoꞋa musufa ya hugahe vinunoꞋa hagoteno ani tokiya kanomona nofiteti ki-teteno afenoꞋyamaꞋa musufa yana hugahie. Nagaya aniꞋa hu-mainoafe Satanina agaseꞋna nofiteti ki-teteꞋna agai Avamula ago anati-talenoe. ");
INSERT INTO kmu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","NagoꞋa veaꞋmoꞋya nagai kanapa veaꞋne omaisayana kame vayaꞋniꞋa mainae. Sipi sipiꞋnima naya huꞋya ali-taluma ohisaya veaꞋmoꞋya amanati-neꞋatalae.” ");
INSERT INTO kmu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","NaꞋa hu-maineafe nagaya tamaha-nepauve mukiꞋa alu kefo ya alu kefo yaꞋene hu-haviya hu-neꞋataya yaꞋene Anumaya KotiꞋa aigeꞋama-teno ani kefo yaꞋamia atale-ma-tegahianagi nagoꞋa veaꞋnemoꞋya Alu aotage AvamuꞋmofema hu-haviya hu-tesayana Anumaya KotiꞋa aigeꞋma-teno ani kefo yaꞋamia atale-oꞋama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","NagoꞋa veaꞋmoꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonihema hu-haviya hu-natesayana Anumaya KotiꞋa aigeꞋama-teno ani kefo yaꞋamia atale-ma-tegahianagi nagoꞋa veaꞋmoꞋya Alu Aotage AvamuꞋmofema hu-haviya hu-tesayana Anumaya KotiꞋa aigeꞋamateno ani kefo yaꞋamia meni kanafiꞋene haenagama falote hisia kanafiꞋene agola atale-oꞋama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kanale yosama hanesigenoꞋa alagaꞋamoꞋenena kanaleꞋya hugahie. Havi yosama hanesigenoꞋa alagaꞋamoꞋenena haviya hugahie. VeaꞋmoꞋya yosalaga ageteꞋya kanale yosalaga hanesigeꞋyahena ‘Kanale yosa hane.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tamakaya osifaꞋvemo nafaꞋneyagamogatama havi vayalagitama hanaꞋa hutama kanale kea hugahae? VeaꞋmoꞋya amaku amakesafinaga havateteno ai-vali-lavi-mainea kea amavayafiti hu-falote nehae. ");
INSERT INTO kmu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Fatago huꞋya mainaya veaꞋmoꞋya kanale amaku amakesa havilineꞋya kanale kavala nehayanagi kefo yama nehaya veaꞋmoꞋya havi amaku amakesa havi-lineꞋya havi kavakeꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nagaya tamaha-nepauve Anumaya KotiꞋa veala kaiyekema hu-ma-teno ali fako hisia yupa mukiꞋa veaꞋmoꞋya amakesa ohavi ke huꞋya hu-haviya hu-ma-tenesaya kehena Anumaya KotiꞋa hama-vi-gegahie. ");
INSERT INTO kmu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hu-mainesana keleti Anumaya KotiꞋa kagaifena ‘Havi kavala ohunane.’ huno hu-ga-tegahianagi hu-mainesana keleti ‘Kefo ya hu-mainane.’ huno hu-ga-tegahie.” ");
INSERT INTO kmu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","NagoꞋa kahegi kema havilinaya anagaꞋene Falasia vayaꞋene Yisasife mage huꞋya hae “Huma-ve-nelina kanomogae tokiya avame yana tavelio.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hageno YisasiꞋa mage huno hama-paiye “Ma kanafima mainaya veaꞋmoꞋya tusiya huꞋya havi veaꞋne mainae. Anumaya Kotina amakaveꞋno hu-tenaya veaꞋne mainae. ‘TokiyaꞋage avame yana tavelio.’ hutama nehayanagi alu avame yana Anumaya KotiꞋa otamamigahigi nagoke avame yake tama-ve-ligahie. Nayoma mainea Anumaya Koti aune kanoa YonaꞋma hu-mainea avame yamaꞋage tama-ve-ligahue. ");
INSERT INTO kmu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonana ala noyamemoꞋa asaga huno nakaigeno tagufa (3) kegeꞋene felugaene aipafinaga mainea kava huꞋna ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna he-vai-natesageꞋna tagufa (3) kegeꞋene felugaene mopafinaga maigahue. ");
INSERT INTO kmu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive kumate mainaya veaꞋmogamina YonaꞋa Anumaya Koti kea hama-paigeꞋya kefo yaꞋamihena amaipa aiyahae hu-mainagi haviho menia Yonana agase-mainea kanoa ma mainegetama tamakaya kefo yatamihena tamaipa ai-yahae nohae. Tamaipa ai-yahae nohayafe Anumaya KotiꞋa kaiyekema hu-lama-tesia kanamoꞋa nayoma Ninive kumate mainaya veaꞋmoꞋya hetiꞋya menia ma kanafima mainaya veaꞋmoꞋya kefo yama hu-mainaya yafena hu-falote hu-lama-tegahae. ");
INSERT INTO kmu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nagola alu haupalegati emainea sauve aꞋmoꞋa mopamona atupaleti eno Solomonina kanale agu agesaene kanomo kea me havigahe emaine. Emaineanagi haviho Solomonina agase-mainea kanoa ma mainegetama tamakaya agai kea nohaviye. Nohaviyafe Anumaya KotiꞋa kaiyekema hu-lama-tesia yupa ani aꞋmoꞋa hetino menia ma kanafima mainetama kefo yama nehutama agai kema nohaviya yafena hu-falote hu-lama-tegahie.” ");
INSERT INTO kmu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nagola Kefo AvamuꞋmoꞋa vaya aguꞋafi haino maineleti ataleno viaꞋyamo hau hu-mainea kopinaga mo vaiyatete huno mai-faluma hisia kumafena ati yegeteana mai-falu hisia kumala oꞋagene. ");
INSERT INTO kmu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","OꞋageno “HagoteꞋna maigeꞋna emainoa agu nopi eteꞋna umaigahue.” huno huteno mogeana ani agu nopina vayala omaigeno ago sese huno kanale ya hu-malenegeno moge-maine. ");
INSERT INTO kmu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mogeteno eteno viaꞋyamo seveniꞋa (7) kefo yaꞋamimoꞋma agase-mainaya Kefo AvamuꞋyaga momavaleno egeꞋya ani agu nopi hai-faleꞋya mainageno hagoteno ani kanomoꞋa nagoke Kefo AvamuꞋmo agu nopina mainegeno haviya huno maineanagino menia kasagoꞋya Kefo AvamuꞋmo agu nopina haiꞋya maigeno tusiꞋa kefo yatafa huno maine. Ani kavala menima mainetama kefo yama nehaya veaꞋmogatama hu-lama-tegahie huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","YisasiꞋa mani kea veaꞋmogamina hama-nepaigeꞋya itaꞋamoꞋene aganaꞋamoꞋyaene “Kea me hapaisune.” huꞋya kumatega emainae. ");
INSERT INTO kmu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Emainageno nago kanomoꞋa Yisasife mage huno me hapaiye “ItakamoꞋene kaganakamoꞋyaene kea kaha-paigahe kumate me hetiꞋya mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Higeno YisasiꞋa mage huno hie “ItaꞋnimoꞋene naganaꞋnimoꞋyaenena taꞋya mainae?” huno havi-ge. ");
INSERT INTO kmu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Havigeteno agaiꞋaenema tokaeꞋya nemaiya anagatega ayana hagaꞋyu huno mage huno hie “Ageho itaꞋnimoꞋya naganaꞋnimoꞋya ma mainae. ");
INSERT INTO kmu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ikapinagama mainea Nenafana haiya kava huꞋya avayama ali hipoꞋya nehaya veaꞋmoꞋya nagaila itaꞋnimoꞋya naganaꞋnimoꞋya nasaꞋnimoꞋya mainae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ani yupa YisasiꞋa nopinagati hati-lavino tikotumo agegayalega mopale umaine. ");
INSERT INTO kmu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mopale mainegeꞋya kasagoꞋya veaꞋmoꞋya agaitega melitalu huꞋya yageꞋyage haya yafe tipi kalefi hai-saga huno mainegeꞋya yageꞋyage haya veala ti agegayalega hetiꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Heti-mainageno YisasiꞋa alu ke alu kea avame kefiti mage huno hama-pai-maine “Nago kanomoꞋa viti avina faigahe alino vie. ");
INSERT INTO kmu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ViaꞋyamo ani avina alino ai-he-lafino nefaigeno nagoꞋa avinamoꞋa kapi tavino hanegeno namayagamoꞋya nageno haꞋno hie. ");
INSERT INTO kmu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","NagoꞋa avinamoꞋa yafa mopafi taviteno osi mopa hanea yafe aupaꞋa hage-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hagetegeno yagemoꞋa hetino amuko-nako higeno hafuꞋya omalea yafe fayoteno asagali-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","NagoꞋa avinayagamoꞋa avetaꞋnafa ino hanea amuꞋnopi tavino hageanagi avetaꞋnafa hanea inoꞋene tokaeno hageteno avetaꞋnafa inomoꞋa ayetegeno haviya hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","NagoꞋa avinamoꞋa kanale mopafi tavino hageteno alagaꞋama ayeana nagoꞋa yosalela tetiꞋa (30) alaga ayegeno nagoꞋa yosalela sikisitiꞋa (60) alaga ayegeno nagoꞋa yosalela kasagoꞋya alaga vani hataletiꞋa (100) ayeno vasai-mai vasai-mai hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mani kea tamakesama hanesigetamahena havilama hutama haviho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","AgaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage huꞋya havigae “NaꞋa higeka avame kefitila veaꞋmogamina hama-nepaine?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hageno YisasiꞋa mage hie “Tamakaya Anumaya KotiꞋa kava yagai-lama-teneanagitama falaki mainea kemona Anumaya KotiꞋa tamaya higetama ago havi-linagi mukiꞋa veaꞋmoꞋya avame kema hama-paisugeꞋya amakesa havigahayanagi haviteꞋya havilama huꞋya ohavigahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Havilama huꞋya havilinaya veaꞋmogamina Anumaya KotiꞋa nagoꞋene havisaya yana amamisigeꞋya havilama huꞋya havigahagi ‘Hai nehavune.’ huno hisaya veaꞋmogamina havilinayamaꞋa hamanafalegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ani veaꞋmoꞋya neꞋagayanagi agelama huꞋya oꞋagegahae. Amakesa havigahayanagi haviteꞋya havilama huꞋya ohavisayafe avame kefiti hama-nepauve. ");
INSERT INTO kmu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ani kavaꞋma nehaya yafena AisaiyaꞋa Anumaya Koti aune kanomoꞋa hu-mainea kemoꞋa ago falote huno tamage hie. Mage huno hu-maineane “Tamakaila tamakesamoꞋa havime havime haigahianagi ani kemona aepaꞋa havilama hutama ohavigahae. TamaulagamoꞋa ageme geme haigahianagi nago yana agelama hutama ohugahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kemona aepaꞋa ohavisaya yafe amaku amakesa omale veaꞋne mainae. AmakesamoꞋa ani ke ohavisiafene huno amakesamoꞋa tile-maine. AmaulagamoꞋa ani yana oꞋagesayafene huno ago asu hu-maine. Havigu ani kea haviꞋya amakuꞋa ai-yahae huꞋya nagaitega esageꞋna ali hilato hu-lama-teyafene.” huno higeꞋya kae-malenayane. ");
INSERT INTO kmu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Anumaya KotiꞋa tamakaila tamaulaga kanaleꞋya hutama neꞋagaya yaꞋene tamakesama nehaviya yaꞋene tamaminea yafena tusiꞋa muse hutama maiho. ");
INSERT INTO kmu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tamage huꞋna tamaha-nepauve “Nayona mukiꞋa mainaya amaune vayaꞋene fatago kavaꞋma hu-mainaya vayaꞋene tamakayama neꞋagaya yana ‘Agesune.’ huꞋya hayanagi oꞋagenae. Nehaviya kea ‘Havisune.’ huꞋya hayanagi ohavinayane.” huno hama-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Avina yama fai-malenea kanomo avame kemona aepaꞋa hu-falote huꞋna tamaha-paisue. ");
INSERT INTO kmu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kapima tavi-mainea avinamoꞋa maꞋa hu-maine nagoꞋa veaꞋmoꞋya Anumaya Koti kava yagai-latesia kea haviteꞋya havilama ohageno SataniꞋa eno amakuꞋafiti anima fai-malenea kea ali-talene. ");
INSERT INTO kmu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Yafa mopafima tavi-mainea avinamoꞋa maꞋa hu-maine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviꞋya muse huteꞋya aupaꞋa atafa hayanagi hafuꞋya mopafi otavia yamoꞋa alige atalege veaꞋne maineꞋya osi kana kanoꞋa osiꞋa haviꞋya amakupi maletageꞋya nagoꞋa veaꞋmoꞋya ani kea heꞋya fala-negiya yafe havi kanamoꞋma amakaite falote nehiana aupaꞋa Anumaya Koti kea neꞋatalae. ");
INSERT INTO kmu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","AvetaꞋnafa ino hanea amuꞋnopima tavi-mainea avinamoꞋa maꞋa hu-maine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviteꞋya ma mopafi mukiꞋa yaꞋyagaꞋamihena amakesa haviꞋya moneꞋamiene yokaloꞋamienefe kalagi aigeno ani yaꞋyagamoꞋa Anumaya Koti kea alino aiso hu-malegeꞋya atalageno alagamoꞋa aye he-lafino lama nohie. ");
INSERT INTO kmu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kanale mopafima tavi-mainea avinamoꞋa maꞋa hu-maine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviteꞋya havilama hageno anifiti alaga mukiꞋa aye he-nelafie. NagoꞋa veaꞋmoꞋya nagoke avina yosalela kasagoꞋya vani hataletiꞋa (100) aye-maine. NagoꞋa veaꞋmoꞋya nagoke avina yosalela sikisitiꞋa (60) alaga aye-maine. NagoꞋa veaꞋmoꞋya nagoke avina yosalela tetiꞋa (30) alaga aye-maine.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","YisasiꞋa nago avame kea mage huno hama-paiye. Anumaya KotiꞋa kava yagai-lama-tesia yamoꞋa maꞋa hu-maine nago kanomoꞋa kanale avina yana hoyaꞋafina fai-malene. ");
INSERT INTO kmu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Fai-malenegeꞋya veaꞋmoꞋya faeꞋya mainageno kame kanomoꞋa havi inoꞋmo alaga alino ani hoyafi ai-he-lafino umaine. ");
INSERT INTO kmu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Utegeno haenaga ani viti alagamoꞋa neꞋayegeno havi ino talamoꞋa anifiti hageno nagopi hai-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","HaigeꞋya aliꞋya vayaꞋmoꞋya hoyamona nefate mage huꞋya mo hae “Ala kanomogae kanale avinama hoyakaꞋafima fai-malananagi naꞋa higeno havi ino talamoꞋa anifitila falote nehie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Havigageno hoyamona nefaꞋa mage huno hie “Nagola kame kanomo mani kavala me hu-malene.” huno higeꞋya aliꞋya vayaꞋmoꞋya mage huꞋya havigae “Tagaya kanale uta havi inona vakai-talesuno?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Havigageno ani hoyamona nefaꞋa mage hie “AꞋao, mo vakai-talesayana havigu kanale avinaene vakai-taleyafenagi ataleho. ");
INSERT INTO kmu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","AtalegeꞋana nagopi tokaeꞋana haneꞋo. KaveꞋma afule yupa hoya aliꞋya vayaꞋnia mage huꞋna hama-paigahue ‘Hagotetama ino talana hakaitama atafi kaesayafe haꞋya kitetama nemaletama anile kanale avinamo yosaꞋa alitalu hutama kave noniꞋafi maleho.’ huꞋna hugahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","YisasiꞋa nagola avame kea hama-paino mage huno hie “Anumaya Koti kava yagai-lamatesia yamoꞋa maꞋa hu-maine nago kanomoꞋa masatati avina alino hoyafi fai-malene. Ani yosamo avina kanoꞋa oꞋagemo avina kanoꞋa haneanagino mukiꞋa alu alagayagamoꞋya ani alaga kanoꞋa agasageno osi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nago kanomoꞋa ani avina kanoꞋa alino hoyafi fai-malegeno hageno ala huteno mukiꞋa hoyafima hanea yosayaga agaseno yosa haigeꞋya namayagamoꞋya me kale-maineꞋya ani yosamo akopale noꞋamia kigahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","YisasiꞋa nago avame kea mage huno hama-paiye “Anumaya KotiꞋa kava yagai-lama-tesia yamoꞋa kai-hamema hale-negia avamete hu-maine. Nago aꞋmoꞋa ani kai-hamema halegisia yana alino taliꞋa (3) ala yopafi taꞋnefa falauvaꞋene ali havigu higeno haenagaꞋa mukiꞋa taꞋnefa palauvamoꞋa halegi-maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","YisasiꞋa melitalu haya veaꞋmogamina mukiꞋa kema hama-paiya kea avame kegeꞋya hama-nepaino nagola kea hu-falote huno hamaꞋopaine. ");
INSERT INTO kmu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ani kavaꞋma hia yafena nagola Anumaya Koti aune kanomoꞋa hu-mainea kemoꞋa ago falote huno tamage hie. Ani kea mage huno hu-maineane “Nagaya avame kea hu-falote nehuꞋna nayoma ma mopama taloma hu-malenea kanaletiꞋma fala-ki-mainea kea menia hama-paigahue.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","YisasiꞋa anima melitalu hu-mainaya veala amataleno nopinaga vigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage huꞋya me hae “Havi inomoꞋma hoyafima falote nehia avame kemona aepaꞋa hu-halegeta havimano.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hageno YisasiꞋa kenonaꞋamia mage huno hie “Kanale avinama fai-malenea kanoa ikapinagati emainoa kanoa vayaꞋmo natenea kanoa nagaya mainoe. ");
INSERT INTO kmu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","MukiꞋa ma mopa ani hoyae. Anumaya Kotife ‘Kava yagai-lato.’ huꞋya nehaya veala ani kanale avina mainae. Satani kema akave nemalaya veala havi ino mainae. ");
INSERT INTO kmu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kame kanoa havi inoma fai-malenea kanoa SataniꞋe. KaveꞋma afulesia yupa ma mopama haꞋno hisia kanae. Mani hoyafi aliꞋya vayala Anumaya Kotina ensole vayaꞋae. ");
INSERT INTO kmu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ani havi inoma alitalu huꞋya mukiꞋa atafi kae-talesaya yana ma mopama haꞋno hisia yupa aniꞋa hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ikapinagati emainoa kanoa vayaꞋmo natena kanomonia ensole vayaꞋnia hu-ma-tesugeꞋya mukiꞋa veaꞋmoꞋya neꞋamafugamina ‘Kefo kava hiho.’ huꞋya ali haviyama hu-mainesaya veaꞋnene Anumaya Koti kema ali-tagae-mainesaya veaꞋnene Anumaya KotiꞋa kava yagai-mainea yapitila amavaleꞋya hagaꞋyu hu-talegahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ala atagefafi hagaꞋyu hu-ma-talegahae. Ani atamoꞋa teno neꞋamasagalisigeꞋya amakata yana neꞋaliꞋya avovo huꞋya avi neꞋateꞋya amave kemoꞋa hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Havi veaꞋnea atafina kaegahayanagi fatago amaku amakesaene veala NeꞋamafaꞋa kava yagai-mainea kumatela hai-faleꞋya maineꞋya yagemoꞋma aye halea kava hugahae. Agesama hanesia kanomoꞋa havilama huno havisie.” ");
INSERT INTO kmu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anumaya KotiꞋa kava yagai-mainea yamoꞋa maꞋa hu-maine nagola mone keꞋayola hoyafi he-vai-malenaya avamete hu-maine. He-vai-malenegeno nago kanomoꞋa mopafiti moli-falote huteno eteno anifi he-vai-maleteno tusi muse huno aupaꞋa “Ma mopa miya hisugeno nagai ya hapaesie.” huno mukiꞋa afenoꞋyamaꞋa moli meli huno monea aliteno ani mopa miya hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Anumaya KotiꞋa kava yagai-mainea yamoꞋa maꞋa hu-maine. Nago kanomoꞋa kitana kana yafena atiyege yegeteno nagola miyamoꞋa hai-mainea kitana kana yana alino falote hu-maine. Higeno “Ala mone namio.” huno higeno mukiꞋa afenomaꞋa moli meli huno mukiꞋa yamaꞋa ataleteno monea alino ani kitana kana yana miya hu-malene. ");
INSERT INTO kmu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nago kene hugahue. Anumaya KotiꞋa kava yagai-mainea yamoꞋa maꞋa hu-maine nagola noyame kukonagoma ti kotupima hagaꞋyu hu-talegenoꞋa alu noyamea alu noyamea hagagino fale-mainea avamete hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ani kukonagopina hiya higeꞋya ti agegayalega he-vayu huꞋya maleneꞋya kanale noyameyaga yopafi yogiꞋya nemaleꞋya havi noyameꞋa aliꞋya hagaꞋyu hu-neꞋatalae. ");
INSERT INTO kmu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma mopama haꞋno hisia yupa ani kava hugahae. Ensole vayaꞋmoꞋya kefo yama hu-mainesaya veaꞋnene fatago kavaꞋma hu-mainesaya veaꞋnene amuꞋnopiti ali fako hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","HuteꞋya ani kefo veala amavaleꞋya tusiꞋa ata nelesia atafi hagaꞋyu hu-talesageno atamoꞋa teno neꞋamasagalisigeꞋya amakata aisigeꞋya avovo huꞋya amave kemo nehuꞋya avitegahae. ");
INSERT INTO kmu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","YisasiꞋa mage huno hama-vige “Tamakaya mani kemona aepaꞋa havilinafi ohavinae?” huno higeꞋya “E, havilinone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hageno mage huno hama-paiye “Tamakaya mono kea havilinaya vayaꞋmogatama menia nagai kea nehaviya veaꞋne mainagi aniꞋa hutama nayoma Anumaya Koti kea hu-mainaya kene menima tamaha-nepauva kea Anumaya KotiꞋa kava yagai-lama-tesia kenena havitetama ala afeno nomona nefaꞋa atafa kanale yaꞋene haegafa kanale yaꞋene nopiti alino neꞋamamia avamete hutama atafa kene yaufa kene hu-haletama hiho.” ");
INSERT INTO kmu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","YisasiꞋa ani avame kea hu-haꞋno huteno ani kumala ataleno umaine. ");
INSERT INTO kmu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Uteno ko aepaꞋalega Nasaleti uvaꞋyi huno mono nopi haino Anumaya Koti kea hama-paigeꞋya mukiꞋa veaꞋmoꞋya atali talu huteꞋya mage hae “Mani kea haviꞋyaꞋami hanea vayaꞋmogami avamete kea mukiꞋa hanateti alia ke nehie? AyapitiꞋma tokiyaꞋa avame yama hu-mainea tokiyaꞋa hanateti ali-maine? ");
INSERT INTO kmu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mani kanoa noma negia kanomo nafaꞋneo? Malia nafaꞋneo? YemesiꞋene YosefeꞋene SaimoniꞋene YutasiꞋenena aganaꞋamoꞋya mainao? ");
INSERT INTO kmu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","MukiꞋa asaꞋamoꞋya tagaiꞋene nagopi mainagi agaya mukiꞋa tokiya yana hanateti ali-maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","HuteꞋya amaipa kafa heteꞋya amakaveꞋno hu-tageno YisasiꞋa mage huno hie “Anumaya Koti kema nehisia kanomoꞋa mukiꞋa kumateꞋma mono kema hama-paisiana agia alisaga hugahayanagi agaiꞋa afamoꞋene no kumaꞋale veaꞋnenena agia alisaga ohugahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Higeno agaife haviꞋya amakupi maleꞋya amametitima ohaya yafe ani kumatela kasagoꞋya tokiya avame yana ohune. ");
INSERT INTO kmu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ani kanafina HelotiꞋa sauve kanogino YisasiꞋa mukiꞋama hu-mainea kavaꞋmona avageꞋa havimaine. ");
INSERT INTO kmu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Haviteno HelotiꞋa agaiꞋa aliꞋya vayaꞋahe mage huno hie “Ma kanoa YoniꞋe, tima fale-neꞋama-tea kanoa, fali-mainefitila ago heti-maineafe ayapitila tokiyaꞋage avame yana nehie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Helotina aganaꞋamo agia FilipiꞋe. Filipi aꞋmo agia HelotiasiꞋe. HelotiꞋa Helotiasina kumai a ali-tenea yafe YoniꞋa Helotife mage huno hie “Anumaya Koti kea ali-tagaeka ali-tenane.” huno hu-mainea yateti HelotiꞋa Yonina atafa huno tokiya nofiteti nofi kiteteno kina nopi hu-tene. ");
INSERT INTO kmu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nofi huteteno HelotiꞋa Yonifena “Haesugeno falisie.” huno hianagi mukiꞋa veaꞋmogamife koli hu-maine. Ani veaꞋmoꞋya Yonifena “Aune kano maine.” huꞋya haya yafe ohaene. ");
INSERT INTO kmu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ohaenegi nago yupa, Helotina atenea kanahe, huꞋya muse hu-taya yupa nagoꞋa veaꞋmoꞋya HelotiꞋene melitalu hu-mainageno Helotiasina munaꞋamoꞋa mukiꞋa veaꞋmogami amuꞋnopi amoa aye-maine. NeꞋayegeno anima ayea yafena HelotiꞋa tusiya huno musena hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nehuno ani munafena mage huno hie “Nagaya tamage Anumaya Koti aulagafi kaha-nepauve kahaisia yafena hisanageꞋna afaꞋa kamigahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Higeno ani munaꞋmona itaꞋamoꞋa nagoꞋa agu agesa amiteno mage huno hie “YoniꞋa ti fale-neꞋama-tea kanomo ageꞋya fakalika agenopaꞋa ai-fakalika yopafi maleteka me namio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","HigenoꞋa ala sauve kanomo aipamoꞋa tusiꞋa kanaꞋage higeno Anumaya Koti aulagafima huno lokiya vai-malea yafeꞋene mainaya vayaꞋamofeꞋene agesa haviteno aliꞋya vayaꞋahe mage hie “Ani munaꞋmo kea ali hipoꞋya hiho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Huteno aliꞋya vayaꞋa hu-mategeꞋya kina nopinaga Yonina ageꞋya mo fakali-talenae. ");
INSERT INTO kmu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","FakaliteꞋya hatagama haya anumaꞋa yopafi maleteꞋya ani munala aliꞋya memigeno itaꞋamotega alino umaine. ");
INSERT INTO kmu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoni anagaꞋmoꞋya augafaꞋa me hipoꞋya huꞋya mo he-vai-teteꞋya Yisasina mo hapai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hapaigeno YisasiꞋa ani kea haviteno tipi kalefi haisaga hu-maino kaꞋme kotega umaine. VigeꞋya mukiꞋa veaꞋmoꞋya ani kea haviteꞋya kumaꞋamileti mopafi akave uꞋya anile umainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","YisasiꞋa tipi kalefiti hati-lavino ti agegayalaga maineno ageana kasagoꞋya melitalu hu-mainaya veaꞋmogamina amaketeno kalagi ai-mateno kali neꞋaliya veala alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Une kigeꞋya agaiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya agaite mage huꞋya me hae “Tagaya vaya omai kaiyaga mainonanagino hani-kisia yafe mukiꞋa veaꞋmogamina hu-ma-tesanageꞋya kumaꞋma hanesilega ute ete huꞋya nesaya kavela miya hisae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hageno YisasiꞋa mage huno hama-paiye “NaꞋa hinageꞋya ugahae? Tamakaitami kavela amamiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","HigeꞋya mage hae “Tagaipina osi kave kanoꞋa hane faefuꞋa (5) mayaene tole noyame kanoꞋagi huno hane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hageno “Ani kavela alitama eho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Huteno YisasiꞋa mage hie “MukiꞋamogatama alitalu hute hute hutama apete mopale maiho.” huno higeꞋya mopale mainageno YisasiꞋa faefuꞋa (5) mayaene tole noyamene alino ikapinaga age-saga huno Anumaya Kotitega huno muse huteno ani maya kolino agaiꞋaenema tokaeꞋya nemaiya anagaꞋa amamigeꞋya mukiꞋa veala amamite amamite hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","HageꞋya mukiꞋa nageno amamu higeꞋya atalaya atupa-tapaꞋa aliꞋya tuelufuꞋa (12) kula ai-hava-te-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","KaveꞋma naya vayaꞋyaga faefu tauseniꞋa (5,000) vemoꞋya ne-mainae. Ne-mainagi aꞋne nafaꞋneꞋamia ohapalinae. OhavunamaꞋa aꞋne nafaꞋnene ne-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Netageno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋmogamina mage huno hama-paiye “Tamakaya nagaila nataletama tipi kalefi haisaga hu-maitama atu kaiyaga hagotetama utegeꞋna nagaya veala hu-ma-tesugeꞋya viho.” ");
INSERT INTO kmu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hu-ma-tegeꞋya utageno agaiꞋage Anumayamotega havigegahe agoꞋyafi haino agaiꞋage mainegeno hani-ki-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hani-ki-geno tipi kalea ti amuꞋnopi utegeno yasimoꞋa aulegati eno ani lipi kalea molino mo ai-yahae me ai-yahae hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Koti avametega YisasiꞋa timo agupile aiya aiyeme aiyeme tipi kalema hanelega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","NeꞋvigeꞋya ani anagaꞋmoꞋya YisasiꞋa ti agupileꞋma aiya ayeme ayeme eaꞋyana ageteꞋya tusiꞋa amamaꞋyo aiteꞋya mage hae “Hakalo neꞋefi?” huꞋya “Avovo.” hae. ");
INSERT INTO kmu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Avovo nehageno aupaꞋa YisasiꞋa mage huno hie “Kolia ohutama maiho. Nagaya neꞋogi tokiyaꞋage hutama maiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Higeno PitaꞋa kenonaꞋa mage huno hie “Anumayamogae kagayama mainenuka nagaifena ‘Timo agupile kaiya ayeme yeme eno.’ huka hugeꞋna vano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Higeno YisasiꞋa Pitafe mage hie “Kagaya elavika eno.” huno hapaigeno PitaꞋa tipi kalefitila hati-lavino timo agupile aiya ayeme yeme Yisasitega ugahe hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ugahe hianagi ala yasimoꞋma tokiyaꞋage huno eaꞋyate ageteno koli huno tipi hapaꞋnesia ya huteno mage hie “Anumayamogae naugafa ali-gatio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Higeno aupaꞋa YisasiꞋa ayana hagaꞋyu huno Pitana atafa huteno mage huno hie “Kagaya nagaifena havika osi kanoꞋa kagupina maleka kametitia hu-mainana kanomogae naꞋa higeka tole kagesa nehavine?” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","NaꞋa huteꞋana tipi kalefi haisaga hu-maiꞋageno yasimoꞋa taga hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Taga higeꞋya tipi kalefima mainaya vayaꞋmoꞋya Yisasife muse huꞋya agia alisaga huꞋya mage hae “Tamage kagaya Anumaya Koti nafaꞋne mainane.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ani ti kotuꞋmona takaeꞋya Kenesale kotega uvaꞋyi hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","VigeꞋya ani kumate veaꞋmoꞋya Yisasina age-lama huꞋya ageteꞋya alu kumate kumate ke huꞋya mage hae “Kali veala amavaletama eho.” huꞋya hageꞋya kali veala amavaleꞋya Yisasite emainae. ");
INSERT INTO kmu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kali neꞋaliya veaꞋmoꞋya emaineꞋya Yisasife mage huꞋya havigae “Kenakamo atupalekeꞋya avate hisune.” huꞋya nehuꞋya avate hu-mainaya veaꞋmogamina kalimoꞋa kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Ani yupa nagoꞋa Falasia vayaꞋene kahegi kema havilinaya anagaꞋene Yelusalemuti Yisasite eꞋya mage huꞋya hae “NaꞋa higeꞋya kagaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya taginagomogami kea ali-tagaeꞋya kaveꞋma negahena amayana sese nohae?*” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hageno YisasiꞋa kenonaꞋamia mage hie NaꞋa higetama tamakinagomogami auꞋavala akaveꞋma malaya yafe Anumaya Koti kahegi kea ago neꞋatagayae? ");
INSERT INTO kmu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anumaya KotiꞋa agaiꞋa autaꞋmafina mage huno hu-maineane. “Tamakaya itatami afotamimogami amakia alisaga nehutama keꞋamia veganokano ohutama amaiyaꞋafinaga maiho. Nago kanomoga itakafokamona kamugema vaitenukahena faligane.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Hu-maineanagi tamakaya mage hutama nehae “Nago kanomoꞋa itaꞋafoꞋamogani anaya hisia monema hanesigenoꞋma itaꞋafoꞋamoganima anaya ohinunoꞋa mage huno hisie ‘Ani monea Anumaya Kotina amisua yane huꞋna hu-mainoe.’ huno hinunoꞋa nefana aya huno agia alisaga ohisie.” hutama nehae. Ani ke nehutama tamakinagomogami auꞋavala akaveꞋma malaya yafe “Anumaya Koti kea afa ya kana nehie.” nehutama alitama neꞋatagayae. ");
INSERT INTO kmu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Tamakaya vagala vaya mainae. AisaiyaꞋa Anumaya Koti aune kanomoꞋa tamakaifena tamage huno Anumaya Koti autaꞋmafina mage huno hu-maineane “Ani nofi veaꞋmoꞋya amavayaleti nagai nagia alisaga nehagi amakuꞋamoꞋa aluꞋale hanegeꞋya ani kavala nehae. ");
INSERT INTO kmu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ma mopafi veaꞋmoꞋya malenaya kahegi kehena ‘Mamona Anumaya Koti ke hanegi akave maleho.’ huꞋya nehayanagi nagai nagia alisaga nehayanagi afa kava maiꞋya nehae.” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","YisasiꞋa agaite esae huno kasagoꞋya veaꞋmogamifena ke higeꞋya ageno mage huno hie “Tamakaya mani kea havilama hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nagola tamavayafima nesaya yamoꞋa tamakuꞋamona alino oniꞋyaꞋagela ohugahigi tamavayafitiꞋma hati-lavisia yamo ali-falote hisigeno tamakuꞋamoꞋa oniyaꞋagela hugahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya Yisasife mage huꞋya hae “Falasia vayaꞋmoꞋya ani kea haviteꞋya amaipa kafa he-gataya kea ago havimainano?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hageno YisasiꞋa mage huno hama-paiye “Ikapinaga mainea NenafaꞋa okalinesia yana agaiꞋa mevakaino hafuꞋyaene tagasi hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tamakaya mani vayafena tamakesa ohaviho. Amaulaga asu hu-mainea vaya mainae. NagoꞋma aulaga asu hu-mainea kanomoꞋa nago aulaga asu hu-mainea afaluꞋamona avaleno vaiyesiana tolemogania komufi asaga hu-lavigaꞋe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Higeno PitaꞋa Yisasife mage hie “Kagaya mani avame kemo aepaꞋa hugeta havimano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Higeno YisasiꞋa mage huno hie “Tamakaya meni kanaene havilama ohunetama nehao? ");
INSERT INTO kmu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tamakaya ohavinao? MukiꞋa yama tamavayafi nageno tamakuꞋafina oꞋunogi tamaipafike taviteno haenagaꞋa aifayolagafi tavino afa ya kana nehie. ");
INSERT INTO kmu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Afa ya kana nehianagi nago yana tamavayafitiꞋma hati-lavia kemoꞋa tamakupiti falote huno tamakuꞋamona alino oniꞋyaꞋagela nehie. ");
INSERT INTO kmu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","TamakuꞋafinagati efalote hia yana maꞋa huno falote nehie kanale ohu tagu tagesa nehavuna yaꞋene vaya he-fali kavaꞋene alu kanomo aꞋne avayu hu yaꞋene aꞋne munaꞋnele kumai he yaꞋene musufaya hu yaꞋene havige hu-ma-te yaꞋene kamuge vai-ma-te yaꞋene taguꞋafitila ali falote nehie. ");
INSERT INTO kmu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","NaꞋama haya yafe tamakupina oniꞋyaꞋagela tamahau-mainegi veaꞋmoꞋya amayama sese ohuꞋya kaveꞋma naya yamoꞋa amakupina oniꞋyaꞋagela ohugahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","YisasiꞋa nemaiya kumala ataleno Taiya kotegaene Saitoni kotegaene umaine. ");
INSERT INTO kmu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Umainegeno nagola anile mainea Kenani aꞋmoꞋa, Yuta vea omainea aꞋmoꞋa, agaife ke huno mage me hie “Ala kanomogae, Tevitina aginagomoga, nagaila kahau hunato. Kefo AvamuꞋmoꞋa nagai munala aguꞋafi faleno maineno tusi havi kava hu-neꞋa-te.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Higeno YisasiꞋa nagola osi ke kanoꞋa ohunegi agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya agaife mage me hae “Ani aꞋmoꞋa tagai takave neꞋeno tusiya huno keha keha nehuno tutu nehigi kagaya hu-tegeno vino.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","YisasiꞋa mage hie “Isalelima vaꞋyagi-mainea sipi sipileke Anumaya KotiꞋa hu-na-tegeꞋna emainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Higeno ani aꞋmoꞋa Yisasi aiyafi aleꞋya meye-maineno mage huno hie “Ala kanomogae naya huo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Higeno YisasiꞋa mage huno hie “Havigu nafaꞋneyagamogami kave hama-faleꞋya kalamogami amamisagi nagaya Isaleli veala amataleꞋna alu vayaꞋne amaya hisuana haviya hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Higeno ani aꞋmoꞋa mage huno hie “Ala kanomogae tamage nehananagi kalamogamina neꞋamafaꞋya nenageꞋya kalamoꞋya sipaletiꞋma asaga hu-lavia atupaꞋa yogiꞋya nenae. Kagaya ani kava huka nagaya Isaleli a omainogi osiꞋa nahaꞋmao.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Higeno YisasiꞋa mage hie “AꞋmogae tusiya huka nagaifena havika kagupi maleka kametiti hanafe nahavigana yana kamigahue.” huno nehigeno ani kana kanoꞋale munaꞋamona kanale hu-tene. ");
INSERT INTO kmu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","YisasiꞋa ani kumala ataleno Kalili ti kotumo agegayalega uteno nago agoꞋyafi haino mopale maine. ");
INSERT INTO kmu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","MainegeꞋya kasagoꞋya veala agaite melitalu nehuꞋya aiya avayu hu-mainea veaꞋnene aiya aya haviya hu-mainea veaꞋnene amaulaga asu hu-mainea veaꞋnene age tagaꞋne-mai veaꞋnene nagoꞋa kali veaꞋnene amavaleꞋya Yisasina aiyafi mematageno alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kanale hu-ma-tegeꞋya mukiꞋa veala agayana higeꞋya tusiꞋa amamaꞋyo ai-mainae. Age tagaꞋne-mai veaꞋmoꞋya kaiyeke hageꞋya amaiya amayamo kayagi-mai veaꞋmogamina amaiya amayaꞋmoꞋa kanale higeꞋya amaiya haviya hu-mainea veaꞋmogami amaiyamoꞋa kanale higeꞋya neꞋvageꞋya amaulaga asu hu-mainea veaꞋmogami amaulagamoꞋa kanale higeꞋya amaulaga age-mainae. NaꞋama haya yate ageteꞋya Isaleli veaꞋmogami Anumaya Koti agia alisaga hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe ke higeꞋya ageno mage hie “Mani veaꞋmoꞋya taliꞋa (3) yupa nagaiꞋene mainageno nesaya kaveꞋamia omalea yafe nahau hu-neꞋama-toe. Havigu amatalesugeꞋya katega nevisageno amakatesigeꞋya amaugetuꞋnatu huꞋya takatiyafena nonahaiye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage huꞋya hapaiye “Mani kotega vaya omai kotegagi hanateti kosa hesia maya alita ani veaꞋnea amamisune?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hageno YisasiꞋa mage huno hama-vige “Tamakaya naꞋmagi maya hane?” huno higeꞋya mage hae “Tagaya seveniꞋa (7) mayaꞋage hanegi nagola osi noyame kanoꞋa hane.” huꞋya hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hageno YisasiꞋa mukiꞋa veafena “Mopale maiho.” huno hama-paigeꞋya mopale mainae. ");
INSERT INTO kmu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mopale mainageno YisasiꞋa ani seveniꞋa (7) mayaene noyamene alino Anumayamotega muse huno havigeteno kolite kolite huno agaiꞋaenema tokaeꞋya nemaiya anagala amamigeꞋya mukiꞋa veaꞋmogamina amaminae. ");
INSERT INTO kmu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","AmamigeꞋya mukiꞋa veala nageno amamu higeꞋya atalaya maya atupayaga agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya alitalu huteꞋya seveniꞋa (7) kupi ai-hava-te-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ani kaveꞋma ne-mainaya veneꞋnea fo tauseniꞋa (4,000) vemoꞋya ne-mainae. NafaꞋneyagaꞋamiene aꞋneyagaꞋamiene nayanagi ohapalinae. ");
INSERT INTO kmu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Netageno YisasiꞋa hu-mategeꞋya utageno agaiꞋa tipi kalefi haisaga hu-maino Magatana kaiyaga umaine. ");
INSERT INTO kmu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falasia vayaꞋene Satiusi vayaꞋene Yisasina meye-vataga hisayafe mage huꞋya me hae “Kagaya ikapinagati tokiya avame yana hugeta agamano.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hageno YisasiꞋa mage huno hie “Unena tamakaya mage nehae ‘IkamoꞋa haesa hianagino ega kanale yage falote hugahie.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Natepiti hetitama mage nehae siaꞋmoꞋa okomaꞋage huno ikamoꞋa ai-haesa hianagino ‘Menia yasimoꞋene koꞋmoꞋene falote hugahie.’ hutama nehae. Tamage tamakaya ikana neꞋagetama ‘NaꞋa hugahie.’ hutama fako nehayanagi meni kanafima falote hia yana age-lama hutama noꞋagae. ");
INSERT INTO kmu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tamakaya meni kanafima mainaya veaꞋmogatama tusiya hutama kefo veaꞋne mainae. Anumaya Kotina tamakaveꞋno hu-neꞋataya veaꞋne mainae. Tamakaya ‘Tokiya avame yana hugeta agamano.’ hutama nagaifena hayanagi nagaya nago avame yana ohugahuanagi Yonama hu-tenea tokiya avame yamaꞋage tamave-ligahie.” huno huteno YisasiꞋa amataleno umaine. ");
INSERT INTO kmu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya tikotuna lakaeꞋya vayana amake-kaniꞋya nagoꞋa maya oꞋaliꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","OꞋaliꞋya vageno YisasiꞋa mage huno hama-paiye “Tamakaya Falasia vayaꞋmoꞋyaene Satiusi vayaꞋmoꞋyaene amakupi hanea yana age-lama ohuꞋya amavayaleti havigema nehaya yana kai hame hale-negia avamete huno halegino alakefa hisia yafena kaꞋye ho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","HigeꞋya ani vayaꞋmoꞋya amakaiꞋami huge havige huꞋya mage hae “Tagaya maya oꞋalita emainona yafe nehie.” huꞋya amakaiꞋami hae. ");
INSERT INTO kmu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Hayanagi YisasiꞋa ani vayaꞋmoꞋya haya kea ago haviteno amakaife mage hie “NaꞋa higetama ‘Kavetia alita omenone.’ hutama tamakaitamia huge havige nehae. Tamakaya nagaifena osi kanoꞋa havitama tamakupi maletama tamametitia hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tamakesa omalegetama havilama nohao? FaefuꞋa (5) mayama faefu tauseniꞋa (5,000) vemoꞋya ne-mainaya yafena tamakesa nohavio? Netagetama naꞋmagi kupi atalaya maya atupayaga ai-mainone hutama nohavio? ");
INSERT INTO kmu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tamakaya seveniꞋa (7) maya kanoꞋa fo tauseniꞋa (4,000) vemoꞋya netagetama naꞋmagi kupi aitama havate-mainone hutama tamakesa nohavio? ");
INSERT INTO kmu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nagaya mayahena tamaha-opainogi. NaꞋa higetama ohavinae? Tamakaya Falasia vayaꞋene Satiusi vayaꞋene amakusafinaga hanea yana agelama ohuneꞋya amavayaleti havigema nehaya yana kai hamemo hale-negia avamete huno halegino alakefa hia yafena kaꞋye ho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mani kema higeꞋya haviyana YisasiꞋa afaꞋa “Kai hame maya hale-negia yafe tamaugafa kaꞋye ho.” huno ohunegi agaya “Falasia vayaꞋene Satiusi vayaꞋmoꞋya nehaya kehe kaꞋye ho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","YisasiꞋa Sisalia Filipai kaiyaga uvaꞋyi huno agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hama-vige “VeaꞋmoꞋya nagaifena, ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋnihena taꞋe huꞋya nehae?” huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hamavi-gegeꞋya kenonaꞋa mage huꞋya hae “NagoꞋa vayaꞋmoꞋya kagaifena YoniꞋe, ti fale-neꞋamatea kano, maine huꞋya hageꞋya nagoꞋa veaꞋmoꞋya kagaifena Ilaiya maine huꞋya hageꞋya nagoꞋa veaꞋmoꞋya Yelemaiya maine huꞋya hageꞋya nagoꞋa veaꞋmoꞋya nayo Anumaya Koti aune kanoa fali-mainea kano maine huꞋya nehae.” huꞋya hapai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hapaigeno YisasiꞋa amakaifena mage huno hama-vige “Tamakaya nagaifena taꞋe hutama nehae?” huno hamavi-ge. ");
INSERT INTO kmu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hamavi-gegeno Saimoni PitaꞋa mage huno hie “Kagaya Kalaisigae, Anumaya KotiꞋma taugafa ali-gatigahe hu-ga-tenea kano mainane. HaimuꞋaene mainea Anumaya Koti neꞋamoga mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Higeno YisasiꞋa Pitafena mage huno hapaiye “Saimonigae, Yona nafaꞋnemoga, mani kea hanafe Anumaya KotiꞋa muse hisana yana kamine. Nagola ma mopafi kanomoꞋa ani yana kaveꞋotinegi ikapinaga mainea Nenafa kave-li-maine. ");
INSERT INTO kmu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nagaya kaha-nepauve kagaya Pitagae ani kagimo aepaꞋa yafamogae. Kagaya yafa kana nehananagiꞋna nagaya mukiꞋa amakuꞋa naminaya veala mani yafaꞋmo agupile no kana huꞋna ki-malenesugeꞋya vayaꞋma hamae-nefalisaya tokiyaꞋamia anima ki-malesua nona alino haviya ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nagaya Anumaya KotiꞋma kava yagai-mainea kumaꞋma yakisana ki nofila kamigahue. Kagaya ma mopafi maineka ‘Ma yana atafa hutama tokiya vaiho.’ huka hisanana Anumaya KotiꞋa agaiꞋenena ikapinaga ‘Ani yana atafa hu-liho.’ huno hugahie. Kagaya ma mopafi nago yafema ‘AfaꞋa ataleho.’ hukama hisanana Anumaya KotiꞋa agaiꞋenena ikapinaga aniꞋa hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe tokiyaꞋage ke huno mage hie “Tamakaya nagoꞋa veala nagaifena ‘KalaisiꞋe, Anumaya KotiꞋma taugafa aligatigahe hutenea kanoa ma maine.’ hutama hama-opaiho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ani yupa YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafena haenagama falote hisia yamofe aepa heno amave-li-maine. Mage huno hie “Nagaya Yelusalemu visugeꞋya ala vayaꞋene mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene tusiꞋa nagata aisia kava hu-nateteꞋya nahaesageꞋna faligahue. FalisugeꞋya komufi he-vai-natesageꞋna tole yupa maiꞋna tagufa kanale fali-mainesufitila hetigahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Higeno PitaꞋa Yisasina faitega avaleno moteneno aepa heno Yisasife mage hie “Anumaya KotiꞋa ani kavala ohisaya amaku amakesa amamisie. Anumayanimogae kagaila ani kavala hu-okatesae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Higeno YisasiꞋa mai-yahae huno Pitafena mage huno hie “Satanigae mai halenato kagaya nagai naguꞋa ali haviya hugahe nehanagi kagaya Anumaya Koti havimainea aguꞋagesa kanaleꞋya huka nohavinagi vayaꞋmoꞋya kaha-paiya amaku amakesa nehavine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafena mage huno hama-paiye “NagoꞋa veaꞋmoꞋya nagai nakaveꞋma visaya amakesa havinuꞋyahena amaugafama aliꞋya hai yana amakaveꞋno hu-teteꞋya nagaiꞋma nagata aisigeꞋna falisua kava hisaya amakesa haviteꞋya yafaga yosa kofiꞋya nakave aliꞋya visae. ");
INSERT INTO kmu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","NagoꞋa veaꞋmoꞋya maiyaꞋamima atafa huꞋya ali-talakoma hu-lisayana maiyaꞋamimoꞋa falino afaya hapaegahigi nagoꞋa veaꞋmoꞋya nagaifema hamainageꞋya maiyaꞋamima atalesaya veaꞋmoꞋya maiyaꞋamia ali-gatisugeꞋya agola aliꞋya maigahae. ");
INSERT INTO kmu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","NagoꞋa veaꞋmoꞋya mukiꞋa ma mopafi mone afenoꞋyaꞋyaga aliteꞋya maineꞋya falisayana agola maige maige hisaya haimula ago atalenayanagiꞋya ali-mainaya mone afenoꞋamimoꞋa hanaꞋa huno amaya hugahie? AꞋao amaya ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia NenafaꞋa tokiya hale yamaꞋaene Anumaya Kotina ensole vayaꞋamoꞋyaene eteꞋna esua kanafina mukiꞋa veaꞋmoꞋya ma mopaleꞋma hu-mainesaya yateti anonaꞋa amamigahue. ");
INSERT INTO kmu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tamage-lafa huꞋna tamaha-nepauve nagoꞋa veala maleꞋma hetiꞋya mainaya veala aupaꞋa ofaligahayanagiꞋya hagoteꞋya nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonina Anumaya KotiꞋa kava yagai-mainea yapi maineꞋna esugeꞋya nagegahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","YisasiꞋa sikisiꞋa (6) kana maiteno Pitana Yemesina Yonigamina amavaleno ayaꞋaya agoꞋyafi hai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","HaiꞋya mainageno Yisasina augosamoꞋa alino alu augosa kaligeno augosafitila yage kana huno ai-vasa nehigeno kenaꞋamoꞋa efeꞋage huno alave alave hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ageho tole kanolana nayoma fali-mainaꞋa kanolana MoseseꞋene IlaiyaꞋene YisasiꞋene kea kea nehaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","NehaꞋageno PitaꞋa Yisasife mage hie “Anumayamogae tagaya male maunana kanaleꞋya hie. Kahaisigekahena katega nona taliꞋa (3) ki-lama-tesue kagaila nagolagi Mosesena nagolagi Ilaiyana nagolagi huno hanesie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ani kea hanepaigeno nagola hale yamaꞋaene siaꞋmoꞋa evaꞋyi huno alino aiso hu-mategeno siapinagati ala kefiti age aino mage huno hie “Mani kanoa nagai nafaꞋnegi nahau nayamopafi nenagea kanogi agaifena aluya huno nenahaigi agai kea haviho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya koli huꞋya amamaꞋyo aigeꞋya mopafi amakoꞋya aiye-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","AmakoꞋya aiyeꞋya mainageno YisasiꞋa avate eno mage hie “Kolia ohiho. Hetiho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","HigeꞋya age-saga huꞋya agayana YisasiꞋa agaiꞋage mainegeꞋya age-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","AgeteꞋya agoꞋyafiti enelaviꞋya YisasiꞋa kahegi mateno mage huno hie “Anima agaya yafena nagoꞋa veaꞋnea hamaꞋopainegeꞋna ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna fali-mainesufiti hetisua yupa hama-paigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","HigeꞋya agaiꞋaenema lokaeꞋya nemaiya anagaꞋmoꞋya mage huꞋya havigae “NaꞋa higeꞋya kahegi kema havilinaya anagaꞋmoꞋya ‘IlaiyaꞋa hagoteno neꞋesigeno Anumaya KotiꞋa taugafa ali-gatisia kanoa egahie.’ huꞋya nehayane?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Havigageno YisasiꞋa mage huno hie “Tamage IlaiyaꞋa hagoteno egahianagino mukiꞋa yana alino kanaleꞋya huno talo tala hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hugahianagi tamaha-nepauve IlaiyaꞋa ago emaineanagi agaila age-lama ohuꞋya hamaiya kava huꞋya agaila havi kava hu-tenaya kavala aniꞋa huꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonina ali haviya hu-natesageno naugafa nagata aigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mani kema hiana “YoniꞋa tima fale-neꞋamatea kanomofe hie.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","YisasiꞋene agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mukiꞋa veala melitalu huꞋya mainale evaꞋyi hageno nago kanomoꞋa Yisasite mepe hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Yisasifena mage huno hie “Anumayamogae kagaya neꞋnafaꞋneꞋnimona kahau huto. Ani nafaꞋneꞋnia mananiꞋya neꞋagegeno augafamona ali haviya nehigeno mukiꞋa yupa ata taꞋnekino tipi asaga hu-nelavino nehie. ");
INSERT INTO kmu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","NaꞋa nehigeꞋna kagaiꞋene tokaeꞋya nemaiya anagakamogamite avaleꞋna oana aliꞋya kanale hu-tesaya amukoꞋamia omalene.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Higeno YisasiꞋa mage huno hama-paiye “Vae tamakaya meni kanafima mainaya veaꞋmogatama nagaifena havitama tamakupi maletama tametitia ohutama fatago hutama nomaiye. AniꞋa haya yafe kasalo nenahaegi naꞋmagi yupa tamakaiꞋenena mainesugetama nagaifena havitama tamakupina malegahae? huno nehuno ani nafaꞋnemo nefafe ‘NafaꞋnekaꞋa avaleka eno.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Higeno avaleno egeno YisasiꞋa anima agupi mainea Kefo Avamufena ke-makino ‘Ataleka hati-lavio.’ huno hutegeno hati-lavigeno aupaꞋa ani nafaꞋnemona kanale hu-tene.” ");
INSERT INTO kmu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya amakaiꞋamige Yisasite mage huꞋya me havigae “Tagaila naꞋa higeno Kefo AvamuꞋma anatisuna amukotia omale?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Hageno YisasiꞋa mage huno hama-paiye “Nagaifema havitama tamakupi maletama tamametiti haya yatamimoꞋa osi hu-mainea yafe ani kava hisaya amukotamia omalene. E, nagaya tamage-lafa huꞋna tamaha-nepauve tamakaya osi kanoꞋa oꞋagemo avina kanoꞋa Masatati avinamoꞋma hia kava hutama nagaifena havitama tamakupi malaleꞋasina ma agoꞋyamofena mage hutama hapaisagenoꞋa ‘Hetika alule vuo.’ hisagenoꞋa ani agoꞋyamoꞋa agola vileꞋasine. Nagaifema havitama tamakupi malesayana tamakaya nago aliꞋyafena ‘Amuha ohunone.’ hutama ohugahagi mukiꞋa tokiya kavala iohugahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kalili kotega alitalu huꞋya mainageno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hama-paiye “Osi kanaꞋa maitesugeno nago kanomoꞋa nagesi huno ikapinagati emainoa kanoa vayaꞋmo natenea kanomonina kame vayaꞋmogami amayapi navaleno nategahie. ");
INSERT INTO kmu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","NatesigeꞋya nahaesageꞋna falisugeꞋya he-vaina-tesageꞋna tole yupa komufi maiteꞋna tagufa (3) molisia kanale eteꞋna he-tigahue.” huno higeꞋya ani kehena agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya havigeno kanaꞋage hamau-maine. ");
INSERT INTO kmu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nago yupa YisasiꞋene agaiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya Kapaneamu evaꞋyi hageꞋya mono noma ali fatago hisaya monea vaya amaugafaleti takesi neꞋaliya vayaꞋmoꞋya Pitate mage huꞋya me havigae “Tamakaila hu-lamave-nelia kanomoꞋa ani mono note monea neꞋataleo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hageno PitaꞋa mage hie “E, ani monea neꞋatale.” huno nehuno nopinaga hai-falegeno YisasiꞋa hagoteno mage huno havige “Saimonigae naꞋane kagesa nehavine. Ma mopale sauve vayaꞋmoꞋya vaya amaugafaleti takesi monea aliꞋya tagami neꞋamamiye? MukiꞋa amakaiꞋami kotega vayateti neꞋalio ifi alu vayaꞋmogamiteti neꞋaliyo?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Havigegeno PitaꞋa mage huno hie “Alu vayatetila afaꞋa neꞋaliye.” huno higeno YisasiꞋa mage hie “Tamage hane. AniꞋa huꞋya amakaiꞋami kotega vayaꞋmogami amaugafaletila takesi noꞋaliye. AniꞋa huta lagaya Anumaya Koti anaga mainonagi tagaitetila takesia oꞋalisae. ");
INSERT INTO kmu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","OꞋaligahayanagi havigu naꞋa hisunageꞋyahena amaipamoꞋa haviya hugahayanagika kagaya ti kotute visanaꞋamoga noyame hukua atalesanageno tavisigeka hagote noyamema avayuma hinuka avaya ali aka hu-lineka nagola monea agegane. Ani monea alika ani vayala memamisanageꞋya tolemogatiꞋa taꞋaugafaleti takesi monea aligahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ani yupa YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya Yisasite mage huꞋya me havigae “Hana kanomo muki vayala amakaseno Anumaya Koti kava yagai-mainea kumatela uhakote-mainea kanoa maigahie.” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Havigageno YisasiꞋa nago osi nafaꞋnea ke higeno egeno mukiꞋa vayaꞋmogami amuꞋnopi avaleno he-ti-tene. ");
INSERT INTO kmu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","He-ti-teneno mage huno hie “Nagaya tamage-lafa huꞋna tamaha-nepauve tamakayama tamakuꞋa ai-yahae hutama nafaꞋnemoꞋyama amaugafa aliꞋya nohaiya kava hutama osi nafaꞋnemogami avamete ohisayana Anumaya KotiꞋma kava yagai-mainea kumatela hai ofalegahae.” ");
INSERT INTO kmu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nago kanomoꞋa agaiꞋa augafama alino ohaino osi nafaꞋnemo avamete maisiana ani kanomoꞋa nagoꞋa veala amakaseno Anumaya Koti kava yagai-mainea kumatela hagote kano maigahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","NagoꞋa veaꞋmoꞋya nagaifema huꞋya ma ma osi nafaꞋnema avaleꞋya falu fala hu-tesayana nagaiꞋenena navaleꞋya falu fala hu-nenatae. ");
INSERT INTO kmu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","NagoꞋa veaꞋmoꞋya nagoꞋma nagaife haviꞋya amakupi malenaya anagapiti nago osi kanohema “Kefo yama huo.” huꞋya hisayana tusiꞋa kefo kava nehayanagiꞋna tusiꞋa kana ya amamigahue. Ala yafakefaleti ani kanomo ageꞋyafi maleꞋya nofi ki-teteꞋya hage lipi hagaꞋyu hu-talageno ti nakaino falisiana ani kana yamoꞋa afa ya kana ya haneanagi nagaya tusiꞋa kana ya amamigahue. ");
INSERT INTO kmu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","AvoꞋnio ma mopale veaꞋmogatama tusi nahau hu-nelama-toe. Mopafi mainaya kanafina “Kefo yama hiho.” huꞋya aye-mavataga hisaya yana falote hugahianagi nagoꞋa veaꞋmoꞋya “Kefo yama hiho.” huꞋya aye-mavataga hisaya veafena “AvoꞋnio kefo kava nehananagika kana yana aligane.” huꞋna tusi nahau hu-nelama-toe. ");
INSERT INTO kmu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","KayaꞋene kaiyamoꞋene “Kefo yama huo.” huꞋana kavaleꞋana havi kapima katesaꞋagekahena ani kaiya kayana ai-fakalika hagaꞋyu hutalo. HagaꞋyu hu-talesanana kanalele. Kaugafa haviya hu-mainesia kano maisanana kanalelagika haꞋno ohu kahaimuka hanesia kano maiyo. Havigu tole kayano tole kaiyao kefo ya hisana kagesa kaminegeka kefo yama hu-mainesana yafe kavaleno hani yapi agola tegelege nehia atafi hagaꞋyu hu-gatalegahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","KaulagamoꞋa agesia yamoꞋma kefo ya hisana kagesama kaminageka ani kaulaga ali faꞋyika hagaꞋyu hutalo. Ali faꞋyi-talesanana kanalele. Nagoke kaulaga hanesigeno kanale haꞋno ohu kahaimula kamisigeka alika maigananagi havigu tole kaulagamoꞋa kefo ya hisana kagesa kaminegeka kefo yama hisanafe hani yapi tegelege nehia atafi kavaleno hagaꞋyu hu-ga-talegahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Tamakaya kaꞋye ho. Havigu nagoꞋa osi anagaꞋnihe “Afa ya kana veaꞋne mainae.” hutama huyafenagi nagaya mage huꞋna tamaha-nepauve ani osi anagala ensole vayaꞋamimoꞋya ani nafaꞋneꞋyagale kava neꞋyagaiꞋya mukiꞋa yupa ikapinaga maineꞋya Nenafa aufina neꞋagae. ");
INSERT INTO kmu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Na tamakesa nehaviye? Nago kanomoꞋa vani hataletiꞋa (100) afu mainefiti nagola fanane higeno ani afumona nefaꞋa mukiꞋa afuꞋa talapinaga amataleno talapinaga viaꞋyamo nagokeꞋma fanane hu-mainea afuꞋahe ati-yeno yeno ali falote hisio? E, fananema hisigenoꞋa aniꞋa huno ati-yegahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nagaya tamage-lafa huꞋna tamaha-nepauve agoꞋma fanane hu-mainesia afuma ali falote huno avalesiana tusiꞋa muse hugahie. Naiti nainiꞋa (99) afuyagaꞋahena muse hianagi nagokeꞋma fanane hu-mainesia afuma ali falote hu-tenoꞋa tusiya huno musena hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","NaꞋa hu-mainegi ikapinaga mainea NelamafaꞋa nagola osi anagaꞋa fanane hisia yafena nohaiye. ");
INSERT INTO kmu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kafu-kaganaꞋma kefo yama hu-ga-tesigeka tanakaya tokaetana mainetana kefo yama hu-mainesia yana avelio. Ave-lisanageno kagai kema haviteno kefo yama hisifitila aguꞋa ai-yahae hisigeka avaleka kagaika kametega ategane. ");
INSERT INTO kmu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ateganagi kekama ohavisigekahena nagokepi tole kanola anavaleka vinuka tolefi (2) tagufa (3) vayaꞋmoꞋya hu-ga-tenea yana ageteꞋya hu-falote huꞋya fako huꞋya ani kanomona aumono maleho. ");
INSERT INTO kmu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aumono maletesageno ani kanoꞋmoꞋma nagoꞋene amakai kema ohavisigeka kagaya Yisasife haviꞋya melitaluma huꞋya maisaya veapi avaleka ugeꞋya aumonola maleho. AumonoꞋma malesageno ani vayaꞋmogami kema ohavisigeka kagaya mage huka huto “Yisasi kea ohavi vaya kana hana kanomoga tagaiꞋenena eomaika kahaote maiyo.” huka huto. ");
INSERT INTO kmu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ani kema hu-tesayana tamage-lafa huꞋna tamaha-nepauve tamakaya ma mopale mainayana “Ma ya atafa hutama tokiya vaiho.” hutama hisayana Anumaya KotiꞋa ikapinaga aniꞋa huno “Ani yana atafa hiho.” hu-lokiya vaigahie. Tamakaya ma mopale mainetama nago yafema “AfaꞋa ataleho.” hutama hisayana Anumaya KotiꞋa ikapinaga aniꞋa hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","EteꞋna nago kea tamaha-nepauve mopafi mainetama tole kanolaganima nago yafema nagoke anaku anakesaleꞋma mainenuꞋana ani yafena Anumaya Kotitega havigesaꞋageno ikapinaga mainea NeꞋanafaꞋa anamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","E, tole (2) kanofi tagufa (3) vayapi nagai nagileꞋma haviꞋya melitalu hisayana nagaya nagaiꞋniꞋa amuꞋnoꞋamifina maigahue huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","PitaꞋa Yisasite eno mage huno hie “Anumayamogae naꞋmagi kana nafuꞋnaganana kefo yana hu-na-tesigeꞋna ani kefo yamaꞋahe aigeꞋateꞋna atale-tesue? SeveniꞋa (7) yupa kefo yama hu-na-tesigeꞋna aigeꞋateꞋna atale-tesuo?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Havigegeno YisasiꞋa mage huno hapaiye “Kagaifena seveniꞋa (7) yupa ani kavala huo huꞋna nohugi nagaya mage huꞋna nehue kasagoꞋya yupa ohavunamaꞋa kanale havi yama hu-ga-tesigeka aniꞋa huka ohavunamaꞋa kana aigeꞋateka ataleto huꞋna nehue.” ");
INSERT INTO kmu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anumaya Kotife “Kava yagai-nato.” huꞋya hu-mainesaya veaꞋmoꞋya ma kava nehae. Nago kumate sauve kanomoꞋa agai aliꞋya veafe mage huno hie “Yoka kaminoa moneꞋniꞋa anonaꞋnia fatago hutama namiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Huteno fatago hugahe nago kanoa avalegeno eno aminea yatefe anonaꞋa ohavunamaꞋa monegefa, nago kanomoꞋma fifitiniꞋa (15) kafu aliꞋya alino ne-mainea augafa mone eteno anonaꞋa amisia yana hane. ");
INSERT INTO kmu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Haneanagi monema amisia amukoꞋa omalegeno kava kanomoꞋa mage huno hie “Kagaikaene akamoꞋene nafaꞋnekaene afenoꞋyakaene alu kanomote atalegeno miya hisigeꞋna kagaiteti anonaꞋa monea alino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Higeno ani aliꞋya kanomoꞋa kava kanomo aiyafi aleꞋya meyeno mage huno hie “NaꞋa ohuka kahau hu-na-teka ako huka nagava mainegeꞋna nagaya haenagaꞋa naminana yatela anonakaꞋa mukiꞋa kamigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Higeno ala kava kanomoꞋa aliꞋya kanoꞋahena tusiꞋa hau hu-teteno anonaꞋama oꞋamia yafena aigeꞋateno atale-tene. ");
INSERT INTO kmu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Atale-teanagi ani aliꞋya kanomoꞋa hati-lavino viaꞋyamo tokaeꞋana aliꞋya neꞋaliꞋa kanomona moge-maine. Ani kanomoꞋa nago yupa agaifena mage huno hie “Nagoke Sotama aliꞋyana aliꞋya nenaya augafa mone yoka namio.” huno higeno amianagi anonaꞋa oꞋamine. OꞋaminea yafe ani kava kanomoꞋma hau hu-tenea kanomoꞋa ani afaluꞋamona ageꞋyafi atafa hu-lineno mage huno hie “Kagaila yoka kaminoa yana anonaꞋa mukiꞋa yaniꞋa aupaꞋa namio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Higeno aliꞋya tokaeꞋana neꞋaliꞋa kanomoꞋa aleꞋya ayeno mage hie “NaꞋa ohuka ataleka afaꞋa kahau hu-na-teka ako huka nagava mainegeꞋnao. Haenaga anonakaꞋa kamigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Higeno ani kanomoꞋa mage huno hie “AꞋao naꞋa kehena nonahaiyafe nofi nopi hu-ga-tesugeka maineka haenaga anonaꞋa namiteka nofi nopitila ataleka maigane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","HigeꞋya nagoꞋa tokaeꞋyama aliꞋya neꞋaliya veaꞋmoꞋya naꞋama hia yafena haviteꞋya amaipamoꞋa haviya higeꞋya kava kanomote mukiꞋa hu-mainea kavafena mo falote hae. ");
INSERT INTO kmu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mo falote hageno ala kava kanomoꞋa atale-tenea aliꞋya kanoꞋahe ke higeno egeno mage huno ha-paiye “Kagaya tusiya huka havi aliꞋya kano mainane. Hagoteka nagaifena avi metanageꞋna anonakaꞋa aigekateꞋna atalega-tenoe. ");
INSERT INTO kmu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nagaya kagaifena nahau hu-ga-toanagi naꞋa higeka ani avamete kavala ohuka kagaya tokaeka aliꞋya neꞋalina kanohena kahauna hu-oꞋatane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huteno kava kanomoꞋa tusiꞋa hai-vaiteno kina nopi avaleno viaꞋyamo kaꞋyo amisaya vayaꞋmogami amayapi ategeno mage hie “Tusi agata ya amitegeno haenagaꞋa mukiꞋa yaniꞋa anonaꞋa namitesigetama atalegeno vino.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","YisasiꞋa mage huno hu-maine “Tamakaya tamafu-tamakanaꞋya kefo yama hu-lama-tesagetamahena amegatila hu kanale ohutama tamage hutama tamaipa kanale yapiti aigeꞋamatetama atale-oꞋama-tesayana ikapinaga mainea NenafaꞋa aniꞋa huno ani mukiꞋamogatamina kinama hu-tenea avamete huno hu-lamategahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","YisasiꞋa mukiꞋa mani kema hu haꞋnoma nehunoꞋa Kalili kotega ataleno Yotani limoꞋa ame kaiyaga Yutia kotega uvaꞋyi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","MukiꞋa veaꞋmoꞋya Yisasi akave vageno kaliꞋamia alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","NagoꞋa Falasia vayaꞋmoꞋya Yisasite eꞋya kanale ohunea kema hisiafene huꞋya nagola aye-vataga hisaya kea mage huꞋya havigae “Nago kanomoꞋa aꞋamoꞋma nehia kavafe atalesia agesama hisigenoꞋa kanalelagino atalesio? Kahegi kemoꞋa ani yafena naꞋane nehie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Hageno YisasiꞋa kenonaꞋamia mage huno hie Tamakaya Anumaya Koti avona hapalitama ohavinao? Mage huꞋya kae-malenayane Anumaya KotiꞋa ehe yupa aepa heno vene aꞋene talo hu-maleteno mage hie “Vene aꞋene talo humalenoafe nago kanomoꞋma itaꞋafoꞋamoma ataleno aꞋamoꞋene ai-lokaeno maisiana ani tolemogania nagoke anaugafa kaligaꞋe.” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","NaꞋa hu-maineafe nagoꞋene tolea omainaꞋagi menia nagoke anagufa kaliꞋana mainesaꞋageno Anumaya KotiꞋa anakaila alino hagelafi-na-teneanageno nago mopale kanomoꞋa ani alavelamogani mai yaꞋania alino apase oꞋana-tesie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","HigeꞋya Falasia vayaꞋmoꞋya Yisasife mage huꞋya havigae “NaꞋa higeno MoseseꞋa nagola kahegi kefina ma kea huno taha-pai-maineane ‘VemoꞋa aꞋamona avo kaeno neꞋamino hu-tesigeno haꞋno huno ugahie.’ huno hu-maineane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hayanagi YisasiꞋa mage huno hama-paiye “Nayona ehela ani yafena Anumaya KotiꞋa malegeno omalenea kavala haneanagi tamakaya ke ohavitama veganokano haya yafe MoseseꞋa aꞋma atalesaya kaana tama-ve-li-maineane. ");
INSERT INTO kmu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nagaya tamaha-nepauve nago kanomona aꞋamoꞋma kumaima ohenesigenoꞋma anauꞋamoꞋa neꞋataleno nago aꞋma alisiana ani kanomoꞋa kumai kano maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya Yisasina mage huꞋya hapaiye “AlavemoꞋya tokaeꞋya maisaya auꞋava yamofe tusiꞋa tokiya kema hanesigetahena afaꞋa neyaꞋve maineta aꞋnea oꞋalisune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hageno YisasiꞋa mage huno hama-paiye “Haya kea tamage nehagi mukiꞋa neyaꞋvemoꞋya aꞋnema oꞋalisaya amukoꞋamia omaleneanagino Anumaya KotiꞋa tokiya amaminea vayaꞋmoꞋyage aꞋnea oꞋaligahae. ");
INSERT INTO kmu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","NagoꞋa neyaꞋvemoꞋya aꞋnema oꞋalisaya tokiyaꞋamia hane. Ani vayapitila nagoꞋa neyaꞋvemoꞋya itaꞋaꞋmimo ama-tenea yupa amakayamoꞋma faꞋyi-talenesaya vayaꞋma mainesayana aꞋnea oꞋaligahae. NagoꞋa neyaꞋvema alu vayaꞋmoꞋyama amakayamoꞋma faꞋyi-talenesaya vayaꞋmoꞋya aꞋnea oꞋaligahae. NagoꞋa vayaꞋmoꞋya ‘Anumaya KotiꞋa kava yagai-la-tesie.’ huꞋya amakesa havi-mainesaya vayaꞋmoꞋya Yisasi kema hama-paisaya yafenagiꞋya ‘AꞋnea oꞋaligahune.’ huꞋya hugahae. Ani kema havilinesia kanomoꞋa ani kava hisie.” ");
INSERT INTO kmu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","VeaꞋmoꞋya osi osi nafaꞋneyaga Yisasife “Aya maleno amakaife Anumayamotega havigesie.” huꞋya amavaleꞋya neꞋageꞋya agaiꞋaene tokaeꞋya nemaiya anagamoꞋya ageteꞋya “NaꞋa kavala ohiho.” huꞋya ke-amaki-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ke-amakiyanagi YisasiꞋa mage huno hie “AmatalegeꞋya nagaitega eho. NafaꞋneyaga nagaite esaya yafena kahegi oꞋama-teho. NaꞋa huꞋya nafaꞋnemogami avamete maisaya veaꞋmoꞋya mage hugahae ‘Tagaya tokiyatia omalenegi Anumaya Kotiga kava yagai-lato.’ huꞋya hugahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anumaya KotiꞋa hamaꞋmaesia yafe ayana amaugafale maleteno neꞋamataleno alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nago kanomoꞋa Yisasiteka eno mage huno havige “Hu-mave-nelina kanomogae nagaya hana augafa kanale kava huteꞋna agola maige maige hisua nahaimula alisue?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Havigegeno YisasiꞋa kenonaꞋa mage huno hie “NaꞋa higeka kanale auꞋavafena nahavi-negane? Nagoke kanoa Anumaya KotiꞋa agaiꞋage kanale kano maine. Agola maige maige hisana kahaimuꞋma alinukahena Anumaya Koti kahegi kea akave malo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Higeno Yisasifena mage huno havige “HanaꞋa kahegi kehe nehane?” huno higeno YisasiꞋa mage huno hie “Vayala haegeno ofalino. Kumai he yana ohuo. Musufayana ohuo. ‘Ma kanoa havi kava nehie.’ huka havigea hu-oꞋato. ");
INSERT INTO kmu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Itakafokamo kea oꞋatagaeka anakia alisaga huo. Kagaika kaugafahena kahaiya avamete huka aniꞋa huka negafu augafahena kahaino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Higeno ani kanomoꞋa mage huno hie “Nagaya mukiꞋa ani kea akave nemaloe. Na yamo nagoꞋa kosa he-ona-tene? Na yaꞋene hisue?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Higeno YisasiꞋa mage huno hie “Nago kavaꞋene hisanana kosa he-ga-tesigeka fatago kano maigane. MukiꞋa malenana mone afenoꞋyaꞋyagaka alika fako faka huka moneꞋamima omalenesia veaꞋne amamisanageno Anumaya KotiꞋa ikapinaga hanea afenoꞋyana kamigahie. AfenoꞋyaꞋyagaka amamite amamite huteka nakave eno.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Higeno ani kanomoꞋa ani kea haviteno mone afenomaꞋamoꞋma kasagoꞋma hu-mainea yafe oꞋatalesia agesa haviteno aipamoꞋa tusi kanaꞋage higeno umaine. ");
INSERT INTO kmu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vigeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hie “Tamage huꞋna tamaha-nepauve mukiꞋa mone afenoꞋyaꞋamima hanesia veaꞋmoꞋya tusiꞋa kasageke huꞋya Anumaya Kotife ‘Kava yagai-lato.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","NagoꞋene tamaha-nepauve nagola pulumaka kana afumo agia kemolomoꞋa nekaꞋyamo kapima hai-falesiana afaꞋa yoꞋyo huno hai-falegahianagi mukiꞋa mone afenoꞋyaꞋamima hanesia veaꞋmoya Anumaya Kotife ‘Kava yagai-lato.’ huꞋya kasageke-voke hugahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya amamaꞋyo neꞋaiꞋya mage huꞋya hae “NaꞋama hu-mainesiana Anumaya KotiꞋa hana veaꞋmogami amaku amame ali-gatigahie?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hageno YisasiꞋa neꞋamakeno mage hie “VeaꞋmogamina amukoꞋamia omaleneanagiꞋya ohugahayanagi Anumaya KotiꞋa mukiꞋa kavala hisia amukoꞋa haneanagino afaꞋa huno ali-gatigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nage higeno PitaꞋa mage huno hie “Havio tagaya mukiꞋa yatia ataleteta kakave neꞋonagi tagaya na ya aligahune?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Higeno YisasiꞋa mage huno hama-paiye “Tamage huꞋna tamaha-nepauve haegafa kanamoꞋa mukiꞋa yana yaufa ya falote hisigeꞋna nagaya ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna kava yagaisuafe tusiꞋa tokiya hale yamaꞋa hanea siale mainesugetama tamakaya nakave nehaya vayaꞋmogatama tuelufuꞋa (12) siale mainetama tuelufuꞋa (12) Isaleli nofi veaꞋmogamina kava yagai-ma-tegahae. ");
INSERT INTO kmu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","MukiꞋa veaꞋmoꞋya nagaifema haviꞋya veaꞋmogamina nagai kema hama-paigahena noꞋamiene nepuꞋamiene amasaꞋamiene itaꞋafoꞋamiene nafaꞋneꞋamiene hoyaꞋamiene amataleꞋya visagenoꞋa Anumaya KotiꞋa anonaꞋamia atalenesaya yaꞋene vani hataletiꞋa (100) mani yaꞋyaga amamiteno maige maige hisaya hamaimuꞋene amamigahie. ");
INSERT INTO kmu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Meni kanafina hagoteꞋya mainesaya veaꞋmoꞋya ani kanafina haenagalafa maigahagi meni kanafima haenagalafa mainesaya veaꞋmoꞋya ani kanafina hagoteꞋya maigahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anumaya KotiꞋa kava yagai-mainea yamoꞋa maꞋa hu-maine. Nofi alagamo hoyamona nefaꞋa kege aluganale ani hoyafi aliꞋya alisaya vayafe ke hugahe umaine. ");
INSERT INTO kmu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uno mage hie “Nagoke yupa kanoꞋa aliꞋyama alisageꞋnahena nagoke vani (1) kina tamamite tamamite hugahue.” huno higeꞋya nagoke amaipa hageno hoyafi hu-ma-tegeꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Umainageno yagemoꞋa naeni (9) kilokile haigeno vaya atagu-nefaya kumapi viana nagoꞋa vayala afaꞋa hetiꞋya mainageno momake-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Momaketeno mage hie “TamakaiꞋenena nofi alagamo hoyaꞋnifi aliꞋya molisageꞋna miyana fatago huꞋna tamamigahue.” huno higeꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Umainageno yagemoꞋa amuꞋnokaꞋno higeno aniꞋa hu-maine. YagemoꞋa alitulu huno lavigeno aniꞋa huno nagoꞋa vayafe “AliꞋya moliho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Higeno unena aupaꞋa velo hugahe higeno nagoꞋa vayala afaꞋa heti-mainageno momaketeno mage huno hie “NaꞋa higetama ayaꞋaya kanagefa heti-taletama afaꞋa mainae?” huno hamavi-ge. ");
INSERT INTO kmu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hamavi-gegeꞋya mage hae “Nago kanomoꞋa aliꞋyana otamigeta afaꞋa mainone.” huꞋya hageno “Kanalelagi tamakaya nagai hoyafi aliꞋyana moliho.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hama-paigeꞋya mo-neꞋaligeno une velo hilega nofi alagamo hoyamona nefaꞋa agaiꞋa aliꞋya kava kanohe mage huno hapaiye “AliꞋya vayafe ke hugeꞋya egeka miyana amamio. Haenagama amavaloa vayaꞋmogami miyana amamiteka hagoteꞋnama amavale-mainoa vayala haenaga amamio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","HigeꞋya une avavema amavalea vayaꞋmoꞋya ageno nagoke vani kina amamite amamite hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Amamite amamite higeꞋya hagotenoꞋma amavalegeꞋya aliꞋyama meli-mainaya vayaꞋmoꞋya mage huꞋya amakesa haviye “Ala miya aligahune.” huꞋya haviyanagi nagoke vani kinageꞋya ali-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","AliteꞋya hoyamona nefafena tusiya huꞋya kea-makiꞋya mage hae “Haenagama amavale-mainana vayala yagemoꞋa osi kana kanoꞋa nagoke kana nehigeꞋya aliꞋyana meli-mainagi tagaya afaꞋa hetita omainonagi tusiꞋa amukonako hia aliꞋya ali-mainonanagi nagoke avamete havi miya nelamine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hageno ani hoyamona nefaꞋa amuꞋnoꞋamifi mainea kanohe mage huno hie “Nenafuga havio nagaya havi kavala hu-notama-toe. Natema tamaha-vi-gogetama ‘E, nagoke vani kina aligahune.’ hutama hagetila naꞋa higetama mani kea nehae? ");
INSERT INTO kmu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","AliꞋyama alitama aliya monea alitama notamilega viho. Nagaya nahaiya avamete huꞋna haenagama amavaloa vayaꞋene nago avamete miyana nelamamue. NagaiꞋni yanagi haile. ");
INSERT INTO kmu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ani monea nagaiꞋniꞋa mone. ‘Nagayama hugahue.’ huꞋna hisua yafena ‘Ohuo.’ hutama nehao? Nagaya vayaꞋma kauva yafe tamaipa haviya nehao?” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","YisasiꞋa mage hie “Nagaya aniꞋa hugahue. Haenagalafa mainesaya veala hagoteꞋya maigahae. HagoteꞋya mainesaya veala haenagalafa taviꞋya maigahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Yelusalemu haigahe katega neꞋuno YisasiꞋa tuelufuꞋa (12) anagaꞋamogamina amahaote amavaleno moma-teteno mage huno hie “Haviho tagaya Yelusalemu haisunageꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia nagaila nagesi hinageꞋya mono note kava vayaꞋmoꞋyaene kahegi kema havilinaya anagaꞋene kame vayaꞋmogami amayapi navaleꞋya na-teteꞋya ‘Haegeno falino.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yuta vea omainaya vayate navaleꞋya momamisageꞋya nagaye hisifa kea hu-nateꞋya hu-haviya hu-na-teteꞋya hegi kaꞋyoteti nahaeteꞋya yafaga yosale nili nahaeꞋya asaisageꞋna faligahue. FalisugeꞋya he-vai-natesageꞋna tole yupa komufi maiteꞋna tagufa (3) kanale fali-mainesufitila Anumaya KotiꞋa ali he-ti-na-tegahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sepetina aꞋamoꞋa netalamaꞋaene Yisasite eꞋya ani aꞋmoꞋa nago yafe havigegahe aiyafi aleꞋya meye-maine. ");
INSERT INTO kmu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aye-mainegeno YisasiꞋa mage huno havige “NaꞋa hu-gatesue?” huno higeno mage huno hie “Kava yagaisana kumate umainesanageꞋana mani tole neꞋnimogania kavate maineꞋana nagoꞋmoꞋa tamaga kayatega maisigeno nagoꞋmoꞋa hauga kayatega maisie.” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Havigegeno YisasiꞋa mage huno netalamaꞋamogania hana-paiye “Nahavi-gea yana ohavinaꞋe. Falisua yana satuꞋage hu-mainea timo avamete ti hanea keꞋayopiti negahugi tanakaya kanale negaꞋo?” huno higeꞋana “E, tokiyatiꞋa haneanagitaꞋa negahuꞋe.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","HaꞋageno mage huno hie “Tamage satuꞋage hu-mainea tina negaꞋanagi ala vaya mainelega tamaga nayategaene hauga nayategaene siale maisaya yana nagaiꞋni yana omalenegi NenafaꞋa ani yana nagoꞋa vayafe ago talo tala huno fatago hu-ma-tene.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","HigeꞋya teniꞋa (10) anagaꞋamoꞋya ani kea haviteꞋya ani kanolafe amaipa haviꞋya haviya hu-na-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","YisasiꞋa “Nagaitega eho.” huno higeꞋya ageno mage huno hie “Ma mopale ala kava vayaꞋmoꞋya ‘TusiꞋa ala vaya mainone.’ huꞋya Yuta vea omainaya veafe ke amama-kiꞋya aliꞋya ke hu-ma-teꞋya kava vayaꞋmogami avamete nehae. ");
INSERT INTO kmu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","NaꞋa nehayanagi tamakaya ani kavala ohiho. Tamakaipina ‘Nagi hanea kanoma maigahue.’ huno hisia kanomoꞋa aliꞋya kanotami maino. ");
INSERT INTO kmu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘UhagoteꞋna maigahue.’ huno hisia kanomoꞋa mone oꞋali aliꞋya kanotami maino. ");
INSERT INTO kmu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna vayaꞋmoꞋya naya huꞋya kanaleꞋya hu-na-tesaya yafe omenogi nagaya amaya huꞋna aliꞋya kanoꞋami maisua yafe emainoanagiꞋna mukiꞋa veaꞋmoꞋya kefo yama hageno ai-gagi-ma-tenea yapiti kalu he-ma-tesua miya atalesua yafe faligahe emainoe.” ");
INSERT INTO kmu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya Yeliko kumala ataleꞋya ugahe hageꞋya kasagoꞋya veaꞋmoꞋya amakave umaine. ");
INSERT INTO kmu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","NeꞋvageꞋana tole anaulaga asu hu-mainea kanolamogania kate mopale mainanageꞋya “YisasiꞋa tanakaseno neꞋvie.” haya kea haviteꞋana ala kegefafiti mage huꞋana haꞋe “Anumayamogae, Tevitina aginagomogae, taꞋagaila kahauna hu-laꞋato.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","HaꞋageꞋya umainaya veaꞋmoꞋya kenama-kiꞋya “Ke ohutana maiꞋo.” huꞋya hayanagi nagoꞋene ala kefiti keha keha haꞋe “Anumayamogae, Tevitina aginagomogae, kahauna hulaꞋato.” huꞋana keha keha haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","HaꞋageno YisasiꞋa haviteno aupaꞋa anile heti-maineno “NaꞋa hu-lana-tesue hugetana nehaꞋe?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","HigeꞋana “Museka nehuꞋagi taꞋagaya etetaꞋa taꞋaulaga agesuꞋe hutaꞋa nehuꞋe.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","HaꞋageno YisasiꞋa kalagi ai-na-teno anaulagale aya malegeꞋana aupaꞋa anaulaga neꞋageꞋana Yisasi akave vaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Yelusalemu aupaꞋa uvaꞋyi hugahe Petafasi umainae. Petafasi kumala Olivi yosa hanea agoꞋyamona agegayalega hanegeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagapiti tole kanolana hu-na-teno mage huno hana-paiye “Atu kumate utana aupaꞋa hosi kana afumo agia tokigi ani tokimona itaꞋamoꞋene nafaꞋneꞋaene aye-tenayanagitana agegaꞋe. Agetetana kalu hetana avaletana male eꞋo. ");
INSERT INTO kmu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","NagoꞋa vayaꞋmoꞋyama tanahavi-gesagetana mage hutana hiꞋo ‘Kava kanotimoꞋa nago aliꞋya aligahe higetaꞋa neꞋoꞋe.’ hutana hama-paisaꞋageꞋya aupaꞋa lanamigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hiana ani yupama haya kavala Anumaya Koti aune kanomoꞋa nayoma hu-mainea kemoꞋa agola falote huno tamage hie. Mage huno kae-maleneane ");
INSERT INTO kmu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Yelusalemu veaꞋmogamina mage huka hama-paiyo “Agegeho menia tamakaite kava yagai-lama-tesia kanoa augafa alino ohaino hosi kana afumo agia tokimo nafaꞋnemo agupifi maiteno eneꞋe.” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tole YisasiꞋene tokaeꞋana nemaiꞋa kanolana uꞋana YisasiꞋma hana-paiya kea mo haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ani hosi kana afumo nafaꞋnene itaꞋamoꞋene Yisasitega anavaleꞋana kenaꞋania anaugafaleti hateꞋana ani afumo agupile yakai-malaꞋageno YisasiꞋa anile haino maine. ");
INSERT INTO kmu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Haino maiteno neꞋegeꞋya mukiꞋa veaꞋmoꞋya “Ala kano neꞋe.” huꞋya nagoꞋamoꞋya amaugafaleti kenaꞋamia hateꞋya visia katela yakaiteꞋya yosa akopa kofa huꞋya katela yakai-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","HagoteꞋya vaya veaꞋmoꞋyaene akave aya veaꞋmoꞋyaene mage huꞋya hae “Taugafa ali-gatisana kanoa Teviti aginagomogae kanale ya huka neꞋane. Anumayamo aliꞋya aligahe hanageno hu-ga-tenea kanoa Anumaya KotiꞋa kanale manu kamino kaya hu-maine. Anafinaga mainea Anumaya KotiꞋa taugafa ali-gatisiafe musena hisune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","YisasiꞋa Yelusalemu hai-falegeꞋya anile mainaya veaꞋmoꞋya atali talu nehuꞋya mage hae “Mani kanoa ta neꞋe?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","NehageꞋya alitalu hu-mainaya veaꞋmoꞋya mage huꞋya hae “Mani kanoa Nasaleti YisasiꞋe Kalili kotegati emainea aune kano neꞋe.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","YisasiꞋa ala mono nopi hai-faleno ageana ani nopi mainaya veaꞋmoꞋya monehe ke huꞋya neꞋaliya veaꞋnene afaꞋa miyama nehaya veaꞋnene “Mai haleho.” huno nehuno vayaꞋmoꞋya alu kote nehanea monea neꞋaliꞋya ani kotegama nehanea monea neꞋamamiya veaꞋmogami folamoa ali-talegeno aige helafige hie. Higeno kugofa kana nama miya nehaya veala ani mono nopi mopale mainaya sipa aniꞋa huno ali-talegeno ai-helafi-lavigeno amanati-tale-tene. ");
INSERT INTO kmu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mage huno hie “Anumaya Koti autaꞋmafina mage huno kae-maleneane ‘Nagai nona mukiꞋa veaꞋmoꞋya Anumaya Koti agi ayeꞋya nunamu hisaya no hane.’ huno kae-maleneanagi tamakaya musufa yama nehaya kava hugahe ma nopina emainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","YisasiꞋa ala mono nopi mainegeꞋya nagoꞋa amaulaga asu hu-mainea veaꞋnene amaiya avayu hu-mainea veaꞋnene agaite ageno ani kaliꞋamia alino kanale hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Alino kanale hu-ma-teanagi ala mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene mono nopi mainaya nafaꞋneyagamoꞋya Yisasifena “Teviti nafaꞋnemogae, taugafa ali-gatigahe hu-ga-tenea kanomogae.” huꞋya kema haya kenefena YisasiꞋma kanale auꞋava yama hia yafeꞋene haviꞋya amaipa haviya hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Amaipa haviya huteꞋya Yisasifena mage hae “Kagaya mani kema haya kea havilinano?” huꞋya havigageno YisasiꞋa mage huno hie “E, tamakaya Anumaya Koti avona hapalitama ohavinao? mage hu-maineane ‘Anumaya Kotiga osi nafaꞋneyagaene nute nafaꞋnemogami amavayafitila kagai kagia kanaleꞋya huꞋya alisaga hisayafe hu-ma-tenane.’ huno kae-maleneane.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mani kea huteno ala kumatetila ataleno ani kegela Petani kumate mo faene. ");
INSERT INTO kmu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Faeteno kotigeno Petania neꞋataleno Yelusalemu ugahe neꞋvigeno Yisasina aga-te-maine. ");
INSERT INTO kmu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aga-tegeno ka haigilega nagola fiki yosa hanegeno ageteno ani yosa aepale mogeana alagaꞋa omalegeno haisaꞋage hanegeno mogeteno YisasiꞋa ani yosahe mage huno hie “Namo yosa hetika maiyo. Agola kagai kaugafafitila nagola alaga falote ohisie.” huno higeno aupaꞋa fayo-te-maine. ");
INSERT INTO kmu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","YisasiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ageteꞋya tusiꞋa amamaꞋyo aigeꞋya mage huꞋya hae “NaꞋa higeno ani fiki yosamoꞋa aupaꞋa fayo-nelie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hageno YisasiꞋa mage huno hama-paiye “Lamage huꞋna tamaha-nepauve Anumaya Kotifena tole lamakesa ohavitama ‘MukiꞋa yama hisanana kanalelageka hateꞋasine.’ hutama tamakupi maletama tametiti hisayana fiki yosama hu-toa kavaꞋene nagoꞋa kavaꞋenena hugahae. Ma agoꞋyamofena ‘Kofa hu-lavika ala ti kotumo amuꞋnopi mo hetika maiyo.’ hutama hapaisagenoꞋa ketamia akave maleno ugahie. ");
INSERT INTO kmu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","MukiꞋa yafema ‘Anumaya Kotitega havigesunana kanaleꞋya huno tamigahie.’ hutama tamakupi maletama tamametiti hisayana afaꞋa amamigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","YisasiꞋa ala mono nopi umaineno alitalu huꞋya maiya vayala hu-mave-neligeꞋya mono note kava vayaꞋmoꞋyaene ala vayaꞋene agaitega mage huꞋya me hae “Hana augafa ala kanomo hu-gategeka mani kavala menehane? Tokiya yakaꞋa ta kamine?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Havigageno YisasiꞋa mage huno hie “Nagaya aniꞋa huꞋna nago yafema tamaha-vigesugetamama naha-paisageꞋnahena ala kanomo hu-na-tegeꞋna emainoa kanomo agia tamaha-paigahue. ");
INSERT INTO kmu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","YoniꞋma tima fale-ma-tenea yana Anumaya Koti hu-tegeno ani kavala me-nehifi afa vayaꞋmoꞋya hu-tageno tina me fale-mateneo? Hu-falote hutama naha-paiho.” huno hu-maine. HigeꞋya “NaꞋa maꞋa hugahune.” huꞋya mohu mehu huteꞋya mage hae. “Anumaya Koti hu-tegeno emaine.” huta hisunagenoꞋa YisasiꞋa “NaꞋa higetama agai kea tamakupina nomalae?” huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hugahiafe tagaya “Afa vayaꞋmoꞋya hutageno emaine.” huta hisunageꞋyahena mukiꞋa veaꞋmoꞋya “YoniꞋa Anumaya Koti aune kano maine.” huꞋya ago havimainaya yafe ali haviya hu-la-tegahae huꞋya mohu mehu nehae. ");
INSERT INTO kmu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","HuteꞋya Yisasifena kenonaꞋa mage huꞋya hae “Tapiga hu-tene? Tagaya ohavinone.” huꞋya hageno YisasiꞋa mage huno hama-paiye “Nagaya aniꞋa huꞋna hana kanomo hu-na-tegeꞋna emainoe huꞋna tamaha-opaigahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na tamakesa nehaviye? Nago kanomoꞋa tole neꞋnafaꞋneꞋa mainaꞋanagino neꞋanafaꞋa hagote nafaꞋneꞋahe mage huno mo hie “NafaꞋneꞋnimogae meni yupa nofi alagamo hoyafi aliꞋyana molio.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Higeno nafaꞋneꞋamoꞋa mage huno hie “OꞋugahue.” huno huteno haenagaꞋa agu ai-yahae huno aliꞋyana moli-maine. ");
INSERT INTO kmu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","NeꞋanafaꞋa haenaga nafaꞋneꞋahena ani ke huno hapaigeno mage huno hie “Nagaya moligahue.” huno huteno oꞋune. ");
INSERT INTO kmu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hana nafaꞋnemo nefa kea ali hipoꞋya hu-maine? huno hama-vi-gegeꞋya “Hagote nafaꞋnemoꞋe.” huꞋya hageno YisasiꞋa mage huno hie “Tamage-lafa huꞋna tamaha-nepauve musufayama nehuꞋya vaya amaugafaleti takesi mone ali-liteꞋya nehaya vayaꞋene moli hu-liteꞋya nehaya aꞋneyagaene hagoteꞋya tamakaseꞋya Anumaya Kotifena ‘Kava yagai-lato.’ huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","YoniꞋa hu-haleno huno fatago hutama maisaya kaana tamave-lianagi tamakaya agai kea havitama tamakupi maletama tamametitia ohunagi musufayama nehuꞋya vaya amaugafaleti takisi mone ali-liteꞋya nehaya vayaꞋene moli hu-liteꞋya nehaya aꞋnene Yoni kea haviꞋya amakupina malenae. Amakupi malagetama tamakaya agetetama haenagaꞋa kefo yatamihena tamaipa aiyahae hutama tamakuꞋa oꞋamitama agai kea tamakupina omalenae.” ");
INSERT INTO kmu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","YisasiꞋa “Nagola avame kea haviho.” huno mage huno hama-paiye Nago kanomoꞋa vaini nofi alagamo hoya kali-maleteno kegiꞋya hu-gove hu-maleteno ani alagayagama vaiteno aye-latigeno timaꞋamoꞋma lavisia komua kafiteno yagainoꞋma nemaiya nona anafi ki-maleteno noꞋagea vayafe “Etama hoyaꞋnifina yagaitama maineho. Ani nofiꞋmo alagafitila ali fako hutama nagoꞋa aliho.” huno hu-ma-teteno alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Umainegeno afuma nelea kanafina ani hoyamona nefaꞋa nagoꞋa aliꞋya vayala hu-ma-tegeꞋya kava vayatega nagoꞋa vaini nofi alaga aligahe umainae. ");
INSERT INTO kmu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","VageꞋya hoyale kava vayaꞋmoꞋya ani vayala amatafa huꞋya nago kanoa kaꞋyo amiteꞋya nago kanomona tavata haeteꞋya nago kanomona yafa kaꞋyoteti hae-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","HamayageꞋya utageno hoyamona nefaꞋa eteno nagoꞋa kasagoꞋya aliꞋya vayaꞋa hu-ma-tegeꞋya vayana hoyaleꞋma kava yagai-mainaya vayaꞋmoꞋya ani kavakeꞋya hu-ma-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hu-ma-tageno hoyamona nefaꞋa eteno agaiꞋa nafaꞋnea hu-tegahe mage huno hie “NafaꞋneꞋnimo kea havigahae.” huno hu-teno hu-tegeno ani hoyalega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","VigeꞋya ani hoyafima kava vayaꞋmoꞋya ageteꞋya mage huꞋya hae “Mamona mani hoyamona nefa nafaꞋne. NefaꞋma falisigenofena mani nafaꞋnemoꞋa hoyaꞋa aligahianagita agaila ago haegetao. Haesunageno falisigeno mani hoya tagai ya hapaegahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","HuteꞋya avaleꞋya hoyafinagatila ai-halatu huꞋya malaga hagaꞋyu hu-taleteꞋya haeyageno fali-maine huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","41","Huteno mage hie “NaꞋa hayanagi hoyamona nefaꞋa naꞋa hu-ma-tegahie?” huno hama-vigegeꞋya mage huꞋya hae “Eteno hoyaꞋafima kava yagai-mainaya vayala tavata me-hamaesigeꞋya faligahae. Fali haꞋno hisageno alu vayafe ‘HoyaꞋnifina kava me yagaiho.’ huno hugahie.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hageno YisasiꞋa mage huno hama-paiye ani yafena Anumaya Koti avopina ago hapali-mainao? Mage huno hu-maineane “VayaꞋmoꞋya yafa noma kigahena nago yafafena ‘Haviya hu-maine.’ huꞋya atalenayanagi haenagaꞋa ani yafamofena ‘TusiꞋa kanale yafane.’ huꞋya nomo aye-tagenale malenae. AnumayamoꞋa ani avamete hu-mainegeta ageteta tusiꞋa kanaleꞋyanagino tamaꞋyo aiya kava nehie huta nehune.” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Kae-malenegi mukiꞋa veamoꞋya ani yafateꞋma asaga hu-lavisayana amaugafamoꞋa atalaga huno haviya hu-lavigahianagi ani yafamoꞋa vaya amaugafaleꞋma asaga hu-lavisiana ai-latapeno ai-talaga talago hu-talegahie. NaꞋa huyafe tamaha-nepauve Anumaya Koti kava yagai-mainea yana tamayapitila tamaha-faleno alu veaꞋmogami amayapi malegahie. Kanale alagaꞋma ayesaya veaꞋmogami amayapi malegahie huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","HigeꞋya mono note kava vayaꞋene Falasia vayaꞋene haviteꞋya “Tagaife mani avame kea nehie.” huꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","HaviteꞋya “Menia avaleta kina nopi ategahune.” huꞋya hayanagi veaꞋmoꞋya Yisasife “Aune kano maine.” huꞋya haya yafe vaya amauhe koli huꞋya atalenae. ");
INSERT INTO kmu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","YisasiꞋa nagoꞋene mukiꞋa vayafe avame kea mage huno hie Anumaya Koti kava yagai-mainea kumate maꞋa hu-maine nagola sauve kanomoꞋa agaiꞋa nafaꞋnemoꞋa a aligahe higeno nefaꞋa ala kave talo tala hugahe hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","AgaiꞋa aliꞋya vayala hu-ma-tegahe mage huno hie “Kema hu-ma-tenoa vayatega utama hama-paisageꞋya ani imuma ki-maloa kavela me nesae.” huno hu-ma-tegeꞋya uꞋya mo hama-paiyana ani vayaꞋmoꞋya imulena omesaya ke hae. ");
INSERT INTO kmu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hageno eteno nagoꞋene alu aliꞋya vayaꞋa hu-ma-teno mage huno “Tamakaya utama kema hu-ma-toa veafe mage hutama hama-paiho Tamakaya haviho nagaya ve pulamakaene tali oꞋvai afuꞋniene ago heꞋna mukiꞋa yana ago talo tala hu-malenogi tamakaya a alisia imule eho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","HigeꞋya ani aliꞋya vayala uꞋya mani kea mo hama-paiyanagi ani veaꞋmoꞋya ohavisaya ke huꞋya ataleꞋya vageꞋya nagoꞋa veala hoyaꞋamilega vageꞋya nagoꞋa veala mone aliꞋyaꞋamile vageꞋya nagoꞋa vayaꞋmoꞋya ani aliꞋya vayala amatafa huꞋya hamayageꞋya fali-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","NaꞋa hageno sauve kanomo aipamoꞋa haviya higeno agaiꞋa ati vayaꞋa hu-ma-tegeꞋya uꞋya mo hamaeꞋya haꞋno hu-taleteꞋya no kumaꞋamia kaeꞋya haꞋno hu-talenae. ");
INSERT INTO kmu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hu-talageno ala sauve kanomoꞋa aliꞋya vayaꞋahena mage huno hama-paiye “A alisia imua ago kiꞋna talo tala hu-malogi ‘Eho.’ huꞋnama hu-ma-toa veala amakaiꞋamia kanale huꞋya omesaya avamete hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","NaꞋa hu-mainagi tamakaya kamo avayaleꞋma momakesaya veafena ‘A alisia imule eho.’ hutama hiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","HigeꞋya aliꞋya vayaꞋmoꞋya anima katega momakaya veala haviya hu-mainaya veaꞋnene kanale veaꞋnene amavaleꞋya melitalu hageno mukiꞋa sauve kanomo nafaꞋnemoꞋma aꞋma alisia imulela ani nopina me hiya hae. ");
INSERT INTO kmu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hageno sauve kanomoꞋa amakegahe ani nopi haino mogeana nago kanomoꞋa aꞋma alisia kanaleꞋma fai-neꞋaliya augafa kena fai-oꞋalinegeno moge-maine. ");
INSERT INTO kmu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mogeteno ani kenama fai-oꞋalinea kanohena mage hie “Nenafugae naꞋa higeka a alisia kanaleꞋma nefaiya kena ofaika ma nopina emainane?” huno havigegeno ani kanomoꞋa kea ohuno maine. ");
INSERT INTO kmu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","AfaꞋa maigeno sauve kanomoꞋa agaiꞋa aliꞋya vayafe mage huno hama-paiye “Aiya ayate nofi kitetama asaga hutama haniꞋyapinaga malaga hagaꞋyu hu-talegeno avi-neꞋateno avekemo nehinageno agaiꞋa augafahe kalagi aino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Anumaya KotiꞋa kasagoꞋya veafe kea hianagi mukiꞋa veala omageꞋya nagoke nagoke huyo-gi-malenea veaꞋneꞋage ehai-nefalae. ");
INSERT INTO kmu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falasia vayaꞋmoꞋya neꞋuꞋya “HanaꞋa huta YisasiꞋma hisia keletila atafa hisune?” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","HuteꞋya keꞋamima nehaviya vayaꞋene Heloti vayaꞋene Yisasite hu-ma-tageꞋya ani vayaꞋmoꞋya mage huꞋya mo hae “Humave-nelina kanomogae tagaya havunana kagaya tamageꞋage kano mainane. Kava vayaꞋene afa vayaꞋenefena kagesa ohavika nagoke kate tamagegeꞋya nehuka Anumaya Koti kea hama-nepainane. ");
INSERT INTO kmu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nagi takisi he yatela kava kanoa Sisana kanale amigahuno ifi oꞋamisune? Na kagesa nehavipi? Taha-paiyo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hageno YisasiꞋa havi kavaꞋma hisaya amaku amakesa ago amaketeno “Vagala vaya mainagi amegati afa ke nehae. NaꞋa higetama nagaila aye-navataga hutama natafa hisaya yafena nahavi-negae? ");
INSERT INTO kmu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nagola takisima nehaya alaga monea alitama naveliho.” huno higeꞋya aliꞋya ave-li-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aveligeno mage huno hie “Mani alaga monelela ta augosaene ta agiene hane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","HigeꞋya “Sisa augosaene agiene hane.” huꞋya hae. Hageno YisasiꞋa mage hie “Sisana agaiꞋa yanagi agaila amiho. Nagi Anumaya Kotina agaiꞋa yana agaila amiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","HigeꞋya anima kesi kateꞋma vaiyaya vayaꞋmoꞋya anima hia kehena amamaꞋyo aigeꞋya ataleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ani kanafina nagoꞋa Satiusi vayaꞋmoꞋya* Yisasitega emainae. Ani Satiusi vayaꞋmoꞋya mage nehaya vayale “Fali-mainaya vayala eteꞋya he-otigahae.” huꞋya nehaya vayale. ");
INSERT INTO kmu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","VayalegiꞋya Yisasina mage huꞋya me havigae “Humave-nelina kanomogae MoseseꞋa mage huno hu-maineane ‘Nago kanomoꞋa nafaꞋnema oꞋate kanomoꞋa aꞋama ataleno falisigenoꞋa aganaꞋamoꞋa ani aala ali-tesigeno fali-mainea kanomofe huno anonaꞋa nafaꞋnea atesie.’ huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","SeveniꞋa (7) koganamoꞋya tagaipina mainayanagino nepuꞋamimoꞋa aala ali-teneanagino nafaꞋnea oꞋate kano maineno faligeno anile aganaꞋamoꞋa aꞋamona ali-tene. ");
INSERT INTO kmu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ali-teanagi nafaꞋnea oꞋate kano maineno faligeno anile aganaꞋamoꞋa eteno ali-tene. AniꞋa hute hute hayanagi mukiꞋa seveniꞋa (7) konagamoꞋya ani aala ali-tayanagi nafaꞋneꞋamia oꞋateꞋya afaꞋa fali-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Faltageno haenagalafa ani aala fali-maine. ");
INSERT INTO kmu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","SeveniꞋa (7) konagamoꞋya ani aala ali-tenayanagiꞋya fali-mainesafitiꞋma hetisaya kanafina hana kanomo ani aala alikahie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Havigageno YisasiꞋa mage huno hama-paiye Anumaya Koti kema kae-malenaya kene tokiya yamaꞋaenefena havilama hutama ohaviya yafe tamakaya havi lamakesageꞋya nehaviye. ");
INSERT INTO kmu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","VeaꞋmoꞋya fali-mainesafitiꞋma hetisaya kanafina nago vemoꞋa aꞋnea oꞋaligahianagi aꞋmoꞋa venena oꞋaligahie. Ensole vaya kana huꞋya maigahae. ");
INSERT INTO kmu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Fali-mainaya veaꞋma he-ti-saya kea Anumaya KotiꞋa tamakaifema hu-mainea kea avopina mage huno hu-mainea kea hapalitama ohavinao? ");
INSERT INTO kmu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mage huno hu-maine “Nagaya Anumaya KotiꞋna Apalahamunagi Aisakinagi Yekopugami Anumaya KotiꞋami mainoe.” huno hu-maineane. Ani anagala fali-mainayanagi “Anumaya KotiꞋamimoꞋna mainoe.” huno hu-maineafe amaku amamemoꞋa ofalinegi afaꞋa mainae huno mani kea hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","HigeꞋya melitalu hu-mainaya veaꞋmoꞋya haviteꞋya anima hia kehena amamaꞋyo ai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","YisasiꞋma hia kehena Satiusi vayaꞋmoꞋya kea ohuꞋya maiya yafe Falasia vayaꞋmoꞋya haviteꞋya Yisasite melitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Maiya vayaꞋmogami amuꞋnopina nagola kahegi kema havilinea kanomoꞋa Yisasina aye-vataga hugahe mage huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Hu-lave-nelina kanomogae hana kahegi kemo mukiꞋa kahegi kemona amakaseno uhagoteno tokiyaꞋage kea hane?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Havigegeno YisasiꞋa mage hie “Anumaya KotiꞋa alakamofena tusiya huno kahaino. KaguꞋafinagatiꞋene kagu kametetiꞋene kahaino. AliꞋyama neꞋalina himamukaene kagesama nehavina yaꞋenena ami haꞋno huka amio. ");
INSERT INTO kmu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mani kemoꞋa uhagoteno amakase-mainea ke hane. ");
INSERT INTO kmu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","AnileꞋma molia kemoꞋa ani kemoꞋma hia avamete hu-mainea kemoꞋa mage huno hu-maine ‘KagaikaꞋa kaugafahema kahaisia avamete mukiꞋa veaꞋmogami amaugafahena kahaino.’ huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","MukiꞋa Anumaya Koti amaune vayaꞋmogami kene Mosese kemoꞋenena ani tole kefi aepaꞋa hane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Falasia vayala melitalu hageno YisasiꞋa mage huno hama-vige “Kalaisifena naꞋane tamakesa nehaviye? Ta nafaꞋne maine?” huno higeꞋya “Teviti nafaꞋne maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hageno “NaꞋa higeno TevitiꞋa AvamuꞋmo hapaiya ke huno Kalaisifena ‘Anumayanimogae.’ hunoꞋma hu-maineana ani kemo aepaꞋahena naꞋane hutama nehae? TevitiꞋa mage huno hu-maineane ");
INSERT INTO kmu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Anumaya KotiꞋa Anumayanimofena mage huno hie ‘Tamaga nayatega, ala vaya mainalega hanea siale emainesanageꞋna kame vayakaꞋa kaiyafinaga ama-tesugeꞋya kagaifena ‘Ago tagasane.’ huꞋya hugahae.’ huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","TevitiꞋa Kalaisifena ‘AnumayaniꞋa mainane.’ huno hu-maineanagi naꞋa higeno TevitiꞋa haenagama atesia aginagomofena ‘AnumayaniꞋa mainane.’ huno hu-maineane?” huno hama-vi-ge. ");
INSERT INTO kmu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hama-vi-geanagi nago kanomoꞋa kenonaꞋa nago kea ohunegi ani kanaleti aepa heꞋya koliꞋa huꞋya nago yafena haviokenae. ");
INSERT INTO kmu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","YisasiꞋa melitaluma hu-maiya vayafeꞋene agaiꞋaenema tokaiꞋya nemaiya anagafeꞋenena mage huno hie kahegi kema havilinaya anagaꞋene Falasia vayaꞋene Mosese kea huge hama-velige nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nehayanagi tamaha-paiya kea akave malegahayanagi kefo yama nehaya kavaꞋamia tamakaveꞋno hu-teho. Amakaya ala kenakea nehayanagi amakaiꞋamima haya kemona akave nomalae. ");
INSERT INTO kmu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Kahegi kea akave maleho.” huꞋya mukiꞋa veaꞋmogamina kanaꞋage yakefa amayoꞋnalela nemaleꞋya nehagi amaya hugahena nagoꞋke amakinagoa maleꞋya amaya ohageꞋya tusiꞋa kana yakefa neꞋaliye. ");
INSERT INTO kmu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","MukiꞋama nehaya kavaꞋamia “VeaꞋmoꞋya tagesae.” huꞋya Anumayamo kae-malenea kea hanea keꞋayola veaꞋmoꞋya agesayafe ala keꞋayola talo huꞋya yagamusago kana huꞋya hamanile ko nefiꞋya kena atupaꞋamile ayaꞋaya konagali nofila aye-maleneꞋya hu-neꞋaliyane. ");
INSERT INTO kmu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","NehuꞋya mono nopiꞋene imuleꞋene “Ala vayaꞋage nemaiya siale maigahune.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Vaya atagu-nefaya kumapi mo-vaiyatete nehuꞋya “NaꞋa vaya mainae huꞋya ali falu fala hu-la-tesae.” huꞋya nehayane. ");
INSERT INTO kmu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nehayanagi nagaya tamakaifena “Ala tisa kanomogae.” huꞋya ohiho. Tamakaila nagoke huge lama-ve-lige hisia kanotami nagaya mainogi tamakaya nagoke avamete mainetama nagoke konaga kana maiho. ");
INSERT INTO kmu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma mopafi mainetama nago kanomofena “NelafaꞋe.” hutama ohiho. Tamakai NelamafaꞋa nagoke ikapinaga maine. ");
INSERT INTO kmu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tamakaifena nagoꞋa veaꞋmoꞋya “Kava kanotimogae.” huꞋya ohiho. KalaisiꞋa agaiꞋage kava kanotamia maine. ");
INSERT INTO kmu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","TusiꞋa ala kanoa tamakaipima mainesiana aliꞋya kanotami kana huno maino. ");
INSERT INTO kmu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","NagoꞋa veaꞋmoꞋya amakaiꞋami amaugafama aliꞋya haisagenoꞋa Anumaya KotiꞋa “Osi kano maiyo.” huno hu-tegahianagi nagoꞋa veaꞋmoꞋya “Osi kano mainoe.” huno hisigenofena Anumaya KotiꞋa agia alisaga huno anale malegahie huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","AvoꞋnio kahegi kema havilinaya anagaꞋmogatamaene Falisia vayaꞋmogatamaenena vagala vayalagi kaꞋye ho. Anumaya KotiꞋa kava yagai-mainea yapi veaꞋmoꞋya ugahe nehayanagi “OꞋviho.” hutama katile-neꞋamatae. Tamakaya “Ani nopi ohaigahune.” hutama haleti nagoꞋa veaꞋmoꞋya “Hai falegahune.” huꞋya haya veaꞋmogamifena “Hai-ofalegahae.” hutama katile-neꞋamatae. ");
INSERT INTO kmu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","AvoꞋnio kahegi kema havilinaya anagaꞋmogatamaene Falasia vayaꞋmogatamaenena vagala vayalagi kaꞋye ho. Tamakaya hagelimo agegayalegaene mopafiꞋene vai-neꞋayetama “Nagoke kanomo Yuta vayaꞋmogati mono kea havisie.” hutama huge ave-lige nehayanagi kefo yafe hu-ve-nelitama havi kapi avaletama atageno tamakayama haya kavala tamakaila tamakaseno tusiꞋa kefo yana nehianagino hani yapi tegelege nehia atafi tamakaiꞋene ugahie. ");
INSERT INTO kmu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","AvoꞋnio tamakaila tamaulaga asu hu-mainegetama veafena “Kaana tamave-ligahune.” hutama nehaya vayaꞋmogatama kaꞋye ho. Mage hutama nehae “NagoꞋa veaꞋmoꞋya ‘Ala mono nomo agile hu-lokiya vaiꞋna tamagelafa nehue.’ hunoꞋma hisiana ‘Afa ke kana hu-maine.’ hutama hu-mainagi nagoꞋa veaꞋmoꞋya ‘Ani mono nopima kanileta yafatetiꞋma talo hu-malenaya yamo agile hu-lokiya vaiꞋna tamagelafa nehue.’ hunoꞋma hisiana ani kema hisia kanomoꞋa hia kea hu-lama huno hino.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tamakaila tamaulagamoꞋa asu hu-mainegetama aifoꞋnafo vaya mainae. Na yamo ala yana hane? Ani kanileta yafateti talo hu-malenaya yano? Ifi ani mono nomoꞋa ala yakefa haneo? AꞋao anima kanileta yafateti talo hu-malenaya yana mono nopinaga malenaya yafekeꞋya alu aotage yana hane. NaꞋa hu-maineafe mono nomoꞋa agaseno ala yakefa hane. ");
INSERT INTO kmu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tamakaya mage hutama nehae “NagoꞋa veaꞋmoꞋya ‘Mono nopi sipi sipi heꞋya nemalaya folamo* hanea yate agi ayeꞋna hu-lokiya vaiꞋna tamagelafa nehue.’ huno hisiana afa ya kana ke nehigi hesaya yafe folamole nemalaya sipi sipihena nagoꞋa veaꞋmoꞋya ‘Agi ayeꞋna tamagelafa hu-lokiya vaiꞋna nehue.’ huno hisia kemona ani veaꞋmoꞋya hu-mainesaya kemona akave maleꞋya hiho.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nehayanagi tamaulaga asu hu-mainea vea mainae. Na yamo ala yana hane? Anumaya Kotina sipi sipi amisaya yano ifi muse yama nemalaya folamoa ala yane? E, folamoa ala ya hane. NagoꞋa sipi sipia ani folamole nemalayafe alu aotage sipi sipi haneanagino folamoa tusiꞋa ala yane. ");
INSERT INTO kmu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","NagoꞋa veaꞋmoꞋya “Folamomo agi neꞋayone.” huꞋya hisaya veaꞋmoꞋya mukiꞋa yama ani folamoleꞋma nemalaya yafeꞋene nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","NagoꞋa veaꞋmoꞋya “Ala mono nomo agi ayeꞋna hu-lokiya vaiꞋna tamagelafa nehue.” huꞋyama hisayana ani mono nomofeꞋene ani nopima mainea Anumaya KotifeꞋene nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","NagoꞋa veaꞋmoꞋya “Ikamo agile hu-lokiya vaiꞋna tamagelafa nehue.” huꞋyama hisayana Anumaya Kotina siaꞋaene ani yateꞋma mainea kanomofeꞋene nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","AvoꞋnio kahegi kema havilinaya anagaꞋmogatamaene Falasia vayaꞋmogatamaene vagala vayalagi kaꞋye ho. Tamakaya supu tala yaꞋene atuꞋene hefi kana yaꞋene osi osi yana alitama teniꞋa (10) haꞋya malenafiti nagoke haꞋya Anumaya Kotina neꞋamiyanagi kahegi kefina ala yamona aepaꞋa neꞋatalae. Fatago hutama kaiyeke hu-matesaya yaꞋene kayone hutama maisaya yaꞋene Anumaya Kotife havitama lamakupi maletama tamametiti hisaya yaꞋene ago neꞋatalae. Hagotetama ani aepaꞋa hanea kea hutetama anile supu tala yaꞋene atuꞋene hefi kana yaꞋene alitama teniꞋa (10) haꞋya malenafiti nagoke haꞋya Anumaya Kotima amisayana kanaleꞋya hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tamaulaga asu hu-mai veala “Nakave eho.” hutama nehaya veaꞋmogatama tamakaya mage nehae “Osi osi havigafa nesuna tipina maineanagita onegahune.” hutama neꞋatalayanagi ala hosia nesaya tipina mainegetama netama nenakaiye. ");
INSERT INTO kmu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","AvoꞋnio kahegi kema havilinaya anagaꞋmogatamaene Falasia vayaꞋmogatamaene vagala vayalagi kaꞋye ho. Amega lamaugafale kava hutama masutamiene yopatamiene amega kaiyagaꞋa sese nehayanagi tamakupinaga musufa yama nehaya yaꞋene tamaugafa age lama-haꞋye nehaya yatamiene hiya hu-lama-teneanagi sesela nohae. ");
INSERT INTO kmu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","TamaulagamoꞋa asu hu-mainea Falasia vayaꞋmogatama hagotetama ti kemo ayopinagaene yopamo ayopinagaene seseꞋma hisayana amega kaiyagaenena oniꞋyaꞋagela ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","AvoꞋnio kahegi kema havilinaya anagaꞋmogatamaene Falasia vayaꞋmogatamaene vagala vayalagi kaꞋye ho. Tamakaya maꞋa nehae vaya komuleꞋma mopama ayeꞋya ali-masave huꞋya ali konagali hu-malayanagi ani komufinaga vayala kasaligeno ayamufama ali yogita huno havi yama hu-lavia avamete kava nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nehayanagi tamakayaenena ani kavakeꞋya hutama mainae. VeaꞋmoꞋya amega tamaugafale nelamakeꞋya “Fatago veaꞋne mainae.” huꞋya nehayanagi tamakupinaga havigema nehaya yatamiene kefo yama nehaya yatamiene kasago hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","AvoꞋnio kahegi kema havilinaya anagaꞋmogatamaene Falasia vayaꞋmogatamaene vagala vayalagi kaꞋye ho. Anumaya Koti amaune vayaꞋene fatago kavaꞋma hu-mainaya veaꞋnenema faligeꞋya he-vai-ma-tenaya komulega tamakaya kanagune hu-maletama mainae. ");
INSERT INTO kmu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mainetama mage hutama nehae “Tagaya tototimoꞋya mainaya kanafima mainoteꞋasina Anumaya Koti amaune vayala hamaonageꞋya ofalileꞋasine.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ani kema nehaya kemoꞋa “Amaune vayala hamayageꞋya fali-mainaya vayaꞋmogami nafaꞋneꞋamimogata mainone.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nehayanagi tamakinagomoꞋya kefo yama hu-mainaya kavala tamakaya nagoꞋene hisageno hiya hisie. ");
INSERT INTO kmu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tamakaya osifaꞋvemogatamae. OsifaꞋveyagamo nafaꞋnemogatama Anumaya KotiꞋa “Hanimo aguꞋafi agola tamakata aisia kumate umaiho.” huno kaiyekema hu-lama-tesiana hanaꞋa hutama faletama ugahae? ");
INSERT INTO kmu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ani yafe nagaya amaune vayaꞋene havi haviꞋyaꞋami hanea vayaꞋene hu-lama-ve-neliya vayaꞋene tamakaiteꞋma hu-ma-tesugeꞋya esagetamahena nagoꞋamogamina yafaga yosale nili hetama asaisageꞋya faligahae. NagoꞋamogamina mono nopinaga hegi kaꞋyoteti hamaetama ali-haviya hu-matesageꞋya alu kumate kumate faleꞋya ugahae. ");
INSERT INTO kmu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","HamaesageꞋya falisaya yafe ma mopafina mukiꞋa fatago veaꞋmogamina ago hamayageꞋya fali-mainaya kolamoꞋa EvoloꞋa kefo yana ohunea kanoꞋagi hagoteꞋya hayageno falitegeꞋya nagoꞋa hamaeme hamaeme ageno haꞋno higeꞋya haenagalafa Pelakia nafaꞋnea Sekalaiyana ala mono nomo kegiꞋyamo amuꞋnopi yafa folamole heti-mainegeꞋya hayageno fali-mainegi tamakaya menima mainaya veaꞋmogatama agoꞋma hu-mainaya kefo yamo anonaꞋamia aligahae. ");
INSERT INTO kmu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tamage huꞋna tamaha-nepauve ago hamayageꞋya fali-mainagi tamakaya menima mainaya veaꞋmogatama agoꞋma hu-mainaya kefo yamo anonaꞋamia tamakaya aligahae. ");
INSERT INTO kmu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Vaeha Yelusalemu mainaya veaꞋmogatama tamakaya Anumaya Koti amaune vayala nehamaetama Anumaya Koti hu-ma-tegeꞋya tamakaitega aya vayala yafa kaꞋyoteti tavata hamae-mainagi nagaya mukiꞋa yupa a kokolemoꞋma nafaꞋneꞋama agekoꞋnafinaga alitaluma nehia avamete huꞋna tamakaila nagaya nagaiꞋniꞋalega alitalu hu-lama-tegahe nehugetama tamakaya “AniꞋa kavala ohuo.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Nehagi haviho na ma mainaya kumafena Anumaya KotiꞋa ago neꞋataleno “AoteꞋyamaꞋae.” huno hu-maineanagitama menia nagoꞋene onagegahagi “Anumayamo aliꞋya aligahe higeno hu-tenea kanoa Anumaya KotiꞋa kanale manua amisie.” huꞋya hisaya kanafina nagoꞋene nagaila nagegahae huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","YisasiꞋa ala mono nona neꞋataleno vigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ayaꞋamoꞋya ala mono noꞋyaga ave-liye. ");
INSERT INTO kmu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ave-ligeno YisasiꞋa mage huno hie “Tamakaya mukiꞋa ma noꞋyaga neꞋagao? Tamage huꞋna tamaha-nepauve ani nomo yafaꞋyaga mukiꞋa alino lagape ai-talesigeno aposi-lavigeno nago yafamoꞋa nago yafamo agupifina ai-kalo huno omaigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","YisasiꞋa Olivi yosa hanea agoꞋyamo agegayalega haino mopale mainegeꞋya agaiꞋaenema tokaeꞋya nemaiya anagala amakaiꞋamige mage huꞋya me hae “Na kanafi ani yamoꞋa falote hugahie? Hana augafa tokiya avame yamo esana kanaene ma mopama haꞋno hisia kanaene faloteꞋma hisia yana taveligahie?” huꞋya havigae ");
INSERT INTO kmu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hageno YisasiꞋa mage huno hie NagoꞋa veaꞋmoꞋya havigema tamaha-paisagetama ohavisaya yafe kaꞋye ho. ");
INSERT INTO kmu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","KasagoꞋya vayaꞋmoꞋya nagai nagi ayeꞋya nagoke nagokeꞋmoꞋya “Tamaugafa ali-gatisua yafe Anumaya KotiꞋa hu-na-tegeꞋna neꞋue.” huꞋya hisageꞋya kasagoꞋya veaꞋmoꞋya amakai kea haviteꞋya amakave malegahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Malegahagi “NagoꞋa kotega kame nehae. NagoꞋa kotega tu hugahe nehae.” huꞋya tamaha-paisagetamahena kolia ohiho. Ani yaꞋyagamoꞋa hagoteno falote hugahianagi ma mopama haꞋno hisia kanamoꞋa aupaꞋa huno falote ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","NagoꞋa vayaꞋmoꞋya alu vayaꞋenena kamea hugahae. Ala kotega vayaꞋene nago ala kotega vayaꞋene kamea hugahae. KasagoꞋya alu kote kotega tusiꞋa kafu nehuꞋya amakatesia kanaene falote hisigeno tusiꞋa imila aligahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ani yaꞋyagamoꞋa afaꞋa aꞋnemoꞋya nafaꞋnema ategahe hageno aepa heno agatama neꞋaiya avamete kava hugahianagi haenagaꞋa tusiꞋa tamakata aisia yana falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tamakaya nakaveꞋma neꞋaya yafe tamatafa huꞋya ali haviya hu-lama-teteꞋya tama-haesagetama faligahae. Nagima neꞋayaya yateti kasagoꞋya vayaꞋmoꞋya amaipa kafa he-lama-tegahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Amaipa kafa he-lama-tesaya yateti kasagoꞋya veaꞋmoꞋya nagaifena haviꞋya amakupi maleꞋya amametitima nehaya yana ataleꞋya nagoꞋa veala amakesi huꞋya amaipa kafa he-lama-tegahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","KasagoꞋya havige amaune vayaꞋmoꞋya havige hisageꞋya kasagoꞋya veaꞋmoꞋya amakai kea haviteꞋya amakave malegahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kefo yama nehaya yamoꞋma ala hisigeno nagoꞋa veaꞋmoꞋya nagoꞋamimogamifema hamau amayamopafi nehamaiya yamoꞋa osi hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Osi hugahigi nagoꞋa veaꞋmoꞋya nagai kema atafa huꞋya tokiyaꞋage hume humema visageꞋnahena nagaya eteꞋnama esua kanafina nagai kema atafa hu-linesaya veaꞋmogamina Anumaya KotiꞋa amaku amamena ali-gatigahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anumaya KotiꞋma kava yagai-mainea yafe kanale mono kea mukiꞋa ma mopafi veaꞋmogamina hama-paisageꞋya havitesageno ma mopamoꞋa haꞋno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","YisasiꞋa mage huno hie nayoma mainea aune kanoa TanioloꞋa tusi havi yana, ma mopa alino hagagitalesia yamoꞋa tamaꞋyo aisia kava falote hisia yafe taha-pai-maine. Anima hu-mainea kema hapalitama havisamogatama havilama hiho. Ani yamoꞋa alu aotage yapi he-ti-mainesigetama agegahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Agenutamahena Yutia mainesaya veaꞋmogatama tamaiyayetama agoꞋyalega faletama viho. ");
INSERT INTO kmu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","NagoꞋa veaꞋmoꞋya nogatofule haiꞋya mainesaletila afenoꞋyaꞋamima alisaya yafena eteꞋya nopinaga ohaiho. ");
INSERT INTO kmu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","NagoꞋa veamoꞋya hoyafinaga mainesaletila eteꞋya kenaꞋamima alisaya yafena notega oꞋviho. ");
INSERT INTO kmu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","AvoꞋnio ani kanafina amaipaene aꞋnene nute ani-linesaya nafaꞋnemogami itaꞋamimoꞋyaenefena tusiꞋa nahau nehie. ");
INSERT INTO kmu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nehigi nunamuna mage hutama havigeho “Tani koꞋma tisia ikateꞋene Sapati yupaenena ani yamoꞋa falote ohinageta faleta oꞋvisune.” hutama havigeho. ");
INSERT INTO kmu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ani kanafina tusiꞋa kana yamo falote hugahie. EheꞋma Anumaya KotiꞋa ma mopama taloma hu-malenea kanaletiꞋene meni kanafiꞋene ani avamete ala kana yamoꞋa falote ohuneane. Falote ohuneanagi tusiꞋa kana yamo ala hutesigeno haenagaꞋa aniꞋa huno falote ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anumaya KotiꞋa ani havi kanama alino aupa hu-malene. AniꞋama ohileꞋasina mukiꞋa veaꞋmoꞋya falileꞋasinagi. Anumaya KotiꞋa haigenoꞋma hapali-ma-tenea veafe agesa havino amaugafama ali-gatisia yafe ani kanaꞋa alino aupa hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ani kanafina nagoꞋa veaꞋmoꞋya mage huꞋya hugahae “Anumaya KotiꞋma taugafa aligatigahie huno hutenea kanoa ma mainegi ageho. Atu mainegi ageho.” huꞋyama hisagetamahena “Tamage nehae.” hutama tamametitia ohiho. ");
INSERT INTO kmu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ani kanafina nagoꞋa havigeꞋage amaune vayaꞋene “Nagaya Anumaya KotiꞋa tamaugafa aligatigahie huno hu-na-tenea kano mainoe.” huꞋya havigema hisaya vayaꞋenena evaꞋyi huꞋya veaꞋmogamina aye-mavataga hugahe tokiyaꞋage avame yana hugahayanagi Anumaya KotiꞋa haꞋye higeno hapali-ma-tenea veaꞋmoꞋya ani kea ohavigahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tamage ani yana falote ohunaya kanafi mani kea ago tamaha-paugi haviho. ");
INSERT INTO kmu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","NagoꞋa veaꞋmoꞋya “Ani kanoa kaꞋme kotega maine.” huꞋya hisagetamahena oꞋviho. “Nopinaga maine.” huꞋyama hisagetamahena ani kea havitama tamametitia ohiho. ");
INSERT INTO kmu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna eteꞋna esua yamoꞋa maꞋa hugahie yagema vaꞋyi nehilegati aulumaya kotino aupaꞋa mukiꞋa kotega ai-vasa nehia avamete huꞋna nagaya eteꞋna egahue. ");
INSERT INTO kmu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Afuma fali-mainea kefafima hakikimoꞋya yage yage huꞋya alitaluma nehaya avamete huꞋna ikapinagati emainoa kanomoꞋna mukiꞋa veaꞋmogami amuꞋnopi egahue. ");
INSERT INTO kmu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ani havi kanamoꞋma haꞋno hisigenoꞋa yagemoꞋa hani-kinageno ikamoꞋa ai-vasa ohugahie. KaꞋnefiꞋmoꞋa ikatetila atafai-lavigahie. IkateꞋma hanea yamoꞋa alu kate kate huno vaiyegahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ani yaꞋyagamoꞋa haꞋno hutesigeꞋna ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna esua alekana yana ikate falote hisigeꞋya mukiꞋa ma mopafima mainaya veaꞋmoꞋya hamau huꞋya avi-tegahae. Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna ikapinagati siate elavisugeꞋya nagegahae. TusiꞋa tokiya yaniꞋaene tusiꞋa hale yaniꞋaene esugetama nagegahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","NagetesageꞋna ensole vayaꞋnia hu-ma-tesugeꞋya ala ufe kemo nehinageꞋya yagemoꞋma tavi nefalelegatiꞋene evaꞋyi nehilegatiꞋene aluga aluga haupalegatiꞋene mukiꞋa ma mopafi nagaiꞋniꞋa nahaꞋye higeꞋna hapali-ma-tenoa veaꞋnea amavalesageꞋya aluga aluga ma mopamona atupaleti melitalu hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","YisasiꞋa nagoꞋene mage huno hie fiki yosamoꞋa nago avame yana tamave-ligahigi ageho. Ani yosamoꞋa hagoteno akopapiti agusasima ayeno amuꞋmalesigetamahena “Anuna neꞋvalea kanamoꞋa ago falote hugahie.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","NaꞋa hugahianagi manima tamaha-nepauva kuguva yama agenutamahena “YisasiꞋa esia kanamoꞋa ago aupa higeno fiate hetino maineanagino ago egahie.” hutama tamakesa havigahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nagaya tamage huꞋna tamaha-nepauve meni kanafima mainaya veaꞋnea ofalinesageno ani yamoꞋa falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","IkaꞋene ma mopaene fanane hugahianagi nagai kemoꞋa fanane ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Manima tamaha-nepauva kanama falote hisia kanahena nago kanomoꞋa ohavine. Ikapinaga mainaya ensole vayaꞋmoꞋyaenena ohavinae. Anumaya Kotina nafaꞋneꞋamoꞋnaenena ani kanama falote hisia kanahena ohavinoe. Ohavinogi NenafaꞋa agaiꞋage haviline. ");
INSERT INTO kmu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna eteꞋna esua kanafima mainesaya veaꞋmoꞋya nayoma NoaꞋma mainea kanafima mainaya veaꞋmoꞋya hu-mainaya avamete kava hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","TimoꞋa yaufa hoꞋokinea kanafima mainaya veaꞋmoꞋya kavela neneꞋya tina neneꞋya nehuꞋya aꞋnema aliyamoꞋene vele uyamoꞋene mukiꞋa kanafina ani yafekeꞋya amakesa havi havi huꞋya mainageno NoaꞋa ala tipi kalefi haisaga hu-maigeno tusiꞋa lina hogino mukiꞋa ani veaꞋnea alino haviya higeꞋya agola fali haꞋno hu-mainayane. Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna eteꞋna esua kanafima mainesaya veaꞋmoꞋya nayona NoaꞋma mainea kanafima mainaya veaꞋmoꞋya hu-mainaya avamete kavala hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tamage tamaha-nepauve nagayama eteꞋna esua kanaleꞋma tole vekalatana nagola hoyafima aliꞋya neꞋalisaꞋagenofena Anumaya KotiꞋa nagoke neꞋavaleno nagola alita-ye-talegahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tole atalama tokaeꞋana aliꞋya neꞋalisaꞋagenofena Anumaya KotiꞋa nagoke neꞋavaleno nagola alita-ye-talegahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","AnumayatamimoꞋa evaꞋyima hisia kanahena ohavinagi tamakesa havige havige hutama kava yagaitama maiho. ");
INSERT INTO kmu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tamage huꞋna tamaha-nepauve nomona nefaꞋa musufa kanomoꞋa nomaꞋafima ehai-falesiana kegela na kanalelo huno agoꞋma havimainesiana yagaino mainageno musufa kanomoꞋa nomaꞋafina ehaino ofalegahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","TamakaiꞋenena talo tala hutama maiho. “Menia omegahie.” hutama hisaya kana kanoꞋale ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna egahue. ");
INSERT INTO kmu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","AnumayamoꞋa mage huno hie aliꞋya kanoa kanale agu agesa hanea kanoa aliꞋyamaꞋale agegeno alige aligema nehia kanoa tamakaipina hanate maine? NaꞋama nehisia kanomofena kava kanomoꞋa mage huno hugahie “MukiꞋa aliꞋya veatela yagai-maineka kavela fako huka mukiꞋa kanafina amamite amamite huo.” huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hugahianagi haenagama ani ala kanomoꞋa eteno esiana hapai-mainea augafa kavaꞋma nehinunofena ani aliꞋya kanomoꞋa muse hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tamage huꞋna tamaha-nepauve naꞋama nehisia aliꞋya kanomofena kava kanomoꞋa mage hugahie “MukiꞋa yaniꞋa kava yagaiyo.” huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Hugahianagi ani aliꞋya kanomoꞋa kefo yama nehisia kanoma mainenunofena agaiꞋa agesa mage hunoꞋma havisiana “Kava kanoꞋnia menia hivi huno omegahie.” huno nehuno agaiꞋa yagai-mainesia veneꞋnegi munaꞋnegi nehamaeno ala kanomo kaveꞋene haviliꞋenena neneno aneginagi hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ani kavala maino nehisiana “Omegahie.” huno hisia yupamo kana kanoꞋale ani kava kanoa egahie. ");
INSERT INTO kmu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Enunofena ani havi kavaꞋma maino nehisia kanomona kaꞋyo kevea amiteno alino haviya hu-teteno mage hugahie “Vagala vayaꞋene amakupi haviꞋya omaleꞋya amegati nehaviya vayaꞋene maiyo.” huno hu-tesigeno visiaꞋamo anilega avia mo neꞋateno ave kemoꞋa tusiya hugahie. ");
INSERT INTO kmu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Anumaya KotiꞋma kava yagai-mainea yamo aepa hesia kanamoꞋa maꞋa hugahie YisasiꞋa avame kea mage huno hie nago kanomoꞋa aꞋnea meni kanoꞋa ali-mainea kanoa egahe higeꞋya teniꞋa (10) vele omainaya munaꞋnemoꞋya lamuꞋamia neꞋaliꞋya katega neꞋuꞋya avalegahe umainae. ");
INSERT INTO kmu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vayana faefuꞋa (5) munaꞋnemoꞋya aifoꞋnafo hageꞋya faefuꞋa (5) munaꞋnemoꞋya kanale havi haviꞋyamia hane. ");
INSERT INTO kmu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ani aifoꞋnafo munaꞋnemoꞋya kanaleꞋya huꞋya lamua aliꞋya vayanagi ata kaesaya tina oꞋaliꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","VageꞋya kanale havi haviꞋyaꞋamima hanea munaꞋnemoꞋya kanaleꞋya huꞋya lamuma hanagalisaya tina keꞋayopi taki-liꞋya lamuꞋamiene aliꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Umainageno ani aꞋma alisia kanoa aupaꞋa omegeꞋya ani munaꞋnemoꞋya agava-mainageno amau lokotoko higeꞋya faeꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","FaeꞋya mainageno kege amuꞋnona nagola ala kemoꞋa mage huno hie “AꞋma alisia kanoa ago neꞋegi tamakaya kategati movaletama eho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","HigeꞋya mani teniꞋa (10) veleꞋma omainaya munaꞋnemoꞋya hetiꞋya lamuꞋamia hanagaliꞋya talo tala hae. ");
INSERT INTO kmu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","HageꞋya aifoꞋnafo munaꞋnemoꞋya kanale havi haviꞋyamima hanea munaꞋnehena mage huꞋya hae “Tagai lamumoꞋa ago asu hisia kava nehigi atama nelea tina keꞋayopitamifiti takitama tamiho.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","HageꞋya kanale havi haviꞋyamima hanea munaꞋnemoꞋya kenonaꞋamia mage huꞋya hae “TagaiꞋene tamakaiꞋenema aye halesuna timoꞋa kosa ohenegi tamakaya afeno nopiti mo miya hiho.” huꞋya hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","HageꞋya ani timaꞋa miya hugahe vageno aꞋma alisia kanoa anile egeꞋya talo talaꞋma hu-malaya munaꞋnemoꞋya agaiꞋene ala kave negahe nopinaga hai-falageno fita agola ki-malene. ");
INSERT INTO kmu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ki-malenegeꞋya haenaga aifonafo munaꞋnemoꞋya mage huꞋya me hae “Ala kanomogae ala kanomogae fita yaki-la-to.” huꞋya me hae. ");
INSERT INTO kmu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Me hageno aꞋma alisia kanomoꞋa mage huno kenonaꞋamia hie “AꞋao tamage huꞋna tamaha-nepauve no-tama-koa anaga emainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","YisasiꞋa mage huno hie “Nagayama esua yupamona kanaꞋaenena ohavinaya yafe menia kava yagaiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","YisasiꞋa Anumaya KotiꞋa kava yagai-mainea yamoꞋa maꞋa hu-maine “Nago kava kanomoꞋa ayaꞋaya kotega ugahe nehuno aliꞋya vayaꞋamofena ke higeꞋya ageno monea ali fako huno amamite amamite hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","AliꞋya aepaꞋamia ageteno nago kanomona faefu tauseni kina (K5,000) amino nago kanomona tole tauseni kina (K2,000) amino nago kanomona vani tauseni kina (K1,000) amino huno amamite amamite huteno alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Umainegeno faefu tauseni kinama (K5,000) amigeno ali-mainea kanomoꞋa ani moneleti aliꞋya aligeno aꞋva monea nago faefu tauseni kina (K5,000) aliteno teni tauseni kina (K10,000) higeno ali-maine. ");
INSERT INTO kmu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ali-geno tole tauseni kinama (K2,000) ali-mainea kanomoꞋa ani moneleti aliꞋya aligeno aꞋva monea nago tole tauseni kina (K2,000) aliteno foꞋa tauseni kina (K4,000) higeno ali-maine. ");
INSERT INTO kmu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ali-geno vani tauseni kinama (K1,000) ali-mainea kanomoꞋa ani monea alino mopafi kafino kava kanomo monea he-vai-malene. ");
INSERT INTO kmu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ani aliꞋya vayaꞋmogami kava kanomoꞋa ayaꞋaya kanagefa umaiteno eteno eno mage hie ‘Monema fako huꞋna tamaminoa monea naꞋmagi mone malenae?’ huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hama-vigegeno faefu tauseni kinama (K5,000) aminea kanomoꞋa teni tauseni kina (K10,000) alino neꞋeno mage huno hie ‘Kava kanomogae musekaꞋa nehugi faefu tauseni kinama (K5,000) naminapitila eteꞋna aꞋva monene alugeno teni tauseni kina (K10,000) hane.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Higeno kava kanomoꞋa mage huno hie ‘Kagaya kanale kano maineka kanaleꞋya huka osi mone kanoꞋa kaminofitila efi efi huka aliꞋyana alinageno ala hu-maineafe ala yakefa kagaila kava yagaisanafe kamigahue. Nopinaga ehaigetaꞋa tokaetaꞋa muse hutaꞋa maiꞋano.’ huno hie ");
INSERT INTO kmu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Higeno tole tauseni kinama (K2,000) aminea kanomoꞋa mage huno me hie ‘Kava kanomogae musekaꞋa nehugi kagaya tole tauseni kina (K2,000) naminapitila aꞋva monene tole tauseni kina (K2,000) higeꞋna aliꞋna neꞋoe.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Higeno kava kanomoꞋa ani kanomofena mage huno hie ‘Kagaya kanale kano maineka kanaleꞋya huka osi mone kanoꞋa kaminofitila efi efi huka aliꞋyana alinageno ala hu-maineafe ala yakefa kagaila kava yagaisana yafe kamigahue. Nopinaga ehaigetaꞋa tokaetaꞋa muse hutaꞋa maiꞋano.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Higeno vani tauseni kinama (K1,000) aminea kanomoꞋa eno mage hie ‘Kava kanomogae musekaꞋa nehugi kagaya keꞋage kanoa alu kanomo yana alika kaugafa hegeka omai kano mainane. Nago kanomoꞋa hoyaꞋafima kali-malenea yaꞋene alika negeka omai kano mainane. ");
INSERT INTO kmu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mainanafe kolikaꞋa huꞋna vani tauseni kinama (K1,000) naminanaꞋmaga mopafi kafiꞋna he-vaiꞋna ka-tenoanagiꞋna menia kagaikaꞋa yanagiꞋna negamue.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Higeno kava kanomoꞋa ani aliꞋya kanohena mage hie ‘Kagaya havi kanoe. FeluꞋage aliꞋya kano mainane. Kagaya ago nehavine nago kanomoꞋma hoyaꞋafima kali-malenea yaꞋene aliꞋna negeꞋna omai kano mainoa yafena kagaya ago havimainano? ");
INSERT INTO kmu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","NaꞋa higeka monema nemalaya nopina moneꞋnima malenateꞋasina menia nagaya nagoꞋa aꞋva monene aluleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vani tauseni (K1,000) kinaꞋnia hafaletama teni tauseni kinama (K10,000) malenea kanomona amiho. ");
INSERT INTO kmu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nagaya tamaha-nepauve nagoꞋa yaꞋamima hanesia veaꞋmogamina nagoꞋene amamisigeno kasago hu-ma-tegahianagi nagoꞋa yaꞋamima omalenesia veaꞋmogamina ali-linesaya yamaꞋa hamana-falegahie. ");
INSERT INTO kmu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ani havi kavaꞋma nehisia aliꞋya kanomona hani yapinaga avaletama hagaꞋyu hu-talesageno tusiya huno avia neꞋateteno avekemoꞋa hugahie.’ huno hie.” ");
INSERT INTO kmu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","YisasiꞋa nagoꞋene mage huno hie Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna kava yagaigahema esuana tokiyaꞋage hale yaniꞋaene ensole vayaꞋene tokiyaꞋage hale yaniꞋaleti kava yagaisua siale maigahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","MainesugeꞋya mukiꞋa kotega veaꞋmoꞋya nagaite melitalu hisageꞋna sipi sipile neꞋyagaiya kanomoꞋma memene sipi sipiene ali fakoma nehia avamete huꞋna mukiꞋa veala ali fako hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ali fako huteꞋna sipi sipiyaga tamaga nayatega neꞋamateꞋna memeyaga hauga nayatega amategahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","AmateteꞋna ala sauve kanomoꞋna tamaga nayategama amatesua veafena mage huꞋna hugahue “NenafaꞋa kanale manua tamaminea vealagi eho. Ma mopama taloma hu-mainea kanaleti aepa heno tamakaife huno talo tala hu-maleteno kava yagai-mainea kumatelagi emaiho.” huꞋna hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Nagaila nagaꞋma tegetama kavela naminae. Tifema nagegetama afaꞋa naminae. Natu kanoma ogetama navaletama falu fala hu-natetama notamifina na-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","KenaꞋnima omalegetama kena fai-natenae. Kalima alugetama navaletama yagai-natenae. Kinafima mainogetama nagegahena emainayane. NaꞋa kavaꞋma hu-mainayafe talo hu-lama-tenea kumatela emaiho.” huꞋna hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","HugeꞋya tamaga nayategama fatago kavaꞋma nehaya veaꞋmoꞋya mage huꞋya hugahae “Anumayamogae na yu kagala tegeta kageteta kavela kaminone? Na yu tifena kagegeta tina kaminone? ");
INSERT INTO kmu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na yu natu kanoa evaꞋyi hanageta alita kanale huta ka-tenone? Na yu kenakaꞋa omalegeta kena kaminone? ");
INSERT INTO kmu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na yu kalia alinageta kage-mainone? Na yu kinafina mainanageta mo kage-mainone?” huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","HuꞋya hisageꞋna ala kava kanomoꞋna kenonaꞋamia mage hugahue “Tamagelafa huꞋna tamaha-nepauve tamakaya amakima omale naganaꞋnimogamima ani kavaꞋma hu-ma-tayana nagai ani kavala hu-natenae.” huꞋna hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hugahuanagi haoga nayatega veafena mage huꞋna hugahue “Tamakaya hu-haviya hu-matenoa kefo kavakeꞋya nehaya veaꞋmogatama mai-haletama viho. SataniꞋene aliꞋya vayaꞋaenena agola tegelege nehia atafi maisaya kumala ago talo hu-malenogi ani kumate agola umaiho. ");
INSERT INTO kmu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nagaila nagaꞋma liana kavela onaminae. Tifema nagegetama tina onaminae. ");
INSERT INTO kmu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Natu kanoma ogetama navaletama falu fala hu-ona-tenae. KenaꞋnima omalegetama kena fai-ona-tenae. Kalima alugetamao kinafima maugetamao me onagegenayane.” huꞋna hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","HisugeꞋya kenonaꞋnia mage huꞋya hugahae “Anumayamogae na yu kagala tegeta kage-mainone? Na yu tifena kagegeta kage-mainone? Na yu natu kanoa anageta kage-mainone? Na yu kenakaꞋa omalegeta kage-mainone? Na yu kalia alinageta kage-mainone? Na yu kinafina mainanageta kage-mainone? Tagayama kage-mainoteꞋasina ago kaya hu-mainoteꞋasine.” huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","HisageꞋna nagaya eteꞋna amakaifena mage hugahue “Tamagelafa huꞋna tamaha-nepauve tamakaya amakima omalenea naganaꞋnimogamina ani kavaꞋma hu-oꞋama-tayana namona nagaiꞋene hu-ona-tenayane.” huꞋna hugahue. ");
INSERT INTO kmu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Huteno kefo yama nehaya anonaꞋamia hu-ma-tenageꞋya agola amakata aisia hani yapi maisaya kumate ugahagi fatago kavaꞋma hu-mainesaya veaꞋmoꞋya ofaliꞋya agola maige maige hisaya kumate ugahae huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","YisasiꞋa mukiꞋa mani kea hu haꞋno huteno agaiꞋaenema lokaeꞋya nemaiya anagafena mage huno hie “Tamakaya ago havimainae tole kana mainesunageꞋya kafuꞋahe kafuꞋahe Anumaya KotiꞋa taginagomogami amaugafama ali-gati-mainea kanahe* alitalu huꞋya imua kigahae. Ani imuma kisaya kanafina ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋnia natafa huꞋya yafaga yosale nili heꞋya nasasaigeꞋna faligahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mono note kava vayaꞋene Yuta vayatamaene ala mono note uhagote-mainea kava kanoa, KaiyafasiꞋe ani kanomo nopi, melitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","MaineꞋya mage hae “HanaꞋa huta agesi huta Yisasina atafa huta haesunageno falisie? ");
INSERT INTO kmu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ala imuma kisaya kanafina atafa ohugahune. Atafa hisunageꞋya veaꞋmoꞋya havigu tusiꞋa ke huꞋya tu huyafenagita atalegahune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","YisasiꞋa Petani viana nayona fugitaya age-mainea kanomo agia SaimoniꞋe kanomo nopi umaine. ");
INSERT INTO kmu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Umainegeno nago aꞋmoꞋa yafa keꞋayola alilino anileꞋma eana ani keꞋayoꞋma taloma hu-malenaya yafamo agia alapasata. Ani li keꞋayopina nagola tusiꞋa miyamaꞋa hanea masavena manaꞋage tina haneanagino YisasiꞋa kave maino nenegeno ani aꞋmoꞋa Yisasi anupi ani masavena takino fale-tene. ");
INSERT INTO kmu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Takino fale-neꞋa-tegeꞋya YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya ageteꞋya ke vaiꞋya mage hae “NaꞋa higeno mani manaꞋage masavena afaꞋa neꞋatale? ");
INSERT INTO kmu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ani masavena nago kanomoꞋma miya hileꞋasina tusiꞋa mone aliteta ani masaveteti monea afenoꞋamima omalenea veaꞋne amamuteꞋasine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hageno YisasiꞋa ani kea haviteno mage huno hie “Kea oꞋama-kitama afaꞋa ataleho. Havige nehagi nagaila tusiꞋa kanale kava hu-nena-te. ");
INSERT INTO kmu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","MoneꞋamima omale veaꞋmoꞋya mukiꞋa kanafina tamakaiꞋenekeꞋya maigahayanagi nagaya tamaikaiꞋenena mukiꞋa kanafina omaigahue. ");
INSERT INTO kmu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mani aꞋmoꞋa masavena naugafaleꞋma takino fale-nena-teana afaꞋa ofaliꞋna mainogeno masavema faleꞋya he-vai-na-tesaya avamete huno fale-nena-te. ");
INSERT INTO kmu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tamage huꞋna tamaha-nepauve mukiꞋa ma mopafi veapima nagaifena kanale mono kema hama-paisafina mani aꞋmoꞋma hia kavafeꞋenema hama-paisageꞋya mukiꞋa veaꞋmoꞋya agaifena amakesa havigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Higeno Yutasi IsakaliotiꞋa Yisasina tuelufuꞋa (12) anagaꞋene tokaeno nemaiya kanogino neꞋamataleno viaꞋamo mono note kava vayate umaine. ");
INSERT INTO kmu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","UvaꞋyi huno mage huno hie “Agesi huꞋna tamave-lisugetama Yisasima atafa hisayana na kano namigahae?” huno higeꞋya muse huteꞋya aupaꞋa tetiꞋa (30) siliva alaga mone aminae*. ");
INSERT INTO kmu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Amigeno YutasiꞋa vaya kulata oꞋaiya yate kesi kateti Yisasina movalesigeꞋya atafa hisaya kafe ati-ye-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hale oki kai-hamema nenaya kanamona hagote kanale YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya Yisasife mage huꞋya me havigae “Anumaya KotiꞋa Yuta vaya amaugafama ali-ga-ti-mainea kanahe kagesa havisana kavela hana nopi mo-lalo tala hisune hunageka nehane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hageno YisasiꞋa mage huno hama-paiye “Ala kumate uvaꞋyi hutama nago kanomote mage hutama mo hiho ‘Hu-lave-nelia kanomoꞋa mage hie ‘Falisua kanamoꞋa ago aupa higeꞋna kagai nopi nagaiꞋenema tokaeꞋya nemaiya anagaꞋaene Anumaya KotiꞋa Yuta vaya amaugafama ali-ga-ti-mainea kanahe tagesa havisuna kavela nesune huꞋna nehueꞋ huno hie.’ hutama hiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya YisasiꞋma hama-paiya avamete huꞋya ani kavela mo-lalo tala hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Talo tala hu-malageꞋya yagemoꞋma tavi faleamaꞋa YisasiꞋa tuelufuꞋa (12) anagaꞋaene kave negahe folamole mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","MaineꞋya kavela nenageno YisasiꞋa mage huno hie “Tamage huꞋna tamaha-nepauve nagaiꞋenema mainafitila nago kanomoga nagesi huka nahaesana yatela vai-neꞋayane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","HigeꞋya anagaꞋamoꞋya amaipa haviya huteꞋya agaifena mage huꞋya havigae “Anumayamogae nagaife nehano?” huꞋya nagoke nagokeꞋmoꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Havigageno YisasiꞋa mage huno hie “NagaiꞋenema nagoke yopafiti ayateti vayagofinoꞋma nenea kanomo nagesila huno nahaesia yatela vai-neꞋaye. ");
INSERT INTO kmu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna nagaife huꞋya Anumaya Koti avopina kae-malenaya kate ugahuanagi vayaꞋmoꞋya havisagi huno nagesi hisia kanomofena avoꞋnio nahau hanagi kagaya kaꞋyeka maiyo huꞋna nehue. Ani kanomoga itakamoꞋma okateneleꞋasina kanale hileꞋasine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Higeno YutasiꞋa agesiꞋma hisia kanomoꞋa mage huno hie “Hu-lave-nelina kanomogae nagaife nehano?” huno higeno YisasiꞋa mage huno hapaiye “Kagaya kagaika ago hu-falote nehane.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kavela nenageno YisasiꞋa kai-hame kana maya alino nunamu huno muse huteno kolite kolite huno agaiꞋaenema tokaeꞋya nemaiya anagala neꞋamamino mage huno hie “Mamona nagaiꞋni naugafagi alitama neho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nagola vaini nofi alagamo ti* hanea keꞋayola aliteno nunamu huno muse huteno amamite amamite nehuno mage huno hie “MukiꞋamogatama neho. ");
INSERT INTO kmu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ma lina nagaiꞋa kolaniꞋae. NahaesageꞋna falisugeno kolaniꞋamoꞋa tamakaifene huno take take hu-lavisiafe haegafa kea, Anumaya KotiꞋene hagelafitama maisaya kea* ali fatago hugahianagino Anumaya KotiꞋa ani kolatetifene huno kasagoꞋya veaꞋmogami kefo yaꞋamia aige-ama-teno atale-ma-tegahie. ");
INSERT INTO kmu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nagaya tamaha-nepauve menia nagaya vaini nofi alagamo tina* nagoꞋene onegahuanagiꞋna NenafaꞋa kava yagai-mainea kumate umaineꞋna haegafa nofi alagamo tina* eteꞋna tamakaiꞋene tokaeꞋna maineꞋna negahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","HigeꞋya nagola yagamea huteꞋya Olivi yosa hanea agoꞋyafi hai-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","YisasiꞋa mage huno hama-paiye “Tamakaya mukiꞋamogatama meni kegela nagaiꞋma hu-na-tesaya kavafena nagaifema havitama tamakupi maletama tamametiti nehaya yana ataletama asaga hu-lavisagi nayona ani yafena mage huno kae-maleneane ‘Nagaya sipi sipi kava kanoa haesugeꞋya sipi sipiyaga atagufeꞋya faleꞋya ute ete hugahae.’ huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kae-maleneanagi fali-mainesufiti Anumaya KotiꞋa alino he-ti-na-tesigeꞋna Kalili uhagote-lama-teꞋna ugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Higeno PitaꞋa kenonaꞋa mage huno hie “Hu-ga-tesaya yafema mukiꞋa anagaꞋmoꞋya kagaifema haviꞋya amakupi maleꞋya amametiti nehaya yama ataleꞋyama falesageꞋnahena nagaya mukiꞋa kanafina kataleꞋna ofalegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Higeno YisasiꞋa kenonaꞋa mage huno hie “Pitaga tamage kaha-nepauve meni kegela kokolemoꞋa agea oꞋainesigeka tagufa (3) kanale ‘Nagaya oꞋagenoa kanoeꞋ huka avane hugane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Higeno PitaꞋa mage huno hie “KagaiꞋene nahaesageꞋna faligahuanagiꞋna kagai kagia avanena huꞋna ali fala okigahue.” huno higeꞋya mukiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya nagoke kegeꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","YisasiꞋa amakaiꞋene viaꞋamo Ketesemani uvaꞋyi huteꞋya YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafena mage huno hie “Tamakaya male maineho. Nagaya amule visuaꞋamoꞋna nunamuna huꞋna havigegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","PitaꞋene Sepeti nafaꞋnetalaꞋene amavaleno viana aipamoꞋa kanaꞋage higeno haumanamoꞋa halegeno kasageke nehie. ");
INSERT INTO kmu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huteno mage huno hama-paiye “Nahau nayamopamoꞋa tusiꞋa kanaꞋage nehigeꞋna ago falisua kava nehugi male mainetama kava yagaitama maineho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","OsiꞋa viaꞋamo Anumayamotega ke huno havigegahe mopafi agoꞋya moyeno maineno nunamuna mage huno havige “Nagaya ago falisua kava nehugeno ani havi kanamoꞋa satuꞋage hu-mainea tima hanea keꞋayola kahaisigekahena ani keꞋayola naha-fale-talo. Nagai nagu nagesa akave omaleka afaꞋa kahaisia yana huo.” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Havigeteno momakeana agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya faeꞋya mainageno Pitafena mage huno mo hie “Vae kagaya aupa yage kanoꞋa kava oꞋyagaika mainano? ");
INSERT INTO kmu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","SataniꞋa aye-lama-vataga hisigeno tamakuꞋamoꞋa ‘Ohugahue.’ huno tokiyaꞋage hugahianagi amega tamaugafamoꞋa tokiyaꞋa afaꞋa omaleneanagino ‘Hugahue.’ huno hisia yana hugahigi Satani kema ohavisaya yafena kava yagaitama mainetama Anumayamotega ke hutama havigeho.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Huteno amataleno viaꞋamo tole (2) kanale nagoꞋene nunamuna mage huno havige “Nenafagae nagaya falisua kava hugeno ani havi kanamoꞋa satuꞋage hu-mainea tima hanea keꞋayola kahaisigekahena ani keꞋayola naha-fale-talo huꞋna nehuanagi afaꞋa kahaisia yana huo.” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Havigeteno eteno momakeana amau tokotoko higeꞋya faeꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","FaeꞋya mainageno tagufa (3) kanale nunamuna nagoꞋene ani avamete huno havige-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Havigeteno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagate eteno mage huno mo hama-vige “Mai-falu hutamage faetama mainao? Haviho kanaꞋniꞋa ago falote nehie. Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemonia nagesi huno navaleno kefo yama nehaya vayaꞋmogami amayapi natesigeꞋya nahaegahe nehae. ");
INSERT INTO kmu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","MukiꞋamogatama hetitama vigetao. Ageho nagesi huno nahaesia kanoa ago neꞋegi vigeta mogamano.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ani kea nehigeno YutasiꞋa tuelufuꞋa (12) anagaꞋaene tokaeno nemaiya kanomoꞋa evaꞋyi higeꞋya agaiꞋene mukiꞋa vayala, mono note kava vayaꞋene nagoꞋa Yuta vayatamaenema hu-matea vayaꞋenena, ayaꞋaya naepege naepege huꞋya muki kaꞋyoꞋene aliꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Agesi huno Yisasima haesaya avame yama huno amavalea kanomoꞋa ani vayafena mage huno hama-paiye “AtakoꞋma hisua kanoa haesaya kano mainegi atafa hutama tokiyaꞋage hutama avaletama viho.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hama-paiteno YutasiꞋa aupaꞋa Yisasite viaꞋamo mage hie “Hulave-nelina kanomogae.” nehuno atako hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Atako higeno YisasiꞋa mage huno hie “Nenafugae hugahema esana yana aupaꞋa huo.” huno higeꞋya ani vayaꞋmoꞋya Yisasina atafa huꞋya aye-talako hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atafa nehageno nagola agaiꞋaenema he-ti-maiya kanomoꞋa ayaꞋaya naepeꞋa he-vayu huno ala mono noteꞋma uhagote mainea kava kanomona aliꞋya kanoꞋamona agesa ai-fakali-talegeno asaga hu-lavi-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ai-fakali-talegeno YisasiꞋa ani kanomofena mage huno hie “AyaꞋaya naepekaꞋa tafugepi eteka vaiyo. AyaꞋaya naepeleti tu hisaya vayaꞋmoꞋya ayaꞋaya naepeleti hamaesageꞋya faligahae. ");
INSERT INTO kmu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kagaya ohavinano? Nagaya Nenafategama ke huꞋna havigesuana seveti tauseniꞋa (70,000) ensole vayaꞋa nahauke heꞋya tuma hisaya yafena hu-ma-tesigeꞋya egahae. ");
INSERT INTO kmu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Egahayanagi naꞋama hisagenoꞋa hanaꞋa huno nagaifena ‘NaꞋa kavala hu-tesageno faligahiema.’ huꞋya Anumaya Koti avopima kae-malenaya kemoꞋa falote huno tamagea hugahie?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","AnileꞋma melitalu hu-maiya vayafena YisasiꞋa mage huno hie “Tamakaya nagaifena ‘Vaya hamaeno musufaya nehia kano maine.’ hutama ayaꞋaya naepene muki kaꞋyoꞋene alitama natafa hugahena neꞋao? Nagaya mukiꞋa kanafina efi efi huꞋna tamakaiꞋene ala mono nopina maineꞋna mono kea tamaha-pauvanagi naꞋa higetama natafa ohunayane? ");
INSERT INTO kmu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ohunayanagi nayoma mainaya amaune vayaꞋmoꞋya kae-malenaya kemoꞋa falote huno tamage hisia yafe mukiꞋa mani kavala hutama natafa nehae.” huno hie. HigeꞋya mukiꞋa agaiꞋaenema tokaeꞋya nemaiya anagala neꞋataleꞋya fale haꞋno hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yisasima atafa haya vayaꞋmoꞋya avaleꞋya ala mono note uhagote-mainea kava kanomo* note, Kaiyafasi note, avaleꞋya vageꞋya kahegi kema havilinaya anagaꞋene Yuta vayatamaene alitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","PitaꞋa akave anatino vianagi avatela oꞋunegi ago aluꞋale umaineno ala mono note hagote kava kanomo nomo haupale uvaꞋyi huno hai-faleno maineno ati vayaꞋene mopale maineno “Yisasina hu-tesaya yana agesue.” huno umaine. ");
INSERT INTO kmu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mono note kava vayaꞋene mukiꞋa kanisole vayaꞋene YisasiꞋma haesaya kaiyeke hu-tegahe nagoꞋa vaya “Kefo kava higeta age-mainone.” huꞋya havige hu-tesaya vayafe ati-ye-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Atiyayana omaigeꞋya kasagoꞋya vayaꞋmoꞋya havige huꞋya Yisasifena huteꞋya haenaga tole kanolatana he-tiꞋana Yisasifena mage huꞋana haꞋe “Ma kanomoꞋa mage huno hu-maine ‘Nagaya Anumaya Kotina ala mono nomaꞋa aliꞋna lagape ai-taleꞋna tagufa (3) kanale ani nona eteꞋna ki-talegahue.’ huno hu-maine.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","HaꞋageno ala mono note hagote kava kanomoꞋa heti-maineno Yisasina mage huno havige “Kagaifena na augafa kea nehae? Kaiyekema hu-ga-taꞋa kemo anonaꞋania hu-falote huka nohane?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Higeno YisasiꞋa avaya tukino ke ohuno maineno nago ke kanoꞋa ohune. Ohigeno ala mono note hagote kava kanomoꞋa eteno mage huno havige “HaimuꞋaene Anumaya Koti aufima kaha-vi-goa kea tamage huka taha-paiyo. Kagaya Anumaya KotiꞋa taugafa ali-gatigahema hu-ga-tenea kanoa, Kalaisiga, mainano? Kagaya Anumaya Kotina nafaꞋneꞋamoga mainano?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Havigegeno YisasiꞋa hu-falote huno mage huno hie “E, kagaya ani kema hanana hai nehane. Tamage ani kano mainoe. Tamaha-nepauve tamakaya haenaga ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna tusiꞋa himamuꞋa hanea Anumaya Kotina aya tamaga kaiyaga hanea siale maineꞋna ikate hanea siate esugetama nagegahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Higeno ala mono note hagote kava kanomoꞋa ani kea haviteno aipamoꞋa tokiyaꞋage higeno kenaꞋa alino hatata nehuno mage huno hie “Anumaya Kotife hu-haviya hu-neꞋatea kea hai havunanagiꞋya nagoꞋa vayaꞋmoꞋya kaiyekea hu-oꞋatesae. Tamakaya Anumaya Kotife hu-haviya hu-neꞋatea kea ago haviye. ");
INSERT INTO kmu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hai havunagi na tamakesa nehaviye?” huno higeꞋya mage hae “AnonaꞋa alisia yafe haesageno falisie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","HuteꞋya nagoꞋa vayaꞋmoꞋya Yisasi augosafi amavetuꞋna he-neꞋateꞋya amayateti aiko-ligeꞋya nagoꞋamoꞋya amayana ali atale-lineꞋya aiko neliꞋya mage huꞋya havigae “Kalaisigae kaune laga huka taha-paiyo taꞋya negahayae?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","PitaꞋa nomo haupalega mopale mainegeno nago aliꞋya munaꞋmoꞋa eaꞋamo Pitafe mage huno hie “Kagaya Kalili YisasiꞋene tokaeka nemaina kano mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Higeno PitaꞋa avane huno mukiꞋa vaya amaufi “AꞋao, ani kanoa oꞋagenoa kanohe maika nehane.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Huteno fiatega umainegeno nago aliꞋya munaꞋmoꞋa megeteno anile he-ti-mainaya vayafe mage huno hie “Mani kanoa Nasaleti YisasiꞋene vai-neꞋayea kanoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Higeno PitaꞋa nagoꞋene eteno “AꞋao Anumayamo aufi tamage nehue oꞋagenoa kanomofe nehane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","OsiꞋa mainegeꞋya anile he-ti-maiya vayaꞋmoꞋya Pitafena mage huꞋya me hae “Tamage kagaya Kalili kano mainananagika kavefuꞋna ali-yahae higeka kema nehana yana tave-linageta havune agai anagapi kano mainane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hageno PitaꞋa mage huno hie “Nagaya tamakema ohisugenoꞋa Anumaya KotiꞋa nahaesie. Anumaya Koti aulagafi tamage huꞋna tamaha-nepauve tamakayama nehaya kanoa nagaya oꞋagenoa kanoe.” huno nehigeno kokolemoꞋa age ai-maine. ");
INSERT INTO kmu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Agea aigeno Pitana agesamoꞋa aikalo higeno YisasiꞋma hapaigeno havi-mainea kea mage huno hu-maineane “KokolemoꞋa agea oꞋainesigeka kagaya tagufa (3) kanale avane huka nagaifena ali fala-kigane.” huno hu-mainea kemoꞋa Pitana agesamoꞋa aikalo higeno haviteno hati-lavino viaꞋamo tusiꞋa avi mo-te-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","KoꞋma alino ha-neleana mukiꞋa mono note kava vayaꞋene Yuta vayaꞋmogami vayatamaene Yisasina haesageno falisia kea huge havige hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","HuteꞋya Yisasina nofi kiteteꞋya ala kamani kava kanoa, Pailatite, avaleꞋya ayapi motenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","YutasiꞋa Yisasina agesi huno kame yama hu-tea kanomoꞋa ageana Yisasina kaiyekema hu-teteꞋya “Faligahie.” huꞋya haya yana ageteno aipamoꞋa kanaꞋage higeno eteno aminaya monea tetiꞋa (30) siliva alaga monea* alino ala mono note kava vayaꞋene Yuta vayatamaene momamine. ");
INSERT INTO kmu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mo neꞋamamino mage huno hie “Nagaya tusiꞋa kefo yama huꞋna kefo yama ohunea kanomona agesila huꞋna kame yana hu-toanagino afa yafe faligahie.” huno higeꞋya ani vayaꞋmoꞋya mage hae “Kahaote yakae. Tagai yana omalenegi kagaikaꞋa yane.” huꞋya hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hu-tageno YutasiꞋa ani yafa monea ala mono nopi hagaꞋyu hu-neꞋataleno viaꞋamo agaiꞋa ayapiti nofila alino anoꞋmu mo-ye-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mo-yegeꞋya mono note kava vayaꞋmoꞋya ani monea aliteꞋya mage huꞋya hae “Mani monea ‘Vaya haesageno falisie.’ huꞋya ali hage-mainaya monegita alita ala mono note monenena omalesune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","HuteꞋya aliꞋya haꞋya kiteꞋya “Mani monea hapaleti susufane talo nehia kanomo mopa miya hugahune. Ani mopa natu vaya he-vai-ma-tesuna mopa hanegahie.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","NaꞋa huteꞋya ani mopamo agia kolamo tavi-mainea mopae huꞋya agia malenayanagino meni kanafina ani agimoꞋa hanegeꞋya neꞋayae. ");
INSERT INTO kmu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","NaꞋama hayana nayona aune kanoa YelemaiyaꞋma hu-mainea kemoꞋa ani kanafina falote huno tamage hie. Mage huno hu-maineane “Ani tetiꞋa (30) silva alaga monea* Isaleli vayaꞋmoꞋya ‘Haesageno falisigeta ani monea kamigahune.’ huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Anumayamo naha-pai-mainea kava huꞋya ani monea aliꞋya hapaleti susufanema talo nehia kanomo mopa miya hu-mainae.” huno hu-maineane. Ani mopama miya hu-mainaya yupa ani kemoꞋa falote huno tamagea hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","YisasiꞋa ala kava kanoa, Pailatite, he-ti-mainegeno PailatiꞋa Yisasifena mage huno havi-ge “Kagaya Yuta veaꞋmogami SauveꞋami mainano?” huno havigegeno YisasiꞋa mage hie “KagaikaꞋa mani kea hai nehane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","HigeꞋya mono note kava vayaꞋene Yuta vayatamaene “MaꞋa avamete kefo ya hu-maineane.” huꞋya hu-tayanagi YisasiꞋa kenonaꞋamia ohune. ");
INSERT INTO kmu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ohigeno PailatiꞋa nagoꞋene mage huno hie “MukiꞋa kefo yama nehana yana ali-faloteꞋma nehayana nohavino?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Higeno YisasiꞋa kenonaꞋa nagola osi kea ohigeno PailatiꞋa amaꞋyo ai-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","KafuꞋahe kafuꞋahe Anumaya KotiꞋa amaugafama ali-gati-mainea kanahe amakesa haviꞋya imua negiyanagino PailatiꞋa mukiꞋa ani imu negia kanafina nagoꞋa nofi hu-matageꞋya nemaiya vayapiti vayaꞋyagamoꞋya haesagama huꞋya “Agaya esie.” huꞋya haya kanohe nofipitila “Hai haꞋno hanagi vuo.” huno hu-neꞋatea kanae. ");
INSERT INTO kmu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ani kanafina nago kanomo agia PalapasiꞋe vayala tavata nehamaya kanoa kina nofipi maineane. ");
INSERT INTO kmu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","MaineanagiꞋya vayaꞋyagamoꞋya melitalu hageno PailatiꞋa mage huno hama-vige “Palapasife ‘Hai haꞋno hanagi vuo.’ huꞋna hisuo ifi nagaya Yisasife, veaꞋmoꞋya ‘Anumaya KotiꞋa taugafa ali-gatigahema hu-tenea kano maine.’ huꞋya nehaya kanomofe, ‘Hai haꞋno hanagi vuo.’ huꞋna hisue? Tafe musena nehae?” huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","HigeꞋya Yisasima atafa huꞋyama avaleꞋya emainaya vayaꞋmoꞋya ma amakesa haviye “MukiꞋa vayala Yisasina agai ke nehaviꞋya tagai kea nohaviye.” huꞋya nehayanagiꞋya Yisasifena amaipamoꞋa haviya higeꞋya Pailatite avaleꞋya metalaya yafe PailatiꞋa agesa haviteno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Huteno kaiyeke hu-ma-tesia siale mainegeno aꞋamoꞋa nago kanomofe “Mage huka hapaiyo.” huno hu-tegeno eaꞋamo mage huno hie “AkamoꞋa mage huno hie ‘Namona fatago kanogi afaꞋa atalo. Nagaya meni kegela tusiya huno koli nagesa hia himona agaitela age-mainoe.’ huno higeꞋna me kaha-nepauve.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mono note kava vayaꞋene Yuta vayatamaene mukiꞋa veafe mage huꞋya mo hama-paiye “Mage hutama hiho ‘Yisasina haegeno falino. Tagaya Palapasife nofipitila haꞋno hisie huta nehune.’ hutama hiho.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hageno PailatiꞋa vayaꞋyagahe nagoꞋene mage huno hie “Tole kanolata mainaꞋagi hana kanohe ‘Hai haꞋno hanagi vuo.’ huꞋna hisue?” huno higeꞋya “Palapasina afaꞋa atalegeno eno.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hageno PailatiꞋa mage huno hama-vige “Ma kanomofena amakaya ‘Anumaya KotiꞋa taugafa ali-gatigahema hu-tenea kanoe.’ huꞋya nehaya kanoa naꞋa hu-tesue?” huno hama-vige. HigeꞋya mukiꞋa veaꞋmoꞋya “Yafaga yosale nili hetama asaigeno falino.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hageno PailatiꞋa mage huno hama-vige “NaꞋa higetama ani kea nehae? HanaꞋa kefo yama hu-maine?” huno hianagi eteꞋya aliꞋya alapi ataleꞋya ala kefiti mage huꞋya hae “Yafaga yosale nili hetama asaigeno falino.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hageno PailatiꞋa “Nagai kea ohaviyanagiꞋya tu hugahe nehae.” huno agesa haviteno mage huno hie “Ani fatago kanomo kolamoꞋa nagaipina kumila omalegahigi tamakaitamifi kumitamia hanegahie.” huno nehuno tina alino ani vayaꞋmogami amaule ayana sese hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sese higeꞋya mukiꞋa veaꞋmoꞋya mage huꞋya hae “Haesanageno falisia kumiꞋmoꞋa tagayaene nafaꞋnetimoꞋyaene afaꞋa aligahune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hageno PailatiꞋa Palapasina nofipitila avaleno neꞋataleno Yisasina agata aisifa kaꞋyoteti haifu amiteno Yisasina ati vaya amayapi ateteno “Yafaga yosale nili hetama asaigeno falino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ala kava kanomo ati vayaꞋmoꞋya Yisasina avaleꞋya ala kava kanomo no haupalega umaineꞋya mukiꞋa amakaiꞋenema nemaiya ati vayafe ke hageꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","AyaꞋamoꞋya Yisasina kenaꞋa asagi-taleteꞋya akaya ateꞋya “Ala kano mainane.” huꞋya hisaya yafe ayaꞋaya haesa kena fai-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Fai-teteꞋya avetaꞋnafaꞋage nofiteti tumano kula talo huteꞋya anutela vai-teteꞋya kupaga kaꞋyona tamaga ayapi amiteꞋya amaleꞋya neꞋayeꞋya hu-haviya hu-teteꞋya kigi hu-teꞋya kamuge hatageꞋya vai-neꞋa-teꞋya mage huꞋya hae “Felugae. Yuta veaꞋmogami ala sauve kanomogae.” huꞋya kigi hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Augafale amavetuꞋna he-teteꞋya anutela kupaga kaꞋyoteti aiko-li-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hu-haviya hu-teteꞋya kigi hu-neꞋa-teꞋya haesa kena hate neꞋa-taleteꞋya agaiꞋa kena fai-teteꞋya yafaga yosale nili hegahe avaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yisasina avaleꞋya kategama vayana Sailini SaimoniꞋene mo-fotu huteꞋya ati vayaꞋmoꞋya motafa huꞋya tokiyaꞋage ke huꞋya “Yafaga yosa Yisasi akave kofika vuo.” huꞋya hu-tageno alino vie. ");
INSERT INTO kmu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","VigeꞋya Yisasina Kologota kumale, ani agimoꞋa tagai kefina anu ayamufae huꞋya nehaya kumate avaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ani ati vayaꞋmoꞋya “Haesunageno falisiana agata ai yafenagita agatama oꞋaisia tina nesie.” huꞋya nehuꞋya ani atuꞋage timo agia gala. Ani atuꞋage tiꞋene nofi alagamo tiꞋene nagopi ali havigu huteꞋya aliꞋyama amiyana YisasiꞋa ani lina neno agegeana higeno masu hugeno atalene. ");
INSERT INTO kmu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","OnegeꞋya yafaga yosale nilia heꞋya asai-maleteꞋya kenaꞋa fako huꞋya aligahe musufa yama nehaya yokalo lageno amakasesaya vayaꞋmoꞋya ali-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","AliteꞋya mopale maineꞋya kava yagaiꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Anutela kaiyekema hu-taya kema kaeꞋya malaya avomoꞋa mage huno hie “Mani kanoa Yuta veate ala Sauve kanoe.” huꞋya kaeꞋya malenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kae-maleteꞋya YisasiꞋene tole kanolatana vaya nehamaeꞋana musufa ya nehaꞋa kanolatana nago kanoa tamaga kaiyagaꞋa haeꞋya asai-maleꞋya nago kanoa haoga kaiyagaꞋa haeꞋya asai-maleꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hu-malenageꞋya kateꞋma ute ete huꞋya agasaya veaꞋmoꞋya amakeꞋya kaꞋyo neꞋaiꞋya “Kefo kano maine.” huꞋya kigi yokalofiti hu-haviya hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mage huꞋya hae “Oho kagaya ‘Ala mono nona aliꞋna lagape ai-taleteꞋna tagufa (3) kanale eteꞋna ki-talegahue.’ huka nehana kano mainane? Kagaya Anumaya Koti nafaꞋne mainenukahena menia yafaga yosa ataleka elavika kagaikaꞋa kaugafa aligatio.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","HageꞋya mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene Yuta vayatamaene aniꞋa huꞋya kamuge hatageꞋya vai-neꞋateꞋya hu-haviya hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mage huꞋya hae “NagoꞋa veala amaugafa ali-negatia kanogi agaiꞋa augafa naꞋa higeno ali-nokatie? Isaleli veaꞋmogami Sauve kanoꞋamima mainenunofena yafaga yosaletila ataleno elavinageta agamano. Agesunana ‘Kagaya lamage nehane.’ huta tametitia hugahune. ");
INSERT INTO kmu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Agaya Anumaya Kotife ametiti nehuno mage huno hu-maineane ‘Nagaya Anumaya Koti nafaꞋnemoꞋnae.’ huno nehianagino Anumaya KotiꞋa agaifema hainagenoꞋa menia augafa ali-gatisie.” huꞋya hu-haviya hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","AgaiꞋenema musufa kanolatama yafaga yosaleꞋma asai-malaya kanolatamoganienena aniꞋa huꞋana Yisasina hu-haviya hu-tenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Anile yagemoꞋa euno amuꞋnokaꞋno higeno hale-mainea yamoꞋa haꞋno higeno mukiꞋa kotega tusiꞋa hani-kino viaꞋamo une kanalega eteno ali hale-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Une kanalega YisasiꞋa ala kefiti ke huno agaiꞋa kefiti mage huno hie “Eli Eli lema sapakatani.” huno hie. Tagaiti kefina mage huno hie “Anumaya KotiꞋnimogae Anumaya KotiꞋnimogae naꞋa higeka nagaila nenatalane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","HigeꞋya nagoꞋa anile heti-mainaya veaꞋmoꞋya haviteꞋya mage huꞋya hae “Ilaiyafe ke nehie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hageno nago kanomoꞋa aiya-yeno viaꞋamo hava koꞋyafa kana yana alino atuꞋage nofi alagamo tipi ayeteno alino viaꞋamo kupaga kaꞋyote maleno ani hava koꞋyafa kana yana kiteno “YisasiꞋa mayu mayu huno nesie.” huno amine. ");
INSERT INTO kmu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","AmigeꞋya nagoꞋamoꞋya mage huꞋya hae “Atalo, agava mainesunageno IlaiyaꞋa esiaꞋamo yafaga yosaletila mevaleno elavisiaꞋamo augafama ali-gatisia yafe esio. Agetetae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hageno YisasiꞋa nagoꞋene ala kefiti nehuno agu nafaꞋnea atalegeno vigeno fali-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Faligenofena ala mono nopi asai-malenaya kenagefa* ayaꞋaya ala kenagefamoꞋa YisasiꞋma falia kana kanoꞋale ani kenamoꞋa analeti aepa heno tavigeno amuꞋnopiti hatata hu-lole huno mo-talegeno imila aligeno yafaꞋyagamoꞋa aposi-lavi-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","HigeꞋya veaꞋma he-vai-ma-tenaya komumoꞋa ai-hagalo higeꞋya kasagoꞋya veala, Anumaya Kotina amakuꞋama amitafa huteꞋya fali-mainaya veala, he-ti-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","He-tigeꞋya ani veala komufitila hetigeno YisasiꞋa fali-mainefiti he-ti-mainea yupa Yelusalemu vageꞋya mukiꞋa veaꞋmoꞋya amake-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ati vayaꞋene kava kanoene YisasiteꞋma yagaiꞋya maiya ati vayaꞋmoꞋya imiꞋma alia yaꞋene alu ya alu yama falote hia yana ageteꞋya tusiꞋa amamaꞋyo aigeꞋya mage huꞋya hae “Tamage huno mani kanoa Anumaya Koti nafaꞋne-lafa maine.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","NagoꞋa aꞋneyaga Yisasina aya hugahe Kaliliti akave emainaya aꞋneyaga aluꞋale hetiꞋya maineꞋya age-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","NagoꞋamogami amakia osi YemesiꞋene Yosefegani itaꞋanimoꞋa MaliaꞋe Magatala kumate MaliaꞋene tole Sepeti nafaꞋnelatamaꞋamogani itaꞋanimoꞋene anifina mainae. ");
INSERT INTO kmu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","YagemoꞋa tavi falegahe higeno YosefeꞋa Alimatia kumate kanoa, ala moneꞋa hanea kanoa Yisasi ke havino akave nemalea kanogino Pailatite mage huno me havige “Yisasina augafaꞋa aligahe nehue.” huno havigegeno PailatiꞋa “E” higeno ati vayaꞋahe “Yisasi augafa aliꞋya Yosefena amiho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hapaigeno YosefeꞋa augafa alino me-maleneno kenaleti aigalaki kalaki huno haꞋya kino anoꞋvai-tene. ");
INSERT INTO kmu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","AnoꞋvai-teteno alino alino viaꞋamo agaiꞋma he-vai-tesaya yafe higeꞋya he falegeꞋya kafi-malenaya yafakapi Yisasina mo he-vai-tene. He-vai-teteno ani yafa kamo avayaleꞋma ai-lilesia yafana, ala yafakefa ayetu-feno anile mo ai-lile-maleteno umaine. ");
INSERT INTO kmu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","VigeꞋana Magatala MaliaꞋene hamoꞋamoꞋene anile mopale maineꞋana he-vai-tea yafa kana age-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Sapati kanahe haviꞋya kavela talo tala hu-maleꞋya faeteꞋya kotigeꞋya ala mono note kava vayaꞋene Falasia vayaꞋene ala kanoa Pailatite mage huꞋya me hae “Ala kanomogae tagaya ago havune anima havigeꞋage kanomoꞋa afaꞋama mainea kanafina mage huno taha-pai-maine ‘Nagaya tagufa (3) kanale maiteꞋna komufitila he-tigahue.’ huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nage hu-maineafe kagaya tokiyaꞋage ke hugeꞋya ani yafa kamona ai-lileꞋya tokiya vai-malesageno tagufa (3) kanafina tokiyaꞋage huꞋya yagaisae. Havigu agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ani komufiti Yisasi augafa musufaya huꞋya aliꞋya uteꞋya veafe ‘Fali-mainefitila agaiꞋa he-tino umaine.’ huꞋya hama-paisageno ani kema hisaya kemoꞋa hagoteno hu-mainea kemona agasegahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hageno PailatiꞋa mage huno hie “Kava yagaisaya ati vayala tamamisugetama ani komule amavaletama moma-tesageꞋya yagai-lama hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","HigeꞋya vayaꞋyamoꞋya ani yafa kateꞋma malenaya yafana fukiteti aye-gaꞋmaeꞋya ai-lileteꞋya nagoꞋa ati vayafe “Yagaiho.” huꞋya hu-ma-tenae. ");
INSERT INTO kmu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sapati kanamoꞋa haꞋno hu-tegeno Sota yupa kola otinegeꞋya Magatala MaliaꞋene hamoꞋamoꞋene he-vai-taya komulega agegahe umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","NeꞋvaꞋageno tusiꞋa imi aligeno Anumayamo ensole kanoa ikapinagati elavino ani yafakefa ayetu-fe-neꞋataleno agupile mopale maine. ");
INSERT INTO kmu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mainegeno augosamoꞋa aulumayaꞋma alia kava huno aye-vasa higeno kenaꞋamoꞋa efeꞋage huno alave alave hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","HigeꞋya he-vai-taya yafakateꞋma yagaiꞋya maiya ati vayaꞋmoꞋya ani ensole kanoa ageteꞋya atili huꞋya amakoꞋya faiteꞋya fali-mainaya vaya kana hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hageno ensole kanomoꞋa ani atalafena mage huno hie “Tanakaila tanamaꞋyoa oꞋaino. Nagaya ago havimainoe tanakaya Yisasina, yafaga yosale nilima heꞋya asai-malenaya kanohe ati-neꞋayaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mafina omainegi fali-mainefitila ago heti-maine. Tamaha-pai-mainea kemoꞋa falote higeno ago he-ti-mainegi etana malenaya kumala ma hanegi megeꞋo. ");
INSERT INTO kmu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Megetetana tanaiyayetana agaiꞋaenema tokaeꞋya nemaiya anagala mage hutana mo hama-paiꞋo ‘YisasiꞋa ofalino afaꞋama maineno tamaha-pai-mainea kea haviho. Uhagotela-mateno Kalili ago umainegi anilega neꞋutama Yisasina mogeho.’ hutana hiꞋo. Hai tanaha-pauve.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","HigeꞋana tolemogania anamaꞋyoa neꞋaiꞋana musena nehuꞋana anaiyayeꞋana agaiꞋaenema tokaeꞋya nemaiya anaga mo hama-paigahe umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","NeꞋvaꞋageno anile aupaꞋa YisasiꞋene fotu mo haꞋageno YisasiꞋa mage huno hanapaiye “NeꞋaꞋo?” huno higeꞋana eꞋana aiyale metafa huꞋana ali soso haꞋe. ");
INSERT INTO kmu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","HaꞋageno YisasiꞋa mage huno hie “TanamaꞋyoa oꞋaitana mage hutana nafuꞋnaganagamina mo hama-paiꞋo ‘Kalili neꞋutama anilega mo nagegahae.’ hutana hama-paiꞋo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tole atalana yaufa neꞋvaꞋageꞋya nagoꞋa komuleꞋma yagai-maiya ati vayala ala kumate uꞋya ala mono note kava vayafena mukiꞋa yama faloteꞋma hia yafena mo hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mo hageꞋya ala mono note kava vayaꞋene Yuta vayatamaene melitalu huꞋya huge havige huteꞋya hu-haꞋya kiteꞋya ani ati vayaꞋmogamina ala mone hageꞋya neꞋamamiꞋya “Mani kea hutama falote ohisaya yafe ma monea negeno haꞋno hino.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","HuteꞋya mage huꞋya hae “Tamakaya veafena mage hutama hiho ‘YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya kege ayaꞋamoꞋya faeta mainonageꞋya augafa musufaya huꞋya aliꞋya vae.’ hutama hiho. ");
INSERT INTO kmu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ala kamani kanomoꞋa mani kema haya kea haviteno kema tamama-kisiana tagaya ali fala-ki-lama-teta ‘Amakaipina kea omale.’ huta alu kema hapaisunanagenoꞋa kea-otamama-kigahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","HageꞋya ati vayaꞋmoꞋya ani monea aliteꞋya ma ma hama-paiya kemo akave malageno mukiꞋa Yuta vea mainalega mani kemoꞋa ute ete huno menia aniꞋa huno hane. ");
INSERT INTO kmu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yisasina aleveniꞋa (11) anagaꞋmoꞋya Kalili agoꞋyalega umainae. ");
INSERT INTO kmu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Valegati Yisasina mogeteꞋya agia alisaga hayanagi nagoꞋamoꞋya tole amakesa havimainae. ");
INSERT INTO kmu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","19","YisasiꞋa ani vaya mainale emaineno mage huno hie “Anumaya KotiꞋa ikategaene mopafiꞋene tusiꞋa kava yagaisua tokiya yana ago namiafe tamakaya mukiꞋa ma mopaene mopaene neꞋutama nagai kea hama-paigeꞋya amakuꞋa namisagetamahena Nenafa agileꞋene nafaꞋneꞋamoni nagileꞋene Alu Aotage Avamumo agileꞋene tina fale-ma-teho. ");
INSERT INTO kmu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tina fale-ma-tetama nagayama tamaha-pai-mainoa kea ‘Akave maleho.’ hutama huge hama-velige hiho. Tamage nagaya tamakaiꞋene mukiꞋa kanafina maime maime neꞋvisugeno ma mopama haꞋno hisia kanamoꞋa falote hugahianagiꞋna otama-talegahue.” huno YisasiꞋa hu-maine. ");
INSERT INTO kmu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yisasi KalaisiꞋa Anumaya Kotina neꞋamofena kanale kea mage huno aepa hie. ");
INSERT INTO kmu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anumaya Koti aune kanoa AisaiyaꞋa mage huno kaemaleneane Anumaya KotiꞋa mage huno hie “Haviho ke hamapaisia kanoꞋnia Yisasi aulega hagoteꞋna hutesugeno kana valino hilato hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","KaꞋme kotegati nago kanomoꞋa keha keha huno mage hugahie “Anumayamo esia kana ali hilato hutama fatago hiho.” huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","YoniꞋa ti faleneꞋamatea kanoa evaꞋyi huno kaꞋme kotega maineno mage huno hie “Tamakaya tamakuꞋa aiyahae hutama kefo yatamia ‘NagoꞋene ohugahune.’ hutama ataletesageꞋna tina falelamatesugeno Anumaya KotiꞋa kefo yatamia aigetamateno atalelamategahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ani yupa Yelusalemu veaꞋene Yutia kotega veaꞋene Yoni mainelega umaineꞋya kefo yaꞋamihena hufalote hageno YoniꞋa Yotani lipi tina falematene. ");
INSERT INTO kmu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","YoniꞋa kemolu afumo ayolagefaleti kenaꞋa fakaꞋnino failineno amuꞋnofila pulamakamo augafaleti ayetalako huno kilineno kaveꞋa kenuꞋene tumemo timaꞋaene neneane. ");
INSERT INTO kmu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mage huno hamapaiye “Nakavela nago kanoa ago egahie. Ani kanoa tusiꞋa tokiya yamaꞋa hanea kanogino nagaila ago nagaseno maigeꞋna nagaya afa kano mainoanagiꞋna agai aiyale ayesuana onategahie. ");
INSERT INTO kmu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nagaya titeti falenelamatoanagino ani kanomoꞋa Anumaya Kotina Alu Aotage AvamuꞋaleti falelamategahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ani kanafina YisasiꞋa Kalili kotega hanea kumala Nasaleti kumateti egeno YoniꞋa Yisasina Yotani lipi tina faletene. ");
INSERT INTO kmu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tina faleneꞋategeno YisasiꞋa tipinagati aivati huno aupaꞋa ageana ikamoꞋa aihagalo higeno Anumaya Koti Alu Aotage AvamuꞋmoꞋa nama kana huno agaitega elavimaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Elavigeno ikapinagati nagola agea aino mage huno hie “Kagaya nagaiꞋni nafaꞋnemoga kagaifena aluya huno nahau nayamopafi nenagea neꞋnimoga kagaifena aluya huꞋna musekaꞋa nehue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Anumaya Kotina Alu Aotage AvamuꞋamoꞋa Yisasina veaꞋne omai kaꞋme kotega anatino umaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Umainegeno SataniꞋa* Yisasife “Havi kava huo.” huno ayevataga higeno fotiꞋa (40) yupa YisasiꞋa ani kotega afela afuyagaene mainegeꞋya ensole anagaꞋmoꞋya meya huꞋya kava hutenae. ");
INSERT INTO kmu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yonina nofi hutenageno YisasiꞋa Kalili kotega Anumaya Koti kanale kea mo hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","YisasiꞋa mage huno hie “Anumayamo malenea kanamoꞋa ago evaꞋyi humainegi Anumaya Koti yagailamatesia kanamoꞋa aupaꞋa evaꞋyi hisia yafe tamakaya tamakuꞋa aiyahae hutama kefo yatamia ataletetama nagaifena kanale kea humainea kemoꞋa ‘Tamage humaine.’ hutama tamakupi maletama tamametitia hiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","YisasiꞋa Kalili ti kotumo agegayalega neꞋuno Saimonina aganaꞋamoꞋene EtaluꞋene anakeana noyame kuꞋya nehaꞋa kanolana maineꞋana ala kukonogo ti kotupi hagaꞋyu huꞋana nemalaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","YisasiꞋa mage huno hanapaiye “Nakave eꞋo. Nakave esaꞋageꞋna noyame kuꞋyama haꞋa kava huꞋna vaya kuꞋya hulanategahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","HigeꞋana aupaꞋa kukonogoꞋania neꞋataleꞋana Yisasi akave umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","VaꞋageno YisasiꞋa nagoꞋene neꞋuno Sepetina netalamaꞋamogania YemesiꞋene YoniꞋene tipi kalefi maineꞋana kukonogo nefakaꞋniꞋageno YisasiꞋa monake. ");
INSERT INTO kmu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Anaketeno YisasiꞋa ke higeꞋana Sepetia neꞋanafaꞋene aliꞋya vayaꞋaene tipi kalefiti neꞋamataleꞋana Yisasina akave vaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kapaneamu kumate taviteꞋya YisasiꞋa Sapati yupa mono nopi haino Anumaya Koti ke humavelie. ");
INSERT INTO kmu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","HumaveligenoꞋa agai kemoꞋa toꞋkiya yamaꞋa hanea kanomo ke kana hia yafena tusiꞋa amamaꞋyo aigeꞋya mage hae “NagoꞋa kahegi kema havilinaya anagaꞋmoꞋya nehaya avamete ke nehie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Anile nago kanoa Kefo AvamuꞋmoꞋa aguꞋafi falemainea kanoa mono nopi emaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Emaineno ala kenake huno mage hie “Avo Yisasigae Nasaleti kumate nafaꞋnemoga naꞋa hulategane? Tagaila tahaeka falilategahe emainano? Nagaya kagaifena ago havimainoe kagaya alu aotage kanoa Anumaya Koti hugatenea kano mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Higeno YisasiꞋa Kefo Avamufena tokiyaꞋage ke huno mage hie “Kea ohuka maiyo. Mani kanoa ataleka agusafinagati vuo.” huno hutene. ");
INSERT INTO kmu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Higeno ani Kefo AvamuꞋmoꞋa moyege meyege huteteno kasageke hia kava huteteno alakenake huno agusafiti ataleno hatilavimaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","VigeꞋya mukiꞋa vayala amamaꞋyo aigeꞋya huge havige huꞋya mage hae “Na kava nehie? Na augafa haekafa ke nehie? TusiꞋa toꞋkiyaleti anumayaꞋage ke higeꞋya Kefo AvamuꞋmoꞋya agai kea ali hipoꞋya huꞋya hatilaviꞋya vae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hageno YisasiꞋma humainea avagemoꞋa mukiꞋa Kalili kotega ute ete higeꞋya mukiꞋa veaꞋmoꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","YisasiꞋa YemesiꞋene YoniꞋene mono nona ataleꞋya anileti Saimonigani Etalugani nopinaga umainae. ");
INSERT INTO kmu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Umainageno Saimonina aꞋamona itaꞋamo alekanoa amukonako kali neꞋaligeno YisasiꞋa uvaꞋyi higeꞋya aupaꞋa ani alekanohe Yisasina hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hapaigeno YisasiꞋa agaite eno ayate alino hetitegeno amukonako kaliꞋamoꞋa agola kanale hutegeno kavela kaeno amamine. ");
INSERT INTO kmu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Unena yagea tavifalegahe higeꞋya veaꞋmoꞋya kasagoꞋya kali veaꞋnea Kefo AvamuꞋmoꞋya amakuꞋafima ali haviya nehia veaꞋnea Yisasite amavaleꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","MukiꞋa ani kumate veala fiate elitalu humainae. ");
INSERT INTO kmu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","YisasiꞋa havigu havagu kali neꞋaliya veaꞋnene ali hilato humateno mukiꞋa Kefo AvamuꞋmola amakuꞋafiti amanatitalegeꞋya Kefo AvamuꞋmoꞋya Yisasina agoꞋma agemainaya yafe YisasiꞋa mage huno hamapaiye “Mani yafena kea ohiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Natena tani kotigeno YisasiꞋa hetino ani nona ataleno vaya omai kotega umaineno nunamuna humaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","UmainegeꞋya SaimoniꞋene nagoꞋa anagaꞋamoꞋyaene agaife aiyaka maeꞋya agaitega uꞋya mage huꞋya mo hae “MukiꞋa veaꞋmoꞋya kagaifena katineꞋayae.” huꞋya hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hapaigeno YisasiꞋa mage huno hamapaiye. “Alu kumate kumate vigetao nagaya mono kea mo hamapaigahue. Mono kema hamapaisua yafe nagaya emainoe.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","MukiꞋa Kalili kotega viaꞋyamo mono nopi Anumaya Koti kea hamapaino Kefo Avamula veaꞋmogami amakuꞋafiti amanatitalene. ");
INSERT INTO kmu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nagola fugitayamo augafa alino haꞋyagino atalako humainea kanomoꞋa Yisasite mepe huno mage huno hapaiye “Kahaisigekasina nagaila ago ali hilato hunatateꞋasine.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Higeno YisasiꞋa kalagi aiteteno ayana haꞋyo huno augafale avate nehuno mage huno hie “NahaigeꞋna kaugafamoꞋa menia kanale hino huꞋna nehue.” huno higeno anile aupaꞋa kaliꞋamoꞋa haꞋno hutene. ");
INSERT INTO kmu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","HaꞋno hutetegeno YisasiꞋa mage huno hapaiye “AupaꞋa visanaꞋamoga ali hilato hugatoa yafena nago kanoa haꞋopaika mono nopi kava kanomote uka mukiꞋa veala kalikaꞋama aliꞋna kanale hugatoa kema havinuꞋyahena mono nopi kava kanomoꞋa kaugafa kamota huno kagetesigeka kaugafama ali kanale hugatoa yafena MoseseꞋa ‘Ma yama Anumaya Kotina amio.’ huno humainea yana Anumaya Kotina momio.” huno toꞋkiyaꞋage ke hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hapaiyanagi ani kanomoꞋa viaꞋamo kanaleꞋma hutea avagea alu kumate kumate hamapaigeꞋya kasagoꞋya veaꞋne haviteꞋya “Kalitia alino kanale hulatesie.” huꞋya Yisasite emainae. Aya yafe YisasiꞋa fufuꞋyate visia kana omalegeno amataleno vaya omai kotega umainegeꞋya alu kumateti kumateti veala Yisasite emainae. ");
INSERT INTO kmu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","YisasiꞋa aupa kana kanoꞋa maiteno Kapaneamu kumate eteno nomaꞋafi “Emaine.” haya kea veaꞋmoꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","HaviteꞋya veaꞋmoꞋya melitalu hageno nomaꞋafiꞋene nosiꞋmekaenena hiya higeꞋya nagoꞋa veala fiategaenena maisaya yana omalegeno YisasiꞋa Anumaya Koti kanale mono kea hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","HamanepaigeꞋya foꞋa (4) vayaꞋmoꞋya nago kanoa aiya aya falimainea kanoa hagifanale avaleꞋya faeteteꞋya Yisasite avaleꞋya ae. ");
INSERT INTO kmu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ayana kasagoꞋya vea hiya haya yafe kana omalegeꞋya nogatofulega haiteꞋya Yisasi maineamaꞋaleti hanae yosa alisaga humaleneꞋya ani hagifanale kali kanoa atalageno Yisasina avate elavimaine. ");
INSERT INTO kmu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Elavigeno YisasiꞋa “Ma vayaꞋmoꞋya nagaife haviꞋya amakupi maleꞋya amametiti hae.” agesa haviteno kali kanohe mage hie “NafaꞋneꞋnimoga nagaya kahanepauve ago aigekateꞋna kefo yakaꞋa atalegatoe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","HigeꞋya kahegi kema havilinaya anagaꞋmoꞋya anile mopale emaineꞋya amakaiꞋami amakuꞋafiti mage hae “NaꞋa higeno mani kea nehie? Ma kanomoꞋa Anumaya Kotifena huhaviya huneꞋate. NagoꞋa vayaꞋmoꞋya aigetateꞋya kefo yatia ataleotategahayanagi Anumaya KotiꞋa agaiꞋage aigetateno kefo yatia atalelatesia kanoa maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hageno YisasiꞋa aupaꞋa amakuꞋafinaga haviya kea agupi ago haviteno mage huno hie “NaꞋa higetama mani kea tamaku tamakesafinaga nehaviye? ");
INSERT INTO kmu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nagayama huꞋna hisua kea hana kemo kanaꞋagela humaine? ‘AigekateꞋna kefo yakaꞋa atalenegatoe.’ huꞋna hisua kemoꞋo? Ifi kali kanomofe ‘Hetika hagifanakaꞋa alisaga hulika vuo.’ huꞋna hisua kemoꞋo? ");
INSERT INTO kmu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna ma mopale maineꞋna kefo yafe aigetamateꞋna kefo yatamia atalelamatesua tokiyaꞋnia hanea yafema havisaya yafe nago kavala huꞋna tamaveligahue.” nehuno kalima alia kanohena mage huno hie “Hetika hagifanakaꞋa neꞋalika nokalega vuo.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Higeno ani kali kanomoꞋa aupaꞋa mukiꞋa vea amaulagafi hetino hagifanaꞋa neꞋalino hatilavimaine. Hetino via yafe mukiꞋa melitalu huꞋya mainaya veaꞋmoꞋya tusiꞋa amamaꞋyo aigeꞋya Anumaya Koti agia alisaga nehuꞋya mage huꞋya hae “Menia ma yupa noꞋagona tokiyaꞋage yana neꞋagone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","YisasiꞋa amataleno Kalili tikotumo agegayalega neꞋvigeꞋya mukiꞋa veaꞋmoꞋya agaitega molitalu hageno YisasiꞋa humavelie. ");
INSERT INTO kmu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Vilegati nago kanoa mogeana ani kanomo agia LivaiꞋe Alafiusi nafaꞋnea mogeanagi LivaiꞋa musufa ya huno vaya amaugafaleti takisi mone aliliteno nehia kanogino opisi nomaꞋale mopale mainegeno YisasiꞋa ani kanoa mogeteno mage huno hapaiye “Kagaya nakave eno.” huno higeno LivaiꞋa hetino Yisasina akave umaine. ");
INSERT INTO kmu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Haenaga YisasiꞋa Livaina nomaꞋafi kave mo nenegeꞋya mukiꞋa musufaya huꞋya amaugafaleti takisi mone neꞋaliya vayaꞋene nagoꞋa kefo yama nehaya vayaꞋene YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋyaene ani nopina tokaeꞋya maineꞋya kavela nenae. Ani yupa kasagoꞋya vayaꞋmoꞋya Yisasi kea haviteꞋya akave umainae. ");
INSERT INTO kmu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","YisasiꞋa ani kefo yama nehaya vayaꞋene vaya amaugafaleti takisi miya neꞋaliya vayaꞋene kave nenegeꞋya nagoꞋa kahegi kema havilinaya Falasia vayaꞋmoꞋya mogeteꞋya YisasiꞋene tokaeꞋya nemaiya anagafe mage huꞋya hae “NaꞋa higeno YisasiꞋa amaugafaleti takisi monema neꞋaliya vayaꞋene kefo yama nehaya vayaꞋenena kavela nene?” huꞋya hamavigae. ");
INSERT INTO kmu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hamavigageno YisasiꞋa ani kea ago haviteno kenonaꞋamia mage huno hamapaiye “AfaꞋa kalima noꞋaliya veaꞋmoꞋya tota kanalega oꞋugahagi kali veake tota kanalega ugahae. ‘Fatago vea mainone.’ huꞋya nehaya veafe ke hugahe nagaya omenogi kefo yama nehaya veafe ke hugahe emainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nago yupa YoniꞋene tokaeꞋya nemaiya anagaꞋmoꞋyaene Falasia vayaꞋmoꞋyaene* kave monesiya yafe nagoꞋa vayala Yisasite eꞋya mage huꞋya havigae “NaꞋa higeꞋya YoniꞋene tokaeꞋya nemaiya anagaꞋene Falasia vayaꞋene kavela mosiꞋya nemaiyanagi kagaiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya kavela nege nege huꞋya nemaiye?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hageno YisasiꞋa mage huno hie “Nago kanomo aꞋma faiꞋya esageno avaya heno nesia imu kisia yupa vayaꞋamoꞋyaene toꞋkaeꞋyama maisayana ani vayaꞋmoꞋya kavela mosisao? AꞋao ani kanoa maineanagiꞋya moꞋosigahae. ");
INSERT INTO kmu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","MoꞋosigahagi haenaga alu kana falote hisigeꞋya kame vayamoꞋya aꞋma alisia kanoa atafa huꞋya amakaipiti avalesageꞋya ani kanafina mainesaya vayaꞋamoꞋya hamau huteteꞋya mosigahae. ");
INSERT INTO kmu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nago kanomoꞋa haegafa kena alino atafa kenalela maleno ohatigahie. Maleno hatisiana haegafa kenamoꞋa taga huno ali haviya hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nago kanomoꞋa haegafa nofi alagamo timaꞋa takino atafa mememo augafa ti keꞋayopina otakigahie. Takisiana ani limoꞋa kaꞋnuka hesigeno ti kena falo huno takilavinageno ani liꞋene keꞋayoꞋene ali haviya hugahie. Haegafa nofi alagamo timaꞋa hefino haegafa meme augafamo ti keꞋayopi takino vaino.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nago Sapati yupa YisasiꞋene agaiꞋaenema tokaeꞋya nemaiya anagaꞋene atili hoyafi neꞋuꞋya atilia kalemainae. ");
INSERT INTO kmu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","NegalageꞋya nagoꞋa Falasia vayaꞋmoꞋya ageteꞋya Yisasife mage huꞋya hae “Ago Sapati yupahena nagalu humalenaya kea neꞋatagayae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hageno YisasiꞋa mage huno hie “Tamakaya TevitiꞋa agaiꞋma avagi huꞋya vaya vayaꞋene amakategeꞋya humainaya yafena nayoma kaemalenaya kea hapalitama ohavinayanagitama nehao? ");
INSERT INTO kmu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Amakategeno Anumaya Koti nopi haino afa vayaꞋmoꞋya onegahae mono note kava vayala* amakaiꞋamige negahae.’ huꞋya nagalu humalenaya kavela Anumaya Koti aulagale malenaya kaihame maya TevitiꞋa neneno tokaeꞋya umainaya vayaꞋaene amamigeꞋya nemainae.” huno humaine. Ani kanafina ApiataꞋa ala mono note uhagote mainea kava kano mainea kanafine. ");
INSERT INTO kmu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","YisasiꞋa Falasia vayafe mage huno hamapaiye “VayaꞋmoꞋya maifalu hisaya kana Anumaya KotiꞋa Sapati kana talo humalenegi veaꞋmoꞋya ani kanamona atafa hisaya yafe veala talo ohune. ");
INSERT INTO kmu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna Sapati kanamona kava yagaimainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","YisasiꞋa nago yupa mono nopi haino mainegeno nago kanoa ayamo falimainea kanoa anile maine. ");
INSERT INTO kmu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","MainegeꞋya nagoꞋa vayaꞋmoꞋya YisasiꞋma havi kavaꞋma hisiafene huꞋya amata huꞋya mainageno “YisasiꞋa Sapati yupa ani kali kanoa alino kanale hutesio.” huꞋya Yisasina amata huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Amata huꞋya mainageno YisasiꞋa ayama falimainea kanomofe mage huno hapaiye “Hetika vaya amuꞋnopi me hetio.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hapaiteno YisasiꞋa amata huꞋya maiya vayafena mage huno hie “Tamahavigoe Sapati yupama hisaya yafena mono kemoꞋa naꞋane humaine? Sapati yupa vayala aliꞋya kanale humategahao ifi ali haviya humategahae? Sapati yupa veala amavaleꞋya avina me matesao ifi veala tavata hamaegahae?” huno hamavigegeꞋya kea ohuꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kea ohuꞋya maigeno YisasiꞋa mukiꞋa vaya amaulagafi moge mege hiana mukiꞋamogami amakuꞋmoꞋa atalako hia yafe aipamoꞋa kana higeno kali kanomofe mage huno hapaiye “Kayana aipi huo.” huno higeno aipi hiana ayamoꞋa kanale hutene. ");
INSERT INTO kmu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","KanaleꞋma hutea yafena Falasia vayaꞋmoꞋya mono nona neꞋataleꞋya Heloti vayaꞋene alitalu huꞋya huge havige huteꞋya “Yisasina hanaꞋa huta haesunageno falisie.” huꞋya vege humainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","YisasiꞋene agaiꞋaenema tokaeꞋya nemaiya anagaꞋaene Kalili ti kotumo agegaya neꞋvageꞋya kasagoꞋya veaꞋne Kaliliti akave vae. YutiatiꞋene YelusalemutiꞋene ItumeatiꞋene Yotani tifaligati veaꞋnene TaiyatiꞋene SaitonitiꞋene mukiꞋa veala YisasiꞋma hia avageꞋa haviteꞋya agaitega vae. ");
INSERT INTO kmu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","NeꞋvageno agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hamapaiye “MukiꞋa alitalu haya veaꞋmoꞋya nagaila ayenatunefayafe tipi kalea talo tala hunateho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","KasagoꞋya veala kaliꞋamia alino kanale humatea yafe mukiꞋa kali veaꞋmoꞋya Yisasi augafale avate hugahe ayetufeliꞋya vae. ");
INSERT INTO kmu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","NeꞋvageꞋya Kefo AvamuꞋmoꞋya vea amakusafi maineꞋya ageteꞋya Yisasina aulegati mopafi amakoꞋya meyeꞋya ala kenake huꞋya mage hae “Kagaya Anumaya Kotina nafaꞋneꞋamoga mainane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hageno YisasiꞋa tokiyaꞋage ke huno mage hie “Ani kea nagoꞋa veala hamaopaiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","YisasiꞋa agoꞋyafi haiteno haiya vayafe ke higeꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ageno ani vayapiti tuelufuꞋa (12) vaya hapalimateteno agaiꞋaenema tokaeꞋya maisaya yafeꞋene agai kema huhaleꞋya hisaya yafeꞋene hapalimatene. Hapaliteno tokiyaꞋa neꞋamamino Kefo Avamula veaꞋmogami amakusafiti amanatitalesaya yafeꞋene hapalimatene. Mage huno hamapaiye “Nagai kema havigeꞋna hulamatoa vayala (Aposolo vaya)* maiho.” huno hapalimatene. ");
INSERT INTO kmu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ani tuelufuꞋa (12) anagaꞋmogami amakia SaimoniꞋe kanomo agia YisasiꞋa PitaꞋe huno malene. ");
INSERT INTO kmu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","YemesiꞋene aganaꞋamoꞋa YoniꞋene Sepetina neꞋamogania YisasiꞋa anakia PoanesiꞋe huno malene. Ani anakimoꞋa tagai kefina monagemoꞋma hia avamete huꞋana tokiyaꞋage ke nehaꞋa kanolatane huno anakia malene. ");
INSERT INTO kmu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","EtaluꞋe FilipiꞋe PatolomiuꞋe MatiuꞋe TomasiꞋene YemesiꞋa Alafiusi nafaꞋnene TatiusiꞋene Saimonina hamoꞋamoꞋa nago agia SelotiꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yutasi IsakaliotiꞋa Yisasina haenagaꞋa agesi huno kame vaya amayapi avaleno atesia kanoe. ");
INSERT INTO kmu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","YisasiꞋa nomaꞋalega umainegeꞋya mukiꞋa veala Yisasite elitalu hageno YisasiꞋaene tokaeꞋya nemaiya anagaꞋene kave negahe haya yapi veala mehiya hageꞋya onenae. ");
INSERT INTO kmu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","AgaiꞋa konaga afamoꞋamoꞋya haviteꞋya Yisasife “Aifonafo nehie.” huꞋya Yisasina avalegahe emainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yelusalemu kumateti kahegi kema havilinaya anagaꞋmoꞋya Yisasife mage huꞋya mehae “Kefo AvamuꞋma kava humainea kanoa PielesepulimoꞋa agupi maineno tokiya amigeno Kefo Avamula anatineꞋatale.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hageno YisasiꞋa haviteno “Nagaite eho.” huno ke higeꞋya ageno avame kefiti mage huno hamapaiye “SataniꞋa hanaꞋa huno Satanina anatitalegahie? ");
INSERT INTO kmu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nagoke kotega veaꞋmoꞋya ali fako huꞋya “Alu vea mainone.” huꞋya tuma hisayana ani kotega veaꞋnenena haꞋno hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nagoke afamoꞋmoꞋya ali fako huꞋya “Alu anaga mainone.” huꞋya tuma hisayana ani afamola haꞋno hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","HaꞋno hugahagi Satani anagaꞋmoꞋya ali fako huꞋya “Alu vaya mainone.” huꞋya hisayana Satani kava yagaisia tokiyaꞋa omalegahianagino haviya huno haꞋno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nagola tokiya kanomoꞋa nomaꞋafima yagaino mainesigenoꞋa nago kanomoꞋa musufa yama hugahe vinunoꞋa hagoteno ani tokiya kanomona nofiteti kitalako huteteno afenoꞋyamaꞋa musufa yana hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","NaꞋa humaineafe nagaya tamage huꞋna tamahanepauve veaꞋmoꞋya mukiꞋa alu kefo yama alu kefo yaꞋene huhaviya humate yaꞋene hisayana Anumaya KotiꞋa aigetamateno kefo yana atalelamategahianagi nagoꞋa veaꞋmo Alu Aotage Avamufema huhaviya hutesayana Anumaya KotiꞋa aigeoꞋamategahianagi ani kefo yamaꞋa hanege hanege huno hanegahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","HigeꞋya “Kefo AvamuꞋmoꞋa YisasiꞋna agupi maine.” huꞋya haya kehe YisasiꞋa ani kea huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yisasina itaꞋamoꞋene aganaꞋamoꞋyaene eꞋya kumatega me hetiꞋya maineꞋya nago kanoa hutageno Yisasife ke hie. ");
INSERT INTO kmu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ke higeꞋya mukiꞋa veala elitalu huꞋya Yisasina aiyafi mopale maineꞋya agaife mage huꞋya hae “ItakamoꞋene kaganakamoꞋyaene kumatega emaineꞋya kagaife ke nehae.” huꞋya hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hapaigeno YisasiꞋa mage huno hie “ItaꞋnimoꞋene naganaꞋnimoꞋya taꞋya mainae?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hamavigeno agaiꞋenema mopale mainaya veala momake memake huno amaketeno mage huno hie “ItaꞋnimoꞋyaene naganaꞋnimoꞋyaenena ma ma nagaiꞋene mopale mainae. ");
INSERT INTO kmu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anumaya Koti kema haviteꞋya haiya kavaꞋma nehaya veala itaꞋnimoꞋya naganaꞋnimoꞋya nasaꞋnimoꞋya mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","YisasiꞋa tikotumo agegayalega umaineno nagoꞋene humaveligeꞋya kasagoꞋya veaꞋnea agaite elitalu huꞋya yageꞋyage haya yafe tipi kalefi haisaga humaino mopale maiteno ti amuꞋnopi umainegeꞋya yageꞋyage haya veaꞋmoꞋya ti agegayalega hetiꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","HetiꞋya mainageno YisasiꞋa alu ke alu kea avame kefiti mage huno hamapaiye “Haviho nago kanomoꞋa avina hanaigahe vie. ");
INSERT INTO kmu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Avina yamaꞋa alino aihelafino nehanaigeno nagoꞋa avinamoꞋa kapi tavino hanegeꞋya namayagamoꞋya me neꞋya haꞋno hae. ");
INSERT INTO kmu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","NagoꞋa avinamoꞋya yafa mopafi taviteꞋya osiꞋa mopa hanea yafe aupaꞋa hagemainae. ");
INSERT INTO kmu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hagayanagi yagemoꞋa teno amukonako higeno hafuꞋya omalea yafe fayoteꞋya asagaliye. ");
INSERT INTO kmu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","NagoꞋa avinamoꞋa avetanafa inomo amuꞋnopi tavino hageteno avetanafa inoꞋene tokaeꞋana haiteteꞋana avetanafa inomoꞋa ayetegeno haviya higeno alagaꞋa falote ohune. ");
INSERT INTO kmu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Falote ohunegi nagoꞋa avinamoꞋa kanale mopafi tavino hageteno ala huno alaga ayeana nagoꞋa avinamoꞋa tetiꞋa (30) alaga ayegeno nagoꞋa avinamoꞋa sikisitiꞋa (60) alaga ayegeno nagoꞋa yosalela kasagoꞋya vani hataletiꞋa (100) alaga ayeno vasaimai vasaimai humaine. ");
INSERT INTO kmu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tamakesama hanesigetama havilama hutama haviho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","MukiꞋa veala utageꞋya agaiꞋa tuelufuꞋa (12) anagaꞋamoꞋyaene nagoꞋa veaꞋene ani avame kemona aepaꞋahe havigae. ");
INSERT INTO kmu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Havigageno YisasiꞋa mage huno hamapaiye “Tamakaila Anumaya KotiꞋa kava yagailamatenea yafe falakimainea kea Anumaya KotiꞋa tamaya hinagetama havigahagi nagai kema nohaviya veala avame kekeꞋya hamanepauve. ");
INSERT INTO kmu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ani veaꞋmoꞋya ageme geme nehaiyanagi agelama huꞋya oꞋagegahae. Havime havime nehaiyanagi havilama huꞋya ohavigahae. Havilama ohisaya yafe avame kea hamanepauve. Havigu havilama huꞋya amakuꞋa aiyahae hisageno Anumaya KotiꞋa aigeꞋamateno kefo yaꞋami atalemateyafe nehue.” huno hie ");
INSERT INTO kmu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","YisasiꞋa mage huno hie “Mani avame kea havilama ohunao? MukiꞋa avame kea hanaꞋa hutama havigahae?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Avina yama hanaigahe via kanomoꞋa Yisasife kanale mono kea nefaiye. ");
INSERT INTO kmu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","NagoꞋa veaꞋmoꞋya kapi tavimainea avinamo avamete mainageno kanale kea faimalegeya maineꞋya Anumaya Koti kea haviyanagi amakupi omalesaya yafe SataniꞋa amakupitila ani kea melitalene. ");
INSERT INTO kmu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","AniꞋa huno yafa mopafima tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviꞋya aupaꞋa atafa huteꞋya muse hae. ");
INSERT INTO kmu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Muse hayanagi hafuꞋyamoꞋa mopafi otavinea yamoꞋa alige atalege veaꞋne maineꞋya osi kana kanoꞋa osiꞋa haviꞋya amakupi maletageno havi kanama falote nehiano Anumayamo kema haviya yafe veaꞋmoꞋya ali haviya humatesaya kanamoꞋma amakaite falote nehiano aupaꞋa Anumaya Koti kea neꞋatalae. ");
INSERT INTO kmu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","NagoꞋa avina avetanafa hanea inomo agusafi tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviteꞋya ma mopafi mukiꞋa yaꞋyagaꞋamihena amakesa haviꞋya moneꞋamima yokaloꞋamihena kalagi aigeꞋya ani yaꞋyagamoꞋa Anumaya Koti kea aliꞋya ayetalako huteꞋya atalageno alaga aye helafino tama nohie. ");
INSERT INTO kmu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tama nohianagi kanale mopafima tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviꞋya amakupi malageno ani alaga mukiꞋa aye henelafie. NagoꞋa veaꞋmoꞋya nagoke avina yosalela tetiꞋa (30) alaga ayemainae. NagoꞋa veaꞋmoꞋya nagoke avina yosalela sikisitiꞋa (60) alaga ayemainae. NagoꞋa avina yosalela vani hataletiꞋa (100) alaga ayemainae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hamapaiya yafe YisasiꞋa mage huno hamavige “NagoꞋa veaꞋmoꞋya lamua hanagaliꞋya susufaneletila aiso hunemalao ifi sipa kapinaga hanagaliꞋya aiso hunemalae? AꞋao aihalesia yafe sipale hanagaliꞋya nemalae. ");
INSERT INTO kmu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","HaenagaꞋa mukiꞋa falakimainesia yamoꞋa efalote hugahie. MukiꞋa kesi kava nehisaya yamoꞋa efalote hinageꞋya veaꞋmoꞋya agegahae. ");
INSERT INTO kmu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tamakesama hanesimogatama havilama hutama haviho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Huteno mage huno hie “Anumaya Koti kema havisaya yafena tamakesa havilama hutama haviho. Havisaya kea akave malesageno nagoꞋa kene tamahapaisigetama havigahae. ");
INSERT INTO kmu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Havilama huno havilinesia kanomona Anumaya KotiꞋa nagoꞋene havisia yana amigahianagi ‘Ago havilinoe.’ huno nehisia kanomona havilinesiamaꞋa hafalegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","YisasiꞋa mage huno hie “Anumaya Koti kava yagaimainea yamoꞋa maꞋa humaine. Nago kanomoꞋa avina yana hoyafi hanaemaleteno kegela mo faeteno feluga hetiteno huge hugeteana ani avinamoꞋa hanaꞋa huno falote huno ala nehia yamona aepaꞋa ani kanomoꞋa oꞋagene. ");
INSERT INTO kmu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","OꞋagenegi afaꞋa mopamoꞋa agaiꞋageꞋya nuna amigeno aifalo huno hageteno haisa falote huteno haenaga alaga ayeno afu nele. ");
INSERT INTO kmu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Akavi huteno afuma nelea kanamoꞋa ago evaꞋyi hia yafe aupaꞋa viaꞋyamo naepeleti hataga humaine. ");
INSERT INTO kmu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","YisasiꞋa mage huno hie “Anumaya KotiꞋa kava yagaimainea yamoꞋa hanaꞋa maine? NaꞋane huꞋna maꞋa huno hane huꞋna avame kefitila tamahapaisue? ");
INSERT INTO kmu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ma ma osi alagamo hia avamete humaine. Ani alagamo agia masatatie. Ani osi osi alagamoꞋa nagoꞋa yosalagama negaliya yosalagamoꞋa agaseno osi kanoꞋa hane. ");
INSERT INTO kmu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Osi osi humaineanagi kalimaletegeno hageno haiteno ala yosagefa haino mukiꞋa hoyafima hanea yosayaga amakaseno ayaꞋaya humainegeꞋya namayagamoꞋya akopatela noꞋamia me negiye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","YisasiꞋa aniꞋa huno kasagoꞋya avame kea alumo alumo huno amakupima havisaya avamete kea hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","YisasiꞋa vayaꞋyagaene maineno mukiꞋa kema hamapaiya kea avame kegeꞋya hamahapaiyanagi agaiꞋaenema tokaeꞋya nemaiya anagala amahaote mainageno hufalote huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ani yupa yagemoꞋa tavifalegahe higeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hie “Tikotumona atu faliga vigetao.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","HigeꞋya mukiꞋa elitalu humainaya veala neꞋamataleꞋya tipi kalefi haisaga humaiꞋya Yisasina avaleꞋya vageno nagoꞋa tipi kaleyagamoꞋya agai tipi kalene tokaeꞋya vae. ");
INSERT INTO kmu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","NeꞋvageno tusiꞋa yasimoꞋa alino timona aikalato kalato huno tipi kalefi atalegeno tipi kalefi havategahe hie. ");
INSERT INTO kmu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Havategahe higeno YisasiꞋa tipi kalemona akavelega tala yosale afita aino faemainegeꞋya agafa huꞋya mage hae “Hulavenelina kanomogae tikotupi asaga hulavita ti nakaita falisunageka kahauna huotategano?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hageno YisasiꞋa hetino ani limofeꞋene yasimofeꞋenena tokiyaꞋage ke huno “Taga huo.” higeno yasimoꞋene timoꞋenena taga huꞋana alava humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Alava higeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hie “NaꞋa higetama kolia nehae? Nagaife havitama tamakupi maletama tamametiti nehaya yamoꞋa kaleꞋyo humaineo?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","HamavigegeꞋya amamaꞋyo aiteꞋya huge havige huꞋya mage hae “Ma kanoa taꞋe? YasimoꞋene timoꞋene agai kea haviteꞋya akave nemalae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kalili ala tikotuna takaeꞋya ame agegayamona Kelasa* vea mainalega uvaꞋyi hae. ");
INSERT INTO kmu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","YisasiꞋa ani tipi kalea neꞋataleno ti agegayalega neꞋvigeno nago kanomona Kefo AvamuꞋmo agupi mainea kanomoꞋa matimatipinagati Yisasite emaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ani kanoa yafakapinaga nomaꞋa hanegeno anifinaga mainegeꞋya tokiyaꞋage seni nofiteti kitesaya vayala omainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","VayaꞋmoꞋya seni nofiteti aiya ayaꞋene kisalu kimalenageno ani nofila aigalu heneꞋataleno aiyafi nofila yafateti ailatapegeno nofila aikaꞋno higeno “Ako huka maiyo” huꞋya hapaisaya tokiyaꞋamima hanea vayala omainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Omaigeno ani kanomoꞋa nateꞋene kegeꞋene efi efi huno matimatipinagaene agoꞋyaleꞋene maineno tusi aviteno avovo nehuno yafateti agaiꞋa augafa aige talaga talagoma humainea yamoꞋa amumoꞋa tusiya humaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ani kanomoꞋa Yisasina ayaꞋayate neꞋegeno ageteno aiyayeno eno aiyafi aleꞋya meyeno mopafi maineno alisoso huneꞋate. ");
INSERT INTO kmu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","YisasiꞋa mage huno hie “Kefo AvamuꞋmogae agusafinagatila hatilavio.” huno hutea yafe ani kanomoꞋa ala kegefafiti mage huno hie “Yisasigae, ago tagaseno anale mainea Anumaya Kotina neꞋamogae, naꞋa hunategahe nehane? MusekaꞋa nehugi nagata aisia kavala huonato.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Higeno YisasiꞋa ani kanohena mage huno hie “Kagai kagia tagae?” huno havigegeno “Nagia KasagoꞋya-moꞋnae. MukiꞋa Kefo AvamuꞋmoꞋya nagupi haifaleꞋya mainaya yafe nagia KasagoꞋyamoꞋnae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huteno Yisasifena mage huno hie “MusekaꞋa nehue ma kumatetila Kefo Avamula humatesanageꞋya alulega oꞋvisae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","NehigeꞋya kasagoꞋya afuyagamoꞋya agoꞋyafi maineꞋya kave nenae. ");
INSERT INTO kmu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","NenageꞋya Kefo AvamuꞋmoꞋya Yisasife mage huꞋya havigae “Ani afuyagamo amakuꞋafi hulategeta vamano.” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Havigageno YisasiꞋa “AniꞋa hiho.” huno higeꞋya Kefo AvamuꞋmoꞋya ani kanomo agupitila hatilaviꞋya afuyagamogami amakupi haifalageno ani afuyagamoꞋya amaiyayeꞋya nagola aulufi kapi taviteꞋya tipi asaga hulaviꞋya ti nakaiꞋya fali haꞋno humainae. Afua tu tauseniꞋa (2,000) afuyaga fali haꞋno humainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Fali haꞋno hageꞋya ani afuyagale kava neꞋyagaiya vayala faleꞋya ala kumatega mainaya veaꞋneheꞋene hoyafinaga mainaya veaꞋneheꞋene “NaꞋa maꞋa higeta neꞋone.” huꞋya hamapaigeꞋya ani veala “Hia yana agesune.” nehuꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yisasite eꞋya kasagoꞋya Kefo AvamuꞋmoꞋma agupifiti hatilavino via kanomona agesa akalo higeno kenaꞋa failino anile mopale mainegeꞋya megeteꞋya koli hae. ");
INSERT INTO kmu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","YisasiꞋma humainea kavaꞋma agemainaya veaꞋmoꞋya naꞋa maꞋa huno Kefo Avamula agupima mainea kanoa alino kanale hutea yafeꞋene afuyagama humatea yafeꞋene hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","HamapaigeꞋya ani veaꞋmoꞋya Yisasifena “Tagaila tataleka ago vuo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","19","Hageno YisasiꞋa ugahe tipi kalefi haisaga hunemaigeno Kefo AvamuꞋma agupiti ataleno umainea kanomoꞋa Yisasifena “KagaiꞋene visuꞋe.” huno havigegeno YisasiꞋa “AꞋao kagaya nokalega visanaꞋamoga mukiꞋa AnumayamoꞋma aigekateno hugatea yafena vayakamogamina mo hamapaiyo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Higeno ani kanomoꞋa viaꞋyamo teniꞋa (10) ala kumaꞋyaga hanea kotega uno YisasiꞋma hutea yafena hamapaigeꞋya mukiꞋa veaꞋmoꞋya amamaꞋyoa aimainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","YisasiꞋa tipi kalefi asaga humaino tina lakaeno eteno ti agegayalega egeꞋya muki veaꞋmoꞋya agaite melitalu humainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Emainageno nagola soka kanoa, YailasiꞋe nehaya kanoa, emaineno Yisasina mogeteno aiyafi mope humaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mope humaineno tokiyaꞋage huno Yisasina mage huno havige “Vae nagai munala faligahe ayaya neꞋaigi kaya mo maletesanageno kanale hutesie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Higeno YisasiꞋa agaiꞋene vigeꞋya veala yageꞋyage huꞋya akave umainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vageno tuelufuꞋa (12) kafua mukiꞋa kanale aigu nopinaga nemaiya aala anile maine. ");
INSERT INTO kmu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","NagoꞋa tota vayate ute ete hugeteana agataiya kavala hageno moneꞋama amaminea yamoꞋa haꞋno higeno ani kaliꞋa nago kanomoꞋa ali kanale huoꞋatenegi kaliꞋamoꞋa ala humaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ani aꞋmoꞋa Yisasi avagea haviteno ani yageꞋyageꞋma haya veapi Yisasina akavelegati kenaꞋale mevate hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Avate nehuno agesa mage huno havie “KenaꞋale avate nehisugeno kaliꞋnimoꞋa haꞋno hunategahie.” huno agesafinaga havimaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Haviteno aniꞋa higeno aupaꞋa kolamoꞋa taꞋnegeno augafafinaga malegeno ageana kaliꞋamoꞋa ago kanale hutene. ");
INSERT INTO kmu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kanale huteanagi YisasiꞋa “NagoꞋa tokiyaꞋnia ago nataleno vie.” huno agesafinaga haviteno anifima alitalu humainaya veaꞋmogami amuꞋnopi maiyahae huno mage hie “Ta kenaꞋnilela mevate hie?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋamoꞋya mage hae “MukiꞋa veala yageꞋyage hageka neꞋaganagi naꞋa higeka na kea hamavinegane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hageno YisasiꞋa moge mege huno avate hia kanohe ati ayemaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ati neꞋayegeno ani aꞋmoꞋa kaliꞋa ago kanale hutegeno agea yafe koli huno atili huteno aiyafi mope huno YisasiꞋma hutea yafena tamage huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hapaigeno YisasiꞋa mage huno hie “AꞋmogae nagaifema havika kagupi maleka kametiti hanageno ago kalikaꞋamoꞋa kanale hugategi kaipamoꞋa yasi nehinageka afaꞋa vuo. KalikaꞋa agola haꞋno hie.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","HanepaigeꞋya nagoꞋa vayala soka kanoa, Yailasi notegati mage huꞋya me hapaiye “MunakamoꞋa ago falimainegi ataleka kava kanomona kasalo haegi nagoꞋene havioko.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hageno YisasiꞋa hapaiya kehena ohavisia agesa haviteno soka kanohena mage huno hie “Kolia ohuka nagaife havika kagupi maleka kametiti huo.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","MukiꞋa veafena omeho huneꞋamateno PitaꞋene YemesiꞋene nepuꞋamoꞋa YoniꞋene amavaleno umainae. ");
INSERT INTO kmu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Soka kanomo note uvaꞋyi huꞋya agayana mukiꞋa veala tusiꞋa avineꞋatageno YisasiꞋa nopi haifaleno amakaifena mage huno hie “NaꞋa higetama tusiꞋa avianeꞋatae? Ma munala ofalinegi afaꞋa faeno maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mani kea higeꞋya veaꞋmoꞋya faligeꞋyama agaya yafe kigiꞋa hutageno “Kumatega hatilavitama viho.” huno higeꞋya kumatega hatilavigeno YisasiꞋa itaꞋafoꞋamoganiene agaiꞋaenema vaya anagaꞋene amavaleno falimainea munaꞋma malalega amavaleno haimaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Haino umaineno ayate atafa hulineno agaiꞋa kefiti mage huno hie “Talita kumi.” huno hie. Tagaiti kefina “Ma munaꞋmoga kahanepaugi hetio.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Higeno aupaꞋa ani munaꞋmoꞋa hetino ute ete hie. Ago ala munalagino tuelufuꞋa (12) kafuꞋa hanea munalagino hetino ute ete higeꞋya anile mainaya veaꞋmoꞋya amamaꞋyo aiye. ");
INSERT INTO kmu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","AmamaꞋyo aigeno YisasiꞋa tokiyaꞋage ke huno “Anima agaya yafena veala hamaꞋopaiho” huno kahegi neꞋamateno “Kavela amiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","YisasiꞋa ani kumala ataleno viaꞋamo ko aepaꞋalega vigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya akave umainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapati yupa mono noꞋamifi haino Anumaya Koti kea mukiꞋa vayala hamapaigeꞋya haviteꞋya amamaꞋyo aigeꞋya mage huꞋya hae “MukiꞋa havi haviꞋyana hanateti alia kea nehie? Ayapitila tokiyaꞋage avame yama humainea tokiyaꞋa hanateti alimaine? ");
INSERT INTO kmu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mani kanoa no negia aliꞋyate kano maineanagi Malia nafaꞋne mainegi YemesiꞋene YoseseꞋene YutasiꞋene SaimoniꞋenena aganaꞋamoꞋya mainagi asaꞋamoꞋya tagaiꞋene nagopi mainae.” huꞋya huteꞋya amaipa kafa heteꞋya amakaveꞋno hutenae. ");
INSERT INTO kmu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","AmakaveꞋno hutayanagi YisasiꞋa mage huno hie “Anumaya Koti kema nehia kanomoꞋa mukiꞋa kumate mono huhaleno hamapaisiana agia alisaga nehagi kumaꞋale maisiana agaiꞋa afamoꞋene no kumaꞋale vayaꞋenena agia alisaga ohugahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mani kumatela ala tokiya avame yana ohunegi afaꞋa nagoke nagoke kali vayake aya malegeno kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kanale humatenegi afaꞋa mukiꞋa veala agaife haviꞋya amakupi maleꞋya amametiti ohaya yafe YisasiꞋa amaꞋyo aigeno alu kumate kumatela vaiyeno monola hamapaino humaveli maine. ");
INSERT INTO kmu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","YisasiꞋa tuelufuꞋa (12) anagaꞋamogamife ke higeꞋya ageno mukiꞋa Kefo AvamuꞋma veaꞋmogami amakupiti amanatitalesaya tokiya amamiteno mage hie “Tole ali lokaete lokaete hutama viho.” huno humatene. ");
INSERT INTO kmu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","HuneꞋamateno mage huno hie “Kama visayana ayopatamige alilitama viho. Kutamiene mayaene monetamiene alitama oꞋviho. ");
INSERT INTO kmu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamaiya nona vaigahayanaki tole siota vaioꞋaliho.” ");
INSERT INTO kmu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","NagoꞋene mage huno hie “Nago nopima haifalenutamahena ani nopi faetama maitama hutetama amataletama alu kumatela viho. Faelitetama ohiho. ");
INSERT INTO kmu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","NagoꞋa kumateꞋma visageꞋya veaꞋmoꞋya ali falu falama huotamateꞋya ‘Tamakai kema ohavigahune.’ huꞋya hisagetama ani kumala neꞋataletama ‘Havi kava hae.’ hutama hisaya yafe tamaiyafima hanesia kugukege mopa aihehe huneꞋataletama viho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","HamapaigeꞋya ani vayala neꞋuꞋya mukiꞋa veaꞋnehe mage huꞋya hae “Kefo yatamihena havitama tamakaye nehinagetama tamakuꞋa aiyahae hiho.” huꞋya hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","HamapaiꞋya mukiꞋa Kefo Avamula veaꞋmogami amakupitila amanati neꞋataleꞋya kasagoꞋya kali veala amaugafale masavena falematageno kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ani kanafina Yisasi avagemoꞋa ala higeno nagola sauve kanomo agia HelotiꞋe anima haya kea havimaine. NagoꞋa veaꞋmoꞋya Yisasifena mage huꞋya hae “Ma kanoa tima falematea YoniꞋe falimainefiti hetimaine. Hetimaineafe tokiyaꞋa hanegeno ma tokiya aliꞋyana neꞋalie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","HageꞋya nagoꞋa veaꞋmoꞋya Yisasifena mage huꞋya hae “Ma kanoa Ilaiya maine.” huꞋya hageꞋya nagoꞋa veaꞋmoꞋya “Aune kanoa nayo amaune vaya kana nehie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hageno HelotiꞋa haviteno mage huno hie “Yonina haeho huꞋna hugeꞋya ageꞋya hataga hutalenaya kanoa faliteno komufiti hetimaine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Helotina aganaꞋamo agia FilipiꞋe. Filipi aꞋmo agia HelotiasiꞋe. HelotiꞋa Helotiasina kumai a alitenea yafe YoniꞋa Helotife mage huno hie “Anumaya Koti kea atagaeka kaganakamo aala kumai a alitenane.” huno hia yafe HelotiꞋa vayala humategeꞋya Yonina motafa huꞋya avaleꞋya kina nopi hutenayane. ");
INSERT INTO kmu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Hutenageno HelotiasiꞋa Yonifena tusi hai vaiteteno haesageno falisia agesa havino maiyanagi HelotiꞋa agesa mage huno havimaine “YoniꞋa kefo yana ohuno fatago kanoa alu aotage kano maine.” huno havilinea yafe Yonifena koli huno “Ohaegahae.” huno auꞋneꞋvaino agai kea haviteno agesa kuꞋmo nehuno tole agesa havino afaꞋa muse huno keꞋa nehaviane. ");
INSERT INTO kmu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nago yupa Helotina atenea kanamoꞋa falote higeno HelotiꞋa ala imu kimaleteno mukiꞋa kamani kava vayaꞋene ati kava vayaꞋene Kalili kotegama afenomaꞋa kasago humainea vayaꞋyagaene ke higeꞋya imulega emainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Emainageno Helotiasina munaꞋamoꞋa eno amoneꞋayegeno HelotiꞋene vayaꞋamoꞋyaene neꞋageꞋya tusiꞋa musemaꞋa hageno HelotiꞋa ani munaꞋmofena mage huno hie “Kahaisia yafena afaꞋa hisanageꞋna kamigahue. ");
INSERT INTO kmu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Anumaya Koti aulagafi kahanepauve nagoꞋa yafema nahavigesanana afaꞋa kamigahue. Mone fenoꞋenefema nehuka mopaenefema hisanana afaꞋa nagai yaꞋyaga haneanagiꞋna amuꞋnopiti ali fako huꞋna kamigahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Higeno ani munaꞋmoꞋa viaꞋamo itaꞋamofena mage huno havige “Na kanohe ke huꞋna havigesue?” huno higeno itaꞋamoꞋa mage huno hie “YoniꞋa ti falemate kanomo ageꞋya fakaliteka anumaꞋa aifakalika me namio huka hapaiyo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Higeno aiyayeno ala sauve kanomotega viaꞋamo mage huno hapaiye “AupaꞋa ti falemate Yonina ageꞋya fakaliteka anumaꞋa yopafi maleka me namio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Higeno ala sauve kanomoꞋa haviteno aipamoꞋa tusiꞋa kanaꞋage higeno Anumaya Koti aulagafima huno lokiya vaimalea yafeꞋene maiya vayafeꞋene agesa haviteno mage huno hie “Ani munaꞋmo kea he falaꞋokigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Higeno aupa kanoꞋa nago ati kanoꞋa huteno mage huno hapaiye “Yonina ageꞋya mo fakalika anumaꞋa alika eno.” huno higeno kina nopi viaꞋamo Yoni ageꞋya mo fakalitalene. ");
INSERT INTO kmu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Fakaliteno anumaꞋa yopafi maleno alino eaꞋamo ani munaꞋmona memigeno itaꞋamona alino amine. ");
INSERT INTO kmu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","AmigeꞋya YoniꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya ani kea haviteꞋya uꞋya augafaꞋa moliꞋya yafakapi mo hevaitenae. ");
INSERT INTO kmu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposolo vayala Yisasitega eteꞋya mukiꞋa humainaya kavaꞋene humaveliya kene eꞋya me hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Me hanepaigeꞋya mukiꞋa veaꞋmoꞋya agaitega neꞋuꞋya neꞋeꞋya maiꞋya hageno YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya kaveꞋamima nesaya kanaꞋamia omalea yafe YisasiꞋa mage huno hie “Egeta tagaitige kaꞋme kotega umaifalu hamano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","HigeꞋya amakaiꞋamige tipi kalefi haisaga humaiꞋya kaꞋme kotega ugahe umainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","VageꞋya mukiꞋa veaꞋmoꞋya amaketeꞋya amaugosafina ago agemainaya vayalegiꞋya kumaꞋamileti mopafi amaiya yeꞋya uhagoteꞋya ani kaꞋme kotega uvaꞋyi humainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","UvaꞋyi hageno YisasiꞋa tipi kalefiti asaga hulavino ageana mukiꞋa veaꞋnea elitalu humaiya veala amaketeno agesa mage huno havie “Ma veaꞋnea sipi sipi kana huꞋya mainayanagi kava yagaisaya vayala omainae.” huno agesama havia yafe kalagi aimateno alu ke alu kea hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Hamanepaigeno yagemoꞋa tavi falegahe higeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya agaite eꞋya mage huꞋya hae “Ma kumala vaya omai kuma hanegeno yagemoꞋa tavi falegahe nehiafe ma veala humatesanageꞋya uꞋya nagoꞋa veaꞋmogami hoyafitiꞋene notegatiꞋene nesaya kaveꞋamia mo miya hisae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hageno YisasiꞋa mage huno hamapaiye “Tamakaya tamakaitami nesaya kavela amamiho.” huno higeꞋya agaifena mage huꞋya hae “Nago kanomoꞋa tu hataletiꞋa (200) kanafi aliꞋya aliteno ani moneleti kosa hesia maya miya ohileꞋasine. Tagaya ani moneleti mo miya hulita ani maya memamisune hunageka nehano?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hageno YisasiꞋa mage huno hie “Mogeho naꞋmagi maya hane?” huno higeꞋya uꞋya mogayana higeꞋya “FaefuꞋa (5) mayagi tole noyamegi huno hane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hageno YisasiꞋa mage hie “MukiꞋamogatama alitalu hute hute hutama kanale apepate mopale maiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","HigeꞋya fifitiꞋa (50) veala nagopi alitalu huꞋya maigeꞋya vani hataletiꞋa (100) veala nagopi alitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","YisasiꞋa faefuꞋa (5) mayaene tole noyamene aliteno anafinaga agesaga huno neꞋageno Anumaya Kotitega ani kavefe huno muse huteno maya kofa huno agaiꞋaenema tokaeꞋya nemaiya anagala amamigeꞋya aliꞋya fako hutele huꞋya veala neꞋamamigeno tole noyamene kolino mukiꞋa veaꞋma nesayafe amamine. ");
INSERT INTO kmu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","AmamigeꞋya mukiꞋamoꞋya neꞋya amamu hae. ");
INSERT INTO kmu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Amamu higeꞋya atalaya mayaene noyamene atupatapaꞋa alitalu huꞋya kupi aiteꞋya tuelufuꞋa (12) kupi aigeno havatemaine. ");
INSERT INTO kmu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ani kaveꞋma nemainaya vayala faefu tauseniꞋa (5,000) vemoꞋya nemainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","AupaꞋa YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe mage huno hie “Tamakaya nagaila nenataletama hagotetama tipi kalefina haisaga humaitama atu kaiyaga Petesaita kumatega utegeꞋna nagaya veala humatesugeꞋya viho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Viho humategeꞋya utageno YisasiꞋa Anumayamotega ke huno havigegahe agoꞋyafi haimaine. ");
INSERT INTO kmu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Haino mainegeno hanikigeno tipi kalemoꞋa tikotumona amuꞋnopi utegeno YisasiꞋa agaiꞋage ti agegayale maine. ");
INSERT INTO kmu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Maineno ageana amaulegati yasimoꞋa eaꞋamo tipi kalemona meyetu fegeteana oꞋvigeno YisasiꞋa ageteno kotigahe hia avametega ti kotumona agupile viaꞋamo amakaitela momakasegahe hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amakasegahe ti agupile vianagi eneꞋegeꞋya ageteꞋya amakesa mage huꞋya haviye “Hakalo neꞋefi?” nehuꞋya “Avovo.” hae ");
INSERT INTO kmu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Avovo huꞋya tusiꞋa koli huteꞋya atali talu hayanagi aupaꞋa amakaifena mage huno hie “Kolia ohutama maiho. Nagaya neꞋogi tokiya vaitama maiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huteno tipi kalefi haino amakaiꞋene nemaiyana yasimoꞋa taga higeꞋya ani vayaꞋmoꞋya tusiꞋa amamaꞋyoge humainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","YisasiꞋa tokiyaꞋaleti kaveꞋma amaminea yafena amakuꞋamoꞋa haꞋyagino atalako higeꞋya aepaꞋa havilama ohunae. ");
INSERT INTO kmu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ti kotuna takaeꞋya Kenesale kotega uvaꞋyi huteꞋya hatilaviꞋyama vayana tipi kalea nofiteti ayetenae. ");
INSERT INTO kmu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tipi kalefiti hatilavino neꞋvigeꞋya aupaꞋa veaꞋmoꞋya Yisasina augosafina agemainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","AgeteꞋya note note amaiyayeꞋya ute ete huꞋya kali veala hagifanale amavaleꞋya “YisasiꞋa ma kumate maine.” huꞋya haya kea haviteꞋya agaite amavaleꞋya etele humainae. ");
INSERT INTO kmu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","YisasiꞋa vilega osi kumatelo ala kumatelo talapinagao kali veala amavaleꞋya kuma amuꞋnopi momateneꞋya Yisasifena mage huꞋya havigae “Kanale kenakamo atupalela avate hisuno?” huꞋya hateꞋya avate humainaya veala kalimoꞋa kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","NagoꞋa Falasia vayaꞋene kahegi kema havilinaya anagaꞋene Yelusalemuti Yisasite emainae. ");
INSERT INTO kmu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","EmaineꞋya agayana nagoꞋa YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya amayana sese ohuꞋya kavela nenageꞋya amakemainae*. ");
INSERT INTO kmu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Falasia vayaꞋagela omainagi mukiꞋa Yuta veaꞋmoꞋyaene amakinagomoꞋya humainaya kava akave maleꞋya amayama seseꞋma ohayana kavela onenagi sese huteꞋyage nenae. ");
INSERT INTO kmu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Situatega ugeꞋyama enuꞋya tima ofalesayana onegahagi tina faleteꞋyage amaugafamoꞋa hilato hutegeꞋya kavela nenae. Ani yamaꞋagelomagi nayona vayaꞋmoꞋya kahegi kea tokiyaꞋage huꞋya humainaya kehe haviꞋya masuene yopaene susufanene mukiꞋa sese nehae. ");
INSERT INTO kmu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Falasia vayaꞋene kahegi kema havilinaya anagaꞋene Yisasife mage huꞋya me hae “NaꞋa higeꞋya kagaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya taginagomogami kavala neꞋataleꞋya ani kea atagaeꞋya kaveꞋma negahena amayana sese nohae?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hageno YisasiꞋa kenonaꞋamia mage hie “Tamakaya vagala vaya mainae. AisaiyaꞋa Anumaya Koti aune kanomoꞋa tamakaifena tamage huno Anumaya Koti autaꞋmafina mage huno humaineane ‘Ani nofi veaꞋmoꞋya amavayaleti huꞋya nagai nagia alisaga nehayanagi amakuꞋamoꞋa alulega hanegeꞋya aniꞋa kavala nehae. ");
INSERT INTO kmu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Amakaya ma mopafi veaꞋmogami amavayafiti humainaya kahegi kehe mage humainayane ‘Mani kea Anumaya Koti ke hanegi akave maleho.’ huꞋya humainayanagi nagai nagia alisaga hisaya kavala ohuꞋya afa kava maiꞋya nehae.’ huno kaemaleneane. ");
INSERT INTO kmu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anumaya Koti kahegi kea ataletama veaꞋmoꞋya malenaya kea akave nemalae. ");
INSERT INTO kmu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Huteno nagoꞋene mage huno hie “Tamakaitami tamakinagomogami kavaꞋma akave nemalaya yafe Anumaya Koti kahegi kea ago atalenae. ");
INSERT INTO kmu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","MoseseꞋa mage huno humaineane ‘Tamakaya itatami afotamimogami amakia alisaga nehutama keꞋamia veganokanola ohutama amaiyaꞋafinaga maiho. NagoꞋa veaꞋmoꞋya itaꞋafoꞋamimogamima kamugema vaimatesayana faligahae.’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Humaineanagi tamakaya mage hutama hae ‘Nago kanomoꞋa itaꞋafoꞋamogani anaya hisia monema hanesigenoꞋa itaꞋafoꞋamoganina anayama ohinunoꞋa mage huno hisie ‘Ani monea Anumaya Kotina amisua yane huꞋna humainoe.’ huno hinunofena itaꞋafoꞋamoganina nagoꞋene anayama ohisiana kanalele.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ani kema haya yafe tamakinagomogami kavala akave malenayafe Anumaya Koti kehena ‘Afa yane.’ hutama mukiꞋa ani kavala nehae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","YisasiꞋa kasagoꞋya veala agaite esaya yafe nagoꞋene ke higeꞋya ageno mage huno hie “Tamakaya mani kea havilama hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","NagoꞋa nesaya yamoꞋma tamavayafi visia yamoꞋa tamakuꞋafina oniꞋya otamahaugahigi tamakuꞋafitiꞋma hatilavisia yamo ali falote hisigeno tamakuꞋamoꞋa oniꞋyaꞋagela hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huteno neꞋamataleno nopinaga haino mainegeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya Yisasife mage huꞋya hae “Kagaya mani avame kemona aepaꞋa hugeta havimano.” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Havigageno YisasiꞋa mage huno hie “TamakaiꞋenena havilama ohutama nehao? Tamakaya ohavinao mukiꞋa yana tamavayafima nesaya yamoꞋa oniꞋya otamahaugahie. ");
INSERT INTO kmu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tamavayafi nayaꞋamoꞋa tamakuꞋafina oꞋuno afaꞋa tamaipafike taviteno haenagaꞋa aifayolagafina taviteno afa ya kana nehie.” huno hie. Mani kema hiana mukiꞋa kavela afaꞋa nesaya kavekeꞋya hane huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Huteno mage huno hie “NagoꞋa yama tamavayafitiꞋma hatilavisia kemoꞋa tamakuꞋamona alino oniꞋyaꞋage nelamahaiye. ");
INSERT INTO kmu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","VeaꞋmogati taguꞋafitiꞋma efalote hia yamoꞋa maꞋa huno ali falote nehie kanale ohunea tagu tagesa nehavuna yaꞋene aꞋne munaꞋnene kumai he yaꞋene musufaya hu yaꞋene vaya hamaefali yaꞋene alu kanomo aꞋne amavayu hu yaꞋene alu kanomo yafe age haꞋye hu yaꞋene kefo yaꞋene havige huno savale savala hu yaꞋene age lamahaꞋye nehaya yaꞋene veamogami taipa havita haviya huneꞋamatona yaꞋene veafe havige humate yaꞋene taugafa alita hai yaꞋene kema ohavi yaꞋene taguꞋafitila ali falote nehie. ");
INSERT INTO kmu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","MukiꞋa ani kefo yama nehaya yana tamakuꞋafiti efalote hia yamo tamakuꞋafina oniꞋyaꞋagela humaine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","YisasiꞋa ani kumala neꞋataleno Taiya kumaꞋmo kaiyaga umaineno agaiꞋama anileꞋma emainea yafena veaꞋmoꞋya ohavisae huno nago nopi haino maiyanagi afaꞋa agaiꞋa falaꞋokigahie. VeaꞋmoꞋya ago haviye. ");
INSERT INTO kmu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","AupaꞋa nago aꞋmoꞋa Yisasi avagea haviteno eno aiyafi aleꞋya meyemaine. Ani aꞋmo munaꞋmona agupi Kefo Avamula mainea alagino. ");
INSERT INTO kmu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Isaleli vea omainea alagino Kaliki ke nehuno Fonisia nofi ale. Silia kotega alagino munaꞋamona agupi mainea Kefo Avamu* anatitalesie huno aukaꞋya huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","YisasiꞋa mage huno hie “NafaꞋnemoꞋya hagoteꞋya kavela negahae. Havigu nafaꞋnemogami kavela hamanafaleta kalayagamogami amamisunana haviya hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Higeno ani aꞋmoꞋa mage huno hie “Anumayamogae tamage hananagi nafaꞋnemoꞋya nenageno osi atupaꞋa sipaleti asaga hulavia yana kalamoꞋya yogiꞋya nenae. Kagaya ani kava huka nagaya Isaleli a omainoanagi osiꞋa nahaꞋmao.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Higeno YisasiꞋa ani afena mage huno hapaiye “KekaꞋa ago hanageꞋna havuafe nokalega vuo. Kefo AvamuꞋmoꞋa munakamona ago ataleno vie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Higeno nomaꞋalega viaꞋamo mogeana Kefo AvamuꞋmoꞋa ago ataleno vigeno munaꞋamoꞋa kanale huno sipale faemainegeno itaꞋamoꞋa mogemaine. ");
INSERT INTO kmu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","YisasiꞋa Taiya kumala ataleno aiyahae huno Saitoni kumala agaseno viaꞋamo teniꞋa (10) kuma hanelega mogaseno Kalili ti agegayalega uvaꞋyi humaine. ");
INSERT INTO kmu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","UvaꞋyi higeꞋya veaꞋmoꞋya nagola yuna aifo kanoa Yisasitega avaleꞋya vayana ani aifo kanomoꞋa hagifali ke nehatagegeꞋya Yisasife mage huꞋya hae “Augafale kayateti avate hisane.” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","YisasiꞋa ani kanoa neꞋavaleno veala amataleno faitega anakaiꞋanige umaineꞋana aya avoyaleti aifo kanomona agesafi vaiteno avetuꞋna heno ayateti avefuꞋnale avatemalene. ");
INSERT INTO kmu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Malegeno anafinaga agesaga huno “Vaeha ausoꞋnio.” huteno agaifena agaiꞋa kefiti mage huno hie “Efata.” huno hie. Tagai kefina “Kagesa akalo hino.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Higeno agesamoꞋa akalo higeno avefuꞋnamoꞋa kanale higeno aikalo huno kea kea hie. ");
INSERT INTO kmu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","YisasiꞋa mage huno hie “NagoꞋa veala mani yafena hamaꞋopaiho.” huno kahegi mateanagi ani kea huꞋya atile male huꞋya mukiꞋa veaꞋmogami amakesale mohu mehu humainae. ");
INSERT INTO kmu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","HageꞋya haviya veaꞋmoꞋya tusiꞋa amamaꞋyo aigeꞋya mage hae “MukiꞋa yana aligeno kanale kanale nehie. Yuna aifo vayala aya malegeꞋya kea nehaviye. Aifo vayala keꞋamia ali falote huneꞋamamie.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Nago yupa kasagoꞋya veaꞋmoꞋya alitalu huꞋya maiyana nesaya yana omalegeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafe ke higeꞋya ageno mage hie “Mani veala tagufa (3) yupa nagaiꞋene mainageno nesaya kaveꞋamia omalea yafe nahau huneꞋamatoe. ");
INSERT INTO kmu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","NagoꞋa veala ayaꞋaya kotegati emainagi havigu amatalesugeꞋya katega neꞋvisageno amakatesigeꞋya amaugetunatu huꞋya takatiyafena nonahaiye.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya mage huꞋya hapaiye “Mauna kola vaya omai kolagi hanateti maya alita ani veaꞋnea amamisune?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hageno YisasiꞋa mage huno hamavige “Tamakaya naꞋmagiꞋa maya hane?” huno higeꞋya mage hae “Tagaipina seveniꞋa (7) mayaꞋage hane.” huꞋya hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hageno YisasiꞋa muki veafena “Mopale maiho.” huno higeꞋya mopale mainageno YisasiꞋa ani seveniꞋa (7) maya alino Anumayamotega muse huno havigeteno aposite aposite huteno agaiꞋaenema tokaeꞋya nemaiya anagala amamigeꞋya mukiꞋa veapina vaya kaimainae. ");
INSERT INTO kmu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nagoke okasi noyame kanoꞋa hanegeno YisasiꞋa Anumayamotega ani noyamehe muse huteno “Amamite amamite hiho.” huno higeꞋya vaya kaimainae. ");
INSERT INTO kmu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","KaigeꞋya mukiꞋa veaꞋnea nageno amamu higeꞋya atalaya maya atupayaga YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya alitalu huteꞋya seveniꞋa (7) kupi aihavatemainae. ");
INSERT INTO kmu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ani kaveꞋma naya veneꞋnea fo tauseniꞋa (4,000) vayaꞋmoꞋya nemainae. Netageno YisasiꞋa humategeꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Utageno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋene tipi kalefi haisaga humaiꞋya Talamanuta kumatega umainae. ");
INSERT INTO kmu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falasia vayaꞋmoꞋya Yisasite eꞋya agaiꞋene ke vaiꞋya ayevataga hisaya yafe mage huꞋya hae “Kagaya ikapinagati tokiyaꞋage avame yana hugeta agamano.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hageno YisasiꞋa aipa havino kanaꞋage huteno mage huno hie “NaꞋa higetama meni kanafima mainaya veaꞋmogatama tokiyaꞋage avame yafena nahavinegae? Tamage tamahapaisua kea haviho meni kanafima mainaya veaꞋmogatamina tokiyaꞋage avame yana tamaveotigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huteno neꞋamataleno tipi kalefi haisaga humaino atu faliga ugahe umaine. ");
INSERT INTO kmu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","YisasiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya tima lakaeꞋya vayana amakekaniꞋya nagoke maya kanoꞋa aliꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","AliꞋya vayanagino YisasiꞋa mage huno hamapaiye “Tamakaya Falasia vayaꞋene HelotiꞋene amakupima hanea yana agelama ohuneꞋya amavayaleti havigema nehaya yamoꞋa kaihamemo halenegia avamete huno halegino alakefa hisia yafena kaꞋye ho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","HigeꞋya ani vayaꞋmoꞋya amakaiꞋamia huge havige nehuꞋya mage hae “Tagaya maya oꞋalita emainona yafe nehie.” huꞋya amakaiꞋamia hae. ");
INSERT INTO kmu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hageno YisasiꞋa ani vayaꞋmoꞋya haya kea ago haviteno mage hie “NaꞋa higetama ‘Kavetia alita omenone.’ hutama tamakaitamia huge havige nehae. Tamakesa havilama hutama ohavinao? TamakuꞋamoꞋa tilemainegetama nohavio? ");
INSERT INTO kmu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Tamaulaga haneanagi agelama nohao? Tamakesa haneanagi havilama nohao? FaefuꞋa (5) maya aliꞋna apositeꞋna faefu tauseniꞋa (5,000) veyagama amaminoa yafena tamakekanitama mainao? NaꞋmagi kupi atupatapa aimalageno havatemaine?” huno hamavigegeꞋya “TuelufuꞋa (12) kule.” huꞋya hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hageno mage huno hie “SeveniꞋa (7) maya aliꞋna apositeꞋna fo tauseniꞋa (4,000) vaya amamugeꞋya neteꞋya naꞋmagi kupi atupatapa aigeno havatemaine?” huno hamavigegeꞋya “SeveniꞋa (7) kule” huꞋya hapaiye.” ");
INSERT INTO kmu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hageno mage huno hie “NaꞋa higetama nohaviye?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Petesaita kumate uvaꞋyi hageꞋya veaꞋmoꞋya nagola aulaga asu humainea kanoa avaleꞋya Yisasite neꞋeꞋya mage huꞋya hae “MusekaꞋa nehunagi augafale avate huo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hageno YisasiꞋa aulagama asu humai kanoa ayate alino kumala ataleno avaleno malaga viaꞋamo aulagafi avetuꞋna heteno aya nemaleno mage huno havige “Nago yana neꞋagano?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Higeno agesaga huno ageana higeno mage huno hie “Veala neꞋagogeꞋya yosa kana huꞋya vaiyatete nehae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Higeno YisasiꞋa nagoꞋene aniꞋa huno ayana aulagale malegeno aulagamoꞋa kanale higeno agemaine. Aulaga age haleno muki yana kanaleꞋya huno agemaine. ");
INSERT INTO kmu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Agegeno YisasiꞋa mage huno hie “Ma kumatela oꞋuka eteka nokalega vuo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋene Sisalia Filipai kotega hanea kumate ugahe katega neꞋuno mage huno hamavige “VeaꞋmoꞋya nagaifena taꞋe huꞋya nehae?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","HamavigegeꞋya kenonaꞋa mage huꞋya hae “NagoꞋa veaꞋmoꞋya kagaifena ‘Tima fale neꞋamatea YoniꞋe.’ huꞋya hageꞋya nagoꞋa veaꞋmoꞋya ‘Ilaiya maine.’ huꞋya hageꞋya nagoꞋa veaꞋmoꞋya ‘Anumaya Kotina aune kanoꞋa maine.’ huꞋya nehae.” huꞋya hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hapaigeno YisasiꞋa mage huno hamavige “Tamakaya nagaifena taꞋe hutama nehae?” huno hamavigegeno PitaꞋa kenonaꞋa mage huno hie “Kagaya Kalaisigae Anumaya KotiꞋa taugafa aligatigane huno hugatenea kano mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Higeno YisasiꞋa amaumono maleno mage huno hie “Mani kea nagoꞋa veala hamaopaiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ani yupa YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafena haenagama falote hisia yafe aepa heno hamapaino mage huno hie “Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna tusiya huꞋna nagata yana alisugeno Yuta vayatamaene mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene amakaveꞋno hunateꞋya nahaesageꞋna falisugeꞋya komufi hevainatesageno naugafamoꞋa tole yupa maitenageꞋna tagufa kanale falimainesufitila eteꞋna hetigahue.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hufalote huno hamapaigeno PitaꞋa Yisasina faitega avaleno mage huno mo hapaiye “Kagaya ani kea ohuo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Higeno YisasiꞋa maiyahae huno nagoꞋa agaiꞋaenema tokaeꞋya nemaiya anagala amaketeno Pitafe keamakino mage huno hie “Sataniga mai halenato kagaya Anumaya Koti havimainea aguꞋagesa kanaleꞋya huka nohavinagi vayaꞋmoꞋya kahapaiya amaku amakesa nehavine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Huteno kasagoꞋya alitalu haya veaꞋnene agaiꞋaenema tokaeꞋya nemaiya anagafeꞋene ke higeꞋya ageno mage huno hamapaiye “NagoꞋa veaꞋmoꞋya nakave visaya amakesa havinuꞋyahena amaugafama aliꞋya hai yana amakaveꞋno huteteꞋya nagaiꞋma nagata aisigeꞋnama falisua avamete amakesa haviteꞋya yafaga yosa kofiꞋya nakave visae. ");
INSERT INTO kmu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","NagoꞋa veaꞋmoꞋya hamaimuꞋma hanesigeꞋya mai yaꞋamima atafa hutalako hisagenoꞋa ani yamoꞋa fanane hugahianagi nagoꞋa veaꞋmoꞋya nagaife huꞋya nagai kanale mono kema hamapaisaya yafema mai yaꞋamiene hamaimuꞋamiene atalesagenoꞋa ani mai yaꞋami aligatisigeꞋya agola maigahae. ");
INSERT INTO kmu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nago kanomoꞋa mukiꞋa ma mopafi afeno yama alisia yafe faliteno agola maige maige hisia haimuꞋa atalesiana alimainea mone afeno yamoꞋa hanaꞋa huno haꞋmaegahie? AꞋao haꞋomaegahie ");
INSERT INTO kmu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Falitesigenofena agola maige maige hisia haimula eteno alisia yafe mukiꞋa ma mopafi mone fenoꞋyana afaꞋa atalegahianagi aya ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","NagoꞋa veaꞋmoꞋya meni kanafina kefo yama nehaya veaꞋnene, Anumaya Koti kema ataleteꞋya alu kate neꞋvaya veaꞋnene, maineꞋya nagai kene nagaiꞋnienefema huꞋya ‘AoteꞋyamaꞋae.’ hunatesageꞋna nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna esua yupa Nenafana tokiya hale yamaꞋaene alu aotage ensole anagaꞋmoꞋyaene eteꞋna esuana aniꞋa huꞋna ani veaꞋnehena nagaye huꞋna ‘TamahaoteꞋyatamie.’ huꞋna humategahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","YisasiꞋa mage huno hamapaiye “Tamage huꞋna tamahanepauve maleꞋma hetiꞋya mainaya veala nagoꞋamogatama ofalinesageno hagoteno Anumaya Koti kava yagaisia yamoꞋa himamu yamaꞋaene efalote hinagetama agetetama haenaga faligahae.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","YisasiꞋa sikisiꞋa (6) kana maiteno Pitana Yemesina Yonigamina amavaleno ayaꞋaya agoꞋyafi haiꞋya amakaiꞋamige maineꞋya agayana Yisasi augafamoꞋa alino alu augafa kalimaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","KenaꞋamoꞋa mopafima mainaya veaꞋmoꞋya sese nehageno efeꞋage nehia avamete ohunegi tusiya huno efeꞋage huno alave alave humaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tole kanolatana MoseseꞋene IlaiyaꞋene evaꞋyi huꞋana YisasiꞋene kaiyeke nehaꞋageꞋya agemainae. ");
INSERT INTO kmu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","PitaꞋa Yisasife mage huno hie “Hulavenelina kanomogae tagaya male maunana kanale nehie. Tagaya katega nona tagufa (3) kilamatesune kagaila nagolagi Mosesena nagolagi Ilaiyana nagolagi huta kilamatesune.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tusiya huꞋya kolima haya yafe PitaꞋa ‘NaꞋane ke hisue?’ huno agesa havigeno mani kea humaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ani kea hanepaigeno agola siaꞋmoꞋa evaꞋyi huno melino aiso humategeno ani siapinagati age aino mage huno hie “Mani nafaꞋnea nagai nafaꞋnegi naguꞋafifena nenahaiya nafaꞋnegi agai kea haviho.” huno siapinagati humaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","HigeꞋya aupaꞋa moge mege huꞋya agayana nagoꞋa vayala omaigeno YisasiꞋa agaiꞋage mainegeꞋya agemainae. ");
INSERT INTO kmu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","AgeteꞋya agoꞋyafitila enelaviꞋya YisasiꞋa kahegi maleno mage huno hamapaiye “Manima agaya yafena nagoꞋa veaꞋnea hamaꞋopaiho. Haenagama nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna falimainesufiti hetisua yupa hamapaigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","HigeꞋya ani kemo akave maleꞋya hamaꞋopainagi “Falimainesufitila eteꞋna hetigahue.” huno hia kemo aepaꞋahe atiyeꞋya amakaiꞋami huge havige hae. ");
INSERT INTO kmu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mage huꞋya Yisasina havigae “NaꞋa higeꞋya kahegi kema havilinaya anagaꞋmoꞋya IlaiyaꞋa hagoteno etesigeno Anumaya KotiꞋa hutesigeno taugafa aligatisia kanoa egahie huꞋya humainae?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hageno YisasiꞋa mage huno hie “Tamage IlaiyaꞋa hagoteno eno mukiꞋa yana melino talo tala hugahie. AniꞋa huꞋya nagaifena Anumaya Koti autaꞋmafina kaemalenayane “Ikapinagati emainoa kanoa vayaꞋmo natenea kanomonina amakaveꞋno hunateꞋya ali haviya hunatesageno naugafa nagata aigahie.” huꞋya nagaifena humainayane. ");
INSERT INTO kmu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tamahanepauve IlaiyaꞋa ago egeꞋya Anumaya Koti autaꞋmafina kaemalenaya avamete huꞋya amakaiꞋamia hamaiya avamete agaila havi kavala hutenae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","NagoꞋa agaiꞋaenema tokaeꞋya nemaiya anagatega evaꞋyi huꞋya agayana kasagoꞋya veala anile alitalu humainageꞋya kahegi kema havilinaya anagaꞋmoꞋya YisasiꞋenema tokaeꞋya nemaiya anagaꞋene mo huhaviya me huhaviya huꞋya kea vaiye. ");
INSERT INTO kmu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","NeꞋvaigeno mukiꞋa veaꞋmoꞋya Yisasina ageteꞋya tusi muse nehuꞋya amaiyayeꞋya moli falu fala hutenae. ");
INSERT INTO kmu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","YisasiꞋa mage huno hamavige “NaꞋafene hutama mo huhaviya me huhaviya nehae?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Higeno nagola anile maiya kanomoꞋa mage huno hie “Humavenelina kanomogae Kefo AvamuꞋmoꞋa nafaꞋneꞋnimona agupi haimaineno nafaꞋneꞋnimo avayale maihiya humainegeꞋna kagaitega avaleꞋna neꞋoe. ");
INSERT INTO kmu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","NeꞋogi Kefo AvamuꞋmoꞋa atafa huteno atalegeno takatino faemainegeno agalemoꞋa selu selu nehigeno ave kume neganeno augafamoꞋa apipupapu nehigeꞋna kagaiꞋenema tokaeꞋya nemaiya anagafe ‘Kefo Avamula anatitaleho.’ huꞋna huana ya hugeteꞋya anatioꞋatalenae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Higeno YisasiꞋa mage huno hie “Ae meni kanafima mainaya veaꞋmogatama nagaifena havitama tamakupina omalenetama tamametitia nohaya veaꞋmogatama naꞋmagi kanafi tamakaiꞋenena mainesugetama havigahae? Ohaviya yafena kasalo nenahae. NaꞋmagi kanafi tamakaiꞋenena kanaleꞋya huꞋna ako huꞋna maisue? Nagaitega avaletama eho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","HigeꞋya avaleꞋya ageno Kefo AvamuꞋmoꞋa Yisasina ageteno ani nafaꞋnemona alino kigepagige hia kava huteteno ali takatitalegeno ani nafaꞋnemoꞋa mopafi asaga hulavino kasegase nehigeno agalemoꞋa selu selu humaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Higeno YisasiꞋa nefafena mage huno havige “NaꞋmagi kanafi aniꞋa haumaine?” huno havigegeno nefaꞋa mage huno hie “Osi nafaꞋne mainegeno aniꞋa haumaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","MukiꞋa kanafina Kefo AvamuꞋmoꞋa ayelakatitalegeno atafiꞋene tipiꞋene haefalisia kava nehigeꞋna kagaya kanale humainenuka kahau hulateka tahaꞋmao.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Higeno YisasiꞋa mage huno hie “NaꞋa higeka nagaifena kanale humainenuka nahaꞋmao huka nehane? Nagaifema agupi maleno ametiti nehia kanomoꞋa mukiꞋa yana alu ya alu yana afaꞋa hileꞋasinagi.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Higeno aupaꞋa ani nafaꞋnemona nefaꞋa mage huno hie “Nagaya kagaifena nagupi maleꞋna nametiti nehuanagi nagupi maleꞋna nametiti hua yanimoꞋa aupa nehigi alika ayaꞋaya hunato.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","HanepaigeꞋya veala tusiya huꞋya amaiyayeꞋya elitalu hageno YisasiꞋa neꞋamakeno Kefo Avamufena kemakino mage huno hie “Kagaya Kefo AvamuꞋmogae agesama ailileka avaya alilu kimainana Kefo AvamuꞋmogae hai kahapauve agupitila hatilavika vuo. NagoꞋa kanafina nagoꞋene agupina haiofalo.” huno hutene. ");
INSERT INTO kmu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Higeno Kefo AvamuꞋmoꞋa ala kenake nehuno ani nafaꞋnemona tusiya huno alino kigepagige hia kava huteteno hatilavino ataleno vigeno ani nafaꞋnemoꞋa fali vaya kana huno faemainegeꞋya kasagoꞋya veaꞋmoꞋya “Ago falimaine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nehageno YisasiꞋa ayate alino avalesaga hutegeno hetimaine. ");
INSERT INTO kmu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Haenaga YisasiꞋene nopinaga haino mainegeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya amakaiꞋamige maineꞋya mage huꞋya havigae “Tagaya ya hugetonana ani Kefo Avamula naꞋa higeta anatioꞋatalenone?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hageno YisasiꞋa mage huno hamapaiye “MaꞋa augafa Kefo Avamula alu yatetila oꞋanatigahagi Anumaya Kotitega ke huta havigesaya yatetike anatigahae.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ani kumala neꞋataleꞋya Kalili kotegama vayana “VeaꞋmoꞋya visua kumafena ohavisae.” huno higeꞋya ako huꞋya falakiꞋya neꞋvageno agaiꞋaenema tokaeꞋya nemaiya anagala YisasiꞋa mage huno humavenelie “Ikapinagati emainea kanoa vayaꞋmo atenea kanoa agaila atafa huꞋya avaleꞋya vaya amayapi atesageꞋya haesageno faligahie. Faliteno hevaitesageno tole yupa komufi maiteno tagufa (3) kana falimainesifitila hetigahie.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anima hamapaiya kea havilama ohaya yafe koliꞋa huꞋya haviokenae. ");
INSERT INTO kmu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapaneamu evaꞋyi huteꞋya YisasiꞋa nopi haino maineno amakaife mage huno hamavige “Katega naꞋane kea kea hume hume emainae?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Katega neꞋeꞋya ma ke hume emainae “Kagaya ala kano mainapi nagaya kagaseꞋna ala kanoa mainoe?” huꞋya huge havige hume aya kehenagiꞋya kea ohuꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mainageno YisasiꞋa mopale maineno “EgeꞋna tamahapaino.” huno higeꞋya tuelufuꞋa (12) anagala ageno mage huno hamapaiye “Nago kanomoꞋa ‘Ala kanoma maisue.’ hinunofena haenagalafa maineno mukiꞋa veala kayo kayoꞋma humatesiana ala kano maigahie.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Huteno nagola okasi nafaꞋnea avaleno amuꞋnoꞋamifi hetiteneno avalesaga huno anukilineno mage huno hie “NagoꞋa veaꞋmoꞋya nagaifema haviꞋya maꞋa augafa osi nafaꞋnema avaleꞋya falu fala hisayana nagaiꞋene navaleꞋya falu fala hunenatae. NagaiꞋma navaleꞋya falu fala hisayana hunatenea NenafaꞋene avaleꞋya falu fala huneꞋatae.” ");
INSERT INTO kmu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","YoniꞋa mage huno humaineane “Hulavenelina kanomoga tagaya agonana nago kanomoꞋa kagai kagile Kefo Avamula vea amakusafinagatila anatineꞋatalegeta neꞋageteta takaveꞋma nohia yafe ‘AniꞋa ohuo.’ huta ‘AꞋao.’ hutenone.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","YisasiꞋa Yonife mage huno hapaiye. “Ani kanoa alitama ‘AꞋao.’ huoꞋateho. NagoꞋa veaꞋmoꞋya nagai nagile tokiyaꞋage aliꞋyama alisayana aupaꞋa nagaifena huhaviyana huonategahae. ");
INSERT INTO kmu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","VeaꞋmoꞋya kamema huotatesayana tagai kanapa maigahae. ");
INSERT INTO kmu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tamage tamahanepauve nagoꞋa veaꞋmoꞋya tamakayama Kalaisi nafaꞋnema mainaya yafe yasi tima tamamisagetama nesayana anonaꞋa kanale miya aligahae.” ");
INSERT INTO kmu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nagola osi nafaꞋneꞋni, nagaife havino agupi maleno ametiti nehisia nafaꞋnehema nagoꞋa veaꞋmoꞋya ‘Kefo yama huo.’ huꞋya havi kapima avaletesayana tusiꞋa havi kava nehayanagiꞋna tusiꞋa kana ya amamigahue. Ala yafagefaleti ani kanomo ageꞋyafi maleꞋya nofi kiteteꞋya hage lipi hagaꞋyu hutalesayana afa ya kana kana ya haneanagi nagaya tusiꞋa kana ya amamigahue. ");
INSERT INTO kmu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","KayamoꞋa ‘Kefo yama huo.’ huno kavaleno havi kapima katesigekahena ani kayana aifakalitalo. Aifakalitalesanana kanale hugahie. KaugafamoꞋa haviya humainesia kanoma maisanana haꞋno ohisia kahaimula hanesia kano maigane. Havigu tole kaya hanenageka kefo ya hisana kagesa kaminegeka kefo yama humainana yafe kavaleno hani yapi agola tegelege nehia atafi hagaꞋyu hugatalegahie. ");
INSERT INTO kmu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","KaiyamoꞋa ‘Kefo yama huo.’ huno kavaleno havi kapima katesigekahena ani kaiya aifakalika atalo. Aifakalitalesanana kanale hugahie. Kaugafa haviya humai kano maisanana haꞋno ohu kahaimula hanesia kano maigane. Havigu tole kaiyamoꞋa kefo ya hisana kagesa kaminegeka kefo ya humainana yafe kavaleno hani yapi agola tegelege nehia atafi hagaꞋyu hugatalegahie. ");
INSERT INTO kmu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","KaulagamoꞋma agea yafema kefo yama hisana kagesa kaminagekahena ani kaulaga ali faꞋyika atalo. Ali faꞋyitalesanana kanale hugahie. Nagoke kaulaga hanesigeno Anumaya KotiꞋa kava yagaimainea kumatela umaigananagi havigu tole kaulagamoꞋa kefo ya hisana kagesa kaminegeka kefo ya humainana yafe hani yapi tegelege nehia atafi kavaleno hagaꞋyu hugatalegahie. ");
INSERT INTO kmu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Anima ata legelege nehia kumapi veaꞋmoꞋya ani atafi mainageno kani kafaꞋamimoꞋa ofalisigeno atamoꞋa asua ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hagema kavete falea avamete huno veala mukiꞋamogatamina ataleti falelamategahie. ");
INSERT INTO kmu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hagea kanale ya haneanagi hagaꞋageꞋma nehia yamaꞋa haꞋnoma hisiana hanaꞋa hutama hagaꞋageꞋma nehia yamaꞋa ali falote hugahae? Hage kana yana tamakuꞋafi hanesigetama alava hutama nagoke tamaku tamakesale kigi yokalo hutama maiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","YisasiꞋa ani kola neꞋataleno Yutia kotega viaꞋamo Yotani timoꞋa ame kaiyaga uvaꞋyi huno mainegeꞋya mukiꞋa veala agaite melitalu hageno nehia kava huno nagoꞋene hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","HamanepaigeꞋya nagoꞋa Falasia vayaꞋmoꞋya Yisasite eꞋya ase ohisea kema hisiafene huꞋya nagola ayevataga hisaya kea mage huꞋya havigae “Nago kanomoꞋa aꞋama atalesia agesa hisigenoꞋa kahegi kemoꞋa ‘AfaꞋa atalegahie.’ huno humaineo?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hageno YisasiꞋa kenonaꞋamia mage huno hamavige “Mosese kahegi kemoꞋa ani yafena naꞋane humaine?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","HigeꞋya mage huꞋya hae “MoseseꞋa nagola kahegi kefina mage huno tahapaimaine ‘VemoꞋa aꞋamona avo kaeno neꞋamino hutesigeno haꞋno huno ugahie.’ huno humaineane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hayanagi YisasiꞋa mage huno hamapaiye “Tamakaya ke ohavitama veganokano haya yafe MoseseꞋa aꞋma atalesaya kea kaemaleneane. ");
INSERT INTO kmu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","Kaemaleneanagi Anumaya Koti avopina mage huno humaineane ‘Ehe yupa Anumaya KotiꞋa vene aꞋene talo humaleneane. Vene aꞋene talo humalenea yafe nago kanomoꞋma itaꞋafoꞋamoganima anataleno aꞋamoꞋene ailokaeno maisiana ani tolemogania nagoke anaugafa kaligaꞋe.’ huno humaineane. NaꞋa humaineafe nagoꞋene tolelatana omaigaꞋagi nagoke anaugafa kaliꞋana maigaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anumaya KotiꞋa ago alino hagelafimaleneanagino nagola ma mopale kanomoꞋa ani alavelatana mai yaꞋania alino apase oꞋanatesie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mani kea huteno nopinaga haino maineno agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ani kehena havinegae. ");
INSERT INTO kmu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Havigageno mage huno hie “Nago kanomoꞋa aꞋama ataleno alu aꞋma aliana ani kanomoꞋa kumai kava huno hagote aꞋamona ali haviya huneꞋate. ");
INSERT INTO kmu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nagi nago aꞋmoꞋma anauꞋamoma ataleno alu veleꞋma viana ani aꞋmoꞋa kumai kava nehie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","VeaꞋmoꞋya nafaꞋneꞋamia avaleꞋya Yisasite “Aya malese.” huꞋya neꞋageꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya “NaꞋa ohiho.” huꞋya kemamakimainae. ");
INSERT INTO kmu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","YisasiꞋa kema amamakiya yana ageteno haivaimateno mage huno hie “NafaꞋneyaga amatalegeꞋya nagaitega eho. Ka heakioꞋamateho. NafaꞋne avamete maiya veaꞋmoꞋya mage nehae ‘Tagaitige maunana tokiyatia omalegi Anumaya Koti kava yagailatesie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tamagelafa huꞋna tamahanepauve nafaꞋne avamete maisaya veaꞋmoꞋya ‘Tagaitige maunana tokiyatia omaleafe Anumaya KotiꞋa kava yagailatesie.’ huꞋya ohisayana Anumaya KotiꞋa kava yagaimainea kumatela oꞋugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huteno YisasiꞋa ani nafaꞋneyaga amavaleno amanukilineno “Anumaya KotiꞋa kanale manua tamamisie.” huno amaugafale ayana malene. ");
INSERT INTO kmu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","YisasiꞋa katega ugahe nehigeno nago kanomoꞋa aiyayeno eaꞋamo aule aleꞋya meyeno mage huno havige “Kagaya kanale ya huka humavenelina kanomogae hanaꞋa huteꞋna agola maige maige hisua nahaimula alisue?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Higeno YisasiꞋa mage huno hie “NaꞋa higeka nagaifena ‘Kanale kano mainane.’ huka nehane? Anumaya KotiꞋa agaiꞋage kanale kanoa maine. ");
INSERT INTO kmu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kagaya Anumaya Koti kahegi kea havilinane ani kemoꞋa mage huno humaine ‘Vayala haegeno ofalino. Kumai he yana ohuo. Musufa yana ohuo. ‘Ma kanomoꞋa havi kava nehie.’ huka havigehena kena oꞋvalo. Havigea ayevataga huka alu veaꞋmo yana oꞋalio. Itakafokamo kea ‘KahaoteꞋyakaꞋae.’ ohuo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Higeno ani kanomoꞋa mage huno hie “Hulavenelina kanomogae nagaya nafaꞋnema mainoa kanaleti aepa heꞋna mukiꞋa ani kema hana kea akave nemaloane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Higeno YisasiꞋa ani kanoa ageana agaifena hau ayamopafima haiya yafena ageteno mage huno hie “NagoꞋa yafena kosa heꞋokatene. Nago kavaꞋene huo. MukiꞋa malenana mone afenoꞋyakaꞋa alika fako huka moneꞋamima omalenesia veaꞋnema amamisanagenoꞋa Anumaya KotiꞋa ikapinaga afenoꞋyana kamigahie. AfenoꞋyakaꞋa fako huka amamite amamite huteka nakave eno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Higeno ani kanomoꞋa ani kea havianagi mone afenomaꞋama kasago humainea yafe oꞋatalesia agesa haviteno augosamoꞋa atili kaegeno aipamoꞋa tusi kanaꞋage higeno ataleno umaine. ");
INSERT INTO kmu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Vigeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagala moge mege huno neꞋamakeno mage huno hie “MukiꞋa mone afenoꞋyaꞋamima hanesia veaꞋmoꞋya kasageke humaiꞋya humaiꞋya Anumaya Kotife ‘Kava yagailato.’ huꞋya hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ani kehena amamaꞋyoa aiyanagi YisasiꞋa nagoꞋene mage huno hie “NafaꞋneꞋnimogatama veaꞋmoꞋya kasageke humaiꞋya humaiꞋya Anumaya Kotifena ‘Kava yagailato.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nagola pulumaka kana afumo agia kemolumoꞋa nekaꞋyamo kapima haifalesiana afaꞋa yoꞋyo huno haifalegahianagi mukiꞋa mone afenoꞋyamaꞋa hanesia kanomoꞋa Anumaya Kotifena ‘Kava yagainato.’ huno kasageke huno haifalegahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Haviya anagaꞋmoꞋya tusiꞋa amamaꞋyo aigeꞋya mage huꞋya hae “NaꞋama humainesiana hana veaꞋmogami amaku amame Anumaya KotiꞋa aligatigahie?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hageno YisasiꞋa amakeke huno amakemaineno mage huno hie “VeaꞋmogamina tokiyaꞋamia omaleneanagiꞋya ohugahayanagi Anumaya KotiꞋa mukiꞋa kava hisia tokiyaꞋa haneanagino afaꞋa aligatigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Higeno PitaꞋa mage huno hie “Havio tagaya mukiꞋa yatia ataleteta kagai kakavela neꞋone.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Higeno YisasiꞋa mage huno hapaiye “Tamage huꞋna tamahanepauve mukiꞋa veaꞋmoꞋya nagaifema huꞋya nagai kanale mono kema veaꞋmogamima mo hamapaigahena noꞋamiene nepuꞋamiene amasaꞋamiene itaꞋamiene neꞋamafaꞋene nafaꞋneꞋ-amiene mopaꞋamiene amataleꞋya visagenoꞋa Anumaya KotiꞋa mopale mainaya kanafima atalenesaya noꞋamiene nepuꞋamiene amasaꞋamiene itaꞋamiene nafaꞋneꞋamiene mopaꞋamiene nagoꞋene nagoꞋene ohavunamaꞋa ya aliteꞋya huhaviyama humatesaya yaꞋene aliteꞋyagi haenagaꞋa maige maige hisaya hamaimula amamigahie. ");
INSERT INTO kmu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Meni kanafima hagoteꞋya mainaya veala ani kanafina haenagalafa maigahayanagi meni kanafima haenagalafa mainaya veala ani kanafina hagoteꞋya maigahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yelusalemu haigahena katega neꞋuꞋya YisasiꞋa hagoteno vigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya amamaꞋyo aiꞋya neꞋvageꞋya amakave vaya veaꞋmoꞋya koli nehageno YisasiꞋa eteno nagoꞋene tuelufuꞋa (12) anagaꞋamogamina amahaote amavaleno momateneno haenagama agaila hutesaya yafena hamanepaiye. ");
INSERT INTO kmu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mage huno hie “Haviho tagaya Yelusalemu haisunageꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia natafa huteno mono note kava vayaꞋmogami amayapiꞋene kahegi kema havilinaya anagaꞋmogami amayapiꞋene natesigeꞋya nagaifena ‘AfaꞋa falisie.’ huꞋya Yuta vea omainaya vayaꞋmogami amayapi navaleꞋya nategahae. ");
INSERT INTO kmu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","NatesageꞋya nagaye hisifa ke hunateꞋya amavetuꞋna henenateꞋya hegi kaꞋyoteti haifu namiteꞋya nahaesageꞋna yafaga yosale faligahue. FalisugeꞋya hevainatetesageꞋna tole yupa komufinaga maiteꞋna tagufa (3) kanale falimainesufitila hetigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepeti nafaꞋnelatana YemesiꞋene YoniꞋene Yisasite eꞋana mage huꞋana havigaꞋe “Hulavenelina kanomogae nago yafe kahavigesuꞋageka ani yana hulaꞋato.” huꞋana havigaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","HaꞋageno YisasiꞋa mage huno hanavige “NaꞋa hulanatesue?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","HigeꞋana mage huꞋana haꞋe “Tokiya hale yakaꞋafima umaisanagetaꞋa taꞋagaya kavate mainesuꞋageka ‘NagoꞋmoga tamaga nayatega maiyo.’ huteka ‘NagoꞋmoga hauga nayatega maiyo.’ huka hulaꞋato.” huꞋana havigemainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","HavigaꞋanagi YisasiꞋa mage huno hanapaiye “NahavigaꞋa yafena ohavinaꞋe. Falisua yana satuꞋage humainea ti kana humainea ti hanea keꞋayopitila negahugi tanakaya naꞋaleꞋasino onaꞋaleꞋasine? Nagaila falenatesaya yamoꞋa, nagatama aisia yatetila tanakaila ani yateti falelanatesagetanahena afaꞋa aligaꞋo?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","HigeꞋana “E, tokiyatiꞋa haneanagitaꞋa aniꞋa hugahuꞋe.” huꞋana haꞋageno YisasiꞋa mage huno hie “Tamage satuꞋage humainea tina negaꞋanagi falenatesaya yamoꞋa nagatama aisia yateti falelanategahae. ");
INSERT INTO kmu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Falelanategahayanagi ala vayaꞋma mainalega tamaga nayategaene hauga nayategaenena siale maisaya yana nagai yana omalegi Anumaya KotiꞋa agaiꞋa ani yana ago nagoꞋa vayafe huno talo tala huno ali fatago humatene.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","HigeꞋya teniꞋa (10) anagaꞋmoꞋya ani kea haviteꞋya Yemesigani Yoniganina amaipa haviꞋya haviya hunatenae. ");
INSERT INTO kmu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","YisasiꞋa “Nagaitega eho.” huno higeꞋya ageno mage huno hie “Ma mopafi ala kava vayaꞋmoꞋya ‘TusiꞋa ala vaya mainone.’ huꞋya Yuta vea omainaya veafe ke amamakiꞋya aliꞋya ke humateꞋya kava vayaꞋmo nehaya avamete kava nehae. ");
INSERT INTO kmu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","NaꞋa nehayanagi tamakaya aniꞋa kavala ohiho. Tamakaipima ‘Nagi hanea kanoma maigahue.’ huno hisia kanomoꞋa aliꞋya kanotami maino. ");
INSERT INTO kmu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","‘UhagoteꞋna maigahue.’ huno hisia kanomoꞋa miya oꞋali aliꞋya kanotami maino. ");
INSERT INTO kmu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna veaꞋmoꞋya naya huꞋya ali kanale hunatesaya yafene huꞋna omenogi nagaya amaya huꞋna aliꞋya kanoꞋami maisuafene huꞋna emaineꞋna mukiꞋa veaꞋmoꞋya kefo yama nehaya yamo aigagimatenea yapiti alikalu hematesuafe miya atalesue huꞋna faligahe emainoe.” ");
INSERT INTO kmu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋene kasagoꞋya veaꞋnene Yeliko kumate uvaꞋyi huteꞋya ani kumala mogaseꞋya ugahe nehageno nagola aulaga asu humainea kanomo agia PatimeusiꞋa Timeusi nafaꞋnegino ka agegayale mopale maineno monehe aukaꞋya huge huge huno maine. ");
INSERT INTO kmu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Nasaleti YisasiꞋa ago neꞋe” huꞋya haya kea haviteno ke huno mage huno hie “Yisasigae, Tevitina aginagomogae nagaila kahau hunato.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","HigeꞋya kasagoꞋya veaꞋmoꞋya kemakiꞋya “Ke ohuka maiyo.” huꞋya hayanagi nagoꞋene ke huno “Tevitina aginagomogae nagaila kahau hunato.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Higeno YisasiꞋa anile mo hetimaineno mage huno hie “Hapaigeno eno.” huno higeꞋya ani kanohe ke huꞋya mage huꞋya hae “KaguꞋa ali lokiya vaika aupaꞋa hetio. Kagaife ke nehie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hageno ayaꞋaya yasi kenaꞋa asagi neꞋataleteno aupaꞋa hetino Yisasite vie. ");
INSERT INTO kmu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vigeno YisasiꞋa mage huno hie “NaꞋa hugatesue?” huno higeno aulagama asu humai kanomoꞋa mage huno hie “Humavenelina kanomogae naulaga agesue huꞋna nehue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Higeno YisasiꞋa mage huno hapaiye “AfaꞋa vuo nagaifema havika kagupi maleka kametitima hana yateti ago aliꞋna kanale hugatoe.” huno higeno aupaꞋa aulagamoꞋa kanale higeno Yisasi akave umaine. ");
INSERT INTO kmu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yelusalemua aupate hanegeꞋya tole osi kumatalana Petafasiene Petaniene hanea kumate umainae. Ani kumatalana Olivi yosa hanea agoꞋyamo agegayalega hane. Anile maineꞋya YisasiꞋa tole agaiꞋaenema tokaeꞋana nemaiꞋa kanolatana hunateno mage huno hanapaiye “Atu kumate utetana atupa note hosi kana afumo agia tokimo nafaꞋnea ayetenayanagitana agegaꞋe. Ani tokimo nafaꞋnea vayala oꞋamavalenea tokie. Kalu hetana avaletana male eꞋo. ");
INSERT INTO kmu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","NeꞋeꞋageꞋya nagoꞋa vayaꞋmoꞋya ‘NaꞋa higetana naꞋa kavala nehaꞋe?’ huꞋya hisagetanahena mage hutana hiꞋo ‘Kava kanotimoꞋa nago aliꞋya aligahe higetaꞋa neꞋoꞋanagino aliꞋyamaꞋa aliteno aupaꞋa eteno tamamigahie.’ hutana hamapaiꞋo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","HigeꞋana ani kanolatana uꞋana ani tokimo nafaꞋnea no fiate ayetageno ka agegayale hetino mainegeꞋana mogefalote huteꞋana nofila alikalu hemainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","NehaꞋageꞋya nagoꞋa anile hetimainaya vayaꞋmoꞋya mage huꞋya hae “NaꞋa higetana tokimo nafaꞋnea kalu nehaꞋe?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","HageꞋana YisasiꞋma “Nage hutana hiꞋo.” hunoꞋma hia kea hamapaiꞋageꞋya ani vayaꞋmoꞋya “AfaꞋa tokia avaletana viꞋo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","HageꞋana ani tokimo nafaꞋnea Yisasite avaleꞋana evaꞋyi huteꞋana kenaꞋania anaugafaleti hateꞋana ani afumo agupile yakaimalaꞋageno YisasiꞋa anile haino maine. ");
INSERT INTO kmu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","MaigeꞋya mukiꞋa veapiti nagoꞋamoꞋya amaugafaleti kenaꞋamia hateꞋya via katela yakaigeꞋya nagoꞋamoꞋya haisa hanete hanete yosayaga kofanafa huꞋya katela yakaimalageno YisasiꞋa ani kate afumo agupifina maiteno umaine. ");
INSERT INTO kmu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","HagoteꞋya vaya veaꞋmoꞋyaene haenagama vaya veaꞋmoꞋyaene ala kenake kefiti mage huꞋya hae “Alamogae taugafa aligatisana kanoa kanaleꞋya huka neꞋane. Anumayamo aliꞋya alisana yafe hugategeka emainana kanomoga Anumaya KotiꞋa kanale manu kamino kaya humaine. ");
INSERT INTO kmu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","TaginagomoꞋa TevitiꞋe nayona kava hunoꞋma yagaimainea avamete kavala eteno aniꞋa huno falote hugahie. Ani yafena muse higetao. Anafinaga Anumaya KotiꞋa taugafa aligatisia kanohe muse hisune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","YisasiꞋa Yelusalemu uvaꞋyi huteno ala mono nopi umaineno mukiꞋa mono nopima hanea yana ako huno ageliteno huno ageteno neꞋataleno hani kisia avamete higeno ataleno tuelufuꞋa (12) anagaꞋaene Petaniga vae. ");
INSERT INTO kmu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","FaeteꞋya kotigeꞋya Petania ataleꞋya neꞋvageno Yisasina agatemaine. ");
INSERT INTO kmu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Agategeno nagola haisa afaꞋa hanea fiki yosamoꞋa aluꞋale hanegeno ageteno alagaꞋahe mogegahe ani yosamo aepale uno mogeana alagaꞋa omalegeno haisayagaꞋage hane. Ani fiki yosamoꞋa alagaꞋama neꞋayea kanamoꞋa yaufa falote ohune. ");
INSERT INTO kmu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mogeteno YisasiꞋa ani yosahena mage huno hie “Namo yosa hetika maiyo. Agola kagai kaugafa veaꞋmoꞋya nagoꞋene onegahae.” huno huhaviya hutegeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ani kea havimainae. ");
INSERT INTO kmu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yelusalemu evaꞋyi huteꞋya YisasiꞋa ala mono nopi haino mone aliꞋya neꞋaliya veaꞋnene afaꞋa miyama nehaya veaꞋnene “Maihaleho.” huno amanatineꞋataleteno nagoꞋa veaꞋmoꞋya alu kotegama nehanea monea neꞋaliꞋya ani kotegama nehanea monea neꞋamamiya veaꞋmogami folomoa alitalegeno aige helafige higeno kugofa kana namama miya nehaya veaꞋmogami sipaꞋamia aniꞋa huno alitalegeno aihelafilavimaine. ");
INSERT INTO kmu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Afenoma aliliteꞋya nehaya veafena mage hie “Ala mono no kumapina afenona alitama ute ete ohiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huteno mage huno hamapaiye “Anumaya KotiꞋma humainea kemoꞋa autaꞋmafina mage huno kaemaleneane ‘Nagai nona mukiꞋa kotega veaꞋmoꞋya Anumaya Koti agi ayeꞋya havigesaya no hane.’ huno kaemaleneanagi tamakaya musufa yama nehaya veaꞋmogami nomo avamete kava hutama falakitama musufa ya hugahe ma mono nopina emainae.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","HigeꞋya mono note kava vayaꞋmoꞋyaene kahegi kema havilinaya anagaꞋmoꞋyaene YisasiꞋma hia ke haviteꞋya muki veaꞋmoꞋya YisasiꞋma hamapaiya kema haviteꞋya amamaꞋyoma aiya yafe koli huteꞋya “HanaꞋa huta haesune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hayanagi YisasiꞋa anagaꞋamoꞋyaene hani kigeꞋya Yelusalemua ataleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","YisasiꞋa faeteno natena agaiꞋaenema tokaeꞋya nemaiya anagaꞋaene kate vayana anima alaga oꞋayenea fiki yosa mogayana hafuꞋyayagafiti amagino haisamoꞋa amagiteno fayo temaine. ");
INSERT INTO kmu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","YisasiꞋa ani yosahema humainea kehena Pita agesamoꞋa hao higeno haviteno Yisasife mage huno hie “Humavenelina kanomogae ago fiki yosama huhaviya hutana yosamoꞋa ago faꞋyotemaine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Higeno YisasiꞋa mage huno hamapaiye “Anumaya Kotifena mage hutama hiho ‘Kagaya mukiꞋa yana hateꞋasine.’ hutama tamakupi maletama tamametiti hisayana tamage huꞋna tamahanepauve Anumaya Kotifena tole lamakesa ohavitama ‘Havigesua yana falote hugahie.’ hutamama hisagenofena ani yamoꞋa falote hugahie. Ani kavaꞋma hisia kanomoꞋa ma agoꞋyahena ‘Ma agoꞋyamoga kofa hulavika ala tikotumo amuꞋnopi ufaemaiyo.’ huno hapaisigenofena akave maleno aniꞋa hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ani yafe mage huꞋna tamahanepauve mukiꞋa yafena Anumaya Kotitega havigesayana ‘Anumaya KotiꞋa kanaleꞋya huno lamigahie.’ hutama tamakesa havisagenofena afaꞋa tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Tamakaya hetitama Anumaya Kotitegama ke hutama havigegahena hagotetama kefo yama hulamatenesaya veafena aigeꞋamatetama kefo yaꞋamia atalematesagenofena ikapinaga mainea NelamafaꞋa kefo yatamia aigetamateno atalelamategahie. ");
INSERT INTO kmu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yelusalemu alehate evaꞋyi hayana YisasiꞋa ala mono no kumapi ute ete nehigeꞋya mono note kava vayaꞋmoꞋyaene Yuta vayatamaene kahegi kema havilinaya anagaꞋene agaitega evaꞋyi hae. ");
INSERT INTO kmu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","EvaꞋyi huteꞋya mage huꞋya hae “Hana augafa ala kanomo hugategeka mani kavala me nehane? Himamu yakaꞋa ta kamine?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hageno YisasiꞋa kenonaꞋamia mage huno hie “Nagaya hagoteꞋna nago yafena tamahavigesugetama nahapaisageꞋna nagaya ani yama talo nehua himamuꞋnima hanea navagea tamahapaigahue. ");
INSERT INTO kmu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","YoniꞋa tima fale neꞋamatea yana Anumaya Koti hutegeno ani kavala me nehifi afa vayaꞋmoꞋya hutageno lina faleneꞋamate? Tamakaya hufalote hutama nahapaiho.” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","HigeꞋya “NaꞋa maꞋa hugahune.” huꞋya mohu mehu huteꞋya mage hae “Anumaya Koti hutegeno emaine.” huta hisunagenoꞋa YisasiꞋa “NaꞋa higetama agai kea havitama tamakupina nomalae?” huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hugahianagita mukiꞋa veaꞋmoꞋya Yonifena “Anumaya Koti aune kano maine.” huꞋya tokiyaꞋage kema nehaya yafe tagaya “Afa vayaꞋmoꞋya hutageno emaine.” huta hisunagenofena kelamakigahie huta koli nehune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kolia nehuꞋya Yisasifena mage huꞋya hae “Tagaya ohavinonanagita hufalote huta kahaꞋopaigahune.” huꞋya hageno YisasiꞋa mage huno hie “NahaꞋopaisayana nagayaenena aniꞋa huꞋna hufalote huꞋna ani yama taloma nehua himamuꞋnima hanea navagea tamahaꞋopaigahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","YisasiꞋa aepa heno avame kea mage huno hamapaiye nago kanomoꞋa vaini* nofi alaga hoya humaleteno kegiꞋya hugove humaleneno ani alagayagamo timaꞋa ayelatisigeno timaꞋamoꞋa tavino umaisia komua kafiteno yagaiꞋyama maisaya nona anafi kimaleteno alu vayafe ke huno “Etama hoyaꞋnile me yagaitama maineho. Ani nofiꞋmo alagafitila aye fako hutama nagoꞋa aliho.” huno humateteno alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Umaineno fuma nelea kanafina ani hoyamona nefaꞋa nagola aliꞋya kanoa hutegeno ani vaini hoyaleꞋma neꞋyagaiya vayatega alaga aligahe umaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","VigeꞋya hoyaleꞋma neꞋyagaiya vayaꞋmoꞋya ani aliꞋya kanoꞋamona atafa huꞋya kaꞋyo amiteꞋya mage hae “Okamigahunagi kagaya eteka vuo.” huꞋya hageno eteno umaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eteno vigeno hoyamona nefaꞋa alu aliꞋya kanoꞋa hutegeno viana aniꞋa huꞋya atafa huꞋya anu aliteꞋya tusiꞋa agaye hisifa kava hutenae. ");
INSERT INTO kmu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hutageno vigeno eteno alu aliꞋya kanoꞋa hutegeno ani hoyafi viana atafa huꞋya hayageno falimaine. Falitegeno hoyamona nefaꞋa kasagoꞋya aliꞋya vayaꞋyaga humategeꞋya vageꞋya nagoꞋa aliꞋya vayala amatafa huꞋya nehamaeꞋya nagoꞋa kuyafa neꞋamataleꞋya nagoꞋa tefa hamae falimainae. ");
INSERT INTO kmu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","MukiꞋa vageno hau ayamopafima nehaiya nafaꞋneꞋa agaiꞋage maigeno nefaꞋa mage huno hie “NafaꞋneꞋnimo kea havigahae.” huteno hutegeno haenagalafa ani hoyalega umaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","VigeꞋya ani hoyafima yagaimainaya vayaꞋmoꞋya mage huꞋya hae “Mamona mani hoyamona nefa nafaꞋne. NefaꞋma falisigenofena mani nafaꞋnemoꞋa hoyaꞋa aligahianagita ago haegetao. Haesunageno falisigeta mani hoya tagai ya hapaegahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","HuteꞋya atafa huꞋya hayageno faligeꞋya augafaꞋa aliꞋya hoyafinagati ai halatu huꞋya malaga hagaꞋyu hutalenae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Huteno YisasiꞋa mage huno hamavige “NaꞋa hayanagino hoyamona nefaꞋa hanaꞋa humategahie? Eno hoyaꞋafima yagaimainaya vayala tavata me hamaesigeꞋya faligahae. Fali haꞋno hisageno alu vayafe “Tamakaya hoyalela kava me yagaiho.” huno humategahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","NagoꞋene YisasiꞋa mage huno hie “Manima Anumaya Koti avopima hanea kea ago hapalitama havimainao? Mage huno humaineane ‘VayaꞋmoꞋya yafa noma kiyana nago yafafena ‘Haviya humaine.’ huꞋya atalayanagi ani yafamoꞋa haenagaꞋa ‘TusiꞋa kanale yafanagino amakaseno haimainea yafane.’ huꞋya nomo ayetagenale malenae. ");
INSERT INTO kmu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","AnumayamoꞋa aniꞋa humaineanagita neꞋageta tusiꞋa kanale ya hane huta nehune.’ huꞋya kaemalenayane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","YisasiꞋa mani kea higeꞋya mono note kava vayaꞋmoꞋya “Mani avame kema hiana tagaife nehie.” huꞋya amakesa haviteꞋya mage hae “Avaleta kina nopi ategahune.” huꞋya hayanagi alitalu humainaya veafe koli huteꞋya Yisasina ataleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","NagoꞋa Falasia vayaꞋene nagoꞋa Heloti vayaꞋene humatageꞋya YisasiꞋma havigaya keleti ayevataga huꞋya atafa huꞋya haegahe Yisasi mainelega umainae. ");
INSERT INTO kmu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","UmaineꞋya mage huꞋya havigae “Humavenelina kanomogae tagaya ago havunana kagaya tamageꞋage kano mainane. Amakima hanea vayaꞋene amakima omale vayaꞋenefena nagoke katekeꞋya havi neꞋamamika kelamage nehuka Anumaya Koti kea tahanepainane. Takisi monema ataleyatela SisaꞋa kava kanomotega kanale atalesuno ifi oꞋatalesune? huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hageno YisasiꞋa amakupinagama haviya kea ago haviteno “Vagala vaya mainetama amegati ke nehae. NaꞋa higetama nagaila ayenavataga hutama natafa hisaya yafena nahavinegae? Nagola alaga monea alitama me namigeꞋna agano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","HigeꞋya nagola alaga monea aliꞋya memigeno ageteno mage huno hamavige “Mani alaga monelela ta augosaene ta agiene hane?” huno hamavigegeꞋya “Sisa augosaene agiene hane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hageno YisasiꞋa mage hie “Sisana agaiꞋa yana agaila amiho. Nagi Anumaya Kotina agaiꞋa yana agaila amiho.” huno higeꞋya ani kehena amamaꞋyo aimaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","NagoꞋa Satiusi vayaꞋmoꞋya* Yisasitega emainae. Ani vayaꞋmoꞋya mage nehaya vayale “Falimainaya vayala eteꞋya heotigahae.” huꞋya nehaya vayale. ");
INSERT INTO kmu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","VayalegiꞋya Yisasina me havigeꞋya mage huꞋya hae “Humavenelina kanomogae MoseseꞋa tagaifena mage huno kaemaleneane ‘Nago kanomona nepuꞋamoꞋa nafaꞋneꞋa oꞋate kanoa aꞋama ataleno falinagenoꞋa aganaꞋamoꞋa ani aala aliteneno agoꞋma falimainea kanomofe anonaꞋa nafaꞋne atesie.’ huno kaemaleneane. ");
INSERT INTO kmu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nago kanafina seveniꞋa (7) konaga mainayanagino nepuꞋamimoꞋa aala aliteneanagino nafaꞋnea oꞋate kano maineno falimaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Falitegeno anile aganaꞋamoꞋa ani aala aliteana nafaꞋnea aniꞋa huno oꞋatenea kano falitegeno anile aganaꞋamoꞋa aniꞋa humaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","MukiꞋa seveniꞋa (7) konagamoꞋya aliteme aliteme ayana nafaꞋnea oꞋateꞋya fali haꞋno hageno haenagalafa ani aala falimaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","SeveniꞋa (7) konagamoꞋya ani aala alitenayanagi falimainesafitiꞋma hetisaya kanafina hana kanomo ani aala aligahie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Havigageno YisasiꞋa mage huno hamapaiye “Anumaya Koti kefima kaemalenea kene tokiya yamaꞋaenefena havilama hutama ohaviya yafe tamakaya havi tamakesageꞋya nehaviye. ");
INSERT INTO kmu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","VeaꞋma falimainesafiti hetisaya kanafina ensole vaya kana huꞋya vemoꞋya aala oꞋaligahae. AꞋmoꞋyaenena vea oꞋaligahae. ");
INSERT INTO kmu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Falimainaya veaꞋma eteꞋya hetisaya yafe nahavinegao? Mosese kaemalenea avopima ohapalinao? Nagola osi yosaleꞋma ala ata anefela leanagi ani osi yosa otene.” huno kaemalenea kea ohavinao? Anumaya KotiꞋa ani kanafina Mosesefena mage huno humaineane “Nagaya Apalahamunagi Aisakinagi Yekopugami Anumaya mainoe.” huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ani anagala falimainayanagi “Nagaya Anumaya KotiꞋamimoꞋna mainoe.” huno humainea yafena amaku amamemoꞋa ofalinegi afaꞋa mainaya yafe ani kea humaine. Tamakaya veaꞋmoꞋya heꞋotigahae hutama nehaya kea havige nehae.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nago kanoa kahegi kema havilinea kanomoꞋa anile eno huge havige haya kea haviana YisasiꞋa kanale kema huhaleno hamapaiya kea me haviteno Yisasifena mage huno havige “Anumaya Koti kahegi kefitila hana kemo mukiꞋa kemona agaseno uhagoteno tokiyaꞋage kea hane?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Havige-geno YisasiꞋa mage huno hie “Uhagoteno tokiyaꞋageꞋma humainea kemoꞋa mage huno humaine ‘Isaleli vayala* haviho AnumayamoꞋa tagaiti Anumaya KotiꞋa agaiꞋage mainegi nagoꞋa Anumaya omaine. Kagaya Anumaya Kotikamofena kahau kayamopafina tokiyaꞋage huno kahaino. MukiꞋa kagesama havisana yaꞋene kagu kamema havisana yaꞋene aliꞋya neꞋalina kayamufaene tokiyaꞋage huka Anumaya Kotina amio.’ ");
INSERT INTO kmu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anile nago kea mage huno humaineane ‘MukiꞋa vayafena tusiya huno kahau kayamopafi kahaino. Kagaika kaugafahema kahaisia avamete aniꞋa huno alu veaꞋmogami amaugafahena kahaino.’ Menima tole kema kahapauva kemoꞋa mukiꞋa Anumaya Koti kahegi kemona ago amakasemainea ke hane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Higeno ani kahegi kema havilinea kanomoꞋa Yisasifena mage huno hie “Humavenelina kanomogae tamage nehane. Nagoke Anumaya Koti mainegi nagoꞋa Anumaya Koti omaiye. ");
INSERT INTO kmu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Omaigi tagaya mukiꞋa tahau tayamopafi tokiyaꞋage huno tahaisigeta mukiꞋa tagesama havisuna yaꞋene tagu tamema havisuna yaꞋene aliꞋya neꞋaluna tayamufaene tokiyaꞋage huta mukiꞋa Anumaya Kotina amisune. Amiteta mukiꞋa veafena tahau tayamopafi tahainageno tagaiti laugafahema tahaisia avamete aniꞋa huta alu veaꞋmogami amaugafahena tahaisie. NaꞋama hisuna yamoꞋa mukiꞋa alu kavala amakasemaine. Nayona veaꞋmoꞋya ‘Anumaya Kotina muse yana neꞋamune.’ huꞋya nagola sipi sipi heꞋya neꞋamiꞋya nago sipi sipia atafi kae salaꞋmana aineꞋataleꞋya nehaya yamona menima kahapauva kemoꞋa ani kavala ago agasemaine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","YisasiꞋa anima huhalenoꞋma hia kea haviteno “HaviꞋyamaꞋaene kano maineafenagino nahapaiye.” huno agesafinaga haviteno kenonaꞋa mage huno hie “Ani kema hana kemoga aupaꞋa Anumaya Kotife ‘Kava yagainato.’ huka hugane.” huno hie. HigeꞋya vayaꞋyagamoꞋya haviteꞋya koli huꞋya Yisasina nagoꞋene haviokenae. ");
INSERT INTO kmu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","YisasiꞋa ala mono nopi mo humavenelino mage huno hamavige “Kahegi kema havilinaya anagaꞋmoꞋya naꞋa higeꞋya Kalaisifena, ‘Anumaya KotiꞋa hutenea kanomofena Tevitina aginagomoꞋa mopale kano maine?’ huꞋya nehae.” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hamavinegeno mage hie “TevitiꞋa Anumaya Kotina Alu Aotage Avamumo hapaiya kea mage huno humaineane ‘Anumaya KotiꞋa Anumaya-niꞋamofena mage huno humaine ‘Tamaga nayatega, ala vaya mainalega hanea siale emainesanageꞋna kame vayakaꞋa kaiyafinaga amatesugeꞋya kagaife ‘Ago tagasane.’ huꞋya hugahae.’ huno kaemaleneane. ");
INSERT INTO kmu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","TevitiꞋa Kalaisife ‘AnumayaniꞋa mainane.’ huno humainegi naꞋa higeno TevitiꞋa haenagama atesia aginagomofena ‘AnumayaniꞋamoga mainane.’ huno humaineane?” huno hamavige. HigeꞋya mukiꞋa alitalu humainaya veaꞋmoya Yisasi kea haviteꞋya tusiꞋa muse hae. ");
INSERT INTO kmu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","YisasiꞋa hamapaiya kefiti mage huno hamapaiye “Kahegi kema havilinaya anagafena kaꞋyeho. Ani vayaꞋmoꞋya ayaꞋaya kena failiya yafena ‘Nelagafi notagafi?’ huꞋyama haya yafena tusiya huno nehamaiye. Vaya atagu nefaya kumapi mo vaiyatete nehuꞋya ‘NaꞋa vaya mainae.’ huꞋya ‘Ali falu fala hulatesae.’ huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mono nopiꞋene imuleꞋene ‘Ala vayaꞋageꞋma nemaiya sialekeꞋya maigahune.’ huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ani vayaꞋmoꞋya keto aꞋneyagahena ‘Mono nopima atalesaya monea tamiho.’ huꞋya nehuꞋya noꞋamifima hanea yaꞋyaga musufaya huꞋya moneꞋamia ali haꞋno nehaya vayalagiꞋya. VayaꞋyaga ayemavataga huꞋya ‘Kanale vaya mainae.’ huꞋya hisae huꞋya ayaꞋaya nunamu nehayane. AniꞋama nehaya vayaꞋmoꞋya havi miyana tusiya huno amaugafa amagata aisia yaꞋene aligahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","YisasiꞋa mono nopi mone neꞋatalaya kaiyaga maineno monema atalaya veala amakeana moneꞋamima hanea veaꞋmoꞋya “Monetia Anumaya Kotina amigahune.” huꞋya ala mone pokisifina atalenae. ");
INSERT INTO kmu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Atalageno nagola moneꞋa omale keto aꞋmoꞋa tole osi haesa monea metalene. Ani haesa yafatalamogania tokayaꞋagenoꞋa vani toya kana humaine. ");
INSERT INTO kmu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","YisasiꞋa ani yana ageteno agaiꞋaenema tokaeꞋya nemaiya anagafe ke higeꞋya ageno mage huno hamapaiye “Nagaya tamagelafa huꞋna tamahanepauve ma ma moneꞋa omale keto aꞋmoꞋa hagoteꞋyama metalaya veaꞋmogamina amakaseno ala mone metale. ");
INSERT INTO kmu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Metaleneanagi moneꞋamima hanea veaꞋmoꞋya aliꞋyamaꞋa omalenea monegiꞋya havigu malenaya monegiꞋya afaꞋa metalayanagi ani aꞋmoꞋa mukiꞋa yamaꞋa ali haꞋno huno metale. MukiꞋa kaveꞋama alino nesia moneꞋa mukiꞋa alino metale.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","YisasiꞋa ala mono nona neꞋataleno vigeno nagola agaiꞋaenema tokaeno nemaiya kanomoꞋa mage hie “Hulavenelina kanomogae male ago. Ala yafana kanale yafaꞋyagaleti kimalenaya kanale noꞋyaga hanegeka neꞋagane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Higeno YisasiꞋa mage huno hie “Kagaya mani kanaleꞋnale ala noꞋyaga neꞋagano? Ani mukiꞋa yafaꞋyaga alino lagape aitalesigeno aposilavisianagi nago yafamoꞋa nago yafamo agupifina aikalo huno omaigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","YisasiꞋa Olivi yosa hanea agoꞋyamo agegayalega haino mopale maineno ageana ala mono nona atu kaiyaga hanegeno neꞋagegeꞋya PitaꞋene YemesiꞋene YoniꞋene EtaluꞋene YisasiꞋma mainelega emainae. ");
INSERT INTO kmu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","EꞋya Yisasife mage huꞋya havigae “Ani yafa nomoꞋa tagapema aisia kana na kanafine? Hana augafa tokiya avame yamo ani kanama faloteꞋma hisia kanafina taveligahie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hageno YisasiꞋa mage huno hie “NagoꞋa vayaꞋmoꞋya havigema lamahapaisagetamahena ohavisaya yafe kaꞋye ho. ");
INSERT INTO kmu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","MukiꞋa vayaꞋmoꞋya nagai nagia neꞋayeꞋya ‘Anumaya KotiꞋa tamaugafa aligatisuna yafe hulategeta neꞋone.” huꞋyama hisayana kasagoꞋya veaꞋne havige ayemavataga hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“NagoꞋa kotega kamema nehae.” huꞋya hisagetamaene “Kotamile-gaenema kamema nehae” huꞋyama tamahapaisagetamahena kolia ohiho. Ani yaꞋyagamoꞋa hagoteno falote hugahianagi ma mopama haꞋno hisia kanamoꞋa yaufa falote ohune. ");
INSERT INTO kmu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","NagoꞋa vayaꞋmoꞋya alu vayaꞋenena kamea hugahae. Ala kotega vayaꞋene nago ala kotega vayaꞋenena kamea hugahae. KasagoꞋya alu kote kotela tusiꞋa imila aligahie. Alu kote kotela tusiꞋa kafu nehuꞋya amakatesia kanamoꞋa falote hugahie. Ani yaꞋyagamoꞋa afaꞋa aꞋnemoꞋya nafaꞋnema ategahema hageno aepa heno amagata neꞋaiya avamete kava hugahianagi haenagaꞋa tusiꞋa tamagata yamo falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tamakaitamia kava yagailama hiho. NagoꞋa veaꞋmoꞋya tamakaila tamavaleꞋya kanisole vayate kaiyekea hulamategahae. Mono nopi tamavaleꞋya kaꞋyona mo lamamigahae. Nagai nakaveꞋma haya yafe tamavaleꞋya ala kava vayateꞋene amakasemainea sauve vayateꞋene tamavaleꞋya hetilamatesageꞋya kaiyekea hulamatesagetama nagai kanale mono kea hamapaigahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hamapaigahayanagi hagoteꞋya Yisasi kanale mono kea aliꞋya ute ete huꞋya mukiꞋa kote veaꞋmogamina hamapaitesageno ma mopamoꞋa haꞋno hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","TamavaleꞋyama kaiyeke hulamatesaya kanafina kema hisaya yafena “NaꞋane huta hugahuneꞋ hutama tamakesa kuꞋmoꞋa ohutama afaꞋa viho. Ani kanafina kanale kema hisaya kea Anumaya KotiꞋa tamahapainagetama hugahae. Ani kea tamakai kea omalegi Anumaya Koti Alu Aotage AvamuꞋmoꞋa huno lamakesa hinagetama hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ani kanafina veaꞋmoꞋya amakaiꞋami nepuꞋamimona kame vayaꞋamimote amavaleꞋya visayaꞋamoꞋya ‘HamaegeꞋya faliho.’ huꞋya hugahae. NefaꞋa nafaꞋneyagaꞋa aniꞋa humategahae. NafaꞋneꞋamimoꞋya itaꞋafoꞋamimoꞋene-na aliyahae huꞋya kamea humateteꞋya ‘Hamaetama faliho.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nagima neꞋayaya yafe mukiꞋa veaꞋmoꞋya haviꞋya amaipa kafa helamategahae. NagoꞋa veaꞋmoꞋya nagai kemona meni kanaleti aepa heꞋya atafa huꞋya tokiyaꞋage hume hume neꞋvisageꞋna YisasiꞋna eteꞋnama esua kanafina nagai kema atafa hulinesaya veaꞋmogamina Anumaya KotiꞋa amaku amamena aligatigahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","YisasiꞋa nagoꞋene mage huno hie tusiꞋa havi yana ma mopa alino hagagitalesia yana alu aotage yapi hetimainesigetama agegahae. Anima tamamaꞋyoma aisia yama agenuta-mahena Yutia mainaya veaꞋmogatama tamaiyayetama agoꞋyalega viho. Ani YisasiꞋma humainea kema hapalitama havisamogatama havilama hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nagi nago kanomoꞋa nogatofuleꞋma haino maineno ani kema havinunofena tavino nomaꞋafinagati haifaleno nagoꞋa yana oꞋalino. AfaꞋa aiyayeno vino. ");
INSERT INTO kmu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","NagoꞋa veaꞋmoꞋya hoyafinagama mainesaletila kenaꞋamima aligahena notega eteꞋya oꞋviho. ");
INSERT INTO kmu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","AvoꞋnio ani kanafina tusiꞋa havi yamo falote hugahie. Amaipaene aꞋnene nute anilinesia nafaꞋnemogami itaꞋamimoꞋyaenefena tusiꞋa nahau nehie. ");
INSERT INTO kmu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Anumaya Kotitega nunamuna mage hutama havigeho “Ani havi yamoꞋa tani koꞋma ikate tisia kanafina falote ohisie.’ hutama havigeho. ");
INSERT INTO kmu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ani kanafina tusiꞋa kana ya falote hugahie. EheꞋma Anumaya KotiꞋa ma mopama talo humalenea kanafiꞋene meni kanafiꞋenena aniꞋa ala kana yana falote ohuneanagi tusiꞋa ala kana yamoꞋa nagoꞋene haenagaꞋa aniꞋa huno falote ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Anumaya KotiꞋa ani havi kanama alino aupa ohileꞋasina mukiꞋa veaꞋmoꞋya falileꞋasinagi Anumaya KotiꞋa haigenoꞋma hapalimatenea veafe agesa havino amaugafa aligatisia yafe ani kanaꞋa alino aupa hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ani kanafina nagoꞋa veaꞋmoꞋya mage hugahae “Anumaya KotiꞋma taugafa aligatigahie huno hutenea kanoa ma mainegi ageho. Atu mainegi ageho.” huꞋya hisagetamahena “Tamage nehae.” hutama havitama tamametitia ohiho. ");
INSERT INTO kmu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ani kanafina nagoꞋa havigeꞋage amaune vayaꞋene “Nagaya Anumaya KotiꞋma tamaugafa aligatigahie huno hunatenea kano mainoe.” huno havige hisia kanoene evaꞋyi huꞋya veaꞋmogamina ayemavataga hugahe tokiyaꞋage avame yana hugahayanagi Anumaya KotiꞋa haꞋye huno hapalimatenea veaꞋmoꞋya ohavigahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ohavigahagi falote ohunaya kanafina ago tamahapaimainogi kaꞋyetama maiho. ");
INSERT INTO kmu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ani havi kanamoꞋa haꞋno hutesigeno yagemoꞋa hanimaꞋage hinageno ikamoꞋa aivasa ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","KaꞋnefiꞋmoꞋya ikatetila atafailavigahie. IkateꞋma hanea yaꞋyagamoꞋya kanage kanage huno alu kate kate vaiyegahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","MukiꞋa ani yamoꞋa falote hutesigeꞋna ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna ikapinagatila siate elavisugeꞋya nagegahae. TusiꞋa tokiyaꞋniene tusiꞋa hale yaniꞋaene esugetama nagegahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","NenagesageꞋna ensole vayaꞋnia humatesugeꞋya yagemoꞋma tavi nefalelegatiꞋene evaꞋyi nehilegatiꞋene aluga aluga haupalegatiꞋene mukiꞋa mopaene mopaene nagaiꞋniꞋa nahaigeꞋna hapalimatenoa veaꞋnea aluga aluga mukiꞋa ma mopamona atupaletiꞋene ikamo atupaletiꞋene amavalesageꞋya melitalu hugahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","YisasiꞋa mage huno hie “Fiki yosamoꞋa nago avame ya tamaveligahigi ageho. Ani yosamoꞋa hagoteno akopapitiꞋma agusasiyeno amuꞋma malesigetamahena ‘Anuna valesia kanamoꞋa falote hugahe nehie.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","NaꞋa hugahayanagi manima tamahanepauva kuguva yama agenutamahena “YisasiꞋa esia kanamoꞋa ago aupa higeno fiate hetino maineanagino ago egahie.’ hutama tamakesa havigahae. ");
INSERT INTO kmu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nagaya tamage huꞋna tamahanepauve meni kanafima mainaya veala ofalinesageno ani yamoꞋa falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","IkaꞋene mopaene fanane hugahianagi nagai kemoꞋa fanane ohugahie. ");
INSERT INTO kmu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Manima tamahapauva kanama falote hisia kanahena nago kanomoꞋa ohavine. Ikapinaga mainaya ensole vayaꞋmoꞋya ohavinae. Anumaya Kotina nafaꞋneꞋamoꞋna ani kanama falote hisia kanahena ohavinoanagi nenafaꞋa agaiꞋage haviline. ");
INSERT INTO kmu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tamakaya ani kanama falote hisia kanahena ohavinaya yafe tamaula ofaetama tamakaitamile yagaiho. ");
INSERT INTO kmu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nago kava kanomoꞋma hia kava huno YisasiꞋa egahie. Ani kava kanomoꞋa aliꞋya vayaꞋamofena ‘Ma aliꞋyana alu aliꞋya alu aliꞋyana tamahaote tamahaote yagaitama maiho.’ huneꞋamateno “FiateꞋma mainamoga kagaikaꞋa yagaiyo.” huneꞋateno ataleno alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","NaꞋa humaineafe tamakaya aniꞋa hutama yagaiho. Nomona nefaꞋma esia kanahena ohavinae. Une esio? Kege amuꞋnopi esio? KokolemoꞋa age neꞋaisigeno esio? Ifi nate esio? Esia kanahena ohavinaya yafe kava yagaitama maiho. ");
INSERT INTO kmu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Faetama mainesageno havigu aupaꞋa esigetama tamakaye hu yafenagi kaꞋyetama maiho. ");
INSERT INTO kmu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mani kea tamakaifema hua kea mukiꞋa veaꞋmogamife nehugi kava yagaitama tokiyaꞋage hutama maiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ani kanafina tole yupa maiteꞋya kafuꞋahe kafuꞋahe Anumaya KotiꞋma amakinagomo amaugafama aligatimainea yafe* alitalu huꞋya hale oki kaihamena nenaya imu kigahe nehageꞋya mono note kava vayaꞋmoꞋyaene kahegi kema havilinaya anagaꞋene Yisasina haesaya kea kesi ako huꞋya atafa hisaya yafe ke huge havige humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mage huꞋya hae “MukiꞋa veala imuleꞋma alitalu huꞋya maisafima Yisasina atafama hisunageꞋya mukiꞋa veaꞋmoꞋya ageteꞋya ke huꞋya atile male huꞋya tu hugahae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","YisasiꞋa Petani umaineno nayona fugitaya agemainea kanomo agia SaimoniꞋe kanomo nopi umaine. Mopale umaineno kave nenegeno nago aꞋmoꞋa anile eno manaꞋage masavena havatemai yafa keꞋayola alilino emaine. Ani keꞋayopina nagola tusiꞋa monele hanea masavena manaꞋage tina hane. Ani limo agia natie. Ani keꞋayoꞋma taloma hia yafamo agia alapasata yafane. Ani aꞋmoꞋa masave keꞋayola alino aitagino Yisasi anupi takino faletene. ");
INSERT INTO kmu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","FaletegeꞋya nagoꞋa anile mainaya vayaꞋmoꞋya ageteꞋya ke vaiꞋya mohu mehu nehuꞋya mage huꞋya hae “NaꞋa higeno mani aꞋmoꞋa manaꞋage masavena afaꞋa neꞋatale? ");
INSERT INTO kmu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nago kanomoꞋma miya hileꞋasina tali hataleti kina (K300) aluteꞋasine. Aliteta ani masavete monea alita afenoꞋamima omalenea veaꞋnea amamuteꞋasine.” huꞋya ani aꞋmofena “Kefo kava talo hane.” huꞋya kemakimainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ke neꞋamakigeno YisasiꞋa mage huno hie “Agaila afaꞋa ataleho. NaꞋa higetama kea neꞋamakiye? Ani aꞋmona aipamoꞋa haviya hisia kava nehagi nagaila tusiꞋa kanale kava hunenate. ");
INSERT INTO kmu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","AfenoꞋamima omalenea veaꞋmoꞋya mukiꞋa kanafina tamakaiꞋene maigahayanagitama amaya hisaya tamakesama havisayana amaya hugahayanagi nagaya tamakaiꞋenena mukiꞋa kanafina omaigahue. ");
INSERT INTO kmu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ani aꞋmoꞋa amukoꞋa hanegeno ani kavala hagoteno afaꞋa ofaliꞋna mainogeno masavema faleꞋya hevainatesaya masavena agola fale nenate. ");
INSERT INTO kmu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tamage huꞋna tamahanepauve mukiꞋa ma mopafi veapima Yisasifena kanale mono kema hamapaisayana ani aꞋmoꞋma hia kavafeꞋenena hamapaisageꞋya mukiꞋa veaꞋmoꞋya agaife amakesa havi havi huꞋya maigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ani kanafina Yutasi IsakaliotiꞋa tuelufuꞋa (12) anagaꞋaene nemaiya kanomoꞋa viaꞋamo Yisasina agesi huno momavalesigeꞋya metafa hisaya yafe mono note kava vayatega umaine. ");
INSERT INTO kmu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ViaꞋamo mo hamapaigeꞋya ani kea haviteꞋya tusiꞋa muse huteꞋya ‘Mone kamigahune.’ huꞋya hapaitageno YutasiꞋa vaya kuluta oꞋai yate kesi kateti momavaleno esigeꞋya Yisasina haesaya kafe atiyemaine. ");
INSERT INTO kmu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hale oki kaihame kana maya nenaya kanamoꞋa ehe kanale Anumaya KotiꞋa Yuta vaya amaugafama aligatimainea kanahe amakesa nehaviya imuma kigahena sipi sipi heꞋya kiꞋya nenaya kanamoꞋa falote higeꞋya YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya Yisasina mage huꞋya havigae “Hanatega kahaisia kumatela Anumaya KotiꞋa amaugafama aligatimainea kanahe kagesa havisana kavela mo lalo tala hisune?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hageno YisasiꞋa tole kanolatana hunateno mage huno hanapaiye “Ala kumate neꞋviꞋageno ti keꞋayoꞋma alino esia kanoene fotu hutetana akave viꞋo. ");
INSERT INTO kmu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Akave neꞋviꞋageno haino mo falesia nopi haitana ani nomona nefafe mage hutana havigeꞋo ‘Hulavenelia kanomoꞋa mage hie ‘Hanate ayenalagimalenana nona hane? Yoka namisanageꞋna nagaiꞋene tokaeꞋya nemaiya anagaꞋniene Anumaya KotiꞋa amaugafama aligatimainea kanahe tagesa havisuna kavela nesune?’ huno hie.’ hutana havigeꞋo. ");
INSERT INTO kmu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","HisaꞋagenoꞋa folamo huno anale kimalenea nona ago alino hilato humaleneanagino ala nona tanavelisigetana kavetia talo tala hiꞋo.” huno hanapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","HigeꞋana ala kumate vaꞋana YisasiꞋma hia kemoꞋa mukiꞋa falote higeꞋana ageteꞋana Anumaya KotiꞋa amaugafa aligatimainea kanahe amakesa havi havi hisaya kavela talo tala humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Talo humalenaꞋageꞋya yagemoꞋma tavi faleamaꞋa YisasiꞋa tuelufuꞋa (12) anagaꞋamoꞋyaene emainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mopale emaineꞋya kavela nenageno YisasiꞋa mage huno hie “Tamage huꞋna tamahanepauve nagaiꞋenema kaveꞋma nenaya anagaꞋmogatama tamakaipiti kesi nahaesaya yatela nago kanomoꞋa vaineꞋaye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","HigeꞋya ani anagaꞋmoꞋya amaipa haviya huteꞋya agaifena amahaote amahaote mage huꞋya hae “Nagaife nehano?” higeꞋya “Nagaife nehano?” higeꞋya huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Havigageno YisasiꞋa mage huno hie “Tamakaya tuelufuꞋa (12) anagaꞋnimogatama tamakaipiti nagokeꞋmoga kesi nahaesaya katela vaineꞋayane. Ani kanomoꞋa nagaiꞋene nagoke yopafiti kaihame kana maya ali vayagofino nene. ");
INSERT INTO kmu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemonihena Anumaya Koti autaꞋmafima kaemalenaya avamete kava hugahuanagi vayaꞋmoꞋya havisagi huno nagesi hunatesia kanomofena ‘AvoꞋnio nahau hanagi kagaya maigaꞋyeka mainekao.’ huꞋna nehue. Ani kanomoga itakamoꞋa okateneleꞋasina tusiꞋa kanale kava hileꞋasine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ani kavela nenageno YisasiꞋa kaihame kana maya alino nunamu huteno muse huno havigeno kolite kolite huno neꞋamamino mage huno hie “Aliho. Mamona nagaiꞋni naugafae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nagola vaini nofi alagamo ti* hanea keꞋayola aliteno nunamu huno muse huno havigeno alino amamite amamite higeꞋya nemainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nenageno YisasiꞋa mage huno hie “Mamona nagaiꞋni kolane. VayaꞋmoꞋya nahaesageꞋna falisugeno kolaniꞋamoꞋa takilavino mukiꞋa veafene huno takilavisia yafe Anumaya KotiꞋa hulokiya vaino alino halegafilamatenea kemo* aepamoꞋa alino fatago hugahie. ");
INSERT INTO kmu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tamage huꞋna tamahanepauve menia nagaya vaini nofi alagamo timaꞋa* nagoꞋene onegahuanagiꞋna Anumaya KotiꞋma kava yagaimainea kumate umaineꞋna haegafa nofi alagamo tina* eteꞋna negahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","HigeꞋya yagamea nagola huteꞋya Olivi yosa hanea agoꞋyafi haimainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","YisasiꞋa mage huno hamapaiye “Tamakaya mukiꞋamogatama nagaife havitama tamakupi maletama tamametiti nehaya yana ataletama asaga hulavisagi nayona ani yafe kaemaleneane ‘Nagaya sipi sipi kava kanoa haesugeꞋya sipi sipiyaga atagufeꞋya falegahae.’ huno kaemaleneane. ");
INSERT INTO kmu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kaemaleneanagi falimainesufiti Anumaya KotiꞋa alino hetinatesigeꞋna Kalili uhagotelamateꞋna visugetama nakave egahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Higeno PitaꞋa kenonaꞋa mage huno hie “MukiꞋa anagala kagaifema haviꞋya amakupi maleꞋya amametiti nehaya yama ataleꞋya falesageꞋnahena nagaya aniꞋa ohugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Higeno YisasiꞋa mage huno hie “Tamage huꞋna kahanepauve meni kegela kokolemoꞋa tole kanale agea oꞋainesigeka kagaya tagufa (3) kanale mage hugane ‘Nagaya oꞋagenoa kanoe.’ huka avane hunategane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Higeno PitaꞋa tokiyaꞋage ke huno hie “KagaiꞋene nahaesageꞋna faligahuanagiꞋna kagai kagihena avanena huꞋna fala okigahue.” huno higeꞋya mukiꞋa anagaꞋmoꞋya nagoke kegeꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","HuteꞋya Ketesemani uvaꞋyi hageno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagafena mage huno hie “Tamakaya male maineho. Nagaya Anumaya Kotitega nunamu huꞋna havigegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","PitaꞋene YemesiꞋene YoniꞋene amavaleno viana aepa heno aipamoꞋa kanaꞋage higeno haumana halegeno kasageke hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Huteno mage huno hamapaiye “Nahau nayamopamoꞋa tusiꞋa kanaꞋage nehigeꞋna ago falisua kava nehugi male mainetama kava yagaitama maineho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","OsiꞋa viaꞋamo nunamu huno havigegahe mopafi agoꞋya moyeno maineno nunamuna mage huno havige “Kahaisigekahena falisua kanaꞋnia alitalesane huꞋna kahavinegoe. ");
INSERT INTO kmu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nenafagae kagaya mukiꞋa yana kanale hateꞋasine. Nagaya falisua kava nehugi ani havi kanamoꞋa satuꞋage hia ti kana tima hanea keꞋayola nahafaletalo. AfaꞋa nagai nagu nagesa akave ohuka kahaisia yana afaꞋa huo.” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Havigeteno viaꞋamo momakeana agaiꞋaenema tokaeꞋya nemaiya anagala faeꞋya mainageno Pitafena mage huno hie “Saimonigae faekage mainano? Vae kagaya aupa kana kanoꞋa kava oꞋyagaikage mainano? ");
INSERT INTO kmu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","SataniꞋa ayelamavataga hisigeno tamakuꞋamoꞋa ‘Ohugahue.’ huno tokiyaꞋage humaineanagi afaꞋa amega tamaugafamoꞋa tokiyaꞋa omaleneanagino ‘Hugahue.’ huno hisia yana hugahigi Satani kema ohavisaya yafena kava yagaitama mainetama Anumayamotega ke hutama havigeho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huteno amataleno viaꞋamo Anumayamotega havigea kea aniꞋa huno nagoꞋene mo havige. ");
INSERT INTO kmu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Havigeteno eteno momakeana amau tokotoko higeꞋya faeꞋya mainageno momakeanagi “Vae tagaya naꞋane hisune?” hugeꞋya amakesaguꞋmo humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hageno YisasiꞋa eteno eaꞋamo tagufa (3) kanale amakaifena mage huno hamavige “Maifalu hutamage faetama mainao? Hailagino kanaꞋnia ago falote nehie. Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemonia nagesi huno navaleno kefo yama nehaya vayaꞋmogami amayapi natesigeꞋya nahaegahe nehae. ");
INSERT INTO kmu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","MukiꞋamogatama hetitama vigetao. Ageho nagesi huno nahaesia kanoa ago neꞋegi vigeta mogamano.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","YisasiꞋa mani kea nehigeno aupaꞋa YutasiꞋa tuelufuꞋa (12) anagaꞋaenema tokaeno nemaiya kanomoꞋa evaꞋyi higeꞋya agaiꞋene mukiꞋa vayaꞋyagaene mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene nagoꞋa Yuta vayatamaenema humataya vayaꞋmoꞋya ayaꞋaya naepege naipege huꞋya muki kaꞋyoꞋene aliꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Agesi huno Yisasina haesaya yama amavalisea kanomoꞋa vayaꞋyagahena mage huno hamapaiye “AtakoꞋma hisua kanoa haesaya kano mainegi atafa hutama tokiyaꞋage hutama avaletama viho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","YutasiꞋa evaꞋyi huno Yisasite eaꞋamo mage hie “Hulavenelina kanomogae.” nehuno atako me hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Atako higeꞋya ageteꞋya vayaꞋyagamoꞋya Yisasina atafa huꞋya ayetalako humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atafa nehageno nagola agaiꞋaenema hetimaiya kanomoꞋa ayaꞋaya naepeꞋa hevayu huno ala mono note hagote kava kanomo aliꞋya kanoꞋamo agesa aifakalitalegeno asaka hulavimaine. ");
INSERT INTO kmu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aifakalitegeno YisasiꞋa mage huno hie “Tamakaya nagaifena ‘Vaya nehamaeno musufaya nehia kano maine.’ hutama nagaiꞋma natafa hugahena ayaꞋaya naepene muki kaꞋyoꞋene alitama neꞋao? ");
INSERT INTO kmu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","MukiꞋa kanafina efiꞋefi huꞋna tamakaiꞋene maineꞋna ala mono nopina mono kea huhaleꞋna nehuanagi nagaila natafa ohunayanagi afaꞋa kanalele. Nayoma kaemalenaya kemoꞋa falote huno tamage hisia yafe menia natafa nehae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","HigeꞋya mukiꞋa agaiꞋaenema tokaeꞋya nemaiya anagala neꞋataleꞋya fale haꞋno humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Nago neyamoꞋa aye ohati kena kenalafamaꞋage failino Yisasi akave umainegeꞋya agaila atafa hugahe hageno kenaꞋa hateno neꞋataleno augafa alapaꞋage aiyayeno faleno umaine. ");
INSERT INTO kmu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yisasina avaleꞋya ala mono notela hagote kava kanomote ageꞋya mono note kava vayaꞋyagaene Yuta vayatamayagaene kahegi kema havilinaya anagaꞋene alitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","PitaꞋa akave anatino vianagi avatela oꞋunegi aluꞋale umaineno ala mono notela hagote kava kanomo nomo haupale uvaꞋyi huno ati vayaꞋene mopale umaineno atale tota huno maine. ");
INSERT INTO kmu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mono note kava vayaꞋmoꞋyaene mukiꞋa kanisole vayaꞋene YisasiꞋma haesaya kaiyekema hutegahena nagoꞋa vayaꞋmoꞋya “Kefo kavala higeta agemainone.” huꞋya hutesaya vayafe atiyayana omainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","OmaigeꞋya kasagoꞋya vayaꞋmoꞋya havige huꞋya Yisasifena hayanagi amakai kemoꞋa nago katela ohunagi alu ke alu ke maiꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","NagoꞋa vayaꞋmoꞋya hetiꞋya havige huꞋya Yisasifena mage huꞋya hae “Tagaya agaiꞋama humainea kea havilinone mage huno humaine ‘Nagaya vayaꞋmoꞋyama kimalenaya ala mono nona aliꞋna lagape aitaleꞋna tagufa (3) kanafi ani nona eteꞋna vayaꞋmoꞋya nokiya avamete no ali hetigahue.’ huno higeta havilinone.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hayanagi ani kemoꞋa nago avamete kea ohunagi alu ke alu ke maiꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hageno ala mono notela hagote kava kanomoꞋa amuꞋnoꞋamifi hetimaineno Yisasina mage huno havige “Na augafa ke kagaifena nehae? Kagaifena kaiyekema hunegatayana kenonaꞋamia hufalote huka nohane?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Havigeanagi YisasiꞋa kea ohuno avaya lukino maineno nagola osi ke kanoꞋa ohutafa huno mainegeno ala mono notela hagote kava kanomoꞋa eteno nagoꞋene havige “Kagaya Anumaya KotiꞋa taugafa aligatigahema hugatenea kano mainano? Kagaya agima alisaga nehaya Anumaya Kotina nafaꞋneꞋamoga mainano?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Havigegeno YisasiꞋa hufalote huno hie “E, nagaya ani kano mainoanagitama tamakaya haenagaꞋa Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemonia tusiꞋa tokiya yamaꞋa hanea Anumaya Kotina tamaga ayatega hanea siale maineꞋna ikate hanea siate esugetama nagegahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Higeno ala mono notela hagote kava kanomoꞋa ani kea havigeno aipamoꞋa tokiyaꞋage higeno kenaꞋa alino hatata nehuno mage huno hie “Tagaya hai havunanagiꞋya nagoꞋa vayaꞋmoꞋya kaiyekea huoꞋatesae. ");
INSERT INTO kmu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anumaya Kotifema huhaviya hutea kea ago nehavigi. Na tamakesa nehaviye?” huno higeꞋya mage huꞋya hae “Tamage nehane anona yamaꞋa alisia yafe haesageno falisie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","HuteꞋya nagoꞋa vayaꞋmoꞋya Yisasina amavetuꞋna heneꞋateꞋya aulagafi aiso huteneꞋya aikoneliꞋya mage huꞋya havigae “Kaune kema nehana kanomoga tahapaiyo taꞋya negahayae?” huꞋya havinegeꞋya ati vayaꞋmoꞋya amayateti aikolimainae. ");
INSERT INTO kmu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","PitaꞋa nomo haupalega afetega mainegeno ala mono notela hagote kava kanomona aliꞋya munaꞋmoꞋa anile emaineno ageana PitaꞋa ata lota nehigeno ani munaꞋmoꞋa megeteno Pitana agesagali maineno mage huno hie “Kagayaenena Nasaleti YisasiꞋene vaiyatete nehana kanoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Higeno PitaꞋa avane huno “AꞋao nagaya ani kanoa oꞋagenoa kanohe maika nehane.” huno nehuno fiate neꞋvigeno anile kokolemoꞋa agea aimaine. ");
INSERT INTO kmu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Fiate mainegeno ani munaꞋmoꞋa mogeteno anile hetimaiya vayafena mage huno hie “Mani kanoa Yisasi anagapiti kanoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Higeno PitaꞋa nagoꞋene eteno “AꞋao nagaya ani kanoa omainoe.” huno hie. Osi kana kanoꞋa maigeꞋya anile hetimaiya vayaꞋmoꞋya mage huꞋya hae “Tamage kagaya Kalili kano mainana yafe agaiꞋene vaiyatete nehana kano mainane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hageno PitaꞋa mage huno hie “Nagaya tamagema ohisugenoꞋa Anumaya KotiꞋa nahaesie. Anumaya Koti aulagafina tamage huꞋna tamahanepauve tamakayama haya kanoa nagaya oꞋagenoa kanoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nehigeno aupaꞋa hagoteno agema aiya kokolemoꞋa anile viaꞋamo agea aigeno Pitana agesamoꞋa aikalo higeno YisasiꞋma hapaigeno havimainea kea mage huno humaineane “KokolemoꞋa tole kanale agea oꞋainesigeka kagaya tagufa (3) kanale avane huka nagaifena ‘NoꞋagoa kano maine.’ huka hugane huno humainea kemoꞋa Pita agesamoꞋa aikalo higeno haviteno tusiꞋa avitemaine. ");
INSERT INTO kmu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kola alino halegeꞋya mukiꞋa mono note kava vayaꞋene Yuta vayatamaene kahegi kema havilinaya anagaꞋene kanisole vayaꞋene Yisasina haesageno falisia kea huge havige huteꞋya Yisasina nofi kiteteꞋya ala kamani kava kanole, Pailatite* avaleꞋya ayapi motenae. ");
INSERT INTO kmu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Motageno PailatiꞋa Yisasifena mage huno hie “Kagaya Yuta veaꞋmogami Sauve kano mainano?” huno havigegeno YisasiꞋa mage hie “KagaikaꞋa ani kea hai nehane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","HigeꞋya mono note kava vayaꞋmoꞋya kasagoꞋya kea “MaꞋa kefo kava humainane.” huꞋya hutenae. ");
INSERT INTO kmu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","HuneꞋatageno PailatiꞋa nagoꞋene mage huno hie “Havio mukiꞋa kefo yama nehana yana ali falote nehagi kagaya kenonaꞋamia naꞋa higeka nohane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hianagi YisasiꞋa kenonaꞋa nagola osi ke kanoꞋa ohigeno Pailatina amaꞋyo aimaine. ");
INSERT INTO kmu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","KafuꞋahe kafuꞋahe Anumaya KotiꞋa amaugafama aligatimainea kanahe amakesa haviꞋya imua negiyanagino PailatiꞋa mukiꞋa ani imu kisaya kanafina nagoke nofi hutegeno nemaiya kanoa vayaꞋyagamoꞋya haesaga huꞋya “Agaya esie.” huꞋya haya kanohe nofipitila “Hai haꞋno hanagi vuo.” huno huneꞋatea kanae. ");
INSERT INTO kmu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ani kanafina nago kanomo agia PalapasiꞋe kamani vayaꞋene tuma nehaya vayaꞋene maineno tuma haya kanafina vayala tavata nehamaeyaya vayaꞋene mainegeꞋya kina nopi avaleꞋya hutenayane. ");
INSERT INTO kmu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","HutenayanagiꞋya vayaꞋyagamoꞋya Pailatife mage huꞋya me hae “MukiꞋa imuma kina kanafima nehana kavala hulato.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hageno PailatiꞋa mage huno hamavige “Nagaya Yisasifena Yuta veate Sauve kanomofe ‘Hai haꞋno hanagi vuo.’ huꞋna hisugetama musena hugahao?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","HigeꞋya mono note kava vayaꞋmoꞋya ma amakesa haviye “MukiꞋa veala Yisasi kegeꞋya nehaviꞋya tagai kea nohaviye.” huteꞋya ani yafe Yisasifena amaipamoꞋa haviya huteteꞋya Pailatite avaleꞋya ageno PailatiꞋa ani yafe agesa nehavino humaine. ");
INSERT INTO kmu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Havianagi mono note kava vayaꞋmoꞋya mukiꞋa vayaꞋmogami amaipa moyeꞋya mage huꞋya hamapaiye “Mage hutama hiho ‘Palapasina atalesanageno afaꞋa esie.’ hutama hiho.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hageno PailatiꞋa vayaꞋyagahena mage huno hamavige “AniꞋa hisuana ma kanomofe tamakaya Yuta vayate Sauve kano maine hutama nehaya kanomofena naꞋa hutesue?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","HamavigegeꞋya mukiꞋa vayaꞋmoꞋya ala kefiti mage huꞋya hae “Yafaga yosale nili hetama asaigeno falino.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hageno PailatiꞋa mage huno hamavige “NaꞋa higetama na kea nehae? HanaꞋa augafa kefo kava humaine?” huno hianagi amakaya eteꞋya aliꞋya alapi ataleꞋya ala kefiti mage huꞋya hae “Yafaga yosale nili hetama asaigeno falino.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hageno PailatiꞋa mukiꞋa vayaꞋmoꞋya muse hisaya kava hugahue huno Palapasina nofipiti avaleno neꞋataleno Yisasina agata aisifa kaꞋyoteti haifu amiteno Yisasina ati vaya amayapi ateteno “Yafaga yosale nili hetama asaigeno falino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ati vayaꞋmoꞋya Yisasina avaleꞋya ala kava kanomo no haupalega umaineꞋya mukiꞋa amakaiꞋene nemaiya ati vayafe ke hageꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","EmaineꞋya Yisasina akaya ategahe “Ala kano mainane.” huꞋya hisaya yafe ayaꞋaya haesa kena aliꞋya faiteteꞋya avetaꞋnafaꞋage nofi aliꞋya mo aigalaki me aigalaki huꞋya tumano kula talo huꞋya Yisasina anute vaitenae. ");
INSERT INTO kmu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","VaiteteꞋya aepa heꞋya huhaviya hutegahena mage huꞋya hae “Felugae. Yuta vayaꞋmogami sauve kanomogae.” huꞋya akaya atae. ");
INSERT INTO kmu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","NeꞋateꞋya anute kaꞋyoteti nagoꞋene nagoꞋene huꞋya aikoneliꞋya augafale amavetuꞋna heneꞋateꞋya amaleꞋya ayeꞋya mopale maineꞋya “Ala kano mainane” huꞋya ayevataga vatago humainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kigi huneꞋateꞋya haesa kena hateneꞋataleteꞋya agaiꞋa kena faiteteꞋya yafaga yosale nili hegahe avaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kategama vayana SaimoniꞋene fotu humainae. Ani kanoa Sailini kumate kanoe. AlekasataꞋene Lufasiganiene neꞋanafaꞋe. Ani SaimoniꞋa hoyafinagati kate eneꞋvigeꞋya ati vayaꞋmoꞋya tokiyaꞋage ke huꞋya “Kaiyayeka yafaga yosa melika vuo.” huꞋya hageno molino umaine. ");
INSERT INTO kmu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Alino vigeꞋya Yisasina avaleꞋya vayaꞋamoꞋya Kologota kumate uvaꞋyi hae. Ani kumaꞋmo agimoꞋa tagaiti kefina anu ayamufa kumale huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ani ati vayaꞋmoꞋya “Haesunageno falisiana agata ai yafenagita agatama oꞋaisia tina amisunageno nesie.” huꞋyama hayana anima agata oꞋaisia timo agia mea. MeaꞋene nofi alagamo tiꞋene nagopi ali havigu huteꞋya aliꞋya amiyana YisasiꞋa ani tifena “AꞋao.” huno onene. ");
INSERT INTO kmu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","OnegeꞋya yafaga yosale nili heꞋya asaimaleteꞋya kenaꞋa fako huꞋya aligahe musufa yama nehaya yokalo lageꞋya amakasaya vayaꞋmoꞋya alimainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Natena naeni (9) kiloki yagemoꞋa anale hai vaꞋyi higeꞋya Yisasina yafaga yosalela nilia maleꞋya heteꞋya asaimainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","AsaiteꞋya “Ma kava higeta haune.” huꞋya kaemalenae “Mani kanoa Yuta veate ala Sauve kanoe.” huꞋya kaeꞋya malenae. ");
INSERT INTO kmu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","KaemaleteꞋya YisasiꞋene tole kanolatana vaya nehamaeꞋana musufa yama nehaꞋa kanolatana nago kanoa Yisasina tamaga kaiyagaꞋa haeꞋya asaimaleꞋya nago kanoa haoga kaiyagaꞋa haeꞋya asaimaleꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","HumalenageꞋya kateꞋma ute ete huꞋya agasaya vayaꞋmoꞋya amakeꞋya kaꞋyo aiꞋya “Kefo kano maine.” huꞋya kigi yokalofiti huhaviya huneꞋateꞋya mage huꞋya hae “Oho kagaya ‘Ala mono nona aliꞋna lagape aitaleteꞋna tagufa (3) kanafi eteꞋna kitalegahue.’ huka nehana kano mainane? ");
INSERT INTO kmu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Menia kagaya yafaga yosa neꞋataleka kagaikaꞋa elavika kaugafa aligatio.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","HageꞋya mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene amakaiꞋami vayaꞋmoꞋyaene aniꞋa huꞋya kamuge hatageꞋya vaineꞋateꞋya mohu mehu huꞋya huhaviya huneꞋateꞋya mage huꞋya hae “NagoꞋa vea amaugafa aligatimainegi naꞋa higeno agaiꞋa augafa ali nokatie. ");
INSERT INTO kmu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kalaisiga Isaleli vayate Sauve kanoꞋamimoga yafaga yosa neꞋataleka elavigeta agamano. Agesunana kagaifena havita tagupi maleta tametitia hugahune.” huꞋya huhaviya huneꞋatageno agaiꞋenema yafaga yosaleꞋma asaimalaya musufa kanolatamoganienena aniꞋa huꞋana Yisasina huhaviya hutenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","YagemoꞋa euno amuꞋnokaꞋno higeno halemainea yamoꞋa haꞋno higeno mukiꞋa kotega tusiꞋa hanikino viaꞋamo une kanalega eteno ali halemaine. ");
INSERT INTO kmu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Une kanalega YisasiꞋa ala kefiti ke huno agaiꞋa kefiti mage huno hie “Eli Eli lema sapakatani.” huno hie. Tagaiti kefina mage huno hie “Anumaya KotiꞋnimogae, Anumaya KotiꞋnimogae naꞋa higeka nagaila nenatalane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","HigeꞋya nagoꞋa anile hetimaiya veaꞋmoꞋya haviteꞋya mage huꞋya hae “Ilaiyafe ke nehigi haviho.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hageno nago kanomoꞋa viaꞋamo hava koꞋyafa kana yana alino atuꞋage nofi alagamo tipi ayeteno alino viaꞋamo kupaga kaꞋyote maleno ani hava koꞋyafa kana yana kiteno “YisasiꞋa mayu mayu huno nesie.” huno neꞋamino mage huno hie “Agava maineta agesune IlaiyaꞋa yafaga yosaletila mevaleno elavisifi agegahune.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Higeno YisasiꞋa ala kegefa huteno falimaine. ");
INSERT INTO kmu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","FaligenoꞋa ala mono nopima ala kena ayaꞋaya kenagefama asaimalenaya kenamoꞋa YisasiꞋma falia kana kanoꞋale analeti aepa heno amuꞋnopiti hatata hulole hulavino mo talene. ");
INSERT INTO kmu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ati vayate kava kanomoꞋa Yisasina aulega hetimaineno YisasiꞋa kema huteno falia yana ageteno mage huno hie “Tamage huno mani kanoa Anumaya Koti nafaꞋnelafa maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","NagoꞋa aꞋneyaga aluꞋale maineꞋya agemainae. NagoꞋamogami amakia, osi YemesiꞋene Yosefegani itaꞋanimoꞋa MaliaꞋe SalomiꞋagi Magatala kumate MaliaꞋagi huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","YisasiꞋa Kalilima mainea kanafina ani aꞋneyagamoꞋya akave vaiyatete nehuꞋya kavela kaeꞋya neꞋamiyane. MukiꞋa aꞋneyaga YisasiꞋene Yelusalemu tokaeꞋya umainaya aꞋneyaga aluꞋale hetiꞋya maineꞋya Yisasina agemainae. ");
INSERT INTO kmu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sapati yupahe haviꞋya talo tala hisaya kanagino yagemoꞋa lavi falegahe higeno YosefeꞋa Alimatia kumate kanoa Yuta kanisolefi nemaiya kanoa evaꞋyi hie. Ani kanoa Anumaya KotiꞋma kava yagaisia kanahe muse huno agava nehia kanogino kolia ohuno Pailatite viaꞋamo mage huno havige “Yisasina augafaꞋa aligahe nehue.” huno mo havige. ");
INSERT INTO kmu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Havigegeno PailatiꞋa “AupaꞋa ago falimainegeka nehano? AvoꞋnio namaꞋyo aiye.” huno agesa nehavino nagoꞋa ati vayate kava yagaimainea kanohe ke higeno egeno “YisasiꞋa ago falimaineo?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Havigegeno ati vayate kava kanomoꞋa “E, ago falimaine.” huno higeno PailatiꞋa Yosefena mage huno hapaiye “Kanalelagi augafa afaꞋa moligane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Higeno YosefeꞋa viaꞋamo kaꞋyo muki ayaꞋaya kena molino viaꞋamo augafa yafaga yosaleti alino maleneno kenaleti augafalela aigalaki kalaki huno haꞋya kiteno alino viaꞋamo hefalegeꞋya kafimalenaya yafakapi Yisasina hevaiteteno avayaleꞋma aililesia yafana ayetufeno anile mo aililemalene. ");
INSERT INTO kmu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magatala MaliaꞋene Yosefena itaꞋamoꞋa MaliaꞋene maineꞋana hevaitea yafa kaana agemainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapati yupamoꞋa haꞋno higeꞋya Yemesina itaꞋamoꞋa MaliaꞋe hamoꞋamoꞋa Magatala kumate alagi SalomiꞋene Yisasina augafale manaꞋage masaveteti faletegahe ani masavena aliꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sota yupa yagemoꞋa yaufa nehaigeꞋya ani aꞋneyaga komulega vae. ");
INSERT INTO kmu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kategama vayana amakaiꞋamige kea hume hume umainae “Komumo avayaleꞋma aililemalea yafana ta taya huno avayaletila alino avayu huno faitega atalelategahie?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","NehuꞋya agesaga huꞋya agayana ani ala yafakefa ago alikelitalageno faitega hanegeꞋya agemainae. ");
INSERT INTO kmu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","AgeteꞋya ani yafakapinaga hai faleꞋya mogayana nago neyana aya tamaga kaiyaga mopale mainegeꞋya agayana ani kanomoꞋa ayaꞋaya efe kena failinegeꞋya ageteꞋya tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","AmamaꞋyo neꞋaigeno ani kanomoꞋa mage huno hie “Tamakaila tamamaꞋyoa oꞋaino. Tamakaya Nasaleti Yisasife ati neꞋayae. Yafaga yosale nilima heꞋya asaimalaya kanohe ati neꞋayayanagi agaya falimainefiti ago hetimaine. Mafina omainegi ani kanoma malaya kumala ma hanegi ageho. ");
INSERT INTO kmu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tamakaya utama YisasiꞋenema tokaeꞋya nemaiya anagaꞋene PitaꞋene mage hutama hamapaiho “YisasiꞋa ofalino afaꞋa mainenoꞋma tamahapaimainea kemoꞋa ago uhagotelamateno Kalili umainegi anilega neꞋutama Yisasina mogeho.” huno hamanepaiye. ");
INSERT INTO kmu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","HigeꞋya amakaya atili huteꞋya amamaꞋyo aigeꞋya yafakapitila hatilaviꞋya amaiyayeꞋya vayanagi kolima haya yafe nagoꞋa vayala ani kea hamaopainae. ");
INSERT INTO kmu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sota yupa nate alakefafi YisasiꞋa falimainefitila hetino viaꞋamo hagoteno Magatala kumate Malia mainelega uvaꞋyi higeno agemaine. Nayona ani aꞋmo agupina seveniꞋa (7) Satani Avamula mainegeno YisasiꞋa anatitaleneane. ");
INSERT INTO kmu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Ani MaliaꞋa ageteno viaꞋamo YisasiꞋenema tokaeꞋya nemaiya anagala mogeana tusiꞋa hamau huꞋya avineꞋatageno ani aꞋmoꞋa mage huno mo hamapaiye “YisasiꞋa falimainefitila ago hetigeꞋna nagaya agaila ago ageteꞋna neꞋoe.” huno hamapaigeꞋya haviteꞋya “Havige nehane.” huꞋya amametitia ohunae. ");
INSERT INTO kmu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","HaenagaꞋa ani vayapitila tolemogania kumala ataleꞋana katega neꞋvaꞋageno YisasiꞋa evaꞋyi higeꞋana agemainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","AgeteꞋana ani kanolatana eteꞋana vayaꞋanimoꞋya mainalega vaꞋaꞋamogani “YisasiꞋa naꞋa kano agoꞋe.” huꞋana mo nehaꞋana ani vayaꞋmoꞋya “Havige nehaꞋe.” huꞋya haviꞋya amametitia ohunae. ");
INSERT INTO kmu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","HaenagaꞋa aleveniꞋa (11) anagala kave maiꞋya nenageno YisasiꞋa evaꞋyi huno maineno amakaya vayaꞋmoꞋyama haya kemoꞋa “YisasiꞋa falimainefitila ago hetigeta agemainone.” huꞋya haya kema havisaya yafena amakuꞋamoꞋa tilegeꞋya haviꞋya amametitima ohaya yafe YisasiꞋa ke memamakie. ");
INSERT INTO kmu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kemamakiteno mage huno hamapaiye “MukiꞋa kotega utama nagai kanale mono kea alitama veaꞋmogamina mo hamapaiho. ");
INSERT INTO kmu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","HamapaisageꞋya nagoꞋa veaꞋmoꞋya ani kehena ‘Tamage nehae.’ huꞋya haviꞋya amakupi maleꞋya amametiti hisagetama tina falematesageno Anumaya KotiꞋa amaku amamena aligatigahianagi nagoꞋa veaꞋmoꞋya ani kehena ‘Havige nehae.’ huꞋya haviꞋya amakupi omalesaya veafena Anumaya KotiꞋa ‘Hani yapi tegelege nehia atafi viho.’ huno humategahie. ");
INSERT INTO kmu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nagai kema haviꞋya amakupi maleꞋya ametiti hisaya veaꞋmoꞋya ani tokiyaꞋage avame yana hugahae nagai nagile Kefo Avamula vea amakupitila amanati neꞋataleꞋya amaku amakesafiti ohavinesaya kefitila alu amake alu amakea aigahae. ");
INSERT INTO kmu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","VeaꞋma akafu neꞋamanisia osifaꞋvema atafa hisayana amaugafa amagata oꞋaisigeꞋya ofaligahae. VayaꞋma nefalia posini lima nesayana amaugafa amagata oꞋaisigeꞋya ofaligahae. Kalima neꞋaliya vayaꞋmogami amaugafaleꞋma amayama malesagenoꞋa kaliꞋamimoꞋa kanale humategahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","YisasiꞋa, AnumayatimoꞋe mani kea hamapaitegeno ikapinaga avalesaga higeno haino Anumaya Kotina tamaga ayatega umaine. ");
INSERT INTO kmu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","UmainegeꞋya YisasiꞋene tokaeꞋya nemaiya anagala mukiꞋa kotega ute ete huꞋya Yisasi mono kea hamanepaigeno AnumayamoꞋa amakaiꞋene vaiyeno amaya huno tokiya yamaꞋaleti “Ani kea tamage nehae.” huꞋya veaꞋmoꞋya havisaya yafe kasagoꞋya tokiya avame yana humainae. Mani kema hua kea tamage. ");
INSERT INTO kmu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofilasiga ala kava kanomoga mukiꞋa vayaꞋmoꞋya YisasiꞋma tagai amuꞋnopi humainea yana ago kaemalenae. ");
INSERT INTO kmu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yisasi kema hamanepaiya vayaꞋmoꞋya ehe kanale aepa heꞋya ani yana ageteꞋya tamahapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","MukiꞋama kahapaiya kemona aepaꞋa kelamake ke havisa-nafe nagaya kanaleꞋya huꞋna havilama huꞋna havilinoafe fatago huꞋna kaeꞋna kamigahue huꞋna nehue. ");
INSERT INTO kmu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nagi Yutia kotega ala kava kanomo agia HelotiꞋe kava yagaino mainea kanafina nago kanomo agia SekalaiyaꞋe mono note kava kano maineanagino Apaisa nofi kano mai-geno aꞋamoꞋa Eloni nofi vayapiti falote humaineane. Ani aꞋmo agia IlisapetiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ani alavelatana Anumaya Koti aulagafina fatago huꞋana mai-neꞋana mukiꞋa Anumayamo kahegi kea haviꞋana akave maleꞋana havi kavala ohunaꞋane. ");
INSERT INTO kmu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","IlisapetiꞋa namo a maineafe nafaꞋneꞋania omai alavelata kosuna alekano lemainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Apaisa nofi vayaꞋmoꞋya aliꞋya alisaya kana SekalaiyaꞋa Anumaya Koti aulagafi aliꞋyamaꞋa neꞋaligeꞋya mono nopi kava vayaꞋmoꞋya Sekalaiyafe “Kagayae.” huꞋya hageno SekalaiyaꞋa Anumaya Koti mono nopi maineno manaꞋage yana kaesalamana Anumaya Kotina huneꞋateane. ");
INSERT INTO kmu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Halinamo manaꞋa Anumaya Kotina neꞋamigeꞋya mukiꞋa veaꞋne-yaga kumatega maineꞋya Anumaya Kotitega havigemainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Havigageno SekalaiyaꞋa mono nopi mainegeno Anumayamo ensole kanomoꞋa agaite efalote huno manaꞋage ata kaemalea folamole* tamaga kaiyagaꞋa me hetimainegeno agemaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","SekalaiyaꞋa ani kanoa ageteno atali talu huno koli humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Koli hianagi ani kanomoꞋa mage huno hie “Sekalaiyaga kolia ohuka afaꞋa maiyo. Nunamuma humainana yafena Anumaya KotiꞋa ago havianagino akamoꞋa IlisapetiꞋa ne nafaꞋne atesigeka agia YoniꞋe huka malo. ");
INSERT INTO kmu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kagaya tusiꞋa muse nehisanageꞋya mukiꞋa veaꞋmoꞋya ani nafaꞋnema falote hisia yafena tusiꞋa muse hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ani nafaꞋnemoꞋa Anumaya Koti aulagafina ala agiene kano maineno havilina onegahia-nagino atenea kanaleti aepa heno Anumaya Koti Alu Aotage AvamuꞋmoꞋa aguꞋafina hiya hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hiya hisigeno mukiꞋa Isaleli kumate veaꞋnemoꞋya agai kea haviteꞋya amakuꞋa aiyahae huꞋya amakaiꞋami Anumaya Kotitega ugahae. ");
INSERT INTO kmu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anumayamo aulega hagoteno IlaiyaꞋma humainea kavaꞋene aminea tokiꞋyaꞋaene vigeꞋya amafaheꞋya agai kea haviteꞋya amakuꞋa aiyahae huꞋya nafaꞋneꞋamihena amakesa havigahae. Veganokano nehaya veaꞋneꞋmoꞋya agai kea haviteꞋya amakuꞋa aiyahae huꞋya fatago veaꞋneꞋmoꞋya humainaya kanale kea havigahae. AniꞋama hisayafe veaꞋneyaga AnumayamoꞋma esiafe amakuꞋa talo tala huꞋya maigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Higeno SekalaiyaꞋa mage huno hie “Tamage nehapi havige nehane? Nagaya kosunagiꞋna aꞋnimoꞋa alekano lemaineanagitaꞋa hanaꞋa hutaꞋa ani kea havisuꞋe?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Higeno ensole kanomoꞋa mage huno hie “Nagaya KepalieliꞋnae Anumaya Koti aule hetiꞋna mainogeno Anumaya KotiꞋa ani kanale kema kahapaisuafene huno hunategeꞋna emainoe. ");
INSERT INTO kmu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Havio nagai kemoꞋma haenagaꞋa efaloteꞋma huno tamage hisigeka keꞋnia ohavinanafe menia tugogekamoꞋa tileno atalako hinageka kaiyekea ohugananagika kema hua kemoꞋa efalote huno tamage hisia kanale tugogekamoꞋa akalo hinageka kagea aikalo hugane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","HigeꞋya kumate mainaya veaꞋmoꞋya Sekalaiyafe agava huge hugeteꞋya ayaꞋaya kanagefa Anumaya Koti noma hunalagimale nopima maiya yafe “NaꞋa higeno aupaꞋa nome.” huꞋya amakesa haviꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mainageno ani nopinagati hatilaviana kaiyekea nohie. Kaiyekema ohia yafe veaꞋmoꞋya amakesa mage huꞋya havimainae “Nopinaga maiya yamo alu ya agemai kano maine.” huꞋya havigeno ani kanomoꞋa ayateti avameꞋname huno kea hamapaiya-nagi avayamoꞋa tuki maine. ");
INSERT INTO kmu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tuki mainegeno aliꞋyamaꞋama haꞋno hia kanale nomaꞋalega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Umainegeno haenagaꞋa aꞋamoꞋa, IlisapetiꞋa aipaene maineno faefuꞋa (5) ikana falakino maineno mage hie “AnumayamoꞋa kanale ya hunatene. Nageteno veaꞋmogami amaulagafina nagayema humainoa yana ago alitalene.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","IlisapetiꞋa aipaene mainea ikana sikisiꞋa (6) ika agasetegeno Anumaya KotiꞋa nago ensole kanoa, Kepalielina, nago Kalili kotega hanea kumala, Nasaleti hutene. ");
INSERT INTO kmu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anumaya KotiꞋa nagola vene ofaenea munate Kepalielina hutegeno umaine. Ani munaꞋmo agia MaliaꞋe. Yosefena agaite hagemalenaya munale. Yosefena aginagomo agia TevitiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","KepalieliꞋa Maliate eno mage huno hie “Mainano? Anumaya KotiꞋa kagaila muse nehia munaꞋmoga AnumayamoꞋa kagaiꞋene maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Higeno anima hia kehena MaliaꞋa tusi amaꞋyo neꞋaino ma agesa havimaine “Ani kea naꞋane ke me nahapaiye?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Higeno ensole kanomoꞋa agaife mage huno hie “Maliaga kolia ohuo. Anumaya KotiꞋa kagaifena aipa kanale hunegate ");
INSERT INTO kmu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Havio kagaya kaipa ya huteka ne nafaꞋne ateteka agia YisasiꞋe huka malo. ");
INSERT INTO kmu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Ani nafaꞋnemoꞋa agi hanesia kano mainesigeꞋya veaꞋmoꞋya ‘Anale mainea Anumaya Koti nafaꞋne maine.’ huꞋya hugahae. AginagomoꞋa, Teviti kava yagaimainea tokiyaꞋa Anumaya KotiꞋa amisigeno Yekopu nofi veate agola kava yagaino maineno kava yagaisia tokiyaꞋa hanege hanege huno hanesigeno haꞋno ohugahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Higeno MaliaꞋa ensole kanomofe mage huno hie “HanaꞋa huꞋna aniꞋa hisue? Nagaya velela omainoa muna mainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Higeno ensole kanomoꞋa agaife mage huno hie “Anumaya Kotina Alu Aotage AvamuꞋamoꞋa kagaite emaisigeno anale mainea Anumaya Kotina tokiyaꞋamoꞋa aiso hugatesigeka maineka nafaꞋnea ategane. Atesanana alu aotage kanale nafaꞋne mainesigeꞋya veaꞋmoꞋya ani nafaꞋnehena ‘Anumaya Kotina neꞋamo maine.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Havio neꞋitakamoꞋa, IlisapetiꞋa, alekano lemaineanagi aipaene maineanagino ne nafaꞋne ategahie. ‘Namo a maine.’ huꞋya humainaya alekanomoꞋa aipaene mainea ikamaꞋa sikisiꞋa (6) ika agasemaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anumaya KotiꞋa tagaya ohuteꞋasina yanagi afaꞋa hugahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Higeno MaliaꞋa mage huno hie “Nagaya ago Anumayamo aliꞋya muna mainoe. Hana kemoꞋa kanalelagino nagaitela falote hunategahie.” huno hie. Higeno ensole kanomoꞋa anileti neꞋataleno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","MaliaꞋa ani kanafina hetino aiyayeno agoꞋyafi haino Yutia kotega hanea kumate umaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uvayi huno Sekalaiya nopi hai faleno Ilisapetina falu fala hutene. ");
INSERT INTO kmu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Falu fala huneꞋategeno IlisapetiꞋa MaliaꞋma hia kea nehavigeno aipafima mainea nafaꞋnemoꞋa kanage kanage higeno Anumaya Koti Alu Aotage AvamuꞋmoꞋa Ilisapetina aguꞋafina hiya higeno IlisapetiꞋa ala kefiti mage huno hie “Kagaya mukiꞋa aꞋneyaga amakaseka mainanageno Anumaya KotiꞋa kanale muse ya kamianagika atesana nafaꞋnea kanale muse ya alimainea nafaꞋne kaipafina maine. ");
INSERT INTO kmu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nagaya hanaꞋa a mainogeka AnumayaniꞋamona itaꞋamoga nagaitega neꞋane. ");
INSERT INTO kmu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Havio hu falu fala hunatana kea nagesafi nehavugeno naipafinaga mainea nafaꞋnemoꞋa tusi muse nehuno kanage kanage nehie. ");
INSERT INTO kmu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kagaya Maliaga Anumayamo ensole kanomoꞋa kahapaiya kea ago tamage huno falote hugahie huka ago havika kagupi maleka kametiti humainanafe Anumaya KotiꞋa muse hisana yana ago kamine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","MaliaꞋa mage huno hie “Nagu nafaꞋnemoꞋa Anumayamo agi alisaga nehigeno nagu namena alinegatia Anumaya KotiniꞋamofena tusi muse nehue. ");
INSERT INTO kmu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Muse nehuanagiꞋna nagaya afa munalagiꞋna aliꞋya munaꞋa mainoanagi agaiꞋa nagaila kalagi ainateanagiꞋna ani nafaꞋnea atesugeꞋya mukiꞋa veala meni veaꞋnene haenagama falote hisaya veaꞋnene nagaifena ‘Ma aꞋmona Anumaya KotiꞋa tusiꞋa muse hisia ya aminea ale.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tusi tokiyaꞋa hanea kanomoꞋa nagaila kanale ya hunatene. Ani kanomo agia ‘Kanale alu aotage kano.’ maine huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Agaife ‘Ala kanoꞋni maine.’ huꞋya humai-naya veaꞋmofena menima mainaya veaꞋnene haenaga veaꞋmogamifeꞋene tusiꞋa kalagi aimaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ayateti tokiya aliꞋyana alimaineanagino ‘Tagaya ala veaꞋne mainone.’ huꞋya amakuꞋafinaga nehaviꞋya amaugafa aliꞋya haimainaya amakesa haviya veaꞋmogamina amanatitalene. ");
INSERT INTO kmu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","TokiyaꞋage kava vayala alino mopafi amataleneanagi amakima omale veaꞋmogamina amakia alisaga humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","AmakuꞋafinaga amakaꞋ-nelea veaꞋmogamina kanale yana kasagoꞋya alino amamigeno amamu higeꞋya havatemainae. MukiꞋa yaꞋamima hanea veala oꞋamamino humategeꞋya ataleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","TaginagomoꞋa ApalahamuꞋene agaiꞋa nofi veaꞋnene haenagama falote hisaya veaꞋnenefe mage huno hie ‘Kalagi ailamategahue.’ huno nayona humainea kele menia agesa haviteno Isaleli kumate aliꞋya vayaꞋamogamina amaya humaine.” huno MaliaꞋa humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","MaliaꞋa IlisapetiꞋene tagufa (3) ika maiteno kumaꞋalega eteno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisapetina inamu ya alitegeno ne nafaꞋne atene. ");
INSERT INTO kmu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","AtetegeꞋya agaiꞋa kumate veaꞋnene agaiꞋa nofi veaꞋnene Anumaya KotiꞋa kalagi aitenea yafena haviteꞋya tusiꞋa muse humainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Nago sota maiteꞋya ani ne nafaꞋnemona agoya anoꞋya taga hisia ya agegahune huꞋya emaineꞋya nefate hamoꞋya hugahe agia SekalaiyaꞋe huꞋya malegahe nehageno itaꞋamoꞋa “AꞋao agia YoniꞋe huta malegahune.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","HigeꞋya veaꞋmoꞋya mage huꞋya hae “NaꞋa higeka ani agia nemalane? Tanakai nofi veaꞋmoga-mina aniꞋa amakia omalene.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nefa tugokemoꞋa tilemainegeno agema oꞋaiya yafe avameꞋname huꞋya “Na agi malegane?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Havigageno avameꞋname huno “Avo kaesua ya namiho.” huno higeꞋya amigeno “Agia YoniꞋe.” huno kaegeꞋya ageteꞋya vayaꞋmoꞋya “Nohaya kava hie.” huꞋya amamaꞋyoa aiye. ");
INSERT INTO kmu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ani agia kaemaletegeno aupaꞋa Sekalaiya tugokemoꞋa akalo higeno avefuꞋnamoꞋa ayaꞋaya higeno kaiyekea huno Anumaya Koti agia alisaga hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ani kumate veaꞋmoꞋya tusiꞋa amamaꞋyo aigeꞋya ani yafena ke hu atile male hageno ani kemoꞋa mukiꞋa Yutia agoꞋya hanea kumatega ute ete higeꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","HaviteꞋya veaꞋmoꞋya haviꞋya amakupi maleteꞋya mage huꞋya hae “AnumayamoꞋa aya hugahe agaiꞋene maineafe haenagaꞋa mani nafaꞋnemoꞋa hanaꞋa hisia nafaꞋne maigahie?” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","NefaꞋa, Sekalaiyana aguꞋafi Anumaya Kotina Alu Aotage AvamuaꞋamoꞋa me hiya huno havatemainegeno Anumaya Koti aune kano kana huno mage hie “Isaleli veaꞋmogati Anumaya KotiꞋa agaiꞋa veaꞋnele me laya huno taugafa aligatimainea yafe agia alisaga hisune. ");
INSERT INTO kmu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","TevitiꞋa Anumaya Kotina aliꞋya kanoꞋamo nofi anagapiti nago tokiyaꞋage kanoa taugafa aligatisia kano ali hetitene. ");
INSERT INTO kmu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ani kea Anumaya KotiꞋa nayona alu aotage aune vayaꞋamogami amavayafiti hu falote humaineane. ");
INSERT INTO kmu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mage huꞋya humainae ‘Kame vayatimoꞋya ago tatafa hulinaya vayaꞋmogamiꞋene tagaife amaipa kafa henelataya vayaꞋmogami amayapitila tavaleno taugafa aligatigahie.’ ");
INSERT INTO kmu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anumaya KotiꞋa taginagomofe ‘AigetamateꞋna tamaya hugahue.’ huno humainea yana hugahie. Alu aotage huno alino hagelafilateneafe agesa havi havi huno agekani otategahie. ");
INSERT INTO kmu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Alino hagelafilatenea kemona hulokiya vaino taginagomona Apalahamufe humaineane. Nayoma humainea kea menia ani kava hisiafe hie. ");
INSERT INTO kmu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Anima hulokiya vaimalenea kemoꞋa mage huno humaine ‘Nagaya kame vayatamimogami amayapitila tamavalesaga huꞋna tamaugafa aligatisugetama tamakaya kolia ohutama mukiꞋa kanafina tamahaimula hanesigetama kefo yatamia omale veaꞋnea fatago kavaꞋage hutama nagai naulela aliꞋyaniꞋa aligahae.’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","78","Humaineanagi kagaya Yoniga nafaꞋneꞋnimogae haenagaꞋa kagaifena ‘Anafinaga mainea Anumaya Kotina aune kanoꞋa mainane.’ huꞋya hugahae. Kagaya uhagoteka Anumayamo visia kana talo tala hugane. Anumaya KotiꞋa tagaifena tusiya huno kalagi ailateneafe agaiꞋa veaꞋnea kefo yaꞋamia agetamateno ataleꞋamateno amaku amamena aligatisiafe humavelisanageꞋya havigahae. Monafinagati halemainea kanoa falote huno tagaiteꞋma esiana ani kava hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hani yapi maineta faligahe humainona veaꞋmogata ayevasa hulateno ako huta maisuna kate tategahe egahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ani nafaꞋnemoꞋa ala huno agu agesamoꞋa tokiyaꞋage higeno kaꞋme kotega umaiteno Isaleli veaꞋmogami amaulagale efalote higeꞋya agemainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ani kanafina nago kava kanomo agia Sisa OgasatasiꞋe mage huno humaine “MukiꞋa Lomu kamanimoꞋya kava yagaimainesaya kumate veala amaki me ayegeꞋya kaeho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Higeno ani kanafina hagote kanale aepa heꞋya amakia kaemainayane. Ani kanafina nago osi kava mainea kanomo agia KuiliniusiꞋe ani kanoa Silia kotega kava yagaino nemaiya kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","4","MukiꞋa vayala amaki aligahe hageꞋya mopa aepaꞋamilega umainae. Yosefena aginagomoꞋa TevitiꞋma maineafe YosefeꞋa Kalili kotega hanea kumala Nasaleti kumaꞋa ataleno Petelehemu, Tevitina atenea kumate umaine. ");
INSERT INTO kmu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maliana hagemalenaya munala aipaene mainegeꞋana “TaꞋagi alisae.” huno avaleno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ani kumate umainaꞋageno inamu yana alitene. ");
INSERT INTO kmu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","MaliaꞋa yage nafaꞋneꞋa ne nafaꞋne ateteno mukiꞋa faesia nona hiya higeno pulamakamo nopi ateteno kupi asaga huno aiteno pulamakamoꞋya kave nenaya yopafi faetene. ");
INSERT INTO kmu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ani kegela sipi sipi kava vayala talapinaga maineꞋya sipi sipiyagale kava yagaiꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mainageno anile Anumaya Koti ensole kanomoꞋa egeno Anumayamo tokiya hale yamaꞋamoꞋa aivasa hulino egeꞋya ageteꞋya koli humainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hageno ensole kanomoꞋa mage huno hie “Kolia ohutama mainetama haviho nagaya kanale kaiyekea tamahapaigahe aliꞋna neꞋoe. TusiꞋa muse hisaya kea tamahapaisugeꞋya mukiꞋa veaꞋmoꞋya havigahae. ");
INSERT INTO kmu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Meni kegela Teviti kumatela tamaugafa aligatisia kanoa ago neꞋate. Ani kanomo agia Anumaya KalaisiꞋe, Anumaya KotiꞋma taugafa aligatigahema hutenea kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ani nafaꞋnea kupi aiteteno pulamakamo kave nenea yopafi faeteneanagitama mogetetama ‘Ma yafema hia yana ago falote humaine.’ hutama hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","HigeꞋya mukiꞋa ensole vayaꞋyaga ani kanomote aupaꞋa melitalu huꞋya Anumaya Koti agia alisaga nehuꞋya mage huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anumayatimogae anafinaga mainane huta kagi alisaga nehunageka mopale mainaya veaꞋmogamina kaipa falu humatesana veaꞋmoꞋya amaipa falu huꞋya kanaleꞋya huꞋya maigahae.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensole vayaꞋmoꞋya neꞋamataleꞋya ikapinaga haigeꞋya sipi sipi kava vayaꞋmoꞋya ke mohu mehu huꞋya mage hae “Petelehemu vigetao AnumayamoꞋa tahapaiya yana mogegahune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","AmaiyayeꞋya agegahe vaayana Maliagani Yosefegania nafaꞋneꞋania afumo kave nenea yopafi faeteteꞋana mainaꞋageꞋya mogemainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","MogeteꞋya ensole vayaꞋmoꞋya ani nafaꞋnehema hamapaiya kea mukiꞋa veaꞋnea hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","HamapaigeꞋya mukiꞋa havimainaya veaꞋꞋmoꞋya sipi sipi kava vayaꞋmoꞋyama hamapaiya kehena tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","AmamaꞋyo aiyanagi MaliaꞋa mukiꞋa yama humainea kavala aguꞋafi maleneno agesa havino maine. ");
INSERT INTO kmu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","MainegeꞋya sipi sipi kava vayaꞋmoꞋya eteꞋya kumaꞋamilega neꞋuꞋya agoꞋma hamapaigeꞋya haviteꞋya agemainaya yafena Anumaya Kotitega muse huꞋya agia alisaga hume hume vae. ");
INSERT INTO kmu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yisasina atetegeꞋya nago sota maiteꞋya agoya anoꞋya tagama haya kanale* agia YisasiꞋe huꞋya malenae. Ani agia oꞋatenegeno itaꞋamoꞋa aipa yana ohunegeno ensole kanomoꞋa ani agia malenea agie. ");
INSERT INTO kmu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ItaꞋamoꞋene nafaꞋnene faeꞋana hali hutaꞋageno MoseseꞋma humainea kemo akave maleꞋana Yisasina avaleꞋana Anumaya Kotina amigahe Yelusalemua haimainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Anumaya Koti ke kaemalenaya kefina mage huno humaine “MukiꞋa yage ne nafaꞋneyaga Anumaya Kotina alu aotage nafaꞋneꞋa maisie.” huꞋya kaemalenayane. ");
INSERT INTO kmu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kaemalenayana Anumaya Kotitega muse ya amigahe haimainaꞋe. Anumaya Koti ke kaemalenaya kefina mage huno humaine “Tole nama haefatalapi tole ala namalata amigahae.” huꞋya kaemalenayane. ");
INSERT INTO kmu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Ani kanafina nagola Yelusalemu mainea kanomo agia SimioniꞋe. Fatago kano maineno Anumaya Koti kea akave nemalea kanoa Isaleli veaꞋmogami amaugafa aligatisia kanomo esiafe agava mainegeno Alu Aotage AvamuꞋmoꞋa agaiꞋene maineno mage huno hapaiye “AupaꞋa ofaligananagika Anumaya KotiꞋma amaugafa aligatigahema hutesia kanoa ageteka faligane.” huno hapaimaineane. ");
INSERT INTO kmu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Hapaimaineanagino ala mono nopi avaleno egeno anile mainegeꞋana Yisasina itaꞋafoꞋamogania mono kemo avaya ali hipoꞋya huꞋana avaleꞋana aꞋageno ani kanomoꞋa Yisasina avaleno anukilineno Anumaya Koti agia alisaga humaine. ");
INSERT INTO kmu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Avalelineno SimeoniꞋa mage huno hie “Anumayamoga hagoteka nahapaimainana nafaꞋnea menia ani nafaꞋnemoꞋa tagaila taugafama aligatisia kanoa neꞋagoafe naipamoꞋa kanale hinageꞋna aliꞋya kanokamonia ‘Falio.’ hisanageꞋna falisue. ");
INSERT INTO kmu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","MukiꞋa veaꞋmogami amaulagafina anima taugafa aligatisia kanoa tavelinanagino ani kanomoꞋa kagaikaꞋa Isaleli veaꞋmogamina amakia alisaga huteno Yuta veala omainaya veaꞋmogamina aye vasa humateno kagai kea hamapaigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yisasina itaꞋafoꞋamogania SimeoniꞋa ani nafaꞋnehema hia kehena tusi anakesa havi havi humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","HaꞋageno SimeoniꞋa kanale manu anamino ani nafaꞋnemo itaꞋamoꞋa, Maliafena mage huno hie “Havio Anumaya KotiꞋa mani nafaꞋnea huteneafe mukiꞋa Isaleli kumate veaꞋnea nagoꞋamogamina ali lakatineꞋamataleno nagoꞋamogamina ali hetimategahe hutegeno emaine. Anumaya KotiꞋa nagola alegana ya kana huno hanesiafe hutegeno emaineanagi mukiꞋa veaꞋmoꞋya agaifena ‘KahaoteꞋyakae.’ huꞋya hugahae. Hugahayanagi mukiꞋa veaꞋmoꞋya amaku amakesa haviya kemoꞋa falote humategahie. Maliaga haenagaꞋa kagaila kahaumanamoꞋa tusiya huno halegahie.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ani mono nopina nagola Anumaya Koti aune aala maine. Ani aꞋmo agia AnaꞋe nefa agia FanueliꞋe. Anakai nofi veaꞋnea Asa nofi veaꞋne mainae. Ani aala alekano maine. Yauva a mainea kanafina neveꞋene seveniꞋa (7) kafu mainegeno neveꞋa falitegeno megusa heno maino haimainea kafua eiti foꞋa (84) kafu maine. Ani aꞋmoꞋa mono nona oꞋataleno anifi mukiꞋa kanafina kegeꞋene felugaene Anumaya Koti agia alisaga nehuno kavela mosino Anumaya Kotitega havinegeane. ");
INSERT INTO kmu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ani aꞋmoꞋa anile evaꞋyi huno Yisasina megeteno Anumaya Kotifena tusi muse huteteno mukiꞋa Yelusalemu veaꞋnea amaugafa aligatisia kanohe agava mainaya veala Yisasifena hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yisasina itaꞋafoꞋamogania mono kema hamanepaiya kavala haꞋno huteteꞋana Kalili uꞋana kumaꞋanilega Nasaleti umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","YisasiꞋa ala huno tokiyaꞋage nafaꞋne maineno kanale agu agesaene nafaꞋne mainegeno Anumaya KotiꞋa agaiꞋene maineno kayone hu yana amine. ");
INSERT INTO kmu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isaleli kotega veaꞋnea mukiꞋa kafuꞋahena Anumaya KotiꞋma amaugafa aligatimainea yafe amakesa hao hisia imu negigeꞋana* Yisasina itaꞋafoꞋamogania mukiꞋa kafuleꞋma ani imulega Yelusalemuga umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","VaꞋageno YisasiꞋa tuelufuꞋa (12) kafuꞋa hanegeꞋana mukiꞋa kafule nehaꞋa kava huꞋana Yelusalemu ani imulega haimainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anima imuma kiya kanamoꞋa haꞋno higeꞋya itaꞋafoꞋamogania noꞋamilega aepa heꞋya ugahe hageno ani nafaꞋnea YisasiꞋa oꞋuno afaꞋa Yelusalemu mainegeꞋana maiya yafena ohavinaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“NagoꞋa vayatiene katega neꞋvifi?” huꞋana nago yupa kate uteꞋana kegela agai nofi vayaꞋamogami amuꞋnoꞋamifiꞋene nefugami amuꞋnoꞋamifiꞋene atiyaꞋana oꞋagenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","OꞋagetafa huteꞋana atiyegahe Yelusalemu alehate eteꞋana umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tagufa (3) feluga atiyegetaꞋana oꞋageꞋana ala mono nopi haiꞋana mogaꞋana anile ala humaveli vayaꞋene mopale maineno amakai ke haviteno anonaꞋamia hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","HamavigegeꞋya mukiꞋa ani kema haviya vayaꞋmoꞋya kenonaꞋahena tokiyaꞋage agesama hanea yafena tusiya huꞋya amamaꞋyoa aimainae. ");
INSERT INTO kmu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","AmamaꞋyoa neꞋaigeno itaꞋafoꞋamogania mogeteꞋana anamaꞋyo neꞋaiꞋana itaꞋamoꞋa mage hie “NeꞋnimoga naꞋa higeka ma kavala hu nelaꞋatane? NegafaꞋene taꞋaipa havitaꞋa kanaꞋage hutaꞋa kagaifena katineꞋayoꞋe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Higeno YisasiꞋa anakaifena “NaꞋa higetana nagaifena natineꞋayaꞋe? Nagaya Nenafa nopina aliꞋya alisua yafe nenahaiye huꞋna hua kea nohaviꞋafio?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","HigeꞋana agayama hia kea havilama ohunaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Havilama ohaꞋageno YisasiꞋa anakaiꞋene tavino Nasaleti umaineno anakai ke haviteno akave malegeno itaꞋamoꞋa mukiꞋa humainea kavala alino aguꞋafi malene. ");
INSERT INTO kmu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Malegeno YisasiꞋa ala hutegeno kanale aku agesamoꞋa ala higeno Anumaya KotiꞋene veaꞋmoꞋyaene tusiꞋa muse hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taipiliasi SisaꞋa mukiꞋa Lomu veaꞋnela ala kava maine. FifitiniꞋa (15) kafu ala kava kano maigeno ani kanafina Potiusi PailatiꞋa Yutia kotega Gavana kava kano maigeno HelotiꞋa Kalili Kavana kava kano maigeno aganaꞋamoꞋa FilipiꞋa Ituliaene Talakonaitisiene Gavana kava kano maigeno LaiseniasiꞋa Apilini Gavana kava kano maigeno huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","MainageꞋana ani kanafina AnasiꞋagi KaiyafasiꞋagi ala mono note kava kanolata mainaꞋanagino ani kanafina Sekalaiya nafaꞋnea, YoniꞋa kaꞋme kotega umainegeno Anumaya KotiꞋa nago ke hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","YoniꞋa ani kanafina Yotani ti agegaya kumaꞋyagale uno Anumaya Koti kea hamapaino mage huno hie “Kefo yatamihe tamakuꞋa aiyahae hutama ‘NagoꞋene ohugahune.’ hutama vigeꞋna tina falelamatesugeno Anumaya KotiꞋa kefo yatamia aigetamateno atalelamateno.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nayona Anumaya Koti aune kanomoꞋa, AisaiyaꞋa, mage huno kaemaleneane “KaꞋme kotegati nago kanomoꞋa keha keha huno mage hugahie ‘Anumayamo esia kamaꞋa ali hilato hutama ali fatago hiho. ");
INSERT INTO kmu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Otufina male havatetama osi agoꞋyaene ala agoꞋyaene kafilava higeno tavino afete hanesie. Ugayagi egayagi humainea kamona ali fatago nehutama yafama hanea kaꞋene ali fatago hulama hiho. ");
INSERT INTO kmu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","MukiꞋa veala Anumaya Koti amaku amamena aligatisia yana agegahae.’ huno kaemaleneane.” ");
INSERT INTO kmu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","MukiꞋa veala Yonitega “Ti falelatesie.” huꞋya neꞋageno YoniꞋa amakaife mage huno hamapaiye “Tamakaya osifaꞋveyagamo nafaꞋneyaga mainetama, havigeꞋage vayaꞋmogatama, Anumaya KotiꞋma kaiyeke hulamatesigeno tamaugafa tamagata aisia kanaꞋa aupaꞋa efalote hisia yafena ‘Faletama viho.’ kea ta tamahapaimaine? ");
INSERT INTO kmu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hagotetama kefo yatamihena tamakuꞋa aiyahae humainayafe tamakaitami kanale kava humainesaya yafema navelisayana tina falelamategahue. Tamakaya ‘Apalahamu nafaꞋneyaga mainone.’ hutama ohiho. Nagaya tamahanepauve Anumaya KotiꞋa ma yafatetila Apalahamu nafaꞋneyaga kanale talo hileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tamakaya yosa kana humainayanagi menia Anumaya KotiꞋa tuna alino yosamo aipalela maleneno kanale alagama oꞋayenea yosa atagino atafi hagaꞋyu huno kaegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","HigeꞋya mukiꞋa veaꞋmoꞋya mage huꞋya havigae “Tagaya na kava hisune?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","YoniꞋa mage huno hie “Nago kanomoga tole siotama hanesigekahena siotaꞋa omalesia kanoa nagola afaꞋa amio. KaveꞋama hanesia kanomoꞋa aniꞋa huno kaveꞋa omalesia kanomona afaꞋa amino.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","NagoꞋa vayala amaugafaleti takisi mone neꞋaliya vayaꞋmoꞋya “Ti falelatesie.” huꞋya emaineꞋya agaife mage huꞋya hae “Hulaveli kanomoga tagaya naꞋa hisune?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hageno amakaifena mage hie “Ala kava kanomoꞋma ‘NaꞋa mone aliho.’ hisia kate aliho. Afa moneꞋamienena oꞋaliho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","NagoꞋa ati vayaꞋmoꞋya mage huꞋya havigae “Tagaya naꞋa hisune?” huꞋya hageno amakaifena mage hie “Tamakaya veala hamaetama moneꞋamia oꞋaliho. Havigea hutama alu moneꞋamia ali oꞋamateho. Alisaya moneꞋage muse hutama aliho.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","MukiꞋa veaꞋmoꞋya Anumaya KotiꞋa amaugafama aligatigahe hutesia kanohe “AupaꞋa egahie.” huꞋya agava maineꞋya Yonifena tusiꞋa amaku amakesa haviꞋya “YoniꞋa ani KalaisiꞋe haya kano mainefi?” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hageno YoniꞋa kenonaꞋamia mage huno hie “Nagaya titeti fale nelamatoanagino haenagama nago kano esiana Alu Aotage AvamutetiꞋene ataletiꞋene falelamategahie. Ani kanomoꞋa tusiꞋa tokiyaꞋa hanea kanogino nagaila ago nagasemaineanagiꞋna nagaya afa kano mainoanagiꞋna agai aiyale ayesuana onategahie. ");
INSERT INTO kmu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Agaya sipeti ayopaꞋa alilineno vitimo anoꞋyaꞋa fu huno haletaleno alagaꞋa alino nopi halaꞋya humalegahigi anoꞋyaꞋa ata tegelege nehia atafi kaetalegahie. Ani avinamoꞋma hia kava huno veala fako faka hugahie.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mani kene alu ke alu kene Anumaya Kotina kanale keꞋa hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","HelotiꞋa Gavana kanomoꞋa mukiꞋa kefo ya humainea yafeꞋene aganaꞋamo aala Helotiasina kumai heno vigeno alitenea yafeꞋene YoniꞋa aufi ke ayesali huno humainea keleti HelotiꞋa mukiꞋa kefo ya humainea yana agaseno Yonina nofi hutene. ");
INSERT INTO kmu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Nofila hu oꞋatenegeno YoniꞋa mukiꞋa veala tina fale neꞋamategeno YisasiꞋa anile egeno agaila fale neꞋategeno Anumaya Kotitega ke huno havigegeno ikamoꞋa aihagalo higeno Alu Aotage AvamuꞋmoꞋa nama kana huno agaitega enelavigeno ikapinagati age aino mage huno hie “Kagaya nagaiꞋni nafaꞋnemoga kagaifena aluya huno nahau nayamopafi nenagea neꞋnimoga kagaifena aluya huꞋna musekaꞋa nehue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","YisasiꞋa tetiꞋa (30) kafuꞋa hanegeno aliꞋyamaꞋa aepa hemaine. MukiꞋa veaꞋmoꞋya agaifena “Yosefe nafaꞋne maine.” huꞋya hae. Yosefena nefa agia HeliꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helina nefa agia MatataꞋe. Matatana nefa agia LivaiꞋe. Livaina nefa agia MelekiꞋe. Melekina nefa agia YanaiꞋe. Yanaina nefa agia YosefeꞋa. ");
INSERT INTO kmu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefena nefa agia MatatiasiꞋa. Matatiasina nefa agia AmosiꞋa. Amosina nefa agia NahumiꞋa. Nahumina nefa agia EsaliꞋa. Esalina nefa agia NagaiꞋa. ");
INSERT INTO kmu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaina nefa agia MatiꞋe. Matina nefa agia MatatiasiꞋe. Matatiasina nefa agia SemeniꞋe. Semenina nefa agia YosekiꞋe. Yosekina nefa agia YotaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yotana nefa agia YoananaꞋe. Yoananana nefa agia Lesae. Lesana nefa agia SelupapeliꞋe. Selupapelina nefa agia SealitieloꞋe. Sealitielona nefa agia NeliꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nelina nefa agia MelekiꞋe. Melekina nefa agia AtiꞋa. Atina nefa agia KosamaꞋe. Kosamana nefa agia ElamatamaꞋe. Elamatamana nefa agia EaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eana nefa agia YosuꞋae. YosuꞋana nefa agia EliesaꞋe. Eliesana nefa agia YolimaꞋe. Yolimana nefa agia MatataꞋe. Matatana nefa agia LivaiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livaina nefa agia SimioniꞋe. Simionina nefa agia YutaꞋe. Yutana nefa agia YosefeꞋe. Yosefena nefa agia YonamaꞋe. Yonamana nefa agia EliakimaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimana nefa agia MeleaꞋe. Meleana nefa agia MenaꞋe. Menana nefa agia MatataꞋe. Matatana nefa agia NatanaꞋe. Natanana nefa agia TevitiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tevitina nefa agia YesiꞋe. Yesina nefa agia OpetiꞋe. Opetina nefa agia PoasiꞋe. Poasina nefa agia SalamoniꞋe. Salamonina nefa agia NasoniꞋa. ");
INSERT INTO kmu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonina nefa agia AminatapiꞋe. Aminatapina nefa agia AtamiꞋe Atamina nefa agia AniꞋe. Anina nefa agia HesaloniꞋe. Hesalonina nefa agia PelesiꞋe. Pelesina nefa agia YutaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yutana nefa agia YekopuꞋe. Yekopuna nefa agia AisakiꞋe. Aisakina nefa agia ApalahamuꞋe. Apalahamuna nefa agia TelaꞋe. Telana nefa agia NahoꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahona nefa agia SelukiꞋe. Selukina nefa agia LeuꞋe. Leuna nefa agia PelekeꞋe. Pelekena nefa agia EpeꞋe. Epena nefa agia SelaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selana nefa agia KainaniꞋe. Kainanina nefa agia ApakasatiꞋe. Apakasatina nefa agia SiemiꞋe. Siemina nefa agia NoaꞋe. Noana nefa agia LamekaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekana nefa agia MetuselaꞋe. Metuselana nefa agia EnokiꞋe. Enokina nefa agia YaletiꞋe. Yaletina nefa agia MahalaleliꞋe. Mahalalelina nefa agia KenaniꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenanina nefa agia EnosiꞋe. Enosina nefa agia SetiꞋe. Setina nefa agia AtamuꞋe. Atamuna nefa agia Anumaya KotiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Anumaya Kotina Alu Aotage AvamuꞋamoꞋa Yisasina aguꞋafi hiya higeno YisasiꞋa Yotani tina atalenoꞋma neꞋviana Alu Aotage AvumuꞋmoꞋa veaꞋne omai kaꞋme kotega avaleno motegeno fotiꞋa (40) yupa mainegeno SataniꞋa Yisasina “Havi kava ho.” huno ayevataga humaine. Ayevataga huge huge nehigeno YisasiꞋa kavela ani fotiꞋa (40) kanafina oneno afaꞋa mainegeno tusiꞋa agatemaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","SataniꞋa Yisasife mage hie “Kagaya Anumaya Koti nafaꞋnema mainenukahena ma yafana hapaigeno maya hapaeno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Higeno YisasiꞋa kenonaꞋa mage huno hapaiye “Anumaya Koti avopiti kemoꞋa mage humaineane ‘VayaꞋmoꞋya mayaꞋage nesayana kanaleꞋya huꞋya omaigahae.’ huno humaineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","SataniꞋa Yisasina anale avaleno viaꞋyamo aupaꞋa mukiꞋa ma mopafi hanea ala kumaꞋyagaene afenoꞋyamaꞋaene avelimaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aveliteno SataniꞋa agaifena mage hie “Mani kanale kumaꞋyaga kavama yagaisana tokiya kamigahue. Ani kava yagaisia tokiyaꞋa nagaiꞋni ya haneanagiꞋna nagaya nahaisia kanomona afaꞋa amigahue. ");
INSERT INTO kmu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kagayama nagaifema ‘TusiꞋa ala kano mainane.’ huka naiyafi ape huka ala nagi namitesanageꞋna ani kavama yagaisana tokiya kamigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","YisasiꞋa kenonaꞋa mage huno hie “Anumaya Koti avopi kaemalenaya kemoꞋa mage huno humaineane ‘Anumaya Kotikamona agaiꞋagefe ‘TusiꞋa ala kano maine.’ huka kagesa havi havi huka agia alisaga huka agai aliꞋyamaꞋage alio.’ huno humaineane.” huno hapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","SataniꞋa Yisasina Yelusalemu avaleno ala mono nomo agotofule ateneno mage huno hapaiye “Kagaya Anumaya Koti nafaꞋnema mainenukahena ma nomo agotofuleti mopafi asaga hulavio. ");
INSERT INTO kmu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Anumaya Koti avopiti kemoꞋa mage humaineane ‘Anumaya KotiꞋa ensole vayaꞋahe ‘Kava hiho.’ huno humatesigeꞋya amayateti kavalesaga hulisageka tavisanageno yafatela kaiyamona aye kofa ohugahieꞋ huno humaineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Higeno YisasiꞋa kenonaꞋa mage huno hie “Anumaya Koti avopiti kemoꞋa mage humaineane ‘Anumaya Kotikamo tokiya ayevataga ohuo. Afa yafe ‘Tokiya kava huo.’ huka ohuo.’ huno humaineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Higeno SataniꞋa mukiꞋa alu ya alu ya huno ayevataga hugeteana higeno Yisasina ataleno nagoꞋa kanale ayevataga hisia kanalefe agava maine. ");
INSERT INTO kmu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","YisasiꞋa Alu Aotage AvamuꞋmo tokiyaꞋaene Kalili kotega egeno agai avagemoꞋa ani kotega ute ete higeꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mono noꞋyagaꞋamifi huge amavelige higeꞋya mukiꞋa veaꞋmoꞋya agai agi alisaga humainae. ");
INSERT INTO kmu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","YisasiꞋa Nasaleti maino ala humainea kumate uno Sapati yupa mukiꞋa kanale nehia kava huno mono nopi hai faleno Anumaya Koti ke hapaligahe hetimaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hetimainegeno Anumaya Kotina aune kanoꞋamo Aisaiya kaemalenea autaꞋma aliꞋya amigeno vakayeno hapalino autaꞋmafiti kea mage huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“AnumayamoꞋa Alu Aotage AvamuꞋamona nagaite hutegeno nagaiꞋene emainegeꞋna mukiꞋa yamaꞋa omale veaꞋmogamina agaiꞋa kanale ke hamapaisuafeꞋene kina humainaya veaꞋne kalu hematesuafeꞋene amaulaga asu humainaya veaꞋne aligali humatesuafeꞋene amakaiꞋami amaugafahe tusiꞋa kalagi aiꞋya mai haviya humainaya veaꞋne amaugafa aligatisuafeꞋene Anumaya KotiꞋa tokiyaꞋa namiteno hunategeꞋna emainoe. ");
INSERT INTO kmu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nagaya menia ma kanafina AnumayamoꞋa tamakaife kalagi ailamatesia kanaꞋa ago efalote humaine huꞋna tamahapaisuafe nagaila hunategeꞋna emainoe.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Huteno avona alino ailileteno kava kanoa amiteno mopale mainegeꞋya mukiꞋa mono nopi mainaya veaꞋmoꞋya Yisasi aulagafi aulu heꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mainageno aepa heno mage huno hie “Menia ma ma kaemalenea kea tamakai tamakesale ago egetama havigeno ago efalote huno tamage hie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","HigeꞋya mukiꞋa veaꞋmoꞋya “Tamage hane.” huꞋya avayafitiꞋma hia ke haviteꞋya muse haya kehe amakesa havi havi huꞋya mage hae “Mamona Yosefe nafaꞋnefi?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hageno YisasiꞋa amakaife mage huno hie “Tamage, tamakaya ma ma haya kea nagaife mage hugahae ‘Tota kanomoga kagaika kaugafa hagoteka ali hilato hugeta agamano. Kapaneamu kumate ‘NaꞋa maꞋa kava hie.’ hageta havimainona yana male kagaika kumate hugeta agamano.’ hutama hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tamagelafa huꞋna tamahanepauve nagola Anumaya Koti ke hamanepaiya kanomoꞋa agaiꞋa vayaꞋamogami amuꞋnopi mainegeꞋya veaꞋamoꞋya ‘Ala kanomo kegi havigetao.’ huꞋya ohugahae. ");
INSERT INTO kmu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Nagaya tamage huꞋna tamahanepauve nayona IlaiyaꞋma mainea kanafina tagufa (3) kafugi sikisiꞋa (6) ikanagi huno kola oꞋaigeꞋya ani Isaleli kotega mainaya veaꞋmoꞋya tusiꞋa amakateno kaveꞋamia omalene. Ani kanafina mukiꞋa megusa aꞋneyaga Isaleli kotega mainayanagi Anumaya KotiꞋa agaiꞋa aune kanomona, Ilaiyana, ani megusa aꞋnele hu oꞋatenegi nago Salefati kumate mainea megusa aꞋmote hutegeno umaine. Ani kumala Saitoni kotega hane. ");
INSERT INTO kmu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nayona IlaisaꞋma mainea kanafina mukiꞋa fugitaya amakemainea veala Isaleli kotega mainayanagi ani veaꞋnefitila nagoꞋa veala kanale hu oꞋamatenegi alulega mainea kanoa, NemaniꞋe, Silia mainea kanomona agaiꞋage fugitayama agemainea yana kanale huteneane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","HigeꞋya ani kea haviteꞋya mukiꞋa mono nopi mainaya vayaꞋmoꞋya tusiya huꞋya ke vaiꞋya hamai vaitenae. ");
INSERT INTO kmu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hamai vaiteteꞋya hetiꞋya Yisasina atafa huꞋya kumapiti avayu huꞋya avaleꞋya ani kumaꞋma kimalenaya agoꞋyale haiteꞋya ani agoꞋyafiti aye lakatiꞋya hagaꞋyu hutalegahe humainae. ");
INSERT INTO kmu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hayanagi YisasiꞋa mukiꞋa veaꞋne mainaya amuꞋnopiti afaꞋa amataleno ago alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","YisasiꞋa nagola Kalili hanea kumate Kapaneamu taviteno Sapati yupa Anumaya Koti ke hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","HamapaigeꞋya agai kemoꞋa tokiya yamaꞋa hanea kanomo ke kana hia yafe tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anile nago kanoa Kefo AvamuꞋmoꞋa aguꞋafi mainea kanoa mono nopi maineno “Avovo.” huno alakenake humaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Mage huno hie “Avo Yisasiga Nasaleti nafaꞋnemoga na ya hulategane? Tagaila tahaeka falilategahe emainano? Nagaya kagaila ago kagemainoe kagaya kanale alu aotage kanoa Anumaya KotiꞋa hugatenea kano mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Higeno YisasiꞋa Kefo Avamufe tokiyaꞋage ke huno mage hie “Ke ohuka afaꞋa maiyo. Mani kanoa ataleka agusafinagatila hatilavio.” huno higeno ani Kefo AvamuꞋmoꞋa mukiꞋa veaꞋne mainaya amuꞋnopi ani kanomona mopafi ayelakatino agoꞋya fai neꞋateno agusafitila hatilavino vianagi ani kanomona ali haviya hu oꞋatene. ");
INSERT INTO kmu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","HatilavigeꞋya mukiꞋa veaꞋmoꞋya tusi amamaꞋyo aigeꞋya huge havige huꞋya mage hae “NaꞋane ke hie? Tusi tokiyaꞋaleti tokiyaꞋage ke higeꞋya Kefo AvamuꞋyagamoꞋya agai ke hipoꞋya huꞋya hatilavie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hageno YisasiꞋma hia kavaꞋmo avagemoꞋa mukiꞋa ani kumaꞋyagalega ute ete higeꞋya mukiꞋa veaꞋmoꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","YisasiꞋa hetino mono nona ataleno Saimonina nomaꞋafinaga umainegeno Saimonina aꞋamona itaꞋamo alekanoa tusiꞋa amukonako kali alino mainegeꞋya Yisasife “Melika kanale huto.” huꞋya havigageno avate uno ani kaliꞋahe ke amakigeno ani kaliꞋamoꞋa ataleno vigeno aupaꞋa ani alekanomoꞋa hetino kavela amine. ");
INSERT INTO kmu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ani unena yagemoꞋa tavi falegahe higeꞋya mukiꞋa ani kumate veaꞋmoꞋya vayaꞋamima alu kali alu kali alimainaya veala amavaleꞋya Yisasite ageno mukiꞋa nagoke nagokeꞋmogamina amaugafale aya maleno kaliꞋamia alino kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Alino kanale humatetegeꞋya nagoꞋa veala amakusafiti Kefo AvamuꞋmoꞋya amataleꞋya neꞋuꞋya ala kefiti mage huꞋya hae “Kagaya Anumaya Kotina neꞋamoga mainane.” huꞋya hageno YisasiꞋa ke neꞋamamakigeꞋya agaife Anumaya KotiꞋa “Amaugafa aligatigahie huno hutenea kanoa ma maine.” huꞋya havilinayafe YisasiꞋa “NagoꞋene osi kea ohiho.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Natena tani ko tigeno YisasiꞋa amataleno veaꞋne omai kotega umainegeꞋya mukiꞋa veaꞋmoꞋya agaifena atiyeꞋya ayeꞋya agaite uvaꞋyi huꞋya mage huꞋya hae “Tataleka oꞋuka tagaiꞋene maisane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hayanagi YisasiꞋa mage huno hamapaiye “Nagaila Anumaya KotiꞋa kava yagaisia kanale keꞋa alu kumate kumate ute ete huꞋna hamapaigahue. Anumaya KotiꞋa ani aliꞋyatefe hunategeꞋna emainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","YisasiꞋa mukiꞋa Yutia kumaꞋyagalega ute ete huno mono nopi Anumaya Koti kea hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nago yupa YisasiꞋa Kenesaleti* tikotumo agegayalega hetimainegeꞋya mukiꞋa veaꞋmoꞋya Anumaya Koti ke havigahe meligovegave hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hutageno YisasiꞋa ageana tole tipi kale ti agegayalega avayu huꞋya maleteꞋya noyame kuꞋyama nehaya vayala ani tipi kalea ataleꞋya kukonago sese humainae. ");
INSERT INTO kmu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sese nehageno YisasiꞋa Saimoni tipi kalefi haisaga humaino maineno mage hie “Saimoniga ti agegaya neꞋataleka osiꞋa tipi vuo.” huno hapaiteno ani tipi kalefi haino mopale maineno mukiꞋa alitalu humainaya veaꞋmogamina kea hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hamapaiteno Saimonife mage hie “Tipi kalekaꞋa ti amuꞋnopi ayetufeka kotumona augelifi kukonagokaꞋa ataleka noyame kuꞋya huo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Higeno PitaꞋa Yisasife mage huno hapaiye “Ala kanomogae tagaya kegela noyame kuꞋya huge hugetonana noyamea oꞋalunageno ko timaine. OꞋalinonagi kagayama hana kemo akave maleꞋna kukonagona malegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Ani kukonagona tipi maleana kasagoꞋya noyame hai falegeno kukonagomoꞋa kanaꞋage huno atalaga hisia kava higeꞋya nago tipi kalefi mainaya vaya amakaiꞋene tokaeꞋya aliꞋya neꞋaliya vayafe amayateti avameꞋname huꞋya “Etama taya hiho.” huꞋya hageꞋya emainae. EteꞋya ani tole lipi kalelatapina noyamea aliꞋya male havatageno kanaꞋage huno hapaꞋnesia kava humaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni PitaꞋa ani yana ageteno Yisasina aiyafi aleꞋya ayemaineno mage hie “Anumayamogae nagaya kefo kava nehua kano mainogi nagaila nataleka vuo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","SaimoniꞋene agaiꞋaene mainaya vayaꞋmogamina noyamemoꞋma havateno hiya hia yafena tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","SaimoniꞋene aliꞋya neꞋaliꞋa kanolatana, Sepeti nafaꞋnelatane, YemesiꞋene YoniꞋene aniꞋa huꞋana tusiꞋa anamaꞋyo aiꞋageno YisasiꞋa Saimonife mage hie “Menia kolia ohuo. Noyame kuꞋyama hana avamete Anumaya KotiꞋa agola maisaya hamaimula amamigahe veaꞋne kuꞋya hugane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","HigeꞋya tipi kalea aliꞋya kahaepatega nemaleꞋya mukiꞋa yaꞋyaga neꞋataleꞋya Yisasina akave umainae. ");
INSERT INTO kmu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nagi nago yupa YisasiꞋa nago ala kumate mainegeno nago fugitayamo augafa alino haꞋyagino atalako humainea kanoa maineno Yisasina ageteno agaitega eno mopafi agoꞋya ayemaineno mage huno havige “Anumayamoga kahaisigekahena nagaila ago alika hilato hunatateꞋasine.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Higeno YisasiꞋa ayana haꞋyo huno augafale avate hulineno mage huno hie “Nagaya nahaigeꞋna kaugafamoꞋa menia kanale hino huꞋna nehue.” huno higeno anile aupaꞋa kaliꞋa haꞋno hutene. ");
INSERT INTO kmu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","YisasiꞋa mage huno hapaiye “Ali hilato hugatoa yafena nago kanoa haꞋopaika mono nopi kava kanomote uka mukiꞋa veala kalikaꞋama kanale hugatoa kema havinuꞋyahena mono nopi kava kanomoꞋa kaugafa kamota huno kagetesigeka kaugafama ali hilato hugatoa yafena MoseseꞋma ‘Ma yama Anumaya Kotina amio.’ huno humainea yana Anumaya Kotitega atalo.” huno tokiyaꞋage ke hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hapaiyanagi kalima alino kanale hutea kemoꞋa ute ete higeꞋya kasagoꞋya veaꞋmoꞋya haviteꞋya “Agai ke havita kalitia alino kanale hulatesie.” huꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Emainayanagi YisasiꞋa ani veala neꞋamataleno veaꞋne omai kotega umaineno Anumayamotega ke huno havige havige huno maine. ");
INSERT INTO kmu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nagi nago yupa YisasiꞋa humaveli hamaveli nehigeꞋya mukiꞋa Falasia vayaꞋene kahegi kemo aepaꞋama havilinaya anagaꞋene YelusalemutiꞋene mukiꞋa Kalili kumaꞋyagaletiꞋene Yutia kumaꞋyagaletiꞋene eꞋya avate mopale maineꞋya havimainageno kali veaꞋne kanale humatesia tokiyaꞋa AnumayamoꞋa amigeno Yisasipi hane. ");
INSERT INTO kmu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Anile nagoꞋa vayaꞋmoꞋya nago kanomona aiya aya falimainea kanoa hagifanale faeno mainegeꞋya avaleꞋya “Yisasi avate motegahune.” huꞋya hayanagi kasagoꞋya veaꞋmoꞋya hiya humainaya yafe kana omalegeꞋya amega nogatofule haiteꞋya hanae yosa alisaga humaleneꞋya ani hagifanale faeno mainea kali kanoa mukiꞋa veaꞋmogami amuꞋnopi atalageno Yisasi avate tavimaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tavigeno YisasiꞋa “Ma vayaꞋmoꞋya ago nagaife haviꞋya amakupi maleꞋya amametiti nehae.” agesa haviteno kali kanohe mage huno hie “Nenafuga kahanepauve nagaya ago aigekateꞋna kefo yakaꞋa atale negatoe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","HigeꞋya kahegi kemo havilinaya anagaꞋene Falasia vayaꞋene haviteꞋya amakaiꞋami amakuꞋafiti mage huꞋya hae “Mani kanoa Anumaya Kotife huhaviya hutea kanoa taꞋe? NagoꞋa vayaꞋmoꞋya aigetateꞋya kefo yatia atale otategahayanagi Anumaya KotiꞋa agaiꞋage aigetateno kefo yatia atalelatesia kano maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hageno YisasiꞋa amakupi haya kea ago nehavino mage huno hie “NaꞋa higetama mani kea tamaku tamakesafinaga nehae? ");
INSERT INTO kmu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nagayama huteꞋna hisua kea hana kemo kanaꞋage humaine? ‘AigekateꞋna kefo yakaꞋa atalenegatoe.’ huꞋna hisua kemopi? Kali kanomofe ‘Hetika ka vuo.’ huꞋna hisua kemoꞋe? ");
INSERT INTO kmu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nagayama ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna ma mopale maineꞋna aigetamateꞋna kefo yatamia atalelamatesua tokiyaꞋnia hane hutama havisaya yafe nago kava huꞋna tamaveligahue.” huno kalima neꞋalia kanomofe mage huno hie “Hetika hagifanaka neꞋalika nokalega vuo.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Higeno ani kalima neꞋalia kanomoꞋa aupaꞋa mukiꞋa veaꞋmogami amaulagafi hetino faeno nemaiya hagifanaꞋa neꞋalino Anumaya Koti agia alisaga hume hume nomaꞋalega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na kava higeꞋya mukiꞋa alitalu humainaya veaꞋmoꞋya ageteꞋya tusi amamaꞋyo aigeꞋya Anumaya Koti agia alisaga nehuꞋya mage huꞋya hae “Meni kanalela aluꞋa ya neꞋagone.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Anile neꞋamataleno vilegati nago kanoa agia LivaiꞋe musufa huno vaya amaugafaleti takisi mone aliliteno nehia kanoa opisi nomaꞋale mopale mainegeno YisasiꞋa ani kanoa mogeteno mage huno hie “Kagaya nakave eno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Higeno LivaiꞋa hetino mukiꞋa yamaꞋa neꞋataleno Yisasina akave umaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","LivaiꞋa nomaꞋafina tusiꞋa kave Yisasina kaetegeꞋya mukiꞋa musufa huꞋya amaugafaleti takisi mone neꞋaliya vayaꞋene nagoꞋa vayaꞋene ani nopi YisasiꞋene tokaeꞋya maineꞋya kavela nemainae. ");
INSERT INTO kmu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","NemainageꞋya Falasia anagaꞋene kahegi kemo havilinaya anagaꞋene YisasiꞋenema tokaeꞋya nemaiya anagahe kalugalu ke nehatageꞋya mage huꞋya nehae “NaꞋa higetama tamakaya amaugafaleti takisi monema neꞋaliya vayaꞋene kefo yama nehaya vayaꞋenena kavela maitama nenae?” huꞋya hamavigae. ");
INSERT INTO kmu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hageno YisasiꞋa kenonaꞋamia mage huno hamapaiye “Kalima noꞋaliya veaꞋnea tota kanomotega oꞋugahagi kali veaꞋmoꞋyage tota kanomotega ugahae. ");
INSERT INTO kmu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","‘Fatago veaꞋne mainone.’ huꞋya nehaya veaꞋnehena ke hugahe omenogi nagaya kefo yama nehaya veaꞋnehe ‘TamakuꞋa aiyahae hiho.’ huꞋna hamapaigahe emainoe.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","VayaꞋmoya mage huꞋya nehae “YoniꞋenema tokaeꞋya nemaiya vayaꞋene Falasia vayaꞋene mukiꞋa kanalela kavela mosiꞋya Anumayamotega havige havige huꞋya nemaiyanagi kagaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya mukiꞋa kaveꞋene tiꞋene nege nege nehae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Hageno YisasiꞋa mage huno hie “Nago kanoa aꞋama faiꞋya esakenoꞋa avaya hesia imu kisia yupa vayaꞋamoꞋyaene toꞋkaeꞋya mainesigeꞋya ani vayaꞋyaga kavela mosisafio? AꞋao moꞋosigahayanagiꞋya haenagaꞋa alu kana falote hisigenoꞋa kame vayamoꞋya aꞋma alisia kanoa atafa huꞋya amakaipiti avaletalesageꞋya ani kanale mainesaya vayaꞋamoꞋya hamau huteteꞋya mosigahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","YisasiꞋa nago avame kea mage huno hamapaimaine “Nago kanomoꞋa haegafa kena alino laga huteno atafa kenalela maleno ohatigahie. Maleno hatisiana haegafa kena laga huno ali haviya hugahie. Haegafa kenamoꞋa atafa kenalela nagoke avamete ohune. ");
INSERT INTO kmu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nago kanomoꞋa haegafa nofi alagamo timaꞋa* atafa mememo augafa ti keꞋayopina takino oꞋvaigahie. Takino vaisiana timaꞋamoꞋa kaꞋnuka hesigeno ti kena falo huno takilavinageno ti kena ali haviya hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","NaꞋa hugahiafe haegafa nofi alagamo timaꞋa hefino haegafa meme augafamo ti keꞋayopi takino vaimaleno. ");
INSERT INTO kmu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","KaꞋnuka hemainea nofi alagamo timaꞋa nemainaya veaꞋneꞋmoꞋya haegafa nofi alagamo timaꞋahena ohamaigeꞋya mage huꞋya hae ‘KaꞋnuka hemainea nofi alagamo timaꞋahena nelahaiye.’ huꞋya humainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nago Sapati kanale YisasiꞋene agaiꞋaene tokaeꞋya nemaiya anagaꞋaene nago atili hoya amuꞋnopi neꞋuꞋya anagaꞋamoꞋya nago atilia kaleꞋya atafaiꞋya nae. ");
INSERT INTO kmu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","NenageꞋya nagoꞋa Falasia vayala anile mainaleti ageteꞋya mage huꞋya hae “Sapati kanama katilemalenaya yana naꞋa higetama ani kavala nehae?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hageno YisasiꞋa mage huno hie “Tamakaya TevitiꞋene avagi huꞋya umainaya vayaꞋene amakatemainaya yafena hapalitama ohavinafio? ");
INSERT INTO kmu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Amakategeno TevitiꞋa Anumaya Koti nopi hai faleno ageana ‘Afa vayamoꞋya onesageꞋya mono nopi kava vayaꞋmoꞋya amakaiꞋamige negahae.’ huꞋya katilemalenaya maya Anumaya Koti aulagale malenaya kaihame alino neneno avagi huꞋya emainaya vayala amamine. Tamakaya ani kea hapalitama ohavinafio?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","YisasiꞋa mage huno hie “Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna Sapati kana kava yagaimainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nago Sapati yupa YisasiꞋa mono nopi haino mono ke hamanepaigeno nago kanoa tamaga aya avayu hulavimainea kanoa anile maine. ");
INSERT INTO kmu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","MainegeꞋya nagoꞋa kahegi kema havilinaya anagaꞋene Falasia vayaꞋene YisasiꞋa havi kavaꞋma hisiafene huꞋya ati neꞋayeꞋya “YisasiꞋa Sapati kanale ani kali kanoa alino kanale hutesifi huotesifi?” huꞋya Yisasina amata huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mainageno YisasiꞋa ani vayaꞋmoꞋyama haviya amaku amakesa ago haviteno ayama avayu hulavimainea kanomofe mage huno hapaiye “Hetika vayaꞋmogami amuꞋnoꞋamifi me hetio.” huno higeno hetino anile me hetimaine. ");
INSERT INTO kmu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Me hetimainegeno YisasiꞋa amata huꞋya maiya vayafe mage huno hie “Tamahavinegoe Sapati yupahe mono kemoꞋa naꞋane ke nehie? Sapati yupa veaꞋne ali hilato humatesifi alino haviya humategahie ifi Sapati yupa veaꞋnea amavaleno avina me mategahafi ifi veala tavata hamaegahie?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hamavigeteno mukiꞋa vayaꞋmogami amaulagafi ageno ute ete nehuno kali kanomofe mage huno hapaiye “Kayana aipi huo.” higeno aipi hiana ayamoꞋa ago kanale hute. ");
INSERT INTO kmu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","HutegeꞋya amata huꞋya maiya vayaꞋmoꞋya tusiya huꞋya amaipa kafa heteteꞋya “Yisasina na kava hutesune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nago yupa YisasiꞋa Nefatega nunamu huno havigegahe agoꞋyafi haino ani kegela Anumaya Kotitega ke huno havige havige nehigeno kola ali halemaine. ");
INSERT INTO kmu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kola alino halegeno agaiꞋenema tokaeꞋya nemaiya anagaꞋamofe ke higeꞋya ageno ani anagapiti tuelufuꞋa (12) anaga hapalimateteno “Nagai kema nehavigeꞋna hunelamatoa anagala Aposolo anaga maiho.” huꞋna hapalinelamatoe. ");
INSERT INTO kmu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Anima agaiꞋene tokaeꞋya nemaiya anagaꞋamogami amakia SaimoniꞋe kanomo agia YisasiꞋa PitaꞋe huno malene. Pitana aganaꞋamoꞋa EtaluꞋe, YemesiꞋe YoniꞋe FilipiꞋe PatolomayuꞋe MatiuꞋe, TomasiꞋe, YemesiꞋa Alafiusi nafaꞋne Saimonina hamoꞋamoꞋe nago agia SelotiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","YutasiꞋa Yemesi nafaꞋne, Yutasi IsakaliotiꞋa haenaga ani kanomoꞋa Yisasina agesi huno kame hutesia kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","YisasiꞋa agaiꞋenema tokaeꞋya nemaiya anagaꞋaene tavino otufi hetimainegeꞋya nagoꞋa kasagoꞋya agai kema nehaviya veaꞋnea YutiatiꞋene YelusalemutiꞋene hage limo agegayalega tole kumatalana Taiyaene SaitonitiꞋene kasagoꞋya vea elitalu huꞋya agai kea nehaviꞋya “Kalitia alino kanale hulatesie.” huꞋya emainageno YisasiꞋa Kefo AvamuꞋyaga veaꞋmogami amakupiti amanati neꞋataleno alino kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","TokiyaꞋamoꞋa efalote higeno mukiꞋa veaꞋnea alino kanale humategeꞋya mukiꞋa veaꞋmoꞋya ageteꞋya augafale avate hugahe hae. ");
INSERT INTO kmu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","YisasiꞋa agesaga huno agaiꞋene toꞋkaeꞋya nemaiya anagaꞋamogamina neꞋamakeno mage huno hie “MukiꞋa yatamima omalenaya veaꞋnemogatama Anumaya KotiꞋa tamakaila kava yagai nelamatea yafe musena hiho. ");
INSERT INTO kmu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tamakaila menia tamakaꞋma nelea veaꞋmogatama haenagaꞋa nesageno tamamu hisiafe musena hiho. Menia tamakaya avi neꞋataya veaꞋnemogatama haenagaꞋa kigi hisayafe musena hiho. ");
INSERT INTO kmu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemonima nakave nemalayafe veaꞋnemoꞋya amaipa kafa helamateꞋya ‘AluꞋale maiho.’ hulamateꞋya kamuge vailamateꞋya ‘Otahaiya kagi hane.’ huꞋya hisagetamahena tamakaya ani kanafina afaꞋa muse hutama maiho. ");
INSERT INTO kmu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","AniꞋama hulamatenaya veaꞋneꞋmogamina amakinagomoꞋya nayona Anumaya Koti amaune vayaꞋmogamina aniꞋa huꞋya humatenayane. AniꞋama hisaya kanafina haenagaꞋa ikapinaga umainetama anonaꞋa kasagoꞋya ya alisayafe tamaipa kanale hutama muse hiho. ");
INSERT INTO kmu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","AvoꞋnio mukiꞋa yatamima hanea veaꞋneꞋmogatama tamakaya kaꞋye ho. Tamaipa kanale hisia yana hai ali mainae. ");
INSERT INTO kmu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","AvoꞋnio tamakaya menia mukiꞋa yama nelamamuꞋma nehaya veaꞋmogatama tamakaya kaꞋye ho. HaenagaꞋa tusiꞋa lamakategahie. AvoꞋnio menia kigima hutama nemaiya veaꞋnemogatama kaꞋye ho. HaenagaꞋa tamahau nelagitama avia ategahae. ");
INSERT INTO kmu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","AvoꞋnio veaꞋmoꞋya ‘Ala vaya mainae.’ huꞋya tamaki alisaga nehisaya anagala kaꞋye ho. AniꞋama humainaya veaꞋnemogamina amakinagomoꞋya nayona aniꞋa huꞋya havigeꞋage amaune vayamogami amaki alisaga humainayane.” ");
INSERT INTO kmu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nagai kema havisaya veaꞋmogatama ‘Kame veaꞋnetamimofena tamahau tamayamopafi tamahaino. Amaipa kafama henelamataya veaꞋnemogamina kanale kava humateho.’ ");
INSERT INTO kmu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","‘Anumaya KotiꞋa ali haviya hugatesie.’ huꞋya nehaya veaꞋmogamife ‘Kanale ya amamio.’ huka Anumayamotega ke huka havigo. Hu haviya hunegatesaya veaꞋnemogamifena ‘Amaya huo.’ huka Anumayamotega havigo. ");
INSERT INTO kmu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nago kanomoꞋma kagalamesaleꞋma kaikolisigekahena ‘Nago kaiyaga nagalamesaleꞋene naikolio.’ hisanageno kaikolisie. Nago kanomoꞋma ala yasi siotakama musufama alisigekahena nago siotakaꞋa afaꞋa kaufila ohuo. ");
INSERT INTO kmu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nago kanomoꞋma ‘Nago yakahema namio.’ hisigekahena afaꞋa hagaꞋyu huka amio. Kagai yama alimainesia kanomofena ‘Eteka namio.’ huka tokiya kea hu oꞋato. ");
INSERT INTO kmu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","VeaꞋneyagahe ‘Ma kava hulatesae.’ hutama hisaya kavala ani kavakeꞋya alu veaꞋnea humateho. ");
INSERT INTO kmu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","VeaꞋmoꞋya hamau amayamopafi tamakaifena nehamainagetamahena tamakaya aniꞋa hutama amakaifena tamahaisia yana afa yanagi anonaꞋa oꞋaligahae. Kefo yama nehaya veaꞋnemoꞋya aniꞋa huꞋya amahau amayamopafima amahaiya veafena nehamaiye. ");
INSERT INTO kmu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kanale kavaꞋma hulamataya veaꞋnemogamina aniꞋa hutama kanale ya humatesayana ani yana afa yanagitama anonaꞋa oꞋaligahae. Kefo yama nehaya veaꞋnemoꞋya aniꞋa kavala nehae. ");
INSERT INTO kmu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‘Eteno namigahie.’ hutama hutetama amisaya veala yoka amisayana afa yanagitama anonaꞋa oꞋaligahae. Kefo yama nehaya veaꞋmoꞋya nagoke augafa ya alisayafe kefo yama nehaya veaꞋneꞋamimona yoka neꞋamamiye. ");
INSERT INTO kmu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Anumaya KotiꞋa kefo veaꞋnemoꞋyaene agaifena musema nohaya veaꞋnemogamifeꞋene kayone huneꞋamatea yafe tamakaya ani kava hutama kame veaꞋnetamihena tamahau tamayamopafi nelamahaisigetama kanale kavakeꞋya humateho. ‘AnonaꞋa nago yana oꞋaligahune.’ hutama hamaisia yana amamiho. NaꞋama hisayana haenagaꞋa Anumaya KotiꞋa kasagoꞋya anonaꞋa tamamisigetama ala Anumaya Koti kana hutama nafaꞋneyagaꞋa maigahae. ");
INSERT INTO kmu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","NelamafaꞋma hauma huneꞋamatea kavala aniꞋa hutama tamahauna humateho.” ");
INSERT INTO kmu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nelamafufena ‘NaꞋa maꞋa hana kano mainane.’ hu oꞋateho. AniꞋama ohisagenoꞋa Anumaya KotiꞋa tamakaifena ‘Havi kava haya veaꞋne mainae.’ huno hu otamategahie. Nelamafugamina kaiyekema hu oꞋamatesayana Anumaya KotiꞋa tamakaila kaiyekea hu otamategahie. Haviya hulamatenesia kanomona aigeꞋatetama kefo yamaꞋa ataleteho. AniꞋa hisagenoꞋa Anumaya KotiꞋa kefo yatamia aigetamateno atalelamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nelamafugamima amamisaya kavala Anumaya KotiꞋa aniꞋa huno lamamigahie. Tamakaila kutamifina aye talako huno havatesia kava huno ku ailamategahie. Ma mopaleꞋma nelamafugamima humatesaya kavala Anumaya KotiꞋa tamakaila ani kava hulamategahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nago avame kea mage huno hie “NagoꞋma aulaga asu humainesia kanomoꞋa nago aulaga asu humainesia nefaluna avaleno kanale vaiyesaꞋafi? AꞋao avalenoꞋma vaiyesiana tolemogania komufi asaga hulavigaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nago sugulufi mainesia nafaꞋnemoꞋa huveli kanoꞋamona oꞋagaseneanagino mukiꞋa huvenelia yamaꞋa havilama hulineno huvelimainea kano kana huno maigahie” ");
INSERT INTO kmu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tagaya tagaiti taguꞋafima hanea yana ageteta alu veaꞋnehena “Havi veaꞋne mainae.” huta hisuna yafe YisasiꞋa mage huno hie “NaꞋa higeka negafu aulagafina osiꞋa havi yana hanegeka neꞋagananagi kagaikaꞋa kaulagafina nagola muki yosalapagefa hanegeka ‘Omale.’ huka nehane? ");
INSERT INTO kmu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","NaꞋa higeka negafufena ‘Kaulagafitila havi yana alitalegahue.’ huka hananagi kagaika kaulagafina nagola muki yosalapagefa hanegeka ‘Omalene.’ huka nehane? KaguꞋafinaga hanea yana agelama ohuneka kavayaleti havige huka vagala kano maineka kagaikaꞋa kaulagafitila muki yosalapagefa alitaleteka negafu aulagafina kanale neꞋageka osiꞋa havi yana alitalegane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kanale yosamoꞋa havi yosalaga noꞋayegi havi yosamoꞋa kanale yosalaga noꞋaye. ");
INSERT INTO kmu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","NoꞋayegi veaꞋmoꞋya yosalaga ageteꞋya kanale yosalaga hanesigeꞋyahena ‘Kanale yosa hane.’ huꞋya hugahae. AvetaꞋnafa yosaletila kaimona hataga ohugahae. AvetaꞋnafa nofitetila fulutu alaga avayu huꞋya notagiye. ");
INSERT INTO kmu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Fatago huꞋya mainaya veaꞋmoꞋya kanale amaku amakesa havilineꞋya kanale kavala nehayanagi kefo ya nehaya veaꞋmoꞋya havi amaku amakesa havilineꞋya havi kavakeꞋya nehae. VeaꞋmoꞋya amaku amakesafinaga havateteno aivalilavimainea kea amavayafiti hu falote nehae.” ");
INSERT INTO kmu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nagaifena afa kava nehune hutama ‘Anumayatimogae, Anumayatimogae.’ hutama nehayanagi tamahapauva kea ali hipoꞋya nohae. ");
INSERT INTO kmu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","NagoꞋa veaꞋmoꞋya nagaite neꞋeꞋya nagai ke havige havige huꞋya ali hipoꞋya nehaya veaꞋmogamina maꞋa augafa veaꞋne mainae huꞋna tamaveligahue. ");
INSERT INTO kmu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nago kanomoꞋa noma kigahena ayaꞋaya komu kafiteno yafana anifinaga maleteno u posia ani komufinaga yafa agotofule maleteno aye talako huno nona kimalegeno timoꞋa tusiꞋa li hogino ani note eanagi tokiyaꞋage no kimaleneafe anima hogino ea timoꞋa alino lagape aioꞋatalene. ");
INSERT INTO kmu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ali lagape aioꞋatalenegi nagoꞋa veaꞋmoꞋya nagai ke haviteꞋya ali hipoꞋya nohaya veaꞋmoꞋya maꞋa veaꞋne mainae. Nago kanomoꞋa noma kiana amega komu kafiteno fulu fulu posi ayeno nona kimalenegeno timoꞋa hogino ani note eana aupaꞋa ani nomaꞋa ali lagape aino mopafi atalegeno tusiya huno haviya hulavimaine.” ");
INSERT INTO kmu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","YisasiꞋa mukiꞋa humainea kea veala hamapaigeꞋya havitageno Kapaneamu umaine. ");
INSERT INTO kmu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nago Lomu ati vayate kava humainea kanomoꞋa agaiꞋa aliꞋya kanoꞋa tusiya huno nehaiya kanoꞋagino tusiꞋa kali alino ago faligahe hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Faligahe nehigeno ati vayate kava humainea kanomoꞋa Yisasi avagea haviteno nagoꞋa Yuta vayate ala vayaꞋmoꞋya humateno mage humaine “Nagayama hua kea Yisasina havigeho ‘MusekaꞋa nehugi kanale eka aliꞋya kanoꞋnia ali kanale huto huno hie.’ hutama havigeho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nage higeꞋya neꞋuꞋya Yisasite uvaꞋyi huꞋya tutu huꞋya mage hae “Ani kava kanomoꞋa tagaiti Yuta vayaꞋmogatife aluya huno nehaigeno mono notia kilatene. Ani yafe kanale kano mainegi afaꞋa haꞋmaisanana katesia kava hugane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","YisasiꞋa amakaiꞋene tokaeno viaꞋamo nomaꞋale uvaꞋyi hugahe nehageno Lomu ati vayate kava humainea kanomoꞋa vayaꞋamogamife “Mage hutama hiho.” huno humategeꞋya Yisasite eꞋya mage huꞋya mehae “Mage hie ‘Anumayamoga kasalo kahaesigekahena atalo. Nagaya kanale ohunoa kanomoni noniꞋafi esanana okategahie huꞋna ani yafe kagaitega oꞋunogi afaꞋa menia aliꞋya kanoꞋnimona kaliꞋahena keꞋa hutesanageno kanale hutesie huꞋna nehue. ");
INSERT INTO kmu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nagaya kava kano mainoe. NakaiꞋma kava yagainatenea kanoa anale nagaseno maineanagi nagaya aniꞋa huꞋna nagoꞋa ati vayatela kava huꞋna mainoe. Nago kanomofe ‘Vuoma.’ hugenoꞋa umaine. ‘Enoma.’ hugenoꞋa emaine. AliꞋya kanoꞋnihe ‘NaꞋa huo.’ hugenoꞋa aniꞋa humaine.’ huno hie.” huꞋya hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hapaigeno YisasiꞋa ani kea haviteno agesaguꞋmoꞋa tusiya huteno kasagoꞋya akaveꞋma umainaya veaꞋmogamifena mage huno hie “Tamahanepauve ma kanomoꞋa tusiya huno nagaifena havino agupi maleno ametiti humaine. Ma kanomoꞋma hia ya huꞋya nagaifema haviꞋya amakupi maleꞋya ametiti humainaya veala mukiꞋa Yuta veaꞋne mainaya kumatela oꞋagenoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","HigeꞋya humatenea vayaꞋmoꞋya notega eteꞋya uꞋya mogayana ani aliꞋya kanoa ago kanale huno mainegeꞋya mo gemainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","YisasiꞋa osi kanaꞋa maiteno agaiꞋene tokaeꞋya nemaiya anagaꞋaene mukiꞋa veaꞋnene Neni kumate umainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ani kumala kegiꞋya humalenaya fiate neꞋvageꞋya nagola falimainea kanoa aliꞋya hevaitegahe emainae. Anima falimainea neyamona itaꞋamoꞋa aiya nagoke nafaꞋneꞋagino itaꞋamoꞋa megusa alagiꞋya ani yafe mukiꞋa ani kumate veaꞋmoꞋya ani aꞋmo akave umainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","NeꞋvageno AnumayamoꞋa ani aꞋmona ageteno tusiꞋa hau huteteno mage huno hapaiye “Kagaya kahauma huka avima atana yana haꞋno huka afaꞋa maiyo.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hapaiteno alilinaya hagifanale motafa hulineno hagifanama aliꞋya aya vayala anile hetimainageno YisasiꞋa mage hie “Ma neyamoga hetio huꞋna nagaya kahanepauve.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Higeno anima falimainea neyamoꞋa hetino kaiyekea aepa henoꞋma nehiana YisasiꞋa avaleno itaꞋamona amine. ");
INSERT INTO kmu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","AmigeꞋya mukiꞋa veaꞋnemoꞋya tusiꞋa amamaꞋyo aiteꞋya Anumaya Koti agia alisaga nehuꞋya mage hae “Anumaya Koti ala aune kanoa tagai amuꞋnopina ago emaine. Anumaya KotiꞋa mukiꞋa veaꞋa amaugafa aligatigahe emaine.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","YisasiꞋa aniꞋama hia avagemoꞋa mukiꞋa Yutia kotegaene alu kotegaene ute ete humaine. ");
INSERT INTO kmu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoni kema nehaviya vayaꞋmoꞋya Yisasi avagea Yonina hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Hapaigeno YoniꞋa agaiꞋene tokaeꞋya nemaiya anagapiti tole kanolafe ke higeꞋana agaite aꞋageno Anumayamotega hunateno “Mage hutana havigeꞋo.” huno hanapaiye “Kagaya egahiema humainaya kano emainapi alu kanohe agava maisune?” hutana havigeꞋo. huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","HigeꞋana ani tole kanolatana Yisasitega eꞋana mage huꞋana haꞋe “YoniꞋa tima fale neꞋamatea kanomo hulaꞋategetaꞋa kagaitega neꞋoꞋe. Mage hutana havigeꞋo huno taꞋahapaiye ‘Kagaya egahie huꞋya humainaya kano mainapi alu kanohe agava maisune.’ huno hie.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ani kanafina YisasiꞋa mukiꞋa alu kali alu kali alimainaya veaꞋnene Kefo Avamula amakusafinaga mainea veaꞋnene ali hilato humatene. Amaulaga asu humai veaꞋnea amaulaga agesaya ya humatene. ");
INSERT INTO kmu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Anakaifena kenonaꞋania mage huno hie “Tanakaya utana agaꞋa yaꞋene haviꞋa yaꞋene Yonina hapaiꞋo. Amaulaga asu humainea veaꞋmoꞋya amaulaga neꞋagae. Amaiya haviya humainea veaꞋmogami amaiyamoꞋa kanale humate. Fugitaya amakemainea veala kanale humate. Amakesa tilemainea veala eteꞋya nehaviye. Falimainaya veala hetiꞋya mainae. AfenoꞋami omalenea veala Anumaya Kotina kanale keꞋa nehaviye hutana hapaiꞋo. ");
INSERT INTO kmu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nagai kehema tole amakesa ohavisaya veaꞋmoꞋya kanaleꞋya huꞋya maigahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","YoniꞋma hunategeꞋana emainaꞋa kanolatana utaꞋageno YisasiꞋa anile mainaya veaꞋmogamina Yonife mage huno hamavige “Tamakaya kaꞋme kotega utama na ya agegahe neꞋvae? Nago vemoꞋa hopa kana huno yasimoꞋa ali fagagi mainea kanomona agegahe neꞋvafio? ");
INSERT INTO kmu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ifi na ya agegahe neꞋvae? Kanale kena failinesia kanoa kaꞋme kotega agegahe neꞋvafio? AꞋao kanale kena failinesaya vayala kanale kave nege nege nehaya vayala kaꞋme kotega omainagi ala kanomona kanale nomaꞋafi maigahae. ");
INSERT INTO kmu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na ya agegahe neꞋvae? Anumaya Koti aune kano agegahe neꞋvafio? Tamage tamahapauve mukiꞋa Anumaya Koti aune vayaꞋmogamina amakasemainea kanoa Yoni maine. ");
INSERT INTO kmu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yonife nayona Anumaya Koti autaꞋmafina mage huꞋya kaemalenayane ‘Haviho nagaya Anumaya KotiꞋna aliꞋya kanoꞋnimona hagoteꞋna hutogeno uhagotegateno visana kana valino ali hilato hugategahie.’ huno kaemaleneane. ");
INSERT INTO kmu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tamahapauve YoniꞋa mukiꞋa ma mopale atenaya vayaꞋmogamina ago amakasemaineanagino nagoꞋa afa veaꞋmoꞋya Anumaya Kotife ‘Kava yagailato.’ huꞋya humainaya veala Yonina ago agasemainae. ");
INSERT INTO kmu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","30","KasagoꞋya veala musufaya nehuꞋya vaya amaugafaleti takisi neꞋaliya vayaꞋene Yoni humainea kaiyekea haviteꞋya ‘E, Anumaya KotiꞋa ‘NaꞋa maꞋa huo.’ huno humainea kea fatago ke huno hie.’ hutageno YoniꞋa tina falemateanagi Falasia vayaꞋene kahegi kema havilinaya anagaꞋene ‘Anumaya KotiꞋma ‘NaꞋa maꞋa hiho.’ humainea kehe tagaifena ohune.’ YoniꞋma falematea tina ofalegahune.” huꞋya amakaveꞋno hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Meni kanafima mainaya veaꞋmogatamahena hana augafa veaꞋne mainae huꞋna tamahapaisue? ");
INSERT INTO kmu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ma ma hisua augafa nafaꞋneyagamoꞋya mainaya kava hutama mainae. Ani nafaꞋneyagamoꞋya veaꞋne alitalu huꞋya mainalega maineꞋya alu nafaꞋneyagahena ke huꞋya mage huꞋya hae ‘YaveꞋya aikolunana tamakaya amoa noꞋayae. Tagaya tahau hisuna yagame nehunana tamakaya avia noꞋatae.’ huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","YoniꞋa ti fale neꞋamatea kanomoꞋa kaveꞋene haviliꞋene mosino emainegetama tamakaya ‘Satani Avamula aguꞋafina maine.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hayanagi ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna tina kavela nenogetama nagaifena ‘KaveꞋene tiꞋene neno haꞋno hugeno omai kano maineno musufaya nehaya vayaꞋene amaugafaleti takisi neꞋaliya vayaꞋene kefo yama nehaya vayaꞋene vayaꞋamoꞋya mainae.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hayanagi Anumaya KotiꞋna kanale agu agesama hanea kavala akaveꞋma neꞋvaya veaꞋmoꞋya ‘Fatago kava nehie.’ huꞋya nehae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nagola Falasia kanoa SaimoniꞋe Yisasife “NagaiꞋene kavela meno.” huno higeno YisasiꞋa kave mo negahe Falasia kanomo nopi haino mopale maine. ");
INSERT INTO kmu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Haino mainegeno nagola kumai aala ani kumate nemaiyanagino “YisasiꞋma Falasia kanomo nopiti kave negahe umaine.” huꞋya haya kea haviteno manaꞋage masavena havatemai yafa keꞋayo alilino emaine. Ani keꞋayoꞋma talo hia yafamo agia alapasatae. ");
INSERT INTO kmu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yisasi akavelega aiyafi umaineno Yisasife “Ala kano mainane.” nehuno aiyafi ape huno avi neꞋategeno aunumoꞋa takilavino Yisasi aiyale tavigeno agaiꞋa ayolagefaleti aye haꞋmino alisoso hu neꞋateno aiyale atako nehuno manaꞋage masaveteti faletene. ");
INSERT INTO kmu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fale neꞋategeno kema humainea Falasia kanomoꞋa ani aꞋmoꞋma hia kavala ageteno agesafinaga mage huno havie “Ma kanomoꞋa Anumaya Koti aune kanoma maineleꞋasina aiyaleꞋma alisoso hutea aꞋmofena ago havileꞋasine. Ani aꞋmoꞋa tusiꞋa kefo yamaꞋage nehia a maine.” huno nehavie. ");
INSERT INTO kmu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Agesafinaga ani kea nehavigeno YisasiꞋa agaife mage huno hie “Saimonigae nago kea kahapaisue.” huno higeno “Hulavenelina kanomogae nahapaigeꞋna havino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Higeno YisasiꞋa mage huno hie “Nagola moneꞋa hanea kanomote tole kanolatamogania uꞋana nagoꞋmoꞋa ‘Vani hataleti kina (K100) namigeꞋna alino.’ higeno nagoꞋmoꞋa teni kina (K10) namigeꞋna alino. AlitetaꞋa anonaꞋa haenaga megamiꞋano huꞋana haꞋageno anamigeꞋana aliꞋana umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","UteꞋana haenagaꞋa anonaꞋama amisaꞋa monea kosa ohegeꞋana oꞋamiꞋageno ‘Kanalelagi onamitana ataleꞋo.’ huno humaine. Ani kema humainea yafena ani tole kanolatalapitila hana kanomo monema aminea kanohena tusia musena huno hau ayamopafina haugahie?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","SaimoniꞋa mage hie “Nagesa havuana ala monema alimainea kanohe atalo hunoꞋma hutea kanomoꞋa tusiꞋa muse huno hau ayamopafi haugahie.” huno higeno YisasiꞋa mage huno hie “Tamage hane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ani kea huteno maiyahae huno ani aꞋmona agemaineno Saimonina mage huno hapaiye “Kagaya mani aꞋmona ago. Nagaya kagai nopi ogeka naiya sese huonatanageno ma aꞋmoꞋa agaiꞋa aunuleti naiya sese hunateteno agaiꞋa ayolagefaleti ali hau hunenate. ");
INSERT INTO kmu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kagai nopi ogeka nagaila naugafalela alisoso hu onatenanagi ma aꞋmoꞋa naiyalela eno aluya huno alisoso hunenate. ");
INSERT INTO kmu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kagaya afa masavetetila nanupina fale onatenanagi mani aꞋmoꞋa manaꞋage masaveteti naiyalela falenatene. ");
INSERT INTO kmu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ani yafe kahanepauve mani aꞋmoꞋa kefo yamaꞋamoꞋa kasago humainegeno Anumaya KotiꞋa ago aigeꞋateno ataletea yafe tusiya huno hau ayamopafi haumaineanagino osi kefo yamaꞋama hanea kanomona Anumaya KotiꞋa ani kefo yamaꞋa aigeꞋateno ataletesiana osiꞋa hau ayamopafina haugahie.” ");
INSERT INTO kmu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","YisasiꞋa mage huno ani afena hie “Nagaya kefo yakaꞋa ago aigekateꞋna atalegatoe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","50","AgaiꞋaene tokaeꞋya mopale mainaya veaꞋmoya sumi sumi kefiti mage huꞋya hae “Mani kanoa hanaꞋa kano maineno ‘Kefo yakaꞋa aigekateꞋna atalegatoe.’ huno nehie.” huꞋya hae. “Nagaifena havika kagupi maleꞋka kametiti hanafe kagu kamena ago aligatigatogi kamena male falu huka vuo.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","YisasiꞋa osi kanaꞋa maiteno ala kumaꞋyagaleꞋene osi kumaꞋyagaleꞋene vaiyatete huno Anumaya Koti kava yagaimatesia kanale mono kea hamapaimaine. AgaiꞋa tuelufuꞋa (12) anagaꞋaene nagoꞋa aꞋneyagaene YisasiꞋa amakupitiꞋma Kefo AvamuꞋma anatitaleno kaliꞋamima alino kanale humatenea aꞋneyagaene agaiꞋaene vaiyatete humainae. Nago aꞋmo agia Magatala MaliaꞋe. YisasiꞋa hagoteno seveniꞋa (7) Kefo AvamuꞋyaga aguꞋafiti anatitalenea ale. ");
INSERT INTO kmu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nago aꞋmo agia YoanaꞋe Heloti nopi kava kanomo alagi. Ani kava kanomo agia SusaꞋe. Nago aꞋmo agia SusanaꞋe nagoꞋa aꞋneyagaene YisasiꞋene vaiyatete nehuꞋya ani aꞋneyagamoꞋya amakaiꞋami moneꞋamifiti YisasiꞋene anagaꞋamogamiꞋene amaya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","MukiꞋa alu kumateti kumateti veala Yisasite melitalu hageno YisasiꞋa nago avame kea hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mage huno hie “Nago kanomoꞋa avina faigahe alino vie. Avina alino aihelafino nefaigeno nagoꞋa avinamoꞋa kapi tavino hanegeno veaꞋmoꞋya ani avinale amaiya ayeꞋya ute ete hageno namayagamoꞋya nageno haꞋno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","NagoꞋa avinamoꞋa yafa mopafi taviteno hageana tina omalea mopafinagino eteno fayoteno asagalimaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","NagoꞋa avinayagamoꞋa avetaꞋnafa ino hanea amuꞋnopi tavino hageteno avetaꞋnafa hanea inoꞋmoꞋa ayetegeno haviya humaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","NagoꞋa avinamoꞋa kanale mopafi tavino hageteno alagaꞋama ayeana nagoke yosalela kasagoꞋya alaga vani hataletiꞋa (100) ayeno vasaimai vasaimai humaine.” huno hie. Ani kea huteno ala ke huno mage hie “Mani kea tamakesama hanesigetamahena havilama hutama haviho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","AgaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya ani avame kemo aepaꞋahe havigae. ");
INSERT INTO kmu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Havigageno YisasiꞋa mage hie “Tamakaya Anumaya KotiꞋa kava yagailamateneafe kemoꞋa falaki mainea kea Anumaya KotiꞋa tamaya higetama ago havilinagi mukiꞋa veaꞋmoꞋya avame kema hamapaisugeꞋya amakesa havigahagi haviteꞋya havilama huꞋya ohavigahae. VeaꞋmoꞋya neꞋagayanagi agelama huꞋya oꞋagegahae. ");
INSERT INTO kmu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mani avame kemona aepaꞋa hu falote huꞋna tamahapaisue. Mani avinamoꞋa Anumaya Koti ke kana humaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","KateꞋma tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya Anumaya Koti kea havitageno SataniꞋa mage hie ‘Amakupi aliꞋya omalesageno Anumaya KotiꞋa amaku amamena ali okatisie.’ huno amakupitila ani kea alitalene. ");
INSERT INTO kmu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yafa mopafima tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviꞋya muse huꞋya atafa hayanagi hafuꞋya mopafi otavia yamoꞋa alige atalege veaꞋne maineꞋya osi kanaꞋa osiꞋa haviꞋya amakupi maletageno havi kanama amakaiteꞋma falote nehiana aupaꞋa Anumaya Koti kea neꞋatalae. ");
INSERT INTO kmu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","AvetaꞋnafa ino hanea amuꞋnopi tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya Anumaya Koti kea haviteꞋya ma mopafi mukiꞋa yaꞋyagaꞋamihe amakesa haviꞋya moneꞋamiene yokaloꞋamienefe kalagi aiteꞋya ani yaꞋyagaꞋamimo Anumaya Koti kea alino aiso humalegeꞋya atalageno alagaꞋamoꞋa aye helafino lama nohie. ");
INSERT INTO kmu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kanale mopafima tavimainea avinamoꞋa maꞋa humaine nagoꞋa veaꞋmoꞋya tokiyaꞋage amaku amakesa hanegeya Anumaya Koti kea haviteꞋya aliꞋya amakupi maleꞋya atafa hu talako huꞋya mainaya veaꞋmoꞋya ani alagaꞋa mukiꞋa aye henelafie.” ");
INSERT INTO kmu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Anumaya Koti ke nehaviyafe YisasiꞋa mage huno hamapaiye “NagoꞋa veaꞋmoꞋya lamua hanagaliꞋya susufaneleti aiso hu nemalafi ifi sipa kapinaga hanagaliꞋya aiso hu nemalae? AꞋao lamua hanagaliteꞋya esaya veaꞋmoꞋya ani lamule agesayafe sipale nemalae. ");
INSERT INTO kmu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ani yafe haenagaꞋa mukiꞋa falakimainesia yamoꞋa efalote hugahie. MukiꞋa kesi kava nehaya yamoꞋa efalote hinageꞋya veaꞋmoꞋya agegahae. ");
INSERT INTO kmu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ani yafe Anumaya Koti ke havisaya yafena tamakesa havitama havilama hutama haviho. Havilama huno havilinesia kanomona Anumaya KotiꞋa nagoꞋene havilisia yana amigahianagi nagoꞋamoꞋya ‘Ago havilinoe.’ huno hisia kanomona havilinesiamaꞋa hanafaletalegahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yisasina itaꞋamoꞋene aganaꞋamoꞋyaene agegahe ayanagi kasagoꞋya veaꞋmoꞋya hiya huꞋya maigeno YisasiꞋma mainea avatela omenae. ");
INSERT INTO kmu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Omenagi nago kanomoꞋa Yisasife mage hie “ItakamoꞋene kaganakamoꞋyaene kagai kagegahe emaineꞋya kumatega hetiꞋya mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Higeno kenonaꞋa mage huno hie “MukiꞋama Anumaya Koti kema haviꞋya akave nemalaya veala itaꞋnimoꞋya naganaꞋnimoꞋya mainae.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nago yupa YisasiꞋenema tokaeꞋya nemaiya anagaꞋene tipi kalefi haisaga humaiꞋya neꞋuꞋya YisasiꞋa mage huno hamapaiye “Tikotumona atu faliga vigetao.” huno higeꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yaufa neꞋvageno YisasiꞋa aukalokalo higeno faemainegeno tusiꞋa yasimoꞋa tina mevaleno tipi kalefi atalegeno ani lipi kalefina havatesia kava higeꞋya mukiꞋamoꞋya haviya hisaya kava humainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","HuteꞋya YisasiꞋa faemainegeꞋya mogafa huꞋya mage hae “Kava kanomogae, kava kanomogae tagaya ti nakaita falisuna kava nehunageka notagane.” huꞋya hageno hetino ani limofeꞋene yasimofeꞋene tokiyaꞋage ke huno “Taga huo.” huno higeno yasimoꞋene timoꞋene taga huꞋana alava humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Alava hutegeno YisasiꞋa agaiꞋaene tokaeꞋya nemaiya anagafe mage huno hamavige “Nagaifena havitama tamakupi maletama tamametitima haya yana hanate atalae?” huno higeꞋya koli huꞋya tusiꞋa amamaꞋyo neꞋaiꞋya huge havige huꞋya mage hae “Mani kanoa taꞋe? TimoꞋene yasimoꞋene keꞋa haviteꞋya akave malae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kaliliti ala tikotuna takaeꞋya ame kaiyaga agegayamona Kelasasa* veaꞋne mainalega uvaꞋyi hae. ");
INSERT INTO kmu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","YisasiꞋa tipi kalea ataleno ti agegayalega neꞋuno ageana nagola ala kumate kanoa Kefo AvamuꞋyagamoꞋya aguꞋafi mainaya kanoa Yisasite emaine. Ani kanoa ayaꞋaya kanafi kenaꞋa fai oꞋalino nopina nomaiyane. MatimatipikeꞋya nemaiya kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ani kanomoꞋa Yisasina ageteno mopafi agoꞋya ayemaineno ala kefiti mage hie “Yisasiga tagasenoꞋma anale mainea Anumaya Kotina nafaꞋneꞋamoga naꞋa hunategahe neꞋane? MusekaꞋa nehugi nagata aisia kavala hu onato.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Higeno YisasiꞋa Kefo Avamufe mage huno hie “Agusafitila hatilavio.” huno higeno Kefo AvamuꞋmoꞋya mukiꞋa kanafina ani kanomona atafa nehigeꞋya kava neꞋyagaiya vayaꞋmoꞋya aiya ayapi seni nofiteti kisalu kitayanagi ani nofila aikaꞋnokaꞋnu huneꞋataleana Kefo AvamuꞋmoꞋya afai kotega anatigeno faleno neꞋviane. ");
INSERT INTO kmu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","YisasiꞋa ani kanohe mage hie “Kagai kagia tagae?” huno higeno mage hie “Nagai nagia kasagoꞋyamoꞋnae.” huno hie. NaꞋafene kasagoꞋya Kefo AvamuꞋmoꞋya aguꞋafima hai falemainayafe “Nagia kasagoꞋyamoꞋnae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ani Kefo AvamuꞋmoꞋya Yisasifena mage hae “Hanikimainea kumapina tagaila hulategeta oꞋvamano.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","NehageꞋya kasagoꞋya afuyagamoꞋya agoꞋyafi maineꞋya kave nenageno ani Kefo AvamuꞋmoꞋya Yisasifena mage huꞋya hae “Amuga afuyagamo amakuꞋafina hulategeta vamano.” huꞋya havigageno YisasiꞋa “AniꞋa hiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","HigeꞋya ani Kefo AvamuꞋmoꞋya ani kanomo aguꞋafitila hatilaviꞋya afuyagamogami amakupi hai nefalayana ani afuyagamoꞋya amaiyayeꞋya nagola aulufi kapi taviteꞋya tipi asaga hulaviꞋya ti nakaiꞋya fali haꞋno humainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fali haꞋno hageꞋya ani afuyagale kava vayaꞋmoꞋya ani afuyaga tima nakaiꞋya fali haꞋnoma haya yana ageteꞋya faleꞋya ala kumate mainaya veaꞋmogamifeꞋene hoyafinaga mainaya veaꞋmogamifeꞋene “NaꞋa maꞋa higeta neꞋone.” huꞋya hamapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","HageꞋya ani veaꞋmoꞋya humainea yama agegahe Yisasite eꞋya Kefo AvamuꞋmoꞋma agusafiti ataleno umainea kanomona agesa akalo higeno kenaꞋa failino Yisasi aiyafi mopale mainegeꞋya megeteꞋya koli humainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","YisasiꞋma humainea yama agemainaya veaꞋmoꞋya “NaꞋa maꞋa huno Kefo AvamuꞋmogamina agusafi mainea kanomona alino kanale hutene.” huꞋya hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","HamapaigeꞋya mukiꞋa Katalaga kumate veaꞋmoꞋya Yisasifena tusiꞋa koli huteꞋya “Tagaila tataleka vuo.” huꞋya hageno YisasiꞋa amataleno emainelega ugahe tipi kalefi haisaga humaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Haisaga hunemaigeno Kefo AvamuꞋmoꞋma agusafiti hatilavino umainea kanomoꞋa Yisasifena “KagaiꞋene ugahe nehue.” huno higeno YisasiꞋa “AꞋao kagaya eteka nokalega uka mukiꞋa Anumaya KotiꞋma hugatenea yafena veaꞋneyaga mo hamapaiyo.” huno higeno ani kanomoꞋa viaꞋyamo mukiꞋa ala kumaꞋale veaꞋmogamina YisasiꞋma hutea yafena hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","YisasiꞋa eteno egeꞋya mukiꞋa veaꞋmoꞋya agava maineꞋya tusiꞋa muse huꞋya falu fala hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Falu fala huneꞋatageno nago kanoa YailasiꞋe nehaya kanoa emaine. Ani kanoa soka kano maineanagino Yisasi aiyafi mepe humaineno tutu nehuno Yisasina mage huno havige “NoniꞋalega egetaꞋa vaꞋano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ani kanomoꞋa aiya nagoke munaꞋa maine. Ani munala kafuꞋa tuelufuꞋa (12) kafuꞋa hanea munala faligahe ayaya neꞋaigeno “NoniꞋalega eno.” huno tutu higeno YisasiꞋa anilega vigeꞋya veaꞋmoꞋya yageꞋyage huꞋya aulega akavelega huꞋya akave umainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vageno ani veaꞋnefiti nago aꞋmoꞋa tuelufuꞋa (12) kafu aigu nopinaga mukiꞋa kanale nemaiya aala nagoꞋa vayaꞋmoꞋya aliꞋya kanale hu oꞋataleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ani aꞋmoꞋa Yisasina akavelagati eno kenaꞋamo atupale avate aligeno aupaꞋa kolamaꞋamoꞋa taꞋnemaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","TaꞋnegeno YisasiꞋa mage huno humaine “Ta kenaꞋnilela mevate humaine?” huno higeꞋya mukiꞋamoꞋya “Tagaya naꞋa ohunone.” huꞋya hageno PitaꞋa mage hie “Kava kanomoga mukiꞋa veaꞋmoya yageꞋyage huꞋya kaulegati kakavelagati nehagi naꞋa higeka mani kea hamavinegane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","YisasiꞋa mage huno hie “Tamage huꞋna nehue nago kanomoꞋa kenaꞋnile avate higeꞋna nagaya nagesa nehavugeno navate aligeno nagoꞋa tokiyaꞋnimoꞋa ago nataleno umaine.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hapaigeno ani aꞋmoꞋa “Falakigahe huanagi ago nagane.” huno atili huteno Yisasi aiyafi mepe humaineno mukiꞋa veamogami amaulagafi “NaꞋa maꞋa huꞋna kali alimainoafe avate alugeno kaliꞋniꞋa aupaꞋa kanale hunate.” huno hapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hapaigeno YisasiꞋa mage huno hapaiye “Ma aꞋmoga nagaife kagupi maleka kametiti hanafe kanale negahaiye kagaya kaipamoꞋa yasi nehinageka vuo.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ani kea nehigeno nago kanomoꞋa soka kanomo notegati anile evaꞋyi huno Yailasife mage huno hie “MunakamoꞋa ago falimainegi ataleka kava kanomona kasalo haegi nagoꞋene havioko.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","YisasiꞋa ani kea haviteno Yailasife mage huno hie “Kolia ohuka afaꞋa nagaife kagupi maleka kametiti hisanageno munakaꞋa falimainefitila hetigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Soka kanomo note uvaꞋyi huno YisasiꞋa mukiꞋa veaꞋnehe “Omeho.” huno PitaꞋene YoniꞋene YemesiꞋene ani munaꞋmo itaꞋafoꞋamoꞋene amavaleno ani nopi haimainae. ");
INSERT INTO kmu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","MukiꞋa veaꞋmoꞋya ani munaꞋma falimainea yafena tusiꞋa avi neꞋatageno YisasiꞋa mage huno hie “Avia oꞋateho mani munala falilavata ohunegi afaꞋa faeno maine.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ani munala faligeꞋyama agemainaya yafena ani veaꞋmoꞋya Yisasina kigiꞋa hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kigi hutayanagi YisasiꞋa ani munaꞋmo ayate atafa nehuno mage hie “Ma munaꞋmoga hetio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nehigeno agu nafaꞋnea eteno egeno aupaꞋa hetie. Hetigeno YisasiꞋa mage hie “NagoꞋa nesia kavela amiho.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ItaꞋafoꞋamogania ani yana ageteꞋana tusiꞋa anamaꞋyo aimaiꞋanagi YisasiꞋa mage hie “Nago kanomona ma ma hua yafena hamaopaiꞋo.” huno kaheginatene. ");
INSERT INTO kmu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","YisasiꞋa tuelufuꞋa (12) anagaꞋamofe ke higeꞋya ageno mukiꞋa Kefo AvamuꞋyagama veaꞋmogami amakusafiti amanatitalesaya tokiyaene kalima aliꞋya kanale humatesaya tokiyaene amamine. ");
INSERT INTO kmu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Amamiteno Anumaya KotiꞋma kava yagaisia yafe hamapaigahe kalima hamaemainea yana aliꞋya kanale humatesayafe humatene. ");
INSERT INTO kmu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","HuneꞋamateno mage huno hamapaiye “Kama visayafena ayopatamiene kutamiene mayatamiene monetamiene alitama oꞋviho. Tole kena oꞋaliho. Alu nopi alu nopi faelitetama ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nago nopima hai falenutamahena ani nopi faetama maitama amataletama alu kumatela viho. Faelitetama ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","NagoꞋa kumate veaꞋmoꞋya falu falama huotamatesagetamahena ani kumala neꞋataletama ‘Havi kava hae.’ hutama tamaiyafima hanesia kugukege yana aifopo huneꞋataletama viho.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","HamapaitegeꞋya alu kumate kumate neꞋuꞋya mukiꞋa kumatela Anumaya Kotina kanale keꞋa hamanepaiꞋya kaliꞋamia aliꞋya kanale huneꞋamateꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ani kanafina HelotiꞋa sauve kanogino YisasiꞋa mukiꞋama humainea kavaꞋmo avagema haviana nagoꞋa veaꞋmoꞋya ani yana ageteꞋya “YoniꞋa falimainefiti ago hetimaine.” huꞋya hageꞋya nagoꞋa veaꞋmoꞋya “IlaiyaꞋa eteno falote humaine.” huꞋya hageꞋya nagoꞋa veaꞋmoꞋya “Nayoma Anumaya Kotina aune kanoꞋa falimainefiti hetimaine.” huꞋya haya yafe HelotiꞋa ani kea haviteno agu agesamoꞋa anilega vigeno “Hana veaꞋmogami kemo tamagea nehafi?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Huteno HelotiꞋa mage hie “Nagaya aliꞋya vayaꞋniꞋa humatogeꞋya Yonina ageꞋya ago fakalitalageno falimaine. NaꞋa maꞋa kava nehie huꞋya avagema humainaya kanoa taꞋe?” huno nehuno Yisasima agesia kafena ati ayemaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposolo anagala eteꞋya “NaꞋa maꞋa kava huteta neꞋone.” huꞋya Yisasina me hapaigeno YisasiꞋa haviteno ani anagaꞋa amavaleno Petesaita kumatega ugahe katega umainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","NeꞋvageꞋya mukiꞋa veaꞋmoꞋya haviteꞋya akave agaitega ageno YisasiꞋa falu fala humateteno Anumaya KotiꞋma kava yagaisia yafe hamapaiteno kalima neꞋaliya veala alino kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Une kigeꞋya tuelufuꞋa (12) anagaꞋamoꞋya Yisasite mage me hae “Tagaya vaya omai kaiyaga mainonafe mukiꞋa veaꞋmogamina humatesanageꞋya hanesia kumateꞋene noma hanesilegaene ute ete huꞋya faesaya nofeꞋene nesaya yafeꞋene atiyesae.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hageno YisasiꞋa mage huno hamapaiye “Tamakaitami kavela amamiho.” huno hamapaigeꞋya mage hae “Utama mukiꞋa mainaya veaꞋmogami kavela miya hiho huka nehano? Tagaipina osi kave kanoꞋa hane faefuꞋa (5) mayaene tole noyame kanoꞋagi huno hane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Anifima mainaya vayala faefu tauseniꞋa (5,000) vayaꞋyaga mainayanagi YisasiꞋa agaiꞋenema tokaeꞋya nemaiya anagaꞋamogamife mage huno hamapaiye “HamapaigeꞋya fifitiꞋa (50) veaꞋne ‘Alitalu hutama maite maite hutama mopale maiho.’ hutama hamapaiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","HamapaigeꞋya aniꞋa hute hute huꞋya mopale mainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","YisasiꞋa faefuꞋa (5) maya neꞋalino tole noyamene neꞋalino huteno ikapinaga agesaga huno Anumaya Kotitega huno muse huteno ani mayaene noyamene koliteno agaiꞋenema tokaeꞋya nemaiya anagaꞋa amamigeꞋya mukiꞋa veala amamite amamite humainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Amamite amamite hageꞋya mukiꞋa nageno amamu higeꞋya atalaya atupatapaꞋa aliꞋya tuelufuꞋa (12) kula aihavatemainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nago yupa YisasiꞋa agaiꞋage Anumaya Kotitega havinegegeꞋya agaiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya avate mainageno mage huno hamavige “VeaꞋmoꞋya nagaifena taꞋe huꞋya nehae?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","HamavigegeꞋya kenonaꞋa mage huꞋya hae “NagoꞋa veaꞋmoꞋya kagaifena ‘Ti faleneꞋamatea Yoni maine.’ huꞋya hageꞋya nagoꞋa veaꞋmoꞋya kagaifena ‘Ilaiya maine.’ huꞋya hageꞋya nagoꞋa veaꞋmoꞋya ‘Anumaya Koti aune kanoa nayo ago falimainea kano falimainefiti eteno hetimaine.’ huꞋya nehae.” huꞋya hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hapaigeno YisasiꞋa amakaifena mage huno hamavige “Tamakaya nagaifena taꞋe hutama nehae?” huno hamavigegeno PitaꞋa mage huno hie “Kagaya Kalaisigae Anumaya KotiꞋa taugafa aligatigahe hugatenea kano mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Higeno YisasiꞋa tokiyaꞋage ke huno “Mani kea nagoꞋa veala hamaopaiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","YisasiꞋa mage huno hamapaiye “Soka vayaꞋene mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene nagaila ikapinagati emainoa kanoa vayaꞋmo natenea kanomonihena ‘KahaoteꞋyakae.’ huꞋya hunatesageno tusiꞋa nagata aisigeꞋya nahaesageꞋna faligahue. FalisugeꞋya komufi hevainatesageꞋna tole yupa maiꞋna tagufa kanale falimainesufiti hetigahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Alitalu humaiya veaꞋnene agaiꞋaene tokaeꞋya nemaiya anagaꞋenefe mage huno hie “NagoꞋa veaꞋmoꞋya nagai nakaveꞋma visaya amakesa havinuꞋyahena amaugafama aliꞋya hai yana amakaveꞋno huteteꞋya nakaiꞋma nagata aisigeꞋna falisua kava hisaya amakesa haviteꞋya yafaga yosa kanaꞋaene kanaꞋaene kofiꞋya nakave aliꞋya visae. ");
INSERT INTO kmu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nagola veaꞋmoꞋya maiyaꞋamima atafa huꞋya ali talakoma hulisayana maiyaꞋamimoꞋa falino afaya hapaegahigi nagoꞋa veaꞋmoꞋyama nagaifema hamainageꞋya maiyaꞋamima atalesaya veaꞋmoꞋya maiyaꞋamia aligatisugeꞋya agola aliꞋya maigahie. ");
INSERT INTO kmu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nagola veaꞋmoꞋya mukiꞋa ma mopale mone fenoꞋyaga aliteꞋya maineꞋya falisagenoꞋa agola maige maige hisaya haimula ago atalenayanagiꞋya alimainaya mone fenoꞋamimoꞋa hanaꞋa huno amaya hugahie? AꞋao amaya ohugahie. ");
INSERT INTO kmu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","NagoꞋa veaꞋmoꞋya keꞋniꞋaene nagaiꞋenefema amakaye huꞋya ‘AoteꞋyamaꞋae.’ huꞋya hunatesayana nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna esua kanafina tokiya hale yaniꞋaene Nenafana tokiya hale yamaꞋaene alu aotage ensole anagaꞋamoꞋyaenema eteꞋna esuana aniꞋa huꞋna ani veaꞋnehena nagaye huꞋna ‘TamahaoteꞋyatamie.’ humategahue. ");
INSERT INTO kmu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tamagelafa huꞋna tamahanepauve nagoꞋa veala maleꞋma hetimainaya veaꞋmoꞋya aupaꞋa ofaligahayanagiꞋya hagoteꞋya Anumaya KotiꞋma kava yagaisia kanaꞋamoꞋma efalote hisia yana agegahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","YisasiꞋa mani kea huteno seveniꞋa (7) kana maiteno Pitana Yonina Yemesigamina amavaleno Anumayamotega ke huno havigegahe agoꞋyafi haimainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Haimainageno YisasiꞋa Anumayamotega ke huno havinegegeno augosamoꞋa alino alu augosa kaligeno kenaꞋamoꞋa efeꞋage huno alave alave humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Tole kanolatana nayo falimainaꞋa kanolatana MoseseꞋene IlaiyaꞋene tokiya hale yaꞋene maineꞋana Anumaya KotiꞋa Yisasifema “NaꞋa maꞋa huka Yelusalemu faligane.” huno hutenea kehe YisasiꞋene kea kea humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ani kaiyekea nehageꞋya PitaꞋene anagaꞋamoꞋyaene amaukalokalo higeꞋya faemainafiti aupaꞋa hetiꞋya agayana YisasiꞋa tokiya hale yamaꞋaene avate tokaeꞋana hetimaiꞋa kanolataꞋene amakemainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","NeꞋamakageꞋana ani lole kanolatana Yisasina ataleꞋana ugahe nehaꞋageno PitaꞋa Yisasife mage hie “Anumayamoga tagaya male maunana kanale ya hie. Katega nona taliꞋa (3) kilamatesune. Kagaila nagolagi Mosesena nagolagi Ilaiyana nagolagi huno hanesie.” huno hianagi agesa havilama ohuno ani kea hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hanepaigeno nago siaꞋmoꞋa evaꞋyi huno alino aiso humategeꞋana Mosesegani Ilaiyagania ani siapi falaꞋageꞋya PitaꞋene anagaꞋamoꞋyaene tusiꞋa koli humainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Koli nehageno siapinagati ala kefiti age aino mage huno hie “Mani kanoa nagaiꞋni nafaꞋne ago hapaliꞋna hutenoa nafaꞋnegi agai kea haviho.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","HamapaigeꞋya ani kea haviteꞋya agayana YisasiꞋa agaiꞋage mainegeꞋya ageteꞋya ke ohuꞋya mainayanagiꞋya ani kanafina nagoꞋa veala hamaꞋopainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","FaeteꞋya kotigeꞋya YisasiꞋene PitaꞋene YoniꞋene YemesiꞋene ani agoꞋya neꞋataleꞋya elavigeꞋya kasagoꞋya veaꞋmoꞋya Yisasi agegahe emainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aya veaꞋnefiti nago kanomoꞋa hetino ala kefiti mage huno hie “Humavenelina kanomoga tusiya huꞋna kahavinegoe. Aiya nagoke ne nafaꞋneꞋniꞋagi mego. ");
INSERT INTO kmu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","KanaꞋaene kanaꞋaene Kefo AvamuꞋmoꞋa agusafinaga haimainegeno nafaꞋneꞋnimoꞋa ala kegefafiti ke nehigeno Kefo AvamuꞋmoꞋa aige hafalege huneꞋategeno avayafitila efeꞋage agalemoꞋa selu selu nehigeno augafa alino haviya nehuno aupaꞋa ataleno oꞋvisia kava nehie. ");
INSERT INTO kmu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","NaꞋa higeꞋna kagaiꞋene tokaeꞋya nemaiya anagakaꞋmogamife ani Kefo Avamula nafaꞋneꞋnimo agusafinagati anatitalesae huꞋna hamavige hamavige hugetoana amuha ohunaya yafe anati oꞋatalenae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Higeno YisasiꞋa mage huno hamapaiye “Vae tamakaya meni kanafima mainaya veaꞋmogatama nagaife havitama tamakupi maletama tametiti ohutama fatago hutama nomaiye. AniꞋa haya yafe kasalo nenahaegi naꞋmagi yupa tamakaiꞋenena mainesugetama nagaife tamakupi malegahae?” nehuno ani nafaꞋnemo nefafe “NafaꞋnekaꞋa avaleka eno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Higeno ani nafaꞋnea yaufa avaleno neꞋegeno Kefo AvamuꞋmoꞋa alino mopafi ailakatitalegeno faemaineno kasegase nehigeno YisasiꞋa ageteno Kefo AvamuꞋmofe kemakino “Ataleka hatilavio.” huno hutegeno hatilavigeno ani nafaꞋnea alino kanale huteteno nefana amine. ");
INSERT INTO kmu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","AmigeꞋya mukiꞋa anile mainaya veaꞋmoꞋya ageteꞋya Anumaya Kotina tokiya yamaꞋahe tusiꞋa atalitalu huꞋya amamaꞋyo aiyanagi YisasiꞋa agaiꞋenema tokaeꞋya nemaiya anagaꞋamogamife mage huno hie “Menima hisua kea tamakesa havilama hutama haviho. Osi kanaꞋa maitesugeno nago kanomoꞋa nagesi hinageꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia kame vayaꞋmogami amayapi navaleꞋya nategahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","HigeꞋya ani kemona aepaꞋamoꞋa ago falakimaineafe havilama ohunagi koli huꞋya ani kemo aepaꞋahena haviokenae. ");
INSERT INTO kmu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya “Tagaipima uhakotemainea kanotia ta maine?” huꞋya huteꞋya ani yateti ke vaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","YisasiꞋa amakaipima hanea amaku amakesa ago haviteno nagola osi nafaꞋnea avaleno avate hetitene. ");
INSERT INTO kmu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ateteno mage huno hamapaiye “NagoꞋa veaꞋmoꞋya nagaifema huꞋya ma osi nafaꞋne avaleꞋya falu fala hutesayana nagaiꞋene navaleꞋya falu fala hunatae. NagaiꞋma navaleꞋya falu fala hunatesayana hunatenea kanoene avalemainae. Tamakaipina ‘OsiꞋa afa kano kana huꞋna mainoe.’ huno hisia kanomoꞋa tamakaila tamakaseno kava kano maine.” huno hamapaiye ");
INSERT INTO kmu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","YoniꞋa mage huno hie “Kava kanomoga tagaya agonana nago kanomoꞋa kagai kagi neꞋayeno Kefo Avamula veaꞋmogami amakusafinagati amanatigeta ageteta kagaiꞋenema kakave nohia yafe ‘AniꞋa ohuo.’ huta nagalu huneꞋatone.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Higeno YisasiꞋa agaife mage huno hie “Ani kanoa alitama nagalu hu oꞋateho. Vaya nagoꞋmo kamema hu otamatesiana nelamafuꞋya mainae.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","YisasiꞋa ikapinaga haisia kanamoꞋa aupa higeno Yelusalemu visia agesa havino tokiya vaiteno katega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","NagoꞋa anagaꞋa talo tala hisaya yafe hagoteno humategeꞋya nago Samelia kumate uꞋya vayafe mage huꞋya hae “YisasiꞋa egahigi mukiꞋa yana talo tala hiho.” huꞋya mo hamapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samelia kumate veaꞋmoꞋya YisasiꞋa Yelusalemu ugahe hia yafe amakesa haviteꞋya mage huꞋya hae “Tagaya avaleta ali falu fala hu oꞋategahune.” huꞋya hae*. ");
INSERT INTO kmu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","AgaiꞋenema toꞋkaeꞋana nemaiꞋa kanolatana Yemesigani Yonigani ani kavaꞋma haya kavala ageteꞋana mage haꞋe “Vae Anumayamoga kahaisiana taꞋagaya ikapinagati atahe ke hisuꞋageno ata maleno ani veala asagalisie?” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","HaꞋageno YisasiꞋa maiyahae huno keꞋanamakiteno “AꞋao aniꞋa ohiꞋo.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Huteno anileti neꞋataleꞋya alu kumatega umainae. ");
INSERT INTO kmu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Katega neꞋuꞋya nago kanomoꞋa Yisasifena mage huno humaine “MukiꞋa kumate visanana nagaya kakave ugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Higeno YisasiꞋa kenonaꞋa mage huno hapaiye “Kepu yagamoꞋya faesaya komuꞋamia mopafinaga hanegi namamogamina noꞋamia haneanagi ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna faesua noniꞋa omale.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nago kanohe mage huno hapaiye “Nakave eno.” huno higeno mage huno humaine “Alanimogae nenafana falisigeꞋna aliꞋna hevaiteteꞋna kakavela ugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Higeno YisasiꞋa mage huno kenonaꞋa hapaiye “Atalo nagai kea ohavinesaya veala amaku amamemaꞋamo falimainaya veaꞋmoꞋya falia kanomona aliꞋya hevaitegahae amakaiꞋami yanagi kagaya neꞋataleka veaꞋmogamite Anumaya Koti kava yagaimatesia kaiyekea mukiꞋa veaꞋmogamina hamapaiyo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nago kanomoꞋa hetino mage huno hapaiye “Alanimogae kagai kakave malegahe huanagi natalegeꞋna nenafa nopi mainaya veala nayana amamite amamite huteꞋna kakavela vano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Higeno YisasiꞋa kenonaꞋa mage huno hapaiye “NagoꞋa veamoꞋya avina yama kaligahena amakavelega maiyahae huꞋya moge mege hinuꞋyahena Anumaya KotiꞋa aniꞋa hisaya veafena ‘Nagai aliꞋya alitama veamogamite kava yakaisua kea hamapaiho.’ huno ohugahie.” ");
INSERT INTO kmu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","2","Anile AnumayamoꞋa sevetituꞋa (72) vaya hapaliteno “NagaiꞋnima visua kumate ali lokaete lokaete hutama uhagotetama neꞋviho.” huno humategahe amakaife mage huno hamapaiye “Nagai kema havisaya veala kasagoꞋya kaveꞋma hoyafi afulemailemai hia kava humainegi hoyafima aliꞋya alisaya veala osiꞋa veaꞋne kanoꞋa mainayafe ani hoyamona nefafe havigegeno nagoꞋa aliꞋya vayala kaveꞋma alisayafe humatesie. ");
INSERT INTO kmu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tamakaya neꞋutama haviho tamakaya sipi sipi nafaꞋne kana hutama mainagi nagaila ago amakaveꞋno hunenataya veala afai kala kana kaveꞋage veaꞋne mainaya amuꞋnopi hulamatesugetama ugahae. ");
INSERT INTO kmu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ugahagi monetamiene kutamiene tamaiya noꞋene alitama oꞋviho. Katega neꞋvisaya veaꞋnenena ayaꞋayate maitama kaiyekea ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nago nopima hai falenutama hagotetama mage hutama hiho ma nopima mainaya veaꞋmogatamina ‘Anumaya KotiꞋa tamaipa falu hisaya tamaku tamakesa tamamisie.’ hutama hiho. ");
INSERT INTO kmu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aipa falu hisia agesaene kano ani nopima mainesiana Anumaya KotiꞋa aipa falu hisia agesa amigahigi aniꞋa kana kanoma omainesiana aipa falu hisia yana oꞋaligahie. ");
INSERT INTO kmu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ani nopi mainetama nesaya yama tamamisagetama afaꞋa neho. Nagai aliꞋya alisaya anonaꞋa nesaya yana afaꞋa alisayana kanale hugahie. Alu nopi alu nopi faelitetama ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nago kumateꞋma visageno falu fala hulamateteꞋya tamamisaya kavela afaꞋa neho. ");
INSERT INTO kmu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ani kumateꞋma mainesaya kali veala ali kanale humatetama mukiꞋa veafe mage hutama hamapaiho ‘Anumaya KotiꞋa kava yagailamatesia kana ago efalote huno aupa humaine.’ hutama hamapaiho. ");
INSERT INTO kmu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Nago kumateꞋma visageꞋya falu fala hu otamatesagetama ani kumala ataletama veaꞋmoꞋyama mainesaya katega utama mage hiho ‘Havi kava hae. Tamakai kumapiti kugukege yana taiyalegati aifopo hutalegahunagi tamakaya havilama hutama haviho Anumaya KotiꞋa kava yagaisia kanamoꞋa ago efalote huno aupa humaine.’ hutama hamapaiho. ");
INSERT INTO kmu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nagaya tamahanepauve Anumaya KotiꞋa kaiyekema hulamatesia kanafina Sotomu mainaya veaꞋmogami amaugafa amagata aigahigi tamakaiꞋma falu fala hu otamatesaya kumate veaꞋmoꞋya tusiya huno amakaseno amaugafa amagata aigahie.” ");
INSERT INTO kmu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“AvoꞋnio Kolasini mainaya veaꞋmogatamaene Petesaita mainaya veaꞋmogatamaene tusiya huꞋna tamakaifena nahau nehue. Tamakai kumapi nagaya tokiya avameꞋyana ago huanagi tamaipa aiyahae ohageno ani tokiya avameꞋyana Taiyaene Saitoniene huleꞋasine ani kumate veaꞋmoꞋya kefo yaꞋamihena ago amaipa aiyahae huꞋya kefo yama humainaya yafena kayavo kena failiꞋya taꞋnefafi mopale maileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anumaya KotiꞋa kaiyekema humatesia kanafina Taiya mainaya veaꞋnene Saitoni mainaya veaꞋnene amaugafa amagata yana aligahayanagi tamakaya tusiya hutama nagoꞋene tamaugafa tamagata yana aligahae. ");
INSERT INTO kmu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tamakaya Kapaneamu mainaya veaꞋmogatama ‘Taugafa alita anale haigahune.’ hutama nehao? AꞋao afete tavitama tamakaye nehinagetama maigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","NagoꞋene humatenea vayaꞋmogamife mage huno hamapaiye “Tamakai kema havisaya veaꞋmoꞋya aniꞋa huꞋya nagai kea havigahae. Tamakaifema ‘TamahaoteꞋyatamie.’ hisaya veaꞋmoꞋya aniꞋa huꞋya nagaifena ‘KahaoteꞋyakae.’ huꞋya hunategahae. Nagaife ‘KahaoteꞋyakae.’ hisaya veaꞋmoꞋya aniꞋa huꞋya hunatenea kanomofena ‘KahaoteꞋyakae.’ huꞋya hutegahae huno hamapaigeꞋya umainae.” ");
INSERT INTO kmu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","UteꞋyama ayana ani sevetituꞋa (72) vayala muse huꞋya eꞋya mage hae “Anumayamoga tagaya kagai kagileti Kefo AvamuꞋa humatonageꞋya tagai ke akave malae.” huꞋya me hae. ");
INSERT INTO kmu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hageno YisasiꞋa amakaifena mage huno hie “Nagaya agoana SataniꞋa ikateti aulumaya alia kava huno aupaꞋa asaga hunelavigeꞋna agoe. ");
INSERT INTO kmu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Haviho nagaya tokiya ago tamaminoe. NagoꞋa yamoꞋa tamakaila alino haviya otamahaugahie. Satani tokiyamona agasesaya tokiya ago tamaminoe. Vaya anigeno nefalia osifaꞋvene yapaveꞋene tamaiyaleti ayelatapesayana nagaiꞋni tokiya ago tamaminoafe otamahaegahie. NagoꞋa yamoꞋa tamakaila ali haviya otamahaugahie. ");
INSERT INTO kmu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","TokiyaꞋnia ago tamaminogi Kefo Avamula amakasesaya tokiya tamaminoa yafena musena ohutama Anumaya KotiꞋa tamakima ikapinaga kaemalenea yafena tusiꞋa muse hiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ani kanafina Alu Aotage AvamuꞋmoꞋa tusiya huno muse hisia agu agesa amigeno YisasiꞋa muse nehuno mage huno hie “Nenafagae mukiꞋa ma mopafi yaꞋene ikapinaga yaꞋene kava yagaimainana Anumayamoga kanale kava nehane. Ma ma hamapauva kea nagoꞋa ‘MukiꞋa yafena havilinoa kano mainoe.’ huꞋya haya veaꞋmogamifena ohavisae huka falakimalenane. ‘Ala avo nopi umainona vea mainone.’ huꞋya hisaya veaꞋmogamifena ohavisae huka falakimalenanagi ‘Inamu nafaꞋne kana huta mainone.’ huꞋya humainaya veala ago huhaleka amavelimainanafe aluya huꞋna musekaꞋa nehue. E, Nenafagae kagai kagu kagesamoꞋa aniꞋa humainegeka ani kavala humainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","VeaꞋmogamifena mage huno humaine “NenafaꞋa mukiꞋa lokiya ago namine. MukiꞋa veaꞋmoꞋya nagaila neꞋamonina aepaꞋnia ohavinagi NenafaꞋa agaiꞋage nagai aepaꞋa haviline. Havilinegi mukiꞋa veaꞋmoꞋya Nenafa aepaꞋa ohavinae. NagaiꞋnige neꞋamoꞋna havilineꞋna nahaisia veaꞋmogamina humavelisugeꞋya Nenafa aepaꞋa havigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","YisasiꞋene toꞋkaeꞋya nemaiya anagaꞋmoꞋya amahaote mainageno YisasiꞋa mage huno hamapaiye “Anumaya KotiꞋa tamaulagama neꞋagaya yana ago tusiꞋa kanale ya ago tamamia yafena tusiꞋa muse hutama maiho. ");
INSERT INTO kmu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tamahapauve nayona mukiꞋa mainaya amaune vayaꞋene sauve vayaꞋyagaene tamakayama neꞋagaya yana ‘Agesune.’ huꞋya hayanagi oꞋagenae. Havilinaya kea ‘Havisune.’ huꞋya hayanagi ohavinae.” huno hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","NagoꞋa kahegi kema havilinea kanomoꞋa hetino Yisasina ayevataga huno mage huno havige “Humavenelina kanomogae nagaya hanaꞋa huteꞋna agola maige maige hisua nahaimula alisue?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Havigegeno YisasiꞋa mage hie “Anumaya Koti autaꞋmafina naꞋane huꞋya kaemalenae? Kagaya hapaliteka ani kemo aepaꞋa naꞋane huka nehavine?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Havigegeno mage hie “Ani kemoꞋa mage humaine ‘Ala Anumaya Kotikamofena tusiya huno kahaino. KaguꞋafinagatiꞋene kahaino. Kagu kameꞋene amio. AliꞋya neꞋalina himamukaene amio. Kagesama nehavina yana amio. Kagaika kaugafahema kahaisia avamete mukiꞋa veamogami amaugafahena kahaino.’ huno humaineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Higeno YisasiꞋa mage hie “Kagai kemoꞋa tamage huka nehane mukiꞋa kanafina ani kava huge huge hisanana maige maige hisana kahaimula aligane.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Higeno ani kanomoꞋa agesafinaga mage huno havie “YisasiꞋa nagaife kanale kagesa hanea kano mainane.” huno hisiafene huno havige “MukiꞋa veala tagamife nehane?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Havigegeno YisasiꞋa mage hie “Nago Yuta kanoa Yelusalemu kumala ataleno Yeliko kumatega ugahe katega neꞋvigeꞋya nagoꞋa musufa vayaꞋmoꞋya katega ageteꞋya atafa huꞋya mukiꞋa afenomaꞋa hanafaleteꞋya aikolimainae. AikoliteꞋya ataleꞋya vageno falisia kava huno maine. ");
INSERT INTO kmu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mainegeno ani yupa mono note kava kanoa ani kate taviana ani kanoa mo neꞋageno agaseno ka agegayalega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Umainegeno nago Yuta kanoa Livai nofi kanoa aniꞋa huno mo neꞋageno agaseno nago kaiyaga ka agegayalega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","NaꞋa haꞋageno nagola Samelia kanoa kame kanoꞋamoꞋa anile neꞋeleti megeteno tusiꞋa hau hutene. ");
INSERT INTO kmu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hau huteteno avate umaineno masave tiꞋene nofi alagamo tiꞋene haemalaya amupina takino haꞋya kiteteno avaleno agaiꞋa toki afumo agupifi ateteno avaleno viaꞋyamo natu vaya nefayaya nopi moteneno kanale huno kava hutene. ");
INSERT INTO kmu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kava huteno mainegeno ko tigeno ani nomona nefana tole kina neꞋamino mage huno hapaiye ‘Kagaya kanaleꞋya huka mani kanoa kava huto. NagoꞋa monekamoꞋma ani kanoleꞋma haꞋno hisigeꞋna nagaya eteꞋna anonakaꞋa kamigahue.’ huno hapaiye.” ");
INSERT INTO kmu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","YisasiꞋa anima hia kea hu haꞋno hugahe mage hie “NaꞋa humainagi na kagesa nehavine? TaliꞋa (3) vayala agaseꞋya vageno hana kanomo musufa vayaꞋmoꞋya hae-malenaya kanomona alino kanapa vayaꞋmoya nehaya kavala hu-tene?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Higeno ani kahegi kema havilinea kanomoꞋa mage hie “TusiꞋa hau hutenea kanomoꞋa kanapa vaya kana kavala hutene.” huno higeno YisasiꞋa agaifena mage hie “Kagaya visanaꞋamoga mukiꞋa kanafina aniꞋageꞋya huo.” huno hapai-maine. ");
INSERT INTO kmu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","YisasiꞋene agaiꞋaenema tokaeꞋya nemaiya anagala katega neꞋvageno YisasiꞋa nago kumate vigeno nago aꞋmo agia MataꞋe Yisasina avaleno nomaꞋafinaga umaine. ");
INSERT INTO kmu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Umainegeno Matana negana agia MaliaꞋe Yisasina aiyafi mopale emaineno YisasiꞋma hia kaiyekea nehavie. ");
INSERT INTO kmu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Havino mainegeno nunaꞋamoꞋa, MataꞋa, mukiꞋa kavela talo tala hiana agesamoꞋa tole-lole higeno Yisasite eno mage huno hie “Anumayamogae naganaꞋnimoꞋa natalegeꞋna nakaiꞋnige kavela tusiya huꞋna neꞋalugi ani yafena kagesa nohavino? Hapaigeno me naya hino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Higeno YisasiꞋa mage huno hie “Mataga mukiꞋa yafena kagesamoꞋa tole-lole huka aliꞋyana neꞋalinana havi kava nehane. ");
INSERT INTO kmu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nagoke yamaꞋage alisana kagesa havige havige huka maiyo. MaliaꞋa ani yafena agesa havi havi huno atafa nehigi ani yana nago kanomoꞋa hana-ofalegahie.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nago yupa YisasiꞋa nago kotega maineno Anumaya-motega ke huno havige-maine. Havigeteno agaiꞋaene tokaeno nemaiya anagapiti nago kanomoꞋa mage huno havige “Anumayamogae YoniꞋene tokaeꞋya nemaiya anagaꞋmogamina humavelimainea kavala huka ‘NaꞋa maꞋa hutama nunamuna hiho.’ huka hulavelio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Higeno YisasiꞋa mage huno hie “Nunamuma hinutamahena mage hutama hiho ‘Nelafaga kagai kagimoꞋa alu aotage huno hanesie. Kava yagaisana kanamoꞋa efalote hisie. ");
INSERT INTO kmu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","MukiꞋa kanafima nesuna kavela tamio. ");
INSERT INTO kmu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tagaya havi kavaꞋma hulatenaya veala aigeꞋamateteta kefo yaꞋamia atalematona kava huka kefo yatia aigetateka atalelato. SataniꞋma ayelavataga hisia katela tavaleka otato.’ hutama hiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hamapaiteno mage huno hie “Hana kanomoga kege amuꞋnona negafute uka mage huka hugane ‘Nenafugae taliꞋa (3) maya yoka namisano? ");
INSERT INTO kmu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","7","Nago nenafuꞋa kategati eana nesia yana omalegi kanale namisano?’ hukama hisanageno negafuꞋa nomaꞋafinagati make huno kahapaisio ‘Kasalo nenahaegi natalo. Fita ago ki-maleteꞋna nafaꞋneyagaꞋniene ago fae-mainonanagita nagaya hetiꞋna nahavigana yana okamigahue.’ huno hisio? ");
INSERT INTO kmu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","AꞋao tamahanepauve ‘NegafuꞋma mainoe.’ huno hisia yafena oꞋamigahigi tutuꞋma hia yafe hetino havigea yana amigahie.” ");
INSERT INTO kmu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ani yafe tamahanepauve Anumaya Kotitega nago yafema ke hutama havigesagenoꞋa ago tamamigahie. Nago yafema atiyesagenoꞋa afaꞋa tamaveligahie. FitaleꞋma akalu-kaluma hisagenoꞋa Anumaya KotiꞋa yakilamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","MukiꞋa havigesaya veaꞋmoya aligahae. Atiyesaya veaꞋmoya ali falote hugahae. FitaleꞋma akalu-kalu hisaya veaꞋmogamina fita yakimategahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hana kanomoga nafaꞋnekamoꞋa noyamehema kahavigesigeka nefaga osifaꞋvea alika amigano? AꞋao ani yana alika oꞋamigane. ");
INSERT INTO kmu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kokole amufema kahavigesigeka yapavena alika amigano? AꞋao ani yana alika oꞋamigane. ");
INSERT INTO kmu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","OꞋamiganagi tamakaya havi veaꞋne mainayanagitama nafaꞋnetamimona kanale ya amamiyanagi ikapinaga mainea nelamafaꞋa tusiya huno tamakase-maineanagitama havigesageno Alu Aotage AvamuꞋa tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nago kanomona Kefo AvamuꞋmoꞋa* aguꞋafi mainegeno avefuꞋna alino aiyahae higeno agea noꞋaiyane. YisasiꞋa ani Kefo Avamula anati-talegeno vigeno ani kanomoꞋa age aino kea kea higeꞋya alitalu hu-mainaya veaꞋmoꞋya ageteꞋya tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","AmamaꞋyo neꞋaigeꞋya nagoꞋa veaꞋmoꞋya mage hae “PielesepuliꞋa Kefo AvamuꞋyagale kava hu-mainea kanomoꞋa tokiyaꞋa amigeno Kefo AvamuꞋmona anati-neꞋatalie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","HageꞋya nagoꞋa vayaꞋmoꞋya aye-vataga hugahe mage hae “Monafinagati avame yana hugeta tokiyakaꞋa agamano.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hageno YisasiꞋa amakupinagama ma haviya amaku amakesa ago haviteno mage hie “Nagoke kotega veaꞋmoꞋya aye fako huꞋya tuma hisayana ani kotega veaꞋnene haviya hu-lavigahae. Nago afamo aye fako huꞋya ‘Alu vaya mainone.’ huꞋya tuma hisayana ani afamola haviya hu lavigahae. ");
INSERT INTO kmu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","SataniꞋa anagaꞋaenema aye fako huꞋya ‘Alu vaya mainone.’ amakaiꞋami tuma hisayana Satani kava yagaisia tokiya hanaꞋa huno hanegahie? AꞋao tokiyaꞋa omalegahie ani yafe tamakaya nagaifena ‘PielesepulimoꞋa tokiya kamigeka ani yateti Kefo Avamula neꞋanatine.’ hutama nehayanagi havige nehae. ");
INSERT INTO kmu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nagaifena ‘Kagaya Pelesepulimo tokiyaleti anati neꞋatalane.’ hutama hayanagi tamakaitami anagatamia Kefo Avamula amanati-talageno Pielesepulimo amakaila amaya nehio? Ani anagatamia amakaiꞋami manima haya kea ali fako huꞋya tamaveneliye. ");
INSERT INTO kmu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tamage nagaya Anumaya Koti tokiyaleti ani Kefo Avamula anati neꞋataloe. Ani yafe Anumaya KotiꞋa kava yagaisia yana tamakaitela ago emaine. ");
INSERT INTO kmu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nagola tokiyaꞋage kanomoꞋma nomaꞋafima ati keveꞋa alino yagai-maleno maisiana mukiꞋa yamaꞋamoꞋa kanale huno hanegahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nagola tokiyaꞋage kanomoma eno ani tokiyaꞋage kanoenema tuma hisaꞋana tokiyaꞋage kanomoꞋa agasesiana hagote kanomoꞋma ametitima huno mainea ati keveꞋa melino ani kanomo afeno yamaꞋa musufa alino vayaꞋamogami amamite amamite hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","NagoꞋa veaꞋmoꞋya nagai kanapa veaꞋne omaisayana kame vayaꞋniꞋa mainae. NagoꞋa veaꞋmoꞋya sipi sipiꞋniꞋama naya huꞋya ali-taluma ohisayana amanati neꞋatalae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nago Kefo AvamuꞋmoꞋa vaya aguꞋafi haino maineleti ataleno viaꞋyamo hau hu-mainea kopinaga mo vaiyatete huno mai-faluma hisia kumafe ati neꞋaye. Ati ayegeteana mai-falu hisia kumala omalegeno “HagoteꞋna maigeꞋna emainoa aguꞋafi eteꞋna mo maigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Uno mogeana ani agupi ago sese huno kanaleꞋya hu-malenegeno mogemaine. ");
INSERT INTO kmu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mogeteno eteno viaꞋyamo seveniꞋa (7) kefo kavaꞋamimoꞋma agase-mainea Kefo AvamuꞋyaga momavaleno egeꞋya ani agupi hai-faleꞋya mainageno hagotenoꞋa ani kanomoꞋa nagoke Kefo AvamuꞋmoꞋa aguꞋafima mainegeno haviya huno maineanagino menia mukiꞋa Kefo AvamuꞋmoꞋya aguꞋafina haiꞋya maigeno tusiꞋa kefo ya hutafa huno maine.” ");
INSERT INTO kmu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mani kema higeꞋya anifima alitalu hu-mainaya veaꞋnefiti nago aꞋmoꞋa ala kefiti mage huno hie “KatetenoꞋma numa kaminea aꞋmona Anumaya KotiꞋa tusiꞋa muse huno haiya yana amine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Higeno YisasiꞋa mage huno hie “Ani aꞋmoꞋa musena hugahianagi Anumaya Koti kema haviꞋya akave malesaya veaꞋmoꞋya tusiꞋa muse hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","MukiꞋa veala agaite melitalu hageno mage huno hamapaiye “Menia ma kanafima mainaya veaꞋmoꞋya tusiya huꞋya kefo veaꞋne mainae. ‘TokiyaꞋage avame yana tavelio.’ huꞋya hayanagi Anumaya KotiꞋa ani yana oꞋamamigahigi nagoke avame yana nayoma mainea aune kanoa Yonama hutenea tokiya avame yana tamaveligahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonana noyamemoꞋa asaga huno nakaigeno taliꞋa (3) yupa aipafinaga maineafe Ninive mainaya veaꞋmoꞋya avame yana amaveli-maineane. Nagaya ikapinagati emainoa kano vayaꞋmo natenea kanomoꞋna menia ma kanafima mainaya veaꞋmogamina nagaya aniꞋa kavala hisua kavaꞋniꞋa avame yana tamaveligahue. ");
INSERT INTO kmu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nagola alu haupalegati emainea sauve aꞋmoꞋa mopamona atupaleti eno SolomoniꞋa kanale agu agesaene kanomo kea havigahe emaineanagi haviho Solomonina agase-mainea kanoa ma mainegetama tamakaya agai kea nohaviye. Nohaviyafe Anumaya KotiꞋa kaiyekema hulamatesia yupa ani aꞋmoꞋa hetino menia ma kanafima mainaya veafe kefo kava hutama agai kema ohavinaya yafena hu falote hulamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive kumate mainaya veaꞋmogamina YonaꞋa Anumaya Koti kea hamapaigeꞋya kefo yaꞋamihena amaipa aiyahae hu-mainagi haviho menia Yonana agase-mainea kanoa ma mainegetama tamakaya kefo yatamihena tamaipa aiyahae nohae. Tamaipa aiyahae nohayafe Anumaya KotiꞋa kaiyekema hulamatesia kanamoꞋa Ninive kumate nayoma mainaya veaꞋmoꞋya hetiꞋya menia ma kanafima mainaya veaꞋmoꞋya havi kava hu-mainayafe hu falote hulamategahae.” ");
INSERT INTO kmu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“VeaꞋmoꞋya lamua hanagaliteꞋya nopinaga hanesia komufinaga omalegahae. Susufaneletila aiso ohugahagi ani nopima hai falesaya veaꞋmoꞋya agesayafe sipale nemalae. ");
INSERT INTO kmu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","TamaulagamoꞋa tamakupinaga aivasa hisia lamu hane. TamaulagamoꞋa kanale yama agesiana tamakupinaga aivasa hu-mainegi tamaulagamoꞋa kefo yama agesiana tamakupinaga haniki-maine. ");
INSERT INTO kmu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tamakesa havilama hiho ‘Nagupinaga aivasa hu-maine.’ hutamama hisayana asu huno haniki-mainesia yafe hisagi kava yagaitama maiho. ");
INSERT INTO kmu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","MukiꞋa tamaugafa aivasa hisigeno nagoke kaiyaga hanima okisiana lamumoꞋma aivasa hia avamete mukiꞋa lamakupinaga tusiya huno aivasa hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nagola Falasia kanomoꞋa Yisasifena mage huno hie “Menia kagaya nagaiꞋene kavela me negane.” huno higeno YisasiꞋa kave mo negahe Falasia kanomo nopi haino mopale maine. ");
INSERT INTO kmu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mainegeno ani Falasia kanomoꞋa mogeana YisasiꞋa kaveꞋma negahena ayana sese ohuno* mopale maiya yafena agesa havi havi huno maine. ");
INSERT INTO kmu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mainegeno YisasiꞋa mage huno hapaiye “Tamakaya Falasia* vayaꞋmogatama amega kava hutama masutamiene yopatamiene amega kaiyagaꞋa sese nehagi tamakupina musufa yaꞋene kefo yatamiene hiya hulamatenegetama sesela nohae. ");
INSERT INTO kmu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tamakaya aifoꞋnafo vaya mainageno Anumaya KotiꞋa amega kaiyagaꞋage talo nehuno agusafinaga talo ohuneo? ");
INSERT INTO kmu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Masutamiene yopatamienema hanesia kavela kasagoꞋya yaꞋamima omalenesia veaꞋmogamima amamisayana tamakuꞋamoꞋa oniꞋyaꞋage ohugahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","AvoꞋnio Falasia vayaꞋmogatama kaꞋyeho. Tamakaya supu tala yaꞋene atuꞋene hefi kana yaꞋene osi osi yana alitama teniꞋa (10) malenafiti nagoke Anumaya Kotina neꞋamitama nehayanagi fatago hutama maisaya yaꞋene Anumaya Kotifema lamahaisia yaꞋene ago atalenae. Hagotetama fatago hutama mainetama Anumaya Kotifena tamahau tamayamopafi tamahau-maineanagitama haenagaꞋa supu tala yaꞋene atuꞋene hefi kana yaꞋene teniꞋa (10) malenafiti nagoke Anumaya Kotina amisayana kanale hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","AvoꞋnio Falasia vayaꞋmogatama kaꞋyeho. Mono nopima neꞋutama ‘Kava vayayaga nemaiya sialefekeꞋya maigahune.’ hutama veaꞋne atagu nefaya kumapina ‘Nagaifena ala kano mainane huꞋya hisae.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","AvoꞋnio tamakaya kaꞋyeho. Tamakaya vaya hevaimatenaya komu kana hutama mainae. TamakuꞋamoꞋa oniꞋyaꞋage higetama falaki-mainageꞋya veaꞋmoꞋya oniꞋyaꞋage yama hanea komufi vaya hevaitenaya komule oꞋageꞋya ute ete nehae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Higeno nagola kahegi kema havilinea kanomoꞋa kenonaꞋa mage huno hapaiye “Hulavenelina kanomogae ani kema hanana tagaiꞋenefe tagaye hia ke nehane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Higeno mage huno hie kahegi kema havilinaya vayaꞋmogatama tamakaifeꞋene nehugi avoꞋnio kaꞋyeho. Tamakaya kahegi ke malenaya ke hutama tusiꞋa kanaꞋage ya mukiꞋa veaꞋmogami amayoꞋnale malenetama amaya hugahena nagoꞋke tamakinagoa maletama amaya ohageꞋya tusiꞋa kana yakefa neꞋaliye. ");
INSERT INTO kmu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","AvoꞋnio kaꞋyeho. Tamakinago-moꞋya Anumaya Koti amaune vayaꞋa hamayageꞋya fali-mainayanagitama tamakaya anima fali-mainaya amaune vayaꞋmogami komulega vilasi hoya maitama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vilasi hoya maitama nehayafe “TamakinagomoꞋya amaune vayala hamayageꞋya fali-mainaya yafena kanale kava humainae.” hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anumaya KotiꞋa kanale agu agesaene kanomoꞋa mage huno humaine “Nagaya nagaiꞋni amaune vayaꞋene Aposolo vayaꞋene amakaipina visageꞋya nagoꞋa veaꞋmoꞋya ali haviya humateꞋya nagoꞋa veaꞋmoꞋya hamaesageꞋya faligahae.” ");
INSERT INTO kmu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","HamayageꞋya fali-mainaya yafe ma mopama talo hu-mainoa kanafina aepa heꞋya mukiꞋa kafua amaune vaya hamayageꞋya fali-mainagi tamakaya meni kanafima mainaya veaꞋmogatama amakaiꞋma humatenaya havi kavaꞋmo anonaꞋamia aligahae. ");
INSERT INTO kmu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hagoteno Epolona haegeno fali-maineane. NagoꞋa hamaeme hamaeme ageno haꞋno hutegeꞋya haenagalafa Sekalaiyana ala mono no kegiꞋyamo amuꞋnopi yafa folamole heti-mainegeꞋya hayageno fali-maineane. Nagaya tamage huꞋna tamahanepauve hamayageꞋya fali-mainagi tamakaya menima mainaya veaꞋmogatama hu-mainaya havi kavaꞋmo anonaꞋamia aligahae. ");
INSERT INTO kmu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","AvoꞋnio kahegi kema havilinaya anagaꞋmogatama kaꞋye ho. MukiꞋa Yisasi kea havimainayanagi veaꞋmoꞋya ohavisae hutama fita ki-maletetama yakisaya ki nofila ago alitama atalenae. Tamakaya “Ani nopi ohaigahune.” hutama haleti nagoꞋa veaꞋmoꞋya “Hai falegahune.” huꞋya haya veaꞋmogamife “Hai ofalegahae.” hutama katile neꞋamatae huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","YisasiꞋa ani nopiti hati-lavigeꞋya mukiꞋa kahegi kema havilinaya anagaꞋene Falasia vayaꞋene akave neꞋuꞋya tusiya huꞋya amaipa kafa heteteꞋya amata huꞋya alu yafe alu yafe agaila havige havige nehuꞋya mage hae “AgaiꞋama hisia keleti atafa huta kaiyekea hutegahune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ani kava higeꞋya ohavunamaꞋa veaꞋmoꞋya alitalu humainaya yapina nagoꞋa veaꞋmogami amaiya aye latapemo huꞋya mainageno YisasiꞋa agaiꞋenema tokaeꞋya nemaiya anagaꞋamogamife nagoꞋa veaꞋnenefe mage huno hie “Falasia vayaꞋmoꞋya amakupima hanea yana agelama ohuꞋya amavayaleti havigema nehaya yafena kaꞋyeho. Ani yana kai hamemoꞋma halegia kava huno halegino alakefa hugahie. Tamakaya ani yafena kaꞋyeho. ");
INSERT INTO kmu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aiso humainea yamona Anumaya KotiꞋa mukiꞋa alino fufute atalegahie. Falaki-mainesia yamona Anumaya KotiꞋa mukiꞋa veaꞋmogami amaulagafi ali falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hanipinaga hu-mainesaya kea veaꞋmoꞋya yagefi havigahae. Notamifinaga sumi sumi hutama hu-mainesaya kea kuma amuꞋnopiti ala kefiti keha keha huꞋya hugahae.” ");
INSERT INTO kmu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nenafugatama tamahanepauve amega tamaugafaꞋage hefalisaya veafena kolia ohiho. Ani veaꞋmoꞋya tamaku tamameꞋene tamahae falisaya himamuꞋamia omalene. ");
INSERT INTO kmu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“Hana kanomofe kolia hisune?” hutama hayanagiꞋna tamahapaigahue. HefalitenoꞋma hanimo aguꞋafi ata tegelege nehia yapi tamaku tamamema hagaꞋyu hulama-talesia tokiyaꞋama hanea kanoa, Anumaya Kotifeke tusiya hutama koliꞋa hiho huꞋna tamahanepaugi Anumaya Kotifeke koliꞋa hiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“FaefuꞋa (5) osi osi namayaga tole haesa moneleti miya nehayanagi Anumaya KotiꞋa ani nama nagokefena agelaꞋokanino amakaifena agesa havi havi huno mainegi tamakaitamifiti nagokeꞋmoga mukiꞋa namayaga agasetama mainayanageꞋya veaꞋnea ala yaga mainae. Anumaya KotiꞋa mukiꞋa hanea tamayolagefa ago hapalino haviline. Kolima hisaya yana neꞋataletama afaꞋa maiho. huno hie.” ");
INSERT INTO kmu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Tamahanepauve nago kanomoꞋma veaꞋmogami amaulagafi nagaifema “Yisasina naguꞋa amitafa humainoe.” huno hu falote hisigeꞋna nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna Anumaya Koti ensole anagaꞋmogami amaulagafina agaifena “Nagai nafaꞋne maine.” huꞋna hu falote hugahue. ");
INSERT INTO kmu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hu falote hugahugi nago kanomoꞋma veaꞋmogami amaulagafi nagaifema “NaguꞋa amitafa nohue.” hunoꞋma hufalote hisigeꞋna nagaya Anumaya Koti ensole anagaꞋmogami amaulagafina ani kanohena “OꞋagenoa kano maine.” huꞋna hugahue. ");
INSERT INTO kmu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","NagoꞋa veaꞋmoꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonihema hu-haviya hunatesayana Anumaya KotiꞋa aigeꞋamateno ani kefo yaꞋamia atalemategahigi veaꞋmoꞋya Alu Aotage AvamuꞋmofema hu-haviya hutesayana Anumaya KotiꞋa aipa haviya huno aigeꞋamateno ani kefo yaꞋamia ataleoꞋamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nagai kema huhaletama hisaya yafena kaiyeke hulamategahae. TamavaleꞋya mono nopi ala kaiyeke hulamate vayate visagetama kolia hutama “KenonaꞋamia naꞋane ke hisune?” hutama tamakesa kuꞋmoꞋa ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ani yupa kanoꞋa Alu Aotage AvamuꞋmoꞋa “Mage hiho.” huno tamahapainagetama hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anima alitalu hu-mainaya veapiti nago kanomoꞋa Yisasina mage huno havige “Humavenelina kanomogae nepuꞋnimona hapaigeno nelaꞋafaꞋma ataleno fali-mainea afenopiti fako huno nagoꞋa namisie.” huno havinege. ");
INSERT INTO kmu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Havigegeno kenonaꞋa YisasiꞋa mage huno hapaiye “Nagaya kaiyekea huꞋna fako hisua kanoa omainoe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hapaiteno YisasiꞋa amakaifena mage huno hie “Tamakaya maihao hutama maiho. Alu kanomo yafena agetama tamahaꞋyea ohiho. Nago kanomoꞋa kasagoꞋya afenomaꞋa haneanagi ani afenomaꞋamoꞋa kanaleꞋya huno maisia haimula oꞋamigahie.” ");
INSERT INTO kmu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nago avame kea mage huno hamapaiye “TusiꞋa afenomaꞋa hanea kanomona hoyaꞋafina tusiya huno alaga aye-maine. ");
INSERT INTO kmu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aye-mainegeno agesafinaga mage huno havimaine ‘Na ya hisue? KaveꞋnia aliꞋna halaꞋya hisua nona omaleanagiꞋna hanaꞋa hisue?’ ");
INSERT INTO kmu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","MaꞋa hisue. Yu noꞋyagaꞋniꞋa tagape aitaleteꞋna ala noꞋyaga kasagoꞋya kigahue. KiteꞋna mukiꞋa kaveꞋniꞋaene afenoꞋyaniꞋaene anifi halaꞋya hu-malegahue. ");
INSERT INTO kmu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hu-maleteꞋna nagaiꞋnihena mage huꞋna hugahue ‘Nagu nagesamoga mukiꞋa kafua nesua kaveꞋene afenoꞋyaniꞋaene ago halaꞋya hu-malenogi menia nagaya maifalu huꞋna maineꞋna kaveꞋniene tiniꞋaene nege nege nehuꞋna muse huꞋna maigahue.’ huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hianagi Anumaya KotiꞋa agaifena mage huno humaine ‘Ani kava hana kavala aifoꞋnafo kano kana kano mainananagika meni kegela kahaimula kahafalesugeka faligane. FalitesanageꞋya talo tala humalenana afenoꞋyagakaꞋa taꞋya aligahae?’ huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Huteno YisasiꞋa mage huno hie nagoꞋa veaꞋmoꞋya amakaiꞋami amaugafa aliꞋya haisaya yafe mone afenoꞋamia halaꞋya nehayanagi Anumaya KotiꞋa musema hisia kavala aliꞋya halaꞋya nohayafe ani kanomoꞋma humainea kava kana veaꞋne mainae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","TuelufuꞋa (12) anagaꞋamogamife mage huno hamapaiye “Ani yafena nagaya tamahanepauve kanale hutama maisaya yaꞋene kave nesaya yaꞋene ti nesaya yaꞋene tamakesa havi havi ohiho. Tamaugafale kena failisaya yafeꞋene tamakesa havi havi ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kave neyana aifa letale yanagi kahaimuna kanaleꞋya huka maisana yana kanale ya hane. Kena failisana yana amegale yanagi veaꞋnea tokiya ya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hakiki namayaga ageho. Amakaya avina yana ofaiꞋya kavela hoyafinagatila noꞋaliye. Kave malesaya noꞋamiene yu noꞋamiene omaleneanagi Anumaya KotiꞋa kavela afaꞋa neꞋamamie. Tamakaya namayaga amakase-mainaya veaꞋne mainayafe tamakaiꞋene kava yagailamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tamakaitamifitila nago kanomoꞋa ‘OfaliꞋna nagoꞋene maime maime haigahue.’ huno tokiyaꞋage agesa havisiana anima havia katela hanaꞋa huno falote hugahie? AꞋao falote ohugahie ");
INSERT INTO kmu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ohugahigi ani osi ya kanoꞋa ohaleꞋasine naꞋa higetama nagoꞋa maisaya yafena tamakesa havime havime nehaiye? ");
INSERT INTO kmu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ageho talapinaga hanea vilasiyamoꞋya haiꞋya ausea nehae. AliꞋyana aliꞋya kenaꞋamia talo huꞋya fainoꞋaligi kanale kenaꞋami hanegeꞋna nagaya tamahanepauve nayoma mainea ala sauve kanotamia SolomoniꞋa kanale kenaꞋa failianagi ma vilasiyamoꞋya kanaleꞋya huꞋya agase-mainae. ");
INSERT INTO kmu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tala yana meni kanafina hoyafina haneanagi ega hataga huꞋya atafi atalegahagi Anumaya KotiꞋa ani tala yana kava yagaigeno kanaleꞋya humainegi tamakaya mukiꞋa veaꞋmogatama nagaifena tamakupi maletama tamametitia osi kanoꞋa nehagi Anumaya KotiꞋa aniꞋa huno tamakaila kenatamia alino hilato hulamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ani yafe ‘KaveꞋene tiꞋene na ya negahune?’ hutama tusiꞋa tamakesa havi havi ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","NaꞋa yafena ma mopale mainaya veaꞋmoꞋya Anumaya Koti kema nohaviya veala amakesa havi havi huꞋya nemaigi NelamafaꞋa nesaya yaꞋene kena failisaya yaꞋenefena ago havimaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Havimaineafe tamakaya ani kavala ohutama Anumaya KotiꞋma kava yagaisia kumate visayafe tamakesa havi havi hutama maisayana Anumaya KotiꞋa ani yaꞋene mukiꞋa kavetamiene kenatamiene tamamiteno ani kumatela tamavaleno tamategahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nenafugatama tamakaya osi kanoꞋa sipi sipia mainagi kolia ohiho. NelamafaꞋa kava humainea kumatela utama visageno kava yagailama-tesigetama maisayafe agesa havino mainegi kolia ohiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ani agesa havimaineanagitama afenoꞋyatamia alitama afenoꞋyaꞋami omalesia veaꞋmogami amamiho. Na kava hisayana ikapinaga muse yatamia talo hugahae. Ani ikapinaga muse yana haꞋno ohugahie. Musufaya nehaya vayaꞋmoya musufayama hugahena ani kumatela oꞋugahae. HakaꞋnomoꞋa ali haviya ohugahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Muse yatamima malenesaya kumatefe tamakesa havi havi hutama ani kumate visaya tamaku tamakesa havitama maigahae. ");
INSERT INTO kmu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","YisasiꞋa mage huno hie “Ala kanoma esiafe kenatamia alitama aupa hutama failinetama tamamu nofila hulinetama kaꞋnitamia aye haletama maiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","NagoꞋa aliꞋya vayaꞋmoꞋya ala kanoꞋamimofe agava maisaya kava hutama maiho. Ani ala kanomoꞋa aꞋma alisia imulegati eteno no fitaꞋaleꞋma me kalu-kalu hisigeꞋya aupaꞋa hetiꞋya yakitesayafe agava mainae. Tamakaya aniꞋa hutama nagava maiho. ");
INSERT INTO kmu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ala kanoma emainea kanafina hetiꞋya maineꞋya agavama mainaya aliꞋya vayaꞋamoꞋya tusiꞋa muse huꞋya maigahae. Tamage tamahanepauve ani ala kanomoꞋa kenaꞋa ali aupa huno failineno aliꞋya vayaꞋahe ‘Mopale maiho.’ huno humateteno kavela amamite amamite hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kege amuꞋnopi esio? KokolemoꞋa agea oꞋainesigeno esio? Esigenofena hetiꞋya agava maisaya aliꞋya veaꞋmoꞋya tusiꞋa muse hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tamage huꞋna tamahanepauve nomona nefaꞋma musufaya hisia kanomoꞋa nomaꞋafi ehai falesia kanahema havimaineleꞋasina nomaꞋa ataleno oꞋvigeno nomaꞋafina ehaino musufayana ohileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","TamakaiꞋenena talo tala hiho. ‘Menia omegahie.’ hutama hisaya kana kanoꞋale ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna egahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","PitaꞋa mage huno humaine “Anumayamogae tagaifekeꞋya ani avame kaiyekea tahanepaino ifi mukiꞋa veaꞋne havisae?” huno havigemaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","AnumayamoꞋa mage huno humaine “AliꞋya kanomoꞋa kanale agu agesa hanea kanoa aliꞋyamaꞋa agegeno alige alige nehia kanoa tamakaipina hanate maine? AniꞋama humainea kanomofe kava kanomoꞋa mage hugahie ‘MukiꞋa aliꞋya veate yagai-maineka kavela fako faka huka mukiꞋa kanafina amamite amamite huo.’ huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hugahigi haenagaꞋa ani ala kanomoꞋa eteno esigenoꞋa hapai-mainea augafa kavaꞋma hinagenofena ani aliꞋya kanomoꞋa muse hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tamage huꞋna tamahanepauve aniꞋama humainesia aliꞋya kanomofena ala kanomoꞋa mage hugahie ‘MukiꞋa yaniꞋa kava yagaiyo.’ huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Hugahianagi ani aliꞋya kanomoꞋa agaiꞋa agesafinaga mage huno havisiana ‘Kava kanoꞋnia menia hivi huno omegahie.’ nehuno agaiꞋa aliꞋyate kava yagai-mainesia vegi munaꞋnegi nehamaeno ala kanomo kavela tina neno havilina neno aneginagi nehuno ‘Omegahie.’ huno hisia yupaene kanaꞋaene kava kanoa egahie. EnunoꞋa ani havi kavaꞋma humainea kanomona kaꞋyo kevia ami-maleteno alino haviya huteteno mage hugahie nagaiꞋma veganokano hunenataya veaꞋnene umaiyo huno hutegahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nago aliꞋya kanomoꞋa agaiꞋa ala kava kanomona haiya kavafena ago havitenoꞋagi kava kanomona haiya kavala ohuno talo talaꞋma ohunesiana ala kava kanomoꞋa agaila alakefa huno haegahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Haegahigi nago aliꞋya kanomoꞋa ala kanomona haiya kavafema ohavino havi kavaꞋma maino nehisigenoꞋa ala kava kanomoꞋa ako huno haegahie. MukiꞋa yama ali-mainaya veafena ‘AnonaꞋa etetama mukiꞋa yaniꞋa namiho.’ huno hugahie. MukiꞋa yamaꞋa amamigeꞋya ali-mainesaya veafena ‘AnonaꞋa aꞋva monene etetama menamiho.’ huno hugahie.” ");
INSERT INTO kmu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","YisasiꞋa mage huno hie “Nagaya ma mopafi ata kaesugeno tesia yafe emainoe. Ani atamoꞋa aupaꞋa tesie huꞋna nagu nagesa nehavue. ");
INSERT INTO kmu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nahaesagenofena nagaila tusiꞋa nagata aigahie. AupaꞋa huꞋya onahaesaya yafe nagu nagesa havua nagesamoꞋa hivi huno talavaꞋnote. ");
INSERT INTO kmu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tamakaya na tamakesa nehaviye? ‘Ma mopale taipa falu huta maisuna yana tamigahe YisasiꞋa emaine.’ hutama nehafi? AꞋao nagaya tamakaila ali fako hisua yafe emainoe. ");
INSERT INTO kmu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Meni kanafina aepa heꞋya faefuꞋa (5) afamola nagoke nopi nemaisaletila tolemogania (2) taliꞋamogamina (3) kame humategaꞋe. TaliꞋamoꞋya (3) tolemoganina (2) kame hunategahae. ");
INSERT INTO kmu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mago afamotalamogania nefaꞋa agaiꞋa nafaꞋnemona kame hutesigeno nafaꞋneꞋamoꞋa agaiꞋa nefana kamea hutegahie. Nago tayametalamogania itaꞋamoꞋa munaꞋamona kame hutenageno munaꞋamoꞋa itaꞋamona kamea hutegahie. Vemona itaꞋamoꞋa anofeloꞋamona kame hutenageno anofeloꞋamoꞋa aniꞋa huno nevena itaꞋamona kamea hutegahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Alitalu humainaya veaꞋmogamifena mage hie “Tamakaya yagemoꞋma tavi nefalelegati siaꞋmoꞋma evaꞋyi higetamahena aupaꞋa mage nehae ‘Ko aigahe nehie.’ hutama nehageno ani yana tamage huno falote nehie. ");
INSERT INTO kmu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Oko ikama agetetama ‘AmukoꞋage hugahe nehie.’ hutama nehageno ani yana tamage huno falote nehie. ");
INSERT INTO kmu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","TamakuꞋafina havitama omaletama amegati kea nehaya vagala veala tamakaya mopale yaꞋene ikate yaꞋene agelama hutama neꞋagayanagi naꞋa higetama meni kanafima falote hia kavala agelama hutama noꞋagae?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“NaꞋa higetama fatago kavafena tamakaitamia tamakesa havilama hutama nohaviye? ");
INSERT INTO kmu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nago kanomoꞋma ‘Haviya hunatanageꞋna kaiyeke hugategahe nehue.’ hunoꞋma kavaleno vinagetana kaiyekema havi kanomoteꞋma ugahema neꞋutana ‘Nenafuga kaipa falu hisia yana kamigahue.’ huka hapaiyo. AniꞋa ohisanana kavaleno kaiyekema hugatesia kanomote vinageno ani kea haviteno ati vayaꞋmogami ayapi katesigeno kavaleno nofila hugategahie. ");
INSERT INTO kmu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nofi hugatesigekahena kaiyekema hugatenea kanomoꞋma ‘Mone namio.’ huno hu-mainesia yamaꞋa oꞋaminukahena nofi nopitila ataleka omegane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ani yupa nagoꞋa vayala Kalili vayafe Yisasina kea hapaigahe eꞋya mage hae “Ani Kalili vayaꞋmoꞋya Anumaya Koti muse yama amigahena sipi sipi nehageno PailatiꞋa, kava kanomoꞋa, ati vaya humategeꞋya me hamayageꞋya faligeno kolaꞋamiene sipi sipi afuma haya kolaꞋamoꞋene nagopi tavi-maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hageno YisasiꞋa mage huno hie “Kalili vayaꞋma fali-mainaya vayaꞋmogami kefo yaꞋamia nagoꞋa Kalili vayaꞋmogami kefo yaꞋamimona ago amakaseno hai-mainea yafe fali-mainae hutama tamakesa nehavio? ");
INSERT INTO kmu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tamahapauve ani vayaꞋyaga kefo yaꞋamia ala huno otamakaseneanagi tamakaya kefo yatamihena tamakuꞋa aiyahae ohisayana aniꞋa hutama faligahae. ");
INSERT INTO kmu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nago yupa Siloamu kumate ayaꞋaya nona tagape ailavino eitiniꞋa (18) vaya hamaegeꞋya fali-mainaya kea havilinao? Na tamakesa nehaviye ani vayaꞋmogami kefo yaꞋamimoꞋa nagoꞋa Yelusalemu mainaya veaꞋmogami kefo yaꞋami ago amakaseno hai-maineafe fali-mainae hutama tamakesa nehavio? ");
INSERT INTO kmu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tamahanepauve anima fali-mainaya vayala kefo yaꞋamimoꞋa ala huno otamakasenegi tamakaya kefo yatamihena tamakuꞋa aiyahae ohisayana aniꞋa hutama faligahae.” ");
INSERT INTO kmu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","YisasiꞋa nago avame kea huno mage hie “Nago kanomoꞋa hoyaꞋafina figi yosa hane. Nago yupa alagaꞋa tagigahe vianagi alagaꞋa omale. ");
INSERT INTO kmu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Omalegeno hoyafi aliꞋya neꞋalia kanomofe mage huno hie ‘Havio nagaya taliꞋa (3) kafu alaga aligahe ete ete huanagi alaga omalene. OꞋayeneafe ani yosa atagi-talo. NaꞋa higeno mopamona limaꞋa afaꞋa nenegeꞋna alu yosa faisue huꞋna nehue.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Higeno hoyafi aliꞋya kanomoꞋa mage hie ‘MusekaꞋa nehugi ma kafuene atalegeꞋna hafuꞋyafina aipopoꞋma huꞋna afumo aifa kateꞋna maleꞋna agano. ");
INSERT INTO kmu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Malesugeno nago kafuleꞋma alagaꞋa ayesio? OꞋayesigeka afaꞋa atagi-talegane.’ huno humaine.” ");
INSERT INTO kmu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nago Sapati yupa YisasiꞋa nago mono nopi maineno humavenelie. ");
INSERT INTO kmu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Humaveneligeno nagola kali neꞋalia alagino ani nopina maine. Ani aꞋmona aguꞋafina Kefo Avamula hai fale-maineno tusiꞋa kali neꞋamigeno eitiniꞋa (18) kafu ani kalia ali-maineanagino akaveꞋya ayamufamoꞋa fagagigeno hetino fatago huno nomaiyane. ");
INSERT INTO kmu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","YisasiꞋa ageteno ke huno mage huno hie “Ma aꞋmogae kalikaꞋa ago ali neꞋataloe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nehuno ani aꞋmo augafale aya malegeno anile aupaꞋa akaveꞋya aifatago higeno hetino maineno Anumaya Koti agia alisaga humaine. ");
INSERT INTO kmu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nehigeno ani mono nopi soka kanomoꞋa YisasiꞋma Sapati kanaleꞋma hutea yafena aipa kafa heteteno mukiꞋa veafe mage huno hamapaiye “AliꞋya kana sikisiꞋa (6) kana hanegi kalitima alino kanale hisie hinutamahena ani aliꞋya kanale eho. Sapati kana kalitami alilino kanale hulamatesia yafena omeho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Higeno AnumayamoꞋa kenonaꞋa mage huno hie “Tamakaya tamakuꞋafina havi omaletama amegati ke nehaya vagala vayaꞋmogatama tamakaya mukiꞋamogatama Sapati yupa toki afuene pulamakatamiene noꞋamifina mo kalu hetama ti amigahena amavaletama neꞋvayane. ");
INSERT INTO kmu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","NaꞋa nehayanagi ma aꞋmona Apalahamu aginagomona SataniꞋa eitiniꞋa (18) kafu nofi hutegeno kalia ali-maineafe Sapati yupa ani yana ali kalu hetaloa yafe ‘Havi kava hane.’ hutama nehao?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","HigeꞋya kame vayaꞋamoꞋya tusiꞋa amakaye higeꞋya mukiꞋa veaꞋmoꞋya kanale kava hia yafe tusiꞋa muse humainae. ");
INSERT INTO kmu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","YisasiꞋa mage huno hie “Anumaya KotiꞋma kava yagaisia kavaꞋmoꞋa ma kava humaine? HanaꞋa huꞋna maꞋa augafa yana hane huꞋna tamahapaisue? ");
INSERT INTO kmu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ma osi osi alagamoꞋma hia avamete nehie. Ani alagamo agia masatatie. Osi osi alagama nago kanomoꞋa alino hoyafima fai-malegeno hageteno haino haino ala yosagefa hanegeꞋya namayagamoꞋya akopale noꞋamia ki-mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","NagoꞋene mage huno hie “Anumaya KotiꞋma kava yagaisia kavafena hanaꞋa huꞋna maꞋa yana hane huꞋna tamahapaisue? ");
INSERT INTO kmu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kaihamema hale negia avamete humaine. Nago aꞋmoꞋa ani kaihamema halegisia yana alino taliꞋa (3) ala yopafi taꞋnefa falauvaꞋene ali havigu higeno haenagaꞋa mukiꞋa taꞋnefa falauvaꞋmoꞋa halegi-maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","YisasiꞋa Yelusalemu ugahe osiꞋosi kumaꞋyagaleꞋene ala kumaꞋyagaleꞋene uno humavelie. ");
INSERT INTO kmu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Humaveneligeno nago kanomoꞋa mage huno havige “Anumayamogae Anumaya KotiꞋa naꞋmagi veaꞋne amaku amamena aligatigahie? OsiꞋa veaꞋnefi kasagoꞋya veaꞋne?” huno higeno YisasiꞋa alitalu humainaya veaꞋmogamina mage huno hamapaiye “Anumaya Koti kumateꞋma visaya fiana osi fia kanoꞋa hane. Ani fiapima vinutamahena tamayamufa alitama tokiyaꞋage hutetama hai falegahae. Hai falegahagi kasagoꞋya veaꞋmoꞋya ‘Hai falesune.’ huꞋya hugahayanagi amukoꞋamia omaleneanagiꞋya hai ofalegahae. ");
INSERT INTO kmu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","HaenagaꞋa ani noteꞋma kava yagai-mainea kanomoꞋa hetino fita alino kilamatesigetama fiate heti-mainetama fitale aiko nelitama mage hutama hugahae ‘Anumayamogae fita yakilato.’ hutama hisagenoꞋa mage hugahie ‘Nagaya otamakenoane. Tamakaya hanategati aya veaꞋne neꞋae?’ huno hulamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hulamatesigetama mage hutama hugahae ‘KagaiꞋene kavela nenonane. Tagai kumate kaiyekea tahapai-mainana kano mainane.’ hutama hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hugahayanagi mage huno hulamategahie ‘Ago tamahanepauve tamakaila otamakenoane. Hanategati aya veaꞋne neꞋae? Kefo kavakeꞋya ali falote hutama nehaya vealagi nagaitegatila mai-haletama viho.’ huno hulamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tamakaya mogesayana ApalahamuꞋene AisakiꞋene YekopuꞋene Anumaya Koti amaune vayaꞋene Anumaya Koti kumatela mainesagetama mogegahayanagi tamakaya anilela oꞋugahayanagitama malaga mainetama tusiya hutama avia neꞋatetama tamakaitami tamaugafahena tusiꞋa kalagi aigahae. ");
INSERT INTO kmu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nagi mukiꞋa veaꞋmoꞋya yagemoꞋma tavi nefalelegatiꞋene evaꞋyi nehilegatiꞋene aluga aluga haupalegatiꞋene Anumaya Koti kumate melitalu huꞋya siale maineꞋya kavela negahae. ");
INSERT INTO kmu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Haviho meni kanafina nagoꞋa veaꞋmoꞋya haenagalafa mainaya veaꞋmoꞋya uhagoteꞋya maigahae. HagoteꞋya mainaya veaꞋmoꞋya haenagalafa maigahae.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","HigeꞋya ani kanafina nagoꞋa Falasia vayaꞋmoꞋya mage me hae “Ma kumala ataleka alu kumate vuo. HelotiꞋa ala kava kanomoꞋa ago kahaegahe nehie.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hageno YisasiꞋa mage hie “Tamakaya utama ani afai kalamona, kesi kate vaiyatete nehia kalamona, nagayama hisua kea mage hutama hapaiho ‘Havio nagaya osi kanaꞋa Kefo Avamula veaꞋmogami amakuꞋafiti ali-taleteꞋna kali veaꞋnene aliꞋna kanale humateteꞋna taliꞋa (3) kanale aliꞋyaniꞋa ali avaya ayegahue.’ huꞋna tamahapai-mainoa kea mo hapaiho.” huno hamapaiye ");
INSERT INTO kmu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hamapaiteno “Anumaya Koti aune kanomona alu kumatela ohaegahayanagiꞋya Yelusalemuge haegahae. Ani yafe nagaya meniene egaene olagaene kate vaiyegahue. ");
INSERT INTO kmu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Vaeha Yelusalemu mainaya veaꞋmogatama tamakaya Anumaya Koti amaune vayaꞋyaga nehamaetama yafa kaꞋyo alitama Anumaya Koti humategeꞋya tamakaitega emainaya vayala yafa kaꞋyoteti tavata hamae-mainayanagi nagaya mukiꞋa yupa a kokolemoꞋa nafaꞋneꞋama agekoꞋnafinagama alitalu nehia avamete huꞋna tamakaila nagaya nagaiꞋniꞋale alitalu hulamategahe nehugetama tamakaya ‘Ani kavala ohuo.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haviho ma mainaya kumatefena Anumaya KotiꞋa ago ataleno ‘AoteꞋyamaꞋae.’ huno humaineanagitama menia nagoꞋene onagegahagi ‘Anumayamo aliꞋya aligahe higeno hutenea kanoa Anumaya Koti kanale manu amisie.’ huꞋya hisaya kanafi nagoꞋene nagegahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nago Sapati yupa YisasiꞋa Falasia vayate kava humainea kanomo nopi kave mo nenegeꞋya nagoꞋa Falasia vayaꞋmoꞋya Yisasina ageꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mainageno nagola augafa halegimai kanoa, faligahe nehia kanoa, anile maine. ");
INSERT INTO kmu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mainegeno YisasiꞋa ani kanoa ageteno ani nopi mainaya Falasia vayaꞋene kahegi kema havilinaya vayaꞋene mage huno hamavige “Sapati kanafina kaliꞋamia alino kanale hutesia yana kanale yapi havi yane? Tamakai mono kemoꞋa naꞋane nehie?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","HamavigegeꞋya ani vayaꞋmoꞋya nagola osi ke kanoꞋa ohuꞋya afaꞋa mainageno YisasiꞋa ani kali kanoa atafa hulineno kaliꞋa alino kanale huteteno atalegeno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vigeno YisasiꞋa mage huno hamavige “Hana kanomoga Sapati kanafima nafaꞋnekafi pulumakafi komufima tavi-mainesigetama ‘Sapati yupae.’ hutama anifinaga atalesafi ifi aupaꞋa amavayu hugahae?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","HamavigegeꞋya mukiꞋa vayaꞋmoya kenonaꞋa kea ohuꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","“KaveꞋma me neho.” huno ke higeꞋya emainaya vayaꞋmoꞋya “Ala kanomo nemaiya siale emaisune.” huꞋyama nehaya kavala YisasiꞋa ageteno ani kavaꞋma nehaya yafena mage huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Nago kanomoꞋa kagaifema ‘Ala imuleꞋma eno.’ huno kema hinageka vinukahena ala kanomo nemaiya sialela uomaiyo. Havigu anile mainesanageno nago kanoa kagaseno mainesia ala kanomofe ke hinagenoꞋma emainesigeno kava kanomoꞋa kagaifena mage me hugahie ‘He-tio. Ala kanomo sialelagi kagaya omaiyo.’ huno hugatesigeka kagaye nehinageka akavelaga mo maigane. ");
INSERT INTO kmu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nago kanomoꞋma kagaifema ‘Ala kave meno.’ huno kema hinageka vinukahena osi kanomo mainesile mo maiyo. Mopale mainesanageno kagaifema ke humainesia kanomoꞋa megagesiana hinagenoꞋa mage huno hugahie ‘Nenafugae malela omaika neꞋataleka ala kanomo siale haisaga humaika maiyo.’ huno hugategahie. Ani kema hisigeꞋya mukiꞋa anile mainesaya veaꞋmoꞋya kagai kagi alisaga hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","NagoꞋa veaꞋmoꞋya ‘Ala vaya mainonanagita tagia alisaga hugahune.’ huꞋya hisagenoꞋa Anumaya KotiꞋa ‘Afa vaya mainae.’ huno humategahigi nagoꞋa veaꞋmoꞋya ‘Tagia omale veaꞋne mainone.’ huꞋya hisagenoꞋa Anumaya KotiꞋa ani veaꞋmogami amakia alisaga hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","“Kavela me neho.” huno ke humainea kanomofe YisasiꞋa mage huno hie “Ala imuma kigahena mukiꞋa kameta negafuꞋene kafukaganaꞋene kagaika nofi vayaꞋene moneꞋamima hanesia veaꞋneheke ‘Kave me nesae.’ huka kea hu oꞋamato. HaenagaꞋa kagaife ‘Kave meno.’ huꞋya hisagekama mo nesanana anonakaꞋa hai ali-mainane. ");
INSERT INTO kmu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","Hai ali-mainanagi ala imuma kigahena maꞋa veafe kea huo moneꞋamima omale veaꞋnegi amaugafa haviya humai veaꞋnegi amaiya haviya humai veaꞋnegi amaulaga asu humai veaꞋnegi huka ke hisanageno Anumaya KotiꞋa muse yana kamigahie. Ani veaꞋmoꞋya anonaꞋa kavekale kamisaya amakula omalenea yafe kagaya muse hisanageno fatago humainaya veaꞋnema fali-mainesafiti hetisaya kanafina Anumaya KotiꞋa agaiꞋa anonakaꞋa kamisigeka muse hugane.” ");
INSERT INTO kmu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nago kanomoꞋa YisasiꞋene maineno kave neneno Yisasi kea haviteno mage hie “NagoꞋa veaꞋmoꞋya Anumaya Koti kava yagaisia kumate haiꞋya maineꞋya kavela neneꞋya tusiꞋa muse hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Higeno YisasiꞋa mage huno hapaiye “Nago kanomoꞋa ala imu kigahe mukiꞋa veaꞋneyaga ‘Meneho.’ huno ke humaine. ");
INSERT INTO kmu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ke humateteno imua ago kimaleteno aliꞋya kanoꞋamona hutegeno viaꞋyamo kema humatenea veaꞋnehe ‘Tamakaya eho. MukiꞋa nesaya yana ago talo tala humalene.’ huno hamapai-maine. ");
INSERT INTO kmu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","HamapaigeꞋya ani mukiꞋa veala nagoke nagokeꞋmoꞋya mage hae ‘Tagaya oꞋugahune.’ huꞋya hae. Hageno nagoke kanomoꞋa mage hie ‘Nagola hoya yaufa miya humalenoanagiꞋna mogegahe nehue. Museka nehugi nagaya oꞋugahue.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Higeno nago kanomoꞋa mage hie ‘Nagaya teniꞋa (10) aliꞋya alisia pulumaka miya humaleneꞋna nehuanagiꞋna kanale aliꞋya neꞋalifi agegahe neꞋue. Museka nehugi nagaya oꞋugahue.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Higeno nago kanomoꞋa mage huno hie ‘Menia nagaya yaufa aꞋniꞋa alitenoanagiꞋna museka nehugi nagaya oꞋugahue.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nage hageno eteno ani aliꞋya kanomoꞋa kava kanomona mo hapaigeno ani kava kanomona aipamoꞋa haviya higeno aliꞋya kanoꞋamofe mage huno hapaiye ‘Kagaya aupaꞋa eteka uka kumate mainaya veaꞋnegi moneꞋamiꞋa omale veaꞋnegi aiya haviya humai veaꞋnegi aulaga asu humai veaꞋnegi aumiꞋya haviya humai veaꞋnegi amavaleka eno.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Higeno ani aliꞋya kanomoꞋa ani kava huteno eteno mage huno kava kanomona me hapaiye ‘Kagai kavaya ali hipoꞋya huanagi nagoꞋa siale maisaya yana afaꞋa hanegeno nokaꞋafina hiyala ohune.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Higeno ala kanomoꞋa aliꞋya kanoꞋahena mage huno hapaiye ‘Kagaya kumala neꞋataleka ala katega neꞋuka tala agegayalega nemaiya veaꞋnea ke huka amavayu huka amavaleka noniꞋafina memategeꞋya hiya hiho. ");
INSERT INTO kmu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nagaya kahanepauve hagoteꞋna kema nehugeꞋyama omenaya veaꞋnea mukiꞋamoꞋya menia kavela meliꞋya onegahae.’ huno hie.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","KasagoꞋya veaꞋmoꞋya YisasiꞋene neꞋvageno maiyahae huno hamapaiye “NagoꞋa veaꞋmoꞋya nagai nakaveꞋma egahena nefaꞋene itaꞋamoꞋene aꞋamoꞋene nafaꞋneꞋamoꞋene nepuꞋamoꞋene asaꞋamoꞋene aganaꞋamofeꞋenena ‘Afa vaya mainagi YisasiꞋa tamakase-mainea yafe naguꞋa aminoa kano mainoe.’ huno ohisia kanomoꞋa nagai kea havino akave omale kano maine. ");
INSERT INTO kmu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘KanaleꞋya huꞋna maisua nahaimula afa ya hanegi YisasiꞋa agasemai kanogiꞋna naguꞋa aminoe.’ huno ohisia kanomoꞋa nagai kea havino aꞋkave omale kano maine. ");
INSERT INTO kmu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nagaila nagatama aisigeꞋna falisua yafema nago kanomoꞋa ‘Ani kava hugahue.’ huno agaiꞋa yafaga yosa kofino nakave visia agesa ohavisia kanomoꞋa nagai kea havino aꞋkave omale kano maine. ");
INSERT INTO kmu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tamakaipiti nago kanomoga ‘Ala nokefa kigahue.’ kagesa havinukahena hagoteka ‘Ani noniꞋa kiꞋna avaya ayesua moneꞋnia hanefi?’ huka kagesa havi havi hugane. ‘MukiꞋa kisua monea hane.’ huteka ani nona aepa heka kigane. ");
INSERT INTO kmu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Hagotekama naꞋa ohinuka aepa heka amalagu aiteka posia ayesanageno monekaꞋa haꞋno hisigeka ani no kika avaya ayesana amukoka omalesigeꞋya mukiꞋa agesaya veaꞋmoꞋya kigika hugateꞋya ‘Ma kanomoꞋa nona aepa heno kianagi ani nona hivi huno ki haꞋno hisia amukoꞋa omalene.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nagi nagola sauve kanomoꞋa ‘Nago sauve kanoenema aepa heꞋna tu hugahue.’ huno agesama havinunofena hagoteno mage huno agesa havisie ‘Nagaya teni tauseniꞋa (10,000) ati vayaꞋnia mainagi nago sauve kanomoꞋa tueti tauseniꞋa (20,000) ati vayaꞋa mainayanagiꞋna tuma hisua himamuꞋnia haneo?’ huno agesa havigahie. ");
INSERT INTO kmu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Agesa haviteno ‘AꞋao tuma hisua himamuꞋnia omalene.’ hunoꞋma hinunofena agaiꞋene tuma hisaya vayaꞋmoꞋya ayaꞋayate mainesageno nagoꞋa vayala humateno mage huno hugahie ‘Mage hutama mo havigeho ‘HanaꞋa hutaꞋa taꞋaipa ali falu hutaꞋa maisuꞋe.’ hutama mo havigeho.’ huno hamapaisigeꞋya mo havigegahae. ");
INSERT INTO kmu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mo havigegahagi tamakaipitila nagoꞋa veaꞋmoꞋya mukiꞋa yaꞋamima amakaveꞋno hu oꞋatesayana nagai kea ohavi veaꞋne maigahae.” ");
INSERT INTO kmu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tamakaya havilinae solea kanale ya haneanagi hagama nehia yamaꞋa haꞋnoma hisigetama hanaꞋa hutama hagama nehia yamaꞋa ali falote hugahae? ");
INSERT INTO kmu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hagama nehia yamaꞋa omalesiana afa ya hanegi afumo aifaene aliꞋya ituyaꞋene hoyafi malesayana afovaꞋage ohugahigi veaꞋmoꞋya afaꞋa hagaꞋyu hutalegahae. Tamakesama hanesiana havilama hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vaya amaugafaleti takisi mone huhatiꞋya aliliteꞋya huꞋya musufayama nehaya vayaꞋene kefo yama hume hume nehaiya veaꞋnene Yisasi ke havigahe avate emainae. ");
INSERT INTO kmu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","EmainageꞋya Falasia vayaꞋmoꞋyaene kahegi kema havilinaya anagaꞋmoꞋyaene ageteꞋya mage huꞋya ke vaimainae “Ma kanomoꞋa kefo ya nehaya vayaꞋene tokaeno maineno kavela nene.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Nehageno YisasiꞋa avame kea mage huno hamapaiye “Hana kanomoga tamakaipitila vani hataletiꞋa (100) afua mainefiti nagola fanane higeno ani afumona nefaꞋa mukiꞋa afuꞋa talapinaga amataleno viaꞋyamo nagokeꞋma fanane humainea afuꞋahe atiyeno yeno ageno ali falote hisifi? E, fananema hisigeno aniꞋa huno ati ayegahae. ");
INSERT INTO kmu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Atiyeno agefalote huteno tusiꞋa muse huno ageꞋyafi aigagino avaleno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kumate uvaꞋyi huteno vayaꞋahe ke higeꞋya melitalu hageno mage hie ‘Fananema humainea afua ago agefalote huafe tamakaiꞋene nagaiꞋene muse hisune.’ huno humaine.” ");
INSERT INTO kmu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","YisasiꞋa hufalote huno mage hie “Ani kava huno mukiꞋa vani hataletiꞋa (100) veaꞋmoꞋya kefo yafe amakuꞋa aiyahae huꞋya fatago kava nehaya veafena Anumaya KotiꞋa muse hugahianagi nagoke kanomoꞋa kefo yama hume hume nehaisiletiꞋma ‘Kefo yaniꞋa ataleꞋna nagaye higeꞋna aigagiꞋna Anumaya Kotitega eteꞋna naguꞋa amigahue.’ hunoꞋma hisigenofena Anumaya KotiꞋa tusiꞋa muse hutegahie.” ");
INSERT INTO kmu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nago aꞋmoꞋa teni (10) kina malenefiti nagola fanane higeno lamua hanagaliteno nomaꞋafina halafi huno atiyeno yeno ali falote humaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ali falote huteno vayaꞋahe ke higeꞋya melitalu hageno mage hie “TamakaiꞋene nagaiꞋene muse hisune. MoneꞋnima fanane humainea monea ago atiyeꞋna yeꞋna ali falote hue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","YisasiꞋa hufalote huno mage hie “Nagaya tamahanepauve ani kava huꞋya Anumaya Kotina ensole vayaꞋamoꞋya nagoke kanomoꞋma kefo yama hume hume nehaisiletiꞋma ‘Kefo yaniꞋahena nagaye higeꞋna aigagiꞋna Anumaya Kotitega eteꞋna naguꞋa neꞋamue.’ hunoꞋma hisigenofena ensole anagaꞋmoꞋya tusiꞋa muse hutegahae.” ");
INSERT INTO kmu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","YisasiꞋa amakaifena mage huno hie nago kanomoꞋa nafaꞋnelatamaꞋa tole mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","MainaꞋanagino haenaga nafaꞋnemoꞋa nefafe mage huno hapaiye “Nenafagae falisanana nagai ya hapaegahie huka hunatenana yana ago namio.” huno higeno nefaꞋa mukiꞋa yamaꞋa alino fako huno tole nafaꞋnelatamaꞋamokani anamine. ");
INSERT INTO kmu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Anamitegeno haenaga nafaꞋneꞋamoꞋa osi kana kanoꞋa maiteno mukiꞋa mone afenoꞋyamaꞋa alino ayaꞋaya kotega umaineno hu osuꞋyate mone afenomaꞋa motale metale huno age haꞋye hu yateꞋene mone afenomaꞋa mukiꞋa atale haꞋno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","MukiꞋa yamaꞋa haꞋno higeno ani kumatega ala kafu haya kanamoꞋa falote higeno nagoꞋa nesia yana omalegeno tusiꞋa agatemaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Agategeno nagola ani kumate kanomotega viaꞋyamo “AliꞋyakaꞋa alisue.” huno havigegeno “E.” huteno talapinaga hutegeno viaꞋyamo afuꞋale kava yagaino maineno kaveꞋamia amamine. ");
INSERT INTO kmu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","NeꞋamamino mage hie “Vae nesua kavela omaleanagiꞋna afumo kavepiti haletiꞋnaꞋa nesue.” huno humaine. Hianagi nago kanomoꞋa nesia yana oꞋamine. ");
INSERT INTO kmu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","OꞋamigeno agesamoꞋa hao higeno agesafinaga mage huno hie “MukiꞋa nenafa aliꞋya veaꞋmoꞋya amamu hia no maineꞋya kasagoꞋya kavela nenageꞋna nagaya nagala legeꞋna maꞋa huꞋna falisua kavala nehue. ");
INSERT INTO kmu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nehuafe hetiꞋna nenafatega uꞋna mage huꞋna hapaigahue ‘Nenafagae nagaya kefo ya hugatenoe. KagaiꞋene Anumaya KotiꞋene kefo ya hulanatoe. ");
INSERT INTO kmu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nagaila natenana nafaꞋnekamoꞋnae huꞋna hisuana onategahianagiꞋna musekaꞋa nehugi aliꞋya kanokaꞋa maisua yafe navalo.’ huꞋna hugahue.” huno agesa havimaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Haviteno nefatega neꞋeno aluꞋale neꞋegeno nefaꞋa ageteno kalagi aino aiyayeno monukino atako humaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Atako nehigeno nafaꞋneꞋamoꞋa agaifena mage huno hie “Nenafagae nagaya kefo ya hugatoe. KagaiꞋene Anumaya KotiꞋene kefo ya hulanatoe. Nagaya natenana nafaꞋnekamoꞋnae huꞋna hisuana onategahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Higeno nefaꞋa aliꞋya veaꞋamofena mage huno hie “AupaꞋa utama kanaleꞋyama humainea kukena alitama me vaiteho. Ayapi vaisia kihana vaitetama aiya noꞋene vaiteho. ");
INSERT INTO kmu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ala pulumaka afovaꞋageꞋma humainesia afua hetama kisageta neneta musekase hutesune. ");
INSERT INTO kmu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ma ma mainea nafaꞋneꞋnimoꞋa fali-mainefiti hetia yafeꞋene fananema hu-mainefiti efalote hia yafeꞋene musena hutesune.” huno higeꞋya aepa heꞋya tusi muse hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","HuneꞋatageno yage nafaꞋneꞋamoꞋa hoyafinagati eno note evaꞋyi nehuno haviana yagame haya yaꞋene amo ayaya kene me haviteno aliꞋya kanomofena ke higeno egeno mage huno havige “Na kava nehae?” huno havigemaine. ");
INSERT INTO kmu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Havigegeno mage hie “KaganakamoꞋa ago emaine. AugafamoꞋa kanaleꞋya higeno ea yafe negafaꞋa afovaꞋage afua hegeꞋya neneꞋya hafali ateꞋya mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","29","Higeno nepuꞋamoꞋa aipa haviya higeno “Nagaya nopinaga ohaigahue.” huno higeno nefaꞋa nopinagati eno mage hie “MusekaꞋa nehugi ehaiyo.” huno tutu higeno nefafe mage huno hapaiye “Havio nagaya kasagoꞋya kafua kagai aliꞋya alige-lige huꞋna kekaꞋa nago kanafina ‘AꞋao.’ huꞋna ohunuanagika vayaꞋniꞋamogamiꞋene muse hisuna yana nagoke meme ataꞋauꞋa heka onamitafa hu-mainanane. ");
INSERT INTO kmu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Onaminana yana ma nafaꞋnekamoꞋa mone fenoꞋyagakaꞋa alino kumai aꞋnele momi memi higeno monekaꞋa haꞋno higeno emainegeka afovaꞋage afua heka musekase huneꞋatane.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","Higeno nefaꞋa mage huno hie “NafaꞋneꞋnimogae mukiꞋa kanafina nagaiꞋene nemainanagino mukiꞋa yaniꞋa kagai ya hanegi kaganakamoꞋa falino fanane humainefiti evaꞋyi hianagita muse huta taipamoꞋa kanale hinageta maisunana ani yamoꞋa kanale hulatesie.” huno hapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","YisasiꞋa agaiꞋaene tokaeꞋya nemaiya anagafe mage huno hamapaiye nagola tusiꞋa moneꞋa hanea kanomoꞋa ani afenomaꞋale kava nehea aliꞋya kanoꞋamoꞋa mainegeꞋya nagoꞋa vayala ayaꞋamoꞋya ani aliꞋya kanomofe akavelaga ke huꞋya mage hae “Kagai aliꞋyate kava kanomoꞋa mukiꞋa yakaꞋa alino motale metale humaine” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hageno moneꞋama hanea kanomoꞋa kava nehea aliꞋya kanoꞋamofena ke higeno egeno mage hie “NaꞋane huꞋya kagaifena nahanepaiye? Kagaila kava hisana tokiya ago kaminoafe kagaya hanaꞋa huka kava humainane? Huyogiteka menahapaiyo. NagoꞋene kagaya mani aliꞋyana oꞋaligane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Higeno ani aliꞋya kanomona agu agesamoꞋa mage hie “AliꞋyaniꞋa nahafalegahe higi hanaꞋa hisue? Hoya aliꞋya alisua tokiyaꞋnia omaleneanagiꞋna aukaꞋya hisugenoꞋa nagaye hugahianagiꞋna hanaꞋa hisue? ");
INSERT INTO kmu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hisua yafena menia nagesa havue. Ani kava humatesugeno aliꞋyaniꞋama nahafalesigeꞋya anonaꞋa ani vayaꞋmoꞋya ‘Notifi emaiyo.’ huꞋya hugahae.” huno havimaine. ");
INSERT INTO kmu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","NagoꞋa ala kanoꞋamoteti nofi humainaya veafe amahaote amahaote ke higeꞋya ageno hagote kanomofena mage huno havige “Nagai kava kanomoꞋa naꞋmagi ya nofila hugatene?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Havigegeno mage hie “Nagaya vani hataletiꞋa (100) kalasini talamu nofila huanagi anonaꞋa oꞋaminoe.” huno higeno aliꞋya kanoꞋamoꞋa mage hie “Anima kae-malenea autaꞋma ma hanegi ani vani hataletie (100) huno hanea avona ayehananeka fifitiꞋae (50) huka kao.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nago kanomofena mage hie “NofiꞋma humainana yana naꞋmagi ali-mainane?” huno higeno “Vani hataletiꞋa (100) alaisi kula nofi huanagi anonaꞋa oꞋaminoe.” huno higeno aliꞋya kanoꞋamoꞋa mage hie “Anima kae-malenea autaꞋma ma hanegi ani vani hataletia (100) ayehananeka eitiꞋae (80) huka kao.” huno humaine. Ani kavaꞋma hia yamoꞋa ma agesa havie “HaenagaꞋa aliyaniꞋama nahafalesigeꞋya ani vayaꞋmoꞋya mage hugahae ‘Notifi emaiyo.’ huꞋya hisayafenagiꞋna naꞋa kava hugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ani musufaꞋage aliꞋya kanomoꞋa agesa havi havi huno ani kava humainea yafe ala moneꞋama hanea kanomoꞋa mage hie “Kanale kagu kagesa hane.” huno humainegeno YisasiꞋa mage huno hie “Ma mopale yafema muse nehaya veaꞋmoꞋya mone alisaya yafe amakesa havi havi huteꞋya aliyama aliyana hale yapi mainaya veala ago amakaseꞋya amakesaene veaꞋne mainae. ");
INSERT INTO kmu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nagaya tamakaitamige tamahanepauve tamakaya ma mopale monea alitama veaꞋmogami amamisageꞋya nelamafuꞋya maisagetama falisaya yupa ani monea haꞋno hisigeno Anumaya KotiꞋa maige maige hisaya nopina tamavaleno ali falu fala hulamategahie. ");
INSERT INTO kmu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","NagoꞋa veaꞋmoꞋya osi osi yate kanaleꞋya huꞋya yagaisayana ala yakefalela aniꞋa huꞋya kanaleꞋya huꞋya yagaigahayanagi nagoꞋa veaꞋmoꞋya osi osi yateꞋma kanaleꞋya huꞋya oꞋyagaisayana ala yakefalela aniꞋa huꞋya kanaleꞋya huꞋya oꞋyagaigahae. ");
INSERT INTO kmu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tamakaya ma mopale monema kanaleꞋya hutama kava oꞋyagaisayana ikapinaga tama afenoꞋyateꞋma yagaisae huno otamamigahie. ");
INSERT INTO kmu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tamakaya alu veaꞋmogami yateꞋma kanaleꞋya hutama kavama oꞋyagaisayana tamakaitami afenona otamamigahie. ");
INSERT INTO kmu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nagoke aliꞋya kanomoꞋa ‘Tole kava kanolatamogani aliꞋya kanoꞋania maisue.’ huno ohisie. AniꞋa hisiana nagoke kava kanomofe ‘Haivaino naipa nagata aiya kano mainane.’ huno hugahianagi nago kava kanomofena ‘Nahaiya kano mainane.’ huno hugahie. Nago kava kanomona aipa amiteno nago kava kanomofe ‘Falote onahaiya kava hana kano mainane.’ huno hugahie. Tamakaya aniꞋa hutama Anumaya KotiꞋenefe ma mopale mone fenoꞋenefe ‘Ali lokaetana kava yagailateꞋo.’ hutama hisayana haviya hugahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falasia vayaꞋmoꞋya ani kea haviteꞋya mone fenofema nehamaiya yafena tusiya huꞋya kigiꞋa nehuꞋya kamuge hatageꞋya vaitenae. ");
INSERT INTO kmu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kigi hutayanagi YisasiꞋa amakaifena mage hie “Tamakaya veaꞋmogami amaulagafina ‘Fatago anaga mainone.’ hutama nehayanagi Anumaya KotiꞋa tamakupina ago agelama huno agemaine. Age-maineanagiꞋya tamakaifema veaꞋmoꞋya tamakeꞋya ‘TusiꞋa kanaleꞋnale kava nehae.’ huꞋya nehaya kavafena Anumaya Koti aulagafina hiꞋmanaꞋage hia kava nehae. ");
INSERT INTO kmu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","MukiꞋa kanafina vayaꞋmoꞋya MoseseꞋene Anumaya Koti amaune vayaꞋene humainaya kea haviyanagi YoniꞋma falote humainea kanaleti aepa heꞋna Anumaya Koti kava yagailamatesia kanale mono kea tamahapaugetama mukiꞋa veaꞋmogatama ‘ Anumaya KotiꞋa kava yagailatesie.’ hutama hugahe tamayamufa aitama tusi ya maitama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","IkaꞋene mopaene haꞋno hugahianagi Anumaya Koti kema kae-malenaya kemoꞋa nagoke kanoꞋa afa ya kanala ohugahie.” ");
INSERT INTO kmu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nago kanomoꞋma aꞋama neꞋataleno alu aꞋma alisiana kumai kava humaine. Nagi nago aꞋma anauꞋamoꞋa atalesigenoꞋma mainesia aꞋma alu kanomoꞋma alisayana aniꞋa huno kumai kava humaine. ");
INSERT INTO kmu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nago kanoa tusiꞋa moneꞋa hanea kanomoꞋa mukiꞋa kanafina kanaleꞋnale siotaꞋaene kava vayaꞋmoꞋya nehaya kava huno haesa kenaꞋaene failino maineno kanaleꞋnale kavekeꞋya neneane. ");
INSERT INTO kmu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Neneanagino no fiamaꞋalela nago kanoa afenomaꞋa omale kanomona amumoꞋa augafa alino haꞋyagi-mainea kanoa mopale nemaiyane. Ani kanomo agia LasalusiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ani kanomoꞋa agesa mage huno havimaine “AfenomaꞋa hanea kanomo nea kaveꞋmo atupa-napaꞋa yogiꞋna nesue.” huno huteno emainegeꞋya kalayagamoꞋya amutetila me haene haene humainae. ");
INSERT INTO kmu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","NaꞋa hageno maineno haenagaꞋa afenomaꞋa omale kanoa faligeꞋya ensole anagaꞋmoꞋya mevaleꞋya Apalahamu mainele motageno maine. Mainegeno moneꞋama hanea kanoa aniꞋa huno faligeꞋya aliꞋya mo hevaitenae. ");
INSERT INTO kmu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mo hevaitageno haniki-mainea kumapi umaineno augafa agata tusiya huno aigeno maineno agesaga huno anafinaga ageana amuga aluꞋafi ApalahamuꞋene LasalusiꞋene mainaꞋageno anakemaine. ");
INSERT INTO kmu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Anaketeno mage huno ke hie “Vae Apalahamuga naginagomogae kagaya tusiya huka kahauna hunato. Kahau hunateka Lasalusina hutegeno eno aya aginagoleti tipina ayeteno navefuꞋnale malesigeno tani tani nahaisie. Nagaya tusiꞋa atafi mainogeno tusiꞋa nagata neꞋaiye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hianagi ApalahamuꞋa mage huno hie “NafaꞋneꞋnimoga kagaya nayona mopaleꞋma kanaleꞋya huka mainana kanafina mukiꞋa kanaleꞋnale yakaꞋa ago ali-mainananagi LasalusiꞋa mukiꞋa havi yamaꞋage ali-maine. Ani yafe kagesamoꞋa aikalo hinageka havio. Menia LasalusiꞋa ma kumate egenoꞋa aipamoꞋa kanale huno yasi yasi higeno mainegeka kagaya kaugafa kagataenena mainane. ");
INSERT INTO kmu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nago yana tagaya mauna kaiyagaene tamakaya mainaya kaiyagaene amuꞋnotifina Anumaya KotiꞋa tusiꞋa ayo omale komugefa kafi-maleneanagiꞋya ma kumate mainaya veaꞋmoꞋya tamakaitega visaya amakesa haviꞋya usaga humaiꞋya oꞋugahae. AniꞋa huꞋya kagaiꞋene mainaya veaꞋnea esaga humaiꞋya ma kaiyaga omegahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Higeno ani kanomoꞋa mage hie “Naginagomogae nagaya tusiya huꞋna tutu hugateꞋna kalagi neꞋauve. Lasalusina hutesanageno nenafa notega visie. ");
INSERT INTO kmu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","VisigeꞋya faefuꞋa (5) naganaꞋnimoꞋya mainageꞋna nagaya tusiꞋa nagata aiya kumate emainoafe kagaya Lasalusina hutegeno visiaꞋamo ala kefiti mage huno hisie ‘Tamaipama aiyahae ohinutamahena nagayama mainoa kumatela egahae.’ huno hamapaisie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Higeno ApalahamuꞋa mage hie “Amakaya MoseseꞋa humainea kene Anumaya Koti amaune vayaꞋmogami kene hanegi ani kemona hapaliꞋya havisae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Higeno moneꞋama hanea kanomoꞋa mage hie “AꞋao, naginagomogae, Apalahamuga, nani kea ohavinayanagino nagola fali-mainea kanoma komufiti hetino amakaitega mo hamapaisigeꞋya kefo yaꞋamia ataleteꞋya amakaye huꞋya aigagiꞋya Anumaya Kotina amakuꞋa amigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Higeno ApalahamuꞋa agaifena mage hie “MoseseꞋma humainea kene Anumaya Koti amaune vayaꞋmoꞋya humainaya kene amakupima omalenesayana nagola fali-mainea kanomoꞋa komufitila hetino mo hamapaisiana ani kea haviꞋya amakupina omalegahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","YisasiꞋa agaiꞋaene tokaeꞋya nemaiya anagafe mage huno humaine kefo yama huo huno ayemavataga hisaya yana falote hugahianagi kefo yama hisaya kate tamavaleno visia kanomofena “Kefo kava nehananagika kana yana aligane.” ");
INSERT INTO kmu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ani kanomoꞋa nagoꞋa osi anagaꞋnihe “Kefo yama huo.” huno hisiana tusiꞋa kefo kava nehianagiꞋna tusiꞋa kana ya amigahue. Ala yafakefaleti ani kanomo ageꞋyafi maleꞋya nofi kiteꞋya hage lipi hagaꞋyu hutalesayana ani kana yana afa avamete kana ya haneanagi nagaya tusiꞋa kana ya amigahue. ");
INSERT INTO kmu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amigahuanagi tamakaya kaꞋye ho. NegafuꞋa kefo yama hinageka “NaꞋa kavala ohuo.” huka kemakio. Amakigeno agayama aguꞋa aiyahaeꞋma hinageka aigeꞋateka kefo yamaꞋa ataleto. ");
INSERT INTO kmu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","NegafuꞋa nagoke yupa seveniꞋa (7) kanaleꞋma kefo yama hugateteno ani kefo yafe “NaguꞋa aiyahae nehue.” huno hisigekahena kagaya aniꞋa huka seveniꞋa (7) kanale aigeꞋateka kefo yamaꞋa ataleto huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya Anumayamofe mage hae “Kagaife havita tagupi maleta tametiti nehuna yana kagaya nagoꞋene alika ayaꞋaya hulato.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hageno YisasiꞋa mage hie “Tamakaya nagaifena havitama tamakupi maletama tamametiti nehaya kavala osi masatati yosamo alaga kanoꞋa hanea avamete hutama osiꞋa havitama tamakupi malesayana ma yosahe mage hutama hapaigahae ‘Ma yosamoga kagaya aepa muki tagasi huka ala tipi hageka haiyo.’ hutama hapaisageno tamakai kea akave malegahie.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tamakaipiti nago kanoa aliꞋya neꞋalia kanoꞋamoꞋa hoya aliꞋyapi, afu kava aliꞋyapi, ani aliꞋyana alino haꞋno huno esigenoꞋa ala kanomoꞋa ani aliꞋya kanohe mage huno hapaisio “Kagaya aupaꞋa me maifalu huka maineka kavela no.” huno hapaisio? ");
INSERT INTO kmu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","AꞋao ani kea ohugahianagino mage huno hugahie “Kagaya kaveꞋnia talo tala hunateka kenakaꞋa faiteka kaveꞋnia alika me namigeꞋna hagoteꞋna netesugeka kagaya haenaga negane.” huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Anima hapaiya kema akave malenea yafena ala kanomoꞋa “Kanale kava hanafe musekaꞋa nehue.” huno hisifi? AꞋao aniꞋa ohugahie. ");
INSERT INTO kmu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tamakaya aniꞋa hutama mukiꞋa tamahapai-mainoa aliꞋyana alitama avaya ayetetama mage hutama hiho “Tagaya kanale aliꞋya anaga omainone. Tagaiti aliꞋyanagita ago alune.” hutama hiho huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","YisasiꞋa Yelusalemu ukahe viana SameliaꞋene Kaliliene amuꞋnopi katega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Nago kumate uvaꞋyi higeꞋya teniꞋa (10) fugita kali neꞋaliya vayala aluꞋale heti-maineꞋya ala kefiti mage hae “Yisasiga ala kano mainanagi tagaila kahau hulato.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hageno YisasiꞋa amaketeno mage hie “Tamakaya mono nopi kava vayate utama tamaugafa momaveliho.” huno higeꞋya ani vayatega neꞋvageno katega amaugafamoꞋa eteno kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kanale humategeꞋya vafiti nagoke kanomoꞋa augafa ageana kanale higeno eteno katega viaꞋamo ala kefiti muse huno Anumaya Koti agi alisaga humaine. ");
INSERT INTO kmu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Huteno Yisasite aiyafi mepe huno maineno aiyale alisoso nehuno “Kagaifena tusiꞋa musekaꞋa nehue.” huno hie. Aiyale alisosoma hia kanoa Sameliati kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","YisasiꞋa ani kanoa ageteno mage hie “Nagesa havuana teniꞋa (10) vaya ago aliꞋna kanale humatenofi? huꞋna huanagi nainiꞋa (9) vayala hanate mainagekae? ");
INSERT INTO kmu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","NaꞋa higeꞋya ani vayaꞋyaga Anumaya Koti agia melisaga ohae? Mani nagoke kanoa alu kotegati emainea kanomoꞋa agaiꞋage Anumaya Koti agia melisaga nehie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","YisasiꞋa ani kanomofena mage huno hapaiye “Kagaya hetika vuo. Nagaifema havika kagupi maleka kametiti hana yamo kagaila alino kanale hugate.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","NagoꞋa Falasia vayaꞋmoꞋya mage huꞋya havigae “Na kanafi Anumaya KotiꞋa aepa heno kava yagaigahie?” huꞋya hageno YisasiꞋa mage huno humaine “Anumaya KotiꞋma kava yagaisia kanama falote hisiana tamaulagamoꞋa oꞋagesia kava huno egahie. ");
INSERT INTO kmu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","VeaꞋmoꞋya ‘Malega hane. Amualega hane.’ huꞋya ohugahagi haviho Anumaya KotiꞋa tamakaipi ago kava yagaino maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","YisasiꞋa agaiꞋaene tokaeꞋya nemaiya anagafe mage huno hamapaiye “HaenagaꞋa nago kanama falote hisigetama mage hutama hugahae ‘Ikapinagati emainea kanoa vayaꞋmo atenea nafaꞋnemona nagoke yupa kanoꞋa agesune.’ hutama hugahayanagi afaꞋa oꞋagegahae. ");
INSERT INTO kmu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","OꞋagegahagi nagoꞋa veaꞋmoꞋya ‘Amugalega mainegi ageho.’ nehuꞋya ‘Malega mainegi ageho.’ nehuꞋyama hisagetamahena amakavela oꞋviho. ");
INSERT INTO kmu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna eteꞋna esua yamoꞋa maꞋa hugahie ikamoꞋa nago kaiyaga aupaꞋa aulumayaꞋmoꞋma nehia avamete huno mukiꞋa kotega aivasa nehinageꞋna nagaya eteꞋna egahue. ");
INSERT INTO kmu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Egahuanagi hagoteꞋya meni kanafima mainaya veaꞋmoꞋya nagaifena ‘KahaoteꞋyakae.’ huꞋya hunatesageno tusiya huno nagata aigahie. ");
INSERT INTO kmu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea nafaꞋnemoꞋna eteꞋna esua kanafima mainaya veaꞋmoꞋya nayoma NoaꞋma mainea kanafima mainaya veaꞋmoꞋya humainaya kavala hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","NoaꞋma mainea kanafina kavela neneꞋya tina neneꞋya aꞋnema aliyamoꞋene vele uyamoꞋene mukiꞋa kanafina ani yafekeꞋya amakesa havi havi huꞋya mainageno NoaꞋa ala tipi kalefi haisaga humaigeno tusiꞋa lina hogino mukiꞋa ani veaꞋnea alino haviya higeꞋya ago fali haꞋno humainayane. ");
INSERT INTO kmu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","LotiꞋma mainea kanafina ani kava huꞋya kaveꞋene tiꞋene neneꞋya nagoꞋa yaꞋamia miya nehuꞋya hoya aliꞋyaꞋamia neꞋaliꞋya noꞋamia negiꞋya mukiꞋa kanafina ani yafekeꞋya amakesa havi havi humainayane. ");
INSERT INTO kmu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ani amakesale mainageno LotiꞋa Sotomua neꞋataleno umainea kanalela Anumaya KotiꞋa ikapinagati tusiꞋa hiꞋmanaꞋage ata nelea yafaꞋyaga koꞋmopa hia kava huno asaga hulavino mukiꞋa veaꞋnea hamaegeꞋya fali-mainayane. ");
INSERT INTO kmu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nagayama ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna eteꞋna esua kanafima mainesaya veaꞋmoꞋya nayona Loti mainea kanafima mainaya veaꞋmoꞋya humainaya kavala aniꞋa hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","YisasiꞋma esia kanafina nagoꞋa veaꞋmoꞋya kumatega mainesaletila afenoꞋyaꞋamia alisaya yafena eteꞋya nopinaga ohaisae. Nagi aniꞋa huꞋya hoyafinaga mainesaya veaꞋmoꞋya eteꞋya noꞋamilegama hanesea afenoꞋya alisaya yafena oꞋvisae. ");
INSERT INTO kmu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tamakaya Loti aꞋmoma hutenea kavafena tamakesa aikalo hinagetama havilama hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","NagoꞋa veaꞋmoꞋya hamaimuꞋma hanesigeꞋya ‘Mai yatia atafa hutalako huligahune.’ huꞋya amakesama havisayana ani kanale mai yaꞋamimoꞋa fanane hugahianagi nagoꞋa veaꞋmoꞋya ‘Kanalelagita maisuna yatiene tahaimuene Yisasife tagesa nehavita afaꞋa atalegahune.’ huꞋya hisagenoꞋa kanaleꞋya huno mai yaꞋamia aligatimatesigeꞋya maige maige yana aliteꞋya agola maigahae. ");
INSERT INTO kmu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tamahanepauve nagayama eteꞋna esua yupa ani kegela tole vekalatana nagoke sipale faeꞋana mainesaꞋagenofena Anumaya KotiꞋa nagoke avalegahianagino nagola alitaye-talegahie. ");
INSERT INTO kmu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Tole atalana tokaeꞋana aliꞋya neꞋalisaꞋageno Anumaya KotiꞋa nagoke avalegahianagino nagoꞋmona alitaye-talegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","HigeꞋya mage huꞋya havigae “Anumayamogae mani kavala hana kumate falote hugahie?” huꞋya havigageno YisasiꞋa mage huno hamapaiye “AfumoꞋma fali-mainesia kefafina hakikimoꞋya yage yage huꞋya alitalu hunemaiyanagi ikapinagati kanomoꞋna aniꞋa huꞋna mukiꞋa veaꞋmogami amuꞋnopi egahue.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","YisasiꞋa mage hie “MukiꞋa kanafina nunamuna hiho. ‘Kasalo tahae.’ hutama oꞋataleho. Ani kema havisaya yafe nagola huvame ke tamahapaigahue.” huno mage huno hie “Nago ala kumatela Yasi kanoa maine. Ani kanomoꞋa veaꞋnehe agesa havioꞋamamino Anumaya Kotifena koliꞋa nohiane. ");
INSERT INTO kmu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nagola megusa alagino ani kumatela maineno mukiꞋa kanafina ani Yasi kanomote ete ete huno mage huno nehiane ‘Nago kanomoꞋa ali-haviya hunategi kagaya kaiyekeꞋnia havika fatago ho.’ huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Havige havige maino higeno ani Yasi kanomoꞋa hagote kanafina ‘Kaya ohugahue.’ huno hu-maineanagi eteno haenagaꞋa agu agesamoꞋa mage hie ‘Tamage huꞋna nagaya Anumaya KotifeꞋene veafeꞋene kolia nohuanagi ma megusa aꞋmoꞋa nagaite ete ete hia yamoꞋa onahaiyanagiꞋna afaꞋa kaiyekeꞋa haviꞋna fatago hugahue. AniꞋa ohisuana mukiꞋa yupa ete ete hisigeno tusiꞋa kasalo nahaegahie.’ huno humaine.” ");
INSERT INTO kmu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","YisasiꞋa mage huno hie “Fatago kava ohunea Yasi kanomoꞋma humainea kehena havilama hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Anumaya KotiꞋma hisia yafena na tamakesa nehaviye? AgaiꞋa havinoꞋma hapalimatenea veaꞋmoꞋya nateꞋene kegeꞋene mage huꞋya havinegae ‘Ali-haviya hulataya veaꞋmogamina ageteka fatago huka kaiyekea humato.’ huꞋya havige havige hisageno ani kea havisio? E, afaꞋa havigahie. AyaꞋaya kanagefa maiteno amaya hisio? AꞋao tamahanepauve ali-haviya hu-neꞋamataya veaꞋmogamina aupaꞋa anonaꞋamia humategahie. Nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna eteꞋna esuana nagaifema haviꞋya amakupi maleꞋya ametiti nehaya veaꞋnea ma mopafina mainesao omainegahao?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","NagoꞋa veaꞋmoꞋya amakaiꞋami amaku amakesafiti “Kanale kava nehunageꞋya nagoꞋa veaꞋnea kefo kava nehaya anaga mainae.” huꞋya nehaya veaꞋmogamifena YisasiꞋa avame ke huno mage huno hie “Tole kanolatamogania nunamu hugahe mono nopi haiꞋana umainaꞋe. Nago kanoa Falasia kanoe. Nago kanoa musufaya huno vaya amaugafaleti takisi mone aliliteno nehia kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falasia kanomoꞋa amuꞋnote mo hetino maineno Anumayamotega agaiꞋahe mage huno hie ‘Nagaya nagoꞋa veaꞋmoꞋya nehaya kavala nohue. Musufayama haya kavala nohue. Fatago ohunaya veaꞋmogami augafa kavala nohue. AꞋnele kumai nehaya kavala nohue. Mama mainenoꞋma vaya amaugafaleti takisi mone aliliteno nehia kano kana ohunoe. Ani yafe musekaꞋa nehue. ");
INSERT INTO kmu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","MukiꞋa sotamo aliꞋyapina nagaya tole yupa kavela mosiꞋna maineꞋna mukiꞋa neꞋalua yapitila teniꞋama (10) malenofitila nagoke alitayeꞋna negamuane.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hianagi vaya amaugafaleti takisi monema aliliteno nehia kanomoꞋa aluꞋale maineno Anumaya Kotitega ke huno havigegahe hetimaineno ‘Nagaya kefo kano mainoe.’ huno ikapinaga agesaga ohuno ape huno havi kafa yonegino Anumaya Kotitega mage huno havige ‘Anumayamogae nagaya kefo kava hume hume nehauva kano mainoe. Nagaifena kalagi ainateka kahau hunato.’ huno havige.” ");
INSERT INTO kmu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","YisasiꞋa mage huno hie “Nagaya tamahanepauve anima musufayama huno takisi monema aliliteno nehia kanomofena Anumaya KotiꞋa ‘Fatago kano mainane.’ huno hutegeno nomaꞋalega eteno umaineanagi hagote kanomofena ani kea hu oꞋatene. NagoꞋa veaꞋmoꞋya amakaiꞋami amaugafa aliꞋya haisayana Anumaya KotiꞋa ‘Osi veaꞋne kanoꞋa mainae.’ huno humategahianagi nagoꞋa veaꞋmoꞋya ‘Osi veaꞋne kanoꞋa mainone.’ huꞋya hisayana Anumaya KotiꞋa amakia alisaga hugahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","NagoꞋa veaꞋmoꞋya osi osi nafaꞋneyaga Yisasite “Aya malesie.” huꞋya amavaleꞋya neꞋageꞋya agaiꞋaene tokaeꞋya nemaiya anagamoꞋya ageteꞋya “NaꞋa kavala ohiho.” huꞋya kemamaki-mainae. ");
INSERT INTO kmu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kemamakiyanagi YisasiꞋa ani nafaꞋneyagahe mage hie “AmatalegeꞋya nagaitega eho.” higeꞋya ageno mage hie “NafaꞋneyaga nagaite esaya yafena kahegi oꞋamateho. NaꞋa huꞋya nafaꞋnemogami avamete maisaya veaꞋmoꞋya mage hugahae ‘Tagaya tokiyatia omalenegi Anumaya Kotiga kava yagailato.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tamagelafa huꞋna tamahanepauve nagoꞋa veaꞋmoꞋya nafaꞋne mainaya avamete maisaya veaꞋmoꞋya mage hugahae ‘Tagaila tokiyatia omaleanagika Anumaya Kotiga kava yagailato.’ huꞋya ohisayana Anumaya KotiꞋma kava yagaisia kumatela oꞋugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nago kava kanomoꞋa mage huno havige “Kagaya kanaleꞋya huka humavenelina kanomoga nagaya hanaꞋa huteꞋna agola maige maige hisua nahaimula alisue?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Havigegeno YisasiꞋa kenonaꞋa mage huno hie “NaꞋa higeka nagaifena kanale kanoa mainane huka nehane? Anumaya KotiꞋa agaiꞋage kanale kanoa maine. ");
INSERT INTO kmu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kagaya Anumaya Koti kahegi kea ago havilinanagi ani kemoꞋa mage huno humaine ‘Kumai he yana ohuo. Vayala hamaegeꞋya ofaliho. Musufayana ohuo. ‘Ma kanomoꞋa havi kava nehie.’ huka havigea huoꞋato. Itakafokamo kea oꞋatagaeka anakia alisaga huo.’ huno humaineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Higeno ani kanomoꞋa mage hie “Nagaya nafaꞋnema mainoa kanaleti aepa heꞋna mukiꞋa ani kema hana kea akave nemaloane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Higeno YisasiꞋa ani kea haviteno mage huno hie “Nago kavaꞋene huo. MukiꞋama malenana mone fenoꞋyaꞋyagaka alika fako faka huka moneꞋamima omalenesia veaꞋne amamisanageno Anumaya KotiꞋa ikapinaga hanea afenoꞋyana kagaila kamigahie. AfenoꞋyaꞋyagaka fako huka amamite amamite huteka nakave eno.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Higeno ani kanomoꞋa ani kea haviteno mone fenomaꞋamoꞋma kasagoꞋma humainea yafe oꞋatalesia agesa haviteno aipamoꞋa tusi kanaꞋage humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","KanaꞋage higeno YisasiꞋa ageteno mage huno hie “MukiꞋa mone fenoꞋyaꞋamima hanesia veaꞋmoꞋya tusiꞋa kasageke huꞋya ‘Anumaya Kotife kava yagailato.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nagola pulumaka kana afumo agia kemolomoꞋa nekaꞋyamo kapima hai falesiana afaꞋa yoꞋyo huno hai falegahianagi mukiꞋa mone fenoꞋyamaꞋa hanesia kanomoꞋa Anumaya Kotife ‘Kava yagainato.’ huno kasageke-voke hugahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","HigeꞋya ani kea haviteꞋya veaꞋmoꞋya mage huꞋya hae “NaꞋama hu-mainesiana Anumaya KotiꞋa hana veaꞋmogami amaku amamemaꞋa aligatigahie?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hageno YisasiꞋa mage hie “VeaꞋmogamina himamuꞋamia omaleneanagiꞋya ohugahayanagi Anumaya KotiꞋa mukiꞋa kava hisia himamuꞋa haneanagino afaꞋa aligatigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nage higeno PitaꞋa mage huno hie “Havio tagaya mukiꞋa yatia ataleteta kagai kakavela neꞋone.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Higeno YisasiꞋa mage huno hamapaiye “Tamage huꞋna tamahanepauve mukiꞋa veaꞋmoꞋya Anumaya KotiꞋa kava yagaisia keꞋa veaꞋnema mo hamapaigahena noꞋamiene aꞋamiene amasaꞋamiene nepuꞋamiene itaꞋafoꞋamimoꞋene nafaꞋneꞋamiene amataleꞋya visagenoꞋa Anumaya KotiꞋa mopaleꞋma mainaya kanaleꞋma atalenaya yaꞋene nagoꞋene nagoꞋene anonaꞋa ohavunamaꞋa ya amamiteno haenagama falote hisia kanafina maige maige hisaya hamaimuꞋene amamigahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagala hamaote amavaleno momateneno mage huno hie “Haviho tagaya Yelusalemu haisunageꞋya mukiꞋa Anumaya Koti amaune vayaꞋmoꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonihema kae-malenaya kemoꞋa efalote huno tamage hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nagaila natafa huꞋya Yuta vea omainaya vayate navaleꞋya momamisageꞋya nagaye hisifa kea hunateꞋya hu-haviya hunateteꞋya amavetuꞋna henategahae. ");
INSERT INTO kmu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hegi kaꞋyoteti nahaeteꞋya tavata nahaesageꞋya hevainatesageꞋna tole yupa komufina maiteꞋna tagufa kanale fali-mainesufitila eteꞋna hetigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hianagi YisasiꞋene tokaeꞋya nemaiya anagaꞋmoꞋya keꞋa haviyanagi ani kemo aepamoꞋa falaki-mainea yafe havilama ohunae. ");
INSERT INTO kmu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","YisasiꞋa Yeliko kumate uvaꞋyi hugahe mo aupa higeno nagola aulaga asu humainea kanomoꞋa kate mopale maineno monehe aukaꞋya hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","AukaꞋya maino nehigeꞋya mukiꞋa veaꞋmoꞋya agaseꞋya eutele haya yafe “NaꞋa higeꞋya mukiꞋa veaꞋmoꞋya nagaseꞋya eneꞋvae?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","HigeꞋya “Nasaleti YisasiꞋa neꞋegeꞋya kagaseꞋya eneꞋvae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hageno ala kegefafiti mage huno hie “Yisasiga Tevitina aginagomogae nagaila kahauna hunato.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","HigeꞋya aulegama mainaya veaꞋmoꞋya kemakiꞋya “Ke ohuka maiyo.” huꞋya hayanagi nagoꞋene ala kefiti keha keha hie “Yisasiga, Tevitina aginagomogae kahauna hunato.” huno keha keha humaine. ");
INSERT INTO kmu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Higeno YisasiꞋa haviteno anile heti-maineno “Avaletama nagaite eho.” huno higeꞋya avaleꞋya ageno YisasiꞋa “NaꞋa hugatesue hugeka nehane?” huno havigegeno “MusekaꞋa nehue nagaya eteꞋna naulaga agesua yafe nehue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Higeno YisasiꞋa agaifena mage hie “Kaulaga agegali huo. Nagaifema havika kagupi maleka kametiti hanafe kaulagamoꞋa ago kanale hugate.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Higeno aupaꞋa ani kanomoꞋa agegali nehuno Yisasi akave neꞋeno Anumaya Koti agi alisaga nehigeꞋya mukiꞋa anile alitalu humainaya veaꞋmoꞋya ageteꞋya Anumaya Koti agia alisaga humainae. ");
INSERT INTO kmu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","YisasiꞋa Yeliko kumate uvaꞋyi huteno agaseno alulega ugahe vie. ");
INSERT INTO kmu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","NeꞋvigeno ani kumatela nago kanomo agia SakiusiꞋa musufaya huno vaya amaugafaleti takisi mone aliꞋyate kava kanogino moneꞋamoꞋa kasago humainea kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ani kanomoꞋa “YisasiꞋa hanaꞋa augafa kano neꞋefigagiꞋna agesue.” huno hianagi aupa kanogiꞋya yage yage humainaya veaꞋmoꞋya agasageno “HanaꞋa huꞋna Yisasina agesue?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","YisasiꞋma visia katega aiyayeno uhagoteno nagola fiki yosafi moliteno haimaine. ");
INSERT INTO kmu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Haino mainegeno YisasiꞋa ani yosamo aepale neꞋeno agesaga huno ageteno Sakiusifena mage huno hie “Kagaya aupaꞋa elavio menia kagai nopi momaigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Higeno SakiusiꞋa aiyayeno laviteno tusiꞋa muse huno Yisasina avaleno nomaꞋalega atene. ");
INSERT INTO kmu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Avaleno vigeꞋya veaꞋmoꞋya aniꞋama hia yana ageteꞋya Yisasifena kalugalu ke vaiꞋya mage huꞋya hae “Kefo kavakeꞋya maino nehia kanomo nopinaga maigahe viana havi kava hie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hayanagi SakiusiꞋa hetino Anumayamofe mage huno hie “Havio AnumayaniꞋamoga menia nagaya afenoꞋyaniꞋa amuꞋnopiti ali fako huꞋna moneꞋamima omale vaya amamigahue. Havigema huꞋna moneꞋamima musufa ali-mainoa monea eteꞋna foꞋa (4) malete malete huꞋna amamigahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Higeno YisasiꞋa mage huno hapaiye “Kagaya Apalahamuna aginagomoga mainanagi menia anagakaene kagaiꞋene Anumaya KotiꞋa tamaku tamamena ago alinegatie. ");
INSERT INTO kmu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna fanane humainaya veafe amatiyeꞋna amaku amame aligatigahe emainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","YisasiꞋa Yelusalemu uvaꞋyi hugahe higeꞋya veaꞋmoꞋya amaku amakesa mage huꞋya haviye “Anumaya KotiꞋa kava yagaisia kanamoꞋa aupaꞋa falote hugahie.” huꞋya amakesa haviya yafe YisasiꞋa mage huno nago avame kea hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Nago kava kanomoꞋa kava yagaisia tokiyaꞋa aligahe ‘AyaꞋaya kotega mo maineꞋna aliteꞋna eteꞋna egahue.’ huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","AyaꞋaya kotega ugahe nehuno teniꞋa (10) aliꞋya vayaꞋamogamife ke higeꞋya ageno monea ali-fako huno tueti (20) kina tueti (20) kina amamite amamite hie. Amamiteno mage huno hamapaiye ‘Mani moneleti aliꞋyana aligeno ali kosa nehenageꞋna nagaya eteꞋna ano.’ huno hamapai-maine. ");
INSERT INTO kmu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hamapaiteno ataleno umainegeꞋya nagoꞋa vayaꞋamoꞋya ani kava kanomofe amaipa haviya huteteꞋya nagoꞋa aliꞋya vayala humatageꞋya mo humakesa huꞋya ‘Mage hutama hiho.Tagaya mani kanoma kavatima maisia yafena notahaiye hutama hiho.’ huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hageno ani kava kanomoꞋa kava yagaisia tokiyaꞋa ago moliteno ani kotegati eteno monema fako huno amaminea aliꞋya vayamogamife ‘NaꞋmagi mone halaꞋya humalenafi?’ huno havisia yafe amakaife ke hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ke higeno hagote kanomoꞋa evaꞋyi huno mage hie ‘Ala kanomogae kagaya tueti (20) kinama naminapitila eteꞋna nagoꞋene aliꞋya aliꞋna kosa hua monene tu hataleti (200) kina alugeno hane.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Higeno ala kanomoꞋa mage huno hie ‘Kagaya kanale kano mainane. KanaleꞋya huka osi mone kanoꞋa kaminofitila efi efi huka aliꞋyana alinageno ala hiafe kagaila teniꞋa (10) ala kumate kava yagaisane huꞋna hapalinegatoe.’ huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Higeno anile kanoa eno mage huno hapaiye ‘Ala kanomogae kagaya tueti (20) kina naminapitila eteꞋna nagoꞋene aliꞋya aliꞋna kosa hoa monene vani hataleti (100) kina alugeno hane.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Higeno ani kanomofena ala kanomoꞋa mage huno hapaiye ‘Nagaya faefuꞋa (5) kumate kava yagaisane huꞋna hapalinegatoe.’ huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Higeno nago aliꞋya kanomoꞋa anile eno mage hie ‘Ala kanomogae tueti (20) kinama naminana monea afaꞋa omanafi haꞋya kiꞋna katenoanagiꞋna menia ma ma aliꞋna me negamue. ");
INSERT INTO kmu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kagaya keꞋage kanoma mainananagiꞋna kolikaꞋa hue. Alu veaꞋmogami yana alika kaugafa hegeka omai kano mainananagika nago kanomoꞋa hoyaꞋafima kali-malenea yaꞋene alika negeka omai kanogiꞋna kolikaꞋa hue.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Higeno kava kanomoꞋa ani aliꞋya kanohena mage hie ‘Kagaya havi aliꞋya kano mainane. KagaikaꞋa kemo eteno maiyahae huno kaiyekea hugategahie. Kagaya ago havimainane nagaya keꞋage kano mainoe. Alu veaꞋmogami yama aliꞋna naugafa hegeꞋna omai kano mainoanagiꞋna nago kanomoꞋma hoyaꞋafima kali-malenea yaꞋene aliꞋna negeꞋna omai kano mainoanagika kagaya nagaifena ago havimainano? ");
INSERT INTO kmu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","NaꞋa higeka monema nemalaya nopina moneꞋnia omaleka afaꞋa malenane. Monema nemalaya nopima malenateꞋasina menia nagaya nagoꞋa aꞋva monene aluleꞋasine.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anile hetiꞋya mainaya vayafe mage huno hie ‘Tueti (20) kinaꞋnia hafaletama tu hataleti (200) kinama malenea kanomona amiho.’ huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","HigeꞋya amakaya kava kanomofena mage huꞋya hapaiye ‘Ala kanomogae ani kanomoꞋa tu hataleti (200) kina ago alino malene.’ huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hageno mage hie ‘Tamage huꞋna tamahanepauve nago yama hanesia veaꞋmogamina nagoꞋene amamigahigi nago yama omalesaya veaꞋmogamina alilinesamaꞋa hanafalegahie. ");
INSERT INTO kmu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kame veaꞋniꞋamoꞋya nagaifena ‘Kavatima maisia yafena notahaiye.’ huꞋya humainaya veala amavaletama naulagale hamaegeꞋya faliho.’ huno hie.” ");
INSERT INTO kmu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","YisasiꞋa anima hia kaiyekea huno haꞋno humaleteno Yelusalemu ugahe uhagoteno katega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Petafasiene Petaniene ani kumatalana Olivi yosa hanea agoꞋyamona agegayalega hanegeꞋya aupaꞋa uvaꞋyi hugahe hageno YisasiꞋene tokaeꞋya nemaiya anagapiti tole kanolatana hunateteno mage huno hanapaiye “Atu kumate utana atupa notela hosi kana afumo agia tokigi ani tokimo nafaꞋnea ayetenayanagitana agegaꞋe. Ani tokimo nafaꞋnea vayala oꞋamavalenea tokigi kalu hetana avaletana male eꞋo. ");
INSERT INTO kmu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","NagoꞋa vayaꞋmoꞋya ‘NaꞋa higetana kalu hetana neꞋvaꞋe?’ huꞋya tanahavigesagetana mage hutana hiꞋo ‘Kava kanotimoꞋa nago aliꞋya aligahe higetaꞋa neꞋoꞋe.’ hutana hamapaiꞋo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hunatea kanolatamogania mogeteꞋana YisasiꞋma hanapaiya yana ago moge falote humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","34","Ani tokimo nafaꞋnea kalu nehaꞋageꞋya ani afumo nefaꞋya megeteꞋya mage huꞋya hae “NaꞋa higetana tokimo nafaꞋnea kalu nehaꞋe?” huꞋya hageꞋana mage huꞋana haꞋe “Kava kanotimoꞋa aliꞋya aligahe higetaꞋa kalu nehoꞋe.” huꞋana hamapaiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","HuteꞋana Yisasite avaleꞋana evaꞋyi huꞋana kenaꞋania anaugafaleti hateꞋana ani afumo agupile yakai-malaꞋageno YisasiꞋa anile haino maine. ");
INSERT INTO kmu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Haino maiteno katega neꞋvigeꞋya veaꞋmoꞋya “Ala kanoa neꞋie.” huꞋya amaugafaleti kenaꞋamia hateꞋya visia katela yakaitenae. ");
INSERT INTO kmu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","YisasiꞋa viaꞋyamo Olivi yosa hanea agoꞋyamona agegayalegati enelavigeꞋya mukiꞋama melitalu humainaya veaꞋnene agaiꞋenema tokaeꞋya nemaiya anagaꞋaene tokiya avameꞋyama higeꞋya age-mainaya yafe aepa heꞋya ala kefiti Yisasife muse nehuꞋya Anumaya Koti agia alisaga hume hume neꞋuꞋya mage hae ");
INSERT INTO kmu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ala kava kanomogae kanaleꞋya huka neꞋane. Anumayamo aliꞋya aligahe hanageno hugategeka emainana kanomoga Anumaya KotiꞋa kanale manu kamiteno kaya humaine. Ikapinaga amaipa falu hisaya yana hanesie. Anafi mainea Anumaya Kotina agai agia alisaga hisune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","HageꞋya anima melitalu humainaya veapiti nagoꞋa Falasia vayala anifi maineꞋya Yisasife mage huꞋya hae “Humavenelina kanomogae kagaiꞋenema tokaeꞋya nemaiya anagakamogamifena ‘Kea ohutama maiho.’ huka hamapaiyo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hageno YisasiꞋa mage hie “Nagaya tamahanepauve ani veaꞋmoꞋya kema ohuꞋya maisayana yafaꞋyagamoꞋya amakaiꞋami ani kea hugahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yelusalemu kumala aupate hanegeno YisasiꞋa ageteno ani kumate veafe avite-maine. ");
INSERT INTO kmu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Avia ateteno mage hie “Ma kea meni havisae huꞋna nehugi nagaya tamaipamoꞋa falu hisia yana tamamisua kano mainoe. Menima mainogetama ani yana falaki mainegetama noꞋagae. ");
INSERT INTO kmu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nagola alu kana falote hisigeꞋya kame vayatamimoꞋya esayaꞋamoꞋya kegiꞋya lafi humalenaya kegiꞋyafi me kagi kagi nehuꞋya ali haviya hulamategahae. ");
INSERT INTO kmu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Anumaya KotiꞋa tamaya hugahe neꞋegetama agai kema ohaviya yafe kame vayatamimoꞋya tamakaiꞋene nafaꞋnetamiene mukiꞋa lafifima mainaya veaꞋnene falifalutisageꞋya yafatetiꞋma kimalenaya nona mukiꞋa ani yafamoꞋa mopafi helafilavigahie.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","YisasiꞋa ani kaiyekea huteno ala mono nopi hai faleno ageana ani nopi mainaya veaꞋmoꞋya monehe ke huꞋya neꞋaliya veaꞋmogamina aepa heno amanatigahe nehuno mage hie “Anumaya Koti autaꞋmafina mage huno kae-maleneane ‘Nagai nona mukiꞋa veaꞋmoꞋya Anumaya Koti agi ayeꞋya ke huꞋya havigesaya no hane.’ huno kae-maleneanagi tamakaya musufa yama hisaya kava hugahena ma nopi emainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","MukiꞋa kanafina ani ala mono nopi hai faleno huge amavelige nehigeꞋya ani mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene mukiꞋa veate kava vayaꞋene Yisasima haesaya kafena atiyemainae. ");
INSERT INTO kmu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ati maiꞋya ayayanagi mukiꞋa veaꞋmoꞋya agai kehema muse huꞋya agima alisaga haya yafe ala vayaꞋmoꞋya haesaya kana ageꞋya ali falote ohunae. ");
INSERT INTO kmu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nago yupa YisasiꞋa ala mono nopi maineno alitalu humainaya vayala humavelino Anumaya Koti kanale mono kea hamapaigeꞋya ani kumate vayatamaene mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene agaitega emainae. ");
INSERT INTO kmu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mage huꞋya hae “Hana augafa ala kanomo hugategeka mani kavala me nehane? Tokiya yaka ta kamine?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Havigageno YisasiꞋa mage huno hie “Nagaya hagoteꞋna nago yafena tamahavigegahue nagaila nahapaiho. YoniꞋma tima falematenea yana Anumaya KotiꞋa hutegeno ani kavala me nehifi afa vayaꞋmoꞋya hutageno lina fale neꞋamate? Hufalote hutama nahapaiho.” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","7","HigeꞋya “NaꞋa maꞋa hugahune.” huꞋya mohu mehu huteꞋya mage hae “Anumaya Koti hutegeno emaine.” hisunagenoꞋa YisasiꞋa “NaꞋa higetama agai kea tamakupina nomalae?” huno hugahianagita tagaya “Afa vayaꞋmoꞋya hutageno emaine.” huta hisunana mukiꞋa veaꞋmoꞋya “YoniꞋa Anumaya Koti aune kano maine.” huꞋya ago humainayafe “Yafa kaꞋyoteti tahaesageta faliyafene.” huꞋya mohu mehu huteꞋya Yisasifena kenonaꞋa mage huꞋya hae “Tapiga hutene? Tagaya ohavinone.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hageno YisasiꞋa mage huno hamapaiye “Nagaya aniꞋa huꞋna hana kanomoꞋa hunategeꞋna emainoe huꞋna tamahaopaigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","YisasiꞋa aepa heno veafe nago avame kea mage huno hamapaiye nago kanomoꞋa vaini nofi alaga hoya kali-maleteno noꞋagea vayafe mage hie “Etama hoyaꞋnilela yagaitama maineho. Ani nofiꞋmo alagafitila aye fako hutama aliho.” humateteno ayaꞋaya kanagefa umaigahe alu kotega umaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Afu nelea kanafina ani hoyamona nefaꞋa nago aliꞋya kanoꞋa hutegeno kava vayatega nagoꞋa vaini nofi alaga aligahe umaine. VigeꞋya hoyale kava vayaꞋmoya atafa huꞋya aikoliteꞋya “Okamigahunagi ataleka vuo.” huꞋya hageno ataleno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Utegeno nagola kayo kayo kanoꞋa hutegeno viana aniꞋa huꞋya aikoliteꞋya agaye hisifa kava huteteꞋya “Okamigahunagi ataleka vuo.” huꞋya hageno ataleno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Utegeno eteno nagola kayo kayo kanoꞋa hutegeno viana aniꞋa huꞋya aikoligeno kolamoꞋa higeꞋya hoyafinagati avaleꞋya malaga hagaꞋyu hutalenae. ");
INSERT INTO kmu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","HagaꞋyu hutalageno hoyamona nefaꞋa agesafinaga mage huno havie “HanaꞋa hisue? NafaꞋneꞋnimona nahau nayamopafi nenahaiya nafaꞋneꞋnia hutesugeno visigeꞋya agai kea havisao?” huno havimaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Agesa haviteno hutegeno neꞋvigeꞋya ageteꞋya mage huꞋya hae “Mamona mani hoyamona nefa nafaꞋne. NefaꞋma falisigenofena mani nafaꞋnemoꞋa hoyaꞋa aligahianagita agaila ago haegetao. Haesunageno falisigeta mani hoya tagai ya hapaegahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","HuteꞋya hoyafinagati avaleꞋya hagaꞋyu hutaleteꞋya hayageno fali-maine. YisasiꞋa mage hie “NaꞋa hayanagi hoyamona nefaꞋa naꞋa humategahie? ");
INSERT INTO kmu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eteno hoyaꞋafima kava yagai-mainaya vayala tavata me hamaesigeꞋya faligahae. Fali haꞋno hisageno alu vayafe ‘HoyaꞋnilela kava me yagaiho.’ huno hugahie.” huno hie. HigeꞋya anifima alitalu humainaya veaꞋmoꞋya mage hae “AvoꞋnio ani kavala ohisie.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hageno YisasiꞋa nago kea mage huno hie “Kae-malenaya kemoꞋa mage huno humaineane ‘VayaꞋmoꞋya yafa noma kigahena nago yafafena ‘Haviya humaine.’ huꞋya atalayanagi haenagaꞋa ani yafamoꞋa ‘TusiꞋa kanale yafane.’ huꞋya nomo ayetagenale malenae.’ huꞋya kae-malenayane.” huno hie. Huteno amakeno ute ete hiana higeno mage huno hie “AgoꞋma kae-malenaya kemona aepaꞋa havilinao? ");
INSERT INTO kmu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","MukiꞋa veamoꞋya ani yafateꞋma asaga hulavisayana amaugafamoꞋa atalaga huno haviya hugahianagi ani yafamoꞋa vaya amaugafaleꞋma asaga hulavisiana ailatapeno aitalaga talago hutalegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","HigeꞋya kahegi kema havilinaya anagaꞋene mono note kava vayaꞋene “Tagaife ani avame kea nehie.” huꞋya ago haviteꞋya “Menia avaleta kina nopi ategahune.” huꞋya hayanagi vaya amauhe koli huꞋya atalenae. ");
INSERT INTO kmu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","AtaleꞋya ala tokiyaꞋama hanea kanomote kaiyeke hutesiafe Yisasifena kesi amata huꞋya maineꞋya agesaya vayala humatageꞋya moyevataga hisayafe ani vayala “Kanale fatago vaya mainone.” huꞋya fau nehuꞋya YisasiꞋma hisia keleti atafa hugahe humainae. ");
INSERT INTO kmu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Anima kesi kateꞋma vaiyaya vayaꞋmoꞋya mage huꞋya hae “Humaveli kanomogae tagaya havunana nehana kea fatago katekeꞋya hana kanoe. Nagi kava vayaꞋene afa vayaꞋene nagoke katekeꞋya hamapaika veaꞋma amaipa aye kea nohanagi tamage hutafa huka Anumaya KotiꞋa ‘Ma kate vuo.’ huno hia kegeꞋya taveneline. ");
INSERT INTO kmu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nagi takisi he yatela kava kanoa Sisana kanale amisupi oꞋamisune?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Havigageno YisasiꞋa agaiꞋma ayevataga haya kea ago haviteno mage huno hamapaiye “Nagola alaga monea alitama naveliho.” higeꞋya aveligeno “Mani alaga monelela ta augosaene ta agiene hane?” huno higeꞋya “Sisa augosaene agiene hane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hageno YisasiꞋa mage huno hie “Sisana agaiꞋa yanagi agaila amiho. Nagi Anumaya Kotina agaiꞋa yana agaila amiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","HigeꞋya anima kesi kateꞋma vaiyaya vayaꞋmoꞋya “Vaya amaulagafi hisia keleti atafa hugahe hunanagi tokiya ke hianagita atafa ohugahune.” huꞋya nehuꞋya hia kehe amakesa havi havi huꞋya ke ohuꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","NagoꞋa Satiusi vayaꞋmoꞋya* Yisasitega emainae. Ani vayala mage nehaya vayale “Falimainaya vayala eteꞋya heotigahae.” huꞋya nehaya vayalagiꞋya Yisasite mage huꞋya me havigae “Humavenelina kanomoga MoseseꞋa tagaifena mage huno kae-maleneane ‘Nago kanoma nepuꞋamoꞋa nafaꞋneꞋa oꞋate kanomoꞋma aꞋama ataleno falisigenoꞋa aganaꞋamoꞋa ani aala aliteno maineno fali-mainesia kanomofe anonaꞋa nafaꞋne atesie.’ huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","SeveniꞋa (7) konaga mainayanagino nepuꞋamimoꞋa aala aliteneanagino nafaꞋnea oꞋate kano maineno falimaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Falitegeno anile aganaꞋamoꞋa aliteana nafaꞋnea oꞋate kano falimaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Falitegeno anile aganaꞋamoꞋa eteno aniꞋa hute hute hayana mukiꞋa seveniꞋa (7) konagamoꞋya ani aala alitayana nafaꞋneꞋamia oꞋateꞋya afaꞋa falimainae. ");
INSERT INTO kmu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Haenagalafa ani aala falimaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","SeveniꞋa (7) konagamoꞋya ani aala alitenayanagi fali-mainesafitiꞋma hetisaya kanafina hana kanomo ani aala aligahie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Havigageno YisasiꞋa mage huno hamapaiye “Ma mopafi mainaya veaꞋmoꞋya vea aligeꞋya aꞋne aligeꞋya nehayanagi haenagaꞋama falote hisia kanafina veaꞋmoꞋya amatea kavama agoꞋma huteꞋya maineꞋya fali-mainesafitiꞋma hetisaya kanafina vemoꞋya aꞋnea oꞋaligahae. AꞋmoꞋyaenena vea oꞋaligahae. ");
INSERT INTO kmu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ikapinaga ensole vaya kana huꞋya maisayafenagiꞋya nagoꞋene ofaligahae. AgoꞋma fali-mainafitila heti-mainayafe Anumaya Koti nafaꞋneyaga maigahae. ");
INSERT INTO kmu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Fali-mainaya veaꞋmoꞋya hetisaya kea MoseseꞋa ago haviline. Nago osi yosale ala ata anefela leanagi ani osi yosa otene huno kae-malenea kefiti mage huno kae-maleneane ‘Anumaya KotiꞋa ApalahamuꞋagi AisakiꞋagi Yekopugami Anumaya KotiꞋami mainoe.’ huno humaineane. Ani anagala fali-mainayanagi ‘Anumaya KotiꞋami mainoe.’ huno humaineafe amaku amamemoꞋa ofaliꞋya afaꞋa mainae huno ani kea humaine. Anumaya Koti aulagafina ani anagala hamaimula afaꞋa hane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","HigeꞋya nagoꞋa kahegi kema havilinaya anagaꞋmoꞋya agaifena mage hae “HumaꞋvenelina kanomoga kanale ke nehane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","HageꞋya Satiusi vayaꞋmoꞋya koli huꞋya nagoꞋene haviokenae. ");
INSERT INTO kmu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","YisasiꞋa mage huno hamavige “VeaꞋmoꞋya Kalaisifena, Anumaya KotiꞋma huꞋtenea kanomofena, ‘Tevitina aginagomoꞋa ma mopale kano maine?’ huꞋya haya kemona aepaꞋa naꞋane hae? ");
INSERT INTO kmu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Anumaya Kotifena yagame kae-malenaya avona TevitiꞋa mage huno humaineane ‘Anumaya KotiꞋa Anumayanimofena mage huno humaine ‘Tamaga nayatega ala vaya mainalega siale mopale emainesanageꞋna kame vayakaꞋa kaiyafi amatesugeꞋya kagaife ‘Ago tagasane.’ huꞋya hugahae.’ huno kae-maleneane.’ ");
INSERT INTO kmu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","TevitiꞋa Kalaisife ‘AnumayaniꞋa mainane.’ huno humainegi naꞋa higeno TevitiꞋa haenagama atesia aginagomofena ‘AnumayaniꞋa mainane.’ huno humaineane?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","MukiꞋa veaꞋnea maineꞋya havigeno YisasiꞋa agaiꞋene tokaeꞋya nemaiya anagafe mage huno hie “Kahegi kema havilinaya anagafena kaꞋyeho. Ani anagaꞋmoꞋya ayaꞋaya kena failiya yafena ‘Nelagafi notagafi?’ huꞋya nehaya anagale. Vaya atagu nefaya kumapi mo vaiyatete nehuꞋya ‘NaꞋa vaya mainae huꞋya ali falu fala hulatesae.’ huꞋya nehuꞋya mono nopiꞋene imuleꞋene ‘Ala vayaꞋage alitalu huꞋya nemaiya yatekeꞋya maigahune.’ huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ani anagaꞋmoꞋya keto aꞋneyagahena ‘Mono nopima atalesaya monea tamiho.’ huꞋya nehuꞋya noꞋamifima hanea yaꞋyaga musufaya huꞋya moneꞋamia ali haꞋno nehaya anagalagiꞋya vayala ayemavataga huꞋya ‘Kanale anaga mainae.’ huꞋya hisae huꞋya ayaꞋaya nunamuna humainae. AniꞋama nehaya anagaꞋmoꞋya havi miyana tusiya huno amaugafa amagata aisia yaꞋene aligahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","YisasiꞋa agesaga huno ageana veaꞋmoya moneꞋamimoꞋma haimainea veaꞋmoꞋya “Monetia Anumaya Kotina amigahune.” huꞋya pokisifi atalenae. ");
INSERT INTO kmu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atalageno ageana nagola moneꞋa omale keto aꞋmoꞋa tole osi haesa monea anifi me vaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Me vaigeno YisasiꞋa ageteno mage huno hie “Tamagelafa huꞋna tamahanepauve ma ma moneꞋa omale keto aꞋmoꞋa mukiꞋa hagoteꞋyama metalaya veaꞋmogamina amakaseno ala mone metale. ");
INSERT INTO kmu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Metaleanagi moneꞋami-moꞋma haimainea veaꞋmoꞋya aliꞋyamaꞋa omalenea monegiꞋya, afaꞋa malenaya mone metalageno ani aꞋmoꞋa mukiꞋa kaveꞋma alino nesia moneꞋa mukiꞋa metale.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","NagoꞋa vayaꞋmoꞋya ala mono nofena mage huꞋya hae “Anumaya Koti agi alisaga hugahe vayaꞋmoꞋya kanale yafana aliꞋya ma nona ali hilato huꞋya kimalenae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Hageno YisasiꞋa mage huno hie “Ma ma neꞋagaya nona nago kanama falote hinagenoꞋa ani yafaꞋyaga mukiꞋa alino lagape aitalesigeno aposi-lavino tole yafamoꞋa nago yafamo agupile aikalo huno omaigahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Hulave nelina kanomogae na kanafi ani kavala hugahie? HanaꞋa tokiya avameꞋya ani kanama faloteꞋma hisia kanafina taveligahie?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hageno YisasiꞋa mage huno hie “NagoꞋa veaꞋmoꞋya havigema tamahapaisagetama havisao? Ohavisaya yafe kaꞋye ho. KasagoꞋya vayala nagai nagi ayeꞋya ‘Tamaugafa aligatisuna yafe Anumaya KotiꞋa hulategeta neꞋone.’ huꞋya hisaya vayala evaꞋyi huꞋya ‘YisasiꞋma eteno esia kanamoꞋa ago falote nehie.’ huꞋya hisagetama amakavela oꞋviho. ");
INSERT INTO kmu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","‘NagoꞋa kotega kame nehae. NagoꞋa kotegaenema tu hugahe nehae.’ huꞋyama tamahapaisagetama kolia ohiho. Ani yaꞋyaga hagoteꞋya hugahayanagi ma mopama haꞋno hisia yaꞋyaga aupaꞋa vaꞋyi ohugahie. ");
INSERT INTO kmu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nago nofi vayaꞋmoꞋya nagoꞋa nofi vayaꞋene kamea hugahae. Ala kotega vayaꞋene nago ala kotega vayaꞋene kamea hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","TusiꞋa imila aligahie. Alu kotega alu kotega tusiꞋa kafu nehuꞋya amakatesia kanaene tusiꞋa kali alisaya kanaene falote hugahie. Ikapinagatila tusiꞋa lamamaꞋyo aisia tokiya avame yaꞋyaga falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma ma tamahapauva kemoꞋa falote ohunesigeꞋya tamakaya nagai nakaveꞋma nehayafe vayaꞋmoꞋya tamatafa huꞋya ali haviya hulamateteꞋya mono nopi kava vayateꞋene Kamani kava vayateꞋene kaiyekea hulamatesayafe tamavaleꞋya kina nopi tamategahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tamatesagetama ani kanafina nagai kea hamapaigahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hamapaigahagi kaiyekema hulamatesaya yupa ‘NaꞋane hugahune?’ hutama tamakesa ohaviho. ");
INSERT INTO kmu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nagi nagaya nagaiꞋniꞋa ani kanafina kanale ke hisaya kea tamahapaisugetama hisageꞋya kame vayatamimoꞋya ‘Havige hae.’ huꞋya ketamia hefala okigahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hefala okigahagi ani kanafina itatamimogamiꞋene nelamafaꞋene neputamimoꞋyaene tamasatamimoꞋyaene tamakaitami afamoꞋene nelamafuꞋyaene tamakaifena ‘Ma mainae.’ huꞋya kaiyekema hulamatesaya yafena kame vayatamimogami amayapi tamavaleꞋya tamatesageꞋya nagoꞋamogatamina tamahaesagetama faligahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamakaya nagai nakaveꞋma nehayafe mukiꞋa veaꞋmoꞋya amaipa kafa helamategahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","AniꞋa hulama-tegahayanagi kanaleꞋya hutama maigahae. Tamayolegefafina nagola haviya ohugahigi tokiyaꞋage hutama hetitama maisayafe agola maige maige hisaya tamahaimula aligahae.” ");
INSERT INTO kmu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“KasagoꞋya kame ati vayaꞋmoꞋya Yelusalemu kumaꞋma kove kove hisagetama agesayana ani kumala ‘Ali hagagi-talegahae.’ hutama tamakesa havigahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Havisayana Yutia mainesaya veaꞋmogatama tamaiya-yetama agoꞋyalega viho. Yelusalemu mainesaya veaꞋmogatama tamaiya-yetama ani kumala ataletama viho. Hoyafinaga mainesaya veaꞋmoꞋya eteꞋya kumaꞋamilega omesae. ");
INSERT INTO kmu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ani kanafina mukiꞋa Anumaya Koti kema kae-malenaya kemoꞋa falote huno tamage hisiafe Anumaya KotiꞋa ani veala kefo yama humainaya anonaꞋa ali haviya humategahie. ");
INSERT INTO kmu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ani kanafina amaipaene aꞋnene nute ani-linesia nafaꞋnemogami itaꞋamimoꞋyaenefe tusiꞋa nahau nehie. Ani kanafina Isaleli kumala tusiya huno haviya hugahie. Isaleli veaꞋmoꞋya kefo yama humainaya anonatamia Anumaya KotiꞋa havi kavala hulamatesigetama tusiꞋa tamaugafa lamakata yana aligahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kame vayaꞋmoꞋya nagoꞋa veala ayaꞋaya naepeleti hataga hamaesageꞋya faligahae. NagoꞋa veala nofi humateteꞋya amavaleꞋya alu kotega Yuta veaꞋne omainaya veaꞋmogami kotega momategahae. Yuta vea omainaya veaꞋmoꞋya eꞋya Yelusalemu kumala mukiꞋa amaiyaleti ayelata-pesageno aposi-lavigahie. Aposi-lavisigeꞋya ani Yuta vea omainaya veala anile emaige maige huꞋya maisageno Yuta vea omainaya veaꞋmoꞋya kava yagaisaya kanaꞋamia haꞋno hugahie.” ");
INSERT INTO kmu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","YisasiꞋa nagoꞋene mage huno hie “Yagene kaꞋnefiꞋene ikamoꞋene kugava kava huno alu kava humaveligahie. Nagi hage limoꞋa ayepafa hulino ute ete hisia yafena mukiꞋa kotega ma mopafi veala tusiꞋa amamaꞋyo aigahie. ");
INSERT INTO kmu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","IkateꞋma hanea yamoꞋya kanage kanage huꞋya alu kate kate visaya yafena mukiꞋa ma mopafima mainaya veaꞋmoya ‘Na ya falote hugahe nehie?’ huꞋya nehisageno amaipamoꞋa kanaꞋage nehinageno amaulagamoꞋa kagi kagi hinageꞋya asaga hulavigahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","MukiꞋa ani yamaꞋa faloteꞋma hutesigeꞋna ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna siate elavisugeꞋya nagegahae. TusiꞋa himamu yaniꞋaene tusiꞋa hale yaniꞋaene esugetama nagegahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ani kugava yaꞋyaga aepama heno esigetamahena ‘Taugafa aligatisia kanamoꞋa ago aupaꞋa falote hugahe nehie.’ hutama hetitama tamanuna alisaka hutama ageho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","YisasiꞋa nago avame kea mage huno hamapaiye “Fiki yosaleꞋene afa yosaleꞋene ageho. ");
INSERT INTO kmu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ani yosamoꞋa haegafa haisama falote higetamahena ‘Anuna neꞋvalea kana falote hugahie.’ hutama nehae. ");
INSERT INTO kmu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","AniꞋa hugahianagi anima tamahapauva kugava yama agenutamahena ‘Anumaya KotiꞋa kava yagaisia kanamoꞋa ago falote hugahie.’ hutama havigahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nagaya tamage huꞋna tamahanepauve meni kanafima mainaya veaꞋnea ofalinesageno ani yaꞋyaga falote hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","IkaꞋene ma mopaene ago fanane hugahianagi nagai kemoꞋa fanane ohugahie. ");
INSERT INTO kmu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Tamakaitamile yagaiho. Havigu havili nelitetama nehutama havigu kave nesaya yafeꞋene tamaugafale yaꞋenefe tamakesa havi havi hisageno ani yamoꞋma aiso hulamatesiana ala kanomo kalifumoꞋma aupaꞋa hatea kava huno esigetamahena talo tala ohunesageno esigi kava yagaitama maiho. YisasiꞋa mukiꞋa ma mopafi veaꞋmogami amaulagale evaꞋyi hinageꞋya atali-talu hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ani yafena tamakaitami nagoke nagokemogatama kava yagaiho. MukiꞋa kanale tokiyama alisayafena nunamuna higeno ani tokiya tamamisigeno ani havi yama falote hisia kanafina Anumaya KotiꞋa tamaugafa aligatisigetama ikapinagati emainoa kanoa vayaꞋmo natenea kanomoni naule hetigahae.” huno hamapai-maine. ");
INSERT INTO kmu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","YisasiꞋa mukiꞋa kanafina ala mono nopi haino maineno humavenelino mukiꞋa kegela Olivi yosa hanea agoꞋyafi haino nemaiyane. ");
INSERT INTO kmu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Haino mainegeno koꞋma neleana mukiꞋa veala “Agai kema havigahune.” huꞋya mono nopina etele nehayane. ");
INSERT INTO kmu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ala imu negiya kanamoꞋa meupa higeꞋya ani imule hale oki kaihamena nenayane. Ani imua kafuꞋahe kafuꞋahe Anumaya KotiꞋma Yuta veaꞋmogami amakinago-mogamima amaugafa aligatimainea kanahe amakesa havi havi hisaya imu* alitalu huꞋya negiyane. ");
INSERT INTO kmu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ani kanafina mono note hagote kava vayaꞋene kahegi kema havilinaya anagaꞋene Yisasina haesaya kafe atiyayanagi vaya amaulagahe koli humainae. ");
INSERT INTO kmu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","5","Koli nehageno aupaꞋa SataniꞋa* Yutasi aipafi hai fale-maine. Yutasi IsakaliotiꞋa Yisasina tuelufuꞋa (12) anagaꞋene nemaiya kanogino neꞋamataleno viaꞋamo mono note kava vayaꞋene mono note ati kava vayaꞋene kea kea huno mage hie “Nagaya hanaꞋa kateti agesila huꞋna tamahapaisugetama Yisasina atafa hugahae?” huno higeꞋya muse huteꞋya “AniꞋama hisanageta mone hageta kamigahune.” huꞋya hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hapaigeno YutasiꞋa “E, kanalele” huno huteno vaya kulata oꞋaiya yate kesi kateti Yisasina movalesigeꞋya atafa hisaya kafe ati ayemaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hale oki kaihamema nenaya kanamoꞋa hagote yupa falote hie. Ani yupa amaugafama aligatimainea yafe amakesa ali hao hisayafe nagola sipi sipi nafaꞋneꞋa hemainae. ");
INSERT INTO kmu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","YisasiꞋa PitaꞋene YoniꞋene hunateno mage hie “Utana Anumaya KotiꞋma taginagomogami amaugafa aligatimainea yafe tagesa ali hao hisuna kavela utana talo tala hiꞋageta monamano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","HigeꞋana “Hana nopi mo lalo tala hisuꞋe huꞋageka nehane?” huꞋana havigaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","HaꞋageno YisasiꞋa mage huno hanapaiye “HaviꞋo ala kumate utana nago kanomoꞋa ti kema hefilino visia kanoene mo fotu hutetana akave utana haisia nopi haitana ani nomona nefafe mage hutana havigeꞋo ‘Hulavenelia kanomoꞋa kagaife mage huno kahavige ‘Hana nopi nagaiꞋene tokaeꞋya nemaiya anagaꞋmoꞋyaene Anumaya KotiꞋma taginagomogami amaugafama aligatimainea yafe tagesa ali hao hisuna kavela nesune?’ huno hie.’ hutana havigeꞋo. ");
INSERT INTO kmu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","HavigesaꞋageno folamo huno anayapi kimalenea nona ago alino hilato humalenea nona, ala nokefa, tanavelisigetana ani nopi kavetia talo tala hiꞋo.” huno hanapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","HanapaigeꞋana vaꞋana hia kemoꞋa mukiꞋa falote higeꞋana Anumaya KotiꞋa amaugafa aligatimainea kanahe amakesa havi havi hisaya kavela mo lalo tala humainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kave ne kanamoꞋa aupa higeꞋya YisasiꞋene agaiꞋaene tokaeꞋya nemaiya anagaꞋmoꞋyaene kave negahe folamole mainae. ");
INSERT INTO kmu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mainageno YisasiꞋa mage huno hamapaiye “Anumaya KotiꞋma taginagomogami amaugafama aligatimainea yafe tagesa ali hao hisuna kavela tamakaiꞋene tokaeta nesuna yafe tusiya huno nenahaiye. NeteꞋna tusiꞋa nagata aisigeꞋna faligahue. ");
INSERT INTO kmu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tamahapauve ma kavela nagoꞋene ma mopafi maineꞋna onegahue. Anumaya KotiꞋa agola tamaku tamamena aligatisigeꞋna ikapinaga eteꞋna negahue.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nagola nofi alagamo timo agia vainie. YisasiꞋa ani lima hanea keꞋayola alino Anumayamotega muse huno havigeteno mage huno hamapaiye “Ma keꞋayola alitama nete nete hiho. ");
INSERT INTO kmu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tamahanepauve menia ma vaini nofi alagamo tina* nagoꞋene onegahue. Anumaya KotiꞋma kava yagaisia kanamoꞋma falote hinageꞋna eteꞋna negahue.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","NaꞋa huteno kaihamena alino nunamu huno muse huno havigeteno kolite kolite huno neꞋamamino mage huno hie “Mamona nagaiꞋni naugafae. Tamakaife huꞋna naugafa atalesugetama mukiꞋa kanafina aniꞋa hutama nete nete nehutama nagaifena tamakesa havi havi hutama maiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","HigeꞋya ani kavela netageno vaini nofi alagamo tima* hanea keꞋayola alino aniꞋa huno Anumayamotega muse huno havigeteno alino amamite amamite nehuno mage huno hamapaiye “Ma lina nagai kolaniꞋae. NahaesageꞋna falisuana kolaniꞋamoꞋa tamakaifene huno take take hulavisiafe haegafa kea, Anumaya KotiꞋene hage-lafitama maisaya kea* alino fatago hugahie. ");
INSERT INTO kmu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Haviho vayaꞋmoꞋya havisagi huno nagaila nagesi huno kame hunatesia kanomoꞋa nagaiꞋene tokaeno mainegetaꞋa nagokepiti kavela alitaꞋa nenoꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna Anumaya KotiꞋma hunatenea kate ugahuanagi vayaꞋmoꞋya havisagi huno nagesi hunatesia kanomofena ‘AvoꞋnio nahau hanagi kagaya maigaꞋyo huꞋna nehue.’ huno humaine.” ");
INSERT INTO kmu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","HigeꞋya amakaiꞋami huge havige nehuꞋya mage hae “Ani kavala tagaipitila ta hugahie?” huꞋya mo havige me havige hae. ");
INSERT INTO kmu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","YisasiꞋenema tokaeꞋya nemaiya anagamoꞋya mage huꞋya hae “Ta tagaipina tagaseno ala kanoa maine?” huꞋya ani yateti ke vaimainae. ");
INSERT INTO kmu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ke neꞋvaigeno YisasiꞋa mage huno hie “Ma mopale ala kava vayamoꞋya kemamakiꞋya aliꞋya ke huneꞋamateꞋya ‘Tagaifela kayone huka kanale kava kanoe huꞋya hunatesae.’ huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nehayanagi tamakaya aniꞋa kavala ohiho. Tamakaipima agima hanesia kanomoꞋa osi nafaꞋnemoꞋma maiya avamete maisia kanomoꞋa kava kanotami maineno kayo kayo kano maisie. ");
INSERT INTO kmu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta ala kava kanoa maine? Mopale maineno kavela nenea kanofi? Kavela hatino neꞋamamia kanofi? AfaꞋa mopale maineno kaveꞋma nenea kanoa ala kano mainegi nagaya tamakaiꞋene maineꞋna kayo kayo hunelamatoe. ");
INSERT INTO kmu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","NagaiteꞋma havi kanama falote higetamahena tamakaya onataletama nagaiꞋene mainayane. ");
INSERT INTO kmu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ani yafena NenafaꞋa nagaife ‘Kava yagaigane.’ huno hunatenea kava huꞋna tamakaila ‘Kava yagaigahae.’ huꞋna nelamamue. ");
INSERT INTO kmu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","NaꞋa hisugetama kavama yagaisua kumaꞋnilela umainetama nagaiꞋene kavela nenetama kava vayaꞋmogami siale mainetama teniꞋa (10) Isaleli nofi veaꞋmogamite kava yagaigahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","Saimonifena mage huno hie “Saimonigae, Saimonigae havio SataniꞋa tamakayama nagaila natalesaya yafe tamakaila tamatafa huno ayelamavataga hisia yafe ‘Ani vayala namio.’ huno Anumaya Kotifena havigeanagi nagaya kagaifena Saimoniga nagaifema ‘TusiꞋa tokiyaꞋa hane.’ huka kagupi maleka kametiti humainana kea oꞋatalesanafe Anumaya Kotitega ago havigogi kaguꞋa aiyahae huka vayakamoꞋya nagaifema amakupi maleꞋya amametiti hisayafe amaya huo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Higeno SaimoniꞋa kenonaꞋa mage huno hie “AlaniꞋamogae nagaya kagaiꞋene kina hulaꞋateteꞋya taꞋahaesagetaꞋa faligahuꞋe huꞋna nagu nagesa talo tala nehue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Higeno YisasiꞋa kenonaꞋa mage huno hie “Pitaga kahanepauve meni kegela kokolemoꞋa agea oꞋainesigeka tagufa (3) kanale ‘Nagaya oꞋagenoa kanoe.’ huka avane hunategane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Huteno nagoꞋene mage huno hamapaiye “Monetamiene kutamiene tamaiya noꞋene oꞋalitama viho huꞋna hulamatogetama vayana nagoꞋa yafena aupa humainao?” huno higeꞋya “AꞋao mukiꞋa yana kanaleꞋya huta alimainone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hageno nagoꞋene mage huno hie “HagoteꞋna mani kea tamahapai-mainoanagi menia monetamima hanesimogatama alitama viho. Kutamima hanesi-mogatama alitama viho. AyaꞋaya naepetamima omalesi-mogatama kenatamia alu kanomona amisageno anonaꞋa ayaꞋaya naepea tamamisie. ");
INSERT INTO kmu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","NaꞋafene nagaya tamahanepauve nayona Anumaya Koti kefima kae-malenaya kemoꞋa mage huno kae-maleneane ‘VayaꞋyagamoꞋya agaifena mage hae ‘Havi kavakeꞋya nehia kano maine.’ huꞋya hae.’ huꞋya kae-malenayanagi nagaiꞋma hunatesaya kavaꞋma hisagenoꞋa ani kemoꞋa falote hisigeꞋya ‘Tamage humaineane.’ huꞋya hugahae.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","HigeꞋya mage hae “Alatimogae ago tole ayaꞋaya naepea ma hane.” huꞋya hageno kenonaꞋamia mage hie “Haile.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","YisasiꞋa kumala ataleno mukiꞋa kanafi nehia kava huno Olivi yosa hanea agoꞋyafi haigeꞋya agaiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya akave haimainae. ");
INSERT INTO kmu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ago anilega uvaꞋyi huteꞋya mage huno hamapaiye “Anumaya Kotitega nunamu hutama havigeho ‘SataniꞋma ayelavataga hisia yapina tavaleka oꞋvuo.’ hutama havigeho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Ani kea huteno neꞋamataleno viaꞋamo vayaꞋmoꞋya yafama hagaꞋyu hutalageno neꞋvia avamete viaꞋamo aleꞋya moye maineno Anumayamotega mage huno havige “Nenafagae falisua kava nehugi kahaisigekahena ani havi kanamoꞋa satuꞋage hia ti kana ti hanea keꞋayola nahafalo. AfaꞋa nagai nagu nagesa akave ohuka kahaisia kavala huo.” huno havige-maine. ");
INSERT INTO kmu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nehigeno ikapinagati nago ensole kanomoꞋa tokiya memine. ");
INSERT INTO kmu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Memigeno YisasiꞋa augafafinaga malageno ageana tusiꞋa kanaꞋage haiya yafe Anumayamotega nagoꞋene tusiya huno havinegegeno amuꞋnamoꞋa kolamoꞋma hia kava huno mopafina take take hulavimaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Take take nehigeno Anumayamotega havigeteno hetino mogeana agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya hamauma haya yafe ago fae-mainageno momake-maine. ");
INSERT INTO kmu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Momaketeno mage huno hie “Ae faetamage mainao? Hetitama SataniꞋa ayelama-vataga hisigetama asaga hu otavisaya yafena Anumayamotega nunamuna hutama havigeho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ani kea nehigeꞋya kasagoꞋya vaya evaꞋyi hageno YutasiꞋa tuelufuꞋa (12) anagapi tokaeno nemaiya kanomoꞋa amavaleno Yisasina me tako hugahe emaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","NeꞋegeno YisasiꞋa mage huno hie “Yutasigae natako hisana yateti nagaila ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia nagesi huka kame vaya amayapi nategahe nehano?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","NehigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya haya kavala ageteꞋya mage hae “Alamogae ayaꞋaya naepeleti hamaesuno?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nehageno amakaipiti nago kanoa ala mono nopima hagote kava kanomona aliꞋya kanoꞋamona ayaꞋaya naepeleti tamaga kaiyaga agesa aifakali-talegeno asaga hulavimaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aifakaligeno YisasiꞋa mage hie “Tu hisaya kavala ohiho.” huno nehuno ayana ani agesamo aepale maleno agesa alino kanale hutene. ");
INSERT INTO kmu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Alino kanale huteteno mono note kava vayafeꞋene ala mono note ati kava vayafeꞋene Yuta vayatamaene agaiꞋma atafa hugahe aya vayaꞋmogamifeꞋene YisasiꞋa mage huno hamapaiye “Tamakaya nagaifena ‘Vaya nehamaeno musufaya nehia kano maine.’ hutama ayaꞋaya naepene muki kaꞋyoꞋene alitama neꞋao? ");
INSERT INTO kmu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nagaya mukiꞋa kanafina efi efi huꞋna tamakaiꞋene ala mono nopina nemauvanagi natafa ohunayane. Anumaya KotiꞋa meni kana tamayapi malegetama SataniꞋa hani yamo nefaꞋa aliꞋya alisia kanamoꞋa ago falote humaine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Atafa huꞋya mono note hagote kava kanomo* kumate avaleꞋya vageno PitaꞋa akave anatino vianagi avatela oꞋunegi ago aluꞋale umaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","UmainegeꞋya ani no kegiꞋya kovefi ata kae-maleteꞋya mopale mainageno PitaꞋa amakaiꞋene mopale umaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ata anefete mopale mainegeno nagola aliꞋya munaꞋmoꞋa Pitana ageke huno ageteno mage hie “Ma kanoa YisasiꞋene vaiyatete nehia kanoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Higeno PitaꞋa avane huno mage hie “AꞋao ma munaꞋmoga nagaya oꞋagenoa kanohe nehane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","OsiꞋa maigeꞋya nago kanomoꞋa Pitana ageteno mage huno hie “Kagaya YisasiꞋene tokaetana nemaiꞋa kano mainane.” huno higeno PitaꞋa mage hie “AꞋao ma neꞋmoga nagaya oꞋagenoa kanohe nehane.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","OsiꞋa maigeꞋya nago kanomoꞋa tokiyaꞋage kefiti mage huno hie “Tamage huꞋna tamahanepauve ma kanoa Kalili kanoe. YisasiꞋene vaiyatete nehia kano maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Higeno PitaꞋa mage huno hie “Ma neꞋmoga nagaya ohavinoa kehe nehane.” huno nehigeno anile aupaꞋa kokolemoꞋa agea aimaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Age aigeno AnumayamoꞋa maiyahae huno Pitana ageke huno agegeno Pitana agesamoꞋa aikalo higeno YisasiꞋma hapaigeno havimainea kea mage huno humaineane “Meni kegela kokolemoꞋa agea oꞋainesigeka kagaya tagufa (3) kanale avane huka nagaila ali falakigane.” huno humainea kehe Pitana agesamoꞋa aikalo higeno haviteno hatilavino viaꞋyamo tusiꞋa avi motemaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Yisasima atafa humainaya vayaꞋmoꞋya kigi huneꞋateꞋya akaya ateꞋya kaꞋyo aikoneliꞋya aulagafina kenaleti nofi kisalu kiteneꞋya mage huꞋya hae “Kaune laga nehana kanogi tahapaiyo taꞋya negahayae?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","NagoꞋene alu ke alu ke huꞋya kigi huneꞋateꞋya akaya atenae. ");
INSERT INTO kmu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","KotigeꞋya Yuta vayaꞋmogami vayatamaene mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene kanisolefi melitalu huteꞋya Yisasina avaleꞋya anile umaineꞋya Yisasifena mage huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Tahapaiyo kagaya Anumaya KotiꞋa taugafa aligatigahie huno hugatenea kano mainano?” huꞋya hageno YisasiꞋa kenonaꞋamia mage hie “Nagayama tamahapaisugetamahena ‘Tamage nehane.’ hutama ani kea havitama tamakupina omalegahae. ");
INSERT INTO kmu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nagaya nago kema tamahavigesugetamahena kenonaꞋania nahaꞋopaigahae. ");
INSERT INTO kmu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Meni aepa heno ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna tusiꞋa himamuꞋa hanea Anumaya Kotina aya tamaga kaiyaga hanea siale umaineꞋna agola maige maige huꞋna maigahue.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","HigeꞋya mukiꞋa anile melitalu huꞋya mainaya vayaꞋmoꞋya mage huꞋya hae “Kagaya ani kea nehananagi Anumaya Kotina nafaꞋneꞋamoga mainano?” huꞋya havigageno “Tamakaya nagaifena tamage nehae. ‘Ani kano mainane.’ hutama nehae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","HigeꞋya mage hae “AgaiꞋa avayafiti ago haesuna kea hufalote higeta havune. Havigu nagoꞋa vayaꞋmoꞋya nagoꞋa kea agaifena tahapaiyafenagita alu vayaꞋmogamifena ke ohisune.” huꞋya humainae ");
INSERT INTO kmu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","MukiꞋa kanisolefi metalu huꞋya mainaya vayaꞋmoꞋya hetiꞋya Yisasina avaleꞋya ala kava kanoa, Pailatite umainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","AvaleꞋya umaineꞋya aepa heꞋya “Ma kava huno kefo kavala humaine. Tagaya agonana mani kanomoꞋa tagai nofi vayafena mage hie ‘Kamani vayaꞋmogami kea neꞋataletama havi kava hiho.’ huno nehuno tagaifena ‘Takisi neꞋamamiya yana Sisana oꞋamiho.’ huno nehuno ‘Nagaya nagaiꞋniꞋa KalaisiꞋna, Sauve kano mainoe.’ huno humaine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hageno PailatiꞋa Yisasifena mage huno havige “Kagaya Yuta nofi vayaꞋmogami SauveꞋami mainano?” huno havigegeno YisasiꞋa mage hie “KagaikaꞋa mani kea hai nehane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Higeno PailatiꞋa mono note kava vayafeꞋene mukiꞋa alitalu huꞋya mainaya vayafeꞋene mage huno hamapaiye “Kefo kavaꞋma hu-mainesiafene huꞋna atiyoana nago yamaꞋa omale.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","HigeꞋya tokiyaꞋage kefiti mage huꞋya hae “MukiꞋa Yutia kotega ute ete nehuno veafena mage humaine ‘Kamani vayaꞋmogami kea neꞋataletama ma kava hiho.’ huno humaveligeꞋya veaꞋmoꞋya ‘Ani kava humategahune.’ huꞋya hae. Kaliliti ani kavala aepa heno hulino hulino menia male neꞋe.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","PailatiꞋa ani kea haviteno mage huno hamavige “Ani kanoa Kalili kano maineo?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","HamavigegeꞋya “E, ani kumateti kanoe.” huꞋya hageno “Heloti kava yagaimainea kotegati kanoe.” huꞋya hageno haviteno hutegeno Helotite umaine. Ani kanafina HelotiꞋa Yelusalemu nemaiyane. ");
INSERT INTO kmu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","HelotiꞋa Yisasina ageteno tusiꞋa muse hie. Avagema haviana “TokiyaꞋage avameꞋya yana nagoꞋa hinageꞋna agesue.” huno nehuno ayaꞋaya kanale Yisasina agesia agesa havianagi noꞋageane. ");
INSERT INTO kmu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yisasina ageteno mukiꞋa kehena havige havige hugeteana YisasiꞋa nagola osi ke kanoꞋa ohune. ");
INSERT INTO kmu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ke ohuno maigeꞋya mono note kava vayaꞋene kahegi kema havilinaya anagaꞋene anile hetiꞋya maineꞋya tusiꞋa ke nehuꞋya “Na kava ma kava huno kefo kavala humaine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hageno HelotiꞋene ati vayaꞋamoꞋyaene Yisasina huhaviya huteteꞋya kigi huteꞋya kamuge hatageꞋya vaineꞋateꞋya nagola kanale kena aliꞋya me faitetageno HelotiꞋa Yisasifena “Pailatite etetama avaletama viho.” huno humatene. ");
INSERT INTO kmu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","HelotiꞋene PailatiꞋene kame kanolata mainaꞋaleti ani yupa anakaya ali konaga ayemainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","PailatiꞋa mono note kava vayafeꞋene Yuta vayaꞋmogami kava vayafeꞋene vayaꞋyagamogamifeꞋene ke higeꞋya melitalu hageno mage huno hamapaiye “Tamakaya ma kanomofena ‘Kefo kava huno veafena ‘Kamani vayaꞋmogami kea neꞋataletama havi kava hiho.’ huno hamapai-maine.’ hutama nehutama nagaifena kaiyeke hutesane hutama avaletama ayanagi nagaya tamakai tamaulagafima havigoana ‘Kefo kavaꞋma humaine.’ hutama haya kavala tamage huno kefo kavala ohune huꞋna nehue. ");
INSERT INTO kmu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","17","AguꞋafina agoanagino HelotiꞋa aniꞋa huno ageana tagaitefe ‘Eteka vuo.’ huno hutegeno eanagi ageho mani kanoa falisia augafa kefo kavala ohuneafe afaꞋa kaꞋyo amiꞋna aumono maleteꞋna atalesugeno visie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hianagi mukiꞋa alitalu humainaya veaꞋmoꞋya ailulupeꞋya mage hae “Yisasina haegeno falino. Tagaya Palapasife nofipiti haꞋno hisie huta nehune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ani PalapasiꞋa ala kumate vayaꞋyagamofe mage hie “Kava vayaꞋene tu higetao.” huno huteno nago kanoa haegeno falimainea yateti avaleꞋya kina hutenaya kanogiꞋya agaife ani kea hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hageno PailatiꞋa “Yisasina atalesugeno afaꞋa visie.” huno agesa havia yafe nagoꞋene ke huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","HamavigegeꞋya ala kefiti mage hae “Yafaga yosale nili hetama asaigeno falino. Yafaga yosale nili hetama asaigeno falino.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hageno PailatiꞋa nagoꞋene eteno mage hie “NaꞋa higetama ani kea nehae? HanaꞋa kefo ya humaine? Nagaya atiyoana falisia kefo augafa kavala ohuneafe afaꞋa kaꞋyo amiꞋna aumono maleteꞋna atalesugeno visie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ani kea hianagi amakaya tusi tokiyaꞋage kefiti mage huꞋya hae “Yafaga yosale nili hetama asaigeno falino.” huꞋya tokiyaꞋage kegeꞋya hageno PailatiꞋma hia kemona amakai kemoꞋa hefalaki-maine. ");
INSERT INTO kmu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","KeꞋamona hefalakigeno PailatiꞋa haya ke haviteno Yisasifena “Yafaga yosale nili hetama asaigeno falino.” huno ati vayala hamapaimaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","PalapasiꞋa vayafe “Kava vayaꞋene tu higetao.” huteno nago kanoa haegeno falimainea yateti avaleꞋya kina hutenaya kanoa tutu haya yafe PailatiꞋa “HaꞋno hanagi vuo.” huno huteanagi mukiꞋa vayaꞋmoꞋya Yisasifena “Yafaga yosale nili hetama asaigeno falino.” huꞋya haya kemo akave malene. ");
INSERT INTO kmu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yisasina avaleꞋya katega neꞋuꞋya Sailini SaimoniꞋene mo fotu humainae. SaimoniꞋa hoyafinagati kate eneꞋvigeꞋya ati vayaꞋmoꞋya motafa huꞋya yafaga yosa aliꞋya ayoꞋnale kofiteteꞋya “Yisasi akave kofika vuo.” huꞋya hutenae. ");
INSERT INTO kmu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","MukiꞋa veaꞋmoꞋya akave neꞋvageno aꞋnemoꞋya avi neꞋateꞋya hamau hume hume akave umainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","NeꞋvageno YisasiꞋa maiyahae huno amaketeno mage hie “Yelusalemu mainaya aꞋnemogatama nagaifene hutama avia oꞋateho. Avima ategahena tamakaitamihe neꞋatetama nafaꞋneyagatamimofeꞋene avia atemateho. ");
INSERT INTO kmu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Haviho haenagaꞋa nago kana falote hisigeꞋya mage huꞋya hugahae ‘Namo aꞋnemogatama nafaꞋne oꞋatetama numa noꞋamisaya yafena tusiꞋa muse hutama maiho.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ani kanafina aepa heꞋya ala agoꞋyamofena mage huꞋya hugahae ‘Kolilavika aiso hulato.’ huꞋya hugahae. Osi agoꞋyahena ‘Mehi alika aiso hulato.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nagaya haegafa ata kana huꞋna mainoa kanoe. Kefo yana tamage huꞋna ohunoa kano mainogeꞋya mani kavala hunenatayanagi tamakaya avaifa ata kana hutama kefo kava nehaya veaꞋne mainayafe na kava hulamategahae?” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yisasina haegahe avaleꞋya neꞋuꞋya tolea kefo yama humainaꞋa kanolataꞋene hanaegahe anavaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Anu ayamufae huꞋya nehaya kumate avaleꞋya uteꞋya yafaga yosale nili haeꞋya asaimainae. Tole kefo yama humainaꞋa kanolatane nago kanoa Yisasina tamaga kaiyagaꞋa haeꞋya asaimaleꞋya nago kanoa haoga kaiyagaꞋa haeꞋya asaimaleꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","YisasiꞋa Anumayamotega ke huno mage huno hie “Nenafagae mani vayaꞋmoꞋya kefo yama haya kavala ‘NaꞋa kava nehune.’ huꞋya havilama ohaya yafe aigeꞋamateka kefo yaꞋamia atalemato.” huno humaine. HigeꞋya ati vayaꞋmoꞋya kenaꞋa aligahe musufayama nehaya yokalo lageno amakaseno haiya kanomo alimaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","AligeꞋya veala alitalu huꞋya hetiꞋya aulu heꞋya mainageꞋya kava vayaꞋmoꞋya kamuge hatageꞋya vaineꞋateꞋya mage hae “NagoꞋa veala amaugafa aligatimainea kanogi Anumaya KotiꞋma hau ayamopafi nehaiya kanoa taugafa aligatigahie huno hutenea kanoma mainesiana agaiꞋa augafa aligatino.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","38","AnuteꞋma kaeꞋya malaya avomoꞋa mage huno hie “Mani kanoa Yuta veate ala Sauve kanoe.” huꞋya kaeꞋya malenae. MalenageꞋya ati vayaꞋmoꞋya aniꞋa huꞋya kamuge hatageꞋya vaineꞋateꞋya atuꞋage nofi alagafiti tina neꞋamiꞋya mage hae “Kagaya Yuta vayate sauve kanoꞋamima mainesanana kagaikaꞋa kaugafa aligatio.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nagola kefo yama humainea kanoa yafaga yosale nili heꞋya asaimalaya kanomoꞋa Yisasifena hu-haviya huteno mage huno hie “Anumaya KotiꞋma taugafa aligatigane huno hugatenesia kanoma mainenuka kagaikaene taꞋagaiꞋene yosaleti ali hakao hugeta tavimano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Higeno nagola kefo yama higeꞋya yafaga yosale nili heꞋya asaimalaya kanomoꞋa ani kea haviteno kemakino mage huno hie “Vae kagaya Anumaya Kotifena kolia nohuka ani kea nehano? Kefo yama humainoꞋa anonaꞋa nagopi taꞋagaila nilia laꞋahaeꞋya asailaꞋa-tenayanagitaꞋa faligahuꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","TaꞋagaya kefo yatiꞋamo anonaꞋa fatago kava hayanagi ma kanoa nagola osi kefo yamaꞋa omalene.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nehuno ani kanomoꞋa Yisasifena mage huno hie “Yisasiga kava yagaigahema esana kanafina nagaifena kagesa havi namio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Higeno YisasiꞋa kenonaꞋa mage huno hie “Tamagelafa huꞋna kahanepauve meni kanoꞋa nagaiꞋene kanale maige maige hisaya kumatela tokaetaꞋa umaigahuꞋe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Anile yagemoꞋa euno amuꞋnokaꞋno higeno halemainea yamoꞋa haꞋno higeno mukiꞋa kotega tusiꞋa hanikino viaꞋyamo une kanalega eteno ali halemaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ani hanimo aguꞋafinaga ala mono nopima asaimalenaya kenagefamoꞋa* amuꞋnopiti aipa hulole humaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aipa hulole higeno YisasiꞋa ala kefiti mage huno hie “Nenafagae nagu nafaꞋnea kagai kayapi nemaloe” huno nehuno haimula atalegeno vigeno falimaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Faligeno ati vayate kava kanomoꞋa anile maineleti mukiꞋa yama hia kavala ageteno Anumaya Koti agi alisaga nehuno mage huno hie “Tamage mani kanoa kefo yana nohia kanoe.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","“Na kava hutesafi agetetae.” huꞋya melitalu humainaya veaꞋmoꞋya mukiꞋa humainea kavala ageteꞋya tusiꞋa hamau huneꞋateꞋya havi kafa yogime yogime noꞋamilega ataleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vayanagi mukiꞋa veaꞋmoꞋyaene Kaliliti akave emainaya aꞋneyagaene aluꞋale hetiꞋya maineꞋya hutaya kavala agemainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nagola fatago kanoa YosefeꞋe, Yuta vayaꞋmogami Kanisolefi maineanagi “Yisasina haegahune.” huꞋya haya kehena “E, kanalele.” huno ohunea kanoa Yuta veaꞋmogami kotega Alimatiyae huꞋya nehaya kumate nemaiya kanogino Anumaya KotiꞋma kava yagaisia kanahe muse huno agava nemaiya kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ani kanomoꞋa Pailatite viaꞋyamo mage huno havige “Yisasina augafaꞋa aligahe nehue.” huno havige. ");
INSERT INTO kmu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Havigegeno PailatiꞋa “E” higeno yafaga yosaleti haino ali hakao hulino elavino memaleneno kenaleti augafalela aigalaki kalaki huno haꞋya kiteno alino viaꞋyamo he falageꞋya kafimalenaya yafa kane, anifina vayala hevai oꞋamatenaya yafakapima alino mo hevaitene. ");
INSERT INTO kmu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ani yupa Sapatihe haviꞋya talo tala hisaya kanagino Sapatia ago evaꞋyi hugahe higeno YosefeꞋa ani kavala humaine. ");
INSERT INTO kmu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","HigeꞋya Kaliliti YisasiꞋene tokaeꞋya emainaya aꞋneyaga Yosefe akave uꞋya yafakapima hevaitea yana mogemainae. ");
INSERT INTO kmu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","MogeteꞋya ayaꞋamoꞋya augafaleꞋma faletesaya yana manaꞋage tiꞋene masaveꞋene talo tala nehageno Sapati kanamoꞋa evaꞋyi higeꞋya kahegi kemo akave maleꞋya maifalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sota yupa kola otinegeꞋya ani aꞋneyaga ago talo tala humalenaleti manaꞋage masavena aliꞋya Yisasina hevaitenaya komulega umainae. ");
INSERT INTO kmu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","UꞋya mogayana komumo avayaleꞋma aiso humalaya yafana ago alikeli-talenageno avayalela omalegeꞋya ani yafakapi hai faleꞋya mogayana Yisasi augafa omalegeꞋya mogemainae. ");
INSERT INTO kmu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Omalea yafe “Hanate hane?” huꞋya tusiꞋa amakesa nehavigeno anile tole kanolatana efeꞋage huno alave alave hia kena failiꞋana evaꞋyi haꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","EvaꞋyi haꞋageꞋya aꞋneyagamoꞋya ageteꞋya tusi koli huꞋya ape hageꞋana ani tole kanolatamogania mage huꞋana haꞋe “NaꞋa higetama afaꞋa mainea kanohena falimainaya vayaꞋmogami matimatipina ati neꞋayae? Mafina omaigi fali-mainefitila ago hetino umaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kalili mainenoꞋma tamahapai-mainea kea tamakesa hinagetama haviho. ");
INSERT INTO kmu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mage huno humaineane ‘Ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia kefo kava nehaya vayaꞋmoꞋya natafa huteꞋya yafaga yosale nili nahaeꞋya nasaisageꞋna faligahue. FalisugeꞋya komufi hevainatesageꞋna tole kana maiteꞋna fali-mainesufiti eteꞋna hetigahue.’ huno humaineane. Ani kehena tamakesa havitama havilama hutama haviho.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","HaꞋageꞋya YisasiꞋma humainea kehe amakesa haviteꞋya matimatila ataleꞋya vayaꞋamoꞋya agaya yaꞋene haviya kene Yisasina aleveniꞋa (11) anagaꞋamoꞋyaene nagoꞋa veaꞋene hamapai-mainae. ");
INSERT INTO kmu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Magatala kumate MaliaꞋene YohanaꞋene Yemesina itaꞋamoꞋa MaliaꞋene nagoꞋa aꞋneyagaene YisasiꞋenema tokaeꞋya nemaiya anagala hamapai-mainae. ");
INSERT INTO kmu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hamapaiyanagi amakesa haviteꞋya “Afa ke nehae.” huꞋya nehuꞋya amakupi maleꞋya amametitia ohunae. ");
INSERT INTO kmu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amametitia ohayanagi PitaꞋa hetino aiyayeno hevaitenaya yafakapi mope humaineno ageana Yisasina aye-gasagitenaya kenaꞋage mogeteno agesa havi havi huno nomaꞋalega eteno umaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ani kanafina YisasiꞋenema tokaeꞋana nemaiꞋa kanolatana Emeasi kumate ugahe katega vaꞋana anima vaꞋa kamoꞋa Yelusamuti Emeasi umainea kamoꞋa osiꞋa ayaꞋayaꞋa aleveniꞋa (11) kilomita hane. ");
INSERT INTO kmu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ani tole kanolatana katega neꞋuꞋana ani kanafima humainaya kavafe kea kea hume hume umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","NeꞋuꞋana ani yafe kea kea hume hume neꞋuꞋana agaila havigegeno agaila havigegeno hume neꞋvaꞋageno YisasiꞋa evaꞋyi huno anakave eno anakaiꞋene tokaeꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","NeꞋuꞋya anakaya agaꞋanagi anaulaga alino aiso higeꞋana Yisasina agelama huꞋana oꞋagenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Agelama ohaꞋageno YisasiꞋa mage huno hanavige “NaꞋafe kea kea hume hume neꞋvaꞋe?” huno hanavigegeꞋana anile hetiꞋana maineꞋana anaugosa ayegatule-taleꞋana mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nago kanomo agia KaliopasiꞋa mage huno hie “Kagaya Yelusalemu kumate natu kano mainano? MukiꞋa natu umainaya veaꞋmoꞋya ani kanafima falote humainea kavala ago agemainayanagi kagaikage oꞋagenano?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Higeno YisasiꞋa mage huno hanavige “Na kavafe nehaꞋe?” huno hanavi-gegeꞋana mage huꞋana haꞋe “Nasaleti Yisasi kehena ohavino? Ani kanoa aune kano maineanagino Anumaya Koti aulagafiꞋene veaꞋmogami amaulagafiꞋene tusiya huno tokiyaꞋage yana talo nehuno tusiꞋa hetofa ke tahanepaiya kanoe. ");
INSERT INTO kmu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tahanepaiya kanogi tagai mono note kava vayaꞋene kava vayatiene atafa huꞋya kaiyeke huteteꞋya ‘Faligane.’ huꞋya yafaga yosale nili haeꞋya asaigeno falimaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","23","Fali-maineanagi tagaya agaifena Anumaya KotiꞋa taugafa aligatigahe hutegeno emainea kanoe huta tametiti nehune. Nago yana olaga kanoꞋa hae-mainayanagi menia tagaiꞋene nemaiya aꞋnemoꞋya natekefa hatilaviꞋya Yisasina hevaitenaya komulega mogayana Yisasina augafa omalegeꞋya mogeteꞋya eteꞋya eꞋya mage huꞋya me lahapaiye ‘Tagaya ensole kanolata agonageꞋana mage huꞋana tahapaiꞋe ‘YisasiꞋa ago hetimaine.’ huꞋana haꞋa kea tahapaigeta neꞋone.’ huꞋya me hageta tagaya tusiya huta atalitalu humainone. ");
INSERT INTO kmu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Atalitalu hunanagi nagoꞋa tagaiꞋene nemaiya vayaꞋmoꞋya ani komulega uꞋya mogayana aꞋneyagamoꞋyama haya kemoꞋa mukiꞋa tamage hae. Ani kavala humaineanagi Yisasina oꞋagenae.” huꞋana hapaiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hapaigeno YisasiꞋa mage huno hie “Tanakaya tanakesa nohaviꞋe. MukiꞋa kema Anumaya Koti amaune vayaꞋmoꞋyama kae-malenaya kea havilama hutana tanakupina omalenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anima amaune vayaꞋmoꞋya mage huꞋya kae-malenayane ‘Anumaya KotiꞋa taugafa aligatigahema hutesia kanomoꞋa tusiꞋa augafa agata aisia yana aliteno tokiya hale yamaꞋaene kumaꞋalega eteno ugahie.’ huꞋya kae-malenaya kea ohavinaꞋo?” huno hanavige. ");
INSERT INTO kmu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nehuno MoseseꞋma kae-malenea kemona aepa heno mukiꞋa Anumaya Koti amaune vayaꞋmoꞋya agaifema kae-malenaya kemo aepaꞋa hugafino hanapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","HanapaigeꞋana ugahema vaꞋa kumatela ago uvaꞋyi haꞋageno YisasiꞋa nagoꞋene hume hume ugahe hianagi anakaya atafa huꞋana mage haꞋe “TaꞋagaiꞋene faegane. YagemoꞋa ago tavifalesigeno aupaꞋa hani kigahie.” huꞋana haꞋageno anakaiꞋene faigahe noꞋanifinaga haifalemaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","31","Haifaleno mopale maineno anakaiꞋene kave negahe kaihame kana maya alino nunamu huno muse huteno aposino neꞋanamigeno anile anaulagamoꞋa aigali higeꞋana Yisasina agelama nehuꞋana “Agayamagae.” huꞋana nehaꞋamaꞋa anile fanane higeꞋana nagoꞋene Yisasina noꞋagaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ani yafena anakaiꞋani mohu mehu huꞋana mage haꞋe “Vaeha taꞋagaya katega neꞋoꞋageno agaya kanale kea taꞋahapaino Anumaya Koti ke kae-malenaya autaꞋmafi hanea kemona aepaꞋa hugafino taꞋahapaigeno taꞋaipamoꞋa hetigeno taꞋaguꞋamoꞋa tusiꞋa muse hie.” huꞋana haꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","HuteꞋana aupaꞋa hetiꞋana eteꞋana Yelusalemu vaꞋana Yisasina aleveniꞋa (11) anagaꞋamoꞋyaene nagoꞋa veaꞋyagaene alitalu huꞋya mainageꞋana momake-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","MomakaꞋageꞋya mage huꞋya hanapaiye “Tamage AnumayatimoꞋa fali-mainefitila ago hetigeno SaimoniꞋa agemaine.” huꞋya hanapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","HageꞋana anakaya kategama humainea kavaꞋmo avagea hamapaiꞋana mage haꞋe “Kaihame maya alino aponesigeno anile taꞋaulagamoꞋa aigali higetaꞋa Yisasina agelama hutaꞋa agoꞋe.” huꞋana hamapaiꞋe. ");
INSERT INTO kmu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ani kea maiꞋana nehaꞋageno amuꞋnoꞋamifi mo hetimaineno mage huno nehie “TamaipamoꞋa yasi nehinagetama maiho.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","HamapaigeꞋya amakaya tusiꞋa koli nehuꞋya atalitalu haya yafe Yisasifena “Hakalo emaine.” huꞋya tusiꞋa koli hae. ");
INSERT INTO kmu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Koli hageno YisasiꞋa mage hie “NaꞋa higeno tamaipamoꞋa kanaꞋage nehie? NaꞋa higeno tamakesamoꞋa tole-lole nehae? ");
INSERT INTO kmu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tamakaya nayaꞋene naiyaleꞋene ageho. Nagayamagae nagaiꞋniꞋa emainoe. Naugafalela navate hutama ageho. HakaloꞋmona augafa ameꞋene ayamufaene omalenegi nagaila naugafa nameꞋene nayamufaene hanegi neꞋagao.” huno hamapaiye. ");
INSERT INTO kmu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ani kea nehuno aiya ayana amavelie. ");
INSERT INTO kmu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","AmaveligeꞋya ageteꞋya tusiꞋa muse nehuꞋya “Tamage nehifi havige nehie?” huꞋya tole amakesa haviꞋya amakesa havi havi nehageno mage hie “Nesua kavela haneo?” huno hamavige. ");
INSERT INTO kmu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Hamavi-gegeꞋya atafi kaemale noyame aliꞋya amigeno alino amaulagafi mata mata huno nemaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","YisasiꞋa mage hie “TamakaiꞋenema tokaeꞋna mainoa kanafina mage huꞋna tamahapai-mainoe ‘MukiꞋa nagaifema MoseseꞋma kae-malenea kene Anumaya Koti amaune vayaꞋmoꞋya kaemalenaya kene Yagame Avopi kaemalenaya kene mukiꞋa anima kae-malenaya kemoꞋa falote huno tamage hugahie.’ huꞋna tamahapai-mainoane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Huteno anima kae-malenaya kemoꞋa amakesa halenegeꞋya havilinae. ");
INSERT INTO kmu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Havilinageno “Mage huꞋya kae-malenayane ‘Anumaya KotiꞋa tamaugafa aligatigahema hutesia kanomoꞋa tusiya huno agata aisigeno falisigeꞋya hevaitetesageno tole kana augafamoꞋa komufinaga haneteno fali-mainesifitila eteno hetigahie.’ ");
INSERT INTO kmu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hetisigetama tamakaya Yelusalemu aepa hetama mukiꞋa mopale kumaꞋyagalega ute ete hutama mage hutama hamapaiho ‘YisasiꞋa tamaku tamamena ago aligatiafe tamakesa havitama kefo yatamihena tamakuꞋa aiyahae hisagenoꞋa Anumaya KotiꞋa aigetamateteno kefo yatamia atalelamategahie.’ hutama hamapaisayafe kae-malenayane. ");
INSERT INTO kmu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","MukiꞋa tamaulagafiti agemainaya kavafena hamapaiho. ");
INSERT INTO kmu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Haviho nagaya NenafaꞋma ‘Tamamigahue.’ huno humainea kanomona Alu Aotage Avamula tamakaite hutesugeno egahie. Egahianagi tamakaya mani ala kumate mainegeno eno anafinagati tokiya tamamisigetama alitetama nagaifena mo hamapaiho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Ani kea huteno amavaleno Petani kumate umaineno ayana alisaga huno mage huno hie “Anumaya KotiꞋa tokiyaꞋaleti tamaya hisie.” huno nehigeno Anumaya KotiꞋa avalegeno ikapinaga haimaine. ");
INSERT INTO kmu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","HaigeꞋya Yisasi agia alisaga nehuꞋya tusiꞋa muse hume hume Yelusalemu eteꞋya umaineꞋya muki kanafina efi efi huꞋya ala mono nopi maineꞋya Anumaya Koti agia alisaga humainae. ");
INSERT INTO kmu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","EheꞋma Anumaya KotiꞋma ma mopama taloma ohunea kanafina Yisasina nago agia KemoꞋe huno maineane. Anumaya KotiꞋene tokaeꞋana mainaꞋane. Ani KemoꞋa, YisasiꞋe, Anumaya KotiꞋene nagoꞋya hu-mainaꞋane. ");
INSERT INTO kmu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","MainaꞋageno ehe kanafina ani kanoa Anumaya KotiꞋene tokaeꞋana mainaꞋane. ");
INSERT INTO kmu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anumaya KotiꞋa hapaigeno YisasiꞋa mukiꞋa yana talo hu-maleneane. YisasiꞋa nago yana talo ohunea yana omalene. ");
INSERT INTO kmu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ani YisasiꞋa mukiꞋa veala hamaimu neꞋamamia kano maineanagino ani haimuꞋamoꞋa veala aye hale-ma-te yamaꞋa hane. ");
INSERT INTO kmu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ani hale yamoꞋa haniki mainea yapina aye hale-mainegeno hani-ki-mainea yamoꞋa alino asu ohune. ");
INSERT INTO kmu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anumaya KotiꞋa nago kanoa hu-tegeno emaine. Ani kanomo agia YoniꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ani kanoa hale yamo ke hama-paigahe emainegeꞋya agai keleti mukiꞋa veaꞋmoꞋya hale yafe “Tamage hane.” huꞋya agaife amakupi maleꞋya ametiti hisaya yafe emaine. ");
INSERT INTO kmu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","YoniꞋa hale yamona aepaꞋa omainegi afaꞋa hale yamona aepaꞋa hanea kanomofe hama-paigahe emaine. ");
INSERT INTO kmu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ani tamage hale yamaꞋa ma mopale eno mukiꞋa veaꞋne aye hale-ma-tegahe emaine. ");
INSERT INTO kmu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ani YisasiꞋa ma mopama talo hu-malenea kano emaineanagi ma mopafi veaꞋmoꞋya ageteꞋya aepaꞋa havilama huꞋya ohavinae. ");
INSERT INTO kmu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","AgaiꞋa talo hu-malenea mopale emaineamagi agaiꞋa veaꞋmoꞋya avaleꞋya falu fala huꞋya oꞋavalenae. ");
INSERT INTO kmu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","AvaleꞋya oꞋatageꞋya nagoke nagokeꞋmoꞋya falu fala huꞋya Yisasina avale-mainaya veaꞋmoꞋya Yisasife amakupi maleꞋya amametiti nehaya veaꞋmogamina YisasiꞋa tokiyaꞋaleti “Anumaya Koti nafaꞋneyagae.” huno hu-neꞋama-te. ");
INSERT INTO kmu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ani veaꞋmoꞋya vayaꞋmo kolateti oꞋama-temagi Anumaya Kotiteti ama-tene. Vemo augafa ageno haꞋye hu yateti oꞋamatenegi Anumaya Kotiteti amatene. VeaꞋmoꞋya nafaꞋne atesaya amakesa haviya yateti oꞋamatemagi Anumaya Kotiteti amatene. ");
INSERT INTO kmu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yisasina nago agiꞋa Kemona atetegeno ve maineno tagaiꞋene mainegeta agaila alu aotage tokiya hale yamaꞋa neꞋagone. Ani kanoa Anumaya Kotina aiya nagoke nafaꞋneꞋa maineamagino nefaꞋa agaiꞋa alu aotage tokiya hale yamaꞋa amigeno ali falu huno kayoneꞋage yaꞋene tamageꞋage hu yaꞋene agai aguꞋafina hiya hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","YoniꞋa keha keha nehuno agaife mage hie “Ma kanomofe nayona mage huꞋna tamaha-pai-mainoe haenagaꞋa nago kanoa nagaila onatenele mainea yafe nagaila ago nagase-mainea kanoa egahiema huꞋna tamaha-pai-mainoane.” ");
INSERT INTO kmu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ali falu huno kayone yamaꞋa hiya hu-mainefiti tagaila mukiꞋamogatina taya huno kanale manu tamiteno nagoꞋa kanale manuene nelamie. ");
INSERT INTO kmu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tamage Anumaya KotiꞋa kahegi kema malenea kea Mosesena ayapi maleteno hapaigeno hama-pai-mainiamagi ali falu huno kayone yaꞋene tamage hu yaꞋene Yisasi Kalaisiteti neꞋalune. ");
INSERT INTO kmu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nagoke kanomoꞋa Anumaya Kotina oꞋagene. Tamage mukiꞋa veala oꞋagenae. Aiya nagoke nafaꞋneꞋamoꞋa Anumaya KotiꞋene nagoꞋya huꞋana mainaꞋamagino ani kanomoꞋa Nefa avate maineleti Nefana agaiꞋage tave-nelino aepaꞋa hu-gafino taha-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Isaleli vayaꞋmoꞋya Yelusalemu mainaleti Livae nofi vayaꞋene mono note kava vayaꞋene hu-ma-tageꞋya Yonife “Kagaya tagae?” hutama havigeho huꞋya hama-pai-mainae. Hama-paigeꞋya mo havigageno YoniꞋa ma ke huno hama-nepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","YoniꞋa ani ke fala-kino ohunegi ani kea hu falote huno mage huno hie “Nagaya Kalaisi, Anumaya KotiꞋma taugafa ali-gatigahe hu-tenea kanoa nagaya omainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","HigeꞋya “Ani kanoa omaimagi kagaya tagae? Ilaiyaga mainapi?” huꞋya havigageno “AꞋao nagaya ani kanoa omainoe.” YoniꞋa make huno higeꞋya “Nagi Anumaya Koti aune kano mainapi?” huꞋya hageno “AꞋao.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","HigeꞋya “Taha-paiyo kagaya tagae? Hu-la-tenaya vayaꞋmogamina kenonaꞋamima hama-paisuna kea kagesafiti kagaika aliꞋyafe naꞋane ke nehane?” huꞋya havi-negae. ");
INSERT INTO kmu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nehageno YoniꞋa kenonaꞋamilela mage huno hama-nepaiye “Nagaya ma kano mainoe. Nage aiꞋna kaꞋme kotegati keha keha hisua kano mainoe. AisaiyaꞋa Anumaya Koti aune kanomoꞋa nayo hu-malenea kea mage huꞋna nehue ‘Anumaya visia kana alitama hilato hutama ali fatago hiho.’ huno hu-maineane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Anima havigesia kema aliꞋya vaya vayala Falasia vayaꞋmoꞋya hu-ma-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ani vayaꞋmoꞋya Yonife mage huꞋya havi-negae “Kalaisigaene Ilaiyagaene Anumaya Koti aune kanoenema omaineka naꞋa higeka tina fale neꞋamatane?” huꞋya havi-ge-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Havigageno YoniꞋa kenonaꞋamilela mage hie “Ma nagaya titeti fale nelama-toamagi tamakaipina nagola oꞋagenaya kanoa he-ti-maine. ");
INSERT INTO kmu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Heti-maineamagino ani kanomoꞋa haenagaꞋa egahie. Nagaya afa kano mainoamagiꞋna agai aiyalela ayesuana onategahie.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","YoniꞋa Petani kumate Yotani timona atu kaiyaga maineno veaꞋne ti fale neꞋama-teno mani kea hu-mainea kehe mehavi-ge-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","FaeteꞋya kotigeꞋya YisasiꞋa Yonitega eneꞋegeno YoniꞋa ageteno mage huno nehie “Ageho mani kanoa Anumaya Kotina Sipi sipi nafaꞋneꞋae. HaenagaꞋa haesageno falisia yateti ma mopale veaꞋmogamina kefo yaꞋamia ali-talesia yafe emaine. ");
INSERT INTO kmu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ani kanomofe nayona mage huꞋna tamaha-pai-mainoe ‘HaenagaꞋa esia kanomoꞋa nagaila onatenele mainea yafe nagaila ago nagase-mainea kano egahie.’ huꞋna tamaha-pai-mainoane. ");
INSERT INTO kmu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nagaya agaila aepaꞋa oꞋagenoanagi Isaleli veaꞋmogamina Yisasina amave-ligahe tina mo fale-ma-tesoe huꞋna emainoane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","YoniꞋa mage huno hama-pai-maine “Anumaya Kotina Alu Aotage AvamuꞋamoꞋa nama kana huno ikapinagati elavino eaꞋyamo augafalela emainegeꞋna age-mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nagaya agaila oꞋagenoanagi Anumaya KotiꞋa ti fale-ma-to yate hu-natenea kanogino mage hie ‘Kagaya agegane nagaiꞋni Alu Aotage AvamuꞋmoꞋa elavino nago vemo augafaleꞋma emaisigekama agesana vemoꞋa veaꞋmogamina Alu Aotage AvamuꞋaleti fale-ma-tegahie huka havigane.’ huno higeꞋna havi-mainoane. ");
INSERT INTO kmu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nagaya ani kema hia yana ago age-mainoleti tamaha-nepauve ma kanoa Anumaya Kotina neꞋamo maine huꞋna nehue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","FaeteꞋya kotigeꞋya YoniꞋene agaiꞋaene tokaeꞋana nemaiꞋa kanolataꞋene eteꞋya he-tiꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","37","YisasiꞋa neꞋvigeno YoniꞋa ageke huno ageteno mage hie “Anumaya Koti Sipi sipi nafaꞋnea atu maine.” huno higeꞋana YoniꞋene tokaeꞋana nemaiꞋa kanolatana ani kea haviteꞋana Yisasina akave neꞋvaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Akave neꞋvaꞋageno YisasiꞋa mai-yahae huno anaketeno ke huno hana-vige “NaꞋafe neꞋaꞋe?” huno higeꞋana anakaya mage haꞋe “Lapaiga hanate nemaine?” huꞋana nehaꞋe. Lapai tagai kefina hu-mave-lina kanoe huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","YisasiꞋa mage huno hie “Etana megeꞋo.” huno hana-paigeꞋana agaiꞋene neꞋvaꞋageno une kigeꞋana nomaꞋa mogeteꞋana ani kanalela agaiꞋene mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoni kema haviteꞋana Yisasi akaveꞋma umainaꞋa kanolatapitila nago kanomo agia EtaluꞋe ani kanoa Saimoni Pitana aganaꞋamoꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","EtaluꞋa hagoteno nepuꞋamona Saimonife mo atiyeno mogefalote huteno mage huno hapaiye “Anumaya KotiꞋma taugafa ali-gatigahema hu-tegeno emainea kanoa Kalaisina nagaya ago agoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Huteno Saimonina avaleno Yisasite neꞋvaꞋageno YisasiꞋa ageke huno ageteno mage hie “Kagaya Saimoniga Yonina nemofogae kagai kagia mage huꞋna nemaloe Sifasigae Pitagae.” huno nehie. Ani agilatamogania nagoꞋya hu-mainaꞋe. Tagai kefina yafaꞋmogae huno malene. ");
INSERT INTO kmu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","FaeteꞋya kotigeno YisasiꞋa Kalili visia agesa havino vilegati Filipina mogeteno mage huno hapaiye “Kagaya nakave eno.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","FilipiꞋa Petesaita kumate kanoe. Ani kumala Etalugani Pitagani kumale. ");
INSERT INTO kmu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","FilipiꞋa Nataniolona moge-falote huteno mage huno hapaiye “Nago kanomofe Anumaya Koti amaune vayaꞋene MoseseꞋene mono autaꞋmafi kae-malenaya kanoa tagaya ago age-falote hunana agaya Nasaleti YisasiꞋe Yosefena nafaꞋneꞋamo maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Higeno NatanioloꞋa mage huno hie “Nasaleti kanale yana falote hisifi? Falote ohugahie.” huno higeno FilipiꞋa mage huno hie “Eka mego.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","HapaigeꞋana neꞋaꞋageno YisasiꞋa Nataniolona ageteno mage hie “Ageho Isaleliti tama kanolafane. Mani kanoa nagola havigeꞋa omalenea kano maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Higeno NatanioloꞋa mage huno havinege “Nagai aepaꞋa na yu havimainanane?” huno havigegeno YisasiꞋa mage hie “FilipiꞋa kagaila moge ohunegeka kagaya fiki yosamo aepale mainanageꞋna nagaya ago kage-mainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Higeno NatanioloꞋa mage hie “Hulaveli kanomoga Anumaya Koti nafaꞋne mainane. Kagaya Isaleli kotega ala sauve kano mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Higeno YisasiꞋa Nataniolofe mage hie “Fiki yosamo aepale mainanageꞋna nagaya kage-mainoafe tamage nehane huka kagupi maleka kametiti nehano? HaenagaꞋa tusiꞋa ala kavaꞋyaga efalote hinageka agegane.” huno hapai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","YisasiꞋa amakaife mage hie “Tamagelafa huꞋna tamaha-nepauve tamakaya ikamoꞋma ai-halenagetama neꞋagetama ikapinagati emainoa kano vayaꞋmo natenea kanomonilela Anumaya Kotina ensole anagaꞋamoꞋya naugafalela haiteꞋya laviteꞋya nehisagetama agegahae.” huno hama-nepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tole kana maiteꞋya Kalili hanea kumala Kenae nehaya kumate nago kanomoꞋa a aligahe higeno Yisasina itaꞋamoꞋa anima aꞋma aligahema hia nopi umaine. ");
INSERT INTO kmu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","UmainegeꞋya “Yisasiga kagaiꞋenema tokaeꞋya nemaiya anagakaene eho.” huꞋya ke hageꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","UmaineꞋya nenageno nofi alagamo tina haꞋno higeno Yisasina itaꞋamoꞋa Yisasina mage huno hapaiye “Nofi alagamo tina haꞋno hie.” huno hanepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Higeno YisasiꞋa mage hie “AꞋoko ‘NaꞋa maꞋa huo.’ huka nahaꞋopaiyo kagai yana omalene. nagaya tokiyaꞋniꞋa amavelisua kanaꞋa falote ohune.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nehigeno Yisasina itaꞋamoꞋa kaveꞋma talo talaꞋma huꞋya amamiya veaꞋnehe mage huno hama-paiye “Nago kema hinagetama agai ke akave maleho.” huno hama-nepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuta vayaꞋmogami mono kemoꞋa mage humaine “MukiꞋa kanalela mukiꞋa yana sese hutama ti faleho.” huno humaineane. Ani yafe sikisiꞋa (6) yafa ti keꞋayola vani hataletiꞋa (100) lita hanea keꞋayola anilela hane. ");
INSERT INTO kmu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hanegeno YisasiꞋa kaveꞋma talo talaꞋma huꞋya neꞋamamiya veaꞋnehe mage huno hama-paiye “Mani li keꞋayoꞋyakafina hefitama havateho.” huno hama-paigeꞋya hefi havate-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Havatageno “KaveteꞋma kava yagai-mainea kanole osiꞋa hefitama alitama momiho.” huno higeꞋya hefiliꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","HefiliꞋya momigeno ani kaveteꞋma kava yagai-mainea kanomoꞋa ani lina hagotenoꞋa titafa haniamagi haenagaꞋa eteno nofi alagamo ti hapaegeno neno akekeana higeno ani lina ea kamaꞋa oꞋageneamagi hefiꞋyama aliꞋyaꞋma aya veaꞋnemoꞋyage havimainae. KaveteꞋma kava kanomoꞋa aꞋma alia kanohe ke huno mage huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“MukiꞋa vayaꞋyaga hagote kanalela hagaꞋage tina amamigeꞋya mageno amamu higeꞋya haviyama hia tina neꞋamamiya yamagi kagaya hagote kanalela afa li tamiteka haenaga hagaꞋage tina nelamine.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Manima taloma hia tokiya avame yana YisasiꞋa hagote kanale Kalili hanea kumala Kenae huꞋya nehaya kumate ani kavala talo nehuno tusiꞋa ala tokiya hale yamaꞋaene amaveligeꞋya agaiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya ageteꞋya aliꞋya amakupi maleꞋya amametiti hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","NaꞋa hu-maletegeꞋya YisasiꞋene itaꞋamoꞋene aganaꞋamoꞋyaene agaiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋyaene Kapaneamu laviꞋya osi kanaꞋa anile mainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nago ala imua Anumaya KotiꞋma Yuta veayaꞋmogami amakinagomogami amaugafama aligatimainea kanahe amakesa havi havi nehaya imu negiya kana evaꞋyi hugahe higeno YisasiꞋa Yelusalemu haimaine. ");
INSERT INTO kmu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","YisasiꞋa ala mono nopi haino mogeana vayaꞋyagamoꞋya pulumaka afuma sipi sipi afuma namama malenageꞋya veaꞋmoꞋya miya hisaya yafe malenageno YisasiꞋa mokemaine. magi nagoꞋa vayaꞋmoꞋya alu kotega nehanea monea neꞋaliꞋya ani kumateꞋma nehanea monea anonaꞋa amamisaya yafe folomole maleꞋya mopale mainageno momakemaine. ");
INSERT INTO kmu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Momaketeno nofiteti alifagagi maleneno mukiꞋa vayaꞋma sipi sipima pulumaka afuyakaene mono nopiti ali helafi neꞋataleno monema ayeyahaeꞋma nehaya vayaꞋmogami folomoꞋamiene moneꞋamiene ali helafi-talene. ");
INSERT INTO kmu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Namayagama miya nehaya vayafe mage huno hamapaiye “Alitama eviho. Mafina nenafa nona tamakaya alitama maketi kumala talo ohiho.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","NehigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋamoꞋya avopima hanea kehe amakesa nehaviye. Ani kea mage huno haneane “Anumaya Koti nofena mukiꞋa kanale magesa havi havi huꞋna nokaꞋa kanaleꞋya huno hanesia yafe aluya huꞋna muse nehue.” huno kaemalenegeꞋya havimainayane. ");
INSERT INTO kmu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","HavimainayamagiꞋya Yuta vayaꞋmoꞋya eteꞋya havinegae “AniꞋama hana kavala ta tokiyaleti nehane? TokiyakaꞋa hane huta havisuna yafe nagola oꞋagenona tokiya avame yana hugeta agamano.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nehageno YisasiꞋa kenonaꞋamia mage huno hama-paiye “Ma ala mono nona alitama lagape aitaletesageꞋna taliꞋa (3) kanale eteꞋna ani nona aliꞋna hetigahue.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","HigeꞋya Yuta vayaꞋmoꞋya mage huꞋya hapaiye “KekamoꞋa kanale ohia ke nehane taliꞋa (3) kanale ani nona aliꞋna hetigahue huka nehanamagi vayaꞋyagamoꞋya foti sikisiꞋa (46) kafufi mani nona kimalenaya none.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","HuꞋya hageno YisasiꞋa ani avame kea hiamagi ani mono nofema hiana agaiꞋa augafahe nehie. ");
INSERT INTO kmu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","YisasiꞋma falitenoꞋma he-ti-mainea kanafina agaiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya ani kema humainea kehena amakesa havimainae. Avopima hanea kene YisasiꞋma humainea kene “Tamage humaineane.” huꞋya amakupi maleꞋya amametiti humainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Imuma negiya kanale YisasiꞋa Yelusalemu maineno oꞋagenaya tokiya avame yana higeꞋya ageteꞋya mukiꞋa veaꞋnemoꞋya “Tamage nehie.” huꞋya amakupi maleꞋya amametiti humainae. ");
INSERT INTO kmu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hayamagi YisasiꞋa mukiꞋa veaꞋnemogami amakuꞋa ago amakea yafe aguꞋa noꞋamamie. ");
INSERT INTO kmu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","NaꞋafene amakupima hanea yana ago age-mainea yafe YisasiꞋa mukiꞋa veaꞋmogamife “Tamakupima hanea yana naha-paiyo.” huno ohune. ");
INSERT INTO kmu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nago Falasia kanoa Yuta vayate ala kava kanoꞋamimo agia NikotimasiꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nago kegela ani kanomoꞋa Yisasite eno mage huno hie “Humave-nelina kanomoga tagaya ago havimainone kagaya humaveli hama-veli nehana kanomoga Anumaya KotiꞋa hu-gategeka emainane. Kagaya oꞋagenaya tokiya avame yana nehane. Anumaya KotiꞋa kagaiꞋene omaineleꞋasina aniꞋa kavala ohateꞋasine. Ani yafe tagaya ago havimainone Anumaya KotiꞋa hu-gategeka emainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Higeno YisasiꞋa mage huno hie “Tamage-lafa huꞋna kaha-nepauve anafinaga kanomoꞋma nago kanoma haegafa huno oꞋatesiana Anumaya KotiꞋma kava yagai-mainea kumala oꞋagegahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Higeno NikotimasiꞋa mage huno hie “Alopa kanomona hanaꞋa huno ateleꞋasine? ItaꞋamo aipafinaga eteno hai falesigeno nagoꞋene eteno atesie huka nehapio?” huno havinege. ");
INSERT INTO kmu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Havigegeno YisasiꞋa mage huno hie “Tamage-lafa huꞋna kaha-nepauve titetiꞋene Anumaya Koti Alu Aotage AvamuꞋmotetiꞋene oꞋatesiana Anumaya KotiꞋma kava yagai-mainea kumatela oꞋugahie. ");
INSERT INTO kmu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Amaugafama hanea veaꞋmoꞋya augafa hanesia nafaꞋne amategahayanagi Anumaya Kotina Alu Aotake AvamuꞋmoteti atesia kanomona Alu Aotage AvamuꞋmoꞋa haimula amigahie. ");
INSERT INTO kmu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nagaya mani kema hua kea ‘NagoꞋene eteka nato huka huo.’ huꞋna hua kehena havika kamaꞋyoa aika atali ohuo. ");
INSERT INTO kmu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","YasimoꞋa agaiꞋa hau yate alino visia yana kaulagamoꞋa oꞋagene. AfaꞋa uhuhu uhuhu hia keꞋa haviteka hanategatiꞋma aepa heno falote hia kaꞋene vaiyea kaꞋene oꞋagenane. YasimoꞋma hia avamete huno Anumaya Kotina Alu Aotake AvamuꞋmoꞋa nago kanomona neꞋateana noꞋagone.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Higeno NikotimasiꞋa mage huno havige “Ani yana hanaꞋa huno falote hugahie?” huno havinege. ");
INSERT INTO kmu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Havigegeno YisasiꞋa mage huno hie “Kagaya Isaleli veaꞋne hu-maveli hamaveli nehana kano mainanagi naꞋa higeka ohavinane? ");
INSERT INTO kmu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tamage-lafa huꞋna kaha-nepauve age-mainona yafe kaha-nepauve havilinona yafe kaha-nepauvanagi mani kea tamakaveꞋno hu-neꞋatae. ");
INSERT INTO kmu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nagayama ma mopale yafe ago kaha-nepauvanagi ‘Tamage nehane.’ huka havika kagupi maleka kametiti nohanagi ikapinaga yafema kaha-paisugeka hanaꞋa huka havika kagupina maleka kametitia hugane? ");
INSERT INTO kmu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nago kanomoꞋa ikapinaga ohainegi nagaya ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna nagaiꞋniꞋage ikapinagatila ma mopafina elavi-mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","MoseseꞋa kaꞋme kotega maineno osifaꞋvea talo huteno yosale malegaꞋmaeno alisaga hu-mainea kavala menia aniꞋa huꞋya ikapinagati emainoa kanoa vayaꞋmo natenea kanomonina navaleꞋya alisaga hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Alisaga hisageno mukiꞋa veaꞋmoꞋya ‘Tamage nehie.’ huꞋya amakupi maleꞋya amametiti hisaya veaꞋmoꞋya agola maige maige hisaya hamaimula aligahae.” ");
INSERT INTO kmu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anumaya KotiꞋa aiya nagoke nafaꞋneꞋa maineanagi ma mopafi veaꞋnehe tusiya huno hau ayamopafi haigeno ani aiya nagoke nafaꞋneꞋa hu-tegeno elavino emaine. Emainegeta tagaya nagoke nagokeꞋmogata agaife tagupi maleta tametiti hisunana haniki-mai yapi tegelege nehia atafina oꞋugahunanagita agola maige maige hisuna tahaimula aliteta maigahune. ");
INSERT INTO kmu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anumaya KotiꞋa nafaꞋneꞋamona mopale veaꞋne kaiyeke hu-mateno nofi hu-matesia yatela hu-tegeno omenegi mopafi veaꞋne amaku amamemaꞋa ali-gatisiafene huno hu-tegeno emaine. ");
INSERT INTO kmu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Emaineanagi nagoꞋa veaꞋmoꞋya Yesasifena amakupi maleꞋya amametiti haya veala Anumaya KotiꞋa kaiyeke huno nofila hu oꞋama-tegahianagi nagoꞋa veaꞋmoꞋya Anumaya Kotina aiya nagoke nafaꞋnehe haviꞋya amakupi omaleꞋya amametiti nohaya yafe Anumaya KotiꞋa ago kaiyeke hu-ma-teteno ago nofi hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kaiyekema hu-mate yamo aepaꞋamoꞋa maꞋa hu-maine, aye hale-ma-te kanoa ma mopafina ago emainegeꞋya veaꞋmoꞋya kefo yana nehuꞋya hani yapi maisaya yafe muse huꞋya hale yafena nohamaiya yafe Anumaya KotiꞋa ago kaiyeke hu-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","MukiꞋa kefo kava huge huge nehaya veaꞋmoꞋya hale yafena nohamaigeꞋya “Hale yapima visunageꞋya kefo yatia age-falote hugahae.” huꞋya hale yapina nomae. ");
INSERT INTO kmu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tama kava nehaya veaꞋmoꞋya hale yapima neꞋeya mage nehae “Anumaya KotiꞋa taya higeta kanale yana hu-mainonafe mukiꞋa veaꞋmoꞋya agesae.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","NaꞋa hu-maleteno YisasiꞋene agaiꞋaenema tokaeꞋya nemaiya anagaꞋene Yutia umaineꞋya nagoꞋa kana umaiteꞋya veaꞋnea mono tina fale-ma-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Fale-ma-tegeno YoniꞋa Ainonie nehaya kumate maineno aniꞋa huno veaꞋnea fale-ma-tene. Ainoni kumala Salimie nehaya kumaꞋmo aupate hane. KasagoꞋya tiꞋyaga anilega haneanagiꞋya veaꞋmoꞋya ete ete hageno tina fale-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yonina avaleꞋya nofipina oꞋatenageno ani lina fale-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yonienema tokaeꞋya nemaiya anagaꞋene nago Yuta kanoene mono tima fale yamo auꞋava yafe mohu mehu huꞋya ke vai-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ke vai-maleꞋya Yonitega mage huꞋya mo hane-paiye “Hulave nelina kanomoga Yotani limona ame haupalega kagaiꞋenema mainegeka agaifema taha-pai-mainana kanomoꞋa menia agaiꞋa tina fale neꞋa-ma-tegeꞋya mukiꞋa veaꞋmoꞋya agaitega utele nehae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hageno YoniꞋa mage huno hie “Anumaya KotiꞋa nagoꞋa veaꞋmogamina nago yana oꞋamamineleꞋasina oꞋalileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tamakaya agoꞋma hu-mainoa kea havilinae. Mage huꞋna hu-mainoe ‘Nagaya Anumaya KotiꞋma taugafa ali-gatigahe hu-tenea kanoa omainogi nagaya uhagoteꞋna neꞋvisugeno agaya haenaga egahie.’ huꞋna hu-mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nago vemoꞋa aꞋma aliana agaiꞋa a maineanagi ayama hu-mainea kanomoꞋa agava huno aꞋma ali-mainea kea haviteno tusiꞋa muse nehie. AniꞋama hia avamete huꞋna Yisasitega veaꞋma neꞋvaya yafena nagaya tusiꞋa muse nehue. ");
INSERT INTO kmu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yisasi agimoꞋa nagaila nagaseno ala huno haigahianagi nagai nagimoꞋa afete tavigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","YoniꞋa mage huno hie “Anafinagati elavi-mainea kanomoꞋa mukiꞋa yana amakase-maineanagi ma mopaletiꞋma efalote hu-mainea kanomoꞋa ma mopale kano maineno mopale yafeke kea nehie. Ikapinagati elavi-mainea kanomoꞋa mukiꞋa yana amakase-maine. ");
INSERT INTO kmu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ikapinagati elavi-mainea kanomoꞋa age-mainea yafeꞋene havimainea yafeꞋene hama-nepaiyanagi nagoꞋa veaꞋmoꞋya ani kea haviꞋya amakupina nomalae. ");
INSERT INTO kmu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nomalagi nagoke nagoke veaꞋmoꞋya hu-mainea kea haviꞋya amakupima malaya yafe ‘Anumaya KotiꞋa tamageꞋage kano maine.’ huꞋya hu-lokiya neꞋvaiye. ");
INSERT INTO kmu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anumaya KotiꞋa hu-tenea kanomona Anumaya KotiꞋa Alu Aotage Avamula nago haupa nago haupa huno oꞋaminegi mukiꞋa hiya huno aminegeno Anumaya Koti kea nehie. ");
INSERT INTO kmu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Higeno nefaꞋa nafaꞋneꞋamofena tusiꞋa muse nehuno mukiꞋa kava yagaisia yana ayapi malene. ");
INSERT INTO kmu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","NagoꞋa veaꞋnemoꞋya nafaꞋneꞋamofema ‘Tamage nehie.’ huꞋya amakupi maleꞋya amametitima hayana agola maige maige hisaya hamaimula ago ali-mainayanagi nagoꞋa veaꞋmoꞋya nafaꞋneꞋamoꞋma hia kema akaveꞋma omalesayana ani hamaimula oꞋaligahae. Anumaya KotiꞋa ani veaꞋmogamina aipa haviya hu-mateno kaiyeꞋkea ago hu-neꞋamate.” ");
INSERT INTO kmu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","“YisasiꞋa Yonina agaseno mukiꞋa veaꞋmogamina tina fale-ma-teno hai-maine.” huꞋya haya ke Falasia vayaꞋmoꞋya havimainae. YisasiꞋa agaiꞋa tina fale oꞋama-tenegi agaiꞋaenema tokaeꞋya nemaiya anagaꞋamoꞋya fale-ma-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Falasia vayaꞋmoꞋya ago ani kea haviya yafe YisasiꞋa haviteno Yutia neꞋataleno Kalili eteno ugahe amuꞋno kola mogaseno via kotega Samelia mo vaiyatete hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nago Samelia kumaꞋmo agia Sika. Ani kumala YekopuꞋa Yuta vayaꞋmogami amakinagomoꞋa nafaꞋneꞋamona Yosefe aminea hoya hanelega hane. YisasiꞋa ani kumate evaꞋyi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","YekopuꞋa ti he-nefia kagemuyola hanegeno yagemoꞋa amuꞋno-kaꞋno higeno YisasiꞋa kama vaiye-mainea yafe kasalo haegeno ani kagemuyo ti avayale eno mopale maine. ");
INSERT INTO kmu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mopale emainegeno nago Samelia aꞋmoꞋa ti he-figahe neꞋegeno YisasiꞋa mage hie “Tina namigeꞋna nano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Yisasienema tokaeꞋya nemaiya anagaꞋmoꞋya anile omainagi kave miya hugahe ala kumatega umainae.) ");
INSERT INTO kmu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yuta vayaꞋene Samelia vayaꞋene amakoꞋya huꞋya amahaote amahaote huꞋya nemaiya yafe ani Samelia aꞋmoꞋa mage huno hie “Kagaya Yuta kano mainanagi nagaya Samelia a mainogi naꞋa higeka nagaifena tina namigeꞋna nano huka nehane?” huno havinege ");
INSERT INTO kmu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Higeno YisasiꞋa mage huno hie “Kagaya Anumaya KotiꞋma amuse yama kamisia yafema havimainateꞋasina tifena nagaila nahavi-gateꞋasine. Tima namio hia kanoma nagemainateꞋasina tifena nahaviganageꞋna maige maige hisana tina kamuleꞋasine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Higeno ani aꞋmoꞋa mage huno hie “Ala kanomoga ani li komua afe yapi hanegi tima he-fisana keꞋayola omalegi hanateti ani maige maige hisua tina he-fika namigane? ");
INSERT INTO kmu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","YekopuꞋa, taginagomo ani kagemuyola tamineane. YekopuꞋa nafaꞋneyagaꞋaene agaiꞋa afuyagaene ani komufitila ne-mainae. ‘Agaila agase-mainoe.’ huka nehapio?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Higeno YisasiꞋa mage huno hie “MukiꞋa veala ma lipiti nesayana eteꞋya lifena amakegahianagi nagoke nagoke veaꞋmogamima amamisua timoꞋa amakusafinaga kapae nehagea ti kana huno lavige lavige hisigeꞋya maige maige hisaya hamaimula amamigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Higeno ani aꞋmoꞋa mage huno hie “Ala kanomogae ani lina namigeꞋna nano. NamisanageꞋna nagoꞋene onahaugahianagiꞋna malela tima he-figahena eteꞋna omano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Higeno YisasiꞋa mage huno hie “Negavena mo ke hu-lika male eno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Higeno ani aꞋmoꞋa mage hie “NenaveꞋa omaiye.” huno higeno YisasiꞋa “NenaveꞋma omaiyema hanana tamage nehane.” ");
INSERT INTO kmu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Kagaya faefuꞋa (5) negaveꞋya mainayane meni kanafina nago vene mainananagi miya hu-ga-tenaya negaveꞋa omaine. Mani kea tamage huka naha-nepaine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Higeno ani aꞋmoꞋa mage huno hie “Ala kanomogae nagaya ago havimainoe kagaya Anumaya Kotina aune kanoꞋa mainane. ");
INSERT INTO kmu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","TaginagomoꞋya ma agoꞋyale* Anumaya Koti agia alisaga nehayanagi tamakaya Yuta vayaꞋmogatama ‘Yelusalemu Anumaya Koti agia alisaga nehaya kumala hane.’ hutama nehae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Higeno YisasiꞋa mage huno hie “Ma aꞋmoga nagayama tamage huꞋna kaha-paisua ke havika kagupi ai-maleteka kametiti huo. Nago kana falote hinageno ma agoꞋyaleꞋene Yelusalemuene Anumaya Koti agia alisaga ohugahagi alu kumateti kumateti agia alisaga hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tamakaya Samelia veaꞋmogatama agima alisaga nehaya kanomona age-lama hutama oꞋagenae. Tagaya Yuta veaꞋmogata agima alisaga nehuna kanomofe havilama hu-mainona yafe agia alisaga nehune. Tamaugafa ali-gatisia kanoa Yuta vayapiti falote nehie. ");
INSERT INTO kmu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nago kana falote hugahie. Ani kana ago falote hu-maine. Nenafa agima alisaga hisaya veaꞋmoya tamage huꞋya amaku amamemaꞋafiti Nenafa agi alisaga hisaya kanamoꞋa ago falote hu-maine. Nenafana amaku amamemaꞋafiti agima alisaga hisaya veaꞋnehe ati neꞋaye. ");
INSERT INTO kmu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anumaya KotiꞋa augafa omalenea avamula mainea yafe agai agima alisaga hugahena veaꞋmoya amaku amamemaꞋaleti tamage huꞋya agia alisaga hiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Higeno ani aꞋmoꞋa kenonaꞋa mage huno hie “KalaisiꞋa, Anumaya KotiꞋma taugafa ali-gatigahie huno hu-tesia kanoma esia kea nagaya ago havimainoe. Esiana mukiꞋa yafena taha-paigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Higeno YisasiꞋa kenonaꞋa mage hie “Nagaya nevayaꞋna kakaiꞋenema maineꞋna kema nehua kanoa mani kano mainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mani kea nehigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagala eteꞋya neꞋeꞋya YisasiꞋma aꞋmoꞋenema kea kea haꞋaꞋyafe ageteꞋya tusi amakesa havi havi hayanagi nagoꞋamoꞋya “NaꞋafe nehane?” huꞋya aꞋmofena haviokenae. “NaꞋa higeka ma aꞋene kea kea nehane?” huꞋya Yisasina haviokenae. ");
INSERT INTO kmu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ani aꞋmoꞋa ti kena neꞋataleno ala kumatega uno anifima mainaya veaꞋnehe mage huno hama-paiye “MukiꞋa nayoma hu-mainoa yama naha-paiya kanoa etama megeho. Ani kanoa Anumaya KotiꞋma taugafa ali-gatigahema hu-tenea kanofi?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","HigeꞋya kumala neꞋataleꞋya Yisasitega emainae. ");
INSERT INTO kmu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yaufa neꞋageꞋya YisasiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya Yisasifena mage hae “Hulave-nelina kanomoga nesana yana hanegi no.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nehageno YisasiꞋa mage huno hie “Nagaya oꞋagenaya kaveꞋnia hane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","HigeꞋya ani anagaꞋamoꞋya amakaiꞋami huge havige huꞋya mage hu-mainae “Nago kanomo nesia kavela ago alino me mainefi?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hageno YisasiꞋa mage huno hie “Nesua kavela ma hane hu-na-tenea kanomoꞋma haisia kavaꞋma huꞋna naminea aliꞋyana alivaya ayesua yana kaveꞋniꞋa hane. ");
INSERT INTO kmu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","VeaꞋmoꞋya nehaya ke mage hutama nehae ‘FoꞋa (4) ika maitesunageno afuma nelea kana falote hugahie.’ hutama nehafi? Nagaya tamaha-nepauve tamakaya hoyafina age-lama hutama ageho. Ani hoyafina ago afu-le-maine. Anima hia kava huꞋya veaꞋmoꞋya nagai kema haviꞋyama amakupi maleꞋya anametiti hisaya yafe ago afu-le-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Afuma leana Anumaya Koti kema havisaya yafe ayama hisia kanomoꞋa anonaꞋa aligahianagi aya hu-mainaya vayala amakupi maleꞋya amametiti hisayana agola maige maige hisaya hamaimula aligahae. Aligahayanagi ani hoyafima avina yama negalia kanomoꞋene afumalegeno ayama huno neꞋalia kanomoꞋene nagoꞋya huꞋana musena hugaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Manima agoꞋma hu-mainaya kea ‘Nago kanomoꞋa kali-malegeno nago kanomoꞋa nenaꞋa neꞋalie.’ huꞋya haya kea tamage nehae. ");
INSERT INTO kmu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nehagi nagoꞋa veaꞋmoꞋya kasageke huꞋya anima nagai kema ohavinaya veaꞋmogamina Anumaya Koti ke ago hama-pai-mainagi tamakaya ayama hugahena ani vayate ago hu-lama-togetama hama-pai-mainayanagiꞋya amakupi malesagetama afaꞋa nenaꞋage aligahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ani aꞋmoꞋma hu-mainea kehe mukiꞋa Samelia veaꞋmoꞋya Yisasife haviꞋya amakupi maleꞋya amametiti nehae. Ani aꞋmoꞋa mage huno hu-maine “MukiꞋa hu-mainoa yana ago naha-pai-maine.” huno hu-mainea kehe haviꞋya amakupi maleꞋya amametiti hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yisasite evaꞋyi huꞋya mage huꞋya hae “TagaiꞋene maisane.” huꞋya havigageno YisasiꞋa amakaiꞋene tole kana maine. ");
INSERT INTO kmu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","MainegeꞋya kasagoꞋya veaꞋmoꞋya agai kema haviya yafe amakupi maleꞋya amametiti nehae. ");
INSERT INTO kmu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Amametiti nehuꞋya ani aꞋmofe mage huꞋya hapaiye “Menima kagai kema havuna yafe Yisasina taguꞋa amita tametiti nohunagi tagayama agai kema tagaiti haviteta tagupi maleta tametitia nehune. Menia nehavune mani kanoa ma mopale veaꞋmogati taugafa ali-gatigahe emaine.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Anile tole kana maiteno YisasiꞋa ataleno Kalili umaine. ");
INSERT INTO kmu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","YisasiꞋa agaiꞋa nayona mage huno hu-maineane “Nago mono ke hama-nepaiya kanomoꞋa agaiꞋa vayaꞋamogamipi maineana vayaꞋamoꞋya ‘Ala kanomo kegi havigetao.’ huꞋya nohae.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hu-maineanagi Kalili evaꞋyi higeꞋya ani kumate veaꞋmoꞋya hu falu fala huteꞋya muse-kase hu-mainae. NaꞋafene ani veaꞋmoꞋya Yelusalemu ala imu ki-mainaya kanale YisasiꞋma mukiꞋa yama hu-mainea yama moge-mainaya yafe hu falu fala huteꞋya musena hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Musena hutetageno YisasiꞋa eteno Kalili hanea kumala Kena kumate uvaꞋyi hu-maine. Ani kumatela YisasiꞋa tifena higeno nofi alagamo ti hapae-mainea kumale. YisasiꞋa anile umainegeno nago kamani kava kanoa, Kapaneamu kumate kanogino, neꞋamoꞋa kali ali-maine. ");
INSERT INTO kmu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kali neꞋaligeno nefaꞋa “YisasiꞋma Yutiati ago Kalili emaine.” huꞋya haya kea haviteno aupaꞋa nafaꞋneꞋa neꞋataleno Yisasite eno mage huno hie “NafaꞋneꞋniꞋa falisia kava nehigi melika kanale huto.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Higeno YisasiꞋa mage huno hie “Tamakaya tokiya avame yama oꞋagenutamahena nagaifena tamakuꞋa havi onamitama tamametitia ohugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Higeno ani kamani kava kanomoꞋa mage huno hie “Ala kanomogae nafaꞋneꞋniꞋa ago faligahe nehigi afaꞋa kaiyayeka nagaiꞋene eno.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Higeno YisasiꞋa mage hie “Kagaya afaꞋa vuo. NafaꞋnekamoꞋa ofaligahigi afaꞋa maigahie.” huno higeno YisasiꞋma hia kea havino akuꞋafi maleteno ametiti nehuno umaine. ");
INSERT INTO kmu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Emainea kate eteno maitagifeno neꞋvigeno aliꞋya nafaꞋneꞋamoꞋya me fotu huteꞋya mage huꞋya hae “Kagaila nafaꞋnekamoꞋa ago kanale hu-tegeno maine.” huꞋya me-hae. ");
INSERT INTO kmu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Me hageno “Na kanale aepa heno kanale hu-tene?” huno hamavi-gegeꞋya “Ega yagemoꞋa ali tagifeno nagokete evigeno ani amuko-nakoma haiya kalimoꞋa kanale hu-tene.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hageno nefaꞋa agesa haviteno mage hie “Tamage yagemoꞋa ani kanaꞋale eneꞋvigeno YisasiꞋa ‘NafaꞋneka ago kanale maine.’ huno naha-pai-maine.” huno nehuno agaiꞋaene mukiꞋa anagaꞋaene Yisasife haviꞋya amakupi maleꞋya amametiti hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","YisasiꞋa Yutiati eteno Kalili emaineno aniꞋama hia kavala napa tu (2) kanale tokiya avame yana hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","HaenagaꞋa Yuta veaꞋmoꞋya ala imu Yelusalemu negiya kana falote higeno YisasiꞋa anilega hai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalemu kegiꞋyafi nago fiana sipi sipi afuyagamo fiana hane. Ani fiama hanelela ti kotuna male-maine. Ani li kotumo agia Yuta vayaꞋmogami* kefina Petesaitae. Ani kotutela faefuꞋa (5) fugagiꞋeta nona hane. ");
INSERT INTO kmu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","MukiꞋa kali veala aulaga asu hu-mai anagaꞋene aiya avayu hu-mainea anagaꞋene aiyaꞋaya api hu-mai anagaꞋene ani fugagiꞋeta noꞋyagafi alitalu huꞋya fae-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nago anile nemaiya kanomona kaliꞋamoꞋa teti eitiꞋa (38) kafu hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","YisasiꞋa anima faeno mainea kanoa mogeteno “Mani kanoa ayaꞋaya kana kalia alino maine.” huno huteno mage hie “KalikamoꞋma haꞋnoma hisia yafena muse nehapio?” huno havige-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Havigegeno kali kanomoꞋa Yisasife mage hie “Humave-nelina kanomoga tima aikalafuꞋma nehia kanaleꞋma naya huno navaleno tipi natesia vayala omaiya yafe nagaiꞋnige oanagi nagaila ago nagaseꞋya tipi aupaꞋa neꞋvae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Higeno YisasiꞋa mage hie “Hetika fae omanakaꞋa neꞋalika ka vuo.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Higeno aupaꞋa kaliꞋamoꞋa kanale hu-tegeno hetino fae omanaꞋa neꞋalino ka umaine. KanaleꞋma hu-tenea kana Sapati kanalele. ");
INSERT INTO kmu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ani yafe Yuta vayaꞋmoꞋya kaliꞋama haꞋno hutea kanomofe mage hae “Meni kana Sapati kanalele. NaꞋa higeka faesana omanaka alika neꞋvane? TagaiꞋma kahegi kemoꞋa Sapati kanalela ani kavala ohuo huno hu-maineane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hageno kenonaꞋamia mage hie “KaliꞋniꞋa alino kanaleꞋma hu-na-tea kanomoꞋa mage huno naha-pai-maine ‘Fae omanakaꞋa neꞋalika vuo.’ huno hu-na-tene.” huno hie ");
INSERT INTO kmu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","HigeꞋya mage huꞋya havigae “Mani kanoa hana kanomo kaha-paigeka faesana omanaka alika neꞋvane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hayanagi mukiꞋa veaꞋma anile alitaluma hagenofena YisasiꞋa aluꞋale ago umainegeno anima kaliꞋama haꞋnoma hutea kanomoꞋa mage hie “OꞋagoa kanomo ani kea hu-natene.” huno ha-mapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","HaenagaꞋa YisasiꞋa kanale hu-tenea kanomona mono nopi mainegeno mogeteno mage hie “Kagaya ago menia kalikaꞋa haꞋno hu-ga-tegeka kanale huka mainanagi kefo kavala nagoꞋene ohuo. Kefo kavaꞋma hisanana nagoꞋa kana ya aligane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Higeno mani kanomoꞋa viaꞋyamo Yuta vayafena mage huno hama-paiye “YisasiꞋa alino kanale hu-natenea kanoe.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hianagi YisasiꞋma Sapati kanaleꞋma kaliꞋama alino kanaleꞋma hu-tenea yafena Yuta vayaꞋmoꞋya aepa heꞋya amaipa kafa heteꞋya Yisasina aliꞋya haviꞋya hu-neꞋatae. ");
INSERT INTO kmu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","YisasiꞋa mage huno hama-nepaiye “NenafaꞋa mukiꞋa kanalela aliꞋyana neꞋaligeꞋna nagaiꞋenena aniꞋa huꞋna aliꞋyana neꞋalue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mani kehena YisasiꞋa “Anumaya KotiꞋa nagai NenafaꞋe.” huno nehuno “Nagaya Anumaya KotiꞋene nago kana kana hutaꞋa mainoꞋe.” hunoꞋma nehia kene Sapati kanale kahegi kema atagae-mainea yafeꞋene Yuta vayaꞋmoꞋya nagoꞋene ke vaiteꞋya “Haegahune.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","YisasiꞋa mage huno hie “Tamage-lafa huꞋna tamaha-nepauve NafaꞋneꞋamoꞋa agaiꞋage nagoke kavala nohianagi NenafaꞋma nehia kavala age-maineafe ani kavala nehie. NenafaꞋma nehia kavala NafaꞋneꞋamoꞋa ani kavala nehie. ");
INSERT INTO kmu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","NenafaꞋa NafaꞋneꞋamofena aguꞋafina nehaigeno agaiꞋma mukiꞋa nehia kavala ave-nelie. Ave-ligeno ala kavaꞋma ago hu-mainea kavala agaseno haenagaꞋa tusiꞋa ala kavakefa ave-linegetama agetama atali atalu hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","NenafaꞋa fali-mainea vayala ali he-ti-mateno hamaimuꞋa neꞋamamianagino NafaꞋneꞋamoꞋa aniꞋa huno haiya veaꞋmogamina hamaimula neꞋamamie. ");
INSERT INTO kmu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","NenafaꞋa nago kanomona fako hu noꞋateanagi mukiꞋa veala fako hu-ma-tesia tokiya yana NafaꞋneꞋamona ago amine. ");
INSERT INTO kmu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aminea yafe Nenafafema mukiꞋa veaꞋmoꞋya agima alisaga hayana aniꞋa huꞋya NafaꞋneꞋamo agia alisaga hisae. NagoꞋa veaꞋmoꞋya NafaꞋneꞋamo agima alisaga ohisayana aniꞋa huꞋya hu-tenea Nenafa agiene alisaga nohae. ");
INSERT INTO kmu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Magi nagaya tamage-lafa huꞋna tamaha-pauve nagoꞋa veaꞋmoꞋya keꞋniꞋa haviꞋya hu-natenea kanomofe ‘Tamage nehie.’ huꞋya amakupi maleꞋya amametiti hisayana ani veaꞋmogamina agola maige maige hisaya hamaimula ago ali-mainae. Ani veala hagoteꞋya fali-mai vaya kana huꞋya mainafiti hetiꞋya hamaimuꞋamia ali-mainae. HaenagaꞋa Anumaya KotiꞋa kaiyeꞋkea hu oꞋama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tamage-lafa huꞋna tamaha-nepauve nago kanamoꞋma agoꞋma falote hisiana amaku amamemaꞋamoꞋa fali-mainaya veaꞋmoꞋya Anumaya Koti nafaꞋnemo ke haviteꞋya akave malesayana he-tiꞋya agola maigahae. Ani kana ago falote hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nenafana agaiꞋafi haimuꞋmo aepa haneanagi aniꞋa huno NafaꞋneꞋamofena ‘HamaimuꞋmona aepaꞋa maiyo.’ huno hu-tene. ");
INSERT INTO kmu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","NafaꞋneꞋamofena ikapinagati emainea kanoa vayaꞋmo atenea kanoginofe kaiyeꞋkema hu-ma-teno fako hu-ma-tesia tokiyaꞋa amine. ");
INSERT INTO kmu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mani kehena atali ohiho. Nago kana falote hisiana mukiꞋa agoꞋma faligeꞋyama komufi he-vai-matenaya veaꞋmoꞋya Yisasini nagea havigahae. ");
INSERT INTO kmu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","HaviteꞋya ani komufinagati he-tiꞋya hati-lavisageꞋya kanale kava hu-mainesaya veaꞋnea hetiꞋya agola maigahayanagi kefo kava hu-mainesaya veaꞋnea he-tisageno Anumaya KotiꞋa kaiyeꞋkea hu-ma-teteno kina hu-ma-tenageꞋya haviya hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","NagaiꞋnige nago kavala nohuanagi Anumaya KotiꞋa nahapai-mainea keleti kea fako hu-neꞋama-toe. Ani yafe fatago hulama huꞋna kea fako hu-neꞋama-toe. NagaiꞋniꞋa nagesafiti ani kavala nohuanagi hu-na-tenea kanomoꞋa agaiꞋa huo hea kavaꞋage nehua yafe fatago hu-lama huꞋna kea fako hu-neꞋama-toe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","“NagaiꞋnigeꞋma hu-haleꞋna aepaꞋaꞋnima tamaha-paisugenoꞋa keꞋnimoꞋa haviya hugahianagi nago kanomoꞋma nagaifema hu-haleno tamaha-nepaiyana nagaya ago havimainoe agayama nagaifema hia kea tamage nehie. ");
INSERT INTO kmu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tamakaya vayala hu-matageꞋya Yonitega vageno YoniꞋa nagaifena ke tamage tamaha-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nagayama vayaꞋmoꞋya nagaifema hu-mainaya kea ‘Afa ke nehae.’ huꞋna huanagi tamakaya ani kea havisageno tamaugafa ali-gatisia yafe tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","YoniꞋa kaꞋni kana huno maineno hanagaligenoꞋma leana osi kanafi tamakaya agai kaꞋniꞋmoꞋma lea yafena musena hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Muse hu-mainayanagi nago tusiꞋa kanale yaꞋaene nagai aepaene tamave-li-maine. Ani yana ali-mainoa aliꞋyaniꞋae. Nenafa naminea aliꞋyama aliꞋna avaya-yesua yana YoniꞋa nagaife hu-mainea kemo agase-mainegetama agetetama nagaifena havimainae. Ani aliꞋyaꞋniꞋa Nenafa hu-na-tenea yafe tamave-li-maine. ");
INSERT INTO kmu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hu-na-tenea NenafaꞋa nagaifena ago tamaha-pai-maineanagi tamakaya agaila ageꞋa ohavitama agai aufina oꞋagetama hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hu-tenea kanomofena ‘Tamage nehane.’ hutama tamakupina maletama tamametiti nohaya yafe Anumaya Koti kea tamakupina alitama nomalae. ");
INSERT INTO kmu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Anumaya Koti kea nayo kae-malenaya avopi hapalitama ati-yetama ago age-mainae. ‘Ani avopitila agola maige maige hisuna tahaimula aligahune.’ hutama tamakesa havimainae. Ani avona nagaife huꞋya tamaha-pai-mainayanagi nagaitega esaya tamakesa nohaviye. Agola maige maige hisaya tamahaimula tamamisua yafena nagaitega nomae. ");
INSERT INTO kmu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Veala muse hu-na-teyafene huꞋna nohuanagi tamakaifena nagaya ago havimainoe. Tamakaya tamakuꞋafina Anumaya Kotifena notama-haikeꞋna neꞋagoe. ");
INSERT INTO kmu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nagaya Nenafa agile emainoanagi navaletama falu fala hutama nonatayanagi alu kanomoꞋa agaiꞋa agile esigetama afaꞋa avaletama ali falu fala hutegahae. ");
INSERT INTO kmu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tamakaya ‘Alu vayatimo alu vayatimoꞋya muse hu-lateꞋya ala tagi lamisae.’ hutama nehayanagi Anumaya KotiꞋa agaiꞋage mainegi alu Anumaya KotiꞋa omaineanagitama Anumaya KotiꞋa muse hu-lama-tesia yafena notamahaiye. NaꞋa nehayanagi hanaꞋa hutama nagaifena tamakupina maletama tamametitia hugahae? ");
INSERT INTO kmu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tamakaya nagaife ma ke hutama ohaviho ‘Nefate kaiyekea hu-la-tegahie.’ hutama tamakesa ohaviho. AꞋao, nagaya kaiyekea hu otama-tegahuanagino tamakayama taya hugahiema hutama nehaya kanomo, MoseseꞋma tamaha-paiya kemoꞋa kaiyekea hu-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosese kema havitama tamakupi maletama tamametitima haleꞋasina nagai kene aniꞋa hutama tamametitia haleꞋasine. MoseseꞋa nagaife huno kae-maleneafe aniꞋa haleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tamakaya MoseseꞋma kae-malenea kema havitama tamakupi maletama tamametitia ohunayanagitama hanaꞋa hutama nagai ke havitama tamakupi maletama tamametiti hugahae?” huno hamavi-nege. ");
INSERT INTO kmu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","HaenagaꞋa YisasiꞋa tipi kalefi uno Kalili* li kotuna takaeno umaine. Ani li kotumona nago agia Taipiliasie.* ");
INSERT INTO kmu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","MukiꞋa veaꞋmoꞋya kaliꞋamima alino kanale hu-ma-teno tokiya avame yama higeꞋyama agaya yafe akave umainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Vageno YisasiꞋene agaiꞋaenema tokaeꞋya nemaiya anagaꞋaene agoꞋyale haiꞋya mopale mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yuta vayaꞋmoꞋya Anumaya KotiꞋma amakinagomogami amaugafama ali-gati-mainea yafe amakesa havisaya imu* kisaya kanaꞋa ago aupa hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","YisasiꞋa ageno ataleno ageana mukiꞋa veaꞋmoꞋya agaitega neꞋageno amaketeno Filipife mage hie “Hanateti ani veaꞋmoꞋyama nesaya kavela miya hugahune?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","YisasiꞋa Filipina ayevataga huno mani kea nehuno agayama hugahema hia yana ago havimaineno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","FilipiꞋa mage hie “Nago kanomoꞋa tu hataletia (200) kanale aliꞋyana aliteno miya alino ani monea ataleno kaveꞋma miya hisiana ma mukiꞋa veakefafina osi osi huꞋya kavela alite alite hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Higeno nago kanoa agaiꞋaenema tokaeꞋya nemaiya anagaꞋamogamipitila, Saimoni Pitana aganaꞋamoꞋa EtaluꞋa, mage huno hie “Nago nafaꞋnemoꞋa faefuꞋa (5) mayagi tole noyamegi huno ali-lino maine. Veakefamo alino ala higeno mani kavela osi kanoꞋa haneanagi hanaꞋa huno taya hisie?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Higeno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋamofe mage hie “MukiꞋa veakefa ‘Mopale maiho.’ hutama hama-paiho.” huno hama-paiye. Ani kumala mukiꞋa apeꞋage hanea kumalagiꞋya mukiꞋa veakefa mopale mainae. Ani veala faefu tauseniꞋa (5,000) veneꞋne mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","YisasiꞋa ani maya alino Anumaya Kotitega muse huno havigeteno mukiꞋa mopale mainaya veaꞋmogamina fako huno amamite amamite hu-maine. Noyamene ani kava higeno mukiꞋa veaꞋmoꞋya ani kavela nageno amamu hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nemamu hu-male-tageno YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋamofena mage hie “MukiꞋa atupa-tapa kavela alitalu hu-tama maleho. NagoꞋa osi osi atupa vitali vitali ohiho.” ");
INSERT INTO kmu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Amakaya mukiꞋa veala faefuꞋa (5) maya kanoꞋafiti neteꞋya atalaya atupayaga alitalu huꞋya tuelufuꞋa (12) kula ai-havate-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","AnifiꞋma mainaya veakefamoꞋya YisasiꞋma hu-mainea tokiya avame yana ageteꞋya mage hae “Tamage huno Anumaya Kotina aune kanoꞋa hu-tesigeno ma mopafima egahiema huno hu-mainea kanoa mama ago emaine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hageno YisasiꞋa vayaꞋmoꞋyama hisaya kavala aguꞋafinaga mage huno havimaine “Mani vayaꞋmoya nagaila sauveꞋami maisua yafe navalegahe nehae.” huno nehuno neꞋamataleno agaiꞋage agoꞋyafi hai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","YagemoꞋa lavi-falegeno une avamemaꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋamoꞋya ala ti agegayalega uteꞋya tipi kalefi asaga hu-maiꞋya Kapaneamu vayana YisasiꞋa amakaiꞋenena oꞋune. OꞋvigeꞋya yaufa uge uge huꞋya neꞋvageno hani ki-ma-tene. ");
INSERT INTO kmu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ala yasigefamoꞋa eno tina melino mo ai-yahae me ai-yahae huno tusiya hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tusiya higeꞋya tipi kalefima mainaya vayaꞋmoꞋya yosaleti vailagai-liꞋya vayana nagoꞋa ayaꞋayaꞋa sikisiꞋa (6) kilomita ti kotuꞋmona amuꞋnopi neꞋuꞋya agayana YisasiꞋa ti avoyale aiya ayeme ayeme tipi kalema hanelega neꞋegeꞋya ageteꞋya tusiya huꞋya kolia hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Koli nehageno YisasiꞋa mage huno hama-paiye “Kolia ohiho mamona nagayae.” huno hama-nepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hama-paigeꞋya vayaꞋmoꞋya Yisasina tipi kalefi haisaga hu-maisia yafe muse nehuꞋya tipiti avalesaga nehae. Ani tipi kalemoꞋa visaya kumatela aupaꞋa uvaꞋyi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","FaeteꞋya kotigeꞋya tikotuꞋmona atu kaiyaga mainaya veaꞋmoꞋya ageteꞋya mage hae “Nagoke tipi kaleꞋage hanegeta age-mainone. YisasiꞋenema tokaeꞋya nemaiya anagaꞋage ani lipi kalefi vayanagi YisasiꞋa oꞋunegi ani vayala amakaiꞋamige umainae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ani kumala YisasiꞋa Anumayamotega nunamu huno muse huteno kavela amamigeꞋya ne-mainaya kumate nagoꞋa lipi kaleyaga Taipiliasi kumateti anile neꞋae. ");
INSERT INTO kmu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","NeꞋeꞋya mukiꞋa veaꞋmoꞋya megayana YisasiꞋenema tokaeꞋya nemaiya anagaꞋene omainageꞋya megeteꞋya tipi kalefi asaga hu-maiꞋya Kapaneamu Yisasife mo atiye-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Atiyeme valegati atu kaiyaga umaineꞋya Yisasina mogeteꞋya mage hae “Hulave-nelina kanomoga na yu ma kumala meli-mainane?” huꞋya havinegae. ");
INSERT INTO kmu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Havigageno YisasiꞋa mage hie “Nagaya tamagelafa huꞋna tamaha-nepauve tamakaya kaveꞋma tamamugetama nageno tamamuꞋma hu-mainea yafe natia neꞋayayanagi nagaila tokiya avame yama hugetama age-mainaya yafena natia noꞋayae. ");
INSERT INTO kmu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tamakaya kasalisia kavefena maitama ati oꞋayeho. Maige maigema hisaya kavefeꞋke maitama atiyeho. Nagaya NenafaꞋa, Anumaya Koti hu-na-tenea kanomoꞋna ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna mani kavela tamamigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","HigeꞋya mage huꞋya havinegae “Tagaya hanaꞋa huta Anumaya Koti aliꞋyana alisune?” huꞋya havinegae. ");
INSERT INTO kmu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hageno YisasiꞋa mage hie “Mani aliꞋyana Anumaya KotiꞋa muse nehia aliꞋyane. Agayama hu-tegeno emainea nafaꞋnemofe tamakupi maletama tamametiti hisaya yafe muse nehie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","HigeꞋya mukiꞋa veaꞋmoꞋya mage hae “Hana augafa tokiya avame yana tave-lisanageta ageteta tagupina maleta tametiti hisune? ");
INSERT INTO kmu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nayona taginagomoꞋya vaya omai kotega maineꞋya nago kavela agia manae nehaya kave ne-mainayane huno kae-maleneane ‘Ikapinagati maya amamigeꞋya ne-mainae.’ huno kaemaleneane.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hageno YisasiꞋa mage hie “Nagaya tamage-lafa huꞋna tamaha-nepauve ikapinagati elavi-mainea maya MoseseꞋa agaiꞋa oꞋamaminegi NenafaꞋa ikapinagati tama maya menia nelamamie. ");
INSERT INTO kmu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Anumaya KotiꞋma tamamia mayamoꞋa maꞋa hu-maine nago kanoa ikapinagati ea maya mainea yafe ma mopale mainaya veala hamaimula amamine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","HigeꞋya mage huꞋya hae “Ala kanomogae mukiꞋa kanalela ani maya tamige lamige huo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hageno YisasiꞋa mage huno hama-nepaiye “Nagaya hamaimu amamisua maya mainoe. Nagaitegama esia veaꞋmoꞋya nagoꞋene amakala otegahae. Nagayama hu-lama-tesua yafe amakuꞋafi maleꞋya amametiti hisaya veaꞋmoꞋya tifena oꞋamakegahae. ");
INSERT INTO kmu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nagaya ago tamaha-paugetama nagaila ago nagemainayanagi nagaya hu-lama-tesua yafena tamakupina maletama tamametitia nohae. ");
INSERT INTO kmu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","MukiꞋa NenafaꞋma naminea veaꞋmoꞋya nagaitega egahae. Nago kanomoꞋma nagaitegama esigeꞋnahena ‘Eteka vuo.’ huꞋna hu oꞋategahue. ");
INSERT INTO kmu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hu-na-tenea kanomoꞋma haisia kavaꞋma hisua yafe ikapinagatila hu-nategeꞋna emainoe. NagaiꞋniꞋa nagesafiti kavala hugahe omenoe. ");
INSERT INTO kmu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hu-na-tenea kanomoꞋma haisia kavaꞋma hisuana maꞋa hu-maine naminea veaꞋnefitila nagoke kanoꞋa fanane ohisageꞋna ma mopama haꞋnoma hisia kanafina mukiꞋa fali-mainesafiti ali he-ti-matesugeꞋya agola maige maige hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","NenafaꞋa maꞋa yafe musena nehie mukiꞋa veaꞋmoꞋya nafaꞋneꞋamona neꞋageꞋya agayama hu-matesia yafe havilama huꞋya amakupi maleꞋya amametiti hisayana agola maige maige yana aligahae. AlitesageꞋna ma mopama haꞋno hisia kanafina nagaya fali-mainesafitila ali he-ti-ma-tesugeꞋya agola maige maige huꞋya maigahae.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","YisasiꞋma “Nagaya ikapinagati elavi-mainoa maya mainoe.” huno hu-mainea kehe Yuta veaꞋmoꞋya Yisasifena ke vaiꞋya kasagoꞋya ke hu-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mage huꞋya nehae “Ma kanoa YisasiꞋa, Yosefe nafaꞋnefi? NefaꞋene itaꞋamoene ago age-mainone. NaꞋa higeno menia ‘Ikapinagati elavi-mainoa kano mainoe.’ huno nehie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hageno YisasiꞋa kenonaꞋamia mage huno hie “Tamakaya tamakaitamifima kasagoꞋya kema hatagaya kea ataleho. ");
INSERT INTO kmu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nago kanomoꞋa nagaitega agaiꞋa nomegi hu-na-tenea Nenafa avayu hinageno nagaitega enageꞋna nagaya ma mopama haꞋno hisia kanafina fali-mainesifiti ali he-ti-tesugeno haimula aligahie. ");
INSERT INTO kmu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Anumaya Koti aune vayaꞋmoꞋya mage huꞋya kae-malenayane MukiꞋa veaꞋmogamina Anumaya KotiꞋa hu-maveli hamaveli hugahie huꞋya kae-malenayane. MukiꞋa veaꞋmoꞋya NenafaꞋma hu-mavelia kea haviteꞋya akave malenaya veaꞋmoꞋya nagaitega neꞋae. ");
INSERT INTO kmu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nago kanomoꞋa Nenafana oꞋageneanagi Anumaya Kotitegati emainea kanomoꞋa agaiꞋage Nefana age-maine. ");
INSERT INTO kmu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tamage-lafa huꞋna tamaha-nepauve nagaifema haviꞋya amakupi maleꞋya amametiti hu-mainaya veaꞋmoꞋya agola maige maige hisaya hamaimula ago ali-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nagaya nagaiꞋniꞋa hamaimu amamisua maya mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ani tamakinagomoꞋya vaya omai kotega maineꞋya nago kaveꞋmo agia manae huꞋya nahaya kave ne-mainayanagi ago fali-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Fali-mainayanagi maꞋa augafa ikapinagati elavia maya nesaya veaꞋmoꞋya ofaligahae. ");
INSERT INTO kmu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nagaya Ikapinagati elavi-mainea maya mainoe. Ani mayamona haimuꞋa hane. NagoꞋa veaꞋmoꞋya mani mayama nesayana agola maige maige hugahae. Ani maya nagaiꞋniꞋa naugafae. Ma mopaleꞋma mainaya veala agola maige maige hisaya yafe naugafa ataleteꞋna faligahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","HigeꞋya Yuta vayaꞋmoya mani kehena ke vaiꞋya mage huꞋya hae “Mani kanomoꞋa hanaꞋa huno augafaꞋa taminegeta nesuna yafe nehie?” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nageno YisasiꞋa mage hie “Nagaya tamage-lafa huꞋna tamaha-nepauve tamakayama ikapinagati emainoa kano vayaꞋmo na-tenea nafaꞋnemoni naugafaene kolaniꞋaenema onesayana maige maige hisaya tamahaimula tamakupina omalegahie. ");
INSERT INTO kmu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","NagoꞋa veaꞋmoꞋya naugafaene kolaniꞋaenema nesayana agola maige maige hisaya hamaimula ago ali-mainayanagiꞋna ma mopama haꞋno hisia kanafina fali-mainesafitila ali he-ti-ma-tegahue. ");
INSERT INTO kmu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nagai naugafa, kave tama hane. KolaniꞋaenena tama li hane. ");
INSERT INTO kmu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","NagoꞋa veaꞋmoꞋya naugafaene kolaniꞋaenema nesayana nagai nagupi mainageꞋna nagaya aniꞋa huꞋna amakai amakupina mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","NenafaꞋa haimuꞋaene kanomoꞋa hu-nateneanagino nahaimula namigeꞋna mainoe. NagoꞋa veaꞋmoꞋya nagai naugafama nesayana nagai tokiyafiti hamaimula aliteꞋya maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ikapinagati elavi-mainea maya maꞋa augafa maya hane. Yuta vayaꞋmogami amakinagomoꞋya ne-mainaya maya kana ohune. Ani maya neteꞋya ago fali-mainayanagi nagoꞋa veaꞋmoꞋya ikapinagati elavi-mainea mayama nesayana agola maige maige hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","YisasiꞋa mani kea Kapaneamu mono nopi huno hama-pai-mainea ke. ");
INSERT INTO kmu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","MukiꞋa akaveꞋma neꞋvaya veaꞋmoꞋya ani kea haviteꞋya mage huꞋya hae “Manima hu-mave-lia kemoꞋa tusiꞋa kana nelahaiye. Hana kanomo mani kea haviteno akave malesia amukoꞋa hane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hageno YisasiꞋa ani kehena akaveꞋma neꞋvaya veaꞋmoꞋya kasagoꞋya kema haya kea ago aguꞋafinaga haviteno mage huno hie “Mani kemoꞋa otamahaifi? Natalesaya tamakesa nehavifio?” huno hamavi-nege. ");
INSERT INTO kmu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nagayama, ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋna, eteꞋnama hagoteꞋna nemauva kumateꞋma visugetama nagesayana hanaꞋa hugahae? ");
INSERT INTO kmu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anumaya Koti AvamuꞋmoꞋa maige maige hisaya tamahaimula nelamianagi tamakai tamaugafamoꞋa nagola kanale yana notamamie. Nagaya Anumaya Koti AvamuꞋmoꞋa naminea ke tamaha-pai-mainoe. Ani kemoꞋa maige maige hisaya tamahaimula nelamamie. ");
INSERT INTO kmu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mani kea tamaha-pai-mainoanagi “NagoꞋamogatama ani kehena tamakupina alitama nomalae.” huno nehuno nayoma aepa he-mainea kanafina YisasiꞋa amakupi maleꞋya amametiti ohisaya veaꞋene agaiꞋama agesi huno kame ya hu-tesia kanoene ago haviline. ");
INSERT INTO kmu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","YisasiꞋa nagoꞋene mage hie “Ani yafe mage huꞋna tamaha-pai-mainoane nagoke veala amakaiꞋamia nagaitega omegahagi Nenafa esaya amaku amakesa amamisigeꞋya nagaitega egahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mani kema higeꞋya kasagoꞋya akaveꞋma umainaya veala eteꞋya mai-yahae huꞋya ataleꞋya umaineꞋya nagoꞋene agaiꞋenena me vai-oꞋayenae. ");
INSERT INTO kmu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","YisasiꞋa tuelufuꞋa (12) anagaꞋamogamife mage huno hamavi-nege “Tamakaya aniꞋa hutama nagaila natalegahao?” huno hamavi-nege. ");
INSERT INTO kmu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hamavi-gegeno Saimoni PitaꞋa kenonaꞋa mage hie “Anumayamoga hana kanomote visune? Kagai kemoꞋa maige maige hisuna tahaimula nelamie. ");
INSERT INTO kmu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tagaya ago havilinone kagaya alu aotage kavaꞋage kanoa Anumaya KotiꞋa hu-gategeka emainananagita kagaifena tagaya tagupi maleta tametitia ago hu-mainone.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Higeno YisasiꞋa mage hie “Tamakaya tuelufuꞋa (12) anagaꞋnimogatamina nagaya ago hapali-lama-tenoamagi tamakaipina nago kanomoga Kefo AvamuꞋene mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mani kema hiana Yutasife hu-maine. YutasiꞋa Saimoni Isakaliotina nafaꞋneꞋamoꞋe. TuelufuꞋa (12) anagapiti Yisasina agesi huno kame ya hu-tesia kanohe hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ani kanafina Yutia kotega vayaꞋmoꞋya haesaya amakesa haviya yafe YisasiꞋa Yutia vai-oꞋayeno Kalili kotega ute ete huno maine. ");
INSERT INTO kmu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ala kana, fugagiꞋeta nopi maineꞋya imu negiya kana aupa nehie. ");
INSERT INTO kmu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aupa higeꞋya Yisasina aganaꞋamoꞋya mage huꞋya hapaiye “Ma kumala neꞋataleka Yutia kotega ugeꞋya kakaveꞋma nehaya veala kagayama tokiyakaletiꞋma alina aliꞋyana ageho. ");
INSERT INTO kmu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nago kanomoꞋa ‘MukiꞋa veaꞋmoꞋya nagesae.’ huno kesi aliꞋyana noꞋalia yane. Kagaya ani tokiya aliꞋyana mukiꞋa ma mopale veaꞋmogami amaufi aligeꞋya ani aliꞋyakaꞋa ageho.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hayanagi ani aganaꞋamoꞋya agaifena haviꞋya amakupi maleꞋya amametitia ohunaya yafe ani kea hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","YisasiꞋa mage hie “AliꞋyaniꞋa amave-lisua kanaꞋniꞋa falote ohunegi tamakaya mukiꞋa kanalela tamakaiꞋma tamahaisia kavala hisaya kanatamilelagi afaꞋa haiho. ");
INSERT INTO kmu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nagai ke nohaviya veaꞋmoꞋya tamakaifena musetami nehagi nagaya ‘Ase ohu kava nehae.’ huꞋna hama-pauva yateti nagaila amaipa kafa he-nenatae. ");
INSERT INTO kmu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tamakaya Yelusalemu imulega viho. Nagaya aliꞋya kanaꞋniꞋa falote ohuneanagiꞋna ani yafe menia imulega oꞋugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ani kea hama-paiteno oꞋuno afaꞋa Kalili kotega maine. ");
INSERT INTO kmu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","AganaꞋamoꞋya imulega ago utageno YisasiꞋa haenaga anilega hai-maine. Vaya amaulela oꞋunegi kesi fala-kino umaine. ");
INSERT INTO kmu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","12","Falakino umainegeꞋya Yuta vayaꞋmoꞋya agayama imuleꞋma esiafene huꞋya moge mege hugetayana higeꞋya mage huꞋya hae “Ani kanoa hanate maine?” huꞋya hamavi-gageꞋya anifima alitalu hu-mainaya veaꞋmoꞋya Yisasifena sumi sumi huꞋya nagoꞋamoꞋya “Kanale kanoe.” huꞋya nehageꞋya nagoꞋamoꞋya “Vaya aye-mavataga hugeno omai kanoe.” nehageꞋya huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hayanagi Yuta vayaꞋmogamife koli haya yafe ani kea ala kea ohunagi osi kefiti sumi sumi huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ani imu kanamo amuꞋnopinaga YisasiꞋa ala mono nopi haino hu-mave-li-maine. ");
INSERT INTO kmu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hu-mave-neligeꞋya Yuta veaꞋmoꞋya tusiꞋa amamaꞋyo neꞋaiꞋya mage huꞋya hae “Mani kanoa hana avo nopi uno age-mainea kanomo avopitila taha-nepaiye? Avo nopina oꞋunea kanomoꞋa hanateti ani kea haviline?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hageno YisasiꞋa kenonaꞋamia mage huno hama-paiye “Hu-mave-nelua yana nagesafiti tamaha-nopaugi nevaꞋyaꞋma hu-na-tegeꞋna emainoa kanomo naha-pai-mainea ke tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","NagoꞋa veaꞋmoꞋya ‘Anumaya Kotina haisia kava hugahune.’ huꞋyama hisaya veaꞋmoꞋya ma ma hu-lamave-nelua kea nagesafiti tamaha-nepaufi Anumaya KotiꞋa naha-pai-mainea ke tamaha-nepaufi havigahae. ");
INSERT INTO kmu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Havigahayanagi nago kanomoꞋa agaiꞋa agesafiti kema hisia kanomoꞋa ‘Nagai nagi alisaga hisae.’ huno nehianagi nago kanomoꞋma ‘NevaꞋyaꞋma hu-na-tenea kanomo agi alisaga hisae.’ huno hisia kanoa kanale agu agesaene kano mainea yafe havigea ohugahie. ");
INSERT INTO kmu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","MoseseꞋa kahegi kea ago tamaha-pai-mainea ke tamakaitamifina nago kanomoga ani kemona akavela nomalane. NaꞋa higetama menia nagaila nahaegahena nehae?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","HigeꞋya melitalu hu-mainaya veaꞋmoꞋya mage huꞋya hae “Kefo avamuꞋmo kagaila kagusafina maineno kavale-liteno nehie. TaꞋya kahaegahena nehageka nehane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hageno YisasiꞋa mage huno hama-paiye “Nagaya nago tokiya aliꞋyama Sapati kanaleꞋma alua aliꞋyafe tamamaꞋyoa neꞋaiye. ");
INSERT INTO kmu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","MoseseꞋa nayona ‘NafaꞋnetamimona agoya amega augafaꞋa taga hu-taleho*.’ huno hama-pai-maine. Ani kavala agaiꞋa alino aepa ohenegi Mosesena aginagomoꞋya ani yana aliꞋya aepa he-mainae. NeꞋmoꞋma agoya anoꞋyaꞋa tagama hayana Sapati kanale taga hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tamakaya MoseseꞋma kahegi kema oꞋatagaesaya yafe Sapati kanalela neꞋmo agoya anoꞋyaꞋa taga nehayanagi naꞋa higetama nagayama Sapati kanalema nago kanoma mukiꞋa augafama aliꞋna hilatoma hua yafena tamahaiya vai-nena-tae? ");
INSERT INTO kmu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Havigu ke nehae. AfaꞋa amega yate agetetama ‘Kefo kava nehane.’ hutama nehagi tama kava hisigetama agetetama kaiyekea hu-teho.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","NagoꞋa Yelusalemu mainaya veaꞋmoya YisasiꞋma hia ya ageteꞋya mage hae “Ma kanoa ala vayaꞋmoꞋyama haegahunema haya kanofi? ");
INSERT INTO kmu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ageho vaya amaulagafina kea nehianagi nago yana hu noꞋatae. Kava vayaꞋmoꞋya ma kanomofe Anumaya KotiꞋa veaꞋmogati taugafa ali-gatigahie huno hu-tegeno emainea kanoa mainea yafe havimainafi? ");
INSERT INTO kmu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anumaya KotiꞋa taugafama ali-gatigahema hu-tegeno emainea kanomofena ‘Hana kumateti emaine?’ huꞋya hugahayanagi ma kanoma ea kumala ago age-mainone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hageno YisasiꞋa ala mono nopi haino maineno hu-mave-nelino ala kefiti mage huno hie “Tamakaya nagaifena ago havilama hutama nage-mainafi? Nagayama emainoa kumaꞋenefe havimainafi? Nagaya nagaiꞋni nagesafiti omenogi nagaiꞋma hu-natenea kanomoꞋa tokiyaꞋage kano maineanagitama tamakaya agaila oꞋagenae. ");
INSERT INTO kmu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","OꞋagenayanagi nagaya agaiꞋene mainoleti hu-nategeꞋna emainoafenagiꞋna ago age-mainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","HigeꞋya agaila atafa hugahe hayanagi falisia kanaꞋa yaufa falote ohunea yafe augafalela nago kanomoꞋa atafa ohune. ");
INSERT INTO kmu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ohunayanagi mukiꞋa anifima mainaya veaꞋmoꞋya agaifena haviꞋya amakupi maleꞋya mage hae “Anumaya KotiꞋma taugafa ali-gatigahema hu-tenea kanoma esiana ma mainea kanomoꞋma tokiya avame yama hu-mainea kavala agasesifi? AꞋao oꞋagasegahie. Ma kanoa Anumaya KotiꞋma taugafa ali-gatigahema hu-tegeno emainea kano maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","NehageꞋya Falasia vayaꞋmoꞋya agaifema sumi sumiꞋma haya kea haviteꞋya mono note kava vayaꞋene Falasia vayaꞋene ati vayaꞋmogamina hu-ma-tageꞋya Yisasina me haesaya malesaya kava huꞋya avalegahe neꞋae. ");
INSERT INTO kmu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","NeꞋageno YisasiꞋa mage huno hie “Osi kana kanoꞋa tamakaiꞋenena maiteꞋna hu-nategeꞋna emainoa kanolega ugahue. ");
INSERT INTO kmu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tamakaya nagaifena natiyegahayanagi nagaila onagegahae. Visua kumatela tamakaya oꞋugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","HigeꞋya Yuta vayaꞋmoꞋya amakaiꞋamifi huge havige huꞋya mage hae “Agayama ‘Nagaila onagegahaema.’ hia kumala hanamaꞋalegafiga hanegeno nehie? Agaya Kaliki kotega Yuta vayaꞋmogatina tataleꞋya umainaya kotega umaineno Kaliki vea hu-mave-li hamaveli hugahe nehifi? ");
INSERT INTO kmu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Agayama hia kea ‘Tamakaya nagaila natiyegetesayana onagegahae. Visua kumatela oꞋugahae.’ hunoꞋma hia kemo aepaꞋa naꞋane huno nehie?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Imu kime haiꞋya mogi haꞋnoma haya kana tusiꞋa ala kanae. Ani kanale YisasiꞋa he-tino ala kefiti mage hu-maine “NagoꞋa veaꞋma tifema amakesia veala nagaite eꞋya tina me neho. ");
INSERT INTO kmu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","NagoꞋa veaꞋmoꞋya nagaife haviꞋya amakupi maleꞋya amametitia hisayana Anumaya Koti autaꞋmafina ani veaꞋmofe mage hu-maineane ‘Ofali tina kasagoꞋya timo aguꞋafina hava-te-maineno vali-lavino tavigahie.’ huno hu-maineane.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","YisasiꞋa anima hia kea “Alu Aotage AvamuꞋamofe hu-maine.” Ani Alu Aotage Avamula Yisasifema haviꞋya amakupi malesaya vaya amamite amamite hugahe nehie. Ani kema hia kanafina YisasiꞋa yaufa ikapinaga ohainea yafe Alu Aotage AvamuꞋamoꞋa yaufa omenegeno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","NagoꞋa alitalu hu-mainaya veaꞋmoya ani kea haviteꞋya mage hae “Tamage-lafa huno mani kanoa Anumaya Koti aune kano emaine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","HageꞋya nagoꞋa veaꞋmoꞋya “Anumaya KotiꞋa taugafa ali-gatigahe hu-tenea kano maine.” nehageꞋya nagoꞋa veaꞋmoꞋya “Anumaya KotiꞋa taugafa ali-gatigahe hu-tenea kanomoꞋa Kalilitila falote ohugahie. ");
INSERT INTO kmu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anumaya Koti autaꞋmafina mage huno kae-maleneane ‘Anumaya KotiꞋa taugafa ali-gatigahema hu-tenea kanoa Tevitina aginagomo egahie. TevitiꞋma Petelehemu nemaiya kumate ategahie.’ huno kae-maleneane.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ani veaꞋmoꞋya agaifena tolefi ali fako huꞋya alu ke alu ke nehae. ");
INSERT INTO kmu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","HageꞋya nagoꞋamoꞋya “Agaila atafa hiho.” huꞋya hayanagi nago kanomoꞋa augafalela atafa ohune. ");
INSERT INTO kmu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ati vayala eteꞋya mono note kava vayateꞋene Falasia vayateꞋene vageꞋya mage huꞋya hamavigae “NaꞋa higetama avaletama nomae?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","HageꞋya ati vayaꞋmoꞋya mage huꞋya hae “YisasiꞋma hia kea nayona nago kanoꞋmoꞋa aniꞋa augafa kea ohigeta ohavinona yafe avaleta nomone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","HageꞋya Falasia vayaꞋmoꞋya mage hae “TamakaiꞋenena ago aye-lamavataga hu-mainefi? ");
INSERT INTO kmu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ifi nagoꞋa kava vayapi Falasia vayapi ‘Yisasifena haviꞋya amakupi maleꞋya amameti hu-mainae.’ huꞋya haya kea havimainafi? ");
INSERT INTO kmu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","AꞋao kava vayala aniꞋa ohunagi kahegi kema ohaviꞋyama alitaluma hu nemaiya veaꞋmogamina Anumaya KotiꞋa hai vai-ma-teno haniki-mainesia yapina hu-mategahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Hageno NikotimasiꞋa nayoma YisasiteꞋma emainea kanomoꞋa amakaipi maineanagino mage hie “Tagai mono kemoꞋa mage huno hie ‘Hagotetama nofiꞋma hu-tesaya kanomona ‘NaꞋa maꞋa humainoe.’ huno hisia kea havitetama kefo kavaꞋma hu-mainesia kanomona nofila huteho.’ huno hu-maineane.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","NehigeꞋya “Kagaya kagaiꞋenena Kaliliti kano mainapi? Anumaya Koti ke kae-malenaya kefina hapalika havilama huteka kagaiꞋenena havio Kaliliti nagola aune kano omegahie.” huno hu-maineane huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","NehageꞋya mukiꞋa veaꞋmoꞋya atagu-feꞋya ataleꞋya kumaꞋamilega ute ete hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","MukiꞋa veaꞋmoꞋya kumaꞋamilega ute ete hageno YisasiꞋa Olivi yosa hanea agoꞋyafi hai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","KegeꞋafiti YisasiꞋa he-tino ala mono nopi umainegeꞋya veaꞋmoꞋya melitalu hageno YisasiꞋa mopale maineno mono kea hama-nepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hama-nepaigeꞋya kahegi kema havilinaya anagaꞋene Falasia vayaꞋene nago ala alu vene moli nehigeꞋya ageteꞋya avaleꞋya alitalu hu-mainaya veaꞋmogami amaufi me he-ti-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Me he-ti-teteꞋya Yisasife mage huꞋya nehae “Hu-maveli kanomoga ma aꞋmoꞋa alu vene moli nehigeta ageteta avaleta neꞋone. ");
INSERT INTO kmu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","MoseseꞋma kahegi kema taminea kemoꞋa maꞋa hu-maine ‘Ani kavaꞋma hisia aꞋmona yafateti haetama he-vai-teho.’ huno hu-mainegi ‘Kagaya naꞋane huka nehane?’ huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Agaifema mani kema hayana aye-vataga huꞋya nagoꞋa havige hisigeta atafa huta kaiyeke hu-tegahune.” huꞋya hayanagi YisasiꞋa ape huno mopafi maineno aginagoleti avo negae. ");
INSERT INTO kmu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Avo negaegeꞋya anileꞋma he-tiꞋya maineꞋya mani kema havige havigema haya vayafe YisasiꞋa he-tino mage hie “TamakaipitiꞋma nago osi kefo yakaꞋa omalenesia kanomoga hagoteka yafana hagaꞋyu huka mani aꞋmo augafalela aiko-lio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mage huteno eteno ape huno mopafi avo negae. ");
INSERT INTO kmu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mani kema higeꞋya mukiꞋa atagu-feꞋya ute ete hageꞋya hagoteꞋya vayatamamoꞋya ataleꞋya vageꞋya haenaga mukiꞋamoꞋya ataleꞋya ute ete hageno YisasiꞋa ape huno mainegeno ani aꞋmoꞋa aule he-tino maine. ");
INSERT INTO kmu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mainegeno YisasiꞋa he-tino ani aꞋmofena mage huno hie “Ma aꞋmogae mani vayala hanatega vae? Nago kanomoꞋa kagaila kaiyekema hu-gatesia kanoa omainefio?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Higeno mani aꞋmoꞋa mage hie “AꞋao, ala kanomogae, nago kanoa omaine.” huno higeno YisasiꞋa mage hie “Nagaya nagaiꞋenena kaiyekea hu okategahugi afaꞋa ugananagi eteka nagoꞋene kefo yana ohuo.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","HaenagaꞋa YisasiꞋa mono nopi alitalu hu-mainaya vayaꞋyagahe mage hu-maine “Nagaya ma mopafi veala aye hale-ma-tesua kano mainoe. Nagai nakaveꞋma malesaya veaꞋmogatama maige maige tamahaimula hanea hale yana alitetama haniki yapina ute ete ohugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","HigeꞋya Falasia vayaꞋmoꞋya Yisasifena mage huꞋya hae “Kagaya kagaikaꞋa kehe hu-falote nehananagi kekahena havita tametiti ohugahune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hageno YisasiꞋa mage huno hie “Tamage nagaya nagaiꞋniꞋahe kea nehuanagi hua kehena havitama tamameti hiho. NaꞋafene nagaya aepama heꞋnama emainoa kumaꞋene visua kaꞋene age-mainoanagitama tamakaya nagayama emainoa kumaꞋene visua kaꞋene oꞋagenae. ");
INSERT INTO kmu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tamakaya ma mopafi veaꞋmogamina no maiyateti fako nehayanagi nagaya nago kanomo no maiyana fako nohue. ");
INSERT INTO kmu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fako nohuanagi nagaya nago kanomoma fako hu neꞋa-tesugenofena kema hua kelela havitama tamameti hiho. Nagaya nagaiꞋnige fako nohuanagi hu-natenea NenafaꞋa nagaiꞋene tole huno aliꞋyana neꞋalino fako nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tamakai mono kemoꞋa mage huno nehie ‘Tole kanolatamoganima keꞋanimoꞋma nagoke kateꞋma visiana keꞋanimoꞋa tamage hugaꞋe.’ hutama nehayane. ");
INSERT INTO kmu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nagaya nagaiꞋniꞋahena kea hu-falote huꞋna nehugeno nagaiꞋma hu-nategeꞋna emainoa NenafaꞋa nagaifena aniꞋa huno hu-falote nehie.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","HigeꞋya haviteꞋya Falasia vayaꞋmoꞋya mage huꞋya havigae “NegafaꞋema hana kanoa hanate maine?” huꞋya havigageno YisasiꞋa mage hie “Tamakaya nagaiꞋma onagenayana Nenafana aniꞋa hutama oꞋagenae. NagaiꞋma nage-mainaleꞋasipa Nenafana aniꞋa hutama age-mainaleꞋasine.” ");
INSERT INTO kmu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","YisasiꞋa mani kea ala mono nopina muse yama nemalaya kaiyaga maineno mani kea hu-mave-lianagi agayama falisia kanaꞋamoꞋa aupa ohunea yafe nago kanomoꞋa agaila atafa ohune. ");
INSERT INTO kmu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","YisasiꞋa eteno nagoꞋene mage hu-maine “Nagaya ago visugetama nagaifena natiyegahayanagi tamakaitami kefo yatamia oꞋataletama hanesigetama faligahae. Nagayama visua katela tamakaya oꞋugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","HigeꞋya Yuta vayaꞋmoꞋya amakaiꞋamifina mage huꞋya hae “Nagayama visua katela tamakaya oꞋugahae hunoꞋma hia kemona aepaꞋa agaiꞋa augafa hae-faligahe nehifi?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hageno YisasiꞋa mage huno hie “Tamakaya afetegati emainayanagi nagaya anafinagati emainoe. Tamakaya ma mopafiti emainayanagi nagaya ma mopafiti omenoe. ");
INSERT INTO kmu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","NaꞋafene nagaya tamakaila ago tamaha-pai-mainoe ‘Tamakaitami kefo yatamia oꞋatalesageno hanesigetama faligahae.’ huꞋna hu-mainoane. Tamakaifema nagaya ‘MaꞋa kano mainoe.’ huꞋna hu-mainoa kehe havitama tamakupi maletama tamametitima ohisayana kefo yatamia oꞋataletama hanesigetama faligahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","HigeꞋya “Kagaya tagae?” huꞋya havigageno YisasiꞋa mage hie “Nagaya laꞋnae huꞋna tamakaila hagoteꞋna tamaha-pai-mainoane. ");
INSERT INTO kmu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tamakaifema kasagoꞋya kema, hu-lamateꞋna fako hisua kea hane. NagaiꞋma hu-na-tegeꞋnama emainoa kanomoꞋa tamage keꞋage kano mainegeꞋna agaitegati nagaya havimainoa ke ma mopafi veaꞋmogatamina tamaha-nepauve.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ani kea Nefafema nehigeꞋyagi amakaya haviꞋya aepaliꞋya ohavinae. ");
INSERT INTO kmu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ohavinaya yafe YisasiꞋa mage hie “Tamakayama ikapinagati emainoa kanoa vayaꞋmo natenea kanomoꞋnina yafaga yosale alisagama hisaya kanafina tamakaya nagayama ‘Ani kano mainoe.’ huꞋna hu-mainoa yafe havilama hutama havigahae. Nagaya nagaiꞋni nagesafitila nago yana nohue. AꞋao nagaila Nenafama hu-mainea keꞋage nehugetama nehavie. ");
INSERT INTO kmu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","NagaiꞋma hu-natenegeꞋna emainoa NenafaꞋa nagaiꞋene maineno mukiꞋa kanalela agayama museꞋma hia kavaꞋma huafenagino nagaila nonatale.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","HigeꞋya kasagoꞋya veaꞋmoꞋya YisasiꞋma hia ke haviteꞋya amakupi maleꞋya amametiti nehae. ");
INSERT INTO kmu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","YisasiꞋa amakupima maleꞋya amametitima haya Yuta vayafena mage hie “Tamakaya nagai kema mukiꞋa kanafima akaveꞋma malesayana nagai ke havisaya anagaꞋniꞋa maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nagayama tamagema hua kema havilama hutama havisagenoꞋa ani ke-lamagemoꞋa tamakaila kanama lamahaiya yamoꞋa nofi hu-lama-tenaya yana haꞋno hisigetama afa vea maigahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","HigeꞋya kenonaꞋa mage hae “Tagaya Apalahamu nofi vaya mainona yafe nagoꞋa vayaꞋmoꞋya nofila hu-la-tageta miya oꞋali aliꞋyana oꞋalinone. NaꞋa higeka tagaifena nofila hu-lama-tagetama miya oꞋali aliꞋyapi mainaya vea ali haꞋno hisugetama afa vaya kana hutama maigahae huka nehane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hageno YisasiꞋa kenonaꞋamia mage hie “Tamage-lafa huꞋna tamaha-nepauve mukiꞋa veaꞋma kefo kavaꞋma taloma hisayana kefo yaꞋamimoꞋa nofi hu-ma-tegeꞋya miya oꞋali aliꞋya veaꞋne kana huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nagi miya oꞋali aliꞋya veala nagoꞋa afamopina agola omaigahayanagi atenea nafaꞋneꞋamoꞋa agola ani afamopi maigahie. ");
INSERT INTO kmu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anumaya Koti NafaꞋnemoꞋa kefo yatamimoꞋma tamatafa hu-mainea nofila alino lagama hu-taleana tamage huno ago alino laga hu-talegetama kanale hutama mainae. ");
INSERT INTO kmu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nagaya ago havimainoe tamakaya Apalahamu nofi vaya mainayanagi nagai kemoꞋa tamakupina omalenea yafe nagaila nahaegahena nehae. ");
INSERT INTO kmu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nagayama nehuana NenafaꞋma nave-li-mainea yaꞋyagahe nehuanagi tamakaya tamakaitami nelamafa tamaha-pai-mainea kava nehae.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","YisasiꞋa higeꞋya Yuta vayaꞋmoꞋya haviteꞋya mage hae “NelafaꞋa Apalahamu maine.” huꞋya hageno YisasiꞋa mage hie “Tamagema tamakaya Apalahamu nafaꞋneyagama mainaleꞋasina agayama nehia kavala talo haleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Talo haleꞋasinagi menia nagaya tamage kema Nenafategati havimainoa ke tamaha-pauva kanomonia naꞋa higetama nagaila nahaegahena nehae. ApalahamuꞋa naꞋa kavala ohunea yane. ");
INSERT INTO kmu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tamakaya nelamafa nehia kava nehae.” huno higeꞋya “ItatimoꞋa moli hu-liteno huno otateneane. Tagaila Anumaya KotiꞋa agaiꞋage nagoke nelafa maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hageno YisasiꞋa mage hie “Tamagema Anumaya KotiꞋa nelamafaꞋma maineleꞋasina nagaya Anumaya Kotitegati emainoa yafe nagaifena tamahaileꞋasine. NagaiꞋniꞋa nagesafitila omenogi Anumaya KotiꞋa agaiꞋa hu-na-tegeꞋna emainoe. ");
INSERT INTO kmu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","NaꞋa higetama kema hua kea havilama hutama nohaviye? Mani kemona aepaꞋamoꞋa maꞋa hu-maine tamakaya havisaya tokiyatamia omaleanegitama nagai kea ohavigahae. ");
INSERT INTO kmu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tamakaila SataniꞋa lama-tenea nelamafa agu agesa tokiyaꞋage hutama nelamafa akave nemalae. Aepama he-mainelegati vaya hamaeno fali-ma-tegeno omai kanoe. Ani kanomo agupina tamage kemoꞋa omalenegeno havigema hiana mukiꞋa kanale nehia kava nehie. Ani kanoa havigeꞋage kanoe. MukiꞋa havigema hu yana SataniꞋa agaiꞋafiti havigeꞋage kemona aepaꞋa maine. ");
INSERT INTO kmu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nagaya lamakaifena tamageꞋage ke nehua yafe havilama hutama tamakupi maletama tamametitia nohae. ");
INSERT INTO kmu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hana veaꞋmoga nageteka nagaifena ‘Kefo yakaꞋa hane.’ huka fako hu-nena-teka hu-falote hunategane? AꞋao, aniꞋa ohugahae. Nagaya lamageꞋage kea huꞋna tamaha-nepauvanagi naꞋa higetama nagaifena tamakupina havi nomalae? ");
INSERT INTO kmu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","NagoꞋa veala Anumaya Koti nafaꞋneyaga maineꞋya Anumaya Koti kea nehaviyanagi tamakaya Anumaya Koti nafaꞋneyaga omainaya yafe nagai kea nohaviye.” ");
INSERT INTO kmu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuta vayaꞋmoꞋya kenonaꞋa Yisasifena mage huꞋya hae “Tagaya kagaifena tamage nehune ‘Samelia kano mainane. Kefo AvamuꞋmoꞋa kagupina tamage maine.’ huta nehune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hageno YisasiꞋa mage hie “Nagaipina Kefo Avamula omaine. AꞋao nagaya Nenafa agi alisaga nehugetama lamakaya nagai nagia alitama afepinaga nemalae. ");
INSERT INTO kmu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nagaya nagia alisaga nohuanagi nagoke kanomoꞋa nagai nagia alisaga hisia kano maine. Ani kanoa, Anumaya KotiꞋe, kaiyekea hu-ma-tesia kano maine. ");
INSERT INTO kmu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tamage-lafa huꞋna lamaha-pauve nagai kema akaveꞋma malesamoꞋya ofaligahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","HigeꞋya Yuta vayaꞋmoꞋya mage hae “Ani kema hana yafena tagayama havunana kagaikaꞋa kagupi Kefo Avamula maine. ApalahamuꞋene nayona mainaya Anumaya Koti amaune vayaꞋmoꞋya fali-mainagi kagaya ‘Nagai ke akave malesamoꞋya ofaligahae.’ huka nehano? ");
INSERT INTO kmu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ApalahamuꞋa taginagomona ‘Agase-mainoa kano mainoe.’ huka nehano? ApalahamuꞋa faligeꞋya Anumaya Koti aune vayala ago fali-mainae. Kagaya hanaꞋa augafa kano mainoe huka nehane?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hageno YisasiꞋa mage hie “Nagaya nagima alisaga hisuana afa ya kana hugahianagi Nenafa tamakaya ‘Anumaya Kotitimo maine.’ hutama nehaya kanomoꞋa nagai nagia alisaga nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Alisaga nehianagi tamakaya agaila oꞋagetafa hu-mainae. Nagaya agaila ago age-mainogi ‘AgaiꞋma oꞋagenoe.’ huleꞋasina tamakai kana huꞋna havigeꞋage kano mauleꞋasinagi nagaya ago agaila age-mainoanagiꞋna agai kea akave nemaloe. ");
INSERT INTO kmu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ApalahamuꞋa tamakinagomoꞋe nagayama ma mopaleꞋma falote hisua kanahe agesia yafena musena hu-maineanagi agetenoꞋa tusiꞋa muse hu-maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","HigeꞋya Yuta vayaꞋmoꞋya kenonaꞋa mage hae “Kagaya fifitiꞋa (50) kafua ohunanagi kagaya vayatama omainane. Apalahamuna age-mainano?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hageno YisasiꞋa mage hie “Tamage-lafa huꞋna tamaha-nepauve Apalahamuna oꞋatenele nagaya hagoteꞋna monafinaga mainoane.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ani kema hia yafe yafa kaꞋyoteti aliꞋya aiko-ligahe nehageno YisasiꞋa fala-kino amataleno ala mono no kategati hati-lavino umaine. ");
INSERT INTO kmu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","YisasiꞋa katega neꞋuno nago kanoa atenea kanalegati aulaga asu humai kano moge-maine. ");
INSERT INTO kmu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mo neꞋagegeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage huꞋya havige-mainae “Hula-ve-nelina kanomoga ta hia kefo yamo alino aulaga asu hu-maine akaiꞋafi itaꞋafoꞋamoꞋa kefo ya haꞋa yamo aulagamoꞋa asu hu-mainefi?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Havigageno YisasiꞋa mage hie “Mani kanomo itaꞋafoꞋamoꞋa akaiꞋaene kefo yama hia yamo alino aulaga asu ohunegi Anumaya KotiꞋa tokiya yamaꞋa alino kanale hu-tesigeꞋya mukiꞋa veaꞋmoꞋya agesaya yafe aulagamoꞋa asu hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Menima yagema hanesiamaꞋaene hu-natenea kanomo aliꞋyana alige alige huta maisune. Hanima kisiana nago kanomoꞋa aliꞋyana oꞋaligahie. ");
INSERT INTO kmu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Menima ma mopaleꞋma mainoa-maꞋahena nagaya ma mopafina kaꞋni aye-halesua kano mainoe.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mani kea huno nehuno avetuꞋna mopafi heteno mopaene ayegakalifeno aulagama asu hu-mainea kanomo aulagale malegaꞋmaetene. ");
INSERT INTO kmu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","MalegaꞋmaeteteno mage huno hapaiye “Kagaya Siloamu ti kotute mo sese huo. Ani li kotumo agia tagai kefina ‘Hu-tene.’ huꞋya nehae. Ani li kotute kaugosa mo sese huteka eteka eno.” huno higeno mo seseꞋma hiana aulagamoꞋa kanale higeno neꞋageno nomaꞋalega emaine. ");
INSERT INTO kmu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","NomaꞋalega egeꞋya agaiꞋa kumate vayaꞋene nayoma mani kanomoꞋa monehema aukaꞋya nehigeꞋya neꞋagaya veaꞋmoꞋyaene mage huꞋya hu-mainae “Ma kanoa nayoma felu maineno monehema aukaꞋya nehia kanofi alu kanoe?” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","NehageꞋya nagoꞋa veaꞋmoꞋya “Ani kanoe.” nehageꞋya nagoꞋa veaꞋmoꞋya “Alu kanogi vuohe ani augafa kanomo nehigi.” huꞋya hageno agaiꞋa nehuno “Nagaya mani kano mainoe.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","NehigeꞋya mukiꞋa veaꞋmoꞋya havige-mainae “HanaꞋa hanageno kaulagamoꞋa kanale hu-maine?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Havigageno mage hie “Nago kanoa, YisasiꞋe kanomoꞋa, hapa talo huteno alino naulagale maleteno ‘Siloamu ti kotutega kaugosa mo sese huo.’ huno higeꞋna naugosa mo sese huteꞋna agoana aupaꞋa naulaga age-mainoe.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","HigeꞋya veaꞋmoꞋya “Ani kanoa hanate maine?” huꞋya hageno “Nagaya oꞋagenoe.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aulagama asu hu-mainea kanomona Falasia vayatega avaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","YisasiꞋa hapama ali gakalifeteno ani kanomo aulagama alino kanaleꞋma hu-teneana Sapati kanae. ");
INSERT INTO kmu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Falasia vayaꞋmoꞋya nagoꞋene mage huꞋya havigae “HanaꞋa hanageno kaulagamoꞋa kanale hu-maine?” huꞋya hageno “Hapa ali gaꞋmaeno naulagale malegeꞋna mo sese hugeno naulagamoꞋa kanale higeꞋna age-mainoe.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","HigeꞋya nagoꞋa Falasia vayaꞋmoꞋya mage hae “Ani kavaꞋma hia kanoa Sapati kanamona akave omalea yafe Anumaya KotiꞋa ani kanoa hu-tegeno omene.” huꞋya nehageꞋya nagoꞋa vayaꞋmoꞋya mage hae “Kefo yamaꞋa hanesia kanomoꞋa ani tokiya avame yana talo ohileꞋasine.” huꞋya nehageꞋya huteꞋya tolefi ali fako hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","NaꞋa huteꞋya aulagama asu hu-mainea kanoa eteꞋya havige-mainae “Ani kanoma kaulagama alino lamama hu-gatea kanohena naꞋane hu-mainane?” huꞋya hageno mage hie “Anumaya Koti aune kanoe.” nehie. ");
INSERT INTO kmu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","HigeꞋya Yuta vayaꞋmoꞋya “Mani kanoa aulagamoꞋa asu hu-maineanagi menia aulaga ago agegali hu-maine.” huꞋyama haya kehena “Havige nehae.” huꞋya haviꞋya amakupina maleꞋya amametitia ohuꞋya aulagama asu hu-mainea kanomona itaꞋafoꞋamoganifeꞋene ke hageꞋya emainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","AꞋageꞋya itaꞋafoꞋamoganife mage huꞋya hana-vigae “Mani kanoa atenaꞋa kanafi aulagamoꞋa asu hu-mainea nafaꞋnetani maineano? NaꞋa higeno menia aulaga neꞋage?” huꞋya hana-vigae. ");
INSERT INTO kmu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","21","Hanavi-gageꞋana itaꞋafoꞋamogania mage haꞋe “TaꞋagai nafaꞋne maineanagitaꞋa taꞋagaya ago age-mainoꞋe. Aulagama asu hu-mainea nafaꞋnema atenoꞋamaꞋa ago age-mainoꞋanagi aulagama age-maineamaꞋa oꞋagenoꞋe. Tapiga aulaga alino kali hu-teneafe tamakaya agai havigeho. Alopa ve maineanagino agaiꞋa tamaha-paigahie.” huꞋana nehaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","ItaꞋafoꞋamogania Yuta vayafe koli huꞋana mani kea hu-mainaꞋe. Yuta vayaꞋmoꞋya kea hu-lokiya vaiꞋya mage hu-mainae “NagoꞋa veaꞋmoꞋya ‘Yisasina Anumaya KotiꞋa taugafa ali-gatigahema hu-tenea kanoa ma maine.’ huꞋya hisaya veaꞋmogamina agola mono nopitila amati-talegahune.” huꞋya hu-mainaya kehe koli nehuꞋana “Agaya alopa ve mainegi agai havigeho.” huꞋana hu-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","NagoꞋene eteꞋya aulagama asu hu-mainea kanohe ke hageno egeꞋya mage hu-mainae “Kagaya Anumaya Koti aufi tamage-lafa huka kea huo. Tagaya agonana ani kanoa kefo kavaꞋage nehia kanoe.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hageno kenonaꞋamia mage huno hie “Nagaya oꞋagenogi agaya kefo kava nehia nepi nohia nepi oꞋagenogi nagokeꞋya kanoꞋama agoana hagotenoꞋa naulagamoꞋa asu humaineanagi menia naulaga agegali nehue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","HigeꞋya mage huꞋya havigae “NaꞋa hu-ga-tene? HanaꞋa huno kaulaga alino kali hu-ga-tene?” huꞋya havige-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Havigageno “Nagaya agoꞋma tamaha-nepauvana tamakaya keꞋniꞋa nohaviye. NaꞋa higetama etetama nahavi-negae? TamakaiꞋenena agaiꞋaene tokaeꞋya nemaiya anagaꞋmogamipi maigahe nehao?” huno havige-maine. ");
INSERT INTO kmu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","HigeꞋya amakaya huꞋya akaya ateꞋya mage hae “Kagaikage Yisasienema tokaeka nemaina kanoa mainanagi tagaya Mosese kema nehavuna vayala anale haita mainone. ");
INSERT INTO kmu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tagaya ago havimainone Anumaya KotiꞋa Mosesena kea hapai-maineanagi ma kanomoꞋa hanategati emainenoꞋe tagaya agaila noꞋagonane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hageno aulagama asu hu-mainea kanomoꞋa mage hie “Avo namaꞋyo neꞋaiye. Tamakaya alu kegefa nehae. Tamakaya hanategatipiga emainea ke ohavinayanagi naulagama alino kali hu-na-tenea kano afa kanoa omaine. Anumaya Kotitegati emaine. ");
INSERT INTO kmu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tagaya ago havimainone Anumaya KotiꞋa kefo kava nehaya veaꞋmogami kea nohavie. NagoꞋa veaꞋmoꞋya Anumaya Koti agi alisaga nehuꞋya agaiꞋma haiya kavaꞋma hisaya veaꞋmogami kea Anumaya KotiꞋa havigahie. ");
INSERT INTO kmu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","EheꞋma fusa kanafima ma mopama taloma hu-malenelegatiꞋma emaineana nago atenea kanalegati aulaga asu hu-mainea kanoa alino kali hu-tene huꞋya haya kea ohavinonane. ");
INSERT INTO kmu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anumaya KotiꞋma mani kanoma hu-tegenoꞋma omeneleꞋasina nago yana agaya ohisine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","HigeꞋya kenonaꞋa mage hu-mainae “Kagaya kefo yapiti falote huka emainananagika tagaila menia hu-lave-ligahe nehano?” huꞋya nehuꞋya mono nopitila avaleꞋya kumatega hagaꞋyu hu-talenae. ");
INSERT INTO kmu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","YisasiꞋa mono nopitiꞋma anati-talaya kea haviteno ani kanoa atiyeno mogeteno mage hie “Kagaya ikapinagati emainea kanoa vayaꞋmo atenea kanomofena havika kagupi maleka kametitia nehano?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Havigegeno ani kanomoꞋa mage hie “Ani kanoa taꞋe? huka nehapi? Nagaila naha-paigeꞋna haviꞋna nagupi maleꞋna nametiti hano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Higeno YisasiꞋa kenonaꞋa mage hie “Kagaya agaila ago neꞋagane. Ani kanoa menima kagaiꞋenema maineno kea kea nehaꞋane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Higeno ani kanomoꞋa mage huno hie “AyeꞋnio Alamogae menia kagaifena haviꞋna nagupi maleꞋna nametiti nehue.” huno muse nehuno aiyafi aleꞋya aye-maineno Yisasi aiyale ali-soso nehuno agi alisaga nehie. ");
INSERT INTO kmu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","YisasiꞋa mage hie “Nagaya ma mopale veaꞋmogami fako hu-ma-tesua yafe emainoe. Ali fako hisugeꞋya amaulaga asu humai veaꞋmoꞋya amaulaga agesageno amaulagama hanea veaꞋmoꞋya amaulagama asu hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","HigeꞋya nagoꞋa avate maiya Falasia vayaꞋmoꞋya anima hia kea nehaviꞋya agaifena mage huꞋya havigae “Tagaifena tamaulaga asu hu-maine huka nehano?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Havigageno YisasiꞋa mage huno hie “TamaulagamoꞋa asuma hu-mainesina kefo yatamia omalesinagi tamakaya ‘TaulagamoꞋa kali kali hu-maine.’ hutama haya yafe kefo yatamimoꞋa hane.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","YisasiꞋa mage huno hie “Nagaya tamage-lafa huꞋna tamaha-nepauve nagoꞋa vayaꞋmoꞋya sipi sipi kegiꞋyamo fiatetiꞋma hai ofaleꞋya afalegatiꞋma asaga hu-maiꞋya hai falesaya vayala musufa vaya mainae. ");
INSERT INTO kmu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nago kanomoꞋma fiatetiꞋma hai nefalea kanoa sipi sipileꞋma kava neꞋyagaiya kano maine. ");
INSERT INTO kmu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","FiateꞋma yagai-mainea kanomoꞋa ani kanoa ageteno yaki-tegeno fiateti hai falegeꞋya sipi sipiyagamoꞋya alenaga agea havimainaya yafe agaiꞋa sipi sipimogamina amakia hanete hanete hu-maineanagino amakia ayete ayete huno amavaleno kumatega neꞋvie. ");
INSERT INTO kmu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","AmavalenoꞋma kumatega neꞋunofena uhagoteno neꞋvigeꞋya ani kanomona alenaga agema havimainaleti lagiꞋya ani sipi sipimoꞋya akave neꞋvae. ");
INSERT INTO kmu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nagi oꞋagenaya vayaꞋmogami amakavela oꞋugahae. Nagi ani kanomona alenaga agema ohavinaya yafe faleꞋya alulega ugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","YisasiꞋa mani avame kea hama-paiyanagi amakaya havilama huꞋya ohavinae. ");
INSERT INTO kmu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ohaviyanagi YisasiꞋa nagoꞋene eteno mage hu-maine “Tamage-lafa huꞋna tamaha-nepauve nagaya sipi sipimoꞋyama hai falesaya fiana nagaiꞋnige mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mainoanagi hagoteꞋyama emainaya vayala vayaꞋma nehamaeꞋya musufa yama nehaya vayalagiꞋya sipi sipiyagamoꞋya kema haya kea ohavinae. ");
INSERT INTO kmu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma nagaya fia mainoe. Mainoanagitama nagoꞋa veaꞋmogatama etama nagaipi ehai falesageꞋna tamaku tamamena ali-gatisugetama hai faletama mainetama elavitetama haitetama nehutama nesaya yana aligahae. ");
INSERT INTO kmu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Musufa kanomoꞋa musufa yana nehuno veala nehamaeno ali haviya hu-ma-tegahe neꞋeanagi nagaya kanaleꞋnale tamahaimu tamamigahe emainoe. Agola haꞋno ohu tamahaimula tamamigahe emainoe. ");
INSERT INTO kmu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nagaya kanaleꞋnale sipi sipi kava kano maineꞋna sipi sipiꞋniꞋamogamina amaku amamemaꞋa ali-gatisua yafe faligahue. ");
INSERT INTO kmu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nago kanomoꞋa yagaiteno mone neꞋalia kanoa sipi sipimona nefaꞋa omaine. Omaigeno afela kalamoꞋma egenoꞋa ani kanomoꞋa ataleno falegeno ani afela kalamoꞋa sipi sipimogamina akafu amanino mo hamae me hamae higeꞋya faleꞋya atagufeꞋya alulega ute ete nehae. ");
INSERT INTO kmu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ani sipi sipileꞋma yagaino maineno monema neꞋalia kanomoꞋa sipi sipiyagahena agesa ohavino amataleno faleno umaine. ");
INSERT INTO kmu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nagaya kanale sipi sipi kava kano mainoe. NenafaꞋa aguꞋa namigeꞋna nagaya naguꞋa amugetaꞋa nehuꞋe. NaꞋa hu-mainoꞋa kava huꞋna sipi sipiyagaꞋnimoꞋya amakuꞋa namigeꞋna nagaya naguꞋa neꞋamamue. Nagaya sipi sipiꞋniꞋamogami amaku amamemaꞋa ali-gatisua yafe faligahue. ");
INSERT INTO kmu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","NagoꞋa sipi sipiyagaꞋniꞋa amahaote mainae. Mani sipi sipi kegiꞋyaꞋnifina omainayanagi ani afuyaga amavaleꞋnama esuana alenaga nage nehaviꞋya nagokeꞋage afuyakama maisayana nagokeꞋmoꞋna ani sipi sipiyagalela kava kano maigahue. ");
INSERT INTO kmu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nagaya ‘AfaꞋa faligahue.’ huꞋna hua kehena NenafaꞋa tusiya huno hau ayamopafi nehaiye. NaꞋafene? Nahaimula atalesugeno eteno namisigeꞋna he-tisuaꞋyafe nahaimula afaꞋa atalegahue. ");
INSERT INTO kmu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","NagoꞋa vayamoꞋya nahaimula naha-ofalegahae. Nagaya nagaiꞋniꞋage nahaimula atalegahue. NahaimuꞋma atalesua tokiyaꞋniꞋaene ataleteꞋna eteꞋna alisua tokiyaꞋniꞋaene hane. AniꞋama hisua kavaꞋmo kea NenafaꞋa ago naha-pai-maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mani kema hia kea Yuta vayaꞋmoꞋya haviteꞋya tolefi ali fako hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","KasagoꞋyamoꞋya mage hae “Kefo AvamuꞋmo agupi hai-mainegeno aifoꞋnafo nehigi naꞋa higetama keꞋa maitama havimainae?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","HageꞋya nagoꞋamoꞋya mage hae “Kefo AvamuꞋmoꞋa agupima maineleꞋasina maniꞋa augafa kea ohileꞋasine. Kefo AvamuꞋmoꞋa aulagama asu hu-mainea kanomo aulaga aligali hu-oꞋateleꞋasine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Nayona mono no kimaleteꞋya fita yaki-mainaya kanahe muse nehaya imu Yelusalemu ki-mainae. Ani imua yasi neꞋalia kanale negiyanagino ani kanalela YisasiꞋa Anumaya Koti nopi umaineno Solomoni yasi neꞋalea nona aye-nagali-malenea kaiyaga neꞋvie. ");
INSERT INTO kmu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","MukiꞋa Yuta veaꞋmoꞋya meliꞋya amuꞋno huteꞋya maineꞋya mage hae “Tagu tagesamoꞋa tole-lole nehuno taipamoꞋa kanaꞋage nehigi. Menia hu-falote huka taha-paiyo kagaya Anumaya Koti hu-ga-tegeka emainana kano mainano?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Havigageno YisasiꞋa mage huno hie “Nagaya agoꞋma tamaha-pai-mainogi nagaifena havitama tamakupi maletama tamametiti nohae. Nenafa naminea tokiya yateti aliꞋyana alugetama agayana ani yana nagaya Anumaya Koti hu-na-tegeꞋna emainoa kano mainoa yafe tama-ve-lianagi nagai sipi sipima omaiya yafe havitama tamakupina nomalae. ");
INSERT INTO kmu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nomalayanagi nagai sipi sipiyagamoꞋya nagaila alenaga mage haviteꞋya nakave malageꞋna nagaya amakaila ago amake-mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","AmaketeꞋna maige maige hisaya hamaimula ago amaminoanagiꞋya ofaligahae. Nagaila ago nayapi mainayanagino nago kanomoꞋa memavayu ohugahie. ");
INSERT INTO kmu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NenafaꞋa ani sipi sipiyaga naminea kanogino mukiꞋa yana amakase-mainea kano mainea yafe alu kanomoꞋa Nenafa ayapitila haofalegahie. ");
INSERT INTO kmu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","NenafaꞋene nagaiꞋniene nagoke mainoꞋe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","HigeꞋya Yuta vayaꞋmoꞋya nagoꞋene yafa kaꞋyo aliꞋya haesaya kava nehae. ");
INSERT INTO kmu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nehageno YisasiꞋa mage huno hama-paiye “Nagaya mukiꞋa Nenafa naminea tokiya avame yana tamakai tamaulagafina ago hu-mainogi nagoke avameꞋyana hana avameꞋya hua yamo notamahaigetama nagaila yafatetila nahaegahena nehae?” huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hama-vi-gegeꞋya “Tokiya avame yama hu-mainana yafene huta yafatetila okahaegahunagi kagaya ma mopafi afa kano mainekagi ‘Anumaya KotiꞋene nagoke mainoꞋe.’ hukama hanana Anumaya Kotina kalana ategana kema hana yateti kagaila yafa kaꞋyotetila kahaegahena nehune.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Hageno YisasiꞋa mage hie tamakaitami mono kema kae-malenaya kemoꞋa mage hu-maineane “Anumaya KotiꞋa mage hie ‘Tamakaitami Anumaya Kotigatama mainae.’ huno hie.” huꞋya kae-malenayane. ");
INSERT INTO kmu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Ani Anumaya Koti kea kae-malenaya ke hanege hanege huno tamageꞋage hugahie. Anumaya Koti kema agoꞋma hama-paiya vayafena “Anumaya Kotigatama mainae.” huno hu-maineana nagaya Nenafafena “Nenahaiya kano mainane huno hu-na-tegeꞋna ma mopafina emainoema.” huꞋna nehuana naꞋa higetama “Nagaya Anumaya Kotina neꞋamoꞋnae.” huꞋnama hua kehena “Anumaya Kotina hu-haviya hu-neꞋatane.” hutama hu-nena-tae? ");
INSERT INTO kmu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","“Nagaya Nenafa aliꞋyama oꞋaluleꞋasina nagaifena havitama tamakupi maletama tamametiti ohaleꞋasinagi kanale kava haleꞋasine. Nagaya kema hu-mainoa kehema havitama tamakupima omalenutamahena aliꞋyama ali-mainoa aliꞋyafena havitama tamakupi maletama tamametiti hiho. NaꞋa hisayana NenafaꞋa nagaiꞋene maigeꞋna nagaya aniꞋa huꞋna agaiꞋene mainoꞋema huꞋna hua kea havilama hutama havigahae.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","HigeꞋya nagoꞋene atafa huꞋya nofi hu-tegahe hayanagi amakaseno ago umaine. ");
INSERT INTO kmu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uteno YisasiꞋa eteno Yotani lina mo lakaeno YoniꞋma lima fale-ma-tenea kumate mo maine. ");
INSERT INTO kmu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mo mainegeꞋya mukiꞋa veaꞋmoꞋya melitalu huꞋya maineꞋya mage hae “YoniꞋa keꞋama alino lokiya vaisia yana nagola malegeta oꞋagenonagi ma kanomofena mukiꞋa kema hu-mainea kemoꞋa tamage-lafa hu-maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","MukiꞋa ani kumate veaꞋmoꞋya Yisasifena haviꞋya amakupi maleꞋya amametiti hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nago kanomo agia LasalusiꞋe kali ali-maine. Ani kanoa Petani kumate kanoe. MataꞋene aganaꞋamoꞋa Maliagani kumale. ");
INSERT INTO kmu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ani MaliaꞋa nago yupa manaꞋage masavena Yisasina aiyale takino fale-teneno ayolagefaleti ali hau hu-teneane. Ani munaꞋmona asaꞋamoꞋa Lasalusi kali ali-maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kali alino mainegeꞋana ani tole nanukana-latamogania Yisasitega nago kano hu-taꞋageno mage mo hie “Alatimogae kagaikama kahau kayamopafima negahaiya kanoa kali neꞋalie.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hapaigeno YisasiꞋa ani kema nehavinoꞋa mage hie “LasalusiꞋa kali alino fae-maineanagi falisia yafe oꞋalinegi mani kalimoꞋa Anumaya Koti agi alisaga hisayafene huno ali-maine. Ani kalia Anumaya Koti nafaꞋnemo agi alisaga hisaya yafe falote hu-maine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","YisasiꞋa MataꞋene aganaꞋamoꞋene LasalusiꞋene ani anagafena tusiya huno hau ayamopafi nehaiya anagale. ");
INSERT INTO kmu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","YisasiꞋa LasalusiꞋma kalima alia kea havianagi oꞋuno tole yupa afaꞋa nemaiya kumate maiteno agaiꞋaenema tokaeꞋya nemaiya anagaꞋahe mage huno hama-paiye “Yutia kotega eteta visune.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage hae “Hu-lave-nelina kanomoga menia Yuta vayaꞋmoꞋya yafateti aliꞋya kahaegahema haya kotega kagaya ani kotega nagoꞋene ugahe nehano?” huꞋya havinegae. ");
INSERT INTO kmu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Havigageno YisasiꞋa mopafi mainea kanaꞋamoꞋa haꞋno ohunea yafe kenonaꞋamia avame kea mage huno hie “TuelufuꞋa (12) auva nagoke yagefina omalenefi? VeaꞋmoꞋyama yagefima vai-yesayana ma mopafi yagemoꞋa ai vasa humainea yafe asaga hu otavigahayanagi veaꞋmoꞋya kegeꞋma vaiyatete hisayana aye-vasa hu yamaꞋa amakupina omaleanagino vailino hamaegahie.” ");
INSERT INTO kmu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","YisasiꞋa mani kea huteno nago kea mage huno hu-maine “Tagaila kanapatia LasalusiꞋa faeno maineanagiꞋna nagaya visuaꞋamoꞋna mogafa huꞋna avale he-ti-tegahue.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage hae “Alatimogae agayama kalima alino fae-mainesiana afaꞋa kanale hu-tegahie.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Hageno YisasiꞋa mani avame kema hiana LasalusiꞋa ago fali-maine huno nehianagi agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya ohavinaya yafe “AfaꞋa faeno mainegeno nehie.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hageno YisasiꞋa ani avame kea neꞋataleno hu-falote huno hama-paiye “LasalusiꞋa ago fali-maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tamakaya nagaifena havilama hutama ‘Tamage nehie.’ hutama tamakupi maletama tamametiti hisaya yafe omainogeno fali-maineanagiꞋna nagaya muse nehugi menia aligeta mogamano.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Higeno Tomasina, nago agia TitimasiꞋe, tagai kefina kuyave nafaꞋne, Yisasienema tokaeꞋya nemaiya anagafe mage hie “MukiꞋamogata vigetao. Nagopi neꞋvisunageꞋya tahaesageta faligahune.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasalusina foꞋa (4) yupa komufi he-vai-tenageno YisasiꞋa uvaꞋyi higeꞋya he-vai-tenaya kanahe hapaimainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Petaniti Yelusalemua tagufa (3) kilomita aupate hanea yafe mukiꞋa Yuta veaꞋmoꞋya Yelusalemutila etele huꞋya Matagani Maliaganina anasaꞋanimoꞋma fali-mainea yafe hamau hu-nateꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Emainageno MataꞋa Yisasife “NeꞋe.” huꞋya haya kea haviteno katega viaꞋyamo mo fotu hu-mainegi MaliaꞋa nomaꞋafi maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mainegeno MataꞋa Yisasife mage hie “Alanimoga kagayama maleꞋma mainateꞋasina nasaꞋnimoꞋa ofalileꞋasine. ");
INSERT INTO kmu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ago havimainoe menia kagayama Anumaya Kotitega nago yafema havigesanana afaꞋa kamigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Higeno YisasiꞋa mage huno hapaiye “KasakamoꞋa fali-maineanagi eteno haimula alino he-tigahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Higeno ani munaꞋmoꞋa mage hie “E, nagaya ago havimainoe ma mopama haꞋnoma hisia kanafina mukiꞋa fali-mainaya veaꞋma he-tisaya kanafina eteno he-tino haimula aligahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Higeno YisasiꞋa kenonaꞋa mage hie “Nagaya fali-mainaya veala amavale he-tiꞋna hamaimula amamisua kano mainoe. Nagaya maige maige hisaya hamaimu amami yamona aepaꞋa mainoe. NagoꞋa veaꞋmoꞋya nagaife haviꞋya amakupi maleꞋya amametiti hisayana faliteꞋya hetiꞋya agola maige maige hisaya hamaimula aligahae. ");
INSERT INTO kmu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","NagoꞋa veaꞋmoꞋya afaꞋa maineꞋya nagaifena haviꞋya amakupi maleꞋya amametiti hu-mainaya veala maige maige hugahayanagiꞋya ofaligahae. Kagaya mani kea ago havilama huka kagupi maleka kametiti nehapi nohane?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Havigegeno ani munaꞋmoꞋa mage hie “E, Alanimoga nagaya nehaviꞋna ago nagupi maleꞋna nametiti hu-mainoe. Tamage nehae kagaya Kalaisigae* Anumaya KotiꞋa hu-ga-tegeka taugafa ali-gatigahe ma mopafi elavisana kano emainane. Anumaya Koti nafaꞋne mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","MataꞋa mani kea huteno eteno viaꞋyamo aganaꞋamona Maliana sumi sumi huno mage huno hapaiye “Hu-mave-nelia kanoa ago emaineno kagaife ke nehie.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hapaigeno MaliaꞋa ani kea haviteno aupaꞋa he-tino Yisasi mogegahe umaine. ");
INSERT INTO kmu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","NeꞋvigeno YisasiꞋa kumatela omenegi MataꞋene fotuma huꞋana kea keama haꞋalega maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","MainegeꞋya Yuta veaꞋmoꞋya MaliaꞋene nopi maineꞋya hanauma hu-nateꞋyama emainaya veaꞋmoꞋya MaliaꞋa aupaꞋa he-tino kumatega via yafe agayana higeꞋya “Vae MaliaꞋa asaꞋamo komulega avitegahe neꞋvie.” huꞋya akave umainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Akave vageno MaliaꞋa Yisasi mainelega mogeteno aiyafi mope hu-maineno mage hie “Alanimogae kagayama maleꞋma mainateꞋasina nasaꞋnimoꞋa ofalileꞋasine.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hapaiteno avi neꞋategeno agaiꞋenema emainaya Yuta veaꞋmoꞋya aniꞋa huꞋya neꞋatageno YisasiꞋa Maliana neꞋagegeno aipamoꞋa tusiya huno haviya hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","AipamoꞋa haviya hu-mainefiti hama-vigeno mage hie “Hanate he-vai-tenae?” huno higeꞋya “Alatimoga eka mego.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nehageno YisasiꞋa avi-te-maine. ");
INSERT INTO kmu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","NeꞋategeꞋya Yuta veaꞋmoꞋya mage hae “Ageho Lasalusifena tusiya huno hau ayamopafi nehaiye.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","HageꞋya nagoꞋa veaꞋmoꞋya mage hae “Ma kanoa amaulagama asu hu-mainea veaꞋma aligali hu-neꞋamatea kanogi naꞋa higeno Lasalusina kaliꞋa alino kanale hu-tegeno ofalino afaꞋa maiyanagi fali-maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisasina aipamoꞋa nagoꞋene haviya higeno he-vai-tenaya komulega umaine. Ani komua yafa kapi he-vai-teteꞋya komumo avayalela ala yafateti aliꞋya ai-lile-malenae. ");
INSERT INTO kmu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ai-lile-malenageno YisasiꞋa mogeteno mage hie “Mani komumo avayaleti yafana ali-taleho.” huno higeno fali-mainea kanomo asaꞋamoꞋa, MataꞋa, mage huno hie “AlaniꞋamogae mani kanoa ago he-vai-tageno foꞋa (4) yupa komufinaga haneanagino tusiꞋa hiꞋmana hugahie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Higeno YisasiꞋa mage hie “Nagaya ago kaha-pai-mainofi? ‘Kagayama nagaifema tamage nehane huka kagupi maleka kametitima hisanana Anumaya Koti agi alisaga hisaya tokiya yana agegane huꞋna kaha-pai-mainofi?’ huno havinege.” ");
INSERT INTO kmu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ani yafana ali-taletageno YisasiꞋa anafinaga agesaga huno age-maineno mage hie “Nenafaga nunamuniꞋa ago havimainana yafe musekaꞋa nehue. ");
INSERT INTO kmu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","HavimainanagiꞋna nagaya mukiꞋa kanalema kahavi-goa kea nehavinagi afaꞋa menia manileꞋma mainaya veaꞋmoꞋya kagayama hu-na-tanageꞋna emainoa yafema ‘Tamage nehane.’ huꞋya amakupi maleꞋya ametiti hisaya yafe kahavi-negoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mani kea huteno ala kegefafiti mage hie “Lasalusiga he-tika elavio.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Higeno LasalusiꞋa, fali-mainea kanoa, eteno he-tino elavigeꞋya aiyafima ayapima augosafima kenaletiꞋma aye-gasagi-malea kanoa elavigeno YisasiꞋa mage huno hama-paiye “Kalu hetama atalegeno vino.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","MukiꞋa MaliaꞋenema emainaya Yuta veaꞋmoꞋya YisasiꞋma hia kavala ageteꞋya amakupi maleꞋya amametiti hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","AmakuꞋa amiyanagi nagoꞋa vayaꞋmoꞋya ataleꞋya Falasia vaya mainalega uꞋya YisasiꞋma hia kavafena mo hama-pai-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hama-paigeꞋya Falasia vayaꞋene ala mono note kava vayaꞋene Kanisole vayafe ke hageꞋya ageꞋya mage huꞋya hae “Ma kanoa kasagoꞋya tokiya avame yaꞋyaga nehigi naꞋa hisune? ");
INSERT INTO kmu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","AfaꞋama atalesunagenoꞋa mukiꞋa kanalela aniꞋageꞋyama hisigeꞋya mukiꞋa veaꞋmoꞋya ‘Tamage nehie.’ nehuꞋya haviꞋya amakupi maleꞋya amametiti hisageꞋya kava vayatia, Lomu vayaꞋmoꞋya eꞋya mukiꞋa veaꞋnene ala mono notiene ali haviya hugahae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hageno KaiyafasiꞋa ani kafufina ala mono note hagote kava kano maineanagino ani vayapiti he-tino mage hie “Tamakaya tamaku tamakesa nomale. ");
INSERT INTO kmu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tamakaya ohavinafi na ya kanale tamaya hisia yana hane? MukiꞋa veati ali haviya hisafi nagoꞋke kanomoꞋa mukiꞋa veaꞋamogami anonaꞋa falisie?” huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ani kafufina KaiyafasiꞋa ala mono note hagote kava kanogino mani kea Anumaya KotiꞋa hapaigeno aune laga huno hu-maine. AgaiꞋa agesafiti ohune. Ani aunema laga hia aepaꞋamoꞋa mage hu-maine “YisasiꞋa Yuta veaꞋmogamife huno faligahie. ");
INSERT INTO kmu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","AmakaiꞋamigetefena huno ofaligahigi alu kumate kumate mainaya Anumaya Koti nafaꞋneyaga amavaleno nagoke anaga hu-ma-tesigeꞋya maisaya yafe YisasiꞋa faligahie.” ");
INSERT INTO kmu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ani kanaleti aepa heꞋya Yuta vayaꞋmogami kava vayaꞋmoꞋya Yisasina haesaya kea huꞋya haviteꞋya huge havige hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ani yafe YisasiꞋa nagoꞋene Yuta veaꞋmogami amaulagafina vai oꞋayenegi nago kumala Efalaimie huꞋya nehaya kumala vaya omai kola aupa hu-mainegeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋene anilega uꞋya mo mainae. ");
INSERT INTO kmu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuta veaꞋmoꞋya kafuꞋahe kafuꞋahena Anumaya KotiꞋma amakinagomogami amaugafama ali-gati-mainea yafe haviꞋya alitalu huꞋya imu negiyane. Ani imuma kisaya kanamoꞋa aupa higeꞋya mukiꞋa veaꞋmoꞋya mukiꞋa kumateti haiꞋya kahegi kemo hama-paiya kava huꞋya amaugafaene amakuꞋaene sese hugahe Yelusalemu umainae. Ago mo sese huteꞋya ani imuꞋamia nenae. ");
INSERT INTO kmu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ala mono nopi molitalu huꞋya maineꞋya Yisasife moge mege huꞋya ati-yegetayana higeꞋya amakaiꞋamifi mo hama-vige me hamavige huꞋya mage hae “NaꞋane tamakesa nehaviye? KaveꞋma nesutela egahifi omegahie?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","HageꞋya ala mono note kava vayaꞋene Falasia vayaꞋene Yisasina atafa hugahe mage hu-mainae “MaꞋa hiho. YisasiꞋma faesia kumaꞋma agenutamahena aupaꞋa ani kea alitama me laha-paiho.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","YisasiꞋa Petani kumate, LasalusiꞋa faligeꞋya he-vai-tenageno YisasiꞋa molino he-ti-tenea kanomo kumate, uvaꞋyi hu-maine. UvaꞋyi hiana ani kanafina Anumaya KotiꞋma amakinagomogami amaugafama ali-gati-mainea yafe amakesa haviꞋya imuma kisaya kana sikisiꞋa (6) yupa maiteꞋya kigahe nehae. ");
INSERT INTO kmu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hageno Yisasina musekase kave talo tala hu-teteno MataꞋa alino amamite amamite nehigeno LasalusiꞋa YisasiꞋene siale mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mainageno MaliaꞋa nago kilo* manaꞋage masave hanea keꞋayola, tusiꞋa mone hanea masavemo agia natie nehaya masavena alino Yisasina aiyale taki haꞋno hu-teteno ayolagefaleti ali hau hu-neꞋa-tegeno ani masavemo manamoꞋa ani nopi haino hiya higeꞋya manaꞋa havimainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Nago kanoa, YisasiꞋenema tokaeꞋya nemaiya anagapiti kanomo, agia Yutasi IsakaliotiꞋe. Ani kanomoꞋa haenagaꞋa Yisasina agesi huno kame ya hu-tesia kanomoꞋa mage hie “NaꞋa higeno mani manaꞋage masavena afaꞋa neꞋatale? Atalegeno nago kanomoꞋma miya hileꞋasipa tali hataleti (K300) kina aliteta mani masaveteti monea afenoꞋamima omalenea veaꞋne amamuteꞋasine.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mani kea moneꞋamima omalenea veafena hauma hu-neꞋa-matea yafena nohigi mukiꞋa kanalela monema hanea kutela agaiꞋa yagai-maineno musufa yama nehia yafe mani kea hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","YisasiꞋa mage hie “Ma munala afaꞋa atalegeno ma masavena afaꞋa ali-lineno nagayama falisugeꞋya he-vai-natesaya kanalela mani masaveteti fale-na-tegahie. ");
INSERT INTO kmu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","MoneꞋamima omalenea veaꞋmoꞋya mukiꞋa yupa tamakaiꞋene maigahayanagi nagaya tamaikaiꞋenena mukiꞋa yupa omaigahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","MukiꞋa Yuta veaꞋmoꞋya “YisasiꞋa Petani kumateꞋma emaine.” huꞋya haya kea haviteꞋya ani kumate umainae. Yisasina agaiꞋage agegahe oꞋunagi LasalusiꞋa fali-mainegeno ali he-ti-tenea kanoene anakegahe umainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","LasalusiꞋa fali-mainefiti he-ti-mainea yafe mukiꞋa Yuta veaꞋmoꞋya nayoma nehaya monola neꞋataleꞋya Yisasina amakuꞋa amitafa huꞋya amametitima haya yafe ala mono note kava vayaꞋmoꞋya LasalusiꞋene haesaya kea hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","FaeteꞋya kotigeꞋya mukiꞋa veaꞋmoꞋya Anumaya KotiꞋma amakinagomogami amaugafama ali-gati-mainea yafe imuma ki-malenale emaineꞋya “YisasiꞋma Yelusalemu kumate egahie.” huꞋya haya kea havi-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","HaviteꞋya YisasiꞋene katega mo fotu hugahe tofe yosamona haisaꞋa kofa-nafa huꞋya aliꞋya umaineꞋya ala kefiti mage huꞋya hae “TusiꞋa yate taugafa ali-gatisana kanoa kanaleꞋya huka neꞋane. Anumayamo aliꞋya alisana yafe hu-ga-tegeka emainana kanomoga Anumaya KotiꞋa kanale manu kamiteno kaya hu-maine. Isaleli kotega yagai-ma-tenana sauve kanomoga Anumaya KotiꞋa kaya hu-maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","YisasiꞋa nago hosi kana afumo agia tokie nehaya afua age falote huteno agupifi haino maine. AniꞋama hia kavala nayona Anumaya Koti kefina mage huꞋya kae-malenayane. ");
INSERT INTO kmu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalemu veaꞋmogatama kolia ohutama ageho. Menia tamakaila sauve kanotamia yaufa tokimo agupifi haino maiteno egahie.” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","YisasiꞋma aniꞋama hu-mainea yupa agaiꞋenema tokaeꞋya nemaiya anagaꞋmoꞋya anima kae-malenea kea ohavianagi haenagaꞋage YisasiꞋma faliteno he-tino tokiya hale yamaꞋama hanea kumate haitegeꞋya amakesamoꞋa ai-kalo higeꞋya anima kae-malenea kene veaꞋmoꞋya ani yupama hu-tenaya kavafeꞋene havi-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","YisasiꞋa Lasalusifema “Komufitila he-tio.” huno higeno fali-mainefitiꞋma he-ti-mainea yupa anileꞋma mainaya veaꞋmoꞋya ani kanafina “YisasiꞋa naꞋa maꞋa kavala hu-maine.” huꞋya kea aliꞋya ute ete huꞋya hama-pai-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hama-paigeꞋya haviteꞋya anima tokiya avame yama hu-mainea kema haviya yafe mukiꞋa veaꞋmoꞋya katega YisasiꞋene mo fotu hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","HageꞋya Falasia vayaꞋmoꞋya amakaiꞋami amuꞋnoꞋamifina ani kehena mohu mehu huꞋya mage hu-mainae “Ageho mukiꞋa mopafi veaꞋmoꞋya Yisasina akave neꞋvayanagita atafa ohugahune.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","NagoꞋa Kaliki veaꞋmoꞋya, Anumaya Koti agi alisaga hugahe, ani imu kaveꞋma nalega Yelusalemu hai-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ani Kaliki veaꞋmoꞋya Filipite umainae. FilipiꞋa Kalili hanea kumala Petesaita kumateti kano mainelega uꞋya mage hae “MusekaꞋa nehunagi tagaya Yisasina agegahe neꞋone.” huꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hageno FilipiꞋa viaꞋyamo Etaluna hapaiteꞋana ani lolemogani Yisasina mo hapai-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","HapaiꞋageno YisasiꞋa mage huno hana-paiye “Menia Ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia tusiya huꞋya nagai nagia ali-saga hisaya kanamoꞋa ago evaꞋyi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tamage huꞋna tanaha-nepauve nagoke viti avinamoꞋma asaga hu-lavino mopafima ofalinunofena nagoke viti avinaꞋage hanegahigi nagi falinunofena ai-falo huno hageteno kasagoꞋya viti alagayaga aye helafigahie. ");
INSERT INTO kmu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","NaꞋa hugahianagi nagoꞋa veaꞋmoꞋyama mukiꞋa ma mopafi yafema amaugafama aliꞋya haiteꞋya hamaimuꞋamima atafa hisaya veaꞋmoꞋya faligahae. Faligahayanagi nagoꞋa veaꞋmoꞋyama ma mopale mainaya amaugafama aliꞋya haisaya yafema ‘Afa yanema.’ huꞋya hisaya veaꞋmogami hamaimuꞋmoꞋa haꞋno ohugahianagiꞋya maige maige huꞋya maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","NagoꞋa veaꞋmoꞋyama nagaifema huꞋya aliꞋya alisayana nakave ege ege hisae. NakaveꞋma esaya veaꞋmoꞋya maisua yate nagaiꞋene mainesageno NenafaꞋa nagai aliꞋyama neꞋaliya veaꞋmogamina ala amaki amamigahie.” ");
INSERT INTO kmu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","YisasiꞋa mage huno nehie “Nagai naguꞋamoꞋa tusiya huno kanaꞋage nehigeꞋna kasagoꞋya nagesa nehavugi naꞋane huꞋna hisue? ‘Nenafaga menia nagai naugafaleꞋma faloteꞋma hugahema nehia yana ali-talo.’ hisufi? AꞋao nagaya ani nagata aisia yapi maigahe emainoe. ");
INSERT INTO kmu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nenafaga kagaika kagi alisaga huo.” huno nehigeno anile ikapinagati age aino mage huno hie “Nagia ago alis-aga hu-mainoane eteꞋna nagoꞋene nagia ali-saga hugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","HigeꞋya melitalu hu-mainaya veaꞋmoꞋya agema aiya kea haviteꞋya nagoꞋamoꞋya mage huꞋya hae “Ikapinagati akali kalu nehie.” huꞋya hageꞋya nagoꞋa veaꞋmoꞋya mage huꞋya hae “Nago ensole kanomoꞋa ke me hanepaiye.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Hageno YisasiꞋa mage huno hie “Ani agema aiya agea nagai naya hisia yafe nohigi mani kea tamakai tamaya hisia yafe nehie. ");
INSERT INTO kmu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Menia ma kanafina Anumaya KotiꞋa ma mopale veaꞋmogamina kaiyeke hu-ma-tegahie. Meni kanafima ma mopaleꞋma kava yagai-mainea kanoa, Satanina* ago anati-talegahie. ");
INSERT INTO kmu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Anati-talegahigi ma mopaleti navalesaga huꞋya* nahaesageꞋya mukiꞋa veaꞋmoꞋya amakuꞋa namisaya yafe amavayu huꞋna nagaiꞋnilega amategahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ani avame kema huno hia kemoꞋa mage hu-maine “Ma yateti, yafaga yosale nahaesageꞋna faligahue.” huno hama-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hama-paigeꞋya veaꞋmoꞋya kenonaꞋa mage huꞋya hapai-mainae “Tagai monoꞋmoꞋa mage huno taha-pai-maine ‘Anumaya KotiꞋma taugafa ali-gatigahema hu-tesia kanoa mukiꞋa kanafina maige maige hugahie.’ huno taha-pai-maineanagi naꞋa higeka ‘Ikapinagati emainoa kanoa vayaꞋmo natenea kanomonia yafaga yosale navalesaga hugahae.’ huka nehane? Anima ikapinagati emainea kanoa vayaꞋmo atenea nafaꞋnea ta maine?” huꞋya havigae. ");
INSERT INTO kmu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Havigageno YisasiꞋa kenonaꞋamia mage huno hie “Hale yamaꞋaene kanomoꞋa tamakaipina osi kana kanoꞋa maine. Hani kisia yana vaꞋyi huno aiso hu-lama-tesia yafe hale yama hanea kanale vaiyatete hiho. Hani-ki-mainea yapima mainaya veaꞋmoꞋya visaya kana oꞋagenae. ");
INSERT INTO kmu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hale yamaꞋama hanea kanafina hale yamaꞋaene kanohe ‘Tamage nehane.’ hutama havitama tamakupi maletama tamametiti hiho. AniꞋama hisayana hale yamo nafaꞋneyaga maigahae.” huno hama-pai-maine. YisasiꞋa mani kea huteno neꞋamataleno mo fala-ki-maine. ");
INSERT INTO kmu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","MukiꞋa tokiya avameꞋyamo amaulagafi alianagi agaifena haviꞋya amakupina maleꞋya amametitia nohae. ");
INSERT INTO kmu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ani yafe Anumaya Kotina aune kanoꞋa, AisaiyaꞋa, hu-mainea kea falote huno tamage nehie. Mage huno hu-maineane “Anumayamoga manima hu-mainona kea taꞋya haviꞋya amakuꞋafina maleꞋya amametitia nehae? AnumayamoꞋa tokiya avame yamaꞋa amave-ligeꞋya hana veaꞋmoꞋya havilama nehae?” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Higeno amuha ohunayanagiꞋya Yisasifena haviꞋya amakupina maleꞋya amametitia ohunaya yafe AisaiyaꞋa nagoꞋene mage huno humaineane ");
INSERT INTO kmu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Amaulaga oꞋagesaya yafe Anumaya KotiꞋa amaulaga ago alino asu hu-ma-tene. Amaku amakesa havilama ohisaya yafe ‘Yafa kana amanuꞋene veaꞋne maiho.’ hu-ma-tene. Havigu amakuꞋa ai-yahae huꞋya nagaitega eyafenagiꞋna ali hilato hu oꞋama-tegahue.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","AisaiyaꞋa Yisasina tokiya hale yamaꞋa ageteno Yisasife mani kea hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hu-maineanagi Yuta kava vayaꞋyagafitila kasagoꞋya vayaꞋmoꞋya Yisasife haviꞋya amakupi maleꞋya amametitia hayanagi Falasia vayaꞋmoꞋya mage hae “Mani kavaꞋma hisayana mono nopina omegahae huta nagalu hu-lama-tegahune.” huꞋya hu-mainaya yafe “Yisasina taguꞋa neꞋamune.” huꞋya hu-falote ohunae. ");
INSERT INTO kmu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ani veamoꞋya Anumaya KotiꞋa “Kanale kava nehae.” huno amakima alisaga hisia yafena nohamaigi veaꞋmoꞋya “Kanale kava nehae.” huꞋya amaki alisaga hisaya yafeke nehamaiye. ");
INSERT INTO kmu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","YisasiꞋa tokiyaꞋage ke hu-haleno mage hu-maine “NagoꞋa veaꞋmogatama nagaifema tamage nehie hutama tamakupi maletama tamametitima hisayana nagaiꞋnigefena tamakupina maletama tamametitia hu-nona-tagi hu-na-tenea kanomofeꞋene hu-neꞋa-tae. ");
INSERT INTO kmu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","NagoꞋa veaꞋmoꞋyama nagaiꞋma nenagayana NenafaꞋa hu-na-tenea kanoene age-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nagayama ma mopaleꞋma emainoana hale ya kana huꞋna emainoe. Nagoke nagoke veaꞋmoꞋya nagaifeꞋma haviꞋya amakupima maleꞋya amametitima hisayana haniki-mainea yapina omaigahae. ");
INSERT INTO kmu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","NagoꞋa veaꞋmogatama nagai kema havitetama nakaveꞋma omalesayana nagaya tamakaila kaiyekea hu otama-tegahue. Ma mopale veaꞋmogamina kaiyekea hu-ma-tegahue huꞋna omenogi ma mopale veaꞋmogamina amaugafa ali-gatigahue huꞋna emainoe. ");
INSERT INTO kmu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","NagoꞋa veaꞋmoꞋya nagaifeꞋma amakaveꞋnoma huꞋya nagai kema amakupima aliꞋya omalesayana hu-mainoa keꞋnimoꞋa fako hu-ma-tegahie. Ma mopama haꞋno hisia kanama evaꞋyima hisiana hu-mainoa keꞋnimoꞋa fako hu-ma-tegahie. ");
INSERT INTO kmu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mani kea nagesafitila ali falote huꞋna tamaha-nopaugi hu-na-tenea Nenafa ‘Nage mage huka huo.’ huno naha-paiya keꞋage tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nagaya ago havilinoe agai kema havitama tamakupima maletama tamametitima hisayana ofalitama agola maige maige hisaya tamahaimula aligahae. Nani yafe NenafaꞋa naha-pai-mainea kea tamaha-nepauve.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anumaya KotiꞋma amakinagomogami amaugafama ali-gati-mainea yafe ala imu kigahe nehae.* Ani imu kisaya kanaꞋamimoꞋa aupa hugahe nehigeno YisasiꞋa ma agesa havimaine “Ma mopa ataleꞋna Nenafatega visua kanamoꞋa ago evaꞋyi nehie.” huno nehuno mukiꞋa kanaleꞋma ma mopale maineꞋyama agai kema nehaviya veaꞋmogamifena tusiya huno hau ayamopafi nehaino agola haume haume haino mo fali-maine. ");
INSERT INTO kmu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","YisasiꞋenema tokaeꞋya nemaiya tuelufuꞋa (12) anagaꞋaene unena kavela nenageno SataniꞋa Yutasifena “Havisigi huka agesi huka hama-pai-sanageꞋya Yisasina haesae.” huno agu agesa amine. Ani YutasiꞋa nago agiꞋa IsakaliotiꞋa Saimonina nemofoꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","SataniꞋa aniꞋama hisia agu agesa amigeno YisasiꞋa ma agesa havimaine “NenafaꞋa mukiꞋa tokiya ago nayapi maleneanagiꞋna Anumaya KotiꞋa hu-na-tegeꞋna emainoafe eteꞋna Anumaya Kotitega haigahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nehuno kaveꞋma neneletila neꞋataleno he-tino ayaꞋaya kenaꞋa hateno nemaleno taulia alino amupi ai-gagino fai-line. ");
INSERT INTO kmu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Fai-lineno tina alino yopafi taki-maleneno aepa heno agaiꞋa tuelufuꞋa (12) anagaꞋamogami amaiya agupia sese hu neꞋama-teno ai-gagi-linea taulileti alino hau hu-neꞋamate. ");
INSERT INTO kmu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ali hau hu-ma-teme Saimoni Pitate vigeno Saimoni PitaꞋa Yisasife mage hie “AlaniꞋamoga naigai naiya sese hu-na-tegahe nehano? Sese hu ona-tegane.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Higeno YisasiꞋa mage hie “Kagaya nagayama nehua kavala menia ohavinanagi haenagaꞋa havilama huka havigane.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ha-paigeno PitaꞋa Yisasifena mage hie “Kagaya naiya sese ohutafa huka sese ohugane.” huno higeno YisasiꞋa kenonaꞋa mage hie “Kaiyama seseꞋma ohisuana nagaiꞋenena omaitafa huka omaigane.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Hapaigeno Saimoni PitaꞋa mage hie “AlaniꞋamoga naꞋama hinageka naiyaꞋagela sese hu ona-teka nayaꞋene nanuꞋene sese hu-nato.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ha-paigeno YisasiꞋa kenonaꞋa mage huno hapaiye “NagoꞋa veaꞋmoꞋya mukiꞋa amaugafama sese hu-malenaya veala amaugafalela oniꞋyaꞋamia omaleno haigafaꞋage hamau-maineanagiꞋya amaiyaꞋage sese hugahae. Tamakaila kefo yama haya oniꞋyatamia omaleno haigafananamaꞋage hu-mainagi nagoke kanomona oniꞋyaꞋage hau-maine.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Hama-paiteno YisasiꞋa agaiꞋma agesiꞋma huno haegahema hia kanoa ago age-mainea yafe “Tamakaya mukiꞋamogatamina oniꞋyatamia omalene huꞋna nohue.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Amaiya sese hu-ma-teteno kenaꞋa alino vai-lino mopale maineno mage huno hama-vige “Nagayama hu-lama-toa kavala ago havilama nehafio? ");
INSERT INTO kmu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tamakaya nagaifema ‘Hulave-nelina kanomogae.’ nehutama ‘Alatimogae.’ hutamama nehayana tamage hutama nehae. Nagaya ani kanoema hutama haya kano mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nagaya AlatamimoꞋna hu-lama-ve-neloa kanotamimoꞋna tamaiya sese hu-nelama-toe. Tamakaya aniꞋa hutama nelamafugami amaiya sese hu-ma-teho. ");
INSERT INTO kmu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nagaya hisaya kavala ago tamave-neluafe tamakaya nagayama hu-lama-toa kavala aniꞋa hu-ma-teho. ");
INSERT INTO kmu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nagaya tamagelafa huꞋna tamaha-nepauve aliꞋya kanoꞋamoꞋa kava kanoꞋamona agaseno omainegi kayo kayo kanoꞋamoꞋa hu-tenea kanomona agaseno omaine. ");
INSERT INTO kmu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tamakaya mani kema havilamama hutetama mani kavaꞋma hisayana kanaleꞋya hutama maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nagaya ‘KanaleꞋya hutama maigahaema.’ huꞋnama hua kea mukiꞋamogatamifena nohugi nagayama nahaigeꞋna huyo-gi-malenoa-maꞋamogamife nehaviꞋna mani kea nehue. Anumaya Koti kema nayoma kae-malenaya kemoꞋa mage hu-maineane ‘NagaiꞋenema maineno kaveꞋma nenea kanomoꞋa aiya alisaga huno nagaila aye-nalata-pegahie.’ huno kae-maleneane. Kae-maleneanagi meni kanafina mani kemoꞋa efalote huno tamage hugahe nehie. ");
INSERT INTO kmu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","HaenagaꞋa mani kemoꞋma efalote hisigetama nagaifena mage hugahae ‘Agaya Anumaya Koti nafaꞋne maine.’ hutama havitetama tamakupima maletama tamametitima hisaya yafe menia ani kana yaufa falote ohunea kanafi tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tamage-lafa huꞋna tamaha-nepauve nagoꞋa veaꞋmoꞋya nagayama hu-ma-tesua veaꞋma amavaleꞋya falu falama hu-ma-tesayana nagaila aniꞋa huꞋya navaleꞋya falu fala hu-nena-tae. NagaiꞋma navaleꞋyama falu fala hu-natesayana hu-na-tenea kanomona aniꞋa huꞋya avaleꞋya falu fala hu-neꞋatae.” ");
INSERT INTO kmu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","YisasiꞋa mani kea hama-paitegeno aipamoꞋa kanaꞋage higeno agu agesama havia agesamoꞋa hivi huno talavate oꞋategeno mani kea hu-falote nehie “Lamage huꞋna tamaha-nepauve tamakaipitila nago kanomoga vayaꞋmo havisigi huka nagesi huka kame ya hu-na-tegane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","HigeꞋya agaiꞋa tuelufuꞋa (12) anagaꞋamoꞋya oꞋaufi aꞋaufi hugetayana higeꞋya “Tafepiga nehie?” huꞋya mani kanomofena ohavinae. ");
INSERT INTO kmu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","OhavigeꞋna nagaya YoniꞋna agaiꞋaenema tokaeꞋya nemaiya anagapi nemauvanagino hau ayamopafi nagaifena hau-mainea kanogiꞋna avate tokaetaꞋa mainoꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mainogeno Saimoni PitaꞋa anuteti avameꞋname huno “Havigo.” huno naha-paino “Tafe nehane huka havigo.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","HigeꞋna nagaya Yisasina avaꞋale mime uꞋna maineꞋna mage huꞋna havigoe “AlaniꞋamogae tafe nehane?” huꞋna havigoe. ");
INSERT INTO kmu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Havigogeno YisasiꞋa mage huno hie “Nagayama kaveꞋma aliꞋnama supufi ayeteꞋnama aliꞋna amisua kanoa nagesiꞋma hisia kano maine.” huno nehuno ani kavela alino supufi ayeteno YutasiꞋa, Saimoni Isakaliotina nemofo amine. ");
INSERT INTO kmu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ani kavela amigeno alitegeno SataniꞋa aguꞋafinaga mo hai-faleno mainegeno YisasiꞋa mage huno hapaiye “Kagaya aupaꞋa hisuema hisana kavala ago huo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","HigeꞋya anileꞋma mopale mainaya vayaꞋmoꞋya YisasiꞋa Yutasife hianagi ani kemona aepaꞋa nohaviye. ");
INSERT INTO kmu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ohavinagi YutasiꞋa mone pokisiꞋamile yagaino nemaiya kanogiꞋya nagoꞋa vayaꞋmoꞋya mage huꞋya amakesa nehaviye “YisasiꞋa agaifena ‘Ala imule mo nesuna yana molika eno.’ huno nehifi ifi ‘MoneꞋamima omalenea vaya nagoꞋa mone molika amamio.’ huno nehifi?” huꞋya amakesa havimainae. ");
INSERT INTO kmu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Havigeno YutasiꞋa ani kavela aliteno aupaꞋa kumatega hati-laviana tusiꞋa hani ki-mainea yapi umaine. ");
INSERT INTO kmu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","YutasiꞋa ago utegeno YisasiꞋa mage huno hie “Menia ikapinagati emainoa kanoa vayaꞋmo natenea kanomoni nagia ali-saga hugahae. NagaiꞋma nahaesageꞋna falisugenoꞋa Anumaya KotiꞋa ala agi aligahie. ");
INSERT INTO kmu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nagaya falisua yafe Anumaya Koti agima ali-saga hisayana Anumaya KotiꞋa navalesigeꞋna agaiꞋene maigahue. AupaꞋa navaleno tokiya hale yapi ala nagi namigahie. ");
INSERT INTO kmu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","NafaꞋneyagaꞋnia tamakaiꞋenena nagaya osi kana kanoꞋa maiteꞋna visugetama nagaifena natiyegahayanagi amuha ohunayanagitama visua kumatela oꞋugahae. Mani kea Yuta veaꞋmogami hama-pai-mainoanagiꞋna menia tamakaila tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Menia nagola ohavinaya kahegi kea tamaha-paigahugi haviho. Nelama-fugamifena tamahau tamayamopafi tamahaino. Amakaya aniꞋa huꞋya tamakaifena hamaisie. Nagayama tamakaifema nahau nayamopafima nahaiya kava hutama nelama-fugamifena tamahau tamayamopafi tamahaino. Amakaya aniꞋa huꞋya tamakaifena hamaisie. ");
INSERT INTO kmu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nagi tamakaya mukiꞋa nelama-fugamifena tamahau tamayamopafima lamahaisiana muki veaꞋmoꞋya tamakaila lamaketeꞋya tamakaifena mage huꞋya hugahae ‘YisasiꞋenema tokaeꞋya nemaiya anaga mainae.’ huꞋya hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimoni PitaꞋa mage huno havige “AlaniꞋamogae hanatega ugane?” huno havigegeno YisasiꞋa mage huno hie “Visua kumatela menia nakavela oꞋuganagi haenagaꞋage nakavela ugane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Higeno PitaꞋa mage huno hie “AlaniꞋamogae nagaya na ya hinageꞋna menia kakavela oꞋugahe hugeka nehane? Nagaya kagaifene huꞋna nahaimula atalegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Higeno YisasiꞋa mage huno havige “Kagaya nagaifene huꞋka kahaimula atalegano? Tamagelafa huꞋna kaha-nepauve hagoteno kokolemoꞋa agea oꞋainesigeka kagaya tagufa (3) kanale avane huka nagiꞋa alika fala-kigane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","YisasiꞋa mage huno hu-maine “MukiꞋa veaꞋmogatama tamaipamoꞋa kanaꞋage huno tamakesa kuꞋmoꞋa ohino. Anumaya Kotife havitama tamakupi maletama tamametiti haya kava nehutama nagaifena havitama tamakupi maletama tametiti hiho. ");
INSERT INTO kmu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nenafa nopina veala maisaya nona kasagoꞋya hane. Ani yama omalesina nagaya mani kea ohuleꞋasine. Nagaya kumatamia moliꞋna talo tala hu-lama-tegahe ugahue. ");
INSERT INTO kmu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nagaya kumatamia mo lalo tala hu-maleteꞋna eteꞋna me lamavalesugetama visua kumatela visageta nagaiꞋene mo lokaeta maigahune. ");
INSERT INTO kmu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tamakaya nagayama visua kumaꞋmo kana ago age-mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Higeno TomasiꞋa mage huno hie “Alatimogae tagaya visana kumala oꞋagenone. HanaꞋa huta ani kana agesune?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Higeno YisasiꞋa mage huno hapaiye “Nagaya ikapinaga visaya kamona NefaꞋnae. Nagaya ke-lamage kemona aepaꞋa mainoe. Nagaya agola maige maige yamo hamaimula aepaꞋa mainoafe nagoꞋa veaꞋmoꞋya Nenafatega visayana alu katetila oꞋugahagi nagaiteke esae. ");
INSERT INTO kmu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tamakaya nagaiꞋma havimainaleꞋasipa Nenafafena aniꞋa hutama havileꞋasine. Tamakaya menia aepa hetama Nenafana ago havitetama age-mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Higeno FilipiꞋa mage huno hapaiye “Alanimogae negafana taveligeta agesunageno tagu tamemoꞋa tamu hisie.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Higeno YisasiꞋa mage huno hapaiye “Filipigae ayaꞋaya kanale tamakaiꞋenena maime emainoana kagaya nagaila onagenano? NagoꞋa veaꞋmoꞋya nagaiꞋma nage-mainayana aniꞋa huꞋya Nenafana age-mainae. NaꞋa higeka ‘Negafana lave-lio huka nehane?’ ");
INSERT INTO kmu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nagaya Nenafa aguꞋafina maugeno NenafaꞋa aniꞋa huno nagai naguꞋafina mainea yafena havika kagupina nomalano? Tamaha-pai-mainoa kea nagesafiti kea tamaha-opainoe. AꞋao. NenafaꞋa nagai nagupi maineno agaiꞋa aliꞋyamaꞋa neꞋalie. ");
INSERT INTO kmu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nagaya Nenafa aguꞋafi maugeno aniꞋa huno NenafaꞋa nagaila naguꞋafina maigetaꞋa hu-mainoꞋema huꞋnama hua kea havitama tamakupina maletama tamametiti hiho. Mani kema ohavinutama tamakaya mukiꞋa aliꞋyama ali-mainoa aliꞋyama age-mainesayana nagaifena havitama tamakuꞋafi ali maletama tamametiti hiho. ");
INSERT INTO kmu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tamage-lafa huꞋna tamaha-nepauve nagoꞋa veaꞋmoꞋya nagaifema haviꞋya amakupi nemalaya veaꞋmoꞋya mukiꞋama ali-mainoa aliꞋyana aniꞋa huꞋya aligahae. Nagaya Nenafatega visua yafe anima alisaya aliꞋyamoꞋa ali-mainoa aliꞋyana agaseꞋya aligahae. ");
INSERT INTO kmu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","NafaꞋneꞋamonife huꞋya NenafaꞋa agima ali-saga hisaya yafe tamakaya nagai kema havitetama nagai nagi ayetama mukiꞋa yafena naha-vi-gesageꞋna aniꞋa hu-lama-tegahue. ");
INSERT INTO kmu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","MukiꞋa yafema nagai nagima ayetama naha-vi-gesayana afaꞋa ani yana hu-lama-tegahue.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mani kea huteno mage hie “Tamakaya nagaifema tamahau tamayamopafima tama-haisigetamahena tamaha-pai-mainoa kemona akave malegahae. ");
INSERT INTO kmu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Akave malesageꞋna Nenafatega havigesugeno tamaya hisia Avamula hu-tesigeno tamakaite eno agola tamakaiꞋene emaige maige huno maigahie. ");
INSERT INTO kmu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ani Alu Aotage Avamula tamageꞋage kemona aepaꞋa maineno hulama-ve-ligahie. MukiꞋa ma mopale yafema amaugafama aliꞋya nehaiya veaꞋmoya Alu Aotage Avamula ageꞋya havilama ohunaya yafe oꞋavalegahagi tamakaya ago age-lama hutama age-mainaya yafe tamakaiꞋenena emaineno tamakupi haino maigahie. ");
INSERT INTO kmu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na yafe tama-talesugetama megusa nafaꞋne kana hutama omaigahayanagiꞋna tamakaitela eteꞋna egahue. ");
INSERT INTO kmu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Okasi kanaꞋa ma mopale yafema amaugafama aliꞋya nehaiya veaꞋmoꞋya nagoꞋene onagegahayanagitama tamakaya nagegahae. Agola maige maige yamona aepaꞋa mainoafe tamakaya aniꞋa hutama maige maige hisaya tamahaimula alitama maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mainesageno Alu Aotage AvamuꞋmoꞋma esia kanafina nagaya NenafaꞋene mainoanagitama tamakaya aniꞋa hutama nagaiꞋenena maisageꞋna nagaya aniꞋa huꞋna tamakaiꞋenema mainoa yafena havilama hutama havigahae. ");
INSERT INTO kmu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","NagoꞋa veaꞋmoꞋya nagai kema haviꞋya akave malenuꞋya nagaifena hamau amayamopafifna hamau-maine. Nagaifema hamau amayamopafima hamau-mainesia veaꞋmoꞋya NenafaꞋa aniꞋa huno amakaifena hau ayamopafina nehaiye. NehaigeꞋna nagaiꞋenena aniꞋa huꞋna nahau nayamopafina nenahaigeꞋna naguꞋa amamisugeꞋya nagaila nage-lama huꞋya nagegahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Higeno nago kanoa, Yutasi Isakalioti omagi, hamoꞋamoꞋa mage huno Yisasina havige “Alanimogae naꞋa higeka kagaya tagaila taulagafina kagaika aepakaꞋa tave-nelinagi mukiꞋa ma mopale yafema amaugafama aliꞋya nehaiya veaꞋmogami amaulagafina hu-falote huka ohunanane?” huno havinege. ");
INSERT INTO kmu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Havigegeno YisasiꞋa mage huno hie “NagoꞋa veaꞋmoꞋyama nagaifema hamau amayamopafima hamaisigeꞋyahena nagai kemona akave malesagenofena NenafaꞋa amakaifena aniꞋa huno hau ayamopafina haugahie. NenafaꞋene nagaiꞋnienena amakaiꞋene emaigahuꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","NagoꞋa veaꞋmoꞋya nagaifema hamau amayamopafima ohamaisiana nagai kemona akavela nomalae. Manima tamaha-nepauva kea nagaiꞋnige kea omalegi hu-na-tenea Nenafa ke hane. ");
INSERT INTO kmu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","TamakaiꞋenema maineꞋna mani kea ago tamaha-pai-mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tamaha-pai-mainoanagino NenafaꞋa nagai nagileꞋma hu-tesia kanomoꞋa, tamayama hisia Alu Aotage Avamulagino emaineno mukiꞋa yana hulamave-liteno mukiꞋa tamaha-pai-mainoa kea alino tamakesa hao hinagetama havigahae. ");
INSERT INTO kmu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tama-taleꞋna ugahe tamaipa falu hutama maisaya tamaku tamakesa nelamamue. Nagayama naipa falu huꞋna nemauva nagu nagesa nelamamue. Anima tamaipa falu hutama maisaya yama tamamua yana ma mopale veaꞋmoya amaipa falu nehaya ya kana ohunegi kanaꞋage tamaku tamakesa havitama kolia ohiho. ");
INSERT INTO kmu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘TamataleꞋna uteꞋna eteꞋna tamakaitega egahuema.’ huꞋna tamaha-pauva kea ago havilinae. Nagaifema tamahau tamayamopafima nelamahaisigetamahena Nenafa mainelega visua yafena muse haleꞋasine. NenafaꞋa nagaseno ala kano mainea yafe Nenafa mainelega visua yafena muse haleꞋasine. ");
INSERT INTO kmu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","TamataleꞋna visua kanafina nagaife havitama tamakupi maletama tamametitima hisaya yafe yaufa ani kana falote ohunea kanafi menia mani kea tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","SataniꞋa, ma mopaleꞋma kava hu-mainea kanoa ago neꞋeanagiꞋna nagaya nagoꞋene kea ohugahue. Satanina tokiyaꞋamoꞋa nagaila onagaseneanagi Nenafa nahapai-mainea kava huꞋna faligahue. ");
INSERT INTO kmu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nagayama Nenafafema nahau nayamopafi nenagea kavala ma mopale veaꞋmoꞋya havisaya yafe Nenafa naha-pai-mainea kava nehue. Hai nehugi vigetao.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","YisasiꞋa mage huno hie “Nagaya tamage huꞋna vaini alagamo nofi maugeno NenafaꞋa ani vaini alagamo nofi hoyalela yagai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Agaya mukiꞋa nagai vaini nofi akopaꞋmoꞋa alagama oꞋayea akopaꞋyaga atagi neꞋataleno alagama ayea akopaꞋyaga ‘NagoꞋene alaga ayesie.’ huno aiꞋa alino hagalo nehie. ");
INSERT INTO kmu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tamaha-pai-mainoa kemoꞋa tamakaila ago alino hagalo higeno oniꞋyatamia omalenegi kanale tamahau-maine. ");
INSERT INTO kmu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tamakaya nagaiꞋenema ai-gaꞋmaesayana nagaya tamakaiꞋenena ai-gaꞋmaeꞋna maigahue. Nago vaini alagamo nofiꞋmo akopamoꞋma nofiteꞋma ai-okaꞋmaesiana alaga oꞋayegahie. NaꞋa hu-maineafe tamakaya nagaila navaꞋaleꞋma ai-okaꞋmaesayana tamakaya alaga oꞋayegahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nagaya vaini alagamo nofi maugetama tamakaya ani vaini alaga nofiꞋmo akopaꞋa mainae. Tamakaya nagaiꞋenema ai okaꞋmaesayana nagoꞋa kanale kavala ohugahae. Kanale kavaꞋma hinutamahena nagaiꞋene ai-kaꞋmaetama maiho. NagoꞋa veaꞋmoꞋyama nagaiꞋenema ai-gaꞋmaeꞋya maisageꞋna nagayama amakaiꞋenema ai-kaꞋmaeꞋna maisuana kasagoꞋya nofi alagamo kaveꞋa ayegahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","NagoꞋa veaꞋmoꞋya nagaiꞋenema ai-okaꞋmaesayana oꞋayea vaini nofiꞋmo akopaꞋma atagiꞋya hagaꞋyu hu-talagenoꞋma hagage nehia kava nehae. Ani akopayaga alitalu huꞋya atafi kae-talenae. ");
INSERT INTO kmu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tamakaya nagaiꞋenema aigaꞋmaetama maisayana nagai kemoꞋa tamakupina hanesigetama nagoꞋa yafema naha-vi-gesayana naha-vi-gesaya yana hu-lama-tegahue. ");
INSERT INTO kmu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tamakayama kasagoꞋya nofi alagamo kaveꞋma aye-gasagoꞋma hisaya yateti NenafaꞋa ala agia aligahie. Alinagetama-nagitama tamakaya nagaiꞋenema tokaeꞋya nemaiya anaga maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","NenafaꞋa nagaifena hau ayamopafi hau-mainea kava huꞋna tamakaifena aniꞋa huꞋna nahau nayamopafi nenahaiye. Nahau nayamopafima nenahaiya yamo aguꞋafinaga faletama maiho. ");
INSERT INTO kmu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nagaya NenafaꞋma hu-mainea kahegi kema haviꞋnama akave maloa yafe NenafaꞋa nagaifena hau ayamopafina nehaiye. Tamakaya aniꞋa hutama hu-mainoa kahegi kea havitama akave malesayana tamakaifema nahau nayamopafi nenahaiya yamo aguꞋafinaga faletama maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nagai naguꞋafima muse yama hanea yana tamakai tamakupi male hava-telama-tesua yafe mani kea tamaha-pai-mainoane. ");
INSERT INTO kmu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nahau-mainea kavala mage huꞋna nehue ‘Nagaya tamakaifema nahau nayamopafima nahaiya kava hutama nelama-fugamifena tamahau tamayamopafi tamahainageno aniꞋa huꞋya amakaya tamakaifena hamau amayamopafina hamaino.’ huꞋna tamaumonola nemaloe. ");
INSERT INTO kmu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nago kanomoꞋma nefufema ‘Kagai kaugafama ali-gatisua yafene huꞋna nagaya faligahue.’ hunoꞋma hisiana mukiꞋa veaꞋmogami hamau amayamopafima nehamaiya kavala amakasegahie. ");
INSERT INTO kmu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nagayama nehua kema akave malenutamahena nagaiꞋni nenafugatama maigahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nagaya tamakaifena ‘AliꞋya vayaꞋnimogatama mainae.’ huꞋna nagoꞋene ohugahue. Nago aliꞋya kanomoꞋa kava kanoꞋamoma aliꞋyama alia aepaꞋa oꞋagenegi nagaya mukiꞋa yama NenafaꞋma naha-pai-mainea kea ago tamaha-pai-mainoa yafe ‘AliꞋya vayaꞋnimogatama mainae.’ huꞋna ohugahugi agoꞋma tamaha-nepauva yafe ‘Tamakaya nagai kanapa mainae.’ huꞋna nehue. ");
INSERT INTO kmu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tamakaya nagaila nagetama hu-yoꞋokinagi nagaya hagoteꞋna tamakaila tamakeꞋna hu-yogiteꞋna tamakaitami utama Anumaya Koti haisia kava hisaya yafe hu-yogilama-tenoe. AniꞋama hisaya yapiti alagaꞋa falote huteꞋya agola mainesagetama nagai nagileꞋma Nenafatega havigesayana mukiꞋa havigesaya yana tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kahegi kea mage huꞋna tamaumonola nemaloe nelama-fugamifena tamahau tamayamopafi tamahainageꞋya aniꞋa huꞋya tamakaifena hamau amayamopafi hamaino.” ");
INSERT INTO kmu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ma mopale yafema amaugafama aliꞋya nehaiya veaꞋmoꞋya tamakaila kamema hu-lama-tesagetamahena tamakesa hao hinagetama haviho. HagoteꞋya nagaila aniꞋa huꞋya kamea hu-na-tenayane. ");
INSERT INTO kmu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tamakaya ma mopale veaꞋmoꞋya nehaya kavaꞋma hutama mainaleꞋasipa mani mopale veaꞋnemoꞋya hamau amayamopafi tamakaifena hamaileꞋasinagi nagaya ma mopafi vayapiti tamakeꞋna hu-yogi-malenoafe tamakaya mani mopale vea kana veaꞋne omainae. Na yafe ma mopale yafema amaugafama aliꞋya nehaiya veaꞋnemoꞋya amakesa nehaviꞋya kamea hu-nelama-tae. ");
INSERT INTO kmu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nagaya mage huꞋna ago tamaha-pai-mainoe ‘AliꞋya kanoꞋamoꞋa kava kanoꞋamona oꞋagasene.’ huꞋna hu-mainoane. Ani kehe tamakesa havitama maiho. NagoꞋa veaꞋmoꞋya nagaiꞋma, tamakai kava kanotamimonima, aliꞋya haviyama hu-na-taya kava huꞋya aniꞋa huꞋya tamakaila aliꞋya haviya hu-lama-tegahayanagi nagoꞋa veaꞋmoꞋya nagai kema haviꞋya akave nemalesaya veaꞋmoꞋya tamakai kea aniꞋa huꞋya haviꞋya akave malegahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hu-na-tenea kanomona havilama huꞋya ohavinaya yafe ani kavala hu-lama-tegahae. Tamakaya nagai veaꞋnema mainaya yafenagiꞋya ani kavala hu-lama-tegahae. ");
INSERT INTO kmu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nagaya eꞋnama kema hama-opauleꞋasina ‘Kefo katia hane.’ huꞋya ohaleꞋasine. AfaꞋa ago me hama-pauvanagi kefo yama hu-mainaya yafena kalagi aiteꞋya agasesaya katamia omalene. ");
INSERT INTO kmu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","NagaiꞋma kamema hu-na-tesaya veaꞋnemoꞋya NenafaꞋene kamea hu-neꞋatae. ");
INSERT INTO kmu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nagaya amakaipima maineꞋnama nagoꞋa veaꞋmoꞋyama tokiya kavaꞋma ohuleꞋasina ‘Kefo yatia hane.’ huꞋya ohaleꞋasinagi ago alugeꞋya ageteꞋya nagaiꞋene NenafaꞋenena kamea hu-nelaꞋa-tae. ");
INSERT INTO kmu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Amakai kahegi kema kae-malenaya kemoꞋa nagaifena mage hu-mainayane ‘Havi kavala ohunegeꞋya kamea afaꞋa hu-neꞋa-tae.’ huꞋya kae-malenayane. Mani kemoꞋa ago falote huno tamage hisia yafe nagaila kamea hu-nena-tae. ");
INSERT INTO kmu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nenafategati tamaya hisia vekaꞋa hu-tesugenoꞋma esiana tamageꞋage ke huno tamaha-paisia vekaꞋa, Alu Aotage Avamula NenafategatiꞋma esiana nagaifena tamaha-paigahie. ");
INSERT INTO kmu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tamaha-paigahianagitama nagaya aliꞋyama aepa heꞋna ali-mainoa kanaleti tamakayama nagaiꞋenema mainaya yafe nagaifena veaꞋmogamina hama-paigahae.” ");
INSERT INTO kmu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","YisasiꞋa mage huno hie “Nagaifema tamakupima ago malenaletiꞋma neꞋataletama alu kate oꞋvisaya yafe mani kea tamaha-pai-mainoe. ");
INSERT INTO kmu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Amakaya tamakaila mono nopitila tamavaleꞋya tamanati-talegahae. Ani kanama esia kanafina nagoꞋa veaꞋmoꞋya tamakaila nelamahaeꞋya ma amakesa havigahae ‘Mani kavaꞋma nehunana Anumaya Kotina akave nemalone.’ huꞋya hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","NenafaꞋene nagaiꞋenema amakuꞋa otaꞋaminaya yafe ani kavala hu-lama-tegahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ani kanama falote hisia kanafina tamaha-pai-mainoa kemoꞋa tamakesa ai-hagalo hinagetama havilama hisaya yafe menia mani kea tamaha-nepauve. Ehe kanafina tamakaiꞋenema mainoa yafe nayona ani kea tamaha-opainoane. ");
INSERT INTO kmu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","NagaiꞋma hu-na-tegeꞋna emainoa kanolega menia eteꞋna ugahuanagitama nago vekamoga nagaifena ‘Hanatega neꞋvane?’ huka nahavi-nokane. ");
INSERT INTO kmu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nahavi-nokayanagi nagayama tamaha-pai-mainoa kehe tamakesa havitama tamahau nehae. ");
INSERT INTO kmu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tamahau nehayanagi tamage-lafa huꞋna tamaha-nepauve nagayama oꞋvisuana tamaya hisia kanoa omegahigi nagayake uteꞋna tamaya hisia kanoa hu-tesugeno tamakaitegama esiana kanale kanaꞋa falote hu-lama-tegahie. ");
INSERT INTO kmu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","EfaloteꞋma hisiana tamaya hisia kanomoꞋa mukiꞋa ma mopale veaꞋmogami kefo yama nehaya aepaꞋamiene kanale kavaꞋma nehaya aepaꞋamiene Anumaya KotiꞋa kaiyekema hu-ma-tesia yamo aepaꞋaene hu-falote hisigeꞋya haviteꞋya agegahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kefo yamo aepamofena tamaya hisia kanomoꞋa mage huno hugahie ‘Yisasifena havitama tamakupi maletama tamametiti nohaya yafe kefo yatamia hane.’ huno hugahie. ");
INSERT INTO kmu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nagaya Nenafa mainelega eteꞋna ugahuanagitama nagoꞋene nagaila onagesayafe tamaya hisia vekamoꞋa kanale kavaꞋma hisaya yamo aepaꞋa hu-falote hinagetama havitetama agegahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Anumaya KotiꞋa ma mopale kava kanoa, Satanina, ago kaiyekea hu-tenea yafe tamaya hisia vekaꞋa Anumaya KotiꞋma kaiyekema hu-ma-tesia yamo aepamoꞋa hu-falote hinagetama havitetama agegahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nagaya kasagoꞋya kea tamaha-paigahe nehuanagi kanaꞋage hu-mainea yafe tamakaya havilama hutama ohavigahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ohavigahayanagi Anumaya Kotina tamageꞋage nehia AvamuꞋamoꞋma esiana agaiꞋalegati mukiꞋa Anumaya Koti tamageꞋage kea tamaha-paigahie. Agesafiti kea tamaha-opaigahianagino nehavia keꞋageꞋene haenagama esia kanafima falote hisia yamo kene tamaha-paigahie. ");
INSERT INTO kmu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tamaha-painageno ani kanomoꞋa nagayama hu-mainoa kea tamakaila tamaha-paisia yafe nagai nagia tusiya huno ali-saga hugahie. ");
INSERT INTO kmu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hugahianagi mukiꞋa NenafaꞋma malenea yana nagaiꞋniꞋa yamaꞋage fatago huno hanea yafe mage hu-mainoe ‘Alu Aotage AvamuꞋmoꞋa amisua kea alino tamakaila me lamaha-paigahie.’ huꞋna hu-mainoe.” ");
INSERT INTO kmu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Osi kana kanoꞋa nagoꞋene onagegahagi osi kana kanoꞋa maitetama etetama nagegahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","HigeꞋya nagoꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋamoꞋya amakaiꞋamifina mage hae “Osi kana kanoꞋa onagegahae huno nehuno etetama osi kana kanoꞋa nagegahae huno nehunoꞋma nehia kemona aepaꞋamoꞋa hanaꞋa hu-maine? ‘Nenafatega visua yafe nehue.’ huno nehia kemona aepaꞋa nohavune. ");
INSERT INTO kmu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Osi kanaꞋaema hia kemona aepaꞋa naꞋane huno nehie? Tagaya agayama hia kea nohavune.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","NehuꞋya havigegahema haya kea YisasiꞋa ago aguꞋafinaga haviteno mage huno hie “Hua kemoꞋa ‘Osi kana kanoꞋa nagaila onagegahagi etetama osi kanaꞋa maitetama nagegahaema.’ hua kehena tamakaya lamakaya tamakaitamifina mani kemona aepaꞋahe huge havige nehao? ");
INSERT INTO kmu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tamage-lafa huꞋna lamaha-pauve tamakaya tamataleꞋnama visua yafena avia ategahayanagi ma mopale veaꞋmoꞋya muse hugahae. Tamakaila hagoteno tamahau hu-tesigetama haenagaꞋa ai-yahae hutama muse hugahae. ");
INSERT INTO kmu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","AꞋmoꞋma nafaꞋnema ategahema nehuno agatama aisia kana falote hisia yafe hauna hianagi nafaꞋnema ago atetenoꞋa ‘NafaꞋnea ago atoe.’ huno muse nehuno agatama ai-mainea yafena age-kani-maine. ");
INSERT INTO kmu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ani kanamoꞋa tamakaipina hane. Menia tamakaya tamahau nehayanagi eteꞋna tamakesugenoꞋa tamakupina muse yamoꞋa hiya hinageno nago kanomoꞋa ani muse yana tamaha-ofalegahie. ");
INSERT INTO kmu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ani kanama evaꞋyima hisiana tamakaya nagaila nago yafena nahavi-okegahae. Tamage-lafa huꞋna tamaha-pauve nagaifema hutama nagai nagima ayetama nago yafema Nenafama havigesayana mukiꞋa havigesaya yana afaꞋa tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","NayoꞋene meniene nagaifena nehutama nagia ayetama nagoke yafena Nenafana haviokenayane. Nagi menia muse yatamimoꞋma tamakupina hiya huno hanesia yafena nahavigegeꞋna tamamino.” ");
INSERT INTO kmu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mani kea tamakaila avame kefi hu-maleꞋna tamaha-nepauvanagi haenagaꞋa mani avame kea nagoꞋene ohugahuanagiꞋna hu-falote huꞋna Nenafafena tamaha-paigahue. ");
INSERT INTO kmu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Hu-falote hisugetama ani kanafina nagai nagile havigegahagi nagaya ‘Tamakaifena Nenafana havigegahue.’ huꞋna ohunogi tamakaya nagaifena tamahau tamayamopafi nelamahaiya yafe NenafaꞋa tamakaifena hau ayamopafi nehainageno havigesaya yana agaiꞋa tamamigahie. Nagayama Anumaya Kotitegati emainoa kema tamakupi malenaya yafe NenafaꞋa tamakaifena hau ayamopafi nehaiye. ");
INSERT INTO kmu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nagaya NenafaꞋene mainoleti ma mopafina emainoe. Menia nagaya mani mopa ataleꞋna Nenafatega ugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","HigeꞋya agaiꞋaenema tokaeꞋya nemaiya anagaꞋmoꞋya mage hae “E, avame kefiti menia nohanagi hu-falote huka nehane. ");
INSERT INTO kmu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Menia tagaya havunana kagaya mukiꞋa yana havimalenane. MukiꞋa veaꞋmoꞋya amakupima haviya yana ago havimainana yafe nago kanomoꞋa nago yafena kahavi-okesie. MukiꞋa yana havimainana yafe tagaya kagaifena Anumaya Kotitegati emainane huta tagupi malenone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","YisasiꞋa kenonaꞋamilela mage huno hie “Meni tamakaya havitama tamakupina nemaletama tamametiti nehafio? ");
INSERT INTO kmu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Haviho nago kanamoꞋa aupaꞋa egahema hia kanamoꞋa ago efalote hu-maine. Ani kanafina nagoke nagokeꞋmogatama nataletama kumatamile ute ete hugahae. Nataletama visageꞋna nagaiꞋnige maigahuanagi NenafaꞋa nagaiꞋenena maine. ");
INSERT INTO kmu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","TamakuꞋa namitetama tamaipa falu hutama hilato hutama maisaya yafe mani kea tamaha-pai-mainoe. Ma mopale mainesageno nago kanaꞋage yamoꞋa falote hugahianagi kolia ohiho. Nagaya ma mopafi auꞋava yana ago agaseꞋna kava yagai-mainoe.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","YisasiꞋa mani kea huteno ikapinaga age-saga hu-maineno Anumayamotega mage huno hie “Nenafagae falisua kanaꞋnia ago efalote hie. NekamoꞋna kagi ali-saga hisua yafe faliteꞋna he-tiꞋna kagaitega haisua yafe lokiya hale yania nekamonina namio. ");
INSERT INTO kmu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nekamonia mukiꞋama naminana veaꞋmogamina agola maige maige hisaya hamaimuꞋamima amamisua yafe mukiꞋa veaꞋmote kava yagaisua tokiyaꞋnia ago naminane. ");
INSERT INTO kmu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Anumaya Kotiga kagaikage ala tokiya kanoa tamagemona tamaꞋa nagokeꞋage Anumaya mainanagi veaꞋmoꞋya kagaifema havilama huꞋya maisayana hu-tenana kanoa ‘YisasiꞋa veaꞋmogami amaku amamemaꞋa ali-gatisia kanoa ikapinagati emainea kano maine.’ huꞋya havilama hisayana maige maige hisaya hamaimula aligahae. ");
INSERT INTO kmu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","5","Naminana tokiya hale yatetiꞋa ma mopalela kagia alisaga hu-mainoe. Naminana aliꞋyana ago aliꞋna avaya aye-mainoa yafe Nenafagae meni kanafina kagai kavate mainesugeka tokiya hale yaniꞋa namio. Ma mopama talo ohunana kanafina kagaiꞋene mainoanagiꞋna tokiya hale yania haneanagi menia eteka ani yana namio. ");
INSERT INTO kmu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma mopafi veapitiꞋma naminana veaꞋmogamina ago aepakaꞋa hu-falote huꞋna hama-pai-mainoe. Ani veala kagaikaꞋa veaꞋnegika nagaila ago naminane. NaminanageꞋya ani veaꞋmoꞋya kagai kea atafa hu-linae. ");
INSERT INTO kmu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Atafa hu-lineꞋya mukiꞋa naminana yana kagaikaꞋalegati emaine huꞋya menia ago havilinae. ");
INSERT INTO kmu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Naminana kea ago amamugeꞋya ago atafa huꞋya havilama hulineꞋya nagayama kagaitegatiꞋma emainoa yafena tamage nehie huꞋya havilama hu-lineꞋya kagayama hu-na-tanageꞋna emainoa yafena amakupi maleꞋya amametiti nehae. ");
INSERT INTO kmu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amakaifena Nenafagale ke huꞋna kahavi-negoe. Ma mopale yafema amaugafa aliꞋya nehaiya veafe Nenafagale menia kahavi-nokogi kagaikaꞋama naminana veaꞋnea kagai veaꞋne mainaya yafe naminana veafe kahavi-negoe. ");
INSERT INTO kmu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nagai veala kagai veale. Kagai veala nagai vea mainageꞋya ani veaꞋnimoꞋyama nagai tokiyaleti haya kavala nehageꞋya mopale veaꞋmoꞋya ageteꞋya nagai nagia alisaga nehae. ");
INSERT INTO kmu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ali-saga nehageꞋna menia ma mopaletila ataleꞋna kagaitega ugahuanagi nagaifema amakupi nemalaya veala ma mopafi maigahagi alu aotage Nenafaga kagaika kagileti naminana nagileꞋma hanea tokiyaleti auꞋvai-ma-tesanana taꞋagaya nagoke kanolatama mainoꞋa ya huꞋya amakaya nagoke kate maleꞋya nagoke veaꞋne maisae. ");
INSERT INTO kmu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nagaya amakaiꞋene maineꞋna kagayama naminana nagileꞋma hanea tokiyaleti auꞋvai-ma-togeno nagoꞋmoꞋa hani-ki-mainea yapima tegelege nehia atafina oꞋugahagi Anumaya Koti kema kae-malenaya kemoꞋma efalote huno tamagema hisia yafe anima hani-ki-mainea yapima tegelege nehia atafima visia kanoa YutasiꞋa agaiꞋage ugahie. ");
INSERT INTO kmu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Menia eteꞋna kagaitega egahugi nagayama nehua muse yaniꞋamoꞋa amakai amakupina hava-tesia yafe ma mopale maineꞋna mani kea hama-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hama-nepaiꞋna kagai kea ago amaminogi nagaya ma mopafi kanoa omaiꞋnoe. Alu nagu nameꞋene kano mainogeꞋya amakaya nagayama hua kava huꞋya ma mopale veaꞋne kana vea omainae. Alu amaku amameꞋene veaꞋne mainaya yafe ma mopale veaꞋmoꞋya amakaife amaipa kafa he-ma-teꞋya kamea hu-neꞋama-tae. ");
INSERT INTO kmu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kamea hu-neꞋama-tayanagi nagaya veaꞋnimogamifena ‘Ma mopaleti amavalesaga huo.’ huꞋna kahavi-nokogi ‘SataniꞋma aye-mavataga hu yafe auꞋvai-mateka amaugafa ali-gatisanageꞋya kaꞋyeꞋya maisae.’ huꞋna kaha-vi-negoe. ");
INSERT INTO kmu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nagaya ma mopale kanoa omaiꞋnoe. Alu nagu nameꞋene kano mainogeꞋya amakaya nagai kana huꞋya ma mopale veaꞋnea omainae. Alu amaku amameꞋene veane mainae. ");
INSERT INTO kmu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mainayafe kagaika ke-lamage kekaleti alu aotage veaꞋne maisaya amaku amakesa amamio. Kagayama hu-mainana kemoꞋa tamageꞋage nehie. ");
INSERT INTO kmu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kagaya ma mopafima nagaiꞋma hu-natanageꞋna emainoa kava huꞋna naminana veaꞋnea nagaya mopale veaꞋmogami amuꞋnopi ago hu-ma-tenoe. ");
INSERT INTO kmu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nagi tamage huꞋya amaku amamemaꞋamona kagaila kamisaya yafe nagaya nagu namemaꞋamona kagaila negamue. ");
INSERT INTO kmu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","NagaiꞋenema mainaya veaꞋneꞋagefena kahavi-nokogi amakayama hisaya keleti nagaifema haviꞋya amakupi maleꞋya amametitima hisaya veafeꞋene kahavi-negoe. ");
INSERT INTO kmu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nenafagae mage huꞋna kahavi-negoe kagaya nagaiꞋenema mainageꞋna nagaya kagaiꞋenema maugetaꞋama huꞋa kava huꞋya nagaifema amakupi malenaya veala nagoke vea kanoꞋa taꞋagaiꞋene maisageꞋya mukiꞋa mopale veaꞋmoꞋya kagayama hu-na-tanageꞋnama emainoa yafema haviꞋya amakupi maleꞋya amametiti hisae. ");
INSERT INTO kmu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","TaꞋagayama nagoke taꞋaipaleꞋma mauꞋa kava huꞋya nagoke amaipale maisaya yafe naminana tokiya hale yaniꞋa ago amaminoe. ");
INSERT INTO kmu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Amakaya nagoke vea kanoꞋa mai-lama huꞋya maisaya yafe nagaya amakaiꞋenena maugeka kagaya nagaiꞋenena mainane. Kagaya hu-na-tanageꞋna emainoa yafema mukiꞋa mopale veaꞋmoꞋya havisaya yafeꞋene nagaifena kahau kayamopafi negahaigeka aniꞋa huka ma mopale veafeꞋene kahau kayamopafi kahau-mainea yama havisaya yafe kagai kema havimalenaya veaꞋmoꞋya nagoke vea kanoꞋa maisae. ");
INSERT INTO kmu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nenafagae ma mopama taloma ohunana kanafina nagaifena kahau kayamopafi kahaigekama naminana tokiya hale yaniꞋa nagaiꞋma naminana veaꞋmoꞋya agesaya yafe nagaya maisua kumate maisae huꞋna nehue. ");
INSERT INTO kmu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","KanaleꞋya huka fatago hu-mainana Nenafagae ma mopale yafema amaugafa aliꞋya nehaiya veaꞋmoꞋya kagaila okagenagi nagaya ago kagaila kage-mainoafe ma ma mainaya veaꞋmoꞋya nagaiꞋma hu-na-tanageꞋna emainoa yafena ago haviꞋya ageꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nagaifema kahau kayamopafi kahau-mainea yana amakai amakupi malesana yafe aepakaꞋa hu-falote huꞋna hama-pai-mainoanagi nagoꞋene hama-paigahue. Nagaya amakupi maisua yafe aepakaꞋa ago hama-pai-mainoe.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","YisasiꞋa ani kea Anumayamotega havigeteno tuelufuꞋa (12) anagaꞋaene hati-laviꞋya Kitaloni lina mo laꞋkaeꞋya umainae. Atu kaiyaga nago olivi yosa kali-malenaya hoya hanegeꞋya YisasiꞋa agaiꞋaenema tokaeꞋya nemaiya anagaꞋamoꞋyaene ani hoyafinaga umainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Umainayanagi mukiꞋa yupa YisasiꞋa tuelufuꞋa (12) anagaꞋamoꞋyaenena ani hoyafinaga molitalu huꞋya nemaiya yafe YutasiꞋa, agesiꞋma huno Yisasina kamema hu-tesia kanomoꞋa, ani hoya ago age-maineane. ");
INSERT INTO kmu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Age-maineanagino YutasiꞋa viaꞋyamo ala mono note kava vayateꞋene* Falasia vayateꞋene vigeꞋya mono note ati vayaꞋene Lomu ati vayaꞋene amigeno amavaleno ani hoyafinaga kaꞋniꞋene lamu kaꞋniꞋene tu hisaya yaꞋene aliꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ayanagi YisasiꞋa mukiꞋa augafaleꞋma falote hugahema hia yana ago haviteno amakaite viaꞋyamo mo hama-vige “Tamakaya tafe atineꞋayae?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","HigeꞋya kenonaꞋa mage huꞋya hae “Nasaleti Yisasife ati-yeta neꞋone.” huꞋya hageno YisasiꞋa mage hie “Nagaya ma mainoe.” huno higeno agesiꞋma huno Yisasina kamema hu-tea kanoa, YutasiꞋa, ani vayaꞋene tokaeno maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mainegeno YisasiꞋa “Nagaya ma mainoe.” hunoꞋma hia yafe amakavelegati eteꞋya valega mo fae-laka-ti-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Fae-laka-ti-tageno YisasiꞋa nagoꞋene eteno hama-vige “Tafe ati neꞋayae.” huno higeꞋya amakaya nehuꞋya “Nasaleti Yisasife ati neꞋayone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hageno YisasiꞋa kenonaꞋamia mage hie “Nagaya ago tamaha-nepauve nagaya ma mainoe huꞋna nehue. Tamakaya nagaifema nati neꞋayenutamahena ma ma nagaiꞋenema mainaya vayala amatalegeꞋya afaꞋa viho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","YisasiꞋa agoꞋma hu-mainea kea mage huno hu-maineane “Naminana veala nagoke kanoꞋa ata-oꞋayegahie.” huno hu-maineane. Anima hu-mainea kemoꞋa falote huno tamagema hisia yafe YisasiꞋa “AmatalegeꞋya viho.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Higeno Saimoni PitaꞋa ayaꞋaya naepeꞋa ali-lianagino alisagino ala mono note hagote kava kanomo aliꞋya kanoꞋa, Malakusina, ai-koligeno tamaga kaiyaga agesa aifa-kali-talegeno asaga hu-lavi-maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ai-fakaligeno YisasiꞋa Pitafena hapaino “AyaꞋaya naepekaꞋa tafugepi vaiyo. Naugafaene nagu name nagata aisia yaniꞋa satuꞋage hia tima hanea masu keꞋayola NenafaꞋa naminegi nagaife onesie huka nehano?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lomu ati vayaꞋene ala kava kanoꞋamiene mono note ati vayaꞋene Yisasina atafa huꞋya nofi ki-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nofi k-iteteꞋya hagoteꞋya Anasite avaleꞋya umainae. AnasiꞋa Kaiyafasina aꞋamona nefa maineanagino KaiyafasiꞋa ani kafufina ala mono note hagote kava kano maineane. ");
INSERT INTO kmu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","KaiyafasiꞋa Yuta vayafe mage huno hama-pai-maineane “Kanalele nagoke kanomo mukiꞋa veaꞋmogamitefe huno falisie.” huno hu-maineane. ");
INSERT INTO kmu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimoni PitaꞋene nagola YisasiꞋenema tokaeno nemaiya kanoꞋene* Yisasina akave anatiꞋana umainaꞋe. NeꞋvaꞋageno mono note kava kanomoꞋa ani YisasiꞋenema tokaeno nemaiya kanomona ago age-mainea yafe agaya YisasiꞋene ala mono note kava kanomo no kegiꞋya kovefinaga hai-fale-maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Haigeno PitaꞋa fiate he-tino mainegeno anima YisasiꞋenema tokaeno nemaiya kanomoꞋa fiateꞋma yagai-mainea munaꞋmofena mo hanepaino Pitana avaleno emaine. ");
INSERT INTO kmu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","NeꞋegeno fiateꞋma yagai-mainea munaꞋmoꞋa Pitafena mage huno havige “Kagaya mani kanomona tuelufuꞋa (12) vayapiti kano mainano?” huno havigegeno “AꞋao nagaya ani vayapiti kanoa omainoe.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","TusiꞋa yasimo higeꞋya aliꞋya vayaꞋene ati vayaꞋene ata kae-taleꞋya he-tiꞋya tota huꞋya mainageno PitaꞋa amakaiꞋene atale he-tino augafa tota huno maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ala mono noteꞋma hagote kava kanomoꞋa Yisasifena “KagaiꞋenema tokaeꞋya nemaiya anagakaheꞋene kagayama hu-ma-veli mainana keheꞋene naha-paiyo.” huno havinege. ");
INSERT INTO kmu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Havigegeno YisasiꞋa mage hie “Nagaya mukiꞋa veaꞋmogamina fufute hama-nepauvane. MukiꞋa yupa Yuta veaꞋnea melitaluma haya mono nopiꞋene ala mono nopiꞋene hama-nepauvane. Fala-kiꞋna hama-opainoe. ");
INSERT INTO kmu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","NaꞋa higeka nagaila nahavi-negane? Nagai kema nehaviya vayafena hama-nepauva kehena hama-vigo. Nagayama hama-pai-mainoa kea ago havilinae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Higeno nago ati kanomoꞋa he-tino maineleti YisasiꞋma mani kema nehiana augosafi ai-ko-nelino mage hie “NaꞋa higeka kagaya ala mono note hagote kava kanomo aulagafina mani kea nehane?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Higeno YisasiꞋa kenonaꞋa mage hie “Kefo kema hu-mainesugekahena nagaya kefo kema hua kea hu-falote huka naha-paiyo. Nagayama kanale kema hu-mainesugekahena naꞋa higeka nai-ko-neline?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","HigeꞋya nofiꞋma kitaya nofila kalu he-oꞋa-teneꞋya AnasiꞋa ala mono note hagote kava kanoa, Kaiyafasitega hu-tegeꞋya avaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","NeꞋvageno Saimoni PitaꞋa atale maineno ata lota huno mainegeꞋya agaife mage huꞋya hae “KagaiꞋenena mani kanomona tuelufuꞋa (12) vayaꞋamopiti kano mainano?” huꞋya hageno PitaꞋa avane huno mage hie “AꞋao nagaya ani kanoa omainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Higeno ala mono noteꞋma hagote kava kanomo aliꞋya kanoꞋamona, PitaꞋma agesama ai-fakali-talegeno asaga hu-lavi-mainea kanomo anagapiti kanomoꞋa mage huno hie “Kagaya YisasiꞋene hoyafina mainaꞋageꞋna kage-mainoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Higeno PitaꞋa nagoꞋene avane huno “AꞋao nagaila onagenane.” huno higeno aupaꞋa kokolemoꞋa age ai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yisasina Kaiyafasi nopinagati Lomu kamanile ala kava kanomoꞋa kaiyekema hu-neꞋamatea note kegeꞋafiti avaleꞋya umainae. Yuta vayaꞋmogamina mono keꞋamimoꞋa mage huno hu-maine “Afa vayaꞋene tokaetama maisayana amakai kava hutama kefo vaya mainaya yafe ala imu kavela onegahae.” huno hu-mainea yafe Yuta vayaꞋmoꞋya ala imu kaveꞋma mo nesaya yafenagiꞋya ani nopina ohainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kumatega mainageno PailatiꞋa, Lomu kamanile ala kava kanomoꞋa, amakaite eno mage huno hama-vige “Tamakaya naꞋane keleti mani kanoa kaiyekea hu-tegahae?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","HigeꞋya kenonaꞋa mage huꞋya hapaiye “Mani kanomoꞋma kefo kavaꞋma ohuneleꞋasipa avaleta kagaitela omoteꞋasine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hageno PailatiꞋa eteno mage huno hama-paiye “Tamakaya avaletama tamakaitami mono keleti kaiyekea hu-teho tamakaitami yane.” huno hie. HigeꞋya Yuta vayaꞋmoꞋya mage huꞋya hu-mainae “Kagaya kamanimoga huka taumono malenana kemoꞋa nago kanoa haegeno ofalino.” huka hu-mainane* huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nayona YisasiꞋa mage huno hu-maine “Nagayama falisua yana yafaga yosale nahaeꞋya nasaesageꞋna faligahue.” huno hu-maineane. Lomu kamani vayaꞋmoꞋyage vayala yafaga yosalela hamaeꞋya asaigeꞋya fali-mainae. YisasiꞋa agoꞋma hu-mainea kemoꞋa falote huno tamage hisia yafe Yuta vayaꞋmoꞋya mani kea hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hageno PailatiꞋa ataleno kaiyekema hu-neꞋama-tea nopinaga haino maineno Yisasife ke higeno vigeno mage huno havige “Kagaya Yuta veaꞋnogami sauve kano mainano?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Havigegeno YisasiꞋa kenonaꞋa mage hie “Kagaya kagu kagesafiti mani kea nehapi ifi nagoꞋa vayaꞋmoꞋya nagaifena kaha-paigekahe nehano?” huno eteno havige. ");
INSERT INTO kmu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Havigegeno PailatiꞋa kenonaꞋa mage huno havige “Nagaya Yuta kano mainogeka nehano? Kagai nofi vayaꞋene ala mono note kava vayaꞋene kavaleꞋya nagaite neꞋaya yafena kagaya na havi kava hu-mainane huꞋna kahavi-negoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Higeno YisasiꞋa kenonaꞋa mage hie “Nagaya kava yagaisua kumala ma mopafina omalene. Inagi ma mopafima kava yagaisua kumaꞋniꞋama haneleꞋasipa aliꞋya vayaꞋnimoꞋya kamea hageꞋya nagaila navaleꞋya Yuta vayaꞋmogami amayapina onataleꞋasine. Inagi nagaya kava yagaisua kumaꞋniꞋa ma mopafina omalene.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Higeno PailatiꞋa mage huno hie “Ala sauve kano mainoe huka nehano?” huno higeno YisasiꞋa kenonaꞋa mage hie “Kagaya nagaife ala sauve kano mainane hukama hana kea tamage nehane. Nagaya itaꞋnimoꞋma natenelegatiꞋma emaineana ke-lamaꞋage hu-falote hisua yafe ma mopafina emainogi ke-lamama haviꞋya amakupi malenaya veaꞋmoꞋya nagayama hua kea nehaviye.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Higeno PailatiꞋa Yisasife mage hie “Ani ke-lamage kea naꞋane ke?” huno nehuno PailatiꞋa hati-lavino kumatega viaꞋyamo Yuta vayate mage huno mo hama-paiye “Kefo kavaꞋma hia yana ati ayegetoana omalene. ");
INSERT INTO kmu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tamakaya mukiꞋa yupa ala imuma kigahena naha-vigageꞋna nago kanoa kina nopitila afaꞋa avaleꞋna nelamamuanagi na yafe nelamahaiye Yuta veaꞋmogatamina sauve kanotamia afaꞋa atalesugeno visio?” huno hama-vige. ");
INSERT INTO kmu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hama-vigegeꞋya ala kefiti mage huꞋya hae “Agaila neꞋataleka Palapasina tamisane.” huꞋya hu-mainae. PalapasiꞋa vaya nehamaeno musufa yamaꞋage hume hume nehaiya kano mainea kanohe hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","PailatiꞋa Yisasina avaleno “Nofi kaꞋyoteti haifu amiho.” huno hama-paigeꞋya haifu aminae. ");
INSERT INTO kmu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","AmiteꞋya ati vayaꞋmoꞋya avetaꞋnafa nofiteti tumano kula talo huteꞋya anute vai-teteꞋya ala kava kanomo fai-neꞋalia augafa haesa kena vai-teneꞋya YisasiꞋma he-tino mainele eꞋya Yisasifena “Felugae. Yuta vayaꞋmogami ala sauve kanomogae.” huꞋya nehuꞋya augosafi amayateti ainagolapeꞋya nehaeꞋya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hageno PailatiꞋa kumatega hati-lavino eaꞋyamo alitaluma hu-mainaya Yuta vayafe mage huno hie “AtiyeꞋna agoana nagoke kefo ya kanoꞋa omalegeꞋna tamakaya mani kea havisae huꞋna avaleꞋna tamakaite hati-laviꞋna neꞋoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Higeno YisasiꞋa kumategama hati-lavino eana avetaꞋnafa nofitetiꞋma talo hu-malaya tumano kula anute vai-teteꞋya haesa kena fai-tetageno hati-lavino elavigeno PailatiꞋa mage huno hie “Ageho mani kanoa ma maine.” huno hama-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hama-paigeꞋya mono note kava vayaꞋmoꞋyaene ati vayaꞋene Yisasina ageteꞋya ala kegefafiti mage huꞋya hae “Yafaga yosale nili hetama asaigeno falino. Yafaga yosale nili hetama asaigeno falino.” huꞋya hae. Hageno PailatiꞋa kenonaꞋamia mage huno hama-paiye “Tamakaitami avaletama yafaga yosalela nilia hetama asaiho. Nagaya nago kefo yamaꞋahena ati-yoana omaleanagiꞋna ohaegahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","HigeꞋya Yuta vayaꞋmoꞋya kenonaꞋa mage huꞋya hapaiye “YisasiꞋa agaiꞋahena mage huno hu-maine ‘Nagaya Anumaya Koti nafaꞋne mainoe.’ hunoꞋma hiana tagaipina kahegi kemoꞋa mage hu-maine ‘ManiꞋa augafa kema hisia kanomoꞋa falisie.’ huno hu-maineafe menia YisasiꞋa mani kema hu-mainea yafe falisie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hageno PailatiꞋa ani kea haviteno tusiya huno amaꞋyoa neꞋaiye. ");
INSERT INTO kmu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","AmaꞋyo aigeno PailatiꞋa eteno kaiyekema nehavia nopinaga hai-faleno maineno Yisasifena mage huno havige “Kagaya hanategati emainane?” huno havigeanagi YisasiꞋa kenonaꞋa ohune. ");
INSERT INTO kmu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ohigeno PailatiꞋa mage huno hapaiye “Kagaya naꞋa higeka nagelela noꞋaline? Nagaya tokiyaꞋniene kanogiꞋna ‘Kina nopitila atalegahae.’ huꞋnama hisuana afaꞋa katalegahae. ‘Yafaga yosale nili hetama asaigeno falino.’ huꞋnama hisuana aniꞋa hu-ga-tegahae. Kagaya mani kea nohavino?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Havigegeno YisasiꞋa kenonaꞋa mage huno hapaiye “Anafinaga mainea Anumaya KotiꞋa kagaiꞋma tokiyama okamineleꞋasipa nagaila natafa ohateꞋasinagi amakayama navaleꞋya kagai kayapima natenaya vayaꞋmogamina kefo yaꞋamimoꞋa kagai kefo yakamona agaseno kasagoꞋya kefo yaꞋami hane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Higeno PailatiꞋa anima hia kea haviteno “HanaꞋa huꞋna atalesugeno visie?” huno kafe ati-neꞋayegeꞋya Yuta vayaꞋmoꞋya ala kegefafiti mage huꞋya hu-mainae “Nagoke kanomoꞋa YisasiꞋma hia kava huno agaiꞋahe ‘Nagaya ala sauve kanoma mainoe.’ hunoꞋma hisia kanomoꞋa Sisana kameꞋa maine. Kagaya mani kanoma atalesanageno visiana kagaya tagaila ala sauve kanotia, Sisana, kanapaꞋa omainane.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hageno PailatiꞋa ani kema haya kea haviteno Yisasina avaleno hati-lavino kumatega elavino eaꞋyamo ala kaiyekema havi kanomo siale emaine. Ani siama malenaya aupaligahena Yuta vayaꞋmogami kefina Kapatae huꞋya nehae. Ani aupaligahena tagai kefina amalagu aiꞋya yafa malenaya aupaligae huta hugahune. ");
INSERT INTO kmu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ani kanafina Anumaya KotiꞋa amakinagomogami amaugafama ali-gati-mainea yafe Yuta veaꞋmoꞋya amakesa hao hinageꞋya havisaya yafe imu ki kanaꞋamimoꞋa aupa higeꞋya talo tala hisaya yafe yagemoꞋa euno amanutule evigeno PailatiꞋa Yuta veaꞋmogamina mage huno hama-paiye “Ala sauve kanotamimona ageho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","HigeꞋya amakaya ala kegefafiti mage huꞋya hae “AoteꞋyamaꞋae. AoteꞋyamaꞋae. Yafaga yosale nili hetama asaigeno falino.” huꞋya hageno PailatiꞋa mage huno hama-paiye “Nagaya tamakai sauve kanotamia yafaga yosale nili heꞋna asaisue hugetama nehao?” huno higeꞋya mono note kava vayaꞋmoꞋya mage hae “Tagaila nago ala sauve kanotia omaine. SisaꞋa agaiꞋage nagoke maine.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hageno PailatiꞋa “Yisasina yafaga yosale nili hetama asaiho.” huno avaleno amayapi amamine. ");
INSERT INTO kmu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yisasina avaleꞋya vageno haeꞋya asaisaya yafaga yosa agaiꞋa ko-fino anu ayamufae huꞋya nehaya agoꞋyalega umaine. Ani agoꞋyamo agia Yuta vayaꞋmogami kefina Kologotae huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ani agoꞋyafi avaleꞋya vayaꞋamoꞋya yafaga yosale nilia heꞋya asai-malenae. Tole kanolataꞋene hanaote yafaga yosale aluga aluga atupale hanaeꞋya asai-maleneꞋya Yisasina amuꞋnoꞋanifi nilia heꞋya asai-malenae. ");
INSERT INTO kmu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Asai-maletageno PailatiꞋa nago avona kaeno Yisasina nilima he-malaya yafaga yosale asai-malene. Ani avomoꞋa mage hie “Nasaleti YisasiꞋe, Yuta vayaꞋmogami sauve kanoa ma maine.” huno kae-malene. ");
INSERT INTO kmu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kae-malenegeꞋya YisasiꞋma yafaga yosale asai-malenaya kaiyaga ala kumaꞋmo aupaꞋale haeꞋya asai-malayanagiꞋya mukiꞋa Yuta veaꞋmoꞋya ani avona hapaliꞋya havimainae. PailatiꞋa tagufa (3) kefiti kae-malene. Yuta vayaꞋmogami kefitiꞋene Lomu vayaꞋmogami kefitiꞋene Kaliki vayaꞋmogami kefitiꞋene kae-malenegeꞋya hapaliꞋya havimainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Haviya yafe Yuta vayaꞋmogami mono note kava vayaꞋmoꞋya Pailatifena mage hae “Kagaya ‘Yuta vayaꞋmogamina ala sauve kanoꞋami ma maine.’ huka okaeka ma ke huka kao ‘Nagaya Yuta vayaꞋmogami ala sauve kanoꞋami mainoe hunoꞋma hia kanoa ma maine.’ huka kao.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hageno PailatiꞋa mage hie “Kae-malenoa kea hai kae-malenoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ati vayaꞋmoꞋya Yisasina yafaga yosale nili heꞋya asai-maleteꞋya kenaꞋa foꞋa (4) hetaꞋma vaiꞋya ali-mainae. AyaꞋaya siotaꞋaene aligahe agayana mukiꞋa analegati afetegama lavi-maineana aye ohati siota hane. ");
INSERT INTO kmu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ohati siota hanea yafe ani ati vayaꞋmoꞋya kea mohu mehu huꞋya mage hae “Hatata ohuta afaꞋa musufa yama nehaya yokaloa kasi nelesunageno tagasesimoꞋa alisie.” huꞋya amakaiꞋami hu-mainae. AniꞋama haya kavala Anumaya Koti kefima nayoma kae-malenaya kemoꞋa ago efalote huno tamage nehie. Anima nayoma kae-malenaya kemoꞋa mage humaineane “KenaꞋniꞋa fako huꞋya neꞋaliꞋya nago kenaꞋniꞋa kasi yokalo-leꞋya amakasesimoꞋa aligahie.” huꞋya kae-malenayane. Kae-malenayanagiꞋya ati vayaꞋmoya mani kavala hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","HageꞋya Yisasima asai-malenaya yafaga yosamo avatela Yisasina itaꞋamoꞋene nunaꞋamoꞋene he-ti-mainaꞋe. AnakaiꞋene Kalopasina aꞋamoꞋa MaliaꞋene hamoꞋamoꞋa Magatala kumate MaliaꞋene he-ti-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","He-ti-mainageno YisasiꞋa itaꞋamona ageteno agaiꞋenema tokaeꞋya nemaiya anagapiti hau ayamopafima hau-mainea kanomoꞋna, YoniꞋnae, itaꞋamo avate he-titaꞋa mainoꞋageno taꞋageteno itaꞋamofena “AꞋmogae namona kagaikaꞋa nafaꞋnekaꞋae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Huteno nagaifena “Namona itakamoꞋe.” huno higeꞋna nagaya ani yupa Maliana yagaigahe noniꞋalega avaleꞋna umainoe. ");
INSERT INTO kmu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ani kea huteno YisasiꞋa “MukiꞋa aliꞋyaꞋniꞋa ago aliꞋna haꞋno hue.” huno agesafinaga havimaine. Nayoma Anumaya Koti kema kae-malenaya kemoꞋa efalote huno tamagema hisia yafe mage hie “Life nenage.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","HigeꞋya nofi alagafiti falote hia tina nagola havate-mai keꞋayola aliꞋya havagoꞋyafa kana yana ani lipi ayeteꞋya kaꞋyote vaiꞋya ali-saga huꞋya Yisasina avayale malenae. ");
INSERT INTO kmu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Malageno YisasiꞋa mayu mayu huno neteno mage hie “Nenafagae naha-pai-mainana aliꞋyana ago aliꞋna haꞋno hue.” huno nehuno ageꞋya ainamagino agu nafaꞋneꞋamo atalegeno vigeno fali-maine. ");
INSERT INTO kmu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sapati yupahe talo tala hisaya yupagino ega ala Sapati kana falote hisia yafe Yuta vayaꞋmoꞋya anima yafaga yosaleꞋma hamae-malaya vayaꞋmogami amaugafamoꞋma SapatileꞋma yafaga yosale hanesia yafena ohamaigeꞋya Pailatife mage huꞋya mo havigae “Ati vayaꞋmoꞋya amaiya ali kofa hisageꞋya aupaꞋa falisageꞋya hipoꞋya huꞋya aliꞋya visae.” huꞋya mo havigae. ");
INSERT INTO kmu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hageno PailatiꞋa ati vaya hama-paigeꞋya mogayana YisasiꞋenema yafaga yosale asai-malaya kanolatamogani anaiya meli kofa hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ali kofa huteꞋya Yisasina megayana ago fali-mainegeꞋya megeteꞋya aiya ali kofa ohunae. ");
INSERT INTO kmu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ali kofa ohageno nago ati kanomoꞋa keveꞋaleti Yisasina haohipafi meyegeno aupaꞋa ani keve kapitila kolamoꞋene timoꞋene taki-lavi-maine. ");
INSERT INTO kmu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Taki-lavigenoꞋma age-mainea kanomoꞋa tamaha-nepaiye. Tamaha-nepaiya kea tamageꞋage ke hanea yafe agaiꞋa havilama hu-lineno tamaha-nepaiyafe tamakayaenena Yisasifena havitama tamakupi maletama tamametiti hisaya yafe tamageꞋage ke tamaha-nepaiye. ");
INSERT INTO kmu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Nayona Anumaya Koti kema kae-malenaya kemoꞋa mage hu-maineane “Amakaya nago ayamufaꞋa ali kofa ohugahae.” huꞋya kae-malenayane. Nagi nagola Anumaya Koti kema kae-malenaya kemoꞋa mage huno hu-maineane “Haohipafina keveletiꞋma aye-mainea kanomona agegahae.” huꞋya kae-malenayane. Kae-malenaya kemoꞋa falote huno tamagema hia yafe mani kavala hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","YosefeꞋa Alimatiyae huꞋya nehaya kumate nemaiya kanogino Yisasi ke havino akave nemalea kanogi Yuta vayafe koli huno Yisasifema ametiti nehia yana fala-ki-lineno mage huno Pailatina mo havige “Yisasina augafaꞋa aligahe nehue.” huno mo havige. Havigegeno PailatiꞋa “E.” huno higeno YosefeꞋa viaꞋyamo Yisasina augafaꞋa mo hipoꞋya huno alino emaine. ");
INSERT INTO kmu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","NikotimasiꞋa hagoteno Yisasite hanipinaga emainea kanomoꞋa Yosefena mo ha-maegahe kule fuki kana manaꞋage tina tole yosafiti he-fino ali havigu higeno manaꞋage tina falote higeno sigelile mo malegeno tetiꞋa (30) kilo falote higeno alino emaine. Ani tole yosalatamogani anakia meaꞋene aloꞋene alino emaine ");
INSERT INTO kmu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ani tole kanolatamogania vaꞋaꞋyamogani Yisasina augafaꞋa mo hipoꞋya huꞋana mopale maleneꞋana manaꞋage tina fale-teteꞋana kefe kana kenaleti augafalela ai-galaki galaki huꞋana haꞋya kiteꞋana aye-gasagi-malenaꞋe. MukiꞋa yupa Yuta vayaꞋmoꞋya vayaꞋamima faligeꞋya aniꞋa huꞋya neꞋamataya kava hu-tenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ani kaiyaga Yisasina yafaga yosale nilima heꞋya asai-malenaya kaiyaga nago hoya hane. Ani hoyafina nagola vayaꞋma he-vai-ma-tesaya yafa kana, yaufa kafi-malenayane. Anifina nago vayala he-vai-oꞋama-tenaya yafa kapi aliꞋya mo he-vai-tenae. ");
INSERT INTO kmu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ani yupa Sapatihe haviꞋya talo tala hisaya kanafinagiꞋana ani matimatila aupateꞋma hanea yafe ani tole kanolatamogania Yisasina augafaꞋa aliꞋana anifi mo malenaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sota yupa kola otinegeno Magatala kumate MaliaꞋa natemaꞋa Yisasina he-vai-tenaya komulega umaine. Uno mogeana komumo avayaleꞋma aiso hu-malenaya yafana ago alike-li-talenageno avayalela omalegeno moge-maine. ");
INSERT INTO kmu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mogeteno eteno aiya-yeno YisasiꞋma nehaiya kanoene Saimoni PitaꞋene mainaꞋale eno mage huno hana-paiye “Alatimona komufitila ago aliꞋya hanatepi atenae.” huno hana-paiye. ");
INSERT INTO kmu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hana-paigeꞋana haviteꞋana PitaꞋene YisasiꞋma nehaiya kanoene Yisasi komulega umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anaiya-yeꞋana ani komulega vaꞋaleti YisasiꞋma nehaiya kanomoꞋa Pitana agaseno aupaꞋa komule hagoteno umaine. ");
INSERT INTO kmu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uteno mope hu-maineno ageana Yisasina aye-gasagi-tenaya kenaꞋage hanegeno ageanagi anifinaga hai-ofalene. ");
INSERT INTO kmu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Hai-ofaleno mainegeno Saimoni PitaꞋa akave eaꞋyamo ani komufinaga aupaꞋa hai-fale-maine. Haino mogeana nagoꞋa aye-gasagi-tenaya kena neꞋageno anuteꞋma ki-tenaya kenaene Yisasina augafaleꞋma aye-gasagi-tenaya kenaene nagopi tokaeno omalenegi aote kaiyaga aye-gafage-kino malenegeno haino moge-maine. ");
INSERT INTO kmu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","NeꞋagegeno YisasiꞋma nehaiya kanomoꞋa komuleꞋma hagoteno umainea kanoa anifinaga hai-faleno mo neꞋageno komufitiꞋma he-ti-mainea yafe “Tamage nehie.” huno havino agupi maleno ametiti nehie. ");
INSERT INTO kmu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ani kanafina mukiꞋa anagaꞋamoꞋya Anumaya Koti kema kae-malenaya kea havilama ohunae. Ani kemoꞋa mage huno hu-maine “YisasiꞋa fali-mainesifiti he-tigahie.” huꞋya kae-malenaya kemona havilama ohunae. ");
INSERT INTO kmu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Anakaya YisasiꞋenema tokaeꞋana nemaiꞋa kanolatana anifinagati hati-laviꞋana noꞋanilega eteꞋana umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","MaliaꞋa ani yafakamo avayale he-tino maineno avi neꞋateno ape huno ani komufinaga aulu heno neꞋage. ");
INSERT INTO kmu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ageana tole ensole kanolatana efeꞋage kenaꞋani failiꞋana Yisasi augafama malenaya yate mopale mainaꞋe. Nago kanoa anuma malenalega maigeno nago kanoa aiyama malenalega maigeno hu-mainaꞋageno anake-maine. ");
INSERT INTO kmu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","NeꞋanakegeꞋana Maliafe mage haꞋe “AꞋmogae naꞋa higeka avia neꞋatane?” huꞋana havigaꞋageno MaliaꞋa mage huno hie “AlaniꞋamona aliꞋyama mo malaya kumala oꞋagenoa yafe avi neꞋatoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nehuno mai-yahae huno ageana YisasiꞋa he-ti-mainegeno ageanagi augosafina agelama ohune. ");
INSERT INTO kmu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Agelama ohigeno YisasiꞋa mage hie “AꞋmogae naꞋa higeka avia neꞋatane? Tafe ati neꞋayane?” huno havigegeno MaliaꞋa agesafinaga mage huno hie “Ma kanoa hoyaleꞋma yagai-mainea kano maine.” huno agesafinaga nehavino mage huno hie “MusekaꞋa nehugi kagayama alika umainenukahena malenesana kumafena naha-paigeꞋna molino.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Higeno YisasiꞋa mage huno hie “Maliao.” huno higeno ani aꞋmoꞋa maiyahae huno Yuta vayaꞋmogami kefiti mage huno hie “Laponae.” huno hie. Ani kemoꞋa takai kefina “Hu-lave-nelina kanomogae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Higeno YisasiꞋa mage hie “Nenafa mainelega ohainogi natafa ohuka naganaꞋnimogamina mage huka mo hama-paiyo ‘NagaiꞋene tamakaiꞋene Nelafatega haigahe nehue. Nagai Anumaya Kotitegaene tamakai Anumaya Kotitegaene haigahe nehue.’ huꞋka mo hama-paiyo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Higeno Magatala MaliaꞋa viaꞋyamo YisasiꞋenema tokaeꞋya nemaiya anagaꞋamogamina mage huno hama-paiye “Nagaya AlaniꞋamona ago agoe.” huno nehuno “Nage mage huka hama-paiyo.” hunoꞋma hapaiya kea hama-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","YisasiꞋa fali-mainefitiꞋma he-ti-mainea Sotamona hanipinaga Yisasina aleveniꞋa (11) anagaꞋamoꞋya Yuta vayafena koliꞋami huꞋya fita kiꞋya tokiyaꞋage hu-maleteꞋya nopinaga alitalu huꞋya mainae. Mainageno YisasiꞋa evaꞋyi huno amuꞋnoꞋamifi me he-ti-maineno mage hie “TamaipamoꞋa falu nehinagetama maiho.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hama-paiteno akaiꞋma ayapima nilima he-malenaya afuguꞋene haopafina kevema aye-mainaya afuguꞋene amave-neliye. Amave-ligeꞋya aleveniꞋa (11) anagaꞋamoꞋya AlaꞋamimona ageteꞋya amakuꞋamoꞋa tusiꞋa muse hia kava hae. ");
INSERT INTO kmu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hageno YisasiꞋa nagoꞋene mage hie “TamaipamoꞋa falu nehinagetama maiho. NenafaꞋa hu-na-tenea augafa kava huꞋna nagaya tamakaila hu-nela-matoe.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mani kema nehunoꞋa haimula fu huno neꞋamamino mage huno hie “Tamakaila Alu Aotage Avamula nelamamugi avaleho. ");
INSERT INTO kmu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","NagoꞋa veaꞋmogamina ai-geꞋama-tetama kefo yaꞋamima atale-ma-tesayana Anumaya KotiꞋa aniꞋa huno ani kefo yaꞋamia ai-geꞋama-teno atale-ma-tegahie. Kefo yaꞋamima ai-geꞋama-tetama atale oꞋamatesaya veaꞋmogamina Anumaya KotiꞋa kefo yaꞋamia ai-geꞋama-teno atale oꞋama-tegahie.” huno hama-paiye. ");
INSERT INTO kmu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","YisasiꞋma amakaite evaꞋyima hu-mainea yupa aleveniꞋa (11) anagaꞋafitila nago kanoa amakaiꞋenena omaine. Ani kanoa, TomasiꞋe, nago agia TitimasiꞋe, tagai kefina kuyave nafaꞋne, ani kanoa omaine. ");
INSERT INTO kmu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","OmainegeꞋya amakaya “Tagaya Alatimona age-mainone.” huꞋya hane-paigenoꞋa TomasiꞋa mage hie “Yisasina nilima he-malenaya afuguꞋma oꞋageꞋna, naginagoma nilimo kapima omaleꞋna haopafima keve honomuꞋma aye-malenaya afugupima nayama oꞋvainuꞋnahena mani kea aliꞋna nagupina maleꞋna nametitia ohugahue.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","SeveniꞋa (7) kana maiteꞋya Yisasina aleveniꞋa (11) anagaꞋamoꞋya eteꞋya ani nopi mainageno TomasiꞋa amakaiꞋene maine. Fita kiꞋya tokiyaꞋage hu-malayanagi YisasiꞋa evaꞋyi huno amuꞋnoꞋamifi me he-ti-maineno mage hie “TamaipamoꞋa falu nehinagetama maiho.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasifena mage hie “Kaginagoa male me maleka nayapi nafugula ago. Kayana nahaopaleꞋma hanea nafugupina vaika ago. Ageteka tole kagesama havina kagesa neꞋataleka nagaifena havika kagupi maleka kametiti huo.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Higeno TomasiꞋa mage hie “Kagaya AlaniꞋamogae Anumaya KotiꞋnimoga mainane.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Higeno YisasiꞋa mage hie “Kagaya agoꞋma nagana yafe kagupina maleka kametitia nehananagi onagenesaya veaꞋnemoꞋyama haviꞋya amakupi maleꞋya amametitima hisaya veaꞋmoꞋya tusiꞋa muse hugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","YisasiꞋa aleveniꞋa (11) anagaꞋamogami amaulagafina aluꞋa aluꞋa tokiya avameꞋyaꞋyaga hu-maineanagi ani yana mukiꞋa mani autaꞋmafina okaenoe. ");
INSERT INTO kmu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Okaenoanagi manima kae-maloa kea tamakaife huno YisasiꞋa, Anumaya Kotina nafaꞋneꞋamoꞋa, tagu tamema ali-gatisia kano maine hutamama havitama tamakupi maletama tamametitima hisaya yafe kae-malenoane. Ani yafe havitama tamakupi maletama tamametiti hisayana Yisasi agileti agola maige maige hisaya tamahaimula aligahae huꞋna kae-malenoe. ");
INSERT INTO kmu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","HaenagaꞋa YisasiꞋa eteno agaiꞋenema tokaeꞋya nemaiya anagaꞋamogami amaule ma kava huno Taipiliasi tikotumo agegayalega evaꞋyi hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni PitaꞋene, Tomasina nago agia TitimasiꞋe, tagai kefina kuyave nafaꞋne, NatanioloꞋa, Kalili hanea kumala Kena kumate kanoene, tole Sepeti nafaꞋnelataꞋa YoniꞋene, aganaꞋamoꞋene, tole Yisasina aleveniꞋa (11) anagaꞋaene mainae. ");
INSERT INTO kmu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mainageno Saimoni PitaꞋa mage huno hama-pai-maine “Nagaya noyame kuꞋya hugahe neꞋue.” huno higeꞋya mage hae “KagaiꞋene ugahune.” huꞋya hapaiteꞋya tipi kalefi hai-saga humaiꞋya ani kegela vayanagi nagoke noyamea oꞋalinae. ");
INSERT INTO kmu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","OꞋaligeno yagea hai vaꞋyi hugahe nehigeno YisasiꞋa ti agegayalega he-ti-maiyanagi agaiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya YisasiꞋe huꞋya agelama ohunae. ");
INSERT INTO kmu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Agelama ohageno YisasiꞋa mage huno hama-vige “Vae nafaꞋneꞋnimogatama nagoꞋa noyamea neꞋalifi noꞋaliye?” huno hamavi-gegeꞋya “AꞋao noꞋalune.” huꞋya hapai-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hapaigeno YisasiꞋa mage huno hama-paiye “Tamakaya kukonagona tipi kalemona tamaga kaiyagamo haikanagati hagaꞋyu hutama malesayana noyamea aligahae.” huno hama-paigeꞋya kukonagona aniꞋa huꞋya hagaꞋyu hayana tusiꞋa noyame aligeno kanaꞋage higeꞋya alisaga hisaya yafena tusiꞋa ya hu-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","YisasiꞋenema tokaeꞋya nemaiya anagapiti nehaiya kanoꞋamoꞋa Pitana mage huno hapaiye “Agaya AlatimoꞋe.” huno hapaiye. Hapaigeno Saimoni PitaꞋa anima hia kea nehavino aupaꞋa augafale anoꞋya asagi-taleno aliꞋyana neꞋalileti eteno aupaꞋa alino vai-lino tipina asaga hu-lavino Yisasitega neꞋvie. ");
INSERT INTO kmu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","VigeꞋya ani tipi kalea aluꞋalelomagi vani hataleti (100) mita aupaꞋale maineꞋya nagoꞋa YisasiꞋenema tokaeꞋya nemaiya anagaꞋamoꞋya kukonagona avayu huꞋya ti agegayalega emainae. ");
INSERT INTO kmu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ti agegayalega me maleteꞋya agayana ata nelegeno nago noyamene hame mayaene ani atafina hanegeꞋya age-mainae. ");
INSERT INTO kmu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","NeꞋagageno YisasiꞋa mage huno hama-paiye “Menima aliya noyamefitila nagoꞋa alitama eho.” huno hama-pai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hama-paigeno Saimoni PitaꞋa tipi kalefi hai-saga hu-maino kukonagona avayu huno ti agegayalegama eana kasagoꞋya noyame, vani hataleti fifiti taliꞋa (153) noyameyaga ani kukonagopina hiya hu-maiyanagi ani kukonagomoꞋa ailagatoa ohune. ");
INSERT INTO kmu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","YisasiꞋa mage huno hama-paiye “Tamakaya etama kavela me neho.” huno hama-paigeꞋya agaiꞋenema tokaeꞋya nemaiya anaga amamaꞋyoma aiya yafe “Kagaya lagae.” huꞋya haviokenagi “Alatimo maine.” huꞋyama amakesafinaga haviya yafe haviokenae. ");
INSERT INTO kmu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","YisasiꞋa atale eaꞋyamo hame mayaene noyamene melino amamine. ");
INSERT INTO kmu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yisasina komufima he-vai-tageno etenoꞋma he-ti-maineana tole yupa age-mainaleti eteno mani kavaꞋma hiana napa tali (3) kanale evaꞋyi higeꞋya agaiꞋenema tokaeꞋya nemaiya anagaꞋamogata taulagafiti age-mainone. ");
INSERT INTO kmu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kavela netageno YisasiꞋa Saimoni Pitana mage huno havige “Saimonigae Yoni nafaꞋnemoga kagaya ma vayala amakaseka nagoꞋene kaguꞋa nenamino?” huno havige. Havigegeno PitaꞋa mage huno hie “E, AlaniꞋamogae kagaya ago nehavine kagaifena nenahaiye.” huno higeno YisasiꞋa mage huno hapaiye “Kagaya nagai sipi sipi nafaꞋneyaga kavela amamio.” huno hapai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hanepaino nagoꞋene mage huno hie “Saimonigae Yoni nafaꞋnemoga kaguꞋa havika ago nenamino?” huno havigegeno PitaꞋa mage huno hapaiye “Kagaya ago nehavine nagaya kagaifena nenahaiye.” huno higeno YisasiꞋa mage huno hapaiye “Kagaya sipi sipiyagaꞋnilela kava yagaiyo.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hapaiteno nagoꞋene napa tali (3) kanale mage huno havige “Saimonigae Yoni nafaꞋnemoga nagaifena negahaiyo?” huno higeno napa tali (3) kanaleꞋma “Kagaya nagaifena negahaiyo?” hunoꞋma havigea yafe Pita aipamoꞋa kanaꞋage higeno mage huno hie “AlaniꞋamogae mukiꞋa yana ago havi-mainane. Nagaya kagaifema nenahaiya yafena ago nehavine.” huno hapaigeno YisasiꞋa mage huno hie “Kagaya sipi sipiyagaꞋnia kavela amamio.” huno hapai-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Hapaiteno mage hie “Tamage-lafa huꞋna kaha-pauve kagaya neyama maineka kamu nofila ki-takalo hu-maleteka ‘Visue.’ hukama hana kumatela neꞋvananagi haenagaꞋa kosunama lesanana kayana alisaga hu-linesanageꞋya nagoꞋa vayaꞋmoꞋya kenaka fai-ga-teteꞋya ‘OꞋugahuema.’ hukama nehisana kumatela afaꞋa kavaleꞋya ugahae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Anima hia kemona aepaꞋamoꞋa mage huno hu-maine “HaenagaꞋa kefo vayaꞋmoꞋya katafa huꞋya kahaesagekama falisana yateti Anumaya Kotina ala agi amigane.” huno aepaꞋa huteno YisasiꞋa Pitafena “Nakave eno.” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","YisasiꞋene tokaeꞋya nemaiya anagapiti hau ayamopafima hau-mainea kanoa kaveꞋma ne-mainaya yupa Yisasina avaꞋale maineno mage huno havige-maineane “AlaniꞋamogae kagaila kagesiꞋma huno kamema hu-ga-tesia kanoa hana kanomoꞋe?” huno havigea kanomoꞋa YisasiꞋene Pitagani anakave neꞋvigeno PitaꞋa maiyahae huno age-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ageteno PitaꞋa Yisasina mage huno havige “AlaniꞋamogae ani kanoa haenagaꞋa hana augafa kava hugahie?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Havigegeno YisasiꞋa mage huno hapaiye “NakaiꞋma nahaisigeꞋnama ma mopafima eteꞋna esua yupa afaꞋa mainesigeꞋnama esuana kagai yano? Kagaya nakave eno.” huno hapaiye. ");
INSERT INTO kmu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hapaiya kemoꞋa anagaꞋamogamipina mani kema hia kemoꞋa ute ete higeꞋya mage hae “YoniꞋa ofaligahie.” huꞋya hayanagi YisasiꞋa “Ofaligahie.” huno hu-oꞋa-tenegi “NagaiꞋma nahaisigeꞋna ma mopafima eteꞋna esua yupa afaꞋa mainesigeꞋnama esuana kagai yano?” huno hu-maine. ");
INSERT INTO kmu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ani kema hayana Yoninihe hu-maine. Nagaya mukiꞋa YisasiꞋma hu-mainea kavafena tamaha-nepaiꞋna avona kae-malenoe. Nagayama nehua kea tamage-lafa huꞋna havilinoa ke tamaha-nepauve. ");
INSERT INTO kmu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","YisasiꞋa mukiꞋa alu ya alu yana hu-maineanagi nagoꞋa vayaꞋmoꞋya mani kema mukiꞋa nagoke nagoke avopima kayaleꞋasina mani avoꞋyagamoꞋa kasago higeꞋya malesaya kumaꞋmoꞋa mukiꞋa ma kotega nagesa havuana hiya hileꞋasine huꞋna nehue. ");
INSERT INTO kmu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofilasigae hagoteꞋna kaemalenoa autaꞋmafina YisasiꞋma aepa heno ali-mainea aliꞋyaꞋene humaveli-mainea kene Anumaya Kotina Alu Aotage AvamuꞋmo tokiyaleti “NaꞋa maꞋa kava hiho.” huno Aposolo vayala* (agai kema nehavigeno humatenea vayala)* hamapaiteno ikapinaga haimainea yafeꞋene ago kaeꞋna kahapai-mainoe. ");
INSERT INTO kmu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","YisasiꞋa tusiꞋa augafa agataiya alino faliteno hetino Aposolo vayaꞋmogami amaulagale efalote huno fali-mainefitiꞋma hetino mainea yafena havise huno kasagoꞋya tokiya kavaꞋage humaine. FotiꞋa (40) yupa mopafina maineno efalote huno amaveliteno amataleno uteno eteno efalote huno Anumaya KotiꞋma kava yagaisia yafena hamapai-maine. ");
INSERT INTO kmu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","AmakaiꞋenema mainea kanafina mage huno hamapai-maine “Tamakaya Yelusalemu kumala ataletama oꞋviho. NenafaꞋma ‘Nago kanoa tamamigahue.’ hunoꞋma humainea kanoa avaletetama viho. Nagaya ani kanohena ago tamahapai-mainoane. YoniꞋa titeti falelamateneanagi tamakaya aupa kana kanoꞋa maisayana Nenafana Alu Aotage AvamuꞋamoteti falelamategahie.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ani yupa Aposolo anagaꞋmoꞋya alitalu huꞋya maineꞋya Yisasifena mage huꞋya havinegae “Alatimogae menia ma kanafina Lomu kamani vayaꞋmogami amayapitila Isaleli vayaꞋmogati hafaleka kagaikaꞋa kava yagailatesanageno tokiyaꞋage hisifi?” huꞋya havinegae. ");
INSERT INTO kmu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Havigageno YisasiꞋa mage huno hie “NenafaꞋa agaiꞋa tokiyaleti ‘Ma kanaene mukiꞋa kanafiꞋene maꞋa kava hugahue.’ huno huteno yagai-mainegi agayama hisia yana tamakaya havisaya yana omalene. ");
INSERT INTO kmu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Omalenegi Anumaya Kotina Alu Aotage AvamuꞋamoꞋma tamakaiteꞋma esiana tokiyaꞋa tamamisigetama nagai kea Yelusalemuene mukiꞋa Yutia kotegaene Samelia kotegaene mukiꞋa ma mopamo atupale mainaya veaꞋnenena nagaifena hamapaigahae.” huno humaine. YisasiꞋa ikapinaga haimaine. ");
INSERT INTO kmu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mani kea huno haꞋno huteno ageꞋya mainageno mopaleti haino haino haigeno nako siaꞋmoꞋa melino aiso hulino avaleno haimaine. ");
INSERT INTO kmu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","HaigeꞋya amakaya ikapinaga agesaga huꞋya ageꞋya maiya anayufi tole kanolatana efeꞋage kena failiꞋana efalote huꞋana amakaiꞋene anile heti-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","HetiꞋana mage huꞋana haꞋe “Kalili kumate veaꞋmogatama naꞋa higetama heti-mainetama ikatela aulula maitama nehae? YisasiꞋa tamataleno ikapinaga ago haiyanagi manima ikapinaga haiya avamete huno eteno elavisigetama agegahae.” huꞋana hamapai-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Amakaya Olivi yosa hanea agoꞋyaleti taviteꞋya aupaꞋale lagiꞋya vani kilomita vayaꞋamoꞋya Yelusalemua uvaꞋyi humainae. ");
INSERT INTO kmu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","UvaꞋyi huteꞋya nemaiya nona folamo huꞋya ana yapi kimale nopi haiꞋya mainae. HaiꞋya mainaya vayaꞋmogami amakia PitaꞋe YoniꞋe YemesiꞋe EtaluꞋe FilipiꞋe TomasiꞋe PatolomiuꞋe MatiuꞋe Alafiusi nafaꞋnea YemesiꞋe SaimoniꞋe kanomona nako agia SelotiꞋe YutasiꞋa Yemesi nafaꞋnene haiꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ani vayaꞋene aꞋneyagaene MaliaꞋa Yisasina itaꞋamoꞋene Yisasina aganaꞋamoꞋyaene nagoke amaku amakesale maineꞋya mukiꞋa yupa Anumayamotega muse huꞋya nunamu humainae. ");
INSERT INTO kmu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ani kanafina Yisasifema haviꞋya amakupi maleꞋya amametiti humainaya veala, vani hataleti tuetiꞋa (120) veaꞋne, mainageno PitaꞋa amakai amuꞋnopi heti-maineno mage huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“NafuꞋnaganagatama Anumaya Kotina Alu Aotage AvamuꞋamoꞋa Teviti avayafiti hufalote huno nayona Yutasife humaine. Yisasima atafa hisaya kama amavelisia kanohe, aune laga humaine. Ani kemoꞋa ago falote huno tamage humaine. ");
INSERT INTO kmu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ani kanoa, YutasiꞋe, YisasiꞋenema tokaeta nemauna anagapi maineno Yisasi kea nehavigeno aliꞋyatela hutenea kano maine. ");
INSERT INTO kmu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ani kanoa, YutasiꞋe, kefo yama hia yamo anonaꞋa mone aliteno mopa miya humaleteno ani mopafi agoꞋya faigeno aipamoꞋa aitalaga higeno mukiꞋa aipamoꞋa helafi lavi-maine. ");
INSERT INTO kmu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Helafi lavigeꞋya mukiꞋa Yelusalemuma mainaya veaꞋmoꞋya ani kea haviteꞋya ani mopamo agia amakaiꞋami kefina ‘Akelatama.’ huꞋya humainae. Tagai kefina ani agia ‘Kolama lavi-mainea kumale.’ huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","TevitiꞋma yagamema humainea autaꞋmafina, Samupina, mage huno kae-maleneane ‘AgaiꞋama nemaiya kumala vaya omaino yu kuma hapaesie.’ huno kae-maleneane. Ani kemoꞋa nago kaiyaga mage huno humaineane ‘Alu kanomoꞋa agai aliꞋyatela alisie.’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ani yafe nago kanomoꞋma YoniꞋa tima falematenea kanaleti aepa heno Anumayatia YisasiꞋene tagaiꞋenema vaiyatete huno huno egenoꞋma YisasiꞋa ikapinaga haimainea yupa tagaiꞋenema nemaiya vayapiti nago kanoa YisasiꞋma fali-mainefitiꞋma heti-mainea kema hamapaisiafe ani aliꞋyatela alita hetitesune.” huno PitaꞋa humaine. ");
INSERT INTO kmu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","HigeꞋya amakaya tole kanolafe “Anakayae.” huꞋya hageꞋana nago kanoa, Yosefe PasapasiꞋe kanomona, nago agia YasatusiꞋe, nago kanoa MatiasiꞋe huꞋya anakia ayemainae. ");
INSERT INTO kmu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","AyeteꞋya Anumayamotega mage huꞋya havinegae “Anumayamoga kagaya mukiꞋa vayaꞋmogami amakuꞋafina ago age-mainane. YutasiꞋma haiya kavaꞋma huteno tataleno havi kapi umainea yafe anonaꞋale alu kanomoꞋa hetino Aposolo kano maisie huta nehune. Kagaya ani kanolatapitila hana kano ago hapalika huneꞋatane? HuneꞋatana kanoa tavelio.” huꞋya havinegae. ");
INSERT INTO kmu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nunamuna huteꞋya anakia aote yate kaeteꞋya yopafi maleneꞋya nagoke avayu huꞋya agayana Matiasi agi avayu huteꞋya ani kanoa avaleꞋya hetitageno Aposolo vayapi maine. ");
INSERT INTO kmu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","YisasiꞋa ago falitegeꞋya seveniꞋa (7) sota maiteꞋya vitimo afulea kanahe muse haya imu kiya kanafina mukiꞋa Yisasi veala nago nopi alitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mainageno aupaꞋa ikapinagati ala age neꞋaino ala yasimoꞋma huhu huhu nehia kava huno age neꞋaino anima mainaya nopina me hiya humaine. ");
INSERT INTO kmu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hiya higeꞋya agayana atamo anefe kana yamoꞋa hamaote hamaote amaugafale mo kaꞋmaemaine. ");
INSERT INTO kmu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mo kaꞋmae-mainegeno Alu Aotage AvamuꞋmoꞋa eno mukiꞋamogami amakupina me hiya higeꞋya amakaya aepa heꞋya Alu Aotage AvamuꞋmo hamapaigeꞋya amaku amakesafiti nohaviya kea alu ke alu ke humainae. ");
INSERT INTO kmu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","NehageꞋya ani yupa kasagoꞋya Anumaya Koti kema nehaviya Yuta vayaꞋyaga mukiꞋa kotegati eꞋya Yelusalemu melitalu humainae. ");
INSERT INTO kmu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ani vayaꞋmoꞋya ikapinagatiꞋma ala agegefa aigeꞋya haviteꞋya melitalu huꞋya haviyana ani nopima mainaya veaꞋmoꞋya alu ke alu ke maiꞋya nehageꞋya alu kotegatiꞋma emainaya veaꞋmoꞋya mage hae “Nagai ke nehie. Nagai ke nehie.” huꞋya tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","AmamaꞋyo neꞋaiꞋya amakesa havi havi huꞋya mage hae “Mani kema nehaya vayaꞋmoꞋya Kalili vaya mainayanagi hanaꞋa huꞋya tagaiti itatimoꞋya nelafaꞋya nehageta nehavuna kefitila hageta nehavune. ");
INSERT INTO kmu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Tagaya ma kumaꞋyagaleti emainone PatiaꞋene MitiaꞋene Elamiene MesopotemiaꞋene YutiaꞋene Kapatosiene Potusiene EsiaꞋene FiligiaꞋene PamafiliaꞋene Isipiene Sailinia aupaꞋale Lipia kotegatiꞋene Lomuene Kalitiene AlepiaꞋene naꞋa kotegati emainonagi Yuta vayaꞋene Yuta vayaꞋmogami Anumaya KotiꞋamimo ke havilinaya vayaꞋene emainonagi tahaote tahaote ketifiti Anumaya Koti tokiyaleti humainea kavafe tahapai-mainae.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","13","HageꞋya mukiꞋa veaꞋmoꞋya tusiꞋa amamaꞋyo neꞋaiꞋya tusiꞋa amakesa nehaviꞋya nagoꞋa veaꞋmoꞋya mage huꞋya hae “Ani kavaꞋmona aepaꞋa naꞋane?” huꞋya hayanagi nagoꞋa veaꞋmoꞋya havigu ke nehuꞋya mage hae “Amakaya havilina vaini nofi alagamo timaꞋa neteꞋya aneginagi nehae.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","PitaꞋa aleveniꞋa (11) Aposolo vayaꞋene heti-maineno ala kefiti mage huno humaine Yuta nafuꞋnaganagatamaene Yelusalemuma mainaya veaꞋnene nago ke tamahapaigahugi haviho. ");
INSERT INTO kmu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tamakaya tamakesa haviyana mani veaꞋmoꞋya havilina vaini li neꞋya aneginagi nehae hutama nehafi? AꞋao menia natekefa naeni kiloki nehigi havilina onenae. ");
INSERT INTO kmu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Onenagi menima agaya yafena nayona Anumaya Koti aune kanomoꞋa YoeliꞋma humainea kemoꞋa mage huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Anumaya KotiꞋa mage huno humaine “Mani kanamoꞋa aupaꞋama haꞋno hugahema hisia kanafina nagaya Alu Aotage AvamuꞋnimona mukiꞋa veaꞋnemogamina amamigahue. AmamisugeꞋya tamakai nafaꞋnemoꞋene munaꞋnemoꞋene Anumayamo avayafiti hamapai-mainea kea hisageꞋya neyaꞋvetamimoꞋya himona kana yaꞋyaga feluga neꞋagesageꞋya kosunatamimoꞋya himona agegahae. ");
INSERT INTO kmu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","He, nagaya Alu Aotage Avamula aliꞋya veaꞋnimogamina vene aꞋnene amamisugeꞋya Anumayamo avayafitiꞋma hamapai-mainea kea tamahapaigahae. ");
INSERT INTO kmu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nagaya ikateꞋene ma mopafiꞋene tokiya avameꞋyama hisua yana kolaꞋene ataene halinaene tamaveligahue. ");
INSERT INTO kmu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tamavelitesugeno yagemoꞋa ayesu hinageno ikaꞋmoꞋa kolamaꞋage hisigeno AnumayamoꞋma esia kanafina tusiꞋa tokiyaꞋaene hale yamaꞋaene efalote hugahie. ");
INSERT INTO kmu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","EfaloteꞋma hinageꞋya mukiꞋa veaꞋmoꞋya Anumayamo agi neꞋayeꞋya ‘Kalagi ailato.’ huꞋya nehisageno Anumaya KotiꞋa amaku amamena aligatigahie.” huno kae-maleneane. ");
INSERT INTO kmu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isaleli vayaꞋmogatama nago kea tamahapaigahugi haviho “Nasaleti YisasiꞋe, Anumaya Kotitegati emainea kano maine.” hutama havisaya yafe Anumaya KotiꞋa aya higeno tusiꞋa tokiya avame yana tamakaipina ago ali falote higetama age-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Agayanagi Anumaya KotiꞋa nayona havino “NaꞋa maꞋa hugahue.” huno haꞋya kimaleteno tamayapi ategetama Anumaya KotiꞋa hutenea kava hutama ani kanoa, Yisasina, kefo vayaꞋene yafaga yosalela nilia hetama asaitetama hayageno fali-maine. ");
INSERT INTO kmu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Falimaineanagi falimainea yamoꞋa atafa huno atakalo ohune. Anumaya KotiꞋa anima agata yama alino falimainea yapitila kalu heno ali hetitene. ");
INSERT INTO kmu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nayona TevitiꞋa YisasiꞋma falimainesifitiꞋma alino heti-tesia yafena mage huno humaineane “MukiꞋa kanafina AnumayaniꞋamoꞋa nagaiꞋene maineno tamaga nayategama mainea yafena kolia ohugahue. ");
INSERT INTO kmu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","NagaiꞋenema nemaiya yafena nagu nafaꞋnemoꞋa tusiꞋa muse nehigeꞋna agia alisaga nehue. Yoka faliteꞋna hetigahue huꞋna nametitia nehue. ");
INSERT INTO kmu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Anumaya Kotigae ‘Alu aotage kanoe.’ huka hunatenana kanomonia naugafa kasalisia yafe fali-mainaya veaꞋne mainaya kumatela natalesanageꞋna oꞋvisua yafe nametitia nehue. ");
INSERT INTO kmu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kagaya agola maige maige hisua kana ago navelinageꞋna age-mainoafe kagaiꞋenema maisua yafena aluya huꞋna musena hugahue.” Teviti mani kea humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","PitaꞋa nagoꞋene mage hie “Nenafugatama hufalote huꞋna tamahapaisue taginagomoꞋa TevitiꞋa ago faligeꞋya hevaitenae. Hevaitenaya komua tagai amuꞋnopi hanegi akaiꞋahe mani kea ohuneane. ");
INSERT INTO kmu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Ohunegi Anumaya KotiꞋa agaife mage huno hulokiya vaino kea humaineane ‘Kagai kaginagomopiti nago kanomoꞋa hetino eteno kagai kumate veaꞋnea kava yagaimategahie.’ huno humaineane. Humaineanagi TevitiꞋa Anumaya Koti aune kano maineanagino KalaisiꞋa, Anumaya KotiꞋma taugafa aligatigahe hutenea kanoa, fali-mainefiti hetigahie huno aune laga huno mage huno humaine. Kalaisife ‘AugafaꞋa kasalisia yafe fali-mainaya veaꞋne nemaiya kumatela oꞋategane.’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ani kanoa, Yisasina, Anumaya KotiꞋa fali-mainefiti eteno ago alino hetitegeta age-mainona yafe tamahanepaune. ");
INSERT INTO kmu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anumaya KotiꞋa ali hetiteno avalesaga huno agaiꞋa tamaga aya kaiyagaꞋa uhagote mainaya vaya mainalega ateteno ‘Tamamigahue.’ hunoꞋma humainea kanoa, Alu Aotage AvamuꞋa, amigeno aliteno YisasiꞋa ani Alu Aotage Avamula eteno lamigeta mani kavala hunagetama neꞋagae. ");
INSERT INTO kmu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","TevitiꞋa mage huno humaineane Anumaya KotiꞋa AnumayaniꞋamofena mage huno humaine ‘Tamaga nayatega uhagote mainaya vaya mainalega mopale emainesanageꞋna kame vayakaꞋa kaiyafi amatesugeꞋya ani kame vayaꞋmoꞋya kagaifena ago tagasane.’ huꞋya hugahae.” huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ani yafe Isaleli vayaꞋmogata havilama huta havisune. Ani Yisasina tamakayama yafaga yosalela nilia hetama asai-malenaya kanomofe Anumaya KotiꞋa mage huno humaine ‘Ani kanomoꞋa Anumaya maineanagi nagaya hutogeno emainea kano maine.’ huno humaine.” huno nehie. KasagoꞋya ve aꞋmoꞋya amakuꞋa aiyahae hageꞋya tina falematenae. ");
INSERT INTO kmu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","PitaꞋma hia kemoꞋa amakupi ayegeꞋya haviteꞋya PitaꞋene nagoꞋa Aposolo vayaꞋenefe mage huꞋya hae “Nelafugatama menia hanaꞋa hisune?” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hageno PitaꞋa mage huno hie “Tamakaya mukiꞋamogatama tamakuꞋa aiyahae hutama egeta Yisasi Kalaisi agile tina falelamatano. AniꞋama hisagenoꞋa Anumaya KotiꞋa aigetamateno kefo yatamia atalelamateno Alu Aotage Avamula tamamigahie. ");
INSERT INTO kmu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","‘Tamamigahue.’ huno humainea kea tamakaife nehigi tamakayaene nafaꞋnetamiene Yuta vea omainaya veaꞋnenefe mani kea huno mukiꞋa Anumaya KotiꞋa kema humatesia veaꞋmogamife ‘Tamamigahue.’ humaineane.” huno Pita mani kea humaine. ");
INSERT INTO kmu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","PitaꞋa mani kea nehuno alu ke alu ke huno kanaꞋye kanaꞋye huno mage huno hie “Meni kanafima mainaya veaꞋmoꞋya tusiꞋa kefo kava maiꞋya nehagi havigu tamakaya kefo kava huyafenagi atalegeno Anumaya KotiꞋa tamaku tamamena aligatino.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","HigeꞋya nagoꞋa veaꞋmoꞋya tali tauseniꞋa (3,000) veaꞋmoꞋya mani kea haviteꞋya aliꞋya amakupi maleꞋya amametiti hageꞋya ani yupa lina falematenae. Yisasife amakupi nemalaya veaꞋmoꞋya tokaeꞋya kanale kava nehae. ");
INSERT INTO kmu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Lina falematageꞋya amakaya mukiꞋa yupa nago amaku amakesa haviꞋya Aposolo vayaꞋmogami kea haviꞋya hameꞋya maya kofa huꞋya nete nete nehuꞋya Anumayamotega muse huꞋya nunamuna nehae. ");
INSERT INTO kmu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","NehageꞋya mukiꞋa veaꞋmoꞋya tusiꞋa amamaꞋyo neꞋaigeꞋya Aposolo vayaꞋmoꞋya kasagoꞋya tokiya avame yana nehae. ");
INSERT INTO kmu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","MukiꞋa Yisasi kema haviꞋya amakupi maleꞋya amametitima humainaya veaꞋmoꞋya nagoke amaku amakesa haviꞋya mukiꞋa yaꞋyagaꞋamihena “NagaiꞋnige yane.” huꞋya ohunagi “MukiꞋa yana lagaiti ya hane.” huꞋya nehae. ");
INSERT INTO kmu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mopaene afenoꞋyaꞋamienema hanea veaꞋmoꞋya atalageno alu kanomoꞋa miya higeꞋya monea aliteꞋya fako hute hute huꞋya kaveꞋamima omalenea veala amaminae. ");
INSERT INTO kmu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","MukiꞋa kanafina nagoke amaku amakesa haviꞋya ala mono nopina neꞋuꞋya alu nopina alu nopina uꞋya hameꞋya maya kofa huꞋya kaveꞋene nete nete nehuꞋya muse huꞋya Anumaya Koti agia alisaga nehageꞋya mukiꞋa veaꞋnemoꞋya ageteꞋya “Kanale kava nehae.” huꞋya nehageno AnumayamoꞋa nago kanafina nago kanafina nagoꞋa veaꞋnea amaku amamena aligatiteno “Nagai ke nehaviya veaꞋene maiho.” huno humatene. ");
INSERT INTO kmu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nago yupa une kanalega tali (3) kiloki PitaꞋene YoniꞋene nunamu hisaya kanamoꞋa aupa higeꞋana ala mono notega umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","NeꞋvaꞋageꞋya vayaꞋmoꞋya nagola kali kanoa, atenelegati aiyamoꞋa haviya humainea kanoa, avaleꞋya emainae. MukiꞋa kanafina anima aiyama haviya humainea kanomoꞋa ala mono nomo fiate mopale nemaiyane. Ani fiamo agia koganali fiane huꞋya agia neꞋayaya fiate maineno ala mono nopima vaya veafena “Monea namiho.” huno ayana haꞋya hulineno aukaꞋya nehia kanoe. ");
INSERT INTO kmu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ani kanomoꞋa ageana PitaꞋene YoniꞋene ala mono nopi haigahe nehaꞋageno “Monea namitetanao.” huno aukaꞋya hunatene. ");
INSERT INTO kmu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","HunategeꞋana PitaꞋene YoniꞋene tokiyaꞋage aulu hemaineꞋana PitaꞋa mage hie “TaꞋagaila taꞋago.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","7","Higeno ani kanomoꞋa “Nago ya namigahe nehaꞋe.” huno anakaila anakeke huno anake-mainegeno PitaꞋa mage huno hie “MoneꞋniꞋa omalegi nagaipima hanea yana kamigahue Nasaleti Yisasi Kalaisi agile kahanepauve hetika ute ete huo.” huno nehuno tamaga ayate alino hetitegeno aupaꞋa aiyamoꞋene aleꞋyamoꞋene kanale hutegeno tokiya hau-maine. ");
INSERT INTO kmu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","TokiyaꞋage hautegeno hetino ute ete nehuno anakaiꞋene ala mono nopinaga nehaino haite asaga hulavite nehuno Anumaya Koti agia alisaga hume hume nehaiye. ");
INSERT INTO kmu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Anumaya Koti agia alisaga huno haigeꞋya mukiꞋa veaꞋmoꞋya agayana higeꞋya “Vae mani kanoa mukiꞋa yupa ala mono nomona koganali fiate maineno aukaꞋya nehia kanogi.” huꞋya nehuꞋya alino kanaleꞋma hutenea yafena tusiꞋa amamaꞋyo aimainae. ");
INSERT INTO kmu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","VeaꞋmoꞋya amamaꞋyo neꞋaigeno ani kanomoꞋa PitaꞋene YoniꞋene anatafa huno ananukigeꞋya mukiꞋa veaꞋmoꞋya ala mono nomo haupale yasi alisia ya ayekalo humalenea nomo, agia Solomoni none huꞋya nehaya yate, amakaitega umainae. ");
INSERT INTO kmu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Vageno PitaꞋa ageteno mage huno humaine “Isaleli kumate vayaꞋmogatama naꞋa higetama atali talua nehae? TaꞋagaya taꞋagaitiꞋa tokiyaletiꞋene fatago humainoꞋa auꞋava yatetiꞋene ani kanoa alitaꞋa kanale hutoꞋageno ute ete nehie hutama taꞋagaila taꞋageneꞋasagalifi? ");
INSERT INTO kmu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","AꞋao. Taginagomogami Anumaya KotiꞋa, ApalahamuꞋene AisakiꞋene Yekopuene Anumaya KotiꞋamimoꞋa, agaiꞋa aliꞋya kanoꞋamona, Yisasi, tokiya hale ya amigahe ani kanomona alino kanale hutenegi tamakaya ani Yisasina avaletama kame vayaꞋmogami amayapi atageno PailatiꞋa Yisasife ‘AfaꞋa atalegahue.’ huno nehiana tamakaya Pailati aulagafi ‘Tagai kava kanoa omaigi agaya falisie.’ hutama tamakaveꞋno hutenae. ");
INSERT INTO kmu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","15","Alu aotage kanoa fatago kavaꞋage nehia kanomona tamakaveꞋno huneꞋatetama vayaꞋma hamaeno fali neꞋamatea kanohe ‘Atalegeno eno.’ hutetama mukiꞋa veaꞋmogami hamaimuꞋmona aepaꞋa mainea kanomona hayageno falianagi Anumaya KotiꞋa fali-mainefiti alino hetitegetaꞋa ago agetetaꞋa mani kea tamahanepauꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","‘YisasiꞋa kanale hulaꞋatesia tokiya hane.’ hutaꞋa taꞋagupi malenoꞋa yafe manima neꞋagaya kanomona ago kanale hutetegeno aiyamoꞋa tokiya vaimaine. ‘YisasiꞋa kanale hutesia tokiyaꞋa hane.’ hutaꞋa taꞋagupi malenoꞋa yateti tamakai tamaulagafi ago kanale hutegeno kanale huno maine. ");
INSERT INTO kmu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tamage nenafugatama nagaya havuana tamakai kava vayatamimoꞋyaene YisasiꞋma emainea aepaꞋaene havilama ohunetama Yisasina hae-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hae-mainaya yafe Anumaya Koti aune vayamogami amavayafitiꞋma humainaya kea mage humainayane ‘Nagaya tamaugafa aligatigahe hutenoa kanomoꞋa tusiꞋa agataya aliteno faligahie.’ huꞋya humainaya kemoꞋa efalote huno tamage humaine. ");
INSERT INTO kmu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ani yafe kefo yatamia neꞋataletama tamakuꞋa aiyahae hisageno Anumaya KotiꞋa kefo yatamia aye haꞋmi-talegahie. ");
INSERT INTO kmu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aye haꞋmiteno agaiꞋalegati kanaleꞋma humatesia yana nelamamino Yisasina tamakaifema tamaugafa aligatigahie huno hutenea kanoa eteno tamakaitega hutenageno egahie. ");
INSERT INTO kmu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hutegahianagi meni kanafina YisasiꞋa ikapinaga maineno Anumaya KotiꞋma mukiꞋa yana eteno haegafa yamaꞋage talo hisia yafe agava-maine. MukiꞋa Anumaya KotiꞋma nayoma mainaya amaune vayaꞋmoꞋya humainaya kemoꞋa efalote huno tamage humaineafe YisasiꞋa eteno egahie. ");
INSERT INTO kmu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","MoseseꞋa mage huno kaemaleneane ‘Anumaya KotiꞋa tamakaipiti nagola aune laga hisia kanoa nagayama huaꞋya huno hisia kanoa ali hetitegahie. HetitetenagenoꞋma agayama hisia kea haviho. ");
INSERT INTO kmu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ani aune kanomo kema ohavisaya veaꞋmogamina Anumaya KotiꞋa hamaeno fali haꞋno hinageꞋya Isaleli veapina omaigahae.’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","MukiꞋa Anumaya Koti amaune vayaꞋmoꞋya SamueliꞋene agai akavelegatiꞋma falote humainaya amaune vayaꞋyagaene menima mainona kanahe haviꞋya kae-malenayane. ");
INSERT INTO kmu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tamakaya Anumaya Koti amaune laga nehaya vayaꞋmogami amakinagomogatama mainae. Anumaya KotiꞋma Apalahamufe hulokiya vaino alino hagelafi lamatenea kea* huno tamakaiꞋenefe mani kea humaine. Anima hulokiya vaimalenea kemoꞋa mage huno humaineane ‘Nago tamakinagomoꞋa esiana mukiꞋa ma mopafi veaꞋmogamina kanale manua amamigahie.’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","MukiꞋa manima humainaya kemoꞋa falote huno tamage hisia yafe Anumaya KotiꞋa agaiꞋa aliꞋya nafaꞋneꞋamona alino hetitegetama tamakaya kefo yatamihe tamakuꞋa aiyahae hisageno tamaya huno kanale manua tamamisia yafe hagoteno tamakaitela hutegeno emaine.” PitaꞋa mage huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pitagani Yonigani yaufa mani kea hama-nepaiꞋageꞋya mono note kava vayaꞋene mono note ati kava kanoene nagoꞋa Satiusi vayaꞋene eꞋya menakayana anakayama “YisasiꞋma fali-mainefitila ago ali hetiteneanagino mukiꞋa veaꞋnea aniꞋa huꞋya fali-mainesafitila eteꞋya hetigahae.” huꞋana hamapaiꞋa yafe amaipa haviya nehae. ");
INSERT INTO kmu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Amaipa haviya huteꞋya anatafa hagi “Ago une kianagita ega kaiyekea hunategahune.” huꞋya kina nopi anavaleꞋya monatenae. ");
INSERT INTO kmu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Monatayanagi kasagoꞋya veaꞋnemoꞋya anakai kea haviteꞋya amakupi maleꞋya amametiti nehae. Faefu tauseniꞋa (5,000) veaꞋmoꞋya YisasiꞋma hulatenea yafena haviꞋya amakupi maleꞋya amametitia nehae. ");
INSERT INTO kmu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","FaeteꞋya koꞋma neliana kava vayaꞋene vayatamaene kahegi kema havilinaya anagaꞋene AnasiꞋa ala mono note hagote kava kanomoꞋene agaiꞋa anagaꞋene KaiyafasiꞋene YoniꞋene AlekasataꞋene mukiꞋamoꞋya Yelusalemu alitalu humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Alitalu huteꞋya ani kanolatana anavaleꞋya amaufi hetinateneꞋya mage huꞋya hanavigae “Tanakaya hanaꞋa agimo tokiyaleti mani kavala humainaꞋe?” huꞋya hanavigae. ");
INSERT INTO kmu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hana-vigageno Alu Aotage AvamuꞋmoꞋa Pitana agupina hiya higeno mage huno humaine Kava vayaꞋmogatamaene vayatamaene haviho. ");
INSERT INTO kmu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mani aiyamoꞋa haviya humainea kanomona ali falu hutetana alitana kanale hutenaꞋe kea havisune hutama kaiyekea hulaꞋatetama na yateti mani kava nehaꞋe hutama taꞋahavi-negapi? ");
INSERT INTO kmu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","TaꞋa-havigayanagi mukiꞋamogatamaene mukiꞋa Isaleli veaꞋmoꞋyaene haviho. Nasaleti Yisasi Kalaisi agimoꞋa manima tamaufima heti-mainea kanomona alino kanale hutene. Ani Yisasina tamakaya yafaga yosale nilia hetama asaigeno fali-maineanagi Anumaya KotiꞋa fali-mainefiti ago ali hetitene. ");
INSERT INTO kmu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Anumaya Koti kemoꞋa autaꞋmafina mage huno humaine “Tamakaya yafa noma kiyana nago yafafena ‘Haviya hie.’ hutama atalayanagi menia ani yafamoꞋa tusiꞋa kanale yafane nomo ayetagenale ago malenae.” huno humaineane. Ani yafana Yisasife humaine. ");
INSERT INTO kmu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ani kanomoꞋa agaiꞋage tagu tamena aligatigahie. MukiꞋa mopafi veapitila nago kanomo agileti tagu tamena aliokatigahigi Yisasina agaiꞋage agileti tagu tamena aligatigahie huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pitagani Yonigania tokiyaꞋage ke haꞋageꞋya haviteꞋya mage hae “Vae mani kanolatana afa kanolata maineꞋana avo nopina oꞋunaꞋa kanolanagi hanaꞋa huꞋana tusiꞋa kanale kea nehaꞋe?” huꞋya amakesa havi havi nehuꞋya “Vae mani kanolatana YisasiꞋene nemaiꞋa kanolatane.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hayanagi aliꞋana kanaleꞋma hutenaꞋa kanoa anakaiꞋene heti-mainegeꞋya agaya yafe nagoꞋa havige havagea huoꞋanatenae. ");
INSERT INTO kmu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","“Kanisole vaya nopitila ataletana viꞋo.” huꞋya hunateteꞋya amakaiꞋamifi kea huge havige humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mage huꞋya hae “Ani tole kanolatana hanaꞋa hunatesune? Mama tokiya avame yana haꞋageꞋya mukiꞋa Yelusalemu nemaiya veaꞋmoꞋya ago age-mainagi hanaꞋa huta ali fala-kisune? ");
INSERT INTO kmu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Havigu mani kemoꞋa alu kote kotega ute ete huyafenagi aluya huta ‘NagoꞋene mani agia oꞋayeꞋo.’ huta kahegi-natesune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Anakaife ke hageꞋana aꞋageꞋya mage huꞋya anaumonola malenae “Yisasifena nagoꞋene veaꞋmogamina hamapaitana humaveotiꞋo.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","HageꞋana PitaꞋene YoniꞋene kenonaꞋamia mage haꞋe “Na tamakesa nehaviye Anumaya Koti aulagafi mainoꞋagi ta kele akavela malesuꞋe? Tamakai kelepi Anumaya Koti kelele hutama nehafi na tamakesa nehaviye? Tamakaitami fako hutama haviho. ");
INSERT INTO kmu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","TaꞋagaya YisasiꞋma humainea kavala agetaꞋa havimainoꞋa kavaꞋyaga fala okigahuꞋe.” huꞋana nehaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","HaꞋageꞋya anaikolisaya amakesa haviyanagi mukiꞋa veaꞋmoꞋya humainaꞋa kavala ageteꞋya Anumaya Koti agi alisaga nehageꞋya mage hae “Anaiko-lisunana veaꞋmoꞋya kelama-kigahae.” huꞋya nagoꞋene anaumonola maleteꞋya anatalageꞋana umainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anima aiyama haviya humainea kanoma aliꞋana kanale hutenaꞋa kanomona kafuꞋa fotiꞋa (40) kafu humainea kanogiꞋya Anumaya Koti agi alisaga humainae. Yisasife amakupi malenaya veaꞋmoꞋya tokiya vaiꞋya Yisasi kema hufalote hisaya yafe Anumayamotega havige-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","AnatalageꞋana anagaꞋanimoꞋya mainalega uteꞋana mukiꞋa ala mono note ala kava vayaꞋyagaene vayatamaene hanapaiya kea mo hamapai-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mo hamapaiꞋageꞋya haviteꞋya nagoke amakesa haviꞋya Anumayamotega ke huꞋya mage huꞋya havige-mainae “Kava yagai Anumayatimogae mopaene ikaꞋene hage liꞋene mukiꞋa anifima hanea yaꞋyagaene talo humalenana kanomogae. ");
INSERT INTO kmu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Kagaya kagai aliꞋya kanoa, tototimoꞋa TevitiꞋma avayafiti Alu Aotage Avamukaletila mage huka humainanane ‘NaꞋa higeꞋya Isaleli nofiꞋma omainaya veaꞋmoꞋya ‘Anumaya KotiꞋene tu hugahune.’ huꞋya havigu ke huꞋya amaipa kafa hemainae? Ma mopafi kava vayaꞋene vayatamaene AnumayamofeꞋene agaiꞋa tagu tamemaꞋa aligatigahe hutenea kanomofeꞋene amaipa haviya nehuꞋya kea neꞋvaiye?’ huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mamona kelamage. Mani kumate alu aotage aliꞋya kanokaꞋa kagaikaꞋa taugafa aligatigahema hutenana kanomona kame hutesaya yafe HelotiꞋene Potiasi PailatiꞋene Yuta vea omainaya vayaꞋyagaene Isaleli vayaꞋene alitalu huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kagayama nayoma huka ‘NaꞋa maꞋa hugahae.’ hukama havimainana kagesa aniꞋa hugahe alitalu humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Menia Anumayatimoga manima tagaifema hamae vainelateꞋya hu kolima latesaya kema haya kea nehavika tahaꞋmao. Tagaya kagai aliꞋya vaya mainonagi kagaya tahaꞋmaegeta kolia ohuta kagai kea tokiyaꞋage huta hamapaisune huta kahavinegone. ");
INSERT INTO kmu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kayana maleka kali veala alika kanale huneꞋamateka kagaikaꞋa alu aotage nafaꞋnekamo agile tokiya avame yama hisuna tokiyakaꞋa lamio.” huꞋya Anumayamotega havinegae. ");
INSERT INTO kmu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Havigageno Anumaya KotiꞋa amakayama mainaya nona alino kosi kosi hutegeno Alu Aotage AvamuꞋmoꞋa amakupina me hiya humainegeꞋya Anumaya Koti kema tokiyaꞋage huꞋya hamapaisaya yafena kolia ohunae. MukiꞋa Yisasina amakuꞋama aminaya veaꞋmoꞋya nagoke amaipale maineꞋya amaipa oꞋami aꞋami huꞋya mainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","MukiꞋa Yisasi kema haviꞋya amakuꞋama aminaya veaꞋmoꞋya nagoke amaku amakesale maineꞋya nago kanomoꞋa agaiꞋage yafena ageteno “NagaiꞋnige yane.” huno ohunegi “MukiꞋa yana tagaiti yamaꞋage hane.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hageno tusiꞋa tokiyaꞋa amamigeꞋya Aposolo vayaꞋmoꞋya “YisasiꞋa fali-mainefitila ago heti-maine.” huꞋya hamanepaigeno Anumaya KotiꞋa kayone hisaya yana neꞋamamino amaya humaine. ");
INSERT INTO kmu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Amaya higeꞋya amakai amuꞋnoꞋamifina kavefena kafua ohu veaꞋne maineꞋya mopaꞋamia hanea veaꞋnene noꞋamia hanea veaꞋnene “Alu kanomo miya hisie.” huꞋya hageꞋya monea amamigeꞋya aliꞋya Aposolo vayaꞋmogamina momamigeꞋya kaveꞋamima omalenea veaꞋmogamina amaya huꞋya amamite amamite humainae. ");
INSERT INTO kmu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Nago kanoa YosefeꞋe, nago agia Aposolo vayaꞋmoꞋya mage huꞋya malenae PanapasiꞋe huꞋya malenae. Ani agimoꞋa tagai kefina mage hie “Amaipa falu hisia ke nehia kanoe.” Ani kanomoꞋa Livai nofi kano maine. Saipalusi kumateti kanomoꞋa agaiꞋa mopa alu kano amigeno monea eteno amigeno ani monea alino Aposolo vaya me neꞋamamiane. ");
INSERT INTO kmu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nago kanoa AnanaiyasiꞋe aꞋamo agia SafailaꞋe ani alavelatamogania nago mopaꞋania alu kano neꞋamiꞋana mone ali-mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","AliteꞋana AnanaiyasiꞋa kesi nagoꞋa monea agaiꞋa alino fala-kigeno aꞋamoꞋa anima alia monea ago age-maine. AnanaiyasiꞋa nagoꞋa monea alino Aposolo vaya momamine. ");
INSERT INTO kmu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Amamianagi PitaꞋa agaifena mage hie “Ananaiyasigae SataniꞋa* kefo kagu kagesa kamigeka kagaya ‘MukiꞋa monea mama hane.’ huka nehanagi nagoꞋa monea ali fala-negika Alu Aotage AvamuꞋmofena havige huka ayevataga nehane. ");
INSERT INTO kmu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mani mopa kagaika mopagika ‘Alu kanomo alisie.’ huka monea neꞋalika aniꞋa huka kagaika monegi naꞋa higeka ‘Havigea huꞋna ayevataga hugahue.’ huka kagu kagesafinaga nehane? VayaꞋmona ayevataga ohunanagi Anumaya Koti ayevataga humainane.” huno nehie. ");
INSERT INTO kmu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Higeno AnanaiyasiꞋa ani kea haviteno ailakatino fali-maine. FaligeꞋya neyaꞋvemoꞋya nago kena moliꞋya haꞋya kiteteꞋya aliꞋya komufi mo hevaitenae. HevaitetageꞋya ani kanoma fali-mainea kea mukiꞋa veaꞋmoꞋya haviteꞋya tusiꞋa lagi tagiꞋya amake-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","HaenagaꞋa taliꞋa (3) aova haꞋnoma nehiana aꞋamoꞋa ani fali-mainea kea ohavino egeno PitaꞋa agaife mage hie “Manima hanea monea mopaletila hai ani kanoꞋa ali-mainaꞋo?” huno higeno “Tamage ani kanoꞋa al-imainoꞋe.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Higeno PitaꞋa mage huno hie “NaꞋa higetana tanakaya tokaetana kea hutetana ‘Alu Aotage AvamuꞋmona ayevataga hugahuꞋe.’ hutana haꞋane? Agego anaukamoma agoꞋma aliꞋya mo hevaitaya vayala eteꞋya fiate me heti-maineꞋya kagaiꞋenena falisanageꞋya aliꞋya mo hevaigategahae.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nehigeno aupaꞋa ani aꞋmoꞋa Pita aiyafi ailakatino agoꞋya faiteno faligeꞋya neyaꞋveyagamoꞋya haiꞋya mogayana ani ala ago fali-mainegeꞋya moliꞋya anauꞋamoma hevaitale mo lokaeꞋya hevainatenae. ");
INSERT INTO kmu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","HevainatageꞋya Yisasina amakuꞋama aminaya veaꞋene mukiꞋa ani kema haviya veaꞋmoꞋyaene tusiꞋa lagitagiꞋya amake-maine. ");
INSERT INTO kmu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo vayaꞋmoꞋya mukiꞋa vea amuꞋnopi kasagoꞋya tokiya avame yaꞋyaga hageꞋya age-mainae. AgeteꞋya Yisasina amakuꞋama aminaya veaꞋmoꞋya nagoke amaku amakesale maineꞋya ala mono nomo haupale yasi alisia ya ayekalo humalenea nomo agia Solomoni none ani nopi mukiꞋa kanafina molitalu humai humai nehayane. ");
INSERT INTO kmu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","NehageꞋya nagoꞋa veaꞋmoꞋya kolima haya yafe amakaiꞋenena mo lokaeꞋya uomainagi ani veaꞋmogami amaki alisaga humainae. MukiꞋa veaꞋmoꞋya Yisasi kema haviꞋya amakupi maleꞋya amametitia huteꞋya amakaiꞋene mainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tokiya avameꞋyama humainea yafe mukiꞋa kalima hamaeya veala amavaleꞋya kate amateꞋya hagifanale maineꞋya mage hae “PitaꞋma esiana agai amemo me halatu hamaesigeno kanale humategahie.” huꞋya kate momatenae. ");
INSERT INTO kmu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","AmatageꞋya mukiꞋa veaꞋmoꞋya Yelusalemu aupateꞋma hanea kumaꞋyagaleti kalima hamaeya veaꞋnene Satani avamuꞋmoꞋma amakupi fale-mainea veaꞋnene amavaleꞋya ageno mukiꞋa ago alino kanale humatene. ");
INSERT INTO kmu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Mono noteꞋma hagote kava kanomoꞋene agaiꞋenema lokaeꞋya mainaya vayaꞋene Satiusi vayaꞋmoꞋyaene amaipa haviya humateteꞋya Aposolo vayala amatafa huꞋya amavaleꞋya kina nopi momatenae. ");
INSERT INTO kmu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Amatenageno ani kegela Anumayamo ensole kanomoꞋa eno fita me yakino anifiti amavaleno kumatega neꞋuno mage huno hie “Tamakaya utama ala mono nopi hetitama veaꞋmoꞋyama haegafa huꞋya agola maige maige hisaya hamaimula alisaya kea hamapaiho” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","HigeꞋya haviteꞋya natekefafi hetiꞋya uꞋya ala mono nopi veaꞋmogamina mo hamanepaiye. Hamanepaigeno ala mono note hagote kava kanomoꞋene agaiꞋenema lokaeꞋya nemaiya vayaꞋene ani kea ohaviꞋya neꞋataleꞋya Kanisole vayafeꞋene Isaleli nofi vayatamaenefe moge hageꞋya ageno ati vayafe “Kinama humatenona vayala momavaletama eho.” huꞋya hamapaimainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Me hageꞋya ati vayala kina nopi mogayana omaigeꞋya neꞋataleꞋya eteꞋya mage mo hae “Tagaya mogonana fita tokiyaꞋage alokileti hemaleneꞋya vayala kava yagaiꞋya kumate hetimainageta fita mo yakiteta kina nopima mogonana omainae.” huꞋya me humainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","MehageꞋya ala mono note kava vayaꞋyagaene mono note ati kava kanoene mani kea haviteꞋya tusiꞋa amakesa havi havi huꞋya mage hae “HanaꞋa huꞋya kina nopitila fanane humainae? HanaꞋa humainea ya falote hugahie.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hageno nago kanomoꞋa mage huno me hamapaiye “Haviho kina nopima amataya vayala ala mono nopi hetiꞋya maineꞋya veaꞋmogamina humave-neliye.” huno me hie. ");
INSERT INTO kmu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Me higeꞋya mono note ati kava kanomoꞋene ati vayaꞋaene uꞋya “Havigu amakai kema havimainesaya veaꞋmoꞋya yafateti tahaesageta falisunagi.” huꞋya amaikootiꞋya ako huꞋya amavaleꞋya emainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","AmavaleꞋya ayaꞋamoꞋya Kanisole vaya amuꞋnopi me hetimatetageno ala mono note hagote kava kanomoꞋa mage huno hie. ");
INSERT INTO kmu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tagaya Yisasife nagoꞋene veaꞋmogamina hamapaitama humaveotiho” huta tamakaila tamaumonola ago malonanagi tamakaya mukiꞋa Yelusalemu nemaiya veaꞋmogamina mani kea hamapaitama tagaifena ‘Ago Yisasina hae-malenaya vaya mainae.’ hutama hamapai-mainae.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hianagi PitaꞋa nagoꞋa Aposolo vayaꞋene mage huꞋya nehae “Ma mopafi vayaꞋmogami kemona akave omalegahunagi tagaya Anumaya Koti kemo akave malegahune. ");
INSERT INTO kmu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tamakaya Yisasina nagoke yafaga yosale asai-malageno fali-maineanagi Tototimo Anumaya KotiꞋa fali-mainefiti ago ali hetitene. ");
INSERT INTO kmu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ali hetiteteno avalesaga huno tamaga ayatega ategeno hagote kava kanoa tagu tamema aligatimainea kanoene mainea yafe tagaya Isaleli veaꞋmogata taguꞋa aiyahae hisuna tagesa tamisigeta taguꞋa aiyahae hisunageno aigetateno kefo yatia atalelategahie. ");
INSERT INTO kmu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tagaya mani kea hisuna vaya mainonageno Alu Aotage AvamuꞋmoꞋa aniꞋa huno mani kea humaine. MukiꞋa Anumaya Koti kema akave malenaya veaꞋmogamina Anumaya KotiꞋa Alu Aotage Avamula ago amamine.” huno hie. KamalieliꞋa kanisole vayaꞋmofe mage huno hie “Aposolo vayaꞋmogamina ako hutama amateho.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","HageꞋyama mani kema haviya yafe amaipa amakata aiꞋya Aposolo vayala hamaesageꞋya falisaya amakesa nehaviye. ");
INSERT INTO kmu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hamaegahayanagi nagola Falasia kanomo agia KamalieliꞋe* mono humave-nelia kanogino Yuta vayaꞋmogami Kanisolefi mainegeꞋya mukiꞋa veaꞋmoꞋya agima alisaga nehaya kanogino ani kanomoꞋa hetino mage huno hie “Tahaote kea hugahunagi Aposolo vayala humategeꞋya kumatega hati-lavisageta kea hisune.” huno hie. ");
INSERT INTO kmu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","HigeꞋya hati-laviꞋya vageno mage huno Kanisole vayaꞋmogamife hie “Isaleli vayaꞋnimogatama mani vayaꞋmogamina nago yama humategahunema hinutama tamakesa havilama hutetama aniꞋa hiho. ");
INSERT INTO kmu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nayona nago kanomo agia TeutasiꞋe evaꞋyi huno ‘Nagaya tokiyaꞋniꞋa hanea kano mainoe.’ huno higeꞋya fo hataletiꞋa (400) vayaꞋmoꞋya akavela vayanagi kamani kava vayatimoꞋya ago hayageno faligeꞋya akaveꞋma neꞋvaya vayala atagufeꞋya ute ete hageno aliꞋyamaꞋamoꞋa afa ya kana humaine. ");
INSERT INTO kmu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Agai akavelega amakima negayaya kanafina YutasiꞋe Kalili kanomoꞋa evaꞋyi huno kea hamapaigeꞋya nagoꞋa vayala akave neꞋvageno kava vayatimoꞋya Yutasina ago hayageno faligeꞋya akaveꞋma neꞋvaya vayala atagufeꞋya ute ete humainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","NaꞋa humainaya yafe menia tamahapauve mani vayala amatalegeꞋya viho. Anima nehaya kea amakaiꞋami mopale vayaꞋmogami kema hanesigenoꞋa afaꞋa haꞋno hugahianagi Anumaya Koti kema hanesigetama tamakayama ali haviyama hisaya amukotamia omalene. Havigu lamakaya Anumaya Kotina kame hutetama agaiꞋene tu hutesagi.” huno humaine. ");
INSERT INTO kmu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","HigeꞋya Kamalieli ke haviꞋya “Tamage hane.” huteꞋya Aposolo vayafe ke hageꞋya ageꞋya nofi kaꞋyoteti haifu amamiteꞋya amaumono nemaleꞋya mage hae “Yisasifena nagoꞋene veaꞋmogamina hamaopaiho.” huꞋya humateteꞋya amatalageꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ani Kanisole vayala amataleꞋya neꞋuꞋya “Anumaya KotiꞋa ago tamatea kava nehae.” huno tagaifena nehuno “Yisasi agima neꞋayaya yafe tamakaye hisifa kavala hisagetama amukotamia hanegahie.” huno humainea yafe tusiꞋa muse hume hume umainae. ");
INSERT INTO kmu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","MukiꞋa yupa ala mono nopiꞋene veaꞋmogami nopiꞋene mukiꞋa veaꞋmogamina Yisasifena hamapai-mainae. “Yisasina Anumaya KotiꞋa taugafa aligatigahema hutenea kanoe.” huꞋya hamapai-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","KasagoꞋya veaꞋmoꞋya Yisasi kea haviꞋya amakupi maleneꞋya amaku aminaya kanafina nagoꞋa ani veaꞋmoꞋya Kaliki ke havilinaya vea mainagi nagoꞋa veaꞋmoꞋya Hipalu ke havilinae. Kaliki kema havilinaya veaꞋmoꞋya mage hae “Tagai megusa aꞋneyaga havi kava hutama osi kanoꞋa kavela neꞋamamiyanagi Hipalu amakema neꞋaiya megusa aꞋneyaga kasagoꞋya kave neꞋamamiye.” huꞋya amaipa haviya huꞋya ke vai-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Kema vaiya yafe Yisasina tuelufuꞋa (12) Aposolo anagaꞋamoꞋya mukiꞋa Yisasina amakuꞋama aminaya veafe ke hageꞋya ageꞋya mage huꞋya hae “Havigu tagaya Yisasi ke hamanepauna aliꞋyatia ataleta kaveꞋma fako faka hisunana haviya huyafenagi nafuꞋnaganagatama tamakaitami amuꞋnotamifi atiyetama seveniꞋa (7) kanale amaku amakesaene vayaꞋma, mainesigenoꞋma Alu Aotage AvamuꞋmoꞋa amakupima hiya humainenageꞋya veaꞋamimogami amaulagafima kanale kavaꞋma nehisaya vayafe atiyetama ani aliꞋyatela humatesune. ");
INSERT INTO kmu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Humategahunanagi tagaya mukiꞋa yupa nunamu huta havige havige nehuta Yisasi kea hamapaige hamapaige huta maigahune.” huꞋya humainae. ");
INSERT INTO kmu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","HageꞋya mukiꞋa veaꞋmoꞋya mani kea haviteꞋya muse nehuꞋya ani vayala hapaliꞋya humataya vayala SitiveniꞋa, Yisasi kea aguꞋafi tokiyaꞋage huno malegeno Alu Aotage AvamuꞋmoꞋa agupina hiya humainea kanoene FilipiꞋene PolokolasiꞋene NikanaꞋene TimoniꞋene PamenasiꞋene NikolasiꞋe. NikolasiꞋa Atioku kanoa nayona Yuta nofi kanoa omaineanagi eaꞋyamo “Yuta vayaꞋmogami Anumaya KotiꞋamimo ke aliꞋna nagupi malegahue.” huno Isaleli nofi vayapi maineane. ");
INSERT INTO kmu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ani vayala amavalageꞋya Aposolo vayatega ageꞋya ani vayaꞋmogami amanute amaya maleꞋya nunamuna humatenae. ");
INSERT INTO kmu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Anumaya Koti kemoꞋa mukiꞋa kotega ute ete higeꞋya kasagoꞋya Yelusalemu nemaiya veaꞋmoꞋya Yisasi kea haviꞋya amakupina malenae. KasagoꞋya mono note kava vayaꞋyagaene aniꞋa huꞋya Yisasi kea aliꞋya amakupi maleꞋya amametiti humainae. ");
INSERT INTO kmu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","SitiveniꞋa tusiꞋa kanale kanogino kayone hisia yaꞋene tokiyaꞋaene agupina hiya humainegeno tusiya huno ani vayapina tokiya avame yana humaine. ");
INSERT INTO kmu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","AniꞋa nehianagi nagoꞋa vayaꞋmoꞋya hetiꞋya SitiveniꞋene ke neꞋvaiye. Ani vayala miya oꞋali vaya maiteꞋya eteꞋya afaꞋa maineꞋya nago mono nopi neꞋvaya vayale. Sailinia vayaꞋene Alekasatalia vayaꞋene nagoꞋa vayala Silisia vayaꞋene Esia vayaꞋene Sitivenina ke vaitenae. ");
INSERT INTO kmu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kea vaitayanagi Alu Aotage AvamumoꞋa haꞋmaegeno kanale agu agesaene kanomo kea amigeno humaine. Higeno amakai kemoꞋa Sitiveni kemona oꞋagasene. ");
INSERT INTO kmu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","OꞋagasegeꞋya nagoꞋa vayafe “Sitivenifena havige hutesageta mone lamamigahune.” huꞋya hageꞋya ani vayala mage mo hae “Mani kanomoꞋa MosesefeꞋene Anumaya KotifeꞋene tusiya huno hu-haviya hunategeta havimainone.” huꞋya mo humainae. ");
INSERT INTO kmu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mani kema haya yafe mukiꞋa vayaꞋmoꞋyaene vayatamaene kahegi kema havilinaya anagaꞋmogamina amakuꞋamoꞋa haviya higeꞋya Sitivenina motafa huꞋya Kanisole vayate avaleꞋya umainae. ");
INSERT INTO kmu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","UteꞋya nagoꞋa havigema nehaya vayala amavaleꞋya hetimatageꞋya ani vayaꞋmoꞋya mage hae “Mani kanomoꞋa mukiꞋa yupa tagaila alu aotage mono notiene kahegi kene huno haviya hie. ");
INSERT INTO kmu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Higeta havunana YisasiꞋa Nasaleti kanomoꞋa ma ala mono nona aliꞋna lagaꞋya vaineꞋataleꞋna ‘MoseseꞋma tahapai-mainea kahegi kea ataletama alu kava hiho.’ huno higeta havimainone.” huꞋya hae. ");
INSERT INTO kmu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","NehageꞋya mukiꞋa Kanisolefi mainaya vayaꞋmoꞋya Sitivenina aulu hayana augosamoꞋa alave alave nehuno ensole vayaꞋmogami amaugosamoꞋma nehia kava higeꞋya age-mainae. ");
INSERT INTO kmu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ala mono note hagote kava kanomoꞋa Sitivenifena mage huno havige “Mani kema hugataya kea tamage nehao?” huno havige. ");
INSERT INTO kmu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Higeno SitiveniꞋa mage huno humaine nenafagatamaene naganaꞋni-mogatamaene haviho. TaginagomoꞋa ApalahamuꞋe yaufa Halani kotega oꞋuno Mesopotemia kotega mainegeno tokiya hale yamaꞋaene Anumaya KotiꞋa Apalahamute efalote humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Efalote huteno mage huno hapaiye “Kagaika mopakaꞋaene vayakamogamiꞋenena neꞋamataleka kavelisua mopalega vuo.” huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Higeno ApalahamuꞋa anile Kalatia vayaꞋmogami mopa neꞋataleno Halani kotega umaineno anilega nefaꞋa falitegeno Anumaya KotiꞋa eteno hutegeno tamakayama menima mainaya mopalela emaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Emaineanagi Anumaya KotiꞋa agaiꞋa atafa hisia mopa nago atupa kanoꞋa ani mopa nagoke aiya malesia mopa oꞋaminegi “HaenagaꞋa kamigahue. Ani mopa atafa hulinesanageꞋya kagaipiti falote hisaya nafaꞋneyagamoꞋya aligahae.” huno hianagi ani kanafina ApalahamuꞋa namo kano maineane.* ");
INSERT INTO kmu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Maineanagino Anumaya KotiꞋa agaifena mage humaineane “KagaikaꞋa kaginagomoꞋya Isaleli nofiꞋma omainaya vayaꞋmogami mopale visageꞋya ani vayaꞋmoꞋya amatafa huꞋya ‘AliꞋyatia aliho.’ huꞋya tusi yate ali haviya humatesageꞋya ani mopalela fo hataletiꞋa (400) kafu maigahae.* ");
INSERT INTO kmu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Maigahayanagi amatafama huꞋyama ‘AliꞋyatima aliho.’ huꞋya humainaya vayaꞋmogamina nagaya kaiyeke humateteꞋna aliꞋna haviya humatesugeꞋya kagai kaginagomoꞋya ani kotegatila eteꞋya ma mopale emaineꞋya nagai nagia alisaga hugahae.” huno humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Anumaya KotiꞋa mage huno humaine “Nagai anagaꞋma maisaya yafe hagelafita maisuna kavala nafaꞋnekamogamina amakoya anoꞋya taga huo.” huno higeno ApalahamuꞋa Aisakina nafaꞋneꞋa ateteno napa eitiꞋa (8) kana maiteno agoya anoꞋya taga humaineane. HaenagaꞋa AisakiꞋa nafaꞋneꞋa Yekopuna ategeno YekopuꞋa haenagaꞋa tuelufuꞋa (12) nafaꞋneyaga tagai taginagomogamina amatene. ");
INSERT INTO kmu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Ani Yosefena nepuꞋamoꞋya Yosefefe tusiꞋa amaipa kafa heteteꞋya avaleꞋya alu vayaꞋmogami neꞋamamiꞋya mone aligeꞋya Isipi kotega avaleꞋya vayanagi Anumaya KotiꞋa agaiꞋene maineno kanama haiya yana alitaleno kanale agu agesa amigeno Isipi sauve kanoa, Felona, aulagale hetigeno FeloꞋa muse huno “Hagote kava kano maineka nagai noꞋyagaene mukiꞋa Isipi kotega kava yagaigane.” huno hutene. ");
INSERT INTO kmu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Hutetegeno mainegeno Isipi kotegaene Kenani kotegaene nagola tusiꞋa kafu haya kana efalote higeꞋya tototimogamina kaveꞋamia omalegeꞋya tusiya huno amakala lemainae. ");
INSERT INTO kmu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amakala legeno YekopuꞋa “Isipi koteꞋma kavela hanema.” huꞋya haya kea haviteno nafaꞋneyagaꞋa hagoteno humategeꞋya kaveꞋma hanelega umainae. ");
INSERT INTO kmu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","HaenagaꞋa eteꞋya anile vageno YosefeꞋa “Nagayae tamakanatamimoꞋna mainoe.” huno higeno FeloꞋa Yosefe afamofena havimaine. ");
INSERT INTO kmu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Havitegeno YosefeꞋa nefafena YekopufeꞋene mukiꞋa anagaꞋa seveti faefuꞋa (75) anagaꞋaene ke higeꞋya Isipi kotega umainageno YekopuꞋa anile faligeꞋya nafaꞋneyagaꞋaene tototimoꞋya fali-mainayane. ");
INSERT INTO kmu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","FaligeꞋya eteꞋya aliꞋya Sekemu kumala, ApalahamuꞋa moneleti Hamolo nafaꞋneyagamogami mopa miya higeno amigeno ali-mainea mopafi mo hevaitenae. ");
INSERT INTO kmu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","Anumaya KotiꞋa Apalahamufema hulokiya vai-malenea kemoꞋa fatago huno efalote hisia kanamoꞋa aupa higeꞋya tagai taginagomoꞋya Isipi kumatela falote huꞋya kasago humainageno alu sauve kanoa, Yosefefena oꞋagenea kanomo, eteno sauvea alino humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Falote huno maineno tagai nofi vayala ayemavataga huno huhaviya huneꞋamateno “NafaꞋneya-gatamia hamaesunageꞋya faligahae.” huno tokiyaꞋage ke humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Higeno ani kanafina Mosesena itaꞋamoꞋa atetegeno Anumaya KotiꞋa hau-mainea nafaꞋnegino itaꞋamogani nefagania taliꞋa (3) ikana noꞋanifinaga kava huꞋana ataꞋageno mainaꞋe. ");
INSERT INTO kmu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kava huteteꞋana kumate atenaꞋageno Felo munaꞋmoꞋa ani nafaꞋnea avaleno agaiꞋa nafaꞋne kana huno yagai-maine. ");
INSERT INTO kmu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yagaiteno avo nopi ategeno Isipi vayaꞋmoꞋyama havilinaya yana Mosesena huve-ligeno aliteno tusiya huno tokiyaꞋa haneteno kanale kea nehuno nehia kano maine. ");
INSERT INTO kmu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Maineanagino fotiꞋa (40) kafu huteno mage hie “Isaleli vayaꞋnimogamina momakegahue.” huno agesa havimaine. ");
INSERT INTO kmu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Haviteno mogeana nago Isipi kote kanomoꞋa Isaleli kanomona aiko-neligeno MoseseꞋa moli-neꞋataleno anonaꞋa ani Isipi kote kanoa haegeno fali-maine. ");
INSERT INTO kmu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Faligeno MoseseꞋa ma agesa havimaine “VayaꞋnimoꞋya mage huꞋya hugahae ‘Anumaya KotiꞋa Mosese ayapiti taugafa aligatigahie.’ huꞋya hugahae.” huno agesa havianagi vayaꞋamoꞋya ani amakesa ohavinae. ");
INSERT INTO kmu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ohavigeno MoseseꞋa faeteno mogeana tole Isaleli kanolatana tu nehaꞋageno monaketeno moli-neꞋanataleno mage huno hie “Nenafugatanae tanakaya nagoke konagalata mainaꞋagi naꞋa higetana tua nehaꞋe?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Higeno anima tuma aepa henoꞋma aganaꞋamoma aiko-lia kanomoꞋa Mosesena ayetu-nefeno mage huno hie “Kagaila tagaite kava kano maika kaiyeke fatago hu kano maiyo kea ta kahapaigeka aniꞋa nehane? ");
INSERT INTO kmu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kagayama egama Isipi kanoma hayana kava huka nahaegahe nehano?” huno hie. ");
INSERT INTO kmu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Higeno ani kema hia kehe MoseseꞋa faleno Mitiani kotega mo maineno ala aliteteno maineno haenagaꞋa tole ne nafaꞋnelata anatene. ");
INSERT INTO kmu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Anilegama maiyana fotiꞋa (40) kafu maiteno MoseseꞋa kaꞋme kotega Sainai agoꞋyafi haino mainegeno nago osi yosalela ala ata anefela nelea yapiti nago ensole kanomoꞋa evaꞋyi higeno age-maine. ");
INSERT INTO kmu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Ageteno amaꞋyo neꞋaino agelama hisue huno nehuno avate neꞋegeno AnumayamoꞋa anileti age aino mage huno hie “Nagaya kaginagomogamina Anumaya KotiꞋami mainoe. ApalahamuꞋagi AisakiꞋagi Yekopugami Anumaya KotiꞋami mainoe.” huno higeno MoseseꞋa atali talu huteno ani yama nagoꞋene agesia yafena tusi koli huno oꞋagene. ");
INSERT INTO kmu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Koli nehigeno AnumayamoꞋa mage huno hie “Mamona alu aotage mopa nagaiꞋniꞋa mopagika kaiya anona asagika maletekao. ");
INSERT INTO kmu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nagayama nagai nofi vayaꞋma Isipi nemaiya veaꞋnimoga-mina ali haviyama humataya kavala ago age-mainoe. Avima atayana ago havimaineꞋna amaugafa aligatigahe emainogi. Kagaya eno Isipi kotega hugategahue.” huno Mosesefena hapai-mainea ke huno SitiveniꞋa hamapai-maine. ");
INSERT INTO kmu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mani Mosesefena nayona mage huꞋya humainae “Kagaila kava kano maineka kaiyekea ali fatago hugane huꞋya kea ta kahapaigeka aniꞋa nehane?” huꞋya amakaveꞋno hutenae. Anima amakaveꞋno hutaya kanomona osi yosaleꞋma vaꞋyima humainea ensole kanomoꞋa aya higeno Anumaya KotiꞋa kava humateno amaugafama aligatisia yafe huteneane. ");
INSERT INTO kmu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hutegeno MoseseꞋa Isipi kotega umaineno ani kotegati amavaleno fotiꞋa (40) kafu Isipi kumateꞋene haesa titeꞋene kaꞋme kotegaene kasagoꞋya tokiya avame yaꞋyaga humaineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ani MoseseꞋa Isaleli veaꞋmogamife mage huno hamapai-maine “Anumaya KotiꞋa tamakai vayapiti nagayama huaꞋya huno aune laga hisia kanoa avaleno hetitegahie.” huno hamapai-maineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ani MoseseꞋa kaꞋme kotega maineno mono kema havigahema melitalu humainaya taginagomoꞋyaene maiteno Sainai agoꞋyafi haitegeno nago ensole kanomoꞋa evaꞋyi huno Anumaya Kotina tahaimuꞋma lamisia mono kea Mosesena hapaigeno MoseseꞋa taginagomogamina hamapai-maineane. ");
INSERT INTO kmu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","Hamapai-mainegi taginagomoꞋya “Mosese kea akave omalegahune.” huꞋya amakaveꞋno huteteꞋya Isipi kotega eteꞋya visaya amakesa nehaviꞋya Elonife mage huꞋya humainae “Kateg