﻿USE sofia;
DROP TABLE IF EXISTS sofia.kms_vpl;
CREATE TABLE kms_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kms_vpl WRITE;
INSERT INTO kms_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Kraist ni kimem ningg wand taq pugri. Jisas ni Devit ningg kimem, di Devit Abraham ningg kimem. ");
INSERT INTO kms_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ni Aisak kiyi. Aisak ni Jekop kiyi. Jekop ni Juda kiyi di ni kise kiqam ane. ");
INSERT INTO kms_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ni wo Peres di Sira temi. Peres Sira temi ni kumo Tamar. Peres ni Hesron kiyi. Hesron ni Ram kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ni Aminadap kiyi. Aminadap ni Nason kiyi. Nason ni Salmon kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ni Boas kiyi. Boas ni kumo Rahab. Boas ni Obet kiyi. Obet ni kumo Rut. Obet ni Jesi kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ni King Devit ningg kiyi. Devit ni Solomon kiyi. Solomon ni kumo asi Uria ni ngam. ");
INSERT INTO kms_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ni Rehoboam kiyi. Rehoboam ni Abiya kiyi. Abiya ni Asa kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ni Jehosapat kiyi. Jehosapat ni Jehoram kiyi. Jehoram ni Usia kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ni Jotam kiyi. Jotam ni Ahas kiyi. Ahas ni Hesekia kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ni Manase kiyi. Manase ni Emon kiyi. Emon ni Josaia kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jekonaia ni kiqam ane ni kiyi taq Josaia. Tende puayi wute Babilon kin mandi wute Israel kin mitari mo Babilon taq pu yeru. ");
INSERT INTO kms_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon ruso taq yeru pre dobu wute men mas: Jekonaia ni Sealtiel kiyi. Sealtiel ni Serubabel kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ni Abiut kiyi. Abiut Eliakim kiyi. Eliakim ni Asor kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ni Sadok kiyi. Sadok ni Akim kiyi. Akim ni Eliut kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut ni Eleasar kiyi. Eleasar ni Matan kiyi. Matan ni Jekop kiyi. ");
INSERT INTO kms_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ni Josep kiyi. Josep ni Maria ngaim. Maria ni Jisas wuri wundi wute mari ni Kraist, God ni naip no wute nateri ye. ");
INSERT INTO kms_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pugri bu Abraham nde pu rindi rindi Devit nde te Jisas ni kimem 14 kin pugri, di Devit nde tende pu rindi rindi ni ruso Babilon taq yeru kin tende puayi te Jisas ni kimem 14 kin pugri. Di ni ruso taq yeru kin tende puayi te oyi rindi rindi Kraist nas kin tende puayi Jisas ni kimem munene 14 kin pugrine. ");
INSERT INTO kms_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Kraist ni kumo wuri wundi kin wand taq pugri: Jisas ni kumo Maria ni Josep nitaqi puq mindig, pudi ni wundi teri rise segine ni nuqond yabe ni wo ane wus. Ni Ququ Yuwon Ye nari ni wo ane wus. ");
INSERT INTO kms_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ni ngaim Josep ni wuti yumbo tuquine puq nen ye, pugri bu ni quan rar mingi Maria minyuw new yambu nari. Ni nei namb kin ni waghi grine ni puaq nindiq. ");
INSERT INTO kms_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ni pugri nei namb namb nas, bur ire Yumbui ningg angelo nandi ni ruqo nyemb pe simbe nindig nari, “Josep, Devit ningg kimem, nu Maria taqi kin te ningg wune ghamb wayequ. Nu tungu, te Ququ Yuwon Ye ningg gre pe bu Maria wo ane wus. ");
INSERT INTO kms_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ni wo quayi wo wuri wundi, di nu ni nyamb rang Jisas ei puq ndig, te pugri ni ei nikin wute ni yumbo ur brequ rind kin wand te puaq nindiny di nate ruwi ye.” ");
INSERT INTO kms_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yumbo ur ren ruwi kin ren asi Yumbui propet iri nde gri simbe nand ye te tuqui nap ningg. ");
INSERT INTO kms_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Wand taq ren: “Otiwo nyumbueg ambonye ire ni quayi teri rise segine di ni wo ane wus, di ni wo quayi wo ei wuri wundi ye. Di ni nyamb mirang Emanuel puq mindig.” Nyamb ven kin puate te pugri, God beghi ane pas. ");
INSERT INTO kms_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Muq Josep ni ruqo nase pu nes newo, ni Yumbui ningg angelo simbe nindig kin pugrine puq nen. Ni Maria nitaqi, ni ngam. ");
INSERT INTO kms_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pudi ni Maria teri rise segine ruso ruso Maria ni wo wuri wundi. Di ni nyamb nirang Jisas puq nindig. ");
INSERT INTO kms_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas ni kumo wuri wundi kin tiqe Betlehem Judia opu yequ kin, tende puayi Herot ni king ningg nas. Jisas ni kumo wuri wundi pre dobu, muq wute ninge quan nganye nei mamb kin nginy nawi opu mas kin ni Jerusalem mandi. ");
INSERT INTO kms_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Di ni pengu mand, “Wo iri kumo wuri wundi, wo te otiwo Juda mingg king ningg ei nas ye. Muq wo te muai? Beghi ni tomnji nginy nawi opu tende buqoid di beghi badi ni yumbui nyamb birag ningg.” ");
INSERT INTO kms_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herot ni wand ven nutungu, ni quan nganye nei kumo namb, di Jerusalem kin wute buagi anene nei kumo rimb. ");
INSERT INTO kms_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot ni nari prist mingg yumbui di wute lo wute bei meny kin te ninde mandi di ni pengu nindim, “Asi God ni nari Kraist ni muai opu ei kumo wuri wundi?” ");
INSERT INTO kms_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ni oyi mindig mari, “Ni tiqe Betlehem Judia opu tende ei kumo wuri wundi ye. Te pugri propet ni pugri ur nand: ");
INSERT INTO kms_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nu Betlehem, Juda mingg qi pe yengu kin, nu tiqe aye nde si nambu yeru segi, nu nyamb yumbui. Nu nde wuti iri yumbui ningg nas, di nge sipsip Israel kin te yeng nuany, ninde si nambu yeru’.” ");
INSERT INTO kms_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Muq king Herot ni wute nginy nawi opu mas pu mandi kin te waghi grine ngam niram mandi, ni tomnji pughe puayi muqoind kin te kin ningg pengu nindim. ");
INSERT INTO kms_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Muq ni tiqi nundom Betlehem mo. Ni nari, “Nungoqi wo, otinde wo te ningg meri wat, nungoqi wuqoind, ate wandi nge simbe wundigh, ei nge mune ko di ni yumbui nyamb girag ningg.” ");
INSERT INTO kms_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ni king ningg wand mutungu, di ni mo mo ngimi ni tomnji asi nginy nawi opu muqoind kin te mune muqoind. Ni tomnji te mune muqoind di ni quan nganye chumbuai mand. Ni tomnji te muqoind, ni ye nawo no Jisas nas kin tende tuquine muq newo yenu. ");
INSERT INTO kms_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ni mo mitari righe be baj pe mar mo, di Maria ni wo ane tende rir ris kin te muqond, ni sungomyu gure mawo, yimb maghe, di Jisas yumbui nyamb mirang. Muq ni tami bi mawo, yumbo ninge ni meng. Ni gol, di yumbo yuwon tuqo wuri kin ire frankinsens puq munduw kin te, di ire mur puq munduw kin te meng. ");
INSERT INTO kms_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ni bur mase, ruqo nyemb pe God ni simbe nindim nari, “Nungoqi Herot nde gri wo wayequ.” Pugri bu ni mes mewo, ngim aye pe gri nikin tiqe mo. ");
INSERT INTO kms_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wute nginy nawi opu kin mo pre Yumbui ningg angelo Josep nde nandi, ruqo nyemb pe ni simbe nindig nari, “Tumo di Herot ni wo meri niting, ni nuqoind tedi ni nati ningg. Nu yes yewo, wo kumo teri tari wu wase Isip wo. Nungoqi Isip ne was ruso ruso ngene nu simbe guduw, muqdi mune wandi.” ");
INSERT INTO kms_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Muq Josep ni nes newo, Maria Jisas teri nitari, burne wu rise Isip ruso. ");
INSERT INTO kms_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ni ruso Isip di tene ris ris Herot nati. Ni pugri puq ren ei asi Yumbui ni propet nde gri ni simbe nand ye ane tuqui. Ni pugri puq nand, “Nge wo ni Isip nas pu nge kari ni Isip si niraq di nandi.” ");
INSERT INTO kms_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot ni nei namb wute nginy nawi opu mas pu mandi kin ni wandoqi mindig, bu ni quan nganye umbo ker nawo. Ni wute ninge tiqi nundom mo Betlehem di tiqe ninge Betlehem tumo yeru kin tende mo di quayi wo buagi mi mati. Wo buagi ber teri pu riti ri kin te mine omo mawo. Wute nginy nawi pe opu mas pu mandi kin ni tomnji muqoind di nyinge mare mandi Herot nde mi meyi kin te muq ber teri ruso pre. Pugri bu wo buagi ber teri pu di riti ri kin te mi matine omo. ");
INSERT INTO kms_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yumbo ren te wand propet Jeremaia nde gri rindi kin ane tuquine, ni pugri simbe nand nari, ");
INSERT INTO kms_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Yumbui quanji di ngaim suai ane tiqe ire Rama puq munduw kin tende ruwi. Te Resel ni wo riti ye te ningg ni ngaim suai wumb di quanji wund. Ni wute umbo rew kughe te ni yambu wuri. Te pugri ni wo quan buagine riti pre.” ");
INSERT INTO kms_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot ni nati pre, di Yumbui ningg angelo Josep ruqo nyemb pe Isip tende simbe nindig, ");
INSERT INTO kms_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","di nari, “Yes yewo, wo kumo teri tari Israel mingg qi pe yo, te pugri wute ni mi puq mand kin te yabe mati pre.” ");
INSERT INTO kms_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Muq Josep nes newo, kumo wo teri nitari di ni mune Israel mingg qi pe ruso. ");
INSERT INTO kms_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pudi muq Josep ni nutungu te pugri Arkelaus ni kiyi Herot ningg sunyi nitangvi, ni Judia mingg yumbui ningg nas, bu ni tende ruso kin wune namb. Pudi God ni ruqo nyemb pe Josep yeri nindig, muq ni Galili opu ruso. ");
INSERT INTO kms_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Di ni no, tiqe ire Nasaret puq munduw kin tende no nas. Muq Yumbui ni propet nde gri simbe nand kin te ane tuquine. Ni nari, “Wuti nen Nasaret kin puq mindig ye.” ");
INSERT INTO kms_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tende puayi Jon wute wuye nap kin ni nandi, Judia opu mong ire nyumo di wuye segi ye pe tende wand bir nawo. ");
INSERT INTO kms_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ni pugri puq nand, “Nungoqi nei ware witinde, yumbo yumbo buagi God nde si nambu rise kin ngeri te tumo rind pre.” ");
INSERT INTO kms_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ningg asi Yumbui ni propet Aisaia nde gri simbe nand nari, “Wuti iri mong nyumo di wuye segi ye pe tende yenu di ngam nare nari, ‘Yumbui ngim wuang, di ngim sabi wundig pu wuse ei ni nyinge nare’.” ");
INSERT INTO kms_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ni chongo kamel iny pe yembe munduw kin te niraq wughe, di let kau chongo pe yembe mindig kin te apqe pe taq naimb. Ni quanj di gimeti nyoq ane ne. ");
INSERT INTO kms_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tende puayi wute buagi Jerusalem kin di Judia opu kin di tiqe buagi Jordan wuye qunambe yeru kin te Jon nde ruso. ");
INSERT INTO kms_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ni ruso ni yumbo ur brequ yembe rindiny kin te simbe rind pre di Jon ni wuye Jordan tende wuye nap. ");
INSERT INTO kms_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Muq Jon ni Parisi di Sadyusi nganye buagi ni wuye nap kin sunyi tende mandi nuqond, di ni pugri simbe nindim nari, “Nungoqi ghati sindiyu wo! God wute mai neny puq nand kin te tumo rise. Tughe nungoqi simbe nunduq bu God ni mai neuq kin te ningg wu wase wandi? ");
INSERT INTO kms_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nei ware witinde, di nungoqi yumbo ur wand kin te wute nei mare mitinde pre kin yumbo ur te bei wand. ");
INSERT INTO kms_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eti nungoqi umbo pe pugri nei wamb wari, ‘Beghi Abraham ningg kuqo, pugri bu God beghi mai nengu segi ye.’ Nge nungoqi simbe guduq, God segine wet men mas kin men oyi nare nitinde di Abraham ningg kuqo mingg mas. ");
INSERT INTO kms_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","God ningg mame puate asine nyumo puate pe tende wuse, nyumo buagi yi oghi kin riyi segi kin te enare di wase pe ni riwo namb. ");
INSERT INTO kms_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nge nungoqi wuye pe wuye kupuqu kin te nungoqi umbo ware witinde pre kin te ningg bu nge wuye kupuqu. Pudi wuti iri nge nde dobu nawi kin ni ningg gre te nge gre ane tuqui segi, ni gre quan nganye. Nge wuti yuwon nganye segi, pugri bu nge ni su kiraq ye tuqui segi. Nge wuye pe wuye kupuqu, pudi wuti nen di nungoqi Ququ Yuwon Ye di wase pe wuye nupuqu ye. ");
INSERT INTO kms_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ni nandi di sawol niraqne nandi di wit dang nand kin sunyi raqe nand. Wit yi ir nawo, nikin wit oghi kin mir baj pe nawo ris, di raqe dubu ane wase awu kuso tuqui segi ye pe nande namb.” ");
INSERT INTO kms_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tende puayi Jisas ni Galili si niraq no Jordan wuye pe. Ni no Jon nuqoind ei Jon ni wuye naip ningg. ");
INSERT INTO kms_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pudi Jon ni Jisas segi puq nindig nari, “Nge ei nu nde godo di nu nge wuye ghaip, pughe kin ningg nu nge nde guadi?” ");
INSERT INTO kms_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pudi Jisas ni oyi nindig nari, “Te piyi, muq nu nge wuye ghaip. Beghi pugri puq pen ei God ni nari kin te ane tuquine puq pen.” Pugri bu ni Jisas ningg wand tene nutungu. ");
INSERT INTO kms_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon Jisas wuye naip pre di brequne ni wuye pe pu newo no no di rar nat. Di nginy tu bi viso, ni nuqond God ningg Ququ wapi mabri kin pugri nati ni, ni nde nas. ");
INSERT INTO kms_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Di wuti iri nginy tu wam pu nari, “Wuti nen nge wo. Nge ni quan nganye yawo girag righe, di nge ni ningg quan nganye chumbuai gad.” ");
INSERT INTO kms_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ququ Yuwon Ye Jisas nitanyi mong wuye di nyumo segi ye pe tende no ei Satan ni Jisas wandoqi nindig ningg. ");
INSERT INTO kms_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas ni mir ane yenu yenu nginy 40-pela pu di bur 40-pela pu, be ni quan nganye mir gureg. ");
INSERT INTO kms_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tende puayi muq ququ brequ wute wandoqi nindim kin nandi, Jisas ningg nari, “Nu nganyene nganye God ningg wo, tedi wet men simbe ndim bret mase.” ");
INSERT INTO kms_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pudi Jisas ni oyi nindig nari, “God ningg buk wuri, ‘Wuti iri ni bret ninggne nas tuqui segi. Ni God ningg wand te nutungu tedi gre nand kin tuqui’.” ");
INSERT INTO kms_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Muq Satan Jisas nitanyi tiqe yumbui Jerusalem no, te God ningg tiqe. Ni Jisas nitanyi God ningg baj gug wam nganye nase kin pe tende newo no yenu. ");
INSERT INTO kms_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Muq ni Jisas simbe nindig nari, “Nu nganyene nganye God ningg wo, tedi nu wam ren pu prare yaghe. Te pugri God ningg buk wuri, ‘God nikin angelo ningg nari mandi nu yeng muaw yuwon. Di ni ei nu mait ghase ghasene yaghe yo, ei nu wet pe nyinge dang ghand ye tuqui segi’.” ");
INSERT INTO kms_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pudi Jisas oyi nari, “God ningg buk wuri, ‘Nu Yumbui nu non God ni gre tuqui ghap wayequ’.” ");
INSERT INTO kms_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Muq ququ brequ mingg yumbui ni mune Jisas nitanyi rand iri dobui nganye pe tende mewo mo, muq ni qi pe kin kantri buagi di yumbo yuwon yuwon kin buagi qi pe ven nde yeru kin te bei neng. ");
INSERT INTO kms_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Di ni Jisas simbe nindig nari, “Nu nge ningg sungomyu gure ghawo di nge yumbui nyamb ragh, tedi nge yumbo buagi ren quan buagine nu kew.” ");
INSERT INTO kms_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Muq Jisas ni simbe nindig nari, “Satan, nu kring yo. God ningg buk wuri, ‘Nu Yumbui nunon God ei yumbui nyamb rang di ni ningg yembene ei ghand’.” ");
INSERT INTO kms_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pugri bu Satan ni Jisas si neri, muq angelo ni Jisas nde mondo di sabi mindig. ");
INSERT INTO kms_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisas ni nutungu Jon taq maimb pre, muq ni nyinge nare Galili opu no. ");
INSERT INTO kms_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ni Nasaret si niraq di no Kaperneam nas. Kaperneam ni Galili wuye ngamo qunambe ne yequ. Ni Sebulun di Naptali ninde qi pe yequ. ");
INSERT INTO kms_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas yumbo ur ren yembe nindiny kin ren, asi Aisaia, propet kin iri, ni ningg wand te ane tuquine. Aisaia ni pugri puq nand: ");
INSERT INTO kms_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun di Naptali mingg qi te Galili wuye ngamo pe tumone, di wuye Jordan pu opu gri ruso. Qi puch te Galili puq munduw. Wute Juda segi kin ni tende mas. ");
INSERT INTO kms_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wute men burpoq pe mas di ni ti yumbui muqond. Ni God nei mimbig segi bu ni mati kin pugri mas, di God ni ti nem.” ");
INSERT INTO kms_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tende puayi Jisas ni urupui yembe nand, quayi nyumbueg nde wand bir nawo nari, “Nungoqi nei ware witinde, te pugri yumbo buagi God nde si nambu rise kin ngeri te tumo rind pre.” ");
INSERT INTO kms_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas ni Galili wuye ngamo qunambe nyinge nare no. Ni nyinge nare no wute temi nuqond, iri Saimon di ni kiqam Andru. (Saimon ni Pita puq nindig.) Ni temi yawi wuye pe memeri naghe ei umo materi ningg. Wute men te wute umo meri mand ye. ");
INSERT INTO kms_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Di ni nari, “Nungoqi nge nde dobu wawi, di nge wute wateri ye te kin bei keuq.” ");
INSERT INTO kms_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Muq ni brequne yawi si mare di Jisas nde dobu maru. ");
INSERT INTO kms_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Di ni mune nyinge mare mo, wute aye mune kise kiqam temi nuqond. Jems Jon temi di ni Sebedi ningg wo. Ni kiyi ane at pe yemu yawi bir mas kin te sabi mindim mindim yemu Jisas nandi nari, ");
INSERT INTO kms_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","di ni brequne at di ni kiyi ane si mare, di ni temi mondo Jisas ane mo. ");
INSERT INTO kms_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas ni no tiqe buagi Galili opu yeru kin tende nar ir no. Ni no God yumbui nyamb mirang kin baj manyi pe nar no, di wute wand puate bei neny. Ni wand yuwon ye God ni king ningg nas kin wand bir nawo, di ni wute num isis kureny kin te sabi nindiny. ");
INSERT INTO kms_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wute buagi kantri Siria ris kin ni Jisas ningg wand te rutungu. Pugri bu ni wute buagi num kureny, di ni ghimbi quan nganye yuqo riti kin, di wute ququ brequ ninde yemu kin, di wute pripri rar ori riti kin di wute si nyinge riti kin te rire Jisas nde rindi di ni sabi nindiny oghi. ");
INSERT INTO kms_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Muq wute buagi Galili kin di tiqe aye 10-pela pu te kin, Jerusalem, Judia di tiqe ninge Jordan wuye opu gri yeru ye te rindi Jisas ane ruso. ");
INSERT INTO kms_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas ni wute tit te nuqond di newo no rand pe nas. Nikin wute mandi quir quar mindig, ");
INSERT INTO kms_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","di ni wand puate bei neny nari: ");
INSERT INTO kms_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wute tughe ni God nde rar pe ni si omone yeru kin te ni chumbuai rind, te pugri tumo di ni God nde si nambu ris. ");
INSERT INTO kms_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Wute tughe quanji rind rind ris kin te ni chumbuai rind, te pugri God ni umbo neny kughe ye. ");
INSERT INTO kms_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Wute tughe ni nikin nyamb rindivi viyo segi kin te ni chumbuai rind, te pugri God ni yumbo neny puq nand kin te riteri ye. ");
INSERT INTO kms_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Wute tughe ni yumbo ur tuquine kin te ningg ni mir pugri kureny kin te ningg riri kin te ni chumbuai rind, te pugri God ni tuqui nap ye. ");
INSERT INTO kms_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Wute tughe ni wute aye yawo rutony kin te ni chumbuai rind, te pugri God ni oyi yawo nitony ye. ");
INSERT INTO kms_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Wute tughe ni God nde rar pe umbo yuwon kuse ye te ni chumbuai rind, te pugri ni God ruqoind ye tuqui. ");
INSERT INTO kms_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Wute tughe ni wute aye ker ruwo di rege kin te gure ruwo ye te ni chumbuai rind, te pugri God ni ningg nari, ‘Nge wo.’ ");
INSERT INTO kms_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Wute tughe ni yumbo ur tuquine kin yembe rindiny ye te ningg wute aye ni brequ mindiny ye te ni chumbuai rind, te pugri tumo di God ni king ningg nas di wute ren ninde si nambu ris. ");
INSERT INTO kms_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pudi wute ninge nungoqi rundoqu, di nge ningg bu ni nungoqi aru runduq, di brequ runduq, di nungoqi unje ripuqu ningg mai isis reuq, te kin ningg nungoqi chumbuai wand. ");
INSERT INTO kms_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nungoqi umbo yuwon gud di chumbuai wand, te pugri God nungoqi oyi nunduq kin yumbo yumbui nganye nginy tu wam nuauq rise. Te pugri ni asi propet brequ mindim kin pugrine muq nungoqi mune brequ munduq. ");
INSERT INTO kms_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nungoqi ghat kin pugri qi pe ven nde was. Pudi ghat ni nyong te omo, tedi pughe gri ei puq wen di ghat asi nyong vimb kin pugrine mune nyong vise? Ghat ven oghi vise tuqui segi, pugri bu wute memare viso ei wute buagi rindi nyinge ruwo. ");
INSERT INTO kms_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nungoqi qi pe kin ti kin pugri. Tiqe yumbui ire rand pe yequ kin ni suqo wuso ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Di wuti iri ni lam nindiq, os pe nuaq wughe tuqui segi. Ni nitaqwi ede pe neq wiyo pu wus, ei wute buagi baj pe mas kin te ti wem. ");
INSERT INTO kms_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Te kin pugrine ei ti nungoqi nde rise kin te wute buagi nde ti nase, te ei ni nungoqi yumbo ur oghi ye yembe wundiny kin te ruqond, di ni God nungoqi nuyi wam ye te nyamb rindivi viyo.” ");
INSERT INTO kms_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas ni mune nari, “Eti wari nge gadi Moses ningg lo di propet mingg wand te puaq gad. Te segi. Nge gadi kin te ni mingg wand te ane tuquine puq ken ningg. ");
INSERT INTO kms_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nge nganyene simbe guduq, qi nginy tu anene pre ye, pudi lo kin wand puch ire pre ye tuqui segi. Ni ur mand kin di ur puch woju lo pe ur mand kin te quan buagine di rise. Lo ni pugrine wuse ruso otiwo yumbo yumbo buagi lo puq wund kin te nganyene ruwi. ");
INSERT INTO kms_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wuti iri ni lo puch wojiju nganye te gure nuaq di ni wute aye te yeri nindiny di ni mune lo gure ruaq, tedi wuti te wute buagi God nde si nambu yeru kin ninde nyamb yumbui segi. Pudi wuti iri ni lo te nutungu di wute aye te yeri nindiny di ni mune lo rutungu, tedi wuti te wute buagi God nde si nambu yeru kin ninde nyamb yumbui vise. ");
INSERT INTO kms_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nge nungoqi simbe guduq, nungoqi yumbo ur tuquine kin te Parisi di wute Moses ningg lo wute bei meny kin ni mingg yumbo ur tuquine kin te ane tuqui segi, nungoqi mune quan nganye yumbo ur tuquine kin yembe wundiny segi, tedi nungoqi God nde si nambu yequ tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas ni mune simbe nand nari, “Nungoqi wand ven asi nungoqi nuqo simbe mindiny kin te wutungu pre. Ni mari, ‘Nu wute ghamb riti wayequ. Muq wuti iri no wuti aye iri ni nati, tedi ni kot sunyi pe no.’ ");
INSERT INTO kms_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pudi nge nungoqi simbe guduq, wuti tughe ni kimand ker nuang, tedi ni kot sunyi pe no. Di wuti tughe ni kimand wand aru nindig, tedi ni no kaunsil mingg yumbui te nuqond. Di wuti tughe ni kimand simbe nindig nari, ‘Nu jebo gad iri,’ tedi ni wase wute brequ ye mo kin tende no. ");
INSERT INTO kms_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Pugri bu nu yumbo God gueg ningg kuare alta pe guadi, muq nu nei guab nu nimand tequ wand ninge rise, ");
INSERT INTO kms_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","te nu yumbo alta pe tumone si ghare ris. Di nu yo nimand tequ wand teti wawo pre, muqdi nu mune ghandi yumbo te God yeng. ");
INSERT INTO kms_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pugri bu wuti iri nu kotim naind, muq tequ nyinge ware kot sunyi pe wo ningg, ate buid ghap ei nungoqi tequ ngimine wand te teti wawo. Eti wuti te nu jas nde si pe ni ghondo, di jas oyi polis nde si pe ni ghondo, di polis oyi meti ghowi taq maimb. ");
INSERT INTO kms_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nge nungoqi nganyene simbe guduq, eti nu taq pune yeru ruso ruso wet bidi nu manyi mew kin te ane tuquine tedi pre.” ");
INSERT INTO kms_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas ni mune simbe nand, “Nungoqi wutungu ni yabene simbe mand mari, ‘Nu ngam kin ane wase wayequ.’ ");
INSERT INTO kms_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pudi nge nungoqi simbe guduq, wuti iri ni nyumbueg ire nundoq, muq ni nyumbueg tende nei vise, wuti te ni umbo pe nyumbueg te teri rise pre. ");
INSERT INTO kms_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pudi nu rar si tuan pe opu kin te yumbo ur brequ yembe wundiny, tedi bi waq meraq wuso. Nu ghimbi puch ire ir wuso kin te musoq yuwon, pudi ni mandi nu ghimbi quanene wase pe memare riwo te quan nganye brequ. ");
INSERT INTO kms_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Di nu si si tuan pe opu kin ni yumbo ur brequ gud, tedi di ghawo meghare kuso. Nu ghimbi puch irene ir viso kin te musoq yuwon, pudi nu ghimbi quanene wase pe viso te quan nganye brequ.” ");
INSERT INTO kms_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ni simbe nand nari, “Nungoqi wutungu God ningg buk wuri, ‘Wuti tughe ni ngam puaq nindiq, ate nyumo raqe ire ni ngam puaq nindiq kin te kin ningg ur nindiq new.’ ");
INSERT INTO kms_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pudi nge nungoqi simbe guduq, wuti iri ni ngam quayi aye wand weng segi pu ni puaq nindiq, di ni puq nen bu nyumbueg te ngam kin lo gure waq. Te pugri ni quayi aye wutanyi bu ni ngimne nyumbueg kin pugri wus. Di quayi aye ni nitaqi kin te mune ngam kin lo gurene nuaq.” ");
INSERT INTO kms_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas ni wand aye mune simbe nand nari, “Wand aye nuqo ni ritevi di nungoqi simbe runduq wutungu pre kin te pugri, ‘Nungoqi Yumbui nde rar pe wand ninge taq wamb, tedi nungoqi wand gure wawo wayequ. Yumbui nde rar pe wand taq wamb kin te kin pugrine ei puq wen.’ ");
INSERT INTO kms_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pudi nge nganyene simbe gad, nungoqi yumbo ninge pe wand ire gre weny wayequ. Nungoqi nginy tu wam tende pe wand ire gre weny wayequ, te pugri nginy tu wam te God ni sia king. ");
INSERT INTO kms_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nungoqi wand ire qi pe gre weny wayequ, te pugri qi te God ni nyinge ni viyo kin. Nungoqi Jerusalem nde wand ire gre weny wayequ, te pugri Jerusalem te king yumbui ni tiqe. ");
INSERT INTO kms_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Di nungoqi nde ngawu pe wand ire gre weny wayequ, te pugri nungoqi nde ngawu pe yu iri puq yeng quem namb o quari namb tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nungoqi ngiq wand ate ngiqne wand, nungoqi segi puq wand ate segine puq wand. Nungoqi wand te gre weny ningg di wand aye wawo righe kin te Satan ninde pu vindi.” ");
INSERT INTO kms_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas ni pugri puq nand, “Nungoqi wutungu asi pugri puq mand, ‘Wuti iri ni wuti aye iri rar cheiq niping, ate nungoqi oyi mune wuti te rar cheiqne wuping. Wuti iri ni wuti aye iri sawo paqe nuang, ate nungoqi oyi mune wuti te sawo paqene wang.’ ");
INSERT INTO kms_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pudi nge nungoqi simbe guduq, wuti iri nungoqi unje nupuqu, nungoqi oyi ni unje waip wayequ. Muq wuti iri nungoqi kowisambe si nganye pe opu kin dang nunduq, te piyi rar wuqoind opu gri mune dangne nunduq. ");
INSERT INTO kms_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Di wuti iri nu kot pe nitanyi no di jas simbe nindig ei nu siot te ni neti nowi ningg, tedi nu saket te anene ni yeng ei oghi. ");
INSERT INTO kms_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Di wuti iri ni nari nu tami rang yo 1 kilomita, ate nu rang yo 2 kilomita. ");
INSERT INTO kms_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muq wuti iri nu yumbo ninge ningg sang nupuw, te nu yumbo yeng. Muq wuti iri nu yumbo niraw no di otiwo mune nare nandi ningg nari, te nu si rang nare no.” ");
INSERT INTO kms_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas ni mune wand simbe nand nari, “Asi nungoqi simbe munduq mari, ‘Nu wute aye nunde tumo ris kin te yawo rany righe, di veri te yambu reny.’ ");
INSERT INTO kms_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pudi nge nungoqi simbe guduq, nungoqi veri yawo wurany righe, di nungoqi God pengu wundig ei ni wuti nungoqi unje nupuqu mai isis neuq kin te yuwon nuang. ");
INSERT INTO kms_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Te ei nungoqi God nungoqi nuyi wam nas ye ni ningg wo. Te pugri ni nari wute brequ ye di oghi ye ane tende nginy neyi, di ni nari wute tuquine ris ye di wute brequ ye ane tende wuye wundi. ");
INSERT INTO kms_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nungoqi wute yawo rirauq righe kin tene yawo wurany righe, tedi pughe gri ei God ni nungoqi yumbo wam nuauq rise kin te wateri? Wute takis materi kin ni pugri qa puq men ye. ");
INSERT INTO kms_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Di nungoqi nimand tene chumbuai kin wand wem, tedi nungoqi yumbo ur te oghi nganye segi. Juda segi kin ni pugri qa puq ren ye. ");
INSERT INTO kms_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pugri bu nungoqi yuwon nganye ei was. Nungoqi nuyi wam nas kin ni quan nganye yuwon nas, te kin pugrine nungoqi mune yuwon nganye ei was.” ");
INSERT INTO kms_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas ni mune simbe nand nari, “Nungoqi nei wumbiq yuwon, nungoqi yumbo ur tuquine kin wute aye nde rar pe bei wand ei ni rundoqu di ni nungoqi nyamb rindivi viyo ningg wari muq bei wand wayequ. Nungoqi pugri puq wen, tedi nungoqi nuyi nginy tu wam yumbo oyi nunduq kin manyi nunduq segi. ");
INSERT INTO kms_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pughe puayi nungoqi wute yumbo segi kin te yumbo weny ningg, eti wuti iri no wub namb di wute buagi nei rimb kin pugri. Nungoqi pugri puq wen wayequ. Wute nei tevi kin ni pugri qa puq men, ni mo God yumbui nyamb mirang kin baj pe di tiqe moqine yemu pugri puq men ei wute ni nyamb rindivi viyo. Nge nganyene simbe guduq, wute te ni nyamb rindivi viyo, pudi God ni yumbo nuam rise segi. ");
INSERT INTO kms_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pudi nu wute yumbo segi kin te yumbo kueny ningg ate nu si tuan yumbo ur yembe gudiny kin te si qaqi nei gub wayequ. ");
INSERT INTO kms_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Te ei wute buagi ni nei rimb segi. Di nu nuyi ni nuqond nu waghi grine pugri puq kuen, tedi nu yumbo yumbui manyi nunduq kin te ghateri tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas mune nari, “Nungoqi God pengu wundig ningg, eti nungoqi wute nei tevi ye puq men kin pugri puq wen. Ni God yumbui nyamb mirang kin baj pe mo di tiqe moqine mes pu yemu God ane wand ei wute buagi ni ruqond yawo kurem. Nge nganyene simbe guduq, ni oyi kin te materi pre. ");
INSERT INTO kms_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pudi nu Yumbui pengu gudig ningg, ate nu yo baj pe ghar yo, ngim yiqu, di nuyi suqo pu nas kin te pengu ndig. Di nu nuyi nu nuqoind nu suqo grine puq kuen, tedi ni yumbo yumbui manyi nunduq kin te ghateri tuqui. ");
INSERT INTO kms_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pughe puayi nungoqi Yumbui pengu wundig ningg, nungoqi wand isis simbe wand wayequ. Juda segi kin ni pugri puq men. Ni pugri nei mamb, ni wand dobui mand ei nikin god ni wand mutungu. ");
INSERT INTO kms_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nungoqi ni puq men kin pugri puq wen wayequ. Te pugri nungoqi nuyi pengu wundig segine ni nei namb pre nungoqi yumbo pughe ye segi bu ni pengu wundig. ");
INSERT INTO kms_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nungoqi Yumbui pengu wundig ningg, te pugri ei pengu wundig: ‘Beghi wuyi, nu wam kuas ye, beghi nu pengu buduw ei nu wute nei yeny ei ni riri nu nyamb yuwon nganye. ");
INSERT INTO kms_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Beghi nu pengu buduw ei wute di yumbo buagi nunde si nambu ris ye ngeri te tumo ndiny. Wute wam mas kin ni nu kuari kin wand mutungu kin pugrine ei wute qi pe kin mune puq men. ");
INSERT INTO kms_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Beghi nginy manyi manyi mir yengu. ");
INSERT INTO kms_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Beghi wute aye unje rupumu kin te beghi wand puaq bidiny kin pugrine nu oyi beghi unje pap kin wand te puaq ndug. ");
INSERT INTO kms_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Di beghi yumbo wandoqi rundug kin te si ghare rindi wayequ, pudi nu beghi Satan ningg imb wangu.’ ");
INSERT INTO kms_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Wute nungoqi unje rupuqu kin te wand puaq wundiny, tedi nungoqi nuyi wam nas kin te ni oyi nungoqi mune wand puaqne nunduq. ");
INSERT INTO kms_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pudi nungoqi wute wand puaq wundiny segi, tedi nungoqi nuyi nungoqi unje wap kin wand te mune puaq nunduq segi.” ");
INSERT INTO kms_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Di Jisas mune nari, “Di pughe puayi nungoqi Yumbui nyamb wundivi viyo ningg mir uny yequ, nungoqi yivany kin quenge nase wayequ, eti wute nei tevi kin puq men kin pugrine puq wen. Ni quenge nati di inyap mamb ei wute muqond di nei mamb wute te ni mir ane yemu. Nge nganyene nungoqi simbe guduq, wute te ni oyi kin te materi pre ye. ");
INSERT INTO kms_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pudi nu mir segine yo ningg, nu quenge wuye ghaip di yu puraq ghand, ");
INSERT INTO kms_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","te ei nu mir ane yengu kin te wute buagi nei rimb segi. Pudi nu nuyi suqo pu nas kin nine nei namb, di ni nuqond nu suqo grine puq kuen, tedi ni oyi nunduq kin yumbo manyi nunduw kin te ghateri tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Di Jisas mune nari, “Nu qi pe ven nde nu yumbo isis yirur ei nu yumbo quan rise ningg ghari wayequ. Qi pe ven nde choi di bughi ane yumbo te brequ rindiny, di wute nyungu ye mandi baj bir mawo mar mo yumbo te nyungu mand. ");
INSERT INTO kms_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pudi nungoqi yumbo wirur kin te nginy tu wam kin te ningg ei wirur. Nginy tu wam te choi di bughi ane yumbo te brequ rindiny segi, di wute nyungu ye mandi baj bir mawo mar mo yumbo te nyungu mand tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tiqe nu yumbo ris kin te nu nei mune tendene ei vise.” ");
INSERT INTO kms_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Di Jisas mune nari, “Rar ni ghimbi pe kin ti. Nu rar oghine wuse, tedi nu ghimbi quanene ti rise. ");
INSERT INTO kms_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pudi nu rar brequ wuse, tedi nu ghimbi quanene burpoq rip. Pugri bu nu ghimbi pe kin ti te burpoq rip, tedi burpoq te quan nganye yumbui. ");
INSERT INTO kms_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wuti iri ni nginy iri ninggne wute temi nde yembe nand tuqui segi. Ni pugri puq nen tedi ni iri yambu nireng, di iri yawo nirang righe. Di ni iri ningg wand nutungu, di iri dob neng. Te kin pugrine nungoqi God di wet bidi ane si nambu was tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pugri bu nge nungoqi simbe guduq, eti nungoqi non ghimbine nei wumbiny wari, ‘Beghi mir pughe ye bri pe, di wuye pughe ye bri pe?’ O wari, ‘Beghi chongo pughe ye bri pare righe?’ Pudi mir chongo ane te yumbui segi, beghi pas pas otiwo kin te quan nganye yumbui. ");
INSERT INTO kms_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nungoqi wapi te wuqond. Ni mir ri righe segi, di ni mir riteri mir baj pe ruwo ris segi. Pudi nungoqi nuyi wam nas kin ni mir bag namb. Pudi wapi ni yumbui segi, nungoqi quan nganye yumbui. ");
INSERT INTO kms_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Di nungoqi yumbo ren nei wumbiny kin te ningg was chiraq tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Di nungoqi pughe kin ningg chongo ningg yivany ware? Nungoqi sare bori kis ur ur kin te wuqond. Ni yembe rind segi, di nikinne chongo yembe rindiny segi. ");
INSERT INTO kms_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pudi nge nungoqi simbe guduq, asi king Solomon ni chongo ur yuwon yuwon kin buagi te nare righe, pudi ni chongo quan nganye yuwon segi. Sare bori kis ur ur kin te ni quan nganye yuwon rind. ");
INSERT INTO kms_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Muq nyungo buagi yeru kin te prangi wute mandi, di mawo, di wase pe memare riwo namb. Nyungo ren kin God ni chongo neny ye. Nungoqi wute God oghine nei wumbig segi kin! Ni nungoqi chongo neuq ye. ");
INSERT INTO kms_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pugri bu nungoqi yumbo ren kin ningg yivany ware di wari, ‘Beghi muainde mir pateri pe, di muainde wuye patekui pe?’ Di wari, ‘Beghi chongo pughe ye ei pare righe?’ Nungoqi pugri puq wand wayequ. ");
INSERT INTO kms_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Juda segi kin ni te kin ningg nei kumo mamb. Pudi nungoqi te kin ningg nei kumo wamb wayequ, te pugri nungoqi nuyi wam nas kin ni nei namb nungoqi yumbo te nei wumbiny. ");
INSERT INTO kms_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pudi muq nungoqi pugri ei puq wen. Nungoqi God ei weti nowi king ningg nas, di ni ningg yumbo ur tuquine kin te wateri, di God ni oyi yumbo buagi aye oghi ye te nungoqi neuq. ");
INSERT INTO kms_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pugri bu nungoqi yumbo prangi kin te ningg yivany ware wayequ. Yumbo prangi kin te rise ye. Nginy iri kin mai te nginy te kin maine.” ");
INSERT INTO kms_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Di Jisas mune nari, “Wute aye ni yumbo ur brequ te wundony di brequ puq wundiny wayequ, eti God oyi nungoqi brequ puq nunduq. ");
INSERT INTO kms_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nungoqi wute yumbo ur brequ rind kin te ningg pughe gri simbe wundiny kin te otiwo God nungoqi mune pugrine simbe nunduq, di nungoqi wute aye yumbo pughe gri pu weny ye te kin pugrine ei God nungoqi oyi neuq ye. ");
INSERT INTO kms_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pughe kin ningg nu yumbo tinanji nimand nde rar pe yequ kin te muq gudoq, pudi nyumo bidi yumbui nu non rar pe yequ kin te gudoq segi? ");
INSERT INTO kms_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nyumo bidi yumbui nunde rar pe yequ, tedi pughe kin ningg nu non nimand ningg kuari, ‘Nu yeru, nge tinanji woju nunde rar pe yequ kin te kitaw wi?’ ");
INSERT INTO kms_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nu wuti nei tevi kin! Nyumo bidi nu non nde rar pe yequ kin te taqwi pre, ei nu oghine rar ghat, muqdi tinanji woju nimand nde rar pe yequ kin te taqwi. ");
INSERT INTO kms_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nungoqi yumbo yuwon kin te nyombui weny riq wayequ. Eti nyombui tene nungoqi mune rutuqu. Di nungoqi mitani pu nde meware ruso wayequ. Eti ni nyinge ruwo.” ");
INSERT INTO kms_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Yumbo ningg pengu wand tedi wateri, meri wutiny tedi wuqond, ngimrawu baq wand tedi ngim bi muauq. ");
INSERT INTO kms_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Te pugri wute buagi yumbo riteri ningg pengu rind kin te riteri ye, di wute yumbo ruqond ningg meri ritiny kin te ruqond ye, di wute rir ruso ningg ngimrawu pe baq mand kin te ngim bi muany ye. ");
INSERT INTO kms_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Pudi nungoqi kin iri nonyimi bret ningg pengu nindig, di ni kiyi wet iri neng ye bri? ");
INSERT INTO kms_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Muq wo iri umo ningg kiyi pengu nindig, di kiyi oyi ghati neng ye bri? Te tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nungoqi wutaqu buagi brequ ye, pudi nungoqi yumbo oghi ye wateri wo weny ye nei wamb. Pugri bu nungoqi nei wamb, nuyi wam nas kin ni wuti tughe ni pengu nindig, tedi ni yumbo oghi kin neng ye. ");
INSERT INTO kms_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yumbo ur buagi wute aye nungoqi nde puq ren ningg wari kin pugrine ei nungoqi mune ninde puq wen. Wand ven ni Moses ningg lo di propet ni simbe mand kin wand puate ane tuquine.” ");
INSERT INTO kms_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ngimrawu wokuandi te ningg ei nungoqi war wo. Pudi ngimrawu wase pe opu kin te ni yumbui nganye, di ngim mune quan nganye yumbui, pugri bu wute tende segine nyinge rire ruso ye tuqui. Wute nganye buagi ni tende nyinge rire ruso. ");
INSERT INTO kms_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pudi wute ninge ni yuwon pu pas kin tiqe pe tende ruso ningg, tedi ni ngimrawu wokuandi pe opu ruso. Tiqe tende wute ruso kin ni buid kumo rip, wute ire irene ni tiqe tende ruso.” ");
INSERT INTO kms_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas ni mune simbe nand nari, “Propet wandoqi kin te ningg ei yeng wawo yuwon. Ni nyombui dabo kin sipsip chongo mirang wughe kin pugri, di ni sipsip nde tumo mondo ei sipsip mat rise ningg. Ni mandi kin te nungoqi wuqond wute oghi, pudi ninde nei pe nungoqi puamb muauq wandi, ei unje mupuqu ningg. ");
INSERT INTO kms_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ni yumbo ur pughe ye yembe mindiny kin te wuqond di nei wamb wute oghi ye o wute wandoqi kin. Wute wain yi sare mundim pe riyi pu yeru map segi, di sanyi yi sare tubrege pe riyi pu yeru map segi. ");
INSERT INTO kms_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nyumo oghi kin ni yi oghi ye rire, di nyumo brequ kin ni yi brequ ye rire. ");
INSERT INTO kms_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nyumo nyam kure kin pe nyumo yi brequ kin riyi tuqui segi, di nyumo brequ kuse kin pe mune pugrine nyumo yi yuwon kin riyi tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nyumo buagi ni yi yuwon kin riyi segi kin ni di mawo wase pe memare riwo namb. ");
INSERT INTO kms_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Te kin pugrine nungoqi ni yumbo ur brequ te wundom di nei wamb ni wute God nde pu nei matevi simbe mand kin segi. ");
INSERT INTO kms_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Eti nungoqi pugri nei wamb wari, nungoqi nge yumbui puq wundigh kin te ninggne ei God nde si nambu was tuqui, pudi te tuqui segi. Wuti iri ni nge wuyi wam nas kin ni nari kin yembe te yembe nindiny, tedi ni God nde si nambu nas kin tuqui. ");
INSERT INTO kms_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Otiwo God ni wute buagi ir nawo kin tende puayi di wute nganye buagi ei nge ningg riri, ‘Yumbui, beghi nunde nyamb pe propet kin wand simbe bad, di nunde nyamb pe wute ququ brequ yemu kin puaq bidiny, di nunde nyamb pe beghi yumbo ur gre ye yembe bidiny.’ ");
INSERT INTO kms_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tende puayi di nge ni pugri simbe gidiny, ‘Nge nungoqi nei gubuq segi. Nungoqi kring wo, nungoqi yumbo ur brequ yembe wundiny ye.’” ");
INSERT INTO kms_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas ni mune wand simbe nand, “Wute nge wand ven rutungu di nge kari kin pugrine puq ren kin te ni wuti nei yuwon ye rise kin pugri. Wuti nei yuwon ye rise kin ni wuti iri wet yumbui pe tende baj yembe nindig kin pugri. ");
INSERT INTO kms_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wuye yumbui wundi, wuye nime nase, di nyumurighi yumbui naghe, quan buagine rindi baj choch rip, pudi baj pombri no segi. Baj te kin wet yumbui tamu mas kin te baj rit nase, bu ni pombri no kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pudi wuti iri ni nge ningg wand ven nutungu segi ye te ni wuti iri nei ghabe rindig ye ni baj wuye jiji pene yembe nindig kin pugri. ");
INSERT INTO kms_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wuye yumbui wundi, wuye nime nase, di nyumurighi yumbui naghe, quan buagine rindi di baj te choch rip, tedi baj te pombri no naghe. Di baj te quanene bi no naghe.” ");
INSERT INTO kms_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas ni wand ven simbe nand pre, wute buagi ni wand bei neny kin te ningg nei kumo rimb. ");
INSERT INTO kms_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Te pugri Jisas wand nand kin te nikin wute Moses ningg lo wute bei meny kin ni wand mand kin pugri segi. Ni wand nand kin te wute rutungu nei kumo rimb di riri wuti nen ni gre ane wand nand. ");
INSERT INTO kms_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas ni rand pe pu nati nandi, wute nganye buagi nganye ninde dobu ruru. ");
INSERT INTO kms_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wuti iri num brequ leprosi niraq kin Jisas nde rar ngimi nandi, sungomyu gure nawo, yimb naghe, di nari, “Yumbui, nu nge ghav gudigh yawo kurew, tedi nge ghav ndigh di nge ghimbi mune oghi rise ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Di Jisas si neq wundo nait nase nari, “Nge nu sabi guduw ye. Nu muqdi oghi ghas!” Di brequne num leprosi te prene di mune oghi nas. ");
INSERT INTO kms_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Muq ni simbe nindig nari, “Nu tungu! Nu wute aye simbe ndiny wayequ, nu yo nunon ghimbi te prist nde bei ghand pre, di Moses ningg lo ni wute wand puaq mand ningg umo wase mande kin te ningg wuri kin pugrine puq yen. Nu puq yen ei prist ni te muqond di mari te nganyene nu num oghi pre.” ");
INSERT INTO kms_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas ni tiqe ire Kaperneam puq munduw kin tende nar no, Rom kin ami mingg yumbui iri ni nandi Jisas nuqoind, muq ni ghav nindig ningg pengu nindig nari, ");
INSERT INTO kms_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Yumbui, nge yembe ye wuti iri ni num gureg bu ni baj pene ruqo pu nase. Ni ngape riti di ni yuqo yumbui niraq.” ");
INSERT INTO kms_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Di Jisas ni oyi simbe nindig nari, “Nge ko, sabi gidig ye.” ");
INSERT INTO kms_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pudi ami mingg yumbui ni Jisas oyi nindig nari, “Yumbui, nge wuti oghi nganye segi, pugri bu nu ngende baj pe ghandi wayequ. Nu wandne simbe ghand, di nge yembe ye wuti te num oghi. ");
INSERT INTO kms_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nge nei gab nu wuti te sabi gudig tuqui. Te pugri nge mune wuti nyamb kin iri nde si nambune kas ye, di ami oyi nge nde si nambu mas. Pugri bu nge ami iri simbe gidig kari, ‘Nu yo,’ di ni no; aye simbe gidig kari, ‘Ghandi,’ di ni nandi; nge yembe ye wuti ningg kari, ‘Nu yembe te yembe ndiny,’ di ni yembe nindiny.” ");
INSERT INTO kms_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Muq Jisas ni wand ven nutungu, ni nei quan nganye puye nand, di wute ninde dobu ruru kin te simbe nindiny, “Nge nungoqi nganyene simbe guduq, nge Israel kin iri ni God pugri nganye nei nimbig kin te nge guqoid segi. ");
INSERT INTO kms_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Nge nungoqi simbe guduq, wute nganye buagi nginy nawi opu kin di nginy naghe no opu kin ei rindi, di Abraham, Aisak di Jekop ane God nde si nambu ris mir rind di chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pudi wute asi God nde si nambu ris ningg nap ruso kin te muq ni dob reng bu ni bub nare ruso burpoq pe ris. Di sunyi tende ni quan nganye riri di sawo rit ki.” ");
INSERT INTO kms_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Di Jisas ni ami mingg yumbui simbe nindig nari, “Be yo. Nu nei guab nge wuti te sabi gidig oghi ye, tedi ni segine oghi ye.” Di tende puayine ami mingg yumbui ni yembe ye wuti opu oghi nase pre. ");
INSERT INTO kms_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ni Pita nde baj pe nar no, di Pita ni kine gang ede pe ruqo pu wuse nundoq, ni num kurew bu ni ghimbi sungue rupuw. ");
INSERT INTO kms_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Di Jisas ni si nituw kuse, di num opu prene. Di ni wes wiyo, Jisas mir weng. ");
INSERT INTO kms_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tende yuram wute nganye buagi ququ brequ ninde yemu kin te Jisas nde mare mandi. Di Jisas ni nari, ququ brequ te wute te si mare. Di ni num kin buagi te sabi nindiny oghi. ");
INSERT INTO kms_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ni puq nen kin te propet iri Aisaia puq mindig kin ni asi puq nand kin ane tuquine. Ni pugri puq nand nari, “Nikinne beghi num nitang ruwi di puaq nand ruso pre.” ");
INSERT INTO kms_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas ni nuqond wute buagi ninde quir quar rindig pu yeru, di ni nikin wute te simbe nindim nari, “Be wandi, wuye ngamo pe opu gri po.” ");
INSERT INTO kms_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wuti iri ni lo wute bei neny kin ni nandi, Jisas ningg nari, “Tisa, nge nu ane po ye. Nu muainde opu kuo te nge ane po ye.” ");
INSERT INTO kms_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Di Jisas oyi nand nari, “Nyombui dabo kin nikin rise kin sunyi yeru, di wapi nikin rise kin nyuw yeru. Pudi nge, wuti God nde pu gadi wuti nganye kas kin, nge kase kin sunyi segi.” ");
INSERT INTO kms_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jisas nikin wuti aye iri ni Jisas simbe nindig nari, “Yumbui, nge nunde karu ye. Pudi nu ngiq ghand ei nge ko wuyi yeng guag pu kas, otiwo nati ngamo kowi pre muqdi gadi nu ane po.” ");
INSERT INTO kms_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Di Jisas nari, “Wute Yumbui nei mimbig segi kin ni wute mati pre kin pugri. Ni ei mo wute mati kin te mawo yemu. Nu nge nde ghawi.” ");
INSERT INTO kms_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Muq Jisas ni at pe newo no, di ni nikin wute anene mo. ");
INSERT INTO kms_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ni mo mo wuye ngamo mingi nyumurighi yumbui naghe, di wuye quan seme gub, at pe kuyo kughe. Pudi Jisas ni ruqo mingi no pu yenu. ");
INSERT INTO kms_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Di Jisas nikin wute mondo, ni buraq mindig mari, “Yumbui, beghi ghav ndug! Beghi pati yamb tumo!” ");
INSERT INTO kms_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ni oyi nindim nari, “Nungoqi God musoqne nei wumbig kin, nungoqi pughe kin ningg quan nganye wune wamb?” Muq ni nes newo nyumurighi di wuye ane segi puq nindiny, di ni opu prene. ");
INSERT INTO kms_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Di nikin wute te muqond, di nei kumo mamb, di ni kin kin pengu mand, “Wuti nen ni pughe gib namb ye? Nyumurighi di wuye ane ni wand simbe nand kin te irepene rutungu!” ");
INSERT INTO kms_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ni no gherim Galili opu Gadara mingg qi pe no nar. Di wute temi ququ brequ ninde ghimbi pe yemu kin mandi, Jisas muqoind. Ni temi wute mati mawo yemu kin sunyi pe pu mandi. Ni temi quan nganye jebo mand, pugri bu wute ni ngim tende ruso segi. ");
INSERT INTO kms_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ni quan kumone mari, “Nu God ningg wo, nu beghi pughe sin guegu ningg bu guadi? Ngeri segine nu guadi kin ren nu beghi brequ gudug ningg bu guadi?” ");
INSERT INTO kms_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Muq te pu musoqne kring rundo te pu quan ni tende mir rind rind yeru. ");
INSERT INTO kms_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ququ brequ ni Jisas quan pengu mindig mari, “Nu beghi puaq ndumu ningg, ate beghi rar ndomu bodo pu buagi tende par po.” ");
INSERT INTO kms_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas ni ququ brequ te simbe nindim nari, “Nungoqi wo.” Muq ququ brequ wute temi te si mare, di mo pu buagi tende mar mo. Pu buagi te ni quan vig rimb ruso, rand wari pe righe ruso, wuye ngamo pe ir righe, wuye riq di riti. ");
INSERT INTO kms_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wute pu yeng muany ye ni te muqond, mes mewo, wu mase mo. Ni mo, tiqe yumbui pe yumbo pughe ni muqond kin te wute simbe mindiny. Di ni wute temi ququ brequ ninde yemu kin te yumbo ninde puq ren kin te wute simbe mindiny. ");
INSERT INTO kms_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Di wute buagi tiqe te kin ni Jisas nde rindi. Ni rindi Jisas ruqoind ei ni simbe rindig di ni qi te si niraq ei opu gri mune nandi. ");
INSERT INTO kms_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas ni at pe newo no, di nikin wute ane wuye ngamo misiq opu gri nikin nde tiqe pe mune mandi. ");
INSERT INTO kms_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wute ninge ni wuti iri quangi rind kin te meri mondo, ni sunyi pene ruqo pu nase. Ni nei mamb Jisas wuti te sabi nindig ye di Jisas ni nei te nundom pre, di ni wuti nyinge nare segi kin te ningg nari, “Nge mand, nu umbo yuwon kuse. Nu yumbo ur brequ guad kin wand te puaq pre.” ");
INSERT INTO kms_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wute ninge ni Moses ningg lo wute bei meny kin ni Jisas ningg wand ven mutungu di ni kin kin wand wand mare mari, “Wuti nen ni God wand brequ nindig, te pugri ni God ningg sunyi natevi.” ");
INSERT INTO kms_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas ni nei te nundom pre, di ni nari, “Pughe kin ningg nungoqi nei brequ ven nungoqi nde umbo pe yevu? ");
INSERT INTO kms_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wand pughe ye puq gad tedi wute riri te nganyene: Nge kari, ‘Nu yumbo ur brequ guad kin wand te puaq pre,’ o nge kari, ‘Nu yes yewo nyinge ghare yo’ puq gad di ni nyinge nare kin wuqond di nei wamb kin tuqui? ");
INSERT INTO kms_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pudi puq ken ei nungoqi nei wamb te pugri wuti God nde pu nandi wuti nganye nas ye ni qi pe ven nde yumbo ur brequ kin wand puaq nand ye gre rise.” Muq ni wuti nyinge nare segi kin te ningg nari, “Nu yes yewo, nunon sunyi ghateri, ghare baj pe yo.” ");
INSERT INTO kms_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Di wuti te nes newo, nikin nde baj pe no. ");
INSERT INTO kms_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wute buagi ni te ruqond, di ni quan wune rimb, di ni God nyamb rindivi viyo. Te pugri ni gre quan nganye wute neny. ");
INSERT INTO kms_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas ni mune nyinge nare no, wuti iri Matyu puq mindig kin nuqoind, ni takis nateri ye baj pe nas. Di Jisas ni pugri simbe nindig nari, “Nu nge nde ghawi.” Di Matyu ni nes newo Jisas nde naru. ");
INSERT INTO kms_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas ni Matyu nde baj pe mir nand nand nas, wute takis materi kin di wute yumbo ur brequ rind kin nganye buagi Jisas di nikin wute ane tende ris mir rind. ");
INSERT INTO kms_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi ninge ni te muqond, di ni Jisas ningg wute te pugri pengu mindim, “Pughe kin ningg nungoqi yumbui te ni wute takis materi kin di wute yumbo ur brequ rind kin ane mir rind?” ");
INSERT INTO kms_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas ni wand ven nutungu, ni pugri puq nand, “Wuti num gureg segi kin ni dokta nde no tuqui segi, wuti num gureg kinne ei dokta nde no. ");
INSERT INTO kms_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nungoqi wo, wand God ningg buk pe rise kin ven wuqond, nei wamb. Nungoqi umo wambui riti nge wegh kin te nge yambu kari. Nungoqi wute yawo wutony kin te nge yawo kare righe.” Di Jisas mune nari, “Te kin pugrine nge wute yumbo ur tuquine puq ren yene kateri ningg gadi segi, pudi wute yumbo ur brequ rind rind ris ye ni ningg bu gadi.” ");
INSERT INTO kms_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tende puayi Jon wute wuye nap ye ni ningg wute mandi Jisas muqoind di pengu mindig mari, “Pughe gri ate beghi Parisi ane pripri mir uny yembu, pudi nu ningg wute te mir uny yemu segi?” ");
INSERT INTO kms_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas ni oyi nindim nari, “Wuti iri ngam no ningg mir yembe mindiny di kimand ngam niram mandi ane mir mand. Di ni ane mir mand mand masne kin tende puayi ni kimand te mir uny yemu tuqui segi. Pudi otiwo wute ninge mandi wuti ngam no kin mitanyi mo ye ngeri te rindi ye. Di tende puayi ei ni yivany mare di mir uny yemu. ");
INSERT INTO kms_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wuti iri ni chongo bidi urupui ire nitaqwi, chongo wuri ire bir wus kin pe nuaq wuso rang nimbiq tuqui segi. Ni pugri puq nen, tedi otiwo ni wuye nipiq di chongo bidi urupui kin te wute rundo, di asi kin te mune bir wus di gawo quan nganye yumbui wuse. ");
INSERT INTO kms_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Di wuti iri ni wain urupui meme chongo yabe kin pe nowi naghe segi. Ni pugri puq nen, tedi wain urupui te yindingi di meme chongo yabe kin te bir nuaq di meme chongo te bir wus di wain dabo no. Pugri bu wain urupui te meme chongo urupui pene ei mawo maghe di ni yuwon pu ris.” ");
INSERT INTO kms_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas ni wand te simbe nand nandne yenu, Juda mingg yumbui iri ninde nandi. Ni nandi Jisas nde tumone sungomyu gure nawo yimb naghe, di nari, “Nge wo nyumbueg muq tene wuti pre. Pudi nu ghandi si yew kuyo ei te ni mune wes wiyo.” ");
INSERT INTO kms_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Di Jisas ni nes newo Juda mingg yumbui te temi mo, di Jisas nikin wute te anene mo. ");
INSERT INTO kms_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Di wute ire ni uny chiraq yequ ruso ber 12-pela pu ruso. Nyumbueg te ni Jisas nde dobu gri wuwi, ni nikin nei pe pugri puq wund, “Nge ni chongone kiting rise, tedi nge oghi.” Nikin nei pe pugri puq wund, ni Jisas ni chongo cheq te wuting wuse. ");
INSERT INTO kms_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas ni dobu gri rar nat ni nundoq di nari, “Nge wo, nu nonne nei guab kuari nu nge chongo kuat rise di nu oghi ye puq guad kin te ningg bu nu oghi. Nu umbo yuwon pu kuse di yo, wand nunde rise kin te muq prene.” Muq tende puayine nyumbueg te mune oghi wuse. ");
INSERT INTO kms_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Muq Jisas ni no Juda mingg yumbui ninde baj pe nar no, wute quanji rind rind ris. Quayi ni pereru piq muqond di wute buagi ni quan riri ange nyuw rip, ");
INSERT INTO kms_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","di ni nari, “Nungoqi quan buagine dabo war wo! Nyumbueg wo te wuti segi, ni ruqo wuse!” Di wute buagi ni wur ring. ");
INSERT INTO kms_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pudi ni wute buagi tiqi nundony rir ruso pu dabo yeru. Jisas ni nar no, nyumbueg wo wuse kin sunyi pe, ni si nituw kuse, di ni mune wes wiyo. ");
INSERT INTO kms_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jisas ni pugri puq nen kin wand tene vir ir viso tiqe manyi tende opu yeru kin te rutungu. ");
INSERT INTO kms_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas ni tiqe te si niraq di nyinge nare no. Wute temi rar chukoq kin dobu maru mari, “Nu Devit ningg kuqo ate beghi temu yawo tongu.” ");
INSERT INTO kms_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ni baj pe nar no, muq wute rar chukoq kin te Jisas nde mandi, di Jisas ni mingg nari, “Nungoqi nei wamb ye nge sabi guduq oghi ye tuqui bri?” Ni oyi mand, “Yumbui, nu tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Muq Jisas ni si ninde rar pe nem kuyo nari, “Nungoqi tequ nei wamb ye nge sabi guduq tuqui, pugri bu nungoqi rar wat.” ");
INSERT INTO kms_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Di ni rar mat yumbo muqond. Di Jisas ni wand gre ye ni temi simbe nindim nari, “Nungoqi tequ wand ven wute aye simbe wundiny wayequ.” ");
INSERT INTO kms_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pudi ni temi mo, Jisas ni yembe yuwon nand kin te wute buagi tiqe manyi tende opu yeru kin te simbe mindiny. ");
INSERT INTO kms_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wute temi te mo mone, muq wute ninge wuti iri wand nand segi kin te ritanyi Jisas nde rindi, ququ brequ ninde yenu. ");
INSERT INTO kms_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pudi Jisas ni ququ brequ te puaq nindig. Wuti te wand nand, di wute nei kumo rimb riri, “Beghi asi yumbo ur ren kin Israel ven nde buqod segi.” ");
INSERT INTO kms_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pudi Parisi ni mari, “Wuti nen ni ququ brequ mingg yumbui ni ningg gre pe ququ brequ puaq nand mo.” ");
INSERT INTO kms_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas ni tiqe buagi tende yeru kin tende nar nar no. Ni God yumbui nyamb mirang kin baj pe tende yenu wand yuwon ye bei neny. Di wute God nde si nambu ris kin te kin wand bir nuany. Di ni wute buagi num isis kin te ane sabi nindiny. ");
INSERT INTO kms_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Di ni wute buagi te nuqond di ni quan nganye yawo nitony. Te ni yivany rire di bir kin kin ris, sipsip kin pugri wuti yeng nuany kin segi. ");
INSERT INTO kms_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Muq Jisas nikin wute ningg nari, “Wuny mbe mir nganye buagi nguan pre, pudi wute mir te materi kin quan segi. ");
INSERT INTO kms_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pugri bu nungoqi wuny kiyi pengu wundig ei ni yembe ye wute aye tiqi nundom mo mir te mitangri meng rir.” ");
INSERT INTO kms_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas nikin wute 12-pela pu te nari mandi, di ni gre nem ei ni wute ninge ququ brequ ninde yemu kin te puaq mindiny di num isis kureny kin te sabi mindiny oghi. ");
INSERT INTO kms_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel 12-pela ni nyamb taq ren: ye nawo kin Saimon ni nyamb ire Pita puq nindig, ni kiqam Andru temi; di Jems, Sebedi ningg wo, di ni kiqam Jon. ");
INSERT INTO kms_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Di Pilip, di Bartolomyu di Tomas di Matyu, ni takis nateri kin; Jems ni Alpius ningg wo, di Tadius. ");
INSERT INTO kms_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon ni Selot ningg wute tit kin iri, di Judas Iskariot, wuti Jisas veri nde si pe ni nondo kin te. ");
INSERT INTO kms_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas nikin wute 12-pela pu men tiqi nundom mo, ni wand pugri yeri nindim, “Nungoqi wo kin wute Juda segi kin pe tende wo wayequ. Di nungoqi Samaria nde tiqe pe wo wayequ. ");
INSERT INTO kms_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pudi nungoqi wo kin Israel mingg sipsip ir ruso pre kin te ei meri wutiny. ");
INSERT INTO kms_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nungoqi wo wand pugri puq wundiny, ‘Wute God nde si nambu ris kin te kin ngeri tumo rind pre.’ ");
INSERT INTO kms_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nungoqi wo, num kin sabi wundiny oghi, wute riti kin te mune wundiri riwo, wute leprosi riraq kin ghimbi sabi wundiny oghi, di wute ququ brequ ninde yemu kin te puaq wundiny. Nungoqi gre ren wong wand segine wateri, pugri bu nungoqi ni sabi wundiny kin te ni wong runduq wayequ. ");
INSERT INTO kms_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nungoqi wo kin gol, silva, di wet bidi te ninge hanpaus pe rise ware wo wayequ. ");
INSERT INTO kms_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nungoqi wo kin quongi tami te ware wo wayequ. Di nungoqi chongo aye ware o su ware o botu ware wayequ. Wuti ni yembe nindiny, tedi ni oyi ni ghav rindig mir reng. ");
INSERT INTO kms_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Muq wo, tiqe yumbui o tiqe woju pe wo, te nungoqi rar wat yuwon, wuti pughe ye ni wuti yuwon kin, nungoqi wuti te ane was ruso ruso otiwo nungoqi aye pe wo ningg muqdi tiqe te si wuraq. ");
INSERT INTO kms_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pudi nungoqi baj ire pe war wo ningg, tedi nungoqi wute baj te kin simbe wundiny wari, ‘God nungoqi yuwon nuauq.’ ");
INSERT INTO kms_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wute baj te kin ni yuwon kin, ate nungoqi wand yuwon ye te ninde si wurany. Pudi ni wute yuwon kin segi, ate nungoqi wand yuwon ye te mune nungoqi nde vindi. ");
INSERT INTO kms_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Di wute tiqe te kin nungoqi mitaqu wowi segi, di ni nungoqi wand mutungu yambu mari, ate nungoqi baj te si ware o tiqe te si wuraq ningg di nungoqi nyinge pe kin qusuqu te buraq wand. ");
INSERT INTO kms_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nge nungoqi nganyene simbe guduq, God ni wute ir nawo kin tende puayi mai Sodom di Gomora ane riraq kin te ni ane tuqui segi, tiqe wen kin mai ni mune quan nganye.” ");
INSERT INTO kms_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nungoqi wutungu! Nge nungoqi tiqi gudoqu wo kin te sipsip kin pugri nyombui dabo ye mingi wo. Pugri bu nungoqi wo kin ghati ni waghi waghine ruso kin pugri nungoqi otinde nei wamb wamb wo. Di wapi mabri mingg yumbo ur yuwon ye te kin pugri wute ker wany segi. ");
INSERT INTO kms_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nungoqi wute ningg nei wamb wamb otiwo ni nungoqi mutuqu wase di mitaqu kot pe mo, di nungoqi God yumbui nyamb mirang kin baj pe tende mumbuequ. ");
INSERT INTO kms_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nungoqi nge ningg wute pugri bu nungoqi mitaqu mo gavman nde si pe mequ wondo di king nde si pe mequ wondo. Nungoqi puq meuq tedi God ni wand yuwon ye te ni simbe wundim di Juda segi kin te mune ane rutungu. ");
INSERT INTO kms_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nungoqi mitaqu kot pe wo kin tende puayi eti nungoqi nei kumo wamb wari, ‘Nge wand pughe ye bri simbe gad, o nge pughe gri ni wand oyi gidim?’ Otiwo tende puayi Yumbui nungoqi nei neuq di nungoqi simbe wand. ");
INSERT INTO kms_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wand te nungoqi simbe wand kin te nungoqi te segi. Wand te Ququ Yuwon Ye ni nuyi nde pu nandi nunde mim pe simbe nand. ");
INSERT INTO kms_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wute ninge nikin kise God nei mimbig bu ni mitami kot pe mo di ni mi mati, di kiyi ninge ni wo mune pugrine puq meny. Di wo ninge ngawu gre rind kin ni kiyi kumo kot pe ritari ruso mambui riti. ");
INSERT INTO kms_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nungoqi nge ning wute pugri bu wute buagi nungoqi yambu rireuq. Pudi wute tughe ni gre rind ris ruso ruso qi wen pre kin tende puayi, tedi God ni nateri ye. ");
INSERT INTO kms_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tiqe ire te kin wute nungoqi unje mupuqu mai isis meuq, tedi nungoqi wu wase tiqe aye pe wo. Nge nganyene simbe guduq, nungoqi Israel mingg tiqe buagi tende wo war ir omo wawo segine di wuti God nde pu nandi wuti nganye nas kin ni mune nandi. ");
INSERT INTO kms_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wokuandi nikin tisa nde ni yumbui ningg ris tuqui segi, di wute yembe ye nikin yumbui tende ni oyi yumbui ningg mas tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pudi wokuandi nikin tisa ane tiq tiqne ris tedi tuqui, di wute yembe ye nikin yumbui te ane tiq tiqne mas tedi tuqui. Ni baj kiyi nyamb brequ mindig, mari, ‘Belsebul’ puq mindig, tedi wute ninde baj pe ris kin quan nganye nyamb brequ mindiny.” ");
INSERT INTO kms_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas ni mune pugri simbe nand, “Nungoqi wute yumbo ur brequ munduq kin te ningg wune wamb wayequ. Yumbo ninge muq imb pu rise kin te otiwo bure ris raqene rise, di wand muq suqo pu vise kin te otiwo wute buagi nei rimb ye. ");
INSERT INTO kms_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nge wand burpoq nungoqi simbe guduq kin te bogisumb muqdi simbe wand. Di nge nungoqi ange pe misag kare kin te wewo wo baj wam yequ wute simbe wundiny. ");
INSERT INTO kms_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nungoqi wute ghimbine mamb riti pudi ni ququ mamb riti segi kin te ningg wune wamb wayequ. Pudi nungoqi God ningg ei wune wamb, ni teri ane namb riti, ghimbi namb riti di ququ nate ruwi di wase pe menare righe namb. ");
INSERT INTO kms_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nungoqi nei wamb, wute wapi wo temi wan toea pe wong mand. Di nungoqi nuyi ni wapi wo te quan nganye sabi nindim. Pudi ni ngiq nand segi, tedi iri qi pe ir ni naghe tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nungoqi nde ngawu pe God ni yu te manyi nand pre. ");
INSERT INTO kms_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pugri bu nungoqi wune wamb wayequ, nungoqi nuyi ni wapi wo yawo nitony pudi nungoqi mune quan nganye yawo nitouq.” ");
INSERT INTO kms_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas ni mune simbe nand nari, “Wuti tughe ni wute simbe nindiny nari, ‘Nge Jisas ningg wuti,’ tedi nge mune nginy tu wam tende nge wuyi simbe gidig kari, ‘Wuti nen nge te.’ ");
INSERT INTO kms_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pudi wuti tughe ni wute simbe nindiny nari, ‘Nge Jisas ningg wuti segi,’ tedi nge mune nginy tu wam tende nge wuyi simbe gidig kari, ‘Wuti nen nge te segi’.” ");
INSERT INTO kms_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas ni mune simbe nand nari, “Eti nungoqi nei wamb wari nge muq gadi kin yeng buagi qi pe kin gure kawo ningg bu gadi. Nge yeng gure kawo ningg gadi segi, nge bainat bu keri gadi. ");
INSERT INTO kms_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nge muq gadi kin umbo ker mune pi res, ‘Quayi wo ni kiyi ker muam, di nyumbueg wo ni kumo ker ruany, di nyumbueg ngam kin ni kine ker ruany. ");
INSERT INTO kms_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wute te nikin veri nganye te nikin wangone’.” ");
INSERT INTO kms_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Wuti tughe ni kiyi o kumone yawo nirany righe di nge segi, tedi ni nge ningg wuti kin pugri nas kin tuqui segi. Di wuti ni quayi wo o ni nyumbueg wo tene yawo nirany righe di nge segi, tedi ni nge ningg wuti kin pugri nas kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Di wuti iri ni kruse niraq ngende dobu nawi segi, tedi wuti te ni nge ningg wuti kin pugri nas kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wuti tughe ni nge nei nimbigh segi nikin ghimbine nei nimbiny di nati, tedi ni nas nas te kin nas tuqui segi. Pudi wuti tughe nikin ghimbi nei nimbiny segi nge nei nimbigh muq nati, tedi ni nas nas te kin nas ye. ");
INSERT INTO kms_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Wuti tughe ni nungoqi nitaqu wowi te nge neti kowi, di wuti tughe nge neti kowi te wuti nge tiqi nundogh gadi kin te neti nowi. ");
INSERT INTO kms_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wuti tughe ni propet iri nuqoind di ni nari, ‘Wuti nen ni propet iri pugri bu nge keti nowi,’ tedi yumbo God ni propet nuam rise kin pugrine ni mune nateri. Wuti tughe ni wuti tuquine nas kin iri nuqoind nari, ‘Ni wuti yumbo ur tuquine puq nen pugri bu nge keti nowi,’ tedi yumbo God ni wute yumbo ur tuquine puq ren ye nuany rise kin pugrine ni mune nateri. ");
INSERT INTO kms_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Di wuti iri nari ni nge ningg wute te ghav nindim muq ni uyi wuye natekui nge ningg wuti iri nyamb segi kin te neng, nge nganyene nungoqi simbe guduq, wuti yumbo ur wokuandi nganye ren kin puq nen ye te ningg ni yumbo God nuang rise kin te nateri ye.” ");
INSERT INTO kms_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas nikin wute 12-pela pu wand ren simbe nindim pre, muq ni sunyi te si nare di nyinge nare, tiqe ninge Galili opu yeru kin tende no wand bei neny di bir nawo. ");
INSERT INTO kms_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Muq Jon wute wuye nap ye ni taq pu yenu kin tende puayi wute ninge ni simbe mindig mari Kraist ni yumbo ur pugri nand. Pugri bu Jon nikin wute tiqi nundom Jisas nde mo, ");
INSERT INTO kms_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","di ni Jisas pengu mindig mari, “Nu beghi simbe ndug, Jon ni nari nu, wuti God tiqi nundog nandi puq nand kin tene bri guadi o beghi wuti aye bri ghimbi buag pu pas ye?” ");
INSERT INTO kms_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Di Jisas ni oyi nindim nari, “Mune wo di yumbo yumbo buagi nungoqi non rar pe wuqond di wute aye men simbe munduq wutungu kin te Jon simbe wundig: ");
INSERT INTO kms_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wute rar chukoq kin te ni mune rar bure rind, wute nyinge brequ kin mune nyinge rire, wute leprosi riraq kin te ghimbi mune yuwon rind, wute ange ghave rimbiny kin munene wand rutungu, wute riti kin mune res riwo, di wute yumbo segi kin te ni wand yuwon ye bir muany rutungu. ");
INSERT INTO kms_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wute nge yumbo yumbo buagi puq ken ye te ruqond, pudi nge dob regh segi kin wute te chumbuai rind.” ");
INSERT INTO kms_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon nikin wute Jisas si meri ningg muq Jisas ni Jon ningg wand wute buagi te simbe nindiny nari, “Nungoqi mong wuye di nyumo segi ye pe wo Jon wuqoind kin te ni kombu kin pugri nyumurighi neri no nandi nandi bri yenu wuqoind? Te segi, Jon ni kombu kin pugri segi, ni gre pu yenu ye. ");
INSERT INTO kms_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pudi te segi, tedi yumbo pughe kin wuqond yamb wo? Wuti iri chongo yuwon ye bri nare righe pu yenu bu wo wuqoind ningg? Te segi, wute ni chongo pugri ye mare righe kin ni king ningg baj pe mas ye. ");
INSERT INTO kms_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nungoqi yumbo pughe kin wuqond yamb wo? Propet iri bri wuqoind ningg wo? Te nganyene, nge nungoqi simbe guduq, Jon ni mune yumbui nganye, propet aye ni ane tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wuti nen ningg qa God nde buk pe pugri ur mand, ‘Nge wuti iri nge ningg wand nare no kin te tiqi gudog ye nawo nu ngim sabi nunduw.’ ");
INSERT INTO kms_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nge nganyene nungoqi simbe guduq, wuti iri qi pe ven nde kin Jon wute wuye nap kin ni nde yumbui nas segi, Jon irine yumbui. Pudi wute God nde si nambu ris kin tende wuti iri nyamb segi wokuandi kin pugri nas kin te ni oyi Jon nde yumbui. ");
INSERT INTO kms_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon wute wuye nap kin ni wand bir nawo kin tende puayi pu rindi muq ven nde puayi God ni king ningg nas di wute ninde si nambu ris kin te quan nganye gre rind di wute tende rir ruso ningg quan nganye buid rip. ");
INSERT INTO kms_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propet buagi di Moses ningg lo ane ni wute God nde si nambu ris kin ningg simbe mand. ");
INSERT INTO kms_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Propet ni mari, ‘Elaija ei nandi.’ Nungoqi wand wutungu yawo kureuq, tedi nge nungoqi simbe guduq te Elaija segi, Jon ningg bu puq mand. ");
INSERT INTO kms_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wuti tughe ni nutungu kin tuqui tedi ange nuaq ei wand ren nutungu. ");
INSERT INTO kms_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nge yumbo pughe kin ningg ei wand gad ei nungoqi muq ven nde puayi was kin te ane tuquine? Nungoqi wokuandi kin pugri, ni ruso tiqe moqi ris, wokuandi aye mune rindi muq ni oyi oyi wand rind riri, ");
INSERT INTO kms_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Beghi pereru piq budouq ei nungoqi nyinge wawo ningg pari, pudi nungoqi nyinge wawo segi. Di beghi yivany kin yuwo pari ei nungoqi quanji wand ningg pari, pudi nungoqi quanji wand segi.’ ");
INSERT INTO kms_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Te kin pugrine Jon nandi kin ni mir quan nand segi, di ni wain ne segi, di wute mari ququ brequ ninde yenu. ");
INSERT INTO kms_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Di nge, wuti God nde pu gadi wuti nganye kas kin, nge gadi kin nge mir gad di wain ke di ni mari, ‘Nungoqi wuti nen wuqoind. Ni mir quan nand di wain quan ne, ni wute takis materi kin di wute yumbo ur brequ rind kin kimand.’ Beghi temu yumbo ur kin kinne yembe bidiny, pudi nungoqi temu ane yambu wurengu. Pudi God beghi nde yembe nand kin te bei rind ni nei te tuquine nganye.” ");
INSERT INTO kms_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tiqe ren kin wute Jisas ni yumbo ur gre ye quan nganye yembe nindiny pudi ni te ruqond di nei rire ritinde segi. Pugri bu Jisas ni tiqe ren kin wute ker nuany. ");
INSERT INTO kms_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ni pugri puq nand, “Korasin kin wute, otiwo nungoqi mai yumbui nganye ware, di Betsaida kin wute, nungoqi mune pugrine mai yumbui nganye ware ye. Te pugri wuti iri ni no tiqe brequ ye Tair di Saidon tende nge ningg yumbo ur gre ye nungoqi nde yembe gidiny kin pugrine ni mune tende yembe nindiny, tedi Tair di Saidon ane asine nei rire ritinde, ni chongo bir bir kin rire righe ruso wase inyap righe. ");
INSERT INTO kms_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pudi nungoqi nei ware witinde segi, pugri bu nge muq nungoqi simbe guduq, otiwo God ni wute buagi ir nawo kin tende puayi nungoqi mai quan nganye wuraq. Tair di Saidon ane ni mai tumo wone riraq. ");
INSERT INTO kms_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Di nungoqi Kaperneam nungoqi nonne nyamb wundivi viyo quan nganye yumbui vise ningg wari? Te segi. God ni meniraqu mati kin tiqe pe wo. Te pugri wuti iri ni no tiqe Sodom tende nge yumbo ur gre ye nungoqi nde yembe gidiny kin pugrine ni mune tende yembe nindiny, tedi Sodom ni yequne. ");
INSERT INTO kms_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pugri bu nge nungoqi simbe guduq, otiwo God ni wute ir nawo kin tende puayi nungoqi mai Sodom riraq kin pugri segi, nungoqi Kaperneam mai quan nganye wuraq.” ");
INSERT INTO kms_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tende puayi Jisas ni nari, “Wuyi, nu nginy tu wam di qi anene kin yumbui. Nge nu chumbuai guduw, te pugri nu wute quan nganye nei mamb kin ni nu yumbo suqo kuram, di wute ninge wokuandi nei rise kin tene nu bei gudim. ");
INSERT INTO kms_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Te nganye wuyi nu non nei pene bu pugri puq kuen.” ");
INSERT INTO kms_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Di Jisas ni mune simbe nand nari, “Nge wuyi ni yumbo yumbo buagi nge negh. Di wuti iri ni wo te nei nimbig segi, pudi kiyi ni irine wo te nei nimbig. Di wuti iri ni kiyi te nei nimbig segi, pudi wo di wute ninge ni wo kiyi bei neny kin tene ni nei rimbig. ");
INSERT INTO kms_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nungoqi yumbo mai kin ware ghimbi buid segi ate ngende wandi, tedi nungoqi was yawotuan kin sunyi kew kin tuqui. ");
INSERT INTO kms_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nungoqi nyumo bog bulmakau nde gibe pe mirany righe ei ni yumbo qo rimb rire ruso ye te nei wumbiny. Bulmakau ni wute nde si nambu yeru di ni yumbo qo rimb rire ruso. Nungoqi te kin pugrine nge ningg wand wutungu di nge nde si nambu yequ. Nge yumbo ur oghi ye yembe gidiny di nge ningne nyamb gidivi viyo segi, di yumbo te nungoqi nde mai riwo segi, di nungoqi was yawotuan kin tuqui. ");
INSERT INTO kms_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nyumo bog nge nungoqi nde gibe pe kirauq righe kin te nungoqi ware kin tuqui, di yumbo nge keuq kin te mai riwo segi, nungoqi ware kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nginy iri Sabat kin tende puayine Jisas nikin wute ane wit wuny mingi tende nyinge mare mo. Jisas nikin wute mir kurem, di wit yi ninge map me. ");
INSERT INTO kms_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Muq Parisi ni te muqond, ni Jisas ningg mari, “Muq nginy nen te Sabat kin nginy, pudi nu wute ni wit yi map me. Lo ni beghi yembe bad kin te ningg segi puq wund.” ");
INSERT INTO kms_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Di Jisas oyi nindim nari, “Devit nikin wute ane mo mo mir kurem di pughe sin men kin te nungoqi buk pe wuqond segi bri? ");
INSERT INTO kms_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ni God ningg baj pe nar no, bret God meng ningg mawo ris kin te nare nandi, nikin wute ane me. Bret ren pristne di me ye, wute aye me kin te lo segi puq wund. ");
INSERT INTO kms_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nungoqi Moses ningg lo buk te wundoq segi bri? Ni nari prist ni God ningg baj pe yembe mand ye nginy Sabat te ningg ni segine yembe mand, pudi ni te kin ningg unje map segi. ");
INSERT INTO kms_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nge nungoqi simbe guduq, God ningg baj ni yumbui, pudi wuti iri ni mune quan nganye yumbui kin muq nen yenu. ");
INSERT INTO kms_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God ningg buk wuri, ‘Nungoqi umo wambui riti nge wegh kin te nge yambu kari. Nungoqi wute yawo wutony kin te nge yawo kare righe.’ Nungoqi wand puate ven kin ei nei wamb, tedi wute aye unje rip segi kin te mai weny segi. ");
INSERT INTO kms_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Te pugri wuti God nde pu nandi wuti nganye nas kin ni Sabat kin puate.” ");
INSERT INTO kms_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas ni sunyi te si nare di nyinge nare no, ni mingg God yumbui nyamb mirang kin baj pe nar no. ");
INSERT INTO kms_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tende puayi wuti iri si kuti kin ni tende nas. Wute ninge ni Jisas kotim maind ningg ngim meri mand bu ni mandi pu tende mas, ni Jisas pengu mindig mari, “Moses ningg lo pughe puq wund, beghi wute num ye nginy Sabat kin tende puayi sabi bidiny ye o segi ye?” ");
INSERT INTO kms_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas ni oyi nindim, “Pudi nungoqi kin iri sipsip ire yequ pu di nginy Sabat kin tende puayi sipsip te ngamo pe ir wughe, tedi ni pughe sin nen? Ni nitiq wuse qo nimbiq wuwi wundi segi bri? ");
INSERT INTO kms_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pudi wutamu sipsip ane tuqui segi, wutamu quan nganye yumbui. Pugri bu beghi lo puq wund nginy Sabat kin te ningg wute ghav bidiny tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Muq ni wuti si kuti kin te simbe nindig, “Nu si tuqu kuso.” Di ni si nituqu kuso, muq ni si mune oghi, si yuwon kin opu gri kuse kin pugrine ire te mune oghi kuse. ");
INSERT INTO kms_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pudi Parisi ni God yumbui nyamb mirang kin baj te si miraq mo aye pe mo mas, di Jisas mi nati ningg wand wand mare. ");
INSERT INTO kms_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tende puayine Jisas ni nei namb Parisi ni yumbo ur ninge yembe mindiny ningg, pugri bu ni tiqe te si niraq, di wute buagi ninde dobu ruru. Wute buagi num kureny kin te ni sabi nindiny oghi, ");
INSERT INTO kms_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","di ni segi puq nindiny ei ni God ningg wo te kin ningg wute aye simbe rindiny segi. ");
INSERT INTO kms_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ni yumbo ur puq nen kin te propet iri Aisaia puq mindig kin ninde mim pe God simbe nand kin ane tuquine. Ni pugri puq nand: ");
INSERT INTO kms_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wuti nen ni nge ningg yembe ye iri, nge ni si gubog, ni irine nge ni yawo girag righe, di nge umbo ni ningg quan nganye chumbuai gud. Nge ningg ququ ninde kowi nas, di ni nge wute tuquine puq keny ye te ningg Juda segi kin simbe nindiny. ");
INSERT INTO kms_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ni ker nawo segi, di quan kumo nari segi, di ni ngimne no wand kumo nand kin te wute rutungu segi. ");
INSERT INTO kms_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni taqme nuqu te paqe nowi segi, di ni lam ire wel omo kin te awu nindiq segi. Ni pugrine yembe yembene yenu ruso ruso, otiwo nge wute tuquine puq keny kin wute buagi ruqond nei rimb. ");
INSERT INTO kms_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Di ninde nyamb pe Juda segi kin buagi ni te ruqond di ni ghimbi ruang, ni nandi di ni ghav nindiny.” ");
INSERT INTO kms_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tende puayi wute ninge ni wuti iri mitanyi Jisas nde mandi. Wuti nen ququ brequ ninde yenu, bu ni rar chukoq di wand nand segi. Jisas ni wuti te sabi nindig, pugri bu ni wand nand di rar bure nindiq, rar nat. ");
INSERT INTO kms_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wute buagi ni Jisas yumbo ur yembe nindiny kin te ruqond, di ni nei kumo rimb. Ni kin kin pengu rind, “Wuti nen ne bri Devit ningg kuqo?” ");
INSERT INTO kms_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tende puayine Parisi ni wand ven mutungu, di ni oyi mand mari, “Wuti nen ni ququ brequ mingg yumbui, Belsebul puq bidig kin, ni gre neng bu ni ququ brequ puaq nand ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas ni nei te nundom, di ni pugri puq nindim nari, “Kantri ire kin wute ni bir mawo kin kin mege, tedi kantri te oghine yembe wund tuqui segi, ir wughe ye. Di wuti iri ngam wo ane bir ruwo di priprine riri riri, tedi ane ruwo gudo tuqui segi, kin kin yeru. Muq tiqe ire o wute baj ire pe kin ni bir ruwo opu opu yeru rege, tedi tiqe o wute baj ire kin rikur segi, ni bir kin kin yeru. ");
INSERT INTO kms_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te kin pugrine Satan ni nikin ququne ququ aye puaq mand mo, tedi ququ buagi ninde si nambu mas kin ni bir kin kin mo, di gre pu yemu kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nungoqi wari nge Belsebul nde gre pe bu ququ brequ puaq gad. Pugri bu nge puq gad, nge Belsebul nde gre pe ququ brequ puaq gad, tedi nungoqi non wute tughe nde gre pe ququ brequ puaq mand? Nungoqi non wute tene bei munduq nungoqi unje wap. ");
INSERT INTO kms_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pudi nge God ningg Ququ nde gre pe ququ brequ puaq gad, tedi nungoqi nei wamb wute God nde si nambu ris ye ngeri te nungoqi nde rindi pre. ");
INSERT INTO kms_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Wuti iri ni wuti aye iri gre quan rise kin ni baj bir nuang nar no yumbo nateri tuqui segi. Ni wuti gre quan rise kin te taq naimb pre, tedi ni baj bir nawo nar no yumbo sir nateri. ");
INSERT INTO kms_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wuti iri ni nge wuti segi, tedi ni nge veri kin pugri. Wuti nge ghav nindigh di sipsip pirur segi kin wuti te ni oyi sipsip bub nare ruso ye. ");
INSERT INTO kms_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yumbo ur pugri ye te ningg nge nungoqi simbe guduq, wute yumbo ur brequ mand di wand brequ mand kin wand te puaq ye tuqui. Pudi wuti iri Ququ Yuwon Ye wand brequ nindig ye ni wand te puaq segi ye. ");
INSERT INTO kms_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wuti tughe ni wuti God nde pu nandi wuti nganye nas kin te wand brequ nindig, te kin wand God puaq nand ye tuqui. Pudi wuti tughe ni Ququ Yuwon Ye wand brequ nindig, te God ni te kin wand puaq nindig segi ye. Otiwo pudi mune tuqui segine.” ");
INSERT INTO kms_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas ni mune simbe nand nari, “Nyumo oghi kin te ni yi oghi ye rire. Di nyumo brequ kin te ni yi brequ ye rire, nyumo yi te wuqond di nungoqi nei wamb ni nyumo oghi o brequ. ");
INSERT INTO kms_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Parisi, nungoqi ghati sindiyu wo. Nungoqi wutaqu brequ, tedi pughe gri ei wand oghi ye wand? Wuti te ni nei isis umbo pe vise kin te bu mim wand vind. ");
INSERT INTO kms_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wute yuwon kin ni nei isis yuwon kin rise, bu ni yumbo ur yuwon ye yembe rindiny. Pudi wute brequ kin ni nei isis brequ kin rise bu ni yumbo ur brequ ye te yembe rindiny. ");
INSERT INTO kms_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pudi nge nungoqi simbe guduq, God ni wute ir nawo kin tende puayi wute buagi ni ruso God simbe rindig pughe kin ningg ni wand isis te kin rind. ");
INSERT INTO kms_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nungoqi non wand tende pene ei God nungoqi ir nuaqu, nungoqi wutaqu tuquine was kin o nungoqi wutaqu brequ.” ");
INSERT INTO kms_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Muq wute Moses ningg lo wute bei meny kin di Parisi ane Jisas pengu mindig mari, “Tisa, beghi pari nu yumbo ur gre ye ire yembe nduw, ei beghi budoq.” ");
INSERT INTO kms_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Di ni oyi nand nari, “Nungoqi wute muq ren nde puayi kin nungoqi wute brequ, di God nei wumbig segi. Nge yumbo gre ye yembe gidiny wuqond ningg wari bri? Nge segi puq gad. Yumbo gre ye propet iri Jona puq mindig kin ni bei nand pre. ");
INSERT INTO kms_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona yabe chuqo ni wuye umo yumbui umbo wabe nar nase nginy temi ire pu bur tengi ire pu. Te kin pugrine otiwo wuti God nde pu nandi wuti nganye nas kin ni qi gawo pe nase nginy temi ire pu di bur tengi ire pu. ");
INSERT INTO kms_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","God ni wute ir nawo kin tende puayi Ninive kin wute ni res riwo di God nde rar pe simbe rind ye. Ni simbe rind kin te nungoqi wutaqu muq ren nde puayi yumbo ur brequ wand kin te simbe rind. Te pugri ni Jona wand bir nawo kin te rutungu di ni nei rire ritinde. Di nge nungoqi simbe guduq, wuti iri Jona nde quan nganye yumbui kin nen nas. Pudi nungoqi ni ningg wand te wutungu segi. ");
INSERT INTO kms_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Otiwo God ni wute buagi ir nawo kin tende puayi di Kwin Siba opu kin ni wes wiyo di nungoqi yumbo ur brequ muq ven nde puayi yembe wundiny kin te simbe wund. Te pugri ni qi cheq pe pu wundi King Solomon ni nei oghi ye simbe nand kin te wutungu ningg. Pudi nge nungoqi simbe guduq, wuti iri Solomon nde ni quan nganye yumbui kin nen nas, di nungoqi ni ningg wand wutungu segi.” ");
INSERT INTO kms_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas ni mune simbe nand nari, “Ququ brequ ni wuti iri si neri, ni no wuye di nyumo segi ye pe tende no nas yawotuan kin sunyi meri nat, pudi ni sunyi ire nuqond segi, ");
INSERT INTO kms_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tedi ni nari, ‘Nge mune baj asi kas kin pe tende ko.’ Di ni mune nandi nuqond baj pe te wute mas segi, baj bureng maip, di yumbo sabi mindiny. ");
INSERT INTO kms_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Muq ququ brequ asi nas yumbo ur brequ musoqne nand kin te ni mune no, ququ brequ aye 7-pela pu mune nitami nandi, ni quan nganye yumbo ur brequ mand ye, di ni nitami nar no tende mas. Wuti nen asi brequ nase, pudi muq ni quan nganye brequ nase. Te kin pugrine muq ven nde puayi wute ni yumbo ur brequ rind kin ane tuquine.” ");
INSERT INTO kms_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas ni wute buagi te wand simbe nindiny nindinyne yenu, ni kumo di kiqam ane rindi pu dabo yeru, ni ghimbi ruang nandi ei ane wand ningg. ");
INSERT INTO kms_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wuti iri ni simbe nindig nari, “Nu numo niqam ane rindi pu dabo te yeru, ni nu ane wand ningg bu pengu rind.” ");
INSERT INTO kms_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas oyi nand nari, “Wute tughe nge moyu di wute tughe nge qam?” ");
INSERT INTO kms_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Di nikin wute te si numbony muq nari, “Wute ren nge moyu di nge qam. ");
INSERT INTO kms_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Te pugri wute tughe nge wuyi wam nas kin nari kin pugri puq ren ye ni nge qam di nge nyumbu di nge moyu.” ");
INSERT INTO kms_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nginy te ningg Jisas ni baj te si nare, di ni no Galili wuye ngamo qunambe nas. ");
INSERT INTO kms_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ni nas wand bir nawo kin pe tende bot ire yequ. Di wute nganye buagi nganye rundo rikur ni quir quar rindig, pugri bu ni bot pe newo no nas, di wute buagi ni dabo jiji pe yeru, muq ni wand simbe nand. ");
INSERT INTO kms_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Muq ni wand nganye buagi te kopuqu wand pene simbe nindiny nari, “Wuti iri nikin wuny mbe no di wit yi puraq nand. ");
INSERT INTO kms_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ni puraq nand nand di wit yi ninge ngimne ir ri, di wapi rindi riq. ");
INSERT INTO kms_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ninge qi wet kin pe ir ri. Tende qi quan wus segi bu ni wamne ris, pugri bu ni brequne ruwi, ");
INSERT INTO kms_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pudi nginy nawi, wit te nande namb di quari rimb. Te pugri ni tumuri quan maghe mo segi. ");
INSERT INTO kms_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit yi ninge ruso nyungo quat kin pe ir ri di nyungo quat kin ni nambu wi ruso. ");
INSERT INTO kms_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pudi ninge qi oghi ye pe ir ri righe kin te ni mir rise. Ninge 100-pela pu rire, ninge 60-pela pu rire, di ninge 30-pela pu rire. ");
INSERT INTO kms_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wuti iri ni nutungu kin tuqui tedi ange nuaq ei wand ren nutungu.” ");
INSERT INTO kms_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas nikin wute mandi ni pengu mindig mari, “Pughe kin ningg wute ren nu kopuqu wand pe simbe gudiny?” ");
INSERT INTO kms_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ni oyi nand nari, “Yumbo yumbo buagi God nde si nambu rise kin wand suqo pu rise kin te God nungoqi nei neuq di nungoqi nei wumbiny tuqui, pudi ni wute ren bei neny segi ye. ");
INSERT INTO kms_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wuti tughe ni nei yuwon ye ninge rise, tedi God ni nei aye mune neng, ei ni nei quan rise. Pudi wuti ni nei yuwon segi, musoqne rise, tedi God mune natevi. ");
INSERT INTO kms_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Te puate ven ningg bu nge kopuqu wand pe simbe gidiny. ‘Ni rar pe ruqond pudi ruqond rip ruso segi. Ni ange ruaq rutungu pudi nei rimb segi.’ ");
INSERT INTO kms_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ni ningg propet iri Aisaia puq mindig kin ni simbe nand kin ane tuquine. Ni nari, ‘Nungoqi ange waq wutungu, pudi nei wumbiny tuqui segi. Nungoqi rar wat wat, pudi wuqond tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Te pugri wute ren ni nei ghabe rindiny, di ni ange tuq rimbiny, di ni rar imb ruany pre. Eti ni rar pe ruqond, ange pe rutungu, di nei pe nei rimbiny, di ngende tindi rindi di nge ni sabi gidiny oghi.’ ");
INSERT INTO kms_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pudi nungoqi nge ningg wute nungoqi rar pe wuqond, di ange pe wand wutungu. Te ningg bu nungoqi chumbuai wand. ");
INSERT INTO kms_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Te nge nungoqi nganyene simbe guduq, asi propet di God ningg wute tuquine mas ye ninge ane nungoqi muq yumbo ur wuqond kin te ni quan nganye ruqond yawo kureny, pudi ni ruqond segi. Di nungoqi muq wand wutungu kin ven ni mune rutungu yawo kureny, pudi rutungu segi. ");
INSERT INTO kms_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nungoqi wutungu, kopuqu wand wit yi puraq nand kin wand puate taq pugri: ");
INSERT INTO kms_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wute ninge yumbo yumbo buagi God nde si nambu rise kin te kin wand ni rutungu, pudi ni nei rimb segi. Wute ren ni wit yi ngimne ir ri kin pugri. Ququ brequ mingg yumbui ni nandi God ningg wand ninde umbo pe vise kin te puaq nand. ");
INSERT INTO kms_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Muq wit yi ninge qi wet pe ir ri kin taq wuti tughe ni wand ven nutungu di brequne chumbuai ane natevi. ");
INSERT INTO kms_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pudi ni tumuri quan maghe mo segi kin pugri, ni wand te kin nei pe nawo vis nganye segi. Ni God ningg wand nutungu, pudi wute ninge wand te ningg brequ mindig ningg mai isis meng kin tende puayi ni brequne ir naghe. ");
INSERT INTO kms_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wit yi ninge nyungo quat kin pe ir righe kin te wuti wand nutungu, pudi yumbo qi pe kin yivany nirany, di yumbo quan rise ningg nari. Yumbo ren ni nei imb ruang bu God ningg wand ni nde mir rire segi. ");
INSERT INTO kms_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pudi wit yi qi oghi ye pe ir ri kin te wuti iri wand ven nutungu di puate nei nimbiny. Wit te ni yi rise pre, ninge 100-pela pu di ninge 60-pela pu di ninge 30-pela pu rire.” ");
INSERT INTO kms_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas ni kopuqu wand aye mune simbe nindiny nari, “Yumbo yumbo buagi God nde si nambu rise kin te pugri, wuti iri nikin nde wuny mbe wit yi oghi kin menare. ");
INSERT INTO kms_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pudi wute buagi ruqo rise pre, ni veri nandi wit yi mingi tende ni mune nyungo brequ kin yi te menare pre, di ni no. ");
INSERT INTO kms_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Otiwo wit yi te ruwi mir rire ningg, ni muqond nyungo brequ mune anene ruwi. ");
INSERT INTO kms_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Muq yembe ye wute ni mo wuny kiyi pengu mindig mari, ‘Yumbui, beghi buqod nu wit yi oghi kinne bu wuny mbe mekuare. Pudi nyungo brequ wen muai pu wundi?’ ");
INSERT INTO kms_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ni oyi nand nari, ‘Veri ni puq nen!’ “Yembe ye wute ni wuny kiyi pengu mindig mari, ‘Nu nei guab ye beghi po nyungo brequ te bi pawo?’ ");
INSERT INTO kms_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ni oyi nand nari, ‘Wayequ. Nungoqi wo nyungo brequ te bi wawo, eti wit ane bi wawo. ");
INSERT INTO kms_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Rar wuqond teri anene ruwi. Otiwo mir pateri kin tende puayi, muqdi nge wute tende yembe mand kin simbe gidim, ni nyungo brequ te bi mawo wumb muqond wase mande pre, muqdi wit yi materi nge nde mir baj pe mawo ris’.” ");
INSERT INTO kms_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Muq ni kopuqu wand aye mune simbe nand nari, “Wute God nde si nambu ris kin ni mastet yi kin pugri. Wuti mastet yi nare no nikin nde wuny mbe ni righe. ");
INSERT INTO kms_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet yi wokuandi nganye ni nyumo aye ninge kin yi pugri segi, ni mowi kin minye ninge wuny mbe mi righe kin ane tuqui segi, ni quan nganye yumbui, ni nyumo kin pugri. Wapi rindi ninde muange pe tende ris.” ");
INSERT INTO kms_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Muq ni kopuqu wand aye mune simbe nindiny, “Wute God nde si nambu ris kin ni yis kin pugri. Wute ire yis puch wutaqwi di plaua os yumbui pe waq wughe di ane quang wumbiq. Di otiwo yis plaua pe wur ir di plaua te quanene yindiqi.” ");
INSERT INTO kms_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Wand ven Jisas ni kopuqu wand pe wute buagi te simbe nindiny. Ni wand ire raqene simbe nand segi, ni pripri kopuqu wand pene simbe nand. ");
INSERT INTO kms_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wand ven propet iri ni simbe nand ye ane tuquine. Ni nari, “Nge simbe gad kin kopuqu wand pe ei simbe gad ye, di nge simbe gad kin te God qi yembe nunduw kin tende puayi pune rindi muq God ni yumbo suqo nare pu rise kin te ningg ei simbe gad.” ");
INSERT INTO kms_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Muq ni wute buagi te si nare baj pe nar no. Di nikin wute mandi mari, “Beghi wand puate simbe ndug, kopuqu wand pe nyungo brequ wuny mbe ruwi kin te pughe kin?” ");
INSERT INTO kms_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ni oyi nindim nari, “Wuti tughe ni wit yi oghi ye kuan nawo kin te wuti God nde pu nandi wuti nganye nas ye. ");
INSERT INTO kms_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wuny te qi. Di mir yi oghi kin te wute God nde si nambu ris ye. Nyungo brequ te wute Satan nde si nambu ris ye. ");
INSERT INTO kms_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Di veri ni nyungo brequ wuny mbe meniraq kin te Satan. Mir nguan materi kin te ngeri pre kin tende puayi. Wute wuny mbe yembe mand kin te angelo buagi. ");
INSERT INTO kms_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nyungo brequ taq mamb wase pe memare riwo namb kin te otiwo ngeri pre kin tende puayi. ");
INSERT INTO kms_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wuti God nde pu nandi wuti nganye nas kin ni angelo tiqi nundom wute God nde si nambu ris kin tende mingi mo di yumbo wute nei brequ rindiny kin te di wute yumbo ur brequ rind kin te puaq mand ruso, ");
INSERT INTO kms_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","di wase yumbui pe memare righe namb. Di wute ni quan nganye mari di sawo mat ki. ");
INSERT INTO kms_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Muq wute yumbo ur tuquine yembe rindiny kin ni wute kiyi nde si nambu ris kin tende nginy kin pugri ti nase. Wuti iri ni wand nutungu kin tuqui tedi ni ange nuaq ei wand ren nutungu.” ");
INSERT INTO kms_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Wute God nde si nambu ris kin ni wet bidi bokis ane wuny mbe suqo miraq pu wuse kin pugri. Wuti iri nundoq di mune but niraq, di ni quan nganye chumbuai nand, di ni no yumbo buagi te wute nem wong mand pre, di ni nandi wuny vise kin qi puch te wong nindiq. ");
INSERT INTO kms_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Wute God nde si nambu ris kin te wuti iri mitani yuwon nganye meri nand kin pugri. ");
INSERT INTO kms_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wuti te mitani quan nganye yuwon kin te nundoq, ni no yumbo buagi te wute nem wong mand, pre di ni nandi mitani te wet bidi yumbui pe wong nindiq.” ");
INSERT INTO kms_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas ni mune simbe nand, “Wute God nde si nambu ris ye te yawi kin pugri ni gherim pe memeri naghe no di umo isis materi. ");
INSERT INTO kms_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yawi te bre, tedi wute umo qo mamb rindi dabo, di ni mas umo te ir mawo. Umo oghi kin te materi imbi pe mawo righe, di brequ kin te memare ruso. ");
INSERT INTO kms_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te kin pugrine otiwo ngeri pre kin tende puayi di angelo mandi wute ir mawo brequ kin opu di tuquine puq ren kin opu, ");
INSERT INTO kms_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","di wute brequ kin te memare wase yumbui pe tende righe ruso, di quan nganye riri riri sawo rit ki. ");
INSERT INTO kms_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nungoqi wand puate ven nei wumbiny bri?” Di nikin wute oyi pugri puq mindig, “Beghi nei bab.” ");
INSERT INTO kms_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Di ni simbe nindim nari, “Wute Moses ningg lo wute bei meny kin ninge ni God nde si nambu mas ningg mari kin, ni wuti iri baj kiyi kin pugri. Ni yumbo baj pe nawo ris kin te nare nandi, ninge urupui kin di ninge asi kin.” ");
INSERT INTO kms_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Muq Jisas ni kopuqu wand te simbe nand pre, di ni tiqe te si niraq, ");
INSERT INTO kms_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","mune nikin nde tiqe pe nandi, di no God yumbui nyamb mirang kin baj pe nar no, wand bei neny. Muq ni wand nand kin te ni rutungu nei kumo rimb, kin kin pengu rind riri, “Wuti nen ni quan kumo nei namb di yumbo ur gre ye bei nand kin ren muai pu nateri? ");
INSERT INTO kms_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ni kiyi kapenta iri. Di ni kumo te Maria. Di ni kiqam Jems di Josep di Saimon di Judas. ");
INSERT INTO kms_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Di ni kunyumbu beghi ane ren nde pas. Ni quan kumo nei namb di yembe gre ye ren muai pu nateri?” ");
INSERT INTO kms_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Di muq ni yambu rireng. Pudi Jisas ni simbe nindiny nari, “Propet iri nikin tiqe pene di nikin nde baj pene wute ni nyamb rindivi viyo segi. Wute buagi aye ni nyamb rindivi viyo.” ");
INSERT INTO kms_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ni God nei rimbig segi, bu Jisas yumbo ur gre ye quan tende yembe nindiny segi. ");
INSERT INTO kms_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tende puayi Herot ni Galili king ningg nas, ni Jisas yembe nand kin wand te nutungu. ");
INSERT INTO kms_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Di nikin yembe ye wute te ningg nari, “Wuti nen, Jon wute wuye nap kin teneqa nen, ni nati pre mune nes newo, pugri bu yumbo ur gre ye yembe nindiny kin gre ninde rise.” ");
INSERT INTO kms_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot ni asi Jon ni nati kin taq pugri: Asi Herot ni kiqam Pilip ni Herodias nitaqi, muq Herot kiqam ngam Herodias puaq nindiq nitaqi. Te ningg bu Jon ni pugri simbe nindig nari, “Nu Herodias kutaqi kin te lo segi puq wund.” Pugri bu ni Jon nait nase, sare pe taq naimb, taq yemu kin sunyi pe ni nar no. ");
INSERT INTO kms_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot ni Jon ni nati ningg nei nimbiq, pudi ni wute buagi wune nimbiny, te pugri ni nei rimb Jon ni propet iri. ");
INSERT INTO kms_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pudi Herot ni asi kumo wuri wundi kin nginy tende puayi. Herodias ni wonyumbu wundi wute buagi ris kin tende yuwo nyinge wuwo. Herot ni yuwo nyinge wuwo kin te nundoq yawo nare righe. ");
INSERT INTO kms_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Muq ni simbe nunduw nari, “Nu yumbo pughe kin ningg nge pengu ndigh, tedi nge kew ye.” Di ni Yumbui nde rar pe wand te gre neny. ");
INSERT INTO kms_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodias ni kuwonyumbu pugri simbe wunduw bu kuwonyumbu wuri, “Jon wute wuye nap kin ni ngawu nyeng pe ven nde ghowi naghe nge yegh.” ");
INSERT INTO kms_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King ninde nei pe yuwon rind segi. Pudi ni asine wute ni ane mir rind kin ni nde rar pe wand gre neny pre, pugri bu ni ngiq nand, ngawu new ye. ");
INSERT INTO kms_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ni wuti iri tiqi nundog no wute taq yemu kin baj pe no Jon gibe pend nuang. ");
INSERT INTO kms_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Di ni ngawu nyeng pe nowi naghe neri nandi, wo te new di ni mune wuri wuso kumo wew. ");
INSERT INTO kms_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Di Jon nikin wute mandi, Jon meti nowi ngamo pe mowi yenu, di ni mo Jisas simbe mindig. ");
INSERT INTO kms_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Muq Jisas ni wand ven nutungu, ni nikin wute ane sunyi te si mare, at pe mewo mo mas, mong wute segi ye pe tende mo. Pudi wute buagi ni wand rutungu, tiqe si rire ni nande kin tende nyinge rire dobu ruru. ");
INSERT INTO kms_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas ni at si niraq nyinge nare no, wute nganye buagi nganye ris nuqond di ni yawo nitony, di ni num kin te sabi nindiny. ");
INSERT INTO kms_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tende yuram Jisas nikin wute mandi, Jisas simbe mindig mari, “Mong ven nde opu te wute segi, nginy yabe quan naghe no. Wute buagi ren tiqi ndony tiqe manyi te ruso ei mir ni kinne wong rind riq.” ");
INSERT INTO kms_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas ni oyi nand nari, “Ni ruso wayequ, nungoqi ei mir weny riq.” ");
INSERT INTO kms_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ni oyi mindig mari, “Beghi bret 5-pela pune di umo terine rise.” ");
INSERT INTO kms_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Di ni oyi nand nari, “Nge nde ware wandi.” ");
INSERT INTO kms_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Muq ni nari wute buagi te nyungo pe tende ris, di ni bret 5-pela pu di umo teri te nateri, di ni wam rar neq wiyo, God chumbuai nindig pre di bret te bir nawo. Pre muq nikin wute nde ni rundo, di ni mare mo wute buagi te meny. ");
INSERT INTO kms_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Di ni buagi ane mir rind ruso ruso mir rimbiq, di Jisas nikin wute mo mir cham te materi imbi pe mawo righe ruso imbi 12-pela pu bre mand. ");
INSERT INTO kms_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Di wute tende ris mir rind kin te quayine 5,000-pela pu, nyumbueg di wo buagi te manyi mand segi. ");
INSERT INTO kms_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Te pre di brequne Jisas nikin wute simbe nindim at pe mewo mo ye mawo mo, wuye ngamo pe opu gri mo ningg, di Jisas ni tene yenu wute buagi te tiqi nundony nikin tiqe ruso. ");
INSERT INTO kms_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ni wute buagi tiqi nundony ruso pre dobu nikin irine rand pe newo no yenu di God pengu nindig. Ruso nginy naghe no yuram pudi ni irine rand pe tende yenu. ");
INSERT INTO kms_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Muq tende puayi at te wuye ngamo mingine yequ pre, pudi nyumurighi naghe gherim seme te at choch nipiq niraq nandi. ");
INSERT INTO kms_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Di yambgriq tumo Jisas rand pe pu nati ni, di wuye wamne nyinge nare nikin wute nde nondo. ");
INSERT INTO kms_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Muq nikin wute ni muqoind, ni wuye wam nyinge nare nandi, ni quan nganye wune mamb, ni mari, “Nen wuye wariwo!” Ni wune mamb bu quan mari. ");
INSERT INTO kms_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pudi brequne ni simbe nindim nari, “Nungoqi gre pu yequ. Wune wamb wayequ, ngene bu gadi.” ");
INSERT INTO kms_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Muq Pita Jisas simbe nindig nari, “Yumbui, nganyene nganye nunonne ate nge gig ghari nge mune wuye wamne nyinge kare nunde godo.” ");
INSERT INTO kms_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ni nari, “Be ghandi.” Muq Pita ni at pe pu newo naghe wuye wamne nyinge nare Jisas nde nondo. ");
INSERT INTO kms_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pudi ni nyumurighi quan gre nand kin te nuqoind, wune namb, di wuye pe naghe no yamb. Muq ni Jisas ningg nari, “Yumbui, nge gheti kowi.” ");
INSERT INTO kms_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Muq Jisas ni brequne si neq wondo nait nase, di ni ningg nari, “Nu nge musoqne nei gubigh! Pughe kin ningg nu nei tevi vise?” ");
INSERT INTO kms_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Di ni temi mandi at pe mewo maghe, di nyumurighi opu prene. ");
INSERT INTO kms_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Di wute at pe mas kin te ni yumbui nyamb mirang di mari, “Nganyene nganye nu God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Di ni opu gri mowi mati, Genesaret nde qi pe mandi. ");
INSERT INTO kms_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Di wute buagi tiqe te kin ni Jisas ruqoind rip no, di wand ri viso tiqe manyi Genesaret yeru kin te rutungu di wute num kin buagi rire Jisas nde rindi. ");
INSERT INTO kms_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Di ni Jisas pengu rindig ei wute num kin ni rindi Jisas ningg chongo cheq te riting wuse ei ni num oghi ningg. Di wute buagi rindi chongo riting wuse kin te ni num oghi. ");
INSERT INTO kms_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi di wute Moses ningg lo wute bei meny kin Jerusalem pu Jisas nde mandi di pengu mindig mari, ");
INSERT INTO kms_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pughe kin ningg nunon wute te koku mingg yumbo ur te gure mawo? Ni mari, beghi si wuye pap pre ei mir bad, pudi nunon wute ni si wuye map segine mir mand.” ");
INSERT INTO kms_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas ni oyi nindim nari, “Di pughe kin ningg nungoqi God ningg lo gure waq, di nungoqi non nuqo mingg chuqo tene yembe wundiny? ");
INSERT INTO kms_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God ni nari, ‘Nungoqi nuyi numo ningg wand te irepene ei wutungu,’ di ‘Wuti tughe kiyi o kumo wand brequ nindiny tedi wi nati.’ ");
INSERT INTO kms_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pudi nungoqi wute simbe wundiny wari wuti iri yumbo ninge kiyi o kumo ghav nindiny ningg, pudi ni simbe nindiny nari, ‘Nge yumbo nungoqi ghav guduq kin ren te God geg ningg kiping ruso pre.’ ");
INSERT INTO kms_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wuti te ni kiyi ningg wand nutungu segi di ghav nindig segi. Te kin ningg nungoqi God ningg wand te meware ruso di nungoqi non nuqo mingg chuqo tene yembe wundiny. ");
INSERT INTO kms_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nungoqi wutaqu umbo pe nei brequ bre pu rise muq nange vingg wute rundoqu ninggne yumbo ur yuwon ye wand. Asi propet Aisaia ni nungoqi ningg nari ye te nganyene nand. Ni nari, ");
INSERT INTO kms_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Wute men ni mim pe nge yumbui nyamb miragh, pudi ninde umbo pe nge nei mimbigh segi. ");
INSERT INTO kms_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ni nge yumbui nyamb miragh ye te ghav rindim segi, te pugri ni wute gri lo yembe mindiny kin te oyi God ningg lo kin pugri wute bei meny’.” ");
INSERT INTO kms_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Di Jisas ni wute buagi te ningg nari ninde rundo di simbe nindiny nari, “Wutungu di nei pe wawo vis. ");
INSERT INTO kms_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yumbo dabo pu wuti nde rir ruso kin te ni unje rip segi, pudi yumbo pughe wuti nde nei pe pu riyi ri kin te ni unje rip.” ");
INSERT INTO kms_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Muq nikin wute ninde mandi di simbe mindig mari, “Nu wand guad kin te ningg Parisi ni umbo brequ kuse kin te nu nei gubiny?” ");
INSERT INTO kms_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas ni oyi nand nari, “Yumbo buagi nge wuyi wam kin kuan nawo segi kin otiwo ni puate ane bi nawo. ");
INSERT INTO kms_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nungoqi ni si ware. Ni wute rar chukoq kin pugri. Wuti rar chukoq kin iri ni rar chukoq kinne aye iri ngim bei nindig, tedi temi ane mo ngamo pe ir maghe.” ");
INSERT INTO kms_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita oyi Jisas simbe nindig nari, “Beghi kopuqu wand ven kin puate te bei yengu.” ");
INSERT INTO kms_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Di ni oyi nari, “Pughe gri ate nungoqi mune nei wamb segine? ");
INSERT INTO kms_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nungoqi nei wamb segi bri, yumbo ninde mim pe gri ne righe ruso kin te mune umbo che nawo ruso. ");
INSERT INTO kms_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pudi yumbo mim pe simbe bad kin te nei pe pu rindi, di yumbo ren kin wuti unje rip. ");
INSERT INTO kms_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Te pugri umbo pe yumbo ur buagi ren rise: nei brequ, wute mamb riti kin nei, wute ngam ruso kin wute aye ane rise kin nei, quayi nyumbueg ane segi segi rise kin nei, nyungu kin nei, wandoqi mand, di wute aye nyamb brequ mindiny. ");
INSERT INTO kms_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yumbo pugri kin te God nde rar pe wute unje rip. Pudi wuti si wuye nap segine mir nand kin te God nde rar pe unje rip segi.” ");
INSERT INTO kms_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas ni Israel mingg qi te si niraq, Tair di Saidon opu no. ");
INSERT INTO kms_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Di Kenan kin nyumbueg ire tende wus kin wundi Jisas ningg wuri, “O yumbui, nu Devit ningg kuqo, nu nge yawo togh. Nge wo nyumbueg ququ brequ ninde ghimbi pe yenu di ni mai wuraq.” ");
INSERT INTO kms_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pudi ni wand ninge simbe nand segi. Di Jisas nikin wute mandi buid map simbe mindig mari, “Tiqi ndow wuso, ni beghi nde dobu wuwi wuri nyuw wup.” ");
INSERT INTO kms_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ni oyi nand nari, “God nge tiqi nundogh gadi kin Israel mingg sipsip ir ruso kin te ninggne bu gadi.” ");
INSERT INTO kms_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pudi ni wundi Jisas nde muange tingi sungomyu gure wuwo yimb wughe wuri, “Yumbui, nge ghav ndigh.” ");
INSERT INTO kms_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Di ni oyi nand nari, “Beghi wo ni mir te nikin nyombui mepirany rundo riq kin te oghi segi.” ");
INSERT INTO kms_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Di ni wuri, “Yumbui, te nganyene, pudi mir cham ni kiyi nde ede pe tende ir ri kin te nyombui riq yuwon ruany.” ");
INSERT INTO kms_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Muq Jisas ni oyi nand nari, “Nyumbueg, nu nge quan nganye nei gubigh! God nu yumbo nei gubiny kin te puaq nand ye.” Di ni wo nyumbueg brequne mune oghi wuse. ");
INSERT INTO kms_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ni tiqe te si niraq, wuye ngamo Galili qunambe nyinge nare no. Ni rand pe newo no, di tende nas. ");
INSERT INTO kms_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Di wute buagi ninde rindi, ni wute nyinge brequ kin, di wute rar chukoq kin, di wute nyinge rengu kin, di wute wand mand segi kin, di num kin buagi aye te ane mitari mandi, Jisas nde muange tingi mawo ris, di Jisas sabi nindiny oghi. ");
INSERT INTO kms_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wute buagi ni ruqond, wute wand rind segi kin te mune wand rind, di nyinge rengu kin te mune oghi, di nyinge brequ kin te mune nyinge rire, di rar chukoq kin te mune rar rit, di ni te ruqond nei kumo rimb. Di ni Israel mingg God ni nyamb rindivi viyo. ");
INSERT INTO kms_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Muq Jisas nikin wute ngam niram ninde mandi simbe nindim nari, “Nge wute ren yawo kutony, te pugri ni nge ane pas nginy temi ire pu, di ni mir segi. Nge ni mir ane tiqi gudony ruso yambu kari, eti ni ngimi rar ori riti.” ");
INSERT INTO kms_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Di Jisas nikin wute Jisas ningg mari, “Beghi wuye di nyumo segi ye pe ven nde pas, di muainde ei bret pateri kin tuqui di wute buagi ren mir bag bab?” ");
INSERT INTO kms_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Di Jisas ni mingg nari, “Nungoqi bret pughe gri pu rise?” Ni mari, “Bret 7-pela pu, di umo woju ninge ane.” ");
INSERT INTO kms_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Di Jisas ni wute buagi te simbe nindiny qi pe ris. ");
INSERT INTO kms_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ni bret 7-pela pu di umo ane nateri, God chumbuai nindig pre, bir nawo di nikin wute te nem, di nikin wute mare mo wute buagi te meny. ");
INSERT INTO kms_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ni mir rind di mir rimbiq, di Jisas nikin wute ni mir cham te mune materi imbi pe mawo righe ruso di imbi 7-pela pu bre mand. ");
INSERT INTO kms_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wute quayi ni bret me kin te 4 tausen pela pu. Ni nyumbueg wo ane manyi mand segi. ");
INSERT INTO kms_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Di Jisas wute buagi tiqi nundony ruso, di ni at pe newo no Magadan mingg qi pe no. ");
INSERT INTO kms_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi di Sadyusi ane Jisas maip mi newo ningg ninde mandi, pengu mindig ei ni wam kin yumbo ur gre kin ire bei nand muqond. ");
INSERT INTO kms_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ni oyi nindim nari, “Yuram nginy ambo newo tedi nungoqi wari prangi ngeri oghi. ");
INSERT INTO kms_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Di burane wuye quari wumb nginy tu ambo viyo, tedi nungoqi wari muqdi nyumurighi naghe di wuye wundi. Te nganye nungoqi yumbo ur nginy tu pe kin te wuqond di nei wamb wuye wundi o segi, pudi nungoqi muq ven nde puayi kin yumbo ur te puate nei wumbiny segi. ");
INSERT INTO kms_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nungoqi muq ven nde puayi was kin nungoqi wutaqu brequ, God nei wumbig segi. Nungoqi nge yumbo ur gre ye ire yembe guduw ningg pengu wand bri? Nge yumbo ur gre ye aye yembe gidiny segi, pudi nungoqi Jona ningg yumbo ur te wuqond di nei wamb.” Muq Jisas ni si nare di ni nyinge nare no. ");
INSERT INTO kms_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas nikin wute nei gheri map bu bret mare segine wuye ngamo misiq opu gri mo mewo. ");
INSERT INTO kms_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas ni mingg nari, “Nungoqi rar wat yuwon, Parisi di Sadyusi mingg yis te ningg ei yeng wawo yuwon.” ");
INSERT INTO kms_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Di ni kin kin wand mand mari, “Beghi bret ninge pare badi segi bu ni pugri puq nand.” ");
INSERT INTO kms_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pudi ni wand wand mare kin te Jisas ni nei namb pre, pugri bu ni pengu nindim, “Nungoqi nge musoqne nei wumbigh, pughe kin ningg wari nungoqi bret segi puq wand? ");
INSERT INTO kms_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nungoqi nei wamb segine bri? Wute 5 tausen pela pu di bret 5-pela pu me di imbi pughe gri pu mune wateri kin te nei gheri bri wap? ");
INSERT INTO kms_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O wute 4 tausen pela pu bret 7-pela pu me di imbi pughe gri pu mune wateri kin te nei gheri bri wap? ");
INSERT INTO kms_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pughe ningg nungoqi te nei wumbiny segi? Nge bret ningg wand gad segi. Nungoqi Parisi di Sadyusi mingg yis te ningg ei yeng wawo yuwon.” ");
INSERT INTO kms_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Muq Jisas nikin wute nei mamb, Jisas ni yis bret pe req wur kin te ningg yeng mawo yuwon ningg nari segi. Ni Parisi di Sadyusi mingg wand te ningg yeng muany yuwon kin te ningg bu ni simbe nindim. ");
INSERT INTO kms_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Muq Jisas ni tiqe ire Sisaria Pilipai tumo tende nandi di nikin wute pengu nindim nari, “Wute riri nge, wuti God nde pu gadi wuti nganye kas kin, nge tughe?” ");
INSERT INTO kms_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Di ni mari, “Wute ninge riri Jon wute wuye nap kin, ninge riri Elaija, ninge riri Jeremaia, o propet asi kin iri.” ");
INSERT INTO kms_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Di ni mingg nari, “Pudi nungoqi pughe gri nei wamb? Nungoqi wari nge tughe bri?” ");
INSERT INTO kms_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita oyi nand nari, “Nu Kraist, God nas nas roq kin ni ningg wo.” ");
INSERT INTO kms_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Di Jisas oyi nindig nari, “Saimon, Jona ningg wo, nu chumbuai ghand. Ven nu wuti iri nei new segi, pudi nge wuyi wam nas ye nu nei new. ");
INSERT INTO kms_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Di nge nu simbe guduw, nu nyamb Pita, di wet nen nde wam wute buagi nge nei rimbigh kin te kirur di gre pu yeru, di wute riti kin gre te ni nyinge ruwo righe kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yumbo yumbo buagi God nde si nambu yeru kin te kin ki nu kew ye. Yumbo pughe kin nu qi pe ven nde segi puq ghand te nginy tu wam tende God ni segi puqne nand pre, di yumbo pughe kin nu qi pe ven nde ngiq ghand te nginy tu wam tende God ni ngiqne nand pre.” ");
INSERT INTO kms_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Muq Jisas nikin wute simbe nindim nari, “Nungoqi nge Kraist, wuti God naip ko wute kate ruwi ye, te kin ningg wute aye simbe wundiny wayequ.” ");
INSERT INTO kms_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tende puayi Jisas nikin wute waghine simbe nindim nari, ni Jerusalem no ei mai niraq, ni quayi kiyi di prist mingg yumbui di wute Moses ningg lo wute bei meny kin ninde si pe yuqo niraq di ni mi nati. Pre di nginy temi mo pre aye ningg di God mune nindingi newo. ");
INSERT INTO kms_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita ni wand ven nutungu ni Jisas nitanyi temi kring mo kinne yemu, muq Jisas segi puq nindig nari, “Yumbui, te tuqui segi. Yumbo ren nunde ruwi kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas ni tindi nondo Pita ningg nari, “Satan, nu kring yo! Nu nge ngim imb kuagh ningg, te pugri nu God ningg nei pe wand guad segi, nu wute ningg nei pe wand guad.” ");
INSERT INTO kms_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Muq Jisas nikin wute simbe nindim nari, “Wuti nge nde nawi ningg, tedi ni yumbo buagi qi pe kin te dob neny di nge mai kiraq kin pugrine ei niraq. ");
INSERT INTO kms_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wuti tughe nikin ghimbine nei nimbiny nimbiny di nati, tedi ni nas nas te kin nas tuqui segi, pudi wuti tughe nge ningg nikin ghimbi nei nimbiny segi di nati, tedi ni otiwo yuwon pu nas nas te kin nas ye. ");
INSERT INTO kms_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wuti iri nge dob negh, qi pe kin yumbo yumbo oyi quan nei nimbiny, di yumbo te kin yembe nand nand muq nati, tedi yumbo te pughe gri ei ni ghav rindig ye? Te tuqui segi. Ni otiwo yuwon pu nas kin te yumbo ninge pe wong nand tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wuti God nde pu nandi wuti nganye nas ye nikin angelo ane mandi kiyi ningg gre pe yenu kin tende puayi di ni wute yumbo ur oghi ye rind kin te yumbo neny di yumbo ur brequ rind kin te mai neny. ");
INSERT INTO kms_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nge nungoqi nganyene simbe guduq, nungoqi ven yequ kin nungoqi kin ninge mati segine di wuti God nde pu nandi wuti nganye nas ye ni king kin pugri nandi muqoind.” ");
INSERT INTO kms_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nginy 6-pela pu mo pre Jisas ni Pita, Jems, di Jems ni kiqam Jon pugri pu nitami rand iri wam dobui nganye kin tende mewo mo nikinne tende mas. ");
INSERT INTO kms_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ni Jisas muqoind muqoindne ni tindi no aye gib namb. Ni quenge nginy ti nase kin pugri, di ni chongo quem rimb di ti nase. ");
INSERT INTO kms_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Di Moses Elaija temi mandi Jisas ane wand wand yemu muqond. ");
INSERT INTO kms_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Di Pita Jisas ningg nari, “Yumbui, beghi ven nde pas te yuwon. Nu ngiq ghand tedi nge baj yirbu teri ire pu ven nde yembe gidiny. Ire nu te, ire Moses te, di ire Elaija te.” ");
INSERT INTO kms_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita wand nand nandne yenu wuye quari ti wuri kin wundi ni imb wup, di wuti iri wuye quari wam te pu ngam nare nari, “Nen nge wo, nge ni quan nganye yawo girag righe di chumbuai gidig. Nungoqi ni ningg wand wutungu.” ");
INSERT INTO kms_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jisas nikin wute wand ven mutungu, ni quan nganye wune mamb ni pombri mo ngawu mare mo qi pe mundub. ");
INSERT INTO kms_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pudi Jisas ninde nandi, nat mase nari, “Wes wewo, nungoqi wune wamb wayequ.” ");
INSERT INTO kms_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Di ni rar mindigi kuyo rar mat, wute aye muqond segi, Jisas irine muqoind. ");
INSERT INTO kms_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Di ni rand pe pu mati mi mi, Jisas ni yeri nindim nari, “Nungoqi wo wuti iri yumbo ur ren wuqond kin te ningg simbe wundig wayequ, segine ruso otiwo wuti God nde pu nandi wuti nganye nas ye ni nati pre di God mune nindingi newo.” ");
INSERT INTO kms_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Di Jisas nikin wute ni pengu mindig mari, “Pughe ningg wute Moses ningg lo wute bei meny kin ni mari Elaija ei ye nawo nandi?” ");
INSERT INTO kms_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ni oyi nand nari, “Te nganyene Elaija ni ye nawo nandi di yumbo buagi sabi nindiny asi kin pugrine rise. ");
INSERT INTO kms_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pudi nge nungoqi simbe guduq, Elaija nandi pre, di wute ni ruqoind rip no segi, pudi ni yumbo puq meng yawo kurem kin te puq meng. Otiwo wuti God nde pu nandi wuti nganye nas ye ni pugrine ei mai reng ye.” ");
INSERT INTO kms_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Muq Jisas nikin wute nei mamb ni Jon wute wuye nap kin ni ningg bu wand nand. ");
INSERT INTO kms_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Muq ni wute buagi yeru pe mune mandi, wuti iri nandi Jisas nde rar ngimine sungomyu gure nawo yimb naghe nari, ");
INSERT INTO kms_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Yumbui, nge wo yawo tong. Ni ghimbi yuqo quan nganye nare, pripri ni rar ori nati, no wase pe ir naghe o wuye pe ir naghe. ");
INSERT INTO kms_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Di nge nunon wute nde kitanyi gadi, pudi ni sabi mindig tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Di Jisas ni oyi nand nari, “Nungoqi wutaqu God nei wumbig segi kin, di yumbo ur brequ quan kumo wand ye. Nge muq nungoqi ane pas nganye chiraq tuqui segi. Nge nungoqi mai quan nganye kare yambu kari. Wokuandi te ren wutanyi wandi.” ");
INSERT INTO kms_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Di Jisas ni ququ brequ te ker nuang, di ququ brequ wo te si neri neyi ni no, di tende puayine wo te opu oghi nase. ");
INSERT INTO kms_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Di Jisas nikin wute waghi grine mandi, Jisas ningg mari, “Pughe gri ate beghi ququ brequ te puaq baid no kin tuqui segi?” ");
INSERT INTO kms_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ni oyi nindim nari, “Nungoqi God musoqne nei wumbig pugri bu puaq waind tuqui segi. Nge nganyene nungoqi simbe guduq, nungoqi nge nei wumbigh kin nei te mastet yi wojiju kin pugri, tedi nungoqi rand nen ningg wari, ‘Nu ren pu yo tende yeru,’ tedi ni no. Yumbo ninge nungoqi imb ruauq segi.” ");
INSERT INTO kms_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas nikin wute ane mandi Galili irepene mikur, Jisas ni simbe nindim nari, “Wuti God nde pu nandi wuti nganye nas kin ni wute nde si pe mi nondo ye. ");
INSERT INTO kms_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ni mi nati, di nginy temi mo pre aye ningg di God mune nindingi newo.” Nikin wute wand ven mutungu di quan nganye yivany mare. ");
INSERT INTO kms_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Muq Jisas nikin wute ane mandi Kaperneam, wute God ningg baj pe kin takis materi kin ni Pita nde mandi ni pengu mindig mari, “Nu non yumbui takis wong bri nindiq?” ");
INSERT INTO kms_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ni nari, “Te nganye ni wong nindiq.” Muq Pita baj pe nandi di Jisas ni ye nawo pengu nindig nari, “Saimon, nu pughe gri nei guab? Qi pe ven nde tughe king nde takis wong mand? Ni kin wo takis wong mand, o wute aye kin te takis wong mand?” ");
INSERT INTO kms_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita oyi nand nari, “Wute aye kin takis wong mand.” Muq Jisas Pita ningg nari, “Tedi king nikin wo takis te wong mindiq segi. ");
INSERT INTO kms_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pudi eti wute God ningg baj kin takis materi kin men puq pem tedi ni umbo ker mawo. Nu yo, wuye ngamo pe umosungo yeq wughe, di umo ire ye wuwo kutaqwi kin te mim puaq nduw, di wet bidi tende wur wuse kin te taqwi raq yo ni yem, di nge nu temu ye God ningg baj kin takis te wong ndiq.” ");
INSERT INTO kms_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tende puayi Jisas nikin wute Jisas nde mandi mari, “Wute God nde si nambu yeru kin tende wuti tughe ei yumbui ningg nas?” ");
INSERT INTO kms_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Muq Jisas wo iri ningg nari nandi, ninde rar ngimine teti pu yenu, ");
INSERT INTO kms_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","di ni nari, “Nge nganyene nungoqi simbe guduq, nungoqi nei ware witinde wokuandi kin pugri segi, tedi nungoqi wute God nde si nambu yeru kin tende war wo tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wuti tughe ni wokuandi nen kin pugri ni wute nde si nambu nas, tedi ni wute God nde si nambu yeru kin tende yumbui nas kin tuqui. ");
INSERT INTO kms_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wuti iri ni nge nde nyamb pe wokuandi pugri ye iri neti nowi sabi nindig, te ni nge bu neti kowi sabi nindigh.” ");
INSERT INTO kms_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Di Jisas ni mune simbe nindim nari, “Pudi wuti iri ni wokuandi nge nei rimbigh ye ren kin ire puq neny yumbo ur brequ gud, te wuti te wet yumbui gibe pe wuq wang gherim pe meweri naghe tedi yuwon. ");
INSERT INTO kms_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yumbo ur brequ kin qi pe ruwi di wute te ningg mune yumbo ur brequ rind te ningg ni mai yumbui nganye rire. Yumbo te kin rindi ye, pudi wute tughe ni puq men kin te ei ni mai yumbui nganye miraq. ");
INSERT INTO kms_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Di nu si o nu nyinge ni puq rew nu yumbo ur brequ guad, tedi pend ghawo meghare viso. Te pugri nu si ire kuse o nyinge ire vise muq yo yuwon pu ghas kin te quan nganye yuwon. Nu si tengi ane kuse o nyinge tevi ane vise, di ni memeri wase awu kuso segi ye pe tende yo kin te brequ. ");
INSERT INTO kms_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Di nu rar puq wew nu yumbo ur brequ guad, tedi bi waq meraq wuso. Te pugri nu rar irene wuse di nu ghas ghas otiwo kin te yuwon. Pudi nu rar teri ane rise di ni memeri wase wute brequ ye mo kin tende yo kin te brequ.” ");
INSERT INTO kms_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Nungoqi wuti wokuandi nen kin pugri nyamb segi kin iri perei wundig wari, ‘Ni nge ane tuqui segi’ puq wundig wayequ. Nge nungoqi simbe guduq, nginy tu wam ye angelo wokuandi yeng muany kin pripri nge wuyi wam nas ye ninde rar ngimine yemu. ");
INSERT INTO kms_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nungoqi pughe gri nei wamb? Muq wuti iri ni sipsip 100-pela pu yeru di ire ir wuso, tedi ni pughe sin nen? Wuti te ni sipsip 99-pela si nare rand pe yeru di ni no ire ir wuso kin te meri nituw ye. ");
INSERT INTO kms_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nge nganyene nungoqi simbe guduq, muq ni sipsip te nundoq, ni quan nganye chumbuai nand. Ni sipsip 99-pela ir ruso segi kin te ningg chumbuai nand, pudi ire ir wuso kin mune nundoq kin te ningg ni quan nganye chumbuai nand. ");
INSERT INTO kms_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te kin pugrine nungoqi nuyi wam nas kin ni wokuandi ren kin ire ir kuso ni yambu nari.” ");
INSERT INTO kms_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas ni mune simbe nand nari, “Nimand iri nunde unje nap, te nu irine yo ni unje nap kin te simbe ndig. Ni nu wand nutungu, tedi nu nimand kueti nowi pre. ");
INSERT INTO kms_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pudi ni nu wand nutungu segi, tedi wuti aye iri o temi ghate mowi nu ane wo, te ei wand buagi ane irepene wutaqu tequ o tequ ire pu simbe wundig kin te ni nutungu. Te Moses ningg lo pugri puq wund. ");
INSERT INTO kms_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Muq ni wand te mune nutungu yambu nari, wo wute buagi aye nge nei rimbigh kin te mune simbe wundiny. Di ni wute buagi nge nei rimbigh kin ni wand te mune nutungu yambu nari, tedi nungoqi Juda segi kin di wute takis materi kin puq wem kin pugrine wuti te nungoqi ane was segi puq wundig. ");
INSERT INTO kms_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nganyene nganye, nge nungoqi simbe guduq, yumbo pughe kin nungoqi qi pe ren nde segi puq wand te nginy tu wam tende God ni segi puqne nand pre. Yumbo pughe kin nungoqi qi pe ren nde ngiq wand te nginy tu wam tende God ni ngiqne nand pre. ");
INSERT INTO kms_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nge munene nungoqi simbe guduq, wute temi ni nei irene rise di nge wuyi wam nas ye yumbo ninge ningg pengu mindig, tedi ni yumbo te nuam rise ye. ");
INSERT INTO kms_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Muainde wute temi o temi ire pu nge nde nyamb pe mikur, nge ni ane tende pas.” ");
INSERT INTO kms_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Muq Pita Jisas nde nandi di simbe nindig nari, “Yumbui, nge mand iri nge nde yumbo ur brequ quan yembe nindiny, di nge ni yumbo ur brequ nand kin te puaq gidig pughe gri pu ei gad? Nge puaq gidig 7-pela pu bri gad?” ");
INSERT INTO kms_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas ni oyi nindig nari, “Nge nu simbe guduw, 7-pela pu ghand segi, pudi 77-pela pu ghand. ");
INSERT INTO kms_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wute God nde si nambu ris kin ni wand ven kin pugri. Yabe king iri nas di ni nikin yembe ye ane wet bidi segine materi kin te mune sabi nindiny. ");
INSERT INTO kms_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ni wet bidi segine materi kin te sabi nand ningg yenu, wuti iri mitanyi mandi, ni wet bidi segine nateri kin te manyi mindig 10 milion kina kin pugri. ");
INSERT INTO kms_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ni wet bidi te oyi nindig tuqui segi, bu nikin yumbui nari ni di ni ngam di nikin wo di nikin yumbo buagi ane te wute nem wong mand. Ni pugri puq nen ei ni wet bidi segine nateri kin te oyi nindig ye. ");
INSERT INTO kms_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","King ningg yembe ye wuti te ni wand ven nutungu, di ni king nde tumone sungomyu gure nawo di nari, ‘Nge yumbui, nu nge yawo togh di nge ghimbi wagh. Wet bidi buagi nge segine kateri kin te nge oyi guduw ye.’ ");
INSERT INTO kms_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Di king ni yawo nitong, ni wet bidi segi nateri kin te oyi nand segi, king segi puq nindig di tiqi nundog no. ");
INSERT INTO kms_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pudi wuti te nikin yembe ire iri asi ninde wet bidi 10 kina segine nateri. Muq ni no wuti te nait nase gibene naind, di simbe nindig nari, ‘Nu nge nde wet bidi segine kuateri kin te brequne di oyi ghand.’ ");
INSERT INTO kms_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nikin yembe ire ni wand ven nutungu di ni sungomyu gure nawo di ni simbe nindig nari, ‘Nu nge yawo togh di nge ghimbi wagh. Nge nunde wet bidi segine kateri kin te nge oyi guduw ye.’ ");
INSERT INTO kms_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ni wand te nutungu yambu nari, di ni nitanyi no taq naimb pu yenu ruso ni wet bidi te mune oyi nand. ");
INSERT INTO kms_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Muq nikin yembe ire aye te muqond yivany mare, di ni mo wuti te yumbo ur yembe nindiny kin te ningg king simbe mindig. ");
INSERT INTO kms_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pugri bu king ni wuti te ngam nirang nondo, muq ni simbe nindig nari, ‘Nu wuti brequ. Asi nu nge ningg quanji guad bu nge nde wet bidi kuateri kin te oyi guad segine nge si keri ko. ");
INSERT INTO kms_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nge oyi nu yawo kutow. Pughe ningg nu oyi nu non yembe ire te yawo kutong segi?’ ");
INSERT INTO kms_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Di king ni quan ker nawo, nari ni yembe ye wuti te mitanyi mo taq maimb di yuqo meng ruso ni wet bidi buagi te oyi nindig. ");
INSERT INTO kms_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Te kin pugrine nge wuyi wam nas kin ni mune pugrine puq nen, nungoqi nimand mai puaq wundiny segi, tedi ni oyi nungoqi mai puaq nunduq segine.” ");
INSERT INTO kms_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Muq Jisas ni wand ren simbe nand pre, ni Galili si niraq no Judia opu wuye Jordan nisiny opu gri no newo, ");
INSERT INTO kms_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","di wute nganye buagi ninde dobu ruru di ni tende num sabi nindiny oghi. ");
INSERT INTO kms_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Di Parisi ninge ninde mandi, ni Jisas maip mi newo ei muqond ni wand ire unje nap bri. Pugri bu ni pengu mindig, “Beghi lo wuri wuti nikin nde nei pe ni ngam segine puaq nindiq tuqui bri?” ");
INSERT INTO kms_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ni oyi nand nari, “Nungoqi God ningg wand buk pe vise kin te wuqond segi bri? Yabe God ni qi di yumbo yumbo buagi yembe nindiny kin tende puayi ‘ni quayi nyumbueg ane pu yembe nindiny,’ ");
INSERT INTO kms_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","di God nari, ‘Puate te ningg bu quayi ni kiyi kumo ane si nare di ni ngam teri irepene ris, di ni teri ghimbi irene nganye rise.’ ");
INSERT INTO kms_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Asi ni kin kin ris pudi muq ni teri ghimbi irene. God ni teri irepene nawo righe, pugri bu wuti iri ni bir nawo ni kin kin yeru te brequ.” ");
INSERT INTO kms_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Di ni Jisas simbe mindig mari, “Pughe kin ningg Moses simbe nand nari, quayi ni ngam puaq nindiq di nyumo raqe ur nindiq new pre di tiqi nundow wuso?” ");
INSERT INTO kms_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ni oyi simbe nindim nari, “Nungoqi ngawu gre wand bu Moses nungoqi ngiq nunduq nungoqi ngam puaq wand ye tuqui. Pudi asi God ni quayi nyumbueg yembe nindiny kin tende puayi yumbo ur ren kin segi. ");
INSERT INTO kms_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Di nge nungoqi simbe guduq, wuti tughe ni ngam quayi aye ane rise segi, pudi ni ngam te puaq nindiq di nyumbueg aye nitaqi, te ni ngam kin lo gure nuaq.” ");
INSERT INTO kms_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas nikin wute mari, “Wuti iri ni ngam puaq nindiq kin yumbo ur pugri ye ninde rise, tedi ni ngam ruso segi te yuwon.” ");
INSERT INTO kms_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Di ni oyi nindim nari, “Wand ven wute quan buagine mutungu segi, pudi wute ngam mo segi kin te God ni wand ven nem ye. ");
INSERT INTO kms_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nungoqi wutungu, wute isis mas, ninge ni ngam mo segi. Ninge ni ghimbi kumo rire rindi kin tende puayine ghimbi brequ rise di wo mare tuqui segi, ninge wute aye ni ghimbi pend mawo di ni wo mare tuqui segi. Wute ninge God nde si nambu yemu di nikin yembe nei mimbiny bu ni ngam mo yambu mari. Wuti tughe wand ven natevi kin tuqui tedi ni ei natevi.” ");
INSERT INTO kms_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Di wute wokuandi Jisas nde ritari rundo ei Jisas ni si neny riwo di God pengu nindig ningg. Pudi Jisas nikin wute ni wute wo ritari rindi kin te ker muany. ");
INSERT INTO kms_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pudi Jisas nari, “Wokuandi te rar wuqond nge nde rindi, segi puq wundiny wayequ, te pugri wute God nde si nambu ris kin te wokuandi pugri ye ni te.” ");
INSERT INTO kms_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Di ni si neny riwo pre, di sunyi te si nare no. ");
INSERT INTO kms_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Muq wuti iri nandi Jisas ningg nari, “Tisa, nge yumbo ur oghi ye pughe ye yembe gidiny ei nge kas kas te kin kas?” ");
INSERT INTO kms_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ni oyi nindig nari, “Pughe kin ningg nu yumbo ur oghi ye te ningg nge pengu gudigh? God irine oghi ye. Nu lo tungu, tedi nu God ane was chiraq kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ni oyi Jisas ningg nari, “Lo pughe ye?” Di Jisas nari, “Wute ghamb riti wayequ; wute ngam kin ane wase wayequ; nyungu ghand wayequ; wute segi wandoqi ndiny ghari ni unje rip puq ghand wayequ; ");
INSERT INTO kms_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nuyi numo ningg wand irepene tungu; di nunon ghimbi yawo kurany righe kin pugrine wute aye yawo rany righe.” ");
INSERT INTO kms_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Quayi ambonye te oyi nand nari, “Yumbo buagi ren nge puq ken ye, pudi yumbo aye pughe ye mune puq ken?” ");
INSERT INTO kms_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas ni simbe nindig nari, “Nu mune tuquine nganye kuas ningg, tedi nu yo yumbo yumbo buagi te yi rundo wute aye wong mand, di wet bidi te kin ghateri wute yumbo segi kin te. Nu puq yen tedi nu yumbo yuwon kin nganye nginy tu wam rise. Nu puq yen pre muqdi nge nde ghawi.” ");
INSERT INTO kms_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Muq quayi ambonye ni wand ven nutungu, ni no quan nganye yivany nare. Ni yumbo quan rise ye te ningg bu ni yivany ane no. ");
INSERT INTO kms_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Di Jisas nikin wute te mingg nari, “Nganyene nganye, nge nungoqi simbe guduq, wuti yumbo quan rise kin ni wute God nde si nambu ris kin tende nar no kin te yembe yumbui nganye. ");
INSERT INTO kms_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Umo yumbui kamel puq munduw kin ni chongo rang kin nil gawo woju tende wur wuso kin yembe yumbui segi, pudi wute yumbo quan kin ni wute God nde si nambu ris kin tende rir ruso ye yembe yumbui nganye.” ");
INSERT INTO kms_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jisas nikin wute wand ven mutungu, ni puyene mand mari, “Tedi wuti tughe ei God neti nowi yuwon pu nas ye?” ");
INSERT INTO kms_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pudi Jisas rar neq wundo nuqond di nari, “Wute puq ren tuqui segi, pudi God yumbo buagi te puq nen kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Muq Pita ni oyi nand nari, “Beghi yumbo buagi te si pare di nunde dobu pawi. Beghi yumbo pughe kin ei pateri?” ");
INSERT INTO kms_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas ni oyi nindig nari, “Nge nungoqi nganyene simbe guduq, otiwo qi urupui pe wuti God nde pu nandi wuti nganye nas ye nikin sia king yuwon ye pe tende nas kin tende puayi nungoqi, nge nde dobu wawi kin, nungoqi mune sia 12-pela pe tende was, di Israel kin wute tit 12-pela pu yeng wany. ");
INSERT INTO kms_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Di wute buagi nge nde nyamb pe ni baj si rire o kise kiqam si rire o kiyi kumo si rire o wo o wuny si rire ye te ningg ni yumbo te kin 100-pela pu pugri riteri di otiwo ni ris ris te kin ris. ");
INSERT INTO kms_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pudi wute quan muq ni ye mawo kin te otiwo ni dobu mawi, di muq dobu mawi kin te otiwo ye mawo ye.” ");
INSERT INTO kms_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Wute God nde si nambu yeru kin te wuny kiyi kin pugri. Burane ne ni nyinge nare maket sunyi pe no wute ninge ningg nari mandi ninde wain wuny mbe yembe mand di ni wong nand. ");
INSERT INTO kms_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wute ninde yembe mand kin ni nginy iri yembe mand kin wet bidi mat rise kin ngiq mand, dobu di ni tiqi nundom mo wain wuny mbe yembe mand. ");
INSERT INTO kms_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Di 9 kilok pugri pe ni mune maket kin sunyi pe no, wute aye mune yembe segi pu tende yemu nuqond. ");
INSERT INTO kms_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Muq ni simbe nindim nari, ‘Nungoqi mune pugrine wo nge wain wuny mbe yembe wand, di nge nungoqi tuquine wong guduq ye.’ ");
INSERT INTO kms_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Di ni mo. Di 12 kilok mune no pugrine puq nen, di 3 kilok ni mune no pugrine puq nen. ");
INSERT INTO kms_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Muq 5 kilok yamb tumo rind rind ni mune maket sunyi pe no, wute ninge tende yemu nuqond, di ni simbe nindim nari, ‘Pughe kin ningg nungoqi ren nde segine yequ ruso ruso yuram?’ ");
INSERT INTO kms_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ni oyi mindig mari, ‘Pudi wuti iri beghi yembe ningg wand nuangu segi.’ Ni oyi nindim nari, ‘Nungoqi mune pugrine wo, nge wain wuny mbe yembe wand.’ ");
INSERT INTO kms_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Di yuram wuny kiyi nandi, wute yembe mand kin te ni yeng nuam kin te simbe nindig nari, ‘Nu wute yembe ye te ngam ram mandi, wong ghand. Dobu pu mandi yembe mand kin te gri ye ghawo wong ghand ruso ruso asi ye mawo mandi yembe mand kin te mune wong ghand.’ ");
INSERT INTO kms_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Di wute 5 kilok yuram yembe mand kin ni mune wet bidi nginy iri kin pugrine materi. ");
INSERT INTO kms_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Muq wute asine ye mawo yembe mand kin ni mari ni muqdi wet bidi quan ei mat rise ye. Pudi ni ire ire nginy iri yembe mand kin wet bidi pugrine mat rise. ");
INSERT INTO kms_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Di ni te materi muqond, ni wuny kiyi wand kumo mindig mari, ");
INSERT INTO kms_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Wute men nu dobu pu kuari mandi aua irene yembe mand. Beghi burane ne badi yembe bad ruso ruso nginy naghe no, nginy wase mingi tende beghi yembe bad kin te beghi wong gudumu kin te ni wong guad kin ane tuquine.’ ");
INSERT INTO kms_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pudi wuny kiyi ni kin iri oyi nindig nari, ‘Mand, nu tungu, nge nu unje kaip segi. Nu nginy iri yembe guad kin wet bidi te ningg asi wand bad di nu ngiq guad pre. ");
INSERT INTO kms_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nu wet bidi ghateri di nambu yo. Nge ngeningne wuti dobu nawi kin nen nu wet bidi kew kin pugrine ni mune geg. ");
INSERT INTO kms_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Te nge te wet bidi. Ngening nde nei pe wet bidi bir kawo nungoqi keuq ye. Nge wute men nde tumb kare ningg te piyi, pughe kin ningg nu te ningg kuari’?” ");
INSERT INTO kms_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Te kin pugrine wute dobu mawi kin te otiwo ye mawo, di ye mawo kin te otiwo dobu mawi.” ");
INSERT INTO kms_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Di Jisas ni Jerusalem newo no, nikin wute 12-pela pu waghine nitamine no nikinne yemu di simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Muq beghi Jerusalem pewo po, di wuti God nde pu nandi wuti nganye nas ye ni prist mingg yumbui di wute Moses ningg lo wute bei meny ye ninde si pe mi nondo ye. Di ni mari ni nati puq mand, ");
INSERT INTO kms_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","di wute Juda segi kin ninde si pe mi nondo, ei wute Juda segi kin ni wand peq mindig, di yas muang, di kruse pe qungu mi nati. Pudi nginy temi mo pre aye ningg di God ni mune nindingi newo.” ");
INSERT INTO kms_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tende dobu Sebedi ningg quayi wo temi ni kumo ane Jisas nde rindi. Di ni rar ngimine sungomyu gure wuwo yimb wughe, di ni yumbo ninge ningg pengu wundig. ");
INSERT INTO kms_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Di Jisas nari, “Nu yumbo pughe kin ningg kuari?” Ni oyi wundig wuri, “Nu nge simbe ndigh, nge wo temi men otiwo nu king ningg ghas di ni temi anene nyamb yumbui mare, iri nunde si nganye pe opu nas di iri nunde si qaqi pe opu nas.” ");
INSERT INTO kms_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pudi Jisas oyi nand nari, “Nungoqi yumbo pengu wand kin te nei wamb segi. Nungoqi kap nge wuye ke kin te ningg wuye we tuqui bri?” Ni temi oyi mand mari, “Beghi tuqui.” ");
INSERT INTO kms_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ni oyi nindim nari, “Nungoqi nge wuye ke kin kap te ninggne wuye we ye, pudi nge nde si tuan pe o si qaqi pe was kin te nge gri nungoqi sunyi te keuq tuqui segi. Sunyi ren te wute tughe nge wuyi sunyi te nipim ruso pre ye ni te.” ");
INSERT INTO kms_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Muq Jisas nikin wute aye 10-pela pu wand ren mutungu, di ni Sebedi ningg wo temi te ningg ker mawo. ");
INSERT INTO kms_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pudi Jisas ni quan buagine nari mondo di simbe nindim nari, “Nungoqi nei wamb te pugri wute Juda segi kin ni mingg yumbui ningg mas ye ni quan nganye yumbui mas di wute buagi ninde si nambu ris ningg mari. Di ni nikin wute nyamb kin te ni buid map ei wute buagi ni mingg wand irepene rutungu. ");
INSERT INTO kms_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nungoqi ni puq men kin pugri puq wen wayequ. Pudi nungoqi kin wuti iri ni yumbui nas ningg nari, te ni nungoqi ningg yembe ye wuti kin pugri ei nas. ");
INSERT INTO kms_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Di wuti iri ni ye nawo ningg nari, te nungoqi nde taq pu yenu yembe ye wuti te kin pugri ei nas. ");
INSERT INTO kms_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Te kin pugrine wuti God nde pu nandi wuti nganye nas ye ni wute ni ningg yembe rindig ningg nandi segi, pudi ni oyi wute nde yembe nand ningg nandi, di ni nati ei wute nganye buagi ir pu ris ningg wong nand.” ");
INSERT INTO kms_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas nikin wute ane Jeriko si miraq mo, muq wute nganye buagi ninde dobu ruru. ");
INSERT INTO kms_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Di tende puayi wute temi rar brequ kin ngim qunambe tende mas, ni mutungu Jisas te gri nandi, muq ni temi mari, “Yumbui, Devit ningg kuqo, nu beghi yawo tongu.” ");
INSERT INTO kms_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wute buagi ni temi ker ruam di simbe rindim ei ni temi wand segi mas. Pudi ni temi mune quan kumo mari, “Yumbui, Devit ningg kuqo, beghi yawo tongu.” ");
INSERT INTO kms_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Di Jisas yenu di ni temi ningg nari, “Nge nungoqi pughe sin keuq ningg wari?” ");
INSERT INTO kms_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ni oyi mindig mari, “Yumbui, beghi rar pat yumbo buqod ningg pari.” ");
INSERT INTO kms_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Di Jisas ni temi yawo nitom si natekui rar nitim rise di brequne ni temi rar mune oghi rar mat yumbo muqond, di ninde dobu maru. ");
INSERT INTO kms_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Muq ni Jerusalem tumo mondo di ni tiqe Betpage tende mondo. Di ni nyumo oliv yemu kin rand qunambe tende yemu, di Jisas nikin wute temi yeri nindim pre tiqi nundom mo, ");
INSERT INTO kms_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","di simbe nindim nari, “Nungoqi tequ tiqe tumo te yequ kin tende wo. Nungoqi tiqe te ningg warne wondo di donki ire wuq muaw pu wo ane tende yeru wuqond ye. Sare bure wand di teri wutari nge nde wandi. ");
INSERT INTO kms_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wuti iri nungoqi segi puq nunduq, nungoqi simbe wundig wari, ‘Yumbui ni yembe rise.’ Puq wand di ni brequne ngiq nand di wutari wandi ye.” ");
INSERT INTO kms_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yumbo ur ren kin ruwi kin asi propet iri ni simbe nand kin ane tuquine. Ni nari, ");
INSERT INTO kms_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Wand ven wute Jerusalem kin simbe ndiny, ‘Wuqond, nungoqi king nungoqi nde nandi. Ni nandi kin wuti nyamb segi kin pugri, donki pe nas di nandi, di donki wo pe nandi’.” ");
INSERT INTO kms_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jisas nikin wute mo, di Jisas nari kin pugrine puq men. ");
INSERT INTO kms_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Di ni temi donki kumo di wo ane mitari mandi, chongo dobui donki wam mawo pre, Jisas newo nas. ");
INSERT INTO kms_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wute nganye buagi nikin chongo dobui ngimne ruwo ruwo rire ruso di ninge nyumo muange ngimne ruwo rise. ");
INSERT INTO kms_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wute ninge ye ruwo, ninge Jisas nde dobu ruwi, quan buagine pugri riri, “Devit ningg kuqo Hosana puq wundig. God nu wuti Yumbui nde nyamb pe nandi kin nen yuwon wang. Yumbui wam nganye nas kin ni nyamb wundivi viyo.” ");
INSERT INTO kms_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas ni Jerusalem nar no, wute buagi tiqe yumbui tende ris kin ni puyene rind, ni kin kin pengu rind riri, “Wuti nen tughe?” ");
INSERT INTO kms_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Di wute buagi riri, “Wuti nen propet iri, Jisas puq mindig kin, tiqe Nasaret Galili opu kin.” ");
INSERT INTO kms_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Di Jisas ni God ningg baj imb wabe nar no, di wute God ningg baj pe yumbo wong mand di maket muaq kin te bub nare mo. Wute ninge mas wet bidi kantri aye kin materi di ni mingg wet bidi te oyi mem. Di Jisas nandi wute men ni tebol te groq nindim ruso, di wute wapi mabri mawo mas wong mand kin ni mas kin komboiq te pombri nipim ruso. ");
INSERT INTO kms_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ni simbe nindim nari, “God ningg wand rise kin buk pe God pugri puq nand, ‘Nge ningg baj te wute nge ane wand ye baj puq munduw ye.’ Pudi nungoqi wute nyungu kin suqo mo ye sunyi kin pugri puq wew.” ");
INSERT INTO kms_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Di wute rar rit segi kin di wute nyinge brequ kin ritari rindi God ningg baj pe, di Jisas ni sabi nindiny oghi. ");
INSERT INTO kms_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pudi prist mingg yumbui di wute Moses ningg lo wute bei meny kin ni yumbo ur oghi ye Jisas yembe nindiny kin te muqond, di wokuandi God ningg baj pe pugri riri, “Nungoqi Devit ningg kuqo Hosana puq wundig!” Pugri bu ni Jisas ningg ker mawo, ");
INSERT INTO kms_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","di ni simbe mindig mari, “Nu kutungu wo ren pughe puq rind?” Di Jisas oyi nindim nari, “Nge kutungu ye! Nungoqi God ningg buk te wundoq segi bri? God ningg buk pugri puq wund wuri, ‘Wokuandi di wo kumo miny reny riq kin nikin mim pe Yumbui nyamb rindivi viyo’.” ");
INSERT INTO kms_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Di Jisas ni si nare, tiqe ire Betani puq munduw kin tende no, bur ire te nas. ");
INSERT INTO kms_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Burane Jisas mune Jerusalem no, ni no no ngimi mir gureg. ");
INSERT INTO kms_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Di ni nyumo fig ngim qunambe yenu nuqoind, be ni nondo tumo nuqond di fig yi segi, raqene rise. Di ni nyumo te ningg nari, “Nunde gidaqi pe yi mune riyi segi ye!” Di nyumo fig te brequne quari namb. ");
INSERT INTO kms_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jisas nikin wute te muqond, ni nei kumo mamb mari, “Pughe gri ate nyumo fig nen brequne quari namb?” ");
INSERT INTO kms_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Di Jisas oyi nindim nari, “Nge nganyene nganye simbe guduq, nungoqi Yumbui nei wumbig di nungoqi nei tevi tevi vise segi, tedi nge nyumo fig puq geg kin pugrine nungoqi mune puq wen ye tuqui. Di ren ne segi, pudi nungoqi rand nen ningg wari, ‘Nu yo gherim pe ir yaghe,’ tedi yumbo nungoqi wari kin pugrine puq ren. ");
INSERT INTO kms_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nungoqi Yumbui nei wumbig, tedi yumbo pughe kin ningg ni pengu wundig di nungoqi wateri.” ");
INSERT INTO kms_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Di Jisas ni God ningg baj kin imb pe nar no, wute wand bei neny neny yenu, prist mingg yumbui di quayi kiyi ane mandi ni muqoind di mari, “Nu beghi simbe ndug, nu gre pughe ye pe yumbo ren yembe gudiny? Tughe nu ngiq nunduw bu nu yembe ren guad?” ");
INSERT INTO kms_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas oyi nindim nari, “Muq nge oyi mune pengu ire nungoqi pengu guduq, di nungoqi nge simbe wundigh tedi nge oyi simbe guduq tughe nge ngiq nindigh bu nge yembe ren gad. ");
INSERT INTO kms_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon ni tughe nde gre nateri di ni wute wuye nap? God nde pu nateri o wute nde pu nateri.” Di ni kin kin wand mand mari, “Beghi pari God nde pu nateri, tedi ni beghi ningg nari, ‘Pughe kin ningg nungoqi Jon ningg wand te wutungu di nganyene puq wand segi?’ ");
INSERT INTO kms_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pudi beghi pari, ‘Wute nde,’ tedi beghi wute buagi te wune bibiny. Te pugri wute buagi riri Jon ni propet iri.” ");
INSERT INTO kms_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Te ningg di ni oyi mand kin mari, “Beghi nei bab segi.” Jisas nari, “Nge mune pugrine, nge tughe nde gre pe yumbo ren yembe gidiny kin te nungoqi simbe guduq segi.” ");
INSERT INTO kms_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nungoqi pughe gri nei wamb? Wuti iri ni quayi wo temi mas, di ni no wo kiseyu te simbe nindig nari, ‘Nge wo, nu muq yo wain wuny mbe yembe ghand.’ ");
INSERT INTO kms_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Di ni oyi nand nari, ‘Nge ko yambu kari.’ Pudi dobu pu ni nei nare nitinde di ni no. ");
INSERT INTO kms_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Di kiyi ni no wo kiqam nde te mune pugrine puq nen, di oyi nand nari, ‘Yumbui, nge ko ye.’ Pudi ni no segi. ");
INSERT INTO kms_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nungoqi pughe gri nei wamb, wo pughe ye bu kiyi ningg wand nutungu?” Ni mari, “Ni wo kiseyu.” Jisas ni wute te simbe nindim nari, “Nge nganyene nganye nungoqi simbe guduq, wute takis materi kin di ngimne nyumbueg ane ni ye ruwo God nde si nambu ris di nungoqi oyi dobu waru. ");
INSERT INTO kms_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon ni nandi kin ngim tuquine ye bei neuq, pudi nungoqi ni wand te wutungu segi. Pudi wute takis materi kin di ngimne nyumbueg ane ni ningg wand rutungu. Di muq nungoqi ren wuqond, pudi nungoqi nei ware witinde di ni ningg wand wutungu segi.” ");
INSERT INTO kms_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nungoqi kopuqu wand aye ven mune wutungu. Wuti iri ni wain wuny ire yembe nindiny. Ni undaw nipiq, wain yembe mindig kin sunyi ire tende wabe gri ngamo nuaq, di baj dobui wute mas wuny yeng muany kin iri tende yembe nindig. Ni pre nand di wute aye nem di ni ber manyine wong maind maind mas, di ni wonji tiqe aye pe no. ");
INSERT INTO kms_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wain yi uri mand kin tende puayi ni yembe ye wute ninge tiqi nundom mo, wute ni wuny yeng muany kin te muqond di wain yi ninge map. ");
INSERT INTO kms_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pudi wute wuny yeng muany kin ni yembe ye te iri pug mindig, iri mi nati, di iri wet memirang. ");
INSERT INTO kms_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Muq ni wute yembe ye aye mune tiqi nundom mo, asi kin quan segi muq quan nganye. Di ni mune pugrine puq mem. ");
INSERT INTO kms_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tende dobu nikin wo nganye tiqi nundog ninde no, ni nari, ‘Ni nge wo ningg wand mutungu ye.’ ");
INSERT INTO kms_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pudi wuny yeng muany kin ni wo te muqoind, ni kin kin wand wand mare mari, ‘Wuti nen ei ni kiyi ningg yumbo yumbo buagi nateri ye. Beghi pi nati, ei ni ningg yumbo yumbo te beghi oyi pateri.’ ");
INSERT INTO kms_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pugri bu ni mait nase, mitanyi mo wuny dabo memeri nar no di mi nati. ");
INSERT INTO kms_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nungoqi pughe gri nei wamb? Wuny kiyi nandi di wute wuny yeng muany kin pughe sin bri nem?” ");
INSERT INTO kms_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ni oyi mindig mari, “Ni wute brequ kin te suquan moyi gri ni mati, di wain wuny te wute aye nem yeng muany, di otiwo mir rise uri rind kin tende puayi di ni mir materi wuny kiyi meng rir.” ");
INSERT INTO kms_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas ni oyi nindim nari, “Nungoqi God ningg wand buk pe vise kin ven wuqond segi bri? Wand ven te: ‘Wet te asi wute baj yembe mand ye mari brequ di kring maip no kin wet te muq baj mingine nas di baj nare. Yumbui ni ren kin puq nen di beghi nde rar pe yuwon nganye.’ ");
INSERT INTO kms_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Pugri bu nge nungoqi simbe guduq, nungoqi God nde si nambu yequ kin te ningg God ni segi puq nunduq, di ni oyi wute aye ni wand rutungu kin te ngiq nindiny. ");
INSERT INTO kms_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Di wuti tughe ni wam pu ir ni naghe wet pe yenu, tedi ni bir nas puch puch yenu. Pudi wet oyi ir ni wuti dang naind, tedi wuti te binye nase.” ");
INSERT INTO kms_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Prist mingg yumbui di Parisi ane ni kopuqu wand ven mutungu, ni nei mamb Jisas ni mingg bu simbe nand. ");
INSERT INTO kms_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ni mait nase ningg nei mamb, pudi ni wute buagi wune mimbiny. Te pugri wute ni riri Jisas ni propet iri. ");
INSERT INTO kms_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Muq munene Jisas ni kopuqu wand pe wute simbe nindiny, ");
INSERT INTO kms_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Wute God nde si nambu yeru kin te pugri, king iri ni wo ngam urupui no kin mir yembe nindig. ");
INSERT INTO kms_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ni wute ninge simbe nindiny otiwo ni wo ngam urupui no kin te mir mawo kin tende puayi di ni rindi. Muq ni mir rind kin puayi nikin yembe ye wute te tiqi nundom mo wute simbe mindiny rindi ningg, pudi ni rindi yambu riri. ");
INSERT INTO kms_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Muq nikin yembe ye aye mune tiqi nundom mo simbe nindim nari, ‘Wute nge simbe gidiny rindi puq gad kin te simbe wundiny, “Nungoqi wutungu, nge mir yembe gidiny pre pu rise, bulmakau quayi buagi di bulmakau wo buagi nyam rire kin nge gab riti pre. Yumbo yumbo buagi nge yembe gidiny pre, nungoqi ngam kin mir pene wandi”.’ ");
INSERT INTO kms_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Yembe ye wute mo ni simbe mindiny, pudi ni rutungu yambu riri, di ni aye pe ruso. Iri ni no wuny yembe nand, di iri ni no bisnis yembe nand. ");
INSERT INTO kms_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pudi ninge king ningg yembe ye te mat mase pug mindim di mi mati. ");
INSERT INTO kms_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King ni umbo ker nawo, di ni ami tiqi nundom mo, wute nikin yembe ye mi mati kin te mi di ni tiqe te mindany nimbiny. ");
INSERT INTO kms_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Muq ni yembe ye aye simbe nindim nari, ‘Ngam kin mir nge yembe gidiny pre pu rise, pudi wute nge simbe gidiny kin ni wute oghi segi bu ni rindi segi. ");
INSERT INTO kms_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nungoqi tiqe manyi te wo wute pughe ye wuqond simbe wundiny ngam kin mir pe rindi.’ ");
INSERT INTO kms_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Muq nikin yembe ye tiqi nundom mo wute buagi ni ngimne muqond mate ruwi, oghi kin di brequ kin, buagi ane mate ruwi riso, di mir kin sunyi te wutene bre. ");
INSERT INTO kms_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pudi king ni neyi nandi wute te nuqond, di ni wuti iri ngam kin chongo oghi nganye nare righe segi kin te nuqoind. ");
INSERT INTO kms_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ni pengu nindig nari, ‘Nge mand, pughe gri ate nu ngam kin chongo oghi nganye kuare righe segine ven nde kueyi kui?’ Muq wuti te wand segine yenu. ");
INSERT INTO kms_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Muq king nikin yembe ye simbe nindim nari, ‘Si muange taq wumbig, meweri dabo burpoq pe nar no. Tende wute quan nganye riri di sawo rit ki.’ ");
INSERT INTO kms_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Te pugri wute nganye buagi ngam nirany, pudi ire irene ni nate ruwi.” ");
INSERT INTO kms_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisi ni mo kin kinne wand taq mamb pughe gri ei wandoqi mindig di ni wand ninge unje nap tedi mait nase. ");
INSERT INTO kms_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Di Parisi nikin wute di wute ninge Herot nde opu mase ye te ane mo Jisas ningg mari, “Tisa, beghi nei bab nu wand nganye kin pene God ningg yumbo ur te wute bei kueny ye, di nu wute ni pughe sin ren kin te ningg nei kumo guab segi, nu wute nyamb kin o wute nyamb segi kin wand irene simbe gudiny. ");
INSERT INTO kms_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Beghi simbe ndug, nu pughe gri nei guab? Beghi Sisar nde takis wong bad kin te tuquine o segi?” ");
INSERT INTO kms_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pudi Jisas ni nei namb ni yumbo ur brequ mand ningg bu ni nari, “Nungoqi wute nei tevi kin. Pughe kin ningg nungoqi nge wandoqi wundigh ei nge wand unje kap ningg wari? ");
INSERT INTO kms_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis kin wet bidi ire te nge bei wegh.” Di ni wet bidi te miraq mandi meng. ");
INSERT INTO kms_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Di Jisas ni pengu nindim nari, “Wuti tughe ngawu di nyamb ane wet bidi wen nde rise?” ");
INSERT INTO kms_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ni oyi mand mari, “Sisar te.” Di Jisas ni simbe nindim nari, “Yumbo Sisar ningg te Sisar weng, di God ningg te God weng.” ");
INSERT INTO kms_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ni wand ven mutungu, nei kumo mamb, di ni Jisas si meri di mo. ");
INSERT INTO kms_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadyusi ni mari wute mati kin ni mune mes mewo segi ye. Nginy te ningg wute te kin Jisas nde mandi di ni pengu mindig mari, ");
INSERT INTO kms_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisa, Moses nari wuti iri wo segine nati, te ni kiqam ei mune kise ngam te nitaqi. Ni mune kise ngam te nitaqi, wo niraw di wo te kise nati kin ni te. ");
INSERT INTO kms_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Muq beghi kise kiqam 7-pela pu mas. Kiseyu ngam no di nati, di ni wo segi, ni ngam kiqam nde si niraq pu wus. ");
INSERT INTO kms_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Muq mingi ye tende dobu mune nitaqi, ni mune nati. Te tene ruso kiqam chumb mune nitaqi, ni mune natine. ");
INSERT INTO kms_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ninde pre dobu nyumbueg te wuti. ");
INSERT INTO kms_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kise kiqam 7-pela pu ni wute te mitaqi. Pugri bu otiwo wute mati kin mes mewo kin tende puayi tedi nyumbueg wen ni tughe ningg ngam ei wus?” ");
INSERT INTO kms_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pudi Jisas ni oyi nindim nari, “Nungoqi unje wap. Te pugri nungoqi God ningg wand buk pe rise kin di God ningg gre te nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wute mati kin mune mes mewo ye tende puayi ni ngam ruso o oyi oyi ngam mawo ruso segi. Ni angelo wam mas kin pugrine ris ye. ");
INSERT INTO kms_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Di wute riti kin mune res riwo kin te ningg nungoqi God buk pe simbe nand kin te wuqond segi bri? ");
INSERT INTO kms_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ni nari, ‘Nge Abraham ningg God, Aisak ningg God di Jekop ningg God.’ God ni wute mati ye ni mingg God segi, ni wute urupuine mas ye ni mingg God.” ");
INSERT INTO kms_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wute buagi ni wand ven rutungu, di te ningg nei kumo rimb. ");
INSERT INTO kms_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisi ni mutungu Jisas ni Sadyusi wand mand kin ngim imb nuam, di ni mandi irepene mikur. ");
INSERT INTO kms_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Di wuti iri ni lo quan nei numbuw ye ni Jisas puamb nuang ningg bu ni pugri pengu nindig, ");
INSERT INTO kms_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisa, lo pughe ye bu yumbui?” ");
INSERT INTO kms_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Di ni oyi nindig nari, “‘Nu Yumbui nunon God te ei nunde umbo pe, ququ pe gri, di nei pe yawo rang righe.’ ");
INSERT INTO kms_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lo wen te quan nganye yumbui di lo ye wuwo kin. ");
INSERT INTO kms_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Di aye tende dobu te pugri: ‘Nunon ghimbi yawo kurany righe kin pugrine wute aye yawo rany righe.’ ");
INSERT INTO kms_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses ningg lo di propet mingg wand nikin puate taq, wute aye yawo pirany righe di God yawo birag righe.” ");
INSERT INTO kms_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi irepene mikur pu yemu, di Jisas ni pengu nindim ");
INSERT INTO kms_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","nari, “Nungoqi Kraist ningg pughe gri nei wamb? Ni tughe ningg kuqo?” Ni oyi mindig mari, “Devit ningg kuqo.” ");
INSERT INTO kms_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ni oyi nindim nari, “Pughe gri ate Ququ Yuwon Ye Devit nei neng bu Devit wuti nen yumbui puq nindig? Devit ni puq nand, ");
INSERT INTO kms_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yumbui ni nge yumbui ningg nari, “Nge nde si tuan pene ghas ruso ruso nge nu veri nunde nyinge tingi kawo mas”.’ ");
INSERT INTO kms_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Muq Devit nikinne ni yumbui puq nindig, tedi pughe gri ei ni Devit ningg kuqo?” ");
INSERT INTO kms_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wuti iri ni wand te oyi nindig tuqui segi. Di tende puayi pu ruso ni Jisas wand ire pengu mindig kin wune mamb. ");
INSERT INTO kms_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Muq Jisas wute buagi di nikin wute ane wand simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wute lo wute bei meny kin di Parisi ane Moses ningg lo te bu simbe munduq. ");
INSERT INTO kms_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pugri bu wand pughe ye nungoqi meuq kin te wutungu di yembe wundiny. Pudi yumbo ur yembe mindiny kin te nungoqi yembe wundiny wayequ. Ni wand oghi kin simbe mand pudi nikinne yembe mindiny segi. ");
INSERT INTO kms_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ni yumbo ninge quan nganye mai ruwo kin wute nde sikar pe mirany righe, di ni rire kin tuqui segi. Pudi nikinne si timuepu iri nganye meri mondo musoq ghav mand segi. ");
INSERT INTO kms_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Di ni yumbo ur buagi yembe mindiny ei wute ni ruqond ningg. Wute pripri God ningg wand mawo righe kin bokis te nikin quenge pe di si pe taq mamb. Ni bokis te kin yumbui ye taq mamb yawo kurem. Di ni sare dobui materi chongo dobui Yumbui pengu mindig ningg miraq wughe kin tende taq mamb. ");
INSERT INTO kms_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Di ni mir yumbui pe mo di wute nyamb kin mas ye sunyi pe ei mas yawo kurem, di God yumbui nyamb mirang kin baj pe wute nyamb kin mas ye sunyi pe tende ei mas yawo kurem. ");
INSERT INTO kms_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Di ni wute buagi pripri rikur kin sunyi pe tende mo di wute ni ei chumbuai kin wand rem yawo kurem. Di ni tisa puq rindim yawo kurem. ");
INSERT INTO kms_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pudi wute nungoqi tisa puq runduq kin te wayequ, te pugri nungoqi Tisa irine, di nungoqi quan buagine kise kiqam wand. ");
INSERT INTO kms_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nungoqi nuyi irine wam nas, bu nungoqi wuti iri qi pe ven nde nungoqi wuyi puq wundig wayequ. ");
INSERT INTO kms_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wute nungoqi tisa puq runduq kin te wayequ, te pugri nungoqi tisa irine te Kraist. ");
INSERT INTO kms_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wuti tughe nungoqi nde yumbui ningg nas kin te ni nungoqi yembe ye iri. ");
INSERT INTO kms_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wuti tughe nikin nyambne nindivi viyo, tedi ni nyamb vighe viso, di wuti tughe nikin nyamb ni vighe viso, tedi ni nyamb yumbui natevi.” ");
INSERT INTO kms_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jisas ni mune simbe nand nari, “Nungoqi wutaqu lo wute bei weny kin di nungoqi Parisi otiwo nungoqi mai yumbui nganye ware. Nungoqi wutaqu nei tevi kin. Nungoqi wute God nde si nambu yeru kin te kin ngim nungoqi wute te imb wany. Nungoqi nonne war wo yambu wari, di wute rir ruso kin te nungoqi ngim imb wany. ");
INSERT INTO kms_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nungoqi wutaqu lo wute bei weny kin di nungoqi Parisi otiwo nungoqi mai yumbui nganye ware. Nungoqi wutaqu nei tevi kin. Nungoqi war ir wonji nganye wo, ei wuti iri ni Juda ningg lo te simbe wundig nutungu. Di nungoqi lo simbe wundig di nungoqi ningg wand te kin pugri puq nen, tedi nungoqi wase pe wo kin pugrine ni mune wase pe no. Ni nungoqi mai wuraq kin pugrine ni oyi quan nganye niraq. ");
INSERT INTO kms_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nungoqi rar chukoq kin, nungoqi wute ngim bei weny pudi nungoqi nonne ngim wundoq kin tuqui segi, otiwo nungoqi mai yumbui nganye ware. Te pugri nungoqi wute yeri wundiny wari, ‘Wuti God ningg baj pe wand ire gre neny, ni dobu puq nen segi te piyi. Pudi wuti iri God ningg baj ni gol tende pe wand gre neny, te ni puq nand kin pugrine ei puq nen.’ ");
INSERT INTO kms_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nungoqi rar chukoq di ghabe gad! Yumbo pughe kin quan nganye yumbui? Gol God ningg baj wabe wur wus kin te yumbui segi, God ningg baj ni quan nganye yumbui di gol ni God ningg baj wabe wur wus kin te ningg bu ni anene yumbui. ");
INSERT INTO kms_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Di nungoqi wari, ‘Wuti iri alta pe wand gre neny, ni dobu puq nen segi te piyi. Pudi wuti iri alta pe yumbo God meng kin tende pe wand gre neny, te puq nand kin pugrine ei puq nen.’ ");
INSERT INTO kms_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nungoqi wutaqu rar chukoq kin. Yumbo alta pe mawo ris kin te yumbui segi. Alta ni quan nganye yumbui, di yumbo God meng kin ni alta pe ris kin te ningg bu ni anene yumbui. ");
INSERT INTO kms_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pugri bu wuti iri alta pe wand gre neny, tedi ni alta di yumbo buagi alta pe ris kin te anene wand gre neny. ");
INSERT INTO kms_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Di wuti tughe God ningg baj pe wand ire gre neny, tedi God ningg baj di God tende nar nas kin ninde anene wand gre neny. ");
INSERT INTO kms_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Di wuti tughe God nas kin tiqe tende pe ni wand ire gre neny, te God ningg sia pe bu wand gre neny, di God tende newo nas ye pe wand gre neny. ");
INSERT INTO kms_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nungoqi wutaqu lo wute bei weny kin di nungoqi Parisi, nungoqi otiwo mai yumbui nganye ware. Nungoqi wutaqu nei tevi kin. Nungoqi lo wojiju kin te wat rise di wuny mbe kin minye buagi mint, dil, di kumin te nungoqi 10-pela pu mone wawo puch ire God weng. Pudi nungoqi lo yumbui kin te si ware pre. Taq pugri, nungoqi yumbo ur wute aye nde tuquine yembe wundiny, di wute yawo wutony, di God nei wumbig kin yumbo ur te yembe wundiny. Nungoqi lo yumbui kin te yembe wundiny, di lo aye te si ware segi kin. ");
INSERT INTO kms_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nungoqi wutaqu rar chukoq, nungoqi wute ngim bei weny ningg! Nungoqi te kin pugri, ase iri wuti iri nde minye wuye pe naghe pu yenu bu ni neti nowi meneri no. Pudi ni umo yumbui kin ire, kamel puq munduw kin, minye wuye pe wughe pu yequ kin te nundoq segi, ni minye wuye te ne di kamel anene naq wughe. ");
INSERT INTO kms_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nungoqi wutaqu lo wute bei weny kin di nungoqi Parisi, otiwo nungoqi mai yumbui nganye ware ye! Nungoqi wutaqu nei tevi kin. Nungoqi kap nyeng ane dabo gri oghine wuye wap, pudi wabe gri te quan nganye puqum rimb. Te pugri nungoqi nyungu wand di nungoqi non ghimbine nei wumbiny kin tene nei wamb. ");
INSERT INTO kms_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nungoqi Parisi nungoqi rar chukoq kin! Nungoqi kap nyeng ane wabe gri wuye wap quem rimb pre, tedi dabo gri mune quemne rimb. ");
INSERT INTO kms_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nungoqi wutaqu lo wute bei weny kin di nungoqi Parisi, nungoqi otiwo mai yumbui nganye ware ye. Nungoqi wutaqu nei tevi kin. Nungoqi wute riti mawo yeru kin ngamo qi quem kin pe nyang mamb kin pugri. Wute riti mawo yeru kin ngamo wam gri buqod kin yuwon, pudi wabe gri wute riti kin ngape mboq di sigh ane tende rir rise. ");
INSERT INTO kms_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nungoqi mune pugrine. Wute nungoqi ghimbi rundoqu riri nungoqi wutaqu yumbo ur tuquine puq wen ye. Pudi nungoqi nde umbo pe nei tevi kin yumbo ur di yumbo ur quan nganye brequ kin nungoqi nde umbo pe rise. ");
INSERT INTO kms_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nungoqi wutaqu lo wute bei weny kin di nungoqi Parisi nungoqi otiwo mai yumbui nganye ware. Nungoqi wutaqu nei tevi kin. Nungoqi nonne propet te mati mawo yemu kin ngamo te yuwonne yembe wundiny, di wute yumbo ur tuquine yembe mand ye mati kin ngamo te yenji wupiny. ");
INSERT INTO kms_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Di nungoqi wari, ‘Beghi koku ni mas kin tende puayi beghi pas, tedi beghi ni ghav bidim propet te pi mati segi.’ ");
INSERT INTO kms_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wand ven nungoqi nonne bei wand, nungoqi wute propet mi mati kin ni mingg wo. ");
INSERT INTO kms_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Be wo nungoqi nuqo yumbo ur brequ puq ren kin te mune yembe wundiny. ");
INSERT INTO kms_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nungoqi ghati! Nungoqi ghati sindiyu wo! God nungoqi ir nuaqu di wase pe wo ye! Di nungoqi wu wase wo ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Te kin ningg di nge propet di wute nei oghi ye di wute lo bei munduq kin nungoqi nde tiqi gudom mondo ye. Ninge nungoqi wi mati, di kruse pe qungu wi mati, ninge nungoqi wutari wo God yumbui nyamb wurang kin baj pe yas wuany, di bub ware tiqe manyi te ruso ye. ");
INSERT INTO kms_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nungoqi pugri puq wen bu wute buagi ni wute tuquine ris ye qi pe ven nde ris kin te mambui riti kin mai te nungoqi wuraq ye. Nungoqi nuqo wute oghi ye mambui riti kin taq, Kein ni Abel ni nati kin tende pu rindi Sekaraia, Berekia ningg wo, ni God ningg baj opu di alta opu di tende mingi mi nati. ");
INSERT INTO kms_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nge nganyene nungoqi simbe guduq, mai te kin buagi nungoqi muq was kin ware ye.” ");
INSERT INTO kms_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Di Jisas mune nari, “O Jerusalem, Jerusalem, nu propet te kui mati, di nu wute God tiqi nundom mondo kin te kuate mowi wet mekuram kui mati. Pripri nge nu wo ire pe kirur ningg, wapiqu kumo wo ngam wurany rindi nimbraqe nambu wirir kin pugri, pudi nu yambu kuari. ");
INSERT INTO kms_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nu tungu! God nu God ningg baj te si niraq di muq omone nganye yequ. ");
INSERT INTO kms_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nge nu simbe guduw, nu nge qoind segine ruso ruso nu nonne ghari, ‘God nu wuti Yumbui nde nyamb pe nandi kin nen yuwon wang’.” ");
INSERT INTO kms_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ni God ningg baj si niraq no di nikin wute ninde mandi, ni baj buagi God ningg baj pe tende rise kin tende si mundub di Jisas simbe mindig. ");
INSERT INTO kms_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Di ni oyi nindim nari, “Nungoqi yumbo ren wuqond? Nge nganyene nganye nungoqi simbe guduq, otiwo wute mandi baj ren bir mawo di wet men mune iri aye nde wam nas wuqoind segi ye. Ni quan buagine bir ir maghe di kin kin mas ye.” ");
INSERT INTO kms_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas ni newo no rand oliv ningg nas, nikin wute waghi grine mandi mari, “Beghi simbe ndug, pughe puayi bri nu yumbo kuari kin ren ruwi? Di yumbo ur pughe kin ye ruwo ei beghi buqod di nei bab nu mune guadi kin di ngeri pre kin te tumo rind?” ");
INSERT INTO kms_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Di ni nari, “Nungoqi yeng wawo yuwon. Eti wute ninge mandi nungoqi wandoqi munduq di ni wand wutungu. ");
INSERT INTO kms_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Te pugri wute wandoqi kin nganye buagi nge nde nyamb pe mandi di mari ni Kraist, di wute nganye buagi ni mingg wand rutungu. ");
INSERT INTO kms_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Di nungoqi yeng wundi kin wand wutungu di yeng kin yumbo riri wutungu, pudi nungoqi te ningg wune wamb wayequ. Yumbo ren kin te ruwi ye, pudi ngeri pre kin te segine. ");
INSERT INTO kms_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kantri ire mes mewo kantri aye ane mege, di king iri nikin wute ane mes mewo di king aye nikin wute ane mege, di tiqe ninge pe mir segi. Di tiqe ninge pe titwuye naghe. ");
INSERT INTO kms_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yumbo ren kin te wute wo pe wuso ningg yuqo puate rew kughe kin pugri. ");
INSERT INTO kms_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tende puayi nungoqi mitaqu mo unje mupuqu mai isis meuq, di mumbuequ wati, di nungoqi nge ningg wute pugri bu ni nge nyamb brequ mindigh ningg mari di nungoqi yambu mireuq. ");
INSERT INTO kms_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Di ninge nge nei rimbigh kin te si rire, di ni kin kinne ker ruwo di ni kinne oyi oyi res ruwo veri nde si pe ri rundo. ");
INSERT INTO kms_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Di wute ninge mandi wandoqi mand mari ni propet di wute nganye buagi wandoqi mindiny. ");
INSERT INTO kms_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Di tiqe manyi wute nganye buagi yumbo ur brequ rind, pugri bu wute nganye buagi nganye ni wute yawo rirany righe kin nei te mune gre rind segi. ");
INSERT INTO kms_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pudi wute tughe ni gre pu yeru ruso ruso ngeri pre, tedi God ni nateri. ");
INSERT INTO kms_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Di wute God nde si nambu yeru kin wand yuwon ye ven tiqe buagi qi pe ven nde yeru kin tende wute buagi simbe mindiny rutungu pre muqdi ngeri pre ye. ");
INSERT INTO kms_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nungoqi otiwo wuqond yumbo brequ nganye God ningg baj brequ wunduw ye ire yequ. Ni puq wen kin te asi propet iri Daniel puq mindig kin ni simbe nand ye ane tuquine.” (Nu wuti wand ven guqod ye nu wand puate ei oghine nei mbiny.) ");
INSERT INTO kms_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Te muqdi wute Judia opu ris kin te wu rise rand pe ei riwo ruso. ");
INSERT INTO kms_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wuti baj wam nas kin ni mune baj pe nar no yumbo ninge nateri wayequ. Ni brequne wu nase no. ");
INSERT INTO kms_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wuti iri wuny mbe yenu kin mune nambu no chongo aye nitaqwi wayequ. Ni brequne wu nase no. ");
INSERT INTO kms_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tende puayi nyumbueg wo ane ris kin di ninge ni wo wokuandi ne ris ye ni mai quan nganye rire ye. ");
INSERT INTO kms_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nungoqi God pengu wundig ei yumbo ren kin ngeri uyi kin o Sabat kin nginy tende puayi puq ren segi. ");
INSERT INTO kms_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Te pugri asi God qi di yumbo buagi yembe nindiny kin tende puayi pu rindi muq mai yumbui ren kin rindi segi. Di otiwo mune mai ren kin segi. ");
INSERT INTO kms_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yumbui ni wute mai rire kin ngeri te pend nawo puayi rise segi, tedi wuti iri ni gre nand nas tuqui segi. Pudi ni wute nap ruso kin ni ningg nari bu ngeri te pend nawo puayi rise. ");
INSERT INTO kms_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tende puayi wuti iri nandi nari, ‘Kraist nen yenu.’ O nari, ‘Ni te no yenu.’ Nungoqi ni wand te wutungu wayequ. ");
INSERT INTO kms_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Te pugri Kraist wandoqi kin di propet wandoqi kin ni mandi di yumbo ur gre ye isis yembe mindiny. Ni puq men ei tuqui tedi wute Yumbui nap ruso kin te wandoqi mindiny di ir righe. ");
INSERT INTO kms_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nungoqi wutungu. Nge yumbo buagi ren ningg muqne simbe guduq pre otiwo yumbo te kin puq ren. ");
INSERT INTO kms_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Muq ni nungoqi ningg mari, ‘Te wuqond, ni wuye di nyumo segi ye pe tende yenu.’ Nungoqi tende wo wayequ. Muq ni mari, ‘Te wuqond, ni tende suqo pu yenu.’ Nungoqi wand te wutungu wayequ. ");
INSERT INTO kms_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wuti God nde pu nandi wuti nganye nas ye ni nandi ningg tedi ti pris kin pugri nginy nawi opu ti nase tene rindi ruso nginy naghe no opu di wute buagi ni ruqoind. ");
INSERT INTO kms_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ni nandi kin taq pugri, umo riti kin ni muainde rise te wapi ambojig ni mandi tendene mikur. ");
INSERT INTO kms_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mai yumbui ren ruso pre, brequne nginy burpoq nap, di irew mune ti wuri segi, di tomnji nginy tu pe pu bi ir mi, di yumbo gre kin nginy tu pe yeru kin tit rip. ");
INSERT INTO kms_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tende puayi di wute buagi qi pe kin ni ruqond wuti God nde pu nandi wuti nganye nas kin nikin ur nginy tu pe ruwi di ni quanji rind. Di ni ruqond wuti God nde pu nandi wuti nganye nas kin ni wuye quari pe gre di ti yumbui ane nandi. ");
INSERT INTO kms_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Di angelo biugel piq nuqoind quan nganye nari, di ni nikin angelo tiqi nundom tiqe buagi mo nikin wute ni nap ruso pre kin te mirur. Angelo ni tiqe manyi wute materi ruso ruso qi cheq pene, di ni mitari mandi. ");
INSERT INTO kms_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nungoqi nyumo fig ni yumbo ur te wuqond di tende pu nei wateri di nei wamb tuqui. Nyumo fig ni muange te uyi mare di raqe riyi tedi nungoqi nei wamb te wuye wundi kin ngeri te muq tumo rind. ");
INSERT INTO kms_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Te kin pugrine otiwo yumbo nge simbe gad ye te puq ren, tedi nungoqi nei wamb te pugri wuti God nde pu nandi kin ni mune nandi kin ngeri te tumo nganye rind, ni ngimrawu ne yenu. ");
INSERT INTO kms_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nge nungoqi nganyene simbe guduq, wute tit muq ris kin ren ni riti segi, risne di yumbo te kin puq ren. ");
INSERT INTO kms_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nginy tu di qi ane ni pre ye, pudi nge wand te pre segi ye. ");
INSERT INTO kms_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pudi wuti iri ni nei namb pughe puayi o aua pughe ye tende ei wuti God nde pu nandi wuti nganye nas ye ni mune nandi kin te ni nei namb segi. Angelo buagi wam kin ni mune nei mamb segi, God ningg wo mune nei namb segi, wuyi irine nei namb. ");
INSERT INTO kms_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yumbo ur Noa ni nas kin tende puayi puq men kin te muq wuti God nde pu nandi wuti nganye nas ye ni mune nandi kin mune pugrine puq men. ");
INSERT INTO kms_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yabe wuye nime yumbui nase segine, wute mir rind wuye riq, wute ngam ruso, tetene ruso ruso Noa ni at pe nar no, ");
INSERT INTO kms_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","di wute ni nei tuan rimb pu ris kin tende puayi wuye nime yumbui nase nandi ni quan buagine nare no. Te kin pugrine wuti God nde pu nandi wuti nganye nas ye ni mune nandi kin ngeri te mune pugrine. ");
INSERT INTO kms_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wute temi wuny mbe yembe mand, ni nandi iri neti nowi di iri yenu. ");
INSERT INTO kms_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nyumbueg teri plaua bret yembe runduw kin te kin yembe rind rind yeru, ni nandi ire nitaqi no di ire pugrine yequ. ");
INSERT INTO kms_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pugri bu nungoqi yeng wawo yuwon, te pugri nungoqi Yumbui mune nandi kin ngeri te nungoqi nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nungoqi yumbo ur ren nei wumbiny. Muq baj kiyi nei namb bur pughe ye te ningg ei wuti nyungu ye nandi ni baj bir nuang ningg, tedi ni yeng nawo di wuti nyungu kin ni baj bir nawo nar no segi. ");
INSERT INTO kms_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Te kin pugrine nungoqi mune yeng wawo yuwon, te pugri nungoqi nginy nei wumbig segi kin tende puayi di wuti God nde pu nandi wuti nganye nas ye ni mune nandi. ");
INSERT INTO kms_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wuti yembe ye ni nei oghi ye rise di ni yembe nikin yumbui neng kin te oghine yembe nand, bu nikin yumbui ni si numbog yembe ye aye te yeng nuany di mir rind kin puayi mir neny. ");
INSERT INTO kms_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wuti te otiwo nikin yumbui nandi nuqoind ni yembe nand nandne nas, tedi ni chumbuai nand. ");
INSERT INTO kms_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nge nganyene nganye nungoqi simbe guduq, yumbui ni yembe ye wuti te si numbog di ni yumbo yumbo buagi yeng nuany ye. ");
INSERT INTO kms_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pudi yembe ye wuti te ni wuti brequ di ni nari, ‘Nge yumbui brequne nandi segi ye,’ ");
INSERT INTO kms_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","di yembe ye ni yeng nuany kin te pug nindiny, di ni wute wuye kumo me kin te ane mir mand di wuye me. ");
INSERT INTO kms_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Muq wuti te ni yumbui nandi kin nginy te ni yeng nawo segi, di aua pughe ye nandi kin te ni nei namb segi, ");
INSERT INTO kms_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","di ni nandi mai neng, tiqi nundog no wute nei tevi kin te ane mas. Tende wute quanji mand di sawo mat ki ye.” ");
INSERT INTO kms_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas ni mune simbe nand nari, “Tende puayi yumbo buagi God nde si nambu rise kin te nyumbueg ambonye 10-pela kin pugri. Ni lam rind rire ruso, wuti iri ngam urupui no kin te ghimbi ruang pu yeru, ni nandi ei ane ngam urupui ruso kin mir pe tende ruso ningg. ");
INSERT INTO kms_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nyumbueg ambonye 5-pela ni nei segi, di 5-pela ni nei oghi ye rimb. ");
INSERT INTO kms_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nyumbueg nei segi kin ni lam rind rire, pudi wel aye rire segi. ");
INSERT INTO kms_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nyumbueg nei oghi kin ni wel aye lam ane rire. ");
INSERT INTO kms_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wuti te ngam urupui no kin ni brequ nandi segi, pugri bu ni ruqoi kureny, yabe ruqo rise. ");
INSERT INTO kms_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Burpoq mingi wuti iri pugri nari, ‘Wuti ngam urupui no kin be nandi. Nungoqi wandi po, ngimi buqoid, muqdi pitanyi badi.’ ");
INSERT INTO kms_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Muq nyumbueg ambonye buagi res riwo, ni lam wik te mune rindiri riwo. ");
INSERT INTO kms_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Di nyumbueg nei segi kin te ni ninge nei oghi kin te ningg riri, ‘Beghi wel puch wengu lam pe pawo righe, beghi lam awu ruso.’ ");
INSERT INTO kms_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pudi nei oghi kin oyi riri, ‘Nungoqi mune peuq tedi beghi tuqui segi. Nungoqi wo, stua pe nungoqi non tene wong wand.’ ");
INSERT INTO kms_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Di ni wel wong rind yamb ruso pu yeru, wuti ngam urupui no kin nandi, ninge te ni ghimbi ruang pu ris kin te ni nitari anene ngam kin mir yumbui tende rir ruso, di ni ngim miraq wughe. ");
INSERT INTO kms_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dobu pu ninge te rindi riri, ‘Yumbui, yumbui, beghi ngim bi wangu.’ ");
INSERT INTO kms_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pudi ni oyi nand nari, ‘Nge nganyene nganye nungoqi simbe guduq, nge nungoqi nei gubuq segi.’ ");
INSERT INTO kms_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Pugri bu nungoqi yeng wawo pune ei was. Nginy pughe ye te ningg di aua pughe ye te ningg ei nungoqi non Yumbui nandi te nungoqi nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Wute buagi God nde si nambu yeru kin taq pugri: wuti iri ni wonji no ningg nikin yembe ye nari mandi, di ni yumbo buagi te bir nawo ni nem ei ni yeng muany. ");
INSERT INTO kms_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ni yembe ye wute ni yembe mand kin ane tuquine ire ire nem. Ni wuti iri 5,000 kina neng, iri 2,000 kina neng, di aye iri 1,000 kina neng, pre muq ni tiqe aye pe no. ");
INSERT INTO kms_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wuti iri ni 5,000 kina nat rise kin te ni brequne no, bisnis yembe nand, aye mune 5,000 kina nateri. ");
INSERT INTO kms_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pugrine wuti 2,000 kina nat rise kin te ni mune bisnis yembe nand aye mune 2,000 kina nateri. ");
INSERT INTO kms_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pudi wuti 1,000 kina nat rise kin te nikin yumbui ningg wet bidi te nare no qi ngamo nuaq suqo nare. ");
INSERT INTO kms_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Muq dobu nikin yumbui mune nandi di nikin yembe ye te nuqond ni wet bidi pughe sin bri men. ");
INSERT INTO kms_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wuti 5,000 kina nat rise kin te nandi, rar ngimine yenu, ni 5,000 kina aye narene nandi muq nari, ‘Yumbui, nu nge 5,000 kina kuegh, muq nge 5,000 kina aye ren mune kateri.’ ");
INSERT INTO kms_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nikin yumbui oyi nand nari, ‘Nu yembe ye wuti oghi di nu yuwonne yembe guad ye. Nu yumbo wokuandi nganye yeng kuany. Muqdi nge nu yumbo quan kew nu yeng wany. Nu ghandi nge nunon yumbui ane chumbuai bad.’ ");
INSERT INTO kms_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Wuti 2,000 kina nat rise kin ni mune nandi nari, ‘Yumbui, nu nge 2,000 kina kuegh, muq nge 2,000 kina aye ren mune kateri.’ ");
INSERT INTO kms_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nikin yumbui oyi nand nari, ‘Nu yembe ye wuti oghi di nu yuwonne yembe guad ye. Nu yumbo wokuandi nganye yeng kuany. Muqdi nge nu yumbo quan kew nu yeng wany. Muq nu ghandi nge nunon yumbui ane chumbuai bad.’ ");
INSERT INTO kms_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Muq wuti 1,000 kina nat rise kin mune nandi, rar ngimine yenu, muq nari, ‘Yumbui, nge nei gab nu wute aye yawo kutony segi ye. Nu mir wute aye mi righe kin te bi kuawo ye. Wute aye ni mir yi mi righe kin te nu mir tende kuateri, ");
INSERT INTO kms_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","pugri bu nge wune gab, di nge nu 1,000 kina ren kare ko, qi pe suqo kare. Te qond, nu wet bidi taq ren.’ ");
INSERT INTO kms_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pudi nikin yumbui oyi nand nari, ‘Nu yembe ye wuti brequ. Nu yembe ye kuen si yavi quang. Nu kuari nge wute aye mir mi righe kin te nge bi kawo, di nge ko wute aye mir yi memare kin te kateri. ");
INSERT INTO kms_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pughe kin ningg nge wet bidi kuare kuo, wet bidi baj pe kuawo righe segi, te ei nge mune gadi di nge wet bidi kateri, di aye ninge megh ane. ");
INSERT INTO kms_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Muq nungoqi ni wet bidi wutangri, wuti aye 10,000 kina rise kin te ni weng. ");
INSERT INTO kms_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te pugri wute tughe ni yumbo ninge rise pre, tedi nge yumbo aye ninge keny, di ni yumbo quan rise. Muq wute tughe ni yumbo segi, ni musoqne rise, tedi nge mune ninde pu kateri. ");
INSERT INTO kms_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yembe ye wuti brequ nen wutanyi wo, burpoq pe meweri naghe. Tende wute ni quanji rind di sawo rit ki ye’.” ");
INSERT INTO kms_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Otiwo wuti God nde pu nandi wuti nganye nas ye ni king kin pugri ei nikin ti yumbui ane nandi, di angelo buagi ane mandi, di ni sia king pe wam kin ti yumbui ane nas. ");
INSERT INTO kms_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tende ni wute buagi tiqe manyi kin mitari mandi ninde rar ngimine yeru, di ni wute ir nawo, wuti sipsip yeng nuany kin ni sipsip di meme ir nawo kin pugri. ");
INSERT INTO kms_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ni sipsip si nganye pe opu nawo yeru, di meme si qaqi pe opu nawo yeru. ");
INSERT INTO kms_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Di king ni wute ninde si nganye pe opu yeru kin te simbe nindiny nari, ‘Nungoqi nge wuyi yuwon nuauq pre ye nungoqi ren wandi. Asi qi urupuine kin tende puayi ni nungoqi yumbo yuwon ye manyi nunduq pre ye. Nungoqi wandi yumbo te kin wateri. ");
INSERT INTO kms_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Te pugri nge mir kuregh di nungoqi nge mir wegh, nge yawo singar kati di nungoqi nge wuye wegh, nge wuti aye kin di nungoqi nge wutanyi baj pe wo, ");
INSERT INTO kms_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nge chongo segi di nungoqi nge chongo wegh, nge num kuregh di nungoqi nge yeng wagh, nge taq pu yengu di nungoqi wandi nge wuqoind.’ ");
INSERT INTO kms_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Di wute tuquine ris ye oyi rind riri, ‘Yumbui, pughe puayi beghi nu buqoid nu mir ane kuas di beghi mir pew? Di pughe puayi nu yawo singar kuati di beghi nu wuye pew? ");
INSERT INTO kms_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Di pughe puayi beghi nu buqoid nu aye kin di beghi pitanyi baj pe po, o pughe puayi nu chongo segi di beghi chongo pew? ");
INSERT INTO kms_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Di pughe puayi beghi nu buqoid nu num kurew di beghi nu yeng puaw, o pughe puayi nu taq yengu di beghi badi nu buqoid’?” ");
INSERT INTO kms_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Di king ni oyi nindiny nari, ‘Nge nganyene nganye nungoqi simbe guduq, qam ren kin iri nyamb segi kin ninde yumbo ur puq wen kin te nge bu puq wegh.’ ");
INSERT INTO kms_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Muq wute si qaqi pe yeru kin te simbe nindiny nari, ‘Nungoqi kring wo, God nungoqi brequ nunduq ye. Nungoqi wase awu kuso segi ye pe tende wo, Satan di ni angelo brequ te ane ni mingg bu wase kuen nawo kughe pu yengu. ");
INSERT INTO kms_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Te pugri nge mir kuregh di nge mir wegh segi, nge yawo singar kati di nungoqi nge wuye wegh segi, ");
INSERT INTO kms_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nge aye kin di nungoqi nge wutanyi baj pe wo segi, nge chongo segi di nungoqi nge chongo wegh segi, nge num kuregh di taq yengu di nungoqi wandi nge ghav wundigh segi.’ ");
INSERT INTO kms_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Di ni oyi rind riri, ‘Yumbui, pughe puayi beghi nu buqoid nu mir ane yengu, o yawo singar kuati, o nu wuti aye kin, o nu chongo segi, o nu num kurew, o nu taq yengu di beghi nu yumbo ghav buduw segi?’ ");
INSERT INTO kms_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Di ni oyi nindiny nari, ‘Nge nganyene nganye nungoqi simbe guduq, nungoqi qam ren kin iri ni nyamb segi kin ninde yumbo ur pugri ye puq wen segi te nge bu puq wegh segi.’ ");
INSERT INTO kms_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Di ni ruso yuqo pre segi ye pe tende yuqo riraq ris ris te kin ris, pudi wute tuquine ris kin ni ruso yuwon pu ris ris te kin ris kin tende ruso.” ");
INSERT INTO kms_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas ni wand buagi te simbe nand omone nawo pre, muq nikin wute pugri simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nungoqi nei wamb nginy temi mo pre dobu di asi God ni Israel mingg wo rar nuqond mas kin ngeri te nei bibiny ye. Tende puayi di ni nge, wuti God nde pu gadi wuti nganye kas ye, nge veri nde si pe mi godo, di kruse pe qungu mi kati.” ");
INSERT INTO kms_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Di tende puayine prist mingg yumbui di Israel mingg quayi kiyi ni mo prist mingg yumbui mingg yumbui, Kaiapas puq mindig kin, ninde baj yumbui pe mikur, ");
INSERT INTO kms_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","di ni wand taq mamb ei waghi grine Jisas mait nase, di mi nati ningg. ");
INSERT INTO kms_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pudi mari, “Beghi yumbo ren kin ngeri yumbui nei bibiny kin tende puayi puq pen wayequ. Beghi puq pen tedi wute buagi beghi ker ruangu.” ");
INSERT INTO kms_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas ni Betani wuti iri Saimon, wuti asi leprosi niraq kin, ninde baj pe nas. ");
INSERT INTO kms_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Di nyumbueg ire wel yuwon nganye iri botol ane wuri wundi. Wel te wet bidi quan pe wong wuind. Botol te wet yuwon nganye iri, alabasta puq mindig kin tende pe yembe mindig ye. Jisas ni mir nand nand nas di nyumbueg te wel wuri wundo, Jisas nde ngawu pe groq wundig. ");
INSERT INTO kms_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pudi tende puayi Jisas ningg wute ninge ni te muqond, ni umbo brequ kuse, di mari, “Pughe kin ningg ni wel nen unje wuip? ");
INSERT INTO kms_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Beghi wute aye pem wong maind, tedi nen ningg beghi wet bidi quan pateri, di wute yumbo segi kin te peny.” ");
INSERT INTO kms_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pudi Jisas ni nei te nundom pre, pugri bu ni simbe nindim nari, “Nungoqi ni rar wundoq. Pughe ningg nungoqi ni yumbo puq wen kin te ningg segi puq wand? Ni yumbo ur oghi ye nge nde yembe wundiny. ");
INSERT INTO kms_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wute yumbo segi kin nungoqi ane was ye, pudi nge nungoqi ane pas nganye segi ye. ");
INSERT INTO kms_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nyumbueg wen ni wel nge nde ghimbi pe groq wuind kin te ni nge ghimbi muqne sabi wundiny pu ei otiwo nge ngamo pe ko ye. ");
INSERT INTO kms_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nge nungoqi nganyene simbe guduq te pugri otiwo wute mo tiqe buagi te wand yuwon ye bir mawo kin tende puayi wute wen ni yumbo yembe wundiny kin ren anene simbe mand ye. Ni pugri puq men ei nyumbueg yumbo ren yembe wundiny kin wen anene nei rumbuw.” ");
INSERT INTO kms_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tende puayi Jisas nikin wute 12-pela kin iri, Judas Iskariot puq mindig kin, ni no prist mingg yumbui te nuqond, ");
INSERT INTO kms_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","di nari, “Nge Jisas nungoqi nde si pe ki nondo, tedi nungoqi nge yumbo pughe kin ei wegh?” Di ni wong maind silva puch 30-pela pu meng. ");
INSERT INTO kms_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Di tende puayine Judas ni Jisas veri nde si pe ni nondo kin ngim meri nat. ");
INSERT INTO kms_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Muq Juda ni bret yis segi kin riq ye nginy ye nawo ye tende puayi Jisas nikin wute ninde mandi di pengu mindig mari, “Nu nei guab ye beghi muainde ei mir yembe bidiny, di nu guadi ane mir bad ei God asi Israel mingg wo rar nuqond mas kin ngeri te nei bibiny?” ");
INSERT INTO kms_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ni oyi nand nari, “Nungoqi wo, tiqe yumbui pe wuti te nas kin te simbe wundig wari, ‘Tisa nari, nge ngeri tumo rind. Nge ngening wute ane nunde baj pe ei pikur di God ni asi Israel mingg wo rar nuqond mas kin ngeri te nei bibiny ningg mir bad ye’.” ");
INSERT INTO kms_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Di Jisas nikin wute ni nari kin pugrine puq men, di ni mir te kin yembe mindiny. ");
INSERT INTO kms_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Di yuram ni nikin wute 12-pela pu ane tebol pe mas, ");
INSERT INTO kms_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","di ni mir mand mand mas di ni nari, “Nge nungoqi nganyene simbe guduq, nungoqi kin iri ni nge veri nde si pe ni godo ye.” ");
INSERT INTO kms_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Di ni quan nganye yivany mare, di ni ire ire pengu mindig mari, “Yumbui, nu nge ningg bri kuari?” ");
INSERT INTO kms_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ni oyi nand nari, “Wuti nge temu nyeng ire pe si pawo righe kin ni di nge veri nde si pe ni godo ye. ");
INSERT INTO kms_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wuti God nde pu nandi wuti nganye nas ye ni nati kin te God ningg buk puq wund kin pugrine ei nati ye. Pudi wuti pughe ye ni wuti God nde pu nandi wuti nganye nas ye ni veri nde si pe ni nondo kin ni mai yumbui nganye niraq ye. Wuti te kin kumo wuri wundi segi tedi yuwon nganye.” ");
INSERT INTO kms_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas wuti Jisas veri nde si pe ni nondo ye ni nari, “Tisa, nu nge ningg bri kuari?” Ni oyi nindig nari, “Nu tuquine guad.” ");
INSERT INTO kms_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ni mir mand mand mas, di Jisas ni bret nitaqwi, Yumbui chumbuai nindig pre, bir nuaq nikin wute te nem di nari, “Bret wen wutaqwi waq, wen nge ghimbi.” ");
INSERT INTO kms_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Te pre muq ni wain mune kap ane neti nowi, Yumbui chumbuai nindig pre, nem di nari, “Nungoqi buagi ane we. ");
INSERT INTO kms_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nen nge yavi di yavi wen te God asi Moses ane wand taq mamb kin te gre weny. Di yavi wen te ir wi ei wute nganye buagi yumbo ur brequ kin wand te puaq. ");
INSERT INTO kms_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nge nungoqi simbe guduq, nge wain nen mune ke segi segine ruso ruso otiwo nge nungoqi ane yumbo yumbo buagi nge wuyi nde si nambu yeru kin tende pas di wain urupui pe.” ");
INSERT INTO kms_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Muq ni yuwo ire mari di tiqe yumbui te si miraq, di rand iri Oliv puq mindig kin tende mo. ");
INSERT INTO kms_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Muq Jisas ni pugri simbe nindim nari, “Muq bur kuen gug yumbo ninge nge nde ruwi di nungoqi ir waghe ye. Te pugri God ningg buk pe pugri ur mand mari, ‘Nge wuti sipsip yeng nuany kin te ki di sipsip bure ire ire ruso ye.’ ");
INSERT INTO kms_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pudi dobu nge kes kewo, di nge ye kawo Galili ko di nungoqi waru.” ");
INSERT INTO kms_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Di Pita nes newo Jisas ningg nari, “Piyi wute buagi yumbo nunde ruwi kin te muqond di ni ir maghe, pudi nge ir kaghe tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Di Jisas oyi nindig nari, “Nge nu nganyene simbe guduw, muq bur wapiqu nari segine di nu ghari nu nge nei gubigh segi puq ghand tevi ire pu ghand ye.” ");
INSERT INTO kms_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pudi Pita oyi Jisas oyi nindig nari, “Piyi, nge nu temune pati ye, nge kari nge nu nei gubuw segi ye puq gad tuqui segi.” Di Jisas nikin wute quan buagine pugrine puq mand. ");
INSERT INTO kms_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Muq Jisas nikin wute ane mong puch ire Getsemani puq munduw kin tende mo, di ni nikin wute simbe nindim nari, “Nungoqi ven ne was, nge tende ko God pengu gidig.” ");
INSERT INTO kms_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Di ni Pita di Sebedi ningg wo temi te ane nitami no. Ni misoqne kring mondo, di ni umbo mai kuyo, di ni nutungu ghave rimb. ");
INSERT INTO kms_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Muq ni pugri simbe nindim nari, “Nge umbo mai kuyo di nge ghimbi kutungu ghave rimb, nge kati ningg tumo. Nungoqi ven nde was nge ane yeng pawo.” ");
INSERT INTO kms_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Di ni musoqne kring nondo wonji pugri yenu, muq ni qi pe me no nase, God pengu nindig nari, “Nge wuyi, nu tuqui tedi nge yuqo kiraq ye kap wen taqwi. Pudi nge kari kin wand te tungu segi, nu non nei pene.” ");
INSERT INTO kms_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Di ni mune nandi, nikin wute nuqond ni ruqo pu mase, di ni Pita ningg nari, “Pughe gri ate nungoqi nge ane yeng pawo ruso aua ire segi? ");
INSERT INTO kms_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yeng wawo, di God pengu wundig ei Satan nungoqi wandoqi nunduq kin tende puayi nungoqi ir waghe segi. Nungoqi umbo yumbo yembe gudiny ningg kuri, pudi ghimbi buid segi.” ");
INSERT INTO kms_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ni munene no God pengu nindig nari, “Wuyi, nu nei guab kin yuqo kiraq kin te yuwon, tedi nu kuari kin pugrine puq yen.” ");
INSERT INTO kms_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Di ni mune nandi nuqond nikin wute ruqo pune mase. Te pugri ni rar mai riwo. ");
INSERT INTO kms_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Muq ni si nare mase, di ni mune no mining kin pugrine God pengu nindig, ni wand asi nand kin tene mune simbe nand. ");
INSERT INTO kms_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Muq ni nandi nikin wute nuqond, di ni pugri simbe nindim nari, “Nungoqi ruqo pune ei wase ye bri? Te wuqond, wuti God nde pu nandi wuti nganye nas ye ni meti nowi wute yumbo ur brequ mand kin nde si pe mi nondo ye ngeri taq tumo rind pre. ");
INSERT INTO kms_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wes wewo, be po. Wuti nge veri nde si pe ni godo kin taq tumo nandi pre.” ");
INSERT INTO kms_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas ni wand nand nandne yenu, Judas nandi. Prist mingg yumbui ninge di Juda mingg quayi kiyi ni wute nganye buagi tiqi mundom mame bidi di wase puayi ane mare Judas nde dobu maru. (Judas ni Jisas nikin wute 12-pela kin iri.) ");
INSERT INTO kms_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Muq wuti nen Jisas nikin veri nde si pe ni nondo kin yumbo ur bei nindim kin te simbe nindim nari, “Wuti nge song gireg kin te wait nase.” ");
INSERT INTO kms_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Di ni Jisas nde tuquine nondo di nari, “Bur oghi Tisa!” Di ni song nireng. ");
INSERT INTO kms_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas oyi Judas simbe nindig nari, “Mand, nu yumbo pughe yembe gudiny ningg guadi kin te nu puq yen.” Di wute aye te mandi Jisas mait nase. ");
INSERT INTO kms_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Di Jisas ningg wuti iri ni mame dobui qo naimb di prist mingg yumbui mingg yumbui ni yembe ye wuti te iri ange di nuang ir wi. ");
INSERT INTO kms_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Di Jisas ni simbe nindig nari, “Mame dobui mune nikin chongo pe yi ndighe. Wute buagi mame pe yeng mand tedi mame oyi namb mati. ");
INSERT INTO kms_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nge te ningg kari, tedi nge wuyi pengu gidig di brequne ni angelo nganye buagi tiqi nundom mandi, nge ghav mindigh di wute men ni ane tuqui segi. Nu te kin nei guab segi bri? ");
INSERT INTO kms_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nge ni pengu gidig kin tuqui, pudi nge te kin pugri puq ken, tedi pughe gri ei God ningg buk puq wund kin te ane tuquine? Yumbo buagi ren God ningg buk wuri kin pugrine ei nge nde puq ren ye.” ");
INSERT INTO kms_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tende puayine Jisas ni wute buagi te simbe nindim nari, “Nge wute kitami yeng pe bri badi bu nungoqi mame dobui di wase puayi ane ware nge wait kase ningg wandi? Nginy manyi manyi nge God ningg baj pe tende kas di wute wand bei keny. Nungoqi nge pughe ningg tendene wait kase segi? ");
INSERT INTO kms_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pudi yumbo ur ren kin pugrine puq ren ei propet ni ur mand kin ane tuquine.” Di Jisas nikin wute buagi ni si meri wu mase mo. ");
INSERT INTO kms_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wute Jisas mait nase mitanyi prist mingg yumbui mingg yumbui Kaiapas nde mo, di wute lo wute bei meny kin di quayi kiyi ni tende mas. ");
INSERT INTO kms_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Di Pita Jisas nde dobu wonjine naru, di prist mingg yumbui mingg yumbui ni baj kin imb pe nar no. Wute tende yeng mawo pu yemu kin te ane mas, ei ni nuqond Jisas pughe sin bri meng. ");
INSERT INTO kms_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Prist mingg yumbui di kaunsil buagi ni wute ninge meri mand ei ni wand ghav mindim di Jisas wandoqi mindig ei ni mi nati. ");
INSERT INTO kms_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wute nganye buagi mandi Jisas wandoqi mindig, pudi ni mi nati kin ngim ire mundoq segi. Dobu pu wute aye temi mandi, ");
INSERT INTO kms_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","di mari, “Wuti nen nari, ‘Nge God ningg baj wen bir kuaq di nginy temi ire pune di mune yembe guduw omo kuaq kin tuqui’.” ");
INSERT INTO kms_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Muq prist mingg yumbui mingg yumbui nes newo Jisas ningg nari, “Nu ni wand te oyi gudim segi ye bri? Wand ven wute men nunde memiraw viyo kin te puate pughene?” ");
INSERT INTO kms_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pudi Jisas ni wand nand segi. Di prist mingg yumbui mingg yumbui ni simbe nindig nari, “Nge God nganyene nas kin ninde rar pe nu simbe guduw, di nu wand nganyene ei simbe ghand. Nu Kraist bri? Nu God ningg wo bri?” ");
INSERT INTO kms_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas ni oyi nindig nari, “Te nganye, nu simbe guad kin pugrine. Pudi nge nungoqi simbe guduq. Otiwo nungoqi wuti God nde pu nandi wuti nganye nas ye ni God gre quan nganye rise ye ninde si tuan pe opu nas di God nde tiqe pe pu wuye quari wam nandi wuqoind ye.” ");
INSERT INTO kms_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Prist mingg yumbui mingg yumbui ni wand ven nutungu, nikin chongo bir nuaq nari, “Nen God wand brequ nindig. Pughe kin ningg beghi wute aye mune pari mandi ni yumbo ur yembe nindiny kin te simbe mand? Muq tene nungoqi wutungu ni God wand brequ nindig. ");
INSERT INTO kms_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nungoqi pughe gri nei wamb?” Ni oyi mand mari, “Ni unje nap pre, ni nati tedi oghi.” ");
INSERT INTO kms_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Muq ni quenge pe sombaqe miping, di si mung mamb pug mindig. Ninge si bure mand kowisambe dang mindig, ");
INSERT INTO kms_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","di mari, “Nu nganyene nganye Kraist, ate God nde pu nei ghatevi beghi simbe ndug, wuti tughe bu nu ni?” ");
INSERT INTO kms_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Muq Pita baj dabo gri nas, di yembe ye nyumbueg ire ninde wundi wuri, “Nu anene Jisas Galili kin ni ningg wuti iri.” ");
INSERT INTO kms_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pudi wute buagi nde rar pe Pita segi puq nand nari, “Nge nei gab segi, nu pughe puq guad.” ");
INSERT INTO kms_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Muq ni no, ngimrawu ne yenu di nyumbueg aye ire ni wuqoind, ni wute buagi te simbe wundiny wuri, “Wuti nen ni Jisas Nasaret kin ni ane ye.” ");
INSERT INTO kms_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Di Pita mune segi puq nand nari, “Nge God nde rar pe kari nge wuti nen nei gibig segi!” ");
INSERT INTO kms_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ni yenu big rip pu wute ninde tumo yemu kin ni mandi Pita pugri simbe mindig mari, “Nganyene nganye, nu nikin iri. Nu wand guad kin gibe te nu bei rind.” ");
INSERT INTO kms_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Muq Pita ni wand gre neny, puq nand nari, “Nganyene wam ye nei namb, nge wuti nen nei gibig segi. Pudi nge wandoqi gad ate God nge brequ nindigh.” Ni puq nand pre brequne di wapiqu nari. ");
INSERT INTO kms_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Di Pita ni asi Jisas puq nand kin te mune nei nimbiny. Jisas nari, “Wapiqu nari segine nu ghari nu nge nei gubigh segi puq ghand tevi ire pu ghand ye.” Pita wand ven nei nimbiny, di dabo nar no, yumbui quanji kiyi nand. ");
INSERT INTO kms_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Burane ne prist mingg yumbui di quayi kiyi buagi wand taq mamb ei Jisas mi nati ningg. ");
INSERT INTO kms_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ni taq maimb di mitanyi mo gavman kin yumbui, Pailat, ninde si pe mi nondo. ");
INSERT INTO kms_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, wuti Jisas veri nde si pe ni nondo ye, ni nuqond kot pe ni wand taq mamb ei Jisas mi nati ningg. Di ni yivany nirang di wet bidi silva pe kin 30-pela pu prist mingg yumbui di quayi kiyi meng kin te mune nare no nem. ");
INSERT INTO kms_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Di ni pugri puq nand nari, “Nge yumbo ur brequ gad pre. Wuti nge nungoqi nde si pe ki nondo kin te ni yumbo ninge unje nap segi di nungoqi wi nati.” Pudi ni oyi mand mari, “Te beghi pughe sin ei pen? Nu non nde nei pene.” ");
INSERT INTO kms_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Di ni wet bidi te God ningg baj pe tende menare ruso ris, di ni nyinge nare no. Ni no, di nikinne pori naghe nati. ");
INSERT INTO kms_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pudi prist mingg yumbui ni wet bidi te materi mari, “Ren yavi kin wet bidi, pugri bu beghi lo wuri wet bidi ren God ningg baj kin wet bidi ane pawo ris segi ye.” ");
INSERT INTO kms_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Muq ni wet bidi te ningg nei mamb mari, ni qi puch ire wute asi tende os qi yembe mindiny kin te wong mindiq. Ni nei mamb kin wute tiqe wonji kin ni mati ei ni tende mawo yemu kin sunyi puq mand. ");
INSERT INTO kms_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pugri bu qi puch te wute nyamb miraw mari, “Yavi kin qi,” di muq wute buagi pugrine nyamb miraw mirawne. ");
INSERT INTO kms_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pugri bu propet iri, Jeremaia puq mindig kin, ni asi simbe nand kin ane tuquine. Ni pugri puq nand nari, “Ni wet bidi silva pe kin 30-pela pu materi. Wute Israel kin ni wet bidi pugri manyi mand kin te pugri ni wuti nen wong maind kin. ");
INSERT INTO kms_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Di wet bidi te kin pe ni qi puch ire wute tende os qi yembe mindiny kin te wong mindiq. Yumbui nge simbe nindigh kin ane tuquine.” ");
INSERT INTO kms_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Muq Jisas gavman kin yumbui, Pailat, ninde rar ngimine teti pu yenu di Pailat ni pengu nindig nari, “Nu Juda mingg king bu?” Di Jisas oyi nand nari, “Nu kuari nge Juda mingg king, te tuquine.” ");
INSERT INTO kms_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pudi prist mingg yumbui di quayi kiyi ane wand quan memirang viyo, di ni wand te oyi nindim segi. ");
INSERT INTO kms_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Muq Pailat ni ningg nari, “Nu wute buagi wand memiraw viyo kin te kutungu segi bri?” ");
INSERT INTO kms_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pudi Jisas ni wand ire oyi nindim segi, pugri bu Pailat ni nei kumo namb. ");
INSERT INTO kms_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Muq Rom mingg gavman kin yumbui nikin yumbo ur te pugri: Ber manyi God asi Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny ye tende puayi ni wute taq pu yemu kin te iri si neri no ye. Wute buagi nikinne ei wute taq yemu kin te iri nyamb rirang, di Pailat ni wuti te si neri no. ");
INSERT INTO kms_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tende puayi wuti iri yumbo ur brequ nganye nand ni taq pu yenu, ni nyamb Barabas. ");
INSERT INTO kms_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wute buagi rindi rikur pre, Pailat ni ningg nari, “Nungoqi nei wamb ye nge wuti pughe ye ei si keri nungoqi nde nondo, Barabas o Jisas, wuti ni Kraist pug mindig ye te?” ");
INSERT INTO kms_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ni puq nand, te pugri ni nei namb ni Jisas maip no mari bu ni kot pe mitanyi mandi. ");
INSERT INTO kms_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Muq Pailat ni jas ningg sia pene nas, ni ngam wand ire wi vindi wuri, “Nu wuti tuquine nganye nas ye nen ningg yumbo ninge yembe ndiny wayequ. Burpoq nge ruqo nyemb pe guqoid, di nge umbo mai kuyo.” ");
INSERT INTO kms_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pudi prist mingg yumbui di quayi kiyi ane wute chuch muany, ei ni Pailat ningg riri ni Barabas si neri nandi di Jisas mi nati. ");
INSERT INTO kms_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Di Pailat ni pugri pengu nindiny nari, “Wute temi men, nungoqi nei wamb ye nge pughe ye ei si keri nondo?” Di ni riri, “Barabas.” ");
INSERT INTO kms_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Di Pailat ni pengu nindiny nari, “Tedi wuti nen, Kraist puq mindig kin nen, nge pughe sin ei geg?” Ni quan buagine riri, “Kruse pe qungu wi nati.” ");
INSERT INTO kms_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Di ni nari, “Pughe kin ningg, ni yumbo pughe unje nap?” Pudi ni quan kumo riri, “Kruse pe qungu wi nati.” ");
INSERT INTO kms_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat ni nei namb ni wand wute rutungu segi ye, di ni yeng rind gib rimb. Pugri bu ni wuye natekui wute nde rar pene si wuye nap, nari, “Wuti nen nati, te nge unje kap segi, te nungoqi non nei pene.” ");
INSERT INTO kms_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wute buagi ni oyi rind riri, “Mai wen si rangu, beghi piraq di beghi wo miraq!” ");
INSERT INTO kms_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Muq ni Barabas si neri ninde nondo. Di ni nari soldia Jisas yas muang pre, di ni soldia nde si pe ni nondo ei kruse pe qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Muq gavman kin yumbui ni ningg soldia Jisas mitanyi gavman mingg baj pe mo di soldia buagi mandi Jisas quir quar mindig. ");
INSERT INTO kms_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Di ni chongo ir muang di king kin pugri chongo ambo kin mune mirang wughe. ");
INSERT INTO kms_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Di ni sare quat kin materi, king hat kin pugri yembe munduw, Jisas nde ngawu pe mirang wughe. Di ni botu iri si tuan pe opu meng nait nase, ni sungomyu gure mawo, di ni perei wand mindig mari, “Nu Juda mingg king, beghi nu chumbuai buduw.” ");
INSERT INTO kms_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Di ni som miping, di botu te mune meti nowi ngawu pe mi mi. ");
INSERT INTO kms_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ni perei wand mindig pre, di chongo ambo kin te ir muang di nikin chongone mune mirang wughe, di mitanyi mo ei kruse pe qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Di ni nyinge mare mo ngimi wuti iri muqoind, wuti te Sairini kin ni nyamb Saimon, di ni simbe mindig ni Jisas ningg kruse te niraq. ");
INSERT INTO kms_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Di ni mong puch ire Golgota puq mand kin tende mo. (Mong nyamb ven ni puate te, “ngawu ngape tiqe.”) ");
INSERT INTO kms_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sunyi tende ni wain marasin abo weq kin ane quang mamb kin te Jisas meng ne ningg. Pudi ni musoq ne, di ni mune segi puq nand. ");
INSERT INTO kms_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Soldia Jisas chongo ir muang di kruse pe qungu mi nati pre, muq ni satu griny mand ei Jisas ningg chongo te bir mawo ire ire mare mo ningg, ");
INSERT INTO kms_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","muq ni tene mas di ni yeng muang. ");
INSERT INTO kms_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ninde ngawu pe ni wand pughe ye te ningg Jisas mi nati kin te ur mand. Ni pugri ur mand mari, “Wuti nen Jisas, Juda mingg king.” ");
INSERT INTO kms_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Muq wute nyungu kin temi tendene kruse kin kin pe qungu mi mati pu yemu, iri si nganye pe opu, iri si qaqi pe opu. ");
INSERT INTO kms_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Di wute buagi tende ruso rindi, ni wand perei rindig di ngawu uring ri, ");
INSERT INTO kms_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","di riri, “Nu wuti God ningg baj bir kuaq pre di nginy temi ire pune di mune yembe guduw omo ye taq kuen qa. Be nu non ghimbine ghav ndiny. Nu nganyene nganye God ningg wo, ate nu kruse pe te pu ghati yi.” ");
INSERT INTO kms_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pugrine prist mingg yumbui di wute lo wute bei meny kin di quayi kiyi ni mune Jisas perei wand mindig mari, ");
INSERT INTO kms_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ni wute aye ghav nindiny. Ni nikinne ghav nand tuqui segi. Ni Israel mingg king. Ni kruse pe ven nde pu nati ni buqoid, tedi beghi pari te nganye. ");
INSERT INTO kms_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ni God nei nimbig ye di ni nari, ‘Nge God ningg wo.’ Pugri bu muq God ni oyi chumbuai nindig, ate ni ghav nindig buqoid.” ");
INSERT INTO kms_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wute nyungu ye temi Jisas ane kruse kin kin pe qungu mi mati kin ni mune pugrine perei mindig. ");
INSERT INTO kms_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Muq 12 kilok bogisumb bur ir kui ruso 3 kilok yuram. ");
INSERT INTO kms_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Muq 3 kilok ningg tumo rind rind Jisas quan kumo pugri nari, “Eli, Eli, lama sabaktani?” Wand ven puate taq pugri, “Nge God, nge God, pughe kin ningg nu nge si kueri?” ");
INSERT INTO kms_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wute ninge tumo yemu kin ni wand ven mutungu mari, “Wuti nen Elaija ngam nirang.” ");
INSERT INTO kms_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Di wuti te kin iri brequne vig namb no, chongo bidi ire nyumo kamo pe wureq nimbiq, wain pe neq wughe nitaqwi, ei Jisas wain neng, ne ningg. ");
INSERT INTO kms_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pudi ninge te segi puq mand mari, “Ghimbi ghawo buqod, Elaija ni nandi ghav bri nindig.” ");
INSERT INTO kms_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Di Jisas mune quan kumo nari pre, di nikin ququ si niraq wuso. ");
INSERT INTO kms_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tende puayine chongo God ningg baj pe meri naghe pu nase kin te newo wam pune bir tene no tingi, bidi temi pu yemu. Di qi tit wup di wet yumbui bir mas. ");
INSERT INTO kms_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Di wute mati kin ngamo bi ruso, God ningg wute asi mati kin ninge te mune mes mewo. ");
INSERT INTO kms_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ni mati kin sunyi pe mes mewo pu mas, otiwo Jisas nes newo kin tende dobu di ni Jerusalem mo, di wute quan ni ruqond. ");
INSERT INTO kms_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ami mingg yumbui ni soldia buagi te ane Jisas yeng muang pu yemu kin, ni muqond qi tit wup di ni yumbo yumbo buagi te muqond ni quan wune mamb di mari, “Nganyene nganye, wuti nen God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nyumbueg nganye buagi tende yeru, ni wonjine yeru di ruqond ruqond yeru. Ni asi Galili si riraq Jisas ghav rindig ningg ni nde dobu ruwi. ");
INSERT INTO kms_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tende mingi Maria Magdala kin, Maria Jems di Josep ni kumo, di Sebedi ningg wo temi te ni kumo ni ane tende yeru. ");
INSERT INTO kms_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tende yuramne wuti iri Arimatea kin, ni yumbo quan rise kin, ni nandi, ni nyamb Josep. Ni Jisas ningg wand nutungu di nganyene puq nand ye. ");
INSERT INTO kms_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ni no Pailat pengu nindig ei Jisas neti nati, neri no nowi yenu ningg. Muq Pailat ngiq nand, Jisas ni neng ye. ");
INSERT INTO kms_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Di Josep no, Jisas neti nowi, chongo urupui quem ye pe imb naimb, ");
INSERT INTO kms_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","di ni neri no, wute mati kin ngamo urupui pe nowi yenu. Ngamo te wet pe yembe munduw kin, Josep ni asi nari ngamo te yembe mindig, ei otiwo nine tende mowi yenu. Di Josep ni wet yumbui ire choch nipiq wundi, mim tuq nimbiq pre, di ni no. ");
INSERT INTO kms_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdala kin di Maria aye ire te teri tende ris. Ni teri ngamo pe tumone rar pu ris. ");
INSERT INTO kms_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Muq yambgriq Sabat kin nginy te ningg prist mingg yumbui ninge di Parisi ninge ane mo Pailat muqoind, ");
INSERT INTO kms_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","di mari, “Yumbui, beghi wuti wandoqi nand kin ni nati segine ni wand nand kin te beghi nei bibiny bibinyne vise. Ni nari, ‘Nginy temi ire pu mo pre di nge mune kes kewo.’ ");
INSERT INTO kms_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pugri bu nu ghari ei ngamo mim te tuq mimbiq gre ruso ruso nginy temi ire pu mo. Eti nikin wute mandi nyungu maind meri mo, di wute buagi simbe mindiny mari, ‘Jisas yabe mune nes newo.’ Di ni muq wandoqi mand kin te quan yumbui, di asi ni nasne wandoqi nand kin te musoq.” ");
INSERT INTO kms_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat ni oyi nindim nari, “Nungoqi soldia wutami wo, simbe wundim ngamo pe tende yeng mawo pu yemu. Nungoqi wo, nungoqi non nei pe ngamo pughe sin wew gre wund kin te pugri puq wen.” ");
INSERT INTO kms_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Muq ni mo segi puq mand kin yumbo ur te yembe mindiny pre, di ngamo imb muaq gre di mari soldia tende yeng muaw pu yemu. ");
INSERT INTO kms_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat kin nginy te no pre, tumo di namba wan wik kin nginy neyi, tende puayi Maria Magdala kin di Maria aye ire te ane ruso ngamo rundoq. ");
INSERT INTO kms_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Di brequne qi tit wup, te pugri Yumbui ningg angelo nginy tu wam pu nati ni, wet te choch nipiq wuso, di tende newo pu nas. ");
INSERT INTO kms_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ni quenge pris naghe ti nase kin pugri ti neri, di ni chongo quem nganye rimb. ");
INSERT INTO kms_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldia buagi ni wune mimbig, buyaq mand, di mati kin pugri mase. ");
INSERT INTO kms_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pudi angelo nyumbueg teri te simbe nindiny nari, “Nungoqi wune wamb wayequ, nge nei gab nungoqi Jisas, wuti kruse pe qungu mi nati kin te wuqoind ningg. ");
INSERT INTO kms_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ni ven nde nase segi, ni mune nes newo pre, asi ni puq nand kin pugri. Nungoqi wandi, ni nase kin sunyi ven wuqond. ");
INSERT INTO kms_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Di nungoqi brequne wo, nikin wute te simbe wundim, ‘Ni nati kin yabe mune nes newo pre, di brequne ni ye nawo no Galili, tende wo di wuqoind.’ Nungoqi nge wand ven simbe guduq pre kin te wutungu.” ");
INSERT INTO kms_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Muq ni teri wune rimb, pudi ni chumbuai ane ngamo si riraq brequne vig rimb ruso ei Jisas nikin wute te simbe rindim. ");
INSERT INTO kms_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Di brequne Jisas ni ngimi nuqond di nari, “Nungoqi umbo yuwon kuse.” Di teri rundo tumo, ni nyinge riting vise di ni yumbui nyamb rirang. ");
INSERT INTO kms_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Di Jisas ni simbe nindiny nari, “Nungoqi wune wamb wayequ. Nungoqi wo nge qam simbe wundim ni Galili mo, tende di nge muqoind.” ");
INSERT INTO kms_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nyumbueg teri te ruso rusone soldia ngamo yeng muaw kin ninge te tiqe yumbui mo, di yumbo pughe kin tende ruwi kin te prist mingg yumbui simbe mindim. ");
INSERT INTO kms_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Muq prist mingg yumbui ninge di Juda mingg quayi kiyi ninge ane mikur, wand taq mamb di ni wet bidi yumbui soldia mem, ");
INSERT INTO kms_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","di simbe mindim mari, “Nungoqi wari, ‘Beghi ruqo kumo pase bu Jisas nikin wute burpoq mingi mandi Jisas nyungu maind meri mo.’ ");
INSERT INTO kms_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Otiwo Pailat gavman kin yumbui ni wand te nutungu di ker nawo, ate beghi ni ane wand teti pawo di nungoqi mai wuraq segi.” ");
INSERT INTO kms_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Muq soldia wet bidi te mat rise, di ni simbe mindim kin pugrine puq men, wand ven kin viso Juda buagi rutungu, di Juda ni wand tene rind rind rindi muq. ");
INSERT INTO kms_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Muq Jisas nikin wute 11-pela pu mo Galili, di ni mo rand asi Jisas ni simbe nindim kin tende mo. ");
INSERT INTO kms_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ni Jisas muqoind yumbui nyamb mirang, pudi ninge nei tevi mamb. ");
INSERT INTO kms_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Muq Jisas ninde nandi nari, “God nge ngiq nindigh di nge gre buagi wam kin di qi pe kin tende wam kas. ");
INSERT INTO kms_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pugri bu nungoqi wute tit buagi nde wo, di simbe wundiny ei ni nge gig wute ningg ris. Nungoqi ni wuyi nde nyamb pe di wo nde nyamb pe di Ququ Yuwon Ye nde nyamb pe wuye wap. ");
INSERT INTO kms_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Di nungoqi ni bei wundiny ei ni wand buagi nge simbe guduq kin te kin pugrine puq ren. Nge nganyene nungoqi ane pas ruso ruso ngeri pre ye.” ");
INSERT INTO kms_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Wand ven te God ni wo Jisas Kraist ningg wand yuwon ye. Di wand ven te propet iri Aisaia puq mindig kin ni wand simbe nand kin ven nde pu puate ri righe. Aisaia wand simbe nand kin taq pugri: God ni nari, “Nge wuti iri nge ningg wand nare no kin te tiqi gudog ye nawo nu ngim sabi nunduw. ");
INSERT INTO kms_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wuti iri mong nyumo di wuye segi ye pe tende yenu di ngam nare nari, ‘Yumbui ngim wuang, di ngim sabi wundig pu wuse ei ni nyinge nare’.” ");
INSERT INTO kms_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Di te kin pugrine Jon ni qi nyumo di wuye segi ye pe tende wand bir nawo di wute simbe nindiny ei ni nei rire ritinde di ni wuye nap ei God ni yumbo ur brequ rind kin wand te puaq nindiny. ");
INSERT INTO kms_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wute buagi Judia opu kin di Jerusalem kin ni ruso Jon wand nand kin te rutungu. Ni ruso ni yumbo ur brequ yembe rindiny kin te simbe rind pre di Jon ni wuye Jordan tende wuye nap. ");
INSERT INTO kms_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ni chongo kamel iny pe yembe munduw kin te niraq wughe, di let kau chongo pe yembe mindig kin te apqe pe taq naimb. Ni quanj di gimeti nyoq ane ne. ");
INSERT INTO kms_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Di ni wand ren wute simbe nindiny, “Otiwo wuti iri nge nde dobu nawi kin ni ningg gre te nge gre ane tuqui segi, ni gre quan nganye. Nge wuti yuwon nganye segi, pugri bu nge ni ghav gidig di yimb kaghe ni su taq nimbiq kin sare te bure gad kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nge nungoqi wuye pene wuye kupuqu. Pudi otiwo ni nandi, tedi Ququ Yuwon Ye pe wuye nupuqu.” ");
INSERT INTO kms_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tende puayi Jisas ni Nasaret pu nandi. Nasaret te Galili opu yequ. Ni nandi wuye Jordan tende di Jon ni wuye naip. ");
INSERT INTO kms_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pre, Jisas ni wuye pe pu nowi ni ni rar nat, nginy tu bi viso, di God ningg Ququ wapi mabri kin pugri Jisas nde nati ni. ");
INSERT INTO kms_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Di wuti iri nginy tu wam pu nari, “Nu nge wo. Nge nu quan nganye yawo kiraw righe, di nu ningg quan nganye chumbuai gad.” ");
INSERT INTO kms_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jon ni Jisas wuye naip pre, di opu brequne God ningg Ququ ni Jisas tiqi nundog mong wuye di nyumo segi ye pe tende no. ");
INSERT INTO kms_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mong tende umo dabo kin yeru, Jisas tende nas nginy 40-pela pu nawo, di Satan ni wandoqi nindig ei Jisas God dob neng ningg. Di God ningg angelo ni mondo Jisas sabi mindig. ");
INSERT INTO kms_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","King Herot ni Jon taq naimb pre tende dobu Jisas ni Galili opu no, wand yuwon ye God nde pu vindi kin te bir nawo. ");
INSERT INTO kms_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ni pugri simbe nindiny nari, “Ngeri oghi ye muq tumo rind. Yumbo buagi God nde si nambu rise kin ngeri te tumo rind pre. Nungoqi nei ware witinde, God ningg wand yuwon kin te wutungu di umbo pe wawo vis.” ");
INSERT INTO kms_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas ni Galili wuye ngamo qunambe nyinge nare no no, di wute temi wuye ngamo pe yawi mi naghe di umo materi ri yemu nuqond. Wute men te wute umo meri mand ye, ni nyamb Saimon di kiqam Andru. ");
INSERT INTO kms_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas ni temi simbe nindim nari, “Nungoqi nge nde dobu wawi, di nge wute wateri ye te kin bei keuq. Asi nungoqi umo wateri, muq nungoqi wute wateri.” ");
INSERT INTO kms_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ni brequne yawi si mare di Jisas nde dobu maru. ");
INSERT INTO kms_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ni mune musoqne nyinge mare mondo, Sebedi ningg wo Jems di kiqam Jon temi nikin at pe yawi sabi mindim mindim yemu nuqond. ");
INSERT INTO kms_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ni brequne ngam niram, di kiyi wute yembe ye te ane si mare at pe tende mas di ni Jisas ane mo. ");
INSERT INTO kms_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ni mo tiqe ire Kaperneam puq munduw kin tende mo mar. Di brequne Sabat kin nginy te ningg ni God yumbui nyamb mirang kin baj pe mar mo, di Jisas ni God ningg wand te wute bei neny. ");
INSERT INTO kms_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wute buagi ni wand bei neny kin te rutungu, di nei kumo rimb. Te pugri ni gre ane wand simbe nand, di ni wute Moses ningg lo wute bei meny ye ni kin pugri segi. ");
INSERT INTO kms_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","God yumbui nyamb mirang kin baj pe tende wuti ququ brequ ninde nas kin iri ane tende nas. Muq Jisas wand simbe nand nandne wuti te nari, ");
INSERT INTO kms_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas Nasaret kin, nu guadi beghi pughe guegu ningg? Nge nu nei gubuw, nu God ningg wuti yuwon ye. Nu beghi brequ gudug ningg bri guadi? Beghi si ramu pas.” ");
INSERT INTO kms_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas oyi ququ brequ te simbe nindig nari, “Nu wand segi ghas wuti te si gheri gheyi yi yo.” ");
INSERT INTO kms_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ququ brequ ni wuti te puq neng di quan kumo buyaq nand, di ququ brequ te nari pre neyi ni no. ");
INSERT INTO kms_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wute buagi te ruqond, nei kumo rimb, bu ni kin kin wand rind riri, “Yumbo ren pughe bri? Ni wand urupui di gre ane kin bei nand. Di ni ququ brequ wand gre ye simbe nindim di ni wand irepene mutungu.” ");
INSERT INTO kms_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Di Jisas ni yumbo buagi puq nen kin wand te vir ir tiqe buagi Galili opu yeru kin te rutungu. ");
INSERT INTO kms_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tende dobu ni God yumbui nyamb mirang kin baj te si miraq, di Saimon Andru temi nde baj pe mo. Jems Jon temi ni anene mo. ");
INSERT INTO kms_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon ni kine te ghimbi sungue rupuw pu wuse, di ni Jisas simbe mindig nutungu. ");
INSERT INTO kms_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Di Jisas no, ni si nituw kuse, ghav nunduw wes wuyo di num opu brequne oghi, di ni mir wem me. ");
INSERT INTO kms_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tende puayine yuram nginy naghe no pu nase, wute num kin di ququ brequ ninde mas kin buagi Jisas nde mitari mandi. ");
INSERT INTO kms_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wute buagi tiqe tende kin rindi Saimon nde baj ngimrawu ne rikur, ");
INSERT INTO kms_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","di Jisas ni wute nganye buagi num isis rire kin te num puaq nindiny. Di ni ququ brequ nganye buagi anene bub nare mo. Di ququ brequ ni nei mamb Jisas te tughe, pugri bu ni wand ninge simbe mand kin te segi puq nindim. ");
INSERT INTO kms_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yambgriq burane, bur yengune Jisas nes newo, baj si nare di mong wute segi ye pe tende no, God temi wand. ");
INSERT INTO kms_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon di Jisas ni wute aye temi ire pu te ane Jisas meri miting miting mo mo ");
INSERT INTO kms_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","muqoind, di simbe mindig mari, “Wute buagi nu meri rutuw.” ");
INSERT INTO kms_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisas oyi simbe nindim nari, “Wandi, tiqe aye ven nde tumone yeru kin tende po, ei nge ninde anene wand bir kawo. Nge puate te ningg bu gadi.” ");
INSERT INTO kms_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Muq ni tiqe Galili opu yeru kin tende opu mo, God yumbui nyamb mirang kin baj manyi pe nar no, wand bir nawo di ququ brequ wute nde mas kin te puaq nand mo. ");
INSERT INTO kms_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wuti iri leprosi niraq kin ni nandi Jisas nde sungomyu gure nawo, di Jisas quan nganye pengu nindig nari, “Nu nge ghav gudigh yawo kurew, tedi nge ghav ndigh di nge ghimbi mune oghi rise.” ");
INSERT INTO kms_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas ni wuti te quan nganye yawo nitong, di si neq wundo, nait nase nari, “Nge nu sabi guduw ye. Nu muqdi oghi ghas!” ");
INSERT INTO kms_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Di opu brequne num leprosi te prene di mune oghi nas. ");
INSERT INTO kms_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Di Jisas ni wand ven yeri nindig pre tiqi nundog no. ");
INSERT INTO kms_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ni nari, “Nu yo wute aye yumbo ren kin ningg simbe ndiny wayequ. Pudi yo nunon ghimbi te prist nde bei ghand, di Moses ningg lo ni wute mai puaq mand ningg umo wase mande kin te ningg wuri kin pugrine puq yen. Nu puq yen ei prist ni te muqond di mari te nganyene nu num oghi pre.” ");
INSERT INTO kms_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pudi wuti te oyi no, raqene simbe simbe no, di wand te vir ir wute nganye buagi rutungu. Pugri bu Jisas ni munene tiqe ire pe raqene nar no tuqui segi, pudi ni dabo wute segi ye pe tende nas. Pudi wute tiqe isis kin ni Jisas nde rundo rundone. ");
INSERT INTO kms_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni nas nginy ninge pre tende dobu ni munene Kaperneam no. Di wute rutungu ni mune nambu nandi pre. ");
INSERT INTO kms_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wute nganye buagi ruso baj iri pe rikur di Jisas wand bir nawo. Ni baj te brene rind, di dabo ngimrawu te ane brene. ");
INSERT INTO kms_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Muq wute ninge wuti quangi rind kin iri Jisas nde meri mondo, di wute temi aye temi pu ni wuti te meri. ");
INSERT INTO kms_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pudi wute quan di sunyi bre bu ni wuti te Jisas nde tumo meri mondo ye tuqui segi. Pugri bu ni mewo mo baj wam gri gawo mamb di wuti nyinge nare tuqui segi kin te sunyi anene gawo pe gri mi naghe no. Ni gawo te Jisas yenu pe tuquine yembe munduw. ");
INSERT INTO kms_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ni nei mamb Jisas wuti te sabi nindig ye di Jisas ni nei te nundom pre, di ni wuti nyinge nare tuqui segi kin te ningg nari, “Mand, nu yumbo ur brequ guad kin wand te puaq pre.” ");
INSERT INTO kms_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wute Moses ningg lo wute bei meny ye ninge ni yumbo ren muqond di kin kin nei pe mari, ");
INSERT INTO kms_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pughe kin ningg wuti nen pugri wand nand? Ni God wand brequ nindig! Wuti iri yumbo ur brequ kin wand te puaq nand tuqui segi, pudi God irine ni puq nen tuqui.” ");
INSERT INTO kms_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pudi Jisas ni kin kin umbo pe pugri nei mamb kin te nei namb pre, pugri bu ni simbe nindim nari, “Nungoqi pughe kin ningg pugri nei wamb? ");
INSERT INTO kms_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wand pughe ye puq gad tedi wute riri te nganyene: Nge wuti nyinge nare tuqui segi ye te ningg kari, ‘Nu yumbo ur brequ guad kin wand te puaq pre,’ o nge kari, ‘Nu yes yewo, sunyi ghateri, di nyinge ghare yo?’ ");
INSERT INTO kms_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pudi puq ken ei nungoqi nei wamb te pugri wuti God nde pu nandi wuti nganye nas ye ni qi pe ven nde yumbo ur brequ kin wand puaq nand ye gre rise.” Muq ni wuti nyinge nare tuqui segi ye te ningg nari, ");
INSERT INTO kms_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nge kari nu yes yewo, nunon sunyi ghateri, ghare baj pe yo.” ");
INSERT INTO kms_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Muq wute buagi ruqoind ruqoindne nes newo, brequne sunyi nateri di nyinge nare neyi ni no. Wute buagi te ruqond, puyene rind, di God ningg nyamb rindivi viyo riri, “Asi beghi yumbo ur pugri ye buqod segi.” ");
INSERT INTO kms_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Muq Jisas ni munene Galili wuye ngamo opu tende no. Wute nganye buagi ninde rundo, di ni God ningg wand bei neny. ");
INSERT INTO kms_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ni nyinge nare no no di wuti iri Livai Alpius ningg wo, ni wute takis materi kin baj pe tende nas nuqoind, di simbe nindig nari, “Nu nge nde ghawi.” Muq Livai nes newo, Jisas nde dobu naru. ");
INSERT INTO kms_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Di dobu Jisas ni Livai nde baj pe no, Livai ane mir mand. Tende puayi wute takis materi kin di wute yumbo ur brequ rind kin nganye buagi Jisas di nikin wute ane tende ris mir rind. Te pugri wute te kin quan ni Jisas nde dobu ruru ye, pugri bu ni anene tende mir rind. ");
INSERT INTO kms_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parisi mingg wute Moses ningg lo wute bei meny ye ni Jisas wute takis materi ye di wute yumbo ur brequ rind kin ane mir rind kin te muqond, di Jisas ningg wute te pengu mindim, “Pughe kin ningg ni wute takis materi kin di yumbo ur brequ rind kin ane mir rind?” ");
INSERT INTO kms_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas ni wand ren nutungu di simbe nindim nari, “Wuti num gureg segi kin ni dokta nde no tuqui segi, wuti num gureg kinne ei dokta nde no. Te kin pugrine nge wute yumbo ur tuquine puq ren yene kateri ningg gadi segi, pudi wute yumbo ur brequ rind rind ris ye ni ningg bu gadi.” ");
INSERT INTO kms_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Muq Jon wute wuye nap kin ni ningg wute di Parisi ane ni mir uny yemu. Di wute ninge mandi, Jisas pengu mindig mari, “Pughe gri ate Jon ningg wute di Parisi mingg wute ane mir uny yemu, pudi nu wute ni mir uny yemu segi?” ");
INSERT INTO kms_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas oyi nand nari, “Wuti iri ngam no ningg mir yembe mindiny, di kimand ngam niram mandi ane mir mand. Di ni ane mir mand mand masne kin tende puayi ni kimand te mir uny yemu tuqui segi. Te pugri ni ane masne di ni chumbuai mand bu ni mir uny yemu tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pudi otiwo wute ninge mandi wuti ngam no kin mitanyi mo ye ngeri te rindi ye. Tende puayi di ni yivany mare di mir uny yemu. ");
INSERT INTO kms_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Wuti iri ni chongo bidi urupui ire nitaqwi, chongo wuri ire bir wus kin pe nuaq wuso rang nimbiq tuqui segi. Ni pugri puq nen, tedi otiwo ni wuye nipiq di chongo bidi urupui kin te wute rundo, di asi kin te mune bir wus di gawo quan nganye yumbui wuse. ");
INSERT INTO kms_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Di wuti iri ni wain urupui meme chongo yabe kin pe nowi naghe segi. Ni pugri puq nen, tedi wain urupui te yindingi, di meme chongo yabe kin te bir nuaq, di ni teri ane brequ rise. Ni wain urupui meme chongo urupui pene nowi naghe tedi oghi.” ");
INSERT INTO kms_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat kin nginy iri ningg Jisas nikin wute ane wit wuny mingine nyinge mare mo. Ni mo mo Jisas nikin wute ni mir kurem, bu ni wit yi ninge map me me nyinge mare. ");
INSERT INTO kms_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Muq Parisi ni Jisas simbe mindig mari, “Muq nginy nen te Sabat kin nginy, pudi nu wute ni wit yi map me. Lo ni beghi yembe bad kin te ningg segi puq wund.” ");
INSERT INTO kms_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jisas oyi nari, “Devit nikin wute ane mir kurem, mir segi, di ni God ningg baj pe nar no, bret God meng ningg mawo ris kin te nateri ne, di nikin wute ninge nem me. Bret ren kin te pristne me kin, wute aye me kin te lo segi puq wund. Tende puayi Abiatar ni prist mingg yumbui mingg yumbui ningg nas. Nungoqi wand ren buk pe wuqond segi bri?” ");
INSERT INTO kms_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Muq ni wand aye ren mune simbe nindim, “God ni wute Sabat kin lo te rit rise sabi rindiny di Sabat yuwonne wuse ningg wute yembe nindiny segi. Pudi ni wute asine yembe nindiny pre muq Sabat kin nginy te naip no, ei tende puayi ni waghine ris di God nei rimbig. ");
INSERT INTO kms_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pugri bu wuti God nde pu nandi wuti nganye nas kin ni Sabat kin puate.” ");
INSERT INTO kms_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Muq Jisas ni munene God yumbui nyamb mirang kin baj pe nar no. Di wuti iri si kuti kin tende nas nuqoind. ");
INSERT INTO kms_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wute ninge ni Jisas kotim maind ningg ngim meri mand ye, pugri bu ni waghine Jisas yeng muang pu yemu. Ni yeng muang ei muqond muq Sabat kin nginy nen ningg ni wuti si kuti kin te sabi nindig oghi, tedi te ningg kotim maind ningg. ");
INSERT INTO kms_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Muq Jisas ni wuti si brequ kin te simbe nindig nari, “Nu ren ghandi wute buagi nde rar pe yeru.” ");
INSERT INTO kms_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Di Jisas wute te pengu nindim nari, “Sabat kin lo pughe puq wund? Wute ghav bidiny yuwon pu ris, o wute unje pap? Wute ghav bidiny ei ris o wute bab riti?” Jisas ni pugri pengu nindim, pudi ni wand segine mas. ");
INSERT INTO kms_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas ni wute te ker ane nuqond nuqond, di ni God nei mimbig segi kin te ningg umbo mai riwo. Muq ni wuti si brequ ye te ningg nari, “Nu si tuqu kuso.” Muq wuti te ni si nituqu kuso di opu oghi. ");
INSERT INTO kms_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pugri bu Parisi ni God yumbui nyamb mirang kin baj te si miraq di meyi mi mo, wute Herot nde opu mase ye ninge ane mikur, Jisas mi nati ningg wand wand mare. ");
INSERT INTO kms_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Muq Jisas nikin wute ane tiqe te si miraq, di Galili wuye ngamo pe tende mo. Di wute nganye buagi Galili opu kin ni ruru. ");
INSERT INTO kms_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Di wute buagi Judia kin, Jerusalem kin, Idumea kin, Jordan opu gri kin, di Tair di Saidon opu kin ni buagi ane Jisas yumbo yembe nindiny kin wand rutungu di Jisas nde rundo. ");
INSERT INTO kms_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wute nganye buagi nganye rundo, bu Jisas nikin wute te simbe nindim di ni bot woju ire miraq mandi, di ni tende newo no ei wute rindi ni imb rip tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ni wute num kin nganye buagi nganye sabi nindiny, pugri bu wute num kin buagi ni Jisas rit nase ningg buid rip. ");
INSERT INTO kms_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ququ brequ wute nde yemu ye ni Jisas muqoind, di ni Jisas nde rar pene pombri mo mase di quan kumo mari, “Nu God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pudi Jisas ni quan nganye segi puq nindim ei ni God ningg wo te kin ningg wute aye simbe mindiny segi. ");
INSERT INTO kms_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Muq Jisas ni rand pe newo no, di wute ninde maru ningg nari kin te ngam niram mondo. ");
INSERT INTO kms_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Di ni wute te nikin wute 12-pela ningg nap mo di aposel puq nindim, ei wute te ni ane nyinge mare di otiwo ni tiqi nundom mo wand bir mawo. ");
INSERT INTO kms_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Di ni gre nem ei ni ququ brequ bub mare mo kin tuqui. ");
INSERT INTO kms_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ni wute 12-pela pu nap mo kin taq men: Saimon, di ni nyamb aye te Pita puq nindig. ");
INSERT INTO kms_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems, Sebedi ningg wo, di ni kiqam Jon, ni nyamb aye nem kin te Boanerges. (Nyamb ven ni puate te “Kimereg kin pugri.”) ");
INSERT INTO kms_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Di Andru, Pilip, Bartolomyu, Matyu, Tomas, Jems Alpius ningg wo, Tadius, Saimon ni Selot ningg wute tit kin iri, ");
INSERT INTO kms_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","di Judas Iskariot, wuti Jisas veri nde si pe ni nondo kin te. ");
INSERT INTO kms_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Muq Jisas ni baj iri pe nar no, di mune pugrine wute nganye buagi rindi rikur, di Jisas nikin wute ane mir mand ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nikin yavi ire ni wand buagi te rutungu pugri bu ni riri ni jebo nand di ni ruso ritanyi nikin baj pe ruso ningg. ");
INSERT INTO kms_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Di wute Moses ningg lo wute bei meny kin Jerusalem pu mandi ye ni mari, “Belsebul ninde nas. Ni Belsebul, ququ brequ mingg yumbui, ni ningg gre pe ququ brequ puaq nand mo.” ");
INSERT INTO kms_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pugri bu Jisas ni ngam niram mondo, di kopuqu wand pe simbe nindim nari, “Pughe gri ei Satan ni nes newo nikin ququne bub nare mo? ");
INSERT INTO kms_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tiqe ire bir mawo kin kin mege, tedi tiqe te yequ tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wute baj ire pe kin ni bir ruwo opu opu yeru, tedi ni yuwonne ris tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Di Satan nikin ququ bir mawo opu opu yemu kinne mari, tedi ni yuwonne mas segi, di ni gre te prene. ");
INSERT INTO kms_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wuti iri ni wuti aye iri gre quan rise kin ni baj bir nuang nar no yumbo nateri tuqui segi. Ni wuti gre quan rise kin te taq naimb pre, tedi ni baj bir nawo nar no yumbo sir nateri. ");
INSERT INTO kms_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nge nungoqi nganyene simbe guduq. Te pugri wute yumbo ur brequ mand di wand brequ mand kin mai te puaq ye tuqui. ");
INSERT INTO kms_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pudi wuti iri Ququ Yuwon Ye wand brequ nindig ye ni wand te puaq segi ye, wuti te ni yumbo ur brequ te kin ningg wand ninde vise vise te kin vise.” ");
INSERT INTO kms_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas ni pugri puq nand kin puate te pugri, wute te ni mari, “Jisas ni ququ brequ ninde nas.” ");
INSERT INTO kms_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Muq Jisas ni kumo di kiqam ane Jisas ruqoind ningg rindi pu baj sange pe yeru, di wuti iri tiqi rundog nar no Jisas simbe nindig ei no ni nuqond. ");
INSERT INTO kms_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Di wute buagi ninde ris ris rundo rindi kin ni simbe rindig riri, “Nu numo di niqam ane nu meri rutuw rindi pu dabo te yeru.” ");
INSERT INTO kms_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Di Jisas oyi pengu nand nari, “Tughe nge moyu di nge qam?” ");
INSERT INTO kms_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Muq wute ninde ris ris rundo rindi kin te rar neq wundo nuqond di nari, “Wute ren nge moyu di nge qam. ");
INSERT INTO kms_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wute tughe God nari kin pugrine puq ren ye ni nge qam di nge nyumbu di nge moyu.” ");
INSERT INTO kms_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas ni mune Galili wuye ngamo yumbui tende opu wand wute bei neny. Ni yenu wand bei neny kin pe tende bot ire yequ. Di wute nganye buagi nganye rundo rikur ni quir quar rindig, pugri bu ni bot pe newo no nas, di wute buagi ni dabo jiji pe yeru, muq ni wand simbe nand. ");
INSERT INTO kms_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Muq ni wand nganye buagi te kopuqu wand pene bei neny. Di tende puayi ni wand ire simbe nindiny kin te nari, ");
INSERT INTO kms_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nungoqi wutungu! Wuti iri nikin wuny mbe no di wit yi puraq nand. ");
INSERT INTO kms_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ni puraq nand nand di mir yi ninge ngimne ir ri, di wapi rindi riq. ");
INSERT INTO kms_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ninge qi wet kin pe ir ri. Tende qi quan wus segi bu ni wamne ris, pugri bu ni brequne ruwi, ");
INSERT INTO kms_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","pudi nginy nawi, wit te nande namb di quari rimb. Te pugri ni tumuri quan maghe mo segi. ");
INSERT INTO kms_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mir yi ninge ruso nyungo quat kin pe ir ri di nyungo quat kin ni nambu wi ruso di ni yi riyi segi. ");
INSERT INTO kms_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Di ninge qi oghi ye pe ir ri. Ni oghine ruwi di yi quan nganye riyi, puate ninge ni yi 30-pela, ninge 60-pela di ninge 100-pela.” ");
INSERT INTO kms_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas ni kopuqu wand ven simbe nand pre di mune nari, “Wuti iri ni nutungu kin tuqui tedi ange nuaq ei wand ren nutungu.” ");
INSERT INTO kms_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wute buagi rundo rikur Jisas wand bei neny kin te rutungu ye te ruso pre, di Jisas ni irine nikin wute 12-pela ane mas. Muq nikin wute di wute aye ni ane mas kin ni kopuqu wand puate te ningg Jisas pengu mindig. ");
INSERT INTO kms_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Di ni simbe nindim nari, “Yumbo yumbo buagi God nde si nambu rise kin wand suqo pu rise kin te God nungoqi nei neuq di nungoqi nei wumbiny tuqui. Nge kopuqu wand pe simbe gad ei wute wand nganyene kin rutungu yambu riri ye ni wandne rutungu pudi puate nei rimb segi. ");
INSERT INTO kms_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Te ei ni rar rit rit pudi ruqond tuqui segi, ni ange ruaq rutungu pudi nei rimb segi. Eti ni nei rimb di God ningg ngim pe nyinge rire di God ni mai puaq nindiny.” ");
INSERT INTO kms_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Muq Jisas ni simbe nindim, “Nungoqi kopuqu wand ven puate nei wamb segi bri? Tedi pughe gri ei nungoqi kopuqu wand aye te ni puate nei wumbiny? Ni puate taq pugri. ");
INSERT INTO kms_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mir yi wuny mbe puraq nand kin te God ningg wand. ");
INSERT INTO kms_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wute ninge ni God ningg wand riteri kin te ni ngim kin pugri mir yi ninde ir ri. Ni God ningg wand rutungu pre, di brequne Satan nandi wand ninde pu natevi nare no. ");
INSERT INTO kms_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wute ninge ni qi wet kin pugri mir yi ninde ir ri. Ni brequne chumbuai ane wand te ritevi. ");
INSERT INTO kms_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pudi ni tumuri quan maghe mo segi kin pugri, ni wand te kin nei pe ruwo vis nganye segi. Ni God ningg wand rutungu, pudi wute ninge wand te ningg brequ mindiny ningg mai isis meny kin tende puayi ni brequne ir righe. ");
INSERT INTO kms_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wit yi ninge nyungo quat kin pe ir righe kin te wute ninge wand rutungu kin pugri, ");
INSERT INTO kms_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yumbo qi pe kin ningg yivany rirany, di yumbo quan rise ningg riri, di yumbo aye mune riteri yawo kureny kin nei te rindi. Yumbo ren ni nei imb ruany bu God ningg wand ni nde mir rire segi. ");
INSERT INTO kms_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pudi wit yi qi oghi ye pe ir ri kin te wute wand rutungu, umbo pe ruwo vis di mir quan rire, ninge ni yi 30-pela, ninge 60-pela, di ninge 100-pela kin pugri.” ");
INSERT INTO kms_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas ni wand aye mune simbe nindim nari, “Wuti iri lam niraq nandi os pe but niraq o ede nambu neq wur ye bri? Yewo, ni puq nen segi, pudi ni lam te nikin wus kin sunyi pe raqene nuaq wus di ti nase. ");
INSERT INTO kms_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Te pugri yumbo suqo pu rise ye te otiwo raqe ei ruso wute buagi nei rimb, di yumbo but pu rise kin te otiwo raqene ei rise. ");
INSERT INTO kms_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wuti iri ni wand nutungu kin tuqui tedi ni ange nuaq ei wand ren nutungu.” ");
INSERT INTO kms_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ni mune simbe nindim nari, “Nungoqi wand wutungu kin te oghine nei wumbiny. Nungoqi pughe gri wute aye yumbo ur brequ rind kin te ningg simbe wundiny pu, tedi God oyi mune nungoqi pugrine simbe nunduq, di nungoqi mune quan nganye. ");
INSERT INTO kms_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Te pugri wuti God ningg wand asi nutungu kin nat vise ye te otiwo God ni aye neng, pudi wuti God ningg wand nutungu kin te menare viso, tedi God ni wuti tende wand puch nganye vise kin te mune natevi.” ");
INSERT INTO kms_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas ni kopuqu wand aye mune simbe nand nari, “Yumbo buagi God nde si nambu rise kin te wuti mir yi puraq nand kin pugri. ");
INSERT INTO kms_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Burpoq di yambgriq ni ruqo nase o nes pu nas, mir yi te ruwi di yumbui ruso pudi ni pughe gri puq ren kin te ni nei namb segi. ");
INSERT INTO kms_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ni nikinne qi pe pu ruwi, ni riwo ruso raqe rimb, kis rimb di yi riyi. ");
INSERT INTO kms_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mir yi nguan kin tende puayi wuti te ni mame bidi neti nowi, no mir di nawo, te pugri mir bi nawo kin ngeri te rindi pre.” ");
INSERT INTO kms_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Muq Jisas wand aye mune simbe nand ningg di ni nari, “Wute God nde si nambu ris kin te ningg pughe puq ei bad? Kopuqu wand pughe ye ei te ane tuqui? ");
INSERT INTO kms_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wute God nde si nambu ris kin te mastet yi kin pugri. Mastet yi te wokuandi nganye nyumo yi buagi aye nungoqi kuan wawo kin ni ane tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pudi otiwo mi righe pre, di ni ruwi kin ni minye ninge wuny mbe mi righe kin ane tuqui segi, ni quan nganye yumbui, ni nyumo kin pugri. Ni muange te yumbui di wapi rindi nyumo tende nambu rir ris kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas ni pripri kopuqu wand ren kin wute rutungu nei rimbiny kin tuqui ye tende pene God ningg wand simbe nand. ");
INSERT INTO kms_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni wand ire raqene simbe nand segi, ni pripri kopuqu wand pene simbe nand. Pudi ni nikinne nikin wute ane mas kin tende puayi ni mune kopuqu wand buagi te nitari riti. ");
INSERT INTO kms_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nginy te ninggne yuram Jisas ni nikin wute te simbe nindim nari, “Wandi wuye ngamo pe ruso ruwo opu gri tende po.” ");
INSERT INTO kms_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Muq ni wute buagi te si mare yeru, di Jisas ni bot pe pugrine nas di opu gri mo ningg. Tende puayine bot aye ninge anene ruso. ");
INSERT INTO kms_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ni mo mo nyumurighi yumbui naghe di wuye seme gub bot pe kuyo kughe di bre ningg tumo. ");
INSERT INTO kms_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ni bot dobu gri tende ngawu pilo pe ninjeny di ruqo pu nase. Di nikin wute mondo buraq mindig di simbe mindig mari, “Tisa, nu beghi wuye pe paghe po ningg bri kuari?” ");
INSERT INTO kms_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Muq Jisas nes newo nyumurighi te simbe nindig nari, “Nu muq prene!” Di wuye bir bir gudi kin te ningg nari, “Nu waghine ghase!” Di nyumurighi naghe kin te pre di wuye mune waghine kuse. ");
INSERT INTO kms_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Muq nikin wute te simbe nindim nari, “Nungoqi pughe ningg wune wamb? Nungoqi God nei wumbig segi bri?” ");
INSERT INTO kms_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ni te muqond wune mamb di oyi oyi pengu mand mari, “Wuti nen tughe? Nyumurighi di wuye ane ni wand simbe nand kin te irepene rutungu!” ");
INSERT INTO kms_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ni wuye ngamo misiq opu gri mo di Gerasa mingg qi puch pe tende mo mar. ");
INSERT INTO kms_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas ni bot pe pu nati ni, jiji pe newo no pune wuti iri matmat pe pu Jisas nde nandi. Wuti nen te ququ brequ ninde yemu. ");
INSERT INTO kms_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ni matmat pe nase, di wute mait nase taq maimb ye tuqui segi. Piyi ni sen pe taq maimb ningg pudi tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Te pugri ni pripri mait nase nyinge si ane sen pe taq mimbig, pudi ni sen te wurigh namb pend, di ain nyinge ap muang pu rise kin te paqe nawo. Ni quan nganye gre nand di wuti iri ni segi puq nindig tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Burpoq di bogisumb ni matmat di rand pe tende nari, di wet nateri nikin ghimbine pend nawo nawo nas. ");
INSERT INTO kms_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wuti te ni wonjine yenu, rar neq wundi Jisas nuqoind, di vig namb nandi Jisas nde rar ngimine sungomyu gure nawo. ");
INSERT INTO kms_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Di ni quan kumone nari, “Jisas, God wam nganye nas kin wo, nu nge pughe sin kuegh ningg? God nde nyamb pe nge unje ghaip segi ningg wand gre yeny.” ");
INSERT INTO kms_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Te pugri Jisas ni asine nari, “Ququ brequ, nu wuti nen nde pu gheyi yi.” ");
INSERT INTO kms_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Muq Jisas ni pengu nindig nari, “Nu nyamb pughene?” Di wuti te oyi nand nari, “Nge nyamb te Ami, te pugri beghi quan pas.” ");
INSERT INTO kms_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Di ni Jisas pengu nindig nindig ei Jisas ni bub nare aye pe mo segi. ");
INSERT INTO kms_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ni yemu pe tende tumone te rand woju iri yenu, di pu quan rand qunambe tende mir rind rind yeru. ");
INSERT INTO kms_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Di ququ brequ wuti tende mar mas kin ni Jisas ningg mari, “Nu beghi pu pe tende tiqi ndog po, nu beghi rar ndomu pu pe tende par po.” ");
INSERT INTO kms_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas ni ngiq nindim di ni wuti te si meri meyi mi mo, pu pe mar mo. Pu tit te tausen teri kin pugri, di ni buagi ane vig rimb rand wari pe te righe ruso, di wuye ngamo pe ir righe, wuye riq di riti. ");
INSERT INTO kms_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wute pu yeng muany kin ni te muqond, di vig mamb mo tiqe yumbui di tiqe wo aye pe tende mo, yumbo ren kin ningg simbe mand. Di wute buagi ruso yumbo te ruqond ningg. ");
INSERT INTO kms_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ni ruso Jisas nde ritari righe, di ni wuti ququ brequ nganye buagi ninde mar mas kin te nas ruqoind. Ni nei mune yuwon rise di chongo nare righe pu nas ruqoind. Ni quan nganye wune rimb. ");
INSERT INTO kms_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wute yumbo te ruqond kin ni wuti ququ brequ buagi ninde mas kin ni pughe sin reng kin te ningg simbe rind. Di pu ningg anene simbe rind. ");
INSERT INTO kms_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Di ni Jisas ni mong puch ni ris kin opu te si nare ningg simbe rindig di quan nganye buid rip. ");
INSERT INTO kms_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisas ni bot pe newo no, di wuti ququ brequ buagi ninde mas pudi muq oghi kin te ane no ningg nari. ");
INSERT INTO kms_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisas ni wuti te ngiq nindig ane no segi, pudi simbe nindig nari, “Nu nunon tiqe yo, di nunon yavi ire te Yumbui ni yembe yumbui nganye nand di nu pughe gri yawo nitow kin te simbe ndiny.” ");
INSERT INTO kms_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Muq wuti te no di tiqe yumbui 10-pela Jordan pu nginy nawi opu yeru kin tende no, di Jisas ni pughe gri ghav nindig kin te ningg simbe nand. Di wute buagi ni puyene rind. ");
INSERT INTO kms_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas ni munene bot pe newo no, wuye ngamo te nisiq opu gri no, di wute nganye buagi rundo rikur. Ni wuye ngamo qunambe tende opune yenu, ");
INSERT INTO kms_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","di wuti iri nondo. Wuti te ni nyamb Jairus ni God yumbui nyamb mirang kin baj te kin ye quayi kiyi iri. Ni Jisas nuqoind, di nondo Jisas nde nyinge tingi sungomyu gre nawo nase, ");
INSERT INTO kms_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","di nari, “Nge wo num kurew, wuti ningg tumo. Nu ghandi, nge wo si yew kuyo ei ni num oghi di wus.” ");
INSERT INTO kms_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Di Jisas nondo temi mo. Wute nganye buagi Jisas nde dobu ruru, di yeru yeru rundo rindi. ");
INSERT INTO kms_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Di nyumbueg ire ni asine uny chiraq yequ ruso ber 12-pela pu wuwo kin ni anene tende yequ. ");
INSERT INTO kms_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ni dokta nganye buagi nganye mandi sabi munduw di ni dokta puq mew kin te ningg mai quan wure. Ni wet bidi buagi mewure ruso omo wuwo, ni mune oghi segi pudi ni quan nganye puq rew. ");
INSERT INTO kms_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ni wute Jisas ningg simbe rind kin te wutungu, di Jisas nde dobu gri wuwi. Ni wute buagi aye tende mingi wuru di ni nei wumb kin wuri, “Nge ni chongone kiting rise, tedi nge oghi.” Ni pugri nei wumb di si weq wundo Jisas chongo te wut rise. ");
INSERT INTO kms_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ni pugri puq wen di opu brequne ni uny te prene, di ghimbi pe wutungu kin te ni mai te muq yuwon pre. ");
INSERT INTO kms_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Di tende puayine Jisas ni nutungu kin te gre ninge ninde pu riyi ri. Ni tindi nandi di pengu nand, “Tughe nge chongo nat rise?” ");
INSERT INTO kms_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Di nikin wute oyi mari, “Wute nganye buagi nganye ruwi tumo yeru kin te guqod o segi? Pughe ningg wute nu chongo rit rise kin te ningg pengu guad?” ");
INSERT INTO kms_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pudi Jisas ni wute pughe ye ni chongo wuting rise kin te nundoq ningg rar nat natne. ");
INSERT INTO kms_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Muq nyumbueg te ninde yumbo pughe sin ren kin te nei wumb, di wune ane wuso Jisas nde nyinge tingi pombri wuso buyaq buyaq wuse, di ni pughe sin rew kin te simbe wund. Ni wand ninge suqo wure segi. ");
INSERT INTO kms_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Di Jisas ni simbe nunduw nari, “Nge wo, nu nonne nei guab kuari nu nge chongo kuat rise di nu oghi ye puq guad kin te ningg bu nu oghi. Nu umbo yuwon pu kuse di yo, nu mai kuraq kin te muq prene.” ");
INSERT INTO kms_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas ni wand nand nandne yenu wute ninge Jairus, wuti God yumbui nyamb mirang ye baj kin quayi kiyi iri, ninde baj pe pu mandi di mari, “Nu wo wuti pre. Tisa segi tanyi yo wayequ.” ");
INSERT INTO kms_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pudi ni wand wandne yemu Jisas ni wand pend nuam di Jairus ningg nari, “Nu wune ghamb wayequ. God ne nei mbig gre.” ");
INSERT INTO kms_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jisas ni wute aye te si nare yeru, di ni Pita, Jems di Jems ni kiqam Jon pugri pune natemi, ni ane mo. Ni wute buagi aye ruso kin te ningg ni segi puq nand. ");
INSERT INTO kms_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ni mo Jairus nde baj pe mitari righe, di Jisas nuqond wute buagi ruso rikur quan kumo quanji rind di riri riri nyuw rip. ");
INSERT INTO kms_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ni nar no di simbe nindiny nari, “Nungoqi pughe kin ningg quanji wand nyuw wap? Wo wen wuti segi, ni ruqo wuse.” ");
INSERT INTO kms_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jisas ni pugri simbe nindiny, pudi ni oyi Jisas wur ring. Muq Jisas ni tiqi nundony riyi ri ruso pre, di wo kiyi, wo kumo di nikin wute temi ire pu ni ane mo kin tene nateri di wokuandi wuse kin sunyi pe tende rir ruso. ");
INSERT INTO kms_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisas ni si nituw kuse, nitaqwi di nari, “Talita kum.” (Wand ven ni puate te pugri, “Nyumbueg wo! Nge nu ningg kari yes yewo.”) ");
INSERT INTO kms_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Muq wo te opu wes wiyo di nyinge wure wuso wundi. Nyumbueg wo te ber 12-pela kin pugri. Wute buagi ni te ruqond di puyene rind. ");
INSERT INTO kms_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas ni simbe nindiny ei ni puq nen kin te ningg wute aye simbe rindiny segi, di simbe nindiny ei wo te mir ninge rew wuq. ");
INSERT INTO kms_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas ni Jairus nde baj pe pu neyi ni nikin tiqe no. Di nikin wute ni anene mo. ");
INSERT INTO kms_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat kin nginy te ningg ni God yumbui nyamb mirang kin baj pe tende wand bei neny. Wute nganye buagi rindi Jisas wand nand kin te rutungu puyene rind di kin kin pengu rind riri, “Wuti nen ni wand di nei yuwon kin ren muai pu nateri? Wuti tughe ni yumbo ren bei nindig di ni yumbo ur gre ye yembe nindiny? ");
INSERT INTO kms_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kapenta tene bri nen? Wuti nen Maria ningg wo, di Jems, Joses, Judas di Saimon ni kise bri? Di ni kunyumbu ni beghi ane ren pas.” Di ni Jisas yambu rireng. ");
INSERT INTO kms_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Di Jisas ni simbe nindiny nari, “Propet iri nikin tiqe pene, nikin yavi ire di nikin nde baj pene wute ni nyamb rindivi viyo segi. Wute buagi aye ni nyamb rindivi viyo.” ");
INSERT INTO kms_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Di Jisas ni yumbo ur gre kin ninge yembe nindiny tuqui segi, pudi wute num kinne ire ire si neny riwo di ni num oghi. ");
INSERT INTO kms_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Di Jisas ni wute nikin tiqe pe kin ni God nei rimbig segi kin te ningg puye nand. Muq Jisas ni tiqe woju tende tumone yeru kin tende nar ir wand bei neny neny. ");
INSERT INTO kms_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Di ni nikin wute 12-pela pu te nari mondo, ququ brequ puaq mand kin gre nem di temi temi tiqi nundom mo. ");
INSERT INTO kms_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni mo segine di Jisas ni yeri nindim nari, “Nungoqi nyinge ware wo kin tende yumbo ninge ware wo wayequ. Nungoqi mir tami yumbo sir wi rise kin di wet bidi te kin ware wayequ, omone nganye ei wo. Di botune ei ware. ");
INSERT INTO kms_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nungoqi sune ei wate riwo pudi chongo aye ware wayequ. ");
INSERT INTO kms_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nungoqi baj ire pe wo tedi baj te ninggne ei was was otiwo tiqe te si wuraq di tiqe aye pe wo. ");
INSERT INTO kms_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Di nungoqi tiqe ire pe wo muq wute tiqe te kin nungoqi mitaqu wowi segi, di nungoqi ningg wand mutungu yambu mari, tedi nungoqi tiqe te si wuraq kin tende puayi nyinge pe kin qusuqu te buraq wand. Nungoqi puq wen ei wute tiqe te kin ruqond ei nei rimb ni nungoqi ritaqu wowi segi kin te ningg ni yumbo ur brequ rind pre.” ");
INSERT INTO kms_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Muq ni mo wand bir mawo ei wute nei rire ritinde. ");
INSERT INTO kms_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ni ququ brequ nganye buagi wute nde yemu kin te puaq mand di wute num kin nganye buagi wel nyang mimbiny di ni num oghi. ");
INSERT INTO kms_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jisas ni nyamb yumbui vise di wute buagi nei rimb. Wute ninge riri, “Jon wute wuye nap kin ni nati pre mune nes newo, pugri bu yumbo ur gre ye yembe nindiny kin gre ninde rise.” Di Herot ni te nutungu. ");
INSERT INTO kms_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ninge riri, “Ni Elaija.” Di ninge riri, “Ni propet iri,” puq rind rindne, di riri ni propet asi nganye mandi kin pugri ye iri. ");
INSERT INTO kms_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pudi Herot ni wand ven nutungu di ni nari, “Te Jon wuti nge kari gibe di muang kin ni mune nes newo pre!” ");
INSERT INTO kms_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Te pugri Herot asine Herodias nitaqi. Herodias te Herot ni kiqam Pilip ni ngam, di Herot ni puaq nindiq nitaqi. Di Jon ni te kin ningg Herot simbe nindig nari, “Nu niqam ningg ngam kutaqi kin te lo ni te kin ningg segi puq wund.” Di te kin ningg Herot nari Jon mait nase di taq maimb pu yenu. ");
INSERT INTO kms_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Di Herodias ni Jon wand simbe nand kin te ningg umbo ker wuwo di wi nati ningg. Pudi ni Jon wi nati kin tuqui segi, ");
INSERT INTO kms_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","te pugri Herot ni nei namb Jon ni yumbo ur tuquine puq nen di ni wuti yuwon nganye, pugri bu Herot ni Jon wune nimbig di nari mi nati segi. Herot ni Jon wand nand nutungu kin te ningg ni nei mai viyo, pudi ni wand nutungu yawo gureg. ");
INSERT INTO kms_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias ni asi Jon wi nati ningg wuri kin te muq ni ngim wuse. Di ren kin te pugri: Herot ni asi kumo wuri wundi ye nginy te muq nandi pre, di tende puayi Herot ni nikin te wute nyamb kin di ami mingg yumbui di wute nyamb kin aye Galili opu kin te ni mar ane mir mand. ");
INSERT INTO kms_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Di ni mir mand mand mas kin tende puayi Herodias ni wonyumbu wuso ni mir mand mand mas kin pe tende yuwo nyinge wuwo di Herot di wute ni ane mir mand kin ni quan nganye chumbuai mand. Di Herot ni nyumbueg wo te ningg nari, “Nu yumbo pughe kin kuateri yawo kurew kin te nge pengu ndigh, tedi nge nu kew ye.” ");
INSERT INTO kms_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Di ni God nde nyamb pe wand te gre neny di nari, “Piyi nu yumbo buagi nge nde si nambu rise kin te nu cham kuateri ningg kuari, te nge nu kew ye.” ");
INSERT INTO kms_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Muq nyumbueg wo te wuso di kumo pengu wunduw, “Nge yumbo pughe ningg ei kari?” Di kumo wuri, “Nu yo ghari ‘Jon wute wuye nap ye ni ngawu ei di ghowi nge yegh’.” ");
INSERT INTO kms_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Muq nyumbueg wo te brequne king nde wuso di wuri, “Nu muqne ei Jon wute wuye nap ye ni ngawu nyeng pe ghowi naghe pre yegh.” ");
INSERT INTO kms_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King ninde nei pe yuwon rind segi pudi ni asine wute ni ane mir rind kin ninde rar pe wand gre neny pre pugri bu muq ni segi puq nand ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Di king ni soldia king baj yeng muang pu yemu ye te iri wand yeri nindig pre tiqi nundog no ei Jon ngawu neri nandi. Di wuti te no Jon taq pune yenu ngawu di nuang, ");
INSERT INTO kms_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nyeng pe nowi naghe pre neri nandi. Ni neri nandi nyumbueg wo te new di ni wuti nowi kumo wew. ");
INSERT INTO kms_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon nikin wute ni te mutungu di mandi Jon meti nowi meri mo ngamo pe mowi yenu. ");
INSERT INTO kms_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas nikin aposel tiqi nundom mo kin te mune mandi di Jisas meng kur mondo mandi pu mas di ni mo yumbo buagi puq men kin te Jisas simbe mindig. ");
INSERT INTO kms_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Di wute nganye buagi ni Jisas nde mandi di mo, pugri bu Jisas nikin wute ane mir mand kin tuqui segi. Di Jisas nikin wute te simbe nindim nari, “Nungoqi ne waghine wandi nge ane mong wute segi ye pe po ei waghine pas yawotuan.” ");
INSERT INTO kms_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Muq ni nikin bot pe mewo mo di mong wute segi ye pe tende mo. ");
INSERT INTO kms_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pudi wute nganye buagi tiqe buagi kin ni bot pe mo kin te ruqond. Di ni bot te rundoq ripiq wuso di nei rimb te Jisas nikin wute ane. Di wute buagi ni nyinge pene vig rimb sunyi ni mo kin pe tende ye ruwo rinde pu ris. ");
INSERT INTO kms_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas ni nikin wute ane mo mitari righe di wute nganye buagi nganye ris muqond. Di Jisas ni yawo nitony, te pugri ni sipsip wuti sipsip yeng nuany ye segi nikinne yeru kin pugri yeru. Pugri bu ni wand nganye buagi nganye bei neny. ");
INSERT INTO kms_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pudi nginy te yuram bur pre pugri bu Jisas nikin wute mondo Jisas ningg mari, “Mong ven nde opu te wute segi, di muq yuram bur nganye. ");
INSERT INTO kms_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wute ren tiqi ndony ruso, ei te rundo tiqe ninge tumone pugri yeru kin pe tende rundo mir wong rind riq.” ");
INSERT INTO kms_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pudi Jisas oyi nand nari, “Nungoqi ei mir weny riq.” Di ni mari, “Wute ren quan nganye bu wuti iri yembe nand ruso irew 8-pela pre di wet bidi te irepene nawo righe, tedi wute buagi ren ningg bret wong nand neny riq tuqui. Nu kuari beghi wet bidi pugri pu ei mepare ruso di bret wong bad wute ren peny?” ");
INSERT INTO kms_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Di Jisas nari, “Nungoqi bret pughe gri pu rise? Wo wuqond.” Ni mo di bret 5-pela pu di umo teri ane rise muqond di mandi Jisas simbe mindig mari, “Bret 5-pela pu di umo teri.” ");
INSERT INTO kms_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Di Jisas ni simbe nindim mo wute te simbe mindiny nyungo pe tende ris. ");
INSERT INTO kms_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Muq ni kin kin ris, ninge 100 di ninge 50, te te ris ris ruso. ");
INSERT INTO kms_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jisas ni bret 5-pela pu umo teri ane nateri, wam rar neq wiyo, God chumbuai nindig pre di bret te bir nawo. Muq nikin wute te nem mare mo wute buagi meny. Di umo teri te mune pugrine bir nawo nem mare mo wute buagi te meny. ");
INSERT INTO kms_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Di ni buagi ane mir rind ruso ruso mir rimbiq. ");
INSERT INTO kms_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Di Jisas nikin wute ni mo bret di umo cham te materi imbi pe mawo righe ruso imbi 12-pela pu bre mand. ");
INSERT INTO kms_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wute buagi ane mir rind ye te manyi mand kin te quayine ni 5 tausen kin pugri. ");
INSERT INTO kms_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ni mir rind prene di opu Jisas nikin wute simbe nindim at pe mewo mo di ye mawo Betsaida mo, di Jisas ni tene yenu wute buagi te tiqi nundony nikin tiqe ruso. ");
INSERT INTO kms_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jisas ni tiqi nundony ruso pre, di ni rand pe newo no ei God temi wand ningg. ");
INSERT INTO kms_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bur ir kui kin tende puayi Jisas nikin wute ni wuye ngamo mingi yemu pre, di Jisas irine dabone yenu. ");
INSERT INTO kms_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Di Jisas ni nuqond pre te pugri nikin wute ni mo kin opu te nyumurighi nandi, pugri bu ni bot miraq mo kin tuqui segi. Di yambgriq tumo Jisas ni wuye wamne nyinge nare nikin wute nde nondo. Ni nondo dob nem no ningg tumo. ");
INSERT INTO kms_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ni rar meq wundo muqoind pudi ni nei mamb kin mari te wuye wariwo, di wune mamb mari mari. ");
INSERT INTO kms_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ni Jisas muqoind di quan wune mamb. Di Jisas ni brequne wand meniram nari, “Nungoqi gre pu yequ. Wune wamb wayequ, ngene bu gadi.” ");
INSERT INTO kms_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Muq ni bot pe newo no, nyumurighi opu prene di nikin wute ni quan nganye puye mand. ");
INSERT INTO kms_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Te pugri ni nei imb ruam di ni bret wute buagi meny riq kin te nei mamb segi. ");
INSERT INTO kms_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ni wuye ngamo yumbui te misiq Genesaret tende mo mar di tende bot sare wuq muaw pu yequ. ");
INSERT INTO kms_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ni bot si miraq meyi mi di wute Jisas ruqoind rip no pre. ");
INSERT INTO kms_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Di ni vig rimb tiqe buagi te ruso wute num kin nyembe pe ruwo righe rire di Jisas ni muainde nas rutungu kin tende ruso. ");
INSERT INTO kms_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Di Jisas ni tiqe buagi tiqe yumbui tiqe woju o tiqe aye wonji yeru kin tende no, te wute num kinne rire rindi maket sunyi pe ruwo rise. Di ni Jisas pengu rindig ei wute num kin ni Jisas ningg chongo cheq te ritiq wuse ei ni num oghi ningg. Di wute buagi ni chongo riting wuse kin te ni num oghi. ");
INSERT INTO kms_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Muq Parisi di wute Moses ningg lo wute bei meny kin ninge Jerusalem pu mandi ye, ni Jisas yenu pe tende mikur pu yemu. ");
INSERT INTO kms_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ni Jisas ningg wute ni si wuye map segine mir mand kin te muqond. Te pugri Juda ni mari ni mir mand kin puayi te si wuye map segi tedi ni si uny. ");
INSERT INTO kms_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi di Juda buagi aye ni pripri si wuye rip di mir rind. Ni pugri puq ren ei kuqo mingg yumbo ur te rit rise. ");
INSERT INTO kms_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ni maket pe ruso pu rindi, te ni si wuye rip di mir buagi rire rindi kin te wuye rip pre muqdi riq. Di ni yumbo ur aye isis kuqo nde pu riteri kin te rit rise gre. Yumbo ur ren kin te kap wuye rip, os, nyeng di yumbo aye te kin wuye rip. ");
INSERT INTO kms_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pugri bu Parisi di wute Moses ningg lo wute bei meny kin ni Jisas pengu mindig mari, “Pughe kin ningg nunon wute ni koku mingg yumbo ur te memare ruso di si wuye map segine mir mand?” ");
INSERT INTO kms_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Di Jisas ni oyi nindim nari, “Nungoqi wutaqu umbo pe nei brequ bre pu rise muq nange vingg wute rundoqu ninggne yumbo ur yuwon ye wand. Asi propet Aisaia ni nungoqi ningg nari ye te nganyene nand. Ni nari, ‘Wute men ni mim pe nge yumbui nyamb miragh, pudi ninde umbo pe nge nei mimbigh segi. ");
INSERT INTO kms_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ni nge yumbui nyamb miragh ye te ghav rindim segi, te pugri ni wute gri lo yembe mindiny kin te oyi God ningg lo kin pugri wute bei meny.’ ");
INSERT INTO kms_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nungoqi God ningg lo te meware ruso di wute gri lo yembe mindiny kin te wat rise gre. ");
INSERT INTO kms_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Nungoqi God ningg lo te meware ruso ei nuqo ningg yumbo ur te God ningg lo kin pugri wat rise ye te quan nganye nei wamb. ");
INSERT INTO kms_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Te pugri Moses nari, ‘Nungoqi nuyi numo ningg wand te irepene ei wutungu,’ di ‘Wuti tughe kiyi o kumo wand brequ nindiny tedi wi nati.’ ");
INSERT INTO kms_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pudi nungoqi wute simbe wundiny wari wuti iri yumbo ninge kiyi o kumo ghav nindiny ningg, pudi ni simbe nindiny nari, ‘Nge yumbo nungoqi ghav guduq kin ren te God geg ningg kiping ruso pre,’ tedi ni kiyi o kumo yumbo ninge neny segi. ");
INSERT INTO kms_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ni pugri puq nand tedi nungoqi wuti te rar wuqoind yumbo ninge kiyi o kumo neny segi. ");
INSERT INTO kms_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te kin ningg nungoqi non nuqo mingg chuqo yembe wundiny kin tende gri nungoqi God ningg wand te meware ruso. Nungoqi yumbo ur pugri kin nganye buagi nganye puq wen pre.” ");
INSERT INTO kms_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Muq Jisas ni wute buagi te ningg nari ninde rundo di simbe nindiny nari, “Nungoqi buagi ane ange waq nge wand simbe gad kin ven wutungu di nei pe wawo vis. ");
INSERT INTO kms_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Yumbo dabo pu wuti iri nde rir ruso kin ni wuti te unje rip segi. Pudi yumbo wuti nde nei pe pu riyi ri kin te ni unje rip.” ");
INSERT INTO kms_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas ni wute buagi te si nare pre di baj pe no, muq nikin wute ni kopuqu wand ven kin puate te ningg pengu mindig. ");
INSERT INTO kms_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Di Jisas ni pengu nindim nari, “Pughe gri ate nungoqi mune nei wamb segine? Te pugri yumbo ninge dabo pu wuti iri nde rir ruso kin te ni unje rip segi. ");
INSERT INTO kms_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Te pugri yumbo ninde mim pe gri ne righe ruso kin te mune umbo che nawo ruso, ninde nei pe ris segi.” (Ren kin te Jisas ni mir buagi ni God nde rar pe yuwon kin te ningg nari.) ");
INSERT INTO kms_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas ni wand aye mune simbe nand nari, “Yumbo wuti nde wabe gri rise pu dabo riyi ri kin te ni unje rip. ");
INSERT INTO kms_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te pugri umbo pe yumbo ur buagi ren rise: nei brequ, quayi nyumbueg ane segi segi rise kin nei, nyungu kin nei, wute mamb riti kin nei, wute ngam ruso kin wute aye ane rise kin nei, ");
INSERT INTO kms_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","qi pe kin yumbo quan nei mimbiny, wute brequ mindiny, wute wandoqi mindiny kin nei, yumbo ur brequ isis puq men kin nei, wute aye yumbo yuwon kin rise di te ningg ker mawo, wute aye nyamb brequ mindiny, nikin nyamb mindiri ruwo, di wute nei yuwon ye rise segi kin pugri mas. ");
INSERT INTO kms_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yumbo ur brequ buagi ren kin nei te wuti nde umbo pe pu dabo riyi ri. Di yumbo ren kin ni wuti te unje rip.” ");
INSERT INTO kms_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Muq Jisas ni mong te si nare di no tiqe ire tiqe yumbui Tair mingg qi pe yequ kin tende no. Di ni no baj ire pe nar no ei suqo no, te pugri ni tende nas kin te wute nei rimb ni yambu nari. Pudi ni suqo no kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Te pugri, brequne nyumbueg ire ni Jisas nondo kin wand wutungu. Di ni kuwonyumbu ququ brequ ninde nas. Pugri bu ni wundo Jisas nde muange tingi wuse. ");
INSERT INTO kms_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nyumbueg te ni Grik wand wund kin. Di ni kumo te Juda segi, ni wute tit Ponisia puq munduw ye te kin, ni Siria ris ye. Di ni tende wuraq wundi. Ni Jisas simbe wundig ei ni ququ brequ kuwonyumbu nde yenu kin te puaq naind no. ");
INSERT INTO kms_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nyumbueg te Juda segi kin bu Jisas ni simbe nunduw nari, “Beghi wo rar buqod mir ni riq yawo kureny kin te riq. Te pugri beghi wo ni mir te nyombui mepirany rundo riq kin te oghi segi.” ");
INSERT INTO kms_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nyumbueg te oyi wund wuri, “Yumbui te nganye, pudi nyombui nyembe nambu rise kin ni oyi wo ningg mir di ir righe kin te riq yuwon ruany.” ");
INSERT INTO kms_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Muq Jisas ni nyumbueg te simbe nunduw nari, “Nu pugri oyi guad ye te ningg bu muq nu yo. Ququ brequ ni nu wo te si niraq pre.” ");
INSERT INTO kms_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ni mune nikin baj pe wuso di ni kuwonyumbu sunyi pe ruqo pu wuse wundoq, di ququ brequ ni si niraq no pre. ");
INSERT INTO kms_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Muq Jisas ni Tair mingg mong puch te si nare di Saidon mingine newo naghe Galili wuye ngamo opu tende no. Ni no kin te tiqe yumbui 10-pela pu yeru ye tende mingine no. ");
INSERT INTO kms_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tende wute ninge wuti iri ange tuq rimbig di yuwonne wand nand tuqui segi kin te mitanyi Jisas nde mondo. Di ni Jisas ningg mari ei wuti te si neng kuyo ningg. ");
INSERT INTO kms_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Muq Jisas ni wuti te irine nitanyi wute buagi te si mare di kring mo pu aye pe yemu, di Jisas ni wuti tende ange pe si suramb ange gawo pe opu opune ni mindighe. Di ni si tumuepu te som nuang di wuti te minjuq te niting nase. ");
INSERT INTO kms_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ni nginy tu wam rar neq wiyo, di chi nateri muq nari, “Epata.” (Wand puch ven ni puate te pugri, “Bi yo.”) ");
INSERT INTO kms_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Muq wuti te ni ange mune oghi rise, di ni minjuq mune yuwon nand di yuwonne wand nand. ");
INSERT INTO kms_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas ni wute yumbo ni puq nen ruqond kin te ningg wute aye simbe rindiny segi puq nindiny. Pudi ni quan nganye segi puq nindiny, di ni oyi yumbo ruqond kin te ningg wute aye quan simbe rindiny. ");
INSERT INTO kms_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wute buagi te ningg quan nganye puye rind. Di ni riri, “Ni yumbo buagi yuwonne puq nen. Ni wute ange tuq rimbiny kin te tuq bi nawo ruso, di wute wand rind segi kin te sabi nindiny wand rind.” ");
INSERT INTO kms_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tende puayi wute buagi aye mune rundo Jisas nde tende rikur. Ni yeru ruso di mir rind kin mir segi. Di Jisas nikin wute ningg nari mondo di simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nge wute ren yawo kutony, te pugri ni nge ane pas nginy temi ire pu, di ni mir segi. ");
INSERT INTO kms_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ninge wonji pu rindi di nge ni tiqi gudony ruso, tedi ninge mir ningg ngimi te rar ori riti ye.” ");
INSERT INTO kms_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Di nikin wute ni oyi mari, “Pudi beghi mong wuye di nyumo segi ye pe ven yembu, di wute quan nganye, pugri bu wuti iri wute buagi ren bret neny ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Muq Jisas ni pengu nindim nari, “Nungoqi bret pughe gri pu rise?” Ni oyi mand mari, “7-pela pu.” ");
INSERT INTO kms_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Di Jisas ni wute buagi te simbe nindiny qi pe ris. Muq ni bret 7-pela pu te nateri, God chumbuai nindig pre, bir nawo nikin wute te nem, ei ni mare mo wute buagi te meny. ");
INSERT INTO kms_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ni umo woju ninge ane rise, di te mune pugrine, God chumbuai nindig pre di nikin wute nem di simbe nindim mare mo wute buagi te meny. ");
INSERT INTO kms_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wute buagi te riq di mir rimbiq. Di Jisas nikin wute ni mir cham te mune materi imbi pe mawo righe ruso di imbi 7-pela pu bre mand. ");
INSERT INTO kms_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wute buagi te manyi mand kin te quayine te 4,000 kin pugri tende mas. Jisas ni wute buagi te tiqi nundony ruso, ");
INSERT INTO kms_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","di ni nikin wute ane bot pe mewo mo di Dalmanuta opu tende mo. ");
INSERT INTO kms_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Muq Parisi Jisas maip mi newo ningg ni nde mandi. Ni pengu mindig ei ni wam kin yumbo ur gre kin ire bei nand muqond. ");
INSERT INTO kms_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ni quan kumo chi nate ruso di nari, “Pughe kin ningg wute muq ven nde puayi mas kin ni yumbo ur gre ye muqond ningg mari? Nge nungoqi nganyene simbe guduq, wute muq ven nde puayi mas kin ni yumbo ur gre ye ninge muqond segi ye.” ");
INSERT INTO kms_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Muq ni si nare yemu bot pe mune newo no di wuye ngamo misiq opu gri mo. ");
INSERT INTO kms_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisas ningg wute ni nei gheri map di bret ninge mare segine mo, pudi irene miraq mo pu bot pene wuse. ");
INSERT INTO kms_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Muq Jisas ni yeri nindim nari, “Nungoqi rar wat yuwon, Herot di Parisi ni mingg yis te ningg yeng wawo yuwon.” ");
INSERT INTO kms_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Muq ni kin kin wand mand mari, “Beghi bret segi bu ni puq nand.” ");
INSERT INTO kms_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pudi ni wand wand mare kin te Jisas ni nei namb pre, pugri bu ni pengu nindim nari, “Nungoqi pughe kin ningg wari nungoqi bret segi puq wand? Nungoqi yumbo te kin wuqond o nei wamb segine bri? Nungoqi nei rise segi bri? ");
INSERT INTO kms_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nungoqi rar rise pu muq wuqond segi, o ange rise pu muq wutungu segi bri? Di nungoqi ren nei wamb segi bri? ");
INSERT INTO kms_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nge wute 5,000 pela pu te ningg bret 5-pela pu bir kawo, riq pre di cham mune dong wand kin te imbi pughe gri pu bre wand?” Ni oyi mand mari, “12-pela pu.” ");
INSERT INTO kms_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Di nge wute 4,000 pela te ningg bret 7-pela pu bir kawo riq pre, di cham dong wand kin te imbi pughe gri pu?” Ni oyi mand mari, “7-pela pu.” ");
INSERT INTO kms_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ni simbe nindim nari, “Nungoqi nei wamb segine bri?” ");
INSERT INTO kms_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Muq ni mo Betsaida di wute ninge ni wuti iri rar brequ kin te mitanyi Jisas nde mandi di Jisas ningg mari ei wuti te nait nase ningg. ");
INSERT INTO kms_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas wuti te si niting rise nitanyi temi tiqe si miraq dabo mar mo. Muq Jisas wuti te ninde rar pe som nuang pre, si neng kuyo di pengu nindig nari, “Nu yumbo ninge guqod o segi?” ");
INSERT INTO kms_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Di wuti te rar nat di nari, “Nge wute guqod, ni ruso rindi pudi ni nyumo gib rimb.” ");
INSERT INTO kms_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas ni mune wuti te ninde rar pe si neng kuyo. Muq wuti te ni rar yuwon rind di yumbo buagi te yuwonne nuqond nap ruso. ");
INSERT INTO kms_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Muq wuti te tiqi nundog nikin tiqe no di simbe nindig nari, “Nu mune tiqe mingine ghar yo wayequ, nu qunambe ne yo.” ");
INSERT INTO kms_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas ni nikin wute ane tiqe woju Sisaria Pilipai opu yeru kin tende mo. Ni mo ngimi di Jisas nikin wute te pengu nindim nari, “Wute buagi ni pughe puq rind, nge tughe bu?” ");
INSERT INTO kms_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Di ni oyi mand mari, “Wute ninge riri nu Jon wute wuye nap kin, ninge riri nu Elaija, di ninge riri nu propet asi kin iri.” ");
INSERT INTO kms_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Di Jisas ni mune pengu nindim nari, “Pudi nungoqi pughe gri nei wamb, nge tughe bu?” Di Pita oyi nand nari, “Nu Kraist, wuti beghi kutamu powi ningg God naip kuo ye.” ");
INSERT INTO kms_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Di Jisas ni simbe nindim ei ni te kin ningg wute aye simbe mindiny segi. ");
INSERT INTO kms_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Muq Jisas ni nikin wute wand bei nem, di ni pugri simbe nindim, “Wuti God nde pu nandi wuti nganye nas kin ni mai quan nare ye. Di quayi kiyi, prist mingg yumbui di wute Moses ningg lo te wute bei meny kin ni yambu mireng ye. Ni mi nati, nginy temi ire mo pre di God mune nindingi newo.” ");
INSERT INTO kms_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas ni wand ren raqene simbe nand, di Pita ni Jisas nitanyi temi kring mo kinne yemu, muq ni Jisas segi puq nindig ei ni pugri puq nand segi. ");
INSERT INTO kms_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pudi Jisas ni rar neq wundo nikin wute ninge te nuqond, di Pita ni Jisas wand te segi puq nand kin te ningg ker nuang di nari, “Satan nu kring yo. Nu God ningg nei pe wand guad segi, nu wute ningg nei pe wand guad.” ");
INSERT INTO kms_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Muq ni wute buagi di nikin wute te ane nari rundo di simbe nindiny nari, “Wuti nge nde nawi ningg, tedi ni yumbo buagi qi pe kin te dob neny di nge mai kiraq kin pugrine ei niraq. ");
INSERT INTO kms_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te pugri wuti tughe nikin ghimbine nei nimbiny nimbiny di nati tedi ni nas nas te kin nas tuqui segi, pudi wuti tughe nge di God ningg wand yuwon ye te ningg nikin ghimbi nei nimbiny segi di nati tedi ni otiwo yuwon pu nas nas te kin nas ye. ");
INSERT INTO kms_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wuti iri nge dob negh, qi pe kin yumbo yumbo oyi quan nei nimbiny, di yumbo te kin yembe nand nand muq nati, tedi yumbo te pughe gri ei ni ghav rindig? Te tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ni otiwo yuwon pu nas kin te yumbo ninge pe wong nand tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wute muq ven nde puayi ris ye ni yumbo ur brequ isis yembe rindiny di God yambu rireng. Di wuti iri ni muq ven nde puayi nas kin ni wute nde rar pe nari ni nge ningg wuti di nge wand natevi puq nand kin te ningg minyuw nati, tedi nge wuti God nde pu gadi wuti nganye kas ye nge wuyi ningg ti yumbui pe di angelo yuwon ye ane gadi kin tende puayi nge oyi ni minyuw kiteng.” ");
INSERT INTO kms_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Di Jisas ni simbe nindim nari, “Nge nungoqi nganyene simbe guduq, nungoqi ven yequ kin nungoqi kin ninge mati segine di yumbo buagi God nde si nambu rise kin te gre ane rindi muqond.” ");
INSERT INTO kms_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jisas ni otiwo nati kin te ningg simbe nand pre, tende dobu nginy 6-pela pu mo pre Jisas ni Pita, Jems, di Jon pugri pu nitami rand iri wam dobui nganye kin tende mewo mo nikinne tende mas. Ni Jisas muqoind muqoindne tindi no aye gib namb. ");
INSERT INTO kms_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ni chongo nare righe kin te quan nganye quem rimb, ni quem rimb kin te yumbo ninge qi pe kin quem rimb kin pugri segi. ");
INSERT INTO kms_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Di Elaija Moses temi mandi Jisas ane wand wand yemu muqond. ");
INSERT INTO kms_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Di Pita Jisas ningg nari, “Tisa, beghi ven nde pas te yuwon. Nu ngiq ghand tedi beghi baj yirbu teri ire pu ven nde yembe bidiny. Ire nu te, ire Moses te, di ire Elaija te.” ");
INSERT INTO kms_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ni quan nganye wune mamb, pugri bu ni wand aye nei nimbiny segi.) ");
INSERT INTO kms_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Muq wuye quari ire wuti wi ni buag wure, di wuti iri wuye quari wam te pu ngam nare nari, “Nen nge wo, nge ni quan nganye yawo girag righe. Nungoqi ni ningg wand wutungu.” ");
INSERT INTO kms_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Muq ni rar mat di wute ni ane yemu kin te yemu segi, Jisas irine yenu muqoind. ");
INSERT INTO kms_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ni rand pe pu mune mati mi mi, di Jisas ni simbe nindim ei ni yumbo muqond kin te ningg wute aye simbe mindiny segi. Ni nari ni simbe mand segine ruso wuti God nde pu nandi wuti nganye nas ye ni nati pre mune nes newo. ");
INSERT INTO kms_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Di ni wand te kin ningg wute aye simbe mindiny segi, nikinne ni nati pre mune nes newo ye te ningg wand mand di nei mimbiny mimbiny mas. ");
INSERT INTO kms_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Di ni pengu mindig mari, “Pughe ningg wute Moses ningg lo wute bei meny ye ni mari Elaija ei ye nawo nandi?” ");
INSERT INTO kms_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ni oyi nand nari, “Te nganye Elaija ni ye nawo nandi di yumbo buagi sabi nindiny asi kin pugrine rise. Pughe ningg bu wand buk pe ur pu vise ye te viri wuti God nde pu nandi wuti nganye nas ye ni mai quan nare di wute yambu rireng? ");
INSERT INTO kms_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pudi nge nungoqi simbe guduq, Elaija nandi pre, di ni yumbo puq meng yawo kurem kin te puq meng. Ni puq men kin te wand buk pe ur pu vise kin te tuquine puq men.” ");
INSERT INTO kms_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ni rand pe pu mati mi di Jisas nikin wute aye te mas pe tende mo mitari righe di wute nganye buagi rindi tende rikur pu yeru muqond. Di wute Moses ningg lo wute aye bei meny ye ni Jisas ningg wute te ane ker mawo mawo yemu. ");
INSERT INTO kms_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ni Jisas nondo ruqoind di ni quan nganye puye rind di vig rimb rundo chumbuai rindig. ");
INSERT INTO kms_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Di Jisas ni pengu nindiny nari, “Nungoqi pughe ningg ni ane ker wawo?” ");
INSERT INTO kms_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Muq wuti iri wute mingi tende yenu pu oyi nand nari, “Tisa, nge wo ni ququ brequ ninde nar nas di ni wand nand tuqui segi kin nen nunde kitanyi gadi. ");
INSERT INTO kms_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ququ brequ ni pripri nge wo unje naip di qi pe pombri naip no. Ni pripri sawo nat ki, napu mim pe gri ruwi riti di ni si muange gre rind. Nge nunon wute ni ququ brequ te bub meri no ningg kari, pudi ni puq men tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas oyi puq nand nari, “Nungoqi wutaqu muq ven nde puayi was kin nungoqi God nei wumbig segi. Nge nungoqi ane pas nganye chiraq tuqui segi. Nge nungoqi mai quan nganye kare yambu kari. Wokuandi te ren wutanyi wandi.” ");
INSERT INTO kms_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Muq ni wokuandi te Jisas nde mitanyi mondo. Ququ brequ ni Jisas nuqoind di ni wokuandi te meneri no quan nganye buyaq nand. Ni qi pe me no pu nase ni naghe nondo nandi di napu mim pe ruwi riti. ");
INSERT INTO kms_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Muq Jisas wokuandi te ni kiyi pengu nindig nari, “Wokuandi nen ni pugri puq reng kin ber pughe gri pu nawo?” Di ni oyi nand nari, “Ni wokuandi ne puq reng. ");
INSERT INTO kms_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ququ brequ ni pripri wase pe di wuye pe meneri naghe ei nati ningg. Pudi nu tuqui tedi beghi yawo tongu di ghav ndug mune sabi ndig.” ");
INSERT INTO kms_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas nari, “Pughe ningg nu kuari, ‘Nu tuqui tedi’? Wuti God nei nimbig tedi ni yumbo buagi puq nen ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Di wokuandi te ni kiyi opu brequne nari, “Nge nei gab ni mune oghi ye, nu nge ghav ndigh ei nge nei ven gre vind.” ");
INSERT INTO kms_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas ni wute buagi ni yumbo te ruqond ningg vig rimb rundo kin te nuqond di ququ brequ te ker nuang nari, “Nu ange wand kutungu segi kin di wand guad segi kin ququ, nu wo te si gheri di mune ninde ghandi ghar yo wayequ.” ");
INSERT INTO kms_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Muq ququ brequ ni quan kumo nari, wo te ni nondo nandi di neyi ni no. Wo te tit segi pu nase di wute buagi riri ni nati. ");
INSERT INTO kms_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pudi Jisas ni si niting rise, nindingi newo yenu. ");
INSERT INTO kms_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dobu Jisas ni nikin wute ane baj pe mas muq nikin wute ni pengu mindig mari, “Pughe gri ate beghi ququ brequ te puaq baid no kin tuqui segi?” ");
INSERT INTO kms_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ni oyi nindim nari, “Ququ brequ pugri kin te nungoqi God ne pengu wundig tedi ni meyi mi mo kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ni sunyi te si mare di Galili gri mo. Jisas ni muainde mas kin te wute nei rimb yambu nari. ");
INSERT INTO kms_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Te pugri ni nikin wute wand bei nem ningg. Di ni pugri simbe nindim nari, “Wuti God nde pu nandi wuti nganye nas kin ni wute nde si pe mi nondo ye. Ni mi nati, nginy temi ire pre di ni mune nes newo.” ");
INSERT INTO kms_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ni pugri simbe nindim, pudi ni wand ven kin puate nei mimbiny segi di wand ven kin puate ningg pengu mindig ye wunene mamb. ");
INSERT INTO kms_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ni mo Kaperneam mitari righe di ni baj pe mar mas muq ni pengu nindim nari, “Ngimi badi kin tende yumbo pughe kin ningg oyi oyi wari?” ");
INSERT INTO kms_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pudi ni wand segine mas, te pugri ngimi mandi kin tende puayi ni wuti tughe ei yumbui ningg nas ye te ningg oyi oyi ker mawo. ");
INSERT INTO kms_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Muq Jisas ni chuchu nas nikin wute 12-pela pu te nari mondo di simbe nindim nari, “Wuti iri ni ye nawo ningg nari, tedi ni dobu nganye nawi di wute buagi mingg yembe ye wuti ningg nas.” ");
INSERT INTO kms_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Di ni wokuandi iri neti nowi ninde rar ngimine teti pu yenu. Ni wo te sibraj ni di nari, ");
INSERT INTO kms_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wuti iri ni nge nde nyamb pe wokuandi pugri ye iri neti nowi sabi nindig, te ni nge bu neti kowi sabi nindigh, di wuti nge neti kowi sabi nindigh kin te ngene neti ki sabi nindigh segi, pudi wuti nge tiqi nundogh gadi kin ni ane neti nowi sabi nindig.” ");
INSERT INTO kms_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Muq Jon nari, “Tisa, beghi wuti iri buqoid nu nde nyamb pe ququ brequ puaq nand. Pudi wuti te aye kin, ni beghi nde dobu nawi segi ye. Pugri bu beghi ni segi puq bidig ei mune puq nen segi.” ");
INSERT INTO kms_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Muq Jisas nari, “Nungoqi ni segi puq wundig wayequ. Wuti iri nge nde nyamb pe yumbo ur gre ye bei nand pre te brequne mune nge wand brequ nindigh tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Te pugri wuti iri beghi veri ningg nas segi kin ni beghi nde opu nas. ");
INSERT INTO kms_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nge nungoqi nganyene simbe guduq, wuti iri nungoqi nge te wute bu te kin ningg nge nde nyamb pe wuye kap ire neuq, tedi wuti te ni yumbo otiwo nateri kin te nateri ye.” ");
INSERT INTO kms_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisas mune nari, “Di wuti iri ni wokuandi nge nei rimbigh ye ren kin ye iri puq neng yumbo ur brequ nand, te wuti te wet yumbui gibe pe wuq wang gherim pe meweri naghe tedi yuwon. ");
INSERT INTO kms_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nu si ire puq rew yumbo ur brequ guad, tedi si te pend ghawo. Te pugri nu si irene kuse muq yo yuwon pu ghas kin te quan nganye yuwon. Nu si tengi ane kuse di wase awu kuso segi ye pe tende yo kin te brequ. ");
INSERT INTO kms_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Di nu nyinge ire puq wew yumbo ur brequ guad tedi pend ghawo. Nu nyinge ire ninggne yo yuwon pu ghas kin te yuwon, di nyinge tevi ane vise wase pe memeri yaghe kin te oghi segi. ");
INSERT INTO kms_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Di nu rar puq wew yumbo ur brequ guad, tedi bi waq. Te pugri nu rar irene wuse di wute God nde si nambu ris kin tende ghar yo kin te yuwon. Pudi nu rar teri ane rise di ni wase pe memeri yaghe kin te brequ. ");
INSERT INTO kms_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wase pe tende choi mati segi kin tende yemu, di wase awu segi ye. ");
INSERT INTO kms_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wute buagi ni mir sol puraq bidiny kin pugri ei wase namb ye. ");
INSERT INTO kms_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ghat ni oghi, pudi ni nyong te prene, tedi ni mune nyong gub segi. Nungoqi ghat kin pugri nyong wamb wambne was di wute aye ane umbo yuwonne rise was.” ");
INSERT INTO kms_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Muq Jisas ni nikin wute ane Galili si miraq Judia opu mo, wuye Jordan misiny opu gri mo mewo. Di munene wute nganye buagi rundo, di ni pripri puq nen kin pugrine mune wand bei neny di rutungu. ");
INSERT INTO kms_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Muq Parisi ninge ninde mandi, di Jisas maip mi newo ei muqond ni wand ire unje nap bri. Pugri bu ni pengu mindig, “Wuti iri ni ngam puaq nindiq ye te ningg lo segi puq bri wund?” ");
INSERT INTO kms_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Di Jisas oyi nindim nari, “Moses ni nungoqi pughe gri simbe nunduq?” ");
INSERT INTO kms_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ni mari, “Moses nari wute segine ni ngam puaq mand kin nyumo raqe ur mand meny pre di tiqi mundony ruso.” ");
INSERT INTO kms_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Di Jisas oyi nand nari, “Moses ni puq nand kin puate te pugri nungoqi quan nganye ngawu gre wand, pugri bu Moses ni lo wen pugri ur nindiq. ");
INSERT INTO kms_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pudi asi God ni qi di yumbo buagi qi pe kin yembe nindiny kin tende puayi ‘Ni quayi nyumbueg ane pu yembe nindiny.’ ");
INSERT INTO kms_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Puate te ningg bu quayi ni kiyi kumo ane si nare di ni ngam teri irepene ris, ");
INSERT INTO kms_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","di ni teri ghimbi irene nganye rise.’ Asi ni kin kin ris pudi muq ni teri ghimbi irene. ");
INSERT INTO kms_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God ni teri irepene nawo righe, pugri bu wuti iri ni bir nawo kin kin yeru te brequ.” ");
INSERT INTO kms_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ni munene mo baj pe mas di Jisas nikin wute ni te kin ningg mune pengu mindig. ");
INSERT INTO kms_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Di ni oyi nindim nari, “Wuti iri ni ngam puaq nindiq muq aye nitaqi, te ni ngam kin lo gure nuaq di unje nipiq. ");
INSERT INTO kms_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Di nyumbueg ni ngaim puaq wuind muq wuso aye wutanyi, te ni yumbo ur pugri kinne ngam kin lo gure waq.” ");
INSERT INTO kms_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Di wute wokuandi Jisas nde ritari rundo ei Jisas ni si neny riwo ningg. Pudi Jisas nikin wute ni wute wo ritari rindi kin te ker muany. ");
INSERT INTO kms_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Di Jisas ni te nuqond di ker nawo, di nikin wute te simbe nindim nari, “Wokuandi te rar wuqond nge nde rindi, segi puq wundiny wayequ, te pugri wute God nde si nambu ris kin te wokuandi ren kin pugri ris ye ni te. ");
INSERT INTO kms_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nge nungoqi nganye simbe guduq, wuti iri ni wokuandi ren kin pugri God nde si nambu nas segi, tedi ni wute God nde si nambu ris kin tende nar no segi.” ");
INSERT INTO kms_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Di Jisas ni wokuandi te nateri nare pu yenu si neny riwo di Yumbui pengu nindig ei ni yuwon nuany. ");
INSERT INTO kms_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas ni mune nyinge nare no no di wuti iri vig namb ninde nondo sungomyu gure nawo di nari, “Tisa, nu yuwon nganye. Nu nge simbe ndigh, nge pughe sin ken ei nge kas kas te kin kas?” ");
INSERT INTO kms_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas oyi nand nari, “Pughe ningg nu nge yuwon puq gudigh? Wuti iri yuwon segi; God irine yuwon. ");
INSERT INTO kms_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nu God ningg lo nei guab pre: Wute ghamb riti wayequ; wute ngam kin ane wase wayequ; nyungu ghand wayequ; wute wandoqi ndiny ghari ni unje rip puq ghand wayequ; wute wandoqi ndiny yumbo segi tanyri wayequ; di nuyi numo ningg wand irepene tungu.” ");
INSERT INTO kms_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Di wuti te oyi nari, “Tisa, yumbo ren kin nge asi wokuandi ne kas kin tende puayine puq ken ken rindi rindi muq.” ");
INSERT INTO kms_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas rar neq wundo wuti te nuqoind di yawo nirang righe di simbe nindig nari, “Yumbo ire nu puq kuen segine. Nu yo, yumbo yumbo buagi te yi rundo wute aye wong mand, di wet bidi te kin ghateri wute yumbo segi kin te yeny. Nu puq yen tedi nu yumbo yuwon kin nganye nginy tu wam rise. Nu puq yen pre muqdi nge nde ghawi.” ");
INSERT INTO kms_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wuti te ni Jisas pugri puq nand kin te nutungu di ni quenge riti. Ni yumbo quan nganye rise, pugri bu Jisas wand nand kin te ningg ni yivany ane no. ");
INSERT INTO kms_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Di Jisas ni rar nat wute buagi te nuqond pre di nikin wute simbe nindim nari, “Wute yumbo quan rise kin ni wute God nde si nambu ris kin tende rir ruso kin yembe yumbui nganye.” ");
INSERT INTO kms_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jisas ni pugri puq nand di nikin wute ni nei kumo mamb. Pudi Jisas ni munene nari, “Nge wo, wute God nde si nambu ris kin tende rir ruso ye yembe te yumbui nganye. ");
INSERT INTO kms_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Umo yumbui kamel puq munduw kin ni chongo rang kin nil gawo woju tende wur wuso kin yembe yumbui segi, pudi wute yumbo quan kin ni wute God nde si nambu ris kin tende rir ruso ye yembe yumbui nganye.” ");
INSERT INTO kms_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Di Jisas nikin wute ni mune quan nganye nei kumo mamb di kin kin pengu mand mari, “Tedi wuti tughe ei God neti nowi yuwon pu nas ye?” ");
INSERT INTO kms_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Muq Jisas ni rar neq wundo nuqond di nari, “Wute puq ren tuqui segi, pudi God yumbo buagi te puq nen kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Di Pita Jisas ningg nari, “Beghi yumbo buagi te si pare di nunde dobu pawi.” ");
INSERT INTO kms_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas oyi nand nari, “Nge nungoqi nganyene simbe guduq, wuti iri ni nge di God ningg wand yuwon ye ningg nari nikin tiqe, kise kiqam, kiyi kumo, wo, di wuny si nare kin ");
INSERT INTO kms_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","otiwo di ni yumbo si nare kin te mune quan, 100 kin pugri rise. (Yumbo ren kin te baj, kise kiqam, kumo, wo di wuny.) Di yumbo tene segi, pudi wute mandi ni unje maip ningg mai isis meng, di wute te kin ni otiwo yumbo buagi yuwon pu rise kin tende puayi ni anene yuwon pu nas nas te kin nas ye. ");
INSERT INTO kms_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pudi wute quan muq ni ye mawo kin te otiwo ni dobu mawi, di muq dobu mawi kin te otiwo ye mawo ye.” ");
INSERT INTO kms_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas ni nikin wute ane ni Jerusalem mewo mo, di Jisas ni ye nawo. Ni mo mo di Jisas nikin wute ni nei kumo mamb di wute aye ninde dobu ruru kin ni wune rimb. Di Jisas ni mune nikin wute 12-pela pu waghine nitami no nikinne yemu di ni otiwo yumbo ninde puq reng kin te ningg simbe nindim. ");
INSERT INTO kms_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ni pugri simbe nindim nari, “Muq beghi Jerusalem pewo po, di wuti God nde pu nandi wuti nganye nas ye ni prist mingg yumbui di wute Moses ningg lo wute bei meny ye ninde si pe mi nondo ye. Di ni mari ni nati puq mand, di wute Juda segi kin ninde si pe mi nondo. ");
INSERT INTO kms_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Di wute Juda segi kin ni wand peq mindig, di som mirang righe, yas muang di mi nati. Nginy temi ire pre dobu di ni mune nes newo.” ");
INSERT INTO kms_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Muq Sebedi ningg wo Jems di Jon temi ni Jisas nde mondo di mari, “Tisa nu beghi yumbo ninge puq yen ningg pari, di beghi pari kin pugrine ei puq yen.” ");
INSERT INTO kms_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisas oyi pengu nindim nari, “Nge nungoqi pughe sin keuq ningg wari?” ");
INSERT INTO kms_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Di ni Jisas pugri simbe mindig mari, “Otiwo nu Yumbui ningg kuas di yumbo buagi nunde si nambu rise kin tende puayi beghi temu nu ane ei pas, iri si tuan pe opu di iri si qaqi pe opu.” ");
INSERT INTO kms_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Di Jisas nari, “Nungoqi yumbo pengu wand kin te nei wamb segi. Nungoqi kap nge wuye ke kin te ningg wuye we tuqui bri? Di nge wuye maip kin pugrine nungoqi mune wuye mupuqu kin tuqui bri?” ");
INSERT INTO kms_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Di ni oyi mand mari, “Beghi tuqui.” Di Jisas ni simbe nindim nari, “Nungoqi nge wuye maip kin pugrine wuye mupuqu di nge wuye ke kin kap te ninggne wuye we ye, ");
INSERT INTO kms_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","pudi nge nde si tuan pe o si qaqi pe was kin te nge gri nungoqi sunyi te keuq tuqui segi. Sunyi ren te wute tughe God sunyi te nipim ruso pre ye ni te.” ");
INSERT INTO kms_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jisas nikin wute aye 10-pela pu te ni ren mutungu di ni Jems Jon temi ningg ker mawo. ");
INSERT INTO kms_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Di Jisas ni quan buagine nari mondo di simbe nindim nari, “Nungoqi nei wamb te pugri wute Juda segi kin ni mingg yumbui ningg mas ye ni quan nganye yumbui mas di wute buagi ninde si nambu ris ningg mari. Di ni nikin wute nyamb kin te ni buid map ei wute buagi ni mingg wand irepene rutungu. ");
INSERT INTO kms_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nungoqi ni puq men kin pugri puq wen wayequ. Pudi nungoqi kin wuti iri ni yumbui nas ningg nari, te ni nungoqi ningg yembe ye wuti kin pugri ei nas, ");
INSERT INTO kms_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","di wuti iri ni ye nawo ningg nari, te ni wute buagi nde taq pu yenu yembe ye wuti te kin pugri ei nas. ");
INSERT INTO kms_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te pugri wuti God nde pu nandi wuti nganye nas ye ni wute ni ningg yembe rindig ningg nandi segi, pudi ni oyi wute nde yembe nand ningg nandi, di ni nati ei wute nganye buagi ir pu ris ningg wong nand.” ");
INSERT INTO kms_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Muq Jisas nikin wute ane mo Jeriko mo mar. Di Jisas nikin wute ane di wute buagi Jisas ningg wand rutungu ningg ruru kin ni ane Jeriko si riraq ruso. Wuti iri rar brequ ye ni ngim sange pe tende yumbo sang nap nap nas. Wuti te ni nyamb Bartimeus puq mindig kin di ni Timeus ningg wo. ");
INSERT INTO kms_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Di Bartimeus ni nutungu Jisas Nasaret kin nandi no, di ni ngam nare nari, “Jisas, Devit ningg kuqo, nu nge yawo togh.” ");
INSERT INTO kms_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wute nganye buagi ni ker ruang di simbe rindig ei ni wand segi nas. Pudi ni mune nganye nari, “Devit ningg kuqo, nge yawo togh.” ");
INSERT INTO kms_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Muq Jisas ni yenu di nari, “Simbe wundig nandi.” Di ni wuti rar brequ kin te ningg riri, “Nu nei kumo ghamb wayequ, yes yewo, ni nari nu ghondo.” ");
INSERT INTO kms_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Muq wuti te ni saket meniraq wuso wuse, nes newo di Jisas nde nondo. ");
INSERT INTO kms_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Muq Jisas ni pengu nindig nari, “Nge nu pughe sin kew ningg kuari?” Di wuti rar brequ kin te nari, “Tisa, nge rar kat yumbo guqod ningg kari.” ");
INSERT INTO kms_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Di Jisas nari, “Nu yo, nu nge nei gubigh ye te ningg nu rar oghi pre.” Di brequne nganye ni rar mune oghi rar nat yumbo nuqond, di ni wute buagi aye te ane Jisas nde dobu ruru di ngimne nyinge rire ruso. ");
INSERT INTO kms_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Muq ni Jerusalem tumo mondo di ni tiqe Betpage Betani ane tende mondo. Ni nyumo oliv yemu kin rand tende qunambe yemu di Jisas nikin wute temi yeri nindim pre tiqi nundom mo. ");
INSERT INTO kms_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ni yeri nindim nari, “Nungoqi tequ tiqe tumo te yequ kin tende wo. Nungoqi tiqe te ningg warne wondo di donki ghair iri wuq muang pu yenu wuqoind ye. Wuti iri ni donki te ningg no segine. Donki te sare bure wundig di wutanyi ven wandi. ");
INSERT INTO kms_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Di wuti iri nungoqi pengu nunduq nari, ‘Pughe kin ningg nungoqi puq wen?’ tedi nungoqi oyi wuti te simbe wundig wari, ‘Yumbui ni yembe rise bu pitanyi po pre di brequne mune pitanyi badi ye’.” Ni pugri yeri nindim pre muq tiqi nundom mo. ");
INSERT INTO kms_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Muq ni temi mo donki te ngimrawu ne sare pe mibo pre dabo opu mi neyi ni pu yenu muqoind. Di ni temi mondo sare bure mindig mindig yemu ");
INSERT INTO kms_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","di wute ninge ninde tumone yemu kin ni mari, “Pughe kin ningg nungoqi donki te sare bure wundig?” ");
INSERT INTO kms_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Di ni Jisas yeri nindim kin pugrine simbe mand, di ni rar muqond mo. ");
INSERT INTO kms_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ni donki te mitanyi mo Jisas nde di ni nikin chongo dobui te donki wam mawo, di Jisas newo nas. ");
INSERT INTO kms_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wute nganye buagi nikin chongo dobui ngimne ruwo ruwo rire ruso di ninge nyumo muange wuny mbe pu gure ruwo rire rindi kin te ngimne ruwo rise. ");
INSERT INTO kms_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wute ninge ye ruwo, ninge Jisas nde dobu ruwi, di quan buagine pugri riri, “Hosana! God nu wuti Yumbui nde nyamb pe nandi kin nen yuwon wang. ");
INSERT INTO kms_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God, nu beghi koku Devit ni yumbo buagi ninde si nambu rise kin te muq mune rindi kin te yuwon wany. Yumbui wam nganye nas kin ni nyamb wundivi viyo.” ");
INSERT INTO kms_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas ni Jerusalem nar no di tene no God ningg baj pe, di ni yumbo buagi tende yeru kin te nuqond nuqond no. Pudi burpoq rip pre pugri bu ni nikin wute 12-pela pu te ane mune Betani mo. ");
INSERT INTO kms_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yambgriq ni Betani si miraq mo di Jisas ni mir gureg. ");
INSERT INTO kms_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ni wonjine rar neq wuso, nyumo fig iri raqe ane yenu nuqoind, di ni no nuqoind, yi neyi pu bri. Ni nondo tumo nuqond di fig yi segi, raqene rise, te pugri tende puayi fig ni yi meyi kin ngeri te segine. ");
INSERT INTO kms_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Muq Jisas ni nyumo fig te ningg nari, “Nu muq wute nu ningg yi te mune me segi ye.” Di ni wand ven puq nand kin te Jisas nikin wute ni mutungu mutungu ne puq nand. ");
INSERT INTO kms_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ni mo Jerusalem mitari righe, di Jisas ni God ningg baj imb wabe nar no, di wute God ningg baj pe yumbo wong mand di maket muaq kin te bub nare mo. Wute ninge mas wet bidi kantri aye kin materi di ni mingg wet bidi te oyi mem. Di Jisas nandi wute men tebol te groq nindim ruso, di wute wapi mabri mawo mas wong mand kin ni mas kin komboiq te pombri nipim ruso. ");
INSERT INTO kms_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Di wute aye God ningg baj imb pe yumbo rire ruso rindi kin te segi puq nindiny. ");
INSERT INTO kms_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Di ni God ningg wand bei neny kin tende puayi ni pugri simbe nindiny nari, “God ningg wand rise kin buk pe God pugri puq nand, ‘Nge ningg baj te tiqe buagi nge ane wand ye baj puq munduw ye.’ Pudi nungoqi wute nyungu kin suqo mo ye sunyi kin pugri puq wew.” ");
INSERT INTO kms_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Muq prist mingg yumbui di wute Moses ningg lo wute bei meny ye ni ren kin mutungu di ni Jisas mi nati kin ngim meri mat. Te pugri wute buagi ni Jisas wand simbe nand kin te ningg puyene rind, pugri bu ni Jisas wune mimbig. ");
INSERT INTO kms_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Di burpoq rip ningg tumo di Jisas nikin wute ane tiqe yumbui te si miraq mo. ");
INSERT INTO kms_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yambgriq ni mune nyinge mare mo di nyumo fig te tumuri pe grine quari namb pu yenu muqoind. ");
INSERT INTO kms_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ni te nuqoind di Jisas ni nyumo te ningg wand nand kin te mune nei nimbiny di ni Jisas ningg nari, “Tisa, te qond! Nyumo fig nu wand brequ gudig kin te yabe quari namb pre.” ");
INSERT INTO kms_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Di Jisas oyi ni simbe nindim nari, “God ei nei wumbig. ");
INSERT INTO kms_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nge nungoqi nganyene simbe guduq, wuti iri rand nen ningg nari, ‘Nu yo gherim pe ir yaghe,’ di ninde umbo pe nari yumbo te ni nari kin pugrine puq ren ye ni nei tevi vise segi, tedi yumbo te ni nari kin pugrine puq ren ye. ");
INSERT INTO kms_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pugri bu nge nungoqi simbe guduq, nungoqi yumbo ninge ningg God pengu wundig te nungoqi nde umbo pe wari nungoqi yumbo te wateri ye puq wand, tedi nungoqi yumbo te wateri ye. ");
INSERT INTO kms_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Di nungoqi God ane wand kin tende puayi wuti iri nu yumbo ur brequ nunduw kin te ghat rise pu rise wayequ. Nu ni mai te puaq ndig ei nu nuyi nginy tu wam nas kin ni oyi nu yumbo ur brequ guad kin mai te puaq nunduw.” ");
INSERT INTO kms_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Muq ni mune mo Jerusalem mitari righe di Jisas ni God ningg baj imb wabe nyinge nare no no di prist mingg yumbui, wute Moses ningg lo wute bei meny ye di quayi kiyi ninge ni nde mondo. ");
INSERT INTO kms_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Di ni Jisas pengu mindig mari, “Nu beghi simbe ndug, nu gre pughe ye pe yumbo ren yembe gudiny? Tughe nu ngiq nunduw bu nu yembe ren guad?” ");
INSERT INTO kms_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas oyi nand nari, “Muq nge oyi mune pengu ire nungoqi pengu guduq, di nungoqi nge simbe wundigh tedi nge oyi simbe guduq tughe nge ngiq nindigh bu nge yembe ren gad. ");
INSERT INTO kms_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nungoqi nge simbe wundigh, Jon ni tughe nde gre nateri di ni wute wuye nap? God nde pu nateri o wute nde pu nateri?” ");
INSERT INTO kms_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Di ni kin kin wand mand mari, “Beghi pari God nde pu nateri, tedi ni beghi ningg nari, ‘Pughe kin ningg nungoqi Jon ningg wand te wutungu di nganyene puq wand segi’?” ");
INSERT INTO kms_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Di wute buagi ni riri Jon ni nganyene propet iri, pugri bu ni mari, “Jon ni yembe te wute nde pu nateri,” puq mand wune mamb. ");
INSERT INTO kms_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Te ningg di ni oyi mand kin mari, “Beghi nei bab segi.” Jisas nari, “Nge mune pugrine, nge tughe nde gre pe yumbo ren yembe gidiny kin te nungoqi simbe guduq segi.” ");
INSERT INTO kms_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Muq Jisas ni kopuqu wand pe simbe nindim nari, “Wuti iri ni wain wuny ire yembe nindiny. Ni undaw nipiq, wain yembe mindig kin sunyi ire ngamo nuaq, di baj dobui wute mas wuny yeng muany kin iri tende yembe nindig. Ni pre nand di wute aye nem ni ber manyine wong mand mand mas, di ni wonji tiqe aye pe no. ");
INSERT INTO kms_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dobu wain yi uri mand kin tende puayi ni nikin yembe ye wuti iri tiqi nundog wute ni wain wuny yeng muany ye tende no ei wuny te kin wain yi ninge nare nandi. ");
INSERT INTO kms_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pudi ni yembe ye wuti te mait nase, pug mindig di tiqi mundog si omone mune no. ");
INSERT INTO kms_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Muq ni yembe ye wuti aye mune iri tiqi nundog no, di wuti te mune pugrine ngawu pe mi di yumbo ur isis ni minyuw meng kin te puq men. ");
INSERT INTO kms_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ni wuti aye nganye mune tiqi nundog no, di wuti te ni mi nati. Di ni wute aye nganye buagi tiqi nundom mo, di ninge mi mati di ninge pug mindim. ");
INSERT INTO kms_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Muq ni wute tiqi nundom mo kin te aye irine nas. Di te ni nikin kuwonyimi nikin quan nganye yawo nirang righe ye. Ni kuwonyimi te dobu nganye tiqi nundog no, di ni nei namb kin nari nikin kuwonyimi ne no tedi ni nari kin wand mutungu ye. ");
INSERT INTO kms_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Pudi wute wuny te wong mand mand mas ye ni wand wand mare mari, ‘Wuti nen ei ni kiyi ningg yumbo yumbo buagi nateri ye. Beghi pi nati, ei ni ningg yumbo yumbo te beghi oyi pateri.’ ");
INSERT INTO kms_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Muq ni wo te mait nase mi nati di wuny mbe pu dabo memeri nar no. ");
INSERT INTO kms_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Muq wain wuny kiyi ni pughe sin ei nen? Ni nandi di wute wain wuny wong mand mand mas kin ni mati, di wute aye mune nari mandi wuny te wong mand mand mas, di ni oyi wuny te yeng muany ye. ");
INSERT INTO kms_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nungoqi God ningg wand buk pe vise kin ven wuqond segi bri? ‘Wet te asi wute baj yembe mand ye mari brequ di kring maip no kin te muq wet te baj mingine nas di baj nare. ");
INSERT INTO kms_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yumbui ni ren kin puq nen di beghi nde rar pe yuwon nganye’.” ");
INSERT INTO kms_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Prist mingg yumbui, wute Moses ningg lo wute bei meny ye di Juda mingg quayi kiyi kopuqu wand ven mutungu, ni nei mamb Jisas ni mingg bu simbe nand. Pugri bu ni ngim meri mat ei Jisas taq maimb ningg, pudi ni wute buagi te ningg wune mamb, pugri bu ni si meri yenu di mo. ");
INSERT INTO kms_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dobu ni Parisi di wute ninge Herot nde opu mase ye te tiqi mundom Jisas nde mo ei wandoqi mindig di tende puayi ni wand ninge unje nap tedi mait nase. ");
INSERT INTO kms_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ni Jisas nde mondo di mari, “Tisa, beghi nei bab nu wand nganye kin simbe guad ye. Di nu wute ni pughe sin ren kin te ningg nei kumo guab segi, nu wute nyamb kin o wute nyamb segi kin wand irene simbe gudiny, di nu wand nganye kin pene God ningg yumbo ur te wute bei kueny ye. Beghi Sisar nde takis wong bad kin te tuquine o segi? ");
INSERT INTO kms_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Beghi takis wong bad o wayequ?” Pudi Jisas nei namb wute men wandoqi mand, di ni pengu nindim nari, “Pughe kin ningg nungoqi nge wandoqi wundigh ei nge wand unje kap ningg wari? Nungoqi wet bidi ire wuraq wandi nge gudoq.” ");
INSERT INTO kms_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ni wet bidi ire miraq mondo meng di ni pengu nindim nari, “Wuti tughe ngawu di nyamb ane wet bidi wen nde rise?” Ni oyi mand mari, “Sisar te.” ");
INSERT INTO kms_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Di Jisas ni simbe nindim nari, “Yumbo Sisar te, Sisar weng; di God te, God weng.” Di ni quan nganye puye rind. ");
INSERT INTO kms_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Muq Sadyusi ni mari wute mati kin ni mune mes mewo segi ye. Sadyusi Jisas nde mondo di ni pengu mindig ningg. ");
INSERT INTO kms_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Di ni mari, “Tisa, Moses beghi ningg lo ire pugri ur nindiq, ni nari wuti iri ni kise nyumbueg ire nitaqi, pudi wo segine nati di ni ngam te si niraq wus, tedi ni kiqam te ei mune kise ngam te nitaqi. Ni mune kise ngam te nitaqi, wo niraw di wo te kise nati kin ni te. ");
INSERT INTO kms_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Muq wuti iri ni wo 7-pela pu mas. Wo iri ni nyumbueg ire nitaqi di ni wo ire kus segine ni nati. ");
INSERT INTO kms_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Di ni wo aye mune nyumbueg te nitaqi, pudi ni mune pugrine wo segine ni nati. Di wo aye mune nyumbueg te nitaqi kin ni mune pugrine. ");
INSERT INTO kms_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ni wo 7-pela te ni buagi anene wo ire kus segine mati. Di dobu nyumbueg te mune wuti. ");
INSERT INTO kms_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wute 7-pela ni wute te mitaqi. Pugri bu otiwo wute mati kin buagi mes mewo kin tende puayi tedi nyumbueg wen ni tughe ningg ngam ei wus?” ");
INSERT INTO kms_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas oyi nand nari, “Nungoqi unje wap. Te pugri nungoqi God ningg wand buk pe rise kin di God ningg gre te nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te pugri wute mati kin mune mes mewo ye tende puayi ni ngam ruso o oyi oyi ngam mawo ruso segi. Ni angelo nginy tu wam mas kin pugrine ris ye. ");
INSERT INTO kms_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wute mati kin mune mes mewo. Nungoqi Moses ningg buk pe Moses ni nyumo wase naimb nuqoind kin pugri di God ni Moses ningg nari, ‘Nge Abraham ningg God, Aisak ningg God di Jekop ningg God,’ ni puq nand kin te nungoqi wuqond o segi? ");
INSERT INTO kms_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God ni wute mati ye ni mingg God segi, ni wute urupuine mas ye ni mingg God. Nungoqi unje gri nei wamb.” ");
INSERT INTO kms_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ni wand wand yemu di wuti iri ni Moses ningg lo wute bei neny kin ni nondo di ni wand mand kin te nutungu. Di ni nuqond kin te Jisas ni yuwonne oyi nand. Pugri bu ni Jisas pengu nindig nari, “Lo pughe ye bu yumbui nganye?” ");
INSERT INTO kms_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas oyi nand nari, “Lo yumbui nganye kin taq pugri: ‘Israel buagi nungoqi wutungu Yumbui beghi God, ni irine beghi Yumbui, aye segi. ");
INSERT INTO kms_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nu Yumbui nunon God te ei nunde umbo pe, ququ pe gri, nei pe di gre pe yawo rang righe.’ ");
INSERT INTO kms_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Di aye tende dobu taq pugri: ‘Nu non ghimbi yawo kurany righe kin pugrine wute aye yawo rany righe.’ Lo aye lo teri ren nde mune nganye yumbui kin rise segi.” ");
INSERT INTO kms_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wuti te oyi nand nari, “Tisa, nu yuwonne oyi guad. Nu kuari God aye segi irine puq guad kin te tuquine. ");
INSERT INTO kms_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Muq beghi nde umbo pe, nei pe, di gre pe God yawo birag righe, di beghi bon ghimbi yawo pirany righe kin pugrine wute aye yawo pirany righe. Yumbo ren kin te quan nganye yumbui di umo alta pe bade namb kriq ruso kin di umo bab riti God beg kin te ane tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas ni nuqond wuti te ni yuwonne wand nand, di simbe nindig nari, “Nu wute God nde si nambu ris kin tende wonji kuas segi.” Di tende pu ruso kin tende puayi wute aye mune Jisas wand ninge pengu mindig wune mamb. ");
INSERT INTO kms_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas ni God ningg baj pe tende God ningg wand wute bei neny neny yenu di ni pengu nand nari, “Pughe gri ate wute Moses ningg lo wute bei meny ye ni mari Kraist te Devit ningg wo? ");
INSERT INTO kms_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pudi Devit nikinne Ququ Yuwon Ye nei neng di ni nari, Yumbui ni nge yumbui ningg nari, ‘Nge nde si tuan pene ghas ruso ruso nge nu veri nunde nyinge tingi kawo mas.’ ");
INSERT INTO kms_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit nikinne ni Yumbui puq nindig, tedi pughe gri ei ni Devit ningg wo?” Wute buagi ni chumbuai ane ris ni wand nand kin te rutungu. ");
INSERT INTO kms_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas ni wand bei neny neny di ni simbe nindiny nari, “Nungoqi wute Moses ningg lo wute bei meny ye ni mingg ei yeng wawo yuwon. Ni nei mamb kin ni nyamb kin, pugri bu ni pripri chongo dobui kin ei mare righe pre di wute nde rar pe nyinge mare mo yawo kurem ye. Di ni wute buagi pripri rikur kin sunyi pe tende mo di wute ni ei chumbuai kin wand rem yawo kurem ye. ");
INSERT INTO kms_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Di God yumbui nyamb mirang kin baj pe mo di wute nyamb kin mas ye sunyi pe tende ei mas yawo kurem ye. Di mir yumbui pe mo di wute nyamb kin mas ye sunyi pe ei mas yawo kurem ye. ");
INSERT INTO kms_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nyumbueg ngaim mati pre kin nyarimo wandoqi mindiny di ni baj mitanyri. Di Yumbui pengu mindig kin tende puayi wand dobui nganye mand ei wute ruqond ningg mari ye. Wute men kin otiwo di ni mai quan nganye mare ye.” ");
INSERT INTO kms_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas ni wute yumbo God reng kin ruwo ris ye bokis pe opu gri tende nas di wute wet bidi rire rundo ruwo righe kin te nuqond nuqond nas. Wute nganye buagi wet bidi quan rise kin ni rundo wet bidi yumbui yumbui ruwo righe. ");
INSERT INTO kms_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pudi wute ire wet bidi segi kin ni ngaim nati ye ni wundo di wet bidi ambo ye woju teri wuwo righe. Wet bidi woju teri te ni wan toea kin pugri. ");
INSERT INTO kms_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Muq Jisas nikin wute te ngam niram mondo di simbe nindim nari, “Nge nungoqi nganyene simbe guduq, wute ngaim nati di yumbo segi kin wen ni wet bidi quan nganye wet bidi bokis pe wuwo righe, wute aye segi. ");
INSERT INTO kms_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wute buagi ren ni yumbo quan rise bu ninge ruwo righe di ninge nikin rise. Pudi nyumbueg wen ni wet bidi segi kin bu wet bidi ambo ye woju terine nikin mir wong wund ningg rise kin tene wuwo righe.” ");
INSERT INTO kms_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas ni nikin wute ane God ningg baj si miraq mo mone di nikin wute te kin ye iri ni simbe nindig nari, “Tisa, nu wet yuwon di baj yuwon te qond. Ni yuwon nganye.” ");
INSERT INTO kms_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Di Jisas oyi nand nari, “Nu baj buagi ren qond. Otiwo wute mandi baj ren bir mawo di wet men mune iri aye nde wam nas wuqoind segi ye. Ni quan buagine bir ir maghe di kin kin mas ye.” ");
INSERT INTO kms_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas ni God ningg baj wuse pe pu oyi gri te rand oliv pe tende nas, di Pita, Jems, Jon, di Andru ni waghine Jisas pengu mindig mari, ");
INSERT INTO kms_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nu beghi simbe ndug, yumbo ren kin pughe puayi ei puq ren ye? Beghi yumbo ur pughe kin buqod ei nei bab yumbo buagi ren kin puq ren yamb tumo?” ");
INSERT INTO kms_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Di Jisas ni oyi simbe nindim nari, “Nungoqi yeng wawo yuwon. Eti wute ninge mandi nungoqi wandoqi munduq di ni wand wutungu. ");
INSERT INTO kms_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Te pugri wute wandoqi kin nganye buagi nge nde nyamb pe mandi di mari, ‘Nge Kraist’ di wute nganye buagi ni mingg wand rutungu. ");
INSERT INTO kms_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Di nungoqi yeng wundi kin wand wutungu di yeng kin yumbo riri wutungu, pudi nungoqi te ningg wune wamb wayequ. Yumbo ren kin te ruwi ye, pudi ngeri omo kin te wundi segine. ");
INSERT INTO kms_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantri ire mes mewo kantri aye ane mege, di king iri nikin wute ane mes mewo king aye nikin wute ane mege, di tiqe ninge pe mir segi. Di tiqe ninge pe te titwuye naghe. Yumbo ren kin te wute wo pe wuso ningg yuqo puate rew kughe kin pugri. ");
INSERT INTO kms_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nungoqi yeng wawo yuwon pu ei was. Te pugri wute nungoqi kaunsil nde si pe mequ wondo, di God yumbui nyamb mirang kin baj pe tende mumbuequ ye. Di nungoqi nge ningg wute pugri bu ni nge nyamb brequ mindigh ningg mari di nungoqi mitaqu king di gavman kin yumbui nde mo ninde rar pe muaqu yequ, ei wand nganyene kin simbe wand. ");
INSERT INTO kms_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Di God ningg wand yuwon ye te tiqe buagi mo simbe mand pre ei ngeri te wundi. ");
INSERT INTO kms_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Di pughe puayi nungoqi mitiqu wase miraqu mo taq mumbuqu ningg nungoqi prine wand oyi simbe wundim ye te ningg yivany ware wayequ. Nungoqi wand pughe ye nei pe vindi kin tene simbe wand, te pugri wand ren kin te nungoqi nonne simbe wand segi, pudi Ququ Yuwon Ye ni gri simbe nand. ");
INSERT INTO kms_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Kise kiqam ni kinne oyi oyi veri nde si pe mi mondo di mi mati. Di kiyi wo ane mune pugrine. Wo ni nikinne kiyi kumo ane ker ruwo di wute aye simbe rindim ei ni kiyi kumo mamb riti. ");
INSERT INTO kms_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nungoqi nge ningg wute pugri bu wute buagi nungoqi yambu mirequ, pudi wute tughe ni gre pu yeru ruso ruso qi wen pre, tedi God ni nateri. ");
INSERT INTO kms_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Otiwo yumbo brequ nganye God ningg baj brequ wunduw ye ire yequ wundoq ye.” (Nu wuti wand ven guqod ye nu wand puate ei oghine nei mbiny.) “Te muqdi wute Judia opu ris kin te wu rise rand pe ei riwo ruso. ");
INSERT INTO kms_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wuti baj wam nas kin ni mune baj pe nar no yumbo ninge nateri wayequ. Ni brequne wu nase no. ");
INSERT INTO kms_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wuti iri wuny mbe yenu kin mune nambu no chongo aye nitaqwi wayequ. Ni brequne wu nase no. ");
INSERT INTO kms_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tende puayi nyumbueg wo ane ris kin di ninge ni wo wokuandi ne ris ye ni mai quan nganye rire ye. ");
INSERT INTO kms_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nungoqi God pengu wundig ei yumbo ren kin ngeri uyi kin tende puayi puq ren segi. ");
INSERT INTO kms_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te pugri asi God qi di yumbo buagi yembe nindiny kin tende puayi pu rindi muq mai yumbui ren kin rindi segi. Di otiwo mune mai ren kin segi. ");
INSERT INTO kms_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yumbui ni wute mai rire kin ngeri te pend nawo puayi rise segi, tedi wuti iri ni gre nand nas tuqui segi. Pudi ni wute si numbom di nap mo kin ni mingg nari bu ngeri te pend nawo puayi rise. ");
INSERT INTO kms_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tende puayi wuti iri nandi nari, ‘Kraist nen yenu,’ o nari, ‘Ni te no yenu.’ Nungoqi ni wand te wutungu wayequ. ");
INSERT INTO kms_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Te pugri Kraist wandoqi kin di propet wandoqi kin ni mandi di yumbo ur gre ye isis yembe mindiny. Ni puq men ei tuqui tedi wute Yumbui nap ruso kin te wandoqi mindiny di ir righe. ");
INSERT INTO kms_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pugri bu nungoqi yeng wawo yuwon. Nge yumbo buagi ren ningg muqne simbe guduq pre muqdi yumbo te kin puq ren. ");
INSERT INTO kms_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pudi tende puayi wute mai isis te kin rire pre tende dobu ‘Nginy burpoq nap, di irew mune ti wuri segi, ");
INSERT INTO kms_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tomnji nginy tu pe pu bi ir mi, di yumbo gre kin nginy tu pe yeru kin tit rip.’ ");
INSERT INTO kms_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tende puayi di wute ni wuti God nde pu nandi wuti nganye nas kin ni wuye quari pe yenu ruqoind. Ni gre yumbui di ti ane nandi. ");
INSERT INTO kms_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Di ni angelo te tiqi nundom tiqe buagi mo nikin wute ni nap ruso pre kin te mirir. Ni wute qi cheq pe pune mirir rir mo qi cheq opu gri. ");
INSERT INTO kms_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nungoqi nyumo fig ni yumbo ur te wuqond di tende pu nei wateri di nei wamb tuqui. Nyumo fig ni muange te uyi mare di raqe riyi tedi nungoqi nei wamb te wuye wundi kin ngeri te muq tumo rind. ");
INSERT INTO kms_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Te kin pugrine otiwo yumbo nge simbe gad ye te kin puq ren, tedi nungoqi nei wamb te pugri wuti God nde pu nandi wuti nganye nas kin ni mune nandi kin ngeri te tumo nganye rind, ni ngimrawu ne yenu. ");
INSERT INTO kms_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nge nungoqi nganyene simbe guduq, wute tit muq ris kin ren ni riti segi, risne di yumbo te kin puq ren. ");
INSERT INTO kms_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nginy tu di qi ane ni pre ye, pudi nge wand te pre segi ye. ");
INSERT INTO kms_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pudi wuti iri ni nei namb pughe puayi o aua pughe ye tende ei wuti God nde pu nandi wuti nganye nas ye ni mune nandi kin te ni nei namb segi. Angelo buagi wam kin ni mune nei mamb segi, God ningg wo mune nei namb segi, wuyi irine nei namb. ");
INSERT INTO kms_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yeng wawo yuwon. Rar wat yuwon. Pughe puayi ei ngeri te kin rindi ye te nungoqi nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yumbo ren kin te wuti iri ni tiqe aye pe no kin pugri. Ni baj te si nare vise di nikin yembe ye wute ni baj te yeng muany pu mas. Di ni ire ire nikin yembe te nem, di wuti ngimrawu nas kin te simbe nindig di ni mune nandi kin te ningg rar rar yenu. ");
INSERT INTO kms_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pugri bu nungoqi mune yeng wawo yuwon, te pugri baj kiyi ni mune nandi kin ngeri te nungoqi nei wamb segi. Ni yuram nandi, o bur mingi nandi, o wapiqu mari mari nandi, o nginy nowi ni pre nandi. ");
INSERT INTO kms_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ni nandi di nungoqi segi ruqo ruqo wase nundoqu wayequ. ");
INSERT INTO kms_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wand nungoqi simbe guduq kin ren nge wute buagi ane ningg simbe gad. Rar wat yuwon.” ");
INSERT INTO kms_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Muq nginy temine pre tende dobu di God Israel mingg wo rar nuqond mas kin di bret yis segi kin me kin ngeri te nei mimbiny ye. Di prist mingg yumbui di wute Moses ningg lo wute bei meny ye ane ni pughe gri Jisas waghi grine mait nase di mi nati kin ngim meri mat. ");
INSERT INTO kms_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pudi ninge mari, “Ngeri yumbui nei bibiny kin tende puayi puq pen wayequ. Beghi puq pen tedi wute buagi beghi ker ruangu.” ");
INSERT INTO kms_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pudi Jisas ni Betani ne nas kin tende puayi ni wuti iri Saimon, wuti asi leprosi niraq kin, ninde baj pe mir nand. Di nyumbueg ire wel yuwon nganye iri nyumo nad pe yembe mindig kin te botol ane wuri wundo. Wel te wet bidi quan pe wong wuind. Botol te wet yuwon nganye iri alabasta puq mindig kin tende pe yembe mindig ye. Ni wuri wundo botol mim te gure wuwi di wel te Jisas nde ngawu pe groq wuind. ");
INSERT INTO kms_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wute ninge tende mas kin ni te muqond di umbo ker mawo di kin kin wand mand mari, “Pughe kin ningg ni wel te segi mewuri no? ");
INSERT INTO kms_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Beghi wel te wute aye pem wong maind, tedi wet bidi quan pateri kin tuqui. Wet bidi te kin te wuti iri yembe nand nand ruso ber ire pre ni wet bidi nateri kin ane tuquine. Di wet bidi te oyi wute yumbo segi kin te peny.” Di ni wute te wand isis simbe minduw. ");
INSERT INTO kms_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Di Jisas nari, “Nungoqi ni rar wundoq. Pughe ningg nungoqi ni yumbo puq wen kin te ningg segi puq wand? Ni yumbo ur oghi ye nge nde yembe wundiny. ");
INSERT INTO kms_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wute yumbo quan segi kin nungoqi ane was ye, di pughe puayi ni ghav wundiny ningg te segine otiwo ghav wundiny tuqui. Pudi nge nungoqi ane pas nganye segi ye. ");
INSERT INTO kms_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ni yumbo puq wen tuqui kin te bu puq wen. Ni wel ngende ghimbi pe groq wuind kin te otiwo nge kati ngamo pe ko ye te ningg bu ni muq pugrine sir wuip. ");
INSERT INTO kms_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nge nungoqi nganyene simbe guduq te pugri otiwo wute mo tiqe buagi te wand yuwon ye bir mawo kin tende puayi wute wen ni yumbo yembe wundiny kin ren anene simbe mand ye. Ni pugri puq men ei nyumbueg yumbo ren yembe wundiny kin wen anene nei rumbuw.” ");
INSERT INTO kms_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Muq Judas Iskariot, ni Jisas ningg wute 12-pela te kin ye iri, ni prist mingg yumbui nde no di ni Jisas ninde si pe ni nondo kin wand simbe nindim. ");
INSERT INTO kms_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Prist mingg yumbui ni te mutungu di chumbuai mand di ni wet bidi pe wong maind ye puq mand. Pugri bu Judas ni Jisas ninde si pe ni nondo kin ngim meri nat. ");
INSERT INTO kms_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Muq Juda ni bret yis segi kin riq ye nginy ye nawo ye te ningg di nginy te ninggne ni God Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny ningg sipsip mamb ye. Di Jisas nikin wute ni pengu mindig mari, “Nu nei guab ye beghi muainde ei mir yembe bidiny, di nu guadi ane mir bad ei God Israel mingg wo rar nuqond mas kin ngeri te nei bibiny?” ");
INSERT INTO kms_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Di Jisas ni nikin wute te temi yeri nindim nari, “Nungoqi tiqe yumbui pe tende war wo di wuti iri wuye os niraq nandi kin te wuqoind ye. Di nungoqi wuti te nande pe dobu waru. ");
INSERT INTO kms_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nungoqi wo di wuti te baj ire ningg nar no muqdi nungoqi wondo baj kiyi te pengu wundig wari, ‘Tisa nari nu wute wonji pu mandi kin ni mase ye sunyi kuap ruso kin te muai bu? Ni di nikin wute ane Yumbui Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny kin mir mand ningg.’ ");
INSERT INTO kms_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Di wuti te nungoqi sunyi yuwon ire baj wam wiyo yequ kin ei bei neuq ye, di yumbo buagi baj pe tende rise. Nungoqi tende ei mir bad kin te ningg sir wap.” ");
INSERT INTO kms_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Muq Jisas ningg wute temi te ni tiqe yumbui pe tende mar mo di yumbo buagi Jisas nari kin pugrine puq ren muqond. Di ni mir te kin sir map. ");
INSERT INTO kms_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Muq burpoq rip di Jisas nikin wute 12-pela pu ane dobu maru. ");
INSERT INTO kms_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ni tebol pe mas mir mand mand di Jisas ni simbe nindim nari, “Nge nungoqi nganyene simbe guduq, nungoqi kin iri wuti nge temu mir bad kin ni nge veri nde si pe ni godo ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jisas nikin wute ni te mutungu di ni yivany mare di ire ire Jisas simbe mindig mari, “Nu nge ningg bri kuari.” ");
INSERT INTO kms_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Di Jisas oyi nand nari, “Wuti te nungoqi 12-pela te kin ye iri, di ni wuti nge temu temune bret nyeng pe peq wughe kin te. ");
INSERT INTO kms_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wuti God nde pu nandi wuti nganye nas kin ni nati kin te God ningg buk puq wund kin pugrine ei nati ye. Pudi wuti pughe ye ni wuti God nde pu nandi wuti nganye nas ye te veri nde si pe ni nondo ye ni mai yumbui nganye niraq ye. Wuti te kin kumo wuri wundi segi tedi yuwon nganye.” ");
INSERT INTO kms_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ni mir mand mand mas, di Jisas ni bret nitaqwi, Yumbui chumbuai nindig pre, bir nuaq nikin wute te nem di nari, “Nungoqi wen wutaqwi, wen nge ghimbi.” ");
INSERT INTO kms_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te pre muq ni wain mune kap ane neti nowi, Yumbui chumbuai nindig pre, nem di ni buagi ane wain kap te irene maq. ");
INSERT INTO kms_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Di ni simbe nindim nari, “Nen nge yavi di yavi wen te God asi Moses ane wand taq mamb kin te gre weny. Di yavi wen te wute nganye buagi ningg ir wi. ");
INSERT INTO kms_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nge nungoqi nganyene simbe guduq, te pugri nge muq wain nen mune ke segine ruso ruso otiwo nginy yumbo buagi God nde si nambu rise kin tende puayi di wain urupui kin ke.” ");
INSERT INTO kms_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ni mir mand pre dobu yuwo ire mari. Di yuwo mari pre, rand nyumo oliv yemu kin tende mo. ");
INSERT INTO kms_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Di Jisas ni simbe nindim nari, “Nungoqi quan buagine nge wuqoind yambu wari di si weri ye, te pugri wand ven kin buk pe vise pre. Wand ven taq pugri, ‘Nge wuti sipsip yeng nuany kin te ki di sipsip bure ire ire ruso ye.’ ");
INSERT INTO kms_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pudi nge mune kes kewo pre dobu te nge ye kawo Galili ko di nungoqi waru ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Di Pita nari, “Wute buagi wu mase mo, pudi nge wu kase ko segi ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Di Jisas oyi nand nari, “Nge nu nganyene simbe guduw, muq nu puq guad. Pudi muq bur wapiqu nari tevi nand segine di nu ghari nu nge nei gubigh segi puq ghand tevi ire pu ghand ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pudi Pita buid nganye nap nari, “Piyi wute nge ane mi kati ningg, pudi nge wandoqi gad kari nge nu nei gubuw segi puq gad segi ye.” Di Jisas nikin wute aye te ni mune pugrine puq mand. ");
INSERT INTO kms_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Muq ni mong puch ire Getsemani puq mand kin tende mo di Jisas nikin wute te simbe nindim nari, “Nungoqi ven ne was di nge ko God temu wand.” ");
INSERT INTO kms_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Di ni Pita, Jems di Jon pugri pu natemi ane mo, di ni umbo quan nganye mai kuyo. ");
INSERT INTO kms_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Di ni temi ire pu te simbe nindim nari, “Nge umbo pe quan nganye yivany kare di yivany ven ningg kati ye tuqui. Nungoqi ven nde yeng wawo pu was.” ");
INSERT INTO kms_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ni musoqne kring nondo di qi pe me no nase di God pengu nindig ei ni ngeri te kin puaq nand. ");
INSERT INTO kms_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ni nari, “Wuyi, nge wuyi, nu yumbo buagi puq kuen ye tuqui. Nu nge kap wen puaq ndiq wuso. Pudi nu nge nde nei pe puq yen wayequ, nunon nde nei pe puq yen.” ");
INSERT INTO kms_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pre muq nikin wute mas kin sunyi pe mune nandi, ni ruqo pu mase nuqond di nari, “Saimon, nu ruqo bu kuase? Nu musoq kuas, yeng kuawo aua ire kin tuqui segi bri? ");
INSERT INTO kms_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nungoqi wes pu was, yeng wawo, di Yumbui pengu wundig ei ququ brequ nungoqi wandoqi nunduq yumbo ur brequ wand segi. Nungoqi nde nei pe wari nungoqi yumbo te puq wen yawo kureuq, pudi nungoqi ghimbi te buid segi.” ");
INSERT INTO kms_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Di Jisas ni mune no God temi wand, di ni asi wand nand kin pugrine mune simbe nand. ");
INSERT INTO kms_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Di ni munene nikin wute nde nondo, ni quan nganye ruqoi kurem rar mai riwo di ruqo pu mase nuqond. Ni mune buraq nindim mes mewo di ni minyuw mati, wand mand ye koruso. ");
INSERT INTO kms_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Di ni no pre mune nandi simbe nindim nari, “Nungoqi ruqo pune bu wase? Muqdi pre. Ngeri te muq wundi pre. Te wuqond. Wuti God nde pu nandi wuti nganye nas kin ni muqdi wute yumbo ur brequ mand kin ninde si pe mi nondo. ");
INSERT INTO kms_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wes wewo. Be po. Wuti nge veri nde si pe ni godo ye be nandi.” ");
INSERT INTO kms_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas ni wand nand nandne yenu di Judas, Jisas nikin wute 12-pela te kin ye iri, ni nondo raqe no. Di wute ninge mame dobui kin di wase puayi ane mare ni ane mondo. Wute men te prist mingg yumbui, wute Moses ningg lo wute bei meny ye di Juda mingg quayi kiyi ni tiqi mundom mondo. ");
INSERT INTO kms_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Di wuti Jisas veri nde si pe ni nondo ye ni wute ni ane mondo kin te ane wand taq mamb, di ni yumbo pughe ye yembe nindiny kin te ni simbe nindim pre, ni nari, “Wuti nge song gireg kin te Jisas ne. Wait nase wutanyi wo di yeng wang wangne ei yenu.” ");
INSERT INTO kms_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Muq Judas ni Jisas nde nondo di Jisas ningg nari, “Rabai” di song nireng. ");
INSERT INTO kms_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Di wute Judas ane mondo kin ni mondo Jisas mait nase. ");
INSERT INTO kms_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Muq Jisas nikin wute ninge tumone yemu ye te kin iri ni mame dobui qo naimb nandi di prist mingg yumbui mingg yumbui ni yembe ye wuti te iri ange di nuang ir wi. ");
INSERT INTO kms_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Di Jisas ni wute te simbe nindim nari, “Nge wute kitami ko gavman ane yeng bri bad ningg bu nungoqi mame dobui di wase puayi ane ware wandi nge wait kase ningg? ");
INSERT INTO kms_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nge nginy manyi nungoqi ane pas, God ningg baj imb pe tende wand wute bei keny, di nungoqi tende puayine nge wait kase segi. Pudi ren kin God ningg wand buk pe vise kin te ane tuquine ei puq ren ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Muq Jisas nikin wute ni Jisas si meri di wu mase mo. ");
INSERT INTO kms_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wuti ambonye iri ni chongo ire taq nimbiq di chongo aye ninge nare righe segi, ni Jisas nde dobu naru. Di ni ambonye te mait nase ningg pudi ni chongo bure wus, ");
INSERT INTO kms_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ir wuti wughe pu wuse di ni umbo gawo omone wu nase no. ");
INSERT INTO kms_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Muq ni Jisas mitanyi prist mingg yumbui ni yumbui nde mo. Di prist mingg yumbui buagi di quayi kiyi di wute Moses ningg lo wute bei meny ye ni buagi ane mo ire pe mikur. ");
INSERT INTO kms_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ni Jisas mitanyi mo di Pita dobu naru. Pudi ni wonji wonjine naru, di ni none no prist mingg yumbui ni yumbui ningg baj kin imb pe tende nar no. Ni tende nas di wute baj yeng muany kin ni ane wase suqo map map mas. ");
INSERT INTO kms_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Muq prist mingg yumbui di kaunsil buagi ni Jisas mi ningg ngim meri mat. Ni ngim meri mand ei wand pughe ye te mai viyo ei Jisas mi nati ningg. Pudi ni Jisas mi kin ngim ninge muqond segi. ");
INSERT INTO kms_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wute nganye buagi ni Jisas ningg wandoqi kin wand ninge simbe mand pudi ni wand aye ni wand te gre meny kin segi. ");
INSERT INTO kms_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Muq wute aye ninge mes mewo di wandoqi kin wand ren simbe mand mari, ");
INSERT INTO kms_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Beghi putungu putungu ne ni nari, ‘Nge God ningg baj wute gri yembe munduw kin wen bir kuaq di nginy temi ire pre aye wute gri yembe munduw segi kin mune yembe guduw’.” ");
INSERT INTO kms_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pudi wand ven mune pugrine, ni wand irene mand segi. ");
INSERT INTO kms_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Muq prist mingg yumbui mingg yumbui ni nes newo yenu di Jisas pengu nindig nari, “Nu ni wand te oyi gudim ye o segi? Nu yumbo puq kuen kin te ningg simbe mand ye te pughene bri?” ");
INSERT INTO kms_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pudi Jisas ni wand segine yenu di ni oyi nindig segi. Di prist mingg yumbui mingg yumbui ni munene pengu nand nari, “Nu Kraist, wuti yuwon nganye wute buagi ni irine yumbui nyamb rirang ye ni ningg wo bri?” ");
INSERT INTO kms_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas oyi nand nari, “Nge teneqa. Di nge wuti God nde pu gadi wuti nganye kas ye nge wuti gre nganye kin ninde si tuan pe opu kas di nginy tu pe kin wuye quari pe gri gadi wuqoind ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Muq prist mingg yumbui mingg yumbui ni nikin chongo bir nawo di nari, “Pughe kin ningg beghi wand aye ningg mune ghimbi pawo? ");
INSERT INTO kms_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nungoqi ni God wand brequ nindig kin te wutungu pre. Muq nungoqi pughe gri nei wamb?” Di ni quan buagine mari, “Ni nati tedi yuwon.” ");
INSERT INTO kms_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Di wute ninge som map mirang righe, chongo bidi pe rar buag mirang pre pug mindig di simbe mindig mari, “Be simbe ghand, wuti tughe bu nu ni?” Di wute baj yeng muany yemu kin ni mitanyi mo di pug mindig. ");
INSERT INTO kms_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ni tingi imb pe tende naghe nas muq prist mingg yumbui mingg yumbui ni yembe ye nyumbueg ire ni nas pe tende wundo. ");
INSERT INTO kms_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Di ni Pita wase suqo nap nap nas wuqoind di ni Pita wuqoind wuri wuse. Di wuri, “Nu Jisas Nasaret kin te ane yequ ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pudi Pita segi puq nand nari, “Nge nei gab segi. Nu yumbo pughe kin ningg wand guad?” Ni puq nand di baj nganye pe mar mo kin ngimrawu tende nyinge nare nondo. ");
INSERT INTO kms_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Muq nyumbueg yembe ye te ni Pita mune tende yenu wuqoind di wute ninge tende yemu kin te simbe wundim wuri, “Wuti nen ni ane ye.” ");
INSERT INTO kms_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Di Pita ni mune segi puq nand. Musoq big rip pre wute ninge Pita ane tumo tumone yemu kin ni mari, “Nganyene nganye nu ni ane ye, te pugri nu Galili kin.” ");
INSERT INTO kms_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Di Pita ni God nde nyamb pe wand gre neny nari, “Nge wuti nungoqi wari kin nen nge nei gibig segi. Nge wandoqi gad tedi piyi God nge brequ nindigh.” ");
INSERT INTO kms_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Di opu brequne wapiqu nari tevi nand. Muq Pita ni Jisas asi wand simbe nindig kin te mune nei nimbiny. Jisas nari, “Wapiqu nari tevi nand segine di nu ghari nu nge nei gubigh segi puq ghand tevi ire ghand.” Di Pita ni quanji nand. ");
INSERT INTO kms_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pend ruso burane nganye prist mingg yumbui, quayi kiyi, wute Moses ningg lo wute bei meny ye, di kaunsil buagi ni nei ire taq mamb. Ni Jisas taq maimb pre mitanyi mo Pailat nde si pe mi nondo. ");
INSERT INTO kms_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Di Pailat ni Jisas pengu nindig nari, “Nu Juda mingg king bu?” Di Jisas oyi nand nari, “Nu kuari nge Juda mingg king, te tuquine.” ");
INSERT INTO kms_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Di prist mingg yumbui ni mari ni yumbo nganye buagi yembe nindiny. ");
INSERT INTO kms_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pudi Jisas ni wand segine yenu. Pugri bu Pailat ni mune pengu nand nari, “Nu ni wand mand ye te oyi gudim ye o segi? Ni nu yumbo brequ nganye buagi yembe gudiny ye te ningg simbe mand.” ");
INSERT INTO kms_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pudi Jisas ni mune pugrine wand segine yenu, di Pailat ni te kin ningg nei kumo namb. ");
INSERT INTO kms_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Di Pailat ni yumbo ur ire te pugri, ni mir yumbui yembe munduw kin tende puayi te ni wute taq pu yemu ye te kin iri si neri no ye, di te kin te wute gri ei wuti te nyamb rirang. ");
INSERT INTO kms_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wuti iri Barabas puq mindig kin ni ane taq pu yenu. Asi wute ninge gavman ane bir mawo kin tende puayi ni wuti iri ni nati di te ningg taq maimb pu yenu. ");
INSERT INTO kms_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wute buagi riwo rundo di Pailat ni pripri wute taq pu yemu ye te kin ye iri si neri no ye te kin ningg simbe rindig. ");
INSERT INTO kms_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Di Pailat ni pengu nindiny nari, “Nge nungoqi Juda mingg king nen si keri nondo ningg bri wari?” ");
INSERT INTO kms_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ni nei namb pre te pugri prist mingg yumbui ni Jisas yambu mireng bu ninde si pe meng. ");
INSERT INTO kms_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pudi prist mingg yumbui ni wute simbe mindiny ei ni Pailat simbe rindig di ni Barabas ei si neri neyi ni. ");
INSERT INTO kms_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Di Pailat mune pengu nindiny nari, “Te muq wuti nungoqi Juda mingg king puq wundig kin nen pughe sin ei geg?” ");
INSERT INTO kms_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Di ni ngam mare rundo mari, “Kruse pe qungu wi nati.” ");
INSERT INTO kms_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Muq Pailat oyi ni pengu nindim nari, “Ni yumbo ur brequ pughe ye yembe nindiny?” Pudi ni mune ngam rire rundo riri, “Kruse pe qungu wi nati.” ");
INSERT INTO kms_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Di Pailat ni wute buagi chumbuai rind ningg nari di Barabas si neri neyi ni, di Jisas rar nuqoind pug mindig di soldia mitanyi mo ei kruse pe qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Muq soldia ni Jisas mitanyi gavman nde baj pe mar mo, di ami buagi aye te mari mo irepene mikur. (Baj te ni pretorium puq munduw.) ");
INSERT INTO kms_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ni chongo ambo kin ire king mingg chongo gib wumb kin mirang wughe pre, di sare quat kin meti nowi king hat kin pugri muet maimb pre ngawu pe mireng naghe. ");
INSERT INTO kms_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Di ni Jisas ningg pugri puq mand mari, “Juda mingg king, nu kuas kuas otiwo ye.” ");
INSERT INTO kms_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ni gij puayi iri meti nowi ngawu pe mi, som mirang righe di king kin pugri sungomyu gure muang. ");
INSERT INTO kms_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Di ni pugri perei mindig pre ni chongo ambo kin te ir muang di ni nikin chongone mune mirang wughe. Muq mune mitanyi meyi mi ei mo kruse pe qungu mi nati ningg. ");
INSERT INTO kms_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ni Jisas mitanyi mo mo di wuti iri Saimon puq mindig kin ni nikin yembe pe yenu pu nandi. Saimon Sairini kin ni Aleksander Rupus temi kiyi. Di soldia ni mari di Saimon ni Jisas ningg kruse te niraq. ");
INSERT INTO kms_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ni Jisas mitanyi sunyi ire Golgota puq munduw kin tende mo. (Nyamb ven ni puate te ngawu ngape tiqe.) ");
INSERT INTO kms_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Muq ni wain di ghimbi yuqo kin marasin ire mur puq munduw kin te ane quang mimbiq pre meng naq ningg, pudi ni yambu nari. ");
INSERT INTO kms_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Muq ni kruse pe qungu mi nati. Di ni chongo te bir mawo ire ire materi ningg. Te ningg di ni satu griny mand ei muqond wuti tughe ei chongo te nateri. ");
INSERT INTO kms_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ni Jisas qungu mi nati kin te 9 kilok burane pugri ye pe. ");
INSERT INTO kms_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Di ni wand pughe ye te ningg qungu mi nati kin te anene ur mand pu rise. Ni pugri ur mand, “Juda mingg king.” ");
INSERT INTO kms_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Di ni wute nyungu kin temi anene qungu mi mati pu yemu, iri Jisas nde si tuan pe opu di iri si qaqi pe opu. ");
INSERT INTO kms_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wute nganye buagi te gri rundo ruso kin ni Jisas wand peq rindig, ngawu uring rind di riri, “Nu wuti pugri kin bu kuari nu God ningg baj bir kuaq pre nginy temi ire ninggne mune yembe guduw. ");
INSERT INTO kms_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Muq kruse si raq ghati yi ei nunon ghimbine ghav ndiny.” ");
INSERT INTO kms_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wute buagi ni puq rind kin pugrine prist mingg yumbui di wute Moses ningg lo wute bei meny ye ni mune nikinne oyi oyi wand mand mari, “Ni wute aye ghav nindiny, nikin ghimbine ghav nindiny tuqui segi. ");
INSERT INTO kms_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Muq Kraist Israel mingg king nen rar buqoid nikinne kruse si niraq nati ni ei pari ni nganyene God ningg wo.” Di wute aye kruse pe qungu pu yemu kin ni anene Jisas wand peq mindig kin wand nganye buagi nganye simbe mand. ");
INSERT INTO kms_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Di 12 kilok kin pugri bur ir kui yengu ruso 3 kilok yuram. ");
INSERT INTO kms_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Di 3 kilok kin tende puayi Jisas ni quan kumone nari, “Eloi Eloi lama sabaktani?” Wand ven kin puate te pugri, “Nge God, nge God, pughe kin ningg nu nge si kueri?” ");
INSERT INTO kms_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wute ninge tende yemu kin wand ren mutungu di mari, “Te wutungu, ni Elaija ningg nari.” ");
INSERT INTO kms_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wuti iri ni Jisas wain neng ne ningg di no chongo bidi ire nyumo kamo pe wureq nimbiq pre di wain jig nand kin pe tende neq wughe pre ei Jisas nde neq wundo. Pudi nikinne mune nari, “Muq rar buqoid yenu, di buqod Elaija nandi ni neti nati o segi.” ");
INSERT INTO kms_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Muq Jisas ni quan kumone nari, di nati. ");
INSERT INTO kms_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Di tende puayine chongo yumbui God ningg baj pe yequ kin te mingine bir wughe wuso dig di bidi teri. ");
INSERT INTO kms_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Di soldia mingg yumbui te ni Jisas nde tumone yenu. Di ni Jisas nari kin te nutungu di ni pughe gri nati ye te nuqond di ni nari, “Nganyene nganye, wuti nen ni God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nyumbueg ninge ni wonjine yeru di te ruqond. Nyumbueg te yeru kin tende Maria Magdala kin, Maria Jems kise Joses temi ni kumo di Salome ni ane tende yeru. ");
INSERT INTO kms_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nyumbueg ren ni Galili pune Jisas ane rindi ei ni yumbo jeb riping. Di nyumbueg aye nganye buagi Jisas ane Jerusalem riwo ruso kin ni ane tende yeru. ");
INSERT INTO kms_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Muq Juda ni ngeri yumbui nei rimbiny kin te ningg sir rip ye nginy, di nginy te pre dobu di Sabat. Di nginy te muq yuram pre. ");
INSERT INTO kms_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Di Josep Arimatea kin ni Juda mingg kaunsil te kin ye iri di wute buagi ni ningg chumbuai rind. Di ni nikinne ni yumbo buagi God nde si nambu rise ningg ghimbi pu nas. Ni wune namb segi, no Pailat pengu nindig ei Jisas neti nati neri no nowi yenu ningg. ");
INSERT INTO kms_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ni Jisas brequne nati kin te nutungu di puyene nand. Di ami mingg yumbui te nari nandi di pengu nindig ei nuqond Jisas ni nganyene bri nati. ");
INSERT INTO kms_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat ni soldia mingg yumbui nde wand nutungu di Jisas ni nganyene nati pre, di ni Josep ngiq nindig no Jisas neti nati. ");
INSERT INTO kms_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Muq Josep ni wute mati di imb mamb kin chongo te ninge wong nand nare no, Jisas neti nati di chongo quem ye pe wureq naimb pre, di wute mati kin mawo yemu ye gawo ire wet sange pe pend muaq pu yequ ye tende nowi yenu. Di ni wet yumbui ire kring nipiq wundi wuso, gawo te tuq wumbiq. ");
INSERT INTO kms_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdala kin di Maria Joses kumo ni teri Jisas nowi yenu kin te ruqond ruqondne nowi yenu. ");
INSERT INTO kms_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat kin nginy te pre muq Maria Magdala kin, Maria Jems kumo di Salome pugri pu ruso yumbo tuqo yuwon kin wong rind ei rire ruso Jisas nyang rimbig ningg. ");
INSERT INTO kms_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nginy namba wan te ningg burane ni Jisas nde ngamo pe ruso. ");
INSERT INTO kms_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ni ngimi nyinge rire ruso ruso nikinne oyi oyi pengu rind, “Wuti tughe ei wet gawo tuq wumbiq kin te sange nipiq wuso?” ");
INSERT INTO kms_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pudi ni Jisas nde ngamo pe tiq rar req wiyo wuso ruqond wet yumbui te kring wuso pre. ");
INSERT INTO kms_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ni rundo ngamo pe rir ruso di wuti ambonye iri chongo quem kin nare righe pre si nganye opu nas ruqoind. Di ni quan nganye puye rind di nei kumo rimb. ");
INSERT INTO kms_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Di wuti te ni simbe nindiny nari, “Nungoqi nei kumo wamb wayequ. Nungoqi Jisas Nasaret kin kruse pe qungu mi nati ye te bu meri wuting. Ni mune nes newo pre. Ni ven nde nas segi. Nungoqi ni mowi nase kin sunyi te wuqond. ");
INSERT INTO kms_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pudi nungoqi wo ni nikin wute di Pita ane simbe wundim wari, ‘Ni ye nawo Galili no pre. Nungoqi tende wo tedi ni wuqoind. Ren kin te ni asi nungoqi simbe nunduq kin pugrine ei wuqoind’.” ");
INSERT INTO kms_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Muq nyumbueg te ni buyaq rind di wune ane ngamo si riraq riyi ri di wu rise nambu ruso. Ni wune rimb di wute aye ane wand rind segine ruso ruso nambu ritari righe. ");
INSERT INTO kms_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas ni wik ire kin nginy ye nawo ye te ningg burane nes newo. Di tende puayi ni ye nawo Maria Magdala kin ninde raqe no. Maria wen te asi Jisas ni ququ brequ 7-pela pu ninde pu puaq nand mo. ");
INSERT INTO kms_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ni wuso di wute asi Jisas ane ris di Jisas ningg yivany rire di quanji rind kin te simbe wundiny. ");
INSERT INTO kms_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ni wuso simbe wundiny wuri Jisas nes newo pre di ni wuqoind pre, pudi ni wand te rutungu nganyene puq rind segi. ");
INSERT INTO kms_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dobu Jisas ni nikin wute temi ni ngimne nyinge mare mo mo di Jisas ni aye gib namb pre nondo ninde raqe no. ");
INSERT INTO kms_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Muq wute temi te mune mo wute aye te simbe mindiny, pudi ni mingg wand te mune nganyene puq rind segine. ");
INSERT INTO kms_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dobu Jisas ni nikin wute 11-pela pune ni mir mand mand mas di ni nondo raqe no. Ni nei gre rind di Jisas mune nes newo kin wand te nganyene puq mand segi ye te ningg abo nindim. Te pugri ni wute ninge Jisas nes newo ruqoind pre kin simbe rind kin wand te mutungu segi. ");
INSERT INTO kms_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Di ni pugri simbe nindim nari, “Nungoqi tiqe buagi tende wo di wute buagi nde God ningg wand yuwon ye te simbe wand. ");
INSERT INTO kms_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wuti pughe ye ni God ningg wand yuwon ye te nganyene puq nand di wuye maip kin God ni neti nowi. Pudi wuti pughe ye ni God ningg wand te nganyene puq nand segi ye God ni brequ nindig ye. ");
INSERT INTO kms_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Di wute wand yuwon kin te ningg nganyene puq mand ye ni yumbo ur gre ye ren ei ni bei mand: Nge nde nyamb pe ququ brequ puaq mand. Ni wand tuan aye kin pe wand mand. ");
INSERT INTO kms_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ni ghati mat rise mindiri riwo di ni yumbo wute me di mati ye te me pudi ni mati segi, di ni wute num kin si meny riwo num oghi ye.” ");
INSERT INTO kms_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jisas ni wand ven simbe nindim pre di mune nginy tu wam newo no di God nde si tuan pe opu nas. ");
INSERT INTO kms_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Muq Jisas nikin wute ni mo tiqe buagi tende God ningg wand bir mawo. Di Yumbui ninde dobu yenu di yumbo ur gre kin pe ni wand simbe mand kin te gre neny. ");
INSERT INTO kms_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiopilus Wute nganye buagi yumbo ur God beghi nde yembe nand kin te muqond kin te kin wand ur mand ningg. ");
INSERT INTO kms_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yumbo ren kin puate ri righe di wute te muqond di te kin wand bir mawo ye, ni beghi simbe mundug kin te kin pugrine muq wute nganye buagi te kin wand ur mand ningg buid nganye map. ");
INSERT INTO kms_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Muq nge nge ning gri mune asi yumbo ren puate ri righe kin te otinde guqod, pugri bu nge nei gab kin te nge nyumo raqe wen ur guduw ei nu nei ghamb yumbo pughe kin ye ruwo di yumbo pughe kin dobu ruwi. ");
INSERT INTO kms_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Te ei nu yumbo yumbo buagi te bei munduw kin te oghine nei mbiny. ");
INSERT INTO kms_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot ni Judia pe king ningg nas kin tende puayi prist iri nas ni nyamb Sekaraia. Ni prist mingg wute tit Abiya puq mindim ye te kin iri. Ni ngam Elisabet ni mune Aron ningg kuqone. ");
INSERT INTO kms_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ni teri ane Yumbui ningg lo irepene rutungu ye, di wand ninge gure ruwo segi ye. Pugri bu ni God nde rar pe tuquine ris. ");
INSERT INTO kms_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pudi Elisabet ni kimasi yequ bu wo wure segi. Di ni teri gang rise pre. ");
INSERT INTO kms_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Muq Abiya ningg wute, Sekaraia di nikin yembe ire ane ei yembe mand ye, pugri bu Sekaraia ni God ningg baj pe prist ningg yenu. ");
INSERT INTO kms_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nikin yumbo ur taq wen: Ni wet wo pe prist buagi nyamb ur mindim pre os wo pe mawo maghe, otiwo iri meti ni muqond tughe ni nyamb tende vise, te muqdi ni God ningg baj pe nar no yumbo tuqo yuwon kin wase nande. Pugri bu ni te kin puq men di wet wo Sekaraia nyamb vise ye te meti nowi bu Sekaraia te kin yembe nand. ");
INSERT INTO kms_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Muq yumbo tuqo yuwon kin wase nande kin tende puayi wute buagi God yumbui nyamb rirang kin dabo gri rikur Yumbui pengu rindig rindig yeru. ");
INSERT INTO kms_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Muq Yumbui ningg angelo iri Sekaraia nde nandi di alta pe ni yumbo tuqo yuwon kin wase nande kin tende si tuan pe opu yenu. ");
INSERT INTO kms_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ni te nuqoind di ni puye nand di quan nganye wune namb. ");
INSERT INTO kms_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pudi angelo te nari, “Sekaraia nu wune ghamb wayequ. Nu kuari kin te God nutungu pre. Pugri bu otiwo nungam Elisabet quayi wo iri wurew ye. Otiwo ni wo te wuri wundi di Jon ei puq ndig. ");
INSERT INTO kms_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","Otiwo ni Yumbui nde rar pe yumbui nas. Ni wain ne segi, di wuye gre kin aye te ne segi. Ni kumo wuri wundi kin tende puayi pune ruso ruso otiwo ni yumbui no kin tende puayi Ququ Yuwon Ye ni nde nas. Wuti nen ei otiwo Israel nganye buagi nitari Yumbui nikin God nde nandi. Yumbui nawi ningg bu ni ye nawo Elaija kin pugri Ququ Yuwon Ye ningg gre pe wand bir nawo ei wute buagi yumbo ur brequ si mare. Ni no ei kiyi di wo ane ire pe nimar, wute ngawu gre mand kin mune wand mutungu di yumbo ur tuquine kinne mand. Ni puq nen ei wute nei yuwon ye matevi pre ei Yumbui dobu nawi. Pugri bu nu Elisabet tequ wo te nas kin te ningg quan nganye chumbuai wand, di wute buagi aye te mune pugrine ni nas kin te ningg quan nganye chumbuai rind.” ");
INSERT INTO kms_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Muq Sekaraia oyi angelo pengu nindig, “Pughe gri ei nge nei gab nu nganyene guad? Nge gang kase pre di nge ngam mune gang wuse pre.” ");
INSERT INTO kms_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Muq angelo te oyi nari, “Nge Gebriel, nge God nde rar pe yengu ye, ni tiqi nundogh gadi nu wand yuwon ye ven simbe guduw ningg. ");
INSERT INTO kms_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yumbo ren nganyene nge simbe guduw kin pugrine ei puq ren ye, pudi nu kuari nge nganyene puq gad segi, pugri bu muqdi nu mim ruaw riwo pu ghas ghas otiwo, muq wand ren nge simbe guduw kin ren nganyene puq ren kin tende puayi di nu mune wand ghand.” ");
INSERT INTO kms_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wute buagi Sekaraia ghimbi ruang pu yeru yeru riri, “Pughe ningg ni te nar yenu chiraq?” ");
INSERT INTO kms_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Otiwo ni mune neyi nandi pudi ni mim ruang riwo, di wand nand kin tuqui segi. Ni wand nand kin tuqui segine bu ni si pene yeri nand nand. Ni te ruqond di nei rimb ni God ningg baj pe te nar yenu rar ri righe ruso di yumbo ninge ruqo nyemb pe pugri nuqond. ");
INSERT INTO kms_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Otiwo ni God ningg baj pe yembe nand kin te prene ni mune baj pe no. ");
INSERT INTO kms_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Otiwo tende dobu Elisabet wo ane wus di irew 5-pela pu ni baj pene wus. ");
INSERT INTO kms_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Di ni wuri, “Yumbui nge ghav nindigh bu nge wo ane kas. Asi nge wo segi kas bu wute buagi minyuw kiteny, pudi muq ven nde puayi Yumbui nge yawo nitogh minyuw te puaq nindigh pre bu nge wo ane kas.” ");
INSERT INTO kms_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet wo ane wus irew 6-pela pu ruso pre, di God angelo Gebriel tiqi nundog Nasaret Galili opu yequ kin tende no. ");
INSERT INTO kms_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ni nyumbueg ambonye ire nde no. Nyumbueg ambonye te Josep Devit ningg kuqo ni meng nitaqi ningg wus ye. Ni asi wuti iri teri rise segi. Nyumbueg ambonye te ni nyamb Maria. ");
INSERT INTO kms_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelo te ni nde no muq simbe nunduw nari, “Nu nei tuan mbiq, God nu quan nganye yawo niraw righe. Yumbui nu tequ was.” ");
INSERT INTO kms_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ni puq nand kin te ningg Maria nei kumo nganye wumb, di nei wumb segi pughe kin ningg angelo wand ven kin nand. ");
INSERT INTO kms_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pudi angelo te Maria simbe nunduw, “Maria nu wune ghamb wayequ, God nu quan nganye yawo niraw righe. ");
INSERT INTO kms_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Muqdi nu wo ane ghas di otiwo nu quayi wo iri gheri ghandi. Wo te gheri di ni nyamb Jisas ei puq ndig. ");
INSERT INTO kms_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Otiwo ni nyamb yumbui nganye vise di God Yumbui Nganye Kin nari ni ni ningg wo. Yumbui God nari di ni kuqo Devit ningg sunyi nitangvi, king ningg nas. ");
INSERT INTO kms_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Di Jekop ningg kuqo kimem buagi ni nde si nambu ris. Di yumbo yumbo buagi ni nde si nambu rise kin te pre ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Muq Maria oyi wuri, “Te pughe gri ei? Nge wuti iri temu pase segine di pughe gri ei nge wo ane kas?” ");
INSERT INTO kms_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Di angelo oyi simbe nunduw nari, “Ququ Yuwon Ye nu nde nandi ye. Di Yumbui Wam Nganye Kin ni ningg gre nunde bre. Pugri bu nu quayi wo yuwon kin te gheri, di God ningg wo puq mindig. ");
INSERT INTO kms_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Piyi nu yavi ire Elisabet ni gang wuse pudi muq ni wo wuri yamb tumo. Wute riri ni wo wure tuqui segi, pudi muq ni wo ane wus irew 6-pela ruso pre. ");
INSERT INTO kms_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Te pugri yumbo yumbo buagi wute qi pe kin puq men tuqui segi kin te God puq nen kin tuqui. Yumbo ninge God puq nen tuqui segi kin rise segi.” ");
INSERT INTO kms_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Muq Maria oyi angelo simbe wundig, “Te piyi muq nu simbe guad kin pugrine nge puq negh. Nge God ningg yembe ye wuti. Pugri bu God nge pughe sin negh ningg te piyi.” Ni puq wund di angelo Maria si niraq no. ");
INSERT INTO kms_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tende puayi Maria yumbo sir wup di brequne Judia opu wuso di tiqe ire rand pe opu yequ kin tende wuso. ");
INSERT INTO kms_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wuso tende wuso wur di Sekaraia ningg baj pe wuso, di ni Elisabet chumbuai kin wand simbe wunduw. ");
INSERT INTO kms_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet ni Maria chumbuai kin wand simbe wunduw kin te wutungu ne, di wo Elisabet nde umbo pe kuse kin chumbuai gud prare kuyo, di opu Ququ Yuwon Ye Elisabet nde yenu. ");
INSERT INTO kms_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Di Elisabet quan kumone wuri, “Nyumbueg buagi nde mingi God nu irine quan nganye yuwon nuaw, di wo nu nde umbo pe kuse kin te quan nganye yuwon nuany. ");
INSERT INTO kms_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pudi pughe kin ningg nge quan nganye yuwon nuagh bu nge Yumbui ningg kumo nge nde wundi? ");
INSERT INTO kms_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu chumbuai kin wand guad kin nge nde ange pe vighe di opu wo nge nde umbo pe kuse kin chumbuai gud di prare kuyo. ");
INSERT INTO kms_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yumbui nu simbe nunduw kin te nu kuari otiwo nganyene yumbo te kin puq ren puq guad ye te ningg God nu yuwon nganye nuaw.” ");
INSERT INTO kms_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria wuri, “Nge umbo pe Yumbui nyamb gidivi viyo ");
INSERT INTO kms_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","di nge ququ God nge neti kowi kin ni ningg chumbuai wund. ");
INSERT INTO kms_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Nge ni ningg yembe ye nyumbuegne, pudi ni nge nei gheri nipigh segi. Yumbui Gre Nganye Kin yumbo yumbui kin wute aye puq men tuqui segi kin ni nge nde yembe nindiny kin te ningg di muq ven nde puayi pune ruso ruso otiwo wute buagi riri God nge yuwon nuagh. Ni nyamb yuwon vise. ");
INSERT INTO kms_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wute muq mas kin men di ni wo mune mas kin tende puayi wute God yumbui nyamb mirang tedi ni oyi yawo nitom di yumbo ur pugri kin bei nindim. ");
INSERT INTO kms_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nikin si gre kin pe ni yumbo gre kin puq nen. Wute nikin nei pe mari ni yumbui mas puq mand kin te oyi ni woingo nuam righe. ");
INSERT INTO kms_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wute nyamb kin ni ni maghe mo, pudi wute nyamb segi kin oyi nyamb nindivi viyo yumbui nyamb niram. ");
INSERT INTO kms_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wute asi yumbo segi kin te oyi muq ni yumbo quan kumo nem, pudi wute asi yumbo quan kin te oyi muq tiqi nundom yumbo segi si omone mo. ");
INSERT INTO kms_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ni asi beghi koku simbe nindim kin te nei gheri nap segi, bu muq nikin yembe ye wute Israel yawo nitony bu nandi. ");
INSERT INTO kms_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ni yumbo te kin asi ni beghi koku simbe nindim kin pugrine ei otiwo Abraham di nikin kuqo ane bei nindiny nindinyne ruso ruso otiwo.” ");
INSERT INTO kms_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabet ane ris irew teri ire ruso pre muq mune nikin tiqe wuso. ");
INSERT INTO kms_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ni wo wuri wundi kin tende puayi ni wuso quayi wo wuri wundi. ");
INSERT INTO kms_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Di nikin yavi ire di tiqe ire ye ni God Elisabet yawo nitow di ghav nunduw kin te rutungu, di ni ruso Elisabet ane chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nginy 7-pela pu mo pre, nginy 8 te ningg ni mandi wo te ghimbi dugu chongo pend muang ningg. Wute ghimbi dugu chongo pend muang kin ni kiyi Sekaraia nyambne mirang ningg mari. ");
INSERT INTO kms_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pudi ni kumo segi puq wund wuri, “Yewo! Ni nyamb Jon.” ");
INSERT INTO kms_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ni oyi mari, “Te pudi nungoqi nuqo iri nyamb te kin vise pu ghari.” ");
INSERT INTO kms_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sekaraia mim ruang riwo di ni wand nand segine ye, pugri bu ni si pene yeri mand di pengu mindig ei ni simbe nand nyamb pughe ye bri wo te mirang ningg nari. ");
INSERT INTO kms_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Muq Sekaraia oyi si pene yeri nindim di ni nyumo raqe meng. Muq ni wo nyamb te nyumo raqe pe ur nand nari, “Ni nyamb Jon.” Muq wute buagi te yemu kin puyene nganye mand. ");
INSERT INTO kms_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sekaraia puq nand di brequne nganye ni mim ruang riwo kin te prene, minjuq mune bure nondo, di mune wand nand kin tuqui, di ni God chumbuai nindig. ");
INSERT INTO kms_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wute buagi nikin tiqe kin wune rimb, di wand te kin Judia opu tiqe buagi rand pe yeru kin tende vir ir. ");
INSERT INTO kms_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wute buagi wand ven rutungu kin te nei kumo rimb di riri, “Wo nen otiwo ni pughe gri kin bri nas?” Yumbui ningg gre ni nde vise bu puq ren. ");
INSERT INTO kms_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Di Jon kiyi Sekaraia Ququ Yuwon Ye ni nde nas nei neng di propet kin wand ren simbe nand: ");
INSERT INTO kms_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yumbui Israel mingg God nyamb bidivi viyo; te pugri ni nandi nikin wute Israel nate ruwi pre. ");
INSERT INTO kms_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ni beghi wuti gre nganye kin iri nengu pre. Wuti te otiwo beghi nitamu powi ye. Wuti te God ningg yembe ye wuti Devit ningg kuqo. ");
INSERT INTO kms_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wand ven kin yabe chuqo nikin propet yuwon ye ni simbe nindim mandi simbe mand kin ane tuquine. ");
INSERT INTO kms_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ni simbe nindim nari otiwo ni beghi ghav nundug, beghi bon veri nde si pe pu nitamu powi. Di wute beghi yambu mirengu kin ninde si pe pu nitamu powi. ");
INSERT INTO kms_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yumbo ren kin puq nen kin te asi ni wand yuwon ye taq namb kin te nei gheri nipiny segi, di ni beghi koku yawo nitom kin te bei nand ningg. ");
INSERT INTO kms_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ni beghi koku Abraham nde wand gre ye simbe nindig nari, ");
INSERT INTO kms_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Otiwo ni nganyene beghi veri nde si pe pu nitamu powi, di ghav nundug ei beghi wune bab segi di ni ningg yembene bad. ");
INSERT INTO kms_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Di beghi ninde rar pe yuwon pu pas di yumbo ur tuquine puq pen pen pati. ");
INSERT INTO kms_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Di nu nge wo otiwo wute buagi mari nu Yumbui Wam Nganye Kin ni ningg propet iri. Te pugri nu ei ye ghawo Yumbui ngim wang ei ni dobu naru ye. ");
INSERT INTO kms_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Di nu God ningg wute simbe ndiny ei ni nei rimb ni nate ruwi yuwon pu ris. Beghi God ni quan nganye yawo nitony ye te ningg bu ni yumbo ur brequ rind kin wand te puaq nindiny di Yumbui ningg ti beghi nengu. ");
INSERT INTO kms_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Di wute yumbo ur brequ rind di burpoq wabe ris kin te ti neny. Ni puq nen ei beghi ngim budoq ei yuwon pene nyinge pare, yeng bad segi di umbo yuwonne kuse.” ");
INSERT INTO kms_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Di wo nen yumbui no di gre natevi, di no dabo char kumo mingi wute segi ye pe te yenu yenu, otiwo muq mune wute buagi Israel kin nde rar pene nandi. ");
INSERT INTO kms_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tende puayi Sisar Ogastus ni Rom kin gavman mingg yumbui. Ni wand ni viso tiqe manyi Rom gavman nde si nambu yeru kin te wute buagi manyi mand. ");
INSERT INTO kms_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ogastus ni wand ni viso di wute manyi mand kin ren asi puq men segi, ren kin muq teneqa puq men. Ni wute manyi mand kin tende puayi Kwirinius ni Siria pe gavman kin yumbui ningg nas. ");
INSERT INTO kms_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wute buagi nikin tiqe pene mo nyamb mi rundo. ");
INSERT INTO kms_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pugri bu Josep mune Nasaret Galili opu pu nyinge nare no Betlehem Judia opu yequ kin te no. Betlehem te ni kuqo king Devit ningg tiqe. Josep ni Devit ningg kuqo pugri bu ni te no. ");
INSERT INTO kms_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ni te no ei Maria, nyumbueg te ni meng nitaqi ningg wus kin te, teri nyamb ur rind ningg. Nyumbueg te muq wo ane wus. ");
INSERT INTO kms_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ni ruso Betlehem ris Maria wo pe wuso, ");
INSERT INTO kms_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","di quayi wo wuri wundi. Wo te Maria nikin sonyi wo. Ni quayi wo te wuri wundi di baj pe ris kin sunyi segi, pugri bu ni chongo pe imb wuimb di kau mir rind kin sunyi pe te wuwi nase. ");
INSERT INTO kms_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tende opune wute sipsip yeng muany kin ninge mas, muq bur mingi pu ni nikin sipsip yeng muany pu dabo yemu. ");
INSERT INTO kms_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Muq Yumbui ningg angelo iri ni nde nandi, di Yumbui ningg ti ninde quan nganye ti nase, di ni quan nganye wune mamb. ");
INSERT INTO kms_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pudi angelo te ni simbe nindim nari, “Nungoqi wune wamb wayequ. Nge wand yuwon ye nungoqi nde kare gadi. Otiwo di wute buagi te ningg quan nganye chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Muq bur kuen gug, Devit ningg tiqe pe, wuti nungoqi nitaqu wowi kin kumo wuri wundi pre. Ni Yumbui, ni Kraist God nikin wute ghav nindiny ningg naip no! ");
INSERT INTO kms_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nungoqi wo yumbo ren kin wuqond di nei wamb wo teneqa: Wo te chongo pe imb rimb kau mir rind kin sunyi pe ruwi naghe pu nase. Nungoqi te wuqond tedi nei wamb wo teneqa.” ");
INSERT INTO kms_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Muq brequne angelo nganye buagine aye, ni wam kin ami, mandi angelo te ane yemu, God nyamb mindivi viyo ningg pugri yuwo mari: ");
INSERT INTO kms_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God wam nganye kin ni nyamb bidivi viyo, di qi pe kin wute ni chumbuai nindiny kin te umbo neny kughe.” ");
INSERT INTO kms_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Otiwo angelo te ni si mare mune nginy tu wam mewo mo pre, wute sipsip yeng muany kin te mari, “Be Betlehem po, yumbo ren Yumbui simbe nundug kin ren po buqod.” ");
INSERT INTO kms_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Muq ni brequne mo Betlehem di Josep Maria teri te ris muqond, di wo kau mir rind kin sunyi pe te ruwi naghe pu nase muqoind. ");
INSERT INTO kms_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ni wo te muqoind pre, muq ni angelo wo nen ningg simbe nindim kin te simbe mand mand mo. ");
INSERT INTO kms_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Di wute buagi wand ven simbe mand kin te rutungu di ni quan nganye puye rind. ");
INSERT INTO kms_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pudi Maria ni yumbo te nei pe wuwo ris. Di muq ni te kin quan nganye nei wumbiny wumbiny wus. ");
INSERT INTO kms_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Muq wute sipsip yeng muany kin te mune mo, di yumbo yumbo buagi angelo simbe nindim kin pugrine muqond kin te ningg Yumbui nyamb mindivi viyo viyo mo. ");
INSERT INTO kms_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nginy 7-pela pu mo pre nginy 8 te ningg ni ghimbi dugu chongo pend muang kin tende puayi ni Jisas nyamb mirang. Nyamb ven asine ni kumo nde umbo pe nase segine angelo ni nyamb ven neng pre. ");
INSERT INTO kms_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muq Maria ni si uny pu wus kin nginy te omone, bu ni ghimbi sabi munduw ningg. Pugri bu ni Moses ningg lo puq wund kin pugrine puq ren. Ni te kin puq ren ningg bu wo te riri Jerusalem ruso Yumbui nde ri nondo ningg. ");
INSERT INTO kms_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ni yumbo ren kin puq ren kin Yumbui ningg lo puq wund kin pugrine puq ren. Yumbui ningg lo wuri, “Wute ire wo sonyi wund muq quayi wo wuri, tedi Yumbui nde wi nondo.” ");
INSERT INTO kms_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Di mir wase rinde Yumbui reng ningg, te Yumbui ningg lo puq wund kin pugrine ei puq ren. Yumbui ningg lo wuri, “Wapi mabri temi o wapi mabisvir tevi wase rinde God reng.” ");
INSERT INTO kms_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalem pe wuti iri nas, ni nyamb Simeon. Ni wuti yuwon ye. God nde rar pe ni yumbo ur tuquine puq nen ye. Ni wuti Israel nate mowi ningg nandi kin te ghimbi nuang pu nas. Di Ququ Yuwon Ye ni nde nas, ");
INSERT INTO kms_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","di Ququ Yuwon Ye ni simbe nindig nari ni prine nati segi, ni nasne otiwo Kraist ni ningg wute ghav nindim ningg Yumbui naip no kin te nuqoind. ");
INSERT INTO kms_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ququ Yuwon Ye ni nitanyi God ningg baj kin imb pe nar no. Di Jisas opu kiyi kumo riri God ningg baj pe rir ruso ei lo wuri kin pugrine puq ren ningg. ");
INSERT INTO kms_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Muq Simeon Jisas neti nowi si pe nowi naghe di God nyamb nindivi viyo nari, ");
INSERT INTO kms_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yumbui nu king ningg kuas. Nu kuari kin te muq nganyene puq kuen. Muq nu ghari di nge nu non yembe ye wuti ko. ");
INSERT INTO kms_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nu wuti nu tiqi gudog nandi beghi nitamu powi kin te nge ning gri rar pe guqod pre, ");
INSERT INTO kms_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","di wute buagi nde rar pe nu yumbo ren puq kuen; ");
INSERT INTO kms_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","di ni wute Juda segi kin nei yuwon ye neny di ni nei rimb kin tuqui, di nu non wute Israel nu gudiri riwo yumbui nyamb kueny.” ");
INSERT INTO kms_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Di wo te kin kiyi kumo Simeon wand nand kin te ningg quan nganye puye rind. ");
INSERT INTO kms_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Muq Simeon God pengu nindig ei God ni yuwon nuany ningg. Di Maria, Jisas kumo simbe nunduw nari, “Wo nen ningg ei otiwo wute Israel kin nganye buagi ir righe, di nganye buagi mune res riwo. Te ningg bu God wo nen si numbog di tiqi nundog nandi. Otiwo di wute ninge ni wand brequ rindig, ");
INSERT INTO kms_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tende puayi di ni nei brequ te raqe ruso di wute aye ruqond. Otiwo di nu non quayi mune ni ningg yivany ghare kin te mame bidi dobui nu dugogu mingine cheiq no opu gri bre no kin pugri.” ");
INSERT INTO kms_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tende puayi nyumbueg gang ire mune wus, ni nyamb Ana. Ni propet ire. Ni Panuel ningg wo, di ni wute tit Aser kin. Asi ni ngam wuso, ngaim teri ris ber 7-pela pu pre, ");
INSERT INTO kms_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","muq ni ngaim nati di mune nyarimo wus. Muq ni ber 84-pela wuwo pre. Ni God ningg baj si wuraq ye tuqui segi, ni pripri bur di bogisumb God ningg baj pe wuso, mir uny yequ Yumbui pengu wundig, di God yumbui nyamb wurang. ");
INSERT INTO kms_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Muq brequne ni wundi wo kiyi kumo ane yeru kin pe tende yequ, God chumbuai wundig, di wute buagi God Jerusalem nate ruwi puq nand kin te ningg ghimbi ruwo pu ris kin te, wo nen ningg simbe wundiny. ");
INSERT INTO kms_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep Maria teri Yumbui ningg lo puq wund kin pugrine yumbo yumbo buagi puq ren pre, muq ni teri nikin tiqe Nasaret Galili opu mune ruso. ");
INSERT INTO kms_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Di wo te yumbui no, gre nand, di nei yuwon ye ni nde bre, di God nikin nei pene ni yuwon nuang. ");
INSERT INTO kms_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ber manyi ni pripri God ni asi Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny di mir mawo. Di Jisas ni kiyi kumo teri ber manyi mir te kin pe Jerusalem ruso. ");
INSERT INTO kms_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas ni ber 12-pela nawo pre, di ni pripri mir te kin pe ruso kin pugrine muq mune ruso. ");
INSERT INTO kms_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Otiwo mir te pre, Jisas tene nas di ni kiyi kumo mune tiqe ruso, pudi ni nei rimb segi, ");
INSERT INTO kms_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ni riri Jisas ni anene bu ruso. Ni nyinge rire ruso ruso nginy iri no pre, muq ni wute buagi ni kimand di yavi ire buagi nde mingi te meri riting, pudi ruqoind segi. ");
INSERT INTO kms_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ni meri riting ruqoind segi, di munene Jerusalem ruso meri riting. ");
INSERT INTO kms_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nginy temi ire pu mo pre muq ni God ningg baj kin imb pe nas ruqoind. Ni wute Moses ningg lo bei mand kin te ane God ningg baj pe te mas ni mingg wand nutungu di ni oyi pengu nindim. ");
INSERT INTO kms_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wute buagi mutungu ni oyi pengu mand kin te ni quan nganye nei nimbiny di tuquine nganye simbe nand, pugri bu ni nei kumo mamb. ");
INSERT INTO kms_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ni kiyi kumo teri te nas ruqoind di ni puyene nganye rind. Di ni kumo wuri, “Wo, pughe kin ningg nu beghi puq guegu? Nge nu nuyi temu nu ningg nei kumo bab, bu meri buid nganye putuw.” ");
INSERT INTO kms_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Di ni oyi nari, “Pughe ningg nungoqi nge meri wutigh? Nge ngening wuyi ningg baj pe ei kas ye, nungoqi te kin nei wamb segi bri?” ");
INSERT INTO kms_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ni oyi pugri simbe nindiny, pudi ni nei rimb segi ni pughe ningg puq nand. ");
INSERT INTO kms_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Muq ni kiyi kumo wand nutungu di anene mune Nasaret righe ruso, di otiwo mune kiyi kumo ningg wand nutungu nutungu ne. Di kumo yumbo buagi ren nei pe wuwo ris. ");
INSERT INTO kms_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Muq Jisas yumbui no di nei yuwon ye mune ni nde yumbui yevu, di ni God di wute nde rar pe yuwon nganye nand. ");
INSERT INTO kms_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisar Taiberius ni Rom pe gavman kin yumbui ningg nas ye ber 15 te ningg Pontius Pailat ni Judia opu kin yumbui ningg nas, Herot Galili opu nas, ni kiqam Pilip Iturea di Trakonitis opu nas, di Lisanias Abilene opu yumbui ningg nas. ");
INSERT INTO kms_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Di tende puayine Anas Kaiapas temi prist mingg yumbui ningg mas. Wute buagi men yumbui ningg mas kin tende puayi Jon Sekaraia ningg wo qi nyumo di wuye segi ye pe tende yenu di God ningg wand ni nde vindi. ");
INSERT INTO kms_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Di ni sunyi buagi Jordan opu rise kin tende nar ir wand bir nawo. Ni wand bir nawo kin te wute simbe nindiny ei ni nei rire ritinde di ni wuye nap ei God ni yumbo ur brequ rind kin wand te puaq nindiny. ");
INSERT INTO kms_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ni puq nen kin te wand propet Aisaia ni ningg wand rise ye buk pe ur nand pu rise kin pugrine puq nen. Wand taq ren: “Wuti iri mong nyumo di wuye segi ye pe tende yenu di ngam nare nari, ‘Yumbui ngim wuang, di ngim sabi wundig pu wuse ei ni nyinge nare. ");
INSERT INTO kms_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Otiwo di ghawo buagi te righe di rand buagi bir mas bedne mase. Asi mong tende brequ rise di ngim wuso tuqui segi kin te mune yuwon rind, tuquine rise, di ngim tende gi wuti. ");
INSERT INTO kms_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Di wute buagi God wuti beghi nitamu powi ningg tiqi nundog nandi kin te ruqoind’.” ");
INSERT INTO kms_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon wute buagi ninde rindi ei wuye nap ningg rindi kin te simbe nindiny nari, “Nungoqi ghati sindiyu wo! God wute mai neny puq nand kin mai te tumo rise. Tughe nungoqi simbe nunduw bu God ni mai neuq kin te qibe wurany ningg? ");
INSERT INTO kms_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nei ware witinde di yumbo ur oghi yene wand. Di nungoqi nonne nungoqi ningg wari, ‘Beghi Abraham ningg kuqo, pugri bu God beghi mai nengu segi ye.’ Nge nungoqi simbe guduq, God segine wet men mas kin men oyi nare nitinde di Abraham ningg kuqo ningg mas. ");
INSERT INTO kms_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","God ningg mame puate asine nyumo puate pe tende wuse, nyumo buagi yi oghi kin riyi segi kin te enare di wase ni riwo namb.” ");
INSERT INTO kms_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Muq wute buagi te yeru kin Jon pengu rindig riri, “Muqdi beghi pughe ei pen ye?” ");
INSERT INTO kms_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Di Jon oyi simbe nindiny nari, “Wuti iri siot temi mase tedi wuti tughe siot segi kin te iri yeng, di wuti mir quan rise kin te pugrine puq yen.” ");
INSERT INTO kms_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wute takis materi kin mune pugrine mandi ei Jon wuye nap ningg. Di ni Jon pengu mindig mari, “Tisa, beghi pughe ei pen?” ");
INSERT INTO kms_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Di Jon oyi ni simbe nindim nari, “Nungoqi wo wute nde takis wateri kin te simbe munduq ye tuquine ei wateri. Nungoqi non nei pe mune so rundo wateri wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Di ami ninge ni mune pugrine Jon pengu mindig mari, “Di beghi? Beghi pughe ei pen ye?” Di Jon ni oyi nindim nari, “Wute wandoqi wundim segi wat mase taq wamb di wet bidi segi wutamri wayequ. Nungoqi fotnait pughe gri pu meuq kin te tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wute buagi ni wuti God nikin wute ghav nindiny ningg naip no kin te ghimbi ruang pu ris ye. Wuti te Kraist puq rindig kin. Pugri bu ni Jon ruqoind di nei kumo rimb. Ni riri Kraist tene bri Jon. ");
INSERT INTO kms_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Di Jon nari, “Nge nungoqi wuye pe wuye kupuqu. Pudi wuti aye iri nge nde dobu nawi kin ningg gre te nge gre ane tuqui segi, ni gre quan nganye. Nge wuti yuwon nganye segi, pugri bu nge ni su taq nimbiq kin sare te bure gad kin tuqui segi. Nge wuye pe wuye kupuqu, pudi wuti nen di nungoqi Ququ Yuwon Ye di wase pe wuye nupuqu ye. ");
INSERT INTO kms_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ni nandi di sawol niraqne nandi di wit dang nand kin sunyi raqe nand. Wit oghi kin nikin mir baj pe nawo ris, di raqe dubu ane wase awu kuso tuqui segi ye pe nande namb.” ");
INSERT INTO kms_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Di Jon wand yuwon ye Jisas beghi nitamu powi ye te kin wand aye nganye buagi simbe nindim. ");
INSERT INTO kms_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pudi Jon wute buagi nde rar pene Herot Galili opu kin yumbui te ni yumbo ur brequ buagi yembe nindiny kin te ningg abo nindig, di ni kiqam ngam Herodias nitaqi kin wand te simbe nindig, ");
INSERT INTO kms_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","di Herot Jon taq naimb. Ni puq nen kin te ni munene yumbo ur brequ nand. Asi ni yumbo ur brequ nganye buagi nand di muq mune yumbo ur brequ nand. ");
INSERT INTO kms_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon wute buagi wuye nap kin tende puayi ni Jisas anene wuye naip. Ni Jisas wuye naip pre, Jisas God pengu nindig nindig yenu di nginy tu bi viso, ");
INSERT INTO kms_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","di Ququ Yuwon Ye ni nde nati ni. Ququ Yuwon Ye ni nde nandi kin te wapi mabri gib namb. Di wuti iri nginy tu wam pu nari, “Nu nge wo. Nge nu quan nganye yawo kiraw righe, di nu ningg quan nganye chumbuai gad.” ");
INSERT INTO kms_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas ni ber 30-pela pu ruso pre muq ni yembe puate ni righe. Wute buagi ni nei mamb kin mari Jisas ni Josep ningg wo. Di Josep ni Heli ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli Matat ningg wo, Matat Livai ningg wo, Livai Melki ningg wo, Melki Janai ningg wo, Janai Josep ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep Matatias ningg wo, Matatias Amos ningg wo, Amos Nahum ningg wo, Nahum Esli ningg wo, Esli Nagai ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Mat ningg wo, Mat Matatias ningg wo, Matatias Semen ningg wo, Semen Josek ningg wo, Josek Joda ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda Joanan ningg wo, Joanan Resa ningg wo, Resa Serubabel ningg wo, Serubabel Sealtiel ningg wo, Sealtiel Neri ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melki ningg wo, Melki Adi ningg wo, Adi Kosam ningg wo, Kosam Elmadam ningg wo, Elmadam Er ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josua ningg wo, Josua Elieser ningg wo, Elieser Jorim ningg wo, Jorim Matat ningg wo, Matat Livai ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai Simeon ningg wo, Simeon Juda ningg wo, Juda Josep ningg wo, Josep Jonam ningg wo, Jonam Eliakim ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim Melea ningg wo, Melea Mena ningg wo, Mena Matata ningg wo, Matata Natan ningg wo, Natan Devit ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit Jesi ningg wo, Jesi Obet ningg wo, Obet Boas ningg wo, Boas Salmon ningg wo, Salmon Nason ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason Aminadap ningg wo, Aminadap Ram ningg wo, Ram Hesron ningg wo, Hesron Peres ningg wo, Peres Juda ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda Jekop ningg wo, Jekop Aisak ningg wo, Aisak Abraham ningg wo, Abraham Tera ningg wo, Tera Nahor ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serug ningg wo, Serug Reu ningg wo, Reu Peleg ningg wo, Peleg Eber ningg wo, Eber Sela ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela Kainan ningg wo, Kainan Arpaksat ningg wo, Arpaksat Siem ningg wo, Siem Noa ningg wo, Noa Lamek ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Metusela ningg wo, Metusela Enok ningg wo, Enok Jared ningg wo, Jared Mahalalel ningg wo, Mahalalel Kenan ningg wo, ");
INSERT INTO kms_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enos ningg wo, Enos Set ningg wo, Set Adam ningg wo, di Adam God ningg wo. ");
INSERT INTO kms_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jon Jisas wuye naip pre di Ququ Yuwon Ye ni nde bre di ni Jordan si neri nandi, di Ququ Yuwon Ye ni nitanyi mong nyumo di wuye segi ye pe tende no. ");
INSERT INTO kms_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ni tende yenu di Satan ni nde nandi di ni wandoqi nindig. Satan nginy 40-pela pu Jisas wandoqi nindig. Nginy 40-pela pu te ningg ni mir nand segine yenu, di ni quan nganye mir gureg. ");
INSERT INTO kms_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Muq Satan ni ningg nari, “Nu nganyene nganye God ningg wo, tedi nu wet nen simbe ndig ei ni tindi no bret nase.” ");
INSERT INTO kms_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Di Jisas oyi nari, “God ningg buk wuri, ‘Wuti iri ni bret ninggne nas tuqui segi’.” ");
INSERT INTO kms_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Di Satan ni nitanyi rand yumbui iri ningg newo no, rand bage pe yenu di brequne mong di kantri buagi di qi pe kin yumbo yumbo buagi te bei nindig. ");
INSERT INTO kms_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Di simbe nindig nari, “Yumbo buagi ren nge megh pre. Muq nge ning nei pe wuti tughe geg yawo kuregh di geg. Pugri bu nu nge yumbui nyamb ragh, tedi yumbo yumbo buagi ren nge nu kew. Di wute buagi ningg gre di nikin yumbo yuwon ye buagi te buagi ane nu kew di nu te.” ");
INSERT INTO kms_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Di Jisas oyi nari, “God ningg buk wuri, ‘Nu Yumbui nunon God ei yumbui nyamb rang di ni ningg yembene ei ghand’.” ");
INSERT INTO kms_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Muq Satan Jisas nitanyi Jerusalem mune no di nitanyi God ningg baj pe newo no baj gug wam nganye yenu di simbe nindig nari, “Nu nganyene nganye God ningg wo, tedi nu wam ren pu prare yaghe. ");
INSERT INTO kms_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","God ningg buk wuri, ‘God nikin angelo ningg nari mandi nu yeng muaw yuwon. ");
INSERT INTO kms_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Di ni ei nu mait ghase ghasene yaghe yo, ei nu wet pe nyinge dang ghand tuqui segi’.” ");
INSERT INTO kms_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Di Jisas oyi nari, “God ningg buk wuri, ‘Nu Yumbui nu non God ni gre tuqui ghap wayequ’.” ");
INSERT INTO kms_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan Jisas pugri wandoqi nindig nindig pre, si neri di no. Otiwo ei mune nandi di wandoqi nindig. ");
INSERT INTO kms_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisas Ququ Yuwon Ye ningg gre pe munene Galili no. Di Jisas ningg wand tiqe buagi Galili opu yeru kin tende vir ir. ");
INSERT INTO kms_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ni no ni mingg God yumbui nyamb mirang kin baj manyi tende wand bei neny di wute buagi te opu kin ni ningg nyamb rindivi viyo. ");
INSERT INTO kms_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas Nasaret nas yumbui no. Muq ni mune Nasaret no Sabat kin nginy tende di ni God yumbui nyamb mirang kin baj pe no. Te nikin yumbo ur pugri ye Sabat kin nginy tende di ni God yumbui nyamb mirang kin baj pe no ye, pugri bu muq ni pripri puq nen kin pugrine puq nen. Di God yumbui nyamb mirang kin baj pe ni nes newo ei buk nundoq ningg. ");
INSERT INTO kms_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Muq buk propet Aisaia ni ur nindiq kin te meng. Ni buk te bure nindiq, di nuqond wand ren rise kin tuquine bure nindiq: ");
INSERT INTO kms_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yumbui nge si numbogh bu gadi wute yumbo segi kin wand yuwon ye simbe gidiny ningg. Pugri bu Yumbui ningg Ququ nge nde yenu. Ni nge tiqi nundogh gadi ei wute taq pu yeru kin te simbe gidiny ni taq kin te muq prene. Di wute rar brequ kin te simbe gidiny muq ni mune rar rit tuqui. Di wute mai rire rire ris kin te simbe gidiny, muq ni mune yuwon pu ris ye. ");
INSERT INTO kms_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ni nge tiqi nundogh gadi ei Yumbui ni yawo nitony kin bei nand ye ngeri te ningg simbe gad ningg.” ");
INSERT INTO kms_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Muq buk te mune muet nimbiq, wuti God yumbui nyamb mirang kin baj pe yembe nand ye ni nde neq wundo di no nas. Di wute buagi God yumbui nyamb mirang kin baj pe mas kin ni rar ni nde gre gud pu kuse, ");
INSERT INTO kms_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","di ni wand puate ni righe pugri simbe nindim nari, “Wand ven muq tene buk wen ningg wutungu kin ven, muq nganyene wand te kin pugrine puq ren pre.” ");
INSERT INTO kms_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wute buagi ni wand nand kin te rutungu quan nganye yuwon di ni chumbuai rindig. Ni yuwonne nganye wand nand pugri bu wute buagi ghabe rind di riri, “Ni Josep ningg wo, pughe gri ate ni pugri wand nand?” ");
INSERT INTO kms_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Di Jisas ni pugri simbe nindiny, “Nge nei gab, nungoqi nge pugri puq wundigh ye: ‘Nu wuti wute sabi gudiny ye, muq be nu non nde mune puq yen. Nu Kaperneam pe puq kuen kin te beghi putungu. Muq be nu Kaperneam pe puq kuen kin pugrine nu non tiqe pe ven nde mune puq yen.’ ");
INSERT INTO kms_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Nge nungoqi nganyene nganye simbe guduq, propet buagi nikin tiqe kin wute buagi yambu rirem. ");
INSERT INTO kms_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nge nungoqi simbe guduq, asi Elaija nas kin tende puayi wuye wundi segi, nginyne yenu yenu ber teri ire pu di ire cham. Pugri bu tiqe buagi tende opu yeru kin mir segi. Di tende puayi Israel pe nyumbueg nganye buagi ngaim mati pre nyarimo ris kin te ris. ");
INSERT INTO kms_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pudi God Elaija tiqi nundog nyumbueg Juda kin tende no segi. Ni tiqi nundog nyarimo nyumbueg ire Sarepat kin tende oyi no. Sarepat te Saidon opu yequ ye. ");
INSERT INTO kms_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Di Elisa propet iri ni nas kin tende puayi Israel wute num leprosi rire kin nganye buagi ris. Pudi ni Juda kin wuti iri sabi nindig segi. Ni Naman irine sabi nindig. Naman te Siria opu kin.” ");
INSERT INTO kms_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wute buagi God yumbui nyamb mirang kin baj pe ris kin ni pugri puq nand kin te rutungu di quan nganye umbo ker ruwo. ");
INSERT INTO kms_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Di ni mes mewo bub meri dabo mar mo, di mitanyi rand cheq pe mo. Rand te ningg tiqe te yequ ye. Ni Jisas mitanyi mo rand cheq pe tende yemu ei memeri naghe no ningg. ");
INSERT INTO kms_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pudi ni tindi nandi, wute buagi nde mingine nyinge nare no opu no nar, di no. ");
INSERT INTO kms_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Muq Jisas Kaperneam tiqe ire Galili opu yequ kin tende naghe no, di Sabat kin nginy tende ni wute wand bei neny. ");
INSERT INTO kms_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ni wand bei neny kin te ni gre ane wand nand pugri bu wute buagi nei kumo rimb. ");
INSERT INTO kms_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","God yumbui nyamb mirang kin baj pe tende wuti iri ququ brequ ane kin tende nas. Muq ququ brequ wuti tende quan kumone ngam nare nari, ");
INSERT INTO kms_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jisas Nasaret kin, nu guadi beghi pughe guegu ningg? Nge nu nei gubuw, nu God ningg wuti yuwon ye. Nu beghi brequ gudug ningg bri guadi? Beghi si ramu pas.” ");
INSERT INTO kms_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Muq Jisas ququ brequ te simbe nindig nari, “Nu wand segi ghas wuti te si gheri gheyi yi yo.” Muq ququ brequ wute buagi nde rar pene wuti te meneri no naghe, di neyi ni, no. Ni wuti te meneri no naghe, pudi ghimbi dang nand yuqo nati segi. ");
INSERT INTO kms_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Di wute buagi puyene rind di riri, “Ni wand gre ye nganye ququ brequ te neng. Wuti nen gre quan nganye rise. Di gre tende pe ni ququ simbe nindim di ni meyi mi mo.” ");
INSERT INTO kms_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Di Jisas ningg wand vir ir tiqe buagi tende opu yeru kin ni rutungu. ");
INSERT INTO kms_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Muq Jisas God yumbui nyamb mirang kin baj te si niraq, di Saimon nde baj pe no. Tende puayi Saimon kine num yumbui kurew, ghimbi quan nganye sungue rupuw, di buid segi pu wuse. Pugri bu ni Jisas ningg mari ei ni num te puaq nunduw ningg. ");
INSERT INTO kms_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pugri bu Jisas ni nde tumo nondo, num te simbe nindiny di ni si riraq. Muq ni num oghi di brequne wes wiyo, mir wem me. ");
INSERT INTO kms_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yuram nginy naghe no pu nase kin tende puayi ni wute num isis rire kin Jisas nde mare mandi. Ni mandi di Jisas ni wute manyine kin kin si neny riwo, di ni num te oghi. ");
INSERT INTO kms_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Di ququ brequ anene wute nde pu meyi mandi di mari, “Nu God ningg wo.” Pudi ququ brequ ni nei mamb ni Kraist, wuti God tiqi nundog nandi wute nate ruwi ye, pugri bu ni ker nuam di segi puq nindim di ni wand mand segi. ");
INSERT INTO kms_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yambgriq bur cham ane ni mong wute segi ye pe tende no nas, di wute buagi ni meri miting. Ni meri miting maru maru, ni nas muqoind, di puamb muang ningg ane mas ei ni si nare di no segi ningg mari. ");
INSERT INTO kms_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pudi ni simbe nindim nari, “Nge ko ei yumbo yumbo buagi God nde si nambu rise kin wand yuwon ye te tiqe aye pe mune bir kawo ye. Puate te ningg bu ni nge tiqi nundogh gadi.” ");
INSERT INTO kms_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Di ni Judia opu no, God yumbui nyamb mirang kin baj manyi tende opu rise kin tende nar ir wand bir nawo. ");
INSERT INTO kms_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nginy iri ningg Jisas Genesaret wuye ngamo qunambe yenu, God ningg wand simbe nand, di wute buagi rindi, ni imb rip rundo rindi pu yeru, ni God ningg wand simbe nand ye te rutungu rutungu yeru, ");
INSERT INTO kms_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","di Jisas rar neq wuso at teri jiji pe te yeru nuqond. At te wute umo ningg yawi mi maghe kin ni te. Ni at te mawo yeru, di mo yawi wuye map map yemu. ");
INSERT INTO kms_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Di Jisas no, at ire ningg newo no. At ni newo kin te Saimon ningg. Muq ni Saimon ningg nari di ni at te musoq kring nipiq wuye pe wughe wuso. Muq ni at pe tende nas God ningg wand simbe nand, di wute jiji pe yeru rutungu. ");
INSERT INTO kms_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ni wute buagi wand simbe nindiny pre, di Saimon ningg nari, “At raq wuye kughe kuso kin pe tende par po, di yawi wi maghe ei umo wateri.” ");
INSERT INTO kms_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Di Saimon oyi Jisas ningg nari, “Yumbui, beghi bur mingi buid pap pap pudi umo ninge pateri segi. Pudi muq nu kuari pu pugri bu nge at kring kipiq wuye mingi tende par po, di yawi ki maghe ye.” ");
INSERT INTO kms_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Muq ni Jisas nari kin pugrine puq men: At miraq wuye mingi mar mo, yawi mi maghe di umo nganye buagi nganye righe, di yawi bir mas wand mand. ");
INSERT INTO kms_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Umo quan nganye di mate ruwi ye tuqui segi, bu ni yembe ire at aye pe kin te ngam miram mandi ni ghav mindim. Ni mandi yembe ire ghav mindim umo te mate ruwi di at teri ane bre mand. Umo quan nganye bu at mai riwo righe ruso di wuye at pe kuyo kughe. ");
INSERT INTO kms_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita ni te nuqond di ni Jisas nde muange tingine sungomyu nisir nase di nari, “Yumbui, nu nge nde ghandi wayequ, nu yo. Nge wuti yumbo ur brequ quan nganye gad ye.” ");
INSERT INTO kms_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Te pugri Saimon di wute buagi ni ane at ire pe mo kin te umo quan nganye pugri muqond, di quan nganye puye mand. ");
INSERT INTO kms_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Di Saimon kimand, Jon Jems temi mune mandi muqond di ni mune pugrine puye mand. Jon Jems temi ni Sebedi ningg wo. Muq Jisas Saimon simbe nindig nari, “Nu wune ghamb wayequ. Asi nu umo kuateri, pudi muq pu ruso otiwo nu wute oyi ghateri ye.” ");
INSERT INTO kms_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pugri bu ni at qo mamb riwo ruso jiji pe yeru, yumbo yumbo buagi si mare rise, di Jisas nde dobu maru. ");
INSERT INTO kms_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas tiqe ire ningg yenu wuti iri num brequ leprosi niraq kin nandi. Ni nandi nandi Jisas nuqoind di yimb naghe, naghe no qi pe dung di nari, “Yumbui, nu nge ghav gudigh yawo kurew, tedi nge ghav ndigh di nge ghimbi mune oghi rise ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Di Jisas si neq wundo nait nase nari, “Nge nu sabi guduw ye. Nu muqdi oghi ghas!” Di brequne num leprosi te prene di mune oghi nas. ");
INSERT INTO kms_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas ni num te puaq nindig pre, di simbe nindig nari, “Nu num te oghi pre pugri bu yo Moses nari kin pugrine puq yen. Nu yo nunon ghimbi te prist nde bei ghand, di Moses ningg lo ni wute mai puaq mand ningg umo wase mande kin te ningg wuri kin pugrine puq yen. Nu puq yen ei prist ni te muqond di mari te nganyene nu num oghi pre. Pudi nu wute aye simbe ndiny wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pudi Jisas ni puq nen kin wand te vir ir di yumbui nganye viso, pugri bu wute nganye buagi ni nde rindi ni ningg wand rutungu di ni num puaq nindiny ningg. ");
INSERT INTO kms_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pudi Jisas priprine, mong wute segi ye pe tende no, ei nikin irine nas di God ane wand. ");
INSERT INTO kms_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nginy iri ningg Jisas wute God ningg wand bei neny neny yenu. Di tende puayi prist tit ire Parisi puq mindim kin te ninge di wute Moses ningg lo wute bei meny ye ni mune anene mas. Parisi di wute Moses ningg lo wute bei meny ye ni Jerusalem tiqe buagi Galili opu yeru kin, di Judia opu yeru kin tende pu mandi. Muq God ningg gre Jisas nde vise, di ni wute num puaq nindiny tuqui. ");
INSERT INTO kms_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Di quayi ninge wuti quangi rind kin te sunyi pe mowi naghe, meri mondo, di baj pe mar mo ei Jisas nde rar ngimi mowi nase ningg mari. ");
INSERT INTO kms_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ni meri mar mo ningg tuqui map, pudi baj pe wute quan nganye bre ngim imb, di ni mar mo ye tuqui segi. Pugri bu ni wuti te meri baj wam mewo mo, di wam gri gawo mamb, di sunyi anene te gri mi naghe no. Ni mi naghe no kin te wute buagi nde mingine naghe no, di no Jisas nde rar ngimine nganye nase. ");
INSERT INTO kms_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ni nei mamb Jisas wuti te sabi nindig ye di Jisas ni nei te nundom pre, di ni wuti te simbe nindig nari, “Mand, nu yumbo ur brequ guad kin wand te puaq pre.” ");
INSERT INTO kms_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisi di wute Moses ningg lo wute bei meny ye ni te mutungu di nikin nei pene pugri nei mamb mamb mas, ni mari, “Wuti nen nari ni wute wand puaq nindim ye. Ni pugri puq nand kin te ni God wand brequ nindig. Wuti iri yumbo ur brequ kin wand te puaq nand tuqui segi, pudi God irine ni puq nen tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas ni nei te nundom pre pugri bu ni pengu nindim nari, “Pughe kin ningg nungoqi pugri nei wamb? ");
INSERT INTO kms_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wand pughe ye puq gad tedi wute riri te nganyene: Nge kari, ‘Nu yumbo ur brequ guad kin wand te puaq pre,’ o nge kari, ‘Nu yes yewo nyinge ghare yo’ puq gad di ni nyinge nare kin wuqond di nei wamb kin tuqui? ");
INSERT INTO kms_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pudi puq ken ei nungoqi nei wamb te pugri wuti God nde pu nandi wuti nganye nas ye ni qi pe ven nde yumbo ur brequ kin wand puaq nand ye gre rise.” Muq wuti nyinge nare tuqui segi ye te ningg nari, “Nge kari nu yes yewo, nunon sunyi ghateri, ghare baj pe yo.” ");
INSERT INTO kms_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Muq brequne ni nde rar ngimine wuti nyinge brequ kin te nes newo nikin nase di meri mandi kin sunyi te muet namb, nare God nyamb nindivi viyo viyo nambu no. ");
INSERT INTO kms_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wute buagi te ruqond di quan nganye puye rind, di God nyamb rindivi viyo. Ni ruqond quan nganye puye rind di riri, “Beghi yumbo asi buqod segi kin te muq buqod.” ");
INSERT INTO kms_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tende dobu Jisas nar no, di wuti iri takis nateri kin nikin takis nateri kin baj pe tende nas nuqoind. Wuti te ni nyamb Livai. Ni wuti te nuqoind di simbe nindig nari, “Nu nge nde ghawi.” ");
INSERT INTO kms_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Di Livai nikin yembe kin yumbo yumbo buagi si nare rise, di nes newo, Jisas nde dobu naru. ");
INSERT INTO kms_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Muq Livai Jisas ningg mir yumbui ire yembe nunduw. Mir te nikin nde baj pene nuaq. Ni mir te nuaq kin tende takis materi kin aye nganye buagi mandi di wute aye anene rindi, Livai nde baj pene rikur, di ni ane mir rind. ");
INSERT INTO kms_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mir pe tende Parisi di wute Moses ningg lo wute bei meny ye ni mandi di Jisas wute te ane mir rind kin te muqond di te kin ningg ni Jisas ningg wute te ane ker mawo. (Wute lo wute bei meny ye te ni mune Parisi ne.) Ni Jisas ningg wute te ker muam di mari, “Pughe kin ningg nungoqi wute takis materi kin di wute yumbo ur brequ rind kin ane mir wand di wuye we?” ");
INSERT INTO kms_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Di Jisas ni oyi nindim nari, “Wuti num gureg segi kin ni dokta nde no tuqui segi, wuti num gureg kinne ei dokta nde no. ");
INSERT INTO kms_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Te kin pugrine nge wute yumbo ur tuquine puq ren yene kateri ningg gadi segi, pudi wute yumbo ur brequ rind rind ris ye ni ningg bu gadi. Nge ni simbe gidiny ei ni nei rire ritinde ningg.” ");
INSERT INTO kms_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Di ni Jisas simbe mindig mari, “Jon ningg wute ni pripri mir uny yemu di Yumbui pengu mindig. Di Parisi mingg wute pugrine puq men. Pudi nu ningg wute ni pripri mir mand di wuye me.” ");
INSERT INTO kms_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Di Jisas nari, “Wuti iri ngam no ningg mir yembe mindiny di kimand ngam niram mandi ane mir mand. Di ni ane mir mand mand masne kin tende puayi ni kimand te mir uny yemu tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pudi otiwo wute ninge mandi wuti ngam no kin mitanyi mo ye ngeri te rindi ye. Tende puayi ei ni yivany mare di mir uny yemu.” ");
INSERT INTO kms_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Di Jisas te kin ningg ni kopuqu wand ven simbe nindim, “Wuti iri siot wuri gawo namb, di siot urupui kin puch pend nowi, di gawo pe tende rang naimb tuqui segi. Ni puq nen tedi siot urupui te unje naip, segi pend nowi. Di puch te siot wuri pe tende rang naimb, pudi urupui wuri te ane tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Di wuti iri ni wain urupui meme chongo yabe kin pe nowi naghe segi. Ni pugri puq nen tedi wain urupui te yindingi di meme chongo yabe kin te bir nuaq di meme chongo te bir wus di wain dabo no. ");
INSERT INTO kms_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pugri bu wain urupui te meme chongo urupui pene ei mawo maghe. ");
INSERT INTO kms_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wuti iri wain asi kin ne pre, tedi urupui kin mune ne yambu nari. Tedi ni nari, ‘Yabe kin te oghi’.” ");
INSERT INTO kms_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat kin nginy iri ningg Jisas nikin wute ane wit wuny mingine nyinge mare mo. Ni nyinge mare mo mo di Jisas ningg wute wit yi ninge gure mawo, materi, si pe sosi mand, chongo puaq di nganye te me. ");
INSERT INTO kms_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Muq Parisi ninge te muqond di ni pengu mindim, “Pughe ningg nungoqi Moses ningg lo te gure waq di Sabat kin nginy nen ningg yembe wand wit yi gure wawo?” ");
INSERT INTO kms_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Di Jisas oyi nari, “Devit nikin wute ane mo mo mir kurem di pughe sin men kin te nungoqi buk pe wuqond segi bri? ");
INSERT INTO kms_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Beghi bon lo wuri bret God meng ningg mawo ris kin te God meng ye. Bret te kin pristne ei me, wute aye me kin te lo segi puq wund. Pudi Devit nikin wute ane mo mo mir kurem di ni God ningg baj pe sunyi uny kin pe tende nar no di bret te nateri, nare nandi ne, di nikin wute ninge nem me. Nungoqi wand te kin buk pe wuqond o segi?” ");
INSERT INTO kms_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Di ni simbe nindim nari, “Wuti God nde pu nandi wuti nganye nas kin ni Sabat kin puate.” ");
INSERT INTO kms_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat aye ningg ni God yumbui nyamb mirang kin baj pe nar no di God ningg wand wute bei neny. Di wuti iri ni si kuti kin te ane God yumbui nyamb mirang kin baj pe tende nas. Wuti te ni si tuan brequ kuse. ");
INSERT INTO kms_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Di Parisi wute Moses ningg lo wute bei meny ye ane ni Jisas kotim maind ningg ngim meri mand ye, pugri bu ni waghine Jisas yeng muang pu yemu. Ni yeng muang ei muqond muq Sabat kin nginy te ningg ni wuti si kuti kin te sabi nindig oghi, tedi te ningg kotim maind ningg. ");
INSERT INTO kms_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pudi Jisas ni nei te nundom pre. Di ni wuti si brequ kin te simbe nindig nari, “Nu yes yewo, ghandi, wute buagi nde rar pe yeru.” Pugri simbe nindig di nes nandi, wute buagi nde rar ngimine yenu. ");
INSERT INTO kms_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Muq Jisas ni simbe nindim, “Nge nungoqi pengu guduq, Sabat kin lo pughe puq wund? Wute ghav bidiny yuwon pu ris, o wute unje pap? Wute ghav bidiny ei ris o wute bab riti?” ");
INSERT INTO kms_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Muq ni rar nat wute buagi nuqond nuqond nondo nandi pre di wuti te simbe nindig nari, “Nu si tuqu kuso.” Muq ni Jisas nari kin pugrine puq nen, ni si nituqu kuso, di brequne nganye ni si mune oghi. ");
INSERT INTO kms_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pudi ni te muqond di Jisas quan nganye umbo ker muang. Di oyi oyi pengu mand mari, “Muqdi beghi Jisas pughe sin ei beg ye?” ");
INSERT INTO kms_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tende puayi nginy iri ningg Jisas char iyu pe newo no Yumbui pengu nindig ningg. Ni te no di bur te ningg ni God pengu nindig nindigne ruso pend ruso. ");
INSERT INTO kms_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yambgriq burane nikin wute nari mandi di wute 12-pela pu si numbom di wute te aposel puq nindim. ");
INSERT INTO kms_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wute 12-pela pu te ni nap mo kin taq men: Saimon (ni nyamb aye te Pita puq nindig) ni kiqam Andru temi, Jems, Jon, Pilip, Bartolomyu, ");
INSERT INTO kms_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems Alpius ningg wo, Saimon ni Selot ningg wute tit kin iri, ");
INSERT INTO kms_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jems ningg wo, di Judas Iskariot otiwo ni Jisas veri nde si pe ni nondo kin te. ");
INSERT INTO kms_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Muq Jisas aposel te ane char iyu pe pu mati mi bed pe yemu. Di bed pe tende nikin wute nganye buagi rindi, tende rikur pu yeru. Di wute aye tiqe isis kin nganye buagi nganye rindi tende rikur pu yeru pre. Wute te tiqe buagi Judia opu yeru kin te pu rindi, Jerusalem pu rindi di tiqe yumbui gherim qunambe yeru kin Tair di Saidon pu rindi. ");
INSERT INTO kms_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wute buagi te Jisas nde rindi ni ningg wand rutungu di num puaq nindiny ningg. Wute ninge ququ brequ ni nde yemu kin te ni ququ brequ te puaq nindiny. ");
INSERT INTO kms_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Di gre Jisas nde pu viyi vindi di wute nganye buagi num di ququ brequ puaq nindiny. Wute ni rit nase kin te ninggne di ni num oghi di ququ brequ wu mase mo. Pugri bu wute nganye buagi ni rit nase ningg tuqui rip rip. ");
INSERT INTO kms_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Muq Jisas rar neq wundo nikin wute te nuqond di nari, “Nungoqi wutaqu yumbo quan segi kin nungoqi chumbuai wand, te pugri tumo di nungoqi God nde si nambu was. ");
INSERT INTO kms_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nungoqi wutaqu muq mir tuqui segi di mir ane was kin te nungoqi chumbuai wand, te pugri God nungoqi tuqui nupuqu ye. Nungoqi wutaqu muq yivany ane was kin te nungoqi chumbuai wand, te pugri nungoqi oyi chumbuai ane was ye. ");
INSERT INTO kms_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nungoqi wutaqu nge, wuti God nde pu gadi wuti nganye kas kin, nge nei wumbigh di nge ningg nyamb bir wawo ye te ningg wute buagi nungoqi yambu mireuq di ni nde tumo wondo mundoqu yambu mari, di nyamb brequ munduq. Nginy te ningg nungoqi pugri puq meuq kin tende nungoqi chumbuai wand, nungoqi yuwon pu was. ");
INSERT INTO kms_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wute nungoqi pugri puq meuq kin nginy tende nungoqi nyinge wawo di quan nganye chumbuai wand. Te pugri God oyi nungoqi oyi nunduq kin yumbo yumbui nganye nginy tu wam nuauq rise. Muq ni nungoqi puq meuq kin te asi ni kuqo mune propet pugrine puq mem ye. ");
INSERT INTO kms_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pudi nungoqi wutaqu muq yumbo quan rise kin nungoqi muq qi pe yuwon pu was di quan nganye chumbuai wand pre. Otiwo di God nungoqi mai neuq. ");
INSERT INTO kms_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nungoqi wutaqu mir tuqui kin te, otiwo di God nungoqi mai neuq di nungoqi oyi mir tuqui segi di mir ane was. Nungoqi chumbuai ane was di wur wur was kin te otiwo di God oyi nungoqi mai neuq di nungoqi quanji wand di yivany ane was. ");
INSERT INTO kms_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nungoqi wutaqu muq wute buagi aye chumbuai munduq di nungoqi nyamb mindivi viyo kin te, otiwo di God oyi nungoqi mai neuq. Wute nungoqi chumbuai munduq di yuwon muauq kin te asi ni kuqo propet wandoqi kin pugrine nganye yuwon muam ye.” ");
INSERT INTO kms_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Muq Jisas mune nari, “Nungoqi muq nge ningg wand wutungu wutungu yequ kin wen, nge nungoqi simbe guduq: Nungoqi non veri yawo wurany righe, di wute nungoqi yambu mireuq kin te nungoqi oyi ni yuwon wam, ");
INSERT INTO kms_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","di wute nungoqi awo mumbuq kin te nungoqi oyi God pengu wundig ei ni yuwon nuam, wute nungoqi wand brequ munduq kin te nungoqi oyi God pengu wundig ei ni oyi yuwon nuam. ");
INSERT INTO kms_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wuti iri nu kowisambe opu dang nunduw, te piyi rar qoind opu gri mune dangne nunduw. Wuti iri nu chongo ire nitaw wi, te piyi rar qoind aye te mune nitaw wi. ");
INSERT INTO kms_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wute nungoqi yumbo ningg sang mupuq te nungoqi wem, yawo nduq wayequ. Di wute nungoqi yumbo ninge mitaquri kin te nungoqi mune wateri ningg wari wayequ, te piyi ni mare mo. ");
INSERT INTO kms_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yumbo ur buagi wute aye nungoqi nde puq ren ningg wari kin pugrine ei nungoqi mune ninde puq weny. ");
INSERT INTO kms_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nungoqi wute nungoqi yawo rirauq righe kin tene yawo wurany righe kin te eti wari God te kin ningg nungoqi chumbuai nunduq ningg puq wand. Wute yumbo ur brequ rind kin pugrine wute ni yawo rirany righe kin tene ni oyi yawo rirany righe ye. ");
INSERT INTO kms_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Di nungoqi wute nungoqi yuwon muauq kin tene muq oyi sabi wundim kin te eti wari God te kin ningg nungoqi chumbuai nunduq ye. Wute yumbo ur brequ kin ni te kin pugrine qa puq ren ye. ");
INSERT INTO kms_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Di nungoqi wute yumbo wem di nei wamb wute te otiwo ni oyi nungoqi wem kin tuquine oyi mune meuq ye tuqui. Pugri bu nungoqi wute tene ei yumbo wem. Nungoqi pugri puq wen ye te eti wari God nungoqi te kin ningg chumbuai nunduq. Wute yumbo ur brequ rind kin ni pugrine wute aye yumbo ur brequ rind kin te yumbo reny pu ei otiwo ni oyi mune te kin tuquine reny ye. ");
INSERT INTO kms_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pudi nungoqi oyi nungoqi non veri yawo wurany righe, sabi wundiny, yumbo weny di ni oyi oyi runduq ye te ningg wari muq weny wayequ, segi ei weny. Nungoqi pugri puq wen, tedi God oyi nungoqi oyi nunduq kin te quan nganye. God ni wute brequ kin di wute ni chumbuai rindig segi kin te anene yuwon nuany ye. Pugri bu nungoqi te kin pugrine puq wen, tedi wute aye rundoqu di nei rimb nungoqi God wam nganye kin ni ningg wo. ");
INSERT INTO kms_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Beghi wuyi wute buagi yawo nitony kin pugrine ei nungoqi mune wute aye yawo wutony.” ");
INSERT INTO kms_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Wute aye ni yumbo ur brequ te wundony di brequ puq wundiny segi, tedi God oyi nungoqi brequ puq nunduq segine. Wute aye yumbo ur te wundony wupiny ruso segi, tedi God oyi nungoqi yumbo ur brequ te rupuqu ruso segine. Wute nungoqi unje mupuq pudi nungoqi wand te puaq wundiny, tedi God oyi nungoqi wand puaq nunduq.” ");
INSERT INTO kms_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jisas kopuqu wand ven nand, “Nungoqi wute aye yumbo weny, tedi God oyi nungoqi wute aye yumbo weny kin pugrine neuq. Ni oyi quan nganye ei nungoqi nde si wam nuauq di nungoqi si bre di ninge buraq ri ye. Nungoqi wute aye yumbo pughe gri pu weny ye te kin pugrine ei God nungoqi oyi neuq ye.” ");
INSERT INTO kms_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Di ni kopuqu wand aye ren mune simbe nindiny: “Wuti iri rar brequ kin ni wuti aye rar brequ kinne si niting rise di nitanyi no ye tuqui segi. Tedi ni temi ane ngamo pe ir maghe. ");
INSERT INTO kms_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Skul wokuandi iri nikin tisa nde yumbui di nikin tisa oyi ni nde nambu nas segi. Tisa ni yumbui di skul wokuandi oyi tisa nde nambu. Pudi skul wokuandi ni skul omo nuaq, tedi nikin tisa ane tuquine. ");
INSERT INTO kms_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pughe kin ningg nu yumbo tinanji nimand nde rar pe yequ kin te muq gudoq, pudi nyumo bidi yumbui nu non rar pe yequ kin te gudoq segi? ");
INSERT INTO kms_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pughe gri ei nyumo bidi yumbui nu non rar pe yequ kin te nei gubuw segine, muq nu non nimand ningg kuari, ‘Mand, nu yeru nge tinanji woju nu nde rar pe yequ kin te kitaw wi?’ Nu wuti nei tevi kin! Nyumo bidi nu non nde rar pe yequ kin te taqwi pre, ei nu oghine rar ghat, muqdi tinanji woju nimand nde rar pe yequ kin te taqwi.” ");
INSERT INTO kms_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nyumo nyam kure kin pe nyumo yi brequ kin riyi segi, di brequ kuse kin pe mune pugrine nyumo yi yuwon kin riyi segi. ");
INSERT INTO kms_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nyumo manyi wute nikin yi te mundony di nei mamb nyumo te nyam kure kin o brequ kuse kin. Wute sanyi yi sare mundim pe riyi pu yeru map segi, di wain yi sare tubrege pe riyi pu yeru map segi. ");
INSERT INTO kms_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Te kin pugrine wuti oghi kin nei yuwon ye ni nde umbo pe rise kin te simbe nand, di wuti brequ kin nei brequ ye ni nde umbo pe rise kin te ei simbe nand ye. Mim nikin nei pe wand vind segi, mim ni wuti ningg nei umbo pe bre pu rise kin te bu simbe vind.” ");
INSERT INTO kms_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nungoqi nge kari kin yumbo ur te puq wen segi, tedi pughe kin ningg nge ningg wari, ‘Yumbui, Yumbui?’ ");
INSERT INTO kms_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wuti nge nde nandi nge ningg wand nutungu di nge kari kin pugrine puq nen kin te, muqdi nge nungoqi simbe guduq ni pughe gri ei nas ye. ");
INSERT INTO kms_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wuti te kin ni wuti iri baj yembe nindig ningg di qi ngamo nuaq naghe no wet yumbui iri raqe naind, muq simen wet wam tende nawo muq baj yembe nindig kin pugri. Otiwo wuye nime nandi kin tende puayi wuye nime baj te si numbony, pudi baj te viso vighe di bir segi. Ni baj gre ye nganye yembe nindiny, pugri bu bir ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Pudi wuti nge ningg wand nutungu pudi nge kari kin pugri puq nen segi kin te, ni wuti iri ngamo nuaq naghe no simen nowi muq baj yembe nindig segi, ni wuti qi wamne baj yembe nindig kin te ane tuqui. Otiwo wuye nime nase kin tende puayi wuye nime baj te si numbony di baj te bi viso vighe di bir vis omone viso.” ");
INSERT INTO kms_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas wute buagi wand ren simbe nindiny nindiny pre di Kaperneam nar no. ");
INSERT INTO kms_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kaperneam pe wuti iri num yumbui gureg di nati ningg tumo pu nase. Wuti te Rom kin ami mingg yumbui ni ningg yembe ye wuti iri. Ami kin yumbui ni wuti nen quan nganye nei nimbig ye. ");
INSERT INTO kms_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Rom kin ami mingg yumbui ni nutungu Jisas Kaperneam nandi, di ni Juda ye quayi kiyi ninge tiqi nundom Jisas nde mo. Ni mo Jisas simbe mindig ei nandi ni ningg yembe ye wuti te sabi nindig ningg. ");
INSERT INTO kms_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wute te tiqi nundom mo kin te mo Jisas nde mo mar di Jisas simbe mindig di mitanyi ne mo ningg quan nganye buid map. Ni pugri simbe mindig, “Nu segine wuti nen nde baj pe yo di ghav ndig. ");
INSERT INTO kms_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Te pugri ni beghi Juda yuwon nuangu ye. Nikin wet bidi pene yumbo wong nand di beghi Juda God yumbui nyamb mirang kin baj yembe mundug.” ");
INSERT INTO kms_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Muq Jisas ni ane mo. Jisas ami mingg yumbui nde baj pe tumo nondo nondone di ami mingg yumbui te kimand tiqi nundom mandi ei Jisas pugri simbe mindig ningg, “Yumbui, nu nyinge ghare nge nde baj pe gheyi yi wayequ, te nu yembe yumbui guad. Nge wuti oghi nganye segi, pugri bu nu ngende baj pe ghandi wayequ. ");
INSERT INTO kms_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nge wuti oghi segi pugri bu nge nge ningne mune nu nde godo kin te oghi nganye segine. Pugri bu wute te tiqi gudom mondo. Te ningg bu nu ghandi segi, pudi nu wandne simbe ghand, di nge yembe ye wuti te num oghi. ");
INSERT INTO kms_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nge nei gab nu wuti te sabi gudig tuqui. Te pugri nge mune wuti nyamb kin iri nde si nambune kas ye, di ami oyi nge nde si nambu mas. Pugri bu nge ami iri simbe gidig kari, ‘Nu yo,’ di ni no; aye simbe gidig kari, ‘Ghandi,’ di ni nandi; nge yembe ye wuti ningg kari, ‘Nu yembe te yembe ndiny,’ di ni yembe nindiny.” ");
INSERT INTO kms_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas ni wand ren kin nutungu di ni quan nganye puye nand, di tindi nondo wute buagi ni nde dobu ruru kin te simbe nindiny, “Nge nungoqi simbe guduq, wuti iri God pugri nganye nei nimbig kin te nge guqoid segi. Israel pe mune wuti nen kin iri guqoid segine.” ");
INSERT INTO kms_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Muq wute ami mingg yumbui tiqi nundom mo kin te mune baj pe mandi, di yembe ye wuti te mune num oghi pu nas muqoind. ");
INSERT INTO kms_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tende dobu Jisas tiqe ire Nain puq munduw kin tende no. Ni no di nikin wute di wute buagi aye te ni nde dobu ruru kin te ni anene riso. ");
INSERT INTO kms_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ni riso tiqe ngimrawu pe riso rir pune di wute tiqe te kin wuti ambonye iri nati kin te meri meyi mandi. Wuti ambonye te wute ire ni ngaim nati pre kin nyarimo nyumbueg wus ye ni ningg wo. Ni wo aye segi, quayi wo te irine nas ye muq nati. Pugri bu ni wuti te meri mandi di wute nganye buagi ni kumo ane ruwi. ");
INSERT INTO kms_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas nyumbueg te nundoq di quan nganye yawo nitow. Di simbe nunduw nari, “Quanji ghand wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Muq ni wuti mowi naghe kin nyembe pe tumo nondo, si neq wundo nyembe nitiq wuse di wute nyembe miraq kin te mune nyinge mare segi, pugrine yemu. Di ni nari, “Ambonye, nge nu simbe guduw, nu yes yewo!” ");
INSERT INTO kms_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Di wuti nati pre kin te mune nes newo nas di wand nand. Di Jisas wuti ambonye te mune nitanyi nondo kumo nde si neri. ");
INSERT INTO kms_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wute buagi te ruqond di quan nganye puye rind, di God nyamb rindivi viyo riri, “Propet yumbui nganye iri beghi nde bre nowi pre. God nikin wute ghav nindiny ningg nandi pre.” ");
INSERT INTO kms_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Di wand ven kin vir ir tiqe buagi Judia opu yeru kin te rutungu, di tiqe aye pe opu yeru kin te mune rutungu ne. ");
INSERT INTO kms_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon wute wuye nap kin ni ningg wute Jisas yumbo yumbo buagi ren puq nen ye wand te Jon simbe mindig. Di ni nikin wute temi nari mandi, ");
INSERT INTO kms_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","di tiqi nundom Yumbui nde mandi ei pugri pengu mindig ningg, “Nu wuti God tiqi nundog nandi puq nand kin tene bri guadi o beghi wuti aye bri ghimbi buag pu pas ye?” ");
INSERT INTO kms_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Muq wute temi te mandi Jisas nde mi meyi di mari, “Jon wute wuye nap ye ni beghi tiqi nundog bu nu nde badi ei wand ven pengu buduw ningg, ‘Nu wuti God tiqi nundog nandi puq nand kin tene bri guadi o beghi wuti aye bri ghimbi buag pu pas ye’?” ");
INSERT INTO kms_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ni temi mandi pu yemu kin tende puayine Jisas wute num isis rire kin num puaq nindiny, di wute ququ brequ ane kin ququ brequ puaq nindiny. Wute nganye buagi rar brequ kin te sabi nindiny di mune rar rit. ");
INSERT INTO kms_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pre, muq ni wute temi Jon ningg wand mare mandi ye te oyi simbe nindim nari, “Mune wo di yumbo yumbo buagi nungoqi non rar pe wuqond di wute aye men simbe munduq wutungu kin te Jon simbe wundig: Wute rar chukoq kin te ni mune rar bure rind, wute nyinge brequ kin mune nyinge rire, wute leprosi riraq kin te ghimbi mune yuwon rind, wute ange ghave rimbiny kin munene wand rutungu, wute riti kin mune res riwo, di wute yumbo segi kin te ni wand yuwon ye bir muany rutungu. ");
INSERT INTO kms_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wute nge yumbo yumbo buagi puq ken ye te ruqond, pudi nge dob regh segi kin wute te chumbuai rind.” ");
INSERT INTO kms_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wute Jon ningg wand mare mandi kin te mo pre, Jisas wute buagi te yeru kin te Jon ningg simbe nindiny nari, “Nungoqi mong wuye di nyumo segi ye pe wo Jon wuqoind kin te ni kombu kin pugri nyumurighi neri no nandi nandi bri yenu wuqoind? Te segi, Jon ni kombu kin pugri segi, ni gre pu yenu ye. ");
INSERT INTO kms_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pudi te segi, tedi yumbo pughe kin wuqond yamb wo? Wuti iri chongo yuwon ye bri nare righe pu yenu bu wo wuqoind ningg? Te segi, wute chongo yuwon ye mare righe di yumbo yuwon yuwon ghimbi pe mare righe kin te king ningg baj pe mas ye. ");
INSERT INTO kms_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nungoqi yumbo pughe kin wuqond yamb wo? Propet iri bri wuqoind ningg wo? Te nganyene, nge nungoqi simbe guduq, Jon ni mune yumbui nganye, propet aye ni ane tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wuti nen ningg qa God nde buk pe pugri ur mand, ‘Nge wuti iri nge ningg wand nare no kin te tiqi gudog ye nawo nu ngim sabi nunduw.’ ");
INSERT INTO kms_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nge nungoqi simbe guduq, wuti iri qi pe ven nde kin Jon nde yumbui nas segi, Jon irine yumbui. Pudi wute God nde si nambu ris kin tende wuti iri nyamb segi wokuandi kin pugri nas kin te ni oyi Jon nde yumbui.” ");
INSERT INTO kms_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wute buagi di wute takis materi kin anene ni Jon ningg wand rutungu di Jon wuye nap pre ye. Pugri bu muq ni Jisas Jon ningg wand ren simbe nand ye ren rutungu di riri God ni yumbo buagi tuquine nganye puq nen. ");
INSERT INTO kms_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pudi Parisi di wute lo quan nganye nei mamb ye ni asine Jon ningg wand mutungu yambu mari bu ni wuye nap segi, pugri bu ni God nari kin pugri puq men segi. ");
INSERT INTO kms_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas nari, “Nge yumbo pughe kin ningg ei wand gad ei nungoqi muq ven nde puayi was kin te ane tuquine? ");
INSERT INTO kms_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nungoqi wokuandi kin pugri, ni ruso tiqe moqi ris, wokuandi aye mune rindi muq ni oyi oyi wand rind riri, ‘Beghi pereru piq budouq ei nungoqi nyinge wawo ningg pari, pudi nungoqi nyinge wawo segi. Di beghi yivany kin yuwo pari ei nungoqi quanji wand ningg pari, pudi nungoqi quanji wand segi.’ ");
INSERT INTO kms_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Te kin pugrine Jon wute wuye nap ye nandi kin ni mir quan nand segi, di wain ne segi, di nungoqi wari ququ brequ ninde yenu. ");
INSERT INTO kms_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Di nge, wuti God nde pu gadi wuti nganye kas kin, nge gadi kin nge mir gad di wain ke di nungoqi wari, ‘Nungoqi wuti nen wuqoind. Ni mir quan nand di wain quan ne, ni wute takis materi kin di wute yumbo ur brequ rind kin kimand.’ ");
INSERT INTO kms_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Beghi temu yumbo ur kin kinne yembe bidiny pudi nungoqi temu ane yambu wurengu. Pudi God beghi nde yembe nand kin te bei rind ni nei te yuwon nganye.” ");
INSERT INTO kms_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Muq Parisi iri Jisas ningg nari ei Jisas nondo ni ane mir mand ningg. Pugri bu Jisas Parisi tende baj pe no di ane mas mir mand. ");
INSERT INTO kms_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Di wute ire tende wus. Wute te ngimne nyumbueg, asine yumbo ur brequ wund wund rindi rindi muq. Ni Jisas mir nand yamb nandi pu Parisi nde baj pe tende nas ye te wutungu. Di ni os wo yuwon ye ire wet pe yembe munduw kin pe tende wel yuwon tuqo neri kin te wuwi naghe wuri wundi. ");
INSERT INTO kms_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ni wundi Jisas nde dobu muange tingi yequ, quanji wund, di ni ngam giji wuye Jisas nde muange wam ir mati, di nikin yu pe ku wumb. Di yimb wughe, wughe wuso Jisas nyinge song wurang, di wel yuwon tuqo neri kin nyinge wam groq wundig. ");
INSERT INTO kms_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisi te Jisas ningg nari ninde baj pe nondo ye te ni te nuqond di nikin nei pene pugri nei namb, “Wute wen ngimne nyumbueg ire bu ni wuit nase. Wuti nen nganyene propet iri, tedi ni nei namb wute wen pughe gib wumb ye bu ni wuit nase.” ");
INSERT INTO kms_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas ni nei nundog, pugri bu ni oyi oyi nindig nari, “Saimon, nge nu wand ire simbe guduw ningg.” Di ni oyi nari, “Tisa, be simbe ghand.” ");
INSERT INTO kms_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Di Jisas simbe nand nari, “Wute temi wuti iri nde mo wet bidi ninge materi, di otiwo ni oyi mune oyi mindig ye. (Wuti te nikin bisnis yembe te wute aye wet bidi nem pu ei otiwo ni oyi mune oyi mindig kin tende di so rundo meng ye.) Wuti iri no ni ningg nari di silva kin wet bidi 500-pela nateri. Di wuti aye mune ni nde no nari di silva wet bidi 50-pela nateri. ");
INSERT INTO kms_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ni temi wet bidi te materi pre, pudi ni temi ane oyi mindig ye tuqui segi, ni temi wet bidi segi. Pugri bu ni segi puq nindim nari, ‘Te piyi, nungoqi tequ ane nge wet bidi te oyi wundigh wayequ.’ Ni pugri puq nindim, tedi nu nei guab kin wuti pughe ye ei ni quan chumbuai nindig ye?” ");
INSERT INTO kms_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Di Saimon nari, “Nge nei gab kin wuti wet bidi quan nateri kin te ei wuti te quan nganye chumbuai nindig ye.” Muq Jisas nari, “Nu tuquine nei guab.” ");
INSERT INTO kms_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Muq ni tindi nondo nyumbueg te nundoq di Saimon simbe nindig nari, “Nu nyumbueg wen yumbo ur wund kin guqod bu? Nge nu nde baj pe keyi gadi pudi nu nge wuye kuegh di nyinge wuye kap segi. Pudi nyumbueg wen nikin ngam giji wuye pe nge nyinge wuye wupigh, di nikin yu pe ku wumb. ");
INSERT INTO kms_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nu nge song kuregh segi, pudi nyumbueg wen nge keyi gadi kasne di ni wundi yimb wughe nge nyinge song wureny kin tene rise rise. ");
INSERT INTO kms_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nu nge nde ngawu pe wel groq gudigh segi, pudi wute wen wel tuqo yuwon ye nge nyinge bage wam groq wundigh. ");
INSERT INTO kms_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pugri bu nge nu simbe guduw, wuti yumbo ur brequ musoqne nand pu muq God puaq nindig kin te musoqne chumbuai nand ye. Nyumbueg wen ni quan nganye yumbo ur brequ wund ye, pudi ni nge quan nganye nei wumbigh, pugri bu ni yumbo ur brequ wund kin wand te puaq pre.” ");
INSERT INTO kms_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Muq Jisas ni simbe nunduw, “Nu yumbo ur brequ guad kin wand te puaq pre.” ");
INSERT INTO kms_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Di wute aye mune mir pe tende mandi pu mas ye te ni wand ren mutungu di kin kin wand mand mari, “Wuti nen tughe? Ni wute aye yumbo ur brequ rind ye wand te mune puaq nindiny yene?” ");
INSERT INTO kms_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Di Jisas nyumbueg te simbe nunduw nari, “Nu yivany ghare wayequ, nu umbo yuwon pu kuse di yo. Nu nge nei gubigh ye te ningg nu wand puaq pre.” ");
INSERT INTO kms_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tende dobu Jisas nyinge nare tiqe manyi nar ir. Tiqe yumbui di tiqe woju tende nar ir yumbo yumbo buagi God nde si nambu rise ye te kin wand yuwon ye bir nawo. Ni no di nikin wute 12-pela pu te ni ane mo. ");
INSERT INTO kms_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Di nyumbueg ninge Jisas ququ brequ puaq nindiny di num puaq nindiny kin te ni mune anene ruso. Wute te, Maria (tiqe Magdala kin) ni ququ brequ 7-pela pu yemu pudi Jisas tiqi nundom meyi mi mo kin te. ");
INSERT INTO kms_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Di Kusa ngam Joana, ni ngaim Kusa ni Herot nde baj pe yembe mand ye yumbui, di Susana, di nyumbueg nganye buagi aye. Wute ren nikin wet bidi di yumbo yumbo pene Jisas nikin wute ane ghav rindim ningg bu ane ruso. ");
INSERT INTO kms_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wute buagi tiqe manyi kin rindi, Jisas nde rikur kur di Jisas kopuqu wand ven simbe nindiny, ");
INSERT INTO kms_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wuti iri nikin wuny mbe no di wit yi puraq nand. Ni puraq nand nand di wit yi ninge ngimne ir ri, di wute nyinge ruwo di wapi rindi riq. ");
INSERT INTO kms_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ninge qi wet quan kumo kus ye pe ir riti righe kin te ruwi pre pudi wuye segi, pugri bu quari rimb. ");
INSERT INTO kms_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit yi ninge ruso nyungo quat kin pe ir ri di nyungo quat kin ni nambu wi ruso. ");
INSERT INTO kms_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Di yi ninge qi yuwon ye pe ir ri. Yi qi yuwon pe ir ri kin te yuwonne ruwi, yumbui ruso di yi riyi. Ni asi musoqne puraq nand pudi muq oyi wit puate ire ire yi 100-pela pugri riyi.” Ni kopuqu wand ven simbe nand pre di ngam nare wute buagi te simbe nindiny, “Wuti iri ni nutungu kin tuqui tedi ange nuaq ei wand ren nutungu.” ");
INSERT INTO kms_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas nikin wute ni pengu mindig ei ni kopuqu wand ven kin puate raqe nand ningg mari. ");
INSERT INTO kms_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Muq Jisas nari, “Yumbo yumbo buagi God nde si nambu rise kin wand suqo pu rise kin te God nungoqi nei neuq di nungoqi nei wumbiny tuqui. Pudi wute aye kin te nge kopuqu wand pe simbe gidiny ei ni rar pe ruqond pudi yumbo ninge ruqond rip ruso segi, di ange ruaq rutungu pudi nei rimb segi. ");
INSERT INTO kms_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kopuqu wand te kin puate taq ven: Wit yi te God ningg wand. ");
INSERT INTO kms_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit yi ninge ngimne ir righe kin te, te wute God ningg wand rutungu di umbo pe ruwo vis, pudi ququ brequ mingg yumbui nandi wand ninde umbo vis kin te puaq nindiny viso. Ni puq neny ei ni God dob reng di God oyi mune ni nateri segine. ");
INSERT INTO kms_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wit yi wet pe ir righe kin te wute tughe ni wand ven rutungu di brequne chumbuai ane ritevi. Pudi ni tumuri maghe mo segi kin pugri, ni wand te kin nei pe ruwo ris nganye segi. Ni God ningg wand rutungu pudi mai isis rindi ninde meriwo di ni God ningg wand brequne si rire. ");
INSERT INTO kms_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wit yi ninge nyungo quat kin pe ir righe kin te wute wand rutungu, pudi otiwo ni ruso mai rire di te kin quan nganye nei kumo rimbiny, wet bidi nei rimbiny, di qi pe kin yumbo te chumbuai rindiny, di te kin puq ren yawo kureny. Nei ren kin oyi ni nei imb ruany di God ningg wand oghine nei rimbiny segi. Wute te kin ni wit yi oghine uri rind segi kin pugri. ");
INSERT INTO kms_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pudi wit yi qi puch oghi kin pe ir righe kin te, te wute yuwon ye di nei yuwon ye rise ye. Ni God ningg wand rutungu di nei pe ruwo ris ye. Ni mai rire pudi God dob reng segi, ni wit kin pugri yi riyi. ");
INSERT INTO kms_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wuti iri lam nindiq pre di os pe but niraq o ede nambu neq wur wuso suqo niraq segi ye, ni wam niraq wughe pu yequ ei wute aye mandi di lam ti te muqond tuqui. ");
INSERT INTO kms_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Te pugri yumbo suqo pu rise ye te raqe ruso wute buagi nei rimb ye, di yumbo but pu rise kin te raqene rise di wute buagi nei rimb ye. ");
INSERT INTO kms_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pugri bu God ningg wand oghine wutungu di ni nari kin pugrine ei puq wen. Te pugri wuti God ningg wand asi nutungu kin te nat vise ye te otiwo God ni aye neng, pudi wuti God ningg wand nutungu kin te menare viso ye, tedi God ni wuti tende wand puch nganye vise kin te mune natevi.” ");
INSERT INTO kms_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Muq Jisas kumo di kiqam ane Jisas ruqoind ningg rindi. Ni riyi rindi ningg pudi wute quan nganye bre pugri bu ni Jisas nde tumo rundo ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Muq wute ninge Jisas simbe mindig, “Nu numo niqam ane rindi pu dabo sange te yeru, ni nu ghimbi ruaw pu yeru. Ni nu ruqoind ningg.” ");
INSERT INTO kms_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pudi ni oyi nari, “Wute God ningg wand rutungu di God nari kin pugrine puq ren kin te nge moyu di qam.” ");
INSERT INTO kms_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nginy iri ningg Jisas nikin wute simbe nindim nari, “Wandi wuye ngamo pe pu opu gri te po pewo.” Muq ni at pe mewo mo di mo. ");
INSERT INTO kms_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ni mo mo ngimi Jisas ruqo nase. Ni ruqo nase di nyumurighi yumbui wuye ngamo pe tende naghe di wuye seme gub. Di wuye at pe kuyo kughe bu at wughe wuso ningg tumo. ");
INSERT INTO kms_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Muq nikin wute mondo ni buraq mindig di mari, “Yumbui, Yumbui! Beghi wuye pe paghe po wuye pe di pati yamb.” Muq Jisas nes newo, nyumurighi di wuye seme gub kin te segi puq nindiny, di nyumurighi nati di wuye mune kuti yuwon pu kuse. ");
INSERT INTO kms_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Di nikin wute simbe nindim nari, “Nungoqi God nei wumbig segi bri?” Ni te muqond, di puye mand, di wune mamb, di kin kin wand mand mari, “Wuti nen tughe? Ni nyumurighi wuye ane simbe nindiny di ni mune ni ningg wand rutungu ne ye!” ");
INSERT INTO kms_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Muq Jisas nikin wute ane at pe Gerasa opu mo. Gerasa te Galili wuye ngamo pe opu gri yequ. ");
INSERT INTO kms_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ni mo Gadara mo mar, Jisas naghe no, jiji pe nyinge nare newo no pune wuti iri tiqe te kin ququ brequ ane kin ni nde nandi. Wuti nen ni yabe chuqone nganye chongo nare righe segi, omone yenu ye. Di ni yabe chuqone baj pe nas segi, ni wute mati mawo yemu ye ngamo pe tende nas ye. ");
INSERT INTO kms_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wuti te Jisas nuqoind, di quan kumone nari, di Jisas nde rar ngimine sungomyu sungomyu yenu, di quanne ngam nare nari, “Jisas, God Wam Nganye nas kin wo, nu nge pughe sin kuegh ningg? Nge nu pengu guduw, nu nge unje ghaip wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Te pugri Jisas asine ququ brequ te simbe nindig ei wuti te si neri neyi ni no ningg. Pugri bu muq wuti te pugri ngam nare. Yabe chuqo nganye ququ brequ te ninde yenu, di wuti te ququ brequ ningg nei pe nyinge nare ye. Wute pripri ni si nyinge sen pe taq mimbig di taq maimb pu yenu, pudi ni pripri sen te pend nawo, di ququ brequ gri ni nitanyi vig namb mong wute segi ye pe tende no. ");
INSERT INTO kms_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Muq Jisas ni pengu nindig nari, “Nu nyamb pughene?” Ququ nganye buagi ninde yemu ye pugri bu ni oyi nari, “Nge nyamb Ami.” ");
INSERT INTO kms_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Muq ni Jisas pengu mindig ei ni brequ nindim segi ningg quan nganye buid map. Eti Jisas ni ngamo pre segi kin pe tende menare maghe ye te ningg wune mamb. ");
INSERT INTO kms_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Rand qunambe tende pu quan tende ruso yeru mir rind rind. Muq ququ brequ Jisas pengu mindig ni ngiq nindim ei ni mo pu pe tende oyi mar mo ningg. Di Jisas ngiq nindim. ");
INSERT INTO kms_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Di ququ brequ wuti tende pu meyi mandi, di mo pu pe tende oyi mar mo. Di pu buagi te oyi vig rimb, rand wari pe te righe ruso, di ruso wuye ngamo pe ir righe, wuye riq di riti. ");
INSERT INTO kms_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wute pu yeng muany kin ni te muqond, di vig mamb mo, Gadara simbe mand di tiqe wo tende opu yeru kin tende mo simbe mand. ");
INSERT INTO kms_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ni mo simbe mand, di wute buagi ruso yumbo te ruqond ningg. Ni rindi Jisas nde di wuti Jisas ququ brequ puaq nindig kin te Jisas nde muange tingi te nas ruqoind. Wuti te muq ni nei mune yuwon rise di chongo nare righe pu nas. Ni te ruqond di wune rimb. ");
INSERT INTO kms_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Di wute ninge yeru ruqond ruqondne Jisas pughe gri wuti ququ brequ ane kin te ququ brequ puaq nindig ye wand te wute aye muq rindi kin te simbe rindiny. ");
INSERT INTO kms_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wute buagi Gerasa opu kin ni Jisas yumbo ren puq nen kin te ruqond di quan nganye wune rimb. Pugri bu ni Jisas simbe rindig ei ni si nare aye pe opu no. Pugri bu ni mune at pe newo no ei no ningg. ");
INSERT INTO kms_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ni newo no di wuti ququ brequ puaq nindig kin te nandi Jisas pengu nindig nari, “Nge nungoqi ane po.” Pudi ni segi puq nindig di tiqi nundog nari, ");
INSERT INTO kms_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mune nu non tiqe yo, God nu pughe gri ghav nunduw kin te wute aye simbe ndiny.” Pugri bu wuti te no, di Jisas pughe gri ni ququ brequ puaq nindig ye wand te wute buagi tiqe te kin simbe nindiny. ");
INSERT INTO kms_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Galili wuye ngamo pe opu gri tende wute Jisas ghimbi ruang pu yeru. Pugri bu Jisas nikin wute ane mune mondo ruqond di ni quan nganye chumbuai rindig. ");
INSERT INTO kms_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Muq wuti iri nandi Jisas nde muange tingi sungomyu nisir nase, di Jisas ningg nari ei ni temi ninde baj pe mo ningg. Wuti te ni nyamb Jairus di ni God yumbui nyamb mirang kin baj te kin ye quayi kiyi iri. ");
INSERT INTO kms_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairus ni wo irene wus ye. Wo te nyumbueg wo, ni ber 12-pela kin pugri, pudi muq ni wuti yamb tumo pu wuse. Pugri bu kiyi nandi Jisas ningg nari ei nitanyi ninde baj pe no ningg. Muq Jisas nyinge nare Jairus nde baj pe no. Ni no di wute buagi rindi ni imb rip rundo rindi di ap ruwi ningg tumo. ");
INSERT INTO kms_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Di tende puayi nyumbueg ire tende wus ye ni uny chiraq yequ ruso ber 12-pela pu ruso, pudi wuti iri ni sabi nunduw ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Muq ni Jisas nde dobu gri wuwi, Jisas chongo cheqne wuting wuse, di brequne ni uny te prene, mune oghi. ");
INSERT INTO kms_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Muq Jisas pengu nand, “Wuti tughe nge nait kase?” Ni pengu nand pudi wute buagi suqo rire, di Pita nari, “Yumbui, wute nganye buagi nu imb rip rundo rindi.” ");
INSERT INTO kms_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pudi Jisas nari, “Segi, wuti iri nge nait kase pre. Gre ngende vise kin te kutungu kutungu ne viyi vindi viso, pugri bu nge nei gab wuti iri nge nait kase.” ");
INSERT INTO kms_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wute te wuqond Jisas nei namb pre bu ni suqo wure ye tuqui segi, di ni wundi Jisas nde muange tingine sungomyu sungomyu wuse, di wute buagi nde rar pene ni Jisas simbe wundig. Ni wuri ni uny pu yequ yequ ber 12-pela pu pudi wuti iri ni sabi nunduw ye tuqui segi, pugri bu ni wundi Jisas wuit nase di opu uny pendne. ");
INSERT INTO kms_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Muq Jisas ni simbe nunduw nari, “Nge wo, nu nonne nei guab kuari nu nge chongo kuat rise di nu oghi ye puq guad kin te ningg bu nu oghi. Nu umbo yuwon pu kuse di yo.” ");
INSERT INTO kms_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas wand wandne yenu di wuti iri Jairus, wuti God yumbui nyamb mirang ye baj kin quayi kiyi iri, ninde baj pe pu nandi di Jairus ningg nari, “Nu wo wuti pre. Nu segi Tisa tanyi nunde baj pe yo wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas te nutungu di Jairus simbe nindig nari, “Nu wune ghamb wayequ. God ne nei mbig gre, tedi nu wo te mune yuwon pu wus tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisas no Jairus nde baj pe nitari righe di wute buagi segi puq nindiny dabone yeru. Di nine, Pita, Jon, Jems, di nyumbueg wo te kin kiyi kumo pugri pune rir ruso. ");
INSERT INTO kms_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wute buagi aye nyumbueg wo te ningg yivany riraw di quanji runduw runduw ris. Jisas te nuqond di nari, “Nungoqi quanji wand wayequ, ni wuti segi, ni ruqo wuse.” ");
INSERT INTO kms_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wute buagi te ris kin ni nyumbueg te rundoq wuti pre ye. Pugri bu Jisas pugri puq nand di ni wur ring. ");
INSERT INTO kms_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pudi Jisas si neq wundo, nyumbueg wo te si nituw kuse di nari, “Nge wo, yes yewo!” ");
INSERT INTO kms_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ni puq nand di nyumbueg wo te nikin ququ mune wundi wughe di opu brequne wes wiyo teti pu yequ. Muq Jisas ni simbe nindiny ei ni mir ninge rew wuq. ");
INSERT INTO kms_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ni kiyi kumo te ruqond di quan nganye puye rind, pudi Jisas ni simbe nindiny nari, “Wute aye wand ren kin simbe wundiny wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas nikin wute 12-pela pu te nari mandi mikur, di ni yembe nem di gre nem ei mo wute ququ brequ buagi puaq mindiny di num puaq mindiny kin tuqui. ");
INSERT INTO kms_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ni gre nem pre di tiqi nundom mo ei yumbo buagi God nde si nambu rise ye te kin wand bir mawo di wute num puaq mindiny ningg. ");
INSERT INTO kms_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Di ni simbe nindim nari, “Nungoqi nyinge ware wo kin tende yumbo ninge ware wo wayequ. Nungoqi botu ware ei botu botu wo wayequ, tami ware wayequ, di bret ware wayequ, wet bidi ware wayequ, di chongo aye ware wayequ, omone ei wo. ");
INSERT INTO kms_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nungoqi tiqe ire ningg wo muq baj pughe ye pe wo te baj te ninggne ei was was otiwo tiqe te si wuraq di tiqe aye pe wo. ");
INSERT INTO kms_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nungoqi tiqe ire ningg wo muq wute tiqe te kin nungoqi mitaqu wowi segi, te nungoqi nyinge pe kin qusuqu te buraq wand. Nungoqi puq wen ei wute tiqe te kin ruqond ei nei rimb ni nungoqi ritaqu wowi segi kin te ningg ni yumbo ur brequ rind pre. Pugri puq wen pre muqdi tiqe te si wuraq di tiqe aye pe wo.” ");
INSERT INTO kms_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ni pugri simbe nindim pre muq ni tiqe manyi te mar ir mo, wand yuwon ye bir mawo di wute num puaq mindiny. ");
INSERT INTO kms_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Muq Herot Galili kin yumbui ni Jisas nikin wute ane yumbo buagi puq men kin te nutungu. Ni nutungu wute ninge mari Jon wute wuye nap ye mune nes newo pre. Di ninge mari Elaija mune nandi pre, di ninge mari yabe chuqo kin propet iri muq mune nes newo pre. Ni wand isis mand pugri bu Herot ni ghabe nand di nari ni nganyene mand o wandoqi mand. ");
INSERT INTO kms_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pudi Herot nari, “Nge kutungu kin wuti nen yumbo ur gre ye nganye puq nen. Wuti nen tughe bri? Jon nge kari di asine gibe di muang pre ye.” Di ni Jisas nuqoind ningg buid nap nap. ");
INSERT INTO kms_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposel mune mandi Jisas nde mi meyi di ni yumbo buagi puq men kin te Jisas simbe mindig. Muq Jisas ni nitami waghine ni kinne nyinge mare Betsaida mo. ");
INSERT INTO kms_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pudi wute buagi ni nei rimb Jisas nikin wute ane te mo pugri bu ni ninde dobu ruru. Ni ruru kin te ningg Jisas ni segi puq nindiny segi, ni chumbuai nindiny di yumbo buagi God nde si nambu rise ye te kin wand simbe nindiny. Di wute ninge num rire kin te num sabi nindiny. ");
INSERT INTO kms_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yuram bur Jisas nikin wute 12-pela pu te Jisas nde mandi di ni simbe mindig mari, “Beghi muq mong wute segi ye pe ven nde pas, pugri bu nu wute buagi ren tiqi ndony kin kin tiqe tumo yeru kin tende ruso ei mir meri rind di bur rise kin sunyi meri rind.” ");
INSERT INTO kms_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Di Jisas oyi nari, “Nungoqi ei mir weny riq.” Tende puayi quayine 5 tausen kin pugri tende mas. Pugri bu Jisas ningg wute oyi mari, “Pudi beghi bret 5-pela pune di umo terine rise. Beghi po mir aye wong bad, tedi wute buagi ren tuqui pap.” Pudi Jisas nikin wute te simbe nindim nari, “Wute buagi te bir wawo 50 50 wawo ris, 50-pela pu kinne ris, 50-pela pu kinne ris. Te tene ruso ruso wute buagi omone wawo.” ");
INSERT INTO kms_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Muq Jisas ningg wute Jisas nari kin pugrine puq men. Wute buagi chuchu ris pre, ");
INSERT INTO kms_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","di Jisas bret 5-pela di umo teri te nateri, wam rar neq wiyo God chumbuai nindig pre di bret te bir nawo. Pre muq nikin wute nde ni rundo di ni mare mo wute buagi te meny. ");
INSERT INTO kms_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Di ni buagi ane mir rind ruso ruso mir rimbiq. Jisas nikin wute mo mir cham te materi imbi pe mawo righe ruso imbi 12-pela pu bre mand. ");
INSERT INTO kms_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nginy iri ningg Jisas nikin wute anene mas, di Jisas God pengu nindig nindig nas. Tende puayi di Jisas nikin wute te pengu nindim nari, “Wute buagi pughe puq rind, nge tughe bu?” ");
INSERT INTO kms_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Di ni mari, “Wute ninge riri Jon wute wuye nap kin, ninge riri Elaija, di ninge riri yabe kin propet iri muq mune nes newo pre.” ");
INSERT INTO kms_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Di ni mune pengu nindim nari, “Pudi nungoqi pughe gri nei wamb? Nungoqi wari nge tughe bu?” Di Pita nari, “Nu Kraist, wuti beghi kutamu powi ningg God naip kuo kin.” ");
INSERT INTO kms_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Muq Jisas ni wute aye wand ven kin simbe mindiny ye te ningg segi nganye puq nindim pu ei ni simbe mand segi. ");
INSERT INTO kms_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Di Jisas nari, “Wuti God nde pu nandi wuti nganye nas kin ni mai quan ei nare. Di quayi kiyi, prist mingg yumbui di wute Moses ningg lo wute bei meny kin ni yambu mireng ye. Ni mi nati, di nginy temi mo pre aye ningg di God mune nindingi newo.” ");
INSERT INTO kms_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Muq ni simbe nindim nari, “Wuti nge nde nawi ningg, tedi ni yumbo buagi qi pe kin te dob neny di nge mai kiraq kin pugrine nginy manyi manyi ei niraq. ");
INSERT INTO kms_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te pugri wuti tughe nikin ghimbine nei nimbiny nimbiny di nati tedi ni nas nas te kin nas tuqui segi, pudi wuti tughe nge ningg nikin ghimbi nei nimbiny segi di nati tedi ni otiwo yuwon pu nas nas te kin nas ye. ");
INSERT INTO kms_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wuti iri nge dob negh, qi pe kin yumbo yumbo oyi quan nei nimbiny, di yumbo te kin yembe nand nand muq nati, tedi yumbo te pughe gri ei ni ghav rindig ye? Te tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wuti iri ni wute nde rar pe nari ni nge ningg wuti di nge wand natevi puq nand kin te ningg minyuw nati, tedi otiwo nge ngening ti yumbui, wuyi ningg ti, di angelo yuwon ye mingg ti ane gadi kin tende puayi di nge, wuti God nde pu gadi wuti nganye kas kin, nge oyi mune ni minyuw kiteng. ");
INSERT INTO kms_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nge nungoqi nganyene simbe guduq, nungoqi muq wen yequ kin wen wute ninge mati segine di yumbo buagi God nde si nambu rise kin te muqond.” ");
INSERT INTO kms_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas pugri puq nand pre, nginy 8-pela pu mo pre, ni Pita Jon di Jems pugri pu nate mowi, ni ane rand pe mewo mo, ei ni Yumbui pengu nindig ningg. ");
INSERT INTO kms_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ni mo tende mo mar, Jisas Yumbui pengu nindig nindig yenu, di ni quenge kin grine nase di ni chongo quan nganye ti riri. Chongo ti riri kin te pris naghe di ti nase kin pugri. ");
INSERT INTO kms_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Muq wute temi, Moses Elaija temi ");
INSERT INTO kms_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wam kin ti yumbui ane mandi pu Jisas ane yemu wand wand. Ni wand mand kin te otiwo Jisas no Jerusalem di mi nati ei God nari kin te ane tuquine. Muq ni mi ye te kin ningg wand mand mand yemu. ");
INSERT INTO kms_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita di wute temi te ane ruqoi kurem di ruqo mase. Pudi otiwo ni mune mes mewo, Jisas ningg ti te muqond muq rar mat di Moses Elaija temi ni ane yemu wand wand muqond. ");
INSERT INTO kms_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses Elaija temi mune mewo mo mo kin tende puayi Pita Jisas ningg nari, “Yumbui, beghi ven nde pas te yuwon. Nu ngiq ghand tedi beghi baj yirbu teri ire pu ven nde yembe bidiny. Ire nu te, ire Moses te, di ire Elaija te.” Pita ni nei namb segi, bu pugri wand nand. ");
INSERT INTO kms_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita wand nand nandne di wuye quari wuti wi ni buag wure. Di ni wune ane wuye quari nambu te yemu. ");
INSERT INTO kms_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Muq wuti iri wuye quari wam te pu ngam nare nari, “Nen nge wo, nge ni kaip no. Nungoqi ni ningg wand wutungu.” ");
INSERT INTO kms_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wuti wand nand kin te prene muq mune rar mat di Jisas irine yenu muqoind. Jisas ningg wute temi ire pu te tende puayi yumbo pugri kin muqond, pudi wute aye simbe mindiny segi. Nikin nei pene rise. ");
INSERT INTO kms_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yambgriq ni rand pe te pu mati mi di wute nganye buagi rindi, Jisas ghimbi ruang pu tamu te yeru. ");
INSERT INTO kms_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Ni mandi ninde mi meyi yemu, di wuti iri mingi tende yenu pu quanne nari, “Tisa, nge wo irine nas ye muq ququ brequ ni nde nas. Pugri bu pripri ququ brequ ni puye yis nireng di ni quan kumo nari, di ququ brequ te ni meneri no naghe, buyaq nand di napu ninde mim pe ruwi riti. Ququ brequ te ni si neri segi, pugri bu ni ghimbi quan nganye unje niping. Pugri bu nge nu pengu guduw, nu nge wo nen qoind. ");
INSERT INTO kms_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nge nu non wute nge wo nen ququ brequ te puaq mindig ningg kari pudi ni puq men tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Muq Jisas nari, “Nungoqi wutaqu God nei wumbig segi ye, di yumbo ur brequ quan kumo wand ye. Nge nungoqi ane pas nganye chiraq tuqui segi. Nge nungoqi mai quan nganye kare yambu kari.” Pre muq wuti te ningg nari, “Nu wo te ven tanyi ghandi.” ");
INSERT INTO kms_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wo te Jisas nde nandi nandine di ququ brequ mune nganye wo te meneri no naghe tingi nase di quan nganye buyaq nand. Pudi Jisas ququ brequ te ker nuang no, wo te sabi nindig di mune kiyi nde ni nondo. ");
INSERT INTO kms_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wute buagi God ningg gre yumbui te ruqond di quan nganye puye rind. Wute buagi Jisas yumbo ren kin puq nen ye te ningg nei kumo rimb rimbne yeru, di Jisas nikin wute pugri simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nge nungoqi wand ninge simbe guduq yamb. Nungoqi ange waq di otinde wutungu. Te pugri wuti God nde pu nandi wuti nganye nas kin ni wute nde si pe mi nondo ye.” ");
INSERT INTO kms_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nikin wute wand ven mutungu pudi wand ven kin puate nei mimbiny segi. God ni wand ven kin puate suqo niram, pugri bu ni wand ven mutungu pudi puate nei mimbiny ye tuqui segi. Di ni Jisas wand ven kin puate ningg pengu mindig ye wunene mamb. ");
INSERT INTO kms_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas ningg wute 12-pela pu te wuti tughe ei yumbui ningg nas ye te ningg kin kin mari. ");
INSERT INTO kms_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pudi Jisas ni nei te nundom pre, pugri bu ni wo iri nari nandi ni nde tumo yenu, ");
INSERT INTO kms_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","muq ni simbe nindim nari, “Wuti iri ni nge nde nyamb pe wokuandi nen neti nowi sabi nindig, te ni nge bu neti kowi sabi nindigh. Wuti nge neti kowi sabi nindigh kin te wuti nge tiqi nundogh gadi kin te neti nowi sabi nindig. Te pugri wuti iri nungoqi nde wokuandi nen kin pugri nyamb segi kin nas te ni yumbui nas.” ");
INSERT INTO kms_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Muq Jon nari, “Yumbui, beghi wuti iri buqoid nu nde nyamb pe ququ brequ puaq nand. Pudi wuti te aye kin, ni beghi nde dobu nawi segi ye. Pugri bu beghi ni segi puq bidig ei mune puq nen segi.” ");
INSERT INTO kms_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Muq Jisas nari, “Nungoqi ni segi puq wundig wayequ. Te pugri wuti tughe nungoqi veri ningg nas segi kin ni nungoqi nde opu nas.” ");
INSERT INTO kms_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God Jisas nitanyi wam newo no kin ngeri te tumo rind rind, pugri bu Jisas Jerusalem no ningg. Ni Jerusalem no kin nei gre nganye vind, ");
INSERT INTO kms_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","di ni wute ninge tiqi nundom mo ei ni yumbo sir miping. Ni mo Samaria mingg tiqe ire pe mar mo, di tende yumbo sir miping ningg. ");
INSERT INTO kms_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pudi wute tiqe te kin ni mutungu Jisas ni Jerusalem no ningg bu nandi pugri bu ni ngiq mindig segi. ");
INSERT INTO kms_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Muq Jisas nikin wute Jon Jems temi te muqond, di Jisas pengu mindig mari, “Yumbui, nu puq guad tedi beghi God ningg pari ei wase wam pu ir nawo kuti ni wase namb.” ");
INSERT INTO kms_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pudi Jisas tindi nondo ni temi ker nuam. ");
INSERT INTO kms_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Di ni nyinge mare tiqe aye pe mo. ");
INSERT INTO kms_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ni nyinge mare mo mo di wuti iri nandi Jisas ningg nari, “Nge nu ane po ye. Nu muainde opu kuo te nge ane po ye.” ");
INSERT INTO kms_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Di Jisas oyi nand nari, “Nyombui dabo kin nikin rise kin sunyi yeru, di wapi nikin rise kin nyuw yeru. Pudi nge, wuti God nde pu gadi wuti nganye kas kin, nge kase kin sunyi segi.” ");
INSERT INTO kms_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Di Jisas wuti aye ningg mune nari, “Nu nge nde dobu ghawi.” Pudi wuti te nari, “Yumbui, nge nu nde karu ye. Pudi nu ngiq ghand ei nge ko wuyi yeng guag pu kas, otiwo nati ngamo kowi pre muqdi gadi nu ane po.” ");
INSERT INTO kms_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Di Jisas nari, “Wute Yumbui nei mimbig segi kin ni wute mati pre kin pugri. Ni ei mo wute mati kin te mawo yemu. Pudi nu yo, yumbo buagi God nde si nambu rise ye te kin wand bir ghawo.” ");
INSERT INTO kms_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wuti aye mune nari, “Yumbui, nge nu nde dobu karu ye. Pudi nu nge ngiq ndigh ei nge ko nge yavi ire te simbe gidiny pre muqdi gadi nu ane po.” ");
INSERT INTO kms_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Di Jisas wuti te simbe nindig nari, “Wuti stia nait nase kin ni si stia pe kuse, pudi ni priprine dobu rar neq wuso kin te ni wute God nde si nambu ris ye te kin yembe nand ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tende dobu Jisas wute aye 72-pela pu si numbom di tiqi nundom tiqe yumbui di tiqe wo manyi te mo. Ni wute temi temi tiqi nundom tiqe manyi te mo. Ni tende tiqi nundom mo kin te Jisas nikinne no yamb, pugri bu ni tiqi nundom ye mawo. ");
INSERT INTO kms_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ni tiqi nundom mo ningg di kopuqu wand ven simbe nindim nari, “Mir nganye buagi nguan pu rise, pudi wute yembe kin quan segi. Pugri bu wuny kiyi pengu wundig ei ni wute yembe kin quan tiqi nundom nikin wuny mbe tende mo ei yembe mand. ");
INSERT INTO kms_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nungoqi wo. Nge nungoqi tiqi gudoqu sipsip wo nyombui dabo kin pe mingi ruso kin pugri wo. ");
INSERT INTO kms_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nungoqi tami ware di hanpaus ware wayequ. Di sendel ware wayequ, omone ei wo. Wute ninge ngimi wuqond tende yequ di ane wand wand wayequ, wo wone. ");
INSERT INTO kms_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nungoqi baj ire pe war wo, tedi wand ye viwo kin te wari, ‘God nungoqi puq neuq umbo yuwon pu kuse.’ ");
INSERT INTO kms_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nungoqi pugri puq wand ei wuti yuwon kin iri baj tende nas, tedi nungoqi ningg wand yuwon ye ven ninde umbo pe vis. Pudi wuti te kin iri nas segi, tedi wand yuwon ye te nu non ndene mune vindi. ");
INSERT INTO kms_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nungoqi baj te ninggne was, aye pe wo wayequ. Tene ei was, di mir pughene reuq te we, di wuye pughe reuq te we. Te pugri nungoqi yumbo reuq kin te nungoqi wand bir wawo ye te ningg God wong nunduqu kin pugri. Pugri bu baj ire ninggne ei was, aye pe aye pe mune wo wayequ. ");
INSERT INTO kms_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nungoqi tiqe ire ningg wo muq wute tiqe te kin nungoqi wondo ye te ningg chumbuai rinduq di ritaqu baj pe ruso, te muqdi mir pughe kin reuq ye te we. ");
INSERT INTO kms_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Di wute num kin tiqe tende ris ye te num puaq wundiny, di simbe wundiny wari, ‘Wute di yumbo yumbo buagi God nde si nambu rise ye nginy te nungoqi nde tumo nase pre.’ ");
INSERT INTO kms_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pudi tiqe ire ningg wo muq wute tiqe te kin nungoqi ngiq runduq muq ritaqu baj pe ruso di sabi runduq segi, te muqdi puq wen: War wo tiqe mingine yequ di wari, ");
INSERT INTO kms_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nungoqi non tiqe pe kin qusuqu beghi nde nyinge pe kangi ruso kin te nungoqi non nde tiqe pene mune ku bab. Nungoqi yumbo ur te kin wuqond ei nei wamb, nungoqi pugri puq wen ye te ningg nungoqi unje wap pre. Nungoqi pugri puq wen, pudi yumbo ren ei nei wumbiny, yumbo buagi God nde si nambu rise ye te kin nginy tumo nase pre!’ ");
INSERT INTO kms_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nge nungoqi simbe guduq, God ni wute ir nawo kin nginy te ningg di wute tiqe wen kin ni mai quan kumo rire. Ni mai rire kin te wute Sodom kin asi mai rire kin te ane tuqui segi. Sodom mai musoqne, ni te oyi quan nganye ei.” ");
INSERT INTO kms_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas ni mune nari, “Nungoqi Korasin, otiwo nungoqi pughe gri ei was, di nungoqi Betsaida, otiwo nungoqi pughe gri ei was ye. Nge yumbo ur gre ye nungoqi nde bei gad kin te nge tiqe brequ kin teri ren Tair di Saidon pe bei gad, tedi wute te kin yabene nei rire ritinde pre. Tedi muq ni asi yumbo ur brequ rind ye te ningg ei yivany rire, di yivany kin chongo rire righe, di wase inyap righe pu ris. ");
INSERT INTO kms_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pudi God wute ir nawo kin nginy tende di nungoqi mai quan nganye ei ware. Tair di Saidon ni ane tuqui segi, ni musoqne. ");
INSERT INTO kms_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Di nungoqi Kaperneam, nungoqi wari nungoqi mitaqu wam bri mewo mo ye? Tuqui segi. Nungoqi tamu nganye ei waghe wo, wute mati kin tiqe pe wo ye. ");
INSERT INTO kms_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Wuti tughe nungoqi ningg wand nutungu, ni nge ningg wand nutungu. Wuti nungoqi dob neuq, ni nge dob negh, di wuti nge dob negh kin te ni God nge tiqi nundogh gadi kin te dob neng.” ");
INSERT INTO kms_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wute 72-pela pu asi tiqi nundom mo kin te mune Jisas nde mandi. Ni chumbuai ane mandi di Jisas ningg mari, “Yumbui, ququ brequ mune beghi ningg wand mutungu ne. Beghi nu nde nyamb pe ni simbe bidim, di ni beghi ningg wand mutungu.” ");
INSERT INTO kms_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Di Jisas nari, “Nge Satan wam pu ir nati naghe guqoid. Ni ir naghe kin te nginy tu wam pris naghe kin pugri. ");
INSERT INTO kms_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yumbo ninge nungoqi unje rupuqu tuqui segi. Nge nungoqi gre keuq pre. Gre te ghati di tangegamyi nyinge wawo maghe ye, di veri ningg gre buagi nyinge wawo righe ye. ");
INSERT INTO kms_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pudi ququ brequ buagi nungoqi ningg wand mutungu ye te ninggne chumbuai wand wayequ; God nungoqi nyamb nginy tu wam ni nde buk pe nuauq pre, pugri bu nungoqi te ningg ei chumbuai wand.” ");
INSERT INTO kms_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tende puayi Ququ Yuwon Ye gri puq nen di Jisas chumbuai nand di nari, “Wuyi nu yumbo ren puq kuen kin ren nu non asine nei gubiny te yuwon, pugri bu muq puq kuen: Wuyi nge nu nyamb gidivi viyo. Nu wam kin yumbui di tingi kin yumbui. Wute quan nei mamb ye pe nu yumbo ren suqo kuram, di wute wokuandi kin pugri ris ye te oyi nu bei gudiny. ");
INSERT INTO kms_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Yumbo buagi ren nge wuyi nge nde si wam nuagh pre. Nge wuti tughe, te kin wuti iri nei namb segi, nge wuyi irine ni nge nei nimbigh. Di nge wuyi ni wuti tughe, te kin wuti iri nei namb segi, nge ni ningg wo irine nge nei gab, di wute nge bei gidiny yawo kuregh di bei gidiny kin tene nei rimb.” ");
INSERT INTO kms_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Te pre Jisas nikin wute ane ni kinne mas, muq Jisas tindi nondo nikin wute waghine simbe nindim nari, “Wute yumbo nungoqi wuqond kin pugrine ruqond kin te chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nge nungoqi simbe guduq, yabe chuqo kin propet nganye buagi di king nganye buagi yumbo yumbo nungoqi wuqond kin ren muqond ningg mari, pudi muqond segi, di wand nungoqi wutungu kin te mutungu ningg mari, pudi mutungu segi.” ");
INSERT INTO kms_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Muq wuti iri lo quan nganye nei namb ye ni nes newo Jisas pengu nindig. Ni segine Jisas pengu nindig ei nuqond Jisas lo nei bri namb. Ni pugri pengu nand nari, “Tisa, nge pughe sin ken ei otiwo nge kati di God nge neti kowi ni ane pas pas te kin pas ye?” ");
INSERT INTO kms_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Di Jisas oyi nari, “Lo buk pe pughe gri ur mand? Nu guqod kin lo pughe puq wund?” ");
INSERT INTO kms_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Di wuti te oyi pugri oyi nand nari, “Lo wuri, ‘Nu Yumbui nunon God te ei nunde umbo pe, ququ pe gri, nei pe di gre pe yawo rang righe.’ Di ‘nu non ghimbi yawo kurany righe kin pugrine wute aye nunde tumo ris kin te yawo rany righe’.” ");
INSERT INTO kms_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Di Jisas nari, “Nu tuquine oyi guad. Nu pugrine puq yen tedi ghati segi.” ");
INSERT INTO kms_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pudi wuti te nei namb kin nari eti Jisas ni nari ni nei segi bu pugri pengu nand. Te ningg bu ni mune nganye pengu nand nari, “Wute tughe nge nde tumo mas kin te ei nge yuwon kuam ye?” ");
INSERT INTO kms_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Muq Jisas oyi ni oyi nindig nari, “Wuti iri Jerusalem pu nes newo Jeriko naghe no ningg. Ni naghe no no ngimi di wute nyungu kin mait nase, yumbo yumbo di chongo mitangri, di wuti te mi mi rar ori nati pu nase ni mo. ");
INSERT INTO kms_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Muq tende puayine prist iri mune ngim te ninggne naghe no. Ni no no, wuti te ngimne nase nuqoind, di ni puaq nand ngim dabo sange opu gri no no nar di no. ");
INSERT INTO kms_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Livai kin iri mune pugrine, ni nandi ngimne tende ni neyi di wuti te nase nuqoind. Di ni dabo sangene puaq nand di no. ");
INSERT INTO kms_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaria ni wute aye kin. Pudi wuti Samaria kin iri mune ngim te ninggne nandi nandi, di wuti mi kin sunyi pe tende ni neyi. Di wuti mi mi rar ori nati pu nase kin te nuqoind di yawo nitong. ");
INSERT INTO kms_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Di ni nondo wuti te nuqoind, di pend kin pe wel nueng, di wain nueng, di taq nimbig. Pre di neti nowi ni ningg donki pe ni newo, di neri baj ire wute wonji pu mandi di tende mase ye tende neri no, nowi nase, di yeng nuang. ");
INSERT INTO kms_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yambgriq ni silva bidi teri nateri, wuti baj pe tende yembe nand ye te neng di simbe nindig nari, ‘Nu wuti nen yeng wang. Nu wet bidi pughe gri pu wuti nen ningg yumbo wong gudig pu te otiwo nge mune gadi di oyi guduw ye’.” ");
INSERT INTO kms_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas pugri wand nand pre muq wuti te pengu nindig nari, “Wute temi ire pu men, wuti tughe wuti nyungu kin mi ye te ningg wand ire kin pugri?” ");
INSERT INTO kms_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muq wuti lo quan nei namb kin te Jisas oyi nindig nari, “Wuti ni yawo nitong kin te.” Di Jisas ni simbe nindig nari, “Nu yo, te kin pugrine puq yen.” ");
INSERT INTO kms_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas nikin wute ane mo mo, tiqe ire ningg mo mar. Tiqe tende wute ire ni nyamb Marta, ni tende wus. Ni mo tiqe te ningg mo mar, di Marta wute mowi ninde baj pe mo. ");
INSERT INTO kms_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ni kiqam ire wus, ni nyamb Maria. Maria ni wuso pu Yumbui nde muange tingi wus, ni ningg wand wutungu wutungu. ");
INSERT INTO kms_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pudi Marta irene mir wase wuwo wuwo yequ. Ni Jisas ningg wand wutungu yawo kurew, pudi ni yembe kumo wund pugri bu ni Jisas ningg wand oghine wutungu tuqui segi. Di wundi Jisas ningg wuri, “Yumbui, nu guqod nge qam nge si wuri nge ning irine yengu mir wase kawo kawo. Nu te kin nei gubiny o segi? Nu ni simbe nduw ei wundi nge ghav wundigh.” ");
INSERT INTO kms_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Muq Yumbui ni oyi nunduw nari, “Marta, Marta. Nu yumbo quan nei gubiny, di te ningg quan yivany kuare. ");
INSERT INTO kms_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nu yumbo irene ei nei mbuw. Maria ni yumbo te nei wumbuw di wutaqwi pre. Yumbo te yuwon. Muq wute aye yumbo te ninde pu mitaqwi tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nginy iri ningg Jisas sunyi ire ningg nas God pengu nindig. God ane wand pre nikin wuti iri ni pengu nindig nari, “Yumbui, beghi God ane wand ningg di beghi pughe gri ei wand bad? Jon nikin wute bei nem kin pugrine nu mune beghi bei yengu.” ");
INSERT INTO kms_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Muq Jisas ni simbe nindim nari, “Nungoqi God pengu wundig kin te pugri ei puq wand: Wuyi, beghi nu pengu buduw ei nu wute nei yeny ei ni riri nu nyamb yuwon nganye. Beghi nu pengu buduw ei wute di yumbo buagi nu nde si nambu ris ye ngeri te tumo ndiny. ");
INSERT INTO kms_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nginy manyi manyi beghi mir yengu. ");
INSERT INTO kms_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wute aye beghi unje rupumu pudi beghi ni wand puaq bidiny pugri bu nu beghi wand puaq ndug. Di nu Satan rar qoind beghi wandoqi nundug wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Muq ni simbe nindim nari, “Nungoqi nimand mas, muq nungoqi bur mingi pu nimand nde wo di wari, ‘Mand, nu nge bret teri ire pu yegh. ");
INSERT INTO kms_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nge mand iri wonji pu nandi, di nge nde baj pe nas, pudi nge mir geg kin segi, pugri bu gadi nu ningg kari.’ ");
INSERT INTO kms_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Nungoqi puq wand muq nimand wabe nas kin te nari, ‘Nu nge yembe yegh wayequ. Nge ngim yabe kiraq wughe di nge wo ane ruqo pase pre. Muq mune kes kewo di bret kew tuqui segi.’ ");
INSERT INTO kms_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nge nungoqi simbe guduq, te piyi wuti te nes newo di ni kimand yumbo te neng yambu nari, pudi ni nari nari nganye pugri bu ni si yavi nati di nes newo nandi yumbo ni nari kin tuquine neng. Ni kimand kin te kin nei namb bu neng segi. ");
INSERT INTO kms_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Pugri bu nge nungoqi simbe guduq, yumbo ningg pengu wand tedi wateri, meri wutiny tedi wuqond, priprine ngimrawu baq wand tedi ngim bi muauq. ");
INSERT INTO kms_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pugri bu wute buagi yumbo materi ningg pengu mand kin te materi ye, di wute yumbo muqond ningg meri mitiny kin te muqond ye, di wute ngimrawu baq mand kin te ngim bi muam. ");
INSERT INTO kms_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nungoqi wuti tughe ni kuwonyimi umo ningg kiyi ningg nari, pudi kiyi oyi ni ghati neng? ");
INSERT INTO kms_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ni wapi nyoq ningg nari, pudi kiyi oyi ni tangegamyi neng? Te tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nungoqi wutaqu brequ kin pudi nungoqi wo yumbo yuwon kin weny ye te nei wamb. Te kin pugrine nungoqi nuyi wam nas kin ni wute Ququ Yuwon Ye nem ningg quan nganye chumbuai nand. Pugri bu wuti God ni Ququ Yuwon Ye neng ningg pengu nindig, tedi ni neng ye.” ");
INSERT INTO kms_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas wuti iri ququ brequ puaq nindig. Ququ brequ te wute wand mand segi kin. Pugri bu ququ brequ te wuti tende yenu di wuti te wand nand segi ye. Muq Jisas ni ququ brequ te puaq nindig, di wuti te mune wand nand. Wute buagi te ruqond, di quan nganye puye rind. ");
INSERT INTO kms_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pudi wute ninge riri, “Wuti nen ni ququ brequ mingg yumbui, Belsebul puq mindig kin, ni ningg gre pe ququ brequ puaq nand.” ");
INSERT INTO kms_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Di wute ninge Jisas wandoqi mindig ningg pengu mindig ei ni God ningg gre pe yumbo gre ye ninge yembe nindiny ni muqond tedi mari God ningg gre ninde vise. ");
INSERT INTO kms_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ni pugri nei mamb ye te Jisas ni nei te nundom di ni pugri simbe nindim, “Kantri ire ni bir mawo di kin kin mege, tedi kantri te oghine yembe wund tuqui segi, ir wughe ye. Di wuti iri ngam wo ane bir ruwo di priprine riri riri, tedi ane ruwo gudo tuqui segi, kin kin yeru. ");
INSERT INTO kms_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te kin pugrine muq ququ buagi Satan nde si nambu mas kin ni bir kin kin mo, tedi ni gre pu yemu kin tuqui segi. Nge guqod kin nungoqi wari nge Belsebul ningg gre pe ququ brequ puaq gad, pugri bu nge pugri puq gad. ");
INSERT INTO kms_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nge Belsebul ningg gre pe ququ brequ puaq gad, tedi nungoqi non wute tughe nde gre pe ququ brequ puaq mand? Nungoqi non wute tene bei munduq nungoqi unje wap. ");
INSERT INTO kms_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pudi nge God ningg gre pe ququ brequ puaq gad, tedi wute God nde si nambu ris ye ngeri te nungoqi nde rindi pre. ");
INSERT INTO kms_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wuti gre kin iri ni yeng kin yumbo yumbo nare pu nikin baj yeng nuany pu yenu, tedi yumbo buagi nikin baj pe rise kin te yuwonne rise. ");
INSERT INTO kms_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wuti te ni nei namb kin ni yeng kin chongo te nare righe pugri bu wute aye mandi ni mi kin tuqui segi. Pudi wuti iri quan nganye gre kin nandi ni temi mege, nine wuti te ni, tedi ni oyi ni ningg yeng kin yumbo te nitangri di ni yumbo yumbo buagi aye te anene nateri. ");
INSERT INTO kms_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Wuti iri ni nge wuti segi, tedi ni nge veri. Wuti nge ghav nindigh di sipsip pirur segi kin wuti te ni oyi sipsip bub nare ruso ye. ");
INSERT INTO kms_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ququ brequ iri wuti iri nde pu neyi ni no, ni no mong wuye segi ye pe tende no nas yawotuan kin sunyi meri nand. Ni no meri nand, pudi sunyi ire nuqond segi, tedi nari, ‘Nge ngening baj asi kas pu gadi kin tendene ei mune ko ye.’ ");
INSERT INTO kms_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ni mune nandi baj te nuqond, baj te bureng map yuwon di yumbo yumbo buagi irepene mirur. ");
INSERT INTO kms_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Muq ni no di ququ brequ aye 7-pela pu nitami nandi. Ni musoq brequ, pudi ququ brequ aye 7-pela pu nitami nandi kin te ni oyi quan nganye brequ ye. Ni mandi wuti tende mar mo mas, di wuti te asi ni musoq yuwon pu nas pudi muq quan nganye brequ nase.” ");
INSERT INTO kms_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ni wand ren kin nand nand di wute buagi te yeru kin tende mingi pu wute ire quanne wuri, “Numo tughe nu wuri wundi di bag wuimb kin wute te ni chumbuai wund.” ");
INSERT INTO kms_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Di Jisas oyi nari, “Te segi, wute God ningg wand rutungu di ni nari kin pugrine puq ren ye wute te ni chumbuai rind.” ");
INSERT INTO kms_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wute quan rindi rikur kur di Jisas nari, “Wute buagi muq ven nde puayi kin ni wute tit brequ kin. Ni yumbo ur gre ye ire mundoq ningg mari. Pudi nge yumbo ur ire bei gidim segi ye, ni Jona ningg yumbo ur tene ei muqond. ");
INSERT INTO kms_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Te pugri Jona te asi God yumbo ur bei nand kin pugri wute Ninive kin bei nindiny. Te kin pugrine muq nge, wuti God nde pu gadi wuti nganye kas kin, nge God nikin yumbo ur wute muq ven nde puayi kin bei nindiny kin pugri. ");
INSERT INTO kms_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","God ni wute ir nawo kin tende puayi di wute tit muq ven nde puayi kin te mune res riwo kin tende di kwin Siba opu kin te anene wes wiyo. Ni anene wes wiyo di wute tit muq kin ren nikin yumbo ur brequ te raqe wundiny. Te pugri asi ni Solomon wand wutungu ningg di qi cheq pe pu wes wiyo wundi. Pudi muq wuti Solomon nde yumbui kin iri nandi pre pudi nungoqi ni ningg wand wutungu segi. ");
INSERT INTO kms_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Otiwo God wute ir nawo kin tende puayi di wute Ninive kin ni Jona wand bir nawo ye te ningg ni nei rire ritinde pre ye te muq kin wute ren anene res riwo di ni muq kin wute ren ni yumbo ur brequ te raqe rindiny. Pudi muq wuti Jona nde yumbui kin iri nandi pre pudi nungoqi ni ningg wand wutungu segi. ");
INSERT INTO kms_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Wuti iri lam nindiq pre di imb pe nuaq wus o os pe buag niraq pu wus tuqui segi. Ni raqene nuaq wus ei wute meyi mandi di lam ti te mundoq ye tuqui. ");
INSERT INTO kms_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nungoqi rar te nungoqi non ghimbi kin lam. Nungoqi rar oghi, tedi ghimbi quanene ti nase, di ti quan nganye bre. Pudi rar brequ rise, tedi ghimbi anene quan nganye burpoq rip. ");
INSERT INTO kms_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pugri bu nungoqi yeng wawo yuwon eti ti nungoqi nde rise kin te burpoq rip. ");
INSERT INTO kms_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pugri bu nungoqi ghimbi quan buagine ti nase, puch ire burpoq rip segi, tedi ni quan nganye ti nase. Di ni ti te lam ti nungoqi nde ti nase kin pugri.” ");
INSERT INTO kms_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas ni wand nand nand pre di Parisi iri Jisas ningg nari ei nondo ni ane mir mand ningg. Pugri bu ni Parisi tende baj pe nar no di ane mas. ");
INSERT INTO kms_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pudi Parisi te nuqond Jisas si wuye nap segine muq mir nand yamb nas, pugri bu ni puye nand. ");
INSERT INTO kms_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Muq Yumbui ni simbe nindig nari, “Nungoqi Parisi, nungoqi dabo gri nungoqi wari nungoqi wutaqu yuwon ye, pudi nungoqi nde wabe gri nyungu kin yumbo ur di nei brequ bre pu rise. ");
INSERT INTO kms_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nungoqi wutaqu nei segi kin! Wuti ghimbi dabo kin yembe nindiny kin tene wabe kin yembe nindiny. Nungoqi te kin nei wamb segi bri? ");
INSERT INTO kms_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pudi wute aye yumbo segi kin te yuwon wam, tedi nungoqi ghimbi buagi puqum rimb segi yuwon pu rise. ");
INSERT INTO kms_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nungoqi Parisi nungoqi yeng wawo otiwo di God nungoqi brequ nunduq ye. Te pugri nungoqi wuny kin minye buagi te lo wuri kin pugrine bir wawo bid 10-pela pu di bid ire God weng, pudi yumbo ur tuquine puq wen yambu wari, di God yawo wurang righe yambu wari. Yumbo God weng kin te yumbo ur yuwon kin ire te puq wen. Te yuwon, pudi eti wari te kinne puq wen di yumbo yumbui aye te wayequ. Te segi, quan buagine ei puq wen. ");
INSERT INTO kms_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nungoqi Parisi, nungoqi God yumbui nyamb mirang kin baj pe wo di sia rar ngimi yeru kin te ei wateri yawo kureuq. Di wute mikur kin sunyi pe tende wo di wute nungoqi wand yuwon yene ei meuq yawo kureuq ye, pugri bu nungoqi yeng wawo yuwon. Otiwo God nungoqi yumbo ur ren ningg brequ nunduq ye. ");
INSERT INTO kms_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nungoqi Parisi nungoqi wute ngamo kin pugri, dabo gri wari nungoqi wutaqu yuwon pudi nungoqi nde wabe gri nungoqi quan nganye brequ rise. Wute te nei mamb segi di tende nyinge mare mo bu ni puqum mamb. Pugri bu otiwo di God nungoqi brequ nunduq ye.” ");
INSERT INTO kms_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Muq wuti lo quan nei namb ye iri Jisas oyi nindig nari, “Tisa, nu pugri puq guad kin te nu beghi anene wand brequ gudug.” ");
INSERT INTO kms_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Di Jisas oyi nari, “Nungoqi wute lo quan nei wamb ye, nungoqi yeng wawo, otiwo di God nungoqi mai neuq. Te pugri nungoqi wute lo yumbo mai kin pugri wute quan nganye wany righe, di ni rire kin tuqui segi. Nungoqi te wuqond, pudi nungoqi nonne mune si timi iri wi nar di ni ghav wundiny segi. ");
INSERT INTO kms_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“Yabe chuqo nungoqi nuqo ni propet mi mati di mawo yemu. Muq nungoqi wari nungoqi te kin puq wen segi ye. Pudi muq nungoqi ni ngamo te yenji wupim. Nungoqi non yumbo ur te bei rind, nungoqi nuqo propet mi ye te ningg ngiq wand. Pugri bu otiwo di God nungoqi brequ nunduq ye. ");
INSERT INTO kms_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yumbo ur pugri kin te God ni quan nganye nei namb di nari kin pugri. Ni nari, ‘Nge propet di aposel tiqi gudom mondo, ninge mi mati di ninge unje map mai isis mem.’ ");
INSERT INTO kms_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pugri bu qi wuse urupui ne pu rindi rindi muq kin propet buagi ni yavi ir wughe kin te ningg di God nungoqi wute tit muq kin wen mai neuq ye. ");
INSERT INTO kms_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wute te Abel nde pu puate ri righe di rindi rindi Sekaraia, wuti alta umo wase mande ye opu di God ningg baj opu di mingi tende mi nati ye tende pend. Nge nungoqi simbe guduq, wute buagi men ningg di otiwo God nungoqi wute tit muq kin wen oyi mai neuq ye. Te nganye. ");
INSERT INTO kms_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nungoqi wute lo quan nei wamb ye, wute mar mo di God ningg nei yuwon ye matevi kin ki te nungoqi nde nase. Pudi nungoqi nonne war wo segi, di nungoqi wute mar mo mo ningg tuqui map kin te segi puq wundim di mar mo segi. Te ningg bu otiwo di God oyi nungoqi quan nganye brequ nunduq ye.” ");
INSERT INTO kms_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas ni baj te si nare no pre otiwo Parisi di wute Moses ningg lo wute bei meny ye ni pripri Jisas ningg quan nganye umbo ker muang di wand isis pengu mindig. ");
INSERT INTO kms_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ni mari ni pugri pengu mindig ei muqond ni lo ire gure nuaq o God nyamb brequ nindig ei ni lo pe mitanyi mo ningg. ");
INSERT INTO kms_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wute nganye buagi nganye rindi rikur, wute quan nganye bre pugri bu ni giq giq yeru kin tende puayi Jisas wand puate ni vighe. Ni wand puate ni vighe kin te nikin wute simbe nindim nari, “Nungoqi Parisi mingg yis te ningg yeng wawo yuwon. Ni mim pe wand aye mand, pudi ni umbo pe nei brequ bre pu rise. ");
INSERT INTO kms_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nungoqi nei umbo pe rise kin te suqo pu rise ye tuqui segi. Yumbo waghi grine puq wen kin te otiwo di God bei nand wute buagi ruqond, di yumbo suqo pu rise ye te otiwo di God raqene nawo rise. ");
INSERT INTO kms_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yumbo burpoq pe wand wand kin te oyi bogisumb simbe nand, di wute buagi rutungu ye. Di baj wabe war was waghi grine ange pe misag ware kin te otiwo di tiqe moqine yemu di wand te bir mawo di wute buagi rutungu. ");
INSERT INTO kms_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nge mand, nge nungoqi simbe guduq, nungoqi wute ghimbi omo mamb pre di tende dobu mune nganye brequ munduq tuqui segi kin te wune wumbim wayequ. ");
INSERT INTO kms_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pudi muqdi nge wuti iri bei guduq di nungoqi wuti te ei wune wumbig: Wuti te nungoqi ghimbi numbueuq riti pre, dobu di mune wase pe meniraqu waghe kin gre rise ye te ei wune wumbig. Nge nungoqi simbe guduq, nungoqi ni ei wune wumbig. ");
INSERT INTO kms_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wapi digiski woju wute wong mand kin, 5-pela pu 2 toea pene wong mand. Wapi te woju nganye, pudi God wapi wo te iri nei gheri niping tuqui segi, ni buagi ane yeng nuam. ");
INSERT INTO kms_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Di yu nunde ngawu pe vis kin te God yu kimbi ire ire manyi nand di nei nimbiny pre. Pugri bu nungoqi wune wamb wayequ, God nungoqi nei numbuq kin te wapi digiski wo nei nimbim kin ane tuqui segi, nungoqi oyi quan nganye. ");
INSERT INTO kms_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nge nungoqi simbe guduq, wuti tughe wute buagi nde rar pe nari ni nge ningg wuti, tedi nge wuti God nde pu gadi wuti nganye kas kin nge oyi God ningg angelo nde rar pe ni ningg kari ni nge ningg wuti. ");
INSERT INTO kms_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pudi wuti wute buagi aye nde rar pe nari ni nge ningg wuti segi, tedi nge oyi God ningg angelo nde rar pe kari ni nge ningg wuti segi. ");
INSERT INTO kms_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Di wute nge wuti God nde pu gadi wuti nganye kas kin wand brequ mindigh kin te God ni wand puaq nindim kin tuqui. Pudi wute God ningg Ququ Yuwon Ye wand brequ mindig kin te God ni wand puaq nindim segi ye. ");
INSERT INTO kms_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wute mandi nungoqi mutuqu wase, mitaqu God yumbui nyamb mirang kin baj pe mo, di tende opu ye gavman kin yumbui o wute nyamb kin pe mitaqu mo, te nungoqi pughe gri ei wand wand o pughe sin wen ei ni nungoqi brequ munduq segi ye te ningg nei kumo wamb wayequ. ");
INSERT INTO kms_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Te pugri tende puayi di Ququ Yuwon Ye gri ei wand bei neuq di wand wand ye.” ");
INSERT INTO kms_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muq wute buagi te yeru kin tende mingi pu wuti iri nari, “Tisa, nu nge chech simbe ndig ei ni wuyi nati di ni ningg yumbo buagi beghi si nirangu rise kin te bir nawo nge bid negh.” ");
INSERT INTO kms_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Muq Jisas oyi nari, “Mand, wuti tughe nge si numbogh di simbe nindigh nari nge nungoqi ningg wand kutungu ye, o nge nungoqi nuyi ningg yumbo buagi te bir kawo di nungoqi puch puch wateri ye? Te segi.” ");
INSERT INTO kms_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Muq Jisas nikin wute simbe nindim nari, “Nei wamb yuwon, di yeng wawo yuwon. Eti nungoqi yumbo isis wuqond di te kin quan nganye nei wumbiny di wateri yawo kureuq. Te piyi nungoqi yumbo quan wateri, pudi wuti iri ni yumbo quan rise ye te ninggne nas nas otiwo tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Di ni wute te kopuqu wand ven simbe nindim, “Wuti iri yumbo quan rise kin ni qi yuwon wund di mir yuwonne nganye ruwi. ");
INSERT INTO kms_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ni te nuqond muq nikin nei pene pugri nei namb nari, ‘Nge mir buagi ren kawo ris kin sunyi segi. Muqdi nge pughe sin ei ken?’ ");
INSERT INTO kms_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Muq ni nari, ‘Muq nge mir baj woju kin ren bir kawo di aye yumbui kin yembe gidiny. Te ei nge wit yi di mir buagi tende kawo ris ye tuqui. ");
INSERT INTO kms_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Te puq ken pre muqdi kari, muqdi nge yuwon pu kas ye, nge yumbo yuwon kin nganye buagi kawo ris pre. Muq nge yumbo te ninggne kas kas ber quan tuqui. Di nge waghine kas mirne gad, wuye ke, di yuwon pu kas.’ ");
INSERT INTO kms_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Pudi God wuti te ningg nari, ‘Nu wuti ghabe gad! Muq bur kuen gugne di nge nu ququ kitaw wi di ghati. Nu kuati di tughe ei nu yumbo yumbo buagi sir kuap pu rise ye te nateri ye’?” ");
INSERT INTO kms_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Di Jisas nari, “Wute ni yumbo buagi irepe mirur ei ni yumbo tuqui di yuwon pu mas ningg mari di God ningg yumbo ninde rise segi tedi ni wuti te kin pugri.” ");
INSERT INTO kms_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Muq Jisas nikin wute simbe nindim nari, “Pugri bu nge nungoqi simbe guduq, nungoqi yuwon pu was ningg yivany ware wayequ, di mir we ye te ningg yivany ware wayequ, di ghimbi pe chongo ware righe ye te ningg yivany ware wayequ. ");
INSERT INTO kms_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mir te yumbui segi, ququ te nganye. Di chongo yumbui segi, ghimbi te yumbui. ");
INSERT INTO kms_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wapi kuroqu te wuqond. Ni wuny yembe mindiny di mir mi righe segi, di mir nguan kin te materi mirur segi. Di yumbo mirur kin baj segi, di mir baj segi. Ni yumbo te kin segi, pudi God ni mir bag namb. God nde rar pe nungoqi oyi quan nganye yumbui di wapi oyi wokuandi, pugri bu nungoqi oyi quan nganye nei numbuq ye. ");
INSERT INTO kms_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wuti tughe ni nati kin ngeri tumo rind, pudi ni yumbo yumbo yuwon kin ningg yivany nare ye te ningg di mune nganye nas ye tuqui? ");
INSERT INTO kms_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nungoqi yumbo woju nganye ren kin puq wen ye tuqui segi ye, tedi pughe kin ningg yumbo buagi aye te ningg yivany ware? ");
INSERT INTO kms_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nyungo ruwi kin te wuqond. Ni chongo yembe rindiny segi, di rang rimb ei rire righe segi. Ni yumbo te kin puq ren segi. Pudi nge nungoqi simbe guduq, King Solomon ni yumbo nganye buagi di chongo yuwon yuwon rise, pudi ni chongo yuwon kin te nyungo kis ane tuqui segi, nyungo kis quan nganye yuwon. ");
INSERT INTO kms_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nyungo ni yeru nganye segi, ni muqne yeru, prangi mune yeru segi, pend mawo wase memare riwo namb ye, pudi God ni nei gheri nipiny segi. Nungoqi wutaqu God oghine nei wumbig segi kin! Nungoqi nei wamb, God ni nyungo nei nimbiny ye, pugri bu ni nungoqi wutaqu oyi quan nganye nei numbuq ye. ");
INSERT INTO kms_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Di nungoqi mir di wuye we ye te ningg quan nganye nei kumo wumbiny wayequ. ");
INSERT INTO kms_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Te pugri wute God nei rimbig segi kin ni yumbo ren kin ningg pripri yivany rire. Pudi nungoqi wutaqu God nei wumbig kin God nungoqi nuyi ni nei namb pre nungoqi yumbo ren kin wateri ei was tuqui. ");
INSERT INTO kms_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nungoqi yumbo ren ningg yivany ware wayequ, nungoqi God nde si nambu was ye te ningg ei meri wat. Nungoqi puq wen tedi ni yumbo buagi aye te neuq ye.” ");
INSERT INTO kms_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jisas nikin wute ningg nari, “Sipsip tit woju wen nungoqi wune wamb wayequ. Te pugri God nungoqi nuyi ni nungoqi nitaqu wowi di ni nde si nambu was ye. Nungoqi te ningg chumbuai wand ye. ");
INSERT INTO kms_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nungoqi non yumbo yumbo buagi te wi rundo wute aye wong mand, te kin wet bidi wateri di wute yumbo segi kin te wem. Nungoqi hanpaus gre ye ei wateri, di yumbo yuwon ye nginy tu wam wirur ye te kin yembe ei wand. Yumbo nginy tu wam rise ye ir ruso kin tuqui segi, wute nyungu kin tende tumo mandi segi, pugri bu nyungu mand ye tuqui segi, di choi pend ruwo tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Te pugri nungoqi yumbo yuwon yuwon kin te muainde wawo rise te nungoqi nei mune tendene ei rise. ");
INSERT INTO kms_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Nungoqi sir wap di yeng wawo pu ei was. Wute nikin yumbui wute urupui ngam ruso kin mir pe tende no di ni sir map di ghimbi muang pu mas kin pugri. Ni pugri sir map di ghimbi muang pu mas pu ei otiwo ni mir pe te pu mune nandi ngimrawu baq nand di ni brequne ngim bi muang, neyi ni, ni muq sir map segi. Muq nungoqi ni kin pugrine sir wap, chongo kring wap riwo ruso puayi rise di let pe taq wamb gre, lam wand pre, di yeng wawo pu was. ");
INSERT INTO kms_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wute sir map pre muq nikin yumbui yeng muang pu mas mas muq nikin yumbui nandi ni nuqond kin wute te chumbuai mand. Nge nungoqi nganyene simbe guduq, nikin yumbui pugri nuqond, tedi ni mir mawo kin chongo nare righe, chongo kring nipiq wiyo wuso puayi wuse let pe taq nimbiq gre, di nikin yembe ye wute simbe nindim mas di ni mir nuam. ");
INSERT INTO kms_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Piyi nikin yumbui bur mingi pu nandi o yambgriq tumo pu nandi, pudi ni ruqo mase segi ni ghimbi muang pu mas. Wute te kin ni quan nganye chumbuai mand. ");
INSERT INTO kms_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pudi yumbo ren ei nei wumbiny. Wuti iri ni nei namb pughe puayi di wuti nyungu kin nandi ni baj bir nuang di yumbo nyungu nand ye, tedi tende puayi ni yeng nawo di wuti nyungu kin nandi ni baj bir nuang di yumbo nyungu nindig tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Muq nge nungoqi simbe guduq, nungoqi mune te kin pugrine ei yeng wawo pu was. Wuti God nde pu nandi wuti nganye nas kin ni nandi kin ngeri te nungoqi nei wamb segi, nungoqi nei tuan wamb pu was kin tende puayi ei ni nandi ye. Pugri bu nungoqi ni nandi ye te ningg yeng wawo pu ei was.” ");
INSERT INTO kms_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Muq Pita Jisas pengu nindig nari, “Yumbui, nu kopuqu wand ven beghine simbe gudug o nu wute buagi ren yeru kin ren anene simbe gudiny?” ");
INSERT INTO kms_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Di Yumbui oyi nand nari, “Wuti tughe ni nei yuwon ye rise di nikin yumbui ningg wand nutungu di ni nari kin pugrine puq nen ye? Wuti te kin di nikin yumbui ni si numbog, di ni oyi wute yembe ye aye te yeng nuam, di yumbui ngeri nap ruso kin tende tuquine mir nem. ");
INSERT INTO kms_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yembe ye wuti iri te kin tuquine puq nen nen muq nikin yumbui mune nandi ni nuqoind, tedi wuti te chumbuai nand. ");
INSERT INTO kms_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nge nungoqi nganyene simbe guduq, tedi ni wuti te yumbui ningg nowi nas, di ni oyi ni ningg yumbo yumbo buagi te yeng nuany ye. ");
INSERT INTO kms_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pudi yembe ye wuti nari, ‘Nge yumbui ni nas nas nganye pu ei nandi ye.’ Ni puq nand di nes newo yembe ye wute quayi di nyumbueg te pug nindiny, di mir nand wuye ne ngawu ghabe rind. ");
INSERT INTO kms_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yumbui mune nandi ye nginy te ni nei namb segi, ni nei tuan namb di nei gheri nap pu nas kin tende puayi di ni mune nandi, tedi ni brequ nindig. Tedi ni pend pend nowi, di wute ni nei mimbig segi ye nawo mas kin tende ane irepe nawo mas. ");
INSERT INTO kms_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yembe ye wuti iri nikin yumbui yembe neng kin te nei nimbiny, pudi ni nikin yumbui nari kin yumbo te nate ruwi segi, di ni nari kin pugrine puq nen segi ye, wuti te nikin yumbui ni quan kumo ni ye. ");
INSERT INTO kms_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pudi wuti nikin yumbui ningg nei te nundog segi, pudi nikin nei pene yembe nand di unje nap, di ni unje nap ye te ningg pug nindig kin tuqui ye, wuti te kin nikin yumbui oyi musoqne ei ni ye. Wute yumbo quan kumo materi kin te otiwo ni oyi yumbo quanne ei oyi mand ye. Wute yumbo nganye buagi wuti iri nde si wam ruang kin te, otiwo di ni oyi quanne neny ningg riri ye.” ");
INSERT INTO kms_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas nari, “Nge gadi kin God ni wute wase neny puq nand kin te bu kare gadi. Nge nde nei pe wase te brequne ei namb yawo kuregh. ");
INSERT INTO kms_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nge mai wabe ei ko yamb. Wute wuye map ningg di wuye wabe murund maghe kin pugri ei nge mai wabe ko ye. Muq nge mai te kare segine, pudi mai te rindi ye. Pugri bu mai te ningg nge nei quan nganye mai viyo. ");
INSERT INTO kms_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nge nungoqi simbe guduq, eti nungoqi wari nge qi pe gadi kin yeng gure kuaq di wute yuwon pu mas ningg bu gadi. Te segi. Nge wute bir kawo ningg bu gadi, ");
INSERT INTO kms_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","pugri bu muq pu ruso otiwo di wute kin kin bir ruwo. Baj ire ningg wute 5-pela pu ris, kiyi, kumo di wo. Pudi nikinne bir ruwo teri opu di teri ire pu opu, di teri res riwo teri ire pu ruqond riri, di teri ire pu res riwo teri ruqond riri. ");
INSERT INTO kms_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nikinne bir ruwo, kiyi kuwonyimi muqond mari, kuwonyimi oyi kiyi muqond mari, di kumo kuwonyumbu ruqond riri, kuwonyumbu oyi kumo ruqond riri, di kine gang kine ghar ruqond riri, kine ghar oyi kine gang ruqond riri.” ");
INSERT INTO kms_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Di Jisas wute buagi te yeru kin te simbe nindiny nari, “Wuye quari nginy naghe no opu wes wiyo, tedi wari muqdi wuye wundi ye, di nganyene wuye wundi. ");
INSERT INTO kms_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Di nyumurighi gherim pe pu nandi wuqoind di wari muq nginy oghi ye, di nganyene nginy oghi. ");
INSERT INTO kms_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nungoqi wute nei tevi kin! Nungoqi nginy tu wuqond di qi pe kin yumbo wuqond di nei wamb muqdi ngeri pughe gri ei rise ye. Pudi pughe gri ate nungoqi muq kin yumbo ur ren wuqond pudi nei wamb segi? ");
INSERT INTO kms_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Pughe kin ningg nungoqi nonne nungoqi non yumbo ur te wuqond segi, yumbo ur pughe ye te yumbo ur yuwon ye di yumbo ur pughe ye te yumbo ur brequ ye? ");
INSERT INTO kms_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wuti iri nu kotim naind ningg nitanyi kot pe no, te tequ muq qa wo wone di nu buid ghap ei nu tequ wand te teti wawo. Eti ni nu nitanyi jas nde no, di jas nu polis nde si pe ni ghondo, di nu mitanyi mo taq maimb. ");
INSERT INTO kms_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nge nu simbe guduw, ni nu taq maimb pre tedi nu mune gheyi yi tuqui segi. Nu tene yeru yeru wet bidi buagi jas nupuw ruso ye te meghare ruso omone ghawo di gheyi yi.” ");
INSERT INTO kms_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Asi Pailat nikin ami simbe nindim di wute Galili kin ninge umo wase mande God meng meng yemu kin te mi. Ni mi mati di ni yavi te umo God meng ningg mambui riti kin yavi te ane irepene righe ruso. Muq wute ninge Jisas nde wand pe tende mandi pu yemu kin te ni Jisas wand ven kin simbe mindig. ");
INSERT INTO kms_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Di Jisas oyi ni simbe nindim nari, “Nungoqi nei wamb kin wute Galili kin aye te ni quan yumbo ur brequ mand segi ye, pugri bu ni mi segi, pudi wute men ni quan nganye yumbo ur brequ mand ye, pugri bu ni yuqo pugri kin miraq? Nungoqi pugri nei wamb bri? ");
INSERT INTO kms_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Te segi. Nge nungoqi simbe guduq, nungoqi nei ware witinde segi tedi nungoqi buagi ane mune ni kin pugrine wati. ");
INSERT INTO kms_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Di wute 18-pela pu asi Siloam kin baj dobui bir ir nati di ni mati kin te nungoqi wari wute aye Jerusalem kin ni quan nganye yumbo ur brequ mand segi ye pugri bu ni mati segi, pudi wute 18-pela pu men ni quan nganye yumbo ur brequ mand ye pugri bu ni mati? ");
INSERT INTO kms_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Te segi. Nge nungoqi simbe guduq. Nungoqi nei ware witinde segi, tedi nungoqi mune ni kin pugrine wati.” ");
INSERT INTO kms_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Di Jisas kopuqu wand ven simbe nand: “Wuti iri nikin nde wain wuny mbe kotu ire neq wughe pu yequ. Di ni no kotu te nundoq, ni yi wumb ei yi te nap ningg, pudi ni yi ire yequ nundoq segi. ");
INSERT INTO kms_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pugri bu ni nikin yembe ye wuti wain wuny yeng nuany ye te simbe nindig nari, ‘Nge priprine gadi, kotu wen gudoq kari ni yi wumb ei nge kap ningg pudi yi wumb segi. Nge priprine gadi gadi ber teri ire pu ruso, pudi nge yi ire gudoq segi. Pugri bu nu eraq wuso wughe. Pughe kin ningg segi yequ di qi nyong omo wuaq?’ ");
INSERT INTO kms_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Di yembe ye wuti te oyi nari, ‘Yumbui, piyi ber wen irene mune rar ndoq yequ, di nge nyumo puate pe qi tiqe gidiq godo gadi, di kau umbo kawo. ");
INSERT INTO kms_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pugri puq kew pu yequ muqdi ber ire te ningg mune budoq, yi wumb o segi. Ber ire te ningg ni yi riyi te yuwon. Ni yi riyi segi, tedi epiraq wuso wughe’.” ");
INSERT INTO kms_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat kin nginy iri ningg Jisas God yumbui nyamb mirang kin baj ire ningg nas wute God ningg wand bei neny. ");
INSERT INTO kms_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tende di nyumbueg ire ququ brequ ane kin mune anene God yumbui nyamb mirang kin baj pe tende yequ, Jisas wand nand kin wutungu wutungu. Wute te ququ brequ ni nde nas ni num new bu ni dob quan nganye rengu nare, di yimb yimb wuso, oghine nyinge wure tuqui segi. Ni pugri pune yequ yequ ber 18-pela pu. ");
INSERT INTO kms_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas wute te nundoq, di nari wundi ninde tumo yequ, di simbe nunduw nari, “Nyumbueg, nge nu num puaq guduw pre.” ");
INSERT INTO kms_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Muq ni si new kuyo di brequne ni opu wes wiyo yuwonne yequ, di God nyamb wundivi viyo. ");
INSERT INTO kms_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","God yumbui nyamb mirang kin baj te kin yumbui ni nuqond Jisas Sabat kin nginy tende ni wute num puaq nunduw. Pugri bu ni umbo ker nawo, di wute te yeru kin simbe nindiny nari, “Yembe kin nginy 6-pela pu mase. Pugri bu nginy te ningg ei wandi di ni num puaq nunduq. Sabat kin nginy nen ningg wandi wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Di Yumbui ni oyi nindig nari, “Nungoqi wute nei tevi kin. Nungoqi wand wand kin te nungoqi non yumbo ur ane tuqui segi. Sabat kin nginy tende nungoqi non non nungoqi non kau di donki baj pe wo di sare bure wundiny wutari wo wuye weny riq segi ye bu? ");
INSERT INTO kms_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wute wen ni Abraham ningg wo ire. Satan ni taq nimbiq pu wus wus ber 18-pela pu. Te pughe ningg ate yumbo ni taq rimbiq kin te Sabat kin nginy tende puaq guduw tuqui segi?” ");
INSERT INTO kms_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas ni pugri puq nand di nikin veri buagi ni minyuw mati. Pudi wute buagi ni yumbo yuwon nganye puq nen ye te ningg quan nganye chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Muq Jisas ni pengu nindim, “Wute God nde si nambu ris kin pughe gri ei ris ye? Nge yumbo pughe kin ningg wand gad ei ane tuquine? ");
INSERT INTO kms_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wute God nde si nambu ris kin te mastet yi kin pugri. Wuti iri mastet yi nare no nikin nde wuny mbe ni righe. Mastet yi te yire, yumbui ruso nyumo kin pugri yeru, di wapi rindi ninde muange pe tende ris.” ");
INSERT INTO kms_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mune pengu nand nari, “Nge yumbo aye pughe kin ningg wand gad ei yumbo God nde si nambu rise kin ane tuquine? ");
INSERT INTO kms_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ni yis kin pugri. Wute ire yis puch wutaqwi di plaua os yumbui pe waq wughe di ane quang wumbiq. Di otiwo yis plaua pe wur ir di plaua te quanene yindiqi.” ");
INSERT INTO kms_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Di Jisas nyinge nare Jerusalem no di no tiqe yumbui di tiqe woju ngimne yeru kin tende wand bei neny neny no. ");
INSERT INTO kms_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Di wuti iri ni pengu nindig nari, “Yumbui, God wute ire irene bri nate mowi ye?” Di Jisas ni simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nungoqi ngim wokuandi pe war wo ningg buid nganye ei wap. Te pugri, nge nungoqi simbe guduq wute nganye buagi ei ngimrawu woju pe mar mo ningg buid map, pudi tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Otiwo baj kiyi nes newo ngimrawu niqu, di nungoqi dabo gri yequ ngimrawu pe baq wand di wari, ‘Yumbui, beghi ngim bi wangu.’ “Pudi ni oyi pugri ei simbe nand nari, ‘Nge nungoqi nei gubuq segi, nungoqi muai pu wandi.’ ");
INSERT INTO kms_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Di nungoqi oyi pugri ei wari ye, ‘Beghi asi nu ane mir bad di wuye pe, di nu beghi nde opu guadi wand bei guegu.’ ");
INSERT INTO kms_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Pudi ni oyi puq ei nand ye, ‘Nge nungoqi nei gubuq segi, nungoqi muai pu wandi ye. Nungoqi wutaqu yumbo ur brequ wand ye! Nungoqi kring wo, nge nde tumo wandi wayequ!’ ");
INSERT INTO kms_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Di nungoqi Abraham, Aisak, Jekop di propet buagi te God nde si nambu mas wuqond di nungoqi quanji wand di sawo wat ki. Pudi ni nungoqi ngiq nunduq di war wo ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tende puayi di wute tiqe manyi kin yumbo yumbo God nde si nambu rise ye mir yumbui pe tende mas. Wute nginy nawi opu kin, nginy naghe no opu kin, di tiqe manyi qi pe ven nde yeru kin mandi mir pe tende sunyi materi di mas. ");
INSERT INTO kms_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Di wute ninge muq dobu mawi kin te otiwo ye mawo ye, di wute muq ye mawo kin te otiwo dobu mawi ye.” ");
INSERT INTO kms_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tende puayine Parisi ninge Jisas nde mandi di simbe mindig mari, “Nu tiqe wen si raq di tiqe aye pe yo. King Herot nu ni ghati ningg.” ");
INSERT INTO kms_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Di Jisas oyi ni simbe nindim nari, “Nungoqi wo nyombui brequ dabo kin te pugri simbe wundig, ‘Muq di prangi nge wute ququ brequ puaq gidiny di num puaq gidiny ye. Di nginy aye te ningg di nge yembe omo kawo ye.’ ");
INSERT INTO kms_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pudi nginy nen ningg di prangi di yamb nge nyinge kare karene. Te pugri propet iri tiqe aye pe mi nati wayequ, Jerusalem pene mi nati ei oghi.” ");
INSERT INTO kms_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Di Jisas nari, “O Jerusalem, nu propet kui mati, di wute God tiqi nundom nu nde mandi ye te wet pe kui mati ye. Pripri nganye nge nu ningg wute wapiqu nikin wo nimbraqe nambu wirir kin pugri kimar ningg kari, pudi nu nge rar guqoid segi. ");
INSERT INTO kms_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nu tungu, otiwo di nu tiqe wen brequ wuse di wute segi pu wuse. Nge nungoqi simbe guduq, nungoqi nge mune wuqoind tuqui segi. Segi segine ruso ruso otiwo nungoqi wari, ‘God nu wuti Yumbui nde nyamb pe nandi kin nen yuwon wang’!” ");
INSERT INTO kms_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat kin nginy iri ningg Jisas Parisi mingg yumbui iri nde baj pe no ei ane mir mand ningg. Tende puayi ni Jisas yeng muang yuwon ei muqond, Jisas Sabat kin lo gure nuaq o segi. ");
INSERT INTO kms_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Di wuti iri num brequ nare di ni ghimbi quan nganye nirang riwo kin Jisas nde rar ngimine te yenu. ");
INSERT INTO kms_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas wuti te nuqoind di Parisi di wute lo quan nganye nei mamb ye te pengu nindim nari, “Sabat kin nginy tende wute num puaq bidiny kin te lo gure puaq o segi?” ");
INSERT INTO kms_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pudi ni Jisas oyi mindig segi, ni wand segine yemu. Pugri bu Jisas wuti te nait nase, num puaq nindig, di tiqi nundog no. ");
INSERT INTO kms_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Di ni wute te pugri pengu nindim nari, “Nungoqi kin iri ni quayi wo iri o kau iri Sabat kin nginy te ninggne ngamo pe ir naghe pu yenu, tedi nu brequne kuo kueti nowi ye o segi?” ");
INSERT INTO kms_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Di ni Jisas ningg wand ven oyi mindig kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas ni nuqond wute mir pe tende mandi kin ni sia rar ngimi yeru kin tende ei mas yawo kurem. Ni te nuqond di kopuqu wand ven simbe nindim. ");
INSERT INTO kms_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wuti iri nungoqi ngam nirauq wute urupui ngam ruso kin mir pe tende wo, te nungoqi sia rar ngimi yeru kin wute nyamb kin mas ye te wateri wayequ. Eti sia te wuti iri ni nyamb oyi musoq nu nde yumbui kin te miping wuso pre kin te muq nu oyi kuas. ");
INSERT INTO kms_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tedi otiwo wuti nu tequ ngam nirauq mir pe tende wandi kin te nandi di nu ningg nari, ‘Nu yes yewo, wuti te nandi sia rar ngimi yequ kin wen wung nas.’ Di nu quan nganye minyuw ghati di yes yewo yo, sia dobu nganye yeru kin wute nyamb segi kin mas ye pe tende ghas. ");
INSERT INTO kms_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pugri bu wuti iri nu ngam niraw mir pe tende kuo, nu sia dobu nganye yequ kin te ei taqwi. Te ei otiwo wuti nu ngam niraw mir pe tende kuo kin te nandi, nu nuqoind, nu dobu nganye kuas, tedi ni nu simbe nunduw nari, ‘Mand, nu ghandi sia rar ngimi yequ kin wen wung ghas.’ Ni pugri puq new, di wute buagi nu ane mir wand kin ninde rar pene nu nyamb yumbui. ");
INSERT INTO kms_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Te pugri wute ni kinne nikin nyamb mindivi viyo kin te God oyi ni nyamb ni vighe viso. Pudi nikin nyamb mi vighe viso kin te God oyi ni nyamb nindivi viyo.” ");
INSERT INTO kms_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Muq Jisas wuti te ni ngam nirang mir pe tende nandi kin te simbe nindig nari, “Nu mir yumbui yembe guduw, te nu nimand, nuse niqam wand kin o nu non yavi ire, di wute wet bidi quan rise kin nu ane tumo tumo was kin te ningg ghari mandi ane mir wand wayequ. Eti otiwo ni oyi mir yembe mindiny di nu ningg mari ghondo ane mir wand. Ni pugri puq men tedi nu ni mir kuem kin te oyi munduw pre. ");
INSERT INTO kms_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pudi nu mir yumbui yembe gudiny te nu wute yumbo segi kin, wute ghimbi brequ rise kin, wute nyinge brequ kin, di wute rar ghave rimbim kin te ei ghari mandi ane mir wand. ");
INSERT INTO kms_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tedi God nu yuwon nuaw. Te piyi wute men kin ni oyi nu mir te oyi munduw ye tuqui segi. Pudi otiwo wute God nde rar pe tuquine mas kin ni mune mes mewo kin tende puayi di God oyi nu mir te oyi nunduw.” ");
INSERT INTO kms_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wuti iri ni ane mas mir mand kin ni Jisas ningg wand ven nutungu di ni Jisas ningg nari, “Wuti wute God nde si nambu mas kin mir mand ye mir pe tende nas di ane mir mand kin wuti te chumbuai nand.” ");
INSERT INTO kms_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Muq Jisas oyi nari, “Wuti iri mir yumbui ire yembe nunduw pre, di wute nganye buagi nari mir pe tende mandi ningg. ");
INSERT INTO kms_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ni mir te sir nap pre, muq ni yembe ye wuti tiqi nundog no, wute ni nyamb nitamri ye simbe nindim nari, ‘Be wandi, yumbo buagi sir nap pre.’ ");
INSERT INTO kms_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Pudi ni buagi anene mari ni yembe rise, pugri bu mir tende mondo tuqui segi. Wuti iri nari, ‘Nge ni yawo kutong, ni nge ningg nari. Nge godo ningg pu qa, pudi nge wuny ire muq teneqa wong gad pu vise. Di muq ei nge ko di wuny te guqod ye, pugri bu nge godo tuqui segi.’ ");
INSERT INTO kms_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Wuti aye nari, ‘Nge ni yawo kutong, ni nge ningg nari. Nge godo ningg pu qa, pudi muq tene qi bir kin kau quayi 10-pela pu wong gad. Muq ei nge ko tuqui kap ye. Pugri bu muq nge ko yamb gadi. Te ningg bu nge godo tuqui segi.’ ");
INSERT INTO kms_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Di aye mune nari, ‘Nge muq tene qa ngam ko pu, pugri bu nge godo ye tuqui segi.’ ");
INSERT INTO kms_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Di yembe ye wuti te mune nandi, ni mingg wand te nikin yumbui simbe nindig. Nikin yumbui te nutungu, umbo ker nawo di nikin yembe ye wuti te simbe nindig nari, ‘Nu brequne tiqe wen kin ngim yumbui di woju buagi tende ghar ir, wute yumbo segi kin, wute ghimbi brequ rise kin, wute rar brequ rise kin, di wute nyinge brequ rise kin te qond, di tari nge nde baj pe ghandi.’ ");
INSERT INTO kms_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Di yembe ye wuti te no nikin yumbui nari kin pugrine puq nen pre, muq no nikin yumbui te simbe nindig nari, ‘Yumbui, nu kuari kin te nge puq ken pre, pudi baj bre segine. Sunyi yumbui visene.’ ");
INSERT INTO kms_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Muq yumbui nikin yembe ye wuti te simbe nindig nari, ‘Nu ngim manyi te yo di yo wuny kin imb manyi te nyinge ghare ghar ir, quayi nyumbueg tende yeru qond, te ghari buid nganye ghap ghap ei tari nge nde baj pe ghandi. Te ei nge baj bre. ");
INSERT INTO kms_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nge nungoqi simbe guduq, wute asi nge nyamb kitamri di nge ningg mir pe ven nde mandi ningg kari pudi mandi segi kin wute te ni nge mir wen kin puch nganye me tuqui segi.’” ");
INSERT INTO kms_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wute nganye buagi Jisas ane nyinge rire ruso ruso, di Jisas tindi nandi ni simbe nindiny nari, ");
INSERT INTO kms_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wuti iri nge nde nawi pudi ni nge quan nei nimbigh di kiyi, kumo, ngam, wo, kise, kiqam, di kunyumbu te yambu nireny segi, di nikin ghimbi yambu nireny segi, wuti te ni nge te wuti ningg nas tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wuti nge nde dobu nawi di te ningg mai nare ye yambu nari, wuti te kin nge te wuti ningg nas tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nungoqi kin wuti iri nu baj dobui iri yembe gudig ningg te nu kuas otinde nei guab yuwon pre, muqdi yembe gudig ye o segi? Nu wet bidi tuqui ghap ei qond, nu baj te yembe gudig omo kuowi kin wet bidi tuqui o segi. ");
INSERT INTO kms_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nu pugri puq kuen segine muq baj te yembe gudig, tedi nu tingi kin yembe ghand pre dobu di nu qond nu baj te yembe gudig omo kuowi ye wet bidi tuqui segi. Di wute buagi baj te muqoind, di nu wur maw ");
INSERT INTO kms_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","mari, ‘Wuti nen baj te puate ni naghe, pudi omo nowi ye tuqui segi’.” ");
INSERT INTO kms_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Di mune nari, “O king iri yeng pe no di king aye temi mege ningg. Te ni nas di otinde nei namb yuwon. Ni yeng kin wute 10 tausen pela pune di king aye te ni yeng kin wute 20 tausen. Pugri bu ni nei namb yuwon, nikin yeng kin wute 10 tausen pela pune te king wute 20 tausen kin te mi di kring map mo kin tuqui o segi? ");
INSERT INTO kms_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ni nei namb ni tuqui segi, te muqdi king aye te ni yeng kin wute ane wonjine yemu yemu di ni wute ninge tiqi nundom mo ei king te ane wand ei yeng mand segi, ane mawo gudo. ");
INSERT INTO kms_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te kin pugrine muq nungoqi kin wuti iri nikin yumbo yumbo buagi dob neny segi, ni nge te wuti ningg nas tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Di ni nari, “Ghat te yuwon. Pudi ghat ni nyong te prene, tedi beghi pughe sim peny ei mune nyong vimb? ");
INSERT INTO kms_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ghat ven ni mir wuny mbe ruwi kin te ghav rindiny tuqui segi. Di ghat te kin beghi kau umbo ane quang bab di wuny mbe pawo ye tuqui segi. Ghat te kin mene ei pare viso ye. “Wuti iri ni nutungu kin tuqui tedi ange nuaq ei wand ren nutungu.” ");
INSERT INTO kms_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Muq wute takis materi kin di wute yumbo ur brequ rind kin rindi Jisas nde rikur di ni wand nand kin rutungu. ");
INSERT INTO kms_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pudi Parisi di wute lo wute bei meny ye ane ni Jisas ningg umbo ker mawo mari, “Wuti nen wute yumbo ur brequ rind ye ane sabi rind di mir rind.” ");
INSERT INTO kms_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Di Jisas kopuqu wand ven simbe nindim: ");
INSERT INTO kms_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nungoqi kin iri sipsip 100-pela pu yeru pu muq ire ir wuso. Tedi 99-pela te si nare, mong puch ire ningg yeru mir rind rind, di no ire ir wuso kin te meri nunduw ye o segi? Ni no ire ir wuso kin meri nunduw nunduw nundoqne di pre. ");
INSERT INTO kms_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ni nundoq tedi ni quan nganye chumbuai nand di nitaqwi sikar wam neq wiyo di niraq nambu no. ");
INSERT INTO kms_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ni no nambu di ni kimand di wute ni ane tumo tumo ris kin te nari rindi rikur di nari, ‘Wandi nge ane chumbuai bad. Nge sipsip ir wuso kin te mune gudoq pre.’ ");
INSERT INTO kms_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nge nungoqi simbe guduq, wuti yumbo ur brequ nand ye iri mune nei nare nitinde ye te ningg di nginy tu wam kin te kin pugrine quan nganye chumbuai mand. Te nganye wute 99-pela pu asine nei rire ritinde pre di God nde rar pe tuquine ris kin te ningg ni chumbuai mand. Pudi wuti yumbo ur brequ nand nand ruso ruso muq mune nei nare nitinde ye te ningg ni quan nganye chumbuai mand.” ");
INSERT INTO kms_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Di Jisas kopuqu wand aye ire simbe nand nari, “Nyumbueg ire wet bidi 10-pela pu rise pu muq ire ir wuso, tedi ni pughe ei wen ye? Tedi ni lam wundiq wus, di baj pe bureng wup, di waghine meri wunduw wunduw wundoqne di pre. ");
INSERT INTO kms_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ni wet bidi te wundoq pre, tedi ni kimand di wute ni nde tumo ris kin te wuri rindi di wuri, ‘Wandi nge ane chumbuai bad. Nge wet bidi ir wuso kin te yabe mune gudoq pre.’ ");
INSERT INTO kms_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nge nungoqi simbe guduq. Te kin pugrine wute yumbo ur brequ mand kin iri ni nei nare nitinde ye te ningg God ningg angelo ni quan nganye chumbuai mand.” ");
INSERT INTO kms_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Di Jisas kopuqu wand aye ire simbe nand nari, “Wuti iri quayi wo temi mas. ");
INSERT INTO kms_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Muq wo kiqam te kiyi ningg nari, ‘Wuyi, nu yumbo bir kuawo nge ninge kuegh di chech ninge gueg puq guad kin te nge te be yegh.’ Muq kiyi nikin ningg yumbo yumbo buagi te bir nawo di ni kin kin nem. ");
INSERT INTO kms_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Tende dobu nginy ninge mo pre wo kiqam te ni ningg yumbo yumbo te ni rundo wute aye wong mand, di ni wet bidi te kin nateri nare di wonji, kantri aye pe no. Ni no tende nas, di bujeyi nase di wet bidi sabi nindiny segi. Ni wet bidi segi segi menare ruso ruso di wet bidi buagi omone nawo. ");
INSERT INTO kms_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ni yumbo buagi omo nawo pre pu nas, di tende opu mune mir segi. Di ni wet bidi segi pugri bu ni mir ne kin segi. ");
INSERT INTO kms_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pugri bu ni no wuti iri te opu kinne yembe nindig. Di wuti te ni tiqi nundog no pu imb pe yembe nand pu bag namb. ");
INSERT INTO kms_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ni pu yeng nuany pu yenu, pu ni mir rind di mir chongo ir righe kin te nuqond di ni ne ei umbo tuq namb yawo nganye gureg. Di tende puayi wute ninge ni mir ninge meng segi. ");
INSERT INTO kms_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Muq ni nei yuwon ye mune vindi vighe di ni nari, ‘Nge ven yengu kin mir segi di mir ningg kati yamb tumo. Nge wuyi ningg yembe ye wute buagi ni mir quan nganye rise, di me omo mawo ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Muqdi nge mune nyinge kare wuyi nde ko. Ko wuyi nde ko kar di simbe gidig kari, “Wuyi, nge God nde yumbo ur brequ gad, di nu nde yumbo ur brequ gad. ");
INSERT INTO kms_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nge muq wuti oghi nganye segi, pugri bu nu nge wo puq ndigh tuqui segi. Muqdi nge nu ningg yembe ye wuti kin pugri ei yembe yegh di yembe gad.” ’ ");
INSERT INTO kms_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pugri nei namb pre di nes newo nyinge nare kiyi nde no. “Pudi ni nyinge nare wonjine nondo nondo kiyi rar neq wundi nuqoind, di quan nganye yawo nitong. Di ni nes newo vig namb no, kuwonyimi sibraj ni di song nireng. ");
INSERT INTO kms_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Muq wo kiyi ningg nari, ‘Wuyi, nge God nde yumbo ur brequ gad di nu nde yumbo ur brequ gad pre. Nge wuti oghi nganye segi, pugri bu nu nge wo puq ndigh tuqui segi.’ ");
INSERT INTO kms_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Pudi kiyi nikin yembe ye wute te simbe nindim nari, ‘Brequne wo nge ningg chongo yuwon ye te wutaqwi, wuraq wandi, wurang wughe. Di ring si tumuepu pe weng naghe, di sendel nyinge pe wutang rindiwo. ");
INSERT INTO kms_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Di kau wo quan nganye nyam wure kin te wuraq wandi, wumbueq wuti. Di beghi mir yumbui yembe bidiny, mir bad di chumbuai bad. ");
INSERT INTO kms_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Te pugri nge wo nen ni nati pre di mune nes newo, ni ir no pre pudi mune buqoid.’ Pugri bu ni mir yumbui yembe mindiny, mir mand di chumbuai mand. ");
INSERT INTO kms_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tende puayi wo kiseyu ni wuny mbene yenu. Ni wuny mbe pu mune nandi kin tende, ni nandi baj pe tumo tumo di ni yuwo riri di nyinge ruwo ruwo kin te nutungu. ");
INSERT INTO kms_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Di ni yembe ye wuti iri ngam nirang nandi di pengu nindig nari, ‘Te pughe riteri?’ ");
INSERT INTO kms_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Di yembe ye oyi ni simbe nindig nari, ‘Nu niqam mune nandi pre. Ni no pre di yuwon pune mune nandi. Nu nuyi ni pugri nuqoind bu ni chumbuai nand bu nari di kau wo quan nganye nyam wure kin te mumbueq, mir yumbui yembe mindiny di chumbuai mand.’ ");
INSERT INTO kms_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kise ni te nutungu umbo ker nawo di baj pe nar no yambu nari. Di kiyi neyi nandi wo ningg nari, ei wo nar nondo ningg. ");
INSERT INTO kms_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pudi wo oyi kiyi ningg nari, ‘Pughe gri ate nge ber quan nu nde wet bidi segi ye yembe gad, di nge nu ningg wand sange guduw segi. Nu nge pughe kin ningg tiqi gudogh di nge nu wand irepene kutungu di te kin pugrine puq ken. Pudi nu nge meme ghar iri kuegh di nge nge ningg mand ane chumbuai bad segi. ");
INSERT INTO kms_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pudi nu nuwonyimi nen ni nu ningg yumbo yumbo buagi te nare no ngimne nyumbueg neny omo nawo pre, muq mune nandi ye nen ningg bu nu kau wo nyam wure kin tene gubueq.’ ");
INSERT INTO kms_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Muq kiyi oyi nari, ‘Nge wo, nu nge ane pas ye, di nge ningg yumbo yumbo buagi te nu te. ");
INSERT INTO kms_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pudi nu niqam nen ni nati pre, di mune nes newo, ni ir no pre di mune buqoid. Pugri bu muqdi beghi te ningg chumbuai ei bad ye’.” ");
INSERT INTO kms_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas nikin wute simbe nindim nari, “Wuti iri wet bidi quan kin ni yembe ye wute ninge mas di wuti iri yembe ye wute te mingg yumbui. Yumbui te ni wet bidi sabi nindiny segi ye te ningg wute ninge mandi wuti wet bidi quan kin te simbe mindig. ");
INSERT INTO kms_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pugri bu ni yumbui te ngam nirang neyi nandi di pengu nindig nari, ‘Nge nu ningg wand pugri ye kutungu. Te nganyene bri? Muqdi nu yumbui ningg mune ghas segi ye, pugri bu nge ningg yumbo yumbo buagi nunde si pe rise ye te kin ur ghand nge yegh.’ ");
INSERT INTO kms_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Muq yembe ye mingg yumbui te nikin nei pene nei nimbiq nari, ‘Muqdi nge pughe ei ken? Nge yumbui nge nyamb puaq nindigh yamb. Ni nge nyamb puaq nindigh di nge yembe ye wuti ninggne yengu, pudi nge qi bir kuaq kin buid tuqui segi. Di nge wute aye wet bidi ningg sang kipim kin te minyuw kati. ");
INSERT INTO kms_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Muq nge nei gab nge pugri ei puq ken. Nge wute aye ghav gidim pu ei otiwo nge yumbui nge nyamb ven puaq nindigh di yembe segi kas kin tende di wute te oyi nge mitanyi ni nde baj pe mo.’ ");
INSERT INTO kms_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Pugri bu ni wute ni ningg yumbui nde yumbo ninge materi pudi oyi mand segine kin te ngam niram mandi. Wuti ye nawo nandi kin te pengu nindig nari, ‘Nu nge yumbui ningg yumbo pughe gri pu kuateri pudi oyi guad segine?’ ");
INSERT INTO kms_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Di ni nari, ‘Nge oliv kin wel 3,000 lita kateri.’ Muq yembe ye wuti te simbe nindig nari, ‘Brequne ghas, nyumo raqe wen taqwi 1,500 litane ur ghand.’ ");
INSERT INTO kms_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Muq ni wuti aye mune pengu nindig nari, ‘Nu pughe gri pu kuateri?’ Di wuti te nari, ‘Nge wit bek 100-pela pu katemi.’ Di ni simbe nindig nari, ‘Muq nu nyumo raqe wen asi nu yumbo kuateri di ur mand pu rise ye wen taqwi, di 80-pela pune ur ghand.’ ");
INSERT INTO kms_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Yembe ye mingg yumbui ni pugri puq nen kin te otiwo nikin yumbui te nuqond di nari ni otiwo kin nei ur namb. Te pugri ni pugri puq nen kin te wute yumbo bar map kin puq men kin pugri puq nen. Wute qi pe kin yumbo ur ni nde rise kin ni wute wam kin yumbo ur ni nde rise kin te ane tuqui segi. Wute qi pe kin nikin yembe mand kin ngim isis quan nganye nei mimbiny. ");
INSERT INTO kms_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nge nungoqi simbe guduq, qi pe kin wet bidi pe nungoqi quayi nyumbueg qi pe kin yuwon wany ei ni nungoqi chumbuai runduq. Te pu ei otiwo wet bidi wateri kin te prene, di nungoqi wewo wo wute ris ris otiwo kin te ane was. ");
INSERT INTO kms_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Wuti yumbo wokuandi kin sabi nindiny, tedi yumbo yumbui kin mune sabi nindiny tuquine. Di wuti yumbo wokuandi kin sabi nindiny segi, tedi yumbo yumbui kin mune sabi nindiny tuqui segine. ");
INSERT INTO kms_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pugri bu nungoqi qi pe kin wet bidi sabi wundiny segi, tedi ni nei mamb nungoqi wute wandoqi wand ye di yumbo nganye kin mune meuq wateri segine. ");
INSERT INTO kms_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Di nungoqi wute aye ningg yumbo sabi wundiny segi, tedi yumbo nungoqi non te te mune meuq segine. ");
INSERT INTO kms_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yembe ye wuti iri yumbui temi temi yembe nindim tuqui segi. Ni wute temi temi yembe nindim tedi iri yawo nirang righe di iri oyi yambu nireng, di iri ningg wand nutungu di iri oyi dob neng. Nungoqi God wet bidi anene nei wumbiny tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi ni wet bidi quan nganye nei mimbiny ye, pugri bu ni Jisas pugri wand nand kin te mutungu di Jisas wand peq mindig di wur mang. ");
INSERT INTO kms_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Di Jisas ni simbe nindim nari, “Nungoqi wutaqu nungoqi non nei pe wari nungoqi wute nde rar pe yumbo ur yuwon ye wand ye. Pudi God nungoqi nei nundouq pre. Yumbo wute qi pe kin mari yuwon nganye puq mand kin te God nde rar pe brequ.” ");
INSERT INTO kms_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jisas nari, “Lo Moses ningg lo buk pe rise kin wand di propet ni mingg wand buk pe rise kin te simbe mand mand rindi rindi Jon nas. Di Jon nas kin tende puayi pu rindi yumbo buagi God nde si nambu rise kin wand yuwon ye te bir mawo tiqe manyi mutungu. Di wute buagi yumbo yumbo God nde si nambu rise ye tende rir ruso ningg buid nganye rip rip. ");
INSERT INTO kms_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Qi nginy tu ane pre kin tuqui, pudi God ningg lo puch woju nganye ire pre kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Wuti iri ni ngam puaq nindiq di nyumbueg aye nitaqi ni ngam kin lo gure nuaq. Di wuti iri nyumbueg ngaim puaq nindiq pu wus kin te ni nitaqi, ni ngam kin lo gure nuaq.” ");
INSERT INTO kms_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas nari, “Asi wuti iri nas. Wuti te wet bidi quan rise kin pugri bu ni chongo yuwon yuwon, ambo kin di quem kin te nare righe. Di nginy manyi wuti te nikin baj pe nas di mir yuwon ye nand. ");
INSERT INTO kms_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ni nde baj ngimrawu tende wuti iri yumbo segi kin tende ruqo pu nase. Wuti te ni nyamb Lasarus. Lasarus ni nei namb kin ni tende nas ei wuti wet bidi kin te mir nand di ni ningg mir di ir righe kin te dong nand, ne ningg. Ni nde ghimbi pe waserar nganye buagi ris. Waserar wuye te righe ruso di nyombui rindi ni waserar mureng rimbig. ");
INSERT INTO kms_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Otiwo wuti yumbo segi kin te nati. Ni nati di God ningg angelo mandi ni mitanyi mo Abraham nas kin pe tende mowi nas. Di wuti wet bidi quan kin mune natine di mowi yenu. ");
INSERT INTO kms_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ni no mati kin tiqe pe nas, di yuqo quan kumo nare. Ni wam rar neq wiyo Abraham wonji nganye te newo nas nuqoind, di Lasarus ni nde tumo te nas nuqoind. ");
INSERT INTO kms_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Muq wuti wet bidi quan kin te pugri ngam nare nari, ‘Wuyi, Abraham. Nge wase pe ven yengu yuqo quan nganye kare. Pugri bu nu nge yawo togh, Lasarus tiqi ndog no, si timi wuye pe ni naghe pre, neri nandi nge nde minjuq pe nundub ei nge minjuq musoq uyi nare.’ ");
INSERT INTO kms_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Pudi Abraham oyi nari, ‘Nge wo, nu yumbo ren ei nei mbiny. Asi nu kuati segine kin tende puayi nu yumbo yuwon kin buagi kuateri, di Lasarus oyi yumbo brequ kin nateri. Pudi muq ni ven nde yuwon pu nas di chumbuai nand, di nu oyi yuqo quan kumo raq. ");
INSERT INTO kms_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yumbo aye mune pugri. Beghi tiqe opu nungoqi tiqe opu, mingi tende God changru yumbui ire nuaq pre pu wuse. Te pu ei wute ninge beghi nde ven pu nungoqi nde mondo ningg mari, pudi tuqui segi. Di wute nungoqi yequ ye te pu beghi nde mandi ningg mari, pudi tuqui segi.’ ");
INSERT INTO kms_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Muq wuti wet bidi quan kin te oyi nari, ‘Wuyi, te kin te be nge nu pengu guduw, nu Lasarus tiqi ndog nge wuyi nde baj pe no. ");
INSERT INTO kms_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Te pugri nge qam 5-pela pu mas. Lasarus no ni wu wand nindim ei ni nei mare mitinde ei ni mune nge yengu ye pe ven nde mawi segi. Eti ni yuqo pare kin tiqe pe ven nde mawi.’ ");
INSERT INTO kms_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Pudi Abraham oyi ni oyi nindig nari, ‘Moses ningg lo di propet ni mingg wand tende rise. Ni ni mingg wand te oyi mutungu kin tuqui.’ ");
INSERT INTO kms_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Di wuti wet bidi kin te nari, ‘Wuyi Abraham, segi. Tene tuqui segi. Pudi wuti iri nati pre kin mune nes newo ni nde no ni simbe nindim, tedi ni nei mare mitinde kin tuqui.’ ");
INSERT INTO kms_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Di Abraham ni simbe nindig nari, ‘Ni Moses ningg lo di propet ni mingg wand mutungu yambu mari, tedi piyi wute mati kin iri mune nes newo ni nde no di ni simbe nindim, pudi te ningg mune nei mare mitinde tuqui segine’.” ");
INSERT INTO kms_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas nikin wute pugri simbe nindim nari, “Yumbo isis ei rindi ye. Yumbo te wute puq rem di ir maghe yumbo ur brequ mand ye. Pudi wuti tughe ye nawo yumbo ren puq nen di wute aye mune puq men ye wuti te otiwo mai niraq ye. ");
INSERT INTO kms_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Di wuti iri ni wokuandi nge nei mimbigh ye men kin ye iri puq neng yumbo ur brequ nand, te wuti te wet yumbui gibe pe wuq wang gherim pe meweri naghe tedi yuwon. ");
INSERT INTO kms_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pugri bu nungoqi yeng wawo yuwon. “Nu nimand iri yumbo ur brequ nand, te nu simbe ndig ei ni mune yumbo ur brequ nand segi. Ni nei nare nitinde, te nu mai puaq ndig. ");
INSERT INTO kms_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ni nginy iri ningg nu nde yumbo ur brequ nand 7-pela pu nand pre, di mune nunde nandi nari, ‘Nge nei kare kitinde.’ Ni pugri puq nen 7-pela pu nand, te piyi nu wand puaq ndig.” ");
INSERT INTO kms_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Muq aposel Yumbui ningg mari, “Nu beghi ghav ndug ei beghi God quan nganye nei bidig.” ");
INSERT INTO kms_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Di Jisas oyi ni oyi nindim nari, “Piyi nungoqi God nei wumbig kin te wokuandi woju nganye mastet yi kin pugri, nungoqi nyumo yumbui nen simbe wundig wari, ‘Puate pene bri ghas di yo gherim wam yiri.’ Tedi nyumo nen nungoqi ningg wand nutungu di nungoqi wari kin pugrine puq nen ye. ");
INSERT INTO kms_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nungoqi kin wuti iri nikin yembe ye wuti iri yenu. Di yembe ye wuti te wuny mbe qi bir nuaq o sipsip yeng nuany pu yenu yenu pre, yuram mune baj pe nandi. Tedi ni pugri bri simbe nindig nari, ‘Be gheyi ghandi ghas di mir ghand’? ");
INSERT INTO kms_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Te segi. Ni nikin yumbui ni pugri ei simbe nindig nari, ‘Nu yo nge mir wase wagh, pre mir wase kin chongo taq mbiq di nge mir ghawo di ragh ghandi. Nge mir gad wuye ke pre, dobu muqdi nu mune mir ghand di wuye ye.’ ");
INSERT INTO kms_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yembe ye wuti nikin yumbui ni yembe neng kin te yembe nindiny pre. Pugri bu nikin yumbui te kin ningg chumbuai bri nindig ye? Tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pugri bu nungoqi mune pugrine God nari kin yumbo buagi te yembe wundiny pre, te muqdi nungoqi pugri ei puq wand wari, ‘Beghi yembe ye wute oghi nganye segi, beghi yembe nupung ruso kin tene yembe bidiny. Pugri bu te ningg chumbuai nundug wayequ’.” ");
INSERT INTO kms_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Muq Jisas nyinge nare Jerusalem no. Ni no kin Samaria opu yequ Galili opu yequ ni mingine ngase pene nyinge nare no. ");
INSERT INTO kms_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ni nyinge nare no tiqe pe nondo, di muq tene tiqe nar no ningg tumo tumone di wute 10-pela num brequ leprosi mare kin te mandi ni muqoind. Di ni wonjine yemu, ");
INSERT INTO kms_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","di pugri ngam mare mari, “Jisas, Yumbui, nu beghi yawo tongu!” ");
INSERT INTO kms_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas ni te nuqond di ni simbe nindim nari, “Nungoqi wo nungoqi non ghimbi prist nde bei wand.” Ni muq qa nyinge mare mo mone di num te prene di ni ghimbi mune yuwon rind. ");
INSERT INTO kms_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wute 10-pela te kin iri ni nuqond ni ghimbi mune yuwon rind di mune nandi, di quan kumo ngam nare God nyamb nindivi viyo. ");
INSERT INTO kms_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ni nandi, Jisas nde muange tingi sungomyu sungomyu yenu di Jisas chumbuai nindig. Wuti te Samaria kin. ");
INSERT INTO kms_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Muq Jisas pengu nand nari, “Wute aye 9-pela te muai mo? Wute 10-pela buagi anene num oghi segi, wuti irine bri oghi? ");
INSERT INTO kms_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pughe kin ningg ate wuti wute tit aye kin nen irine mune nandi di God nyamb nindivi viyo, di wute aye te mandi God nyamb mindivi viyo segi?” ");
INSERT INTO kms_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Muq ni simbe nindig nari, “Be yes yewo yo. Nu God nei gubig ye te ningg nu num te oghi pre.” ");
INSERT INTO kms_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi ninge Jisas pengu mindig mari, “Pughe puayi ei yumbo yumbo buagi God nde si nambu rise ye?” Muq Jisas ni oyi nindim nari, “Yumbo yumbo God nde si nambu rise ye ngeri te rindi kin te nungoqi yumbo ur gre ye ninge wuqond di nei wamb ngeri te tumo rind, te segi. ");
INSERT INTO kms_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Di wute ninge nungoqi simbe munduq mari, ‘Ni nandi ren yumbui ningg nas,’ o ‘Ni te no nas,’ te segi. Te pugri yumbo yumbo buagi God nde si nambu rise ye te nungoqi nde rise pre.” ");
INSERT INTO kms_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Muq Jisas nikin wute simbe nindim nari, “Otiwo di nungoqi nge, wuti God nde pu gadi wuti nganye kas kin, nge ngeri te wuqond yawo nganye kureuq ye, pudi wuqond tuqui segi. Te kin ngeri rindi ye. ");
INSERT INTO kms_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Di wute nungoqi wandoqi munduq kin te mandi ye. Ni mandi di nungoqi simbe munduq mari, ‘Ni tende no yenu,’ o mari, ‘Ni nen yenu.’ Ni pugri ei puq mand, pudi nungoqi ni nde dobu waru wayequ. ");
INSERT INTO kms_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Te pugri nge, wuti God nde pu gadi wuti nganye kas kin, nge gadi ye te pris kin pugrine. Nungoqi nei wamb nginy tu pe pris naghe te ni ti te ti nase wonji ruso. Nge, wuti God nde pu gadi wuti nganye kas kin, nge pugrine ei gadi di wute buagi nge ruqoind. ");
INSERT INTO kms_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pudi muq nge yuqo quan kiraq di wute tit muq ven nde puayi mas kin men nge brequ puq mindigh, di dob megh pre ei. ");
INSERT INTO kms_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Asi Noa nas kin tende puayi wute yumbo ur rind ye te kin pugrine ei nge, wuti God nde pu gadi wuti nganye kas ye, nge gadi kin ngeri tende puq ren ye. ");
INSERT INTO kms_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wute nei tuan rimbiq pu ris, mir rind, di wuye riq, di quayi nyumbueg ngam ruso. Ni te kin pugri puq ren ren ne ruso, Noa at pe nar no kin nginy tende. Muq Noa at pe nar no di wuye nime kur di wute buagi rumb riti. ");
INSERT INTO kms_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot ni nas kin tende puayi mune wute pugrine puq ren. Wute nei tuan rimb pu ris mir rind di wuye riq, yumbo wong rind di ri rundo wute aye wong rind, wuny mbe yumbo ri righe di baj yembe mindiny. ");
INSERT INTO kms_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pudi Lot ni Sodom si niraq di no kin nginy tende puayi God wet nyaw wase ane kin wam pu ir nawo mati, di wute buagi ritine omo. ");
INSERT INTO kms_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nge, wuti God nde pu gadi wuti nganye kas kin, nge nungoqi nde raqe ko kin ngeri te ningg di asi wute te puq ren kin pugrine nganye ei puq ren ye. ");
INSERT INTO kms_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tende puayi wuti iri ni yumbo wabene rise muq ni newo no pu baj wam nas kin te mune nar no nikin yumbo te nateri ye tuqui segi. Te kin pugrine, wuti iri wuny mbe yembe yembe yenu pu mune nikin baj pe no yumbo nateri ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot ngam ningg yumbo ur te nei wumbiny. ");
INSERT INTO kms_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wuti tughe nge ningg yembe nand nand muq te ningg mai niraq di nati yambu nari kin te ni mai niraq ye. Di wuti tughe nge ningg yembe nand nand muq te ningg mai niraq di nati, wuti te kin otiwo di ni oyi yuwon pu nas. ");
INSERT INTO kms_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nge nungoqi simbe guduq, bur te ningg wute temi ede ire ninggne mase, pudi iri nitanyi no di iri nase. ");
INSERT INTO kms_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Nyumbueg teri wit yi dang rindiq plaua yembe runduw runduw yeru ire nitaqwi di ire yequ.” ");
INSERT INTO kms_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Muq ni Jisas pengu mindig mari, “Yumbui, yumbo ren kin muainde ei puq ren ye?” Di Jisas nari, “Umo riti kin ni muainde rise te wapi ambojig ni mune mandi tendene mikur ye.” ");
INSERT INTO kms_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Muq Jisas nikin wute kopuqu wand ire simbe nindim. Kopuqu wand te simbe nindim kin te ni si yavi mati segi kin, ni priprine ei Yumbui pengu mindig ye te kin kopuqu wand. ");
INSERT INTO kms_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ni pugri simbe nindim nari, “Tiqe ire ningg wuti iri wute aye ningg wand nutungu di teti nawo kin nas. Ni wuti God wune nimbig segi, di wute yawo nitony segi ye. ");
INSERT INTO kms_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tiqe te ninggne nyarimo nyumbueg ire wus. Nyumbueg te priprine ninde wundi di simbe wundig wuri, ‘Wuti nge temu kot bad kin ni nge unje naip ningg. Nu nge kot ghav ndigh.’ ");
INSERT INTO kms_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Pripri ni wundi wuri pudi ni ghav nunduw yambu nari. Pudi muq ni pugri nei nimbiq nari, ‘Nge God wune gibig segi, di wute yawo kutony segi, ");
INSERT INTO kms_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pudi nyarimo nyumbueg wen priprine wundi nge mai wegh. Pugri bu piyi nge ni kot ghav guduw ei mune wundi segi. Eti ni priprine wundi nge ningg wuri wuri di nge si yavi kati’.” ");
INSERT INTO kms_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Di Yumbui nari, “Nungoqi wuti brequ nen ningg wand ven wutungu. ");
INSERT INTO kms_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nungoqi pughe gri nei wamb? God nikin wute ni nap ruso pre kin te ni ghav nindiny ningg pripri bur manyi di nginy manyi ris riri riri kin te ghav nindiny ye tuqui segi bri? Ni riri kin te ni nutungu nutungu, pudi ghav nindiny tuqui segi bri? Te segi. ");
INSERT INTO kms_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nge nungoqi simbe guduq, God brequne nganye ei nikin wute ghav nindiny ye. Pudi otiwo nge, wuti God nde pu gadi wuti nganye kas kin, nge mune gadi ye tende puayi di nge guqod wute qi pe kin God nei mimbig o segi?” ");
INSERT INTO kms_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wute ninge nikinne nei mamb kin mari nine tuquine mas, di wute buagi aye te ni kin pugri yuwon nganye segi. Wute te kin ye mingg Jisas kopuqu wand ven simbe nand. Ni nari, ");
INSERT INTO kms_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wute temi God ningg baj pe mewo mo, God ane wand ningg. Wuti iri Parisi di iri wuti takis nateri ye. ");
INSERT INTO kms_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Muq Parisi te nes newo di nikinne Yumbui pengu nindig, ‘God nge nu chumbuai guduw, nge wute aye te kin pugri segi. Ni wute aye yumbo nyungu mindim, yumbo ur brequ mand, di nyumbueg ngam kin wand meny ye. Pudi nge te kin puq ken segi ye. Di nge wuti takis nateri ye nen kin pugri segi. ");
INSERT INTO kms_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nge wik ire ningg nginy temi mir uny yengu, di nge yumbo yumbo buagi kateri kin te bir kawo bid 10-pela pu di ire nu kew ye.’ ");
INSERT INTO kms_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Pudi wuti takis nateri kin ni musoq kring nondo wonjine pugri yenu. Di ni wam rar neq wiyo segi, ni yimbne naghe pu yenu, mand baq nand di nari, ‘God nge wuti yumbo ur brequ gad ye, nu nge yawo togh.’ ");
INSERT INTO kms_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nge nungoqi simbe guduq, wuti takis nateri kin nen munene nikin nde baj pe no di God nde rar pe tuquine nas. Wuti aye te segi. Te pugri wute buagi nikinne nikin nyamb mindivi viyo kin te God oyi ni nyamb nyinge nuam vighe ye. Di wute buagi nikinne nikin nyamb mi vighe viso kin te God oyi ni nyamb nindivi viyo.” ");
INSERT INTO kms_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Di wute wokuandi Jisas nde ritari rundo ei Jisas ni si neny riwo ningg. Jisas ningg wute ni te muqond, di wute te ker muany. ");
INSERT INTO kms_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pudi Jisas ni nari di wo te ritari ni nde rindi di ni nari, “Wokuandi te rar wuqond nge nde rindi, segi puq wundiny wayequ, te pugri wute God nde si nambu ris kin te wokuandi pugri ye ni te. ");
INSERT INTO kms_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nge nungoqi nganye simbe guduq, wuti iri ni wokuandi ren kin pugri God nde si nambu nas segi, tedi ni wute God nde si nambu ris kin tende nar no segi.” ");
INSERT INTO kms_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Muq Juda mingg nyamb ye iri Jisas pengu nindig nari, “Tisa, nu yuwon nganye. Nu nge simbe ndigh, nge pughe sin ken ei nge kas kas te kin kas?” ");
INSERT INTO kms_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Di Jisas ni oyi nindig nari, “Pughe ningg nu nge yuwon puq gudigh? Wuti iri yuwon segi; God irine yuwon. ");
INSERT INTO kms_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nu God ningg lo ren nei guab pre, ‘Wute ngam kin ane wase wayequ; wute ghamb riti wayequ; nyungu ghand wayequ; wute segi wandoqi ndiny ghari ni unje rip puq ghand wayequ; di nuyi numo ningg wand irepene tungu’.” ");
INSERT INTO kms_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Di wuti te oyi nari, “Yumbo ren kin nge asi wokuandi ne kas kin tende puayine puq ken ken rindi rindi muq.” ");
INSERT INTO kms_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas te nutungu di ni simbe nindig nari, “Yumbo ire nu puq kuen segine. Nu yumbo yumbo buagi te yi rundo wute aye wong mand, di wet bidi te kin ghateri wute yumbo segi kin yeny. Nu puq yen tedi nu yumbo yuwon kin nganye nginy tu wam rise. Nu puq yen pre muqdi nge nde ghawi.” ");
INSERT INTO kms_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wuti te ni yumbo quan nganye rise ye, pugri bu Jisas ni pugri puq nindig kin te nutungu di ni quan nganye yivany nare. ");
INSERT INTO kms_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas wuti te nuqoind ni quan nganye yivany nare, di ni nari, “Wute yumbo quan rise kin ni wute God nde si nambu ris kin tende rir ruso kin yembe yumbui nganye. ");
INSERT INTO kms_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Umo yumbui kamel puq munduw kin ni chongo rang kin nil gawo woju tende wur wuso kin yembe yumbui segi, pudi wute yumbo quan kin ni wute God nde si nambu ris kin tende rir ruso ye yembe yumbui nganye.” ");
INSERT INTO kms_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wute wand ven mutungu di mari, “Tedi wuti tughe ei God neti nowi yuwon pu nas ye?” ");
INSERT INTO kms_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Di Jisas ni oyi nindim nari, “Yumbo wute puq ren tuqui segi kin te God puq nen ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Muq Pita Jisas ningg nari, “Beghi beghi bon yumbo yumbo buagi si pare rise di nu nde dobu pawi.” ");
INSERT INTO kms_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Di Jisas ni simbe nindim nari, “Nge nungoqi nganyene simbe guduq, wute God nde si nambu mas ningg mari muq ni tiqe, nikin ngam, kise kiqam, kiyi kumo, di wo si mare, ");
INSERT INTO kms_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wute te muq qi pe ven nde masne kin ven nde puayine God ni yumbo quan nganye ei nem ye. Yumbo te asi kin ane tuqui segi. Di wute te kin ni otiwo yumbo buagi yuwon pe rise kin tende puayi ni anene yuwon pu mas mas te kin mas ye.” ");
INSERT INTO kms_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas nikin wute 12-pela pu te waghine nitami no nikinne yemu, muq simbe nindim nari, “Muq beghi Jerusalem pewo po. Wand buagi asi propet ni wuti God nde pu nandi wuti nganye nas ye ni ningg wand ur mand ye te muq nganyene ei puq ren yamb. ");
INSERT INTO kms_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Muqdi ni mait nase di wute Juda segi kin ninde si pe mi nondo ye. Di wute Juda segi kin wand peq mindig, som miping, yas muang, di mi nati. ");
INSERT INTO kms_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pudi nginy temi mo pre aye ningg di ni mune nes newo ye.” ");
INSERT INTO kms_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jisas ningg wute Jisas ni wand buagi ren simbe nand kin ren ni musoq nei mimbiny segi nganye. Ni nei imb ruam, pugri bu Jisas wand nand kin te wand puate ni nei mamb segi, ni pughe kin ningg wand nand. ");
INSERT INTO kms_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","36","Jisas Jeriko tumo nondo nondo di wute buagi ni ruqoind ningg nyinge rire ruso rindi. Di wuti rar brequ kin iri ngim sange pe tende yumbo sang nap nap nas. Ni nutungu wute buagi nyinge rire ruso rindi di ni pengu nand nari, “Pughe sin ren?” ");
INSERT INTO kms_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Di ni simbe rindig riri, “Jisas Nasaret kin ni nyinge nare ven gri nandi.” ");
INSERT INTO kms_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Muq ni ngam nare nari, “Jisas, Devit ningg kuqo, nu nge yawo togh.” ");
INSERT INTO kms_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Di wute ye ruwo kin te ni ker ruang di segi puq rindig ei ni wand segi nas. Pudi ni mune nganye nari, “Devit ningg kuqo, nge yawo togh.” ");
INSERT INTO kms_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Muq Jisas yenu di ni simbe nindim nari, “Wuti te wutanyi ven wandi.” Ni mitanyi mandi Jisas nde tumo di Jisas ni pengu nindig nari, ");
INSERT INTO kms_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nge nu pughe sin kew ningg kuari?” Di ni oyi nari, “Yumbui, nge rar kat di yumbo guqod ningg kari.” ");
INSERT INTO kms_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Muq Jisas ni simbe nindig nari, “Be nu rar ghat. Nu nge nei gubigh ye te ningg nu rar oghi pre.” ");
INSERT INTO kms_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Muq brequne nganye ni rar mune oghi rar nat yumbo nuqond, di God nyamb nindivi viyo viyo Jisas nde dobu naru. Wute buagi te ruqond, ni mune God nyamb rindivi viyo. ");
INSERT INTO kms_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jeriko nar no di tene nyinge nare Jerusalem no. ");
INSERT INTO kms_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wuti iri tiqe tende nas, ni nyamb Sakius. Sakius ni wute takis materi ye yumbui, di ni wet bidi quan nganye rise ye. ");
INSERT INTO kms_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ni Jisas nuqoind yawo gureg, pudi wute nganye buagi nganye rindi bre, di ni wuti bog ye pugri bu ni Jisas nuqoind ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pugri bu ni vig namb ye nawo no, nyumo dobui iri ningg newo no. Te ni nei namb Jisas nyinge nare te gri ei nandi ye. ");
INSERT INTO kms_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas nandi Sakius nase pe tende ni neyi di nyumo wam tende rar neq wiyo wuso, Sakius nuqoind, di simbe nindig nari, “Sakius, muq nginy nen ningg nge nunde baj pe ei kas ye. Pugri bu nu brequ ghati yi.” ");
INSERT INTO kms_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pugri bu Sakius brequne nati ni, di ni nde umbo pe quan nganye chumbuai nand, di Jisas nitanyi ninde baj pe no. ");
INSERT INTO kms_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wute buagi Jisas Sakius temi Sakius nde baj pe mo kin te ruqond di ni ker ruwo riri, “Ni no wuti iri yumbo ur brequ nand ye ni ningg baj pe nas.” ");
INSERT INTO kms_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pudi ni baj pe mo mas di Sakius ni nes newo di Yumbui ningg nari, “Yumbui, nu tungu. Muqdi nge yumbo buagi bir kawo bid teri di ire wute yumbo segi ris kin te keny. Nge wuti iri wandoqi gidig di ni ningg yumbo nyungu gidig pu tedi muqdi nge oyi ni yumbo kateri kin tuquine 4-pela pu oyi gidig.” ");
INSERT INTO kms_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Di Jisas ni simbe nindig nari, “Muq God wute baj ren kin nateri pre. Wuti nen mune Abraham ningg kuqone. ");
INSERT INTO kms_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te pugri wuti God nde pu nandi wuti nganye nas kin ni wute ir ruso ye te meri nitiny nandi nuqond ei mune nate ruwi ningg bu nandi.” ");
INSERT INTO kms_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas muq Jerusalem tumo nase nase. Wute nei rimb kin Jisas Jerusalem no nar di brequne yumbo yumbo buagi God nde si nambu rise kin te raqe ruso ye. Pugri bu wute buagi Jisas wand nand kin te rutungu rutungu ne di ni kopuqu wand aye ven mune simbe nand. ");
INSERT INTO kms_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ni nari, “Wuti nyamb kin iri ni nes newo wonji tiqe aye pe no, ei ni king ningg si mumbog ningg. Pre ei mune nikin tiqe nandi, di nikin wute mingg king ningg nas. ");
INSERT INTO kms_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ni no ningg di nikin yembe ye wute 10-pela pu nari mandi di 20 kina 20 kina nem di simbe nindim nari, ‘Wet bidi ren ningg yumbo ninge yembe wundiny wundiny was was nge mune gadi. Nge mune gadi di guqod nungoqi wet bidi aye pughe gri pu wateri pre.’ ");
INSERT INTO kms_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pudi wute nikin nde opu kin ni umbo ker muang, pugri bu ni no pre di ni wute ninge tiqi mundom dobu maru ei simbe mand mari, ‘Wuti nen beghi ningg king ningg nas ye beghi yambu pari.’ ");
INSERT INTO kms_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pudi wuti te ni no te yabe ni king ningg si mumbog pre, di mune nikin tiqe nandi. Ni nandi pre, muq ni nikin yembe ye wute asi ni wet bidi nem kin te mune wand nuam mandi. Ni wand nuam mandi ei nuqond ni wet bidi tende pe yumbo ninge yembe mindiny di wet bidi aye pughe gri materi pre. ");
INSERT INTO kms_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Muq wuti ye nawo kin te neyi nandi di nari, ‘Yumbui, nu nge 20 kina kuegh kin tende pe nge aye mune 200 kina yembe gidiny pre.’ ");
INSERT INTO kms_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Di nikin yumbui oyi nari, ‘Nu nge yembe ye wuti yuwon ye. Nu yuwonne yembe guad. Nu yumbo wokuandi ren yuwonne nganye puq kuen ye, pugri bu muq nge kari di tiqe yumbui 10-pela pu ren nunde si nambu yeru.’ ");
INSERT INTO kms_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Di wuti aye ni nde dobu nawi kin te mune nandi di nari, ‘Yumbui, nu 20 kina tende pe nge 100 kina aye kateri.’ ");
INSERT INTO kms_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Di ni yumbui ni oyi nindig nari, ‘Nu tiqe yumbui 5-pela pu nu nde si nambu yeru.’ ");
INSERT INTO kms_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Muq yembe ye wuti aye mune nandi di nari, ‘Yumbui, nu wet bidi taq ren. Nge chongo bidi pe imb gab yuwon, di kawo rise. ");
INSERT INTO kms_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nu wuti quan nganye ker kuawo ye, pugri bu nge wune gab bu nu wet bidi te chongo imb gab pre kawo rise. Nu yumbo wute aye mawo rise kin te kuateri ye, di yumbo wute aye mi righe kin te nu kuateri ye. Pugri bu nge wune gab.’ ");
INSERT INTO kms_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Muq nikin yumbui oyi nari, ‘Nu yembe ye wuti brequ nganye. Nu non wand guad kin wand tende pene di nu brequ guduw ye. Nu kuari nu nei guab nge wuti quan nganye ker kawo ye, nge yumbo wute aye mawo rise kin te kateri ye, di yumbo wute aye mi righe kin te kateri ye. ");
INSERT INTO kms_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nu nei guab pu di pughe kin ningg nu nge wet bidi benk pe oyi kuawo righe segi? Te pu ei benk oyi wet bidi tende pe yembe mand di aye ninge mawo righe, di otiwo nge mune gadi di aye te ane kateri.’ ");
INSERT INTO kms_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Muq ni wute ninde tumo yemu kin te simbe nindim nari, ‘Ni ningg wet bidi 20 kina te wutangri di ware wo wuti 200 kina yembe nindiny kin te weng.’ ");
INSERT INTO kms_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Pudi wute te ni simbe mindig mari, ‘Yumbui, wuti te ni 200 kina rise pre.’ ");
INSERT INTO kms_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Di ni oyi nindim nari, ‘Nge nungoqi simbe guduq, wute nikinne yumbo ninge rise tedi nge aye ninge kem ye. Pudi wuti iri nikinne yumbo ninge rise segi, tedi yumbo pughe kin woju ni nde rise kin te nge puaq gad di wute aye kem. ");
INSERT INTO kms_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pudi nge veri, wute nge ni mingg king ningg yengu yambu mari kin te ven wutami wandi di nge nde rar pene wi mati’.” ");
INSERT INTO kms_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ni kopuqu wand ren simbe nand pre di mune nes newo Jerusalem newo no ningg. Ni nyinge nare ye nawo di wute buagi dobu ruru. ");
INSERT INTO kms_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ni nyinge nare tiqe Betpage di Betani tumo nondo nondo, nyumo oliv kin rand iyu pe tende yenu di nikin wute temi tiqi nundom ye mawo. Ni tiqi nundom mo ningg di yeri nindim nari, ");
INSERT INTO kms_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nungoqi tequ tiqe tumo te yequ kin tende wo. Nungoqi tiqe te ningg warne wondo di donki ghair iri wuq muang pu yenu wuqoind ye. Wuti iri ni donki te ningg no segine. Donki te sare bure wundig di wutanyi ven wandi. ");
INSERT INTO kms_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wuti iri nungoqi pengu nunduq nari, ‘Pughe kin ningg nungoqi donki te sare bure wundig?’ Te nungoqi ni simbe wundig wari, ‘Yumbui ni yembe rise’.” ");
INSERT INTO kms_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wute temi Jisas tiqi nundom ye mawo kin te mo mo mar di yumbo buagi Jisas simbe nindim kin pugrine nganye rise muqond. ");
INSERT INTO kms_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ni temi donki te sare bure mindig mindig yemu di wute donki puate kin mandi ni pengu mindim mari, “Pughe kin ningg nungoqi donki te sare bure wundig?” ");
INSERT INTO kms_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Di ni temi oyi mari, “Yumbui ni yembe ninge rise.” ");
INSERT INTO kms_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Muq ni donki te mitanyi mandi Jisas nde di ni nikin chongo dobui donki wam mawo, di Jisas si miting rise newo no donki wam nas. ");
INSERT INTO kms_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ni donki wam nas no no di wute nikin chongo dobui ngimne ruwo di Jisas chongo wamne donki pe no. ");
INSERT INTO kms_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ni nandi ngim suai nyumo oliv kin rand wo yemu kin tende wughe wuso kin tende nandi, di nikin wute ni yumbo ur gre ye buagi bei nand ruqond ye te nei rimbiny di ni quan nganye chumbuai rind di quan kumone ngam rire God nyamb rindivi viyo riri, ");
INSERT INTO kms_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“God, nu king Yumbui nde nyamb pe nandi kin nen yuwon wang. God wam nganye kin ni nyamb bidivi viyo. Ni beghi ghav nundug di yuwon pu pas.” ");
INSERT INTO kms_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Muq Parisi ninge wute buagi te ane yeru kin te Jisas ningg mari, “Yumbui, nu nu non wute ker wany, ei ni wand ren kin rind wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Di Jisas oyi nari, “Nge nungoqi simbe guduq. Ni wand segi yeru, tedi wet oyi pugri mari ye.” ");
INSERT INTO kms_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jerusalem tumo nase nase rar neq wuso Jerusalem tiqe yumbui nundoq di ni quanji nunduw, ");
INSERT INTO kms_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","di nari, “Jerusalem, nge nde nei pe muq nginy nen ninggne ei yumbo nu ghav runduw di yuwon pu ghas ye te nei mbiny ningg kari. Pudi muq yumbo te nu nde rar pe suqo pu rise. ");
INSERT INTO kms_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nu non veri mandi nu imb maip ye nginy te nandi ye. Nginy te ningg di nu non veri mandi nu imb maip mondo mandi dung, di ngimrawu manyi yeng mawo, di nungoqi ngimrawu ire ningg war wo tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nu bir mowi omone mowi di nu non wute nu nde imb wabe ris kin te mambui riti. Te pugri God ni nu ghav nunduw ningg ngeri ren nap ruso kin te nei gubiny segi, pugri bu ni imb kin wet te iri rar muqoind nas tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Muq Jisas God ningg baj imb wabe nar no, di wute God ningg baj pe maket muaq kin te bub nare mo. ");
INSERT INTO kms_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Di ni simbe nindim nari, “God ningg wand rise kin buk pe God pugri puq nand, ‘Nge ningg baj te wute nge ane wand ye baj puq munduw ye.’ Pudi nungoqi wute nyungu kin suqo mo ye sunyi kin pugri puq wew.” ");
INSERT INTO kms_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nginy manyi ni God ningg baj pe nar no wute buagi God ningg wand bei neny. Pudi prist mingg yumbui, wute Moses ningg lo wute bei meny ye di Juda mingg quayi kiyi ni Jisas mi nati ningg ngim meri mand. ");
INSERT INTO kms_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pudi ni mi nati kin ngim ire mundoq segi. Te pugri wute buagi Jisas ningg wand quan nganye rutungu yawo kureny. ");
INSERT INTO kms_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nginy iri ningg Jisas God ningg baj pe yenu quayi nyumbueg wand bei neny, di God ningg wand yuwon ye bir nawo nawo yenu, prist mingg yumbui, wute Moses ningg lo wute bei meny ye, di quayi kiyi ane Jisas nde mowi mandi. ");
INSERT INTO kms_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ni mandi di Jisas pengu mindig mari, “Nu beghi simbe ndug, nu gre pughe ye pe yumbo ren yembe gudiny? Tughe nu ngiq nunduw bu nu yembe ren guad?” ");
INSERT INTO kms_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Di ni oyi nari, “Muq nge oyi mune pengu ire nungoqi pengu guduq. Nungoqi nge simbe wundigh, ");
INSERT INTO kms_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon ni tughe nde gre nateri di ni wute wuye nap? God nde pu nateri o wute nde pu nateri.” ");
INSERT INTO kms_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Di ni kin kin wand mand mari, “Beghi pari God nde pu nateri, tedi ni beghi ningg nari, ‘Pughe kin ningg nungoqi Jon ningg wand te wutungu di nganyene puq wand segi?’ ");
INSERT INTO kms_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wute buagi ni nei rimb kin Jon ni propet iri. Ni nei te kin gre vind pre ye, pugri bu beghi pari, ‘Ni gre te wute nde pu nateri,’ tedi wute buagi men yemu kin men beghi wet pe mumbuemu.” ");
INSERT INTO kms_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Te ningg di ni oyi mand kin mari, “Beghi nei bab segi, ni gre te muainde pu nateri.” ");
INSERT INTO kms_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jisas nari, “Nge mune pugrine, nge tughe nde gre pe yumbo ren yembe gidiny kin te nungoqi simbe guduq segi.” ");
INSERT INTO kms_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Muq Jisas wute kopuqu wand aye ven mune simbe nindiny: “Wuti iri ni wain wuny ire yembe nindiny. Ni pre nand di wute aye nem di ni ber manyine wong maind maind mas, di ni wonji tiqe aye pe no nas nas nganye. ");
INSERT INTO kms_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ni no nas nas wain yi uri mand kin tende puayi ni nikin yembe ye wuti iri tiqi nundog wute ni wain wuny yeng muany ye tende no. Ni no ni simbe nindim ei ni wuny te kin wain yi ninge meng pu nare no ni neng ningg. Pudi wute wuny yeng muany kin te mes mewo yembe ye wuti te pug mindig, di tiqi mundog si omone mune no. ");
INSERT INTO kms_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Di ni yembe ye wuti aye mune tiqi nundog no. Pudi aye te mune pugrine, pug mindig, wand brequ mindig, di tiqi mundog si omone no. ");
INSERT INTO kms_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Di ni aye mune tiqi nundog no, di te mune pugrine mi yavi naghe, di mitanyi mo wuny dabo memeri nar no. ");
INSERT INTO kms_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Muq wuny kiyi te nari, ‘Muq nge pughe ei ken ye? Nge ning wo nganye, nge quan nganye yawo girag righe ye te tiqi gudog no ei. Ni bri no nari ei ni ni ningg wand mutungu.’ ");
INSERT INTO kms_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Muq ni nikin wo te tiqi nundog no, pudi wute wuny yeng muany kin nikin wo te nandi muqoind, di wand wand mare mari, ‘Wuti nen ei ni kiyi ningg yumbo yumbo buagi nateri ye. Beghi pi nati, ei ni ningg yumbo yumbo te beghi oyi pateri.’ ");
INSERT INTO kms_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pugri bu ni mitanyi mo wuny dabo memeri nar no di mi nati.” Muq Jisas ni pengu nindim nari, “Nungoqi nei wamb kin pughe gri. Wain wuny te kin kiyi wute te pughe ei nem ye? ");
INSERT INTO kms_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ni nandi di wute wain wuny wong maind maind mas kin ni mati, di wute aye mune nari mandi wuny te wong maind maind mas, di ni oyi wuny te yeng muany ye.” Wute buagi te yeru kin ni te rutungu di riri, “Ni pugri puq nen wayequ.” ");
INSERT INTO kms_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Di Jisas rar neq wundo wute buagi te nuqond, di pengu nindiny nari, “Te muq wand ven God ningg wand rise kin buk pe ur pu vise kin puate pughe? ‘Wet te asi wute baj yembe mand ye mari brequ di kring maip no kin te muq wet te baj mingine nas di baj nare.’ Sng 118:22 ");
INSERT INTO kms_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wute buagi wam pu ir mi maghe wet pe tende yemu tedi bir puch puch yemu. Pudi wet te oyi ir ni wuti iri dang rind tedi wuti te binye nase.” ");
INSERT INTO kms_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wute lo wute bei meny ye di prist mingg yumbui ni te mutungu di Jisas muqne ei mait nase taq maimb ningg ngim meri mat. Ni kopuqu wand ven mutungu, ni nei mamb Jisas ni mingg bu simbe nand. Pugri bu ni ngim meri mat ei Jisas taq maimb ningg, pudi ni wute buagi mune wune mimbiny. ");
INSERT INTO kms_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Muq prist di wute lo quan nei mamb ye Jisas yeng muang yuwon. Ni wute ninge wong mand di tiqi mundom mandi waghine yemu Jisas yeng muang. Ni yeri mindim pu ei ni mo di wandoqi mand mari ni Jisas ningg wand mutungu yawo nganye kurem ye. Di ni mo Jisas wand ninge pengu mindig. Ni mari ni puq men ei ni wand ninge unje nap ei ni mo prist mingg yumbui simbe mindim, ei ni wand te ningg mitanyi gavman kin yumbui nde mo, di gavman kin yumbui ni taq naimb. ");
INSERT INTO kms_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Muq wute te Jisas pugri pengu mindig mari, “Tisa, beghi nei bab, nu wute buagi wand bei kueny kin te wand nganye kin. Nu wute nyamb kin wand aye simbe gudim di nyamb segi kin wand aye simbe gudim segi. Piyi wute nyamb kin di nyamb segi kin ni buagi ane wand irene simbe gudiny ye. Di nu wand nganye kin pene God ningg yumbo ur te wute bei kueny ye. ");
INSERT INTO kms_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Muq beghi nu pengu buduw, nu beghi simbe ndug. Beghi Sisar nde takis wong bad kin te tuquine o segi?” ");
INSERT INTO kms_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pudi ni wandoqi mand kin te Jisas nei namb pre, pugri bu ni simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Be wet bidi ire nge bei wundigh gudoq.” Ni bei mindig nundoq di ni pengu nindim nari, “Wuti tughe ngawu di nyamb ane wet bidi wen nde rise?” Ni oyi mand mari, “Sisar te.” ");
INSERT INTO kms_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Di Jisas ni simbe nindim nari, “Yumbo Sisar te, Sisar weng; di God te, God weng.” ");
INSERT INTO kms_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pugri bu ni wute buagi nde rar pe Jisas wandoqi mindig, di wand ire unje nap ei kotim maind kin tuqui segi. Di Jisas ni wand oyi nindim kin te mutungu di ni quan nganye puye mand, di ni mune wand mand segi, waghine yemu. ");
INSERT INTO kms_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi ni mari wute mati kin ni mune mes mewo segi ye. Sadyusi Jisas nde mondo di ni pengu mindig ningg. ");
INSERT INTO kms_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pugri bu ni Jisas nde mandi di Jisas wandoqi mindig mari, “Tisa, Moses beghi ningg lo ire pugri ur nindiq, ni nari wuti iri ni kise nyumbueg ire nitaqi, pudi wo segine nati di ni ngam te si niraq wus, tedi ni kiqam te ei mune kise ngam te nitaqi. Ni mune kise ngam te nitaqi, wo niraw di wo te kise nati kin ni te. ");
INSERT INTO kms_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Muq kise kiqam 7-pela pu mas. Kiseyu nyumbueg ire nitaqi pudi wo segine nati. ");
INSERT INTO kms_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Di kiqam ni nde dobu kin mune nitaqi, pudi ni mune wo segine nati, ");
INSERT INTO kms_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","di kiqam ni nde dobu kin mune nitaqi, pudi ni mune pugrine. Te tene ruso ruso 7-pela ane nyumbueg te mitaqi, pudi ni buagi ane wo segine mati, di nyumbueg te si miraq wus. ");
INSERT INTO kms_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Di dobu nyumbueg te mune wuti. ");
INSERT INTO kms_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wute 7-pela pu ni wute te mitaqi. Pugri bu otiwo wute mati kin buagi mes mewo kin tende puayi tedi nyumbueg wen ni tughe ningg ngam ei wus?” ");
INSERT INTO kms_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Muq Jisas ni oyi nindim nari, “Quayi nyumbueg muq qi pe ven nde ris kin ven nde puayi ni ngam ruso. ");
INSERT INTO kms_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pudi wute oghi ye riti kin otiwo God mune nindiri riwo di ni ane ris kin te ni ngam ruso o oyi oyi ngam mawo ruso segi ye. ");
INSERT INTO kms_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Te pugri ni angelo kin pugri ei ris ye, pugri bu mune riti ye tuqui segi, ris ris te kin ris ye. God ni mune nindiri riwo pugri bu ni God ningg wo ningg ris. ");
INSERT INTO kms_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pudi Moses ni mune nari wute mati kin mune mes mewo ye. Te pugri char puch ire wase namb kin wand tende buqod di Moses Yumbui ningg nari, ‘Abraham ningg God, Aisak ningg God, di Jekop ningg God.’ ");
INSERT INTO kms_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God ni wute mati ye ni mingg God segi, ni wute urupui ne mas ye ni mingg God. Te pugri God nde rar pe wute mati kin urupui ne mas.” ");
INSERT INTO kms_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wute lo wute bei meny ye ninge ni wand te mutungu di Jisas simbe mindig mari, “Tisa, nu wand yuwon nganye simbe guad.” ");
INSERT INTO kms_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Muq ni wune mamb, di wuti iri Jisas wand aye pengu nindig segi. ");
INSERT INTO kms_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Muq Jisas ni simbe nindim nari, “Pughe gri ate wute mari Kraist te Devit ningg wo? ");
INSERT INTO kms_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Te pugri Devit nikinne Buk Song pe nari, Yumbui ni nge yumbui ningg nari, ‘Nge nde si tuan pene ghas ruso ruso, ");
INSERT INTO kms_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nge nu veri nu nyinge yi viyo kin komboiq woju ningg kawo mas.’ Sng 110:1 ");
INSERT INTO kms_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit nikinne ni Yumbui puq nindig, tedi pughe gri ei ni Devit ningg wo?” ");
INSERT INTO kms_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wute buagi Jisas ningg wand rutungu rutungu yeru di Jisas nikin wute te simbe nindim nari, ");
INSERT INTO kms_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nungoqi wute Moses ningg lo wute bei meny ye ni mingg ei yeng wawo yuwon. Ni nei mamb kin ni nyamb kin, pugri bu ni pripri chongo dobui kin ei mare righe pre di wute nde rar pe nyinge mare mo yawo kurem ye. Di ni wute buagi pripri rikur kin sunyi pe tende mo di wute ni ei chumbuai kin wand rem yawo kurem ye. Di God yumbui nyamb mirang kin baj pe mo di wute nyamb kin mas ye sunyi pe tende ei mas yawo kurem ye. Di mir yumbui pe mo di wute nyamb kin mas ye sunyi pe ei mas yawo kurem ye. ");
INSERT INTO kms_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nyumbueg ngaim mati pre kin nyarimo wandoqi mindiny, di ni baj mitanyri. Di Yumbui pengu mindig kin tende puayi wand dobui nganye mand ei wute ruqond ningg mari ye. Wute men kin ye otiwo di ni mai quan nganye mare ye.” ");
INSERT INTO kms_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas God ningg baj pe yenu di nuqond wute wet bidi quan kin mandi nikin wet bidi Yumbui meng ningg God ningg baj pe kin wet bidi bokis pe mawo righe. Ni yenu te nuqond nuqond ");
INSERT INTO kms_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","di nyumbueg ire wundi nundoq. Nyumbueg te ngaim nati kin ni wet bidi segi ye ni wundo di wet bidi ambo ye woju teri wuwo righe. ");
INSERT INTO kms_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisas ni te nuqond di wute buagi simbe nindiny nari, “Nge nungoqi nganyene simbe guduq, wute ni ngaim nati di yumbo segi kin wen ni wet bidi quan nganye wet bidi bokis pe wuwo righe, di wute aye segi. ");
INSERT INTO kms_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wute buagi ren ni yumbo quan rise bu ninge ruwo righe di ninge nikin rise. Pudi nyumbueg wen ni wet bidi segi kin bu wet bidi ambo ye woju terine nikin mir wong wund ningg rise kin tene wuwo righe.” ");
INSERT INTO kms_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wute ninge God ningg baj te mundoq, wet yuwon yuwon pe yembe munduw, di yumbo God meng di yumbo tende pe God ningg baj yenji mipiq kin te muqond di wand wand yemu. Pudi Jisas nari, ");
INSERT INTO kms_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nge nungoqi simbe guduq, yumbo buagi muq ren rise wuqond kin ren otiwo wute mandi bir mawo di wet men mune iri aye nde wam nas wuqoind segi ye. Ni quan buagine bir ir maghe di kin kin mas ye.” ");
INSERT INTO kms_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Di ni Jisas pengu mindig mari, “Tisa, yumbo ren kin pughe puayi ei puq ren ye? Beghi yumbo ur pughe kin buqod ei nei bab yumbo ren kin puq ren yamb tumo?” ");
INSERT INTO kms_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Di Jisas ni oyi nari, “Nungoqi yeng wawo yuwon. Eti wute ninge mandi nungoqi wandoqi munduq di ni wand wutungu. Te pugri wute wandoqi kin nganye buagi nge nde nyamb pe mandi di mari, ‘Nge Kraist’ di mari, ‘Ngeri te tumo rind pre.’ Ni nungoqi pugri puq munduq, pudi nungoqi ni ningg wand wutungu di ninde dobu waru wayequ. ");
INSERT INTO kms_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Di qi puch aye pe opu yeng yumbui wes di mai yumbui nganye rindi kin wand wutungu, te nungoqi wune wamb wayequ. Yumbo ren kin ei ye ruwo ye, pudi qi nginy tu ane pre kin ngeri te tende puayine rindi segi ye. Yumbo ren kin puq ren pre dobu ei ngeri te kin rindi ye.” ");
INSERT INTO kms_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Muq simbe nindim nari, “Kantri ire mes mewo kantri aye ane mege, di king iri nikin wute ane mes mewo di king aye nikin wute ane mege. ");
INSERT INTO kms_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tende puayi di tiqe ninge pe te titwuye naghe di tiqe ninge pe te mir segi di num yumbui mare ye. Di woingo kin yumbo isis di yumbo ur gre ye nginy tu wam pu rindi ye. ");
INSERT INTO kms_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pudi yumbo buagi ren puq ren segine di ni nungoqi mutuqu wase, unje mupuqu mai isis meuq, di mitaqu God yumbui nyamb mirang kin baj pe mo kotim munduqu, di taq mumbuqu. Nungoqi nge ningg wute pugri bu ni nge nyamb brequ mindigh ningg mari di nungoqi mitaqu king di gavman kin yumbui nde mo, di ninde rar ngimi muaqu yequ. ");
INSERT INTO kms_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ni pugri puq meuq te nungoqi ninde wand bir wawo kin ngim muauq. ");
INSERT INTO kms_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ni nungoqi kotim munduqu di nungoqi oyi ni wand oyi wundim kin te ningg nei kumo wamb wayequ. ");
INSERT INTO kms_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Te pugri nge gri nungoqi nei yuwon ye keuq di nge gri nungoqi ni oyi wundim kin wand mim pe kuauq di nungoqi wand wand. Nungoqi oyi wand wand di wute nungoqi kotim munduqu kin te oyi nungoqi wand te oyi munduq kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nungoqi non nuyi numo, nuse niqam, yavi ire di nimand ni mune anene ei nungoqi veri nde si pe requ wondo, di ninge rumbuequ wati. ");
INSERT INTO kms_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nungoqi nge ningg wute pugri bu wute buagi nungoqi yambu mirequ. ");
INSERT INTO kms_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pudi nungoqi ngawu pe kin yu kimbi iri nganye ir no ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nungoqi buid wap di gre pu yequ tedi wati segi, was was te kin was. ");
INSERT INTO kms_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nungoqi wute yeng kin mandi Jerusalem quir quar munduw mondo mandi pu yemu wuqond te nungoqi nei wamb tiqe yumbui wen bir kin ngeri te tumo rind. ");
INSERT INTO kms_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Te muqdi wute Judia opu ris kin te wu rise rand pe ei riwo ruso. Di wute Jerusalem ris kin riyi rindi wu rise ruso, di wute tiqe ris segi dabo yeru kin mune tiqe rir ruso wayequ. ");
INSERT INTO kms_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Te pugri tende puayi te God wute ni ningg wand mutungu segi kin te oyi mai nem ye. Te pugri wand asi God ningg wand rise kin buk pe ur mand kin te nganyene ei puq ren ye. ");
INSERT INTO kms_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tende puayi nyumbueg wo ane ris kin di ninge ni wo wokuandi ne ris ye ni mai quan nganye rire ye. Te pugri tende puayi mai yumbui nganye ei qi pe wundi, di God ni umbo ker te oyi wute nde oyi nand ye. ");
INSERT INTO kms_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Veri wute te mambui riti di ninge mitari tiqe manyi aye pe opu te mo taq mamb pu yeru. Di wute aye Juda segi kin oyi Jerusalem nyinge muaq wughe ninde si nambu yequ ruso ruso otiwo God ni ngeri nipim ruso kin te prene.” ");
INSERT INTO kms_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas nari, “Otiwo ngeri tende di nginy pe, irew pe di tomnji pe yumbo ur gre ye isis ruwi. Di qi pe kin wute buagi nei kumo mamb di gherim seme yumbui gherim gug pe bir kus kuri kuri ye te ningg wune mamb di buyaq mand. ");
INSERT INTO kms_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wute buagi yumbo ur isis qi pe rindi ye te ningg quan nganye wune rimb di rar ori riti. Te pugri yumbo gre kin nginy tu pe kin tit rip ye. ");
INSERT INTO kms_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tende puayi di wute buagi qi pe kin ni wuti God nde pu nandi wuti nganye nas kin ni nikin gre di ti yumbui ane wuye quari wabe yenu di nandi kin te ruqoind. ");
INSERT INTO kms_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yumbo pugri kin puate ri righe wuqond te muqdi nungoqi wes wewo ngawu wundigi kuyo di wam rar wat. Nungoqi chumbuai wand, te pugri God nungoqi nitaqu wowi ye ngeri te rindi pre.” ");
INSERT INTO kms_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Muq Jisas ni kopuqu wand ven simbe nindim nari, “Nungoqi nyumo fig di nyumo buagi aye te wuqond. ");
INSERT INTO kms_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ni raqe uri rind buraq ri di mune muap rind wuqond, tedi nungoqi nei wamb te wuye wundi kin ngeri te muq tumo rind. ");
INSERT INTO kms_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Te kin pugrine nungoqi yumbo ur ren kin wuqond nungoqi nei wamb God king ningg nas di wute yumbo yumbo buagi ane ninde si nambu rise ye ngeri te tumo rind pre. ");
INSERT INTO kms_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nge nungoqi nganyene simbe guduq, wute tit muq ris kin ren ni riti segi, risne di yumbo te kin puq ren. ");
INSERT INTO kms_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nginy tu di qi ane ni pre ye, pudi nge wand te pre segi ye.” ");
INSERT INTO kms_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jisas mune nganye nikin wute simbe nindim nari, “Nungoqi yeng wawo yuwon. Eti nungoqi wuye kumo we di jebo wand. Di qi pe kin yumbo quan nganye nei wumbiny, tedi nungoqi nei yumbo pe tende rise, di Yumbui nandi kin nginy te nandi di nungoqi puye yis nireuq. Wapi yawi pe maghe kin pugri nungoqi puye yis nireuq, ");
INSERT INTO kms_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","di nungoqi sir wap segine. Te pugri nginy nen wute buagi qi pe kin ni ruqoind ye. ");
INSERT INTO kms_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Priprine nungoqi yeng wawo pu ei was. Di priprine God pengu wundig ei ni nungoqi gre neuq. Te ei nungoqi mai ren segine puaq wand, di wuti God nde pu nandi wuti nganye nas kin ni nde rar ngimi yequ kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nginy manyi Jisas no God ningg baj pe yenu wute wand bei neny, di bur ni no nyumo Oliv kin char iyu pe tende nase. ");
INSERT INTO kms_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Di quayi nyumbueg pripri burane nganye res riwo di ni ningg wand rutungu ningg God ningg baj pe tende rindi di ni ningg wand rutungu. ");
INSERT INTO kms_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Muq bret yis segi ye me kin ngeri te tumo rind. Ngeri yumbui te ni nyamb, God Israel mingg wo rar nuqond mas. ");
INSERT INTO kms_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Di prist mingg yumbui wute Moses ningg lo wute bei meny ye ane Jisas mi nati ningg. Te pugri ni wute buagi wune mimbiny pugri bu ni ngim meri mand. ");
INSERT INTO kms_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Muq Satan Judas, Iskariot puq mindig kin, ninde nandi. Judas ni Jisas ningg wute 12-pela ye te kin iri. ");
INSERT INTO kms_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Muq Judas prist mingg yumbui di wute God ningg baj yeng muaw ye yumbui ninde no, di ni pughe gri ei Jisas ninde si pe ni nondo ye te ningg wand taq mamb. ");
INSERT INTO kms_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wute te Judas ningg chumbuai nganye mand di mari ni Judas wet bidi pe wong maind ye. ");
INSERT INTO kms_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Di Judas ni wand mand ye te ningg ngiq nand di ni Jisas ninde si pe ni nondo ningg ngim meri nat. Ni ghimbi nawo otiwo wute quan buagi Jisas ane yeru segi, nikin irine yenu kin tende muqdi ni Jisas wute tende si pe ni nondo. ");
INSERT INTO kms_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Muq bret yis segi ye me kin mir yumbui yembe munduw ye nginy te nandi. Nginy te ningg di ni sipsip wo mi mati di me, di asi God Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny ye. ");
INSERT INTO kms_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pugri bu Jisas Pita Jon temi tiqi nundom nari, “Nungoqi wo mir yembe wundiny ei beghi mir bad di asi God Israel mingg wo rar nuqond mas kin ngeri te ningg chumbuai bad.” ");
INSERT INTO kms_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Di ni Jisas pengu mindig mari, “Te nu nei guab ye beghi muainde ei po mir te yembe bidiny ye?” ");
INSERT INTO kms_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Di ni simbe nindim nari, “Nungoqi nyinge ware tiqe war wo wo di wuti iri wuye os niraq nandi kin te wuqoind ye. Nungoqi wuti te wuqoind wuye os niraq ye nawo, di nungoqi ninde dobu waru waru di baj ni nar no ye te ningg war waru, ");
INSERT INTO kms_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","di baj kiyi te simbe wundig wari, ‘Tisa nu ningg nari, wute aye pe pu mandi ye mase kin sunyi muai bri? Ni di nikin wute ane tende ei mas mir mand di God Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny ye.’ ");
INSERT INTO kms_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pugri puq wand di ni sunyi yumbui ire nange yequ kin te ei bei nunduq ye. Sunyi tende mir pawo ris kin nyembe di pas kin sunyi rise pre. Nungoqi sunyi tende ei mir wawo.” ");
INSERT INTO kms_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Muq ni temi mo di yumbo yumbo buagi Jisas simbe nindim kin pugrine rise muqond. Di ni temi mir te yembe mindiny. ");
INSERT INTO kms_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ni pripri God Israel mingg wo rar nuqond mas ye mir te kin me ye te nginy naghe no pre ei mir te me ye. Pugri bu muq nginy naghe no pre bu Jisas nikin aposel ane mas ei mir mand ningg. ");
INSERT INTO kms_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Di ni nikin wute simbe nindim nari, “Nginy yumbui nen kin mir nge nungoqi ane pas mir bad yawo quan nganye kuregh. Te pre dobu muqdi nge yuqo kiraq. ");
INSERT INTO kms_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Te pugri nge nungoqi simbe guduq, nge nginy yumbui nen kin mir aye mune ke segi segine ruso ruso otiwo God ni king ningg nas di wute yumbo yumbo buagi ane ninde si nambu ris kin ngeri te rindi. Di mir wen yumbo ur bei wund kin te nganyene puq ren pre di nge mir wen kaq.” ");
INSERT INTO kms_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ni wain neti nowi, God chumbuai nindig pre di nari, “Nungoqi wain nen wait nase di puch puch we. ");
INSERT INTO kms_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Te pugri nge nungoqi simbe guduq, nge wain mune ke segi segine ruso ruso otiwo God king ningg nas pre di nge wain mune ke.” ");
INSERT INTO kms_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Di ni bret ire nitaqwi, God chumbuai nindig pre bir nuaq nem di nari, “Wen nge ghimbi. Nge nungoqi ghav guduq ningg bu mir kin pugri God geg. Pugri ei puq wen ei nge nei wumbigh.” ");
INSERT INTO kms_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ni mir mand pre, ni wain neti nowi di te kin pugrine mune puq nen di nari, “Kap wen nge wand urupui nungoqi ane taq bab ye. Nge ngening yavi nungoqi ghav guduq ningg ei groq gad di wand urupui taq bab. ");
INSERT INTO kms_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pudi wuti nge veri nde si pe ni godo kin te ni si nge te ane tebol ire pene pawo rise. ");
INSERT INTO kms_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nge, wuti God nde pu gadi wuti nganye kas kin, nge God asine ngim nipigh wuso pre kin te ningg ei ko ye. Pudi ni nge veri nde si pe ni godo kin wuti te nge yawo kutong, otiwo di ni mai yumbui niraq ye.” ");
INSERT INTO kms_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jisas ningg wute ni te mutungu nikinne oyi oyi pengu mand mari, “Wuti tughe ei pugri puq nen ye?” ");
INSERT INTO kms_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Muq Jisas ningg wute 12-pela pu te kin iri wuti tughe ei ninde yumbui nas ye te ningg kin kin mari. ");
INSERT INTO kms_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Di Jisas ni simbe nindim nari, “Wute Juda segi kin king ni yumbui mas di wute buagi ninde si nambu ris. Di wute nyamb ye buagi mari, ‘Nge wuti nyamb kin, nge wute yumbo keny.’ ");
INSERT INTO kms_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pudi nungoqi te kin pugri puq wen wayequ. Nungoqi kin wuti iri nyamb yumbui nganye kin nas, te ni wute nyamb segi ye mas kin pugri ei nas. Di wuti nungoqi nde ye nawo kin ni nungoqi ningg yembe ye wuti ningg ei nas. ");
INSERT INTO kms_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Te pugri qi pe kin yumbo ur taq pugri: wuti nasne di nikin yembe ye wuti te ni mir nirang nandi neng kin ni wuti yumbui, di wuti mir wase nawo ni nirang nandi kin wuti te ni yembe ye wuti. Pudi nge muq nungoqi ane pas kin te nge nungoqi ningg yembe ye wuti kin pugri kas. ");
INSERT INTO kms_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nge mai guqod kin tende nungoqi wutaqu nge nde dobu yequ ye. ");
INSERT INTO kms_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wuyi nge gre negh di nikin wute yumbo yumbo buagi ane nge nde si nambu rise ye te kin pugrine nge mune nungoqi gre keuq di wute buagi nungoqi nde si nambu ris. ");
INSERT INTO kms_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Te ei nungoqi nge nde si nambu was di nge mir ke kin tene nungoqi we di wuye nge ke kin te nungoqi mune we. Di sia king pe was di Israel kin wute tit 12-pela pu te nungoqi nde si nambu ris.” ");
INSERT INTO kms_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas nari, “Saimon, God Satan ngiq nindig pre, ni nungoqi wandoqi nundoq ye. Ni pugri puq nen ei ir nuaqu oghi kin kinne mas di brequ kin kinne mas. Wute wit ir mawo yi kinne mawo ris di dubu raqe ane memare ruso kin pugri. ");
INSERT INTO kms_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pudi Saimon, nge God nu ningg pengu gidig pre, te ei nu God nei gubig kin te si ghare segi. Di otiwo nu mune tindi guadi pre, te muqdi nu oyi nimand gre yem.” ");
INSERT INTO kms_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pudi Saimon oyi nari, “Yumbui, nge yeng kawo pune kas, nu taq maimb nge temu ane taq yembu, nu mi ghati nge mune katine.” ");
INSERT INTO kms_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Di Jisas Saimon oyi nindig nari, “Pita, nge nu simbe guduw, muq bur wapiqu nari segine di nu ghari nu nge nei gubigh segi puq ghand tevi ire pu ghand ye.” ");
INSERT INTO kms_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Muq Jisas ni pengu nindim nari, “Asi nge nungoqi tiqi gudouq wo kin tende nungoqi hanpaus, tami di sendel ware segine wo. Tende puayi nungoqi yumbo ninge segi bri?” Di ni mari, “Segi.” ");
INSERT INTO kms_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Muq ni simbe nindim nari, “Pudi muq nungoqi hanpaus rise te nungoqi warene, di tami rise te nungoqi warene. Di wuti tughe mame bidi dobui segi te nu chongo te yeq wundo wute aye wong mindiq di nu wet bidi te ghateri mame bidi dobui iri wong ghaind. ");
INSERT INTO kms_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Te pugri God ningg buk pe wand pugri ye ur pu rise, ni mari, ‘Quayi nyumbueg ni ruqoind kin ni wuti yumbo ur brequ mand kin iri.’ Nge nungoqi simbe guduq wand te kin muq nganyene nge nde puq ren ye. God ningg buk nge ningg wand simbe wund kin te muq nganye puq ren yamb.” ");
INSERT INTO kms_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Di nikin wute mari, “Yumbui, te qond, beghi mame bidi dobui temi men mase.” Di ni oyi nari, “Te tuqui.” ");
INSERT INTO kms_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Muq Jisas nikin wute ane pripri puq men kin pugrine mune Oliv kin char iyu pe mewo mo. ");
INSERT INTO kms_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ni mewo mo mitari righe di Jisas nikin wute simbe nindim nari, “Yumbui pengu wundig ei Satan nungoqi puamb nuauq, pudi ir waghe segi.” ");
INSERT INTO kms_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Di ni kring no nikin irine wonji pugri yenu. Ni wonji te wuti iri wet meneri di no ir naghe kin wonji pugri pe sungomyu sungomyu yenu di Yumbui pengu nindig nari, ");
INSERT INTO kms_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Wuyi nu nge mai wen puaq gudigh ningg te piyi puaq ndigh ei nge yuqo te kiraq segi. Pudi nge nde nei pe puq yen wayequ, nu non nde nei pene puq yen.” ");
INSERT INTO kms_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Muq wam kin angelo iri ninde nandi di ni gre neng. ");
INSERT INTO kms_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Di Jisas nei quan nganye mai viyo di ni Yumbui quan nganye pengu nindig, di ni tuw yavi kin pugri qi pe groq ri. ");
INSERT INTO kms_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisas Yumbui pengu nindig pre di nes newo nikin wute nde mune no, di nikin wute ruqo pu mase nuqond. Ni quan nganye yivany mare bu buid omo. ");
INSERT INTO kms_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Di ni nari, “Pughe kin ningg ruqo wase? Wes wewo di Yumbui pengu wundig wundig was ei te Satan nungoqi wandoqi nunduq kin te ningg ir waghe segi.” ");
INSERT INTO kms_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas wand nand nandne di wute tit mowi mandi. Di Judas ye nawo di wute te nitami nandi. Judas ni Jisas ningg wute 12-pela ye te kin iri. Muq Judas nyinge nare Jisas nde nandi ei song nireng ningg. ");
INSERT INTO kms_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pudi Jisas ni pengu nindig nari, “Judas, nu wuti God nde pu nandi wuti nganye nas kin te song gureg ei veri nde si pe kui nondo ningg bri? Te nu yumbo ur pugri kin pe bri nu veri nde si pe kui nondo ningg?” ");
INSERT INTO kms_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisas ningg wute ni ane mo kin te ni te muqond di mari, “Yumbui, beghi mame bidi dobui pe ni ane bege di bub pare mo bri?” ");
INSERT INTO kms_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Di iri mame bidi dobui naimb ni di prist mingg yumbui mingg yumbui ni ningg yembe ye wuti iri ange si tuan pe opu kin pend nuang ir wi. ");
INSERT INTO kms_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pudi Jisas ni oyi nindim nari, “Mune puq wen segi, prene!” Di ni wuti te ange puate niting wuse di mune oghi. ");
INSERT INTO kms_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Di Jisas prist mingg yumbui, wute God ningg baj pe yeng mawo ye yumbui, di quayi kiyi ni mait nase ningg mandi kin te simbe nindim nari, “Nge wute yeng kin bri kitami gadi bu nungoqi mame bidi dobui di yeng kin yumbo ane wandi? ");
INSERT INTO kms_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nginy manyi manyi nge nungoqi ane God ningg baj pe yembu, pudi nungoqi nge wait kase segi. Pudi muq nungoqi non ngeri, te bur kin ququ brequ ni king ningg nas.” ");
INSERT INTO kms_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Muq ni Jisas mait nase, mitanyi mo, di mo prist mingg yumbui mingg yumbui nde baj pe mar mo. Di Pita ninde dobu wonji wonjine naru. ");
INSERT INTO kms_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wute ninge baj te kin imb wabe wase muaq wughe di suqo mipiq mipiq mas. Pita ni naru pu te ane wase pe tende mas. ");
INSERT INTO kms_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yembe ye nyumbueg ire ni te nas wuqoind, di tumo gri otinde wuqoind di wuri, “Wuti nen Jisas ningg wuti iri.” ");
INSERT INTO kms_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pudi Pita segi puq nand nari, “Nge ni nei gibig segi.” ");
INSERT INTO kms_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mas musoq big rip pu wuti iri mune ni nuqoind di nari, “Nu mune ni ningg wutine qa iri.” Di Pita nari, “Segi, nge Jisas ningg wuti segi.” ");
INSERT INTO kms_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aua ire kin pugri wuso pre di wuti aye mune Pita ningg wand buid nap nari, “Nganyene nganye, wuti nen mune Galili kinne, pugri bu ni Jisas ningg wuti iri qa.” ");
INSERT INTO kms_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pudi Pita oyi nari, “Nu wand ven nge nei gab segi nganye!” Ni wand nand nandne di wapiqu nari. ");
INSERT INTO kms_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Di Yumbui tindi nandi, Pita nuqoind neri nase. Muq Pita Yumbui ni wand simbe nindig kin te nei nimbiny, “Muq bur wapiqu nari segine di nu ghari nu nge nei gubigh segi. Nu pugri puq ghand tevi ire pu ei ghand ye.” ");
INSERT INTO kms_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Muq ni raqe nar no di yumbui quanji nand. ");
INSERT INTO kms_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wute Jisas yeng muang kin ni Jisas perei mindig di pug mindig. ");
INSERT INTO kms_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ni chongo pe rar buag mirang pre muq pug mindig di pengu mindig mari, “Be nu propet kin pugri God nde pu nei ghatevi di simbe ghand, wuti tughe nu ni?” ");
INSERT INTO kms_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Di ni wand brequ isis mindig. ");
INSERT INTO kms_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yambgriq burane kaunsil mandi mikur. Kaunsil te quayi kiyi buagi, di prist mingg yumbui di wute lo wute bei meny ye. Ni mandi irepene mikur di Jisas mitanyi ninde mandi, ");
INSERT INTO kms_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","di ni Jisas pengu mindig mari, “Nu simbe ghand, nu Kraist, wuti God naip kuo wute kuateri ningg guadi ye te o aye?” Di Jisas oyi nari, “Nge nungoqi simbe guduq, pudi nungoqi nge wand te wutungu di nganyene puq wand segi. ");
INSERT INTO kms_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Di nge nungoqi te ningg pengu guduq, tedi nungoqi oyi wand yambu wari ye. ");
INSERT INTO kms_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pudi muq wuti God nde pu nandi wuti nganye nas kin ni God gre nganye kin ninde si tuan pe opu ei nas nas ruso ruso otiwo.” ");
INSERT INTO kms_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Muq ni buagi ane Jisas pengu mindig mari, “Te nu God ningg wo bu?” Di Jisas ni oyi nindim nari, “Nungoqi wari nge God ningg wo puq wand kin te tuquine.” ");
INSERT INTO kms_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Di ni mari, “Beghi mune wute ningg pari mandi di ni unje nap kin te simbe mand ningg pari wayequ. Beghi bon gri nikin nde mim pene putungu pre.” ");
INSERT INTO kms_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Muq kaunsil buagi ane mes mewo Jisas mitanyi Pailat nde mo. ");
INSERT INTO kms_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mo Pailat nde mo mar di Pailat simbe mindig mari, “Beghi wuti nen buqoid beghi wute nare nondo nandi. Ni wute Sisar nde takis wong rind kin te ningg segi puq nand, di nikinne nari ni Kraist, wuti God naip no wute nate ruwi ningg nandi ye. Te ni king iri.” ");
INSERT INTO kms_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Di Pailat Jisas pengu nindig nari, “Nu Juda mingg king bu?” Di Jisas oyi nand nari, “Nu kuari nge Juda mingg king te tuquine.” ");
INSERT INTO kms_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Muq Pailat prist mingg yumbui di wute buagi te rindi pu yeru kin te simbe nindiny nari, “Nge guqod kin wuti nen unje nap segi.” ");
INSERT INTO kms_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pudi ni quan nganye buid map mari, “Ni Judia kin tiqe buagi nar ir wute wand simbe nindiny, di ni nei unje nipiny pre. Ni Galili pune puate ni righe nandi nandi ven.” ");
INSERT INTO kms_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat ni pugri puq mand nutungu, di ni pengu nindim nari, “Wuti nen Galili kin bri?” ");
INSERT INTO kms_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat ni nutungu Jisas ni qi puch Herot nde si nambu yequ kin te pu nandi, di ni tiqi nundom Jisas mitanyi Herot nde mo. Tende puayi Herot mune nandi pu Jerusalem ne nas. ");
INSERT INTO kms_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot asi Jisas ningg wand nutungu, di ni Jisas nuqoind ningg nari, pudi nuqoind segi segine. Di ni Jisas nuqoind ei nikin nde rar pene Jisas yumbo ur gre ye ire bei nand nuqond ningg nari. ");
INSERT INTO kms_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pugri bu Herot Jisas wand quan pengu nindig. Pudi Jisas oyi ni wand ire oyi nindig segi. ");
INSERT INTO kms_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Di prist mingg yumbui di wute lo wute bei meny ye ni tumo mawi di taq maimb ningg wand buid nganye map. ");
INSERT INTO kms_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Muq Herot nikin ami ane Jisas wand brequ mindig di wur mang, di perei mindig. Di chongo yuwon ye ire mitaqwi, taq mimbig di mune tiqi mundog Pailat nde no. ");
INSERT INTO kms_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nginy te ningg Herot Pailat temi mawo gudo, asi ni temi veri. ");
INSERT INTO kms_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Di Pailat nari prist mingg yumbui, Juda kin nyamb ye di wute buagi rindi rikur, ");
INSERT INTO kms_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","di ni simbe nindiny nari, “Nungoqi wuti nen nge nde wutanyi wandi di wari ni quayi nyumbueg nei brequ neny di ni Rom ningg gavman nde si nambu ris yambu riri. Nungoqi yequ wuqond wuqondne qa nge ni pengu gidig. Nge ni otinde nganye pengu gidig, pudi nge guqod kin ni unje nap segi. Ni nganyene puq nen segi pu bu nungoqi taq waimb ningg wari. ");
INSERT INTO kms_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Di Herot mune nge nei gab kin pugrine nei namb, pugri bu ni Jisas tiqi nundog beghi nde mune nandi. Taq te wuqond, wuti nen yumbo ninge unje nap segi, pugri bu nge kari di ni mi nati ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Pugri bu nge kari di ni pugne mindig pre di si meri no.” ");
INSERT INTO kms_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Di wute buagi ane riri, “Wuti te wi nati, di Barabas ei si weri beghi nde nandi.” ");
INSERT INTO kms_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas ni taq maimb kin puate taq pugri: yeng ire Jerusalem tende wes di wute ninge mi mati. Te ni mari Barabas bu puq nen di wute te mati, pugri bu ni taq maimb pu yenu. ");
INSERT INTO kms_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat mune nganye wute simbe nindiny, ni Jisas si neri no ningg. ");
INSERT INTO kms_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pudi wute buagi ngam rire riri, “Kruse pe qungu wi nati! Kruse pe qungu wi nati!” ");
INSERT INTO kms_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailat miningne segi puq nand tevi nand pre, di muq mune nganye puq nand nari, “Pughe ningg? Ni mai pughe kin yembe nindiny? Nge guqod ni yumbo ninge unje nap tedi nge kari ni mi kin tuqui, pudi ni unje nap segi. Pugri bu nge kari ni pugne mindig pre di si meri no.” ");
INSERT INTO kms_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ni Jisas kruse pe qungu mi nati ningg quan kumo nganye ngam mare di wand buid map, di ni mari kin te Pailat ningg wand nyinge muang vighe. ");
INSERT INTO kms_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pugri bu Pailat ni mari kin pugrine puq nen ningg. ");
INSERT INTO kms_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Di ni wuti gavman nde yeng nindiqi wiyo di wute ni mati ye te ningg Rom gavman taq maimb pu yenu kin te ningg riri ye te si nireny nandi, di ni mari kin pugrine puq nen. Ni nari Jisas oyi mitanyi mo, nyumo pe qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rom kin ami Jisas mitanyi mo mo di wuti iri te Jerusalem nar no yamb nandi muqoind di mait nase di kruse Jisas niraq kin te mitaqwi, ni muang wughe niraq Jisas nde dobu naru. Wuti te ni nyamb Saimon, ni Sairini kin. ");
INSERT INTO kms_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Di wute nganye buagi nganye ninde dobu ruru. Di nyumbueg ninge ni ningg quanji rind di yivany kin yuwo riri kin ni wute buagi te ane dobu ruru. ");
INSERT INTO kms_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas tindi nandi, nyumbueg te simbe nindiny nari, “Jerusalem nyumbueg, nungoqi nge ningg quanji wand wayequ. Nungoqi non ninggne ei quanji wand, di nungoqi non wo ningg ei quanji wand. ");
INSERT INTO kms_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Te pugri otiwo di nungoqi wari, ‘Nyumbueg wo kimasi yeru kin, wute wo rire segine kin, di wute ni miny wo riq segine kin ni chumbuai rind.’ Pugri puq wand kin nginy te nandi ye. ");
INSERT INTO kms_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tende puayi di wute rand simbe rindim riri, ‘Bir ir wati, beghi buag wuramu.’ Di char iyu ningg riri, ‘Beghi imb wupumu.’ ");
INSERT INTO kms_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yumbo ren kin muq nyumo puayi urupui ne wuse kin pe puq ren kin te otiwo nyumo puayi quari wumb kin tende puayi di yumbo brequ nganye ei puq ren ye.” ");
INSERT INTO kms_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ni Jisas mitanyi mo di wute aye temi mune anene mitami mo. Ni temi yumbo ur brequ mand ye pugri bu mitami mo ei Jisas anene mi mati ningg. ");
INSERT INTO kms_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ni mandi mong puch Ngawu Ngape puq mindiny kin tende mi meyi, di ni Jisas kruse pe qungu mi nati. Di wute temi yumbo ur brequ mand kin te ane qungu mi nati. Iri Jisas nde si tuan pe opu qungu mi mati, di iri si qaqi pe opu qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Di Jisas nari, “Wuyi, nu ni wand puaq ndim, ni nei mamb segi yumbo te puq men.” Di ami ni wet wo map mewo di muqond wuti tughe maip no di Jisas ningg chongo ire nitaqwi. Ni pugri puq men di kin kin Jisas ningg chongo te mitangri. ");
INSERT INTO kms_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wute buagi te yeru ruqond ruqond di wute nyamb kin ni Jisas perei mindig mari, “Ni wute aye ghav nindiny ye, ni nganyene nganye Kraist, wuti God naip no ei ni ningg yembe nand ye, di God ningg wute nate mowi ningg tiqi nundog nandi ye, tedi ni nyumo te si neri nati ni.” ");
INSERT INTO kms_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Di ami mune pugrine mowi mi di perei mindig. Di wain jig meng, ");
INSERT INTO kms_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","di mari, “Nu nganyene Juda mingg king, tedi nu nyumo te si gheri ghati yi.” ");
INSERT INTO kms_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di wand puch ire ur mand nange gri teq mand viso mari, “Nen Juda mingg king.” ");
INSERT INTO kms_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wute brequ temi te Jisas ane qungu mi mati pu yemu ye te iri Jisas perei nindig nari, “Nu Kraist segi bri? Tedi nu nyumo te si gheri yaghe yo, di beghi anene ghav ndug.” ");
INSERT INTO kms_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pudi wuti brequ kin iri te ni ker nuang nari, “Nu God wune gubig segi bu? Beghi temu ire ane mai irene piraq. ");
INSERT INTO kms_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ni beghi temu mumbuemu pati, te ni tuquine puq men. Te pugri beghi temu beghi bon yumbo ur brequ bad kin te ane tuquine bu oyi mumbuemu pati ningg. Pudi wuti nen ni yumbo ur brequ ninge yembe nindiny segi.” ");
INSERT INTO kms_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Muq ni nari, “Jisas, nu king ningg kuas kin tende puayi nu nge nei mbigh.” ");
INSERT INTO kms_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Di Jisas ni oyi nindig nari, “Nge nu nganyene simbe guduw, muqne nu nge temu nginy tu wam God ningg wuny mbe pas.” ");
INSERT INTO kms_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Muq 12 kilok bogisumb kin pugri di nginy mune neyi segi, pugri bu tende opu buagi ane bur ir kuti, di bur te yengune ruso ruso 3 kilok yuram. Di chongo God ningg baj pe qungu muaw pu yequ kin te mingine bir wus bid teri. ");
INSERT INTO kms_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Di Jisas quan kumone ngam nare nari, “Wuyi, nge ququ nu nde si wam kuaw.” Ni puq nand di opu nati. ");
INSERT INTO kms_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ami kin yumbui ni pugri nuqond, di ni God nyamb nindivi viyo, di nari, “Nganyene qa, wuti nen tuquine nas ye.” ");
INSERT INTO kms_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Di wute buagi yumbo ren ruqond yamb rindi pu yeru kin te ni yumbo ur pugri kin ruqond, di quan nganye yivany rire, mand baq rind, di mune nikin nde baj pe ruso. ");
INSERT INTO kms_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pudi Jisas nikin kimand, di nyumbueg Jisas ane Galili pune rindi kin te ni kring rundone yeru, di yumbo yumbo buagi te puq ren kin te ruqond ruqond yeru. ");
INSERT INTO kms_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wuti iri ni nyamb Josep, ni tiqe ire Arimatea puq munduw kin te pu nandi kin. Tiqe te Judia opu yequ ye. Ni wuti tuquine nas ye, di God nei nimbig ye, ni God king ningg nas di yumbo yumbo buagi ninde si nambu rise ye ngeri te ghimbi nuany pu nas ye. Ni kaunsil te wand wand mare di Jisas nyumo pe qungu mi nati ye te kin iri, pudi ni kaunsil te ane wand taq mamb segi. Ni te ningg chumbuai nand segi. ");
INSERT INTO kms_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Muq ni no, Pailat pengu nindig ei Jisas neti nati neri no nowi yenu ningg. Di Pailat ni ngiq nindig. ");
INSERT INTO kms_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Muq ni Jisas nyumo pe pu neti nati, chongo quem ye pe wureq naimb, di neri no, ngamo ire rand sange pe wet pend mawo mar mo ye pe tende nowi yenu. Ngamo te ningg asi wuti iri mowi yenu segine ye. ");
INSERT INTO kms_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabat kin nginy te tumo nand bu nginy nen ni Sabat ningg sir map ye nginy. ");
INSERT INTO kms_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nyumbueg Jisas ane Galili pune rindi kin te ni Josep nde dobu ruru, di ngamo te rundoq, di Josep Jisas pughe gri ngamo pe nowi yenu kin te ruqond. ");
INSERT INTO kms_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ni te ruqond pre, di mune baj pe ruso di Jisas ghimbi wel ruang ningg wel tuqo yuwon kin riteruwi. Pudi Sabat kin nginy tende ni lo wuri kin pugrine ris yawotuan. ");
INSERT INTO kms_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nginy namba wan te ningg burane nganye nyumbueg te res ruyo wel tuqo yuwon kin keine ritemi pu mas kin te rire Jisas ningg ngamo pe ruso. ");
INSERT INTO kms_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ni ruso ngamo pe ritari righe, di ruqond wet yumbui ngamo tuq mimbiq kin te kring mipiq wuso pre. ");
INSERT INTO kms_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Di ni rir ruso, pudi Yumbui Jisas tende nase ruqoind segi. ");
INSERT INTO kms_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Di ni te ningg nei kumo rimb rimb yeru. Di wute temi ninde tumo te yemu ruqond. Wute temi te chongo quan nganye ti riri ye. ");
INSERT INTO kms_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ni te ruqond, di ni quan nganye wune rimb di yimb righe ni quenge righe ruso qi pe dung. Pudi wute temi te ni simbe mindiny mari, “Pughe ningg nungoqi wute mati kin mawo yemu ye ngamo pe wo di wuti urupui ne nas ye te meri wundig? ");
INSERT INTO kms_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ni ven nase segi, ni mune nes newo pre. Ni Galili ne nas di nungoqi wand te simbe nunduq kin te ei nei wumbiny. Wand taq ven, ");
INSERT INTO kms_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Wuti God nde pu nandi wuti nganye nas kin ni wute yumbo ur brequ mand ye ninde si pe mi nondo di kruse pe qungu mi nati. Di nginy temi mo pre aye ningg ni mune nes newo ye’.” ");
INSERT INTO kms_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Muq nyumbueg te Jisas ni asi simbe nand ye wand te nei rimbiny. ");
INSERT INTO kms_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Di ni ngamo te si riraq mune ruso, yumbo yumbo buagi ren ningg Jisas ningg wute 11-pela te simbe rindim, di wute buagi aye Jisas nde dobu ruwi ye te simbe rindiny. ");
INSERT INTO kms_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nyumbueg te wand ven rire ruso aposel simbe rindim kin wute taq, Maria Magdala kin te di Joana di Maria Jems kumo, di nyumbueg aye ni ane ruso kin te ane. ");
INSERT INTO kms_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aposel ni nyumbueg te simbe rindim mutungu, pudi ni mari nyumbueg ni wand nganye kin simbe rind segi. Pugri bu ni nyumbueg ningg wand te mutungu segi. ");
INSERT INTO kms_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pudi Pita nes newo di vig namb ngamo pe no. Ni no nitari righe, di yimb naghe ngamo pe rar neq wur wuso, di chongone rise nuqond. Di ni te ningg nei kumo namb namb mune baj pe no. ");
INSERT INTO kms_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nyumbueg Jisas ningg ngamo pe ruso kin nginy te ninggne Jisas ningg wute temi Jerusalem pu nyinge mare tiqe ire Emeus puq munduw kin tende mo ningg. Jerusalem pu tiqe tende mo kin te 11 kilomita kin pugri. ");
INSERT INTO kms_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ni temi ngimi nyinge mare mo di yumbo buagi te ningg kin kin wand wand mo. ");
INSERT INTO kms_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ni temi te ningg wand kumo mand di oyi oyi pengu mand mand nyinge mare mo mo di Jisas nikinne nandi di ni ane nyinge mare mo. ");
INSERT INTO kms_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ni temi Jisas muqoind pudi muqoind maip no tuqui segi. ");
INSERT INTO kms_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Di Jisas ni temi pengu nindim nari, “Nu tequ yumbo pughe kin wand bu wand wand nyinge ware wo?” Ni pugri pengu nindim di ni temi pugrine yemu, di ni quenge yivany gib mamb pu yemu. ");
INSERT INTO kms_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Di iri, ni nyamb Kliopas, ni Jisas oyi nindig nari, “Wute buagi tiqe manyi kin Jerusalem mandi kin ni nei mamb, nu irine bu tende puayi yumbo te puq ren kin te nei guab segi.” ");
INSERT INTO kms_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Di ni oyi pengu nand nari, “Yumbo pughe kin?” Di ni oyi oyi mindig mari, “Jisas Nasaret kin puq meng ye te kin wand. Ni propet iri. Di ni God nde rar pe di wute buagi nde rar pe yumbo ur gre ye yembe nindiny di wand gre kin simbe nand ye. ");
INSERT INTO kms_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Prist mingg yumbui di beghi wute nyamb kin ni Rom gavman kin yumbui nde mi nondo, di ni mi nati ningg ngiq nindim, di ami ni kruse pe qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pudi asi beghi nei bab kin pari wuti nen nganyene nganye God ni tiqi nundog wute Israel kin nate mowi ningg nandi ye. Di wand aye mune te pugri. Ni Jisas nde yumbo buagi ren puq men kin te nginy temi mo pre di muq nginy nen ane te nginy temi ire. ");
INSERT INTO kms_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Di muq beghi kin nyumbueg ninge beghi puye yis rirengu. Ni muq burane nganye res ruyo, Jisas ningg ngamo pe ruso, ");
INSERT INTO kms_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pudi ni Jisas tende nase ruqoind segi. Di ni munene rindi, di beghi simbe rundug riri ni angelo ninge ruqond, di ni simbe mindiny mari wuti te mune nes newo pre, di muq urupui nas. ");
INSERT INTO kms_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ni pugri simbe rind, di beghi kin wute ninge mune ngamo pe tende mo. Ni mo, di yumbo buagi nyumbueg simbe rind kin pugrine rise muqond, pudi Jisas muqoind segi.” ");
INSERT INTO kms_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Muq Jisas wute temi te simbe nindim nari, “Nungoqi tequ nei segi nganye. Propet mingg wand buagi te wutungu di brequne umbo pe wawo ris di wari wand te kin nganyene ei puq ren ye puq wand segi. ");
INSERT INTO kms_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kraist ni mai wen niraq pre dobu ei ni wam newo no, di God ningg ti pe nas kin te nungoqi nei wamb segi bri?” ");
INSERT INTO kms_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Di ni Moses ningg lo di propet mingg wand tende pu wand puate ni vighe, di wand buagi nikin ningg simbe mand ye God ningg wand rise kin buk buagi pe ur mand pu rise ye wand te kin puate simbe nindim. ");
INSERT INTO kms_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ni nyinge mare mo tiqe tumo mase mase di Jisas ni wandoqi nand ni tiqe aye pe no kin pugri puq nen, ei ni nei mamb ni tiqe tendene nas ningg nandi segi, ni aye pe no ningg. Ni yumbo ur te kin ngin namb, ");
INSERT INTO kms_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","pudi ni temi ni quan nganye segi puq mindig mari, “Yuram bur nganye, nginy naghe no pre tumo di bur ir kui yamb, pugri bu ghandi beghi ane po.” Muq ni nondo, ni temi ane mo mas. ");
INSERT INTO kms_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ni mir mand ningg chuchu mas, di Jisas anene mas. Di Jisas bret nitaqwi, God chumbuai nindig pre, bir nuaq, di ni temi bid bid nem. ");
INSERT INTO kms_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ni puq nen muq ni rar pend riti, di ni Jisas muqoind maip no. Ni muqoind maip no, di ni opu brequ sei maind no di mune nas muqoind segi. ");
INSERT INTO kms_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Di ni temi kin kin wand mand mari, “Beghi ngimi badi kin tende ni beghi ane wand bad di ni wand God ningg wand rise ye buk pe rise kin puate te simbe nand ye tende beghi nde umbo pe quan nganye yuwon rind.” ");
INSERT INTO kms_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Puq mand di opu mes mewo mune Jerusalem mo. Mo Jerusalem mitari righe, di Jisas ningg wute 11-pela pu te di wute buagi aye Jisas nde dobu ruwi kin te ane irepene rikur pu ris muqond. ");
INSERT INTO kms_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Di ni wute temi te simbe rindim riri, “Nganyene nganye! Yumbui mune nes newo pre. Ni Saimon nde raqe no, di Saimon ni nuqoind pre.” ");
INSERT INTO kms_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Di ni temi mune ngimi nyinge mare mare di Jisas ninde bre newo, di ane mo Emeus mas di ni bret bir nuaq nem di ni muqoind maip no ye te simbe mindiny. ");
INSERT INTO kms_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jisas ningg wute di wute buagi aye te ane te kin ningg wand wandne yeru di Jisas nikinne mune ninde mingine bre newo pu yenu, di ni simbe nindiny nari, “Nungoqi umbo yuwon gud.” ");
INSERT INTO kms_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pudi ni buagi ane puye rind di wune rimb. Ni nei rimb kin riri ni ququ bri ruqoind. ");
INSERT INTO kms_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Di Jisas ni simbe nindiny nari, “Pughe kin ningg nungoqi wune wamb di nei isis nungoqi nde nei pe rindi? ");
INSERT INTO kms_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nungoqi nge si wundogh di nyinge wundogh. Nge ningne nganye qa ven. Nge wait kase di wuqoind, nge som di ngape mboq rise. Ququ ni som di ngape mboq rise segi ye.” ");
INSERT INTO kms_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ni pugri simbe nindiny pre di ni si nyinge ane bei nindiny. ");
INSERT INTO kms_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ni quan nganye chumbuai rind, di nei kin kin rimb, pugri bu ni oghine nei rimb segine. Ni riri te nganye o wandoqi. Ni pugri nei rimb rimbne di ni pengu nindiny nari, “Nungoqi mir ninge rise?” ");
INSERT INTO kms_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Di ni umo req wughe nimbiq kin te bid ritaqwi reng. ");
INSERT INTO kms_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Di umo te nitiq wuse ninde rar pene naq. ");
INSERT INTO kms_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Di ni simbe nindiny nari, “Nge nungoqi ane pasne kin tende puayi nge nungoqi pugri simbe guduq kari, ‘Yumbo yumbo buagi nge ningg Moses ningg lo buk pe ur mand kin di propet ni buk pe ur mand kin di Buk Song pe ur mand kin yumbo yumbo buagi te nganyene ei puq ren ye’.” ");
INSERT INTO kms_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Muq ni nei bir nuany ei wand buagi God ningg buk pe rise ye te kin wand puate otinde nei rimbiny. ");
INSERT INTO kms_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ni simbe nindiny nari, “God ningg buk wuri ni Kraist mi nati ye. Pudi nginy temi mo pre, aye ningg di mune nes newo ye. ");
INSERT INTO kms_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Di ni ningg gre pe ei wute Jerusalem pe pu mo tiqe manyi mar ir wute nei rire ritinde ei God ni wand puaq nindiny ye te kin wand bir mawo. ");
INSERT INTO kms_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nungoqi ei yumbo ren puq ren ye te ningg wand simbe wand ye. ");
INSERT INTO kms_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Asi God nungoqi Ququ Yuwon Ye neuq puq nand kin te muqdi nge tiqi gudog nungoqi nde nandi ye. Pudi nungoqi aye pe wo wayequ, Jerusalem ne ei was was wam kin gre weti ni pre muqdi wo.” ");
INSERT INTO kms_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas nikin wute nitari no no Betani tumo di ni si nindigi kuyo di God pengu nindig ei God ni yuwon nuany ningg. ");
INSERT INTO kms_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ni yuwon nuany ningg si neny kuyo kuyone di God ni nitanyi nginy tu wam newo no, di ni si nare yeru. ");
INSERT INTO kms_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Muq ni sungomyu sungomyu yeru Jisas yumbui nyamb rirang. Muq ni quan nganye chumbuai rind rind di mune Jerusalem ruso. ");
INSERT INTO kms_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Di ni priprine God ningg baj pe ris God chumbuai rindig. ");
INSERT INTO kms_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Asi nganye qi di yumbo buagi qi pe kin rise segine wuti iri ni wand kin pugri puq mindig kin ni nas pre, ni God temi mas, di ni God ne. ");
INSERT INTO kms_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ni asine yumbo buagi rise segine kin tende puayine ni God temi mas. ");
INSERT INTO kms_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ninde gri God ni yumbo buagi yembe nindiny. God yumbo buagi yembe nindiny kin te wuti aye nde gri yembe nindiny segi. ");
INSERT INTO kms_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ninde gri wute mas, di ninde gri wute oghine muqond di burpoq pe mas segi. ");
INSERT INTO kms_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ni ti nase kin pugri priprine bur yengu pe ti nase, pudi wute yumbo ur brequ rind kin ni nei rimbig segi. ");
INSERT INTO kms_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God ni wuti iri Jon puq mindig kin tiqi nundog nandi. ");
INSERT INTO kms_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","8","Ni nikinne ti kin pugri segi. Ni wute ningg ti kin pugri ye te ningg simbe nand ningg bu nandi. Ni pugri simbe nand, ei te ninde gri wute buagi wuti ti kin pugri ye wand te rutungu di riri te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ti ningg simbe nand ye te ti nganye qi pe nandi, wute buagi qi pe kin ti nem. ");
INSERT INTO kms_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ninde gri God ni yumbo buagi qi pe kin yembe nindiny, di ni qi pe nandi, pudi wute qi pe kin ni ruqoind rip no segi. ");
INSERT INTO kms_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni nikin te wute ris pe nandi, pudi ni nikin te wute ni riti nowi segi. ");
INSERT INTO kms_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ninge ni riti nowi di nikin wand simbe nand kin te rutungu di riri nganyene puq rind kin ni puq neny di ni God ningg wo ningg ris. ");
INSERT INTO kms_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wo nikin kuqo mas rindi muq ni mas, o wute ni gri mari, o wuti iri ni ngam teri ningg wo kin pugri segi, pudi God ningg wo. ");
INSERT INTO kms_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wand ni muq wuti ningg nas, di beghi ane pas. Beghi ni ningg ti yuwon kin te buqod pre, ni God ningg wo irine nganye nas, pugri bu God ningg ti yuwon ye ni neng, di ni nikinne kiyi nde pu nandi, ni beghi yuwon nuangu, di wand nganyene kin ninde rise. ");
INSERT INTO kms_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ni ningg quan kumone simbe nand nari, “Wuti taq nen ningg bu nge asi kari, ‘Wuti iri nge nde dobune nandi kin ni quan nganye yumbui, te pugri ni nas pre muq nge kas’.” ");
INSERT INTO kms_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ni nikin nde nei pene beghi quan nganye yuwon nuangu kin te ningg ni beghi priprine yuwon nuangu. ");
INSERT INTO kms_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ni Moses nde gri beghi yumbo ur brequ bad segi ye lo te nengu. God ni wute yuwon nuany kin di wand nganyene kin Jisas Kraist nde gri rindi. ");
INSERT INTO kms_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wuti iri ni God nuqoind segine, pudi God ningg wo ni kiyi nde tumo yenu kin ni irine God raqe naind. ");
INSERT INTO kms_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon ni Jisas ningg wand simbe nand kin taq pugri. Juda ninge Jerusalem mas kin, ni prist di wute ninge wute tit Livai kin tiqi mundom mo Jon pengu mindig ei Jon nikin ningg simbe nindim. Tende puayi Jon nikin ningg simbe nindim. ");
INSERT INTO kms_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ni wand ninge suqo nare segi, pudi ni oghi pune simbe nindim nari, “Nge Kraist segi.” ");
INSERT INTO kms_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ni pengu mindig mari, “Te muq nu tughene? Nu Elaija kin pugri?” Ni nari, “Nge Elaija kin pugri segi.” Ni mari, “Nu propet iri beghi ghimbi buag kin te bri?” Ni oyi nindim nari, “Yewo.” ");
INSERT INTO kms_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Muq ni mari, “Nu tughene? Nu beghi simbe ndug, ei te beghi po wute beghi tiqi mundog badi kin te simbe bidim. Nu nu non ningg pughe puq guad?” ");
INSERT INTO kms_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ni propet Aisaia wand nand kin te kin pugrine ni wute te oyi nindim, “Wuti iri ni qi wuye di nyumo segi ye pe tende wand nand nari, ‘Yumbui ningg ngim ire tuquine waq.’ Nge wuti te.” ");
INSERT INTO kms_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Muq Parisi ninge tiqi mundom Jon nde mo ye te Jon pengu mindig, ");
INSERT INTO kms_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Te muq nu kuari nu Kraist segi, di nu Elaija kin pugri segi, di nu propet iri beghi ghimbi buag kin te segi, pudi pughe kin ningg nu wute wuye kuap?” ");
INSERT INTO kms_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon oyi nindim nari, “Nge wuye nganye pe wute wuye kap. Pudi nungoqi wuti iri nungoqi ane yequ kin te nei wumbig segi. ");
INSERT INTO kms_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ni nge nde dobune nandi, di nge wuti oghi nganye segi pugri bu nge ni sendel ir guag kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yumbo ren te tiqe ire Betani puq munduw kin ni Jordan pu nginy nawi opu Jon wute wuye nap kin tende puq men. ");
INSERT INTO kms_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nginy aye ningg Jon ni Jisas ni nde tiq nyinge nare nandi kin te nuqoind di nari, “Te wuqond. Wute mai puaq nindim kin sipsip wo God te ni wute buagi qi pe kin mai puaq nindim! ");
INSERT INTO kms_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wuti taq nen ningg bu nge kari, ‘Wuti iri nge nde dobune nandi kin ni quan nganye yumbui, te pugri ni nas pre muq nge kas.’ ");
INSERT INTO kms_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nge ngeningne ni nei gibig segi. Pudi nge gadi wute wuye pe wuye kap ei Israel kin buagi ni nei rimbig.” ");
INSERT INTO kms_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Muq Jon ni wand ren simbe nand, “Nge Ququ Yuwon Ye wapi mabri kin pugri guqoid guqoidne nginy tu pe gri nandi, ni nde nas. ");
INSERT INTO kms_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nge ngeningne wuti nen nei gibig segi, pudi wuti nge tiqi nundogh gadi ei wute wuye pe wuye kap ye ni asi nge simbe nindigh nari, ‘Wuti nu Ququ Yuwon Ye qoind qoindne nati ni di ni nde newo nas kin ni Ququ Yuwon Ye pe wute wuye nap ye.’ ");
INSERT INTO kms_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nge te guqod di nge te ningg simbe gad pre, te pugri wuti nen ni God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nginy aye ningg Jon di nikin te wute temi ane sunyi tendene mune yemu. ");
INSERT INTO kms_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jon rar neq wuso, Jisas ni yemu pe tumone nandi nuqoind, muq nari, “Te wuqond. God ningg sipsip wo.” ");
INSERT INTO kms_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Muq Jon ningg wute temi te mutungu di mondo Jisas nde dobu maru. ");
INSERT INTO kms_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas tindi nandi, ni temi dobu maru kin te nuqond, di pengu nindim, “Nungoqi pughe kin ningg wandi?” Ni mari, “Rabai, nu muainde pe bu kuas?” (Wand puch Rabai kin puate taq pugri, wuti wand wute bei neny ye.) ");
INSERT INTO kms_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisas oyi nindim nari, “Nungoqi wandi, di nge kas kin te wuqond.” Te 4 kilok yuram kin pugri. Muq ni maru di Jisas nas kin sunyi te muqond, di nginy te ningg ni Jisas ane mas ruso burpoq rip. ");
INSERT INTO kms_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru, Saimon Pita ni kiqam, ni wute temi te kin ye iri. ");
INSERT INTO kms_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ni brequne no kise Saimon meri niting nuqoind, di simbe nindig, “Beghi Mesaia buqoid pre.” (Mesaia te Kraist.) ");
INSERT INTO kms_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Di ni Saimon nitanyi Jisas nde nandi. Jisas rar neq wundo nuqoind nari, “Nu Saimon Jon ningg wo. Nu muqdi Sipas puq buduw.” (Sipas nyamb ven te Pita kin pugri, di ni puate te wet nyaw.) ");
INSERT INTO kms_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nginy aye ningg Jisas ni Galili no ningg. Ni Pilip nuqoind, simbe nindig nari, “Ghandi nge nde dobu ghawi.” ");
INSERT INTO kms_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip, Andru di Pita ni tiqe irene, Betsaida kin. ");
INSERT INTO kms_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip ni Nataniel nuqoind di simbe nindig, “Beghi wuti te Moses ni lo buk pe ni ningg ur nand kin, di propet anene ni ningg ur mand kin te buqoid pre. Ni Jisas, Nasaret kin, Josep ningg wo.” ");
INSERT INTO kms_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel pengu nand, “Nasaret! Mari bri yumbo oghi kin ninge Nasaret pu rindi?” Muq Pilip oyi nand nari, “Ghandi di qond.” ");
INSERT INTO kms_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisas ni Nataniel ni nde tumo nondo kin te nuqoind, simbe nand nari, “Wuti nen ni Israel kin nganye, ni wute wandoqi nindiny segi ye.” ");
INSERT INTO kms_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel Jisas pengu nindig, “Pughe gri ate nu nge nei gubigh?” Jisas oyi nindig nari, “Nu nyumo fig nambu kuar pu yengu kin tende puayi nge nu guqoid pre, muq Pilip nu ningg nari guadi.” ");
INSERT INTO kms_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Muq Nataniel simbe nand nari, “Tisa. Nu God ningg wo, di Israel mingg king.” ");
INSERT INTO kms_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Muq Jisas nari, “Nge kari nu nyumo fig nambu kuar kuas kin te nge nu guqoid pre puq gad kin te ningg bri nu nge nei gubigh? Nu segine yumbo yumbui nganye, ren ane tuqui segi kin te qond. ");
INSERT INTO kms_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nge nungoqi nganyene simbe guduq, nungoqi nginy tu ngim bi wuso kin te wundoq, di God ningg angelo wuti God nde pu nandi wuti nganye nas kin ni nde mati mi di mewo mo kin te wuqond.” ");
INSERT INTO kms_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jisas ni Pilip Nataniel temi ningg nari di ni nde dobu maru kin tende puayi nginy temi mo pre aye ningg di tiqe ire Kana Galili opu yequ kin tende wute ngam ruso kin te ningg mir yembe mindiny. Jisas kumo ni anene tende wus, ");
INSERT INTO kms_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","di Jisas ni nikin wute te anene mari mondo ei ane mir mand. ");
INSERT INTO kms_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ni mir mand mandne mas wain omo, di Jisas kumo wundo Jisas ningg wuri, “Ni wain omone.” ");
INSERT INTO kms_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisas oyi nand nari, “Nyumbueg, nu pughe kin ningg nge ningg kuari? Nge ren kin puq ken kin ngeri te muq segine.” ");
INSERT INTO kms_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Di ni kumo wundo mir te kin yembe ye wute te simbe wundim wuri, “Ni pughe puq nand tedi nungoqi pugrine ei puq wen.” ");
INSERT INTO kms_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ni ris kin tumone tende os wet pe yembe mindiny kin 6-pela pu wuye mat kin te yeru. Os ren kin te Juda nikin mir yembe mindiny kin tende puayi ei os te kin pe wuye mat di maghe. Os ren kin te wuye 100 lita kin pugri tende mawo kughe. ");
INSERT INTO kms_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas ni wute mir te kin yembe ye wute te simbe nindim nari, “Nungoqi os tende pe wuye wawo righe.” Pugri bu ni mo os tende pe wuye mawo righe righe brene. ");
INSERT INTO kms_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Muq ni simbe nindim nari, “Muq musoq wat, groq wand kuso, di ware wo, wuti mir wen ningg ye nawo kin te weng.” Ni Jisas nari kin pugrine puq men, ");
INSERT INTO kms_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","di wuye tinde kuso wain kuse kin te mare mo, wuti mir te ningg ye nawo kin te meng ei te ni puch ne, nuqond, oghi bri. Ni wain mait meri mandi kin sunyi te ni nei namb segi, pudi nikin ningg yembe ye wute ni mo wuye mat ye ni nei mamb. Muq ni wuti urupui ngam no kin te ningg nari nandi, ");
INSERT INTO kms_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","di simbe nindig nari, “Wute nganye buagi ni pripri wain oghi kin wute meny riq, di otiwo ni quan nganye riq pre tende dobu muqdi oghi segi kin te mune meny riq. Pudi nu wain oghi ye kuowi nas nas rindi muq.” ");
INSERT INTO kms_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yumbo ur gre kin ren te Jisas ni Kana Galili opu tende puate ni righe. Ni ti yuwon kin te bei nand, di nikin wute ni yumbo ur te muqond di ni nei mimbig. ");
INSERT INTO kms_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jisas ni wute ngam ruso ningg mir yembe mindiny kin te ane mir rind pre tende dobu ni nikin kumo, di kiqam, di nikin wute ane tiqe ire Kaperneam puq munduw kin tende righe ruso, di nginy ninge ni tende ris. ");
INSERT INTO kms_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","God asi Israel mingg wo rar nuqond mas ye te nei mimbiny kin ngeri te tumo rind rind kin tende puayi Jisas Jerusalem newo no. ");
INSERT INTO kms_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","God ningg baj kin imb wabe tende wute ninge nuqond ni kau, sipsip di wapi mabri mare mandi tende mawo yeru ei te wute mandi wong mand. Di wute ninge nyembe pe mas ei wute Rom mingg wet bidi rire rundo, tedi ni rem di ni oyi Juda mingg wet bidi meny. Ni te mas nuqond. ");
INSERT INTO kms_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pugri bu ni tamb pe yas iri yembe nindig, di kau di sipsip te quan buagine God ningg baj pe pu bub nare ruso. Ni wute ninge nyembe pe mas kin te nyembe groq nindim, di wet bidi priq ire ire ruso. ");
INSERT INTO kms_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ninge wapi mabri mawo kin te simbe nindim nari, “Nungoqi yumbo ren ware wo! Nge wuyi ningg baj maket kin pugri puq wew wayequ!” ");
INSERT INTO kms_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ni pugri puq nen di nikin wute wand buk pe rise kin te nei mimbiny, “Nge nu baj wen quan nganye nei gubuw ye te ningg nge kati ye.” ");
INSERT INTO kms_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Muq Juda mingg wute nyamb kin Jisas ningg mari, “Nu yumbo ur gre kin pughe ye beghi bei gudug ei beghi nei bab nu yumbo ren puq kuen kin gre rise.” ");
INSERT INTO kms_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Di Jisas oyi nindim nari, “Nungoqi God ningg baj wen bir waq te nge segine nginy temi ire ninggne mune yembe guduw ye.” ");
INSERT INTO kms_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Muq Juda mingg wute nyamb kin oyi mari, “God ningg baj wen ber 46-pela pre bu omo muaq, di nu kuari nu nginy temi ire ninggne mune yembe guduw?” ");
INSERT INTO kms_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas God ningg baj bir muaq pre nginy temi ire ninggne mune yembe nunduw puq nand kin te nikin ghimbi ningg nari. ");
INSERT INTO kms_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ni nati pre mune nes newo kin tende dobu nikin wute ni wand nand kin ren nei mimbiny. Muq ni wand buk pe vise kin di wand Jisas simbe nand kin te nei mimbiny mari te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Muq ni God asi Israel mingg wo rar nuqond mas kin te nei mimbiny ningg Jerusalem mas kin tende puayi di Jisas ni yumbo ur gre ye isis bei nand, di wute nganye buagi Jisas nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pudi Jisas wute buagi nei nundony pre, pugri bu ni nikin ningg wand raqene simbe nand segi. ");
INSERT INTO kms_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni nei nundony pre, pugri bu wute ninge wute aye ningg wand ni simbe rindig ningg nari segi. ");
INSERT INTO kms_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Muq Parisi kin wuti iri ni nyamb Nikodemus ni Juda mingg wuti nyamb kin iri. ");
INSERT INTO kms_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ni burpoq pu Jisas nde nandi, di nari, “Tisa, beghi nei bab nu wuti God ningg wand wute bei kueny ye nu God ningg wand kuare guadi. Te pugri wuti iri God ningg Ququ ni nde nas segi, tedi nu yumbo ur gre ye bei guad ye ren kin ni puq nen tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas oyi pugri simbe nindig, “Nge nu nganyene simbe guduw, nu mune wokuandi ghase tedi God nde si nambu ghas.” ");
INSERT INTO kms_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus nari, “Pughe gri ei wuti iri gang nase pre mune wokuandi nase? Ni mune kumo nde umbo pe nar no pre munene wuri wundi kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas oyi nand nari, “Nge nu nganyene simbe guduw, wuti iri ni God nde si nambu nas tuqui segi, pudi ni mune wokuandi kin pugri nas, yumbo ur brequ si nare, di wuye Ququ Yuwon Ye ane pe wuye maip, tedi ni God nde si nambu nas kin tuqui. ");
INSERT INTO kms_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kiyi kumo ane wuti riri rindi kin te ni ghimbi wuse, pudi God ningg Ququ ni nei neng di nei urupui ni nde vise. ");
INSERT INTO kms_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nu nge puq gad kin te ningg puye ghand wayequ, ‘Nu mune wokuandi ghase.’ ");
INSERT INTO kms_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nyumurighi ni nikin nde nei pe naghe. Nu qurur tungu, pudi nandi no kin sunyi te nei ghamb tuqui segi. Ququ Yuwon Ye ni wute nei urupui nem kin te nyumurighi kin pugri.” ");
INSERT INTO kms_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus pengu nand, “Ren kin te pughe gri ei?” ");
INSERT INTO kms_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas oyi nindig nari, “Nu Israel mingg tisa, pughe gri bu nu yumbo ren kin nei gubiny segi? ");
INSERT INTO kms_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nge nu nganyene simbe guduw, beghi yumbo nei bibiny kin te ningg wand bad, di yumbo buqod kin te ningg simbe bad, pudi nungoqi beghi simbe bad kin te wutungu yambu wari. ");
INSERT INTO kms_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nge yumbo qi pe kin ningg simbe guduq di nungoqi wari te nganye puq wand segi. Muq nge nginy tu pe kin yumbo te ningg simbe gad, tedi nungoqi wari te nganye puq wand kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wuti iri God ningg tiqe pe no segine, pudi wuti God nde pu nandi wuti nganye nas kin ni irine God nde tiqe pe nar no. ");
INSERT INTO kms_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses ni qi wuye di nyumo segi ye pe tende ghati nindingi newo kin pugrine wuti God nde pu nandi wuti nganye nas kin ni wundingi newo no, ");
INSERT INTO kms_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","te ei wute ni nde gri God nei rimbig kin ni ris ris te kin ris ye. ");
INSERT INTO kms_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Te pugri God ni wute qi pe kin quan nganye yawo nirany righe kin te ningg nikin wo irine nganye nas kin te neny, ei te wute ni wo te nei rimbig kin ni riti segi pudi ris ris te kin ris ye. ");
INSERT INTO kms_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Te pugri God ni wo tiqi nundog qi pe nandi ye ni wute ir nawo ningg nandi segi, pudi ni nde gri God ni wute nate ruwi ye. ");
INSERT INTO kms_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wute ni nde gri God nei rimbig kin ni yembe neny segi, pudi ninge ni nde gri nei rimbig segi kin God ni yembe neny puq nand pre, te pugri ni God ningg wo irine nganye ni nde nyamb pe God nei rimbig segi. ");
INSERT INTO kms_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God nari wute unje rip puq nand kin puate taq pugri: Wute mingg ti kin pugri ye te qi pe ven nde nandi pre, pudi wute ti kin pugri ye te si meri, di ni burpoq pe mas yawo kurem, te pugri ni yumbo yembe mindiny kin te brequ. ");
INSERT INTO kms_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wute buagi yumbo ur brequ rind kin ni ti kin pugri ye te yambu rireng, di ni nde rindi segi, te pugri ni wune rimb, eti ni yumbo ur brequ rind kin te raqe ruso. ");
INSERT INTO kms_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pudi wute ninge wand nganyene kin rutungu ye ni ti kin pugri ye ninde rindi, ei te ni oghine ruqond ni yumbo yembe rindiny kin te God nari kin pugrine yembe rindiny.” ");
INSERT INTO kms_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jisas Nikodemus temi wand mand pre, Jisas di nikin wute ane Jerusalem si miraq, mo tiqe Judia opu yeru kin tende mo ei nginy ninge ni wute te kin ane ris, di ni wuye nap. ");
INSERT INTO kms_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon ni Ainon tiqe ire Salim tumo yequ kin pe tende wute wuye nap, te pugri mong tende wuye quan rise, di wute priprine rindi ei ni wuye nap ningg. ");
INSERT INTO kms_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Tende puayi Jon ni taq yenu segine.) ");
INSERT INTO kms_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Muq Jon ningg wute di Juda kin wuti iri ane wute wuye map ye te ningg ker mawo. ");
INSERT INTO kms_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jon ningg wute Jon nde mandi di mari, “Tisa, wuti nu tequ Jordan pu ruso ruwo opu gri yequ kin, wuti te ningg nu simbe guad kin te, ni wute wuye nap, di wute buagi ni nde ruso.” ");
INSERT INTO kms_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ni te kin ningg oyi nand nari, “Wuti segine yumbo God nde pu rindi kin nate ruwi. ");
INSERT INTO kms_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nungoqi nonne segine nge wand gad kin te wutungu di nei wamb, ‘Nge Kraist segi, pudi nge ye kawo gadi di ni nawi.’ ");
INSERT INTO kms_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Wuti iri ni ngam nitaqi, tedi nyumbueg te ni te. Wuti aye te segi. Wuti te ni kimand nandi, ni nde tumo yenu, ni gibe ko nutungu di te ningg ni chumbuai nand. Te kin pugrine nge muq quan nganye chumbuai gad. ");
INSERT INTO kms_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni ei wute quan ni nde maru, nge nde oyi musoqne mandi. ");
INSERT INTO kms_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Wuti wam pu nandi kin ni yumbo buagi qi pe kin di wam kin ningg yumbui, wuti qi pe gri nandi kin ni qi pe ye, di ni qi pe kin yumbo te ningg wand nand. Wuti nginy tu wam pu nandi kin ni yumbo buagi qi pe kin di wam kin ni yumbui. ");
INSERT INTO kms_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ni yumbo nuqond di nutungu kin te ningg simbe nand, pudi wute ni simbe nand kin te rutungu segi. ");
INSERT INTO kms_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ninge rutungu ye ni te kin ningg God ningg wand te nganyene puq rind ye. ");
INSERT INTO kms_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Te pugri God wuti tiqi nundog nandi ye te Ququ musoq musoq neng segi, pugri bu ni God ningg wand simbe nand. ");
INSERT INTO kms_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","God ni wo quan nganye yawo nirang righe, di yumbo buagi ni nde si pe ni rundo. ");
INSERT INTO kms_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wute ni wo nei rimbig ye ni ris ris te kin ris, pudi ninge ni wo nari kin pugrine puq ren segi ye ni ris ris te kin ris segi, te pugri God ni ker nuany di ni mai te wuse wuse te kin wuse ye.” ");
INSERT INTO kms_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi ninge ni wute quan Jisas nde ruso ni wuye nap di Jon ni musoqne wuye nap kin te mutungu. ");
INSERT INTO kms_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","3","Muq Yumbui ni puq mand kin te nutungu, di ni Judia si niraq, munene Galili no. Pudi yumbo nganye Jisas ni wute wuye nap segi, pudi nikin wute ni oyi wute wuye map. ");
INSERT INTO kms_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Muq ni Galili no ningg tedi ni Samaria gri ei no ye. ");
INSERT INTO kms_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pugri bu tiqe ire Sikar puq munduw kin ni Jekop ningg qi puch ire ni wo Josep neng ye tende tumone yequ kin tende nandi. ");
INSERT INTO kms_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekop ningg wuye ghar tende nase. Muq 12 kilok kin pugri di Jisas wonji pu nandi kin te ningg ni buid omo, bu wuye ghar pe tende nas. ");
INSERT INTO kms_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Muq Jisas nikin wute ni mir wong mand ningg tiqe pe mo pu yemu. Di nyumbueg Samaria kin ire wuye wut ningg wundi, di Jisas nyumbueg te ningg nari, “Nu nge wuye mune yegh ke.” ");
INSERT INTO kms_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nyumbueg Samaria kin ni Jisas ningg wuri, “Nu Juda kin di nge Samaria kin. Pughe kin ningg nu nge wuye kew ningg kuari?” (Te pugri Juda ni Samaria ane irepe mawo gudo segi.) ");
INSERT INTO kms_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas oyi nunduw nari, “God otiwo nungoqi yumbo neuq ye puq nand kin te di nu wuti muq wuye ningg pengu guduw kin te nei guab, tedi nu ni pengu ndig di ni oyi wuye nu ye di ghati segi kin te new.” ");
INSERT INTO kms_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nyumbueg te wuri, “Yumbui, wuye ghar nen naghe nganye no, di nu wuye ghat kin yumbo segi. Nu wuye pe di pati segi kin te muai nde pu ei kuate kuwi? ");
INSERT INTO kms_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Beghi koku Jekop ni wuye ghar nen neti nowi, di ni nikin wo ane wuye kuen me. Di ni kau sipsip ane wuye kuen riq. Nikin wuye ghar nen nase nase rindi muq beghi mune wuye kuen ne pe. Nu muq quan nganye yumbui di ni segi bri?” ");
INSERT INTO kms_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas oyi nunduw nari, “Wute wuye kuen me ye, ni mune yawo singar mati ye, ");
INSERT INTO kms_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pudi wute wuye nge kem kin te me ye, ni mune yawo singar mati tuqui segi. Te pugri wuye nge kem kin te ni nde wuye qi pe kuyi kin pugri kuyi kuyi kuse di te kin ningg ni mati segi, mas mas te kin mas.” ");
INSERT INTO kms_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Muq nyumbueg te Jisas ningg wuri, “Yumbui, nge wuye te kin yegh, ei te nge munene yawo singar kati segi, di priprine wuye kat ningg ven nde gadi segi.” ");
INSERT INTO kms_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisas simbe nunduw nari, “Yo, nungaim simbe ndig, di ane mune wandi.” ");
INSERT INTO kms_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nyumbueg te oyi wund wuri, “Nge ngaim segi.” Muq Jisas nari, “Nu kuari nu nungaim segi ye puq guad kin te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yumbo nganye taq pugri, nu asi nungaim 5-pela pu mas, di wuti muq nu tequ was kin ni nu nungaim segi. Nu mining puq guad kin te nganyene.” ");
INSERT INTO kms_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nyumbueg te wuri, “Yumbui, nge nei gab kin te pugri nu propet iri. ");
INSERT INTO kms_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Beghi koku ni rand pe ven nde God yumbui nyamb mirang, pudi nungoqi Juda pugri puq wand wari beghi Jerusalem ei God yumbui nyamb birag.” ");
INSERT INTO kms_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Muq Jisas simbe nand nari, “Nge wand gad kin ren ei nei mbiny, ngeri ire wundi ye tende di nungoqi rand pe ven nde o Jerusalem pe wuyi yumbui nyamb wurang segi. ");
INSERT INTO kms_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nungoqi Samaria kin nungoqi yumbo nei wumbiny segi kin te yumbui nyamb wurany, pudi beghi Juda kin beghi wuti nei bibig kin te yumbui nyamb birag, te pugri God ni wute qi pe kin nate ruwi kin te Juda ni te kin ningg simbe mand. ");
INSERT INTO kms_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ngeri ire ghimbi puany ye, muq wundi pre, di wute nganyene wuyi yumbui nyamb rirang kin ni ququ pe gri di ni God yumbo ur yuwon ye rise kin pugri ei yumbui nyamb rirang. Te pugri wute God yumbui nyamb rirang kin ni wuyi pugri ei yumbui nyamb rirang ningg nari. ");
INSERT INTO kms_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God ni ququne, di ni ningg ququ nde gre pe ei wute ni yumbui nyamb rirang di ni God yumbo ur yuwon ye rise kin pugri ei yumbui nyamb rirang.” ");
INSERT INTO kms_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Muq nyumbueg te wuri, “Nge nei gab Mesaia nandi ye. Otiwo ni nandi di yumbo buagi ren ningg simbe nundug ye.” (Mesaia, te Kraist kin pugrine, di ni teri puate irene.) ");
INSERT INTO kms_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Muq Jisas simbe nand nari, “Nge nu temu wand bad kin nge wuti te.” ");
INSERT INTO kms_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas nyumbueg Samaria kin te teri wand wandne yeru muq nikin wute mir wong mand ningg mo pre mune mandi, di Jisas nyumbueg te teri wand wand yeru muqond, te ningg ni puye mand. Pudi ni pengu mand mari, “Nu pughe ningg kuari?” o “Nu pughe ningg nyumbueg te tequ wand wand?” ni pugri puq mand segi. ");
INSERT INTO kms_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Muq nyumbueg te wuye os te si wuraq wus, munene tiqe wuso di wute buagi tiqe pe kin te ningg wuri, ");
INSERT INTO kms_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nungoqi wandi, wuti iri nge asi yumbo yembe gidiny ye te simbe nindigh omo kin nen wuqoind. Wuti nen Kraist bri?” ");
INSERT INTO kms_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ni quan buagine tiqe pe pu riyi ri di Jisas nde rundo. ");
INSERT INTO kms_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wute buagi rundo segine Jisas nikin wute ni ningg mari, “Tisa, be mir ghand.” ");
INSERT INTO kms_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pudi Jisas oyi simbe nindim nari, “Nge mir te nungoqi nei wamb segi.” ");
INSERT INTO kms_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Muq nikin wute te mutungu di oyi oyi pengu mand mari, “Wute ninge mandi, mir meng ne pu bri?” ");
INSERT INTO kms_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisas oyi nindim nari, “Nge mir taq wuti nge tiqi nundogh gadi kin ni nari ye yembe te yembe gidiny di omone ei kawo. ");
INSERT INTO kms_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nungoqi wand ire wutungu mari, ‘Irew 4-pela pre di mir bi pawo.’ Nge nungoqi simbe guduq, rar wat wuny te wuqond, ni nguan pre pu rise. ");
INSERT INTO kms_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muq wuti mir bi nawo ye God ni wong naind. Muq ni wute mas mas te kin mas kin te ningg mir bi nawo, ei te wuti mir ni righe kin di wuti mir bi nawo kin anene chumbuai mand. ");
INSERT INTO kms_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wand puch ven, ‘Wuti iri mir ni righe, di iri mir bi nawo’ ye te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nge nungoqi tiqi gudoqu wo yumbo nungoqi wi righe segi kin te bi wawo. Aye ni yembe yumbui mand, di nungoqi ni yembe mand kin te ei bi wawo.” ");
INSERT INTO kms_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nyumbueg te simbe wund wuri, “Ni nge yumbo ur asi yembe gidiny kin te simbe nindigh omo.” Pugri bu Samaria kin wute nganye buagi tiqe tende ris kin ni Jisas nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pugri bu Samaria kin wute buagi tiqe pe pu riyi ri Jisas nde rundo ni simbe rindig ei ni ane ris ningg. Di Jisas ni ane ris nginy temi. ");
INSERT INTO kms_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Di Jisas ni wand simbe nand kin te ningg wute nganye buagi ni nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Muq ni nyumbueg te ningg riri, “Nu beghi simbe gudug kin te ninggne beghi ni nei bibig segi, muq beghi bonne putungu pre, di nei bab wuti nen ni nganyene nganye wute qi pe kin nate ruwi ye.” ");
INSERT INTO kms_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas ni Samaria nas nginy temi pre tende dobu ni Samaria si niraq Galili no. ");
INSERT INTO kms_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Muq Jisas nikinne pugri simbe nand nari, “Propet ni wute nikin tiqe kinne yuwon ruang segi.” ");
INSERT INTO kms_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wute Galili kin ni God asi Israel mingg wo si nare mas kin te nei rimbiny ningg Jerusalem ris di Jisas yumbo ur bei nand kin te ruqond pre, pugri bu Jisas ni nondo Galili nitari righe di ni Jisas chumbuai rindig. ");
INSERT INTO kms_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisas ni munene tiqe ire Kana puq munduw kin ni Galili opu yequ ye tende no. Tiqe te ningg ni asi nari di wuye tinde kuso wain kuse. Di wuti iri ni Juda mingg wuti nyamb kin ni wo num yumbui nganye gureg pu Kaperneam nase. ");
INSERT INTO kms_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wuti nen ni Jisas Judia pu Galili nandi pre kin te nutungu, ni Jisas nde newo no di simbe nindig ei ni no di ni kuwonyimi nati ningg tumo pu nase kin te sabi nindig. ");
INSERT INTO kms_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisas wuti te simbe nindig nari, “Nungoqi kin iri nge nei nimbigh segi. Nge yumbo ur gre kin te bei gad kin te wuqond, tedi nge nei wumbigh.” ");
INSERT INTO kms_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wuti nyamb kin te nari, “Yumbui, nu ghati yi, eti nge wo nati.” ");
INSERT INTO kms_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas oyi nand nari, “Nu yo. Nu wo nati segi, nas ye.” Wuti nyamb kin te Jisas ningg wand te nutungu di no. ");
INSERT INTO kms_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ni baj pe no nitari righe segine nikin te yembe ye wute te mandi ngimi muqoind di mari, “Nu wo yabe oghi pre.” ");
INSERT INTO kms_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ni pughe puayi oghi kin te ningg pengu nand di ni mari, “Kambe 1 kilok kin pugri ni ghimbi sungue kin num te oghi.” ");
INSERT INTO kms_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Muq ni nei namb, kambe ngeri pugri ye pe nganye Jisas ni simbe nindig nari, “Nu wo nati segi, nas ye.” Pugri bu wuti nyamb kin di nikin ngam wo ane Jisas nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Asi Jisas Judia pu Galili no kin tende puayi ni yumbo ur gre kin ire bei neny pre, di muq aye wen mune bei neny. ");
INSERT INTO kms_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jisas ni Juda mingg wuti nyamb kin iri wo te sabi nindig pre, di Juda ni ngeri yumbui ire chumbuai rindiny kin te ningg Jerusalem newo no. ");
INSERT INTO kms_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Muq Jerusalem tende ngimrawu ire ni Sipsip Ngimrawu puq munduw kin tende tumone wuye ngamo ire Hibru wand pe Betesda puq munduw kin tende wuse. Di baj wase ede 5 pela pu wuye ngamo pe tende mase mase mondo mandi. ");
INSERT INTO kms_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Wase ede pe tende wute num kin nganye buagi pripri ris: wute ninge rar rit segi kin, ninge nyinge brequ rise nyinge rire tuqui segi kin, di ninge quangi rind kin. ");
INSERT INTO kms_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wuti iri ni nyinge nare tuqui segi pu nas ber 38 pela pu nawo kin ni anene tende nas. ");
INSERT INTO kms_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas wuti te tende nase kin te nuqoind di wute ninge simbe rindig riri ni asine pugri pu nase. Segi ni pengu nindig nari, “Nu mune oghi ningg kuari?” ");
INSERT INTO kms_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Muq wuti num kin te oyi nand nari, “Yumbui, nge wuye ideng kup kin tende puayi wute nge ghav mindigh wuye pe mi kaghe kin wute segi. Nge kaghe ko pune di wuti aye naghe no sunyi nateri pre.” ");
INSERT INTO kms_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Muq Jisas wuti num kin te ningg nari, “Yes yewo! Nunon kuase kin sunyi te ghateri di nyinge ghare yo.” ");
INSERT INTO kms_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Muq wuti te opu oghi, nikin nase kin sunyi te nateri di nyinge nare no. Jisas ni wuti te sabi nindig kin te nginy Sabat kin tende puayi puq nen, ");
INSERT INTO kms_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","di te ningg Juda mingg wute nyamb kin ni wuti te Jisas sabi nindig mune oghi kin te ningg mari, “Muq te Sabat, lo ni nu sunyi ghare yo kin te ningg segi puq wund.” ");
INSERT INTO kms_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wuti Jisas sabi nindig oghi kin te oyi nand nari, “Wuti nge sabi nindigh oghi kin ni nge simbe nindigh nari, ‘Nu sunyi ghateri di nyinge ghare yo’.” ");
INSERT INTO kms_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Muq ni pengu mindig, “Wuti tughe bu nu sunyi kuateri di nyinge kuare kuo puq nunduw?” ");
INSERT INTO kms_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pudi wuti te ni wuti sabi nindig kin te nei nimbig segi, te pugri Jisas ni wute buagi tende tumone yeru kin tende mingi nar no pre. ");
INSERT INTO kms_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dobu Jisas ni wuti te God ningg baj pe tende nas nuqoind di simbe nindig nari, “Nu tungu, nu mune oghi pre. Muq nu munene yumbo ur brequ ghand wayequ, eti mune num yumbui nganye kurew.” ");
INSERT INTO kms_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Muq wuti te no, di Juda mingg wute nyamb kin te pugri simbe nindim nari, “Wuti taq Jisas bu nge sabi nindigh.” ");
INSERT INTO kms_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pugri bu Jisas ni Sabat kin nginy te ningg ni yumbo ren puq nen kin te ningg Juda ni Jisas unje maip mai isis meng. ");
INSERT INTO kms_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas ni simbe nindim nari, “Nge wuyi nikin yembe te kin yembe nand nand rindi rindi muq, di nge mune pugrine yembe gad ye.” ");
INSERT INTO kms_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Te kin ningg wute Juda kin ni buid map ei Jisas mi nati ningg. Ni Sabat lo gure nuaq kin te ninggne segi, pudi ni God nikin kiyi puq nindig kin te ningg anene. Te pugri ni puq nand kin te ningg ni nari ni God temi tuquine kin pugri. ");
INSERT INTO kms_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Muq Jisas ni oyi pugri simbe nindim nari, “Nge nungoqi nganyene simbe guduq, wo ni nikinne yumbo yembe nindiny kin tuqui segi. Ni kiyi yumbo yembe nindiny nuqond kin tene yembe nindiny, te pugri yumbo kiyi yembe nindiny kin te wo segine yembe nindiny ye. ");
INSERT INTO kms_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Te pugri kiyi ni kuwonyimi quan nganye yawo nirang righe, di te ningg ni yumbo buagi yembe nindiny kin te bei nindig omo. Te nganye, ni yumbo mune nganye yumbui kin te bei neng ye te ningg nungoqi puye wand ye. ");
INSERT INTO kms_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wuyi ni wute mati kin nindimi mewo di simbe nindim ni mune mas ye, pugrine kuwonyimi ni wute pughe ye nindimi mewo yawo gureg kin te nindimi mewo ye. ");
INSERT INTO kms_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wuyi ni wute ir nawo segi, pudi ni kuwonyimi gre neng di wute ir nawo, ");
INSERT INTO kms_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ei te wute buagi wuyi nyamb rindivi viyo kin pugrine kuwonyimi nyamb rindivi viyo. Wuti iri kuwonyimi nyamb nindivi viyo segi, te ni wuyi ni tiqi nundog nandi ye te anene ni nyamb te nindivi viyo segi. ");
INSERT INTO kms_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nge nungoqi nganyene simbe guduq, wuti nge wand gad kin te nutungu di wuti nge tiqi nundogh gadi kin te nei nimbig ye, ni nas nas te kin nas di wuyi ni yembe neng segi. Te pugri ni wute mati kin pugri ye pe tende pu newo naghe no wute mas kin pugri pe tende no pre. ");
INSERT INTO kms_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nge nungoqi nganyene simbe guduq, ngeri ire wundi ye te muq wundi pre di muq ven nde puayi wute mati pu pugri mas ye ni God ningg wo wand nand kin te mutungu, di wute mutungu kin ni mas ye. ");
INSERT INTO kms_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Te pugri wuyi ni nde gri wute mas di te kin pugrine muq ni kuwonyimi gre neng ei ninde gri wute mas. ");
INSERT INTO kms_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Di ni wute ir nawo kin gre neng, te pugri ni God nde pu nandi wuti nganye nas ye. ");
INSERT INTO kms_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Nungoqi nge simbe gad kin ren ningg puye wand wayequ, te pugri ngeri ire wundi kin tende puayi wute riti kin buagi ngamo pe rise kin ni wand nand kin te rutungu, ");
INSERT INTO kms_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","di res riwo ye. Wute yumbo ur oghi rind ye ni res riwo di ris, di wute yumbo ur brequ rind ye ni res riwo ei God ni yembe neny. ");
INSERT INTO kms_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nge ngening nde gre pene yumbo ninge yembe gidiny tuqui segi. Nge wand kutungu kin pugrine wute ir kawo, di wute ir kawo kin te tuquine ir kawo, te pugri nge ngeningne yumbo ren puq ken segi, pudi wuti nge tiqi nundogh kin ni nge yumbo ren puq ken ningg nari.” ");
INSERT INTO kms_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Muq Jisas ni mune simbe nand nari, “Nge ngening ningg wand simbe gad, tedi nungoqi nge wand simbe gad kin te nganyene puq wand kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wuti aye iri wand ghav nand kin ni nge ningg simbe nand ye, di nge nei gab ni wand nand ye te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Nungoqi wute Jon nde tiqi wundom mo, di ni wand nganyene kin te ningg simbe nindim. ");
INSERT INTO kms_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ren kin te wute nge wand ghav mindigh ningg kari segi. Pudi Jon nge ningg wand simbe nand kin te simbe gad ei nungoqi te nei wumbiny di God nungoqi nitaqu wowi. ");
INSERT INTO kms_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ni lam kin pugri nimbiq di wute ti neny, di nungoqi nonne wondo ti pe tende chumbuai ane was. ");
INSERT INTO kms_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon nge ningg wand simbe nand kin te ni nge wand ghav nindigh. Pudi yembe nge wuyi negh yembe gidiny di omone ei kawo ye ni quan nganye ghav rind, te pugri wuyi nge tiqi nundogh gadi. ");
INSERT INTO kms_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Di wuyi nge tiqi nundogh gadi ye ni nikinne nge ningg simbe nand pre. Nungoqi ni wand nand kin gibe ko te wuntungu segi, di ni quenge wundig segi, ");
INSERT INTO kms_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","di ni ningg wand nungoqi nde umbo pe vise segi, te pugri nungoqi nge ni tiqi nundogh gadi kin nge wand simbe gad kin te nganyene puq wand segi. ");
INSERT INTO kms_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nungoqi wand God ningg buk pe rise kin te wuqond nei wumbiny ningg, te pugri nungoqi wari nungoqi pugri puq wen ei was was te kin was ye. Wand buk pe rise kin te nge ninggne ur mand, ");
INSERT INTO kms_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pudi nungoqi nge nde wandi ei was was te kin was yambu wari. ");
INSERT INTO kms_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Wute nge nyamb mindivi viyo kin te ningg kari segi, ");
INSERT INTO kms_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","pudi nge nungoqi nei gubuq pre. Nge nei gab kin te pugri God wute yawo nirany righe kin pugri ye te nungoqi nde umbo pe rise segi. ");
INSERT INTO kms_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nge wuyi nde nyamb pe gadi, di nungoqi nge wand gad kin te wutungu segi. Pudi wuti iri nikin nde nyamb pe nandi tedi nungoqi ni ningg wand wutungu. ");
INSERT INTO kms_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nungoqi nonne oyi oyi nyamb wundivi viyo, di nungoqi yumbo ur ninge puq wen ei God irine nas ye nungoqi nyamb nindivi viyo ningg puq wen segi, tedi pughe gri ei nge nei wumbigh? ");
INSERT INTO kms_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Pudi eti nungoqi nei wumbiq wari nge wuyi simbe gidig kari nungoqi unje wap, pugri nei wamb wayequ. Wuti wuyi simbe nindig nari nungoqi unje wap puq nand kin te Moses, nungoqi non wari ni nungoqi ghav nunduq ye. ");
INSERT INTO kms_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nungoqi nganyene nganye Moses wand nand kin te wari nganyene, tedi nge wand gad kin te anene wari nganyene, te pugri Moses ni nge ningg wand ur nand. ");
INSERT INTO kms_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pudi muq nungoqi Moses wand ur nand ye te wari nganyene puq wand segi, tedi pughe gri ei nge wand gad kin te wari nganyene?” ");
INSERT INTO kms_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Jisas ni wute num kin sabi nindiny ye yumbo ur te bei nand, pugri bu ni nikin ningg wand simbe nand pre tende dobu ni Galili wuye ngamo yumbui nisiq opu gri no, di wute nganye buagi nganye ni nde dobu ruru. (Wuye ngamo te ni nyamb aye Taiberias.) ");
INSERT INTO kms_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Muq Jisas ni rand pe newo no di nikin wute ane mas. ");
INSERT INTO kms_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","God asi Israel mingg wo rar nuqond mas kin ngeri chumbuai mindiny ye te tumo rind. ");
INSERT INTO kms_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas ni rar nat di wute nganye buagi ni nde riwo ruru kin te nuqond, di ni Pilip ningg nari, “Beghi bret muainde wong bad ei wute ren peny riq?” ");
INSERT INTO kms_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ni pugri puq nand ei nuqond Pilip ni pughe gri ei oyi nand, pudi Jisas ni yumbo puq nen kin te nei namb pre. ");
INSERT INTO kms_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip oyi nand nari, “Irew 8-pela kin fotnait pe beghi bret wong bad, pudi wute buagi ren puch puch riq kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jisas nikin wuti aye iri, Andru, Saimon Pita kiqam ni nari, ");
INSERT INTO kms_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wokuandi iri nen nas kin ni bret wokuandi bali pe yembe mindiny kin te 5-pela pu rise, di umo woju teri ane rise, pudi ren ninggne wute buagi ren bag bab tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisas nari, “Wute buagi simbe wundiny chuchu ris.” Mong tende nyungo nganye buagi ris, di wute buagi nyungo pe tende chuchu ris. (Wute buagi tende ris kin te quayine ni 5 tausen kin pugri.) ");
INSERT INTO kms_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Muq Jisas bret te nateri, Yumbui chumbuai nindig pre. Di neny neny ruso wute buagi tuqui nap, di umo te mune pugrine puq neny. ");
INSERT INTO kms_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ni quan buagine riq mir rimb pre, Jisas nikin wute ningg nari, “Nungoqi wo bret cham te dong wand, cham ninge si ware rise segi kin.” ");
INSERT INTO kms_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pugri bu ni mo, bret bali pe yembe mindiny kin wute riq tuqui segi cham ris kin te dong mand, di imbi pe mawo righe ruso imbi 12-pela pu bre mand. ");
INSERT INTO kms_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wute buagi Jisas yumbo ur gre ye ven puq nen kin te ruqond pre tende dobu riri, “Nganyene nganye, wuti nen ningg asi Moses simbe nand nari, ‘Propet iri ni qi pe nandi ye’.” ");
INSERT INTO kms_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas ni nei namb wute te rindi di ni gri buid riping ei Jisas king ningg nas, pugri bu ni rand te si neri, nikin irine rand aye pe no. ");
INSERT INTO kms_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bur yuram tende puayi Jisas nikin wute te wuye ngamo yumbui pe maghe mo, ");
INSERT INTO kms_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bot pe mewo mo di wuye ngamo yumbui te misiq opu gri Kaperneam tende mo ningg. Muq bur ir kui pre, di Jisas ninde nandi segine. ");
INSERT INTO kms_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nyumurighi yumbui nganye naghe, di wuye te quan nganye bir bir gudi. ");
INSERT INTO kms_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ni mo 5 kilomita kin pugri ye pe tende Jisas wuye wamne ni nde tiq nyinge nare nandi kin te muqoind, di ni wune mamb. ");
INSERT INTO kms_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pudi Jisas ni simbe nindim nari, “Wune wamb wayequ, ngene bu gadi.” ");
INSERT INTO kms_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Muq ni chumbuai ane bot pe mi newo, di bot opu brequne jiji pe opu ni mo puq mand kin tende yequ. ");
INSERT INTO kms_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yambgriq wute buagi wuye ngamo yumbui opu gri yeru kin ni nei rimb bot irene tende yequ di Jisas ane bot pe newo no segi, pudi nikin wutene bot pe tende mewo mo. ");
INSERT INTO kms_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Muq bot ninge Taiberias pu rindi, Yumbui ni bret 5-pela pu nateri God chumbuai nindig pre wute neny riq kin sunyi pe tende tumone yeru. ");
INSERT INTO kms_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wute buagi ruqond Jisas nikin wute ane tende yemu segi, di ni bot pe riwo ruso di Kaperneam ruru Jisas meri riting. ");
INSERT INTO kms_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ni Jisas wuye ngamo yumbui pe ruso riwo opu gri yenu ruqoind di pengu rindig, “Tisa, nu pughe puayi ren guadi?” ");
INSERT INTO kms_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisas oyi nand nari, “Nge nungoqi nganyene simbe guduq, te pugri nungoqi nge yumbo ur gre ye bei gad wuqond kin te ningg nge meri wutigh segi. Nungoqi bret waq di omo waq kin tuqui segi ye te ningg nge meri wutigh. ");
INSERT INTO kms_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nungoqi mir brequne brequ rise kin te ningg yembe wand wayequ, pudi mir pe ei pas pas te kin pas ye te ningg ei yembe wand. Mir te wuti God nde pu nandi wuti nganye nas kin ni nungoqi neuq ye. Te pugri God nge wuyi ni ningg chumbuai nand kin te bei nand pre.” ");
INSERT INTO kms_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Muq ni pengu rind riri, “Beghi pughe sin pen ei God nari kin yembe te yembe bad?” ");
INSERT INTO kms_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisas oyi nand nari, “God ningg yembe taq: wuti God tiqi nundog nandi kin te ei nei wumbig.” ");
INSERT INTO kms_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Muq ni Jisas pengu rindig, “Nu yumbo ur gre kin pughe ye bei guad, di te beghi buqod di nu nei bubuw? Nu pughe sin ei kuen? ");
INSERT INTO kms_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Beghi koku ni mir ire mana puq munduw kin qi wuye di nyumo segi ye pe tende riq kin te God ningg wand buk pe rise kin te ane tuquine, ‘Ni nginy tu pe pu bret neny riq’.” ");
INSERT INTO kms_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisas simbe nindiny nari, “Nge nungoqi nganyene simbe guduq, Moses nungoqi nuqo bret te nginy tu pe pu neny segi. Nge wuyi nungoqi bret nganye nginy tu pe pu neuq. ");
INSERT INTO kms_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Te pugri God ni bret taq wuti nginy tu pe pu nandi, di ni nde gri wute qi pe kin ris ye.” ");
INSERT INTO kms_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Muq ni riri, “Yumbui, muq pu ruso otiwo beghi bret te yengu.” ");
INSERT INTO kms_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Muq Jisas nari, “Bret wute maq di mas mas te kin mas ye te nge. Wute nge nde rindi kin ni mir kureny segi, di wute nge nei rimbigh kin ni yawo singar riti tuqui segi ye. ");
INSERT INTO kms_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pudi nge nungoqi simbe guduq pre kin pugri, nungoqi nge wuqoind pre pudi nei wumbigh segine. ");
INSERT INTO kms_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wute buagi wuyi nge negh kin te nge nde rindi ye, di wute nge nde rindi ye nge kring kap ruso segi. ");
INSERT INTO kms_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Te pugri nge nginy tu wam pu gadi kin nge ngening yumbo yembe gidiny ningg gadi segi, pudi wuti nge tiqi nundogh gadi kin ni nari kin yembe te yembe gidiny ningg bu gadi. ");
INSERT INTO kms_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Di ni nari kin yembe taq pugri: wute buagi nge negh kin te si kare segi, pudi ngeri pre kin tende puayi nge kari di res riwo. ");
INSERT INTO kms_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nge wuyi ni nari kin taq pugri: wute buagi ni kuwonyimi ruqoind di nei rimbig kin ni ris ris te kin ris, di ngeri pre kin tende puayi nge kari di mune res riwo ye.” ");
INSERT INTO kms_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas ni nari, “Nge ngeningne te bret nginy tu pe pu wuti wi kin,” pugri bu Juda ni te kin ningg kin kin ker mawo. ");
INSERT INTO kms_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ni mari, “Wuti nen Jisas ni Josep ningg wo, ni kiyi di kumo ane beghi nei bibiny. Pughe gri ate ni muq nari ni nginy tu wam pu nandi?” ");
INSERT INTO kms_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas oyi nand nari, “Nungoqi non non ker wawo wayequ. ");
INSERT INTO kms_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wuti iri nikinne nge nde nandi tuqui segi, pudi wuyi nge tiqi nundogh gadi kin ni gri nei neng tedi nge nde nandi tuqui, di ngeri pre kin tende puayi nge gidingi newo ye. ");
INSERT INTO kms_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wand ven te propet iri ni ur nand pu vise. Wand ven taq pugri, ‘God ni quan buagine nei neny di ni nei rimb.’ Wute buagi ni wuyi nde pu wand rutungu di nei riteri kin ni nge nde rindi ye. ");
INSERT INTO kms_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wuti iri wuyi nuqoind segine, pudi wuti God nde pu nandi kin ni wuyi nuqoind pre. ");
INSERT INTO kms_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nge nungoqi nganyene simbe guduq, wuti nge wand gad kin te nutungu nari nganyene puq nand kin ni nas nas te kin nas ye. ");
INSERT INTO kms_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nge ngeningne te bret, wute te riq di ris ris te kin ris ye. ");
INSERT INTO kms_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nungoqi nuqo bret ire mana puq munduw kin te qi jijine kuse kin tende riq, pudi ni riti. ");
INSERT INTO kms_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pudi bret wen nginy tu wam pu wundi kin te wute segine riq di riti segi. ");
INSERT INTO kms_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nge ngeningne te bret wute riq di riti segi ye, nginy tu wam pu wuti wi kin te. Wuti iri ni bret wen naq, ni nas nas te kin nas ye. Bret wen te nge ngening ghimbi, wute buagi qi pe kin keny ei ni ris.” ");
INSERT INTO kms_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Muq Juda ni kin kinne oyi oyi quan nganye ker mawo di mari, “Pughe gri ei wuti nen nikin ghimbi som te nengu paq?” ");
INSERT INTO kms_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisas simbe nindim nari, “Nge nungoqi nganyene simbe guduq, nungoqi wuti God nde pu nandi wuti nganye nas kin ni ningg som te waq segi di ni yavi waq segi, tedi nungoqi was segi. ");
INSERT INTO kms_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wute nge som riq di yavi riq ye ni ris ris te kin ris, di otiwo ngeri pre kin tende puayi nge gidiri riwo ye. ");
INSERT INTO kms_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Te pugri nge som te mir nganye, di nge yavi te wuye nganye we kin. ");
INSERT INTO kms_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wute nge som riq, di nge yavi riq, nge ni ane irene pas. ");
INSERT INTO kms_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wuyi nas nas te kin nas ye ni nge tiqi nundogh gadi, di ninde gri nge kas, di te kin pugrine wute nge me kin te nge nde gri ni mas. ");
INSERT INTO kms_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bret taq wen bu nginy tu wam pu wuti wi ye. Nungoqi nuqo ni mana riq di riti, pudi wuti bret wen naq ye ni nas nas te kin nas.” ");
INSERT INTO kms_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas ren simbe nand kin te ni Kaperneam God yumbui nyamb mirang kin baj pe ni wand wute bei neny kin tende puayi ni simbe nand. ");
INSERT INTO kms_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisas nikin wute nganye buagi Jisas wand nand kin te rutungu riri, “Wand ven te quan nganye gre kin. Tughe ei wand ven rutungu?” ");
INSERT INTO kms_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas nikin wute ni pugri nei rimb kin te ni asine nei namb pre, pugri bu ni simbe nindiny nari, “Nungoqi wand ren ningg nge dob bri wegh? ");
INSERT INTO kms_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nge wuti God nde pu gadi wuti nganye kas kin nge munene asi kas kin sunyi pe kewo ko kin te wuqond, tedi nungoqi pughe sin ei wen! ");
INSERT INTO kms_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God ningg Ququ nde gri wute ris, wute mingg gre pene tuqui segi. Wand nge nungoqi simbe guduq kin te ningg God ningg Ququ nungoqi nde nandi di nungoqi was was te kin was. ");
INSERT INTO kms_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pudi nungoqi kin ninge nge wand gad kin te wutungu wari te nganyene segi.” Ni puq nand kin puate te pugri wuti pughe ye Jisas ningg wand te nutungu nari te nganyene segi, di wuti pughe ye ei Jisas veri nde si pe ni nondo kin te God ni asine yumbo buagi qi pe kin yembe nindiny kin tende puayine Jisas nei namb pre. ");
INSERT INTO kms_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ni mune nganye simbe nand nari, “Te kin ningg bu nge nungoqi simbe guduq kari, wuti iri nikinne nge nde nandi kin tuqui segi, pudi wuyine nari tedi tuqui.” ");
INSERT INTO kms_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas puq nand kin te ningg wute ninge Jisas nde dobu ruru kin ni dob reng di ninde dobu ruru segi. ");
INSERT INTO kms_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Muq Jisas nikin wute 12-pela pu te pengu nindim nari, “Nungoqi ni ane wo ye bri?” ");
INSERT INTO kms_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita oyi nand nari, “Yumbui, beghi tughe nde ei po? Nu irine qa pas pas te kin pas ye wand te rise. ");
INSERT INTO kms_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Beghi nu nei bubuw, di nei bab te pugri nu wuti yuwon nganye God nde pu guadi kin.” ");
INSERT INTO kms_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Muq Jisas oyi nand nari, “Nge nungoqi 12-pela pu kupuqu wo. Pudi nungoqi kin iri te ququ brequ mingg yumbui ni ningg wo!” ");
INSERT INTO kms_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ni puq nand kin te Judas, Saimon Iskariot ningg wo, ni Jisas ningg wute 12-pela ye te kin iri, pudi otiwo ni Jisas veri nde si pe ni nondo ye, ni ningg bu nari. ");
INSERT INTO kms_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tende dobu Jisas ni tiqe Galili opu yeru kin te nuqond nuqond no. Ni Judia no yambu nari, te pugri Juda mingg wute nyamb kin tende mas kin ni Jisas mi ningg ghimbi pu mas. ");
INSERT INTO kms_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Juda ni mir bi mawo kin ngeri te ningg ni baj yirbu pu mas di chumbuai mand ye ngeri te tumo rind kin tende puayi ");
INSERT INTO kms_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisas ni kiqam simbe mindig mari, “Nu muqdi tiqe wen si raq di Judia yo, ei te nu non wute nu yumbo ur gre ye bei ghand muqond. ");
INSERT INTO kms_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wuti iri ni nyamb yumbui vise ningg nari kin ni suqo grine yumbo yembe nindiny segi. Nu yo yumbo ren puq yen ei wute buagi nu nei rumbuw.” ");
INSERT INTO kms_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jisas kiqam ni Jisas nikin ningg wand simbe nand kin te nganyene puq mand segi, pugri bu ni puq mand. ");
INSERT INTO kms_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Te kin ningg di Jisas ni simbe nindim nari, “Nge ko kin ngeri te segine. Nungoqi segi puayi wo ye. ");
INSERT INTO kms_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wute buagi nungoqi yambu rireuq tuqui segi, pudi nge yambu riregh, te pugri nge ni yumbo ur brequ rind kin te ningg simbe gad. ");
INSERT INTO kms_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nungoqi mir pe tende wo. Nge mir pe tende prine kewo ko segi ye, te pugri nge ko kin ngeri te muq segine.” ");
INSERT INTO kms_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ni pugri puq nand di Galili ne nas. ");
INSERT INTO kms_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pudi ni kiqam mir pe tende mo pre, muq ni suqo grine naru, ni raqene no segi. ");
INSERT INTO kms_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Muq mir pe tende Juda mingg wute nyamb kin ni Jisas ningg rar rar mas, di oyi oyi pengu mand, “Wuti te muainde nas?” ");
INSERT INTO kms_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wute buagi yeru pe mingi tende wute quan Jisas ningg misag rire. Ninge riri, “Ni wuti oghi ye.” Ninge oyi rind riri, “Yewo, ni wute wandoqi nindiny ye.” ");
INSERT INTO kms_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pudi wute buagi nde rar pene ni Jisas ningg wand rind segi, te pugri ni Juda mingg wute nyamb kin te wune rimbim. ");
INSERT INTO kms_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mir yembe mindiny ye te mingi mingi yemu, Jisas ni God ningg baj pe nar no di God ningg wand wute bei neny. ");
INSERT INTO kms_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda mingg wute nyamb kin ni puye mand di pengu mand mari, “Wuti nen pughe gri ate skul nand segi pudi ni yumbo quan nganye nei nimbiny?” ");
INSERT INTO kms_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas oyi nand nari, “Nge wand simbe gad kin te nge ngening nde nei pe simbe gad segi. Wand ven te wuti nge tiqi nundogh gadi kin ni nde pu vindi. ");
INSERT INTO kms_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wuti iri God nari kin pugrine puq nen ningg nari, tedi ni segine nei namb ye tuqui te pugri wand nge simbe gad kin te God nde pu vindi, o nge ngening nde nei pe simbe gad. ");
INSERT INTO kms_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wuti ni nikin nde nei pe simbe nand kin ni pugri puq nen ei ni nyamb kin nas ningg nari. Pudi wuti iri wuti ni tiqi nundog nandi kin ni nyamb te ningg yembe nand kin ni wand nganyene kin simbe nand ye. Ni wandoqi nand segi. ");
INSERT INTO kms_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses nungoqi lo neuq, pudi nungoqi lo te gure wawo. Pughe kin ningg nungoqi nge wi ningg?” ");
INSERT INTO kms_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wute buagi oyi rind riri, “Ququ brequ nu nde nas. Wute pughe ye nu mi ningg?” ");
INSERT INTO kms_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas oyi nand nari, “Nge yumbo ur gre ye ire bei guduq di nungoqi puye wand. ");
INSERT INTO kms_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pudi Moses nungoqi ghimbi dugu chongo pend wawo ningg nari, pugri bu nungoqi Sabat kin nginy tende wo ghimbi dugu chongo pend wam. (Moses nungoqi ghimbi dugu chongo pend wawo ningg nari, pudi nungoqi nuqo ni te kin puate mi righe.) ");
INSERT INTO kms_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Muq nungoqi Sabat kin nginy wo ghimbi dugu chongo pend wam, di Moses ningg lo gure waq segi, pudi pughe kin ningg nge wuti Sabat kin nginy te ningg sabi gidig kin te ningg ker wawo? ");
INSERT INTO kms_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nungoqi non nde nei pene wute unje map puq wundim wayequ. Nungoqi wute wuqond muqdi tuquine ir wawo.” ");
INSERT INTO kms_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Muq Jerusalem kin wute ninge pengu rind riri, “Wuti mi puq mand kin tene bri nen? ");
INSERT INTO kms_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Muq ni rar quan mingine yenu wand nand, di wute ni ningg wand ninge simbe mand segi. Beghi ningg wute nyamb kin ni nei mamb wuti nen nganyene Kraist bri? ");
INSERT INTO kms_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wuti nen ni tiqe beghi nei bab, pudi otiwo Kraist nganye nandi kin ni tiqe wuti iri nei numbuw ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Muq God ningg baj kin imb pe tende Jisas ni wute wand bei neny nenyne di nari, “Te nganye nungoqi nge nei wumbigh, di nge muai pu gadi kin te nei wamb. Pudi nge ngeningne ren gadi segi. Ni nge tiqi nundogh gadi kin te nganyene. Pudi nungoqi ni nei wumbig segi, ");
INSERT INTO kms_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nge ngeningne ni nei gibig, te pugri nge ni nde pu gadi, di ni nge tiqi nundogh gadi.” ");
INSERT INTO kms_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jisas ni wand ren simbe nand kin te ningg Jerusalem kin wute ninge ni mait nase ningg, pudi wuti iri Jisas nait nase segi, te pugri Jisas ni mait nase kin ngeri te segine. ");
INSERT INTO kms_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jisas ni yumbo ur gre ye bei nand kin te ningg wute nganye buagi ni nei rimbig. Ni riri, “Asi mari Kraist ni nandi di yumbo ur gre ye nganye ei bei nand puq mand kin te muq wuti nen ni yumbo ur bei nand kin te wand te ane tuquine.” ");
INSERT INTO kms_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi ni wute Jisas ningg pugri misag rire kin te mutungu. Muq prist mingg yumbui di Parisi ane wute God ningg baj yeng muaw kin te tiqi mundom mo ei Jisas mait nase ningg. ");
INSERT INTO kms_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas nari, “Nge nungoqi ane musoqne pas, pre di wuti nge tiqi nundogh gadi kin ni nde mune ko. ");
INSERT INTO kms_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nungoqi nge meri wutigh, pudi nge wuqoind segi, di nge kas kin pe tende nungoqi waru kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda mingg wute nyamb kin oyi oyi wand wand mare mari, “Wuti nen ni muainde bri no ningg bu nari ni no di beghi buqoid kin tuqui segi? Ni tiqe aye pe beghi wute tende mas, di wute Grik kin te God ningg wand bei nem kin pe tende bri no? ");
INSERT INTO kms_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Puate pughe ningg bu ni nari, ‘Nungoqi nge meri wutigh pudi nge wuqoind tuqui segi,’ di ‘Nge kas kin pe te nungoqi waru tuqui segi’?” ");
INSERT INTO kms_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Muq mir yembe mindiny ruso ruso mir te pre kin nginy di nginy te yumbui nganye. Nginy te ningg Jisas nes newo, di quan kumone simbe nand nari, “Wuti iri yawo singar nati tedi nge nde nandi, ei wuye ne. ");
INSERT INTO kms_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","God ningg wand buk pe vise kin taq pugri, wute nge nei mimbigh kin ni wuye wute me di mas kin te ni nde wuye ambri kin pugri yuroru gud gud kuse.” ");
INSERT INTO kms_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas puq nand kin te ni Ququ Yuwon Ye wute ni nei rimbig kin te neny ye te ningg nari. Pudi Jisas ni nati pre di mune nes newo nginy tu wam newo no di yumbui ningg nas segine, pugri bu wute ni nei rimbig kin te Ququ Yuwon Ye neny segine. ");
INSERT INTO kms_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas ni wand simbe nand rutungu kin te ningg wute ninge riri, “Nganyene nganye, wuti nen ni propet iri beghi ghimbi buag kin te.” ");
INSERT INTO kms_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ninge riri, “Ni Kraist.” Pudi ninge pengu rind rindne, “Pughe gri ei Kraist Galili pu nandi? ");
INSERT INTO kms_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wand buk pe vise buqod kin te pugri, Kraist ni Devit ningg kuqo nde gri ei nandi ye, di Devit nas kin tiqe Betlehem pu ei nandi.” ");
INSERT INTO kms_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jisas ni wand simbe nand kin te ningg wute bir, ninge opu ninge opu. ");
INSERT INTO kms_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ninge Jisas mait nase ningg, pudi wuti iri Jisas nait nase segi. ");
INSERT INTO kms_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wute God ningg baj yeng muaw kin te ni Jisas mait nase ningg mo pre, mune prist mingg yumbui di Parisi nde mandi. Muq prist mingg yumbui di Parisi ni pengu mindim mari, “Pughe ningg nungoqi wuti te wutanyi segine wandi?” ");
INSERT INTO kms_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wute God ningg baj yeng muaw ye ni mari, “Wuti iri ni wand simbe nand kin pugri wand nand kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Muq Parisi ni mari, “Nungoqi anene wandoqi nunduq bri? ");
INSERT INTO kms_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nungoqi beghi wute nyamb kin di Parisi kin wuti iri Jisas ningg wand nutungu nari te nganyene puq nand kin iri nei wumbig? ");
INSERT INTO kms_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pudi wute buagi ren Moses ningg lo nei rumbuw segi di ninde ruru ye te God di lo ane ni mai neny ye.” ");
INSERT INTO kms_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Muq Nikodemus, Parisi te asi Jisas nde no kin te ni nari, ");
INSERT INTO kms_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Beghi lo wuri, wuti unje paip segine ni pughe sin nen kin te beghi simbe nundug pre muqdi unje paip.” ");
INSERT INTO kms_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wute te ni oyi mand mari, “Nu anene Galili kinne bri? Nu wand buk pe rise kin te qond, di te pugri propet ni Galili pu mandi segi.” ");
INSERT INTO kms_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Muq Juda mingg wute nyamb kin te ire ire nikin baj pe mo. ");
INSERT INTO kms_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pudi Jisas ni rand Oliv puq mindig kin tende no. ");
INSERT INTO kms_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yambgriq bur ane ni munene God ningg baj kin imb pe no, tende wute buagi rindi rikur di ni mingine nas ei God ningg wand bei neny ningg. ");
INSERT INTO kms_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Muq wute ninge Moses ningg lo wute bei meny kin di Parisi ni wute ngam kin ire quayi aye ane rise muqond, di nyumbueg te mitaqi Jisas nde mondo. Ni mari nyumbueg te wute buagi nde rar pene yequ, ");
INSERT INTO kms_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","di Jisas ningg mari, “Tisa, nyumbueg wen ngam kin bu quayi aye iri ane rise buqod. ");
INSERT INTO kms_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses ningg lo te pugri, wute pugri ye beghi wet pe ei bab. Muq nu pughe puq guad?” ");
INSERT INTO kms_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ni pugri pengu mand kin te ni puq mand ei Jisas ni oghine oyi nand segi, tedi ni mo wute nyamb kin simbe mindim mari Jisas unje nap. Pudi Jisas ni yimb naghe di si timi pe qi pe ur nand. ");
INSERT INTO kms_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ni pengu mand mandne, segi ni nes newo, simbe nindim nari, “Nungoqi kin iri yumbo ur brequ guad segi ye, ate nu ye ghawo wute wen wet meraw.” ");
INSERT INTO kms_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ni pugri simbe nand pre di mune yimb naghe di qi pe ur nand. ");
INSERT INTO kms_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wute buagi Jisas puq nand kin te mutungu kin te ningg ire ire bure naghe mo, wute gang gri ye mawo, di wute buagi mo mo omo, Jisas ne nas, di nyumbueg te pugrine teti pu yequ. ");
INSERT INTO kms_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas nes newo yenu, di nyumbueg te pengu nunduw nari, “Nyumbueg, wute buagi men yemu kin muai bu mo? Wuti iri nu unje naip o segi?” ");
INSERT INTO kms_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nyumbueg te wuri, “Yumbui, wuti iri nge unje naip segi.” Muq Jisas simbe nand nari, “Nge mune pugrine nu unje kaip segi ye. Nu yo, pudi nu mune yumbo ur brequ ghand wayequ.” ");
INSERT INTO kms_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas ni wute mune wand simbe nindiny nari, “Nge wute buagi qi pe kin ni ti. Wute nge nde rindi ye ni wute ris ris chiraq kin ti te ningg ris, di burpoq pe ris segi.” ");
INSERT INTO kms_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisi ni Jisas simbe mindig mari, “Muq nu irine nunon ninggne wand simbe guad, pugri bu beghi nu ningg wand putungu ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisas oyi nindim nari, “Te piyi nge ngening ningg wand simbe gad, nge simbe gad kin te nganyene. Te pugri nge muai pu gadi di muai nde ko ye te nei gab. Pudi nungoqi nge muai pu gadi di muai nde ko ye sunyi te nungoqi nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nungoqi wute yumbo ur dabo kin te wuqond wari te brequ, pudi ni nei umbo pe rise kin te nei wamb segi. Nge wuti iri unje nap ye te ningg simbe gidig segi. ");
INSERT INTO kms_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pudi te piyi nge wute unje rip kin te ningg simbe gidiny, nge tuquine simbe gidiny ye, te pugri nge irine yengu segi. Wuyi nge tiqi nundogh gadi ye ni nge temu yembu. ");
INSERT INTO kms_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nungoqi non ningg lo taq pugri, wute temi gri wand simbe mand kin te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nge irine ngening ningg wand simbe gad ye. Pudi nge irine nganye segi, wuyi nge tiqi nundogh gadi kin ni nge wand ghav nindigh ye.” ");
INSERT INTO kms_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Muq Parisi Jisas pengu mindig mari, “Nu nuyi muai?” Jisas oyi nand nari, “Nungoqi nge di wuyi temu nei wumbug segi. Nungoqi nge nei wumbigh, tedi nge wuyi anene nei wumbig.” ");
INSERT INTO kms_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas ni God ningg baj pe God ningg wet bidi ruwo ris kin sunyi pe tumone God ningg wand wute bei neny neny yenu, di ni wand ren simbe nand. Pudi wute ni mait nase segi. Te pugri ni mait nase di mi kin ngeri te muq segine. ");
INSERT INTO kms_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ni Juda mingg wute nyamb kin munene simbe nindim nari, “Nge ko, di nungoqi nge meri wutigh, di nungoqi yumbo ur brequ wand ye te ningg wati ye. Nge ko kin pe te nungoqi waru tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jisas ni puq nand kin te ningg Juda mingg wute nyamb kin oyi oyi pengu mand mari, “Ni nikin ghimbi nambui ningg bri nari, ‘Nge ko kin pe te nungoqi waru kin tuqui segi’?” ");
INSERT INTO kms_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pudi Jisas nari, “Nungoqi tingi qi pe kin, nge wam kin. Nungoqi qi wen kin, nge qi wen kin segi. ");
INSERT INTO kms_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nge nungoqi simbe guduq pre, nungoqi non yumbo ur brequ wand ye te ningg wati ye. Te pugri nge kari nge taq wuti nge simbe gad ye te di puq gad kin te wari nganyene puq wand segi, tedi nungoqi yumbo ur brequ wand kin te ningg wati.” ");
INSERT INTO kms_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Muq ni Jisas pengu mindig mari, “Nu tughene?” Jisas oyi nand nari, “Nge taq, asi nungoqi simbe guduq kin wuti te. ");
INSERT INTO kms_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nge nungoqi ir kuaqu kin te ningg simbe gad ye wand te nganye buagi rise. Pudi wuti nge tiqi nundogh gadi ye ni nganyene nas, di nge wand ninde pu kutungu kin te wute buagi simbe gidiny.” ");
INSERT INTO kms_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ni Jisas ni kiyi ningg puq nand kin te ni ghabe mand. ");
INSERT INTO kms_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pugri bu Jisas nari, “Nungoqi wuti God nde pu nandi wuti nganye nas kin te kruse pe qungu wi nati pu yenu kin tende puayi di nge kari nge te wuti nge simbe gad kin te nei wamb. Te pugri nge ngeningne yumbo ninge puq keny segi, pudi nge wand simbe gad kin te wuyi nge simbe nindigh kin pugrine nge simbe gad. ");
INSERT INTO kms_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wuti nge tiqi nundogh gadi kin ni nge nde nas, ni nge si neri irine kas segi, te pugri nge yumbo yembe gidiny kin te ningg ni chumbuai nand.” ");
INSERT INTO kms_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wute nganye buagi Jisas wand simbe nand ye te rutungu kin te ninggne ni nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisas ni wute Juda kin ni nei rimbig ye te simbe nindiny nari, “Nungoqi nge wand simbe gad kin te wat vise, tedi nungoqi nganyene nge ningg wute. ");
INSERT INTO kms_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tedi nungoqi God ni nganyene pughe gri nas kin te nei wamb, di te ningg nungoqi taq pu yequ segi, ir pu was.” ");
INSERT INTO kms_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Muq ni Jisas oyi rindig riri, “Beghi Abraham ningg kuqo, di beghi wute aye nde taq pu yembu yembe bad segi. Pughe gri ate nu kuari God beghi ghav nundug di taq pu yembu segi, ir pu pas?” ");
INSERT INTO kms_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas oyi nand nari, “Nge nungoqi nganyene simbe guduq, wute pripri yumbo ur brequ rind kin ni yumbo ur brequ nde taq pu yeru yembe rind ye. ");
INSERT INTO kms_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wute taq pu yeru yembe rind kin ni ris nganye tuqui segi. Wo ni kiyi temi mas mas te kin mas ye. ");
INSERT INTO kms_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pugri bu baj kiyi ni wo nungoqi nitaqu wowi, tedi nungoqi ir pu was. ");
INSERT INTO kms_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nge nei gab nungoqi Abraham ningg kuqo. Pudi nungoqi nge wi ningg, te pugri nge wand gad kin te nungoqi wutungu yambu wari. ");
INSERT INTO kms_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nge yumbo wuyi nde rar pe rise guqod kin te nungoqi simbe guduq, di nungoqi oyi nuyi simbe nunduq kin pugri puq wen.” ");
INSERT INTO kms_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Muq ni mari, “Abraham te beghi wuyi.” Di Jisas oyi nand nari, “Nungoqi nganyene Abraham ningg kuqo, tedi Abraham ningg yumbo ur ei nungoqi mune puq wen. ");
INSERT INTO kms_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nge yembe te wand nganyene kin God nde pu kutungu kin te nungoqi simbe guduq, pudi nungoqi nge wi ningg. Abraham ni yumbo ren kin puq nen segi. ");
INSERT INTO kms_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nungoqi yumbo nungoqi non nuyi puq nen kin pugrine puq wen.” Ni oyi mand mari, “God irine beghi wuyi di beghi nikin wo nganye.” ");
INSERT INTO kms_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisas simbe nindim nari, “God nganyene nungoqi nuyi, tedi nungoqi nge yawo wuragh righe, te pugri nge God nde pu gadi, di muq ven yengu. Nge ngening nde gre pene gadi segi, pudi ni nge tiqi nundogh gadi. ");
INSERT INTO kms_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pughe ningg nungoqi nge wand gad kin te nei wamb segi? Te pugri nungoqi nge wand gad kin te wutungu tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nungoqi te nungoqi non nuyi Satan ningg wand wutungu di ni nari kin pugrine puq wen ye. Ni asine wute ni mati, yumbo ur yuwon ye di nganyene kin ningg veri, te pugri wand nganyene kin ninde vise segi. Ni wandoqi nand kin tende puayi ni umbo pe ane wand nand, te pugri ni wandoqi nand ye, di ni nari wute wandoqi mand. ");
INSERT INTO kms_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pudi nge nungoqi wand nganyene kin simbe guduq ye te ningg wari te nganyene puq wand segi! ");
INSERT INTO kms_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nungoqi kin iri nge yumbo ur brequ gad kin te simbe guad kin tuqui bri? Nge wand nganyene kin simbe gad di pughe kin ningg nge wand simbe gad kin te nganyene puq wand segi? ");
INSERT INTO kms_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God ningg wo ni God simbe nand kin te rutungu. Nungoqi nge wand simbe gad kin te wutungu segi ye puate te pugri nungoqi God ningg wo segi.” ");
INSERT INTO kms_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Muq wute Juda kin ni Jisas simbe mindig mari, “Beghi pari nu Samaria kin di ququ brequ nu nde nas puq bad kin te nganyene.” ");
INSERT INTO kms_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas oyi nand nari, “Ququ brequ nge nde nas segi, pudi nge wuyi nyamb gidivi viyo, di nungoqi oyi nge nyamb wi vighe viso. ");
INSERT INTO kms_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nungoqi nge nyamb wundivi viyo kin te ningg kari segi, pudi wuti iri bu nungoqi nge nyamb wundivi viyo ningg nari, di nikinne otiwo wute ir nawo ye. ");
INSERT INTO kms_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nge nungoqi nganyene simbe guduq wuti iri nge simbe gad kin pugrine puq nen, tedi ni nati segi ye.” ");
INSERT INTO kms_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jisas ni pugri puq nand kin te ningg Juda mingg wute nyamb kin ni mari, “Muq beghi nei bab ququ brequ nu nde nas! Abraham ni nati pre, di propet buagi ni mati, pudi nu kuari wute nu simbe guad kin pugrine puq ren ye ni riti segi ye. ");
INSERT INTO kms_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nu kuari nu mune nganye yumbui, beghi koku Abraham kin pugri segi bri? Nu kuari nu tughene bri? Abraham nati, di propet ni anene mati.” ");
INSERT INTO kms_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisas oyi nand nari, “Nge ngening nyamb gidivi viyo, tedi nge nyamb yumbui vise segi. Nge wuyi nungoqi wari nungoqi God puq wundig kin ni bu nge nyamb nindivi viyo. ");
INSERT INTO kms_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nungoqi ni nei wumbig segi, pudi nge nei gibig. Nge ni nei gibig segi puq gad, tedi nge nungoqi kin pugri wandoqi gad ye. Pudi nge ni nei gibig, di ni ningg wand kat rise gre. ");
INSERT INTO kms_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nungoqi nuqo Abraham ni nge gadi ye ngeri nei nimbiny ye te ninggne chumbuai nand. Ni te nuqond pre di quan nganye chumbuai nand.” ");
INSERT INTO kms_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juda mingg wute nyamb kin ni Jisas ningg mari, “Nu kuas kin ber 50-pela kuawo segine bu nu kuari nu Abraham guqoid pre!” ");
INSERT INTO kms_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisas oyi nand nari, “Nge nungoqi nganyene simbe guduq, Abraham ni nas segine kin tende puayi nge kas!” ");
INSERT INTO kms_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jisas ni pugri puq nand kin te ningg di ni wet materi ei Jisas mi ningg, pudi Jisas God ningg baj te si niraq di aye pe suqo no. ");
INSERT INTO kms_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas nyinge nare no no, wuti iri ni asine kumo wuri wundi kin tende puayine ni rar nat kin tuqui segi ye te nas nuqoind. ");
INSERT INTO kms_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisas nikin wute ni ningg mari, “Tisa, tughene mai yembe runduw kin te ningg bu wuti nen rar nat kin tuqui segi, wuti nen o nikin kiyi kumo?” ");
INSERT INTO kms_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Muq Jisas nari, “Wuti nen o nikin kiyi kumo ningg mai segi. Pudi ni pugri puq reng ei te wute buagi ruqond di nei rimb te pugri God irine ni yumbo ren kin puq nen ye tuqui. ");
INSERT INTO kms_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Muq nginy nasene beghi yembe yuwon nganye wuti nge tiqi nundogh gadi kin ni ningg yembe te ei yembe bidiny. Muq burpoq rip ningg tumo di wuti iri yembe nand kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nge qi pe ven nde kasne kin ven nde puayi nge wute buagi mingg ti kin pugri.” ");
INSERT INTO kms_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas puq nand pre qi pe som nap, di sombaqe pe irinyi yembe nunduw, di wuti te rar pe nyang nimbig. ");
INSERT INTO kms_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Muq Jisas wuti te simbe nindig nari, “Nu yo wuye ngamo ire Siloam puq munduw kin tende wuye yaghe.” Pugri bu wuti te no wuye ngamo tende wuye naghe, di opu rar nat yumbo nuqond di mune baj pe no. (Wand puch Siloam ni puate te “wute tiqi bidom mo” kin pugri.) ");
INSERT INTO kms_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wuti te ni kimand di wute ninge ni asi pripri wute yumbo sang nipim muqoind kin ni pengu mand, “Wuti nen ni asi nas di yumbo sang nap kin tene bri?” ");
INSERT INTO kms_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ninge mari, “Nikinne qa.” Ninge mari, “Yewo, wuti nen ni temi gib irene mamb.” Pudi ni nikinne nari, “Nge wuti nungoqi wari kin tene qa.” ");
INSERT INTO kms_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Muq ni mari, “Pughe gri ate nu munene rar kuat?” ");
INSERT INTO kms_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wuti te oyi nand nari, “Wuti iri Jisas puq mindig kin ni sombaqe pe irinyi yembe nunduw, di nge nde rar pe nyang nimbiq, pre wuye ngamo ire Siloam puq buduw kin te ningg tiqi nundogh ko wuye kaghe, di opu rar kat.” ");
INSERT INTO kms_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Muq wuti te pengu mindig mari, “Wuti te muai?” Ni nari, “Nge nei gab segi.” ");
INSERT INTO kms_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Muq ni wuti asi rar nat segi ye te mitanyi Parisi nde mo. ");
INSERT INTO kms_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisas ni ngeri ire Sabat puq munduw kin tende puayi wuti te irinyi rar pe nyang nimbig di rar nat. ");
INSERT INTO kms_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pugri bu Parisi ni wuti te pughe gri ni munene rar nat kin te ningg pengu mindig. Di wuti te oyi nand nari, “Ni nge irinyi rar pe nyang nimbigh, di nge wuye kaghe, di muq nge rar kat.” ");
INSERT INTO kms_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wute Parisi kin ninge mari, “Wuti nen God nde pu nandi segi, te pugri ni Sabat lo ire gure nuaq.” Pudi ninge pengu mand mari, “Pughe gri ei wuti yumbo ur brequ nand kin ni wuti nen sabi nindig, di yumbo ur gre ye ninge asi bei nand kin te puq nen?” Pugri bu ni nei irene vise segi. ");
INSERT INTO kms_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Muq ni wuti asi rar nat segi kin te pengu mindig mari, “Wuti nen nu rar sabi nunduw kin nen ningg nu pughe puq ei guad?” Wuti te oyi nand nari, “Ni propet iri.” ");
INSERT INTO kms_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juda mingg wute nyamb kin ni wuti nen ni asi rar nat tuqui segi di muq ni rar nat ye wand te ni mari te nganyene puq mand segine. Ni kiyi kumo ningg mari rundo pre, muq ni mari te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ni pengu mindiny mari, “Wuti nen nungoqi wo bri? Wuti nen bu nungoqi wari ni asine kumo wuri wundi kin tende puayine rar nat segi ye? Pughe gri ate ni mune rar nat?” ");
INSERT INTO kms_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ni kiyi kumo oyi rind riri, “Wuti nen beghi wo di ni asi nas kin tende puayine rar nat segi ye. ");
INSERT INTO kms_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pudi pughe gri ni munene rar nat o wuti tughe sabi nindig di munene rar nat kin te beghi nei bab segi. Ni nikinne pengu wundig. Ni quayi kin di nikinne simbe nand ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ni kiyi kumo ni Juda mingg wute nyamb kin te wune rimbim, te pugri ni asine mari wuti iri Jisas ningg Kraist puq nand, tedi ni God yumbui nyamb rirang kin baj pe tende ane ris segi. ");
INSERT INTO kms_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pugri bu kiyi kumo ni riri, “Ni quayi kin. Nikinne pengu wundig.” ");
INSERT INTO kms_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Muq mune nganye wuti Jisas sabi nindig di mune rar nat kin te ningg mari nandi, simbe mindig mari, “God nde nyamb pe nu beghi nganyene simbe ndug, te pugri beghi nei bab wuti nen yumbo ur brequ nand ye.” ");
INSERT INTO kms_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wuti te oyi nari, “Nge nei gab segi, wuti te yumbo ur brequ nand ye o segi. Pudi yumbo ire nge nei gab te pugri nge asi rar kat kin tuqui segi, muq nge rar kat!” ");
INSERT INTO kms_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Muq ni pengu mindig mari, “Ni nu pughe sim new? Ni nu pughe gri sabi nunduw bu muq nu rar kuat?” ");
INSERT INTO kms_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wuti te oyi nand nari, “Nge nungoqi simbe guduq pre, di nungoqi wutungu segi. Pughe ningg nungoqi munene wutungu ningg wari? Nungoqi ni ningg wute ningg was ningg bri?” ");
INSERT INTO kms_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Muq ni umbo sange wand mand di mari, “Nu wuti te ningg wand kutungu ye! Beghi Moses ningg wand putungu ye! ");
INSERT INTO kms_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Beghi nei bab te pugri Moses ni God temi wand, pudi wuti te ni nandi kin sunyi te beghi nei bab segi.” ");
INSERT INTO kms_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wuti te oyi nand nari, “Te pughe gri nganye ate! Ni nandi kin sunyi te nei wamb segi, pudi ni nge sabi nindigh di muq nge rar kat. ");
INSERT INTO kms_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Beghi nei bab, God ni wute yumbo ur brequ mand ye ni mingg wand nutungu kin tuqui segi. Ni wute God yumbui nyamb mirang kin di ni nari kin pugrine puq men kin ni mingg wandne nutungu ye. ");
INSERT INTO kms_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Beghi wuti iri ni asine kumo wuri wundi kin tende puayine rar nat kin tuqui segi ye te mune rar nat kin te putungu segine. ");
INSERT INTO kms_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wuti nen God nde pu nandi segi, tedi ni yumbo ren kin puq nen kin tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wuti te puq nand kin te ningg Parisi ni oyi mand mari, “Nu numo wuri wundi kin tende puayine nu yumbo ur brequ guad guad rindi muq. Pughe gri ate nu oyi beghi ren kin ningg simbe gudug!” Di wuti te wute pripri rikur God yumbui nyamb rirang kin pe tende ni ane nandi segi puq mindig. ");
INSERT INTO kms_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas ni wuti te wute rindi rikur God yumbui nyamb rirang kin tende ni ane nandi kin te ningg segi puq mindig kin wand te nutungu, di ni wuti te mune nuqoind kin tende puayi ni simbe nindig nari, “Nu wuti God nde pu nandi wuti nganye nas kin te nei gubig?” ");
INSERT INTO kms_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wuti te pengu nand nari, “Yumbui, wuti te tughene? Nge simbe ndigh ei te nge ni nei gibig.” ");
INSERT INTO kms_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas nari, “Nu ni guqoid pre. Ni nikinne qa nu tequ wand wand.” ");
INSERT INTO kms_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Muq wuti te nari, “Yumbui, muq nge nu nei gubuw.” Di ni Jisas yumbui nyamb nirang. ");
INSERT INTO kms_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Muq Jisas nari, “Nge wute ir kawo ningg bu qi pe gadi, ei te wute rar mat segi kin ni mune rar mat, di wute rar mat ye ni oyi rar mat ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Muq Parisi ninge ni ane yemu kin ni Jisas puq nand kin te mutungu di pengu mand, “Pughene? Beghi anene rar pat kin tuqui segi bri?” ");
INSERT INTO kms_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas nari, “Nungoqi rar wat tuqui segi, tedi nungoqi yumbo ur brequ wand kin te ningg mai ware segi. Pudi muq te pugri nungoqi wari nungoqi wuqond tuqui, pugri bu nungoqi mai te rise ye.” ");
INSERT INTO kms_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Muq Jisas ni Parisi simbe nindim nari, “Nge nungoqi nganyene simbe guduq, wuti iri ni sipsip yeru kin imb ngimrawu pe gri nar no segi, pudi aye pe gri newo naghe ye ni wuti nyungu kin. ");
INSERT INTO kms_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wuti ngimrawu pe gri nar no ye ni sipsip bag namb ye. ");
INSERT INTO kms_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wuti sipsip yeru kin imb te yeng nuaw ye ni ngim bi nuang nar no, nikin te sipsip ire ire nyamb nirany, nitari neyi ni, te pugri sipsip ni ningg gibe ko te rutungu. ");
INSERT INTO kms_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ni nikin te sipsip te nitari neyi ni, pre ni ye nawo, di sipsip dobu ruru, te pugri sipsip ni gibe ko te nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pudi ni wuti aye ni nei rimbig segi kin nde dobu ruru ye tuqui segi. Wute aye mondo di ni wu rise ruso, te pugri ni wute aye ningg gibe ko nei rimb segi.” ");
INSERT INTO kms_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas ni kopuqu wand ven simbe nand, pudi Juda mingg wute nyamb kin wand puate ni nei mamb segi. ");
INSERT INTO kms_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pugri bu Jisas munene nari, “Nge nungoqi nganyene simbe guduq, nge te sipsip yeru kin imb ngimrawu kin pugri. ");
INSERT INTO kms_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wute asine mandi pre nge gadi kin ni nyungu mbuaq di wute mambui yumbo mitanyri ye, pudi sipsip ni ningg wand rutungu segi. ");
INSERT INTO kms_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nge sipsip yeru kin imb ngimrawu kin pugri. Wute nge nde gri rir ruso ye ni yuwon pu ris ye. Ni rir ruso di riyi ri di qi puch nyungo ris kin te ruqond. ");
INSERT INTO kms_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wute nyungu ye ni nyungu mand ninggne mandi, di wute mamb riti di yumbo unje mipiny. Nge gadi kin te gadi ei te wute ris, di yuwon pu ris. ");
INSERT INTO kms_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nge sipsip bag gab kin wuti yuwon nganye. Wuti sipsip bag namb yuwon nganye ye ni sipsip ningg nati, ei te ni sipsip yuwon pu ris. ");
INSERT INTO kms_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wuti aye wong maind di nandi sipsip bag namb kin ni sipsip kiyi kin pugri bag namb segi. Pugri bu nyombui dabo kin nandi nuqoind kin tende puayi ni sipsip si nare yeru wu nase no. Muq nyombui dabo kin te nandi sipsip te nat di bure ire ire ruso. ");
INSERT INTO kms_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wuti te wu nase no, te pugri sipsip te ni te segi wuti aye te, pugri bu ni sipsip te oghine nei nimbiny segi. ");
INSERT INTO kms_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nge sipsip bag gab kin wuti yuwon ye. Nge wuyi nge nei nimbigh di nge ni nei gibig kin pugrine nge ning sipsip ni nge nei rimbigh, di nge ni nei gibiny, di nge ni ningg kati ye. ");
INSERT INTO kms_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nge sipsip aye yeru, pudi ni imb wen kin segi. Nge ni anene kitari ne gadi ye. Ni anene nge wand gad kin te rutungu ye, di sipsip tit irene yequ di wuti irine bag namb. ");
INSERT INTO kms_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Wuyi nge quan nganye yawo niragh righe ye puate taq pugri, nge kati di munene kes kewo ye. ");
INSERT INTO kms_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wuti iri nge ni kati segi, pudi nge ngening nde nei pene kati. Nge kati kin gre rise, di mune kes kewo kin gre rise. Nge wuyi ni nge pugri simbe nindigh.” ");
INSERT INTO kms_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisas ni puq nand kin te ningg Juda ni munene bir mawo opu opu yemu. ");
INSERT INTO kms_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wute quan mari, “Ququ brequ ninde nas, di ni jebo nand. Pughe ningg ni ningg wand putungu?” ");
INSERT INTO kms_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pudi ninge mari, “Wuti ququ brequ ninde nas kin ni pugri wand nand kin tuqui segi. Ququ brequ ni wuti rar nat tuqui segi kin sabi nindig munene rar nat ye tuqui segi.” ");
INSERT INTO kms_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Muq Jerusalem tende God ningg baj asi sabi munduw kin te ningg mir yembe mindiny. Tende puayi te uyi kin ngeri pe, ");
INSERT INTO kms_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","di Jisas ni God ningg baj pe tende wase ede iri Solomon te wase ede puq mindig kin tende tiq nyinge nare no. ");
INSERT INTO kms_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wute buagi rindi Jisas nde yeru yeru rundo rindi di riri, “Beghi wand nganyene kin ghimbi puany pu pas nganye ye bri? Nu Kraist ate nu beghi oghi pune simbe ndug.” ");
INSERT INTO kms_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas oyi nand nari, “Nge nungoqi simbe guduq pre, pudi nungoqi wari te nganyene segi. Nge simbe gad kin sambu taq te wuyi nde nyamb pe nungoqi yumbo ur gre ye bei guduq, ");
INSERT INTO kms_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","pudi nungoqi wari te nganyene segi. Te pugri nungoqi nge te sipsip segi. ");
INSERT INTO kms_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nge te sipsip ni nge wand gad kin te rutungu. Nge ni nei gibiny, di ni nge nde dobu ruwi. ");
INSERT INTO kms_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nge kari ni ris ris te kin ris di riti segi, di wuti iri nge nde si pe pu nateri ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nge wuyi ni nge sipsip ren negh kin ni quan nganye yumbui, wuti iri sipsip nge wuyi nde si nambu yeru kin nateri ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nge di nge wuyi temu beghi irene.” ");
INSERT INTO kms_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Muq wute Juda kin ni munene wet materi ei Jisas wet pe mi ningg, ");
INSERT INTO kms_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","pudi Jisas simbe nindim nari, “Nge yumbo ur gre ye wuyi nde pu rindi kin te nganye buagi bei guduq pre. Muq yumbo ur pughe ye puq ken kin te ningg bu nungoqi nge wet pe wi ningg?” ");
INSERT INTO kms_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ni oyi mand mari, “Beghi nu yumbo ur gre ye bei guad kin te ningg nu wet pe pi segi. Pudi nu God wand brequ gudig, te pugri nu beghi kin pugrine, muq nu kuari nu God tequ irene puq guad kin te ningg bu nu wet pe pi ningg.” ");
INSERT INTO kms_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas ni oyi nindim nari, “Nungoqi nde lo buk pe God ni puq nand nari, ‘Nge kari nungoqi god ningg was.’ ");
INSERT INTO kms_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Beghi nei bab God ningg wand buk pe vise kin ir vighe segi ye. God ni wute yabene ni ningg lo materi kin te god puq nindim, ");
INSERT INTO kms_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","pugri bu nge wuti God naip ko di tiqi nundogh gadi ye nge kari nge God ningg wo puq gad kin te ningg nungoqi wari nge God wand brequ gidig puq wand kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nge wuyi ni puq nen kin te puq ken segi, tedi piyi nge nei wumbigh wayequ. ");
INSERT INTO kms_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pudi nge wuyi yumbo puq nen kin te puq ken di nge wand gad kin te nganyene puq wand segi, tedi piyi nungoqi nge yumbo ur gre ye bei gad kin te oyi nganyene puq wand, te ei nungoqi nei wamb wuyi nge nde nas di nge ninde kas.” ");
INSERT INTO kms_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Muq munene Jisas mait nase ningg, pudi ni wu nase no. ");
INSERT INTO kms_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Muq Jisas ni wuye Jordan nisiny opu gri Jon ni asi wute wuye nap kin tende no. Ni tende nas, ");
INSERT INTO kms_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","di wute nganye buagi ninde rundo. Ni riri, “Jon ni yumbo ur gre ye bei nand segi, pudi ni wuti nen ningg simbe nand kin wand buagi te nganyene.” ");
INSERT INTO kms_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Di wute nganye buagi tende ris kin ni Jisas nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Muq wuti iri Lasarus puq mindig kin ni num gureg pu nase. Lasarus ni Maria di ni kunyumbu Marta ane tiqe irene. Ni tiqe nyamb te Betani. ");
INSERT INTO kms_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria wen te Lasarus muq num gureg pu nase kin ni kunyumbu, di wute wen ne otiwo wel Yumbui nde nyinge pe nyang wumbig, di yu pe ku wumbig ye. ");
INSERT INTO kms_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Muq Marta Maria teri Jisas nde wand ri viso di riri, “Yumbui, nu nimand yawo gurag righe kin Lasarus num gureg.” ");
INSERT INTO kms_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisas ni te nutungu nari, “Num kuen ningg ni nati segi ye. God ni gre te bei nand ningg bu ni pugri puq reng, ei te wute buagi te ruqond di ni te kin ningg God ningg wo nyamb rindivi viyo.” ");
INSERT INTO kms_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ni Maria, Marta di Lasarus ane quan nganye yawo nirany righe. ");
INSERT INTO kms_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pudi ni Lasarus num gureg kin wand te nutungu kin tende puayi ni no nuqoind segi, ni pugrine nas nginy aye temi nawo. ");
INSERT INTO kms_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Muq Jisas ni nikin wute te simbe nindim nari, “Wandi munene Judia po.” ");
INSERT INTO kms_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pudi ni oyi mari, “Tisa, kambe tene pugri Juda te kin ni nu wet pe mi ningg, di muq munene tende kuo ningg kuari?” ");
INSERT INTO kms_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas oyi nand nari, “Nginy irine ni aua 12-pela pu. Pugri bu wuti bogisumb nyinge nare ye ni oghine nyinge nare di nyinge nap yeru segi, te pugri ni qi wen kin ti nuqond, di ti te ningg ni nyinge nare. ");
INSERT INTO kms_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ni burpoq pu nyinge nare kin tende puayi bu ni oghine nyinge nare segi di nyinge nap yeru, te pugri ni ti nase nuqond segi.” ");
INSERT INTO kms_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas ni ren kin simbe nand pre ni nari, “Beghi mand Lasarus ni ruqo nase, pugri bu nge tende ko ei buraq gidig mune nes newo ye.” ");
INSERT INTO kms_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jisas nikin wute te oyi mari, “Yumbui, ni ruqo nase, tedi mune oghi ye.” ");
INSERT INTO kms_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas ni Lasarus nati kin te ningg bu nari ruqo nase, pudi nikin wute mari muq ni nganyene bu ruqo nase puq mand. ");
INSERT INTO kms_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pugri bu ni oghine simbe nindim nari, “Lasarus ni nati, ");
INSERT INTO kms_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","di nge ko ni guqoid segi ye te ningg nge chumbuai gad, te pugri nge ko segi ei nungoqi te wuqond di God nei wumbig. Pudi muq wandi ni nde po.” ");
INSERT INTO kms_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Muq Tomas ni Jisas ningg wute aye te simbe nindim nari, “Beghi anene po ei ni ane pati.” (Tomas ni nyamb aye taq Didimus.) ");
INSERT INTO kms_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisas no Betani nitari righe kin tende puayi wute ninge ni simbe mindig mari ni Lasarus mowi yenu ye nginy 4-pela pu mo pre. ");
INSERT INTO kms_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalem pu Betani te 3 kilomita kin pugri, ");
INSERT INTO kms_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","di Juda kin wute nganye buagi rindi Maria di Marta ane ris, ni teri umbo reny kughe ei ni teri kinyimi nati ye te ningg quan nganye yivany rire segi. ");
INSERT INTO kms_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta wutungu Jisas ninde baj pe tumo nondo di baj si wure wuyi wi ei Jisas wuqoind ningg, pudi Maria ni baj pene wur wus. ");
INSERT INTO kms_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Muq Marta Jisas ningg wuri, “Yumbui, nu keine ven ghandi, tedi Lasarus nati segi. ");
INSERT INTO kms_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pudi nge nei gab te pugri muqne nu yumbo ninge ningg God pengu ndig di ni new ye.” ");
INSERT INTO kms_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisas Marta simbe nunduw nari, “Nu nyimi mune nes newo ye.” ");
INSERT INTO kms_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta oyi wund wuri, “Nge nei gab otiwo qi wen prene kin tende puayi wute mati ye mune mes mewo di ni ane nes newo ye.” ");
INSERT INTO kms_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas simbe nunduw nari, “Nge wute mati kin gidimi mewo di nge kari ni mas ye. Wute nge nei rimbigh ye ni piyi riti, pudi ris ye. ");
INSERT INTO kms_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Di wute risne di nge nei rimbigh kin te ni riti segi ye. Nge puq gad kin te nu kuari nganye bri?” ");
INSERT INTO kms_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta Jisas simbe wundig wuri, “Yumbui, nge kari te nganyene, te pugri nu Kraist, God ningg wo, di wuti qi pe nandi ye puq mand kin wuti te.” ");
INSERT INTO kms_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Di Marta ni pugri puq wund pre ni munene baj pe wuso di Maria waghi grine simbe wunduw wuri, “Tisa nandi pre, di ni nu ningg pengu nand.” ");
INSERT INTO kms_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ni wand te kin wutungu ni brequne wes wiyo Jisas nde wuso. ");
INSERT INTO kms_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ni tiqe te ningg nar no segine, pudi ni asi yenu Marta wundo wuqoind teri wand kin sunyi pe tendene yenu. ");
INSERT INTO kms_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wute Juda kin ninge Maria umbo rew kughe ningg ruso pu ni ane baj pe ris kin ni Maria brequne wes wiyo di dabo wuyi wi kin te rundoq, di ni nei rimb kin ni Lasarus nde ngamo pe wuso ei quanji wund ningg bu wuso, di ni res riwo dobu ruru. ");
INSERT INTO kms_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria wuso Jisas nde wutari righe di wuqoind kin tende puayi ni Jisas nyinge tingine pombri wuso wuse di wuri, “Yumbui, nu keine ghandi tedi Lasarus nati segi.” ");
INSERT INTO kms_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas ni Maria quanji wund di wute Juda kin ninge Maria ane rundo kin te anene quanji rind nuqond kin tende puayi ni umbo pe quan nganye yivany nare. ");
INSERT INTO kms_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Muq ni pengu nand nari, “Nungoqi Lasarus muainde pe bu wowi yenu?” Ni oyi rind riri, “Yumbui, nu ghandi di qond.” ");
INSERT INTO kms_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas quanji nand. ");
INSERT INTO kms_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Muq wute Juda kin ni riri, “Te wuqond, ni Lasarus quan nganye yawo nirang righe, pugri bu ni quanji nand.” ");
INSERT INTO kms_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pudi ninge riri, “Nikinne qa wuti rar nat segi kin te sabi nindig mune rar nat ye. Ni asine nandi tedi Lasarus sabi nindig kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas ni mune nganye umbo pe yivany nare, di Lasarus mowi yenu kin sunyi pe tende no. Lasarus mowi yenu kin te rand sange pe qi bir muaq mar mo pre, wuti minar no pu nase, di wet yumbui ire mitaqwi gawo te chupoq mindiq. ");
INSERT INTO kms_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas nari, “Wet nyaw te kring wupiq wuso.” Pudi Lasarus ni kunyumbu Marta ni wuri, “Yumbui, muqdi brequ tuqo neri ye, te pugri ni powi yenu kin nginy 4-pela pu mo pre.” ");
INSERT INTO kms_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Muq Jisas nari, “Nge kari nu God nei mbig, tedi nu God ningg gre pe di ni yuwon pughe gri nas kin te qond, te nu simbe guduw segine bri?” ");
INSERT INTO kms_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pugri bu ni wet kring mipiq wuso. Jisas wam rar new wiyo di nari, “Wuyi, nge nu chumbuai guduw, te pugri nu nge kari kin te kutungu pre. ");
INSERT INTO kms_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nge nei gab, nu priprine nge kari kin te kutungu ye, pudi nge muq puq gad ei wute ren yeru kin rutungu ei riri nu nge tiqi gudogh gadi kin te nganyene puq rind.” ");
INSERT INTO kms_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas ni pugri puq nand pre quan kumone nari, “Lasarus, gheyi yi!” ");
INSERT INTO kms_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Muq wuti nati kin te nyinge nare neyi ni, ni si di muange ane chongo bidi pe wureq rimbig, di chongo aye quenge pe wureq rimbig. Muq Jisas nari, “Ni chongo te bure wundig, di si weri no.” ");
INSERT INTO kms_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pugri bu Juda kin wute buagi Maria rundoq ningg rindi kin ni Jisas Lasarus mune nindingi newo kin te ruqond, di te ningg ninge ni nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pudi ninge Jisas ni yumbo ur puq nen kin te ningg ruso Parisi simbe rindim. ");
INSERT INTO kms_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Muq prist mingg yumbui ninge di Parisi ane mo Juda mingg kaunsil mari mandi ni ane wand mand. Muq ni mari, “Beghi pughe kin ningg ni rar buqoid? Wuti nen yumbo ur gre ye nganye buagi nganye bei nand. ");
INSERT INTO kms_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Beghi ni rar buqoid puq nen, tedi wute buagi ni nei rimbig, di Rom ni mandi beghi tiqe di qi ane mitanguri.” ");
INSERT INTO kms_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Muq ni wuti iri ni nyamb Kaiapas, ber te ningg ni prist mingg yumbui mingg yumbui, ni nari, “Nungoqi nei wamb segi. ");
INSERT INTO kms_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wuti irine nungoqi buagi ane ningg nati ye, di wute buagi oyi mati segi te yuwon. Nungoqi te kin nei wumbiny segi.” ");
INSERT INTO kms_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ni puq nand kin te nikin nei pene puq nand segi, pudi ber te ningg ni prist mingg yumbui mingg yumbui, pugri bu ni propet kin pugri yumbo otiwo kin te ningg simbe nand, te pugri otiwo Jisas ni Juda mingg nati ye. ");
INSERT INTO kms_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Di Juda minggne ni nati segi, pudi God ningg wo buagi qi pe ris kin te anene ningg nati, ei te ni kring nap rindi di ni ane irene ris. ");
INSERT INTO kms_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Muq tende puayine ni Jisas mi nati ningg wand taq mamb. ");
INSERT INTO kms_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pugri bu Jisas ni mas pe raqene nyinge nare segi. Pudi ni qi puch ire wuye di nyumo segi ye pe tumo yequ kin tende opu no, di ni nikin wute ane tiqe ire Epraim puq munduw kin tende mas. ");
INSERT INTO kms_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","God asi Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny ye te tumo rind kin tende puayi wute wonji mas kin quan buagine Jerusalem mo, ei ni mai rise kin te puaq mand, di God nde rar pe ni yuwon pu mas pre, ei ni God asi Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny. ");
INSERT INTO kms_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ni God ningg baj pe mar yemu di Jisas rar miting mitingne yemu, di oyi oyi pengu mand mari, “Nungoqi nei wamb kin pughe gri, ni mir pe nandi o segi?” ");
INSERT INTO kms_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pudi prist mingg yumbui di Parisi ni pugri simbe mand mari, wuti iri Jisas nuqoind tedi ni simbe nand ei te ni mait nase. ");
INSERT INTO kms_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","God asi Israel mingg wo rar nuqond mas ye te muq nginy aye 6-pela pre di ngeri te nei mimbiny. Tende puayi Jisas ni tiqe ire Betani, Lasarus nas kin pe tende no nitari righe. Lasarus taq teneqa nati di Jisas mune nindingi newo. ");
INSERT INTO kms_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Muq tende ni Jisas nde nyamb pe mir wase ruwo ei ane mir rind ningg. Marta ni wute mir wem di Lasarus ni Jisas di wute aye ninge ane tebol pe mas. ");
INSERT INTO kms_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Muq Maria ni wel yuwon nganye iri nyumo nad puq mindig kin pe yembe mindig di wet bidi yumbui pe wong wuind kin te wuti nowi, di quanene Jisas nde nyinge pe groq wundig. Pre, ni nikin yu pe nyinge ku wumbig. Di ni ris kin baj pe te wel tuqo paqe muet rimb. ");
INSERT INTO kms_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pudi Jisas nikin wutine iri ni otiwo Jisas veri nde si pe ni nondo ye, ni nyamb Judas Iskariot, ni nari, ");
INSERT INTO kms_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Pughe kin ningg nungoqi wel wute aye wem wong maind di wet bidi te wateri wute yumbo segi kin te weny segi? Wel nen ni wet bidi te wuti iri yembe nand ruso ber ire pre ni wet bidi nateri kin ane tuquine.” ");
INSERT INTO kms_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ni puq nand kin te ni wute yumbo segi kin te nei nimbiny muq puq nand segi, pudi ni nyungu nand ye. Te pugri asi ni wet bidi bek nitiq wuse ye, di tende puayi wute wet bidi ruwo righe kin te ni ninge nateri ye. ");
INSERT INTO kms_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Muq Jisas oyi nari, “Rar wundoq, ni wel te otiwo nge kati di mowi yengu ei nyang wumbigh ningg bu nase. ");
INSERT INTO kms_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wute yumbo segi kin nungoqi ane was ye, pudi nge nungoqi ane pas nganye segi ye.” ");
INSERT INTO kms_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Muq Juda kin wute nganye buagi ni rutungu Jisas tende nas di ni tende rundo. Ni Jisas ninggne tende rundo segi, pudi Lasarus nati pre di Jisas mune nindingi newo kin te ruqoind ningg ane bu rundo. ");
INSERT INTO kms_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pugri bu prist mingg yumbui ni wand wand mare, ei Lasarus anene mi nati ningg, ");
INSERT INTO kms_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","te pugri Jisas ni nindingi newo kin te ningg bu Juda kin wute nganye buagi Jisas nde ruso di Jisas nei rimbig. ");
INSERT INTO kms_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yambgriq wute buagi mir pe tende rindi kin ni rutungu Jisas ni Jerusalem nandi. ");
INSERT INTO kms_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ni chubair raqe riteri, rire ninde rundo di riri, “Hosana! God nu wuti Yumbui nde nyamb pe nandi kin nen yuwon wang! God nu Israel mingg king nen yuwon wang!” ");
INSERT INTO kms_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Jisas ni donki ghair iri nuqoind di donki pe no. “Wute Jerusalem kin nungoqi wune wamb wayequ, nungoqi king ni donki ghair pe newo pu nas di nandi ye.” Yumbo ren kin te God ningg wand buk pe rise kin pugrine Jisas mune puq nen. ");
INSERT INTO kms_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tende puayine Jisas nikin wute ni ren nei mimbiny segi, pudi Jisas ni nati pre mune nes newo kin tende dobu muq ni nei mamb te pugri wand buk pe vise kin di yumbo ren puq ren kin te ni ningg puq wund. ");
INSERT INTO kms_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Muq wute buagi Jisas ane yeru kin ni Jisas Lasarus ngamo pe pu ngam nirang di mune nindingi newo kin wand te wute aye mune simbe rindiny rindinyne. ");
INSERT INTO kms_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wute nganye buagi ni Jisas yumbo ur gre ye wen bei nand kin te rutungu ye te ninggne ni riyi ri Jisas ruqoind. ");
INSERT INTO kms_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pugri bu Parisi ni oyi oyi wand wand mare mari, “Te wuqond, beghi yumbo ninge puq pen kin tuqui segi. Wute buagi wuti tende dobu ruru!” ");
INSERT INTO kms_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wute mir pe mas kin te Grik kin ninge ni anene mondo God yumbui nyamb mirang. ");
INSERT INTO kms_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Muq ni Pilip nde mondo mari, “Pilip, beghi Jisas buqoid ningg.” (Pilip ni Betsaida, Galili opu ye.) ");
INSERT INTO kms_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip no Andru simbe nindig. Andru di Pilip temi anene mo Jisas simbe mindig. ");
INSERT INTO kms_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pudi Jisas ni oyi nindim nari, “God ni nge ninde pu gadi wuti nganye kas kin nge wuti yumbui pughe gri kas ye te bei nand kin ngeri te muq rindi pre. ");
INSERT INTO kms_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nge nungoqi nganyene simbe guduq, wit yi ni qi pe ir wughe segi, tedi ni yi irene wuse kin tene wuse. Pudi wit yi ni qi pe ir wughe ni mune yiraq, tedi yi aye nganye buagi rise. ");
INSERT INTO kms_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wuti nikin ghimbi quan nganye nei nimbiny kin, ni ghimbi te si nare ye. Pudi wuti iri wute aye ghav nindiny ningg nikin ghimbi nei nimbiny segi ye, tedi ni nas nas te kin nas. ");
INSERT INTO kms_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wute nge ni mingg yumbui kas ningg mari ye, ni ngende ei mandi, di nge muainde kas te nge te yembe ye wute ni anene tende mas ye. Nge wuyi ni wute nge ni yumbui ningg kas ningg riri ye ni nyamb nindiri riwo ye. ");
INSERT INTO kms_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Muq nge umbo pe brequ rise, di nge pughe puq ei gad? Nge kari, ‘Wuyi nge mai wen puaq ndigh,’ puq bri gad? Yewo. Puate taq te ningg bu nge gadi. ");
INSERT INTO kms_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wuyi, nu wuti yuwon pughe gri kuas kin te wute bei yeny!” Muq wuti iri nginy tu pe gri nari, “Nge wuti yuwon pughe gri kas kin te bei gad pre, di munene bei gad ye.” ");
INSERT INTO kms_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wute buagi tende yeru di wand te rutungu ye ni riri te kimereg bu naghe. Ninge riri angelo iri nandi, Jisas wand simbe nindig. ");
INSERT INTO kms_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisas oyi nand nari, “Wand ven te nungoqi wutungu ningg bu simbe nand, nge segi. ");
INSERT INTO kms_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Muq God ni wute ni nei rimbig segi kin di qi wen kin yumbo ur brequ te ir nawo ye. Muq God ni ququ brequ qi wen kin yumbui te bures naip no ye. ");
INSERT INTO kms_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pudi nge qi pe pu mindingi kewo qungu mi kati ye tende puayi nge wute buagi kring kap nge nde rindi ye.” ");
INSERT INTO kms_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ni puq nand kin te otiwo ni pughe gri mi nati kin te ningg simbe nand. ");
INSERT INTO kms_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wute buagi mari, “Beghi putungu pre te pugri lo wuri Kraist ni nas nas te kin nas ye, pughe gri ate nu kuari, ‘Wuti God nde pu nandi wuti nganye nas ye ni qungu mi nati ye’? Wuti God nde pu nandi ye te tughene?” ");
INSERT INTO kms_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Muq Jisas simbe nindim nari, “Nungoqi nde ti nase pre di muq pre ningg tumo. Ti nase kin tende puayine nungoqi nyinge ware, eti burpoq rip. Wuti burpoq wabe nyinge nare kin ni mong nuqond segi. ");
INSERT INTO kms_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nungoqi nde ti nase kin tende puayine nungoqi te ti te nei wumbig ei te nungoqi ti ningg wo ningg was.” Jisas ni wand simbe nand prene kin tende puayi ni wute buagi si nare di ni ningg suqo no. ");
INSERT INTO kms_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas ni wute buagi nde rar pene yumbo ur gre kin buagi te bei nand, pudi wute nganye buagi ni nei rimbig yambu riri. ");
INSERT INTO kms_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ni pugri puq ren kin te propet Aisaia ni ningg wand te ane tuquine. Aisaia ni nari, “Yumbui, wuti iri beghi wand simbe bad kin te nutungu di ni nari te nganye puq nand segi. Di tughene Yumbui ni gre te bei nand kin te nuqond? Te segi.” ");
INSERT INTO kms_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ni wand te rutungu pudi riri te nganyene puq rind kin tuqui segi ye puate taq pugri, Aisaia ni wand aye ninge simbe nand kin nari, ");
INSERT INTO kms_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God ni rar chupoq nindiny di rar rit kin tuqui segi, di nei imb nuany di nei rimb kin tuqui segi, te pugri eti ni God nde rindi di ni mune sabi nindiny.” ");
INSERT INTO kms_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia ni puq nand kin te ni Jisas wuti yumbui pughe gri nas kin te nuqond pre di te kin ningg simbe nand. ");
INSERT INTO kms_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pudi ni simbe nand nand kin tende puayine Juda mingg wute nyamb kin ninge ni nei mimbig. Pudi ni Parisi ningg wune mamb, pugri bu ni Jisas nei mimbig kin te raqene simbe mand segi. Te pugri ni simbe mand di God yumbui nyamb mirang kin baj pe tende ni ane mo segi puq mindim. ");
INSERT INTO kms_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Te pugri ni wute gri ei ni nyamb mindiri riwo yawo kurem, God gri ni nyamb nindiri riwo segi. ");
INSERT INTO kms_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Muq Jisas quan kumone nari, “Wuti iri nge nei nimbigh, tedi ni ngene nei nimbigh segi, pudi wuti nge tiqi nundogh gadi kin ni nei nimbig. ");
INSERT INTO kms_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ni nge nde rar neq wundi kin tende puayi ni wuti nge tiqi nundogh gadi kin te nuqoind. ");
INSERT INTO kms_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nge ti kin pugri qi pe gadi, ei wute nge nei rimbigh ye ni burpoq pe ris segi. ");
INSERT INTO kms_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Wute nge wand rutungu pudi pugrine puq ren segi ye, nge te kin ningg ni ir kawo segi. Te pugri nge wute unje rip kin te ningg ir kawo ningg gadi segi, pudi nge wute kateruwi ningg bu gadi. ");
INSERT INTO kms_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wute nge wand gad kin rutungu segi di pugrine puq ren segi ye te yumbo irene ni te kin ningg ir wuwo ye. Te pugri wand buagi nge simbe gad kin ren ne ei otiwo ngeri pre kin tende puayi ni unje rip kin te ningg simbe rind. ");
INSERT INTO kms_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Te pugri nge ngening nde nei pene wand ren simbe gad segi, pudi wuyi nge tiqi nundogh gadi kin ni nari nge wand simbe gad, di ni wand simbe nand kin pugrine nge simbe gad. ");
INSERT INTO kms_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nge nei gab ni nari nge wand simbe gad kin te wute ghav rindiny di ni ris ris te kin ris ye. Pugri bu yumbo buagi nge simbe gad kin te wuyi nge yeri nindigh bu nge simbe gad.” ");
INSERT INTO kms_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nginy aye irine pre tende dobu di God asi Israel mingg wo rar nuqond mas ye ngeri te nei mimbiny kin te ningg mir mand. Pudi te segine Jisas ni nei namb pre te pugri ni qi wen si niraq di munene kiyi nde no kin ngeri te tumo rind. Ni wute qi pe ven nde ris ye ni ningg wand rutungu di pugrine puq ren kin quan nganye yawo nirany righe, di muq ni wute quan nganye yawo nirany righe kin te bei nand. ");
INSERT INTO kms_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yuram Jisas nikin wute ane irepene mikur mas mir mand, di ququ brequ mingg yumbui ni Judas Iskariot, Saimon ningg wo, ni Jisas veri nde si pe ni nondo kin nei neng pre. ");
INSERT INTO kms_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas ni nei namb pre te pugri kiyi ni asine yumbo buagi ninde si pe ni rundo pre, di ni God nde pu nandi di otiwo God nde mune no ye, ");
INSERT INTO kms_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","pugri bu ni nes newo chongo niraq wughe kin te ir nuaq, di taul ire apqe pe taq nimbiq. ");
INSERT INTO kms_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pre nand, wuye nyeng pe nawo kughe, muq nikin wute te nyinge wuye nipim di taul apqe pe taq nimbiq pu wuse kin tende wuye giji ku nimbim. ");
INSERT INTO kms_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ni nyinge wuye nipim nipim nandi nandi di Saimon Pita mune nyinge wuye niping ningg, di Saimon Pita nari, “Yumbui nu nge nyinge wuye pigh wayequ.” ");
INSERT INTO kms_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisas oyi nand nari, “Nge yumbo ren puq ken kin ren nu muq nei guab segi, pudi otiwo di nei ghamb.” ");
INSERT INTO kms_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita nari, “Yewo, nu nge nyinge wuye pigh wayequ.” Jisas oyi nand nari, “Nge nu nyinge wuye kupuw segi, tedi nu nge te yembe ye wuti segi.” ");
INSERT INTO kms_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita oyi nand nari, “Yumbui, te kin ye be, pudi nyingene segi, si di ngawu anene wuye ghap!” ");
INSERT INTO kms_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas oyi nand nari, “Wute wuye maghe pre kin ni nyingene ei wuye map, ni ghimbi buagi te puqum rise segi. Di nungoqi puqum segi yuwon pu was, pudi nungoqi buagi ane segi.” ");
INSERT INTO kms_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas ni wuti pughe ye ni veri nde si pe ni nondo ye ni nei namb pre, pugri bu ni nari, “Nungoqi puqum segi yuwon pu was, pudi nungoqi buagi ane segi.” ");
INSERT INTO kms_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas ni nikin wute te nyinge wuye nipim pre, nikin chongo mune niraq wughe, di asi nas kin sunyi pe mune no. Muq ni pengu nindim nari, “Nge yumbo ren puq ken kin puate nungoqi nei wamb? ");
INSERT INTO kms_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nungoqi nge tisa di yumbui puq wundigh kin te tuquine qa puq wand, te pugri nungoqi wari kin te nge teneqa. ");
INSERT INTO kms_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nge nungoqi tisa di yumbui, pudi nge wuti nyamb segi kin pugri nungoqi nyinge wuye kupuq pre, pugri bu nungoqi mune pugrine oyi oyi nyinge wuye wap. ");
INSERT INTO kms_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nge puq ken ei nungoqi te wuqond di nge puq ken kin pugrine puq wen. ");
INSERT INTO kms_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nge nungoqi nganyene simbe guduq, yembe ye wuti ni oyi yumbui di wuti ninde yembe nand kin ni oyi ninde si nambu nas kin tuqui segi. Di wuti wand nare ye ni oyi yumbui di wuti ni tiqi nundog no ye ni oyi ninde si nambu nas tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Muq nungoqi yumbo ren nei wumbiny pre, nungoqi pugrine puq wen tedi God nungoqi yuwon nuauq. ");
INSERT INTO kms_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nge puq gad kin te nungoqi quan buagine ningg puq gad segi. Nge wute ir kawo nge nde dobu maru kin te nge ni nei gibim. Pudi nge simbe gad kin te pugri ei God ningg wand buk pe vise kin ven, ‘Wuti nge ane bret puch puch paq kin ni nge veri,’ puq wund kin te ane tuquine. ");
INSERT INTO kms_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Nge nungoqi muqne simbe guduq pre muqdi yumbo te kin puq ren, ei te yumbo te puq ren kin tende puayi nungoqi nei wamb te pugri nge wuti God nde pu gadi wuti nganye kas kin tene, aye segi. ");
INSERT INTO kms_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nge nungoqi nganyene simbe guduq, wuti pughe ye wute nge tiqi gudom mo ye nate mowi ye ni nge neti kowi, di wuti nge neti kowi ye ni wuti nge tiqi nundogh gadi ye neti nowi.” ");
INSERT INTO kms_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas puq nand pre, ni nei mai viwo, di simbe nand nari, “Nge nungoqi nganyene simbe guduq, nungoqi kin iri ni nge veri nde si pe ni godo ye.” ");
INSERT INTO kms_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jisas ni puq nand kin te ningg nikin wute oyi oyi rar mat, ni nei mamb segi Jisas tughe ningg bri puq nand. ");
INSERT INTO kms_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas ningg wute te kin ye iri, Jisas nikin quan nganye yawo nirang righe ye, ni Jisas nde tumone nas. ");
INSERT INTO kms_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pugri bu Saimon Pita ni ngawu puraq nindig nari, “Nu Jisas pengu ndig, ni tughe ningg bu puq nand.” ");
INSERT INTO kms_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Muq wuti te Jisas nde tumo kring nondo, pengu nindig nari, “Yumbui, tughene bu?” ");
INSERT INTO kms_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas oyi nand nari, “Wuti te nge bret puch wen nyeng pe keq wughe pre kitaqwi geg ye.” Muq ni bret puch nyeng pe neq wughe pre nitaqwi Judas Iskariot, Saimon ningg wo neng. ");
INSERT INTO kms_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ni bret te nitiq wuse pre, muq Satan ninde nar no. Muq Jisas ni simbe nindig nari, “Nu yumbo puq kuen puq guad kin te brequne puq yen.” ");
INSERT INTO kms_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pudi wute mir pe tende mas kin ni nei mamb segi, Jisas ni pughe ningg bri puq nand. ");
INSERT INTO kms_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ni Jisas ningg wute buagi mingg wet bidi nat rise ye, pugri bu ninge ni nei mamb kin mari muqdi Jisas ni tiqi nundog no ei mir te kin ye wong nand, o wute yumbo segi ye te yumbo ninge nem ningg bu ni no yumbo wong nand. ");
INSERT INTO kms_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas bret te nitaqwi pre, di opu nes newo no. Di burpoq rip pre. ");
INSERT INTO kms_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ni no pre, Jisas nari, “Muq nge, wuti God nde pu gadi wuti nganye kas kin, nge gre yuwon kin te bei gad, di nge puq ken kin te ningg God ni gre yuwon kin te bei gad wute buagi ruqond. ");
INSERT INTO kms_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nge wuti nganye kas kin nge God ningg gre yuwon kin te bei gad, di wute buagi God nyamb rindivi viyo tedi God ni nge wuti nganye kas kin nge gre yuwon kin te wute bei neny, di ni nge nyamb rindivi viyo. Di te bei nand ye muq tumo rind. ");
INSERT INTO kms_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Nge wo, muq nge nungoqi ane pas chiraq nganye tuqui segi. Nge asi Juda ninge simbe gidim kin pugrine nungoqi mune simbe guduq, nungoqi nge meri wutigh ye. Pudi nge ko kin pe te nungoqi waru tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Muq nge nungoqi yeri guduq, asi nge nungoqi pugri yeri guduq segi. Wute aye te oyi oyi yawo wurany righe. Nge nungoqi yawo kirauq righe kin pugrine nungoqi wute aye oyi oyi yawo wurany righe. ");
INSERT INTO kms_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nungoqi wute aye oyi oyi yawo wurany righe, tedi te kin ningg wute buagi nei rimb nungoqi nge te wute.” ");
INSERT INTO kms_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita nari, “Yumbui, nu muai nde kuo?” Jisas oyi nand nari, “Nge ko ye pe te nu muq gharu kin tuqui segi, pudi otiwo nu gharu ye.” ");
INSERT INTO kms_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita nari, “Yumbui, pughe kin ningg nge muqne nu nde karu tuqui segi? Nge nu ningg kati ye tuqui.” ");
INSERT INTO kms_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Muq Jisas nari, “Nu nganyene nge ningg kuati ye tuqui? Nge nu nganyene simbe guduw, wapiqu nari segine di nu ghari nu nge nei gubigh segi puq ghand tevi ire pu ghand ye.” ");
INSERT INTO kms_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Muq Jisas nikin wute te simbe nindim nari, “Nungoqi yivany ware wayequ. Nungoqi God ei nei wumbig di nge anene nei wumbigh. ");
INSERT INTO kms_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nge wuyi ningg baj pe sunyi nganye buagi rise, segi tedi nge muq nungoqi simbe guduq segi. Nge tende ko ei nungoqi sunyi kupuq ruso. ");
INSERT INTO kms_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nge nungoqi sunyi kupuq ruso, tedi munene gadi nungoqi kitaqu nge kas kin sunyi pe tende ko. ");
INSERT INTO kms_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nungoqi ngim tiqe nge ko ye pe wuso kin te nei wamb ye.” ");
INSERT INTO kms_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Muq Tomas Jisas ningg nari, “Yumbui, beghi nu kuo ye tiqe te nei bab segi. Pughe gri ei beghi ngim te nei bubuw?” ");
INSERT INTO kms_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas oyi nand nari, “Nge nde gri wute God nei rimbig, di nge nde gri wute God nganyene pughe gri nas kin te nei rimb. Di nge nde gri wute ris ris te kin ris. Wuti iri ngim aye pe gri wuyi nde nandi segi, nge nde grine. ");
INSERT INTO kms_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nungoqi nganyene nge nei wumbigh, tedi nge wuyi anene nei wumbig. Muqne nungoqi ni nei wumbig di wuqoind pre.” ");
INSERT INTO kms_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip nari, “Yumbui, nu beghi wuyi bei yengu, tedi beghi umbo yuwon gud.” ");
INSERT INTO kms_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas oyi nand nari, “Nge nungoqi ane pas nganye chiraq, pudi pughe gri ate Pilip nu nge ghabe gudigh? Wute nge ruqoind, te ni wuyi ruqoind pre. Pughe kin ningg nu kuari, ‘Nu beghi wuyi bei yengu’? ");
INSERT INTO kms_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wuyi nge nde nas di nge wuyi nde kas puq gad ye te nu nganyene puq guad segi bri? Wand nge nungoqi simbe guduq kin te nge ngening nde nei pe kateri segi, pudi nge puq ken kin te wuyi nge nde nas kin ni bu nikin yembe te puq nen. ");
INSERT INTO kms_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nge kari nge wuyi nde kas di wuyi nge nde nas puq gad kin te nganyene ei puq wand. Te segi ate yumbo ur gre ye bei gad kin te ningg ei nganyene puq wand. ");
INSERT INTO kms_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nge nungoqi nganyene simbe guduq, wute nge nei rimbigh kin ni nge yumbo gre ye puq ken kin te puq ren ye. Ni yumbo mune nganye yumbui kin te puq ren ye, te pugri nge wuyi nde ko. ");
INSERT INTO kms_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Di nge nde nyamb pe nungoqi yumbo ninge ningg pengu wand, te nge puq ken ye. Te pugri ei te wuyi ni gre yuwon ye rise kin te bei gad. ");
INSERT INTO kms_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nungoqi yumbo pughe kin ningg nge nde nyamb pe pengu wundigh, te nge puq ken ye.” ");
INSERT INTO kms_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Muq Jisas nikin wute te simbe nindim nari, “Nungoqi nge yawo wuragh righe, tedi nungoqi nge kari kin pugrine puq wen. ");
INSERT INTO kms_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Di nge wuyi ningg kari, di ni Ququ Yuwon Ye, ni God nganye nas ye te kin ningg wute simbe nindiny ye te tiqi nundog nandi, nungoqi nde yenu, nungoqi pugrine ghav nunduq, di ni nungoqi nde nas nas te kin nas ye. Wute yumbo ur brequ nde si nambu ris ye ni riti nowi ninde umbo pe nas ye tuqui segi, te pugri ni ruqoind segi di nei rimbig segi. Pudi nungoqi ni nei wumbig, te pugri ni muq nungoqi ane was di otiwo ni nungoqi nde nar nas ye. ");
INSERT INTO kms_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nge nungoqi nyarimo wo kin pugri nonne si kiraqu segi ye. Nge nungoqi nde gadi ye. ");
INSERT INTO kms_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tumo di wute buagi nge ruqoind segi, pudi nungoqi nge wuqoind ye. Nge kes kewo ye te ningg nungoqi anene wes wewo ye. ");
INSERT INTO kms_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ngeri te ningg di nungoqi nei wamb te pugri nge ngening wuyi nde kar kas, di nungoqi nge nde war was, di nge nungoqi nde kar kas. ");
INSERT INTO kms_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wute nge wand rit rise di pugrine puq ren kin ni nge yawo riragh righe ye. Wute nge yawo riragh righe ye, nge wuyi ni yawo nirany righe di nge anene ni yawo kirany righe, di gadi ni nde raqe ko ye.” ");
INSERT INTO kms_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Muq Judas nari, “Pudi Yumbui, pughe kin ningg nu kuari nu beghi ndene raqe kuo, di wute buagi qi pe kin segi?” (Judas nen te aye, ni Judas Iskariot segi.) ");
INSERT INTO kms_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas oyi simbe nand nari, “Wuti iri ni nge yawo niragh righe, tedi ni nge wand gad kin pugrine puq nen ye. Te kin ningg di nge wuyi ni yawo nirang righe ye, di nge wuyi temu ane badi ninde pas ye. ");
INSERT INTO kms_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wute nge yawo riragh righe segi, tedi ni nge kari kin pugrine puq ren segi. Wand nungoqi simbe guduq wutungu kin ren nge ngening nde nei pene simbe gad segi. Wand ren te wuyi nge tiqi nundogh gadi kin ninde pu rindi. ");
INSERT INTO kms_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Muq nge nungoqi ane pas bu nge grine wand buagi te simbe guduq. ");
INSERT INTO kms_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pudi Ququ Yuwon Ye nungoqi ghav nunduq ye, otiwo wuyi nge nde nyamb pe tiqi nundog nandi kin, ni nungoqi yumbo buagi bei neuq, di ni nungoqi nei neuq di yumbo buagi nge simbe guduq kin te nei wumbiny ye. ");
INSERT INTO kms_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nge kari nungoqi umbo oghi kuse. Nge umbo oghi kuse kin pugrine nungoqi te oghi kuse. Nge kari nungoqi umbo oghine kuse kin te wute qi pe kin mari wute umbo oghi kuse kin pugri segi. Otiwo nungoqi yumbo ninge wuqond di te kin ningg puye wand di wune wamb wayequ. ");
INSERT INTO kms_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nungoqi nge asi simbe gad kin te wutungu pre, ‘Nge kari nge ko di nungoqi nde mune gadi ye.’ Nungoqi nge yawo wuragh righe, tedi nge wuyi nde ko kin te ningg chumbuai ane was, te pugri wuyi ni quan nganye yumbui di nge segi. ");
INSERT INTO kms_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nge muqne nungoqi simbe guduq pre, muqdi yumbo te kin puq ren, ei te yumbo te puq ren kin tende puayi nungoqi nge wand gad kin te ningg wari te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nge muq nungoqi ane wand bad bad pas nganye chiraq ye tuqui segi, te pugri qi wen kin yumbui ni nandi. Ni nge nyinge nowi kaghe ye tuqui segi, ");
INSERT INTO kms_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pudi wute buagi qi pe kin ni pugri ei nei rimb te pugri nge wuyi yawo girag righe, di wuyi simbe nindigh kin pugrine nganye puq ken. Muq wandi, be po.” ");
INSERT INTO kms_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas mune simbe nand nari, “Nge wain sare nganye, di nge wuyi ni wain ni maghe ye. ");
INSERT INTO kms_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Muange buagi yi meyi segi kin nge nde mase kin te ni pend nawo, pudi muange buagi yi meyi kin te ni qunati puaq nand, ei te oghi pu mase di yi quan meyi. ");
INSERT INTO kms_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wand nge nungoqi simbe guduq kin te ningg nungoqi yumbo ur brequ puaq di yuwon pu was pre. ");
INSERT INTO kms_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nungoqi nge nde was di nge nungoqi nde kas ye. Wain muange iri nikinne yi neyi tuqui segi. Ni wain big pe nase, tedi ni yi neyi ye tuqui. Te kin pugrine, nge nungoqi ghav guduq segi, tedi nungoqi nonne yi ware tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nge wain big, nungoqi wain muange. Wuti iri nge nde nas di nge ninde kas, tedi ni segine yi quan nare. Nge ghav gad segi, tedi ni yumbo ninge puq nen tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wute nge nde ris segi ye ni wain muange memare ruso di quari mamb kin pugri. Muange pugri ye te materi, wase pe memare righe di namb. ");
INSERT INTO kms_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nungoqi nge nde was di nge wand nungoqi nde vise, tedi nungoqi yumbo ninge nei wumbiny kin te ningg pengu wand di wateri ye. ");
INSERT INTO kms_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nungoqi wain muange kin pugri yi quan ware di bei wand te pugri nungoqi nge te wute ningg was. Nungoqi puq wen ei nge wuyi nyamb yumbui natevi. ");
INSERT INTO kms_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wuyi nge yawo niragh righe kin pugrine nge nungoqi yawo kurauq righe. Nungoqi yumbo ur yuwon kinne puq wen ei nge nungoqi yawo kurauq righe righene was. ");
INSERT INTO kms_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nungoqi nge kari kin pugrine puq wen, tedi nge wuyi nari kin pugrine puq ken di ni nge yawo niragh righe righene kas kin pugrine nge nungoqi yawo kurauq righe righene was. ");
INSERT INTO kms_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nge nungoqi ren kin simbe guduq ei te nge umbo yuwonne kuse kin pugrine nungoqi umbo yuwonne kuse, di te kin ningg nungoqi quan nganye chumbuai wand. ");
INSERT INTO kms_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nge wand taq pugri: Nge nungoqi yawo kirauq righe kin pugrine nungoqi nonne oyi oyi yawo wurany righe. ");
INSERT INTO kms_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wute ni kimand quan nganye yawo rirany righe kin ni kimand yawo rirany righe ye te ningg riti ye. ");
INSERT INTO kms_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nungoqi nge kari kin pugrine puq wen, tedi nungoqi nge mand. ");
INSERT INTO kms_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nge muq nungoqi yembe ye wute puq guduq segi, te pugri yembe ye wute ni nikin yumbui ningg yembe te nei mamb segi. Pudi nge nungoqi mand puq guduq, te pugri yumbo buagi wuyi nge bei negh kin te nungoqi nde bir kawo di nei wumbiny pre. ");
INSERT INTO kms_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nungoqi nge si wumbogh segi, pudi nge nungoqi si gubouq, di kupuqu wo, di wo wain muange kin pugri yi quan ware. Di yi te rise rise te kin rise ye. Nungoqi wain kin pugri yi quan ware, tedi nungoqi yumbo ninge ningg nge nde nyamb pe pengu wand kin te wuyi nungoqi neuq ye. ");
INSERT INTO kms_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nge wand taq: Nonne oyi oyi yawo wurany righe. ");
INSERT INTO kms_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Wute yumbo ur brequ nde si nambu ris ye nungoqi yambu rireuq, tedi nungoqi nei wamb te pugri ni nge yambu riregh pre, muq nungoqi mune yambu rireuq. ");
INSERT INTO kms_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nungoqi wute buagi yumbo ur brequ nde si nambu ris ye pugrine was, tedi wute buagi yumbo ur brequ nde si nambu ris kin ni nikin wute yawo rirany righe kin pugrine nungoqi yawo rirauq righe. Pudi nge nungoqi kupuqu wo di qi pe kin yumbo ur te si ware pre, pugri bu wute buagi qi pe kin nungoqi yambu rireuq. ");
INSERT INTO kms_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nge nungoqi wand simbe guduq ye ren nei wumbiny. Te pugri yembe ye wuti ni oyi yumbui di wuti ninde yembe nand kin ni oyi ninde si nambu nas kin tuqui segi. Pugri bu ni nge unje maip mai isis megh, tedi nungoqi anene unje mupuqu mai isis meuq ye. Di ni nge wand rutungu di pugrine puq ren, tedi nungoqi wand rutungu di pugrine puq ren ye. ");
INSERT INTO kms_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nge nungoqi kupuqu wo di nge te, pugri bu ni puq reuq ye, te pugri ni wuti nge tiqi nundogh gadi ye te ghabe rindig. ");
INSERT INTO kms_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nge gadi di wand simbe gad segi, tedi wute ni yumbo ur brequ rind kin te ningg mai rire segi. Pudi muq nge simbe gad di ni nei rimb pre, pugri bu ni riri ni unje rip segi puq rind ye ngim segi. ");
INSERT INTO kms_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wute nge yambu riregh ye ni wuyi anene yambu rireng. ");
INSERT INTO kms_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nge ninde yumbo wute buagi aye puq men tuqui segi kin te puq ken segi, tedi ni yumbo ur brequ rind kin te ningg mai rire segi. Pudi muq ni yumbo ur gre ye ren ruqond pre, pudi nge wuyi temu yambu rirengu. ");
INSERT INTO kms_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ni nge yambu riregh kin te pugri puq ren ei te wand ninde lo buk pe vise kin ven ane tuquine. Wand ven taq pugri, ‘Ni nge yambu riregh, pudi ni nge yambu riregh ye puate segi.’ ");
INSERT INTO kms_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ququ Yuwon Ye, wand nganyene kin simbe nand ye, wuyi nde pu nandi wute ghav nindiny ye, otiwo nge wuyi nde pu tiqi gudog nungoqi nde nandi kin tende puayi ni nge ningg simbe nand ye. ");
INSERT INTO kms_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Di nungoqi anene nge ningg ei simbe wand, te pugri nungoqi asine nge yembe puate ki righe kin tende puayine nge ane pas. ");
INSERT INTO kms_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nge nungoqi wand buagi ren simbe guduq pre ei te nungoqi Yumbui dob weng segi. ");
INSERT INTO kms_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Te pugri wute nungoqi God yumbui nyamb birag kin baj pe war wo kin te segi puq munduq. Di ngeri ire wundi kin tende puayi wute ninge nungoqi mumbuequ wati di ni nei mamb kin mari ni God ningg yembe te yembe mand bu puq men. ");
INSERT INTO kms_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ni nge di nge wuyi temu nei mumbug segi, pugri bu ni yumbo te kin puq men ye. ");
INSERT INTO kms_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nge nungoqi yumbo te kin ningg simbe guduq pre ei te yumbo te kin puq ren kin tende puayi nungoqi nei wamb ye te pugri nge te kin ningg nungoqi simbe guduq pre. Nge asine yembe puate ki righe kin tende puayine nungoqi simbe guduq segi, te pugri tende puayi nge nungoqi ane pasne. ");
INSERT INTO kms_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Muq nge wuti nge tiqi nundogh gadi kin ninde ko ye, di nge ko kin te ningg nungoqi kin iri pengu nand nari, ‘Nu muainde kuo?’ ni pugri pengu nand segi. ");
INSERT INTO kms_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nge wand ren kin gad kin te ningg nungoqi umbo mai kuyo. ");
INSERT INTO kms_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pudi nge nungoqi nganyene simbe guduq: Nge ko kin te nungoqi ningg bu nge ko. Nge ko segi, tedi wuti nungoqi ghav nunduq kin nungoqi nde nandi segi. Pudi nge ko, tedi ni tiqi gudog nungoqi nde nandi ye. ");
INSERT INTO kms_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ni nandi kin tende puayi ni wute buagi qi pe kin ni yumbo ur brequ rind kin te bei nindiny, di ni yumbo ur pughe ye ni tuqui di God ni pughe gri wute ir nawo kin te bei nindiny ye. ");
INSERT INTO kms_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yumbo ur brequ ningg bei nindiny ye te pugri, ni nge nei rimbigh segi. ");
INSERT INTO kms_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Di yumbo ur pughe ye ni tuqui kin te ningg bei nindiny ye, te pugri nge wuyi nde ko di nungoqi nge mune wuqoind tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Di ni God pughe gri wute ir nawo ye te ningg bei nindiny ye, te pugri God ni qi wen kin yumbui yembe neng puq nand pre. ");
INSERT INTO kms_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nge nungoqi yumbo simbe guduq ye te nganye buagi nganye, pudi muqne nungoqi nei wumbiny kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Otiwo Ququ Yuwon Ye ni God ningg wand nganyene kin simbe nand ye ni nandi kin tende puayi ni nungoqi nei neuq, di God ningg wand nganyene kin te quan buagine nei wumbiny ye tuqui. Ni nikin nde nei pe wand nand segi ye. Ni yumbo nutungu kin di yumbo otiwo rindi kin te ninggne ei nungoqi simbe nunduq ye. ");
INSERT INTO kms_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ni nge wand simbe gad kin tene nungoqi mune simbe nunduq, di te kin ningg ni nge gre yuwon kin te nungoqi bei neuq ei nungoqi nge nyamb wundivi viyo. ");
INSERT INTO kms_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yumbo buagi wuyi nde si nambu rise kin te nge te. Pugri bu nge kari, Ququ Yuwon Ye ni nge simbe gad ye tene ei nare nandi di nungoqi simbe nunduq ye.” ");
INSERT INTO kms_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Muq Jisas nari, “Nginy aye ninge pre di nungoqi nge mune wuqoind segi, di tende dobu nginy aye ninge pre di wuqoind.” ");
INSERT INTO kms_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisas ni nikin wute ninge Jisas puq nand kin te mutungu di oyi oyi pengu mand mari, “Pughe kin ningg bu ni puq nand? Ni beghi simbe ndug nari, nginy ninge pre di beghi ni mune buqoid segi, di tende dobu nginy aye ninge pre di buqoid. Di ni mune beghi simbe nundug nari ni kiyi nde no ye.” ");
INSERT INTO kms_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ni pugri pengu mand mand, ni mari, “Yumbo pughe kin ningg bu ni ‘nginy ninge pre’ puq nand? Beghi ni pugri puq nand kin te nei bab segi.” ");
INSERT INTO kms_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ni Jisas yumbo te kin ningg pengu mindig ningg wand wand mare kin te ni nei namb pre, pugri bu ni pengu nindim nari, “Nge kari ‘nginy ninge pre di nungoqi nge mune wuqoind segi, di tende dobu nginy aye ninge pre di wuqoind.’ Nungoqi te ningg bu oyi oyi pengu wand? ");
INSERT INTO kms_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nge nungoqi nganyene simbe guduq, nungoqi yivany ware di quanji wand ye, pudi wute buagi qi pe kin ni oyi chumbuai rind ye. Nungoqi yivany ware, pudi yivany ware ye te otiwo pre, di chumbuai ane was ye. ");
INSERT INTO kms_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nyumbueg wo wure wundi kin ni yuqo wuraq ye, te pugri muq ni wo pe wuso ye ngeri. Pudi wo wure wundi pre dobu ni wo urupui ire qi pe gudi ye te ningg chumbuai wund, di ni mai mining wuraq kin te nei gheri wupiny. ");
INSERT INTO kms_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nungoqi muq nyumbueg wo pe wuso di mai wuraq kin pugrine. Muq nungoqi yivany ware ye, pudi nge munene nungoqi gudoqu di nungoqi chumbuai wand ye, di wuti iri nungoqi chumbuai wand ye te pend nawo righe ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nge nungoqi nganyene simbe guduq. Ngeri te wundi kin tende puayi nungoqi yumbo ninge ningg nge pengu wundigh segi, te pugri nungoqi yumbo ninge ningg nge nde nyamb pe pengu wand, tedi nge wuyi nungoqi yumbo te neuq ye. ");
INSERT INTO kms_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Muqne nungoqi yumbo ninge ningg nge nde nyamb pe pengu wand segine. Pengu wand di yumbo wateri, di quan nganye chumbuai wand. ");
INSERT INTO kms_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nge nungoqi wand ren simbe guduq kin te kopuqu wand pe simbe guduq. Pudi ngeri ire wundi ye, di tende puayi nge kopuqu wand gad segi ye, pudi nge wuyi ni yumbo ninde nei pe rise kin di yumbo pughe puq wen ningg nari kin te yuwonne simbe guduq. ");
INSERT INTO kms_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ngeri te ningg nungoqi ngende nyamb pe pengu wand ye. Nge nungoqi ningg nyamb pe wuyi pengu gidig ningg kari segi. ");
INSERT INTO kms_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pudi nungoqi nge wuyi nde pu gadi kin te nganyene puq wand di nge yawo wuragh righe, pugri bu wuyi nikinne nungoqi yawo nirauq righe. ");
INSERT INTO kms_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nge wuyi nde pu gadi di qi pe keyi ki pre. Muq nge qi wen si kiraq di wuyi nde mune ko ye.” ");
INSERT INTO kms_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Muq Jisas nikin wute te mari, “Muq nu yuwonne wand simbe guad, di kopuqu wand pe simbe guad segi. ");
INSERT INTO kms_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pugri bu muq beghi nei bab nu yumbo buagi nei gubiny, di nu wute nei gudony ye. Wuti iri nu wand ninge pengu nunduw tuqui segi, te pugri ni wand te nu nei guab pre. Nu wute nei gudony ye pugri bu nu God nde pu guadi ye te beghi pari te nganyene puq bad.” ");
INSERT INTO kms_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas oyi nand nari, “Muqne nungoqi nge nei wumbigh. ");
INSERT INTO kms_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pudi ngeri ire wundi ye, te muq wundi pre, di tende puayi nge irine si weri yengu, di nungoqi ire ire wu wase nungoqi non baj pe wo ye. Pudi nge irine nganye yengu segi, te pugri nge wuyi ni nge temu yembu. ");
INSERT INTO kms_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nge yumbo simbe gad kin te simbe guduq, ei te nungoqi ngende wandi di umbo yuwon gud ye tuqui. Qi pe ven nde nungoqi mai ware ye. Pudi wune wamb wayequ. Te pugri nge qi pe kin gre te nyinge kawo righe pre.” ");
INSERT INTO kms_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas ni wand te simbe nand pre, ni wam rar neq wiyo di nari, “Wuyi nge mi kati ye ngeri te muq wundi pre. Nge nu wo, nge gre yuwon kin te bei ghand, ei te kin ningg nge nu wo oyi nu gre yuwon kin te bei gad wute buagi ruqond di te kin ningg nu nyamb rindivi viyo. ");
INSERT INTO kms_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Te pugri nge gre kuegh di wute buagi nge nde si nambu yeru, ei te nge nde gri wute nu nge kuegh ye te ris ris te kin ris. ");
INSERT INTO kms_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Muq ris ris te kin ris ye te pugri ni nu irine God nganyene kin nei rumbuw, di nge Jisas Kraist nu tiqi gudogh gadi ye nei rimbigh. ");
INSERT INTO kms_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nu nge yembe kuegh kin te yembe gidiny omo kawo ye te ningg nge nu gre yuwon kin te wute buagi bei keny. ");
INSERT INTO kms_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pugri bu muq, wuyi, asi qi di yumbo buagi rise segine kin tende puayi beghi temu gre yuwon kin rise kin te ninggne muq nunde rar pene gre yuwon kin te bei ghand. ");
INSERT INTO kms_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nge wute qi pe kin nu ir kuawo nge kuegh ye te nu wuti pughe gib guab kin te bei kem pre. Wute men nu te, nu nge kuegh, di ni nu wand mutungu kin pugrine puq men. ");
INSERT INTO kms_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Muq ni nei mamb pre te pugri yumbo buagi nu nge kuegh kin te nunde gri rindi. ");
INSERT INTO kms_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Te pugri nu nge wand simbe gudigh kin te simbe gidim, di ni wand te umbo pe mawo vis, nge nganyene nunde pu gadi di nu nge tiqi gudogh gadi kin te nganyene puq mand. ");
INSERT INTO kms_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nge wute buagi qi pe kin ningg kari segi, pudi wute nu nge kuegh kin men ningg bu kari, te pugri wute men te nu te. ");
INSERT INTO kms_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nge te wute buagi te nu te, di nu te wute buagi te nge te. Ni yumbo yembe mindiny kin te ningg nge nyamb yumbui vise. ");
INSERT INTO kms_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nge qi pe ven nde kas nganye segi ye, pudi nge wute men ni qi pe ven nde mas di nge nunde godo ye. Pugri bu, wuyi yuwon nganye, nu nunon nyamb nge kuegh ye ni gre te ningg ni yeng wam, ei te beghi temu umbo irene kuse kin pugrine ni umbo irene kuse. ");
INSERT INTO kms_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nge ni ane pasne kin ven nde puayi nge nyamb nu kuegh kin ven ningg ni yeng kuam di ghav gidim yuwon pu mas. Wuti iri ir no segi, pudi Judas ni ir no ninggne, pugri bu ni ir no ei te nu ningg wand buk pe vise kin pugrine yumbo te puq ren. ");
INSERT INTO kms_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Muq nge nunde godo, pudi nge qi pe kas kin ven nde puayine nge wand ren simbe gad, ei te nge umbo pe quan nganye chumbuai gad kin pugrine ninde umbo pe chumbuai mand. ");
INSERT INTO kms_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nge nu wand simbe gudigh kin te simbe gidim pre di wute yumbo ur brequ nde si nambu risne kin ni yambu rirem ye. Te pugri nge yumbo ur brequ nde si nambu kas segi kin pugrine wute men ni yumbo ur brequ nde si nambu mas segi. ");
INSERT INTO kms_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nge nu ni qi pe ven nde pu ghate mowi ningg kari segi, pudi nu yeng wam ei Satan ni nyinge nawo maghe segi. ");
INSERT INTO kms_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nge yumbo ur brequ nde si nambu kas segi ye pugrine ni yumbo ur brequ nde si nambu mas segi. ");
INSERT INTO kms_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nu wand simbe guad kin te wand nganyene kin simbe guad, pugri bu nu wand nganyene kin te ningg ni ghap mo di ni nunon tene. ");
INSERT INTO kms_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nu nge tiqi gudogh qi pe gadi kin pugrine nge ni tiqi gudom mo. ");
INSERT INTO kms_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ni ningg bu nge kari nge nunon te wuti ei ni mune pugrine nunon te wute. ");
INSERT INTO kms_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Wuyi, nge wute men ninggne nu pengu guduw segi, pudi otiwo wute ninge wute men nge ningg wand simbe mand kin te rutungu di te ningg nge nei rimbigh ye te anene, ");
INSERT INTO kms_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","te ei ni quan buagine nu nge nde kuas di nge nunde kas di beghi temu irene pas kin pugrine ni irene ris. Ni beghi nde ris ei te kin ningg wute qi pe kin ni te ruqond di nei rimb, nu nge tiqi gudogh gadi. ");
INSERT INTO kms_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Beghi temu irene pas kin pugrine ni irene ris, nge ninde kas di nu ngende kuas, te ningg bu nu gre yuwon kin kuegh kin te ni keny pre. Ni irene ei ris di wute qi pe kin te ruqond di nei rimb te pugri nu nge tiqi gudogh gadi, di nu nge yawo kuragh righe kin pugrine ni yawo kurany righe pre. ");
INSERT INTO kms_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Wuyi, qi di yumbo buagi rise segine nu nge yawo kuragh righe, pugri bu nu nge gre yuwon kin bei guad. Wute nu nge kuegh ye nge kas pe tende ghawo ris ei nu nge gre bei guad kin te ruqond. ");
INSERT INTO kms_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Wuyi, nu yuwon kuawo ye, wute buagi qi pe kin nu ghabe runduw. Pudi nge nu nei gubuw, di wute men nu nge tiqi gudogh gadi kin te nei mamb pre. ");
INSERT INTO kms_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nge nu ningg ni simbe gidim di nu nei mumbuw pre, di otiwo nge mune pugrine puq ken, ei nu nge yawo kuragh righe kin pugrine ni mune yawo ram righe, di nge ngeningne ninde kas ye.” ");
INSERT INTO kms_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas ni kiyi pugri pengu nindig pre, ni nikin wute ane wuye iri Kidron puq mindig kin te misiny opu gri mo. Ruso ruwo opu gri tende mong puch ire nyumo olivne tende yemu, di ni tende mar mo. ");
INSERT INTO kms_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jisas ni pripri nikin wute ane tende mikur, pugri bu Judas ni sunyi te nei namb pre. (Judas nen te ni Jisas veri nde si pe ni nondo ye.) ");
INSERT INTO kms_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Prist mingg yumbui di Parisi ninge ni wute God ningg baj yeng muaw kin ninge tiqi mundom mo. Judas ni wute God ningg baj yeng muaw kin te di Rom mingg ami ninge ane nitami nyumo oliv yemu kin sunyi pe tende no. Ni soi di lam di yeng kin yumbo ane mare mo. ");
INSERT INTO kms_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas ni yumbo pughe sin meng kin te quan buagine nei namb pre, pugri bu ni nandi pengu nindim nari, “Nungoqi tughe ningg wandi?” ");
INSERT INTO kms_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ni oyi mand mari, “Jisas Nasaret kin.” Jisas oyi nand nari, “Nge wuti te.” (Di Judas ni Jisas veri nde si pe ni nondo ye ni anene tende yenu.) ");
INSERT INTO kms_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisas nari, “Nge wuti te” puq nand kin tende puayi ni dobu dobune kring mo di pombri mo qi pe mase. ");
INSERT INTO kms_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Muq ni munene pengu nindim nari, “Nungoqi tughe ningg wandi?” Di ni mari, “Jisas Nasaret kin.” ");
INSERT INTO kms_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisas oyi nand nari, “Nge nungoqi simbe guduq pre te pugri te nge. Nungoqi nge meri wutigh, ate wute men si ware mo.” ");
INSERT INTO kms_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jisas ni pugri simbe nindim ei te ni asi kiyi ningg nari, “Nge wute nu kuegh ye te iri si keri segi ye” puq nand kin te ane tuquine. ");
INSERT INTO kms_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Muq Saimon Pita ni mame bidi dobui iri nase ye te qo naimb nandi, prist mingg yumbui mingg yumbui ni yembe ye wuti iri ange si tuan opu kin te pend nuang ir wi. (Wuti te ni nyamb Malkus.) ");
INSERT INTO kms_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Muq Jisas Pita simbe nindig nari, “Nu mame dobui te nikin chongo pe mune yi ndighe. Nu nei guab kin kuari wuyi nge mai kiraq puq nand ye te kiraq segi ye bri?” ");
INSERT INTO kms_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Muq Rom mingg ami ni yumbui ni nikin ami ninge ane di wute God ningg baj yeng muaw ye te ane Jisas mait nase, si taq mimbig. ");
INSERT INTO kms_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","14","Ber te ningg Kaiapas ni prist mingg yumbui mingg yumbui di asi ni Juda simbe nindiny nari, “Wuti iri nungoqi buagi ane ningg nati te yuwon.” Kaiapas ni wuti iri Anas puq mindig ye ni kuwonyumbu te nitaqi. Ni Jisas mitanyi Anas nde mo. ");
INSERT INTO kms_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita di Jisas ningg wuti aye iri temi Jisas nde dobu maru. Prist mingg yumbui mingg yumbui ni Jisas ningg wuti iri te nei nimbig ye, pugri bu ni Jisas ane prist mingg yumbui mingg yumbui ni nas kin imb wabe mar mo, ");
INSERT INTO kms_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pudi Pita ni dabo ngimrawu ne ghimbi nawo pu yenu. Jisas ningg wuti iri te ni prist mingg yumbui mingg yumbui ni nei nimbig ye, pugri bu mune neyi ni, nyumbueg ngimrawu yeng wuwo pu yequ kin te simbe nunduw di Pita nitanyi nar no. ");
INSERT INTO kms_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Muq nyumbueg ngimrawu yeng wuwo pu yequ kin te Pita pengu wundig wuri, “Nu Jisas ningg wuti iri segi bri?” Pita oyi nand nari, “Nge segi.” ");
INSERT INTO kms_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wute God ningg baj yeng muaw kin di yembe ye wute ni uyi mati, di wase muaq wughe suqo mipiq mipiq yemu. Di Pita ni anene wase suqo nap nap yenu. ");
INSERT INTO kms_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Muq Anas, prist mingg yumbui mingg yumbui, ni Jisas nikin wute te ningg di Jisas ni wand pughe ye simbe nindim kin te ningg Jisas pengu nindig. ");
INSERT INTO kms_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas oyi nand nari, “Nge pripri wute God yumbui nyamb mirang kin baj pe di God ningg baj Juda buagi rikur pe tende wand raqene simbe gad. Nge wand ninge suqo grine simbe gad segi. Di wute buagi nei rimb. ");
INSERT INTO kms_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Pughe kin ningg nge pengu gudigh? Nu wute nge wand gad kin rutungu ye te ei pengu ndiny. Nganyene nganye, ni nge wand simbe gad kin te nei rimb.” ");
INSERT INTO kms_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas ni puq nand kin tende puayi wute God ningg baj yeng muaw ye wuti iri Jisas nde tumone yenu kin te si namb kui Jisas kowisambe dang nindig, di simbe nindig nari, “Tughe simbe nunduw bu nu prist mingg yumbui mingg yumbui nde rar pe pugri wand guad?” ");
INSERT INTO kms_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas oyi nand nari, “Nge wand ire unje kap, ate nu nge wand unje kap kin te simbe ghand. Pudi nge wand simbe gad kin te nganyene, te pughe kin ningg nu nge kui?” ");
INSERT INTO kms_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Muq Anas ni Jisas si taq pune rise tiqi nundog prist mingg yumbui mingg yumbui, Kaiapas, nde no. ");
INSERT INTO kms_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita ni wase suqo nap napne yenu, wute ninge pengu mindig mari, “Nu Jisas ningg wuti iri bri?” Saimon Pita segi puq nand nari, “Nge segi.” ");
INSERT INTO kms_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Muq prist mingg yumbui mingg yumbui ni yembe ye wuti iri di ni Malkus ni yavi ire te quan buid nap nari, “Nu Jisas ane oliv yemu kin sunyi pe tende yequ. Nu kuari nge nu guqoid segi bri?” Malkus te Pita ange di nuang kin te. ");
INSERT INTO kms_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita mune nganye segi puq nand, di ni segi puq nand pre brequne di wapiqu nari. ");
INSERT INTO kms_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Muq Juda mingg wute nyamb kin Jisas Kaiapas nde baj pe pu mitanyi Rom mingg yumbui Pailat nde baj yumbui pe mo. Tende puayi te burane di ni Pailat nde baj pe mar mo segi. Te pugri ni mar mo tedi ni Juda mingg lo gure muaq di ni God asi Israel mingg wo rar nuqond mas kin ngeri chumbuai rindiny di mir rind ye te ni ane mir mand tuqui segi. Te ningg bu ni dabone yemu. ");
INSERT INTO kms_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pugri bu Pailat neyi nandi di pengu nindim nari, “Wuti nen yumbo ur brequ pughene puq nen bu nge nde wutanyi wandi?” ");
INSERT INTO kms_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ni oyi mand mari, “Ni unje nap segi, tedi beghi nunde si pe pi nondo segi.” ");
INSERT INTO kms_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat nari, “Nungoqi nonne wutanyi wo, nungoqi non nde lo pene wand ir wang.” Juda mingg wute nyamb kin segi puq mand mari, “Nungoqi wute Rom kin beghi wuti iri pi nati ye te ningg segi puq wand.” ");
INSERT INTO kms_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yumbo ren puq ren kin asi Jisas ni kruse pe nati ye te ningg simbe nand ye ane tuquine rise. ");
INSERT INTO kms_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Muq Pailat mune baj yumbui pe nar no, Jisas ngam nirang nondo, di pengu nindig nari, “Nu Juda mingg king bu?” ");
INSERT INTO kms_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas oyi pengu nand nari, “Nu wand simbe guad kin ren nunon nde nei pene puq guad, o wute aye nge ningg puq mand kin te nu simbe munduw?” ");
INSERT INTO kms_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat oyi nand nari, “Nu nei guab kin nge Juda kin bri? Nunon wute di nunon prist mingg yumbui bu nu nge nde si pe mi guadi. Nu pughe sin bu kuen?” ");
INSERT INTO kms_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas nari, “Nge qi pe kin king segi. Nge qi pe kin king, tedi nge te yembe ye wute ni oyi yeng mand, di nge ghav mindigh ei Juda nge mait kase segi. Pudi nge tiqe aye pe kin king.” ");
INSERT INTO kms_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat oyi nari, “Muq nu kingne iri.” Jisas oyi nand nari, “Nu kuari nge king iri puq guad kin te nu tuquine guad. Te pugri nge te kin ningg moyu wuri wundi di qi pe ven nde gadi, ei wand nganyene kin te ningg simbe gad. Wute wand nganyene kin opu yeru ye ni nge ningg wand rutungu ye.” ");
INSERT INTO kms_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Muq Pailat pengu nand nari, “Wand nganyene kin te pughene?” Muq ni Jisas si neri mune dabo neyi ni di Juda kin wute buagi te simbe nindiny nari, “Nge wuti nen nati puq gad kin wand puate ninge guqod segi. ");
INSERT INTO kms_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pudi nungoqi non yumbo ur te pugri, God asi Israel mingg wo rar nuqond mas kin ngeri yumbui chumbuai wundiny kin tende puayi di nge wute taq pu yemu kin te kin ye iri si keri nondo ye. Pugri bu nge Juda mingg king nen si keri nondo ningg bri wari?” ");
INSERT INTO kms_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Muq ni Pailat nde ngam mare rundo di mari, “Yewo, ni segi. Beghi Barabas ei si gheri nandi.” (Barabas ni yeng nand ye iri.) ");
INSERT INTO kms_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Muq Pailat ami simbe nindim, Jisas mitanyi mo yas pe pug mindig. ");
INSERT INTO kms_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ni sare quat kin muet mamb pre ngawu pe mirang righe, di king kin pugri chongo ambo kin ire mirang wughe pre, ");
INSERT INTO kms_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","di ire ire ninde mandi di mari, “Juda mingg king nu kuas nganye chiraq ye!” Ni puq mand di Jisas kowisambe pe mi. ");
INSERT INTO kms_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat ni mune nganye dabo neyi ni di wute buagi simbe nindiny nari, “Te wuqond! Nge wuti nen pi nati puq gad kin wand puate segi, pugri bu nge kitanyi keyi ki ei nungoqi nonne wuqoind.” ");
INSERT INTO kms_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pugri bu Jisas ni sare quat kin ngawu pe rise kin te di chongo ambo kin mirang wughe kin te risene neyi ni. Muq Pailat wute buagi te ningg nari, “Te wuqond. Wuti taq nen.” ");
INSERT INTO kms_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Muq prist mingg yumbui di wute God ningg baj yeng muaw kin ni muqoind di ngam mare rundo mari, “Kruse pe qungu wi nati. Kruse pe qungu wi nati.” Pailat simbe nindim nari, “Nungoqi nonne wutanyi wo kruse pe qungu wi nati. Nge ni ki nati ye wand puate ninge guqod segi.” ");
INSERT INTO kms_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Muq Juda kin wute buagi te oyi mune simbe mand, “Beghi ningg lo wuri ni nati ye tuqui, te pugri ni nari ni God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat ni te nutungu kin te ningg ni quan wune namb. ");
INSERT INTO kms_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ni mune baj yumbui pe mar mo, di Jisas pengu nindig, “Nu muai pu guadi?” Pudi Jisas ni oyi nindig segi. ");
INSERT INTO kms_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Muq Pailat nari, “Nu nge wand kuegh segi ye bri? Nu nei guab te pugri nge segine nu si keri yo, o wute simbe gidim nu kruse pe qungu mi ghati kin gre rise.” ");
INSERT INTO kms_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas oyi nand nari, “God nari bu nu wuti pugri ye kuas, bu muq nu segine wute simbe ndim nge kruse pe qungu mi kati ye tuqui. Pugri bu wuti nge nu nde si pe ni godo ye ni mai te quan nganye yumbui, nu te musoqne.” ");
INSERT INTO kms_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat ni te nutungu kin te ningg ni Jisas si neri no kin ngim meri nat. Pudi Juda buagi ngam mare rundo mari, “Nu si gheri no, tedi nu Sisar kimand segi! Wuti iri nari ni king puq nand ye ni opu gri yenu, di Sisar ningg veri!” ");
INSERT INTO kms_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat ni wand ven nutungu, Jisas nitanyi raqe nar no. Di jas nas kin komboiq te miraq mandi sunyi puch ire wet mawo yuwon muany pu rise kin tende muaq yequ di Pailat ni tende nas. (Sunyi puch te Hibru wand pe Gabata puq munduw.) ");
INSERT INTO kms_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Muq Juda ni Sabat kin nginy te ningg sir rip ye ngeri di ngeri te muq bogisumb. Di te kin te God ni asi Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny kin wik te ninggne. Pailat wute buagi te ningg nari, “Nungoqi king taq nen.” ");
INSERT INTO kms_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ni ngam mare rundo mari, “Weri wo! Weri wo! Kruse pe qungu wi nati!” Pailat ni pengu nindim nari, “Nge nungoqi king nen kruse pe qungu ki nati ningg bri wari?” Muq prist mingg yumbui ni oyi mand mari, “Beghi king aye segi, Sisar irine!” ");
INSERT INTO kms_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Muq Pailat ni Jisas Rom mingg ami ninde si pe ni nondo ei kruse pe qungu mi nati ningg. Pugri bu Rom mingg ami Jisas mitanyi mo. ");
INSERT INTO kms_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni nikin kruse te niraq tiqe yumbui pe pu neyi ni, di mong puch ire “Ngawu ngape tiqe” puq mand kin tende no. (Mong te Hibru wand pe Golgota puq mand.) ");
INSERT INTO kms_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tende ni kruse pe qungu mi nati, di wute aye temi anene qungu mi mati, iri opu yenu iri opu yenu di Jisas mingine yenu. ");
INSERT INTO kms_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat nari wand ninge ur mand pre kruse pe mi riwo pu yeru. Ni wand ur mand kin taq pugri, “Jisas Nasaret kin, ni Juda mingg king.” ");
INSERT INTO kms_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jisas qungu mi nati kin sunyi pe pu tiqe yumbui pe te tumone. Di wand ur mand kin te Hibru wand, Latin wand, di Grik wand pe ur mand, pugri bu Juda nganye buagi ni wand ur mand kin te ruqond. ");
INSERT INTO kms_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Juda mingg prist mingg yumbui ni Pailat ningg mari, “Nu Juda mingg king ur ghand wayequ. Pudi nu pugri ei ur ghand, ‘Wuti nen nari ni Juda mingg king’.” ");
INSERT INTO kms_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat oyi nand nari, “Nge kari ur mand kin te rar wuqond, ur mand kin pugrine rise.” ");
INSERT INTO kms_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Rom mingg ami ni Jisas kruse pe qungu mi nati pre, ni chongo te materi bir mawo 4-pela pu di ire ire materi. Ni chongo dobui kin wabe gri niraq wughe, di chongo irine pe yembe munduw kin te anene ir muang. ");
INSERT INTO kms_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rom mingg ami te kin kin wand wand mare mari, “Chongo dobui kin wen bir puaq wayequ. Satu griny bad ei buqod tughe nitaqwi.” Ni pugri puq men kin te God ningg wand buk pe vise kin ane tuquine. God ningg wand taq pugri, “Ni nge chongo bir mawo ire ire materi, di nge chongo dobui kin te satu griny munduw ye.” Di muq Rom mingg ami ni pugri puq men. ");
INSERT INTO kms_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas nde kruse pe tumone te nikin kumo, nikin kumotumo, Maria Klopas ngam, di Maria Magdala kin ni tende yeru. ");
INSERT INTO kms_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas ni nikin kumo di nikin wuti iri ni yawo nirang righe ye ni tende yeru nuqond. Pugri bu nikin kumo te simbe nunduw nari, “Ni nu wo ei puq ndig.” ");
INSERT INTO kms_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Muq nikin wuti te ningg mune nari, “Ni nu numo ei puq nduw.” Di tende puayine Jisas nikin wuti te Maria nitaqi no ninde baj pe wus. ");
INSERT INTO kms_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas nei namb te pugri tende puayi ni yembe buagi te omo nawo pre, pugri bu ni nari, “Nge yawo singar kati.” Ni puq nand ei wand buk pe vise kin te ane tuquine. ");
INSERT INTO kms_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wain abo neq kin os ane tende nas, pugri bu ni chongo bidi nyumo kamo pe wureq mimbiq, wain pe meq wughe pre Jisas nde mim pe meq wundo. ");
INSERT INTO kms_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas ni wain te ne pre di nari, “Omone.” Muq ni ngawu nindinyi nati, nikin ququ te wuwi wundi wuso di nati. ");
INSERT INTO kms_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Muq Juda mingg wute nyamb kin ni Pailat pengu mindig ngiq nand tedi wute kruse pe yemu kin te muange gure muam ei brequne mati di mate mati ningg. Ni puq men kin te pugri muq Sabat kin nginy te ningg sir rip di ni Sabat kin ngeri yumbui nganye te tumo rind, di ni Sabat kin nginy te ningg wute kruse pe yemu kin te ni yambu mari. ");
INSERT INTO kms_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pugri bu ami ni wute Jisas ane kruse pe qungu mi mati kin te muange gure muam. ");
INSERT INTO kms_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pudi ni Jisas nde mondo kin tende puayi ni muqond Jisas nati pre, pugri bu ni muange gure muang segi. ");
INSERT INTO kms_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pudi ami iri yir neti nowi qut pe cheiq neri, di opu brequne yavi wuye ane buraq ri. ");
INSERT INTO kms_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wuti yumbo ren nuqond kin ni ren kin ningg simbe nand, di ni simbe nand kin te nganyene. Ni nei namb ni wand simbe nand ye te nganyene, di ni te kin ningg simbe nand ei nungoqi Yumbui nei wumbig. ");
INSERT INTO kms_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yumbo ren puq ren ei te wand buk pe vise kin ven te ane tuquine. Wand buk pe vise kin taq pugri, “Ni ningg ngape ire gure muang segi ye,” ");
INSERT INTO kms_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","di aye te “Wuti ni yir pe cheiq meri kin te ei ruqoind ye.” ");
INSERT INTO kms_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tende dobu Josep Arimatea kin ni Pailat pengu nindig ei Jisas neti nati neri no nowi yenu ningg. (Josep ni Jisas ningg wand nutungu di nganyene puq nand ye, pudi ni Juda mingg wute nyamb kin te wune nimbim, pugri bu ni suqo grine Jisas nei nimbig.) Pailat ni Josep Jisas neti nati neri no kin te ningg ngiq nindig, pugri bu ni no di Jisas neti nati, di neri no. ");
INSERT INTO kms_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, wuti asi Jisas nuqoind ningg burpoq pu Jisas nde no kin te, ni wel tuqo kin mur di alos pe yembe mindig kin te 30 kilogram kin pugri nare Josep temi mo. ");
INSERT INTO kms_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ni temi Jisas meri mo di wel tuqo kin te muang di chongo quem kin pe wureq maimb. Ni puq men kin te Juda ni wute mati kin mawo yemu ningg tedi pugri ei puq men ye. ");
INSERT INTO kms_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas qungu mi nati kin sunyi pe tende tumone wuny ire vise, di wuny mbe mingi tende wute mati mawo yemu kin ngamo ire yequ, ngamo te urupui, wuti iri mowi yenu segine. ");
INSERT INTO kms_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Muq Juda buagi Sabat kin ngeri te ningg sir map ningg, di ngamo te tumone yequ, pugri bu ni Jisas meri mo ngamo pe tende mowi yenu. ");
INSERT INTO kms_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nginy namba wan te ningg burane, bur yengune Maria Magdala kin ni Jisas nde ngamo pe wuso, di wuqond wet nyaw ngamo pe yequ kin te kring mipiq wuso pre. ");
INSERT INTO kms_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pugri bu ni mune vig wumb Saimon Pita di Jisas ningg wuti te kin ye iri Jisas nikin yawo nirang righe kin te ni temi nde wuso di simbe wundim wuri, “Yumbui ngamo pe pu meti nowi meri mo pre, di ni muainde mowi nase kin te beghi nei bab segi.” ");
INSERT INTO kms_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Muq Pita di Jisas ningg wuti aye te temi mes mewo Jisas nde ngamo pe mo. ");
INSERT INTO kms_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ni temi ane vig mamb mo, pudi Jisas ningg wuti aye te oyi ye nawo no ngamo pe nitari righe, di Pita naru. ");
INSERT INTO kms_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ni yimb naghe, rar neq wur di chongo bidi Jisas nde ghimbi pe wureq mamb kin te nuqond, pudi ni ngamo pe nar no segi. ");
INSERT INTO kms_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Muq Saimon Pita, ni wuti tende dobune naru kin, ni no nitari righe di ngamo pe nar no. Ni chongo bidi Jisas nde wureq mamb kin te rise nuqond, ");
INSERT INTO kms_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","di chongo bidi ngawu pe mirang wughe kin te anene gure muaq pre pu wuse nundoq. Chongo bidi te nikinne wuse, di chongo bidi aye te ane ire pene rise segi. ");
INSERT INTO kms_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Muq Jisas ningg wuti aye te ye nawo no ngamo pe nitari righe kin ni mune ngamo pe nar no. Ni chongo te rise nuqond, di ni nei namb Jisas ni nganyene mune nes newo pre. ");
INSERT INTO kms_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Pudi ni temi Jisas mune nes newo ye wand te God ningg wand buk pe rise kin te nei mimbiny segine.) ");
INSERT INTO kms_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Muq Jisas ningg wute temi te munene kin kin baj pe mo. ");
INSERT INTO kms_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pudi Maria ni Jisas nde ngamo qunambe tende quanji quanji yequ. Ni quanji quanjine yimb wughe ngamo pe rar weq wur, ");
INSERT INTO kms_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","di angelo temi yemu wuqond. Ni chongo quem kin mare righe pre Jisas asi mowi nase kin sunyi pe tende mas, iri ngawu tiqe opu nas, di iri muange tingi opu nas. ");
INSERT INTO kms_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ni temi Maria pengu munduw mari, “Nu pughe kin ningg quanji guad?” Ni oyi wund wuri, “Wute ninge nge yumbui meti nowi meri mo pre, di nge nei gab segi ni muainde bri mowi nase.” ");
INSERT INTO kms_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ni puq wund pre, muq dobu gri rar wut di Jisas te yenu wuqoind, pudi ni wuqoind wuip no segi. ");
INSERT INTO kms_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas ni pengu nunduw nari, “Nyumbueg, nu pughe kin ningg quanji guad? Nu tughe meri kuting?” Ni nei wumb kin wuri ni wuti wuny mbe tende yembe nand kin bri yenu, pugri bu ni simbe wundig wuri, “Nu kueti nowi kueri kuo, ate sunyi muainde kuowi nase kin te simbe ghand di nge ko keti nowi ye.” ");
INSERT INTO kms_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas simbe nunduw nari, “Maria!” Maria Jisas nde tindi wundo di Hibru wand pe wuri, “Rabonai!” (Wand ven ni puate te, wuti wand wute bei neny ye.) ");
INSERT INTO kms_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisas ni simbe nunduw nari, “Nu nge ghait kase wayequ, te pugri nge mune nge wuyi nde kewo ko segine. Pudi nu yo, nge te wute te simbe ndim ghari, nge mune ngening wuyi nde kewo ko ye. Ni nge wuyi di nungoqi nuyi, nge God di nungoqi God.” ");
INSERT INTO kms_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Muq Maria Magdala kin ni wuso di Jisas ningg wute te simbe wundim wuri ni Yumbui wuqoind pre, di ni Jisas simbe nunduw kin wand te simbe wundim. ");
INSERT INTO kms_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nginy namba wan te ningg yuram bur Jisas ningg wute irepene baj pe mikur, di ngim miraq wughe gre pu mas, te pugri ni Juda mingg wute nyamb kin te wune mimbim. Muq Jisas nandi ninde mingine yenu di nari, “Nungoqi umbo yuwon kuse.” ");
INSERT INTO kms_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ni puq nand pre, ni qut di si te bei nindim. Jisas ningg wute ni Yumbui muqoind kin te ningg ni quan nganye chumbuai mand. ");
INSERT INTO kms_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas munene simbe nindim nari, “Nungoqi umbo yuwon kuse. Wuyi nge tiqi nundogh gadi kin pugrine nge mune nungoqi tiqi gudouq wo.” ");
INSERT INTO kms_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ni pugri puq nand pre di ni puy nuqond di simbe nindim nari, “Ququ Yuwon Ye weti nowi. ");
INSERT INTO kms_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nungoqi wuti iri mai puaq wundig, tedi ni mai te puaq. Nungoqi ni mai puaq wundig segi, tedi ni mai te puaq segi.” ");
INSERT INTO kms_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Muq Tomas (Didimus puq mindig kin) ni Jisas ningg wute 12-pela te kin ye iri, di Jisas ni nikin wute nde raqe no kin tende puayi ni ane mas segi. ");
INSERT INTO kms_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pugri bu Jisas ningg wute ninge te ni simbe mindig mari, “Beghi Yumbui buqoid pre.” Pudi ni simbe nindim nari, “Nge ni muanji si pe rise kin te guqod di nge nil maghe kin sunyi te si kawo, di ninde qut pe si keq wur, tedi nge kari nungoqi nganyene wand.” ");
INSERT INTO kms_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wik ire pre Jisas nikin wute ni munene baj pe tende mas, di Tomas ane mas. Ni ngim miraq wughe, pudi Jisas nandi ninde mingine yenu di nari, “Nungoqi umbo yuwon kuse.” ");
INSERT INTO kms_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Muq ni Tomas ningg nari, “Nu si suramb ven yi mandi, nge si ren qond. Nu si yeq wundi di nge nde qut pe si yeq wur. Nu nei tevi tevi kin te si ghare, di wand simbe munduw kin te nganyene puq ghand.” ");
INSERT INTO kms_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Muq Tomas Jisas ningg nari, “Nge Yumbui di nge God!” ");
INSERT INTO kms_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Muq Jisas ni simbe nindig nari, “Nu nge guqoid pugri bu nu kuari te nganyene. Wute nge ruqoind segine nganyene puq rind kin God ni yuwon nuany ye.” ");
INSERT INTO kms_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas ni yumbo ur gre ye nganye buagi nganye nikin wute nde rar pe bei nand, pudi te kin te quan buagine buk wen nde ur gad segi. ");
INSERT INTO kms_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pudi ren ne ur gad ei nungoqi wari Jisas ni nganyene Kraist, God ningg wo, di nungoqi ni nei wumbig kin te ningg ninde nyamb pe nungoqi was. ");
INSERT INTO kms_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tende dobu nginy ninge mo pre Taiberias wuye ngamo pe tende Jisas nikin wute nde mune raqe no. Jisas nikin wute nde raqe no kin taq pugri. ");
INSERT INTO kms_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (Didimus puq mindig kin te), Nataniel Kana Galili opu kin te, Sebedi ningg wo temi, di Jisas ningg wute aye temi ninge ane ni quan buagine irepene yemu. ");
INSERT INTO kms_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Muq Saimon Pita ni simbe nindim nari, “Nge ko umo meri kat.” Di ni mari, “Beghi nu ane po ye.” Muq ni mes mewo mo, bot pe mewo mo di mo, pudi bur te ningg ni umo ninge materi segi. ");
INSERT INTO kms_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yambgriq burane Jisas dabo jiji pe tende yenu, pudi nikin wute ni muqoind maip no segi. ");
INSERT INTO kms_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Muq ni ngam nare rundo nari, “Mand, nungoqi umo ninge wateri segi bri?” Ni oyi mand mari, “Segi.” ");
INSERT INTO kms_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Muq ni nari, “Nungoqi yawi si nganye opu mune meweri naghe, di umo ninge wateri.” Ni Jisas nari kin pugrine puq men di umo nganye buagi nganye yawi pe righe, di yawi qo maimb nondo bot pe mowi naghe kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Muq Jisas ningg wute te kin ye iri Jisas nikin yawo nirang righe kin ni Pita ningg nari, “Te Yumbui bu yenu ye.” Saimon Pita ni wand te nutungu kin tende puayi ni chongo ir nuaq pu wus di yembe nand kin chongo te mune niraq wughe, wuye pe prare naghe ei wuye ghiri numboq dabo no ningg. ");
INSERT INTO kms_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Muq Jisas nikin wute aye ninge te mune bot pe maru ei yawi pe umo righe bre pu yeru kin te yawi ane qo mamb mare dabo jiji pe mo. Bot te jiji pe tumone yequ, 100 mita kin pugri. ");
INSERT INTO kms_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ni mo jiji pe mo mar kin tende puayi wase ire namb namb yengu di umo ninge wase pe tende rise, di bret ninge ane rise muqond. ");
INSERT INTO kms_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisas ni simbe nindim nari, “Nungoqi umo ninge muq tene wateri kin ninge ren ware wandi.” ");
INSERT INTO kms_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Muq Saimon Pita mune bot pe newo no di yawi te qo naimb neri dabo jiji pe newo no. Umo yumbui kinne 153 kin pugri yawi pe tende bre, pudi yawi pend nas segi. ");
INSERT INTO kms_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas ni simbe nindim nari, “Wandi, mir wand.” Jisas ningg wute te iri Jisas ningg pengu nand nari, “Nu tughene” ni nei mamb pre te Yumbui, pugri bu ni pengu mand segi. ");
INSERT INTO kms_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas nandi bret te nateri nem di umo mune pugrine. ");
INSERT INTO kms_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Muq ven te Jisas nati pre mune nes newo nikin wute nde raqe no tevi ire pu nand kin. ");
INSERT INTO kms_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ni mir mand pre, muq Jisas Saimon Pita ningg nari, “Saimon, Jon ningg wo, nu nganyene nge quan nganye yawo kuragh righe, di wute aye te nge musoqne yawo miragh righe bri?” Ni nari, “Yumbui, nu nei guab nge nu yawo kiraw righe.” Jisas nari, “Nge sipsip wo te bag ghamb.” ");
INSERT INTO kms_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas munene nari, “Saimon, Jon ningg wo, nu nganyene nge quan nganye yawo kuragh righe?” Ni oyi nand nari, “Yumbui, nu nei guab nge nu yawo kiraw righe.” Muq Jisas nari, “Nge sipsip te sabi ndiny.” ");
INSERT INTO kms_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas mune nganye puq nand nari, “Saimon, Jon ningg wo, nu nge yawo kuragh righe bri?” Jisas ni pengu nindig tevi ire pu nand nari, “Nu nge yawo kuragh righe?” Di Pita ni umbo mai kuyo. Pugri bu ni nari, “Yumbui, nu yumbo buagi nei guab omo. Nu nei guab nge nu yawo kiraw righe.” Jisas nari, “Nge sipsip te bag ghamb. ");
INSERT INTO kms_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nge nu nganyene simbe guduw, nu ambonye kuas kin puayi nunonne chongo kuare righe di muainde kuo puq guad kin tende kuo. Pudi nu gang ghase kin tende puayi di nu si ndiri riwo, di wute aye mait ghase, di sunyi nu kuo yambu kuari kin tende mitanyi mo.” ");
INSERT INTO kms_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas ni puq nand kin te otiwo Pita ni pughe gri nati di God gre yuwon ye te bei nand kin te ningg bu puq nand. Muq Jisas Pita ningg nari, “Nge nde dobu ghawi.” ");
INSERT INTO kms_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita trombui nandi, Jisas nikin wute te kin ye iri Jisas nikin yawo nirang righe kin te ninde dobu naru nuqoind. (Wuti nen te asi mir mand mand mas di ni yimb nondo Jisas pengu nindig nari, “Wuti tughe ei nu veri nde si pe ni godo,” puq nand kin te.) ");
INSERT INTO kms_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ni nuqoind di pengu nand nari, “Yumbui, te muq ni pughe gri?” ");
INSERT INTO kms_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas oyi nand nari, “Nge ni nati segine nas nge mune gadi ningg kari, tedi nu te kin ningg yivany ghare wayequ. Nu ngende ghawi.” ");
INSERT INTO kms_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pugri bu wand vir ir wute nganye buagi Jisas nei rimbig kin ni nei rimb kin riri Jisas ningg wuti nen ni nati segi ye. Pudi Jisas ni wuti te nati segi ye te ningg nari segi. Jisas nari, “Nge ni nati segine nas nge mune gadi ningg kari, tedi nu te kin ningg yivany ghare wayequ.” ");
INSERT INTO kms_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wuti nen bu yumbo ren ningg simbe nand, di ur nand. Beghi nei bab ni simbe nand kin te nganyene. ");
INSERT INTO kms_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas ni yumbo aye quan yembe nindiny. Quan buagine ur gad, tedi nge nei gab kin buk nganye buagi nganye, di wute buagi qi pe ven nde buk mawo rise kin sunyi segi. ");
INSERT INTO kms_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilus, nge buk ire ye wuwo ur gidiq, di Jisas ni yembe puate ni righe di wute wand bei nindim kin te kin bei guduw. ");
INSERT INTO kms_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Asine pu rindi muq nginy nen ningg ni ningg aposel ir nawo pre kin te wand nem. Ni Ququ Yuwon Ye ningg gre pe yembe kin wand ven yeri nindim nindim ruso ruso God Jisas nitanyi newo no. Wand ven kin nge buk aye pe ur gad pu rise. ");
INSERT INTO kms_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Asi ni yuqo nare di ni nati pre, otiwo muq ni nikin wute nde mune nandi. Di ni nikin ghimbi bei nindiny, te ei ni ruqond di nei rimb, riri, “Ni urupuine qa nas.” Ni nginy 40-pela pu ni ane ris, di ni wute God nde si nambu ris kin wand simbe nindiny. ");
INSERT INTO kms_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nginy iri ningg Jisas ni ane mir rind rind ris di ni simbe nindiny nari, “Nungoqi Jerusalem si wuraq wayequ. Nungoqi wasne, ei wuyi ni nari ni yumbo te neuq puq nand kin te ghimbi wany. Asi nge simbe guduq kin te. ");
INSERT INTO kms_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ni wute wuye tuan pe wuye nap. Pudi nginy quan segine di God ni ningg Ququ Yuwon Ye nungoqi nde nati ni.” ");
INSERT INTO kms_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Muq Jisas ningg wute Jisas nde irepene rikur muq ni pengu rindig riri, “Yumbui, muq ven nde puayi nu beghi wute Israel kin ghav gudug, di beghi munene yumbui pas di wute aye beghi nde si nambu ris bri?” ");
INSERT INTO kms_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Muq ni oyi simbe nindiny nari, “Pughe puayi yumbo isis ruwi kin te nge wuyi nikin gre pe nap ruso pre ye, nungoqi nei wamb tuqui segi. ");
INSERT INTO kms_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pudi otiwo God ningg Ququ Yuwon Ye nati ni nungoqi nde nas, tedi nungoqi gre wateri. Di segine nungoqi wand ware wo Jerusalem, di Judia buagi, di Samaria buagi, di tene ruso tiqe buagi qi wen wung yeru kin tende wo, wute nge ningg simbe wundiny.” ");
INSERT INTO kms_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ni wand ren puq nand pre, ni rar rar yeru, di God ni neti nowi di nitanyi wam newo no. Di ni wuye quari ire pe nar no, di ni mune ruqoind segi. ");
INSERT INTO kms_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ni no di ni nginy tu pe rar rarne yeru, muq brequne wute temi ni ane yemu. Ni temi chongo quem kin mare righe. ");
INSERT INTO kms_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ni temi mari, “Nungoqi wute Galili opu kin pughe kin ningg nungoqi nginy tu pe rar rar yequ? Jisas nen muq God nungoqi nde pu neti nowi di nitanyi wam newo no, di otiwo nungoqi muq wuqoind wuqoindne wam newo no kin pugrine nganye ei mune nandi.” ");
INSERT INTO kms_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Muq ni rand Oliv puq mindig kin te si meri, di mune Jerusalem mo. Rand Oliv ni Jerusalem tumone, 1 kilomita kin pugri. ");
INSERT INTO kms_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ni mo tiqe mar mo, di baj ire nyembe tevi, ire tingi, di ire wam kin tende mo. Di ni nyembe wam kin tende mewo mo mas. Wute men baj pe tende mewo mo: Pita di Jon di Jems di Andru, di Pilip Tomas temi, di Bartolomyu Matyu temi, di Jems Alpius ningg wo, di Saimon wute tit Selot kin iri, di Judas Jems ningg wo. ");
INSERT INTO kms_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wute buagi men ni pripri ire pe mas God ane wand mand mand. Nyumbueg ninge di Maria Jisas ni kumo di Jisas ni kiqam ni anene God ane wand rind rind. ");
INSERT INTO kms_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tende puayi Pita ni wute aye Jisas nei rimbig kin ninde mingine yenu, muq wand ire nand. Wute te buagi ane 120-pela kin pugri. ");
INSERT INTO kms_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pita ni nari, “Chech qam, muqdi nge Judas Iskariot ni wute Jisas mait nase kin ngim bei nem ye te kin simbe gad yamb. Asi God ningg Ququ Yuwon Ye Devit nei neng. Muq Devit wand nand, bu muq God ningg wand pe vise. Asi Devit simbe nand kin wand te nganyene ei puq ren ye, pugri bu muq Judas te kin tuquine puq nen. ");
INSERT INTO kms_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Asi Judas beghi ane pas. Ni beghi ane yembe wen pitaqwi.” Pita ni puq nand. ");
INSERT INTO kms_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas Jisas bei naind di wute aye mandi mait nase di Judas ni yumbo ur brequ ren puq nen ye te ningg ni wet bidi ninge nateri. Judas wet bidi te nare no, qi puch ire wong nindiq. Wong nindiq pre, muq ni qi pe tende ir naghe, di ni umbo bir kus, di umbo buagi qi pe groq ri. ");
INSERT INTO kms_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Otiwo wute buagi Jerusalem mas kin nei mamb. Muq nikin wand pe qi puch wen “Akeldama” puq munduw. Nyamb ven kin puate taq pugri: Yavi qi.) ");
INSERT INTO kms_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Muq Pita ni nari, “Wand ven beghi Buk Song pe pugri vise: ‘Ni baj piyi segine nase. Wuti iri tende nas segi kin.’ Di buk te aye pe opu wuri, ‘Wuti aye ei ni sunyi te nitangvi wuti ye nawo kin ningg nas.’ ");
INSERT INTO kms_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Pugri pu bu muqdi beghi wuti iri si bubog ei Judas ningg sunyi natevi. Wuti beghi ane pripri Jisas ane nyinge pare po badi po badi kin te ei iri paip no. ");
INSERT INTO kms_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jon ni wute wuye nap, di Jisas ni yembe nindiri riwo, yembe nand rindi God ni Jisas beghi nde pu neti nowi nitanyi newo no. Muq wuti yumbo buagi ren nuqond kin te ei beghi si bubog. Di ni beghi ane ei yembe bad, Jisas mune nes newo kin te kin wand bir pawo.” ");
INSERT INTO kms_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita ni pugri puq nand, muq ni wute temi si mumbom. Iri taq Josep, ni Barsabas nyamb mirang, ni nyamb aye mune visene, taq Jastus. Di wuti aye taq Matias. ");
INSERT INTO kms_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Muq ni God ane pugri wand mand, “Yumbui, nu wute buagi nei mamb kin te nei gubim. Nu mune beghi bei ndug, nu wute temi men yemu kin men nu pughe ye si gubog pre te beghi bei ndug, ");
INSERT INTO kms_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","te ei ni Judas ningg sunyi natevi, aposel ningg nas ei beghi ane yembe bad. Judas ni yembe wen si niraq di nati, muq nu sunyi kuping ruso pe tende no pre.” ");
INSERT INTO kms_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Muq ni wet wo map mewo di muqond Matias ni nyamb ye wuwo. Di muq ni aposel 11-pela te ane mikur. ");
INSERT INTO kms_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nginy iri Pentikos puq mindig kin te ningg ni buagi ane irepene rikur pu ris. ");
INSERT INTO kms_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Muq brequne nganye qurur yumbui wam pu rindi di wute buagi baj tende ris kin quan buagine qurur te rutungu. Qurur te nyumurighi yumbui naghe kin qurur pugri. ");
INSERT INTO kms_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Muq ni yumbo ninge wase nyungu kin pugri ruqond. Di yumbo te bir puch puch wute buagi te yeru kin ire ire ninde wam rise. ");
INSERT INTO kms_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Di God ningg Ququ Yuwon Ye Jisas ningg wute nde bre. Muq ni nei neny di ni segine wand tuan isis rind. ");
INSERT INTO kms_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Juda ninge kantri buagi aye pe mas kin mandi pu Jerusalem mas, wute te ni pripri God ningg wand mutungu ye. ");
INSERT INTO kms_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Qurur nyumurighi yumbui kin pugri mutungu, di wute buagi rindi rikur. Muq wute buagi kin kin rutungu Jisas ningg wute ni nikin nde wand tuan pene nganye wand mand. Muq ni puye rind, ");
INSERT INTO kms_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","di ni nei kumo rimb. Ni riri, “Pughe sin ren? Wute buagi men wand mand kin men ni Galili opu kinne. ");
INSERT INTO kms_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pughe gri qa te beghi wutamu manyi ire ire bon wand tuanne nganye putungu, beghi bon wuyi moyu nde mim pe putungu kin pugri nganye? ");
INSERT INTO kms_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Beghi kantri bon bonne badi. Beghi ninge Partia di Media di Elam kin, muq wute ninge Mesopotemia kin, di Judia di Kapadosia, di Pontus di Esia kin, ");
INSERT INTO kms_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","di Prigia di Pampilia, di Isip di beghi ninge kantri Libia Sairini tumo yequ ye te kin, di wute ninge Rom pu badi ren pas. ");
INSERT INTO kms_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Beghi Juda di wute aye kin ninge ane Juda mingg yumbo ur te pitaqwi, di Krit di Arebia, beghi quan buagine putungu. God ni yembe yumbui nand kin te kin wand beghi bon wand tuan pene nganye simbe mand.” ");
INSERT INTO kms_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Muq quan buagine puye mand di ni nei kumo mamb. Di kin kin pugri wand mand mari, “Yumbo ren pughe gri ate?” ");
INSERT INTO kms_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pudi ninge perei mand mari, “Ni wain quan nganye me, bu ngawu ghabe rind.” ");
INSERT INTO kms_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pudi Pita ni 11-pela pu te ane yemu di ni quan kumone ngam nare di pugri simbe nand, “Nungoqi Juda di nungoqi wute buagi wandi pu Jerusalem was kin te nungoqi nge nde ange waq, wand ven wutungu ei yumbo ren nei wamb. ");
INSERT INTO kms_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nungoqi nei wamb kin di wute men ngawu ghabe rindim. Segi. Muq 9 kilok burane, bu muq wain pe segine. ");
INSERT INTO kms_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Propet Joel God ningg wand simbe nand ye ni yabe yumbo ren ningg qa puq nand: ");
INSERT INTO kms_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God ni nari, ‘Otiwo ngeri muq pas kin ren pre ningg tumo di nge ningg Ququ te wute buagi keny ye. Di nungoqi quayi wo di nyumbueg wo ane propet kin pugri wand bir ruwo. Di nge nungoqi wo ambonye ruqo nyemb pe pugri yumbo isis bei gidim, di nungoqi wute gang te nge ruqo nyemb nganye kem. ");
INSERT INTO kms_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tende puayi di nge ningg Ququ Yuwon Ye ningg gre nge ningg yembe ye quayi di yembe ye nyumbueg keny, te ei ni propet kin pugri wand bir ruwo. ");
INSERT INTO kms_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Di nge nginy tu wam yumbo ur aye kin yembe gidiny, di nge nginy kitindi no burpoq nap, di irew kitindaq wuso yavi kin pugri ambo wuyo. Di nge tingi qi pe yumbo ur gre ye aye yembe gidiny. Yavi di wase di wasebo yumbui nganye ei ris. Muq tende dobu di Yumbui nandi kin nginy. Ni nandi kin nginy te di yumbui nganye. ");
INSERT INTO kms_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Di wute Yumbui munene nateri ningg riri, tedi Yumbui ghav nindiny di ni ni ningg wute ris.’ ");
INSERT INTO kms_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Wute Israel kin, nungoqi wand ven wutungu. Nge Jisas Nasaret kin ningg simbe guduq yamb. Nungoqi non gri qa yumbo ur gre ye di yumbo ur God gri Jisas nde si pe nungoqi nde mingi puq nen ye wuqond. Ni puq nen ei nungoqi nei wamb God ni Jisas tiqi nundog nandi. ");
INSERT INTO kms_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Asine God ni nei namb di wand taq namb pre, bu wuti nen nungoqi nde si pe nowi nas. Di wute brequ nde si pe nungoqi kruse pe qungu wi nati. ");
INSERT INTO kms_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pudi matmat wuit nase gre pu nase tiq segi, bu God wuti nen mune nindingi newo. Ni nati kin yuqo brequ buagi te mune puaq nindig. ");
INSERT INTO kms_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yabe nganye Devit mune Jisas ningg pugri puq nand: Nge pripri Yumbui guqoid nge nde tumone nganye nas. Ni nge nde tumo nas, pugri bu nge yumbo ninge ningg wune gab segi. ");
INSERT INTO kms_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pugri bu nge umbo chumbuai nganye gud, di nge wand chumbuai kin simbe gad. Nge ningne yumbo yuwon kin ghimbi kuany. ");
INSERT INTO kms_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Muq nu nge ququ mati kin tiqe pe si kueri nas segi. Di nge nunon wuti yuwon ye si kueri matmat pe kase sigh gab segi. ");
INSERT INTO kms_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nu nge yuwon pu kas kin ngim bei gudigh pre. Muqdi nu nge temu pas, di te kin ningg di nge quan nganye chumbuai gad. ");
INSERT INTO kms_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Chech buagi, nge beghi koku Devit ningg oghi pune simbe guduq ningg. Ni nati pre, di ngamo mowi. Di ni ngamo beghi nde mingine yequ yequ rindi rindi muq. ");
INSERT INTO kms_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pudi Devit ni propet, bu ni nei namb God ni pugri puq nand nari, ‘Otiwo nu nuqo dobu iri si gubog, di ni nu kin pugrine king ningg nas.’ ");
INSERT INTO kms_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Asi Devit ni God otiwo yumbo puq nen kin nuqond pre, di nari otiwo di Kraist mune nes newo. Ni nari, God ni mati kin tiqe pe si neri nase tiq segi. Di ni ghimbi sigh rimb tiq segi. ");
INSERT INTO kms_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Muq Jisas te God nindingi newo pre. Beghi quan buagine ni buqoid pre, muq beghi simbe buduq. ");
INSERT INTO kms_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Muq God ni nitanyi wam newo no, di ninde si tuan pe nas pre. Wuyi ni Ququ Yuwon Ye neng pre, te asi ni neng puq nand kin pugrine. Pugri bu muq Ququ te kin nengu pre, di nungoqi wuqond di wutungu. ");
INSERT INTO kms_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Jisas ni puq nen kin te asi Devit wand nand kin te ane tuquine. Devit wam newo no segi, pudi ni kin oyine nari, Yumbui ni nge yumbui pugri simbe nindig nari, ‘Nu nge nde si tuan pe ghas ruso ruso ");
INSERT INTO kms_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nge nu veri nu nyinge yi viyo kin komboiq woju ningg kawo mas.’ ");
INSERT INTO kms_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Pugri pu bu nungoqi wute Israel kin wand ven ei wutungu yuwon. Jisas nen nungoqi kruse pe qungu wi nati ye te muq God ni yumbui ningg nowi nas, di Kraist ningg nas.” Pita pugri wand nand. ");
INSERT INTO kms_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ni Pita wand ven simbe nand kin te rutungu, muq ni wand ven ningg umbo pe quan nganye yivany rire. Di ni Pita di aposel aye te ane pugri simbe rindim, “Chech buagi, muqdi beghi pughe sin ei pen?” ");
INSERT INTO kms_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Muq Pita ni simbe nindiny nari, “Nungoqi wutaqu manyi ire ire nei ware tinde, di Jisas Kraist nde nyamb pe wuye pupuqu, tedi God nungoqi yumbo ur brequ wand kin wand puaq nunduq. Nungoqi pugri puq wen, tedi God nikin Ququ Yuwon Ye nungoqi neuq. ");
INSERT INTO kms_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yumbui ni beghi God, di ni asine puq nand pre, nari ni wute ninge ngam nirany rindi kin te Ququ Yuwon Ye neny ningg nari. Pugri ni Ququ Yuwon Ye neuq ningg nari, di nungoqi wo neny puq nand, di wute ninge wonji ris kin te neny puq nand.” ");
INSERT INTO kms_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Di Pita ni wand aye nganye buagi pe wu wand nindiny, di ni quan kumo nganye pugri simbe nindiny nari, “Nei wamb yuwon: Eti nungoqi wute brequ kin te anene yuqo neuq.” ");
INSERT INTO kms_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pugri bu wute ninge Pita ningg wand oghine matevi, di ni wuye map. Nginy te ningg wute 3 tausen kin pugri ni Pita ningg wand rutungu rindi asi ye te ane rikur. ");
INSERT INTO kms_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Di ni aposel wand bei meny kin te rutungu ningg buid nganye rip, di ni umbo ire kuse, di ire pe mir rind, di anene God ane wand. ");
INSERT INTO kms_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God ni aposel nde si pe yumbo ur gre kin yembe nindiny, bu wute buagi wune rimb. ");
INSERT INTO kms_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Muq wute buagi Kraist nei rimbig ye te ire pene ris. Muq ni nei rimb ni te yumbo sir buagi te wute God nei rimbig ye te anene ye. ");
INSERT INTO kms_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ni pripri qi puch o yumbo yumbo ni ningg riteri, wute aye rem wong mand. Di ni wet bidi te kin riteri, di wute buagi mir o yumbo yumbo segi kin te ire ire reny. ");
INSERT INTO kms_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ni quan buagine umbo ire kuse, di nginy manyi manyi God ningg baj pe ruso. Di ni umbo irene kuse, ni chumbuai rind, di oyi oyi kimand nde baj pe ruso ane ire pe mir rind. ");
INSERT INTO kms_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pripri ni God nyamb rindivi viyo, di wute buagi ni yuwon ruany. Nginy manyi manyi Yumbui wute ire ire mune nate ruwi, di ni rindi wute asi God ningg wand rutungu kin te ane rikur. ");
INSERT INTO kms_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nginy iri ningg Pita Jon temi 3 kilok pugri pe ni God ningg baj pe mo ei God ane wand. Te pugri Juda buagi ni pripri 3 kilok di God ane wand mand. ");
INSERT INTO kms_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Muq wuti iri ni nas, ni nyinge brequ ye. Ni kumo pugrine wuri wundi ye. Nginy manyi ni God ningg baj ngimrawu pe ei mowi nas, ngimrawu te ni nyamb, “Yuwon nganye.” Ni pripri wute God ningg baj pe rir ruso di ni wet bidi sang nipiny. ");
INSERT INTO kms_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita Jon temi God ningg baj pe mar mo ningg, muq wuti nen ni simbe nindim ei ni wet bidi ninge meng. ");
INSERT INTO kms_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Muq Pita Jon temi muqoind muqoind pre, muq Pita ni nari, “Nu beghi temu ndomu.” ");
INSERT INTO kms_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Muq ni tindi nondo, ni temi nuqond. Ni nei namb kin nari, “Muqdi temi nge yumbo megh.” ");
INSERT INTO kms_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pudi Pita ni nari, “Nge wet bidi segi. Nge nu ghav guduw, di Jisas Kraist Nasaret ye ni gre pe nge nu simbe guduw, nu yes yewo nyinge ghare yo.” ");
INSERT INTO kms_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Muq ni si tuan niting kuse di ni nindingi newo. Muq brequne ni nyinge jam di op rar mune gre rind. ");
INSERT INTO kms_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Muq ni brequne nes newo, teti pu yenu, di nyinge nare. Di ni temi te ane God ningg baj pe mar mo muq ni nyinge nare di ni prare newo, ni God nyamb nindivi viyo. ");
INSERT INTO kms_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wute buagi anene ni ruqoind, ni nyinge nare di God nyamb nindivi viyo. ");
INSERT INTO kms_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Muq ni nei rimb, wuti nen qa pripri ngimrawu pe nas, ngimrawu te yuwon nganye puq munduw ye tende nas wet bidi ningg nari. Ni te ruqoind, muq ni puyene rind, di quan nganye nei kumo rimb. ");
INSERT INTO kms_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ni Pita Jon temi sibraj ni, muq wute buagi rindi, ninde veranda God ningg baj pe rise kin tende rikur. (Veranda te nyamb mirany mari, “Solomon ningg veranda.”) Muq ni puyene rind. ");
INSERT INTO kms_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ni te nuqond di wute pugri simbe nindiny, “Nungoqi Israel ye wute, pughe kin ningg nungoqi ren nei kumo wamb? Pughe kin ningg beghi temu wundomu? Nungoqi nei wamb kin di wari, beghi bon gre o beghi bon yumbo ur ninge yuwon ye pe bu wuti nen yembe bidig nyinge nare no. Segi nganye. ");
INSERT INTO kms_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham di Aisak di Jekop di beghi koku mingg God ni nikin yembe ye wuti Jisas nyamb yumbui neng, bu ni ningg gre pe wuti nen nes newo. Asi nungoqi ni weti nowi, veri nde si pe wi nondo. Di Pailat ni si neri no ningg, pudi nungoqi segi puq wand. Di nungoqi dob weng. ");
INSERT INTO kms_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Wuti nen wuti yuwon ye nganye di yumbo ur tuquine puq nen kin nungoqi ni dob weng, di rar wuqoind taq pu yenu. Di nungoqi Pailat ningg wari ei wuti iri ni wute ni mati kin te ei si neri nungoqi nde nondo. ");
INSERT INTO kms_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jisas ni beghi pas pas te kin pas ye puate, pudi nungoqi ni wi nati pre. Pudi God ni ngamo pe pu mune nindingi newo. Muq nge temu nungoqi nde wand ren bir pawo. ");
INSERT INTO kms_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Beghi temu Jisas nei bibig. Pugri bu Jisas ningg nyamb pe ninde gri beghi God nei bibig ye te ningg bu wuti nen yuwon. Nungoqi wuti nen wuqoind di waip no kin tuqui. Beghi Jisas nei bibig, bu nungoqi nde rar pe ni wuti nen sabi nindig mune yuwon nas. ");
INSERT INTO kms_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nganyene nge chech qam buagi, nge nei gab, nungoqi oghine nei wamb segi bu nungoqi Jisas wi nati. Nungoqi wute nyamb kin mune pugrine ghabe mand bu Jisas mi nati. ");
INSERT INTO kms_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yabe chuqo nganye God ni propet buagi nde mim pe wand bir nawo, nari Kraist ni yuqo ei niraq. Muq nungoqi yumbo ur brequ ren kin puq wen ye te ni ningg wand te ane tuquine. ");
INSERT INTO kms_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Pugri bu muqdi nungoqi nei ware witinde, God nei wumbig, di ni nungoqi wand te puaq nunduq. Muq nungoqi puq wen, tedi Yumbui ni gre neuq ");
INSERT INTO kms_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","di ni Kraist nowi naghe nungoqi nde nandi, nungoqi ghav nunduq, di nungoqi yuwon pu was. Jisas ni Kraist wuti beghi nitamu powi ningg God naip no ye. ");
INSERT INTO kms_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Muq ni wam nas, di otiwo God yumbo yumbo buagi mune sabi nindiny yuwon pu yeru kin tende puayi di ni mune nandi. Te asi nganye nikin propet yuwon ye ni ningg wand mare mandi pugri qa simbe mand. ");
INSERT INTO kms_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Te pugri Moses ni Kraist ningg pugri puq nand: ‘Otiwo Yumbui nungoqi ningg God ni nungoqi nuqo iri neti nowi, di nge propet kas kin pugri nowi nas. Tedi nungoqi ni ningg wand wutungu, di ni ningg wand tene nungoqi mune puq wen. ");
INSERT INTO kms_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Muq nungoqi ni ningg wand wutungu segi, tedi God mune numbuequ wati, di nungoqi non wute Israel ane was ye tiq segi.’ ");
INSERT INTO kms_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Asi Moses ni pugri puq nand, di propet buagi wand te bir mawo ye te, Samuel di propet aye ni nde dobu mas kin, ni ngeri muq pas kin te ningg simbe mand. ");
INSERT INTO kms_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yabe chuqo propet God ningg wand simbe mand, di God nungoqi nuqo ane wand taq mamb pu bu muq wand taq mamb kin nungoqi nde vise. Asi God Abraham simbe nindig nari, ‘Otiwo nu nuqo nas, di nge ninde gri wute buagi qi pe kin yuwon kuany.’ ");
INSERT INTO kms_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God ni yembe ye wuti tiqi nundog nungoqi nde nondo ei nungoqi ye wawo ni ningg wand wutungu pre dobu muqdi wute aye mune rutungu. Di ni nungoqi yuwon nuauq, ni yuwon nuauq kin te nei nirauq nitindauq ei nungoqi yumbo ur brequ wand segi.” ");
INSERT INTO kms_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Jon temi wute simbe mindiny mindinyne, prist di wute God ningg baj yeng muaw ye ni mingg yumbui di prist mingg wute tit ire nyamb Sadyusi ni mandi. ");
INSERT INTO kms_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ni nei mamb mari, “Muqdi ni wute bu wand bei meny, ni Jisas ngamo pe pu nes di wute riti kin te mune res ye wand te simbe mand.” Pugri bu ni aposel temi te umbo ker muam. ");
INSERT INTO kms_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ni temi taq mamb, di muq yuram bu temi burpoq yemune yambgriq. ");
INSERT INTO kms_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pudi wute nganye buagi ni mingg wand te rutungu di ninge Jisas nei rimbig, di muq wute Jisas nei rimbig kin te riwo ruso 5 tausen. ");
INSERT INTO kms_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yambgriq muq Juda mingg wute nyamb kin, quayi kiyi, di ninge Moses ningg lo wute bei meny kin ni quan buagine Jerusalem mikur. ");
INSERT INTO kms_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas prist mingg yumbui mingg yumbui, di Kaiapas, di Jon, di Aleksander, di prist mingg yumbui ni mingg yavi ire mandi, ni ane mikur. ");
INSERT INTO kms_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ni aposel temi te mitami mandi, ninde rar ngimi yemu, muq ni pugri pengu mindim, “Nungoqi tughe ningg gre wateri di nungoqi tughe nyamb wurang bu yumbo ren kin yembe wundiny?” ");
INSERT INTO kms_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","God ningg Ququ Yuwon Ye ni Pita nde nas, di Pita ni simbe nindim nari, “Nungoqi wute nyamb kin, di nungoqi quayi kiyi. ");
INSERT INTO kms_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Muq nungoqi beghi temu wuti iri muange brequ kin te sabi bidig ye te ningg bu nungoqi pengu wand. Nungoqi wuti te pughe gri ni oghi kin te ningg bri beghi pengu wundug? ");
INSERT INTO kms_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Te muqdi nungoqi di wute buagi Israel kin nei wamb, te pugri Jisas Kraist Nasaret kin ni nyamb pe muq wuti nen op rar gre rind, muq nungoqi nde rar pe yenu. Nungoqi Jisas nen kruse pe qungu wi nati, pudi God mune ngamo pe pu nindingi newo. ");
INSERT INTO kms_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisas ni wet kin pugri, di ‘Wet te asi nungoqi baj yembe wundig kin wari brequ di kring waip no kin te muq wet te baj mingine nas di baj nare.’ ");
INSERT INTO kms_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Muq wuti aye pughe ye ei Jisas kin pugrine beghi ghav nundug? Muq wuti aye iri te kin muai nas ei ni nari di God beghi mune nitamu powi?” ");
INSERT INTO kms_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Jon temi wune mamb segi. Muq prist te muqond nei mamb ni temi skul mand segi, di nyamb segi kin. Pugri pu ni nei kumo mimbiq, di ni nei mamb asi ni temi Jisas ane mas. ");
INSERT INTO kms_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Muq ni wuti te muqoind, di ni ghimbi yuwon pre, muq ni ane yemu. Pugri bu ni wand aye ningg oyi mindim ye tuqui segi. ");
INSERT INTO kms_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Muq ni temi simbe mindim lotu kaunsil ningg baj te si miraq, raqe mar mo. Ni temi mo, muq ni pugri simbe mand, ");
INSERT INTO kms_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Beghi wute temi men pughe sin ei pem? Ni temi yumbo ur gre ye ren mand, bu wute Jerusalem kin te ruqond nei rimb pre. Muq beghi suqo pare tuqui segi. ");
INSERT INTO kms_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pudi eti wand ven viso wute buagi rutungu. Pugri bu beghi ni temi quan nganye segi puq bidim ei ni temi Jisas ningg wand te aye pe simbe mand segi.” ");
INSERT INTO kms_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Muq ni temi mari mandi di simbe mindim ni temi Jisas ningg nyamb pe wute aye ni ningg wand bei meny ye tiq segi. ");
INSERT INTO kms_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pudi Pita Jon temi ni wand te oyi simbe mindim mari, “Beghi temu God ningg wand si pare muq beghi nungoqi ningg wand tene putungu te kin God nde rar pe tuqui o segi? Te kin nungoqi nei wamb. ");
INSERT INTO kms_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pudi beghi wand segi yembu ye tuqui segi. Beghi yumbo yumbo buqod di ange pe putungu kin te ei wute nde bir pawo ye.” ");
INSERT INTO kms_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Wuti nen nyinge brequ pu nas ber 40-pela pu nawo pre, muq Pita Jon temi Jisas ningg gre pe ni sabi mindig. Wute buagi te ruqond, di God ningg nyamb rindivi viyo. Pugri bu lotu kaunsil ni Pita Jon temi brequ mindim ye tuqui segi, ni wute buagi ni oyi ker ruam ningg wune mamb, bu ni Pita Jon temi taq mamb segi. Pudi ni mune nganye ker muam pre di si mare mo. ");
INSERT INTO kms_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ni temi kaunsil si mare pre, muq ni mo, nikin kimand ris pe mo, muq ni prist mingg yumbui di quayi kiyi ni pughe sin mem kin wand te simbe mand omo. ");
INSERT INTO kms_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ni rutungu pre, muq ni ane ire pe rikur, muq God ane pugri wand rind: “Yumbui, nu King di nu qi di nginy tu di gherim te yembe gudiny, di yumbo yumbo buagi tende rise kin te yembe gudiny. ");
INSERT INTO kms_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yabe chuqo beghi koku Devit nu ningg yembe ye wuti ni nas, di nu Ququ Yuwon Ye tiqi gudog, ni nde no, ni nei neng, di ni wand nand nari, ‘Pughe kin ningg wute aye ni Juda segi ye ni nu umbo ker muaw? Pughe kin ningg wute ni nei brequ mamb? ");
INSERT INTO kms_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","King buagi kin kin qi pe ven nde ni yeng mand ningg sir map. Di wute nyamb kin ni Yumbui di Kraist ni nikin wuti si numbog pre kin te temi mi maghe mo ningg mari.’ ");
INSERT INTO kms_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Wand ren kin te muq nganyene nganye puq ren, Herot di Pontius Pailat, di wute Israel kin, di wute Juda segi kin ni mandi, tiqe wen wung mikur, ei Jisas mi naghe no ningg. Yabe chuqo nu si gubog nunon yembe ye wuti yuwon ye ningg nas. ");
INSERT INTO kms_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ni mandi, mikur, ei yumbo yumbo buagi asi nunde gre pe di nunde nei pe puq guad kin pugrine di puq men. ");
INSERT INTO kms_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Muq ni beghi oyi brequ mundug ningg mari, te ningg bu nu beghi nu ningg yembe ye wute beghi ghav ndug. Pugri ei beghi gre bad, ei beghi wune bab segi nu ningg wand bir pawo. ");
INSERT INTO kms_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Di nu wute num kin ghat rise di ni num oghi nganye. Muq yumbo ur gre ye ren kin nunon yembe ye wuti Jisas nde nyamb pe yembe bidiny.” ");
INSERT INTO kms_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ni God ane wand pre, muq God ningg Ququ Yuwon Ye nandi wute buagi nde nas di baj te ni rikur ye te tit vip. Muq ni God ningg wand bir ruwo. Ni wune rimb segi quan nganye simbe rind. ");
INSERT INTO kms_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wute God nei mimbig ye ni nei irene, di umbo irene kuse. Wuti iri ni yumbo yumbo nuqond segi pu muq ni nari, “Yumbo yumbo ren nge te.” Te kin segi. Yumbo yumbo buagi te mawo, muqdi ire ire mare mo. ");
INSERT INTO kms_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposel buagi ni Yumbui Jisas nes newo kin wand te bir mawo, te kin quan nganye gre vind. Di God nikin nde nei pene quan nganye yuwon nuany. ");
INSERT INTO kms_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wuti iri ni mir di yumbo segi nas segi. Te pugri wute ninge ni qi di baj tuqui kin ni yumbo yumbo te mi rundo wute aye wong mand, ni wet bidi materi. ");
INSERT INTO kms_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ni wet bidi te mare mandi, aposel mem. Di aposel ni materi, wute yumbo segi kin te meny. ");
INSERT INTO kms_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Muq wuti iri ni nyamb taq Josep. Muq aposel ni nyamb aye mirang mari Barnabas. Nyamb ven kin puate taq pugri: “Wute umbo neny kughe ye.” Ni wute tit Livai kin iri di ni ailan Saiprus kin. ");
INSERT INTO kms_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni qi puch ire wute aye kin ye ni nem. Muq ni qi kin wet bidi te nare nandi, aposel nem, di ni oyi wute yumbo segi kin te meny. ");
INSERT INTO kms_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wuti iri ni nyamb Ananaias, di ngam nyamb Sapaira. Ananaias ni wuti iri qi puch ire neng. ");
INSERT INTO kms_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Di qi te kin wet bidi puch te nikin nawo rise. Ni cham nare nandi aposel nem di nari ni quane nare nandi. Ni ngam wet bidi puch nawo rise kin te nei wumb pre. ");
INSERT INTO kms_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Muq Pita ni nari, “Ananaias, pughe kin ningg ate nu Satan rar guqoid nunde umbo pe nas, di nu God ningg Ququ Yuwon Ye wandoqi gudig, di qi puch te kin ye wet bidi cham nunon suqo kuare? ");
INSERT INTO kms_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Asi ni qi puch te wong mindiq segine tende puayi qi te nu non irine ye. Muq ni qi te wong mindiq pre, muq nu non wet bidi te kuat rise. Pughe ningg nu umbo pe pugri nei guab? Te nu wute wandoqi gudim segi. Nu God wandoqi gudig.” ");
INSERT INTO kms_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias ni wand ven nutungu, ni nati di pombri no. Di wute te kin mutungu, di ni quan nganye wune mamb. ");
INSERT INTO kms_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Muq quayi ambonye mandi, ni chongo pe imb maimb meri mo ngamo mowi. ");
INSERT INTO kms_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Otiwo aua teri ire ruso pre, muq Ananaias ni ngam wuyi wundi. Ni yumbo ur ren kin ye puq ren ye ni wutungu segine. ");
INSERT INTO kms_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Di Pita ni pengu nunduw, “Nungoqi tequ qi puch wen ye wet bidi pugri pu bu wateri o segi?” Muq ni ngam wuri, “Te nganye. Pugri pune qa.” ");
INSERT INTO kms_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Di Pita ni simbe nunduw nari, “Pughe kin ningg nungoqi tequ ane wand wand ware, muq Yumbui ningg Ququ wandoqi wundig, ei wuqond ni oyi numbuequ o segi? Nu tungu, wute nu ngaim ngamo mowi kin taq mandi pu ngimrawu ne te yemu. Muqdi nu mune meri mo.” ");
INSERT INTO kms_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Brequne nganye wute te wuti, di Pita nde muange tingine wuso wughe. Muq wute ambonye meyi mandi, wute te mundoq, wuti pre. Di miraq mo, ni ngaim nde ngamo pe tumone muaq yequ. ");
INSERT INTO kms_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wute tit Jisas nei rimbig kin di wute buagi wand ven rutungu kin ni quan nganye wune rimb. ");
INSERT INTO kms_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jisas ningg aposel yumbo ur gre ye isis wute buagi nde rar pene yembe mindiny. Di wute buagi Jisas nei rimbig kin ni umbo ire kuse, di ni pripri veranda God ningg baj pe rise kin tende rikur. Veranda te ni nyamb mirany mari, “Solomon ningg veranda.” ");
INSERT INTO kms_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wute aye Jisas nei rimbig segi kin ni Jisas ningg wute ningg nyamb rindivi viyo, pudi ni wune rimb bu ni rindi ane ire pe rikur segi. ");
INSERT INTO kms_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Di wute quan nganye Yumbui nei rimbig, muq ni riyi ri ninde opu rise. ");
INSERT INTO kms_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pugri bu wute buagi nikin wute num kin rire rindi, ngimne ruwo rise, di ede isis pe ruwo rise. Ni riri, pugri pu rise, ei ninge Pita ni nyinge nare no di ni ququ te ninde wundo ningg. ");
INSERT INTO kms_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wute buagi tiqe manyi manyi Jerusalem tumone yeru kin te ni anene rindi rikur. Ni wute num kin di wute ninge ququ brequ ninde yemu kin te ritari rindi. Muq wute buagi ren mune yuwon ris. ");
INSERT INTO kms_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wute buagi ni aposel mingg wand rutungu. Pugri bu prist mingg yumbui mingg yumbui di wute buagi ni ane mas kin ni umbo brequ nganye rise. Wute te prist tit ire Sadyusi puq mindim ye te kin. ");
INSERT INTO kms_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ni mes mewo, aposel te mat mase taq mamb wute brequ kin te ane mas. ");
INSERT INTO kms_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pudi burpoq Yumbui ningg angelo iri taq yemu kin baj ye ngimrawu bi nuaq, ni ni meyi mi, ");
INSERT INTO kms_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","di nari, “Nungoqi wo, God ningg baj pe war wo, di yequ wute yuwon pu ris kin wand ren otinde simbe wundiny.” ");
INSERT INTO kms_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jisas ningg aposel ni ven mutungu, di ni burane nganye mes mewo mo, God ningg baj pe wute wand bei meny meny yemu. Muq prist yumbui mingg yumbui nikin wute ane mandi, di Juda mingg lotu kaunsil di Israel kin quayi kiyi te ngam miram mandi mikur. Lotu kaunsil te Israel nikin quayi kiyi. Muq ni taq yemu kin baj pe wand mi viso, ei ni Jisas ningg aposel mitami mandi. ");
INSERT INTO kms_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wute God ningg baj yeng muaw kin ni taq yemu kin baj pe mo rar mat, pudi aposel tende mas muqond segi. Ni mune mo, pugri simbe mindim, ");
INSERT INTO kms_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Beghi taq yemu kin baj kin ngimrawu buqod, di ngimrawu miqu gre, di wute yeng mawo yemu kin ni ngimrawu buagi tende yeng mawo pu yemu. Di beghi ngim bi pawo, pudi beghi wuti iri tende nar yenu buqoid segi.” ");
INSERT INTO kms_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Muq wute God ningg baj yeng muaw ye ni mingg yumbui di prist mingg yumbui ni wand ven mutungu di mari, “Muqdi yumbo pughe sin ei ren?” ");
INSERT INTO kms_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Muq wuti iri nandi ni simbe nindim, “Wutungu, wute buagi men nungoqi taq wamb pre kin te ni muq God ningg baj pe mar mo wute wand bei meny meny yemu.” ");
INSERT INTO kms_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pugri mutungu, di wute God ningg baj yeng muaw ye ni mingg yumbui di nikin wute te ane mo aposel te mat mase. Pudi ni mamb segi. Ni wune mamb di mari, “Eti wute beghi wet pe rumbuemu.” ");
INSERT INTO kms_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ni aposel mitami mandi Juda mingg lotu kaunsil buagi nde rar pe mawo yemu. Muq prist yumbui mingg yumbui ni simbe nindim, ");
INSERT INTO kms_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nungoqi nyamb ven ningg wute wand bei weny kin te ningg qa beghi segi nganye puq bad. Pudi nungoqi wand ven Jerusalem pe bre wand. Di Jisas ni nati kin te ningg beghi si wumbog.” ");
INSERT INTO kms_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pudi Pita di aposel ninge te ane pugri oyi mand, “Beghi God ningg wand pene ei po. Beghi wute ningg wand pe po segi. ");
INSERT INTO kms_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nungoqi Jisas kruse pe qungu wi nati, pudi beghi koku mingg God mune nindingi newo. ");
INSERT INTO kms_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God ni nitanyi newo no, di ni si tuan pe nowi nas di ni wuti ye nawo kin di beghi nitamu powi kin ningg nas. Te ei ni beghi wute Israel kin ghav nundug ei nei pare pitinde, di beghi wand puaq nundug kin. ");
INSERT INTO kms_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Beghi wutamu yumbo buagi ren ningg wand bir pawo, di God ningg Ququ Yuwon Ye mune wand ren bir nawo. God ni wute pripri ni ningg wand rutungu kin ni Ququ Yuwon Ye neny.” ");
INSERT INTO kms_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Juda mingg lotu kaunsil te mutungu, muq ni umbo ker nganye mawo, di ni aposel te mi mati ningg mari. ");
INSERT INTO kms_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pudi lotu kaunsil iri yenu. Ni Parisi iri, ni nyamb Gamaliel. Ni wute Moses ningg lo wute aye bei meny ye iri, di wute buagi pripri ni nyamb rindivi viyo. Gamaliel ni aposel temi te tiqi nundom dabo mar mo musoq ju yemu. ");
INSERT INTO kms_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Muq ni lotu kaunsil ninge te simbe nindim, “Nungoqi wute Israel kin, muq nungoqi wute men pughe sin wem ningg nungoqi nei wamb yuwon muqdi. ");
INSERT INTO kms_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Te pugri nungoqi nei wamb asi wuti iri Teudas ni nes newo, nari, ‘Nge wuti yumbui ye, nge nyamb kin.’ Puq nand di wute 400-pela pu ninde dobu maru. Pudi wute aye ni mi nati, di wute ni wand mutungu dobu maru kin wu mase ire ire mo, di ni yembe te ir wughe. ");
INSERT INTO kms_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ninde dobu gavman wute nyamb mitanyri kin tende puayi Judas Galili kin nes newo, wute nei qo nimbiny. Di wute buagi ni nde opu mase, di gavman bub mare mo ningg yeng mindiqi wuyo. Pudi ni mi nati, di wute ni wand mutungu kin ni wu mase ire ire mo. ");
INSERT INTO kms_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pugri bu muq nge simbe guduq, wute men ningg nungoqi kring wo ei wute men si ware mas. Te pugri wute men nikin nei pene yumbo ren puq men, tedi ni yembe te mune ir wughe ye. ");
INSERT INTO kms_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pudi yembe wen God ningg tedi nungoqi wat mase mas kin tiq segi. Eti nungoqi God ane yeng wand.” ");
INSERT INTO kms_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Di ni Gamaliel ningg wand mutungu. Ni aposel ngam miram mandi muq mari di pug mindim. Ni Jisas ningg nyamb pe wand mand kin te ningg segi nganye puq mindim. Pre muq si mare mo. ");
INSERT INTO kms_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Juda buagi ni Jisas brequ mindig ningg aposel oyi brequ mindim. Aposel ni mai te kin mare ningg chumbuai mand, te pugri ni nei mamb God ni nei nimbim ni Jisas ningg nyamb pe mai mare kin tuqui. Pugri bu ni lotu kaunsil si mare di chumbuai mand mand mo. ");
INSERT INTO kms_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Di nginy manyi God ningg baj pe di wute nikin baj pe ni pripri God ningg wand bei mindiny. Ni Jisas ni Kraist kin te kin wand yuwon ye bir mawo kin suqo mare segi. ");
INSERT INTO kms_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tende puayi Jisas ningg wute nganye buagi nganye. Jisas ningg wute buagi wand Grik nei rimb ye ni Jisas ningg wute ninge wand Hibru rutungu ye umbo ker ruany. Ni riri, “Nginy manyi nungoqi wute ninge mir segi kin tene bu ghav wundiny, pudi nungoqi beghi Grik kin nyarimo nyumbueg te mir ghav wundiny segi.” ");
INSERT INTO kms_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pugri bu aposel 12-pela pu ni mes mewo, Jisas ningg wute aye quan buagine ngam mirany rindi, muq ni mari, “Beghi wute God ningg wand ghav bidiny kin te si pare muq mir pawo te oghi rise segi. ");
INSERT INTO kms_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chech, pugri bu muqdi nungoqi nonne ven yequ kin ven kinne ei wute 7-pela pu wuqond. Ni wute nde nyamb yuwon vise ye, di God ningg Ququ Yuwon Ye ni nde nas ye, di nei yuwon ye rise ye. Di beghi wute 7-pela pu men ei yembe ven kin pe pawo mas, ei ni mir mawo. ");
INSERT INTO kms_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pudi beghi bonne ei pripri God ane wand, di wute God ningg wand ghav bidiny.” ");
INSERT INTO kms_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wute buagi ni wand ven rutungu, chumbuai rind. Di ni Stiven nyamb rirang, ni wuti God nei nimbig gre, di God ningg Ququ Yuwon Ye ni nde nas ye. Di ni Pilip nyamb rirang, di Prokorus, di Nikanor, di Timon, di Parmenas, di Nikolas. Nikolas ni Antiok kin, asi ni neyi nandi Juda nde opu nase. ");
INSERT INTO kms_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wute men aposel nde rar ngimi ruwo yemu, di ni God ane wand mand, si mem kuyo ei ni wute mir ghav mindiny ningg map mo. ");
INSERT INTO kms_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Di God ningg wand vir ir viso di wute nganye buagi Jerusalem ris kin ni Jisas ningg wute ningg ris, di prist nganye buagi mune Jisas nei mimbig. ");
INSERT INTO kms_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God nikin nde nei pene Stiven quan nganye yuwon nuang di gre neng, di ni wute nde yumbo ur gre kin isis bei nand. ");
INSERT INTO kms_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pudi wute ninge mes mewo Stiven ane wand pe mege. Wute te God yumbui nyamb mirang kin baj ire kin. Baj te Juda ni nyamb miraw mari, wute asi wute aye nde taq pu yemu yembe mand kin mune meyi mi ye ni God yumbui nyamb mirang kin baj. Wute men ni wonji pu mandi kin. Ni Sairini, di Aleksandria, di Silisia opu kin, di Esia opu kin. ");
INSERT INTO kms_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","God ningg Ququ Yuwon Ye Stiven nei yuwon nganye neng. Pugri bu wute ni wand nyinge muang vighe kin tiq segi. ");
INSERT INTO kms_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pugri bu ni suqo gri wute ninge simbe mindim, di ni oyi Stiven wandoqi mindig mari, “Beghi putungu ni Moses God temi wand brequ nindim.” ");
INSERT INTO kms_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wute buagi, quayi kiyi, di wute Moses ningg lo wute bei meny kin wand ven kin mutungu, di ni Stiven umbo ker muang. Muq ni mo, Stiven mait nase, di lotu kaunsil nde mitanyi mo. ");
INSERT INTO kms_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Di wute ninge wandoqi kin tende mawo yemu. Wute buagi te mari, “Pripri wuti nen God ningg baj yuwon ye wen di Moses ningg lo ane wand brequ nindiny. Te si nare segi. Pripri wand brequ nindiny. ");
INSERT INTO kms_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Te pugri beghi putungu ni nari, ‘Otiwo di Jisas Nasaret kin God ningg baj wen unje nipiq, di yumbo ur Moses beghi nengu kin te nare nitinde’!” ");
INSERT INTO kms_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Muq wute lotu kaunsil ningg mas kin te ni Stiven muqoind meri mase mase di ni quenge mundog angelo quenge kin pugri. ");
INSERT INTO kms_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Muq prist mingg yumbui ni yumbui ni nari, “Wand ven nganyene bu?” ");
INSERT INTO kms_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Muq Stiven ni nari, “Chech buagi di wuyi buagi, nungoqi wutungu! Asi beghi koku Abraham kantri Mesopotemia nas, ni Haran no segine, tende puayi God quan ti nase ye ninde nandi. ");
INSERT INTO kms_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Muq God ni simbe nindig nari, ‘Nu qi wen si raq, nu nuse niqam si ghare yo qi puch ire otiwo ei nge nu bei guduw ye tende yo.’ ");
INSERT INTO kms_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pugri bu Abraham ni kantri Kaldia ningg qi te si niraq, muq ni no Haran nas. Tende nas ni kiyi nati pre muq God mune tiqi nundog nandi qi ven nde nas, muq nungoqi ven nde was. ");
INSERT INTO kms_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God ni Abraham qi nikin tene ninge neng segi. Qi puch woju nganye mune ire neng segine. Abraham ni wo segine kin tende puayi God wand taq namb di ni simbe nindig, otiwo ni qi puch neng di ni kuqo qi te mitaqwi. ");
INSERT INTO kms_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God ni pugri simbe nindig, ‘Nu ningg nuqo otiwo di wute aye ningg qi pe ris. Di wute tit te kin mes mewo ni unje map, di nu ningg nuqo taq pu yeru yembe rind di wet bidi riteri segi. Di ni ber 400-pela pugri tende yembe rind. ");
INSERT INTO kms_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nu ningg nuqo ninde taq yeru yembe rind. Pudi otiwo nge wute ren oyi brequ gidiny. Muq otiwo nganye di nu ningg nuqo ni qi te si riraq, di ven nde rindi nge yumbui nyamb riragh.’ God ni pugri puq nand. ");
INSERT INTO kms_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","God ni nari Abraham ghimbi dugu chongo pend nawo ei te ni God ane wand taq mamb ye yumbo ur, pugri bu dobu pu Abraham ni wo iri nas, ni nyamb Aisak. Aisak ni bur 8-pela pu nawo pre kiyi ni ghimbi dugu chongo pend nuang. Muq Aisak ni Jekop kiyi, di Jekop ni wo 12-pela pu te beghi Juda ningg koku mas. ");
INSERT INTO kms_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Beghi koku ninge ni kiqam Josep umbo ker muang, bu ni wute aye nde mi nondo ni wong maind mitanyi Isip mo ni tende taq yenu yembe nand. Pudi God ninde nas. ");
INSERT INTO kms_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tende ni Pero Isip ye king temi wand mand, God ni Josep nei yuwon ye neng, bu king ni quan nganye chumbuai nindig. God ni Josep ghav nindig, di ni mai puaq nindig. Pugri bu king ni Josep Isip kin yumbui ningg nowi nas, di king ningg yumbo yumbo buagi ninde si pe rise. ");
INSERT INTO kms_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Dobu pu muq Isip opu di Kenan opu mir segi mas, ni mai yumbui mare. Muq beghi koku ni mir pughe gri materi? ");
INSERT INTO kms_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Muq Jekop ni nutungu Isip mir rise. Muq beghi koku tiqi nundom mo, ");
INSERT INTO kms_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","pre otiwo munene tiqi nundom mo, muq Josep ni kise kiqam pugri simbe nindim, ‘Nge Josep.’ Pugri bu king Pero ni Josep ningg yavi ire nei nimbim. ");
INSERT INTO kms_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Muq Josep wand ni viso, muq kiyi Jekop ningg nari nandi. Di nikin kise kiqam ni ngam wo ane te 75-pela pu quan buagine ninde rindi. ");
INSERT INTO kms_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Muq Jekop ni naghe no Isip, di ni nati, di beghi koku anene mati. ");
INSERT INTO kms_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Di ni mare mandi, Sekem matmat pe mawo yemu. Yabe chuqo Abraham ni wet bidi ninge menare ruso, Hamor ningg wo ni mingg qi puch ire Sekem tende wong nindiq. ");
INSERT INTO kms_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Asi God ni wand taq namb di Abraham simbe nindig ni kuqo kantri te si miraq mune Kenan mo kin ngeri tumo rind. Tende puayi Isip pe Israel nganye buagi mas pre. ");
INSERT INTO kms_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pre dobu pu muq wuti iri ni king ningg Isip nas, ni Josep nuqoind segi. Josep ni asine nati pre. ");
INSERT INTO kms_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ni beghi koku yambu nirem, bu ni nari, beghi koku ni wo pe ruso di wo te rire ruso dabo ruwo rise ei riti. ");
INSERT INTO kms_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tende puayi Moses ni kumo wuri wundi. Ni quan nganye yuwon. Muq ni kiyi kumo baj pe ruwi nase irew teri ire. ");
INSERT INTO kms_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dobu pu muq mune riti nowi, dabo ruwi nase. Muq king Pero ningg kuwonyumbu wundi wuti nowi, muq ni kuwonyimi kin pugri bag wuimb. ");
INSERT INTO kms_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses ni Isip mingg nei di yumbo ur yuwon te nateri omo, muq ni oyi wand di yembe te ningg quan nganye gre nand. ");
INSERT INTO kms_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses ni ber 40-pela kin pugri muq ni yavi ire mas pe no ningg nei namb. ");
INSERT INTO kms_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ni nuqond Isip kin iri nes newo, Israel kin iri ni. Pugri bu Moses nes newo Israel kin te ghav nindig Isip kin te ni nati. ");
INSERT INTO kms_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muq ni nikin yavi ire te nei nimbiny di nei namb, ‘Muq nge yavi ire nei rimb nge ni ghav gidiny, di riri, “God ni beghi ghav nundug kin Moses nde si pe beghi ghav nundug”.’ Pudi Israel buagi ni Moses nei namb kin pugrine nei rimb segi. ");
INSERT INTO kms_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Nginy iri ningg Moses nandi nandi di wute Israel kin temi mege mege yemu nuqond. Di ni nandi yeng gure nuam ningg nandi. Ni nari, ‘Ei, pughe kin ningg nu nuse niqam nunon tequne wege?’ ");
INSERT INTO kms_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Pudi wuti iri ni aye te brequ nindig ningg ni Moses choch naip no, di oyi simbe nindig nari, ‘Wuti tughe nu simbe nunduw nu beghi ningg yumbui o beghi nde wand ir kuawo ningg kuas? ");
INSERT INTO kms_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nu nge kui bri ningg? Kambe pugrine nu Isip kin te kui nati.’ ");
INSERT INTO kms_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Ni puq nand, di Moses wu nase no. Ni no, Midian opu te no nas. Pre, dobu muq ni ngam no, di ni wo temi mas. ");
INSERT INTO kms_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ber 40-pela pu pre muq Moses Sainai rand tumone wute mas segi ye pe tende yenu. Nyumo kamo iri wase naimb naimb yenu, di Moses angelo iri wase nyungu wabe nar nas kin te nuqoind. ");
INSERT INTO kms_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses te nuqond, ni quan nganye nei kumo nimbiq. Muq ni nondo tumo yenu nuqond muq Yumbui ni simbe nindig nari, ");
INSERT INTO kms_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nge nu nuqo Abraham di Aisak di Jekop mingg God.’ Moses te nutungu di ni wune namb, ni buyaq nand di ni rar nat segi. ");
INSERT INTO kms_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Muq Yumbui ni pugri simbe nindig, ‘Sunyi muq nu yengu kin ven te nge te. Pugri bu nu nge nyamb gudivi viyo ningg nu su ir waq omone yeru. ");
INSERT INTO kms_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wute Isip kin nge ningg wute yumbo ur brequ mindiny ye te nge guqod pre. Nge ni quanji rind kin te kutungu pre. Muq nge kati ki, di ni ghav gidiny, di ni mai te puaq gidiny ningg. Pugri bu nu yes yewo. Nge nu tiqi gudow Isip mune yo.’ ");
INSERT INTO kms_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses nen asine Israel buagi ni choch maip no, ni simbe mindig mari, ‘Wuti tughe nu simbe nunduw nu beghi ningg yumbui o beghi nde wand ir kuawo ningg kuas?’ Wuti nen ne qa God ni tiqi nundog no ni mingg yumbui ningg nas di Israel mune nate mowi. God ni angelo nyumo woju pe nas ye ninde gri Moses wute Israel kin nde ye nawo ye yembe neng. ");
INSERT INTO kms_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ni mune Isip no, di yumbo ur gre ye isis nand. Muq ni wute Israel kin nitari Isip si riraq, di Gherim Ambo pe opu gri te ruso. Ni wute segi ye pe opu ris, ber 40-pela pu ruwo, di Moses ni mune yembe gre ye isis nand. ");
INSERT INTO kms_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Muq Moses nen Israel simbe nindiny, ‘Otiwo God ni nungoqi nuqo iri neti nowi di nge kin pugri propet ningg nowi nas.’ ");
INSERT INTO kms_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Dobu pu muq beghi koku qi wute segi kin tende rikur, di Moses ni ane ris. Ni Sainai rand pe God ningg angelo Moses temi wand mand kin ni ane ris. Ni wand te beghi pas pas otiwo kin te God nde pu natevi, muq beghi nengu. ");
INSERT INTO kms_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pudi beghi koku ni Moses ningg wand te rutungu yambu riri. Muq ni kring rip no, di ni Isip mune ruso ningg riri. ");
INSERT INTO kms_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ni Aron simbe rindig, ‘Nu beghi ambojig ninge yembe ndiny, ei ni beghi god puq bidiny. Moses nen beghi Isip pu nitamu nandi kin te muq muai nde no? Beghi ghabe bad.’ ");
INSERT INTO kms_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tende puayi Aron no wandoqi kin god ire bulmakau kin pugri yembe nunduw yequ, muq ni mir muaw te ningg yuwo rind. Ni wandoqi kin god nikin si pe yembe runduw kin te ningg quan nganye chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Ni pugri puq ren bu God ni dob neny, di nginy di irew di tomnji yumbo ren ni god kin pugri yumbui nyamb rirany. Ni pugri puq ren kin te propet ningg wand God ningg buk pe vise kin ane tiqne. Propet ningg wand buk pe pugri vise: God ni nari, ‘Nungoqi Israel, asi nungoqi ber 40-pela pu qi wute segi kin tende was, di nungoqi sipsip di bulmakau te wambui di mir wawo kin te nge mir wagh segi. ");
INSERT INTO kms_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nungoqi wandoqi kin god Repan ningg tomnji ququ te yembe wundig, di wandoqi kin god Molek ningg yumbui nyamb wurang kin sel baj te ware wo. Temi men nungoqi god kin pugri yumbui nyamb wuram. Pugri bu nge nungoqi tiqi gudouq Babilon opu gri te wo.’ ");
INSERT INTO kms_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“God asi Moses sel baj ire bei nindig kin ni pugri yembe nunduw. Beghi koku asi qi wuye di nyumo segi ye pe ris, di God ningg baj sel pe kin wen ni ris kin tende wuse, ni te rundoq di ni nei rimb, God ni ane ris. ");
INSERT INTO kms_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dobu pu muq beghi koku ni God ningg baj sel pe kin te riraq Josua ane rindi. God ni wute aye tende mas kin te kring nap mo. Beghi koku rindi wute aye mingg qi te ritaqwi, di tiqe te ninggne ris ris muq Devit mune nas. ");
INSERT INTO kms_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God Devit yuwon nuang, di ni Jekop ningg God ni ningg baj iri yembe nindig ningg pengu nindig. ");
INSERT INTO kms_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pudi ni baj te yembe nindig segi. Ni wo Solomon baj te yembe nindig. ");
INSERT INTO kms_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pudi baj wute si pe yembe mindiny kin te God wam nganye nas kin tende nas segi. Te kin te asi propet iri puq nand kin wand ane tiqne. Ni pugri simbe nindim: ");
INSERT INTO kms_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","God ni pugri puq nand, ‘Nginy tu te nge sia king, di qi te nge nyinge tende keq wuyo kin. Nge yumbui, pugri bu baj pughe gib vimb kin te yembe wundiny, pudi nge tende kas kin tuqui segi. Nge sunyi ire pene kas yawotuan kin tuqui segi. ");
INSERT INTO kms_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yumbo buagi ren nge nde si pe bu rise kin.’ ");
INSERT INTO kms_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Nungoqi ngawu gre nganye wand. Nungoqi umbo pe di ange pe wute God nei mimbig segi kin ni ange di umbo kin pugri. Pugri bu nungoqi God ningg Ququ Yuwon Ye wand wutungu yambu wari. Nungoqi nuqo puq men kin pugrine nungoqi mune puq wen. ");
INSERT INTO kms_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yabe chuqo nungoqi nuqo propet buagi unje map ningg mai isis mem. Ni wute buagi wuti tuquine nas kin wand te bir mawo ye te mi mati. Muq nungoqi wuti yuwon ye nen wetinowi veri nde wi nondo mi nati. ");
INSERT INTO kms_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nungoqi God ningg lo angelo nde pu wateri ye te nungoqi pugrine puq wen segi!” Stiven ni pugri puq nand. ");
INSERT INTO kms_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lotu kaunsil buagi ni wand te mutungu, di te ningg ni Stiven umbo ker muang di sawo mat ki. ");
INSERT INTO kms_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pudi God ningg Ququ Yuwon Ye Stiven nde nas, muq ni wam rar nat. Ni rar nat pune God ni quan nganye ti nase kin ti te nuqond. Di Jisas God nde si tuan pe yenu nuqoind. ");
INSERT INTO kms_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Muq Stiven ni puq nand, “Wutungu! Nge guqod wam ye ngimrawu bi viso, di Jisas wuti God nde pu nandi wuti nganye nas kin God nde si tuan pe yenu.” ");
INSERT INTO kms_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pugri bu ni quan kumone mari di ange tuq mamb, ni quan buagine mes mewo vig mamb mo Stiven mait nase. ");
INSERT INTO kms_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ni mait nase mitanyi mar mo tiqe dabo sange di wet nyaw pe mi. Wute Stiven wet nyaw pe mi kin te ni saket ir mawo, wuti ambonye iri nas kin tumone mawo ris. Ambonye te ni nyamb taq Sol. ");
INSERT INTO kms_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ni Stiven wet nyaw pe mi mi di Stiven pugri Yumbui simbe nindig, “Jisas nu Yumbui, nu nge ququ taqwi!” ");
INSERT INTO kms_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Muq ni pombri no sungomyu pe yenu di quan kumone nari, “Yumbui, ni pugri puq men ye te oyi ndim wayequ.” Stiven ni pugri puq nand, di opu nati. ");
INSERT INTO kms_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ni Stiven mi nati, muq Sol ni tende yenu nuqond di ni umbo yuwon gud. Nginy te ningg ni wute Jisas nei rimbig ye Jerusalem kin unje map di mai isis meny. Puq ren bu wute buagi Jisas nei rimbig kin wu rise ire ire Judia di Samaria opu ruso. Pudi aposel ne Jerusalem mas. ");
INSERT INTO kms_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wute ninge God ningg wand mutungu kin ni Stiven ngamo mowi di ni ningg yumbui quanji mindig. ");
INSERT INTO kms_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Muq Sol ni wute Jisas nei rimbig kin brequ nindiny nindiny. Ni baj manyi nar no, wute Jisas nei rimbig kin nateri. Di ni nitari no, taq namb. ");
INSERT INTO kms_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wute Jisas nei mimbig kin wu mase ire ire mo ye ni tiqe aye pe mas wand yuwon ye bir mawo. ");
INSERT INTO kms_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip ni tiqe ire Samaria yequ kin tende naghe no, Kraist ningg wand bir nuany. ");
INSERT INTO kms_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wute nganye buagi nganye ni Pilip ningg wand rutungu, di yumbo ur gre ye isis nand kin te ruqond, di wand nand ye te ningg ange ruaq yuwon. ");
INSERT INTO kms_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wute nganye buagi ququ brequ ninde mas, pudi muq ququ brequ te suquan moyi gri nyeq mand, di ni si mare wu mase mo. Muq wute nganye buagi ngape riti di nyinge brequ kin mune oghi. ");
INSERT INTO kms_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Pugri bu wute buagi tiqe te kin quan nganye chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tiqe tende wuti iri nas, ni nyamb Saimon. Asi ni pripri awo namb di mu nand. Ni puq nen di wute buagi Samaria kin nei kumo rimb. Ni pripri nari, “Nge yumbui.” ");
INSERT INTO kms_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Di wute buagi nyamb kin di nyamb segi kin quan buagine Saimon wandne rutungu. Ni riri, “Wuti nen God ningg gre ninde vise.” Gre te ningg ni Yumbui Gre puq rindig ye. ");
INSERT INTO kms_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pripri ni mu pe yumbo ur isis nand, di wute te ruqond, di ni nei kumo rimb. Di ni Saimon ningg wand rutungu ningg buid rip. ");
INSERT INTO kms_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pudi Pilip ni God ni yumbui nas kin wand di Jisas Kraist ningg wand yuwon ye bir nawo. Di wute buagi quayi nyumbueg ane Pilip ningg wand rutungu riri ni wand nganyene nand, di ni wuye nap. ");
INSERT INTO kms_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Muq Saimon mune pugrine God nei nimbig di ni wuye naip. Di ni Pilip nde naru. Ni yumbo ur gre ye isis nuqond, di nei kumo namb. ");
INSERT INTO kms_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposel Jerusalem mas kin ni wand mutungu wute Samaria kin God ningg wand ritevi. Pugri bu ni Pita Jon temi tiqi mundom ninde mo. ");
INSERT INTO kms_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Wute Samaria kin God ningg Ququ Yuwon Ye riti nowi segi, di ni ninde nati ni segine. Pilip ni wute te Yumbui Jisas nde nyamb pe wuye nap. Muq Pita Jon temi ninde mo, di God pengu mindig ei ni wute Samaria kin ghav nindiny ei ni Ququ Yuwon Ye neny. ");
INSERT INTO kms_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pugri bu muq ni temi ninde si meny kuyo, di ni Ququ Yuwon Ye riti nowi. ");
INSERT INTO kms_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon ni nuqond aposel temi te sine wute nde mi kuyo di ni Ququ Yuwon Ye riti ni. Di Saimon wet bidi ni temi nde nare nandi, ");
INSERT INTO kms_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","muq nari, “Nungoqi tequ gre te nge mune wegh. Te pu ei otiwo nge wuti iri nde si ki kuyo, di ni segine Ququ Yuwon Ye neti nowi.” ");
INSERT INTO kms_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pudi Pita ni simbe nindig nari, “God nikin nei pe beghi gre nengu, pudi nu kuari nu segine ei wet bidi pe wong guad! Nu puq guad ye te ningg otiwo nu nunon wet bidi anene brequ pe yo! ");
INSERT INTO kms_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","God nde rar pe nu umbo tuquine kuse segi kin te muq beghi God ningg yembe ren bad kin ren nde nu mune gheyi ghandi kin tiq segi. ");
INSERT INTO kms_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pugri bu muqdi nu nei ghare tinde di nei brequ ven dob yeny. Di Yumbui pengu ndig ei qond ni nu wand puaq nunduw kin tuqui bri. ");
INSERT INTO kms_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nge nu guqoid, nu God ningg yumbo ningg buyaq nganye guad, di yumbo ur brequ taq nganye rimb pu yengu.” ");
INSERT INTO kms_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Muq Saimon ni pugri oyi nand, “Nungoqi tequ ei Yumbui ane nge ningg wand wand, ei nge ghav nindigh. Te ei mai nungoqi tequ wari kin ren nge kare segi.” ");
INSERT INTO kms_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Di Pita Jon temi Yumbui ningg wand wute buagi simbe mindiny. Pre ni temi mune Jerusalem mo. Ni mo ngimi Samaria mingg tiqe nganye buagi wand yuwon ye bir muany. ");
INSERT INTO kms_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Muq Yumbui ningg angelo Pilip simbe nindig nari, “Nu bogisumb di nu yes yewo, ngim ire Jerusalem pu wuso Gasa kin te wung yo.” Ngim tende tiqe ninge yeru segi. ");
INSERT INTO kms_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Muq Pilip ni nes newo sir nap pre, nyinge nare. Ni no ngimi wuti Itiopia kin nuqoind. Ni wuti yumbui nyamb kin. Ni wute Kwin Kandasi Itiopia kin yumbo yumbo yeng muany ye yumbui. Wuti nen Jerusalem nandi God yumbui nyamb nirang pre, ");
INSERT INTO kms_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","muq mune no ningg. Ni nikin wilkar pe nas muq hos qo naimb. Ni buk propet Aisaia ur nindiq kin te nundoq nundoq no. ");
INSERT INTO kms_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Muq God ningg Ququ Yuwon Ye Pilip simbe nindig, “Nu wilkar tende ghondo.” ");
INSERT INTO kms_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Muq Pilip ni vig namb tumo nondo wuti te propet Aisaia ningg buk nundoq nundoq nas kin te nutungu. Di ni pengu nindig nari, “Nu wand te guqod ye puate nei gubiny o segi?” ");
INSERT INTO kms_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Muq ni pugri oyi nindig nari, “Wute nge puate simbe mindigh segine, tedi pughe gri ei nge nei gab?” Muq ni Pilip ningg nari, “Nu ghowi yi nge temu pas.” ");
INSERT INTO kms_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ni God ningg wand puch buk tende pe nuqond kin taq pugri vise: “Wute sipsip ire mumbueq wuti ningg mitaqi mandi, pudi ni wuri segi. Di sipsip iny pend muaw ir wughe, pudi ni wuri segi. Otiwo di wuti iri te kin pugrine mi nati ningg pudi ni nari segi. ");
INSERT INTO kms_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ni minyuw kin wand simbe mindig, di ni murundi naghe, di ni kot tuquine mutungu segi. Ni mi nati pre, muq ni qi pe ven nde mune nas segi. Pugri bu ni kuqo pughe ye ris be wute simbe mindiny?” ");
INSERT INTO kms_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wuti Itiopia kin ni wand te nuqond pre, muq Pilip ningg nari, “Nge nu pengu guduw, propet wuti tughe ningg bu wand ven puq nand? Ni nikin ningg puq nand, o ni wuti aye ningg puq nand?” ");
INSERT INTO kms_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Muq Pilip ni wand te kin puate bir nuang. Ni God ningg wand puch ven simbe nand nare no no, muq Jisas ningg wand yuwon ye te mune bir nuang. ");
INSERT INTO kms_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ni temi ngimne mo mo, wuye ire muqond. Muq wuti te nari, “Wuye te kuse. Nu muq nge wuye kuaip tiq bri?” ");
INSERT INTO kms_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Muq ni nari di wilkar yequ. Di Pilip wuti te temi wuye pe maghe mo. Muq Pilip ni wuye naip. ");
INSERT INTO kms_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pre, temi wuye si mare mowi mi, Yumbui ningg Ququ nandi, Pilip nitanyi no. Di wuti te Pilip mune nuqoind segi. Muq wuti te Jisas nei nimbig ye te ningg chumbuai nand, di wilkar pe newo no, di mune no. ");
INSERT INTO kms_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pudi God ningg Ququ Pilip nitanyi brequne nganye no Asotus yenu. Ni tiqe manyi wand yuwon ye bir nawo nawo no. Dobu ni no Sisaria no nar. ");
INSERT INTO kms_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol ni Jisas ningg wute namb riti ningg quan nganye buid nap. Puq ren bu ni prist mingg yumbui ni yumbui nde no, ");
INSERT INTO kms_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","di ni simbe nindig, di ni wute nyamb kin Juda God yumbui nyamb mirang kin baj Damaskus rise ye tende mas kin nyumo raqe ur nindim. Muq ni nyumo raqe te Sol neng. Nyumo raqe te puq wund: “Sol ni quayi ninge nuqond o nyumbueg ninge nuqond Jisas ningg ngim pe ruso, tedi ni segine taq namb, di Jerusalem nitari nandi.” ");
INSERT INTO kms_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Muq Sol ni no. Ni Damaskus tumo nondo nondo, brequne nganye pris kin pugri naghe, di ninde tuquine quan nganye ti nase. ");
INSERT INTO kms_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Di Sol ni no naghe qi pe nase. Muq ni nutungu mim ire pugri simbe vind, “Sol, Sol, pughe ningg nu nge pripri unje kuaip mai isis kuegh?” ");
INSERT INTO kms_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Muq Sol ni nari, “Yumbui, nu tughe?” Di ni nari, “Nge Jisas, nu pripri nge unje kuaip kuaip. ");
INSERT INTO kms_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Muq nu yes yewo, tiqe ghar yo. Otiwo di wuti iri nu pughe sin ei yen kin te kin wand simbe nunduw ye.” ");
INSERT INTO kms_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wute Sol ane mo kin ni wand ven mutungu, pudi ni wuti muqoind segi. Di ni pugrine wand segi pu yemu. ");
INSERT INTO kms_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ni yumbo quan nganye ti nase kin nuqond pre, muq ni nes newo rar bure nand, di rar burpoq rip. Segi di ni si miting kuse, mitanyi Damaskus mar mo. ");
INSERT INTO kms_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ni te nas nginy temi ire, pudi ni rar te pugrine burpoq rip pu rise. Di ni mir nand segi wuye ne segi pu nas. ");
INSERT INTO kms_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jisas ningg wuti iri ni nyamb Ananaias ni Damaskus ne nas. Ni ruqo nyemb pe pugri nuqond, Yumbui ni ningg nari, “Ananaias!” Di Ananaias nari, “Yumbui nge ven kas.” ");
INSERT INTO kms_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Di Yumbui ni simbe nindig nari, “Nu yes yewo, ngim ire ni nyamb Gi Wuti te ningg yo. Nu yo Judas nde baj pe wuti iri Tarsus kin ni nyamb Sol ni ningg pengu ghand. Ni nge pengu nindigh nindigh nas. ");
INSERT INTO kms_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Di ruqo nyemb pe pugri wuti iri nuqoind, ni nyamb Ananaias. Ni neyi nandi, ninde si neng kuyo, ei ni mune oghine rar nat ningg.” Yumbui pugri Ananaias simbe nindig. ");
INSERT INTO kms_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Muq Ananaias Yumbui pugri oyi nindig nari, “Yumbui, wute nganye buagi wuti nen ningg nge simbe mindigh kutungu, ni nu ningg wute Jerusalem kin yumbo ur brequ isis nindiny. ");
INSERT INTO kms_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Muq ni prist mingg yumbui nde nyumo raqe nitaqwi pre pu bu nandi ye. Ni wute ninge tiqe ven kin nuqond nu wand rutungu di nu ane wand, tedi ni taq namb.” ");
INSERT INTO kms_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pudi Yumbui ni Ananaias pugri simbe nindig nari, “Nu yo. Wuti nen nge yembe nindigh ningg kaip no pre ye. Otiwo ni nge wand nare wute buagi Juda segi kin di nikin king ane ninde no di Israel nde mune no ye. ");
INSERT INTO kms_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Otiwo di ni nge ningg wand bir nawo, di wute buagi ni oyi mai meng kin te kin simbe gidig.” ");
INSERT INTO kms_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Muq Ananaias nes newo no. Ni no baj pe nar no, muq Sol nde si ni kuyo di nari, “Chech Sol, Yumbui Jisas nu ngimi guqoid pre kin te nge tiqi nundogh bu gadi, ei nu munene oghine rar ghat, di God ningg Ququ Yuwon Ye nunde nas.” ");
INSERT INTO kms_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Muq brequne nganye yumbo Sol nde rar pe rise kin umo bidi kin pugri puaq ir riti righe, muq ni mune oghine rar nat. Muq ni nes newo nari di wuye maip. ");
INSERT INTO kms_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Otiwo Sol ni mir nand, muq ni mune buid nap. Nginy ninge Sol ni Jisas ningg wute ane Damaskus mas. ");
INSERT INTO kms_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Di brequne Juda God yumbui nyamb mirang kin baj buagi tende no Jisas ningg wand bir nawo, ni nari, “Jisas ni God ningg wo.” ");
INSERT INTO kms_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ni wand te kin nand, wute buagi puyene nganye mand. Ni mari, “Wuti pughe ye bu asi Jerusalem nas di wute nyamb ven qa rindivi viyo di ni unje nap mai isis neny? Wuti nen ne qa muq mune ven nandi ei wute ninge nyamb ven rire nutungu, tedi taq namb di nitari prist mingg yumbui nde no.” ");
INSERT INTO kms_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pudi Sol ni muq gre nganye nand. Di ni Jisas ni Kraist kin wand raqe nganye nindim, bu wute Juda kin Damaskus mas kin wand te mutungu, di ni oyi mindig tiq segi. ");
INSERT INTO kms_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nginy nganye buagi mo pre di Juda mandi irepene mikur, Sol mi nati ningg wand taq mamb. ");
INSERT INTO kms_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Di ni mi nati ningg wand wand mare kin te ni nutungu. Muq Juda buagi ni mi nati ningg mo vang ngimrawu manyi te yeng mawo pu yemu. Bogisumb burpoq ane yeng mawo. ");
INSERT INTO kms_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pudi Sol ningg wute ni wand mutungu ni Sol mitanyi mo vang pe mewo mo yemu di ni imbi yumbui ire wung naghe no nas muq ni vang kin windua pe gri sare pe mi naghe no. ");
INSERT INTO kms_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Otiwo Sol Jerusalem nandi, ni Jisas ningg wute aye te ane irepene mikur yembe mand ningg nari. Pudi wute buagi ni wune rimbig, di ni riri ni Jisas ningg wuti nganye segi ye, ni wuti aye bu. ");
INSERT INTO kms_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pudi Barnabas ni Sol nitanyi Jisas ningg aposel nde no. Muq ni Sol ngimi Yumbui nuqoind, di Yumbui ni wand neng di ni Damaskus pe wune namb segi Jisas ningg wand raqene bir nawo ye te kin simbe nindim. ");
INSERT INTO kms_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pugri bu Sol ni ane Jerusalem mas di ane irepene nyinge mare mo mandi. Di Yumbui ningg gre pe ni wune namb segi, di Yumbui ningg gre pe ni Jisas ningg wand raqe nand. ");
INSERT INTO kms_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ni pripri Juda ni wand Grik nei mamb kin te ane wand mand, di ane wand pe mege. Di ni mi nati ningg ngim meri mand. ");
INSERT INTO kms_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Otiwo Jisas ningg wute aye ni wand ven kin mutungu, di mes mewo Sol mitanyi maghe mo Sisaria di tiqi mundog Tarsus no. ");
INSERT INTO kms_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pugri bu muq wute buagi Jisas nei rimbig kin, Judia opu kin di Galili opu kin di Samaria opu kin, yuwon pu ris. Yeng te kin segi bu ni gre rind. Ni Yumbui nde si nambu ris, di God ningg Ququ Yuwon Ye gre neny. Di wute nganye buagi Jisas nei rimbig, di riyi ri ni ane ire pe rikur. ");
INSERT INTO kms_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita nyinge nare tiqe buagi no no, di tene no tiqe Lida mune naghe no, di God ningg wute Lida kin te ane ris. ");
INSERT INTO kms_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tiqe te ningg Pita wuti iri nuqoind, ni nyamb Ainias. Ni ngape buagi riti omo pre, di nyinge nare kin tiq segi, ni sunyi pene nas nas ber 8-pela pu nawo. ");
INSERT INTO kms_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Muq Pita ni ningg nari, “Ainias muq Jisas Kraist nu oghi sim naind pre. Nu yes yewo sunyi sabi ndiny.” Di brequne nganye Ainias nes newo. ");
INSERT INTO kms_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Muq wute buagi Lida di Saron kin te ruqond, di ni nei rire ritinde, Yumbui nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tiqe Jopa pe Jisas ningg wute ire wus, ni nyamb Tabita. Grik wand pe mari Dorkas. Pripri ni yumbo ur yuwon ye wund, wute ninge yumbo pughe kin segi di ghav wundiny. ");
INSERT INTO kms_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Muq yabe num yumbui wure di wuti pre. Di ni wuye ripiq. Te ni nikin yumbo ur pugri ye, wute riti di wuye rip, pugri bu ni wuye ripiq pre, muq rum ire nange yequ ye tende ruaq wuse, ei ni quanji runduw ningg. ");
INSERT INTO kms_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida Jopa teri tumo tumone yeru. Pugri bu Jisas ningg wute ni Pita Lida nas ye wand rutungu, ni wute temi tiqi mundom ninde mo, di ni Pita simbe mindig mari, “Nu beghi nde ghandi. Nu mune ghimbi ghawo wayequ.” ");
INSERT INTO kms_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Di Pita nes newo ni ane mo. Ni mo mo mar, di ni Pita mitanyi rum ire nange te ningg mewo mo. Wute buagi ngaim mati pre kin nyarimo ni rindi, Pita nde tumone yeru quanji rind rind. Dorkas asi wusne puayi chongo buagi di saket yembe wundiny kin te Pita bei rindig. ");
INSERT INTO kms_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Di Pita wute buagi tiqi nundony rir ruso omo, di ni sungomyu nisiri, muq Yumbui pengu nindig. Pre tindi nondo wute wuti kin te nundoq, muq nari, “Tabita nu yes yewo.” Di wute wuti pre kin te rar bure wundiq Pita wuqoind di wes wuyo wus. ");
INSERT INTO kms_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Di Pita ni si nituw rise, muq ni wes wuyo yequ. Di Pita wute God nei rimbig kin te di wute ngaim mati pre kin nyarimo te ningg nari rindi Dorkas mune neny. ");
INSERT INTO kms_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wand ven Jopa pe vir ir, di wute rutungu omo. Di wute nganye buagi Yumbui nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita Jopa nas nginy quan nawo. Ni wuti iri bulmakau chongo pe yumbo yembe nindiny kin ni nyamb Saimon ni temi mas. ");
INSERT INTO kms_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Rom kin wuti iri Sisaria nas kin ni nyamb Kornilius. Ni Rom kin ami 100-pela kin yumbui. Ami men ni nyamb miram mari, “Itali mingg ami.” ");
INSERT INTO kms_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ni di nikin yavi ire ane pripri God wune rimbig di nine rar ngimi ruwi nas ye. Ni pripri nikin wet bidi nateri, Juda kin wet bidi segi kin ninge neny, di ni pripri God ane wand ye. ");
INSERT INTO kms_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nginy iri ningg 3 kilok kin pugri ni ruqo nyemb pe pugri God ningg angelo iri ninde raqene nganye yenu nuqoind. Muq angelo te nandi nyamb nirang. ");
INSERT INTO kms_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Muq Kornilius ni te nuqoind quan nganye wune namb, pudi ni nari, “Nge yumbui, pughe sin ren?” Muq angelo ni Kornilius simbe nindig nari, “Nu kuari kin te God nutungu pre, nu wet bidi kuateri wute ninge wet bidi segi kin te kueny ye te God ni chumbuai nand. Di ni te nei nimbiny nimbinyne. ");
INSERT INTO kms_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Muqdi nu yo, wute ninge tiqi ndom Jopa mo, ei Saimon ni nyamb ire Pita ni mitanyi mandi. ");
INSERT INTO kms_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wuti nen ni Saimon ne iri ninde baj pe nas, ni bulmakau chongo pe let yembe nindim ye. Ni baj gherim qunambe ne vise.” ");
INSERT INTO kms_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angelo te Kornilius simbe nindig kin te mune no pre, di Kornilius wute temi ire pu nari mandi. Iri ami di temi ni nikin yembe ye wute. Ami te mune pripri God ninde rar ngimi nowi nas ye, di pripri ni Kornilius ane mas ye. ");
INSERT INTO kms_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Muq Kornilius ni angelo ningg wand te wute temi ire te waghine simbe nindim yuwon, muq tiqi nundom Jopa mo. ");
INSERT INTO kms_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ni nyinge mare mo mo ngimi mase. Yambgriq mune nyinge mare mo. Ni mo Jopa tiqe tumo mondo mondo, Pita baj pe newo no ei God pengu nindig ningg. Muq belo ningg tumo, ");
INSERT INTO kms_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","bu Pita mir gureg, be ni mir nand yamb nas. Ni muq qa mir ri righe pu yeru. Muq Pita ni rar ri righe ruso yumbo ninge nuqond. ");
INSERT INTO kms_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ni nuqond nginy tu bi kring viso, muq yumbo ire chongo gib wumb kin te nyang wi. Di yumbo ire ni qunyup 4-pela pu te wut rise di waghi waghi qi pe weq wuti wi. ");
INSERT INTO kms_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ni yumbo isis umo dabo kin di ghati di wapi ni chongo tende rir rise nuqond. ");
INSERT INTO kms_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Muq mim ire pugri simbe vindig, “Pita, nu yes yewo, umo ren ghambui, di ye.” ");
INSERT INTO kms_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pudi Pita ni nari, “Nge yumbui, nge puq ken tiq segi! Nge musoq ju mir uny kin ke segi ye.” ");
INSERT INTO kms_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Muq mim te mune pugri simbe vindig, “Yumbo God ni oghi puq nindiny kin te nu uny simbe ghand wayequ.” ");
INSERT INTO kms_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yumbo te kin riyi ri tevi ire rind pre, muq mune nginy tu pe rir ruso. ");
INSERT INTO kms_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Muq Pita ni tene nei kumo nimbiq nari, “Ruqo nyemb wen gibiq kin puate te pughe gri bri?” Ni tene nei nimbiq nimbiq nas nas, di wute Kornilius tiqi nundom kin te mandi. Ni mandi kin wute buagi Saimon ningg baj ningg pengu mindiny mindiny mandi mandi muq muqond. ");
INSERT INTO kms_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Muq ni ngimrawu tumone yemu di pugri ngam mare mari, “Saimon, ni nyamb ire Pita, ni ven nde nas o segi?” ");
INSERT INTO kms_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ni ruqo nyemb pe pugri yumbo nuqond kin te nei nimbiq nimbiq, muq God ningg Ququ Yuwon Ye ni Pita pugri simbe nindig nari, “Nu tungu, wute temi ire pu nu meri munduw. ");
INSERT INTO kms_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pugri bu nu nei kumo mbiq wayequ. Nge ningne bu tiqi gudom mandi. Nu yaghe yo ni qond ei ane wo, yambu ghari wayequ.” ");
INSERT INTO kms_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Muq Pita wute te yemu pe te naghe no, di ni simbe nindim nari, “Nungoqi nge meri wundigh kin nge taq ven gadi. Nungoqi pughe kin ningg wandi?” ");
INSERT INTO kms_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Muq ni oyi mari, “Beghi Kornilius, Rom kin ami 100-pela mingg yumbui ni tiqi nundog bu badi. Ni wuti yumbo tuquine puq nen ye, ni God nei nimbig, di wute buagi Juda kin ni pripri mari ni wuti yuwon ye. God ningg angelo yuwon ye iri ni simbe nindig nari, nu ninde baj pe ghondo, ei ni wand ninge simbe ndig.” ");
INSERT INTO kms_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pugri puq mand, muq Pita nitami baj pe mar mo, di bur ni ane mase. Yambgriq muq Pita anene mo. Di Jisas ningg wute ninge Jopa kin ni mes anene mo. ");
INSERT INTO kms_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ni nyinge mare mo mo ngimi mase, yambgriq mune mo mo Sisaria mo mar. Di Kornilius ni ghimbi nuang pu nas. Ni nikin yavi ire di nikin kimand te nari rindi ane ni ghimbi ruang rikur pu ris. ");
INSERT INTO kms_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ni Kornilius ningg baj pe nar no pune Kornilius nandi, Pita nde sungomyu sungomyu yenu yimb naghe, muq ni yumbui nyamb nirang. ");
INSERT INTO kms_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Muq Pita ni simbe nindig nari, “Nu yes yewo. Nge God kin pugri segi, nge nu kin pugri, nge wutine.” ");
INSERT INTO kms_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Muq Pita ni temi wand wand baj pe mar mo di wute buagi baj pe te rir ris ye te nuqond. ");
INSERT INTO kms_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Di Pita ni simbe nindiny nari, “Nungoqi nei wamb beghi Juda kin di nungoqi wute aye kin ane ire pe pas kin tiq segi. Te kin beghi Juda uny simbe nganye bad. Pudi God nge yumbo ren kin ningg pugri simbe nindigh nari, nge wuti iri puqum nimbiq puq gidig tuqui segi. ");
INSERT INTO kms_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pugri bu nungoqi wand wi vindo pu nge kas ye tuqui segi, nge gadi. Muqdi nge pengu guduq, pughe kin ningg nge wand wagh gadi?” ");
INSERT INTO kms_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Muq Kornilius ni Pita simbe nindig nari, “Kei muq nginy nase kin pugri pu nase nge yumbo ninge guqod. Yumbo te guqod kin tende puayi pu rindi muq nginy temi ire pu mo pre. Te pugri 3 kilok pugri pe nge nge ning nde baj pe kas, God temu wand bad. Nge God temu wand bad badne wuti iri ni chongo quan nganye ti riri kin nandi nge nde rar ngimine yenu. ");
INSERT INTO kms_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Muq ni pugri puq nand nari, ‘Kornilius, nu wand guad kin te God nutungu pre. Di nu pripri wet bidi di yumbo yumbo ninge kuateri di wute ninge yumbo yumbo di wet bidi segi kin te kueny kin te God ni nu chumbuai nunduw, di ni muq nu yumbo ur te nei namb nambne. ");
INSERT INTO kms_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pugri bu muqdi nu wute ninge tiqi ndom Jopa mo, ei Saimon ni nyamb ire Pita ni simbe mindig nandi. Pita ni wuti iri ni nyamb Saimon ne ni pripri kau chongo pe let yembe nindim kin ni temi mas. Ni baj gherim qunambe ne vise.’ ");
INSERT INTO kms_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pugri pu nge brequne wute te tiqi gudom nunde mondo, di nu wuti oghi ye bu wand kutungu di brequne guadi. Muq beghi quan buagine God nde rar pe ven pas, di Yumbui nu yumbo bei nunduw kin te beghi simbe ndug.” Kornilius ni pugri simbe nand. ");
INSERT INTO kms_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Muq Pita ni pugri simbe nand nari, “Nganyene nganye, muq nge nei gab God ni wute tit ire nei nimbiny di wute tit aye te si nare segi. Ni buagi anene nei nimbiny. ");
INSERT INTO kms_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Piyi ni Juda ane yavi ire segi ni aye kin, pudi ni ni ningg wand rutungu di yumbo ur tuquine puq ren, tedi God ni nate ruwi. ");
INSERT INTO kms_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Wand ven God beghi Israel simbe nundug, Jisas Kraist ni wute buagi mingg yumbui, di ni beghi nei nengu ei beghi God ane nei irene vise ye te kin wand yuwon ye bir mawo kin te nei wamb pre. ");
INSERT INTO kms_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nungoqi nei wamb, asi Jon ni wute wuye nap ningg wand bir nawo ye tende puayi yumbo puq ren ye nei wamb. Yumbo te kin Galili pu puate ri righe di ruso Judia opu te yumbui yeru. ");
INSERT INTO kms_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wand ven Jisas Nasaret kin ni ningg wand. God ni ningg gre di Ququ Yuwon Ye te Jisas neng. Pugri bu muq God ninde nas, bu ni tiqe manyi manyi te no, wute buagi ququ brequ mingg yumbui nde si pe ris kin te ghav nindiny di ni mune oghi. ");
INSERT INTO kms_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Muq beghi ni asi Jerusalem di beghi wutamu Juda kin nde ni yumbo ur nand kin wand te kin bir pawo. Wuti nen mi nati kin te ni kruse pe qungu mi nati. ");
INSERT INTO kms_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","“Pudi nginy temi mo pre aye ningg God ni nari di mune nes newo di raqene nandi. ");
INSERT INTO kms_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","God ni wute buagi nde Jisas raqe naind segi. Ni beghi God ningg wand raqe bad ningg manyi nundumu pre kin beghi ndene bu ni Jisas raqe naind. Asi ni mune nes newo kin tende puayi beghi ni ane mir bad di wuye pe. ");
INSERT INTO kms_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Muq ni beghi simbe nundug kin beghi wute nde wand pugri ei bir pawo: God ni Jisas irine naip no, otiwo di wute mati kin di wute urupuine mas kin ni mingg kot te nutungu. ");
INSERT INTO kms_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yabe propet buagi ni wuti God naip no kin nen ningg qa wand mand mari, otiwo wute buagi ni wuti nen nei rimbig, tedi ni ningg nyamb pe ni yumbo ur brequ rind kin wand te puaq nindiny.” ");
INSERT INTO kms_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wute buagi Pita God ningg wand te bir nawo kin te rutungu rutungu ne, God ningg Ququ Yuwon Ye ninde nati ni. ");
INSERT INTO kms_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Juda kin wute tit Jisas nei mimbig ye ni Pita ane mandi ye ni mutungu, ni God nyamb rindivi viyo kin te ni wand tuan isis pe rindivi viyo. Pugri bu puyene mand, muq ni mari, “God ni beghi Juda kinne Ququ Yuwon Ye nengu segi. Ni beghi di wute tit Juda segi kin anene Ququ Yuwon Ye nengu.” Muq Pita ni simbe nand nari, ");
INSERT INTO kms_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Asi Ququ Yuwon Ye beghi Juda kin nde nati ni kin pugrine muq ninde mune nati ni. Pugri bu muq beghi wute ren wuye pap kin te ningg Juda iri nari kin tiq segi.” ");
INSERT INTO kms_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Muq Pita mune simbe nindim nari, “Nungoqi Jisas Kraist ningg nyamb pe ei wute ren wuye wap.” Muq wute te Pita simbe rindig, “Muqdi nu beghi ane pas nginy quane pawo pre muqdi nu yo.” ");
INSERT INTO kms_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposel di Jisas ningg wute ninge Judia opu tiqe kin kin mas kin te wand mutungu wute Juda segi kin ni mune God ningg wand ritevi pre. ");
INSERT INTO kms_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pugri bu Pita mune Jerusalem no, di wute Jisas nei mimbig kin ninge ni ghimbi dugu chongo pend mawo kin ni ker muang. ");
INSERT INTO kms_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ni mari, “Nu wute ghimbi dugu chongo pend segi ye baj pe kuo di ane mir wand pre ye!” ");
INSERT INTO kms_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pudi Pita ni yumbo ur buagi nuqond kin te simbe nand. Ni nari, ");
INSERT INTO kms_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nge Jopa kas, nge God temu wand bad bad pas, di nge rar ri righe ruso, di nge yumbo ire ruqo nyemb pe pugri gudoq. Yumbo ire chongo yumbui gib wumb ye wuti wi. Yumbo ire ni qunyup 4-pela pu te wut rise, muq waghi waghi nginy tu pe pu weq wuti wi, nge nde wundi. ");
INSERT INTO kms_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nge oghine nganye nei gab ningg kari, bu nge otinde ququ kare, di umo buagi qi pe ven nde yeru kin, umo dabo kin, di ghati, di wapi buagi te guqod. ");
INSERT INTO kms_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Di nge kutungu mim ire nge simbe vindigh viri, ‘Pita, nu yes yewo, umo te ghambui, di ye.’ ");
INSERT INTO kms_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Pudi nge kari, ‘Yumbui, nge puq ken tiq segi! Nge musoq ju mir uny kin ke segi ye.’ ");
INSERT INTO kms_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Pudi mim te wam pu mune nganye viri, ‘Yumbo God ni oghi puq nindiny kin te nu uny simbe ghand wayequ.’ ");
INSERT INTO kms_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Yumbo ur ren kin puq ren tevi ire rind pre, mune wam riwo ruso. ");
INSERT INTO kms_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Di brequne nganye wute temi ire pu mandi, beghi pas kin baj tende bre mowi. Wuti iri Sisaria nas kin ni wute temi ire pu te tiqi nundom nge nde mandi. ");
INSERT INTO kms_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Muq God ningg Ququ nge simbe nindigh nari, ‘Nu ni ane wo. Nu nei kumo ghamb wayequ.’ Jisas ningg wute Jopa kin 6-pela pu men mune nge anene po, di po wuti te ningg baj pe par po. ");
INSERT INTO kms_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Di ni angelo iri ninde baj pe nar yenu nuqoind kin te kin wand beghi simbe nundug. Ni nari, angelo ni simbe nindig nari, ‘Nu wute ninge tiqi ndom Jopa mo, ei Saimon ni nyamb ire Pita simbe mindig nandi. ");
INSERT INTO kms_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ni ei nu wand ninge new, di wand te ningg God nu di wute nu non ane baj ire pe was kin te buagi ane mune nitaqu wowi.’ Wuti te beghi pugri simbe nundug. ");
INSERT INTO kms_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Muq nge wand gad, di asi Ququ Yuwon Ye beghi nde nati ni kin pugrine ninde mune nati ni. ");
INSERT INTO kms_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Di nge asi Yumbui ni puq nand kin wand te nei gibiny. Asi Yumbui ni nari, ‘Jon ni wute wuye tuan pe wuye nap, pudi nungoqi otiwo God ni ningg Ququ Yuwon Ye ei wuye nupuqu ye.’ ");
INSERT INTO kms_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Asi beghi Yumbui Jisas Kraist nei bibig bibig di God te ningg beghi ni ningg Ququ Yuwon Ye nengu. Muq God ni wute aye kin mune te kinne neny. Nge pughe gib gab ye ate nge God segi puq gidig?” Pita pugri puq nand. ");
INSERT INTO kms_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ni Pita ningg wand te mutungu, di ni mune ker mawo segi. Ni God ningg nyamb mindivi viyo, di mari, “Muq beghi nei bab wute Juda segi kin te mune nei mare mitinde God ne nei mimbig, tedi ni mune nate mowi di mas mas te kin mas ye.” ");
INSERT INTO kms_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Asi ni Stiven mi nati di wute Jisas nei mimbig kin unje map mai isis mem. Di te ningg wute Jisas nei mimbig ye wu mase ire ire mo, di tene mo Ponisia opu mo, ninge mo qi puch Saiprus mas, di ninge Antiok. Ni te mo mas di wute aye kin nde wand yuwon ye bir mawo segi, ni Juda ne simbe mindim. ");
INSERT INTO kms_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pudi wute ninge Saiprus kin di ninge Sairini kin ni ane mo Antiok, di ni oyi wute Grik kin nde mune wand bir mawo. Ni Yumbui Jisas ningg wand yuwon ye simbe mindim. ");
INSERT INTO kms_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Di Yumbui ni gre nem, bu wute nganye buagi nei rire ritinde Yumbui nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Di Jerusalem kin wute Jisas nei mimbig ye ni wand ven mutungu, ni mes mewo Barnabas tiqi mundog Antiok no. ");
INSERT INTO kms_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ni no no nar, di ni nuqond God nikin nde nei pene yuwon nuany, di ni chumbuai nand. Di ni wute buagi simbe nindiny ei ni Yumbui si riri segi kin. ");
INSERT INTO kms_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ni wuti yuwon ye, Ququ Yuwon Ye ni nde nas di ni God quan nganye nei nimbig gre ye, bu wute nganye buagi nganye Yumbui nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas te pre nand, muq ni Sol meri niting ningg Tarsus no. ");
INSERT INTO kms_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ni meri niting no no nuqoind, muq nitanyi mune Antiok nandi. Ni ber ire Antiok wute Jisas nei rimbig kin te ane ris, wute nganye buagi nganye God ningg wand bei meny. Antiok pe wute buagi ni Jisas ningg wute te ruqond di “Kristen” puq rindiny. Asi Jisas ningg wute ni pugri nyamb rirany segi, muq tene ni nyamb ven kin rirany. ");
INSERT INTO kms_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tende puayi propet, wute God nde pu wand matevi simbe mand ye, ninge Jerusalem pu Antiok mati mi. ");
INSERT INTO kms_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Propet iri ni nyamb Agabus, ni Ququ Yuwon Ye nde gre pe ni nes newo di simbe nand nari, otiwo di tiqe buagi qi wen wung yeru ye mir segi di ni mir ningg si rip riti. (Pre, otiwo Klodius king ningg nas kin tende puayi nganyene mir segi, di ni mir ningg si rip riti.) ");
INSERT INTO kms_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pugri bu Jisas ningg wute buagi wute Judia kin ghav mindiny ningg wet bidi ninge mi ruso ningg wand taq mamb. Wute buagi nikin ire ire nei mamb, wet bidi bir mawo ni cham rise, cham kimand Judia kin ghav mindim. ");
INSERT INTO kms_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ni pugri puq men pre, Barnabas Sol temi tiqi mundom wet bidi te mare mo wute Jisas nei mimbig kin quayi kiyi Jerusalem mas kin te mem. ");
INSERT INTO kms_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tende puayi King Herot nari di wute ninge Jisas nei rimbig kin te unje map mai isis meny ningg mat rise. ");
INSERT INTO kms_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ni Jems Jon ni kise mame dobui pe mi nati. ");
INSERT INTO kms_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ni nuqond ni Jems mi nati ye te ningg Juda ni chumbuai mand, di ni nari di Pita mune taq maimb. Herot ni Juda bret yis segi ye mir mawo kin tende puayi ni Pita Jems temi pugri puq nem. ");
INSERT INTO kms_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ni Pita nait nase pre, muq ni taq naimb. Muq ami tit teri aye teri pu yeru, di ami tit ire ire ami temi aye temi pu. Ami men Pita yeng muang pu yemu. Herot ni nei namb kin nari otiwo wute buagi ni God asi Israel mingg wo rar nuqond mas kin ngeri te nei mimbiny pre, muqdi ni Pita ni neyi ni wute buagi nde rar pene ei kot nand. ");
INSERT INTO kms_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pugri bu Pita ni taq pune yenu di ami buagi yeng muang yuwon. Pudi wute Jisas nei rimbig kin te ni God pengu rindig rindig ei God ni ghav nindig. ");
INSERT INTO kms_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Prangi di Herot Pita nitanyi kot pe no ye. Pudi pend ruso segine, bur te ningg ami opu opu mase muq Pita mingine nase. Ni sen temi pe si taq mimbig, di sen iri si opu kin ami iri nait nase, di sen opu kin ami aye nait nase. Muq ami ninge ngimrawu yeng mawo pu yemu. ");
INSERT INTO kms_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Muq brequne Yumbui ningg angelo iri taq yemu ye baj pe bre newo, di rum te ti nase. Muq ni Pita ut pe ni nondo nandi di buraq nindig. Muq angelo ni nari, “Nu brequne yes yewo.” Muq sen temi Pita nde si pe mase ye te kinne bure ir maghe. ");
INSERT INTO kms_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angelo ni simbe nindig nari, “Nu let taq ghaimb, su nyinge pe taq wundio.” Muq Pita ni angelo simbe nindig kin pugrine puq nen. Muq angelo ni simbe nindig nari, “Nu saket raq wughe, di nge nde dobu ghawi.” ");
INSERT INTO kms_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pre muq ni temi rum te si miraq di mo. Pudi angelo te puq nen kin te Pita ni nei namb segi, ni nari ni ruqo nyemb pe bri nuqond. ");
INSERT INTO kms_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ni temi nyinge mare mo, ami tit temi imb pe yeng mawo kin te ibe miram, di dodi ain kin tende mondo, dodi kinne bi wuso. Muq temi mar mo, ngim ire ningg nyinge mare mo. Nyinge mare mo mo di brequne angelo Pita si neri sei nand no. ");
INSERT INTO kms_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Muq Pita ni nei mune vinde vighe, ni nei namb, di ni nari, “Muq nge nei gab. God ni angelo tiqi nundog nandi ei Herot nde pu neti kowi, te ei Juda buagi ni nge pughe sin regh ningg riri pudi tiq segi.” ");
INSERT INTO kms_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ni ren kin nei namb pre muq ni no Maria, Jon ni nyamb ire Mak ni kumo nde baj pe no. Baj tende wute buagi miningne rindi rikur di God ane wand rind rind ris. ");
INSERT INTO kms_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Muq Pita nondo baj imb kin ngimrawu pe baq nand, di yembe ye nyumbueg ire ni nyamb Roda ni wundi ei ngim bi wang ningg. ");
INSERT INTO kms_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pudi ni Pita gibe ko wutungu, ni quan nganye yawo wure righe, di ni ngim bi wang segine vig wumb wur wuso ninge te simbe wundiny wuri, “Pita ngimrawu te yenu!” ");
INSERT INTO kms_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Muq ni Roda simbe runduw riri, “Nu ghabe bri guad?” Pudi Roda simbe wundiny wuri, “Nganyene nganye, ni te yenu.” Di ni riri, “Te ni ningg angelo bri?” ");
INSERT INTO kms_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pudi Pita ni ngimrawu baq nand nandne, di ni ngim bi ruang, muq ni ruqoind di ni puyene rind. ");
INSERT INTO kms_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Muq Pita ni si nipiny righe ei ni wand segi yeru. Muq ni wand segi yeru di ni taq yenu di pughe gri Yumbui ni ghav nindig ni neyi ni ye te simbe nand. Pre dobu muq ni mune pugri simbe nindiny nari, “Nungoqi wo, Jems di Jisas ningg wute aye yumbo ren kin ningg simbe wundim.” Pre, muq ni neyi ni aye pe no. ");
INSERT INTO kms_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yambgriq burane ne ami rar mat, Pita nas segi. Di ni quan nganye nei kumo mamb di vig mo mandi nikinne oyi oyi pengu mand mari, “Pita muainde no?” ");
INSERT INTO kms_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Muq Herot nari di ni Pita meri miting, pudi muqoind segi. Pugri bu ni ami te kotim nand, ei mi mati. Muq Herot ni Judia si niraq no, Sisaria nas. ");
INSERT INTO kms_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot ni wute Tair kin di Saidon kin umbo ker nuany. Pugri bu ni quan buagine rikur King Herot nde rindi. Ni rindi, Blastus wuti iri king ningg baj te yeng nuany kin ni ane wand, di ni ninde opu nase ei ni ghav nindiny ningg riri. Pre muq ni king nde ruso. Pripri wute Tair opu kin di Saidon opu kin ni Herot nde opu mir wong rind riq ye. Pugri bu ni king ningg riri riri, ei ni umbo ker te pre di ni ane ruwo gudo ningg. ");
INSERT INTO kms_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Muq king ni wand simbe nindiny kin nginy te naip no. Nginy te ningg Herot ni king ningg chongo te nare righe pre, ni king ningg sia pe nas, di ni wute wand simbe nindiny. ");
INSERT INTO kms_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Muq wute Herot puamb ruang ningg riri, “Wuti nen nari kin te god gibe pugri, wuti gibe segi!” ");
INSERT INTO kms_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pugri puq rind ei Herot yawo nare righe ei ni oghi puq nindiny ningg. Muq Herot ni nikin nyambne nindivi viyo. Ni nari di wute God nyamb rindivi viyo segi. Di brequne Yumbui ningg angelo Herot ni meneri no nase, kuambki mandi me me di nati. ");
INSERT INTO kms_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","God ningg wand vir ir wute nganye buagi rutungu di God nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas Sol temi wet bidi mare mandi kin te God ningg wute mingg quayi kiyi mem pre di Jerusalem si miraq mune mo. Ni mo di Jon Mak mitanyi ne mo. ");
INSERT INTO kms_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Wute Jisas nei mimbig kin Antiok mas ye ninge propet di ninge God ningg wand wute bei meny kin te mas. Wute te ni nyamb taq: Barnabas, di Simeon ni nyamb ire Niger, di Lusius Sairini kin, di Manain, ni gavman yumbui Herot ningg kimand, di Sol. ");
INSERT INTO kms_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wute men mir uny yemu God yumbui nyamb mirang mirang, di Ququ Yuwon Ye ni simbe nindim nari, “Nungoqi Barnabas Sol temi ei si wumbom di tiqi wundom mo yembe te nge ni kap mo di simbe gidim pre kin te yembe mand.” ");
INSERT INTO kms_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pugri bu ni mir unyne God ane wand mand mand pre, di ni temi nde si mem kuyo, di tiqi mundom mo. ");
INSERT INTO kms_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ququ Yuwon Ye ni temi tiqi nundom mo, di temi Selusia maghe mo. Selusia pu bot ire mitaqwi Saiprus ailan mo. ");
INSERT INTO kms_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ni mo ailan te kin tiqe ire Salamis puq munduw kin tende mo mar, di ni God yumbui nyamb mirang kin baj pe Juda mirur, God ningg wand simbe mindiny. Jon Mak ni temi ane yemu pu ei ni ghav nindim kin. ");
INSERT INTO kms_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ni tiqe buagi Saiprus ailan pe yeru kin te omone mawo mandi mandi Papos mi meyi. Papos pe ni wuti iri muqoind, wuti te ni awo namb di mu nand kin. Ni Juda iri ni propet wandoqi ye pudi ni nari ni God ningg propet iri. Ni nyamb Barjisas. ");
INSERT INTO kms_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","8","Barjisas ni nyamb aye Elimas. Ni pripri awo namb di mu nand ye te ningg bu Grik wand pe Elimas puq mindig. Ni wuti iri gavman yumbui ni nyamb Sergius Paulus ni ane mas ni ghav nindig ye. Sergius Paulus ni nei yuwon ye namb ye, ni God ningg wand nutungu yawo gureg, bu ni Barnabas Sol temi wand nuam ei mandi ningg. Sergius Paulus ni Barnabas Sol temi mingg wand nutungu, tedi Elimas ningg wand nutungu segi. Elimas te kin ningg yambu nari, bu ni pripri ni temi nyamb nem vighe viso, ni nari ni temi wandoqi mand. Ni gavman yumbui te nei brequ neng, ei ni God nei nimbig kin nei te si nare ningg. ");
INSERT INTO kms_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pudi Sol, ni nyamb aye Pol puq mindig kin, ni Ququ Yuwon Ye ningg gre ninde yumbui nganye vise. Ni Elimas otinde gri nuqoind nuqoind pre muq nari, ");
INSERT INTO kms_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nu Satan ningg wo! Nu wute yumbo ur tuquine kin te yambu kuari! Nu pripri wute wandoqi gudiny! Nu yumbo ur wandoqi kin di yumbo ur brequ nunde bre pu rise! Nu pripri Yumbui ningg yumbo ur nganye kin te kuare kuitinde di wandoqi kin puq guad! Nu yumbo ur ren si kuare yambu bri kuari? ");
INSERT INTO kms_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Muq nu tungu! Muq Yumbui nikin si pe nu ni, di nu rar wughe, di rar ghat tiq segi. Di nginy qoind tiq segi, pugri pune ghas ghas bur quan.” Pol puq nand pune di brequne nganye yumbo wuye quari kin pugri quan nganye burpoq rip di Elimas rar imb ruang. Di ni tuqui nondo nandi nondo wute meri nat, iri nuqoind ei ni si niting kuse ei ngim bei nindig. ");
INSERT INTO kms_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gavman yumbui ni yumbo ur ren nuqond, di Yumbui ningg wand ni bei meny ye te ningg quan nganye nei kumo namb, di ni Yumbui nei nimbig. ");
INSERT INTO kms_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol di wute ni ane mo kin te Papos pu di bot wutemi wure wuso Perga Pampilia opu wi mati. Jon Mak ni te pu si nare di munene Jerusalem no. ");
INSERT INTO kms_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ni Perga si miraq, di nyinge mare mo Antiok ire Pisidia opu yequ kin tende mo mar. Di Sabat nginy mas yawo tuan kin tende ni God yumbui nyamb mirang kin baj pe mar mo mas. ");
INSERT INTO kms_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","God yumbui nyamb mirang kin yumbui ni Moses ningg lo kin wand di propet ningg wand te muqond pre, muq wute ninge simbe mindim mondo Pol nikin yembe ire ane simbe mindim. Ni mari, “Chech, nungoqi wand ninge wute umbo weny kughe ye rise ate simbe wand.” ");
INSERT INTO kms_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Di Pol ni nes newo, si nindingi kuyo, di nari, “Nungoqi wute Israel kin, di nungoqi wute aye kin God yumbui nyamb wurang kin, nungoqi nge wand wutungu. ");
INSERT INTO kms_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel mingg God beghi koku yabene ir nawo pre pu muq mo Isip mas. Ni tende mas pudi wute muq mandi kin pugri wute aye nde si nambune mas. Tende puayi God nari di ni quan nganye mas. Otiwo God nikin gre yumbui pe tende ni nitami Isip si miraq, wonji wute segi pe mo. ");
INSERT INTO kms_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Di qi wute segi ye pe tende God ni ane mas ber 40-pela pu mawo. Wute te ni pripri yumbo ur brequ mand, di ni te ningg yivany nare, pudi ni si nare segi. ");
INSERT INTO kms_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kenan pe ni wute tit 7-pela pu namb riti, di ni mingg qi te Israel nem, di otiwo ni kuqo qi te mitaqwi. ");
INSERT INTO kms_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ni qi tende mas ber 450-pela pugri mawo. Otiwo ni Israel pe yumbui ninge nawo mas, di ni mas masne rindi rindi propet Samuel mune nas. ");
INSERT INTO kms_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Propet Samuel nas kin tende puayi muq ni king iri meti nowi ningg mari, di God ni Sol Kis ningg wo nem. Ni wute tit Benjamin kin. Di ni ber 40-pela pu king ningg nas. ");
INSERT INTO kms_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pre di God ni puaq naind, di Devit oyi Israel mingg king ningg nowi nas. Di God Devit ningg ninde pugri simbe nand, ‘Nge wuti iri guqoid pre, ni nyamb Devit, ni Jesi ningg wo. Wuti nen nge yumbo nei gibiny kin tuquine ni nei nimbiny ye bu otiwo di ni yumbo yumbo nge kari kin te puq nen ye.’ ");
INSERT INTO kms_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Di God ni puq nand kin pugrine puq nen. Asi ni nari, otiwo Devit ningg kuqo ei iri yumbui ningg nowi nas di ni beghi Israel nitamu powi kin. Muq ni asi puq nand kin tuquine puq nen pre, ni Jisas tiqi nundog nandi. ");
INSERT INTO kms_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Asi Jisas nandi segine tende puayi Jon ni wute Israel kin wand bir nuany, di ni nei rire ritinde ei ni wuye nap. ");
INSERT INTO kms_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon ni yembe omo nawo ningg tumo di nari, ‘Nungoqi nei wamb kin nge tughe bu? Nge nungoqi wuti ghimbi wuang pu was kin te segi. Nungoqi ange wuaq wutungu! Nge ni segi, pudi ni nge nde dobu nawi ye. Ni nge nde quan nganye yumbui. Nge oghi nganye segi bu nge ninde tumo godo segi, di nge ni su nyinge pe kin ir guag kin tiq segi.’ ");
INSERT INTO kms_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Chech qam, Abraham ningg kuqo di nungoqi wute tit aye kin God yumbui nyamb wurang kin, wand ven God nari ni beghi mune nitamu powi puq nand ye te yabe nengu pre. ");
INSERT INTO kms_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wute Jerusalem mas kin nikin wute nyamb kin ane Jisas beghi nitamu powi ningg nandi kin te nei mamb segi. Di ni propet mingg wand Sabat kin nginy manyi muqond di simbe mand kin te oghine nganye nei mimbiny segi. Pudi ni oyi Jisas ningg mo nikin yumbui nde wandoqi wand simbe mand, di ni mi nati ningg wand taq mamb. Ni puq men kin te nganyene asi propet te simbe mand kin wand te ane tuquine muq puq men. ");
INSERT INTO kms_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ni musoq ju unje nap muqoind muq mi nati ningg mari segi, ni segi nganye bu Pailat ningg mari mari ei ni nati ningg. ");
INSERT INTO kms_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ni yumbo yumbo buagi asi propet Jisas ningg wand ur mand kin tuquine nganye mune puq meng pre muq otiwo ni kruse pe pu meti nati, di ngamo ire wung mowi yenu. ");
INSERT INTO kms_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pudi God ni ngamo pe pu mune nindingi newo. ");
INSERT INTO kms_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Di wute asi Jisas ni ane Galili pu Jerusalem mo kin te ni pripri Jisas ninde bre newo muqoind. Muq wute men ni ningg wand beghi wute Juda kin nde bir mawo ye. ");
INSERT INTO kms_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Di beghi muq Yumbui ningg wand yuwon ye ven nungoqi nde bir kawo ningg badi: Yumbo ren asi God beghi koku nem puq nand kin ");
INSERT INTO kms_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","taq te muq beghi ni kuqo oyi nengu pre. Ni Jisas mune nindingi newo kin te Buk Song pe God ningg wand puch yuwo namba tu pe rise kin ane tiqne. Ni nari, ‘Nu nge wo. Muq nge nu nuyi ningg kas.’ ");
INSERT INTO kms_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ni ngamo pe pu nindingi newo pre pu bu muq munene ngamo pe no sigh namb kin tiq segi. Te taq God ni nari, ‘Muqdi nge nungoqi yumbo yuwon kin buagi asi Devit geg puq gad kin te keuq, di ni ningg wand nungoqi wutungu kin tiq nganye.’ ");
INSERT INTO kms_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pugri pu bu yuwo aye pe Devit puq nand nari, ‘Nu nunon wuti yuwon ye ngamo pe si kueri nase sigh namb segi ye.’ ");
INSERT INTO kms_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Beghi nei bab Devit wute ane ris, di ni pripri God ningg nei pene yembe nand. Pre otiwo ni nati, di ni nikin kuqo kin pugrine ngamo mowi di sigh namb. ");
INSERT INTO kms_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pudi wuti te God nindingi newo kin te sigh namb segi. ");
INSERT INTO kms_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pugri pu bu chech nge kari nungoqi beghi wand simbe buduq kin ven ei oghine nei wumbiny. Beghi nungoqi wand simbe buduq kin taq pugri: Jisas nungoqi wand puaq nunduq kin tuqui. ");
INSERT INTO kms_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses ningg lo nungoqi wand puaq wunduq di tuquine nganye was tiq segi. Pudi wuti nen wute buagi ni nei rimbig kin ni wand puaq nindiny di tuquine nganye ris ye. ");
INSERT INTO kms_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pugri bu nungoqi yeng wawo yuwon eti propet ni wand ren puq mand kin ren nungoqi nde puq ren. Ni pugri puq mand mari, ");
INSERT INTO kms_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nungoqi wutaqu God perei wundig ye nungoqi wutungu. Otiwo di nungoqi nei kumo wamb di wati! Te pugri nungoqi was kin tende puayi di nge yumbo ninge yembe gidiny, pudi nungoqi nei wumbiny tiq segi. Piyi wuti iri te kin ningg simbe nunduq, pudi nungoqi nei wumbiny tiq segi’.” ");
INSERT INTO kms_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol ni wand te kin simbe nindim pre, di ni Barnabas temi nyinge mare mar mo, di wute riri, “Wik ire te wung Sabat kin nginy tende nungoqi tequ wand ven ne ei beghi munene simbe wundug.” ");
INSERT INTO kms_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ni God yumbui nyamb mirang kin baj si miraq, tiqe mar mo pre, di Juda ninge di wute aye kin ninge Juda kin pugri mas yawo kurem di mes, Pol Barnabas temi ane mo. Di ni otinde simbe mindim ei God nikin nde nei pene yuwon nuam ye te ningg ni nei God ndene mi viso di gre pu yemu. ");
INSERT INTO kms_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nginy Sabat kin aye iri te ningg wute tiqe te kin nganye buagi nganye rindi rikur, di Pol ni Yumbui ningg wand bir nawo ye te rutungu ningg. ");
INSERT INTO kms_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pudi wute buagi Pol ningg wand rutungu, di Juda mingg yumbui ni te muqond, di ni umbo brequ kuse. Di ni Pol wand sange mindig di perei mindig. ");
INSERT INTO kms_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Di Pol Barnabas temi ni gre grene simbe mindim mari, “Te nganye, beghi temu God ningg wand nungoqi ei simbe buduq pre, muqdi aye mune simbe bidim. Pudi nungoqi wand ven dob weny. Te nungoqi nonne bu wari, ‘Beghi God nde si nambu pas pas te kin pas kin wutamu yuwon nganye segi.’ Pugri bu muq nungoqi ange wuaq wutungu. Muq beghi temu nungoqi si piraqu, di wute Juda segi kin pe po. ");
INSERT INTO kms_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Te pugri Yumbui beghi pugri simbe nundug: ‘Nge nu wute aye Juda segi kin nde sinde kin pugri kowi yengu, di nu ei tiqe manyi qi ven nde yeru kin te ngim bei ndiny, di God mune nateri ye’.” ");
INSERT INTO kms_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wute buagi Juda segi kin te ni wand ven rutungu, di ni umbo yuwon nganye gud. Ni Yumbui ningg wand ningg chumbuai rind. Di wute ninge God ninde si nambu ris ris te kin ris ningg ir nawo pre kin te ni wand ven rutungu di nganye puq rind. ");
INSERT INTO kms_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Di tiqe buagi tende opu yeru kin te Yumbui ningg wand vir ir omo. ");
INSERT INTO kms_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pudi Juda ni yemu nyumbueg nyamb kin God yumbui nyamb rirang ye te di quayi tiqe te kin yumbui te nei brequ meny, di wute tiqe te kin Pol Barnabas temi unje rip mai isis rem, umbo ker ruam, di res riwo bub rire aye pe opu mo. ");
INSERT INTO kms_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pugri bu ni temi qi nyinge pe kin tende buraq mand ri, yumbo ur te kin te pugri ni yumbo ur brequ tende yerune. Di ni temi Aikoniam mo. ");
INSERT INTO kms_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Di Jisas ningg wute Antiok kin chumbuai nganye rind, di Ququ Yuwon Ye ninde nas. ");
INSERT INTO kms_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aikoniam pe ni temi mune pugrine puq men. Ni Juda God yumbui nyamb mirang kin baj pe mar mo, wand bir mawo. Ni wand bir mawo, Juda di Grik kin nganye buagi rutungu rutungu ruso ruso yuwon rind, muq ni God nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pudi Juda ninge Jisas nei rimbig segi ye ni wute ninge Juda segi kin nei reny, di Juda segi kin ni Jisas ningg wute umbo ker ruany. ");
INSERT INTO kms_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pugri bu ni Aikoniam mas nginy quan nganye mawo. Ni Yumbui ningg wand raqene bir mawo ni wune mamb segi, di Yumbui ni ghav nindim ni gre nem, di ni temi yumbo ur gre ye isis mand. Wute buagi ni temi yumbo ur gre ye isis mand kin te ruqond, di ni temi Yumbui nikin nde nei pene wute yuwon nuany kin wand simbe mand kin te ni riri te nganyene. ");
INSERT INTO kms_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pudi wute tiqe te kin ni bir ruwo, ninge Juda ane opu rise Jisas nei rimbig segi, di ninge Jisas ningg aposel ninde opu rise Jisas nei rimbig. ");
INSERT INTO kms_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dobu pu muq wute Juda segi kin di Juda kin di Juda mingg wute nyamb kin ni mes mewo, ei Pol Barnabas temi brequ mindim di wet nyaw pe mi mati ningg mari. ");
INSERT INTO kms_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pol Barnabas temi te mutungu, mes mewo wu mase mo tiqe teri Likonia opu yeru kin, ni nyamb Listra di aye te ni nyamb Derbe, di tiqe woju tende opu yeru kin tende mo. ");
INSERT INTO kms_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Muq temi tiqe tende Jisas ningg wand yuwon ye bir mawo. ");
INSERT INTO kms_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra opu tende wuti iri nyinge gre vind segi ye ni tende nas. Ni musoq ju nyinge nare no segi. Yabene ni kumo nde umbo pene nase, ni nyinge pugrine vise kumo wuri wundi. ");
INSERT INTO kms_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ni Pol ni God ningg wand te bir nawo kin te nutungu nutungu nas. Pol rar neq wundo ni nuqoind di ni nuqond ni God nei nimbig ye te ningg di ni nyinge oghi kin tuqui. ");
INSERT INTO kms_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Di ni quan kumone pugri nari, “Nu yes yewo, teti pu yeru.” Muq wuti te brequne nes newo, di opu nyinge nare. ");
INSERT INTO kms_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wute buagi ruqond Pol ni yembe gre ye nand, bu wute buagi anene ni Likonia mingg wand tuan pe pugri riri, “God ninge tinde mo wute mase, muq beghi nde mati mi.” Ni nikin wandoqi kin god te ningg puq rind. ");
INSERT INTO kms_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Muq ni Barnabas Sus puq rindig. Di Pol ni wand simbe nand kin bu ni Hermes puq rindig. ");
INSERT INTO kms_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nikin wandoqi kin god Sus ni ningg yumboyi baj te tiqe vang tumone wuse. Wandoqi kin god Sus te ni ningg prist te ni kau nitami nandi, di ambomawi ninge nare tiqe vang ngimrawu nandi, muq ni wute te ane Pol Barnabas temi god kin pugri mir ruam di yumbui nyamb riram ningg. ");
INSERT INTO kms_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pudi aposel Barnabas Pol temi wand te mutungu ni pugri puq ren ningg, di ni umbo brequ kuse di ni nikin chongo te bir mawo, vig mamb mo wute buagi yeru pe mingine yemu, muq pugri mari, ");
INSERT INTO kms_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nungoqi wutaqu, nungoqi pughe kin ningg beghi mir wangu? Beghi temu nungoqi kin pugri, beghi wutamu ne. Beghi temu wand yuwon ye bir pawo ei nungoqi wandoqi kin yumbo ur ren si ware, ei God iri nas nas te kin nas ye tene nei wumbig. Ni nginy tu di gherim di qi di yumbo yumbo buagi tende rise kin nine yembe nindiny. ");
INSERT INTO kms_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Asi God ni wute buagi rar nuqond nikin nei pe ris. ");
INSERT INTO kms_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pudi ni suqo nganye no segi. Ni raqe no ningg bu ni yumbo ur yuwon ye nand. Ni wuye neuq di wam pu wundi, di ni nungoqi mir wi righe ni sabi nindiny mir te ruwi. Ni nungoqi mir te neuq, di nungoqi yawo ware righe.” ");
INSERT INTO kms_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ni temi wand ren kin pe wute mir ruam kin te ni segi puq mindiny, pudi ni buid rip. Muq ni temi segi puq nganye mand, di ni mir ruam segi. ");
INSERT INTO kms_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Muq Juda ninge Aikoniam di Antiok opu pu mandi di ni wute te nei brequ ye meny, bu ni Pol wet nyaw pe mi. Muq ni tiqe vang pe pu qo maimb meri raqe mar mo. Ni riri Pol nati pre bri. ");
INSERT INTO kms_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Dobu pu muq Jisas ningg wute rindi ninde rikur, muq Pol mune nes newo tiqe mune nar no. Yambgriq muq Barnabas temi Derbe mo. ");
INSERT INTO kms_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol Barnabas temi Derbe opu wand yuwon ye bir mawo di wute nganye buagi Jisas ningg wute ningg ris. Pre muq mune mandi Listra, Aikoniam di Antiok. ");
INSERT INTO kms_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ni temi Jisas ningg wute umbo meny kughe ei ni God nei rimbig kin nei te si rire segi ningg ni quan kumone pugri simbe mindiny mari, “Nungoqi God nei wumbig gre. Beghi par po God nde si nambu pas ningg pari, tedi muq beghi mai quan nganye pare kin ngim tende nyinge pare, tedi beghi God nde si nambu pas kin tuqui.” ");
INSERT INTO kms_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Muq ni temi mir uny mas di God ane wand mand ei Jisas nei rimbig kin wute tit manyi kin quayi kiyi map mo. Quayi kiyi men Yumbui nde nei mundub ye, muq Barnabas Pol temi ni Yumbui nde si pe mi mondo. ");
INSERT INTO kms_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ni temi Pisidia opu mar ir pre, muq Pampilia opu mune mandi. ");
INSERT INTO kms_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ni mo Perga pe God ningg wand bir mawo, pre di maghe mo Atalia. ");
INSERT INTO kms_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia pu bot ire mitaqwi Antiok mo. Tiqe tende asi wute God ane wand rind, ei Barnabas Pol temi God nde si pe ri mondo ei God ni temi yuwon nuam ei ni God ningg yembe mand kin tuqui. Muq ni temi yembe te pre mand pre muq Antiok mune mandi. ");
INSERT INTO kms_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ni mandi Antiok mitari righe di ni wute Jisas nei rimbig kin irepe mirur, muq ni temi God ni yumbo yumbo ninde yembe nindiny kin te simbe mindiny. Ni mari, “God ni wute tit Juda segi kin nei neny bu muq ni God irine nei rimbig.” ");
INSERT INTO kms_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Di ni temi nginy quan pugri Jisas ningg wute ane ris. ");
INSERT INTO kms_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Juda kin wute ninge Judia pu mati mi Antiok, di Jisas ningg wute wand bei meny meny yemu. Ni mari, “Nungoqi lo Moses beghi nengu kin te nei wumbiny segi di lo te wuri kin pugrine ghimbi dugu chongo pend muauq segi, tedi nungoqi God mune nitaqu wowi segi.” ");
INSERT INTO kms_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ni puq mand ye te ningg di Pol Barnabas temi ni ane wand pe mege. Pre muq wute Jisas nei rimbig ye Pol Barnabas temi di Jisas nei mimbig kin wute aye ninge ane ir ruwo ei ni Jerusalem mo ei wand ren kin ningg aposel di wute Jerusalem kin Jisas nei rimbig kin ni mingg quayi kiyi ane wand mand ningg. ");
INSERT INTO kms_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wute buagi Jisas nei rimbig kin ni tiqi rindom mo. Ni mo kin te ni Ponisia di Samaria opu te gri mo. Ni wute te opu kin te God ni wute aye Juda segi kin umbo nare nitindam kin te kin wand simbe mand mand mo. Jisas ningg wute wand ven rutungu di ni quan nganye chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ni mo Jerusalem mo mar di aposel di wute buagi Jisas nei rimbig kin te di nikin quayi kiyi ane ni chumbuai rindim. Muq Pol Barnabas temi yumbo buagi God ni temi nde gri puq nen kin te simbe mindiny. ");
INSERT INTO kms_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Parisi, prist tit ire, ni ningg wute ninge Jisas nei mimbig kin ni mes mewo di mari, “Nungoqi wute aye beghi ane Juda kin segi ye te ghimbi dugu chongo ei pend wuam, di simbe wundim ni Moses ningg lo ei nei mimbiny.” ");
INSERT INTO kms_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Muq aposel di wute Jisas nei rimbig kin quayi kiyi ane mikur, te kin ningg wand mand. ");
INSERT INTO kms_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ni wand quan kumo mand pre, muq Pita ni nes newo di ni simbe nindim nari, “Chech, nungoqi nei wamb, asi God beghi yembe ire ire nengu. Ni nge naip ko ei wute aye Juda segi kin ni nge nde mim pe Jisas ningg wand yuwon ye rutungu di Yumbui nei rimbig ye. ");
INSERT INTO kms_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God ni wute buagi umbo nundony ye, ni wute aye Juda segi kin Ququ Yuwon Ye beghi nengu kin pugrine ni mune neny. Pugri puq nen kin te ni beghi bei nundug, ni wute aye Juda segi kin anene nate ruwi ye. ");
INSERT INTO kms_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ni beghi yumbo ur aye kin bei nundug di ni yumbo ur aye kin bei nindiny segi. Wute ni nei rimbig kin te ninggne ni wand puaq nindiny. ");
INSERT INTO kms_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Nungoqi wari wute aye beghi Juda ane yavi ire segi kin te mandi, Moses ningg yumbo ur buagi tene ei mand. Puq wand wawo yeru. God puq nand segi. Nungoqi pughe ningg God ningg wand ware witinde? Pugri puq wen kin te nungoqi God tuqui waip ningg bu Jisas ningg wute mai ren kin weny. Asi beghi di beghi koku ane mai ren kin pare tuqui segi. ");
INSERT INTO kms_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Te segi! Pudi beghi pugri nei bab: Beghi Yumbui Jisas nikin nde nei pene beghi yuwon nuangu ye te ningg di God beghi nitamu powi, te kin pugrine ni mune nate ruwi.” ");
INSERT INTO kms_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita pugri puq nand, di wute buagi mune wand segi mas di Barnabas Pol temi wand mand ye te ningg ange muaq. Di God wute Juda segi kin nde mingi ni temi nde si pe yumbo ur gre ye isis nand kin wand simbe mindim. ");
INSERT INTO kms_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ni temi wand mand pre, muq Jems ni nari, “Chech, nungoqi ange wawo nge wand ven wutungu. ");
INSERT INTO kms_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon ni God asi urupui wute Juda segi kin yawo nitony di ninge ir nawo nikin wute ningg ris kin wand te simbe nundug pre. ");
INSERT INTO kms_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Propet mingg wand mune ven kin pugrine. Ni pugri ur mand mari: ");
INSERT INTO kms_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Yumbui nari, ‘Otiwo di nge mune gadi, muq nungoqi Devit ningg baj viso vighe pre kin pugri, nge munene gidivi viyo ye. Yumbo yumbo baj ven kin brequ rise pre, di nge aye mune yembe gidiny ye, di mune gidivi viyo. ");
INSERT INTO kms_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Te ei wute ninge risne kin nge meri ritigh kin tuqui. Te wute buagi wute Juda segi kin nge ir kawo pre kin te segine nge meri ritigh.’ Yumbui ni pugri puq nand, di ni wand te kin pugrine puq nen ye. ");
INSERT INTO kms_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Asi nganye ni puq nand kin te yabene nei bab pre. ");
INSERT INTO kms_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Pugri bu nge nei taq pugri: Wute aye Juda segi kin ni nei mare mitinde God nei mimbig, te beghi ni yembe yumbui pem wayequ. ");
INSERT INTO kms_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Beghi ni nyumo raqe ei ur bidim, di simbe bidim ei ni umo wute wandoqi kin god mem ningg mambui kin te me segi kin. Di ni nyumbueg segi griny mindiny kin te ei puaq mand yuwon. Di ni umo wute gibe pori muany riti kin te me segi kin. Di ni yavi me segi kin. ");
INSERT INTO kms_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Te pugri beghi nei bab Moses ningg lo yabe chuqone qa wute ni ningg wand bir mawo kin tiqe manyi ni ningg wand bir mawo mawone rindi rindi muq. Di nginy Sabat kin ni pripri Moses ningg wand God yumbui nyamb mirang kin baj pe muqond.” ");
INSERT INTO kms_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Muq aposel di wute Jisas nei rimbig kin quayi kiyi di wute Jisas nei rimbig kin nikin nde kinne wute aye temi si mumbom ei tiqi mundom Pol Barnabas temi ane Antiok mo ningg. Muq ni wand wand mare di Judas ni nyamb ire Barsabas, di Sailas ni temi si mumbom di tiqi mundom ni temi ane mo. Wute temi men Jisas ningg wute buagi kin yumbui. ");
INSERT INTO kms_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ni temi nde si pe nyumo raqe ire meq wuso. Nyumo raqe pe ni pugri ur mand: “Nungoqi wute Juda segi kin Antiok, Siria, di Silisia opu was kin. Beghi aposel di wute Jisas nei rimbig kin quayi kiyi ane, nungoqi beghi mand. Muq beghi nyumo raqe wen ur bidiq, nungoqi wute aye kin ninge Jisas nei wumbig ye nungoqi nde peq wundo. ");
INSERT INTO kms_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Beghi wute ninge beghi nde kin nungoqi nde mondo wand mand di nungoqi ni wand te ningg puye wand di nei kumo wamb kin te putungu pre. Ni nungoqi nei unje mupuq. Wute men beghi nde wand materi muq mondo segi ye. ");
INSERT INTO kms_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Beghi wand ven putungu, di ire pe pikur, wand wand pare, beghi umbo irene kuse, muq wute temi si bubom, di ni temi tiqi bidom beghi mand Barnabas Pol temi ane nungoqi nde mondo. ");
INSERT INTO kms_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ni temi beghi Yumbui Jisas Kraist ningg nyamb mindivi viyo viyo muq mati kin te kin wune mamb segi. ");
INSERT INTO kms_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pugri bu beghi Judas Sailas temi tiqi bidom mondo, ei ni temi beghi wand nyumo raqe pe rise ye te kin pugrine mim pe mune simbe munduq ei wand te gre meny. ");
INSERT INTO kms_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","God ningg Ququ Yuwon Ye beghi ane pas, muq beghi wand ven kin taq bab pari, beghi nungoqi mai aye aye peuq wayequ, nungoqi yumbo ren ne ei puaq wand yuwon: ");
INSERT INTO kms_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Umo wute wandoqi kin god meng ningg mambui kin te we wayequ. Nungoqi yavi we wayequ. Nungoqi wute umo gibe pori muany riti kin te we wayequ. Nungoqi nyumbueg segi segi griny wundiny kin yumbo ur te ei puaq wand yuwon. Nungoqi yumbo ur buagi ren kin puaq wand yuwon, tedi nungoqi yuwon. Teneqa. Nungoqi yuwonne was.” ");
INSERT INTO kms_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Muq wute Jisas nei rimbig kin te ni wute temi aye temi te tiqi rindom Antiok maghe mo. Ni mo wute tiqe te kin Jisas nei rimbig kin te ngam mirany rindi, di nyumo raqe te meny. ");
INSERT INTO kms_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Di ni wand yuwon ye nyumo raqe pe vise kin te ruqond, ni gre rind di ni chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Sailas temi ni kinne propet ningg mas pu bu ni wand yuwon kin nganye buagi Jisas ningg wute meny, di wand tende ni gre meny. ");
INSERT INTO kms_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ni temi Antiok mas mas bur quan mawo pre, muq Jisas ningg wute Antiok kin ni Yumbui pengu rindig ei ni temi yuwon nuam, pre di tiqi rindom wute ni tiqi rindom mandi kin tendene mune mo. ");
INSERT INTO kms_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pudi Pol Barnabas temi Antiok ne mas. Ni temi tene mas di wute aye ninge ane wute God ningg wand bei meny, di ni Yumbui ningg wand yuwon ye bir muany. ");
INSERT INTO kms_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Otiwo nginy ninge mo pre di Pol Barnabas simbe nindig nari, “Beghi temu muqdi mune po ei Jisas ningg wute buagi tiqe manyi ris kin te beghi asi Yumbui ningg wand bir puany kin te buqod. Te ei beghi nei bab ni yuwon pu ris o segi.” ");
INSERT INTO kms_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ni Jon nyamb aye Mak puq mindig kin ni ei ni temi ane mo ningg nari. ");
INSERT INTO kms_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pudi Pol ni nari, “Wuti nen asi beghi ane po Pampilia pudi ni beghi si niramu di beghi ane yembe bad segi. Pugri bu muq beghi wuti nen pitanyi ane po te yuwon segi.” ");
INSERT INTO kms_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ni temi te ningg quan kumo ker mawo. Pugri puq men, di ni temi mune ire pe yembe mand segi. Barnabas ni Mak nitanyi di ni temi mo, bot ire mitaqwi di ailan Saiprus mo. ");
INSERT INTO kms_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Muq Pol nes newo, Sailas neti nowi ni temi mo, di Jisas ningg wute riri, “Yumbui nungoqi yuwon nuauq nuauqne wo.” ");
INSERT INTO kms_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ni nyinge mare Siria di Silisia opu mo, di wute Jisas nei rimbig kin te gre meny meny mo. ");
INSERT INTO kms_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ni no Derbe di te pu mune no Listra. Tiqe tende Jisas ningg wuti iri tende nas, ni nyamb Timoti. Ni kumo Jisas nei wumbig kin, di ni Juda kin. Pudi ni kiyi Grik kin. ");
INSERT INTO kms_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jisas ningg wute buagi Listra di Aikoniam kin ni Timoti chumbuai rindig ye. Timoti ni wuti yuwon ye. ");
INSERT INTO kms_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol ni nari Timoti ni ane ei mo, pugri bu ni neti nowi, ghimbi dugu chongo pend nuang. Te pugri ni nei namb kin nari, Juda ni yumbo ur ren kin yembe mindiny ye, di Juda buagi tende mas kin ni nei mamb Timoti kiyi ni wuti Grik kin. ");
INSERT INTO kms_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ni nyinge mare, tiqe manyi mo kin ni wand asi aposel di wute Jisas nei mimbig kin quayi kiyi asi Jerusalem pe wand taq mamb ye te kin wand wute Jisas nei rimbig ye ni simbe mindiny. Ni mari, “Nungoqi ren kin ei puq wen.” ");
INSERT INTO kms_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pugri bu wute buagi Jisas nei rimbig kin quan nganye gre rind, di nginy manyi manyi wute nganye buagi aye urupui Jisas nei rimbig di rindi ane rikur. ");
INSERT INTO kms_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ni Esia opu mo wand bir mawo ningg, pudi Ququ Yuwon Ye ni tende wand bir mawo ye segi puq nand. Di ni Prigia opu Galesia opu mingi tende nyinge mare mo. ");
INSERT INTO kms_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ni mo, Misia mingg ngase pe mo, muq Bitinia opu mar mo ningg, pudi Jisas ningg Ququ ni simbe nindim ei tende mar mo segi. ");
INSERT INTO kms_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pugri bu ni Misia opu nyinge mare mandi mandi Misia dob mew di mandi Troas. ");
INSERT INTO kms_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bur ire gug Pol ni rar kinne ri righe ruso ruqo nyemb pe pugri wuti iri Masedonia kin nuqoind, ni pugri simbe nindig nari, “Muqdi nu gherim te bir ghawo ghandi Masedonia, ei beghi ghav ndug.” ");
INSERT INTO kms_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol ni yumbo te ruqo nyemb pe pugri nuqond pre, muq beghi brequne sir pap di Masedonia po kin ngim meri pat. Beghi nei bab, God beghi ningg nari po ei tende wand yuwon ye bir pawo. ");
INSERT INTO kms_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pugri bu beghi Troas pu bot pe pewo po Samotres paghe po. Yambgriq mune te pu bot pitaqwi po Neapolis paghe po. ");
INSERT INTO kms_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Muq beghi tiqe te si piraq, di nyinge pare po Pilipai par po. Yabe chuqo Rom mingg gavman tiqe te yembe munduw, di Masedonia opu puch ire pe tiqe te yumbui. Beghi tende pas, nginy ninge pugri pawo pre, ");
INSERT INTO kms_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","di Sabat kin nginy tende beghi po wuye ambri iri tiqe ye vang dodi pe tumo nase pe tende po. Beghi nei bab kin wute pripri rikur God ane wand kin sunyi tende vise. Di wuye ambri tende beghi buqod, nyumbueg ninge tende rikur pu ris di beghi po ane pas wand bad. ");
INSERT INTO kms_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wute ire ni ane ris di beghi wand rutungu kin ni nyamb Lidia. Ni tiqe Taiataira kin, di ni chongo ambo ye te rang wumb, di wute ninge mandi wong mand ye. Te ni kun wet bidi yembe. Ni Juda segi pudi ni yabene God yumbui nyamb wurang ye. Muq Yumbui ni nei bir nuaw, di Pol wand nand kin te wutungu yawo kurew. ");
INSERT INTO kms_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Muq ni di wute ni ane baj ire pe ris ye ane wuye pap. Ni wuye pipiq pre muq ni beghi simbe wundug wuri, “Muq nungoqi nei wamb kin nge Yumbui nei gibig ye, tedi nungoqi wandi nge nde baj pe was.” Ni quan nganye buid wup bu beghi bodo ninde pas. ");
INSERT INTO kms_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nginy iri ningg beghi God ane wand kin sunyi pe tende po, muq nyumbueg wute aye nde taq pu yequ yembe wund kin ire beghi wundomu. Nyumbueg ambonye te ququ brequ ninde yenu, di otiwo yumbo pughe kin puq ren ye te ningg simbe wund ye. Nyumbueg ambonye te ni ququ te pengu wundig, di ni otiwo kin yumbo te simbe nunduw, di ni wute wand te simbe wundim, di ni oyi wet bidi mew. Muq ni wet bidi wuteri nikin yumbui te wem. Pugri bu nyumbueg te nikin yumbui ni pripri wet bidi quan nganye materi. ");
INSERT INTO kms_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Muq nyumbueg ambonye te beghi nde dobu wuwi, di ni priprine pugri quan kumone wuri, “Wute men God wam nas kin ni ningg yembe mand ye. Ni otiwo nungoqi God mune nitaqu wowi ye wand simbe mand ye.” ");
INSERT INTO kms_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nginy quan nyumbueg te pugri wuri wuri, muq Pol ni nutungu nutungu si yavi nati, di ni tindi nondo ququ brequ te simbe nindig nari, “Nge Jisas Kraist nde nyamb pe kari, nu nyumbueg te si raq di yo.” Muq brequne ququ brequ te nyumbueg te si niraq, wu nase no. ");
INSERT INTO kms_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Muq nyumbueg ambonye te nikin yumbui te muqond ququ brequ te ni si niraq no pre. Pugri bu ni nei mamb nyumbueg te mune wand suqo pu vise kin te simbe wund tuqui segi, di ni wet bidi mune materi tuqui segi. Pugri bu ni Pol Sailas temi mat mase, mitami mo, maket pe rar ngimi muq wute nyamb kin te mem. ");
INSERT INTO kms_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Di ni temi wute kot mutungu kin pe mitami mo di pugri wandoqi mindim mari, “Wute temi men Juda kin. Ni beghi tiqe wen kin wute mai meny. ");
INSERT INTO kms_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Beghi Rom opu beghi yumbo ur te dob peny kin te ni temi wand te kin bir mawo.” ");
INSERT INTO kms_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Wute ni mune pugrine puq rind, bu wute kot mutungu kin mari di ni chongo bure mindim, kande pe mi. ");
INSERT INTO kms_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ni kande pe mi pre, muq ni taq mamb. Muq ni wuti iri kalabus baj pe yeng nawo kin simbe mindig, ei ni yeng nuam yuwon. ");
INSERT INTO kms_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wuti yeng nawo kin ni wand te nutungu, di ni temi nate mowi, rum ire te wur wuso nganye yequ kin tende ni mar mo, muq ni palang puayi pe bi nand mo, nyinge taq nimbim. ");
INSERT INTO kms_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Burpoq mingi Pol Sailas temi God ane wand mand di yuwo mindig mindig, di wute ninge taq pune yemu kin te ni mas mutungu mutungu. ");
INSERT INTO kms_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Muq brequne wariqo yumbui naghe di opu kalabus baj pe yuwod buagi te tit rip, di opu dodi buagi te kinne bi omo, muq wute taq pu yemu kin buagi sen si pe taq mimbim kin te kinne bure. ");
INSERT INTO kms_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Wuti kalabus baj pe yeng nawo kin ni ruqo nase pu nes newo nuqond ngimrawu buagi te kinne bi omo, di ni nei nimbiq nari wute taq kin wu mase mo pre bri. Pugri nei nimbiq di si nawo righe nikin mame dobui neti nowi nikin ghimbi baq nindiny ei nati ningg pune ");
INSERT INTO kms_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol brequne quan kumone nari, “Nu nu nonne ghimbi unje ghap ghawo yeru. Beghi wu pase po segi. Beghi quan buagine ven yembu!” ");
INSERT INTO kms_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Muq wuti kalabus baj yeng nawo kin ni soi ningg nari di soi miraq mandi. Ni wune namb ngape buyaq rindig omo, di vig namb Pol Sailas temi yemu pene neyi ni muange gure nawo. ");
INSERT INTO kms_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pre muq nitami raqe nar no, muq ni nari, “Nu tequ nge yumbui. Nge pughe sin ken ei God nge mune neti kowi?” ");
INSERT INTO kms_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Muq ni pugri simbe mindig mari, “Nu beghi Yumbui Jisas irine nei mbig, tedi God nu di wute nu ane baj ire pe was kin buagi ane nitaqu wowi, di nungoqi ni te.” ");
INSERT INTO kms_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Muq ni Pol Sailas temi nitami ninde baj pe mo, muq Pol Sailas temi Yumbui ningg wand te ni di wute nikin ane baj ire pe ris kin pe simbe mand. ");
INSERT INTO kms_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bur te gug ni kande pe yas muam kin waserar te wuye nipim, pre muq ni di nikin baj ire ane wuye map. ");
INSERT INTO kms_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Di ni Pol Sailas temi nitami baj pe nar no, di ni mir nem. Muq ni di nikin baj ire ane God nei rimbig di quan nganye chumbuai rind. ");
INSERT INTO kms_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yambgriq muq wute kot mutungu kin nikin polis ninge tiqi mundom mandi, muq wuti kalabus baj pe yeng nawo kin ni simbe mindig mari, “Muqdi nu wute temi te si ghare mo.” ");
INSERT INTO kms_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Muq wuti te nandi, Pol simbe nindig nari, “Wute kot mutungu kin mari, nu Sailas tequ muqdi si pirauq wo. Pugri bu nungoqi tequ taq yequ kin prene. Tequ wo di umbo yuwonne rise was.” ");
INSERT INTO kms_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pudi Pol ni polis te simbe nindim nari, “Beghi wutamu Rom kinne, pudi wute kot mutungu kin ni beghi kot mutungu segine muq rar ngimi kande pe mumbuemu di taq mumbumu. Ni puq men kin te ni Rom mingg lo gure muaq. Pudi muq beghi suqo grine si miramu peyi pi po tuqui segi. Muq ni nikinne mandi di beghi mitamu mar mo.” ");
INSERT INTO kms_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Polis ni mo wute kot mutungu kin simbe mindim mari, “Ni temi Rom kinne.” Pugri bu ni wune mamb. ");
INSERT INTO kms_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Di ni mo mune yawo mutom ye wand te simbe mindim, di sabi mindim pre, muq mitami mar mo di waghine simbe mindim ni ngiq mand ei tiqe te si miraq aye pe mo ningg. ");
INSERT INTO kms_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pudi Pol Sailas temi kalabus baj pe pu meyi mi di Lidia nde baj pe mo. Di ni temi Jisas ningg wute tende ris muqond, di ni umbo meny kughe pre, muq ni aye pe mo. ");
INSERT INTO kms_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ni nyinge mare mo Ampipolis mo mar. Ampipolis pu mune nyinge mare mo Apolonia mo mar. Apolonia pu mune nyinge mare mo Tesalonaika mo mar. Tiqe te wung Juda God yumbui nyamb mirang kin baj ire tende wuse. ");
INSERT INTO kms_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Muq Pol ni pripri puq nen kin pugrine mune puq nen. Wik teri ire pu Sabat ye nginy tende Pol ni God yumbui nyamb mirang kin baj pe Kraist yuqo niraq, nati di mune nes newo ye te ningg wand nand nand di wand God ningg buk pe vise ye te nuqond. Di tende pe ni bei nand Kraist ni nganyene God ni manyi naind pu bu ni yuqo niraq di nati, di mune nes newo. Di nari, “Wuti te Jisas nge ni ningg wand bir kawo ye te, ni Kraist.” ");
INSERT INTO kms_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Muq Juda kin ninge Jisas nei mimbig, bu muq ni Pol Sailas temi nde ire pe mikur. Di wute Grik kin God