﻿USE sofia;
DROP TABLE IF EXISTS sofia.kmo_vpl;
CREATE TABLE kmo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kmo_vpl WRITE;
INSERT INTO kmo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Diita maji eeta Jisas Kraist riina yimowurek eeka tar wayega yechi maji. Jisas Kraist rii Devit riiti neja. Devit rii Ebraham riiti neja. ");
INSERT INTO kmo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham rii Aisak riiti apoko. Aisak rii Jekop riiti apoko. Jekop rii Juda riiti apoko riiti yaka kumwoy yechaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda rii Peres, Sara piiriiti apoko. Piiriiti awi siiti hi Tema. Peres rii Hesron riiti apoko. Hesron rii Ram riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram rii Aminadap riiti apoko. Aminadap rii Nason riiti apoko. Nason rii Salmon riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon rii Boas riiti apoko. Riiti awi Rehap. Boas rii Obet riiti apoko. Riiti awi Rut. Obet rii Jesi riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi rii aka tabo yima Devit riiti apoko. Devit rii Solomon riiti apoko. Riiti awi sii Yuraia riiti mima. ");
INSERT INTO kmo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon rii Riaboam riiti apoko. Riaboam rii Abaisa riiti apoko. Abaisa rii Esa riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa rii Jihosapat riiti apoko. Jihosapat rii Joram riiti apoko. Joram rii Asaia riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia rii Jotam riiti apoko. Jotam rii Ehas riiti apoko. Ehas rii Hesekaia riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia rii Manasa riiti apoko. Manasa rii Emos riiti apoko. Emos rii Josaia riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia rii Jekonaia riiti apoko yaka kumwoyeka eecha tar. Diita nediik Isrel ma yenya pokojichi Bebilon akamak ye ir. ");
INSERT INTO kmo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Poko jichi ye irek, Jehonaia rii Sialtiel riiti apoko. Sialtiel rii Serababel riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel rii Abaiat riiti apoko. Abaiat rii Elaiakim riiti apoko. Elaiakim rii Eso riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso rii Sedok riiti apoko. Sedok rii Ekim riiti apoko. Ekim rii Elaiat riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiat rii Eliesa rii apoko. Eliesa rii Matan riiti apoko. Matan rii Jekop riiti apoko. ");
INSERT INTO kmo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop rii Josep riiti apoko. Josep rii Maria siiti ma. Sii Jisas riiti awi. Riina eecha habatar Kraist. ");
INSERT INTO kmo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Warek, na he. Ebraham riina heechi Devit riina heechi eeta ye wayega tar. Devit riina heechi Bebilon akamak ye i poko jir nedii heechi i eeta ye 14 wayega tabatar. Bebilon akama heechi i Kraist riiti nedii eechaba 14 wayega tabatar. ");
INSERT INTO kmo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Dii eeta Jisas Kraist riina yimowur nobo diitata. Riiti awi Maria siina Josep riina heechiken hisiichi heechitar. Worek, rii siin saka yatarek, sii yikapwa biika eecha siir. Holi Spiritek otiirek, sii eena eecha siiri, sii her. ");
INSERT INTO kmo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Worek, siina yaken otiitar ma Josep rii ma kepi wey tarek, rii eena saka siina hibiya majin barek, rii siina eshar veenyechi heechi inyakan hikitar. ");
INSERT INTO kmo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep rii eena hikitarek, Harapa riiti ejel rii heechirek, ya Josep riina eecha wor: “Josep, Devit riiti neja, mii opoche siina yuyeechi heechitanakech. Sii kata tawa yikapwa Holi Spiritek siina har. ");
INSERT INTO kmo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Komas siita eeta yikapwa riina yimowunak riiti hi napa eecha haba, Jisas. Rii riiti ma mima yechi kapasek boboy bachi poyechi yesokwa hehar yicha tawa yikapwa. Eena riiti hi Jisas habato.” ");
INSERT INTO kmo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Diita boboy sii sokwa tari, Harapa riita riiti piirapet riiti kujak mashi ya siiken sawor: ");
INSERT INTO kmo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Omunyego mima pochi sii hoyey yikapwan biika siichi yimowukiita. Yimowunak, riina eecha habakiita, Emanyuel.” (Diita maji eecha wocho, “God rii notaka eecha tawa.”) ");
INSERT INTO kmo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Worek, Josep rii sokwa Harapa riiti ejel rii riina otiken eecha bar majin rii eena sumowur. Rii eena sumowurek, rii mima siina yar. ");
INSERT INTO kmo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Siina yarek, rii siitaka eecha bana bana takasakech. Eecha ta iri, i Jisas riina yimowur. Yimowurek, Josep rii riina hi eecha habar, Jisas. ");
INSERT INTO kmo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herot rii aka tabo yima tarek, Maria sii i Jisas riina Judia nosap Bethlehem akamak eeka yimowur. Worek, winymayn hechar ma ye ya sokwa nobok eeka tar. Eeta ma yecha Jerusalem akamak eeka yar. ");
INSERT INTO kmo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yarek, ye woher, “Akar yimowuwa yikapwa Ju ma yechi aka tabo yima rii siitak tawa? Nota riiti winyumayn ya sokwa nobok herek, no eena ya riiti hin yesokwaken yato.” ");
INSERT INTO kmo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Worek, aka tabo yima Herot rii eena meejirek, rii Jerusalem ma yechaka kaw inyaka nubu nubu tar. ");
INSERT INTO kmo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Worek, rii uwarek, opelen otiitar harapa ma ye, lo majin pokii tar ma ye ya yopo wuchi yicharek, Herot rii yenya woher, “Kraist riin kapo siita akamak yimowukiita?” ");
INSERT INTO kmo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ye awasen eecha wor: “Judia nosap Bethlehem akamak eeka yimowukiita. God riita worek, piirapet rii mashi keyir maji eecha wocho: ");
INSERT INTO kmo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judia nosap Bethlehem akama ma mii aka tabo yiman otiitawey, mii eeta karakadakasakech. Kwoti nediik siitii kowu tawa ma por sokwanak, eeji Isrel ma yenya nobon mukuchikiita. Eena nota eecha wocho, rii Bethlehem akamak eeka yimowukiita.’” ");
INSERT INTO kmo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Worek, Herot rii ya sokwa eemek tar yen kuruk uwa yaya yichi maji bar. Batarek, rii her winyumay sokwa tar nedii. ");
INSERT INTO kmo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Worek, rii yenya Bethlehem akamak wochirek ir. Rii eecha wor: “Na i yikapwan yeshaniga he. Kwotaq henyak, napa ya ana wonyak, ada i riina henyak, ada riiti hi kepi i yesokwabak.” ");
INSERT INTO kmo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Worek, ye heechi nobon icharek, ye her mashi ya sokwa eemek ye her winyumay sii mapo iri yikapwa riita water eemek i bana bana siitii buya tarek, ye her. ");
INSERT INTO kmo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Yecha winyumay siin herek, yechi inyaka kwoya woy hiki tar! ");
INSERT INTO kmo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aka wok i yarechi ye her yikapwa rii awi siitaka eecha tarek, ye yatii bogok piitiichi ye riiti hin yesokwa tar. Worek, ye yechi ye ir kwowun tagwachi boboy kepin riina har. Gol, kwowa ya tawa hikisheboka, kwowa ya tawa ukuka eecha riina har. ");
INSERT INTO kmo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Worek, sukwiyari, God riita yenya eecha wor: “Kwo opoche Herot riitaka kawka ichanakech.” Ye meejichi ye heechi anadii nobok i yechi akamak ir. ");
INSERT INTO kmo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yecha heechi irek, God riiti ejel por yari, Josep riina sukwiya majik bar. Bari, eecha wor: “Herot rii yikapwan ya pi sowakwoken otiito. Na sokwa. Yikapwan, nokwapaka eecha yeechi Isip nosapek na heechi i. Heechi i tanak, komas ada miina kawka wokiita. Herot rii yikapwan hechi ya pi sowakwoken otiito.” ");
INSERT INTO kmo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Worek, Josep rii meejichi sokwa riiti mima yikapwa yeechiniga niyik heechi Isip nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Irek, rii eecha tarek, Herot rii har. Eecha otirek, Harapa riiti majin piirapet por riita keyiri sii eeta siiken sokwar. Eecha wor: “Ada eeji yikapwan uwarek, rii Isip nosapen heechi yar.” ");
INSERT INTO kmo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Winyumayn hechar ma ye yikapwa water eemek Herot riin veenyichi maji saka ya saworek, Herot rii eena hechi ri inyaka kwotayir. Worek, rii wosoworek, ri ow ana pichar ma ye Bethlehem akamak bana bana tar ta yey tar akama ma yechi eyey hoyey yikapwan sukwiya upurus tari sukwiya podat tarin eyey pi sowakwo hamar. Herot rii winyumayn otii hechar ma yenya wowohechari, hiki tarin, eena rii eecha tar yikapwan eecha otii tar. ");
INSERT INTO kmo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Riita eecha otii tari, piirapet Jeremaia riita keyir maji sii eeta siiken sokwar. ");
INSERT INTO kmo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Maji eecha wor: “Ye Rama akamak uwar ayan meejir. Harapa keya yesokwarin meejir. Resel sii siiti yikapwan eena keyatar. Keya tari, ma mima ye siina saboy eshar siikasakech. Boyewak? Yikapwan eyey hama seechir. Hama seechirek, eena keya tar.” ");
INSERT INTO kmo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Komas Herot rii harek, God riiti ejel por rii ya Josep riina Isipek tarek, sukwiya majik wor: Yikapwa riina sowakwo tar ma ye eeta ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hamarek, eena na sokwanak, mima yikapwan yaniga Isrel nosapek awasen heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Worek, Josep rii sokwa mima yikapwan yeechi Isrel nosapek heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Irek, Josep rii meejir Akeleas rii apoko Herot riita otii tar Judia aka tabo yima yon rii eena yar. Eena meejichi akiichi eeta nosapek saka yirek. Sukwiya majik God riita riina eecha worek, eena rii heechi Galili nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ichi akama pochi siiti hi Nasaret eeka yir. Rii otiirek, piirapet yecha mashi keyir maji sii eeta siiken sokwar. Yecha eecha keyir maji eecha wor: “Yecha riina eecha habakiita, rii Nasaret ma.” ");
INSERT INTO kmo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eeta nedii Jon Baptis rii ya God riiti majin Judia me biish tar eemek eeka sawo tasiir. ");
INSERT INTO kmo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Rii eecha wor: “Kwota kapasek boboy otii tawey, inyakak hiki tawa kapasek boboyen na magiirechi! God riiti kigdom diitaq bana bana tawa!” ");
INSERT INTO kmo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Piirapet Aisaia rii batari, rii eeta Jon riiti yon eena batar. Rii eecha wor: “Ma por rii me biish tar eemek eeka uwato. ‘Harapa riiti nobon na sayarechicha. Riiti nobon na nagw nagwa seechi ta!’” ");
INSERT INTO kmo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon riita kamel yechi niibiik tar kapasek rikin ruwuchi putu sapik giirii tar. Rii nowo sagan saka atarek, eena saman atarek, heemi yechi bey ukun atar. ");
INSERT INTO kmo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eeta nedii Jerusalem akamak tar ma ye, Judia nosapek tar ma ye, Jodan pak bana bana tar ma ye eyey heechi riitak yar. ");
INSERT INTO kmo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yecha yarek, ye yechi kapasek boboyen geenyek kwodii worek, Jon rii yenya Jodan pak uku yeechi tar. ");
INSERT INTO kmo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Worek, Jon rii nokwapa nokwapa Peresi ma ye Sadyusi ma ye riitak uku yeechibaken eena yatarek, rii her. Hechi rii yenya eecha wor: “Kwo eeta hopo riiti yikapwa. Nama kwona wochi tawak, kwo God riita kwotay tawa boboyen kwo heechi akii ichu? ");
INSERT INTO kmo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ma yenya na jecha mukuchicha: Kwo kwoti inyaka na dareboyetanak, yo kepin na otii ta. Eena na eecha mukuchicha. ");
INSERT INTO kmo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Opoche eecha hikitanakech ‘Ebraham rii eeta noti wayega.’ li eeta saka kiki siikiitawak. Ada kwona wocho, God rii eeta kiki sowa rii papan yeechi otiiney, iipa Ebraham nejak siikiita! ");
INSERT INTO kmo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Eeta yeeberu sii men muku tawa. Tawak, sii yiiken kowutu. Kata me siik kepi wanan siiney, iipa yiichi hik rabochinyak uwukiita. ");
INSERT INTO kmo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ada kwona ukuk uku yeechi tawak, ii eeta mukuchichu kwo kwoti inyaka dareboyer. Wowak, ma por rii ana komas yanak, rii kwona Holi Spiritek, hika eeka uku yeechikiita. Rii eeta harapa. Ada eeta karakada. Ada ma kepika tanak, eena ada riiti yatii ruwa tawa bobyen kiya ik. ");
INSERT INTO kmo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Riiti keyibochi saniga saniga heechi tawa gishagu sii riitak tawa. Tawak, rii wit otiichi sharega saka tawak, siik akak heechi tawak, sharega ye i hik tukuchichawak, uwutu! Uwutawa hi sii ha hikasakech!” ");
INSERT INTO kmo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Eeta nedii Jisas rii Galili nosapen heechi Jodan pak ir. Irek, rii Jon riitak uku yeechiken yar. ");
INSERT INTO kmo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yarek, Jon rii Jisas riiti inyakan dareboyeken rii eena otii her. Eecha wor: “Eeta kepi miita ana uku yeechikiita. Boyewak ada miina uku yeechikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Worek, Jisas rii awasen eecha wor: “Siikayekiisii. Miita keena ana uku yeechikiita. Diita yikadey nobon otiiney, sicha eyey nobo kepin sumowukiita.” Worek, Jon riita riiti majin sumowur. ");
INSERT INTO kmo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisas riina uku yeechi hamarek, rii pan heechi ameya giiriibak ya sokwar. Ya sokwarek, neer tagwar. Riina tagwachirek, God riiti Spirit sejikiir apo saka tawaga eech ya saka riitak siirek, rii her. ");
INSERT INTO kmo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Worek, neerek uwar aya eecha wor: “Dii rii eeta eeji ada rukusii tawa yikapwa. Riita otii tawa abo ada eena kwoya hecho.” ");
INSERT INTO kmo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Worek, Spirit rii Jisas riina yeechi me biish tar eemek Gaba riita riina woshepii otii otii heken eena ye ir. ");
INSERT INTO kmo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eeka tarek, jisas rii aboboy yadii 40 niyi 40 rii akasakech. Biish tarek, rii eecha har. ");
INSERT INTO kmo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Worek, Gaba rii Jisas riitak yar. Yarek, rii eecha wor: “Miita God riiti yikapwa taney, diita papan na yeechi geyen dareboy.” ");
INSERT INTO kmo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisas rii meejichi awasen eecha wor: “Keyir maji eecha wocho: ‘Ma geyeban eechi takasakech. Ye God riiti eyey kujak saya tawa maji kepin eena sa a ta.’” ");
INSERT INTO kmo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Worek, Gaba rii riina yeechi Jerusalem ye i harapa lotu aka howuk ye yo ye ichi riina eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Miita God riiti yikapwa taney, miita na diika siitiichi muk durii. Keyir maji eecha wocho: ‘God riita riiti ejel yenya maji wochinak, yecha miina hehar otiikiita. Wonyak, yecha miina tapak seechikiita. Seechinak, kepi siikiita. Wonyak, miiti yatii ma papak gworomokasakech.’” ");
INSERT INTO kmo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas rii awasen eecha wor: “Keyir maji eecha babato: ‘Opoche miiti Harapa miiti God, riina otii otii hechanakech.’” ");
INSERT INTO kmo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Worek, Gaba rii Jisas riina yeechi harapa kwowuk ye i ye yo ye ichi eyey diita nosapek tawa kigdomen siiti harapa eyey boboyen riina mukuchi hamar. ");
INSERT INTO kmo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Worek, Gaba rii eecha wor: “Miita ana yatii bogok piitiichi ye eeji hin yesokwa taney, ada miina diita eyey boboyen hakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisas rii awasen eecha wor: “Gaba mii na heechi i! ‘God riiti keyir maji eecha wocho: ‘Eeta Harapa Ma Miiti God, riiti hiban na yesokwa ta. Riiti yoban na otii ta.’” ");
INSERT INTO kmo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Worek, eeta Gaba rii riina heechi saka ir. Irek, ejel ye Jisas riitak ya riina kiyatayer. ");
INSERT INTO kmo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jon riina poko jicharek, Jisas rii meejichi rii heechi Galilinosapek eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Irek, rii Nasaret akamak siikasakech. Rii i Kapaneam akamak eeka siir. Kapaneam Galili pagirebak bana tar. Eeta Sebyulan Naptalai nosapek eeka tar. ");
INSERT INTO kmo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Riita diina otiirek, piirapet Aisaia riiti maji sii eeta siiken sokwar. Rii mashi eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pagiireba yepak, Jodan pa yepak Sebyulan nosap, Naptalai nosap eeka tar. Galili muk shebo shebo tawa ma eeka tawak, ye niyik yiniga ye harapa haba okoreenak hekiita. ");
INSERT INTO kmo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kata ma mima ye niyiki tawak ha tawa eemek tawak, hab a sii eeta yenya okoreechichakiita!” ");
INSERT INTO kmo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eeta nedii Jisas rii diita majin yesokwachi bar. Rii eecha wor: “Kwoti kapasek boboyen na dareboy! God riiti kigdom diika bana bana tawa!” ");
INSERT INTO kmo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas rii Galili pak pagiirebak chishi icharek, rii i yaka kumwoy piiriin her. Saimon, riiti anadii hi, Pita, riiti kumwoy, Endru piiriin her. Piir emiyepen mayak yater yon otiitar. ");
INSERT INTO kmo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Otii tarek, Jisas rii piiriina hechi uwa yayeechi piiriin eecha wor: “Ki na ya adaka eecha ta. Wonyak, ada kinya man ya tawa tobon mukuchik.” ");
INSERT INTO kmo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Worek, piir maya ameya heechi ya riina sumowur. ");
INSERT INTO kmo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Worek, rii way kawka chishitarek, rii way anadii yaka kumwoy piiriin i hebar. Piiriiti hi Jems, Jon. Piir Sebedi riiti yikapwa. Piir yechi jabiir wok tar. Piiriiti apoko Sebedi riitak ye eecha tar. Tarek, ye mayan sayaretar. ");
INSERT INTO kmo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sayaretarek, Jisas rii i piiriina uwa yayar. Uwa yayarek, piir meejichi piiriiti eepi jabiirek ameya heechi piir Jisas riina ya sumowubar. Piiriiti apokon heechi ya sumowuba tar. ");
INSERT INTO kmo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas rii eyey galili nosap i ye yatar. I ye yatarek, yechi nokwapa nokwapa lotu akak i yar maji pokii tar. Kigdom siiti hadabas maji kepin rii eena sawo tar. Rii ma mima yechi hak otii tar boboyen yeechi robotarek, ye kepi siitar. ");
INSERT INTO kmo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Riita eecha otiir yo maji sii eyey Siria nosapek i ye yar. I ye yarek, ma mima ye eyey ma ye hak otii ye i tarin yeechichi riitak yayar. Eyey kapasek hak otii tar boboy ma eecha tari, kapasek Spiritek tar ma yen, kuja sugwiyabak saka tar ma yen, yatii tapa ha tar ma yen yeechichi riitak yayar. Yayarek, rii eeta yenya eyey otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eecha otii tarek, nokwapa nokwapa ma mima ye Galili nosapek tari, Dekapolis eeka tari, Jerusalem eeka tari, Jodan pa pagiireba yepak tari, ye heechi ya riitaban sumowu chishitar. ");
INSERT INTO kmo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas rii nokwapa nokwapa ma mima yenya herek, rii kwowuk yo i yir. Yirek, riiti disaipel ye ya riitak ya yopo wuchi yir. ");
INSERT INTO kmo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Worek, riita yenya maji pokii tar. Rii pokiir maji diitata: ");
INSERT INTO kmo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kata ma ye eecha hiki tawey, God riiti Spiriten no biish wey tawey, God riiti kigdom eeta ma yechi! Yechi inyaka eeta kwoya wey hiki takiita! ");
INSERT INTO kmo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Kata ma ye keya tawey, God riita yenya saboyekiita! Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Kata ma ye yechi hin veenyi tawey, God riita yenya mashi wosawor boboyen yepa yakiita! Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Kata ma ye God riiti inyakak tawa boboyeban otii taken hiki tawey, God riipa yenya hehar otii takiikiisiichikiita! Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Kata ma ye anadii man rukusii tawey, God riipa yenya rukusii takiita! Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Kata ma ye inyaka apoma hechawey, yepa God riina hekiita! Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Kata ma ye anadii man otiiniga ye yechaka eecha anapoy anapoy siiken otii tawey, God riita yenya riiti yikapwa haba takiita! Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Kata ma yecha God riiti inyakak otii tawey, yenya kikir poyiwey, God riiti kigdom eeta yechi. Yechi inyaka eeta kwoya wey hiki takiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kwota ana sumowu tawey, anadii ma ye kwona wosiiboy majin banak, kapasek yon kwona otiinak, nokwapa nokwapa woshepii majin ba taney, ii kwoti inyaka sa kwoya wey hiki ta. ");
INSERT INTO kmo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","“Na riiga ta. Kwoti hevenek tawa hadabas boboy eeta harapa. Ma ye kwona eecha otii tawey, yecha mashi tar piirapet eechaba yenya otiitar. ");
INSERT INTO kmo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ana sumowu tawa ma kwota diita nosapek tawa woshiga eecha tawa. Woshi somakwo taweyn heechiney, kwopa shecha otiinak woshi kawka somakwo takiita? Eeta yikadey woshi sii boyen otikasakech? Na kayek eeta rabowak, ma ye yatiik piitiichishitu. ");
INSERT INTO kmo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kwota diita nosapek tawa haba tawaga eecha tawa. Ma ye nokwapa nokwapa akan kwowuk yo otii tari ii veenyekasakech. (Kwowuk tawaakaman ma hechawaga, ye kwoti habe eechaba hecho.) ");
INSERT INTO kmo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma por rii lam hayichi awo bik beenyechi tadii yichikasakech. Yaho. Rii hayichi yichi tawa eemek yichi. Tawak, eeta akak tawa ma ye yaman kiki hecho. ");
INSERT INTO kmo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma ye eecha otiiwey, kwo kwoti haban na anadii man eechaba mukuchi ye inyak, ye sa heba ta. Wonyak ye sa kwoti yo kepin henyak, sa kwoti hevenek tawa Apoko riiti hin sa yesokwaba ta. ");
INSERT INTO kmo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kwo opoche eecha hikitaqnakech ada lo majin piirapet yecha pokiir majin eena ada wosowoyek yar. Ada saka eena yeechi raboken yarek. Yaho. Ada yari, lo maji mun geenyek kwodii woken eena yar. ");
INSERT INTO kmo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Opoche diina abosuchitanakech diitata: Neer nosap sii tanak, eyey sokwak otii tawa boboy sii sa eyey sokwanak, lo mogo saka rabokiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wowak, ma por rii eeta lo mogo pochin wosowoyeney, rii anadii man eechaba pokii taney, riipa hevenek ikarakada wey siikiita. Wowak, ma por rii lo majin hehar sumowu taney, rii anadii man eechaba hehar pokii taney riipa i hevenek harapa ma siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ada kwona wocho: lo majin pokii tawa ma Peresi ma yecha nagwa nagwa nobon otii tawey, kwota eena kiki siinan siiney, kwo iipa God riiti kigdom saka iyarekiitawak. Kwo nagwa nagwa otii tawa abo na harapa otii ta. ");
INSERT INTO kmo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kwo mashi meejir ma yenya eecha wor: ‘Opoche man pi sowakwotanakech. Ma por rii anadii man pi sowakwoney, ma ye riina yeechi ye i anasakiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wowak, ada kwona wocho: ma por rii riiti inyak yaka kumwoyen kwotay taney, riina yeechi ye i anasakiita. Ma por rii riiti yaka kumwoyen kubuchey ma wonyey, riina yeechi ye i kaunsil ma wonyey, ii riipa hi uwu tawa eemek ik otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wowak, mii opel hak ichaney, miita hikiney, miiti yaka kumwoy miina majika taney, ");
INSERT INTO kmo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","miita God riina ha tawa boboyen na cheyek yichi heechi miiti yaka kumwoyen i maji ba dabuchi awasen ya opel boboyen na opoy ha. ");
INSERT INTO kmo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma por rii miinamajika taney, tii miina anasak ye ik otiiney, wonyey, mii na mapo ameya maji ba dabu kepi sii. Opoche ye i anasatanakech. Riipa miina ye i anasak otiinak, riipa miina yeechi ye i jas riiti tapak now hanak, riipa way yeechi polis man yeechi tapak how hanak, yepa way riina yeechi poko jikiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wonyak, ada kwona wocho mii poko ji akak tanak, ya manik tokonak, mii eeka heechi ikiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kwota mashi diita majin meejir. ‘Akar mey miman kwoya hechi anamesherokotanakech.’ ");
INSERT INTO kmo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wowak, ada apa kwona wocho: ma por rii mima pochin kwoya hechi yak gegi yataney, rii eeta mima siin riiti inyaka wok anesmesheroko kapasek boboy otii hamar. ");
INSERT INTO kmo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Miiti mama yepak tawa miy siita miina otiichinyak, miita kapasek boboyeka sakaney, ii na siin korii yeechi rabo! Eeta kepi miiti kapasek miyin mii heechi ikiita. Eeta kapasek miiti eyey maban hi uwu tawa eemek eyey rabochinyak uwukiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Miiti mama yepa tapa siita miina kapasek boboyen otiichinyak, mii sakaney, ii na tiimiichi rabo! Eeta kepi miiti tapa pochin raboney, eeta kapasek miita eyey maba miitin hik rabochiyak uwukiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mashi diita maji sii sokwar: ‘Ma por rii riiti miman sayeri, rii sa siina saye jeyn keyichi ha.’ ");
INSERT INTO kmo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Apa ada kwona wocho: ma por rii riiti miman sayeney, sii nobo anemeshe rokonan siiney, sii anadii man i siiney, rii eeta mima siina otii nobo anemeshe rokoto. Anadii ma rii siina yaney, ii eeta nobo anemeshe rokoto. ");
INSERT INTO kmo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kwo mashi wayega ye batar majin eechaba meejir: ‘Kwo God riiti mi somak saba howu tawa maji na otii ta. Opoche heechitanakech.’ ");
INSERT INTO kmo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Apa ada kwona eecha wocho: Kwo yon otiik wonyey, kwo opoche heven saba howutanakech. Hevenek tawa eem sii eeta God riiti tiikiir. ");
INSERT INTO kmo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kwo opoche nosapen saba howutanakech. Nosap sii eeta God riita yatiin piitii tawa tiikiir. Kwo opoche Jerusalem akaman saba howutanakech. Sii eeta Harapa Aka Tabo Yima God riiti akama. ");
INSERT INTO kmo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kwo opoche kwoti maseken saba howutanakech. Kwopa saka masebiyan saba howutanakech. Kwopa saka masebiyan otiiniga kehapa siinak, apoma siikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kwota na eecha ba, ‘Ayo, yaho.’ Eeta kiki sowa. Kwo kawka wonyey, eeta boboy sii Gaba riita yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kwo mashi diita sokwar majin meejir: ‘Miy pochi horii raboney, ii na awasen riiti miyin horii raboba. Pun reekiiney, ii na awasen riiti pun reekiiba.’ ");
INSERT INTO kmo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Apa ada kwona wocho: ma por rii miina kapasek boboy otiiney, mii opoche riina awasen kapasek otiitanakech. Ma por rii miina mama yepa wagii siiriin pinyey, ii na way heechinak yepa wadii siiriin sa pi ba. ");
INSERT INTO kmo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma por riin miina ye i anaseechi miiti ruwu tawa rikin yaken otiiney, ii na miiti saketeka eecha ha ba. ");
INSERT INTO kmo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma por rii miina hegiya boboyen kiyaniga iken otiiney, ii na kiya ichi kawka na eechaba kiya icha. ");
INSERT INTO kmo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma por rii miita boboyen haken wonyey ii na ha. Ma por rii miina boboyen yeyada yaken wonyey, mii opoche egesiitanakech. ");
INSERT INTO kmo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kwo diita mashi sokwar majin meejir. ‘Kwoti apoman nareboyen na rukusii ta. Kwona ow ana pichawa man ii na magiirechicha! ");
INSERT INTO kmo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wowak, apa ada kwona wocho: kwona ow ana pichawa man na rukusii ta. Kwona kapasek otii tawa ma yenya na God riina maji bachicha. ");
INSERT INTO kmo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kwo eecha otiinak, kwo eeta hevenek tawa Apoko riiti yikapwa siiken sokwakiita. Riita otiichichawak, eeta ya rii ma kepika ma kapasekeka yechi mabak ya buyato. Wayi rii eechaba otiichichawak, kapasek otii tawa ma kepi otii tawa ma yechi eemek eeka vato. ");
INSERT INTO kmo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kwota kwoti nareboyeban rukusiitawey, ii boyewak kwo eecha hikitu God riita nona ya hakiita? Kapasek takis yan ya tawa ma ye eecha otiito, yechi apoman rukusiito. ");
INSERT INTO kmo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kwota kwoti nareboyeban rukusiichi woshi ataney, ii kwo boy harapa boboyen otiito? Yaho. Biish tawa ma ye eecha otiito. ");
INSERT INTO kmo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kwo na hehar kepi ta. Kwoti hevenek tawa Apoko riita tawabaga kwo napa eechaba ta.” ");
INSERT INTO kmo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Miita na ow poy sii ta. Mii opoche boboy kepin ma ye hechanak, otiitanakech. Mii diita yikadey boboyen yechi mi somak otiiney, miiti hevenek tawa Apoko rii miina ya saka hakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Miita boboyen biish shebo shebo tawa man haney, opoche eeta boboyen anadii ma yechi mi somak geenyik otiitanakech. Akar man mukuchibaken otii tawa ma ye lotu akak awa batawa eemek eecha otiitawey, mii opoche eechaba eena otiitanakech. Boyewak ye eecha otiito? Yechi hin anadii ma yecha yesokwaken eena eecha otiito. Kwo diina na hiki ta. Yenya yan ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Miita biish shebo shebo tawa man kiyatay tawey, eecha na otiitanak kwotaka bana bana tawa ma ye eena hekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wonyak, God riipa hekiita. Dii eeta miiti saniga otii tawa boboy. Miiti Apoko rii miita veenyichi otii tar boboyen henyak, riipa miina yan hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Miita God riina maji batanak, mii wosheipii majiga bakasakech. Shebo wosheipii maji batawa ma ye lotu akak iyar maji ya batawa eemek iyar ma yechi misomak geenyek siitii God riina maji bato. Na hiki ta! Yenya yan ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Miita God riina maji bak otiiney, mii na miiti aka wok iyarechi nubereja dasiipiichi miiti veenyi tawa Apoko riina na maji ba. Miiti Apoko rii miita veenyi otii tawa boboyen hewak, riipa yan miina hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kwota God riina maji banak, opoche3 shebo shebo tawa ma batawaga eecha batanakech. Yecha eecha hikitu yecha nokwapa nokwapa ameda ameda maji banak, yenya meejikiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Opoche yecha otiitawabaga eecha otiitanakech. Kwoti Apoko rii kwota dopo tawa boboy hecho. Kwota riina wohenyan tawey, rii hecho. ");
INSERT INTO kmo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kwota na riina maji jecha ba: ‘Noti Apoko mii hevenek tawa. Miiti hi sa kepi wey ba ta. ");
INSERT INTO kmo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Miiti siitii kowu tawa kigdom sii sa ya. Miiti inyakan hevenk sumowutawaga nota nosapek tawa ma na eechaba sumowuba ta. ");
INSERT INTO kmo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nota yadii pochi dopo tawa aboboyen miita nona na ha ta. ");
INSERT INTO kmo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma ye nona kapasek otii tawa boboyen nota kwoyavayatawaga, miita na noti kapasek boboyen eechaba na kwoyava yeechi ta. ");
INSERT INTO kmo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mii opoche nona otiihechawa boboyen heechanak, ya nona otii hechanakech. Miita nona na Gaba riina na ya.’ Miiti kigdom, miiti hadabas boboy miiti hapaga boboy miitabaka eechaba eechaba takiita. (Omutiik) ");
INSERT INTO kmo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Na meeji. Kwota anadii ma yecha kwona kapasek otii tawa boboyen abosuchiney, hevenek tawa Apoko rii kwoti kapasek boboyen eechaba abosuchikiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kwota anadii ma yechi kapasek boboyen abosuchinan siiney, kwoti hevenek tawa Apoko rii eechaba kwoti kapasek boboyen saka abosuchikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kwo God riin wohechi aboboyen heechiney, kwo opoche eyepiitanakech. Woshepii majiga tawa ma yecha otiitawabaga eecha otiitanakech. Yecha otiitawey, yechi misoma eecha hatawa ma yechi misomaga eecha hechawak, anadii ma ye hechi eecha wocho ye aboboyen heechitu. Diina na hiki ta. Yecha yan ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Miiti aboboyen heechiney, miita na ukuk misoman bachichi masebiyak na rosii. ");
INSERT INTO kmo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Wonyak, anadii ma yepa miina henyak, yepa eechahikikiita rii aboboy heechikasakech. Miiti veenyichi tawa Apoko riitaba miin hekiita. Miita Apoko rii miita veenyichi tawa boboyen henyak, riipa miina yan hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kwo opoche kwoti diita nosapek tawa kepi boboyen yaya yopo yichitanakech. Machi atawak, keyiha boboy sii atawak, hiyiyatawa ma rii aka diigiichi yar hiyika yatol ");
INSERT INTO kmo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wowak, kwota na kepi boboyen hevenk yopo yichi ta. Li machi sii akasakech. Keyiha tawa boboy sii akasakech. Hiyi ya tawa ye saka aka diigiichi yar yakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Miiti hadabas boboy heechawa tawa eemek miiti inyaka wopu sii iibak siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Miy sii eeta kwoti haba. Miiti miy sii hehar hechaney, miiti maba sii eeta yama hecho. ");
INSERT INTO kmo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Miiti miy siita tiiriiney, miiti maba siipa niyiki yikiita. Wowak, eeta haba miitaka tawey, sii niy siiney, niyiki mayaka tawey, sii niyiki mayaka ya gamukiita! ");
INSERT INTO kmo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ma por rii aka tabo yima upurusen eepiira eepiira yo otiiney, ii saka kikisiikiitawak. Li riipa poren kwoya henyak, poren yuyakiita. Li riipa poren sumowunak, poren wosowoyekiita. Eena God riiti noboka moni noboka eepiira sumowukasakech. Li saka kikisiikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Eena ada kwona wocho: Opoche kwo ukuban aboboyeban aken hikitanakech. Miiti maba rikiban hikitaqnakech. Eechaba eechaba tawa boboy sii ukuka aboboyeka eecha kikisiikasakech. Eechaba eechaba tawa boboy sii rikiy siitaka kikisiikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Apo yecha haga i ye yataweyn na he. Yecha saga otiikasakech. Boboy siik chikasakech. Siik wanak, yakasakech. Ye eecha otiitawak, hevenek tawa Apoko rii yenya havato. Apo eeta karakada. Mii eeta harapa. Riita miina heharetakiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nama kwotaka tawey, rii hikichi riita kiki sowak rii eechaba ta ichakiita? Ma takasakech. ");
INSERT INTO kmo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wowak, boyewak kwo rikiban yaken hikitu? Kwota woheja she na hecha. Yecha rikin otiikasakech. Ye yo otiikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wowak, ada kwona wocho: Solomon rii riki kepin ruwuri, rii woheja sheba eecha kwoyakekasakech. Solomon rii saka kiki siirek. ");
INSERT INTO kmo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God riita otiitawak, woheja she eena wato. Woheja sii apa tawa. Lyi siin pokotiichi ye i hik tukukiita. God riita woheja shen rikiga eecha ruwu tawey, ii nona mukuchichurii nona eechaba hehar ruwukiita. Kwota hiki siitiichichawa boboy sii eeta karakada eena kwota rikiban aboboyeban hiki siitiichichu. ");
INSERT INTO kmo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eena kwo opoche eecha hikitanakech, nopa kapo boyen boboyen akiita? Boy ukun akiita? Boy rikin ruwukiita? ");
INSERT INTO kmo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diita eyey boboyen shebo shebo tawa man ye eena yaken hikitu. Kwoti hevenek tawa Apoko rii kwota dopo tawa boboyen hecho. ");
INSERT INTO kmo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kwota na mapo God riiti kigdom na yesha henyak God riiti inyakan na sumowu ta. Eecha otii taney, riipa kwona diita anadii boboyen kwona habatakiita. ");
INSERT INTO kmo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wowak, kwo iyav nedii opoche kawka inyakapwa hikitanakech. Iyik inyakapwa hiki tawa boboy siita yanak, eeta nedik napa opoy inyakapwa hiki ta. ");
INSERT INTO kmo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kwo opoche anadii ma riiti yon wosowoyetanakech. Eecha otiiney, anadii ma ye miiti yon awasen wosowoyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwo anadii man wosowoy tawaga God riipa kwona eechaba wosowoyekiita. Kwo anadii ma yen boboyen homachi ha tawaga, God riipa kwona awasen eechaba homachi hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wowak, boyewak mii kumwoy riiti miyik tawa regiin hechi wocho, mii miiti miyik tawa men mii eeta saka hechawak? ");
INSERT INTO kmo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Me miiti miyik tawey, mii boyewak miiti kumwoy riina eecha wocho: ‘Ada miiti miyik tawa regiin yaken otiito? ");
INSERT INTO kmo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eecha wochawak, mii keena woshepii tawa ma. Miita na mapo miiti miyik tawa men honii yeechi komas miiti kumwoy riiti miyik tawa regiin napa ya. ");
INSERT INTO kmo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kwo opoche God riiti boboy kepin asan hatanakech. Kwo haney, yepa dareboyechi ya kwona chekiita. Kwo opoche kwoti gayetiiken opoche poyi yechi kujak rabotanakech. Yepa eena yatiik piitii pejakiita. ");
INSERT INTO kmo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kwota God riina wohenyak, riipa kwona hakiita. Na yesha taney, kwopa hekiita. Kwo nubureja hapakaney, iipa kwona tagwachikiita. ");
INSERT INTO kmo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Eyey ma ye wohechaney, ii yepa yakiita. Kata ma rii yeshataney, ii riipa hekiita. Kata ma rii nuburejan hapakataney, iipa riina tagwachikiita. ");
INSERT INTO kmo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kwoti ma por rii yikapwa geyen aken wonyey, apoko riipa boy papan yeedi hakiita? Yaho. ");
INSERT INTO kmo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yikapwa rii emiyepen aken wonyey, kwo kapo boy hopon yeechihakiita? Yaho. ");
INSERT INTO kmo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kwota kapasek tawak, eecha otii tawey, kwo hikitu boboy kepin yikapwan havato. Wowak, hevenek tawa Apoko rii tawak, kwo wohenyak, riipa kwona kepi boboyen hatakiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Miita anadii ma ye miina otiichiken gegiyatawaga, miita na yenya eechaba na otii chicha. Dii eeta lo siiti maji mu. Dii eeta piirapet pokii tar maji mu diitata. ");
INSERT INTO kmo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kwota na i karakada nubureja yar. Hi uwu tawa eemek ichawa nobo sii eeta harapa. Eeka i yar tawa nubureja eeta bad mayaka. Eeechatawak, nokwapa nokwapa ma mima ye eena eeta nobok ichu. ");
INSERT INTO kmo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Eechaba eechaba hadabas eemek ichawa nubureja sii eeta karakada. Nobo eeta nokwapa nokwapa ma ye eena yeshahekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Woshepii tawa piirapet yenya na ow poy sii ta. Yecha sapi giiriichi yecha yatawey, eeta sipsip yatawabaga eecha he yato. Eecha yatawey, ii kwasheka tawa asaga eecha taws. ");
INSERT INTO kmo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yecha eecha otii taweyn kwota eena na hehar he siitiichi. Yechi yo kapo kepi, kapo kapasek Yamika tawa me rii siik kepi wakasakech. Pu hatawa me rii aboboy kepi wakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Me kepi rii eeta siik kepin watol Me kapasek rii eeta siik kapaseken wato. ");
INSERT INTO kmo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Me kepi rii kapasek siiken wakasakech. Kapasek me rii kkepi siiken wakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Me por rii siik wanan siiney, ii yiichi hik rabochichawak uwutu. ");
INSERT INTO kmo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eecha otii tawak, kwo woshepii tawa piirapet yecha otii tawa abon kwo henyak, eena na hiki ta. ");
INSERT INTO kmo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Eyey ma yecha ana eecha haba tawey, ‘Harapa, Harapa’ yepa saka God riiti kigdom iyarekiitawak. Kata ma ye eeji hevenek tawa Apoko riiti inyakak eecha otii tawey, yechaba keena hevenek ikiita. ");
INSERT INTO kmo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hamak tawa nediik yanak, nokwapa nokwapa ma mima ye yanak ana habatakiita: ‘Harapa, Harapa, nota miiti hik God riiti maji sawotar. Miiti hik nota kapasek spiriten no yeechi rabotar. Nota nokwapa nokwapa harapa hapaga yo otiitar.’ ");
INSERT INTO kmo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wowak, hamak tawa nediik anapa yenya eecha wokiita: ‘Ada kwona hekasakech. Ana na heechi i! Kwo kapasek tawa ma.’ ");
INSERT INTO kmo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Wowak, ma ye eeji diita maji meejichi sumowutawey, ye eeta inyaka wopu kepi tawa maga eecha tawak, aka papa hek eeka otiir. ");
INSERT INTO kmo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Otiiri, wayi mayaka vatari, uku yi ichari, sowa yatari, eeta aka sii sakakasakech. Boyewak? Siin papa hek otiirek, harapa papak neek siitiitarek, eena sakakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Eyey ma ye diita majin meejiri ye eena sumowunan siiri, ye eeta hikisha yesha maga eecha tawak, ye aka eeta kesinek otiitarek, wayi vatari, uku yi ichari, sowa yatari, eeta akan ameya otiichirek, sii sakar. Sakarek, siita harapa kapasek wey siir!” ");
INSERT INTO kmo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas rii diita majin ba hamarek, rii eecha pokii tarin, eeka tar ma mima ye eena heneba rabor. ");
INSERT INTO kmo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Rii yechi on otii hechawa mak banaga eecha bakasakech. Rii harapa ma yecha batawabaga riieecha batar. Eena batarek ye heneba rabor. ");
INSERT INTO kmo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas rii kwowun heechi ya sakarek, nokwapa nokwapa ma mima yeriina sumowu ichar. ");
INSERT INTO kmo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Worek, maba kapasek tar ma por rii Jisas riiti yatii bogok piitiichi yi riina wor: “Harapa Ma, mii eeta kiki sowa, mii otii henyak ana otii kepi siichik.” ");
INSERT INTO kmo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Worek, Jisas rii riiti tapak howu neekichi eecha wor: “Ada eena otiiken gegiyato. Na kepi sii!” Worek, kapasek tar maba sii eeta ameya kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Worek, Jisas rii riina eecha wor: “Na meeji. Mii opoche diita boboyen i anadii man sawo ye itanakech. Opel otii tawa ma riitak na nagwa nagwa inyak, rii sapa miina hehar he. Wonyak, miita napa Moses riita opel ha majin worega eecha otii ta. Miita wonyak, eyey ma yepa miina hechi eecha hikikiita riiti hak otii tar boboy eeta kepi siir.” ");
INSERT INTO kmo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas rii Kapaneam akamak iyarerek, ami kepten ma rii Jisas riina ya jaworek, rii riina woyasachiyasa her: ");
INSERT INTO kmo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Harapa Ma, eeji yo otii tawa wakasa ma rii eeji akak hak otiitawak, rii yatii tapa harek, harapa kapan meejito.” ");
INSERT INTO kmo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas rii awasen riina eecha wor: “Ada i riina otii kepi siik.” ");
INSERT INTO kmo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kepten rii meejichi eecha wor: “Harapa Ma, yaho. Ada ma kepik tanak een miita aka eeji ik. Miita majik wonyak, eeji wakasa ma sa eeka kepi sii. ");
INSERT INTO kmo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ada eechaba harapa tawa ma riiti kuruk tawa. Ada eechaba harapa tawak eeji ow ana pichawa ma ye eechaba eeji kuruk tawa. Eecha tawak, ada iken wowey, ye ichu. Ada akar man yaken wowey, ye yato. Ada eeji yo otii tawa wakasa ma yo otiiken wochawey, ye otiito.” eeka kepi sii. ");
INSERT INTO kmo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas rii meejichi rii nyegerabochi rii riina sumowutar ma mima yenya wor: “Ada kwona wocho diita yikadey hiki siitiichichawa boboyen Isrel ma yechaka ada saka herek. Riiti hiki siitiichichawa boboy eeta harapa tawa. ");
INSERT INTO kmo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Ada kwona wocho nokwapa nokwapa ma mima ya sokwa tawa nobok yanak, ya ye i tawa nobok yanak, yepa Ebraham, Aisak, Jekop yechaka eecha howuk tawa kigdom kepik siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma ye God riiti kigdom mashi iyar henyak tanak, yeeena saka ikiitawak. Eena yen sabak tawa niyik yik rabokiita. Wonyak, yecha kiyatanak pu takiivii kiikiirena siitiichichakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Worek, Jisas rii kepten riina kawka eecha wor: “Miita na heechi miiti akak i. Miita hiki siitiichichawa boboyen miina otiichikiita.” Worek, eeta nediibak yo otii tar wakasa ma rii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas rii i Pita riiti akak iyar heri, Pita riiti mima siiti awi sii meeji pu hak otii tarek eena watar. ");
INSERT INTO kmo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Watarek, rii siina tapak neekiirek, eeta maba hi uwutari, sii eeta ameya kepi siirek, sii sokwa aboboyen Jisas riina havaken sayarer. ");
INSERT INTO kmo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Worek, hogo siirek, ye nokwapa nokwapa spirit kapasek tar ma yenya Jisas riita otii kepi siiken yeechichi riitak yayar. Worek, Jisas rii maji barek eeta spirit kapasek ye eeta heechi irek, anadii hak otii tar ma yen otii kepi sii bar. ");
INSERT INTO kmo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mashi piirapet Aisaia rii eecha wor: “Riita mayama noti hak otii tawa boboyen kwoyaveechi noti kapasek boboyen yeechi kiya ir.” Jisas riita otiichirek, piirapet Aisaia riiti maji eeta geenye woyik siiken sokwar. ");
INSERT INTO kmo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Worek, Jisas rii nokwapa nokwapa ma mima ya riina gamu poyerek, rii eena hechi rii yenya eecha wor: “No katak pa giireba yepak heechi ik.” ");
INSERT INTO kmo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lo maji pokii tar ma por rii ya Jisas riina wor: “Tisa eyey eem miita ichawey, anapa ya miina sumowuniga eecha ibatakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Worek, Jisas rii awasen eecha wor: “Kwashika tawa asa ye aka nosap wok tawa. Apo ye wosiik tawa. Ma Yikapwa rii misoma veenyichi wa akakasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Worek, anadii ma por rii eeta Jisas riiti disaipel, rii eecha wor: “Harapa Ma, miita ana wochinak ada i eeji apokon chichi heechi yak ik.” ");
INSERT INTO kmo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisasrii riina awasen eecha wor: “Miita na ya ana sumowu ik. Ii eeta hatawa ma yechi yo. Sapa yecha chi.” ");
INSERT INTO kmo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Worek, Jisas rii i jabiirek ye ichi icharek, riiti disaipel ye ibatar. ");
INSERT INTO kmo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ibatarek, harapa sowa yatarek, pa uku boro harapa sokwabatarek, jabiir gubuken otiitar. Eeecha otiitarek, Jisas rii watar. ");
INSERT INTO kmo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Watarek, disaipel ye i riina cheyechi eecha wor, “Harapa Ma, nona na kiyatayi. No kapasek siik otiito.” ");
INSERT INTO kmo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisas rii meejichi yenya eecha wor: “Boyewak kwo akiita? Kwoti hiki siitiichichawa boboy sii eeta karakada!” Worek, rii sokwachi sowan uku borowon anachekerek yatari eeta siir. ");
INSERT INTO kmo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Worek, ye eyeyeena hechi nyegerabor. Nyegerabochi ye eecha wor: “Diita ma rii kapo boy yikadey ma? Rii sowa uku boron wowey, kata meejichi sowa!” ");
INSERT INTO kmo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Worek, Jisas rii i akar pa giireba yepak iti, Gadara yechi nosapek i it. Icharek, spirit kapasek tar ma upurus piir tiitiimo supun heechi yari, Jisas riina nobok jawor. Eeta ma piir kapasek boboyen otiitarek, eena ma mima ye eeta nobon i ye yakasakech ye akiitar. ");
INSERT INTO kmo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Piiriita harapa eecha uwar: “God riiti Yikapwa, sicha eeta miiti yokasakech. Mii boyak yawa?” ");
INSERT INTO kmo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bana tarek, nokwapa nokwapa poyi ye atar. ");
INSERT INTO kmo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Worek, kapasek spirit ye Jisas riina woyasachiyasa her: “Miita nona yeechi raboney, napa nona heechinak, nopa i kata poyi yechaka eecha siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Worek, Jisas rii yenya eecha wor: “Na i.” Worek, eeta ma piiriin heechi iri poyi yechaka eecha siir. I siirek, eyey poyi yi kwowuk tarin heechi buk akii iri, pak i ye ichi ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Poyin siitii kowu tar ma ye heechi akii iri, harapa akama iri, diita otiir majin spiriteka tar ma piiriina otii kepi siirin eena sawo ye i tar. ");
INSERT INTO kmo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Worek, eyey akamak tar ma ye akama heechi ir. Jisas riina nobok jawochi eena akar nosapek heechinak iken eena woyasachiyasa her. ");
INSERT INTO kmo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas rii jabiirek i yowuchi pa giireba yepak i iri riiti akamak siikenek iyarer. ");
INSERT INTO kmo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Worek, ye yatii tapa har ma poren yemek jichi kiya ya seechir. Worek, Jisas rii yecha hiki siitiichichar boboyen heri, rii yatii tapa har ma riina wor: “Miiti inyaka sa kwoya hik. Miiti kapasek boboyen bachi poyewa.” ");
INSERT INTO kmo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Worek, Ion maji pokii tar ma kaw ye inyakak batar:” “Kata ma rii God riina wosoboy majin bato!” ");
INSERT INTO kmo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas rii yechi inyakan hechirii eecha wor: “Boyewak kwo kwoti inyakak diita yikadey kapasek boboyen hikitu? ");
INSERT INTO kmo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ada maji upurus baney, ‘Miiti kapasek boboy bachi poyewa,’ nago, ‘Na sokwa siitii chishi i?’ Diita upurus maji sii eeta podat. ");
INSERT INTO kmo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ada kwona mukuchik Ma Yikapwa rii diita nosapek tawak, riita eeta kiki sowak, rii God riiti harapa boboyek eecha tawak, rii kapasek boboy bachi poyetu.” Worek, rii yatii tapa har ma riina eecha wor: “Miita na sokwa miitiwa gwosen yeechi miiti akak i!” ");
INSERT INTO kmo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Worek, kata ma rii sokwachi riiti akak ir. ");
INSERT INTO kmo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Irek, ma mima ye riina hechi ye akiita. Ye her God rii eecha tar hapaga boboyen man harek, ye eena God riiti hin yesokwa tar. ");
INSERT INTO kmo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas rii heechi chishi icharek, rii i takis yan yater ma, Matyu, riina her. Rii riiti yo otiitar aka wok yicharek, rii her. Herek, rii riina eecha wor: “Mii na ana sumowu ta.” Worek, Matyu rii meejichi sokwa sumowuniga ir. ");
INSERT INTO kmo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Komas Jisas rii akak yi otii atarek, takis yan yater ma ye kapasek muk shebo shebo tar ma yechaka eecha ya Jisas riiti disaipel yechaka yi otii abatar. ");
INSERT INTO kmo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Worek, Peresi ma kaw ye eena hechi Jisas riiti disaipel yenya eecha wor: “Boyewak kwoti Tisa rii takis yan yatawa ma yechaka kapasek muk shebo shebo tawa ma yechaka eecha yi otii ato?” ");
INSERT INTO kmo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas rii meejichi yenya eecha wor: “Hak otiinan biish tawa ma ye dokta riitak ikasakech. Hak otii tawa ma yechabadokta riitak ichu. ");
INSERT INTO kmo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kwo diita God riita jeyek keyir majin eena na i kenyechi siiti mun na hiki ta. ‘Opel otii tawa boboyen ada eena gegiyakasakech. Ada man rukusii tawa boboyen kwota otiiken eena gegiyato.’ Ada yari an saka ma kepin uwaken yarek. Yaho. Ada muk shebo shebo tawa man kapasek tawa man eena uwaken yar.” ");
INSERT INTO kmo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Worek, jon Baptis sumowutar ma ye Jisas riitak ya riina woher, “Nota God riina wohechanak, boyewak nota Peresi yechaka aboboyen heechitu? Miiti disaipel ye aboboyen heechikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas rii meejichi wor; “Ma por rii miman yak otiiwak, riiti nareboy ya nokusha aboboyen atawak, kwo boy kapo eecha hikitu ye aboboy akasakech.’ Yaho. Miman yak tawa ma riin yeechi ye inyak, eeta nedii nareboy yecha aboboy akasakech. ");
INSERT INTO kmo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ma por rii riki kepin yeechi mashi saket neekii tana supun kapa kasakech. Rii eecha otiiney, eeta saket siipa kawka neekiinak karapa supuk siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma por rii akar wain ukun mashi meme sapi kwowok woyekasakech. Iipa sii sapi neekiinak uku saka ikiita. Sapi siipa eeta neekii nakiikiita. Akar wain ukun eeta akar meme sapik eeka woyeto. Woyetanak, ukuka sapika piiriipa eeta kepi batakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas rii diita majin batarek, Ju yechi harapa ma por rii ya Jisasriina yatii bogok piitiichi eecha wor: “Eeji yikapwa eeta hawey har. Miita na ya miiti tapak neeki siipa kawka ya sokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Worek, Jisas rii sokwa riina sumovu riitaka eecha ir. Irek, riiti disaipel ye riina sumovu ibatar. ");
INSERT INTO kmo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yecha icharek, mima pochi sii tari, siita kamu sii tari 12 sukwiya eecha tar. Tarek, sii ya Jisas riina sumovu i riiti saket barek howu neekir. ");
INSERT INTO kmo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sii mayama eecha hikir: “Ada riiti saketen howu neeki henyak, ana otii kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Worek, Jisas rii vayeko hechi siina eecha wor: “Yikapwa, na ana beyichi ta! Nija ana hiki siitiichichawa boboy sii eeta ninya otii kepi sowa.” Worek, sii eeta ameya kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Worek, jisas rii Ju harapa ma riitaka eecha ichi riiti aka wok iyarer. Iyarechi rii sagey piita tar ma yenya keya hoyi tar ma miman her. ");
INSERT INTO kmo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hechi rii eecha wor: “Na kwona toch! Diita karakada yikapwa sii biish wato!” Worek, ye meejir riina wokwoyaniga heger. ");
INSERT INTO kmo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma mima yen wochirek, geenyek iyarerek, rii yikapwa siita watar aka wok iyarechi siiti tapan yesokwa neekirek, sii eeta awasen yesokwar. ");
INSERT INTO kmo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Worek, eecha otiir maji sii akar nosapek i ye yar. ");
INSERT INTO kmo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas rii eeta eemen heechi rii chishi tarek, miy kiitiitar ma upurus piir riina sumowuniga i uwaniga eecha wor. “Devit riiti neja, Kraist, miita na sinya inyakapwa hikichi ba diigiichi!” ");
INSERT INTO kmo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas rii aka wok iyarerek, piir iyarebachi riitak yarek, rii piiriina eecha woher: “Ki kapo eecha hikitu ada eeta kiki sowa kinya otii kepi siikiita? Piir awasen eecha wor: “Ayo, Harapa Ma!” ");
INSERT INTO kmo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Worek, Jisas rii piiriiti miyik tapa howu neekichi eecha wor: “Kicha hiki siitiichichawey, sii sa wokwa!” ");
INSERT INTO kmo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Worek, piiriiti miy eeta mey makar. Worek, Jisas rii kabuk wor: “Anadii man ki sawo ye ikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Worek, piir heechi iri Jisas riita piiriina otiir boboyen eyey nosapek sawo ye itar. ");
INSERT INTO kmo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yecha heechi iken otiitarek, ma kaw ye kapsek spiriteka tarek, kuja dimiitar man Jisas riitak yayar. ");
INSERT INTO kmo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kapasek spiriten yeechi raborek, eeta ma rii maji bar. barek, eyey mama ye eena hechi nyegerabochi eecha wor: “Mashi no Isre ma diita yikadey boboyen hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Worek, Peresi ma ye eecha wor: “Rii kapasek spirit yechi harapa ma riita wochitawak, eena rii eecha yeechi raboto.” ");
INSERT INTO kmo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas rii eyey akaman i chishi ye itar. Chishi ye itarek, rii yechi lotu akak i yar yenya maji pikii tar. Rii God riiti kigdom hadabas maji kepin sawotar. Eyey ma mima hak otii ye i tarin rii yenya eyey otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma mima ye nokwapa nokwapa ya yopo wuchi yirek, rii eena hechi inyakapwa hikir. Yecha kubuchey yikapwaga eecha tarek, ye eena inyakapwa hikitarek, yenya ma kiyatayikasakech eecha tarek, sipsipen siitii kowu ma biish taniga eecha tarek, eena rii yenya inyakapwa hikir. ");
INSERT INTO kmo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hikirek, rii riiti disaipel yenya eecha wor: “Nokwapa nokwapa nowo saga tawey, saga ya ma nokwapakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eena na Nowo Ma riina maji batanak, riipa akar nokwapa nokwapa saga ya man rii heechinak yakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas rii riiti 12 disaipel yenya uwarek, ye ya yopo wuchi yir. Yirek, rii ri hapaga boboyen yenya harek, ye eeta kiki siirek dapasek spiriten ye yeechi rabo tarek, hak otii tar boboyen ye otii kepi siitar. ");
INSERT INTO kmo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Eeta 12 aposel yechi hi diitata: mapo eeta Saimon, riina habatar Pita. Endru, Pita riiti kumwoy. Jems, riiti kumwoy, Jon. Piir Sebedi riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, batolomyu. Tomas, Matyu, rii takis yan ya tawa ma. Jems rii Alpiyas riiti yikapwa. Tadias. ");
INSERT INTO kmo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Selot. Judas Iskeriot, rii komas Jisas riina magiiriichir ma. ");
INSERT INTO kmo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas rii diita 12 disaipel yenya heechirek irek, rii eecha wor, “Kwo opoche i shebo shebo tawa ma yechaka eecha tanakech. Samaria nosapek opoche i tanakech. ");
INSERT INTO kmo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isrel ma kaw yecha i nobo yesha tawa sipsip tawaga eecha tawa. Na kwo yechaka na eecha i ta. ");
INSERT INTO kmo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na i yenya eecha sawo ta. ‘Hevenek tawa kigdom sii diita ya band band tawa!’ ");
INSERT INTO kmo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hak otii tawa man na otii kepi sii ta. Ha tawa man na saniya ta. Maba kapasek tawa man na otii sa kepi hecha. Kapasek spiriten na yeechi rabo ta. Kwota boboyen yatawey, shebo shebo yato. Yenya boboyen haney, opoche tokotanakech. Na shebo shebo ha. ");
INSERT INTO kmo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kwo opoche go, silva, kapa yan kwoti kwowok woyi ichanakech. ");
INSERT INTO kmo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kwo opoche kwowo wakiir ichanakech. ");
INSERT INTO kmo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kwo opoche saket upurus yatii ruwu tawa boboy ye ichanakech. Kubu opoche neeki ichanakech. Yaho. Ma yon otiiney riipa riiti aboboyen yakiita. “Kwo akaman iyarenak, anadii akaman iyarenak, na i ma kepin na yesha hechi riiti akak riitaka eecha na sii. Eeka eeta akabak tanak kwopa eeta akaman heechi sokwa ikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kwo aka pochik iyareney, na i akama yen woshi a. ");
INSERT INTO kmo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Eecha otiinak, yecha kwona yaney, ii na yenya maji kepiban ba. Banak, yechi inyaka kwoya hikikiita. Woshi anak, yecha kwona awasen woshi anan siiney, ye meejiney, eena na heechi ya. ");
INSERT INTO kmo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aka ma por rii kwona yeechi ye inyan siiney, anadi akama tawa ma ye kwona yeechi ye inyan siiney, ii na heechi. Kwoti yatii cheren kavakava pakachi heechi i. Eeta akaman God riipa harapa kapasek otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Diina na hiki ta: anasaka tawa nedii yanak, God riipa Sodom, Gomora akama ma miman karakada pikiita. Riipa diita akama tawa ma miman harapa pikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Na meeji. Ada kwona wochiwak ichawey, kwo sipsip tawaga kwo nokwapa nokwapa kwashika tawa asa yechaka eecha i siikiita. Hopo yecha hehar hikichi eshar ichawabaga kwo na i eechaba otii ta. Nurer yecha kepi boboyeban otii tawaga kwo na eechaba otii ta. ");
INSERT INTO kmo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kwota na ma yenya owpoy sii ta. Yepa kwona yeechi kaunsil ma yechak ye inyak yepa kwona anaseechi yechi lotu akak eeka kubu pikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kwo eeji hik yon otiitanak, yepa kwona yeechi aka tabo yimak ye inyak, gavman ma ye inyak, kwo eeji hadabas majin yen anadii shebo shebo tawa ma yenya sawotakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yepa kwona asasak ye inyak, kwo opoche akiichi eecha wochanakech, ‘Nopa kapo boy majin awasen bakiita? Nopa kapo shecha bakiita?’ Yaho. Eeta nediibak God riipa kwota ba majin sawo mukuchikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwota batana maji eeta kwotikasakech. Kwoti Apoko riiti Spiritek kwotak yanak, kwo eeka bakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ma kaw ye yechi yaka kumwoy yenya anadii ma yenya mukuchinyak, yen pi sowakwokiita. Apolo yepa yikapwa yen eechaba otiitakiita. Yikapwa yepa apoko nokwapa yenya magiirechinyak, sowakwokiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Eeji hi kwotaka eecha tawey, eyey ma yepa eeta kwona henyey, yuyakiita. Ma kaw ye hapago siichi taney, yepa i komas hamak tawa nediik i siiney, God riipa yenya hechi yesokwa yichikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yepakwona akama pochi kikir poyeney, ii napa kwona heechi anadii akama pochik akii sii. Ada kwona wocho: Kwopa i Isrel yechi akaman yo saka otii hamatanak, ma yikapwa riipa yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Skul ya tawa ma rii riiti tisa riitak kikisiikasakech. Yo otii tawa wakasa ma rii riiti harapa man dagiir poyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eena eeta kiki sowa skul ya tawa ma ye yechi maji pokii tawa ma riitaka eecha kiki sowa. Yo otii tawa wakasa ma ye sokwa yechi harapa; ma riitaka eecha kiki sowa. Ma ye eeta Harapa Ma riina kapasek otii tawa harapa ma habataney, yepa riiti yo otii tawa wakasa ma yen kapo shecha habatakiita? Hi kapasek habatakiita! ");
INSERT INTO kmo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Wowak, kwo ma yenya opoche akiitanakech. Eyey boboy veenyichi tawey, komas sii geenyik ya sokwakiita. Eyey veenyi tawa majin geenyik kwodii wokiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Maji ada kwona niyik sawotawey, kwo napa eena yadiik sawo ta. Maji kwotaba meejiri, kwo napa eena eyey ma yenya uwabatanak, ye sapa meejiba ta. ");
INSERT INTO kmo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kwo maban otii sowakwo tawa man opoche akiitanakech. Ye kwoti meseken saka sowakwo bakiitawak. Kwo God riitaban na akii ta. Riita keen kiki sowa, riipa kwoti maba kwoti mesek upurusen yeechi hi hay tawa eemek rabochinyak, hi uwukiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Karakada apon ya karakadak tokoto. Wowak, karakada apo pochi nosapek sakatweyk, kwoti Apoko rii eena hechi heechitu. ");
INSERT INTO kmo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kwo na mayama hiki. Kwoti masebiya God riita otiichi kenyichi heechir. ");
INSERT INTO kmo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wowak, kwo opoche akiitanakech. Apo ye eeta karakada. Kwo eeta harapa! ");
INSERT INTO kmo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kata ma ye eeji hin geenyik kwodii wochaney, ada eechaba yechi hin eeji Apoko riina hevenek kwodii wochakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kata ma ye eyey ma misomak eecha wonyey noriitikasakech, ada eechaba hevenek eeta ma yenya magiirechibakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kwo opoche eecha hikitaqnakech ada nosapek yari diita nosapek tawa ow ana pichawa boboyen anachekeken yar. Yaho. Ada eena saka anacheken yarek. Ada eekiyen yayar. ");
INSERT INTO kmo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ada ya otiirek, hoyey yikapwa rii sokwa riiti apokon pik otiikiita. Mima yikapwa sii sokwa siiti awin pik otiikiita. Mima sii way sokwa siiti ma riiti awi siina pikiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ma por riiti ow ana pichawa ma ye riiti aka wok takiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma por rii ana koma kinyik heechinak, riiti awi apokon yaya mapo heechiney, rii eeta eeji nareboyikasakech. Ma por rii ana koma kinyik heechinak, rii riiti yikapwan yaya mapo heechiney, eeta ma rii eeji nareboyikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma por rii riiti nobon mayama heechinan siiney, riina har yon kiyachiniga ana sumowunan siiney, rii eeta eeji nareboyekaskech. ");
INSERT INTO kmo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kata ma por rii riita maban mayama egiisiitaney, riipa sii siiken siikiita. Kata ma rii riiti maban yeechi eeji hik rabotaney, riipa akar maban siikenen yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kata ma rii miina woshiataney, ii eeta rii ana woshiabato. Kata ma rii ana woshiatawey, rii eeta ana heechirek yar Apoko riina woshiabato. ");
INSERT INTO kmo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","God riiti piirapet por yaney, ma por rii riina hechi piirapet wochi woshianey, piirapet yenya hak tawa yan riipa yabakiita. Nagwa nagwa tawa ma por yaney, ma por rii riina hechi nagwa nagwa tawa ma wochi woshianey, nagwa nagwa tawa ma yenya hak tawa yan riipa yabakiita. ");
INSERT INTO kmo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Diina na hiki ta. Ma por rii ana sumowu tawa ma riina uku sobon siiviichi haney, rii hecho rii eeta ana kubuchey sumowu tawa ma rii eena hawey, riipa saka yan dopokiitawak.” ");
INSERT INTO kmo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas rii diita majin riiti 12disaipe yenya barek, rii kata eemen heechi rii akar bana bana tar akamak i yenya God riiti majin pokii tarek sawo tar. ");
INSERT INTO kmo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Worek, Jon riin poko ji tarek, rii Kraist riita otii tar yon meejichi rii riiti disaipel kawen Jisas riitak heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Heechirek irek, ye Jisas riina woher: “Mi eeta kapo yaken otii tawa ma? No boy kapo akar man kowutakiita?” ");
INSERT INTO kmo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas rii meejichi eecha wor: “Kwo na heechi awasen i Jon riina kwota hechawa boboyen kwota meejiwa boboyen napa sawo. ");
INSERT INTO kmo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Miy kiitii tar ma ye mey maka hecho. Yatii ha tar ma ye kepi chishitu. Maba kapasek tar ma ye eeta kepi hecho. Mabiya giitar ma ye eeta hehar meejito. Har ma yen yesokwa yichitu. Eeta hadabas majin kiiriisiiposii tawa ma yenya sawo mukuchichu. Een na sawota. ");
INSERT INTO kmo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kata ma por rii anada hiki siitiichichawa boboyen abosuchinan siiney, riipa inyaka kwoyawoy hikitakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon riiti disaipe ye heechi awasen icharek, Jisas rii Jon riiti majin ma mima yenya sawochi eecha wor: “Mashi kwo me biish tar eemek Jon riina heken iri, kwo boyen heken eena ir? Kapo kwo gubu kiipiikan sowak howo taweyn eena heken ir? Yaho. ");
INSERT INTO kmo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Boyen heken eena ir? Kwo kapo iri riki kepin ruwu tawa ma riina heken eena ir? Yaho. Eeta yikadey ma ye aka tabo yima riiti harapa akak ye eeka yichu! ");
INSERT INTO kmo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ana na wo. Boyen heken kwo ir? Kapo piirapet poren heken eena ir? Ayo. Ada kwona wocho: Kwo iri kwo piirapet tawaga tawa harapa boboyen hechar. ");
INSERT INTO kmo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","God riiti mashi keyir maji eeta Jon riina batari eecha wor: ‘God riita eecha wor: Dii eeta eeji majin heechiwak ye ichawa ma. Ada riina mapo heechinak i miiti nobon sayarechichak.’ ");
INSERT INTO kmo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Diina na hiki ta. Jon Baptis rii diita nosapek tar man eyey dagiir poyetu. Wowak, God riiti hevenk tawa kigdom karakada tawa ma rii waqy Jon riina dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon rii ya maji sawor nedii apa howuk tawa God riiti kigdom sii ow ana pik yaniga sii eecha yato. Yatawak, ow ana pichawa ma ye iyareken eena otii otii hecho. ");
INSERT INTO kmo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Eyey piirapet ye, Moses riiti o maji sii mashi Jon riiti nedii God riiti kigdom maji sawotar. ");
INSERT INTO kmo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kwota yechi maji meejiken gegiyaney, ii na meeji. Ye eecha wor: ‘Ilaija riipa yakiita!’ Jon rii eeta Iaija. ");
INSERT INTO kmo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kwo mabiyaka tawey, diita hapaga maji na meeji. ");
INSERT INTO kmo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ada kwona boyega shecha mukuchik? Kwo kapo boyega shecha tawa? Yecha yikapwa awaba tawa eemek yinyaga hecho. Yikapwa kaw ye anadii yikapwan uwachi wocho: ");
INSERT INTO kmo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nota kwona sagey piitachichawey, kwo hokwa chikasakech! Nota keyaniga chichawa hokwan chichawey, kwo eena kiki chikasakech.’ ");
INSERT INTO kmo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Eecha otiitari, Jon riita yari, rii aboboy akasakech. Rii wain ukun akasakech. Rii eecha otiitarek, ma mima ye eecha wor: ‘Rii eeta hikishato!’ ");
INSERT INTO kmo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma Yikapwa rii yarek, rii aboboyen otii atarek, wain ukun atarek, ma mima ye eecha wor: ‘Na he! Rii abobyen harapa atawak, wain ukun harapa atawak, rii eeta takis yan ya tawa ma yechi apoma, muk shebo shebo tawa ma yechi apoma.’ Wowak, nagwa nagwa hiki tawa boboy siiti siik sii eeta nona mukuchichu sii eeta siiken tawa.” ");
INSERT INTO kmo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Akama kaw Jisas riita mirakel otiirin, ye eena heri, yecha saka yechi kapasek boboy heechirek, eena rii yenya ow maji batar. ");
INSERT INTO kmo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Rii eecha wor: “Korasin, God riita harapa kapasek boboyen kwona hakiita! Betsaida kwon eechaba harapa kapasek boboyen habakiita! Mirakelen kwoti akamak ada otiirega, Taia akamak saidon akamak eeka ada eecha otiiyega, yecha keha tar rikin hiipiichi hiki shebo maba tenye yopo wuchi yichaken otiitar. Yechi kapasek boboy magiirechiken eena eecha otiitar. ");
INSERT INTO kmo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Diina na hiki ta. Anasak tawa nedii yanak, God riipa Taia, Saidon akamak tawa ma yenya karakada pikiita. Kwona harapa pikkta. ");
INSERT INTO kmo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapanean akamak tawa ma kwo na meeji! Kwo boy eecha hikitu, no hevenek ichawa nobok ikiita? Yaho. Kwona hi uwu tawa eemek eeka rabokiita! Mirakelen kwotak ada otiirega, Sodom akamak otiiyega, apa Dodom akamak eechaba tawa. ");
INSERT INTO kmo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Diina na hiki ta! Anasak tawa nedii yanak, God riipa Sodom akamak tar ma yenya karakada pikiita. Kwona harapa pikiita!” ");
INSERT INTO kmo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eeta nedii Jisas rii eecha wor: “Apoko, mii howuka tawa Harapa, nosapeka tawa Harapa. Miita miiti inyakak tawa boboyen yikapwa yena mukuchitarek, harapa otii hechar ma yenya mii veenyitarek, eena ad miina woshiato. ");
INSERT INTO kmo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ayo. Apoko mii miiti inyakak tawa boboyen miita hikichi otiir. ");
INSERT INTO kmo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eeji Apoko rii eyey boboyen eeji tapak howu har. Ma ye eeta Yikapwa riina hekasakech. Apoko riitaba saniga riina hecho. Eeta Apoko riina ma ye hekasakech. Eeta Yikapwa riitaba riina hechi kata ma yen eeta Yikapwa rii Apokon mukuchichawak, ye hebato. ");
INSERT INTO kmo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kwotaq ma harapa yon otii tawey, kwo maba kapa meeji tawey, adak na yanak, ada kwona otii yi hapakachik. ");
INSERT INTO kmo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ada kiyatawak nomoyatawa boboyen kwo na yeechi kiyabachi kwo eeji inyakak hiki tawa boboyen na yaba ta. Eecha otiiney, kwopa yo otii nedii yi hapakakiita. Ada eshar otii tawa ma. Ada wohipu tawa makasakech. ");
INSERT INTO kmo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ada kwona nomoyatawa boboyen kiyachiwey, ii harapa yokasakech. Ada kwona kiyaken hana boboy sii nomoyakasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Komas Jisas rii akamak sii tawa nediik wit nowo far nediik eeka i chishitar. Worek, riiti disaipel ye eecha harek, ye eeta wit siiken siikiirechi atar. ");
INSERT INTO kmo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eecha otii atarek, Peresi ma ye hechi Jisas riina eecha wor: “Na he. Eeta yikadey boboyen miiti disaipel yecha Sabat nedii otii tawey, ii ye noti on nediik reekiito!” ");
INSERT INTO kmo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Jisas rii meejichi eecha wor: “Kwo kapo Devit riiti majin saka kenyitarek? Eeta nedii rii riiti wakasa ma yechaka eecha hatarek, ye God riiti akak iyarer. Iyarechi rii riiti ma yechaka God riina har geyen ye eena yeechi ar. Geyen yeechi atari dii eeta ye on reekiir. Opelen otiitar ma yechaba diita geyen atari ii on reekiikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kwo kapo Moses riiti on saka kenyitarek? Maji eecha wocho: Sabat nediik opelen otii tawa ma ye harapa otu akak yo otii tawey, ye eeta lon mayama reekiitawak, ye eeta kapasek boboy otiikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wowak, ada kwona wocho: diika tawa boboy sii harapa llotu akan dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kwota diita God riiti maji mun hiki taney, ‘Ada opelen otii tawa boboyen yuyato. Man rukusii tawa boboyen eena ada kwoya hikitu, ‘Kwo kepi tawa man wosowoyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wowak, Ma Yikapwa rii eeta Sabat nediin siitii kowu tawa Harapa Ma.” ");
INSERT INTO kmo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Worek, Jisas rii eeta eemen heechi yechi lotu aka porek iyarer. ");
INSERT INTO kmo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma por rii eeka tari riiti tapa kapasek tar. Worek, ma ye eeka tari, ye Jisas rii kapasek yon ba diimaken eena hiki ye itar. Eecha hiki tarek, ye eena riina woher: “Nopa boy Sabat nediik hak otii tawa man boy otii kepi siikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas rii awasen eecha wor: “Ma por rii kwotaka tawey, riiti sipsip saka supuk ye inyey, riipa boy saka heyi yeechi yesokwakiitawak? ");
INSERT INTO kmo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wowak, ma rii eeta harapa. Sipsip sii eeta karakada. Wowak, noti lo eecha wokasakech: Sabat nediik man otii kepi siikasakech. Eena nota keena yo kepin Sabat nedii otiito. ");
INSERT INTO kmo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Worek, rii ma riina eecha wor: “Miiti tapan na danegwa.” Worek, rii danegwarek, eeta kepi siir. Riiti akar tapa pochi kepi tari, siitiibaga eecha siir. ");
INSERT INTO kmo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Worek, Peresi ma ye hechi kapasek hechichi i yopo wuchi yi Jisas riina pisowakwo maji apo dagii tar. ");
INSERT INTO kmo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas rii riina pi sowakwo majin meejichi rii eetaq eemen heechi ir. Heechi icharek, nokwapa nokwapa ma mima ye rii na sumowuniga eecha ichar. Rii eyey hak otii tar ma yenya otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Otii kepi siirek, rii yenya eecha wor: Anadii ma yenya ana opoche geenyik kwodii wochanakech. ");
INSERT INTO kmo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Rii yenya eecha worek, piirapet Aisaia riita ya bar maji sii eeta siiken woy sokwar. Aisaia rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“God rii eecha wor: Dii eeta eeji yo otii ma ada hisiir. Riina ada rukusiitawak, ada kwoya hecho. Ada eeji Spiriten riitak heechitakiita. Riipa eeji nagwa nagwa otii tawa boboyen muk shebo shebo tawa ma yenya sawotakiita. Riipa maji awasen awasen saka bakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Riipa saka kabuk wokiitawak. Riipa akamak harapa maji saka batakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gubu kawen reekiiney, riipa sakapa eyey reekiikiitawak. am pochi sii hak otiiney, riipa saka otii hakiitawak. Riipa i eechaba eechaba otiitaqnak, nagwa nagwa otii tawa boboy siipa sokwa howuk siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nokwapa nokwapa ma yepa riina hiki siitiichi kowutakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Worek, ma kaw ye ma poren yeechi Jisas riitak ye ir. Riiti miy kiitarek, kuja diimiibatar. Kapasek spirit riiti wok tarek eena eecha tar. Tarek, Jisas rii otii kepi siirek, riita maji barek, rii mey maka her. ");
INSERT INTO kmo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ya yopo yichar ma ye eena hechi heneba rabochi ye eecha woher: “Rii kapo boy Devit riiti neja, Kraist?” ");
INSERT INTO kmo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Peresi ma ye eena meejichi ye eecha wor: “Harapa Gaba, Besebu, riita riina hapaga boboyen hatawak, rii eena kapasek spiriten yeechi raboto.” ");
INSERT INTO kmo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Worek, Jisas rii yechi inyakan hechari rii yenya eecha wor: “Apoma ye ow eeta apomaban ow ana pichawey, ye hapaga siikasakech. Iipa eeta kkapasek siikiita. Podar akamak tanan sokwa ow ana pinyey saniga siiney, iipa eeta kapasek siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wowak, Gabaka tawa ma kaw ye anadii Gabaka tawa ma kawen ow ana pichaney, Gaba riiti kigdom saniga saniga tawey, iipa kapasek siikiita! ");
INSERT INTO kmo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kwo eecha wocho: ‘Besebul riita ana hapaga boboyen hatawak, ada eeka otiito! Eecha siiken taney, nama kwona sumowu tawa ma yenya hapaga boboyen hatawak yecha kapasek spiriten yeechi raboto. Kapo Beselbull? Kwona sumowu tawa ma ye otiitawey, ye geenyik kwodii mukuchichawey, kwoti inyaka eeta kapasek hikitu! ");
INSERT INTO kmo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ayo. God riiti Spirit rii ana hapaga boboyen hatawak, ada kapasek spiriten yeechi raboto? Ada diina eecha otiitawey, ii geenyik eecha mukuchichu God riiti kigdom kwotak yar. ");
INSERT INTO kmo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Hapaga tawa ma por riita riiti akak tarek, hiyiyatawa riiti boboyen yar yak otiiney, mapo riiti tapan poko jichi sapa opoy ya. ");
INSERT INTO kmo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ma por rii adaka eecha tanan siiney, rii eeta eeji yabo pi ma. Ma por rii ana boboyen yaya yopoyichiken kiyatayenan siiney, rii eeta boboyen rabo ya payato. ");
INSERT INTO kmo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eena ada kwona wocho: ma ye eyey kapasek boboy otiiney kapasek maji bataney, iipa God riita kwoyava yakiita. Ma por ri Hoi Spiriten wokwoyaney ii riina kwoyava yakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma por rii Ma Yikapwa riina wokwoyaney, God riipa riina kwoyava yeechikiita. Ma por rii Holli Spiriten kapasek maji ba wokwoyaney, iipa riina kwoyava yeechikasakech. Apa komas kwoyava yeechikasakech. Yaho. ");
INSERT INTO kmo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kwota me siik kepin yaken otiiney, ii na me kepin ya yeechi chinyak siik kepin wakiita. Me kapasek taney, rii eeta siik kapasek wato. Ma ye hecho me kepi taweyeka, kapasek taweyeka piiri siiken ye hecho. ");
INSERT INTO kmo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kwo hopoga eecha tawa. Kwo eecha kapasek tawak kwo boyega maji kepin bato? Ma ye yechi inyaka wopuk tawa boboyen ye eena bato. ");
INSERT INTO kmo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ma kepi rii riiti inyaka sugu wopu kepi tawey, rii yo kepin otiito. Ma kakpasek rii riiti inyaka wopu kapasek boboyeka tawey, rii eeta kapasek yon otiito. ");
INSERT INTO kmo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ada kwon wocho: anasak tawa nedii yanak, eyey ma mima ye yecha eyey biish batar maji sapa geenyik kwodii wonyak, anasakiita. ");
INSERT INTO kmo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Miita batawa maji sii miina anasakiita. Kwota batawa majin, God riita meejitawey, riipa kwona anasakiita. Kwoti maji kepi taney, kwota kepi siikiita. Kapasek taney, ii kapasek siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lon maji pokii tar ma kaw ye Peresi ma kaw ye eecha wor: “Tisa nota miita mirakelen otiinak heken gegiyato.” ");
INSERT INTO kmo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Worek, Jisas rii awasen eecha wor: “Kapasek tawa ma ye God riina hikinan biish tawa ma ye mirake otiken eena wohecho. Mukuchichawa boboy podaren kwona hakiita. Piirapet Jona riiti mirakelen kwona eena hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona rii emiyep suguk i tari niy piiriichar yadii piiriichar eecha tarega, Ma Yikapwa riipa eechaba yadii niy piiriichar nosapek chinyak eeka eecha siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Anasak tawa nedii yanak, Nineva akama ma ye siitii kwona ba diimakiita. Yecha Jona riita sawotar majin meejitari, ye kapasek boboyen heechi magiirechir. Ada kwona wocho boboy kaw Jona riina dagiir poyeri diita diika tawa. ");
INSERT INTO kmo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Anasak tawa nedii yanak, asut mushi yepak tawa aka tabo yi mima sii ya siitii kwona hehar ba diimakiita. Boyewak? Sii siiti eemen heechi yapa eem mayakan ya Soomon riiti harapa otii hechawa boboyen sii eena hek yar. Wowak, ada kwona wocho boboy kaw diika tawey, ii Soomon riina dagiir poyetu! ");
INSERT INTO kmo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kapasek spirit por rii ma poren heechi saya sabak i wayi vanan biish tawa eemek i ye ya tawey, rii yi hapaka eemeneena yesha i ye yato. Yesha i yaya hipuney, ");
INSERT INTO kmo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","rii mayama eecha wocho: ‘Ada mashi tar akabak eeka kawka i siik.’ Wowak, rii kawka i hechawey, eeta aka eeta hako kiiriikuchi keyapochi siitiichir. ");
INSERT INTO kmo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Rii eena hechi heechi i spirit kawen yeechi yayato. Kapasek boboyen ye riitaka eecha kiki siikasakech. Yecha yawey yecha riiti akabak eekapa yikiita. Mapo rii kapasek tar. Wowak, apa eeta ma rii eena harapa kapasek tawa. Diita ma riina kapasek otiirega, diita apa tawa ma yenya eechaba harapa kapasek otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas rii ma mima yenya majin batarek, riiti awi sii riiti kumwoy ye yar. Yari ye sabak siitiir. Jisas riina majin woheken eena siitiir. ");
INSERT INTO kmo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Worek, ma por rii eeka tari, rii riina eecha wor: “Na he. Miiti awi, miiti kumwoy ye yawey, miina maji baken sabak siitii kowutu.” ");
INSERT INTO kmo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Worek, Jisas rii awasen eecha wor: “Kapo nama eeji awi? Kapo nama eeji kumwoy?” ");
INSERT INTO kmo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Worek, rii riiti disaipel yenya tapak mukuchichi eecha wor: “Na he! Eeji awi eeji kumwoy ye diitata! ");
INSERT INTO kmo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kata ma rii eeji howuk tawa Apoko riiti inyakak otiitaney, sii eeta eeji awi, eeji kumwoy, eeji mowey. ");
INSERT INTO kmo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Eeta nedii Jisas rii akaman heechi pak ir. I yi rii maji pikiitar. ");
INSERT INTO kmo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nokwapa nokwapa ma mima ye harapa ya yopo wuchi tarek, rii hechi sokwa jabiirek ye yichar. Yicharek, ma mima ye pagiirebak siitiitar. Siitiitarek, rii yenya shiy tawa majik batar. ");
INSERT INTO kmo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rii eecha wor: “Ma por rii tarek, rii sokwa sabak i wit siiken rabor. ");
INSERT INTO kmo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nowok rabotarek, kaw nobok sakar. Sakarek, apo ye yari yecha ar. ");
INSERT INTO kmo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kaw papa heksakarek karakada nosap tarek, sii ameya sokwar. Karakada nosap eeka tarek, eena ameya sokwar. ");
INSERT INTO kmo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sokwarek, ya piri hi uwurek pamu siita eeta reekii siir. Nenyii saka ye yikasakech eena ameya reekii siir. ");
INSERT INTO kmo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Siik kaw yamika tawa poko chik sakar. Sakarek, poko sii sokwa wit pamun gamu poyer. ");
INSERT INTO kmo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Siik kaw nosap kepik eeka sakar. Sakari, sii sokwa siik watar. 100 siik, 60 siik, 30 siik eecha watar.” ");
INSERT INTO kmo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Worek, Jisas rii kawka eecha wor: “Na meeji. Mabiyaka taney, diina na meeji!” ");
INSERT INTO kmo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Worek, disaipel ye Jisas riitak ya riina woher: “Boyewak miita yenya batawey, mii shiy tawa majik bato?” ");
INSERT INTO kmo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Rii awasen eecha wor: “Howuk tawa kigdom yechi veenyi tawa boboyen kwona harek, kwota hecho. Yenya otii mukuchikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma por rii boboyeka eecha tawey, God riipa way kawka riina hanak, riiti boboy harapa tikiita. Ma por rii boboy biish tawey, riitak tar boboy siin awasen yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eena ada shiy tawa majik yenya bato. Yecha hechawey, ye hehar hikasakech. Yecha meejitawey, ye hehar meejikasakech, hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wowak, piirapet Aisaia riita bar maji sii eeta siiken sokwatawey, eecha wocho: God riita eecha wocho: ‘Kwo majin wagateyitawey, kwo eena hikikasakech. Kwokechaweyn, eena saka hehar hechawak. ");
INSERT INTO kmo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Diita ma mima yechi marenoku eeta hapaga bor. Yecha yechi mabiya giir. Yecha yechi miyin dasiipiir. Yecha eena otiinan siiney, Yechi miy eeka hecho. Yechi mabiya eeka meejito. Yechi marenoku eeta opoy hikitu. Yecha eecha otiiney, yepa adak yakiita. Yanak, adapa yenya otii kepi siikiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Wowak, kwota na kwoyawoy hiki ta. Kwoti miy eeta hecho. Kwoti mabiya eeta meejito. ");
INSERT INTO kmo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Diina na hiki ta. Mashi nokwapa nokwapa piirapet ye nokwapa nokwapa God riiti ma mima ye kwota hechawa boboyen heken otiiri, ye saka herek. Kwota maji meejitaweyn, ye eena meejibaken otiiri ye saka meejirek. ");
INSERT INTO kmo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kwota na meeji. Wit siiken rabo tawa maji mun na makebek heechi. ");
INSERT INTO kmo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ma ye God riiti kigdom sawo tawa maji meejichi meejinan siiney, ye eeta nobok saka tawa wit siikega eecha tawa. Eeta Gaba rii ye eeta yechaka chir majin yeechi kayek raboto. ");
INSERT INTO kmo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Papa hek saka tawa wit tawaga diita eecha tawa. Ye sawo tawa majin meejichi kwoya hikitu. ");
INSERT INTO kmo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kwoya hikitawey harapa he ye ikasakech. Eeta majin ameda ye kwoya hikichi abosuchitu. Eecha kaw God riiti majin ameda hikitawey, Jisas riiti hi yechaka eecha tawey, eena kapasek boboy yechak yaney, kikir poy tawa boboy eetaq yechak yanak, yecha eeta majin eeta ameya yapaka chikiita. ");
INSERT INTO kmo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chik saka tawa wit tawaga diita eecha tawa. Diita yikadey ma ye God riiti majin kaw meejitawey, wowey, diita nosapek tawa nomaya tawa boboy sii yawey, ye nosapek tawa yan rukusii tawey, eeta boboy sii ya God riiti majin gamu poyetu. Gamu po tawak, sii sokwa omu wakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nosap kepik sakar wit sii eeta ma ye maji meejichi hiki siitiichichu. Hiki siitiichichawak omu wato. Kaw 100 siik wato. Kaw 60 siik wato. Kaw 30 siik wato.” ");
INSERT INTO kmo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Worek, Jisas rii anadii shiy tawa majin bar. Rii eecha wor: “Howuka tawa God riiti kigdom tawaga eecha tawa. Ma por rii nowo yeechi siik kepin eeka rabotar. ");
INSERT INTO kmo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Rabotarek, niy pochik, eyey ma mima wa hamarek, ow ana pi ma rii yar. Rii yari, rii kuru kapasek eeta nowobak rabobar. Rabobachi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit siik sii sokwa omu watarek, kuru kapasek sii sokwabar. ");
INSERT INTO kmo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","28","Worek, nowo yo otii tar wakasa ma yecha ya nowo man wor: ‘Mii siik kepiban miiti nowok rabor. Diita kuru kapasek kapo siitak taren sokwawa?’ Rii meejichi awasen eecha wor: ‘Ow ana pichawa ma por riita ya otiir.’ Yecha awasen riina eecha woher: ‘Mii kapo eecha hikitu nota i kata kuru kapaseken hono rabok?’ ");
INSERT INTO kmo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Rii awasen eecha wor: ‘Yaho. Sa eepiira eepiira ta. Iipa kwo kuru kapasek hononey, wit kepika eecha honobakiita. Sa eecha ta. ");
INSERT INTO kmo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kwo na heechinak, piir sa eecha tanak, sagii yak otiina nediik sa eecha ta. Komas eeta nedii yanak, ada sagiin yatawa ma yenya wonyak ye mapo kuruwun honachi chenyek jichi hik rabochinyak, uwukiita. Wonyak, wit siik yeechi ye i eeji boboyen heechi tawa akak eeka heechikiita.’” ");
INSERT INTO kmo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas rii anadii shiy tawa majin bar. Rii eecha wor: “Howuk tawa kigdom sii eeta mastet siik tawaga eecha karakada tawa. ");
INSERT INTO kmo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma por rii siiken yeechi rii riiti nowok ye i chinyak, eeta sokwa nowok tawa akar sagiin dogiir poyetu. Dagiir poyechi mega siinak apo ye ya riiti tapak wosii eeka patiito.” ");
INSERT INTO kmo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas rii anadii shiy tawa maji pochin bar. Rii eecha wor: “Howuk tawa digdom sii eeta yis tawaga eecha tawa. Mima pochi sii yis yeechi gey chichawa hiki shebo woy tawa awok rabonak sii piipii taney harapa siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas rii eeta ma mima yenya batari, rii shiy tawa maji bak yenya ba ye itar. Rii maji pochin yenya geenyik kwodii wokasakech. Yaho. Shiy tawa maji bak batar. ");
INSERT INTO kmo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Riita eecha otiitari piirapet riita keyir maji sii eeta geenyik sokwar. Piirapet rii eecha wor: “God rii eecha wocho: ‘Ada yenya batanak, ada yenya shiy tawa maji bak batakiita. Ada yenya maji batanak, ada veenyi tawa boboyen bakiita. Diita majin mashi nosapen tasiichi otiir nedii diita apa nedii ada yenya saka barek.” ");
INSERT INTO kmo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Worek, Jisas rii ma mima yenya heechi i ada wok iyarer. Iyarerek, riiti disaipel ye ya riina eecha woher. “Mii nona nowok sokwa tawa kuru majin na geenyik kwodii wo mukuchi.” ");
INSERT INTO kmo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas rii awasen eecha wor: “Siik kepin rabo tawa ma eeta Ma Yikapwa. ");
INSERT INTO kmo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Eeta nowo eeta diita nosap. Siik kepi sii eeta God riiti ma mima. Kuru sii eeta Gaba riiti ma mima. ");
INSERT INTO kmo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kuru siiken rabo tawa ma rii eeta ow ana pichawa ma, eeta Gaba. Boboy sagii yak tawa nedii eeta hamak tawa nedii. Nowo yo otii tawa ma ye eeta ejel. ");
INSERT INTO kmo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kuruwun honochi chenyek jichi hiki tukuchirek, uwurega, komas hamak tawa nedii eechaba otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eeta nedii Ma Yikapwa rii riiti ejelen heechinak ikiita. Inyak, ya anadii man kapasek yon mukuchichawa man riiti kigdom taweyn yeechi yayakiita. Yayanak, ejel ye anadii eyey yo kapasek otii taweyn yeechi yayabakiita. ");
INSERT INTO kmo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wonyak, ejell yecha yenya hik rabochinyak, uwukiita. Hik uwunak, kapa meejinak pu giiriiga wa giiriigakiita. ");
INSERT INTO kmo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wonyak, eeta nedii God riiti ma mima yepa Apoko riiti kigdomek maba yi yaga eecha hekiita. Wowey, mabiyaka taney, ii na meeji! ");
INSERT INTO kmo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Howuk tawa kigdom sii harapa yan nowok veenyi tarega sii eecha taws. Ma por rii i eeta yan hechi rii yeechi kawka hebar eebak veenyitu. Wowak, rii eena kwoya heechawak i riiti eyey boboy akar man hapoy pakatawak, rii eeta yan harapa yeechi eeta nowon awasen i eena tokoto.” ");
INSERT INTO kmo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Howuk tawa kigdom sii eeta gayetiik kepin tokoken yeshatarega sii eecha taws. ");
INSERT INTO kmo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Rii i pochi kepi henyak, tanak, riipa riiti eyey boboyek tokohamachi diita gayetiiken tokochi yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Howuk tawa kigdom sii mayan rabowak emiyepen hedii tawaga sii eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Maya takiikiisiiwak kiy yesokwa giiriibak yichi keyiboto. Keyibowak, emiyep kepi yen yeechi heebiyak heechiwak, kapasek emiyep yen yeechi kayek roboto. ");
INSERT INTO kmo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Hamak tawa nedii sii yanak, diita eechaba otiikiita. Ejel ye yanak, kapasek tawa ma ye ma kepi yechaka eecha tanak, yen keyibo yeechi hik rabochinyak uwutanak ye pu giiriiga wa giiriigatakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas rii yenya eecha woher: “Kwo kapo ada bawa majin hikitu?” ");
INSERT INTO kmo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ye awasen eecha wor: “Ayo.” Worek, rii yenya eecha wor: “Maji mu diitata: Lon hiki tawa ma riin howuk tawa kigdom disaipel yesokwanak, rii harapa akan siitii kowu tawa maga eecha tawa. Rii riiti aka iyarechi boboy heechi tawa eemek iyarechi mashi boboyen apa tawa boboyen yeechi yayato.” ");
INSERT INTO kmo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas rii diita shiy tawa noman sawo hamarek, rii eeta eemen heechi ");
INSERT INTO kmo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","rii riiti akama siikenek heechi ir. Iyarechi rii yechi lotu akak maji pokii tar. Worek, ye meejichi ye nyegiirabochi eecha woher “Riita harapa hiki tawa boboy rii kapo siitak tarin yar? Mirake otii tawa boboy kapo siitak tarin rii yar? ");
INSERT INTO kmo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Rii kapo kamda riiti yikapwa? Riiti awi kapo eeta Maria siita? Riiti kumwoy ye kapo eeta Jems, Josep, Saimon, Judas. ");
INSERT INTO kmo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Riiti mowey ye diita diika tawa. Diita eyey boboyen rii kapo siitak tarin yar? ");
INSERT INTO kmo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Worek, yecha riina nasowoyer. Worek, Jisas rii yenya eecha wor, “Piirapet rii riiti akama ye riiti magwi ye riina hehar meejikasakech. Akar eemek riiti hin hehar meejito.” ");
INSERT INTO kmo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yecha riina saka hiki siitiichirek eena rii eeta eemen nokwapa nokwapa mirakel otiikasakech. Karakada otiir. ");
INSERT INTO kmo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Eeta nedii harapa aka tabo yima, Herot, Galili nosapen siiti kowu tar ma, rii Jisas riita otiitar boboyen meejir. ");
INSERT INTO kmo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Rii riiti kiyatayetar wakasa ma yenya eecha wor: “Diita ma rii eeta Jon Baptis riita saniyeechi awasen yesokwar. Eena hapaga tawa boboy kata riitaka eecha tawak rii eena ottito.” ");
INSERT INTO kmo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mashi Herot rii Piip riiti mima, Herodias siina yar. Pilip rii Herot riiti kumwoy tar. Jon Baptis rii eena meejichi Herot riina eechaba wochar, “Miita siina yari ii eeta kapasek?” Worek, Herodias sii kapasek otiirek, Herot rii eecha otiirek, Jon riina yeechi poko jichi akak heechitar. ");
INSERT INTO kmo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heechitarek, Herot rii Jon riina sowakwoken otii tari rii Ju ma yenya akiitarek, eena heechitar. Ju ma ye eecha hikitar Jon rii eeta piirapet. ");
INSERT INTO kmo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herot riina yimowur nediin eena riita nokusha atar. Nokusha atarek, Herodias siiti mima yikapwa sii eeta nokwapa nokwapa mima ma yechi miy somak hokwa tosiitar. Worek, Herot rii eena hechi inyaka kwoya hikitar. ");
INSERT INTO kmo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kwoya hikitarek, rii siina eecha wor: “Ada ninya sabo howutu nija ana boboyen wohenyey anapa ninya hakiita!” ");
INSERT INTO kmo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Worek, siiti awi sii siina barek, sii way Herot riina woher: “Jon Baptis riiti maseken na yeecha diita heebiyak woyichi ana ha!” ");
INSERT INTO kmo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Worek, Herot rii meejichi riita inyakapwa hikitar. Worek, riita eyey yar ma mima yechi misomak sabo howurek, eena rii eeta mima siita gigiyarek, eena rii otiichir. ");
INSERT INTO kmo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Worek, poko ji akak Jon riiti masek diigiir. ");
INSERT INTO kmo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Diigiichi heebiyak woyichi yaya yikapwa siina harek sii yeechi ye i nokwapa siina har. ");
INSERT INTO kmo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Worek, Jon riiti disaipel ye yaniga riiti maban yeechi ye i wak chir. Chirek, ye heechi i Jisas riina wor. ");
INSERT INTO kmo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas rii Jon riina otiir majin meejichi, rii eeta eemen heechi jabiir yeechi ma biish tar eemek saniga eeka heechi ir. Irek, ma mima ye meejichi ye akaman heechi kwow nobok riina sumowu kikir ichar. ");
INSERT INTO kmo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Worek, Jisas rii jabiir heechi rii eeka nokwapa nokwapa ma mima tarin hechi rii yenya harapa inyakapwa hikir. Inyakapwa hikichi yechi had otiitar man otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hogo sii nedii yarek, riiti disaipel ye riitak yaniga riina eecha wor: “Hogo siik otiito. Diita eem makasakech. Na wochinak sa ye heechi i akamak aboboyen tokochi ya. ");
INSERT INTO kmo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas rii meejichi eecha wor: “Yecha sa ta. Kwota na yenya aboboy kaw ha.” ");
INSERT INTO kmo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Worek, ye awasen eecha wor: “Nota gey yokotapa emiyep upuruseba eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisas rii meejichi eecha wor: “Eena na yeechi adak yaya.” ");
INSERT INTO kmo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Rii yenya wochirek ye wohejak eeka hey yi ye yir. Worek, rii eeta yokotapa geyen yeechi emiyep upurusen yabachi rii neeren mow hechi rii God riina woshi achi eeta rii geyen reekiir. Reekiichi rii riiti disaipel yenya harek, ye ma mima yenya hamachi hapoy pakar. ");
INSERT INTO kmo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Worek, ye eyey ari, eeta bii diir. Worek, disaipell yekaw yichiri yeechi 12 wasahayak woyichi yichir. ");
INSERT INTO kmo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Worek, 5,000 ma yecha eeka tarek, yecha ar. Mima yikapwa boyega kadiik wonyak. ");
INSERT INTO kmo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Worek, Jisas rii disaipelyenya wochirek, ye jabiirek i mapo akar yepak i ta. Worek, ye heechi icharek, Jisas rii ma mima yen heechirek ye i ye yar. ");
INSERT INTO kmo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Heechi ye yarek, rii kwowuk heechi yo ir. God riina maji baken eena heechi yo ir. ");
INSERT INTO kmo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hogo sii nediik yarek, Jisas rii saniga eeka tar. Eeka tarek, harapa sowa yarek, jabiir sii uku bor ye yo yasakarek gubuk otiitar. Jabiir pa nediik eeka tar. ");
INSERT INTO kmo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Uhadiik otiitar nediik Jisas rii pa hek howu piitii i yechak ichar. Icharek, disaipell ye riina heri, rii pa hebak howu piitii ichar. ");
INSERT INTO kmo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eena heri ye harapa akiitar. Harapa akiitarek, ye uwachi eecha wor: “Ka Gaba yato!” Ye harapa akiitar. ");
INSERT INTO kmo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Worek, Jisas rii yenya kiyatay majin ameya wor: “Dii eeta ada. Opoche akiitanakech!” ");
INSERT INTO kmo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Worek, Pita rii eecha wor: “Harapa Ma, miita siiken yataney, na miita banak ada pa hebak howu piitii yabak.” ");
INSERT INTO kmo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas rii awasen eecha wor: “Na ya.” Worek, Pita rii jabiir heechi pa hek saka piitii Jisas riitak ik otiir. ");
INSERT INTO kmo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Icharek, sowa yarin rii eena hechi akiitarek, pa wok ye iken otiitar. Worek, Pita rii eecha wor: “Ana na yeechi yesokwa!” ");
INSERT INTO kmo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Worek, Jisas rii meejichi rii ameya riina tapak hey yeechi yesokwar. Yesokwachi rii eecha wor: “Miita hiki siitiichichawa boboy sii eeta karakada. Boyewak mii inyaka upurus hikitu?” ");
INSERT INTO kmo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Worek, piiriita jabiirek awasen i yowur. I yowurek sowa yatari sii eeta siir. ");
INSERT INTO kmo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Worek, disaipel ye jabiirek wok tari ye Jisas riiti hin yesokwatar. Ye eecha wor: “Eeta siiken mii eeta God riiti yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Worek, ye jabiirek i akar yepak gayer. Genesaret nosapek eeka i gayer. ");
INSERT INTO kmo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gayerek, eeka tar ma mima ye her rii eeta Jisas. Herek, yecha yechi hak otii tar ma kaw akar akama tarika eecha yeechichi Jisas riitak yayar. ");
INSERT INTO kmo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Worek, yecha yar riina woyasachiyasa her: “Nota miiti saketen neeki henyak kapo kepi siikiita.” Ye eecha otiiri eeta ye kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Worek, Peresi ma kaw ye lon maji pokii tar ma kaw ye Jerusaem akama heechi Jisas riitak yar. ");
INSERT INTO kmo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Yarek, riina woher: “Boyewak miiti disaipel ye noti wayega yecha maji pokii tawa abon nota eena meejitawey ye nasowoyetu? Yecha otii aken otiiawey ye tapa nota nagwa nagwa otii tawaga uku yeetiichi akasakech!” ");
INSERT INTO kmo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas rii yenya eecha wor: “Boyewak kwo kwoti noboban sumowutawey, ii eeta kwo God riiti lon reekiito? ");
INSERT INTO kmo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God rii eecha wor: ‘Kwota na kwoti awi eepi yechi hin yesokwa ta. Ma por rii riiti awi eepi hin kapasek habataney, ii na riina pi sowakwo.’ ");
INSERT INTO kmo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Wowak, kwo maji eecha pokiitu, ma por rii awi eepi piiriina haken sayar tana boboyen taney, riieecha wonyey ‘Dii eeta God riiti,’ wonyey ii ri awi eepi piir siikayek sii. Eecha otiiney, rii riiti awi eepi piiriti hin yesokwakasakech. Diita yikadey boboyen kwota otiitawak, kwo eeta God riiti nobon dagiir poyechi kwoti noboban sumowutu. ");
INSERT INTO kmo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kwo woshepiibak tawa ma! Piirapet Aisaia riita wor maji eeta maji siikenen bar. Riita mashi wori kwona wor: ");
INSERT INTO kmo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God rii eecha wor: ‘Diita ma mima ye eeji hin biish shebo shebo yechi kujak habato. Eecha habatawak yechi inyaka eena ana hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ye maji eecha pokiitu maka otiitaweyn ye eecha wocho eeta God riiti lo. Eecha otiitawak ye eena eeji hin shebo shebo yesokwato.’” ");
INSERT INTO kmo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Worek, Jisas rii ma mima yenya uwarek, ye yarek, rii eecha wor: “Na wagiitey tanak, na hiki ta! ");
INSERT INTO kmo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kata boboyen kujak atawey sii man otii kehakasakech. Kujak tawan ya saya tawey siita man otiiniga kehato.” ");
INSERT INTO kmo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Worek, disaipel yecha riitak yaniga ye eecha wor: “Peresi ma ye miita bawa meejiwey ye inyaka kapasek hikitu. Miita boy kapo hecho? ");
INSERT INTO kmo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas rii awasen eecha wor: “Eyey pamu sokwa tawa boboyen eeji eepi rii saka chicharek, riipa eena honokiita. ");
INSERT INTO kmo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yecha siikayekiisii. Yecha eeta miy dumu tawey, ye eeta akar man nobon mukuchi hechawa ma. Miy dumu tawa ma por rii way anadii miy dumu tawa ma poren nobo mukuchichaney piiriita riitaka riitaka i supuk ye ikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Worek, Pita rii eecha wor: “Miita diitashiy tawa maji mun na nona geenyik kwodii wo.” ");
INSERT INTO kmo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas rii awasen eecha wor: “Kwo boy eechaba ada bawa majin saka hikitawak? ");
INSERT INTO kmo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kwo boy eena hikitu? Eyey boboy ma riiti kujak iyare tawey, sii eeta i ye suguk i mabak sayato. ");
INSERT INTO kmo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wowak, boboy kujak ya sayatawey, inyakak mapo sokwachi sii kujak ya sayatawey, sii eeta man saya otii kehato. ");
INSERT INTO kmo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kapasek hiki tawa boboy sii eeta ma yechi inyakak tawey sayato. Yecha inyakak hikitawey, yecha man pi sowakwoto. Eecha hikitawey, ye nobo mima anemesha rokoto. Ye kapasek boboy otiito. Ye hiyiyato. Ye woshepii maji bato Ye anadii ma yechi hin kapasek habato. ");
INSERT INTO kmo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eeta boboy echa man otii kehato. Wowak, ma ye yechi tapan uku yeetiinan siiney, shebo shebo otii aney, sii yenya otii kehakasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Worek, Jisas rii kata eemek heechi icharek, Taia akama Daidon akamak bana bana tawa nosapek iyarer. ");
INSERT INTO kmo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","iyarerek, Kenan mima pochi sii eeka tari, Jisas riitak yar. Yaniga uwachi eecha wor: “Harapa Ma, Devit riiti neja! Miita ana inyakapwa hikichi eeji yikapwan ba dogiichi. Kapasek spirit siitaka tawey siina kapasek otiito.” ");
INSERT INTO kmo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Worek, Jisas rii siina awasen maji bakasakech. Worek, riiti disaipe Jisas riitak yari ye Jisas riina woher: “Kata mima siina na wochinak sa i. Siita nona sumowutawey, siita wasegey rokoto!” ");
INSERT INTO kmo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Worek, Jisas rii awasen eecha wor: “God riita ana heechirek yari ada yari, nobon somwoy tar Isrel mayechaban mukuchik eena yar.” ");
INSERT INTO kmo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Barek, kata mima sii ya Jisas riiti yatii jumuk yatii bogok piitiichi yir. Yichi sii eecha wor: “Harapa Ma ana kiyatay.” ");
INSERT INTO kmo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas rii Isrel man, anada man shiyi tawa majik siina eecha wor: “Eeta kapasek yikapwak atawa boboy kawen yeechi asan rabochichawak atawey.” ");
INSERT INTO kmo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sii meejichi awasen eecha wor: “Eeta maji siiken. Wowak, apokoriiti atawa cheyek saka tawa aboboyen asa ye eena abato.” ");
INSERT INTO kmo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisas rii siina eecha wor: “Nijihiki siitiichichawa boboy eeta harapa. Nija otiiken gegiyan boboyen God riipa ninya otiichikiita.” Worek, eeta nediibak si mima yikapwa sii kepisiir. ");
INSERT INTO kmo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas rii kata eemen heechi rii Galii pagiireba yepak chishi ichar. Icharek, rii i nedii kwowuk i yo eeka yir. ");
INSERT INTO kmo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yirek, nokwapa nokwapa ma mima ye riitak yaniga yatii kapasek tar ma, miy kiitii tar ma, tapa kapasek tar ma, kuja diimii tar ma, nokwapa nokwapa anadii hak otii tar ma yen yeechi yaya. Jisas riiti yatii jumuk yichir. Yichirek, riita yenay otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Worek, ma mima ye heri, ye nyegerabor. Kuja diimiitar ma ye eeta maji batar. Tapa kapasek tar maeeta kepi siir. Yatii needi tar ma ye eeta chishir. Miy kiitii tar ma ye eeta mey maka her. Ye eena hechi God riiti hin yesokwa tar. ");
INSERT INTO kmo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Worek, Jisas rii riiti disaipel yenya eecha wor: “Ada diita ma mima yenya inyakapwa hikiwa. Yecha yadii diipiira kara diika adaka eecha siir. Siirek, ye aboboyekasakech. Eeta kapasek aboboy biish tanak, ada yenya heechinak inyey, yepakapo i nobok sakakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Worek, riiti disaipe yecha riina woher: “Diita eem makasakech. Nopa siitak tana geyen yeechi yenyapa havakiita?” ");
INSERT INTO kmo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisas rii yenya eecha woher: “Kwo kapo gey shasha heechitu?” Ye awasen eecha wor: “No 7 gey tawak, emiyep por por eecha heechitu.” ");
INSERT INTO kmo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Worek, Jisas rii ma mima yen wochirek, ye nosapek he yi ye ir. ");
INSERT INTO kmo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Worek, rii 7 geyen yeechi emiyepen yabachi, God rii woshiachi rii reekiichi disaipe yenya harek yecha ma mima yenya hapoy pakar. ");
INSERT INTO kmo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hapoy pakarek, ye are, eeta kiki siir. Worek, disaipe ye heechir gey kawen yeechi yayar. Yeechi yayarek, 7 wasahaya kwowuk woyichi yichir. ");
INSERT INTO kmo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ar ma ye eeta 4,000 ma. Mima yikapwa yenya kenyikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Worek, Jisas rii eeta ma mima yenya heechirek, rii i jabiirek ye ichi Magadan nosapek eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Worek, Peresi ma ye Sadyusi ma ye Jisas riitak yar. Jisas riina apo diigii diigii hechaken eena yar. Eena ye riita mirakelen otiiken woher. God riita Jisas riina hechi wohowuken eena wochar. ");
INSERT INTO kmo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Worek, Jisas rii awasen eecha wor: “Hogo nedii ya ye i tawak kwo eecha wocho: ‘Neer eeta nayi hecho. Ii eeta nedii kepi yato.’ ");
INSERT INTO kmo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Niyiga nedii kwo eecha wocho: ‘Neer eeta nayi hechawak kehapa hecho. Ii eeta wayiva nedii yato. Kwo eeta kiki siitawak kwo neeren hechawey, kapo boy boboy sokwato? Kwo eena hecho. Wowak, kwota diita nediik otii tawa tobon hechawey kwo eena sokwak tawa boboyen kwo hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ma mima dii nedii eeta kapasek wey otiitawak, God riina saka hikitawak!” Jisas rii eechaba eecha wor: “Kwota mirakel otiiken wohechawey, ada kwona saka otiiwak. God riita kwon mirakelen hari eetaba. Jona riina otiir mirake sii eetaba.” Worek, Jisas riita yenya heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Disaipel ye pagiirebak icharek, ye geyen abosuchi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Icharek, Jisas rii yenya eecha wor: “Kwota na hehar hecha. Peresi Sadyusi yechi yis eena na opoy sii ta.” ");
INSERT INTO kmo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Worek, ye awasen awasen eecha wor: “No gey saka yeechi yayawak, eena rii eecha wor.” ");
INSERT INTO kmo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas rii yechi majin eena hikichi eecha wor: “Boyewak kwo gey biish sii majin awasen awasen bato? Kwoti hiki siitiichichawa boboy eeta karakada wey! ");
INSERT INTO kmo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kwo boy kapo saka otii hechawak? Kwoboy kapo abosuchir eetaq nediik ada yokotapa geyn reekiichi 5,000 man havari eeta kiki siirek, kaw kapo kwo wasahaya kwow shasha heechir? ");
INSERT INTO kmo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Eeta nediik 7 geyen reekiichi 4,000 ma yenya havari, kapo wasahaya kwow shasha kwo woyichi yichir? Kapo kwo eena abosuchuwa? ");
INSERT INTO kmo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Boyewak kwo saka hikitawak ada saka geyn wochawak? Kwota Peresi Sadyusi yechi yisen eena na ow poy sii ta. ");
INSERT INTO kmo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Worek, ye meejichi hikir Jisas riisaka gey rabotawa yisen wocharek. Rii Peresi Sadyusi yechi pokii tar majin eena wor. ");
INSERT INTO kmo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas rii Sisaria Pilipai akamak bana bana tar nosapek eeka ir. Irek, riiti disaipel yen eecha woher: “Ma mima ye boy Ma Yikapwa riina shecha habato?” ");
INSERT INTO kmo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yecha awasen eecha wor: “Ma kaw ye eecha wocho, Jon Baptis. Ma kaw ye eecha wocho. Ilaija. Anadii ma ye eecha wocho, Jeremaia. Akar ye eecha wocho, piirapet por.” ");
INSERT INTO kmo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jisas rii yenya eecha wor: “Nago. Kwotaba kapo shecha hikitu an nama?” ");
INSERT INTO kmo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Worek, Saimon Pita rii eecha wor: “Mii eeta Kraist, eeta eechaba eechaba tawa God riiti Yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Worek, Jisas rii awasen eecha wor: “Saimon, Jon riiti yikapwa, mii na kwoya woy hiki ta. Diita amutiik maji siiken mak yakasakech. Yaho. Howuk tawa Apoko riitaba miina har. ");
INSERT INTO kmo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eena ada miina wocho: Pita mii eeta hapaga papa. Diita papan ada yeechi yaya eeka otiinak ada eeji eyey ma miman yeechi yayanak, ye ya yopo wuchi yichikiita. Eecha otiinak ha tawa boboy siipa eeta boboyen dagiir poyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ada miina God riiti kigdom nuberejan tagwa tawa boboyen miina hakiita. Miita diita nosapek egesiitawey, ii hevenek siir. Miita diita nosapek heechitawey, ii eeta hevenek heechir.” ");
INSERT INTO kmo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Worek, Jisas rii riiti disaipell yen wor: “Kwo opoche man eecha wochanakech Ada eeta Kraist.” ");
INSERT INTO kmo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Eeta nediik Jisas rii riiti disaipel yenya tasii mukuchichi eecha wor: “Adapa Jerusaem akamak heechi ikiita. Inyak, lotu apoko saba ma ye, opelen otii tawa harapa ma ye, Lon maji pokii tawa ma ye ana kapasek ottinak, ada harapa kapa meejikiita. Yecha ana pi sowakwochi chinyak, ada yadii piiriichar siichi awasen ya sokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita rii meejichi riina tapa tiibok yeechi akar eemek ye ichi Pita rii riina wosawo maji batar. “Harapa Ma, boboy God rii sapa egesii. Diita boboy sii miitak yakasakech!” ");
INSERT INTO kmo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas rii meejichi Pita riina dareboyechi eecha wor: “Gaba, ana na heechi i! Mii mega eecha tawa. Eeji nobon mii dasiipiito. Miita hiki tawa boboyen eena hikitu. Ii eeta God riita hiki tawa boboyekasakech!” ");
INSERT INTO kmo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Worek, Jisas rii riiti disaipel yenya eecha wor: “Ma por rii adaka eecha ik otiiney, rii sapa riiti nobon mayama heechi abosuchiniga rii sapa riina har yon kiya kapa meeji ana sumovu ta. ");
INSERT INTO kmo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ma por rii riiti maban egesiitaney, riipa sii siiken siikiita. Ma por rii riiti maban ana haney, eeji hik haney, riipa maba kepiweyn yeechi riipa eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma por rii diita nosapek tawa eyey boboyen kwoya hechi yaney, riiti maban heechinak saya inyey, rii kapo boyen yakiita? Rii eeta sobo siikiita. Ma sakapa eechaba eechaba tawa boboyek awasen tokokiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ma Yikapwa riipa riiti Apoko riiti hadabas boboyek riiti ejelek eecha yakiita. Yanak, riita eyey ma yecha diita nosapek otii tawa abon eena rii tokokiita. Yo kapasek otiitawey, yen awasen kapasek otiikiita. Yo kepin otiitawey, yen awasen rii yo kepin hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diita na hiki ta: ma kaw ye diika tawey yepa saka hatanak, Ma Yikapwa riipa aka tabo yima tawaga eecha siichi yakiita. Eecha yanak, yepa riina hekiita. ");
INSERT INTO kmo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Worek, yadii 6 hamarek, Jisas rii Pita, Jems, riiti kumwoy, Jon yechaban yeechiniga harapa kwowuk ye yo ye ir. ");
INSERT INTO kmo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yecha Jisas rii hecharek, Jisas riita dareboyer. Riiti misoma yaga eecha her. Riitiriki yama eeta hi apomaga eecha her. ");
INSERT INTO kmo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Worek, disaipel piiriichar ye Moses, Ilaija, piir Jisas riitaka maji batar. ");
INSERT INTO kmo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Worek, Pita rii hechi Jisas riina eecha wor: “Harapa Ma, eeta kepi nota diika tawa. Miita hikinak, nota diika key akan piiriichar otiik. Miin pochi otiichinyak, Moses riin pochi otiichinyak, Ilaija riina pochi otiichikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Riita eecha batarek, neer sii hijagwayap ya yenya gamupoyer. Gamupoyerek, aya pochi neerek uwar. Uwari eecha wor: “Dii eeta eeji Yikapwa. Ada rina rukusiito. Riita otii tawa abon ada kwoya hecho. Kwota na riina meeji ta!” ");
INSERT INTO kmo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Worek, disaipel ye ayan meejichi ye harapa akiitar. Akiitarek, eena ye saka nosapek misoma gamuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yicharek, Jisas rii yaniga yenya ho neekichi eecha wor: “Na sokwa. Opoche akiitanakech.” ");
INSERT INTO kmo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Worek, ye mey maka heri, Jisas riitaban her. ");
INSERT INTO kmo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Worek, ye kwow heechi ya sakarek, Jisas rii yenya eechawor: “Kwota her boboyen kwo opoche anadii man sawotanakech. Ma Yikapwa riina yeechi yesokwanak eeta nediik napa sawo ye i ta.” ");
INSERT INTO kmo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Worek, disaipel ye Jisas riina woher: “Boyewak lo maji pokii tawa ma ye eecha wocho: Kraist rii yak otiinak, Ilaija rii sapa mapo ya?” ");
INSERT INTO kmo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas rii awasen eecha wor: “Iaija rii mapo yato. Yatawak, rii eyey boboyen sayarechikiita. ");
INSERT INTO kmo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wowak, ada kwona wocho: Ilaija rii eeta yar. Yarek, ma mima yecha riina saka hikitawak. Ye yechi nobon sumowuniga, ye yechi hikitarin riina otiir. Ye eecha riina otiirega, ye Ma Yikapwa riina eechaba otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Worek, disaipel ye meejichi ye eecha hikir Jisas rii Jon Baptis riina wor. ");
INSERT INTO kmo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yecha i ma mima yechak i yarek, ma por rii Jisas riitak yar. Yari rii yatii bogok putiichi he yir. ");
INSERT INTO kmo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","He yichi eecha wor: “Harapa Ma, miita na eeji yikapwan inyakapwa hikichi na ba dagiichi! Rii beyi tawak, kuja sogwiyabak ya. Tawak i hik yow tawak, pak i i ye itu. ");
INSERT INTO kmo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eena ada riina yeechi miiti disaipel yechak ye iri yecha kiki siikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Worek, Jisas rii awasen eecha wor: “Kwota kapasek hiki tawak, saka hikisiitiichichawak! Kapo shasha yadii ada kwotaka eecha siikiita? Kapo yadii shasha diita kwoti nomoyatawa boboyen ada kiyatakiita? Yikapwa riin adak na ya ya!” ");
INSERT INTO kmo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Worek, Jisas rii kapasek spiriten wochirek, heechi irek, eeta yikapwa ameya eeta kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Worek, disaipel ye ya Jisas riina veenyichi woher: “Boyewak nota saka kiki sowak, kata spiriten yeechi rabotawak?” ");
INSERT INTO kmo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jisas rii awasen yenya eecha wor: “Kwoti hiki siitiichichawa boboy sii eeta saka kiki siikiitawak. Diina na hiki ta. Kwoti hiki siitiichichawa boboy sii mastet siik tawaga eecha taney, kwo diita kwowun wochinak, ‘Sii na akar yepak i!’ Wonyey, siita ikiita! Wonyey, yo pochin kwo otii somoyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Eyey disaipel ye Galili nosapek ya yopo wuchi yicharek, Jisas yenya eecha wor: “Ma Yikapwa riina ma yechi tapak howu hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hanak, yecha riina pi sowakwokiita. Sowakwonak, rii yadii piiriichar siinak, God riita riina otii saniyeechi yesokwakiita.” Worek, disaipel yechi bii eena harapa nomoyatar. ");
INSERT INTO kmo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas rii riiti disaipel yechada Kapanean akamak iyarerek, lotu aka takis yan yatawa ma ye ya Pita riina woher: “Kapo miiti Tisa rii lotu aka takis yan hato, kapo saka hatawak?” ");
INSERT INTO kmo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita rii awasen eecha wor: “Ayo. Rii hato.” Worek, Pita rii akak iyarer. Iyarerek, Jisas rii mapo eecha wor: “Saimon, mii shecha hikitu? Kapo boy nama diita nosapen aka tabo yichawa ma yenya takis yan hato? Kapo riiti yikapwa yenya hato kapo anadii man hato?” ");
INSERT INTO kmo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita riita awasen eecha wor: “Anadii ma yechaba hato.” Worek, Jisas rii awasen eecha wor: “Miita bawa maji eecha wocho: Yikapwa ye takis yan tokokasakech. ");
INSERT INTO kmo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Worek, eena opoche nota ma mima yenya inyaka kwotay boboyen otiitanakech. Wowak, eena na i pak por rabo. Rabonak, emiyep poren yanak, riiti kujan na tagwachi ya pochi eeka taweyn na ya. Eeta sichi lotu aka takis ya kiki siikiita. Na yeechi yaya sichi takis yan yenya na ha ta.” ");
INSERT INTO kmo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Eeta nedii disaipel ye Jisas riitak yari, riina woher: “Kapo nama howuk tawa kigdomek harapa siikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Worek, Jisas rii karakada yikapwan uwarek, ya yechi nediik siitiirek, rii eecha wor: “Na hiki ta! Kwota dareboyechi diita yikapwaga siinan siiney, kwopa howuk trawa God riiti kigdom iyarekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kata ma por rii riiti hin mayama dagiir poyechi kata yikapwaga eecha siiney, riipa God riiti howuk tawa kigdom harapa ma siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kata ma rii diita yikadey yikapwan eeji hik yaney, rii ana eechaba yato. ");
INSERT INTO kmo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ana hiki siitiichichawa karakada yikapwan ada bato. Ma por rii otiichinyak, karakada yikapwa por rii ana magiirechichi heechi inyey, harapa kapasek boboy eeta ma riitak yakiita. Eeta ma riiti borowagek papa kiitiichi heechinak paka yeyiney, eeta boboy sii eeta kubuchey kapasek boboy. ");
INSERT INTO kmo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eeta kapasek wey boboy kaw diita nosapek tawey, sii otiichinyak ma ye dareboyechi kapasek nobok ichu. Eeta yikadey kapasek boboyen otiitakiita. Wowak, ma por rii diita kapasek boboyen otiichinyak harapa kapasek boboy riitak yakiita! ");
INSERT INTO kmo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Miiti yatii tapa sii miina otiichinyak kapasek boboyeka siiney, ii na yatii tapa, tiimiichi rabo. Miita eechaba eechaba tawa eemek iyarenak, miiti yatii tapa pochi tnan siiney, sii eeta kepi. Miiti yatii tapan egesiinak, miina eechaba eechaba tawa hik rabochinyak, uwuney, ii eeta kapasek wey. ");
INSERT INTO kmo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Miiti miy sii miina otiichinyak kapasek boboyeka eecha sakaney, ii na miyin horechi na kayek rabo. Eeta kepi miy podat taney, ii miipa eechaba eechaba tawa eemek iyarekiita. Eeta kapasek miita miy upurus taney, iipa miina hiki rabochinyak uwukiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Opoche kwo eena karakada ma miman wosowoy tanakech. Ada kwona wocho: yechi ejel hevenek tawey ye eeji Apoko misomak bana bana tawa. ");
INSERT INTO kmo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ma Yikapwa rii wurubu yarebor man eena yesokwa yichiken yar.) ");
INSERT INTO kmo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kwo boyen hikitu? Ma por rii tawak, riiti 100 tawa sipsip por wurubu yareboney, riipa kapo checha otiikiita? Riipa 99 sipsip karakada nedii kwowuk heechinak, poren yesha hek ikiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ada kwona wocho riipa i henyak, inyaka ri kwoya hikitakiita. Wowak, 99 sipsip ye anadii tawey, rii yechaban hikitakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eena havenek tawa Apoko rii por wurubu yarebonan yuyato. ");
INSERT INTO kmo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Miiti yaka kumwoy rii miina kapasek tawa boboy otiiney, ii na miita riiti kapasek boboyen riina na mukuchi. Kicha na veenyichi maji ba. Wonyak, riita miina meejichi otiiney, wowey, ii eeta miiti kumwoyen awasen yato. ");
INSERT INTO kmo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mashi keyir maji sii eecha wocho: Miita inyak, riita miiti majin meejinan siiney, mii ii na ma upurus por yeechi eecha i. Eecha otiiney, eekapa ma upurus por eecha otiineyek kwodii wokiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kwota inyak, rii kwona meejinan siiney, ii na eyey ya yapa wuchi yichawa ma yenya na sawo. Sawonak, rii ya yopo wuchi yichawa man meejinan siiney, ii na riina eecha hiki rii eeta biish shebo shebo tawa ma, rii eeta kapasek takis yan yatawa ma. ");
INSERT INTO kmo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ada kwona eyey wocho: Kwota diita nosapek tawa eyey boboyen kwo anachekiitawa, hevenek eechaba anachekiikiita. Kwota diita nosapek tawak eyey boboyen kwo heechi tawaga hevenek eechaba heechitakiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ada kwona kawka wocho: Ma upurus piir nokwapa apoko podatega hiki tawey, kwo God riina wohechawey, hevenek tawa Apoko riipa kwona otiichichikiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ma upurus piiriichar ana meejichi ya podat akamak yopo wuchi yinyak anapa eeka yichi nediik takiita.” ");
INSERT INTO kmo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Worek, Pita rii Jisas riitak ya Jisasriina eecha wor: “Harapa Ma kapo shasha nedii eeji yaka kumwoy ana kapasek boboyen otiichinyey, ana riita otiina boboyen shasha nedii ada abosuchikiita! Kapo 7 nedii.” ");
INSERT INTO kmo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas rii awasen eecha wor: “Yaho, 7 nedii otiikasakech. Eechaba eechaba nedii na abosuchi ta. ");
INSERT INTO kmo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wonyak, hevenek tawa kigdom sii eeka aka tabo yimaga eecha tawa. Rii riiti wakasa ma yecha sobo yar yan eena he kenyiken yar. ");
INSERT INTO kmo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tasiichi kenyiri sobo yar ma poren yayari, rii harapa ya mayakan sobo yar. ");
INSERT INTO kmo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Worek, riiti ya karakada tarek, eena saka awasen harek. Worek, harapa ma rii eecha wor: ‘Anadii ma riita diita ma riina tokokiita. Riiti mima yikapwaka eecha eyey tokobakiita. Eecha otiiney, riipa sobo yar yan awasen hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Worek, wakasa ma rii yatii jumuk saka bogok piitiichi yichi rii woyasachiyasa woher: ‘Na ana inyakapwa hikichi na kowutanak ada awasen eyey yan miina hakiita!’ ");
INSERT INTO kmo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Worek, riiti harapa ma rii riina inyakapwa hikichi riita sobo yar yan heechi riina wochirek ir. ");
INSERT INTO kmo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Worek, rii heechi i riita yo meshi otiitarek, yan kaw har ma riina jawor. Jaworek, rii riiti borowagiik howu neekiirek, rii hegahakasakech. Rii riina eecha wor: ‘Ada miina har yan napa ameya awasen ha!’ ");
INSERT INTO kmo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Worek, riiti yo meshi otiitar ma rii yatii jumuk saka bogok piitiichi yichi rii woyasachiyasa woher: ‘Na ana inyakapwa hikichi na kowutanak ada awasen eeta yan eyey miina hakiita!’ ");
INSERT INTO kmo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Rii meejichi eena sakaotiirek. Yaho. Rii otiichirek, i pokoji akak rabor. Rii yan awasen hanak, een riin heechinak ik. ");
INSERT INTO kmo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Worek, anadii yo meshi otiitar ma ye eena hechi ye inyaka kisokwachi harapa ma riitak i riina eyey otiir boboyen eena wor. ");
INSERT INTO kmo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Worek, harapa ma rii meejichi eeta wakasa ma riin wo yayar. Wo yayachi rii riina eecha wor: ‘Mii eeta kapasek wakasa ma siiken wey! Miita ana woherek, ada miita sobo eyey yar yan awasen ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ada miin inyakapwa hikichi ba dagiichirega miiti yo meshi otiitar man na eechaba inyakapwa hikichi na ba dagiichi.’ ");
INSERT INTO kmo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Worek, harapa ma rii inyaka kwotayichi rii riina otiichirek, rii pokojiakak rabochirek ir. Kapa meejiken eena heechirek ir. Riita eeta yan awasen hanak eena riina heechinak ik.” ");
INSERT INTO kmo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Worek, Jisas rii kawka eecha wor: “Kwota eyey kwoti inyaka wopuk kwoti yaka kumwoy yenya ba dagiichinyan siiney, eeji hevenek tawa Apokoriipa kawona eechaba saka ba dagiichikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas rii diita majin ba hamarek, rii Gallili nosapek heechi rii Judia nosapek ir. Jodan pa giiriiba yepak eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Rii icharek, nokwapa nokwapa ma mima ye riina sumowu ibatar. Ibatarek, Jisas rii hak otiitar ma yenya otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Worek, Peresi ma kaw ye ya Jisas riina apo diigii diigiiheken ya otii hechi eecha woher: “Bwimey noboknoti lon eeta heechiwak, ma rii riiti miman sayichiwak ichu? Siita bwimey kapasek yon otiitawak, een siina sayichichawak ichu?” ");
INSERT INTO kmo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas rii awasen eecha wor: “Kwo kapo God riiti majin saka kenyi herek? Ii eeta wocho: ‘Mashi mashi tasiir nediik eyey boboyen otii hamarek God rii man otiir. Ma mimaka eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God rii eecha wor: ‘Eena ma rii riiti awi eepin heechi riiti mimaka eecha apoyeto. Apoyewak piir eeta podabak sowa.’ ");
INSERT INTO kmo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eena piiriita saniga saniga takiisakech. Podatebak tawa. Wowak, eena God riita ediir boboyen ma opoche reekiitanakech.” ");
INSERT INTO kmo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Worek, Peresi ma ye riina woher: “Eecha tawey, boyewak Moses rii eecha wor: ‘Ma mima sayeken otiiney, ma rii jeyn sa keyichi siina hanak, sa heechinak i?” ");
INSERT INTO kmo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas rii awasen eecha wor: “Kwoti marenoku hapaga tawak, eena Moses rii kwona heechirek, twokwoti miman sayechichawak ichu. Wowak, mashi he nedii diita yikadey nobo sii takasakech. ");
INSERT INTO kmo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wowak, ada kwona wocho, mima sii nobo anemesherokonan biish tanak, ma rii siina saye heechinak inyey, wonyak, eeta ma rii akar miman yaney, ii eeta God riiti lon rii nediik reekiito.” ");
INSERT INTO kmo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wowak, riiti disaipel ye riina eecha wor: “God riiti on eecha wochawey, maka mimaka podatebaktawey, eeta kepi opoche mima yatanakech.” ");
INSERT INTO kmo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas rii awasen eecha wor: “Eyey ma mima ye diita mima ya majin kiki siinak, yakasakech. God riita kata ma yenya boboy kaw hana ma yechaba kata boboyen yeechi otiito. ");
INSERT INTO kmo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Diita yikadey ma ye miman yakasakech. Ma kaw yimowurek, eeka eecha siir. Worek anadii ma ya ya yenya kapasek otiitarek, yecha miman saka yarek, eena ye eecha sirr. Anadii ma ye miman yanan siiri, ye howuk tawa kigdom yon otiitawak, eena yakasakech. Eeta ma ye diita majin kiki siinak, yaken otiiney, eena na yeechi hiki ta. ");
INSERT INTO kmo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma kaw ye karakada yikapwan yeechi Jisas riitak ye ir. Ye irek, Jisas riiti tapan yenya howu neekichi Apoko riina wohechar. Worek, disaipel ye eena hechi yenya ow majin bar. ");
INSERT INTO kmo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Worek, Jisas rii eecha wor: “Kwota na heechinak, yikapwa ye sa adak ya. Kwo opoche anacheketanakech. Hevenek tawa kigdom sii jecha tawa ma yechi.” ");
INSERT INTO kmo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Worek, rii riiti tapa howu neekichi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Worek, ma por rii Jisas riitak yaniga riina eecha wor: “Tisa, kapo boy boboy kepik ada otiinak, anapa eechaba eechaba siikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Worek, Jisas rii awasen eecha wor: “Boyewak mii boboy kepin ana wohecho? Boboy Podat rii eeta kepi boboy. Miita eechaba eechaba siiken gegiyaney, mii God riiti yokotapa yokotapa majin na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rii awasen woher: “Ii bwimey majin?” Worek, Jisas rii eecha wor: “Opoche ma pi sowakwotanakech. Nobo miman anemesherokotanakech. Hiy yatanakech. Woshepii maji batanakech. ");
INSERT INTO kmo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Awi eepi piiriiti hinna yesokwa ta. Miita mayama rukusiitawabaga anadii man na eechaba rukusii ta.” ");
INSERT INTO kmo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hadiiye ma rii awasen eecha wor: “Ada diita eyey miita bawa majin sumowutar. Akar boyen boboyen ada otii somoyeto?” ");
INSERT INTO kmo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas rii meejichi eecha wor: “Miita sokwa kepi siiken gegiyaney, miita na i. Miiti eyey boboyen na yeechi ye i yak toko. Tokonak, kiiriisiiposii man eeta eyey yan napa ha. Hanak, komas miita hevenek tawa harapa yan yakiita. Wonyak, na ya ana sumowu.” ");
INSERT INTO kmo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Worek, hadiiye ma rii meejichi riiti misomak eyipiichi inyaka nomoyeechi heechi ir. Eeta ma rii riiti ya harapa tarek, rii eena eecha otiichi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Worek, Jisas rii riiti disaipel yenya eecha wor: “Ada kwona wocho, harapa yak tawa ma ye God riiti kigdom iyarek otiiney, harapa yo otiichi iyarekiita. ");
INSERT INTO kmo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ada maji pochin kawka bak, kamel sii riki kapa tawa wowi siiti supuk iyarek otiiney, yo ameda otiiniga iyarekiita. Yaka tawa ma rii eeta God riiti kigdom eechaba iyarek otiiney hisaw yon otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Worek, disaipel ye eena meejichi henebarabochi eecha woher: “Eecha tawey, kapo naman yesokwa yichikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas rii yenya miyik hechi eecha woher: “Ma ye saka kiki siikiitawak. God riitaba saniga eyey boboyen otii kiki siitakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Worek, Pita rii eecha wor: “Na he. Nota noti eyey boboyen heechi miina sumowubato. Sumowubatawey, nopa kapo boy boboyen yakiita?” ");
INSERT INTO kmo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas rii awasen eecha wor: “Ada kwona siiken wocho, hadabas kepi nedii yanak, Ma Yikapwa riiriiti harapa tiikiirek eeka yinyak, ana sumowu tawa ma kwo 12 harapa aka tabo yima yechi tiikiirek eeka yibakiita. Yibatanak, kwo eechaba Isre magwi 12 yenya anasabatakiita. ");
INSERT INTO kmo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kata ma ye eeji hik yechi akan, yechi yaka kumwoyen, yechi moweyen, yechi awi eepin, yechi yikapwan, yechinowo sagiin eeji hibak heechiyega, ii yepa waga 100 hadabas boboy kepin yakiita. Ye waga eechaba eechaba tawa. ");
INSERT INTO kmo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wowak, nokwapa nokwapa mapo tawa ma yepa i komasenak, komas tawa ma yepa way i mapokiita. ");
INSERT INTO kmo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“God riiti howuk tawa kigdom jecha tawa: Wain nowo ma rii tawa. Tawak, niyegak rii nowo yootiichi man i yeechi yayaken eena ir. ");
INSERT INTO kmo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Irek, yeechi yaya ha yan woherek yecha eeta dola ya pochin wohowor. Wohoworek, riita yenya wochirek ye nowok otiik ir. ");
INSERT INTO kmo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ye irek, rii niyega nediik rii awa ba eemek ir. Irek, rii her ma kaw siitii ye i tarek. ");
INSERT INTO kmo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Worek, rii hechi yenya eecha wor: ‘Kwota na i eeji wain nowo yon otiinak, ada kwona ya kepin hakiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Worek, ye meejichi yo otiiken ir. Worek, nowo ma rii yadii nedii hogo nediik eechaba otiir. ");
INSERT INTO kmo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Worek, yo hamak otiitar nediik rii way awa ba eemek kawka ichi ma kaw ye siitii ye i tarek, rii way her. Herek, rii eecha woher: ‘Boyewak kwo eechaba eechaba diibak ya siitiito?’ ");
INSERT INTO kmo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ye awasen eecha wor: ‘Nona yo ha makasakech. No eena siitii ye itu.’ Nowo ma rii meejichi eecha wor: ‘Na i. Eeji nowo yon otii.’ ");
INSERT INTO kmo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Worek, hogo ya ye nediik nowo ma rii riiti siitii kowu tar ma riina eecha wor: ‘Na yo otii tawa man uwanak sa ya yechi yan ya. Ada komas nobo yar ma yechak na tasiichi yan ha. Ada mapo yar ye sapa ya komas ya.’ ");
INSERT INTO kmo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Wkorek, yo hamak otii tar nediik woher ma ye doa ya pochin yar. ");
INSERT INTO kmo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Worek, akar mapo yar ma ye yaniga eecha hikitar nopa ya harapa yakiita. Wori, yaho. Yecha doa ya pochin yabar. ");
INSERT INTO kmo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ye yan eecha yeechi nowo ma riin ow maji bar. ");
INSERT INTO kmo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ye riina eecha wor: ‘Diita ma yen miita yo hama nediik woheri mii yenya noti yaga yenya eecha har. Ye saka harapa yon otiitarek nota harapa yon ya geenyik otiitar!’ ");
INSERT INTO kmo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nowo ma rii ma podaren awasen eecha wor: ‘Ada miina kapasek otiikasakech. Ada miina eecha wor: Miita yadii pochi yo otiiney dola ya pochin ada miina hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kwota eena wohowor. Wowak, miiti yan na yeechi i. Ya miina adahawa baga komas yar ma yen ada eechaba haken hikitu. ");
INSERT INTO kmo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ii eeji ya ada keena eecha hak wonyey, anapa keena hakiita. Ada eeji yan sobo hataney, mii kapo eena hechi inyaka mi kwotayet.’” Jisasrii kowka eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Wowak, eechaba siikiita. Komas yari yepa i maponak, mapo yari, yepa i komasekiita.” ");
INSERT INTO kmo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas rii Jerusaem akamak iyarerek ottirek, rii riiti 12 disaipe yeechi yaya yechaban veenyichi i sawor. ");
INSERT INTO kmo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Rii yenya eecha wor: “Ana na meeji. Nota Jerusalem akamak ichu. Iyarenak, Ma Yikapwa riina opeen otii tawa harapa ma lon maji poko tawa ma yechi tapak how hakiita. How hanak, riina pi sowakwo haken eena anasakiita. ");
INSERT INTO kmo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ye anasachi shebo shebo tawa ma yechi tapak how hakiita. Howu hanak, ye riina wosoboy wokwoyachi kubu pichi mek ji siitiichikiita. Wonyak, yadii piiriichar siichi rii awasen ya saniyeechi sokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eeta nediik Sebedi riiti yikapwa piiriiti awi sii siiti yikapwa piiriitaka Jisas riitak ya he gamuchi otii boboyen riina woher. ");
INSERT INTO kmo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas riita hechi siina woher: “Boyak yawa?” Sii eecha wor: “Eena nediik miita aka tabo yima siinak, eeji yikapwa piir por miiti mama yepak yinyak por yeeji yepak yinyak, piiriita harapa aka tabo yimaga siibakiita. ");
INSERT INTO kmo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Worek, Jisas rii awasen siina eecha wor: “Nija ana wohewey, kwosaka otii hechawak. Ki boy kapo kikisiikiita ada kiya tawa nomoya tawa boboyen kipa boy kiyabakiita?” Piir meejichi awasen eecha wor: “Sicha eeta kiki sowa.” ");
INSERT INTO kmo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Worek, Jisas rii awasen eecha wor: “Ayo. Kicha ada nomoyo tawa boboyen kiyabakiita. Wowey, namapa eeji mama yepak yin6yak yeeji yepak yiney eeta yo eeji yokasakech. Diita tiikiir ma kawen eeji Apoko riita sayarechir. Eeta riiti yo.” ");
INSERT INTO kmo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Worek, anadii 10 disaipel ye eena meejirek yaka kumwoy piiriina kwotayer. ");
INSERT INTO kmo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Worek, Jisas rii yenya uwa yaya yopowuchi yir. Yirek, rii eecha wor: Kwo hikitu diita nosapek tawa aka tabo yima ye yechi ma mima yenya siitii kowu tawey, ye eeta yenya dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wowak, kwo jecha otii tawa abon opoche otiitanakech. Ma por rii kwotaka tawey, harapa siiken gegiyaney, rii sapa anadii man kiyatay tawa maga eecha sii. ");
INSERT INTO kmo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma por rii mapo ima siiken otiiney, rii sapa yo otii wakasa maga eecha sii. ");
INSERT INTO kmo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ma Yikapwa rii yarik saka riina mak kiyatayeken yarek. Rii yari, rii anadii man kiyatayenak, rukusiitaken eena yar. Rii riiti meseken harek, nokwapa nokwapa ma miman tokochiken eena yar. Riita eecha otii tawaga kwo napa eechaba otiiba ta.” ");
INSERT INTO kmo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yecha Jeriko akaman heechi iken otiitarek nokwapa nokwapa mima ma ye Jisas riina sumowutar. ");
INSERT INTO kmo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sumowu icharek, miy kiitii ma piir nobo giirebak eeka yichar. Yicharek, piir meejir Jisas rii yarin, piir uwachi eecha wor: “Devit riiti neja miita sinya na inyakapwa hikichi ba diigiichi! ");
INSERT INTO kmo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma mima ye meejichi ye piiriina anachekechi ow maji bar. Worek, piiriita harapa uwachi eecha wor: Devit riiti neja! Miita sinya na inyakapwa hikichi ba diigiichi!” ");
INSERT INTO kmo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Worek, Jisas rii eeka siitiichi piiriina uwachi eecha wor: “Boyen ada kinya otiichiken ki gegiyato?” ");
INSERT INTO kmo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Piir eecha wor: “Harapa Ma, sicha gegiyato miita shichi miyin na tagwachi!” ");
INSERT INTO kmo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Worek, Jisas rii piiriina inyakapwa hikichi piiriiti miyin rii howu neekir. Howu neekirek, piir ameya miy kepi mey maka her. Worek, piir riina sumowutar. ");
INSERT INTO kmo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yecha Jerusalem akamak iyarerek, ye Betpasi akamak mapo iyarer. Betpasi Oliv kkwow bana bana tar. Ye eeka tarek, Jisas rii disaipel upurusen heechirek, ik otiirek ");
INSERT INTO kmo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","piiriina eecha wor: Kicha ana diika heechi dii yapak tawa akaman na i. Kicha iyarenak, napa he donki nokwapa siina yikapwaka eecha pokokkushi siitiichichu. Wonyey, napa heemachi yeechi ana yaya. ");
INSERT INTO kmo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ki eecha otiinak, ma por rii kichaka maji baney, riina napa eecha wo: ‘Harapa Ma riita dopotawak, eena shicha yeechi ye iken shi eena yawa.’ Kicha banak, riipa ameya heechikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Worek, eecha otiirek, mashi piirapet bar maji sii diita nediik siiken sokwatarek, eena eecha otiitar. Piirapet rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion akamak tar ma mima yenya na sawo. ‘Na he! Kwoti aka tabo yima kwotak yato. Rii eshar otiitawak, riita donki magiirek yo yichi yato. Rii donki yi magiirek yo yichi yato!” ");
INSERT INTO kmo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Disaipel piir Jisas riita bar maji meejichi piir i eechaba otiir. ");
INSERT INTO kmo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Piir i donki yi nokwapaka eecha yeechi yayar. Yayarek, worek, yecha yechi saketen yeechi donki magiirek ye yo yichir. Ye yo yichirek Jisas rii yo eeka yir. ");
INSERT INTO kmo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Worek, nokwapa nokwapa ma mima ye yechi saket yeechi nobok yichi ir. Worek, kaw ye me tapan reekiichi nobok seechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jisas rii icharek, ma mima ye kaw mapo tarek, kaw komas tarek sumo eecha icharek ye uwar: “Devit riiti neja riiti hin na yesokwa ta. Diita ma rii God riiti hik yatawey, God riita riina rukusiito! God riiti hin na yesokwaba ta!” ");
INSERT INTO kmo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas rii Jerusaem akamak iyarerek eeka tar ma mima ye riina hechi nyegiirabochi eecha wor: “Dii kapo nama?” ");
INSERT INTO kmo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma mima ye awasen eecha wor: “Dii eeta piirapet Jisas, Gaii nosap Nasaret akamak tar ma!” ");
INSERT INTO kmo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Worek, Jisas rii harapa otu akak iyar ya mani tokotar ma boboyen tokotar ma yenya pi heechirek, ye saya ir. Rii ya mani tokotar chey otiichirek sakar. Nurer tokotar ma yechi tiikiir eechaba otiichirek sakabar. ");
INSERT INTO kmo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Eecha otiichi rii eecha wor: “Mashi keyir maji God riita eecha wor: ‘Eeji aka eecha habato, God riina maji ba tawa aka. Wowak, kwo hiyiya tawa ma yichi akaga eecha veenyichi otiito!” ");
INSERT INTO kmo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas rii harapa otu aka wok tarek miy kiitii tar ma kaw yatii neeki tar ma yecha riitak yarek, rii yenya otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Rii yo kepin otiitarek, opel otii tar harapa ma lon maji pokii tar harapa ma ye eena hechi yechi inyaka kwotayer. Ye eechaba her, yikapwa ye harapa otu akak eecha uwar, “Devit riiti neja riiti hin na yesokwa ta.” ");
INSERT INTO kmo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yecha heri ye kwotayechi Jisas riina eecha wor: “Yecha wochawey, mii boy meejito?” Jisas rii awasen eecha wor: “Ada hehar meejito! Kwo boy kapo saka kenyitarek, ‘God riita yikapwan yikapwa baregiin maji pokiitarek, ye eena God riiti hin hehar yesokwato?’ ");
INSERT INTO kmo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Worek, Jisas rii yenya heechi rii Betani akamak ir. Irek, niy pochi siir. ");
INSERT INTO kmo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Niyega nediik Jisas rii Jerusalem akamak awasen icharek, nobokrii eecha har. ");
INSERT INTO kmo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eecha harek, rii pek men nobok bana bana siitiitarek, rii i hechi omu watanakech. Rii hipurek kiipiikabak tar. Worek, eena rii pek men eecha wor: “Mii siik kawka wakasakech!” Worek, eeta me ameya reekiisiir. ");
INSERT INTO kmo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Worek, disaipel ye eena hechi nyegiirabochi woher: “Kata me boyewak eeta ameya reekiisowa?” ");
INSERT INTO kmo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas rii awasen eecha wor: “Kwo na hiki ta! Ameda opoche hiki siitiichicha. Hiki siitiichichaney, ada pik men otiiwabaga kwo eechaba otiikiita. Kwo diita kwowun wochanak sokwa somakwotii tawa pak ye inyey, iipa mayama eecha otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kwo hiki siitiichichaney, boboyen yaken God riina wohenyey kwopa yakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas rii harapaotu akak iyarechi ma mima yenya maji pokii tar. Maji pokii tarek, opelen otii tar harapa ma ye Ju ma yechi apoko saba ma ye riitak yar. Yarek, riina woher: “Bwimey jebwa miitaka tawak, mii diita boboyen otiito? Siitii kowu boboy miin nama har?” ");
INSERT INTO kmo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas rii awasen eecha wor: Ada way eechaba kwona maji pochin wohek. Kwota ana maji kepin awasen baney, ada awasen adaka tawa jebwak yo otiitaweyn kwona bak. ");
INSERT INTO kmo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon riita man uku yeetiichichari, eeta boboy kapo siitak yar? Kapo God riiti, kapo ma yechi?” Worek, yecha awasen maji batar. Ye eecha wochar: “Nota eecha wonyey, ‘God riita har,’ riipa echa wokiita: ‘Boyewak kwo riina saka hikisiitiichirek?’ ");
INSERT INTO kmo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nota eecha wonyey, ‘Mak har,’ ii napa ma mima yenya akii ta. Yecha eecha hiki siitiichichar Jon rii eeta piirapet.” ");
INSERT INTO kmo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Worek, eena yecha Jisas riina eecha wor: “No saka heechawak.” Jisas rii awasen yenya eecha wor: “An eechaba wokasakech boy yikadey siitii kow tawa boboy tawak ada diita yon otiito.” ");
INSERT INTO kmo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nagwo, kwo shecha hikitu? Ma por rii tarek, riiti yikapwa upurus tar. Tarek, rii yaka yikapwa riitak ir. Iri, rii riina eecha wor: ‘Yikapwa, apa miita na i eeji wain nowon yo otii ta.’ ");
INSERT INTO kmo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Rii awasen eecha wor: ‘Ada yuyato.’ Worek ri inyaka komas dareboyechi rii way yo otiiken ir. ");
INSERT INTO kmo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Worek, apoko rii way i kumwoy riina eechaba wor. Worek, kumwoy rii awasen eecha wor: ‘Ayo, apoko. Ada ik.’ Wori, rii ikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wowak, yikapwa; upurus piir tarek, kapo nama apokon riiti inyakak otiitar?” Ye awasen eecha wor: “Yaka riita mayishichar.” Jisas rii Ju ma yenya eecha wor: “Ada kwona wocho: Takis yan yak tawa ma ye nobo eechaba eechaba anemesheroko tawa kapasek mima ye God riiti kigdomek kwona mapokiita. ");
INSERT INTO kmo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon Baptis rii yarek, rii kwon nagwa nagwa ichawa nobon mukuchichar. Mukuchichari, kwo riina saka hikirek. Wowak, takis yan yatar ma ye nobo anamesherokotar kapasek mima yecha riina meejichiniga hikir. eena sumowurek, kwo eena heri kwo saka kwoti inyaka dareboyechi riin hiki siitiichibarek.” ");
INSERT INTO kmo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas rii eecha wor: “Dii akar shiy tawa majin na meeji. Ma Por rii harapa nosapek tarek, rii wain nowo eeka otiir. Otiirek, inyijir. Worek, rii wain ukun hekiir tar papa supun otiir. Otiirek, rii eeta nowon siitii kow aka pochi otiibar. Worek, rii akar man harek, yecha siitii kowu tarek, rii heechi riiti eem pochi yapak tarek, rii eeka heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Worek, wain ukun otii tar nedii sii yarek, nowo ma rii riiti yo otii tar ma kawen heechirek, ye eeta wain kawen yeechi ye iken eena yar. ");
INSERT INTO kmo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ye yarek, nowo siitii kowu tar ma ye yenya howu neekichi poren kubu pichi poren pi sowakwochi poren papak rabor. ");
INSERT INTO kmo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Worek, nowo ma meejichi rii anadii yo otiitar wakasa ma kawen heechirek, ye way kawka yar. Ye way yari, nowok ya sayarek, nowon siitii kowu tar ma ye yenya neekichi mashi otiirega eechaba kawka otiir. ");
INSERT INTO kmo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Worek, nowo ma rii way meejichi riiti yikapwan heechirek, rii way yar. Rii mayama eecha wor: ‘Yepa eeji yikapwa riiti majin meejikiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Worek, nowo tar ma ye yikapwan herek, ye mayama eecha wor: ‘Dii eeta nowo ma riiti yikapwa. Na hawa pi sowakwochi diita nowon nota yakiita!’ ");
INSERT INTO kmo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Worek, ye riina howu neekichi sabak rabochi pi sowakwar.” ");
INSERT INTO kmo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas rii eecha wor: “Nago. Wain nowo ma rii yanak, rii kapoboyen nowo siitii kowu tar ma yenya otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yecha awasen eecha wor: “Nowa ma rii kapasek otii tawa ma yenya pi sowakwo hamakiita. Wonyak, riipa eeta wain nowon yeechi anadii siitii kowu tawa man hakiita. Hanak, yepa aboboy ya nedii yepa kawen yeechi hanak, riipa akiita.” ");
INSERT INTO kmo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Worek, Jisas rii yenya eecha wor: “Kwo kapo God riiti mashi keyir maji saka kenyitarek? Sii eecha wocho: ‘Kata papan aka yon otii tar ma yecha rabori, Ii rii sokwa kepi papak siirek, riin somar heechir. God riita otiichirek, Eeta sokwa kepi wey.’” ");
INSERT INTO kmo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jisas rii kawka eecha wor: “Eena ada kwona wocho: God riiti kigdom kwotaka tawey, eena awasen yakiita. Yeechi anadii man hanak, ye omu kepin wakiita. ");
INSERT INTO kmo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Eeta ma papa hek sakaney, riina ameda pikiita. Eeta papa riina ma hek sakaney, ii ma eeta mogobak siikiita.)” ");
INSERT INTO kmo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Worek, opelen otiitar harapa ma ye Peresi ma ye Jisas riita shiy tawa majin meejiri, ye eecha hikitar Jisas rii kata nona wocho. ");
INSERT INTO kmo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eena ye riina pokok jiken otii hechari, ye ma mima yenya akiirek, eena riin heechir. Ma mima eecha hikitar Jisas rii eeta piirapet. ");
INSERT INTO kmo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas rii way kawka shi tawa majik wor: “Hevenek tawa kigdom sii harapa aka tabo yima otii tawabaga eecha otiito. Riiti yikapwa mima yak otiirek, eena rii harapa noku sha aken sayar tar. ");
INSERT INTO kmo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Worek, rii riiti yo otii tawa wakasa ma yen komas noku sha majin yecha yaken wochirek ir. ");
INSERT INTO kmo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Worek, komas rii way yo otii wakasa ma yen heechirek, yecha ya majin wochirek ir. Wori, ye yaken gegiyakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Worek, rii way kawka yo otii wakasa ma yenya wochirek ir. Rii yenya eecha wor: ‘Woher ma yenya na i wonyak: eeji nokusha a boboy eetaq sayar homawa. Eeji bulamakaw, bulamakaw yin sowakwor. Eyey boboyen sayar homawa. Na yanak, nokusha ak!’ ");
INSERT INTO kmo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Worek, woher ma mima ye eena meejikasakech. Ye yechi yoban eechaba otiitar. Woher ma por rii riiti nowok heechi ir. Por riiti boboy toko akak ir. ");
INSERT INTO kmo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Woher ma kaw ye wakasa ma kawen yeechi pi sowakwor. ");
INSERT INTO kmo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Worek, aka tabo yima rii meejichi kwotayichi rii riiti ow ana pichar man heechirek i sowakwor ma yen eeta ma ye pi hamar. Yechi akaman hik hay hamar. ");
INSERT INTO kmo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Worek, rii riiti yo otii wakasa man uwar. Uwachi rii yenya eecha wor: ‘Eeji nokusha aboboy eeta apa sayar hamawa. Wowak, woher ma yechi nobo eeta kapasek. Ye eena ya eeji aboboyen akasakech. ");
INSERT INTO kmo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wowak, na i harapa nobok chishitanak eeka henya ma ii napa wochanak sapa ya.’ ");
INSERT INTO kmo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Worek, wakasa ma ye harapa nobok iri, ye eyey ma hechi ye yen wo yayar. Ma kepi ma kapasek eyey wo yayar. Worek, nokusha ak otii tar aka sii takiikiisiir. ");
INSERT INTO kmo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Worek, ma ye ya yapakarek, aka tabo yima rii yenya heken ir. Irek, rii heri ma por rii riki kepin ruwukasakech. ");
INSERT INTO kmo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Worek rii eecha wor: ‘Nareboy, boyewak mii diita tapa a nediik yawey saka riki kepin ruwu yawak?’ Worek, eeta ma rii awasen maji bakasakech. Me tobo siir. ");
INSERT INTO kmo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Worek, aka tabo yima rii riiti wakasa ma yenya eecha wor: ‘Riina na yeechi riiti yatii tapan poko jichi geenyik niyik yik rabochinyak sa i. Eeka sa keyatanak pu giiriiga wagiiriiga ta.’” ");
INSERT INTO kmo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas rii kawka eecha wor: “Nokwapa nokwapa ma mima yenya uwawey, eyey hisiichi kenyikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Peresi ma ye i Jisas riina apo diigiichi dagiir poyeken eena otiitar. ");
INSERT INTO kmo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eecha otiik otiitarek, ye yechi maji pok tar ma kawen Herot riiti ma kawen heechirek, ye Jisas riina woheken yar. Yarek, ye eecha wor: “Tisa, no hikitu mii maji siikiinen batawa ma mii God riiti maji siiken batawey, mii God riiti inyakan mukuchichu. Eena mukuchichawak, mii anadii ma ye miina hikitawey mii eena inyaka hikikasakech. Harapa tawa ma karakada tawa ma yen mii hechawey mii eecha hikitu eeta kubuchey boboy. ");
INSERT INTO kmo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wowak, nona na ba. Ii mii shecha hikitu? Nota Sisa riina takis yan haney, ii kapo no lon reekiito. Kapo reekiikasakech?” ");
INSERT INTO kmo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas rii meejichi rii yechi inyakak hiki tawa boboyen rii her. Eena hechi rii eecha wor: “Kwo woshepii tawa ma. Boyewak kwo ana dagiir poyeken otiito? ");
INSERT INTO kmo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kwota takis yan toko tawa ya mani na pochi yeechi yaya ana mukuchi!” Worek, ye ya mani yeechi yaya riina mukuchir. ");
INSERT INTO kmo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mukuchirek, rii yenya eecha woher: “Diita misoma hi diika tawey, kapo namey hi?” ");
INSERT INTO kmo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ye awasen eecha wor: “Eeta Sisa riiti.” Worek, Jisas rii yenya eecha wor: “Wowey, Sisa riiti boboy ii na riitaban ha. God riiti boboy ii na God riitaban ha.” ");
INSERT INTO kmo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ye eena meejichi nyegiirabor. Nyegiirabochi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Eeta nedii Sadyusi ma kaw ye Jisas riitak yar. Sadyusi ma ye eecha wocho: Ha tawa ma ye awasen saniyeechi ya sokwakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ye eecha wor: “Tisa, Moses rii eecha wor, ‘Ma por rii yikapwa biish tanak, haney, riiti kumwoy rii sapa riiti mima siina ya. Riita yanak, har ma riiti senyen sapa yikapwa por kiya.’ ");
INSERT INTO kmo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wowak, 7 yaka kumwoy diika tar. Tarek, yaka rii mima yar. Yari, rii harek, rii sobo har. Yikapwa biish. Worek, kumwoy riita way siin yar. ");
INSERT INTO kmo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yari yaka riita otiirebaga rii eechaba otiir. Worek, eyey yaka kumwoy ye eechaba eechaba siir. ");
INSERT INTO kmo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Worek, eeta mima sii eeta komas habar. ");
INSERT INTO kmo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wowak, ma awasen ya sokwak tawa nedii yarek eeta mima siin kapo nama yakiita? Eyey yaka kumwoy ye siina ya hamar!” ");
INSERT INTO kmo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Worek, Jisas rii yenya awasen eecha wor: “Kwo keena kapasek wey hikitu. God riiti keyir majin God riiti hapaga tawa boboyen kwo eena hekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Har ma yecha ya sokwana nedii ma ye mima yaksaskech. Yepa hevenek tawa ejelega eecha takiita. ");
INSERT INTO kmo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wowak, ada man yesokwa majin kwona bak. Kwo kapo God riita bar majin saka kenyi her. Rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ada Ebraham riiti God, Aisak riiti God, Jekap riiti God. Maji mu eecha wocho: Ada har ma yechi Godekasakech. Ada sobo tawa ma yechi God.” ");
INSERT INTO kmo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Worek, ma mima ye riita maji pokii tar maji meejichi ye eena henebarabor. ");
INSERT INTO kmo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Eecha barek, Jisas rii Sadyusi yechi kujan diimiir. Eecha otiirek, Peresi ma ye eena meejichi ye bana yopo wuchi yir. ");
INSERT INTO kmo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Worek, ma por rii yechi nediik tari lon otii hechar ma rii Jisas riina dagiir poyeken eena otii hechar. ");
INSERT INTO kmo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Rii eecha woher: “Tisa, shecha tawa o siita mapo harapa tawa?” ");
INSERT INTO kmo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas rii awasen eecha wor: “Miita miiti Harapa miiti God riina na miiti inyaka wopu, mesek, marenoku ii eeka na riina rukusii ta.’ ");
INSERT INTO kmo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Diita lo sii eeta mapo harapa na kepi wey. ");
INSERT INTO kmo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Komas harapa lo sii diitata: ‘Kwo mayama rukusii tawaga diita bana bana tawa man na eechaba rukusii ta.’ ");
INSERT INTO kmo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Eeta maji piiriiti muga eecha tawa. Moses riiti eyey loka piirapet yechi eyey majika.” ");
INSERT INTO kmo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Peresi ma ye ya yopo wuchi yicharek, Jisas rii yenya woher: ");
INSERT INTO kmo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Boyak kwo Kraist riin hikitu? Rii kapo namey neja?” Ye awasen eecha wor: “Ri eeta Devit riiti neja.” ");
INSERT INTO kmo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas rii awasen eecha wor: “Eecha tarek, boyewak Spirit rii otiichicharek, Devit rii Kraist riina eecha habatar Harapa?’ Devit rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Eeta Harapa rii eeji Harapa riina eecha wor: Eeji mama yepak na yi komas ada miina ow ana pichawa man miiti kuruk heechikiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit rii riina Harapa habatari boyega shecha Kraist rii Devit rriti neja tawa?” ");
INSERT INTO kmo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma ye riina meejichi maji pochi bakasakech. Worek, eeta nedii ye riina akiitarek eena maji pochin kawka way wohekasakech. ");
INSERT INTO kmo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Worek, Jisas rii ma ma mima riiti disaipel yen eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Lon maji pokii tawa ma, ye Peresi ma ye eecha wocho: ‘Noti yo eeta Moses riiti lo mun anadii man kukuchichu. ");
INSERT INTO kmo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eena kwo nota batawa majin na sumowu ta.’ Wowak, kwota yechi otii tawa abon eena opoche sumowutanakech. Yi majiban na sumowu ta. Ye yechi kujak batawa majin eena sumowukasakech. ");
INSERT INTO kmo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yecha nomoya tawa boboyen yechi ma yechi tiimiinak howu kiyachi tawey, ye tapamak parachi kiya powukasakech. ");
INSERT INTO kmo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Eyey boboyen ye otii tawey, ii eeta ma ye heken eena otiito. Ye God riiti maji uku yopoga tawa boboy ye harapa otiichi yi makabek jichi chishitu. Ye saket gworo mayakan ruwuchi bar. Keyapochichi chishi tar! ");
INSERT INTO kmo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nokusha a tawey, ye harapa tiikiiren yecha eena kwoya hechi eeka yichu. ");
INSERT INTO kmo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ye ma yecha awa batawa eemek inyak ye yenya woshi aken gegi yakiita. Ma ye ‘Tisa’ habaken gegiyato. ");
INSERT INTO kmo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Wowak, opoche anadii ma ye kwona ‘Tisa’ habatanakech. Kwo yaka kumwoy tawa. Tisa podareba tawa. ");
INSERT INTO kmo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kwo opoche diita nosapek eyey tawa ma ‘apoko’ wochanakech. Kwoti Apoko podareba rii hevenek tawa. ");
INSERT INTO kmo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kwona opoche mapo i ma habatanakech. Kwoti mapo neeki ichawa ma podareba tawey, riiti he eeta Kraist. ");
INSERT INTO kmo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kwoti harapa tawa ma rii sa kwoti yo otii wakasa ma sii. ");
INSERT INTO kmo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kata ma rii riiti hin yesokwa taney, iipa riin dagiir poyekiita. Ma por rii riiti hin mayama dagiir poyeney, riipa eeta harapa siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Lon maji pokii tawa ma kwo Peresi kwo na ow poy sii ta. God riita kwona pikiita. Kwo maji kuja upurus batawa ma. Ma kaw ye God riiti kigdom yaken otiitawey, kwo nubureja dasepii par tawa ma. Wowak, kwota eena kidgom iyarekasakech. Ma mima ye iyareken otiitawey kwo saka heechitawak, ye i yarekiitawak! ");
INSERT INTO kmo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(“On maji pokii tawa ma kwo Peresi kwo na ow poy sii ta. God rii kwona pikiita! Kwo maji kuja upurus batawa ma. Kwo mibiya mima yen dagiir poyechi yechi akan hiyik yatol Eecha otiitawak, kwo God riina woshepii gworo majin bato. Kwo eecha otiitowak, eena harapa kapasek boboy yatawey, sii eeta kwotaka eecha siikiita.”) ");
INSERT INTO kmo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Lon maji pokii tawa ma kwo Peresi kwo na ow poy sii ta. God rii kwona pikiita. Kwo maji kuja upurus batawa ma. Kwota harapa somakwotii tawa pak ichawey, nosapek ichawey, kwo i kwona sumo i ma yenya yeshato. Yesha henyak, wonyak riita uwu tawa eemek i maga eecha otiito. Kwo otiitawey, rii keena kwona dagiir poyechi harapa hapaseken eechaba otiito. ");
INSERT INTO kmo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kwo miy dumu tawa nobon mukuchichawa ma na ow poy sii ta. God rii kwona pikiita. Kwo maji pokiitu: ma rii lotu aka maji siiken bachi sabo howuney, eecha baney ii sumowukasakech. Riita otu aka goen eena siiken bachi sabo hahuney, ii napa sumowu. ");
INSERT INTO kmo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kwo hikishatawak, kwoti miy eeta dumutu. Boy boboy eeta harapa? Kapo goll harapa? Kapo lotu aka harapa? Lotu aka sii otiichichawak, gol sii eeta kepi tawa. ");
INSERT INTO kmo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kwo maji eechaba pokiitu: ma por rii opel maji siiken bachi sabo howuney, eecha baney, ii sumowukasakech. Rii opelen ha tawa boboyen siiken sabo howuney, ii napa sumowu. ");
INSERT INTO kmo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kwota miy eeta dumu siikener. Boy yikade boboy eeta harapa? Kapo howu ha boboy? Kapo opel otiitawa boboy? ");
INSERT INTO kmo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ma por rii opelen siikien sabo howuney, eecha baney, rii eeta opelen eyey howu hatawa boboyen eena rii sabo howutu. ");
INSERT INTO kmo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma rii lotu akak maji siiken bachi sabo howuney, rii lotu akan eeka yichawa God riitaka piir eecha sabo howutu. ");
INSERT INTO kmo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma por rii hevenen maji siiken bachi sabo howueney, rii God riiti tiikiireka God riitaka eecha yichi sabo howutu. ");
INSERT INTO kmo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Lon maji pokii tawa ma kwo Peresi kwo na ow poy sii ta. God riita kwona pikiita. Kwo maji kuja upurus batawa ma. Kwota God riina eyey karakada boboy ten ten hato. Wowak, kwo lo siiti harapa nobon wosowoyeto. Nagwa nagwa otii tawa boboy, man rukusii tawa boboy, yo kepin otii tawa boboy kwo eena wosowoyeto. Diita boboyen na hikichi otii ta. Anadii boboy kepin opoche abosuchitanakech. ");
INSERT INTO kmo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kwo miy dumu tawa nobon mukuchichawa ma. Amaruka kwoti uku a heebiyak ye inyey, kwo yeechi rabokiita. wowak, kame sii iibak ye inyey, kwo siitiika eecha akochekiita. ");
INSERT INTO kmo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Lon maji pokii tawa ma kwo Peresi kwo na ow poy sii ta. God rii kwona pikiita! Kwo maji kuja upurus batawa ma. Kwo kwoti kapasek boboy sababan yeetiito. Kwo kapasek boboyen otiichichi hiy yatawa kapasek boboyen otiichichi yatawak, kwoti kapasek boboy eeta boboy takiikii sowa. ");
INSERT INTO kmo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mi dumu tawa Peresi ma kwo heebiyan na yeechi mapo won uku yeetii. Uku yeetiinak, sabaka eecha apoma hekiita! ");
INSERT INTO kmo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Lon maji pokii tawa ma kwo Peresi kwo na ow poy sii ta. God riita kwona pikkita. Kwo maji kuja upurus batawa ma. Kwo eeta tiiriimo supun now apomak neeki tawaga eecha hecha. Kwo saba eecha apoma hechawey, kwoti wo ha ma hapa kwopa sii tawa boboy takiikii siito. ");
INSERT INTO kmo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kwo eechaba tawa. Ma ye kwona hechawey kwo apoma hecho. Hechasey, kwoti wo woshepii tawa boboy kapasek yon otii tawa boboy takiikiisii tawa.” ");
INSERT INTO kmo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Lon maji ppokii tawa ma kwo Peresi ma kwo na ow poy sii ta. God riita kwona pikiita. Kwo maji kuju upurus batawa ma. Kwo hadabas tiiriimon piirapet yenya otiichichi kwo yo kepin otii tar ma yechi papan tatar man yesokwa siitiichi keyapo chichu. ");
INSERT INTO kmo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Eecha otiitawak, kwo eecha wocho: ‘Nota mashi wayega tar nediik teyega, eecha piirapet yenya pi sowakwor boboyen na mashi saka eecha otiitarek.’ ");
INSERT INTO kmo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kwo mu eecha wochawey, no noti wayega riitii neja. Kwoti wayega ye piirapet yenya pi sowakwor. ");
INSERT INTO kmo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eeka pi sowakworek, wowak, na i kwoti wayega yecha tasiichi otiirin, na otii hama. ");
INSERT INTO kmo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kwo hopoga tawa. Kwo hopo yiga tawa. God riita anasakii otiinak, kwo hiy uwu tawa eemek kwona eeka heechikiita. Kwo kapo boyega eena tavii yichi ikiita? ");
INSERT INTO kmo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Ada kwona wocho: Ada piirapet yenya harapa hiki tawa ma yenya Tisa ma yenya kwona eecha wochinak ikiita. Inyak, kwo kawen pi sowakwonak, kaw mek ji siitiichinyak, kawen kwoti otu akak pokok pinyak, kawen pi kikir chinyak, akar eemek heechi ikiita. ");
INSERT INTO kmo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wonyak, kwona ya kapaseken hakiita. Mashi Ebel rii yo kepin otiitarek, kwoti wayega rii riina pi sowakwor. Sekaraia, Berekaia riiti yikapwa, riina kwota pi sowakwor. Lotu aka yepa tarek opel otiitar chey yepa tarek eeta nediik kwo riina pi sowakwor. Worek, kwoti yey wayega yechi ya kapasek sii kwota otii tawa ya kapasek siitaka eeta kwotabak yakiita. Kwo kwoti wayega yechaka ma kepin pi sowakworek eena kwotaka yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ada kwona maji siiken wocho: Mashi kapasek yon otii tar ma yechi ya kapasek kwota kapasek yan eyey diita nosapek diita tawa ma kwona hakiita!” ");
INSERT INTO kmo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusaem, Jerusalem! Kwo piirapet yenya pi sowakwo hato. God riita kwona hehareken heechitawak ichawa man kwo eena papak rabochi pi sowakwoto. Apochoko nokwapa siita siiti yin yeechi yaya chepi wok woyi tawaga, ada kwona eechaba eeji tapak yaya yopo yichiken gegiyato. Ada gegiyatawey, kwota ana yuya bokonato! ");
INSERT INTO kmo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Apa kwoti aka God riita heechi inyak iipa biish woy siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ada kwona wocho, apa na komas kwo ana hekaskech. Kwota wonyak, ‘Ma rii Harapa riiti hik yatawey, riina na rukusii ta!’ Wonyak, kwota eeka anapa hekiita.” ");
INSERT INTO kmo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas rii harapa lotu akan heechi icharek, riiti disaipel yecha riitak yarek, ye harapa lotu aka otiir papan mukuchir. ");
INSERT INTO kmo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisas rii yenya eecha wor: “Kwota kapo eena kwoya hecho. Ada kwona wocho: eyey hek tawa papa ye reekiichi sakakiita. Eeta papa sii siiti tar eemek takasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas rii Oliv kwowuk eeka yicharek, riiti disaipel yecha veenyichi riitak yar. Yaniga eecha wor: “Nona na ba. Siitii yekega kapo diita kapasek boboy diita nosapek yakiita? Boy boboy sii mukuchikiita miita diita nosapek awasen ya nedii diita nosapek hamak tawa nedii yakiita?” ");
INSERT INTO kmo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas rii awasen eecha wor: “Na ow poy sii ta. Anadii ma por iipa kwona ya woshepiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nokwapa nokwapa yepa, eeji hik yanak eecha wokiita: ‘Ada eeta Kraist, eeta riitaba.’ Wonyak, nokwapa nokwapa man woshepiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kwopa ow ana pi hokwa takwan bana bana meejikiita. Yapak tana hokwa takwa majiban kwopa meejitakiita. Wonyak, kwo opoche eena inyakapa hikichi mija maji batanakech. Eech otiina boboy ii sapa ya. Ii eecha wokasakech hamak tawa nedii diita yato. ");
INSERT INTO kmo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Akama pochi siipa eeta sokwa akama pochin ana pikiita. Nokwapa nokwapa ma yepa eeta harapa eechin hatakiita. Nenyaw eetapa eyey eemek harapa yatakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Diita boboy siipa eeta mima yikapwa yimowuk otii tawak mapo hapa meeji tawaga eecha meejikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Wonyak, eeta nediik yepa kwona nomoya tawa boboy mayakan hanak kwona pi sowakwokiita. Eeji hi kwotak tawak, diita nosapek tawa ma ye eena kwoa harapa yuyakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eeta nediita nokwapa nokwapa ma ma mima ye yecha Jisas riina hiki siitiichichawa boboyen heechikiita. Wonyak, nokwapa nokwapa ma yepa yechi yaka kumwoyen yuyeechi anadii yabu pi ma yechi tapak how hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Eeta nedii yana kapa nokwapa nokwapa woshepii tawa piirapet yepa ya nokwapa nokwapa man woshepiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kapasek otii tawa boboy siipa ma yechak i yeyakiita. I yeyanak, ma yechi anadii man hehar rukusii tawa boboyen wubuyarebokiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma por tanak, komas yak tawa nediika kiki siiney, riina God riita yesokwa yichikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Diita God riiti hadabas emek tawa majin eyey nosapek eyey akamak i sawo ye i takiita. I sawo ye i tanak, wonyak, ma mima yepa meejitanak, hamak tawa nedii siipa yakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Piirapet Daniel rii eecha wor: ‘Kapasek wey otii tawa boboy siipa God riiti eem kepik siitii takiita. Siitii tanak, kwopa hekiita.” (Wonyak, ma diita jeyn kenyetaney, ii napa hehar hiki ta.) ");
INSERT INTO kmo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Eeta nedii ma mima ye Judia nosapek tawey, kwo napa heechi akii kwowuk i. ");
INSERT INTO kmo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma aka sabak taney i akak tana boboyen i kawka yar yakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma rii nowok taney, rii way i riiti akak tawa saketen yakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Eeta nedii mima yikapwa baregiika taney, mima yikapwa muku ataney, yecha nomoya kapa meejitawa boboyen yecha harapa kiyakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kwota na God riina wohe: mii opoche nona neekiireya nedii yanak heechinak ichanakech. Akamak sii tawa nedii heechinak ichanakech! ");
INSERT INTO kmo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Diita nomoya tawa boboy sii harapa mayaka siikiita. Mashi mashi nedii diita yikadey kapasek boboy mayaka yakasakech. Apa nedii komas nedii yakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Eeta nedii God riita otii tobo siir. Otii tobo siiyega ma waga takasakech. Eyey ha hamawa. Riita riiti hisiichi kenyir man eena hikirek eena tobo siikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Eeta nedii yanak ma por rii eecha wonyey, ‘Kraist rii kata yepak tawa. Diika tawa.’ Opoche diita majin eena sumowutanakech. ");
INSERT INTO kmo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wowak, woshepii tawa piirapet ye woshepii tawa Kraist ye sokwatakiita. Sokwanak, ye harapa jebwan mirakel eena otiikiita. Boyewak otiikiita? God riita hisiir ma yenya woshepiiken eena otiikiita? Woshepiiken otiiney, saka otiikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ada bawa maji na meeji. Ada kwona wor. Komas diita boboy yakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ma mima yecha kwona eecha wonyey, ‘Kraist rii ma biish tawa eemek eeka i tawa.’ Eena meejichi opoche ichanakech. Yecha eecha wonyey, ‘Rii aka wok yar tawa.’ Eena meejichi opoche iyaretanakech. ");
INSERT INTO kmo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yeeripiya sii eyey eemek okoree tawaga, Ma Yikapwa rii yanak eechaba eemek uhadiinaga hekiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ma hawa tawa eem eeka oponumay ye ya eeka yopo wuchi yichu.” ");
INSERT INTO kmo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nomo mayaka ya tawa nedii hamanak, ya rii tiiriikiita. Niiwiika sii tiiriibakiita. Winyumay ye sakakiita. Howuk tawa boboy sii nobon heechi anadii nobok ikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eeta nediik Ma Yikapwa ri jebwan niiriika hekiita. Henyak, eyey eemek ta ye i tawa ma ye eena hechi keyatakiita. Wonyak, yecha hekiita Ma Yikapwa rii niiriik ya sakanak, riiti hapaga tawa boboyeka hadabas boboy kepik eecha ya sakakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wonyak, harapa sagiiyega tawa boboyen piita tanak, rii riiti ejeen heechinak eyey eemek i ye yatakiita. I ye yatanak, Riiti ma mima yenya yeechichi yayakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kwota na pik me siita otiitaweyn eena na hechi hiki ta. Siiti tapa siita nubuchi akar kiipiika sokwanak, kwo hecho ii eeta nedii kepi yak otiito. ");
INSERT INTO kmo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eechaba otiitanak, kwo na hiki. Diita ada bawa eyey boboyen kwota henyak, kwo na hiki ta eeta nedii bana siito. Eeta tasiito. ");
INSERT INTO kmo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ada kwona siiken wocho: diita kapasek nedii yanak, eecha otii tawa ma ye eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Neereka nosapek piir hamakiita. Eeji maji sii hamakasakech. Eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Eyey ma ye Jisas rii awasen ya nediin mayin hekasakech. Howuk tawa ejel ye hekasakech. God riiti Yikapwa rii hekasakech. Apoko God riiaba saniga hecho ");
INSERT INTO kmo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ma ye Noa riita tar nediik otii tarega, Ma Yikapwa rii diika yana nediik ma ye eechaga otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Harapa uku niy siina biish tar nediik ma ye uku atarek, aboboy atarek, miman yatar. Eecha otii ichari, Noa rii eetaq jabiir wok i yarer. ");
INSERT INTO kmo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yecha otiitarek, ye yechak yak otiitar boboyen hekasakech. Worek, harapa uku siirek, yari, yenya gamupoyer. Ma Yikapwa rii yana nedii siipa eechaba otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wonyak, eeta nedii ma upurus nowok i tanak poren heechikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mima upurus piir gey chichaney, pochin yanak, pochin heechikiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eena na kwota na hehar kowu ta. Kwota hekasakech Harapa riita yana nedii. ");
INSERT INTO kmo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kwo na hiki ta: aka ma rii hiyi yatawa ma riita ya nediin hikiney, riipa riiti akan siitii kowu tanak sakapa hiyi ya man heedhinak iyarekiitawak. ");
INSERT INTO kmo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eena kwo eechaba na tanak, na kowu ta. Ma Yikapwa rii awasen diika yanak, kwo eecha hikikkita rii yakasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kapa nama eeta yo kepin hehar otii tawa ma, kapo nama nagwa nagwa hiki tawa nobon yo otii tawa wakasa ma? Rii diitata: riiti harapa ma riita riina akar man siitii kowu ta yon hari, rii yenya aboboy a nediik eeka hato. ");
INSERT INTO kmo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eecha otii tawa ma riiti harapa ma riita awasen yanak, rii riiti wokasa ma riiti yon henyak wakasa ma rii inyaka kwoya woy hikitakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ada kwona siiken wocho: harapa ma riipa riina hisiinak, riipa i harapa ma siinak, riipa riiti eyey boboy sagiin riipa siitii kowutakiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Diita ma rii kapasek wakasa ma taney, riipa mayama wokiita, ‘Eeji harapa ma riipa saka awasen ameya yakiitawak.’ ");
INSERT INTO kmo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wonyak, rii taney, anapoy yo otii man pinyak riipa beyi tawa maka otii anak, uku akiita. ");
INSERT INTO kmo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wonyak, yo otii wakasa ma ri harapa ma riipa awasen yanak, rii riina saka howutakiitawak. Yana nedii hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wonyak, eeta nediik harapa ma rii riina pichi kuhachi woshepii tawa ma yecha tawa eemebak rabonak yechaka eecha takiita. Heechinak riipa eeka keyatanak, pu giiriiga wa giiriigatakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Eeta medii yanak, God riiti kidgom eeta yokotapa yokotapa amunyegu mimaga eecha yakiita. Yecha yechi lam yeechi mima tapa ak yak tawa ma riina nobok kowuken iken otiitar. ");
INSERT INTO kmo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yokotapa ye hikisha tarek, yokotapa ye hikitar. ");
INSERT INTO kmo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hikisha tawa mima ye am yeechi yayari, uku kaweban yayar. ");
INSERT INTO kmo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hikitar mima ye eeta uku anadii botol takiikiisiirek, eecha yayabar. ");
INSERT INTO kmo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Worek, mima tapa aken yaken otii tar ma rii ameya yakasakech. Worek, mima tapa aken yaken otii tar ma rii ameya yakasakech. Worek, mima ye eena miy meejirek, watar. ");
INSERT INTO kmo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Worek, niy nediik uwar aya eecha wor: ‘Tapa ak otii tawa ma rii yato! Na ya he!’ ");
INSERT INTO kmo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Worek, mima ye eyey sokwachi yechi lam sayarer. ");
INSERT INTO kmo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sayarerek, hikisha tawa mima ye hiki tawa mima yenya eecha wor: ‘Uku na nona kaw ha. Noti am uku eeta hamak otiito.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Worek, hiki tar mima ye awasen eecha wor: ‘Yaho. Diita uku sakapa kwotaka notaka eecha kiki siikiitawak. Eeta kepi na kwota i boboy toko tawa akan i toko.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Worek, ye eena ukun tokoken irek, mima tapa ak yar ma rii yarek, aka wok i yiniga yokotapa mima yechaka eecha otii atarek nubureja dasiipii payitar. ");
INSERT INTO kmo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Worek, komas yokotapa mima ye ya eecha wor: ‘Harapa ma, harapa ma, nobo na tagwanak, no ya sayak! ");
INSERT INTO kmo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mima tapa atar ma rii eecha wor: ‘Ada kwona hekasakech.’” ");
INSERT INTO kmo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas rii kawka eecha wor: “Eena na owpoy sii ta. Kwo ya nedii hekasakech. Ya maji hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","God riiti kidgom tawaga eecha tawa. Ma por rii akaman heechi akar eemek iken sayar tar. Worek, rii riiti yo otii wakasa ma yenya uwa yayar. Uwa yayeechi rii riiti eyey boboyen yechi tapak how har. ");
INSERT INTO kmo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","How heechi rii yecha otiik tawa abon hechi rii yenya mani ya har. Poren 5,000 doa har. Poren 2,000 doa har. Poren 1,000 doa har. Heechi rii heechi akamak ir. ");
INSERT INTO kmo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Irek, 5,000 ya manin yar ma rii bisnis yo otiitari rii way kawka 5,000 dola yan yar. ");
INSERT INTO kmo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Worek, 2,000 ya manin yar ma rii bisnis eechaba yo otiitari, rii way kawka 2,000 dola yan yar. ");
INSERT INTO kmo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Worek, 1,000 dola yan yar ma rii riiti harapa ma riiti yan yeechi ye i wa kwotiichi supuk chir. ");
INSERT INTO kmo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sii sii mashi siirek, wakasa ma yechi harapa ma rii way ya yechaka riita har ya majin baken eena yar. ");
INSERT INTO kmo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yarek 5,000 dola yan yar ma rii ya 5,000 dola yan riina awasen tapak how har. Worek, rii eecha wor: ‘Miita ana 5,000 doa yan har. Na he. Ada i awasen 5,000, dola yan kawka yeechi yayar.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Harapa ma rii awasen eecha wor: ‘Mii eeta yo kepin otiitar. Miita eeta wakasa ma kepi. Miita karakada boboyen hehar otiitarek, ada miin nokwapa nokwapa boboy hanak, miita eena siitii kowukiita. Mii na ya miiti harapa ma riitaka kwoya hiki chishi ta!’ ");
INSERT INTO kmo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Worek, 2,000 dola yan har. Na he! Ada i kawka 2,000 dola yan yeechi yayar.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Worek harapa ma rii eecha wor: ‘Mii eeta yo kepin otiitar. Miita eeta wakasa ma kepi. Miita karakada boboyen hehar otiitarek, ada miina nokwapa nokwapa boboy hanak, miita eena siitii kowukiita. Mii na ya miiti harapa ma riitaka kwoya hiki chishi ta!’ ");
INSERT INTO kmo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Worek, 1,000 dola yan yar ma rii yaniga eecha wor: ‘Harapa ma, ada hecho. Mii ow asa ma. Mii nowo sagiin yeechi otii makasakech. Akar siiken yeechi nowok rabokasakech. ");
INSERT INTO kmo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eecha otiitawak, eena ada akiichiniga miiti mani ada yeechi ye i eena wa kwotiichi supuk chir. Na he! Miiti yan na yeechi ye i.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Riiti harapa ma rii awasen eecha wor: ‘Miita kapasek tawa wakasa ma. Mii waba tawa ma. Mii boy kapo eecha hikitar ada sagiin yeechi yaya chikasakech, ada nowok tawa boboy siiken yeechi rabokasakech. ");
INSERT INTO kmo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wowey boyewak mii eeji mani yan heechi tawa eemek saka heechirek? Miita eecha otiiyega, ada awasen yawey, ada eeji eyey har yan yeechi kawka waga yawa. ");
INSERT INTO kmo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Diita apak, riitaka tawa ya manin yeechiniga ye i 10,000 dolan yar ma riitaban napa ha. ");
INSERT INTO kmo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Boyewak! Ma boboy kawka taney yenya kawka hatakiita. Wonyak, ye eeta harapa siikiita. Ma por rii boboy biish taney, riiti karakada boboyen awasen yeechi akar man hakiita. ");
INSERT INTO kmo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Eeta yo otii wakasa ma rii kapasek, riina na kikirechinyak, sa i niyik yichawa eemek sa i. Inyak, sa keyatanak pu giiriiga wagiirega ta.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","32","“Komas Ma Yikapwa aka tabo yi maga riipa yanak, riiti eje yechaka eecha yanak, riipa riiti harapa tiikiir kepik yinyak, eyey diita nosapek tawa ma yepa i riiti mi somak siitiikiita. Wonyak, riipa sipsip siitii kowu tawa ma riita meme yenya sipsip yechaka keyibotawaga, riipa ma mima yen eechaba keyibokiita. ");
INSERT INTO kmo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Riipa sipsip yenya riiti mama yepak heechinak, meme yenya yeji yepak heechikiita. ");
INSERT INTO kmo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wonyak, aka tabo yima rii mama yepak tana ma mima yenya eecha wokiita: ‘Kwota, eeji Apoko riita rukusiitari, kwo na ya. God riita kwona mashi mashi nediik otiichir. Kigdomen na ya ya. God riita diita nosapen otiir nediik rii eeka kwona otiichir. ");
INSERT INTO kmo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na ya ya. Mashi ada eecha ha tari, kwota ana hava tar. Barek siitari kwota ana ukun hatar. Ada anadii tarin yar. Ma tari, kwota ana akan har. ");
INSERT INTO kmo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ada siivatabi biish siitari kwota ana siivatabin har. Ada hakenotii tari, kwota an hehar tar. Ada poko ji akak tari, kwota ya an hechar. ");
INSERT INTO kmo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wonyak, ma kepi yepa riina awasen eecha wokiita: ‘Harapa Ma, siita nediik nota miina her mii eecha hatarek, nota aboboyen miina har? Mii bareka siitarek, nota miina uku hatar? ");
INSERT INTO kmo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Siitayekega nota miina her, mii anadii akama maga yarek, nota miin akan har? Siitayekega miita siivatabi biish siirek, nota miina rikin har? ");
INSERT INTO kmo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Siitayekega mii haken otiitarek, poko ji akak tarek, nota miina ya her?’ ");
INSERT INTO kmo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wonyak, aka tabo yima rii awasen eecha wokiita: ‘Ada kwona wocho: Kwota kubuchey tar yaka kumwoyen hehar tari, kwota ana eechaba otiichichar. ");
INSERT INTO kmo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wonyak, riipa yeji yepak siitii tana ma yenya eecha wokiita: ‘God riita otiichirek, kwo eeta sii siiken sowa. Kwo napa God riita Gabaka yechi ejeleka yenya otiichir hik napa i! ");
INSERT INTO kmo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mashi ada eecha hatari, kwo ana havakasakech. Ada bareka siitari, kwo ana uku hakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mashi ada anadii ma tari, kwo ana akan hakasakech. Ada rikin biish tari, kwo ana hakasakech. Ada haken otiitari, ada poko ji aka tari kwo ya ana heharekasakech.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Wonyak, yepa awasen riina eecha wokiita: ‘Harapa ma, siitayekega nota miina her miita eechi hatarek, bareka siitari, anadii maga tari, riki biish tari, hak otii tari, poko ji akak tari, no miina kiyatayi kasakech?’ ");
INSERT INTO kmo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wonyak, harapa aka tabo yima rii yenya awasen eecha wokiita: ‘Ada kwona maji siikenen wocho: kwota diita kubuchey tar man hechi saka kiyatay tarek, kwo ana eechaba kiyatayikasakech.’ ");
INSERT INTO kmo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wonyak, eeta yikadey ma yepa i ya kapaseken eechaba yatakiita. Nagwa nagwa ichawa ma yepa i eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas rii diita majin riiti disaipel yenya ba hamarek, rii yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kwo hikitu yadii upurus Pasova nokusha a nedii yanak, Ma Yikapwa riin tapak howu hanak, riin mek ji siitiichikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Eeta nedii opelen otii tar harapa ma yecha Ju apoko saba ma yechaka Kaiapas riiti akak ya yopo yichir. Kaiapas rii opelen otii tar harapa tar ma. Ya yopo yichirek, ye veenyichiapo diigiitar. Jisas riina veenyeechi pi sowakwoken eena apo diigiitar. ");
INSERT INTO kmo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ye eecha wochar: “Nota opoche diita Pasova nokusha a nediik otiitanakech. Ma mima yepa eena hechi owun yesokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas rii Betani akamak mashi maba kapasek tar Saimon riiti akak tar. Betani akamak tar. ");
INSERT INTO kmo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Eeka tarek, mima pochi sii riitak yari, sii kwowa ya tar ukun woyi tar papa awon yayaniga Jisas riita yi otii atarek, riiti masekiik gwotii powur. Eeta uku ya naji tar uku. ");
INSERT INTO kmo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Worek, disaipel ye eena hechi inyaka kwotayichi riina eecha woher: “Boyewak siita diita ukun shebo shebo gwotiiwa? ");
INSERT INTO kmo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nota diita ukun haney anadii ma ye tokona harapa yan nota yeechi kiiriisiiposii tawa man waga hawa!” ");
INSERT INTO kmo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Worek, Jisas rii yecha hiki tar majin hechi rii eecha wor: “Boyewak kwo kata mima siina yo mayakan hawa? Sii ana hadabas boboy kepin otiichuwa. ");
INSERT INTO kmo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kiiriisiiposii tawa ma ye eechaba eechaba kwotaka tawa. Wowak, ada kwotaka eechaba nedii takasakech. ");
INSERT INTO kmo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mima siita kwoya ya tawa ukun eeji mabak gwotiiri, sii eeji ha nobo takiichuwa. ");
INSERT INTO kmo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Diina na makabek heechi. Diita hadabas majin diita nosapek sawo ye i tanak, siita otiiwa boboyen eechaba sawo ye i takiita. Sawo ye i tanak, yepa eena hiki takiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Worek, disaipel por Jisas riitaka eecha 12 tari, riiti hi Judas Iskeriot, rii i opelen otiitar harapa ma yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Kwota ana boy boboyen hanak, ada Jisas riina kwoti tapak hak?” Worek, ye 30 ya mani kenyichi riin har. ");
INSERT INTO kmo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wowak, eeta nediik Judas rii Jisas riina how ha nobon yeshatar. ");
INSERT INTO kmo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yis Biish Tar Gey nokusha atar mapo yadii yarek, disaipel ye Jisas riitak yaniga woher: “Kapo siitak nota Pasova nokusha a nediin miina sayarechikiita?” ");
INSERT INTO kmo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rii yenya eecha wor: “Kwota na i harapa akamaka tawa ma por wohe: ‘Eeta Tisa rii echa wor: Eeji nedii yar. Yarek, ada eeji disaipel yechada eecha miiti akak Pasova nokusha akiita.’” ");
INSERT INTO kmo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Worek, disaipel ye Jisas riita worega eecha Pasova sayarer. ");
INSERT INTO kmo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hogo nedii siirek, Jisas rii riiti 12 disaipel yechaka eecha aken yir. ");
INSERT INTO kmo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yecha atarek, Jisas rii eecha wor: “Kwotaka bana tawa ma por riipa ana magiirechichi kwodii wokiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Disaipel ye meejichi eena hiki ye ichi riina wohechar: “Harapa Ma, miita wochawey, ana boy wokasakech?” ");
INSERT INTO kmo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas rii awasen eecha wor: “Kata ma rii adaka eecha tapa sicha chegiik heebiyak geyen hey woyir ma riitapa ana magiirechikiita. ");
INSERT INTO kmo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God riita keyir maji eecha wor: Ma Yikapwa wii sapa ha. Wori, riipa hakiita. Wowak, Ma Yikapwa riina magiirechichichawa ma riipa kapasek wey siikiita! Riiti nokwapa sii riina yimowanan siiyega, owaga kepi. ");
INSERT INTO kmo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Worek, Judas, magiirechir ma, rii eecha wor: “Tisa, miita ana kapo wokasakech?” Jisas rii awasen eecha wor: “Miita wochowey, eeta mii wocho.” ");
INSERT INTO kmo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yecha atarek, Jisas geyen yeechi Apoko riina woshi eechi neeki reekiichi disaipel yenya har. Haniga rii eecha wor: “Na ya a. Dii eeta eeji maba.” ");
INSERT INTO kmo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Worek, riita wain uku yeechi eechaba Apoko riina woshi eechi yenya haniga eecha wor: “Kwota na eyey a. ");
INSERT INTO kmo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Dii eeta eeji pi. Eecha mukuchichu God riita wotar maji sii eeta siiken woy sokwato. Eeji pi nosapek gwotii sakanak, nokwapa nokwapa ma mima yechi kapasek boboyen poyekiita. ");
INSERT INTO kmo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ada kwona wocho: diita wain ukun ada saka komas kawka akiitawak. Komas ada eeji Apoko riiti kigdomek siinak, eeka akar wain ukun akiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Worek, ye hokwa pochi chichi sokwa geenyik ichi Oliv kwowuk eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Worek, Jisas rii disaipel yenya eecha wor: “Diita niyik kwoti hiki siitiichichawa boboyen adak heechi ikiita. God riita mashi heyir maji eecha wocho: ‘God rii sipsip hehar tar ma riina pi sowakwonak, sipsip ye heechi akii i ye yakiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wonyak, ana saniyeechi yesokwanak, ada mapo i Galili nosapek i takiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita rii eecha wor: “Anadii ma yepa miina heechi inyey, adaba miina saka heechikiitawak!” ");
INSERT INTO kmo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas rii meejichi Pita riina eecha wor: “Diita niyik apochok woken otii tana nediik miita ana piiriichar eecha wokiita: Miita ana hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita rii awasen eecha wor: “Ada siiken wocho: Ada miiti hin veenyikasakech. Ada miitaka eecha hakiita!” Worek, eyey disaipel ye eechaba wor. ");
INSERT INTO kmo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Worek, Jisas rii riiti disaipel yechaka eem pochi Getsemani eeka ir. Irek, rii yenya eecha wor: “Kwo diika na yinyak, ada i katak God riina maji bak.” ");
INSERT INTO kmo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Rii Pita riina Sebedi riiti yikapwa piiriitaka eecha yeechi ye ir. Riiti inyaka harapa nomo yar. Harapa nomo yeechi rii yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Eeji inyaka harapa nomon yawa. Yawak, ada hak otiito. Kwo diika tanak, adaka eecha siitii kowu ta.” ");
INSERT INTO kmo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Worek, rii ameda yeroku ichi riiti misomak sakar. Sakachi rii eecha wor: “Eeji Apoko, ma yechi kapasek boboy bachi poyi anadii nobo taney, na otiichinyak, ada nomo yatawa boboyen na yeechi rabo. Wowak, eeji inyakak hiki taweyn eena sumowukasakech. Miiti inyakak hiki taweyn ii napa sumowukiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Worek, rii disaipel piiriichar yechak awasen yar. Yari, rii her ye watar. Watarek, hechi rii Pita riina eecha wor: “Boyewak kwo saka adaka awa pochi saka siitii kowutawak? ");
INSERT INTO kmo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kwo na siitii kowutanak, God riina maji ba ta. II kwopa boboy siipa kwona eecha heechiney, kwopa tiipiikeneechi sakakiita. Spirit rii yaken otiitawey, maba sii yuyato.” ");
INSERT INTO kmo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas rii kawka iri God riina maji bar. Rii eecha wor: “Eeji Apoko, diita kapasek adak yatawey, diita heebiya adapa anan yuyakiita. Wowak, ada aney, ii eeta miiti yon ada otiiney, ii sa ya. Miiti yon adapa otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Worek, rii disaipel yechak kawka yari, rii her yecha kawka watar. Yechi mi meejitar. ");
INSERT INTO kmo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Worek, rii heechi kawka iri God riina maji mashi bar majiban iiban batar. ");
INSERT INTO kmo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Worek, rii kawka ya disaipel yenya wor: “Kwo boy opoy wabato? Na he. Ma Yikapwa riina kapasek yo otii tawa ma yechi tapak howu ha nedii yawa. ");
INSERT INTO kmo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na sokwa napa i. Na he. Ana magiiriichichi kwodii wochi kapasek otii tawa ma rii yawa!” ");
INSERT INTO kmo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas riita batarek, Judas, Jisas rii 12 disaipel por, rii eecha yar. Riita yarek, akar ma ye eeki kubuka eecha neeki neeki riitaka eecha yar. Opelen otii tar harapa ma ye Ju yechi apoko saba ma yecha wochirek, eena yar. ");
INSERT INTO kmo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kwodi wochi kapasek otii tar ma rii ya mapo mukuchichawa boboyen otiitar. Rii eecha wor: “Kata ma riina ada waga woshi eechi amor amorechi heedhinak, riina kwo yaken otiito. Riina napa yeechi poko ji!” ");
INSERT INTO kmo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas rii nagwa nagwa yari, Jisas riina omor amorechi eecha wor: “Tisa na eshar ta.” ");
INSERT INTO kmo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Worek, Jisas rii awasen eecha wor: “Miita otiiken otii tawa boboy na ameya otii!” Worek, yecha yari, Jisas riina tapak kiikiiriinachi neekitar. ");
INSERT INTO kmo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma por rii Jisas riitaka eecha tari, rii eena heechi riiti eekin heyi huguruku yeechi opelen otii tar harapa ma riiti wakasa ma por riiti mabiyan tiimii rabor. ");
INSERT INTO kmo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Worek, Jisas rii riina eecha wor: “Na eeki awasen heyi heehci. Eyey ma ye eekibak ana pichawak, eeki siipa yenya pi sowakwo hamakiita. ");
INSERT INTO kmo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kwo kapo saka hechawak? Ada eeji Apoko riina wonyak, riita ana nokwapa nokwapa ejel heechinak yanak, 12 ami ye yenya gamu poyekiita. ");
INSERT INTO kmo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ada riina wohenyey, God riita mashi keyir maji siipa saka sokwakiitawak. Wowak, mashi keyir maji sii sapa siiken ya.” ");
INSERT INTO kmo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Worek, Jisas rii ma yenya eecha wor: “Kwota yari eekika kubuka eecha neeki neeki yari ii hiyiya tawa man yaken yaniga kwo eecha yar. Boyewak eecha otiito? Nokwapa nokwapa yadii ada harapa lotu adak yi maji pokii tari, kwo ana eeka yakasakech. ");
INSERT INTO kmo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wowak, piirapet ye God riiti maji keyiri, sii sa i siiken sokwa ta.” ");
INSERT INTO kmo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Worek, eyey disaipel ye riina heechi akii ir. Jisas riina jichi ye ir ma ye Jisas riina Kaiapas riiti akak ye ir. Kaiapas rii opelen otii tar harapa ma. Riiti akak lon maji pokii tar ma Ju apokosaba ma ye eecha yopo wuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Worek, Pita rii wumowu icharin rii yapa kadak tar. Opelen otii tar harapa ma riiti akak Pita rii eeka i sumowutar. Sumowuchi rii inyik wok i yarechi rii siitii kowutar ma yechaka eecha yichar. Rii sokwana boboyen heken eena eeka yichar. ");
INSERT INTO kmo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Opelen otii tar harapa ma ye kansil ma ye Jisas riina woshepii maji ba diima man eena yeshatar. Yecha riina pi sowakwoken hikirek, eena eecha otiitar. ");
INSERT INTO kmo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nokwapa nokwapa ma ye woshepii maji batarek, ye riina sowakwo nobon yesha hipiir. worek, ma upurus piir yari eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Diita ma rii eecha wor: ‘Ada eeta kiki sowa ada harapa lotu akan dagiichi yadii piiriichar kawka otii hamakiita.’” ");
INSERT INTO kmo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Worek, opelen otii tar harapa ma rii Jisas riina eecha wor: “Mii diita ba diima tawa majin mii boyewak saka awasen bawak?” ");
INSERT INTO kmo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Worek, Jisas rii meejichi saka awasen barek. Worek, harapa ma rii way kawka riina eecha wor: “Ada eechaba eechaba takiitawa God riiti hik miina wocho: Miita howuk tawa God riiti hin na baba: Mii boy eeta Kraist, eeta God riiti Yikapwa?” ");
INSERT INTO kmo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas rii riina awasen eecha wor: “Miita bawa maji eetata. Ada kwona wocho: Komaskwo hikiita. Ma Yikapwa riipa i howuk hapaga tawa Apoko riiti mama yepak yikiita. Tanak, hapaga siichi riipa neerek kawka yakiita!” ");
INSERT INTO kmo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Worek, harapa ma rii eena kwotayechi riiti rikin woyarechi eecha wor: “II God riina wosoboyeto. Ba diima tawa ma kaw ii sa kayekiisii! Kwo eeta apak riiti kapasek majin meeji hamawa! ");
INSERT INTO kmo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kwo shecha otiiken hikitu?” Ye awaseneecha wor: “Rii kapasek tawa. Sa kayek ha!” ");
INSERT INTO kmo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Worek, ye riiti misoman sogo yak piichi pir. Ma kaw ye riina pichi eecha wor: “Kraist, miita nona na ba. Kapo nama miina piwa?” ");
INSERT INTO kmo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita rii inyi wok yicharek, opelen otii tar harapa ma riiti wakasa mima sii ya Pita riina eecha wor: “Mii eechaba Galili Jisas riitaka tar.” ");
INSERT INTO kmo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Worek, Pita rii eyey ma mi somak woshepiichi eecha wor: “Ada niji maji meejikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Worek, rii sokwa inyi nuberejok iyarer. Worek, anadii wakasa mima pochi sii way riina hechi eeka tar ma yenya eecha wor: “Diita ma rii Nasaret Jisas riitaka eecha tar ma.” ");
INSERT INTO kmo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Worek, Pita riita meejichi kawak woshepii majin wor: “Ada sabo howu maji siikenen wocho: Kata ma riin an hekasakech!” ");
INSERT INTO kmo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ameda siichi eeka siitii tar ma ye ya Pita riina eecha wor: “Eeta siiken. Miita eeta riiti ma por. Miiti maji sii eeta miina kwodii wocho!” ");
INSERT INTO kmo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Worek, Pita rii meejichi sabo howu bokonachi eecha wor: “God miita ana pi. Kata ma riina ada hekaskech!” Worek, apochok aya wor. ");
INSERT INTO kmo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Worek, Pita rii Jisas riita riina bar majin hikir. “Apochok wo nediik miita eeji hin piiriichar veenyikiita.” Worek, Pita rii eena hikichi i sabak yarechi inyakapwa hikichi harapa keyatar. ");
INSERT INTO kmo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Uhaderek, opelen otii tar ma ye Ju apoko saba ma ye Jisas riina pi sowakwo nobon apo diigiichi yesha hechar. ");
INSERT INTO kmo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yecha riina pokok jichi ye i Pailot riiti tapak how har. Pailot rii eeta gavman harapa ma. ");
INSERT INTO kmo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Worek, Judas, Jisas riina magiirechir ma, rii her ye Jisas riina anasarek, rii riiti inyakan dareboyichi rii 30 silva yan yeechi ye i opelen otii tar harapa ma yenya Ju apoko saba ma yenya har. ");
INSERT INTO kmo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Rii eecha wor: “Ada kapasek boboyen otiir. Ada otiirek, kepi wey tar ma riinapa pi sowakwokiita.” Ye meejichi awasen eecha wor “II noti yokasakech. Miiti saniga yo!” ");
INSERT INTO kmo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Worek, Judas rii eena meejichi riiti silva yan yeechi lotu akak rabo parechi rii heechi i mayama borowagii pokok kiitiirek har. ");
INSERT INTO kmo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Worek, opelen otii tar harapa ma ye silva yan heyiyi yeechi eecha wor: “Diita ya eeta man pi sowakwo tawa ya. Noti lo saka eecha wochawak, kata yan noti lotu yaka eecha chegiik heechikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ye apo diigiichi eeta yan yeechi nosap pochin tokor. Nosap si he eeta awo chichawa ma ri nosap. Eeta akar ma yechi tiiriimo tar eem. ");
INSERT INTO kmo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eena eeta nosap si hi eeta Pi Nosap. Siiti he eechaba tawa. ");
INSERT INTO kmo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eecha otiirek, God riiti piirapet, Jeremaia, riita keyir maji sii eeta sokwato. Rii eecha keyir: “Yecha 30 silva yan yar. Isrel ma ye apo diigiichi eecha hikitar diita ya kata ma riina tokokiita. ");
INSERT INTO kmo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Siva yan yeechi ye awo chichawa ma riiti nosapen tokokiita. Eeta Harapa riita ana wor.” ");
INSERT INTO kmo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas rii i siitiirek, harapa Gavman ma rii riina woher: “Mii boy kapo Ju ma yechi harapa aka tabo yima?” Jisas rii awasen eecha wor: “Miita bawa maji eetata.” ");
INSERT INTO kmo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Opelen otii tar harapa ma ye, Ju yechi apoko saba ma ye eena ba diimatari, Jisas rii yenya awasen bakasakech. Siitii meeji tar. ");
INSERT INTO kmo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Worek, Pailat rii way eecha woher: “Yecha miina ba diima tawey, mii boy meejito?” ");
INSERT INTO kmo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Worek, Jisas rii Pailat riina awasen bakasakech. Worek, harapa gavman ma rii eena i hiki ya hikir. ");
INSERT INTO kmo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pasova Nokusha nediik harapa gavman ma rii otii tawa abo rii poko jichawa man heemachi heechi tarek, ichar. Eeta ma mima yecha woherek, rii eena heemachi tar. ");
INSERT INTO kmo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kata nediik kapasek ma por rii tari, riiti hi, Barabas. Riiti he eyey meeji ye i tar. ");
INSERT INTO kmo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ma mima ye yopo wuchi siitiirek, Pailat rii yenya woher: “Ada boy naman heemachinyak ik? Kapo Barabas, kapo Jisas haba tawa, Kraist? Riina boy heechinak ik?” ");
INSERT INTO kmo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat hehar hiki tar ye Jisas riitaban inyaka kwotayechi hiki tar. Eena ye yeechi riiti tapak how har. ");
INSERT INTO kmo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat rii riiti tiikiirek yicharek, anasa tawa wok yar yicharek, Pailat riiti mimas sii riina jey keyichi heechirek ir. Sii eecha keyir: “Opoche mii kata ma kepi riin boy boboyen otiitanakech. Niyik ada riina sukuyawey, harapa nomo yatawa boboy mayaka adaka yawa.” ");
INSERT INTO kmo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Worek, opelen otii tar harapa ma Ju apoko saba ma ye ma mima ye otii kapasek sii boboyen apo diigiichi yesokwar. Ye eecha wor: Pailat riina na wohe: Barabas riina na heemachinyak sa inyak Jisas riitaban napa sowakwo! ");
INSERT INTO kmo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Harapa gavman ma rii yenya kawka woher: “Boy yikadey ma riina ada heemachinyak ikiita?” Ye riina eecha wor: “Barabas!” ");
INSERT INTO kmo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat rii awasen eecha wor: “Wonyak, anapa Jisas, haba tawa Kraist riin shechapa otiikiita?” Ye eyey awasen eecha: “Mek na ji siitii chi.” ");
INSERT INTO kmo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Worek, Pailat rii woher: “Boyewak? Rii boy kapasek boboyen otiirek?” Worek, ye harapa uwar: “Riina na mek ji siitiichi!” ");
INSERT INTO kmo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat rii hechi hikir: Boyewak ada diita boboyen eechaba babato? Rii her ma ye kapa anapik otii tari, eena rii ukun yeechi yayarek, rii riiti tapan yechi misomak uku yeetiir. Rii uku yeetiichi eecha wor: “Dii eeta kwota otiik tawa booby. Diita sowakwo tawa boboy eeji yokasakech. Kwoti keena yo!” ");
INSERT INTO kmo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Worek, eyey ma mima ye awasen eecha wor: “Nota kapasek otiitaney, eeta boboy siipa notak noti yikapwak yakiita!” ");
INSERT INTO kmo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Worek, Pailat rii Barabas riina heemachinrek yechaka ir. Worek, Jisas riina kubu pichi, riina mek ji siitiichiken eena ow ana pichar ma yichi tapak how har. ");
INSERT INTO kmo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Worek, Pailat riiti ow ana pichar ma ye Jisas riina yeechi ye i gavman harapa ma riiti aka wok yayarer. Yayarerek, eyey ma ye ya riina siitii wukurer. ");
INSERT INTO kmo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Worek, ye riiti ruwu tar rikin kwoyavayeechi nayim siik tar siivatabi awasen ruwuchir. ");
INSERT INTO kmo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ruwuchi ye yeemika tar pokon yeechi shagureyeechi masekiik ruwuchir. Worek, ye gubun yeechi mama yepak har. Ye eeka bana bana yatii bogok putiichi yi wokwoyachi hegachi eecha wor: “Mii eeta Ju ma yechi harapa aka tabo yima. Na eechaba eechaba ta. ");
INSERT INTO kmo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Worek, ye sogoyak piichi gubu yeechi riiti maseken tapar. ");
INSERT INTO kmo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eeecha otii hamarek, ye riina ruwuchir rikin kwoyava yeechi riiti rikik kawka ruwuchir. Worek, eeta riin yeechi mek ji siitiichiken ye ir. ");
INSERT INTO kmo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yecha icharek, Sairini ma por riina nobok her. Riiti he Saimon. Worek, yecha riina wohigiyar riita Jisas riiti men kiya ichiken. ");
INSERT INTO kmo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ye i eem pochik iyarer Siiti hi, Golgota. Mu eecha wocho: “Masekii hapa eem.” ");
INSERT INTO kmo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eeka iyarerek, worek, ye wain ukun kapasek ukuka yaworechi Jisas riina havaken otiitar. Worek, rii kwo a hechi rii yuyeechi heechir. ");
INSERT INTO kmo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Worek, yecha riina mek ji siitiichi hamarek, worek, ye riiti saketen yeechi satu anemeshi rokotarek, ma por riita yar. ");
INSERT INTO kmo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Worek, ye eeta eemek yi riina hechar. ");
INSERT INTO kmo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yecha jey yeechi keyir maji eecha wor: “DII EETA JISAS, RIITA JU YECHI HARAPA AKA TABO YIMA.” Worek, riiti masekiik eeka howu heechir. ");
INSERT INTO kmo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Worek, ye ma upurus piiriin hiyiyatarek, poren mama yepak jirek, poren yeeji yepak jir. ");
INSERT INTO kmo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma mima ye yatari, riina hechichi masekii ye yadiichichi Jisas riina wohegachi eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Mii eecha wochar: Harapa lotu akan ada diigiichi yadii piiriichar kawka otii hamakiita. Miita God riiti yikapwa taney, na keena saniga mayama otii yesokwa yichi. Men na heechi muk ya saka!” ");
INSERT INTO kmo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Opelen otiitar harapa ma ye lon maji pokii tar ma ye apokosaba ma ye riina eechaba wohegabachi eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Rii anadii man kiyatayichicharek, eena riita mayama kiyatayichikasakech! Rii boy Isrel yechi harapa aka tabo yima? Riita sa men heechi ya sakanak, nota riina hiki siitiichikiita! ");
INSERT INTO kmo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Riita God riina hiki siitiichichawey, rii eecha wocho ada eeta God riiti yikapwa. Wowak, nota hek: God riita otii kepi siik wonyey, sa otii kepi sii!” ");
INSERT INTO kmo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hiyiyatar ma piiren riitaka mek jik siitiichicharek, piir riina wohegabatar. ");
INSERT INTO kmo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yadii wurwur nediik eyey nosap ye eeta niyega eecha siir. Awa piiriichar eecha siir. ");
INSERT INTO kmo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eeecha siirek, Jisas rii harapa teejichi eecha wor: Eli, Eli, lema sabaktani? Eeta maji siin dareboyeri eecha wocho: “Eeji God, eeji God, boyewak miita ana heechi ir?” ");
INSERT INTO kmo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Worek, bana bana siitiitar ma ye meejichi eecha wor: “Rii Ilaija riina uwato.” ");
INSERT INTO kmo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Worek, ma por rii meejichi ameya i uku sheki atawa boboyen yeechi yaya wain ukuk hey kiiviivhi kubuk sukwuchi howu kujak neekir. ");
INSERT INTO kmo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Worek, anadii ma ye eecha wor: “Na amedii kwowu. Nota hek. Kapo Ilaija riipa ya riina yesokwa yichikiita!” ");
INSERT INTO kmo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Worek, Jisas rii harapa teejichi eeta kiiriidii chir. ");
INSERT INTO kmo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Worek, harapa lotu akak tar shikichar siiviitabi sii nediik piikachi upurus sakar. Howuk mapo piika iri, heyik i sakar. Worek, nosape nyenyaw yarek, papa rogwachi sakar. ");
INSERT INTO kmo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tiiriimo tagwa seechir. Tagwa seechirek, nokwapa nokwapa God riiti ma mima harin yesokwa yichir. ");
INSERT INTO kmo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesokwa yichirek, ye tiiriimo supun heechir. Komas Jisas riita saniyeechi sokwarek, diita ma mima ye harapa holi akamak iyarerek nokwapa nokwapa ma mima ye eeka opoy yenya her. ");
INSERT INTO kmo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ami kepten rii anadii ow ana pichar ma yechaka eecha Jisas riina siitii kowu tarek, harapa nyenyaw yarek, anadii boboy yabarek, ye eena hechi harapa akiitarek, eecha wor: “Eeta siiken, rii eeta God riiti yikapwa!” ");
INSERT INTO kmo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nokwapa nokwapa mima ye Galili heechi Jisas riina sumowu kiyatayi ibar mima ye eeka yepak siimaka her. ");
INSERT INTO kmo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Diita mima eeta Maria, Magdala, Jems, Josep piiriiti awi, Maria, Zebedi riiti yikapwa piiriiti awi yechaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hogo sii nediik, Arimatia nosapek tar ma rii tar, harapa ya manika eecha tari, rii yar. Riiti he Josep. Rii eeta Jisas riiti disaipel por. ");
INSERT INTO kmo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rii i Pailat riina Jisas riiti maban yeechi ye i tiiriimo chiken woher. Worek, Pailat rii wochir Josep riita yeechi ye iken eena wochir. ");
INSERT INTO kmo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Worek, Josep rii yeechi riki apoma hepik jichi rii riiti tiiriimo supuk ye i seechir. Riita diita supun otii seechiri anadii ma poren yaya chikasakech. Maban ye i seechirek, papan yeechiniga nubureja eeka dasiipii parechi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdala sii akar Maria pochi siitaka eecha yichar. Piir yi tiiriimo supuban eena hechar. ");
INSERT INTO kmo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Komas yadii nedii pochi siirek, Sarere, opelen otii tar ma ye Peresi ye Pailat riitak ya yopo wochi yir. ");
INSERT INTO kmo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Worek, yecha wor: “Harapa ma, nota eecha hikitu kata woshepii tar ma rii tarek, eecha wochar, ‘Yadii diipiira kata siichi ada saniyeechi kawka yesokwakiita.’ ");
INSERT INTO kmo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eena nota eecha hikitu miita na wonyak, tiiriimo supun dasiipiichi hehar siitii nowutanak, yadii diipiira kata sa sii. Wonyey, riiti disaipel ye riiti maban iipa hiyik yeechi ye i ma mima yenya sawokasakech. Yecha iipa eecha wokiita, ‘Rii saniyeechi ya sokwawa.’ Komas woshepii siipa mashi woshepii siitaka kiki siikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Worek, Paiat rii yenya eecha wor: “Ow ana pichawak siiti kowu tawa man na yeechi yayanak tiiriimo upuk sa i bana bana hehar siiti kowu ta.” ");
INSERT INTO kmo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Worek, ye heechi i tiiriimo supun hehar dasiipii parechi hokuk shar. Hokuk sharek, ye siiti kowu tar man heechirek siiti kowu tar. ");
INSERT INTO kmo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Akama sii tawa nedii sii hamarek, Sade uhadiirek, Magdala Maria sii akar Maria pochi siitiika piir eecha tiiriimo supun heken ir. ");
INSERT INTO kmo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Worek, ameya nosap sii harapa nyenyaw yar. Harapa riiti ejel rii hevenek taren heechi ya sakar. Sakari, tiiriimo dasiipii tar papan tagwa seechi rii eeta papa tukuk yichar. ");
INSERT INTO kmo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Riiti maba eeta yiirepiya tawaga eecha hechar. Ri siivatabi eeta apama tobo woy her. ");
INSERT INTO kmo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wiitii tar ma ye eena hechi harapa akii nubunubu tari, ha maga eecha siir. ");
INSERT INTO kmo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Worek, ejel rii mima piiriina eecha wor: “Ki opoche akiitanakech. An hewa ki Jisas riina mek ji siitii chirin eena heken yawa. ");
INSERT INTO kmo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rii diika takasakech. Rii saniyeechi sokwa ir. Mashi riita worega rii eecha otiir. Na ya riita watar eemeban na he. ");
INSERT INTO kmo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kicha napa ameya i riiti disaipel yenya wo: ‘Rii harek, God riita riina awasen yesokwa yichir. Yichirek, rii apa Galilik mapo i kwona kowutaken ir. Eeta eemek kwota riina i hekiita!’ Ada kwona bawa majin napa kwo eena makebek heechi.” ");
INSERT INTO kmo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Worek, eeta mima piir eena akiichi inyaka kwoya hikichi piir ameya ir. Disaipel yenya sawoken eena ir. ");
INSERT INTO kmo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Worek, Jisas rii ya piiriina nobok ameya jawor. Jawochi, piiriina woshi eechi eecha wor: “Kichi inyaka sii kwoya hiki ta.” Worek, piir bana bana yesokwa tar. ");
INSERT INTO kmo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas rii piiriin eecha wor: “Opoche ki akiitanakech. Kicha na i eeji yaka kumwoyen wonyak, ye sapa ya ana Galili nosapek he. Ada eeka taken ichu.” ");
INSERT INTO kmo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mima piir icharek, tiiriimon siitii kowu tar ma ye heechi i harapa akamak iyayarek, ye opelen otii tar harapa ma yenya otiir boboyen sawotar. ");
INSERT INTO kmo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Worek, opelen otii tar ma ye apoko saba ma yechaka eecha yopo wuchi yi apo diigii tar. Apo diigii hamachi ye siitii kowu tar ma yenya harapa yan har. ");
INSERT INTO kmo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Heechi eecha wor: “Napa eecha wo: No watarek, riiti disaipel ye ya riiti maban niyik yeechi ye ir. Kwo watarek, yeechi ye ir. ");
INSERT INTO kmo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wowak, harpa gavman ma riita diita majin meejiney, nota riina harapa banak, kwo eena hikichi akiikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Worek, siitii kowu tar ma ye meejichi ya manin yeechi yenya bar majiga eechaba bar. Eena diita maji Ju ma yechak i ye yarek. Wowak, apa diita eechaba otiito. ");
INSERT INTO kmo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Worek, 11 disaipel ye Jisas riita yenya wor Galili kwowuk eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Eeka i ye riina hechi riiti hin yesokwatar. Worek, kaw ye riina i hiki ya hikitar. ");
INSERT INTO kmo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas rii ya bana bana siitii eecha wor: “God riita ana hapaga boboyen harek, ada howuk tawa boboyek nosapek tawa boboyeka adaba siiti kowutu. ");
INSERT INTO kmo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wowak, eena kwota na heechi eyey nosapek ta yey tawa ma mima yenya wonyak, ye sa eeji disaipeleba siinak, Apoko riiti hik, Yikapwa riiti hik, Holi Spirit riiti hik eeka sa uku yeechi ta. ");
INSERT INTO kmo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yenya na sawotanak, ada eyey kwona bar majin eena na maji pokii tanak, sa eena sumowu ta. No hiki ta: Ada kwotaka eechaba eechaba takiita. Apa i komas nedii ada kwotaka eecha siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diita maji God riiti Yikapwa, Jisas Kraist, riiti hadabas maji riiti yo kepi diitata: ");
INSERT INTO kmo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Piirapet Aisaia riita keyir boboy sii eeta sokwar. Rii eecha keyir: “God riita riiti Yikapawan eecha wor, ‘Na he: ada ma poren heechinak riipa mapo inyak, riipa nobon hehar tak ichikiita, miina.’ ");
INSERT INTO kmo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Me biish tawa eem aya pochi eecha wocho, ‘Harapa Ma riiti nobon na hehar sayarechicha. Riiti nobon na nagwa nagwa sayarechichanak, riipa eeka ikiita.’” ");
INSERT INTO kmo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Worek, Jon riita biish tar eemek eeka sokwar. Sokwari, ma mima yenya uku yeechichi God riiti majin sawotar. Sawotari, eecha wochar, “Kwota inyaka wopu na dareboy ta, wochi uku na yeechicha. Eecha otiiney, God riipa kwoti kapasek boboyen bachipoyekiita.” ");
INSERT INTO kmo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eecha otiitarek, nokwapa nokwapa Judia nosapek tar ma mima Jerusaem akamak tar ma mima ye Jon riita batar maji meejiken eena eyey ir. Yecha i yechi kapasek boboyen geenyik kwodii worek, Jon riita yenya Jodan pak eeka yeechir. ");
INSERT INTO kmo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon riita kamel nebiik otiitar rikin ruwur. Rii putu sapik nedii poko eeka giirii tar. Riita saman, himi yechi ukuka eecha atar. ");
INSERT INTO kmo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rii ma mima yenya eecha wochar, “Ma por komas yakiita. Riita eeta harapa. Ada eeta karakada. Riiti yatii ruwu tawa pokon ada keena saka gamuchi heemakiitawak. Riiti yon ada otiitawey, ada ma kepikasakech. ");
INSERT INTO kmo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Apa ada kwona ukuk ukuy eechichu. Riipa kwona Holi Spiritek ukuk eecha yeechikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Komas Jisas riita Nasaret akama Galili nosapek tarek, rii heechi Jon riitak irek, Jon riita riina Jodan pak eeka uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas riita pak tarin heechi ya sokwa mo heri, ner tagwa seechi tarek, rii her Spirit rii aponuma saka tawaga eecha riitak ya sakar. ");
INSERT INTO kmo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Worek, aya pochi nerek uwaqr, “Mii eeji yikapwa. Miita eeka tawey, ada miina kwoya hecho.” ");
INSERT INTO kmo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Holi Spirit rii ameya Jisas riina wochirek ir, rii heechi me biish tar eemek eeka i tar. ");
INSERT INTO kmo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eeka tari yadii 40 rii eeka tar. Rii tari Harapa Gaba rii riina otii otii hechar. Kwashik tawa boboy asa tawaga eecha tawa boboyeka eecha tar. Worek, ejel ye ya riina kiyatayer. ");
INSERT INTO kmo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yecha Jon riina poko jirek, Jisas rii Galili nosapek ichi God riiti hadabas maji sawo tar. ");
INSERT INTO kmo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Rii eecha wochar, “Eeta nedii kepi yar. God riiti kigdom, God riita ma mima yenya siitii kowu tawa boboy, diita bana bana tawa. Kwota na inyaka dareboyenak, maji kepin na meejichi hiki siitiichicha!” ");
INSERT INTO kmo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Gaili pa giiriibak chishiniga iri rii her ma upurus piir emiyep yatar. Piiriiti hi Saimon Pita, riiti kumwoy, Endru. Piir mayak emiyep yeechi yayatar. ");
INSERT INTO kmo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Worek, Jisas rii piiriina hechi eecha wor, “Kicha na adaka ya. Yanak, ada kinya man yeechi yaya tawa nobon mukuchi takiita.” ");
INSERT INTO kmo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Worek, piir piiriiti mayan ameya heechi Jisas riina sumowu tar. ");
INSERT INTO kmo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Rii heechi kawka ichari rii ma upurusen i kawka her. Piir yaka kumwoy tari piiri hi Jems, Jon, Sebeti riiti yikapwa. Piir piiriiti veyik tari piir mayan hehar otiitar. ");
INSERT INTO kmo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas rii piiriina hechi uwar. Uwarek, piir piiriiti apoko riina wakasa ma kawka riitaka veyik tarin yenya heechi piir Jisas riina sumowutar. ");
INSERT INTO kmo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Worek, ye heechi Kapaneam akamak iyarer. Yadii pochi iyarerek, Ju ma yechi akamas siitar nediik iyarer. Worek, Jisas rii Ju ma yechi lotu akak iyar maji sawor. ");
INSERT INTO kmo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yatarma mima ye riina meejiri ye nyegiirabor. Rii pokiitar maji lon otii hechar batar majiga eecha bakasakech. Riiti maji rii batari harapa mak banaga eecha batar. ");
INSERT INTO kmo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Rii batarek, spiriteka kapaseka tar ma rii lotu aka ya wok iyarechi harapa uwabar, “Nasaret Jisas, nota miiti yokasakech. Boyewak mii nona yawa? Mii boy kapo ya nona pi hamaken eena yawa? Ada miina hecho. Mii eeta God riiti Holi Ma kepi.” ");
INSERT INTO kmo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas rii meejichi kapasek spiriten eecha wor. “Mi kuja na dumichi na ya saya!” ");
INSERT INTO kmo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Worek, eeta spirit kapasek rii ma riin otii rii nubu nubu harapa uwa bachi heechi saya ir. ");
INSERT INTO kmo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Worek, eeta ma mima ye negiirabochi ye maji awasen awasen batar, “Diita ma ii boy yikadey ma? Diita ma rii eeta akar maji pokiitawa ma. Hapaga tawa boboy riitaka eecha tawey, rii spirit kapasek tawa man wochinak yasaya ikiita!” ");
INSERT INTO kmo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Worek, Jisas riita otiir maji anadii Galili nosapek i ye yar. ");
INSERT INTO kmo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Worek, yecha lotu aka heechi ye Saimon, Endru piiriiti aka eeka nagwa nagwa ir. Jems, Jon piir yechaka eecha ir. ");
INSERT INTO kmo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Irek, Saimon Pita riiti mima siiti nokwapa siita had otii tar. Maba si hi uwu tarek, eena watar. Worek, Jisas rii iyarerek, yecha riina ameya sawor. ");
INSERT INTO kmo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Saworek, rii i siiti tapak hey neekichi yesokwarek, sii sokwar. Sokwarek, maba hi uwutari eeta hamarek, sii yenya aboboyen sayarechir. ");
INSERT INTO kmo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hogo nedii siirek, ya ye irek, mima ma ye, hak otii tar ma, spirit kapaseka tar ma yenya yeechi Jisas riitak yayar. ");
INSERT INTO kmo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eyey akama ma mima ye ya nuburejak bana bana yopo wuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nokwapa nokwapa hak otii tawa boboyen riita otii kepi siir. Nokwapa nokwapa spirit kapaseken rii yeechi rabor. Eeta spirit kapasek ye riina hechar. Hecharek, eena Jisas rii yechi kujan dasiipiir. ");
INSERT INTO kmo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Worek, uhadiirek, niy tarek, Jisas rii sokwa akan heechi ir. Rii akama heechi ma biish tar eemek eeka God riina maji baken eena ir. ");
INSERT INTO kmo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Worek, Saimon rii riiti apoma ye Jisas riina yesha ir. ");
INSERT INTO kmo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","I herek, ye riina eecha wor: “Eyey ma mima ye miina yeshato.” ");
INSERT INTO kmo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Worek, Jisas rii awasen eecha wor: “Nota anadii bana tawa akamak hawa ik. Ada God riiti majin yenya sawobataken. Eena ada yar.” ");
INSERT INTO kmo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Worek, rii i Galili eyey akamak i ye yeechi rii ma mima yechi lotu aka iyarechi God riiti majin sawo sawochiniga spirit kapasek rii yeechi rabotar. ");
INSERT INTO kmo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maba kapasek tar ma, lepra man, rii Jisas riitak ya yatii bogok putiichi hey yir. Hey yichi riina kiyatayeken eena Jisas riina woyasachiyasar. Rii eecha wor: “Miitaq ana otii kepi siiken gegiyaney, miita keena ana otii kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Worek, Jisas rii riina harapa inyakapwa hikichi rii riiti tapan yesokwa riina neekiichi eecha wor: “Ada gegiyato. Miita na kepi ta!” ");
INSERT INTO kmo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Worek, mabak kapasek tar boboy sii eeta kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Worek, Jisas rii riina harapa maji bachi wochirek ameya ir. ");
INSERT INTO kmo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Rii riina eecha wor: “Na meeji. Mii opoche i anadii man sawotanakech. Mii opel otii tawa ma riina na nagwa nagwa inyak, riipa miina hehar hekiita. Riipa hehar henyak, miipa God riina boboyen, opelen, napa ha. Moses riita wochar majin eena ha. Miita eecha otiiney, ii miita nokwapa nokwapa man mukuchichu mii eeta apoma hewa.” ");
INSERT INTO kmo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Worek, ma rii iri, rii anadii man sawo ye ir. Rii harapa sawo tarek, Jisas rii eena anadii adama saka iyarerek. Rii Ma biish tar eemek eeka sabak tar. Sabak eeka tarek, nokwapa nokwapa ma mima ye eyey akaman heechi riitak yar. ");
INSERT INTO kmo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yadii kaw siirek, Jisas rii Kapaneam akamak kawka eeka ir. Ma mima ye eecha meejir, Jisas rii aka wok tar. ");
INSERT INTO kmo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Meejichiniga nokwapa nokwapa ma mima yatar. Yatari aka takiikiisiir. Takiikiisiirek, ma mima ye nubureja boyega iyarek wonyak. ");
INSERT INTO kmo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Worek, Jisas rii God riiti maji sawotarek, diipiira kapiira ma ye yar. Yari, yatii tapa har ma riina kiyaniga yar. ");
INSERT INTO kmo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nokwapa nokwapa ma mima ye takiisiirek, ye Jisas riina saka ye i mukuchirek. Eena ye aka matiikon yo diigiiri Jisas riita siitiitar eemek eeka nagwa nagwa diigiir. Ye diigiichiniga eeta ma rii riiti yememk watarek, eymeka eecha heechirek Jisas riita siitiitarek eemek ye yey seechir. ");
INSERT INTO kmo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Worek, Jisas rii yechi hiki siitiichichawa boboyen hechi rii yatii tapa har ma riina eecha wor: “Eeji yikapwa, miiti kapasek boboy eena bachi poyewa.” ");
INSERT INTO kmo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Worek, o maji pokiitar ma ye eeka yibatar. Yiba tarek, ye mayama eecha hiki tar: ");
INSERT INTO kmo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Rii boyewak God riina wosowoy maji bato? Ma por rii kapasek boboy otii bachi poyekasakech. God riitaba podar kapasek boboyen bachi poyetu.” ");
INSERT INTO kmo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Worek, Jisas rii yechi inyakan hikichi veenyetar boboyen heri, rii yenya eecha wor: “Boyewak kwi inyaka eecha hikitu? ");
INSERT INTO kmo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kapo boy kada maji eeta nomoyakasakech? Ada diita yatii tapa har ma riina banak, riiti kapasek boboy bachi poyenak, ada banak riita wa gwosii yeechi sokwa kiya ikiita. ");
INSERT INTO kmo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wowak, ada kwona mukuchik. Ma riiti Yikapwa rii diita nosapek tawey hapaga tawa boboy riitaka eecha tawa. Tawak, riita keen kapasek boboy bachi poyetu.” Worek, rii yatii tapa har ma riina eena wor: ");
INSERT INTO kmo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ada miina wocho, na sokwa, miiti wa gwosiin yeechi kiya miiti akak na i.” ");
INSERT INTO kmo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eyey ma yecha riina herek, rii eena hechi nyegerabochi God riiti hin yesokwatar. Ye eecha wor: “Mashi diita yikadey boboy nota saka hecharek!” ");
INSERT INTO kmo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Worek, Jisas rii icharek Galilli pagiirebak awasen yar. Yarek, nokwapa nokwapa ma mima riitak yar. Yarek, Jisas rii yenya maji pokiitar. ");
INSERT INTO kmo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Rii chishi tarek, rii takis yan yatawa ma riin her. Riiti hi Livai. Rii Apias riiti yikapwa. Rii riiti takis yatawa akak eeka yicharek, Jisas rii riina eecha wor: “Ana na sumowu ta.” Worek, Livai rii sokwa Jisas riina sumowu ir. ");
INSERT INTO kmo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Komas Jisas rii Livai riiti akak otii ar. Nokwapa nokwapa takis yan yatawa ma ye, nokwapa nokwapa muk shebo shebo tawa ma ye, kapasek otii tawa ma ye, Jisas riina sumowu tawey Jisas riitaka eecha tar. Tarek, ma kaw ye riitaka Jisas riiti disaipel, riiti sumowu tar ma, yechaka cheyek eecha yi ar. ");
INSERT INTO kmo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Worek, Peresi ma kaw, lo maji pokii tar ma kaw, yecha her Jisas rii muk shebo shebo tawa ma yechaka, takis yan ya tawa ma yechaka eecha atar. Atarek, ye Jisas riiti maji pokiitar wakasa ma yenya woher: “Boyewak rii muk shebo shebo tawa ma, takis yan yatawa ma yechaka eecha ato?” ");
INSERT INTO kmo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Worek, Jisas rii meejichi yenya eecha wor: “Ma hak otiinan biish tawey, rii dokta riitak saka iwak. Hak otiiney, ii riipa riitak ikiita. Ada yari, saka ma kepiweyin uwaken yarek. Ada muk shebo shebo tawa man kapasek otii tawa man eena uwaken yar. ");
INSERT INTO kmo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nedii pochik Jon baptis riina sumowu tar ma ye, Peresi yenya sumowu tar ma yechaka aboboyen heechir. Saka arek. Worek ma kaw tawama yechaka aboboy saka atawak. Yecha yechi otii tawa abon sumowu tawak eena akasakech. Boyewak miiti sumowu tawa ma ye ato?” ");
INSERT INTO kmo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas rii awasen eecha woher: “Kwo shecha hikitu, mima ya siikii tawa nedii mima yatawa ma riiti apoma ye boy nokusha atawa boboy kapo akasakech? Yaho. Ye abato. Mima yak tawa ma rii tawey, aboboy egesiikasakech. Eeta ato. ");
INSERT INTO kmo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Eeta nedii yanak mima ya tawa me riin yeechi ye ikiita. Ye inyak, aboboy yecha saka akiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ma ye saka akar riki yeechi mashi siivatabi kapakii tawak. Eecha otiiney, akar riki siipa siivatabi siina otii neekiikiita. Wonyak, siipa harapa supuka siikiita. ");
INSERT INTO kmo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma ye akar wain ukun yeechi mashi otiir meme sapi awok gwotiikasakech. Eecha otiiney, akar wain uku mashi otiir meme sapi awon reekiichi uku sakakiita. Yaho. Wonyak, ma ye akar wain ukun yeechi akar meme sapi awok eeka woyekiita! Opoche mashi boboyeka akar boboyeka chegiik heechitanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ju ma yechi Sabat nedii pochi Jisas rii wit nowo tar nediik ir. Riiti disaipel riina sumowu tar ma, ye riitaka eecha ichari, ye wit siiken siikiirechi aken yatar. ");
INSERT INTO kmo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Worek, Perisi ma ye hechi Jisas riina eecha wor, “Miiti disaipel yecha Sabat nediik eecha otii tawey, ii noti lon reekiito!” ");
INSERT INTO kmo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Worek, Jisas rii awasen eecha wor: “Kwo boy kapo mashi keyin maji saka kenyi tarek, eeta nedii Devit rii aboboy dopo tari, rii riiti wakasa ma yechaka eecha harek, rii God riiti aka iyarechi, God riin hor geyen opelen har geyen eena rii yeechi ar. ");
INSERT INTO kmo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Eeta nedii Abaiata rii opelen otii tar harapa ma tar. Noti lo maji eecha wocho diita geyen opelen otii tawa ma yechaba sapa ata. Worek, Devit rii eena achi wakasa ma yenya kawen har. Devit rii geyen arek, kapasek boboyen rii saka otiirek, eeji disaipel ye witen atawak, ye eena kapasek boboyen saka otiitawak.” ");
INSERT INTO kmo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas rii kawka wor, “Eeta akamak sii tawa nediin, God riita man kiyatayeken eena otiichir. God riita akama siitawa nediin otiirek, ma ye akama siitawa nedii hechawak, opoche ma ye nomoyatawa boboyen kiyatanakech. ");
INSERT INTO kmo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wowak, Ma Yikapwa rii akama siitawa nediin Harapa Ma.” ");
INSERT INTO kmo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Worek, Jisas rii lotu aka wok iyarer. Iyarechi tapa kapasek tar man eeka her. ");
INSERT INTO kmo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma kaw eeka tari, ye riina maji ba diimaken eena gegiyatar. Worek, eena yecha riina hehar hechar. Rii kapo ma poren otii kepi siikiita, kapo saka otii kepi siikiitawak? Ye eena hechar. ");
INSERT INTO kmo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Worek, Jisas riita tapa kapasek tar ma riina eecha wor: “Miita na ya nediik na siitii.” ");
INSERT INTO kmo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Worek, Jisas rii ma mima yenya eecha woher: “Noti lo maji kapo shecho anachekiita? Nota akamak siitawa nediik boy kapo man kiyatayekiita, kapo nota man kapasek otiikiita?” Worek ma ye maji saka batarek. ");
INSERT INTO kmo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Worek, Jisas riita yenya har he ye ichi inyaka kwotayechi rii way yanya inyakapa hiki tar. Yecha kapasek hiki tarek, yechi mabiya gii tarek, eena rii hechi inyakapa hiki tar. Worek, rii ma riina eecha wor: “Miiti tapan na danegwa.” Rii danegwarek, eeta otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Worek, Perisi ma ye lotu akan ameya heechi ir. Iri, Herot riiti magwi yechaka eecha ya yopo wuchi yir. Yirek, yecha inyakak hiki ye itar Jisas riina sowakwoken eena hiki tar. ");
INSERT INTO kmo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Worek, Jisas riita riiti disaipel yechaka eecha heechi Galili pagiirebak eeka ir. Irek, nokwapa nokwapa ma mima ye riina sumowuniga ibatar. Yecha Galili nosap heechi Judia nosap heechi, Jerusalem akamak heechi, Idumia nosap heechi, Jodan pa kata yo paka yepa nosapek heechi, Taia, Saidon piiriiti akama bana bana tar nosap heechi ye Jisas riitak yar. Yecha meejir Jisas rii harapa boboyen otii tar eena ma nokwapa nokwapa yar. ");
INSERT INTO kmo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nokwapa nokwapa ma mima yechaka eecha tarek, eena Jisas rii riiti disaipel yenya eecha wor, “Jabiir pochin na yeechi yayanak, ada eeka ye ik. Opoche ma mima yecha ana dagiir poyetanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Rii nokwapa nokwapa hak otii tar ma yenya otii kepi siir eena anadii nokwapa nokwapa hak otii tar ma ye akar man keyibo ya Jisas riina tapa neekiik yar. ");
INSERT INTO kmo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kapasek spiriteka tar ma ye Jisas riina hechi riiti yatii jumuk sakachi uwar: “Mii God riiti Yikapwa!” ");
INSERT INTO kmo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Worek, Jisas rii yenya harapa eecha wor: “Ada tawey, kwo opoche ana genyek kwodii wochanakech!” ");
INSERT INTO kmo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Worek, Jisas rii kwowuk heechi ir. Ichi rii hiki tar ma kawen yeechi riitak eecha yo otiiken eena uwar. ");
INSERT INTO kmo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yecha riitak yarek, rii 12 ma yenya hisiichi apose habar. Rii yenya eecha wor: “Kwota adaka eecha taken eena hisiir.” Rii kawka eecha wor: “Ada kwona heechinak kwota i God riiti majin sawotakiita. ");
INSERT INTO kmo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kwo kapasek spirit maka taweyn eena yeechi rabokiita. God riiti hapaga boboy kwotaka eecha tawak, eena kwo yeechi rabokiita.” ");
INSERT INTO kmo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Eeta 12 ma diitata: Saimon (riina Jisas rii akar hin har. Eeta Pita.) ");
INSERT INTO kmo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems, Jems riiti kumwoy, Jon. Piiriita Sebedi riiti yikapwa. (Jisas rii piiriina habar, Boanesis. Maji mu diitata: nerek kuru tawa boboy siiti yikapwa.) ");
INSERT INTO kmo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anadii disaipel diitata: Endru, Pilip, Batolomyu, Matyu, Tomas, Jems, (Alpias riiti yikapwa), Tadias, Saimon Selot. ");
INSERT INTO kmo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskeriot (Rii Jisas riina magiirechichi kapasek otiichi, rii Jisas riina ow ana pichar ma yechi tapak how har.) ");
INSERT INTO kmo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Worek, Jisas riita riiti akak ir. Irek, nokwapa nokwapa ma mima ye ya yopo wuchi yicharek, rii riiti disaipel ye otii akasakech. ");
INSERT INTO kmo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Riiti awi eepi kumwoy ye meejichi riina yeechi ye iken eena ir. Ma mima ye yenya eecha wor: “Jisas rii hikishato.” Eena ye riina yeechi ye iken ir. ");
INSERT INTO kmo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lo majin maji pokiitar ma kaw ye Jerusalem akama heechi yari ye eecha wochar: “Bielsebul, Gabaga tawa boboy, rii Jisas riiti wok eeka tawa.” Anadii ma ye eecha wor: “Harapa Gaba rii Jisas riitaka tawak, eena rii kapasek spiriten yeechi raboto.” ");
INSERT INTO kmo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Worek, Jisas rii yenya uwarek, yecha ya riitak bana bana tarek, rii yenya shiy tawa majin eena eecha wor: “Boyega Gaba riita mayama eeta Gaban yeechi raboto? ");
INSERT INTO kmo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Akama pochi sii ma saniga saniga siiney, iipa saka mu siikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Podar akak tana ma yecha saniga saniga har ta ye i taney, awasen awasen o ana pichaney, iipa ye saka muka siikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wowak, Gaba riita siiti kowu tawa ma mima ye saniga saniga har ta ye i taney, iipa saka hapaga siichi siitiitakiitawak. Iipa sak mu sii hamakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ma por rii hapaga tawa ma riiti akan i dagiichi saniga iyar hapaga tawa ma riiti boboyen yakasakech. Yaho. Mapo rii sapa hapaga tawa ma riiti tapan pokok jichi, riipa keena eeka riiti boboyen yakiita. ");
INSERT INTO kmo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Diita maji na hiki ta. Ma ye nokwapa nokwapa kapasek boboy otii taney, kapasek maji ba taney, God riita keena eena bachi poyekiita. ");
INSERT INTO kmo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wowak, ma por rii Holi Spirit riina kapasek ow majin baney, diita kapasek boboyen saka bachi poyekiitawak. Diita kapasek boboy rii eechaba eechaba kiyatakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Ma kaw ye eecha wor: “Kapasek spirit rii eeta Jisas riitaka eecha tawa.” Eena diita majin Jisas rii eecha wor.) ");
INSERT INTO kmo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Worek, Jisas riiti awi sii riiti kumwoy ye yar. Ya geenyek siitii Jisas riina wo yaya majin bar. ");
INSERT INTO kmo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eeta nedii nokwapa nokwapa ma mima ye Jisas riitaka bana bana yichar. Yicharek, ye riina eecha wor: “Na he. Miiti awi, miiti kumwoy ye kata geenyek siitiiniga miita yaken eena gegiyato.” ");
INSERT INTO kmo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Worek, Jisas rii awasen eecha wor: “Nama eeji awi?” Nama eeji kumwoy?” ");
INSERT INTO kmo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Worek rii bana bana riitaka yichar ma yenya miyik mey maka her. Hechi, rii eecha wor: “Na he. Eeji awi, eeji kumwoy diitata! Kata ma ye God riiti inyakan sumowu tawey, ye eeta eeji awi, eeji kumwoy eeji mowey.” ");
INSERT INTO kmo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","(-) ");
INSERT INTO kmo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Worek, Jisas rii Galili pagiirebak eeka maji pokiitar. Nokwapa nokwapa ma mima ya yopo wuchi siitiitar. Nokwapa nokwapa ma tarek, eena Jisas riita Jabiir yeechi paka i ye i yir. Jabiir pak tarek, ma mima ye pagiirebak eeka siitiitar. ");
INSERT INTO kmo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Worek, Jisas rii maji pokiitawa majin shiy tawa majik yenya sawo tar. Diita noma rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Na meeji ta. Ma por rii wit siiken nowok raboken ir. ");
INSERT INTO kmo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wit siiken rii rabotari, kaw nobok sakar. Sakatarek, apok yeechi atar. ");
INSERT INTO kmo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Siik kaw papa hek karakada nosap tar eemek eeka sakar. Sakarek, sii ameya sokwar. Karakada nosap tarek, eena ameya sokwar. ");
INSERT INTO kmo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sokwarek, ye piri, sii eeta reekiisiir. Nenya karakada tarek, eena reekiisiir. ");
INSERT INTO kmo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Siik kaw yamika tawa poko tar eemek eeka sakar. Yamika tawa poko sii sokwa witen gamu poyerek sii eena sokwakasakech. Omu wakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Worek, siik kaw eeta nosap kepik eeka sakar. Sakari, sii eeta sokwa, harapa siichi, omu harapa watar. Siik podat sii kaw 30 siik watar, kaw 60 siik watar, kaw 100 siik watar.” ");
INSERT INTO kmo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Worek, Jisas rii kawka eecha wor, “Na meeji: Kwo mabiya tawey, na meeji!” ");
INSERT INTO kmo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas riita saniga tarek, Jisas riita bar maji meejir ma kaw yecha 12 disaipel ma yechaka Jisas riitak yar. Yarek, ye Jisas riita shiy tawa majin kwodii woken eena woher. ");
INSERT INTO kmo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Worek, Jisas rii awasen eecha wor: “God riiti kigdom veenyi tawa boboyen siina eeta kwona har. Sabak tawa anadii ma ye shiy tawa majiban eena meejito. ");
INSERT INTO kmo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Yecha eena hechawey, ye hehasakech. Yecha wagatey tawey, ye meejikasakech. Yecha meejiney, yecha yechi inyaka God riina dareboyenak, God riipa yenya kwoyava yatakiita.’” ");
INSERT INTO kmo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Worek, Jisas riita yenya eecha woher: “Kwo diita shiy tawa majin kapo meejikasakech? Diina meejinan siiney, boyega kwo anadii shiy tawa majin meejikiita? ");
INSERT INTO kmo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ada diita shiya tawa majin kwona kwodii wok: Wit siiken rabo tawa ma rii eeta God riiti maji raboto. ");
INSERT INTO kmo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","God riiti maji nobok eeka saka tawey, ma kaw ye meejito. Ye meeji tawey, Gaba rii ya yeechi ye ichu: ");
INSERT INTO kmo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma mima kaw ye eeta wit siik tawaga eecha tawak, yecha eeta papa tawa eemek saka tawaga eeka sakato. Saka tawak, ye ameya kwoya hikitu. ");
INSERT INTO kmo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wowak, sii nenya ye ikasakech. Eena sii eechaba eechaba takasakech. Yenya pi kikir poyeney, kapasek otii tawa boboy yechak yaney, yecha akiichi heechitu. ");
INSERT INTO kmo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma mima kaw ye wit yamek tawa poko tawa eemek saka tawaga ye eechaba tawa. Ye God riiti maji meeji tawak, ");
INSERT INTO kmo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sokeaken otii tawey, diita nosapek tawa pokok genya gamu poyetu. Ye inyakapwa hiki tawey, moni yan yaken eena hiki tawey, anadii diita nosapek tawa gegiya tawa boboyen yaken eena hiki tawey, eecha otii tawey, eeta God riiti majin eena ji poyetu. Ji poye tawak eeta omu wakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wowak, anadii ma ye wit siik kaw kepi tawa nosapek sakachi sokwa tawaga ye eechaba otiito. Yecha God riiti majin meejichi ye eena yeechi omu wato. Watawak, 30, 60, 100 siik wato.” ");
INSERT INTO kmo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas rii kawka eecha wor: “Ma por rii lamun hayichi rii kapo awu bik tadiikiita? Rii kapo chey kuruk veenyekiita? Yaho. Rii cheyek ye yo yichikiita. ");
INSERT INTO kmo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Eyey boboy ye veenye tawey yepa eeka geenyek ya sayakiita. Eyey boboyen ma ye gamu poyeri, yepa eeka geenyek yasayakiita. ");
INSERT INTO kmo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kwo mabiya tawey, na meeji ta!” ");
INSERT INTO kmo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Rii yenya eechaba eecha wor: “Kwo mabiyak meeji tawey, eena na hehar hiki ta! Anadii man kwota kepi kapasekek otii tawaga, komas God riita kwona eechaba kepika kapasekeka otiikiita. Kwon harapa otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kata ma rii boboyeka tawey, boboy kawen riina kawka hakiita. Kata ma rii boboy biish tawey, riitaka tawa boboyen komas riina heechikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas rii kawka eecha wor: “God riiti kigdom eeta siik kawen nowok ma rii rabo tawak sokwa tawaga eecha sokwato. ");
INSERT INTO kmo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rii niyik wato. Yadii rii chishi ye ichu. Rii eecha otii tawak, siik eeta sokwato. Siik sokwatawa tobon rii hekasakech. ");
INSERT INTO kmo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nosap eeta otiichichawak, siik sokwaqchiniga omu watakiita. Kiipiika mapo sokwanak, siik wanak omu sii eeka komas wakiita. ");
INSERT INTO kmo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Siik niipiinak ma rii hechi arepiik dagiichi ye ikiita. Saga yatawa nediik eeka yar.” ");
INSERT INTO kmo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas riita eecha woher: “God riiti kigdom kapo shecha tawa? Boyen shiy tawa majin ada kwona mukuchitakiita? ");
INSERT INTO kmo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eeta mastet siik sii eeta kigdom eeta eecha tawa. Ma rii eena yeechi nowok chinyak, ");
INSERT INTO kmo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","siipa sokwanak eeta harapa siikiita. Siinak, siipa nowoka tawa eyey boboy siiken dagiir poyekiita. Sii eeta harapa tapaka eecha takiita. Tanak, apo yepa ya gwoyetawa eemek eeka wosii patiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas rii riiti majin ma mima yenya sawo tar. Sawo tarek, rii diita yikadey shiy tawa majin yenya eecha wor. Yecha hiki tawa woyekeeka yenya har. ");
INSERT INTO kmo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rii yenya batar maji shiy tawa majibak eeka batar. Worek, riiti disaipel yechaba riitaka eecha tarek, rii yenya eyey maji siikenen kwodii wochar. ");
INSERT INTO kmo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hogo eeta nediibak Jisas rii riiti disaipel yenya eecha wor, “Nota anadii pa yepak ik.” ");
INSERT INTO kmo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Worek, ye ma mima yenya heechi ir. Disaipel ye i Jisas riita yichar jabiirebak i yowur. Yecha riitaka eecha ir. Akar jabiir kaw iibak tar. ");
INSERT INTO kmo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Heechi icharek, harapa sowa mayaka yar. Yarek, jabiir uku siivii woyer. ");
INSERT INTO kmo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Worek, Jisas rii jabiir mu yepak eeka watar. Watarek, disaipel yecha riina i cheyechi eecha wor: “Tisa, mii nona hikikasakech? No kapo hak otiito.” ");
INSERT INTO kmo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Worek, Jisas rii sokwa sowa yatarin eecha wor: “Na sii!” Rii pan eecha wor: “Na sii!” Worek, sowa hamarek, pa eeta siir. ");
INSERT INTO kmo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Worek, Jisas rii yenya eecha wor: “Boyewak kwo akiita? Kwo kapo saka hiki siitii chichawak? Eena kwo akiita?” ");
INSERT INTO kmo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Worek, ye harapa akii tar. Ye awaqsen awasen eecha wor: “Diita ma rii kapo nama? Eeta sowa eeta uku boro yatari riiti kujan meejichi eeta siir!” ");
INSERT INTO kmo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Icharek, yecha Galili pa anadii yepak igayer. Gerasa nosap eeka igayer. ");
INSERT INTO kmo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Igayerek, jisas rii jabiir heechir. Heechirek, ma por rii ya riina jawor. Eeta ma por rii tiiriimo supu tarek eemek eeka yichar. ");
INSERT INTO kmo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kapasek spirit eeta ma riiti wok tar. Eecha tari, ma rii sen poko riin kiitiikasakech. ");
INSERT INTO kmo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mashi riiti tapan riiti yatiin sen pokok kiitiitari, rii neekiichi yatiika tar ain poko rrkiichi heechi ichar. Rii hapaga bor ma. Ma ye riina boyega neekiik wonyak. Niy yadii tiiriimobak rii eeka chishi ye itar. ");
INSERT INTO kmo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chishi ye itarek, riita harapa uwa chishi tarek, papak riiti moban papak tiimii ye itar. ");
INSERT INTO kmo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mashi ri yapak tarek, rii Jisas rii icharin rii her. Hechi rii amaba yar. Amaba yari, Jisas riiti yatii jumuk eeka hey yir. ");
INSERT INTO kmo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Hey yichi rii harapa uwar: “Jisas, mii howuka tawa harapa God riiti Yikapwa! Ada miiti yokasakech! God riiti hik ada miina wohecho: mii ana otii harapa kapa meejikasakech!” ");
INSERT INTO kmo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jisas rii mashi riina wor: “Kapasek spirit diita ma riitaka eecha tawey, riina na heechi.” Eena diita ma rii diita majin wochar. ");
INSERT INTO kmo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Worek, Jisas riita riina woher: “Miiti hi boy?” Rii awasen eecha wor: “Eeji hi, Ami. Nota kapasek spirit nokwapa nokwapa tawa.” Eena rii eecha wor, Ami. ");
INSERT INTO kmo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Worek, rii Jisas riina woyasachiyasa her, “Mii diita adaka tawa kapasek spirit yenya opoche yeechi yapak tawa eemek heechinak ichanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Worek, nokwapa nokwapa poyi kaw ye nedii kwowuk eeka aniga tar. ");
INSERT INTO kmo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kapasek spirit ye Jisas riina woyasachiyasa her: “Miita nona otiichinyak, nota keena i poyi yechaka eecha siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Worek, Jisas rii yenya heechirek ir. Kapasek spirit ye ma riina heechi sabak i poyi yechak iyarer. Iyarerek, eyey 2,000 poyi tari, ye heechi pak eyey i ye iri, eeta ha hamar. ");
INSERT INTO kmo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Poyin siitii kowu tar ma ye heechi akii ir. Akii iri ye akar eemek akar akamak i eecha otiir majin sawo ye itar. Worek, ma mima ye eeta boboyen heken ir. ");
INSERT INTO kmo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Irek, ye Jisas riitak yar. Yari, mashi eeta nokwapa nokwapa kapasek spiriteka tar ma riina her. Rii riki giiriichi yicharek, inyaka rii nagwa nagwa hiki tarek, ye riina herek, ye akii tar. ");
INSERT INTO kmo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eeta boboyen her ma ye hapasek spiritek tar ma riina otiirin, poyin otiirin ye yar ma mima yenya sawor. ");
INSERT INTO kmo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Worek, ma mima ye Jisas riina woher: “Diita nowap na heechi i!” ");
INSERT INTO kmo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Worek, Jisas rii jabiirek i ye yirek, mashi kapasek spiriteka tar ma rii Jisas riina woyasachiyasa her: “Ada miitaka eecha ibaken!” ");
INSERT INTO kmo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Worek, Jisas rii meejichi bokonar. Rii riina awasen eecha wor: “Miita na i miiti akamak miiti apoman miina Harapa riita otiitar boboyen napa geenyek kwodii wocha! Harapa riita miina rukusiitar majin na i geenyek kwodii wocha!” ");
INSERT INTO kmo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Worek, eeta ma rii i Dikapolis nosapek Jisas riita riina otiir boboyen eena sawotar. Sawotarek, eena meejir ma ye harapa heneba rabochi ye harapa hikitar. ");
INSERT INTO kmo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Worek, Jisas rii jabiirek iri i akar yepak ir. Irek, nokwapa nokwapa ma mima ye riitak ya yopo wuchi siitiitar. ");
INSERT INTO kmo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Worek, Jairas, Ju ma yechi lotu aka harapa tar ma, rii Jisas riitak yar. Yarek, rii Jisas riiti yatii jumuk ya yatii bogok putiichi hey yir. ");
INSERT INTO kmo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","24","Hey yichiniga, Jisas riina woyasachiyasa hechi eecha wor: “Eeji mima yikapwa sii haken otiito. Miita na ya miiti tapak eeji yikapwan howu neekinak, sii kepi siik!” Worek, Jisas rii riitaka eecha ir. Nokwapa nokwapa ma mima ye riitaka ichari, ye i riitaka eecha apoyer. ");
INSERT INTO kmo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Worek, mima pochi sii ibatari, siita kamu siitari, 12 sukwiya eecha otii tar. ");
INSERT INTO kmo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Otii tarek, nokwapa nokwapa dokta ye siina otii kepi siik wochi siiti moni ya eeta eyey yenya ha hamar. Wori, sii kepi siikasakech. Siita keena eechaba kapasek tar. ");
INSERT INTO kmo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sii Jisas riita otii tar boboyen meejichi sii yar. Yarek, eeta ma mima yechi nediik i Jisas riiti magiirek sumowuniga ibatar. ");
INSERT INTO kmo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sii mayama eecha wor: “Ada kapo riiti rikin howu neekinak, ana otii kepi siik.” ");
INSERT INTO kmo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Worek, sii riiti saketen neekirek, siita pi yatar boboy sii eeta ameya kepi siir. Sii meejir siiti maba eeta ameya kepiwey siir. ");
INSERT INTO kmo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Worek, Jisas riita ameya meejir riiti hapaga tar boboy eeta heechi ir. Heechi irek, rii dareboyechi kamakinyin vayeko hechi eecha wor: “Eeji saket kapo nama neeki hewa?” ");
INSERT INTO kmo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Worek, riiti disaipel ye riina eecha wor: “Mii hewa, nokwapa nokwapa ma mima ye miitaka eecha ichawey. Boyewak mii wohecho: nama miina neeki hewa?” ");
INSERT INTO kmo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Worek, Jisas rii way riina neeki her miman kawka vayeko her. ");
INSERT INTO kmo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Worek, eeta mima sii siina otiir boboyen sii her. Heri, sii akiichi Jisas riitak nubu nubuniga yar. Yari, sii Jisas riiti yatii jumuk sakar. Sakachi sii inyakak hikichi eyey boboyen sii geenyek kwodii wor. ");
INSERT INTO kmo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Worek, Jisas rii siina eecha wor: “Eeji yikapwa, niji hiki siitiichichawaq boboy sii eeta ninya otii kepi sowa. Na eshar i. Niji hak otii tar boboy sii eeta hamawa.” ");
INSERT INTO kmo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Diita majin Jisas rii batarek, ma kaw ye ya eeta majin eena yar. Jairas riiti akan heechi ye yar. Ye jairas riina eecha wor, “Miiti yikapwa sii eeta kiiriidiichir. Boyewak mii eeta Tisa riina wo wohecho?” ");
INSERT INTO kmo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yecha bar maji Jisas rii meejichi rii bokonar. Bokoneechi Jairas riina eecha wor: “Mii opoche eeta boboyen akiitanakech. Iiban na hiki siitiichicha.” ");
INSERT INTO kmo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Worek, rii ma mima kaw yen anachekerek, Pita, jems, riiti kumwoy, Jon, yechaban yeechi riitaka eecha ir. ");
INSERT INTO kmo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Worek, ye lotu harapa tar ma riiti akak i bana meejir. Ma mima ye harapa keya yesokwa tarek, meejir. Wasiigey rokotarek, her. ");
INSERT INTO kmo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Worek, Jisas rii iyar yenya eecha wor, “Boyewak kwo harapa keyato? Boyewak wasiigey harapa rokoto? Diita yikapwa sii saka harek. Sii biish wato?” ");
INSERT INTO kmo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Worek, ye riina wohega wosaboyetar. Worek, rii yen wochirek geenyek iyarer. Worek, rii har yikapwa siiti awin apokoka yeechi, riiti disaipel yechaka eecha yeechi, yikapwa watar aka wok yeeeka iyarer. ");
INSERT INTO kmo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Worek, Jisas rii yikapwa siiti tapak hey neekichi siina eecha wor: “Talita kumi.” Dareboyechi eecha wocho: “Yikapwa, ada ninya wocho: na sokwa!” ");
INSERT INTO kmo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Worek, sii ameya sokwar. Sokwachi chishiye itar. Sii 12 sukwiya siir. Worek, ye eena hechi ye harapa negarabor! ");
INSERT INTO kmo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Worek, Jisas rii yenya harapa eecha wor: “Diita boboyen opoche akar man sawo ye itanakech.” Rii kawka eecha wor: “Siina aboboyen na otii hava.” ");
INSERT INTO kmo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Worek, Jisas riita eetaeemen heechi riiti akama siikenek awasen ir. Riiti disaipel ye riina sumowuniga ibar. ");
INSERT INTO kmo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Worek, akamak siitawa nediik rii Ju ma yechi lotu akak maji pokiitar. Nokwapa nokwapa ma mima ye eeka tar. Ye eena meejichi heneba roabor. Ye eecha woher: “Eeta majin rii kapo siitak yar? Diita riina harek, riita hiki tawa boboy ii kapo boy boboy? Rii kapo boyega shecha mirakel otiito? ");
INSERT INTO kmo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Rii boy kamda tawa? Rii Maria siiti yikapwa. Riiti kumwoy eeta Jems, Josis, Judas, Saimon. Riiti mowey ye boy diika yichu?” Worek, eena ye riina wosowoyer. ");
INSERT INTO kmo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Worek, Jisas rii yenya eecha wor: “Piirapet por riiti hin eyey eem ii yesokwato. Wowak, riiti akama ma siiken ye riiti yaka kumwoy ye riiti magwi piirapet riiti hin yesokwakasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Worek, rii mirakel eeka saka otiirek. Worek, rii riiti tapak how neekiichi hak otii tar ma kawen otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Rii heneba rabor. Yecha saka hiki siitiichirek. Eena rii heneba rabor. Worek, Jisas rii anadii akama ta ye itarin, rii i maji pokiitar. ");
INSERT INTO kmo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Worek, rii 12 disaipel yenya uwarek, ye yar. Yarek, rii yenya upurus upurus heechirek ye i ye ir. Rii riiti hapaga tawa boboyen yenya harek, ye kapasek spiriten yeechi raboken eena i ye ir. ");
INSERT INTO kmo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Rii yenya wor: “Kwota inyak kububan na neeki i. Geyen ye ikasakech. Boboy woy tawa kwo ye ikasakech. Moni yan woy tawa kwok woyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yatii ii na ru. Riiki upurusen ye ikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Rii yenya kawka eecha wor: “Kwota inyak akama pochik iyarenak, ma yecha kwona hana aka eeta bak na ta. ");
INSERT INTO kmo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kwo akar akama pochik iyareney, yecha kwona akan hanan siiney, kwota bana majin meejinan siiney, ii na heechi nosap kwoti yatiik taweyn na kavakava pakachi heechi i. Wonyak, kwota eecha otiiney, yepa hikikiita nagwa nagwa mukuchi tawa boboy yechaka eecha yar.” ");
INSERT INTO kmo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Worek, disaipel yecha heechi sabak iniga kapasek boboy dareboy tawa majin eena sawo tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ye nokwapa nokwapa kapasek spiriten yeechi rabotar. Ye maba neeki tawa kwarek hak otii tar ma yenya otiiniga kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Worek, Herot, aka tabo yima, rii diita boboyen meejir. Jisas riiti he eyey eemek i ye yatarin rii eena meejir. Ma kaw ye eecha wor, “Jon Baptais rii saniyeechi sokwar. Eena diita hapaga sii tawa boboy riiti tapak sokwar.” ");
INSERT INTO kmo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Anadii ma ye eecha wor: “Rii eeta Ilaija.” Anadii ma ye eecha wochar: “Rii eeta mashi piirapet tarega eechaba tawa.” ");
INSERT INTO kmo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot rii diita majin meejichi rii eecha wor: “Rii eeta Jon Baptais! Ada riiti maseken reekiirek, rii eeta saniyeechi sokwar!” ");
INSERT INTO kmo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mashi Herodias sii Pilip riiti mima tar. Pilip rii Herot riiti kumwoy. Eeta nedii Herodias sii Herot riiti mima. Eecha tarek, eena Jon Baptais rii Herot riina eecha wochar: “Mii kumwoy riiti miman yawey, God riita saka kwoya hewak!” Herot riitaba eecha worek, Jon riina sen pokok jichi akak heechir. Herodias siita otiirek, Jon poko ji akak tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Worek, Herodias sii Jon Baptais riina yuyatarek, eena riina sowakwoken gegiyatar. Worek, Herot riita tari, sii saka kiki siirek. ");
INSERT INTO kmo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot rii Jon riina akii tar. Rii eecha hikir Jon rii eeta holi ma kepi, rii God riiti yon saniga otii tar ma, nagwa nagwa ichar ma. Eena rii Jon riina siitii kowu tar. Ma sowakwokasakech. Herot rii Jon riita ba tar majin eena meeji tarek, rii riiti inyaka nubu nubu tarek rii akii tar. Wocharek, rii eena Jon rii ba tar majin meejiken gegiyatar. ");
INSERT INTO kmo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Komas Herodias sii riina sowakwo nobon eecha her. Herot riina yimowur nediin rii eena harapa nokusha ar. Gavman harapa ma, ow ana pichar harapa ma, Galili nosapek tar harapa ma yecha nokusha abaken yar. ");
INSERT INTO kmo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ya arek, Herodias siiti mima yikapwa sii ya eeka hokwachi tosiir. Tosii tarek, Herot riita eeta ak yar ma yechaka eena kwoya hechar. Kwoya hecharek, aka tabo yima Herot rii eeta yikapwa siina eecha wor: “Nija boy boboyen yaken hiki taney ii na wonyak ada ninya hak.” ");
INSERT INTO kmo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herot rii mayama harapa maji ba rii ma howuchi eecha wor: “Ada ninya masewoyeri anapa nija wohenyak hakiita. Nicha eeji siita kowu tawa boboyen chipiin wohenyey, anapa ninya kaw hakiita!” ");
INSERT INTO kmo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Worek, yikapwa sii sabak i siiti awika eecha ir. Irek, sii awi siina eecha woher: “Boy boboyen adapa yaken wohekiita?” Awi sii meejichi awasen eecha wor: “Nija napa Jon Baptais riiti maseken ya.” ");
INSERT INTO kmo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yikapwa sii meejichi ameya ya aka tabo yima riina woher: “Ada hikitu miita Jon Baptais riiti maseken heebiyak woyechi ana ha!” ");
INSERT INTO kmo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Worek, Herot rii meejichi riiti inyaka harapa nomoyar. Worek, rii wochar maji barek, ma howuchi eecha worek, iibak yichar harapa ma ye meejibarek, eena rii woshakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Worek, aka tabo yima, rii soldia ma poren ameya heechirek rii i Jon Baptais riiti maseken yaken eena ir. ");
INSERT INTO kmo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldia rii heechi i poko jichar akak iyar Jon riiti maseken tiimii yeechi heebiyak woyechi yayar. Yayaniga eeta yikapwa siina har. Harek, yikapwa sii yeechi siiti awi siina har. ");
INSERT INTO kmo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Worek, Jon riiti maji pokiitar ma ye meejichi yaniga riiti maban yeechi tiiriimo supuk ye i chir. ");
INSERT INTO kmo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposel ma ye ya Jisas riitak yopo wuchi yicharek, yecha otii tar yo majin eena riina sawo tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Worek, nokwapa nokwapa ma mima ye Jisas riitak riiti disaipel yechaka yatar icharek, ye otii a nediikasakech. Worek, rii yenya eecha wor: “Na hawa akar eem ma biish tawa eemek eeka i yihapakak.” ");
INSERT INTO kmo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Worek, ye jabiiren yeechi yechaba ma biish tar eemek heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Worek nokwapa nokwapa ma mima ye yenya herek ye heechi ir. Eeta akama tar ma mima yenokwapa nokwapa akaman heechi nosapek mapo i Jisas riita jabiir ir gay eemek eeka kowu tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Worek, Jisas rii i gayechi nosapek i yowur. I yowuniga rii nokwapa nokwapa ma miman her. Rii yenya hechi harapa inyakapan hikir. Yecha sipsipega eecha tar siitii kowu makasakech eena rii inyakapa hikir. Hikichi rii yenya harapa majin sawo tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya yeyik otii tar nediik Jisas riiti maji pokii ma ye ya riina eecha wor: “Diita eem eeta ma biish tawa eem. Eeta hogo siik. ");
INSERT INTO kmo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wowak, diita ma mima yenya na heechinak, sa i yey. I yeyinak, aboboyen tokochi sa a.” ");
INSERT INTO kmo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisas rii awasen eecha wor: “Kwota keena na yenya hava.” Yecha riina awasen eecha woher: “Mii kapo eechahikitu: nota i geyen 200 dola yak tokochi yayaniga diita ma yenya havakiita?” ");
INSERT INTO kmo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Worek, Jisas rii yenya eecha woher: “Kwo gey shasha tawa? Ne i he.” Worek, ye i hechi ya riina awasen eecha wor: “Gey yokotapa tawa. Emiyep upurus tawa.” ");
INSERT INTO kmo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Worek, Jisas rii yenya eecha wor: “Ma mima ye sa woheja kepik saniga saniga yopochichi yi ye i ta.” ");
INSERT INTO kmo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Worek, ma mima ye yichari, kaw 100 ma, kaw 50 ma eecha eecha yichar. ");
INSERT INTO kmo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Worek, Jisas rii geyen yokotapa yeechi neekichi rii neren mo hechi God riina woshiar. Woshieechi rii geyen reekiichi riiti disaipel yenya harek, ye eeta ma mima yenya homachichi hapoy pakar. Worek, emiyep piirin eechaba reekii reekiich eyey ma mima yenya hapoy pakabar. ");
INSERT INTO kmo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Worek, yecha ari eeta kiki siir. ");
INSERT INTO kmo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Worek, disaipel yecha kiki siirek heechir gey kaw emiyepika eecha 12 wasahaya kwowuk woyechiniga yichir. ");
INSERT INTO kmo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eeta geyen ar ma ye 5,000 ma. ");
INSERT INTO kmo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisas riita ameya yenya wochirek, ye jabiirek i yeyichi Betsaida akamak eeka mapo iken ir. Betsaida sii kata yepak tar. Worek, rii ma mima yenya wochirek ye heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eyey heechirek ye irek rii heechi kwowuk yo i God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hogo sii nediik jabiir pa nediik watarek, Jisas rii pagiirebak howu i siitiitar. Riitaba saniga tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Worek, Jisas rii her sowa harapa yari eeta jabiiren pichar. Picharek, ye eyik katari harapa yo otii tar. Worek, uhadii nediik Jisas rii pa hebak howu piitii i yenya i heechi mapo iken otii tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Irek, disaipel yecha riita pa hek howu icharek yecha riina hechi eecha wor: “Ka kapo Gaba!” Yecha harapa uwar. ");
INSERT INTO kmo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yecha harapa akii tarek, eena uwar. Worek, jisas rii ameya yenya eecha wor: “Na hapaga sii. Dii ada yato. Opoche akiitanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Worek, rii i jabiirek yowurek, sowa yatari eeta siir. Worek, disaipel yechi inyaka wopu eeta heneba rabochi harapa hiki tar. ");
INSERT INTO kmo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisas riita geyen otiirin yecha otiir mun saka hiki tarek. Yechi marenoku eena Jisas riin saka hehar herek. ");
INSERT INTO kmo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas rii riiti disaipel yechaka i Genesaret pak eeka igayer. Igayerek, yecha jabiir pokok pi seechir. ");
INSERT INTO kmo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Seechirek, ye jabiir heechi i yowurek, ma mima ye Jisas riina ameya her. ");
INSERT INTO kmo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Worek, yecha eyey akamak i ye yar. I ye yarek, akamak hak otii tar ma yen yemek jichichi kiya kiya yari Jisas riita tar eemek yaya seechi ye ir. ");
INSERT INTO kmo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas rii nowo tar eemek, aka tar eemek, akama tar eemek, eeka har chishi ye itar. Chishi ye itarek, ma mima ye hak otii tar ma yenya riitak ye ichar. Awabatar eemek ye i seechi tar. Ye i seechi tarek, ye Jisas riina woyasachiyasa hechar: “Diita hak otii tawa ma yepa miiti saketen tapak kapo neeki hekiita.” Ma kaw ye riiti saketen neeki her ye eeta kepi siir. ");
INSERT INTO kmo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Perisi ma ye Ju ma yechi lo maji pokiitawa ma kaw yechaka Jerusalem akaman heechi yar. Yari, Jisas riitaka eecha yopo wuchi siitiir. ");
INSERT INTO kmo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Worek, yecha her: Jisas riiti disaipel kaw ye yechi tapan Perisi yechi tapan uku yeetii tawabaga saka eecha yeetii tarek. Perisi ye eecha wor: disaipel ye tapan uku yeetiichi akasakech. ");
INSERT INTO kmo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Perisi ma ye akar Ju ma yechaka yechi wayega yechi nobon sumowutu. Sumowu tawak ye yechi tapan Ju ma yechi wayega yechi tapan otii tawabaga eecha otiinan siiney, yecha aboboy akasakech. ");
INSERT INTO kmo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ye awaba tanak aboboy tokoney, aboboyen ukuk panebiyanan siiney yecha sakapa akiitawak. Yecha anadii wayega yecha har nokwapa nokwapa loban eena sumowutu. Een sumowu tawak, ye heebiya, awo, kapa awo, cheyen ye eena yeetiito.) ");
INSERT INTO kmo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Worek, Perisi ma ye Ju ma yechi lon Tisa tar ma yechaka Jisas riina woher: “Boyewak miiti disaipel ye wayega yechi nobon saka sumowu tawak? Ye tapan ukuyeetiichi kiya noku akasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Worek, Jisas rii yenya awasen eecha wor: “Piirapet Aisaia rii kwona mashi keyichiri, rii maji siikenen keyichir. Rii keyiri eecha wocho kwo eeta woshepii tawa ma. Rii eecha keyir. ‘God rii eecha wocho: Diita ma mima ye yechi kujabak eeji hin biish shebo shebo habato. Yechi inyaka wopu ana esiinato. ");
INSERT INTO kmo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yecha eeji hin sobo biish habata. Yecha maji eecha pokiitu: mak otii tar lon ye eecha wocho ii eeta God riiti lon no mukuchichu. Eena yecha God riiti hin sobo biish habato!’ ");
INSERT INTO kmo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Worek, Jisas rii kawka eecha wor: “Kwo God riiti lon heechirek, kwo eena ma yecha otii tawa abon eena sumowutu.” ");
INSERT INTO kmo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Rii kawka eecha wor: “Kwo keena God riiti majin wosowoy tawey, hehar otii hecho. Kwo kwoti loban eena sumowuken gegiyato. Eena kwo God riiti majin nasiiwoyetu. ");
INSERT INTO kmo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses rii eecha wor: ‘Kwo na awi apoko yechi kuruk ta. Ma por rii awi apoko piiriin hin kapasek habaney, eena riin pi sowakwo.’ ");
INSERT INTO kmo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Wowak, kwo maji eecha pokiitu: ‘Ma por rii awi apokon kiyatay boboy taney, rii eecha wonyey: dii eeta God riiti, ii sa awi apoko kayek sii.’ ");
INSERT INTO kmo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwota eecha otiichi akar man pikiitawey, ii kwo God riiti majin kwo nasowoyetu. Kwo diita yikadey yon nokwapa nokwapa otiito.” ");
INSERT INTO kmo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Worek, Jisas rii ma mima yenya uwarek, ye yarek, rii maji eecha wor: “Kwota ana na meejichi na hiki ta. ");
INSERT INTO kmo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sabak tawa boboy sii ma riiti sugu wopu wok inyey, sii man otii kehakasakech. Yaho. Ma riiti sugu wopuk tawa boboy siita geenyik ya sayawey siita ma riin otii kehato. ");
INSERT INTO kmo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Kwota mabiyaka tawey ii napa meeji.)” ");
INSERT INTO kmo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Rii eeta ma mima yenya heechi rii aka wok heechi ir. Heechi irek, riiti disaipel ye riita bar shiy tawa majin woher. ");
INSERT INTO kmo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Woherek, rii yenya eecha woher: “Kwoti marenoku kapo biish tabato? Kwo boy hikikasakech? Sabak tawa boboy ma yechi sugu wopu wok inyey, iipa saka man otii kehakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yechi inyakak ikasakech. Yechi suguk eeka ichi sii awasen sabak ya saya ichu.” (Jisas riita diita majin bari, rii eecha wor: eyey kiya noku napa a ta.) ");
INSERT INTO kmo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Rii kawka eecha wor: “Eeta boboy sii man heechi yasaya otiiniga kehato. ");
INSERT INTO kmo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ma yechi inyaka kapasek hiki tawey, hikichi otii tawey, ye ya saya diita kapasek boboy eecha otiito: ye hiyi yatawey, pi sowakwo tawey, ");
INSERT INTO kmo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","23","nobo miman anemesh roko tawey, nokwapa nokwapa boboyen kwoya hechawey, kapasek boboy otii tawey, woshepii maji bo tawey, yama yama chishi tawey, inyaka kapasek hiki tawey, man wosiiboy tawey, hikisha yesha inyaka hiki tawey, hikisha tawa boboy hiki tawey, sii eena ya sayaniga eecha otii tawak, eena otiiniga kehato. ");
INSERT INTO kmo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas rii eeta akaman heechi Taia akama nosapek ir. Iri rii aka podat tarek eeka iyarer. Ma riina henyak tanan eena yuyar. Worek, rii veenyikasakech. ");
INSERT INTO kmo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mima pochi sii eeka tari siiti mima yikapwa sii kapasek spiriteka eecha tar. Nokwapa sii meejir Jisas rii eeka tari, sii meejichi Jisas riitak yar. Yari, Jisas riiti yatii jumuk saka heyi yir. ");
INSERT INTO kmo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yirek sii Jisas riina woyasachiyasa woher: “Eeta kapasek spirit eeji yikapwak taweyn eena na yeechi rabo.” Diita mima sii akar nosap pochik tar mima. Siin Pinisia akama Siria nosapek eeka siin yimowur mima. ");
INSERT INTO kmo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Worek, Jisas rii awasen diita shiy tawa majin siina eecha wor: “Nota mapo yikapwan napa hava ta. Opoche no yikapwa yechi aboboyen yeechiniga asan rabochichanak atanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Worek, sii awasen riina eecha wor: “Harapa Ma, eetata eecha otiito. Yikapwa eechi rabo tawa chepii asa chey kuruk taweyek yecha ato.” ");
INSERT INTO kmo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Worek, Jisas rii meejichi eecha wor, “Nija eeta yikadey majin awasen bawey, na heechi niji akamak i. Eeta kapasek spirit sii eeta niji yikapwak tari sii eeta heechi ir!” ");
INSERT INTO kmo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Worek, sii heechi siiti akamak i her yikapwa siiti cheyek watarek her. Kapasek spirit eeta ir. ");
INSERT INTO kmo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Worek, Jisas rii Taia akamak bana bana tar nosapen heechi ir. Heechi irek, Saidon akama i heechi Dikapolis nosapen i heechi Galili Pak iyarer. ");
INSERT INTO kmo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iyarerek, ma kaw ye ma poren Jisas riitak yayar. Riiti mabiya gii siitiitar. Riiti tarekwoy paretar. Yecha riina yayaniga Jisas riina woher: riita riiti tapak neeki hek eena woyasachiyasa her. ");
INSERT INTO kmo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Worek, Jisas riita ma mima yenya heechi riitaban saniga yeechi ye ir. Ye ichi rii riiti tapak mabiyan gwayechi rii sagwiyan piichi ma riiti tarekwoyen how neeki her. ");
INSERT INTO kmo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Worek, Jisas rii neren mo hechi rii biikiipoyechi eeta ma riina eecha wor: “Epata.” Diita maji siiti mu eecha wocho: ‘Na tagwa!” ");
INSERT INTO kmo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Worek, ameya eeta ma rii mabiya tagwar. Riiti tarekwoy danegwar. Worek, rii maji kepi batar. ");
INSERT INTO kmo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Worek, Jisas rii yenya anacheketar diita otiir boboyen yecha anadii man sawo mukuchinakech. Anacheke tari, ye meejichi eena geenyik harapa kwodii wo ye ichar. ");
INSERT INTO kmo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Meejitar ma ye harapa nyegarabochi eecha wor: “Riita otii tawa boboy eeta kepi boboyeban eena otiito! Rii otiiniga mabiya giitawa ma eeta meejito, tarekwoy par tawa ma eeta maji kepi bato!” ");
INSERT INTO kmo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Eeta nedii ameda siirek, nokwapa nokwapa ma mima ye kawka ya yopo wuchi yichar. Aboboy hamarek, Jisas rii riiti disaipel yenya uwarek ye ya riitaka eecha siitiir. ");
INSERT INTO kmo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Worek, rii eecha wor: “Diita yawa ma mima yenya ada harapa inyakapwa hikitu. Yadii piiriichar yecha adaka eecha siiri ye aboboyekasakech. Ye kaw yapa eemek taren yar. ");
INSERT INTO kmo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ye eechi hatawak, ada yenya heechinak inyey, yepa kaponobok i sakakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Worek, riiti disaipel yecha riina woher: “Nota diita ma biish tawa eemek ya tawey, nopa aboboy siitan tokochi yenya havakiita?” ");
INSERT INTO kmo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas rii yenya eecha woher: “Kwo gey kapo shasha heechitu?” Ye awasen eecha wor: “7 gey tawa.” ");
INSERT INTO kmo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Worek, rii ma mima yen wochirek ye nosapek hey yi ye ir. Yi ye irek, rii 7 gey yeechi, God riina woshiachi, reekiichi disaipel yecha homachi haken har. Harek, ye eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Worek, emiyep kaw tabatar. Worek, Jisas rii eena woshiachi disaipel yenya eecha wor: Eetayo, na homachi hapoy paka. ");
INSERT INTO kmo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Worek, eyey ma mima ye achi eeta kiki siir. 4,000 ma mima eeka tar. ");
INSERT INTO kmo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Worek, ye ari kiki siirek, kaw yopo yichi 7 wasahaya kwowuk woyer. Worek, Jisas rii ma mima yenya wochirek ir. ");
INSERT INTO kmo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Worek, rii ameya riiti disaipel yechaka eecha ijabiirek ye ichi Dalmanuta nosapek eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Worek, Perisi ma kaw ye Jisas riitak ya awasen awasen ow majin batar. Ye Jisas riina biish apo diigiichi ba hechar. Ye Jisas riina mirakel otiiken wohechari, riita mirakelen otiinak God riita riina hechi wohowuken eena wochar. ");
INSERT INTO kmo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Worek, Jisas rii biikiipoyechi eecha wor: “Boyewak diita eyey ma mima ye mirakelen otiikeneena wowohecho? Ada kwona wocho, yaho. Diita ma mima yenya God rii mirakel otii mukuchikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Worek, rii yenya heechi jabiirek i ye ichi yepak iken eena sayarer. ");
INSERT INTO kmo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pak ichari, disaipel ye geyen yaken otiiri abosuchi heechi ir. Geyen podateba jabiir wok tar. ");
INSERT INTO kmo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas rii yenya eecha wor: “Na ow poy sii ta! Perisi yechi yis, Herot riiti yis eena na ow poy sii ta.” ");
INSERT INTO kmo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eena yecha awasen awasen eecha wor: “Gey no biish eena rii eecha wor.” ");
INSERT INTO kmo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yecha batar maji Jisas rii hikir. Eena rii eecha woher: “Boyewak kwo eecha ba ye itu, no geyekasakech? Kwo o boy saka hikitawak? Kwo marenoko kiiriide siitiito? ");
INSERT INTO kmo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kwota miyika tawa. Kwo boy saka hechawak? Kwota mabiyaka tawa. Kwo boy saka meejitawak. Kwo boy kapo abosuchetu? ");
INSERT INTO kmo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eeta nediik ada yokotapa geyen 5,000 ma miman reekiichi hapoy pakar i kapo wasahaya kwow shasha kwo yeechi yichir?” Ye awasen eecha wor: “12.” ");
INSERT INTO kmo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisas rii kawka eecha woher: “Eeta nediik ada geyen 4,000 ma miman reekiichi hapoy pakar i kapo wasohaya kwow shasha kwo yeechi woyechi yichir?” Ye awasen eecha wor, “7.” ");
INSERT INTO kmo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kwo heri kwo eena o boy saka hikitawak?” ");
INSERT INTO kmo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Worek, yeecha Betasida akamak iyarer. Iyarerek, ma kaw ye miy dumur ma poren Jisas riitaka yayar. Yayarek, ye Jisas riita eeta ma riina tapak neeki heken woher. ");
INSERT INTO kmo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Worek, Jisas rii miy dumur ma riiti tapan howu neekir. Neekichi rii sabak ye ir. Akaman heechi ir. Worek, rii eeta ma riiti miyin rii sogwiyak piir. Piichi Jisas rii riina riiti tapak howu neekichi riina eecha woher: “Mii boy boboyen kapo hecho?” ");
INSERT INTO kmo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Worek, eeta ma rii mey maka hechi eecha wor: “Ada man hechawey, me chishinaga ada eecha hecho.” ");
INSERT INTO kmo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Worek, Jisas rii riiti tapak eeta ma riiti miyin kawka how neeki her. Worek, eeta ma rii hehar he siitiichichi, miy otii kepi siirek, rii eyey boboyen eeta hehar her. ");
INSERT INTO kmo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Worek; Jisas rii eeta ma riina riiti akak heechirek ir. Rii riina eecha wor: “Mii akamak iyarekasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Worek, Jisas riita riiti disaipel yechaka eena heechi Sisaria Pilipai eeta nosapek tawa akama ye eeka ir. Nobon icharek, rii yenya eecha woher: “Ana na wo, ma mima ye ana shecha wocho an kapo nama?” ");
INSERT INTO kmo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ye awasen eecha wor: “Ma kaw ye eecha wocho, mii eeta Jon Baptais. Anadii ma ye way eecha wocho, mii eeta Ilaija. Anadii ma ye way eecha wocho, mii eeta piirapet por.” ");
INSERT INTO kmo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jisas rii meejichi eecha woher, “Kwo tawey kwo shecha hikitu, ada kapo nama?” Worek, Pita rii awasen eecha wor: “Mii eeta Kraist.” ");
INSERT INTO kmo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Worek, Jisas rii yenya anachekechi wor: “Anadii ma pochi sawotanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Worek, Jisas rii riiti disaipel yen maji pokiitar. Rii eecha wor: “Ma Yikapwa rii harapa kapa meeji tawa boboyen eena sapa kiya ta. Ju yechi harapa ma ye, opelen otii tar ma ye, lon maji pokii tawa ma ye, Ma Yikapwa riina sapa magiirechicha. Riina sowakwokiita. Sowakwonak, riipa yadii piiriichar siichinga saniyeechi awasen yesokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Diita maji riita yenya geenyik kwodii wor. Worek, Pita rii Jisas riina yeechi anadii eemek ye i riina wosawo tar. ");
INSERT INTO kmo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Worek, Jisas rii dareboyechi riiti disaipel yenya hechi Pita riita bar majin eena wosowoyechi eecha wor. “Mii Gaba, mii na eejimagiirek na ye i. Miita hiki tawa boboy eeta ma yechi yin mii eena hikitu. Eeta God riitikasakech!” ");
INSERT INTO kmo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Worek, Jisas rii ma mima yen riiti disaipel yechaka eecha uwachi eecha wor: “Ma por rii adaka eecha ik otiiney, rii sapa riiti nobon mayama heechi abosuchiniga rii sapa riina har yon kiyachiniga ana sumowu ta. ");
INSERT INTO kmo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma por rii riiti popoyen egesii taney, riipa sii siiken siikiita. Ma por rii riiti popoyen ana haney, hadabas maji kepin sawo tawa yon eena haney, riipa popoy kepiweyn yeechi riipa eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma por rii eyey diita nosapek tawa boboyeban ya hamaney, riiti popoyen heechiney, kapo rii boyen yar? Yaho. Eeta sii siiken. ");
INSERT INTO kmo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma ye popoyen tokokasakech. ");
INSERT INTO kmo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Diita nedii ma mima ye harapa kapasek yo otii tawey dii eeta God riin wosowoye tawa nedii ma por rii eeji majin hiibiya yaney, ana hiibiya yaney, komas riipa Apoko God riiti hadabas boboyek eeka riiti ejel kepika yanak, Ma Yikapwa adapa riina hibiya yakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rii kawka eecha wor: “Diita majinopoche abosuchitanakech. Ma kaw ye diika tawey, yecha hakasakech, ye tanak, God riiti hapaga tawa kigdom eena hekiita.” ");
INSERT INTO kmo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Komas 6 de siirek, Jisas riita Pita, Jems, Jon yechaban yeechi harapa hisaw kwowuk neeki ir. Irek, yecha riina hecharek, riiti maba diireboyechi siir. ");
INSERT INTO kmo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Riiti riki sii diireboyichi apoma siibar. Diita nosapek tawa ma eechaba otii apoma hekasakech. ");
INSERT INTO kmo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Worek, disaipel piiriichar ye her Ilaija, Moses piir Jisas riitaka maji eecha ba tar. ");
INSERT INTO kmo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Worek, Pita riita maji yesokwa bar. Jisas riina eecha wor: “Tisa dii eeta boboy kepinota diika tawey, nota karakada aka piiriichar otiik. Mi pochi. Moses ri pochi. Ilaija ri pochi.” ");
INSERT INTO kmo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Rii, piiriita, akii tarek rii ri maji hikikasakech, eena eecha wor. ");
INSERT INTO kmo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Worek, hejagwayap yarek, yenya ya gamur. Gamurek, hejagwayap punyetarek uwar aya eecha wor: “Dii eeta eeji kwoyawoy hechawa yikapwa. Riiti majin napa meeji ta!” ");
INSERT INTO kmo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Worek, ye ameya he ye iri, ma hekasakech. Jisas riitaba yechaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Worek, ye kwowun heechi ya sakar. Ya saka tarek, Jisas rii yenya eecha wor: “Kwota hewa boboyen kwo opoche anadii man batanakech. Ma Yikapwa rii haniga saniyeechi kawka sokwanak eeta nediik napa eeka sawo ta.” ");
INSERT INTO kmo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ye miiti majin meejichi eena sumowur. Worek, ye awasen awasen ba tar: “Diita haniga saniyeechi kawka sokwa maji iiboy maji?” ");
INSERT INTO kmo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Worek, ye Jisas riina woher: “Boyewak lo majin pokii tawa ma ye eecha wocho: mapo Ilaija rii sapa ya?” ");
INSERT INTO kmo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Rii awasen eecha wor: “Ayo, boyewak mashi keyir maji eecha wocho: Ma Yikapwa rii sapa harapa kapa meeji tanak riina sapa wosoboy ta? ");
INSERT INTO kmo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ada kwona wocho: Ilaija rii yar. Yarek, mashi keyir maji eecha wochowey, ma mima ye riina eyey boboyen riina otiiken otiiri, ye riina otiir.” ");
INSERT INTO kmo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Worek, ye i anadii disaipel yechaka siir. Siirek, ye her nokwapa nokwapa ma mima ye eeka tar. Lon maji pokii tar ma ye disaipel yenya ow majin awasen awasen ba tar. ");
INSERT INTO kmo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma mima ye Jisas riina hechi ye negiirabachi amaba i riina woshiatar. ");
INSERT INTO kmo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Worek, Jisas rii yenya woher: “Kwo yechaka boyen majin bato?” ");
INSERT INTO kmo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Worek, ma por rii eeta ma mima yechi nediik tari rii Jisas riin awasen eecha wor: “Tisa, eeji yikapwa spirit kapasekeka eecha taweyn ada miitak yayawa. Ri kuja maji bakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kapasek spirit rii yikapwan pichichi nosapek raboto. Rabotawak, sogwiya kujak piitiiwoy pu takiiviikiikiirena siitiichichu. Wowak, riiti maba eeta kiikiita siitiito. Ada miiti disaipel woheri, yecha eena kikisiichi yeechi rabokasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Worek, Jisas rii yenya eecha wor: “Kwota hiki siitiichichawa boboyekasakech. Kapo shasha nedii ada kwotaka takiita? Kapo shasha nedii ada kwoti nomon kiyakiita? Yikapwan adaka na yaya!” ");
INSERT INTO kmo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Worek, ye yikapwan Jisas riitak yayar. yayarek, kapasek spirit rii Jisas riina hechi yikapwan kapasek otiirek, yikapwa rii nosapek sakar. Sakachi nosapek jimo jemo chishitari sogwiya kujak yatar. ");
INSERT INTO kmo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Worek, Jisas rii eeta yikapwa riiti apoko riina woher: “Kapo siitayek nediik eecha otiir?” Apoko rii awasen eecha wor: Rii yibarega tarek eeka siir. ");
INSERT INTO kmo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eechaba nedii rii yikapwa riina sowakwoken otii hechi hik yeechi raboken otii hechi, pak raboken otii hechar. Eena mii kiki siiney, miita nona na inyakapa hikichi kiyatayechi na badiigiichi!” ");
INSERT INTO kmo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Worek, Jisas rii eecha wor: “Ayo, miita kiki siiney iipa otiikiita. Ma por rii hiki siitiichiney, riipa keena otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Worek, apoko rii ameya eecha wor: “Ada hiki siitiichichawey, sii eeta tobo. Eena ana na miita kiyatay!” ");
INSERT INTO kmo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Worek, Jisas rii her ma mima ye eyey ameya ya riitaka bana bana siitiir. Eena rii kapasek spiriten eena eecha wor: “Ma kujan diimii tawa spirit ma mabiya giitawa spirit, mii yikapwan na heechi saya sabak ichi kawka iyarekasakech!” ");
INSERT INTO kmo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Worek, eeta spirit rii harapa uwachi yikapwan kawka wadesiichi heechi saya sabak ir. Irek, yikapwa rii ha tawa maga eecha her. Herek, ye eecha wor: “Rii eeta ha siiken hawa!” ");
INSERT INTO kmo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Worek, Jisas rii riiti tapak neekichi eeta sokwaken kiyatayichirek, rii sokwa siitiir. ");
INSERT INTO kmo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Worek, Jisas rii aka porek iyareri riiti disaipel riina veenyichi eecha woher: “Boyewak nota diita spirit kapaseken saka yeechi rabowa?” ");
INSERT INTO kmo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas rii yenya awasen eecha wor: “God riina wohechawa boboy siitaba saniga otiito. Anadii boboy sii saka kiki siikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Worek eeta eemen yecha heechi ye Galili nosapek ieeka chishitar. Eeka tari, Jisas rii eeka i tari ma riina i henyan rii yuyar. ");
INSERT INTO kmo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Rii riiti disaipel yenya maji pokiiken gegiyatar. Eena rii yuyatar. Rii eeta yenya eecha wor: “Ma Yikapwa riin ma yechi tapak how hakiita. How hanak, yecha riina sowakwokiita. Sowakwonak, yadii piiriichar siinak, God riita riina otii saniyeechi kawka yesokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Worek, yecha riita bar maji mun saka hiki tarek. Worek, ye akiirek, eena ye saka riina woherek. ");
INSERT INTO kmo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Worek, ye Kapaneam akamak iyarer. Iyarerek ye aka porek i siir. I siirek, Jisas rii riiti disaipel yenya eecha woher: “Kwo nobok ichari, kwo boy majin ba ichar?” ");
INSERT INTO kmo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wori, ye saka awasen barek. Yecha nobok ichari harapa ma sii man eena ba icharek, eena saka awasen barek. ");
INSERT INTO kmo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Worek, Jisas rii yi 12 disaipel yenya wo yayar. Yayarek, rii yenya eecha wor: “Ma por rii harapa ma siiken otiiney, rii sapa i komas nobo ma sii. Rii sapa yon eyey man kiyatayi ma sii.” ");
INSERT INTO kmo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Worek, rii karakada yikapwa poren tapak yeechi ye i yechi misomak eeka siitiichir. Worek, Jisas rii riiti tapan yesokwa yikapwan neeki rii yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ma por rii eeji yon eeji hik otiiken hikiney, rii jecha tana yikapwa poren yaney, ii riipa ana eechaba yakiita. Eecha otiiney, riipa ana heechirek yar Apoko riina eechaba yakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon riita Jisas riina eecha wor: “Tisa, nota her ma por rii miiti hik kapasek spirit yeechi raboto. Worek, nota riina anacheker. Eecha otiiri riita nona sumowukasakech. Eena riina anacheker.” ");
INSERT INTO kmo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Worek, Jisas rii awasen eecha wor: “Opoche riina anacheketanakech. Ma por rii mirakel eeji hik otii taney, riipa ana ameya wosoboyekasakech. ");
INSERT INTO kmo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ma rii nona pinyan siiney, rii eeta noti nareboy. ");
INSERT INTO kmo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Diita majin na makebek heechi: Kwota Kraist riiti yon otii tawey, ma por rii eena hikichi kwona ukun havaney, rii komas hadabas boboyen yakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ana hiki siitiichichawa karakada yikapwan eena na hiki ta. Ma por rii kapasek boboyen otiichiwey, diita yikapwa rii eeji nobon heehci inyey, ii napa riiti borewagii papak kiitichi somakwotii tawa pak heechinak sa ye i. ");
INSERT INTO kmo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Miiti tapak kapasek boboy otii taney, ii na yiipa tiimii rabo. Eeta kepi miiti tapan tiimii raboney, mii howuk tawa hadabas eem kepik iyarekiita. Eeta kapasek tapa upurus siik gegiyaney, ii miipa hi uwu tawa eemek ikiita. Eeta hi ha i hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Eeka yechi owugiir hakasakech. Eeta hi ha ikasakech.) ");
INSERT INTO kmo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Miiti yatii siita miina otiichinak kapasek boboyen sakaney, ii na tiimii rabo. Eeta kepi miiti yatiin tiimii raboney, mii howuk tawa hadabas eem kepik iyarekiita. Eeta kapasek yatii upurus siik gegiyaney, iipa miina yeechi hi uwu tawa eemek rabokiita. ");
INSERT INTO kmo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Eeka yechi owugiir hakasakech. Eeta hi ha ikasakech. ");
INSERT INTO kmo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Miiti miy siita miina otiichinak, miita kapasek boboyeka sakaney, ii na miy hor yeechi rabo. Eeta kepi mii God riiti kigdom miy podatebak iyarekiita. eeta kapasek miy upurus taken gegiya taney, iipa miina hi uwu tawa eemek rabochinyak ikiita. Eeka yechi owugiir saka hekiitawak. Eeta hi saka ha ikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Eyey ma kwona higa tawa boboyek, woshiga tawa boboyek otiichichanak kwota eeka mak siikiita. ");
INSERT INTO kmo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Woshi eeta otiichichawa boboy kepi. ");
INSERT INTO kmo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wowak, woshi siita somakwotii tawa boboy hamaney, kwopa kapo shecha otiinak siipa kawka somakwotakiita? Woshi sa kwoti wok tanak, kwo napa kwoti yaka kumwoy yechaka eecha hehar yicha.” ");
INSERT INTO kmo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Worek, Jisas rii eeta eemen heechi rii Judia nosapek eeka ir. Iri, rii Jodan Pa heechi yepak ir. Worek, nokwapa nokwapa ma mima ye riitak yar. Riitak yarek, rii yenya mashi maji pokiitarega rii yenya eechaba pokiitar. ");
INSERT INTO kmo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Worek, Perisi ma kaw ye riitak yar. Yarek, ye riina kapasek otiiken eena apo diigii hechar. Eena yecha riina eecha woher: “Miita nona na wo. Eeta lo ii boy ma por rii riiti miman sayi heechinak ikiita?” ");
INSERT INTO kmo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas rii meejichi awasen eecha woher: “Moses rii kwon boy lon har?” ");
INSERT INTO kmo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ye awasen eecha wor: “Moses rii nona saka anachekerek. Rii eecha wor: miman sayi heechinak ik otiiney, rii sapa jeyen mapo keyichi heechanak i.” ");
INSERT INTO kmo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Worek, Jisas rii yenya eecha wor: “Kwota marenoku hapaga eena Moses rii eeta jey eena keyichi har. ");
INSERT INTO kmo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wowak, tasiir nedii, God rii eyey boboyen otiirek, God riita maka mimaka eecha taken eena otiir. ");
INSERT INTO kmo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Eena ma por riiti awi eepi heechi i mimaka eecha sa ta. ");
INSERT INTO kmo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tanak, piir eeta podabak takiita. Wowak, piir saniga saniga takiisakech. Piir podat tawa. ");
INSERT INTO kmo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eena God riita chegek heechiri, ma kwo opoche eena sayichinak i ya yatanakech.” ");
INSERT INTO kmo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Worek, yecha aka wok awasen iyarerek, disaipel ye Jisas riita bar majin woher. ");
INSERT INTO kmo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Woherek, Jisas rii yenya eecha wor: “Kata ma por rii riiti miman sayi heechinak inyak, rii way akar miman yaney, rii riiti mayama miman kapasek otii heechinak ikiita. ");
INSERT INTO kmo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Eechaba mima sii siiti ma riina yuyeechi heechi i akar man siiney, sii mayama eechaba kapasek eecha otii heechinak ikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ma mima kaw ye karakada yikapwa yenya yaya Jisas riitak riiti tapak neekiken eena yayar. Worek, disaipel yecha hechi yenya ow maji bar. ");
INSERT INTO kmo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Worek, Jisas rii hechi kwotayechi disaipel yenya maji eecha wor: “Yikapwan heechinak sa adak ya. Opoche anachekatanakech. God riiti kigdom eeta yikapwaga eecha tawa ma yechi. ");
INSERT INTO kmo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Opoche abosiichitanakech. Kata ma rii God riiti kigdom eemek iken gegiyaney, rii sapa yikapwaga eecha, siichi i. ");
INSERT INTO kmo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Worek, rii yikapwa yen tapak saniga saniga yeechi neeki i yenya God riina rukusii majin bachitar. ");
INSERT INTO kmo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Worek, jisas rii ik otiirek, ma por rii amaba ya yatii bogok putiichi Jisas riina woher: “Tisa kepi, ada boyega shecha otiinak adapa eechaba eechaba takiita?” ");
INSERT INTO kmo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas rii awasen eecha wor: “Boyewak mii ana eecha habato: an kepi? God podareba riita eeta kepi. ");
INSERT INTO kmo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lo majin miita hikitu: ma por pi sowakwotanakech. Nobo miman opoche anemesh rokotanakech. Hiy opoche yatanakech. Woshepii maji batanakech. Mey boboyen opoche kwoya hechi ya tanakech. Awi eepi yechi hin na kwoya ba ta.” ");
INSERT INTO kmo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kata ma meejichi eecha wor: “Tisa, ada yibarega tarek, ada diita lon, sumowu tari diita apa.” ");
INSERT INTO kmo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Worek, Jisas rii riiti misoman hehar mey maka hechi rii rukusii tarek eecha wor: “Miita wonyak, miita harapa yan hevenek yakiita. Wowak, na ya. Ana na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Worek, kata ma rii meejichi riiti misoma eyepii siitiir. Riiti inyaka nomoyaniga ir. Boyewak? Riiti ya, saga eeta harapa tarek eena rii eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Worek, jisas rii har he ye ichi disaipel yenya eecha wor: “Eeta ma ye nokwapa nokwapa boboyek tawey, rii God riiti kigdom iyarek otiiney, hisaw yo otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Riiti disaipel ye riiti maji meejichi heneba rabor. Worek, jisas rii kawka eecha wor: “Yikapwa. God riiti kigdom ik otiiney, hisaw yon otiikiita! ");
INSERT INTO kmo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel siita riki kapa tawa go siiti supuk iyarek otiiney, yo yeechi iyarekasakech. Nokwapa nokwapa boboy saga tawa ma rii God riiti kidgom iken otiney, hisaw yo yaniga ikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Worek, disaipel ye meejichi harapa heneba rabor. heneba rabochi ye awaqsen awasen maji woher: “Kapo naman God rii yesokwa yichikiita?” ");
INSERT INTO kmo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas rii yenya hehar hey riitiichi eecha wor: “Diita yon ma saka kiki siikiitawak. God rii eeta kiki sowa. Eyey boboyen God riita keena otikkita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Worek, Pita rii eecha wor: Na he. Nota eyey boboyen heechi nota miina sumowutu.” ");
INSERT INTO kmo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas rii awasen eecha wor: “Ayo. Ada kwona wocho: Eeta ma ye yechi akan heechiney, yaka kumwoy, moweyn heechiney, medaya heechiney, nokwapa apokon heechiney, yikaowan heechiney, nosapen heechiney, eeji majin eeji hik sawoken otiiney, ");
INSERT INTO kmo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","riipa diita nosapek harapa boboy kepin yakiita. Riipa akan, yaka kumwoyen, medayan, moweyn, awin, yikapwan, nosapen 100 harapa yakiita. Wonyak, yechak kikir poy tawa boboyen yabanak, akar nedii yanak yecha eeka eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nokwapa nokwapa ma ye apak mapo ichawey, koma nedii yecha komas yakiita. Nokwapa nokwapa ma ye apak komas ichawey, ye koma nedii ye mapo ikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Worek, ye Jerusalem Akama nobok icharek, jisas rii mapo tarek, riiti disaipel ye riina heneba robochi akiiniga sumowu ichar. Ma mima ye komas sumowu akiiniga ibatar. Worek, jisas rii kawka 12 disaipel yechaban yeechi rii yenya riitak yak otii tar boboyen eena sawor. ");
INSERT INTO kmo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rii eecha wor: “Na he. Nota Jerusalem akamak ichu. Ichanak, Ma Yikapwa riina harapa apelen otii tawa ma yechi tapak, lon maji pokiitawa ma yechi tapak how hakiita. ");
INSERT INTO kmo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","How hanak, ye pi sowakwo maji apo diigiichi anadii tawa ma ye riina wosaboy tanak riina sogwoyak piichi yamika tawa poko yeechi pichanak, riina sowakwo hakiita. Sowakwo hanak yadii piiriichar siichi riipa kawka saniyeechi ya sokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Worek, Jems, Jon, Sebedi riiti yakapwa, piir Jisas riitak yarek, piir Jisas riina woher: “Tisa, miita boboy podateban sinya otiichiken si eena gegiyato.” ");
INSERT INTO kmo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Worek, Jisas riin awasen eecha woher: “Boy boboyen aka kinya shecha otiichiken ki ana wohecho.” ");
INSERT INTO kmo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Piir meejichi eecha wor: “Miita miiti hadabas kigdomek kepi tiikiirek yinyak sicha kapoeechaba por miiti mama yepak yinyak por yeeji yepak yibakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas rii piiriin eecha wor: “Ki diita boboyen saka hehar otii hechawak, kicha ana wohewey. Kata kapa meeji tawa boboyen ana gamu tanak eena kipa boy kapa kiki siinak kiyabatakiita?” ");
INSERT INTO kmo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Worek, piiriita eecha wor: “Shi eeta kiki sowa.” Jisas rii piiriina eecha wor: “Ayo, ada kapa meeji tawa boboyen adapa komas kiyak otiiney, kipa eechaba kiyabakiita. ");
INSERT INTO kmo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wowak, eeta ma piir eeji mama yepak, yeeji yepak yiken otiiney, ii eeji yokasakech. God riitaba diita tiikiir upurusen ma piiriina sayarechiri, riipa piiriina hakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Worek, anadii disaipel 10 diita majin meejichi ye Jems, Jon piiriina kwotayetar. ");
INSERT INTO kmo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Worek, Jisas rii yenya uwa ye yeechi eecha wor: “Kwo hikitu diita nosap siitii kowu tawa ma ye anadii harapa tawa ma yechaka ye eeta ma mima yenya dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kwo eena hechawey, ii kkwoti nobokasakech. Ma por kwotaka tawey, rii harapa siiken gegiya taney, rii sapa anadii ma yechiyo otii ma sii. ");
INSERT INTO kmo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma por kwotaka tawey, rii mapo i ma siiken gegiya taney, rii sapa eyey ma yechi yo otii wakasa ma sii. ");
INSERT INTO kmo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wowak, Ma Yikapwa rii yari, saka mak riinayo kiyatayechiken yarek. Yaho. Rii yari, rii anadii man kiyatayechiniga riiti mabak nokwapa nokwapa ma mima yenya tokochiken eena yar. ");
INSERT INTO kmo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Worek, yecha Jeriko akamak iyarer. Jisas riita riiti disaipel yechaka, nokwapa nokwapa ma mima yechaka eechaik otii tarek, miy kiitiitar ma por, riiti he Batimias, Timias riiti yikapwa, riita nobo barek yiniga moni yan aboboyen eena wo wo hechar. ");
INSERT INTO kmo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Rii meejir Nasaret Jisas rii siitii tarek, rii meejirek, riieena uwar: “Jisas, Devit riiti neja, miita ana na rukusiita!” ");
INSERT INTO kmo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Worek, nokwapa nokwapa ma mima yecha riina anachekechi eecha wor: “Kuja na diim!” Worek, rii harapa uwar: “Devit riita neja miita ana rukusii ta!” ");
INSERT INTO kmo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Worek, Jisas rii meejichi rii i siitiir. Siitiichi rii eecha wor: “Riina na uwa yaya.” Worek, ye miy kiitii tar ma riina uwa yayar. Ye riina eecha wor: “Miiti inyaka sa kepi siinak na kwoya hiki. Na sokwa, riita miinauwa yayato.” ");
INSERT INTO kmo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Worek, rii riiti saket yapakeechi heechi sokwa siitiichi Jisas riitak i bana bana siitiir. ");
INSERT INTO kmo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Worek, Jisas riita riina woher: “Boy boboyen ada miina otiichiken mii eena gegiyato?” Worek, rii meejichi awasen eecha wor: “Tisa, ada kawka mey maka heken eena gegiyato.” ");
INSERT INTO kmo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Worek, Jisas rii riina awasen eecha wor: “Na i. Miitaq hiki siitichichawa boboy siita miina otii kepi sowa.” Worek, rii ameya miy mey makachi rii Jisas riina sumowuniga eecha ir. ");
INSERT INTO kmo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yecha i Jerusalem akama bana bana yatarek, Betpasi akamak bana tarek, worek, ye Oliv kwowuk iyarer. Worek, Jisas rii riiti disaipel upurusen heechirek mapo ir. ");
INSERT INTO kmo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Heechirek, irek, Jisas rii piiriina eecha wor: “Mapo tawa akama na heechi i. Ki iyarenak, ki i hadiiyey donki hek. Diita donki ma por riiti magiirek saka yi chishi tarek. Donki siin pokok ji siitiichichar. Ki i eena henyak, napa heema yeechi diika yaya. ");
INSERT INTO kmo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wonyak, ma por rii kinya wohenyey, ‘Boyewak ki eecha otiito?’ riina napa eecha wo: ‘Eeta Harapa Ma riita diina dopoto. Yo otii hamanak rii awasen yayanigadiibak heechikiita.’” ");
INSERT INTO kmo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Worek, piir heechi i donki pochin nobok her. Aka nuburejak eeka pokok ji siitiichicharek, piir her. Herek, piir i pokon heema tarek, eeka bana bana siitii tar ma por rii eecha woher: “Ki heema tawey, boyaken otiito?” ");
INSERT INTO kmo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Worek, Jisas riita piiriina wochirek iniga piir riina eechaba worek, rii meejichi piiriina wochirek, ");
INSERT INTO kmo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","piiriita yeechi Jisas riitak ye ir. Ye irek, yecha yechi saket kwoyava yeechi donki magiirek kowu heechirek, Jisas rii yow eeka yir. ");
INSERT INTO kmo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Worek, nokwapa nokwapa ma mima ye yechi saket kwoyavachi nobok yichi ir. Anadii ma ye nowok ichari me tapaban reekiichi yaya nobok seechir. ");
INSERT INTO kmo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Worek, ma mima kaw ye mapo tarek kaw ye komas tarek yecha harapa aya uwaniga eecha wochar: “God riiti hin napa yesokwa ta! Diita ma riita God riita God riiti hik yatawey, God miita riina na rukusii ta! ");
INSERT INTO kmo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","God miita diita yatawa kigdom kepin napa rukusii ta. Diita eeta noti wayaga, Devit, riiti kigdom. God riiti hin na yesokwa ta!” ");
INSERT INTO kmo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas rii iri Jerusalem akamak iyareri, rii Ju ma yechi harapa lotu aka wok iyarechi eyey boboyen he ye ir. Eeta hogo nedii sii tarek eena rii riiti disaipel yechaka heechi Betani akamak ir. ");
INSERT INTO kmo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iyi yadii nediik yecha Betani Akama heechi yatarek Jisas rii eecha har. ");
INSERT INTO kmo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eecha harek, rii pek men her. Kiipiikaka eecha tar. eecha tarek, Jisas rii omun hek iri, hipurek. Omu wa nediikasakech. Kiipiikabak tar. ");
INSERT INTO kmo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Worek, eena rii eecha wor: “Ma rii niji omun kawka akasakech!” Worek, riiti disaipel yecha meejir. ");
INSERT INTO kmo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yecha Jerusalem iyarechi Ju ma yechi lotu aka wok iyarechi Ju ma yechi lotu aka wok iyarechi moni ya yon otii tar ma yenya rii pi poy pakachirek, moni yan awasen awasen toko tar ma yechi cheyen otiichirek yaka eecha yogotii sakar. Nurer toko tar ma yechi tiikiiren eechaba otiichirek sakar. ");
INSERT INTO kmo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Worek, rii yenya anacheker eeta yikadey boboyen yecha tebel akak yeechi ye i yayarenakech. ");
INSERT INTO kmo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Worek, rii ma mima yenya maji pokiichi, rii eecha wor: “God riiti mashi keyir maji eecha wor: ‘Eeji aka eeta eyey ma mima yecha God riina maji ba tawa aka.’ Wowak, kwo hiy yatawa ma yechi akaga eecha otii tar!” ");
INSERT INTO kmo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Worek, harapa opelen otii tar ma ye, lon maji pokiitar ma ye Jisas riita eecha otiir majin meejir. Eena meejichi riina pi sowakwo nobon eena yesha tar. Worek, yecha riin akii tar. Eyey ma mima ye Jisas riita ba tar majin heneba rabochi kwoya meeji tarek, eena yecha akii tar. ");
INSERT INTO kmo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Worek, hogo niy sii nedii sii tarek, Jisas rii riiti disaipel yechaka eecha akaman heechi geenyik ir. ");
INSERT INTO kmo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eeta hediik uhadiirek, yecha nobok ichari, ye pek men heri sii eeta reekii siir. Kiipiikaka neejika eyey reekii siir. ");
INSERT INTO kmo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita rii otiir boboyen hikichi rii Jisas riina eecha wor: “Tisa, na he. Pek men miita harapoa majin bari sii eeta har!” ");
INSERT INTO kmo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas rii yenya awasen eecha wor: “Na hechi diina na hiki ta. ");
INSERT INTO kmo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Miita God riina hiki siitiichichaney, miita keena diita kwowun banak, na sokwa somakwotii tawa pak duru. Miita sokwa tawan bawa majin miita hiki siitiichichaney, miiti inyaka inyakapwa hikinan siiney, iipa miina God riita otiichikiita. ");
INSERT INTO kmo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eena ada kwona wocho: Miita God riina boboyen wohechaney, ii na hiki ta, miita eeta yar. Eecha hiki siitiichinyey, iipa miin hakiita. ");
INSERT INTO kmo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Miita siitii God riina majin ba tawey, ma por riita kapasek boboyen miina otiirega, mii riita otiir boboyen na abosuchi. Miita eena abosuchiney, miita howuk tawa Apoko rii miiti kapasek boboyen abosuchikiita. ");
INSERT INTO kmo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mii anadii ma yecha miina kapasek otii tawa yon abosuchinan siiney, miiti howuk tawa Apoko rii miiti kapasek otii tawa boboyen saka abosuchikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Worek, yecha Jerusalem akamak kawka awasen yar. Jisas rii Ju ma yechi lotu akak i yar chishi tarek, opel otii tar harapa ma ye, lo majin pokiitar ma ye, lotu akan kowu tar apoko saba ma ye riitak yar. ");
INSERT INTO kmo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yari, riina woher: “Kapo nama miina hisiirek, diita yon miita otiito? Kapo boy hapaga tawa boboy miitaka tawak, miita diita yon otiito?” ");
INSERT INTO kmo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Worek, Jisas rii awasen yenya eecha wor: “Ada kwona maji pochin wohek. Kwota ana awasen nagwa nagwa baney, ada kwonapa ana hisiir man wokiita. ");
INSERT INTO kmo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ana na wo. Kapo nama Jon riina hisiirek, riita ma mima yenya uku yeechi tar? Kapo God riita hisiirek, kapo mak hisiirek?” ");
INSERT INTO kmo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yecha meejichi ye awasen awasen ow maji ba tar. Ma kaw ye eecha woher: “Kapo boy majin bak? No awasen baney, ‘God riita riina hisiir,’ rii awasen bak, ‘Worek, boyewak kwo saka Jon riina hiki siitiichirek?’ ");
INSERT INTO kmo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","No awasen baney, ‘Mak hisiir,’ boyega shecha otiik wonyak?” Eyey ma mima yecha eecha hiki tar Jon rii eeta piirapet. Worek, Ju yechi harapa ma yecha ma mima yenya akii tar. ");
INSERT INTO kmo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Worek, eena Ju ma yecha Jisas riina awasen eecha wor: “No saka hechawak.” Worek, Jisas rii yenya eecha wor: “Ada eechaba kwona wokasakech, nama ana hisiirek, ada diita yon otiito.” ");
INSERT INTO kmo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Worek, Jisas rii yenya shiyi tawa majin wor. Rii eecha wor: “Ma por rii tarek, rii wain siik nowo chichi, inyi jichi wain ukun ya harapa awan otiichi, hiyiya man siitii kowu aka pochi otiibar. Worek, rii riiti nowon ya yo otii tar ma yenya how har. How heechi rii akar eemek heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain siiken siikiir ediik nowo ma rii wakasa ma poren heechirek ir. Nowo ma riiti boboy saga kawen yeechi yayaken nowon ya otii tar ma yenya eena wochirek ir. ");
INSERT INTO kmo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rii yarek, nowon yo otii tar ma ye riina yeechi neekiichi pi heechirek rii biish shebo shebo ir. ");
INSERT INTO kmo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Worek, nowo ma rii anadii wakasa ma poren heechirek ir. heechirek ir, nowon otii tar ma ye way eeta ma poren maseken tapachi riin kapasek boboy otiir. ");
INSERT INTO kmo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Worek, nowo ma rii anadii wakasa ma poren kawka heechirek iri yecha riina pi sowakwo har. Yecha nokwapa nokwapa wakasa ma yen eechaba kaw pirek, kaw sowakwo har. ");
INSERT INTO kmo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Worek, ma podar dagii rabo taren, heechinak iken otii tari, rii eeta nowo ma riiti rukusii tar yikapwa. Komas nediik, worek, nowo ma rii riiti yikapwan nowon otii tar ma yechak heechirek ir. Rii mayama eecha wor: ‘Yichapa eeji yikapwa riita bana majinmeejikiita.’ ");
INSERT INTO kmo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Worek, nowon yak tawa yikapwa rii irek, nowon otii tar ma ye riina hechi awasen awasen maji bachi eecha wor: ‘Dii eeta nowo ma riiti yikapwa. Na ya hawa pi sowakwoken. Sowakwochi nowo eeta nota yak.’ ");
INSERT INTO kmo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Worek, ye yikapwa riina pi sowakwachiniga yeechi nowo tamek ye i rabor.” ");
INSERT INTO kmo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Worek, Jisas rii kawka eecha wor: “Wowak, nowo ma riipa kapo boyen otiikiita? Riipa diina otiikiita. Riipa yanak, nowon otii tawa ma yen pi sowakwo hamachi nowon riipa yeechi anadii ma kawen hakiita. ");
INSERT INTO kmo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“God riita mashi keyir maji chepen kwo kapo eena saka kenyitawak. Diita maji eecha wocho: ‘Kata papan aka yon otii tawa ma yechayeechi rabori, rii sokwa aka mushik mapo seechi papa kepik siir. ");
INSERT INTO kmo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eeta boboy eeta Harapa Ma riita otiir. Otiirek, nota hechawey, eeta hadabas kepiwey hecho.’” ");
INSERT INTO kmo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yecha Jisas riina yeechiniga pokok jiken otii her. Yecha hikitar Jisas riita shiy tawa majik yenya ba tar. Eena pokok jiken otii tar. Wori ye saka otiirek. Yecha ma mima yenya akiir. Eena saka otiirek. Yecha heechi ir. ");
INSERT INTO kmo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Worek, Perisi ma kaw yen Herot riiti magwi kaw yen heechirek iri ye i Jisas riitak ir. Jisas riina apo diigiichiniga kapasek boboyen wohechi otiiken eena heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yecha riitak yari ye riina woher: “Tisa, nota hikitu mii maji siikiineban ba tawa ma. Miita anadii ma mima yecha miina hiki tawa boboyen mii eena hikichi akiikasakech. Harapa hi howuk tawa ma ye karakada sobo tawa ma yen miita yechaka yechaka eecha saniga saniga otiikasakech. Yaho. Miita God riiti nobo siikenen, God riita ma yecha otiiken gegiya tawa boboyen miita eena maji pokiitu. Miita nona na ba: eeta kepi kapo kapasek no noti takis yan Sisa riina boy hak? Nota boy riina haken ii boy sakapa hakiitawak?’ ");
INSERT INTO kmo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Worek, Jisas rii meejichi yecha riina apo diigii tar majin rii hikichi yenya awasen eecha wor: “Boyewak kwo ana kapasek otii apo diigii diigii hecho? Moni ya pochin na yeechi yaya ana hanak ada hek.” ");
INSERT INTO kmo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Worek, ye moni ya pochin yeechi yaya riina mukuchirek, rii yenya eecha woher: “Ii namey mayik tawa? Namey hika eecha tawa?” Worek, ye awasen eecha wor: “Eeta Sisa riiti.” ");
INSERT INTO kmo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Worek, Jisas rii eecha wor: “Ii Sisa riiti boboy ii na riina ha. God riiti boboy ii na God riina ha.’ Worek, yecha riita bawa maji meejichi hikichi heneba rabor. ");
INSERT INTO kmo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi ma kaw ye Jisas riitak yar. Sadyusi ma ye eecha wocho: “Ha tawa ma ye awasen yesokwakasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yecha Jisas riina eecha wor: “Tisa, Moses rii diita lo majin nona keyichir: ‘Ma por rii hanak, mima sii taney, yikapwa biish taney, eeta hana ma riiti yaka kumwoy rii mibiya mima siina sa ya. Yaney rii har ma riiti sen sa por kiyachi.’ ");
INSERT INTO kmo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mashi 7 yaka kumwoy ye eecha tar. Ye eecha tarek, yaka rii mima pochin yar. Yari, sii yikapwa saka por kiyarek, rii sobo har. ");
INSERT INTO kmo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Worek, riiti kumwoy rii way eeta mima siina yar. Yari, sii yikapwa saka por kiyarek, rii sobo har. Nedii ma rii way eeta mima siin yar. Rii sobo harek bor riitaka yar. Eyey 7 yaka kumwoy ye eeta mima siina ya tari hari yikapwa por kiyakasakech. Tarek, komas siita har. ");
INSERT INTO kmo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Worek, wonyak, awasen yesokwak tawa nedii sokwanak, har ma ye saniyeechi awasen yesokwanak, kapo nama siina yakiita? Eyey yaka kumwoy ye siina ya hama tar. Eena nota wohecho kapo nama siina yakiita?” ");
INSERT INTO kmo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas rii yenya awasen eecha wor: “Kwo hikisha tawak eena kwo majin nagwa nagwa bakasakech. Kwota kapasek hiki tawa boboyen kwo eena hekasakech. God riiti majin kwo God riiti hapaga tawa boboyen kwo eena hekasakech. Eena kwo hikisha bato. ");
INSERT INTO kmo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Har ma yen God riita yesokwa yichanak, yecha hevenek tawa ejelebaga eecha siikiita. Eecha siinak ma ye miman yakasakech. Mima ye eechaba man yakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wowak, har man awasen yesokwa yichi majin ada kwona bak. Kwo boy kapo God riiti majin Moses rii keyiri men hik uwuri majin kwo kapo kenyikasakech? Kata noma eecha wocho: God rii Moses riina eecha wor: ‘Ada Ebraham riiti God, Aisak riiti God, Jekop riiti God.’ ");
INSERT INTO kmo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Maji mu eecha wocho: Ma ye yenya har ma habato. God riita yenya tawa habato. Wowak, rii tawa ma yechi God. Kwota hiki tawey, eeta hikishawey tawa boboy!” ");
INSERT INTO kmo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Worek, lo majin pokiitar ma por rii eeka tarek, ow majin ba tari, rii meejir. Meejichi rii her Jisas rii Sadyusi ma yenya maji kepin awasen ba tarek, rii ya Jisas riina eeta majin woher: “Bwimey lo siita eeta harapa mayaka?” ");
INSERT INTO kmo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas rii meejichi awasen eecha wor: “Diita lo siita eeta harapa mayaka. Isrel ma kwo ana na meeji! Eeta Harapa Ma kwoti God, riita eeta podarebawey. ");
INSERT INTO kmo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wowak, eeta Harapa Ma kwoti God riina kwoti inyaka wopu, kwoti maba tapa, riina na rukusii ta. ");
INSERT INTO kmo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Komas, God riiti lo pochi diitata: Kwota mayama rukusii tawaga, kwo kwotaka bana bana tawa man no eechaba rukusiiba ta. Akar lo pochi sii piiriina dagiir poyikasakech.” ");
INSERT INTO kmo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Worek, lo maji pokiitar ma rii Jisas riina eecha wor: “Tisa, miita bawa maji eeta kepiwey. Eeta maji siiken Eeta Harapa Ma rii eeta God podareba wey tawa. Akar god takasakech. ");
INSERT INTO kmo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Eena ma rii riiti inyaka wopu, maba tapa God riitaban sa rukusii ta. Riita mayama rukusii tawaga, rii riitaka bana bana tawa man sa eechaba rukusiiba ta. Ma ye diita lo maji upurusen sumowu taney, sii eeta harapa, kepi. Ma ye opelen hik tuku taney, anadii boboyen God riina ha taney, sii eeta harakada.” ");
INSERT INTO kmo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kata ma rii nagwa nagwa hiki tawa majin awasen ba tari Jisas rii eena meeji tarin rii riina eecha wor: “Miita God riiti kigdomek bana bana tawa.” Worek, ma ye Jisas riina wohenyan akiir. ");
INSERT INTO kmo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas rii Ju Ma yechi harapa lotu akak maji pokiitari, rii ma mima yenya woher: “Boyega lo majin pokiitar ma ye eecha wocho, eeta Kraist rii Devit riiti neja siikiita? ");
INSERT INTO kmo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Eeta Holi Spirit rii Devit riina otiichirek, Devit rii eecha wor: ‘God rii eeji Harapa Ma riina eecha wor: Na ya eeji mama yepak yichanak, Ada miina ow ana pichawa boboyen yeechi piitii neetiichinyak miiti yatii kwuruk seechikiita.’ ");
INSERT INTO kmo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit rii Kraist riina eecha habatar, ‘Harapa Ma.’ Wowak, boyega eeta Kraist Devit riiti neja?” Eeta ma mima ye diita majin meejiri yechi inyaka kwoya woy hiki ye ir. ");
INSERT INTO kmo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas rii yenya maji pokii tari rii eecha wor: “Lo maji pokii tawa ma yenya na ow poy sii ta. Yecha harapa rikin gworowen ruwuchi chishi ye itaken gegiya tarek, yecha awaba eemek ichawak ma mima ye woshiya ye inyak yechi hin wohowuchichu. Eecha otii tawak yecha eena kwoya woy hikitu. ");
INSERT INTO kmo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yecha lotu aka ichawey, ye i harapa tiikiirek yiken eena gegiyato. Yecha nokusha aken ichawey, ye i eechaba tiikiir kepibak eeka yichu. ");
INSERT INTO kmo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yecha mibiya mima yenya woshepiichi yechi akan boboyen hiyik yatar. Yecha God riina maji baken otii tari ye woshepiichi harapa maji gworowen batar. Eecha otii tarek, yecha harapa kapan meeji takiita.” ");
INSERT INTO kmo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas rii Ju ma yechi lotu aka moni yan heechi tar eemek bana bana yichar. Bana bana yicharek ma mima yecha yaniga yechi moni yan heechi tar eemek eeka woyetar. Woye tarek, rii hechar. Hecharek, nokwapa nokwapa moni yak tar ma ye yari harapa yan woyer. ");
INSERT INTO kmo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Worek, mibiya mima pochi sii yari, sii moni yan karakada ya pochin woyer. Sii kiiriisiiposii tar mima. ");
INSERT INTO kmo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Worek, rii riiti disaipel yenya uwa yayar. Yayarek, rii yenya eecha wor: “Ada kwona wocho: diita kiiriisiiposii tawa mibiya mima siita woyer moni ya eeta harapa. Anadii ma ye woyer ya sii eeta karakada. ");
INSERT INTO kmo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Boyewak? Moni yaka tawa ma yechi ya kaw anadii tar. Mibiya mima siiti ya kaw takasakech. Eeta sii eyey woyer. Aboboy toko tar moni yan eeta sii eyey har.” ");
INSERT INTO kmo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas rii harapa lotu akan heechi icharek, riiti disaipel por rii eecha wor: “Tisa, na he! Diita akan otiir harapa papan kwoya hecho!” ");
INSERT INTO kmo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Worek, Jisas rii awasen eecha wor: “Kwo boy diita akan hecho? Komas eyey papa yen rakiichi rabo poy hamakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas Oliv Kwowuk eeka yicharek, harapa lotu aka giiriibak tarek, her. Worek, Pita, Jems, Jon, Endru, yechaba Jisas riitak yar. ");
INSERT INTO kmo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Yarek, yecha Jisas riina woher: “Nona na ba. Siitayekega diita nediik yakiita? Nona na wo: diita boboy sokwaken otiiney, boy boboyen nona mapo mukuchikiita?” ");
INSERT INTO kmo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Worek, Jisas rii yenya maji pokiir: na ow poy sii ta. Ma por iipa kwona woshepiikiita! ");
INSERT INTO kmo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nokwapa nokwapa ma yepa eeta ya eeji hik eecha wokiita: ‘Ada eeta Kraist!’ Eecha baney, ye nokwapa nokwapa man woshepiikiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wowak, kwota ow ana pichawa boboyen harapa meejiney, bana bana tanak, meejiney, yapak otiina boboy meejiney, kwo opoche eena akiitanakech. Diita boboy sii sapa sokwa ta. Wokwa taney, dii eecha wokasakech hama tawa nedii diita yato. Yaho. ");
INSERT INTO kmo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Anadii nosapek tawa ma yepa anadii eemek tawa man ana pichakiita. Anadii aka tabo yima riiti wakasa ma yepa akar aka tabo yima riiti wakasa man ow ana pichakiita. Eyey eem iipa ninyaw ya takiita. Eecha ha tawa boboy sii yaba takiita. Diita boboy sii mima sii yikapwa yimowuk otii tawaga mapo kapo meejitawaga eecha meejikiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kwota keena mayama na ow poy sii ta. Ma kaw ye kwona yeechi anasa takiita. Ma kaw ye kwona yeechi ye i lotu akak pichakiita. Kwota eeji hik aka tabo yima yechi misomak, harapa ma yechi misomak siitiichi hadabas maji kepin yenya sawo takiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","God riiti majin mapo sapa eyey ma mima eyey eemen sawo ta. ");
INSERT INTO kmo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yecha kwona yeechi anasanak, kwo opoche kwota ba tana majin sayarechi hikik otiitanakech. Yaho. Eeta nedii yanak, kwona hana majin eena napa ba ta. Kwota bana maji eeta kwotikasakech. Holi Spirit riita wochinak, kwopa ba takiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Eeta nedii ma kaw ye yechi yaka kumwoy akar ma yechi tapak howu hanak, yecha pi sowakwokiita. Eepi ye yechi yikapwan eechaba otiikiita. Yikapwa yepa yechi awi eepin diireboyechi otii sowakwokiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Eyey ma ye kwona harapa yun ya takiita. Eeji hi kwotaka eecha tawak eena kwona yuyakiita. Wowak, ma por rii eechaba kapa meeji tawa boboyen kiya taney, i hamak tawa nediik siiney, God riita riina yesokwa yichikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kwo komas kapasek woy tawa boboyen hekiita. Sii eem pochik eeka siikiita. Eeka siinak, ii eeta kapasek eeka sii tanak, ii kapasek woy boboy ya gamukiita. (Diita majin kenyi tawey, kwo na hehar meeji) “Eeta nedii yanak, Judia nosapek tawa ma ye sapa heechi amaba kwowuk i. ");
INSERT INTO kmo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma kaw ye akak tawey ye opoche ya saka aka wok tawa boboyen yar yeechi ye ichanakech. ");
INSERT INTO kmo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nowak tana ma kaw yepa opoche i akak yar yechi saket yeechi ye ichanakech. ");
INSERT INTO kmo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Eeta nedii yikapwa kiya mima yenya harapa inyakapwa mayaka hiki takiita! Yikapwa muku heechi tawa mima yenya harapa inyakapwa mayakan hikiba takiita! ");
INSERT INTO kmo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kwota na God riina wohechanak, eeta boboy sii harapa niikiiriiya nedii saka yakiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eeta nedii yak tawa kapasek boboy eeta harapa mayaka woy boboy yakiita. Diita harapa kapasek yikadey boboy sii mashi sokwakasakech. Yaho. Mashi mashi God riita diita nosapen otiir nedii, apa, komas diita kapasek boboy mayaka sii kawka sokwakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eeta Harapa Ma rii diita kapasek nediin tiimii poyinak, tobo kada siikiita. Riita tiimii poyinan siiney, eyey ma mima ha hamakiita. God riita riiti hisiir ma mima hikichi eena eeta nediin tiimii poyir. ");
INSERT INTO kmo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Diita nedii yanak, ma por rii kwona diita majin baney, ‘Na he cha. Kraist rii diita diika tawa.’ Kaw eecha wonyey, ‘Na he. Kataka tawa.’ Eecha wonyey, opoche eena hikitanakech. ");
INSERT INTO kmo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kraist riiti hik woshepii tawa ma yecha sokwakiita. Woshepii piirapet ye sokwaba takiita. Ye sokwanak, yecha harapa ya kepin otii takiita. Ye mirakel otiiba takiita. Ye God riita hisiir ma mima yenya woshepiichi kapasek nobon mukuchi taken eena eecha otiikiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eena na ow poy sii ta! Ada mapo kwona wor: kapasek boboy komas yanan.” ");
INSERT INTO kmo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Diita kapasek nedii hamanak, eeta ya sii niyiga siinak, niiwiika sii buyakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Winyumay yecha eyey sakakiita. Howuka hapaga tawa boboy winyumay eeka tawey, eeta yechi nobon heechikiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wonyak, eeta nedii Ma Yikapwa riipa riita hadabas hapaga boboy kepika hejakwoyapoka eecha yanak, uhadiinaga eecha hekiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wonyak, rii riita ejel yenya heechinak, ye i ya ya tanak, God riita hisiir ma yecha neerer subuk i ya ya ta ye i tawey yenya eyey yeechi yayakiita.” ");
INSERT INTO kmo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na meeji ta. Pek me siita sa kwona maji pokiita. Eeta nedii ukuk sowak kiipiika akar kunya henyuwa kwo hecha ya kepi pek otiito. Nabi siik otiito. ");
INSERT INTO kmo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eecha otii taweyn kwo na eena eecha hikita diitata: Kapasek boboy sii ya tanak, kwo hikikiita: eeta nediik rii ya kwotaka eecha bana bana tanak nuberejak siitii takiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ada kwona maji siiken wocho diita kapasek nedii yanak, eecha tawa ma ye eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nerek tawa boboy nosapek tawa boboy sii hamakiita. Wowak, ada ba tawa maji sii hamakasakech. Eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Diita yak tawa nedii ma por rii hikikasakech. Hevenek tawa ejel ye hekasakech. God riiti yikapwa rii hekasakech. Eeta Apoko God riitaba saniga hecho. ");
INSERT INTO kmo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Eena kwota na siitii kowu tanak, na ow poy sii ta. Kwo eeta nedii yak tawa nediin hekasakech. ");
INSERT INTO kmo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eeta nedii iipa ma akan heechi akar eemek ichawaga, rii riiti wakasa man wochi heechi inyak, yepa kowu takiita. Yecha yechi yon saniga saniga otii ye i takiita. Nubureja siitii kowu tawa ma riin rii eecha wocho: mii na hehar siitii kowu ta. ");
INSERT INTO kmo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eena na siitii kowu ta. Ada ma rii ya nedii kwo hekasakech. Kapo hogo sii nediik yakiita. Kapo niy ediik, kapo uhadii nediik, kapo niyiga nediik yakiita. ");
INSERT INTO kmo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mii opoche watanakech. Rii eeta abok ameya yakii takiita! ");
INSERT INTO kmo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ada kwona maji ba tawey, ada eyey ma mima yenya bato: eyey ow poy sii ta. ");
INSERT INTO kmo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasova nokusha a nedii, Yis Biish Tawa Geyen nokusha nedii yadii upurus siichi takiita. Diita nediik opelen otii tar harapa ma ye, lo majin pokiitar ma ye Jisas riina yeechi veenyichi sokwakwo nobon yesha tar. ");
INSERT INTO kmo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yecha eecha wor: “Opoche nokusha a nediik diita boboyen otiitanakech. Ma mima ye eena hechi ow otii ye ikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas rii Betani akamak tarek, mashi maba kapasek tar Saimon riiti akak tarek, rii otii atarek, mima pochi sii yar. Sii yari, kwowa yatawa uku kepika eecha neeki yar. Eeta uku hisaw ya toko tawa uku. Eeta hadabas uku kepin woye tar papaga tawa boboy eeka eecha yayar. Yayari, sii tiiriikwochi Jisas riiti masekiik gwotii powur. ");
INSERT INTO kmo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Worek, ma kaw ye eeka tarek ye hechi kwotayer. Kwotayechi awasen awasen eecha wor: “Boyewak kata ukun shebo shebo rabowa? ");
INSERT INTO kmo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Diita ukun tokoney, 300 dola tokochi eeka yakiita. Yeechi yayanak kiiriisiiposii tawa man hapoy pakakiita!” Worek, ye diita mima siina ow maji bar. ");
INSERT INTO kmo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Worek, Jisas rii eecha wor: “Kwota diita mima siina na heechi. Boyewak kwo siina nomoya boboy otiito? Sii ana boboy kepin otiiwa. ");
INSERT INTO kmo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kiiriisiiposii tawa ma ye kwotaka eechaba eechaba tawa. Tawey, kwota kiyatayek wonyey, ii na kiyatay ta. Wowak, ada kwotaka eechaba eechaba takasakech. ");
INSERT INTO kmo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sii keena otiiken otiiwey, eeta sii otiiwa. Sii ana eecha otiiwey, ii ada tiiriimok i nediin sii eena sayarechuwa. ");
INSERT INTO kmo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Diita na hiki ta. Eyey eemek eeta God riiti hadabas majin komas eeka sawo tanak, siita otiiwa boboy majin ma ye meeji ye i takiita. Wonyak, siiti hin abosuchikasakech. ");
INSERT INTO kmo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Worek, Judas Iskeriot, Jisas riiti disaipel por rii opelen otii tar harapa ma yenya heken ir. Jisas riina yechi tapak howu haken ir. ");
INSERT INTO kmo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Irek, yecha rii bar majin kwoya meejichi riina moni ya ha majin wor. Worek, Judas rii Jisas riina yechi tapak how ha nobon yesha tar. ");
INSERT INTO kmo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yis Biish Tar Gey nokusha atar nedii yarek, Diita nediik sipsip yin Pasova nokusha aken otii tarek sowakwor. Diita nediik Jisas riiti disaipel yecha riina woher: “Miita shecha hikitu siitak nota i Pasova nokusha aboboyen sayaretak?” ");
INSERT INTO kmo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Worek, Jisas rii disaipel upurusen heechirek ik otiirek rii eecha wor: “Eeta akamak na i yar. Ki i yarenak, ukun siiviichi kiya yatana man kicha nobok jawokiita. Jawonak, riina na sumowu i riita iyar na akak ki napa ibak iyar. ");
INSERT INTO kmo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ki iyarebanak aka ma riina wo: ‘Tisa rii eecha wowa, en aka wo siitak tawa anapa eeji disaipel yechaka eeka Pasova nokusha akiita?’ ");
INSERT INTO kmo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wonyak, riipa kinya harapa aka won yow mukuchinyak, tiikiir chey boboy eeka tawa. Ki napa sayar.” ");
INSERT INTO kmo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Worek, eeta disaipel upurus piir i harapa akamak i yarerek, Jisas riita wor majiga piir i eecha her. Worek, piir Pasova nokusha aboboyen sayarchichar. ");
INSERT INTO kmo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hogo nedii siirek, Jisas rii riiti disaipel 12 yechaka eecha yar. ");
INSERT INTO kmo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yecha cheyek atarek, Jisas rii eecha wor: “Ada kwona wocho, ma por rii diika notaka tawey, riipa ana magiirechikiita. Diita ma rii adaka eecha ato.” ");
INSERT INTO kmo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Worek, disaipel ye meejichi inyaka kisokwachi yecha saniga Jisas riina wohe ye ichi eecha wor: “Kapo nama? Kapoada?” ");
INSERT INTO kmo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisas rii awasen eecha wor: “12 kwotaka tawa ma por riita tapa adaka eecha neebiyak heechinak ye inye eeta ma riita. ");
INSERT INTO kmo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yikapwa riipa hakiita. Wowak, eeta ma rii Ma Yikapwa riina magiirechiwey, kapsek owuka tawa boboy eeta riitak yakiita. Eeeta kepi nokwapa sii diita ma riina saka nokwapa sii yimowu tarek!” ");
INSERT INTO kmo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yecha atarek, jisas rii geyen yeechi God riina woshiachi reekiichi yenya hapoy pakar. Rii eecha wor: “Na ya ta. Dii eeta eeji maba omu.” ");
INSERT INTO kmo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Worek, rii wain heebiya yeechi God riina woshiachi yenya harek yecha abar. ");
INSERT INTO kmo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Worek, jisas rii eecha wor: “Dii eeta eeji pi. Ada otiichinyak, eeji pi sakanak nokwapa nokwapa ma mima yenya yesokwa yikiita. Eecha otiinak, rii eecha wocho riita mashi wor maji sii eeta sokwakiita. ");
INSERT INTO kmo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ada kwona wocho: adadiita wain ukun diita nosapek saka kawka akiitawak. God riiti kigdom yana nediik eeka ada kawka akiita.” ");
INSERT INTO kmo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Worek, yecha hokwa pochi chichi heechi Oliv kwowuk eeka ir. ");
INSERT INTO kmo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas rii yenya eecha wor: “God riita mashi keyir maji eecha wocho, ‘God rii sipsip siitii kowu tawa ma riin sowakwokiita. Wonyak, sipsip ye saka i ye yakiita. Eena iipa kwo akiichi ana heechi ikiita. ");
INSERT INTO kmo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wonyak ada saniyeechi sokwanak, ada mapo Galili nosapek ikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita rii meejichi awasen eecha wor: “Ada miina heechikasakech. Anadii disaipel yecha miina heechik wonyey iipa heechikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Worek, Jisas rii Pita riina eecha wor: “Miita na hiki! Apochok rii upurus uhadiik wo nediik yanak, miipa piiriichar eecha wokiita: ‘Ada riina hekasakech.’” ");
INSERT INTO kmo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita rii meejichi harapa eecha wor: “Ada saka eecha wokiitawak: ‘An Jisas riina hekasakech.’ Ada miitaka sicha eecha hakiita!” Worek, anadii disaipel ye eechaba babar. ");
INSERT INTO kmo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Worek, yecha eemek podatek, siiti he Getsemani, eeka iyarer. Iyarek, Jisas rii riiti disaipel yenya eecha wor: “Kwo diika a yinyak, ada i God riina maji bak.” ");
INSERT INTO kmo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Worek, rii, Pita, Jems, Jon, yenya yeechi ye ibar. Worek, riiti maba harapa nomo mayak yarek, rii yenya eecha wor: “Eeji inyaka harapa nomon yato. Nomo yatawa boboy eeta ana otii dagiir poyekiita. Eena diika na siitii kowu ta.” ");
INSERT INTO kmo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Worek, rii yenya heechi i nosapek sakachi rii God riina maji bar. Rii God riina woheri diita kapa meejik tawa boboy Jisas riitak yak otiiri eena taviyek eena woher. ");
INSERT INTO kmo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Rii Apokon riina eecha woher: “Apoko! Miita keena eyey nokwapa nokwapa boboyen otiikiita. Diita kapa meeji tawa heebiyan adak na yeechi rabo. Wowak, eeji yokasakech. Eeta miiti keena yo. Miita ana otiichik wonyey eena na otiichi. ");
INSERT INTO kmo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Worek, Jisas rii disaipel piiriichareka eecha ya her. Ya heri yecha watarek, herek, Pita riina eecha wor: “Saimon, mii boyewak wato? Miita saka nedii pochi siitii kowu tawak?” ");
INSERT INTO kmo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Worek, rii yenya eecha wor: “Na ow poy siichi siitii kowu ta. Na God riina maji ba ta. Kwo opoche tiipiikeyineechi sakatanakech. Eeta spirit rii eeta kiki sowa. Maba siita paye tawey, saka kiki siikiitawak. ");
INSERT INTO kmo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Worek, rii awasen i kawka Apoko riina maji ba tari, mapo bar maji ban iiban kawka bar. ");
INSERT INTO kmo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Worek, rii riiti disaipel yechak awasen heechi ya heri riiti disaipel ye kawka watar. Miy harapa meejir. Worek, eena ye boy majin riina woken wonyak. ");
INSERT INTO kmo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Worek, rii kawka ya yenya heri ye watarek, rii eecha wor: “Kwo opoy wabato? Eetayo! Eeta nedii yawa. Na he. Ma Yikapwa riin kapasek otii tawa ma yechi tapak how hakiita. ");
INSERT INTO kmo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na wokwa. Hawa ik. Na he. Ana magiirechichawa ma rii yawa!” ");
INSERT INTO kmo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas rii ba tarek, Judas, Jisas riiti disaipel por, rii yar. Nokwapa nokwapa ma ye riitaka eecha yari, eekika kubuka eecha neeki neeki yar. Opelen otii tar harapa ma ye, lo majin pokiitar ma ye, lotu akan kwo tar apoko saba ma ye yenya wochirek irek, eena ye yar. ");
INSERT INTO kmo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Eeta Jisas riina magiirechir ma rii maji pochin wor: “Kwota yak otii tawa ma riina ada omore amoreney, eeta ta Jisas riita. Kwota na neeki riina yeechi ye hehar siitii kowu.” ");
INSERT INTO kmo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Worek, Judas rii ya Jisas riitak i eecha wor: “Tisa!” Worek, riita riina omore amorer. ");
INSERT INTO kmo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Worek, yecha Jisas riina yeechi kiikiiriina neekiir. ");
INSERT INTO kmo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma por rii yechaka eecha siitii tari rii riiti eekin hey huguruku yeechi opelen otii tar harapa ma riiti wakasa ma por riiti mabiyan tiimii rabor. ");
INSERT INTO kmo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Worek, Jisas rii yar ma yenya eecha wor: “Kwota ana yak yawey, kwo boyak eekika kubuka eecha neeki yawa? Kwo ya hiyiya tawa man ya tawaga eecha yaken yawa. ");
INSERT INTO kmo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Eechaba eechaba nedii ada harapa lotu akak kwotaka tarek, kwona maji ada pokiitari, kwo ana jecha neeki kiikiiriineechi yayakasakech. God riiti mashi keyi maji sapa sokwa.” ");
INSERT INTO kmo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Worek, disaipel ye Jisas riitaban heechi akii ir. ");
INSERT INTO kmo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Hadiiyey ma por eeka tari, apoma riki podar tarin, rii Jisas riina sumowu tar. Yecha riina how yak otiiri rii siivatabi apoman how neekiiri rii kwoyava pochi shebo shebo heechi akii ir. ");
INSERT INTO kmo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Worek, yecha Jisas riina opelen otii tar harapa ma podar riiti akak ye ir. Opelen otii tar harapa ma ye, apoko saba ma ye, lo maji pokiitar ma ye eeka ya yopo wuchi yiken otii tar. ");
INSERT INTO kmo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Eecha otii tarek, Pita rii jisas riina sumowu tari, yepak tar. Iri, rii i opelen otii tar harapa ma riiti akan jichar inyi wok iyarer. Iyarechi rii ow ana picharin siitii kowu tar ma yechaka eecha yichar. Yicharek, rii hi tukuchi yi waretar. ");
INSERT INTO kmo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Worek, opelen otii tar harapa ma ye, kaunsil ma ye Jisas riina sowakwo nobon eena yesha tari, ye yesha hipiir. Ba diimanak riina sowakwo nobokasakech. Ba diima maji tarin ye woshepii majin eena bar. ");
INSERT INTO kmo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma kaw akar ba diima maji barek kaw akar maji bar. ");
INSERT INTO kmo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Worek, ma kaw ye siitiichi Jisas riina diita woshepii majin eecha wor: ");
INSERT INTO kmo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Riita diita majin bari, nota meeji tar, ‘Ada diita God riiti akan mak otiiri, ada diigiichi ada yadii piiriichar siinak akaren otii tanak saka ma yechi tapak otiikiitawak.’” ");
INSERT INTO kmo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Diita majin yecha bari, podatebakasakech. ");
INSERT INTO kmo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Opelen otii tar harapa ma podar rii eyey ma misomak siitiichi Jisas riina diita majin wohechar: “Yecha miina maji ba diima tawey, miipa boy diita majin wohechar: “Yecha miina maji ba diima tawey, miipa boy saka sen bakiitawak?” ");
INSERT INTO kmo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Worek, Jisas rii yenya maji awasen bakasakech. Riikuja diimiir. Worek, eeta opelen otii tar harapa ma rii kawka Jisas riina woher: “Mii boy kapo eeta Kraist? Mii boy kapo God riiti Yikapwa? ");
INSERT INTO kmo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Worek, Jisas rii awasen eecha wor: “Ayo. Kwopa hekiita. Ma Yikapwa rii Hapaga Tawa God riiti mama yepak yow yikiita. Yichi riipa nerek tawa hejakwoyapeka eecha ya sakiita!” ");
INSERT INTO kmo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Opelen otii tar harapa ma rii meejichi kwotayechi riiti ruwu tar rikin neeki woyarechi eecha wor: “Boyewak no maji ba diima tawa man yeshato? ");
INSERT INTO kmo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kwo riita kapasek bawa majin meejiwa. Ii kwo shecha hikitu?” Yecha eyey eecha wor: “Rii kapasek boboy otii tawak, rii sa he. ");
INSERT INTO kmo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Worek, kaw ye Jisas riina sogwiyak piirek, siivatabi yeechi misoma ri eeka jir. Jichi riina pir. Pichi ye eecha wor: “Nama miina piwa?” Worek, siitii kowu tar ma ye riin pibar. ");
INSERT INTO kmo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita rii inyika tar eemek eeka tarek, opelen otii tar harapa ma podar riiti wakasa ma pochi siita yar. ");
INSERT INTO kmo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sii yari, Pita riita hik siitii war tarek, sii riina riiti misoman hehar he siitiichi sii eecha wor, “Miita Nasaret Jisas riitaka taba tar.” ");
INSERT INTO kmo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Rii meejichi woshepii majin wor: “Yaho. Nija bawa maji ada meejikasakech.” Worek, rii heechi sabak ir. Irek, apochok aya wor. ");
INSERT INTO kmo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Worek, eeta mima sii eeka riina kawka her. Herek, sii anadii ma siitii tari yenya eecha wor: “Rii por doreba!” ");
INSERT INTO kmo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Worek, Pita rii meejichi woshepii maji kawka bar. Worek, komas anadii siitii tar ma yecha Pita riina kawka eecha wor: “Mii opoche woshepii tanakech. Rii por doreta miita. Mii Galili nosapek tar ma.” ");
INSERT INTO kmo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Worek, Pita rii maji kapasek bachi saba howuchi eecha wor: “Kwota kata ma riina ba tawey ada riina hekasahech!” ");
INSERT INTO kmo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Worek, apochok kawka wor. Worek, Pita rii hikichi Jisas riita bar majin. Jisas rii mashi eecha wor: “Apochok aya upurus wo nediik miipa eeji hin piiriichar nedii veenyikiita.” Worek, rii hikichi rii eeta harapa keya tar. ");
INSERT INTO kmo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Worek, uhadiirek, opelen otii tar harapa ma ye, apoko saba ma ye, lo majin pokiitar ma ye, kaunsil ma ye ya yopo wuchi maji apo diigiichi ye otii hamar. Worek, ye sen pokok Jisas riiti tapan jir. Jichi riina ye i Pailat riiti tapak how har. ");
INSERT INTO kmo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Worek, Pailat rii Jisas riina woher: “Mii boy Ju ma yechi aka tabo yima?” Jisas rii eecha wor: “Eeta mii wocho.” ");
INSERT INTO kmo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Worek, opelen otii tar har ma ye nokwapa nokwapa majin Jisas riitaban ba diima tar. ");
INSERT INTO kmo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ba diima tarek, eena Pailat rii way Jisas riina maji kawka woher: “Boyewak mii saka maji awasen bawak? Yecha miina nokwapa nokwapa ba diima majin bato.” ");
INSERT INTO kmo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Worek, Jisas rii maji sen bakasakech siitii meejiba tarek, eena Pailat rii hechi rii negiirabor. ");
INSERT INTO kmo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pasova noku sha a nediik Pailat rii ma mima ye wohechar man Pailat rii heemachicharek ichar. Dii eeta Pailat riita otii tar abo. ");
INSERT INTO kmo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eeta nedii ma por rii poko ji tari riiti hi Barabas. Mashi Barabas rii ow otii ye i tarek, rii ma poren sowakwor. Eena rii anadii ow otii ye i tar ma yechaka eecha poko ji tar. Yecha gavman ma yenya pik otii tarek, ye eena poko ji tar. ");
INSERT INTO kmo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Worek, nokwapa nokwapa ma mima ye Pailat eecha otii tawa boboyen eena woheken ya yopo wuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Worek, Paiat rii yenya eecha woher: “Kwo boy eecha gegiyato ada Ju ma yechi aka tabo yiman heemachinyak iken kwo eena hikitu?” ");
INSERT INTO kmo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paillat rii hehar hiki tar nokwapa nokwapa Ju ma ye Jisas riina sumowu tari, opelen otii tar harapa ma ye eena hechi harapa yun yatar. Eena yecha Jisas riina riiti tapak how har. Eena Pailat rii yatar Ju ma yenya woher, “Naman ada heemachinyak ik?” ");
INSERT INTO kmo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Worek, opelen otii tar harapa ma ye ma mima yechi wopun saboyer. Pailat riina wohenyak riita Barabas riina heemachinyak iken eena otii tar. ");
INSERT INTO kmo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Worek, Pailat rii ma mima yenya kawka eecha wor: “Ada eecha otiiney, kwo boy eecha hikitu ada boy Ju ma yechi aka tabo yima riina shecha otiiken?” ");
INSERT INTO kmo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ye awasen uwar: “Na mek ji siitiichi!” ");
INSERT INTO kmo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat eecha woher: “Boyewak. Rii boy boboy kapaseken otii tarek?” Ye meejichi kawka harapa uwar: “Mek na ji siitiichi!” ");
INSERT INTO kmo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Worek, Pailat rii ma mima yechi inyaka wopun yecha podatebak hikichi i nobon eena Barabas riina heemachirek ir. Worek, Pailat rii eecha otiirek, ye Jisas riina kubu pichi, ye riina mek ji siitiichir. ");
INSERT INTO kmo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Worek, ow ana pichar ma ye Jisas riina yeechi gavman harapa riiti aka inyik ye ir. Ye iri, anadii ow ana pichar ma yen uwar. ");
INSERT INTO kmo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Worek, ye nayim siik tawa saket yeechi Jisas riina ruwuchi yamik tar pokon yeechi yaya shagur veechi riiti masekiik ruwuchir. ");
INSERT INTO kmo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Worek, ye riina woshiachi eecha wor: “Sen, mi Ju ma yechi aka tabo yima!” ");
INSERT INTO kmo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ye kubu yeechi riiti masiiken pichi sogwiyak piichi yecha yatii bogok putiichi yi yichi anemesheroko boboyen otiir. ");
INSERT INTO kmo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wosoboy hamarek, ye riina ruwuchir nayim siik tar saket kwoyava yeechi riitin awasen ruwuchir. Worek, ye riina yeechi mek ji siitiichik otii tar eemek ye ir. ");
INSERT INTO kmo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yecha nobok icharek, i ma poren jawor. Riiti hi Saimon. Rii tar eem Sairini. Riita Aleksanda, Rupus piiriiti eepi. Rii harapa akamak iyareken ir. Ik icharek, yecha riina yeechi Jisas riiti men Saimon riina heechi, wo hapachi heechirek, rii kiya ichar. ");
INSERT INTO kmo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yecha Jisas riina eem pochik ye ir. Siiti hi Golgata. Eeta maji siin eecha habato: Masiik hapa. ");
INSERT INTO kmo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Worek, ye wain ukun yeechi miir marasin ukuka eecha gwotiichi yaya Jisas riina how har. How hari, Jisas rii yeechi akasakech. ");
INSERT INTO kmo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Worek, ye riina eeta mek ji siitiichir. Worek, ye riiti siivatabin yeechi satu anamesherokoken eena ye i yayar. ");
INSERT INTO kmo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Niyega yadiik yecha riina mek ji siitiichir. ");
INSERT INTO kmo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Riina ba diimar majin howuk keyiri eecha wocho: “Rii Ju Ma Yechi Aka Tabo Yima.” ");
INSERT INTO kmo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yecha ma upurus hiyi yatar ow ana pichar ma upurus piiriina mek ji siitiichibar. Poren mama yepak jirek, poren yeeji yepak jir. ");
INSERT INTO kmo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Eecha otiirek mashi keyir maji sii siiken sokwari, sii eecha wor: “Yecha riina ma kapasek otii tarika eecha kenyichi haba tar.” ");
INSERT INTO kmo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma mima ye ya hechichi ichari, ye wosoboyechichi wokwoyachichi masiik wamar wamaya icharecha eecha tenyecharecha wochar: “Mii eecha wochar harapa lotu akan ada diigiichi yadii piiriichar siinak ada kawka otiichi yesokwakiita! ");
INSERT INTO kmo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Apa mii men na heechi ya saka mayama yesokwa yichi!” ");
INSERT INTO kmo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Opelen otii tar harapa ma ye, lo maji pokiitar ma ye ya eechaba Jisas riina wohega wosoboye tar. Ye awasen awasen eecha wor: “Rii anadii man yesokwari, apa rii mayama yesokwakasakech! ");
INSERT INTO kmo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nota na hecha kapo Kraist rii, Isrel aka tabo yima rii mek taweyn heechi muk ya sakaney, nota riina hiki siitiichikiita!” Anadii ma upurus mek ji siitiichibari piir Jisas riina eechaba wosoboyer. ");
INSERT INTO kmo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yadii nediik eeta niy siir. Eyey eemek eeka niy sii hamar. Ya yey nediik eeka hamar. ");
INSERT INTO kmo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hamarek, Jisas rii harapa uwachi eecha wor: “Eloy, Eoy, ama sabaktani?” Diita majin nota dareboyeri sii eecha wocho: Eeji God, Eeji God, boyewak mii ana heechi ir?” ");
INSERT INTO kmo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Worek, ma kaw ye eeka tarek, ye eena meejichi eecha wor: “Na meeji. Riita Ilaija riina habachi uwato!” ");
INSERT INTO kmo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma por rii ya uku shiki a tawa boboyen yeechi wain sukuk kiiviichi mek jichi how Jisas riiti kujak neekichi eecha wor: “Na kowu ta. Nota hechakiita kapo Ilaija rii riina yeechi ya sakaken yato!” ");
INSERT INTO kmo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Worek, Jisas rii harapa uwachi eeta kiiriidiichir. ");
INSERT INTO kmo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Worek, harapa siivatabi harapa lotu akak tayechi tari, rii eeta nediik piikiichi upurus sakar. Howuk mapo piikii ya sakar. ");
INSERT INTO kmo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ami ow ana pichar ma yechi harapa ma rii meka bana bana siitii tarek, Jisas riita uwachi kiiriidiichirin her. Hechi rii eecha wor: “Diita ma rii eeta siikiin God riiti yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mima kaw ye eeka tari, yapa siimaka hebar. Magdala akama Maria sii yechaka tar. Karakada Jems, Josis piiriiti awi, siiti hi Maria, sii, Salomi sii yechaka eecha taba tar. ");
INSERT INTO kmo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisas rii Galili nosapek icharek, kata mima ye riina sumowuniga kiyatayeniga eecha ibatar. Anadii mima nokwapa nokwapa tar. Ye eechaba Jisas riitaka Jerusalem akamak i yow ba tar. ");
INSERT INTO kmo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hogo sii nediik yarek, Arimatia Josep rii yar. ");
INSERT INTO kmo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Riiti hi kepi tar. Rii kaunsil ma tar. Rii God riiti kigdomen kowu tar. Eeta nedii Ju ma yechi akama siitar nediin sayar tar. Eena Josep rii Pailat riitak anabeyichi i Jisas riiti maban yeechi ye i majin woher. ");
INSERT INTO kmo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Worek, Pailat rii Jisas riita har majin meejichi negerabor. Worek, Pailat rii ami ow ana pichar harapa ma riina uwa yayachi woher: “Jisas rii boy ha siiken har?” ");
INSERT INTO kmo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat rii ami ma riiti maji meejichi rii Josep riina eecha wor: “Riiti maban miita keena yeechi ye i.” ");
INSERT INTO kmo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Worek, Josep rii apoman rikin tokochi maban yeechi ya sakari, rikik jichi tiiriimo supu pochik eeka ye i seechir. Eeta tiiriimo supu papan kwotiitar. Seechirek, ye papa poren ye i supu nobon dasiipoyer. ");
INSERT INTO kmo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala Maria sii, Maria, Josis riiti awi, siita piiriita otiir boboyen her. Piiriita Jisas riina ye i seechir eemen her. ");
INSERT INTO kmo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Aka ma siitii tawa nedii hamarek, Magdala Maria sii, Maria, Jems riiti awi sii Salomi sii yecha kwowa ya tawa boboyen tokochi Jisas riiti maban neekiken otii tar. ");
INSERT INTO kmo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Uhadiirek, Sande niyegak yecha tiiriimo supun hek ir. ");
INSERT INTO kmo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ye nobon icharek ye awasen awasen eecha wor: “Kapo nama ye kata supun dasiipii tawa papan nona jeyigwo ichikiita?” ");
INSERT INTO kmo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eeta papa eeta harapa. Eena ye eecha wochar. Worek, ye i yarechi mow her eeta papan tagwa seechi tarek her. ");
INSERT INTO kmo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Worek, ye i supuk yar her hadiiyey yikapwa rii Jisas riina seechir mama yepak eeka yichar. Rii apoma tawa rikin ruwuchi yichar. Herek, ye eena harapa negerabor. ");
INSERT INTO kmo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Worek, yichar ma rii eecha wor: “Opoche negerabotanakech. Kwo Nasaret Jisas riina yeshato. Riina mek ji siitiichir. Wowak, rii saka diika tawak. Rii saniyeechi awasen sokwar. Na he! Riina seechi tar eem diitata. Na he. ");
INSERT INTO kmo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kwo ne i. Ada bana maji riiti disaipel yen Pita riitaka napa yen eecha sawo. Jisas rii Galili nosapek mapo heechi ichu. Kwona mapo worega napa eecha riina eeka i he.” ");
INSERT INTO kmo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Worek, ye heechi geenyik ameya iyarer. Ye harapa nubunuburek, eena ameya i yarer. Worek, ye iri anadii man sawokasakech. Ye harapa akii tar. ");
INSERT INTO kmo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande uhadiirek, Jisas rii saniyeechi sokwar. Sokwarek, rii Magdala Maria siitak yarek, siita riina mapo her. Mashi eeta mima siin Jisas rii 7 spirit kapaseken yeechi rabor mima. ");
INSERT INTO kmo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Sii hechi sii Jisas riitaka eecha yo otii chishi tar ma yenya sawo tar. Sii yechak yarek, ye inyakapwa hikirek eena keya tarek, sii ya yenya eecha wor: “Jisas rii saniyeechi sokwa tawak, an her.” Ye meejichi eena saka hiki siitiichirek. ");
INSERT INTO kmo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Worek, anadii Jisas riina sumowutar ma upurus piir akaman heechi akar eemek icharek, Jisas rii piiriina akar yikadey mabak siichi i piiriin mukuchir. ");
INSERT INTO kmo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Worek, piir awasen akamak heechi yar. Yarek, piir anadii riina sumowu tar ma yenya her boboyen piir eena sawor. Sawori, yecha saka eena hikirek. ");
INSERT INTO kmo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Komas 11 disaipel ye otii atarek, Jisas rii mayama yenya eeka mukuchir. Rii yenya majin wosawor. Yecha eena inyaka saka hiki siitiichirek. Yechi marenoku hapaga tar. Ma kaw ye Jisas riita sokwar maban heri, yenya eena sawori ye saka hiki siitiichirek. Eena Jisas rii yenya majin wosawor. ");
INSERT INTO kmo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Rii yenya eecha wor: “Kwo na i. God riiti hadabas majin eyey nosapek tawa man napa sawo ye i ta. ");
INSERT INTO kmo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kata ma rii Jisas riina hiki siitiichichaney, riipa riina yesokwa yichikiita. Riina uku yeechikiita. Ma ye Jisas riina hiki siitiichinyan siiney, iipa rii sii siiken siikiita. ");
INSERT INTO kmo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jisas riina hiki siitiichichana ma yen diita mukuchichawa hapaga boboyen yenya hakiita. Eeji hik yecha kapasek spirit yeechi rabokiita. Yecha akar saniga majin bakiita. ");
INSERT INTO kmo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ye hopun yeechi neekiney, kapasek ukun aney, yecha saka kapasek siikiitawak. Ye yechi tapak hak otii tana man neeki taney, ye eeta kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Harapa Jisas rii yenya maji ba hamarek, God riita riina yeechi hevenek ye yowur. Ye yowurek, rii God riiti mama yepak eeka yir. ");
INSERT INTO kmo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Worek, eeta disaipel ye eyey eemek i ye ya tarek yecha God riiti maji ye i tar. Eeta Harapa Ma rii yenya kiyatay tarek, hapaga boboyeka ye eecha otii tar. Otii tari eeta mukuchir eeta yecha sawo tar maji sii eeta siiken. ");
INSERT INTO kmo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiyopilas, sen. Nokwapa nokwapa ma ye notaka tar otiir boboyen ye eena je keyi hechar. ");
INSERT INTO kmo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tasiir nedii ma yecha diita boboy hechi sawotar. Sawotarek, keyir ma yecha meejichi keyi tar. Nota eechaba meejir. ");
INSERT INTO kmo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Meejitarek, ada diita boboyen mashi na apa hehar hikichiniga an apa hikitu eeta kepi ada diita meejir maji miina hehar keyichik. ");
INSERT INTO kmo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Miipa miina maji poko tar majin miipa hehar siikiin hikiken, eena ada miina diita majin keyichichu. ");
INSERT INTO kmo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Eeta nediik Herot riita Judia aka tabo yima tarek opelen otii tar ma por tar. Riiti he eeta Sekaraia. Riiti opelen otii tar magwi, eeta Abaisa. Riiti mima siiti he eeta Ilisabet. Siiti magwi ye eeta Eron riiti magwi. ");
INSERT INTO kmo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Piiriita tarek, piiriita yo kepin otii tarek, God riita her. Piiriita God riiti lon, riiti majin hehar somowutar. ");
INSERT INTO kmo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piiriita yikapwa biish. Siita makwo ma tar. Eena yikapwa biish. Piiriita apoko saba siir. ");
INSERT INTO kmo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nedii pochi Sekaraia rii opelen otiitar ma tari, rii God riiti yon otii tar. Riiti yo nedii tarek, rii otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Opelen otii tar ma yechi otii tar abon riita somowu tari, aboga hisiiri, riita God riiti aka wok ichiniga kwowa ya tar boboyen cheyek tukutar. ");
INSERT INTO kmo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tukutar nediik ma mima ye sabak tarek, ye God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Maji batarek, Sekaraia riita kwowa ya tawa boboyen tukutar cheyek mam yepak siitii tarek, God riiti ejel por rii riitak yar. ");
INSERT INTO kmo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yarek, Sekaraia rii hechi nubu nubuchi akiir. ");
INSERT INTO kmo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Akiirek, ejel rii eecha wor, “Sekaraia, opoche akiitanakech. Good riita miiti woher majin meejirek, miiti mima Ilisabet, siita hoye yikapwan yimowukiita. Yimowunak, riiti hin napa eecha haba ta, Jon. ");
INSERT INTO kmo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Diita yikapwa riin yimowunak kichi inyaka kwoya hikikiita. Nokwapa nokwapa ma mima yechi inyaka kwoyawoy hikitakiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","God riita riina mey maka hewak, riita harapa ma siikiita. Riita wiski, wain akasakech. Riina yimowunak, Holi Spirit riina takiikiisiitakiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Riita nokwapa nokwapa Isrel ma mima yenya yechi Harapa yechi God riina awasen dareboyekiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ilaija riita God riitaka hapaga ichawaga, diita ma rii eechaba God riiti miy somak ikiita. Riita apoko yenya yaya yechi yikapwaka eecha heechikiita. God riina nasowoye tawa ma yen riipa dareboytakiita. Dareboy tanak, ye inyaka kepi hiki tawa ma yechi inyakan yakiita. Riipa God riiti ma miman Harapa riina sayarechikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia rii ejel riina wor, “Boyega ada hikikiita diita maji siikiin batawey? Ada apoko saba ma siir. Eeji mima eeta apoko saba siibar.” ");
INSERT INTO kmo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ejel rii riina awasen wor, “Ada Gebriel. Ada God riiti miy somak siitiito. Diita hadabas majin miina sawoken eena riita ana heechirek yar. ");
INSERT INTO kmo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wowak, ada sawowa maji eeta God riiti nedii sokwakiita. Miita ada bawa majin meejikasakech. Eena miiti kuja diimiikiita. Miita saka hiki siitiichiwak, eena miita kuja saka bakiitawak. Ada miina bawa maji komas siikiin sokwanak, miita kawka kuja bakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Diita nedii ma mima yecha Sekaraia riina kowutar. Kowuchiniga yecha hikichi kapo boyewak rii God riiti lotu akak eechaba eechaba tar. ");
INSERT INTO kmo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Riita sabak yarek, rii yenya maji saka batarek, rii abatar. Eena yecha hikitar rii anada boboyen lotu akak eeka her. Maji saka worek, rii tapabak maji mukuchir. ");
INSERT INTO kmo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraia riiti lotu akak yo otii nedii hamachi rii riiti akak awasen ir. ");
INSERT INTO kmo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Komas riiti mima, Ilisabet, sii yikapwan kiyatar. Kiyaniga sii siiti akak niiwiika yokotapa eeka siir. ");
INSERT INTO kmo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Sii eecha wor, “Apa eeta Harapa rii ana kwoya hecho. Apa riita eeji hiibiyan yeechi rabowa.” ");
INSERT INTO kmo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet sii 6 niiwiika yikapwa poche kiyatarek, God rrita ejel Gebriel riina heechirek ir. Galili nosape akaman siiti hi Nasaret, eeka heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Irek, omunyegu mima pochin siitaka yar. Ma por tarek, riiti hi, Josep, riita yak tawa miman eena hisiir. Josep riiti wayega eeta Devit. Omunyegu mima siiti hi eeta Maria. ");
INSERT INTO kmo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eeta ejel rii siitaka yarek, rii siin eecha wor, “Sen apa. Na eshar ta. Eeta Harapa nijaka tawa. Tawak, rii ninya rukusiichiniga yeyada har.” ");
INSERT INTO kmo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria siita ejel sawotar maji meejichi nubu nubu tarek, sii maji mun hiki tar. ");
INSERT INTO kmo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Worek, ejel rii siina eecha wor, “Maria, nija opoche akiitanakech. God riita ninya keena harapa rukusiito ");
INSERT INTO kmo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nija awi siikiita. Nija awi siinak, hoye yikapwan yimowukiita. Yimowunak, riiti hi Jisas na haba ta. ");
INSERT INTO kmo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rii harapa siikiita. Riina harapa howuk tawa God rii yikapwa habatakiita. Eeta God riita riina aka tabo yiman otiikiita. Riiti wayega, Devit rii tarega, rii eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tanak, rii Jekop riiti yakapwan eechaba eechaba neeki yesokwakiita. Riiti kigdom eechaba eechaba takiita. Hamakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Worek, Maria sii meejichi ejel riina wor, “Ada omunyegu mima tawa. Ada makasakech. Boyega diita boboyen ada siikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eeta ejel awasen wor, “Eeta Holi Spirit riita nijaka yakiita. Yanak, God riiti hapaga otii tawa boboy ninya gamukiita. Eena diita kepi yikapwa riina God Riiti Yikapwan habatakiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Niji yakaa, Ilisabet, siina na hiki ta. Sii eeta apoko saba mima siir. Siirek, ma ye eecha wocho, sii keena yakapwan saka yimowukiitawak. Wowak, sii yikapwan kiyato. Yokotapa abo yokotapa pochi niiwiika siir. ");
INSERT INTO kmo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God rrita eyey boboy keena otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria sii eecha wor, “Ada Harapa riiti yo otiitawa wakasa mima. Miita bawa majin wowey, sa way ta.” Worek, ejel rii heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Komas Maria sii boboyen sayarechi ameya heechi kwowuk tar eemek heechi ir. Judia nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekaraia, Ilisabet piiriiti akak ir. I hechi Ilisabet siina woshiar. ");
INSERT INTO kmo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Woshiarek, Ilisabet sii meejirek, eeta yikapwa rii siiti biik tari, nyegiirabor. Holi Spirit rii yarek, Ilisabet siina takiikiisiirek, ");
INSERT INTO kmo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","sii harapa uwar, “Nija akar eyey mimaka tari, God riita nijaban keena rukusiito. God riita niji yikapwan keena rukusiito. ");
INSERT INTO kmo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Boyewak diita boboy eeta ana yawak, eeji Harapa riiti nokwapa ana hek yawa? ");
INSERT INTO kmo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ada nija ana woshiar majin meejiwak eeji yikapwa eeji biik tari, ameya rii kwoya woy hikichi, nyegiirrabor. ");
INSERT INTO kmo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nija God riita ninya wochirek yar majin sokwaken hiki siitiichiwey, niji inyaka kwoya woy hikikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria sii eecha wor, “Eeji wopu eeta Harapa riiti hin yesokwato. ");
INSERT INTO kmo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Eeji yesokwa yichi tawa God riita otiirek, eeji inyaka eeta kwoya woy hikitu. ");
INSERT INTO kmo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ada God riiti kubuchey wakasa mima tawey, rii ana hikitar. Apa na komas eyey ma mima yecha eecha habatakiita: Ada eeta God riita rukusii tawa mima. ");
INSERT INTO kmo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Harapa otii tawa God riita harapa boboyen ana otiichicharek eena ana eecha habatar. Rii ti hi eeta Holi. ");
INSERT INTO kmo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ma mima mukaw mashi tarek, apa tawak, komas tabatawak, riita riiti hehar otii tawa boboyen eena God riina akii tawa man eena mukuchichu. ");
INSERT INTO kmo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Riita riiti hapaga tawa tapan mukuchir. Wohipi tawa ma yechi inyaka otii hiki tawa boboy otiirek, riita yenya otii poy pakar. ");
INSERT INTO kmo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Rii harapa akii tabo yima yenya dagiir poyer. Wok woy tawa ma yenya riita yesokwar. ");
INSERT INTO kmo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rii eecha ha tawa ma yenya hadabas aboboyen takiikiisiir. Ye yaka tawa ma yenya wochirek ye sobo ir. ");
INSERT INTO kmo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Riita noti wayega yenya wotar majin rii yesokwar. Riiti wakasa ma, Isrel, yenya rii kiyatayek yar. ");
INSERT INTO kmo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Rii Ebraham riina hehar rukusii tari saka abosuchirek, Rii Ebraham riiti yikapwan yenya eechaba eechaba saka abosuchitarek.” ");
INSERT INTO kmo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Worek, Maria siitaq niiwiika piiriichar kaka siirek, sii Ilisabet siina heechi siiti akamaka awasen ir. ");
INSERT INTO kmo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilisabet yimowur nediik yarek, sii hoyey yikapwan yimowur. ");
INSERT INTO kmo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yimowurek, siiti bana bana tar ma siiti magwi Harapa riita siina kepi otiitar boboyen ye meejichi yaniga siitaka maji kwoyawoy batar. ");
INSERT INTO kmo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yikapwa rii 8 yadii tarek, yecha sapi dagii rabok yar. Yarek, yecha riina hin habak Sekaraia apoko riiti hin, eena waga habatar. ");
INSERT INTO kmo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Worek, riiti awi eecha wor, “Yaho. Sekaraia habakasakech. Riiti hi eeta Jon.” ");
INSERT INTO kmo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yecha awasen siina eecha wor, “Niji magapana diita yikadey hi takasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Worek, yecha eepi riina tapa maji batawak woher, “Kapo boy riiti hin habatakiita?” ");
INSERT INTO kmo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Worek, Sekaraia riita jeyn yaken woher. Wohechi keyirin kadiirek eecha wor, “Riiti hi eeta Jon.” Worek, eyey nyegiirabor. ");
INSERT INTO kmo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Eeta nedii Sekaraia rii kawka maji sokwarek kawka maji batar. Baniga, rii God riiti hin yesokwatar. ");
INSERT INTO kmo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Worek, bana bana tar ma ye harapa akii tar. Worek, diita otiir boboy Judia kwowu tar eemek eeka i ye ya tar. ");
INSERT INTO kmo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Eyey ma mima ye meejichi hikichi woher, “Kapo boy diita yikapwa riipa boy siikiita?” Eeta geenyek siir God riiti hapaga boboy eeta yikapwa riitaka siir. ");
INSERT INTO kmo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Riiti eepi, Sekaraia, riina Holi Spirit yaniga takiikiisiirek, Sekaraia rii komas sokwak tawa majin sawor: ");
INSERT INTO kmo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Eeta Harapa, Isrel yechi God, riina na kwoya babatanak na kwoya ba hiki ta. Rii riiti ma mima kiyatayek yar. Yenya heemachik eena yar. ");
INSERT INTO kmo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Riita otiirek, yesokwa yicha ma sokwar. Sokwarek, riita nona yesokwa yichir. Dii eeta Devit, God riiti wakasa ma, riiti neja. ");
INSERT INTO kmo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mashi mashi riita riiti piirapet, maji sawo tar ma kepi, riita yechi kujak eecha wor. ");
INSERT INTO kmo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Riita wotar, nona o ana pichawa ma yecha nona dagiir poyek otii tanak, riita nona yesokwa yichikiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Riita noti wayega yenya eecha wor, “Ada yenya mashi wotar majin saka abosuchikiitawak. Ada kwona hehar rukusiitakiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Riiti noti wayega Ebraham riina majin wotar, ");
INSERT INTO kmo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","o ana pichawa ma yecha nona dagiir poyek otii tanak, riita nona yesokwa yichikiita. Riita wotar, nota riiti yon otiichinyey, nota sak akiikiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Riita wotar, riita nona riiti miyik henyak, nota eechaba eechaba kepi takiita. Eechaba eechaba hehar takiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Miita eeji yikapwa. Howuk tawa God riiti piirapet miina harapa habatakiita. Miita Harapa riina mapo ikiita. Mapo iniga Harapa riiti nobon takiichikiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Takiichinyak, riipa God riiti ma miman yenya yesokwa yichiken eena wokiita. Yechi kapasek boboyen bachi poyeken eena wokiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Noti God rrita nona hehar rukusiito. Riipa otiitanak, hevenek tawa haba nona okoreechichakiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Niyi kiyik yichawa man, hak otii tawey, haba eeta yenya okoreechichakiita. Okoreechichanak, hechi noti yatii kepi wey tawa nobok piitiikiita. Wonyak, nopa kepi hikichi ikiita. ");
INSERT INTO kmo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eeta yikapwa, Jon, sokwatar. Sokwatarek, riiti spirit hapaga sokwar. Riita me biish tar eemek akama biish tar eemek, eeka yichar. Yi yi yicharek, komas nedii riita Isrel ma mima yechi miy somak ya sokwar. ");
INSERT INTO kmo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Eeta nedii Rom ma aka tabo yima, Sisa Ogastas, riita lo majin heechirek ir. Riiti kigdom eyey ma mima yenya diita lon heechirek ir. Riiti lo eecha wor, eyey ma mima yechi hin jeyek sa keyi ta. ");
INSERT INTO kmo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Diita mapo hin keyir yo otiitari, eeta nedii Sairinias rii Siria nosape neeki yesokwatar ma. ");
INSERT INTO kmo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Worek, eyey ma mima yecha yechi akama hin keyiken heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Worek, Josep rii Nasaret akama, Galili nosape tarek, heechi Judia nosape eeka ir. Betlehem akamak ir. Ada tabo yima, Devit riin mashi mashi eeka yimowurek, Josep rii Devit riiti neja tarek, eena Josep rii eeka ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maria ri mima sii riitaka ir. Piiriiti hin keyik eena ir. Sii yikapwaka tarek, ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Piiriita Betlehem akamak tarek, Maria sii yikapwa yimowu nedii yar. ");
INSERT INTO kmo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yarek, sii siiti mapo yikapwa, hoye yikapwan, yimowur. Yimowurek, sii riina siivatabi jichi bulamakaw aboboy heechi tar eemek eeka seechir. I ye ya tar ma yechi wa tar aka eeta takiikiisiir. Eena bulamakaw yechi eemek eeka watar. ");
INSERT INTO kmo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kata eemek sipsip hehar tar ma kaw yecha niyik yechi sipsip siitii kowu tar. ");
INSERT INTO kmo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eeka tarek, God riiti ejel yechak yar. Yarek, God riiti harapa yama yenya okoreetar. Worek, yecha harapa akii tar. ");
INSERT INTO kmo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Akii tarek, ejel rii yenya eecha wor, “Opoche akiitanakech! Ada hadabas hiki tawa majin yayar. Ma mima ye meejinak, yecha inyaka kwoya woy hikikiita. ");
INSERT INTO kmo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Apa niy Devit riiti akamak kwoti yesokwa yicha tawa ma riina yimowur. Rii eeta Kraist, eeta Harapa! ");
INSERT INTO kmo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na he. Diita boboyen henyak, kwo hikikiita riita eeta omutiik: Eeta yikapwan siivatabi jichi bulamakaw yechi aboboy heechi tawa eemek eeka seechitu.” ");
INSERT INTO kmo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Worek, ameya nokwapa nokwapa hevenek tawa ejel yecha yaniga God riina hokwa chichar. God riiti hin yesokwaken eena chichar. Diitata chichar: ");
INSERT INTO kmo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","God riiti hin howuk tawa eemek na yesokwa ta. Ma mima ye diita nosapek tawey, God riita yenya kepi hiki tawey, God riiti wopusha tawa boboy yechaka sa ta. ");
INSERT INTO kmo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ejel yecha yenya heechi hevenek irek, sipsip hehar tar ma yecha awasen awasen eecha wor, “Nota Betlehem akamak na hawa ik. Diita otiir boboyen God riita nona woweyn, nota na heechi i he.” ");
INSERT INTO kmo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Worek, yecha ameya heechi ir. Irek, iyarechi yecha Maria, Josep piiriina yesha hechi yikapwa riita bulamakaw yechi aboboy heechi tar boboy eeka watarin her. ");
INSERT INTO kmo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hechiniga, yecha eyey ma miman ejell rii diita yikapwan bar majin wor. ");
INSERT INTO kmo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Worek, eyey ma mima yecha sipsipen siitii kowutar ma yecha bar majin meejichi yecha nubu nubu tar. ");
INSERT INTO kmo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Worek, Maria sii hechi makabek heechir. Saka abosuchirek. Diita boboyen sii inyaka wopu siitiik hiki tar. ");
INSERT INTO kmo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Worek, sipsip siitii kowutar ma ye heechi awasen ir. Iniga God riina hokwa chichar. Harapa boboyen yecha herin meejirin eena God riina kwoya babatarek, kwoya ba hiki tar. Ejel riita yenya batari, ii eeta sokwar. ");
INSERT INTO kmo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Komas 8 yadii hamarek, eeta sapi dagii poye tar nedii yarek, yecha riiti hin eecha habar, Jisas. Diita hin ejel rii mapo biik tar nediik har. ");
INSERT INTO kmo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses riiti lo wori, piiriiti otii yeetetar nedii hamarek, piiriita Jisas riina yeechi Jerusalem akamak ye ir. God riina sobo haken ye ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","God riiti keyir lo maji eecha wocho, “Eyey mapo hoye yikapwan yimowunak sa habata rii eeta holi, rii eeta God riiti.” ");
INSERT INTO kmo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","God riiti lo wori yecha kawka sejikiir apo upurus aponima yi upurusen upurus hak wori piiriina yeechi ye iniga eeta opelen otiir. ");
INSERT INTO kmo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Worek, ma por rii Jerusalem akamak tarek, riiti hi eeta Simion. Simion rii yo kepin otii tar ma. Rii God riiti nobon somowutar. Riita Isrel ma yenya yesokwa yichi tawa ma riina kwoutar. Holi Spirit riita riitaka tar. ");
INSERT INTO kmo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Holi Spirit riita riina mukuchirek, rii hikir rii eeta Kraist, God riita wotarin, rii eena hechiniga komas riipa hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Holi Spirit rii otiirek, Simion rii harapa lotu akak ir. Irek, Mariaka Josep piiriita Jisas riina harapa lotu aka wok ye ir. Lo maji eecha wori, eena ye ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ye irek, Simion rii hechi yikapwan riiti tapak yeechi God riina woshi atar. Eecha wor: ");
INSERT INTO kmo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apa miita wotar majin sokwar. Miiti wakasa ma, ana, na heechinak anapa eshar ikiita. ");
INSERT INTO kmo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Eeji miyik ada miiti yesokwa yicha tawa boboyen hehar hewa. ");
INSERT INTO kmo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Miita eyey ma mima yechi mi somak sayar otiichir. ");
INSERT INTO kmo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mii eecha haba yama tawey, mii shebo shebo biish tawa ma yenya miiti nobon mukuchichu. Miiti hadabas boboyen miiti Isrel ma mima yenya hato.” ");
INSERT INTO kmo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion riita Jisas riina hechi bar majin yikapwa riiti awi, eepi piir meejichi henebarabor. ");
INSERT INTO kmo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion rii piiriina God riiti kepi majin bar. Riiti awi siina eecha wor, Diita yikapwan God riita hisiir. Hisiirek, rii otiichinyak, nokwapa nokwapa Isrel ma yecha tepekeyinechi sakakiita. Nokwapa nokwapa anadii ma yecha sokwakiita. God riita otiirek, riita God riiti nobon ma yenya diita nobon dasiipiiken otiikiita. ");
INSERT INTO kmo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yecha eena otiiniga yechi veenyi hikitar inyakaka tar boboyen riita geenyik yenya kwodii wokiita. Wonyak, niji inyakan meseken eekik pikiita. ");
INSERT INTO kmo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Piirapet mima pochi siita eeka tarek, siiti hi Ana. Sii Panuwel riiti yikapwa. Siiti magwi eeta Aser. Sii apokosaba mima. 7 sukwiya siiti maka tarek, rii har. ");
INSERT INTO kmo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Harek, sii 84 sukwiya saniga tar. Apokosaba siir. Sii harapa lotu akan heechikasakech. Sii eechaba eechaba God riina maji kwoya ba ba tarek, kwoya ba hiki tar. Sii aboboy kaw saka atarek. Sii God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kata nedii Josep, Maria piir harapa lotu akak tarek, sii iyarechi God riina woshiachiniga sii diita yikapwan hikichi maji bar. Kowutar ma yenya maji bar. Yecha God riita Isrel ma miman yesokwaken kowutar. ");
INSERT INTO kmo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yecha eyey God riiti lo keyir maji otii hamarek, yecha Galili nosape awasen heechi ir. Yechi akama Nasaret, eeka ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eeta yikapwa sokwatar. Sokwachi hapaga siir. Siirek, rii hokwa sokwa tawa maga siir. God riita riin hehar rukusiitar. ");
INSERT INTO kmo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Eechaba eechaba sukwiya Jisas riiti awi, eepi piiriita noku sha aken Jerusalem akamak ir. Noku sha atawa boboy siiti hi Pasova. ");
INSERT INTO kmo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas riita 12 sukwiya tarek, yecha otii tar boboyen somowu tarek, yecha Pasova noku sha ak eena ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Noku sha a hamarek, yecha yechi akamaka heechi iken otiir. Heechi ik otiirek, yikapwa Jisas rii Jerusalem akamaka tar. Tarek, riiti awi, eepi saka hikirek. ");
INSERT INTO kmo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Piiriita eecha hikitar Jisas rii kapo awasen ichar ma mima yechaka kapo eecha tawa. Eena yadii pochi piiriita noboka ichar. Yadii pochi nobon opoy icharek, piiriita riina yesha hipur. Nareboy, magwi yechaka eecha riina yesha hipur. ");
INSERT INTO kmo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yesha hiputarek, piiriita Jerusalem akamak kawka yeshaken eena ir. ");
INSERT INTO kmo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yadii piiriichar hamarek, piiriita riina harapa lotu akak eeka her. I heri, rii Ju ma maji poko tar ma yechaka eecha yichar. Yiniga rii yechi majin meejichi awasen yenya wowohechar. ");
INSERT INTO kmo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eyey ma yecha riiti majin meejirin yecha negerabor riiti majin. ");
INSERT INTO kmo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Riiti awi, eepi piir riina hechi negerabor. Worek, riiti nokwapa sii riina eecha wor, “Eeji yikapwa, boyewak miita sinya eecha otiiwa? Miina yesha hipurek, miiti eepi adaka sicha miina inyakapa hikichiniga miina yeshato.” ");
INSERT INTO kmo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Rii piiriina awasen eecha wor, “Boyewak kicha ana yeshatar? Ki kapo saka hikirek eeta kepi ada keena eeji Apoko riiti akakeeka tawa?” ");
INSERT INTO kmo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Worek, piiriita riita bar majin saka hikirek. ");
INSERT INTO kmo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Worek, Jisas riita piiriitaka Nasaret akamak ir. Irek, riita piiriita batar majin meejichi mayishichar. Riiti nokwapa sii diita otiitar boboyen siiti inyaka wopuk heechi tar. ");
INSERT INTO kmo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Worek, Jisas rii sokwar. Sokwaniga maba kepi siirek, hokwa sokwar. Siirek, God riita riina rukusiitar. Ma ye riina rukusiitar. ");
INSERT INTO kmo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibirias Sisa rii 15 sukwiya siitii kowu tarek, Pontias Pailat rii Judia nosap harapa gavman ma tar. Tarek, Herot rii Galili nosap harapa gavman ma tar. Pilip, riiti kumwoy, rii Ituria nosap, Trekonaitis nosap harapa gavman ma tar. Laisenias rii Abilini nosap harpa gavman ma eeta nedii tar. ");
INSERT INTO kmo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas, Kaiapis piiriita harapa opelen otii tar ma tar. Eeta nedii God riiti maji eeta Jon, Sekaraia riiti yikapwa, riitaka yar. Rii me bish tar eemek eetaka tar. ");
INSERT INTO kmo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yarek, Jon riita Jodan pak bana bana tar nosapek i ye ya tar. I ye ya tarek, rii eecha sawotar, “Noti kapasek otii tawa boboyen na diireboyechi uku yeetii poy. Wonyey, God riita kwoti kapasek boboyen bachi poyekiita. ");
INSERT INTO kmo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Piirapet Aisaia riita keyir maji eecha wor: “Me biish tar eemek aya sii eeka uwato: ‘Harapa riiti nobon na sayarechicha! Eye nobo na tak seechi. Wonyak, riipa eeka ikiita. ");
INSERT INTO kmo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tabotii wawu woy takiikii siitakiita. Eye harapa kwow karakada kwow otiiniga sheyshey siitakiita. Kuriikwor tawa nobo otii danegwa seechikiita. Tomo tam papaka tawey, otii kepi siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eye ma mima yecha God riita eysokwa yichi tawa boboyen yecha hekiita!” ");
INSERT INTO kmo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nokwapa nokwapa ma mima yecha Jon riitak uku yeechik yatar. Rii yenya eecha wor, “Kwo hopo yechi yikapwa. Kapo nama kwona eecha wor, ‘Komas God riiti kwotaye yana boboyen na heechi akii i.’ ");
INSERT INTO kmo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kwo na yo otiichi akar man na mukuchicha: Kwota kwi kapasek boboyen heechir. Opoche kwota eecha batanakech, ‘No Ebraham riiti yikapwa.’ Ada kwona siikiin wocho, God rii eeta kiki sowa rii papan yeechiniga otiichirek, Ebraham riiti yikapwaga eecha siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yeebiiru me muk bana bana wato. Eyey me omu wanan siiney, iipa ye yechi hik rabokiita.” ");
INSERT INTO kmo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma mima yecha riina wohechar, “Nopa boyen otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rii awasen eecha wor, “Ma por rii siivatabi upurus taney, poren na biish tana man ha. Ma aboboy taney, napa eechaba ha ta.” ");
INSERT INTO kmo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis yan ya tawa ma uku yeechik yar. Yarek, ye Jon riina woher, “Tisa, nopa boyen otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Rii yaka yakasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","O ana pichawa soldia kaw ye riina woher, “Nopa boyen otiikiita?” Rii awasen eecha wor, “Kwota yan woshepii yeechi kwowuk woyetanakech. Kwota piken otiichi yan wohegiya yatanakech. Anasak tawa aka woshepii batanakech. Kwo opoche yakech keyi tanakech. II siikayekiisii.” ");
INSERT INTO kmo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ma mima yechi inyakak hikiniga kowutar. Jon riina harapa hikitar. Inyaka hikichi wor, “Rii kapo mapo wotar yak tawa Kraist.” ");
INSERT INTO kmo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Worek, Jon rii yenya eecha wor, “Ada kwona ukuk uku yeechichu. Komas ma por rii yanak, riipa harapa siikiita. Ada karakada siikiita. Ada saka kikisowak, wonyak, ada riitii yatiin su poko hogok wonyak. Riipa kwona Holi Spiritek hika eeka uku yeechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Rii riiti gishagu riita tapak neekitu. Tapak neekitawak, riita kepika, kapasekiika keyiboto. Otii tawak, riita witen heechi tawa akak heechinak, sharega rii yeechi hik eechaba eechaba tukutakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hadabas majin sawochiniga nokwapa nokwapa nobon Jon riita ma miman yenya kiyapotar. ");
INSERT INTO kmo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Worek, Jon riita Herot, harapa gavman ma riina o maji bar. Herot rii mima pochin, riiti yaka riiti mima siina yar. Akar kapasek boboy otiiba tarek, eena Jon rii riina o maji bar. ");
INSERT INTO kmo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Worek, Herot rii way kawka kapasek boboyen otiir. Rii Jon riina pokok jir. ");
INSERT INTO kmo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Eeta nedii Jon rii ma mima yenya uku yeechi hamarek, rii Jisas riina uku yeechibar. Worek, Jisas rii God riina maji batarek niir eeka tagwar. ");
INSERT INTO kmo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tagwarek, Holi Spirit rii sejikiirega eecha haga riitak yar. Worek, aya niirek uwari eecha wor, “Ada miina kwoya hecho. Mii eeji Yikapwa. Eeji inyaka miina kwoya woy hikitu.” ");
INSERT INTO kmo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas riita riiti yon yesokwari rii 30 sukwiya tar. Ma mima eecha hikitar rii Josep riiti yikapwa. Josep rii Hilai riiti yikapwa. Hilai riita Matat riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat riita Livai riiti yikapwa. Livai riita Melkai riiti yikapwa. Melkai riita Janai riiti yikapwa. Janai riita Josep riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep riita Matataias riiti yikapwa. Matatais riita Emos riiti yikapwa. Emos riita Neam riiti yikapwa. Neam riita Eslai riiti yikapwa. Eslai riita Nagai riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai riita Meat riiti yikapwa. Meat riita Matatais riiti yikapwa. Matataias riita Semen riiti yikapwa. Semen riita Josek riiti yikapwa. Josek riita Joda riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda riita Joanan riiti yikapwa. Joanan riita Resa riiti yikapwa. Resa riita serababel riiti yikapwa. Serababel riita Sialtiel riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sialtiel riita Nerai riiti yikapwa. Nerai riita Melkai riiti yikapwa. Melkai riita Edai riiti yikapwa. Edai riita Kosam riiti yikapwa. Kosam riita Elmedam riiti yikapwa. Elmedam riita Ea riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ea riita Josua riiti yikapwa. Josua riita Eliesa riiti yikapwa. Eliesa riita Jorim riiti yikapwa. Jorim riita Matat riiti yikapwa. Matat riita Livai riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai riita Simion riiti yikapwa. Simion riita Juda riiti yikapwa. Juda riita Josep riiti yikapwa. Josep riita Jonam riiti yikapwa. Jonam riita Elaiakim riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim riita Melia riiti yikapwa. Melia riita Mena riiti yikapwa. Mena riita Matata riiti yikapwa. Matata riita Netan riiti yikapwa. Netan riita Devit riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit riita Jesi riiti yikapwa. Jesi riita Obet riiti yikapwa. Obet riita Boas riiti yikapwa. Boas riita Salmon riiti yikapwa. Salmon riita Nason riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason riita Aminadap riiti yikapwa. Aminadap riita Admin riiti yikapwa. Admin riita Anai riiti yikapwa. Anai riita Hesron riiti yikapwa. Hesron riita Peres riiti yikapwa. Peres riita Juda riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda riita Jekop riiti yikapwa. Jekop riita Aisak riiti yikapwa. Aisak riita Ebraham riiti yikapwa. Ebraham riita Tera riiti yikapwa. Tera riita Neho riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neho riita Serak riiti yikapwa. Serak riita Riyu riiti yikapwa. Riyu riita Pelek riiti yikapwa. Pelek riita Iba riiti yikapwa. Iba riita Sila riiti yikapwa. Sila riita Kenan riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kenan riita Apaksat riiti yikapwa. Apaksat riita Sem riiti yikapwa. Sem riita Noa riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek riita Metusala riiti yikapwa. Metusala riita Inok riiti yikapwa. Inok riita Jeret riiti yikapwa. Jeret riita Mahalalil riiti yikapwa. Mahalalil riita Kenen riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan riita Inos riiti yikapwa. Inos riita Set riiti yikapwa. Set riita Adam riiti yikapwa. Adam riita God riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas riita Holi Spirit takiikiisiich, rii Jodan pa heechiniga ir. ");
INSERT INTO kmo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Heechi irek, Holi Spirit rii 40 yadii me biish tar eemek riina ye irek, Gaba rii riina otii otii hechar. Eeta nedii rii aboboy saka atarek. Worek rii harapa eechin har. ");
INSERT INTO kmo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gaba riita riina eecha wor, “Mii God riiti Yikapwa taney, na miita diita papan wonyak sa geyek sii.” ");
INSERT INTO kmo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas rii awasen eecha wor, “God riita keyir maji eecha wocho, ‘Ma geyiban aney, sii kikisiikasakech.’” ");
INSERT INTO kmo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Worek, Gaba rii riina yeechi howuk ye i nosapek tawa nokwapa nokwapa boboyen ameya mukuchir. ");
INSERT INTO kmo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Gaba rii eecha wor, “Ada diita eye nosap tawa boboyen hapaga tawaboboyen miina hakiita. eye diita boboyen ana har. Harek, ada hikitawey, ma poren ada haken wonyey anapa keena riina hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Miita yatii bobo piitiichi adana kwoyaba banak ana kowyaba hiki taney, diita eyey boboy eeta miitiba.” ");
INSERT INTO kmo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas rii awasen eecha wor, “God riiti keyir maji eecha wocho, ‘Mii God riitaban na kwoyaba ba ta. Na riitaban na somowu ta.’” ");
INSERT INTO kmo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Worek, Gaba rii Jisas riina Jerusalem akamak ye i harapa lotu akak ye yo siitiichi eecha wor, “Mii God riiti Yikapwa taney, diika na siitiichi durii. ");
INSERT INTO kmo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Keyir maji eecha wocho: ‘God riipa ejel yenya heechinak, inyak yepa miina siitii kowukiita.’ ");
INSERT INTO kmo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“Eeta eechaba wocho, ‘Yepa tapak miina neeki inyak, papa miiti yatii oborokukasakech.’” ");
INSERT INTO kmo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas rii awasen eecha wor, “Keyir maji eecha wocho, ‘Mii opoche God riina otii otii hechanakech. Rii eeta miiti harapa God.’” ");
INSERT INTO kmo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Gaba rii diita yikadey boboy Jisas riina otii he hamachiniga akar nediin eena kowur. ");
INSERT INTO kmo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Holi Spirit rii Jisas riitaka harapa tari, rii Galili nosap awasen ir. Worek, riita otiir yo maji i ye yar. ");
INSERT INTO kmo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Rii yechi lotu akak iyar barek, yecha riiti hin yesokwar. ");
INSERT INTO kmo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Worek, Jisas rii Nasaret akamak ir. Nasaret Jisas riita sokwa ma siir akama. Dabat nedii tarek, yecha otii tar abon eena somowure, rii yechi lotu akak ir. Irek, rii i riiti majin kadiik siitiir. ");
INSERT INTO kmo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Siitiirek, piirapet Aisaia riita keyir jeyn riina har. Harek, rii jeyn tagwachi eeta majin kadiir. ");
INSERT INTO kmo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“God riiti Spirit adaka tawak, Riita kiiriisiiposii tawa man ada hadabas maji kepin sawoken hisiir. Ada diita majin sawoken eena ana wochirek ir. Wochirek iri, poko jichawa man heemachik, Ma miy dumu tawey, ye sapa mey maka hek, Ma dagiir poy taweyn heemachik, ");
INSERT INTO kmo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","God riiti hadabas sukwiya yenya sawoken, eena ana wochirek yar.” ");
INSERT INTO kmo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas rii kadii hamachi jeyn rii gwonyebiiriir. Gwonyebiiriichi rii jeyn aka siitii kowu tawa man ho har. Ho heechi rii he yir. Yirek, akak tar ma ye riitaban hechar. ");
INSERT INTO kmo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tarek, rii yenya maji wor, “Diita kadiiwa majin kwo meejiwey, apa nedii siiken sokwawa.” ");
INSERT INTO kmo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Meejichi yecha riina kwoya woy hikichi riita kujak bar majin eena meejichi ye henebarabor. Yecha eecha wor, “Rii kapo Josep riiti yikapwa?” ");
INSERT INTO kmo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Rii yenya eecha wor, “Ada hehar siiken hikitu kwo na ana majin kepin ba. Kwo kapo bak, ‘Dokta, miita miiti maban mayama na mapo hehar ta.’ Kwota ana kawka eechaba kapo bak, ‘Miita Kapaneam akamak miita yo otiirega nota meejiri apa diita akamak nopa eechaba otii.’” ");
INSERT INTO kmo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jisas rii kawka eecha wor, “Ada kwona wocho, yecha piirapet por riiti majin ri akama siikiin ye meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ana na meeji: eeta siiken, Ilaija riita tar nedii nokwapa nokwapa mibiya mima ye Isrel nosapeka tar. Worek, sukwiya piiriichar niiwiika 6 wayi vakasakech. Worek, ma mima ye harapa eechin har. ");
INSERT INTO kmo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Worek, God riita Ilaija riina Isrel mibiya miman Saidon nosapek tarek, eeka wochirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Piirapet Ilaisa riiti nedii nokwapa nokwapa ma mima noma pichar. Worek, ma poren uku yeetii kepi hekasakech. Neaman Siria ma, riitaba uku yeetii maba kepi her.” ");
INSERT INTO kmo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eyey ma mima lotu akak tari, yecha meejichi inyaka harapa kwotayer. ");
INSERT INTO kmo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inyaka kwotayechi yecha sokwachi Jisas riina tapak yeechi kwowuk tar akamak ye yo ye ichi rabochinyak iken hikir. ");
INSERT INTO kmo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Worek, Jisas rii ma yechi nediik iniga ir. ");
INSERT INTO kmo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Worek, Jisas rii Galili akama, Kapaneam, eeka i siir. I siichi sabat nedii yenya maji pokii tar. ");
INSERT INTO kmo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pokii tarek, ye riiti maji meejichi nyegarabor. Jisas riita bawa maji eeta hapaga bor maji. Eena ye nyegarabor? ");
INSERT INTO kmo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma por rii lotu akak tari, kapasek gaba eeta riitaka eecha tar. Tarek, riiti aya Jisas riina harapa uwar, ");
INSERT INTO kmo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nasaret Jisas a, boyewak mii diika yawey nona shecha otiik yawa? Mii kapo nona kapasek otiiken yawa? Ada miina hecho. Mii eeta God riiti ma kepi wey.” ");
INSERT INTO kmo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Worek, Jisas rii kapasek gaba riina harapa wo sowur, “Miiti kuja na diim. Eeta ma riina na heech.” Worek, kapasek gaba eeta riina ma mima yechi nediik otiichirek, rii sakar. Sakarek, gaba eeta riina ma mima yechi nediik otiichirek, rii sakar. Sakarek, gaba rii heechi riin pishamanekasakech. ");
INSERT INTO kmo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eyey ma mima ye hechi heneborabochi, awasen awasen eecha wor, “Boy yikadey maji diitata? Rii kapasek gaba yenya hapaga maji bawey, hisaw tawa majin wo sowuwey, yecha heechitu.” ");
INSERT INTO kmo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Worek, Jisas riita otiir majin kata nosapeka eeka i ye yar. ");
INSERT INTO kmo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Worek, Jisas rii lotu aka heechi Saimon riiti akak ir. Saimon rii mima siiti nokwapa siita maba harapa hi uwutar. Hi uwutarek, ye Jisas riina yak woher. ");
INSERT INTO kmo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Worek, rii i siiti watar eemek siitiichi maba hi uwutar boboyen wor. Worek, siiti maba hi uwutar boboy eeta ameya kepi siir. Worek, sii sokwa aboboy otiichi sii aboboy gwotiir. ");
INSERT INTO kmo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ya yey nedii eyey ma mima ye hak otii tar ma boboyeka ta yey tari yechaka tari ye yeechi Jisas riitak ya yar. Yayarek, rii riiti tapa eeta eyey ma mima yenya howuk neekiiri, ye eeta kepei siir. ");
INSERT INTO kmo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nokwapa nokwapa kapasek gaba eechaba yenya heechiniga uwato: “Mii God riiti Yikapwa.” Worek, rii yenya wo sowuchi banan anachekiir. Yecha hikir rii eeta Kraist eena Jisas rii bokonar yecha kawka maji banakech. ");
INSERT INTO kmo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Uhaderek, Jisas rii akama heechi ma biish tar eemek heechi ir. Irek, ma mima ye riina yeshatar. Yesha hechiniga ye riina eeka anachek heechiken otiir. ");
INSERT INTO kmo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Worek, rii awasen eecha wor, “Ada na God riiti kigdom hadabas maji kepin akar akaman sawo yeyebatak eena God riita ana eena heechirek yar.” ");
INSERT INTO kmo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Worek, rii Ju ma yechi lotu akak Judia nosapek tari, rii maji sawotar. ");
INSERT INTO kmo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Akar nedii pochi Jisas rii Genesaret paka bana bana siitiitarek, nokwapa ma mima ye God riiti maji meejik eena riitak ya yapowur. ");
INSERT INTO kmo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Worek, rii karakada jabiir upurusen gayetarek mey her. Emiyepen yatar ma ye mayan yeetiik heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Worek, Jisas rii jabiir pochik i yowur. I yowuchi jabiiren ameda diimiipareken riina woher. Worek, Jisas rii jabiirek yiniga ma mima yenya maji pokii tar. ");
INSERT INTO kmo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","5","Maji poko hamarek, Jisas rii Saimon riina eecha wor, “Mii jabiiren na diimiichinyak, sa wawek inyak, kwoti mayan na yeechi paka rabo.” Saimon rii awasen wor, “Harapa ma, diita niyi nota harapa yon otii tari, emiyep saka yarek. Wowak, miita bawak, an mayan kawka rabok.” ");
INSERT INTO kmo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Worek, ye mayan kawka yeechi rabor. Raborek, ye nokwapa nokwapa emiyep yar. Yeechi maya emiyepeka neekiik otiir. ");
INSERT INTO kmo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Worek, ye yechi nareboyen ye ya yenya kiyatayek uwar. Ye yarek, yecha jabiir upurusek emiyep woy takakiisiir. jabiir gubuk otiir. ");
INSERT INTO kmo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita rii hechi Jisas riiti yatii jumuk rii yatii bogok eeka putiichi yir. He yichi eecha wor, “Harapa Ma mii na ana heechi i. An boboy kapasek otii tawa ma!” ");
INSERT INTO kmo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Rii akar ma riitaka tari, ye nokwapa nokwapa yar emiyepen hechiniga ye henebarabor. ");
INSERT INTO kmo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon riiti nareboy, Jems, Jon piiriita, Sebedi riiti yikapwa, piiriita akiibatar. Jisas rii Saimon riina eecha wor, “Opoche akiitanakech. Eeta komas nedii miita ma yenya yatakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Worek, ye jabiir i gayerek eyey boboyen heechi Jisas riina somowuniga ir. ");
INSERT INTO kmo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Akar nedii pochi Jisas rii akama pochik tar. Ma por rii eeka tari, riita nomaka tar. Rii Jisas riina heri, nosapek miy soma yepa saka wochi woyasachiyasa her, “Harapa Ma, miita hikiney, miipa ana otiiniga kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisas rii meejichi riiti mabak neekir. Neekichi eecha wor, “Ada eecha hikitu miita kepi siik. Na kepi ta!” Worek, nomaka tar boboy eeta heechir. ");
INSERT INTO kmo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Worek, Jisas rii riina wo sowur, “Akar man diita otiiwa boboyen opoche sawotanakech. Mii opelen otii tawa ma riina na nagwa nagwa i mayama na mukuchi. Wonyak miita na eecha otii Moses riita wor majibaga. Opelen na otii. Wonyak, eyey ma yepa miina hikikiita miiti maba eeta kepi sowa.” ");
INSERT INTO kmo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Worek, Jisas riita otiir maji ameya ameya i ye yatar. I ye yatarek, nokwapa nokwapa ma mima ye riina meejik yaniga hak otiitar boboyen otii kepi siiken eena yar. ");
INSERT INTO kmo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Worek, rii eechaba shebo shebo eemek ichi God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Akar nedii pochi Jisas rii maji pokii tarek, Perisi ye, maji pokii tar ma, yechaka Jisas riitaka bana bana yichar. Yecha eyey Galili, Judia nosap akaman, Jerusalem akaman heechi yar. God riiti hapaga otiir boboy Jisas riitaka eecha tarek, rii eena hak otii tar man otiiniga kepi siitar. ");
INSERT INTO kmo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma kaw ye yatii tapa har man yemek jichi kiyaniga yar. Yayari, aka wok Jisas riita siitii tar eemek yayar seechiken otiiri, ");
INSERT INTO kmo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","eeta eem ma mima nokwapa nokwapa tar. Tarek, eena i hipurek, heechi ye akama toko yo diigiir. Diigiichi yemek jir ma riina supuk heechirek yeyir. Yeyi Jisas riita siiti tar yatii jumuk seechir. ");
INSERT INTO kmo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Seechirek, Jisas rii yechi hiki siitiichichawa boboyen heri, rii eeta ma riina eecha wor, “Ma, miiti kapasek boboyen ada bachipoyewa.” ");
INSERT INTO kmo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lon maji pokii tar ma ye, Peresi ye awasen awasen maji batar. Ye eecha wor: “Diita ma rii kapo nama? Rii God riina kapasek maji bawa? Namapa kapasek boboyen bachi poyetu? God riitaba saniga keena kapasek boboyen bachipoyetu.” ");
INSERT INTO kmo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Worek, Jisas rii yechi inyakan eyey herek, rii awasen eecha wor, “Boyewak kwo inyaka eecha hikitu? ");
INSERT INTO kmo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Boy yo harapa? Ada banak, miiti kapasek boboyen bachipoyer? Ada banak, na sokwa i! ");
INSERT INTO kmo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ada kwona mukuchik Ma Yikapwa rii keena diita nosapeka tawey, hapaga boboy riitaka tawey, rii kapasek boboyen bachipoyeken.” Worek, rii yatii tapa har man eecha wor, “Ada miina wocho, na sokwa mi wa gwosii yeechiniga mi akamak i.” ");
INSERT INTO kmo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ameya eeta ma rii eyey ma mima yechi miy somak sokwachi ri watar gwosii yeechiniga akamak icharek, God riiti hin harapa yesokwaniga ir. ");
INSERT INTO kmo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma mima ye riina heri, eyey henebarabo hamar. Harapa inyaka wopuakiichi ye God riiti hin yesokwachi wochar: “Apa nota hadabas tar boboy kepin hewa!” ");
INSERT INTO kmo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Worek, Jisas rii sabak ichi takis yan ya tawa ma, riiti hi Livai, riina rii her. Rii riiti takis yan ha tawa akak yicharek, rii her. Jisas rii riina eecha wor: “Ana na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Worek, rii sokwa riiti eyey boboyen heechi riina somowutar. ");
INSERT INTO kmo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Worek, Livai rii harapa aboboyen riiti akak Jisas riina nokusha ar. Nokusha atarek, nokwapa nokwapa takis yan yatar ma ye akar ma ye ya yibar. ");
INSERT INTO kmo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Perisi kaw ye yechi lon maji pokii tar ma ye jisas riiti disaipel yenya ow otii majin batar. Yecha eecha woher, “Boyewak kwo takis yan ya tawa maka kapasek otii tawa maka eecha nousha ato?” ");
INSERT INTO kmo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas rii awasen yenya eecha wor, “Kepi tawa ma mima yecha dokta riita kiyatayeken wohekasakech. Yaho. Hak otii tawa ma yechaba wohecho. ");
INSERT INTO kmo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kwoya hechawa ma yenya ada sugu wopu dareboyeken eena uwak saka yarek. Ada kapasek tawa man ada wonyak, ye sugu wopu dareboyeken eena yar.” ");
INSERT INTO kmo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma ycha Jisas riina eecha wor, “Jon riiti disaipel ye aboboy akasakech God riina majibatar. Perisi disaipel ye eechaba otiitar. Wowak, miiti disaipel yecha ukun ab oboboyen ato.” ");
INSERT INTO kmo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas rii meejichi eecha wor, “Kwo boy hikitu mima ya tawa ma riita riiti apoma yechaka tawey, yecha kapo ukuban ato? Yaho. Eecha otiikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Eeta nedii yakiita eeta mima ya tawa man yeechi ye inyak yenapa heechikiita. Eeta nedii yecha aboboyen saka atakiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas rii diita shiyi tawa majin bar, “Ma ye diita boboy eecha otiikasakech: ma ye siivatabi akaren diigiichi bonye siivatabi supun kapakasakech. Yaho. Ye eecha otiiney, akar siivatabi iipa kapasek siinak, akar iipa bonyeka kiki siikasakech. Eeta nobo jekiita. ");
INSERT INTO kmo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma ye akar wain uku sakapa meme sapi bonye siitii woyekiitawak. Iipa uku buwuchi sakanak sapi iipa kapasek siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma ye wain uku akar meme sapi akarebak na woy. ");
INSERT INTO kmo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma ye mashi wain uku awey, ye akar wain ukun kawka wohekasakech. Ye eecha hikitu mashi wain uku eeta kepi tawa.” ");
INSERT INTO kmo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat nedii pochi Jisas rii wit sokwa tawa nosapek chishitar. Chishitarek, riiti disaipel ma yecha wit siiken siikiiriichi yayaniga tapak neeki siigegichi atar. ");
INSERT INTO kmo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Perisi kaw ye eecha wor, “Boyewak kwo Sabat nediik diina otiito? Eeta lo eena eecha wocho, otiikasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas rii yenya awasen wor, “Devit rii riiti wakasa ma yechaka eecha heechi otiirek kwo kapo eena kadiikasakech? ");
INSERT INTO kmo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit rii God riiti holi akak iyarechi God riiti miy somak tar geyn yeechiniga yaya eechi riiti wakasa ma yenya kaw har. Wowak, noti lo eecha wocho, opelen otii tawa ma ye diita geyn sa saniga a ta. Akar ma por rii diita geyn aney, rii noti lon wosowoyetu.” ");
INSERT INTO kmo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisas rii kawka eecha wor, “Ma Yikapwa rii Sabaten harapa tawa ma.” ");
INSERT INTO kmo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Akar Sabat nedii Jisas rii Ju ma yechi lotu akak wok iyarechi maji pokii tar. Ma por rii eeta akak tari, riiti mama yepa tapa har. ");
INSERT INTO kmo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Worek, lon maji pokii tar ma kaw ye Perisi kaw ye Jisas riina hechar. Yecha eecha hikitar rii noti lon nediik riikiiney, nota riina yeechi ye i anasakiita. Yecha hikitar rii kapo Sabat nediik kapasek tar man otii kepi siiken. Eena riina ye hechar. ");
INSERT INTO kmo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Worek, Jisas rii yechi inyakan hechar. Hechi rii tapahar man rii eecha wor, “Na sokwa diika mapo siitii.” Worek, rii sokwachi eeka siitiir. ");
INSERT INTO kmo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Siitiirek, Jisas rii yenya eecha wor, “Ada kwona wohecho, noti lo kapo boy eecha wocho, Sabat nediik boboy kepin na otii? Kapo boboy kapaseken na otii? Kapo ii eecha wocho ma yenya na yesokwa ta? Kapo ma yenya na dagiirepoy ta?” ");
INSERT INTO kmo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Worek, rii yenya mey maka hechi eeta ma por riina eecha wor, “Miiti tapan na danegwa.” Meejichi danegwar. Danegwarek, otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Worek, yechi inyaka wopu harapa kwotayer. Yecha Jisas riina majin ba yey tar. Riina otiik kapasek majin batar. ");
INSERT INTO kmo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Eeta nediik Jisas rii God riina maji bak kwowuk heechi ir. Rii eyey niy God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Uhadiirek, rii riiti disaipel uwar. Uwarek, ye yarek, rii 12 man riita hisiir. Rii yenya eecha habatar, Aposel. ");
INSERT INTO kmo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aposel diitata: Saimon (rii akar hi har, Pita), riiti kumwoy, Endreu, Jems, Jon, Pilip, Batolomyu, Matyu, ");
INSERT INTO kmo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Tomas, Jems (Alpias riiti yikapwa), Saimon (akar hi Selot). ");
INSERT INTO kmo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Jems riiti yikapwa), Judas Iskeriot, rii Jisas riina komas magiirechir. ");
INSERT INTO kmo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas rii kwowuk taren saka yaniga rii sheysheyek siitiir. Nokwapa nokwapa riiti disaipel ye riitaka tar. Nokwapa nokwapa akar ma mima ye Judia nosap tar ma mima, Jerusalem akamak tar ma mima, somakwotii pa bana bana tar akama, Taia, Saidon ma mima yecha eyey heechi yaniga eeka tar. ");
INSERT INTO kmo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ye yari, riiti maji meejik eena yar. Yechi kapasek boboyen hak otii tar boboyen riita otii kepi siiken eena yar. Ma kaw kapasek spiriteka tari, yarek, Jisas rii yenya otiiniga otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eyey ma mima yecha riiti maban neeki her. Worek, riiti hisaw hapaga tawaga tawa boboyen rii heechirek yechak irek, ye kepi sokwar. ");
INSERT INTO kmo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas rii riiti disaipelen hechi eecha wor, “Kwo biish tawa ma na kwoya woy hiki. God riiti kigdom, ri akama, eeta kwoti. ");
INSERT INTO kmo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Apa kwo eecha hatawak, kwo na kwoya woy hiki. Kawopa takiikiisiikiita. “Apa kwo keyatawak, na kwoya woy hiki. Komas kwopa hegekiita. ");
INSERT INTO kmo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Kwo Ma Yikapwa riina somowutawey, eena ma ye kwona yuyatawak, nosowoyetanak, maji kubuk pichanak, eecha wocho kwo kapasek tanak, kwoti inyaka na kwoya woy hiki. ");
INSERT INTO kmo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Otiitanak, napa hiki ta! Napa yatii kwoya tosii ta. Kwi harapa ya hevenek tawa. Yechi wayega yecha piirapet yenya eechaba otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Kwo harapa yaka tawa ma harapa kapasek boboy kwotaka eecha siikiita. Eeta boboy kepi kwotaka tari, eeta hamawa! ");
INSERT INTO kmo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kwo apa takiikiisowey, kapasek harapa boboy kwotaka eecha siikiita. Komas kwopa eecha hatakiita. “Kwo apa hegetawey, kwo komas kwo keyinak keya muk sakatakiita. Kapasek boboy kwotaka yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Eyey ma ye kwoti hin yesokwaney, napa hecha. Harapa kapasek boboy kwotaka eecha siikiita. Yechi wayega ye eechaba woshepii tawa piirapet yechi hin eechaba kepi batar. ");
INSERT INTO kmo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ana meeji tawa ma kwona ada wocho: Kwoti ow ana pichawa man na rukusii ta. Ma yecha kwona kapasek otiiney, kwo napa yenya hehar ta. ");
INSERT INTO kmo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma kaw ye kwona maji kapasek baney, kwo napa yenya maji kepi ba ta. Ma ye kwona kapasek otiiney, kwo napa yenya God riina maji ba ta. ");
INSERT INTO kmo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma por rii miina wagii yepan pinyey, mii na way yokwan heechinak sa pi. Ma por rii miiti saket kwoyava yaney, miiti ruwu tawa siivatabi na haba. ");
INSERT INTO kmo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma por rii boboyen miina wohenyey, eena ha. Ma por rii miiti boboyen yaney, mii opoche eecha wochatabakech ana awasen napa ha. ");
INSERT INTO kmo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Akar ma yecha miina otiichik hikitawey, napa yenya otiichicha. ");
INSERT INTO kmo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kwota kwona rukusii tawa ma yechaban rukusii taney, boyewak kwo eecha hikitu kepi boboyen kwotaka yakiita? Kapasek yo otii tawa ma yecha yenya rukusii tawa ma yenya rukusiito. ");
INSERT INTO kmo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kwota kwona otii kepi siitawa ma yechaban kwota otii kepi siiney, boyewak kwo eecha hikitu kepi boboy kwotaka yakiita? Kapasek otii tawa ma ye eechaba yechaban hehareto. ");
INSERT INTO kmo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kwo akar man boboyen hataney, kwo eecha hikitaney rii sapo kapasek yo otii tawa ma ye akar man heechiniga eechaba hikitu boboy ana awasen hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yaho! Kwona o ana pichawa ma yenya na rukusii tanak, na hehar ta. Na yeyada ha ta. Opoche eecha hikitanakech ada awasen yak. Kwota eecha otiiney, komas hisaw yan yakiita. Kwo harapa howuk tawa God riiti yikapwa siikiita. Egeyebak tawa man kapasek yo otii tawa man God riita hehareto. ");
INSERT INTO kmo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kwoti Eepi rii rukusiichi kepi otiitawak, kwo eechaba napa rukusii otiiba ta. ");
INSERT INTO kmo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Akar man kwo opoche wo diimaniga maji anasatanakech. Eecha otiiney, God riipa saka kwona anasakiitawak. Kwo opoche akar man kapasek batanakech. Eecha otiiney, God riipa kwona saka kapasek bakiitawak. Akar ma yecha miina kapasek otiiney, miiti inyakak kapasek hiki tawey, na abosuch. Otiiney, God riipa miiti kapasek otii tawa boboyen riipa abosuchikiita. ");
INSERT INTO kmo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Akar man na yeyada ha ta. Otii taney, God riipa kwona hakiita. Otii taney, kwo yatawa boboy takiikiisiik. Otii taney, kwo ya tawa boboy tapa takiikiisiinak, kaw nosapek sakakiita. Kwo akar man hatawey, God riipa awasen kwona eechaba eechaba hatakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas rii diita shiya tawa majin eecha wor: “Ma por rii riiti miy dumutawey, riipa akar miy dumu tawa ma riin nobon saka mukuchikiitawak. Riipa eecha otiiney, piiriipa supuk sakakiita. ");
INSERT INTO kmo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maji pokii wakasa ma ye mapo neeki ichawa ma riin otiipoyechi ye howuk siikasakech. Eyey maji pokii wakasa ma ye maji pokii hamanak, ye sokwa mapo neeki ichawa ma tawaga eechaba siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Boyewak mii miiti kumwoy riiti miyik tawa riigan hewak, mii saka miiti miy hewak me tapa eeta miiti miyik tawa? ");
INSERT INTO kmo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Boyewak mii miiti kumwoyen bato, “Kumwoy, ada miiti miyik tawa riigan yaken otiito. II mii saka hewak, miiti miyik tawa harapa me tapa? Mii harapa woshepii tawa ma! Mapo eeta me tapa miiti miyik mapo tar na ya. Na yanak, komas miipa hehar hechi kumwoy riiti miyik tawa riigan miipa yakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Me kepi kapasek siik saka wakiitawak. Me kapasek sakapa siik kepi wakiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma rii me poren hehar henyan siiney, rii siiken henyak, rii hehar he siitiichikiita. Ma ye arey poko siik kepin siikiiriikasakech. Ma ye heemi siiken saka mokubu men siikiiriitawak. ");
INSERT INTO kmo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma kepi rii boboy kepi riiti inyaka wopuk tawak, rii eena hehar boboy otiito. Ma kapasek rii boboy kapasek riiti inyaka wopuk tawak, rii eena kapasek boboyen otiito. Ma por riiti mesek eecha tawey, riiti kuja eeta eechaba otiito.” ");
INSERT INTO kmo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Boyewak kwota ana eecha habato, ‘Harapa Ma, Harapa Ma’, Kwo eeji maji saka somowutawak? ");
INSERT INTO kmo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eyey ma ye adak yawey, eeji majin meejitawey, somowu otii tawey, rii diitata: ");
INSERT INTO kmo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Rii aka otii tar maga tar. Rii harapa aka wa kwotiichi kwatiin heyik siitiichir. Komas harapa uku ya gamuri eeta aka sakakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma por rii eeji majin meejiney somuwunan siiney, rii diitata: Rii kapasek aka otii tar maga eecha tar. Rii akan otiiri, kwatii wa he yey yikasakech. Uku ya gamuri eeta aka eeta ameya sakar. Kapasek siir.” ");
INSERT INTO kmo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas riita jecha bar majin ma mima yenya ba hamarek, riita heechi Kapaneam akamak ir. ");
INSERT INTO kmo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rom ma o ana pichawa kepten ma eeka tari, riita riiti wakasa ma riitaka tari, rii riina rukusii tar. Diita wakasa ma rii harapa hak otii tar. ");
INSERT INTO kmo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kepten ma rii Jisas riita otiir majin meejirek, rii Ju ma harapa kawen Jisas riina heechirek ir. Jisas riina wohey riiti wakasa man otii kepi siiken, eena heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yecha Jisas riitak yarek, yecha riina woyasachiyasa woher, “Diita kepten ma riina na kiyatayi. ");
INSERT INTO kmo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Rii kepi otiito. Riita noti ma mima yenya rukusiichinigalotu akan nona otiichir.” ");
INSERT INTO kmo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Worek, Jisas riita yechaka ir. Kepten riiti aka Jisas rii bana bana tarek, kepten ma rii riiti nareboyek Jisas riina diita majin wochirek ir, “Harapa Ma, boyewak mii harapa yo yayawa? Anapa saka kikisiikiitawak eeji akak miita yaken otiiwey. ");
INSERT INTO kmo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eena anapa saka miina yakiitawak. Majin na wo sawo tanak, eeji wakasa ma riipa otii kepi siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ada eechabatawa: eeji harapa ma adana tabo yichu. Ada eeji o ana pichawa wakasa ma yenya tabo yichu. Ada yenya wo sawonak, yecha otiikiita. Ada diita man eecha wonyey, ‘Na i’, riipa ikiita. Ada akar man eecha wonyey, ‘Na ya’, riipa yakiita. Ada eeji wakasa man eecha wonyey ‘Na otii’, riipa otiikiita. An hikitu. Miita wonyak, eeji wakasa ma riipa kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas rii diita majin meejirek, rii nyegerabor. Nyegerabochi rii sokwa siitiichi maji somowu tar ma yenya wor, “Ada diita yikadey hiki siitiichichawa boboyen Isrel ma mimak yechaka hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Worek, heechirek ir ma ye Jisas riina heechi Kkepten riiti akak iyarer. Iyarechi ye yasaya her eeta wakasa ma rii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Komas ameda nedii Jisas riita akar akamaka ir. Eeta akama siiti hi Nen. Riiti disaipel ye nokwapa nokwapa akar ma ye riitaka eecha ir. ");
INSERT INTO kmo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jisas riita akama inyi nubereja iyarerek, ma mima ye har man yemek jichi kiyaniga yatar. Har ma rii mibiya mima siiti yikapwa podareba tar. Nokwapa nokwapa kata akama ma mima ye siitaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Harapa Ma rii siina hechi rii inyakapa hikichi eecha wor, “Ni opoche keyatanakech.” ");
INSERT INTO kmo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Worek, rii i bana bana siitii har ma riiti yemen tapak how neekir. Neekirek, yemek kiyatar ma ye siitiir. Siitiirek, Jisas rii eecha wor, “Hadeyey ma, ada miina cheyeto na sokwa.” ");
INSERT INTO kmo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Worek, har ma rii sokwa yiniga maji bar. Worek, Jisas rii diita kepi siir yikapwan riiti nokwapa siina awasen har. ");
INSERT INTO kmo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Eyey ma mima ye eena harapa akiichi God riiti hin yesokwachi wor: “Harapa piirapet por rii notaka eecha sokwar. God riita riiti ma miman yesokwaken yar.” ");
INSERT INTO kmo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Diita maji eeta Judia akama akamak i ye yatar. ");
INSERT INTO kmo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Uku yeechir Jon riiti disaipel yecha Jon riina Jisas riita otiir boboyen wor. ");
INSERT INTO kmo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Worek, Jon riita disaipel upurusen uwarek riitak yar. Yarek, riita Harapa Ma riina diita majin woheken heechirek ir. “Mii boy kapo komas yak wochar ma. No boy kapo akar man kowukiita?” ");
INSERT INTO kmo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yecha Jisas riitak yarek, yecha eecha wor, “Uku yeechi tawa Jon riita miina woheken sinya heechiwak yawa, ‘Mii boy kapo komas yak wochar ma. No boy kapo akaren kowutakiita?’” ");
INSERT INTO kmo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Eeta nedii Jisas riita nokwapa nokwapa man otii kepi siir. Nokwapa nokwapa hak otii tar boboyen, miy dumutarin, kapasek gabak tar man otiiniga kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas rii Jon riita heechirek yar ma yenya awasen wor, “Na awasen i Jon riina kwota her boboyen meejir boboyen napa sawo. ‘Mi dimur ma ye hecho, yatii kapasek tar ma ye chishitu. Nomaka tar ma yenya otii kepi siibar. Mabiya giitar ma ye meejito. Har ma yenya otii yesokwa yichir. Kiiriisiiposii tawa ma yenya God riiti hadabas majin sawoto. ");
INSERT INTO kmo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ma por riita ana hiki siitiichichawa boboyen abosuchutanan siiney, ada komas yak wochar ma eena hikitaney, riipa kwoya woy hikikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon riita heechirek ir ma piiriita Jisas riina heechirek, Jisas rii uku yeechir Jon riina maji sawo tar, nokwapa nokwapa ma yenya. Rii ma mima yenya eecha wor, “Kwo mashi Jon rrina me biish tar eemek i heri kwo boyen heken eena hikitar? Kwo kapo wohija sowa howu tarin eena i heken hikitar? ");
INSERT INTO kmo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Boyega kapo kwo i her? Kapo kwo i ma por rii siivatabi kepin ruwutarin heken eena ichar. Yaho. Na meeji. Diita yikadey ruwu tawa ma ye anadii boboy kepi yechaka tawey, ye eeta diita nosapen aka tabo yichawa ma yechi akak yichu. ");
INSERT INTO kmo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ana no wo, kwo boyen heken eena hikitar? Kapo piirapet poren heken eena hikitar? Ayo, ada kwona wocho, piirapet ye eeta karakada, kwota heri rii eeta harapa. ");
INSERT INTO kmo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mashi keyir maji eeta riina eecha wor, na meeji: God rii eecha wocho: ‘Eeji maji yeechi ye ichawa ma eetata. Ada heechinak, riita kwotaka mapo inyak, riipa nobon kwona takiichikiita.’” ");
INSERT INTO kmo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jisas rii kawka eecha wor, “Jon riita diita nosap maka tawey, rii eeta harapa, eyey nosap ma yecha karakada. Wowak, ma por rii God riiti eemek tawey, rii eeta harapa, Jon riita karakada.” ");
INSERT INTO kmo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Eyey ma mimaka takis yan ya tar ma yechaka Jon riita wo sawor majin meejir. Ye meejichi God riiti majin sumowurek, Jon riita yenya uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Worek, Perisi ye, lon maji pokii tar ma ye God riita yenya mukuchir boboyen ye nasowoyer. Nasowoyerek, yen Jon rii saka uku yeechirek. ");
INSERT INTO kmo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas rii kawka eecha wor, “Diita nedii ma ye boyega shecha taken otiito? ");
INSERT INTO kmo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yikapwa ye anemesh roko tawa eemek anemesh roko tawaga ye eechaba tawa. Yikapwa kaw ye akaren uwachi wocho: ‘No kwona sagey mambu piita tawey, kwo hokwa tosokasakech. Nota inyakapwa hiki hokwan chichawey, kwo chibakasakech.’ ");
INSERT INTO kmo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uku yeechir Jon rii yari, gey akasakech, wain uku abakasakech. Worek, kwo eecha wor, ‘Rii gabaka tawa!’ ");
INSERT INTO kmo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma Yikapwa, Jisas, rii yari, geyn atari, wain uku abatari, kwo eecha wor, ‘Diita man na he! Rii geyn harapa atawa ma, wain uku atawa ma. Rii takis yan ya tawa ma riiti nareboy!’ Rii kapasek otii tawa ma yechi nareboy! Diita kwota otii tawa abo. ");
INSERT INTO kmo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nago, kata ma ye God riiti inyakaka boboyen yataney, yecha hiki siitiichichu eena eeta boboy siiken.” ");
INSERT INTO kmo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Perisi ma por rii Jisas riina aken woher. Woherek, Jisas rii riiti akak iniga aken hey yir. ");
INSERT INTO kmo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kapasek otii tar mima kata akamak yichar. Sii meejir Jisas rii Perisi ma por riiti akak otii atar majin sii meejir. Meejichi sii kwowa ya tawa uku botolek yeechi sii neeki Jisas riitak ir. ");
INSERT INTO kmo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Irek, sii Jisas riiti magiirek yatii jumuk bana bana siitii keya tar. Keya tari keya muku Jisas riiti yatiik saka tar. Saka tarek, sii masebiyak yatiin bachichi omoreramorechi kwowa ya tawa ukuk gwotiir. ");
INSERT INTO kmo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Worek, eeta Perisi ma rii Jisas riina aken woheririi mayama hikir: “Diita ma rii piirapet siiken taney, rii waga hikitu diita mima sii riina neediwey sii kapasek. ");
INSERT INTO kmo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas rii Saimon riina eecha wor, “Saimon, ada miina maji bak.” Rii awasen eecha wor: “Ayo, maji pokii ma, na ba.” ");
INSERT INTO kmo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas rii eecha wor, “Ma upurus piiriitana, ma por rii yan hari, piiriita riina komas awasen apa hakiita. Ma por riin 100 dola harek, ma por riin 10 dola har. ");
INSERT INTO kmo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Worek, piiriita riina awasen yan hakasakech. Piir yan biish tar. Worek, rii piiriiti awasen hanan bokonar. Worek, ada miina wohecho: Shecha tawa ma rii riina harapa rukusiit?” ");
INSERT INTO kmo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Waimon rii awasen wor, “An eecha hikitu kata ma rii harapa ya mayakan abosuchir rii eena harapa riina rukusiito.” Jisas eecha wor, “Saimon mii eeta siiken maji bato. ");
INSERT INTO kmo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Worek, Jisas rii mima siina dareboyechi Saimon riina eecha wor, “Miita diita mima siina na he. Ada miiti akak yawa. Yawey, miita ukun yeechi yaya yatii eejinsaka uku yeetiiwak. Wowak, mima siita siiti miy ukuk yatii eneeka uku yeetiiwa. Yeetiiwak, siiti masebiyak bachuwa. ");
INSERT INTO kmo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ada yawak, miita ana saka harenaka yaya omoreramorewak. Wowak, siita ada ya sayawak siita eeji yatiin omoreramorewa. ");
INSERT INTO kmo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Miita kwowoka ya tawa kwar eeji masekiik gwotiikasakech. Siita eeji yatiin kwowa ya tawa kwar gwotiiwa. ");
INSERT INTO kmo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ada miin maji wocho, siita ana harapa rukusiitawey, ii eeta mukuchichu siiti harapa kapasek otii tawa boboyen bachipoyewa. Ma ye karakada kapasek boboyen bachi poyeney, ye mukuchichu ye rukusii tawa boboy eeta karakada tawa. ");
INSERT INTO kmo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Worek, Jisas rii mima siina eecha wor: “Niji kapasek boboyen eeta bachipoy hamawa.” ");
INSERT INTO kmo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Worek, cheyek yichar ma ye awasen awasen maji batar, “Dii kapo nama rii kapasek boboyen bachipoyetu?” ");
INSERT INTO kmo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisas rii mima siina eecha wor, “Niji hiki siitiichichawa boboy eeta ninya otii kepi siichuwa. Na i inyaka kwoya hiki i.” ");
INSERT INTO kmo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Komas Jisas rii karakada akaman harapa akaman God riiti hadabas kigdom majin sawoken eena i ye yatar. Riiti 12 disaipel ye riitaka eecha chishitar. ");
INSERT INTO kmo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mima kaw ye riitaka eecha ibatar. Yenya riita kapasek gaba hak otii tawa boboyen eena otiiniga kepi siir. Maria siitaka 7 kapasek gaba siitaka tarek, Jisas rii eeta yeechi rabor. Siitihi Magdala. Sii ibatar. ");
INSERT INTO kmo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herot riiti wakasa ma, Susa, riiti mima Joana sii eeta ibatar. Susana siitaka akar nokwapa nokwapa mimaka eecha ibatar. Ibatarek, yecha Jisas riina riiti disaipel ma yenya kiyatay tar. Yecha yenya aboboy tokochi yenya havatarek, heharetar. ");
INSERT INTO kmo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nokwapa nokwapa ma mima yechi akamak heechi Jisas riitak yar. Nokwapa nokwapa ma mima ye ya yopowurek, Jisas rii diita shiya tawa majin yenya wor: ");
INSERT INTO kmo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ma por rii wit yechi siiken nosap rabok ir. Rii siiken rabo tari, siik taw eeta nobok sakar. Nobok sakarek, ma ye yatiik piitiir. Apo ye hechi atar. ");
INSERT INTO kmo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Siik kaw eeta papaka tawa nosapek eeka sakar. Sakari, sokwachi ameya reekesiir. Boyewak? Nosap ukukasakech eena reekesiir. ");
INSERT INTO kmo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Siik kaw eeta yeemika tawa poko hek eeka sakar. Sakari, eeta pokok eeka gamupoyer. ");
INSERT INTO kmo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Siik kaw eeta nosap kepik sakar. Sakari, eeta harapa sokwachi siik kepin war. Wit por siik 100 watar.” Worek, Jisas kawka eecha wor, “Ma mabiyaka taney, meejik wonyey, na meeji.” ");
INSERT INTO kmo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas riiti disaipel ye Jisas riina diita shiya tawa maji mun mukuchiken eena woher. ");
INSERT INTO kmo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas rii awasen eecha wor, “God riiti veenyi tawa boboy eena kwona hikiken har. Akar ma yenya shiya tawa majik eeka yato. Yatawak, yecha eena hechi hikikasakech. Yecha meejichi mabiya hehar meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Diita shiya tawa maji eecha wocho: eeta wit siik eeta God riiti maji. ");
INSERT INTO kmo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kata siik nobok sakari dii eeta majin ma kaw ye meejitawak, Gaba riita yaniga majin mesek taweyn yeechi raboto. Gaba rii eecha hikitu: “Kapo yepa God riina hikinak, riipa yesokwa yichikiita.” Eena rii majin yeechi raboto yechi inyakak tawey. ");
INSERT INTO kmo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kata siik papaka tawa nosap sakari, dii eeta majin ma ye meejichi kwoya hikitu. Wowak, diita maji biish shebo shebo otiito. Inyaka wopu yechi yik i ye yakasakech. Yecha riina ameda hikichi abosuchichu. Komas otii otii henya nedii yanak, yepa nobo kepin heechi kapasek ikiita. ");
INSERT INTO kmo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kata siik yeemik tawa pokokeeka sakari, dii eeta majin ma ye meejichi ameda sokwachi siik wakasakech. Diita nosap tawa boboyen inyakapwa hikitawey, yan hiki tawey, anemeshe roko tawey, eeta God riiti majin gamu poyetu. ");
INSERT INTO kmo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kata siik nosap kepik sakari, dii eeta majin ma ye meejichi mesekiik heechi majin somowuchiniga i i iniga yecha siiken wato.” ");
INSERT INTO kmo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ma ye haba hayechi gwosiik gamukasakech. Ehey kuruk har veenyikasakech. Hayechi ye cheyek kowu yichitu. Yichitawak, ma ye wok yasayanak yama hecho. ");
INSERT INTO kmo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Eyey boboyen diita apa veenyi tawey, komas eeta geenyik siikiita. Eyey boboyen dasiipiitari, komas yesha hechi geenyik yamak yesokwa yichikiita. ");
INSERT INTO kmo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kwo na hehar meeji ta. Kata ma ri boboyeka riita tawey, komas riina kawka hakiita. Kata ma rii boboy biish tawey, komas kata boboyen rii hikitu eeta riiti eena yeechi ye ikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisas riiti nokwapa Jisas riiti kumwoyyecha riitak yar. Yarek, yecha riitaka bana bana siitiikasakech. Nokwapa nnokwapa mima ma tarek, eena ya bana bana siitiikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma por rii Jisas riina eecha wor, “Miiti nokwapa miiti kumwoy yecha sabak siitiitawey, miina heken kowutu.” ");
INSERT INTO kmo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Worek, Jisas riita eyey ma mima yenya eecha wor, “Kata ma mima ye eeji maji meejichi somowuchi otiitawak, dii eeta eeji awi eeji kumwoy.” ");
INSERT INTO kmo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nedii pochi Jisas riita riiti disaipel yechaka jabiirek i ye ichi yenya eecha wor, “Nota reekichi kata yokwa pagiirebak ik.” Worek, yecha heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jabiir icharek, Jisas rii watar. Watarek, harapa sowa yar. Sowa yarek, jabiir uku siiva woyer. Siiva woyerek, ameda ameda kapasek siik otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Worek, disaipel ye Jisas riina ya cheyichi eecha wor, “Harapa Ma, Harapa Ma, nota hak otiito.” Worek, Jisas rii sokwachi sowa yatarin uku boro sokwa tarin anacheker. Worek, eeta sowa eeta uku boro eeta siir. Siirek, eeta biish tar. ");
INSERT INTO kmo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Worek, rii riiti disaipel yenya eecha wor, “Kwo hiki siitiichichawa boboy siitak tawa?” Worek, ye akiichi henebarabo taniga awasen awasen eecha wor, “Diita ma rii kapo nama? Rii sowan anachekerek, uku boro anacherek, eeta siir.” ");
INSERT INTO kmo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Worek, yecha jabiirek i Gegesa nosapek igayer. Diita nosap Galili nosap pagiireba yepak tar. ");
INSERT INTO kmo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisas rii gayechi rii yatii nosapek pagiirebak howu piitiirek, kapasek gabaka tar ma por rii akaman heechi ya Jisas riina jawur. Eetama rii maba siivatabi ruwukasakech. Riita riiti akak yikasakech, wakasakech. Rii tiiremo papa supuk wok eeka yichar. ");
INSERT INTO kmo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Rii Jisas riina hechi aya harapa uwatar. Rii ya Jisas riiti yatii jumuk saka waniga harapa wor, “Jisas mii Harapa Howuk Tawa God riiti Yikapwa! Miinawa, mii boy boboyen ana otiik yawa? Ada miina woyasachiyasato, miita ana pikasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisas rii kapasek gaban eecha bar. Nokwapa nokwapa nedii eeta kapasek gaba rii riina hehar neeki siitiichichar. Ma ye riina yatii tapa sen pokok kiitiitar. Kiitiitarek, rii neekichi ma biish tar eemek heechi ir. Kapasek gaba rii riina otii poyechirek rii ir. ");
INSERT INTO kmo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas rii riina woher, “Miiti hi na haba, ii boy?” Rii awasen eecha wor, “Eeji hi eeta nokwapa nokwapa.” Boyerek rii eecha wor, Nokwapa Nokwapa? Nokwapa nokwapa kapasek gaba riiti wok irek, eena riiti hi eecha habar, Nokwapa Nokwapa. ");
INSERT INTO kmo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eeta kapasek gaba riitak tari, ye Jisas riina woyasachiyasar, “Hi uwu tawa kapasek supuk saka wochinak ik tawak.” ");
INSERT INTO kmo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Worek, nokwapa nokwapa poyi ye kwowuk a yey tar. Tarek, kapasek gaba ye Jisas riina woyasachiyasa woher, “Noti poyeka eecha ik!” Jisas rii yenya awasen eecha wor, “Na i.” ");
INSERT INTO kmo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Worek, kapasek gaba ye eeta man heechi i poyi yechi wok i siir. I siirek, poyi ye kwowu heechi amaba iniga paka duruniga uku aniga ha hamar. ");
INSERT INTO kmo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Worek, poyin siitii kowu tar ma eena hechi ameya heechi akamak, akak iniga ye diita otiir noman eena sawotar. ");
INSERT INTO kmo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma mima ye meejichi akaman heechiniga hek ir. Yecha Jisas riitak ya her. Kapasek gaba heechi tar ma rii Jisas riiti yatiin jumuk keyi yir. Rii siivatabi ruwur. Rii riiti marenoku inyaka wopu eeta opoy kwoya woy hikitar. Worek, eyey yecha akiir. ");
INSERT INTO kmo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eeta ma ye heri yecha akar ma yenya sawor. Kapo boyega shecha otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Worek, eyey Gegesa ma mima ye Jisas riina heechinak iken eena woher. Yecha harapa akii tar eena woher. Worek, Jisas rii jabiir i yeyichi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kapasek gaba heechi tar ma rii Jisas riina woyasachiyasar, “Ada miitaka eecha ibak.” Worek, Jisas rii riina bokoneechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Rii eecha wor, “Mii miiti akamak na i. God riita miina otii kepi sowey, akar ma yenya napa sawo ta.” Worek, eeta ma heechi riiti akamak ichi rii akamak tar man Jisas rii riina otiichirin eena sawo tar. ");
INSERT INTO kmo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas rii pagiireba yepak i gayerek, nokwapa nokwapa ma mima ye riina kowu tarek woshiatar. ");
INSERT INTO kmo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Worek, ma por rii, riiti hi Jairas, rii yar. Rii eeta akama Ju ma yechi lotu akan harapa ma tar. Yarek, rii Jisas riiti yatii jumuk i sakar. Saka wochi rii Jisas riina riiti akak yeechi ye ik eena rii woyasachiyasa tar. ");
INSERT INTO kmo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Riiti mima yikapwa sii eeta podateba sii harapa haken otii tar eena rii Jisas riina woher. Jisas riita irek, nokwapa nokwapa ma mima ye ya riina somowutar. ");
INSERT INTO kmo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Worek, mima pochi sii tari, siiti maba pi 12 sukwiya yabatar. Yabatarek, ma ye siina otii kepi siikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Worek, eeta mima sii Jisas riiti magiirek yaniga riiti siivatabin howu dagiirer. Dagiirerek, eeta siiti yatar pi ameya kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Worek, Jisas rii woher, “Nama ana howu dagiirewa?” Eyey ma mima eecha wor, “Yaho.” Worek, Pita rii riina eecha wor, “Harapa Ma, nokwapa nokwapa ma mima ye miitaka ya yopo wochi siitiito.” ");
INSERT INTO kmo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisas rii eecha wor, “Ma kaw mima kaw por ana howu dagiirewa. Eeji harapa boboy eeta ana heechi iwa, an hikiwa.” ");
INSERT INTO kmo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Worek, eeta mima sii hikir Jisas riita siina hehar he hamar. Worek, sii heneba rabochi nubu nubuniga Jisas riitak yar. Yarek, sii Jisas riiti yatii jumuk saka war. Eyey ma yechi mi somak tarek, sii Jisas riina wor, “Ada miina howu dagiir hewak, ada eeta ameya kepi sowa.” ");
INSERT INTO kmo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Worek, Jisas rii siina eecha wor, “Eeji yikapwa, niji siitiichichawa boboy eeta ninya otii kepi siichuwa. Niji inyaka wopu sapa eshar i.” ");
INSERT INTO kmo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Riita diita majin batarek, maji wochirek ir ma rii Jairas riitiakan heechi yar. Rii Jairas riina eecha wor, “Opoche mii Harapa Ma riin kawka wohechanakech. Miiti yikapwa sii eyey har.” ");
INSERT INTO kmo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Worek, Jisas rii meejichi Jairas riina wor, “Opoche akiitanakech. Na hiki siitiichicha. Siita otii kepi sokwak.” ");
INSERT INTO kmo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Akak iyarechi rii Pita, Jon, Jems, yikapwa siiti awi, eepi yechaka aka wok eechaiyarer. Rii akar ma mima yenya anacheker. ");
INSERT INTO kmo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eyey ma mima ye eeka tari, ye diita yikapwa siita kechi keyatar. Worek, Jisas rii eecha wor, “Opoche keyatanakech. Yikapwa hakasakech. Sii biish wato!” ");
INSERT INTO kmo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Worek, ye riina hegi ye itar. Yecha eecha hikitar sii eeta eyey har. ");
INSERT INTO kmo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Worek, Jisas rii siiti tapan neekichi cheyir: “Yikapwa na sokwa.” ");
INSERT INTO kmo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sii saniyeechi sokwar. Sokwarek, Jisas rii eecha wor, “Aboboyen na yeechi siina hava.” ");
INSERT INTO kmo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Worek, siiti awi, eepi heneba rabor. Jisas rii piiriina wo sawor, “Ada otiiwa boboy opoche akar ma yenya sawotanakech.” ");
INSERT INTO kmo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas rii riiti 12 disaipel yenya uwarek, ye yar. Yarek, rii harapa hapaga boboyen yenya har. Yenya harek, yecha keena kapasek gaba yenya yeechiniga rabor. Yecha keena hak otii tar boboyen otiiniga kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Worek, rii God riiti majin sawoken, hak otii tar man yesokwa otii kepi siiken eena heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rii yenya eecha wor, “Kwo inyak, boboyek ye ikasakech. Kubu na heechi i. Aboboy woyi kwo na heechi iba. Aboboyen, yan, maba riki upurusen na heechi iba. ");
INSERT INTO kmo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma rii kwona woshianey, kwo kata akamak eeka yichanak, riiti akakbak napa eeka kiki sii. ");
INSERT INTO kmo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma mima ye kwona woshianan siiney, eeta akama na heechi i. Heechi ik otiinak, yatii cherin napa panebut pakachi heechi i. Diita eecha otiina boboy eeta yenya o batawa boboy.” ");
INSERT INTO kmo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Worek, riiti disaipel ye riina heechi eyey akamak i ye yatar. I ye yatarek, yecha hadabas majin sawotar. Yecha hak otii tar man otiiniga kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herot, rii Galili nosap aka tabo yima, rii nokwapa nokwapa Jisas rii otii tar boboyen meejichi rii somoyetar. Ma kaw ye eecha wor, “Uku Yeechir Jon rii awasen saniyar.” ");
INSERT INTO kmo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Akar ma ye eecha wochar, “Akar mashi mashi tar piirapet hachiniga riita eeta awasen saniyar.” ");
INSERT INTO kmo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herot rii eecha wor, “Ada Jon riiti borowaga dagii rabor. Diita otii tawa boboyen ada meeji tari, kapo nama otiito?” Worek, rii Jisas riina heken eena otii otii hechar. ");
INSERT INTO kmo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisas riiti aposel yecha awasen yar. Yarek, yecha Jisas riina yecha otiir boboyen sawor. Saworek, rii yechaka eecha Betsaida akamak yecha saniga heechi eeka ir. ");
INSERT INTO kmo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma mima yecha meejichiniga, ye nokwapa nokwapa riina somowutar. Somowutarek, Jisas rii yenya woshia ye ichar. Rii yenya God riiti kigdom majin sowotar. Rii hak otii tar man otiiniga kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ya ye i nedii riiti 12 maji pokii tar ma ye Jisas riitak yar. Yeechi eecha wor, “Diita ma mima yenya na heechinak sa i. Heechinak sa inyak, yecha akama aka diika tawey, ichi aboboyen anak, wak otiinak, sapa wa. Diita eem no tawey, makasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Meejichi Jisas rii yenya eecha wor, “Kwotaba aboboyen napa yenya hava.” Yecha awasen eecha no i aboboyen diita eyey ma mima yenya tokochik?” ");
INSERT INTO kmo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","5,000 ma mima diika eemek tar. Jisas rii riiti disaipel yenya eecha wor, “Na wonyak, sa i saniga saniga yopochi chichi yi. 50-50 yopo chichichi yi.” ");
INSERT INTO kmo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Disaipel ye otiirek, eyey ma mima ye hey yichar. ");
INSERT INTO kmo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Worek, Jisas rii geyen yokotapa yeechi emiyep upurusen yeechi, neriin mow hechi God riina woshiachi geyen reekii reekiichi, ma mima yenya homochiniga, haken riiti disaipel yechaka har. ");
INSERT INTO kmo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eyey ma mima ye atarek, ye eeta biidiir. Worek, disaipel ye gey kawen yeechi yaya 12 wasahaya kwowuk eeka woyi takiikiisiir. ");
INSERT INTO kmo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nedii pochi Jisas rii God riina saniga maji ba tarek, disaipel riitak yar. Rii yenya eecha woher, “Ma mima ye ana kapo shecha wocho? An nama?” ");
INSERT INTO kmo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yecha awasen riina eecha wor, “Ma kaw ye eecha wocho mii eeta uku yeechir Jon. Akar ma ye eecha wocho mii eeta Ilaija. Akar ye eecha wocho, mii eeta mashi saniyar piirapet.” ");
INSERT INTO kmo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Rii yenya eecha woher, “Kwo shecha hikitu. An nama?” Pita rii riina awasen wor, “Mii eeta God riiti Kraist’ Yak wochar ma.” ");
INSERT INTO kmo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Worek, Jisas rii riita bana majin akar man sawonakech eena anacheker. ");
INSERT INTO kmo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Rii eecha wor, “Eeta Ma Yikapwa rii sapa harapa kapan sapa meeji. Riina Ju yechi harapa ma ye sapa nasowoy ta. Harapa opelen otii tawa ma ye, lon maji pokii tawa ma ye riina sapa nasowey ta. Yecha riina sowakworek, yadii piiriichar hamanak, riin saniyanak, yesokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Worek, rii eyey ma miman eecha wor, “Ma por rii adaka iken gegiyaney, rii sapa keena riita ichawa nobon sapa heechi. Rii sapa eyey yadii riiti nobon heechiniga ana sumowuchiniga ha tawa nobobak i. ");
INSERT INTO kmo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kata ma rii riiti nobon heechiney, eeji hik yaney, riipa eechaba eechaba takiita. Hadabas nobok riipa ikiita. ");
INSERT INTO kmo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma por rii diita nosapek tawa eyey boboy nokwapa nokwapa riitaba yaney, riiti mesek wurubuyareboney, rii boyega shecha takiita? Riipa kapasek siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma por rii adana hiibiya riipa yanak, riipa riina hiibiya yakiita. Ma Yikapwa riipa yanak, riipa Eepi riiti hadabas boboyeka yayakiita. Yanak, Holi eje yechi hadabas boboy riitaka eecha yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ada majin siiken wocho ma kaw diika tawey, ye God riiti kigdom mapo henyak, komas ye hakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Rii diita majin ba hamarek, wik pochi hamar. Hamarek, Jisas rii Pita, Jon, Jems yenya yeechiniga kwowuk God riina maji baken eena ir. ");
INSERT INTO kmo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Rii God riina maji batarek, riiti miy soma akar mabak dariiboyer. Riiti siivatabi apoma siir. ");
INSERT INTO kmo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ameya ma upurus piiriita riitaka maji batar. Piiriita eeta Moses, Ilaija. ");
INSERT INTO kmo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hevenek tawa hadabas boboy kepi piiriitaka eecha yar. Yarek, maji batar. Jisas riita Jerusalem akamak i ha nedii eena batar. God riiti hikichi otiina boboyen Jisasrii sumowuken eena bar. ");
INSERT INTO kmo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita, riiti nareboy, yecha wachi sokwar. Sokwachi yecha Jisas riiti hadabas boboyen ma upurus riitaka bana bana siitii tarin her. ");
INSERT INTO kmo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma piiriita Jisas riina heechi iken otiirek, Pita rii eecha wor, “Harapa Ma, eeta kepi nota eecha diika tawa. Nota aka piiriichar otiik. Miina pochi otiichik Moses riina pochi otiichik. Ilaija riina pochi otiichik.” (Rii diita maji wori, rii saka hehar hikichi barek, pamenabar.) ");
INSERT INTO kmo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Rii ba tarek, hejagwayap ya saka bana bana siir. Bana bana siirek, disaipel ye akiir. ");
INSERT INTO kmo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gamurek, aya eeka eecha uwar, “Dii eeta eeji Yikapwa. Ada riina hisiiri, riina hapa meeji ta!” ");
INSERT INTO kmo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aya uwa hamarek, Jisas rii saniga siitiitar. Worek, disaipel ye diita majin anadii ma yen saka sawotarek. Yecha her boboyen ye anadii saka barek. ");
INSERT INTO kmo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iyi yadii yecha kwowuk heechi ye irek, nokwapa nokwapa ma mima ye riina nobok i jawor. ");
INSERT INTO kmo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma por rii nokwapa nokwapa mima ma yechi nediik siitiiniga Jisas riina uwar, “Maji pokii ma, ada miina woyasachiyasato, eeji yikapwa podat riina na ya he! ");
INSERT INTO kmo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kkapasek gaba eeta riina pichawak, rii harapa uwachi nosapeka saka hikisha yeshachi kujak sogweya yar. Eeta riina pishamanek tawey, eeta boboy riina ameya heechi ikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ada miiti disaipel yenya woyasachiyasarek, yecha raboken otii heri, ye saka kiki siirek.” ");
INSERT INTO kmo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas rii awasen eecha wor, “Kwo hiki siitiichinyan biish tawa ma siiken. Kwon sabwiya yeechi kapasek nobok heechi tawak ichawa ma. O! Shasha nedii ada kwotaka takiita? Shasha nedii diita nomoya tawa boboyen ada kiyakiita? Worek, rii ma riina eecha wor, “Miiti yikapwa na yaya! ");
INSERT INTO kmo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yikapwa yatarek, eeta kapasek gaba rii riina otiichirek, rii nosapek sakachi hikisha yeshar. Worek, Jisas rii kapasek gaban riina wo sowurek, yikapwan otii kepi siirek, rii riina riiti eepi riina awasen har. ");
INSERT INTO kmo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eyey ma mima ye God riita harapa hapaga otii tar boboyen herin, ye eena harapa nyegerabor. Ma mima ye Jisas riita otiir yon harapa hikitarek, Jisas rii riiti disaipel yenya eecha wor, ");
INSERT INTO kmo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Diita ada kwona wonya maji opoche abosuchitanakech! Ma Yikapwa riin yeechi akar ma yechi tapak how hakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Worek, yecha meejichi saka hikirek. Diita otiitana maji mu yenya veenyir. Eena ye meejikasakech. Yecha akiitar eena yecha riina diita maji saka woherek. ");
INSERT INTO kmo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Disaipel ye awasen awasen ow maji batar. Eecha wochar nama notaka tawey harapa? ");
INSERT INTO kmo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas rii yechi inyakan heri, rii karakada yikapwan yeechi yaya riitaka siitiir. ");
INSERT INTO kmo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Siitiirek, yenya eecha wor, “Kata ma rii diita yikadey yikapwan eeji hik yaney, rii anapa eechaba yakiita. Kata ma rii ana yaney, rii ana heechirek yar ma riina eechaba yakiita. Kata ma rii kwotak karakada hiki tawey, rii harapa mayaka tawa. ");
INSERT INTO kmo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon rii eecha wor, “Harapa Ma, nota her ma por rii miiti hin habachiniga gaba yenya rabotar. Herek, nota riina anacheker. Rii notikasakech. Eena anacheker.” ");
INSERT INTO kmo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas rii awasen eecha wor, “Opoche anacheketanakech. Kata ma rii kwona ow otiinan siiney, rii kwona otiichichu.” ");
INSERT INTO kmo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisas riina hevenek yeechi ye inya nediik yarek, Jisas rii Jerusalem akamak iken hikitar. ");
INSERT INTO kmo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hikichiniga rii ma kawen mapo wochirek ir. Wochirek irek, ye Sameria akama pochi Jisas riiti boboyen sayarechichak iyarer. ");
INSERT INTO kmo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iyarerek, ye Jisas riita yechi akamak yanan yuyar. Rii Jerusalem akamak iken hikitarek, eena ye saka riina yarek. ");
INSERT INTO kmo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Disaipel Jems, Jon piiriita hechi eecha wor, “Harapa Ma, mii kapo hikitu nota hevenek tawa hin wonyak ya saka ma yenya uwunak, eeta akamak hika suw hamakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Worek, Jisas rii dareboyichi awasen yenya ow maji bar. Worek, ye akar akamaka ir. ");
INSERT INTO kmo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","(-) ");
INSERT INTO kmo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yecha nobok icharek, ma por rii eecha wor, “Eyey akama miita ik otiiney, ada miina sumowu ibakiita?” ");
INSERT INTO kmo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas rii riina eecha wor, “Kwashika tawa asa yecha supu nosapek tawa. Apo ye wosiik tawa. Wowak, Ma Yikapwa rii wa eemekasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Rii akar ma riina eecha wor, “Ana na sumowu ta.” Worek, rii awasen eecha wor, “Harapa Ma, ada mapo i eeji apokon tiiriimok chik.” ");
INSERT INTO kmo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas awasen eecha wor, “Har ma yecha sapa ha tawa ma yenya tiiriimok chi cha. Miita na inyak God riiti kigdom majin na sawota.” ");
INSERT INTO kmo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akar ma por rii eecha wor, “Harapa Ma, ada miina sumowutakiita. Nago, ada mapo kata ma yecha akamak taweyn, ada mapo i woshi ak.” ");
INSERT INTO kmo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas rii riina eecha wor, “Ma por rii riiti tapak eyiga tawa boboy neeki tawey, komakin mey hechaney, rii God riiti kigdom sayerekasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dii eeta hamarek, eeta Harapa Ma rii 70 ma yenya hisiir. Hisiichi rii yenya keyibor. Upurus upurus heechirek ir. Eyey akama Jisas riita komas iken eena yenya heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Rii yenya eecha wor, “Nokwapa nokwapa boboy sagii nowoka tawa. Tawak, eeta eem ameda yo otii tawa ma tawa. Nowo kow ye iivii hamakasakech. Kwo na Harapa Nowok Tawa Ma riina na maji ba ta. Rii ma kawka yeechi heechinak sa i yo kawka sa otii ba ta. Eena na wohe cha. ");
INSERT INTO kmo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na i! Ada heechiwak, kwo sipsip yi tawaga eecha tawak, ada kwona heechiwak kwashik tawa harapa aqsa tawa eemek ichu. ");
INSERT INTO kmo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kkwota ya kwo ye ikasakech. Aboboy woyi tawa kwo, yatii ruwu tawa boboy ye ikasakech. Kwo nobok inyak, ma yenya jawoney, maji bakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kwo akak i yowunak, mapo na eecha wor: Kwo na inyaka kwi eshar ta! ");
INSERT INTO kmo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Inyaka kepi tawa ma kaka tawey, kwoti woshia tawa boboy riitaka sa eecha sii. Eecha tanan siiney, kwoti woshi a tawa boboyen na awasen yeechi yaya. ");
INSERT INTO kmo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kwo eeta podar akak eecha na kiki sii. Ye aboboyen ukun kwona havaney, kwota na kiki a. Wonyak yo otii tawa ma ye yan sa ya ta. Kwota opoche akar aka podar podar ichanakech. ");
INSERT INTO kmo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kwo akamak iyarenak, ye kwona woshi anak yechi aboboyen kwona banak napa a. ");
INSERT INTO kmo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kata akamak hak otii tawa ma yenya napa otii kepi sii. Ma yecha eeka tawey, yenya na wo, ‘God riiti Kigdom, ya kwotaka bana bana tawa!’ ");
INSERT INTO kmo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wowak, kwo akamak iyarenak, ma ye kwona woshianan siiney, kwo napa i akama nobok na siitiichi wo, ");
INSERT INTO kmo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kwoti akama nosap yatii notik tawey, no yatii paynebotiichi i. Paynebotiichi wowak, kwo kapasek boboyeka eecha tawa. Na meeji. God riiti kigdom kwotak bana bana yar.’” ");
INSERT INTO kmo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jisas rii kawka eecha wor, “Ada kwona wocho: Anasaka tawa nedii yanak, God riita riiti inyakapa hiki tawa boboyen Sodom akama ma miman hakiita. Diit akamak tawa ma miman riiti inyakapwa hiki tawa boboyen yenya hakasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas rii eecha wor, “Korasin akamak tawa ma mima na meeji! Kwo harapa kapasek boboy kwotaka yakiita. Betsaida akamak tawa ma mima, kwo harapa kapasek boboy yakiita. Harapa merakelen kwoti akamak otiirin, Taia akamaka Saidon akamaka eeka otiirega, mashi mashi yecha waga yechi inyaka dareboyer. Yecha siivatabi bonyi ruwuchi hikishebuk waga yichar. ");
INSERT INTO kmo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","God riita riit inyakapa hiki tawa boboyen Saidon akama Taia akama ma miman hakiita. Kwon saka hakiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapaneam akamak tawa ma mima! Kwo kapo eecha hikitu kwo hevenek ikiita. Yaho Kwo hi uwu tawa eemek ye ikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas rii riiti disaipel yenya eecha wor, “Kata ma ye kwona wagatey tawey, ye ana eechaba wagateyitu. Ma ye kwona nasowoye tawey, ye ana eechaba nsaowoyetu. Ma ye ana nasowoye tawey, ye ana heechirek yar Eepi riina eechaba nasowoyetu.” ");
INSERT INTO kmo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Worek, 70 disapel ye kwoya hikichi awasen Jisas riitak yar. Ye eecha wor, “Harapa Ma, nota kapasek gaba yenya miiti hik wo saworek, yecha noti majin sumowutar.” ");
INSERT INTO kmo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas rii yenya awasen eecha wor, “Neer yeerepiya saka tawaga, gaba riita eechaba sakar, ada her. Na wagetey ta. ");
INSERT INTO kmo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ada kwona harapa hapaga tawa boboyen kwona har. Harek, kwo keena hopun yatiik piitii tawey, mediin yatiik piitii tawey, kwo eeta boboy eeta kwona saka pishamanekiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kapasek gaba ye kwoti maji meejichi heechi akii ichawey, kwi inyaka opoche kwoya hikitanakech. Yaho. Kwi hi hevenek tawa jeyek keyiri, eena na kwoya hiki ta.” ");
INSERT INTO kmo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eeta nedii Jisas rii Holi Spirit takiikiisiirek, rii kwoya woy hikichi eecha wor, “Eepi, mii eeta diita nosap God, mii eeta hevenek tawa God, ada miina woshi ato. Kata boboyen miita harapa jebwa hechawa maka hokwa sokwa tawa maka veenyi tari, mii shebo shebo tawa man mukuchichar. Ayo, Eepi, miita miiti inyakak hikitari, miita eena otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Eeji Eepi rii eyey boboyen ana har. Adadii Ma Yikapwa riina hekasakech. Eepi riitaba saniga hecho. Anadii ma ye Eepi riina eechaba hekasakech. Yikapwa riita Eepin hecho. Anadii ma yenya rii Eepi riina mukuchichawak, ye hebato.” ");
INSERT INTO kmo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas rii riiti disaipel yenya dareboyichi eecha wor, “Kata boboyen kwota hechawey, kwi inyaka napa kwoya hiki ta. ");
INSERT INTO kmo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nokwapa nokwapa piirapet, harapa aka tabo yima ye kwoya hechawa boboyen heken hikitar. Ye meejibaken hikitar. Worek, hekasakech. Meejikasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lon maji pokii tar ma por rii Jisas riina otii otii heken hikichi eecha woher, “Harapa Ma, anapa shecha otiinak eechaba eechaba takiita, hakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas rii awasen riina eecha wor, “Mashi keyir maji kapo shecha wocho? Mii kenyi tawey, mii shecha hikitu?” ");
INSERT INTO kmo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kata ma rii awasen eecha wor, “Mii miiti Harapa God riina eyey mesek, wopu, eyey mayi, eyey hapaga boboy, eyey marenoku riina na rukusii ta. Kawka miitaka bana bana tawa man na rukusiiba ta. Mii mayama rukusii tawaga akar man na eechaba otii.” ");
INSERT INTO kmo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas rii meejichi eecha wor, “Miita bawa maji eeta kepi. Miipa otiitaney, miipa eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lon maji pokii ma rii mayama wohowutaken hikitar. Hikichi Jisas riina eecha woher, “Kapo nama adaka bana bana tawa ma?” ");
INSERT INTO kmo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Meejichi Jisas rii noman eecha wor, “Ma por rii Jerusalem akamak heechi Jeriko akamak ye icharek, hiyi ya tawa ma ye riina nobok kubuk pir. Pichiniga ri siivatabi kwoyava yar. Kwoyava yeechi riina harapa pichi heechi ir. Rii haken otii tar. ");
INSERT INTO kmo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Worek, opellen otii tar ma por rii eeta nobok ye iniga pir ma rii hak otii tarek, her. Hechi rii nobo yepak heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Komas Livai ma rii ibatar. Ibatarek, rii hak otii tar ma riina hechi i bana bana her. Hechi, heheechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Worek, komas Sameria ma por rii eeta nobobak ir. Iniga riina her. Hechiniga rii riina inyakapwa hikir. ");
INSERT INTO kmo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hikichiniga rii i riitak bana bana howuk yichi rii riiti wel ukun wain ukun yeechiniga hak otii tar ma riiti maba ramon gwotiir. Gwotiichi ramojichiniga riiti donki magiirek howu seechiniga ma wa tawa akak ye i heechir. Heechi rii riina hehar tar. ");
INSERT INTO kmo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yadii nedii pochi hamarek, rii ya upurusen yeechi akan kowu tawa ma riina har. Harek, rii eecha wor, ‘Riina na hehar ta. Diita ya ada hawey, kapo saka kiki siikiitawak, sa way ta. Komas ada yanak, anapa kawka hakiita ya miina.’” ");
INSERT INTO kmo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Worek, Jisas rii kawka Lon maji pokii tar man woher, “Mii shecha hikitu? Ma piiriichar tari, shecha tar ma por rii hak otii tar man bana bana tawa ma riita otii tawa baga eecha otiir?” ");
INSERT INTO kmo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lon maji pokii tar ma rii awasen eecha wor, “Eeta ma rii riina hehar otiichir.” Jisas rii eecha wor, “Wowak, mii na eecha otii ta.” ");
INSERT INTO kmo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas rii riiti disaipel yechaka nobok iniga, rii akama pochik iyarer. Kata akamak mima pochi sii tar. Siiti hi Mata. Tarek, sii Jisas riina siiti akan tagwachir. ");
INSERT INTO kmo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Siiti kumwoy, Maria, eeka tar. Sii ya Jisas riita maji pokii tar majin eena meejitar. ");
INSERT INTO kmo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Worek, Mata sii siina heechinga aboboy yonotii tarek, sii mayama inyakapwa hiki tarek, sii Jisas riitak iniga eecha wor, “Harapa Ma, mii kapo ana heharekasakech? Eeji kumwoy sii ana heechirek, ada saniga yo otiito. Siina na wo, Ana sa ya kiyatayi!” ");
INSERT INTO kmo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Harapa Ma rii siina awasen eecha wor, “Mata, Mata, ni nokwapa nokwapa boboyen inyakak hikitu. ");
INSERT INTO kmo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Boboy podateba dopoto. Maria sii mama yepa boboyen hisiir. Hisiirek, diita boboyen siitaka tawey, sii heechikasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nedii pochi tarek, Jisas rii eem pochik God riina maji batar. Maji ba hamarek, riiti disaipel por rii riina eecha wor, “Harapa Ma, miita nona God riina maji ba tawa majin na nona pokii. Jon rii riiti disaipel yenya pokii tarega miita nona na eechaba pokii. ");
INSERT INTO kmo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisas rii eecha wor, “Diitata God riina na ba ta: ‘Eepi, miiti hi sa holi ta. Miiti kigdom sa ya ta. ");
INSERT INTO kmo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Diita nedii aboboyen nona na ha. ");
INSERT INTO kmo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Noti eyey kapasek boboyen miiti inyakak na kwoyava heechi. Akar ma yecha nona kapasek boboy otiitawey, nona yenya abosuchibato. Nona opoche nona otii otii he boboyen heechitanakech!” ");
INSERT INTO kmo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Worek, Jisas rii maji shiyi eecha wor, “Ma por rii riiti nareboy riiti akak niy nediik yawey, riina eecha wocho, ‘Nareboy, miita ana gey piiriichar sobo ha. ");
INSERT INTO kmo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Eeji nareboy rii chishi ye i tarek, eeji akak yawa. Rii yawak, ada aboboy biish.’ ");
INSERT INTO kmo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Miita wa tawa nareboy rii eecha wonyey, ‘Opoche ya ana boboy yak wohechanakech. Nubereja eeta dasiipowa. Ada eeji yikapwa ye wato. Anapa saka sokwa miina aboboy hakiitawak!’ Wowak, miita eechaba eechaba wohechaney, ");
INSERT INTO kmo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ada kwona wocho, riipa sokwachi geyen eyey boboyen miita wohechaweyn riipa miina hakiita. Rii miiti nareboy tawey, kkapo rii miina aboboy hakasakech. Yaho. Eechaba eechaba wo wohechaney, eena riipa hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wowak, ada kwona wocho, na wohecha. Wohechanak, kwopa yakiita. Na yesha ta. Yesha tanak, kwopa hekiita. Na hapaka ta. Hapaka tanak, nubereja tagwakiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Eyey ma ye wo wohechawey, yepa yakiita. Ma yesha tawey, yepa hekiita. Ma ye hapaka tawey, yepa nubereja tagwachikiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ma por riiti yikapwa rii apoko riina emiyepen aken eena wohenyey, riipa kapo boy hopon yeechi hanak akiita? Yaho. Hakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yikapwa por rii riiti apoko riina apobeyen aken wohenyey, riipa kapo boy miiden hanak akiita? Yaho. ");
INSERT INTO kmo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwo ma kapasek tawey, kwo eecha kepi hikitu kwoti yikapwan kepi boboyen havato. Tawey, eeta amutiik hevenek tawa Eepi riipa Holi Spirit kepin riina wohenya ma hakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma por rii tari, kuja diimiitar. Kapasek gaba riitaka eecha tar. Tarek, Jisas hechi yeechi kayek rabotar. Yeechi kayek raborek, kata ma rii maji bar. Barek, nokwapa nokwapa ma mima yecha hechi henebarabor. ");
INSERT INTO kmo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kaw ye eecha wor, “Gaba, eyey kapasek gaba yechi apoko, rii Jisas riina hapaga boboyen harek, rii otiito.” ");
INSERT INTO kmo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Akar ma ye Jisas riina apodagii otii hikishak eena woher, “Mirakelen na otiita. Otii tawey, nota hikiken God riita miina rukusiito.” ");
INSERT INTO kmo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Worek, Jisas rii yechi inyakan hechiniga awasen eecha wor, “Nosap pochi ma mima ye saniga saniga eecha yi ye inyey, awasen awasen o ana pichaney, komas eeta ma mima ye kapasek siikiita. Mamu pochi sii pochi siina o ana pinyey, iipa eeta saniga saniga siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Worek, Gaba riiti mamu saniga saniga tawey, o ana pichaney, shecha ye kapo hapaga siikiita? Kwo eecha wocho, Gaba rii hapaga boboyen ana hatawak, ada kapasek gaban yeechi raboto. ");
INSERT INTO kmo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ada Gaba riiti hik ada kapasek gaban kikir poyeney, kwona sumowu tawa ma ye kapo shecha kapasek gaban kikir poyekiita? ");
INSERT INTO kmo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wowak, God riiti hapaga boboy adaka tawak, kapasek gaban raboto. Eeta kwona mukuchichu God riiti kigdom kwotak yar. ");
INSERT INTO kmo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ma hapaga siitawey, rii yabu anaba yeechi o yichawak, riiti akan siiti kowu tawak, riiti boboy anada tawa. ");
INSERT INTO kmo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wowak, hapaga bor tawa ma rii ya riina o ana pichi dagiirepoyichi riiti anaba yeechi o ana pichar boboyen yeechi ye inyak, akar boboyen yeechi ye inyak, homochikiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kata ma rii eeji nareboy tanan siiney, rii eeta eeji yabu pi ma. Ma rii ma mima adaka yaya yopo yichinan siiney, rii rabo ya payato.” ");
INSERT INTO kmo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kapasek gaba rii ma poren heechi iri, rii shebo shebo eemek chishi ye iniga yi hapaka tawa eemen yeshato. Yesha hipuchi rii mayama wocho, ‘An heechi yar akak awasen kawka ik.’ ");
INSERT INTO kmo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wowak, rii awasen i eeta aka hako kiirakwur. ");
INSERT INTO kmo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Rii hechi heechi akar 7 gaba kapasek weyen akak kawka ye yayareto. Wowak, kata ma rii mashi kapasek tar. Apa rii kawka kapasek wey tawa.” ");
INSERT INTO kmo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Diita majin Jisas rii ba hamarek, mima pochi sii riina eecha wor, “Kata mima sii miina yimowurek mii siiti mukun havari, sii eeta kwoya woy hikitu.” ");
INSERT INTO kmo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jisas rii awasen eecha wor, “Eeta kepi nija eecha bak, eeta ma ye God riiti majin meejiniga ye sumowutawey, ye kwoya woy hikitu.” ");
INSERT INTO kmo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma mima ye Jisas riitaka ya yopo wuchi siitii tarek, Jisas rii eecha wor, “Ma mima ye diita nedii diita nosap tawey, yecha kapasek woy otiito. Yecha mirakelen eena yesha ye i tar. Wowak, mirakel podareban komas yenya hakiita. Diita mirakel eeta Jona riiti. ");
INSERT INTO kmo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Piirapet Jona rii Nineva akama ma miman mukuchir boboyen harega, Ma Yikapwa rii diita nediik tawa ma mima yenya eechaba mukuchir boboy baga. ");
INSERT INTO kmo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Anasak tawa nediik Shiba nosapek siitii kowu tawa aka tabo yi mima sii diita nedii ma mima yenya harapa ow maji bakiita. Siita kata yepa anadii eemek heechi Solomon riiti hokwa sokwa majin meejiken yar. Wowak, ma por apa diika tawey, rii eeta harapa. Rii Solomon riina dagiirepoyetu. ");
INSERT INTO kmo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anasak tawa nediik Nineva akama tar ma mima yecha siitiichi kwona harapa ow majin bakiita. Yecha Jona riita sawotar majin meejitarek, ye yechi kapasek otii tar boboyen dareboyer. Ada kwona wocho, ma por apa diika tawey, rii Jona riina dagiirepoyetu.” ");
INSERT INTO kmo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jisas rii eecha wor: “Diita yikadey boboy ma ye otiikasakech. Haban hayechi veenyetu. Heebiya wok veenyetu. Yaho. Rii hayechi cheyek yichi tawak, ma ye ya hecho. Miiti miy eeta miiti maba siiti haba. ");
INSERT INTO kmo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miiti miy eeta hehar henyak, miiti maba eeta yama hekiita. Wowak, miiti miy kapasek taney, miiti maba eeta eyey niyiki yichu. ");
INSERT INTO kmo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Na hehar hecha. Yama miitaka tawey, sapa eechaba ta. Iipa niyiki yikiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wowak, miiti maba eyey yama hechaney, niyiki kaw tanan siiney, miiti maba eeta eyey yama hecho. Haba eeta miina okoreechichawey, mii eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas rii majin ba hamarek, Perisi ma por rii riina otii aken eena woher. Worek, rii aka wok iyarechi cheyek aken eena yir. ");
INSERT INTO kmo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisas riita riiti tapa saka uku yeetiirek, Perisi rii hechiniga nyegerabor. ");
INSERT INTO kmo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Worek, Jisas rii riina eecha wor, “Na he. Perisi kwo heebiya saban eena uku yeetiito. Wowak, kwoti wok tawey, kapasek boboy takiikiisii tawa hiyiya tawa boboy eechaba takiikiisii tawa. ");
INSERT INTO kmo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kwo harapa hikisha weyitu. God riita saban otiitawey, rii inyaka wopu wo otiibato. ");
INSERT INTO kmo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kata boboyen kwoti heebiyak taweyn kiiriisiiposii tawa man na ha ta. Hatanak, kwi eyey boboy eeta apoma hechakiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kwo Perisi kapasek boboy kwotaka yakiita. Kwo kwoti karakada aboboy ten ten God riina hato. Hatawak, kwo nagwa nagwa hikichi otii tawa boboyen, God riina rukusii tawa boboyen two eena hikichi otiikasakech. Eeta kapasek. Diita boboyen na otii ta. Akar yo kepin opoche abosuchetanakech. ");
INSERT INTO kmo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Kwo Perisi kapasek boboyen kwotaka yakiita. Kwo Ju ma yechi lotu aka harapa ma yichar tiikiiren kwo eena kwoya hecho. Kwo awaba tawa eemek icharek, akar ma ye kwona hechi harapa woshi atarek, two kwoya hikitar. ");
INSERT INTO kmo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kapasek boboy kwotaka yakiita. Kwo tiiriimo supu tawaga eecha tawa. Akar ma ye piitii i ye yatawey, kwo hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Worek, lon maji pokii ma por rii riina eecha wor, “Mii maji eecha ba tawey, mii nona maji kubuk pibato.” ");
INSERT INTO kmo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisas rii awasen eecha wor, “Kwo lon maji pokii ma. Kwo kapasek boboyen yakiita. Kwo nomo ya tawa kwon ma yenya hawak, ye harapa yo otiito. Wowak, kwo kwoti tapama por yenya kiyatayiniga yesokwakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kwo kwoba sii siiken siikiita. Mashi tar piirapet yenya kwoti wayega ye sowakworek, kwo yechi tiiriimon keyapochichu. ");
INSERT INTO kmo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwoti wayega ye piirapet yenya sowakworek, kwo yechi tiiriimon keyapochicharek, kwo eecha mukuchichu kwo hikitu yechi otii tar abo eeta kepi. ");
INSERT INTO kmo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Eena God riita hikichi wor, ‘Ada yenya piirapet yenya heechinak ikiita. Ada yenya eeji majin ye ichawa ma heechinak ikiita. Heechinak ye inyak, yecha kaw yenya sowakwokiita. Yecha kaw yenya kikirepoyekiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eyey piirapet yenya mashi mashi diita nosapen otiir nedii ya ya ya diita nedii kwoti wayega ye sowakwori, diita nediik diita tawa ma yenya God riita awasen pikiita. Wayega yecha otiirin eena awasen piikiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ye Sekaraia riina sowakwor. God riina opelen har eem riiti holi tar eem Sekaraia riita tar nedii, eyey piiriita tar nediik, eyey piirapet yenya diita nediik sowakwo hamari, ada kwona wocho, apa diita nediik tawa ma mima yen God riita pikiita. Kata piirapet yenya sowakwor boboy wayega yecha otiitari, eena yenya awasen pikiita. ");
INSERT INTO kmo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Lon maji pokii ma kapasek boboy kwona yakiita. Kwo mama yepa hehar hiki tawa nobon kwo dasiipiir. Dasiipiirek, kwo diita nobo kepi kwo ikasakech. Worek, kwo dasiipiirek, akar ma ye boyega ik wonyak?” ");
INSERT INTO kmo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas riita kata eemen heechi irek, lon maji pokii ma, Perisi, yecha riina harapa ow maji batar. Yecha riina nokwapa nokwapa boboyen wo wohechar. ");
INSERT INTO kmo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yecha riina majik baniga sakaken otiitar eena riina wo wohechar. ");
INSERT INTO kmo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nokwapa nokwapa ma mima ya yopo yicharek, kaw yecha ma yatii hek piitiichi siitiitar. Worek, Jisas rii riiti disaipel yenya mapo wor, “Perisi yechi woshepii veenyi tawa boboy yechi yis, eena na hehar hecha. Yechi woshepii hiki tawa boboy eeta sokwa i ye yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Eyey veenyitar majin gamuri, iipa tagwa mukuchikiita. Eyey majin veenyichi otiitari, iipa ma yecha hikikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wowak, eyey maji kwo niyik batari, iipa yanak meejikiita. Eeta maji kwota wosiirek batawey, yepa geenyik siitii harapa uwa sawokiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Eeji nareboy kwona wocho: Kwo opoche maban sowakwo tawa man akiitanakech. Yecha akar boboyen kawka otiikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ada kwona mukuchik naman kwo na akii ta? Kwo God riina na akii ta. Rii kwona sowakwonak, komas riitaba keena kwona hi uwu tawa eemek yeechi rabokiita. Ayo, ada kwona wocho, riina na akii ta! ");
INSERT INTO kmo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ma ye yokotapa karakada apo yin sen upuruseba tokor. Worek God riita yenya saka abosucherek. ");
INSERT INTO kmo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kwoti masebiyan God riita kadii hamar. Worek, kwo opoche akiitanakech. Kata apo eeta karakada boboy. Kwo eeta harapa.” ");
INSERT INTO kmo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","9","“Ada kwona wocho, eeta ma rii eeji hin akar man geenyik kwodii wochawey, Ma Yikapwaq riita eeta ma riiti hin eechaba geenyik kwodii wokiita ejel yenya. Ma rii akar man eecha wonyey, Jisas rii eejikasakech, Ma Yikapwa rii riina God riiti ejel yenya eecha wokiita, Eeta ma eejikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ma ye Ma Yikapwa riiti hin ow majibataney, God rrita riiti kapasek boboyen kwoyavayakiita. Wowak, kata ma rii Holi Spiriten kapasek majin bataney, God rrita eeta boboyen saka kwoyavayakiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Komas nedii yecha kwona yeechi lotu akak, gavman mak, harapa aka tabo yimak yeechi mi somak anasak ye inyey, iipa opoche inyakapwa hikitanakech. Kwota mayama kiyatayeniga batana maji opoche inyakapwa hikitanakech. ");
INSERT INTO kmo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Eeta nedii eeta Holi Spirit rii kwona maji pokii tanak, kwopa batakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ma por rii ma mima yechaka tari, eecha Jisas riina wor, “Maji pokii ma, eeji yaka riina na wonyak, sichi har eepi riiti nosap boboyen rii ana sa kaw ha.” ");
INSERT INTO kmo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisas rii riina eecha wor, “Miinawa, kapo nama ana otiichirek ada anasak tawa ma tawa? Nama ana otiichirek, ada kwona nosapen boboyen homachikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Worek, rii kawka eyey man eecha wor, “Na hecha. Eyey kwoya hechawa boboyen na heechi. Ma por rii riti boboy harapa tawey, eeta boboy riina hakasakech eechaba eechaba tak tawa boboy. ");
INSERT INTO kmo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Worek, Jisas rii diita shiya tawa noman wor: “Yaka tar ma por rii tarek, riiti nosap harapa saga sokwatar. ");
INSERT INTO kmo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Worek, riiti inyaka eecha hikir: ‘Eeji sagan heechi aka saka kikisiikiitawak. Anapa shecha otiikiita?’ ");
INSERT INTO kmo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Rii way hikichiniga eecha wor: ‘An hecho anapa eecha otiikiita. Ada diita saga boboyen heechi tawa akan diigiikiita. Diigii rabonak, anapa kawka aka harapa otiikiita. Otiinak, anapa eyey boboy saga eeta akak heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Otiinak, anapa mayama wokiita: Mii kepi tawa. Miiti boboy nokwapa nokwapa tawey, na sukwiya sapa nokwapa nokwapa ta. Na eshar tanak, na eshar chishi ta. Na yi hapaka tanak, na a tanak, uku aba ta!’ ");
INSERT INTO kmo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Worek, God riita hechi riina eecha wor: ‘Mii hikishato! Diita niy miiti maban heechi mii hakiita. Miita hanak, kapa nama miiti mayama sayarechir boboyen yakiita?” ");
INSERT INTO kmo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisas rii kawka eecha wor, “Iipa eechaba tawa ma ye nokwapa nokwapa nosap boboyen mayama sayarechiwak, God riiti boboyen sayarechikasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Worek, Jisas rii riiti disaipel yenya eecha wor, “Eena ada kwona wocho: Kwo diita nosap tawey aboboyen maba ruwu siivatabin inyaka opoche hikitanakech. ");
INSERT INTO kmo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mesek eeta harapa boboy. Aboboy eeta karakada. Eeta maba eeta harapa boboy. Siivatabi eeta karakada. ");
INSERT INTO kmo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kwashika tawa apon na he. Yecha aboboy siiken chikasakech. Yecha sagan otiikasakech. Ye boboy heechi akakasakech. Wowak, God riita eeta apo yenya havato! Na hiki. Apo eeta karakada. Kwo eeta harapa. ");
INSERT INTO kmo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nama kwotaka tawey inyakapwa hiki tawey, rii kawka hiki tanak, rii sukwiya pochika tawa nosap kawka takiita? ");
INSERT INTO kmo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kwo diita yikadey karakada boboy otiinan siiney, boyewak kwo akar boboyen inyaka hikitu? ");
INSERT INTO kmo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Gurunayen na hiki ta. Yecha yo otiikasakech. Yecha siivatabin otiikasakech. Ada kwona wocho: Solomon, harapa aka tabo yima, rii diika tarek, riiti harapa yakatarek, rii riiti siivatabin ruwuri, rii saka gurunayeka eecha kikisiikiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God riita woheja yenya kehapochichu. Kehapochiwak, woyiheja diita apa tawa iy rabochinyak hiki uwukiita. Wowak, rii wohejan eecha kehapochichawak, riipa kwona kawka eechaba heharekiita? Kwo God riina hiki siitiichichawa boboy eeta amusakech! ");
INSERT INTO kmo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kwo opoche inyaka hikitanakech diita nosap boboyen. Aboboyen uku a tawa boboyen opoche eechaba eechaba yeshatanakech hikibatanakech. ");
INSERT INTO kmo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Eecha hiki tawa inyaka diita nosap tawa ma ye eechaba hikitu. Yecha diita boboyen eechaba eechaba yeshato. Kwoti Eepi rii hecho kwota dopo tawa boboyen. ");
INSERT INTO kmo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wowak, God riiti Kigdom eena kwota na mapo sumowu tanak, riipa akar boboyen kwona hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Karakada magwi opoche akiitanakech. Kwoti Eepi riita inyaka kwoya hikichi riiti kigdomen riita kwona haken hikitu. ");
INSERT INTO kmo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kwoti eyey boboyen na tokochi ya yeechi yan kiiriisiiposii tawa man napa ha. Kwo yan woyi tawa kwo neekikasakech na yeechi yaya. Hevenek tawa yaneeka na yopo yichicha. Kaka tawey, eeta ya karakada siikasakech. Kaka hiyiya tawa ma ye yakasakech. Machi akasakech. Kaka kapasek siikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Na meeji kwoti yan tawa eem, kwoti inyaka ii bak tawa.” ");
INSERT INTO kmo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kwo na sayarechi na kow ta. Siivatabi na hehar giiriichi. Kwoti haba na hayi. ");
INSERT INTO kmo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Harapa ma rii yanak, mima tapa aken irek wakasa ma ye riina kowu tawaga kwo eechaba napa kowu ta. Riita awasen ya nuberejak siitii uwanak, ye meejichi nubureja ameya tagwachikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Harapa Ma riiti wakasa ma ye sayarechi yi kowutaney, wakasakech, Harapa Ma riiti yanak, yecha riina inyaka kwoya woy hikikiita. Ada kwona wocho: riipa ya siivatabi giiriichi yenya wochanak, yinyak, riipa aboboy yo otiikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Riipa niy nediik yaney, kapo opochok wo nediik yaney, riipa henyey, yecha sayarechi hamawey, yepa yechi inyaka kwoya woy hikikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Na hiki! Akak hehar siitii kowu tawa ma rii hiyi ya tawa ma rii ya nedii hikiney, rii hiyi ya tawa man anachekiita. Wonyak ri kepi tawa. ");
INSERT INTO kmo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kwo eechaba na kowu ta. Ma Yikapwa riipa yak tawa nedii kapo siitiiyekega yakiita? Kwota na kowu ta!” ");
INSERT INTO kmo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita rii eecha wor, “Harapa Ma, mii diita shiyi tawa majin kapo nona wocho, kapo eyey man wocho?” ");
INSERT INTO kmo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Harapa Ma rii awasen wor: “Nama eeta maji sumowu tawa ma kepi, nama eeta kepi hiki tawa wakasa ma? Rii diitata. Riina eeta Harapa Ma riita riina hisaw yo hakiita. Hanak, riipa riiti aka boboy sagan siitii kowukiita. Kowutanak, rii akar wakasa ma yenya kepi nediik aboboyen homachichikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Riiti Harapa Ma rii awasen yanak, diita boboyen wakasa ma rii otiitawey, wakasa ma riipa inyaka kwoya hikikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eeta siiken, eeta Harapa Ma riipa yanak, riina otiichinyak, riipa eyey boboyen harapa ma siitii kowukiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wowak, kata wakasa ma rii mayama eecha wonyey, ‘Eeji Harapa Ma riipa saka ameya yakiitawak.’ Wonyey, rii akar wakasa ma miman pinyey, harapa nokusha aney, uku eechi beyiney, ");
INSERT INTO kmo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","riiti Harapa Ma yana nediin rii sayarechi kowukasakech. Eena hikikasakech. Harapa Ma riipa yanak, riipa wakasa ma riina harapa pichiniga, heechinak, eeji majin nasowoy tawa ma yecha tawa eemek riin iibak heechinak i siikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kata wakasa ma rii riiti Harapa Ma riiti inyakak hiki tawa boboyen hikinak, rii mayama sayarechinyan siiney, Harapa Ma riiti inyakak tawa boboyen otiinan siiney, komas riina harapa kapasek pikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wowak, kata wakasa ma rii riiti Harapa Ma riiti inyakak hiki tawa boboyen henyan siiney, kapasek boboy otiiney, riipa riina karakada pikiita. Ma por riina harapa boboyen haney, rii sapa harapa yo otii ta. Nokwapa nokwapa boboyen eeta ma riina haney, riisapaawasen eechaba nokwapa nokwapa boboyen ha.” ");
INSERT INTO kmo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas rii eecha wor, “Diita nosapen hik hayeken eena ada yar. Ada gegiyato apa diita nosap hik hay kamawa. ");
INSERT INTO kmo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anapa harapa uku yeechi tawa boboyen yakiita. Ada eena kowutawak, an harapa inyakapwa hikitu. ");
INSERT INTO kmo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kwo kapo eecha hikitu: diita nosapek eshar tawa boboy eena ada yayaken eena ada yar? Yaho. Eshar tawa boboyen yayakasakech. Ada boboy kepin yayatawak, upurus hiki tawa boboy sokwato. Eena ada yar. ");
INSERT INTO kmo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Apa na komas magwi pochi tawey, ma yokotapaba tawey, yecha upurus upurus hikikiita. Ma upurus saniga hikikiita. Ma piiriichar ye saniga hikikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apoko ye yechi yikapwa yechaka eecha saniga saniga inyaka kapasek hikikiita. Yikapwa yepa apokwon saniga hikinak apoko yepa yikapwan saniga hikikiita. Nokwapa yikapwaka eechaba siikiita. Nokwapa sii yikapwa riiti mimaka eechaba siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Worek, Jisas riita ma mima yenya eecha wor, “Kwo ya ye i tawa eemek hejakwayap eeka sokwaney, kwo hechi eecha wocho ‘wayi vak otiito.’ Wonyak, eechapa otiikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kwo kata yepak yana sowan meejinak, kwo eecha wocho, ‘Harapa hi yami yato.’ Eechapa otiikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kwo woshepii tawa ma! Kwo naosapen neeren hechawak kwo siiti mun kwo nagwa nagwa hikitu. Wowak, boyewak kwo diita nedii mun kwo hekasakech?” ");
INSERT INTO kmo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Boyewak kwo mayama nagwa nagwa hikichi yo kepin otiiken anasakasakech? ");
INSERT INTO kmo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ma por rii miina anasaken hikitaney, rii miina anasak tawa akak ye inyey, kicha iipiira inyak, ameya napa gayasay. Gayasayenan siiney, riipa maji sanasak tawa ma miina ye i hakiita. Ye i hanak, riipa miina plisman yen hakiita. Hanak, riipa miina pokojikiita. ");
INSERT INTO kmo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ada miina wocho: miina poko ameya heemakasakech. Miita napa eyey kapasek otiir boboyen eyey toko hama.” ");
INSERT INTO kmo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Eeta nedii ma mima kaw ye Jisas riina maji kawen sawor. Yecha saworek, Galili ma kaw ye God riina opelen hatarek, Pailat, gavman harapa ma, rii yenya sowakwor. Eetamaji ya Jisas riina sawor. ");
INSERT INTO kmo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas rii meejichi eecha wor, “Kwo kapo hikitu kata Gaili ma yenya eecha sowakwori, eeta mukuchir ye eeta hisaw harapa kapasek otii tar ma tawak, akar Galili ma ye karakada kapaseken otiir? ");
INSERT INTO kmo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yaho. Ada kwona wocho: Kwo kwoti kapasek inyaka dareboyenan siiney, yenya eecha sowakwori, kwo eechaba hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kwo meejir 18 ma ye Siloam akamak tarek ye papa inyik bana bana siitiitarek, inyi saka yenya sowakwor. Diita kapo boy mukuchir yecha hisaw harapa kapasek yo otii tar ma tawak, akar Jerusalem akamak tar ma karakada kapasek yon otiir? ");
INSERT INTO kmo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yaho. Ada kwona wocho, kwo kwoti kapasek boboyen dareboyenan siiney, yecha eecha hari, kwota eechaba habakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Worek, diita noman Jisas rii yenya eecha wor, “Ma por rii pek me pochi riiti nowok eeka sokwato. Worek, rii i siiken omun yesha hiputar. ");
INSERT INTO kmo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yesha hiputarek, rii riiti nowootii tar ma riina eecha wor, ‘Na he. Piiriichar sukwiya ada diika ya siiken omun yesha hiputu. Eena na ye rabo! Boyewak eeta me diita nosapen gamu poyetu?’ ");
INSERT INTO kmo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nowon otii tar ma rii awasen eecha wor, ‘Harapa ma, sukwiya pochi ii na heechi ta. Ada nosapen payi iviichi, ada bulamakaw she yeechi eeka chikiita. ");
INSERT INTO kmo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Otiinak, sokwa komas sukwiya pochi omun wanan siiney, napa ye rabo.’” ");
INSERT INTO kmo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat nedii pochi Jisas rii Ju ma yechi lotu aka porek maji pokii tar. ");
INSERT INTO kmo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mima pochi eeka tari, kapasek gaba siitaka tarek, sii 18 sukwiya hak otii tar. Siiti magiir kur tarek, sii gamu gamu chishi tar. ");
INSERT INTO kmo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas rii siina hechi uwar, “Ninyawa, hak otii tawa boboy nichaka tawey, eeta ninya heechuwa!” ");
INSERT INTO kmo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Worek, rii riiti tapan siina neekirek, sii sokwa danegwar. Sokwa danegwachi sii God riiti hin yesokwatar. ");
INSERT INTO kmo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Worek, akak siitii kowu tar ma rii Jisas riina kwotayir. Sabat nedii Jisas rii siina otii kepi siir. Eena rii riina kwotayir. Kwotayichi rii ma mima yenya eecha wor, “6 yadii yo otiito. Otii tawey, kata 6 yadii kwoti hak otii tawa boboyen otii kepi siiken na ya. Sabat yadii opoche yatanakech.” ");
INSERT INTO kmo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Harapa Ma rii meejichi riina awasen eecha wor, “Kwo woshepii tawa ma. Kwo sabat yadiik kwoti bulamakaw yenya poko heemachi uku siiva eemek yiukun waga havawa. ");
INSERT INTO kmo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na he. Diita mima pochi sii Ebraham riiti yikapwa tawey, Seten rii siina 18 sukwiya poko jirek, kapo boyewak Sabat nediik siin saka heemachinrek?” ");
INSERT INTO kmo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas riita yenya diita majin geenyik worek, maji ow ana pichar ma yecha mayama hiibiya yar. Worek, eyey ma mima ye riita hadabas yon hechiniga ye inyaka kwoyahikitu. ");
INSERT INTO kmo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas rii eecha wor, “God riiti kigdom kapo boy boboy? Kapo boy tawaga tawa? ");
INSERT INTO kmo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eeta mastet siik tawaga tawa. Ma por rii mastet siik poren yeechi nosapek chir. Chirek, eeta sokwar. Sokwa mek siir. Mek siirek, apoyari ye wosii eeka patiir.” ");
INSERT INTO kmo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisas rii kawka eecha woher, “God riiti Kigdom kapo boy boboy tawaga tawa? ");
INSERT INTO kmo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Eeta dii tawagatawa. Mima pochi sii yis eena yeechi harapa dram plaua woyichinga kakotiichiniga komas eyey plaua piipiitato.” ");
INSERT INTO kmo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas rii Jerusallem akama icharek, rii karakada akamak, harapa akamak tesen iyarer. Worek, rii ma mima yenya maji pokiitar. ");
INSERT INTO kmo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma por rii riina woher, “Harapa Ma, kapo karakada magwi God riita yesokwa yichikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jisas rii yenya awasen eecha wor, “Na yo ya i. Nubereja eeta karakada. Ada kwona wocho nokwapa nokwapa ma mima ye yo iyareken otii otiihipunak iyarekasakech. ");
INSERT INTO kmo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Akan siitii kowu tawa ma riipa sokwa nubereja dasiipiikiita. Dasiipiinak, kwopa geenyik siitii nubureja hapakachiniga wonyak, ‘Harapa Ma, nuberja na tagwa’. Wonyak, riipa kwona awasen wokiita, ‘Kwota tawa eem ada hekasakech.’ ");
INSERT INTO kmo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wonyak, kwo riina awasen wokiita, ‘Nota miitaka otii atar. Miita noti akamak maji pokiitar.’ ");
INSERT INTO kmo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wonyak, riipa kawka wokiita, ‘Kwota tawa eem ada hekasakech. Adana na heechi! Kwo kapasek otii tawa ma.’ ");
INSERT INTO kmo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ebraham, Aisak, Jekop yecha God riiti kigdom eeka tanak, eyey God riiti piirapet ye riiti kigdom eeka tanak, kwo hechiniga, kwota eeka geenyik siitiitanak, kwo keya keyachiniga kwoti pun mayama takiimorokiita. ");
INSERT INTO kmo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma mima ye eyey eemen heechi ya God riiti kigdom iyarekiita. Iyarenak, yecha aboboy cheyek yikiita. ");
INSERT INTO kmo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Apa eeta ma ye mapo ichawey, yepa komasiikiita. Apa eeta ma ye komas ichawey, yepa mapo ikiita. Komas eeta ma ye harapa siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eeta nedii Perisi ma kaw yecha Jisas riitak yar. Yaniga wor, “Miita dii eemen na heechi i. Herot riita miina sowakwoken hikitu.” ");
INSERT INTO kmo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas rii yenya awasen wor, “Kwo kata kwashika tawa asa riina na i wo: ‘Apa, iyik, ada kapasek gaba yenya pichi raboto, hak otii tawa man ada otii kepi siito. Wowak, piiriichar nedii hamanak, eeji yo eeta hamakiita.’ ");
INSERT INTO kmo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wowak, apa ada nobok ik. Iyik, iyavek ada nobok ikiita. Piirapet riina eeta Jerusalem akamak sapa sowakwo. Opoche akar akamak riina sowakwotanakech. ");
INSERT INTO kmo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, kwo piirapet yenya sowakwoto. God riita kwona heechirek yar piirapet yenya kwo papak rabo sowakwoto. Apochok sii siiti yin chipi kuruk yikapwa eeka hehar gamutawaga, ada kwona eechab eechaba nedii eeji tapak eechaba waga otiiwa. Eecha otiik otiitari, kwo yuyar. ");
INSERT INTO kmo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na he! Kwoti akama biish siikiita. Ada kwona wocho, kwopa wonyak, ‘Kata ma rii Harapa Ma riiti hik yato. Riiti hi na yesokwa ta.’ Wonyak, kwopa ana komas hekiita. Wonyan siiney, kwopa ana saka hekiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat yadii pochi Jisas riiti harapa Perisi ma riiti akak otii ak ir. Icharek, ma mima ye riina hehar hechar. ");
INSERT INTO kmo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Worek, ma por rii tari, riiti yatii tapa piipiitar. Piipiitari, rii Jisas riitak eecha yar. ");
INSERT INTO kmo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yarek Jisas rii lo majinpokii tar ma yen, Perisi ma yen woher, “Noti lo hak otii tawa man nopa boy Sabat nedii otii kepi siikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Worek, yecha meejichi bakasakech. Worek, Jisas rii kata ma riina yeechi otii kepi siichi heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Worek, rii yenya eecha wor, “Kwoti ma por riiti yikapwan riiti bulamakaw sabat nedii supuk yeyiney iipa boy saka yeechi yesokwatawak sabat nediik?” ");
INSERT INTO kmo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Worek, yecha riina maji awasen saka barek. ");
INSERT INTO kmo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Worek, akamak yar ma kaw ye mey maka hechi harapa ma yechi worebey eeka ya yir. Karakada hechi heechir. Jisas rii hechi dii shiytawa maji eecha wor, ");
INSERT INTO kmo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ma por rii miman yayanak, kwo noku sha akiita. Kwo nokusha anak, kwo opoche harapa ma yechi worebey yichanakech. Mii harapa ma worebey eeka yinyey kapo komas harapa ma apa yakiita. Yanak, miina otii havak wor ma, rii kapo miin ya wohekiita, ‘Miita diika worebey na heechi. Harapa ma rii diita worebey apa ya yikiita.’ ");
INSERT INTO kmo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Worek, mii hiibiya yaniga karakada ma worebeyek yikiita. ");
INSERT INTO kmo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kwon nokusha ak wohenyak, karakada ma yechi worebeyek eeka napa yi. Yinyak, miina otii havak wor ma yaniga miina eecha wokiita, ‘Eeji nareboy, diika na ya. Harapa worebey diika na ya yi.’ Miita yinyak, akar yawa ma ye miina hechi eecha hikiita mii eeta harapa ma. ");
INSERT INTO kmo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Eyey ma ye mayama riiti hin ye ye ye inyey, ri hi iipa harapa siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Worek, Jisas rii otii havak wor ma riina eecha wor, “Miita yenya nokusha aniga hava tanak, opoche miiti nareboy yen wohechanakech. Miiti yaka kumwoy wohechanakech. Miiti hadii yenya wohechanakech. Yaka tawa ma opoche wohechakech. Wohenyey, yepa miina aboboy awasen havakiita. Miina awasen havanak, miiti yan miina awasen ha hamakiita. ");
INSERT INTO kmo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Miita nokushaniga hava tanak, kiiriisiiposii ma, yatii kapasek tawa ma, tapa kapasek tawa ma, miykiitii ma yenya napa wohe. ");
INSERT INTO kmo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wohenyak, hadabas inyaka hiki tawa boboy miitak yakiita. Yepa saka awasen hakiitawak. God riipa miina awasen hakiita. Har ma kepin yesokwa yichinak, eeta nedii awasen hakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma por rii aboboy cheyek yiniga Jisas riita bawa maji meejichi Jisas riina eecha wor, “Kata ma ye God riiti aboboy cheyek riiti kigdom taney, yichaney, yecha kwoya hikikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisas rii riina noman eecha wor, “Ma por rii tari, rii harapa nokusha ar. Nokusaha atarek, rii nokwapa nokwapa ma mima yen ak woher. ");
INSERT INTO kmo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Rii riiti wakasa ma riina hechirek ir. Ma mima yenya ak wohek eena heechirek ir. Rii hechirek, irek, rii eecha wor, ‘Na ya a. Aboboy sayarewa!’ ");
INSERT INTO kmo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Worek, eyey ma ye yo maji bar. Mapo wor ma rii wakasa ma riina eecha wor, ‘Ada nosapen tokor. Tokochi ada hek ik. Miiti harapa ma na wo, ada ikasakech, ada riina inyakpa hikitu!’ ");
INSERT INTO kmo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Akar ma por rii eecha wor, ‘Ada 10 bulamakaw tokochi, ada eena otii hek ichu. Ada inyakapa hikitu. Anapa saka yakiitawak.’ ");
INSERT INTO kmo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Akar ma rii eecha wor, ‘Ada mima yawa eena ada yakasakech. Inyakapa hikitu.’ ");
INSERT INTO kmo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Worek, wakasa ma rii awasen ichi riiti harapa ma riina maji wor yepa saka yakiitawak. Worek, akama kowu tawa ma rii inyaka kwotayir. Kwotayichi, wakasa ma riina eecha wor, ‘Karakada nobo harapa nobo diita akamak tawey, na ameya i. Inyak, kiiriisiiposii ma, yatii kapasek tawa ma, tapa kapasek tawa ma, miy kiitii ma yenya na yeechi yaya.’ ");
INSERT INTO kmo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Worek, wakasa ma rii eecha wor, ‘Harapa ma, miita bawa maji ada otiiwa. Otii hamawak, miiti aka saka takakiisowak.’ ");
INSERT INTO kmo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Worek, harapa ma rii wakasa ma riin eecha wor, ‘Nabo i kwashika tana ma, nobo henya ma napa wohegiya yeechi yaya. Eeji aka sa takakiisii. ");
INSERT INTO kmo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ada kwona siiken wocho, ada mashi wor ma yepa saka eeji aboboy akiitawak.’” ");
INSERT INTO kmo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nokwapa nokwapa ma mima yecha Jisas riitaka ichar. Jisas rii dareboyechi yenya wor, ");
INSERT INTO kmo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kata ma rii adak yaney, rii sa riiti awi, eepi, mima, yikapwa, yaka kumwoy, mowey, ruwoy yenya mayama sa magiirechichi heechi. Magiirechichi heechinan siiney, riipa saka ana sumowukiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kata ma rii riiti men kiyanan siiney, ana sumowunan siiney, riipa saka eeji disaipel siikiitawak. Rii sapa eyey yadii riiti nobon heechiniga ana sumowuchiniga ha tawa nobobak i. ");
INSERT INTO kmo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ma por rii aka otiik hikitaney, mapo rii yi hikichi diita aka ya kapo shasha kiki siikiita. ‘Eeji ya kapo kikisiikiita yo hamakiita?’ ");
INSERT INTO kmo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Rii eemna hikinansiiney, riipa kwatiibanwoy siitiichikiita. Aka hamakasakech. Wonyak, ma ye ri yon hechi riina wohegakiita. ");
INSERT INTO kmo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yepa eecha wokiita. ‘Diita ma rii yon tasiiri otii hamakasakech.’ ");
INSERT INTO kmo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aka tabo yima por rii akar aka tabo yima riina o ana pik inyey, 10 tausen ow ana pichawa ma riitaka inyey, akar aka tabo yima riipa 20 tausen ow ana pichawa ma yecha riitaka yaney, ");
INSERT INTO kmo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","riipa yi eecha hikikiita ada saka kikisiikiitawak riina o ana pinyey. Komas akar aka tabo yima yapak tawey, ow ana pik yanak, riipa wakasa ma wochanak i gayasayekiita. Sakapa ow ana pikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jisas rii kawka eecha wor, “Kwo eechaba napa hiki. Kwo eyey boboyen magiirechichi heechinan siiney, kwo saka eeji disaipel siikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Woshi eeta kepi. Wowak, woshi somakwota tawa boboy eeta hamaney, kapo shecha kawka otiinak somakwotakiita? ");
INSERT INTO kmo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Eeta nosapen saka kiyatayekiitawak. Nowo saga, me, saka kiyatayekiitawak. Woshi kapasek eena raboto. Kwo mabiya taney, na meeji.” ");
INSERT INTO kmo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nedii pochi nokwapa nokwapa takis yan yaya tar ma ye kapasek boboy otii tar ma ye Jisas riina wageteyik yar. ");
INSERT INTO kmo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Worek, Perisi ma ye lon maji pokii ma ye Jisas riita otiir yon ye eena awasen awasen maji bar. Yecha eecha wor, “Diita ma rii kapasek boboy otii tawa ma yenya woshi aniga yechaka eecha ato.” ");
INSERT INTO kmo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Worek, Jisas rii diita shiyi tawa noma yenya eecha wor, ");
INSERT INTO kmo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ma porkwotaka tawey, rii 100 sipsip tawey, pochi heechi iwa. Rii saka hewak. Rii boy shecha otiito? Rii 99 sipsip wohejak tawa eemek eeka heechi rii heechi iwa. Sipsip poren yesha he yak ir. ");
INSERT INTO kmo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Rii hewak, rii tawak, yeechi tiimiinak seechi kiya yato. Rii inyaka kwoya hikichi riiganiga akamak awasen yayato. Wowak, rii riiti nareboy bana bana tawa man uwawak, ‘Na kwota eyey ya nota riigak. Ada sipsip por heechichari, he yeechi yayawa.” ");
INSERT INTO kmo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eechaba otiito, ada kwona wocho: kapasek otii tar ma por rii riiti inyaka dareboyeney, hevenek tawa ma mima yecha kwoya woy hikitu. Wowak, inyaka kepi hiki tawa ma yecha inyaka saka dareboyetawak, hevenek tawa ma yecha yenya karakada inyaka kwoya hikitu. ");
INSERT INTO kmo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jisas rii kawka eecha wor: “Mima pochi sii 10 yak tawa. Tawey sii pochi abosuchi heechuwa. Heechawak, sii boy shecha otiito? Sii Lam hi hayachi sii ada hakochi eyey eemen sii hehar hechi yan eeka hewa. ");
INSERT INTO kmo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wiita moni hechi sii siiti nareboy, bana bana tawa mima yenya uwato: ‘Na kwota eyey yanak nota riigak. Ada heechuwa yan hewa.’ ");
INSERT INTO kmo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eechaba otiito, ada kwona wocho: kapasek otiitawa ma rii riiti inyaka dareboyeney, God riiti ejel yecha inyaka kwoya hikitu.” ");
INSERT INTO kmo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas rii kawka eecha wor: “Ma por rii tarek, ri hoyey yikapwa upurus tar. ");
INSERT INTO kmo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tarek, karakada yikapwa riita ri apoko riin eecha wor, ‘Apoko, eeji komas yak tawa boboy, miita ana komas hak tawa boboy apok ana na ha.’ Worek, apoko rii riiti boboy, ya yaka kumwoy piiriina homachicir. ");
INSERT INTO kmo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Homaschichirek, iyavek kumwoy rii riiti boboy yan yopo yichi, rii heechi akar yepak tawa eemek ir. Irek, rii kapasek yon otiitar. Anemeshe rokotar. Riiti ya rabo ya payar. ");
INSERT INTO kmo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Rabo ya payarek, komas kata eemek aboboy karakada tar. Aboboy karakada tarek, rii harapa eecha har. ");
INSERT INTO kmo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Eecha harek, aboboy biish tarek, rii kata nosapek tar ma poren ir. Irek, riita eecha siir. Siirek, riin poyen havaken heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Irek poy atar boboyen rii abak gegiyar. Ma rii aboboy riina saka harek. ");
INSERT INTO kmo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Worek, rii hehar hikir. Hehar hikirek, rii mayama eecha wor, ‘Nokwapa nokwapa wakasa ma eeji apoko eeka tawey, ye harapa kepi aboboy ato. Atawak, ada diika tawey, ada eecha hato. ");
INSERT INTO kmo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ada sokwa eeji apoko heechi ik. I hechi ada riina wok, Apoko, ada kapasek boboy God riiti miy soma otiitar. Miiti miy soma otiibatar. ");
INSERT INTO kmo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ada kapasek tawa, Ana opoche miiti yikapwa habatanakech. Na otiichinyak, ada miiti wakasa ma siikiita!’ ");
INSERT INTO kmo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Worek, riita sokwachi apokon heechi ir. Iniga yapan icharek, riiti apoko rii riina her. Hechi riina inyakapwa hikir. Inyakapwa hikichiniga rii amaba i anapiirer. Anapiirechi omoramorer. ");
INSERT INTO kmo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Worek, yikapwa eecha wor: ‘Apoko, God riiti miy soma, miiti miy soma ada kapasek yo otiitar. Ada kapasek tawa. Ana opoche miiti yikapwa habatanakech.’ ");
INSERT INTO kmo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Worek, apoko riita riiti wakasa yenya eecha wor, ‘Siivatabi kepin na ameya yeechi yaya riina na ruwuchi. Tapama ruwu tawa ring na tapa ruwuchi. Yatii ruwu tawa boboyek yatii na ruwuchi. ");
INSERT INTO kmo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bulamakaw, kwokuka tawey, na yeechi yaya somakwo. Nota harapa nokusha akiita. Nota hokwa chikiita. ");
INSERT INTO kmo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Eeji yikapwa mashi har. Hachiniga rii kawka saniyawa. Riina yesha hiputar. Apa ada riina hewa!’ Worek, yecha nokusha eechi hokwa chichar. ");
INSERT INTO kmo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Worek, riiti yaka rii nowok tari, rii yar. Yarek, akak bana bana siitii meejir. ");
INSERT INTO kmo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Meejirek, rii wakasa ma poren uwachi wo yayar. Yarek, riina hokwa chicharen woher. Woherek, wakasa ma rii awasen riina wor: ");
INSERT INTO kmo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Miiti kumwoy rii yawa. Yawak, apoko rii kwokuka tar bulamakaw sowakwowa. Apoko rii yikapwan hewey, kepi tawa. Eena sowakwowa.’ ");
INSERT INTO kmo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Meejiniga, yaka rii inyaka kwotayer. Kwotayechiniga aka wo iyarekasakech. Worek, riiti apoko geenyek ya sayar. Ya sayachiniga riina wowoher. ");
INSERT INTO kmo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wowoherek, rii awasen riina wor, ‘Na he. Nokwapa nokwapa sukwiya ada miiti yo otiitari, ada miiti maji nosowoyekasakech. An eecha otiitari, mii ana boy boboyen har? Meme yin ana saka harek, ada eeji nareboyen saka nokusha arek. ");
INSERT INTO kmo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Apa miiti yikapwa riita i kapasek boboyen otiitarek, miiti harapa ya nobo mimak rabo ya paya hamerek, miita kwokuka tar bulamakaw pichiwa.’ ");
INSERT INTO kmo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Worek, apoko rii riin eecha wor, ‘Yikapwa, miita adaka eechaba eechaba tawa. Eyey boboy eeji eeta miiti. ");
INSERT INTO kmo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Eeta kepi nota hokwa chichu. No inyaka kwoya hikitu. Miiti kumwoy rii haniga tar. Apa rii awasen saniyawa. Rii nobo hikishar. Apa no hewa.’” ");
INSERT INTO kmo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas rii riiti disaipel yenya eecha wor, “Ma por rii tarek, riiti ya harapa tar. Wakasa ma por rii riiti ya yon otiichichar. Harapa ya kwowuka tar ma rii maji kawen meejir. Rii meejir riiti ya ye yon otiichichar ma rii saka ri yan hehar otiichirek. ");
INSERT INTO kmo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Meejirek, rii riina uwar, ‘Ana na ya!’ Worek, rii eecha riina wor, ‘Boyen maji ada miitak meejiwa? Jebwa keyi tawa jey na hamachi ana na yaya. Mii saka yo kepi otiitawak, eena mi yo eeta hamawa.’ ");
INSERT INTO kmo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Worek, wakasa ma meejichi mayama eecha wor, ‘Eeji harapa ma rii ana bokonawa. Bokoneechi ana heechuwak yawa. Anapa boyen otiikiita? Ada hapakasakech. Anapa saka payi iiviikiitawak. An hiibiya yawa akar man aboboyen woken otiiwey, an hiibiya yawa. Anapa boy otiikiita?’ ");
INSERT INTO kmo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hikichi mayama eecha wor, ‘Apa ana hikitu an otiik! Ada diita yon otii hamanak, ada nareboyeka siikiita. Siinak, komas yecha ana yechi akak woniga ye i yikiita!’ ");
INSERT INTO kmo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Worek, ma ye tari ye harapa yaka tar ma riiti yan sobo yar. Sobo yarin ye riin awasen hakasakech. Diita ma yenya wakasa ma rii uwar Uwachi wor: ‘Kwo na ya! Yarek, ma por riin wakasa ma rii eecha wor, ‘Na meeji. Boboy shasha eeji harapa ma riita miina sobo har?’ ");
INSERT INTO kmo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma rii awasen eecha wor, ‘100 dram gris.’ Meejichi wakasa ma rii awasen eecha wor, ‘Jey na yeechi yaya 100 na bachi poyenak, 50 dram gris na jeyek keyik!’ ");
INSERT INTO kmo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Worek, wakasa ma rii akar ma riin eecha woher, ‘Mii boboy shasha sobo yar?’ Rii awasen wor: ‘100 bek wit ana sobo hawa!’ Meejichi wakasa ma rii awasen wor, ‘Jeyek na keyi 80 bek wit!’ ");
INSERT INTO kmo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Worek, harapa yaka tawa ma rii eeta meejichi riiti kapasek wakasa man wahowur. Rii mayama hehar hiki tawa ma, eena wahowur. Wowak, diita nosap tawa ma yecha yechi boboyen hehar otiitawey, ye hehar weyitu. Wowak, God riiti yamak tawa yikapwa yecha yechi eechaba eechaba tawa boboyen saka hehar otiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisas rii kawka eecha wor: “Ada kwona wocho: Kwota diita nosap tawa ya eena na otiichinyak, kwi nareboy siikiita. Kwo otiitaney, nosap tawa ya hamanak, yepa kwona wonyak, kwopa ya eechaba eechaba tawa akak kwo yikiita. ");
INSERT INTO kmo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Kata ma rii karakada yon hehar otiitawey, riipa harapa yon eechaba hehar otiibatakiita. Kata ma rii karakada yon kapasek otiitawey, riipa harapa yon eechaba otiibatakiita. ");
INSERT INTO kmo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Miita diita nosap tawa yan hehar otiinan sowey, kapo nama miina eechaba eechaba ya siikenen miina hakiita? ");
INSERT INTO kmo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Miita akar ma yechi boboyen hehar otiinan sowey, kapo nama miiti boboyen miina hakiita? ");
INSERT INTO kmo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wakasa ma rii harapa ma upurusen saka sumowukiitawak. Saka kiki siikiitawak. Riipa poren yuyanak, poren rukiisiikiita. Riipa poren sumowutakiita. Poren nasowoyekiita. Opoko miiti God riiti nobo, moni ya tawa nobo, opoko eecha ichanakech.” ");
INSERT INTO kmo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Perisi ma yecha diita majin meejir. Meejichi yecha Jisas riina wosaboyer. Yecha moni ya rukusiito, eena yecha riina wosaboyer. ");
INSERT INTO kmo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Worek, Jisas rii yenya eecha wor, “Kwota mayama otiichiwak, ma ye kwona kepi hecho. Wowak, God riita kwoti mesek, sugu wopu hecho. Kata boboyen ma yecha hikitu eeta harapa. God riita hikitu eeta kubuchey boboy. ");
INSERT INTO kmo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses rii keyir lo piirapet yecha keyir maji sii tar. Tarek, ma mima yenya kiyatay tar. Tarek, uku yeechir Jon rii yar. Apa ma ye God riiti kigdom, riiti hadabas majin sawoto. Sawotawak, nokwapa nokwapa ma yecha daremaniga iyarek otiito God riiti kigdom. ");
INSERT INTO kmo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wowak, diita nosap eeta neerek tawa boboy eeta hamakiita. Wowak, lo riiti karakada wey boboy eeta sakapa hamakiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kata ma rii riiti miman heechiney, akar mima yaney, riita God riiti lo otii kapasowa. Ma por rii heechir mima siina yaney, rii God riiti lo otii kapasowa.” ");
INSERT INTO kmo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nedii pochi ma por rii tarek, riiti moni ya harapa tar. Rii eechaba eechaba siivatabi kepi ruwutarek, diita nosapek tawa boboy kepik eeka yichar. ");
INSERT INTO kmo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Worek, kiiriisiiposii ma por rii tabatar. Riiti hi Lasaras. Nokwapa nokwapa romo riiti mabak tar. Harapa tar. Tarek, yecha riina yaka tar ma riiti nuburejak eechaba eechaba yadii seechitar. ");
INSERT INTO kmo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Seechitarek, rii eecha hatar. Eecha hatarek, aboboy mogo moni yaka tar ma riiti cheyek sakatarek, riita aken gegiyatar. Asa yecha yaniga riiti romon tarekwoyek gwoya ar. ");
INSERT INTO kmo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Worek, kiiriisiiposii tar ma rii har. Harek, ejel ye riina Ebraham riita tar eemek kiya ir. Komas moni yaka tar ma habarek, chir. ");
INSERT INTO kmo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chirek, rii kapasek eemek tarek, harapa kapa meeji tar. Tarek, rii mey maka hechi Ebraham riina yapak tar eemek her. Lasaras rii Ebraham riitaka bana bana tarek, her. ");
INSERT INTO kmo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hechi rii uwar, ‘Apoko, Ebraham, ana na inyakapwa hikichi na ba diigiichi. Lasaras riina adak na heechinak ya. Yaniga riipa riiti tapamak ukuk kiiviichi eeji tarekwoyek heechinak, neekiir yakiita. Ada diita hik tawey, harapa kapa meejito.’ ");
INSERT INTO kmo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ebraham rii meejichi wor, ‘Yikapwa, na hiki. Miita nosapek tarek, miina miiti boboy kepin yatar. Yatarek, Lasaras riina kapasek boboy yatar. Apa rii kepi sowa. Mii harapa kapa meejito. ");
INSERT INTO kmo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Apa eechaba tawa: Harapa pwayi tobo sichi nediik tawa. Eecha tawak, ma mima yecha diita eemek tawey, miiti eem ik gegiyaney, ikasakech. Ma yecha miiti eemek yak gegiyaney, yakasakech.’ ");
INSERT INTO kmo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Worek, moni yaka tar ma eecha wor, ‘Apoko, ada miina woyasachiyasato. Eeji akak majin Lasaras riitak na heechinak sa i. ");
INSERT INTO kmo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Eeji yaka kumwoy yokotapa eeka tar. Ichi yenya wochanak, yepa kepi hikitanak, yepa diika kapa meeji otii tawa eemek saka yakiitawak.’ ");
INSERT INTO kmo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Worek, Ebraham rii eecha wor, ‘Moses riiti maji, piirapet yechi maji yechaka tawa. Tawak, yecha sa meeji.’ ");
INSERT INTO kmo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Rii awasen eecha wor, ‘Yaho, Ebraham, ma por rii ha eemek heechi saniyaney, yechak inyak, yechi kapasek boboy heechichi dareboyekiita.’ ");
INSERT INTO kmo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Worek, Ebraham rii awasen eecha wor, ‘Yecha Moses riiti maji, piirapet yechi maji meejinan siiney, ma por rii ha eemek heechi saniyaney, eechaba yechi inyaka sak hiki siitiichikiitawak.’” ");
INSERT INTO kmo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas rii riiti disaipel yenya eecha wor: “Eeta boboy yana kapak, otiichinyak, ma mima ye kapasek boboyen otiikiita. Wowak, kata ma ye diita boboyen otiichiwak, kapasek boboy harapa yechaka yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Eeta kepi yenya biiriiwaga papak kiitiichi ye i pa wawuk rabokiita. Wonyak, yepa eeta kapasek boboy sakapa otiikiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kwona opoy siitii ta! Miiti yaka kumwoy kapasek boboy otiiney, na wo: eeta kapasek! Riita inyakapwa hikichi dareboyeney, riita otiir boboy eena mi inyaka na heechi! ");
INSERT INTO kmo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Riita 7 kapasek boboyen rii miitaka yadii pochik otiiney, rii 7 nedii inyakapwa hikichi dareboyeney, miita riita otiir kapasek boboy na abosuchi.” ");
INSERT INTO kmo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Disaipel yecha Harapa Ma riina eecha wor, “Nota hiki siitiichichawa boboyen na harapa otiichi.” ");
INSERT INTO kmo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Harapa Ma rii eecha wor, “Kwoti hiki siitiichichawa boboy eeta karakada mastet siik tawaga taney, kwota diita men wonyey, ‘Na mayama honachi somakwotii tawa pak na chi! Lipa kwona otiichikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jisas rii eecha wor: “Miiti wakasa ma por taney, rii nowo yon otiitawak, kapo sipsip yenya siitii kowu tawak, wakasa ma rii riiti yon heechi akama yanak, mii kapo boy riina shecha wokiita, ‘Ne i aboboy a?’ ");
INSERT INTO kmo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yaho. Eecha bakasakech. Mii eecha wokiita, ‘Eeji aboboy na otii. Siivatabi na ruwuchi aboboy yon na otii. Ada ak. Komas miita a.’ ");
INSERT INTO kmo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wakasa ma rii majin sumowutawey, kwo kapo riina shecha woshiato? Yaho. Rii riiti yon otiito. Boyewak riin woshiato? ");
INSERT INTO kmo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wowak rii tawaga kwo eechaba tawa. Eyey majin kwona bawey, kwo eeta yon hamanak, napa ba, “Nota wakasa ma siiken tawa. Nota noti yoban otiir.’” ");
INSERT INTO kmo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas riita Jerusalem akama iniga rii Gaili nosap Sameria nosap rii eeta nediik ir. ");
INSERT INTO kmo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Rii akama pochi otiirek, rii 10 nomaka kapasek tar man nobok her. ");
INSERT INTO kmo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Omu nediik siitiiniga uwar, “Jisas, Harapa Ma. Nona na inyakapwa hikichi na ba diigiichi.” ");
INSERT INTO kmo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas rii hechi yenya eecha wor, “Kwo mayama kwoti opellen otii tawa ma yenya kwoti maban na i mukuchi.” Worek, ye iniga nobok tarek, yenya otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Worek, maba kapasek tar ma por rii ri maba hechi rii awasen ya Jisas riiti yatii jumuk wa Jisas riina woshiar. Diita ma eeta Sameria ma. ");
INSERT INTO kmo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas rii hechi wor, “10 man otii kepi siir. Akar 9 ma siitak tawa? ");
INSERT INTO kmo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Boyewak diita yapa eemek tawa ma riitaba awasen yaniga God riina woshi awa?” ");
INSERT INTO kmo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Worek, Jisas rii riina wor, “Na sokwa i. Miiti hiki siitiichichawa boboy eeta miina otii kepi siir.” ");
INSERT INTO kmo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Perisi ma kaw ye Jisas riina woher, “Siitiiyekega God riiti kigdom kapo yakiita?” Rii awasen wor, “God riiti kigdom yatawey, kwo eena saka hewak. ");
INSERT INTO kmo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma por rii saka bakiitawak, ‘Na he! Eeta diika tawa.’ Akar ma rii saka eecha bakiitawak, ‘Kataka tawa! Yaho. God riiti kigdom kwoti wok tawa.” ");
INSERT INTO kmo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Worek, Jisas rii riiti disaipel yenya eecha wor, “Eeta nediik yakiita kwopa Ma Yikapwan ri ya nedii heken gegiyakiita. Gegiyanak, kwopa saka riina hekiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma kaw ye kwona eecha wokiita, “Diina na he! Kana na he!” Wonyak opoche riina i yeshatanakech. ");
INSERT INTO kmo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sarebiya yerepiya tawak, neere yama hewey, eyey eemen yama hewaga, Ma Yikapwa riipa yanak, riita eechaba hekiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mapo Ma Yikapwa riipa sapa kapa meeji. Mapo riina diita nosap tawa ma ye riina sa nasowoy. ");
INSERT INTO kmo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ma mima ye Nowa riiti nediik otiitarega, Ma Yikapwa riipa yanak, eeta nedii ma mima eechaba otiitakiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowa riiti nedii ma mima yecha otii atar. Yecha mima yatar. Otiitarek, Nowa riita jabiir iyarerek, Harapa wayi vaniga ma mima yenya pi sowakwor. ");
INSERT INTO kmo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma mima ye Lot riiti nediik otiitarega, komas Ma Yikapwa ya nediik yepa eechaba otiitakiita. Lot riiti nediik yecha aboboy atar, uku atar. Yecha boboy awasen awasen tokotar. Yecha nowok chichar. Akan otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kata yadii Lot riita Sodom akamak heechi irek, woshika hika eeka sakar. Wayi vatawaga woshika hika eecha sakar. Sakaniga eyey sowakwor. ");
INSERT INTO kmo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mashi otiitarega, Ma Yikapwa riipa yanak, ma yecha riina henyak, eeta eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Jisas riita yana nedii ma rii aka geenyik taney, opoche aka wok iyarechi boboy yatakech. Ma rii nowok taney, opoche awasen akamak ichanakech. ");
INSERT INTO kmo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot riiti mima na hiki! ");
INSERT INTO kmo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kata ma rii riiti mesek neeki siitii chinyey, riipa mesek komas saka yakiitawak. Kata ma rii riiti mesek abosuchiney, riipa riiti mesek komas yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kata niyi nedii, ada kwona wocho, ma upurus cheyek wakiita. Wanak, poren yeechi yayakiita. Por riin heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mima upurus piiriita aboboy otii atanak, pochi siina yeechi yayakiita. Pochi siina heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ma upurus piir nowo otiikiita. Por riina yeechi yayakiita. Por riina heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Disaipel yecha riina woher. “Harapa Ma, siitak otiikiita? Jisas rii awasen wor, “Har ma yi maba sapi eeka tawey, aponumay ye ya yopo yichikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Worek, Jisas riita diita shiyi tawa majin wor. Rii yenya maji pokiiniga wor: “Eeta kepi yecha God riina maji bato. Opoche yecha inyaka wopu nomayatanakech.” ");
INSERT INTO kmo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jisas rii diita noman eecha wor, “Jas por rii akama pochik tar. Rii God riiti maji akiikasakech. Rii ma yechi majin meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Worek, mimbiya mima pochi eeta akamak tar. Tarek, sii ya jas riina eechaba eechaba woyasachiyasa woher, ‘Ma por ana dagiirepoy tawak, miita ana na kiyatay.’ ");
INSERT INTO kmo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Worek, mapo jas rii meejichi siina saka kiyatayerek. Worek, sii kawka eechaba eechaba riitak yatar. Worek, komas jas rii mayama eecha wor, “Ada God riina saka akiitawak, ma saka meejitawak, wowak, diita yatawa mima siina ada meejichi otiik. ");
INSERT INTO kmo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Sii ana nomuya tawa boboyen hatawak, eeji maba nomuyato. Eena ada ddiita mibiya mima siiti nomon kiyatayekiita.” ");
INSERT INTO kmo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Harapa Ma Jisas rii kawka eecha wor, “Diita kapasek jas riita bar majin na meeji. ");
INSERT INTO kmo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wowak, na hiki! Kapo God riita riiti ma mima yenya kiyatayikasakech. Yaho. Riipa kiyatayek. God riiti ma mima yecha eechaba eechaba yadii niyi riina wohechanak riipa boy kapo ameya yenya kiyatay anaseechikiitawak? Riipa kapo boy eshar yenya kiyatayechikiita? ");
INSERT INTO kmo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ada kwona wocho: Riipa anasanak, riipa ameya yenya kepi otiichikiita. Wowak, Ma Yikapwa riipa yanak, nosap tana ma kapo riina hiki siitiichichakiita?” ");
INSERT INTO kmo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma kaw ye eeka tarek, yecha eecha hikitar yechi inyaka kepi tawa eyey akar ma yechi inyaka kapasek tawa. Worek, Jisas riita diina hikichi diita shiyi tawa majin wor. ");
INSERT INTO kmo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ma upurus piiriita Ju ma yechi harapa lotu akak God riina maji bak yo ir. Perisi ma por tarek, takis yak tawa ma por tar. ");
INSERT INTO kmo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Perisi ma riiba geenyik siitiichiniga God riina maji baniga wor, ‘God, ada boboyen kwoya hekasakech. Ada hiyiyakasakech. Akar mima anemesh rokokasakech. Ada kata takis yak tawa ma kaka tawey, ada riitabaga takiisakech. Eena ada miina woshiato. Ada akar ma yechabaga takiisakech eena ada miina woshiato. ");
INSERT INTO kmo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Upurus yadii eechaba eechaba wik ada aboboy akasakech. Ada miina ten ten hato.’ ");
INSERT INTO kmo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Worek, takis ya tawa ma rii yapa eemek siitiichiniga mo heyiniga, riiti biiriipen hapakaniga God riina maji bar, ‘God ana inyakapwa hikichi na ba diigiichi. Ada eeta kapasek boboy otii tawa ma!” Worek, Jisas rii eecha wor, ");
INSERT INTO kmo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ada kwona wocho: Diita takis ya tawa ma riita akak irek, God riita riina kwoya her. Perisi ma riina kwoya hekasakech. Eyey ma ye mayama hin ye o ye inyey, ri hi iipa ye ikiita. Eyey ma ye mayama hin ye ye ye inyey, ri hi iipa harapa siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ma mima kaw ye yechi yikapwa baregan Jisas riitak yeechi yayar. Jisas riita riiti tapak neekik eena yayar. Riiti disaipel ye hechi yenya ow maji bar. ");
INSERT INTO kmo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Worek, Jisas riita yikapwan uwachi wor, “Eeta kepi yikapwa ana yak. Opoche anachekatanakech. God riiti kigdom eeta yikadey ma yechi. ");
INSERT INTO kmo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Diita na hiki ta! Ma rii yikapwaga God riiti kigdomek inyan siiney, riipa saka iyarekiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ju ma harapa por tar. Rii Jisas riina woher, “Maji pokii ma kepi, anapa shecha otiinak ada eechaba eechaga takiita?” ");
INSERT INTO kmo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas rii riina eecha wor, “Kapo mii boyewak ana kepi habato? God riitaba kepi tawa. ");
INSERT INTO kmo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mii 10 o maji hecho. Akar mima anamesherokotanakech. Opoche man sowakwotanakech. Opoche hiyi yatanakech. Opoche woshepii maji batanakech. Miiti awi eepi piiriiti hin na hehar hikichi ba ta.” ");
INSERT INTO kmo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rii meejichi awasen eecha wor: “Ada yikapwaga tar nediik ya ya diita apa ada 10 maji sumowutar.” ");
INSERT INTO kmo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas riimeejichi riina eecha wor, “Boboy podat mii saka otiirek. Eyey miiti boboy napa tokochi yan yeechi yaya. Yayaniga kiiriisiiposii tawa ma yenya napa homochi ha. Otiitanak, miipa hevenek tawa hadabas boboy kepin miipa yakiita. Otii hamanak, napa ya. Ana na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Worek, ma rii meejichi riiti inyaka harapa nomoyar. Riiti ya eeta harapa. ");
INSERT INTO kmo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas rii riina hechi eecha wor, “Yaka tawa ma rii God riiti kigdomek ik otiiwey, rii harapa yo yato. ");
INSERT INTO kmo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yaka tawa ma God riiti kigdomek iken otiiney, riipa harapa yo mayakan otiikiita. Wowak, kamel ye wowi pinya supuk iyarek otiiney diita yo karakada. ");
INSERT INTO kmo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ma mima ye meejichi riina woher, “Kapo nama yenya yesokwa yichikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas awasen wor, “Boboy ma ye keena saka otiitawak, God riitaba otiito.” ");
INSERT INTO kmo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita rii eecha wor, “Na he. Nota noti akan heechi miina sumowutar.” ");
INSERT INTO kmo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas rii yenya eecha wor, “Ada kwona wocho: diita maji siiken. Ma rii riiti akan, miman, yaka kumwoyen, awi eepin, yikapwan heechiniga God riiti kigdom iken wonyey, ");
INSERT INTO kmo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","diita apa nedii riipa nokwapa nokwapa boboyen yakiita. Komas nedii riipa eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas rii 12 disaipel yechaban eecha wor, “Na meeji. Nota Jerusallem akamak ichu. Mashi tar piirapet yecha Ma Yikapwa majin keyitar. Eyey maji yecha keyitarek, worek, Jerusalem akamak eeka sokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Riina anadii ma tapak yeechi hanak, yecha riina wosaboyeniga, wokwoyaniga, sogweya piikiita. ");
INSERT INTO kmo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yecha riina kubuk pichiniga sowakwonak, yadii piiriichar siichi riipa awasen saniyakiita. ");
INSERT INTO kmo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Worek, riiti disaipel yecha riita bar maji saka hikirek. Maji mu eeta veenyetar eena yecha Jisas riita bar maji saka meejirek. ");
INSERT INTO kmo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas riita Jeriko akamak icharek, miy kiitiir ma por rii yichinga yan wo wohechar. ");
INSERT INTO kmo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Rii nobok yicharek, ma mima ye icharek, rii meejichi woher, “Iiboy otiito?” ");
INSERT INTO kmo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ye meejichi eecha wor, “Nasaret Jisas riita yato.” ");
INSERT INTO kmo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Worek, rii meejichi rii uwar, “Jisas! Devit riiti neja, ana na inyakapwa hikichi na ba diigiichi!” ");
INSERT INTO kmo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Worek, yecha riina ow bachi anacheker. Worek, rii harapa teejiniga uwar, “Devit riiti neja, ana na inyakapwa hikichi na ba diigiichi!” ");
INSERT INTO kmo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Worek, Jisas rii meejichi siitiir. Siitiichi rii eecha wor, “Miy kiitiir ma riin adak na yeechi yaya.” Ye riina yayaniga bana bana tarek, Jisas rii eecha wor, ");
INSERT INTO kmo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ada miina shecha otiiken mii wocho?” Rii awasen wor, “Ada miy mey maka heken.” ");
INSERT INTO kmo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisas rii riina eecha wor: “Mi miyin na he. Miita hiki siitii chichawa boboy eeta miina otii kepi sowa.” ");
INSERT INTO kmo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Worek, miy otii kepi siirek, rii her. Hechi rii Jisas riina sumowuniga God riina woshiatar. Ma mima yecha hechi yecha God riiti hin yesokwatar. ");
INSERT INTO kmo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas rii Jeriko akamak iyarechi i wok yayer. ");
INSERT INTO kmo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Takis yan harapa ya tar ma rii eeka tar. Riiti hi eeta Sakias. ");
INSERT INTO kmo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rii tobo kada tar. Tobo kada tarek, Jisas riina heken eena otii otii hechar. Rii saka kiki siirek, ma mima kaw ye howuka siir. ");
INSERT INTO kmo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eeena rii amaba i mapo sekamor mek yowur. Jisas riina heken eena i yowur. Rii hikir Jisas riita diita nobok yato. Eena yowur. ");
INSERT INTO kmo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Worek, Jisas riita eeta mek bana bana yaniga rii mo hechi Sakias riina eecha wor, “Sakias, na ameya saka ya. Ada miiti akak apa eeka yik otiito.” ");
INSERT INTO kmo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Worek, Sakias rii ameya saka yar. Saka yaniga inyaka kwoya hikichi Jisas riina woshiar. ");
INSERT INTO kmo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eyey ma mima ye eena hechi eyipiir. Yecha wor, “Diita ma Jisas rii kapasek otii tawa ma riiti akak otii ak iwa.” ");
INSERT INTO kmo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Worek, Sakias rii siitiichi Harapa riina eecha wor, “Harapa Ma, na meeji. Ada eeji boboy nediik piikiichi kiiriisiiposii tawa ma kawen yenya hakiita. Ada ma kaw yenya hiyik yari, anapa yenya awasen diipiira kapiira hakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas rii riina eecha wor, “Apa diita magwi eena yesokwa yichawa. Diita ma rii eechaba Ebraham riiti yikapwa. ");
INSERT INTO kmo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nobo somoye tawa ma yenya yesha yeechi yesokwa yichiken eena Ma Yikapwa rii yar.” ");
INSERT INTO kmo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Worek, Jisas rii diita shiyi tawa noman meeji tar ma yenya sawor. Jisas riita Jerusalem akamak eeta nedii iyarek otiir. Eena ye eecha hikir God riiti kigdom kapo ameya sokwakiita. ");
INSERT INTO kmo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Eena Jisas rii diita noman eecha wor, “Harapa ma por tarek, rii heechi yapak tawa eemek ir. Riina harapa aka tabo yiman otiiken eena ir. Komas riipa riiti eemek awasen yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yapa eemek ik otiirek, rii riiti wakasa ma 10 yenya uwar. Uwachi yenya moni yan pochin podat podat har. Heechiniga rii eecha wor, ‘Diita moni yan na yeechi. Ada i akar eemek tanak, kwo diita yan napa yeechi akar yan na otii.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Worek, kata nosap tawa ma yecha riina yuyar. Worek, Harapa ma rii heechi irek, yecha yechi wakasa ma kawen majin wochirek ir. Ye eecha wochirek irek, eecha wor: ‘Nota kata ma riita aka tabo yima siinan yuyawa.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Worek, harapa ma riina aka tabo yima otiichir. Otiichirek, rii awasen yar. Awasen yarek, rii riiti moni ya har wakasa ma yenya uwachi wor: ‘Adaka na ya. Anapa hekiita kwo kapo ya shasha otiitar?’ ");
INSERT INTO kmo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Worek, meejichi mapo yar ma rii yaniga eecha wor: ‘Harapa ma, miita ana podat har yan ada otiiniga 10 mani yan kawka yar.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Worek, rii awasen wor: ‘Eeta kepi. Mii eeta wakasa ma kepi. Miita karakada boboy miita hehar sumowuri, anapa miina otiichinyak, miipa 10 harapa akamak kubu neeki ma siikiita.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Worek, akar wakasa ma por rii yaniga eecha wor: ‘Harapa ma miita ana har yan ada otiiniga 5 mani yan an kawka yar.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Rii meejichi awasen riina eecha wor: ‘Anapa otiichinyak, miipa 5 harapa akamak kubu neeki ma siikiita.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Worek, akar wakasa ma rii yaniga eecha wor: ‘Harapa ma, miiti maniy yan diita tawa. Ada ya pochin eeji siivatabik jichi veenyitar. ");
INSERT INTO kmo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ada miina akiitar. Mii hapaga tawa ma. Boboy miitikasakech mii i yayato. Saga miita saka chichawak, mii yeechi yayato.’ ");
INSERT INTO kmo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Worek, rii awasen riina eecha wor: ‘Mii wakasa ma kapasek! Miita bawa maki anapa yayanak, miina diigii poyekiita. Mii eecha hikitu ada hapaga tawa ma. Mii eecha hikitu boboy eejikasakech ada yayato, saga ada saka chichawak ada yayato. ");
INSERT INTO kmo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wonyak, miita hikitari boyewak miita ada miina har yan beng saka heechirek? Miita eecha otiiyega ada awasen yawak, ada mani yan awasen yeechi win mani eecha waga yawa!’ ");
INSERT INTO kmo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wochi rii kata siitii tawa ma yenya eecha wor, ‘Mani ya pochin na yeechi 10 mani ya tawa man na pochi ha!’ ");
INSERT INTO kmo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Worek, yecha riina eecha wor, ‘Harapa ma, boyewak riina kawka hak? Rii 10 mani ya tawa!’ ");
INSERT INTO kmo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Worek, rii eecha wor, ‘Ada kwona wocho, kata ma ye boboyek tawey, yen boboyen kawka hakiita. Kata ma ye boboy biish tawey, karakada boboyek yechaka tawey, ye heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wowak, kata ma ye ana piken otiitawey, an harapa aka tabo yiman siinan yuyawey, yenya na yeechi adak yayanak, eeji mi somak na pi sowakwo.’” ");
INSERT INTO kmo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas rii diita majin yenya wochi rii mapo Jerusalem akamak ir. ");
INSERT INTO kmo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Rii Betpasi akamak Betani akamak iyarek otiitar. Eeta akama Oliv kwowu bana bana tar. Iyarek otiitarek, rii riiti disaipel upurusen heechirek, piir mapo ir. ");
INSERT INTO kmo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Rii piiriina eecha wor: “Kicha na kata akama yepak i. Iyarenak, donki yi kicha hekiita. Mashi ma por rii eeta donki yin saka yo yicharek. Eena na heemachi na yeechi yaya. ");
INSERT INTO kmo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma por rii kinya wohenyey, ‘Boyewak kicha donki heemato?’ Riina napa awasen eecha wo: ‘Eeta Harapa ma rii yoka tawa eena yeshato.’” ");
INSERT INTO kmo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Worek, piiriita iniga her, Jisas riita bar maji eeka tar. ");
INSERT INTO kmo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Piiriita donki yin heemachiniga donki ma ye piiriina eecha wor: “Boyewak ki donki hemato?” ");
INSERT INTO kmo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Worek, piir awasen eecha wor: “Eeta Harapa Ma rii yoka tawa eena yeshato.” ");
INSERT INTO kmo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Worek, piiriita donki yeechi Jisas riina ye ir. Ye irek, piiriita maba riki yeechi donki maban ruwuchir. Ruwuchi piiriita Jisas riina yesokwa howuk yichir. ");
INSERT INTO kmo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Riita donki yiniga icharek, yecha yechi maba rikin nobok seechitar. ");
INSERT INTO kmo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Riita Jerusalem akamak iyarek otiitarek, Oliv Kwowu nobo i ye i icharek, nokwapa nokwapa riina sumowu tawa ma ye God riina woshieechiniga riina kwoyaba batarek, kwoyaba hikitar. Yecha harapa otiir boboyen herin eena yecha God riiti hin harapa yesokwa tar. ");
INSERT INTO kmo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ye eecha wor: “Eeta aka tabo yima rii God riiti hik yatawey, God riitana na hehar ta. God riiti inyaka eeta kwoya woy hikitu! Howuk tawa God riiti hin na yesokwa ta!” ");
INSERT INTO kmo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Worek, Perisi ma kaw eeka tari, ye eecha wor, “Maji pokii ma, miiti disaipel yechikujan na dasepii!” ");
INSERT INTO kmo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Worek, Jisas rii awasen wor, “Ada kwona wocho, yecha yechi kujan dasepiiney, diita yichawa papa yepa teejikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Rii Jerusalem akama bana bana irek, rii hechi eena keyatar. ");
INSERT INTO kmo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Keyaniga eecha wor: “Ada diita boboyen siiken hek, kwo siiken hikitu: inyaka otii kepi sii tawa boboy. Wowak, kwo saka hewak. Eena ada keyato. ");
INSERT INTO kmo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Eeta nediik yakiita kwonow ana pichawa ma yanak, yepa kwona heedii par payachi nediik heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wonyak, yepa kwona eyey ma mima yen inyi nediik tanak, pi hama seechikiita. Yepa inyi jichar papa eyey rabo hamakiita. Eeta nedii God riita kwona yesokwa yichik yari, kwo saka herek, eena kwon pi hama seechikiita!” ");
INSERT INTO kmo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas riita Ju ma yechi lotu aka wok iniga rii mani ya yo otii tar ma yenya kikiir heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Worek, rii eecha wor, “God rii mashi keyir majik eecha wor: ‘Eeji ada sii eeta ana maji ba tawa aka siikiita.’ Wowak, kwo otiirek, diita aka sii hiyi ya tawa ma yechi aka.” ");
INSERT INTO kmo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Worek, eyey yadii Jisas rii lotu harapa akak maji pokii tar. Harapa opelen otii tar ma yecha lo majin pokii tar ma yecha, aka tabo yima yecha Jisas riina sowakwo nobon yeshatar. ");
INSERT INTO kmo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Worek, yecha pi nobokasakech. Eyey ma mima yecha riina wageteyetar. Riiti eyey majin yecha meejik gegiyar. Eena yecha riina saka pi sowakworek. ");
INSERT INTO kmo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yadii pochik Jisas rii harapa lotu akak ma mima yenya maji pokii tar. Rii God riiti hadabas majin eena sawo tar. Sawo tarek, harapa opelen otii tar ma yecha, lo maji pokii tar ma yecha, akar harapa ma yecha yaniga ");
INSERT INTO kmo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","riina eecha wor: “Nona na sawo, nama miina wochirek, miita diita boboy otiito? Nama diita boboyen miina harek, miita otiito?” ");
INSERT INTO kmo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Worek, Jisas rii awasen wor, “Ada kwona maji wohek. Na ba. ");
INSERT INTO kmo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nama uku yeechir Jon riina wochirek, rii uku yeechi tar? Kapo God riita riina wochirek, kapo ma yecha riina wochirek? ");
INSERT INTO kmo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Worek, woher ma yecha awasen awasen maji bar. Ye eecha wor, “No boy shecha wok? Nota baney, ‘God rii riina wochirek,’ riipa awasen bakiita: ‘Boyewak kwota Jon riita bar majinsaka hiki siitiichirek.’ ");
INSERT INTO kmo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wowak, nota baney, ‘Ma yecha riina wochirek,’ diita nokwapa nokwapa ma mima yecha nona papan yeechi nona rabokiita. Ma mima yecha hiki siitiichichu Jon rii eeta piirapet.” ");
INSERT INTO kmo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eena yecha Jisas riina awasen wor, “Nota saka hikitawak, nama Jon riina hisiir.” ");
INSERT INTO kmo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Worek, Jisas rii yenyaawaseneecha wor, “Ada eechaba kwona saka bakiitawak nama ana hisiirek, ada diita boboyen otiito?” ");
INSERT INTO kmo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Worek, Jisas riita diita shiyi tawa noman ma mima yenya wor: “Ma por rii wain nowon chichar. Chi hamarek, worek rii wakasa ma kaw yecha otiiken eena wochir. Harek, rii riiti akaman heechi akar yapa eemek ir. Irek, nokwapa nokwapa sukwiya eeka tar. ");
INSERT INTO kmo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eeka tarek, siiken siikiir tar yarek, rii riiti wakasa ma riina nowoka tar ma yenya heechirek ir. Riiti nowok tar saga kawen yaken eena heechirek ir. Wakasa ma rii iyarerek nowo otii tar ma yecha riina kubuk pir. Boboy saga riina saka heechirek irek. ");
INSERT INTO kmo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Worek, rii akar wakasa ma por riina heechirek, kawka ir. I nowok iyarerek, nowoka tar ma yecha riina kubuk pibar. Pibachi kapasek boboy riina otiir. Yecha riina eecha otiichi ye boboy riina saka heechirek irek. ");
INSERT INTO kmo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Worek, rii akar wakasa ma kawka heechirek ir. Nowoka tar ma ye riina kawka pir. Pi rabor. ");
INSERT INTO kmo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Worek, nowo ma rii eecha wor, ‘Ada shecha otiik?’ Worek, rii eecha hikir, ‘Eeji yikapwa podareban ada rukusii tawey, anapa riina heechinak ikiita. Riina heechinak inyak, yecha riina meejikiita!” ");
INSERT INTO kmo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hikichi riina heechirek irek, nowoka tar ma ye riina hechi ye awasen awasen wor, ‘Di eeta nowo ma riiti yikapwa. No riina sowakwok. Sowakwonak, diita nowo eeta noti siikiita!’ ");
INSERT INTO kmo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Worek, ye riina nowok rabochi sowakwor. Wowak, eeta nowo ma rii nowoka tawa ma yenya kapo shecha otiikiita? ");
INSERT INTO kmo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Riipa yakiita. Yanak, riipa nowoka ma yenya sowakwokiita. Wonyak, riipa eeta nowon akar man hehareken hisiikiita.” Ma mima yecha meejichi eecha wor, “God sa anachek!” ");
INSERT INTO kmo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas rii meejichi yen hehar hechi eecha woher, “Wowak, diita mashi keyir maji siiti mu ii boy? ‘Kata papan yo otii tawa ma yecha rabori, apa rii eeta aka otii somar kwatii siir.’ ");
INSERT INTO kmo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kata ma ye kata papak sakaney eeta papa yenya pishemanekiita. Wowak, diita papa eeta ma hek sakaney, eeta riina monyenak, nosapega siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lo maji pokii tar ma ye, harapa opelen otiitar ma yecha meejichi eeta nediik Jisas riina poko jik otii her. Yecha hikir Jisas riita shiyinga batar maji yenya ow maji bar. Worek, akar ma mima yenya akiitarek, eena saka pokojirek. ");
INSERT INTO kmo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Worek, yecha kowuniga hechar. Yecha akar ma kawen mani yan heechiniga Jisas riina kasiyaken heechirek ir. Maji ama ye ik eena heechirek ir. Diita ma ye ichiniga kapasek boboy otiitarek, ye mukuchikeneecha hikitar ye eeta ma kepi. Ye iniga Jisas riina otii hikisahak ir. Otii hikisheyega yecha riina gavman riiti tapak how haken. ");
INSERT INTO kmo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Maji kasiya ma ye Jisas riina woher, “Maji pokii ma, no hikitumiita batawa maji miita pokii tawa maji eeta maji siiken. No eechaba hecho mii eecha hikitu ma he ho siikiisakech. Podatebak tawa. Mii God riiti nobon nona hehar mukuchuweyitu. ");
INSERT INTO kmo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wowak, nona na wo, noti lo kapo shecha wocho. II boy kepi nota Sisa riina takis yan hatawey, ii boy kapasek?” ");
INSERT INTO kmo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Worek, Jisas riita yechi inyakan wopun hechi awasen eecha wor, ");
INSERT INTO kmo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ya pochin ana na mukuchi.” Mukuchirek eecha woher: “Namey misoma diika tawa? Namey hi diika tawa?” ");
INSERT INTO kmo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yecha wor, “Sisa riiti misoma. Riiti hi.” Worek, Jisas rii eecha wor, “Wowak, Sisa riiti boboyen riina na ha ta. God riiti boboyen riina na ha ta.” ");
INSERT INTO kmo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Worek, yecha eyey ma mima yechi mi somak ye riiti majin saka otiiniga hikishatarek. Yecha henebarabochi eena ye kuja diimur. ");
INSERT INTO kmo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusi ma kaw ye Jisas riitak yar. Sadyusi ma ye eecha wor, ma mima ye saka saniya sokwatarek. Yecha Jisas riina woher: ");
INSERT INTO kmo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maji pokii ma, Moses rii diita majin keyir: Ma por rii tawey, rii haney, yikapwa biish taney, har ma riiti yaka kumwoy riiti miman sa yanak, har man yikapwa sa kiyachi! ");
INSERT INTO kmo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nedii pochi tarek 7 yaka kumwoy tar. Mapo yimowur yaka yikapwa har. Yikapwakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Worek, kumwoy rii riiti miman yar. ");
INSERT INTO kmo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yatari, rii habar. Nedii ma riita siina yarek, har. 7 yaka kumwoy ye eechaba eechaba otii tar. Ye yikapwakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Worek, mima sii komas habar. ");
INSERT INTO kmo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wowak, saniya sokwa tawa nedii kata mima siin namey mak yakiita? Wyey yaka kumwoy ye siina yatar.” ");
INSERT INTO kmo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Worek, Jisas rii yenya awasen eecha wor, “Diita nosapeka tawa nedii ma yecha mima yenya yato. ");
INSERT INTO kmo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wowak, kata har ma mima yecha kepi wiirek, yesokwanak, eechaba eechaba tanak, yecha miman saka yakiitawak, man saka yakiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yecha ejel tawaga eecha takiita. Yecha saka hakiitawak. Ye God riiti yikapwa sowa. Ye harek, God riita otiichirek, yecha saniyeechi wokwar. ");
INSERT INTO kmo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses rii hehar mukuchir har ma yenya yesokwakiita. Mashi karakada men uwurek, Moses rii her. Herek, Moses rii eecha wor: ‘Eeta God eeta Ebraham riiti God, Aisak riiti God, Jekop riiti God.’ ");
INSERT INTO kmo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Maji mu diitata: God rii eeta tawa ma yechi God. Har ma yechi Godekasakech. God riita ma yenya hechawey, eyey ma yecha tawa.” ");
INSERT INTO kmo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Worek, lo maji pokii ma kaw eecha wor, “Maji pokii ma, eeta maji kepi.” Worek, yecha riina saka maji kawka woherek. ");
INSERT INTO kmo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yecha akiitar. ");
INSERT INTO kmo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas rii yenya eecha wor, “Boyewak keyir maji eecha wocho eeta Kraist, eeta komas yakiitawa ma, rii eeta Devit riiti yikapwa? ");
INSERT INTO kmo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Devit riitaba eecha wor, ‘Eeta Harapa rii eeji Harapa riina eecha wor: Eeji mama yepak diika na yi. Yichanak, miiti ow ana pichawa man ada otiichinyak, miipa yen yatiik piitii dagiir takiita.’” ");
INSERT INTO kmo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wowak, Devit rii riina eena habar, ‘Harapa.’ Habatarek, boyega komas yakiitawa ma rii, eeta Kraist, rii Devit riiti yikapwa siikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eyey ma mima yecha Jisas riina wageteyeniga, Jisas rii riiti disaipel yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lo maji pokii tawa ma yenya na ow poy sii. Kaw yecha siivatabi gworowoka chishitu. Yecha awaba eemek eeka iwak, ma mima yecha lo maji pokii ma yenya woshi ato. Woshi atawak, lo maji pokii ma ye inyaka kwoya hikitu. Yecha harapa worebey lotu aka taweyek yecha eeka yichu. Nokusha atanak, yecha harapa worebey eeka yichu. ");
INSERT INTO kmo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yecha mibiya mima yechi boboy eyey yato. Yechi akan hiyika yato. Wowak, yecha woshepiiniga God riina harapa maji batol Komas yenya anaseechi pinyak, yecha harapa kapa meejikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas rii mey maka hechi rii mani yaka tawa ma yenya her. Ye mani yan bokis lotu akak tari, eeka heechir. ");
INSERT INTO kmo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Heechi rii kiiriisiiposii tar mibiya mima siina hebar. Sii karakada ya upuruseban heechir. ");
INSERT INTO kmo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Worek, Jisas rii eecha wor, “Ada kwona wocho diita kiiriisiiposii tawa mibiya mima sii harapa ya siiken har. ");
INSERT INTO kmo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wiita kiiriisiiposii tawey, sii siiti eyey yan har. Mani yaka tawa ma yecha kaw hawak, harapa ya kaw yechaka tawa.” ");
INSERT INTO kmo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma kaw ye harapa lotu aka maji batar. Eeta aka ma ye kwoya her. Mashi harapa kepi otiir papa eecha tar. Ma mima kaw ye papan God riina har. Akar boboy riina mashi har. Eeena yecha hechi kwoya hechi maji bar. ");
INSERT INTO kmo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Worek, Jisas rii eecha wor, “Diita eyey boboyen kwota heweyn eyey papan heweyn, komas reekiichi sakakiita. Ma ye papa pochi hek awa awa ho siichiri, sakapa takiitawak. Eyey sakakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma ye Jisas riina woher, “Maji pokii ma, kata nedii kapo siitiiyekega yakiita? Eeta boboy yak otiiney, nona kapo shecha tawa boboyen mapo mukuchikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisas rii eecha wor, “Na ow poy sii ta! Yepa eeta kwona woshepiikiita. Nokwapa nokwapa ma ye yaniga eeji he eecha wokiita, ‘Ada eeta riita. Eeta nediik eeta yawa.’ Yenya kwo opoche sumowutanakech. ");
INSERT INTO kmo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma ye awa awa ow ana pichanak, kwomeejitanak, opoche akiitanakech. Diita boboy eeta sapa ya. Ii hamakiitawa nedii saka ameya yakiitawak.” ");
INSERT INTO kmo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rii kawka eecha wor, “Ma ye eem pochik tawey, ye akar eemek tawa ma yenya ow ana pikiita. Akar harapa akama riipa way akar harapa akaman ow ana pikiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Harapanyenyaw yakiita. Harapa eechi hatawa nedii yakiita. Harapa hak otiitawa nedii yakiita. Eyey eemen. Kapasek boboy neerek otiikiita. Hisaw siirenobo neerek otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Diita boboy komas yakiita. Wowak, mapo kwona yeechi poko jikiita. Poko jinyak, kata kapasek boboy komas yakiita. Kwona lotu akak anaseechiniga poko jikiita. Kwota eeji hin habatanak, yepa kwona yeechi harapa aka tabo yima, gavman ma yechak kwona yeechi ye i siitiichi maji anasakakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eeta nediik kwopa napa God riiti hadabas maji napa geenyik sawo ta. ");
INSERT INTO kmo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Diita makabek na heechi ta. Opoche inyakapwa hikitanakech. Siikayekasii kwota bana maji. ");
INSERT INTO kmo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ada kwona kiyatayekiita. Ada kwona inyaka kepi tawa boboyen kwona hakiita. Hanak, kwoti ow ana pichawa ma ye maji awasen saka bakiitawak. Kwota bana maji yecha saka awasen bakiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Kwoti awi eepi, yaka kumwoy, ruwoy, nareboy yecha kwona kaw sowakwokiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eeji hi kwoti sugu wopuk inyakak eeka taney, yecha kwona yuyakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wowak, kwota kwoti masebiya por saka heechikiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na anabeyechi siitii. Anabeyechi siitiitanak kwopa mayama yesokwa yichikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jisas rii kawka eecha wor: “Ow ana pichawa ma ye Jerusalem akaman saban ow yi hamanak, kwo henyak, kwopa hikikiita akama siina pi hama seechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eeta nedii ma mima ye Judia nosapek taney, ye sapa kwowuk amaba i. Ma mima ye akamak taney, ye sapa heechi. Yecha sabak taney, ye opoche akama iyaretanakech. ");
INSERT INTO kmo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Diita nedii eeta awasen pik otii tawa nedii. Eecha otiinak, eyey mashi keyir majin wochari, iipa sokwakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Eeta nedii mima ye yikapwa kiya taney, kapasek siikiita. Eeta nedii mima ye yikapwan muku havataney, eeta kapasek siikiita. Hisaw kapasek boboy diikapa yakiita. God riita harapa inyaka kwotayechi ddita ma mima yenya pikiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yenya eemek ye ikiita. Biish tawa ma yecha Jerusallem akamak chishitakiita. Biish tawa ma yechi nedii eeta hamanak, ye Jerusalem akamak saka kawka piitiikiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Komas siirenobo ya, niiwiika, winyumay yechaka siikiita. Diita nosapek nokwapa nokwapa ma mima ye harapa akiita. Somakwotii tawa pa eeta harapa ukuboro sokwakiita. Sokwatanak, wasege yatanak yepa harapa akiitakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hisaw mayaka kapasek boboy diita nosapek yatanak, ma ye akiiniga kowutanak, ma kaw ye akiiniga hamag siikiita. Neereka tawa boboy yepa yechi nobon heechikiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yanak, Ma Yikapwariipa eecha yakiita. Hisaw hapaga mayakak hadabas boboyek riipa eecha yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Diita boboy eeta tasiinak, na siitiiniga na mey maka hecha. Kwona yesokwa yichi tawa nedii eeta bana bana siito.” ");
INSERT INTO kmo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Worek, Jisas rii diita noman yenya wor, “Pek men akar men na hiki ta. ");
INSERT INTO kmo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kwota henyak meshi buyanak kwo eecha hikikiita me siikwakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wowey, kwopa na hikikiita God riiti kigdom ameya yakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Na hiki! Diita hega ma saka hamakiitawak, ada bawa eyey maji sii mapo sokwakiita. Sokwa hamanak, yepa hamakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Eeta neer ddita nosap eeta eyey i hamakiita. Wonyak, ada bawa maji eeta saka i hamakiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kwota mayama na ow poy sii ta. Opoche harapa nokusha atanakech. Hapaga uku atanakech. Kwo nosap boboyen opoche inyakapwa hikitqanakech. Otiitaney, hamakiitana nedii yanak, kwonmaniga eecha sakakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Man saka tawaga kata nedii eyey diita nosapek tawa ma yenya eecha sakakiita. ");
INSERT INTO kmo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Na siitii kowu ta God riina maji ba ta. Siitii kowu taney, God riina maji ba taney, kwopa anabeyechi siitiikiita. Anabeyichi siitiinak, diita kapasek boboy yanak, kwopa eyey kepi siikiita. Siichi kwopa Ma Yikapwa riiti mi somak siitiikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Eeta nedii Jisas riita Ju ma yechi harapa lotu akak maji pokii tar. Hogo sii nediik riita Jerusalem akamaka heechi sabak i Oliv Kwowuk eeka i watar. ");
INSERT INTO kmo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Niyegak eyey ma mima ye harapa lotu akak riiti maji meejik ichar. ");
INSERT INTO kmo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Eeta nedii Ju Ma yechi Pasova nokusha atar nedii. Yecha eecha Gey Yis Biish nokusha atar. ");
INSERT INTO kmo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Harapa opelen otiitar ma ye, lo maji pokii tar ma ye Jisas riina sowakwoken otii otii her. Sowakwo nobo yesha hipur. Yecha ma mima yenya akiitar. Nokwapa nokwapa ma mima ye riina sumowu tarek, eena ye akiitar. ");
INSERT INTO kmo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Worek, Gaba rii Judas Iskeriot riiti sugu wopu wok ir. Rii eeta Jisas riiti disaipel por. ");
INSERT INTO kmo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Worek, Judas rii heechi harapa opelen otii tar ma yenya harapa lotu akan siitii kowu tar ma yenya maji bar. Boyega riita Jisas riina yechi tapak howu hak wonyak, eena maji ba tar. ");
INSERT INTO kmo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yecha meejichi inyaka kwoya hikichi Judas riina mani ha maji wor. ");
INSERT INTO kmo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas rii yechi majin wohowur. Wohowurek, Jisas riina yecha pi nobon eena yeshar. Mima ma yecha henyan yuyar eena yeshar. ");
INSERT INTO kmo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gey Yis Biish nokusha a nedii yar. Ma mima ye sipsip yin sowakwoken otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Worek Jisas riita Pita, Jon piiriina heechirek ir. Rii piiriina eecha wor, “Na i. Noti Pasova nokusha ak na sayarechi.” ");
INSERT INTO kmo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Piir meejichi woher, “Mii shecha hikitu? Sicha kapo siita sayarechik?” ");
INSERT INTO kmo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Rii eecha wor, “Na meeji. Ki akamak iyarenak, kipa hekiita ma por rii uku awen kiyato. Nobok jawonak, riina na sumowu. Rii aka wok inyak, na sumo iba. ");
INSERT INTO kmo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ki iyarenak, aka ma riina na wohe, ‘Eeta Maji Pokii Ma rii miina wocho: Siitak tawa aka wo adaka eeji disaipel yechaka Pasova nokusha ak?’ ");
INSERT INTO kmo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wonyak, riipa kinya aka won mukuchikiita. Eeta aka wok otiiwa a tawa boboy eeka tawa. Kicha na eena sayarechi ta.” ");
INSERT INTO kmo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Worek, piir heechi ir. Heechi iyarerek, piir her Jisas bar maji eeta tar. Tarek, ye Pasova otiiwa a boboy sayarechir. ");
INSERT INTO kmo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasova nokusha ar nedii yarek, Jisas riita riiti aposel yechaka cheyek yir. ");
INSERT INTO kmo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Worek, rii yenya eecha wor, “Komas ada harapa kapa meejikiita. Mapo ada Pasova aboboy kwotaka nota ak gegiyato. ");
INSERT INTO kmo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ada kwona wocho, ada diita aboboy diika kawka saka akiitawak. Ma ye diita aboboy siiti mun God riiti kigdom eemen hikinak, anapa kawka yechada akiita.” ");
INSERT INTO kmo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Worek, Jisas rii heebiya yeechi God riina maji ba wor, “Diita wain uku yeechi na homachichiniga an. ");
INSERT INTO kmo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ada kwona wocho: Apa diita wain ukun kawka akasakech. Komas God riiti kigdom yanak, eeta nedii anapa diita ukun kawka akiita.” ");
INSERT INTO kmo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Worek, rii geyen yeechi God riina maji bachi yenya hachi wor, “Dii eeta eeji maba. (Ada kwona hato. Kwota na eecha otiitaney, ana na hiki ta.” ");
INSERT INTO kmo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Otii a hamarek, riita heebiya eechaba yeechi yenya har. Rii eecha wor, “Diita heebiya eeta God riiti akar wohowur boboy. Eeji pi sakanak, ii eeta hapaga siikiita. Ii eeta poko shik kiitiito. Eeji pi eeta kwona gwotapakachiwa.) ");
INSERT INTO kmo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Wowak, na he! Kata ma rii ana magiirechichawak, riita diita cheyek adaka yichu! ");
INSERT INTO kmo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God riita otiichirek, Ma Yikapwa riipa hakiita. Wowak, kata ma rii riina magiirechichawak, riipa eeta kapasek wey siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Worek, yecha awasen awasen maji wohechar, “Kapo namapa diita boboyen otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisas riiti disaipel yecha awa awa ow maji bar. Yechaka tari, kapo nama eeta harapa, kapo nama eeta karakada eena awa awa maji bar. ");
INSERT INTO kmo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisas rii yenya eecha wor, “Diita nosapeka tawa aka tabo yima yecha wochuwak ma ye otiito. Hapaga boboy yechaka tawak, ye mima ma yenya dagiirepoytu. Riina habato rii ma mima yenya hehar tawa ma. ");
INSERT INTO kmo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wowak, diita nosap otii tawa abo kwotaka opoche otii tanakech. Harapa ma kwotaka tawey, riita yikapwaga sa ta. Neeki yesokwa tawa ma rii kwotaka tawey, riita wakasa ma tawaga sa eecha ta. ");
INSERT INTO kmo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Diita nosapeka tawey, nama eeta harapa? Ma kaw cheyek ak yichawey, ma kaw aboboy gwotiito. Nama eeta harapa diita nosap? Yichawa ma rii eeta harapa. Wowak, ada kwona wocho, ada kwotaka tawey, ada wakasa ma yo otiito. ");
INSERT INTO kmo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nokwapa nokwapa nomoya boboy adaka eechayatari, kwo ana heechi ikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eeji Apoko rii ana harek, ada ma mima yesokwa neekitu. Riita ada yesokwa neeki tawa boboyen harega, ada kwona eechaba hakiita. ");
INSERT INTO kmo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Komas kwopa eeji kigdom eemek cheyek eeka aboboyen ukun yi akiita. Kwopa harapa worebey yichiniga kwopa Isrel riiti 12 magwi yenya anasakiita. ");
INSERT INTO kmo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon! Na meeji! Gaba rii ana woher kwon yeechiniga otii otii heken. Wit sharega saniga yichinak omu saniga yicha waga Gaba rii kwona eechaba otiiken gegiyato. ");
INSERT INTO kmo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wowak, ada God riina maji bar. Miiti God riina hiki siitiichichawa boboyenkwona heechinakech eena ada miina God riina hiki siitiichichawa boboyen kwona yanak, mii miiti yaka kumwoy yenya na otii sa hapaga sii.” ");
INSERT INTO kmo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita rii awasen eecha wor, “Ada miitaka poko jibak iken hikitu. Ada miitaka habak iken hiktu.” ");
INSERT INTO kmo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas rii eecha wor, “Ada miina wocho, eeta apochok rii aya nediik miita eeji hin veenyiniga piiriichar wokiita, ‘Ada riitikasakech.’ Wonyak, eeta apochok rii aya wokiita.” ");
INSERT INTO kmo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Worek, Jisas rii yenya eecha woher, “Mashi ada kwona heechirek iri, mani ya woy kwo, boboy woy kwo, su saka ye irek, Kwo boy boboyekasakech. Kwo boy dopotar? Yecha eecha awasen eecha wor: “Nowi tar.” ");
INSERT INTO kmo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisas rii awasen wor, “Wowak, apa na komas nedii kata ma rii mani ya woy kwo taney, boboy woy kwo taney na yeechi ye i. Kata ma rii eekik tanan siiney, riipa riiti saket na heechi mani ya yeechi, eekin tokochi na ye i. ");
INSERT INTO kmo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ada kwona wocho: mashi keyir maji ana bari, ii sapa sokwa. Eecha wor, ‘Rii pokojir ma yechaka eecha heechir.’ Eeta mashi keyir maji ana bari, eeta omutiik sapa wokwa.” ");
INSERT INTO kmo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Disaipel ye meejichi wor, “Harapa Ma na he! Eeki upurus diika tawa.” Rii eecha wor, “Eeta kiki sowa.” ");
INSERT INTO kmo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas rii heechi Oliv kwowuk heechi ir. Rii otii tar abo. Riiti disaipel ye riitaka eecha ir. ");
INSERT INTO kmo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ichar eemek iyarerek, rii yenya eecha wor, “God riina na wohecha. Kapasek boboy yanak, kwon otii otii hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Worek, rii yenya heechi ameda i sakachi God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Rii God riina bar, “Apoko miiti inyaka eecha hiki taney; diita kapasek boboy adak yatawey mii na kwoyava yeechi. Wowak, eeji inyakak otiikasakech. Miiti inyakak na keena otii ta.” ");
INSERT INTO kmo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Worek, ejel por hevenek tar yarin, riitak yeechi riina otii kiyapor. ");
INSERT INTO kmo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Worek, rii God riina harapa maji bar. Riiti maba ukurama eeta pi saka tawaga eecha sakato.) ");
INSERT INTO kmo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Worek, rii sokwachi riiti disaipel yecha tar eemek ir. I heri, yechi bii nomoyarek, watar. ");
INSERT INTO kmo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Worek, rii yenya woher, “Boyewak kwo wato? Na sokwachi God riina maji ba. Banak, kapasek boboy yanak, kwona otii otii hehasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Rii maji baniga ma ye yar. Judas, Jisas riiti disaipel ma por rii mapo tar. Rii yaniga rii Jisas riina omoreremorek yar. ");
INSERT INTO kmo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yarek, Jisas rii eecha woher, “Judas mii boy ya ana omoreramorek Ma Yikapwa riina magiirechichu?” ");
INSERT INTO kmo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kata daisaipel yecha Jisas riitaka tari, otiik tawa boboy yecha heri yecha eecha wor, “Harapa Ma, no boy kapo noti eekik ow ana pik?” ");
INSERT INTO kmo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Disaipel por rii eeki yeechi harapa opelen otii tar ma riiti mabiya tiim rabor. ");
INSERT INTO kmo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Worek, rii eecha wor, “Eetayo!” Worek, rii wakasa ma riiti mabiya tapak how neekeri, eeta kepi siir. ");
INSERT INTO kmo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Worek, Jisas rii harapa opelen otii tar ma yenya, harapa lotu akan siitii kow tar ma yenya, Ju ma yechi harapa ma yenya Jisas riina yak yari, Jisas rii yenya eecha wor, “Boyewak kwo ana kubuka, eekika ana eecha yak yawa? Ada boy hiyiya ma? ");
INSERT INTO kmo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eechaba eechaba yadii ada harapa lotu akak kwotaka tar. Ada eeka tari, kwo ya ana otiik yakasakech. Wowak, diita nedii eeta kwoti. Diita nedii eeta hapaga niyi yo otii tawa ma riiti.” ");
INSERT INTO kmo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Worek, yecha Jisas riina yeechi harapa opelen otii tar ma riiti akak ye ir. Ye iniga Pita rii yenya yapak sumowutar. ");
INSERT INTO kmo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma kaw ye aka saba inyi wok hi tuku tar. Hi tuku tarek, ma kaw ye hik yicharek, Pita rii yaniga ii bak yir. ");
INSERT INTO kmo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yirek, wakasa mima pochi sii riina hechi sii riina he siitiichi eecha wor: “Diita ma rii Jisas riitaka eechaba tar.” ");
INSERT INTO kmo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Worek, Pita rii eecha wor, “Yaho. Mima, ada riina hekasakech!” ");
INSERT INTO kmo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Komas ma por riina hechi eecha wor, “Mii eetata, por!” Worek, rii awasen wor, “Yaho, ada riitikasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Awa komas akar ma rii eecha kwodii wor, “An her diita ma rii riitaka tar. Rii eeta Galili nosap ma.” ");
INSERT INTO kmo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Worek, Pita rii awasen eecha wor, “Yaho. Ada miiti maji meejikasakech.” Worek, riita maji wocharek, apochok aya ameya wor. ");
INSERT INTO kmo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Worek, Jisas rii siitiiniga dareboyechi Pita riina he siitiichir. Herek, Pita riita Jisas riita bar maji hikir: “Apa miita piiriichar eeji hin veenyiniga wokiita, ‘Ada riitikasakech. Wonyak, eeta apochok rii aya wokiita.” ");
INSERT INTO kmo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Worek, Pita rii heechi sabak i harapa keyatar. ");
INSERT INTO kmo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma ye Jisas riina siitii kow tar. Siitii kow taniga Jisas riina wosaboyechi kubuk pir. ");
INSERT INTO kmo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Worek, yecha riiti miyin siivatabik jir. Jichi yecha riina kapasek woher, “Na ba. Nama miina piwa?” ");
INSERT INTO kmo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Worek, akar kapasek majin yecha riina wor. ");
INSERT INTO kmo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Uhadiirek, Ju ma yechi harapa ma ye, harapa opelen otii tar ma ye, lo maji pokii tar ma ye ya yopo yichar. Worek, ye Jisas riina yayar. ");
INSERT INTO kmo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yayarek, yecha eecha wor, “Nona na ba. Mii boy kapo eeta komas yak tawa ma?” Worek, rii awasen eecha wor, “Ada kwona wonyey, kwota ana saka hiki siitiichikiitawak. ");
INSERT INTO kmo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ada kwona maji whohenyey, kwopa saka an awasen wokiita. ");
INSERT INTO kmo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Apa na komas Ma Yikapwa rii Harapa Mayaka God riiti mama yepa tapak yikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Worek, eyey awasen wor, “Mii boy God riiti Yikapwa?” Rii awasen eecha wor, “Kwota bawey, eetata.” ");
INSERT INTO kmo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yecha awasen eecha wor, “Nopa boy majin kawka meejikiita? No riiti majin no meejiwa.” ");
INSERT INTO kmo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Worek, yopo yichi sokwachi Jisas riina yeechi Pailat, aka tabo yima, riitak ye ir. ");
INSERT INTO kmo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ye irek, yecha riina ow maji bar. Eecha wor, “Kata ma rii nona ma miman nobo kapaseken mukuchichu. Rii eecha wor: ‘Sisa riina takis yan hatanakech.’ Rii eecha wor: ‘Ada eeta Kraist, eeta aka tabo yima.’” ");
INSERT INTO kmo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat rii meejichi riina eecha woher, “Mii boy Ju Ma yechi aka tabo yima?” Jisas rii awasen wor, “Mi maji eetata.” ");
INSERT INTO kmo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Worek Pailat rii harapa opelen otii tar ma yen, ma mima yen eecha wor: “Ada riiti majin meejiwey, rii eeta kepi. Boy nobok adapa riina dagiir poyekiita?” ");
INSERT INTO kmo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Worek, yecha harapa ow maji bar. Ye eecha wor: “Rii maji pokii tawey, nokwapa nokwapa ma ye inyakapwa kapasek hikichi kapasek nobok ir. Rii Galili nosapek sokwachi Judia nosapeka icharin rii apa diika yar.” ");
INSERT INTO kmo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat rii meejichi eecha woher, “Diita ma rii boy Galili ma?” ");
INSERT INTO kmo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Herot rii Galili nosapen aka tabo yima. Pailat rii meejichi Jisas ri yir eem eeta Herot riita neeki siitii tar eem. Rii meejichi rii Herot riitak heechirek ir. Eeta nedii Herot rii Jerusalem akamak tabatar. ");
INSERT INTO kmo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot Jisas riina hechi rii inyaka kwoya hikir. Rii Jisas rii otii tar abon mashi meejir. Meejichi rii mapo Jisas riin heken gegiyar. Kapo Jisas riita merikal otiinak heken gegiyar. ");
INSERT INTO kmo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Worek, Herot rii Jisas riina nokwapa nokwapa maji woher. Woherek, Jisas rii awasen bakasakech. ");
INSERT INTO kmo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Worek, harapa opelen otii tar ma ye, lo maji pokii ma ye ya Jisas riina kapasek ow majin wor. ");
INSERT INTO kmo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot riita riiti ow ana pichar ma ye Jisas riina wokwoyar, riina wosaboyer. Yecha aka tabo yima yechi siivatabin yeechiniga riina ruwuchir. Worek, ye Jisas riina kawka Pailat riitak heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Eecha otiirek, eeta yadii nedii Pailat, Herot piiriita nareboy siir. Mashi piir ow ana pichar. ");
INSERT INTO kmo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat rii uwarek, harapa opelen otii tar ma ye, Ju ma yechi harapa ma ye, ma mima ye ya yopo yichar. ");
INSERT INTO kmo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yicharek, rii yenya eecha wor, “Kwo diita ma riin adak yayar. Ya yeechi ana eecha worek rii ma mima yenya kapasek nobon mukuchichar. Apa kwota diika tawak, ada riina wo wo hewa. Ada wo wo hewak, ada hecho kwota riina kapasek yo otii majin bawey, rii takasakech. ");
INSERT INTO kmo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot rii eechaba heri, rii adak heechirek yar. Rii kapasek boboyen saka otiirek. Boyewak nota riina pi sowakwok? ");
INSERT INTO kmo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ada riina kubuk pichi ada riina heechinak ik.” ");
INSERT INTO kmo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Worek, eyey ma ye eecha wor, “Riina na sowakwo. Barabas riina na nona heemachi.” ");
INSERT INTO kmo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","(Eechaba eechaba Pasova nokusha ar nediik Pailat rii poko jichar ma poren heemachichawak ichu.) Eena ye eecha wor: Barabas riina na nona heemachi. ");
INSERT INTO kmo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas riita akar ma poren pi sowakwor. Rii ow ana pichar maji barek, ma ye ow ana pi inyakan hikir eena riina poko jir. ");
INSERT INTO kmo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Worek, Pailat rii Jisas riina heemachik gegiyar. Eena rii ma yenya ya ya yopo yichi maji wor. ");
INSERT INTO kmo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Worek, ma ye harapa uwar, “Riina na mek ji siitii chi. Na mek ji siitiichi.” ");
INSERT INTO kmo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Worek, Pailat rii piiriichar wor, “Boy kapasek boboyen rii otiir? Ada riina kubuk pichi heechinak ik.” ");
INSERT INTO kmo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Worek, ma ye harapa uwabatar. Yecha eecha wor: “Rin sa mek ji siitiichi.” Harapa uwatarek, ye Pailat riiti inyakan dagiir poyer. ");
INSERT INTO kmo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Worek, Pailat rii yechi woher maji meejichi otiir. ");
INSERT INTO kmo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabas riina rii heemachir. Barabas rii akar ma poren pi sowakwor. Rii ow ana pichar maji barek, ma ye ow ana pi inyakan hikir eena riina poko jir. Worek, Pailat riita Jisas riina Ju ma yechi tapak howu harek, ye yechi inyakak hikiri eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Worek, yecha Jisas riina ye ir. Iniga yecha ma poren nobok jawor. Riiti hi eeta Saiman, Rii Sairini nosap ma. Rii saba heechi harapa akama iyareken otiitarek, yecha riina tapa tobok neekichi wohegiya heechirek, rii Jisas riiti men yeechi kiyaniga ir. Kiya Jisas riina sumowuniga ir. ");
INSERT INTO kmo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nokwapa nokwapa ma mima ye Jisas riina sumowuniga ibar. Mima kaw ye Jisas riina keya yesokwaniga ichar. ");
INSERT INTO kmo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas rii yenya dareboyechi eecha wor, “Jerusalem akamak tawa mima, na meeji. Ana opoche keyatanakech. Kwoti yikapwan na eena keya ta. Kwota na mayama keya ta? ");
INSERT INTO kmo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Eeta nedii yakiita ma mima yecha wokiita: ‘Kata mima ye yikapwan yimowunan biish tawey, yikapwa baregan yimowan biish tawey, yikapwan muku heechinan siiney, eeta kepi.’ ");
INSERT INTO kmo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kata nedii ma mima ye eecha wokiita, ‘Kwow tom na noti mabak saka dagiir! Karakada kwow tom nona na gamu!’ ");
INSERT INTO kmo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma yecha eeta kapasek hega boboy me ukuka tanak, otiiney, yepa kapo shecha otiikiita me eeta reekasiinak.” ");
INSERT INTO kmo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yecha anadii ma upurusen ye ir. Piir kapasek yo tar ma eena ye piiriina Jisas riitaka eecha sowakwoken ye ir. ");
INSERT INTO kmo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yecha eem pochi siin eecha habatar “ma masek” eeta eemek iyarer. Iyarerek, yecha eeta eemek Jisas riina mek ji siitiichir. Worek, yecha kapasek yo otiir ma piiriina eechaba iibak ji siitiichir. Por mama yepa shikichirek, por yaji yepak shikichir. ");
INSERT INTO kmo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Worek, Jisas rii eecha wor, “Apoko, miita yechi kapasek boboyen na kwoyavayeechi. Ye saka otii hechawak.” Worek, yecha riiti saket yeechiniga laki anemeshe rokotarek, ma porek yar. ");
INSERT INTO kmo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Harapa Ju ma ye siitii Jisas riina wosaboyetarek, ma mima ye mey maka her. Ye eecha wor, “God riita riina hisiirega, rii eeta Kraist, eeta yak tawa ma eecha taney, rii mayama sapa yesokwa yichi. Rii anadii ma yenya yesokwa yichir.” ");
INSERT INTO kmo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ow ana pichar ma ye eechaga riina wosaboyer. Ye riina ya wain ukun howu hak otiir. ");
INSERT INTO kmo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ye eecha wor, “Mayama na yesokwa yichi. Mii Ju ma yechi aka tabo yima taney, na otii.” ");
INSERT INTO kmo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Worek, me subuk jebwa eeka keyir, “RII EETA JU MA YECHI HARAPA AKA TABO YIMA.” ");
INSERT INTO kmo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Worek, kapasek yo otii tar ma por riin shikichirek, rii tarek, rii kapasek majin Jisas riina wor, “Miita Kraist taney, mii mayama, sinya na yesokwa yichi.” ");
INSERT INTO kmo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Anadii ma por rii riina eecha wosowur, “Mii boy God riina akiikasakech. Yecha miin eechaba anasar. ");
INSERT INTO kmo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sicha kapasek yo otiitarek, eena yecha sinya anaseechiniga dagiir poyer. Wowak, diita ma rii kapasek yon saka otiirek.” ");
INSERT INTO kmo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Worek, rii Jisas riina eecha wor, “Jisas miita eecha yanak, aka tabo yimaga miita eecha yanak, ana napa hiki!” ");
INSERT INTO kmo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Worek, Jisas rii eecha wor, “Ada miina wocho, apa miitaka adaka hadabas eemek siikiita.” ");
INSERT INTO kmo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Otii a nedii siirek, ya saka pirek, niyi ya eyey nosap gamur. Awa piiriichar eeta siir. ");
INSERT INTO kmo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Eeta siivatabi harapa lotu akak tari, eeta piikar. ");
INSERT INTO kmo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Worek, Jisas rii aya harapa uwar: “Apoko, eeji mesek miitatapak hato.” Eecha wochi rii har. ");
INSERT INTO kmo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ow ana picha harapa ma rii diita hechi rii God riiti hin yesokwachi eecha wor, “Eeta siiken rii eeta ma kepi.” ");
INSERT INTO kmo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma mima ye boboy heken eeta eemek ya yopo yirek, diita boboyen herek, ye yechi akamak awasen iniga mayama inyaka kapasek hikichi biiriipiin hapakatar. ");
INSERT INTO kmo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Eyey ma mima ye Jisas riina hikichi riitaka Galili mima ye Galili nosap heechi Jisas riina sumowutarek, ye yapak siitiichi riina otiirin boboyen her. ");
INSERT INTO kmo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma por rii tarek, riiti hi Josep. Riiti aka ma eeta Ju ma yechi akama Arimatia. Rii eeta ma kepi. Riiti he kepi tar. Rii God riiti kigdom kowutar. Rii eeta kaunsi ma tar. Kaunsil ma tarek, rii kaunsi ma yechi inyakak podat hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Rii Pailat riina hek ir. Jisas riiti maban yeechi ye i chiken eena iniga woher. ");
INSERT INTO kmo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Worek, rii Jisas riiti maban yeechi apama siivatabik jichi kiya ir. Irek, papaka tar tiiriimo supuk ye i seechir. Eeta tiiriimo akar man saka chicharek. ");
INSERT INTO kmo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Eeta yadii eeta Sabat yak otiitar nedii. ");
INSERT INTO kmo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kata mima Galili nosap heechi Jisas riina sumowutarek, yecha Josep riitaka i tiiriimo her. Josep rii Jisas riina seechir tobon eena hebatar. ");
INSERT INTO kmo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hebatarek, yecha akamak heechi ir. Iri, yecha akamak maba kwowa ya tawa ukun kwowa ya tawa boboyen sayayerer. Worek, sabat nedii yecha yihapakar. Lo majin wori eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Uhadiirek, Sade nedii eeta mima ye sayarechi kwowa ya tawa boboyen ukun yeechi tiiriimo supukye ir. ");
INSERT INTO kmo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iyareri, yecha i her papa tagwa seechi tarek, ");
INSERT INTO kmo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ye iyarer. Iyareri, Jisasriiti maban saka herek. ");
INSERT INTO kmo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ye somoyeniga siitii tarek, ma upurus piir ameya yari, piiriiti siivatabi harapa apama hecharek, piir bana bana siitii tar. ");
INSERT INTO kmo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ye akiichi mo heyirek, piiriita yenya eecha wor, “Kwo boyewwak tawa man har ma tawa eemen yeshato. ");
INSERT INTO kmo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rii diika takasakech. Rii saniyeechi awasen sokwar. Riita bar maji Galili nosapek tari na hiki ta. ");
INSERT INTO kmo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Rii eecha wor, ‘Ma yikapwa riina kapasek yo otiiwa ma yeechi tapak sa howu ha. Howu hanak mek sa ji siitii chi. Ji siitii chinyak, yadii piiriichar siichi sa saniya sokwa.’” ");
INSERT INTO kmo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Worek, mima ye riiti maji wori ye eena marenokuk hikir. ");
INSERT INTO kmo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hikichi ye tiiriimo supun heechi diita otiir majin 11 disaipel yen anadii ma yenya eecha wor. ");
INSERT INTO kmo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yar mima diitata: Maria Magdala, Joana, Maria, Jems riiti awi, yecha anadii mima yechaka aposel yenya i eecha wor. ");
INSERT INTO kmo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Worek, aposel ye meejichi hikir mima ye bar maji eeta sobo maji bar. Ye eena saka hikirek. ");
INSERT INTO kmo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Worek, Pita rii sokwa tiiriimo supuk amaba ir. Iyarerek, rii i gamuchi tiiriimo siivatabiban mey her. Worek, rii heechi akamak awasen yaniga eecha otiir boboyen rii eena harapa hikitar. ");
INSERT INTO kmo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Diita yadii nedii ma upurus piir Emeas akamak chishitar. Jerusalem akama heechi Emeas 7 mail iyarerek, ");
INSERT INTO kmo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","piiriita eyey otiir boboy maji batar. ");
INSERT INTO kmo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yecha awasen awasen maji batari, Jisas rii piiriitak yaniga eecha chishitar. ");
INSERT INTO kmo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Piiriitak chishitari, piir riina hehar hekasakech. ");
INSERT INTO kmo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas rii piiriina eecha wor, “Boy maji ki awa awa ba chishitu?” Meejichi piir ichari siitiir. Nomoyarek siitiir. ");
INSERT INTO kmo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Siitiichi ma por rii, riiti hi Kliopas eecha woher, “Mii kapo boy miitaba Jerusalem akamak tarek, diita nedii otiir boboyen saka meejirek.” ");
INSERT INTO kmo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Rii awasen eecha wor, “Ii boy boboy?” Piir awasen wor, “Kata Nasaret Jisas riina otiir boboy. Diita ma Jisas rii eeta piirapet. God riita her eyey ma mima ye eecha her rii harapa yo otiiniga harapa maji bar. ");
INSERT INTO kmo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Noti harapa opelen tawa ma ye noti harapa ma ye Jisas riina Pailat riiti tapak howu harek, yecha riina dagiir poyerek, riina mek ji siitiichir. ");
INSERT INTO kmo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nota eecha kowu tarek eecha hikitarek rii kapo Isrel ma yenya yesokwa yichik. Diita boboy eecha otiirek, rii hari, piiriichar yadii diita sowa. ");
INSERT INTO kmo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mima kaw noti magwi tawey, ye nona wori no nyegarabor. Ye uhadiirek tiiriimo supuk ichi ");
INSERT INTO kmo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","riiti maban saka herek. Worek, ye awasen ya worek, ejel yenya her. Ejel eecha wor, ‘Rii tawa.’ ");
INSERT INTO kmo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma kaw notaka tawey, ye tiiriimo supuk ichiniga mima bar maji eeta siirek, ye her. Worek, yecha Jisas riina saka herek.” ");
INSERT INTO kmo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Worek, Jisas rii yenya eecha wor, “Kwo hikishato. Boyewak kwo piirapet yecha bar majin eshar hiki siitiichir? ");
INSERT INTO kmo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eeta Kraist rii kapa meeji tawa boboyen sa mapo kiya. Riita mapo sa kapa meeji tawa boboy yeechi komas hadabas boboy riipa yakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Worek, Jisas rii riina mashi keyir majin piiriina geenyik sawor. Rii Moses riiti maji tasiirek, eyey piirapet yechi keyir majin geenyik sawor. ");
INSERT INTO kmo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yecha i akama iyarerek, Jisas rii kawka ik otiirek, ");
INSERT INTO kmo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","yecha riina anachek yayar. Piiriita eecha wor, “Notaka na sii. Niyi siik otiito.” Worek, rii piiriiti akak eeka siik otiitar. ");
INSERT INTO kmo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Worek, piiriitaka cheyek yiniga, geyen yeechi God riina maji bachi, geyen reekiichi piiriina har. ");
INSERT INTO kmo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Worek, piiriiti miy eeta tagwachi eeta mey maka riina her. Herek, rii ameya i veenyirek, piir hekasakech. ");
INSERT INTO kmo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Piir awa eecha wor, “Rii sinya nobok bari, rii mashi keyir maji sinya geenyik bari, si inyaka wopu eeta kwoya woy hikiwa?” ");
INSERT INTO kmo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Worek, piiriita ameya sokwa Jerusalem akamak awasen heechi ir. Iyarerek, piiriita 11 disaipel ye anadii ma yechaka ya yopo yicharek, hechi ");
INSERT INTO kmo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","yecha piiriina eecha wor, “Eeta Harapa Ma rii siiken sokwar. Saiman rii riina her.” ");
INSERT INTO kmo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Piiriita nobok her boboyen yenya geenyik sawotar. Eecha wor Jisas riita geyen reekiirek piiriita riina her. ");
INSERT INTO kmo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Piiriita yenya diita boboyen sawotarek, eeta Harapa Ma rii ameya yechaka siitiitar. ");
INSERT INTO kmo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Worek, yecha eecha hikir yecha kapo gaban her. Eena eecha harapa akiitar. ");
INSERT INTO kmo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Worek, ye eecha wor, “Boyewak kwi inyaka akiito? Boyewak kwo saka eena hiki siitiichirek? ");
INSERT INTO kmo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Eeji tapan eeji yatiin na he. Dii eeta ada. Ana na neeki he. Wonyak kwo hekiita. Ada maba omu tawa. Ada hapa tawa. Eena spiritekasakech.” ");
INSERT INTO kmo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Worek, rii riiti tapan riiti yatiin mukuchir. ");
INSERT INTO kmo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Worek, yecha saka hiki siitiichirek. Yecha inyaka nyegarabori, kwoya hikiri eena saka hiki siitiichirek. Worek, rii eecha woher, “Kwo kapo aboboy tawa?” ");
INSERT INTO kmo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Worek, yecha riina emiyepen kaw har. ");
INSERT INTO kmo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Rii yeechi yechi mi somak rii ar. ");
INSERT INTO kmo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Worek, rii eecha wor, “Ada mashi kwotaka tarek, ada diita majin kwona bar. Moses riita ana keyir maji, piirapet yecha keyir maji, Sam maji eeta siiken sokwar. Eeta sa sokwa.” ");
INSERT INTO kmo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Worek, rii yechi marenoku tagwarchir. Mashi keyir majin hikiken eena tagwar. ");
INSERT INTO kmo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Rii yenya eecha wor, “Keyir maji diitata: Eeta Kraist rii sa kapa meeji tawa boboyen kiyachiniga sa ha. Hachi yadii piiriichar sa sii. ");
INSERT INTO kmo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wonyak, riiti hik kapasek nobon dareboyek majin, kapasek boboyen kwoyava ya tawa majin eyey nosap ma mima yenya sapa i sawo ta. Diita majin Jerusalem akamak sa tasii ta. ");
INSERT INTO kmo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kwota diita boboyen herin, kwopa napa sawo ta. ");
INSERT INTO kmo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kata boboyen eeji Apoko rii wocharin, anapa kwona hakiita. Wowak, diita akamak na kowu. Howuk tawa hapaga boboy eetapa kwotak apa yakiita.” ");
INSERT INTO kmo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wowak, rii mapo geenyik saya Betani akamak ir. Eeka rii riiti tapan ye wowuchi yenya rukusiitar. ");
INSERT INTO kmo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Rii yenya rukusiitari, rii yenya heechi howuk hevenek heechi ir. ");
INSERT INTO kmo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Worek, yecha riiti hin yesokwachi Jerusalem akamak awasen inyaka kwoya hiki ir. ");
INSERT INTO kmo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Harapa lotu akak ichi God riina woshiatar. ");
INSERT INTO kmo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mashi mashi nedii Maji rii eechaba tar. Eeta Maji rii God riitaka eecha tar. Eeta Maji rii eeta God. ");
INSERT INTO kmo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mashi heyi nedii rii God riitaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God riita riitak eyey boboyen otiitar. Boboy pochi akar nobok ya sokwakasakech. Yaho. Eyey sokwari riita eyey otiichirek, sokwar. ");
INSERT INTO kmo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mayi riitaka eecha tarik eeta mayi sii eeta eyey ma yechi haba. ");
INSERT INTO kmo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Eeta haba sii niyik yiyik okor tawak, niyi ya eeji pakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma porin riiti hi, Jon, God riita heechirek yar. ");
INSERT INTO kmo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Rii haba majin sawoken eena yar. Rii yarek, diita haba majin sawonak, ma mima yenya hiki siitiichiken, eena yar. ");
INSERT INTO kmo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Riita eeta habakasakech. Yaho. Rii yari, eeta haba majin geenyik kwodii wo mukuchiken eena yar. ");
INSERT INTO kmo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Diita haba rii eeta haba siiken. Diita haba rii yarek, eyey nosapek tawa ma mima yenya okoreechichu. ");
INSERT INTO kmo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Diita maji rii diita nosapek tarek, God riita diita nosapen riitak otiiri, diita nosapek tar ma mima ye, riina saka sumowurek. ");
INSERT INTO kmo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Rii riiti nosapek iri, eeta ma mima ye saka riina yarek. ");
INSERT INTO kmo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wowak, ma kaw ye riina yar. Yari, ye riina hiki siitiichiri, ye eeta kiki siirek, ye eeta God riiti yikapwa siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eeta yikadey ma mima ye pin, omun yimowukasakech. Ma otii tawa abon yimowukasakech. Yaho. God riita otiiniga ye sokwa riiti yikapwa siir. ");
INSERT INTO kmo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eeta Maji rii mak siirek, noti nediik tawa. Tawak, no ri hadabas boboyen her. Diita hadabas boboy sii rukusii tawa boboy omutiik tawa boboy takiikiisiir. Rii Apoko God riiti podareba yikapwa tarek, eena diita hadabas boboyen riina har. ");
INSERT INTO kmo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon rii riiti majin geenyik kwodii wor. Eecha kwodii wor: “Diita ma riina ada kwona eecha wori, ‘Ana komas yakiitawa ma rii eeta eeji Harapa. Mashi rii tar nedii ada takasakech. Yaho.’” ");
INSERT INTO kmo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nota eyey riitaka tawa rukusii tawa boboyen nota eyey eechaba eechaba yatakiita. ");
INSERT INTO kmo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God riita lon Moses riitak har. Wowak, rukusii tawa boboy omutiik tawa boboy sii eeta Jisas Kraist riitak yar. ");
INSERT INTO kmo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma por keena God riiti misoman hekasakech. Riiti yikapwa podareba riita riitaka tarek, rii eeta Godega tawak, rii riina geenyik kwodii wochar. ");
INSERT INTO kmo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem akamak tar Ju ma ye nediik tar ma kawen Livai ma kawen yechaka eecha heechirek, Jon riina maji woheken ir, “Mii kapo nama?” ");
INSERT INTO kmo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon riita meejichi maji veenyikasakech. Riita awasen eecha kwodii wor: “Ada Kraistekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Worek, ye awasen eecha wor: “Mii kapo nama? Mii kapo eeta Ilaija?” Jon rii awasen eecha wor: “Yaho. Ada riitakasakech.” Ye awasen eecha wor: “Mii kapo piirapet tawa?” Rii awasen eecha wor: “Yaho.” ");
INSERT INTO kmo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Worek, yecha eecha wor: “Mii kapo nama? Na awasen banak, nota keena nona heechirek yar ma yenya sawok. Miiti hi kapo nama habato?” ");
INSERT INTO kmo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Worek, Jon rii awasen eecha wor: “Ada diitata: ‘Ayan meejinan biish tawa eemek uwato: Harapa Ma riiti nobon na nagwa nagwa danegwa seechi!” Diita majin piirapet Aisaia riita mashi keyir. ");
INSERT INTO kmo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Perisi ma yecha diita ma yenya heechirek yar. ");
INSERT INTO kmo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yecha Jon riina woher: “Mii Kraist riikasakech. Mii Ilaija riikasakech, mii eeta piirapetekasakech. Wowey, boyewak mii ma mima yenya uku yeechitu?” ");
INSERT INTO kmo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Worek, Jon rii awasen eecha wor: “Ada yenya ukuk ukuyeechitu. Wowak, ma por rii kwoti nediik siitiitawey, kwo riina hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Riita ana komas sumowu yatawey, ada saka kiki siikiitawak riiti yatii pokon ada saka heemakiitawak.” ");
INSERT INTO kmo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Diita maji sii Betani akama Jodan pa pakiireba yepak tarek, eeka bar diita majin. Diita eemek Jon rii ma eeka uku yeechitar. ");
INSERT INTO kmo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Komas yadii pochi siirek, Jon rii her Jisas rii ya riitak yar. Worek, rii hechi eecha wor: “Na he! Dii eeta God Riiti Sipsip Yi. Rii diita nosapek tawa ma mima yechi kapasek boboyen bachi poyi tawa ma! ");
INSERT INTO kmo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Diita ma riina mashi ada wori apa ada kawka wocho: ‘Ma por rii ana sumowu yari rii eeta eeji Harapa. Mashi ada tanan tar nedii rii tar.’ ");
INSERT INTO kmo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ada keena riina hekasakech. Kapo nama yato? Ada yarek, man uku yeechitari, Isrel ma yecha diita ma riina heken eena an mukuchichar.” ");
INSERT INTO kmo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon riita maji yaya geenyik sawor: “Ada her Spirit rii heven heechi sejikiiregba saka tawaga eecha ya sakachi eeta ma riitaka tar. ");
INSERT INTO kmo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ada riina saka hechawak. Wowak, God riita ana ukuk uku yeechiken heechirek yar. Heechirek, yarek, rii ana eecha wor: ‘Mii hekiita Spirit rii sakachi ma poreka yikiita. Diita ma rii Holi Spiritek uku yeechikiita.’” ");
INSERT INTO kmo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon rii kawka eecha wor: “Ada eena siiken her. Dii eeta God riiti Yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Komas yadii pochik Jon rii eeka kawka siitiitarek, riiti disaipel upurus piir riitaka eecha siitiitarek, ");
INSERT INTO kmo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","rii her Jisas rii chishi irek, Jon rii hechi eecha wor: “Na he. Dii eeta God Riiti Sipsip Yi!” ");
INSERT INTO kmo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Disaipel upurus piir meejichi hechi riina sumowu eecha ir. ");
INSERT INTO kmo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Worek, Jisas rii dareboyichi heri, piir riina sumowu icharek, rii piiriina eecha woher: “Ki boy boboyen yeshato?” Worek, piir eecha wor: “Rabai, mii siita akak wato?” Rabai maji siin eecha wocho, Tisa. ");
INSERT INTO kmo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisas rii awasen eecha wor: “Ki na ya he.” Worek, piiriita riitaka i watar akan her. Worek, piir riitaka eecha nedii pochi tar. Hogo siiken otiitar nediik diitata. ");
INSERT INTO kmo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma por diita majin meejichi Jisas riitaka iri, riiti hi Endru. Rii Saimon Pita riiti kumwoy. ");
INSERT INTO kmo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Rii ameya i riiti yaka, Saimon, riina i sawor: “Nota hewa eeta Mesaia.” Mesaia diita maji eecha wocho eeta Kraist. ");
INSERT INTO kmo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Endru rii Saimon riina yeechi Jisas riitak ye irek, Jisas rii riina hechi eecha wor: “Mii Saimon, Jon riiti yikapwa. Miiti hi komas eeta Sipas habakiita.” Diita hi siin eecha dareboyer, Pita, Papa. ");
INSERT INTO kmo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Komas yadii pochik Jisas rii Galili nosapek iken otiir. Rii Pilip riina yesha hechi wor: “Mii ya adaka eecha ikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip rii Betsaida ma. Endru Pita piiriiti akama. ");
INSERT INTO kmo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip rii i Nataniel riina yesha hechi wor: “Diita ma riina Moses riita lo majik keyiri, piirapet yecha keyibari, no riina diita hewa. Rii eeta Nasaret Jisas, Josep riiti yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel rii meejichi awasen eecha wor: “Kapo Nasaret akama boboy kepin yesokwaney, kapo kiki siikiita?” Worek, Pilip rii awasen eecha wor: “Miita na ya he.” ");
INSERT INTO kmo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Worek, Jisas rii Nataniel riita riitak irek, rii hechi eecha wor: “Na he. Rii eeta Isrel ma siiken, Woshepii tawa maji riitaka kaw takasakech!” ");
INSERT INTO kmo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Worek, Nataniel rii awasen eecha wor: “Boy nobok miita ana tar nediik an heri, mii pek me, muk siitiitarek an her. ");
INSERT INTO kmo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Worek, Nataniel rii awasen eecha wor: “Tisa, mii God riiti yikapwa, Isrel yechi aka tabo yima!” ");
INSERT INTO kmo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas rii riina eecha wor: “Mii pek me muk siitiitarek, ada miina wowey, mii ana hiki siitiichichawey, ay, komas miita harapa boboy mayakan hekiita!” ");
INSERT INTO kmo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Worek Jisas rii yenya eecha wor: “Ada maji siikenen bato: Heven nubureja tagwa seechi tanak, God riiti ejel ye eeka ichichi yatanak, Ma Yikapwa riitaka eecha takiita. Eecha otii tanak kwo hekiita!” ");
INSERT INTO kmo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yadii nedii upurus siirek, ma por rii Kena akamak Galili nosapek mima tapa aken otiirek, Jisas riiti awi sii iibak tar. ");
INSERT INTO kmo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ye Jisas riina riiti disaipel yechaka yabaken woher. ");
INSERT INTO kmo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Worek, wain uku hamarek, Jisas riiti awi sii riina eecha wor: “Wain uku eeta hamawa.” ");
INSERT INTO kmo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Worek, Jisas rii siina eecha wor: “Mima, dii niji yokasakech. Yaho. Eeta eeji yo. Ada eena otiik tawa nedii saka yatawak.” ");
INSERT INTO kmo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Worek, Jisas riiti awi sii yo otiitar wakasa ma yenya eecha wor: “Riita kwona boy majin wonyey ii napa sumowu otii ta.” ");
INSERT INTO kmo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sikas papa awo eeka tari, Ju ma yechi lotu uku yatar awo. Diita awo tari, podar rii 20 galen ukun siivatar. ");
INSERT INTO kmo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Worek, Jisas rii eecha wor: “Ukun na yeechi yaya awok gwotii.” Worek, yecha siiv takiikiisiir. ");
INSERT INTO kmo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Worek, rii yenya eecha wor: “Kwota na kaw gwotiichi ye i aboboyen siitii kowu tawa ma riina ha.” Worek, ye ye ir. ");
INSERT INTO kmo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ye irek, diita mashi uku sobo tar wain ma rii yeechi a her. Rii hekasakech eeta wain uku sii kapo siitak taren yar. Wowak, uku yon otiitar ma ye her. Worek, aboboyen siitii kowu tar ma rii mima tapa aken otiitar ma riina uwa yayar. ");
INSERT INTO kmo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Uwa yayeechi riina eecha wor: “Eyey ma ye wain kepin mapo homochichu. Komas ma ye nokwapa nokwapa awak, ye kaw kapasek kepi a tawa wain ukun homochichu. Wowak, mii eeta wain uku kepin egesii heechi tari, apak mii yayato!” ");
INSERT INTO kmo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Dii eeta Jisas riita mapo mirakel tasiichi otii mukuchir. Kena akamak Galili nosapek eeka otii mukuchir. Riiti hadabas boboyen geenyik mukuchiken eena otiir. Eecha otiirek, riiti disaipel ye eena hechi riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Dii hamarek, Jisas rii riiti awi siitaka, riiti kumwoy yechaka, disaipel yechaka ye Kapaneam akamak ir. Irek, ye nedii kaw eeka i siir. ");
INSERT INTO kmo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ju ma yechi Pasova nokusha a nedii sayarek otiitarek, Jisas rii heechi Jerusalem akamak ir. ");
INSERT INTO kmo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Harapa lotu aka wok ma ye bulmakawen, sipsipen, nuriiren tokotarek, her. ");
INSERT INTO kmo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hechi Jisas rii pokon yeechi kubu pichawa pokon otiichi rii eyey sipsipen bulmakawen kikir poyi pakachi yan tokotar cheyen dabuchirek, ya mani saka i ye yar. ");
INSERT INTO kmo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Worek, rii nuriirek tokotar ma yenya eecha wor: “Na yeechi ye i. Kwo opoche eeji Apoko riiti akak awobak otiitanakech!” ");
INSERT INTO kmo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Worek, riiti disaipel ye mashi keyir majin eena hikitar. Diita maji sii eecha wor: “Ada miiti akan hakok otiitawey, hik uwunaga an eecha meejito.” ");
INSERT INTO kmo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Worek, Ju ma ye riina eecha wor: “Mii bwimey boboy nona mukuchikiita diita yo eeta miiti yo?” ");
INSERT INTO kmo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Worek, Jisas rii awasen eecha wor: Kwota diita God riiti akan na dagiinak, yadii piiriichar ada kawka otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ye meejichi riina eecha wor: “46 sukwiya eecha otiir aka! Mii boy eecha hikitu yadii piiriichareba ada otiikiita!” ");
INSERT INTO kmo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wowak, eeta akan riita wori, riiti maban eena wor. ");
INSERT INTO kmo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Komas Jisas riina tiiriimok chirek, awasen ya sokwarek, riiti disaipel ye eeta majin hikir. Hikirek, ye mashi keyir maji siin Jisas riita bar majin ye eena hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas rii Jerusalem akamak tarek, nokusha atarek, riita harapa yon otiirin, ma mima ye eena hechi hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wowak, Jisas yenya hehar hikikasakech. Rii eyey man he hamatawak, eena rii hehar hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Rii eyey man sugu wopun he hamato. Riina maka sawokasakech. Rii boyen doponak iin ma yecha otii tawa abon sawo mukuchik. ");
INSERT INTO kmo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ma por rii tari, riiti hi Nikodimas. Rii Perisi ma tarek, Ju yechi harapa ma. ");
INSERT INTO kmo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Eeta ma rii Jisas riina niyik yarek, eecha wor: “Tisa, no hecho mii eeta God riita heechirek yar Tisa. Ma por God riitaka tanan siiney, riipa diita yikadey mirakelen eecha otiikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas rii awasen riina eecha wor: “Eeta siiken ada miina wocho ma por kawka yimowunan siiney, riipa God riiti kigdom iyarekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas rii awasen riina eecha wor: “Boyega siichi harapa ma siirin kawka yimowukiita? Kapo awi siiti biik iyarenak, kawka yimowukiita?” ");
INSERT INTO kmo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas rii riina eecha wor: “Ada miina maji wocho, ma por rii ukuka Spiriteka yimowunan siiney, riipa saka God riiti kigdom iyarekiitawak. ");
INSERT INTO kmo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Omu sii omu tawa boboy yimowutu. Spirit rii spirit tawa boboyen yimowutu. ");
INSERT INTO kmo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Opoche kwo eena nyegiirabotanakech. ‘Kwota na kawka yimowu.’ ");
INSERT INTO kmo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sowa sii sokwa yatawey, siiti yok yato. Wowak, kwuku taweyn kwo eena meejitawak, sii sokwa ya tawa eem ichawa eem kwo hekasakech. Sii eeta nokwapak Spiriten yimowu tawaga eecha otiito.” ");
INSERT INTO kmo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas rii eecha wor: “Eeta boboy sii kapo shecha tawa?” ");
INSERT INTO kmo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas rii awasen riina eecha wor: “Mii Isrel ma yechi harapa tisa tawey, boyewak mii somoyeto? ");
INSERT INTO kmo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ada miina maji siikenen wocho: Nota batawey, nota hechawa boboyen eena bato. Nota sawotawey, nota her boboyen eena sawoto. Wowey, kwota nota sawo tawa majin magiirechichu. ");
INSERT INTO kmo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ada kwona nosapek tawa eyey boboyen eyey wori, kwo eena hiki siitiichikasakech. Howuk tawa boboyen ada kwona wonyey, kwopa kapo shecha hiki siitiichikiita? ");
INSERT INTO kmo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma por hevenek i yokasakech. Yaho. Ma Yikapwa riiaba hevenek tarin ya sakar. ");
INSERT INTO kmo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses riita biish tar eemek, hopon yesokwa howuk seechirega, Ma Yikapwa riin napa eechaba yesokwa howuk seechi. ");
INSERT INTO kmo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wonyey, eeta ma yepa eechaba eechaba tawa boboyen yatakiita. ");
INSERT INTO kmo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“God riita diita nosapek tawa man rukusiitarek, rii riiti Yikapwa podareban heechirek yar. Eeta ma rii riina hiki siitiichichawey, riipa hakasakech. Riipa eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God riita riiti Yikapwan heechirek yari, saka nosapek tawa man anasaken eena heechirek, yarek. Yaho. Yenya yesokwa yichaken eena heechirek yar. ");
INSERT INTO kmo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ma por Jisas riina hiki siitiichinyey, riipa anasakasakech. Ma por riina hiki siitiichinyan siiney, riipa anaseechi sii siiken siikiita. Rii God riiti Yikapwa podareba riina saka hiki siitiichicharek, eena sii siiken siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Anasak tawa boboy si mu diitata: Haba diita nosapek heechirek yari, ma ye niyi nobon kwoya hechawak, haba eena yuyato. Yecha kapasek boboyen otiitawak, eena ye eecha otiito. ");
INSERT INTO kmo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ma ye kapasek boboyen otiitawey ye eeta haban yuyatawak, ye eena habak yakasakech. Rii riiti kapasek boboyen habak yayaniga habak geenyik mukuchinyakech. ");
INSERT INTO kmo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wowak, ma rii God riiti yon sumowuchi, otiitawey, rii eeta habak yato. Yatawak, ma kwo napa riina heech rii God riina sumowu tawak, yo kepin otiitawak, rii eena yato.” ");
INSERT INTO kmo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dii hamarek, Jisas rii heechi Judia nosapek ir. Rii i yechaka eecha tarek, rii yenya uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon rii eechaba Inon akamak Selim akamak bana bana tarek, uku yeechibatar. Harapa uku eeka tarek, eena uku eeka yeechitar. Ma mima ye riitak yarek, rii yenya uku yeechitar. ");
INSERT INTO kmo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Eeta nedii Jon riin poko jikasakech. Komas poko jir. ");
INSERT INTO kmo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon riiti disaipel ye eeta nediik Ju ma yechaka uku yeechitar majin eena awasen awasen batar. ");
INSERT INTO kmo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Worek, ye Jon riitak ya riina wor: “Tisa, mii her Jodan pa yepak chishitar ma riina miita wori mii kapo hikitu? Wowak, rii man uku yeechi tawak, eyey ma riitabak ichu!” ");
INSERT INTO kmo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon rii meejichi yenya awasen eecha wor: “Hevenek yana boboyen yanan siiney ma boyega shecha yakiita? ");
INSERT INTO kmo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kwota mashi ada bar majin meejir. Ada eecha wor: ‘Ada Kraistekasakech. Yaho. God riita ana heechirek, mapo yari nobon ada takiiseechi taken eena yar.’ ");
INSERT INTO kmo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ma por mima yaken otiiney, eeta mima sii eeta riiti. Wowak, mima yawa ma riiti nareboy rii siitii eena wageteyetu. Rii mima yawa ma riiti ayan meejinak, rii eeta kwoya hikitu. Eeta nobon ada eeta kwoya hikitu. ");
INSERT INTO kmo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Rii sa ya harapa siinak, ada ye i karakada siikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Howuk yar ma rii eyey boboyen rii eyey boboyen rii howuk tawa. Ma rii nosapek taren heechi yari, rii eeta nosap ma. Rii diita nosapek tawa majin eena bato. Hevenek heechi yar ma rii eyey boboyen howuk tawa. ");
INSERT INTO kmo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Rii sawotawey, riita meejir bobyen her boboyen eena sawoto. Sawotawey, ma por eena meejichi kiikiiriina neekikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wowak, ma por rii diita majin meejichi kiikiiriina neekitawak, rii eecha wocho, “God rii eeta siiken.” ");
INSERT INTO kmo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Diita ma riina God riita heechirek yari, riita God riiti majijn kwodii wocho. God riita riina Spiriten hawey, takiikiisiinak, eena rii kwodii wocho. ");
INSERT INTO kmo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apoko rii riiti Yikapwa riina rukusiitawak riiti eyey boboyen riitaban har. ");
INSERT INTO kmo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma rii Yikapwa riina hiki siitiichichaney, riipa eechaba eechaba takiita. Ma rii Yikapwa riiti nobon sumowunan siiney, riipa eechaba eechaba tawa boboyen yakasakech. Iipa God riiti owuka tawa boboy eeta ma riitaka eecha siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Eeta nedii pochik Perisi ye maji pochin eecha meejir: Jisas riita nokwapa nokwapa ma miman yeechi uku yeechi hamar. ");
INSERT INTO kmo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wowak, ii Jisas riita uku yeechikasakech. Riiti disaipel yecha keena uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jisas riita her, Perisi ye eeta meejir. Worek, rii Judia nosap heechi Galili nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Eeta nobo sii i Sameria yechi nosapek i ichar. ");
INSERT INTO kmo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Worek, rii i Sameria yechi nosapek tarek i Saika nosapek iyarer. Nosap Jekop riita iiti yikapwan har nosap tar eemek ir. ");
INSERT INTO kmo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekop riita kwotiir wokebi eeta eemek tar. Tarek, Jisas rii ichari, riiti maba nomuyarek, rii eeta wokebi tar eemek eeka he yi hapakatar. Otii atawa mayi tarek, yichar. ");
INSERT INTO kmo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sameria mima pochi sii uku siiviiken yar. Yarek, Jisas rii siina eecha wor: “Nija ukun na siiviichi ana ha.” ");
INSERT INTO kmo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Riiti disaipel y akar akamak aboboyen tokoken i hamar. ");
INSERT INTO kmo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Worek, eeta Sameria mima sii awasen Jisas riina eecha wor: “Mii Ju ma. Ada Sameria mima. Boyewak miita ana ukun wohecho?” Ju ma ye Sameria ma yechaka awasen awasen geyekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas rii awasen siin eecha wor: “Nija God riita hatawa boboyen hikiyega, ninya ukun wohewa ma riina nija heyega, nicha riina wohewaga rii waga ninya eechaba eechaba tawa uku kepin ninya hawa.” ");
INSERT INTO kmo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mima sii riina awasen eecha wor: “Harapa Ma, miita uku siivii heebiya yakasakech. Diita wokebi heyek tawa. Miita eechaba eechaba takiitawa ukun mii siitan yato? ");
INSERT INTO kmo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Noti wayega Jekop riita nona diita wokebi ukun otiichi har. Riita, riiti yikapwa, riita asa boboy diita ukun atar. Mii kapa eecha hikitu ada harapa rii kapo karakada?” ");
INSERT INTO kmo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas rii awasen siina eecha wor: “Ma diita ukun ataney, yepa komas kawka uku aken hikikiita. ");
INSERT INTO kmo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wowak, diita ukun ada haken otiitaweym, ma por eena aney, riipa saka boriiwaga kawka reekasiitiitawak. Yaho. Eeta ukun ada yenya hatawey, iipa uku siiv eemega tanak, siipa eechaba saya tanak yepa keena eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mima sii riina awasen eecha wor: “Harapa Ma, diita yikadey ukun na ana hanak, anapa saka boriiwaga reekiisiinak, ukun kawka ya siiviikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisas rii siina eecha wor: “Naja na i niji man uwachi kicha diika eecha ya.” ");
INSERT INTO kmo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mima sii eecha wor: “Ada makasakech.” Jisas rii awasen eecha wor: “Naja ma biish ta maji wochawey, ni siiken woy wocho. ");
INSERT INTO kmo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mashi nija ma yokotapa tar. Eeta ma rii apa nijika tawey, rii niji ma siikenekasakech. Ni eeta siiken wowa.” ");
INSERT INTO kmo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mima sii eecha wor: “An hikitu mii eeta piirapet por. ");
INSERT INTO kmo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Noti wayega ye diita kwowuk ya yopo wuchi yi God riina woshiato. Wowak, kwo eecha wocho Jerusalem akamak eeka sa God riina kwoyaba hikitanak, kwoyaba ba ta.” ");
INSERT INTO kmo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisas rii siina eecha wor: “Mima ni napa eeji majin hiki siitiichicha. Eeta nedii yakiita kwo eeta kwowuk, Jerusalem akamak God riiti hin yesokwatakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sameria ma kwo kwota God riiti hin yesokwa tawey, kwo saka otii hechawak. Nota God riiti hin yesokwa tawey, nota otii hechaweyn eena yesokwato. Ma yesokwa yichi tawa boboy sii Juk tar heechi yar. ");
INSERT INTO kmo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Eeta nedii sii yato ya apa diita tawak, God riiti hin siiken yesokwa tawa ma ye spirit tawa nobok, omutiik tawa nobok God riiti hin yesokwatakiita. Eeta yikadey man Apoko God riita yeshato riiti hin yesokwataken.” ");
INSERT INTO kmo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Eeta mima sii riina eecha wor: “An hewa Mesaia riipa yakiita, riiti hi Kraist. Riipa yanak nona eyey boboyen sawo mukuchikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisas rii awasen siina eecha wor: “Diita adaba. Nijika maji bari.” ");
INSERT INTO kmo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eeta nediik Jisas ri disaipel ye heechi riitak yar. Yarek, ye her Jisas rii mimaka eecha majibatarek ye eena hechi nyegerabor. Worek, ye piiriina majikasakech. Ye siina saka wopoy paka herek, “Boyewak yawa?” Riina saka eecha woherek, “Boyewak mii mimaka maji eecha bawa?” ");
INSERT INTO kmo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Worek, eeta mima sii siiti heebiyan hey yichi heechi akamak iri, akama yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Na ya ma poren he. Riita ada mashi eyey otiitar boboyen kwodii wo hamawa. Rii boy kapo eeta Mesaia?” ");
INSERT INTO kmo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Worek, ye akaman heechi eyey Jisas riina heken ir. ");
INSERT INTO kmo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eeta nedii pochik riiti disaipel ye eecha wor: “Tisa, mii naw otii a!” ");
INSERT INTO kmo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Worek, rii awasen eecha wor: “Eeji aboboy kaw tawey, kwo hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Worek, disaipel ye meejichi awasen awasen bar: “Kapo riina anadii mak aboboyen har?” ");
INSERT INTO kmo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisas rii yenya eecha wor: “Eeji aboboy diitata: Ana heechirek yar ma riiti inyakan ada otii sumowuken riita ana har yon otii hamakiita. Eetata. ");
INSERT INTO kmo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Kwota eeta wocho: ‘Niwiika diipiira kapiira siinak, kow iiviikiita.’ Wowey, ada kwona wocho: Kwota na nowon he yeyi ta. Kow iivii nedii bana siito.! ");
INSERT INTO kmo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma rii sagan yeechi yopo yichi tawey, rii eeta yan yatawey, eechaba eechaba tawa ma yechi sagan yato. Eecha otiiwoy hikitu. ");
INSERT INTO kmo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Eena diita maji eeta siiken: ‘Ma kaw nowo sagan otii tawak, ma kow iiviito.’ ");
INSERT INTO kmo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ada kwona heechirek iri, kwota yo otiinan siir nowon kow iiviikiin eena heechirek ir. Mashi anadii mak otiiri, apa kwo saga kepin yato.” ");
INSERT INTO kmo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nokwapa nokwapa Sameria ma ye Jisas riina hiki siitiichir. Eeta mima sii eecha wor: “Eyey boboyen ada otiitarin, rii geenyik kwodii wor.” Eena yecha Jisas riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Worek, Sameria ma ye riitak ya riina woher: “Miita na notaka eecha ta.” Worek, Jisas rii yadii upurus eeka tar. ");
INSERT INTO kmo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nokwapa nokwapa ma ye riiti majin meejichi ye hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ye eeta mima siina eecha wor: “Saka nija sawowa majiban no meejichi hiki siitiichichawak. Yaho. Nota riiti kujak bar majin meejirek, eena nota hiki siitiichichu. Nota hikitu diita ma rii diita nosapek tawa man aasen yeechi yesokwa tawa ma.” ");
INSERT INTO kmo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas rii yadii pochi siichi Galili nosapek heechi ir. ");
INSERT INTO kmo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisas rii geenyik wor: “Piirapet rii riiti akaman hi takasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Rii Galili nosapek iyarerek eeta Galili ma ye inyaka kwoya woy hikir. Ye Jerusalem Pasova nokusha atar nediik i riita otiitar tobon hebar. Eena ye kwoya hikitar. ");
INSERT INTO kmo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisas rii Kenan Galiliyaka eeka ir. Eeta eemek rii wain ukun eeka otiir. Eeka tarek, gavman ma por rii riiti yikapwa Kapaneam akamak hak otiitar. ");
INSERT INTO kmo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eeta ma rii meejiri Jisas rii Judia nosap heechi Galili nosapek i majin meejir. Worek, rii i riina hechi eecha wor: “Miita na Kapaneam akamak yanak eeji yikapwan otii kepi siik. Rii kiiriidiichiken otiito.” ");
INSERT INTO kmo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisas rii riina eecha wor: “Kwo harapa mirakellen henyan siiney, kwo eena hiki siitiichikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Worek, gavman ma rii eecha wor: “Harapa, miita na adak ameya. Opoche eeji yikapwa hatanakech.” ");
INSERT INTO kmo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas rii awasen eecha wor: “Na i. Miiti yikapwa eetapa kepi siikiita.” Worek, eeta ma rii riita bar majin hiki siitiichi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Rii nobon icharek, riiti yo otiitar wakasa ma ye ya riina nobok jawor. Jaworek, ye riina eecha wor: “Miiti yikapwa eeta tawa!” ");
INSERT INTO kmo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Rii meejichi yenya woher: “Boy mey aua hageyegawa?” Ye awasen eecha wor: “Hogo yadii nediik maba hi uwutar boboy sii saka iwa.” ");
INSERT INTO kmo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Worek, apoko rii eeta auaka meejichi tarek, Jisas rii eecha wor: “Mi yikapwa apa eeta meseka takiita.” Worek, eena rii riiti yimana yechaka hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas rii Judia nosap heechi Galili nosapek iyarerek, mirakel upurus eeka otiir. ");
INSERT INTO kmo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nedii pochi siirek, Ju ma yechi nokusha atawa nediin sayarer. Worek, Jisas rii Jerusalem akamak yo ir. ");
INSERT INTO kmo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalemek sipsip yechi aka nuberejak pa pochi eeka bana bana tar. Eeta pa siiti hi Betesda. Ma yichar aka yokotapa eeta pa giirebak siitii tar. ");
INSERT INTO kmo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Eeta aka ye nokwapa nokwapa hak otiitar ma yecha watar. Miy dumutar ma, yatii hatar ma, yatii neeki ma eeka watar. Ye wa uku boro sokwaken eena kowutar. ");
INSERT INTO kmo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nedii pochi Harapa riiti ejel rii eeta pak yi i uku borowon sabwey tarek yatar. Worek, eecha otiitarek, ma por rii mapo i eeta pak ye i rumuchi sokwari rii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Worek, ma por rii eeta akak watari riita hak otiitar boboy 38 sukwiya eecha tar. ");
INSERT INTO kmo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eeta ma rii watarek, Jisas riita i heri rii keen mashi mashik haken otiitarek wabatar ma. Worek, Jisas rii riina eecha wor: “Mii boy ada otii kepi siiken hikitu?” ");
INSERT INTO kmo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hak otiitar ma rii awasen eecha wor: “Harapa Ma, ada uku boro wokwanak, i ye iken otiitawey, nama ana yeechi hey heechik? Ada eeta pak i ye ik otii tawey, ana anadii ma yecha heechi mapo i ye itu.” ");
INSERT INTO kmo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Worek, Jisas rii eecha wor: “Na sokwa miiti wa gwosen yeechi siitii chishi ta.” ");
INSERT INTO kmo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Worek, eeta ma rii ameya wa gwosen yeechi sokwa siitii chishir. ");
INSERT INTO kmo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eeta nedii akamak siitar nedii. Eena Ju ma yecha otii kepi siir ma riina eecha wor: “Diita akamak siitawa nedii. Miita miiti wa gwosen kiyaniga yawey, eeta noti lon mii reekiiwa.” ");
INSERT INTO kmo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Worek, rii awasen yenya eecha wor: “Ana otii kepi siir ma riita ana eecha wor: ‘Wa gwosen na yeechi kiya siitii chishi i.” ");
INSERT INTO kmo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Worek, ye riina woher: “Nama miina wochuwak miita wa gwosen yeechi kiyaniga chishitu?” ");
INSERT INTO kmo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Worek, otii kepi siir ma rii riina saka hikirek. Nokwapa nokwapa ma mima eeka tarek, Jisas rii i heechi ir. Eena rii saka hikitarek. ");
INSERT INTO kmo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Komas Jisas rii riina harapa lotu akak hechi eecha wor: “Na he. Mii eeta kepi tawa. Komas kapasek boboyen kawka otiikasakech. Iipa harapa kapasek boboy miitak kawka yakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Worek, eeta ma rii i Ju ma yenya wor: “Ana otii kepi siir ma rii eeta Jisas.” ");
INSERT INTO kmo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eecha otiirek, eena Ju ma ye riina kikireken hikitar. Boyewak? Riita akamak siitawa nediik eeta boboyen otiirek, eena kikirek hikitar. ");
INSERT INTO kmo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas rii yenya eecha wor: “Eeji Apoko riita yo otii i diita apa nedii ada eena eechaba otiito.” ");
INSERT INTO kmo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Worek, eena Ju ma yecha Jisas riina sowakwoken kwotay siitiichichar. Boyewak? Saka riita akamak siitawa nediiban reekiirin riita eecha wor: “God rii eeta eeji Apoko.” Eeji wori, rii eecha wor: “Ada eeta Godebaga siir.” ");
INSERT INTO kmo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas rii awasen yenya eecha wor: “Eeta siiken bor: Yikapwa rii saniga yon keena keena otiikasakech. Rii Apoko riita otii taweyn hechi rii otiito. Apoko rii eyey boboyen otiitawey, Yikapwa rii otiibato. ");
INSERT INTO kmo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Apoko rii eeta Yikapwa riina rukusiitawak, rii eyey boboyen otiitaweyn rii riina mukuchichu. Komas riipa riina harapa yo mayakan mukuchinak, diita otii tawa yon dagiir poyekiita. Otiinak kwo nyegiirabokiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Apoko rii ha tawa man yesokwa yichi tawaga Yikapwa riipa eechaba ha man yesokwa yichibakiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apoko rii ma poren anasakasakech. Eeta anasak tawa yo rii Yikapwa riitaban ha hamar. ");
INSERT INTO kmo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ma rii Apoko riiti hin yesokwa tawaga Yikapwa riiti hin eechaba yesokwabataken anasak tawa boboy eena har. Ma por rii Yikapwan riiti hin yesokwanan siiney, Yikapwan heechirek yar Apoko riiti hin yesokwakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ayo, ada kwona maji siikenen wocho: ma por rii eeji maji hiki siitiichinyey, ana Apokok heechirek yarin hiki siitiichichaney, riipa eechaba eechaba takiita. Eeta ma rii ya anasakasakech. Ha tawa boboyen rii heechirek, rii eechaba eechaba tawa. ");
INSERT INTO kmo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ada kwona maji siiken wocho: yak otiitar nedii, sii apa diita yawa ha tawa ma yepa God riiti Yikapwa riiti ayan meejikiita. Meejinak, yepa eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Apoko rii eechaba eechaba tawa boboy mu tawak, rii Yikapwa riina diita boboyen harek, rii eeta eechaba eechaba tawa boboy mu tawa. ");
INSERT INTO kmo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jisas rii Ma Yikapwa siiken tawak, eena God rrita anasak tawa boboyen riiti tapak har. ");
INSERT INTO kmo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kwo eena i hiki yo hikikasakech. Eeta nedii yanak, tiiriimo supuk tawa ma ye riiti ayan meejikiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Meejinak, yepa tiiriimon heechi geenyik ya sokwakiita. Wonyak, yo kepin otii tawa ma yen yesokwa yichinak, yepa eechaba eechaba takiita. Yo kapaseken otii tawa ma yen yesokwa yichinak ye anasakiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Adaba keena saniga eeji inyakak hikichi otiikasakech. Apoko God riita ana har maji bak eeka an anasakiita. Ada eeji inyakak otiikasakech. Yaho. Ada ana heechirek yar Apoko riiti niyakak otiitawak, eena eeji anasak tawa boboy sii eeta siiken. ");
INSERT INTO kmo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ada mayama eeji hiban kwodii wochaney, ii maji siikenekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wowak, akar tawey, riita eeji hin geenyik kwodii wo sawo mukuchitakiita. Wochawak an hecho ana kwodii wo mukuchichawa maji sii eeta siiken. ");
INSERT INTO kmo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Kwo Jon riina heechirek iri, rii maji siikenen kwodii wo hamar. ");
INSERT INTO kmo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sakayekasii eeji mun kwodii wochawey. Ada diita majin batawey kwona yesokwa yichaken eena bato. ");
INSERT INTO kmo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon rii eeta habaga tarek, rii man okoree mukuchichar. Worek, kwoti inyaka wopu riiti haban ameda kwoya hechi siir. ");
INSERT INTO kmo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Wowak, boboy kaw tawey, sii Jon riita heema pak tawa boboy siin dagiir poyechi eeji mun kwodii wocho. Ada otii tawa yo siita ana mayama heema pakachichu. Eeji Apoko riita ada otiiken har yo siita ana geenyik kwodii wo mukuchichu. Sii eecha wocho Apoko riita ana heechirek yar. ");
INSERT INTO kmo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ana heechirek yar Apoko riita eeji mun kwodii wocho. Kwo riiti ayan meejikasakech. Riiti misoman hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Riiti maji kwoti wok takasakech. Riita heechirek yar Yikapwan kwo hiki siitiichikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kkwo hikitu kwo mashi keyir majin kenyitaney, kwopa eechaba eechaba takiitawa boboyen yeshaniga hekiita. Kwota eecha otiitawey, ii mashi keyir maji eeta ana kwodii wo mukuchichu! ");
INSERT INTO kmo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wowak, kwo eena adak ya eechaba eechaba tawa boboyen yakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ada saka chishi ye i tawak, ma yecha eeji hin yesokwataken. ");
INSERT INTO kmo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wowak, ada kwona hecho. Kwota kwoti sugu wopuk God riina rukusiikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ada eeji Apoko riiti hik yari, kwo ana saka yarek. Ma por rii riiti hik mayama yaney, ii kwopa riina yakiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kwota yaka kumwoy kwoti hin mayama yesokwato. Wowak, kwo yo otiikasakech God riita kwoti hin yesokwaken. Eecha otiitawey, boyega shecha kwota hiki siitiichikiita? ");
INSERT INTO kmo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kwo hikitanakech anapa Apokok i kwona maji bakiita. Moses rii Apoko riitak i kwona maji sawokiita. Diita Moses riina kwo eecha hikitu riita kwona kiyatayekiita. ");
INSERT INTO kmo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kwota Moses riiti majin hiki siitiichiyega, ii waga eeji maji eechaba hiki siitiichiwa. Riita eeji hin keyichir. ");
INSERT INTO kmo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Riita keyirin kwota hiki siitiichinyan siiri, boyega kwo eeji majin hikikiita?” ");
INSERT INTO kmo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Worek, komas Jisas rii Galili pagiiriiba yepak heechi ir. Siiti hi Taibirias pa. ");
INSERT INTO kmo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma yecha Jisas riita otiir mirakellen herek, hak otii tawa man otii kepi siirin herek, nokwapa nokwapa ma mima yecha sumowuchishitar. ");
INSERT INTO kmo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas rii kwowukheechi yo iri, riiti disaipel yechaka eecha yichar. ");
INSERT INTO kmo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ju ma yechi Pasova nokusha nedii bana bana tar. ");
INSERT INTO kmo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas riita mey maka hecharek her nokwapa nokwapa mima ma ye riitak yatari, rii Pilip riina eecha wor: “Nopa aboboy siitan tokochi diita eyey ma mima yenya havakiita?” ");
INSERT INTO kmo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Rii Pilip riina otii heken eena wor. Rii her riita otiik tawa yon rii her. ");
INSERT INTO kmo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip rii awasen eecha wor: “Nota 200 dola tokona gey jecha yuwa ma sakapa kiki siikiitawak?” ");
INSERT INTO kmo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Akar disaipel por, Endru, Saimon Pita riiti kumwoy, rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hadiiyey yikapwa por diik tawey, rii gey yokotapa heechi tawak, emiyep upurus eecha heechitu. Wowey, kapo apa jecha yuwa ma sakapa kiki siikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Worek, Jisas rii eecha wor: “Eeta ma mima yenya na wochinak sa hey yi.” Eeta eem nokwapa nokwapa wohijaka eecha tar. Eeta yir ma ye 5,000 ma eecha tar. ");
INSERT INTO kmo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yecha yirek, Jisas rii God riina woshi eechi geyen yeechi yichar ma yenya homachi hapwoy pakar. Worek, rii emiyep piiren eechaba otiibar. Yenya hari ye eeta kiki siir. ");
INSERT INTO kmo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Worek, ari kiki siirek, rii disaipel yenya wor: “Aboboy kaw tawey, na yaya podat eemek yopo yichi. Iipa kaw wurubu yarebokiita.” ");
INSERT INTO kmo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Worek, ye eyey yopo yicharek, bali gey chipen wasiihaya kwo yokotapa woyichi yichir. Eeta ma ye ari kiki siirek, kaw eechaba tar. ");
INSERT INTO kmo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Worek, eeta ma mima ye riita eecha otii mirakel herek ye eecha wor: “Eeta siiken diita piirapet rii diita nosapek yar!” ");
INSERT INTO kmo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas rii heri, yecha riina neekichi ye i aka tabo yima heken otiitar. Worek, riita kawka eena heechi kwowuk saniga yo ir. ");
INSERT INTO kmo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Hogo nedii siirek, Jisas ri disaipel ye i pak ye i jabiir yeechi Kapaneam akamak iken ichari, nobok niy siirek Jisas rii yen saka i hecharek. ");
INSERT INTO kmo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Worek, harapa sowa yarek, hisaw uku boro sokwar. ");
INSERT INTO kmo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Worek, yecha jabiiren eyika ichari 2 mail-3 mail tarek, ye her Jisas rii eeta pa hek how irek, i jabiirek bana bana siirek, disaipel ye hechi akiitar. ");
INSERT INTO kmo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Worek, Jisas rii yenya eecha wor: “Dii eeta ada yato! Opoche akiitanakech.” ");
INSERT INTO kmo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Worek, yecha iken otiitar eemek gayer. ");
INSERT INTO kmo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iy nedii eeta ma ye eeta pagiireba yepak i tar. Tarek, ye heri jabiir podateba woy tar. Ye her Jisas rii eeta disaipel yechi jabiirek ikasakech. Disaipel ye jabiirek Jisas riina heechi ir. ");
INSERT INTO kmo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Worek, akar jabiir, Taibirias yechi jabiir, ya eeta ma mima yecha geyen yi ar eemek, Harapa riita God riina woshiatar eemek, eeka ya gayer. ");
INSERT INTO kmo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eeta ma mima ye Jisas riina disaipel yechaka eecha hipurek, yecha jabiirek i ye irek Kapaneam akaman Jisas riina yesha heken eena ir. ");
INSERT INTO kmo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Worek, ye riina yeshaniga pagiireba yepak her. Herek, ma mima ye riina woher: “Tisa, mii siitiiyekega yar?” ");
INSERT INTO kmo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisas rii yenya awasen eecha wor: “Eeta siiken woy ada kwona wocho: kwo saka eeta mirakelen ya heren kwo ana ya yesha hek yawak. Yaho. Kwota eeta geyen ari biidiirek, eena kwo ana yesha hek yawa. ");
INSERT INTO kmo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kwo opoche kwopa siitii tawa aboboyen yaken otiitanakech. Yaho. Kwo na eechaba eechaba tawa ma yechi aboboyen yaken gegi ya ta. Ma Yikapwa riipa eeta yikadey aboboyen kwona hakiita. Eeta Apoko God riita riina otii yon riiti hik har. ");
INSERT INTO kmo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Worek, ye riina woher: “Nopa kapo shecha otiinak, God riiti yon nopa otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisas rii yenya awasen eecha wor: “Diita yikadey yon God riita kwota otiiken gegiyato: riita heechirek yar ma riina na hiki siitiichicha.” ");
INSERT INTO kmo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Worek, ye riina wor: “Boy mey mirake boboyen otiinak nota miina hiki siitiichikiita? Mii kapo boyen otiikiita? ");
INSERT INTO kmo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Noti wayega ye manan me biish tar eemek eeka atar. Mashi keyir maji eecha wocho: ‘Rii hevenek tar geyen yenya harek ar.’” ");
INSERT INTO kmo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Worek, Jisas rii yenya eecha wor: “Ada kwona maji siiken wocho: Moses riita kwona hatar geyen ii hevenek ya geyekasakech. Yaho. Eeji Apoko riita hevenek tawa gey siikenen kwona hato. ");
INSERT INTO kmo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God riita ha tawa gey sii diitata: rii heven heechi ya sakari diita nosapek tawa man yesokwa yichitu.” ");
INSERT INTO kmo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Worek, ye riina eecha wor: “Harapa Ma, diita geyen nona na eechaba eechaba ha ta.” ");
INSERT INTO kmo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisas rii yenya awasen eecha wor: “Ada eeta yesokwa yichi tawa gey. Eeta ma rii adak yaney, riipa aboboy eecha hakasakech. Eeta ma rii ana hiki siitiichinyey, riipa borowaga reekasiikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Wowak, ada kwona wor: kwo ana heri, kwo ana hiki siitiichikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Eyey ma miman eeji Apoko rii ana hari, yepa adabak yakiita. Ma adak yaney, anapa saka yen magiirechichi otii poyekiitawak. ");
INSERT INTO kmo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ada heven heechi ya sakari, saka ada hiki tawa abon otiik yarek. Yaho. Ana heechirek yar Apoko riiti inyakak tawa boboyeban otiiken yar. ");
INSERT INTO kmo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ana heechirek yar Apoko riiti inyakak tawa boboyen ada diina otiitaken eyey ma miman rii ana hari, ada por heechikasakech. Yaho. Hamak tawa nedii anapa yenya eyey yesokwa yichikiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dii eeta eeji Apoko riiti inyaka: eyey ma ye Yikapwa riina herin hiki siitiichichaney, yepa eechaba eechaba takiita. Eeta yikadey ma yen hamak tawa nedii yanak, anapa yen yesokwa yichakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisas rii mashi eecha worek, “Ada eeta hevenek taren ya sakar gey.” Eena Ju ma ye riina ow maji awasen awasen batar. ");
INSERT INTO kmo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Eena ye eecha wor: “Dii boy Josep riiti yikapwa, Jisas. Nota riiti nokwapa apokwon hecho. Boyewak rii eecha wocho ada hevenen heechi ya sakar?” ");
INSERT INTO kmo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas rii yenya eecha wor: “Opoche kwotaba maji awasen awasen batanakech. ");
INSERT INTO kmo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ana heechirek yar Apoko riita ma poren yeechi yayanan siiney, iipa ma saka adak yakiitawak. Eecha otiiney, ada hamak tawa nediik ada riina yesokwakiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Eeta piirapet yecha keyir: ‘God riipa eyey man pokiitakiita.’ Eyey ma ye Apoko riiti majin meeji tawey, riiti pokii tawamajin meejitawey, yepa adak yakiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ma por Apoko riina hekasakech. Yaho. Ma podat riitak eecha taren yari, riitaba her. ");
INSERT INTO kmo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ayo. Ada kwona maji siikenen wocho: Ma por rii ana hiki siitiichinyey, riipa eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ada eeta eechaba eechaba takiitawa gey. ");
INSERT INTO kmo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mashi mashi kwoti yeyi wagega ye me biish tar eemek manan atarek, ye ha hamar. ");
INSERT INTO kmo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wowak, gey hevenek ya sakarin ma yecha eena aney, yepa hakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","An eechaba eechaba tawa gey an hevenen heechi ya sakar. Ma por riita diita geyen aney, rripa eechaba eechaba takiita. Diita gey ada riina haney, ii eeta eeji maba omu. Ada eeta boboyen hanak diita nosapek tawa ma yepa eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Worek, Ju ma ye eena meejirek, maji awasen awasen batar. Ye eecha wochar, “Boyega kata ma eecha wocho riiti maba omun nona hanak akiita?” ");
INSERT INTO kmo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisas rii yenya eecha wor: “Ada kwona maji siikenen wocho: Kwo Ma Yikapwa riiti maba omun anan siiney riiti pin anan siiney, kwo eechaba eechaba tawa boboy takasakech. ");
INSERT INTO kmo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma ye eeji maba omun atawey, eeji pin atawey, yepa eechaba eechaba tanak, hamak tawa nedii yenya ada yesokwa yichikiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Eeji maba omu sii eeta aboboy siiken tawa. Eeji pi sii eeta uku kepi tawa. ");
INSERT INTO kmo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma ye maba omu eejin aney, eeji pin aney, riita eeji wok tawak, ada riiti wok tawa. ");
INSERT INTO kmo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eechaba eechaba tawa Apoko riita ana heechirek yar. Riita tawak, ada eena eechaba tawa. Eecha tawaga, ada otiitawak, ma ye ana aney, riipa eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Diita gey sii hevenek taren heechi ya sakar. Sii mashi wayega yecha eechi har geyega eecha takasakech. Yaho. Ma diita geyen aney, iipa eechaba eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas riita Kapaneam lotu akak yenya yopo yichi diita majin pokii tar. ");
INSERT INTO kmo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Riiti nokwapa nokwapa disaipel ye diita majin meejichi eecha wor: “Diiti maji hapaga maji. Nopa kapo boyega shecha hikitakiita?” ");
INSERT INTO kmo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas rii riiti inyakak mayama her riiti disaipel eena maji awasen awasen batar. Worek, riita yenya eecha wor: “Diita maji sii boy kwoti inyaka wopun kapasek otiiwa? ");
INSERT INTO kmo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wowak, kwota henyak, Ma Yikapwa riita yar nobok kawka heechi inyey, kwopa kapo shecha hikikiita? ");
INSERT INTO kmo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spirit riita man eechaba eechaba kepi ta boboyen hato. Maba omu sii nona kaw kiyatayekasakech. Diita majin ada hatawey eeta Spirit, eeta eechaba eechaba takiitawa boboy. ");
INSERT INTO kmo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wowak, ma kaw kwotaka tawey, ye hiki siitiichikasakech.” Mashi mashi nediik Jisas rii her ma riina hiki siitiichinyan siiri. Rii hebar ma por riina yabu pi ma siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Rii kawka eecha wor: “Eena ada kwona eecha wor, Apoko riita otiichinyan biish siiyega, ma por riipa saka adak yakiitawak.” ");
INSERT INTO kmo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eeta maji worek, eena nokwapa nokwapa disaipel ye riina heechi irek, riina kawka sumowukasakech. ");
INSERT INTO kmo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Worek, Jisas rii 12 disaipel yenya wor: “Kwo boy kapo ana heechi ibakiita?” ");
INSERT INTO kmo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Worek, Saimon Pita rii awasen eecha wor: “Harapa Ma, nopa namak ikiita? Eechaba eechaba takiitawa maji eeta miitaka eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nota hiki siitiichichu no hecho mii eeta God riiti Holi Ma.” ");
INSERT INTO kmo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisas rii awasen eecha wor: “Ada boy 12 kwona hisiir? Wowak, por kwoti nediik tawey, rii kapasek spiriteka eecha tawa!” ");
INSERT INTO kmo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Rii Judas, Saimon Iskeriot riiti yikapwa, riina eecha wor. Diita ma Judas rii Jisas riina yabo pi man ye i sawor. Rii yechi nediik 12 tar ma. ");
INSERT INTO kmo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Worek, Jisas rii Galili yepak chishi ir. Rii Judia nosapek inyan yuyar. Juda ma yecha riina sowakwoken otiitarek, eena ikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Eeta nedii Ju ma yecha yepaba akak nokusha ar. ");
INSERT INTO kmo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Worek, eena riiti kumwoy ye riina eecha wor: “Na diina heechi. Judia nosapek i miita otii tawa yon otiinak, mi disaipel ye sa hehar he. ");
INSERT INTO kmo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma por rii riiti hin geenyek yesokwaken otiiney, riipa saka boboyen veenyi eemek otiikiitawak. Eeta boboyen otiiken otiiney, na geenyik siitii ma mima yechi misomak otiitanak, ye sa hehar hecha.” ");
INSERT INTO kmo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jisas riiti kumwoy ye riina hiki siitiichi kasakech. ");
INSERT INTO kmo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Eena Jisas rii yenya eecha wor: “Eeji nedii saka yatawak. Wowak, apa kowti nediibak tawa. ");
INSERT INTO kmo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Diita nosapek tawa ma mima ye kwona yabu pi ma takasakech. Ye adaban yabu pi ma tawa. Ada yecha otii tawa kapasek boboyen ada kwodii wochawak, eena ana yabu pi ma tawa. ");
INSERT INTO kmo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kwotaba na i nokusha a. Wowak, eeta nokusha a tawa nedii ada apa ikasakech. Eeji nedii saka yatawak.” ");
INSERT INTO kmo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Rii yen eecha wochi rii Galili nosapek tar. ");
INSERT INTO kmo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Worek, ri kumwoy ye nokusha ak irek, Jisas rii komas sumo ibar. Wori, rii geenyek ikasakech. Rii veenyichi ir. ");
INSERT INTO kmo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Eeta Ju ma ye noku sha atar nediik riina yeshar. Ye woher: “Eeta ma rii siitak tawa?” ");
INSERT INTO kmo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eyey ma mima ye nokwapa nokwapa maji batar. Kaw ye eecha wor: “Rii ma kepi.” Kaw ye eecha wor: “Rii eyey ma miman woshepiito.” ");
INSERT INTO kmo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wowak ye Ju ma yenya akiirek, ma por rii geenyik yesokwa bakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nokusha a hamak otiitar nediik Jisas rii harapa lotu aka wok iyar maji pokiitar. ");
INSERT INTO kmo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Worek, Ju ma ye i hiki ya hikichi woher: “Rii siitak otii her? Riita i maji pokiikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas rii awasen eecha wor: “Ada diita pokiitawa maji sii eejikasakech. Dii eeta ana heechirek yar God riiti maji. ");
INSERT INTO kmo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ma por rii God ri inyakan sumowutaken hikitaney, diita ada sawo tawa maji siiti mun hekiita. Riipa hekiita ada God riiti hin, eeji hin maji pokiitu. ");
INSERT INTO kmo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma por rii riiti inyakak tawa majin eena sawo tawey ii rii riiti hin mayama sobo yesokwato. Ma por rii heechirek yar ma riiti hiban yesokwataney, ii rii eeta nagwa nagwa nobok ichu. Woshepii tawa boboy eeta ma riitaka takasakech. ");
INSERT INTO kmo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Mashi Moses rii kwona lon har. Wowey, na por kwoti nediik tawey, rii Moses riiti lon sumowukasakech. Wowak, boyewak kwo ana sowakwo haken otiito?” ");
INSERT INTO kmo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eeta ma mima awasen riina eecha wor: “Kapasek spirit eeta miitaka eecha tawak, namey mak miina pi sowakwok otiito?” ");
INSERT INTO kmo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas rii awasen yenya eecha wor, “Ada yo podaten otiirin, kwota ana i hiki ya hikir. ");
INSERT INTO kmo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses rii tasiikasakech. Kwoti wayega yecha otiitar abo. Kwota eecha otiitawey, kwota akamak sii tawa nediik, kwo yikapwa maban hichu. ");
INSERT INTO kmo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wowak, kwota yikapwa maban akamak sii tawa nediik hichawak, ii kwo Moses riiti lon reekiinan siiney, ada eechaba akamak sii tawa nediik ma poren otii kepi siiney, boyewak kwo ana kwotayeto? ");
INSERT INTO kmo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Opoche kwo kwoti miyik shebo shebo homachichanakech. God riiti misomak no geenyik homachicha.” ");
INSERT INTO kmo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem akamak tar ma mima kaw ye eecha wor: “Diita ma riina yecha kapo pi pi hak? ");
INSERT INTO kmo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na he! Rii geenyik kwodii wo majin sawotawak, ma riina majikasakech! Kapo harapa ma ye hecho rii eeta Kraist? ");
INSERT INTO kmo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wowak, nota diita ma riiti akama siikenen hecho? Kraist riita diika yanak, riiti akama ma ye hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas rii harapa lotu akak tarek, rii yenya uwaba mukuchitar: “Kwo boy eeji heechi yar eemen hebato? Wowak, ada keena saniga yakasakech. Ana heechirek yar Apoko riita otii tawa boboy riita siiken boboyeban otiito. Kwo riina hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Adaba saniga riina hecho. Riita ana wochirek, an riina heechi yar.” ");
INSERT INTO kmo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Worek, ye eena riina pok jiken otiir. Wowak, eena ma ye riina tapa neeki hekasakech. Riiti nedii saka yatarek. ");
INSERT INTO kmo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wowak, nokwapa nokwapa ma mima ye riina hiki siitiichichar. “Kraist riita diika yanak, rii kapo otiina mirakel diita ma riita otiitaweyn dagiir poyekiita?” ");
INSERT INTO kmo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Eeta Perisi ma yecha meejirek, eeta ma ye Jisas riina diita yikadey majin ba ye i tar. Worek, yecha harapa nediik tar ma yechaka ow ana pichar ma yenya heechirek Jisas riina poko jiken yar. ");
INSERT INTO kmo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Worek, Jisas rii eecha wor: “Ada kwotaka ameda teechi anapa heechi ana heechirek yar ma riitak awasen ikiita. ");
INSERT INTO kmo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Inyak, kwopa ana yesha taney, kwopa saka hekiitawak. Kwopa sakapa ada ikiitawa eemen ikiitawak.” ");
INSERT INTO kmo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Eena Ju ma ye eecha wor: “Riipa kapo siitak inyak nopa riina saka hekiitawak? Kapo riipa noti ma kaw Grik nosapek i eeka siinak, yenya maji pokiitakiita? ");
INSERT INTO kmo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Rii eecha wocho: ‘Kwota ana heken yeshataney, kwopa ana saka hekiitawak! Rii kawka eecha wocho: ‘Ada inya eem kwopa sakapa yabakiitawak.’ Diita yikadey maji si mu, boy?” ");
INSERT INTO kmo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Diita nokusha a tar harapa nedii sii eeta hamak tawa nedii. Diita yadiik Jisas rii siita yenya harapa ayak eecha wor: “Ma ye ukun borowagii reekii siiney, ii sapa adak yanak, adapa eechaba eechaba tawa uku kepin hanak, riipa akiita. ");
INSERT INTO kmo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mashi keyir majik wori, ‘Ma por rii ana hiki siitiichichaney, eechaba eechaba tawa uku siipa riiti biik i takiik siichi gwoyeechi i anadii man kiyatayebakiita.’” ");
INSERT INTO kmo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ii Spiriten eena bar. Hiki siitiichichawa ma yepa yataken eena bar. Eeta nedii Spiriten hakasakech. Eeta nedii Jisas rii hadabas boboyen saka ya tarek. ");
INSERT INTO kmo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ma kaw ye eeta majin meejirek, ye eecha wor: “Eeta siiken diita ma rii eeta yaken otii tawa piirapet.” ");
INSERT INTO kmo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Anadii ma ye eecha wochar: “Ka eeta Kraist.” Wowak, ma kaw eecha wochar: “Kapo Kraist rii Galili nosapek sokwachi yaken otiito? ");
INSERT INTO kmo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mashi keyir maji sii eecha wocho: Kraist rii Devit riiti yimana riipa Betlehem akamak yakiita. Diita akama eeta Devit riiti akama.” ");
INSERT INTO kmo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eena ma mima ye reekiichi i ya ya siir. ");
INSERT INTO kmo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma kaw ye riina poko jiken otiiri wowak, eeta ma ye riina tapa now neekihekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Worek, ow ana pichar ma ye heechi Ju ma yechi harapa ma Perisi yechaka awasen ir. Irek, ye eecha wor: “Boyewak kwosaka riina yeechi diika yayawak?” ");
INSERT INTO kmo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ow ana pichar ma ye awasen eecha wor: “Diita nosapek tawa ma por mashi saka kata ma riita batawa majiga batarek!” ");
INSERT INTO kmo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Peiisi ma ye awasen eecha wor: “Rii kapo kwona woshepii tawak, kwo eena woshepii hiki ye itu? ");
INSERT INTO kmo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kwo boy kapo meejito Perisi harapa ma Ju yechi harapa ma ye kapo boy Jisas riina hiki siitiichibato? Yaho. ");
INSERT INTO kmo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Eeta yikadey ma mima yecha Moses riiti lon hekasakech. Yecha tawey, God riitimisomak kiiriisiiposii kapasek maga eecha tawa.” ");
INSERT INTO kmo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Worek, Nikodimas rii yechi nediik tar. Diita ma rii mashi Jisas riitak ir ma. Rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Noti lo sii boy eecha wocho man nota shebo shebo yaya anasakiita? Yaho. Riita otii tawa abon na mapo hechi riiti majin meejichi komas yaya anasa.” ");
INSERT INTO kmo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ye awasen eecha wor: “Mii kapo Galili ma tabato: Mashi keyir majin na hehar kenyi he. Miipa hekiita piirapet por Galili nosapek sokwachi yakasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(-) ");
INSERT INTO kmo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Worek, eyey ma mima ye heechi yechi akak i ye yar. Worek, Jisas rii heechi Oliv Kwowuk yo ir. ");
INSERT INTO kmo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Worek, niyegak rii harapa lotu akak i yarerek, eyey ma mima ye yar riitak yopo wuchi yir. Yirek, rii yenya maji pokiitar. ");
INSERT INTO kmo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma pochi sii nobo anamesh rokotarek, Perisi ma lon maji pokiitar ma ye siina yeechi Jisas riitak ye i ma mima yechi mi somak siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Worek, ye Jisas riina eecha wor: “Tisa, diita mima sii nobo anamesh rokotarek, ye her. ");
INSERT INTO kmo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Noti Moses riiti lo eecha wocho, eeta yikadey miman nota papak raboto. Mii shecha hikitaney, ii na ba?” ");
INSERT INTO kmo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ye eecha wori, riina anasa nobon eena otiiheri, Jisas rii meejichi rii saka gamuchi yi nosapen tapamak keyir. ");
INSERT INTO kmo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yecha siitiitarek, riina wowo hecharek, rii awasen eecha wor: “Ma podar kwotaka tawey, kapasek boboyen biish tawey, riitaba sapa papa podar mapo rabo.” ");
INSERT INTO kmo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Worek, rii way kawka he gamuchi nosapen tapamak kawka keyir. ");
INSERT INTO kmo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ye eena meejirek, ye podar podar saya ir. Apoko saba tar me ye maporek, anadii ma ye yenya sumowuniga ir. ");
INSERT INTO kmo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Worek, Jisas rii siitii mima siina wor: “Mima, ye siitak iwa? Kapo ma por sakapa ninya anasakiitawak?” ");
INSERT INTO kmo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mima sii eecha wor: “Harapa Ma, makasakech.” Jisas rii eecha wor: “An eechaba ninya anasakasakech. Na i. Komas ni kapasek boboy kawka otiiksakech.” ");
INSERT INTO kmo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas rii yenya eecha wor: “Ada diita nosap haba. Ma ana sumowuney, riipa saka niyi kiyik chishikiitawak. Yaho. Riipa eechaba eechaba tawa hababak eeka takiita.” ");
INSERT INTO kmo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Worek, Perisi ye riina eecha wor: “Mii keena miiti majin mayama sawoto. Eecha sawotawak mi maji eena siikenekaskech.” ");
INSERT INTO kmo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Worek, Jisas rii yenya awasen eecha wor: “Ayo, ada mayama tayechi heema pakatawey, eeta siiken. Ada hecho ada heechi yar eem. Ada hecho ada ikiitawa eemen eena eeji maji eeta siiken. Wowak, kwo ada heechi yar eemen hekasakech. Ada awasen ikiitawa eemen hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kwo nosapek tawa ma anasatawaga eecha anasato. ");
INSERT INTO kmo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wowak, ada man anasaken otiiney, nagwa nagwa anasakiita. Adaba saniga takasakech. Ana heechirek yar Apoko rii adaka bana bana tawak, eena ada nagw nagwa anasato. ");
INSERT INTO kmo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kwoti lo eecha wocho: Ma upurus piiriita heemakiitana maji chegiibak siiney, piiriiti maji eeta siiken. ");
INSERT INTO kmo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ayo, ada keena mayama tayechi heemapakato. Wowak, ana heechirek yar Apoko rii ana eechaba heemapakachibato.” ");
INSERT INTO kmo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Worek, ye eena eecha wor: “Mi Apoko rii siitak tawa?” Jisas rii awasen eecha wor: “Kwo ana hekasakech. Eeji Apoko riina kwo hekasakech. Kwota ana heyega ii kwo waga eeji Apoko riina hebawa.” ");
INSERT INTO kmo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Rii diita majin mani yan heechitar aka wok siitii bar. Eeka Jisas riita harapa lotu akak yenya maji pokii tar. Ma por rii riina pokok jikasakech. Riiti nedii saka yatarek, eena poko jikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Rii kawka wor: “An ichu. Kwopa saka an kawka hekiitawak. Kwopa hanak, kwoti kapasek boboy siipa eechaba takiita. Kwota saka kiki siikiitawak, ada ikiitawa eem.” ");
INSERT INTO kmo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Worek, eena Ju ma ye eecha wor: “Rii eecha wocho, ada ichawa eemen kwopa saka kiki siikiitawak. Diita maji si mu kapo riita mayama pi sowakwok otiito?” ");
INSERT INTO kmo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisas rii awasen yenya eecha wor: “Kwo kuruk taren yar. Ada howuk taren heechi yar. Kwo diita nosap ma. Ada diita nosapek makasakech. ");
INSERT INTO kmo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eena ada kwona wor: kwopa hanak, kwi kapasek boboy eechaba takiita. Kwo diita Ma, ana, hiki siitiichinyan siiney, kwopa hanak, kwi kapasek boboy eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Worek, yuway riina awasen woher: “Mii nama?” Worek, Jisas rii yenay awasen eecha wor: “Ada diita ma kwona mashi wori. ");
INSERT INTO kmo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ada nokwapa nokwapa maji kwota otii tawa abon kwona bak otiito. Komas ada eeta boboyen anasakiita. Wowak, eeta ma riina heechirek yari, riita otii tawa abo sii eeta siiken. Ada riiti eyey majin meeji tawey, ada iiban ddita nosapek tawa ma mima yenya sawoto.” ");
INSERT INTO kmo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Riita yenya bari, rii Apoko riina bari, ye riina hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eena Jisas rii yenya eecha wor: “Kwota Ma Yikapwa riiti hin yesokwana nediik kwopa eecha hikikiita dii eeta ma riita. Wonyak, kwopa ana eecha hikichi saniga eecha otiikasakech. Eeta Apoko riita ana pokiitar majiban ada iiban kwona sawoto. ");
INSERT INTO kmo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ana heechirek yar Apoko rii adaka eecha tawa. Eechaba eechaba nedii ada riiti inyakak otiitawak, rii eena ana heechi ikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Rii eecha worek, nokwapa nokwapa ma mima ye riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Worek, Jisas rii riina hiki siitiichichar Ju ma yenya eecha wor: “Kwota ada pokii tawa majin hehar sumowutawey, kwo eeta eeji disaipel siiken. ");
INSERT INTO kmo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wonyak, kwopa maji siikeban hechakiita. Wonyey, kwo poko ji maga eecha takasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Worek, ye riina awasen eecha wor: “No Ebraham riiti neja. Nota nedii pochi anadii maka poko ji takasakech. Boyewak mii eecha wocho, ‘Kwota poko ji maga takasakech?’” ");
INSERT INTO kmo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas rii yenya eecha wor: “Ada kwona maji siikenen wocho: eyey ma ye kapasek boboyen otiitawey, kapasek boboy sii eeta riina pokoga jichu. ");
INSERT INTO kmo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Poko ji yo otii tawa ma rii akak saka eechaba eechaba takiitawak. Yaho. Yikapwa rii eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wowak, eeta Yikapwa rii kwona pokon heema jinyey, eeta heema siiken jiwa. ");
INSERT INTO kmo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Ada hecho kwo Ebraham riiti neja. Wowey, eeji maji kwoti inyakak takasakech eena kwo ana sowakwoken otiito. ");
INSERT INTO kmo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Diita boboy ana eeji Apokoriita mukuchirin eena ada sawoto. Wowak, kwo kwoti Apokok sawo mukuchichrin, eena kwo otiito.” ");
INSERT INTO kmo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ye riina awasen eecha wor: “Noti apoko eeta Ebraham.” Jisas rii awasen eecha wor: “Kwota Ebraham riiti neja tawey, ii kwo riita otii tawabaga eechaba otiito. ");
INSERT INTO kmo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ada God riita har omutiik majin meejirin eetaban ada otiitar. Wowak, kwo ana sowakwoken otiito. Diita hikichi otii tawa yon Ebraham rii eechaba otiikasakech! ");
INSERT INTO kmo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kwo kwoti apoko riita otiitawa aboga eecha otiito.” Ye riina awasen eecha wor: “Nota nobok ya yikapwakasakech. Nowi Apoko podareba, eeta God.” ");
INSERT INTO kmo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Worek, Jisas rii eecha wor: “God rii kwoti apoko taney, ii kwo waga ana rukusiito. Ada God riitaka taren heechi ya diita eechaba tawa. Ada sobo yakasakech. Riita ana heechirek an yar. ");
INSERT INTO kmo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Boyewak kwo saka eeji majin hehar hikitawak? Kwo eeji majin meejinan yuyatawey, kwo mabiya giito. ");
INSERT INTO kmo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Kwo kwoti apoko, Gaba, riiti yikapwa. Eecha tawak, kwo eena apoko riiti nobon sumowutu. Mashi mashi nedii rii man pi hatar. Ii rii saka nobo kepin sumowu tarek. Maji siiken riitaka eecha takasakech. Rii woshepii ma taweym, rii woshepii tawa boboy yechi apoko. Eena rii woshepii tawak, rii riiti nobobak ichu. ");
INSERT INTO kmo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ada kwona maji siikenen sawo tawey, kwo eena hiki siitiichikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Namey ma por kwotaka riitapa keena adaka tawa kapasek boboy pochin hechi kwona wokiita? Wowak, ada maji siikenen sawotawey, boyewak kwosaka ana hiki siitiichichawak? ");
INSERT INTO kmo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Eyey ma ye God riiti ma tawey, ye riiti majin meejito. Kwo God riiti makasakech eena kwo eeji majin meejikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ju ma ye Jisas riina eecha wor: “Nota maji siikenen bato: mii eeta Sameria ma. Spirit kapasek miitaka eecha tawa.” ");
INSERT INTO kmo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas rii awasen eecha wor: “Kapasek spirit adaka eecha takasakech. Yaho. Ada eeji Apoko riiti hin yesokwatawak, kwo eeji hin dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ada mayama eeji hinotii yesokwakasakech. Ma por rii tawey, riita eeji hin yesokwachi hehar siiken anaseechitu. ");
INSERT INTO kmo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eeta ada kwona siiken majin wocho: Ma por eeji majin sumowu taney, riipa saka eechaba eechaba hakiitawak.” ");
INSERT INTO kmo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Worek, Ju ma ye eecha wor: “Nota he hamawa mii spirit kapasekeka tawa. Ebraham rii harek, piirapet rii habar. Wowak, mii eecha wocho: “Ma por rii eeji maji hehar sumowuney, riipa saka hakiitawak. ");
INSERT INTO kmo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Iiboy mii noti wayega Ebraham riina dagiir poyetu. Rii har. Piirapet ye habar. Mii miita mayama otiiniga namaga siiken otiito?” ");
INSERT INTO kmo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Worek, Jisas rii awasen eecha wor: “Ada eeji hin mayama yesokwataney, iipa kubuchey siikiita. Wowey, eeji Apoko rii eeji hin yesokwato. Wowey, kwo eecha wocho: ‘Ka noti God!’ ");
INSERT INTO kmo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wowey, kwo riina hekasakech. Ada, adaba riina hecho. Ada eecha wonyey, ‘Ada riina saka hechawak’, woney, iipa ada kwota woshepiibak tawa maga eechaba siikiita. Wowak, ada riina hehar hechawak, ada riiti majin hehar sumowutu. ");
INSERT INTO kmo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Kwoti wayega Ebraham rii eeji nediin heri, riita kwoya woy hikitar. Riita herek, ri inyaka kwoya hikir.” ");
INSERT INTO kmo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Worek, eena Ju ma ye eecha wor, “Mii 50 sukwiya takasakech. Eecha tawey, mii boy Ebraham riina her?” ");
INSERT INTO kmo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisas rii awasen eecha wor: “Eeta siiken, ada kwona wocho, mashi Ebraham riina yimowunan biish tar nedii ad tabatar.” ");
INSERT INTO kmo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Worek, Ju ma ye riina papak raboken otiirek, rii veenyichi lotu akan heechi saka ir. ");
INSERT INTO kmo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas rii chishi icharek, i her miy kiitiir ma poren. Heri nokwapa siita yimowurek, kiitiir. ");
INSERT INTO kmo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisas riiti disaipel ye riina woher: “Kapo namey kapasek boboy miy kiitiir? Kapo diita ma riiti, kapo riiti awi, eepi piiriiti kapasek boboy?” ");
INSERT INTO kmo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Worek, Jisas rii awasen eecha wor: “Diita ma riiti kapasek boboy riiti awi eepi piiriiti kapasek boboy riiti miyin kiitiikasakech. God riiti hapaga tawa boboyen ma yechi misomak geenyik otiitaken eena riiti miy kiitii mukuchir. ");
INSERT INTO kmo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Apa nedii nota na ana heechirek yar God riiti yon hapaga siichi otii ta. Apa yadii tawa. Niy sii yak otiito. Sii yanak, ma yo otiikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ada diita nosapek tawa nedii an diita nosap haba.” ");
INSERT INTO kmo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Rii eecha wochi rii sogwiyan piichi nosapeka neekijeeborechi eeta ma riiti miyik neekir. ");
INSERT INTO kmo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Worek, riin eecha wor: “Miita na i Siloam pak uku yeetii.” (Diita hi dareboyechi eecha wocho, heechinak sa i.) Worek, eeta ma rii i uku yeechi yari meyimaka her. ");
INSERT INTO kmo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Riiti akama ma ye mashi hecharek mani yan somak wochar ma ye wopoy paka her, “Kapo kata ma rii yiniga yan somak wochar ma?” ");
INSERT INTO kmo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma kaw ye eecha wor, “Ayo, dii eeta ma riita.” Anadii ma ye way eecha wor: “Dii eeta ma riitaga eecha hewa.” Worek, eeta ma rii eecha wor: “Diitata ada.” ");
INSERT INTO kmo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Worek, ye riina woher: “Boyewak mi miy kepi sowa?” ");
INSERT INTO kmo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Worek, rii awasen eecha wor: “Diita ma riina Jisas habato riita nosapen yeechi ukukajeeborechi eeji miyin apo yichi eecha wor, ‘Miita na i Siloam paka uku yeetii poy. Eena an i uku yar. Wowak, eeji miy eeta kepi siirek ada mey maka hecho.” ");
INSERT INTO kmo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Worek, ye awasen eecha woher, “Eeta ma rii siitak tawa?” Rii eecha wor: “An hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Worek, miy kiitii tar ma riin yeechi Perisi yechak ye ir. ");
INSERT INTO kmo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Eeta nedii Jisas rii chiren yeechi miyin apoyer nedii sii eeta akama sii tawa nedii. ");
INSERT INTO kmo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eena ye riina kawka woher, “Mi miy ii shecha kepi sowa?” Worek, rii yenya eecha wor: “Rii chiren yeechiniga eeji miyik apoyechuwak, ada uku yawak, eeji miyin diita mey maka hecho.” ");
INSERT INTO kmo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Worek, Perisi akamak siitawa nedii reekito.” Worek, anadii ma ye eecha wor: “Boyega diita kapasekeka tawa ma rii boyega diita harapa yo mayakan otiito?” Worek, ma ye piikachi saniga saniga siir. ");
INSERT INTO kmo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Worek, Perisi ye eeta ma riin kawka woher: “Diita ma rii miiti miyin otii kepi sowey, mii riin shecha wocho?” Rii awasen eecha wor: “Rii eeta piirapet.” ");
INSERT INTO kmo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Eeta siiken, mashi diita ma rii ri kiitiitari komas rii her. Wori, Ju ma ye eena hikikasakech. Worek, eena ye miy kiitiir ma riiti awi eepi piiriina uwar. ");
INSERT INTO kmo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yecha piiriina woher: “Dii kapo kichi yikapwa? Ki eecha wocho, yimowur nediik miy eeka kiitiir? Eecha tawey, boyewak rii apa kata mey maka hecho?” ");
INSERT INTO kmo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Worek, awi eepi piir awasen eecha wor: “Ayo, sicha hecho sichi yikapwa. Riina yimowur nediik eechaba miy kiitii tar. ");
INSERT INTO kmo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Apa riiti miy mey maka hecho wey, ii si hekasakech. Nama riiti miyin tagwawa. Ii eechaba si hekasakech. Kwota na riina wohe. Rii eeta harapa siir. Riipa kwona sawo mukuchikiita!” ");
INSERT INTO kmo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Riiti awi eepi piir Ju ma yenya akiirek, eena eecha wor. Ju ma ye geenyik eecha worek, ma por rii Jisas riina eecha wochaney, rii eeta Kraist, iipa riina lotu akak otii poyikiita. ");
INSERT INTO kmo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eena awi eepi piir eecha wor: “Riina na wohe. Rii eeta harapa siir!” ");
INSERT INTO kmo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Worek, komas nedii ye miy kiitiir ma riina eecha wor: “Miita na God riiti hin yesokwa ta. No hikitu diita ma rii kapasekeka tar ma.” ");
INSERT INTO kmo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma rii awasen eecha wor: “Rii kapo kapasekeka tawa ma, kapo biish. An saka hechawak. Boboy podaten an hecho, mashi eeji miyin kiitiitari apa an hecho.” ");
INSERT INTO kmo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Worek, ye riina woher: “Shecha otiirek, mi miyin tagwachir?” ");
INSERT INTO kmo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rii awasen yenya eecha wor: “Ada kwona ba hamar. Kwo meejikasakech. Boyewak, kwo kawka meejiken otiito? Kwota eechaba riiti disaipel siibaken hikitu?” ");
INSERT INTO kmo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Worek, ye riina wosoboyer. Eecha wor: “Miitaba saniga riiti disaipel. No Moses riiti disaipel. ");
INSERT INTO kmo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nota hikitu God rii Moses riina maji har. Eeta ma rii siitak taren yar? Nota hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eeta ma rii awasen yenya eecha wor: “Diita henebarabo tawa boboy siiken. Rii eeji miyin tagwari, kwo riita heechi yar eemen hekasakech! ");
INSERT INTO kmo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","No hikitu God riita kapasekeka tawa ma majin meejikasakech. Wowak, ma ye God riiti hin yesokwotawey, riina sumowutawey, rii yenya meejito. ");
INSERT INTO kmo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mashi mashi nedii apa nedii diita maji takasakech: Ma por miy kiitiitarin ma por rii tagwachirek her. ");
INSERT INTO kmo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God riita diita man heechinak yanan siiyega, rii waga diita yikadey boboyen saka waga otiiwak.” ");
INSERT INTO kmo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ye riina awasen eecha wor: “Miiti awi sii miina kapasek boboyeka eecha yimowurek, mii kapasekeka tawa ma siir. Mii boy nona pokiiken otiito?” Ye eecha wochi riin otii poyir. ");
INSERT INTO kmo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas rii ma riina otii poyi majin rii meejir. Meejirek, rii yesha hechi wor: “Mii boy kapo Ma yikapwan hiki siitiichichu?” ");
INSERT INTO kmo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma rii awasen eecha wor: “Harapa ma, diita ma rii kapo nama? Miita ana sawonak, anapa riina hiki siitiichikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas rii eecha wor: “Mii riina her. Riina herek, miitaka apa maji bato.” ");
INSERT INTO kmo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma rii meejichi eecha wor: “Harapa Ma, ada hiki siitiichichu.” Worek, rii yatii bogok putiichi God riiti hin yesokwatar. ");
INSERT INTO kmo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas rii eecha wor: “Ada diita nosapek yari man anasaken yar. Eena ma henyan biish tawey, yepa hekiita. Ma ye hechawey, yechi miy iipa kiitiikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Worek, Perisi ma kaw ye bana tarek, ye diita majin meejir. Worek, ye eecha wor: “No eechaba miy kiitiito?” ");
INSERT INTO kmo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas rii eecha wor: “Kwoti miy kiitii tawey, kwo kapasek boboyekasakech. Wowak, kwo eecha wocho: ‘Noti miy hecho.’ Eena kwi kapasek boboy sii eechaba tawa.” ");
INSERT INTO kmo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ada kwona maji siikiinen bato. Ma por rii sipsip yechi inyi nuburejak iyarenan siiney, anadii nobok iyareney, rii eeta hiyiya tawa ma. ");
INSERT INTO kmo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wowak, ma rii nuburejak iyare tawey, rii eeta sipsipen siitii kowu tawa ma. ");
INSERT INTO kmo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nubureja tagwachichawa ma rii nuburejan diita man tagwachichu. Wowak, eeta sipsip ye riiti ayan meejito. Rii riiti sipsip siiken yechi hin uwato. Rii yenya yeechi geenyik ye ichu. ");
INSERT INTO kmo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Geenyik ye ichawak, rii mapo tawak, riiti sipsip ye riiti ayan meejichi sumowutu. ");
INSERT INTO kmo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ye akar man sumowukasakech. Yaho. Ye heechi aka ichu. Ye anadii ma yechi ayan meejikasakech. Eena akii ichu.” ");
INSERT INTO kmo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas rii diita shiyi tawa majin bari, ye eeta maji mun hehar meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Worek, Jisas rii riina eecha wor: “Eeta siiken, ada kwona wocho ada eeta sipsip yechi nubureja. ");
INSERT INTO kmo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Eyey ma ye mashi kwotak yari, ye eeta hiyiya tawa ma. Wowak, eeta sipsip ye yechi ayan meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ada eeta nubureja. Ma por rii adak yanak nuburejak iyareney, God riipa riina awasen yakiita. Riipa iyaretanak, yasayatanak, iyeyatanak, aboboy atakiita. ");
INSERT INTO kmo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Hiyiya tawa ma rii sipsipen hiyik yatanak, sowakwoken, kapasekeban otiiken eena yato. Ada yatawey, ma yecha hehar tanak, God riiti boboy kepi takiikiisiiken eena ada yar. ");
INSERT INTO kmo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ada sipsipen siitii kowu tawa ma rii sipsipen yenya hachiken eena sayareto. ");
INSERT INTO kmo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma ya yon otii tawey, rii sipsipen siitii kowu tawa ma siikenekasakech. Riiti sipsipekasakech. Kwashik tawa asa yaney, riipa hechi akii ikiita. Wonyak, kwashika tawa asa ya sipsip yenya kikirechishinak, yepa heechi akii iyeyakiita. ");
INSERT INTO kmo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Diita ma rii ya yoban otiitawak, sipsip yen hehar hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ada sipsipen siitii kowu tawa ma kepi. Ada eeji sipsipen hechawak, eeta sipsip ye way ana hecho. ");
INSERT INTO kmo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ana Apoko riita hechawabaga, ada eeji sipsipen hikitu, yecha ana hikitu. Ada eeta sipsip yenya hachik otiito. ");
INSERT INTO kmo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eeji akar sipsip kaw tawey, ye diita inyik takasakech. Anapa yenya yayabakiita. Yepa eeji ayan meejikiita. Wonyak, yepa podateba sipsipek siinak, siiti kowu tawa ma podareba siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ada eeji sipsipen hachiken otiitawak, an komas saniyeechi kawka yakiita. Eena ana Apoko riita rukusiito. ");
INSERT INTO kmo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma por rii ana otiichinyak, hakasakech. Adaba saniga hikitu ada keena heechinak ma ye pi sowakwokiita. Ana otiichinyak ha hapaga boboyeka aneecha tawa. Diita maji eeji Apoko riita ada eecha otiiken har.” ");
INSERT INTO kmo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ju ma ye diita majin meejirek, piikachi saniga saniga hikitar. ");
INSERT INTO kmo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nokwapa nokwapa ma eecha wochar, “Kapasek spirit riitaka eecha tawak, rii beyito. Boyewak kwota riiti maji meejito?” ");
INSERT INTO kmo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wowak, ma kaw ye eecha wochar, “Dii spirit kapasek tawa ma riiti majikasakech. Boyega kapasek spiriteka tawey, rii miy dumu tawa man tagwachichu?” ");
INSERT INTO kmo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Noku sha atawa nedii pochik Jerusaem akamak niikiir yar nediik sokwar. Nokusha atawa nedii siiti hi Derikeshan. ");
INSERT INTO kmo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas rii harapa lotu akak Solomon riiti aka cheyek chishitar. ");
INSERT INTO kmo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Eeka tarek, Ju ma ye ya riina ya cheshenechi siitiir. Siitiirek, eecha woher, “Kapo yadii shasha miipa heechinak, noti inyakapa hikitawak no miina kowutu. Mii nona na geenyik ba. Mii kapo Kraist?” ");
INSERT INTO kmo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Worek, Jisas rii yenya awasen eecha wor: “Ada kwona maji ba hamari, kwo eena hikikasakech. Eyey yon ada eeji Apoko riiti hik otiitawey, ii eeta eeji hin yesokwato. ");
INSERT INTO kmo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kwota eeji sipsipekasakech eena kwo ana hiki siitiichikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eeji sipsip ye eeji ayan meejitawak, ye ana sumowutawak, ada yenya hecho. ");
INSERT INTO kmo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ada yenya eechaba eechaba takiitawa boboyen hanak, yepa saka hakiitawak. Yaho. Ma por sakapa eeji tapak tanan yakiitawak. ");
INSERT INTO kmo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Eeji Apoko rii yenya ana har. Rii hapaga bor tawak, eyey boboyen dagiir poyirek, ma por rii Apoko riiti tapak tanan yakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Adaka Apoko riitaka shi shichiba.” ");
INSERT INTO kmo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Worek, Ju ma ye papan yeechi riina raboken otiir. ");
INSERT INTO kmo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Otiirek, Jisas rii yenya eecha wor: “Ada kwona Apokoriiti nokwapa nokwapa yo kepin mukuchir. Ada boy mey yon otiirin kwo ana papak raboken otiito?” ");
INSERT INTO kmo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ju ma ye awasen eecha wor: “Miita yo kepin otiirin, nota eena miina papa rabokasakech. Miita God riiti hin wosoboyeto. Miita sobo ma tawey mii eecha wocho ada eeta God!” ");
INSERT INTO kmo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas rii awasen eecha wor: “Kwoti jeyek tawa lok God rii eecha wocho: ‘Kwo godega eecha tawa.’ ");
INSERT INTO kmo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","No hikitu eeta keyi tawa maji siipa siiken eechaba eechaba siikiita. Wowak, God riiti majin har ma yenya God rii goden habatar. ");
INSERT INTO kmo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wowak, Apoko riita ana hisiichi heechirek, an diita nosapek yar. Eena ada eecha wocho, ‘Ada God riiti Yikapwa.’ Kwo boyewak eecha wocho, ‘Mii God riina wohega maji bato?’ ");
INSERT INTO kmo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Ada eeji Apoko riiti yon otiinan siiyega, kwo eeji majin opoche hiki siitiichichanakech. ");
INSERT INTO kmo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wowak, ada riiti yon otiito. Kwota eeji majin hiki siitiichinyan yuyaney, ii na ada otii tawa yon hiki siitiichi. Kwo eecha otiiney, kwopa hehar hekiita: Apoko rii adaka tawak, an riitaka tawa.” ");
INSERT INTO kmo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Worek, ye riina poko jiken otiitari, rii yenya taviiyichi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Worek, Jisas rii heechi i Jodan pa giireba yepak ir. Iri, Jon riita man uku yeechi tar eemek iyarechi eeka siir. ");
INSERT INTO kmo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Siirek, nokwapa nokwapa ma mima ye riitak yar. Yari, ye eecha wor: “Jon rii mirakel pochi otiikasakech. Wowak, eyey boboyen diita ma riina bari, eeta siiken.” ");
INSERT INTO kmo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Worek, eeta em nokwapa nokwapa ma ye riina hiki siitiichichar. ");
INSERT INTO kmo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ma por haken otiitari, riiti hi Lasaras, Betani akamak tar ma. Betani eeta Maria Mata piiriiti akama. Maria sii Mata siiti kumwoy. ");
INSERT INTO kmo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Diita Maria sii mashi kwowa ya tawa ukun yeechi ye i Harapa Ma riiti masekiik gwotiichi kaw riiti yatiik bachir. Siiti medaya, Lasaras, rii haken otiitar. ");
INSERT INTO kmo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eena mowey piir Jisas riina maji wochirek ir. Iri, eecha wor: “Harapa Ma, miiti rukusii tar apoma rii haken otiito.” ");
INSERT INTO kmo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Worek, Jisas rii meejichi eecha wor: “Eeta yikadey hak otii tawa boboy sii ma hakasakech. Eeta hak otii tawa boboy sii God riiti hin yesokwaken eena yar. God riiti Yikapwa riiti hin yesokwaken eena yar.” ");
INSERT INTO kmo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas rii Mata siina, siiti kumwoy, Maria siina, Lasaras riitaka yenya rukusiitar. ");
INSERT INTO kmo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jisas rii Lasaras riita haken otiitar majin meejichi rii yadii upurus riita tar eemek kawka tar. ");
INSERT INTO kmo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Worek, rii riiti disaipel yenya eecha wor: “Kwo napa heechi Judia nosapek i.” ");
INSERT INTO kmo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Worek, disaipel ye awasen eecha wor: “Tisa, mashi Ju ma ye miina papak raboken otiiri. Mii boy eeta eemek kawka iku?” ");
INSERT INTO kmo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas rii eecha wor: “Kwo kapo eecha hikitu? Apa yadii podat 12 awa tawa. Ma yadiik chishi taney, rii saka sowakwoksakech. Rii diita nosap yaman hechi eeka chishitu. ");
INSERT INTO kmo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma rii niyik chishitaney, riipa saka sowakwokiita. Haba riitaka eecha takasakech eena saka sowakwokiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas rii eecha wochi kawka eecha wor: “Noti nareboy Lasaras rii wato. Rii watawey, ada i riina chey yesokwa yichikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Disaipel ye eecha wor: “Harapa Ma, riita wataney, riipa kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas rii hikir Lasaras rii eeta kiiriidiichir. ");
INSERT INTO kmo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Eena Jisas rii yenya geenyik kwodiiwor: “Lasaras rii ha hamar. ");
INSERT INTO kmo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","An saka riitaka eecha tarek, kwoti hin ada hikitawak, eena ada kwoya hikitu. Kwopa henyak, kwopa hiki siitiichikiita. Eena ada kwoya hikitu. No hawa riitaka ik.” ");
INSERT INTO kmo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas habatari, Didimas, rii eecha wor: “Na hawa i. Riitaka eecha habak!” ");
INSERT INTO kmo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisas rii i yarerek, rii i meejir, Lasaras rii tiiriimo supuk yadii dupura kapiira siir. ");
INSERT INTO kmo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani Jerusalemeka bana bana tar. Mail upurus tar. ");
INSERT INTO kmo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Piiriiti medaya harek, eena nokwapa nokwapa Ju ma ye ya Maria Mata piiriiti inyakan saboyeken eena yar. ");
INSERT INTO kmo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata sii Jisas riita ya majin meejirek, sii riina nobok jawoken eena ir. Worek, Maria sii akak yichar. ");
INSERT INTO kmo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata sii jawochi riina eecha wor: “Harapa Ma, miita diika teyega siichi medaya rii waga saka hawak. ");
INSERT INTO kmo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Apak ada hikitu miita God riina wohenya boboy riipa miina hakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Worek, Jisas rii awasen eecha wor: “Na medaya riina awasen yesokwakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata sii riina awasen eecha wor: “An hikitu riipa hamak tawa nedii eyey ma mima awasen saniyeechi yesokwana nedii rii sokwabakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas rii awasen eecha wor: “Yeechi otii saniyeechi yesokwa tawa ma diita ada. Eechaba takiitawa boboy diita ada. Ma rii ana hiki siitiichichaney, riipa haney, rii eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma rii tawak, ana hiki siitiichichaney, riipa hakasakech. Ni boy diina hiki siitiichichu?” ");
INSERT INTO kmo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Sii awasen eecha wor: “Harapa Ma, ayo. Ada hiki siitiichichu mii eeta Kraist, God riiti Yikapwa. Mii God riita nona mashi wotarek, yakiitawa ma.” ");
INSERT INTO kmo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata sii eecha worek, sii heechi awasen i siiti kumwoy siina veenyichi sawor. Sii siina eecha wor: “Rii nija yaken wohecho.” ");
INSERT INTO kmo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria sii eena meejichi sokwa ameya ir. ");
INSERT INTO kmo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas rii akama saka iyare tarek. Rii Mata siita riina i her eemebak eeka tar. ");
INSERT INTO kmo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sii sokwa irek, eeta akak tar ma ye Maria siina saboyetar ma ye siina hechi sokwa geenyik iyarer. Ye eecha hikir sii tiiriimo supuk yi keyataken ichu. ");
INSERT INTO kmo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria sii Jisas riita tar eemek iyar riina hechi sii riiti yatii jemuk yatii bogok putiichi riina maji eecha wor: “Harapa Ma, miita diika ya teyega, eeji medaya rii waga saka waga harek.” ");
INSERT INTO kmo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas rii her sii keyatarek, siitaka ir Ju ma ye keyabatarek, her. Worek, rii inyakapwa hikitarek bii nomuyatar. ");
INSERT INTO kmo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nomuyatarek, rii eecha wor: “Kwo siitak seechuwa?” Ye riina eecha wor: “Harapa Ma, na ya her.” ");
INSERT INTO kmo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Worek, Jisas rii keyar. ");
INSERT INTO kmo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Eena Ju ma yecha eecha wor: “Na he. Rii riina harapa rukusiitar.” ");
INSERT INTO kmo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Worek, ma kaw ye eecha wor: “Diita ma rii kiitii tawa miyin tagwa tawa ma. Rii boy saka Lasaras riita hak otiirin neeki dagiirerek siirek?” ");
INSERT INTO kmo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas rii kawka bii nomuyarek rii tiiriimok ir. Eeta tiiriimo supu papa hen kwotiir. Akar papa taken dasiipii paretar. ");
INSERT INTO kmo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Worek, Jisas rii eecha wor: “Kwota na tadii tawa papan tagwa.” Mata, har ma riiti mowey, sii eecha wor: “Harapa Ma rii hari, yadii dupura kapiira siir. Eena kwopa yato.” ");
INSERT INTO kmo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisas rii siina eecha wor: “Ada boy mashi ninya saka worek, nija hikisiitiichiyega ni waga God riiti boboy kepin hewa?” ");
INSERT INTO kmo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Worek, ye papan tagwar. Jisas rii neren mo hechi rii eecha wor: “Apoko ada woshi awey mii meejuwa. ");
INSERT INTO kmo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ada hechi, eechaba eechaba nedii ada miina wohechawey mii meejito. Ada diita ma yecha ya siitii ye i taweyn eena ada eecha wocho. Ye henyak, yepa hiki siitiichikiita, miita ana heechirek yar.” ");
INSERT INTO kmo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eecha wochi rii uwar: “Lasaras, na ya saya!” ");
INSERT INTO kmo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Worek, har ma rii sokwachi ya sayar. Ri yatii tapa siivatabik jichar. Misoma siivatabibak gamutar. Worek, Jisas rii eecha wor: “Rina na heemachinyak, sa sokwa i.” ");
INSERT INTO kmo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nokwapa nokwapa Maria siina heken yar Ju ma ye Jisas riita otiir boboyen heri, ye eena riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wowak, kaw ye heechi i Perisi ma yenya Jisas riita otiir boboyen sawo mukuchir. ");
INSERT INTO kmo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Worek, eena Ju opelen otiitar harapa ma ye, Perisi ma ye kaunsil ma yen woyayeechi yenya eecha wor: “Nopa kapo shecha otiikiita? Diita ma rii nokwapa mirakelen otiito! ");
INSERT INTO kmo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nota riina heechinak, riita eechaba otiitaney, eyey ma mima yepa riitaban hiki siitiichikiita. Rom ma harapa ma ye yanak, ye noti harapa lotu akan noti akaman kapasek otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Worek, yechaka tar ma por, riiti hi Kaiapas, rii opelen mapo otiitar harapa ma, rii eecha wor: “Kwo sobo hikitu. ");
INSERT INTO kmo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kwo boy eecha hikitu ma por riitaba ma miman hachiney, eeta kepi. Eyey Ju ma ye ha hamaney, eeta kapasek.” ");
INSERT INTO kmo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Riita bari, riiti inyakak saniga bakasakech. Yaho. Eeta sukwiya pochi rii opelen otii harapa ma tar. Eecha tarek, rii komas yak tawa boboyen eena wor. Eecha wor Jisas rii Ju ma yenya waga hachuwa. ");
INSERT INTO kmo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jisas rii waga Ju ma mima yechaban saka waga hachuwak. God riiti yikapwa ye eyey diita nosapek ta yey taweyn, yaya podabak yopo yichiken eena waga hawa. ");
INSERT INTO kmo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Worek, eeta nediik Ju harapa ma ye Jisas riina sowakwo majin tasiir. ");
INSERT INTO kmo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eena Jisas rii Juda nosapek geenyik chishikasakech. Rii eeta eemen heechi me biish tar eemek ir. Eeta akama sii hi Epraim. Rii eeta akamak riiti disaipel yechaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ju ma yechi Pasova noku sha a nedii bana siir. Eena nokwapa nokwapa akaman heechi iri Jerusalem akamak ir. Maban uku yeetii tawa abon otiiken eena ir. ");
INSERT INTO kmo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Worek, ye eena Jisas riina yesha heken otiir. Ye harapa lotu akak iyar yopo wuchi siitii maji batar. Ye eecha wor: “Kwo shecha hikitu? Riipa kapo saka noku sha a nedii yakiitawak?” ");
INSERT INTO kmo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Opelen otii tar harapa ma yechaka Perisi yechaka yenya wo sawor: “Kwota ma por Jisas riina hechaney, ii napa ya nona wo.” Ye Jisas riina poko jiken gegiyatarek, eena wor. ");
INSERT INTO kmo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yadii 6 tarek, nokusha a nedii saka yatarek, Jisas rii Betani akamak iyarer. Eeta akama Lasaras riiti akama, Jisas riita tiiriimo supuk taren otii saniyeechi yesokwar ma, riiti akama. ");
INSERT INTO kmo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yecha Jisas riina eeka aboboy otii ar. Mata siita aboboy gwotiitarek, Lasaras rii ma yechaka yichar. ");
INSERT INTO kmo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Worek, Maria sii yan najitar kwowa yatar uku kepin yeechi yaya Jisas riiti yatiik gwotiichi kaw siiti masebiyak bachir. Worek, eeta uku si kwowa eeta akamak sokwa punyir. ");
INSERT INTO kmo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Worek, Jisas rriti disaipel ma por, ri hi, Judas Iskeriot, rii komas Jisas riina yabu pichar ma yenya mukuchir ma, rii eecha wor: ");
INSERT INTO kmo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Boyewak no diita kwowa yatawa ukun saka 300 yak tokochi kiiriisiiposii tawa ma yenya hawak?” ");
INSERT INTO kmo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Rii saka eeta kiiriisiiposii tawa ma yenya hikichi eecha wor. Yaho. Rii hiyi bak tar ma. Rii yan heechitar bokisen siitii kowu tarek, hiyik yatar ma. ");
INSERT INTO kmo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Worek, Jisas rii yenya eecha wor: “Na heechi eeta mima siin. Sii eena neekitaney, i ana tiiriimok chikiita. ");
INSERT INTO kmo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kiiriisiiposii tawa ma ye kwotaka eechaba takiita. Wowak, ada kwotaka eechaba takasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nokwapa nokwapa Ju ma mima ye meejiri Jisas rii Betani akamak tar. Worek, ye eena eeka ichar. Ye ya Jisas riitaban hekasakech. Lasaras riina hebaken eena yatar. Mashi Jisas riita riina tiiriimok otii saniyeechi yesokwarek, eena hek yar. ");
INSERT INTO kmo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eena opelen otiitar harapa ma ye Lasaras riina pi sowakwobaken hikitar. ");
INSERT INTO kmo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nokwapa nokwapa Ju ma ye Lasaras riina hechi opelen otiitar harapa ma yen yu yeechi heechi yari, Jisas riitaban hikisiitiichichar. Ye eena hikitar. ");
INSERT INTO kmo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Komas yadii pochi nediik nokwapa nokwapa ma mima ye noku sha aken yari, ye meejir Jisas riita Jerusalemek ya maji meejir. ");
INSERT INTO kmo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Worek, ye eena me tapan rrekiichi neeki i nobok jawor. Jawochi ye uwar: “Hasana! Diita ma rii God rii hik yatawey, riiti hiban na yesokwa ta. Rii eeta Isrel yechi aka tabo yima!” ");
INSERT INTO kmo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Worek, Jisas rii donki yesha he yeechi eeka yo yirek ir. Keyir maji eecha wor: ");
INSERT INTO kmo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion akama kwo opoche akiitanakech. Na he! Kwi aka tabo yima rii diita yato. Rii donki magiirek yo yi yato.” ");
INSERT INTO kmo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eeta nediik disaipel ye diita majin hikikasakech. Wowak, komas Jisas rii riiti hadabas boboy kepin yar nediik ye eeka hikir diita jek keyir majin. Ye hikibar eeta ma yecha riina otiir boboyen. ");
INSERT INTO kmo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Eeta nediik Jisas rii Lasaras riita harek tiiriimo supuk tarin uwa yesokwa yichiri ma mima ye eena hechi otiir boboyen ba ye itar. ");
INSERT INTO kmo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eeta ma mima ye eeta mirakel otiirin meejichi ye eena i riina nobok jawor. ");
INSERT INTO kmo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Worek, eena Perisi ye yechaba awasen awasen batar: “Na he! Nota keena kata boboyen otiiniga dagiir poyekasakech. Eyey ma mima ye iri riitaban sumowutu!” ");
INSERT INTO kmo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ma mima ye Jerusalem akamak irek, Grik ma kaw ye God riiti hin yesokwataken ibabar. ");
INSERT INTO kmo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Irek, ye Pilip riitaka yar. Pilip ri akama Betsaida Galili nosapek tar ma. Riitaka yari, ye riina eecha wor: “Miinawa, nota Jisas riina heken gegiyato.” ");
INSERT INTO kmo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Worek, Pilip rii i Endru riitaka Pilip riitaka piir eecha i Jisas riina wor. ");
INSERT INTO kmo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Worek, Jisas rii awasen eecha wor: “Eeta nedii ya hamawa. Apa Ma Yikapwa rii hadabas boboy kepin yak otiito. ");
INSERT INTO kmo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ada kwona maji siikenen wocho: wit siikii nosapek sakachi sokwa siichi hanan siiney, riipa saniga takiita. Wowak, siita sakachi haney, iipa sii sokwachi harapa siiken wakiita. ");
INSERT INTO kmo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ma rii riiti mesek mayama rukusii tawey, riipa sii siiken siikiita. Wowak, ma rii riiti maban diita nosapek tanak yuyaney, iipa ri maban neekichi eechaba eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ma por riita eeji yon neekitaney, rii sapa ana sumowu ta. Eecha otiitaney, eeji yo otii wakasa ma riipa ya ada tawa akamabak adaka tabatakiita. Ma por rii eeji yon otiitaney, eeji Apoko riipa riiti hin howuk heechikiita. ");
INSERT INTO kmo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Apa eeeji bii negiirabotawak, an nubunubutu. Anapa shecha wokiita? Anapa kapo eecha wok, ‘Apoko, mii kapo adak yak otiiawa boboyen na yeechi rabo? Yaho. Anapa saka eecha wokiitawak. Eeta yikadey nomu yatawa boboyen kiyaken yar. ");
INSERT INTO kmo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Apoko! Miita miiti hin ma yechi misomak otiisa kepi wey sii!” Worek, howuk ya sakar aya eecha wor: “Ada eeji hin otii harapa siir. Apa ada kawka otiiniga harapa mayaka siikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma mima ye bana bana siitiitarek, meejirin ye eecha wor: “Nerek kurutu.” Kaw ye eecha wor: “Ejel por riita riina maji bato.” ");
INSERT INTO kmo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisas rii awasen eecha wor: “Diita maji sokwari, sii an kiyatayekasakech. Yaho. Sii sokwari kwona kiyatayechiken eena sokwar. ");
INSERT INTO kmo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Apa diita nosapek tawa ma mima yenya anasaken otiit. Apa diita nosapek aka tabo yichawa man dagiir poyeken otiito. ");
INSERT INTO kmo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ana nosapek tawan yesokwanak, eeta nediik ada ma mima yenya yeechi yayakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rii eecha wori riita hakiitawa majin eena wor. ");
INSERT INTO kmo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Worek, eeta ma mima ye awasen eecha wor: “Noti lo nona eecha wocho: Kraist riipa eechaba eechaba takiita. Boyewak mii eecha wocho, ‘Ma Yikapwa riina yesokwakiita?’ Diita Ma Yikapwa rii na ma?” ");
INSERT INTO kmo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Worek, Jisas rii yenya eecha wor: “Ameda siinak haba siipa kwotaka eecha takiita. Apa kwo habaka tawa. Eena kwota na habak chishi ta. Iipa niyiki ya kwona gamukiita. Ma niyikiyik chishitaney, rii i eemen hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kwo habak tawey, eena na hiki siitiichicha. Iipa kwo haba yikapwa siikiita.” Jisas rii yenya diita maji bachi rii yechi misomak heechi i veenyir. ");
INSERT INTO kmo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yeherek, rii nokwapa nokwapa mirakelen yechi misomak otiiri, ye eena hiki siitiichikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Eena piirapet Aisaia riiti maji sii siiken sokwar. Rii eecha wor: “Harapa Ma, nama kapo noti majin hiki siitiichir? Naman kapo Harapa Ma riiti hapaga tawa boboyen mukuchir?” ");
INSERT INTO kmo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ye kiki siichi hiki siitiichikasakech. Eena Aisaia rii eecha wor: “God rii yechi miyin otii dumur, Worek, yi inyaka sii papaga siir. ");
INSERT INTO kmo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Eena yechi miy hekasakech, marenoku hikikasakech. Yechi inyaka wopu dareboyekasakech eena ada yenya otii kepi siichikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia rii Jisas riiti hadabas boboyen hechi eena eecha wor. ");
INSERT INTO kmo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Worek, nokwapa nokwapa Ju yechi harapa ma ye Jisas riina hiki siitiichir. Worek, ye Perisi ma yenya akiitarek, eena ye hiki siitiichichari geenyik kwodii wokasakech. Ye eecha hikir: “Iipa ye nona lotu akak nonapa otii poyekiita.” ");
INSERT INTO kmo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ye God riiti yenya yechi hin yesokwanan yuyatar. Ye ma yecha yechi hin yesokwataken eena gegiyatar. ");
INSERT INTO kmo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas rii harapa uwachi eecha wor: “Ma ye ana hiki siitiichichaney, ii kwo saka adaban hiki siitiichichawak, rii ana heechirek yar Apoko riina hiki siitiichibato. ");
INSERT INTO kmo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Eeta ma ye ana hechawey, ye ana heechirek yar P Apoko riina hebato. ");
INSERT INTO kmo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ada diita nosapek yari, habaga eecha yar. Eyey ma ye ana hiki siitiichinyak yepa niyik takasakech. ");
INSERT INTO kmo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Eeta ma ye eeji maji meejichi nasowoy taney, ada yenya anasakasakech. Ada saka anasak yarek. Ada ma mima yenya yesokwa yichiken eena yar. ");
INSERT INTO kmo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eeta ma rii ana wosowoyeney, eeji majin yanan siiney, riina anasakiita. Ada sawotar maji sii hamak tawa nediik riina anasakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ada batawa maji saka eeji inyakak hikichi batawak. Yaho. Ana heechirek yar Apoko rii ada sawoken wochirek yar majin ana har. ");
INSERT INTO kmo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wowak, apa ada hecho riiti maji sii man eechaba eechaba takiitawa boboyen hato. Eena eyey majin ada batawey, eeji Apoko riita har majiga ada eechaba bato.” ");
INSERT INTO kmo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mashi yadii podat Pasova nokusha a nedii tarek, Jisas rii hikitar rii diita nosapen heechi Apoko riitak awasen ikiita. Jisas rii diita nosapek tawa ma mima riitin rii rukusiitari, i i eeta riitaka hamak tawa nediik rii rukusiibatar. ");
INSERT INTO kmo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hogo nediik ye atar. Gaba rii hiki hamar: Judas Iskeriot, Saimon riiti yikapwa, rii Jisas riina ye i yabu pi ma yechi tapak howur har. ");
INSERT INTO kmo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas rii her eeta Apoko rii eyey hapaga boboy Jisas riina ha hamar. Rii her rii God riita heechirek, yari riipa awasen riitak ikiita. ");
INSERT INTO kmo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eena Jisas rii aboboy heechi sokwa riiti saket kwoyaveechi siivatabin yeechi giiriir. ");
INSERT INTO kmo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Giiriichi, rii ukun yeechi heebiyaken gwotiipakachi riiti disaipel yeechi yatiin yeetiichi riita nedii poko giiretar siivatabin yeechi yechi yatiin bachir. ");
INSERT INTO kmo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Eecha otiirek, rii Saimon Pita riitak yar. Yarek, Pita rii eecha wor: “Harapa Ma, mii boy eeji yatiin yeetiibaken yato?” ");
INSERT INTO kmo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Worek, Jisas rii awasen eecha wor: “Ada otii tawa boboy mii hekasakech. Komas miipa hekiita.” ");
INSERT INTO kmo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita rii eecha wor: “Miipa yatii eejin sakapa yeetiichi tawak. Eeta sii siiken!” Worek, Jisas rii awasen eecha wor: “Ada miina yeechinan siiney, eeji eyey boboyen mii yakasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Worek, Saimon Pita rii awasen wor: “Harapa Ma mii eeji yatiiban yeechikasakech. Tapa masek napa yeechiba!” ");
INSERT INTO kmo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas rii awasen eecha wor: “Ma rii riiti eyey maban uku yeetii hamaney, rii kawka riiti maban uku yeetiikasakech. Yatiiban yeetiiney, siipa eeta apama hekiita. Kwo eeta apama hecho. Wowak, podareba rii apama hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas rii her eeta ma riipa riina yabu pi man yaya mukuchikiita. Eena rii eecha wor: “Kwo eyey apama hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Worek, Jisas rii yechi yatiin uku yeechi hamarek, rii riiti saketen ruwuchi kawka yir. Rii yen eecha wor: “Kwo kapo ada kwona otiiwa boboyen hikitu? ");
INSERT INTO kmo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kwota ana Tisa, Harapa Ma habato. Eeta kepi kwota eecha wochawey, ada eechaba tawa. ");
INSERT INTO kmo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ada Harapa. Ada Tisa. Tawak, ada kwoti yatiin yeechiwa. Wowak, kwo na eechaba kwoti yak kumwoy, yechi yatiin yeechiba ta. ");
INSERT INTO kmo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Otii tawa abo kepin ada kwona mukuchuwa. Ada kwona otiichirega kwo napa eechaba otii ta. ");
INSERT INTO kmo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ada kwona maji siikenen bato: Yo otii tawa wakasa ma rii riiti harapa man ichawa ma rii riiti yon wochitawak ichawa ma riin dagiir poyekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Apa kwo diita majin hecho. Wowak, kwo i otiiney, kwo kwoya hikitakiita. ");
INSERT INTO kmo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ada kwona eyey wokasakech. Ada hisiir ma yenya ada hikitu. Wowak, mashi keyir maji sii diita siiken sokwato. Sii eecha wor: ‘Ma rii eeji geyen atari, ii rii riiti yatiin yesokwachi ana piken otiir.’ ");
INSERT INTO kmo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ada apa kwona komas sokwakiitawa majin wocho. Komas ada wochawa sokwanak, kwopa hiki siitiichikiita ada diita Ma siiken. ");
INSERT INTO kmo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ada kwona maji siiken wocho: Eeta ma rii ada heechinak ikiitawa ma riin yeechi hehar taney, rii ana yeechi eechaba heharetakiita. Eeta ma rii ana yaney, riipa ana heechirek yar Apoko riina yabakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas rii eecha worek, riita harapa inyakapwa hikichi rii eecha wor: “Ada kwona siiken wocho: Ma por rii kwoti nediik tawey, riipa ana yabu pi ma yechi tapak howu hakiita.” ");
INSERT INTO kmo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Rii eecha worek, riiti disaipel ye miyibak mey maka her. Ye hikikasakech. Ye eecha hikir kapo naman wocho. ");
INSERT INTO kmo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Disaipel poren Jisas rii he hechitari, rii Jisas riitaka bana bana tar. ");
INSERT INTO kmo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Worek, Saimon Pita rii riin ri masekiik yeyadiichi eecha wor: “Riina na woher? Rii kapo naman wocho?” ");
INSERT INTO kmo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Worek, disaipel rii Jisas riitak i bana bana maji woher: “Harapa Ma, ii mii naman wocho?” ");
INSERT INTO kmo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Worek, Jisas rii awasen maji wor: “Ada gey kawen poyekuk heechi eeta ma riina hak.” Worek, Jisas rii gey kawen yeechi poyekuk woyichi Judas, Saimon Iskeriot riiti yikapwa, riina har. ");
INSERT INTO kmo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Worek, Judas rii diita aboboyen yarek, Gaba rii riiti sugu wopuk iyarer. Worek, Jisas rii riina eecha wor: “Miita otiiken otiina boboy na ameya otii!” ");
INSERT INTO kmo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma ye Jisas riitaka tiikiirek yichari ye Jisas riita bar maji meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas rii ya mani woyi tar kwowun heharer. Eena disaipel ye kaw eecha hikir Jisas rii wochirek, Judas rii aboboy tokoken ir. Kaw eecha hikir rii wochirek, kiiriisiiposii ma kawen boboy kiyatayeken ir. ");
INSERT INTO kmo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas rii gey kawen yeechi rii sokwa geenyik iyarer. Eeta niy nedii. ");
INSERT INTO kmo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas rii geenyik iyarerek, Jisas rii eecha wor: “Apa Ma Yikapwa riiti hadabas boboy sii geenyik sokwakiita. ");
INSERT INTO kmo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","God riita riiti hadabas boboyen Jisas Kraist riitaka mukuchinyey, God riitaba Ma Yikapwa riiti hadabas boboyen geenyik kwodii wo ameya mukuchikiita. ");
INSERT INTO kmo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Eeji yikapwa an sakapa kwotaka harapa takiitawak. Wonyak, kwopa ana komas yeshakiita. Ada Ju ma yenya kwodii worega ada kwona eechaba kwodii wocho: Ada inya eem kwo yabakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ada kwona akar lon hato. Kwota na yaka kumwoy yenya awasen awasen rukusii ta. ");
INSERT INTO kmo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kwota anadii man rukusiitawey, eyey ma yecha eena henyak, hikikiita two eeta eeji disaipel.” ");
INSERT INTO kmo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pita rii eecha wor: “Harapa Ma, mii siitak ichu?” Jisas rii awasen eecha wor: “Ada apak ichawa eemen mii ana sumowukasakech. Wowak, komas mii ana sumowukiita.” ");
INSERT INTO kmo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita rii awasen eecha wor: “Harapa Ma, boyewak apa adapa miina saka sumowukiitawak? Ada miina sayarechichu. Ada miina hachikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas rii awasen eecha wor: “Mii boy sayarechichawey mii ana hachikiita? Ada miina siiken wocho: Apochok wonyan biish tana nediik miipa eeji hin piiriichar nedii veenyekiita.” ");
INSERT INTO kmo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kwoti inyaka opoche i hiki ya hikitanakech. Kwo God riina hiki siitiichichawey, ana na eechaba hiki siitiichicha. ");
INSERT INTO kmo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Eeji Apoko riiti aka wo nokwapa nokwapa tawa. Eecha tanan siiyega, ada mashi waga kwona wowa. Ada ichawey, kwoti eemen sayarechiken ichu. ");
INSERT INTO kmo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ada kwoti akaman hamanak, ada kawka ya kwona yeechi ye i adaka eecha takiita. Eena ada tawa akama kwopa eechaba ya adaka tabatakiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ada ichawa akama nobo kwo hecho.” ");
INSERT INTO kmo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas rii eecha wor: “Harapa Ma, mii siitak ichu? Eeta nobon no hekasakech. Boyega no eeta nobon hekiita?” ");
INSERT INTO kmo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas rii yenya eecha wor: “Ada eeta nobo. Ada omutiik boboy mu. Ada eechaba eechaba takiitawa boboy mu. Ma por Apoko riitak saniga i nobokasakech. Yaho. Diita adaba. ");
INSERT INTO kmo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kwota ana hechayega, ii kwo waga eeji Apoko riina hebawa. Apa kwota riina hikichi her.” ");
INSERT INTO kmo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip rii eecha wor: “Harapa Ma, miita na nona Apoko riina mukuchi. Wonyak, nopa eeka kiki siikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas rii riina eecha wor: “Pilip ada kwotaka mashi harapa nedii tarek, mii boy ana saka hecharek? Ma ana henyey, rii eeta Apoko riina hebato. Boyewak mii eecha wocho, ‘Apokoriina na nona mukuchi?’ ");
INSERT INTO kmo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kapo mii ana hiki siitiichikasakech ada Apoko riitaka eecha tawak, riita adaka eecha tawa. Ada kwona batawa maji ansaka eeji inyakak hikichi batawak. Apoko rii adaka tawak, rii riiti yon otiichichu. ");
INSERT INTO kmo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kwota na diita majin hiki siitiichicha Apoko rii adaka tawak, an riitaka tawa. Kwo ana hikinan siiney, ii napa ada otii tawa yon hechi napa ana hiki siitiichi. ");
INSERT INTO kmo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Ada maji siikenen bato: ma rii ana hiki siitiichinyey, eyey ada otii tawa yikadey yon riipa otiibatakiita. Komas riipa otiina yo siipa harapa mayaka siinak, ada otii tawa yon dagiir poyekiita. Ada Apoko riitak ikiita. Eena eecha otiitakiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eyey boboyen kwota eeji hik wohenyey, ii anapa otiichikiita. Eecha otiinak, Apoko riiti hadabas boboy siipa Yikapwa riiti hik geenyek kwodii wo mukuchikiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kwota eeji hik boy boboyen ana wohenyey anapa otiichikiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kwota ana rukusiitaney, iipa kwo eeji lon sumowubatakiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Anapa eeji Apoko riina wohenyak, riipa kwona anadii kiyatay tawa boboy pochin kwona habakiita. Hanak, riipa kwotaka eechaba eechaba takiita. Dii eeta omutiik Spirit. ");
INSERT INTO kmo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Diita nosapek tawa ma mima ye kiki siichi yakasakech. Ye riina hekasakech, hikikasakech. Wowak, kwo riina hecho. Rii kwotaka tawa. Kwoti inyaka woka tawa. ");
INSERT INTO kmo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Anapa saka kwona heechikiitawak. Anapa kwotak yakiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ameda siinak, diita nosapek tawa ma mima yepa saka an kawka hekiitawak. Wowey, kwopa ana hekiita. Ada eechaba eechaba tawaga kwopa eechaba takiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Eeta komas nedii ad eeji Apoko riitaka eecha tawey, kwo hekiita. Kwo eecha hekiita kwo adaka tawak, ada kwotaka eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ma riieeji lon yeechi sumowutaney, eeta ma rii ana rukusiito. Rukusiitawey, iipa eeji Apoko riipa riina rukusiibatakiita. Wowak, anapa eechaba riina rukusiibatakiita. Wowak, ada geenyek ya sayanak, riipa an hehar hekiita.” ");
INSERT INTO kmo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Anadii Judas (Iskeriot, yaho) rii Jisas riina woher: “Harapa Ma, boyewak mii notaban geenyek mukuchichawak, diita nosapek tawa ma mima yensakapa mukuchibakiitawak?” ");
INSERT INTO kmo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas rii awasen eecha wor: “Ma rii ana rukusiitaney, riipa eeji majin sumowutakiita. Wonyak, eeji Apoko riipa eeta ma riina rukusiitakiita. Wonyak, sipa riitaka yanak, eechaba eechaba riitaka takiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Eeta ma rii ana rukusiinan biish tawey, riita eeji majin sumowukasakech. Diita majin kwota meeji tari, ii eeji majikasakech. Ana heechirek yar Apoko riiti maji. ");
INSERT INTO kmo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ada kwotaka eecha tarek, diita boboyen ada kwona sawotar. ");
INSERT INTO kmo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Eeta kiyatay tawa nareboyen, eeta Holi Spiriten, eeji hik eeta Apoko riipa heechinak yakiita. Eeta Holi Spirit riipa yanak, riipa kwona eyey boboyen pokiitanak, ada kwona mashi sawor eyey majin riipa yaya kwoti masekiibak heechikiita. ");
INSERT INTO kmo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ada heechi ik otiinak, eshar kwoya ta boboyen kwotana heechi ikiita. Eeji eshar kwoyaba ta boboyen kwona heechi ikiita. Diita nosapek tawa ma mima yecha eshar kwoya tawa boboyen kwona hatawaga an eecha hakasakech. Opoche kwi inyaka negarabochi akiitanakech. ");
INSERT INTO kmo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ada kwona heechi ichi awasen kawka kwotak yakiita ii kwo meejir. Kwota ana rukusiiteyega, ada eeji Apoko iken otiitawey, kwo waga eena meejichi kwoya hikitu. Apoko rii eeta harapa. An dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dii saka yatawak, ada kwona wocho. Ii yanak, napa kwo eena hiki siitiichi. ");
INSERT INTO kmo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Anapa kwotaka nokwapa maji kawka bakasakech. Diita nosapen aka tabo yichawa ma rii yato. Riiti hapaga tawa boboy sii ya ana siitii kowukasakech. ");
INSERT INTO kmo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wowak, diita nosapek tawa ma ye sa hiki ada Apokon rukusiito. Eena Apoko riita ana batawa eyey majin ada eena otiito. Na sokwanak, hawa ik.” ");
INSERT INTO kmo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ada eeta me nawaba. Eeji Apoko rii nowo yo otii tawa ma. ");
INSERT INTO kmo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Eeji me tapa omu wanan siiney, ii Apoko rii tiimii raboto. Eyey, me tapa omu watawey, Apoko rii eena hechi tiimii poy tawak rii hehar tawak, omu hehar wato. ");
INSERT INTO kmo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ada kwona sawotar maji sii eeta kwona tiimii poy hamar. ");
INSERT INTO kmo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kwota na adabaka eecha ta. Tanak, kwotaka eecha takiita. Me tapa nawabak tanan siiney, iipa boyega siik watakiita? Eechaba tawa kwota adaka tanan siiney, kwo omu wakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ada eeta me nawaba kwo eeta me tapa. Eeta ma ye adaka tanak, an yechaka taney, yepa harapa siiken watakiita. Kwota ana heechi inyey, kwopa omu wakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma por rii adaka tanan siiney, riin me tapaga tiimiichi rabonak, riipa reekiisiikiita. Wonyak, eeta me tapa yen ye i yopo yichi hik tukutu. ");
INSERT INTO kmo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Kwota adaka eecha taney, eeji maji sii kwotaka eecha taney, kwo yaken hikina eyey boboyen wohenyey, iipa kwo yakiita. ");
INSERT INTO kmo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wowak, kwo siik harapa watanak, kwo eeji disaipel siinak, eeta nobok eeji Apoko ri hi eetapa harapa siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Apoko rii ana rukusii tawaga, ada kwona eechaba rukusiito. Eena na ada rukusii tawa boboyek na ta. ");
INSERT INTO kmo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kwota eeji lon hehar sumowu taney, ii kwopa eeji rukusii tawa boboyek eeka siikiita. Ada eeji Apoko riiti majin sumowu tari, ada riiti rukusii tawa boboyek eeka tawaga, kwopa eeji rukusii tawaboboyek eechaba siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Diita majin ada kwona ba hamar. Eena ada kwoya hiki tawa boboysa kwoti sugu wopuk ta. Tanak, kwoti sugu wopuk takiikiisiichi tanak, na kwoya hiki ta. ");
INSERT INTO kmo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Dii eeta eeji lo eecha tawa: Ada kwona rukiisii tawaga kwo na eechaba kwoti yaka kumwoyenrukusiiba ta. ");
INSERT INTO kmo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ma por rii riiti nareboyen kiyatayeken maban mayama heechiney, akar rukusii tawa boboy sii diina dagiir poyechi kepi siikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kwota eeji majin eecha sumowu taney, kwo eeta eeji apoma tawa. ");
INSERT INTO kmo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Yo otii wakasa ma ye yechi harapa ma riita otii tawa boboyen hekasakech. Eena ada kwona yo otii wakasa ma habakasakech. Yaho. Eyey majin ada eeji Apoko riitak yarin, ada kwona sawo hamar. Eena ada kwona nareboy wocho. ");
INSERT INTO kmo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Kwota ana hisiikasakech. Yaho. Ada kwona hisiir. Kwota inyak harapa siiken waken eena hisiir. Eecha otiiri, siik eechaba eechaba takiita. Eecha otiiri, kwota eeji hik Apoko riina yaken otiina boboyen wohenyey, ii riipa hakiita. ");
INSERT INTO kmo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dii eeta eeji lo maji: anadii man na rukusii ta. ");
INSERT INTO kmo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Diita nosapek tawa ma yecha kwona yuyataney, kwo na hiki mapo ye ana yuyeechi ow ana pir. ");
INSERT INTO kmo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kwota diita nosapek tawa ma taney, diita nosapek tawa ma yepa kwona rukusiitakiita. Wowak, kwo diita nosapek tarin, ada kwona hisiirek, kwo diita nosapek yechikasakech. Eena diita nosapek tawa ma ye yuyato. ");
INSERT INTO kmo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ada kwona bar majin opoche abosuchitanakech. Na hiki ta, yo otii wakasa ma ye yechi harapa man dagiir poyekasakech. Yecha ana kikir poyeri, yepa kwona eechaba kikir poyekiita. Ye eeji majin sumowuyega, ii ye waga kwoti majin sumowubawa. ");
INSERT INTO kmo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wowey, ye ana heechirek yar Apoko riina hekasakech. Eena kwo eeji yo otii ma taweyn yepa kapasek otiikiita. ");
INSERT INTO kmo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ada ya yenya maji banan siiyega, ye waga kapasek boboy takasakech. Wowey, apa ye kapasek boboy veenyi nobokasakech. ");
INSERT INTO kmo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nokwapa nokwapa yon anadii ma ye eeji Apoko riina yuyabato. ");
INSERT INTO kmo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nokwapa nokwapa yon anadii ma ye eena otiikasakech. Ada ya yechi nediik eeka otii mukuchir. Ada eeta yon yechi nediik ya otiinan siiyega ye waga kapasek boboykasakech. Wowey, apa ye he hamarek, eena ye ana eeji Apoko riitaka sinya yuyato. ");
INSERT INTO kmo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wowak, yechi lo maji sii eecha wocho: ‘Yecha ana biish sobo yuyato.’ ");
INSERT INTO kmo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Komas kwona kiyatayek tawa ma, Spirit siiken, rii Apoko riitaka taweyn, ada i heechinak, rii ya ana maji kwona batakiita. ");
INSERT INTO kmo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kwo na eechaba sawoba ta. Mashi kwo adaka tarek, ada tasiir yo sii i i diita apa nedii. Eena na sawo ye i ta. ");
INSERT INTO kmo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kwota ana hiki siitiichichawa boboyen abosuchinakech eena ada kwona diita majin wocho. ");
INSERT INTO kmo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Komas ye kwona otu akak otii poyechinyak geenyik ya sayakiita. Komas nedii yanak, kwona pi sowakwo hamakiita. Wonyak, eecha hiki takiita ye God ri yon kiyatay tawa ma. ");
INSERT INTO kmo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wowey, ye Apoko riina saka hechawak, ana saka heb akiitawak eena eecha otiikiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wowey, ada kwona diita boboyen ba hamar. Komas diita boboy sokwanak, kwo napa ada mashi sawo tarin hiki ta.” ");
INSERT INTO kmo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Mashi ada kwotaka eecha tarek, ada eena kwona sawokasakech. ");
INSERT INTO kmo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wowak, apa ada ana heechirek yar Apoko riitak ichu. Wowak, kwoti nediik tawa ma por rii ada i eemen ana wohekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yaho. Ada diita majin kwona batawey, kwi bii kapo nomoyato. Ada kwona maji siikenen wocho. Ada heechi inyey, eeta boboy sii kwona kiyatay boboy. Ada inyan siiney kwona kiyatay boboy rii yakasakech. Wowak, ada heechi inyey, anapa riina wochinak, ya kwona kiyatayi takiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Komas riita ya otiichinyak, diita nosapek tawa ma yepa kapasek boboy siiti mun hekiita. Yepa nagwa nagwa kepi otii tawa boboy siiti mun hebakiita. Yepa anasa tawa boboy siiti mun hebakiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yecha ana hiki siitiichinyan biish tawey, ii eeta ye kapasek boboyeka eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ada eeta Apoko riitak awasen inyak, kwo kawka ana saka hekiitawak, ii yepa nagwa nagwa otii tawa boboy siiti mun hekiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Diita nosapek aka tabo yichawa ma riin anaseechi otii poyerek, eena yepa anasatawa boboyen hekiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ada nokwapa nokwapa majin kwona wok, wonyey, kwopa kapo saka hehar eyey meeji hamakiitawak. ");
INSERT INTO kmo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Komas omutiik tawa Spirit riipa ya kwona siiken tawa boboyen mukuchitakiita. Yanak, riipa saka riiti inyakak saniga otiitakiitawak. Yaho. Riita meejir majin iiban sawotakiita. Riipa kwona komas yak tawa boboyen eena sawotakiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Riipa eeji majiba yeechi kwona sawotakiita. Eecha otiitanak, riipa eeka eeji hin yesokwatakiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Eyey Apoko riiti boboy eeta eejiyiba. Eena ada eecha wocho eeta Spirit rii eeji maji yeechi kwona sawotakiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ameda nedii siinak, kwopa an sak kawka hekiitawak. Komas ameda nedii siichi kwopa ana kawka hekiita.” ");
INSERT INTO kmo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Riiti disaipel kaw ye eecha batar: “Ii boy maji mun rii nona wocho? Rii eecha wochi, ‘Ameda nedii siinak, kwopa an saka kawka hekiitawak. Komas nedii siichi kwopa ana kawka hekiita! Rii kawka eecha wocho, ‘An Apoko riitak iku!” ");
INSERT INTO kmo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ye eecha woher, “Diita ameda nediin riita wowey, rii boyen wowa? No riita bawa maji mun meejikasakech!” ");
INSERT INTO kmo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas rii hikir yecha woheken otiir majin. Eena rii yenya eecha wor: “Kwoboy ada kwona bar maji mun eena wopoy paka hecho? Ada kowna wowa: ‘Ameda nedii siinak, kwopa an hekasakech. Komas ameda siinak, kwopa na kawka hekiita.’ ");
INSERT INTO kmo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ada kwona maji siikenen wocho: Kwopa keya keyaniga inyakapwa hkitakiita. Wonyak, diita nosapek tawa ma mima yepa kwoya hiki ye itanak, kwoti bii apa nomuyatakiita. Wonyak, bii nomuyatawa boboy siipa dareboyenak, kwopa kwoyawoy hikitakiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mima yikapwan yimowuk otiiwa nedii sii yawak, sii inyakapwa hikitu. Sii hecho kapa meeji tawa nedii sii yato. Eena inyakapwa hikitu. Wowak, yikapwan yimowu hamanak, sii kapa meejitar boboyen abosuchitakiita. Yikapwa yimowu hamarek diita nosapek tawak eena sii abosuchi kwoya hikitu. ");
INSERT INTO kmo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kwo eechaba tawa. Apa kwi bii nomuyato. Wowak, anapa way kwon kawka henyak kwopa kwoya woy hikitakiita. Kwoti kwoya hiki tawa boboyen nasowoyekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Eeta nedii yanak, kwopa ana boy boboyen wohekasakech. Ada kwona maji siikenen bato: Kwo Apoko riita kwona boboyen haken wohenyey, riipa eeji hik kwona hakiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mashi kwo eeji hik boboyen yaken wohekaskech. Apa na wo hecha. Wonyak, kwopa yatakiita. Eena kwi sugu wopu kwoya woy hikitu.” ");
INSERT INTO kmo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ada kwona diita boboy wochari, ada shi tawa majik wochar. Ada komas kwona shiyi tawa majik bakasakech. Eeta nediik ada kwona geenyik Apoko riina kwodii wo mukuchikiita. ");
INSERT INTO kmo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Eeta nediik kwopa eeji hik God riina maji batakiita. Ada eecha bakasakech ‘Ada Apoko riina kwona kiyatayeken wohekasakech.’ Yaho. Apoko riita kwona rukusiito. Kwo ana rukusiitawey, kwo ana God riita heechirek, yarek eena hiki siitiichichawak, eena God riita kwona rukusiito. ");
INSERT INTO kmo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mashi ada Apokoka taren heechi diita nosapek yar. Apa ada diita nosapen heechi Apokok ichu.” ");
INSERT INTO kmo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Worek, riiti disaipel ye meejichi eecha wor: “Apa mii geenyik kwodii wocho. Mii shiyi majik bakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Apa no hecho namey ma miina awasen wohekasakech. Mii eyey boboyen hecho. Eena nota miina hiki siitiichichu. Mii God riitaka eecha taren yar.” ");
INSERT INTO kmo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas rii awasen eecha wor: “Apa kwo boy hiki siitiichichu? ");
INSERT INTO kmo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Eeta nedii yato. Ayo, eeta apa yawa. Yepa kwona kikirichinyak, kwopa heechi kwoti akamak saniga saniga i ye yanak, adaba saniga diika takiita. Wowak, ada saniga takasakech. Apoko rii adaka eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ada hikitu kwoti inyaka sa adaka tanak kwo na kwoya hiki ta. Eena ada diita majin kwona wocho. Kwo diita nosapek tawey, nomuyato. Wowak, kwoti inyaka sa hapaga siichi ta. Ada diita nosapek tawa boboyen dagiir poy hamar.” ");
INSERT INTO kmo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas rii diita majin ba hamarek, rii neren now hechi eecha wor: “Apoko, diita nedii sii yawa. Mii napa miiti Yikapwa riiti hinna yesokwa ta. ");
INSERT INTO kmo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wonyak, Yikapwa riipa miiti hin yesokwaba takiita. Miita Jisas Kraist riina eyey man siitii kowu hapaga boboyen hakiita. ");
INSERT INTO kmo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Eechaba eechaba tak tawa boboy diitata: ma ye sa he mii, omutiik tawa God, Jisas Kraist, miita heechirek yar Yikapwa, riina sa heba ta. ");
INSERT INTO kmo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Ada miiti hadabas boboyen yaya nosapek tawa man mukuchir. Ada miita ana har yo otii hamar. ");
INSERT INTO kmo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Apoko! Apa miitaka tawa hadabas boboyen na ana ha. Mashi adaka eecha tar boboyen nosap sokwanan biish tar nediik tar boboyen eena na ana ha. ");
INSERT INTO kmo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Diita nosapek tawa ma kawen miita ana hari, yenya ada miina mukuchi hamar. Yecha miiti tawa. Tawak, yenya miita ana har. Yecha miiti majin mayishichi sumowutar. ");
INSERT INTO kmo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Apa yecha hecho eyey miita ana har boboyen, miita ana har. ");
INSERT INTO kmo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Miita ana har majin ada yenya har. Worek, yecha yar. Yecha hecho ada miitaka taren heechi yar. Yecha hiki siitiichichu miita ana heechirek, an yar. ");
INSERT INTO kmo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Miita yenya kiyatayeken ada miina maji bato. Ada diita nosapek tawa ma yenya maji bachikasakech. Yaho. Miita ana har ma yechaban ada bachichu. Eeta miitiyiba eena ada bachichu. ");
INSERT INTO kmo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Eeji boboy eyey eeta miitiyiba. Miiti eyey boboy eeta eejiyiba. Wowak ye eeji hin yesokwato. ");
INSERT INTO kmo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ada heechi kawka miitak yak otiito. Ada diita nosapek takasakech. Yechaba diika takiita. Holi Apoko yenya na hehar siitii kowu ta. Yepa miiti hik eeka sapa ta. Miita ana har hibak sapa ta. Wonyak, ye sapa podatebakta. Shicha podatebak tawaga, sapa eecha ta. ");
INSERT INTO kmo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ada yechada tar nedii an yenya hehar ta. Ye miiti hik tarek, ye kepi tar. Eeta hi miita ana har hi. Ada yenya hehar otiitarek, por kapasek siikasakech. Ma podar riitaba wurubu yarebo tawa. Mashi keyir maji sii eecha wor riipa wurubu yarebokiita. Mashi heyir maji sii sokwa siiken taken eena rii eecha tar. ");
INSERT INTO kmo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Apa ada miitak yato. Yechi sugu wopu sa takiikiisiinak kwoya woy hiki ta eena diita nosapek kwona wocho. ");
INSERT INTO kmo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Ada miiti maji yenya ha hamar. Ada diita nosap ma yechikasakech. Yecha eechab diita nosap yechikasakech. Eena diita nosap ma ye yenya yuyato. ");
INSERT INTO kmo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Miita yenya diita nosap tawan yeechi ye iken ada eena miina wohekasakech. Yaho. Ada miina wohechawey, miita yenya hehar tanak, Gaba rii yenya yeechi wadey siikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ada diita nosapeksaskech. Ye eechaba diita nosapekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Miiti maji eeta maji siiken. Miita eeta majik na yenya otiichinyak, ye sa holi ma kepiga sii. ");
INSERT INTO kmo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Miita ana heechirek, diita nosapek yarega ada yenya eechaba heechirek, diita nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yecha kepi siiken eena eeji maban miina hato. Ada gegiyato yecha sokwaniga miiti ma siiken eena ada miina hato. ");
INSERT INTO kmo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ada miina maji batawey, yechabansaniga bachikasakech. Yaho. Batawey, eeta ma yecha yechi majin meejichi ana hiki siitiichikeneena bato. ");
INSERT INTO kmo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yecha podarebak hiki takeneena ada miina wohecho. Apoko, miita adaka tawak, ada miitaka tawaga yecha eecha takeneena ada wohecho. ");
INSERT INTO kmo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eeta hadabas boboyen miita ana hari, ada yenya ha hamar. Miita sicha podebak tawaga yecha sa eechaba podatebak ta. ");
INSERT INTO kmo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miita adaka tawak, ada yechaka tawak, yepa sokwa podatebak siikiita. Eecha otiitaney, diita nosap tawa ma yepa eecha hikiita miita ana heechirek yar. Yecha keena eecha hikikiita miita ana rukusiitawaga, miita yenya eechaba rukusiibato. ");
INSERT INTO kmo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Apoko, ada hikitu miita ana har ma yecha ada tawa eemebak taken an hikitu. Eecha tanak, miita ana har boboyen, hadabas boboyen, ye sapa heba ta. Diita nosap saka otii tar nediik miita ana rukusiitar boboyen har. ");
INSERT INTO kmo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yo omutiikeban otii tawa Apoko, diita nosapek tawa ma ye miina saka hechawak. Wowak, ada miina hecho. Diita nosapek tawa ma ye miina saka hechawak. Wowak, ada miina hecho. Diita ma ye eecha hecho miita ana heechirek, an diika yar. ");
INSERT INTO kmo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ada miiti hin yenya geenyik kwodii wo mukuchirek, ada kawka eechaba otiikiita. Miita ana rukusii tawa boboyen yechaka eecha siiken, ada yechaka eecha taken, eena ada eecha otiito.” ");
INSERT INTO kmo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas rii God riina maji bar hamarek, worek, rii riiti disaipel yechaka i Kidron pa reekiichi akar yepak ir. Ye hapaka tar eem sii eeka tarek, eena Jisas rii riiti disaipel yechaka eeka i yarer. ");
INSERT INTO kmo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, Jisas riina anadii ma tapak how haken otiitar ma, rii eeta eemen hebatar. Eechaba eechaba nedii Jisas rii riiti disaipel yechaka eeta eemek yaya yichar. Eena hebatar. ");
INSERT INTO kmo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eena, Judas rii, gavman yechi ow ana pichawa ma yechaka eeta eemek ir. Perisi ye opelen otiitar ma ye yechi ow ana pichawa ma yenya heechirek iri, Judas riitaka eecha ibar. Yecha iri, habata ow ana pichawa boboyeka eecha neekii neekii ir. ");
INSERT INTO kmo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Worek, Jisas rii her eyey boboy riitak yak otiiri, worek, rii sokwa i bana bana siitiichi yenya woher: “Kwo naman yeshato?” ");
INSERT INTO kmo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Worek, ye awasen eecha wor: “No Nasaret Jisas ya yeshato.” Worek, rii awasen yenya eecha wor: “Ada diitata.” Judas, Jisas riina mukuchir ma, rii yechaka eecha siitiibatar. ");
INSERT INTO kmo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisas rii eecha worek, “Ada diitata,” ye meejichi sen sen iri, nosapek sakar. ");
INSERT INTO kmo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Worek, Jisas rii yenya kawka woher, “Kwo naman yeshato?” Worek, ye eecha wor: “Nasaret Jisas.” ");
INSERT INTO kmo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Worek, Jisas rii awasen eecha wor: “Ada kwona wo hamawa, ada diitat. Kwo ana yeshataney, diita ma yenya na heechinak, sapa i.” ");
INSERT INTO kmo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kapo boyewak diita majin rii wor? Mashi rii God riina eecha wor: “Diita miita ana har ma yen ada por heechinak sakakasakech.” Diita maji siita siiken wey sokwaken eena rii eecha wor. ");
INSERT INTO kmo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Worek, Saimon Pita eekika eecha tari, rii eekin heyi huguruk yeechi rii opelen otiitar harapa ma riiti yo otiitar sakasa ma poren riiti mabiya mama yepan tiimii rabor. Eeta wakasa ma riiti hi, Malkas. ");
INSERT INTO kmo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Worek, Jisas rii Pita riina wor: “Miiti eekin na saragak awasen heyi heechi. Ii boy ana Apoko riita har kapa meeji tawa heebiyan anapa saka boy uku akiitawak?” ");
INSERT INTO kmo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Worek, gavman ow ana pichawa ma yechaka, yechi harapa ma riitak, Ju ma yechi ow ana pichawa ma yechaka ye Jisas riina yeechi pokok jir. ");
INSERT INTO kmo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jirek, ye Anas riitak ye ir. Anas riiti mima siiti apoko eeta Kaiapas. Kaiapas rii eeta sukwiya harapa opelen otii hechar ma. ");
INSERT INTO kmo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas rii mashi Ju ma yenya eecha wor: “Sabor ma podareba hanak, eyey ma miman kiyatayechi hacho.” ");
INSERT INTO kmo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita rii akar disaipel por riitaka piir Jisas riina sumowutar. Opelenotiitar harapa ma rii eeta akar disaipel poren hechar. Eena rii opelen otiitar ma riiti inyik iyarebar. ");
INSERT INTO kmo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wowak, Pita rii sabak nuburejaka bana bana siitiitar. Akar disaipel riin oplen otiitar harapa ma rii hechari rii nuberejan siitii kowutar mima siina worek, rii Pita riin i yayarer. ");
INSERT INTO kmo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nuberejan siitii kowutar mima sii Pita riina woher: “Mii kapo diita ma riiti disaipelebatar.” Worek, Pita rii awasen eecha wor: “Yaho. Adakasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yo otiitar ma ye siitii kowutar ma yechaka hin tukuchi maba neekiir yarek eena he waretar. Worek, Pita rii i yechaka eecha siitiichi hi warebatar. ");
INSERT INTO kmo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Eeta opelen otiitar harapa ma rii Jisas riina woher riita pokiitar majin disaipel yechi majin eena woher. ");
INSERT INTO kmo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Worek, Jisas rii awasen eecha wor: “Ada majin eyey ma mima yechimisomak geenyek kwodii wochar. Eechaba eechaba nedii ad lotu akak yenya sawotarek, tebel akak sawotar. Ju ma yecha ya yopo wuchi yichar eemek eeka an sawotar. An boy majin veenyi eemek pochi bakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Boyewak mii ana wochecho? Na eeta majin mmejitar ma yenya wohe. Ada batar maji ye meejitar.” ");
INSERT INTO kmo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Rii eecha wocharek, kubu neeki ma por rii bana siitiitari rii Jisas riina pichi eecha wor: “Mii boyewak harapa ma riina eecha wocho?” ");
INSERT INTO kmo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Worek, Jisas rii awasen eecha wor: “Ada kapasek majin bataney, ii na eeta kapasek maji siin geenyek kwodii wo. Ada maji kepin bataney, boyewak mii ana piwa?” ");
INSERT INTO kmo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Worek, Jisas riin jir poko eechaba tarek, Anas rii riin heechirek, Kaiapas riitak ir. ");
INSERT INTO kmo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Worek, Saimon Pita rii siitii hi watarek, ye riina eecha wor: “Mii kapo riiti disaipeleba?” Rii veenyechi eecha wor: “Yaho. Adakasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Worek, opelen otiitar harapa ma riiti yo otiitar wakasa ma por, Pita riita mabiyan tiimiir ma riiti magapa, rii eecha wor: “Ada miina kapo yichar eemek hebar?” ");
INSERT INTO kmo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Worek, Pita rii awasen eecha wor: “Yaho.” Worek, apochoko aya wor. ");
INSERT INTO kmo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Worek, ye Jisas riina yeechi Kaiapas riina heechi harapa gavman ma riiti akak ye ir. Eeta niyega hubuk. Yecha eeta harapa gavman ma riiti akan iyarekasakech. Ye eecha hikir, “Nota otiiniga kehanak, nopa kapo Pasova nokusha akasakech. Eena ye iyarekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Worek, eena ye geenyek tarek, Pailat rii ya saya yenya woher: “Kwo diita ma riin boyewak anasaken otiito?” ");
INSERT INTO kmo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Worek, ye awasen eecha wor: “Diita ma riita kapasek boboyen otiinan biish teyega, no waga saka miitak yayawak.” ");
INSERT INTO kmo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Worek, Pailat rii yenya eecha wor: “Na keena kwota otii tawa aboga eecha otiiniga anasa.” Worek, eeta Ju ma ye riina eecha wor: “Nota man por pi sowakwo nobokasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mashi nedii Jisas rii ha majin wori eeta maji sii eeta sokwa siiken majik siir. ");
INSERT INTO kmo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Eena Paiat rii heechi gavman harapa ma riiti akak tawka iyarer. Worek, rii Jisas riina uwa yayeechi woher: “Mii boy kapo Juda yechi aka tabo yima.” ");
INSERT INTO kmo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas rii awasen eecha wor: “Kapo miita saniga eeta majin hikichi ana wocho? Kapo akar mak miina ana eecha wor?” ");
INSERT INTO kmo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat riiawasen eecha wor: “Mii boy eecha hikitu an boy Ju ma? Miiti ma ye opelen otiitawa harapa ma yechaka kwo adak yayawa. Mii boyen otiir?” ");
INSERT INTO kmo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Worek, Jisas rii awasen eecha wor: “Eeji yo otii wakasa ma ye waga ow ana piwa. Wowak, namey ma ana Juda yechi tapak how hakasakech. Wowey, eeji kigdom diita nosapek takasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Worek, eena Pailat rii eecha wor: “Wowak, mii aka tabo yima por? Jisas rii awasen eecha wor: “Miita keena eecha wocho, an aka tabo yima. Eeji awi sii ana yimowurek ada diita nosapek yar. Boyewak an yar? Ada boboy podaten otiiken eena yar. Maji siikeneban sawotaken eena ada yar. Eyey ma kaw ye maji siikeneka eecha tawey, ye ana meejito.” ");
INSERT INTO kmo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Worek, Pailat rii awasen woher: “Maji siiken ii boy boboy?” Worek, rii eecha bachi rii kawka Juda yechaka iyarer. Iyarechi rii eecha wor: “Ada riiti kapasek boboyen pochi hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wowey, kwoti Pasova otii tawa abo ada ma poren pokon heemachichawak, ichu. Eena kwo kapo hikitu ada Juda yechi aka tabo yiman heemachik?” Worek, ye eena uwar: “Rii biish! Mii napa Barabas riina heemachi!” Barabas rii man pi sowakwotawak mey boboyen hikyik yato. ");
INSERT INTO kmo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","(-) ");
INSERT INTO kmo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Worek, eena Pailat rii Jisas riina kubuk pir. ");
INSERT INTO kmo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ow ana pichar ma ye yamika tar pokon yeechi makwoga otiichi riiti masekiik ruwuchir. Ruwuchirek, siivatabi nayen ruwuchibar. ");
INSERT INTO kmo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ye yari, wohegachi woshi ar: “Sen, mii Juda yechi aka tabo yima.” Worek, ye i riina pir. ");
INSERT INTO kmo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Worek, Pailat rii kawka geenyik i yarechi wor: “Na he. An riina yeechi Kwona geenyik ya sayato. Kwopa hekiita ada riiti kapasek boboyen kaw hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Worek, Jisas rii geenyik ya sayar. Worek, yamika tar pokon makwoga otiichi ruwuchiri, sii masekiik tarek, eecha ya sayar. Siivatabi nayen ruwuchiri sii tabatar. Worek, Pailat rii yenya wor: “Na diita ma riina he!” ");
INSERT INTO kmo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Worek, opelen otiitar harapa ma ye, kubu neeki tar ma ye, riina hechi uwachi eecha wor: “Mek na ji siitiichi! Mek na ji siitiichi!” Worek, Pailat rii eecha wor: “Kwota na keena yeechi yi i mek ji siitiichi. Ada riiti kapasek boboyen pochi hekasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Worek, eeta Juda ye riina awasen eecha wor: “Nowi lopochi tawa. Eetalo sii eecha wocho: eeta ma rii sa ha. Riita eecha wor: “Ada God riiti Yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat rii eeta majin meejirek, rii harapa akiitar. ");
INSERT INTO kmo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Worek, rii gavman ma riiti akak kawka i yarer. I yarerek, rii Jisas riina eecha wor: “Mii siitak taren yar?” Wori, Jisas rii awasen maji bakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Worek, Pailat rii riina wor: “Mii boyewak ana kapo bakasakech? Anapa keena kiki siinak miina heemachinyak, anapa keena miina mek ji siitiichikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas rii awasen eecha wor: “Howuk tawa God riita miina hapaga tawa boboyen hanan siiyega, mi hapaga boboy sii ana dagiir poyekasakech. Wowak, eena ma ye miiti tapak howu hari, yechi kapasek boboy eeta harapa mayak. Miiti kapasek boboyeka kiki siikasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat rii eena meejirek, rii eena riina heechinak i nobon yeshar. Wori, Juda ye uwar: “Miita diita ma riina heechinak, inyey, ii miipa Sisa riiti nareboyekasakech. Rii eecha wochawey, ada eeta aka tabo yima, ii Sisa riina ow ana pichu!” ");
INSERT INTO kmo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Worek, Paiat rii diita majin meejirek, rii Jisas riina geenyik yeechi ya sayar. Worek, rii anasak tawa tiikiirek eeka yichir. Ye eecha habatar papaga tar eem. Hibru maji eecha wochar, Gabata. ");
INSERT INTO kmo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Diita nedii Pasova nokusha a nediin sayaretar. Dii eeta kiya nokun atawa nedii. Pailat rii Juda yenya wor: “Na kwoti aka tabo yima riin he!” ");
INSERT INTO kmo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Worek, rii awasen eecha wor: “Na ye i. Mek ji siitii ji!” Pailat rii yenya awasen eecha wor: “Kwo boy eecha hikitu, kwoti aka tabo yiman ad ye i mek ji siitiichik!” Worek, opelen otiitar harapa ma ye eecha wor: “Noti akar aka tabo yima takasakech. Sisa riitaba eeta noti aka tabo yima podar!” ");
INSERT INTO kmo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Worek, eena Pailat rii Jisas riina mek ji siitiichiken yechi tapak how har. ");
INSERT INTO kmo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Worek, eena ye Jisas riina yeechi riina ji siitiichi men harek, rii kiyaniga akaman heechi eem pochik ye ir. Eeta eem siiti hi, Masekii Hapa. ");
INSERT INTO kmo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Eeta eem riina mek ji siitiichir eem. Akar ma upurus piiriin yepa yepa akar mek irek, Jisas riin nediik jir. ");
INSERT INTO kmo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Worek, Pailat rii maji kawen keyichi eeta mebak heechir. Rii eecha keyir, “Nasaret Jisas, Juda Yechi Aka Tabo Yima.” ");
INSERT INTO kmo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Eeta eem Jisas riina mek ji siitiichir eem harapa akama pochi eeka bana bana tar. Eena nokwapa Ju ma ye eeta keyir majin kenyitar. Pailat rii eeta majin Hibru majik keyirek, Rom majik keyirek, Grik majik keyir. ");
INSERT INTO kmo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Worek, eeta Juda opelen otiitar harapa ma ye Pailat riitak i maji eecha wor: “Opoche mii eecha keyitanakech, Ju Ma Yechi Aka Tabo Yima. Mii na eecha keyi, Diita Ma Rii Eecha Wor: Ada Ju Ma Yechi Aka Tabo Yima.” ");
INSERT INTO kmo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Worek, Pailat rii awasen eecha wor: “Ada eecha keyiri, eeta an keyi abor.” ");
INSERT INTO kmo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Eeta gavman ow ana pichar ma ye Jisas riina mek ji siitiichi hamarek, ye riiti siivatabin yeechi diipiira kapiira yopo yichi ow ana pichar ma ye homachi ye i yayar. Worek, ri saket yabar. Diita saketsiin kapa nobokasakech. Podareba tar. ");
INSERT INTO kmo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Eena gavman ow ana pichawa ma ye eecha wor: “No diigiikasakech. Sa eecha tanak, nota satu anemesheroko tanak, eeka sapa ma porek ya.” Yecha otiirek, mashi keyir maji sii eeta sokwa siiken siir. Keyir maji sii eecha wor: “Ye eeji siivatabin yeechi yaya homachirek, Eeji saket satu anamesh rokochi ma porek yar.” Ow ana pichawa ma ye eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas riina jir mek riiti awi siitaka siiti kumwoy siitak, Klopas riiti mima, Maria, siitaka, Magdala Maria, siitaka ye eecha eeka siitiitar. ");
INSERT INTO kmo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisasrii riiti awi siina herek, riiti disaipel por rii riina rukusiitar ma riina hebar. Worek, eena rii eecha wor: “Diita ma rii eeta niji yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Worek, rii eeta disaipel riina eecha wor: “Diita mima sii eeta miiti awi.” Worek, eeta nediik disaipel rii Maria siina yeechi riiti akak ye irek, hehar otii hechatar. ");
INSERT INTO kmo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eecha otii hamarek, Jisas rii her riiti yo eeta hamar. Keyir maji eecha wor, “Ada biiriiwaga reekiisowak, ukun aken.” Rii eecha worek, eeta maji sii ya geenyik sokwar. ");
INSERT INTO kmo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Heebiya pochi eeka tari ye viniga ukun sheke atawa boboy eeta heebiya wok heechir. Worek, kubuk jichi Jisas riiti kujak heechirek, rii ar. ");
INSERT INTO kmo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas rii ukun eechi eecha wor: “Eeta hamawa!” Worek, rii masekii eeta saka jeyirek, eeta kuriidiichir. ");
INSERT INTO kmo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Eeta nedii Pasova sayaretar nedii. Eeta akama siitar nedii sii harapa nedii, eena eeta nediik Juda ye maba mek tanak, yuyar. Worek, ye Pailat riina wor: “No yechi yatiin reekiinak, maban yeechi ye ik. ");
INSERT INTO kmo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Worek, gavman ow ana pi ma ye i ma upurus Jisas riitaka eecha jiri, piiriiti yatiin reekiir. ");
INSERT INTO kmo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Worek, ye ya Jisas riina heri, rii ha siiken harek, eena saka rii yatiin reekiirek. ");
INSERT INTO kmo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Worek, ow ana pichar ma por rii Jisas riiti bayegeyn yabuk pirek, pika ukuka eecha gwotii sakar. ");
INSERT INTO kmo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma por ii eena heri, rii geenyik kwodii wor. Eeta kwodii wor maji sii eeta maji siiken. Eena kwota na hiki siitiichicha. ");
INSERT INTO kmo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mashi keyir maji eecha wor: “Ye ri yatiin reekiikasakech.” Eecha otiiri, eeta maji sii eeta ya geenyik sokwar. ");
INSERT INTO kmo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Akar mashi keyir maji sii eecha wocho: “Ma mima ye eeta pir ma riina hekiita.” ");
INSERT INTO kmo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ii hamarek, Arimatia Josep rii ya Paiat riina wor: Jisas riiti maban yeechi ye i chiken. Josep rii Jisas riiti disaipel por tar. Echa tari, rii Juda yenya akiirek, eena riiti hiki siitiichichar boboyen rii veenyir. Paiat rii bar majin meejichi eecha wor: “Na yeechi ye i chi.” Worek, Josep rii maban yeechi ye ir. ");
INSERT INTO kmo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas, rii mashi Jisas riina niyik ya heri, rii Josep riitaka piir eecha ir. Josep rii kwowa ya tawa boboyeka eecha yayar. Eeta pi yechi hi, miir, alos. Eeta boboy si nomu 100 paun. ");
INSERT INTO kmo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Piir Jisas riiti maban yeechi siivatabik jichi Juda yecha otii tawa aboga eecha otiir. Kwowa ya tawa ukuk neekichi ye ir. ");
INSERT INTO kmo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas riina mek ji siitiichir eemek nowo pochi eeka tar. Eeta nowok tiiriimo akar eeka tar. Papa supu tiiriimo eeka tar. Mashi ma por eeta tiiriimok chikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Eeta yadii nedii Juda yecha Pasova sayaretar nedii. Eeta tiiriimo supu eeka bana bana tarek, eena piir ye i eeka chir. ");
INSERT INTO kmo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sand yadii uhadiirek, niyi kaw tarek, Magdalla Maria tiiriimo supun heken ir. Irek, sii her dasiipii paretar papa tagwa seechi tar. ");
INSERT INTO kmo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Worek, sii heechi amaba i Saimon Pita riina akar disaipel, Jisas riita rukusiitari, yechaka eecha wor: “Yecha eeta Harapa riina tiiriimo supuk tarin, yeechi ye iwey, kapo siitak heechuwa?” ");
INSERT INTO kmo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Worek, eena Pita riita akar disaipel poreka piiriita heechi tiiriimo supuk ir. ");
INSERT INTO kmo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Piiriita amaba iri, akar disaipel por rii Pita riin dagiir poyechi mapo amaba i her. ");
INSERT INTO kmo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rii gamuchi mey heri, siivatabibak yicharek, her. Wowey, rii iyarekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Worek, Saimon Pita riita komas yari, rii ya nagwa nagwa tiiriimo supuk i yarer. I yearechi herei, siivatabi kawebak yichar. ");
INSERT INTO kmo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Heri, siiviitabi pochi Jisas riiti maseken jiri, siin hebar. Eeta siivatabi siin saniga saniga har yichi ye ikasakech. Podatebak yopo wuchi yichitar. ");
INSERT INTO kmo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Worek, akar disaipel por mapo yari, rii i yarebar. I yarebari, rii eena herek, rii hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Eeta nedii piir saka hikitarek God riiti mashi keyir maji eecha wor: Jisas riita hanak, saniyeechi kawka yesokwakiita. ");
INSERT INTO kmo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Worek, eeta disaipel piir heechi piiriiti akak ir. ");
INSERT INTO kmo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria sii tiiriimo supuk bana bana siitii keyitarek, sii gamuchi won mey her. ");
INSERT INTO kmo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sii heri, ejel upurus piir siivatabi apaman ruwuchi yicharek sii her. Piir Jisas riiti maban seechir eemek por masekiik yicharek, por yatii hugushak yichar. ");
INSERT INTO kmo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Piiriita hechi Maria siina eecha wor: “Na boyewak keyato?” Worek, sii awasen piiriina eecha wor: “Ye eeji Harapa riina yeechi kapo siitak ye i heechuwa?” ");
INSERT INTO kmo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sii eecha wochi diiriiboyeri, sii Jisas riin her, siitatarek. Wori, Maria sii Jisas riin hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Worek, Jisas rii siin maji wor: “Mama, ni boyewak keyato? Ni naman yeshato?” Maria sii eecha hikir dii nowon siitii kowu tawa ma. Hikichi eecha wor: “Sen, miita yeechi ye siitak seechi taney, napa ana wonyak, an yeechi kiya ik.” ");
INSERT INTO kmo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas rii Maria siina eecha wor: “Maria.” Worek, Maria sii diiriiboyerek, Hibru majik wor: “Rabonai.” Diita maji eecha wocho: “Tisa.” ");
INSERT INTO kmo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisas rii siina eecha wor: “Opoche ana neeki heechanakech. An saka howuk i yowu tawak. Ada saka eeji Apoko riin ichawak. Wowak, nija napa i eeji yaka kumwoy yenya sawo: ‘Ada i yowunak, eeji Apoko riita, kwoti Apoko riitak riina hekiita. Eeji God kwoti God riina i hekiita.’” ");
INSERT INTO kmo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Worek, Magdaa Maria sii ir. Irek, sii disaipe yenya eecha wor: “Ada Harapa riina her.” Sii Jisas riita bar majin sii yenya sawor. ");
INSERT INTO kmo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Disaipel ye Juda yenya akiitarek, yecha tar aka nuburejan dasiipiichi yichar. Eeta Sande nedii ya ye i tar nediik Jisas rii ya yechi nediik siitiir. Siitiichi yen eecha wor: “Kwoti sugu wopu sa hehar ta.” ");
INSERT INTO kmo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eecha wochi rii riiti bayegeyn mukuchirek, tapan mukuchir. Eeta disaipel ye eeta Harapa riina herek, yecha kwoya woy hikitar. ");
INSERT INTO kmo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas rii yenya kawka wor: “Kwoti sugu wopu sa kepiba ta. Apoko riita ana heechirek yar. Eechaba ada kwona heechinak ikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eecha wochi rii yenya piineechi kawka wor: “Kwo eeta Holi Spiriten yawa. ");
INSERT INTO kmo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kwo anadii ma yechi kapasek boboyen kwoyava yeechiney, kwi kapasek boboy eeta biish woy sowa. Kwota anadii ma yechi kapasek boboyen egesiichi heechi taney, yi kapasek boboy siipa yechaka eechaba takiita.” ");
INSERT INTO kmo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Eeta nedii Jisas rii yari, disaipel ye 12 por yechaka takasakech. Riiti hi Tomas. Ri akar hi pochi Didimas. ");
INSERT INTO kmo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Worek, akar disaipel ye riina wor: “No Harapa riina her!” Worek, Tomas rii yenya eecha wor: “Ada riiti tapan pir wowi supun eena henyan siiney, eeji tapa riina wowi pir nobon neeki henyan siiney, eeji tapa riiti bayegeyn neeki henyan siiney, ii ada hiki siitiichikasakech. Eeta sii siiken!” ");
INSERT INTO kmo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Komas 8 de siirek, Jisas riiti disaipel ye kawka i yarerek, Tomas iibak taba tar. Ye eyey nubureja dasiipii hamarek, worek, Jisas rii ya yechi nediik siitiir. Siitiirek, rii eecha wor: “Kwoti sugu wopu sa hehar ta.” ");
INSERT INTO kmo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Worek, rii Tomas riina wor: “Miiti tapaman na diika yaya. Na eeji tapan he. Miiti tapan na yaya eeji bayegeyn na neeki he. Opoche hiki siitiichichawa boboyen nasowoyetanakech. Yaho. Mii na hiki siitiichi.” ");
INSERT INTO kmo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Worek, Tomas rii awasen eecha wor: “Mii eeji Harapa! Mii eeji God!” ");
INSERT INTO kmo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Worek, Jisas rii awasen riina eecha wor: “Mii ana hewey, mii boy hiki siitiichichu? Eeta ma ye ana henyan siiri, ana hiki siitiichichaney, ya sa kwoya hiki ta.” ");
INSERT INTO kmo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas rii nokwapa nokwapa akar mirakelen disaipel yechi misomak otiitar. Otiitari, ada eena eyey, diita jeyek keyakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wowey, dii an keyi hamar. An keyiri, kwota Jisas riina hiki siitiichiken rii eeta Kraist, God riiti Yikapwa, eena ada keyir. Kwo hiki siitiichichaney, kwopa riiti hik eechaba eechaba siikiita. ");
INSERT INTO kmo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Komas nediik Jisas rii kawka disaipel yechi misomak Taibirias pak eeka her. Diita nobok yechak eecha yar: ");
INSERT INTO kmo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (ri hi pochi, Didimas), Nataniel (riiti eem Galili Kena), Sebedi riiti yikapwa upurus piir, Jisas riiti akar disaipel upurus piir yecha eecha eeka tar. ");
INSERT INTO kmo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Worek, Saimon Pita rii yenya eecha wor: “An emiyep chik iku.” Worek, ye riina eecha wor: “Nota miitak ibak.” Worek, ye iri, i jabiirek yowur. Wori, eeta niyi ye emiyepen por yakasakech. ");
INSERT INTO kmo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Uhadiirek, ya sokwak otiitarek, Jisas rii pagiirebak siitiitar. Worek, eeta disaipel ye Jisas riina hekasakech. ");
INSERT INTO kmo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Worek, Jisas rii yenya woher, “Yikapwa kwo boy emiyep kaw yawa?” Meejichi awasen eecha wor: “Yaho.” ");
INSERT INTO kmo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Worek, rii yenya eecha wor: “Kwota na mayan yeechi mama yepa gayek rabo. Rabonak, kwopa emiyep eeka yakiita.” Worek, ye eena meejichi maya rabor. Wori, ye emiyep nokwpa nokwapa yar. Maya ye yesokwakasakech. Emiyep takiikiisiir. ");
INSERT INTO kmo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eeta disaipel por riin Jisas riita rukusiitari, rii Pita riina wor: “Rii eeta Harapa!” Saimon Pita rii riiti saketen kwoyaveechi yo otiitari, rii meejiri, “Rii eeta Harapa”, rii eena sakaten yeechi ruwuchi pak duriir. ");
INSERT INTO kmo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Worek, eeta anadii disaipel ye yari, ye eeta emiyepen mayaka eecha kiyi ye yo wur. Ye pagiirebak yapak takasakech. 300 pit eecha tar. ");
INSERT INTO kmo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ye ya gayechi heri, hi uwutarek, emiyep hik uwutarek, gey iibak tar. ");
INSERT INTO kmo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisas rii eecha wor: “Kwota yawa emiyepen kaw na yeechi yaya.” ");
INSERT INTO kmo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Worek, Saimon Pita rii meejichi jaborek yowur. I Yowuchi mayan kiyi yaya giirebak yichir. Nokwapa nokwapa harapa emiyep eeta maya takiikiisiir. 153 emiyep eecha tar. Eecha nokwapa nokwapa harapa tari, maya sii neekiikasakech. ");
INSERT INTO kmo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas rii yenya eecha wor: “Na ya a.” Eecha wori, disaipel por eena eecha wohekasakech: “Mii nama?” Ye eyey her rii eeta Harapa. ");
INSERT INTO kmo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas rii yari, geyen yenya homachi hapoy pakar. Emiyepen eechaba otiir. ");
INSERT INTO kmo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisas rii tiirimok heechi ya sokwarek, rii mayama disaipel yenya piiriichar nedii mukuchir. ");
INSERT INTO kmo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ye a hamarek Jisas rii Saimon Pita riina maji bar: “Saimon, Jon riiti yikapwa, mii boy kapo diita disaipel kaw yen dagiir poyechi mii ana rukusiito?” Pita rii awasen eecha wor: “Ayo, Harapa Ma, mii hecho, ada miina rukusiito.” Worek, Jisas rii riina eecha wor: “Miita napa eeji sipsip yin hava ta.” ");
INSERT INTO kmo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kawka rii way wor: “Saimon, Jon riiti yikapwa, mii boy ana rukusiito? Kapo saka rukusiitawak?” Worek, Pita rii riina wor: “Ayo, Harapa Ma, mii ana hecho, ada miina rukusiito.” Jisas rii awasen riina wor: “Miita napa eeji sipsipen siitii kowu ta.” ");
INSERT INTO kmo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Piiriichar nedii rii way kawka wor: “Saimon, Jon riiti yikapwa, mii boy kapo ana rukusiito?” Worek, Pita riiti bii nomuyar. Piiriichar nedii woherek, “Mii boy ana rukusiito?” Worek, rii Jisas riina wor: “Harapa Ma, mii eyey boboyen hecho. Mii hecho, ada miina rukusiit.” Worek, Jisas rii riina wor: “Mii napa eeji sipsip yenya hava ta.” ");
INSERT INTO kmo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Eeta siiken woy, ada miina wocho, mashi miita hadiiyey tarek, mii miiti putu sapin giiriichi miita iken otiitar eemek iken otiitari, mii ichar. Wowey, komas miita apoko saba siinak, eeta nedii miipa miiti tapan yesokwanak, akar mak miin putu sapin giiriichi ye ikiita. Miita inyan yuyatana eemek ye ikiita.” ");
INSERT INTO kmo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisas rii diita majin wochawey rii eecha wocho Pita riipa hanak, riipa God riiti hin yesokwakiita.) Worek, Jisas rii Pita riina eecha wor: “Ana na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Worek, Pita rii vayoko hechi akar Jisas ri disaipelen her. Diita her disaipel riin Jisas rii rukusiir. Disaipe yecha aboboy atarek, diita disaipel rii Jisas riitaka bana bana kwarkwar i Jisas riitaka anahayichi eecha woher: “Harapa, nama notaka tawey, apa miina kapasek otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita rii riina hechi Jisas riina woher: “Harapa, ii boy diita ma riita?” ");
INSERT INTO kmo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas rii awasen eecha wor: “Ada gegiyaney, riipa saka hatanak anapa yakiitawak. Iipa miiti yokasakech. Ana na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jisas rii diita majin eecha worek, eena Jisas riina sumowu tar ma ye eecha hikir diita disaipel rii saka hakiitawak. Eena maji i ye yatar. Wowak, Jisas rii saka worek, rii saka hakiitawak. Yaho. Rii eecha wor: “Adagegiyaney, riipasaka hatanak, anapa yakiitawak. Iipa miiti yokasakech.” ");
INSERT INTO kmo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Diita disaipel riitaba rii diita maji bachiniga riitaba keyir. Wowak, no hikitu riiti maji eeta omutiik. ");
INSERT INTO kmo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Wowak, nokwapa nokwapa akar boboy Jisas rii otiir. Eyey riita otiir boboy podat podaten keyiney, an eecha hikitu diita nosap sakapa kiki siikiitawak keyir jey takiikiisiikiita. ");
INSERT INTO kmo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyapolas, sen, Ada mapo keyir jeyek eeka ada Jisas riita otiir yon riita bar majin eena ada keyir. ");
INSERT INTO kmo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jisas eyey yon tasiichi otii hamachi heechi yowur majin eena keyir. Eeta nedii rii saka yo tarek, rii riita hisiir aposel yenya Holi Spirit riiti hapaga boboyek majin eeka pikii tar. ");
INSERT INTO kmo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Rii kapa meejichi harek, rii 40 de siir. Eeta 40 de siirek, rii riiti aposel yenya nokwapa nokwapa mukuchichar. Mukuchicharek, aposel ye her. Herek, eeta mukuchichu rii tawa. Yecha riina hechi chisi tarek, maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jisas rii God riiti siiti kowu tawa boboyen wosawor: “Kwota Jerusalem akaman opoche heechitanakech. Eeji Eepi riita mashi wotar maji na kowu ta. Ada eena kwona mashi wor. ");
INSERT INTO kmo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ukuk ukuyeechir. Wowak, komas kwona Holi Spiritek uku yeechikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposel yecha Jisas riitaka ya yopo wuchi yicharek, yecha riina woher, “Harapa Ma, kapo apa miita God riiti siitii kowu tawa boboyen Isrel yenya awasen hakiita?” ");
INSERT INTO kmo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Worek, Jisas rii yenya eecha wor, “Sokwa tawa nedii eeta Apoko riiti yo. Kwotikasakech. Kwo eecha hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wowak, eeta Holi Spirit riita kwotak yanak, kwo hapaga tawa pawa takiikiisiikiita. Takiikiisiinak, kwopa Jerusalem akamak, Judia nosapek, Sameria nosapeka, akar eyey nosapeka kwopa eeji hin geenyik sawo takiita.” ");
INSERT INTO kmo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Worek, yecha riina hechari, God riita riina yeechi yeyowurek, hejegwayap gamur. ");
INSERT INTO kmo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yecha neeren mo maka hecharek, rii icharek, ma upurus apoma siivatabi ruwuchi ya bana bana siitii yenya wor: ");
INSERT INTO kmo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galili ma, kwo neren boyak siitii mo hech? Eeta Jisas rii kwona heechi nerek iwey, komas riipa eechaba ya sakakiita. Rii nerek irega riipa eechaba yakiita.” ");
INSERT INTO kmo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Worek, aposel yecha Oliv Kwowuk heechi Jerusalem akamak ir. Oliv Kwowu eeta bana bana tar eem. Wowak, Ju ma ye sabat yadiik chishitarek, eeta bana bana tar eemek. ");
INSERT INTO kmo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yecha Jerusalem akamaka iyarechi yechi tar aka howuk eeka ir. Pita, Jon, Jems, Endru, Pilip, Tomas, Batolomyu, Matyu, Jems, Alpiyas riiti yikapwa, Saimon Selot, Judas, Jems riiti yikapwa yecha eecha tar. ");
INSERT INTO kmo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yecha ya yopo yichitarek, ye God riina maji batar. Yecha mima kawka, Maria, Jisas riiti awi, Jisas riiti kumwoy yechaka ya yopo yichi God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Eeta nedii Jisas riina hiki siitiichichar ma yecha ya yopo yichar. Eeta 120 ma mima ye ya yopo yicharek, Pita riita siitii wor: ");
INSERT INTO kmo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Eeji yaka kumwoy na meeji. Eeta Holi Spirit riita Devit riita keyir majik riita Judas riina wor’ Worek, keyir maji eeta sa sokwa. Judas riin hisiirek, rii noti yo kaswen otiiken eena hisiir. Hisiirek, kwotaka tar. Tarek, rii Jisas riina yeechi sowakwo nobon eena mukuchir.” ");
INSERT INTO kmo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Riita diita kapasek yon otiir yak rii noaspen tokor. Tokochi rii eeka sakar. Sakarek, riiti bii eeta piikar. Piikarek, riiti sugu wopu saka i ye yar. ");
INSERT INTO kmo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Worek, eyey Jerusallem akamak tar ma mima yecha meejir. Meejichi yecha Judas har nosap yechi majik eecha habar: Akelladama. Maji mu eecha wocho, “Pi Nosap.”) ");
INSERT INTO kmo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Sam keyir maji eecha wocho: ‘Riiti aka eeta biish siikiita. Ma ye i yikasakech.’ Keyir maji kawka eecha wocho: ‘Akar ma napa riiti yon kawka ya.’ ");
INSERT INTO kmo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Wowak, ma por rii notaka sa ya sii. Riipa eecha omutiik wokiita: An her Jisas rii sokwar. Riita notaka sa mashi eecha ta. Kata nedii Harapa Ma Jisas riita notaka chishi tarega, riita eechaba notaka tar. Jon riita uku yeechir tar nedii Jisas riina erek yeechi ye yo yi ir nedii riita notaka sa eecha ta.” ");
INSERT INTO kmo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Worek, ma upurusen hikitar. Ma por ri hi, Josep. Yecha riina haba tar, Basabas, akar hi pochi, Jastas. Ma por ri hi, Mataias. ");
INSERT INTO kmo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Worek, yecha God riina maji eecha wor: “God, mii hecho eyey ma inyaka wopu. Wowak, nona na mukuchi upurus tawa ma shecha mii kapo nona hisiichir. ");
INSERT INTO kmo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas rii God riiti yo kepin heechiniga riiti kapasek eemek ir. Kapo nama aposell riiti yon otiikiita?” ");
INSERT INTO kmo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Worek, yecha yechi otii tawa abok eecha sumowuchi, ye papa rabori he siikenek eena otiir. Otiirek, Mataias riiti hin hissir. Hisiirek, rii akar 11 aposel yechaka eecha ichar. ");
INSERT INTO kmo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Worek, Pentikos yadii yar. Yarek, Jisas riina hiki siitiichichar ma ye podat eemek ya yopo yichar. ");
INSERT INTO kmo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Worek, wosawosa nerek tari heechi ameya ya sakar. Sowaga eecha yar. Yari eeta yichar aka takiikiisiir. ");
INSERT INTO kmo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Worek, karakada hi tarekwoyiga eecha her. Herek, i ye yar. I ye yari, saniga saniga i ye yir. ");
INSERT INTO kmo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Worek, yecha Holi Spirit takiikiisiir. Takiikiisiirek, eeta Holi Spirit rii otiirek, yecha maji akar saniga saniga bar. ");
INSERT INTO kmo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nagwa nagwa hiki tar Ju ma ye akar akaman heechi Jerusalem akamabak yichar. ");
INSERT INTO kmo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Diita ma yecha diita wosawosa tar boboyen meejirek, eena nokwapa nokwapa ye ya yopo wuchi yichar. Yecha eyey nyegerabor. Yecha meejir ma ye yechi majik barek meejir eena ye nyegerabor. ");
INSERT INTO kmo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nyegerabochiniga, henebarabochiniga yecha eecha wor, “Kata ma yecha diita majik batawey ye eeta Galii ma. ");
INSERT INTO kmo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Boyewak yecha batawa maji noti majiga eecha meejito? ");
INSERT INTO kmo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nota Patia ma, Midia ma, Ilam ma. Nota Mesopotemia nosapek heechir. Nota Judia nosap, Kapadosia nosap, Pontas nosap, Esia nosap, ");
INSERT INTO kmo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prisia nosap, Pampiia nosap, Isip nosap, Sairini nosap Libia nosap har tawey, nota heechi ya tawa. Ma kaw Rom akaman heechi yar. ");
INSERT INTO kmo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nota Ju ma kaw. Nota shebo shebo tar ma kaw Ju ma yechi boboyen herin eena hiki siitiichichu. Ma kaw ye Krit nosap heechi yar. Ma kaw ye Arebia heechi yar. Wowak, nota meejitawey, yecha noti majik God riita harapa otiir boboyek bato.” ");
INSERT INTO kmo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hikisha tari, somoyetari, yecha awasen awasen wohe maji batar. “Boy boboyek otiitawak eeta maji eecha bato?” ");
INSERT INTO kmo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Worek, akar ma ye hiki siitiichichar ma yenya wokwoyarek wohega wor, “Yecha wain ukun aniga beyatar.” ");
INSERT INTO kmo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Worek, Pita rii 11 aposel yechaka eecha siitiichi harapa aya ma mima yenya uwa batar, “Ju ma, kwo Jerusalem akamak tawey, ada bana majin napa wagetey tanak, napa meeji ta. ");
INSERT INTO kmo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kwo eecha hik tawey, diita ma ye saka beyatawak. Dii eeta niyega nedii. ");
INSERT INTO kmo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wowak Piirapet Joel rii eeta boboyen eecha wor: ");
INSERT INTO kmo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God rii eecha wor: “Komas nedii adapa diita boboyen otiikiita: Ada eeji spiriten eyey yenya gwotiipowkiita. Gwotiipownak, kwoti yikapwa ye maji piirapet yecha batawaga eechaba batakiita. Anapa saniga saniga boboyen kwoti hadiiyey ma yenya mukuchikiita. Kwoti apokosaba ma yepa wa sukwi yakiita. ");
INSERT INTO kmo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ayo, kata nedii ada eeji Spiriten eeji wakasa man eeji wakasa miman yenya gwotiipowkiita. Gwotiipownak, yecha eeji maji sawukiita. ");
INSERT INTO kmo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ada harapa boboy mayakan howuk nerek otiikiita. Ada nosapen eechaka harapa boboy mayakan otiibakiita. Pi, hirika, he ye eecha takiita. ");
INSERT INTO kmo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ya niy siikiita. Niiwiika siipa nayim siik piga siikiita. Komas Harapa Ma riiti nedii yakiita. ");
INSERT INTO kmo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eeta nedii kata ma ye Harapa Ma riiti hin habatanak, riipa yenya yesokwa yichikiita.’ Wowak, piirapet Joe rii eecha wor. ");
INSERT INTO kmo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isrel ma, kwota diita maji na meeji. Ada Nasaret Jisas riina bato. God riita riina hisiirek, riita harapa nyegerabo tar boboy mayakan otiir. God riita otiirek, riita harapa siirenoboka eecha otiir. Kwotak otiir kwo hechi hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God riita riiti inyakak mapo hikichi otiirek, Jisas riina kwoti tapak how tar. Riina how harek, kwota riina sowakwor. Kapasek otii tar ma yecha riina mek ji siitii chir. ");
INSERT INTO kmo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Harek, God riita riina awasen yesokwar. Otii yesokwarek, Jisas riiti kapa meeji tawa boboyen ha tawa boboyen riita kwoyavar. Ha tawa eem eeta riina neekikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devit riita diita Jisas riiti majin eecha wor: ‘Ada hecho Harapa Ma rii adaka tawa. Riita eeji mama yepak tawa. Tawak ada akiikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Eena eeji inyaka wopu eeta kwoya hikitu. Ada maji batawey, an wopu sato. Ada mabak tawey, ada yihapakatawak Harapa Ma riin kowutu. ");
INSERT INTO kmo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Miita eeji mayin ha tawa eemek saka yeechi heechikiitawak. Miita miiti hehar otii tar Kepi Ma kwopa siitawa eemek saka yeechi heechikiitawak ");
INSERT INTO kmo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Miita eechaba eechaba takiitawa nobo ana mukuchir. Miita adaka eecha tanak, eeji inyaka iipa kwoya hikitakiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita rii kawka eecha wor: “Yaka kumwoy, ada noti wayega Devit riina kwona maji geenyik bakiita. Rii harek, eeta chirek, riiti tiiriimo apa notaka tawa. ");
INSERT INTO kmo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Rii eeta piirapet. Worek, rii God riita riina wochar majin hiki siitiichir. God riita riina wochar, Devit riiti neja por anapa otiiniga aka tabo yima siikiita. Riita tarebaga riiti neja riipa eechaba siikiita. ");
INSERT INTO kmo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit rii mashi her eeta boboyen God riitapa komas eecha otiikiita, rii Kraist saniyeechi sokwa tawa boboyen eena wor: ‘Riina ha tawa eemek saka yeechi heechirek. Riiti maba saka kwopa siirek.’ ");
INSERT INTO kmo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Diita Jisas riina God riita otii saniyeechi yesokwar. Eecha otiirin, nota her. ");
INSERT INTO kmo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Riina God riita riiti mama yepak yesokwa yichir. Yesokwa yichi riita riina Holi Spiriten har. Riina wocharin eena har. Ma mima akar majin batawey, no hecho apa riita nona gwotii tawey, kwota meeji taweyn, hechaweyn eena hawa. ");
INSERT INTO kmo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit riita diita majin wori, rii hevenek takasakech. Rii eecha wor, ‘Eeta God rii eeji Harapa Ma riina eecha wor, “Eeji mama yepak diika na yi. ");
INSERT INTO kmo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Yichanak, miiti o ana pichawa man ada otiiniga yepa miiti yatii seechitar worebega eecha siikiita.’” ");
INSERT INTO kmo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Worek, eyey Isrel ma mima sa hiki ta eeta Jisas riina kwota mek ji siitiichiri, God riita otiirek, rii eeta Harapa Ma siir. God rii otiirek, rii eeta Kraist.” ");
INSERT INTO kmo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma mima ye diita maji meejirek, yechi bii harapa nomoyar. Nomoyarek, yecha Pita riina anadii aposel yenya eecha woher, “Yaka kumwoy, nota boy shecha otiik?” ");
INSERT INTO kmo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita rii awasen wor, “Kwota eyey noti kapasek boboyen na kayek heechi Jisas Kraist riiti hik na uku yeetii ta. Wonyak, kwoti kapasek boboyen rii kwoyava yakiita. Wonyak, kwota God riita ha tawa boboyen, eeta Holi Spirit eena yakiita. ");
INSERT INTO kmo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God riita wochar boboyen kwona kwoti neja yenya har. Nokwapa nokwapa ma mima yepak tawey yenya har. Kata ma yenya noti Harapa Ma, noti God, riita mayama habatawey, wochar majin har.” ");
INSERT INTO kmo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita riita diita majin yenya wochar. Riita akar kiyapo majin yenya babatar. Rii eecha wor, “Kwo na mayama yesokwa yichi. Harapa kapasek otii tawa boboy diita kapasek tawa ma yechak yakiita. Opoche kwona diina yabatanakech!” ");
INSERT INTO kmo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Worek, nokwapa nokwapa ma mima ye riita sawor majin meejichi hiki siitiichirek, uku yeechir. Eeta 3,000 ma mima kaw yecha hiki siitiichirek, ye Jisas riina hiki siitiichichawa ma yenya ya yopo yichabar. ");
INSERT INTO kmo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Worek, yecha aposel yecha pokii tar majin meeji tar. Yecha awasen awasen kiyapotar. Awasen awasen a tar. Awasen awasen God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nokwapa nokwapa merikal nokwapa nokwapa nyegerabo tawa boboyen Aposel yecha otiir. God riita otiirek, yecha otiir. Otiirek, eyey ma mima ye henebarabor. ");
INSERT INTO kmo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Eyey Jisas riina hiki siitiichichawa ma ye awasen awasen kiyapochi otiitar. Yecha yechi sagan awasen kiyatayechi tar. ");
INSERT INTO kmo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yecha yechi saga akar man harek, yan yeechi Jisas riina hiki siitiichichawa ma yenya homachir. Ma yen dopotarek, eena homachi har. ");
INSERT INTO kmo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eyey yadii yecha Ju ma yechi lotu akak ya yopo yichir. Yecha yechi akak aboboy kwoya hikichiniga atar. ");
INSERT INTO kmo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yecha God riiti hin habaniga yesokwa yichitar. Akar ma ye yenya hechi kwoya hechar. Eyey yadii nedii God riita otiirek, ma mima kaw ye ya hiki siitiichicharek, ye Jisas riina hiki siitiichichar ma yenya ya yopo yichabar. ");
INSERT INTO kmo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yadii pochi 3 klok siirek, ma ye God riina maji batar nedii siirek, Pita, Jon piiriita harapa lotu akak ir. ");
INSERT INTO kmo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Irek, nubereja, siiti hi eeta kwoya hechawa nubereja, eeka yatii kapasek tar ma rii yichar. Rii yimowurek riiti yatii kapasek siir. Eyey yadii ma ye riina nuberejak riina kiya i seechitar. Kiya yar seechitarek, rii eyey ma mima God riina maji bak icharin, rii ye ya yan somak wochar. ");
INSERT INTO kmo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Riita Pita rii Jon rii piiriita i nubereja yarerek, rii piiriina yan woher. ");
INSERT INTO kmo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Woherek, piiriita riitaban mi he siitiichirek, Pita rii eecha wor, “Sinya na he!” ");
INSERT INTO kmo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Worek, riita piiriina hechi eecha hikir piir kapo ana boboyen hak. ");
INSERT INTO kmo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Worek, Pita rii riina eecha wor, “Ada ya biish. Wowak, adaka boboyen ada miina hak. Nasaret Jisas Kraist riiti hik ada miina wocho, Na sokwa siitii chishi ta.” ");
INSERT INTO kmo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Worek, Pita rii riiti tapak neekichi yesokwar. Worek, ma riiti yatii bogo riiti yatii eeta ameya hapaga siir. Siirek, rii ameya durer. ");
INSERT INTO kmo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ameya durechi yatiik piitiichi chishi i ye yar. Worek, rii harapa lotu akak piiriitaka eecha iyarer. Iyarechi durechishiniga God riiti hin harapa yesokwatar. ");
INSERT INTO kmo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Rii eecha otiirin, eyey ma mima ye riina her. ");
INSERT INTO kmo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yecha her rii kata ma rii ya wowohechari, kwoya hechawa nuberejak ye wowo hechar. Riina otiir boboyen yecha herin, yecha heneba rabochi nyegerabor. ");
INSERT INTO kmo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Otii kepi siir ma rii Pita, Jon piiriina neekirek, eyey ma mima nyegerabochi yechak amaba yar. Solomon aka moybi ya yopo wuchi ichar eemek eeka yar. ");
INSERT INTO kmo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ma yarek, Pita riita hechi rii eecha wor, “Isrel ma, boyewak kwo jecha otiir boboyen nyegerabor? Boyewak kwo sichaban hecho? Kwo kapo eecha hikitu sichi kepi tawa boboyek sichi hapaga tawa pawak kapo eeka otiitawak, ma kepi siichi chishitu? Yaho. ");
INSERT INTO kmo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraham riiti God, Aisak riiti God, Jekop riiti God, noti wayega yechi God riita riiti hevenek tawa hadabas boboyen riiti wakasa Jisas riina har. Worek, kwo riina gavman ma yenya har. Harek, Pailat riita riina maji wo wo hechi rii eecha hikir riina heemachinyak iken eena hikir. Worek, kwo riina nasowoyer. ");
INSERT INTO kmo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Riita yo kepi siikiinen otiitarin, kwo riina yuya nasowoyechi kwo Pailat riina woher, kapasek otii tar ma sowakwo tar ma riina na heemachi. ");
INSERT INTO kmo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Worek, kwo tawak kwo eyey boboyen otii yesokwa tawa ma riina kwo sowakwor. Worek, God riita otii saniyeechi yesokwar. Wworek, diita boboyen nota her. ");
INSERT INTO kmo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Riiti hi Kraist, riita hin hiki siitiichichawa boboy sii eeta man otiiniga hapaga siir. Kwo diita riina hecho. Ayo, Kraist riin hiki siitiichichawa boboy sii eeta kwoti mi somak diita man otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Eeji yaka kumwoy, ada hikitu kwota kwoti harapa ma ye Jisas riina kapasek otiirek, kwota somoyerek, eena eecha otiir. ");
INSERT INTO kmo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mashi mashi God riita otiirek, riiti piirapet ye eecha wor, eeta Kraist rii sapa kapa meeji tawa boboyen kiya. Rii eecha otiirek, diita nobo sokwar. ");
INSERT INTO kmo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Apa kwoti inyaka na dareboy ta. God riitak na dareboy ta. Dareboy tanak, riipa kwoti kapasek boboyen kwoyava yakiita. ");
INSERT INTO kmo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Wonyak, God riiti Spirit yanak, Harapa Ma riita kwotaka yanak, kwoti mayi eeta hapaga bor siikiita. Wonyak, riipa Jisas riina eeta Kraist riina kwona heechinak yakiita. Dii Jisas riin rii kwona hi siitiichir. ");
INSERT INTO kmo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Worek, riita hevenek i sa tanak, eyey boboy ye sokwa kepi siinak riipa kawka yakiita. Mashi nedii rii riiti piirapet yenya otiichirek, yecha diita majin bar. ");
INSERT INTO kmo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Moses rii eecha wor, ‘Eeta Harapa Ma, eeta kwoti God, riipa piirapet riina kwona heechinak yakiita. Riipa ma poren kwotaka taweyn riipa yesokwakiita. Kwopa riita eyey kana maji hapa meeji ta. ");
INSERT INTO kmo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kata ma ye diita piirapet riiti majin meejinan siiney, yenya God riiti ma mima yecha ya keyabochichi yakiita. Wonyak, God riipa yeechi yenya pi hamakiita.! ");
INSERT INTO kmo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Maji sawotar piirapet Samyuel riita, komas sokwar akar piirapet yecha diita nediik sokwar boboyen bar. ");
INSERT INTO kmo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Diita piirapet yecha God riita wochar majin sawotarek, yecha kwona bato. God riita kwoti wayega yenya nobon otiichiniga kwopagerabotar. Kwopagerabotarek, rii kwona kwopagerabobatar. God riita Ebraham wori, ‘Ada miiti neja yenya rukusii tanak, ada nosapek tawa ma yenya eyey eechaba rukusiikiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Worek, God riita riiti wakasan hisiirek, riita riina mapo heechirek kwona ir. Riita kwona rukusiitarek, kwota kapasek otii tar boboyen heechiken, eena kwona rukusiir. Kwo kepi siiken, eena otiir.” ");
INSERT INTO kmo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita, Jon piir mima ma yenya batarek, opelen otii tar ma ye, harapa lotu akan siitii kowu tar opisa ma rii, Sadyusi yecha piiriitak yar. ");
INSERT INTO kmo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Piiriita ma mima yenya Jisas riita hachi kawka saniyeechi sokwar majin sawotar. Eena yecha piiriina gwoyabawa maji batar. Piiriita batar maji eecha wochar ma yepa hachi kawka saniyakiita. ");
INSERT INTO kmo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Worek, yecha piiriina yeechi poko jir. Otiirek, eeta hogo nedii. Iyik kapo maji anasakiita. ");
INSERT INTO kmo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Worek, nokwapa ma ye sawo tar maji meejichi hiki siitiichir. 5,000 ma yecha hiki siitiichichar. ");
INSERT INTO kmo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yadii pochi yarek, Ju ma yechi harapa ma ye, lotu akan harapa tar ma ye, lon maji pokii tar ma ye Jerusalem akamak ya yopo yichar. ");
INSERT INTO kmo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Yecha harapa opelen otii tar ma Anas rii, Kaiapas rii, Jon rii, Aleksanda rii, akar harapa opelen otii tar ma riiti apoma ye yechaka ya yopo wuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Worek, yecha maji barek, piiriita yechi misomak siitii tar. Siitii tarek, yecha piiriina woher, “Dii otiir boboy ii shecha otiir? Boy hapaga boboy kichaka eecha tawa? Namey hik tawa?” ");
INSERT INTO kmo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita rii Holi Spirit takiikiisiichiniga yenya eecha wor: “Ma miman siitii kowu tawa ma kwo ana na meeji: ");
INSERT INTO kmo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Yatii kapasek tar ma riina yo toii kepi siir. Kwo sinya wo wohecho, riin boyega otii kepi siiri an sawok. Kwota na hiki eyey Isrel ma yecha sapa hiki ta: diita ya siitii tawa ma rii hehar kepi tawey, kwo misoman hewey, Nasaret Jisas Kraist riiti hik riiti pawak riin eeka otii kepi siir. Diita Jisas riin kwo mek ji siitii chirek, rii harek, God riita riina otii saniyeechi yesokwar. ");
INSERT INTO kmo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Eeta mashi keyir maji eeta Jisas riiti majin bar, ‘Kata papan yo otii tawa ma yecha rabori, apa rii eeta aka otii somar kwatii siir.’ ");
INSERT INTO kmo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ma ye yesokwa yichi tawa boboy eeta Jisas riitabak tawa. Akar hin God riita yesokwa yichi tawa boboyen diita eyey nosapek tawa ma yenya saka harek. Nota hevenek ik otiiney, Jisas riiti hik nota na i.” ");
INSERT INTO kmo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kaunsil ma meejichi ye haneba rabor. Pita, Jon piiriita siitii anabeyichi maji hapagan sawo tar. Piiriita hokwa pokii eem saka irek. Piir sobo tar ma. Eena yecha heneba rabor. Worek, yecha hechi hikir mashi piiriita Jisas riitaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Worek, yecha maji saka barek. Yecha heri otii kepi siir ma rii Pita, Jon piiriitaka eecha siitiir. ");
INSERT INTO kmo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Worek, yecha piiriina wochirek, yecha geenyik ir. Irek, kaunsil ma ye awa awa maji batar. Ye eecha wor, ");
INSERT INTO kmo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Piiriina nota boy shecha otiik wonyak? Eyey ma mima Jerusalem akamak tawey, eecha hikitu diita hapaga otii tawa mirakel piiriita eena otiir. Nota eena dagiir poyekasakech. ");
INSERT INTO kmo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wowak, opoche ddiita maji akar eemek i ye yatanakech. Eena nota na piiriina na anachek owpoy sii ta. Piir akar man Jisas Kraist riiti hin opoche batanakech.” ");
INSERT INTO kmo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Worek, yecha piiriina kawka wochirek aka wok i yarer. I yarerek, yecha piiriina owpoy sii maji bar, “Ki opoche Jisas riiti hin kawka habatanakech, riiti hik maji pokiitanakech.” ");
INSERT INTO kmo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Worek, Pita, Jon piir yenya eecha wor, “Kwotaba saniga na hiki: God riiti mi somak hechawey, sicha boy kwoti nobok ik? ");
INSERT INTO kmo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wowak, sicha herin, meejirin, kuja diimiikasakech eena sawoto. Kwota na hechi anasa. Nama nota kapo sumowuta? Kapo God riina, kapo kwona?” ");
INSERT INTO kmo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Worek, kaunsil ye meejichi harapa owpoy mayaka siirek, piiriina heemachir. Piiriina maji anasa nobokasakech. Eyey ma mima ye God riiti hin yesokwatarek, yecha piiriina anasa poko jinyan akiir. ");
INSERT INTO kmo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kata ma riina piiriita otii mirakel kepi siiri, rii 40 sukwiya siir. ");
INSERT INTO kmo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita, Jon piiriina heemachirek, piiriita piiriiti apomak awasen heechi ir. Irek, piir harapa opelen otii tar ma ye, Ju ma yechi lotu harapa ma ye, piiriina otiir boboyen piir eena apoman sawor. ");
INSERT INTO kmo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yecha meejichi kikibak God riina maji batar. Ye eech wor, “God mii Harapa Apoko. Mii diita nosapen, uku boro, neeren eyey boboy eeka taweyn mii otiir. ");
INSERT INTO kmo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Miita otiirek, eeta Holi Spirit riita noti wayega Devit riiti kujak maji bar. Rii eecha wor, ‘Boyewak shebo tawa ma yechi inyaka kwotayir? Boyewak ma mima yecha inyakak raga hikichi somoyeto? ");
INSERT INTO kmo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Diita nosapek tawa aka tabo yi ma ye ya yopo wuchi yicharek, yecha miina, Harapa Apoko, miiti Kraist riina o ana pi dagiir poyeken eena otiir!’ ");
INSERT INTO kmo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Eepi miita Jisas riina hisiirek Kraist sokwar. Worek, Herot riita Pontias Pailat riita piiriita diita akamak ya yopo wurek, shebo shebo tar ma yecha, Isrel ma yechaka kikibak ya yopo wurek, ye miiti wakasa ma kepi, Jisas, riina dagiir poyer. ");
INSERT INTO kmo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Miita mapo miiti inyakak hikichiniga miita miiti pawak otiichirek yecha ya yopo wuchi yichiniga otiir. ");
INSERT INTO kmo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Apa, Harapa Ma, yecha nona o maji barin eena na hiki tanak, miiti wakasa ma nona na kiyapo tanak, miiti majin nota anabeyichi siitiiniga sawotakiita. ");
INSERT INTO kmo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Miita na miiti tapan danagwachi man na otii kepi sii. Kepi siinak, mirakel, heneba rabo tawa boboyen miiti wakasa ma kepi, Jisas riiti hik otiinak, kepi siikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yecha God riina maji ba hamarek, ya yopo yichi tar eemek eeka howor. Yecha Holi Spirit riina takiikiisiirek, yecha God riiti majin anabeyechi siitiiniga sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisas riina hiki siitiichichar ma ye inyaka chegebak tar. Ma por rii saka eecha barek, kata boboy eeji. Eyey ma ye yechi boboyen homachi hapwoy pakar. ");
INSERT INTO kmo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Haraga pawa yechaga tarek, Aposel yecha Harapa Jisas riita saniyeechi sokwar boboyen eena sawotar. Sawotarek, God riita riiti hadabas boboyen yechak gwotiir. ");
INSERT INTO kmo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Worek, ma por rii yechak tari, rii aboboy dopokasakech. Kata ma ye nosapek tar, akak tar, ye eena tokochi yan yeechi. ");
INSERT INTO kmo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Aposel yenya har. Harek, yecha yan homachi hapwoy pakar. ");
INSERT INTO kmo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Worek, ma por rii tarek, riiti hi Josep. Rii eeta Livai ma. Rii Saipras nosapek riina yimowur. Aposel yecha riina habatar, Banabas. Riiti hi maji mu eeta eecha wocho, ‘Kiyatay tawa ma.’ ");
INSERT INTO kmo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Rii riiti nosap pochin tokochi yan yeechi aposel yenya har. ");
INSERT INTO kmo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Worek, ma por rii tar riiti he eeta Ananaias. Riiti mima siiti hi eeta Sapaira. Riiti nosap pochin tokochi ");
INSERT INTO kmo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","yan yeechi ya kawen rii egesiir. Riiti mima sii eeta inyaka hikibatar. Worek, rii ya kawen aposel yenya har. ");
INSERT INTO kmo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Worek, Pita rii riina eecha woher, “Ananaias, mii boyewak Gaba rii miiti inyakan kapasek otiiwak, mii nosapen tokor ya kawen mii egesiir? Miita Holi Spiriten riina woshipiir. ");
INSERT INTO kmo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mashi eeta nosap eeta miiti. Eeta nosap mii tokochi mii yan yeechi eeta ya eeta miiti. Boyewak miita diita kapasek otii tawa boboy mii inyaka hikichi otiir? Mii ma yeban saka woshepiitawak. Mii God riina woshepiir.” ");
INSERT INTO kmo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Worek, Ananaias rii meejichiniga haniga sakar. Worek, eyey ma ye meejichi harapa akiitar. ");
INSERT INTO kmo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Worek, hadiiye ma ye i wok yar yeechiniga maban siivatabik jichi kiya saya i chir. ");
INSERT INTO kmo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Awa piiriichar hamarek, riiti mima sii yar. Yarek, riin otiitar boboyen sii saka hikitarek. ");
INSERT INTO kmo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Worek, Pita rii siina eecha wor, “Ana na wo, diita ya diika tawey, kicha yeechi nosapen tokori, ii kapo kikisiir?” Sii awasen eecha wor, “Ayo, eeta eyey kikisiir.” ");
INSERT INTO kmo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Worek, Pita rii siina eecha wor, “Ki boyewak ma riitaka God riiti Spiriten otii otii hecho?” Niji man ye i tiiriimok chichar ma yepa ya nuberejak siitii kowutawak, yecha ninya eechaba yeechi kiya ibakiita.” ");
INSERT INTO kmo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Worek, sii eeta ameya ha sakar. Ha sakarek, hadiiye ma ye i yar hechi siin yeechi kiya i ma riina chir tiiriimo bana bana tarek siin iibak chir. ");
INSERT INTO kmo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eyey Jisas riina hiki siitiichichar ma ye, akar meejibatar ma ye, eena hechi ye harapa akiitar. ");
INSERT INTO kmo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nokwapa nokwapa mirakel heneba rabo tawa boboy aposel ye ma mima yechaka eecha otiitar. Eyey Jisas riina somowu tawa ma yecha ye saka yaniga yechaka eecha yopo wuchi yichar eemek yar. ");
INSERT INTO kmo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wowak, anadii ma ye saka yaniga yechaka eecha yopo yirek. Wowak, ma ye yenya inyaka kepi hikir. ");
INSERT INTO kmo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wowak, ma kawka ya yepak yi nokwapa nokwapa ma mima ye Jisas riina hiki siitii chichar. ");
INSERT INTO kmo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposel ye eeta yon otiitarek, hak otii tar ma mima yen yeechi kiya i nobok yimaka cheyaka eecha seechitar. Yecha hikitar Pita rii nobok yanak riiti mayik gamuk eena yenya seechitar. ");
INSERT INTO kmo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nokwapa nokwapa ma mima ye Jerusalem akama bana bana tar. Ye anadii akamak tar. Ye yeechi hak otiitar man yeechinga yayabar. Ye kapasek gabaka tar ma yen yayabar. Yayabarek, yenya otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Worek, harapa opelen otii tar ma rii, riiti nareboy ye, Sadyusi ma kaw ye, Aposel yenya kwotayer. ");
INSERT INTO kmo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Worek, yecha yenya yeechi poko jir. ");
INSERT INTO kmo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Poko jirek, niy nediik God riiti ejel yar. Yarek, rii poko ji aka nuberejan tagwachi rii nobon mukuchichi maji eecha wor, ");
INSERT INTO kmo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kwo na i harapa lotu akak na siitiichi ma mima yenya na diita akar nobon napa sawo ta!” ");
INSERT INTO kmo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Worek, Aposell ye meejichi uhadiirek harapa lotu akak i yarechi yen maji pokii tar. Worek, harapa opelen otii tar rii riiti nareboy ye akar Ju ma yenya neeki yesokwa tar ma yen uwa yayarek, kaunsil ma ye ya yopo wuchi yichar. Worek, yecha poko jichar aka maji heechirek ir. Aposel yenya yeechiniga yayaken eena wochirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Worek, plisman ma ye poko jichar akak i yareri yecha aposel yenya saka herek. Worek, yecha awasen i kaunsil ma yenya maji sawor. ");
INSERT INTO kmo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Noti poko jichar aka i yarewey, no hewey, nubereja hehar dasiipiitar eyey siitii kowu tar ma nuberejak siitiitar. Worek, nota nubereja tagwachi no heri ma ye takasakech.” ");
INSERT INTO kmo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Worek, harapa lotu aka siitii kowu tar plisman rii, harapa opelen otii tar maka ye eecha hikitar dii boy boboy diita Aposel yenya otiiwa? ");
INSERT INTO kmo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Worek, ma por rii yari eecha wor, “Na meeji. Kata ma yen kwo pokii jichari, ye i harapa lotu akak siitiichi ma mima yenya maji poko tar.” ");
INSERT INTO kmo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Worek, plisman harapa rii, riiti wakasa ma ye heechi i Aposel yenya kawka yeechi yayar. Harapa o maji ba woksakech. Pikasakech. Yecha akii eecha hikitar ma mima ye kapo nona papak rabokiita eena eshar yeechi ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Worek, yecha Aposel yenya yeechi aka wok ya yarerek, yecha kaunsil ma yechi mi somak siitiir. Siitiirek, harapa opelen otii tar ma rii maji wowo hechar. ");
INSERT INTO kmo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Rii eecha wor, “Nota kwona harapa maji wo sawotar kwo kata ma riiti hin opoche maji pokiitanakech. Wowak, kwo kwota otii tar boboyen na he. Kwo Jerusalem akamak kwoti majin eena takiikiisiir. Kwo eecha wocho nota kata ma riina pi sowakwor.” ");
INSERT INTO kmo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Worek, Pita rii anadii Aposel ye awasen eecha wor: “Nota God riina na sumowu ta. Man nota opoche sumowutanakech. ");
INSERT INTO kmo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Noti wayega riiti God rii Jisas riina otii saniyeechi yesokwa yichir. Kwo riina mek ji siitiichirek, rii harek, God riita otiichirek, rii saniyeechi yesokwar. ");
INSERT INTO kmo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Otiichirek, rii Jisas riina mama yepak yichir. Yichirek Jisas rii eeta man neeki yesokwa tawa ma, rii eeta man yesokwa yicha tawa ma, siir. Siirek Isrel ma ye yechi kapasek boboyen heechiken. Kapasek boboyen kwoyavaya ya tawa noboka apa eecha tawa. ");
INSERT INTO kmo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nota diita boboyen hechi meejichi eena sawoto. Eeta Holi Spirit rii sawobato. Eeta ma ye God riiti majin sumowutawak, God riita yen Holi Spiriten hakiita.” ");
INSERT INTO kmo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Worek, kaunsil ma ye diita maji meejichi inyaka harapa kwotayer. Kwotayechiniga hikitar Aposel yenya sowakwoken eena hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Worek, ma por rii yechaka tar, riiti hi Gameliel. Rii eeta Peresi. Riita lon maji pokii tar. Ma mima ye riina hehar hiki tar. Rii siitii tar. Siitiichiniga rii eecha wor, “Aposel yenya yeechi geenyik sabak ye i ameda kow.” ");
INSERT INTO kmo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Worek, rii kaunsil ma yenya yeechi eecha wor, “Isrel ma kwo na kata man na eshar hikichi otii ta. ");
INSERT INTO kmo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mashi Tiudas riita sokwa tar. Tarek rii eecha hikichi wor, ‘An harapa ma.’ Worek, 400 ma ye riina sumowutar. Worek, riin sowakwor. Sowakworek, riina sumowutar ma ye heechi i ye yar. Worek, riiti yo eeta sobo sakar. ");
INSERT INTO kmo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Komas anadii ma, riiti hi Judas, Galili ma, rii sokwa tar. Ma hin ya tawa nediik rii eeka sokwa tar. Ma mima ye riina sumowubatar. Worek, riina sowakwobar. Sowakwobarek, riina sumowutar ma ye heechi i ye yar. ");
INSERT INTO kmo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wowak, ada kwona wocho, kwo kata tawa man na ow poy sii ta. Yenya na heechi. Yechi inyaka hiki tawa yecha otii tawa boboy eeta shebo shebo mak otiichichaney, siii eeta sakakiita. ");
INSERT INTO kmo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wowak, eeta boboy God riita otiichinyey, kwopa saka yenya dagiir poyekiitawak. Ii kwopa God riina yabu pi ma siikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaunsil ye Gameliel riita bar majin meejichi ye sumowutar. Worek, Aposel yenya uwarek, ye yarek, yenya kubuk pir. Pirek, yenya wor, “Jisas riiti hin geenyik bakasakech.” Worek, yue yenya heemachirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposel ye iniga inyaka kwoya hiki tar. God riita yenya kwoya hecharek, ye Jisas riiti hik yecha kapa meeji tarin eena kwoya hikir. ");
INSERT INTO kmo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Worek, eechaba eechaba nedii ye harapa lotu akak, yechi akamak eechaba, ye eecha sawo tarek, pokii tar: “Jisas rii eeta Kraist.” ");
INSERT INTO kmo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Komas nokwapa nokwapa Jisas riina sumowu tar ma ye yar. Worek, Grik maji batar Ju ma ye, Hibru maji batar ma ye awasen awasen o maji batar. Grik maji batar ma ye eecha wor, “Noti mibiya mima yecha boboyen hoyet. Eyey yadii aboboyen homachichawey, mibiya mima ye sabor yakasakech. ");
INSERT INTO kmo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Worek, 12 Aposel ye eyey Jisas riina sumowu tar man uwarek, eyey yar. Yarek, ye eecha wor, “Boyewak nopa God riiti maji heechi nota aboboyeban homachichu? Ii eeta kapasek. ");
INSERT INTO kmo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wowak, yaka kumwoy, 7 man na keyibo. Mama yepak nagwa nagwa hiki tawa ma yenya Holi Spirit takiikiisiir ma yenya na keyibo. Kwo keyibonak, nota wonyak, yecha diita yon kiyakiita. ");
INSERT INTO kmo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wowak, eena eyey nedii nota Aposel na God riina ba ba tanak na sawo ta.” ");
INSERT INTO kmo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Aposel yecha bar majin kwoya meejichi yecha Stiven riina hisiir. Riita kapaga hiki siitiichicharek, Holi Spirit eeta riina takiikiisiir. Hisiir ma kaw ye hi diitata: Pilip, Prokoras, Naikena, Taimon, Pamenas, Nikolas. Nikolas rii eeta Antiok ma. Mashi riita shebo shebo tar ma tarek, worek rii eeta Ju ma siir. ");
INSERT INTO kmo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Worek, yecha Aposel yechi mi somak siitiirek, Aposel yecha yenya God riina maji batarek, tapak how seechitar. ");
INSERT INTO kmo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Worek, God riiti maji diita nosap kawek i ye yatar. Jerusalem akamak nokwapa nokwapa ma kaw ye yechi inyaka dareboyechi Jisas riina hiki siitiichi tar. Nokwapa nokwapa opelen otii tar ma ye inyaka dareboyechi hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiven riina God riita rukusiitarek, hapaga pawa rii takiikiisiir. Worek, riita harapa mirakel heneba rabo tawa boboyen ma mima yechaka otiir. ");
INSERT INTO kmo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Worek, ma kaw ye riina maji owk o ana pichar. Kata ma ye lotu aka pochik ichar. Yecha eecha akan habatar Frima Yechi Aka. Sairini Ju Ma ye Aleksandria Ma ye eeka ya yopo yichar. Yecha, Solisia ma yecha, Esia Ma yecha Stiven riina o maji bar. ");
INSERT INTO kmo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eeta Holi Spirit riita Stiven riina harapa hiki tawa boboyen riina harek, Stiven riita yenya awasen barek, yecha saka riina awasen batarek. ");
INSERT INTO kmo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eena yecha kapasek hikichi ma kaw yenya hiyik moni har. Stiven riina woshepii maji baken eena moni yenya har. Harek, moni yatar ma ye eecha wor, “Nota meejir rii eecha Moses riina lon maji wosowoyer. God riina wosowoyer.” ");
INSERT INTO kmo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eeta nobok yecha ma mima yechi inyaka, neeki yesokwa tawa ma yechi inyaka, lon maji poko tawa ma yechi inyaka, eena otiirek, yechi inyaka kwotayer. Worek, yecha Stiven riina neeki yeechi kaunsil ma yenya ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Worek, kata ma ye eecha wor, “Diita ma Stiven rii eechaba eechaba kapasek majin noti harapa lotu aka kepin bato. Noti lon kapasek majin babato. ");
INSERT INTO kmo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nota meejir rii eecha wor, ‘Nasaret Jisas rii diita harapa lotu akan diigiikiita. Riipa nota otii tawa abo Moses riita nona harin riipa rabokiita!” ");
INSERT INTO kmo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Worek, kaunsil akak yichar ma ye Stiven riina hechar. Hechari, Stiven riiti misoma ejel misomaga eecha her. ");
INSERT INTO kmo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Worek, harapa opelen otii tar ma rii Stiven riina woher, “Diitamaji ada meejiri, iiboy kapo maji siiken?” ");
INSERT INTO kmo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Meejichirek, Stiven rii maji awasen eecha wor, “Yaka kumwoy, apoko ana meeji. Hadabas boboyotii tawa God kepi rii mayama Ebraham riina mukuchir. Ebraham rii Mesopetemia nosap tarin Heran nosapek rii saka icharek, Godriita mayama riina mukuchir. ");
INSERT INTO kmo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Rii rrina eecha wor, ‘Miiti magwi yenya na hyeechi miiti nosapen na heechi. Ada miina mukuchinya nosapek napa heechi i! ");
INSERT INTO kmo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Worek, Ebraham rii Kaldia nosapek heechi Heran nosapek iyir. Eeta yicharek, riiti apoko rii harek, God riita worek, Ebraham riita Heran nosap heechi kwota yichawa eemek riita yichar. ");
INSERT INTO kmo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Eeta nedii Godriita Ebraham riina diita nosapen saka harek. Riina saka kaw kada harek. Worek, God riita riina eecha wochar: ‘Komas ada miina diita nosapen hakiita. Hanak, miiti neja na yepa eeka siikiita.’ Eeta nedii God riita riina majin wochari, Ebraham rii yikapwakasakech. ");
INSERT INTO kmo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God riita Ebraham riina eecha wor, ‘Miiti neja ye anadii ma yechi nosapek eeka yichakiita. Yichanak, yecha yo otii wakasa ma siikiita. 400 sukwiya eeka tanak, tawa ma ye yenya kapasek boboyen otiikiita. ");
INSERT INTO kmo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yichanak, kata ma yenya yecha yon kiyataye takiita eena yen an anaseechi pikiita. Wonyak, komas miiti neja kata nosapen heechi diita nosapek yanak, yecha Eeji hin yesokwatakiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Worek, God riita Ebraham riina kwopagey rabo tawa boboy seerenobon riina har. Har seerenobon diitata: Sapi kawen diigii raboto. Eena Ebraham rii riiti yikapwa Aisakriiti sapin diigii rabor. Yikapwa rii wik pochi siirek rii sapi diigii rabor. Worek, Aisak rii Jekop riiti apoko siir. Siirek, Jekop riita riiti 12 yikapwan, noti harapa wayega apoko siir. ");
INSERT INTO kmo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Worek, noti wayega harapa yecha Josep riina inyaka kapasek anadii ma yenya heechirek tokor. Tokorek, Josep rii i Isip nosapek i shebo shebo yo otii wakasa ma siir. ");
INSERT INTO kmo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Siirek, God riita riitaka bana bana eecha tar. Tarek, kapasek boboy riitak yatari, rii hehar tar. Worek, Josep rii Pero, Isip harapa aka tabo yima, riiti mi somak ir. God riita riina rukusiirek, Josep rii nagwa nagwa hikichi rii kepi otiitar. Worek, Pero rii riina hechi Josep riina harapa gavman ma otiichir. Ottichirek, Josep rii eyey isip man hehar otiitar. Pero riiti akama boboy saga, ma miman hehar otiitar. ");
INSERT INTO kmo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Worek, harapa eecha ha tar nedii yar. Isip nosapek Kenan nosapek eeka yar. Yarek, nokwapa nokwapa mamima ye harapa kapa meeji tar. Worek, noti wayega ye aboboy doporek, yesha hipur. ");
INSERT INTO kmo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Worek, Jekop rii meejir noku Isip nosapek eeka tarek, rii noti wayega yenya wochirek, ye mapo ir. ");
INSERT INTO kmo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Komas ye kawka ir. Irek, Josep rii mayama riiti yaka yenya mukuchir. Worek, Pero rii her. Hechi rii eecha hikir Josep riiti magwi. ");
INSERT INTO kmo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Worek, Josep rii riiti apoko Jekop, riina majin wochirek ir. Riiti magwi ye sapa Isip nosapek ya. 75 ma mima ye eecha tar. ");
INSERT INTO kmo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Worek, Jekop rii heechi Isip nosapek ir. Irek, rii noti wayega yecha eeka har. ");
INSERT INTO kmo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Komas yechi hapan yeechi Sikem akamak ye ir. Ye irek, eeka tiiriimo supuk eeka chir. Diita tiiriimo supu Ebraham riita tokor supu. Hemo riiti magwi yan harek, tokor. ");
INSERT INTO kmo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Mashi God riita Ebraham riina maji wochar. Wochar nedii bana bana yarek diita sokwar. Worek, nokwapa nokwapa noti ma mima eeka siir. ");
INSERT INTO kmo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Komas akar aka tabo yima rii Isip nosapen neeki yesokwatar. Rii Josep riina saka herek. ");
INSERT INTO kmo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Riita noti ye wayege yenya woshepii tar. Yenya kapasek otiitar. Rii noti wayege yenya wohigiyarek, kapasek otiirek, yecha yechi yikapwan yeechi sabak heechitarek, yecha hatar. ");
INSERT INTO kmo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Eeta nedii Moses riina yimowur. Riina kwoya hechar. Niiwiika piiriichar riita riiti apokio riiti akak tar. ");
INSERT INTO kmo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tarek, riina yeechi sabak heechir. Sabak heechirek, Pero riiti mima yikapwa siita riina he yeechi ye i akak seechirek, rii sokwar. Siiti yikapwaga eecha yeechi yesokwar. ");
INSERT INTO kmo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Riina eyey Isip ma yecha hiki tawa boboyen riina maji pokii tar. Pokii tarek, rii harapa siirek, maji kepin yo kepin otiitar. ");
INSERT INTO kmo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses riita 40 sukwiya tarek, rii riiti Isrel apoma yenya i heken rii gegiyar. ");
INSERT INTO kmo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Iri rii i her Isip ma rii Isrel ma poren kapasek boboy otiitar. Worek, rii Isrel ma riina kiyatayeken hikirek, rii Isip ma poren sowakwor. ");
INSERT INTO kmo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses rii eecha hikir riiti apoma hikitu God riita Moses riiti tapak Isrel ma yenya heemachikiita. Worek, ye saka eena hikirek. ");
INSERT INTO kmo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Eeta komas nedii rii her Isrel ma upurus piir o ana pichar. O ana picharek rii piiriina neekibiirachi ana cheker. Rii eecha wor, ‘Ki yaka kumwoy tawa. Opoche o ana pichankech?’ ");
INSERT INTO kmo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Worek, kata ma rii akar man kapasek boboy otiitarin rii Moses riina deginya poyechi eecha woher, ‘Nama miina nona neeki yesokwa ma siir? Anasa tawa ma siir? ");
INSERT INTO kmo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mii kapo ana sowakwobak? Mii Isip man yerek sowakworega ana kapo eechaba sowakwoken otiito?’ ");
INSERT INTO kmo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Worek, Moses rii meejichi Isip nosapek ameya heechi akii ir. Midian nosapeka eeka heechi ir. Eeka rii tarek, hoyey yikapwa rii upurus kiyar. ");
INSERT INTO kmo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Worek, 40 sukwiya kawka eeka tarek, ejel por riitak yar. Me biish tar eemek karakada meshikek hi eeka okoreetarek, eeka yar. Sainai kwowu eeka tar. ");
INSERT INTO kmo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Worek, Moses riita herin rii nyegetrabor. Worek, rii meshikek tar eemek rii bana bana siitii hek eena yar. Yarek, rii God ri ayan meejir. ");
INSERT INTO kmo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Rii riina eecha wor, ‘Ada miiti wayega yechi God. Ada Ebraham riiti God, Aisak riiti God, Jekop riiti God.’ Worek, Moses riita akii nubu nubur. Rii akiichi hekasakech. ");
INSERT INTO kmo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Worek, God riita riina eecha wor, ‘Miiti sun na kwoyava. Miita siitii tawa eem ii eeta ada tawa eem kepi. Opoche bana yatanakech. ");
INSERT INTO kmo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ada her eeji ma mima Isip nosapek harapa kapan meeji tawey. Ada her yecha visuwu taweyn eena ada yenya yesokwa yichiken ya sakar. Na sokwa ya. Ada miina Isip nosapek heechinak ik.’” ");
INSERT INTO kmo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stiven rii kawka eecha wor: “Diita ma Moses riina Isrel ma ye wosowoyer. Ye eecha woher, ‘Nama miina otii nona neeki yesokwa ma siir? Anasa tawa ma siir?’ Diita ma yecha wosowoyetari, God riita riina hisiirek, neeki yesokwa tawa ma siiken wochirek ir. God riita hi uwu tar meshikek otiirin Moses rii eena herek riin God rii eena heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Worek, riita ma mima yenya Isip nosapek heechi neeki ichar. Rii harapa mirakel Isip nosapek, Nayim Siik Tawa Soma Kwotiitawa Pan, me biish tar eemek 40 sukwiya wopu dareboy boboy eeka otiir. ");
INSERT INTO kmo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Eeta Moses rii Isrel ma mima yenya eecha wor, ‘God riita piirapet poren kwona heechinak yakiita. Rii ana kwona wochirek yarega riina eechaba wochanak yakiita. Riita kwoti ma siikiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Isrel ma mima ye me biish tar eemek tarek, Moses rii eeka tabatar. Rii noti wayega yechaka tar. Ejel por Sainai kwowu riina worek rii eeka tar. Riita God riiti yesokwa yichi tawa majin yeechi ya ya nona har. ");
INSERT INTO kmo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Worek, noti wayega yecha riina saka sumowutarek. Yecha riina deginya poyetarek, rii Isip nosapek heechi iken eena kaw hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Worek, yecha Eron riina eecha wor, ‘Miita na noti goden otiichinyak, yecha nona neeki ichakiita. Diita ma Moses riita nona yeechi Isip nosapek heechiri nota saka riina herek rii heechi iri kapo siitak ir?’ ");
INSERT INTO kmo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Worek, yecha bulamakaw yin god otiir otiirek yo opelen riitak otiitar. Noku sha ar. Yecha yechi tapak otiir boboyen heri, ye keena eena mayama rabachi yechi hin yesokwar. ");
INSERT INTO kmo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Otiirek, God riita yenya hechi yuyeechi magiir chir. Worek, yecha nerek tawa winyumay, ya, niiwiika, yechi hin yesokwa tar. Worek, piirapet yecha keyir maji eecha wocho, ‘Isrel ma mima kwo mashi 40 sukwiya me biish tar eemek, kwo ana bulamakaw sipsipen sowakwochi, ana saka harek. Yaho. ");
INSERT INTO kmo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kwota Molok chikiyawas riiti akan kiya ye i tar. Kwota Repan chikiyawas riiti winyumayka eechaba kiya ye i tar. Kwota chikiyawas otiichi yechi hin yesokwatar. Eena ada kwona heechinak Bebilon akama kata yepak heechinak ikiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“God riita yichawa aka noti yeyi wayega yecha eecha tar. Me biish tar eemek eeka tar. God riita Moses riina barek, aka yechi mayin riina mukuchirek, akan otiir. ");
INSERT INTO kmo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Komas noti yeyi wayega akan yechak yeechi ya yarek, Josua riitaka eecha ichiniga akar nosap ma yen pichiniga nosapen yar. God riita mapo kwoyava poyerek, ye komas yar. Worek, eeta aka yechaka eeka siir. Devit riiti nedii yarek, eeta eeka siir. ");
INSERT INTO kmo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Worek, Devit riina God riita rukusii tarek, Devit rii God riina woher, ada Jekop riiti God riiti akan kapo otiichikiita. ");
INSERT INTO kmo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Worek, Solomon rii God riiti akan otiichir. ");
INSERT INTO kmo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Worek, howuk tawa God riita ma otii tawa akan saka yichawak. Piirapet rii eecha wocho: ‘God rii eecha wocho: Neer eeta eeji harapa worebey. ");
INSERT INTO kmo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Diita nosap eeta eeji yatiin seechi tawa boboy. Shecha tawa yikadey akan ana kwo otiichikiita? Siitakay eemek ada ya yi hapakakiita? Kwopa saka kiki siikiitawak. ");
INSERT INTO kmo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Adaba diita eyey boboyen otiitar.’” ");
INSERT INTO kmo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven kawka eecha wor, “Kwi mabiya giisiitii tawa. Meejikasakech. Kwoti mesek wopu shebo shebo tawa. Kwo God riiti maji saka meejitarek! Kwoti yeyi wayega tarega kwo eechaba tawa. Kwo eechaba eechaba Holi Spirit riina wosowoyebato. ");
INSERT INTO kmo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Eyey piirapet yenya yeyi wayega yecha kikirepoyetar. God riita heechirek yar ma eeta piirapet ye wocho: God riiti otii kepi siik tawa wakasa ma riipa yakiita. Worek, yecha yenya sowakwor. Apa kwo riina nasowoyechi sowakwor. ");
INSERT INTO kmo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God riita riiti lon kwona eje yechi tapak how yar. Yari kwo eena saka sumowutarek.” ");
INSERT INTO kmo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaunsil ma ye Stiven riita bar maji meejichi harapa inyaka kwotayecniniga ye yechi pu riina giiriigar. ");
INSERT INTO kmo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Holi Spirit riita Stiven riina takiikiisiirek, Stiven riita neren mo heri, God riiti hadabas boboy her. Jisas rii God riiti mama yepak siitiitarek, rii her. ");
INSERT INTO kmo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hechi rii eecha wor, “Na he. Neren tagwawak, ada hecho Ma Yikapwa rii God riiti mama yepak eeka siitiito.” ");
INSERT INTO kmo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Worek, yecha harapa aya uwarek, yecha mabiyan giichi amaba i yecha Stiven riina neekir. ");
INSERT INTO kmo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Neekichi ye riina ye i sabak rabochi papak rabo pichar. Yecha eecha otiitarek, yecha yechi siivatabin kwoya veechi hadiiye ma por riiti yatii jumuk ye i yichir. Diita ma riiti he eeta Sol. ");
INSERT INTO kmo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yecha Stiven riina papak rabotarek, riita God riina uwatar, “Harapa Jisas miita eeji spirit na yeechi ye i!” ");
INSERT INTO kmo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Worek, rii saka yatii bogok putiichi harapa ayak eecha wor, “God, yechi kapasek yon mii boyakasakech.” Worek, rii har. ");
INSERT INTO kmo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol rii hechi riiti inyaka kwoya hikitar. Kata nedii Jerusalem akamak tar Jisas riina sumowu tar ma yen harapa kikirepoyetar. Kikirepoyetarek, eeta ma ye Judia nosapek Sameria nosapek i ye ya tar. Aposel ye Jerusalem eeka siir. ");
INSERT INTO kmo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jisas riina harapa hiki siitii chichar ma ye Stiven riina yeechi chichiniga ye harapa keyatar. ");
INSERT INTO kmo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Worek, Sol rii Jisas riina sumowutar ma mima yenya pi hamaken otiitar. Rii nokwapa nokwapa akan i yar hiki siitiichichar ma mima yenya yeechichi ye i poko jir. ");
INSERT INTO kmo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jisas riina sumowutar ma ye i ye yatarek, yecha God riiti majin sawo tar. ");
INSERT INTO kmo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip rii heechi i Sameria akamaka iniga eeka Kraist majin ma mima yenya sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Riita majin sawotarek, ye hehar meeji siitiitar. Meejichi riita nokwapa nokwapa wopu dareboy boboy otiitari yecha eena her. ");
INSERT INTO kmo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Riita otiitarek, kapasek gaba ye nokwapa nokwapa ma miman heechi ye harapa uwar. Yatii tapa kapasek tar ma yen otii kepi siir. ");
INSERT INTO kmo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Worek, ma mima Sameria akamak harapa kwoya hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kata akamaka ma por rii tar. Riiti hi Saimon. Tarek, rii siiga kapa otii tar kapasek boboyen mashi otii tarek, Sameria ma mima yecha riina heneba rabor. Rii eecha hikitar an eeta harapa ma. ");
INSERT INTO kmo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Eyey akamak tar ma mima karakada na harapa yecha riiti majin meejitar. Ye eecha wor, “Diita ma riiti harapa sii tawa boboy sii eecha habato: God riita harapa boboy mayaka.” ");
INSERT INTO kmo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Riita tiiti heneba rabo tawa boboyen rii eechaba eechaba otiitari, ma mima ye riiti majin hehar meejitar. ");
INSERT INTO kmo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Worek, yecha Pilip riita God riiti siitii kowu tawa hadabas maji kepin meejichi, Jisas Kraist riiti hin meejichi, ye hiki siitiichirek ye uku yeechitar. Ma mima yen uku yeechitar. ");
INSERT INTO kmo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon rii Jisas riina hiki siitiichibatar. Worek, riin uku yeechitar. Worek, rii Pilip riitaka bana bana i ye yatar. Pilip riita harapa otiir wopu dareboy boyen nyegerabotar boboyen Saimon riita eena hechi nyegerabochi nubu nubur. ");
INSERT INTO kmo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Worek, Aposel ye Jerusalem akamak tarek yecha meejir Sameria ma mima ye God riiti majin meejitar. Aposel ye meejichi ye Pita, Jon piiriina Sameria akamak wochirek piir ir. ");
INSERT INTO kmo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","I yarerek, yecha God riina maji bar. Jisas riina somowu tar ma yecha Holi Spirit riina yaken eena maji bar. ");
INSERT INTO kmo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Eeta Holi Spirit rii yenya mashi saka yarek. Yecha Harapa Jisas riiti hibak eeka uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Worek, piiriita tapan ye yo wurek Holi Spirit eeka yen yar. ");
INSERT INTO kmo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposel ye yechi tapan yenya ye wowurek Holi Spirit rii yechaka yarek, Saimon rii hechi Pita, Jon piiriin monik tokoken otiir. ");
INSERT INTO kmo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Rii eecha wor, “Diita hapaga tawa pawa ana napa haba! Habanak eeji tapan ye yowunak ma ye eechaba Holi Spirit yakiita.” ");
INSERT INTO kmo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Worek, Pita rii riina eecha wor, “Miita miiti monika eecha hi uwu tawa eemek eeka na i. God riita ha tawa boboyen miita yak tokokasakech. ");
INSERT INTO kmo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","God riiti misoma miiti mesekek wopu kapasek hecho. Eena diita yo miitakasakech. ");
INSERT INTO kmo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Miiti inyaka hiki tawa boboy na kayek heechinak na magiirechi. God riina na maji batanak riipa kapo miita hiki tawa boboyen kwoyava yeechikiita. ");
INSERT INTO kmo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ada hecho miiti kapasek bii owka tawa boboy, nokwapa nokwapa takiikiisii siitiito. Wowak miiti kapasek boboy eeta miina mayama poko jichu.” ");
INSERT INTO kmo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Worek, Saimon rii Jon Pita piiriina eecha wor, “Ada na God riina majin bachi. Bachinak, miita bawa kapasek boboyen ana yakasakech.” ");
INSERT INTO kmo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Worek, yecha yechi sawotar maji ba hamarek, God riiti maji sawotarek, Pita, Jon piiriita Jerusaem akamak heechi ir. Nobon ichari piiriita nokwapa nokwapa Sameria akamak eeka hadabas majin eena kenyi mukuchichar. ");
INSERT INTO kmo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","God riiti ejel por rii Pilip riina wor, “Na sokwaniga i. Saut yepak na i. Kata nobo Jerusalem akama heechi Gesa akamak napa i.” Diita nobo eeta me biish tar eem eeka tawa. ");
INSERT INTO kmo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Worek, Pilip rii sokwaniga heechi ir. Eeta nedii Itiopia harapa ma por rii riiti nosapek ichar. Eeta ma rii Itiopia nosap harapa ma. Rii aka tabo yi mima siiti ya kwon eena hehar heechitar. Siiti hi Kandesi. Rii Jerusalem akamak tari rii God riiti hin yesokwa baken eena yar. Worek, eeta nedii rii riiti nosapek awasen ichar. Karenga ichawa boboyek rii eeka ichar. Icharek, riita piirapet Aisaia God riiti majin kadii ichar. ");
INSERT INTO kmo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Worek, eeta Holi Spirit rii Pilip riina wor, “Miita na i kareka bana bana i.” ");
INSERT INTO kmo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Worek, rii amaba ichi rii meejir harapa ma rii piirapet Aisaia riiti majin kadiitarek, meejir. Meejichi rii eecha woher, “Mii boy kapo eeta maji mu hechawak, mii kadiito?” ");
INSERT INTO kmo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Worek, rii awasen eecha wor, “Ma ana mukuchinyan siiney, boyega shecha ada hekiita?” Worek, rii Pilip riina wor, “Miita ya sokwanak sicha eecha yik.” ");
INSERT INTO kmo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Harapa ma rii diita majin kadiitar. “Ye riina sipsip poren otii tawaga yeechi ye i akar eemek sowakwoken ye ichu. Sipsip yi por ri nebiin diigii tawaga, rii kuja hanakasakech. Rii maji bakasakech. ");
INSERT INTO kmo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Riina dagiir poyerek, yecha maji saka hehar anasarek riin. Ma yecha riiti yikapwa ma mima yenya sakapa sawotakiitawak. Riita nosap kawka takasakech. Rii yeechi ye ir.” ");
INSERT INTO kmo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Worek, harapa ma rii Pilip riina eecha woher, “Ana na wo. Eeta piirapet naman wocho? Rii kapo mayama wocho? Rii kapo anadii man wocho?” ");
INSERT INTO kmo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Worek, Pilip rii riina majin bar. Diita kadiir majin tasiirek, Jisas riiti hadabas jeyek tawa majin riina sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Piiriita nobok icharek, uku tar eemek iyarer. Iyarerek harapa ma eecha woher, “Uku diika tawa. Kapo apa ana uku yeechi?” ");
INSERT INTO kmo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip rii eecha wor, “Miita miiti eyey sugu wopuk Jisas riina hiki siitiichinyey, miita yak.” Worek, rii awasen wor, “Ayo. Ada hiki siitiichichu Jisas Kraist rii eeta God riiti yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Worek, harapa ma rii maji wosaworek, kar i siirek, harapa ma Pilip piir ye i ukuk uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yeetiichi piir awasen yesokwarek, God riiti Spirit Pilip riina yeechi ameya ye ir. Harapa ma rii riina saka kawka herek. Rii riiti nobobak iri riiganiga ir. ");
INSERT INTO kmo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Worek, Pilip rii Asdot akamak eeka i sokwar. Worek, rii i nokwapa nokwapa akaman hadabas majin sawo mukuchi ye i tar. Worek, rii i Sisaria akamak iyarer. ");
INSERT INTO kmo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Eeta nedii Sol riita Jisas riina hiki siitiichichar ma yenya kapasek ow maji batarek, yeb pi sowakwoken hikitar. Rii harapa opelen otii tar ma riin i jeyn yaken woher. ");
INSERT INTO kmo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Eeta yo otiik Sol riiti hin Damaskas Ju yechi lotu tar ma yenya mukuchir je majin. Sol rii Jisas riiti nobon sumowutar man Damaskas akamak hereyega, rii ma mima yenya pokok jichi Jerusalem akamak heechi awasen yaken eena rii woher. ");
INSERT INTO kmo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Worek, rii heechi Damaskas akamak ir. I akamak bana bana tarek, harapa haba nerek heechirek sakar; riina buyar. ");
INSERT INTO kmo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Buyarek, rii nosapek sakar. Sakachi rii ayan meejir, “Sol! Sol! Boyewak mii ana diigiir poyetu?” ");
INSERT INTO kmo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Rii meejichi eecha wor, “Harapa Ma, mii kapo nama?” Aya eecha wor, “Ada eeta Jisas. Mii ana dagiir poyetu. ");
INSERT INTO kmo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wowak, na sokwa akamak i. Inyak, miita otiina yon miina wokiita!” ");
INSERT INTO kmo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Eeta nedii Sol riitaka ichar ma ye i tar. Ye tari bakasakech. Ye ayan meejiri ma saka herek. ");
INSERT INTO kmo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Worek, Sol riita sokwa ri mi tagwari saka herek. Eena yecha riiti tapak yeechi Damaskas akamak neeki ir. ");
INSERT INTO kmo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yadii piiriichar rii riiti miy hekasakech. Eeta nedii rii aboboy akasakech uku akasakech. ");
INSERT INTO kmo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Worek, Damaskas akamak maji Jisas riina sumowu tar ma por rii tarek, riiti hi, Ananaias, Riita watarek, sukwiyar. Sukwiyatarek, eeta God riita riina eecha wor, “Ananaias! Rii awasen eecha wor, “Harapa, ada didika tawa.” ");
INSERT INTO kmo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","God rii eecha wor, “Na sayarechi nobo pochik eeka na i. Siiti hi, Nagwa Nagwa Nobo. Miita Judas riiti akak inyak, napa woher: kapo Sol, Tasas ma diika tawa? Rii God riiti maji bato. ");
INSERT INTO kmo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Riita sukwiyarek, rii her ma por rii, riiti hi Ananaias, riita i yareri, rii riiti tapan riina howu neekitarek, riiti mi kepi heken eena howu neekir.” ");
INSERT INTO kmo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias rii meejichi awasen eecha wor, “Harapa Ma nokwapa nokwapa ma ye ana wor: Diita ma rii miiti ma mima ye Jerusalem akamak tarin harapa kapasek boboyen otiir. ");
INSERT INTO kmo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Harapa opelen otii tar ma ye riina jeyn harek, rii Damaskas akamak iyareri riita miiti hin haba tawa ma miman yeechi poko jiken eena yar.” ");
INSERT INTO kmo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","God riita riina eecha wor, “Na i. Ada riina hisiirek, riita eeji yon otiitakiita. Riita eeji hin geenyik batanak, akar biish tawa ma ye, aka tabo yi ma ye eeji hin meejikiita. Isrel ma ye meejibatakiita. ");
INSERT INTO kmo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Adaba riina mukuchikiita: nokwapa nokwapa kapa meeji tawa boboyen eeji hik kiyachikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Worek, Ananaias rii heechi akak iyarechi riiti tapan Sol riina howu neekichi wor, “Kumwoy, eeta Harapa, eeta Jisas, rii ana wochuwak yawa. Miita diika yaterek nobok riina her. Miita miy kawka heken, Holi Spirit rii miina takiikiisiiken, eena ana heechuwak yawa.” ");
INSERT INTO kmo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Emiyep ganye tawaga tawa boboyek Sol riiti miyin tagwachi sakar. Sakarek, rii kawka mey maka her. Rii sokwa siitiirek, worek riina uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Worek, rii aboboyen a hamarek, rii hapaga siir. Yadii ameda Jisas riina sumowu tawa ma yechaka Damaskas akamak tari rii eeka siir. ");
INSERT INTO kmo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Riita ameya Ju ma yechi lotu akak i Jisas riiti majin yenya sawotar. Rii eecha wor, “Jisas rii eeta God riiti yikapwa.” ");
INSERT INTO kmo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma yecha riina meejiri ye heneba rabor. Heneba rabochi ye woher, “Ii boy eeta ma riita Jerusalem akamak tawey, rii Jisas riiti hin haba tar ma mima yen pichar? Rii boy kapo diika yawey, yenya eechaba yeechi poko jichi harapa opelen otii tawa ma yechak ye iken yar?” ");
INSERT INTO kmo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Worek, Sol riita kawka hapaka siichi God riiti majin yenya harapa geenyik kwodii wochar. Riita hehar mukuchi siikeney, Jisas rii eeta Kraist. Worek, Ju ma Damaskas akamak tari, ye riiti maji meejichi riina saka awasen maji barek. Saka kiki siirek. ");
INSERT INTO kmo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Worek, komas nedii Ju ma ye ya yopo yichi Sol riina sowakwoken inyaka hikitar. Yadii niy Ju ma ye akama nuberejak eeka riina ow yichar. Riina piken eena yichar. ");
INSERT INTO kmo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Worek, Ju ma yecha inyakak hikitarin Sol rii meejir. ");
INSERT INTO kmo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Worek, niy pochik Sol riiti apoma ye riina yeechi papa inyi sabak Pol riina kwowuk woyechi pokok kiitiichi heechirek, sabak saka ya muku siitiichi rii heechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Worek, Sol rii Jerusalem akamak irek, rii akar Jisas riina sumowu tawa ma yechaka yaya yopo yichiken otiitar. Worek, yecha riina akiir. Yecha riina saka eecha hikirek rii eeta Jisas riina sumowu tawa ma. ");
INSERT INTO kmo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Worek, Banabas rii ya riina kiyatayer. Rii riina Aposel yechak ye ir. Ye ichi rii yenya majin kwodii eecha wor. Sol riita Jisas riina nobok herin, Jisas riita riina majin worin, Banabas rii yenya eecha wor. Rii eechaba wor: Sol rii Jisas riiti hin Damaskas akamak riita anabeyichi sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Worek, Sol rii eeta yechaka eecha siir. Siirek, Jerusalem akama eem eyey rii chishi ye i tarek, God riiti majin Jisas riiti hik sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Riita Grik majik batar Ju ma yenya harapa majin yenya awasen awasen batar. Worek, yecha riina sowakwoken eena otiitar. ");
INSERT INTO kmo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yaka kumwoy wakasa ma ye meejichi yecha Sol riina yeechi Sisaria akamak ye i Tasas akamaka heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","PITA RIITA LIDA AKAMAK JOPA AKAMAK TAR ");
INSERT INTO kmo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita rii eyey eemen chishi ye i tarek, nedii pochi rii God riiti ma mima Lida akamak tari yechak eecha i her. ");
INSERT INTO kmo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Eeka tarek, rii ma por ri hi Inias riina her. Inias riita ma kapasiiniga bor yichar. Bor yicharek, rii riiti wa gwosii 8 sukwiya eecha watar. ");
INSERT INTO kmo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Worek, Pita riita riina hechi eecha wor, “Jisas Kraist rii miina kepi boboy otiito. Na sawo. Miiti wa eemen hehar yeechi.” Worek, rii meejichi ameya sokwar. ");
INSERT INTO kmo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sokwarek, eyey ma mima Lida akamak, Seron akamak, tari, ye eena hechiniga ye inyaka dareboyechi Jisas riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa akamak mima pochi sii eeka tarek, siiti hi Tabita. Sii Jisas riina hiki siitiichichar. Grik hik habatari Dokas. Eyey nedii siita eechaba eechaba boboy kepiban otiitar. Kiiriisiiposii tar man siitii kiyatayetar. ");
INSERT INTO kmo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Worek, eeta nedii sii hak otiiniga har. Harek, yecha siina yeechi ye i maba uku yeetiichi aka howuk ye yo cheyak ye i seechir. ");
INSERT INTO kmo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida akamak Jopa akamak bana bana tar. Worek, eeta hiki siitiichichar ma ye, Jopa akamak tarek, ye meejir Pita rii Lida akamak tar. Worek, yecha ma upurusen maji heechirek ye ir. Eecha wor, “Miita na ameya notak ya.” ");
INSERT INTO kmo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Worek, Pita rii sayarechi piiriitaka eecha ir. Rii iyarerek, yecha riina yeechi howuk ye yo ir. Worek, nokwapa nokwapa mibiya mima ye yaniga Pita riitaka bana bana siitiiniga keyatarecha siitii yenya hatar klos mukuchichar. Otiichichar saket mukuchichar. Siita yechaka tarek eeka otiichichar, yenya. ");
INSERT INTO kmo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Worek, Pita rii eyey tar ma mima yenya wochirek ye geenyik iyarer. Iyarerek, Pita rii yatii bogok putiichi rii God riina maji bar. Worek, rii dareboyechi siina eecha wor: “Tabita, na sokwa.” Worek, sii siiti miy tagwachi Pita riina hechi sii sokwa yir. ");
INSERT INTO kmo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita rii i tapak neekichi yesokwa siitiichir. Worek rii hiki siitiichichar ma yenya mibiya mima yenya uwachi siin tarebaga eecha siirek yenya har. ");
INSERT INTO kmo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Worek, diita otiir yo sii Jopa akamak eeka i ye yarek, nokwapa nokwapa ma mima ye Jisas riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita rii Jopa akamak nokwapa nokwapa yadii eeka tarek, ma por bulamakaw sapi yon otiitar ma, Saimon, rii riiti akak yichar. ");
INSERT INTO kmo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma por rii Sisaria akamak tari, riiti hi Konilias. Rii eeta Ro ma, harapa o anapi ma tar. Rii eeta kepten 100 o anapichar man Itali kompani habatari rii eena siitii kowutar. ");
INSERT INTO kmo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rii God riitaban hiki siitiichichar ma. Rii riiti magwi, ye God riiti hin yesokwatar. Riita kiiriisiiposii tar Ju ma yenya kiyatayetar. Rii God riina eechaba eechaba maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yadii pochi hogo sii nediik, 3 klok, rii sukwiyanaga eecha her. Riita God riiti ejel poren herek, rii riina eecha wor, “Konilias!” ");
INSERT INTO kmo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias rii hechi harapa akiiniga eecha wor, “Harapa Ma, mii boyek yawa?” Ejel rii awasen eecha wor, “God riita miita yeyada hatawey rii hecho. Miita God riina batawa majin rii hebato. Hechi rii miina kwoya hikitu. ");
INSERT INTO kmo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wowak, apa miiti ma kawen Jopa akamak sa i, ma poren wochinak, rii sa ya. Riiti hi eeta Saimon Pita. ");
INSERT INTO kmo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Rii bulamakaw sapin yo otii tawa ma riiti akak eeka tawa.” ");
INSERT INTO kmo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Worek, maji batar ejel rii heechi ir. Irek, Konilias rii riiti wakasa ma upurusen, o ana pichar ma poren yenya uwar. O ana pichar ma rii God riitaban hehar hiki siitiichichar. Riita Konilias riiti wakasa ma tar. ");
INSERT INTO kmo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Worek, Konilias rii ejel bar majin yenya sawochi, yenya Jopa akamak heechirek, yecha ir. ");
INSERT INTO kmo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Eeta komas yadii nediik yecha nobok icharek, Jopa akamak iyareken otiitarek, Pita riita akak yo i howuk God riina maji bak ir. Eeta otii a nedii. ");
INSERT INTO kmo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Worek, Pita rii eecha harek otii ak gegiyar. Aboboy otii tarek, rii kawka sukwi yanaga eecha her. ");
INSERT INTO kmo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Rii mow herek, neer tagwar. Tagwachi harapa siivatabi subu yepa yepa neekichi heechirek saka tar. ");
INSERT INTO kmo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Saka tarek, rii her nokwapa nokwapa apo, hopo, nosapek tawa kiya, boboy eeka tarek rii her. ");
INSERT INTO kmo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Worek, aya riina uwachi eecha wor, “Pita, na sokwa sowakwachi a.” ");
INSERT INTO kmo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Worek, Pita rii bokoneechi eecha wor, “Harapa, yaho. Ada saka keena akiitawak. Ada kapasek tawa kiya ada saka atarek.” ");
INSERT INTO kmo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Worek, aya kawka riina eecha wor, “Eyey boboyen God riita otii kepi siirin, mii boyewak kapasek wocho?” ");
INSERT INTO kmo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Diita boboy piiriichar otiir. Worek, eeta boboy eeta heechi ameya neerek i yowur. ");
INSERT INTO kmo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Worek, Pita riita diita sukwiyanaga hechar boboy siiti mun harapa hikitarek yeshatar. Eecha hikitarek, Konilias heechirek yar ma yecha Saimon riiti akan yesha yar. Yari yecha nuberejak bana bana siitiitar. ");
INSERT INTO kmo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yecha uwachi wor, “Diita kapo tawa ma riiti hi eeta Saimon Pita?” ");
INSERT INTO kmo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita rii sukwiyar maji mun hikitari, Spirit rii eecha wor, “Na meeji. Ma piiriichar ye diika yatawey miina yeshato, ");
INSERT INTO kmo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Miita mayama sayarechi na saka i. Ada yenya miina wochirek yar eena opoche mii siitii siitii siichi ichanakech.” ");
INSERT INTO kmo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Worek, Pita riita saka ichi ma yenya eecha wor, “Kata ma riina kwo yeshatawey, diita ada. Boyak yawa?” ");
INSERT INTO kmo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ye awasen eecha wor, “Kepten Konilias rii nona heechirek yar. Rii eeta ma kepi. Rii God riiti hin yesokwatar. Ju ma ye riina hehar hikitar. God riiti ejel por rii riitak ya wor: miita na Pita riiti akamak ya. Yanak, miita bana majin riita meejik.” ");
INSERT INTO kmo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Worek, Pita riita yenya worek, yecha niy pochi eeka siir. Komas yadii riita sayarechi yechaka ir. Akar Jopa Jisas riina sumowu tawa yaka kumwoy ye riitaka ibatar. ");
INSERT INTO kmo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Komas yadii pochi riita Sisaria akamak iyarer. Eeka Konilias riita riina kowutar. Konilias rii riiti magapa riiti apoma yenya worek, ye kowubatar. ");
INSERT INTO kmo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita riita wok iyarek otiirek, Konilias rii riina hechiniga Pita riiti yatii jumuk bana bana saka he yir. ");
INSERT INTO kmo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Worek, Pita rii riina yesokwa wor, “Na sokwa siitii. Ada eeta ma sobo.” ");
INSERT INTO kmo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piiriita aka wok iyarechi Pita rii maji batar. Iyarerek, rii her nokwapa nokwapa ma mima ye ya yopo wuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Worek, Pita rii yenya eecha wor, “Kwota hehar hikitu Ju ma yechaka kwotaka ya yopo yikasakech. Ju ma yechi lo maji sii Ju man anacheker. Anachekerek, yecha akar biish tawa man yechaka opoche yichanakech, opoche maji batanakech. Wowak, God riita ana mukuchir eeta kapasek ada hikitu ma mima kaw ye wagiishi chichu. ");
INSERT INTO kmo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwota ana maji wochirek yarek ada siitii siitii siikasakech. Eena ada kwona wohecho, boyewak kwota ana maji wochirek yar?” ");
INSERT INTO kmo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Worek, Konilias rii eecha wor: “Yadii 4 mashi siirek, eeta nediik ada God riina maji batar. 3 klok nedii siirek, ma por rii yari eeji mi somak siitiir. Riiti siivatabi apoma woy hechar. ");
INSERT INTO kmo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Worek, rii eecha wor: ‘Konilias, God riita miita God riina batawa majin rii hecho. Miita yeyada hatawa boboy rii hebato. ");
INSERT INTO kmo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Wowak, apa ma kawen Jopa akamak sa i. Ma poren wochinak rii sa ya. Riiti hi eeta Saimon Pita. Rii bulamakaw sapin yo otii tawa ma riiti akak eeka tawa. Rii somakwotii tawa paka bana bana tawa!’ ");
INSERT INTO kmo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Worek, eena ada miina maji wochirek ir. Wowak, miita hiki hamachi yawa. Apa nota God riiti miy somak diika tawey, nota miina kowutu. God riita miina batar majin miita nona sawoken no eena kowutu.” ");
INSERT INTO kmo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita riita eecha wor, “Ada hehar eecha hikitu eeta siiken God riita saka eecha hikitawak, ma por eeta harapoa ma por eeta karakada. ");
INSERT INTO kmo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Eyey ma ye God riina hehar hikitawak, yo kepin otiitawak, God riita yenya kepi hikitu. God riita man hechawey, rii saka riiti wayegan hechawak. Rii keena ma podar podareban hecho. ");
INSERT INTO kmo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kwo hikitu eeta maji God riita riiti Isrel ma mima yenya wochirek yar. Eeta maji eecha wocho: Jisas Kraist rii eeta eyey ma yechi God. Eeta maji inyaka kepi wey siikii tawa maji. ");
INSERT INTO kmo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kwo hikitu Jon Baptais uku yeechi tawa maji. Eeta sokwarek, harapa boboy eeka tasiir. Tasiirek, komas Judia nosapek eeka i ye yar. ");
INSERT INTO kmo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ii eeta Nasaret Jisas maji. Kwo meejir God riita riiti Holi Spirit riiti hapaga tawa pawak Jisas riina gamuchir. Gamuchirek, riita eyey eemek i ye ya tarek, boboy kepin otiichicharek, gaba riita dagiir poyer man rii otii kepi siichi yesokwa tar. God riita riitaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Worek, diita boboyen riita Ju ma yechi nosapek, Jerusalem akamaka otiitarek, no eena hechi sawoto. Worek, yecha riina ye i mek ji siitiichirek, rii har. ");
INSERT INTO kmo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Harek komas yadii piiriichar siirek God riita riina yeechi yesokwarek, ma ye opwoy her. ");
INSERT INTO kmo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Eyey ma ye riin saka herek. Eyey ma yen God riita hisiiri, riin her. God rii nona hisiiri, no Jisas riina herek apa no riiti majin sawoto. God riita riina yesokwarek, nota riitaka eecha otii atar. ");
INSERT INTO kmo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Worek, riita nona wochir diita hadabas majin ma mima yenya napa sawo ta. Riita nona wochir: napa yen sawo: Jisas riitaba eeta God riita hisiiri, rii eeta ha ma yechi jas rii eeta tawa ma yechi jas. ");
INSERT INTO kmo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Eyey piirapet ye riina majin wor. Ye eecha wor: eyey ma ye riina hiki siitiichinyey, yechi kapasek boboyen riiti hapaga tawa hik kwoyava yakiita. ");
INSERT INTO kmo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita riita majin batarek, eeta Holi Spirit rii eyey maji meejitar ma yechak sakar. ");
INSERT INTO kmo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jisas riina hiki siitiichichar Ju ma yecha Pita riitaka Jopa akamak heechi yari, ye hechi henebarabor. God riita riiti Holi Spirit akar biish tar ma harek, gwotii powubarek, eena henebarabor. ");
INSERT INTO kmo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yecha meejir ye akar akar maji ba ye tarin, ye God riiti hin eena yesokwatar. Worek, Pita rii eecha wor, “Nota eeta Holi Spirit riina yarega, yecha eechaba yawa. ");
INSERT INTO kmo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Kapo nama uku yeechi tawa ukun yenya anachekekiita?” ");
INSERT INTO kmo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Worek, riita wochirek, Jisas Kraist riiti hik yenya eeka uku yeechitar. Worek, ye riina woher: “Miin notaka yadii ameda eecha takiita.” ");
INSERT INTO kmo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposel ye Jisas riina sumowutar yaka kumwoy ye, eyey Judia nosapek tari, ye meejir eeta akar biish tar ma, ye God riiti majin meejitar. ");
INSERT INTO kmo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Worek, Pita rii Jerusalem akamak yo ir. Irek, sapin dagiiken hikitar ma ye riina o maji bar. ");
INSERT INTO kmo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Eecha wor, “Miita i yechaka eecha otii atari, yechi maba sapi saka dagiirek.” ");
INSERT INTO kmo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Worek, Pita riita eyey boboy sokwarin eena yenya sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Rii eecha wor: “Ada Jopa akamak God riina maji batarek sukwiyar. Sukwiyarek, ada her ner tagwarek, harapa siivatabin subu yepa yepa neekichi heechirek, ya saka adak bana bana yir. ");
INSERT INTO kmo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bana bana yirek, ada nosapek tawa kiya, yogwosii, hopo, apo yenya hehar her. ");
INSERT INTO kmo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Worek, ada ayan meejir. Aya ana uwar, ‘Pita na sokwa sowakwochi na a.’ ");
INSERT INTO kmo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Worek, ada eecha wor, ‘Yaho, God. Kapasek kiya eeji kujak ada keena akasakech.’ ");
INSERT INTO kmo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Worek, nereka tar aya kawka eecha wor, ‘Eyey boboyen God riita riita otiiri, eeta kepi boboy. Mii boyewak eena eecha wocho?’ ");
INSERT INTO kmo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kawka piiriichar otiir. Otiichi sii eeta howuk nerek ir. ");
INSERT INTO kmo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma por wochirek, eeta nedii ma piiriichar ye Sisaria akaman heechi i ada tar eemebak iibak iyarer. ");
INSERT INTO kmo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Iyarerek, Spirit riita ana eecha wor, ‘Yechaka eecha na i. Opoche siitii siitii siitabakech! Worek, diita 6 yaka kumwoy ye adaka Sisaria akamak eecha ibatar. Ibatarek, i Konilias riiti akak iyarer. ");
INSERT INTO kmo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iyarerek, riita nona eecha wor, ‘Ejel poren riiti aka wok siitiitarek, rii her. Herek, ejel rii riina eecha wor: Miita ma kawen na heechinak, Jopa akamak sa i Saimon riina wochanak, rii sa diika ya. Riiti akar hi pochi eeta Pita. ");
INSERT INTO kmo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Riita miina maji batanak, kwota meejitanak, miiti magwin yenya yesokwa yichikiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Worek, ada yenya maji batarek, eeta Holi Spirit yechak sakatar. Nona tasiir nediik sakarega yenya eechaba sakatar. ");
INSERT INTO kmo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Otiirek, ada inyakak hikir Jisas riita bar majin. Rii eecha wor, ‘Jon riita ukuk uku yeechitar. Kwona Holi Spiritek uku yeechi tar.’ ");
INSERT INTO kmo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Worek, eeta geenyik siir eeta nedii God riita nona har boboyen God riita akar biish tawa ma yen eechaba har. Nota Harapa Ma, Jisas Kraist, riina hiki siitiichirek, God riita Spiriten nona harega, rii akar biish tawa ma yenya eechaba har. Wowak, ada nama God riiti nobon dasiipiito.” ");
INSERT INTO kmo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Worek, yecha riita bar majin meejichi yecha yechi op majin kujan diimiichi God riiti hin yesokwatar. Ye eecha wor, “Nota hecho God riita akar biish tawa ma yenya yechi inyakan dareboyechi yesokwa yichi tawa boboyen habar.” ");
INSERT INTO kmo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiven riina sowakworek Jisas riina sumowu tar ma yenya kikirepoyerek, yecha eyey nosapek heechi i ye yatar. Jisas riina sumowu tar ma kaw ye Pinisia nosapek, Saipras nosapek, Antiok akamak icharek, Ju ma yechaban God riiti majin yenya sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Worek, hiki siitiichichar ma kaw ye Saipras ma, Sairini ma yecha Antiok akamak ichiniga akar biish tar ma yenya Harapa Ma, Jisas, riiti hadabas majin sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Eeta Harapa Ma riiti hapaga pawa yechaka eecha tarek, nokwapa nokwapa ma mima yecha Jisas riina inyaka dareboyechi hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Worek, diita maji sii Jerusalem akamak Jisas riina sumowutar ma yechaka eecha yar. Yarek, ye meejichi ye Banabas riina Antiok akamak heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Worek, riita i yar her God riita eeta ma miman rukusiitarek, riita kwoya hikirek. Kwoya hiki chiniga riita yenya kiyapotar. Riita eecha wor, “Na kwota anabeyichi na siitii ta. Jisas riiti nobon na sumowu ta.” ");
INSERT INTO kmo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas rii eeta ma kepi. Eeta nedii nokwapa nokwapa ma mima ye eeta Harapa Ma riiti nobobak eeka siir. ");
INSERT INTO kmo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Worek, Banabas rii Tasas akamak Sol riina yeshaken eena ir. ");
INSERT INTO kmo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Riita riina yesha hechi rii riina Antiok akamak yeechi yayar. Yeechi yayarek, piir sukwiya pochi piir nokwapa nokwapa Jisas riina sumowu tar ma mima yenya yaya yichi maji pokii tar. Antiok akamak mapo Jisas riina hiki siitiichichar ma yenya habatar eeta Kristen ma. ");
INSERT INTO kmo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Eeta nedii piirapet ma kaw ye Jerusalem akamak heechi Antiok akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma por riiti hi Agabas, rii siitii Holi Spirit riiti hapaga pawa takiikiisiirek, eecha wor, “Eyey eem harapa eechin hakiita.” Worek, komas Klodias rii harapa aka tabo yima tar nediik, eeta eechi ha tawa boboy eeta nediik yar. ");
INSERT INTO kmo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Worek, eeta Kristen ma ye eecha hikitar yecha Judia nosapek tar yechi yaka kumwoy yenya kiyatayekin hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hikichi otiir. Yecha yan yeechi Banabas, Sol piiriina harek, piir yeechi ye iniga Kristen hehar tar ma yenya har. ");
INSERT INTO kmo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Eeta nedii aka tabo yima Herot rii Kristen ma kawen kikirepoyetar. ");
INSERT INTO kmo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Riita Jems, Jon riiti yakan, riina eekik sowakwor. ");
INSERT INTO kmo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Otiirek, Ju ma ye inyaka kwoya hikitar. Kwoya hiki tarek, Herot rii meejichi rii Pita riina pokok jir. Yis Biish Tar Gey nokusha ar nediik riina poko jir. ");
INSERT INTO kmo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Riina poko jirek, Herot riita otiirek, 16 ow ana pichar ma yen hisiirek, ye eeta Pita riina siitii kowu tar. Herot rii eecha hikitar. Pasova nedii hamanak ada Pita riina ma mima yenya geenyik mukuchikiita. ");
INSERT INTO kmo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Worek, Pita riita poko ji tarek, Kristen ma ye riina God riina harapa maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herot riita Pita riina ma mima yen geenyik mukuchiken hikitarek, mashi niy pochi Pita rii o ana pichar ma yechak tar. Ow ana pi ma upurus piir por yokwak por yokwak siitii kowutarek, Pita rii nediik watar. Ain poko upurusek jichi seechitar. Siitii kowu tar ma upurus piir poko ji aka nuberejak siitii kowu tar. ");
INSERT INTO kmo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Worek, Harapa Ma riiti ejel heechirek yarek, eeta eemek ameya ya saka higa okoreerek, rii siitiitar. Worek, ejel rii Pita riina tiimiinan neekichi cheyer. Rii eecha wor, “Na ameya sokwa.” Worek, riiti tapak tar ain poko sii eeta saniga heemachi sakar. ");
INSERT INTO kmo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Worek, ejel rii eecha wor, “Siivatabi hehar giiriichi yatii na ruwuchi.” Pita rii meejichi otiirek, ejel rii riina kawka wor, “Miiti maba saket na ruwuchi adaka na ya howoshi ik.” ");
INSERT INTO kmo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita riita meejichi riina sumowuniga piir poko jichar aka heechi i geenyik yarer. Worek, Pita rii eecha iri rii eecha hikir kapo ada sukwiyato. Ana otiichuwa boboy kapo boboy siikenekasakech? ");
INSERT INTO kmo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Piiriita ya mapo siitii kowutar ma piiriiin heechi saya ir. Iri, komas siitii kowu tar ma piirin i heechi iyarebar. Iyarebari i harapa akama ichawa ain nuburejak i yarer. Worek, eeta nubureja sii saniga tagwarek, heechi ir. Worek, i piiriita nobo chegiik i ejel rii Pita riin heechi rii ir. ");
INSERT INTO kmo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eecha otiirek, Pita rii riina otiichir boboyen hikichi eecha wor, “Apa ada hikitu ana otiichuwa boboy eeta boboy siiken. Eeta God riita riiti ejell ana heechirek yarek, rii ana Herot riiti hapaga boboyen ana heemachir.” ");
INSERT INTO kmo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Rii diita boboyen hikichi rii Maria siiti akak ir. Sii Jon Mak riiti awi. Siiti akak nokwapa nokwapa ma mima ya yopo yichi God riina batar. ");
INSERT INTO kmo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Batarek, Pita rii siiti aka nuburejak siitii geenyik siitii hapaka tarek, wakasa mima pochi, siiti hi Roda, sii meejichi nuburejak yar. ");
INSERT INTO kmo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sii yaniga siita Pita riiti ayan meejichi sii inyaka kwoya hikichi sii aka tagwakasakech sii awasen heechi kawka iri eecha wor, “Pita rii kata geenyik siitiito.” ");
INSERT INTO kmo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ye meejichi siina eecha wor, “Na hiki shato.” Worek, sii awasen eecha wor, “Ada hewa rii siitiito. Ada woshepiikasakech.” Ye eecha wor: “Kapo riiti mayi?” ");
INSERT INTO kmo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ye eecha batarek, Pita rii way kawka nuburejan siitii hapakar. Worek, yecha nuburejan tagwachi riina hechi henebarabor. ");
INSERT INTO kmo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Worek, rii riiti tapan ye yowuchi anacheker. Worek, rii Harapa Ma riita riina poko ji akak heechitar majin eena yenya sawor. Rii eecha wor, “Ada bawa majin Jems riina, akar yaka kumwoy yenya, napa sawo ta.” Eecha wochi rii akar eemek ir. ");
INSERT INTO kmo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Uhadiirek Pita riina siitii kowu tar ma yecha Pita riina hipurek, yecha nyegerabochi ye yesha tar. Ye eecha wor, “Pita kapo siitak tawa?” ");
INSERT INTO kmo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot rii meejichi Pita riina yesha chishi majin yenya wochar. Worek, yecha riina yesha hipiirek, Herot rii Pita riina siitii kowutar ma yenya majin awasen woher. Wohe hamachi rii yenya pi sowakwo majin akar o ana pichar man worek, ye ya yenya pi sowakwor. Worek, Herot rii Judia nosapek heechi Sisaria akamak i siir. ");
INSERT INTO kmo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot rii Taia akamak tar ma yenya Saidon akamak tar ma yenya inyaka kwotayer. Worek yecha ya yopo wuchi Herot riitana hek ir. Irek, yecha Blastas riina majin m apo bar. Barek, Blastas rii meejichi riita yechaka eecha hikitar. Blastas rii Herot riiti akaman akan hehar kowu tar ma. Worek, yecha Herot riina heken ir. I hechi riina wopi kepi sii majin wor. Yecha Herot riiti nosapek i aboboyen tokotar. Eena i wopi kepi sii maji bar. ");
INSERT INTO kmo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Worek, Herot rii mashi yadii pochin hisiichiniga rii riiti kwoya hechawa siivatabi keyapochichi i harapa worebeyek yo yir. Rii yi yenya harapa maji gworon bar. ");
INSERT INTO kmo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Barek, ma mima meejichi ye eecha harapo wor: “Dii rii makasakech. Rii eeta god.” ");
INSERT INTO kmo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","God riiti ejell Herot riina ameya pichirek, rii sakar. Riita God riiti hin saka habatarek, eena pichirek sakar. Wayawaya riiti bii takiikiisiitarek riina chi har. ");
INSERT INTO kmo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Worek, God riiti maji harapa sokwarek, akar akamak eyey i ye yar. ");
INSERT INTO kmo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas, Sol piir piiriiti yo hamachi piir Jerusalem akamak heechi ir. Piiriita Jon Mak riina yeechi ye eecha ir. ");
INSERT INTO kmo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Piirapet ma kaw tisa ma kaw ye Antiok Kristen ma yechaka eecha tar. Diitata. Banabas, Simion (riina eecha habatar, Kehapa), Lusias (riiti nosap Sairini), Maneyen (Rii Herot riiti akak eeka sokwar), Sol yecha tar. ");
INSERT INTO kmo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yecha God riiti hin habatar nedii ye aboboy saka atarek, eeta nedii Holi Spirit rii yenya wor, “Banabas, Sol piiriina na yeechi saniga heechi ada yenya hisiir yon heechinak sa i.” ");
INSERT INTO kmo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Worek, yecha aboboy saka atarek. Yecha God riina maji batarek, ye yechi tapan piiriina howuk seechi piiriina heechirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabas, Sol piiriina Holli Spirit riita heechirek irek, piiriita Selusia akamak iniga jabiirek ye ichi Saipras nosapek i ir. ");
INSERT INTO kmo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Piir Salamis iyarechi piir Ju ma yechi Lotu akak iyarechi God riiti majin sawotar. Jon rii piiriitaka tarek, piiriina kiyapo tar. ");
INSERT INTO kmo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Worek, yecha eyey nedii kwowuk chishiniga i Pepos akamak iyarer. Iyarechi ye ma por riin her. Riiti hi Ba-Jisas. Rii eeta Ju ma. Rii siiga kapa otiitar ma, keyap map otii tar ma. Riita mayama piirapet eecha habatar. Rii woshepii tawa piirapet. ");
INSERT INTO kmo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Rii Sesias Polas, harapa gavman ma, riiti nareboy. Sesias Polas rii harapa inyaka hikitar ma. Riita Banabas, Sol piiriina uwar. Rii God riiti maji meejiken eena piiriina uwar. ");
INSERT INTO kmo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Uwarek, Elimas (Grik hi eecha habatar: Ba-Jisas), rii siiga kapa otii tar ma, rii piiriina uwa yeechi anachekek otiir. Rii harapa gavman ma riiti inyaka wopun dareboyiken riin otuii otii her. Jisas riina hiki siitiichichawa boboyen riita magiirechiken eena otii otii her. ");
INSERT INTO kmo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Worek, Sol (riina eecha habatar, Pol) rii Holi Spirit riina takiikiisiirek, riita siiga kapa otii tar man miy he siitiichi eecha wor: ");
INSERT INTO kmo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Mii Gaba riiti yikapwa. Mii boboy kepin o ana pichawa ma. Miiti kapasek yo otii tawa boboy miitak takiikiisii siitiichichu. Harapa Ma riiti omutiik majin mii yeechiniga woshepii majik heechitu. ");
INSERT INTO kmo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Apa Harapa Ma riiti tapa eeta saka miina pinyak miiti miy dumukiita. Apa ameda saiinak, mii yama saka hewak.” Worek, ameya riiti miy dumuri saka herek. Worek, rii chishitarek, rii riiti tapak neeki tawa man nobon mukuchiken eena yeshatar. ");
INSERT INTO kmo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Worek, eeta harapa gavman ma rii otiir boboyen eena hechi rii Jisas riina hiki siitiichir. Harapa Ma riiti maji pokiitawa majin meejichi rii henebarabor. ");
INSERT INTO kmo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Worek, Pol riita riiti nareboy yechaka Pepos akamak heechi jabiirek ir. Irek, Pega, Pampilia nosapek tarek, iyarerek, Jon rii piiriina heechi rii Jerusalem akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Worek, piiriita Pega akamak heechi Antiok akamak, Pisidia nosapek tari, piir eeka iyarer. Iyarerek, Sabat sii tar nediik, Sarere, piir Ju ma yechi lotu aka i yir. ");
INSERT INTO kmo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Worek, lotu ma ye Moses riiti lo majin piirapet riita keyir majin kadii hamarek, lotu tar ma ye piiriina maji wochirek ir. Eecha wor, “Yaka kumwoy, kicha ma mima yenya kiyapo majin baken taney, ii na ba.” ");
INSERT INTO kmo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Worek, Pol rii sokwa siitiichi rii riiti tapak ye yo wuchi maji yesokwa bar. Rii eecha wor: “Isrel ma kwona, akar ma kwona God riiti hin yesokwa tawey, ana na meeji! ");
INSERT INTO kmo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Diita Isrel ma yechi God rii noti wayegan hisiichi yenya otiichirek, ye yaya how ma Isip nosapek tari, ye sokwa hapaga siir. Siirek, God riita riiti hapaga pawak yenya Isip nosapek tarin yeechiniga akar eemek ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ye irek, 40 sukwiya eecha tarek, God rii yenya bii nomu mayaka yatar. ");
INSERT INTO kmo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Worek, rii 7 mamu akama saniga saniga ma Kenan nosapek tari yenya pi hamar. Pi hamachi, rii yechi nosapen riiti ma yenya har. ");
INSERT INTO kmo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Harek, ye 450 sukwiya eeka tar. Worek, riita jas ma yenya har. Worek, yecha tarek, Samyuell sokwarek piirapet siirek, ye eeta hamar. ");
INSERT INTO kmo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Worek, ye God riita yenya aka tabo yiman haken eena woher. Woherek, Sol, Kish riiti yikapwa Bensamin riiti neja, God riita yenya har. Harek, 40 sukwiya rii siitii kowutar. ");
INSERT INTO kmo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Worek, God riita riina bokoneechi rii Devit riina aka tabo yima heechir. God riita ma yenya Devit maji kawen eecha wor, ‘Ada yesha her Devit, Jesi riiti yikapwa, riina ada kwoya hecho. Eeji inyakak tawa boboyen riitapa otiikiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Worek, God riita Jisas, Devit riiti heja, riina Isrel ma yenya yesokwa yichi tawa ma otiir. Rii mashi wocharin eena otiir. ");
INSERT INTO kmo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Jisas rii saka yatarek, Jon rii Isrel ma mima yenya sawotar. Eecha wor: ‘Kwoti kapasek boboyen na magiirechichi na uku yeetii poy.’ ");
INSERT INTO kmo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon rii ha nedii bana vbana tarek, rii ma mima yenya eecha wor, ‘Kwo boy kapo ana shecha hikitu? An diita kwota kowu tawa makasakech. Na he! Riipa ana komas yakiita. Yanak, ada kubuchey boboy tawak, riiti sun an saka heemakiitawak.’” ");
INSERT INTO kmo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pol rii kawka eecha wor, “Eeji yaka kumwoy, Ebraham riiti neja, ana na meeji. Akar ma kaw God riiti hin yesokwa tawey, ana na meeji. Nona diita yesokwa yichi tawa majin heechirek, yar. ");
INSERT INTO kmo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Worek, Jerusalem akamak tawa ma ye yechi harapa ma ye eecha hikitar: Jisas rii yesokwa yichi tawa majasakech. Wowak, yecha piirapet yechi majin eyey Sabat nediik kadii tarin ye hikikasakech. Wowak, yecha Jisas riina dagiir poy hamarek, ye piirapet yecha bar majin woyik eecha siir. ");
INSERT INTO kmo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yecha riina sowakwori, rii kapasek boboyeka saka tarin riina sowakworek. Worek, yecha Paiullat riina woher, riina sowakwok. ");
INSERT INTO kmo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eyey mashi keyir majin riina batarin, yecha eyey yesokwarek mek ji siitiichi tarin ye yeechi ye i tiiriimok chir. ");
INSERT INTO kmo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tiiriimok chirek, God riita riina otii saniyeechi yesokwar. ");
INSERT INTO kmo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yesokwarek, kata ma ye mashi riitaka Jerusalem akamak, Galili nosapek, ichar yo tarek, ye riina her. Her boboyen apa yecha Isrel ma yen sawoto. ");
INSERT INTO kmo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Worek, sicha diika yawey, God riiti hadabas maji kepin sawo taken, eena yawa. Kata otiina boboyen God riita noti wayega mashi wocharin, rii eeta nona otiichir. Nota noti wayega yechi neja eena nona otiichir. Rii Jisas riina yesokwar nobok nona eeka otiichir. Sam 2 majik keyiri eecha wocho: ‘Mii eeji Yikapwa. Apa ada miiti Apoko.’ ");
INSERT INTO kmo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God riita diita riina saniyeechi yesokwa tawa majin kwopa sii tawa eem rii kawka i kwopa siikasakech. Wowa majin rii eecha wor: ‘Kata boboyen ada Devit riina hak wokwona hakiita!’ ");
INSERT INTO kmo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Akar mashi keyir maji eecha wocho, ‘Miitana sumowu tawa wakasa ma kepi riin miita nobon egesiinak, riipa kwopa siikasakech.’ ");
INSERT INTO kmo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Devit riita eeta nediik tari, rii God riiti inyakak tar boboyen otiir. Otiirek, Devit rii har. Harek, yecha riiti wayegan bana bana tar tiiriimok chir. Chirek, riita kwopa siir. ");
INSERT INTO kmo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wowak, kata ma riina God riita saniyeechi yesokwa tari, riita saka kwopa siitarek. ");
INSERT INTO kmo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Eeji yaka kumwoy, kwotya eyey eena napa he. Nota Jisas riiti hik diita noti kapasek boboyen kwoyava ya tawa nobon eena kwona sawoto. Kwota na henyak na hiki ta: Kwoti kapasek boboyen Moses riina har lo sii saka kwoyava yarek. Kwo Jisas riina hiki siitiichinyey, iipa kapasek boboy riipa kwoyava yakiita. ");
INSERT INTO kmo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Wowak, na ow poy sii ta. Piirapet yechi maji iipa kwotak yanakech. Ye eecha wor: ‘God riita eecha wor: ");
INSERT INTO kmo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Wosaboy tawa ma kwo na he! Na kayek heneba rabochi ha! Kata yon ada kwoti nediik otii tawey, eeta boboyen ma por rii kwona geenyik mukuchinyey, kwopa saka eena hiki siitiichikiitawak.’” ");
INSERT INTO kmo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Worek, Pol, Banabas piir Ju ma yechi lotu akan heechirek otiiri, ma ye piiriina woher, “Ki komas Sabat nediik yanak, diita majin ki kawka napa ba. ");
INSERT INTO kmo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ma mima ye yechi otu akan heechi iri, yecha Po, Banabas piiriina sumowur. Nokwapa nokwapa Ju ma ye nokwapa nokwapa akar biish ma ye, Ju ma yechi majin sumowutari, ye Pol, Banabas piiriina nobok i sumowu ir. Irek, Apose piir yenya maji eecha wochiniga yenya kiyapo majin bar. Eecha wor, “God riiti rukusii tawa boboyek eeka na ta.” ");
INSERT INTO kmo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Worek, komas Sabat nediik nokwapa nokwapa akamak tar ma ye God riiti majin meejik yar. ");
INSERT INTO kmo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yarek, Ju ma ye nokwapa nokwapa ma mima yen hechi kapasek hikichi yecha inyaka kwotayer. Kwotayechi ye Pol riita bar majin o otii maji bar. Ye riiti hin kapasek habar. ");
INSERT INTO kmo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Worek, Pol, Banabas piir anabeyichi harapa eecha wor, “Sicha God riiti majin Ju ma kwona geenyik mapo bak. Batawak, kwo nasowoye tawak, kwo eecha wocho: “Nota keena saka eechaba eechaba tawa boboyen yakiitawak.’ Wowak, nota kwona heechi akar ma biish tawa ma yechaka eecha ikiita. ");
INSERT INTO kmo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Diita majin eeta Harapa Ma rii nona har, ‘Ada kwona otiichirek, kwota, akar biish tawa ma yechi habak siikiita. Ada otiichirek, kwota Ju ma eeta eyey nosap tawa mas yenya yesokwa yichi tawa nobo.’” ");
INSERT INTO kmo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Akar biish tar ma ye diita maji meejichi yechi inyaka kwoya woy hikichiniga God riiti majin yesokwatar. Kata ma yen God riita hisiiri, ye Jisas riina hiki siitiichir. ");
INSERT INTO kmo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Worek, Jisas riiti maji kata eemek i ye yatar. ");
INSERT INTO kmo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Worek, Ju ma ye eeka tari ye akama harapa tar ma, God riina hiki siitiichichar mima yechi inyakan dareboyer. Worek yecha kikirepoy otii tawa boboyen eena tasiir. Worek, piirina yeechi kata eemek rabor. ");
INSERT INTO kmo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Worek, Aposel ye yechi yatii cheren pupoyechi Aikoniam akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Worek, Kristen ma ye tari Holi Spirit yenya takiikiisiirek, yecha inyaka kwoya hikir. ");
INSERT INTO kmo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aikoniam akamak eechaba kawka otiir. Pol, Banabas piir Ju ma yechi otu akak i maji sawotarek, nokwapa nokwapa Ju ma ye, akar biish tar ma yechaka Jisas riina hiki siitiichichar. ");
INSERT INTO kmo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Worek, Ju ma kaw ye saka hiki siitiichirek. Ye kapasek otiichiniga ye akar biish tar ma yechi inyaka wopu dareboyer. Dareboyek, ye yechi yaka kumwoy yenya inyaka kapasek hkir. ");
INSERT INTO kmo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Worek, aposel piir eeka tar eemek harapa kadii siirek, riiti majin siitii anabeyichi sawotar. Sawotarek, God riita mukuchir piiriita bar maji eeta omutiik siiken. Hapaga tawa pawan piiriitaka tari, piir wopu dareboy tawa boboy, henebarabo tawa boboyen otiir. ");
INSERT INTO kmo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ma mima ye saniga saniga yi hiki ye itar. Ma kaw ye Ju ma yechi inyakak hikitar. Kaw Aposel yechi inyakak hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Worek, akar biish tawa ma, Ju ma, harapa ma, yechaka Aposel piiriina kapasek boboyen yenya papak rabo tawa bbobyen otiiken eena hikir. ");
INSERT INTO kmo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Worek, Aposel piir meejichi ppiir heechi Laikoniam nosapek ir. Bana bana tar akama, piiriiti hi Listra, Debi eeka ir. ");
INSERT INTO kmo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Irek, piir eeta hadabas maji kepin sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Piir Listra akamak tarek, ma por rii riiti yatii kapasek tarek eena yichar. Yimowurek, riiti yatii kapasek siir. Rii chishi ye kiasakech. ");
INSERT INTO kmo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Rii Pol riiti majin meejir. Meejitarek, Pol rii her riina otii kepi siiken hiki siitiichir. Worek, Pol riita riina hehar her. ");
INSERT INTO kmo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Hechi harapa aya wor: “Na sokwa yatii piitiichi siitii.” Worek, ma rii meejichi durapowuchi saka siitii chishir. ");
INSERT INTO kmo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Worek, nokwapa nokwapa ma mima ye Po riita otiir boboyen hechi ye yechi Likionia majik eecha wor, “Eeta sikiyawas ye mak siirek, ye notaka saka yar!” ");
INSERT INTO kmo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","13","Ye Banabas riina habar, Sus. Ye Po riina habar, Hemis. Worek, Sus opelen otii tar ma rii bullamakawen keyapo chichi eecha yeechi yayaniga akaman nuburejak yayar. Sus riiti aka saba yepak tar. Opelen otii tar ma rii ma mima ye Banabas, Pol piiriina poy poyeken hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Banabas, Pol piiriita yecha otiiken otiitar boboyen hechi piir piiriiti siivatabin woyarechi piir eeta ma mima yechi nediik i harapa uwar. ");
INSERT INTO kmo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Eecha wor: “Boyewak kwo jecha otiito? Sicha kiki ma ta! Kwota tawabaga eecha tawa! Sicha God riiti hadabas majin sawoken eena yar. Kwo kapo diita kubuchey boboyen magiirechichi eechaba eechaba takiitawa God riitak kwo dareboyeken eena sicha yar. Riita neeren otiir, nosapen otiirek, soma kwotii tawa harapa pan otiirek, eyey boboyen eeka tarin riita otiir. ");
INSERT INTO kmo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mashi God riita ma mima yenya heechirek iri, yecha keena ichar nobok woyek ir. ");
INSERT INTO kmo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Worek, God riita mashi, apa eechaba eechaba ma mima yen mukuchichu rii eeta kepi otii tawa God. Riita nona otiichichawak, wayevatawak, nowo saga kepi sokwatawak, aboboyen hatawak, kwoti inyaka kwoya hikitu.” ");
INSERT INTO kmo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aposel piir diita maji worek, ye kawka poy poyeken eechaba hikitar. Piir harapa maji wochi yen anacheker. ");
INSERT INTO kmo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ju ma kaw Antiok akamak, Aikoniam akamak tari, ye heechi yar. Heechi yaniga, ye Laistra akamak tar ma mima yechi inyakan dareboyechi Pol riina papak rabo pichi riina sabak nekii rutii i seechir. Otiichi yecha hikir rii siiken har. ");
INSERT INTO kmo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Worek, Jisas riina hiki siitiichichar ma ye riitak yopo yirek, worek, rii sokwa heechi harapa akamak ir. Komas yadii rii, Banabas riitaka eecha Debi akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Irek, Po, Banabas piiriita hadabas majin Debi akamak sawotar. Sawotarek, nokwapa nokwapa ma mima Jisas riina hiki siitiichir. Worek, piir heechi Listra akamak awasen ir. Iri, Aikoniam akamak ir. Iri, Antiok akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Piir Kristen ma mima yenya i hapa hachi kiyapowur. Yecha God riiti nobo omutiikek iken eena kiyapowur. Piir eecha wor: “Nota Harapa God riina sumowuk otii tawey, nokwapa nokwapa nomoya tawa boboy notak yakiita.” ");
INSERT INTO kmo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Eyey akamak ma mima ye ya yopo yicha tari piir Kristen man hehar tar ma yenya hisiir. God riina maji bak otiiri piir akasakech. Worek, eeta Jisas riina yecha hiki siitiichirin piir Jisas riiti tapak yenya har. ");
INSERT INTO kmo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Worek, piir Pisidia nosapek i yar hamachi iri Pampiia nosapek eeka i yarer. ");
INSERT INTO kmo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Worek, piir God riiti maji Pega akamak sawotar. Worek, piir Atelia akamaka ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Irek, jabiirek iyarechi heechi Antiok akamak awasen ir. Mashi eeta akamak Kristen ma ye piiriina God riiti yon har. Wochiniga eecha wor: “Kinya, eeta God riiti tapak how hawa. Riita kinyapa heharekiita.” Piir diita yo hamachiniga Antiok akamak kawka yar. ");
INSERT INTO kmo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Piir Antiok akamak iyarechi worek, Kristen ma mima ye ya yopo wuchi yir. Yirek, piir eyey God riita piiriitaka otiir yon eena yenya sawotar. Piir yenya eecha wor: “God riita hiki siitiichichawa nobon akar biish tar ma, yenya tagwachir.” ");
INSERT INTO kmo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Worek, piir Jisas riina hiki siitiichichar ma yechaka eechaba eechaba tar. ");
INSERT INTO kmo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ma kaw ye Judia nosapek heechi Antiok akamak ir. Iri, yecha majin tasiichi Kristen ma mimayenya eecha wor, “Moses riiti lo maji eecha wocho: kwota sapi kawen na diigii rabo. Kwona diigii rabonan siiney, God riita kwona yesokwa yichikasakech.” ");
INSERT INTO kmo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol, Banabas ye meejichi yenya harapa o majin bar. Awasen awasen majin bar. Worek, Kristen ma yecha ba bachi eecha hikichinga Pol, Banabas piiriitaka anadii maka eecha majin ye iken hisiir. Ye Jerusalem akamak iken, diita majin apodiigiik, Aposel yenya, Kristen hehar tar maka diita majin baken, eena hisiir. ");
INSERT INTO kmo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kristen ma mima yecha yenya heechirek ir. Yecha nobon icharek, ye Pinisia nosapek Sameria nosapek ichar. Icharek, ye sawotar akar biish tar ma ye God riiti nobon sumowu tar. Worek, Kristen yaka kumwoy ye meejichi yechi inyaka kwoya hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yecha Jerusalem akamak iyarerek, ya yopo yichar ma, Aposel, Kristen man hehar tar ma ye yechaka tapa neekiichi woshiar. Yecha yarek, akar ma yenya yecha God riita yechaka otii mukuchir yon eena sawotarek, ye eechaba yenya woshiar. ");
INSERT INTO kmo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Worek, Perisi ma kaw ye Jisas riina hiki siitiichir. Yecha eecha wor, “Yecha sapa Moses riiti lo maji sumowutanak, sapi kawen sapa diigii rabo.” ");
INSERT INTO kmo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Worek, Aposel ye Kristen man hehar tar ma ye diita boboyen hiki taken eena ya yopo wuchi yichar. ");
INSERT INTO kmo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Yecha harapa gworo o maji batar. Batarek, Pita rii sokwa wor: “Eeji yaka kumwoy, kwo hikitu mashi ada kwotaka tari God riita ana hisiir. Akar biish tar ma yenya God riiti hadabas majin sawoken, yecha kapo meejichi Jisas riina hiki siitiii chiken eena ana hisiir. ");
INSERT INTO kmo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God riita eyey ma yechi inyaka wopu eyey hecho. Hechawak, riita nona Holi Spirit riina hatarega, rii akar biish tar ma yenya eechaba har. Harek, God riiti inyaka eeta nona mukuchichu. ");
INSERT INTO kmo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nona otiichinyak, yenya saniga otiichikasakech. Yecha Jisas riina hiki siitii chiri, God riita yechi kapasek boboyen kwoyava yeechir. ");
INSERT INTO kmo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Wowak, apa kwo boyewak God riiti inyaka kwotayechik otiito? Kwo Kristen ma yechi magiiren harapa nomo yatawa boboyen boyewak how yichitu? Mashi noti wayega, ye apa notaka Moses riiti lon kiyakasakech. ");
INSERT INTO kmo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yaho. Nota hiki siitiichichawey, Harapa Jisas riiti yeyada nona rukusiitawa boboyeba eeta nona yesokwa yichitawaga yenya eechaba yesokwa yichitu.” ");
INSERT INTO kmo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Worek, ma mima ye meejichi maji awasen saka barek. Worek, Pol, Banabas piir God riita piiriitaka otiir heneba rabo tawa boboyen akar biish tar man otiirin eena sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Piir maji ba hamarek, Jems rii sokwa wor: “Yaka kumwoy, ana na meeji! ");
INSERT INTO kmo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon Pita rii apa nona eecha wor, God riita nona mukuchir riita akar biish tar man rukusiibato. Akar biish tar ma kawen yechaka tawey, God riita yenya hisiichi yanak, eeta riiti. ");
INSERT INTO kmo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Piirapet yechi maji eechaba wor, mashi keyir maji eecha wocho, ");
INSERT INTO kmo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘God rii eecha wor: Komas anapa way kawka yakiita. Yanak, Devit riiti aka sakarin ada ya otii yesokwakiita. Eeta aka boboy kapasek tawey, ada akaren yeechi otiikiita. Ada eena kawka otiichi yesokwakiita. ");
INSERT INTO kmo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Wonyak, akar ma ye God riina yesha hekiita. Kata eyey ma yen ada habari, ii siiken ye riina yeshaniga hekiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eeta God riita diita majin wor. Riita diita boboyen mashi geenyik wor!” ");
INSERT INTO kmo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Worek, Jems kawka eecha wor, “Ada eecha hikitu opoche kata ma ye God riina dareboyechichawey, yenya nota yon kawka hatanakech. ");
INSERT INTO kmo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wowak, nota na jeyn wochinak, sa i. Yecha opoche yecha sikiyawas hatar aboboyen, kapasek tarek, atanakech. Ye opoche akar miman anesmesherotanakech. Ye opoche kiya pika taney opoche atanakech. Pi opoche atanakech. ");
INSERT INTO kmo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Moses riiti lo majin eyey Sabat nedii mashi na apa lotu akak eechaba eechaba kadiitar. Riiti maji eyey akamak sawoto.” ");
INSERT INTO kmo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Worek, Aposel ye, Kristen man hehar tar ma ye, ya yopo yicha tawa ma yechaka hikichi ma kawen yechaka tarin yen hisiir. Hisiichi Pol, Banabas piiriitaka Antiok akamak iken eecha heechinak iken hikir. Yecha Judas (riina eechaba habatar, Basabas), Sailas piiriina hisiir. Kristen ma yaka kumwoy yecha hikitari, piiriina kepi tanaga eecha hikitar. ");
INSERT INTO kmo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Worek, ye jeyn keyichi heechirek yechak ye ir. Eeta jey maji eecha wor: “Eeta Aposel ye Kristen man hehar tawa ma ye kwoti yaka kumwoy yechaka diika tawey, no eyey akar biish tar ma Antiok akamak, Siria nosapek, Silisia nosapek tari, nota kwona woshiato. ");
INSERT INTO kmo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nota meejir noti ma kaw notaka tari, ye heechi kwotak eecha irek, kwon maji kaw wor. Kwo meejichi kwota bii nomuyar. Worek, diita heechi ir ma no yenya saka maji bachirek irek. ");
INSERT INTO kmo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Worek, no ya yopo wuchi yichar. Yicharek no hikitar ma kawen nota hisiichi heechinak kwotaka eecha ikiita. Piir noti apoma Banabas, Pol piiriitaka eecha ikiita. ");
INSERT INTO kmo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Piir Harapa, Jisas Kraist riiti yon otiitarek, piir kapasek yon otiir ma yen saka akiitarek. ");
INSERT INTO kmo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Worek, no Judas, Sailas piiriina kwotak heechuwak ichu. Piirita inyak, diita keyiwa majin kwona piir eechaba sawokiita. ");
INSERT INTO kmo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Eeta Holi Spirit rii notaka hikitu nomuyatawa boboyen no kwona saka hakiitawak. Diita boboyen na otii ta: ");
INSERT INTO kmo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kwo sikiyawasen yaya yopo wu tawa aboboy kwo opoche atanakech. Pi opoche atanakech. Kiya pika taney opoche atanakech. Akar miman opoche anemesh rokotanakech. Kwo eecha otiinan siiney, kwo yo kepin otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","31","Jeyn ye ichar ma ye heechi Antiok akamak ir. I ye worek, hiki siitiichichar ma ya yopo wuchi yirek, ye yenya jeyn har. Harek, ye eena kiyapo maji kadiichi yechi inyaka kwoya hikir. ");
INSERT INTO kmo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas, Sailas piir piirapet tarek, yaka kumwoy yen majin sawotarek, ye meejichi yey hapaga siichi siitiitar. ");
INSERT INTO kmo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Piir eeka i kaw tarek, yaka kumwoy ye piiriina heechirek irek, yechi sugu wopuk eeta kepi tarek, wochirek ir maka piir awasen eecha ir. ");
INSERT INTO kmo_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Silas rii iken hiki hipurek, rii eeka siir.) ");
INSERT INTO kmo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Worek, Pol, Banabas piir Antiok akamak siir. Piir nokwapa nokwapa anadii maka God riiti majin sawotarek, maji pokiitar. ");
INSERT INTO kmo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Komas Pol riita Banbas riina eecha wor, “Sicha heechi ik. Kata akama sicha mashi God riiti majin eeka sawotari, sicha yaka kumwoy howushi hek. Kapo ye boyen otiito? Kapo ye kepi tawa?” ");
INSERT INTO kmo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Worek, Banabas rii eecha hikitar sicha Jon Mak riina yeechi nota eecha ik. ");
INSERT INTO kmo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Wori, Pol rii meejichi rii hikiri saka kepi hikirek, eena rii bokonar. Bokoneechi rii eecha wor: “Mashi rii saka sichaka eecha icharek. Rii saka yo sichaka eecha i otiitarek. Rii Pampiia akamaka sinya eeka heechi rii awasen ir.” ");
INSERT INTO kmo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Worek, piiriita inyaka saniga saniga kwotayechi piir saniga saniga heechi ir. Banabas rii Mak riina yeechi piir heechi Saipras nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol rii sailas riina hisiirek, yaka kumwoy ye piiriina eecha wor: “God riiti rukusii tawa boboyen kichawa apa eecha ikiita.” Piir eeka eecha ir. ");
INSERT INTO kmo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Heechi irek, rii Siria nosapek, Silisia nosapek ichiniga Kristen ya yopo yichi tar ma yenya rii i yenya kwochobo rabotar. ");
INSERT INTO kmo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol rii Debi akamak Listra akamak ir. Kristen ma por eeka tari, riiti hi Timoti. Riiti awi siitaka eecha i siir. Riiti awi sii eeta Ju mima. Sii Jisas riina hiki siitiichichar. Riiti apoko rii eeta Grik ma. ");
INSERT INTO kmo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kristen ma Listra akamak tari, Aikoniam akamak tari, ye Timoti riina wohow tar. ");
INSERT INTO kmo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Worek, Pol riita eecha hikitar Timoti riitaka piir eecha ik. Eecha hikichi riiti sapi kawen diigii rabor. Ju ma ye eeta eemek tari, ye eecha hikir Timoti riiti apoko rii eeta Grik ma eena Pol riita Timoti riiti sapi kawen diigii rabor. ");
INSERT INTO kmo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Worek, Pol, Sailas, Timoti yecha akama akama i ye yatarek, Jerusalem Aposel, Kristen hehar tar ma yechaka hikichi batar majin Kristen ma yenya sawotar. Sawochiniga ye eecha wor, diita majin na sumowu ta. ");
INSERT INTO kmo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Worek, Kristen ma ye eena i harapa hapaga hiki siitiichirek, nokwapa ma ye yatar. ");
INSERT INTO kmo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Worek, yecha Prisia nosapek Galesia nosapek i ye yatar. Icharek, Holi Spirit rii yenya egesiirek, yecha God riiti majin Esia nosapek i sawonakech. ");
INSERT INTO kmo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yecha Misia nosapek iyarek otiirek, yecha Bitinia nosapek i heken eena hikir. Worek, Jisas riiti Spirit rii yenya egesiir. ");
INSERT INTO kmo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Worek, ye Misia nosapek har heechiniga Troas akamak eeka iyarer. ");
INSERT INTO kmo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ye eeka tarek, niy siirek, Pol rii watarek, rii sukwiyar. Sukwiyari, rii wa her, Masedonia ma por rii ya siitiiniga riina woyasachiyasa hechar: “Miita na Masedonia nosapek na ya nona kiyatay!” ");
INSERT INTO kmo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Worek, nota Masedonia nosapek iken eena sayarer. Nota eecha hikitar God riita nona wochir. Nota hadabas majin Masedonia ma miman yenya sawoken God riita eena nona wochir. ");
INSERT INTO kmo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Worek, nota Troas akamak heechi jabiirek ye ichi ir. Iri Samotres akamak iyarer. Iyarechi heechi kawka yadii pochi i Niapolis akamak igayer. ");
INSERT INTO kmo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Igayechi heechi Pilipai akamak ir. Pilipai siita eeta akamak podat Masedonia nosapek eeka tar. Ii eeta harapa akako. Pilipai sii eeta Rom ma yechi akama. Irek, nota yadii nokwapa nokwapa eeka tar. ");
INSERT INTO kmo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabat yadii nota akama heechiniga pak ir. Nota eecha hikitar diita pagiirea Ju ma ye kapo God riina maji eeka batar. ");
INSERT INTO kmo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mima pochi sii meejirek, siiti hi Lidia. Siiti akama eeta Taiataira. Siita siivatabi nayim siik toko tar mima. Sii God riiti hin habatar. Worek, God rrita siiti marenoku tagwarek, eena siita Pol riita bar majin hehar meejitar. ");
INSERT INTO kmo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Worek, siin uku yeechir. Siiti akak tar ma mima yen kiki uku yeechibar. Worek, siita nona woher, “Kwo hikiney, ada God riina hehar hiki siitiichichu eeji akak na ya eeka yicha.” Sii maji eecha barek, nota eena meejichi siina sumowu ir. ");
INSERT INTO kmo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yadii pochi nota God riina maji batar eemek icharek, wakasa mima pochi nota siina nobok awa awa her. Kapasek gaba siiti inyakak eeka tarek, sii komas yak otiitar boboyen sii eena sawotar. Siita diita yon shebo shebo otiitarek, siiti harapa ma ye harapa moni yen yar tar. ");
INSERT INTO kmo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Sii Pol riina notaka sumowuniga sii uwar, “Diita ma ye howuk tawa harapa God riiti wakasa ma. Ye God riita nona awasen yeechi ye i nobon eena hehar mukuchichawa ma.” ");
INSERT INTO kmo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nokwapa yadii sii eechaba otiitar. Eechaba otiitarek, Pol rii yuyeechi dareboyechi kapasek gaba siitaka tarin eecha wor, “Ada miina wocho Jisas Kraist riiti hik mii na ya geenyik saya.” Worek, eeta gaba siitak ameya heechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Worek, siiti harapa ma yecha diita boboy hikirek, yecha her moni ya tawa nobo sii biish woy siir. Herek, yecha Pol Sailas piiriina yeechi mageyetar eemek yeechi piiriina ye ir. Ye iri, gavman ma yenya mukuchir. ");
INSERT INTO kmo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rom ma harapa ma yechak yi i mukuchichi eecha wor, “Diita ma eeta Ju ma. Yecha diita harapa akamak kapasek yon otiito. ");
INSERT INTO kmo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Piiriita kapasek otii tawa abon eena yenya sawotar. Piir noti lon eena nasowoyetu. Wowak, Rom ma nopa piiriita sawo tawa maji no sumowukasakech.” ");
INSERT INTO kmo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Worek, nokwapa nokwapa ma mima ye eechaba piiriina maji ba diimiitar. Diimiitarek, eeka tar harapa ma ye Pol, Sailas piiriiti maba rikin neeki woyarechiniga piiriina kubuk piken wochir. ");
INSERT INTO kmo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Worek, piiriina harapa pirek, piiriina poko jir. Jirek, ye poko ji akan siitii kowu tawa ma riina wor, “Na hehar siitii kowu ta.” ");
INSERT INTO kmo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Rii meejichi siitii kowu tar ma rii piiriina yeechi aka wok ye i heechir. Heechitarek, piiriiti yatin supuka tar plang eeka heechirek eeka tar. ");
INSERT INTO kmo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Worek, niy nediik Pol Saillas piiriita God riina maji batarek, hokwa chicharek, anadii poko jir ma ye piiriina meejitar. ");
INSERT INTO kmo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Worek, harapa nenyaw ameya yar. Yarek, poko jichar aka kwatii ye howorek, nubereja tagwarek, man jichar sen poko sii saniga heemabar. ");
INSERT INTO kmo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Worek, akan siitii howu tar ma rii sokwa siitii her. Poko ji aka nubereja tagwa seechitarek, rii heri rii eecha hikir poko jichar ma ye kapo sokwa heechi akii ii hamawa. Worek, rii riiti eekin huguruku yeechi mayama pi sowakwoken eena otiir. ");
INSERT INTO kmo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Worek, Pol rii eena hechi rii harapa uwar, “Miita opoche mayama pishemanetanakech. Nota eyey diika tawa.” ");
INSERT INTO kmo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Worek, siitii kowu tar ma rii meejichi rii haban uwachi, rii heechi wok i yarechi, iri Pol, Sailas piiriiti yatii jumuk i nubunubu hasakar. ");
INSERT INTO kmo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Worek, rii piiriina yeechi geenyik ye ichi eecha wor, “Harapa ma, anapa shecha otiinak, God riita ana yesokwakiita?” ");
INSERT INTO kmo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Piir eecha wor, “Jisas riina na hiki siitiichi. Hiki siitiichinyey, miina miiti akaka ma yenya God riita yesokwa yichikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Worek, piir riina riiti akak tar ma yenya God riiti maji sawor. ");
INSERT INTO kmo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Eeta niy nediik siitii kowu tar ma rii piiriina yeechi piiriiti maban kubuk pir ramon eena uku yeetiir. Worek, rii riiti akak tar ma mima yenya ameya uku yeechi hamar. ");
INSERT INTO kmo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Worek, rii Pol, Sailas piiriina riiti akak yeechi ye yo ye i aboboy havar. Rii riiti akak tar ma ye God riina hiki siitiichichi inyaka kwoya hiki tar. ");
INSERT INTO kmo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Eeta komas niyega nediik Rom harapa ma ye majin heechirek pllisman ma yechak ye ir. Ye eecha wor, “Diita ma piiriina na heechinak sa i.” ");
INSERT INTO kmo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Worek, poko ji aka siitii kow tar ma rii maji piiriina wor: “Rom harapa ma ye heechinak i majin wochirek yar. Wowak, kicha na ishar na i.” ");
INSERT INTO kmo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pol rii meejichi plisman yenya eecha wor, “Sinya Rom pochi akamak eeka yimowurek, sicha Rom ma tawa. Wowak, sicha kapasek boboyen otiikasakech. Wowak, kwo sinya kubuk pir. Nokwapa nokwapa ma mima yechi miy somak sinya pichiniga poko jir. Wowak, apa kwo sinya heechinak ishar ikiita. Yaho! Rom ma harapa ma sa ya sinya nobo mukuchichi heechinak sicha keena ikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Worek, plisman ye Pol riita bar majin Rom ma harapa ma yechak wochirek ir. Yecha meejirek, Pol, Sailas piiriita Rom ma tarek, eena yecha akiitar. ");
INSERT INTO kmo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Akiitarek, ye heechi piiriina mija maji bar. Worek, yecha piiriina poko ji akak tarin, yeechi geenyik ya sayachiniga piiriina whoher” “Piiriita iken.” ");
INSERT INTO kmo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Worek, Pol Sailas piir akan heechi Lidia siiti akak ir. Iri, akar yaka kumoyen i he yar. I he yarek, piiriita yenya kiyapo majin bachi heechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","2","Piiriita Ampipolis akama iyarechi hechi Apoonia akama iyarechi heechi Tesalonaika akamak iyarer. Iyarechi, Ju ma yechi llotu aka eeka iyarer. Pol riita mashi otiitarebaga eechaba iyar otiir. Rii Sabat piiriichar nedii eeka tarek, rii God riiti mashi keyir majin yechaka awasen awasen batar. ");
INSERT INTO kmo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rii yenya kwodii wo mukuchichar Jisas riita eeta Kraist. Keyir maji eecha wor: “Riipa keena kapo meejikiita. Riipa keena hakiita. Riipa keena kawka yesokwakiita.” Rii eecha God riita hisiir ma.” ");
INSERT INTO kmo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ma kaw ye eena meejichi piiriina sumowutar. Nokwapa nokwapa Grik ma ye God riiti hin yesokwa tari, ye Pol Sailas piiriina eechaba sumowubatar. Harapa ma yechi mima kaw ye eechaba sumowubatar. ");
INSERT INTO kmo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","6","Worek, Ju ma ye eena hechi inyaka kwotayer. Kwotayechiniga yecha awaba eemek yi kapasek yo otiitar ma yenya ya yopo yichi kapasek maji yenya bar. Barek, ye sokwa kapasek boboy otiirek, nokwapa nokwapa ma mima ye kapasek otii inyakan hikir. Worek, ye Jeson riiti akak ya hedii pa payachi iyar. Iyarek, ye piiriina yeechi ma mima yechi tapak haken yesha hipiir. Yesha hipiirek, Jeson riina tapa tobok yeechi neeki akar Kristen yaka kumwoy yechaka eecha ye ir. Akama harapa ma yenya ye ir. Ye i uwachi wor, “Diita ma ye eyey eemek kapasek boboy otiitar. Apa yecha noti akamak yar. ");
INSERT INTO kmo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yarek, Jeson rii riiti akak yeechi heechir. Yecha eecha wocho: ‘Akar aka tabo yima tar. Riiti he eeta Jisas.’ Yecha eecha wochuwak, ye Sisa riiti lon wosowoyetu.” ");
INSERT INTO kmo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Worek, kapasek otiitar ma eecha otiirek, ma mima ye, akama harapa ma ye, inyaka kapasek hikichi kwotayechi otiitar. ");
INSERT INTO kmo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Worek, harapa ma ye otiirek, Jeson rii akar Kristen ma ye moni gavman yenya har. Harek, yeechi yenya heechirek, ir. ");
INSERT INTO kmo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Niy siinak, Kristen yaka kumwoy ye Pol Sailas piiriina Beria akamak heechirek, ir. I iyarechi piir Ju ma yechi lotu akak i ir. ");
INSERT INTO kmo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria ma ye saka kata Tesalonaika tawa maga eecha tawak. Ma mima ye kaka tari, ye yechi inyaka wopu tagwachi majin hehar meejitar. Worek, ye Pol riiti majin ye eena yeechi hehar hikitar. Eechaba eechaba yadii nedii ye mashi keyir majin ye eena kadii tarek, Pol riita bar majin ye eena yesha her kapo eeta omutiik. ");
INSERT INTO kmo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Worek, nokwapa nokwapa ma mima ye Jisas riina hiki siitiichir. Nok wapa nokwapa Grik ma ye riina hiki siitii chibatar. ");
INSERT INTO kmo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Worek, Tesalonaika tar Ju ma ye Pol riita Beria akamak sawotar majin meejichi ye i Pol riina akama otii kapasek sii boboyen i otiir. Otiirek, akamak tar ma ye kapasek hikir. ");
INSERT INTO kmo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Worek, Kristen yaka kumwoy ma ye Pol riina yeechi soma kwotii tawa pa akamak heechirek ir. Worek, Sailas, Timoti piir Beria akamak tar. ");
INSERT INTO kmo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pol riina ye ir ma ye riina Atens akamak heechir. Heechirek, ye Beria akamak maji heechirek ir. Pol rii maji awasen wochirek ir. Rii eecha wor, “Sailas, Timoti kicha napa adak ameya ya.” ");
INSERT INTO kmo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol riita Atens akamak eeka Sailas, Timoti piiriina kowutar. Kowuchiniga rii nokwapa nokwapa geenyik tar sikiyawas yenya her. Akama takiikiisiirek, rii henebarabochi ri inyak kwotayer. ");
INSERT INTO kmo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Worek, Ju ma yechi lotu akak ichi Ju ma yen God riiti hin habatar akar biish ma yenya maji awasen awasen batar. Rii akama awaba eemek ichi yatar ma yenya awasen awasen batar. ");
INSERT INTO kmo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikurian riina sumowu tar ma ye, Stoik nobon sumowutar ma ye Pol riina awasen awasen maji batar. Ma kaw ye eecha woher, “Diita harapa majin har ba ye tawa ma rii kapo shecha wocho?” Anadii ma ye eecha wor, “Riita kapo akar sikiyawas eena maji bato.” Pol riita Jisas riina yesokwa yichi tawa boboyen eena sawotarek, eena ye eecha wor. ");
INSERT INTO kmo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Worek, yecha Pol riina yeechi Ariopagas ya yopo yichi tar eemek ye ir. Ye irek, ye eecha wor, “Nota i akar ba tawa majin meejiken hikitu. ");
INSERT INTO kmo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Miiti maji kawen nota meejitawey, eeta akar maji. No eeta meeji dopowa.” ");
INSERT INTO kmo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atens akama yichar ma ye, akar nosapen heechi yatar ma ye eeka tari, ye eechaba eechaba kada kada majin hehar meejiken eena ya yi meejitar. Dii eeta yecha otiitar abo.) ");
INSERT INTO kmo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Worek, Pol riita Aripogas kaunsil ma yechi mi somak siitiichi eecha wor, “Atens ma, na meeji. Ada hecho kwo nokwapa nokwapa sikiyawas yenya sumowutu. ");
INSERT INTO kmo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ada kwoti akamak chishi ye i tarek, kwoti sikiyawas yechi akan he ye i tarek, ada opelen otii tar chey pochin heri, keyir jebwa eeka tarek, her. Eeta jebwa keyiri eecha wor, ‘Dii Eeta Sikiyawas Podar No Riina Hekasakech.’ Kata sikiyawas riina kwo riiti hin yesokwa tawey, kwo riina saka hechawak, apa eena ada kwona sawok. ");
INSERT INTO kmo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Eeta God rii diita nosapek tawa eyey boboyen otiiri rii howuk tawa boboy heyik tawa boboy eeta riitaba saniga harapa. Riita mak otii tawa akak eeka siikiisakech. ");
INSERT INTO kmo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Riita eyey man popoyen hato. Eyey akar boboyen habato. Riita boy boboyen somoyenak, ma tapak riina mukuchik wonyak? Riina kiyatayek wonyak? ");
INSERT INTO kmo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Riita mapo wayega podar otiirek, eyey ma ye sokwa eyey eemek i ye yar. Riita otiirek, mashi na apa nedii yechi nosap siir nobo sorechichi yen eeka heechi ye ir. Heechi ye irek, yecha eeta eemek yir. ");
INSERT INTO kmo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ma ye God riina yesha heken eena otiitar. Ye hiki hiki i he siitiichiken, eena otii tar. Wowak, God riita yapak takiisakech. ");
INSERT INTO kmo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Eena nota riitaka eecha yichawak, riitaka eecha chishitawak, eena nota riitaka eecha tawa! Kwoti jebwa keyi hechar ma kaw ye eecha wor, ‘Nota eeta riiti yikapwa tabato.’ ");
INSERT INTO kmo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Wowak, nota riiti yikapwa tawey, boyewak nota eecha hikitu God riita gol, silva, pap tawaga eecha tawa boboy? Boyewak nota eecha hikitu ma yecha yechi tapak sikiyawas otiito? ");
INSERT INTO kmo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mashi ma ye saka hikitarek, God riita riiti miy dumur. Nota kapasek boboyen otiitari, rii hekasakech. Wowak, apa riita eyey man eyey eemen hechi wocho, ‘Kapasek yon na kayek heechi inyaka na dareboy!’ ");
INSERT INTO kmo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Riita nedii pochin nagwa nobok wotarek, riita eyey diita nosapek tawa man riipa nagwa nagwa yenya anaseechikiita. Rkiita ma poren hisiiri, riipa keena kwona anaseechikiita. Diita man riita hisiirek, riita riina ha tawa eemek awasen yeechi yesokwar. Yeechi yesokwachi, otiirek, apa diita nona otiichichu: Rii eeta anasakii tawa ma siiken.” ");
INSERT INTO kmo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Worek, ye Pol riita ha tawa man otii saniyeechi yesokwa tawa maji meejirek, ma kaw yecha riina wohega wokwoyar. Anadii ma ye meejichi eecha wor, “No eeta diita majin kawka meejiken.” ");
INSERT INTO kmo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Worek, Pol rii ya yopo yichawa eemek tarin rii heechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ma kaw yechaba Jisas riina hiki siitiichir. Sumo ir ma por riiti hi Daionisias. Riita Ariopagas tar ma. Sumo ibar mima pochi siiti hi Damaris. Anadii ma ye hiki siitiichiniga Pol riina sumowu ibar. ");
INSERT INTO kmo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","2","Worek, Pol riita Atens akamak heechi Korin akamak ir. Korin akamak Ju ma por tari, riiti hi, Akwila. Riin Pontas akamak yimowur. Akwila riita riiti mimaka, Prisila, piir Itali nosapen heechi yar. Harapa Rom gavman ma, riiti hi Klodias rii majin wotarek, eyey Ju ma ye Rom akaman heechi ir. Eena Akwila rii heechi yabar. Worek, Pol rii riina heken ir. ");
INSERT INTO kmo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Worek, rii riiti akak heechi ir. Ichi rii eeka siir. I siirek, rii yechaka yo eecha otiitar. Riiti yo eeta sapi akan otiitar yo. Akwila riiti yo ii taba. Eena Pol riita i otiitar. ");
INSERT INTO kmo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Eyey Sabat nedii rii Ju ma yechi lotu aka ichiniga maji awasen awasen batar. Ju ma Grik ma yechi inyakak hikitar nobon darboyeken eena batar. ");
INSERT INTO kmo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas, Timoti piir Masedonia nosapen heechi Korin akamak iyarerek, Pol riita God riiti majiban eena sawotar. Rii Ju ma yenya sawotar: Jisas rii eeta Kraist. ");
INSERT INTO kmo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Worek, ye meejichi riina nasowoyechi riiti maba riigiin varekwo poyechi rii eecha wor: “Kwota sii siiken siiney, ii eetakwota mayama otii tepekeyineechi yeyuwa. Ada otii kapasek siikaskech. Kwoti yo. Apa ada akar biish tawa ma yechaka eecha ikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Worek, rii yenya heechi i akar biish tar ma por riiti akak i siir. Eeta ma riiti hi Tisias Jastas. Rii God riiti hin habatar. Riiti aka Ju ma yechi lotu akak bana bana tar. ");
INSERT INTO kmo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispas, rii Ju ma yechi lotu akak harapa ma tarek, rii Jisas riina hiki siitiichichar. Rii riiti mima yikapwaka eecha hiki siitiichibatar. Anadii Korin ma mima ye eechaba meejichi hiki siitiichibachi yen uku yeechir. ");
INSERT INTO kmo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Niy pochi Pol riita wa sukwiyaniga Jisas riina her. Herek, Jisas rii riina eecha wor, “Pol, opoche akiitanakech. Miita na eeji maji geenyik na kwodii wocha. Mii opoche egesii heechitanakech. ");
INSERT INTO kmo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ada miitaka eecha tawa. Diika tawa ma por rii miina otii pishemanakasakech. Eeji nokwapa nokwapa ma mima diika akamak tawa.” ");
INSERT INTO kmo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Worek, Pol rii 18 niiwiika eeka siiniga eeka tar ma mima yenya God riiti majin sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Worek, komas Galio rii Rom yechi harapa gavman ma tar. Rii Grik nosap siitii kow tar. Tarek, Ju ma ye ya yopo wuchi yichiniga Pol riina tapa tobok yeechi maji anasak ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yecha eecha wor, “Diita ma rii ma mima yenya maji pokii tawak, God riiti hin yesokwaken maji pokii tawak nobo kapasek batawak, ye noti lon eena nasowoyetu.” ");
INSERT INTO kmo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol rii majin bak otiirek, Galio rii Ju ma yenya majin eecha wor, “Ju ma, riita kapasek yon kapasek boboyen otiiyega, ada waga kwota bawa majin meejuwa. ");
INSERT INTO kmo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Diita maji eeta kwoti maji, kwoti hi, kwoti lo, eena eeta o maji na kwota otiiniga hama. Eeta yikadey boboyen ada keena saka anasakiitawak!” ");
INSERT INTO kmo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Worek, rii yenya maji anasa tawa akak yeechi rabor. ");
INSERT INTO kmo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Worek, yecha Sostenis, Ju ma yechi lotu aka harapa ma, Grik ma ye riina yeechiniga ye i maji anasa tawa aka sabak riina kubuk pir. Piri, Galio rii eena inyaka hikikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Worek, Pol rii Korin akamak Kristen yaka kumwoy yechaka nokwapa nokwapa yadii eeka siir. Siirek, riita yenya heechi Akwila, Prisila piiriita yechaka Siria nosapek eeka ir. Eeta nedii Pol riita Senkria akamak maji wohowuchi eena rii riiti masebiyan yechir. Yechirek, ye jabiirek ir. ");
INSERT INTO kmo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Iri, yecha Epesas akamak iyarer. Iyarerek, Pol rii Prisila, Akwila piiriina heechi rii ir. Ju ma yechi lotu akak eeka ichi Ju ma yechaka eecha maji ba tar. ");
INSERT INTO kmo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Worek, yecha riina woher: “Miita kawka diika na sii.” Woheri, rii yuyar. ");
INSERT INTO kmo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Worek, rii yenya heechi iken otiirek, yenya woshiachi eecha wor, “God riita wonyak, ada kapo awasen yakiita.” Worek, rii eeta heechi Epesas akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Irek, Sisaria akamak iyarerek, Jerusalem akamak ir. Iyarerek, Kristen ma yenya woshiatar. Worek, rii heechi Antiok akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Iri, eeka siirek, rii way kawka heechi ir. Galesia nosapek, Prisia nosapek icharek, Kristen ma yenya rii i otii kiyapoyichichar. ");
INSERT INTO kmo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ju ma por tarek, Aleksandria akamak riina eeka yimowurek, Epesas akamak ya tar. Riiti hi eeta Apolos. Riita God riiti keyir majin harapa hikitar. Rii maji harapa batar ma. ");
INSERT INTO kmo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Riina God riina sumowu tawa nobon hehar mukuchichar. Mukuchicharek, rii Jisas riita otiir boboyen rii hagayegachi man hehar sawo mukuchi tar. Worek, rii Jon riita uku yeechir nobon rii hechar. ");
INSERT INTO kmo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Worek, rii Ju ma yechi lotu akak anabeyichi siitii geenyik kwodii wochar. Worek, Prisila, Akwila piiriita riina mejichi piir riina yeechi piiriiti akak ye ichi God riiti nobon kawka kwodii wo mukuchichar. ");
INSERT INTO kmo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Worek, Apolos rii Grik nosapek iken hikitarek, Epesas tar Kristen ma ye riina kiyatyer. Ye Grik ma Kristen yaka kumwoy yen jeyen keyichi heechirek ir. Maji eecha keyir riina napa woshia. Worek, rii iyarechi rii Kristen ma yenya harapa kiyatayetar. Kata Kristen ma ye God riita nona yeyada rukusii tawa nobok eeka hiki siitiichichar. ");
INSERT INTO kmo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos rii harapa maji batarek, rii Ju ma yenya dagiir poyechi sawotar. Eyey ma mima yechi mi somak dagiir poyechi mukuchichar Jisas rii eeta Kraist. ");
INSERT INTO kmo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos rii Korin akamak tarek, Pol rii howuk tar nosapek eeka i iri, Epesas akamak iyarer. Iyarerek, rii God riina sumowu tar ma mima kawen her. ");
INSERT INTO kmo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Hechi rii yenya woher, “Kwota hiki siitii chiri kwoboy Holi Spirit riina yar?” Ye meejichi awasen eecha wor, “No Holi Spirit maji meejikasakech.” ");
INSERT INTO kmo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Worek, Pol rii yenya eecha woher, “Wowak, kwo kapo shecha tawa uku yeechir?” Yecha awasen yenya wor, “Jon riiti uku yeechi tawa boboyek uku yeechir.” ");
INSERT INTO kmo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol rii awasen eecha wor, “Jon riita uku yeechi tar boboyen ii kapasek boboyen magiirechichar ma yenya hatar. Rii Isrel ma yenya eecha wor, “Ana sumowu yak tawa ma riina napa hiki siitiichi. Rii eeta Jisas riina napa kwo hehar hiki siitiichi. ");
INSERT INTO kmo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ye meejichi Harapa Jisas riiti hik ye eeka uku yeechitar. ");
INSERT INTO kmo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol riita riiti tapan yesokwachi yechi masiiken gamurek, Holi Spirit rii yechak ya tar. Ya tarek, ye akar majin saniga saniga batarek, ye God riiti majin sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Diita ma mima ye 12 tar. ");
INSERT INTO kmo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Worek, Pol rii Ju ma yechi lotu akak eeka ichinga God riiti majin rii siitii anabeyechi yenya sawotar. Niiwiika piiriichar rii eeka ma mima yenya sawotarek, awasen awasen maji batarek, yechi inyakan God riiti hehar rukusii tawa boboy eena dareboyeken otii otii hechar. ");
INSERT INTO kmo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Worek, ma kaw ye mabiya gii siitiichiniga saka hiki siitiichirek. Worek, eena yecha Jisas riiti nobon kapasek majin batar. Eyey, ma mima yechi miy somak batar. Worek, Pol riita eeta Jisas riina sumowu tar ma yenya yeechi heechi ir. Irek, rii Tiranas maji batar akak eeka yi maji batar. Eyey yadii rii awasen awasen maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Sukwiya upurus rii eeka eecha otiichir. Otiichirek, eyey ma mima Esia nosapek tarek, Ju ma ye akar biish tar ma yechaka Jisas riiti majin meejitar. ");
INSERT INTO kmo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God riita otiichirek, Pol harapa wopu dareboy tawa boboy mayakan otiir. ");
INSERT INTO kmo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ma kaw ye Pol riiti neekitar siivatabin yeechi hak otiitar man ye i hatarek, ye eeta kepi sii tar. Kapasek gaba ye yenya heechi akii ir. ");
INSERT INTO kmo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ju ma kaw ye akar nosapek i ye yatari, ye kapasek gaban yeechi rabotar yon eena otiitar. Otiitarek, ye Harapa Jisas riiti hin eena otii hechar. Yecha kapasek gaba yenya eecha wor, “Jisas riiti hik Pol riita sawo tawak ada miina wocho.” ");
INSERT INTO kmo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ma por rii tari, riiti hi Siva, rii Ju ma yechi harapa opelen otii tar ma tarek, riiti ma yikapwa 7 eecha tar. Riiti yikapwa yechaka eecha otiitar. ");
INSERT INTO kmo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma poren ye eecha otiirek, kapasek gaba rii maka eecha tarek, rii eecha wor, “Ada Jisas riina hikitu. Ada Pol riiti hin meejibatawak, kwo kapo eeta namey ma?” ");
INSERT INTO kmo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Worek, gabaka tar ma rii yenya harapa o ana pi rii yenya dagiir poyer. Dagiir poyechi yenya piniga arowa piken otii heechirek, maba biish akii ir. ");
INSERT INTO kmo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Eyey Ju ma, akar biish tar ma ye Epesas akamak tari, ye meejichi harapa akii tar. Worek, Jisas riiti hin yecha harapa yesokwa tar. ");
INSERT INTO kmo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nokwapa nokwapa Kristen ma ye yaniga ye ma mima yechi misomak yecha kapasek otii tar boboyen geenyik kwodii wor. ");
INSERT INTO kmo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nokwapa nokwapa ma ye siiga kapa otiitar ma mima keyapo otiitar ma ye yechi buken yeechi yayaniga ma mima yechi mi somak eeka hik tukur. Ye moni tokor abon kenyi otiitarek, eyey moni 50,000 dola. ");
INSERT INTO kmo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Diita yikadey nobo Jisas riiti maji sokwa hapaga siirek, eyey eemek i ye yar. ");
INSERT INTO kmo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Diita boboyen otiirek, Pol rii God riina maji bachi eecha hikir Masedonia nosapek Grik nosapek i Jerusalem akamak iken eena hikir. Rii eecha wor, “Inyak, ada Rom akamak heken ik.” ");
INSERT INTO kmo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Worek, rii Timoti, Irastas piiriina Masedonia nosapek heechirek ir. Piir riiti kiyatayetar ma. Irek, Pol rii Esia nosapek kawka eeka siir. ");
INSERT INTO kmo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","God riiti nobon ma mima ye sumowutarek, kapasek boboy eeta Epesas akamak sokwar. ");
INSERT INTO kmo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ma por rii tarek, ri hi Dimitrias rii silva sikiyawas kiiriikar akan otiitar. Atemis sikiyawas siiti akan otiitar. Otriitarek, riita riiti yon otiitar ma ye harapa moni yan yatar. ");
INSERT INTO kmo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Worek, rii uwatarek, ri yon otiitar ma, akar ma diita yikadey yon otiibatar ma, yechaka eecha ya yopo yicharek, rii eecha wor, “Kwonawa, kwo eecha hikitu kwo diita yon toiitawak harapa moni yan yato. ");
INSERT INTO kmo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Wowak, kwo hecho kwo meejito diita Pol riita otii tawa yo. Rii eecha wocho: ‘Mak otii tawa sikiyawas ii omutiikakasakech.’ Wowak, ma mima ye riiti majin meejichi ye hikitar. Diita Epesas akama Esia nosapek yecha riita batar majin meejito. ");
INSERT INTO kmo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ada eecha hikitu Pol rii kawka otiitaney, noti yan ya tawa nobo hi kapasek habakiita. Wowak, ada eecha hikitu harapa Atemis sikiyawas siiti lotu akak sii eeta kubuchey boboy siikiita. Siiti hin eyey eemek Esia, eyey akar nosapek yesokwa tar. Yesokwa tarek, komas siiti hin eeta dagiir poyekiita.” ");
INSERT INTO kmo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Epesas ma ye diita maji meejichi ye harapa inyaka kwotayer. Kwotayechi ye eecha uwar, “Epesas yechi sikiyawas, Atemis, sii eeta harapa!” ");
INSERT INTO kmo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Worek, yecha uwari, eyey akama tar eemek eyey uwa ye ir. Worek, ma upurus Pol, riitaka eecha chishi ye i tar. Piiriiti hi Gaias, Aristakas. Piir eeta Masedonia ma. Ma ye piiriina yeechi ma yi gey eemek ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol riita ma mima yechi nediik iken gegiyatarek, Kristen ma ye riina anacheker. ");
INSERT INTO kmo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Gavman ma kaw ye Pol riiti nareboy tari, ye riina maji wochirek ir: Mii opoche yechi mi somak i siitii maji batanakech. ");
INSERT INTO kmo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Eecha otiitarek, ya yopo yichi tar ma yecha eechaba eechabga uwatar. Ma kaw ye saniga saniga ba ye ir. Akar ma ye akar maji ba ye ir. Yari, ye yar mun hekasakech. ");
INSERT INTO kmo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Worek, ma kaw ye Aleksanda riin wo diimar. Ju ma ye otiichirek, Aleksanda rii yechi mi somak siitiir. Worek, Aleksanda rii tapan ye yo wuchi yenya maji baken otiir. ");
INSERT INTO kmo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Worek, ma ye riina hehar heri rii eeta Ju ma. Worek, ma ye eyey kikibak uwa yesokwa tar, “Epesas yechi sikiyawas, Atemis, sii harapa.” Aua upurus ye eecha uwa yesokwatar. ");
INSERT INTO kmo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Worek, Epesas akama jebwa keyi tar harapa ma rii yenya kabuk wor. Kabuk wochi rii maji har: “Kwo Epesas ma, eyey ma mima eecha hikitar Epesas akama sii Atemis siiti lotu aka siitii kowutar. Tarek, nota neerek sakar papan eena siitii kowu tar. ");
INSERT INTO kmo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ma mima ye diita boboyen nasowoyekasakech. Wowak, kwo na eshar ta. Kwo kapasek boboy ameya atiikasakech. Wowak, kwo na eshar ta. ");
INSERT INTO kmo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Diita ya yawa ma piir lotu akak tawa boboyen hiyik yakasakech. Piir noti sikiyawas siina kapasek majin bakasakech. Wowak, kwo piiriina diika yeechi ya yawa. ");
INSERT INTO kmo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Wowak, Dimitrias rii riiti yo otii tawa ma ye akar ma yenya majika siiney, yecha napa keena yenya ye iniga maji anasa. Harapa gavman ma ye diita tawa. Tawak, yecha eeka maji anasakiita. ");
INSERT INTO kmo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Wowak, kwo anadii maji anadii boboyen otiiken gegiyaney, yecha gavman ma yecha majin sawo tawa akak ne i meeji. ");
INSERT INTO kmo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Na ow poy sii ta. Nota diita boboyen otii tawey, no own yesokwatawey, gavman ma ye kapo nona majika eecha siikiita. Diita own yesokwa tawa boboy sii mukasakech. Eena wohenyey, napa boyen mu eena mukuchikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Worek, ye yopo yichari rii yenya wochirek, ye heechi i ye yar. ");
INSERT INTO kmo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Eecha otiir boboy sii hamarek, Pol rii uwarek, Kristen ma ye meejichi ya yopo yir. Yirek, rii yenya kiyapo maji bachi yenya woshiar. Worek, rii heechi Masedonia nosapek ir. ");
INSERT INTO kmo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Diita nosapek iri, rii ma mima yenya maji kiyapo batar. ");
INSERT INTO kmo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Worek, rii Grik nosapek iyarerek niiwiik piiriichar eeka siir. Siirek, rii Siria nosapek iken rii eena sayarechi rii meejir Ju ma ye riina sowakwoken eena hikitar. Worek, rii inyaka dareboyechi Masedonia nosapek awasenheechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Worek, Sopata, rii Piras riiti yikapwa, riiti eem eeta Beria, rii Pol riitaka eecha ir. Aristakas, Sekandas, Tesalonaika akama ma, piir riitaka eecha ibar. Gaias, Debi ma, rii, Timoti rii, Tikikas rii, Tropimas rii, piir Esia ma, yecha Pol riitaka eecha ibar. ");
INSERT INTO kmo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yecha mapo iri Troas akamak eeka nona kowutar. ");
INSERT INTO kmo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Worek, yis biish gey nokusha ar nedii hamarek, no Pilipai akaman heechi jabiirek ir. Yokotapa yadii hamarek, no i yenya Troas akamak her. Worek, wik pochi eecha siir. ");
INSERT INTO kmo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Worek, Sade niy siirek, no otii aken eena ya yopo wuchi yichar. Worek, Pol rii ma mima yen maji sawor. Sawo i i i niy nedii siir. Rii niyegak heechi iken otiirek, eena yenya maji sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Yecha ya yopo yichi eem sii eeta howuk tar. Nokwapa nokwapa haba eeka shikii tar. ");
INSERT INTO kmo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Worek, hadiiyey ma por eeka tari riiti hi Yutikas. Rii aka windo eeka yichar. Dii eeta harapa howuk tar aka. Piiriichar chey eeka yo tar. Pol rii maji sawo tarek, Yutikas rii miy meejirek, rii eena watar. Riita miy meejinga wa he ir. Wa he irin, eeta riibaga sakar. Sakarek, ye i riina yeechi yesokwachi heri rii eeta har. ");
INSERT INTO kmo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Worek, Pol rii eeta ye ir. Ye iniga eeta yikapwa riin yeechiniga anapiirer. Worek, rii eecha wor, “Inyakapwa harapa hikikasakech. Rii tawa.” ");
INSERT INTO kmo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Worek, rii howuk kawka yo ir. Ichi geyen yeechi reekii tarek, ye atar. Atarek, rii yenya maji awasen awasen sawotar. Sawo sawo uhadiirek heechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Worek, yecha hadiiyey ma riina yeechi akak ye irek, yechi inyaka kwoya hiki tar. ");
INSERT INTO kmo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nota kawka i ichi jabiirek i ye ichi Asos akamak iken otiir. Nota i Pol riina jabiirek eeta akamak yeechi yakiita. Mapo Pol riita majin nona eecha wotar. Riita nosapek yatiik ichaken eena rii eecha wor. ");
INSERT INTO kmo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Worek, rii nona ya Asos akamak hechi nota riina jabiirek yeechi Mitilini akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nota eena heechi iyi nediik Kaios akamak bana bana iyarer. Komas nedii pochi nota Semos akamak iyarer. Iyarerek, heechi komas nedii pochi Mailitas akamak iyarer. ");
INSERT INTO kmo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol riita hikichi Epesas akama saka igayerek. Yadii eeta Esia nosapek hamanakech eena yuyar. Eena Esia eyey nosapek saka gaerek. Rii Jerusalem ameya iken eena heechi ir. Rii Pentikos nedii bana bana siirek rii eena ameya i Jerusalem akamak siiken eena ir. ");
INSERT INTO kmo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pol rii Mailitas akamaka gayerek rii majin Epesas akaman wochirek ir. Kristen ya yopo yichar harapa tar ma yecha Mailitas akamak yaken eena wor. ");
INSERT INTO kmo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ye yarek, Pol rii yenya eecha wor, “Ada Esia nosapek mapo yarek, ada kwotaka eecha siir. Siirek, kwo ada otii tawa abon kwo her. ");
INSERT INTO kmo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kwo hikitu nokwapa nokwapa yadii Ju ma ye ana dagiir poyek hikitar. Worek, ada eeji hin dagiir poyer. Ada God riiti yoban otiir. ");
INSERT INTO kmo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kwo hikitu ada kwona God riiti maji sawotarek, ada kiyatay tawa boboyen kwona saka egesiitarek, kwoti adak kwoti akama magey tawa eemek ada kwona sawotari, an egeysiikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ju ma yenya akar biish tar ma yenya ada ow poy siichi wor, ‘Kwoti kapasek boboyen na magiirechichi God riina na dareboyechi hechi Harapa Jisas Kraist riina na hiki siitiichi.’ ");
INSERT INTO kmo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Apa ada Holi Spirit riina sumowutawak, ada Jerusalem akamak ichu. Inyak an saka hikitawak ye kapo an shecha otiikiita. ");
INSERT INTO kmo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ada hikitu eyey ‘Poko jichawa boboy kapasek otii tawa boboy adak yakiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","“Wowak, ada eecha hikitu eeji maba eeji popwoy eeta kubuchey boboy. Ii siikayekesii eeji yon Harapa Jisas riita ana harin ada eena otii hamak. Har yo diitata: God riiti hadabas yeyada rukusii tawa boboyen ada sawoto. ");
INSERT INTO kmo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ada kwotaka eecha chishi ye i tari ada God riita nona yeyada rukusii tawa majin kwona sawotar. Worek, ada apa eecha hikitu kwo ana kawka saka hekiitawak. ");
INSERT INTO kmo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Eena apa ada kwona harapa bato: ma por kwotaka eecha tawey, riita kapasek eemek iyey, ii eeji yokasakech. ");
INSERT INTO kmo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","God riiti maji mun hiki tawa boboyen ada kwona egesiinak, heechikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kwo mayama na siitii kwo tanak na ow poy sii ta. Kwo eeta sipsipen Holi Spirit riita harin na siitii kowu ta. God riiti Kristen ma mima yen na hehar ta. Rii eena riiti pik tokor. ");
INSERT INTO kmo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ada eecha hikitu ada heechi inyak, komas kwashik tawa asa yecha kwotaka eecha ya siichi sipsip yenya kapasek otiikiita. ");
INSERT INTO kmo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Eeta nedii yanak, kwotaka tawa ma ye woshepii maji batanak, Jisas riina hiki siitiichichawa ma yenya yechi kapasek nobok woshepiichi ye iken otiikiita. ");
INSERT INTO kmo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Wonyak na ow poy siitanak na hiki ta. Eechaba eechaba yadii na niy, sukwiya piiriichar, ada kwona keyamuk sakatawak, ada kwona eyey maji pokii tar. ");
INSERT INTO kmo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Apa ada kwona God riiti tapak howu heechitu. Riiti yeyada nona rukusii tawa majik eeka heechitu. Riita keena kwona otii yesokwachikiita. Eeta ma mima yen God riita hisiirin God riipa komas yakiitawa boboyen kwotaka yechaka hakiita. ");
INSERT INTO kmo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ada ma por riiti gol, silva siivatabin eena kwoya he makasakech. ");
INSERT INTO kmo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kwo mayama eecha hikitu ada eeji apomaka boboyen dopoyega, eeji tapak ada keena otiichi yayar. ");
INSERT INTO kmo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ada otiitarek, ada kwona mukuchir nota na yo harapa otii ta. Otii tanak, nota kubuchey man kiiriisiiposii tawa man na kiyatayi ta. Harapa Jisas riita wochar majin eena na hiii ta. ‘Eeta ma rii boboyen sobo haney, rii eeta ameda kwoya hikikiita.’” ");
INSERT INTO kmo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol riita yenya maji ba hamarek, riita yechaka yatii bogok putiichi yiniga God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Yecha riina tapak neekichi omore amorechi keyatar. ");
INSERT INTO kmo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pol riita yenya worek, yecha riina saka komas kawka hekiitawak, eena yecha harapa inyakapwa hikitar. Worek, yecha riina jabiirek ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nota yenya woshi achi jabiirek ye ichi heechi ir. Heechi nagwa nagwa i Kos nosapek eeka ir. Yadii nedii pochi nota Ros nosapek eeka ir. Heechi iri Patara akamak ir. ");
INSERT INTO kmo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Eeka igayerek, nota Pinisia nosapek iken otiitar jabiiren her. Hechi yey ibak i ye ichi ibar. ");
INSERT INTO kmo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","No heechi i Saipras nosapen her. Hechi mama yepak i Siria nosapek ir. Worek, i Taia akamak igayer. Jabiirek igayechi boboyen heechiken eena eeka igayer. ");
INSERT INTO kmo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Worek, no eeka Kristen ma kawen yenya hechi 7 yadii nedii yechaka eecha siir. Siirek, ye Holi Spirit riiti pawak Pol riina eecha wor, “Mii Jerusalem akamak opoche ichanakech.” ");
INSERT INTO kmo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nota tawa nedii eeta hamarek, nota yenya heechi nobok ir. Heechi ik otiirek, eyey ma mima ye yechi yikapwa yechaka notaka eecha i geenyik i yarechi iri, pagiirebak yiniga yatii bogok putiichi no God riina maji batar. ");
INSERT INTO kmo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Worek, woshi atarek nota jabiirek i ye irek, yecha yechi akamak awasen ir. ");
INSERT INTO kmo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","No icharek, Taia akaman heechi Tolemes akamak igayer. Igayechi Kristen ma yaka kumwoy yenya woshi achi yechaka niy pochi eecha siir. ");
INSERT INTO kmo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Siirek, komas yadii pochik no heechi Sisaria akamak iyarer. Iyarerek, Pilip, God riiti majin sawotar ma, riitaka eeka eecha siir. Eeta nedii 7 ma yenya mashi Jerusalem akama hisiirek, Piip riin hisiibarek, rii yechi nediik tar. ");
INSERT INTO kmo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Riiti mima yikapwa diipiira kapiira tarek, riiv siikiikasakech. Yecha God riiti majin hehar sawotar. ");
INSERT INTO kmo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nota yadii kaw eeka tarek, Judia nosapek tar piirapet por rii yar. Riiti hi, Agabas. ");
INSERT INTO kmo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Rii notak eecha yaniga Pol riiti let yeechi rii mayama yatii tapan poko jir. Poko jichi eecha wor, “Holi Spirit rii eecha wocho: Diita let ma riina komas Jerusalem akamak Ju ma riina eechaba otiikiita. Otiitanak, yecha riina akar biish tar ma yechi tapak hakiita.” ");
INSERT INTO kmo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nota diita maji meejiri no Pol riina woyashachiyasa woher, “Mii Jerusalem akama ikasakech.” ");
INSERT INTO kmo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Worek, rii awasen eecha wor, “Kwo boyen wocho? Kwo boyewak eecha keyato? Kwo eeji mesken diigiito. Ada lowutu Jerusalem akamak inyak yecha anapa poko jinyak, wonyak, yecha ana sowakwok wonyey, sapa Harapa Jisas riiti hik ana sowkawo.” ");
INSERT INTO kmo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Worek, nota riiti inyaka saka dareboyerek. Worek, eena nota kawka wohekasakech. No eecha wor, “God riiti inyakak sapa otii.” ");
INSERT INTO kmo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Yadii kaw eeka siirek, nota noti boboyen sayarechichi Jerusalem akamak heechi ir. ");
INSERT INTO kmo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sisaria Kristen ma kaw ye notaka eecha ibar. Ibachiniga ye nona ye i nota siik ir ma riiti akak ye i heechir. Riiti he Heson. Rii mashi Kristen ma tar. Riin Saipras akamak yimowur. ");
INSERT INTO kmo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nota Jerusalem akamak iyarerek, Kristen yaka kumwoy yecha inyaka kwoya hikichi yar. ");
INSERT INTO kmo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Worek, komas yadii pochi siirek nota Pol riitaka eecha Jems riina heken ir. Irek, Kristen hehar tar harapa ma ye riitaka eecha tar. ");
INSERT INTO kmo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Worek, Pol rii yenya woshi achi rii akar biish tar man sawotar majin eena geenyik kwodii wor. God riita Pol riitaka otiirin rii eena sawobatar. ");
INSERT INTO kmo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sawotarek, yecha meejichi God riiti hin habatar. Worek, yecha Pol riina eecha wor, “Yaka, mii hikitu. Tausen Ju ma kaw ye Kristen ma siir. Kristen ma siichiniga ye Moses riiti kon hehar sumowutu. ");
INSERT INTO kmo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Worek, yecha maji meejichi ye hikitu miita Ju ma yenya akar nosapek taweyn miita yenya eecha wochar Moses riiti ion na heechi, yechi yikapwa opoche yechi sapi dagiitanakech. Ju ma yecha otii tawa abon na heechi Ju ma diika tawey, ye miita maji sawo chishi tarin meeji hamar. ");
INSERT INTO kmo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Diita Ju ma ye meejikiita mii diika iyarer. Nopa boy shecha otiik wonyak? ");
INSERT INTO kmo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nota miina wonyak na otii! Ma diipiira kapiira diika tawey ye God riina maji wohowu tar. ");
INSERT INTO kmo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wohowu tarek, yechaka na eecha i. Moses riita bar uku yeetii tawa abo na i kikibak eechaba otii. Otiitanak, miipa yenya moni hatakiita. Hatanak, yecha yechi masibiyan yechetakiita. Miita diita nobon sumowu taney, eyey ma yepa hikikiita eeta maji miina bari, ye meejiri, eeta omutiikakasakech. Miita otiinak, yecha hikikiita miita Moses riiti lo majin sumowutu.” ");
INSERT INTO kmo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Wowak, yecha akar biish tar Kristen ma yechak wor, “Nota akar Kristen ma yenya jeyn heechirek ir. No eecha wor, ‘Kwota ma yecha woshepii sikiyawas hana kiya kwo opoche abatanakech, pin opoche abatanakech. Pika tana kiya opoche atanakech. Mimaka tawey, opoche akar mima kapasek otiitanakech. Miman anemesh rokotanakech.’” ");
INSERT INTO kmo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Worek, komas yadii pochik Pol rii diita ma yenya yeechi ye i uku yeetiir tawa abon otiir. Worek, rii Ju ma yechi harapa lotu akak iyarer. Iyareri akak tar harapa ma yenya eecha wor: “7 yadii komas noti uku yeetii tar nedii hamakiita. Eeta yadii hamanak nona saniga saniga opelen otii tawa boboyen otiikiita.” ");
INSERT INTO kmo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Yadii 7 siik otiirek, Esia nosap Ju ma kaw y Pol riina harapa lotu akak her. Hechi ye ma mima yenya ow yesokwa maji bar. Worek, yecha Pol riina neekichi uwar, ");
INSERT INTO kmo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Isrel ma, na kiyatayi! Diita ma rii eyey eemek chishi maji pok ye iniga Isrel ma mima yenya, Moses riiti ion eena, noti harapa akan, rii dagiir poyetu. Apa rii akar biish tar ma kawen yeechi diita harapa otu akak yasayabachi diita hadabas eemen rii kapasek otiiwa.” ");
INSERT INTO kmo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Yecha her Pol riitaka Tropimas, Epesas ma, riitaka akamaka tar. Tarek, heri ye eecha hikir Pol rii riina harapa lotu akak ye ir. Eena ye eecha wor.) ");
INSERT INTO kmo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Worek, ow maji yesokwari, eyey akama eemek maji i ye yar. Worek, nokwapa nokwapa ma mima ye amaba yari, yaniga Pol riina ya yopo wuchi riina neekichiniga riina sabak ye ir. Worek, harapa lotu aka siiti nubereja siina dasepiir. ");
INSERT INTO kmo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ma ye Pol riina sowakwoken eena otiitarek, maji heechirek ir. Rom harapa o ana pichar kepten ma riina heechirek ir. Maji eecha wor, “Eyey Jerusalem ma ye kapasek boboyen yesokwachi eena otiiken otiito.” ");
INSERT INTO kmo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Worek, kepten rii o ana pichar ma kawen yeechi ye yechaka eecha amaba ir. Irek, Jerusalem ma ye o ana pichar ma yenya heri, ye Pol riina kawka pikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Worek, kepten rii Pol riitak iniga riina yeechi rii eecha wor, “Sen poko upurusek riina na ji.” Jirek rii eecha woher, “Diita ma kapo nama? Rii boyen otiiwa?” ");
INSERT INTO kmo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Worek, ma kaw ye maji pochik worek, ma kaw ye akar majik wor. Maji harapa batarek, kepten ma rii eeta maji mun hehar meejikasakech. Worek, rii riiti o ana pichar wakasa ma yenya wor, “Diita ma riina o ana pichar ma yechi akak na yeechi ye i.” ");
INSERT INTO kmo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Yecha riina aka toku muk yar. Yarek, Ju ma ye harapa kwotayeechi Pol riina piken otiitarek, eena o ana pichar ma ye riina yeechi yesokwa neeki howuk kiyaniga ye yo ir. ");
INSERT INTO kmo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ye riina sumowuniga uwar, “Riina na sowakwo.” ");
INSERT INTO kmo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Worek, ye Pol riina aka wok ye iken otiitarek, Pol rii kepten riina Grik majik eecha wor, “Ada miina maji kawen work.” Kepten rii meejichi eecha wor, “Mii boy Grik majik bato? ");
INSERT INTO kmo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","An eecha hikitu mii kapo kata Isip ma rii mashi kapasek maji yesokwarek, 4,000 ma eekik tari ye riina sumowuniga me biish tar eemek i own yesokwaken eena eeka ir. Mii boy eeta ma?” ");
INSERT INTO kmo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol rii awasen eecha wor, “Yaho. Ada eeta Ju ma. Ana Silisia Tasas akamak, eeta harapa akamak, eeka yimowur. Sen, ada ma mima yenya maji bak.” ");
INSERT INTO kmo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Worek, kepten rii eecha wor, “Na ba.” Worek, Pol rii aka tokuk howuk yo eeka siitiichi rii riiti tapan mima man yenya yesokwar. Yecha wokwinya siitiirek, Pol riita Hibru majik bar. ");
INSERT INTO kmo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol rii eecha wor: “Ma, yaka kumwoy, eepi, kwota ana na meeji. Ada he meeji taweyn eena ada kwona bak.” ");
INSERT INTO kmo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Rii Hibru majik saworek, ye meejirek, ye eena kawka wokwinya siitiir. Worek, Pol rii yenya eecha wor: ");
INSERT INTO kmo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ada eeta Ju ma. Ana Silisia Tasas akamak eeka yikowur. Yimowurek, ada Jerusalem akamak sokwa harapa siir. Siirek, gameliel riita ana maji pokii tar. Pokii tarek, ada noti wayega yechi ion ada hehar meejitar. Meejitarek, kwota apa God riina sumowu tawabaga, ada eechaba God riina hehar sumowutar. ");
INSERT INTO kmo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ada God riina sumowutarek, ada Jisas riiti nobon sumowuytar ma yenya ada kikirepoyechi sowakwoken otiitar. Ada yenya sen pokok jichi poko jichawa akak rabotar. ");
INSERT INTO kmo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Eeta harapa opelen otii tawa ma rii eyey kaunsil ma ye eecha wokiita ada maji siikiinen bato. Yecha jeyn keyichichi ada harapa Ju ma yenya Damaskas akamak tarin, haken eena har. Worek, ada Damaskas akamak ir. Diita nobon sumowu tar ma mima yenya yeechi sen pokok jichi Jerusalem akamak yayachiniga kubu piken eena ir.” ");
INSERT INTO kmo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ada nobok i Damaskas akamak bana bana siitarek, ayadii nedii harapa habaga tawa boboy neerek ya adak sakar. ");
INSERT INTO kmo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Worek, ada nosapek sakar. Nosapek sakachi uwar aya poren meejir. ‘Sol, Sol, boyewak miita ana kikirepoyetu?’ ");
INSERT INTO kmo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ada awasen eecha wor, ‘Harapa, mii kapo nama?’ Rii ana awasen eecha wor, ‘Ada Nasaret Jisas. Mii ana kikirepoyetu.’ ");
INSERT INTO kmo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Worek, adaka tar ma ye haba herek, ana uwar ayan ye meejikasakech. ");
INSERT INTO kmo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Worek, ada riina eecha wor, ‘Harapa, adapa shecha otiik wonyak?’ Worek, Harapa riita ana eecha wor, ‘Na sokwa Damaskas akamak eeka na i. Inyak, ma por rii miina hana yon God riita hisiichiri miina wokiita.’ ");
INSERT INTO kmo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Worek, haba ana harapa okoreetari, eena eeji miy saka herek. Eeena eeji apoma ye na tapa tobok neeki Damaskas akamak ye ir. ");
INSERT INTO kmo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Irek, ma por rii eeka tarek, riiti hi, Ananaias. Rii eeta God riiti hin yesokwabatar ma. Noti ion riita sumowubatar. Akar Ju ma ye Damaskas akamak tari ye Ananaias riiti hin kepi hiki tar. ");
INSERT INTO kmo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Worek, rii adaka yaniga siitiitarek, eecha wor, ‘Kumwoy, na kawka he!’ Eeta nediik ada ameya kawka her. ");
INSERT INTO kmo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Riina ada herek, riita ana wor, ‘Noti wayega yechi God rii miina hisiir. Riiti inyakan hikiken eena hisiir. God riiti yon otii kepi siir wakasa ma, ri hi Jisas, riina heken eena hisiir. Jisas riita kujak batar majin meejiken eena hisiir. ");
INSERT INTO kmo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Riita otiirek, miita riiti yon otiikiita. Miita her boboyen, meejir boboyen, miitapa sawotakiita. ");
INSERT INTO kmo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wowak, boyewak nota kawka kowutu. Na sokwa uku ya. Riiti hin na haba. Habanak, miiti kapasek boboyen kwoyavayakiita.’” ");
INSERT INTO kmo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ada Jerusalem akamak awasen heechi ir. Irek, ada harapa lotu akak God riina maji batarek, ");
INSERT INTO kmo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","sukwiyanaga ada Jisas riina her. Herek, rii ana eecha wor: ‘Na ameya sokwa Jerusalem akaman heechi i. Diita tawa ma mima ye miita ana bawa maji saka meejikiitawak.’ ");
INSERT INTO kmo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ada riina awasen eecha wor, ‘Harapa Jisas, yecha hikitu ada eyey lotu akak ichiniga miina hiki siitiichichawa ma yenya yeechiniga kubuk pichiniga poko jir. ");
INSERT INTO kmo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Miiti wakasa ma Stiven riina sowakworek, ada iibak tarek, hechi an eecha hikir eeta kepi. Ada sowakwo otii tar ma riiti riken ada siitii kowu tar.’ ");
INSERT INTO kmo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Worek, God rii ana eecha wor, ‘Na i. Ada miina akar biish tar ma yapak taweyn, ada miina wochanak ikiita.’” ");
INSERT INTO kmo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ju ma ye Pol riita mapo bar maji chepen hehar wageteytar. Wageteyetarek, 