﻿USE sofia;
DROP TABLE IF EXISTS sofia.kmk_vpl;
CREATE TABLE kmk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kmk_vpl WRITE;
INSERT INTO kmk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Satu dit matuntunan dat ginnapuwan Jesu Kristu un kaganakan didit Ali David un ganak didit Abraham. ");
INSERT INTO kmk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Sadit Abraham, aman dit Isaac. Sadit Isaac, aman dit Jacob un aman Juda kan sadadit sunud na. ");
INSERT INTO kmk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sadit Juda, aman dadit Fares kan Zara ot sadit Tamar dit ina da. Sadit Fares, aman dit Esron un aman Aram. ");
INSERT INTO kmk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sadit Aram, aman dit Aminadab. Sadit Aminadab, aman dit Naason un aman Salmon. ");
INSERT INTO kmk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sadit Salmon, aman dit Boaz un sadit Rahab dit ina na. Sadit Boaz, aman dit Obed ot sadit Ruth dit ina na. Sadit Obed, aman dit Jesse. ");
INSERT INTO kmk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sadit Jesse, aman dit Ali David. Sadit David, aman dit Solomon un imputut na utdit siguda asawan dit Urias. ");
INSERT INTO kmk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sadit Solomon, aman dit Roboam. Sadit Roboam, aman dit Abias un aman Asa. ");
INSERT INTO kmk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sadit Asa, aman dit Josafat. Sadit Josafat, aman dit Joram. Sadit Joram dit kapuunan Ozias. ");
INSERT INTO kmk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sadit Ozias, aman dit Joatam. Sadit Joatam, aman dit Acaz un aman Hezekias. ");
INSERT INTO kmk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sadit Hezekias, aman dit Manases. Sadit Manases, aman dit Amon un aman Josias. ");
INSERT INTO kmk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sadit Josias, kapuunan dit Jeconias kan sadadit susunud na. Siyatu dit timpu un namapilitan dat iBabilonia un nangaḻ-an sidat iyIsrael un pinambalin da dida’n baba-unon. ");
INSERT INTO kmk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Utdit inggawan da ud Babilonia, naiyanak si Salatiel ot si Jeconias dit amana. Sadit Salatiel, apun didit Zorobabel. ");
INSERT INTO kmk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sadit Zorobabel, aman dit Abiud. Sadit Abiud, aman dit Eliakim un aman Azor. ");
INSERT INTO kmk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadit Azor, aman dit Sadoc. Sadit Sadoc, aman dit Akim un aman Eliud. ");
INSERT INTO kmk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sadit Eliud, aman dit Eleazar. Sadit Eleazar, aman dit Matan un aman Jacob. ");
INSERT INTO kmk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ot sadit Jacob, aman ud Jose un asawan Maria un nangiyanak kan Jesus un mauguda Kristu. ");
INSERT INTO kmk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ot manipud kan Abraham inggana kan David awad da ud kagwampuḻu’t opata lonap. Kagwampuḻu’t opata lonap uman manipud kan David inggana’t dit naidallayan da ud Babilonia ot kagwampuḻu’t opata lonap payyan manipud sit naidallayan da ud Babilonia ingganaon sit naiyabengan Kristu. ");
INSERT INTO kmk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kama’t tu dit kaugudan dit naiyabengan Jesu Kristu. Si Maria un inana naipaad kan Jose, yoong utdit daan da payyan man-asawa natigammuwan Maria un nabugiyon maipagapu’t dit pannakabalin Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ot gaputa nalintoga tagu si Jose un naipaadana, adina piyaona maibabbain si Maria ot pinanggop na un isina si nalimod. ");
INSERT INTO kmk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kama’t di dit simsimmok na yoong nilumtaw ud anghel Apudyus kan siya si in-inop un kanana’n, “Jose un kaganakan Ali David, adika umogyata mangasawa kan Maria ta nabugi utdit pannakabalin Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mangiyanak si laḻaki ot ngadanon yu kan Jesus ta taguwona dan tagu utdan basuḻ da.” ");
INSERT INTO kmk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nakwa’n losan datu daḻapnu matungpal dit ugud Apudyus un paimbagana’t dit propeta na utdit un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mabugi’d osa’n babai’n daan payyan di laḻaki’n aduḻon ot mangiyanak si laḻaki’n mangadanan si Immanuel, un piyaona’n ugudon, ‘Awad si Apudyus kan ditaku.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Utdit lumikna si Jose, tinungpal na dit imbagan dit anghel Apudyus un koona, ot inasawa na si Maria. ");
INSERT INTO kmk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yoong adina yan inaduḻ inggana’t inyanak Maria dit bugi na un ningadan Jose kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Utdit naiyabeng si Jesus ud Betlehem un osa’n ili’d Judea utdit timpu’n nan-aliyan Herodes, inggaw da ud dummatong Jerusalem un nanligwat sin kapon lumtawan init un nalalainga tagu’n mangada-adaḻ sidan bituwon. ");
INSERT INTO kmk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ot inimus da un, “Kawad dit naiyabenga Alin di Judio? Naila mi dit bituwon sin kapon lumtawan init un nanigammuwan mi utdit naiyabengana ot inummoy kami’t tu un mandaydayaw kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Magngoḻan man Herodes di, amod dit danag na, kama pay sidat losana iJerusalem. ");
INSERT INTO kmk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pinandatdatong na dadit aap-apun di papadi kan mimistulun di lintog di Judio ot inimusana dida nu kawad dit maiyabengan dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Summungbat da un, “San Betlehem sidin probinsiya’d Judea ta siya’d ingkanglit dat propeta un, ");
INSERT INTO kmk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sika un Betlehem un ili’d Juda, bokona sika’d kadobaan sidan madaydayawa ili’d Juda ta sika’d manligwatan dit mangiyapu kan mangayyuwan sidat taguka kaganakan Israel.’” ");
INSERT INTO kmk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Utdi, inlimod Ali Herodes un pinaayag dadit nalalainga tagu daḻapnu ponkona kan dida dit kustu’n timpu’n nilumtawan dit bituwona inila da. ");
INSERT INTO kmk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Matigammuwana man, pinadaḻanna dida’d Betlehem un kanana’n, “Umoy kayu ot ammaan yu un inapon nat abeng ta nu maodasan yu, ipatigammu yu kan sakon ta umoyak pay mandaydayaw kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Utdi, kaysan da. Inggaw da man sit daḻan, naila da umanon dit bituwona nilumtaw kan dida’t dit ot amod dit taḻok da. Impuyut dit bituwon dida inggana’t nan-illong sit batug dit boḻoya ininggawan dit abeng. ");
INSERT INTO kmk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dumatong da man sit kawadan didi un boḻoy, nilumnok da ot inila da dit abeng kan si Maria un ina na. Nampalintumong da un nandayaw sit abeng ot inokaḻ da dadit nangkangingina’n awit da un iligalu da kan siya un buḻawan, insensu kan mira. ");
INSERT INTO kmk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Masuyop da man, binagaan Apudyus dida si in-inop ta adida ayonon si Herodes. Utdi, nangulin da utdit boboḻoy da un nangoy da si sabali un daḻan. ");
INSERT INTO kmk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Utdit kaysananon dadiya kakkaili, nampaila ud anghel Apudyus umanon si in-inop kan Jose un kanana’n, “Gumangun ka! Ibtik nu danat man-ina ud Egipto, ot inggaw kayu’t di inggana’t ibagaka mangulin kayu, ta panggop Herodes un painap nat abenga papatoy.” ");
INSERT INTO kmk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gummangun si Jose ot inlakkat na dat man-ina’n kaysan Egipto si labi. ");
INSERT INTO kmk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ot iniinggaw da utdi inggana’t natoy si Herodes. Nakwa tu daḻapnu matungpal dit paimbagan Apudyus sidit propetana’t dit un, “Inayagak dit abeng ku un manligwat Egipto.” ");
INSERT INTO kmk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Utdit matigammuwan Herodes un sinikapan dadit nalalainga tagu, amoamod dit suḻag na. Ot imbilin na un mapatoy dat losana laḻaki’n abeng sidin Betlehem kan losanon sidat nangkalliput na, manipud mantawon si duwa un mampadoba, maibasal sit timpu’n imbagan dadit nalalainga tagu un nangil-an da utdit bituwon. ");
INSERT INTO kmk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Utdi, natungpal dit ingkanglit propeta Jeremias sidit un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Magngoḻ dit damit da utdin Rama ta amod dit man-iibil kan manlaḻamat da. Ib-ibbilan Raquel dat abeng na ta naamin da un napatoy ot adina’n taḻon maliwliwa.” ");
INSERT INTO kmk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Utdit natoyon si Ali Herodes, nampaila uman ud anghel Apudyus kan Jose udsi in-inop na ud Egipto. ");
INSERT INTO kmk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kanan dit anghel un, “Gumangun ka ta iyulin nu danat man-ina ud Israel, ta natoyon dit mamiya’n mamatoy sinat abeng.” ");
INSERT INTO kmk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gummangun si Jose ot inlakkat na dat man-ina un kaysan Israel. ");
INSERT INTO kmk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yoong utdit magngoḻan Jose un naisukat si Arkelao kan ama na un Herodes un Ali’d Judea, ummogyata umoy inggaw sidi. Ot gaputa nabagaan payyan si in-inop na, kaysan da utdin probinsiya’d Galilea. ");
INSERT INTO kmk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ot ummoy da utdin boboḻoy Nazaret. Utdi, natungpal dit imbagan Apudyus sidat propeta un kanana’n, “Ngadnon dat tagu’n iNazaret.” ");
INSERT INTO kmk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Utdiya timpu’n inggawan da Jesus Nazaret, dummatong si Juan un Mambubunyag si igaw ud Judea un maid tagtagguwan na ot nantudtudu un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mandadaoli kayu ot igongda yu dat basuḻ yu ta dandaniyon dit timpu’n mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan dit ug-ugudon dit ingkanglit propeta Isaias un, “Awad tagu’t dit igawa maid tagtagguwan na un mampappakuya kanana’n, ‘Isagana yu dit daḻan dit Apu. Manggodngon yu dit daḻan un ayona.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sat badut Juan, naganay si dutdut di kamelyu kan nambakakat si geddang ot dudun kan dilu dit ikatagu na. ");
INSERT INTO kmk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aduadu dat tagu’n ummoy nandongoḻ kan siya un nanligwat Jerusalem, sin losana nilakub Judea kan losana nandodomanga boboḻoy sin wangwang Jordan. ");
INSERT INTO kmk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Impudnu da dat basuḻ da asin Juan binunyagan dida utdin wangwang Jordan. ");
INSERT INTO kmk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoong mailan man Juan un adu’n Fariseo kan Saduceo un umoy kan siya mampabunyag, kanana kan dida un, “Dikayu’n ganak di uḻog! Singngadan nat nangibaga kan dikayu un mampabunyag kayu daḻap maligligan yu dit dumatonga mandusaan Apudyus? ");
INSERT INTO kmk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Masapula ipaila yu utdan angwat yu un tuttuwa’n mandadaoliyan yu dat basuḻ yu. ");
INSERT INTO kmk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Adiyu kanana mailisi kayu utnat kanan yu un, ‘Ulay ta kaganakan dikami kan Abraham.’ Ta tuttuwa tun ibagak kan dikayu un mabalin Apudyus mangwa’t kaganakan Abraham sidatu un batu. ");
INSERT INTO kmk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ot sat manusaan Apudyus kan dikayu maiyalig si wasay un maibibiyada maipokpok sit pong-ad dit kayu. Ot losana kayu’n adi mamunga’t napiya mapokpok asi maidawat sin apuy. ");
INSERT INTO kmk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bunyagok dikayu si danum un siya’d mangipaila’n nandadaoliyan yu dat basuḻ yu. Yoong sat maitagtagnob kan sakon, bunyagon dikayu si Ispiritu Santu kan apuy. Taḻona nangatu nu sakon ot adiyak pay maibilanga mamegkeng sit sandalyas na. ");
INSERT INTO kmk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Maiyalig si tagu’n nakaaggom si igau un mantopa’t ilik. Aminona’n topaan asina iyaḻang dat nabgas ot aminona’n idawat dat nakupaw sit apuya adi makmaksop.” ");
INSERT INTO kmk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Utdit mambunbunyagan Juan sin wangwang Jordan, dummatong pay si Jesus un nanligwat Galilea daḻapnu mampabunyag kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yoong piyaon Juan un lappodan ot kanana’n, “Apay umoy ka mampabunyag kan sakona lobbong na un sakon okyanot nat bunyagom?” ");
INSERT INTO kmk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yoong summungbat si Jesus un, “Kooma lawa uttun satun ta lobbong na un tungpaḻon ta dat losana ipakwan Apudyus.” Ot ummampayun pay si Juan. ");
INSERT INTO kmk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Magangput mana mabunyagan si Jesus, dagusa tummakdang. Utdi, nambukat din langit ot innila na si Ispiritu Santu un dummoba un kama’t kalupati’n inumpa kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Utdiyon inggaw ginga’n nanligwat langit un kanana’n, “Siyatu’d pipiyaoka Anak ku un taḻona masmas-omak.” ");
INSERT INTO kmk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Utdiyon impuyut Ispiritu Santu si Jesus sit igawa maid tagtagguwan daḻapnu sugsugan Satanas. ");
INSERT INTO kmk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lumob-as man opata puḻu’n aḻgaw kan labi un adina’n taḻon nangan, nabitilon. ");
INSERT INTO kmk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Utdi, inummoy si Satanas kan Jesus ot kanana’n, “Nu sika’d abeng Apudyus, bilinom tu un batu ta mambalin si tinapay.” ");
INSERT INTO kmk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yoong summungbat si Jesus un, “Kanan dit ugud Apudyus un, ‘Bokona lawa’n makan ud ikatagun di tagu nu adi masapul na pay dat losana ibagan Apudyus.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Utdiyon, impuyut uman Satanas si Jesus sin nasantuwana siyudad Jerusalem ot indallay na utdit tuktuk didit timplu. ");
INSERT INTO kmk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ot kanana kan siya un, “Nu abeng dika kan Apudyus lumayug ka, ta kanana’t din ugud Apudyus un, ‘Bilinon Apudyus dat aanghel na un mangayyuwan kan sika kan tapayaon dika daḻapnu adina maisugpi danat ikim sidan batu.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yoong summungbat si Jesus un, “Kanana payyan sin ugud Apudyus un, ‘Adim padpadason si Apudyus un Apum.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Utdi, indallay Satanas si Jesus sidit nangatungatu’n bateled ot impaila na dat losana il-ili uttun lubung kan kinabaknang da. ");
INSERT INTO kmk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ot kanana un, “Itdok kan sika un losan datu nu mampalintumong ka un mandayaw kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yoong summungbat si Jesus un, “Manaḻan ka Satanas! Ta kanana pay sin ugud Apudyus un, ‘Dayawom si Apudyus un Apum ot siya ullawa’d manselbiyam.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Utdi, kaysan si Satanas ot dummatong dat aanghel un ummoy nanuḻung kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Utdit madamag Jesus un naibaḻud si Juan un Mambubunyag, nan-ulin sin probinsiya’d Galilea. ");
INSERT INTO kmk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yoong adina ininggaw sin boboḻoy da ud Nazaret, nu adi ummoy ininggaw Capernaum un osa’n boboḻoy sin igid din baybay Galilea un sakup dit pitan dadit Zabulon kan Neftali. ");
INSERT INTO kmk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nakwa tu daḻapnu matungpal dit paingkanglit Apudyus kan propeta Isaias un, ");
INSERT INTO kmk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sat pitan da Zabulon kan Neftali awad sin kapon baybay sidin domang din wangwang Jordan, inggana’t din sakup Galilea un igaw dat bokona Judio. ");
INSERT INTO kmk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Sadat tagu un inggaw sit nakoḻop, naila da dit nakaskasdaawa silaw. Sadat inggaw sit nakoḻopa igaw ud katoy, sinilawan dit silaw dida.” ");
INSERT INTO kmk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Manipud sit timpu’n dummakngana’d Galilea, inlugin Jesus nantudtudu un kanana’n, “Mandadaoli kayu ot igongda yu dat basuḻ yu ta dandaniyon dit timpu’n mangiyapuwan Apudyus!” ");
INSERT INTO kmk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mankikkikkiyang man si Jesus sin igid bananaw sidin Galilea, naila na dat mansunuda Simon un mangadan Pedro kan Andres un madama’n manabtabukuḻ. ");
INSERT INTO kmk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kanana kan dida un, “Maitung-ud kayu kan sakon ta mambalinok dikayu un mantatabukuḻ si tagu.” ");
INSERT INTO kmk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dagusa tinengyan da dit tabukuḻ da ot naitung-ud da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Intultuluy da un dit kummiyang ot naila na payyan dat mansunuda Santiago kan Juan kan sat ama da un si Zebedeo utdit bangka un man-amitong sidit tabukuḻ da. Inayagana dat mansunud ot ");
INSERT INTO kmk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tinengyan da un dagus dit bangka kan si ama da ot naitung-ud da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Dinakdak Jesus din probinsiya’d Galilea un ummoy nantudtudu’t dat sinagoga da utdit Nabaḻu’n Damag maipanggop sit mangiyapuwan Apudyus. Pinapiya na pay dat tagu’t dat nadumaduma’n sakit da. ");
INSERT INTO kmk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Utdiyon, nandinadinamag dit maipanggop kan siya utdin losana boboḻoy sin sakupon Siria. Indatong da kan siya dat losana masakit kan dat awad si paspasibgon, sadat nadimunyuwan, nakoḻdas kan sadat adi makagidu. Ot pinapiyan Jesus dida’n losan. ");
INSERT INTO kmk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Utdiyon, aduadu dat tagu’n naitung-ud kan siya un nanligwat Galilea, Decapolis, Jerusalem, Judea kan sadan boboḻoy sin kapon domang didin wangwang Jordan. ");
INSERT INTO kmk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ilan man Jesus dat adu-adu’n tagu un naitungtung-ud kan siya, nanagada’t dit bateled. Nantupak ot ummadani dat disipulus na kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ot inlugi na un nanudtudu kan dida un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nagasat dan tagu’n mamigbig un naid mabalin da nu maipanggop sidan naispirituwana banag, ta mangkuwa da din mangiyapuwan Apudyus! ");
INSERT INTO kmk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nagasat dan tagu’n mandomdom ta liwliwaon Apudyus dida! ");
INSERT INTO kmk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nagasat dan tagu’n napakumbaba ta maitod kan dida tun pita! ");
INSERT INTO kmk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nagasat dan tagu’n taḻona gutagutan da un tungpaḻon dat piyaon Apudyus ipakwa ta ponkona dida! ");
INSERT INTO kmk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nagasat dan nakaasi ta kaasiyan Apudyus dida! ");
INSERT INTO kmk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nagasat dan nadaḻus si somsomok ta maila da si Apudyus! ");
INSERT INTO kmk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nagasat dan tagu’n mangwa’t mangkikinnappiyaan di tagu, ta ngadanon Apudyus dida un abeng na! ");
INSERT INTO kmk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nagasat dan maidapdapes gapu’t dit mangwaan da utdadit ipakwan Apudyus, ta mangkuwa da din mangiyapuwan Apudyus! ");
INSERT INTO kmk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nagasat kayu nu babbainan dikayu, idapdapes dikayu kan palpalawengon dikayu gapu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Taḻona manlagsak kayu ta amoamod dit gun-guna yu utdin langit. Siya pay kingwan dat tagu’n nampaligat sidat propetan Apudyus sidit un nauna nu dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Intultuluy Jesus un nantudtudu’n kanana’n, “Dikayu’d kama’t asin dan losana tagu. Yoong nu mangkubay nat asin, adinaon mabalina maiyulin dit apgad na. Naid selbi naon nu adi maidawat kad dabdabbokon di tagu’l lawa. ");
INSERT INTO kmk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Dikayu’d kama’t silaw dat tagu’t tun lubung. Somsomkon yu un adina mailingod nat ili un nabangun sinat tuktuk di bateled. ");
INSERT INTO kmk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Padana pay un maid manongog si pingki asina tangngoban, nu adi igga na utdit kustu un iiggaan daḻapnu masilawan dat losana inggaw sit boḻoy. ");
INSERT INTO kmk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Padana pay kan dikayu, masapula napataka maila nat silaw yu daḻapnu ilan dat tagu dan nabaḻu’n angwat yu kad, dayawon da si Ama yu ud langit.” ");
INSERT INTO kmk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Intuluy Jesus un kanana’n, “Adiyu kanana dummatongaka umoy manwaswas sit lintog Moses kan dat ingkanglit dat propetan Apudyus, nu adi umoyak tungpaḻon dat losana imbaga da. ");
INSERT INTO kmk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tuttuwa tun ibagak kan dikayu un, mangkigad tun langit kan pita yoong sadat lintog Apudyus adina mabalina makaanan, ulay sintoyoka lawa inggana’t matungpal un losan. ");
INSERT INTO kmk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Isunga sat tagu’n adi tumuttuwa ulay nu san kanan da un kaḻangpawana bilin Apudyus kan tudtuduwana dan udum daḻapnu adida pay tuttuwaon, siya’d kadobaan sin mangiyapuwan Apudyus. Yoong sat tagu’n tumuttuwa’t dan bilin Apudyus kan itudtudu na utdan udum daḻapnu tuttuwaon da pay, siya’d nangatu’t din mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta ibagak kan dikayu un, adi kayu mabalina maidagamung sin mangiyapuwan Apudyus malaksig nu nalinlintog kayu nu sadan mimistulun di lintog kan sadan Fariseo.” ");
INSERT INTO kmk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Dingngoḻ yu un inabus dit naibilin sidat tagu’t dit aw-awe un kanana’n, ‘Adi kayu kumatoy ta sanat kumatoy maidaḻum.’ ");
INSERT INTO kmk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yoong satu tun ibagak kan dikayu, singngadan na mana sumuḻag si buḻun na, maidaḻum; singngadan na man un mamabbain sit buḻun na un kanana’n, ‘Naid selselbim,’ maidaḻum sit Sanhedrin ot singngadan na mana mangibaga un, ‘Tung-ug ka,’ dusaon Apudyus sin impiyelnu. ");
INSERT INTO kmk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Siya’d gapuna un ulay nu awad kaon sin altar un umoy mandatun kan Apudyus nu magasmok nu un awad kingwam si linaweng dit buḻun nu, ");
INSERT INTO kmk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tengyam yan dit datun nu ta umoy ka yan mampakawan ta mangkapiya kayu asim umoy idatun dit datun nu kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ot nu awad mangidaḻum kan sika, makaaliglu ka un dagus sit daan yu payyan dumakngan sit uukkuman. Ta nu adim koon di, ipaima dika’t din kuis ot san kuis paibaḻud dika’t dan pulis. ");
INSERT INTO kmk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ot ibagak un nu ibaḻud dika, adi kaon makaḻaksun inggana’t mabayadam dit multam.” ");
INSERT INTO kmk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Dingngoḻ yu un inabus dit naibilin un, ‘Adi kayu makadagdagas.’ ");
INSERT INTO kmk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yoong sinsatunon ibagak kan dikayu’n, ulay singngadan na un mangitukkoḻ si babai ot dagusa maboknan dit gikna na un piyaona’n aḻan, nakabasuḻon sit somsomok na si dagdagas. ");
INSERT INTO kmk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Siya’d gapuna un, nu sat diwanana ata yu ud maigapuwan di makabasuḻan yu, tuwilon yu ot idawat yu ta unnaya lawa’n awad kulang nat long-ag yu nu san mabubukkoḻ kayu un maidawat sin impiyelnu. ");
INSERT INTO kmk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ot nu san diwanana ima yu ud maigapuwan di makabasuḻan yu, putdon yu ot idawat yu ta unnaya lawa’n ossaan nat takḻay yu nu san mabubukkoḻ nat long-ag yu un maidawat sin impiyelnu.” ");
INSERT INTO kmk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naibilin pay sidit un: ‘Nu awad laḻaki’n mangidang si asawa na, masapula itdana dit asawa na si kasulatan dit man-idangan da.’ ");
INSERT INTO kmk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yoong sinsatun ibagak kan dikayu un, sanat laḻaki’n umidang si asawa na un adi nakabasuḻ si dagdagas, makabasuḻ nu awad mangasawa’t dit asawa na ta pinambalin na un nakadagdagas. Ot sat laḻaki’n mangasawa’t dit naidangana babai, makabasuḻ payon si dagdagas.” ");
INSERT INTO kmk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Dingngoḻ yu pay dit naibilin sidat ginnapuwan taku un, ‘Masapula adiyu man-awidan dit insapata yu, nu adi masapula tungpaḻon yu dit isapata yu.’ ");
INSERT INTO kmk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yoong sinsatunon, ibagak kan dikayu un adi kayu’n taḻon mansapsapata. Adiyu isapata’d langit ta siya’d man-apuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Padana paya adiyu isapata tun pita ta siya’d naipatayan dan ikina, kan padana pay Jerusalem ta siya’d ilin dit kangattuwana Ali. ");
INSERT INTO kmk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Adiyu pay isapata nat uḻu yu ta adi kayu makapabalin si osa’t napoḻkas onnu nangisita buuk. ");
INSERT INTO kmk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kanan yu ullawa un, ‘On,’ onnu ‘Adi,’ un adiyu dogaan si sapata, ta sat sapata un idoga yu, manligwat kan Satanas.” ");
INSERT INTO kmk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Dingngoḻ yu pay dit naibilin sidit un kanana’n, ‘Sat mamuḻsok si padana un tagu, buḻsokon da pay kan sat mangengaw si padana un tagu gengawan da pay.’ ");
INSERT INTO kmk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yoong sinsatunon ibagak kan dikayu un adi kayu gumaḻos sidan mangwa’t laweng kan dikayu. Nu awad manipak sinat madiwanana pasngit yu, isagad yu payyanot nat biik. ");
INSERT INTO kmk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ot nu awad mangidaḻum kan dikayu ta aḻana nat badut yu, itdon yu payyanot nat kagoy yu. ");
INSERT INTO kmk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ot nu awad mangipapilit kan dikayu’n mangipaawit sinat awit na si singkilometro awiton yuwot si duwa’n kilometro. ");
INSERT INTO kmk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Itdan yu dat mangkodaw kan dikayu, pagawatan yu dat manggawat kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Dingngoḻ yu pay dit naibilin sidit un, ‘Piyaom dat gayyom nu yoong lawengom dat mangidapdapes kan sika.’ ");
INSERT INTO kmk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yoong sinsatunon ibagak kan dikayu’n, masapula piyaon yu dan kabusuḻ yu kan iluwaḻuwan yu dan mangidapdapes kan dikayu ");
INSERT INTO kmk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","daḻapnu mailasin un tuttuwa’n anak dikayu kan Ama yu ud langit. Ta padana’n ipalubus na din inita manilaw sidat nadadag kan nabaḻu’n tagu. Padana’n mangitod si udan sidat mangwa’t nabaḻu kan sidat mangwa’t laweng. ");
INSERT INTO kmk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ot nu sad piyaon yu ullawa dan mamiya kan dikayu, gun-gunaan dikayu kad kan Apudyus? Bokon kada siya pay kokkoon dan man-uuḻup si bugis? ");
INSERT INTO kmk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ot nu sad kabagbaga yu ullawa dan buḻun yu, singngadan nat naidum-an yu utdan uduma tagu? Bokon kada siya pay kokkoon dan bokona makatigammu kan Apudyus? ");
INSERT INTO kmk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Isunga masapula padaon yu si Ama yu ud langit un maid mangkulangana.” ");
INSERT INTO kmk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kanan Jesus un, “Ilan yu ta adiyu gagaḻaona ipappaila din mangwaan yu si nabaḻu, ta nu siya’d koon yu naid gun-guna yu kan Ama yu ud langit. ");
INSERT INTO kmk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Isunga nu awad ituḻung yu utdan nakapus, adiyu umoy ipalapalawag un kama’t din koon dan man-ag-agina tagu nu inggaw da utdin sinagoga kan kaḻkaḻsa daḻapnu idayaw dat tagu dida. Tuttuwa tun ibagak kan dikayu un, inawat daon dit gun-guna da utdiya mangidayawan dat tagu kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yoong nu awad ituḻung yu utdan kapus, adiyu un taḻon ipatpatigammu’t dan udum ulay nu san taḻona kagayyoman yu. ");
INSERT INTO kmk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ot si Apudyus un Ama yu un mangiila’t dan koon yu si nalingod, gun-gunaan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nu manluwaḻu kayu, adiyu padaon dan man-ag-agin. Pipiyaon da un sumikada manluwaḻu’t dan sinagoga kan sidan nan-ab-abtan di kaḻsa daḻapnu ilan dat tagu dida. Tuttuwa tun ibagak kan dikayu un, inawat daon dit gun-guna da utdiya mangidayawan dat tagu kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nu manluwaḻu kayu, mangkuḻung kayu’t din kuwaltu asi kayu manluwaḻu kan Apudyus un adi maila. Ot si Apudyus un Ama yu un mangiila’t dan koon yu si nalingod, gun-gunaan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nu manluwaḻu kayu, adiyu anduwon nat naid si bogasa luwaḻu’n siya’d koko-on dan adi makatigammu kan Apudyus. Ta kanan da nin nu dongḻon Apudyus dit luwaḻu da gaputa andu. ");
INSERT INTO kmk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adiyu padaon dida ta tigammunon Apudyus un Ama yu dan masapul yu utdin daan yu payyan mangkodawan. ");
INSERT INTO kmk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kama’t tu nat manluluwaḻu yu: ‘Ama mi un awad langit, iluwaḻu mi un madaydayaw nat ngadan nu. ");
INSERT INTO kmk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Iluwaḻu mi un dumatongon nat man-apuwam situn pita kan matungpal nat piyaom situn pita un padana’d langit. ");
INSERT INTO kmk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Itdom dan kanon mi un inaḻgaw. ");
INSERT INTO kmk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pakawanom dan basuḻ mi un padan dit mamakawanan mi utdan makabasuḻ kan dikami. ");
INSERT INTO kmk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Adim ipalubusa masugsugan kami, nu adi iyadayu dikami utdin nadadag.’ ");
INSERT INTO kmk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nu pakawanon yu dat makabasuḻ kan dikayu, pakawanon dikayu pay kan Ama yu ud langit. ");
INSERT INTO kmk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yoong nu adiyu pakawanon dida, padana paya adi dikayu pakawanon kan Ama yu ud langit sidat basbasuḻ yu.” ");
INSERT INTO kmk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nu manlangan kayu’n mangan sin manluwaḻuwan yu, adi kayu manduduuya padan dan man-ag-agin. Ta manduduuyon da din ila da daḻapnu mailan kad dat tagu un nanlangan da un mangana manluwaḻu, idayaw da dida. Tuttuwa tun ibagak kan dikayu un, inawat daon dit gun-guna da utdiya mangidayawan dat tagu kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Siya’d gapuna’n nu manlangan kayu’n mangan, mandaḻ-up kan manlaggud kayu, ");
INSERT INTO kmk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","daḻapnu maid makatigammu nu adi abusa lawa si Ama yu un adi maila. Ot si Ama yu un mangiila’t din koon yu si nalingod, gun-gunaan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bokona uttun pita’d mantaḻponan yu utdan talipon yu, ta kaynga’l lawa’n aminon di angngat ya lati kan awad pay lumnoka mangakaw. ");
INSERT INTO kmk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Itaḻpon yuwot sin langit ta maida taḻon angngat onnu lati’t di si mangamin kan maid makaḻnok si mangakaw. ");
INSERT INTO kmk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta sat kawadan dit talipon yu, siya pay ud taḻona sosomkon yu.” ");
INSERT INTO kmk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Satun ata siya’d pannakasilaw ditun long-ag. Isunga nu napadda tun ata, napadda tun losana long-ag. ");
INSERT INTO kmk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yoong nu nadaḻam nat atam, nakoḻop pay nat losana long-ag nu. Ot nu pangot dit awad kan sika imbisa silaw, taḻona napangot nat mataguwam!” ");
INSERT INTO kmk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maid baba-unon si mandisanona’n manselbiyan dan duwa’n apu. Ta lawengona dit osa ot piyaona dit osa, onnu ipasnok na un manselbi’t dit osa ot duḻaona dit osa. Ot padana pay kan dikayu un adiyu mabalina mandisanon din manselbi kan Apudyus kan gumamgama gumaknang.” ");
INSERT INTO kmk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Isunga ibagak kan dikayu un bokona sadan makan, mainum kan badut dan mandanagan yu. Bokon kada napotpotog nat mataguwan yu nu san makan kan napotpotog nat long-ag yu nu san badut? ");
INSERT INTO kmk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilan yu dan sissiwit, adida mammuḻa onnu man-ani, adida man-iyaḻang yoong itdan Ama yu ud langit dida’t kanon da. Bokon kada napotpotog kayu nu sadan sissiwit? ");
INSERT INTO kmk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Singngadan na kan dikayu ud makaisuḻut si sinsikuwan sit mataguwana udsi mandandanagana? ");
INSERT INTO kmk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Apay ikadanag yu ud mambadut yu? Somsomkon yu din mandadakoḻ dan simalona sabsabung. Adida mangkokwa onnu mangganay. ");
INSERT INTO kmk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yoong ibagak kan dikayu un amo napippiya din ila da nu sadat nangkababanola badut Ali Solomon. ");
INSERT INTO kmk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ot nu kama’t di un papiyaon Apudyus dan simalona sabung un matagu’t tun aḻgaw yoong mabigat kad masgob da, bokon kada amo sosomkona nat mambadut yu? Nakapsuta taḻon nat pammati yu! ");
INSERT INTO kmk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Adi kayu mandandanaga kanan yu un, ‘Mangaḻ-an mi kad nin si kanon mi, inumon mi kan da badut mi?’ ");
INSERT INTO kmk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Siya datu dan taḻona sosomkon dan adi makatigammu kan Apudyus. Tigammun Ama yu ud langit un kasapulan yu datu. ");
INSERT INTO kmk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iyun-una yuwota somsomkon nat mangiyapuwan Apudyus kan dikayu kan san mantungpaḻan yu utdan piyaona ot itdona pay dan losana kasapulan yu. ");
INSERT INTO kmk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adiyu ikadanag dan masapul yu nu bigat ta paḻungay pay lawan nu timpu na. Loog naon datu’n palikut situn satuna aḻ-aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Adiyu ukumon dan uduma tagu daḻapnu adin pay Apudyus dikayu ukumon. ");
INSERT INTO kmk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta nu kamaan nat man-uukum yu utdan udum, siya pay man-uukum Apudyus kan dikayu. Nu kamaan nat man-iila yu utdan udum, siya pay dit man-iilan Apudyus kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Apay un sad ilam nat bangbang-ita buḻaw ud buḻun nu un bokona sat kama’t batanga buḻaw nu? ");
INSERT INTO kmk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Inona’n kanam sit buḻun nu un, ‘Kaanok nat buḻaw nu,’ nu adim yan kaanon nat kama’t batanga buḻaw nu? ");
INSERT INTO kmk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Man-ag-agin ka! Kaanom yana umuna nat kama’t batanga buḻaw nu daḻapnu kumadda nat man-iilam un mangaan sit buḻaw buḻun nu. ");
INSERT INTO kmk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Adiyu itdon sidan asu dan singngadan na mana nasantuwan ta dukusan kan kotban dikayu. Adiyu pay igga dan perlas sin sinagung di boḻok ta dabdabbokon da ullawa.” ");
INSERT INTO kmk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nu awad masapul yu adi kayu lumipsuta mangkodaw kan Apudyus ot itdana dikayu. Adi kayu lumipsuta man-inap ot tuḻungan dikayu kan siya’n mangdas. Adi kayu lumipsuta mangkogkog sit sawang na ot ibukatan dikayu kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta losana mangkodaw kan Apudyus maitdan, losana man-inap makaodas kan losana mangkogkog sidit sawang na maibukatan. ");
INSERT INTO kmk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Singngadan na kan dikayu’n ama ud mangitod si batu utdit anak na nu mangkodaw si tinapay? ");
INSERT INTO kmk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onnu itdana’t uḻog nu mangkodaw si ikan? Maid. ");
INSERT INTO kmk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ot nu dikayu un nadadag tigammu yu un mangitod si napiya utdan anak yu, amodot kan Ama yu ud langita mangtod sidan napiya utdan mangkodaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Koon yu utdan pada yu un tagu din piyaon yu un koon da pay kan dikayu, ta siya’d kustu un kaipooyan dit lintoga ingkanglit Moses kan sadat insuḻun dat propeta.” ");
INSERT INTO kmk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mangoy kayu’t din nasupita sooban, ta sat nanawaga sooban kan naḻasu un daḻan manaḻan sin mannanayuna mapaligatan ot adu dan mangoy. ");
INSERT INTO kmk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yoong nasupit din sooban kan nasigab din daḻana manaḻan sin mataguwan si inggaingga isunga akit dan tagu’n makaodas.” ");
INSERT INTO kmk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Alimbanan yu dat man-ag-agin propeta. Ta umoy da kan dikayu un naamma dit ila da un kama dat kannelu, yoong sat katuttuwaana kama da utdan naenget un tanana asu. ");
INSERT INTO kmk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Maimatunan yu dida utdan angwat da. Padan di kayu un maimatunan ta utdit bunga na. Naid iwoy si mamunga’t ubas onnu pingita mamunga’t igus. ");
INSERT INTO kmk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sat napiya un kayu, napiya dit bunga na yoong sat lawenga kayu, laweng pay dit bunga na. ");
INSERT INTO kmk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Adina mabalina sanat napiya’n kayu laweng nat bunga na onnu sanat lawenga kayu napiya nat bunga na. ");
INSERT INTO kmk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Losana kayu un adi mamunga’t napiya, maipokpok asi maidawat sin apuy. ");
INSERT INTO kmk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Isunga maimatunan yu dat man-ag-agin propeta utdit angwat da.” ");
INSERT INTO kmk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bokona losana mangibaga kan sakon si, ‘Apu, Apu’ makaḻnok sin langita mangiyapuwan Apudyus, nu adi abusa lawa dan mangwa’t dan piyaon Ama’d langita ipakwa. ");
INSERT INTO kmk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nu dumtong dit aḻ-aḻgawa mangukuman Apudyus sidat tagu, adu’n mangibaga kan sakon un kanan da un, ‘Apu, Apu, imbaga mi dat paimbagam kan dikami. Inusal mi pay nat ngadan nu un nangaddag sidat dimunyu kan nangkokwa kami pay si adu’n nakaskasdaawa makwa.’ ");
INSERT INTO kmk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yoong ibagak kan dida’n, ‘Naid tigtigammuk kan dikayu. Umadayu kayu, dikayu’n losana kumokokwa’t nadadag.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Isunga sat tagu’n mangngoḻ kan manungpal sidatu’n ibagbagak, maipada’t dit nasiliba tagu’n namoḻoy sit lap-at di batu. ");
INSERT INTO kmk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Umudan man si nabilog, nanlayus kan dinupak pay dit nabiloga bayogbog dit boḻoy, yoong adina natukas ta natutuud sit lap-at dit batu. ");
INSERT INTO kmk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yoong sat tagu’n mangngoḻ sidatu’n ibagbagak yoong adina tungpaḻon, maipada’t dit tung-uga tagu’n namoḻoy sit kalaglaganan. ");
INSERT INTO kmk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Umudan man si nabilog, nanlayus kan dinupak pay dit nabiloga bayogbog dit boḻoy ot natukas kan nagnagsay!” ");
INSERT INTO kmk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Gangputon man Jesus ibaga dadi, nasdaaw dat adu’n tagu utdit nantutudtudu na, ");
INSERT INTO kmk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ta bokona kama’t dit mantutudtudun dat mimistulun di lintog. Ta maila’n awad tulay na. ");
INSERT INTO kmk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Gumusad man si Jesus sidit bateled, adu’n tagu’n naitung-ud kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ot inggaw nakutoḻ un ummoy nampalintumong sit atubang na un kanana’n, “Apu, tigammuka kabooḻama papiyaon sakon nu piyaom.” ");
INSERT INTO kmk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Inagpadan Jesus un kanana’n, “On, piyaok. Kumiya ka!” Ot dagusa nakaan dit kutoḻ na. ");
INSERT INTO kmk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Utdi, binilin Jesus un kanana’n, “Ilam ta adim ibagbaga’t udum, nu adi mandadawwos ka kan padi ta umoy ka ipaila un kummiya kaon, asika umoy mandatun kan Apudyus un kama’t dit imbilin Moses sidit si manigammuwan di losana tagu un kummiya ka.” ");
INSERT INTO kmk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dumatong man si Jesus ud Capernaum, ummabat dit bokona Judio un kapitan di suldadu un nampakpakaasi’n, ");
INSERT INTO kmk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apu, awad dit baba-unoka masakit sin boḻoy. Taḻona kawas ot adina makagidu.” ");
INSERT INTO kmk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“On, umoy ku papiyaon,” kanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yoong summungbat dit kapitan un kanana’n, “Apu, adika ullawaon umoy sin boḻoy ta bokona nadayawaka tagu’n umoy ka dakngon. Ibagama lawa’n kumiya din baba-unok ot kumiya. ");
INSERT INTO kmk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ta taguwak paya awad mangiyapu kan sakon un nangatngatu’n opisyal kan awad da pay suldaduka iyapuwak. Nu ibagak sit osa un, ‘Ikan,’ manaḻan kan nu ibagak sit osa un, ‘Awenu’t tu,’ dumatong. Ot nu ibagak sit baba-unoka, ‘Koom tu,’ koona.” ");
INSERT INTO kmk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nasdaaw si Jesus sit dongḻona di ot kinnanana’t dat tagu’n maitungtung-ud kan siya un, “Tuttuwa tun ibagak kan dikayu un pulus pay nu awad innilak si osa’t iyIsrael un manuttuwa si kama’t tuwa kapitan. ");
INSERT INTO kmk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Somsomkon yu tu un ibagak. Adu’n tu dan bokona Judio un manligwat si nadumaduma’n ili, manipud sin kapon lumtawan init inggana’t din kapon maipsukana un maidagamung sin mangiyapuwan Apudyus sidin langit kan makaubunga mangan kan da Abraham, Isaac kan Jacob un ap-apu taku’n Judio. ");
INSERT INTO kmk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ot adu dan Judio un naituding un maidagamung sin mangiyapuwan Apudyus yoong maidawat da utdin nakoḻopa igaw ot mampaibil kan mampangilot da utdi.” ");
INSERT INTO kmk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Utdi, imbagan Jesus sit kapitan un, “Manaḻan kan, matungpal nat kodkodawom un kama’t dit tuttuwaoma makwa.” Ot dagusa gummilog dit baba-unon didit kapitan. ");
INSERT INTO kmk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ummoy si Jesus sit boḻoy da Pedro ot dintong na dit katugangan Pedro un babai’n uumbog ta mampudpudut. ");
INSERT INTO kmk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inagpadan Jesus dit ima na ot dagusa naid dit pudut na. Gummangun ot ummoy nangisagana’t kinan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Masdom man, nan-idatong dat tagu si adu’n sinakayan di dimunyu. Ot inaddag Jesus dat dimunyu’n losan un binagaana’l lawa dida kan pinabilog na pay dat masakit. ");
INSERT INTO kmk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Siya’d kingwana daḻapnu matungpal dit ingkanglit propeta Isaias un, “Kinaan na un losan dadit dupektun di long-ag taku kan sinagapaḻ na dat sigabon taku.” ");
INSERT INTO kmk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Utdit mailan Jesus dat adu’n tagu’t dit nangkalliput na, imbagana’t dat disipulus na un, “Mandoḻmang taku.” ");
INSERT INTO kmk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Utdi, ummadani kan siya dit osa un mistulun di lintog un kanana’n, “Mistulu, umoyak kan sika si kigada ayam.” ");
INSERT INTO kmk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Summungbat si Jesus un, “Unnay pay dan buwot ta awad lungug si inggawan da kan dan sissiwit ta awad lubu da yoong sakona Inyanak di Tagu, naid boḻoy ku ut man-illongak.” ");
INSERT INTO kmk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inggaw pay osa’t dat disipulus na ud kanana’n, “Apu, oni ta umoy ku yan ilbon si amak.” ");
INSERT INTO kmk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Insungbat Jesus un, “Maitung-ud kaot kan sakon. Bay-ama sadat adi manuttuwa kan sakon ud mangilbon sida’t minatoy da.” ");
INSERT INTO kmk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Manlugan man si Jesus sit bangka naitung-ud pay dat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Inggaw da man sit gawan dit danum, kakḻata lawa un gummali’t nabilog ot maḻukuḻukut dit paḻuunga maisaysay-u utdit bangka ot dandaniyon mapnu’t danum. Yoong si Jesus nasuyop. ");
INSERT INTO kmk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ot ummoy dat disipulus na pinukaw un kanan dan, “Apu taguwon dikami! Ta maḻmos takuwon!” ");
INSERT INTO kmk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Summungbat si Jesus un, “Apay kumimut kayu? Kaakit nat pammati yun!” Utdi, gummangun si Jesus ot ginimauwana dit bayogbog kan paḻuung ot gumminok da. ");
INSERT INTO kmk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nasnasdaaw da un losan dat disipulus na ot kanan dan, “Ngad kadnin dituwa tagu’n ulay danat bayogbog kan paḻuung, tuttuwaon da tun ibaga na?” ");
INSERT INTO kmk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dumangpot man da Jesus sit domang sin lakub din ili’d Gadara, ummabat dat duwa’n laḻaki’n sinakayan di dimunyu’n nanligwat sidit kalobḻobnan. Nangkabibilog da kan gakkimut da, siya’d gapuna’n maid makatuḻoda mangoy sit iiggawan da. ");
INSERT INTO kmk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ilan da man si Jesus kakḻata lawa’n gapappakuyan da un, “Sika un Anak Apudyus apay lingalingom dikami? Umoy ka kad situ ta umoy dikami dusaon sinat bokon payyana timpu na?” ");
INSERT INTO kmk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Inggaw da ud sin-amaḻana boḻok un manubsubuk sit ad-adayu’t akit. ");
INSERT INTO kmk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nampakpakaasi dat dimunyu kan Jesus un kanan dan, “Nu addagon dikami, manaḻnon dikami’t dan boḻok sidi.” ");
INSERT INTO kmk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Ikayu!” kanan Jesus. Ot tinengyan da dat duwa’n tagu ot ummoy da nilumnok sidadit boḻok. Utdiyon, nanggugunod dat sin-amaḻana boḻoka kaysan sit gassud ot naotdag da utdit bananaw ot losan da un naḻmos. ");
INSERT INTO kmk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sadat sin-ayyuwan sidat boḻok, nampatodtoddak da un ummoy nangipadamag sidat tagu’t dit boboḻoy sidit napasamak, taḻon sidit napasamak sidat duwa’n sinakayan dat dimunyu. ");
INSERT INTO kmk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Utdi ummoy dat losana umili inila si Jesus. Ilan da man, nampakpakaasi da un taynan Jesus dit boboḻoy da. ");
INSERT INTO kmk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nanlugan uman da Jesus sit bangka ot nandoḻmang da un nangulin sit ili’n iinggawana. ");
INSERT INTO kmk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Utdiya ininggawana’t di, inggaw da ud tagu’n nangidatong si adi makagidu’n tagu’n uumbog sit katli na. Utdit mailan Jesus un taḻona manuttuwa da kan siya, kanana’t dit adi makagidu un, “Anak, pabilogom nat somsomok nu, ta napakawanon dat basuḻ nu.” ");
INSERT INTO kmk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ininggaw da ud mimistulun di lintoga nadaan sidi ot magngoḻ da man dit imbagan Jesus kankanan da utdit somsomok da un, “Mambagbaga’t maisuganggang kan Apudyus tuwa tagu.” ");
INSERT INTO kmk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yoong tigammun Jesus dit somsomok da ot kinnanana’n, “Apay mansomsomok kayu’t laweng? ");
INSERT INTO kmk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngadan nat naḻasḻasu un maibaga? Sadin ‘Napakawanon nat basuḻ nu,’ onnu san ‘Gumangun ka ta kumiyang ka?’ ");
INSERT INTO kmk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yoong pabilgok tu un adi makagidu daḻapnu manigammuwan yu un sakona Inyanak di Tagu, awad kalintogak situn pita un mamakawan si basuḻ.” Utdi, imbagana’t dit tagu’n adi makagidu un, “Ibagak kan sika, gumangun ka, aḻam nat obog nu ta manaḻan ka.” ");
INSERT INTO kmk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gummangun dit tagu ot kaysan sit boḻoy da. ");
INSERT INTO kmk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mailan man dat tagu, ummogyat da ot nandaydayaw da kan Apudyus ta intod na dit kalintogan un kama’t di si tagu. ");
INSERT INTO kmk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tinengyan Jesus di un igaw ot utdit manaddaddaḻanana, naila na dit osa’n laḻaki un mangngadan kan Mateo un man-uuḻup si bugisa mantutupak sit pisina na. Kinnanan Jesus kan siya un, “Maitung-ud ka kan sakon.” Lummigwat si Mateo ot naitung-ud kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Utdit inummoy da Jesus kan dat disipulus na utdit boḻoy da Mateo nakakan, adu dat man-uuḻup si bugis kan udum paya ibilang dat Judio un gumabasuḻ dat inummoy. Ot nakaubung da kan da Jesus un dit nangan. ");
INSERT INTO kmk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Utdit mailan dat Fariseo, kinnanan da utdadit disipulus Jesus un, “Apay makakan din mistulu yu utdan man-uuḻup si bugis kan gumabasuḻ?” ");
INSERT INTO kmk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yoong magngoḻ man Jesus dit imus da, siya’d summungbata kanana’n, “Sadan awad si sakit ud makasapul si man-aagas bokona sadan naid si sakit. ");
INSERT INTO kmk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anagon yu ud nu sin dit piyaona’n ugudon dit ugud Apudyus un kanana’n, ‘San mangaasiyan yu utdan udum din piyaok, bokona san datun yu.’ Dummatongak daḻapnu ayagak dan gumabasuḻ un masapula mandadaoli utdat basuḻ da bokona sadan mangipagalupa nalintog da.” ");
INSERT INTO kmk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Namingsan, inggaw da ud dummatong un disipulus Juan un Mambunbunyag kan Jesus ot inimus da un, “Apay manlangan kami’n mangan sidadin Fariseo, yoong adida manlangana mangan danat disipulus nu?” ");
INSERT INTO kmk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Summungbat si Jesus un, “Mabalin kad un mandomdom dadin sangaili’t din boda nu inggaw payyan kan dida dit laḻaki’n namboda? Bokon! Yoong nu dumtong dit timpu’n maaḻaon dit laḻaki’n namboda, siyadiyon ud timpu’n manlanganan da un mangan un mangipaila’t dit domdom da.” ");
INSERT INTO kmk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Intuluy Jesus un kanana’n “Maid mangitakup si bagu’n luput sinat dadaana badut ta nu masaksakan, mangkulisonson dit bagu’n luput ot am-amdona’n pissayon dit dadaana badut. ");
INSERT INTO kmk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Padana pay un naid mangibilung si bagu’n basi utnat dadaana geddanga bibillungan un adinaon mannatnat. Ta nu sumubuy, buḻtugona dit bibillungan ot kaynga ullawa’n maibukallay dit basi kan mayam-an pay dit bibillungan. Masapula sat bagu’n basi maibilung si bagu’n geddanga bibillungan daḻapnu maid mayam-an.” ");
INSERT INTO kmk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Madama payyana makabagbagbaga’t Jesus kan dida utdit dummatong dit osa’n pangat di Judio ot nampalintumong sit sinagung Jesus un kanana’n, “Kakatoy din abeng ku un babai, yoong pangngaasim ta umoy nu agpadan kad umungaḻ.” ");
INSERT INTO kmk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Utdi, lummigwat si Jesus ot naibuḻun kan siya pati payon sidat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naitung-ud pay dit babai’n kagwampuḻu’t duwa’n dagunon un makaddaḻadaḻa. Ot nakasuppenget sidadit adu’n tagu un ummoy sit awid Jesus asina sinekgel dit lagayadan dit badut na. ");
INSERT INTO kmk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ta kanana’t dit somsomok na un, “Ulay nu masekgel ku ullawa din badut na, kumiyaak.” ");
INSERT INTO kmk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nan-awing si Jesus ta nagikna na ot ilana man dit babai kinnanana’n, “Anak ku, pabilgom nat somsomok nu. Kummiya nat sakit nu gapu’t nat pammatim kan sakon.” Ot dagusa kummiya dit babai. ");
INSERT INTO kmk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sumaaḻ man da Jesus sit boḻoy didit pangat, innilan Jesus dadit man-uullimong kan sadat mampaalipangdasana tagu. ");
INSERT INTO kmk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Utdi kinnanana un, “Lumaksun kayu’n losan ta bokona natoy nat abeng. Masusuyopa lawa.” Inyaamang da si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yoong utdit nakalaksunon dat tagu, nilumnok si Jesus sit ininggawan dit abeng ot inaggomana dit ima na ot gummangun. ");
INSERT INTO kmk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Utdiyon, nandinadinamag dit maipanggop situ utdat nangkalliputa boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tinengyan Jesus diya igaw ot naitungtung-ud pay dat duwa’n nakuḻap kan siya. Mampappakuy da un kanan dan, “Sika’n kaganakan Ali David, kaasiyan dikami!” ");
INSERT INTO kmk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Utdit dumatong si Jesus sit boḻoya iinggawana, nilumnok ot nilumnok pay dat duwa’n nakuḻap un ummoy ummadani kan siya. Utdi, inimus Jesus kan dida un, “Tuttuwaon yu kad un kabooḻaka papiyaon dikayu?” “On, Apu,” kinnanan da. ");
INSERT INTO kmk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Utdi, inapḻusan Jesus dat ata da un kanana’n, “Kumiya kayu un kama’t nat tuttuwaon yu un makwa.” ");
INSERT INTO kmk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ot dagusa nakaila da. Utdi, binilibilin Jesus dida un kanana’n, “Adiyu’n taḻon ibagbaga’t udum tun kingwak!” ");
INSERT INTO kmk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yoong kaysan da un amodota imbagabaga da dit maipanggop kan Jesus sidat nangkalliputa boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Utdit manaddaḻanan dat nakuḻapa kummiya, inggaw da ud nangidatong kan Jesus si naumoḻ ta sinakayan di dimunyu. ");
INSERT INTO kmk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Maabus mana addagon Jesus dit dimunyu mambagbagaon dit tagu ot nasnasdaaw dat tagu’n nakaila un kanan dan, “Naid payyan innila mi si kama’t tu ud Israel.” ");
INSERT INTO kmk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yoong sadat Fariseo un inggaw sidi, kanan da un, “Sat pangat dat dimunyu ud nangitod kan siya’t pannakabalin na un mangaddag sidan dimunyu.” ");
INSERT INTO kmk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Utdiyon, dinakdak Jesus dat losana kailin-ili un ummoy nanudtudu’t dat sinagoga utdit Nabaḻu’n Damag un maipanggop sin mangiyapuwan Apudyus. Pinapiya na pay dat tagu’t dat nadumaduma’n sakit kan pasigab da. ");
INSERT INTO kmk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Maila na man dat aduadu’n tagu’n maitungtung-ud kan siya, nadaguwan kan dida ta mangkakapsut da utdit ligat da kan naid mabalin da un mampatuḻungan un kama’t kannelu’n maid man-aayyuwan. ");
INSERT INTO kmk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Utdi, kinnanana’t dat disipulus na un, “Adu un maani yoong akit dan man-ani.” ");
INSERT INTO kmk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","“Isunga iluwaḻu yu kan Apudyus un singkuwa’t dan maani ta mangibaun si ad-adu un umoy man-ani.” ");
INSERT INTO kmk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pinandatdatong Jesus dat kagwampuḻu’t duwa un disipulus na ot initdana dida’t kalintogana mangaddag sidan nadadaga ispiritu kan mangagas sidadit mampaspasigab si nadumaduma’n sakit kan pasigab. ");
INSERT INTO kmk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sadatu dat kagwampuḻu’t duwa’n apostoles Jesus. Si Simon un mangngadan si Pedro kan si sunud na un Andres, sada Santiago kan Juan un ganak Zebedeo, ");
INSERT INTO kmk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","sada Felipe, Bartolome, Tomas kan si Mateo un man-uuḻup si bugis, Santiago un anak Alfeo, Tadeo, ");
INSERT INTO kmk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon un mangadan si Patriota, kan si Judas Iscariote un nangituyuk kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Imbaun Jesus dadiya kagwampuḻu’t duwa ot binilibilin na dida un kanana’n, “Adi kayu umoy sidan bokona Judio onnu lumnok si singngadan na mana ili’d Samaria ");
INSERT INTO kmk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nu adi, umoy kayu utdat buḻun taku’n kaganakan Israel un kama’t kannelu’n naiyawa. ");
INSERT INTO kmk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ikayu ot itudtudu yu un dummatongon dit timpu’n mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ot papiyaon yu dat masakit, paungaḻon yu dat natoy, papiyaon yu dat nakutoḻ kan addagon yu dat dimunyu’t dat tagu. Adi kayu mampabayad ta bokona binayadan yu nat pannakabalin yu un intod ku kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Adi kayu mambaḻun si pilak ulay siping. ");
INSERT INTO kmk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Adi kayu mampasiking kan adi kayu mangaḻa’t mansukatan yu si badut kan da kapatus kan ulay suḻkud. Ta san mangkokwa lobbong na un maitdan si kasapulana. ");
INSERT INTO kmk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Singngadan na mana ili’n dakngon yu, inapon yu din lumbonga manangaili kan dikayu ta siya’d inggawan yu inggana’t manaḻnan yu. ");
INSERT INTO kmk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ot nu lumnok kayu’t boḻoy kanan yu un, ‘Itdan dikayu kan Apudyus si kapiya.’ ");
INSERT INTO kmk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ot nu lumbong un maitdan da, maituttuwa’n kapkapiya da. Yoong nu bokona lumbonga maitdan da’t kapiya, maugnut dit imbaga yu. ");
INSERT INTO kmk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Ot nu awad da ud tagu’n adi mamaḻnok kan dikayu onnu adi dumngoḻ sidan itudtudu yu, tengyan yu diya boḻoy onnu ili ot ikagkag yu dat gabu’t dat iki yu. ");
INSERT INTO kmk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Ibagak kan dikayu un nu timpu un mangukuman Apudyus, am-amod dit dusan dat tagu’t diya igaw nu sat dusan dat iSodoma kan iGomora.” ");
INSERT INTO kmk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Dongḻon yu! Kama kayu’t kannelu un ibaun ku utdan tanan un asu. Ot masapula nalaing kan naalistu kayu’n kama’t uḻog yoong kama’t kalupati’n naid loog na un man-uyung. ");
INSERT INTO kmk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Alimbanan yu dat tagu ta dopapon kan idallay dikayu’n tu utdan ukum. Sabisabidan dikayu’n tu utdit daḻom dat sinagoga da. ");
INSERT INTO kmk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gapu’t nat tumuttuwaan yu kan sakon, idaḻum dikayu’t dan gugubinnadul ya aali daḻapnu panoknokan yu dit Nabaḻu’n Damag kan dida kan sidat losana iyapuwan da. ");
INSERT INTO kmk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ot nu idatag dikayu’n maimusan sidan ukum, adi kayu madanagan nu inon dit mansusungbat yu kan nu ngadan nat ibaga yu ta maipatigammu payon kan dikayu utdiya timpu. ");
INSERT INTO kmk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta sadit isungbat yu bokona manligwat sit kanaknakoman yu, nu adi manligwat sit Ispiritun Apudyus un Ama taku. ");
INSERT INTO kmk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sadi un timpu ituyuk dat tagu dat mismu’n sunud da un papatoy. Padana pay un ituyuk dat maḻong-ag un papatoy dat abeng da ot busuḻon pay dat aanak dat maḻong-ag da ot papatoy da dida. ");
INSERT INTO kmk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lawengon dikayu’t dan losana tagu gapu’t nat manuttuwaan yu kan sakon, yoong singngadan na mana adi lumipsuta manuttuwa kan sakon inggana’t anungus na, taguwon Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu paligaton dikayu’t osa’n ili, gumtik kayu’t sabali. Tuttuwa tun ibagak kan dikayu un daan yu payyan magangput nat kewaaḻ yu utdan losana ili’d Israel, dumatongaka Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Somsomkon yu un naid man-adaḻ si nangatngatu nu sat mistulu na, kan naid baba-unon si natultulay nu sadit apu na. ");
INSERT INTO kmk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mapnok okyanon nat osa’n man-adaḻ nu maipada dit kapadasana’t dit mistulu na. Padana pay sit baba-unon nu maipada dit kapadasana’t dit apu na. Ot nu sakona Apu yu, ngadnon da si Beelzebub am-amodot nat ingadan da kan dikayu’n taguk.” ");
INSERT INTO kmk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Adi kayu umogyat sidan tagu’n mamaligat kan dikayu. Ta naid mailimod si adi maikoḻwag onnu naisuḻuk si adi maipaḻtaw nu dumtong din timpu na. ");
INSERT INTO kmk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sadat imbagak kan dikayu si nalimod, ipatigammu yu. Sadat inyagasaas ku kan dikayu, ipalawag yu utdan kataguntagu. ");
INSERT INTO kmk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Adi kayu umogyat sidan kumatoy si long-ag yoong adida mapatoy din kadogwa. Si Apudyus ud iyogyat yu ta siya’d makabalina manusa’t dit long-ag kan kadogwa utdin impiyelnu. ");
INSERT INTO kmk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Somsomkon yu danat tilina magatanga lawa danat duwa si siping, yoong naid osa’t matoy kan dida nu adin Apudyus ipalubus. ");
INSERT INTO kmk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amodot kan dikayu ta tigammu na nat bilang nat buuk yu. ");
INSERT INTO kmk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Siya’d gapuna un adi kayu umogyat ta amo napotog kayu kan Apudyus nu sadan tilin.” ");
INSERT INTO kmk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Singngadan na mana mangipudnu utdan tagu utdit manuttuwaana kan sakon, ipudnuk pay kan Amak ud langit un manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yoong singngadan na mana mangisulib sidan tagu utdit manuttuwaana kan sakon, isulib ku pay kan Amak ud langit.” ");
INSERT INTO kmk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Adiyu kanana inummoyak situn pita un mangidatong si ginok ta sat katuttuwaana dummatongak un mangidatong si ispada ta mambanag tun dummakngak si binnusuḻ. ");
INSERT INTO kmk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sat anaka laḻaki busuḻona si ama na, sat anaka babai busuḻona si ina na, sat manuganga babai busuḻona si katugangana un babai. ");
INSERT INTO kmk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ot mambalina kadadagana kabusuḻ di tagu dat kaboḻoy na. ");
INSERT INTO kmk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Singngadan na mana amo mangipotog kan ama na, ina na onnu anak na nu sakon, adina lumbonga mambalin si disipulus ku. ");
INSERT INTO kmk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ot singngadan na mana adi mamukud sit kulus na asi maitung-ud kan sakon, adina lumbong un mambalina disipulus ku. ");
INSERT INTO kmk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sat tagu’n gumamgam sit mataguwana’t tun pita matoy payon, yoong sat tagu’n matoy gapu’t nat umunudana kan sakon, maitdan si mataguwana maid kigad na.” ");
INSERT INTO kmk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Singngadan na mana mangawat kan dikayu, sakon inawat na ot sat mangawat kan sakon, inawat na payon dit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ot sat mamaḻnok sidat propetan Apudyus gaputa propetan Apudyus dida, magun-gunaan pay sit padan dit gun-gunan di propeta. Sat mamaḻnok sit nalintoga tagu gaputa nalintog, magun-gunaan pay sit gun-gunan di nalintoga tagu. ");
INSERT INTO kmk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tuttuwa tun ibagak un sanat mangitod si sintasa ullawa’n danuma inumon di osa utdatuwa nadoba’n tagu gaputa buyut ku, magun-gunaan pay.” ");
INSERT INTO kmk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gangputon man Jesus bilinon dat kagwampuḻu’t duwa’n disipulus na, kaysana ummoy nantudtudu maipanggop sit Nabaḻu’n Damag sidat il-ili un adani’t di. ");
INSERT INTO kmk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ot si Juan un Mambubunyag, mababaḻud sidit nagngoḻana dat kokkoon Kristu ot nangibaun sidat disipulus na daḻapnu umoy da imuson kan siya un, ");
INSERT INTO kmk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Sika kad dit insapatan Apudyus un dumatonga mangiyapu onnu awad sabali’t uwayon mi?” ");
INSERT INTO kmk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Summungbat si Jesus un kanana’n, “Mangulin kayu kan Juan ta ibaga yu danat dingngoḻ yu kan innila yu un, ");
INSERT INTO kmk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","makaila dat nakuḻap, kumiyang dat napilay, napapiya dat nakutoḻ, makagngoḻ dat nabongngog, napaungaḻ dat natoy kan maipatpatigammu pay dit Nabaḻu’n Damag sidat nakapus. ");
INSERT INTO kmk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ot ibaga yu pay kan siya’n nagasat nat tagu’n maid duwaduwa na maipanggop kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Manaḻan man dat imbaun Juan, imbagan Jesus sidat tagu dit maipanggop kan Juan un kanana’n, “Utdit inummoy kayu kan Juan sin igawa maid tagtagguwan na, sin dit ninamnama yu un maila? Tagu kad un kama’t guḻuna mabayogbogan kad maapuapuyog? Bokon. ");
INSERT INTO kmk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ot ngadan dit ummoy yu inila? Tagu kad un nambadut si nabaḻbaḻu’n badut? Bokon. Sat kinatuttuwana sadat tagu un nabaḻu si badut, san boḻoy ali’d inggawan da! ");
INSERT INTO kmk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ot ngadan didit ummoy yu inila? Osa’n propetan Apudyus? On, yoong ibagak kan dikayu un nangatngatu pay nu san propetan Apudyus dit inila yu. ");
INSERT INTO kmk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta si Juan, siya’d ug-ugudon dit naikanglita Ugud Apudyus un kanana’n, ‘Ibaun ku dit propetak un umun-una nu sika un umoy mangisagana’t dit daḻan un ayom.’ ");
INSERT INTO kmk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ibagak kan dikayu din tuttuwa un naid payyan naiyabeng si tagu uttun pita si pinasawayana dit kinapotog Juan un Mambubunyag. Yoong san kadobaan sin mangiyapuwan Apudyus napotpotog nu si Juan. ");
INSERT INTO kmk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Manipud sit timpu un nanudtuduwan Juan un Mambubunyag inggana’t tun satun, napegot da un man-itudtudu utdit maipanggop sit mangiyapuwan Apudyus ot awad da ud taḻona man-an-anus inggana’t maidagamung da utdit mangiyapuwana. ");
INSERT INTO kmk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta losan dat propetan Apudyus sidit kan sadit lintoga ingkanglit Moses, imbaga da dit maipanggop sit mangiyapuwana inggana’t dit dummakngan Juan. ");
INSERT INTO kmk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ot nu tuttuwaon yu dat imbagbaga da, maawatan yu un si Elias un naipugtu’n mangulin, si Juan dit tungpal na. ");
INSERT INTO kmk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nu awad inga yu un makagngoḻ, dumngoḻ kayu. ");
INSERT INTO kmk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sinsadin, singngadan nat mangiyaligak sidan tagu uttuwa lonap? Kama da utdan aabeng un gatupakan sidin aammungan di tagu’n mampipinnakuy sidan kaalimok da un kanan dan, ");
INSERT INTO kmk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mangangsa kami yoong adi kayu manadok! Manlamat kami yoong adi kayu man-ibil!’ ");
INSERT INTO kmk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Kakamma da utdadiya aabeng ta utdit dummatong si Juan, nanlangana nangan kan adina umminum si kumpolmi’n gumuuk ot kanan da un nadimunyu! ");
INSERT INTO kmk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Dummatongaka Inyanak di Tagu, nangananganak kan umminuinumak ot kanan da umana, ‘Ilan yuwot naḻawota mangan kan umiinum, gagayyom na pay dan man-uuḻup si bugis kan uduma gumabasuḻ!’ Yoong tamman nu siya’d kanan da ta maila payon din kinakustun dit silib Apudyus sin mantatagun dan manuttuwa.” ");
INSERT INTO kmk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Inggimaun Jesus dat tagu’t dat boboḻoya nangkokwaana’t dat adu’n am-amug na ta adida nandadaoliyan dat basuḻ da. ");
INSERT INTO kmk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ot kinnanana un, “Kaasi kayu’n iCorazin kan iBetsaida ta nu utdin Tiro kan Sidon ud nakwaan dat am-amuga kingwak sinat igaw yu, nasulit okyanon un nambadut da si ganggoti kan nantutupak da utdit kagabuwan un mangipail-an da un taḻona mandadaoliyan da dat basuḻ da! ");
INSERT INTO kmk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Isunga ibagak kan dikayu un, un-unnay din dusan dan iTiro kan iSidon nu san dusa yu un iCorazin kan iBetsaida nu timpu un mangukum si Apudyus! ");
INSERT INTO kmk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ot dikayu paya iCapernaum, sanat kanan yu maidayaw kayu’d langit? Bokon! Maidawat kayu’t din impiyelnu. Ta nu naipaila’t dat iSodoma dat impailak kan dikayu’n am-amug, nan-awidan da okyan dat basuḻ da kad, adin Apudyus yinam-an dit boboḻoy da ot awad payyan sinsatun! ");
INSERT INTO kmk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ot ibagak kan dikayu un, un-unnay din dusan dan iSodoma nu san dusa yu nu timpu un mangukum si Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Utdi payona timpu, nanluwaḻu si Jesus un kanana’n, “Manyamanak Ama un Apu ud langit kan situn pita ta impatigammum sidat bokona diadaḻ dat inlimod nu utdat nasilib kan diadaḻ. ");
INSERT INTO kmk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","On, yamanok Ama ta siya’d piniyama makwaana.” ");
INSERT INTO kmk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Maabus mana manluwaḻu, kanana’t dat tagu un, “Impulang Amak kan sakon dat losana banag. Ot maid makatigammu’t dan losana maipanggop kan sakona Anak nu adi si Amak kan maid makatigammu’t dan losana maipanggop kan Amak nu adi sakona Anak na kan singngadan na mana piyaoka mangipatigammuwan. ");
INSERT INTO kmk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Losan kayu’n nabannug kan madagdagsonan, umoy kayu kan sakon ta man-illongok dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tuttuwaon yu datu’n itudtuduk, kan man-adaḻ kayu kan sakon ta naanusak kan napakumbabaak ot maillongan kayu. ");
INSERT INTO kmk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta naḻasu datun tudtuduk kan naḻangpaw datun ipakwak kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nangoy da Jesus sit kapappayawana namuḻ-an si trigo ot sadiya aḻgaw, aḻ-aḻgawa iillongan di Judio. Ot gaputa nabitil dat disipulus na, nansapḻut da utdit bungan di trigo si kinutiman da un dinuum. ");
INSERT INTO kmk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yoong inggaw da ud Fariseo un nangila’t dit kingwa da ot kinnanan da kan Jesus un, “Ilam kad din koon dan disipulus nu. Adin dit lintog ipalubus un koon di nu aḻ-aḻgawa iillongan.” ");
INSERT INTO kmk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Summungbat si Jesus un kanana’n, “Adiyu kad nabasa dit kingwan da Ali David kan dat buḻun na utdit nabitilan da? ");
INSERT INTO kmk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nilumnok si Ali David sit boḻoy Apudyus ot kinan da utdat buḻun na dit tinapaya naidatun kan Apudyus un sadat padi ullawa’d mabalina mangan. ");
INSERT INTO kmk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Adiyu kad nabasa utdit lintoga ingkanglit Moses un salsalungasingon dat padi dit lintog ta mangkokwa da utdit timplu nu aḻ-aḻgawa iillongan? Yoong bokona makabasuḻ da. ");
INSERT INTO kmk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ibagak kan dikayu un, antu uttuwon kan dikayu ud napotpotog nu sadin timplu. ");
INSERT INTO kmk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kanan dit ugud Apudyus un, ‘Napotpotog kan sakon din mangaasiyan yu utdan pada yu un tagu, nu san datun yu.’ Nu maawatan yu tun piyaona’n ugudon tu, adiyu pabasuḻon dan maid si basuḻ. ");
INSERT INTO kmk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta sakona Inyanak di Tagu dit awad si kalintogana mangibaga’t dit mabalina makwa nu aḻ-aḻgawa iillongan.” ");
INSERT INTO kmk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Utdi, kaysan si Jesus ot ummoy sit sinagogan dat Judio utdi. ");
INSERT INTO kmk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Inggaw tagu’t di un naek-ekana nakulekug dit osa un ima na. Ot sadat tagu’n man-in-inap si mamabasuḻan da kan Jesus inyimus da un, “Ipalubus kad dit lintog taku’d man-agas sit aḻ-aḻgawa iillongan?” ");
INSERT INTO kmk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Summungbat si Jesus un kanana’n, “Singngadan na kan dikayu ud adi umoy mangokaḻ sit kannelu na nu mabituwan sit aḻ-aḻgawa iillongan? ");
INSERT INTO kmk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Amo napotpotog nat tagu nu sat kannelu ot siya’d manigammuwan un ipalubus nat lintog nu mangwa taku’t nabaḻu nu aḻ-aḻgawa iillongan.” ");
INSERT INTO kmk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Utdi, imbaga na utdit nakulekug si ima un, “Uknadom nat imam.” Inuknad dit tagu dit ima na ot kummiya’n naipadaon sit osa’n ima na. ");
INSERT INTO kmk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Utdi, kaysan dat Fariseo ot ummoy da nambabagbaga nu inon mampapatoy da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tigammun Jesus di un panggop da ot tinengyana diya boboḻoy. Aduadu’n tagu dat naitung-ud kan siya ot pinapiya na dat losana masakit. ");
INSERT INTO kmk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Binilin na dida’n adida ibagbaga dit maipanggop kan siya ");
INSERT INTO kmk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","daḻapnu matungpal dit paimbagan Apudyus sit propeta Isaias sidita kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Siyatu tun manselselbi kan sakon un pinilik. Siya’d pipiyaok kan taḻona masmas-omak. Itdok tun Ispirituk kan siya ot ipatigammu na utdan losana tagu din nalintoga man-uukum ku. ");
INSERT INTO kmk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Adina akasinnungbat kan mampakuy onnu idangsoḻ dit ginga na utdin kaḻsa. ");
INSERT INTO kmk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Adina putdon dit naḻupaka loda onnu kospan dit matmattoyana pingki. Adina man-illong inggana’t mantulay dit kinalintog. ");
INSERT INTO kmk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ot siya’d mannamnamaan dat losana tagu un managu kan dida.” ");
INSERT INTO kmk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sin-aḻgawan payyan, inggaw da ud tagu’n nangidatong kan Jesus si nakuḻap kan naumoḻ ta sinakayan di dimunyu. Inaddag Jesus dit dimunyu’t dit tagu ot nambagbaga kan umilaon. ");
INSERT INTO kmk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ot nasdaaw dat losana tagu’n nangila un kanan dan, “Siya kad nin tu dit kaganakan Ali David un uuwayon taku?” ");
INSERT INTO kmk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yoong dongḻon man dat Fariseo di kanan da un, “Si Beelzebub ullawa un pangat dat dimunyu ud makaitod kan siya si pannakabalin na un mangaddag sidan dimunyu.” ");
INSERT INTO kmk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yoong tigammun Jesus dit somsomok da ot inyabalig na kan dida un, “Sanat ili un mambibinnusuḻ pay lawan danat tagu na, adina mandonoy. Padana pay sidanat mangkakailiyan onnu simbaḻyana mambibinnusuḻ pay lawan, makaskasway da. ");
INSERT INTO kmk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ot nu addagon Satanas si Satanas, busuḻona dit long-ag na pay lawan ot innona’n mandonoy dit mangiyapuwana? ");
INSERT INTO kmk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nu tuttuwa’n si Beelzebub dit nangitod si pannakabalin ku un mangaddag si dimunyu, ngadan nat nangitod si pannakabalin danat buyut yu un mangaddag si dimunyu nu? Ot sadan buyut yu pay lawan ud mamanoknoka bokon nat kanan yu. ");
INSERT INTO kmk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ot gaputa san Ispiritun Apudyus ud nangitod si pannakabalin ku un mangaddag si dimunyu, siya ud mangilasinan un dummatongon kan dikayu din mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Osa payyan, in-inon di osa’n man-aakaw makaḻnok sinat boḻoy di gumibiloga tagu nu adina yan pangawon dit gumibiloga tagu, asi lumnok sit boḻoya man-aḻa’t dat losana kokokwa na? ");
INSERT INTO kmk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sat adi gumungguy kan sakon, busuḻona’d sakon. Ot sat adi tumuḻunga man-awis sidan tagu un manuttuwa kan sakon, dida’d mangiyad-adayu’t dan tagu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Isunga ibagak kan dikayu un losana basuḻ kan nadadaga maibaga un maisuganggang kan Apudyus, mapakawan. Yoong sat mangibaga’t nadadaga maisuganggang kan Ispiritu Santu bokona mapakawan. ");
INSERT INTO kmk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ulay sanat mangibaga’t nadadaga maisuganggang kan sakona Inyanak di Tagu mapakawan yoong sanat mangibaga’t nadadaga maisuganggang kan Ispiritu Santu, adina’n taḻon mapakawan diya basuḻ na si inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nu napiya din kayu, napiya pay din bunga na. Nu laweng din kayu, laweng pay din bunga na. Ta matigammuwan nat kinakayun dinat kayu utnat bunga na. ");
INSERT INTO kmk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ot dikayu’n kaganakan di uḻoga nagita, innona’n makaibaga kayu’t napiya nu nadadag nat somsomok yu? Ta sanat awad sinat kasomsomkan di tagu, siya’d ibosway dinat sangi na. ");
INSERT INTO kmk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sat napiya’n tagu, napiya dat awad sit somsomok na isunga napiya dat ibosway dit sangi na. Ot sat lawenga tagu, laweng dat awad sit somsomok na isunga laweng dat ibosway dit sangi na. ");
INSERT INTO kmk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Tuttuwa tu un ibagak kan dikayu un, nu dumtong dit aḻ-aḻgawa mangukuman Apudyus, osaosa’n tagu sungbatana dat losana imbagbaga na un naid si bogabogas. ");
INSERT INTO kmk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta sanat ugud yu, siya’d mamanoknok nu madusa kayu onnu bokon.” ");
INSERT INTO kmk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Inggaw da ud mimistulun di lintog kan Fariseo un nangibaga kan Jesus un, “Mistulu, piyaon mi un mangipaila ka si am-amug.” ");
INSERT INTO kmk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yoong summungbat si Jesus un kanana’n “Nadadag dan tagu’t tuwa lonap kan nan-awidan da si Apudyus ot man-inap dat am-amug si mangilasinan da nu imbaunak kan Apudyus. Yoong naid udum si ipailak nu adi sat naipasamak kan Jonas un propetan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ta tuḻu’n aḻgaw kan tuḻu’n labi dit Jonas un ininggaw sit buwang didit dakodakoḻa ikan ot padana pay kan sakona Inyanak di Tagu un mailbonak si tuḻu’n aḻgaw kan tuḻu’n labi. ");
INSERT INTO kmk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ot nu dumatong dit aḻ-aḻgawa maukuman dat losana tagu, sumikad dat iNineve un mamabasuḻ sidan tagu’t tun satun. Ta utdit nagngoḻan dat iNineve dit intudtudun Jonas, nandadaoli da ot nan-awidan da dat basuḻ da. Ot antu kan dikayu’d nangatngatu nu si Jonas yoong adiyu tuttuwaon. ");
INSERT INTO kmk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ot padana paya sumikad dit babai’n apun dat iSeba un mamabasuḻ sidan tagu’t tun satun. Ta nanligwat sin adaddayuwana ili’n ummoy nandongoḻ sit ugud didit nalainga Ali Solomon, yoong antu ud nangatngatu nu si Ali Solomon, yoong adin dat tagu dongḻon.” ");
INSERT INTO kmk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Intultuluy kampay Jesus dit nan-abalig un, “Nu lumaksun nat nadadaga ispiritu utnat tagu’n sinakayana, umoy man-ayaayaw sidit igawa naid danum un man-inap si man-illongana. Nu maid odasana’t inggawana, ");
INSERT INTO kmk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kanana un, ‘Mangulinak sit boḻoy ku un tinengyak.’ Ot nu dakngona dit tagu un kama’t boḻoya naid inggaw un nadaḻusan kan nauḻnus, ");
INSERT INTO kmk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","umoy mangidallay si pitu’n ispiritu’n amo nadaddadag nu siya ot longkon da un igawan diya tagu. Kadon amo nadaddadag dit kasasaad didiya tagu nu sadit damu. Ot kama’t di pay din mapasamak sidan nadadaga tagu’t tun satun.” ");
INSERT INTO kmk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Madama payyana mambagbagbaga si Jesus sidat tagu utdit dummatong dat ina na kan dat sunud na. Ininggaw da utdit lasin ta piyaon da un makabagbaga kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Utdi inggaw osa’n ummoy nangibaga kan Jesus un, “Andi da inam kan da sunud nu un gasikadan sin lasin ot piyaon da un makabagbaga kan sika.” ");
INSERT INTO kmk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yoong summungbat si Jesus un kanana’n, “Singngadan kad nat inak kan da susunud ku?” ");
INSERT INTO kmk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Intudu na dat disipulus na un kanana’n, “Sadatu dat inak kan da susunud ku. ");
INSERT INTO kmk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ta singngadan na mana mangwa’t dan ipakwan Amak langit, dida’d susunud ku kan inak.” ");
INSERT INTO kmk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sadi payona aḻ-aḻgaw, tinengyan Jesus diya boboḻoy ot kaysan sit igid bananaw. Nantupak ta mantudtudu, ");
INSERT INTO kmk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","yoong gaputa aduadu dat tagu’n nangammung kan siya, ummoy nantupak sit bangka ot summikad dat tagu utdit igid bananawa mandongoḻ. ");
INSERT INTO kmk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Adu dat imbaga na kan dida’n inyabalig na un kanana’n, “Inggaw osa’n tagu un ummoy nan-iwalis sit bukoḻa tagimuḻa na. ");
INSERT INTO kmk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ot utdit man-iwalisana, naotdag dat uduma bukoḻ sit igid dit daḻan ot ummoy dat sissiwit inamin timpok. ");
INSERT INTO kmk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Naotdag dat uduma bukoḻ sit kabatbatuwana akit si pita ot asimpiga da un tummubu ta atapaw dit pita na. ");
INSERT INTO kmk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yoong uminit man, naḻpak da ot naḻangu da gaputa adida nakalamut si adaḻom. ");
INSERT INTO kmk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Naotdag dat udum sit kasassaitan ot dumakoḻ man dat sait naseet dat muḻa. ");
INSERT INTO kmk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sadat udum paya bukoḻ naotdag da utdit naḻasa’n pita ot dummakoḻ kan namunga da. Inggaw da ud namunga’t singgagasut, inggaw da pay namunga’t sin-oonomapuḻu kan sintutlumpuḻu dat udum.” ");
INSERT INTO kmk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Utdi, inyanungus Jesus un kanana’n, “Dikayu’n awad si inga un makagngoḻ, dumngoḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Utdi, ummadani dat disipulus Jesus kan siya ot inimus da un, “Apay iyabalig nu nat mantutudtudum kan dida?” ");
INSERT INTO kmk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Summungbat si Jesus un, “Dikayu’d nangipatigammuwan Apudyus sidat adi naipatigammu’t dit maipanggop sin mangiyapuwana. Yoong kan dida, adina naipatigammu. ");
INSERT INTO kmk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta sat tagu’n mamtog sidan dongḻona, madogaan dit man-aawat na kad amoamod dat maawatana. Yoong sadit adi mamtog sidan dongḻona ulay sadit akita kanana’n naawatana, makaan. ");
INSERT INTO kmk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Satu’d gapuna un iyabalig ku un mantudtudu kan dida, ta ulay nu iillan da adida maimatunan, ulay dodongḻon da adida makaawat. ");
INSERT INTO kmk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Taḻona dida’d tungpal dit impapadtun Apudyus kan Isaias un propetana’t dit un kanana’n, ‘Makaddongodongoḻ kayu yoong adi kayu makaawat, iillan yu yoong adi kayu makaimatun. ");
INSERT INTO kmk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ta sadatu un tagu ginumḻang dit somsomok da. Ot mamongngobongngog kan manguḻakuḻap da. Ta nu bokona kama’t di, mabalin da un makaimatun, makagngoḻ kan makaawat kad man-ulin da kan sakon ot papiyaok dida.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ot intultuluy Jesus un kanana’n, “Yoong dikayu, nagasat kayu ta makaila kan makagngoḻ kayu. ");
INSERT INTO kmk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tuttuwa’n adu un propetan Apudyus kan nalintoga tagu’t dit un taḻona mamiya’n mangila utdan mail-ila yu uttun satun yoong adida naila, adu dan mamiya’n mangngoḻ sit magmagngoḻ yu yoong adida nagngoḻ.” ");
INSERT INTO kmk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ot dongḻon yu,” kinnanan Jesus, “ta ibagak dit kaipooyan dit inyabalig ku maipanggop sit tagu’n ummoy nan-iwalis si bukoḻ. ");
INSERT INTO kmk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Sadat tagu’n nakagngoḻ sit Ugud Apudyus maipanggop sit mangiyapuwana yoong adida maawatan, dida’d alig dit daḻana naotdagan dat bukoḻ. Ot ummoy Satanas kinaan dit uguda dingngoḻ da. ");
INSERT INTO kmk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sat kabatbatuwana naotdagan dat uduma bukoḻ, alig dat tagu’n mangngoḻ sit ugud Apudyus ot dagusa mataḻok da un mangawat. ");
INSERT INTO kmk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yoong adina makalamut dit ugud kan dida isunga adina mambayag dit manuttuwaan da. Nu awad mapaligatan daon onnu uyungan dat tagu dida maipagapu’t dit manuttuwaan da utdit ugud, dagusa lumipsut daona manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sadit kasassaitana naotdagan dat uduma bukoḻ, alig na dat tagu’n mangngoḻ sit ugud Apudyus yoong gapu’t dat adu’n mabulungan da maipanggop sit mataguwan da uttun pita kan san gumamgaman da un gumaknang, maabak dit dingngoḻ da un ugud ot adina makabunga. ");
INSERT INTO kmk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ot sadit naḻasa’n pita un naotdagan dat uduma bukoḻ, alig na dat tagu’n mangngoḻ kan makaawat sit ugud Apudyus. Ot mamunga da un kama’t muḻa un mamunga’t singgagasut, sin-oonoma puḻu dat udum, kan sintutlu’n puḻu dat udum.” ");
INSERT INTO kmk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nan-abalig payyan si Jesus kan dida un kanana’n, “San mangiyapuwan Apudyus maiyalig si tagu’n ummoy nammuḻa’t nabaḻu’n bukoḻ sit mumuḻ-ana. ");
INSERT INTO kmk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Labi man sit nangkasuyop dat tagu, ummoy dit kabusuḻ na inwalis dit bukoḻ di bollat sit namuḻ-an ot kaysan. ");
INSERT INTO kmk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dummakoḻ dat muḻa ot namunga da yoong dummakoḻ pay dat bollat. ");
INSERT INTO kmk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Utdi, sadat baba-unon dit singkuwa’t dit mumuḻ-an ummoy da kan siya ot kanan da un, ‘Apu, maid mit naikaḻut sit immuḻama bukoḻ ot sin din nanligwatan didi’n bollat?’ ");
INSERT INTO kmk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Summungbata kanana’n, ‘Inwalis dit kabusuḻ.’ Ot kanan dat baba-unona’n, “‘Piyaom ta umoy kami baguton dan bollat?’ ");
INSERT INTO kmk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Summungbata, ‘Adiyu ta maisalibagut kad dan muḻa ya. ");
INSERT INTO kmk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bay-an yu ta dumakoḻ da inggana’t aappitan. Asik ibaga’t dat umoy man-ani un baguton da yan aminon nat bollata poston asida sobgon, asida aniyona igga’t din aḻang ku dat maani.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ot inyabalig payyan Jesus un kanana’n, “Sadin mangiyapuwan Apudyus, maiyalig si bukoḻ di mustasa un ummoy dit tagu immula’t dit mumuḻ-ana. ");
INSERT INTO kmk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Siya’d kaban-ogana bukoḻ yoong nu dumakoḻa nagabogabong, siya’d kadakoḻana muḻa ot kama’t dakoḻa kayu’n umoy dat sissiwit manlubuwan dadit sanga na.” ");
INSERT INTO kmk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nan-abalig payyan si Jesus un kanana’n, “Sadin mangiyapuwan Apudyus, maiyalig si bubuda itamay dit babai si adu’n alina ot alisana un losan dit maitamayana.” ");
INSERT INTO kmk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Inyabalig Jesus un losan dat tudtudu na utdat aduadu’n tagu’n ummoy kan siya. Naid intudtudu na si adi naiyabalig. ");
INSERT INTO kmk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kama’t di dit kingwa na daḻapnu matungpal dit paimbagan Apudyus sidit propeta na un kanana’n, “Iyabalig ku un man-ugud kan dida. Ipatigammuk kan dida dit adi naipatpatigammu manipud sit nakwaan ditun lubung.” ");
INSERT INTO kmk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Utdi, tinengyan Jesus dat adu’n tagu ot nilumnok sit boḻoy. Ummoy dat disipulus na kan siya ot kinnanan da un, “Ipakaawat nu ud dit kaipooyan dit inyabalig nu un bollat sit payaw?” ");
INSERT INTO kmk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Summungbat si Jesus un kanana’n, “Sadit tagu’n nangimuḻa’t dat nabaḻu’n bukoḻ, sakon un Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ot sat mumuḻ-an, satun lubung. Sadat nabaḻu’n bukoḻ, sadat tagu’n maidagamung sin mangiyapuwan Apudyus ot sadat bollat, dida dat tagu’n Satanas. ");
INSERT INTO kmk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ot sat kabusuḻa ummoy nangiwalis sit bukoḻ di bollat, si Satanas. Sadit timpu’n aappitan, siya’d anungus tun lubung. Ot sadat nan-ani, dida dat aanghel Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ot padan dit nasinupan kan nasobgan dat bollat dit mapasamak nu anungus tun lubung. ");
INSERT INTO kmk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta sakona Inyanak di Tagu, ibaun ku dadit anghel ku un umoy mandagup sidat losana tagu’n maigapuwan di mambasuḻan di udum kan losana nadadag ot isinana dida utdan iyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ot idawat da dida’t din apuya adi maksop un siya’d man-ibilan kan mangngilotan da. ");
INSERT INTO kmk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yoong sadat nalintoga tagu makasiling din tukkoḻ da un kama’t init sin mangiyapuwan Ama da. Ot dikayu’n awad si inga un makagngoḻ, dumngoḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Intultuluy kampay Jesus un kanana’n, “San mangiyapuwan Apudyus maiyalig si kaḻuuba naikuḻub sin payaw. Odasan man di osa’n tagu, amod dit taḻok na ot binunbunana’n obos ta ummoy na yan inlaku dat losana kokokwa na asina umoy gatangon dit payaw. ");
INSERT INTO kmk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Padana paya maiyalig din mangiyapuwan Apudyus si kumopoḻaka tagu’n man-in-inap si napopotoga perlas. ");
INSERT INTO kmk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Odasana man dit kapotgan, kaysan ot ummoy na inlaku dat losana kokokwa na, asina umoy gatangon dit perlas. ");
INSERT INTO kmk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Padana paya sadin mangiyapuwan Apudyus, maiyalig sit tabukuḻ un insab-uk dat mantatabukuḻ sidin baybay ot nangna utdat losana kalasin di lamos. ");
INSERT INTO kmk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Utdit napnu, intakdang dat mantatabukuḻ sit igid ot intupak da un nampili’t dat lamos. Sadat napiya, innigga da utdit baḻuḻang ot sadat laweng, indawat da. ");
INSERT INTO kmk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Siya’d padan dit mapasamak di nu anungus tun lubung. Ta umoy dat anghel ilasin dat nadadag sidat nalintoga tagu. ");
INSERT INTO kmk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ot idawat da dat nadadag sit apuya adi maksop ot mampaibil da un mangngilongilot.” ");
INSERT INTO kmk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Utdi, inimus Jesus sidat disipulus na un, “Naawatan yu un losan dan inyabalig ku?” “On,” kanan da. ");
INSERT INTO kmk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ot kinnanan Jesus un, “Nu kama’t di, maawatan yu payon un san mistulun di lintog un natudtuduwan sidan maipanggop sin mangiyapuwan Apudyus, maiyalig si osa’n gumaḻyan un mangokaḻ sidat bagu kan dadaana alikam na un naitalipon sit iiggaan di alikam.” ");
INSERT INTO kmk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Gangputon man Jesus dat abalig na, tinengyana diya igaw, ");
INSERT INTO kmk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ot nangulin sit boboḻoy da. Ummoy nansuḻu’t dit sinagoga ot nasnasdaaw dat nandongoḻ sit tudtudu na ot kanan da un, “Nangaḻ-an ditu uttun silib na kan pannakabalinna’n mangwa’t nakaskasdaaw? ");
INSERT INTO kmk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bokon kada sat anak Jose un kalupantel nat? Si Maria dit ina na kan, sada Santiago, Jose, Simon kan Judas dat sunud na! ");
INSERT INTO kmk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Inggaw da pay un losan situ dat sunud na un babai! Nangaḻ-aḻ-ana utnat laing kan pannakabalin na?” ");
INSERT INTO kmk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Adin dat tagu maawat si Jesus, siya’d gapuna’n imbaga na kan dida un, “Madayaw nat propetan Apudyus sit losana umoyana malaksig sit mismu’n ili na kan sidat kaboḻoy na.” ");
INSERT INTO kmk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ot adina nangwa’t adu’n nakaskasdaaw sidi ta adida tinuttuwa. ");
INSERT INTO kmk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sadiya timpu, dingngoḻ Herodes un siya’d mangiyapu utdin Galilea dit damag maipanggop kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kanana’t dat tagu na un, “Siya si Juan un Mambubunyaga ummungaḻ. Siya’d gapuna un awad pannakabalin na un mangwa’t nakaskasdaaw.” ");
INSERT INTO kmk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kama’t di dit imbagan Herodes ta siya’d nampadopap kan nampaibaḻud kan Juan sidit ta impagapu na kan Herodias un asawan Felipe un sunud na. ");
INSERT INTO kmk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ta si Juan, kanayun un ibagana kan Herodes un, “Iyadin dit lintog taku’n asawaom nat ipag nu un si Herodias.” ");
INSERT INTO kmk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ot siya’d gapuna’n piyaon Herodes papatoy si Juan yoong umogyat sidat tagu ta tuttuwaon da un propetan Apudyus si Juan. ");
INSERT INTO kmk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yoong utdit timpun dit aḻgawa naiyanakan Herodes, nan-amung da ot nanadok dit baḻasanga anak Herodias sit sanguwan dat kaaduwan. Nasnas-om si Herodes ");
INSERT INTO kmk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ot insapata na utdit anak un itdona kan siya dit ulay singngadan na un kodawona! ");
INSERT INTO kmk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Insuḻun ina na dit ibagana ot kanana’n, “Piyaoka itdom kan sakon dit uḻun Juan un Mambubunyag un napalatu.” ");
INSERT INTO kmk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nasigab dit angos ali Herodes yoong gapu’t dit sapatana kan dingngoḻ pay dat sangaili na, imbilin na un maitod dit kodkodawona. ");
INSERT INTO kmk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ot nangibaun si ummoy namutuḻ sit uḻun Juan sit babaḻḻudan. ");
INSERT INTO kmk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Utdiyon indatong da dit napalatu’n uḻun Juan ot intod da utdit baḻasang. Asin payon dit baḻasang intod kan ina na. ");
INSERT INTO kmk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Matigammuwan man dat disipulus Juan dit naipasamak, ummoy da inaḻa dit ladag Juan un innilbon asida ummoy imbaga kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Magngoḻan man Jesus dit damag maipanggop kan Juan, tinengyana diya igaw ot nanlugan sit bangka’n kaysan sit igawa maid tagtagguwan ta piyaona’n man-os-ossaan. Yoong matigammuwan man dat tagu, nangkikkiyang da un nangoy sit igid baybay un naitung-ud kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dumangpot man si Jesus, naila na dadit aduadu’n tagu un naitung-ud. Nadaguwan kan dida ot pinapiya na dadit masakit kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gumidgidam man, ummoy dat disipulus na kan siya ot kanan dan, “Nasdomon, naid pay tagtagguwan situ. Padaḻnom danat tagu ta umoy da utdan boboḻoy ta gumatang da pay lawan si kanon da.” ");
INSERT INTO kmk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Summungbat si Jesus un, “Adina masapula manaḻan da. Dikayu’d mangitod si kanon da.” ");
INSERT INTO kmk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kanan dat disipulus na kan siya un, “Lima’n bukoḻa tinapay kan duwa’n ikana lawa tun antu kan dikami.” ");
INSERT INTO kmk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kinnanan Jesus un, “Idatong yu uttu.” ");
INSERT INTO kmk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Utdiyon imbilin na utdat tagu un mantupak da utdit kabollatan, asina innaḻa dat lima’n bukoḻa tinapay kan duwa’n bukoḻa ikan ot nantangad langit un nanyaman kan Apudyus. Magangput man, biniibiik na dat tinapay asina intod sidat disipulus na ta iwaḻas da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Losan da un nabsuga nangan. Ot sinupon da man dat nabun-an, napnu dat kagwampuḻu’t duwa’n lakba si tinapay. ");
INSERT INTO kmk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Umoya lima’n libu dit bilang dat laḻaki’n nangan un adina naibilang dat babai kan aabeng. ");
INSERT INTO kmk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Maabus man di, pinanlugan Jesus dat disipulus na utdit bangka ta umuna da utdit domang sidit mampadaḻnanaon sidat tagu. ");
INSERT INTO kmk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Abusona man padaḻnon dat tagu, nanagada’t dit bateleda ummoy nanluwaḻu’n os-ossaan. Utdit lumabiyon iinggaw payyan si Jesus sit bateleda ossaan, ");
INSERT INTO kmk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ot sat bangka’n nanluganan dat disipulus na, inggawon sit adani’t dit gawan dit baybaya itaptappiyak di paḻuung ta nabilog dit bayogboga dumupak kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bungbung-on man, naitung-ud si Jesus un kummiyang sit lap-at dit danum. ");
INSERT INTO kmk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yoong maila da man dit mangkikkiyang sit lap-at dit danum, nakapakuy da utdit amoda kimut da un kanan dan, “Banig!” ");
INSERT INTO kmk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yoong dagusa gumminga’t Jesus un, “Adi kayu kumimut ta sakon, adi kayu madanagan!” ");
INSERT INTO kmk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Gumminga pay si Pedro un kanana’n, “Apu! Nu tuttuwa’n sika, pakiyangonak pay sinat lap-at dinat danuma umoy kan sika.” ");
INSERT INTO kmk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Awenu!” insungtbat Jesus. Utdiyon, nilumsa’t Pedro utdit bangka’n kummiyang sit lap-at dit danuma ummoy kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yoong magikna na mana nabilog dit bayogbog, kummimut ot utdit maḻmaḻnodon impakuy na un, “Taguwonak Apu!” ");
INSERT INTO kmk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ot dagusa inaggoman Jesus un kanana’n, “Kaakit nat pammatima! Apay manduwaduwa ka?” ");
INSERT INTO kmk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Utdit nakalugan daona duwa’t dit bangka kakḻata naid dit bayogbog. ");
INSERT INTO kmk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ot sadat disipulus na un ininggaw sit bangka, nandaydayaw da kan siya un kanan dan “Tuttuwa’n sika’d Anak Apudyus!” ");
INSERT INTO kmk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Utdit makadoḻmang da, dummangpot da utdin boboḻoy Genesaret. ");
INSERT INTO kmk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mailasin man dat tagu si Jesus, nangibaun da si umoy man-ibaga’t dat tagu’t dat losana nangkalliputa boboḻoy ot nan-idatong da utdat masakit kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nampakpakaasi da kan siya ta ipalubus na un sekgelon dat masakit dit badut na ulaya lawa’n sat lagayadana. Ot losan dat nanekgel, kummiya da. ");
INSERT INTO kmk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Inggaw da ud Fariseo kan mimistulun di lintoga nanligwat Jerusalem un ummoy kan Jesus ot inimus da un, ");
INSERT INTO kmk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apay danat disipulus nu un adida unudon dit kadawiyan un impatawid dat dadakkoḻ taku? Adida unudon dit kadawiyana mambubuḻu’t ima asida mangan!” ");
INSERT INTO kmk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Summungbat si Jesus un, “Ot apay un salungasingon yu dat bilin Apudyus maipagapu ullawa’t dit mamiyaan yu un maunud dat kadawiyana naipatawid kan dikayu? ");
INSERT INTO kmk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta kanana’t dit bilin Apudyus un, ‘Dayawom da amam kan inam,’ kan kanana pay un, ‘Sanat mangibaga’t laweng sit ama na onnu ina na, masapula mapatoy.’ ");
INSERT INTO kmk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yoong sanat itudtudu yu kanan yu un sat tagu’n mangibaga kan ama onnu ina na un, ‘Itdok kan Apudyus dit ituḻung ku kan dikayu,’ ");
INSERT INTO kmk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","adinaon masapula tumuḻung un mangipaila’t dit mandayawana kan ama na onnu ina na. Inwalin yu dit bilin Apudyus gapu ullawa’t gagom yu un mangunud sidan kadawiyana tinawid yu. ");
INSERT INTO kmk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Man-ag-agin kayu! Tuttuwa dit paimpadtun Apudyus kan propeta Isaias maipanggop kan dikayu un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Sadatuwa tagu, dayawon da ud sakona lawa si bagbaga, yoong adayu dit aangson da kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maid selselbin dit mandayawan da kan sakon gaputa itudtudu da dat lintoga kingwan di tagu ot ibilang daon un lintog ku.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Utdi, inayagan Jesus kan siya dat adu’n tagu ot kinnanana kan dida un, “Dongḻon yu tun ibagak ot ammaan yu un anagon! ");
INSERT INTO kmk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bokona siya’d mampadadag si tagu dit ipaḻnok na utdit sangi na nu adi sadit lawenga ibagan didit sangi na.” ");
INSERT INTO kmk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Utdi ummoy dat disipulus Jesus kan siya ot kanan dan, “Tigammuma laweng dit angos dat Fariseo utdat dingngoḻ da un imbagam?” ");
INSERT INTO kmk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Summungbat si Jesus un, “Losana muḻa un bokona immuḻan Amak ud langit, mabagut nu dumtong dit timpu na. ");
INSERT INTO kmk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bay-an yu danat Fariseo! Ta kama da si nakuḻapa puyut. Ot nu nakuḻap nat mangipuyut sidan pada da un nakuḻap maotdag da un maamin sit bitu.” ");
INSERT INTO kmk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Guminga man si Pedro kanana’n, “Ilawag nu ud nu sin dit kaipooyan dit inyabalig nu.” ");
INSERT INTO kmk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Apay pati kan dikayu adi kayu makaawat?” kinnanan Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Adiyu kad tigammu un sat lumnok sit sangin di tagu, makana lawa un manaḻan sit buwang asi lumaksun? ");
INSERT INTO kmk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yoong sadat bagbaga’n manligwat sit sangin di tagu, manligwat sit aangsona ot siya’d mampadadag kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta sat aangson siya’d manligwatan dit losana nadadaga somsomok di tagu un mangidulun kan siya’n kumatoy, makadagdagas, mangwa utdan koko-on di man-asawa utdin daan na payyan maasaw-an, man-akaw, mantuli kan manlikud. ");
INSERT INTO kmk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Siya datu dan mampadadag si tagu, bokona sat adi mambuḻuwan sit daan manganan.” ");
INSERT INTO kmk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Maabus man di, tinengyan da Jesus diya boboḻoy ot kaysan sin adani’d Tiro kan Sidon. ");
INSERT INTO kmk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ummoy kan Jesus dit osa’n babai un iCanaan un bokona Judio ot impakuy na un kanana’n, “Apu un kaganakan David, kaasiyanak ta sinakayan di dimunyu din anak ku un babai ot amod din ligat na.” ");
INSERT INTO kmk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yoong adin Jesus summungbat kan siya. Ot ummadani dat disipulus na kan siya ot kindaw da un, “Manaḻnom! Ta nadamit un nat maitungtung-ud!” ");
INSERT INTO kmk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Utdi, kinnanan Jesus un, “Naibaunaka lawa’n umoy tumuḻung sidat kaganakan Israel un alig da ud naiyawa un kannelu.” ");
INSERT INTO kmk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yoong ummoy kampay dit babai nan-okog sit sanguwan Jesus un kanana’n, “Tuḻunganak Apu!” ");
INSERT INTO kmk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Summungbat si Jesus un, “Bokona kalobbongana’n ikob-aḻ ta utdanat asu dit kanon di abeng.” ");
INSERT INTO kmk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kinnanan dit babai un, “Tuttuwa nat Apu, yoong ulay sadat asu kanon da pay dat bugtan dit apu da un maotdag sit bansag.” ");
INSERT INTO kmk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Utdi kinnanan Jesus sit babai un, “Tuttuwa’n amod nat pammatim ot makwa nat piyaom.” Ot dagusa kummiya dit abeng na. ");
INSERT INTO kmk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tinengyan Jesus diya igaw ot nangoy sit igid bananaw sidin Galilea asi nanagada’t dit bateled ot nantupak. ");
INSERT INTO kmk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aduadu’n tagu’n ummoy kan siya un nan-idatong sidat napilay, nakuḻap, naumoḻ kan adu dat udum paya masakit. Innigga da dida’t dit sanguwan Jesus ot pinapiya na dida. ");
INSERT INTO kmk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Utdi, nasnasdaaw dat tagu’t dit naila da un mambagbaga dat naumoḻ, kumiyang dat napilay kan umila dat nakuḻap ot nandaydayaw da kan Apudyus un siya’d daydayawon dat kaganakan Israel. ");
INSERT INTO kmk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tuḻu’n aḻgaw daon sidi utdit inayagan Jesus dat disipulus na ot kanana’n, “Madaguwanak sidatu’n tagu ta tuḻu’n aḻgaw daon kan ditaku’t tu ot naidon kanon da. Adik piyaona manaḻnon dida un mabibittil ta maulaw da kad sinat daḻan ya.” ");
INSERT INTO kmk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Summungbat dat disipulus na un, “Mangaḻ-an mi si umanaya ipakan mi utdatu’n aduadu’n tagu’t tun naid taguna’n igaw?” ");
INSERT INTO kmk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ot inimus Jesus un, “Piga dit tinapay yu un awad sinat?” “Pitu’n bukoḻ kan antu da pay akita ikan un banan-og,” insungbat da. ");
INSERT INTO kmk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pinantupak Jesus dat tagu’t dit pita. ");
INSERT INTO kmk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Utdi, innaḻa na dat pitu’n bukoḻa tinapay kan akita ikan ot nanyaman kan Apudyus. Maabus mana manyaman, biniibiik na dat tinapay kan ikan asina intod sidat disipulus na ot inwaḻas da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Losan da un nabsuga nangan. Ot sinupon man dat disipulus Jesus dit nabun-an, napnu dat pitu’n lakba. ");
INSERT INTO kmk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Opata libu dit bilang dat laḻaki’n nangan un adina naibilang dat babai kan aabeng. ");
INSERT INTO kmk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Maabus man di, pinadaḻanon Jesus dat adu’n tagu asida nambangka utdat disipulus na un kaysan sidin sakup Magadan. ");
INSERT INTO kmk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Inggaw da ud Fariseo kan Saduceo un ummoy namadpadas kan Jesus ot kindaw da kan siya’n mangipaila’t am-amuga mangilasinan da un si Apudyus ud nangibaun kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yoong kinnanan Jesus un, “Nu mangagḻaḻak nu gidgidam kanan yu un napiya’n aḻ-aḻgaw nu bigat. ");
INSERT INTO kmk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ot nu mangagḻaḻak kan nabunot din langit nu biggabiggat kanan yu paya umudan. Mabalin yu un maibaga dit kasasaad dit aḻ-aḻgaw nu ilan yu din langit yoong adiyu maibaga dit kaipooyan dan mangimatunana makmakwa uttuwa timpu? ");
INSERT INTO kmk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Taḻona nadadag kayu’n tagu’t tuwa lonap. Nan-awidan yu si Apudyus! Man-inap kayu si am-amug si mangilasinan yu yoong maid udum si ipailak nu adi sat naipasamak sit Jonas,” kinnanana ot tinengyana dida’n kaysan sit domang. ");
INSERT INTO kmk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Makadoḻmang man da Jesus sidit bananaw, nagasmok dat disipulus na un adida nambaḻun si tinapay. ");
INSERT INTO kmk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Utdit nambagbaga si Jesus kinnanana un, “Mansiput kayu ot alimbanan yu dit bubud dan Fariseo kan Saduceo.” ");
INSERT INTO kmk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Magngoḻ da man dit imbagan Jesus nambabagbagaan da un kanan dan, “Siya’d imbaga na di ta naliuwan taku’n nambaḻun.” ");
INSERT INTO kmk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yoong titiggammun Jesus dit babagbagaon da ot kanana kan dida un, “Kaakit nat pammati yun. Apay un sanat kamaid di tinapay yu nat babagbagaon yu? ");
INSERT INTO kmk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Adiyu kad payyan maawatan un awad pannakabalin ku? Naliuwan yu kadon dat lima’n bukoḻa tinapaya naipakan sidat lima’n libu un tagu? Piga’n lakba dit nabun-ana sininup yu? ");
INSERT INTO kmk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Onnu sat pitu’n bukoḻa tinapaya naipakan sidat opata libu’n tagu? Piga’n lakba dit nabun-ana sininup yu? ");
INSERT INTO kmk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Adiyu kad payyan maawatana bokona tinapay dit ug-ugudok kan dikayu’t dit imbagaka adayuwan yu dit bubud dat Fariseo kan Saduceo?” ");
INSERT INTO kmk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Utdi, naawatan dat disipulus na un bokona sad adayuwan da dit bubud di tinapay nu adi sat itudtudun dat Fariseo kan Saduceo. ");
INSERT INTO kmk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Utdit inummoy da Jesus sin lakub Cesarea Filipos, inimus na utdat disipulus na un, “Singngadan ku un Inyanak di Tagu utdit makanan dat tagu?” ");
INSERT INTO kmk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Summungbat da un, “Kanan dat uduma sika kanu dit Juan un Mambubunyag. Kanan pay dat uduma sika kanu dit Elias yoong sadat udum payyan kanan da un sika dit Jeremias onnu osa’t dat propetan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ot inimus Jesus kan dida un, “Ot dikayu pay nu, singngadan ku utnat makanan yu?” ");
INSERT INTO kmk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Summungbat si Simon Pedro un, “Sika dit Kristu un Anak ud matatagu un Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kinnanan Jesus un, “Nagasat ka Simon un Anak Jonas ta bokona tagu nat nangipatigammu uttu kan sika, nu adi si Amak ud langit. ");
INSERT INTO kmk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ot ibagak kan sika un sanat ngadan nu un Pedro, batu dit kaipooyana. Ot sanata batu dit pannana mangisaadak sidat kadagupan dat tagu’n manuttuwa kan sakon. Ot maid makaabak kan dida un ulay nu san pannakabalin ud katoy. ");
INSERT INTO kmk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ot itdok kan sika dit tulbok sin mangiyapuwan Apudyus ot nu singngadan nat adim ipalubus situn pita, adina pay maipalubus sin langit. Ot singngadan na mana ipalubus nu uttun pita, maipalubus pay sin langit.” ");
INSERT INTO kmk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Utdi, impaypaysod Jesus binilin dat disipulus na un adida un taḻon ibagbaga’t udum un siya dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Manipud sidiya timpu, inlugin Jesus un ipatigammu’t dat disipulus na un masapula umoy sin Jerusalem ot adu’n ligata sagapaḻona utdat lalallakay di Judio, aap-apun di padi kan mimistulun di lintog kan mapatoy yoong umungaḻ nu maikatlu’n aḻ-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Utdi, indallay Pedro utdit ad-adayu ot inggimau na un kanana’n, “Apu, iyadayun okyan Apudyus. Adina mabalina maipasamak kan sika nat kama’t nat.” ");
INSERT INTO kmk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yoong sinangun Jesus ot kinnanana kan siya’n, “Adayuwanak Satanas! Lappod ka kan sakon. Ta bokona sat piyaon Apudyus nat sosomkom nu adi sat piyaon di tagu.” ");
INSERT INTO kmk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ot kinnanan Jesus sidat disipulus na un, “Nu sinnat mamiya un maidagamung kan sakon, masapula igongda naona somsomkon dit mataguwana uttun pita, bukudona dit kulus na asi umunud kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta sanat tagu’n manaḻakug sit mataguwana’t tun pita, adina maitdan si mataguwana’t inggaingga yoong sat tagu’n mataḻak na dit mataguwana maipagapu’t manuttuwaana kan sakon, maitdan si mataguwana’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngadan nat maganab nat osa’n tagu nu mangkuwa na dan losana kinabaknang situn lubung yoong mataḻak na dit mataguwana’t inggaingga? Ta naid mabalina maitod di tagu si kasukat di mataguwana. ");
INSERT INTO kmk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sakona Inyanak di Tagu, mangulinak un buḻun ku dat aanghel ku kan awad kan sakon dit nakaskasdaawa kinangatun Amak. Nu dumatong diya timpu gun-gunaak dat losana tagu manigun sit kingkingwa da. ");
INSERT INTO kmk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ot tuttuwa tun ibagak un awad kan dikayu un antu uttun satun ud adi yan matoy inggana si ilan da ud sakona Inyanak di Tagu un dumatonga Ali.” ");
INSERT INTO kmk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lumabas man onoma aḻgaw, indallay Jesus si Pedro, da Santiago kan Juan un mansunud un nanagada’t dit nangatu’n bateled. ");
INSERT INTO kmk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Inggaw da man sidi, naobos dit ilan Jesus. Makasiling dit pasngit na un kama’t init kan napoḻkapoḻkas dit badut na un kama’t silawa makasiling. ");
INSERT INTO kmk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ot kakḻata nailan dat tuḻu’n disipulus Jesus da Moses kan Elias un makabagbagbaga kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ot guminga man si Pedro, kanana kan Jesus un, “Apu, napiya ta antu taku uttu. Nu piyaom mangwaak si tuḻu’n sigay situ, mangkuwam nat osa, mangkuwan Moses nat osa kan mangkuwan pay Elias nat osa.” ");
INSERT INTO kmk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Utdiya mambagbagaana payyan, inggaw bunota makasilinga nangayyung kan dida’n losan ot inggaw ginga’n nanligwat sit bunota kanana’n, “Siyatu’d pipiyaoka Anak ku un masmas-omak, dumngoḻ kayu kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dongḻon man dat disipulus Jesus di, inumping da utdit pita ta amod dit kimut da. ");
INSERT INTO kmk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yoong ummadani si Jesus kan dida ot inagpadana dida un kanana’n, “Lumigwat kayu! Adi kayu kumimut.” ");
INSERT INTO kmk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Utdit manlungayat da, naid innila da si udum nu adi si Jesus ullawa. ");
INSERT INTO kmk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Utdit madama’n gumusad da utdit bateled, binilin Jesus dida un, “Adiyu ibagbaga’t udum dit naila yu inggana’t umungaḻaka Inyanak di Tagu kan katoy.” ");
INSERT INTO kmk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Utdi inimus dat disipulus na un, “Apay kanan danat mimistulun di lintoga masapula umun-una kanu’t Elias un dumatong nu sadit Kristu nu?” ");
INSERT INTO kmk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Summungbat si Jesus un, “Tuttuwa’n masapula mauna’t Elias dumatonga umoy mangisagana’t dat losan. ");
INSERT INTO kmk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yoong ibagak kan dikayu un naabusona dummatong si Elias yoong adin dat tagu naimatunan ot kingwa da dat piniya da un kingwa kan siya. Ot padana pay un paligaton da ud sakona Inyanak di Tagu.” ");
INSERT INTO kmk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Utdiyon, naawatan dat disipulus na un si Juan un Mambubunyag dit ibagbaga na un Elias. ");
INSERT INTO kmk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dakngon man da Jesus dit inggawan dat adu’n tagu, inggaw tagu’n ummadani kan siya un nampalintumong sit sanguwana’n kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apu, kaasiyam din abeng ku un laḻaki ta nakoḻdas ot taḻona mampalpaligat. Kanayuna matukas sin apuy kan danum. ");
INSERT INTO kmk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ummoyak impaila’t danat disipulus nu yoong adida mapapiya.” ");
INSERT INTO kmk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Summungbat si Jesus un, “Ay, naid pammati yu un tagu’t tuwa lonap kan bokobokon nat somsomok yu! Kamaan nat kabayag ku un iinggaw kan dikayu inggana’t manuttuwa kayu? Kamaan nat kaandun nat mangiyan-anusak kan dikayu? Idatong yu kan sakon nat abeng.” ");
INSERT INTO kmk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Idatong da man, inggimaun Jesus dit dimunyu ot tinengyana dit abeng ot dagusa kummiya. ");
INSERT INTO kmk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Utdiyon ummoy dat disipulus kan Jesus un dida ullawa ot inimus da kan siya un, “Apay adimi maaddag diya dimunyu nu?” ");
INSERT INTO kmk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Summungbat si Jesus un, “Onta akit nat pammati yu. Tuttuwa tun ibagak kan dikayu un, ulay nu kama’t bukoḻ di mustasa nat kaban-og nat pammati yu, mabalina kanan yu uttun bateled un, ‘Umalis ka utdi,’ ot umalis. Maida taḻon adiyu makwa. ");
INSERT INTO kmk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yoong sadan kama’t diya dimunyu, adida maaddag nu adin dit mangaddag ipapati’n manluwaḻu kan lumangan paya mangan sidit manluwaḻuwana.” ");
INSERT INTO kmk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Utdit nandatdatong da Jesus sidat disipulus na ud Galilea, imbagana kan dida un, “Sakona Inyanak di Tagu, dandaniyona maiyawatak sidat tagu. ");
INSERT INTO kmk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Patoyon da ud sakon yoong nu maikatlu’n aḻgaw mapaungaḻak.” Utdi, amod dit domdom dat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dumatong man da Jesus ud Capernaum sidat disipulus na, inimus dat man-uuḻup si bugis di timplu kan Pedro un, “Mambayad pay nat mistulu yu ut bugis di timplu?” ");
INSERT INTO kmk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Inonaan!” insungbat Pedro. Lumnok man si Pedro utdit boḻoya inggawan Jesus, naun-una’t Jesus gumminga’n kanana’n, “Pedro, ngadan nat makanam, sin dit mambugison dat ali’t tun lubung? Sadat tagu da onnu sadat kakkaili?” ");
INSERT INTO kmk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Sadat kakkaili,” insungbat Pedro. Kinnanan Jesus un, “Nu siyanat, di adina masapula mambayad dat tagu da. ");
INSERT INTO kmk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yoong daḻapnu adi dita lawengon sidan tagu, umoy ka utdin bananaw ta umoy ka mamungwit. Sat umuna’n gongtoma lamos ilam dit sangi na kad awad odasam si pilaka umanaya mambugis ta. Aḻam ta siya’d mambayad nu utnat bugis ta un duwa.” ");
INSERT INTO kmk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Utdi payona timpu ummoy dat disipulus Jesus kan siya inimus un, “Singngadan dit kangattuwan sin mangiyapuwan Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Utdi nangayag si Jesus si abeng ot pinasikad na utdit gawa da. ");
INSERT INTO kmk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Utdi, kinnanana’n, “Tuttuwa tun ibagak kan dikayu un, nu adi kayu mambalbaliw kan mambalin si kama nu abeng payyan, adi kayu maidagamung sidan iyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Singngadan na mana napakumbaba un padan tun abeng, dida’d kangattuwan sin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Singngadan na mana mangawat si kama’t tu un abeng un ipagapu na kan sakon, sakon ud inawat na.” ");
INSERT INTO kmk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yoong singngadan na man un maigapuwan di makabasuḻan di osa’t datuwa aabenga mamati kan sakon, un-unnaya lawa’n matakodan si dakoḻana gigillingana batu dit bagang na asi maidawat sin baybay daḻapnu maḻmos. ");
INSERT INTO kmk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nasigaba taḻon tun kasasaad situn lubung ta adu dan mabalina maigapuwan di makabasuḻan di tagu. Awada awad datuwa maigapuwan di makabasuḻan yoong kaasi pay nat tagu’n maigapuwan di osa un mambasuḻ. ");
INSERT INTO kmk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ot nu sanat imam onnu ikim nat maigapuwan nat makabasuḻam, putdom ta idawat nu! Ta un-unnaya lawa un osossaan nat imam onnu ikim un lumnok sin mataguwan si inggaingga, nu sanat duwa nat imam onnu ikima maidawat sin apuya adi maksop. ");
INSERT INTO kmk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ot nu sanat atam nat maigapuwan di makabasuḻam, tuwilom ta idawat nu. Ta un-unnaya matagu ka si inggaingga’n osossaan nat atam nu sanat duwa nat atama maidawat sin apuy sin impiyelnu.” ");
INSERT INTO kmk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Intultuluy Jesus un kanana’n, “Ilan yu ta adiyu idapdapes ulay osa’t datuwa aabeng. Ibagak kan dikayu un sadat aanghel un manga-ayyuwan kan dida kanayuna awad dat din sanguwan Apudyus un Amak sin langit. ");
INSERT INTO kmk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ot sakona Inyanak di Tagu, ummoyak situ un managu’t dat tagu’n naiyawa. ");
INSERT INTO kmk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ta ngadan nat koon nat tagu’n awad si singgasuta kannelu nu maiyawa dit osa? Adina kad taynan dat siyamapuḻu’t siyam sin tangsa ta umoy na inapon dit osa’n naiyawa? ");
INSERT INTO kmk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ot nu odasana, ibagak kan dikayu un amo mataḻok sit osa un indasana nu sadadit siyamapuḻu’t siyama adi naiyawa. ");
INSERT INTO kmk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ot padana pay kan Amak sin langit un adina piyaona awad osa’t datuwa aabeng na ud maisina kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nu nakabasuḻ kan sika nat buḻun nu un manuttuwa, umoy ka kan siya ta ibagam dit nakabasuḻana yoong koom nu dudduwa-an kayu. Ot nu dumngoḻ ta mampakawan impaolim dit napiya un mambuḻbuḻunan yu. ");
INSERT INTO kmk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yoong nu adina dumngoḻ, mangidallay ka si osa onnu duwa’t buḻun nu un umoy obos makabagbaga kan siya daḻapnu awad duwa onnu tuḻu’t mamanoknok sidan losana maugud. ");
INSERT INTO kmk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ot nu adina kampay dongḻon dida, ipatigammum sidat buḻun yu un manggigimung. Nu adina kampay dumngoḻ kan dida ibilang yuwona tagu’n adi manuttuwa kan Apudyus onnu padan dat man-uuḻup si bugisa gumabasuḻ. ");
INSERT INTO kmk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ot ibagak kan dikayu’n losana disipulus ku un, nu singngadan nat adiyu ipalubus situn pita, adina pay maipalubus sin langit. Ot nu sinnat ipalubus yu uttun pita, maipalubus pay sin langit. ");
INSERT INTO kmk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Padana paya, nu man-ampayunan danat duwa kan dikayu’n manuttuwa nat kodawon da kan Amak ud langit, maitod. ");
INSERT INTO kmk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta nu sinnat kawadan di duwa onnu tuḻu’n mandatdatonga maipagapu’t din naiyossaanan da kan sakon, awadak pay kan dida utdi.” ");
INSERT INTO kmk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Utdi, ummoy si Pedro kan Jesus ot inimus na un “Apu, mamimpiga’n pakawanok din buḻun ku un makabbasubasuḻ kan sakon, mamimpitu?” ");
INSERT INTO kmk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Summungbat si Jesus un, “Bokona mamimpitu ullawa, nu adi pakawanom si mamimpitumpuḻu un pitu. ");
INSERT INTO kmk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ta san mangiyapuwan Apudyus, maiyalig si ali un piyaona’n mansingil sidat manselselbi kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Manlugi mana mansingil, inyoy da dit osa’n milyu-milyun dit bayadana. ");
INSERT INTO kmk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yoong gaputa adina makabayad, imbilin dit ali un mailaku da un losana simbaḻyan daḻapnu manselbi da si udum kan mailaku pay dan losana sanikuwa da daḻapnu makabayad. ");
INSERT INTO kmk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Yoong dagusa nampalintumong diya tagu utdit atubang dit ali ot kanana’n dit nampangpangaasi un, ‘Apu, anusam yan ta asik aminon bayadan nu awad ibayad ku.’ ");
INSERT INTO kmk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Utdi kinaasiyan didit ali ot pinakawan na dit utang na asina pinadaḻan. ");
INSERT INTO kmk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lumaksun man di un tagu, inabot na dit padana un manselselbi un nakautang kan siya si singgasuta denario. Dagusa dinokmaana ot pinsoḻ na un kanana’n, ‘Bayadam dit utang nu kan sakon.’ ");
INSERT INTO kmk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Yoong nampalintumong dit padana un manselselbi ot nampakpakaasi’n kanana’n, ‘Anusam yan ta asik aminon bayadan nu awad ibayad ku.’ ");
INSERT INTO kmk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Yoong ummadina ta pinabaḻud na inggana’t makabayad sit utang na. ");
INSERT INTO kmk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Nailan dat pada da un manselselbi dit naipasamak ot laweng dit angos da ot ummoy da imbaga’t dit ali dat losana napasamak. ");
INSERT INTO kmk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Utdi pinaayagan dit ali diya manselselbi ot kanana kan siya un, ‘Nadadag ka paya manselselbi. Adik sika pinambayad gaputa nampangpangngaasi ka. ");
INSERT INTO kmk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ot kinaasiyam pay okyan dit padama manselselbi un kama’t dit nangkakaasik kan sika!’ ");
INSERT INTO kmk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Gapu utdit amoda suḻag dit ali pinabaḻud na diya manselselbi ta madusa inggana’t mabayadana dat losana utang na.” ");
INSERT INTO kmk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Utdiyon kinnanan Jesus un, “Siyadi’d padan din koon Amak langit kan dikayu nu adiyu ud gattoka pakawanon dan buḻun yu.” ");
INSERT INTO kmk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gangputon man Jesus itudtudu’n losan dadi, tinengyana’d Galilea ot kaysan sin lakub Judea utdin kapon domang didin wangwang Jordan. ");
INSERT INTO kmk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Adu dat tagu’n naitung-ud kan siya ot pinapiya na dat masakit kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Inggaw da ud Fariseo un ummoy kan siya daḻapnu padpadason da ot inimus da un, “Ipalubus kad dit lintog taku’n idangan dit laḻaki si asawa na si kumpolmi’n gapuna?” ");
INSERT INTO kmk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Summungbat si Jesus un, “Adiyu kad binasa dit naikanglita ugud Apudyus un sidit damu’n namaloswaana’t tagu kingwa na dit laḻaki kan babai? ");
INSERT INTO kmk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ot kanana un ‘Siya’d gapuna un tengyan dit laḻaki da ama na kan ina na ta umoy sumip-un sit asawa na kad mambalin da si osa.’ ");
INSERT INTO kmk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Utdi bokonona duwa nu adi kama dat ossaana long-ag. Isunga singngadan na mana pinansip-un Apudyus un man-asawa, maid tagu’t mabalina mangidang kan dida.” ");
INSERT INTO kmk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Utdi, inimus uman dat Fariseo un, “Nu siyadi, apay imbagan dit lintog Moses un mabalina mangitod dit laḻaki’t dit asawana si kasulatan dit man-idanganda, asina padaḻnon?” ");
INSERT INTO kmk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Summungbat si Jesus un, “Pinalubusan dikayu kan Moses un umidang sidat asawa yu gaputa adi kayu matudtuduwan yoong bokona siya’d panggop Apudyus sit pogpoga’n nangwaana’t tagu di. ");
INSERT INTO kmk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ot ibagak kan dikayu un, mabalina umidang nat laḻaki nu nakadagdagas dit asawa na yoong makabasuḻ si dagdagas nu mangasawa’t udum.” ");
INSERT INTO kmk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Utdi, kanan dat disipulus na un “Nu siya’d kokwana di, un-unnay din adi mangasawa.” ");
INSERT INTO kmk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kinnanan pay Jesus un, “On, yoong bokona losana tagu’n makakwa’t di nu adi sadan nangitdana lawan Apudyus si kabooḻana adi mangasawa. ");
INSERT INTO kmk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta awad da ud adi mangasawa gaputa nakawoy da manipud sit naiyanakan da. Awad da pay uduma adi mangasawa ta naibutuwan da. Ot awad da pay uduma adi mangasawa daḻapnu maiyosssaan da un mangiwalagawag sit maipanggop sit mangiyapuwan Apudyus. Ot sadan kabooḻan da un adi mangasawa, adida.” ");
INSERT INTO kmk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ininggaw da ud tagu’n nan-idatong sidat aabeng da kan Jesus daḻapnu agpadana dida’n iluwaḻuwan un bindisyunan yoong inggimaun dat disipulus Jesus dat tagu. ");
INSERT INTO kmk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Utdi kinnanan Jesus un, “Bay-an yu un umoy danat aabeng kan sakon, adiyu iyapa dida ta sadan kama kan dida dan maidagamung sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Utdi, inyagpad Jesus dit ima na un namindisyun kan dida asina kaysan. ");
INSERT INTO kmk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ininggaw osa’n tagu un ummoy kan Jesus nan-im-imus un, “Mistulu, ngadan dit napiya un kook daḻapnu mataguwak si inggaingga?” ");
INSERT INTO kmk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Summungbat si Jesus un kanana’n, “Apay imusom kan sakon nu sin dit napiya. Ossaana lawa din napiya un siya si Apudyus. Ot nu piyaoma matagu’t inggaingga, tungpaḻom dat bilin na.” ");
INSERT INTO kmk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Inimus payyan dit tagu un, “Ngadan na un bilin?” Summungbat si Jesus un, “Adika kumatoy. Adika managdagas. Adika man-akaw. Adika mangkustigu si tuli. ");
INSERT INTO kmk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Dayawom da amam kan inam kan piyaom dat buḻun nu un kama’t nat mampipiyam sinat long-ag nu.” ");
INSERT INTO kmk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Summungbat dit laḻaki un, “Tungtungpaḻoka losan danaton ot ngadan na payyan nat masapul ku?” ");
INSERT INTO kmk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kinnanan Jesus kan siya un, “Nu piyaoma taḻona maid mangkulangam, umoy ka ilaku’n aminon dat kukuwam ot itdom sidat nakapus dit bayad na kad awad binaknang nu ud langit, asikaon umunud kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dongḻon man dit laḻaki di, nanduduuy ot kaysana madomdomdoman ta taḻona baknang. ");
INSERT INTO kmk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Utdi, kinnanan Jesus sidat disipulus na un, “Tuttuwa tun ibagak kan dikayu un, nasigaba makaḻnok danat nabaknang sin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ot ibagak payyan kan dikayu un naḻasḻasu’n mangoy nat kamelyu utnat abut di tanud nu sanat baknanga tagu’n lumnok sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dongḻon man dat disipulus na di, taḻona nasnasdaaw da ot inimus da un, “Singngadan dat taguwon Apudyus nu?” ");
INSERT INTO kmk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yoong tummukkoḻ si Jesus kan dida un dit summungbat un, “Adina makwa di nu tagu’d mangwa yoong si Apudyus kabooḻana’n mangwa’t dan losana banag.” ");
INSERT INTO kmk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Utdi kinnanan Pedro un, “Dikami nu, un tinengyan mi dat losana kukuwa mi daḻapnu sika’d uunnudon mi ot sin dit gun-guna mi?” ");
INSERT INTO kmk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Summungbat si Jesus un, “Tuttuwa tun ibagak kan dikayu un, nu masukatan tun lubung si bagu, mantupakak un Inyanak di Tagu utdin madaydayawa tronok un mangiyapu. Ot dikayu’n disipulus ku, mantupak kayu pay sidat kagwampuḻu’t duwa’n trono un manguis sidan tribun dat kagwampuḻu’t duwa’n anak ud Israel. ");
INSERT INTO kmk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ot losana maneyan sit boḻoy na onnu susunud na onnu ama na onnu ina na onnu aabeng na onnu pita na maipagapu’t umunudana kan sakon, adayu’n aduadu dan maawat na nu sat tinengyana kan tawidona pay dit mataguwan un maid kigad na. ");
INSERT INTO kmk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yoong adu dat tagu’n maun-una uttun satun un maudi kan adu dat tagu’n maudi uttun satun un maun-una nu timpu na.” ");
INSERT INTO kmk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“San man-apuwan Apudyus maiyalig si tagu’n nanawag dit minuḻ-ana’t ubas. Ot nanwiswis-ita ummoy nan-inap si tangdanana’t tagu’n mangkokwa’t dit kaubasana. ");
INSERT INTO kmk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Intuḻon na un tangdanana dida’t osa’n denario si sin-aḻgaw ot imbaun na dida’n umoy nangkokwa’t dit kaubasana. ");
INSERT INTO kmk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Mangmanganan man si bang-oga banga, ummoy uman nan-ila’t tagu ot indasana dat gasikadan sit laḻakkuwana naid si kokkoon. ");
INSERT INTO kmk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ot imbaga na kan dida un, ‘Ikayu pay mangkokwa’t din kaubasak ta tangdanak dikayu si kustu’n tangdan yu.’ Utdi ummoy da. ");
INSERT INTO kmk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Mamatuk man kan padana pay sit nandangwilis si init, ummoy payyan nan-inap. ");
INSERT INTO kmk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Manuldullaḻayap man si init, ummoy uman nan-inap si mangkokwa ot naila na dat uduma gasikadana naid si koon ot kinnanana’n ‘Apay palabson yu ullawa nat aḻ-aḻgaw yu uttu un naid si kokkoon?’ ");
INSERT INTO kmk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“‘Onta naid ussiya’d manangdan kan dikami,’ kinnanan da. ‘Ot umoy kayu pay mangkokwa’t din kaubasak,’ kinnanana kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Gumidgidam man, inayagan dit singkuwa’t dit kaubasan dit kapatas na un kanana’n, ‘Ayagam dat nangkokwa ta itdom dit tangdan da, manlugi’t dat naudi inggana’t dadit nauna’n nangkokwa.’ ");
INSERT INTO kmk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Dumatong man dat nanlugi’n nangkokwa’t dit manuldullaḻayapan init, tinangdanana dida’t sin-ossa un denario. ");
INSERT INTO kmk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Utdit dumatong dadit ummun-una un nangkokwa, kanan da nu ad-adu dit tangdan da yoong padana pay sit tangdan dadit naudi un sin-ossa un denario. ");
INSERT INTO kmk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inaḻa da dit tangdan da ot inlugi da un nanlili’t dit singkuwa’t dit kaubasana kanan dan, ");
INSERT INTO kmk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Sadat nangkokwa’t sin-olasa lawa, naipada dit tangdan da kan dikami’n nangkokwa’n nampaaḻgaw sit nasigaba init.’ ");
INSERT INTO kmk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Yoong kinnanan dit singkuwa’t dit kaubasan sit osa’t dat nangkokwa un, ‘Gayyom, bokona kinuluk ku dikayu ta intuḻon yu un tangdanak dikayu’t osa’n denario si sin-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ot aḻan yu nat tangdan yu ta manaḻan kayu. Piyaoka tangdanan datun naudi si padan dit tangdan yu. ");
INSERT INTO kmk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bokon kad si kalintogaka mangwa’t piyaok sit pilak ku pay lawan? Onnu umapaḻ kayu gaputa nalaayaka tagu?’ ” ");
INSERT INTO kmk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Utdi inyanungus Jesus un kanana’n, “Sadan naudi maun-una dan tu, ot sadan ummuna maudi dan tu.” ");
INSERT INTO kmk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Utdit managad-an da Jesus un umoy Jerusalem, tinang-il na dat kagwampuḻu’t duwa’n disipulus na un binagbaga ot kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Dumngoḻ kayu! Managada taku’d Jerusalem ot sakona Inyanak di Tagu maiyawatak sidat aappun di padi kan mimistulun di lintog ot ikoddong da un mapatoyak. ");
INSERT INTO kmk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Asida iyawat sakon sidat bokona Judio daḻapnu manliwliw-anak, kumkumpasanak kan ilansaak sidit kulus yoong umungaḻak sin maikatlu’n aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Maabus man di, ummadani dit asawan Zebedeo un buḻun na dat duwa’n anak na. Nampalintumong sit atubang Jesus daḻapnu mangkodaw. ");
INSERT INTO kmk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Inimus Jesus un, “Singngadan nat piyaom?” Summungbata kanana’n, “Ipalubus nu okyan un mantupak tun osa’n anak ku utnat kapon madiwanam kan osa’t nat kapon makawigim sin mangiyapuwam.” ");
INSERT INTO kmk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yoong summungbat si Jesus un kanana’t dat duwa’n anak un, “Naid tigammu yu utnat kodkodawon yu. Mabooḻan yu kad nat ligata sagapaḻok?” “On, mabooḻan mi,” kanan da. ");
INSERT INTO kmk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Summungbat uman si Jesus un, “Tuttuwa’n mapaligat kayu’n padan din mapaligatak yoong bokona sakon mamili’t dat mantupak situn kapon madiwanan ku kan makawigik ta insaganan Amak di un mantupakan dat pinilina.” ");
INSERT INTO kmk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dongḻon man dat simpuḻu dit kingwan dat mansunud, summuḻag da kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Utdi, inayagan Jesus dida’n losan ot kinnanana kan dida un, “Titiggammu yu un sadan maapu utdan bokona Judio, puyungon da dan iyapuwan da. Ipailan dadit awad si tulay dit pannakabalin da utdan tagu da. ");
INSERT INTO kmk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yoong bokona kama’t di dit makwa kan dikayu. Ta singngadan na mana mamiya un nangatu, masapula manselbi kan dikayu’n losan. ");
INSERT INTO kmk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ot singngadan na mana mamiya un siya’d kangattuwan, masapula manselbi kan dikayu un kama’t babbaun. ");
INSERT INTO kmk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kama kan sakona Inyanak di Tagu, bokona dummatongak daḻapnu paselbiyak sidan tagu nu adi dummatongak daḻapnu manselbiyak kan dida. Dummatongak daḻapnu itdok tun angos ku un mansubbut ku utdan adu’n tagu.” ");
INSERT INTO kmk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lausan man da Jesus ud Jerico, aduadu’n tagu un naitung-ud kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Utdit manaddaddaḻanan da, inggaw da ud duwa’n nakuḻapa mantutupak sit igid dit kaḻsa. Utdit magngoḻ da un lumaus si Jesus, nampakuy da un kanan dan, “Kaganakan Ali David, kaasiyan dikami!” ");
INSERT INTO kmk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Inggimaun dat tagu dida ot binagaan da dida un walling da. Yoong taḻona indangsoḻ da ota kinnanan un, “Kaganakan Ali David, kaasiyan dikami, Apu!” ");
INSERT INTO kmk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nan-illong si Jesus ot pinaayag na dida asina kinnanan un, “Ngadan nat piyaon yu un kook kan dikayu?” ");
INSERT INTO kmk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kinnanan da un, “Apu, piyaon mi un umila.” ");
INSERT INTO kmk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ot nadaguwan si Jesus kan dida ot inapḻusana dat ata da ot dagusa ummila da ot naitung-ud da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Adaniyon da Jesus Jerusalem ot dummatong daon sin Betfage utdin bateled Olivo. Utdi nambaun si Jesus si duwa’t dat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kanana kan dida un, “Umuna kayu utnat madoḻdoḻa boboḻoy ot dagusa awad odasan yu si naisilu’n dangki un nangubbu ot ussagan yu ta idatong yu dida kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu awad man-imus kan dikayu, kanan yu kan siya un, ‘Masapul ud Apu,’ ot dagusa ipalubus na un aḻan yu.” ");
INSERT INTO kmk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nakwa di daḻapnu matungpal dit paimbagan Apudyus sit propetana’t dit un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ibaga yu utdan tagu’d Sion un annaton nat Ali yu un dumatong. Napakumbaba kan nangabayu’t dangki. On, ubbun di dangki ud nangabayuwana.” ");
INSERT INTO kmk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Utdi, ummun-una dat duwa’n kaysan ot tinungpal da dit imbilin Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Indatong da dit dangki kan sat ubbu na. Inyap-ap da dat kagoy da utdit dangki asin Jesus nangabayuwan. ");
INSERT INTO kmk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaaduwan sidat tagu dat nangiyap-ap sidat kagoy da utdit daḻan, ot sadat udum nanggap-id da utdit sangan di kayu’n inyap-ap sit daḻan. ");
INSERT INTO kmk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ot sadat ummuna kan sadat maitungtung-ud kan Jesus, gapappakuyan dan, “Madaydayaw tun kaganakan ali David. Bindisyunan Apudyus tun imbaun na un pannakalong-ag na. Madaydayaw si Apudyus sin langit.” ");
INSERT INTO kmk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dumatong man da Jesus ud Jerusalem, nabukaḻ dat losana tagu’n kanan da un, “Ngadan ditu?” ");
INSERT INTO kmk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Siyatu si Jesus un propetan Apudyus un nanligwat Nazaret sin probinsiya’d Galilea,” insungbat dat tagu’n naibuḻun kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Utdi, nilumnok si Jesus sit timplu ot pinaḻaksun na un inamin dadit tagu’n manlaḻaku kan gumatgatanga ininggaw. Inamin na paya sinuwakkit dat lamesaan dadit mansusukat si pilak kan sadat tutuppakan dat manlaḻaku si kalupati. ");
INSERT INTO kmk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ot kinnanana kan dida un, “Naikanglit sit ugud Apudyus un, ‘Satu’n boḻoy ku, mangadanan si boḻoya luluwwaḻuwan.’ Yoong pinambalin yu un igaw di makuluk.” ");
INSERT INTO kmk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Utdi ummoy dadit nakuḻap kan da napilay kan siya’t dit timplu ot pinapiya na dida. ");
INSERT INTO kmk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yoong nakasuḻag dat aap-apun di papadi kan mimistulun di lintog sidit maila da dat nakaskasdaawa koona kan magngoḻ da dat aabenga gapappakuyan sidit timplu un kanan dan, “Madaydayaw din kaganakan David.” ");
INSERT INTO kmk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ot kinnanan da kan Jesus un, “Magngoḻ nu din ibagbagan dan aabeng?” Summungbat si Jesus un, “On, magngoḻ ku. Adiyu kad nabasa dit naikanglita ugud Apudyus un kanana’n, ‘Insuḻum dat aabeng daḻapnu ustuustu dit mandadayaw da?’ ” ");
INSERT INTO kmk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Utdi tinengyan Jesus dida ot kaysan sin Betania un siya’d inumbogana’t diya labi. ");
INSERT INTO kmk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mabigat man sidit mangulinan da ud Jerusalem, nabitil si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ot maila na man dit kayu’n igus sit igid dit daḻan ummadani ta ilana nu awad bunga na yoong naid ta abus dit tubu na ullawa. Utdi inggiyaw na dit kayu’n kanana’n, “Maidon mamungaam!” Ot dagusa naḻangu dit igus. ");
INSERT INTO kmk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ilan man dat disipulus na di, nasnasdaaw da ot kanan dan, “Inona’n dagusa naḻangu din igus?” ");
INSERT INTO kmk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kinnanan Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu un, nu awad pammati yu kan Apudyus un adi kayu manduwaduwa, bokona lawa’n kama’t din kingwak sin igus nat makwa yu nu adi mabalin yu paya ibaga’t din bateleda, ‘Umalis ka utdin baybay,’ kad makwa. ");
INSERT INTO kmk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta singngadan na mana iluwaḻu yu matungpal nu nataḻgod nat pammati yu.” ");
INSERT INTO kmk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Utdi nangulin si Jesus sit timplu. Utdit madama’n mansuḻu, inummoy dat aappun di padi kan lalallakay di Judio kan siya ot kanan da un, “Ngadan nat kalintogama mangwa’t danat kokkoom? Sin dit nangitod sit kalintogam?” ");
INSERT INTO kmk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Summungbat si Jesus un, “Antu pay imusok kan dikayu. Ot nu sungbatan yu, ibagak pay tun nanligwatan ditun kalintogaka mangwa’t datun kook. ");
INSERT INTO kmk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ibaga yu ud nu sin nanligwatan dit kalintogan Juan un mambunyag, nanligwat kan Apudyus onnu nanligwat si tagu?” Utdi nampipinnuut da pay lawan un, “Nu ibaga taku’n nanligwat kan Apudyus kanana’t oni un, ‘Apay adiyu tinuttuwa nu?’ ");
INSERT INTO kmk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yoong nu ibaga taku’n nanligwat si tagu, gakkimut dan tagu ta tuttuwaon da un propetan Apudyus si Juan.” ");
INSERT INTO kmk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Isunga sat insungbat da kan Jesus kanan da un, “Maid tigammu mi.” Ot kanan Jesus un, “Ot madik pay ibaga kan dikayu nu nanligwatan tun kalintogaka mangwa’t datuwa kook.” ");
INSERT INTO kmk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Inyabalig uman Jesus un kanana’n, “Innon nat makanan yu uttu? Ininggaw osa’n ama un duwa dat anak na. Ummoy sit pangu’n anak na ot kanana’n, ‘Anak, umoy ka mangkokwa’t din kaubasan sinsatun.’ ");
INSERT INTO kmk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Summungbat dit anaka kanana’n, ‘Madik.’ Yoong mabaybayag man, nambabawi ot ummoy nangkokwa. ");
INSERT INTO kmk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ot sadit ama, ummoy sit maikagwa’n anak na ot padana un imbaga na un umoy mangkokwa’t dit kaubasana. Ot summungbat dit anak un, ‘On ama, umoyak.’ Yoong adina inummoy. ");
INSERT INTO kmk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Singngadan na utdadit mansunud dit nanungpal sit piyaon didit ama?” kinnanan Jesus. “Sadit pangu,” kanan da. Utdi, kinnanan Jesus kan dida’n, “Tuttuwa tun ibagak kan dikayu un, sadat gumabasuḻa tagu un kama’t dan man-uuḻup si bugis kan dumadagdagasa babai, umun-una da un maidagamung sin mangiyapuwan Apudyus nu dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta ummoy si Juan un Mambubunyag un nangitudtudu kan dikayu’t dit kustu’n maunud yoong adiyu tinuttuwa. Yoong sadat man-uuḻup si bugis kan dumadagdagasa babai, tinuttuwa da. Ulay nu innila yu dida’n nambabawi’t dat basuḻ da, adi kayu kampay nambabawi kan nanuttuwa.” ");
INSERT INTO kmk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Dongḻon yu payyan tun osa’n abalig,” kinnanan Jesus. “Inggaw osa’n tagu’n minuḻ-ana’t ubas dit pita na. Tinalangkaana’n nilikmut ot nangabut si batu ut poposposan di ubas kan nanuud si nataknanga alligang di man-andog. Utdi impatobaw na dit kaubasana ot nangaḻyug si sabali’n ili. ");
INSERT INTO kmk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Dandani man dit bubuḻḻasan di ubas, imbaun na dat baba-unona un umoy mangaḻa’t dit gogwa na. ");
INSERT INTO kmk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dumatong da man dinokmaan dat mantotobaw dida, pinangpang-ok da dit osa, pinatoy da dit osa asida binatubatu dit osa. ");
INSERT INTO kmk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Utdi nangibaun uman dit singkuwa’t dit pita si ad-adu nu sadat damu’n inummoy ot padana uman dit kingwan dat mantotobaw kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Utdiyon, imbaun na dit anak na ta kanana’t dit somsomok na un, ‘Ikabain da tu ta anak ku.’ ");
INSERT INTO kmk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Yoong ilan man dat mantotobaw dit anak, kanan da un, ‘Siyatu dit manawid situn pita, aweyu ta patoyon taku daḻapnu mangkuwa taku tun pita!’ ");
INSERT INTO kmk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Utdi, dinokmaan da un inlaksun sit lasin didit kaubasan asida pinatoy. ");
INSERT INTO kmk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Kadon, nu dumatong dit singkuwa’t dit pita, sin dit koona’t dadiya man-aayyuwan?” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Insungbat da un, “Maid duwaduwa na un patoyona dadiya nadadag. Asina ipaayyuwan dit kaubasana utdat udum un mangitod sit gogwa na nu dumatong dit bubuḻḻasan.” ");
INSERT INTO kmk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Utdi, kinnanan Jesus kan dida un, “Adiyu kad payyan nabasa dit naikanglita ugud Apudyus? Kanana un, ‘Sadit batu’n inidsan dat mangkokokwa’t boḻoy, siya’d nambalina pannan dit sikun dit boḻoy. Siya’d kingwan Apudyus ot taḻona nakaskasdaawa maila.’ ");
INSERT INTO kmk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Isunga ibagak kan dikayu un makaan dit gundaway yu un maidagamung sin mangiyapuwana ta maitod sidan tagu’n mangwa’t dit ipakwana. ");
INSERT INTO kmk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ot singngadan na mana maotdag situwa batu masipsip-uk ot singngadan na mana tup-ugan dituwa batu matumotumok.” ");
INSERT INTO kmk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dongḻon man dadit aap-apun di papadi kan Fariseo dat abalig Jesus, naawatan da un dida dit ug-ugudona. ");
INSERT INTO kmk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ot piyaon da un dopapon yoong ummogyat da utdat adu’n tagu gaputa tuttuwaon da un propetan Apudyus si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nan-abalig payyan si Jesus sidat aappun di Judio un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“San mangiyapuwan Apudyus maiyalig sit osa’n ali un nampaboda’t dit anak na un laḻaki. ");
INSERT INTO kmk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Utdit nakasaganaon dat losan, imbaun na dadit baba-unona’n umoy mangibaga’t dat naawis sit boda ta dumatong daon, yoong madi da umoy. ");
INSERT INTO kmk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Utdi nangibaun uman sidat uduma baba-unona un kanana’n, ‘Ibaga yu utdat naawis ta dumatong daona makaboda ta naisaganaon tun makan. Napaltiyon dan napaḻungpu’n baka ot losana naisaganaon tun kakigad na.’ ");
INSERT INTO kmk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Yoong adin dat naawis inaw-awingan dida ta ida nan-ipapuut pay lawan sidadit umoyan da. Awad ummoy sit payaw, awad ummoy sit nigusiyu na. ");
INSERT INTO kmk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ot sadat udum, dinokmaan da dat naibaun ot pinalpaligat da dida asida pinatoy dida. ");
INSERT INTO kmk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nasuḻasuḻag dit ali utdit dongḻona dit naipasamak ot imbaun na dat suldadu’n ummoy namatoy sidat kummatoy kan singgob da dit boboḻoy da. ");
INSERT INTO kmk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Utdiyon, inayagana dadit baba-unona’n kanana’n, ‘Ammina naisaganaon tun kokwan ditun boda yoong adida maibagaya maidagamung situn boda dadit naawis. ");
INSERT INTO kmk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Isunga umoy kayu’t dan kaḻkaḻsa ta awison yu dan losana dakngon yu.’ ");
INSERT INTO kmk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Utdi, kaysan dadit baba-unon ot inawis da un losan dat dintong da, nabaḻu man onnu nadadag si ugali ot napnu dit boboddaan sidat inawis da. ");
INSERT INTO kmk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Yoong umoy man dit ali ilan dadit naawis, inggaw naila na un osa un adi nansukat si badut di umoy makaboda. ");
INSERT INTO kmk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ot kinnanana’n, ‘Sunud, innon nat nan-oooy nu uttu un adika nambadut si badut di umoy makaboda?’ Yoong adina nakaginga. ");
INSERT INTO kmk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Utdiyon imbagan dit ali utdat baba-unona un, ‘Pingilon yu nat ima na kan iki na ta idawat yu utdin nakoḻopa igaw, ta siya’d man-ibilana kan mangngilotana.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ot inyanungus Jesus un kanana’n, “Adu dan naawis yoong akit dan napili un maidagamung sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Utdiyon kaysan dadit Fariseo ta umoy da tutulagon nu innon dit man-iimus da kan Jesus daḻapnu awad mangidaḻuman da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ot nangibaun da utdat buyut da kan dat buyut Ali Herodes si umoy kan Jesus. Ot kanan da kan siya un, “Mistulu, tigammu mi un adika mantulituli. Itudtudum pay nat katuttuwaana maipanggop sidan piyaon Apudyus ipakwa. Ot adim mandudumaon dan tagu ta adim ibilbilang dan saad da. ");
INSERT INTO kmk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ot ibagam ud nu sinnat kasomsomkam situ. Naingkalintogan kad un mambayad taku’n Judio si bugis kan Caesar un emperador ud Roma onnu adina?” ");
INSERT INTO kmk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yoong titiggammun Jesus un laweng dit panggop da ot imbaga na un, “Dikayu’n man-ag-agin, apay padpadasonak? ");
INSERT INTO kmk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipaila yu ud kan sakon dit pilaka maibugis!” Ot nangidatong da si denario. ");
INSERT INTO kmk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Inimus na kan dida un, “Sinmuging kan singngadan situn naimalka?” ");
INSERT INTO kmk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Si Emperador Caesar,” insungbat da. “Ot nu siya nat,” insungbat Jesus, “itdon yu kan Caesar nat kuwan Caesar ot itdon yu pay kan Apudyus nat kuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dongḻon da man di, nasdaaw da ot kaysan da. ");
INSERT INTO kmk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Utdi payona aḻ-aḻgaw, inggaw da ud Saduceo un inummoy kan Jesus. Sadatu dat Judio un manguguda maid umungaḻ si natoy. ");
INSERT INTO kmk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Inimus da kan Jesus un, “Mistulu, kanan dit lintoga ingkanglit Moses un, ‘Nu mangasawa nat osa’n laḻaki ta matoy un naid anak na, masapula asaw-on dit sunud na dit bilug daḻapnu man-anak da si kama’t anak didit natoy.’ ");
INSERT INTO kmk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ininggaw da ud pitu’n mansusunuda laḻaki utdit. Nangasawa dit pangu yoong natoya naid anak na. Utdi, inasawan dit maikagwa’n sunud na dit bilug. ");
INSERT INTO kmk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Padana un natoya naid uman anak na. Ot padana payon dit naipasamak sidit maikatlu inggana’t dit maikapitu un naamin da un natoya maid ingganak da utdit bilug. ");
INSERT INTO kmk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Utdit naamin da un natoy dat pitu’n mansusunud, natoy pay dit bilug. ");
INSERT INTO kmk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ot nu timpu’n umungaḻ dat natoy, singngadanon dit sin-asawa’t diya bilug kan dida’n pitu’n mansusunud? Ta losan da un nangasawa kan siya?” ");
INSERT INTO kmk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Summungbat si Jesus un, “Bokon nat kuwa yu un somsomok gaputa adiyu maawatan dit naikanglita ugud Apudyus kan naid tigammu yu utdit pannakabalin na. ");
INSERT INTO kmk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nu umungaḻ dat natoy maid man-aassawa kan dida ta kama da utdan aanghel sidin langit. ");
INSERT INTO kmk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kan osa pay nu maipanggop sit umungaḻan dat natoy, adiyu kad nabasa dit imbagan Apudyus kan dikayu utdit ugud na? ");
INSERT INTO kmk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kanana un, ‘Sakon ud Apudyus un mandaydayawan da Abraham, Isaac kan Jacob.’ Piyaona’n ugudon un si Apudyus bokona Apudyus dat natoy nu adi sadan matatagu.” ");
INSERT INTO kmk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Utdit magngoḻan dat tagu dit intudtudu na, nasnasdaaw da. ");
INSERT INTO kmk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dongḻon man dat Fariseo un gummiginnokon dat Saduceo ta naidan dat maibaga kan Jesus, nandatdatong da utdit ininggawan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Utdi, osa kan dida ud mistulun di lintog ud nan-imus kan siya si mamadpadas na un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mistulu, singngadan dit kapopotgana bilin sidat lintog Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Summungbat si Jesus un, “‘Masapula iyossaan nu nat losana aangsom kan losana somsomok nu un mamippiya kan Apudyus un Apum.’ ");
INSERT INTO kmk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Siyatu’d kapotgan kan umuna un bilin Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ot sat maikagwa, padana pay sin ummuna ta kanana’n, ‘Masapula piyaom dan padama tagu un kama’t nat mampipiyam sinat long-ag nu.’ ");
INSERT INTO kmk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sadatu un duwa’n bilin dat naibasalan dat losana lintog Moses kan sadat ingkanglit dat propetan Apudyus sidit.” ");
INSERT INTO kmk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Inggaw payyan dat Fariseo un naamung ot inimus Jesus kan dida un, ");
INSERT INTO kmk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sinnat makanan yu maipanggop sit Kristu? Sin ganak kan siya?” “Kaganakan dit David,” kinnanan da. ");
INSERT INTO kmk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ot insungbat pay Jesus un, “Nu tuttuwa di, apay un inayagan David si ‘Apu’ dit Kristu? Ta impasomsomok ud Ispiritu Santu dit kinnanan David un, ");
INSERT INTO kmk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Imbagan Apudyus kan Apuk un: Mantupak ka uttun kapon madiwanak inggana’t abakok aminon dat kabusuḻ nu.’ ");
INSERT INTO kmk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ot nu ‘Apu,’ kanan David kan Kristu, innona’n kaganakana nu?” ");
INSERT INTO kmk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Utdi naid nakasungbat kan dida ot manipud sidiyon, naidon ummoy nan-imuimus kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Utdi imbagan Jesus sidat tagu padana pay sidat disipulus na un, ");
INSERT INTO kmk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Awad kalintogan dat mimistulun di lintog kan Fariseo un mangilawlawag sidat lintog Moses. ");
INSERT INTO kmk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Isunga masapula tungpaḻon yu dat losana isuḻu da. Yoong adiyu padaon din koon da ta adida unudon dit itudtudu da. ");
INSERT INTO kmk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Adu dan bilina ipatungpal da un kama dat mampabukud si nadagsona awit un naligata maawit yoong adida un taḻon sumaḻak. ");
INSERT INTO kmk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Losana koon da, koon da ullawa daḻapnu ilan dan tagu. Siya’d gapuna’n dakoḻon da dit iiggaan di papela naikanglitan dit Ugud Apudyus un maitakod sit kiday da kan takḻay da ot padana pay un ipaandu da dit malaymay dit lagayadan dit badut da. ");
INSERT INTO kmk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ot pipiyaon da dit inggaw sit inggawan dat nangangatu’n tagu nu amung kan pipiyaon da dit mantupak sit sangu utdin sinagoga. ");
INSERT INTO kmk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pipiyaon da pay nu dayawon dat tagu dida nu umoy da utdan aabtan di tagu kan piyaon da pay nu ngadanon da dida ut ‘Mistulu.’ ");
INSERT INTO kmk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yoong nu dikayu, adiyu paawag nat long-ag yu un ‘Mistulu’ ta mansusunud kayu ot ossaanaka lawa’n mistulu yu. ");
INSERT INTO kmk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ot adiyu pay awagan si ‘Ama’ nat singngadan na mana tagu’t tun pita ta os-ossaana lawa’d Ama yu un siya si Apudyus ud langit. ");
INSERT INTO kmk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Adiyu pay paawag nat long-ag yu si ‘Apu’ ta sakona Kristu ullawa’d Apu yu. ");
INSERT INTO kmk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ot sat kangattuwan kan dikayu masapula siya’d manselbi. ");
INSERT INTO kmk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta singngadan na mana mangipangatu’t long-ag na maidoba yoong singngadan na mana mampakumbaba, maipangatu nu timpu na.” ");
INSERT INTO kmk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kaasi kayu paya mimistulun di lintog kan Fariseo ta man-ag-agin mamati kayu. Omban yu dit sawanga umoy sin mangiyapuwan Apudyus. Ulay dikayu adi kayu lumnok ot sondan yu dat mamiya un lumnok. ");
INSERT INTO kmk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kaasi kayu paya mimistulun di lintog kan Fariseo. Dikayu un man-ag-agin mamati. Gundawayan yu dat bilug ot aminon yu un aḻan dat sanikuwa da asiyu anduanduwon dat luwaḻu yu un mampalingodan yu utdat kokkoon yu. Siya’d gapuna’n nadagdagson nat dusa yu un itdon Apudyus! ");
INSERT INTO kmk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kaasi kayu’n mimistulun di lintog kan Fariseo. Dikayu un man-ag-agin mamati. Doḻmangon yu nat baybaya umoy si uduma boboḻoya man-awis si ulay osa ullawa si maibuyut kan dikayu ot nu awad maawis yu, mambalinon yu un nadaddadag nu dikayu un buḻun na un madusa’t din impiyelnu. ");
INSERT INTO kmk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kaasi kayu ta kama kayu’t nakuḻapa mangipuppuyut. Ta itudtudu yu un nu awad tagu un usalona din timplu un mansapata, naid basuḻ na nu adina tungpaḻon dit insapata na. Yoong nu usalona’n mansapata din buḻawan sin timplu, masapula tungpaḻona dit sapata na. ");
INSERT INTO kmk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tuttuwa’n nakuḻap kayu kan natung-ug kayu ta bokobokon nat somsomok yu. Ngadan kad nat napotpotog, sat buḻawan onnu sadit timplu un mampasantu utdit buḻawan? ");
INSERT INTO kmk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Itudtudu yu paya nu awad tagu’n usalona din altar nu mansapata, naid basuḻ na nu adina tungpaḻon dit sapata na. Yoong nu sat datun sin altar dit usalona’n mansapata masapula tungpaḻona dit sapata na. ");
INSERT INTO kmk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tuttuwa’n nakuḻap kayu. Ngad kad nat napotpotog, sat datun onnu sat altar un mampasantu utdit datun? ");
INSERT INTO kmk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isunga sat mangusal sin altar un mansapatana, isalisapata na un losan dat datun un awad sidi. ");
INSERT INTO kmk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ot sat mangusal sit timplu un mansapatana, isalisapata na pay si Apudyus un inggaw sidi. ");
INSERT INTO kmk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ot nu awad pay mangusal sin langit un mansapata isalisapata na pay dit tronon Apudyus kan si Apudyus un mantutupak sit trono. ");
INSERT INTO kmk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kaasi kayu’n mimistulun di lintog kan Fariseo ta man-ag-agin mamati kayu. Ta itdon yu kan Apudyus dit ingkapuḻu utdan apit yu un mampabangu’t tipoy, yoong niliwayan yu dan napotpotoga pakwan di lintog un kama’t dan mangwaan yu utdan nalintog, mangkaasiyan yu utdan udum kan manungpaḻan yu utdan losana ibaga yu. Siyadatu dan lumbonga tungpaḻon yu un adiyu pay liwayan dan uduma pakwan di lintog. ");
INSERT INTO kmk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dikayu un nakuḻapa mangipuppuyut. Kama kayu’t tagu’n mamadapad si ilok sit inumona yoong nilumtun na ud kamelyu. ");
INSERT INTO kmk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kaasi kayu’n mimistulun di lintog kan Fariseo, dikayu un man-ag-agin. Ta kama kayu’t tagu’n kiwasana ullawa dat lasin dat tasa kan da pinggan. Ta buḻubuḻuwan yu dat ima yu yoong sat aangson yu napnu’t kinaagum kan kinagamgam. ");
INSERT INTO kmk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Dikayu’n nakuḻapa Fariseo! Masapula kiwasan yu yana umuna nat daḻom nat tasa kan pinggan kad nadaḻus pay din nakinlasin. ");
INSERT INTO kmk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kaasi kayu’n mimistulun di lintog kan Fariseo un man-ag-agin. Kama kayu’t lobona napintulan si pukaw. Napiya din ila na utdin lasin, yoong napnu’t tung-aḻ di ladag kan losana ilan di isaw dit daḻom na. ");
INSERT INTO kmk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ot padana pay kan dikayu ta ipappaila yu un kama kayu’t nalintoga tagu utdan udum yoong sat katuttuwaana napnu nat aangson yu si kinaman-ag-agin kan kinadadag.” ");
INSERT INTO kmk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kaasi kayu’n mimistulun di lintog kan Fariseo un man-ag-agin mamati. Ta pabaḻuwon yu dat lobon dat propetan Apudyus sidit kan al-altiyan yu pay dat lobon dat nalintog si nantatagu. ");
INSERT INTO kmk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Asiyu kanan un, ‘Nu natagu kami okyan sidit timpun dadit inapu mi, adimi kingwa dit kingwa da un namatoy sidadit propetan Apudyus.’ ");
INSERT INTO kmk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sanata kanan yu, ipaila yu un kaganakan dikayu’t dat namatoy sidat propetan Apudyus sidit. ");
INSERT INTO kmk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ot gangputon yu dit inlugin dat inapu yu! ");
INSERT INTO kmk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dikayu’n nadadaga tagu’n kaganakan di uḻog! Inon yu un malisiyan din madusaan yu utdin impiyelnu? ");
INSERT INTO kmk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Isunga mangibaunak kan dikayu si propetan Apudyus kan nangkakalainga tagu kan mimistulun di ugud Apudyus. Patoyon yu dat udum kan dida, ilansa yu dat udum si kulus, sabisabidan yu dat udum sidat sinagoga yu kan unudon yu dida’n paligaton sit kailin-ili un manaḻnan da. ");
INSERT INTO kmk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Isunga madusa kayu maipagapu’t dit natoyan dat losana nalintoga tagu’t tun pita. Mailugi utdit napatoyan Abel inggana kan Zacarias un anak ud Barakias un napatoy sit nambootan dit nasantuwana igaw kan altar. ");
INSERT INTO kmk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tuttuwa tun ibagak kan dikayu un sat dusan dat losana namatoy sidatu, sagapaḻon dan tagu’t tun satuna lonap.” ");
INSERT INTO kmk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Utdi imbagan Jesus un, “Inay kayu paya iJerusalem! Ta pinatoy yu dat propetan Apudyus kan binatubatu yu dat imbaun na un mantudtudu kan dikayu. Namimpiga un piyaoka dagupona ayyuwanan dikayu’n padan din manalikopkopan din manuk sidan siyop na, yoong ummadi yu. ");
INSERT INTO kmk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ot sinsatunon ipatungad dikayuwon kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ot ibagak kan dikayu un, maidon ilan yu kan sakon inggana’t din timpu’n mangibagaan yu un, ‘Binindisyunan Apudyus tun dummatonga imbaun na.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tinengyan da Jesus dit timplu ot makaadayu da man si akit, ummadani dat disipulus na kan siya ot impaila da kan siya dit kinabaḻun didit timplu kan sadat uduma natuud sit lakub na. ");
INSERT INTO kmk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yoong kinnanan Jesus un, “On, maila yu datun nabaḻbaḻu un natuud sinsatun yoong tuttuwa tun ibagak kan dikayu un dumtong nat timpu’n maid osa’t batu si natuuga adi maidugpu.” ");
INSERT INTO kmk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mantutupak si Jesus sin bateled Olivo utdit ummoy dat disipulus na kan siya ot inimus da un, “Apu, ibagam ud nu kapiga dit maipasamakan dit imbagam kanad, kan singngadan dit mangilasinan mi un dandaniyon dit mangulinam kan manganungusan tun lubung?” ");
INSERT INTO kmk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Summungbat si Jesus un, “Man-alimban kayu ta adi kayu maal-allilaw. ");
INSERT INTO kmk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta adun dumatonga tagu un mangusal situn ngadan ku un kanan dan, ‘Sakon dit Kristu,’ ot adu dat maallilaw da. ");
INSERT INTO kmk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Magngoḻ yu dat kankannibung di gubat sinat adani kan damag di gubat sin adayu, yoong adi kayu madanagan ta masapula maipasamak da. Yoong bokon payyana anungus ditun lubung. ");
INSERT INTO kmk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta manggugubat dan kailin-ili’t tun lubung kan mambibinnusuḻ dan tutulay. Awad pay uḻat kan lunig sin nadumaduma’n igaw. ");
INSERT INTO kmk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Luglugi na ullawa datu un paligata padan dit manlogawan di man-abeng. ");
INSERT INTO kmk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Utdiya timpu, dopapon dikayu daḻapnu paligaton kan patoyon dikayu. Lawengon dikayu’t dan losana tagu gapu’t nat manuttuwaan yu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Utdiya timpu adu dat lumipsuta manuttuwa ot mansisinnipsip kan manlilinnaweng da. ");
INSERT INTO kmk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kadon adu’n lumtawa man-ag-agin propetan Apudyus ot adu’n maallilawa tagu. ");
INSERT INTO kmk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ot gapu’t dit kinaadun di kinadadaga lumtaw, umakit dit mampipiyan di kaaduwana tagu. ");
INSERT INTO kmk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yoong singngadan na mana adi lumipsuta manuttuwa kan sakon inggana’t anungus na, taguwon Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ot satun Nabaḻu’n Damag maipanggop sin mangiyapuwan Apudyus, maiwalagawag sidat kailin-ili’t tun lubung daḻapnu magngoḻan di kataguntagu. Kad nu magangput diyon, siya’d anungus ditun lubungon.” ");
INSERT INTO kmk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nu maila yuwon dit impadtun Daniel sidit un gaoogyata yumam-an un umoy sumikad sin timplu un nasantuwana igaw, (sadit mamasa’t tuwa padtu masapula maawatana) ");
INSERT INTO kmk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","masapula dikayu’n iJudea gumtik kayuwon sidan batbateled. ");
INSERT INTO kmk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ot sat tagu’n awad sidit otop dit boḻoy na, adinaon lumnoka umoy mangaḻa’t dat kokokwa na utdit boḻoy. ");
INSERT INTO kmk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ot sat tagu’n inggaw sit pappayaw, masapula adinaon mangulina umoy mangaḻa’t kagoy na. ");
INSERT INTO kmk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Taḻona kawas diya timpu utdat nabugi kan sadat mantagtagibi! ");
INSERT INTO kmk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ot iluwaḻu yu kan Apudyus ta adina maiyaspuḻ nat gumtikan yu si ageled onnu aḻ-aḻgawa iillongan. ");
INSERT INTO kmk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta amoamod dit ligat sidiya timpu un maid maipadaana’t dat ligata napalabas manlugi’t dit nakwaan ditun lubung inggana’t tun satun. Maida taḻon maipadaana’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ot nu adin Apudyus inyaboba dit bilang dit aḻ-aḻgaw didiya ligat maid matagu’t tagu uttun lubung yoong maipagapu’t dan pinili na un tagu na, inyaboba na. ");
INSERT INTO kmk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Utdiya timpu, nu awad mangibaga un, ‘Antu uttu dit Kristu,’ onnu kanan da un, ‘Andi utdi,’ adiyu tuttuwaon. ");
INSERT INTO kmk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta adu dat mangabaw un dida dit Kristu, kan man-ag-agin da un propetan Apudyus. Ot mangipaila da si nakaskasdaaw daḻapnu nu mabalbalin allilawon da pati utdat pinilin Apudyus un tagu na. ");
INSERT INTO kmk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Adiyu liuwan! Idaadaan kuwon ibaga datu kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Isunga, nu awad mangibaga kan dikayu un, ‘Ikayu ilan ta andi dit Kristu utdin igawa maid tagtagguwan,’ adi kayu umoy. Nu kanan da un, ‘Andi’t din kuwaltu!’ adiyu tuttuwaon. ");
INSERT INTO kmk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta nu dumatongaka Inyanak di Tagu, mailan losan din nangkalliput un kama’t din kilat nu dumelang. ");
INSERT INTO kmk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Padana un sat kawadan di ladag, siya’d madatdatngan dat tuḻayan.” ");
INSERT INTO kmk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nu maabus dadiyona manligatan sidiya timpu, dagusa kumḻop din init ot san buḻan adinaon sumoḻag. Maotdag dan bituwon ot maligaligad dan losana awad sin langit. ");
INSERT INTO kmk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Utdiyon, maila’t din langit dit mangilasinan un dumatongakon un Inyanak di Tagu ot losan dat nadumaduma un tagu’t tun pita mampaibil da. Ta ilan da ud sakona Inyanak di Tagu un mailabaw sit bunot un dumoba’n napnu’t pannakabalin kan nakaskasdaawa kinangatu. ");
INSERT INTO kmk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Guminga dit tangguyub si natobag ot ibaun ku dadit aanghel ku uttun kasulisulin ditun lubung daḻap umoy da dagupon dadit losana pinilin Apudyus un tagu na.” ");
INSERT INTO kmk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ilan yu din kayu’n igus ta man-adaḻan yu,” kinnanan Jesus. “Ta nu manlugi’n sumungbud, tigammu yuwona dandani nat iinnitan. ");
INSERT INTO kmk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Padana pay un nu maila yu dadiya imbagaka mapasamak, tigammu yuwona dandani’n mangulinak. ");
INSERT INTO kmk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ot tuttuwa tun ibagaka mapasamak un losan datu sin daan payyan un matoy dan losana tagu uttuwa lonap. ");
INSERT INTO kmk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mangkigad dan losana maila’d langit kan situn pita yoong mannanayun tun ugud ku.” ");
INSERT INTO kmk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Maida taḻon makatigammu’t dit aḻ-aḻgaw onnu olas un makwaan dat losana imbagak. Ulay dan aanghel sin langit onnu sakona Anak Apudyus ta si Ama ullawa’d manigammu. ");
INSERT INTO kmk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nu mangulinaka Inyanak di Tagu, maipada dit kokkoon dat tagu’t dit timpun Noe dat kokkoon dat tagu’n dakngak. ");
INSERT INTO kmk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta utdita timpu’n daan payyan un nalitap tun lubung, ginan-ganas dat tagu’n nanganangan kan da nan-iinum kan nan-aassawa inggana’t nilumnok da Noe utdit dakoḻana bapul. ");
INSERT INTO kmk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Maid somsomok dat tagu’t dit maipasamak inggana’t nanlitap ot naamin da un naḻmos. Ot siya’d padana nu dumatongaka Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Utdiya timpu, nu awad da ud duwa’n laḻaki’n mangkokwa’t din payaw, maaḻa dit osa, matengyan dit osa. ");
INSERT INTO kmk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nu awad da ud duwa’n babai’n manggiling, maaḻa dit osa, matengyan dit osa. ");
INSERT INTO kmk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Siya’d gapuna’n mansasaggana kayu ta adiyu tigammu nu ngadan na un timpu nat dumakngaka Apu yu. ");
INSERT INTO kmk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sosomkon yu tu! Nu tigammun dit singkuwa’t dit boḻoy dit olasa dumakngan dit man-aakaw si labi, adina masuyop ta man-andog daḻapnu adina makaḻnok dit man-aakaw sit boḻoy. ");
INSERT INTO kmk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Isunga masapula mansasaggana kayu pay ta sakona Inyanak di Tagu, dumatongak sit timpu’n adiyu namnam-on.” ");
INSERT INTO kmk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Singngadan din mataḻgodan kan nalainga baba-unon? Siya dit mangipaayyuwanan dit apu na utdat padana un baba-unon daḻapnu itdana dida’t kanon da nu kustu’n timpu na. ");
INSERT INTO kmk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nagasat diya baba-unon nu dakngon dit apu na un manungtungpal sida’t kewaaḻ na. ");
INSERT INTO kmk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tuttuwa tun ibagak kan dikayu’n, siya’d mangitaḻgodan dit apu na utdat losana kukuwa na. ");
INSERT INTO kmk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yoong nu laweng diya baba-unon kanana’t dit somsomok na un, ‘Bokona masapa dit apuka mangulin,’ ");
INSERT INTO kmk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ot lugiyana un mandataḻ sidat padana’n baba-unon kan umoy makakan kan maka-inum sidat gumubuuk. ");
INSERT INTO kmk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Utdiyon, dumatong dit apu na utdit aḻ-aḻgaw kan olasa adina nanam-ona dumatongana. ");
INSERT INTO kmk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ot dusaon dit apu na kan idogana utdat man-ag-agin sit igawa mandusaana kan dida un siya’d man-ibilan kan mangngilotan da.” ");
INSERT INTO kmk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nu dumtong dit timpu’n mangulinak, kama’t tu din maiyaligan din mangiyapuwan Apudyus. Inggaw da ud simpuḻu’n bababbaḻasanga nangaḻa’t silaw un ummoy ummabat sit laḻaki’n mangasawa. ");
INSERT INTO kmk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sadat lima, natung-ug da ot sadat lima nasilib da. ");
INSERT INTO kmk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sadat tung-ug, nangaḻa da si silaw da yoong adida nangaḻa’t igasa usalon da nu maaminan da. ");
INSERT INTO kmk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ot sadat nasilib, nangaḻa da si silaw da kan igas un usalon da nu maaminan da. ");
INSERT INTO kmk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Gaputa maid dummatodatong sidit laḻaki’n mangasawa, nakasuyop da. ");
INSERT INTO kmk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Yoong gawan labi man, inggaw nampakuya kanana’n, ‘Annaton dit laḻaki’n mangasawa! Ikayu abaton!’ ");
INSERT INTO kmk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ot nabalikusu dat simpuḻu’n bababbaḻasang ot insagana da dat silaw da. ");
INSERT INTO kmk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yoong sadat lima’n tung-ug kanan da utdadit lima’n nasilib un, ‘Itdan dikami pay sinat igas yu ta naaminon tun igas mi ot maksopon tun silaw mi.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Yoong kinnanan pay dat lima’n nasiliba bababbaḻasang un, ‘Adina nin umanay ot ikayu pay lawan gumatang sin laḻakkuwan.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Malikmud da mana umoy gumatang si igas, dummatongon dit laḻaki’n mangasawa. Ot sadat nakasagana’n nanakom, naibuḻun daon kan siya’n nilumnok sit boboddaan ot naombanon dit sooban. ");
INSERT INTO kmk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Adina masulit, dummatong pay dat lima’n ummoy gummatang si igas ot kanan dan nampakuy un, ‘Apu, paḻnokon dikami pay!’ ");
INSERT INTO kmk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Yoong, summungbat dit laḻaki’n mangasawa’n kanana’n, ‘Adina mabalin ta sat katuttuwaana maid tigtigammuk kan dikayu.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Utdi, inyanungus Jesus un, “Siyadi dit gapuna’n masapula nasasaggana kayu ta maid tigammu yu utnat aḻ-aḻgaw onnu olasa mangulinak.” ");
INSERT INTO kmk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Intuluy Jesus un kanana’n, “Maiyalig pay din mangiyapuwan Apudyus si osa’n tagu’n manlakkalakkata mangaḻyug. Inayagana dat baba-unona daḻapnu itaḻgod na kan dida dat losana sanikuwa na. ");
INSERT INTO kmk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Initdana dida’t pilaka inigusyu da sigun sit kabooḻan da. Sadit osa initdana si lima’n libu, duwa’n libu utdit maikagwa ot sillibu utdit maikatḻu. Asinaon kaysan. ");
INSERT INTO kmk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Utdiyon sadit naitdan si lima’n libu, dagusa innigusyu na ot nangganansiya si lima’n libu. ");
INSERT INTO kmk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Padana pay sit naitdan si duwa’n libu ta ummoy na pay innigusyu ot nakaganansiya pay si duwa’n libu. ");
INSERT INTO kmk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yoong sadit naitdan si sillibu, ummoy na ingkuḻub dit pilak dit apu na. ");
INSERT INTO kmk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mabayabayag man, nangulin dit apu da ot insingil na kan dida dit pilaka intaḻgod na. ");
INSERT INTO kmk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Utdi, ummoy dit naitdan si lima’n libu ot kanana’t dit apu na un, ‘Apu, lima’n libu dit intod nu kan sakon ot antu’d lima’n libu un naganansiyak!’ ");
INSERT INTO kmk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ot kinnanan dit apu un, ‘Nabaḻu nat kingwam. Nabaḻu ka kan mataḻgodan ka un baba-unon. Ot gaputa mataḻgodan ka utdan kaakita naitod kan sika, mampaayyuwanok sika’t adu. Awenu ta makapanlagsak ka kan sakon!’ ");
INSERT INTO kmk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Padana un ummoy pay dit naitdan si duwa’n libu ot kanana’n, ‘Apu, initdanak si duwa’n libu ot antu’d duwa’n libu un naganansiyak.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ot kinnanan dit apu un, ‘Nabaḻu nat kingwam. Nabaḻu ka kan mataḻgodan ka un baba-unon. Ot gaputa mataḻgodan ka utdan kaakita naitod kan sika, mampaayyuwanok sika’t adu. Awenu ta makapanlagsak ka kan sakon!’ ");
INSERT INTO kmk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Utdi, ummoy pay dit naitdan si sillibu un kanana’n, ‘Apu, tigammuka nasuḻag ka un tagu ta mambuḻas ka utdan bokona immuḻam kan aniyom danat bokona inloop nu. ");
INSERT INTO kmk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kumimutak kan sika ot siya’d gapuna’n ummoyak ingkuḻub dit pilaka intod nu. Ot antu un iyulin ku.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ot kinnanan dit apu na un, ‘Laweng ka un baba-unon! Sadut! Titiggammum un mambuḻasak sidan bokona immuḻak kan aniyok dan bokona inloop ku, ");
INSERT INTO kmk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ot apay adim imbangku dit pilak ku daḻapnu mangulinak kad, iyulin nu dit pilak ku un awad ganansiya na?’ ");
INSERT INTO kmk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Utdi imbagana’t dat uduma baba-unona un, ‘Aḻan yu nat pilak kan siya ta itdon yu utdit kawadan dit simpuḻu’n libu. ");
INSERT INTO kmk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta ad-adu nat maitod sinat mataḻgodan ot masawasawaḻ dat awad kan siya. Yoong sat tagu’n adi mataḻgodan, ulay sat akita awad kan siya masimud un maaḻa. ");
INSERT INTO kmk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ot satun naid si selbi’n baba-unon, idawat yu utdin kakoḻpan un siya’d man-ibilana kan mangngilotana.’” ");
INSERT INTO kmk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Intuluy Jesus un, “Nu dumatongaka Inyanak di Tagu, maila dit nakaskasdaawa kinangatuk kan buḻun ku dan losana aanghel ot mantupakak sit trono un man-ali. ");
INSERT INTO kmk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ot mandatdatong dat losana tagu’t tun pita utdit atubang ku. Ot mansisinaok dida’n padan dit koon dit man-aayyuwan si kannelu un isina na dida utdat kalding. ");
INSERT INTO kmk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Manaḻnok dat nalintoga tagu’t dit kapon madiwanan ku kan manaḻnok dat nadadag sit kapon makawigik. ");
INSERT INTO kmk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kadon sakona Ali ibagak sidat inggaw sit kapon diwanan ku un, ‘Awe yu, dikayu’n binindisyunan Amak ta maidagamung kayu’t din mangiyapuwana un insagana na un tawid yu manipud sit nakwaan ditun lubung. ");
INSERT INTO kmk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta nabitilak ot pinakananak. Nauwawak ot pinainumanak. Kakkailiyak ot pinaḻnokak sidat boḻoy yu. ");
INSERT INTO kmk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naid pay badut ku ot binadutanak. Nasakitak ot inandoganak. Naibaḻudak ot ummoy yu ud sakon biniling.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sumungbat dat nalitoga tagu un, ‘Apu, kapiga nat nangil-an mi kan sika’n nabitil ot pinakanan mi onnu nauwawa pinainuman mi? ");
INSERT INTO kmk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kapiga nat nangil-an mi un kakkaili ka ot pinaḻnok mi onnu naid badut nu un binadutan mi? ");
INSERT INTO kmk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kapiga nat nasakitama inandogan mi kan nabaḻudama ummoy mi ud sika biniling?’ ");
INSERT INTO kmk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ot sakona Ali sumungbatak un, ‘Tuttuwa tun ibagak kan dikayu un, nu kingwa yu datu si osa’t datuwa kadodobaana susunud ku, kingwa yu payon kan sakon!’ ");
INSERT INTO kmk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Utdi ibagak sidat inggaw sit kapon kawigik un, ‘Umadayu kayu kan sakon, dikayu un nakodngana madusa. Ingkayu’t din apuya adi maksopa naisagana’n inggawan Satanas kan sadat aanghel na. ");
INSERT INTO kmk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta nabitilak yoong adiyanak pinakanan. Nauwawak yoong adiyanak pinainuman. ");
INSERT INTO kmk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kakkailiyak yoong adiyanak pinaḻnok. Naid badut ku yoong adiyanak binadutan. Nasakitak kan naibaḻudak yoong adiyanak ummoy biniling.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ot sumungbat da un, ‘Kapiga Apu, nat nangil-an mi kan sika’n nabitil, nauwaw, kakkaili onnu naid si badut onnu nasakit onnu naibaḻuda adimi ummoy tinuḻungan sika?’ ");
INSERT INTO kmk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ot sumungbatak kan dida un, ‘Tuttuwa tun ibagak kan dikayu’n nu adiyu tinuḻungan ud osa’t dat kadodobaana susunud ku, adiyu payon tinuḻungan sakon.’ ");
INSERT INTO kmk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ot siya datu dan umoy sin madusaan da si inggaingga yoong sadat nalintog, umoy da utdin mataguwan da si inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Gangputon man Jesus dat insuḻuna, imbagana’t dat disipulus na un, ");
INSERT INTO kmk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tigammu yu un annat duwa’n aḻgawa lawaon sinat Piyestan di Nalausan ot sakona Inyanak di Tagu, maiyawataka mailansa’t kulus.” ");
INSERT INTO kmk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Utdi payona timpu nandadatdatong dat aappun di padi kan lalallakay di Judio utdin palasiyu’n inggawan Caifas un kangattuwana padi. ");
INSERT INTO kmk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nantutulagan da un ilimoda dokmaan si Jesus kan patoyon. ");
INSERT INTO kmk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yoong kanan da un “Adi taku itimpu’t din piyesta ta asi kada lawa manggulu dan tagu ya.” ");
INSERT INTO kmk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Inggaw man da Jesus Betania ummoy da utdit boḻoy da Simon un pinapiyana’t kutoḻ sidit. ");
INSERT INTO kmk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Utdit madama da un mangan, ummadani kan Jesus tun osa’n babai’n nan-aggom si butilya’n nakwa si alabastro un napnu’t nabanobanola bangbangu ot inyisig na utdit uḻun Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yoong utdit nailan dat disipulus na di, summuḻag da un kanan dan, “Amman, tapaya yamyam-anona di? ");
INSERT INTO kmk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nangina okyan nat mailakuwana kad maitod sidan nakapus dit bayad na!” ");
INSERT INTO kmk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yoong tigammun Jesus dit ibagbaga da ot kanana kan dida un, “Apay dillawon yu tun babai? Nabaḻu’n taḻon tun kingwana kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kanayuna inggaw danat nakapus kan dikayu yoong bokona kanayuna inggawak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Satun nangiyisigana si bangbangu uttun long-ag ku, insagana na ud sakon un mailbon. ");
INSERT INTO kmk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tuttuwa tun ibagak kan dikayu! Singngadan na mana igaw situn lubunga maiwalagawagan tun Nabaḻu’n Damag, mauguugud tun kingwan ditun babai un mangisomsomkan kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Utdi, inummoy si Judas Iscariote un osa’t dat kagwampuḻu’t duwa’n disipulus Jesus sidat aappun di padi. ");
INSERT INTO kmk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kinnanana kan dida un, “Piga nat itdon yu kan sakon nu ituyuk ku si Jesus kan dikayu?” Ot initdan da si tuḻumpuḻu’n palata’n pilak. ");
INSERT INTO kmk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Manipud sidiyon ininainap naon dit gundaway na un mangituyuk kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Utdit umuna un aḻgaw dit Piyestan di Tinapaya maid si bubud, ummoy dat disipulus Jesus kan siya ot kanan dan, “Kawad dit piyaoma umoyan mi mangisaganaan sit kakan di piyesta?” ");
INSERT INTO kmk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kinnanan Jesus kan dida un, “Umoy kayu ud Jerusalem si osa’n tagu ot ibaga yu un, ‘Kanan dit Mistulu un dandaniyon dit naitudinga timpu na ot buḻun na dikami’n disipulus na un mangan sit kakan di piyesta uttun boḻoy yu.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tinungpal dat disipulus Jesus dit imbaga na ot ummoy da insagana dit kakan di Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Masdom man, summangu da Jesus un mangan sidat kagwampuḻu’t duwa’n disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Utdit madama da un mangan, kinnanan Jesus un, “Tuttuwa tun ibagak kan dikayu’n osa kan dikayu ud mangituyuk kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Utdi, nasigab dit angos dat disipulus na ot sin-ossa dan nangimus kan siya un, “Apu, sakon kad?” ");
INSERT INTO kmk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Summungbat si Jesus un, “Naid sabali’t mangituyuk kan sakon nu adi sat makasawsaw kan sakon si tinapay situn maḻukung. ");
INSERT INTO kmk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta sakona Inyanak di Tagu, matoyak un kama’t dit naikanglit sit ugud Apudyus yoong kaasi nat tagu’n mangituyuk kan sakona Inyanak di Tagu! Napipiya pay nu adina naiyanak!” ");
INSERT INTO kmk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Guminga man si Judas un siya’d mangituyuk, kanana un, “Sakon kad, Mistulu?” “Inugud nuwon,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Madama da payyana mangmangan, nangaḻa’t Jesus si tinapay ot nanyaman kan Apudyus asina biniibiika intod sidat disipulus na un kanana’n, “Aḻan yu tu ta kanon yu ta siya’d long-ag ku.” ");
INSERT INTO kmk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Asina payyan innaḻa dit natasa un inumon da. Maabus mana manyaman kan Apudyus intod na kan dida un kanana’n, “Uminum kayu’n losan situ ");
INSERT INTO kmk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ta siyatu’d daḻaka mangipapiddot sidit intulag Apudyus sidat tagu, siya’d daḻaka man-ayus daḻapnu mapakawan dat basuḻ dat adu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ot ibagak kan dikayu’n, adiyakon uminum situwa danum di ubas inggana’t dit aḻ-aḻgawa manginuman taku’t dit bagu’n danum di ubas sidin mangiyapuwan Amak.” ");
INSERT INTO kmk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Utdi, nangkanta da un nandaydayaw kan Apudyus ot maabus man kaysan da utdin bateled Olivo. ");
INSERT INTO kmk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Utdi, imbagan Jesus kan dida un, “Sinsatuna labi mangkabutik kayu’n losan ot taynanak ta naikanglit sit ugud Apudyus un, ‘Patoyok dit man-aayyuwan si kannelu ot man-asiwaḻak dat kannelu na.’ ");
INSERT INTO kmk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yoong nu maabusa mapaungaḻak, umun-unaak Galilea nu dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Utdi, kinnanan Pedro un, “Ulay mangkabutik da un losan adik sika taynan!” ");
INSERT INTO kmk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kinnanan Jesus kan siya un, “Tuttuwa tun ibagak kan sika. Uttuwa labi utdit daan payyan manullauk dit kawitan, pitluwom isulib sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Summungbat si Pedro un kanana’n, “Ulay nu maipangkatoyak kan sika adik sika isulib!” Ot siya pay kanan dat uduma disipulus. ");
INSERT INTO kmk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ummoy da Jesus sidat disipulus na utdin mumuḻ-ana mangngadan Getsemani ot imbaga na kan dida un, “Mantupak kayu yan situ ta umoyak manluwaḻu’t di.” ");
INSERT INTO kmk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ot indallay na da Pedro kan sadat duwa’n anak Zebedeo. Utdi, amoamod dit domdom na kan mabulubulung. ");
INSERT INTO kmk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ot imbaga na utdat tuḻu’n buḻun na un, “Amod tun domdom ku ot kama nu ikatoy kuwon. Inggaw kayu’t tu ot makapanbaḻaga kayu kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Utdi ummadayu’t akit si Jesus ot nanlakkoba nanluwaḻu’n kanana’n, “Ama, nu mabalin, ilisiyak situwa ligata sagapaḻok. Yoong bokona sat piyaok dit matungpal nu adi sat piyaom.” ");
INSERT INTO kmk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Utdi, nangulin sidat tuḻu’n disipulus na ot dinakngana dida’n masusuyop. Ot kinnanana kan Pedro un, “Adi kayu kad makaattoma makapanbaḻaga kan sakon si ulay sin-olasa lawa? ");
INSERT INTO kmk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mansiput kan manluwaḻu kayu daḻapnu adi kayu mambasuḻ nu masugsugan kayu. Ta nadaddaan nat angos yu un manungpal yoong nakapsut nat long-ag yu.” ");
INSERT INTO kmk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Impigwan payyan Jesus un ummadayu’t akit un ummoy nanluwaḻu’n kanana’n, “Ama, nu masapula sagapaḻok tuwa ligat, matungpal nat piyaom.” ");
INSERT INTO kmk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mangulin man uman sit inggawan dat tuḻu’n disipulus na, dinakngana uman dida’n masusuyop ta adida madiyat dat ata da. ");
INSERT INTO kmk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Impitlun uman Jesus un tinengyan dida’n nangulina ummoy nanluwaḻu un padan uman dit imbaga na un nanluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Utdiyon nangulin sidat disipulus na un kanana’n, “Apay masusuyop kan gaillongan kayu kad payyan? Olas naona maiyawataka Inyanak di Tagu’t dadit gumabasuḻ. ");
INSERT INTO kmk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gumangun kayu ta intakunon ta antuwon tun tagu’n mangituyuk kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mambagbagbaga payyan si Jesus sidit dummatong si Judas un osa’t dat kagwampuḻu’t duwa’n disipulus na. Buḻun na dat adu’n tagu’n gaispadaan kan gapang-uḻana imbaun dat aap-apun di padi kan lalallakay di Judio. ");
INSERT INTO kmk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Indaan Judas imbaga dit mantitigammu da kan Jesus un kanana’n, “Sat tagu’n umoyak ogkan, siya ud dokmaan yu!” ");
INSERT INTO kmk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nandadawwos si Judas kan Jesus un kanana’n, “Napiya’n labim, Mistulu,” ot inogkana. ");
INSERT INTO kmk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Summungbat si Jesus un, “Gayyom! Koomon nat panggop nu un koon!” Utdiyon ummadani dat buḻun Judas ot dinokmaan da si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dagusa inapsut dit osa’n buḻun Jesus dit ispada na ot binakag na dit baba-unon didit kangattuwana padi ot nasokdap dit inga na. ");
INSERT INTO kmk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yoong kinnanan Jesus un, “Iboḻoy nu nat ispadam ta sanat mangusal sinat ispada na, ispada pay nat mamatoy da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Adim kad tigammu’n nu kodawok ud saḻak Ama, dagusa mangibaun si piga’n libu un anghel? ");
INSERT INTO kmk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yoong nu kook di, adinaon matungpal dit imbagana’t dit naikanglita ugud Apudyus un maipasamak.” ");
INSERT INTO kmk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Utdi imbagan Jesus sidat kaaduwan un, “Apay tulisanak kad ta ummoy kayu’t tu un gaispadaan kan gapang-uḻan un umoy manokma kan sakon? Inaḻgawa awadak sin timplu’n mantudtudu, apay adiyanak dinokmaan sidi? ");
INSERT INTO kmk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yoong mapasamak datu’n losan daḻapnu matungpal dit paingkanglit Apudyus sidat propeta na.” Utdi nangkabutik un losan dat disipulus Jesus ot binaybay-an da. ");
INSERT INTO kmk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sadat nanokma kan Jesus, indallay da utdit boḻoy Caifas un kangattuwana padi un siya’d nadakdakngan dat mimistulun di lintog kan lalallakay di Judio. ");
INSERT INTO kmk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ot si Pedro inadayuwana’n tinung-ud inggana’t dit paway dit kangattuwana padi ot nilumnoka umoy nakatupak sidadit man-aandog ta ilana nu ngadan dit mapasamak kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sadat aap-apun di padi kan papangat di Judio, man-in-inap da si mamabasuḻan da kan Jesus ulay nu tuli daḻapnu idaḻum da kan papatoy da. ");
INSERT INTO kmk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yoong maid indasan da ulay nu adu dat ummoy nantuli maipanggop kan siya. Masulsulit man inggaw da ud duwa’n inummoy sit sangu. ");
INSERT INTO kmk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Kanan da un, “Kanan dituwa tagu un, ‘Mabalin ku un yam-anon din Timplu’n Apudyus asik ibangun obos si unog di tuḻu’n aḻgaw.’ ” ");
INSERT INTO kmk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Summikad dit kangattuwana padi ot kanana kan Jesus un, “Maid kad maisungbat nu uttu’n ipabpabasuḻ da kan sika?” ");
INSERT INTO kmk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yoong adina gumminga si Jesus. Utdi kanan uman dit kangattuwana padi kan siya un, “Maipagapu’t din ngadan Apudyus un adi matoy, ibagam kan dikami nu sika dit Kristu un Anak Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Summungbat si Jesus un, “On, Imbagamon! Yoong ibagak kan dikayu un maila yun tu ud sakona Inyanak di Tagu’n mantutupak sin kapon madiwanan Apudyus un mannakabalin. Maila yu pay sakona mangulina manligwat langita mailabaw si bunot.” ");
INSERT INTO kmk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pinissay dit kangattuwana padi dit badut na utdit amoda suḻag na un kanana’n, “Maisuganggang kan Apudyus tun inugud na. Apay un masapul payyan nat uduma kustigu? Dingngoḻ yuwon din imbaga na! ");
INSERT INTO kmk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sinnat makanan yu?” Insungbat da un, “Masapula mapatoy.” ");
INSERT INTO kmk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ot niluglugpaan da dit pasngit na kan dinanug da. Ot sadat udum, tinipak da un ");
INSERT INTO kmk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kanan dan, “Pugtuwam ud Kristu nu singngadan dit nanipak kan sika?” ");
INSERT INTO kmk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mantutupak payyan si Pedro utdit paway sidit ummoy kan siya dit babai’n baba-unon didit kangattuwana padi un kanana’n, “Sika, osa ka pay sidat buḻun ud Jesus un iGalilea.” ");
INSERT INTO kmk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yoong insulib na utdit sanguwanan da un losana kanana’n, “Naid tigammuk sinat piyaoma ugudon.” ");
INSERT INTO kmk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ot utdit ummoy sit luwangan, inggaw payyan osa’n babai’n baba-unona nangila kan siya ot kinnanana utdat tagu’n iinggaw sidi un, “Satu, buḻun Jesus un iNazaret.” ");
INSERT INTO kmk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yoong insulib uman Pedro un kanana’n, “Sapataak un adik tigtigammu nat un tagu!” ");
INSERT INTO kmk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Masulit man ummadani kan Pedro dat tagu’n ininggaw sidi ot kanan da un, “Gattoka sika’d osa’t dat kabbuḻunana ta maimatunan sinat gooy nat mambabagbagam.” ");
INSERT INTO kmk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Utdi imbagan Pedro un ulay nu madusa nu bokona tuttuwa dit ibagbaga na ot insapata na un kanana’n, “Adik tigtigammu nat un tagu!” Ot dagusa nanullauk dit kawitan. ");
INSERT INTO kmk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nagasmok Pedro dit imbagan Jesus kan siya un, “Daan payyan tullauk di manuk insulibakon si namitlu.” Utdiyon, lummaksun ot nan-i-ibil. ");
INSERT INTO kmk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mawakas man, nambabagbagaan dat losana aap-apun di padi kan lalallakay di Judio dit koon da un mangipapatoy kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Maabus man, piningil da un indallay kan gubinnadul Pilato. ");
INSERT INTO kmk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Utdit matigammuwan Judas un nangituyuk kan Jesus un nakoddongana mapatoy si Jesus, nambabawi ot innaḻa na dit tuḻumpuḻu’n pilak ot ummoy na inyulin sidat aap-apun di papadi kan lalallakay di Judio ");
INSERT INTO kmk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ot kinnanana’n, “Nakabasuḻak ta intuyuk ku din naid si basuḻa tagu!” Yoong kinnanan da un, “Ngadan nat biyang mi utnat? Nangamung ka pay lawan!” ");
INSERT INTO kmk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Utdi, indawat Judas dit pilak sit timplu ot kaysana ummoy namposoḻ. ");
INSERT INTO kmk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inaknam dat aap-apun di padi dit pilaka kinnanan dan, “Adin dit lintog taku ipalubusa maidagamung sit pilak di timplu ta naigatang si angos di tagu.” ");
INSERT INTO kmk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ot nan-aampayunan da un igatang dit pilak sit pitan di manduduwin ta usalon da un mangilbonan sidat kakkaili. ");
INSERT INTO kmk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ot siya’d gapuna un san ngadan didiya pita inggana’t tun satun, “Pitan di Daḻa.” ");
INSERT INTO kmk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ot siya’d tungpal dit ingkanglit Jeremias un propetan Apudyus sidit un kanana’n, “Inaḻa da dit tuḻumpuḻu’n pilaka siya’d bilanga nambabagbagaan dat piga’n kaganakan Israel un nanggatang da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ot inusal da un inggatang sit pitan di manduduwin, siyadi dit imbilin Apudyus kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Summikad si Jesus sit atubang gubinnadul Pilato un mansukna kan siya. Inyimus Pilato kan siya un, “Sika kad dit Alin dat Judio?” Summungbat si Jesus un, “Naibagamon!” ");
INSERT INTO kmk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yoong utdit pabasuḻon dat aap-apun di padi kan lalallakay di Judio, adina sinungsungbatan dat impabasuḻ da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Isunga kinnanan Pilato kan siya un, “Adim kad magngoḻ danat ipabpabasuḻ da kan sika ta adika sumungsungbat?” ");
INSERT INTO kmk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yoong naid osa’t sinungbatan Jesus sidat impabasuḻ da ot nasnasdaaw si Pilato. ");
INSERT INTO kmk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kada Piyestan di Nalausan, gagangay dit gubinnadul un mangiwaya si osa’n baḻuda kodawon dat tagu un mawayaan. ");
INSERT INTO kmk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Utdiya timpu, ininggaw osa’n baḻuda nandinadinamag un mangngadan si Barrabas. ");
INSERT INTO kmk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Utdit nadatdatong dat adu’n tagu, inimus Pilato kan dida un, “Ngadan nat piyaon yu un pawayaak? Si Barrabas onnu si Jesus un mauguda Kristu?” ");
INSERT INTO kmk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Siya’d imus na di onta tigammu na un apaḻ dit gapun dit nangiyawatan da kan Jesus kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bokona lawan sadi ta utdit mantutupak payyan si Pilato utdit tutuppakan di kuis, inggaw sulata impaitod dit asawa na un kanana’n, “Adika makabiyang sinat nalintoga tagu ta awad inin-inop ku maipanggop kan siya’t dit labi ot taḻona umogyatak.” ");
INSERT INTO kmk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yoong sinugsugan dat aap-apun di padi kan lalallakay di Judio dat tagu un si Barrabas dit paipawaya da ot papatoy da si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Siya’d gapuna’n utdit imuson Pilato kan dida uman un, “Singngadan na utdatu un duwa nat piyaon yu un pawayaak?” Summungbat da un, “Si Barrabas!” ");
INSERT INTO kmk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ot inimus na un, “Ngadan nat kook kan Jesus un mauguda Kristu nu?” “Pailansam si kulus,” insungbat da. ");
INSERT INTO kmk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Inimus uman Pilato un, “Tapay? Ngadan nat nadadaga kingwa na?” Ot amo indangsodangsoḻ daot dit pakuy da un, “Pailansam si kulus!” ");
INSERT INTO kmk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Utdit mailan Pilato un naid makwa na ot manlugiyona magulu dat tagu, nangaḻa’t danum ot binuḻuwana dat ima na utdit atubang dat kaaduwan ot kanana’n “Naid biyang ku utnat mapatoyan dituwa tagu. Nangamung kayu pay lawan.” ");
INSERT INTO kmk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Summungbat dat losana tagu un, “Dikami’t dan kaganakan mi ud sumungbat sin angos na!” ");
INSERT INTO kmk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Utdi pinawayaan Pilato si Barrabas yoong pinasabid na si Jesus asina inyawat sidat suldadu daḻapnu ilansa da si kulus. ");
INSERT INTO kmk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Utdi, innilnok dat suldadun gubinnadul Pilato si Jesus sit boḻoy gubinnadul ot nilikmut dat losana suldadu si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Niluksub da dit badut na asida kinagoyan si nadokota luput. ");
INSERT INTO kmk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Namalikawog da si nasaisait si imbaḻangat da utdit uḻu na. Pinaaggoman da pay si bassaw dit diwanana ima na asida nampalintumong sit sanguwana un nangam-amoḻ un kanan dan, “Matattagu tun Alin di Judio!” ");
INSERT INTO kmk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niluglugpaan da ot inaḻa da dit bassaw kan siya asida impang-ok sit uḻu na. ");
INSERT INTO kmk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Utdit abuson da un man-am-amoḻan, niluksub da dit ingkagoy da ot insukat da dit gagangaya badut na. Ot inlaksun daon un umoy ilansa’t dit kulus. ");
INSERT INTO kmk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Utdit lumaksunan da utdit ili, inabat da tun osa’n tagu’n mangngadan kan Simon un iCirene ot impapilit dat suldadu’n pinabukud kan siya dit kulus Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ot dintong da dit igawa ngadnon da si Golgota un sat piyaona’n ugudon, “Igaw di Battukag.” ");
INSERT INTO kmk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Inggaw da man sidi, initdan dat Jesus si basi un nakamsan si apdu daḻapnu inumona yoong kapkapana man, adina. ");
INSERT INTO kmk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Maabus da mana ilansa’t dit kulus, nambubunutan dat suldadu un nambibingayan dit badut na, ");
INSERT INTO kmk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","asida nantupaka mamabantay kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sat ngatun dit uḻu na nangikwa da si nangikanglitan da utdit gapun dit namabasuḻan da kan siya un kanana’n, “Siyatu si Jesus un Alin dat Judio.” ");
INSERT INTO kmk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Naidisan pay un nailansa dat duwa’n tulisana nan-asisupang kan siya, osa’t dit kapon diwanan na ot sat osa pay sit kapon kawigi na. ");
INSERT INTO kmk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sadat manlaus, nanwitiwit da un nanginsultu kan Jesus un kanan dan, ");
INSERT INTO kmk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Sika un mangibagbaga un yam-anom dit timplu asim ibangun obos si unog di tuḻu’n aḻgaw, taguwom nat long-ag nu. Ot nu tuttuwa’n Anak dika kan Apudyus lumsa ka utnat kulus!” ");
INSERT INTO kmk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ot padana paya naipan-am-amoḻ dat aap-apun di padi kan mimistulun di lintog kan dadit lalallakay di Judio un kanan dan, ");
INSERT INTO kmk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tinagu na dadit udum yoong adina matagu din long-ag na. Bokon kada siya’d Alin dadit iyIsrael? Nu lumsa’t din kulus naon, manuttuwa kami. ");
INSERT INTO kmk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mantaḻgod kan Apudyus kan kanana pay un siya’d Anak Apudyus ot nu tuttuwa’n napotog kan Apudyus, taguwona!” ");
INSERT INTO kmk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Padana pay un inin-insultun dat duwa’n tulisana nailansa’t dit nan-asisupang na. ");
INSERT INTO kmk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mamalintuud man si init, kinumḻop tun lubung inggana’t nandangwilis. ");
INSERT INTO kmk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mandangwilis man si init, nampakuy si Jesus si nadangsoḻ un kanana’n, “Eloi, Eloi lama sabaktani?” Sat piyaona’n ugudon, “Apudyus ku, apay pinatungadak?” ");
INSERT INTO kmk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ot sadat uduma iinggaw sidi un nangngoḻ sit imbaga na kanan da un, “Ay-ayyagana si Elias.” ");
INSERT INTO kmk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ot dagusa nanoddak dit osa kan dida’n ummoy nangaḻa’t kama’t kaposa ummoy na insawsaw sit kilom ot innigga na utdit pungtun dit bassaw asina indukmit kan Jesus daḻapnu supsupana. ");
INSERT INTO kmk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yoong kanan dat uduma, “Daḻam yan ta ilan taku nu umoy Elias taguwon!” ");
INSERT INTO kmk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nampakuy uman si Jesus ot insuku naon dit angos na. ");
INSERT INTO kmk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Utdi, dagusa nangkagwa’n napissay dit koltina’t dit timplu, manipud ngatu inggana’t dit lagayadana. Nanlunig ot nabtak dadit nangkaddakkoḻa batu. ");
INSERT INTO kmk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nambukat pay dat lobon ot adu dat ummungaḻ un tagun Apudyus un natoy sidit. ");
INSERT INTO kmk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Umungaḻ man si Jesus, ummoy da ud Jerusalem ot adu dat tagu’n nampail-an da. ");
INSERT INTO kmk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Magiknan man dit kapitan kan dat suldadu na un manga-andog kan Jesus dit lunig kan naila da dat losana napasamak, amoamod dit kimut da ot kinnanan da un, “Tuttuwa gayama Anak Apudyus!” ");
INSERT INTO kmk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Utdit adayu’t akit, inggaw da pay adu’n babai’n mangoottap sidit mapaspasamak un siya dat nanligwat Galilea un naitungtung-ud kan tummuḻtuḻung kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inggaw kan dida da Maria Magdalena, si Maria un inan da Santiago kan Jose kan sat asawan Zebedeo. ");
INSERT INTO kmk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Masdom man, dummatong si Jose un osa’n baknanga iyArimatea kan osa pay sidat disipulus Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ummoy na kindaw kan Pilato dit ladag Jesus. Utdi imbilin Pilato utdat suldadu un maitod kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ot inaḻan Jose dit ladag asina nilukutan si napoḻkas un luput. ");
INSERT INTO kmk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Utdiyon ummoy na innilbon sit kakokwa na un inabutana’n dakoḻa batu un lobon na pay lawan yoong. Maabus man, namallin si dakoḻa batu ot intubot na utdit sagangaban didit lobon, asina kaysan. ");
INSERT INTO kmk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ininggaw pay sidi da Maria Magdalena kan sadit kangadan na un Maria un mantutupak un manisinnagung sit lobon. ");
INSERT INTO kmk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mabigat man, sidit maabus dit aḻ-aḻgawa mansaganaan, ummoy dat aap-apun di padi kan dat Fariseo kan Pilato. ");
INSERT INTO kmk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ot kinnanan da un, “Apu, nagasmok mi un sadit katattagun payyan didit matuli, imbaga na un umungaḻ kanu nu maikatlu’n aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isunga ibilin nu ta maammaana maandogan dit lobon inggana’t dit maikatlu’n aḻgaw ta ummoy kada lawan dat disipulus na akawon dit ladag na ta asida ibaga’t dan tagu’n ummungaḻ un natoy. Ta nu makwa di, amoamodoton un makaallilaw tun maudi’n tuli na nu sadit damu’n imbagana’n siya’d imbaun Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ot kinnanan Pilato kan dida un, “Mangaḻa kayu’t dan suldadu ot ammaan yu un paandogan din lobon.” ");
INSERT INTO kmk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Utdi, ummoy da inyamma dit tubot dit lobon asida minalkaan daḻapnu matigammuwan nu mabukatan. Maabus man, tinengyan da dat suldadu’n man-andog. ");
INSERT INTO kmk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Biggabiggat man dit umuna un aḻ-aḻgaw di sindumingguwan sidit maikabas dit aḻ-aḻgawa iillongan, ummoy da Maria Magdalena kan sat kangadan na un Maria innila dit nailbonan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kakḻata lawa’n nanlunig si nabilog. Inggaw anghel Apudyus un dummoba’n nanligwat langit un umoy namallin sit batu’n naitubot sit sagangaban dit lobon ot nantupakana. ");
INSERT INTO kmk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Makasiling dit ila na un kama’t kilat kan napoḻkapoḻkas dit badut na. ");
INSERT INTO kmk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ot gapilpilan dat man-aandog sit amoamod un kimut da ot natukas da un kama dat natoy. ");
INSERT INTO kmk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yoong kinnanan dit anghel sidadit babai un, “Adi kayu kumimut, ta tigammuka inapon yu si Jesus un nailansa’t dit kulus. ");
INSERT INTO kmk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naid situ ta ummungaḻon un siya dit imbaga na kan dikayu. Awe yu ta ikayu ilan tun naibanatana. ");
INSERT INTO kmk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Asiyu daḻdaḻsona umoy ibaga’t dat disipulus na un ummungaḻon. Ot makauna’d Galilea nu dikayu ot siyadi ud mangil-an yu kan siya. Tandaanan yu tuwa imbagak kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Utdi, nandaḻadaḻas da un kaysan un kumimkimut da yoong amod dit anggom da. Nanodtoddak da un ummoy nangibaga’t dat disipulus Jesus. ");
INSERT INTO kmk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Utdit manodtoddakan da, inabat Jesus dida ot kanana’n, “Ayan yu?” Ummadani da un umoy ummaggom sit ikin Jesus un nampalintumonga nandayaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Utdi kinnanan Jesus kan dida un, “Adi kayu umogyat. Ikayu ibaga’t dan losana susunud ku ta umoy da ud Galilea ot maila da ud sakon sidi.” ");
INSERT INTO kmk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Utdit manaddaḻanon dadit babai, ummoy sin Jerusalem dat uduma suldadu’n nan-andog sit lobon ot impadamag da utdat aap-apun di padi dat losana napasamak. ");
INSERT INTO kmk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nandadatdatong dat aap-apun di padi utdat lalallakay di Judio ta tulagon da nu innon dit koon da. Pinasuksukan da dat suldadu si adu’n pilak ");
INSERT INTO kmk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asida binilin dida un, “Ibaga yu utdan tagu un, ‘Ummoy dat disipulus Jesus inakaw dit ladag na utdit labi utdit masusuyop kami,’ kanan yu. ");
INSERT INTO kmk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ot nu matigammuwan ud gubinnadul tu, adi kayu madanagan ta dikami’d makabagbaga kan siya daḻapnu maid mapabasuḻan yu.” ");
INSERT INTO kmk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Utdi, innaḻan dat suldadu dit pilak ot tinungpal da dit naibilin kan dida. Ot siyatu’d uḻ-uḻnuga maipadpadamag sidan losana Judio inggana’t tun satun. ");
INSERT INTO kmk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ummoy dadit kagwampuḻu’t osa’n disipulus Jesus sin bateled Galilea un siya dit imbagan Jesus un umoyan da. ");
INSERT INTO kmk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Utdit maila da, nandayaw da kan siya yoong nanduwaduwa kampay dat udum kan dida. ");
INSERT INTO kmk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ummadani’t Jesus ot kinnanana kan dida un, “Naitod kan sakon dit losana kalintogan sin langit kan situn pita. ");
INSERT INTO kmk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isunga ikayu utdan losana tagu’t tun lubung ot tudtuduwan yu dida dalapnu mambalin da un disipulus ku. Bunyagon yu dida’t din ngadan Ama, Anak kan Ispiritu Santu, ");
INSERT INTO kmk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kan tudtuduwan yu dida un mantungpal sidan losana imbilin ku kan dikayu. Ot tatandaanan yu, awadak un kankanayuna mamuḻubuḻun kan dikayu inggana’t anungus ditun lubung.”");
INSERT INTO kmk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Kama’t tu dit luglugin dit Nabaḻu’n Damag maipanggop kan Apu Jesu Kristu un Anak Apudyus. Paingkanglit Apudyus kan Isaias un propetana un kanana’n, “Ibaun ku dit propetak un umun-una nu sika un umoy mangisagana’t dit daḻan un ayom. ");
INSERT INTO kmk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ipappakuy na utdit igawa maid tagtagguwan un, ‘Isagana yu dit daḻan dit Apu. Manggodngon yu dit daḻan un ayona.’ ” ");
INSERT INTO kmk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ot natungpal di ta ummoy si Juan un Mambubunyag sidit igawa maid tagtagguwan na ot intudtudu na utdat tagu’n dummatong kan siya’t di un mandadaoli da kan igongda daon dat basuḻ da ot mampabunyag da daḻapnu pakawanon Apudyus dida. ");
INSERT INTO kmk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Adu dat tagu’n nanligwat sin losana nilakub Judea kan padana pay sin Jerusalem un ummoy nandongoḻ kan Juan. Impudnu da dat basuḻ da asin Juan binunyagan dida’t din wangwang Jordan. ");
INSERT INTO kmk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sat badut Juan, naganay un dutdut di kamelyu kan nambakakat si geddang ot dudun kan dilu dit ikatagu na. ");
INSERT INTO kmk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nantudtudu un kanana’n, “Awad ud maitagtagnob kan sakon un taḻona nangatu nu sakon ot adiyak pay maibilanga man-okoga mangussag sit sandalyas na. ");
INSERT INTO kmk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bunyagok dikayu si danum yoong Ispiritu Santu nat ibunyag na kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Utdiya timpu un mamunbunyagan Juan dummatong pay si Jesus un nanligwat Nazaret sin ili na ud Galilea ot nampabunyag kan Juan sin wangwang Jordan. ");
INSERT INTO kmk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tumakdang man si Jesus, dagusa naila na din langit un nambukat ot dummoba kan siya si Ispiritu Santu un kama’t kalupati. ");
INSERT INTO kmk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Utdiyon inggaw ginga’n nanligwat langit un kanana’n, “Sika’d pipiyaoka Anak ku un taḻona masmas-omak.” ");
INSERT INTO kmk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Maabus man di dagusa indallay dit Ispiritu Santu si Jesus sidit igawa maid tagtagguwan na. ");
INSERT INTO kmk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Opatapuḻu’n aḻ-aḻgaw un iniinggaw sidi ot ummoy Satanas sinugsugsugan. Inggaw pay dat simalona ayam sidiya igaw ot ummoy dadit aanghel tinuḻungan si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Utdit naibaḻud si Juan, kaysan si Jesus ud Galilea un umoy mangitudtudu utdit Nabaḻu’n Damag un nanligwat kan Apudyus un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Natungpaḻon dit naikoddonga timpu. Dandaniyon dit mangiyapuwan Apudyus kan dikayu. Mandadaoli kayu’t dan basbasuḻ yu kan tuttuwaon yu tun Nabaḻu’n Damag.” ");
INSERT INTO kmk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mangkikkiyang man si Jesus sin igid bananaw sidin Galilea, naila na da Simon kan Andres un mansunuda madama’n mantabtabukuḻ ta doda’n siya’d kewaaḻ da. ");
INSERT INTO kmk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kanan Jesus kan dida un, “Maitung-ud kayu kan sakon ta mambalinok dikayu un mantatabukuḻ si tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dagusa tinengyan da dadit tabukuḻ da ot naitung-ud da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Makaadayu da man si akit, nailan Jesus da Santiago kan Juan un anak Zebedeo utdit bangka un man-amitong sidit tabukuḻ da. ");
INSERT INTO kmk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dagusa inayagana dida ot tinengyan da dit ama da utdit bangka pati utdat tangtangdanan da un buḻun da ot naitung-ud da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Inummoy da Jesus sidin Capernaum ot dumatong man dit aḻ-aḻgawa iillongan nilumnok da utdit sinagoga ot nantudtudu si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nasnasdaaw dadit tagu’n nangngoḻ sit nantutudtudu na, ta maila un awad tulay na bokona kama’t dat mantutudtudun dat mimistulun di lintog. ");
INSERT INTO kmk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ininggaw laḻaki’n sinakayan di nadadaga ispiritu utdit sinagoga. ");
INSERT INTO kmk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kakḻata nampakuy un kanana’n, “Jesus un iNazaret, ngadan nat umoy ka koon kan dikami? Ummoy ka kad situ daḻapnu yam-anom dikami? Tigammuk sika. Sika’d nasantuwana imbaun Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yoong inggimaun Jesus dit nadadaga ispiritu un kanana’n, “Guminok ka ot tengyam nat tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pinanwogowog dit nadadaga ispiritu dit tagu’n pinampakuy asina tinengyan. ");
INSERT INTO kmk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nasnasdaawa losan dat tagu ot nampaim-imus da pay lawan un, “Ngad kad nin ditu? Bagu kad nin un tudtudu? Ta antu’d kalintogana. Ulay dan nadadaga ispiritu tuttuwaon da dan bilin na.” ");
INSERT INTO kmk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Utdiyon, dagusa nandinadinamag dit maipanggop kan Jesus sidat losana ili un nangkalliput sidin Galilea. ");
INSERT INTO kmk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lummaksun da Jesus sit sinagoga ot kaysan sit boḻoy da Simon kan Andres un naitung-ud pay da Santiago kan Juan. ");
INSERT INTO kmk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sadit katugangan Simon un babai, uumboga mampudpudut ot dumatong man da Jesus dagusa imbaga da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ummadani si Jesus sit masakit ot inaggomana dit imana un dit namangun. Dagusa naid dit pudut na ot ummoy nangisagana’t kinan da Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maipsuk man si init, indatong dat tagu kan Jesus dat losana masakit kan sinakayan di dimunyu. ");
INSERT INTO kmk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ot nadatdatong dat losana umili utdit boḻoya ininggawana. ");
INSERT INTO kmk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ot pinabilog Jesus dat adu un masakit si nadumaduma’n sakit kan inaddag na dat adu un dimunyu. Yoong adina impalubusa nambagbaga dat dimunyu onta tigammu da nu singngadan ud Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wiswis-it man, gummanguna lummaksun si Jesus sit boḻoy ot kaysan sit gattotopoga igaw un ummoy nanluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yoong ummoy da Simon kan dadit buḻun na ininap. ");
INSERT INTO kmk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Utdit maodasan da kanan da kan siya un, “In-innapon dika’t dan losana tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ot summungbat si Jesus un, “Umoy taku’t dan uduma ili daḻapnu mantudtuduwak pay sidi ta siya’d inummoyak situ.” ");
INSERT INTO kmk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Utdi dinakdak na din probinsiya’d Galilea un nantudtudu’t dat sinagoga da kan inaddag na dat dimunyu utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Inggaw osa’n nakutoḻa ummoy nampakpakaasi kan Jesus ot nampalintumong un kanana’n, “Tigammuka kabooḻama papiyaon sakon nu piyaom.” ");
INSERT INTO kmk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nadaguwan si Jesus ot inagpadana asina kinnanan un, “On, piyaok. Kumiya ka.” ");
INSERT INTO kmk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dagusa nakaan dit kutoḻ na ot kummiya. ");
INSERT INTO kmk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Binilibilin Jesus dit laḻaki asina pinadaḻana dagus un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ilam ta adim ibagbaga’t udum nu adi mandadawwos ka kan padi ta umoy ka ipaila un kummiya kaon asika umoy mandatun kan Apudyus un kama’t dit imbilin Moses sidit, ta manigammuwan di losana tagu un kummiya ka.” ");
INSERT INTO kmk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yoong inummoyot dit laḻaki imbagabaga utdat tagu dit naipasamak kan siya ot nandinadinamag dit maipanggop kan Jesus. Kadon, adina’t Jesus mabalina mampaila’n lumnok sidat il-ili nu adi iniinggaw sit igawa maid tagtagguwan. Ot nakaddatodatong dat tagu kan siya un nanligwat si nadumaduma’n ili. ");
INSERT INTO kmk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lumabas man dit piga’n aḻgaw, nangulin si Jesus ud Capernaum ot naipadamag sidat tagu un summaaḻ sit boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Amoda tagu’n nandatdatong ot maid makgawan sit boḻoy ulay sit adani’t dit sawang. Utdit madama’n itudtudun Jesus dit ugud Apudyus kan dida, ");
INSERT INTO kmk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","inggaw tagu’n adi makagidu un binuligan dat opata tagu’n indatong. ");
INSERT INTO kmk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ot gapu’t dit kinaadun dat tagu, maid inon da un mangilnok sit masakit ot ummoy da winangwangan dit otop sit batug Jesus un siya’d nanguyudan da utdit tagu’n uumbog sit katli na. ");
INSERT INTO kmk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Utdit mailan Jesus un taḻona manuttuwa da kan siya, kanana’t dit adi makagidu’n tagu un, “Anak, napakawanon dat basuḻ nu.” ");
INSERT INTO kmk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ininggaw da ud mimistulun di lintoga mantutupak sidi ot magngoḻ da man dit imbagan Jesus, kanan da utdit somsomok da un, ");
INSERT INTO kmk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Apay kama’t tu tun imbagan dituwa tagu? Maisuganggang kan Apudyus dit imbaga na. Sin dit makabooḻa mamakawan si basuḻ nu adi si Apudyus ullawa?” ");
INSERT INTO kmk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dagusa tinigammun Jesus dit somsomok da ot kinnanana kan dida un, “Apay nat somsomok yu un kama’t nat? ");
INSERT INTO kmk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngadan nat naḻasḻasu’n maibaga uttun tagu’n adi makagidu? Sadin, ‘Napakawanon nat basuḻ nu,’ onnu san, ‘Gumangun ka, aḻam nat obok nu ta kumiyang ka?’ ");
INSERT INTO kmk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yoong pabilgok tun adi makagidu daḻapnu manigammuwan yu un sakona Inyanak di Tagu awad kalintogaka mamakawan si basuḻ di tagu’t tun lap-at pita.” Utdi, imbagana’t dit tagu’n adi makagidu un, ");
INSERT INTO kmk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ibagak kan sika, gumangun ka, aḻam nat obok nu ta manaḻan ka.” ");
INSERT INTO kmk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Utdi, gummangun dit tagu ot dagusa inaḻa na dit obok na ot kaysana iillan dat adu’n tagu. Nasnasdaaw da un losan ot indaydayaw da si Apudyus un kanan dan, “Maid payyan nakail-an mi si kama’t tuwa nakwa.” ");
INSERT INTO kmk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nangulin uman si Jesus sin igid bananaw Galilea ot inammung dat amoamoda tagu ot tinudtuduwana dida. ");
INSERT INTO kmk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Maabus man di utdit manaddaddaḻanana, naila na dit man-uuḻup si bugis un si Levi un anak Alfeo. Mantutupak sit pisina na un uuḻḻupan di bugis. Kinnanan Jesus kan siya un, “Maitung-ud ka kan sakon.” Lummigwat si Levi ot naitung-ud kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Utdit inummoy da Jesus kan dat disipulus na utdit boḻoy Levi nakakan, adu dadit nakaubung kan dida un man-uuḻup si bugis kan uduma gumabasuḻ. Ta adu kan dida dat naitungtung-ud kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ot utdit mailan dat mimistulun di lintog un bungguy dat Fariseo un man-uubung da un mangan, kinnanan da utdadit disipulus Jesus un, “Apay makakan sidan man-uuḻup si bugis kan da gumabasuḻ?” ");
INSERT INTO kmk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Magngoḻ man Jesus dit imus da, siya’d summungbata kanana’n, “Sadan awad si sakit ud makasapul si man-aagas bokona sadan naid si sakit. Bokona dummatongak daḻapnu umoyak awison dan mangipagalup un nalintoga tagu nu adi sadan gumabasuḻ un masapula mandadaoli da utdat basuḻ da.” ");
INSERT INTO kmk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Inggaw sin-aḻgawana manlanganan da un mangan dat disipulus ud Juan un mambubunyag kan sadat Fariseo, ummoy dat tagu kan Jesus un kanan dan, “Apay manlangana mangan dan disipulus Juan kan dan disipulus dan Fariseo, yoong bokona manlangan danat disipulus nu?” ");
INSERT INTO kmk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Summungbat si Jesus un, “Mabalin kad un manlangana mangan dat sangaili’t dit boda nu iinggaw payyan kan dida dit laḻaki’n namboda? Bokon. Kigad si iinggaw dit laḻaki un namboda adida mabalina manlangana mangan. ");
INSERT INTO kmk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yoong nu dumtong nat timpu un maaḻaon dit laḻaki’n namboda, siyadiyon ud timpu’n manlanganan da un mangan un mangipaila’t dit domdom da.” ");
INSERT INTO kmk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Utdi inyabalig uman Jesus un kanana’n, “Maid mangitakup si bagu’n luput sinat dadaana badut ta nu masaksakan, mangkulisonson dit bagu’n luput ot am-amdona’n pissayon dit dadaana badut. ");
INSERT INTO kmk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Padana pay un naid mangibilung si bagu’n basi utnat dadaana geddanga bibillungan un adinaon mannatnat. Ta nu sumubuy, buḻtugona dit bibillungan ot kaynga ullawa dit basi pati pay sit bibillungan. Masapula sat bagu’n basi, maibilung si bagu’n bibillungan.” ");
INSERT INTO kmk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Osa’n aḻ-aḻgawa iillongan, nangoy da Jesus kan dat disipulus na utdit kapappayawana namuḻ-an si trigo ot nansapḻut dadit disipulus na utdit bungan di trigo si kinutiman da un dinuum. ");
INSERT INTO kmk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Inggaw da ud Fariseo un nangila’t dit kingwa da ot kinnanan da kan Jesus un, “Ilam, apay un koon danat disipulus nu dit iyadin dit lintoga koon nu aḻ-aḻgawa iillongan?” ");
INSERT INTO kmk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Summungbat si Jesus un, “Adiyu kada taḻon nabasa dit kingwan da Ali David sit nabitilan da utdat buḻun na? ");
INSERT INTO kmk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Timpun Abiatar un kangattuwana padi utdit nilumnok si Ali David sit boḻoy Apudyus ot kinan na dit tinapaya naidatun kan Apudyus un sadat padi ullawa dat mabalina mangan. Ot initdana pay dat buḻun na si kinan da. ");
INSERT INTO kmk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Sanat aḻ-aḻgawa iillongan nakwa si mampiyaan di tagu. Bokona nakwa dat tagu un mangwa si kumiyaan dit aḻ-aḻgawa iillongan. ");
INSERT INTO kmk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Isunga sakona Inyanak di Tagu dit awad si kalintogana mangibaga’t dit mabalina makwa ulay nu aḻ-aḻgawa iillongan.” ");
INSERT INTO kmk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Namingsana ummoyan uman Jesus sit sinagoga, inggaw tagu’t di un naek-ekana nakulekug dit osa’n ima na. ");
INSERT INTO kmk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ininggaw da pay man-in-inap si mamabasuḻan da kan Jesus isunga sipusiputan da nu papiyaona diya nakulekug si ima utdiya aḻ-aḻgawa iillongan. ");
INSERT INTO kmk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","“Awenu’t tu,” kinnanan Jesus sit naek-ekana nakulekug si ima. ");
INSERT INTO kmk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Utdiyon inimus Jesus sidat tagu un, “Ngadan nat ipalubus dit lintog taku un koon taku nu aḻ-aḻgawa iillongan, mangwa’t nabaḻu onnu mangwa’t laweng? Ipalubus na un kumatoy taku onnu managu taku’t tagu?” Yoong maida taḻon gumguminga kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nasuḻaga ummila si Jesus kan dida’n losan ot nagaga gapu utdit kinaboḻang dit uḻu da. Ot imbagana’t dit tagu un, “Uknadom nat imam.” Utdi, inuknad dit tagu dit ima na un naek-ekana nakulekug ot kummiya. ");
INSERT INTO kmk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ot gapu’t diyon, lummaksun dat Fariseo ot nandadatdatong da un dagus sidadit buyut Ali Herodes ta babagbagaon da nu inon mampapatoy da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kaysan da Jesus kan dat disipulus na utdin dupit bananaw Galilea ot amoda tagu’n iGalilea dat naitung-ud kan dida. Adu pay dat nanligwat Judea, ");
INSERT INTO kmk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea kan uduma boboḻoy sidin domang didin wangwang Jordan kan sidan boboḻoya lakub Tiro kan Sidon. Inummoy da kan Jesus gaputa nagngoḻan da dat losana kingkingwa na. ");
INSERT INTO kmk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gapu’t dit kaadun dat tagu imbagan Jesus sidat disipulus na un mangisagana da si bangka ut sumikadana daḻapnu adina masugpet sidat tagu. ");
INSERT INTO kmk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ta adu dat pinapiyana ot losana awad si sakit mampaduddulun da un umoy manekgel kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nu mailan dat tagu’n sinakayan di nadadaga ispiritu si Jesus mantalluku da utdit sanguwana ot mampapappakuy dan dit mangibaga un, “Sika dit Anak Apudyus!” ");
INSERT INTO kmk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yoong binilibilin Jesus dat dimunyu un summakay kan dida un adida ibagbaga dit maipanggop kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sin-aḻgawan, nanagada si Jesus sidin bateled. Inayagana dadit piniyana ot naitung-ud da pay kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Utdi, nanutuk si kagwampuḻu’t duwa kan dida un mambalina apostoles na un maibuḻubuḻun kan siya kan dida ud ibaun na un umoy mantudtudu. ");
INSERT INTO kmk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Initdana dida si kalintogan un mangaddag si dimunyu. ");
INSERT INTO kmk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sadatu dat kagwampuḻu’t duwa’n dinutukana: si Simon un nginadan na kan Pedro, ");
INSERT INTO kmk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago kan Juan un mansunuda anak Zebedeo un nginadan Jesus dida un Boanerges un piyaona’n ugudon aanak di kiduḻ. ");
INSERT INTO kmk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andres, Felipe, Bartolome, Mateo, Tomas, Santiago un anak Alfeo, Tadeo, Simon un mangadan si Patriota ");
INSERT INTO kmk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kan si Judas Iscariote un siya’d nangituyuk kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nanlokat da Jesus ot dumatong da man sit boḻoy, aduadu uman dat tagu’n nandadatdatong ot adida masangu dit mangan sidat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Utdit madamag dat kabagiyana, ummoy da ta ida idallay ta ibagbagan dat tagu un natiwtiwongan ussiya. ");
INSERT INTO kmk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ot sadat mimistulun di lintog un nanligwat Jerusalem ibagbaga da un, “Sinakayan ud Beelzebub un pangat dat dimunyu ot siya’d nangtod kan siya si kalintogana mangaddag sidan dimunyu.” ");
INSERT INTO kmk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Utdi, inayagan Jesus dadiya tagu un umadani da ot inyabalig na kan dida un kanana’n, “Mabalin kada addagon Satanas pay lawan nat long-ag na? ");
INSERT INTO kmk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nu awad ili si mambibinnusuḻ pay lawan dan tagu na, adina mandonoy. ");
INSERT INTO kmk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nu awad simbaḻyan ta mambibinnusuḻ da pay lawan, makaskasway da. ");
INSERT INTO kmk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ot nu mambibinnusuḻ pay lawan da Satanas kan dat dimunyu’n buḻun na, makaskasway da. Ot bokona mandonoy dit mangiyapuwana nu adi mangkigad. ");
INSERT INTO kmk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Maid makabalina umoy lumnok sinat boḻoy di gumibiloga tagu’n umoy man-akaw nu adina yan pangawona unaon dit gumibiloga tagu asina man-aḻa utdat losana kokokwa na. ");
INSERT INTO kmk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Somsomkon yu tu! Losana basuḻ kan nadadaga ibagan di tagu un maisuganggang kan Apudyus, mapakawan. ");
INSERT INTO kmk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yoong singngadan na mana tagu’n mangibaga si nadadag un maisuganggang kan Ispiritu Santu, adinaon mapakawan ta nakakokwa si nakabasuḻana si inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Imbagan Jesus tu onta ngadnon dat udum un nadadaga ispiritu dit ininggaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Utdiyon, dummatong dit inan Jesus kan dat susunud na. Iniinggaw da utdit lasin dit boḻoy ot nangibaun da si ummoy nangayag kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Adu dat tagu un mantutupak sit sog-on Jesus ot imbaga da kan siya un, “Andi da inam kan da sunud nu utdin lasin un mangimus kan sika.” ");
INSERT INTO kmk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Summungbat si Jesus un, “Singngadan kad dat inak kan da susunud ku?” ");
INSERT INTO kmk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ummila si Jesus sidat tagu un nantupak sit nangkalliput kan siya ot kanana’n, “Sadatu dat inak kan da susunud ku! ");
INSERT INTO kmk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Singngadan na mana mangwa’t dan piyaon Apudyus, dida ud susunud ku kan inak.” ");
INSERT INTO kmk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sin-aḻgawan inlugin Jesus uman nantudtudu’t din igid bananaw. Ot gaputa aduadu dat tagu’n nangammung kan siya, ummoy nantupak sit bangka un inggaw sit bananaw ot ininggaw dat tagu’t dit igida mandongoḻ. ");
INSERT INTO kmk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Abalig dit inusal Jesus un nanudtudu utdat adu un intudtudu na kan dida. Ot kanana’n nantudtudu kan dida un, ");
INSERT INTO kmk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dongḻon yu! Inggaw osa’n tagu’n ummoy nan-iwalis sit bukoḻ un tagimuḻa na. ");
INSERT INTO kmk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ot utdit man-iwalisana, naotdag dat uduma bukoḻ sit daḻan ot ummoy dat sissiwit inamin timpok. ");
INSERT INTO kmk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Naotdag dat uduma bukoḻ sit kabatbatuwana akit si pita ot asimpiga da un tummubu ta atapaw dit pita na. ");
INSERT INTO kmk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ot uminit man, naḻpak da ot naḻangu da gaputa adida nakalamut si adaḻom. ");
INSERT INTO kmk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Naotdag dat udum sit kasassaitan ot dumakoḻ man dat sait, naseet dat muḻa ot adida nakabunga. ");
INSERT INTO kmk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ot sat udum paya bukoḻ naotdag da utdit naḻasa un pita ot tummubu kan lummaba da ot namunga da. Inggaw da ud namunga si sintututlumpuḻu, sin-oonomapuḻu kan singgagasut.” ");
INSERT INTO kmk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Utdiyon imbagan Jesus kan dida un, “Dikayu’n awad si inga un makagngoḻ, dumngoḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Utdit kaysan dat adu’n tagu, natengyan si Jesus pati utdat kagwampuḻu’t duwa’n disipulus na kan dat uduma maitungtung-ud kan dida ot inimus da nu ngad dit kaipooyan didit inyabalig na. ");
INSERT INTO kmk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ot imbagan Jesus kan dida un, “Dikayu’d nangipatigammuwan Apudyus sidat adi naipatigammu’t dit maipanggop sin mangiyapuwana. Yoong sadat uduma adi mamiya’n manuttuwa kan sakon, maiyabalig un losan kan dida daḻapnu ");
INSERT INTO kmk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ulay nu iillan da, adida maimatunan ulay nu dodongḻon da, adida maawatan. Ta nu bokona kama’t di, mabalina mambabawi da kad pakawanon Apudyus dida.” ");
INSERT INTO kmk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Utdi, inimus Jesus sidat disipulus na un kanana’n, “Apay adiyu kad maawatan din inyabalig ku? In-inona un maawatan yu dan losana abalig nu?” ");
INSERT INTO kmk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Utdi inlawlawag Jesus dit abalig un kanana’n, “Sadit bukoḻa inwalis dit tagu, siya’d alig dit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sadit daḻana naotdagan dat uduma bukoḻ, siya’d alig dan tagu’n mangngoḻ sit ugud Apudyus yoong dagus un umoy Satanas kaanon kan dida dit uguda dingngoḻ da. ");
INSERT INTO kmk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Padana paya sadan uduma tagu maiyalig da utdit kabatbatuwana naotdagan dat bukoḻ. Nu magngoḻ da din ugud Apudyus dagusa mataḻok da un mangawat. ");
INSERT INTO kmk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yoong adina makalamut dit ugud kan dida isunga adina mambayag dit manuttuwaan da. Nu awad mapaligatan daon onnu uyungan dat tagu dida maipagapu’t manuttuwaan da utdit ugud, dagusa lumipsut daona manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sadit kasassaitana naotdagan dat uduma bukoḻ, alig na dan tagu’n mangngoḻ sin ugud Apudyus, ");
INSERT INTO kmk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yoong gapu’t dan adu’n mabulungan da maipanggop sin mataguwan da uttun pita, san gumamgaman da un gumaknang kan mangaḻa’t dan udum paya piyaon da un kuwaon, maseet dit dingngoḻ da un ugud ot adina makabunga. ");
INSERT INTO kmk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yoong sadit naḻasa un pita un naotdagan dat uduma bukoḻ, siya’d alig dan tagu’n mangngoḻ kan mangawat sin ugud Apudyus ot mamunga da un kama’t muḻa’n sintututlumpuḻu, sin-oonomapuḻu kan singgagasut dat bunga da.” ");
INSERT INTO kmk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Intuluy Jesus dit nan-abalig ot kanana’n, “Awad kad manongog si pingki asina tangngoban onnu igga utdit sogwab katli? Bokon kada igga na utdit kustu un iiggaan? ");
INSERT INTO kmk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Padana pay un naid maisuḻuk si adi maipaḻtaw onnu mailimod si adi mailawag nu timpu na. ");
INSERT INTO kmk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dikayu’n awad si inga un makagngoḻ, dumngoḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Intuluy Jesus un kanana’n, “Ammaan yu un anagon dan dongḻon yu un tudtuduk. Ta nu kamaan dit man-iisomsomok yu utdan tudtuduk siya pay ud kamaan dit maawatan yu kan dogaan pay Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sat tagu’n mangisosomok sidan tudtuduk, umaduadu dit maipatigammu kan siya. Yoong sat tagu’n adina isosomok dat tudtuduk, makaana losan ulay sat akita naawatana!” ");
INSERT INTO kmk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Intuluy uman Jesus nantudtudu un kanana’n, “San mangiyapuwan Apudyus maiyalig si osa’n tagu’n ummoy nan-iwalis si nabaḻu’n bukoḻ sit mumuḻ-ana. ");
INSERT INTO kmk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Masuyop nu labi, gumangun nu bigbigat ot tummubu kan dummakoḻa lawa dat muḻa na un maid tigammu na utdit nandadakoḻ da. ");
INSERT INTO kmk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta sat pita, siya’d nampatubu kan nampabunga. Umuna’n tumubu asi lumipi asi naon mamuyag. ");
INSERT INTO kmk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yoong nu maḻ-um daon, aḻan dit nammuḻa dit lakom ta timpu’n aappitanon.” ");
INSERT INTO kmk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Inyimus Jesus un, “Ngadan dit maiyaligan din mangiyapuwan Apudyus onnu ngadan na un abalig nat mabalina mausal? ");
INSERT INTO kmk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maiyalig sit bukoḻ di mustasa un siya’d kaban-ogana bukoḻ situn pita. ");
INSERT INTO kmk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yoong nu maimuḻa, dumakoḻa gumabogabong ot mambalina kadakoḻana muḻa. Nangkaddakkoḻ dat sanga na ot umoy dat sissiwit manlubuwan.” ");
INSERT INTO kmk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Adu’n abaliga kama’t datu dat inusal Jesus un nangitudtudu’t dit ugud Apudyus sigun sit oḻog dat tagu’n maawatan. ");
INSERT INTO kmk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naid intudtudu na si adi naiyabalig. Yoong nu dida ullawa’t dat disipulus na, ipakaawat na un losan kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Masdom man sidiya aḻ-aḻgaw, kinnanan Jesus sidat disipulus na un, “Mandoḻmang taku.” ");
INSERT INTO kmk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tinengyan dat disipulus Jesus dat adu’n tagu ot ummoy da utdit inggawan Jesus un bangka asidaon kaysan. Naitung-ud pay dat uduma bangka kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Utdiyon kakḻata lawa un gummali’t nabilog ot maḻukuḻukut dit paḻuung un maisaysay-u utdit bangka ot dandaniyon mapnu’t danum. ");
INSERT INTO kmk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yoong si Jesus ininggaw sit pungtun dit bangka un uumping sit pungana nasuyop. Pinukaw dat disipulus na ot kinnanan da kan siya un, “Mistulu, naid kad kokwa na kan sika nu maḻmos taku?” ");
INSERT INTO kmk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Gummangun si Jesus ot pinaginok na dit bayogbog asina kinnanan sit danum un, “Ustu nan, guminok ka.” Naida tuttuwa dit bali ot gumminok dit maḻukuḻukuta paḻuung. ");
INSERT INTO kmk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Utdi kinnanan Jesus sidat disipulus na un, “Apay kumimut kayu? Maid kad pammati yu kan sakon?” ");
INSERT INTO kmk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Taḻona nasnasdaaw da kan siya ot nampaim-imkaw da un, “Ngad kad nin dituwa tagu’n ulay dan bayogbog kan danum tuttuwaon da tun ibaga na?” ");
INSERT INTO kmk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Utdiyon dummangpot da utdit domang dit bananaw un lakub din ili’d Gerasa. ");
INSERT INTO kmk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Utdit makalosa da Jesus sit bangka, inggaw osa’n tagu’n sinakayan di nadadaga ispiritu un nanligwat sit kalobḻobonan un ummoy ummabot. ");
INSERT INTO kmk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Siya’d inggawana dit kalobḻobnan ot maidon makapingil kan siya’t dit bilog na ulay itakod da si kinawad. ");
INSERT INTO kmk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kanayun un pingilon da dat ima na kan da iki na si lubid kan kinawad yoong aminona’n pugsaton. Naid makapaginok kan siya ta nabilog. ");
INSERT INTO kmk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Labi kan aḻ-aḻgawa manliklikwosa lawa’t dit kalobḻobonan, kanana pay sit bateled un mampappakuy ot dunudunuḻona pay dit long-ag na si batu. ");
INSERT INTO kmk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maotap na man si Jesus, nanoddaka umoy nampalintumong sit atubang na. ");
INSERT INTO kmk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ot kapakpakuyana un kanana’n, “Jesus un Anak Apudyus un kangattuwan apay lingalingom sakon? Isapatam kan Apudyus un adiyanak dusaon.” ");
INSERT INTO kmk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Inugud na di ta imbagan Jesus kan siya un, “Sika’n nadadaga ispiritu, taynam nat tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Inimus Jesus un, “Sinnat ngadan nu?” “Sakon si Sin-amaḻan onta aduadu kami,” kinnanan dit nadadaga ispiritu. ");
INSERT INTO kmk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ot nampakpakaasi kan Jesus ta adina paatunon dida’t diya ili. ");
INSERT INTO kmk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Inggaw da ud sin-amaḻana boḻok un manubsubsubuk sit bakḻas dit bateleda adani kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ot nampakpakaasi dat dimunyu kan Jesus un kanan dan, “Paoyon dikami ullawa’t dan boḻok ta dida’d sakayan mi.” ");
INSERT INTO kmk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pinalubusan Jesus dida. Ot tinengyan dat nadadaga ispiritu dit tagu ot ummoy da nilumnok sidadit boḻok. Utdiyon, nanggugunod dadit umoya duwa’n libu un boḻok un kaysan sit gassud ot naotdag da utdit bananaw ot naḻmos da un losan. ");
INSERT INTO kmk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sadat sin-ayyuwan sidat boḻok, nampatodtoddak da un ummoy nangipadamag sit naipasamak sidat tagu’t dit ili kan adani un boboḻoy. Magngoḻ man dat tagu, ummoy da ta ilan da nu ngadan dit napasamak. ");
INSERT INTO kmk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dumatong da man kan Jesus, naila da dit tagu’n sinakayan dat adu’n nadadaga ispiritu un mantutupak kan nabadutan ot nabaḻuwon dit angos na un bokona kama’t dit. Ot gaputa kama’t di ummogyat da. ");
INSERT INTO kmk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sadat nakaila impadamag da dit naipasamak sit tagu’n sinakayan dat dimunyu kan sadat boḻok. ");
INSERT INTO kmk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ot nampakpakaasi dat tagu kan Jesus ta tengyana dit boboḻoy da. ");
INSERT INTO kmk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ot utdit umoy si Jesus manlugan sit bangka, nampakpakaasi dit tagu un maibuḻun kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yoong madin Jesus impalubus un kanana’n, “Manaḻan ka utdin boboḻoy yu ta umoy ka ibaga’t dan buḻun nu dat kingkingwan Apudyus kan nangkakaasi na kan sika.” ");
INSERT INTO kmk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ot kaysan dit tagu utdat losana boboḻoy sidin Decapolis ot impatigammu na dit kingwan Jesus kan siya ot nasnasdaaw dat losana tagu’n nangngoḻ sit imbaga na. ");
INSERT INTO kmk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nambangka uman da Jesus un nandoḻmang sit domang ot dumangpot da man, inammung dat aduadu’n tagu si Jesus sidit dupit dit baybay. ");
INSERT INTO kmk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Utdi, dummatong dit osa’n pangaton da utdit sinagoga un mangngadan kan Jairo. Ot utdit naila na si Jesus ummoy nampalintumong sit atubang na. ");
INSERT INTO kmk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ot nampakpakaasi un kanana’n, “Awad dit anak ku un babai’n matmattoyan. Pangngaasim ta umoy nu agpadan daḻapnu kumiya kad matagu.” ");
INSERT INTO kmk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naibuḻun si Jesus kan Jairo un kaysan ot madabdabbil dat tagu’n naitung-ud kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Inggaw pay osa’n babai’n kagwampuḻu’t duwa’n dagunon un makaddaḻadaḻa. ");
INSERT INTO kmk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aduwon dat ummoyana nampaagasan ot adu pay dat sinagapaḻ na utdit mampappaagasana kan nagastu na payon amin un pilak na yoong naida taḻon kummiyaana nu adi naam-amodota lawa. ");
INSERT INTO kmk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nadamag na dit maipanggop kan Jesus isunga nakasuppenget sidadit amoda tagu un ummoy sit awid Jesus ot sinekgel na dit badut na. ");
INSERT INTO kmk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta kanana’t dit somsomok na un, “Ulay nu masekgel ku ullawa din badut na, kumiyaak.” ");
INSERT INTO kmk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ot dagusa naopdan dit daḻa na ot nagikna na un naidon dit sakit na. ");
INSERT INTO kmk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Dagusa nagiknan Jesus un awad pannakabalin un nauḻus kan siya ot nan-awinga kanana’t dat tagu un, “Singngadan din nanekgel situn badut ku?” ");
INSERT INTO kmk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kanan dat disipulus na un, “Apu, iillama adu’n tagu, imusom payyan nu ngad nat nanekgel sinat badut nu?” ");
INSERT INTO kmk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yoong nan-awwiawwing si Jesus ta inapona nu singngadan dit nanekgel. ");
INSERT INTO kmk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Utdi, naawatan dit babai un siya dit in-innapon Jesus gaputa tigammuna un naagasanon. Isunga mamilpilpila ummadani kan Jesus ta kumimut. Nampalintumong ot impudnu na un siya’d nanekgel sit badut na ot naagasanon. ");
INSERT INTO kmk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Utdi, imbagan Jesus kan siya un, “Anak ku, kummiya ka utnat sakit nu gapu’t nat pammatim kan sakon. Manaḻan kaona kapkapiya ta naidon nat sakit nu.” ");
INSERT INTO kmk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sissiya payyan si Jesus un mambagbagbaga utdit dumatong dat nanligwat sit boḻoy Jairo ot imbaag da kan siya un, “Natoyon dit abeng nu, koom payyana lawa un lingalingon nat mistulu,” kanan da. ");
INSERT INTO kmk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nagngoḻ Jesus di un imbaga da yoong adina winiliwili ot imbaga na kan Jairo un, “Adika madanagan basta manuttuwa ka ullawa kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Adin Jesus impalubus un awad maitung-ud kan dida malaksig kan Pedro kan da Santiago kan Juan un mansunud. ");
INSERT INTO kmk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sumaaḻ da man sit boḻoy Jairo, nailan Jesus dadit mampaalipangdasan ot mampaibila manlamat dat tagu. ");
INSERT INTO kmk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lumnok man kanana kan dida un, “Apay mampaalipangdasan kan mampaibil kayu? Bokona natoy nat abeng, masusuyopa lawa!” ");
INSERT INTO kmk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Inyaamang da si Jesus. Yoong pinaḻaksun na dida asina inayagan dit ama kan inan dit abeng kan dat tuḻu’n disipulus na ot nilumnok da utdit daḻom un ininggawan dit abeng. ");
INSERT INTO kmk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Inaggoman Jesus dit iman dit abeng ot kinnanana un, “Talita kumi!” Sat piyaona’n ugudon, “Abeng, ibagak kan sika un gumangun ka.” ");
INSERT INTO kmk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dagusa gummangun dit abeng ot kummiyang ta kagwampuḻu’t duwa’n tawon naon. Taḻona nasnasdaaw da utdit napasamak. ");
INSERT INTO kmk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ot imbilibilin Jesus kan dida un masapula naid udum si mangibagbagaan da utdi un kingwa na. Ot imbagana un pakanan da dit abeng. ");
INSERT INTO kmk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tinengyan Jesus diya boboḻoy ot nangulin sin boboḻoy na ud Nazaret un naitung-ud pay dat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aḻ-aḻgaw man un iillongan, ummoy si Jesus nantudtudu’t dit sinagoga ot nasnasdaaw dat aduadu’n tagu’n nandongoḻ sit tudtudu na ot kanan da un, “Nangaḻ-an ditu uttun tigammu na? Ngadan tun nangaḻ-ana uttun silib na kan pannakabalin na un man-am-amug? ");
INSERT INTO kmk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bokon kada sadit kalupantel un anak Maria kan sunud da Santiago, Jose, Judas kan Simon? Inggaw da paya losan situ dat susunud na un babai.” Ot adin dat tagu maawat si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Utdi kinnanan Jesus kan dida un, “Madayaw nat propetan Apudyus sidat losana umoyana malaksig sidat mismu’n kailiyana, kabagiyana kan kaboḻoy na.” ");
INSERT INTO kmk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Siya’d gapuna un adin Jesus nangwa’t nakaskasdaaw sidi malaksig sidat akita lawa’n masakita inagpadana ot kummiya da. ");
INSERT INTO kmk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nasnasdaaw si Jesus sit adin dat kailiyana manuttuwaan kan siya. Ot dinakdak Jesus dat kailin-ili un ummoy nantudtudu. ");
INSERT INTO kmk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pinandatdatong Jesus dat kagwampulu’t duwa’n disipulus na ot sinindogwa na dida ta ibaun na dida un umoy manudtudu. Initdana dida si kalintogana mangaddag si nadadaga ispiritu. ");
INSERT INTO kmk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Utdit daan da un manaḻan binilin na dida un maid taḻon idallay da nu adi abusa lawa’n suḻkud. Adida mambaḻun si kanon da, adida mangawit si pasiking onnu mambulsa’t pilak. ");
INSERT INTO kmk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mabalina man-usal da si sandalyas yoong adida mangaḻa’t badut si mansukatan da. ");
INSERT INTO kmk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Imbagana pay kan dida un, “Nu awad mamaḻnok kan dikayu utnat boboḻoya ayan yu, siya’d inggawan yuwon inggana’t taynan yu diya ili. ");
INSERT INTO kmk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu awad boboḻoy un naid mamaḻnok kan dikayu kan adida dongḻon nat itudtudu yu, tengyan yu diya boboḻoy ot ikagkag yu dat gabu utdat iki yu si bintaga un madusa da ta sinumdiyan da dat itudtudu yu.” ");
INSERT INTO kmk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Utdi kaysan dat disipulus Jesus un ummoy nangitudtudu’t dat tagu un masapula mandadaoliyan da dat basuḻ da ot igongda daona mambasbasuḻ. ");
INSERT INTO kmk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Inaddag da dat dimunyu utdat tagu un sinakayan da kan adu pay dat inapḻusan da si lana un masakit ot kummiya da. ");
INSERT INTO kmk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nagngoḻ ali Herodes dit maipanggop sit kokkoon Jesus ta nandinadinamag. Kanan dat udum un, “Ummungaḻ si Juan un Mambubunyag! Siya’d gapuna un awad pannakabalin na un mangwa’t nakaskasdaaw.” ");
INSERT INTO kmk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yoong kanan dat udum pay un, “Si Elias.” Ot sadat udum payyan kanan da un, “Osa un propetan Apudyus un kama payon sidat propetana utdit aw-awe.” ");
INSERT INTO kmk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yoong magngoḻ man Ali Herodes dit ibagbagan dat tagu kanana un, “Si Juan un Mambubunyag un pinaputuḻ ku dit bagang na yoong ummungaḻ!” ");
INSERT INTO kmk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kama’t di dit imbagan Herodes ta siya’d nampadopap kan nampaibaḻud kan Juan sidit. Kingwa na di un impagapu na kan Herodias un asawan Felipe un sunud na un inasawa na. ");
INSERT INTO kmk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ta si Juan, kanayuna ibaga na kan Herodes un, “Iyadin dit lintog taku’n asawaom nat asawan nat sunud nu.” ");
INSERT INTO kmk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Siya’d gapuna un laweng dit angos Herodias kan Juan ot piyaona’n papatoy. Yoong maid makwaana ");
INSERT INTO kmk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ta umogyat si Herodes kan Juan ta tigammu na un nalintog kan nasantuwana tagu. Isunga tataḻḻakugona. Ot ulay nu makapabulung kan siya dat itudtudun Juan, pipiyaona un dongḻon. ");
INSERT INTO kmk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yoong dummatong dit gundaway Herodias. Utdit timpu’n aḻgawa naiyanakan Herodes nan-amung da ot inawis da dat oopisyal di gubilnu, oopisyal di suldadu kan dat nangangatu un tagu’t din Galilea. ");
INSERT INTO kmk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Utdiya amung ummoy nanadok dit baḻasanga anak da Herodias kan Felipe ot nasnas-om da Herodes kan dat sangaili na. Ot kanan Herodes sidit baḻasang un, “Losana piyaoma kodawon kan sakon, itdok kan sika.” ");
INSERT INTO kmk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Insapatana un, “Singngadan na man un kodawom, itdok ulay nu sat kagogwan ditun mantulayak!” ");
INSERT INTO kmk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Utdi, ummoy yan nantukug dit baḻasang sidit ina na ot kanana’n, “Ngadan kadnin nat kodawok kan siya?” Kanan dit ina na un, “Kodawom dit uḻun Juan un Mambubunyag.” ");
INSERT INTO kmk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Utdi, inni-iway na un nan-ulin kan ali Herodes ot imbaga na kan siya un, “Piyaok un itdom kan sakon situn satun dit napalatu un uḻun Juan un Mambubunyag.” ");
INSERT INTO kmk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Taḻona nasigasigab dit angos ali Herodes yoong adina mabalina adi tungpaḻon gapu’t dit sapata na kan dingngoḻ dat sangaili na. ");
INSERT INTO kmk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ot nangibauna dagus si suldadu’t umoy mangaḻa’t dit uḻun ud Juan. Kaysan dit suldadu un umoy namutuḻ sit uḻun Juan sit babaḻḻudan. ");
INSERT INTO kmk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Utdiyon indatong na dit napalatu’n uḻun Juan ot intod na utdit baḻasang. Asin payon dit baḻasang intod kan ina na. ");
INSERT INTO kmk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Matigammuwan man dat disipulus ud Juan dit naipasamak ummoy da innaḻa dit ladag Juan un innilbon. ");
INSERT INTO kmk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Utdit nangulin dat kagwampuḻu’t duwa’n disipulus un imbaun Jesus, imbaga da kan siya dat losana kingkingwa da kan intudtudu da. ");
INSERT INTO kmk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yoong gaputa masukasukata dumatong dat un-unaya tagu un adida pay mawili un mangan, kinnanan Jesus sidat disipulus na un, “Takun, ta umoy taku man-ila’t igawa maid tagtagguwan si man-illongan taku’t akit.” ");
INSERT INTO kmk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Utdi nambangka da un kaysan un dida’l lawa utdit igawa maid tagtagguwan. ");
INSERT INTO kmk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yoong adu dat nakaila utdit kaysanan da ot naimatunan da dida. Kadon, nampatodtoddak dat tagu un nanligwat sit kailin-ili ot inunaan da da Jesus un dummatong. ");
INSERT INTO kmk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dumangpot man da Jesus naila na dat aduadu’n tagu. Nadaguwan kan dida ta kama dat kannelu un maid man-aayyuwan kan dida. Ot inlugina’n nanudtudu ot adu dat intudtudu na kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Utdit gumidgidamon, ummoy dadit disipulus na kan siya ot kanan dan, “Masdomon, naid pay tagtagguwan situ. ");
INSERT INTO kmk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Padaḻnom dan tagu ta umoy da utdan adani’n boboḻoy gumatang si mabalin da un kanon.” ");
INSERT INTO kmk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yoong summungbat si Jesus un, “Dikayu’d mangitod si kanon da.” Kanan dat disipulus na kan siya un, “Umoy kami nin gumatang si tinapaya banol di duwa’n gasuta denario un ipakan mi kan dida?” ");
INSERT INTO kmk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Inimus Jesus kan dida un, “Piga dit tinapay yu un awad sinat? Umoy yu ud ilan.” Ummoy da inila asida impatigammu kan Jesus un, “Awad lima’n bukoḻa tinapay kan duwa’n ikan.” ");
INSERT INTO kmk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kadon imbilin Jesus sidat disipulus na un mantupakon da dat tagu un mauḻ-uḻmung da utdit kabollatan. ");
INSERT INTO kmk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Utdi, nanlekus da un nauḻ-uḻmung si singgagasut kan sinlilimampuḻu. ");
INSERT INTO kmk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inaḻan Jesus dit lima’n bukoḻa tinapay kan duwa’n ikan ot nantangad langit un nanyaman kan Apudyus, asina biniibiik dida’n intod sidat disipulus na ta iwaḻas da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ot losan da un nabsuga nangan. ");
INSERT INTO kmk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sinupon da man dat nabun-ana tinapay kan ikan, napnu dat kagwampuḻu’t duwa un lakba. ");
INSERT INTO kmk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Umoya lima’n libu dat laḻaki’n nangan un adina naibilang dat babai kan abeng. ");
INSERT INTO kmk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Maabus man di, dagusa pinanlugan Jesus dat disipulus na utdit bangka ta umuna da ud Betsaida utdit domang didit bananaw, sidit mampadaḻnana utdat adu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mangkadaḻan man dat tagu, nanagada si Jesus sit bateled daḻapnu manluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Utdit lumabiyon inggawon dit bangkan dat disipulus Jesus sit adani’t dit gawan dit baybay, yoong iinggaw payyan si Jesus sit bateleda ossaan. ");
INSERT INTO kmk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Naotap na dat disipulus na un mampaligata managwan sit bangka da, onta dupakon dit bayogboga amod dida. Bungbung-on man, kummiyang si Jesus sit lap-at dit danuma ummadani kan dida ot panggop na un lausan dida. ");
INSERT INTO kmk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yoong mailan man dat disipulus dit mangkikkiyang sit lap-at dit danum, kanan da nu banig ot nakapakuy da ");
INSERT INTO kmk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ta amoamod dit kimut da. Yoong dagusa gumminga’t Jesus un kanana’n, “Adi kayu kumimut ta sakon. Adi kayu madanagan!” ");
INSERT INTO kmk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Utdi nakalugan si Jesus kan dida ot kakḻata naid dit bayogbog. Taḻona nasnasdaaw dadit disipulus na, ");
INSERT INTO kmk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","onta adida naawatan nu singngadan ud Jesus sidit nampaaduwana utdit tinapay gaputa ginumḻang payyan dit uḻu da. ");
INSERT INTO kmk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Utdit makadoḻmang da, dummangpot da utdin boboḻoy Genesaret. Insilu da dit bangka da utdit dupit. ");
INSERT INTO kmk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lumsa da man sit bangka dagusa naimatunan dat tagu si Jesus, ");
INSERT INTO kmk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ot nampatodtoddak da un ummoy nangibaga’t dat losana tagu’t diya nangkalliputa boboḻoy. Ot binuligan da dat masakit kan dida un indatong sit singngadan na man un dingngoḻ da un kawadan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Singngadan na man un boboḻoy onnu ili’n ummoyan Jesus, nan-idatong da utdat masakit sidit uummungan di tagu un mabalina ayon Jesus. Nampakpakaasi da kan Jesus ta ipalubus na un sekgelon dat masakit dit badut na ulaya lawa’n sat lagayadana. Ot losan dat nanekgel, kummiya da. ");
INSERT INTO kmk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nandadatdatong da kan Jesus dat Fariseo kan dat mimistulun di lintog un nanligwat Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ot naila da un sadat uduma disipulus Jesus adida binuḻuwan dat ima da utdit kadawiyana mambubuḻun dat Judio asida mangan. ");
INSERT INTO kmk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ta sadat Judio taḻon sidat Fariseo, adida mangan nu adida yan koon dit kadawiyan da un mambubuḻu un tinawid da utdat dadakkoḻ da. ");
INSERT INTO kmk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Padana pay un nu mangulin da un manligwat sit laḻakkuwan adida mangan nu adida yan koon diya kadawiyan da un mambubuḻu kan adu pay dat kadawiyana tinawid da un uunnudon da un padan din mangkikiwas da utdan tasa, banga kan da kandelu da. ");
INSERT INTO kmk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ot gaputa kama’t di, inimus dat Fariseo kan dat mimistulun di lintog kan Jesus un, “Apay danat disipulus nu un adida unudon dit kadawiyan un mambubuḻu un impatawid dat dadakkoḻ taku? Ta mangan da un adida yan mambuḻu.” ");
INSERT INTO kmk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Summungbat si Jesus un, “Tuttuwa dit paimpadtun Apudyus kan Isaias maipanggop kan dikayu’n man-ag-agin un kanana’n, ‘Sadatuwa tagu, dayawon da ud sakona lawa si bagbaga yoong adayu dit aangson da kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Maid selselbin dit mandayawan da kan sakon gaputa itudtudu da dat lintoga kingwan di tagu ot ibilang daon un bilin ku.’ ");
INSERT INTO kmk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Tuttuwa di ta inwalin yu dat bilin Apudyus ot sadat lintoga kingwan dat tagu dat uunnudon yu. ");
INSERT INTO kmk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Nalaing kayu un mansumdi utdit bilin Apudyus daḻapnu maitultuluya maunud dat kadawiyana naipatawid kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ta kanana’t dit bilina ingkanglit Moses sidit un, ‘Dayawom da amam kan inam,’ kan kanana pay un, ‘Sanat mangibaga’t laweng sit ama na onnu ina na, masapula mapatoy.’ ");
INSERT INTO kmk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yoong sanat itudtudu yu kanan yu un sat tagu’n mangibaga kan ama na onnu ina na un, ‘Korban dit ituḻung ku kan dikayu,’ (piyaona’n ugudon maitod kan Apudyus,) ");
INSERT INTO kmk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","adinaon masapula tumuḻung kan ama na onnu ina na. ");
INSERT INTO kmk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ot maipagapu utdiya itudtudu yu, inwalin yu dit ugud Apudyus gapu utdat kadawiyana ipatawid yu utdat tagu. Adu dat udum payyana kama’t datu un kokkoon yu,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Utdi, inayagan Jesus uman kan siya dat adu’n tagu ot kinnanana kan dida un, “Dumngoḻ kayu’n losan situn ibagak ot ammaan yu un anagon. ");
INSERT INTO kmk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bokona siya’d mampadadag si tagu utdit man-iilan Apudyus dit ipaḻnok na utdit sangi na, nu adi sat manligwat sit aangsona. ");
INSERT INTO kmk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nu awad inga yu un makagngoḻ, dumngoḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tinengyan Jesus dat aduadu’n tagu ot kaysan sit boḻoy. Ummoy dat disipulus na inimus nu ngadan dit kaipooyan dit inyabalig na. ");
INSERT INTO kmk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ot kanan Jesus kan dida un, “Apay pati kan dikayu adi kayu makaawat? Adiyu kad tigammu un bokona sat kanon di tagu ud makabasuḻana ");
INSERT INTO kmk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ta bokona manaḻan sit somsomok na nu adi manaḻan sit buwang na asi uman lumaksun?” (Sadiya imbagan Jesus, impatigammu na un losana makan, mabalina kanon di tagu.) ");
INSERT INTO kmk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ot intuluy Jesus un, “Sat manligwat sit aangson di tagu siya’d mampadadag kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta sat aangson siya’d manligwatan dit losana nadadaga somsomok di tagu un mangidulun kan siya’n mangwa utdan koko-on di man-asawa utdit daan na payyan maasaw-an, man-akaw, kumatoy, makadagdagas, ");
INSERT INTO kmk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","man-agum kan manomsomoka mangwa’t nadadag sidan udum, mangallilaw, manlabḻabos un gangganas, umaapaḻ, man-ugud si lawenga maisuganggang sidan udum, manaktakkaḻ kan uduma bokobokona koko-on. ");
INSERT INTO kmk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","“Sadatu un losana nadadaga koko-on, manligwat da utdit aangson di tagu ot dida’d mampadadag kan siya utdin man-iilan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Utdi tinengyan Jesus diya boboḻoy ot kaysan sin adani’d Tiro kan Sidon. Dumatong man, nakaigaw sit osa’n boḻoy. Adina piyaon nu tigammuwon dat tagu dit inggawana’t di. Yoong natigammuwan da kampay. ");
INSERT INTO kmk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ta inggaw babai un sinakayan di nadadaga ispiritu dit anak na un babai ot magngoḻana man un dummatong si Jesus, dagusa inummoy kan siya ot nantalluku utdit sanguwana’n nampakaasi. ");
INSERT INTO kmk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Satuwa babai bokona Judio ta kaganakan di iFenicia un osa’n ili’d Siria ot Griego dit bagbaga na. Impakaasi na un addagon Jesus dit dimunyu’t dit anak na. ");
INSERT INTO kmk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Inyabalig Jesus un nangibaga kan siya un, “Unaon taku yan pakanan dat abeng ta bokona kalobbongana’n ikob-aḻ ta utdanat asu dit kanon di abeng.” ");
INSERT INTO kmk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Tuttuwa nat Apu,” insungbat dit babai. “Yoong ulay danat asu utnat sogwab di lamesaan kanon da danat bugtan di abeng.” ");
INSERT INTO kmk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ot kinnanan Jesus kan siya un, “Gapu utnata imbagam, mabalina manaḻan kaon ta tinengyanon dit dimunyu dit abeng nu.” ");
INSERT INTO kmk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Utdi nangulin dit babai utdit boḻoy da ot dinakngana dit abeng un uumboga kapkapiya ta tinengyanon dit dimunyu. ");
INSERT INTO kmk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Utdiyon tinengyan Jesus ud Tiro ot nangulin sin igid din bananaw sidin Galilea un inoy na ud Sidon kan sadat boboḻoya mangngadan Decapolis. ");
INSERT INTO kmk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Inggaw da ud tagu’n nangidatong si laḻaki un nabongngog kan naumoḻ pay ot nampakpakaasi da kan Jesus ta iyagpad na dit ima na kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Inyadayun Jesus dit laḻaki utdat tagu ot makaadayu da man, insuḻong Jesus dat pagayyamot na utdat ingan dit laḻaki asina nanlugpa ot inapḻusana dit dilan dit laḻaki. ");
INSERT INTO kmk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nantangad si Jesus ud langit ot nakasinta’n kanana’n, “Epfata.” Satun piyaona un ugudon tu, “Mambukat ka.” ");
INSERT INTO kmk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dagusa nambukat dat inga na ot makagngoḻon dit laḻaki kan lummum-oy dit dila na ot nanggodongon dit mambabagbaga na. ");
INSERT INTO kmk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Utdi binilin Jesus dat tagu un adida ibagbaga tuwa kingwa na. Yoong bilibilinona kad dida amodota inwalwalagawag da dit naila da un kingwana. ");
INSERT INTO kmk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Taḻona nasnasdaaw da un losan ot kanan da un, “Laulaus un losan dan kokkoona. Padongḻona pay danat nabongngog kan mambagbagaona danat naumoḻ.” ");
INSERT INTO kmk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Utdiya timpu un ininggawan Jesus sidi, nandatdatong uman dat aduadu’n tagu. Ot utdit maidon kanon da, inayagan Jesus dadit disipulus na ot kinnanana kan dida un, ");
INSERT INTO kmk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Madaguwanak sidatu’n tagu ta tuḻu’n aḻgaw daon un iniinggaw kan ditaku’t tu ot naidon kanon da. ");
INSERT INTO kmk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu padaḻnok dida’t dan boḻoy da un mabibittil, matalimudaw da utdin daḻan ta adayu tun nanligwatan datun udum.” ");
INSERT INTO kmk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Summungbat dat disipulus Jesus un, “Mangaḻ-an si ipakan sidatu’n aduadu’n tagu uttun igawa maid tagtaguwan?” ");
INSERT INTO kmk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Piga dit tinapay yu un awad sinat?” kanan Jesus kan dida. Ot kanan da un, “Pitu’n bukoḻ.” ");
INSERT INTO kmk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pinantupak Jesus dat tagu’t dit pita. Utdi, innaḻa na dat pitu’n bukoḻa tinapay ot nanyaman kan Apudyus. Maabus man un manyaman biniibiik na dit tinapay asina intod sidat disipulus na ot inwaḻas da utdat adu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Inggaw da pay akita ikana banan-og ot nanyaman uman kan Apudyus asina intod sidat disipulus ta iwaḻas da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Losan da un nabsuga nangan. Ot sinupon man dat disipulus na dat buna, napnu dat pitu’n lakba. ");
INSERT INTO kmk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Umoya opata libu’n tagu dat nangan. ");
INSERT INTO kmk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Utdiyon pinadaḻan Jesus dat adu’n tagu asida un dagus nambangka utdat disipulus na un kaysan Dalmanuta. ");
INSERT INTO kmk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Inggaw da ud dummatonga Fariseo un ummoy nakasinsinnungbat kan Jesus ta panggop da un ok-okabon. Ot kindaw da un mangipaila’t am-amug si mangilasinan nu imbaun Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ot ummangos si nadaḻom asina kinnanan kan dida un, “Apay datun tagu’t tuwa lonap un man-inap da ut am-amug si mangilasinan nu imbaunak kan Apudyus? Tuttuwa tun ibagak un adik mangipaila’t am-amug si mangilasinan yu.” ");
INSERT INTO kmk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ot tinengyan Jesus dida ot nanlugan da utdit bangka’n kaysan sit domang. ");
INSERT INTO kmk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naliuwan dat disipulus Jesus un nambaḻun si tinapay ot simbukoḻa lawa dit inggaw kan dida’t dit bangka da. ");
INSERT INTO kmk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Binagaana dida ot kanana’n, “Mansiput kayu ot alimbanan yu dit bubud dan Fariseo padana pay kan Herodes.” ");
INSERT INTO kmk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yoong gaputa adida naawatan dit kaipooyan dit imbaga na, kanan da un, “Siya’d imbaga na di ta maid tinapay taku ussiya.” ");
INSERT INTO kmk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Titiggammun Jesus dit babagbagaon da ot kanana kan dida un, “Apay un sanat kamaid di tinapay yu nat babagbagaon yu? Adiyu kad payyan maawatan un awad pannakabalin ku? Ginumḻang kad nat uḻu yu? ");
INSERT INTO kmk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Adi kayu kad makaila ya annat ata yu? Adi kayu kad makagngoḻ ya annat inga yu? Naliuwan yu kadon dit ");
INSERT INTO kmk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","namiikak sit lima’n bukoḻa tinapaya impakan sidat lima’n libu un tagu, piga’n lakba dit nabun-an un sininup yu?” Kanan da un, “Simpuḻu’t duwa un lakba.” ");
INSERT INTO kmk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ot utdit biniibiik ku dat pitu’n bukoḻa tinapaya impakan sidat opata libu un tagu, piga’n lakba dat nabun-ana sininup yu?” kinnanan Jesus. Kanan da un, “Pitu’n lakba.” ");
INSERT INTO kmk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Utdi kinnanan Jesus kan dida un, “Adiyu kad payyan maawatan?” ");
INSERT INTO kmk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Utdi kaysan da Jesus ud Betsaida. Dumatong da man, inggaw da ud nangisaaḻ si tagu’n nakuḻap ot nampakpakaasi da kan Jesus un agpadana. ");
INSERT INTO kmk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Utdi kiniwid Jesus dit nakuḻap ot indaḻan na utdit lasin dit boboḻoy. Nilugpaana dat ata na asina inagpadan ot inimus na un, “Awad mailam?” ");
INSERT INTO kmk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mandiyat man dit laḻaki kanana un, “Makailaak si tagu yoong kama da si kayu un mangkikkiyang.” ");
INSERT INTO kmk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inagpadan payyan Jesus dat atan dit laḻaki. Utdit tumukkoḻ dit laḻaki kummiyaon dat ata na. Napaddaon dit man-iila na. ");
INSERT INTO kmk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Utdi, pinadaḻan Jesus dit laḻaki un kanana’n, “Mandadawwos ka utdin boḻoy yu ot adim ayonon nat boboḻoy.” ");
INSERT INTO kmk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Utdiyon inummoy da Jesus kan dat disipulus na utdat boboḻoya lakub Cesarea Filipos. Utdit manaddaḻanan da utdi, inimus Jesus sidat disipulus na un, “Singngadan ku utdit makanan dat tagu?” ");
INSERT INTO kmk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Summungbat da un, “Sika kanu si Juan un Mambubunyag. Kanan pay dat udum un sika kanu dit Elias yoong sadat udum payyan kanan da un osa ka utdat propetan Apudyus sidit aw-awe.” ");
INSERT INTO kmk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Dikayu nu, singngadan ku utnat makanan yu?” inyimus Jesus. Summungbat si Pedro un, “Sika dit Kristu.” ");
INSERT INTO kmk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ot binilin Jesus dida un adida ibagbaga si udum dit maipanggop kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Utdiyon inlugin Jesus un ipatigammu utdat disipulus na un siya un Inyanak di Tagu, masapula sagapaḻona’d adu’n ligat. Sumdiyan dat lalallakay di Judio, aap-apun di padi kan mimistulun di lintog ot mapatoy yoong umungaḻ nu lumabas tuḻu’n aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nalawag dit nan-iibaga na uttu kan dida. Utdi indallay Pedro si Jesus sit ad-adayu ot inggimau na. ");
INSERT INTO kmk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yoong summangu si Jesus ot ummila utdat disipulus na asina inggimau si Pedro un, “Adayuwanak Satanas! Ta bokona sat piyaon Apudyus nat sosomkom nu adi sat piyaon di tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Inayagan Jesus dat tagu kan siya pati utdat disipulus na ot kinnanana un, “Nu sinnat mamiya un maidagamung kan sakon, masapula igongda naona somsomkon dit mataguwana uttun pita, bukudona nat kulus na asi umunud kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta sanat tagu’n gumamgam sit mataguwana’t tun pita, adina maitdan si mataguwana’t inggaingga. Yoong sat tagu’n mataḻak na dit mataguwana maipagapu’t manuttuwaana kan sakon kan mangitudtuduwana’t din Nabaḻu’n Damag maipanggop kan sakon, maitdan si mataguwana’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta ngadan nat maganab nat osa’n tagu nu mangkuwa na dan losana binaknang situn lubung yoong mataḻak na dit mataguwana’t inggaingga? Naid. ");
INSERT INTO kmk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ta maid mabalina maitod di tagu si kasukat din mataguwana. ");
INSERT INTO kmk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nan-awidan dan tagu’t tuwa lonap si Apudyus ot sadan sinan-apudyus ud dayawon da kan taḻona gumabasuḻ da. Ot singngadan na man kan dida dit mangibain kan sakon padana pay sidan tudtuduk, sakona Inyanak di Tagu ibain ku pay nu mangulinak situn pita. Ta mangulinaka awad kan sakon dit nakaskasdaawa kinangatun Amak ot buḻun ku dat nasantuwana aanghel.” ");
INSERT INTO kmk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Utdi, kanana un, “Tuttuwa tun ibagak un awad kan dikayu un antu uttun satun ud adi yan matoy inggana’t maila da dit dumakngan dit mangiyapuwan Apudyus kan sat pannakabalin na.” ");
INSERT INTO kmk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lumabas man onoma aḻgaw, indallay Jesus da Pedro, Santiago kan Juan un nanagada’t dit nangatu’n bateled un dida ullawa. Inggaw da man sidi, naobos dit ilan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sadit badut na manilisiling dit kapoḻkas na un naidon makapapoḻkas situn lap-at pita. ");
INSERT INTO kmk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ot kakḻata nailan dat tuḻu’n disipulus da Elias kan Moses un makabagbagbaga kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kinnanan Pedro kan Jesus un, “Apu, napiya ta antu taku’t tu. Mangwa kami si tuḻu’n sigay ta mangkuwam nat osa, mangkuwan Moses nat osa kan mangkuwan pay Elias nat osa.” ");
INSERT INTO kmk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kanana ullawa di ta naid tigammu na si ibaga na utdit amoda kimut da. ");
INSERT INTO kmk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Utdi, kakḻata inggaw bunota nangayyung kan dida ot inggaw ginga’n nanligwat sit bunot un kanana’n, “Siyatu’d pipiyaoka Anak ku, dumngoḻ kayu kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dagusa ummila da utdit nangkalliput yoong naid sabali’t naila da nu adi abus si Jesus ullawa. ");
INSERT INTO kmk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Utdit madama’n gumusad da utdit bateled, binilibilin Jesus dida un adida ibagbaga’t udum dit naila da inggana’t sadit Inyanak di Tagu, umungaḻ kan katoy. ");
INSERT INTO kmk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tinungpal da dit bilin Jesus yoong mampaim-imus da nu ngadan dit piyaona’n ugudon dit imbaga na un umungaḻ kan katoy. ");
INSERT INTO kmk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ot inimus da kan Jesus un, “Apay kanan danat mimistulun di lintog un masapula umun-una si Elias un dumatong nu sadit Kristu nu?” ");
INSERT INTO kmk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Summungbat si Jesus un, “Tuttuwa’n masapula mauna si Elias un dumatonga umoy mangisagana’t dat losan. Ot ngadan nat makanan yu utdit naikanglit sit ugud Apudyus un sakona Inyanak di Tagu sagapaḻok dat adu’n ligat kan sumdiyanak sidat tagu? ");
INSERT INTO kmk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yoong ibagak kan dikayu un naabusona dummatong si Elias ot kingwan dat tagu dat singngadan na mana lawenga piniya da un kingwa kan siya un kama’t dit naikanglit sit ugud Apudyus un makwa kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Utdit dakngon da Jesus dat disipulus un natengyan, naila da dat aduadu’n tagu’n nangammung kan dida kan dat mimistulun di lintoga makasungsungbat kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mailan man dat tagu’n dumoḻdoḻdoḻ si Jesus, nasnasdaaw da ot nampatodtoddak da un umoy nangabat. ");
INSERT INTO kmk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Inimus Jesus un, “Ngadan nat mansisinnungbatan yu kan dida?” ");
INSERT INTO kmk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Osa’t dat kaaduwan dit summungbat un, “Mistulu, indallay ku tun anak ku kan sika ta sinakayan di nadadaga ispiritu ot adina makabagbaga. ");
INSERT INTO kmk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu sakayanon dit ispiritu matukas kan manlaḻabḻab tun sangi na, manggitil datun ngipon na kan kumtug tun long-ag na. Imbagak sidanat disipulus nu un addagon da yoong adida kabooḻan.” ");
INSERT INTO kmk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Summungbat si Jesus un, “Ay, naid pammati yu un tagu. Kamaan nat kabayag ku un iinggaw kan dikayu inggana’t manuttuwa kayu? Kan kamaan nat kaandun nat mangiyan-anusak kan dikayu? Idatong yu kan sakon nat abeng.” ");
INSERT INTO kmk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Indatong da kan Jesus dit abeng. Ot mailan man dit nadadaga ispiritu si Jesus, dagusa pinanwogowog na dit abeng ot natukasa nanduḻaduḻag un manlaḻabḻab dit sangi na. ");
INSERT INTO kmk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Inimus Jesus sit ama na nu kamaan dit kabayag dit gummiknaana. Ot kanan dit ama na un, “Manipud sit kaban-og na. ");
INSERT INTO kmk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kanayuna isubban dit ispiritu utdit apuy kan ilmos na utdit danum si mamatoyana kan siya. Ot nu kabooḻam, mangaasi ka ta tuḻungam dikami.” ");
INSERT INTO kmk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Nu kabooḻak, kanam?” kinnanan Jesus. “Maid adi makwa nu manuttuwa nat osa’n tagu kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dagusa impakuy dit aman dit abeng un, “On, manuttuwaak! Ot tuḻunganak situn kinakulang tun pammatik.” ");
INSERT INTO kmk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Utdit mailan Jesus dat adu’n tagu’n manodtoddaka umadani inggimau na dit nadadaga ispiritu un kanana’n, “Sika un ispiritu un nangumoḻ kan namongngog situ un abeng, bilinok sika un tengyam ot adi kaon manguliulin.” ");
INSERT INTO kmk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nampakuy dit ispiritu ot inwogowog na dit abeng asina tinengyan. Nagngat dit abeng un kama’t ladag dit ila na ot kanan dat kaaduwan un, “Natoy.” ");
INSERT INTO kmk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yoong inaggoman Jesus dit iman dit abeng un namangun ot summikad dit abeng. ");
INSERT INTO kmk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Utdit nilumnokon da Jesus pati utdat disipulus na utdit boḻoy, inimus da kan siya un dida’l lawa un, “Apay adimi maaddag diya nadadaga ispiritu?” ");
INSERT INTO kmk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Summungbat si Jesus un, “Maid makaaddag sinata ispiritu nu adi luwaḻu ullawa.” ");
INSERT INTO kmk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Utdi tinengyan da diya igaw ot nangoy da ud Galilea. Adin Jesus piyaon nu tigammuwon dat tagu dit inggawana, ");
INSERT INTO kmk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta isuḻsuḻu na dat disipulus na. Kanana kan dida un, “Sakona Inyanak di Tagu, dandaniyona maiyawatak sidat tagu. Patoyon da ud sakon yoong nu lumabas tuḻu’n aḻgaw, umungaḻak.” ");
INSERT INTO kmk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Adida naawatan dit kaipooyan dit imbaga na yoong ummogyat da un nangimus kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dummatong da ud Capernaum ot utdit inggaw da utdit daḻom boḻoy, inimus na utdat disipulus na un, “Ngadan dit mansisinnungbatan yu utdin daḻan?” ");
INSERT INTO kmk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yoong adida ginumgumminga onta babagbagaon da nu singngadan dit kangattuwan kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nantupak si Jesus ot inamung na dat kagwampuḻu’t duwa’n disipulus na asina kinnanan kan dida un, “Singngadan na mana mamiya un siya’d kangattuwan, masapula ipadoba na nat long-ag na inggana’t siya’d kadobaan kan masapula manselbi utdan losan.” ");
INSERT INTO kmk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Utdi, nangaḻa’t abeng si Jesus ot pinasikad na utdit gawa da. Binakwaḻ na dit abeng asina kinnanan kan dida un, ");
INSERT INTO kmk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Singngadan na man un mangawat si napakumbaba un padan ditu un abeng un ipagapu na kan sakon, sakon ud inawat na ot singngadan na man un mangawat kan sakon, bokona lawa’n sakon ud inawat na nu adi inawat na pay dit nangibaun kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kanan Juan kan Jesus un, “Mistulu, nakaila kami si tagu un man-addag si dimunyu un usalona nat ngadan nu. Yoong inyapa mi dit koona gaputa bokona buḻun taku.” ");
INSERT INTO kmk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yoong kinnanan Jesus un, “Adiyu iyapa ta maid mangkokwa si am-amug un usalona tun ngadan ku asi mambagbaga’t nadadaga maisuganggang kan sakon nu maabus. ");
INSERT INTO kmk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta singngadan na man un adi gumusuḻ kan ditaku, buḻun taku. ");
INSERT INTO kmk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tuttuwa tun ibagak kan dikayu un singngadan na man un mangtod si sintasa un danuma inumon yu gaputa tagu dikayu kan Kristu, maawat na un maawat dit gun-guna na un itdon Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Singngadan na man un maigapuwan di makabasuḻan di osa’t dat aabenga mamati kan sakon, un-unnaya lawa’n matakodan si dakoḻana gigillingana batu dit bagang na asi maidawat sin baybay. ");
INSERT INTO kmk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ot nu sanat imam dit maigapuwan di makabasuḻam, putdom! Un-unnaya lawa un osossaan nat imam un lumnok sin mataguwan si inggaingga nu sanat duwa nat imam un manaḻan sin impiyelnu un maid maksopan din apuy si inggaingga. ");
INSERT INTO kmk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ot nu sanat ikim nat maigapuwan di makabasuḻam, putdom! Un-unnaya lawa’n ossaan nat ikim un lumnok sin mataguwan si inggaingga, nu sanat duwa nat ikim un umoy sin impiyelnu. ");
INSERT INTO kmk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ot nu sanat atam nat maigapuwan nat makabasuḻam, tuwilom! Un-unnaya lawa’n ossaan nat atam un lumnok sin mangiyapuwan Apudyus nu sanat duwa nat atama maidawat sin impiyelnu. ");
INSERT INTO kmk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta utdin impiyelnu, adida matoy dan ogos un mangan kan dida kan adina maksop din apuy. ");
INSERT INTO kmk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Losan dan umunud kan sakon mansagapaḻ da si adu un ligata mamadas kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Naselbi nat asin nu mannanayun dit apgad na yoong nu mangkubay, naidon selbi na ta adinaon mabalina maiyulin dit apgad na. Padana un mannanayun okyan kan dikayu nat kababalin di osa’n umunud kan sakon daḻapnu naselbi kayu, kad mantutunus kayu.” ");
INSERT INTO kmk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tinengyan da Jesus diya boboḻoy ot ummoy da utdin lakub Judea utdin kapon domang din wangwang Jordan. Aduadu uman dat tagu’n nandatdatong kan siya ot tinudtuduwana dida un siya payon dit doda’n koko-ona. ");
INSERT INTO kmk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Inggaw da ud Fariseo un ummoy kan siya nan-imus daḻapnu padpadason da ot kanan dan, “Ipalubus kad dit lintog taku’n idangan dit laḻaki si asawa na?” ");
INSERT INTO kmk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Summungbat si Jesus un, “Singngad dit imbilin Moses kadot kan dikayu?” ");
INSERT INTO kmk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Summungbat da un, “Impalubus Moses un mangwa dit laḻaki si kasulatan dit man-idangan da, asina padaḻnon dit babai.” ");
INSERT INTO kmk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Summungbat si Jesus un, “Siya’d imbilin Moses kan dikayu di gaputa adi kayu matudtuduwan. ");
INSERT INTO kmk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yoong sidit luglugi’n namaloswaan Apudyus si tagu, kingwana dit laḻaki kan babai. ");
INSERT INTO kmk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ot kinnanan Apudyus un, ‘Siya’d gapuna un tengyan dit laḻaki da ama na kan ina na ta umoy sumip-un sit asawa na, ");
INSERT INTO kmk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ot mambalin da si osa.’ Utdi, bokonona duwa nu adi kama da’t ossaana long-ag. ");
INSERT INTO kmk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Isunga singngadan na mana pinansip-un Apudyus un man-asawa, maid tagu’t mabalina mangidang kan dida.” ");
INSERT INTO kmk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Utdit inggaw daon sit boḻoy, pinuut uman dat disipulus Jesus kan siya dit maipanggop sidiya banag. ");
INSERT INTO kmk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ot kanan Jesus kan dida un, “Sanat laḻaki’n umidang sinat asawa na ta mangasawa’t sabali, makabasuḻ sit poga’n asawa na si dagdagas. ");
INSERT INTO kmk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Padana pay un sat babai’n umidang sit asawa na ta mangasawa’t sabali, makabasuḻ pay sit asawa na si dagdagas.” ");
INSERT INTO kmk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Utdi, nan-idatong dat tagu utdat aabeng da kan Jesus daḻapnu agpadana dida’n bindisyunan yoong inggimaun dat disipulus Jesus dat tagu. ");
INSERT INTO kmk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yoong mailan man Jesus dit koon dat disipulus na nasuḻag ot kinnanana kan dida un, “Bay-an yu un umoy danat aabeng kan sakon, adiyu iyapa dida ta sadan kama kan dida dan manawid sin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tuttuwa tun ibagak kan dikayu un, nu adiyu awaton din mangiyapuwan Apudyus un padan din koon di abenga mangawat adi kayu maidagamung sidi.” ");
INSERT INTO kmk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Utdi, sinin-ossan Jesus binakwaḻ dat aabeng ot inyagpad na dit osa’n ima na un namindisyun kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Utdit manlaklakkat si Jesus un manaḻan, inggaw tagu’n nanoddaka ummoy nanalluku utdit sinagung na ot kanana’n, “Napiya’n Mistulu, ngadan nat masapula kook daḻapnu matawid ku dit mataguwana maid kigad na?” ");
INSERT INTO kmk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kanan Jesus un, “Apay kanama napiyaak? Maid udum si napiya nu adi si Apudyus ullawa. ");
INSERT INTO kmk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tigammum dat bilin un, ‘Adika kumatoy. Adika managdagas. Adika man-akaw. Adika mangkustigu si tuli. Adika mangkuluk. Dayawom da amam kan inam.’ ” ");
INSERT INTO kmk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ot kanan dit laḻaki kan Jesus un, “Apu Mistulu, tungtungpaḻoka losan danaton manipud sit kaban-og ku.” ");
INSERT INTO kmk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Naanggom dit angos Jesus un nangitukkoḻ sit laḻaki ot kanana’n, “Annat osa’n mangkulangama masapula koom. Umoy ka ilaku dat losana kukuwam ta asim itdon dit bayad na utdat nakapus kad awad binaknang nu ud langit, asikaon umunud kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Magngoḻ man dit laḻaki dit imbagan Jesus, nanduduuy ot kaysana madomdomdoman ta amod dit kinabaknang na. ");
INSERT INTO kmk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ummila’t Jesus sit nangkalliput asina kinnanan sidat disipulus na un, “Taḻona nasigaba makaḻnok danat baknang sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nasnasdaaw dadit disipulus Jesus sidit ugud na yoong imbagan uman Jesus kan dida un, “Ay aanak, taḻona nasigab nat lumnok sin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Naḻasḻasu un mangoy nat kamelyu’n dakoḻa ayam sinat abut di tanud nu sanat baknanga tagu’n lumnok sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Utdi, taḻona nasnasdaaw dat disipulus na ot kanan da kan siya un, “Singngadan dat mabalina taguwon Apudyus nu?” ");
INSERT INTO kmk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tummukkoḻ si Jesus kan dida’n dit summungbat un, “Adina makwa di nu tagu’d mangwa yoong si Apudyus kabooḻana’n mangwa’t dan losana banag.” ");
INSERT INTO kmk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Gumminga si Pedro un, “Dikami nu, un tinengyan mi dat losana kukuwa mi daḻapnu sika’d uunnudon mi?” ");
INSERT INTO kmk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kanan Jesus un, “Tuttuwa tun ibagak kan dikayu un singngadan na man un maneyan sit boḻoy na onnu susunud na onnu ina na onnu ama na onnu aabeng na onnu pita na maipagapu kan sakon kan sat Nabaḻu’n Damag, ");
INSERT INTO kmk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","adayu’n ad-adu dan maawat na uttun matattaguwana. Maitdan si nasulsuluk pay nu ginasuta boḻoy, susunud, maḻong-ag, anak kan pita. Maidapdapes yoong anungus kad di aḻgaw awatona pay dit mataguwan un maid kigad na. ");
INSERT INTO kmk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yoong adu dat tagu’n maun-una uttun satun un maudi kan adu dat maudi uttun satun un maun-una nu timpu na.” ");
INSERT INTO kmk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Inggaw man da Jesus sidit tagad-an un umoy Jerusalem, ummuna’t akit si Jesus nu sadat masmasdaawana disipulus na. Ot sadat tagu’n naitung-ud kan dida kumimkimut da pay. Utdi, tinang-il Jesus uman dat kagwampuḻu’t duwa’n disipulus na ot imbaga na dit maipasamak kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kanana un, “Dumngoḻ kayu! Tumagada taku’d Jerusalem ot sakona Inyanak di Tagu, maiyawatak sidat aappun di padi kan mimistulun di lintog ot ikoddong da un mapatoyak asida iyawat sakon sidan bokona Judio ");
INSERT INTO kmk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ot manliwliw-anak, luglugpaanak, sabisabidanak asiyanak patoyon yoong nu lumabas tuḻu’n aḻgaw umungaḻak.” ");
INSERT INTO kmk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Utdi, ummoy da Santiago kan Juan un anak Zebedeo kan Jesus. Kanan da un, “Mistulu, awad kodawon mi kan sika ot sapay okyan ta ipalubus nu.” ");
INSERT INTO kmk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ngadan nat piyaon yu un kook?” kanan Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Summungbat da un kanan dan, “Ipalubus nu okyana mantupak nat osa kan dikami’t nat kapon diwanan nu kan osa’t nat kapon kawigim sinat madaydayaw un mangiyapuwam.” ");
INSERT INTO kmk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yoong summungbat si Jesus un, “Naid tigammu yu utnat kodkodawon yu. Mabooḻan yu kad nat ligata sagapaḻok? Mabooḻan yu kad un mapaligat onnu mapatoy un padan dit mapatoyak?” ");
INSERT INTO kmk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“On, mabooḻan mi,” kanan da. Imbagan Jesus kan dida un, “Tuttuwa un mapaligat kayu’n padan din mapaligatak kan mapatoy kayu un padan nat mapatoyak, ");
INSERT INTO kmk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","yoong bokona sakon nat mamili utdit mantupak situn kapon diwanan ku kan kawigik ta insaganan Apudyus un mantupakan dat pinili na.” ");
INSERT INTO kmk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dongḻon man dat simpuḻu’n buḻun da Santiago kan Juan dit kingwa da, summuḻag da kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gapu’t di, inayagan Jesus inamin dida ot kinnanana kan dida un, “Titiggammu yu un sadan maapu utdan bokona Judio, puyungon da dan iyapuwan da. Ipailan dadit awad si tulay dit pannakabalin da utdan tagu da. ");
INSERT INTO kmk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yoong bokona kama’t di dit makwa kan dikayu. Ta singngadan na mana mamiya un nangatu kan dikayu, masapula manselbi kan dikayu’n losan. ");
INSERT INTO kmk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ot singngadan na mana mamiya un siya’d kangattuwan, masapula manselbi utdan losan un kama’t babbaun. ");
INSERT INTO kmk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta sakona Inyayak di Tagu, bokon paya dummatongak daḻapnu paselbiyak si tagu nu adi dummatongak daḻapnu manselbiyak kan dida. Dummatongak daḻapnu itdok tun angos ku un mansubbut ku utdan adu’n tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dintong da Jesus kan dat disipulus na ud Jerico ot aduadu’n tagu’n naitung-ud kan dida. Utdit malausan daon diya boboḻoy, inggaw nakuḻapa mangngadan kan Bartimeo un anak Timeo un mantutupak sit igid dit kaḻsa un tumaptappaya. ");
INSERT INTO kmk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Utdit magngoḻ na un si Jesus un iNazaret dit lumaus, nampakuy un kanana’n, “Jesus un kaganakan ali David, kaasiyanak!” ");
INSERT INTO kmk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Adu dat nangigimau kan siya ot binagaan da un walling. Yoong amo indangsoḻ na ota kinnanan un, “Kaganakan ali David, kaasiyanak!” ");
INSERT INTO kmk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nan-illong si Jesus ot kanana’n, “Padakngon yu ud situ.” Utdi, inayagan da dit nakuḻap ot kanan da kan siya un, “Pabilgom nat angos nu, lumigwat ka ta andi un padakngon dika.” ");
INSERT INTO kmk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dagusa ingkaḻ-is na dit kagoy na ot summikada ummoy ummadani kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Ngadan nat piyaoma kook kan sika?” inimus Jesus kan siya. “Apu, piyaok umila,” kanan dit nakuḻap. ");
INSERT INTO kmk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“On, mabalin kaona manaḻan. Kummiya ka gapu’t nat pammatim,” kinnanan Jesus kan siya. Dagusa makailaon dit nakuḻap ot naitung-ud kan da Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Adaniyon da Jesus Jerusalem ot dummatong daon sin nambootan Betfage kan Betania utdin bateled Olivo. Utdi nambaun si Jesus si duwa utdat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kanana kan dida un, “Umoy kayu utnat madoḻdoḻa boboḻoy ot nu makadatong kayu, dagusa awad odasan yu si naisilu’n ubbun di dangki un adi payyan nakabayuwan. Ussagan yu ta idatong yu uttu. ");
INSERT INTO kmk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ot nu awad mangigimau kan dikayu un kanana’n, ‘Koon yu un ussagan nat?’ Ibaga yu kan siya un, ‘Masapul dit Apu ot ipaoli na payona dagus.’ ” ");
INSERT INTO kmk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Utdi kaysan da ot naila da dit ubbun di dangki un naisilu’t dit sooban dit boḻoya adani’t dit kaḻsa. ");
INSERT INTO kmk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Utdit ussagan da kanan dadit gasikadana tagu kan dida un, “Koon yu un ussagan nat ubbu?” ");
INSERT INTO kmk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Imbagan dat duwa dit imbilin Jesus un ibaga da ot impalubus da un aḻan da. ");
INSERT INTO kmk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Indatong da kan Jesus dit ubbun di dangki ot inyap-ap da dat kagoy da utdit dangki asin Jesus nangabayuwan. ");
INSERT INTO kmk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Adu dat tagu’n nan-iyap-ap sidat kagoy da utdit daḻan. Ot sadat udum, nanggap-id da utdat nagabong un sangan di kayu’t dit daḻan ot siya’d inyap-ap da. ");
INSERT INTO kmk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ot sadat ummuna kan sadat maitungtung-ud kan Jesus, gapappakuyan da un kanan dan, “Madaydayaw si Apudyus! Bindisyunan Apudyus tun imbaun na un pannakalong-ag na. ");
INSERT INTO kmk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bindisyunana tun dummatonga maisukat kan ali David. Madaydayaw si Apudyus sin langit!” ");
INSERT INTO kmk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Utdit dumatong daon Jerusalem, nilumnok si Jesus sit timplu. Utdit naila na un losanon dit nangkalliput sit daḻom, lummaksun ta nasdomon ot ummoy da utdat kagwampuḻu’t duwa’n disipulus na ud Betania. ");
INSERT INTO kmk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mabigat man sidit mangulin da ud Jerusalem un nanligwat Betania, nabitil si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Maotap na man dit kayu’n nagabonga ngadnon da si igus, ummoy na dintong ta ilana nu awad bunga na. Yoong dumatong man sit puun na maid bunga na ta tubu ullawa onta bokona timpu un bubungngaana payyan. ");
INSERT INTO kmk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Utdi iniliwan Jesus dit kayu un kanana’n, “Manipud sinsatunon, maidon mamungaam.” Ot dingngoḻ dat disipulus na dit inugud na. ");
INSERT INTO kmk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Dumatong da man Jerusalem nilumnok si Jesus sit timplu ot pinaḻaksun na un losan dat manlaḻaku kan gumatgatanga ininggaw. Inamin na paya sinuwakkit dat lamesaan dadit mansusukat si pilak kan sadat tutuppakan dat manlaḻaku si kalupati. ");
INSERT INTO kmk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Inyapa na pay dat awad si awit un mangoy sit paway dit timplu. ");
INSERT INTO kmk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tinudtuduwana dat tagu ot kanana’n, “Bokon kada naikanglit sit ugud Apudyus un, ‘Satun boḻoy ku mangadanan si boḻoya luluwaḻuwan di losana tagu?’ Yoong dikayu pinambalin yu un igaw di makuluk.” ");
INSERT INTO kmk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Utdit nagngoḻan dat aappun di padi kan mimistulun di lintog dit kingwan Jesus, inainapon da nu innon mampapatoy da kan siya. Umogyat da kan siya onta masmasdaawan dat losana tagu’t dat tudtudu na. ");
INSERT INTO kmk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gumidgidam man, tinengyan Jesus ud Jerusalem pati utdat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Manlaus da man si mabigat naila da dit igus un naḻangu inggana’t dit lamut na. ");
INSERT INTO kmk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nagasmok Pedro dit kingwan Jesus ot kinnanana’n, “Apu, ilamot naḻangu dit iniliwam un igus sit kaḻabyan.” ");
INSERT INTO kmk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Summungbat si Jesus un, “Manuttuwa kayu kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tuttuwa tun ibagak kan dikayu un, singngadan na mana mangibaga’t tu un bateled un, ‘Umalis ka utdin baybay,’ un maida taḻon manduwaduwaana ot tuttuwaona un matungpal dit imbagana, makwa. ");
INSERT INTO kmk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ibagak kan dikayu un singngadan na mana kodawon yu kan Apudyus sidanat luwaḻu yu, tuttuwaon yu un maitod ot maitod kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ot nu manluwaḻu kayu ta awad sigab nat angos yu si osa’n tagu, pakawanon yu yan daḻapnu pakawanon Ama yu ud langit dat basbasuḻ yu.” ");
INSERT INTO kmk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nangulin da uman Jerusalem ot utdit mangkikkiyang si Jesus sit daḻom dit timplu, inummoy kan siya dat aappun di padi, mimistulun di lintog kan sadadit lalallakay di Judio. ");
INSERT INTO kmk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kanan da kan siya un, “Ngadan nat kalintogam un mangwa’t danat kokkoom? Onnu ngadan nat nangitod kan sika utnat kalintogam un mangwa’t datu?” ");
INSERT INTO kmk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Summungbat si Jesus un, “Annat imusok kan dikayu ot nu sungbatan yu, ibagak pay tun nanligwatan tun kalintogak un mangwa’t datuwa kook. ");
INSERT INTO kmk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ibaga yu ud nu sin nanligwatan dit kalintogan Juan un mambunyag, nanligwat kan Apudyus onnu nanligwat si tagu?” ");
INSERT INTO kmk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Utdi nampipinnuut da pay lawan un, “Nu ibaga taku’n nanligwat kan Apudyus, kanana’t oni un, ‘Apay adiyu tinuttuwa nu?’ ");
INSERT INTO kmk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yoong nu ibaga taku un nanligwat si tagu gakkimut.” Umogyat da utdat tagu onta tuttuwaon da un si Juan tuttuwa’n propetan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Isunga sat insungbat da kan Jesus kanan da un, “Maid tigammu mi.” Ot kanan Jesus un, “Ot madik pay ibaga kan dikayu nu nanligwatan tun kalintogak un mangwa’t datuwa kook.” ");
INSERT INTO kmk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Utdi, inlugin Jesus dit nan-abalig un kanana’n, “Inggaw tagu’n minuḻ-ana’t ubas dit pita na. Tinalangkaana un nilikmut ot nangabut si batu un maposposan dit bungan dit ubas. Nanuud pay si nataknanga alligang di man-andog. Utdi, impatobaw na dit kaubasana ot nangaḻyug si sabali’n ili. ");
INSERT INTO kmk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Dumatong man dit bubuḻḻasan di ubas, nangibaun si baba-unona un umoy mangaḻa’t dit gogwa na utdit naapit. ");
INSERT INTO kmk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yoong dumatong man dit imbaun na, dinokmaan dat mantotobaw ot pinang-opang-ok da asida pinangulin un imaima ullawa. ");
INSERT INTO kmk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Utdi nangibaun uman si osa’n baba-unon yoong dumatong man, sinugat da dit uḻu na kan binabbainan da pay. ");
INSERT INTO kmk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Nangibaun payyan si osa ot pinatoy da. Padana pay sidat uduma naibaun un pinang-ok da dat udum ot pinatoy da pay dat udum kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Inggaw payyan osa’n nabun-an un baunona un siya dit potpotgona un anak na. Kadon siya’d imbaun naon ta kanana’t dit somsomok na un, ‘Ikabain da tu ta anak ku.’ ");
INSERT INTO kmk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yoong mailan man dat mantotobaw dit anak dit singkuwa’t dit pita kanan da un, ‘Siyatu dit manawid situn pita, aweyu ta patoyon taku daḻapnu mangkuwa taku tun pita.’ ");
INSERT INTO kmk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Utdi dinokmaan da dit anak, pinatoy da asida impagkaḻ sit lasin dit kaubasan. ");
INSERT INTO kmk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kadon, ngadan dit koonon dit singkuwa’t dit pita? Dumatonga umoy mamatoy sidat pinantobaw na kad asina ipatobaw dit kaubasan sidat udum. ");
INSERT INTO kmk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Adiyu kad nabasa dit naikanglita ugud Apudyus? Kanana un, ‘Sadit batu’n inidsan dat mankokokwa si boḻoy, siya’d nambalina pannan dit sikun dit boḻoy. ");
INSERT INTO kmk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Siya’d kingwan Apudyus ot taḻona nakaskasdaawa maila.’ ” ");
INSERT INTO kmk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naawatan dat pangaton dat Judio un imbagan Jesus diya abalig un maibusuḻ kan dida ot pinadas da un dokmaan yoong gaputa umogyat da utdat adu’n tagu binaybay-an da si Jesus ot tinengyan da. ");
INSERT INTO kmk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Utdiyon nangibaun da utdat uduma Fariseo kan uduma buyut Ali Herodes si umoy man-im-imus kan Jesus daḻapnu man-illadu kad sidat isungbat na, awad mangidaḻuman da. ");
INSERT INTO kmk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dumatong da man kan siya kanan da un, “Mistulu, tigammu mi un adika mantulituli kan adim mandudumaon dan tagu ta adim ibilbilang dit saad da. Itudtudum nat katuttuwaana maipanggop sidan piyaon Apudyus ipakwa. Ot ibagam ud nu nainkalintogana mambayad taku’n Judio si bugis kan Caesar un emperador ud Roma? Mambayad taku onnu bokon?” ");
INSERT INTO kmk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yoong titiggammun Jesus un man-ag-agin da ullawa ot kanana kan dida un, “Apay padpadasonak? Itdanak ud si denario ta ilak.” ");
INSERT INTO kmk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Innitdan da si denario ot inimus na kan dida un, “Sinmuging kan singngadan situn naimalka?” “Si Emperador Caesar,” insungbat da. ");
INSERT INTO kmk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Utdi kanan Jesus kan dida un, “Itdon yu kan Caesar nat kuwan Caesar ot itdon yu pay kan Apudyus nat kuwan Apudyus.” Nasnasdaawan da utdiya imbagan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Utdi inggaw da pay Saduceo un inummoy kan Jesus. Sadatu dat Judio un manguguda maid umungaḻ si natoy. ");
INSERT INTO kmk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Inimusan da un, “Mistulu, kanan dit lintog taku’n ingkanglit Moses un, ‘Nu mangasawa nat osa’n laḻaki ta matoy un maid anak na, masapula asaw-on dit sunud na dit bilug daḻapnu man-anak da si kama’t anak didit natoy. ");
INSERT INTO kmk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Inggaw da ud pitu’n mansusunuda laḻaki utdit. Nangasawa dit pangu yoong natoya naid anak na. ");
INSERT INTO kmk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Utdi, inasawan dit maikagwa’n sunud na dit bilug yoong natoy uman un maid anak na. Ot padana payon dit naipasamak sit maikatlu, ");
INSERT INTO kmk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","inggana’t dit maikapitu un losan da un natoya naid ingganak da utdit bilug. Utdit losan daona natoy dat mansusunud, natoy pay dit bilug. ");
INSERT INTO kmk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Ot nu timpu un umungaḻ dat natoy, singngadan dit sin-asawa’t di un bilug? Ta losan dat pitu’n mansusunuda nangasawa kan siya?” ");
INSERT INTO kmk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Summungbat si Jesus un, “Bokon nat kuwa yu un somsomok, gaputa adiyu maawatan dit naikanglita ugud Apudyus kan naid tigammu yu utdit pannakabalin na. ");
INSERT INTO kmk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta nu umungaḻ dat natoy maid man-aassawa kan dida ta kama da utdan aanghel sin langit. ");
INSERT INTO kmk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ot nu maipanggop sit umungaḻan dat natoy, adiyu kad nabasa dit ingkanglit Moses maipanggop sit umapuapuya kayu? Naikanglit sidi dit imbagan Apudyus kan Moses un, ‘Sakon ud Apudyus un mandaydayawan da Abraham, Isaac kan Jacob.’ ");
INSERT INTO kmk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Piyaona’n ugudon un si Apudyus bokona Apudyus dat natoy nu adi sadan matatagu. Gattoka bokon nat kuwa yu un somsomok.” ");
INSERT INTO kmk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inggaw mistulun di lintoga dummatong un nangngoḻ sit mandidiskutilan da Jesus sidat Saduceo. Gaputa maila na un ustuustu dit mansusungbat Jesus, ummadani ot inimus na kan siya un, “Ngadan dit kapopotgan sidat losana bilin?” ");
INSERT INTO kmk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Summungbat si Jesus un, “Siyatu’d kapopotgana bilin, ‘Dongḻon yu, dikayu’n losana kaganakan Israel: Si Apudyus, siya ullawa ud ossaana Apu. ");
INSERT INTO kmk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ot masapula iyossaan nu nat losana aangsom kan losana somsomok nu un mamippiya kan Apudyus un Apum.’ ");
INSERT INTO kmk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ot siyatu tun maikagwa un bilin, ‘Masapula piyaom dan padam un tagu un kama’t nat mampipiyam sinat long-ag nu. Maidon napotpotog si udum nu adi siya datun duwa’n bilin.’ ” ");
INSERT INTO kmk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“On, ustu nat,” kanan dit mistulu kan Jesus. “Tuttuwa nat kanam un naid udum si Apudyus taku nu adi si Apudyus ullawa. ");
INSERT INTO kmk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ot masapula iyossaan taku tun losana aangson, somsomok kan kabooḻan taku’n mamippiya kan siya kan masapul paya pipiyaon taku dan pada taku’n tagu kama’t din mampipiya taku’t tun long-ag taku. Napotpotog nat manungpaḻan sidatuwa bilin nu san mangidatunan sidan ayam kan uduma maidatun kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nadlaw Jesus un nalaing dit nansusungbat didit mistulu ot kanana kan siya un, “Bokona adayu ka utdin mangiyapuwan Apudyus.” Maabus manon di naidon makatuḻoda man-imus kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Utdit mantudtuduwan Jesus sit timplu, inimus na un, “Apay sadanat mimistulun di lintog itudtudu da un si Kristu kaganakan David? ");
INSERT INTO kmk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta mismu un si David imbaga na dit impasomsomok Ispiritu Santu kan siya un, ‘Imbagan Apudyus kan Apuk un: Mantupak ka uttun kapon diwanan ku inggana’t abakok un losan dat kabusuḻ nu.’ ");
INSERT INTO kmk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ot nu, ‘Apu,’ kanan David kan Kristu, inona un kaganakana nu?” Pipiyaon dadit aduadu’n tagu’n dodongḻon dadit tudtudun Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ot utdi un mantudtuduwana kanana un, “Alimbanan yu danat mimistulun di lintog ta pipiyaon da un mangay-ayaw un annandu dit badut da. Pipiyaon da pay nu dayawon dat tagu dida nu umoy da utdan aabtan di tagu. ");
INSERT INTO kmk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pipiyaon da dit mantupak sit sangu utdin sinagoga kan inggaw sit inggawan dat nangangatu’n tagu nu amung. ");
INSERT INTO kmk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gundawayan da dat bilug ot aḻan da un losan dat kokokwa da asida andu-anduwon dit luwaḻu da si man-iilingod da utdit kokkoon da. Nadagdagson dit dusa da un itdon Apudyus nu dumtong dit timpu.” ");
INSERT INTO kmk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Utdi nantupak si Jesus sit adani’t dit pipissukan dat tagu si pilaka mangiila utdit man-ipisukan dat tagu utdat datun da kan Apudyus. Sin-addu dit ipisuk dat babaknang. ");
INSERT INTO kmk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ummoy pay dit nakapusa bilug ot nangipisuk si duwa un siping. ");
INSERT INTO kmk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Inayagan Jesus dat disipulus na asina kinnanan kan dida un, “Tuttuwa tun ibagak kan dikayu un, san impisuk din bilug nabanbanol nu sadan impisuk dan udum un datun da. ");
INSERT INTO kmk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta san intod dan udum nansawaḻan da utdit binaknang da yoong san bilug ulay nu kapus intod na un losan dit awad kan siya un siya ullawa’d ikatagu na.” ");
INSERT INTO kmk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Utdit lummaksun da Jesus sit timplu, kanan dit osa’t dat disipulus na un, “Apu mistulu, ilam kad! Nabaḻbaḻu tun timplu kan sadatu’n uduma natuud situn lakub na. Nangkaddakkoḻ datun batu un panikokwa da.” ");
INSERT INTO kmk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Summungbat si Jesus un, “Maila yu datun nabaḻbaḻu un natuud sinsatun yoong dumtong nat timpu un maid osa’t batu si natuuga adi maidugpu.” ");
INSERT INTO kmk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ummoy si Jesus sin bateled Olivo un domang didit timplu. Mantutupak man ummoy da Pedro, Santiago, Juan kan Andres dintong. ");
INSERT INTO kmk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Inimus da kan siya un, “Apu, ibagam ud nu kapiga dit maipasamakan dit imbagam kanad kan ngadan nat mangilasinan mi nu dumatongon dit timpu un matungpaḻan datu un losan.” ");
INSERT INTO kmk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Utdi, kanan Jesus kan dida un, “Man-alimban kayu ta adi kayu maal-allilaw. ");
INSERT INTO kmk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta adu’n tagu’n dumatonga mangusal situn ngadan ku un kanan dan, ‘Sakon dit Kristu,’ ot adu dat maallilaw. ");
INSERT INTO kmk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ot nu magngoḻ yu dat kankannibung di gubat sinat adani kan damag di gubat sin adayu adi kayu madanagan ta masapula mapasamak da. Yoong bokon payyana anungus ditun lubung. ");
INSERT INTO kmk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta manggugubat dan kailin-ili’t tun lubung kan mambibinnusuḻ dan tutulay. Awad da ud lunig sidanat nadumaduma un ili kan awad pay uḻat. Luglugina ullawa datu un paligat un padan dit manlogawan di man-abeng. ");
INSERT INTO kmk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Siya’d gapuna un masapula man-alimban kayu ta dopapon kan idallay dikayu utdan ukum. Sabisabidan dikayu utdat daḻom di sinagoga. Maipadaḻan kayu utdat gugubinnadul ya aali maipagapu’t manuttuwaan yu kan sakon daḻapnu panoknokan yu dit Nabaḻu’n Damag maipanggop kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta masapula satuwa Nabaḻu’n Damag maitudtudu yan sidan losana tagu utdit daan dit anungus ditun lubung. ");
INSERT INTO kmk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ot nu dopapon dikayu ta idallay dikayu’n maimusan sidan ukum, adi kayu madanagan nu ngadan nat ibaga yu. Basta ibaga yu dit maipatigammu kan dikayu utdiya timpu. Ta sadit ibaga yu bokona manligwat sit kasomsomkan yu nu adi manligwat kan Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sadi un timpu ituyuk dat tagu dat mismu un sunud da un papatoy. Padana pay un ituyuk dat maḻong-ag un papatoy dat abeng da ot busuḻon pay dat aanak dat maḻong-ag da ot papatoy da dida. ");
INSERT INTO kmk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lawengon dikayu’t dan losana tagu gapu’t nat manuttuwaan yu kan sakon yoong singngadan na man un adi lumipsuta manuttuwa kan sakon inggana’t anungus na, taguwon Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nu maila yuwon dit gaoogyata yumam-an un awad sin timplu un bokona siya’d lumbonga maisaadana, dikayu’n iJudea gumtik kayuwon sidan batbateled. (Maawatan okyan dat losana mamasa’t tu tun kaipooyana.) ");
INSERT INTO kmk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ot sat tagu’n inggaw sit otop dit boḻoy na, adinaon lumsa onnu lumnok sit boḻoy un umoy mangaḻa’t ibtik na. ");
INSERT INTO kmk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sat tagu’n inggaw sit payaw na, masapula adinaon mangulina umoy mangaḻa’t kagoy na. ");
INSERT INTO kmk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Taḻona kawas diya timpu utdat nabugi kan sadat mantagtagibi. ");
INSERT INTO kmk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ot iluwaḻu yu kan Apudyus daḻapnu adina maiyaspuḻa mapasamak datu nu timpun di ageled. ");
INSERT INTO kmk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta utdiya timpu amoamod dit ligat un maid maipadaana’t dat ligata lummabas manipud sit namaloswaan Apudyus situn lubung inggana’t tun satun. Maida taḻon maipadaana’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ot nu adin Apudyus inyaboba dit bilang di aḻ-aḻgaw didiya ligat, maid matagu’t tagu uttun lubung yoong maipagapu’t dan pinili na un tagu na, inyaboba na. ");
INSERT INTO kmk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Utdiya timpu, nu awad mangibaga kan dikayu un, ‘Antu’t tu dit Kristu,’ onnu ‘Ilan yu, andi’t di,’ adiyu tuttuwaon. ");
INSERT INTO kmk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta adun tu dat mangabaw un dida dit Kristu kan man-ag-agin da un propetan Apudyus. Ot mangipaila da si nakaskasdaaw daḻapnu nu mabalbalin allilawon da dat pinilin Apudyus un tagu na. ");
INSERT INTO kmk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Siya’d gapuna un man-alimban kayu. Indaddaan kuwona imbaga datu kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Yoong nu maabus dadiyona manligatan sidiya timpu, kumḻop din init ot san buḻan adinaon sumḻag. ");
INSERT INTO kmk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Maotdag dan bituwon ot losana awad sin langit maligaligad da. ");
INSERT INTO kmk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kadon, ilan da ud sakona Inyanak di Tagu un dumoba’n mangillabaw sit bunot un napnu’t pannakabalin ku kan nakaskasdaawa kinangatuk. ");
INSERT INTO kmk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ot ibaun ku dadit aanghel ku uttun kasulisulin ditun lubung daḻapnu umoy da dagupon dadit losana pinilin Apudyus un tagu na.” ");
INSERT INTO kmk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ilan yu din kayu un igus ta man-adaḻan yu,” kinnanan Jesus. “Ta nu manlugi’n sumungbud dan tubu na, tigammu yuwon un dandani nat iinnitan. ");
INSERT INTO kmk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Padana pay un nu maila yu dadiya imbagaka mapasamak, tigammu yuwona dandani’n mangulinak. ");
INSERT INTO kmk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tuttuwa tun ibagaka mapasamak un losan datu daan payyan un matoy dan losana tagu uttuwa lonap. ");
INSERT INTO kmk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mangkigad dan losana maila’d langit kan satun pita yoong mannanayun tun ugud ku.” ");
INSERT INTO kmk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Maid taḻon makatigammu’t dit aḻ-aḻgaw onnu olas un mapasamakan datun imbagak. Ulay dan aanghel sin langit onnu sakona Anak Apudyus, ta si Ama ullawa’d manigammu. ");
INSERT INTO kmk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Man-alimban kayu kan mansasaggana kayu ta adiyu tigammu nat maipasamakan datu. ");
INSERT INTO kmk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ta maiyalig si tagu’n umoy man-ay-ayaw si adayu’n ili. Itaḻgod na dit boḻoy na utdat baba-unona ot itdana’t talibasu dit kada osa kan dida kan bilinona dit man-aandog sit sooban un adina masuyop. ");
INSERT INTO kmk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Isunga mansasaggana kayu ta adiyu tigammu nu gidgidam, gawan labi, tullauk manuk onnu bigbigat nat dumakngaka Apu yu. ");
INSERT INTO kmk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","On, mansasaggana kayu daḻapnu adik dikayu dakngana masusuyop. ");
INSERT INTO kmk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Satuwa ibagak kan dikayu, ibagak pay sidanat losana tagu: Mansasaggana kayu!” ");
INSERT INTO kmk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Inggaw ullawa’d duwa’n aḻgaw daan dit piyestan di Judio un ngadnon dat Piyestan di Nalausan kan Piyestan di Tinapay un maid si bubud. Ot sadat aappun di padi kan mimistulun di lintog, inainapon da dit nalimoda mandodokma kan mampapatoy da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kanan da un, “Adi taku itimpu utdin piyesta, ta asi kada lawa manggulu dan tagu ya.” ");
INSERT INTO kmk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Utdit ininggaw si Jesus ud Betania ummoy sit boḻoy Simon un pinapiyana’t dit si kutoḻ. Utdit madama da un mangan dummatong tun osa’n babai un nakaaggom si butilya’n nakwa si alabastro un nakuan si nangina’n bangbangu un nardu. Pintod na dit bagang didit butilya asina inyisig sit uḻun Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yoong nasuḻag dat uduma tagu’n ininggaw sidi ot kanan dan, “Ay, amaaman! Apay yamyam-anona’l lawa din bangbangu? ");
INSERT INTO kmk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mabalina mailaku si nasuluka tuḻu’n gasuta denario kad maitod sidat nakapus!” Ot amod dit nandidillaw da utdit babai. ");
INSERT INTO kmk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yoong kanan Jesus un, “Baybay-an yu! Apay dillawon yu? Nabaḻu’n taḻon tun kingwa na kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kanayuna inggaw dan nakapus kan dikayu ot mabalin yu un tuḻungan dida si singngadan na un timpu’n piyaon yu. Yoong bokona kanayuna iinggawak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Satuwa babai kingwa na tun kabooḻana. Dinaan naon nilanaan tun long-ag ku si mangisaganaana’t dit mailbonak. ");
INSERT INTO kmk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tuttuwa tun ibagak kan dikayu! Singngadan na man un igaw situn lubunga maiwalagawagan tun Nabaḻu’n Damag, mauguugud tun kingwan dituwa babai un mangisomsomkan kan siya.” ");
INSERT INTO kmk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Utdi, inummoy si Judas Iscariote un osa’t dat kawampuḻu’t duwa’n disipulus sidat aappun di padi daḻapnu makatulaga ituyuk na si Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nataḻok da un nangngoḻ sit imbagan Judas ot insapata da un itdan da si pilak. Kadon ininainapon Judas dit gundaway na un mangituyuk kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dinumtong dit umuna un aḻ-aḻgaw didit Piyestan di Tinapaya maid si bubud, un siya’d mapaltiyan dit ubbun di kannelu un mausal nu Piyestan di Nalausan. Inimus dat disipulus kan Jesus un, “Kawad dit piyaoma umoyan mi mangisaganaan sit kakan di piyesta?” ");
INSERT INTO kmk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Imbaun na dat duwa utdat disipulus na un kanana’n, “Umoy kayu ud Jerusalem ot maabat yu ud osa’n tagu un nan-awit si naamussu un danum. ");
INSERT INTO kmk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Unudon yu utdit lumnokana un boḻoy ot ibaga yu utdit simboḻoy un, ‘Paimus dit mistulu un, kawad kanun dit kuwaltu un manganana utdit kakan di piyesta pati utdat disipulus na?’ ");
INSERT INTO kmk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kad ipaila na kan dikayu ud dakoḻana kuwaltu’n nanginngatu un kawadan dat nadaana masapul taku.” ");
INSERT INTO kmk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Utdi kaysan dadit disipulus un binaun Jesus sin Jerusalem ot naituttuwa dat losana imbagana kan dida. Utdi insagana da dit kakan di piyesta. ");
INSERT INTO kmk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Masdom man, dummatong da Jesus pati utdat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Utdit madama da un mangan kanan Jesus un, “Tuttuwa tun ibagak kan dikayu un osa kan dikayu’n kaubung ku ud mangituyuk kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Utdi, nasigab dit angos dat disipulus na ot sin-ossa da un nan-imus kan Jesus un, “Apu, sakon kad?” kanan da. ");
INSERT INTO kmk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Summungbat si Jesus un, “Osa kan dikayu’n kagwampuḻu’t duwa’n disipulus ku. Sat makasawsaw kan sakon si tinapay situn maḻukung nat mangituyuk kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta sakona Inyanak di Tagu, matoyak un kama’t dit naikanglit sit ugud Apudyus sidit yoong kakkaasi nat tagu’n mangituyuk kan sakona Inyanak di Tagu. Napipiya okyana adina naiyanak.” ");
INSERT INTO kmk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Madama da payyana mangan, nangaḻa’t Jesus si tinapay ot nanyaman kan Apudyus asina biniibiika intod sidat disipulus na un kanana’n, “Aḻan yu tu ta kanon yu, ta siyatu’d long-ag ku.” ");
INSERT INTO kmk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Asina payyan innaḻa dit natasa un inumon da. Maabus man un manyaman kan Apudyus intod na kan dida ot losan da un umminum. ");
INSERT INTO kmk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kanana kan dida un, “Siyatu ud daḻak un mangipapiddot sidit intulag Apudyus sidat tagu, siya’d daḻaka man-ayus daḻapnu mapakawan dat adu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tuttuwa tun ibagak kan dikayu un adiyakon uminum situwa danum di ubas inggana’t dit aḻ-aḻgawa manginuman taku’t dit bagu’n danum di ubas sidin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nangkanta da un nandaydayaw kan Apudyus ot maabus man kaysan da utdin bateled Olivo. ");
INSERT INTO kmk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Utdi, imbagan Jesus kan dida un, “Mangkabutik kayu un losan ot tengyan yu ud sakon ta naikanglit sit ugud Apudyus, ‘Patoyok dit man-aayyuwan si kannelu ot man-asiwaḻak dat kannelu na.’ ");
INSERT INTO kmk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yoong nu maabusa mapaungaḻak, umun-unaak Galilea nu dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Summungbat si Pedro un, “Ulay mangkabutik da un losan, adik sika taynan.” ");
INSERT INTO kmk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kinnanan Jesus kan siya un, “Tuttuwa tun ibagak kan sika, uttuwa labi daan payyana pigwa’n tullauk manuk, pitluwonak isulib.” ");
INSERT INTO kmk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yoong impinpinsod Pedro un imbaga’n, “Ulay nu maipangkatoyak kan sika, adik sika isulib.” Ot siya pay kanan dat uduma disipulus. ");
INSERT INTO kmk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Utdiyon dummatong da Jesus kan dat disipulus na si osa’n igaw un mangngadan Getsemani. Kanan Jesus sidat disipulus na un, “Mantupak kayu yan situ ta umoyak manluwaḻu.” ");
INSERT INTO kmk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ot indallay na da Pedro, Santiago kan Juan. Utdi, amoamod dit domdom na kan mabulubulung. ");
INSERT INTO kmk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ot kanana’t dat tuḻu’n buḻun na un, “Amod tun domdom ku ot kama nu ikatoy kuwon. Inggaw kayu’t tu ot mansiput kayu.” ");
INSERT INTO kmk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Utdi, ummadayu’t akit si Jesus ot nanlakkoba nanluwaḻu un, nu mabalin okyan maligligana diya olasa mansagapaḻana. ");
INSERT INTO kmk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ot kanana’t dit luwaḻu na un, “Ama, naid adi makwa nu sika’d mangwa. Nu mabalin ilisiyak situwa ligata sagapaḻok. Yoong bokona satun piyaok tun matungpal nu adi sanat piyaom.” ");
INSERT INTO kmk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Utdi nangulin si Jesus sidat tuḻu’n disipulus na ot dintong na dida’n masusuyop. Ot kinnanana kan Pedro un, “Simon, masusuyop ka kad? Adim kad maiyattom nat suyop nu ulay sin-olasa lawa?” ");
INSERT INTO kmk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ot kanana kan dida un, “Mansiput kan manluwaḻu kayu daḻapnu adi kayu mambasuḻ nu masugsugan kayu. Ta nadaddaan nat angos yu un manungpal yoong nakapsut nat long-ag yu.” ");
INSERT INTO kmk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Utdi nangulin uman si Jesus un ummoy nanluwaḻu ot inyobos na uman dit luwaḻu na. ");
INSERT INTO kmk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mangulin man uman sit inggawan dat tuḻu’n disipulus na, dinakngana uman dida’n masusuyop ta adida madiyat dat ata da. Ot maid tigammu da utdit isungbat da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pitlu na man un dumatong un dit nanligwata ummoy nanluwaḻu, kanana kan dida un, “Apay masusuyop kan gaillongan kayu kad payyan? Ustu naon! Olas naona maiyawataka Inyanak di Tagu utdadit gumabasuḻ. ");
INSERT INTO kmk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gumangun kayu ta intakunon ta antuwon tun tagu’n mangituyuk kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mambagbagbaga payyan si Jesus sidit dummatong da Judas un osa utdat kagwampuḻu’t duwa’n disipulus na. Buḻun na dat tagu’n gaispadaan kan gapang-uḻan un imbaun dat aap-apun di padi, mimistulun di lintog kan da lalallakay di Judio. ");
INSERT INTO kmk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Utdit nanlakkatan da imbagan Judas dit mantitigammu da kan Jesus un kanana’n, “Sanat tagu’n umoyak ogkan, siya’d dokmaan yu si idallay yu ot adiyu liklikisan.” ");
INSERT INTO kmk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dumatong da man, nandadawwos si Judas un ummoy kan Jesus un, “Apu,” kanana un dit nangogok. ");
INSERT INTO kmk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Utdi dinokmaan da si Jesus ot adida linikisan. ");
INSERT INTO kmk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yoong osa’t dat gasikadan sidi dit nangukmut sit ispada na ot binakag na dit osa’t dat baba-unon dit kangattuwana padi ot nasokdap dit inga na. ");
INSERT INTO kmk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Utdi kinnanan Jesus sidat nanokma kan siya un, “Apay tulisanak kad ta ummoy kayu’t tu un gaispadaan kan gapang-uḻan un umoy manokma kan sakon? ");
INSERT INTO kmk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Inaḻgawa iniinggawak kan dikayu’n mantudtudu’t din timplu, apay adiyanak dinokmaan sidi. Yoong masapula matungpal dit naikanglita ugud Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Utdi, nangkabutik un losan dat disipulus na ot binaybay-an da si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ininggaw babbagu’n naitungtung-ud kan Jesus un nangkagoya lawa’t napoḻkasa luput. Dinokmaan da ");
INSERT INTO kmk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yoong nakalipsutan da ot nambutika nantittiway ta tinengyana dit intawid da un kagoy na. ");
INSERT INTO kmk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Indallay da si Jesus sidit boḻoy dit kangattuwana padi ot nandadatdatong pay dat uduma aap-apun di padi, lalallakay di Judio kan mimistulun di lintog. ");
INSERT INTO kmk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ot si Pedro inadayuwana un tinung-ud inggana’t dit paway dit kangattuwana padi ot ummoy nakaanidu utdat man-aandogon dit padi. ");
INSERT INTO kmk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ot sadat aappun di padi kan dat losana pappangat di Judio man-in-inap da si mamabasuḻan da kan Jesus daḻapnu papatoy da yoong maid maodasan da. ");
INSERT INTO kmk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Adu dat nangibaga’t tuli si mamabasuḻan da kan siya yoong adina nangkakatunusan dat imbaga da. ");
INSERT INTO kmk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Utdi inggaw da ud nantuli’n namabasuḻ kan Jesus un kanan dan, ");
INSERT INTO kmk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dingngoḻ mi dit imbaga na un, ‘Yam-anok tun timplu’n kingwan di tagu ot nu lumabas tuḻu’n aḻgaw mangwaak si sabali un timplu un bokona kingwan di tagu.’ ” ");
INSERT INTO kmk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yoong ulay sadatu’n imbagan datu, adida mangkakatunusan. ");
INSERT INTO kmk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ot sadit kangattuwana padi summikad sit atubang dat tagu’n naammung ot inimus na kan Jesus un, “Maid kad maisungbat nu uttun ipabpabasuḻ da kan sika?” ");
INSERT INTO kmk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yoong maid gumguminga kan Jesus ot adina summungbat. Utdi inimus uman dit padi un, “Sika kad dit Kristu un Anak ud madaydayawa Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Summungbat si Jesus un, “On sakon, ot maila yu ud sakona Inyanak di Tagu un mantutupak sin kapon madiwanan Apudyus un mannakabalin. Maila yu pay sakona mangulina manligwat langita mangillabaw sit bunot.” ");
INSERT INTO kmk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pinissay dit kangattuwana padi dit badut na utdit mangipail-ana’t dit suḻag na un kanana’n, “Apay un masapul payyan nat uduma kustigu? ");
INSERT INTO kmk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dingngoḻ yuwon dit lawenga imbaga na un maisuganggang kan Apudyus. Sinnat makanan yu?” Losan da un nangoddong un masapula mapatoy. ");
INSERT INTO kmk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Utdiyon niluglugpaan dat udum, binaḻaw da asida dinanudanug. Ot “Pugtuwam ud nu sin dit nananug kan sika,” asida kanan. Utdiyon, inaḻan dat suldadu un man-aandog kan siya ot tinipatipak da. ");
INSERT INTO kmk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Iinggaw payyan si Pedro utdit paway sidit dumatong dit babai’n baba-unon dit kangattuwana padi. ");
INSERT INTO kmk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Maila na man si Pedro un man-aannidu ummoy kummatam ot intutukkoḻ na un kanana’n, “Sika pay osa’t dat buḻun Jesus un iNazaret.” ");
INSERT INTO kmk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yoong insulib Pedro un, “Maid tigammuk sinat ibagbagam kan adik pay maawatan nat piyaoma ugudon.” Utdi kaysan sit luwangan. Ot ustu pay un nanullauk dit kawitan. ");
INSERT INTO kmk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Intukkoḻ uman dit babai ot imbagana’t dat uduma tagu un, “Satuwa tagu, siya pay osa’t dat kabbuḻunan Jesus.” ");
INSERT INTO kmk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yoong insulib uman Pedro. Masulsulit man si akit, kanan payyan dat tagu’n ininggaw sidi kan siya un, “Gattoka sika’d osa utdat kabbuḻunan Jesus ta iGalilea ka pay.” ");
INSERT INTO kmk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yoong imbagan Pedro un ulay nu madusa nu bokona tuttuwa dit ibagbaga na ot insapata na un, “Adik tigtigammu nat un tagu’n bagbagbagaon yu.” ");
INSERT INTO kmk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dagusa nanullauk dit kawitan si kapamigwa’n tullauk manuk. Ot nagasmok Pedro dit imbagan Jesus kan siya un, “Daan payyana pigwa’n tullauk manuk, pitluwonak isulib.” Utdiyon, nan-i-ibil. ");
INSERT INTO kmk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mawakas man nambabagbagaan dat aap-apun di padi, lalallakay di Judio, mimistulun di lintog kan losana kamang di Sanhedrin nu inon dit koon da un mangipapatoy kan Jesus. Maabus man di, piningil da si Jesus asida indallay sit boḻoy Pilato. ");
INSERT INTO kmk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ot inimusan Pilato si Jesus un, “Sika kad dit Alin dat Judio?” “On, naibagamon,” insungbat Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Adu dat impabasuḻ dat aappun di padi kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ot inimusan uman Pilato si Jesus un, “Maid kad maisungbat nu? Dodongḻoma adu datun ipabasuḻ da kan sika?” ");
INSERT INTO kmk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yoong maidon insungsungbat Jesus ot nasnasdaaw si Pilato. ");
INSERT INTO kmk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kada Piyestan di Nalausan, gagangay Pilato un mangiwaya si osa’n baḻud un kodawon dat tagu’n mawayaan. ");
INSERT INTO kmk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Utdiya timpu inggaw da ud laḻaki un mababaḻud gapu’t lumablabanan da utdit gubilnu da ot inggaw osa kan dida’d mangngadan si Barrabas un nakapatoy sit nakalabanan da. ");
INSERT INTO kmk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Utdit nadatdatong dat adu’n tagu kan Pilato, kindaw da un mangipawaya’t osa’n baḻud un gagangaya koko-ona kada Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ot inimus Pilato kan dida un, “Piyaon yu un pawayaak tun Ali yu un Judio?” ");
INSERT INTO kmk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Siya’d imus na di onta tigammu na un apaḻ dit gapun dit nangiyawatan dat aap-apun di padi kan Jesus kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yoong sinugsugan dat aap-apun di padi dat tagu un sad kodawon da kan Pilato un pawayaana si Barrabas, un bokona si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ot kinnanan uman Pilato utdat tagu un, “Ot ngadan nat kook kan Jesus un ngadnon yu un Alin di Judio nu?” ");
INSERT INTO kmk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Impappakuy da un, “Pailansam si kulus!” ");
INSERT INTO kmk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kanan Pilato kan dida un, “Tapay? Ngadan nat nadadaga kingwa na?” Amo indangsodangsoḻ daot dit pakuy da un, “Pailansam si kulus.” ");
INSERT INTO kmk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gaputa piyaon Pilato un pagustuwan dadit tagu, winayaana si Barrabas. Magangput man pinasabid na si Jesus asina inyawat sidat suldadu daḻapnu ilansa da si kulus. ");
INSERT INTO kmk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Utdi indallay dat suldadu’n innilnok si Jesus sidit boḻoy gubinnadul ot pinandatdatong da dat losana buḻun da un suldadu. ");
INSERT INTO kmk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kinagoyan da si Jesus si naduḻawa luput ot namalikawog da si nasaisait si imbaḻangat da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nagindadayaw da kan siya un kanan dan, “Matattagu tun Alin di Judio.” ");
INSERT INTO kmk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ot pinangpang-ok da dit uḻu na si bassaw, niluglugpaan da kan nanalluku da un nagindadayaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Utdit abuson da un man-am-amoḻan, niluksub da dit naduḻawa ingkagoy da ot insukat da dit gagangaya badut na. Ot inlaksun daon un umoy ilansa’t dit kulus. ");
INSERT INTO kmk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Inggaw da man sit daḻan naabat da si Simon un iCirene un aman da Alejandro kan Rufo. Nanligwat sit pappayaw un manaḻan sit boḻoy na yoong impapilit da un pinabukud kan siya dit kulus Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Indallay da si Jesus sin igawa ngadnon da si Golgota un sat piyaona’n ugudon, “Igaw di Battukag.” ");
INSERT INTO kmk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Inggaw da man sidi, initdan da ut Jesus si basi un nakamsan si mira yoong adina ininum. ");
INSERT INTO kmk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Inlansa da si Jesus sit kulus. Maabus man nambubunutan dat suldadu un nambibingayan dat badut na. ");
INSERT INTO kmk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mangmanganan si ban-oga banga utdit inlansa da. ");
INSERT INTO kmk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ot naikanglit sit kulus dit gapun dit namabasuḻan da kan siya un, “Siyatu dit Alin dat Judio.” ");
INSERT INTO kmk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Naidisan pay un nailansa dat duwa’n tulisana nan-asisupang kan siya, osa’t dit kapon diwanan na ot sat osa pay sit kapon kawigi na. ");
INSERT INTO kmk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kadon natungpal dit naikanglita ugud Apudyus un impapadtu na utdit un kanana’n, “Maibilang sidat nangkadadaga tagu.” ");
INSERT INTO kmk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nanwitiwit dat nanlausa nanginsultu kan Jesus un kanan dan, “Ay, sika un mangibagbaga’n yam-anom dit timplu asim ibangun obos si unog di tuḻu’n aḻgaw, ");
INSERT INTO kmk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","taguwom nat long-ag nu ot lumsa ka utnat kulus!” ");
INSERT INTO kmk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Padana pay un naipan-am-amoḻ dat aap-apun di padi kan mimistulun di lintog un kanan dan, “Tinagu na dat udum, adina matagu nat long-ag na! ");
INSERT INTO kmk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ilan taku ud un lumsa’t nat kulus nata Kristu un Alin di iyIsrael daḻapnu tuttuwaon taku.” Ot sadat nailansa’t dit nan-asisupang kan siya inin-insultu da pay si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mamalintuud man si init, kinumḻop tun lubung inggana’t nandangwilis. ");
INSERT INTO kmk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mandangwilis man si init, nampakuy si Jesus si nadangsoḻ un kanana’n, “Eloi, Eloi, lama sabaktani?” Sat piyaona’n ugudon tu, “Apudyus ku, apay pinatungadak?” ");
INSERT INTO kmk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sadat uduma iinggaw sidi un nangngoḻ sit imbagana kanan da un, “Dongḻon yu, ay-ayyagana’t Elias.” ");
INSERT INTO kmk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ot nanoddak dit osa un umoy nangaḻa si kama’t kaposa umoy na insawsaw si kilom ot innigga na utdit pungtun dit bassaw asina indukmit kan Jesus daḻapnu supsupana un kanana’n, “Daḻam yan ta ilan taku nu umoy Elias idoba’t tun kulus na.” ");
INSERT INTO kmk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Utdi nampakuy si Jesus ot napungdiwon dit angos na. ");
INSERT INTO kmk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dagusa nangkagwa un napissay dit koltinan dit timplu manipud sit ngatu inggana’t dit lagayadana. ");
INSERT INTO kmk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ot utdit mailan dit kapitan dat suldadu un summisikad sit sanguwan dit kulus dit napungdiwan dit angos Jesus kanana un, “Tuttuwa gayama Anak Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Utdit adayu’t akit, inggaw da pay babai’n mangoottap sit mapaspasamak un sada Maria Magdalena, Salome, Maria un inan da Jose kan Santiago un aliyona. ");
INSERT INTO kmk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sadatu dat naitungtung-ud kan Jesus un tummuḻung kan siya utdit ininggawana’d Galilea. Ininggaw pay dat uduma babai’n naitungtung-ud kan siya utdin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Masdom man sidiya aḻ-aḻgaw un siya’d mansaganaan dat Judio utdit aḻ-aḻgawa iillongan, ");
INSERT INTO kmk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","dummatong si Jose un iyArimatea. Siya’d osa’n nadayawa pangat un manguuway pay sit mangiyapuwan Apudyus. Tinuḻodana un umoy inimus dit ladag Jesus kan Pilato. ");
INSERT INTO kmk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nasdaaw si Pilato utdit nangimusan Jose ta kanana nu adina payyan natoy si Jesus. Inayagana dit kapitan di suldadu ot inimus na nu tuttuwa’n natoyon si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Utdit matigammuwana un natoyon, impalubus na un aḻan Jose dit ladag. ");
INSERT INTO kmk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ummoy gummatang si Jose ut luput ot utdit maidoba na si Jesus sidit kulus, nilukutana’t dit luput asina umoy innilbon sit kakokwa na un lobona inabutana’n dakoḻana batu. Maabus man namallin si dakoḻa batu si intubot na utdit sagangaban dit lobon. ");
INSERT INTO kmk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ot sada Maria Magdalena kan Maria un inan Jose innila da dit nailbonan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Maikabas man dit aḻ-aḻgawa iillongan, gummatang da si bangbangu da Maria Magdalena, Maria un inan Santiago kan Salome ta umoy da labuwon dit ladag Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Biggabiggat man si Duminggu utdit suminaḻ si init, ummoy da utdit nailbonan Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ot utdit daḻan nambabagbaga da un kanan da si osaosa kan dida un, “Ngadan kad nin nat mamallinon taku’t dit batu’n naitubot sit lobon?” ");
INSERT INTO kmk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yoong ilan da man sit dumatong da, naballinon dit naitubot un dakodakoḻana batu! ");
INSERT INTO kmk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Utdit lumnok da utdit lobon, nasdaaw da ta nangila da si babbagu un mantutupak sit kapon diwanan un nakabadut si napoḻkas. ");
INSERT INTO kmk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ot kanana kan dida un, “Adi kayu masdaaw, tigammuka inapon yu si Jesus un iNazaret un nailansa’t dit kulus. Naid situ ta ummungaḻon. Umoy kayu ilan tun nangibanatan da kan siya. ");
INSERT INTO kmk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Isunga ikayu ta kayu ibaga’t dat disipulus na pati kan Pedro un umun-una’d Galilea nu dikayu ot siyadi ud mangil-an yu kan siya un kama’t dit imbagana kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lummaksun da utdit lobon ot nangkabutik da un mampapilpil kan masmasdaaw. Ot naid taḻon nangibagbagaan da utdit napasamak gapu’t dit amoda kimut da. ");
INSERT INTO kmk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Utdit bigbigat di Duminggu un ummungaḻan Jesus, nampaila’n ummuna kan Maria Magdalena un siya dit babai un nangaddagana utdat pitu’n dimunyu utdit. ");
INSERT INTO kmk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ot si Maria kaysana ummoy nangibaga’t dat mandomdomdom kan mampa-i-ibil un naibuḻubuḻun kan Jesus sidit un naila na si Jesus. ");
INSERT INTO kmk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yoong ulay nu dingngoḻ da un matattaguwan si Jesus kan nampaila kan Maria Magdalena, adida kampay tinuttuwa. ");
INSERT INTO kmk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Magangput man di, nampaila uman si Jesus sidat duwa’t dat buyut na si sabali un ila utdit mankikkiyangan da un umoy si osa’n boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nangulin datu un duwa un ummoy nangibaga’t dat udum un naila da si Jesus yoong adida tinuttuwa dida. ");
INSERT INTO kmk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mansidiyon, nampaila’t Jesus sidat kagwampuḻu’t osa un disipulus naon sidit madama da un mangan. Sinuḻagana dida utdit kinamaid di pammati da kan kinasungoḻ da ta adida tinuttuwa dat nakaila kan siya un ummungaḻon. ");
INSERT INTO kmk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ot kinnanana kan dida un, “Ikayu uttun saknap tun lubung ta iwalagawag yu tun Nabaḻu’n Damag maipanggop kan sakon. ");
INSERT INTO kmk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Singngadan na mana manuttuwa’t nat itudtudu yu kan mampabunyag, matagu’t inggaingga yoong singngadan na mana adi manuttuwa, makoddongan un madusa. ");
INSERT INTO kmk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ot sadatu ud mangimatunan sidan manuttuwa. Usalon da tun mannakabalina ngadan ku un mangaddag si dimunyu, kabooḻan da un mambagbaga si sabali’n bagbaga un bokona inadaḻ da. ");
INSERT INTO kmk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ot ulay nu aggoman da dan uḻog onnu makainum da si lugam adida maan-anu. Agpadan da kad dat masakit, kumiya da.” ");
INSERT INTO kmk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Utdit naabusa makabagbaga’t Jesus kan dida, naipangatu’d langit ot nantupak sit kapon diwanan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Utdiyon kaysan pay dat disipulus Jesus sidat kaili-ilin di ili un ummoy nangiwalagawag sit Nabaḻu’n Damag maipanggop kan siya. Tinuḻungan Apu Jesus dida ot pinanoknokana dit kinatuttuwaan dit itudtudu da utdat nakaskasdaaw un am-amuga impakwa na kan dida.");
INSERT INTO kmk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Potpotgoka Apu Teofilo, Aduwon dat nangipasnoka nangikanglit sidat paspasamak un natungpal situn igaw taku. ");
INSERT INTO kmk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ingkanglit da dadit dingngoḻ da un impadamag dat nakaila manipud sit nanlugiyan dat pasamak, kan dida’d nangiwalwalagawag sidiya damag. ");
INSERT INTO kmk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nadayawa Apu, maabus mana inam-ammaaka inadaadaḻ datu un naknakwa manipud sit nanlugiyan da, nasomsomok ku un napiya nin nu ikanglit ku kan sika si nauḻnus ");
INSERT INTO kmk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","daḻapnu manigammuwam un sadat naisuḻu kan sika dida’d katuttuwaan. ");
INSERT INTO kmk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Utdit timpu un nan-aliyan Herodes ud Judea, inggaw osa’n padi un mangngadan kan Zacarias un osa utdat bungguy di papadi un kaganakan Abias. Sat asawana un si Elisabet kaganakan Aaron un ap-apun dat papadi utdit. ");
INSERT INTO kmk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nalintog da un man-asawa utdin man-iilan Apudyus. Naida taḻon mapabaḻawan da utdin manungpaḻan da utdan losana bilin kan lintog na. ");
INSERT INTO kmk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yoong maid abeng da ta lupot si Elisabet kan osa pay naḻakay daon. ");
INSERT INTO kmk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sin aḻgawan, nadtong dit batang da Zacarias un manselbi utdit timplu. ");
INSERT INTO kmk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sat gagangaya ugali da, mambubunutan da nu sin dit koon dit kada osa kan dida. Si Zacarias dit nabunut un lumnok sit timplu un manogob sidit insensu. ");
INSERT INTO kmk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Utdit manobgana adu pay dat tagu’n manluwaḻu utdit lasin. ");
INSERT INTO kmk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Utdi, nampaila kan siya dit anghel Apudyus un sumisikad sit madiwanan dit sosobgan. ");
INSERT INTO kmk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mailan man Zacarias, nabulung kan amod dit kimut na. ");
INSERT INTO kmk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yoong kinnanan dit anghel un, “Adika umogyat Zacarias ta dingngoḻ Apudyus dit inluwaḻum. Man-abeng si Elisabet un asawam. Laḻaki dit abeng yu ot ngadnom kan Juan. ");
INSERT INTO kmk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Amoda manlagsakan yu ot manlagsak pay dan adu’n tagu’t din maiyanakana. ");
INSERT INTO kmk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ta siya ud napotoga tagu utdin man-iilan Apudyus. Masapul un adina uminum si kumpolmi’n makabuuk. Manipud sin maibugiyana inggawon si Ispiritu Santu kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Adu dat iyIsrael un mangulinona’n manuttuwa kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mamangpangu nu si Kristu un Apu. Ot awad dit pannakabalin Ispiritu Santu kan siya un padan propeta Elias sidit. Mantutunusona uman dat man-aama. Mapabalbaliw na dat nasukil ot mansomsomok da un padan dat nalintog. Siya datu ud koona daḻapnu masasaggana dat tagu utdit dumakngan Jesus,” kinnanan dit anghel. ");
INSERT INTO kmk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kinnanan Zacarias sidit anghel un, “Inon nat mantitigammuk situ? Naḻakayakon kan bakbakot pay si asawak.” ");
INSERT INTO kmk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Insungbat dit anghel un, “Sakon si Gabriel un manselselbi kan Apudyus. Imbaunak un mangibaga kan sika uttuwa Nabaḻu’n Damag. ");
INSERT INTO kmk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yoong gaputa adika manuttuwa man-umoḻ ka agingga si matungpal tuwa imbagak kan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sadat tagu’t dit lasin un manguuway kan Zacarias, masmasdaaw da nu apaya nabayag sidit daḻom. ");
INSERT INTO kmk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lumaksun man adinaon makabagbaga kan dida. Ot natigammuwan da un awad nampaila kan siya utdit daḻom dit timplu. Ot mansinsinyasa lawa kan dida ta nan-umoḻon. ");
INSERT INTO kmk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Utdit nagangput dit koon Zacarias sit timplu nangulin sidit boḻoy da. ");
INSERT INTO kmk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Adina nabayag nabugiyon si Elisabet un asawana. Ot si Elisabet adina lummaklaksun si lima’n buḻan. Kanan Elisabet un, ");
INSERT INTO kmk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kinaasiyanak kan Apudyus ta antu un nabugiyak un siya’d naibabbainak sidat uduma tagu dit kinalupot ku.” ");
INSERT INTO kmk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Utdit maikanoma buḻanon ud Elisabet un nabugi, imbaun Apudyus si anghel Gabriel ud Nazaret un osa’n ili’d Galilea, ");
INSERT INTO kmk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ta umoy sit osa’n babai un daan payyan di laḻaki un aduḻon un mangngadan kan Maria. Si Maria naipaada maiyasawa kan Jose un kaganakan Ali David. ");
INSERT INTO kmk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ummoy dit Anghel kan siya ot kinnanana un, “Manlagsak ka, sika un naidumduma’t potog. Awad si Apu kan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yoong nabulung si Maria utdit imbagan dit anghel ot simsimmok na nu ngadan dit piyaona’n ugudon dit imbaga na. ");
INSERT INTO kmk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ot kanan dit anghel kan siya un, “Maria, adika umogyat ta naidumduma nat potog nu kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ilam! Mabugi ka ot iyabeng nu ud osa’n laḻaki un ngadanom kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Siya ud madayawa tagu kan gattoka anak Apudyus un kangattuwan. Mambalinon Apudyus si Ali un padan Ali David un inapu na. ");
INSERT INTO kmk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Itulayana dat kaganakan Jacob si inggaingga, ot maid patinggan dit mangiyapuwana.” ");
INSERT INTO kmk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Summungbat si Maria un, “In-inon dinata makwa? Maid payyan asawak.” ");
INSERT INTO kmk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Summungbat uman dit Anghel kan siya un, “Mabugi ka maipagapu’t pannakabalin Ispiritun Apudyus. Siya’d gapuna un sat iyabeng nu nasantuwan, siya’d gattoka Anak Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ilam si kabagiyama Elisabet un kanan da un lupot yoong nabugi ulay nu bakbakoton ot sat bugi na laḻaki. Kanoma buḻan naon. ");
INSERT INTO kmk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta maid adi makwa nu si Apudyus dit mangwa.” ");
INSERT INTO kmk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Summungbat si Maria un, “Manselbiyak kan Apudyus. Matungpal kan sakon nat imbagam.” Ot tinaynan dit anghel. ");
INSERT INTO kmk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Utdi, nangkamukamu un nanlakkat si Maria ta umoy sit boḻoy da Zacarias sit ili un sakup din kabatbateledana ili ud Judea. ");
INSERT INTO kmk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Dumatong man sidi giningaana si Elisabet. ");
INSERT INTO kmk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Magngoḻ man Elisabet dit gingan Maria, nangkulagtit dit abeng sit buwang na. ");
INSERT INTO kmk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ot indangsoḻ Elisabet un nambagbaga’n, “Maria, sika’d kagasatan sidan losana babai. Ot nagasat pay nat abenga iyabeng nu. ");
INSERT INTO kmk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Apay padayawanak un umoy bilingon kan sika un inan ud Apuk. ");
INSERT INTO kmk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ta utdit magngoḻ ku dit gingam, nangkulagtit tun abeng situn buwang ku utdit lagsak na. ");
INSERT INTO kmk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nagasat ka ta tuttuwaoma matungpal dit insapatan Apudyus un imbagan dit anghel na.” ");
INSERT INTO kmk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Utdi, kanan Maria un, “Daydayawok si Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Naanggomak ta si Apudyus indumduma na ud sakona osa’n babbaun na ullawa. Kadon losana tagu awaganak un nagasat. ");
INSERT INTO kmk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nakaskasdaawa banag dat kingkingwan mannakabalina Apudyus kan sakon. Nasantuwan dit ngadan na. ");
INSERT INTO kmk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kaasiyana dat losana manuttuwa kan siya manipud sidat damu’n lonap aginggana’t dat maudi’n lonap. ");
INSERT INTO kmk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ipaila na dit pannakabalin na utdan koona. Ot alliwona dat mamaspasindayaw sidat koon da. ");
INSERT INTO kmk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ipadoba na dat nangatu’n tutulay sidan saad da. Ot ipangatuna dat kakkaasi un tagu. ");
INSERT INTO kmk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sadat maidan si kanon itdana dida ut napiya un mapnokan da. Yoong sadat nabaknang padaḻnona dida’n imaima. ");
INSERT INTO kmk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tinungpal na dit insapatana utdat dadakkoḻ taku ta tinuḻungana ditaku’n kaganakan Israel. ");
INSERT INTO kmk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Adina naliuwan dit nangkakaasi na kan Abraham kan losan dat kaganakana si inggaingga,” kinnanan Maria. ");
INSERT INTO kmk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nakaigaw si Maria kan Elisabet si unus di tuḻu’n buḻan asina nangulin sidin boḻoy da. ");
INSERT INTO kmk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Utdit dinumtong dit timpu un man-abengan Elisabet inyabeng na ud laḻaki. ");
INSERT INTO kmk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sadat kaaluba da kan kabagiyan da, nagngoḻan da dit nakaskasdaawa mampipiyan Apudyus kan Elisabet. Ot naanggom da pay. ");
INSERT INTO kmk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Utdit maikawaḻu’n aḻgaw dit posik nandadatdatong da ta manlaguman da dit matuḻgiyan kan mangadanan dit posik ta siya’d ugali da un Judio. Piyaon da un ngadanon kan Zacarias ta siya’d ngadan amana. ");
INSERT INTO kmk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yoong kinnanan ina na un, “Bokon ta sat ngadan na, Juan.” ");
INSERT INTO kmk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kinnanan dat tagu kan siya un, “Yoong maid kabagiyan yu si singngadan sinata ngadan.” ");
INSERT INTO kmk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ot insinyas da kan Zacarias nu singngadan dit ingadan nat dit abeng na. ");
INSERT INTO kmk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nangkodaw si Zacarias si kakanglitan ot ingkanglit na un Juan dit ngadan na. Taḻona nasnasdaaw da un losan. ");
INSERT INTO kmk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Utdiyon, nakabagbaga uman si Zacarias ot insaḻad na un nandaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Taḻona nasnasdaaw dadit kailiyan da. Nandinadinamag tuwa napasamak sidin kabatbateledana ili ud Judea. ");
INSERT INTO kmk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nakainsomosomok dat losana nakagngoḻ situwa pasamak ot kanan da un, “Ngad kad nin mambalinan dituwa abeng. Ta nalawag un awad kan siya dit pannakabalin Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Utdi, si Zacarias un aman dit abeng, ininggaw dit Ispiritu Santu kan siya ot imbagana dit piyaon Apudyus paibaga kan siya un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayawon taku si Apudyus un Apu taku’n iyIsrael. Ta inummoy un mangwaya kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Imbaun na dit mannakabalina managu un manligwat sidan kaganakan Ali David un nanselselbi kan siya’t dit. ");
INSERT INTO kmk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Siya payon dit paimpugtu na utdat propetana utdit aw-awe ");
INSERT INTO kmk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","un taguwona ditaku utdan losana kabusuḻ taku kan sidan losana manlaweng kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Imbagana un, kaasiyana dat dadakkoḻ taku kan gagasmokona dit insapatana. ");
INSERT INTO kmk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ta tuttuwa’n insapatana kan ap-apu taku’n Abraham un, taguwon ditaku utdan kabusuḻ taku daḻapnu maid ikimut taku’n manselbi kan siya, ");
INSERT INTO kmk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kan daḻapnu nalintog tun mataguwan taku utdin man-iilana un maid koon taku si laweng.” ");
INSERT INTO kmk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kinnanan pay Zacarias sit abeng na un, “Sika abeng ku, ngadnon dika si propetan Apudyus un kangattuwan. Umun-una ka nu sadit mangiyapu ta umoy ka saganaon dat tagu’t dit daan na un dumatong. ");
INSERT INTO kmk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Umoy ka ipatigammu utdat tagu nat mataguwan da si inggaingga nu kodawon da dit mampapakawan Apudyus sidat basuḻ da. ");
INSERT INTO kmk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ta taḻona nakaasi kan naanus si Apudyus. Ot mangibaun si managu un maiyalig sit dumungitan init sin bigbigat. ");
INSERT INTO kmk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ta silawana dit somsomok dat napangot si katatagu kan iinggaw sit kapangotan un igaw ud katoy. Ipangat ditaku utdit daḻan un mampooy sit kapkapiya un mataguwan.” ");
INSERT INTO kmk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dummakoḻ un nanakman dit aangson dit abeng. Ininggaw sit igawa maid tagtagguwan aginggana’t dit timpu un naikoddonga lumtawana’t dat iyIsrael. ");
INSERT INTO kmk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Utdiya timpu, imbilin Emperador Augustus un malista dat losana tagu’n umapu ud Roma. ");
INSERT INTO kmk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Utdit nakwa tuwa pogpoga’n sensus, si Kirenio dit gubinnadul ud Siria. ");
INSERT INTO kmk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kadon, osaosa ummoy nampalista utdit ili un nanligwatan dat ginnapuwan da. ");
INSERT INTO kmk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Utdi, si Jose un iNazaret sin ili ud Galilea, ummoy nampalista utdin Betlehem un ili ud Judea ta siya’d ilin Ali David un ginnapuwana. ");
INSERT INTO kmk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Naitung-ud pay si Maria un naipaada maiyasawa kan siya un ummoy nampalista ot agin-aanakan. ");
INSERT INTO kmk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Utdit ininggaw da ud Betlehem, siya’d timpu un man-abengana. ");
INSERT INTO kmk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Utdi, maid igaw da utdit boḻoya inggawan dat bisita ot ininggaw da’l lawa’t dit bawin di ayam sit pidong. Inyabeng na dit laḻaki’n pangu un abeng na ot linukutana si luput asina inyobog sit papakkanan di ayam. ");
INSERT INTO kmk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Utdiya labi, inggaw da ud man-ayyuwan un man-andog sidat kannelu da utdat pappayaw. ");
INSERT INTO kmk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kakḻata nilumtaw dit anghel Apudyus ot dinoḻangan dit doḻang Apudyus dida ot amod dit ogyat da. ");
INSERT INTO kmk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yoong imbagan dit anghel kan dida un, “Adi kayu umogyat ta inummoyaka mangibaga si nabaḻu’n damag un mataḻokan dat losana tagu. ");
INSERT INTO kmk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Satuwa labi utdin ilin ali David naiyabeng dit managu kan dikayu un siya’d Kristu un Apu. ");
INSERT INTO kmk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sat manigammuwan yu un tuttuwa tu, maodasan yu nat posika naḻukutan si luputa naiyobog sit papakkanan di ayam,” kinnanan dit anghel kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ot maibaga na man tu, kakḻata nilumtaw dat aduadu’n anghel un nanligwat langit ot nangkankanta da un mandaydayaw kan Apudyus un kanan dan, ");
INSERT INTO kmk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Madaydayaw si Apudyus sidin langit! Ot situn pita, kapkapiya dat tagu’n mas-omana.” ");
INSERT INTO kmk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Manaḻan man dat anghel un man-ulin langit nambabagbaga dadit man-aayyuwan un, “Umoy taku’d Betlehem ta itaku ilan tun naipasamak un impatigammun Apudyus kan ditaku.” ");
INSERT INTO kmk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Utdiyon nangkamukamu da un kaysan un umoy nangila ot indasan da da Jose kan Maria pati utdit posika naiyobog sit papakkanan di ayam. ");
INSERT INTO kmk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Maila da man dit posik imbaga da utdat tagu dit imbagan dit anghel maipanggop kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ot amo nasdaaw dat losana nakagngoḻ sit imbagan dat man-aayyuwan. ");
INSERT INTO kmk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yoong inyaangos ud Maria datu’n losana nakwa ot insosomok na. ");
INSERT INTO kmk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ot nangulin dat man-aayyuwana nandaydayaw kan Apudyus sit losana dingngoḻ da kan naila da ta naituttuwa dit imbagan dit anghel Apudyus kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Utdit waḻu’n aḻgaw naon dit posik, siya dit timpu un matuḻgiyan kan mangadanana ot ningadan da kan Jesus ta siya’d ngadan un imbagan dit anghel sidit daan na un maibugi. ");
INSERT INTO kmk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Utdit dummatong dit timpu un manungpalan da Jose kan Maria utdit lintog Moses maipanggop si madaḻusan da, ummoy da’d Jerusalem. Indallay da pay dit posik ta ida idatun kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ta kanan dit lintog Apudyus un, “Losana pangu un maiyabenga laḻaki maidatun kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kad kingwa da dit datun un maipooy sit madaḻusan Maria. Duwa’n kalupati onnu duwa’n ubbun di ut-ut dat maidatun ta siya’d kanan dit lintog. ");
INSERT INTO kmk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Utdi, ininggaw tagu’n mangngadan kan Simeon un iJerusalem. Nalintoga tagu kan manuttuwa kan Apudyus. Uuwayona dit mangipawaya utdin ili da un Israel. Inggaw pay dit Ispiritu Santu kan siya, ");
INSERT INTO kmk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","un siya’d nangipatigammu kan siya un adina matoy agingga si ilana dit Kristu un ibaun Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sadiya aḻ-aḻgawa nangilnokan da Jose kan Maria utdit posik sit timplu un manungpaḻan da utdit lintog maipanggop sidan aabeng, ininggaw si Simeon sit timplu ta impuyut Ispiritu Santu utdi ot mailana man dit posik, ");
INSERT INTO kmk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","sinakwawa na asina nanyaman kan Apudyus un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sinsatunon Apu ta tinungpal nu dit insapatam, mabalinon un matoyaka kapkapiya. ");
INSERT INTO kmk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ta gattoka nailak tun managu, ");
INSERT INTO kmk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","un imbaun nu kan dikami un tagu. ");
INSERT INTO kmk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kama si silaw un mangilawag sit somsomok dat bokona Judio daḻapnu matigammuwan da dit mantatagum kan dida ot gapu kan siya maidaydayaw da un losana iyIsrael.” ");
INSERT INTO kmk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ot nasnasdaaw dat ina kan aman dit abeng sidit imbagan Simeon maipanggop sidit abeng da. ");
INSERT INTO kmk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kindaw Simeon un bindisyunan Apudyus dida asina kinnanan kan Maria un, “Maria, satuwa abeng nu dinutukan Apudyus yoong lawengon dat kaaduwana tagu’d Israel, un siya’d madusaan da. Ot sadat udum tuttuwaon da un siya’d mataguwan da si inggaingga. Sat katatagu na siya’d mangipailan siya dit nanligwat kan Apudyus yoong supngilon dat adu’n tagu ot sat mansusupngil da ");
INSERT INTO kmk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","siya’d mangipaila’t dit lawenga aangson da un adi naipatpatigammu. Ot gapu’t tuwa mapasamak sika un inana nasigab angos nu un kama’t matbok si natadoma uku nat pusum.” ");
INSERT INTO kmk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Inggaw pay osa’n propetan Apudyus un mangngadan kan Ana un abeng Fanuel. Si Fanuel kaganakan Aser ot si Ana naasaw-an si pitu’n tawon. ");
INSERT INTO kmk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yoong nabilug kan bakbakot payon ta waḻumpuḻu’t opat dit tawon na. Aḻ-aḻgaw kan labi kanayuna umoy sit timplu un mandaydayaw kan Apudyus un mallangan paya mangan maipagapu’t dit manlulluwaḻuwana. ");
INSERT INTO kmk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Utdiya payona timpu, dummatong si Ana ot mailana man si Jesus, nanyaman kan Apudyus. Utdiyon intultuluy na un imbagabaga dit maipanggop kan Jesus sidat losana tagu’n manguuway sidit mapawayaan dit ili’n Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Utdit natungpal da Jose dit pakwan dit linlintog Apudyus nangulin da ud Galilea utdin boboḻoy da un Nazaret. ");
INSERT INTO kmk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dummakoḻ dit abenga gumibilog, nasilib kan nasnas-om si Apudyus kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sadat maḻong-ag Jesus kadagundagun un umoy da ud Jerusalem ta umoy da makapiyesta utdit Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Utdit maikagwampuḻu’t duwa un tawon ud Jesus, ummoy uman dat maḻong-ag na ta siya’d ugali da ot naitung-ud pay kan dida’d Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Magangput man dit Piyestan di Nalausan nanlakkat da un nangulin ud boboḻoy da yoong si Jesus ininggaw ud Jerusalem un adin dat maḻong-ag na napuppuutan. ");
INSERT INTO kmk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kanan da nu awad sidat bungguy da ot nakaingkiyakiyang da un nampasin-aḻgaw. Utdi, ininap da utdat kakabbagiyan da kan gagayyom da ");
INSERT INTO kmk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","yoong maid maodasan da. Ot nangulin da ud Jerusalem ta umoy da inapon. ");
INSERT INTO kmk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Utdit maikatlu’n aḻ-aḻgaw manipud sidit nanlakkatan da ud Jerusalem, indasan da utdit timplu un nakatupak sidat mimistulun dat Judio un mandodongngoḻ kan makaim-imus kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ot sadat nakagngoḻ kan siya, nasdaaw da ta nalainga sumungbat. ");
INSERT INTO kmk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mailan man dat maḻong-ag na un ininggaw sidi nasdaaw da ot kinnanan dit ina na kan siya un, “Apay kingwam tu kan dikami? Amod danag mi kan amam un manginainap kan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Apay un inainaponak?” insungbat Jesus. “Adiyu kad tigammu un masapula inggawak situn timplun Amak?” kinnanana kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yoong adida naawatan dit kaipooyan dit imbaga na kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Utdi, nangulin si Jesus kan dida ud Nazaret. Tinuttuwa na un losan dat imbagan dat maḻong-ag na. Ot losana kingkingwan Jesus inyaangos Maria dida. ");
INSERT INTO kmk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dummakoḻ si Jesus un nasilib kan nanakman ot nasnas-om si Apudyus kan dat tagu kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lummabas piga’n tawon, ot utdit maikagwampuḻu’t lima’n tawon un man-apuwan Tiberios un Emperador ud Roma, si Poncio Pilato ud gubinnadul Judea, si Herodes ud mangiyapu utdin Galilea ot si sunud na un Felipe dit mangiyapu utdin sakup Iturea kan Traconite ot si Lisanias ud mangiyapu ud Abilene. ");
INSERT INTO kmk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sada Anas kan Caifas dat kangattuwana ap-apun dat papadi. Utdiya timpu inggaw imbagan Apudyus kan Juan un anak Zacarias sidit iniinggawana’t dit igawa maid tagtaguwanna. ");
INSERT INTO kmk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kad sidiyon dinakdak na dat kailin-ili utdin nampaigid Jordan un nanudtudu un kanana’n, “Mandadaoli kayu kan igongda yuwon dat basuḻ yu ot mampabunyag kayu daḻapnu pakawanon dikayu kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Si Juan dit ug-ugudon Isaias un propetan Apudyus sit iblu na un kanana’n, “Awad tagu’t dit igawa maid tagtagguwan na un mampappakuya kanana’n, ‘Isagana yu dit daḻan dit Apu. Manggodngon yu dit daḻan un ayona. ");
INSERT INTO kmk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tab-unan yu dat nadaḻom ot lenadon yu dat kuntug kan bateled. Manggodngon yu dat daḻana nakelu kan lenadon yu dan nampabikakung. ");
INSERT INTO kmk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ot losana tagu maila da dit mantatagun Apudyus sidat tagu!’ ” ");
INSERT INTO kmk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Utdi, aduadu dat tagu’n ummoy kan Juan daḻapnu pabunyag da kan siya yoong kinnanana kan dida un, “Dikayu’n ganak di uḻog! Singngadan nat nangibaga kan dikayu un, mampabunyag kayu daḻapnu maligligan yu dit dumatonga mandusaan Apudyus? ");
INSERT INTO kmk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Masapula ipaila yu utdan angwat yu un tuttuwa’n mandadaoliyan yu dat basuḻ yu. Adiyu kanana mailisi kayu utnat kanan yu un, ‘Ulay ta kaganakan dikami kan Abraham.’ Ta tuttuwa tu un ibagak kan dikayu un mabalin Apudyus mangwa’t kaganakan Abraham sidatu’n batu. ");
INSERT INTO kmk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sat manusaan Apudyus kan dikayu maiyalig si wasay un maibibiyada maipokpok sit pong-ad dit kayu. Ot losana kayu un adi mamunga’t napiya mapokpok asi maidawat sin apuy.” ");
INSERT INTO kmk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ot sadat tagu inimus da un, “Ngad nat koon mi nu?” ");
INSERT INTO kmk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ot summungbat si Juan un, “Sat tagu’n awad si duwa ut badut itdona dit osa’t dit maid si badut. Padana’t dit kawadan di makan masapula ibingayana dit maid si kanon.” ");
INSERT INTO kmk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Inggaw da pay man-uuḻup si bugis un ummoy nampabunyag kan siya ot inimus da un, “Mistulu ngad nat koon mi?” ");
INSERT INTO kmk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Summungbata kanana’n, “Sat gagangaya mabayadana lawa ud uḻupon yu.” ");
INSERT INTO kmk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Inggaw da pay suldadu’n nangimus kan siya un, “Dikami nu, ngadan nat koon mi?” Kinnanana kan dida un, “Adi kayu mangog-ogyat onnu man-ipabasuḻa lawa dalapnu maala yu dan pilak dan udum. Mapnok kayuwon sinat tangdan yu.” ");
INSERT INTO kmk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ot gaputa taḻona uuwayon dat tagu dit naisapata un Kristu, kanan daon sit somsomok da nu si Juan dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yoong imbagan Juan kan dida un, “Bunyagok dikayu si danum yoong awad osa un taḻona nangatu nu sakon ot adiyak pay maibilanga mangussag sit sandalyas na. Bunyagon dikayu si Ispiritu Santu kan apuy. ");
INSERT INTO kmk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Siya’d manguis sidan tagu ot maiyalig si tagu’n nakaaggom si igau un mantopa’t ilik. Aminona’n topaan asina iyaḻang dat nabgas ot aminona’n idawat dat nakupaw sit apuya adi makmaksop.” ");
INSERT INTO kmk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Adu pay dat uduma intudtudun Juan sidat tagu utdit man-iwalagawagana’t dit Nabaḻu’n Damag. ");
INSERT INTO kmk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sinuḻasuḻagana pay si ali Herodes maipagapu’t dit nangasaw-ana kan Herodias un asawan dit sunud na kan osa pay adu dat lawenga kingkingwana. ");
INSERT INTO kmk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yoong am-amodot un laweng dit kingwan Herodes ta paimbaḻud na si Juan. ");
INSERT INTO kmk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Utdiya timpu un mamunbunyagan Juan sidat tagu, ummoy pay si Jesus nampabunyag kan siya. Ot utdiya manlulluwaḻuwan Jesus un nabunyagan, nambukat din langit. ");
INSERT INTO kmk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ot dummoba si Ispiritu Santu un kama si kalupati un inumpa kan siya. Inggaw ginga’n nanligwat un kanana’n, “Sika ud pipiyaoka Anak ku un taḻona masmas-omak.” ");
INSERT INTO kmk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Umoya tuḻumpuḻu’n dagun Jesus sidit inlugi na un nansuḻu. Ot imbilang dat tagu un anak ud Jose un anak Eli. ");
INSERT INTO kmk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sat Eli, anak Matat, un anak Levi, un anak Melki, un anak Jane, un anak Jose. ");
INSERT INTO kmk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sat Jose, anak Matatias, un anak Amos, un anak Nahum, un anak Esli, un anak Nage. ");
INSERT INTO kmk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sat Nage, anak Maat, un anak Matatias, un anak Semei, un anak Jose, un anak Juda. ");
INSERT INTO kmk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sat Juda, anak Joana, un anak Resa, un anak Zorobabel, un anak Sealtiel, un anak Neri. ");
INSERT INTO kmk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sat Neri, anak Melki, un anak Adi, un anak Cosam, un anak Elmadam, un anak Er. ");
INSERT INTO kmk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sat Er, anak Josue, un anak Eliezer, un anak Jorim, un anak Matat, un anak Levi. ");
INSERT INTO kmk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sat Levi, anak Simeon, un anak Juda, un anak Jose, un anak Jonan, un anak Eliakim. ");
INSERT INTO kmk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sat Eliakim, anak Melea, un anak Mena, un anak Matata, un anak Natan, un anak David. ");
INSERT INTO kmk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sat David, anak Jesse, un anak Obed, un anak Boaz, un anak Salmon, un anak Naason. ");
INSERT INTO kmk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sat Naason, anak Aminadab, un anak Armi, un anak Arni, un anak Esron, un anak Fares, un anak Juda. ");
INSERT INTO kmk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sat Juda, anak Jacob, un anak Isaac, un anak Abraham, un anak Tare, un anak Nacor. ");
INSERT INTO kmk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sat Nacor, anak Serug, un anak Ragau, un anak Peleg, un anak Heber, un anak Selah. ");
INSERT INTO kmk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sat Selah, anak Cainan, un anak Arfaxad, un anak Sem, un anak Noe, un anak Lamec. ");
INSERT INTO kmk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sat Lamec, anak Matusalem, un anak Enoc, un anak Jared, un anak Mahalaleel, un anak Cainan. ");
INSERT INTO kmk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sat Cainan, anak Enos, un anak Set, un anak Adan un anak Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Magangput man si Jesus un mabunyagan tinengyana din wangwang Jordan. Ot ginumḻoyon dit Ispiritu Santu kan siya un siya’d nangipuyut kan siya’t dit igawa maid amo taguna. ");
INSERT INTO kmk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Utdi, sinugsugan Satanas si Jesus udsi opatapuḻu’n aḻ-aḻgaw. Utdiya timpu un nasugsugana naida taḻon nanganana ot amod dit bitil na. ");
INSERT INTO kmk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kinnanan Satanas sidit manugsugana un, “Gaputa abeng dika kan Apudyus bilinom ud dit batu’t di ta mambalin si makan.” ");
INSERT INTO kmk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Summungbat si Jesus un kanana’n, “Kanan dit naikanglita ugud Apudyus un, ‘Bokona lawa’n makan ud ikatagun di tagu.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Utdiyon, indallay Satanas sit nangatungatu un igaw ot impaila na si sinkispayan dat losana il-ili uttun lubung. ");
INSERT INTO kmk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ot kinnanan Satanas kan Jesus un, “Itdok kan sika dit kalintogaka mangiyapu’t datu kan mangkuwam losan dan kinabaknang da. Ta naipulang kan sakon nat kalintogana mangiyapu kan dida ot mabalina ipulang ku si piliyoka mangipulangan. ");
INSERT INTO kmk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ot nu sakon ud dayawom, mangkuwam dida’n losan.” ");
INSERT INTO kmk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Summungbat si Jesus un, “Yoong kanan dit naikanglita ugud Apudyus un, ‘Dayawom si Apudyus un Apum ot siya ullawa’d manselbiyam.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Magangput man di, impuyut umanon Satanas sidin Jerusalem ot indallay na utdit tuktuk dit timplu asina kinnanan kan siya un, “Nu abeng dika kan Apudyus, lumayug ka. ");
INSERT INTO kmk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta kanan dit ugud Apudyus un, bilinon Apudyus dat anghel na un mangayyuwan kan sika. ");
INSERT INTO kmk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kanana pay un tapayaon dika daḻapnu adina maisugpi danat ikim sidan batu.” ");
INSERT INTO kmk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Summungbat si Jesus un kanana’n, “Tuttuwa nat yoong kanan dit naikanglita ugud Apudyus un, ‘Adim padpadason si Apudyus un Apum.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Gangputon man Satanas dit nadumaduma un nansusugsug na kan Jesus tinaynana yan inggana’t awad gundaway na uman. ");
INSERT INTO kmk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Utdi, dummoba si Jesus un nangulin Galilea ot inggaw kan siya dit pannakabalin Ispiritu Santu. Ot nandinadinamag dit maipanggop kan siya utdat nangkalliputa boboḻoy sidi. ");
INSERT INTO kmk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nantudtudu’t dat kasinasinagoga ot dinaydayaw dat losana tagu. ");
INSERT INTO kmk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Utdiyon, ummoy si Jesus ud Nazaret un dummakḻana. Timpun man dit aḻ-aḻgawa iillongan, inummoy sit sinagoga ta siya’d ininamana un koon. Utdit dakngon da dit mangibasaan da utdit ugud Apudyus, ummoy summikada nambasa. ");
INSERT INTO kmk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ot naipuḻad kan siya dit nalukuta papel un naikanglitan dit paingkanglit Apudyus kan propetana’n Isaias. Binikyad Jesus ot binasa na dit ugud un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Antu kan sakon dit Ispiritun Apudyus. Ta sakon ud pinili na un mangiwalagawag sidit Nabaḻu’n Damag sidat nakapus. Imbaun na ud sakona mangibaga’t din mawayawayaan dat baḻud kan mangipaoli utdit man-iilan dat nabuḻsok kan mangipawaya sidat tagu’n maidapdapes. ");
INSERT INTO kmk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Imbaunak un mangipatigammu un dinumtongon dit timpu un mangipail-an Apudyus sit kaasi na utdat tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Gangputon man Jesus un basaon, linukub na dit papel asina intod sidit tumuḻtuḻung ot nantupak. Intutukkoḻ dat losana tagu’t diya sinagoga si Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Inlugin Jesus un mantudtudu un kanana’n, “Natungpal situn satun tuwa binasaka paingkanglit Apudyus un dingngoḻ yu.” ");
INSERT INTO kmk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dinaydayaw dat losana tagu kan nasnasdaaw da utdit nabaḻu’n man-uugud na. Ot kinnanan da un, “Bokon kada sat anak Jose nat?” ");
INSERT INTO kmk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kinnanan Jesus kan dida un, “Maid duwaduwa na un ibagayu kan sakon tuwa uuggudon da un, ‘Doktol agasam yan unaon nat long-ag nu.’ Mabalin pay un kanan yu un, ‘Koom pay situn boboḻoy taku dat kingkingwam sin Capernaum.’ ");
INSERT INTO kmk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tuttuwa tun ibagak kan dikayu,” intuluy Jesus. “Maid propetan Apudyus si madayaw sit ili na pay lawan. ");
INSERT INTO kmk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ta tigammuyu, adu dat kakkaasin bilug sidin Israel utdit timpun Elias, sidit adina ummudan si tuḻu ya gogwan di dagun ot amoda uḻat sit losana boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yoong gaputa adin dat iyIsrael manuttuwa, adin Apudyus imbaun si Elias un manuḻung si ulay osa utdat nabilug sidi nu adi imbaun na si osa un bilug un bokona iyIsrael ta iSerapta un sakup Sidon. ");
INSERT INTO kmk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Padana pay un adu dat nakutoḻa iyIsrael sit timpun Elisio yoong maid osa si naagasan kan dida malaksig kan Naaman un bokona iyIsrael ta iSamaria.” ");
INSERT INTO kmk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nakaungot dat losana tagu’t dit sinagoga utdit nangngoḻan da un imbagan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ot lummigwat da un umoy nangilagayad kan siya’n nangilaksun ot indallay da utdit igid dit bateleda ummiliyan da ta panggop da un otdagon sidit eppang. ");
INSERT INTO kmk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yoong kaysana lawa si Jesus un nangoy sit gaggawan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Utdiyon ummoy si Jesus ud Capernaum un ili utdin Galilea. Timpun man dit aḻ-aḻgaw un iillongan, ummoy sit sinagoga nantudtudu’t dat tagu’t di. ");
INSERT INTO kmk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nasdaaw dat losana nangngoḻ sit nantutudtudu na ta maiila un awad tulay dat ugud na. ");
INSERT INTO kmk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Inggaw osa’n sinakayan di dimunyu utdiya sinagoga ot nampakuy un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus un iNazaret ngadan nat umoy ka koon kan dikami? Ummoy ka kad situ daḻapnu umoy ka yam-anon dikami. Tigammuk sika. Sika’d nasantuwana imbaun Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yoong inggimaun Jesus dit dimunyu un kanana’n, “Guminok ka ot tengyam nat tagu!” Indubḻang dit dimunyu dit tagu utdit atubang dat tagu asina tinengyana maid kingwa na ut laweng kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nasnasdaaw un losan dat tagu ot nampaim-imus da pay lawan un, “Ngadanna kad nina ugud di? Andi ud tulay na kan pannakabalin na ta bilinona kad dan dimunyu un manaḻan tuttuwaon da.” ");
INSERT INTO kmk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Utdi nandinadinamag dit maipanggop kan Jesus sidadit losana nangkalliputa ili. ");
INSERT INTO kmk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lumaksun man si Jesus sit sinagoga kaysan sit boḻoy da Simon. Sadit katugangan Simon un babai amod dit pudut na ot dumatong man si Jesus kindaw da un papiyaona. ");
INSERT INTO kmk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Utdi ummadani si Jesus sit masakit ot binilin na dit pudut un kumaan ot dagusa naid dit pudut na. Dagusa gummangun dit bakbakot ot ummoy nangisagana’t kinan da Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Maipsuk man si init, losana awad si gayyom un mansaksakit si singngadan na mana sakit, indatong da dida kan Jesus. Ot inagpadana dida’n losan ot gummilog da. ");
INSERT INTO kmk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Inaddag na pay dat dimunyu utdat adu’n tagu ot gapakuyan da un kaysan un kanan dan, “Sika’d Anak Apudyus.” Yoong inggimaun Jesus dida ot adina impalubusa nambagbaga da. Onta tigammu da un siya dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wiswis-it man lummaksun si Jesus sit boḻoy ot kaysan sit gattotopoga igaw. Ummoy dat tagu ininainap ot maodasan da man piyaon da nu iinggawa adina tengyan dida. ");
INSERT INTO kmk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yoong kinnanan Jesus kan dida un, “Masapula umoyak pay sin uduma ili ta itudtuduk tun Nabaḻu’n Damag maipanggop sin mangiyapuwan Apudyus sidan tagu ta siya ud nangibaunana kan sakona kook.” ");
INSERT INTO kmk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ot dinakdak na ud Judea un nantudtudu’t dat sinagoga. ");
INSERT INTO kmk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sin-aḻgawan, sumisikad si Jesus sidit dupit dit bananaw Genesaret ot nanggugunod dat tagu’n ummadani kan siya ta dongḻon da dit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Utdi, naila na dat duwa’n bangka utdit igid dit bananaw un tinengyan dat mangikan ta ida nambaḻbaḻ sidat tabukuḻ da. ");
INSERT INTO kmk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ummoy nanlugan sidit osa’n bangka un kuwan Simon asina inayagan si Simon ta paiyadayu na ut akit dit bangka. Nantupak sit bangka un nantudtudu utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Magangput mana mantudtudu, imbagana kan Simon un, “Iyadayum sin kaadaḻmana ta manabukuḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Apu, insungbat Simon. Nampasinlabi kami un nanabukuḻ yoong taḻona naid naaḻa mi. Yoong nu siya’d kanam itabukuḻ mi.” ");
INSERT INTO kmk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Utdit itabukuḻ da, nangna si amoda ikan ot utdit manlapuwona mabuḻtug dit tabukuḻ da, ");
INSERT INTO kmk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","pinaypayan da dat buḻun da utdit osa’n bangka ta umoy da dida tuḻungan. Ummoy da ot pinnu da dit duwa’n bangka un ulaya lawa’n dandani da un maḻnod. ");
INSERT INTO kmk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mailan man Simon Pedro dit napasamak, nampalintumong sidit sanguwanan Jesus un kanana’n, “Apu umadayu ka kan sakon ta gumabasuḻaka tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ta nasnasdaaw si Simon kan dat buḻun na utdit kaadun dat naaḻa da un ikan, ");
INSERT INTO kmk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","padana pay sidat kasugpun Simon un sada Santiago kan Juan un anak Zebedeo. Ot kinnanan Jesus kan Simon un, “Adika umogyat ta manipud sinsatun taguwon dat dagupom.” ");
INSERT INTO kmk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Utdit maitakdang da dat bangka da, tinengyan da dat alikam da ot naitung-ud da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Namingsana ininggawan Jesus sit osa’n ili, inggaw osa’n laḻaki un nasiklup si kutoḻ dit long-ag na un ummoy nampalintumong sit atubang Jesus ot nampakpakaasi un kanana’n, “Apu, tigammuka kabooḻama papiyaon sakon nu piyaom.” ");
INSERT INTO kmk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Inagpadan Jesus un kanana’n, “On, piyaok. Kumiya ka.” Ot dagusa nakaan dit kutoḻ na. ");
INSERT INTO kmk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Binilin Jesus dit laḻaki un adina ibagbaga’t udum, nu adi kanan Jesus un, “Mandadawwos ka kan padi ta ika ipaila un kummiya kaon, asika umoy mandatun kan Apudyus un kama’t dit imbilin Moses un manigammuwan di losana tagu un kummiya ka.” ");
INSERT INTO kmk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yoong naam-amodota nandinadinamag dit maipanggop kan Jesus. Kadon aduadu dat tagu’n umoy kan siya mandongoḻ kan mampaagas sidat sakit da. ");
INSERT INTO kmk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yoong umoumoy si Jesus sit igawa maid tagtagguwana manluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sin-aḻgawan, mantudtudu si Jesus ot inggaw da ud Fariseo kan mimistulun di lintoga gatupakana dudumngoḻ kan siya un nanligwat si kailin-ili ud Galilea kan Judea. Inggaw da pay nanligwat sin Jerusalem. Ininggaw dit pannakabalin Apudyus kan Jesus un mampapiya utdat masakit. ");
INSERT INTO kmk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Utdi, inggaw da ud tagu’n nambulig si tagu’n adina’n taḻon makagidu. Ot pinadas da un ilnok sit boḻoy ta umoy da ibanat sit atubang Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yoong gapu’t dit kinaadun dat tagu, naid inon da un mangilnok. Ot inyoy da utdit otop asida nangabut si nanguyudan da utdit tagu’n uumbog sit katli na asidaon imbanat sit atubang Jesus un pinanggaggawan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Utdit mailan Jesus un amod dit mantututtuwa da kan siya, imbaga na utdit adi makagidu un, “Gayyom, napakawanon dat basuḻ nu.” ");
INSERT INTO kmk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Magngoḻ man dat Fariseo kan mimistulun di lintog tuwa imbagan Jesus, kanan da utdit somsomok da un, “Singngadan ditu un tagu’n sumuganggang kan Apudyus? Sin dit makabooḻa mamakawan si basuḻ nu adi si Apudyus ullawa?” ");
INSERT INTO kmk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tigammun Jesus dit somsomok da ot kinnanana kan dida un, “Apay nat somsomok yu un kama’t nat? ");
INSERT INTO kmk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngadan nat naḻasḻasu’n maibaga? Sadin ‘Napakawanon nat basuḻ nu,’ onnu san ‘Gumangun ka ta kumiyang ka.’ ");
INSERT INTO kmk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yoong pabilgok tun adi makagidu daḻapnu manigammuwan yu un sakona Inyanak di Tagu, awad kalintogak situn pita un mamakawan si basuḻ.” Utdi, imbaga na utdit tagu’n adi makagidu un, “Ibagak kan sika, gumangun ka! Aḻam nat obog nu ta manaḻan ka.” ");
INSERT INTO kmk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dagusa gummangun dit tagu un iillan dat losan ot inaḻa na dit katli na un kaysan sit boḻoy da un mandaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Taḻona nasnasdaaw da un losan ot nandaydayaw da kan Apudyus. Ummogyat da un kanan dan, “Nakaskasdaaw dan inila mi uttun satun!” ");
INSERT INTO kmk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Magangput man di, kaysan si Jesus ot utdit manaddaddaḻanana naila na dit man-uuḻup si bugis un mangngadan kan Levi un mantutupak sit pisina na. Kinnanan Jesus kan siya un, “Maitung-ud ka kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lummigwat si Levi ot tinengyana dat losan ot naitung-ud kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sin-aḻgawan, nan-amung si Levi utdit boḻoy na ta padayawana si Jesus. Aduadu dadit man-uuḻup si bugis kan udum paya tagu un nakaubung kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ot sadadit Fariseo kan sadat buḻun da un mimistulun di lintoga ininggaw sidi, inggimau da dat disipulus Jesus un kanan dan, “Apay makakan kan makainum kayu utdan man-uuḻup si bugis kan gumabasuḻa tagu?” ");
INSERT INTO kmk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Si Jesus dit summungbata kanana’n, “Sadan awad si sakit ud makasapul si man-aagas bokona sadan naid si sakit. ");
INSERT INTO kmk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bokona dummatongak daḻap umoy ku ayagan dan tagu’n mangipagalup un nalintog da nu adi sadan gumabasuḻ daḻapnu mandadaoli da utdat basuḻ da.” ");
INSERT INTO kmk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Inggaw da ud tagu’n ummoy nangibaga kan Jesus un kanan dan, “Sadan disipulus Juan kankanayun da un manlangan un mangan kan manluwaḻu, padana pay sidan disipulus dan Fariseo yoong apay danat disipulus nu un adida pay koon?” ");
INSERT INTO kmk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yoong summungbat si Jesus un, “Mabalin kad un manlanganoma manganon dat sangaili’t dit boda nu inggaw payyan kan dida dit laḻaki’n namboda? Bokon! ");
INSERT INTO kmk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yoong nu dumatong dit timpu un maaḻaon dit laḻaki’n namboda, siyadiyon ud timpu un manlanganan da un mangan un mangipaila’t dit domdom da.” ");
INSERT INTO kmk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ot imbagan pay Jesus tu un abalig kan dida un kanana’n, “Maid mamissay si bagu’n luput ta itakup na si dadaana badut ta kaynga ullawa dit bagu’n luputa mapissay kan bokon paya maibagay dit bagu un maitakup sidit dadaan. ");
INSERT INTO kmk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pada na pay un maid mangibilung si bagu’n basi utnat dadaana geddanga bibillungan un adinaon mannatnat. Ta nu sumubuy buḻtugona dit bibillungan ot kaynga ullawa’n maibukallay dit basi kan mayam-an pay dit bibillungan. ");
INSERT INTO kmk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Masapula sat bagu’n basi, maibilung si bagu’n geddanga bibillungan.” ");
INSERT INTO kmk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Intuluy Jesus dit abalig na un kanana’n, “Maid mamiya’n uminum si bagu’n basi nu umminumon si dadaan ta kanana un laus dit tamtam dit dadaan.” ");
INSERT INTO kmk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Osa’n aḻ-aḻgawa iillongan dat Judio, nangoy da Jesus kan dat disipulus na utdit kapappayawana namuḻ-an si trigo. Ot nansapḻut dat disipulus Jesus sit bungan di trigo asida linali’t dat ima da ya dinuum. ");
INSERT INTO kmk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yoong inggaw da ud Fariseo un nangila utdit kingwa da ot kinnanan da kan Jesus un, “Apay koon yu nat iyadin dit lintoga koon nu aḻ-aḻgawa iillongan?” ");
INSERT INTO kmk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Summungbat si Jesus un, “Adiyu kad nabasa dit kingwan da Ali David kan dat buḻun na utdit nabitilan da? ");
INSERT INTO kmk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nilumnok si Ali David sit boḻoy Apudyus ot inaḻana dit tinapaya naidatun kan Apudyus ot kinan na un sadat padi’l lawa dat mabalina mangan. Ot initdana pay dat buḻun na si kinan da.” ");
INSERT INTO kmk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Utdiyon, imbagan Jesus kan dida un, “Sakona Inyanak di Tagu dit awad si kalintogana mangibaga sidan makwa nu aḻ-aḻgawa iillongan.” ");
INSERT INTO kmk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Osa payyana aḻ-aḻgawa iillongan, ummoy si Jesus sit sinagoga. Ot inggaw tagu’t di un naek-ekana nakulekug dit madiwanana ima na. ");
INSERT INTO kmk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ininggaw da pay mimistulun di lintog kan Fariseo un manipusiput nu mampapiya si Jesus sidiya aḻ-aḻgawa iillongan daḻapnu awad mamabasuḻan da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yoong tigammun Jesus dit somsomok da ot imbagana’t dit tagu un naek-ekana nakulekug si ima un, “Awe nu ta sumikad ka’t tun sanguwan.” Lummigwat dit laḻaki ot inummoy sit sangu. ");
INSERT INTO kmk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Utdi, inimusan Jesus dat tagu’t di un kanana’n, “Ngadan nat ipalubus dit lintog un koon taku nu aḻ-aḻgawa iillongan, mangwa’t napiya onnu mangwa’t laweng? Ipalubus na un kumatoy taku onnu managu taku’t tagu?” ");
INSERT INTO kmk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ummila si Jesus kan dida’l losan asina imbaga’t dit tagu un, “Uknadom nat imam.” Utdi, inuknad dit tagu dit ima na un naek-ekana nakulekug ot kummiya. ");
INSERT INTO kmk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yoong amoamod dit suḻag dat Fariseo kan mimistulun di lintog ot binabagbaga da nu in-inon dit koon da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sin-aḻgawan, nanagada si Jesus sidit bateleda umoy nanluwaḻu. Nampasinlabi utdiya nanlulluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mawakas man, inayagana un losan dat disipulus na ot namili si simpuḻu’t duwa kan dida ot nginadanana dida’t apostoles. ");
INSERT INTO kmk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sadat pinilina, da Simon un ningadanna kan Pedro, kan si sunud na un Andres, sada Santiago kan Juan, Felipe, Bartolome, ");
INSERT INTO kmk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Santiago un anak Alfeo kan si Simon un mangadanan si Patriota. ");
INSERT INTO kmk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Si Judas un anak Santiago kan si Judas Iscariote un nangituyuk kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Gummusad da Jesus sidat pinilina utdit bateled ot nan-illong da utdit nalenad un kawadan dat adu un maitungtung-ud kan siya. Amoamod pay dat tagu’n ummammung un nanligwat sin Jerusalem kan losana lakub Judea, kama pay sidat il-ili utdin dupit baybay un lakub Tiro kan Sidon. ");
INSERT INTO kmk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inummoy da utdi ta mandongoḻ da utdit tudtudun Jesus kan paagas da pay dat sakit da. Ot sadat sinakayan di nadadaga ispiritu napapiya da. ");
INSERT INTO kmk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Utdi piyaon dat losana tagu’n sekgelon si Jesus ta inggaw manligwat kan siya un pannakabalin un mampapiya kan dida’n losan. ");
INSERT INTO kmk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Utdi, ummila si Jesus sidat disipulus na ot kinnana na un, “Nagasat kayu un mamigbig un maid mabalin yu ta mangkuwa yu dit mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nagasat kayu un nabitil sinsatun ta awad mabsugan yu. Nagasat kayu un man-ibil sinsatun ta umamang kayun tu. ");
INSERT INTO kmk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nagasat kayu nu lawengon dikayu’t dan tagu, nu adi dikayu ikankanamungan, nu babbainan dikayu kan palpalawengon dikayu maipagapu’t manuttuwaan yu kan sakona Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Manlagsak kayu nu mapasamak datu ot ilagtuk yu nat lagsak yu ta amoamod dat gun-guna yu utdin langit. Ta sat koon dat tagu kan dikayu siya pay kingwan dat ginnapuwan da utdat propetan Apudyus sidit aw-awe. ");
INSERT INTO kmk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Yoong kaasi yu pay un nabaknang, ta inabus yuwon un linak-am lam-ay di matagu. ");
INSERT INTO kmk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kaasi yu pay un mabmabsug sinsatun ta mabitil kayun tu. Kaasi yu pay un manlaglagsak situn satun ta madodomdoman kan umibiibil kayun tu. ");
INSERT INTO kmk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kaasi yu pay un idaydayaw dat losana tagu’t tun satun ta pada yu dat man-ag-agin propeta un dinaydayaw dat tagu utdit aw-awe.” ");
INSERT INTO kmk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Intuluy Jesus dit nambagbaga un kanana’n, “Yoong ibagak kan dikayu un dudumngoḻ kan sakon situn satun. Piyaon yu dan kabusuḻ yu, koon yu dan nabaḻu utdan manlaweng kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Iluwaḻuwan yu dan mangiliw kan dikayu kan iluwaḻuwan yu dan mamalpaliwa kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu awad manipak sinat biika pasngit yu, patipak yu payyanot nat biik. Nu awad mangidaḻum kan dikayu ta aḻana nat badut yu, itdon yu payyanot nat kagoy yu. ");
INSERT INTO kmk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Itdan yu dan mangkodaw kan dikayu kan nu awad aḻan da kan dikayu adiyuwon nanam-on un maiyulin. ");
INSERT INTO kmk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Koon yu utdan uduma tagu dat piyaon yu un koon da kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nu sad piyaon yu ullawa dan mamiya kan dikayu, ngadan dit maganab yu? Ulay dan gumabasuḻ piyaon da dan mamiya kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ot nu sadan mangwa si nabaḻu kan dikayu dan mangwaan yu pay si nabaḻu, ngadan dit maganab yu. Ulay dan gumabasuḻ siya pay ud koon da. ");
INSERT INTO kmk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nu sadan tigammu yu ullawa un mangiyulin sidan gawaton da dan pagawatan yu, ngadan dit maganab yu? Ulay dan gumabasuḻ pagawatan da dan pada da un gumabasuḻ ta nanam-on da un ulinon da dit pagawat da. ");
INSERT INTO kmk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","San masapula koon yu, piyaon yu dan kabusuḻ yu, nabaḻu ud koon yu kan dida kan mampagawat kayu un adiyu namnam-on un maiyulin. Nu koon yu datu amod dat gun-guna yu kan siya payon mangipail-an yu un tuttuwa’n anak dikayu kan Apudyus un kangattuwan. Ta si Apudyus nakaasi utdan adi manigammu un manyaman kan nadadaga tagu. ");
INSERT INTO kmk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ot siya’d gapuna un mangaasi kayu un padan Ama yu un nakaasi.” ");
INSERT INTO kmk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Intuluy Jesus un kanana’n, “Adiyu ukumon dan uduma tagu daḻapnu adin pay Apudyus dikayu ukumon. Pakawanon yu dat padayu un tagu ot pakawanon dikayu pay kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mangtod kayu ot itdan dikayu pay kan Apudyus si ad-adu ta masodsod kan magantukan. Ta nu kamaan nat man-iingos yu utdan itdon yu utdan udum siya pay ud man-iingos Apudyus utdan itdona kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Utdiyon, inyabalig pay Jesus kan dida un kanana’n, “Sanat nakuḻap adina kabooḻana mamuyut si padana un nakuḻap ta maotdag da un duwa’t din abut. ");
INSERT INTO kmk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maid man-adaḻ si nalaing nu sanat mistulu na. Yoong nu magangput naon dit adaḻna maipadaon sit mistulu na.” ");
INSERT INTO kmk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Imbagan pay Jesus tuwa abalig un kanana’n, “Apay un sad ilam nat bangbang-ita buḻaw ud buḻun nu un bokona sat kama’t batanga buḻaw nu? ");
INSERT INTO kmk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Inona’n kanam sit buḻun nu un, ‘Buḻun, awenu ta kaanok nat buḻaw nu,’ nu adim kaanon nat kama’t batanga buḻaw nu? Man-ag-agin ka. Kaanom yana umuna nat kama’t batanga buḻaw nu daḻapnu kumadda nat man-iilam un mangaan sit buḻaw buḻun nu.” ");
INSERT INTO kmk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Bokona ibungan nat napiya’n kayu nat laweng, padana pay un sanat lawenga kayu adina mangibunga si napiya. ");
INSERT INTO kmk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta maimatunan nat kayu utnat ibunga na. Maid igus si mabuḻas sit iwoy kan maid ubas si mabuḻas sit pingit. ");
INSERT INTO kmk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Padana pay un sat napiya’n tagu, napiya dat awad sit somsomok na isunga napiya dat ibosway na. Ot sat lawenga tagu, laweng dat awad sit somsomok na, isunga laweng dat ibosway na. Ta sanat awad sinat kasomsomkan di tagu siya’d ibosway na.” ");
INSERT INTO kmk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Intuluy Jesus un dit nambagbaga un kanana’n, “Apay un awaganak si Apu, Apu, yoong adiyu koon nat ibagaka koon yu? ");
INSERT INTO kmk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sat tagu’n umoy kan sakon dumngoḻ sidan ibagak kan tungpaḻona dida, ibagak kan dikayu ud maipadaana. ");
INSERT INTO kmk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Maipada’t dit osa’n tagu un nanuud si boḻoy. Nanguḻub si adaddaḻoman asina pinannan si batu. Dummakodakoḻ dit suḻung ot inoy dit layus diya boḻoy yoong adina’n taḻon naligad, onta inam-ammaana un tinuud. ");
INSERT INTO kmk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yoong sanat tagu’n dumngoḻ sinat ibagak ot adina tungpaḻon maipada utdit osa’n tagu un nanuud si boḻoy na utdit kapit-an un adina pinannan. Utdit dummakoḻ dit suḻung dinagas na dit boḻoy ot dagusa natukas ot nagnagsay!” ");
INSERT INTO kmk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ummoy si Jesus ud Capernaum sidit nagangput nantudtudu utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Inggaw ud osa’n kapitan di suldadu utdi un bokona Judio un masakit dit potpotgona’n baba-unona ot matmattoyan. ");
INSERT INTO kmk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Utdit magngoḻana dit maipanggop kan Jesus, nangibaun sidat lalallakay di Judio kan Jesus ta umoy da ibaga un umoy na papiyaon dit baba-unona. ");
INSERT INTO kmk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ot inummoy dat pappangat kan Jesus nampakpakaasi ot kinnanan da un, “Apu, maibagay tuwa tagu un tuḻungam ta ");
INSERT INTO kmk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pipiyaon dikami’n umili kan nampatuud pay si sinagoga mi.” ");
INSERT INTO kmk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Utdi, naibuḻun si Jesus kan dida. Utdit dumoḻdoḻ da utdit boḻoy, nangibaun dit kapitan sidat gagayyom na ta umoy da umabat ta ibaga da tuwa ugud na kan Jesus, “Apu, adika ullawa umoy sin boḻoy ta bokona nadayawaka tagu’n umoy ka dakngon. ");
INSERT INTO kmk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Siya’d gapuna un bokona sakon ummoy nangabat kan sika. Ibagama lawa’n kumiya din baba-unok ot kumiya. ");
INSERT INTO kmk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ta taguwak paya awad mangiyapu kan sakon si nangatngatu un opisyal kan awad da pay suldaduka iyapuwak. Nu ibagak sit osa un, ‘Ikan,’ manaḻan, kan nu ibagak sit osa un, ‘Awenu’t tu,’ dumatong. Ot nu ibagak sit baba-unoka, ‘Koom tu,’ koona.” ");
INSERT INTO kmk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nasdaaw si Jesus sit dongḻona di ot kinnanana’t dat aduadu’n tagu’n maitungtung-ud kan siya un, “Ibagak kan dikayu un pulus pay nu awad innilak si osa’t iyIsraela manuttuwa si kama’t tuwa kapitan.” ");
INSERT INTO kmk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Utdit nangulin dat imbaun kapitan sit boḻoy dintong da un kummiyaon dit baba-unon kapitan. ");
INSERT INTO kmk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Adina nabayag, ummoy si Jesus si osa’n ili un mangngadan si Nain. Naitung-ud dat amoda tagu kan dat disipulus na kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Utdit dumoḻdoḻ da utdit pudayan didiya ili, naiyaspuḻa lumaksun datun umoy manlobon. Sadit natoy, siya ullawa’d os-ossaana laḻaki un abeng didit bilug. Adu dat kailiyana un naibuḻog kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nakaasiyan si Jesus un nangila utdit bilug ot kinnana un, “Adika man-ibil.” ");
INSERT INTO kmk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Utdi, kummatam si Jesus un ummagpad sidit lungun ya nan-illong dat nambulig si akit. Kinnanan Jesus un, “Babbagu, gumangun ka.” ");
INSERT INTO kmk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dagusa nantupak dit natoy kan inlapu na un nambagbaga. Kadon inyoy Jesus sit ina na. ");
INSERT INTO kmk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Taḻona nasnasdaaw dat losana tagu’n nangila ot dinaydayaw da si Apudyus un kanan dan, “Dummatong kan ditaku tun mannakabalin un propetan Apudyus ot inummoy Apudyus saḻakan ditaku un taguna.” ");
INSERT INTO kmk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ot nandinadinamag si Jesus sidin losana lakub Judea kan sadat nangkalliput un ili. ");
INSERT INTO kmk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sadat disipulus Juan un Mambubunyag impadamag da kan siya utdit babaḻḻudan dat losana maipanggop sit kokkoon da Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ot si Juan nangibaun si duwa utdat disipulus na kan Jesus daḻapnu umoy da imuson kan siya un, “Sika kad dit insapatan Apudyus un dumatonga mangiyapu onnu awad sabali’t uwayon mi?” ");
INSERT INTO kmk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Utdit dakngon da si Jesus kinnanan da un, “Imbaun dikami kan Juan un Mambubunyag ta umoy mi imuson kan sika nu sika dit dumatong onnu awad sabali’t uwayon mi?” ");
INSERT INTO kmk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Utdi payon un timpu adu dadit tagu un pinapiyan Jesus sidat sakit da, inaddag na dat dimunyu’n dat nadimunyu kan pinambalin na un makaila dat tagu’n nakuḻap. ");
INSERT INTO kmk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ot summungbat si Jesus sidat imbaun Juan un, “Mangulin kayu kan Juan ta ibagayu kan siya dan naila yu kan dingngoḻ yu un kama’t dan, makaila dat nakuḻap, makakiyang dat napilay, napapiya dat nakutoḻ, makagngoḻ dat nabongngog, napaungaḻ dat natoy kan maipatpatigammu dit Nabaḻu’n Damag sidat nakapus. ");
INSERT INTO kmk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ot ibagayu pay kan siya nagasat nat tagu’n adi manduwaduwa kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Utdit kaysanon dat imbaun Juan, imbagan Jesus sidat tagu dit maipanggop kan Juan un kanana’n, “Utdit inummoy kayu kan Juan sin igawa maid tagtagguwan, sin dit ninamnama yu un maila? Tagu kad un kama’t guḻuna mabayogbogan kad maapuapuyog? Bokon. ");
INSERT INTO kmk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ot ngadan dit umoy yu innila? Tagu kad un nambadut si nabaḻbaḻu’n badut? Bokon. Sat kinatuttuwana sadin boḻoy ali ud inggawan di nabaḻu’t badut kan nagadaḻ si mantatagu. ");
INSERT INTO kmk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ot ngadan didit umoy yu innila? osa’n propetan Apudyus? On, yoong ibagak kan dikayu un nangatngatu pay nu san propetan Apudyus dit inila yu. ");
INSERT INTO kmk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta si Juan, siya’d ug-ugudon dit naikanglita ugud Apudyus un kanana’n, ‘Ibaun ku dit propetak un umun-una nu sika un umoy mangisagana’t dit daḻana ayom.’ ");
INSERT INTO kmk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ibagak kan dikayu din tuttuwa un naid payyan tagu ut naiyabeng situn pita si pinasawayana dit kinapotog ud Juan. Yoong san osa’n manuttuwa ulay nu nadoba’n tagu mabalin un napotpotog nu si Juan sidin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Losan dat tagu pati utdat man-uuḻup si bugis un nangngoḻ sit imbagan Jesus, pinanoknokan da un kustu dit kingwan Apudyus un nangibaun kan Juan. Onta nampabunyag da kan Juan. ");
INSERT INTO kmk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yoong sadat Fariseo kan sadat mimistulun di lintog sinumdiyan da dit panggop Apudyus kan dida. Onta adida nampabunyag kan Juan. ");
INSERT INTO kmk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Sinsadin, singngadan nat mangiyaligak sidan tagu’t tuwa lonap, singngadan nat kamaan da? ");
INSERT INTO kmk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kama da utdan aabeng un gatupakan sidin aammungan di tagu’n mampipinnakuy sidan kaalimok da un kanan dan, ‘Mangangsa kami yoong adi kayu manadok. Manlamat kami yoong adi kayu man-ibil.’ ");
INSERT INTO kmk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kama da utdadiya aabeng ta utdit dummatong si Juan un Mambubunyag, nanlangana mangan kan adina umminum si basi ot kanan da un nadimunyu. ");
INSERT INTO kmk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dummatongaka Inyanak di Tagu ot nangananganak kan umminuinumak ot kanan da uman un, ‘Ilan yuwot naḻawota mangan kan umiinum, gagayyom na pay dan man-uuḻup si bugis kan uduma gumabasuḻ!’ ");
INSERT INTO kmk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yoong tamman nu siya’d kanan da ta maila payon din kinakustun din silib Apudyus sin mantatagun dan manuttuwa.” Napakawan Dit Gumabasuḻa Babai. ");
INSERT INTO kmk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sin-aḻgawan, osa’t dat Fariseo un mangngadan kan Simon dit nangawis kan Jesus un umoy makakan kan siya ot ummoy si Jesus nakaubunga nangan. ");
INSERT INTO kmk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Utdiya ili inggaw babai un nadadag dit kokkoona kigad si nataguwana. Utdit nagngoḻana un inggaw si Jesus un makakan sit boḻoy dit Fariseo, ummoy pay sidi un nangaḻa si simbutilya’n nabanola bangbangu. ");
INSERT INTO kmk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Summikad sit sog-on dit ikin Jesus un umibiibil ot sadit luwa na nantodtodtod sit ikin Jesus. Pinunasana’t dit buuk na asina inogkan kan inisigan sit bangbangu. ");
INSERT INTO kmk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Utdit mailan dit Fariseo un nangawis kan Jesus di, kinnanana’t dit somsomok na un, “Nu tuttuwa’n propetan Apudyus tuwa tagu tigammu na okyan nu kamaan ditu’n babai un maneksekgel kan siya. Ot tigammu na okyan tun kinadadag tun kokkoona’n tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tigammun Jesus dit inggaw sit somsomok Simon ot kinnanana un, “Simon, antu ud ibagak kan sika.” “On Apu, ibagam ud,” kinnanan Simon. ");
INSERT INTO kmk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Inlapun Jesus un nambagbaga’n kanana’n, “Awad da ud duwa’n tagu un nanggawat si pilak sidit nampagawat. Limanggasut sit osa ot limampuḻu’t dit osa. ");
INSERT INTO kmk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gaputa adida nakabayad pinakawan na dida’n duwa. Singngadan na kan dida’n duwa dit amo mamippiya utdit nampagawat?” ");
INSERT INTO kmk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Summungbat si Simon un, “Sadit amod si ginawata napakawan.” “Kustu nat sungbat nu,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Inawingan Jesus dit babai asina kinnanan kan Simon un, “Ilam tu un babai, nilumnokak situn boḻoy yu yoong adinak initdan si danum si nambuḻuk situn ikik un siya’d ugali taku’n Judio. Yoong satu un babai binuḻuwana datun ikik si luwa na asina pinunasan situn buuk na. ");
INSERT INTO kmk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Adim pay inogkan sakon un siya pay ugali taku yoong satu un babai adina ummillonga nangogoogok sidatun ikik. ");
INSERT INTO kmk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Adim pay nilanaan tun uḻuk un doda’n siya’d ugali taku yoong nilanaana tun ikik si bangbangu. ");
INSERT INTO kmk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ot ibagak kan sika un satun amoda nampipiya na un impaila na siya’d mangil-an un napakawan dat aduadu’n basuḻ na. Sat tagu’n napakawan si akit, akit pay dit mampipiya na.” ");
INSERT INTO kmk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Utdiyon, kinnanan Jesus sidit babai un, “Pinakawan kuwon danat basuḻ nu.” ");
INSERT INTO kmk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","“Singngadan ditu’n tagu’n mamakawan si basuḻ?” kanan dat kaubung na utdit somsomok da pay lawan. ");
INSERT INTO kmk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Utdi imbagan Jesus sidit babai un, “Gapu’t nat pammatim, taguwon dika kan Apudyus. Ikanon un kapkapiya.” ");
INSERT INTO kmk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Adina mabayag, dinakdak Jesus dat kailin-ili kan losana boboḻoya nantudtuduwan sidit Nabaḻu’n Damag maipanggop sit mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Buḻun na dat kagwampuḻu’t duwa’n disipulus na kan naitung-ud pay dadit babai un naagasan si sakit, kan dadit pinapiya na un nadimunyu kama kan Maria Magdalena un nangaddagan Jesus sidat pitu’n dimunyu un nanimunyu kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Osa pay si Juana un asawan Cusa un apun dat manselselbi’t din boḻoy Ali Herodes. Si Susana dit osa kan adu pay dat uduma babai’n nangitod sidan mabalin da un maituḻung kan da Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Amoamoda tagu dat naammung kan makaddatodatong kampay dat udum un manligwat si kailin-ili un umoy kan Jesus. Utdi, imbaga na tuwa abalig kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Inggaw osa’n tagu’n ummoy nan-iwalis si bukoḻa tagimuḻa na. Utdiya nan-iwalisana naotdag dit udum sit daḻan ot dinabbodabbok dat tagu’n nangoy kan timpok dat sissiwit dida. ");
INSERT INTO kmk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sat uduma bukoḻ naotdag sit kabattuwan ot tummubu da yoong naḻpak da ta naid lappat dit pita. ");
INSERT INTO kmk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sat udum naotdag da utdit kasassaitan ot tummubu da yoong naseet da. ");
INSERT INTO kmk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sat udum naotdag sit naḻasa un pita ot tummubu da kan namunga da si maminggasut dit bungan dit osa’n muḻa.” Maabus man un maibagan Jesus di kanana un, “Dikayu’n awad si ingan makagngoḻ, dumngoḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inimus dat disipulus Jesus nu singngadan dit kaipooyan dit abalig. ");
INSERT INTO kmk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ot kinnanan Jesus un, “Dikayu’d nangipatigammuwan Apudyus sidat adi naipatigammu’t dit maipanggop sin mangiyapuwana. Ot sadat udum maipatigammu kan dida si abalig daḻapnu ‘ulay iillan da tun kook adida maimatunan kan ulay dodongḻon da tun ibagak adida maawatan.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Utdi, imbagan Jesus un, “Satu tun kaipooyan dit abalig. Sat bukoḻ maiyalig sit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sat daḻana naotdagan dit uduma bukoḻ, maiyalig sidat tagu’n nangngoḻ sit ugud Apudyus. Yoong dagusa ummoy Satanas sinugsugan dida daḻapnu maliuwan da dit ugud un dingngoḻ da kad adida manuttuwa kan adida maidagamung sit mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sadit bukoḻa naotdag sit kabattuwan maiyalig sidat tagu’n nangngoḻ sit ugud Apudyus. Ot naanggom da un nangngoḻ yoong adina nansilnad dit ugud kan dida ta tuttuwaon da ullawa si sin-akitan yoong lumipsut da nu dumatong dit mamakgangan dat uduma tagu kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Sadat naotdag sit kasassaitan, dida dat tagu’n nangngoḻ sit ugud Apudyus yoong maipagapu’t danag, kinabaknang kan sadat manggan-ganasan situn lubung, maliuwan da dat dingngoḻ da ot adina mambalin dit bunga da. ");
INSERT INTO kmk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ot sadat bukoḻa naotdag sit naḻasa un pita, dida dat nabaḻu kan nanakoma tagu’n nangngoḻ sit ugud Apudyus ot adida linipsutan ot namunga da gaputa intultuluy da un tinuttuwa.” ");
INSERT INTO kmk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Inyabalig pay Jesus un, “Maid tagu’t manongog si pingki asina tangngoban onnu igga utnat sogwab katli, nu adi igga na utdit kustu’n iiggaan daḻapnu silawana nat nakoḻop. ");
INSERT INTO kmk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta naid naisuḻuk si adi maokaḻ onnu nailimod si adi matigammuwan kan maipakaawat. ");
INSERT INTO kmk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ot am-ammaan yu un dongḻon tun ibagak ta sadat tagu’n manuttuwa amo umad-adu dit maawatan da. Sat tagu’n adi manuttuwa utdit ipakaawat Apudyus kan siya makaana losan ulay sat akita naawatana.” ");
INSERT INTO kmk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Utdiyon dummatong dit inan Jesus kan dat susunnud na. Yoong adida nakaadani’n dagus ta nasugsugpet dat tagu utdi. ");
INSERT INTO kmk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Awad nangibaga kan Jesus un, “Andi da inam kan da sunud nu utdi un gasikadan sin lasina piyaon da un ilan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yoong kinnanan Jesus kan dida’n losan un, “Sadat dumngoḻ sit ugud Apudyus kan tungpaḻon da, dida ud inak kan susunud ku.” ");
INSERT INTO kmk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sin-aḻgawan nanlugan da Jesus kan dat disipulus na utdit bangka ot kinnanan Jesus un, “Mandoḻmang taku’t din domang ditu’n bananaw.” Ot kaysan da. ");
INSERT INTO kmk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Utdit dam-an da un dit manlullugana dumoḻmang, nasuyop si Jesus. Ot kakḻata lawa’n gummali ot sadit bangka da dandaniyon mapnu’t danum ot taḻona gaogyat. ");
INSERT INTO kmk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Umoy da pinukaw si Jesus un kanan dan, “Apu, Apu, lumikna ka ta maḻmos takuwon!” Gummangun si Jesus ot binilin na dit bali kan maḻukuḻukuta paḻuung ta guminok da. Ot gumminok da. ");
INSERT INTO kmk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Utdiyon imbagan Jesus sidat disipulus na un, “Kawad dit pammati yu kan sakon nu?” Nasnasdaaw kan nakakimut da ot nampaim-imkaw da un, “Singngadan kad nin ditu un tagu ta bilinona dat bayogbog kan paḻuung kad tuttuwaon da.” ");
INSERT INTO kmk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Intulutuluy da un dit nandoḻmang inggana’t dummangpot da utdin lakub din ili ud Gerasa un domang din ili ud Galilea. ");
INSERT INTO kmk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tumakdang man da Jesus inggaw tagu’n sinakayan di dimunyu utdiya ili un ummoy ummabot kan siya un nabayaga mantittiway kan adina inggaw sit boḻoy ta sat kalobḻobonan dit iinggawana. ");
INSERT INTO kmk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Makaino-inooy dit dimunyu kan siya ot ulay nu maikinawad dat ima kan iki na kan mabantayan naḻasu’n pogsatona ot iyaddag dit dimunyu utdit igawa maid tagtaguwan. Maila na man si Jesus, nampakuya nanlukgub sit atubang Jesus ot kapakpakuyana’n, “Jesus un anak Apudyus un kangattuwan apay lingalingom sakon? Pangaasim ta adiyak dusaon.” Imbagana di ta binilin Jesus dit dimunyu un tengyana dit tagu. ");
INSERT INTO kmk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ot inimusan Jesus un, “Sin nat ngadan nu?” Summungbata kanana’n, “Sakon si Sin-amaḻan.” Onta adu’n dimunyu dat ininggaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sadat dimunyu nampakpakaasi da kan Jesus un adina padaḻnon dida’t dit bitu un maid mangkigadan dit kaadaḻom na. ");
INSERT INTO kmk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Inggaw da ud sin-amaḻana boḻok un manubsubuk sit bakḻas dit bateleda adani kan dida. Ot nampakpakaasi dat dimunyu un ipalubus Jesus un sadat boḻok dat sakayan da. Ot pinalubusan Jesus dida. ");
INSERT INTO kmk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Utdi, tinengyan dat dimunyu dit tagu ot ummoy da nilumnok sidadit boḻok. Utdiyon nanggugunod dadit boḻok un kaysan sit gassud ot naotdag da utdit bananaw ot naamin da un naḻmos. ");
INSERT INTO kmk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mailan man dat tagu’n sin-ayyuwan sidat boḻok dit napasamak, nampatodtoddak da un ummoy nangipadamag sidat tagu’t dit ili kan kaadaniyana boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Utdi, ummoy dat tagu inila nu singngadan dit napasamak. Dakngon da man si Jesus, naila da dit tagu’n tinengyan dat dimunyu un mantutupak sit atubang Jesus. Nakabaduton kan nabaḻuwon dit angos na ot nakakimut da. ");
INSERT INTO kmk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sadat nakaila utdiya napasamak impadamag da nu in-inon dit kummiyaan dit laḻaki’n sinakayan di dimunyu. ");
INSERT INTO kmk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Utdiyon, amoamod dit kimut dat tagu’t din lakub Gerasa ot ummoy da imbaga kan Jesus un manaḻan. Ot nanlugan si Jesus sit bangka daḻapnu man-ulin. ");
INSERT INTO kmk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mansidi, sadit tagu’n tinengyan dat dimunyu nampakpakaasi kan Jesus un maitung-ud kan siya yoong pinadaḻan Jesus un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mangulin ka utdin boboḻoy yu ta ibagam sidat tagu dat losana kingwan Apudyus kan sika.” Ot kaysan dit tagu’n ummoy nangiwalagawag sidit kingwan Jesus kan siya utdan losan sin ili da. ");
INSERT INTO kmk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Utdit nan-ulin da Jesus sit domang bananaw, mataḻok dat adu’n tagu’n manguuway kan siya’t di. ");
INSERT INTO kmk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Utdiyon, dummatong dit osa’n pangaton dat dit sinagoga un mangngadan kan Jairo. Ot ummoy nampalintumong sit sinagung Jesus un nampakpakaasi kan siya ta umoy sit boḻoy na. ");
INSERT INTO kmk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ta sadit os-ossaana abeng na un babai un umoya kagwampuḻu’t duwa dit tawon na, matmattoyan. Utdit kaysanan daon, madabdabbil dat tagu’n naitung-ud kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ot inggaw osa’n babai kan dida un kagwampuḻu’t duwa’n dagunon un makaddaḻadaḻa un maida taḻon makaagas kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nakasuppenget sidat amoda tagu un ummoy sit awid Jesus ot sinekgel na dit lagayadan dit badut na ot dagusa naopdan dit daḻa na. ");
INSERT INTO kmk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Utdi, kinnanan Jesus un, “Singngadan dit nanekgel situn badut ku?” “Bokona sakon,” awad osa ya kanana. Ot kinnanan Pedro un, “Apu adim kad tigammu un madabbidabbil danat tagu’n nanliput kan sika?” ");
INSERT INTO kmk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“Awad nangagaḻa’n nanekgel kan sakon,” kinnanan Jesus “ta nagiknak un awad pannakabalin un lummaksun kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Utdit maawatan dit babai un tigammun Jesus dit napasamak kan siya, mamilpilpila ummoy nampalintumong sit atubang Jesus. Ot imbagana utdat losana tagu’t di nu apay un sinekgel na dit badut Jesus kan sadit dagusa kummiyaana. ");
INSERT INTO kmk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ot kinnanan Jesus kan siya un, “Anak ku, kummiya ka gapu’t pammatim kan sakon. Manaḻan kaona kapkapiya.” ");
INSERT INTO kmk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sissiya payyan si Jesus un mambagbagbaga utdit dumatong dit nanligwat sit boḻoy dit pangata nangibaag kan siya un, “Natoyon dit abeng nu, adimon lingalingon si Mistulu.” ");
INSERT INTO kmk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yoong dingngoḻ Jesus di ot kinnana na utdit pangat un, “Adika madanagan, basta manuttuwa ka ullawa kan sakon matagu payyan.” ");
INSERT INTO kmk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sumaaḻ man da Jesus sit boḻoy didit pangat, adina pinalubusan dat tagu’n makaḻnok kan siya malaksig kan da Pedro, Juan, Santiago kan sadat maḻong-ag dit abeng. ");
INSERT INTO kmk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mampaibila manlamat dat losana tagu’t di yoong kinnanan Jesus un, “Adi kayu man-ibil ta bokona natoy nat abeng. Masusuyopa lawa.” ");
INSERT INTO kmk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inyaamang da si Jesus gaputa tigammu da un natoyon dit abeng. ");
INSERT INTO kmk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yoong inadaniyan Jesus dit natoy ot inaggomana dit imana asina kinnanan un, “Anak ku, gumangun ka.” ");
INSERT INTO kmk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ummungaḻ dit abeng ot dagusa gummangun. Utdiyon imbagan Jesus un pakanan da. ");
INSERT INTO kmk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nasnasdaaw dat maḻong-ag dit abeng yoong binilin Jesus dida un maida taḻon mangibagbagaan da utdiya napasamak. ");
INSERT INTO kmk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pinandatdatong Jesus dat kagwampuḻu’t duwa’n apostoles na ot initdana dida’t pannakabalin kan kalintogan un mangaddag sidat losana dimunyu kan mampapiya’t dat masakit. ");
INSERT INTO kmk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Maabus man di imbaun na dida un umoy mangitudtudu utdit maipanggop sit mangiyapuwan Apudyus kan mampapiya utdat masakit. ");
INSERT INTO kmk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Imbagana kan dida un, “Maida pulus idallay yu utnat mangaḻyugan yu. Adi kayu man-idallay si suḻkud, pasiking, baḻun un makan onnu pilak onnu baduta mansukatan yu. ");
INSERT INTO kmk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nu awad mampaḻnok kan dikayu’t dit boḻoy na, siya’d inggawan yuwon inggana’t manaḻnan yu. ");
INSERT INTO kmk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yoong nu naid mamaḻnok kan dikayu utnat boboḻoya ayan yu, tengyan yu diya boboḻoy ot ikagkag yu dat gabu utdat iki yu si bintaga un madusa da.” ");
INSERT INTO kmk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Utdi, kaysan dat apostoles Jesus ot ummoy da utdit losana boboḻoy un inangiwalagawag sit Nabaḻu’n Damag kan nampapiya’t dat tagu’n masakit. ");
INSERT INTO kmk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Utdiyon nagngoḻ Herodes un siya ud mangiyapu utdin Galilea dit bagbagaon dat tagu maipanggop sidat kokkoon Jesus. Ot nabulubulung ta kanan dat uduma tagu un ummungaḻ si Juan un Mambubunyag. ");
INSERT INTO kmk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sadat udum kanan da un sadit Elias un nampaila. Ot sadat udum payyan kanan da un osa’n propetan Apudyus sidit aw-awe un ummungaḻ. ");
INSERT INTO kmk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yoong si Herodes kinnanana un, “Pinaputuḻ ku dit uḻun Juan ot singngadan na un tagu tun madamdamag ku?” Utdi, piyaona’n taḻon maila si Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Utdit nangulin dat apostoles un imbaun Jesus, imbaga da kan siya dat kingkingwa da. Ot indallay na dida un dida’l lawa utdit ili’d Betsaida ta ida man-illong. ");
INSERT INTO kmk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Matigammuwan man dat aduadu’n tagu inunud da dida. Nataḻok si Jesus un nangila utdat tagu’n dummatong ot tinudtuduwana dida maipanggop sit mangiyapuwan Apudyus kan pinapiyana pay dat masakit. ");
INSERT INTO kmk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Utdit gumidgidamon ummoy dat kagwam puḻu’t duwa un disipulus kan Jesus un kanan dan, “Maid tagtagguwan situ, padaḻnom dan tagu ta umoy da mangila’t manganan da kan umbogan da utdan adani’n boboḻoy.” ");
INSERT INTO kmk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yoong summungbat si Jesus un kanana’n, “Dikayu’d mangtod si kanon da.” Kanan da un, “Lima’n bukoḻa tinapay kan duwa un ikana lawa tun antu kan dikami. Siya a, nu umoy kami gumatang si ipakan sidatu’n amoamoda tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ta umoya lima’n libu dat laḻaki utdi un adi naibilang dat babai kan aabeng. Ot kinnanan Jesus kan dida un, “Mantupakon yu dida’n mauḻ-uḻmungon si sinlilimampuḻu.” ");
INSERT INTO kmk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tinungpal da dit imbagan Jesus un pinantupak da dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Inaḻan Jesus dit lima’n tinapay kan duwa un ikan asina nantangad langit un nanyaman kan Apudyus asina biniibiik dida un intod sidat disipulus na ta iwaḻas da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Losan da un nabsuga nangan. Ot sinupon da man dat nabun-an, napnu dat kagwampuḻu’t duwa un lakba. ");
INSERT INTO kmk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sin-aḻgawan, manlulluwaḻu si Jesus un sadat disipulus na ullawa dat buḻun na. Maabus man, inimus na kan dida un, “Singngadan dit kanan dat tagu kan sakon nu?” ");
INSERT INTO kmk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ot summungbat da un, “Sika kanu si Juan un Mambubunyag. Kanan pay dat udum un sika kanu dit Elias, yoong sadat udum payyan kanan da un osa kan propetan Apudyus sit aw-awe un ummungaḻ.” ");
INSERT INTO kmk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Yoong dikayu nu? Singngadan ku utnat kanan yu?” inyimus Jesus kan dida. Summungbat si Pedro un, “Sika dit Kristu un imbaun Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Utdi, binilibilin na dida un adida ibagbaga’t udum tu. ");
INSERT INTO kmk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kinnanana un, “Sakona Inyanak di Tagu masapula sagapaḻok dat adu’n ligat. Sumdiyan dat lalallakay di Judio, aap-apun di padi kan mimistulun di lintog sakon. Mapatoyak yoong paungaḻonak kan Apudyus utdin maikatlu’n aḻ-aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ot kinnanana kan dida’n losan un, “Nu sinnat mamiya un maidagamung kan sakon, masapula igongda naona somsomkon dit mataguwana uttun pita, bukudona dit kulus na asi umunud kan sakon. ");
INSERT INTO kmk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta sat tagu’n manaḻakug sit mataguwana’t tun pita, mataḻak na dit mataguwana’t inggaingga. Yoong sat tagu’n mataḻak na dit mataguwana’t tun pita maipagapu’t manuttuwaana kan sakon, maitdan si mataguwana’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngadan nat maganab nat osa’n tagu nu mangkuwa na dan losana binaknang situn lubung yoong mataḻak na dit mataguwana’t inggaingga? ");
INSERT INTO kmk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Singngadan na mana mangibain kan sakon pada na pay sidan tudtuduk, ibain ku pay nu mangulinak. Ot nu mangulinaka Inyanak di Tagu, awad kan sakon dit nakaskasdaawa kinangatun Amak ot buḻun ku dan anghel. ");
INSERT INTO kmk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ot tuttuwa tun ibagak un, dikayu’n awad sinsatun awad da ud adi yan matoy inggana’t maila da dit mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lumabas man umoya waḻu’n aḻgaw sit nangibagaan Jesus sidatu, indallay na da Pedro, Juan kan Santiago un nanagada’t dit bateleda umoy manluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Madama mana manlulluwaḻu, nabaliwan dit ilan Jesus ot sat badut na manilisiling dit kapoḻkas na. ");
INSERT INTO kmk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kakḻata inggaw da ud duwa’n tagu un makabagbagbaga kan siya un sada Moses kan Elias. ");
INSERT INTO kmk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mampasiling pay dit ila da ot nambabagbagaan da dit dandani’n mapatoyan Jesus un tungpaḻona’t din Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si Pedro kan dadit buḻun na, amod dit suyop da yoong nakalikna da ot naila da dit doḻang Jesus kan sadadit duwa’n sumisikad sidit sog-on na. ");
INSERT INTO kmk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Utdit tengyan dat duwa’n laḻaki si Jesus kinnanan Pedro kan siya un, “Apu, napiya ta antu taku’t tu. Mangwa kami si tuḻu’n sigay ta mangkuwam nat osa, mangkuwan Moses nat osa kan mangkuwan pay Elias nat osa.” Yoong adin Pedro sinomsomoka ummuna dit imbaga na. ");
INSERT INTO kmk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Utdiya mangibagbagaana’t di, inggaw bunot un nangayyung kan dida ot amod dit kimut da utdit sinakubuwana da Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Inggaw ginga un nanligwat sit bunot un kanana’n, “Siyatu ud Anak ku un pinilik, dumngoḻ kayu kan siya.” ");
INSERT INTO kmk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Utdit guminok dit ginga, si Jesus ullawaon dit ininggaw. Ot naid nangibagbagaan da utdiya timpu utdat naila da. ");
INSERT INTO kmk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mabigat man sidit nakagusad daon sidiya bateled, aduadu’n tagu un ummoy ummabat kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kakḻata napanakuy dit osa un kanana’n, “Mistulu, pangngaasim ud ta ilam tun os-ossaana abeng ku un laḻaki. ");
INSERT INTO kmk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta awad dimunyu un kanayuna sumakay kan siya ot nu sakayana kakḻata mapanakuy un manwogowogowog inggana’t manlaḻabḻab tun sangi na. Palpaligatona’n taḻon ot adina matetengyan. ");
INSERT INTO kmk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kindaw ku un addagon danat disipulus nu yoong adida mabooḻan.” ");
INSERT INTO kmk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Summungbat si Jesus un, “Ay, naid pammati yu un tagu’t tuwa lonap kan bokobokon nat somsomok yu. Kamaan nat kabayag ku un iinggaw kan mangiyaanus kan dikayu inggana’t manuttuwa kayu?” Utdi kinnana’n Jesus sidit ama un, “Idatong nu uttu nat abeng nu.” ");
INSERT INTO kmk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kumatkatam man dit abeng kan Jesus, indubḻang dit dimunyu ot pinanwogowogowog na. Yoong inggimaun Jesus dit dimunyu. Pinapiyan Jesus dit abeng asina inyulin kan amana. ");
INSERT INTO kmk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Losan dat tagu’n nasnasdaaw sidit amoda pannakabalin Apudyus. Utdiya masmasdaawan da utdat losana kingwan Jesus, kinnanana utdat disipulus na un, ");
INSERT INTO kmk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ammaan yu kad dongḻon tun ibagak kan dikayu. Sakon un Inyanak di Tagu dandaniyon un maiyawatak sidat tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yoong adida naawatan dit imbagana ta nailimod dit kaipooyana kan dida. Ot umogyat da un mangimus kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Adina mabayag nampasungsungbat pay lawan dadit disipulus nu singngadan na kan dida dit kangattuwan. ");
INSERT INTO kmk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tigammun Jesus dit somsomok da ot nangaḻa si abeng asina pinasikad sit sog-on na. ");
INSERT INTO kmk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ot kinnanana kan dida un, “Singngadan na mana mangawat situwa abeng un ipagapu na kan sakon, sakon ud inawat na. Singngadan na mana mangawat kan sakon, inawat na pay dit nangibaun kan sakon. Ot sat kadobaan kan dikayu, siya ud gattoka kangattuwan.” ");
INSERT INTO kmk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Utdi, gumminga si Juan un kanana’n, “Apu, nakaila kami si tagu un man-addag si dimunyu un usalona nat ngadan nu. Yoong inyapa mi dit koona ta bokona buḻun taku.” ");
INSERT INTO kmk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yoong kinnanan Jesus kan siya un, “Adiyu iyapa ta sat tagu’n adi gumusuḻ kan dikayu, buḻun yu.” ");
INSERT INTO kmk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Utdit dandaniyon dit mangulinan Jesus ud langit, ingkoddong na un taḻona umoy ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ot nangibaun si uduma tagu un umun-una nu siya. Kadon ummoy dat naibaun sit osa un boboḻoy sidin Samaria ta ida managana si inggawana. ");
INSERT INTO kmk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yoong sadat tagu’t di adida piyaona paḻnokon si Jesus sit boboḻoy da gaputa natigammuwan da un umoy ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Magngoḻan man da Juan kan Santiago un disipulus na tu, kinnanan da un, “Apu, piyaoma ayagan mi dit apuy un manligwat langit ta sobgona dida?” ");
INSERT INTO kmk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yoong ummaswing si Jesus ot inggimau na dida. ");
INSERT INTO kmk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ot magangput man di kaysan da si uduma boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Utdi un manaddaḻanan da inggaw osa un laḻaki un maitungtung-ud kan siya un kanana’n, “Apu, maitung-udak kan sika si kigada ayam.” ");
INSERT INTO kmk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Summungbat si Jesus un kanana’n, “Unnay pay dan buwot ta awad lunguga inggawan da kan dat sissiwit ta awad lubu da. Yoong sakona Inyanak di Tagu, naid boḻoy ku ut man-illongak.” ");
INSERT INTO kmk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Utdi, kinnanan Jesus sit osa kan dida un, “Maitung-ud ka kan sakon.” Yoong summungbat dit laḻaki un kanana’n, “Apu, oni ta umoyak yan ilbon si amak.” ");
INSERT INTO kmk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Summungbat si Jesus un, “Bay-am ta sadat adi manuttuwa kan sakon ud mangilbon sidat natoy kan dida. Yoong nu sika, umoy kaot iwalagawag dit maipanggop sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kinnanan pay dit osa un, “Maitung-udak kan sika Apu, yoong umoyak yan ipalang sidat kabboḻoy ku.” ");
INSERT INTO kmk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kinnanan Jesus kan siya un, “Sat manlugi’n mangaḻadu ta maka-aswiaswing sit awid na bokona naselbi utdin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Maabus man di, namili si Jesus si pitumpuḻu ya duwa payyana tagu un ibaun na un sindogwa ta umun-una da nu siya utdan losana boboḻoya ayana. ");
INSERT INTO kmk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sit daan da un manaḻnan, kinnanan Jesus kan dida un, “Adu dat adi makatigammu kan sakon yoong akit dan manudtudu kan dida un kama’t din adu un maani yoong akit dan man-ani. Isunga iluwaḻu yu kan Apudyus un sinkuwa’t din maani ta mangibaun si ad-adu payyan un man-ani. ");
INSERT INTO kmk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ingkayunon. Ot dongḻon yu, kama kayu’t ubbun di kannelu un ibaun ku utdan tanana asu. ");
INSERT INTO kmk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Adi kayu mambaḻun si pilak onnu mangawit si pasiking onnu kapatus. Adi kayu mailomga’n makabagbaga si tagu utdan daḻan yu. ");
INSERT INTO kmk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Singngadan na mana boḻoy nat longkon yu, umuna’n ibaga yu un, ‘Iluwaḻu mi ta ipooy Apudyus un kapkapiya kayu uttuwa boḻoy.’ ");
INSERT INTO kmk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ot nu awad mamiya kan dida un kapkapiya, maituttuwa un kapkapiya da. Yoong nu naid, maugnut dit imbaga yu. ");
INSERT INTO kmk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Makaigaw kayuwon kan dida utdiya boḻoy un adi kayu umali-alis si uduma boḻoy. Ot kanon yu kan inumon yu dan isunad da kan dikayu ta kalobbongan yu di un kama’t tangdan yu un mangkokwa. ");
INSERT INTO kmk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nu awad dakngon yu si ili ta paḻnokon dikayu’t dat tagu, kanon yu nu singngadan nat maisunad kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Papiyaon yu dat masakit sidiya ili ot ibaga yu kan dida un, ‘Adaniyon kan dikayu dit mangiyapuwan Apudyus.’ ");
INSERT INTO kmk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ot nu awad dakngon yu ut ili ta adi dikayu paḻnokon umoy kayu’t dan kaḻsa ta ibaga yu kan dida un, ");
INSERT INTO kmk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ulay satu’n gabun tun ili yu un naipakot situn iki mi punasan mi ta bintaga’n madusa kayu. Ot somsomkon yu un ummadani kan dikayu dit mangiyapuwan Apudyus.’ ");
INSERT INTO kmk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ibagak kan dikayu un, un-unnay dit dusan dat iSodoma nu san dusan dat tagu’t diya ili nu timpu’n mangukuman Apudyus,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Intuluy Jesus dit nambagbaga un kanana’n, “Kaasi kayu un iCorazin kan iBetsaida ta adu dat kingwaka nakaskasdaaw sidin ili yu yoong adi kayu kampay nandadaoli. Nu utdin Tiro kan Sidon ud nakwaan da, dagus okyana nambadut da si ganggoti kan nantutupak da utdit kagabuwan un mangipail-an da un taḻona mandadaoliyan da dat basuḻ da. ");
INSERT INTO kmk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Isunga ibagak kan dikayu un, un-unnay din dusan dan iTiro kan iSidon nu san dusa yu un iCorazin kan iBetsaida nu timpu un mangukuman Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ot dikayu paya iCapernaum, sanat kanan yu maidayaw kayu’d langit? Bokon! Maidawat kayu’t din impiyelnu.” ");
INSERT INTO kmk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Imbagan pay Jesus un, “Sat tagu’n dumngoḻ sidat itudtudu yu, sakon ud taḻona dongḻona. Sat tagu’n sumumdi kan dikayu, sakon ud taḻona sumdiyana. Ot sat tagu’n sumumdi kan sakon, sumdiyana pay dit nangibaun kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Utdit nangulin dat pitumpuḻu’t duwa’n imbaun Jesus, nantattaḻok da ot imbaga da kan Jesus un, “Apu, ulay sadat dimunyu tuttuwaon dikami nu addagon mi dida un usalon mi nat ngadan nu.” ");
INSERT INTO kmk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Summungbat si Jesus un kanana’n, “On, nailak si Satanas un naotdag un kama si kilat un nanligwat langit. ");
INSERT INTO kmk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dongḻon yu tun ibagak. Initdak dikayu si pannakabalin un mangabak sit losana pannakabalin ud kabusuḻ taku un si Satanas. Ot ulay dabbokon yu dan uḻog kan gayyaman adida dikayu kalkaling-on. ");
INSERT INTO kmk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yoong ulay nu kama’t nata tuttuwaon dikayu’t dat dimunyu, masapula bokona siya di dit mataḻokan yu nu adi san naikanglitan dan ngadan yu ud langit.” ");
INSERT INTO kmk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Utdi payona timpu, pinan-ang-anggom Ispiritu Santu si Jesus ot nanluwaḻu un kanana’n, “Manyamanak Ama un Apu ud langit kan situn pita ta impatigammum sidat bokona diadaḻ dat inlimod nu utdat nasilib kan diadaḻ. On, yamanok Ama ta siya’d piniyama makwaana.” ");
INSERT INTO kmk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maabus mana manluwaḻu kanana’t dat tagu un, “Impulang Amak kan sakon dat losana banag. Ot maid kustu’n makatigammu’t dan losana maipanggop kan sakona Anak Apudyus nu adi si Amak. Padana pay un maid gattoka makatigammu’t dan losana maipanggop kan Amak nu adi sakona Anak na kan singngadan na mana piyaoka mangipatigammuwan.” ");
INSERT INTO kmk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Utdi, nansagung si Jesus sidadit disipulus na ot kinnanana kan dida pay lawan, “Nagasat dan makaila utdat losana mailayu uttun satun. ");
INSERT INTO kmk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tuttuwa tun ibagak un aduadu’n propetan Apudyus kan al-ali utdit un mamiya’n makaila utdat mail-ila yu yoong maid inila da. Piyaon da pay makagngoḻ sidan dongdongḻon yu yoong maid dingngoḻ da.” ");
INSERT INTO kmk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Utdi, inggaw osa’n mistulun di lintog un ummoy namadpadas kan Jesus un kanana’n, “Mistulu, ngadan nat kook daḻapnu matawid ku dit mataguwak si inggaingga?” ");
INSERT INTO kmk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kanan Jesus kan siya un, “Ngadan dit kanan dit naikanglita Ugud Apudyus? Innon din man-aawat nu?” ");
INSERT INTO kmk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Summungbat dit laḻaki un, “Masapula iyossaan nu nat losana aangsom, losana bilog nu, kan losana somsomok nu un mamippiya kan Apudyus kan masapula piyaom dan buḻun nu un kama’t nat mampipiyam sinat long-ag nu.” ");
INSERT INTO kmk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kanan Jesus kan siya un, “Kustu nat insungbat nu. Siya’d koom ot awad mataguwam si inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yoong piyaon dit mistulun di lintog ikalintogan dit long-ag na ot inimus na uman kan Jesus un, “Ngadan dan buḻun ku un piyaok nu?” ");
INSERT INTO kmk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Inyabalig Jesus dit sungbat na un kanana’n, “Sin-aḻgawan, inggaw osa’n Judio un gumusagusada nanligwat Jerusalem un umoy Jerico. Yoong inggaw man sit kaḻsa inabat na dat tulisan un nangaḻa’t dat losana kukuwa na. Nilabusan da kan pinangpang-ok da asida tinengyana matmattoyan. ");
INSERT INTO kmk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Utdi, naisammu un nanlaus dit osa un padin di Judio un gummusad sidit kaḻsa. Maila na man dit tagu, nanliglig sit biik dit daḻana lummaus. ");
INSERT INTO kmk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Inggaw payyan Judio un kaganakan Levi un nangoy sidi ot dumatong man sit ininggawan dit tagu, naila na yoong nilausana umana lawa un niligligan. ");
INSERT INTO kmk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Yoong inggaw osa’n Samaritano un nangoy pay sidiya daḻan. Maila na man dit matmattoyan, nadaguwan. ");
INSERT INTO kmk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ummoy na inisigan dat sugat na si lana kan alak, asina binobobobod. Utdiyon, pinangkabayu na dit tagu utdit kabayu na asina inyoy sit boḻoya oobgan di kakkaili un siya’d nangandogana kan siya utdiya labi. ");
INSERT INTO kmk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Mabigat man, nangitod si pilak sidit singkuwa’t dit boḻoy asina kinnanan un, ‘Pangaasim ta ayyuwanam tuwa tagu ot nu adina umanay tun itdok asik dogaan nu mangulinak.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Utdi, inyimus Jesus sidit mistulun di lintog un, “Utnat somsomok nu ngadan na utdat tuḻu un lummaus dit kustu un buḻun dit tagu’n pinangpang-ok dat tulisan?” ");
INSERT INTO kmk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Summungbat dit mistulun di lintog un, “Sadit osa un nangaasi kan siya.” Kanan Jesus kan siya un, “Siya, ot ikan ta siya’d koom pay dit kingwana.” ");
INSERT INTO kmk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Utdit manaddaḻanan da Jesus un umoy Jerusalem, dintong da dit osa’n boboḻoy ot inggaw osa’n babai’n mangngadan kan Marta un nangawis kan dida utdit boḻoy da. ");
INSERT INTO kmk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Inggaw sunud Marta un babai’n mangngadan kan Maria. Utdit mantudtudu si Jesus ummoy si Maria nantupak sit sog-on dit ikin Jesus un mandodongngoḻ sidit itudtudu na. ");
INSERT INTO kmk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yoong si Marta maallew sit mansaganaana ot inummoy kan Jesus un kanana’n, “Apu, adim kad maila un tinengyanak kan sunud ku un ossaan un man-as-aswinga mansagana? Ibagam ud kan siya ta tuḻunganak.” ");
INSERT INTO kmk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kanan Apu Jesus un, “Marta, Marta, kaadu’n ullawan di madanagam kan mabulungam. ");
INSERT INTO kmk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ossaana lawa’d kapotgan ot siya’d pinilin Maria, ot maid makaaḻa kan siya uttuwa pinilina.” ");
INSERT INTO kmk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sin-aḻgawan, manlulluwaḻu si Jesus. Gangputona man dit luwaḻu na osa utdat disipulus na dit ummadani kan siya un kanana’n, “Apu, tudtuduwam ud pay dikami un manluwaḻu un padan Juan un nantudtudu’t dat disipulus na.” ");
INSERT INTO kmk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kinnana’n Jesus kan dida un, “Nu manluwaḻu kayu siya tu tun kanan yu. ‘Ama, iluwaḻu mi un madaydayaw nat ngadan nu. Iluwaḻu mi un dumatong nat man-apuwam. ");
INSERT INTO kmk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Itdom dan kanon mi un inaḻgaw. ");
INSERT INTO kmk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakawanom dan basuḻ mi un padan dit mamakawanan mi utdat makabasuḻ kan dikami. Ot adim ipalubusa masugsugan kami.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ot kinnanan pay Jesus sidat disipulus na un, “Kaspangaligan ta osa kan dikayu ud umoy sit gayyom na si gawan di labi ot kanana un, ‘Gayyom, pangngaasim ta pabuludanak si tuḻu’n tinapay nu ");
INSERT INTO kmk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta awad gayyom ku un dummagas ot maida taḻon isunad ku kan siya.’ ");
INSERT INTO kmk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Yoong madin dit gayyom na mambukat ta kanana un, ‘Adika lumingaling ta nasaḻudsudan nat sawang kan masuyop kamiyon. Nasadutaka gumangun.’ ");
INSERT INTO kmk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Ibagak kan dikayu un ulay nu gayyom na, adina piyaona gumanguna mangtod. Yoong gaputa adin kampay dit awad sit lasin lipsutan dit mangkodaw, mangtoda lawa utdat masapul dit gayyom na. ");
INSERT INTO kmk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ot padana pay un ibagak kan dikayu, adi kayu lumipsuta mangkodaw kan Apudyus sidan masapul yu ot itdona kan dikayu. Adi kayu lumipsuta man-inap sidan masapul yu ot tuḻungan dikayu kan siya un mangdas. Adi kayu lumipsuta mangkogkog sit sawang na ot ibukatan dikayu kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta losana mangkodaw kan Apudyus maitdan, losana man-inap makaodas kan losana mangkogkog sit sawang na maibukatan. ");
INSERT INTO kmk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Apay awad kad ama un mangtod si uḻog sinat abeng na nu mangkodaw si ikan? ");
INSERT INTO kmk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Onnu mangitod si ammabuy nu mangkodaw si iplug? Maid. ");
INSERT INTO kmk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ot nu dikayu un nadadaga tagu tigammu yu un mangitod si napiya utdan anak yu, amodot kan Ama yu ud langit ta itdona pay si Ispiritu Santu kan dikayu nu kodawon yu!” ");
INSERT INTO kmk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sin-aḻgawan, inaddag Jesus dit dimunyu’n nampaumoḻ sidit tagu. Utdit tinengyan dit dimunyu dit tagu makabagbagaon ot nasnasdaaw dat nakaila. ");
INSERT INTO kmk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yoong inggaw da ud udum un kanan da un, “Si Beelzebub un pangat dat dimunyu ud nangitod kan siya utnat pannakabalin na un mangaddag sidan dimunyu.” ");
INSERT INTO kmk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yoong inggaw da pay uduma mamadpadas kan Jesus ot kindaw da un mangipaila’t am-amug ta mamnokan da nu tuttuwa’n nanligwat kan Apudyus dit kabooḻana. ");
INSERT INTO kmk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yoong tigammun Jesus dit somsomok da ot kinnanana kan dida un, “Sanat ili un mambibinnusuḻ pay lawan dan tagu na, adina mandonoy. Padana pay sidat simbaḻyana mambibinnusuḻ da pay lawan, makaskasway da. ");
INSERT INTO kmk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ot nu mambibinnusuḻ da Satanas kan dat buḻun na, adina mandonoy dit mangiyapuwana. Ta kanan yu un man-addagak si dimunyu un si Beelzebub dit mangitod si pannakabalin ku un mangaddag. ");
INSERT INTO kmk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ot nu si Beelzebub dit nangitod si pannakabalin ku un mangaddag si dimunyu, ngadan nat nangitod si pannakabalin danat buyut yu un mangaddag si dimunyu nu? Sadan buḻun yu pay lawan ud mamanoknoka bokon nat kanan yu. ");
INSERT INTO kmk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ot gaputa si Apudyus ud nangitod si pannakabalin ku un mangaddag si dimunyu, siya ud mangil-an un dummatongon kan dikayu din mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nu sanat osa’n gumibiloga tagu ta nasasaggana dat almas na un mangandog sit boḻoy na, maid makaakaw sidat kukuwa na. ");
INSERT INTO kmk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yoong nu amo nabilog nu siya dit umoy un mangabak kan siya, aḻana’n aminon dat almas un manaḻgod dit singkuwa’t dit boḻoy asina goggogwaon dat samsam na utdat buḻun na. ");
INSERT INTO kmk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Sat tagu’n adi gumungguy kan sakon, busuḻona’d sakon. Ot losan dat tagu’n adi tumuḻunga mangawis sidat tagu un manuttuwa kan sakon, dida’d mangiyad-adayu’t dat tagu kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Intuluy Jesus un kanana’n, “Nu lumaksun nat nadadaga ispiritu utnat tagu’n sinakayana, umoy man-ayaayaw sidit igawa naid si danum un man-inap si uduma man-illongana. Nu maid odasana’t inggawana kanana un, ‘Mangulinak sit boḻoy ku un tinengyak.’ ");
INSERT INTO kmk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ot mangulin kad dakngona dit tagu un kama’t boḻoya nadaḻus kan nauḻnus un naid payyan inggaw. ");
INSERT INTO kmk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Utdi, umoy mangidallay si pitu’n ispiritu’n amo nadaddadag nu siya ot longkon da un igawan diya tagu. Kadon amo nadaddadag dit kasasaad didiya tagu nu sadit damu.” ");
INSERT INTO kmk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Utdiya mambagbagaan Jesus inggaw babai’t dat kaaduwana indangsoḻ na dit gingana un kanana’n, “Taḻona nagasat dit babai un nangiyabeng kan nanagibi kan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yoong kinnanan Jesus un, “On, yoong nagasgasat dat dumngoḻ kan manungpal sit ugud Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Utdit umad-adu dat tagu’n mangkadatong nambagbaga’t Jesus un kanana’n, “Nadadag dan tagu’t tun satuna lonap. Man-inap da si am-amuga mangilasinan da un imbaunak kan Apudyus yoong maid udum si mangilasinan ut ipailak nu adi sat naipasamak kan Jonas sidit aw-awe. ");
INSERT INTO kmk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ta sat napasamak kan Jonas dit nangil-an dat iNineve un si Jonas imbaun Apudyus. Ot padana pay un sat mapasamak kan sakon un Inyanak di Tagu dit mangil-an dat tagu un si Apudyus ud nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ot nu dumatong dit aḻ-aḻgawa maukuman dat losana tagu sumikad tu dit babai’n apun dat iSeba utdit aw-awe un mamabasuḻ sidat tagu’t tun satun. Ta nanligwat sin adaddayuwana ili un ummoy nandongoḻ sit ugud didit nalainga Ali Solomon. Yoong antu kan dikayu ud nangatngatu nu si Ali Solomon yoong adiyu dongḻon. ");
INSERT INTO kmk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Utdiya aḻ-aḻgawa maukuman dat losana tagu, sumikad tu dat iNineve un mamabasuḻ sidan tagu’t tun satun. Ta utdit nagngoḻan dat iNineve dit intudtudun Jonas, nandadaoliyan da dat basuḻ da. Ot antu kan dikayu’d nangatngatu nu si Jonas yoong adiyu tuttuwaon.” ");
INSERT INTO kmk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kinnanan payyan Jesus un, “Maid tagu’t manongog si pingki asina isuḻuk onnu tangban si duyas nu adi igga na utdit kustu un iiggaan di pingki daḻapnu sadan tagu’n lumnok maila da dit padda na. ");
INSERT INTO kmk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“San ata yu kama nu siya’d silaw nat long-ag yu. Isunga nu napadda nat ata yu, napadda nat losana long-ag yu. Yoong nu nadaḻam nat ata yu, nakoḻop pay nat losana long-ag yu. ");
INSERT INTO kmk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Isunga ilan yu ta sanat silaw un awad kan dikayu tuttuwa’n napadda un bokona napangot. ");
INSERT INTO kmk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ta nu nasilawan nat losana long-ag yu un naid akit si koḻop na, taḻona napadda un kama nu masisillawan si napaddapadda’n silaw.” ");
INSERT INTO kmk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Magangput man Jesus un ibaga di, inawis dit osa’n Fariseo utdit boḻoy na ta umoy makakan kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Inummoy si Jesus ot utdit mangan da nasdaaw dit Fariseo ta adin Jesus nambuḻu un kama’t dit kadawiyana mambubuḻu da nu daan dan mangan. ");
INSERT INTO kmk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ot kinnanan Jesus kan siya un, “Dikayu’n Fariseo kama kayu’t tagu’n sad kiwasana ullawa dat lasin dat tasa kan da pinggan. Ta buḻuwan yu dat ima yu yoong sanat daḻom yu napnu’t kinaagum kan kinadadag. ");
INSERT INTO kmk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Natingtingangan kayu! Bokon kad un si Apudyus un nangwa’t dit makindaḻom, kingwa na pay dit makinlasin? ");
INSERT INTO kmk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Daḻusan yuwot nat aangson yu ot itdon yu utdan kakkaasi dat awad kan dikayu kad nadaḻus dat losana kakigad yu. ");
INSERT INTO kmk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yoong kakkaasi kayu pay un Fariseo. Ta itdon yu kan Apudyus ud ingkapuḻun nat losana apit yu un mampabangu’t tipoy yoong niliwayan yu un koon dan nalintog kan niliwayan yu un piyaon si Apudyus. Siyadatu dan lumbonga umuna’n tungpaḻon yu un adiyu pay liwayan dan udum. ");
INSERT INTO kmk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kaasi kayu un Fariseo ta pipiyaon yu un mantupak sit sangu utdin sinagoga kan pipiyaon yu nu dayawon dikayu nu umoy kayu’t dan aabtan di tagu. ");
INSERT INTO kmk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaasi kayu! Kama kayu’t dan lobona maid iimmatunana un dabdabbokona lawan dat tagu ta adida tigammu un lobon.” ");
INSERT INTO kmk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Utdi, osa’t dat mimistulun di lintog dit summungbata kanana’n, “Mistulu, maitagom kami paya mabainan sinata imbagam.” ");
INSERT INTO kmk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Kaasi kayu pay un mimistulun di lintog,” kinnanan Jesus. “Kama kayu’t mampabukud sidan tagu si nadagsona awit sinat adu’n bilina ipatungpal yu yoong adi kayu’n taḻon sumaḻak. ");
INSERT INTO kmk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kakkaasi kayu ta pabaḻuwon yu dat lobon dat propetan Apudyus un pinatoy dat inapu yu utdit aw-awe. ");
INSERT INTO kmk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Siya’d mangipaila un piniya yu dit kingwa da ta pinatoy da dida asiyu pabaḻuwon dat lobon da. ");
INSERT INTO kmk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Satu’d mangipaila utdit kinasilib Apudyus ta kanana’t dit aw-awe un, ‘Mangibaunak kan dida si adu’n propetak kan apostoles yoong patoyon da dat udum kan dida kan palpaligaton da dat udum.’ ");
INSERT INTO kmk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Isunga dikayu’n tagu uttun satuna lonap dan madusa maipagapu’t dit napatoyan dat losana propetan Apudyus manlugi’t dit nakwaan tun lubung ingga na uttun satun. ");
INSERT INTO kmk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Manlugi’t dit napatoyan Abel inggana kan Zacarias un pinatoy da utdit boḻaat dit altar kan timplu. On, ibagak kan dikayu un sungbatan dan tagu’t tuwa lonap dit napatoyan da nu dumtong nat timpu. ");
INSERT INTO kmk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kaasi kayu un mimistulun di lintog ta linappodan yu dat tagu utdit makaawatan da utdit katuttuwaana maipanggop kan Apudyus. Adiyu piyaona tuttuwaon ot lappodan yu pay dan mamiya un manuttuwa.” ");
INSERT INTO kmk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tengyan man Jesus diya boḻoy inlapun dat mimistulun di lintog kan Fariseo un suganggangon si Jesus kan pasungbaton sidat nadumaduma un imus da. ");
INSERT INTO kmk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ta uuwayon da nu awad maisungbat na si mangidaḻuman da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kad pay sidiyon, madabdabbil dat aduadu’n tagu’n naammung un ulaya lawa’n mandidinnabbok da si iki. Inun-unan Jesus binagbaga dat disipulus na un kanana’n, “Alimbanan yu dit bubud dan Fariseo. San piyaoka ugudon sadit kinaman-ag-agin da. ");
INSERT INTO kmk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta maid mailimod si adi maikoḻwag onnu maisuḻuk si adi maipaḻtaw nu dumtong din timpu na. ");
INSERT INTO kmk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Isunga singngadan na mana inlimod yu un imbaga maikoḻwag ot sat inyagasaas yu utdin kuwaltu maipalawag sidan kataguntagu.” ");
INSERT INTO kmk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Intuluy Jesus ot kanana’n, “Ibagak kan dikayu’n gagayyom ku un adi kayu umogyat sidan kumatoy si long-ag un siya ullawa’d mabalina makwa da. ");
INSERT INTO kmk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yoong ibagak kan dikayu dit gattoka iyogyat yu. Iyogyat yu si Apudyus ta mabalin na un patoyon tun long-ag kan siya ullawa ud awad si pannakabalin un mangipagkaḻ sit kadogwa yu utdin impiyelnu. On, ibagak kan dikayu un siya ud gattoka iyogyat yu. ");
INSERT INTO kmk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ta si Apudyus, bokona liuwana dikayu. Somsomkon yu dan tilin un duwa’n sipinga lawa dit bayad dat lima yoong maid osa si liuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ulay nat buuk yu tigammun Apudyus nat bilang na. Siya’d gapuna un adi kayu umogyat ta napotpotog kayu kan Apudyus nu sadan tilin.” ");
INSERT INTO kmk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Intuluy Jesus un kanana’n, “Ibagak kan dikayu, un singngadan na mana mangipudnu utdan tagu utdit manuttuwaana kan sakon, sakona Inyanak di Tagu ipudnuk pay sidan aanghel Apudyus un manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yoong sat mangisulib sidan tagu utdit manuttuwaana kan sakon, isulib ku pay sidan aanghel Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mapakawan nat tagu’n mangibaga’t nadadaga maisuganggang kan sakona Inyanak di Tagu yoong sat tagu un mangibaga si lawenga maisuganggang kan Ispiritu Santu adina un taḻon mapakawan. ");
INSERT INTO kmk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nu idallay dikayu’t dan sinagoga daḻapnu imusan dikayu onnu idallay dikayu’t dan tutulay onnu utdat nangangatu un pangat adi kayu madanagan nu inon dit mansusungbat yu onnu ngadan nat ibaga yu. ");
INSERT INTO kmk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ta utdiya timpu si Ispiritu Santu dit mangipatigammu kan dikayu’t dit masapula ugudon yu.” ");
INSERT INTO kmk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Utdi, inggaw osa’n laḻaki’t dat kaaduwan un kanana kan Jesus, “Mistulu, ibagam man kan sunud ku ta igogwaanak sidan tawid mi kan amami.” ");
INSERT INTO kmk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Imbagan Jesus kan siya un, “Maid kalintogaka mamingay kan dikayu utdin tawid yu. Bokona sakon nat mangwa’t nat.” ");
INSERT INTO kmk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Utdi, intulutuluy na un nambagbaga kan dida’n losan un kanana’n, “Ilan yu kan alimbanan yu dan losana ilan di kinagamgam. Ta san kaandun di mataguwan di osa’n tagu’t tun pita bokona maibasal sit sanikuwana ulay nu taḻona baknang.” ");
INSERT INTO kmk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ot imbagan Jesus tuwa abalig kan dida un, “Inggaw osa’n baknanga tagu un aduadu dit naapit na utdit pita na. ");
INSERT INTO kmk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ot nansomsomok un kanana’n, ‘Ngad kan nin kook? Bang-og din aḻang ku un mamintokak sidan apit ku.’ ");
INSERT INTO kmk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mansidi kanana un, ‘Ay, siyatu ud kook. Gosayok din aḻang ku ta mangwaak si dakodakoḻana mamintokak sidin apit ku kan mamonponak sidan losana kukuwak. ");
INSERT INTO kmk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Asik kanan kan sakon pay lawan un, ‘Nagasatak ta amoamod tun apit ku ot ulay piga’n daguna adiyak mangkokwa nasawaḻona kanok. Ot sad kook mangamanganak, mansussuyopak kan man-gan-ganasaka lawa.’ ");
INSERT INTO kmk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yoong kinnanan Apudyus kan siya un, ‘Tung-ug ka. Satu un labi matoy ka ot singngadan naon dit singkuwa utdatu’n losana tinugpun nu?’ ” ");
INSERT INTO kmk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ot inyanungus Jesus imbaga un, “Siya tu ud doḻasan dan manugtugpun si binaknang da uttun pita yoong kapus da utdit man-iilan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Utdi, imbagan Jesus sidat disipulus na un, “Isunga ibagak kan dikayu un bokona sat makan onnu badut ud ikadanag yu ");
INSERT INTO kmk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ta napotpotog nat mataguwan yu nu san makan kan napotpotog nat long-ag yu nu san badut. ");
INSERT INTO kmk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilan yu dan gowak. Adida mammuḻa onnu man-ani, naid aḻang da yoong itdan Apudyus dida’t kanon da. Amo napotpotog kayu nu sadan sissiwit! ");
INSERT INTO kmk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Singngadan na kan dikayu ud makaisuḻut si sinsikuwan sit mataguwana udsi mandandanagana? ");
INSERT INTO kmk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ot nu siya di un adiyu kapuuta mangwa si kama’t di un kaakkikita banag, apay un madanagan kayu’t dan uduma banag. ");
INSERT INTO kmk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Somsomkon yu din mandadakoḻ dan simalona sabsabung. Adida mangkokwa onnu mangganay yoong ibagak kan dikayu un amo napippiya din ila da nu sadat nangkababanola badut Ali Solomon. ");
INSERT INTO kmk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ot nu siya di un papiyaon Apudyus dat simalona sabsabung un matagu’t tun aḻgaw yoong mabigat kad sobgon da dida, bokon kada amo sosomkona dikayu ot itdona dat mambadut yu? Nakapsuta taḻon nat pammati yu. ");
INSERT INTO kmk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bokona sadan kanon onnu inumon yu dan in-inapon yu kan bokona siya’d mabulungan yu. ");
INSERT INTO kmk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta siya datu dan gamgamgaman dan tagu’t tun lubung un adi makatigammu kan Apudyus. Yoong nu dikayu, tigammun Ama yu ud langita kasapulan yu datu. ");
INSERT INTO kmk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sad isosomok yuwot nat mangiyapuwan Apudyus kan dikayu ot itdona pay dan losana kasapulan yu.” ");
INSERT INTO kmk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Dikayu un disipulus ku, adi kayu kumimut ulay nu akit kayu ta si Apudyus un Ama yu naanggoma nanomsomoka itdona dit mangiyapuwana kan dikayu daḻapnu maipantulay kayu kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sad napiya ilaku yu dat sanikuwa yu ta ituḻung yu dit bayad na utdan nakapus. Ot insaganaan yuwon nat long-ag yu si kamat pitaka un adina’n taḻon dumadaan kan kinabaknang sidin langit un adina’n taḻon maamin. Maid man-aakaw si makaakaw sidiyon kan maid angngat si manam-an. ");
INSERT INTO kmk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta san kawadan dan talipon yu siya pay ud taḻona sosomkon yu.” ");
INSERT INTO kmk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Imbagan pay Jesus sidat disipulus na un, “Masapula kankanayun kayu un mansasaggana ot kankanayuna matotonggan nat silaw yu ");
INSERT INTO kmk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","un kama utdan baba-unon un manguuway kan Apu da un mangulina manligwat si boda. Ta nu dumatong ot mangkogkog, ibukatan da un dagusa paḻnokon. ");
INSERT INTO kmk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nagasat dan kama’t di un baba-unon un adi masuyopa manguuway sidit mangulinan dit apu da. Tuttuwa tun ibagak kan dikayu un mansukat dit apu da ot mantupakona dat baba-unona utdin kakakkanan ot sunadana dida. ");
INSERT INTO kmk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nagasat dadiya baba-unon un mansasaggana’n manguuway sit apu da, gawan labi man onnu bungbung-on sin bigbigat dit sumaaḻana. ");
INSERT INTO kmk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gagasmokon yu tu. Nu tigammun nat osa’n tagu nat dumakngan di man-aakaw, saganaona daḻapnu adina makatukab sit boḻoyna. ");
INSERT INTO kmk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ot padana pay kan dikayu, masapula mansasaggana kayu ta sakona Inyanak di Tagu sumaaḻak sit olasa adiyu nanam-on,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mansidi, kanan Pedro kan Jesus un, “Apu, dikami kad nat mangibagbagaam sinata abalig onnu pati datun losan situ?” ");
INSERT INTO kmk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ot summungbat si Jesus un kanana’n, “Singngadan kad dit baba-unon un mataḻgodan kan nalainga man-ayuwan? Siya’d mangipaayyuwanan dit apu utdit boloy na kan losana baba-unona kan siya’d man-iwaḻas sit kanon da nu timpu na. ");
INSERT INTO kmk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nagasat diya baba-unon nu dakngon dit apu na un manungtungpal sidat kewaaḻ na. ");
INSERT INTO kmk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tuttuwa tun ibagak kan dikayu un siya’d mangitaḻgodan dit apu na utdat losana kukuwa na. ");
INSERT INTO kmk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yoong nu bokona mataḻgodan, kanana’t dit somsomok na un, ‘Bokona masapa dit apuka mangulin,’ ot lugiyana un mandataḻ sidat pada na un laḻaki’n baba-unon kama pay sidat babai asi mangamangan kan uminum inggana’t mabuubuuk. ");
INSERT INTO kmk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Utdiyon, dumatong dit apu na utdit aḻ-aḻgaw kan olas un adina nanam-ona dumakngana. Ot dusaon tu dit apu na ot ipalak-am na dit dusan dat adi mataḻgodana tagu. ");
INSERT INTO kmk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Sat baba-unon un titiggammu na dit piyaon dit apu na yoong adina kampay mansagana onnu tungpaḻon dit piyaona un makwa, nadagson dit mansasabid da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yoong sat baba-unon un naid si tigammu utdat piyaon dit apu na un ipakwa yoong makakwa si madusaana, naḻangpaw dit mansasabid da kan siya. “Sat tagu’n maitaḻgodan di adu, adu pay dit manamnama’n manligwat kan siya. Ot sat maitaḻgodan di ad-adu, ad-adu pay dit manamnama un manligwat kan siya.” ");
INSERT INTO kmk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kinnanan Jesus un, “Inummoyak situn pita un nangidatong si apuy un mangukum ku utdan tagu. Ot piyaok okyana gumilagilabon. ");
INSERT INTO kmk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yoong umuna yana mampaligatak ot nasigab tun angos ku un manomsomok inggana’t maimagasana. ");
INSERT INTO kmk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Kanan yu nin un ummoyak situn pita’n mangidatong si ginok. Bokon ta dummatongaka mangidatong si mansisinaan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Manipud sinsatunon, magoggogwa dan simbaḻyan. Nu awad lima, sadat tuḻu busuḻon da dat duwa ot sadat duwa busuḻon da pay dat tuḻu. ");
INSERT INTO kmk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sat ama busuḻona dit anaka laḻaki ot padana pay un sat anaka laḻaki busuḻona dit ama na. Sat ina busuḻona dit anaka babai kan pada na pay un sat anaka babai busuḻona dit ina na. Sat katuganga un babai busuḻona dit manugang ot sat manugang busuḻona dit katuganga na.” ");
INSERT INTO kmk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Imbagan payyan Jesus sidat tagu’t di un, “Nu maila yu ud bunota manligwat lagud kanan yu un umudan ot tuttuwa un umudan. ");
INSERT INTO kmk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nu mailayu un manligwat daya un manaḻan lagud kanan yu un ekang ot tuttuwa’n ekang. ");
INSERT INTO kmk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Man-ag-agin kayu. Maibaga yu dit kaipooyan dit ilan din langit kan satun pita yoong apay un adiyu maibaga dit kaipooyan dan mangimatunana mapaspasamak situ un timpu?” ");
INSERT INTO kmk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Intuluy Jesus dit nambagbaga un kanana’n, “Apay un adiyu somsomkon nu ngadan nat kustu un koon yu? ");
INSERT INTO kmk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu awad tagu’t mangidaḻum kan dikayu ta iyoy dikayu’t dit uukkuman, padason yu nat losana kabooḻan yu un makaaliglu kan siya sit inggawan yu payyan sit daḻan. Ta nu adiyu koon, lagayadon dikayu’n iyoy sidin kuis ot san kuis ipaima dikayu’t dan pulis ot ibaḻud da dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ot ibagak kan dikayu’n nu ibaḻud dikayu adi kayuwon makaḻaksun inggana’t mabayadan yu un losan dat multa yu.” ");
INSERT INTO kmk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Utdiya timpu’n nantudtuduwan Jesus, inggaw da ud tagu’n summaaḻa nangibaga kan Jesus maipanggop sidat iGalilea un pinatoy ud Pilato utdit madama da un mandatdatun kan Apudyus sidit timplu. ");
INSERT INTO kmk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ot kinnanan Jesus kan dida un, “Kanan yu nin nu nadagdagson dat basuḻ da nu sadat losana pada da un iGalilea gaputa kama’t di dit nangkakatoy da? ");
INSERT INTO kmk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ibagak kan dikayu, bokon. Ta ulay dikayu nu adiyu idadaoli dat basuḻ yu padayu dida un matoy kayu pay ot maisina kayu kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Padan dadit kagwampuḻu’t waḻu un iSiloe un natoya naḻdugan sidit naḻbaan dit nataknataknanga boḻoy. Utnat kanan yu nadagdagson dit basuḻ da nu sadat uduma tagu’n ummili utdin Jerusalem? ");
INSERT INTO kmk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ibagak kan dikayu, bokon. Ta ulay dikayu nu adi kayu mandadaoli pada yu dida un matoy kayu pay ot maisina kayu kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Imbagan Jesus tu un abalig kan dida un kanana’n, “Inggaw osa’n tagu un nangimuḻa si igus sidit mumuḻ-ana’t ubas. Utdit nakadakoḻ, umoy na bilibilingon ta mansallap si bunga na yoong maida taḻon indasana. ");
INSERT INTO kmk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ot imbagana’t dit man-aayyuwanona un, ‘Pokpokom tuwa igus ta tuḻu’n daguna lawaona umoyak bilibilingon nu awad bunga na yoong naida taḻon. Kaynga ullawa tun pita’n inggawana.’ ");
INSERT INTO kmk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kanan dit man-aayyuwan un, ‘Oni man yan. Piga pay tun tawon ta bukaḻok tun nanliput asik kuan si lasana. ");
INSERT INTO kmk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ot nu mamunga nu tawon napiya pay yoong nu adina kampay, asita pokpokon.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Inggaw osa’n aḻ-aḻgawa iillongan, mantudtudtudu si Jesus sidit sinagoga. ");
INSERT INTO kmk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Inggaw osa’n babai un sinakayan di nadadaga ispiritu ot pinambukut na si kagwampuḻu’t waḻu un dagun ot adina’n taḻon matunung dit mansisikad na. ");
INSERT INTO kmk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Utdit mailan Jesus inayagana un pinaadani kan siya asina kinnanan un, “Buḻun, napawayaan kaon sinat paligat nu.” ");
INSERT INTO kmk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ot inyagpad Jesus dit imana kan siya. Dagusa nangeknat ot nantunung dit mansisikad na. Utdiyon, indaydayaw na si Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mansidi, nakasuḻag dit pangaton didiya sinagoga gaputa aḻ-aḻgawa iillongan dit nampapiyaan Jesus sit masakit. Ot kinnanana utdat tagu’t di un, “Onoma aḻgaw nat mantalibasuwan taku ot dumatong kayu’t datuwa aḻ-aḻgawa mampaagas bokona sit aḻ-aḻgawa iillongan.” ");
INSERT INTO kmk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Summungbat si Jesus kan siya un, “Man-ag-agin napiya ka ullawa. Maid kad mangussag si baka onnu dangki na utdit naisiluwana asina umoy painuman nu aḻ-aḻgawa iillongan? ");
INSERT INTO kmk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Satuwa babai un kaganakan Abraham un binaḻud Satanas kan pinalpaligat na si kagwampuḻu’t waḻu un dagun, bokon kada napiya nu mawayaan ulay nu aḻ-aḻgawa iillongan?” ");
INSERT INTO kmk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Utdiya insungbat Jesus, losan dat kabusuḻ na un nabainan. Yoong sadat udum amod dit lagsak da utdit nakaskasdaawa kingkingwana. ");
INSERT INTO kmk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Intulutuluy Jesus un kanana’n, “Singngadan nat kapadan dit mangiyapuwan Apudyus? Sin dit mangiyaligak? ");
INSERT INTO kmk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Maiyalig si bukoḻ di mustasa un bangbang-oga bukoḻ un immuḻan dit tagu’t dit mumuḻ-ana. Ot utdit dummakoḻ, kama’t kayu dit kadakoḻ na ot ummoy dat sissiwit nanlubu utdat sanga na.” ");
INSERT INTO kmk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kinnanan Jesus payyan un, “Ngad pay din mangiyaligak sin mangiyapuwan Apudyus? ");
INSERT INTO kmk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kama si bubud un itamay dit babai si adu’n alina ot pabotaḻona’n losan dit maitamayana.” ");
INSERT INTO kmk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Intuluy Jesus dit kumikkiyangana’n umoy Jerusalem ot nantudtudu’t dat kailin-ili un nilausana. ");
INSERT INTO kmk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Inggaw osa’n nangimus kan siya un, “Apu, akit kada lawa dat taguwon Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kinnanan Jesus kan dida’l losan un, “Igga yu ud kabooḻan yu un mangoy sit nasupita luwangana umoy langit. Ta ibagak kan dikayu un adu dan mamadasa lumnok yoong adida makaḻnok. ");
INSERT INTO kmk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Ta kama’t dit boḻoy un nu ombanon dit simboḻoy dit sawang naidon makaḻnok sidat awad sit lasin. Ulay nu iyumyum-og yu un mangkogkog kan mampakaasi un kanan yu un, ‘Apu, mangaasi ka ta ibukatan dikami.’ Yoong sumungbat dit simboḻoya kanana’n, ‘Naid tigammuk kan dikayu kan nu nanligligwatan yu.’ ");
INSERT INTO kmk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ot kanan yu un, ‘Nakakan kan nakainum kami kan sika kan nantudtudu ka pay sin boboḻoy mi.’ ");
INSERT INTO kmk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yoong sumungbat uman dit simboḻoy un, ‘Naid tigtigammuk nu nanligligwatan yu. Umadayu kayu, dikayu’n losana mankokokwa’t nadadag.’ ");
INSERT INTO kmk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ot dikayu’n inggaw sin lasin, mampaibil kan mampangilot kayu nu dumtong dit timpu nu maila yu dat aappu taku un sada Abraham, Isaac kan Jacob kan sadat losana propetan Apudyus un naidagamung sin mangiyapuwan Apudyus yoong naḻsin kayu kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Utdiya aḻ-aḻgaw, manligwat dat tagu uttun nangkalliputa pita un umoy sumangu’t din kakakkanan sidin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Tuttuwa tun ibagak. Awad da ud tagu’n maudi uttun satun yoong maun-una dan tu ot awad da ud maun-una uttun satun yoong maudi dan tu.” ");
INSERT INTO kmk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Utdi payona aḻ-aḻgaw, inggaw da ud Fariseo un dummatong kan Jesus ot kanan da kan siya un, “Masapula tengyam yan tuwa igaw ta panggop Herodes un papatoy sika.” ");
INSERT INTO kmk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Summungbat si Jesus un, “Umoy kayu ibaga’t nat nasikapa tagu ta uttun satun kan nu bigat, man-addagak sidan dimunyu kan papiyaok dan masakit. Ot nu maikatlu’n aḻ-aḻgaw magangput kuwon tun talibasuk. ");
INSERT INTO kmk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yoong masapula ituluy ku un manaḻan sin Jerusalem situn aḻgaw, bigat kan inggana’t kabigat na ta bokona lobbong na un mapatoy dan propetan Apudyus sin uduma igaw nu adi utdin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Inay kayu paya iJerusalem! Ta pinatoy yu dat propetan Apudyus kan binatubatu yu pay dat imbaun na un manudtudu kan dikayu. Namimpiga un piyaok dagupon dikayu un ayyuwanan un padan din manalikopkopan din manuk sidan siyop na, yoong ummadi yu. ");
INSERT INTO kmk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ot sinsatunon ipatungad Apudyus nat igaw yu. Ot ibagak kan dikayu un maidon ilan yu kan sakon inggana’t din timpu un mangibagaan yu un, ‘Binindisyunan Apudyus tun dummatonga imbaun na un pannakalong-ag na!’ ” ");
INSERT INTO kmk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sin-aḻgawana iillongan, ummoy si Jesus sit boḻoy dit pangpangaton dat Fariseo ta inawis da un umoy makakan. Ot sadat tagu’t di limalimadan da dat koona. ");
INSERT INTO kmk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ininggaw osa’n tagu’t din sanguwan Jesus un nanlollotog dat iki kan imana. ");
INSERT INTO kmk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Utdi, inimusan Jesus dat mimistulun di lintog kan dat Fariseo utdi un kanana’n, “Makwa kad sit lintog taku un man-agas nu aḻ-aḻgawa iillongan onnu adina?” ");
INSERT INTO kmk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Naida taḻon gumguminga ot inaggoman Jesus dit tagu ot pinapiyana asina pinadaḻan. ");
INSERT INTO kmk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Utdiyon kinnanan Jesus kan dida’n dit ininggaw sidi un, “Singngadan na kan dikayu ud adi managdagusa manganguy sit abeng na onnu baka na nu maotdag si bitu nu aḻgawa iillongan?” ");
INSERT INTO kmk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yoong adida masungbatan dit imbagan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Utdit nadlaw Jesus un sadat tagu’n naawis sad piliyon da dit kabaḻuwana igaw, imbagana tuwa abalig kan dida’n losan. ");
INSERT INTO kmk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nu awad mangawis kan dikayu si boda, adiyu umoy piliyon dit kabaḻuwana igaw ta tuwan nu awad nangatngatu nu dikayu un naawis. ");
INSERT INTO kmk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ta nu awad, umoy dit nangawis kan dikayu ot kanana’n, ‘Pangngaasim ta itdom nata tutuppakan kan siya.’ Kad maibabain kayu ot kapilitana umoy kayu mantupak sit igaw dan nadoba’n tagu. ");
INSERT INTO kmk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Isunga nu maawis kayu’t amung, umoy kayu mantupak sit igaw dan nadoba’n tagu daḻapnu nu umoy dit nangawis kan dikayu ot kanana un, ‘Umoy kayu mantupak sin sangu,’ maidayaw kayu’t dan losana tagu’n awad sidi. ");
INSERT INTO kmk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ta sat tagu’n mangipangatu utdit long-ag na maidoba, yoong sat tagu’n mampakumbaba maipangatu.” ");
INSERT INTO kmk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Utdiyon, imbagan Jesus sidit nangawis kan siya un, “Nu awad iyawis nu si kakan onnu amung bokona sadat gagayyom nu, susunud nu, kakabagiyam onnu dat babaknanga kasog-on nu ullawa dat awisom. Ta mabalin da un awison pay sika ot supapakan da dit namakanam kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yoong nu man-amung ka sad awisom dan nakapus, napikon, napilay kan nakuḻap. ");
INSERT INTO kmk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta maid maisupapak da kan sika. Ot nagasat ka ta si Apudyus ud mangtod si gun-guna kan sika nu dumatong nat aḻ-aḻgawa mampaungaḻana’t dat nalintoga tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Magngoḻan man dit osa un nakaubung kan dida’n nangan dit abalig Jesus, kanana un, “Nagasat dit tagu’n makakan sit amung sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Utdi, inyabalig Jesus dit sungbat na un kanana’n, “Inggaw osa’n tagu’n nampaamung ot nan-awis sidat adu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Utdit nakasagana’n losanon dit makan, imbaun dit nampaamung dit baba-unona ta umoy na ibaga’t dat naawis un, ‘Awe yuwon ta nakasagana’n losanon din makan.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Yoong nanlasun dat losana naawis. Kanan dit osa un, ‘Dispinsalon yu ullawa, adiyak makaoy ta kaggatangak si payaw ot umoyak yan ilan.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kingwanan pay dit osa un, ‘Dispinsalon yu ullawa, adiyak makaoy ta kaggatangak si lima’n palisa baka ot umoy ku yan ipadas dida un man-aḻadu.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kanan payyan dit osa un, ‘Dispinsalon yu ullawa, adiyak makaoy ta kaas-awaaka lawa.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Utdi, nan-ulin dit baba-unon ot imbagana’n losan dadit lasun da kan apuna. “Sadit apu nakasuḻag ot imbagana’t dit baba-unona un, ‘Daḻsoma umoy sidan losana kaḻsa kan nampadaddaḻan situn boboḻoy ta idallay nu un losan dat nakapus, dat napikon, dat nakuḻap kan dat napilay.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Bokona nabayag, nan-ulin dit baba-unon ot kanana’t dit apu na un, ‘Apu, nakwaon dit bilin nu yoong adu payyana maigawan.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Utdi, kanan dit apu uman un, ‘Umoy ka utdan uduma kaḻkaḻsa kan nampadaddaḻana manaḻan sidat uduma boboḻoy ot papilitom idallay dat tagu’t tu daḻapnu mapnu tun boḻoy ku. ");
INSERT INTO kmk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta ibagak kan dikayu un maid sidadit ummuna’n inawis ku ud pakapkapak situn makana insaganak.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sin-aḻgawan sidit manaddaḻanan Jesus un umoy Jerusalem, tinung-ud dat un-unaya tagu. Utdi, summangu kan dida un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nu awad tagu’n mamiya un mambalina disipulus ku, masapula sakon ud ipotog na un bokona sadat maḻong-ag na, susunud na, asawa na, aabeng na kan ulay sadit long-ag na pay lawan. ");
INSERT INTO kmk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Padana pay un sat tagu’n adi mamukud sit kulus na asi maitung-ud kan sakon, adina mabalina mambalin un disipulus ku. ");
INSERT INTO kmk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ta awad kad tagu un mampangpanggop un mangwa’t dakodakoḻana boḻoy un adina unaona listaon dat magastu na ta ilana nu awad umanay un mangangput na utdit tuudona? ");
INSERT INTO kmk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta nu paḻangona yoong maid umanaya mangangput na, losan dat mangila duḻaon da un kanan dan, ");
INSERT INTO kmk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Inlugi na un paḻangon yoong maid mangangput na.’ ");
INSERT INTO kmk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Padana pay sit osa’n ali un mamiya’n gumubat sit kabusuḻ na un ali. Bokon kada somsomkona un umuna nu kabooḻan dat simpuḻu’n libu un taguna un abakon dat duwampuḻu’n libu un tagu’n dit kabusuḻ na? ");
INSERT INTO kmk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta nu adida kabooḻan sidit pattapatta na, mangibaun si umoy mangabat sidit ali un kabusuḻ na nu adayu payyan ta umoy makikapiya. ");
INSERT INTO kmk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Padana pay kan dikayu. Masapula am-ammaan yu un somsomkon asikayu maitung-ud kan sakon. Ta adina mabalina mambalin kayu un disipulus ku nu adiyu iwayang dat losana awad kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Intultuluy Jesus dit nan-abalig un kanana’n, “Naselbi nat asin nu mannanayun dit apgad na yoong nu nangkubayon adinaon mabalina maiyulin dit apgadna. ");
INSERT INTO kmk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ot naidon selbi na ta adina pay mabalinona mailasa si pita. Maidawata lawaon. “Ot dikayu’n awad si inga’n makagngoḻ, dumngoḻ kayu,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sin-aḻgawan adu dat man-uuḻup si bugis kan dat ibilang dat Judio un gumabasuḻa nandatdatonga umoy mandongoḻ kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nampangonot dat Fariseo kan mimistulun di lintog un kanan dan, “Inon pay dituwa tagu, naanggoma maibuḻbuḻun sidan gumabasuḻ kan makakan pay kan dida.” ");
INSERT INTO kmk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Utdi, imbagan Jesus tuwa abalig un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kaspagaligan ta osa kan dikayu’d awad si singgasuta kannelu ot mataḻak din osa singngadan nat koona? Adina kad tengyan dat siyamapuḻu’t siyam sit tangsa ta umoy na inapon dit osa’n nataḻak inggana’t odasana? ");
INSERT INTO kmk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ot nu maodasanaon amod dit lagsak na un mamukuda mangidallay. ");
INSERT INTO kmk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ot nu dumatong sit boḻoy da ayagana dat gagayyom na kan kapaway na un kanana’n, ‘Aweyu ta lagsakan taku tun nangdasak sit nataḻaka kanneluk.’ ");
INSERT INTO kmk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Ibagak kan dikayu un padana pay un amoamod din laglagsak sin langit maipagapu’t din osa’n gumabasuḻa mandadaoli nu sadan siyamapuḻu’t siyama adida bigbigon un masapula mandadaoli da.” ");
INSERT INTO kmk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Intuluy Jesus si abalig ot kanana’n, “Nu sanat osa’n babai’n awad si simpuḻu un palata ot mataḻak nat osa, ngadan nat koona? Adina kad tonggan dit silaw asina sagadan dit boḻoy na ta ammaana un inapon inggana’t odasana? ");
INSERT INTO kmk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ot nu maodasanaon ayagana dat gagayyom na kan kapaway na un kanana’n, ‘Naanggomak ta indasak tun nataḻaka palatak ot manlagsak taku.’ ");
INSERT INTO kmk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ibagak kan dikayu un padana pay un manlaglagsak dat anghel Apudyus nu mandadaoli nat osa’n gumabasuḻ.” ");
INSERT INTO kmk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Imbagan pay Jesus tuwa abalig un kanana’n, “Ininggaw osa’n tagu un duwa dat abeng na un laḻaki. ");
INSERT INTO kmk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sin-aḻgawan, kinnanan dit naudi’n abeng sit ama na un, ‘Ama, itdomon dit bingay ku utdat sanikuwam.’ Utdi, biningay dit ama dit ipatawid na utdat duwa un abeng na. ");
INSERT INTO kmk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mapalabas man piga’n aḻgaw inniplak dit naudi un abeng dat losana bingay na ot kaysan si adayu’n boboḻoy un umoy na ullawa binusbusbus dit pilak na udsi bokobokona mantatagu. ");
INSERT INTO kmk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Utdit nagastu na un losan dit pilak na, dummatong dit uḻat sidiya boboḻoy ot naidona taḻon mangaḻ-ana’t igatang na si kanona. ");
INSERT INTO kmk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Utdi, umoy nanlabbu udsi osa’n tagu’t diya boboḻoy ot sat talibasu un impakwa da kan siya, mampapakan si boḻok sit tattaḻun. ");
INSERT INTO kmk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Amod dit bitil na ot piyaona un mangan sit kakannon dat boḻok yoong naid nangitod kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Utdit masomsomok na, kanana un, ‘Adu’n masawaḻ sit kanon dadit baba-unon amak sin boḻoy mi yoong antuwak situ un matmattoyan situn bitil ku. ");
INSERT INTO kmk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Manaḻanakot ta mangulinak kan ama ot kanak kan siya un, ‘Ama, pakawanonak ta nakabasuḻak kan Apudyus kan padana pay kan sika. ");
INSERT INTO kmk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Adiyakon maibagaya abeng nu yoong pangngaasim ta ibilangak un osa’n baba-unom.’ ");
INSERT INTO kmk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kadon, kaysana nangulin kan amana. “Inggaw payyan sit adayu’n dumoḻdoḻ, naotap dit amana. Nadaguwan dit ama na ot nanodtoddaka ummabat kan siya’n kummawoḻ asina inogkan. ");
INSERT INTO kmk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Utdi, kinnanan dit abeng sit ama na un, ‘Ama, nakabasuḻak kan Apudyus padana pay kan sika. Adiyakon maibagaya abeng nu.’ ");
INSERT INTO kmk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yoong inayagan dit amana dadit baba-unona ot imbagana kan dida un, ‘Daḻason yu. Ikayu aḻan dit kabaḻuwana badut ta ibadut yu kan siya. Sikkalangan yu kan kapatusan yu. ");
INSERT INTO kmk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Umoy yu aḻan dit pinaḻungpu taku’n ubbun di baka ta paltiyon yu ta manlagsak taku. ");
INSERT INTO kmk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gaputa satu un abeng ku, alig na ud natoy yoong ummungaḻ. Alig na ud naiyawa yoong naodasan,’ kinnanan dit ama. Utdiyon inlapu daon dit manlaḻagsak. ");
INSERT INTO kmk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Sadit pangu’n abeng ininggaw sit pappayaw un mangkokwa. Dumoḻdoḻ man sit boḻoy un dit nanlokat dingngoḻ na dit gangsa kan sadat mantatadok. ");
INSERT INTO kmk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Utdi, inayagana dit osa’t dat baba-unon da ot inimus na nu ngadan dit mapaspasamak. ");
INSERT INTO kmk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Summungbat dit baba-unon un, ‘Manlaḻagsak da ta nangulin si sunud nu un kapkapiya ot pinapaltin amayu dit pinaḻungpu taku’n ubbun di baka,’ kinnanana. ");
INSERT INTO kmk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Amod dit suḻag dit pangu’n abeng ot taḻona adina lumnok sit boḻoy. Ot lummaksun dit amana ta umoy na alallukona paḻnokon. ");
INSERT INTO kmk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yoong kinnanana’t dit amana un, ‘Piga’n dagun un kamaak si babbaun nu un nantaltalibasu un adik nansuksukil kan sika? Yoong naid gapu’d intod nu kan sakon un makaanggomak sidan gagayyom ku, ulay okyan nu ubbun di kalding. ");
INSERT INTO kmk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sanata abeng nu un umoy na ullawa binusbusbus dit pilak nu utdan nadadaga babai man-ulin kad ipaltiyam si kaḻungpuwana ubbun di baka.’ ");
INSERT INTO kmk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Summungbat dit amana un, ‘Anak ku, iinggaw ka kan sakon ot losana awad kan sakon kuwam. ");
INSERT INTO kmk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yoong masapula man-amung taku ta manlagsak taku ta satun sunud nu alig na ud natoy yoong ummungaḻ, alig na ud naiyawa yoong naodasan.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Utdi, imbagan Jesus tuwa abalig sidat disipulus na un, “Inggaw osa’n baknang un inggaw man-aayyuwanona’t dat kukuwana. Naikubit kan siya un busbusbusona lawan dit man-aayyuwan dit pilak na. ");
INSERT INTO kmk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Utdi, pinaayag dit baknang dit man-aayyuwan ot inimusana un, ‘Apay tun nadamag ku un maipanggop kan sika? Aḻam situ dat losana listaan dat kukuwak ta kaanok sika un man-aayyuwanok.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kinnanan dit man-aayyuwan sit domdom na un, ‘Inon kad nin tun kook nu kaanonakona man-aayyuwan? San mamboka adik makwa. Ot mabainak pay un tumaptapaya si ikataguk. ");
INSERT INTO kmk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ay, tigammukon ud kook daḻapnu ulay makaanak situn talibasuk awad da payyan ud gagayyom ku un mamaḻnok kan sakon sidan boḻoy da,’ kinnanan dit man-aayyuwan. ");
INSERT INTO kmk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Utdi, inayagana un losan dat nakagawat sit apu na un sinin-ossa. Ot kinnanana’t dit ummuna un, ‘Piga dit gawat nu kan apuk?’ ");
INSERT INTO kmk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Singgasuta angang un lana,’ insungbat na. Kinnanan dit man-aayyuwan un, ‘On, antu dit listaan nu. Sukatam, ikanglit nu un limampuḻu.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Utdit osa kinnanana un, ‘Sika nu piga dit gawat nu?’ ‘Sinlibu’n saḻup un binayu,’ insungbat na. ‘Antu dit listaan nu,’ kinnanan dit man-aayyuwan. ‘Mangwa ka si sabali. Ikanglit nu ud waḻu’n gasuta saḻup.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Matigammuwan man dit apu, indayaw na dit kinasikap dit man-aayyuwan. Onta sadan bokona tagun Apudyus nasiksikap da un makatulag sidan pada da maipanggop si mangkapiyaan da nu sadan tagun Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ot ibagak kan dikayu un usalon yu dat binaknang yu uttun lubung un ituḻung sidan mangkasapulan daḻapnu nu naidon dat kinabaknang yu, awaton dikayu utdin mannanayuna igaw yu utdin langit. ");
INSERT INTO kmk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sanat tagu’n mataḻgodan un mangayyuwan si akita banag, mataḻgodan pay un mangayyuwan si adu. Sanat bokona mataḻgodana mangayyuwan si akita banag, amo bokona mataḻgodana mangayyuwan si adu. ");
INSERT INTO kmk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ot nu adi kayu mataḻgodana mangayyuwan sidan binaknang situn pita inona’n maitaḻgod kan dikayu dan gattoka binaknang sidin langit? ");
INSERT INTO kmk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nu adi kayu mataḻgodan sidan bokona kukuwa yu singngadan nat mangitodon si kuwa yu? ");
INSERT INTO kmk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Maid ud baba-unon si mandisanona un manselbiyan dan duwa’n apu. Ta lawengona dit osa ot piyaona dit osa, onnu ipasnok na un manselbi’t dit osa ot duḻaona dit osa. Ot padana pay kan dikayu un adiyu mabalina mandisanon din manselbi kan Apudyus kan gumamgama gumaknang,” kinnanan Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nagngoḻan dat Fariseo un nagamgam si pilak datun losana imbagan Jesus ot inyaḻbuwang da. ");
INSERT INTO kmk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yoong kinnanan Jesus kan dida un, “Ipappaila yu utdan tagu un nalintog kayu yoong tigammun Apudyus nat annat sinat somsomok yu. Sat ibilang di tagu un taḻona napotog, gassuḻon ud Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Intuluy Jesus un kanana’n, “Sat lintog Apudyus un ingkanglit Moses kan sadat ingkanglit dat propetana dat naipatpatungpal agingga’t dit dummakngan ud Juan un Mambubunyag. Yoong manipudon sit timpun Juan, sadit Nabaḻu’n Damag un maipanggop sit mangiyapuwan Apudyus dit maitudtudu. Ot osaosa iyaangos na un taḻon nat maidagamungana. ");
INSERT INTO kmk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Naḻasḻasu’n mangkigad tun langit kan pita nu san mawaswasan din kaban-ogana ugud sidin lintog na. ");
INSERT INTO kmk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Padan dit lintog maipanggop si asawa un, sanat osa’n laḻaki’n mangidang sinat asawa na ta asi mangasawa si sabali, makabasuḻ si dagdagas. Ot sanat laḻaki’n mangasawa utdit naidangana babai, makabasuḻ si dagdagas.” ");
INSERT INTO kmk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Inyabalig payyan Jesus un kanana’n, “Ininggaw osa’n baknanga tagu un nangkabanol dat badut na kan inaḻgawa nadumaduma’n nangkapippiya’n makan dat maisunad kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","“Ot inggaw pay nakapusa tagu’n nagolegoled dit losana long-ag na un mangngadan kan Lazaro. Inaḻgawa umoy da ibanat sit luwangan dit nabaknanga tagu. ");
INSERT INTO kmk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta taḻona piyaona un kanon dat bugtan dit baknang. Ot ummoy pay dat asu ud dildildilan dat goled na. ");
INSERT INTO kmk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Sin-aḻgawan natoy dit nakapusa tagu ot inyoy dat anghel Apudyus sit kawadan Abraham. Natoy pay dit nabaknanga tagu ot innilbon da. ");
INSERT INTO kmk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Utdit inggaw sit Hades un mampalpaligat, nantangad dit baknang ot naotap na utdit adayu da Abraham ot inggaw si Lazaro utdit sog-on na. ");
INSERT INTO kmk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ot nampakuy dit baknang un, ‘Ama Abraham, kaasiyanak ta ibaun nu si Lazaro ta isanong na nat pungtun pagayyamot na utnat danum ta todtodana tun dilak. Ta taḻona mampalpaligatak situn antuwaka apuy.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Yoong summungbat si Abraham un, ‘Somsomkom abeng ku un sadit katattagum losana napiya ininggaw kan sika yoong si Lazaro sinagapaḻ na ud ligat. Sinsatunon antu uttu un kapkapiyaon ot sika pay nat mampalpaligaton. ");
INSERT INTO kmk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Adina pay makwa nat umoy sinata manligwat situ onnu manligwat sinata umoy situ ta awad gassud situn boḻaat taku.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kinnanan dit baknang un, ‘Ama Abraham, pangngaasim ta ibaun nu si Lazaro utdin boḻoy da amak ");
INSERT INTO kmk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta awad da ud lima un sunud ku utdi, ta umoy na bagaan dida ta amangan nu umoy da uttun igaw di amoda ligat.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Yoong summungbat si Abraham un, ‘Awad dit ugud Apudyus un ingkanglit da Moses kan dat propetana un siya’d makatigammuwan da.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Summungbat dit baknang un, ‘Adida tuttuwaon danat ama Abraham, yoong nu sanat tagu’n umungaḻ nat umoy mangibaga kan dida manuttuwa da kad mandadaoli da utdat basuḻ da.’ ");
INSERT INTO kmk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Yoong imbagan Abraham un, ‘Nu adida tuttuwaon dit ugud Apudyus un ingkanglit da Moses kan dat propetana ulay pay nu ummungaḻa natoy nat umoy mangibaga kan dida adida payon maawisa manuttuwa.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Imbagan pay Jesus sidat disipulus na un, “Awada awad maigapuwan nat makabasuḻan di osa’n tagu. Yoong kaasi pay nat tagu’n maigapuwan di osa un mambasuḻ. ");
INSERT INTO kmk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Un-unnaya lawa’n matakodan si dakoḻana gigillingana batu din bagang na asi maidawat sin baybay nu siya’d maigapuwan di makabasuḻan di osa un nadoba’n tagu. ");
INSERT INTO kmk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Siya’d gapuna un ammaan yu nat kokkoon yu. “Nu makabasuḻ nat buḻun yu kan dikayu, igimau yu ot nu mandadaoli, pakawanon yu. ");
INSERT INTO kmk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nu mamimpitu’t sin-aḻgawa makabasuḻ ot kada makabasuḻ umoy mampakawan kan dikayu, pakawanon yu.” ");
INSERT INTO kmk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Utdi, imbagan dat apostoles kan Jesus un, “Apu, pabilgom ud tun mantututtuwa mi.” ");
INSERT INTO kmk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Summungbat si Jesus un kanana’n, “Nu awad pammati yu un kama’t bukoḻ di mustasa nat kadakoḻ na, mabalin un ibagayu’t din kayu un, ‘Mabagut ka ta asika maimuḻa utdin baybay,’ ot tuttuwaon dikayu.” ");
INSERT INTO kmk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Imbagan pay Jesus un, “Kaspagaligan ta awad osa kan dikayu’d awad baba-unona un ummoy nanabḻut onnu ummoy man-ayyuwan si kannelu ta dumatong, dagus kad un kanam kan siya un ‘Umoy ka manganon?’ ");
INSERT INTO kmk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bokon, ta kanam un, ‘Umoy ka man-asug asika mansukat ot sunadanak sinat timpu’n manganak. Ot nu maabusaka mangan asika payon maisongwat.’ ");
INSERT INTO kmk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Ot nu maabusa koon dit baba-unon dat imbilin nu un koona, masapul kad un manyamanam? Bokon ta siya’d talibasu na di. ");
INSERT INTO kmk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pada na pay kan dikayu. Nu natungpal yu un losan dat naibilina koon yu adiyu nanam-ona maidayaw kayu nu adi kanan yuwoton un, ‘Baba-unon dikami ullawa ot kingwa mi ullawa dit naibilin kan dikami un koon mi.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Utdit manaddaḻanan da Jesus un umoy Jerusalem nangoy da utdin boḻaat Samaria kan Galilea. ");
INSERT INTO kmk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dumatong da man sit osa’n boboḻoy ummabat dat simpuḻu’n nakutoḻ. Summikad da utdit ad-adayu asida ");
INSERT INTO kmk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","impakuy kan Jesus un, “Apu, kaasiyan dikami.” ");
INSERT INTO kmk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nailan Jesus dida ot kanana un, “Ikayu mampaila utdat papadi.” Utdi, kaysan da yoong kakḻata lawa’n nagikna daon un kummiya da. ");
INSERT INTO kmk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Magiknan man dit osa un naidon dit kutoḻ na nangulin kan Jesus ot nampappakuya nandaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Umoy nampalintumong sit atubang Jesus un nanyaman. Sadiya tagu, Samaritano. ");
INSERT INTO kmk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Utdi, kinnanan Jesus un, “Bokon kada simpuḻu dat tagu’n kummiya ot kawad dat siyam nu? ");
INSERT INTO kmk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apay un satun bokona Judio tun os-ossaana umoy manyaman kan Apudyus ya simpuḻu da?” ");
INSERT INTO kmk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ot kinnanan Jesus sidit tagu un, “Lumigwat kaon ot manaḻan ka ta kummiya ka gapu’t nat pammatim.” ");
INSERT INTO kmk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Utdi, gaputa inggaw da ud Fariseo un nangimus kan Jesus nu kapiga dit manlapuwan dit mangiyapuwan Apudyus, summungbat si Jesus un, “Maid makail-an sit manlugiyan dit mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maid makaibaga un, ‘Antu uttu,’ onnu ‘Andi utdi,’ ta sat mangiyapuwana antu uttu un mismu kan dikayu uttun satun.” ");
INSERT INTO kmk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Imbagana utdat disipulus na un, “Dumtong nat timpu un piyaon yu un maila’d sakona Inyanak di Tagu, ulay nu sin-aḻgawa lawa yoong adiyu ud sakon maila. ");
INSERT INTO kmk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Ot awad dat mangibaga kan dikayu un, ‘Andi utdi,’ onnu ‘Antu uttu,’ yoong adiyu un taḻon tuttuwaon dida. ");
INSERT INTO kmk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta kama’t din kilat nu dumelang, madoḻangana’n losan din langit ot maila dan losana nangkalliput, siya’d kamaana nu mangulinaka Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yoong masapula sagapaḻok yan dat adu’n ligat kan sumdiyanak sidat tagu’t tun satun. ");
INSERT INTO kmk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nu mangulinaka Inyanak di Tagu, maipada dit kokkoon dat tagu’t dit timpun Noe utdat kokkoon dat tagu’n dakngak. ");
INSERT INTO kmk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta utdit timpun Noe, ginan-ganas dat tagu’n nanganangan, nan-iinum kan nan-aassawa da inggana’t nilumnokan da Noe utdit dakoḻana bapul. Manlitap manon, losan dat tagu’n naḻmos. ");
INSERT INTO kmk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Padana pay sit timpun Lot un sat nanganangan, nan-iinum, nanggatagatang, nanlakuḻaku, nammuḻamuḻa kan namboḻoboḻoy dat kingkingwan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yoong utdit aḻ-aḻgawa nanengyan da Lot sidit boboḻoy Sodom, kakḻata inyudan Apudyus dit apuy kan gumaḻabaḻa’n batu un mangngadan si asufre un namatoy sidat losana tagu. ");
INSERT INTO kmk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kama’t di payon dit mapasamak nu aḻ-aḻgawa mangulinak un Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Utdiya timpu sanat tagu’n awad sit otop dit boḻoy na adinaon lumnoka umoy mangaḻa’t dat kukuwana. Padana pay sit tagu’n awad sit payaw, adinaon masapula mangulin sit boḻoy na. ");
INSERT INTO kmk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Sosomkon yu dit napasamak sit asawan Lot sidit nan-awing. ");
INSERT INTO kmk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Sat tagu’n gamgamana nat mataguwana’t tun pita, maid ayana nu adi mataḻak na dit mataguwan un maid kigad na. Yoong sanat tagu’n matoy maipagapu’t dit manuttuwaana kan sakon, maitdan si mataguwan un maid kigad na. ");
INSERT INTO kmk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ibagak kan dikayu un nu labi nat dumakngak ta awad da ud duwa’n nangkaoboga nasuyop, maaḻa dit osa ot matengyan dit osa. ");
INSERT INTO kmk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Padana un nu awad duwa’n manggilgiling, maaḻa dit osa ot matengyan dit osa. ");
INSERT INTO kmk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nu awad da ud duwa’n tagu’t din payaw, maaḻa dit osa matengyan dit osa.” ");
INSERT INTO kmk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Magngoḻan man dat disipulus Jesus tuwa imbagana, inimus da un, “Apu, kawad na nu nat makwaana?” Inyabalig Jesus un kanana’n, “Sat kawadan di ladag, siya’d madatdatngan dat tuḻayan.” ");
INSERT INTO kmk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Imbagan pay Jesus tuwa abalig kan dida ta piyaona’n kanayuna manluwaḻu da un adida mappog. ");
INSERT INTO kmk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sat abalig na kanana’n, “Inggaw osa’n kuis sit osa’n boboḻoy un adina iyogyat si Apudyus kan adina pay mangwaan dat uduma tagu. ");
INSERT INTO kmk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Ot inggaw pay bilug sidiya boboḻoy un maka-oo-ooy kan siya un umoy mampatuḻung un kanana’n, ‘Pangaasim ta takdoḻam dit kalintogak sidin kabusuḻ ku.’ ");
INSERT INTO kmk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Adin dit kuis wilwiliyon, yoong utdit mabayag kanana’n, ‘Maid ogyat ku kan Apudyus kan adik mangwaan dan uduma tagu. ");
INSERT INTO kmk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yoong gaputa lumingaling tun bilug takdoḻaka lawa. Ta nu makaoo-ooya mampatuḻung mappogak.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Imbagan Jesus un, “Dingngoḻ yu dit imbagan dit lawenga kuis. ");
INSERT INTO kmk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ot bokon kada dongḻon Apudyus dat tagu na un inaḻgaw kan linabi un mangkodaw si tuḻung kan siya? Adina kad dagusona tuḻungan dida? ");
INSERT INTO kmk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibagak kan dikayu un dagusa takdoḻan Apudyus dit kalintogan da. Yoong ulay nu siya di, nu mangulinak un Inyanak di Tagu, awad kad nin dakngak si napasnok ud pammati na uttun pita?” ");
INSERT INTO kmk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Imbagan Jesus tuwa abalig sidat tagu’t di un manaḻtaḻgod sit kinalintog da kan manuḻaduḻa da utdat pada da un tagu. ");
INSERT INTO kmk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kanana un, “Inggaw da ud duwa’n tagu’n ummoy sit boḻoy Apudyus daḻapnu manluwaḻu da. Fariseo dit osa kan man-uuḻup si bugis un maibilanga gumabasuḻ dit osa. ");
INSERT INTO kmk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Summikad dit Fariseo un nangiluwaḻu utdit maipanggop kan siya un kanana’n, ‘Apudyus iyamanak ta bokona kamaak sidat uduma tagu’n naagum, natuli, managdagas onnu padan tun gumabasuḻa man-uuḻup si bugis. ");
INSERT INTO kmk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Manlanganak paya mangan un manluwaḻu si mamigwa’t sindumingguwan kan itdok pay kan sika nat ingkapuḻun nat losana malabbuwak,’ kinnanan dit Fariseo. ");
INSERT INTO kmk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Yoong sadit man-uuḻup si bugis, ininggaw sit ad-adayu ot adina pay mantangad langit un manluwaḻu. Ot binbintugona dit paḻagpag na gapu’t babawi na ot kinnanana un, ‘Apu, kaasiyanak ta gumabasuḻaka tagu!’ ");
INSERT INTO kmk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ibagak kan dikayu,” kinnanan Jesus, “nangulin tuwa tagu un napalintog sit man-iilan Apudyus yoong sat Fariseo, bokona napalintog. Ta sanat tagu’n mangidayaw sit long-ag na maidoba, yoong sanat mampakumbaba siya’d maidayaw.” ");
INSERT INTO kmk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Inggaw namingsan un nan-idatong dat tagu utdat aabeng da kan Jesus daḻapnu agpadana dida’n bindisyunan yoong mailan man dat disipulus na inggimau da dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yoong si Jesus inayagana payon dat aabeng kan siya asina kinnanan sidat disipulus na un, “Bay-an yu un umoy danat aabeng kan sakon, adiyu iyapa dida ta sadat kama kan dida dat maidagamung sin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tuttuwa tun ibagak kan dikayu un, nu adiyu awaton din mangiyapuwan Apudyus un padan din koon di abenga mangawat, adi kayu maidagamung sidi.” ");
INSERT INTO kmk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ininggaw osa’n pangaton dat Judio un nangimus kan Jesus un, “Napiya’n Mistulu, ngad nat masapula kook daḻapnu matawid ku dit mataguwana maid kigad na?” ");
INSERT INTO kmk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Summungbat si Jesus un, “Apay un kanama napiyaak? Maid udum si napiya nu adi si Apudyus ullawa. ");
INSERT INTO kmk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tigammum dat bilin un, ‘Adika managdagas. Adika kumatoy. Adika man-akaw. Adika mangustigu si tuli. Dayawom da amam kan inam.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Summungbat dit laḻaki un, “Tungtungpaḻoka losan danaton manipud sit kaban-og ku.” ");
INSERT INTO kmk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Magngoḻan man Jesus dit insungbat dit laḻaki kinnanana kan siya un, “Annat payyan mangkulangam. Umoy ka ilaku dat losana kukuwam ta asim itdon dit bayad na utdat nakapus kad awad binaknang nu ud langit, asikaon umunud kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Magngoḻan man dit laḻaki di, amod dit domdom na ta taḻona baknang. ");
INSERT INTO kmk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nailan Jesus un nadomdoman ot kanana un, “Taḻona nasigaba makaḻnok danat baknang sin mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Naḻasḻasu un mangoy nat kamelyu un dakoḻa ayam sinat abut di tanud nu sanat osa’n baknanga tagu un lumnok sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ot sadat nakagngoḻ situ inimus da un, “Singngadan dat mabalina taguwon Apudyus nu?” ");
INSERT INTO kmk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Insungbat Jesus un, “Sadat banaga adin di tagu makwa, makwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Utdi, kinnanan Pedro un, “Dikami nu, un tinengyan mi dat boḻoy mi daḻapnu sika’d uunnudon mi?” ");
INSERT INTO kmk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ot kinnanan Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu, un singngadan na mana manengyan sit boḻoy na, onnu asawa na, onnu sunud na onnu maḻong-ag na onnu aabeng na maipagapu’t din mangiyapuwan Apudyus, ");
INSERT INTO kmk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","adayu’n ad-adu dat maawat na uttun matattaguwana nu sadat tinengyana. Ot anungus kad di aḻgaw awatona pay dit mataguwan un maid kigad na.” ");
INSERT INTO kmk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tinang-il Jesus binagbaga dat kagwampuḻu’t duwa un disipulus na ot kanana’n, “Dumngoḻ kayu! Tumagada taku’d Jerusalem ot losan dadit ingkanglit dat propetan Apudyus sidita mapasamak kan sakona Inyanak di Tagu, matungpal da. ");
INSERT INTO kmk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Maiyawatak sidat bokona Judio ot manliwliw-anak, pababbainanak kan luglugpaanak. ");
INSERT INTO kmk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kumkumpasanak asiyanak patoyon yoong umungaḻak sidin maikatlu’n aḻ-aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yoong adin dat disipulus na naawatan dit imbagana ta kama nu naisuḻuk dit kaipooyana ot naid tigammu da nu ngadan dadit uguugudona. ");
INSERT INTO kmk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Utdit ininggaw da Jesus sidit adani’t din Jerico inggaw nakuḻapa tagu’n mantutupak sit igid dit kaḻsa’n tumaptappaya. ");
INSERT INTO kmk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Magngoḻ na man dit damit dat aduadu’n tagu’n lumaus, inimus na nu ngadan dit mapaspasamak. ");
INSERT INTO kmk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Manlaus si Jesus un iNazaret,” kinnanan da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Utdiyon, nampakuy un, “Jesus un kaganakan Ali David kaasiyanak.” ");
INSERT INTO kmk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sadat tagu’n namangu’t dit buḻog inggimau da ot imbaga da un walling. Yoong amo indakoḻ na ota kinnanana’n, “Kaganakan Ali David kaasiyanak.” ");
INSERT INTO kmk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Magngoḻan man Jesus, nan-illong ot imbagana un idatong da kan siya dit nakuḻap. Idatong da man, inimusan Jesus un, ");
INSERT INTO kmk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngadan nat piyaoma kook kan sika?” Ot kanan dit nakuḻap un, “Apu, piyaok umila.” ");
INSERT INTO kmk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Utdi, imbagan Jesus kan siya un, “Umila kaon. Kummiya ka gapu’t nat pammatim kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dagusa ummila dit nakuḻap ot naitung-ud kan Jesus un nandaydayaw kan Apudyus. Ot mailan man dat losana tagu dit napasamak nandaydayaw da pay kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Utdit lumaus da Jesus sin Jerico, ");
INSERT INTO kmk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","inggaw osa’n baknanga ap-apun dat man-uuḻup si bugis un mangngadan kan Zakeo. ");
INSERT INTO kmk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Piyaona’n taḻon un ilan si Jesus nu kamaana yoong adina maila ta abobboba’n tagu ot masaklinan si Jesus sidat aduadu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sat kingwana, nanoddaka ummun-una’t dit doḻdoḻon da Jesus ot summakay sit kayu un ngadnon dat sikamoro daḻapnu lumaus da kad mailana. ");
INSERT INTO kmk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Utdit dumatong da Jesus sit summakayan Zakeo, tinangad Jesus ot kinnanana un, “Zakeo lumsa ka’t nat. Daḻasom ta umoyak sin boḻoy yu uttun aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dagusa nilumsa si Zakeo ot amod dit anggom na un nangidallay kan Jesus sit boḻoy da. ");
INSERT INTO kmk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mailan man dat tagu dit kingwan Jesus nampangonot da un kanan dan, “Apay umoy pasangaili utnat osa’n gumabasuḻa tagu?” ");
INSERT INTO kmk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yoong summikad si Zakeo utdit atubang Jesus un kanana’n, “Apu, itdok nat gogwan di losana kukuwak sidat nakapus. Ot sadat tagu’n kinuluk ku sukatak si mamimpat si kaadu na dat inaḻak.” ");
INSERT INTO kmk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kinnanan Jesus kan siya un, “Uttun satuna aḻgaw taguwon Apudyus datuwa simbaḻyan gaputa si Zakeo pinada na si Abraham un ginnapuwana un nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta sakona Inyanak di Tagu inummoyak situn pita daḻapnu umoyak inapon kan taguwon dat naiyawa.” ");
INSERT INTO kmk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Utdiya dudumngoḻan dat tagu kan Jesus, intulutuluy na un nan-abalig ta adani daon sin Jerusalem ot kanan dat tagu nu ilan daona dagus dit man-apuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ot kinnanana’n, “Inggaw osa’n tagu’n nangatu’t saad na un inummoy sit adayu’n ili daḻapnu mabaḻangatana ali asi mangulina mangiyapu. ");
INSERT INTO kmk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Inayagana dat simpuḻu un baba-unona’t dit daan na un manlakkatan ot sinin-ossa na dida’n initdan si pilaka buḻawan un kanana’n, ‘Siyatu’d mampuunan yu un mannigusiyu inggana’t mangulinak.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Yoong taḻona lalawwengon dat kailiyana diya tagu ot nangibaun dat uduma tagu’n maitung-ud kan siya ta umoy da ibaga’t dit emperador un, ‘Apu Emperador, adimi piyaon tuwa tagu un man-ali mi.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Yoong nambalin payona ali diya nangatu’n tagu. Ot utdit nangulin pinaayagana dat baba-unona un initdana si pilak ta ilana nu piga dit nambalinan dit pilaka intod na kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Dummatong dit ummuna ot kinnanana un, ‘Apu, pinangganansiyak si simpuḻu dit os-ossaana pilaka buḻawana intod nu.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“‘Nabaḻu nat kingwam,’ kinnanan dit ali. ‘Nabaḻu ka un baba-unon. Ot gaputa mataḻgodan ka utdan akita naitod kan sika, mangitulayok sika si simpuḻu’n ili.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Dummatong pay dit maikagwa un kanana’n, ‘Apu, pinangganansiyak si lima dit os-ossaan un buḻawana pilak.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ot kinnanan dit ali kan siya un, ‘Sika’d mangitulayok si lima’n ili.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Naisongwat pay dit osa’n baba-unon un kanana’n, ‘Apu, antu dit pilak nu. Binugubugus ku si pangyu asik insuḻuk ");
INSERT INTO kmk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ta kumimutak kan sika ta nasuḻag ka un tagu. Aḻam nat bokona kuwam kan apitom nat bokona immuḻam.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kanan dit ali kan siya un, ‘Sika’d kadadagana baba-unon. Dusaok sika gapu pay lawan sidanat imbagam. Titiggammum un nauyungak ot aḻak nat bokona kuwak kan apitok nat bokona immuḻak. ");
INSERT INTO kmk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ot apay adim imbangku daḻapnu dumatongak kad awad ganansiya na un iyulin nu kan sakon?’ ");
INSERT INTO kmk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Utdi, kinnanana’t dat tagu’n sumisikad sidi un, ‘Aḻan yu nat pilak kan siya ta itdon yu utdit nakaganansiya si simpuḻu.’ ");
INSERT INTO kmk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yoong kinnanan da kan siya un, ‘Apu andi manon simpuḻu’n pilak nan?’ ");
INSERT INTO kmk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Summungbat dit ali un, ‘Ibagak kan dikayu, sat tagu’n mangusal sidat maitod kan siya daḻapnu taḻona naselbi da, maitdan pay si ad-adu. Yoong sat adi mangusal, ulay sat akita awad kan siya maaḻa. ");
INSERT INTO kmk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ot sadan gumusbusuḻ kan sakon un adi mamiya un sakon man-ali da, idatong yu ta patoyon yu dida’t tun sanguwak,’ kinnanan dit ali.” ");
INSERT INTO kmk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Magangput mana maibagan Jesus di, intuluy na dit umoyana’d Jerusalem ot tinung-ud dat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Utdit umadani daon sidin Betfage kan Betania utdit bateled Olivo, nambaun si Jesus si duwa’t dat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kinnanana kan dida un, “Umuna kayu’t nat madoḻdoḻa boboḻoy ot nu makadatong kayu awad odasan yu si naisilu’n ubbun di dangki un adina payyan nakabayuwan. Ussagan yu ta idatong yu uttu. ");
INSERT INTO kmk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nu awad mangimus nu apaya ussagan yu, ibaga yu un masapul dit Apu.” ");
INSERT INTO kmk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kaysan dat imbaun na ot indasan da un tuttuwa dat imbagan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Utdiya madama’n us-ussagan da dit ubbun di dangki, kinnanan dit singkuwa un, “Koon yu un ussagan nat ubbu?” ");
INSERT INTO kmk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ot kinnanan da un, “Masapul din Apu.” ");
INSERT INTO kmk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Indallay da kan Jesus ot inyap-ap da dat kagoy da utdit dangki asida pinangkabayu si Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Utdit manaddaḻanon si Jesus un dit nangkabayu, inyap-ap dat uduma tagu dat kagoy da utdit daḻan. ");
INSERT INTO kmk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Utdit manlapu daon un gumusad sin bateled Olivo un dumoḻdoḻan da ud Jerusalem inlapun dat adu’n naitung-ud kan Jesus dit mantattaḻok kan mampappakuy un mangidaydayaw kan Apudyus gapu utdat nakaskasdaawa kingkingwa na un naila da. ");
INSERT INTO kmk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Gapappakuyan da un kanan dan, “Bindisyunan Apudyus tun Ali un imbaun na un pannakalong-ag na. Kapiya utdin langit kan madaydayaw si Apudyus sidin kangattuwana langit.” ");
INSERT INTO kmk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ot sadat uduma Fariseo un naidagamung sidat tagu, kinnanan da kan Jesus un, “Mistulu, ibagam sidan disipulus nu ta walling da.” ");
INSERT INTO kmk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Summungbat si Jesus un, “Ibagak kan dikayu un nu guminok da, sadan batu dan maisongwata mampappakuya mandayaw kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Adaniyon da Jesus sin Jerusalem, ot maotap na man dit ili inibilana ta madaguwan sidan tagu. ");
INSERT INTO kmk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kinnanana un, “Ay Jerusalem! Nu tigammum okyan pay situn satuna aḻgaw nat masapul daḻapnu kapkapiya ka. Yoong adim kampay maimatunan. ");
INSERT INTO kmk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ot dumatong nat aḻgawa umoy dat kabusuḻ nu mangalikuman kan sika, sondan dika ot maid ayon dat tagum un mambutik. ");
INSERT INTO kmk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aminon dika un yam-anon kan patoyon da dan losana tagum. Maid ulay osa’t batu si adi magidu ta adim immatunan dit dummakngan Apudyus un managu kan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dumatong da man Jerusalem, nilumnok si Jesus sit timplu ot pinaḻaksun na un inamin dat manlaḻaku. ");
INSERT INTO kmk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kinnanana kan dida un, “Naikanglit sit ugud Apudyus un, ‘Satun boḻoy ku, boḻoya luluwwaḻuwan,’ yoong pinambalin yu un igaw di makuluk.” ");
INSERT INTO kmk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Manipud sidiyon, kaaḻga-aḻgawa mantudtudu si Jesus sit timplu. Ot sadat aap-apun di padi kan dat mimistulun di lintog padana pay dat pappangat dat tagu’t di inainapon da dit mamatoyan da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yoong adida tigammu nu inon dit koon da ta losan dat tagu taḻona pipiyaon da dit dudumngoḻ kan siya’t dit itudtudu na. ");
INSERT INTO kmk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sin-aḻgawan un mantudtuduwan Jesus sidat tagu’t dit timplu kan mangiwalwalagawagana’t dit Nabaḻu’n Damag, ummoy dat aappun di padi, mimistulun di lintog kan sadat lalallakay dat Judio kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kinnanan da kan siya un, “Ibagam ud kan dikami nu ngadan nat kalintogama mangwa’t danat kokkoom onnu singngadan nat nangtod kan sika’t kalintogam?” ");
INSERT INTO kmk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Summungbat si Jesus un, “Antu pay imusok kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ibaga yu ud kan sakon nu singngadan dit nanligwatan dit kalintogan Juan un mambunyag, nanligwat kan Apudyus onnu nanligwat si tagu?” ");
INSERT INTO kmk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Utdi, nampipinnuut da pay lawan un kanan dan, “Nu ibaga taku un nalligwat kan Apudyus kana’t oni un, ‘Apay un adiyu tinuttuwa nu?’ ");
INSERT INTO kmk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yoong nu kanan taku’n nanligwat si tagu, batubatuwon ditaku’t datun adu un tagu gaputa tuttuwaon da un si Juan osa un propetan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Isunga insungbat da un adida tigammu. ");
INSERT INTO kmk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ot kanan Jesus kan dida un, “Ot madik pay ibaga tun nanligwatan tun kalintogaka mangwa’t datuwa kook.” ");
INSERT INTO kmk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Utdiyon, inyabalig Jesus tu utdat tagu un kanana’n, “Inggaw tagu un minuḻ-ana’t ubas dit pita na asina impatobaw ot nangaḻyug si nabayag si sabali’n ili. ");
INSERT INTO kmk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Utdit dumatong dit bubuḻḻasan, nangibaun si baba-unona un umoy mangaḻa’t dit gogwa na utdit naapit. Yoong pinangpang-ok dat nantobaw dit naibaun asida pinadaḻan un imaima. ");
INSERT INTO kmk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Utdi, nangibaun uman si osa’n baba-unon, pinangpang-ok da payyan asida binabbainan un pinangulina imaima. ");
INSERT INTO kmk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Utdi, nangibaun payyan si maikatlu utdat baba-unona ot pinangpang-ok da aginggana’t nasugasugat asida impagkaḻ sit lasin dit kaubasan. ");
INSERT INTO kmk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Utdiyon, kinnanan dit singkuwa’t dit kaubasan un, ‘Inon kad nin din kook? Ibaun ku tun potpotgoka anak ku ta ikabain da nad,’ kinnanana. ");
INSERT INTO kmk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Yoong mailan man dat mantotobaw dit anak, kanan da un, ‘Siyatu dit manawid situn pita. Patoyon taku daḻapnu mangkuwa taku tun pita.’ ");
INSERT INTO kmk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Utdi, inlaksun da dit anak sit kaubasan asida pinatoy. “Kadon, inon dit koon dit singkuwa’t dit kaubasan sidat nantobaw?” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Dumatonga umoy mamatoy sidat pinantobaw na kad asina ipatobaw dit kaubasan sidat udum.” Magngoḻan man dat tagu dit imbagana, kinnanan da un, “Adin Apudyus ipalubusa mapasamak nat kama’t nat.” ");
INSERT INTO kmk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Intutukkoḻ Jesus dida ot kanana’n, “Inonaon dit kanan dit naikanglita ugud Apudyus sidit aw-awe un, ‘Sadit batu un inidsan dadit mangkokokwa’t boḻoy, siya ud nambalina pannan dit sikun dit boḻoy?’ ");
INSERT INTO kmk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ot singngadan na mana maotdaga maitama utdiya batu masipsip-uk ot singngadan na mana maotdagan didiya batu matumotumok.” ");
INSERT INTO kmk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Naawatan dat mistulun di lintog kan aap-apun di padi un imbagan Jesus diya abalig un maibusuḻ kan dida ot pinadas da un dokmaan sidiya timpu yoong ummogyat da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kad sidiyon, linimalimadan da si Jesus. Ot nangibaun da si manissiim kan siya un man-ag-agin nalintoga tagu un umoy makaim-imus kan siya. Ta piyaon da nu makaibaga si maikaniwas daḻapnu awad lasun da un manokma kan siya asida ipaima kan gubinnadul un siya’d awad si kalintogan kan pannakabalin un mangukum kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ummoy dat naibaun kan Jesus ot kanan da un, “Mistulu, tigammu mi un ustu dan ibagbagam kan itudtudum. Maid idumdumam si tagu ta itudtudum nat katuttuwaana maipanggop sidan piyaon Apudyus ipakwa. ");
INSERT INTO kmk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ot ibagam ud nu naingkalintogana mambayad taku si bugis kan Caesar un Emperador ud Roma?” ");
INSERT INTO kmk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yoong naawatan Jesus dit sikap da ot kinnanana kan dida un, ");
INSERT INTO kmk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mangipaila kayu ud si pilak kan sakon?” Nangipaila da man kinnanana un, “Simmuging kan singngadan situn naimalka?” “Si Emperador Caesar,” insungbat da. ");
INSERT INTO kmk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ot kinnanan Jesus kan dida un, “Ot nu siya nat, itdon yu kan Caesar nat kuwan Caesar, ot itdon yu pay kan Apudyus nat kuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naid nagngoḻ dat naibaun si mamabasuḻan da kan siya utdit atubang dat adu’n tagu. Nasnasdaaw daot sidat insungbat na ot naid ginumgumminga kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Inggaw da ud ummoy kan Jesus un Saduceo un dida dat manguguda maid umungaḻ si natoy. ");
INSERT INTO kmk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Inimus da kan Jesus un, “Mistulu, kanan dit lintog taku un ingkanglit Moses un, ‘Nu mangasawa nat osa’n laḻaki ta matoy un naid anak na, masapula asaw-on dit sunud na dit bilug daḻapnu man-anak da si kama’t anak didit natoy.’ ");
INSERT INTO kmk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Ininggaw da ud pitu’n mansusunuda laḻaki. Nangasawa dit pangu yoong natoya naid anak na. ");
INSERT INTO kmk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Utdi, inasawan dit maikagwa’n sunud na dit bilug yoong natoy uman un maid anak na. ");
INSERT INTO kmk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Inasawan pay dit maikatlu yoong nampapada dit naipasamak inggana’t dit maikapitu’n sunud da un naamin da un natoya maid ingganak da utdit bilug. ");
INSERT INTO kmk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mabaybayag man, natoy pay dit bilug. ");
INSERT INTO kmk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Utdi, nu timpu’n umungaḻ dat natoy, singngadanon dit sin-asawa utdiya bilug, ta losan dat pitu’n mansusunuda nangasawa kan siya?” ");
INSERT INTO kmk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Summungbat si Jesus un kanana’n, “Man-aassawa dat tagu’t tun pita ");
INSERT INTO kmk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","yoong nu umungaḻ dat natoy, sadan tagu’n ibilang Apudyus un lobbonga matagu’t inggaingga, maidon man-aassawa kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ta maipada daon sidan aanghel un adi daon matoy. Abeng ud Apudyus didaon ta pinaungaḻ na dida kan katoy. ");
INSERT INTO kmk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Panoknokan Moses un umungaḻ dat natoy. Sadit ingkanglit na un maipanggop sidit umapuapuya kayu, imbaga na un, ‘Si Apudyus siya ud mandaydayawan da Abraham, Isaac kan Jacob.’ ");
INSERT INTO kmk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ot piyaona’n ugudon un si Apudyus bokona Apudyus dat natoy nu adi Apudus dan matatagu. Ta ulay nu natoy dit osa’n tagu, sissiya un matattaguwan sin biyang Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kinnanan dat uduma mimistulun di lintog un, “Mistulu, nabaḻbaḻu nat insungbat nu.” ");
INSERT INTO kmk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kinnanan da tu ta maidon makatuḻoda makaim-imus kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Utdi, kinnanan Jesus kan dida un, “Inona’n kanan da un sat Kristu kaganakan dit Ali David? ");
INSERT INTO kmk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta ulay si David ingkanglit na utdit iblu un Salmo un kanana’n, ‘Imbagan Apudyus kan Apuk un: Mantupak ka uttun kapon madiwanan ku ");
INSERT INTO kmk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","inggana’t abakok aminon dat kabusuḻ nu.’ ");
INSERT INTO kmk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Ot nu ‘Apu’ kanan David kan Kristu, in-inona’n kaganakana nu?” ");
INSERT INTO kmk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Utdiya dudumngoḻan dat tagu, imbagan Jesus sidat disipulus na un, ");
INSERT INTO kmk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Alimbanan yu danat mimistulun di lintog ta pipiyaon da un mangay-ayaw un anandu dat badut da un mangipaila’t dit saad da kan pipiyaon da nu dayawon dat tagu dida nu umoy da utdan aabtan di tagu. Pipiyaon da dit mantupak sit sangu utdin sinagoga kan inggaw sit inggawan dat nangangatu’n tagu nu amung. ");
INSERT INTO kmk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gundawayan da dat bilug ot aminon da un aḻan dat sanikuwa da, asida andu-anduwon dit luwaḻu da un manaḻ-in da utdit kokkoon da. Ot taḻona nadagson dit dusa da nu dumtong dit timpu,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nanlungayat si Jesus ot nailana dadit babaknanga man-ipisuk sidat pakdaw da kan Apudyus sidit pipissukan di pakdaw sidiya timplu. ");
INSERT INTO kmk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ot nailana pay dit nakapukapusa bilug un mangipisuk si duwa’n sipinga lawa. ");
INSERT INTO kmk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Utdi, kinnanana un, “Tuttuwa tun ibagak kan dikayu un sadin impisuk din bilug nabanbanol nu sadin impisuk dan udum. ");
INSERT INTO kmk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta sat intod dan udum sadit nansawaḻan da utdit binaknang da yoong san bilug ulay nu kapus intod na un losan dit awad kan siya un siya ullawa’d ikataguna.” ");
INSERT INTO kmk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sadat uduma tagu’t di babagbagaon da dit kinabaḻbaḻun dit timplu ta nangkaddakkoḻ dat batu un panikokwa na kan naal-altiyan pay si nabaḻu’n pakdaw da kan Apudyus. Ot kinnanan Jesus kan dida un, ");
INSERT INTO kmk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Losan datuwa maila yu mayam-an da ta dumatong nat timpu un maid osa’t batu si natuuga adi maidugpu.” ");
INSERT INTO kmk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Utdi, inimus da kan Jesus un, “Mistulu, ibagam ud nu kapiga dit maipasamakan dat imbagam kanad? Sin dit mangilasinan mi un dandaniyon dit mapasamakana?” ");
INSERT INTO kmk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Imbagan Jesus kan dida un, “Man-alimban kayu ta adi kayu maal-allilaw. Ta adu dan dumatonga tagu’n mangusal situn ngadan ku un kanan da un, ‘Sakon dit Mesias.’ Kanan da pay un, ‘Dummatongon dit timpu’n manganungusan tun lubung.’ Yoong adiyu tuttuwaon dida. ");
INSERT INTO kmk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Adi kayu kumimut nu awad magngoḻ yu si gubgubat ya gulgulu ta masapula umuna un mapasamak da. Yoong bokona dagusa dumatong nat anungus ditun lubung.” ");
INSERT INTO kmk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Intuluy Jesus un kanana’n, “Manggugubat dan kailin-ili uttun lubung kan mambibinnusuḻ dan tutulay. ");
INSERT INTO kmk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Awad da ud ga-oogyata lunig. Awad ud uḻat kan pistin di tagu utdan nadumaduma’n igaw kan awad da ud ga-oogyata mapasamak sinat ngatu kan nakaskasdaawa mangilasinan. ");
INSERT INTO kmk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Yoong daan payyana mapasamak datu, dopapon kan paligatan dikayu. Maipadaḻan kayun tu utdan sinagoga’n mabistigal asida dikayu paibaḻud. Gapu’t dit manuttuwaan yu kan sakon maimusan kayu utdan aali kan gugubinnadul. ");
INSERT INTO kmk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ot siyadiyon ud gundaway yu un mamanoknok maipanggop sit Nabaḻu’n Damag maipanggop kan sakon. ");
INSERT INTO kmk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Isunga imuḻa yu utnat somsomok yu un adiyu ikadanag dat isungbat yu nu dumatong diya timpu. ");
INSERT INTO kmk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ta sakon ud mangtod si silib yu un mambagbaga ot adi dikayu kabooḻan dat kabusuḻ yu un masungbatan onnu masuganggang. ");
INSERT INTO kmk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ulay dat mamaḻḻong-ag yu, sussunud, kakabagiyan kan gagayyom yu ituyuk dikayu. Ot patoyon da dat udum kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lalawwengon dikayu’t dan losana tagu maipagapu’t nat manuttuwaan yu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yoong ayyuwanak dikayu, ot maid mataḻak si ulay osa’t nat buuk yu. ");
INSERT INTO kmk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nu mannanayun nat pammati yu ulay nu mapalpaligatan kayu, maitdan kayu’t mataguwana maid kigad na.” ");
INSERT INTO kmk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Intuluy Jesus un kanana’n, “Nu maila yuwon din ili ud Jerusalem un maliput si suldadun dat kabusuḻ, siya ud manigammuwan yuwon un dandaniyon ud timpu’n mayam-anana. ");
INSERT INTO kmk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ot dikayu’n iJudea gumtik kayuwon sidan batbateled. Sadat awad situn Jerusalem masapula tengyan da tuwa ili. Ot sadat inggaw sidat boboḻoya awad sin lasin dituwa ili masapula adida umoy situ. ");
INSERT INTO kmk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ta siya diyon dit timpu’n madusaan dat iJerusalem daḻapnu matungpal dit naikanglit sidit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Taḻona kawas diya timpu utdat nabugi kan sadat mantagtagibi. Ta amoamoda ligat dit dumatong situwa igaw. Ot maidos-aḻ sidatuwa tagu dit ligligot Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mapatoy dat udum kan dida si ispada ot maidaḻan dat udum sit uduma ili un mabaḻud. Ot yam-ayam-anon tu dat bokona Judio tun Jerusalem inggana’t magangput dit naikoddonga timpu da un bokona Judio.” ");
INSERT INTO kmk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Utdiya timpu awad da ud mangimatunana mapasamak sin init, buḻan kan sadan bituwon ot situn pita maid kapukapuut dat tagu utdat koon da ta amod dit kimut da utdit man-ag-agguwodan din baybay kan maḻukuḻukuta paḻuung. ");
INSERT INTO kmk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Matukas dat tagu utdit kimut da un manguuway nu ngadan dit mapasamak situn lubung, ta losana awad sinat langit maligaligad da. ");
INSERT INTO kmk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Utdiyon, ilan da ud sakona Inyanak di Tagu un dumoba’n mailabaw sit bunot un napnu’t pannakabalin kan nakaskasdaawa kinangatuk. ");
INSERT INTO kmk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu manlugi un mapasamak datu, sumikad ot tumangad kayu ta dandaniyon nat managuwan Apudyus kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Utdi, imbagan Jesus tuwa abalig un kanana’n, “Ilan yu din kayu un igus kan sadan uduma kayu. ");
INSERT INTO kmk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu manlugi’n sumungbud dan tubu da tigammu yuwon un dandani nat iinnitan. ");
INSERT INTO kmk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ot padana pay un nu maila yuwona mapasamak datuwa ligat tigammu yuwon un dandaniyon dit mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Tuttuwa tun ibagak kan dikayu un mapasamak un losan datu daan payyana matoy dan losana tagu uttuwa lonap. ");
INSERT INTO kmk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mangkigada losan dan maila ud langit kan situn pita yoong mannanayun tun ugud ku.” ");
INSERT INTO kmk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Intuluy Jesus un kanana’n, “Man-alimban kayu ta adiyu sad maiḻumḻuman dan nalabosa laglagsak, in-inum kan danag maipanggop situn mataguwan daḻapnu adina kama’t baḻaisa kakḻata maksob kan dikayu nata aḻ-aḻgawa mangulinak. ");
INSERT INTO kmk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ta kakḻata lawa’n dumatong nata aḻ-aḻgaw sidan losana tagu’t tun pita. ");
INSERT INTO kmk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ot mansagana kayu un kanayun kan iluwaḻu yu un awad bilog yu un mangilasat sidan losana mapasamak kan daḻapnu nataḻgod kayu un sumikad sit sinagung ku un Inyanak di Tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kaaḻgaw-aḻgawa mantudtudu’t Jesus sit timplu yoong nu gumidgidam manaḻan un umoy umbog sin bateled Olivo. ");
INSERT INTO kmk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ot masapsappaan dat tagu’n umoy sit timplu mandongoḻ kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Dandaniyon dit Piyestan di Nalausan un siya dit manganan dat Judio si tinapaya maid si bubud. ");
INSERT INTO kmk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ot sadat aappun di padi kan mimistulun di lintog inainapon da nu in-inon dit mampapatoy da kan Jesus si nalimod ta kumimut da utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sinakayan Satanas si Judas Iscariote un osa utdat kagwampuḻu’t duwa’n disipulus Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kadon kaysan si Judas ot inummoy nakabagbaga’t dat aappun di padi kan oopisyal dat man-aandog sit timplu daḻapnu makatulag nu in-inon dit man-iituyuk na kan Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nataḻok dan nangngoḻ sit imbagan Judas ot insapata da un itdan da si pilak. ");
INSERT INTO kmk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Intuḻon Judas ot inluginaon un inainapon dit gundaway na un mangituyuk kan Jesus un adin dat adu’n tagu matigammuwan. ");
INSERT INTO kmk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dinumtong dit aḻgaw dit Piyestan di Tinapaya maid si bubud un siya dit mapaltiyan dit ubbun di kannelu un mausal nu Piestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kadon, imbaun Jesus da Pedro kan Juan un kanana’n, “Umoy kayu isagana dit kakan taku uttun Piyestan di Nalausan.” ");
INSERT INTO kmk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Kawad dit piyaoma umoy mi mangisaganaan?” inimus da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","“Dongḻon yu,” kinnanan Jesus. “Nu makadatong kayuwon sin ili, maabat yu ud osa’n tagu un nan-awit si naamussu un danum. Unudon yu utdit lumnokana un boḻoy. ");
INSERT INTO kmk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ot ibaga yu utdit simboḻoy un, ‘Paimus dit Mistulu nu kawad dit kuwaltu un manganana utdit kakan di piyesta pati utdat disipulus na.’ ");
INSERT INTO kmk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kad ipailana kan dikayu ud dakoḻana kuwaltu’n nanginngatu un siya’d kawadan dat losana masapul taku ot siya’d mangisasagganaan yu utdat kanon taku nu Piyestan di Nalausan.” ");
INSERT INTO kmk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kaysan da ot naituttuwa un losan dat imbaga na kan dida. Mansidi, insagana da dit kakan di piyesta. ");
INSERT INTO kmk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Utdit dumatong dit olasa manganan da, ummoy si Jesus nakaubung sidat apostoles na. ");
INSERT INTO kmk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ot kinnanana kan dida un, “Taḻona inaayyuwaka makakan kan dikayu uttuwa kakan di Piyestan di Nalausan sin daan din mapaligatak. ");
INSERT INTO kmk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta ibagak kan dikayu un adiyakon umbosa mangan situwa kakan aginggana’t dit matungpaḻan dit kustu’n kaipooyana utdin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ot inaḻana dit natasa’n inumon da. Maabus mana manyaman kan Apudyus kinnanana un, “Aḻan yu tu ta mambibingayan yu un inumon. ");
INSERT INTO kmk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta ibagak kan dikayu un manipud sinsatun adiyakon umbosa uminum si danum di ubas aginggana’t dumatong nat mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nangaḻa payyan si tinapay ot maabus mana manyaman kan Apudyus biniibiik na un inwaḻas kan dida un kanana’n, “Siyatu ud long-ag ku un maidatuna mampooy kan dikayu. Manipud sinsatun koon yu tu un mangisomsomkan yu kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Padana pay sit naabus da un nangan, inaḻa na dit tasa un kanana’n, “Satu un natasa dit bagu’n tulag Apudyus kan dikayu un mapataḻgodan situn daḻaka man-ayus un mampooy kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Yoong ilan yu. Antu’t tu un kaubung ku tun mangituyuk kan sakon. ");
INSERT INTO kmk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta sakona Inyanak di Tagu mapatoyak un kama’t dit ingkoddong Apudyus yoong kaasi nat tagu’n mangituyuk kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Utdi, nampaim-imus pay lawan dat disipulus na nu singngadan na kan dida dit mangwa. ");
INSERT INTO kmk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nampasungsungbat pay dat disipulus nu singngadan na kan dida dit mabigbig un kangattuwan. ");
INSERT INTO kmk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ot kinnanan Jesus kan dida un, “Sadat alin dat bokona Judio kan sadat uduma mangitulay kan dida, piyaon da un natulay da utdan iyapuwan da. Ot piyaon da pay un mangaddanan da si Nalaay. ");
INSERT INTO kmk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yoong bokon un kama’t di kan dikayu, ta sat kangattuwan kan dikayu masapula kama nu siya’d kaabengan. Sat pangat kan dikayu masapula kama nu siya’d babbaun. ");
INSERT INTO kmk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngadan dit nangatngatu, sadit mangan sit lamesaan onnu sat mansunad? Bokon kad un sat mangan sit lamesaan? Yoong antuwak kan dikayu un manselbi. ");
INSERT INTO kmk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Dikayu dat adi lummipsuta nanungtung-ud kan sakon sidat losana napadasak. ");
INSERT INTO kmk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ot itdak dikayu si kalintogan un mangiyapu un kama’t dit nan-iitod Amak kan sakon si kalintogan un mangiyapu. ");
INSERT INTO kmk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ot makaubung kayu un makakan kan makainum kan sakon sin mangiyapuwak kan mantupak kayu’t din trono un mangiyapu utdan kagwampuḻu’t duwa’n tribu un kaganakan Israel.” ");
INSERT INTO kmk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Utdi, kinnanan Jesus kan Simon Pedro un, “Simon, Simon, dongḻonak. Napalubusan si Satanas un mamadas kan dikayu’n losan un kama’t man-akiyak si trigo daḻapnu isina na dat nabaḻu utdat laweng. ");
INSERT INTO kmk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yoong inluwaḻuwak sika, Simon, daḻapnu adika lumipsuta manuttuwa kan sakon. Ot nu mandadaoli kaon ot mangulin ka kan sakon, pabilgom dit pammatin dat susunud nu.” ");
INSERT INTO kmk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kinnanan Pedro kan Jesus un, “Apu, nadaddaanak un maipasimbaḻud kan maipangkatoy kan sika.” ");
INSERT INTO kmk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Ibagak kan sika Pedro,” kinnanan Jesus. “Daan payyan manullauk din kawitan si bigbigat isulibakon si mamitlu.” ");
INSERT INTO kmk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kinnanan pay Jesus kan dida un, “Utdit nangibaunak kan dikayu’t dit un maid pitaka, sambag kan sandalyas, awad kad nangkulangan yu? “Naid,” kinnanan da un summungbat. ");
INSERT INTO kmk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kinnanan Jesus un, “Yoong sinsatunon, sanat awad si pitaka aḻana, padana pay sit sambag na. Nu awad naid si ispada na ilaku nat dit kagoy na ta gumatang si osa. ");
INSERT INTO kmk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta masapula matungpal dit naikanglit sit ugud Apudyus maipanggop kan sakon un kanana’n, ‘Maibilang sidat gumabasuḻ.’ On, dandaniyon un matungpal dat naikanglit maipanggop kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Utdi, kinnanan dat disipulus na un, “Apu, antu’d duwa’n ispada uttu.” “Oḻog na naton!” insungbat Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tinengyan Jesus dit ili ot ummoy sin bateled Olivo un gagangaya siya’d kokkoona ot naibuḻun pay dat disipulus na kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dumatong da man sidi, kinnanana kan dida un, “Manluwaḻu kayu daḻapnu adi kayu mambasuḻ nu masugsugan kayu.” ");
INSERT INTO kmk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ummadayu si Jesus kan dida si akit asina nampalintumunga nanluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kinnanana un, “Ama, nu piyaom, ilisiyak situn amoda ligat un sagapaḻok. Yoong bokona satun piyaok tun matungpal nu adi sanat piyaom.” ");
INSERT INTO kmk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Utdi inggaw anghel un nanligwat langita nampaila kan siya’n nampabilog sit somsomok na. ");
INSERT INTO kmk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ot gaputa amoamod dit domdom na, impapatina’n nanluwaḻu ot nangkalingot si kama nu daḻa un nan-at-attod sit pita. ");
INSERT INTO kmk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Utdit nagangputa nanluwaḻu si Jesus, summikad ot nangulin sidat disipulus na ot dintong na dida un nasusuyop gaputa madodomdoman da. ");
INSERT INTO kmk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ot kinnanana kan dida’n, “Koon yu un masusuyop? Gumangun kayu ta manluwaḻu kayu daḻapnu adi kayu mambasuḻ nu masugsugan kayu.” ");
INSERT INTO kmk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mambagbagbaga payyan si Jesus sidit dummatong dat adu’n tagu’n pinuyut Judas un osa utdat kagwampuḻu’t duwa’n disipulus. Ummadani si Judas kan Jesus asina inogkan. ");
INSERT INTO kmk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yoong kinnanan Jesus un, “Judas, ogok kad nat man-iituyuk nu kan sakona Inyanak di Tagu?” ");
INSERT INTO kmk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Utdit mailanon dat disipulus na dit mapaspasamak, kinnanan da un, “Apu, makabinnakag kamiyon?” ");
INSERT INTO kmk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ot osa kan dida dit namakag sidit baba-unon dit kangattuwana padi ot nasokdap dit diwanana inga na. ");
INSERT INTO kmk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yoong kinnanan Jesus un, “Oḻog naon.” Asina inaggoman dit ingan dit baba-unon ot kummiya. ");
INSERT INTO kmk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Utdiyon, kinnanan Jesus sidat aappun di padi, oopisyal dat man-aandog sit timplu kan dat lalallakay un ummoy manokma kan siya un, “Tulisanak kad ta gabadangan kan gapang-uḻan kayu un umoy manokma kan sakon? ");
INSERT INTO kmk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaaḻgaw-aḻgawak sin timplu kan dikayu’n nantudtudu yoong adiyu ud sakon dinokmaan. Yoong siyatuwon ud timpu yu kan timpu’n mantulayan dit pannakabalin Satanas.” ");
INSERT INTO kmk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Utdi, dinokmaan da si Jesus ot indallay da utdit boḻoy dit kangattuwana padi. Tinungtung-ud Pedro yoong inad-adayuwana. ");
INSERT INTO kmk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Awad aanniduwan sit gaggawan dit paway ot ummoy si Pedro nakaanidu utdat ininggaw sidi. ");
INSERT INTO kmk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Utdit mailan dit osa’n babai’n baba-unon si Pedro un mantutupak sit madoḻangan dit apuy, intukkoḻ na un kanana’n, “Satu pay osa’n buḻun na.” ");
INSERT INTO kmk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yoong insulib Pedro un kanana’n, “Adik tigtigammu nat un tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Masulsulit man, inggaw osa’n laḻaki un nakaila kan siya ot kanana’n, “Osa ka pay sidat buyut na.” Yoong summungbat si Pedro un, “Ay, bokonak.” ");
INSERT INTO kmk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lumabas man umoya sin-olas impapilit payyan dit osa un kanana’n, “Gattoka siyatu’d osa utdat kabbuḻunana ta iGalilea.” ");
INSERT INTO kmk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yoong kinnanan Pedro un, “Maid tigammuk sinat ibagbagam.” Mambagbagbaga payyan si Pedro, dagusa nanullauk dit kawitan. ");
INSERT INTO kmk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ummaswing si Jesus ot intutukkoḻ na si Pedro. Ot nagasmok Pedro dit imbagan Jesus kan siya’n, “Daan payyan manullauk dit kawitan si bigbigat insulibakon si namitlu.” ");
INSERT INTO kmk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mansidi, lummaksun si Pedro ot nan-i-ibil. ");
INSERT INTO kmk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Utdiyon, sadat tagu’n nangaandog kan Jesus, binabbainan da kan dinatadataḻ da. ");
INSERT INTO kmk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Binaḻaw da pay asida tinipak kan inimusana kanan da un, “Pugtuwam ud nu singngadan nat nanipak kan sika?” ");
INSERT INTO kmk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ot adu pay dat imbaga da un namabbain da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Utdit mabigat, nandadatdatong dat kamang di Sanhedrin un bukoḻon dat lalallakay dat Judio, aap-apun di padi kan mimistulun di lintog ot paindatong da si Jesus kan dida. Ot kinnanan da kan Jesus un, ");
INSERT INTO kmk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ibagam ud kan dikami nu sika dit Kristu?” Summungbat si Jesus un, “Ulay nu ibagaka sakon adiyu mit laing tuttuwaon. ");
INSERT INTO kmk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ot nu awad imusok kan dikayu adiyu mit laing sungbatan. ");
INSERT INTO kmk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yoong, manipud situn satun, sakona Inyanak di Tagu mantupakak sin kapon diwanan ud Apudyus un mannakabalin.” ");
INSERT INTO kmk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","“Adi pay an, sika dit Anak Apudyus?” kinnanan da. Summungbata kanana’n, “On, naibaga yun.” ");
INSERT INTO kmk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ot kinnanan da un, “Ngadan payyan nat manapulan taku si uduma mangustigu? Dingngoḻ taku un mismu dan imbaga na un maisuganggang kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Utdi, lummakkat da un losan dat naamung ot indallay da si Jesus kan Pilato. ");
INSERT INTO kmk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dumatong da man inlapu da un mampabasuḻ kan siya un kanan dan, “Naodasan mi tuwa tagu un al-allilawona dan kailiyan mi. Iyapa na un mambayad dat tagu si bugis kan Emperador Caesar. Kabawona pay un siya si Kristu un ali.” ");
INSERT INTO kmk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Inimusan Pilato si Jesus un kanana’n, “Sika kad dit Alin dat Judio?” Summungbat si Jesus un, “Naibagamon.” ");
INSERT INTO kmk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Utdi, kinnanan Pilato utdat aap-apun di padi kan dat adu’n tagu un, “Maid odasak si gapun di manusaak situwa tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yoong impapilit da un, “Makibul dat tagu maipagapu’t dat intudtudu na un inlugi na ud Galilea inggana’d Judea kan ulay situwon.” ");
INSERT INTO kmk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Utdit nagngoḻan Pilato tuwa imbaga da inimus na nu iGalilea si Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Utdit natigammuwana un osa utdat ipangatan Herodes, paindallay na si Jesus kan Herodes un ininggaw payyan sin Jerusalem sidiya timpu. ");
INSERT INTO kmk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Utdit mailan Herodes si Jesus, nan-ang-anggom ta nasulita aayyuwana dit maka-il-ana kan siya ta nagngoḻ na dit maipanggop kan siya ot nanam-ona un mangila si am-amuga koona. ");
INSERT INTO kmk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ot nakaimuimus si Herodes kan siya yoong taḻona maid sinungbatan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gasikadan dat aappun di padi kan mimistulun di lintog sidi un nasuḻaga mangipappapilit sidat mamasuḻan da kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dinuḻa kan binabbainan da Herodes kan dat suldadu na si Jesus ot binadutan da si kama’t badut di ali asin Herodes pinangulin kan Pilato. ");
INSERT INTO kmk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Utdiya aḻ-aḻgaw, nanggayyom da Pilato kan Herodes un nambinnusuḻ sidit. ");
INSERT INTO kmk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Utdit indatong da si Jesus, pinandatdatong Pilato dat aap-apun di padi, papangat kan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ot kinnanana kan dida’n, “Indatong yu tuwa tagu kan sakon ot kanan yu un al-allilawona dat tagu. Sinuknaaka dodongḻon yu ot naid maodasan si basuḻ na utdan losana ipabpabasuḻ yu kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ulay si Herodes maid pay maodasana. Siya’d gapuna un pinan-ulin na kan ditaku. Naid kingwan dituwa tagu daḻapnu mapatoy. ");
INSERT INTO kmk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ot pasabid ku asik padaḻnon.” ");
INSERT INTO kmk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Imbagan Pilato di ta masapula mangiwaya si osa’n baḻud nu timpun di Piyestan di Nalausan ta siya’d gagangay da un Judio. ");
INSERT INTO kmk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Yoong nampappakuy dat losana tagu un kanan dan, “Papatoy nu tuwa tagu ta si Barrabas ud wayaam.” ");
INSERT INTO kmk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barrabas naibaḻud gaputa osa utdat lummaban sit gubilnu utdiya ili kan kummatoy pay. ");
INSERT INTO kmk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ot gaputa piyaon Pilato un pawayaan si Jesus kinabagbaga na uman dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yoong impappakuy da un, “Pailansam si kulus! Pailansam.” ");
INSERT INTO kmk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Utdi, pinitlun Pilato un makabagbaga kan dida un kanana’n, “Apay, ngad nat nadadaga kingwa na? Naid odasak si basuḻ na daḻapnu mapatoy ot pasabid ku asik padaḻnon.” ");
INSERT INTO kmk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yoong taḻona gapappakuyan da un mangipappapilita pailansa da utdit kulus inggana’t nangabak da. ");
INSERT INTO kmk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ot kinoddongan Pilato si Jesus un kamat din piyaon da. ");
INSERT INTO kmk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Winayawayaana si Barrabas un nabaḻud gapu’t dit lumablabanana’t dit gubilnu kan kummatoyana, ta siya’d piniya da un mapawayaan. Ot intod na si Jesus kan dida ta umoy da koon dit piyaon da un koon kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Utdiya mangidaldallayan da kan Jesus, naabat da si Simon un iCirene un nanligwat sit kapappayawan. Kinakma da ot impabukud da kan siya dit kulus asida impatung-ud kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Amoda tagu dat naitungtung-ud kan Jesus. Inggaw da pay babai’n mangibiibil kan mangilamalamat kan siya. ");
INSERT INTO kmk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yoong inaswingan Jesus dida un kanana’n, “Dikayu’n babai’n iJerusalem bokona sakon ibilan yu, sad ibilan yu danat long-ag yu kan dat aanak yu. ");
INSERT INTO kmk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta adaniyon nat timpu un kanan tu dat tagu un, ‘Nagasat dat lupot kan dat adi nakapadasa mabugi, kan dat adi nampasusu.’ ");
INSERT INTO kmk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Utdiya timpu, kanan dan tu dat tagu utdat bateled un, ‘Bunbunan dikami,’ ot kanan da utdan batung-uḻ un, ‘Labugan dikami.’ ");
INSERT INTO kmk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta nu kama’t tu tun koon da kan sakon un maid si basuḻ un maiyalig si naata’n kayu, adi amodot sooni utdan gumabasuḻ un maiyalig si naḻangu un kayu?” ");
INSERT INTO kmk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Inggaw da pay duwa’n tulisan un indallay da un maidisan kan Jesus un mapatoy. ");
INSERT INTO kmk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dumatong da man sit igawa ngadnon da si Battukag inlansa da si Jesus sidit kulus ot inlansa da pay dat duwa’n tulisan sidat kulus da, osa’t dit kapon madiwanan na kan osa’t dit kapon makawigi na. ");
INSERT INTO kmk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Utdi, nanluwaḻu si Jesus un kanana’n, “Ama pakawanom dida ta adida tigammu tun kokkoon da.” Sadat suldadu, nambubunut da nu ngadan dit mangkuwan di osa utdat badut na. ");
INSERT INTO kmk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aduadu dat tagu’n gasikadan sidi un mangiila’t dat koon da. Ot sadat pappangat di iJudio dinuḻaduḻa da si Jesus un kanan dan, “Tinagu na dat udum, apay un adina taguwon nat long-ag na pay lawan nu siya si Kristu un pinilin Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Binabbainan pay dat suldadu ot inadaniyan da asida initdan si kiloma basi. ");
INSERT INTO kmk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ot kinnanan da kan siya un, “Nu ali dika’t dan Judio apay adim taguwon nat long-ag nu?” ");
INSERT INTO kmk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Inggaw pay naikanglit sidit labaw dit uḻu na utdit kulus un kanana’n, “Siyatu dit Alin dat Judio.” ");
INSERT INTO kmk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Osa’t dat tulisana nailansa dit nanginsultu kan siya un kanana’n, “Bokon kada sika dit Kristu? Taguwom nat long-ag nu ot taguwom pay dikami.” ");
INSERT INTO kmk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yoong sadit osa, sinuḻagana dit buḻun na un kanana’n, “Apay maid kimut nu kad kan Apudyus? Nampapada taku’n nakoddongana madusa. ");
INSERT INTO kmk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yoong dita’n duwa masapula madusa ta ta nakabasuḻ ta un tuttuwa yoong sanata tagu maid kingkingwa na si laweng.” ");
INSERT INTO kmk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ot kinnanana kan Jesus un, “Gagasmokonak pay Jesus nu dumtong nat man-aliyam.” ");
INSERT INTO kmk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kinnanan Jesus kan siya un, “Tuttuwa tun ibagak kan sika, sinsatunon umoy ka kan sakon langit.” ");
INSERT INTO kmk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mamalintuud man si init, kinumḻop diya ili agingga si nandangwilis. ");
INSERT INTO kmk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ot nangkagwa’n napissay dit koltina’t din timplu. ");
INSERT INTO kmk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Utdi, nampakuy si Jesus un kanana’n, “Ama, itaḻgod ku kan sika tun ispirituk.” Maibaga na man di, napungdiwon dit angos na. ");
INSERT INTO kmk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Utdit nailan dit kapitan dat suldadu dit napasamak, nandayaw kan Apudyus ot kanana’n, “Tuttuwa’n naid basubasuḻ dituwa tagu.” ");
INSERT INTO kmk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Utdit nailan dat tagu’n naamung sidiya mambubuya dit napasamak, nangkadaḻan da utdat boboḻoy da un binbintugon da dat paḻagpag da gapu’t dit sigab dit angos da. ");
INSERT INTO kmk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Losan dat gagayyom Jesus kan dat babai un naitungtung-ud kan siya manipud Galilea, sumisikad da utdit ad-adayyu ot naila da un losan datu un napasamak. ");
INSERT INTO kmk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Utdi, inggaw osa’n tagu’n mangngadan kan Jose un siguda iyArimatea utdin Judea. Nabaḻu kan nalintoga tagu un manguuway sit dumakngan dit mangiyapuwan Apudyus. Osa un kamang di Sanhedrin yoong adina inampayunan dat buḻun na utdit ingkoddong da kan kingwa da kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inummoy kan Pilato ot kindaw na dit ladag Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Impalubus Pilato ot utdit indoba naon dit ladag, nilukutana’t bagu’n luput asina umoy innilbon sit dakoḻa batu’n inabutana un naid payyan nailbon. ");
INSERT INTO kmk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sadiya aḻgaw dit mansaganaan da utdit aḻ-aḻgawa iillongan un dandaniyon manlugi. ");
INSERT INTO kmk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sadat babai’n nanung-ud kan Jesus manipud sin Galilea naitungtung-ud da pay kan Jose isunga naila da dit lobon kan sat nan-iilbon na’t dit ladag Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Utdiyon nangulin da utdin ili ta umoy da man-isagana’t dat bangbangu kan lana un umoy da ilabu utdit ladag Jesus. Sadit naisongwata aḻgaw, aḻ-aḻgawa iillongan ot nan-illong da ta siya’d lintog dat Judio. ");
INSERT INTO kmk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Biggabiggat man sit umuna’n aḻ-aḻgaw di sin-dumingguwan ummoy dat babai utdit lobon ot indallay da dat insagana da un bangbangu. ");
INSERT INTO kmk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dintong da un naballinona naiyadayu dit naitubota batu utdit lobon. ");
INSERT INTO kmk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yoong utdit lumnok da, naidon dit ladag Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Gasikadan da un masmasdaaw sidit kakḻata lawa’n nasanikad ud duwa’n laḻaki utdit sog-on da un manilisiling dit badut da. ");
INSERT INTO kmk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gaputa amod dit kimut da, nantumog da yoong kinnanan dat laḻaki kan dida un, “Apay in-innapon yu utdan natoy nat matattaguwan? ");
INSERT INTO kmk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maid situ. Ummungaḻon. Gasmokon yu dit imbagana kan dikayu utdit ininggawana payyan ud Galilea un: ");
INSERT INTO kmk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Sadit Inyanak di Tagu masapula maitod sidat gumabasuḻa tagu, ot mailansa utdit kulus kad umungaḻ sidit maikatlu’n aḻgaw.’ ” ");
INSERT INTO kmk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Utdi, nagasmok dat babai dat ugud Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tinengyan da dit lobon ot ummoy da imbaga’n losan datu utdat kagwampuḻu’t osa un apostoles kan sidat losana buḻun da. ");
INSERT INTO kmk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sadat ummoy nangibaga utdat apostoles, sada Maria Magdalena, Juana kan Maria un inan Santiago kan sadat uduma babai’n buḻun da. ");
INSERT INTO kmk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yoong satu un impadamag da kama nu uḻ-uḻnuga lawa’t dat apostoles ot adida nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yoong si Pedro nanoddak kampay un ummoy sidit lobon. Dumatong man, nanyuk-unga summiim sit daḻom dit lobon yoong abus dit luputa nailukut kan Jesus ullawa’d nailana. Utdi, kaysana masmasdaaw sidit napasamak. ");
INSERT INTO kmk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Utdi payona aḻgaw, duwa’t dat buyut Jesus ud manaddaḻana umoy sin boboḻoy Emaus un umoya simpuḻu ya osa’n kilometro dit kaadayu na manipud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ot bagbagbagaon da dat napaspasamak. ");
INSERT INTO kmk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Utdiya mambagbagbagaan kan man-in-innimusan da un duwa, inummoy si Jesus naidoḻag kan dida’n manaddaḻan. ");
INSERT INTO kmk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naila da yoong adida naimatunan. ");
INSERT INTO kmk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ot kinnanan Jesus kan dida’n, “Ngadan pay nat bagbagbagaon yu un manaddaddaḻan nu?” Utdi, nan-illong da un manduduuy. ");
INSERT INTO kmk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ot sat osa un mangngadan kan Cleofas dit summungbata kanana’n, “Sika ullawa nin tagu’n inummoy Jerusalem un adi nakatigammu utdat napaspasamak sidi utdan kaysana aḻ-aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Ngadan na un pasamak?” kanan Jesus. Summungbat da un, “Sadat napasamak kan Jesus un iNazaret. Osa’n propeta un mannakabalin utdan kingwa kan ugud na utdin sinagung Apudyus kan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yoong intod dat aappun di padi kan pappangat taku un makoddongana mapatoy ot inpailansa da utdit kulus. ");
INSERT INTO kmk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Siya yoong dit nanam-on mi un mangwaya kan ditaku’n kaganakan Israel. On, kan bokona lawa’n siyadi, maikatlu’n aḻgaw naon tu manipud sit napasamakana. ");
INSERT INTO kmk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Osa pay, nasdaawan kami utdat impadamag dat babai’n buḻun mi un inummoy sit lobon na utdit biggabiggat. ");
INSERT INTO kmk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Naid naila da kanu utdit ladag na. Ot nangulin da un kanan dan nakaila da pay kanu si aanghel un nangibaga kan dida un natagu si Jesus. ");
INSERT INTO kmk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Utdi, inummoy dat uduma buḻun mi utdit lobon ot naila da un ustu dit kanan dat babai, yoong maid naila da kan Jesus.” ");
INSERT INTO kmk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Utdi, kinnanan Jesus kan dida’n, “Ay, nangkakunong kayu’n gattok. Sad nasigab yu ud pay un tuttuwaon dat impadtun dat propetan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bokon kada masapula sagapaḻon dit Kristu datuwa ligat asina maawat dit nakaskasdaawa kinangatu?” ");
INSERT INTO kmk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ot impalawag na kan dida dat losana naikanglit sit ugud Apudyus maipanggop kan siya manipud sidat ingkanglit Moses kan dadit losana propeta. ");
INSERT INTO kmk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Utdit dumoḻdoḻdoḻ daon sidit boboḻoya ayan da, nandawos si Jesus un kama nu awad ayana. ");
INSERT INTO kmk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yoong tinagawidan da un, “Nasdomon, inggaw taku ullawa’t tu ta kumḻopon.” Ot ummoy si Jesus nakaigaw kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Utdit nakasangu daona mangan, inaḻan Jesus dit tinapay ot nanluwaḻu’n nanyaman kan Apudyus asina biniibiika intod kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Utdiyon naimatunan da si Jesus yoong kakḻata nabatin kan dida. ");
INSERT INTO kmk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Utdi, kinnanan da un nansungsungbat pay lawan un, “Siya gayam un kama nu naḻangpaw dit gubu ta ud kanad sit man-ipalawagana kan dita utdin daḻan sidat naikanglit un ugud Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Utdi payona olas, nanlakkat da un nangulin Jerusalem ot dintong da un naamung dat kagwampuḻu’t osa’n disipulus kan dat uduma buḻun da. ");
INSERT INTO kmk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ot imbaga da utdat duwa un, “Tuttuwa’n ummungaḻ si Apu ta nampaila kan Simon.” ");
INSERT INTO kmk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ot sadat duwa, impadamag da pay kan dida dit napasamak sidit daḻan kan sadit nan-iimatun da kan Apu utdit namiikana utdit tinapay. ");
INSERT INTO kmk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Utdiya manguḻ-uḻnugan da utdat napasamak, kakḻata lawa’n nasanikad si Jesus kan dida. Kanana kan dida un, “Kapiya din awad kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nakaogyat kan nakakimut da ta kanan da nu banig dit naila da. ");
INSERT INTO kmk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Utdi, kinnanan Jesus kan dida un, “Apay un mabulubulung kan manduwaduwa kayu? ");
INSERT INTO kmk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilan yu datun imak kan datun ikik ot gattoka sakon. Agpadanak daḻapnu mapnok kayu. Ta naid bogas kan tuḻ-ang di banig yoong sakon antu da.” ");
INSERT INTO kmk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Utdiya nangibagaana’t di impaila na dat nalansa un ima kan iki na. ");
INSERT INTO kmk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Adida pay laing makapati gapu’t dit amoda anggom da kan kasdaaw da utdit kinnanan Jesus kan dida un, “Awad mabalina makan situ?” ");
INSERT INTO kmk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ot initdan da si tinunu un ikan. ");
INSERT INTO kmk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inaḻan Jesus dit ikan ot kinan na un iillan da. ");
INSERT INTO kmk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Maabus man imbagana kan dida un, “Sadatu’n napasamak, siya dadit imbagabagak kan dikayu’t dit ininggawak payyan kan dikayu un masapula matungpal dat naikanglita maipanggop kan sakon sidit lintog Moses kan sadat ingkanglit dat propeta kan sidin iblun di Salmo.” ");
INSERT INTO kmk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Utdi, nilawagan Jesus dit somsomok da ot maawatan daon dat ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ot kinnanan Jesus kan dida un, “Sadit naikanglit sidit, kanana un masapula sagapaḻon dit Kristu dan ligat kan mapatoy yoong umungaḻ sit maikatlu’n aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ot masapula maitudtudu utdan losana ili manlugi uttun Jerusalem un maipagapu kan sakon pakawanon Apudyus dan losana mangidadaoli utdan basbasuḻ da. ");
INSERT INTO kmk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Dikayu’d mangustigu utdatu’n naila yu un napasamak kan sakon. ");
INSERT INTO kmk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ot ibaun ku kan dikayu dit Ispiritu Santu un insapatan Amak. Isunga adi kayu umat-atun situn Jerusalem inggana si maawat yu dit pannakabalin un manligwat langit.” ");
INSERT INTO kmk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Utdiyon, inlaksun Jesus dida’d Jerusalem ot makadatong da man utdin Betania ingngatu na dat ima na asina binindisyunan dida. ");
INSERT INTO kmk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Utdit binbindisyunan Jesus dida, maipangpangatu un kaysan langit. ");
INSERT INTO kmk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nandaydayaw da kan siya asida nangulin sin Jerusalem un amoamod dit lagsak da. ");
INSERT INTO kmk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Manipud sidiyon kankanayun da un umoy sit timplu un mandaydayaw kan Apudyus.");
INSERT INTO kmk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Utdit daan payyan ditun lubung nakwa, siguda ininggaw dit Ugud. Sigud un awad kan Apudyus ot satuwa Ugud, Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naisigud kan Apudyus ");
INSERT INTO kmk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ot siya ud pinampaloswan Apudyus sidat losana paloswa. Nu naid, naid gapu pay nakwa utdat losana napaloswa. ");
INSERT INTO kmk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Satu un Ugud, siya ud manligwatan di mataguwan kan siya pay silaw un manilaw si somsomok di tagu. ");
INSERT INTO kmk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kumaddapadda tuwa silaw sidin kakoḻpan ot adin din koḻop mabalinan un kospan. ");
INSERT INTO kmk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Inggaw tagu un imbaun Apudyus un mangngadan kan Juan. ");
INSERT INTO kmk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dummatonga umoy mamanoknok sidat tagu utdit maipanggop sidit silaw daḻapnu losana makagngoḻ sit ipanoknok na, manuttuwa da. ");
INSERT INTO kmk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bokona siya dit silaw nu adi ummoya mangipanoknok sidit silaw. ");
INSERT INTO kmk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sadit kustu un silaw un manilaw sit somsomok di tagu inummoy situn lubung. ");
INSERT INTO kmk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ininggawon situn lubung sidit ot losan datun paloswa uttun lubung siya’d pinangwan Apudyus yoong adin dat tagu binigbig. ");
INSERT INTO kmk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ummoy sit mismu’n ili na yoong adin dat kailiyana inawat. ");
INSERT INTO kmk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yoong sadat losana nangawat kan nanuttuwa kan siya, initdana dida si kalintogan un mambalina aanak Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sat mambalinan da un anak Apudyus, bokona kama’t din gagangaya maiyanakan di tagu onnu kasomsomkan di man-asawa nu adi kasomsomkan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Satuwa Ugud, nambalin si tagu ot iniinggaw kan ditaku’n tagu. Amoamod mangkakaasi na kan kinatuttuwa na. Naila mi dit nakaskasdaaw un kinangatu na, sat nakaskasdaawa kinangatu un inawat na kan Ama na bilang bugbugtunga Anak. ");
INSERT INTO kmk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pinanoknokan Juan dit maipanggop kan siya ot impappakuy na un kanana’n, “Siyatu dit tagu un ug-ugudok sidit kanak un, ‘Awad maitagtagnob kan sakon un nangatngatu nu sakon ta ininggawon sit daan ku payyan maiyanak.’ ” ");
INSERT INTO kmk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ot maipagapu’t dit nalabos un kaasi na, maid mangkigadan din bindisyun un ipooy na kan ditaku’n losana manuttuwa kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Si Moses ud dinutukan Apudyus un nangipatigammu utdat linlintog na ot si Jesu Kristu dit dinutukana un mangipatigammu utdit maipanggop sit mangkakaasi na kan sat tuttuwa un maipanggop kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naid payyan nakaila kan Apudyus, yoong si Jesu Kristu un bugbugtunga Anak na kan taḻona pipiyaona ud nangipatigammu kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nangibaun dat pappangat di Judio un inggaw Jerusalem sidat papadi kan dat Levitas si umoy mangimus kan Juan nu singngadan dit katatagu na. Kama’t tu dit pammanoknok Juan un insungbat na. ");
INSERT INTO kmk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bokona nantuli si Juan nu adi imbabagga na dit tuttuwa un kanana’n, “Bokona sakon dit Kristu.” ");
INSERT INTO kmk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Imbos da un inimus un, “Singngadan nat katatagum nu? Sika si Elias?” Summungbat si Juan un, “Bokonak.” Inimus da payyan un, “Sika dit propetan Apudyus?” Summungbat uman si Juan un, “Bokonak,” kanana. ");
INSERT INTO kmk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ot kanan daon kan siya un, “Singngadan nu nu? Ibagam ud daḻap awad isungbat mi utdan nangibaun kan dikami. Singngadan nat makanam sinat katatagum?” ");
INSERT INTO kmk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sat insungbat Juan sadit impadtun propeta Isaias un kanana’n, “Sakon dit ginga’n mampappakuy sit igawa maid tagtaggauwan un kanana’n, ‘Man-godngon yu dit daḻan un ayon Apu.’ ” ");
INSERT INTO kmk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sadadit uduma tagu’t di, imbaun dadit Fariseo. ");
INSERT INTO kmk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ot inimusan da si Juan un, “Ot koom man bunyagon danat tagu nu bokon ka kan Kristu, bokon ka kan Elias kan bokon ka si propeta nu?” ");
INSERT INTO kmk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Summungbat si Juan un kanana’n, “Bunyagok dikayu si danum yoong annat kan dikayu nat tagu un adiyu tigammu. ");
INSERT INTO kmk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Siya dit maitagtagnob kan sakon un taḻona nangatu ot adiyak maibilang un mangussag sit sandalyas na.” ");
INSERT INTO kmk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nakwa datu ud Betania un ili utdin domang didin wangwang Jordan un nambunbunyagan Juan sidat tagu. ");
INSERT INTO kmk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kabigatana man, nailan Juan si Jesus un dumoḻdoḻdoḻ kan siya. Kinnanana utdat tagu’n ininggaw sidi un, “Siyatuwon dit mauguda Kannelun Apudyus un maidatun daḻapnu mapakawan dat basuḻ dat tagu’t tun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Siya dit ug-ugudok sidit imbagak un, ‘Awad maitagtagnob kan sakon un taḻona nangatu nu sakon ta siguda ininggawon sit daan ku un maiyanak.’ ");
INSERT INTO kmk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Adik tigammu nu singngadan na utdit, yoong antuwak un mamunyag si danum daḻapnu ipatigammuk siya kan dikayu’n kaganakan Israel.” ");
INSERT INTO kmk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ot imbagan Juan dit pammanoknok na un kanana’n, “Utdit binunyagak, nailak dit Ispiritu Santu un nanligwat langit un kama’t kalupati un inumpa kan siya ot iniinggaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Adik tigammu nu singngadan na utdit, yoong si Apudyus un nangibaun kan sakona umoy mangibunyag si danum, siya’d nangibaga kan sakon un, ‘Sadit tagu’n umpaan kan iinggawan dit Ispiritu Santu un dumoba, siya’d mangibunyag si Ispiritu Santu.’ ");
INSERT INTO kmk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nailaka mismu di ot kustiguwak un siya dit Anak Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kabigatana man, ininggaw uman si Juan kan dat duwa’n disipulus na un sumisikad. ");
INSERT INTO kmk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Utdit mailan Juan si Jesus un lumaus kanana un, “Siyatu dit mauguda Kannelun Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nagngoḻ dat duwa’n disipulus dit imbagan Juan ot tinung-ud da si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Man-awing man si Jesus, naila na dida’n maitungtung-ud kan siya ot inimus na un, “Ngadan nat inapon yu?” Summungbat da un, “Kawad nat inggawam, Mistulu?” ");
INSERT INTO kmk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Intaku, ta umoy kayu ilan,” kanan Jesus kan dida. Utdi, naibuḻun da ot innila da dit inggawana. Gaputa nandangwilison nakaigaw da kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andres un sunud Simon Pedro dit osa utdat duwa un naitung-ud kan Jesus sidit nagngoḻan da dit imbagan Juan. ");
INSERT INTO kmk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dagusa ininap Andres si sunud na un Simon ot imbaga na un, “Indasan mi dit Mesias!” Piyaona’n ugudon, Kristu. ");
INSERT INTO kmk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Utdi, indallay na si Simon kan Jesus. Intukkoḻ Jesus si Simon asina kinnanan un, “Sika si Simon un anak ud Juan. Mangadanan ka kan Cefas.” ");
INSERT INTO kmk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mabigat man ingkoddong Jesus dit umoy Galilea. Dumatong man sidi insangkat na si Felipe ot kanana kan siya un, “Maibuyut ka kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe, iBetsaida un siya payon ilin da Andres kan Pedro. ");
INSERT INTO kmk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ummoy pay Felipe ininap si Nataniel ot odasana man kanana kan siya un, “Indasan mi dit tagu un ingkanglit Moses sidat iblun dat linlintog, un siya payon dit ingkanglit dat propeta utdit. Siya si Jesus un iNazaret un abeng Jose.” ");
INSERT INTO kmk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Summungbat si Nataniel un kanana’n, “Mabalin kad un awad nabaḻu si manligwat Nazaret?” “Itan, ta umoy ka ilan,” insungbat Felipe. ");
INSERT INTO kmk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mailan man Jesus si Nataniel un dumoḻdoḻdoḻ kan siya kanana un, “Siyatu tun gattoka kaganakan Israel yoong naid sikap na.” ");
INSERT INTO kmk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Inimus Nataniel kan Jesus un, “Inona’n tigammum sakon?” Summungbat si Jesus un, “Inilak sika utdit ininggawam sidit pong-ad didit kayu’n igus sit daan Felipe un mangayag kan sika.” ");
INSERT INTO kmk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kanan Nataniel un, “Mistulu, sika’d Anak Apudyus! Sika’d Ali uttun Israel!” ");
INSERT INTO kmk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kanan Jesus un, “Manuttuwa ka kad gaputa imbagaka inilak sika utdit pong-ad dit kayu’n igus? Taḻona nakaskasdaaw tu dat mailam nu satu.” ");
INSERT INTO kmk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ot kinnanana kan dida un, “Tuttuwa tun ibagak kan dikayu un maila yun tu din langita maibubukkat kan sadan aanghel Apudyus un ngumatu ya dumoba da un umoy kan sakona Inyanak di Tagu.” ");
INSERT INTO kmk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lumabas man duwa’n aḻgaw, inggaw boda utdin Cana, osa’n ili ud Galilea. Ininggaw dit inan Jesus sidiya amung. ");
INSERT INTO kmk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ot si Jesus kan sadadit disipulus na, naawis da pay. ");
INSERT INTO kmk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Utdit maamin dit basi, ummoy dit inan Jesus imbaga kan siya un, “Naaminan daon si basi!” ");
INSERT INTO kmk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Summungbat si Jesus un, “Paḻungayam nat kook Ina, ta bokona timpuk payyan.” ");
INSERT INTO kmk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Utdi imbagan dit ina na utdat alluwagi un, “Koon yu nu ngadan nat ibaga na kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Awad ugalin dat Judio maipanggop si mambubuḻu, ot ininggaw onoma angang sidi un manlaun si opat onnu onoma lata’n danum dit osa. ");
INSERT INTO kmk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Imbagan Jesus sidat alluwagi un, “Aminon yu un punuwon dan angang si danum.” Ot pinnu da dida. ");
INSERT INTO kmk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Utdiyon kinnanana kan dida un, “Gumaud kayu ta umoy kayu taugan din mangipangat situn amung.” Ot ummoy da tinaugan. ");
INSERT INTO kmk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kapkapana man, bokonon si danum nu adi napiya’n basi. Naid tigammuna’t dit nanligwatan didit basi, yoong tigammun dat ummoy nanaug. Utdi, inayagana dit laḻaki’n mangasawa, ");
INSERT INTO kmk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ot kanana kan siya un, “Ugali taku un umuna’n ipainum taku dit kapiyaana basi ot nu aduwon dit nainum dat sangaili, asi taku ipainum dit naḻamsit. Yoong naisabsabali ka ta insuḻuk nu tun kapiyaana basi asim okaḻon situn anungus na!” ");
INSERT INTO kmk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Satu un kingwan Jesus ud Cana utdin Galilea siya’d pogpoga un nangwaana’t am-amug. Siya’d nangipail-ana utdit nakaskasdaawa kinangatu na ot amo nanuttuwa dat disipulus na kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Maabus man di, kaysan si Jesus ud Capernaum un buḻun na da ina na, sunud na kan dat disipulus na. Ot ininggaw da utdi si piga’n aḻgawa lawa. ");
INSERT INTO kmk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Utdit dandaniyon dit Piyestan di Nalausan dat Judio, ummoy si Jesus ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nadakngana’t dit timplu dadit manlaḻaku’t baka, kannelu kan da kalupati kan dat mansusukat si pilak. ");
INSERT INTO kmk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Utdi, nangaḻa’t lubid si insabid na utdat kannelu ya baka un nangaddag kan dida’t dit lasin. Inwalis na dat pilak dadit mansusukat si pilak asina sinuwakkit inamin dat lamesaan da. ");
INSERT INTO kmk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Imbaga na utdat manlaḻaku’t kalupati un, “Aminon yu un kaanon situ danat! Adiyu mambalinon si laḻakkuwan tun boḻoy Amak!” ");
INSERT INTO kmk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Utdi, nagasmok dat disipulus na dit kanana’t dit naikanglita ugud Apudyus un, “Sat taḻona man-iipotog ku utdit boḻoy nu Apudyus, siya’d mapatoyak.” ");
INSERT INTO kmk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gapu’t di un kingwan Jesus, inimus dat pappangat dat Judio kan siya un, “Ngadan nat maipailama am-amug kan dikami un mangipaila’t dit kalintogama nangwa’t din kama’t di?” ");
INSERT INTO kmk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Summungbat si Jesus un kanana’n, “Yam-anon yu tun timplu ta pasikadok si unus di tuḻu’n aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kanan da kan siya un, “Opata puḻu ya onoma tawon ud nakwaan dituwa timplu, kanama pasikadom si tuḻu’n aḻgawa lawa?” ");
INSERT INTO kmk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yoong sat timplu un ug-ugudon Jesus, sadit long-ag na payon. ");
INSERT INTO kmk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ot utdit ummungaḻ si Jesus un dit natoy, nagasmok dat disipulus na diya imbaga na. Ot taḻona nanuttuwa da utdit naikanglita ugud Apudyus kama pay sit imbagana. ");
INSERT INTO kmk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Utdit ininggawan Jesus sin Jerusalem sit timpun dit Piyestan di Nalausan, adu dat tagu un nanuttuwa kan siya utdit naila da dadit adu’n am-amug un kingwa na. ");
INSERT INTO kmk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yoong bokona intaḻgod Jesus dit long-ag na kan dida, ");
INSERT INTO kmk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","onta tigammu na dit aangson da. Bokona masapul na ud mangibaga kan siya si maipanggop si tagu ta titiggammu na dit somsomok di tagu. ");
INSERT INTO kmk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Inggaw osa un Fariseo un mangngadan kan Nicodemo un osa’n pangat dat Judio. ");
INSERT INTO kmk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sinlabiyan inummoy kan Jesus nakabagbaga un kanana’n, “Mistulu, tigammu mi un sika’d imbaun Apudyus un umoy mantudtudu. Ta maid makakokwa’t am-amug un padan dan koom nu maid si Apudyus kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Summungbat si Jesus un kanana’n, “Tuttuwa tun ibagak kan sika un maid maidagamung sidan iyapuwan Apudyus nu adina yan maiyanak obos.” ");
INSERT INTO kmk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Inyimus uman Nicodemo un kanana’n, “Inona un maiyanak obos nat naotonga tagu? Mabalin kad un umoy mangulin sinat buwang inana daḻap maiyanak obos?” ");
INSERT INTO kmk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Summungbat si Jesus un kanana’n, “Tuttuwa tun ibagak kan sika un, maid makaḻnok sin mangiyapuwan Apudyus nu adina yan maiyanak si danum kan Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sat iyanak di tagu, aangson di tagu dit awad kan siya. Yoong sat maiyanak si Ispiritu, awad pay si Ispiritu Santu kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Adika masdaaw sit imbagak un, ‘Masapula maiyanak kayu’n obos.’ ");
INSERT INTO kmk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","San bayogbog manaddaddaḻan sit piyaona’n manaḻnan. Magngoḻan taku ullawa nat ag-agguwod na yoong maid tigammu taku’t nat kustu’n manligwatana onnu manaḻnana. Padana pay un adi taku tigammu dit koon Ispiritu Santu un mangobos sit aangson di tagu’n maiyanak si Ispiritu.” ");
INSERT INTO kmk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Summan in-inon ditu?” kanan Nicodemo kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Summungbat si Jesus, “Ay! Sika’d mistulun dat kaganakan Israel adim maaw-awatan tu? ");
INSERT INTO kmk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tuttuwa tun ibagak kan sika un sad ibaga mi sadat tigammu mi kan sad ipatigammu mi sadat naila mi, yoong siya payona adi kayu manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ot nu ibagak kan dikayu dan maipanggop sidan makwa’t tun pita yoong adi kayu manuttuwa, summan in-inona’n tuttuwaon yu nu ibagak kan dikayu dan makwa’d langit? ");
INSERT INTO kmk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ta maid osa’t nakaoy langit nu adi sat nanligwata lawa’d langit un Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ot padan dit nangibayugan Moses sit sinan-uḻoga bayong sit disyerto, maibayugak pay un Inyanak di Tagu un mailansa’t kulus, ");
INSERT INTO kmk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","daḻapnu singngadan na mana manuttuwa kan sakon, matagu’t inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gapu’t dit amoda mampipiyan Apudyus sidan tagu’t tun lubung, imbaun na dit bugbugtunga Anak na daḻapnu singngadan na mana manuttuwa kan siya, adina maipadaḻan sin impiyelnu nu adi maitdan si mataguwana maid kigad na. ");
INSERT INTO kmk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta bokona imbaun Apudyus dit Anak na un umoy mangikoddong sit madusaan di tagu uttun lubung nu adi imbaun na un umoy managu kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ot singngadan na mana manuttuwa kan siya, adinaon makodngana madusa, yoong singngadan na mana adi manuttuwa kan siya nakodnganon un madusa, onta adina tuttuwaon dit bugbugtunga Anak Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sat gapun dit mangikoddongana’t dit madusaan dat tagu, inummoyon dit silaw situn lubung yoong amo piniyan dat tagu dit nakoḻop nu sadit napadda gaputa nadadag dat koko-on da. ");
INSERT INTO kmk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ta singngadan na mana nadadag si koko-on, lawengona dit napadda, ot madina umoy umadani’t dit silaw ta adina piyaona maipaila dit nadadaga koko-ona. ");
INSERT INTO kmk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yoong singngadan na man un kustu’t koko-on umoy umadani’t dit silaw daḻapnu nalawaga maila un sadat nabaḻu un koko-ona maiyannatup sit piyaon Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Maabus man di, kaysan da Jesus kan dat disipulus na utdin probinsiya’d Judea. Siya’d ininggawan da un nambunbunyag sidat tagu. ");
INSERT INTO kmk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nambunbunyag pay si Juan sidin Enon un adani’d Salim ta dakoḻ dit danum sidi. Ummoy dat tagu kan siya ot binunyagana dida. ");
INSERT INTO kmk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ta bokon payyana nabaḻud si Juan sidiya timpu. ");
INSERT INTO kmk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kad sidi, inggaw osa’n Judio un nakasinsinnungbat dat disipulus Juan maipanggop sit madaḻusan dat tagu utdat basuḻ da. ");
INSERT INTO kmk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ummoy kan Juan dat disipulus na ot imbaga da un, “Mistulu, sadit tagu’n ummoy kan sika utdin kapon domang didin wangwang Jordan un siyadit kuskustiguwam, andiyon un mambunbunyag ot adu dadin umoy kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Summungbat si Juan un kanana’n, “Naid maawat nat osa’n tagu nu bokona itdon Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Dikayu payon makakustigu utdit imbagaka bokona sakon dit Kristu ta naibaunaka lawa un umun-una utdit daan na un dumatong. ");
INSERT INTO kmk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Padan di boda un sat babai mampooy ullawa’t dit laḻaki’n mangasawa kan siya. Sad alig ku, sadit gayyom dit laḻaki’n mangasawa un umuna’n umoy mangisagana utdat losana masapul sit mangasawaan dit gayyom na. Ot nu dongḻonaon dit gingan dit mangasawa’n laḻaki mantattaḻok. Ot gaputa tigammuk un dummatongon dit Kristu maidon mangkulangan tun taḻok ku. ");
INSERT INTO kmk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Masapula siya’d ngumatngatu’t dayaw ot dumobdoba tun dayaw ku.” ");
INSERT INTO kmk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Sadit tagu’n nanligwat langit siya’d kangattuwan, ot sadit tagu’n doda’n inggaw situn pita, sadat maipasamak situn lap-at pita ullawa’d tigammuna’n bagbagaon. Isunga nangatngatu kan madaydayaw nat tagu’n nanligwat langit. ");
INSERT INTO kmk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sad ibagbaga na, sadat innila na kan dingngoḻ na ud ngatu, yoong akit dat manuttuwa’t dit ibaga na. ");
INSERT INTO kmk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Singngadan na mana manuttuwa kan siya, bigbigona un losana ugud Apudyus, tuttuwa. ");
INSERT INTO kmk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta satuwa imbaun Apudyus, maid udum si ug-ugudona nu adi sat ugud Apudyus gaputa intod na kan siya dit Ispiritu na. ");
INSERT INTO kmk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taḻona pipiyaon Apudyus un Ama tun imbaun na un Anak na, siya’d gapuna un intod na kan siya dat kakigad. ");
INSERT INTO kmk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ot singngadan na mana manuttuwa’t tun Anak Apudyus, awad mataguwana un maid kigad na. Yoong singngadan na mana adi manuttuwa’t tun Anak na, bokona maitdan situwa mataguwan nu adi mannanayun dit manusaan Apudyus kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Utdit matigammuwan Apu Jesus un nagngoḻan dat Fariseo un ad-adu dat maawis na un buyut na kan umoy mampabunyag kan siya nu si Juan, ");
INSERT INTO kmk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ulay bokona si Jesus un mismu dit nambunyag nu adi sadat disipulus na,) ");
INSERT INTO kmk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","tinengyan da ud Judea ot nangulin da ud Galilea. ");
INSERT INTO kmk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sadiya mangulinan da masapula mangoy da ud Samaria. ");
INSERT INTO kmk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kadon, dummatong da utdit ili un Sicar ud Samaria un adani’t dit pitan dit Jacob un impatawid na utdit anak na un Jose. ");
INSERT INTO kmk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sadiya pita dit inggawan dit gubun dit Jacob. Ummoy si Jesus nantupak sit sog-on dit gubun ta amod dit banikoḻ na ta dandaniyona mamatuk. ");
INSERT INTO kmk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Utdi, dummatong tun osa’n babai un iSamaria un umoy mananum. Kanan Jesus kan siya un, “Itdanak ud si inumok.” ");
INSERT INTO kmk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ossaan si Jesus sidit ta ummoy dat disipulus na utdit boboḻoy gummatang si makan. ");
INSERT INTO kmk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nasdaaw dit babai ot kanana un, “Inona’n sika’n Judio, mangkodaw ka si inumom kan sakon un iSamaria?” Siya’d kanana di ta adin dat Judio mangwaan dat iSamaria. ");
INSERT INTO kmk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kanan Jesus uman un, “Nu tigammum nat piyaon Apudyus itdon kan sika kan nu tigammum nu ngadan tun mangkodaw si inumona, sika nat mangkodaw kan siya, kad itdona kan sika dit matattagu’n danum un mangtod si mataguwan.” ");
INSERT INTO kmk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kanan dit babai kan Jesus un, “Apu, naid manggaud nu ta adaddaḻoman tun gubun ot sin mangaḻ-am si danuma mangtod si mataguwan? ");
INSERT INTO kmk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nangatngatu ka kad nu sadit Jacob un ginnapuwan mi? Siya’d nanguḻub situwa gubun ta uminuman da utdat ganak na kan ayam na ot tinawid mi un kaganakana.” ");
INSERT INTO kmk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Summungbat si Jesus un, “Sanat uminum situwa danum mauwaw uman, ");
INSERT INTO kmk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","yoong singngadan na mana uminum sinat itdoka danum, adinaon mauwaw si inggaingga, onta sat danuma itdok mambalina kama’t ob-ob kan siya un adi maobasan ot mangtod kan siya si mataguwana un maid kigad na.” ");
INSERT INTO kmk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Summungbat dit babai un, “Apu, itdanak ud sinata danum daḻap adiyak mauwaw uman kan adikon masapula umoy mananum situ.” ");
INSERT INTO kmk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kinnanan Jesus kan siya un, “Manaḻan ka ta umoy ka ayagan si asawam ot mangulin kayu’t tu.” ");
INSERT INTO kmk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Naid asawak,” kanan didit babai un summungbat. “Kustu nat kanam un naid asawam,” kanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Ta lima dat naasawam ot sanat laḻaki’n kabboḻoy nu uttun satun bokona gattoka asawam ot tuttuwa nat sungbat nu.” ");
INSERT INTO kmk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Summungbat dit babai ot kanana’n, “Apu, mailasin ku utdanat bagbagam un propeta ka. ");
INSERT INTO kmk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sadat ginnapuwan mi utdit, nandaydayaw da kan Apudyus situ un bateled yoong dikayu’n Judio kanan yu un san Jerusalem ud masapula mandaydayawan.” ");
INSERT INTO kmk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kinnanan Jesus kan siya un, “Tuttuwaon yu tun ibagak un dumtong nat timpu un bokona satuwa bateled onnu san Jerusalem dit mandaydayawan dat tagu kan Apudyus un Amak. ");
INSERT INTO kmk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Dikayu’n iSamaria adiyu tigammu nu singngadan na nat mandaydayawan yu yoong dikami un Judio tigammu mi nat daydayawon mi ta manligwat kan dikami’n Judio dit managu. ");
INSERT INTO kmk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yoong dumtong nat timpu, un sinsatunon sadat tuttuwa’n mandaydayaw kan Apudyus un Ama, mandaydayaw da kan siya si ispiritu kan maibasal sit katuttuwaan. Ta siyadi dit mas-oman Apudyus un mandadayaw. ");
INSERT INTO kmk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Apudyus, Ispiritu ot gaputa Ispiritu masapul un sadat mandaydayaw kan siya daydayawon da utdit ispiritu da kan ibasal da utdit katuttuwaan un maipanggop kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kanan dit babai kan siya un, “Tigammuk un awad dumatonga Mesias un mangadanan si Kristu. Ot nu dumatong, ipatigammu na kan ditaku dat losana kakigad.” ");
INSERT INTO kmk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Naid sabali nu adi sakona kabagbagam,” kanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Utdit madama da payyana mambagbagbaga utdit babai, dummatong dat disipulus Jesus. Taḻona nasnasdaaw da ta nadakngan da un makabagbagbaga’t babai si Jesus. Yoong naid nakaimus kan dida nu sin dit piyaon dit babai onnu apay un makabagbagbaga si Jesus kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tinengyan dit babai dit banga un danumana ot kaysan sit boboḻoya ummoy nangibaga’t dat tagu un, ");
INSERT INTO kmk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aweyu, ta ilan yu din tagu’n nangibaga’t dat losana kingkingwak. Siya kad nin dit Kristu?” ");
INSERT INTO kmk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Utdi, kaysan da un losana ummoy sit ininggawan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Utdit daan da payyan dumakngan, imbagan dat disipulus Jesus kan siya un, “Mangan kaon, mistulu.” ");
INSERT INTO kmk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yoong summungbat si Jesus un kanana’n, “Awad makan kan sakon un adiyu tigammu.” ");
INSERT INTO kmk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nampaim-imus da pay lawanon dat disipulus na un, “Awad kad nin nangidatong si kinan na?” ");
INSERT INTO kmk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kanan Jesus sidat disipulus na un, “Sat kanok, sat mangwaak sidat piyaon dit nangibaun kan sakon kan sat mangangputak sit talibasu un intaḻgod na. ");
INSERT INTO kmk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Awad uuggudon yu un, ‘Annat opata buḻanon, aanniyan uman.’ Yoong ibagak kan dikayu, ammaan yu un ilan dan pappayaw, naḻ-umon dan pagoy, aanniyanon. ");
INSERT INTO kmk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sadat man-ani, magun-gunaan da ot sadan tagu’n aniyon da magun-ud da dit mataguwan un maid si kigad. Kadon sadit nammuḻa makapanlagsak pay sidat nan-ani. ");
INSERT INTO kmk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ot tuttuwa dit uguda kanana’n, ‘Mammuḻa nat osa ot sabali nat mangani.’ ");
INSERT INTO kmk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ta ibaun ku dikayu’n umoy mangani utdit adiyu nambannugan. Sabali dat nambannug yoong dikayu dit mangapit.” ");
INSERT INTO kmk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Adu dat iSamaria un nanuttuwa kan Jesus gapu’t dit ugud dit babai un, ‘Imbagana un losan dat kingkingwak.’ ");
INSERT INTO kmk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Siya’d gapuna un utdit inummoy dat iSamaria kan siya, kindaw da un makaigaw yan kan dida. Ot ininggaw kan dida si duwa’n aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ot ummadu dat nanuttuwa kan Jesus gapu’t dat intudtudu na kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ot kanan dat tagu’t dit babai un, “Sinsadin bokonona gapu’t dit imbagam dit manuttuwaan mi, nu adi dingngoḻ mi un mismu dat tudtudu na ot maawatan mi un siya dit umoy managu utdat tagu uttun lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lumabas man dit duwa’n aḻgaw da Jesus Samaria, kaysan da ud Galilea. ");
INSERT INTO kmk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Inummoy sidi ta siya payon dit nangibaga un maid propetan Apudyus si maidayaw sit gattoka boboḻoy na pay lawan. ");
INSERT INTO kmk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dumatong man da Jesus ud Galilea, naanggom dat kailiyana utdit dummakngana, onta ummoy da pay sit Piyestan di Nalausan ud Jerusalem ot naila da dat nakaskasdaawa kingwa na. ");
INSERT INTO kmk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Utdiyon ummoy da uman Cana, un ili ud Galilea un siya’d nampabalinana’t dit danum si basi utdit. Ininggaw osa’n opisyal di gubilnu un masakit dit anak na ud Capernaum. ");
INSERT INTO kmk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dongḻona man un dummatong si Jesus ud Galilea un nanligwat Judea, ummoy kan siya ud nampakpakaasi’n nangibaga un umoy Capernaum ta umoy na papiyaon dit anak na un laḻaki un matmattoyan. ");
INSERT INTO kmk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kad kanan Jesus kan siya un, “Nu adi kayu makaila’t nakaskasdaawa mangilasinan si kook adi kayu manuttuwa.” ");
INSERT INTO kmk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Amo nampakpakaasi dit opisyal un kanana’n, “Apu, umoy ta daan na un matoy din anak ku.” ");
INSERT INTO kmk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kanan Jesus kan siya un, “Manaḻan kaon, matagu din anak nu.” Tinuttuwan dit opisyal dit imbagan Jesus ot kaysan. ");
INSERT INTO kmk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Inggaw man sit daḻan, inyabot dat baba-unona dit damag un kummiyaon dit anak na! ");
INSERT INTO kmk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ot inimus na utdat baba-unona nu kamaan init sit kummiyaan dit anak na ot imbaga da un, “Sat namatuk kaḻabyan dit naidan dit pudut na.” ");
INSERT INTO kmk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ot nagasmok dit opisyal un siya payon dit timpu un nangibagaan Jesus kan siya un kanana’n, “Matagu din anak nu.” Ot siyadiyon ud nanuttuwaan da un simbaḻyan kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Siyadi ud maikagwa’n nakaskasdaawa mangilasinan un kingwan Jesus sidin Galilea un nanligwat Judea. ");
INSERT INTO kmk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Maabus man di, inggaw piyestan di Judio ud Jerusalem ot ummoy si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sadit luwangan sin Jerusalem un aayyon dat kannelu, ininggaw lobong sit sog-on na un oomsan un ngadnon dat Betsata utdin bagbagan di Hebreo. Ot inggaw pay lima’n bawi un iiddungan sidit igid na. ");
INSERT INTO kmk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Adu dadit masakit un gaobogan sidadiya bawi. Awad da ud nakuḻap, napilay kan adi makagidu. Uuwayon da dit manggalibyawan dit danum, ");
INSERT INTO kmk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ta nu udum na umoy dit anghel Apudyus galibyawon dit danum ot sadit makauna’n umoy manlabbung sit manggalibyawana kumiya dit sakit na. ");
INSERT INTO kmk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Inggaw osa’n laḻaki’t di un tuḻumpuḻu’t waḻu’n dagun naona masakit. ");
INSERT INTO kmk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mailan man Jesus di kan tigammuna un nabayagona uumbog, kanana kan siya un, “Piyaom kada gumilog?” ");
INSERT INTO kmk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Summungbat dit laḻaki un, “Apu, nu manggalibyaw din danum gunnaanakon ta maid mangilusong kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Utdi imbagan Jesus kan siya un, “Gumangun ka, lukubom nat obok nu ta manaḻan ka.” ");
INSERT INTO kmk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dagusa gummilog dit laḻaki ot nilukub na dit obok na ot kaysan. Sadiya aḻgaw, aḻ-aḻgawa iillongan di Judio. ");
INSERT INTO kmk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ot kanan dat Judio utdit gummiloga laḻaki un, “Aḻ-aḻgawa Iillongan situn satun ot ipalit dit lintog taku nu awad mangkokwa ot apay binukud nu nat obok nu?” ");
INSERT INTO kmk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","“Sadit tagu’n nampabilog kan sakon, siya’d nangibaga un lukubok tun obok ku ta manaḻanak,” kinnanan dit laḻaki un summungbat. ");
INSERT INTO kmk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ot inimus dat pappangat un, “Singngadan dinat tagu’n nampakwa’t nat?” ");
INSERT INTO kmk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yoong adin dit laḻaki nalasin nu singngadan dit nampabilog kan siya ta adu-adu’n tagu kan kaysanon si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Adina nabayag, naabot Jesus dit laḻaki’t dit timplu ot kanana kan siya un, “Ilam ot gummilog ka. Madimon mambasuḻ ta amangan nu amo nadadagot nat ipasamak nu.” ");
INSERT INTO kmk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Utdi, kaysanon dit laḻaki un ummoy nangibaga’t dat pappangat di Judio un si Jesus dit nampabilog kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ot gaputa aḻ-aḻgawa iillongan dit nangwaan Jesus, siya’d nanlawengan dadit pappangat di Judio kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yoong kinnanan Jesus sidadit Judio un, “Maid man-illongan Amak un mangkokwa ot siya’d padan tun kook.” ");
INSERT INTO kmk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gapu’t tuwa imbagan Jesus, naam-amodota piyaon dat pappangat di Judio un patoyon ta bokona lawa’n sinalungasing na dit lintog da un maipanggop sit aḻ-aḻgawa iillongan nu adi imbaga na paya Ama na si Apudyus un ipadana dit long-ag na kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kadon, kinnanan Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu un sadit Anak, bokona somsomok na pay lawan dat koona, nu adi koona dadit ilana un kokkoon Ama na. Singngadan na mana koon Ama na, siya pay koona. ");
INSERT INTO kmk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta sadit Ama, pipiyaona dit Anak na ot siya’d gapuna un ipaila na un losan kan siya dat koona. Ot ipakwa na kan siya nat amo nakaskasdaawa makwa nu sadatu’n naila yu daḻapnu masdaaw kayu. ");
INSERT INTO kmk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Padan dit mangitdan dit Ama si mataguwan sidat natoy un paungaḻona, itdan pay dit Anak dat losana piyaona’n itdan si mataguwan. ");
INSERT INTO kmk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ot bokona sadit Ama dit mangukum sidat tagu nu adi intod na utdit Anak dit kalintogana mangukum, ");
INSERT INTO kmk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","daḻapnu losana tagu, dayawon da dit Anak un padan pay dit mandadayaw da utdit Ama. Sat adi mandayaw sit Anak, adina dayawon dit Ama un nangibaun kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tuttuwa tun ibagak kan dikayu un singngadan na mana dumngoḻ sidan ugud ku kan manuttuwa utdit nangibaun kan sakon, awad mataguwana un maid si kigad. Adinaon maukum ta nailasat naon si katoy ot maitdan si mataguwan un maid si kigad. ");
INSERT INTO kmk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Tuttuwa tun ibagak kan dikayu un dummatongon nat timpu un sadan natoy magngoḻ da dat ugud Anak Apudyus, ot sadadit dumngoḻ ot manuttuwa, matagu da si inggaingga. ");
INSERT INTO kmk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sadit Ama, siya ud manligwatan di mataguwan ot kingwa na pay dit Anak un manligwatan di mataguwan. ");
INSERT INTO kmk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Intod na utdit Anak dit kalintogan un mangukum sidat tagu gaputa siya dit Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Adi kayu masdaaw situn ibagak un dumatong nat timpu un sadat losana natoy un nailbon magngoḻ da dit gingan dit Anak ");
INSERT INTO kmk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kad umungaḻ da un manligwat sidat lobon da. Sadat nabaḻu si kingkingwa, matagu da si inggaingga ot sadat laweng si kingkingwa, madusa da si inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Intuluy Jesus un kanana’n, “Naid makwak sidit kuwak pay lawan un pannakabalin. Dudumngoḻak kan Ama utdin mangukumak ot kustukustu tun man-uukum ku, onta bokona san piyaok pay lawan din kook nu adi sat piyaon dit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nu sakon pay lawan mangibaga’t dit maipanggop kan sakon, maid manuttuwa’t dit ibagak. ");
INSERT INTO kmk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yoong awad osa un mangipanoknok sit maipanggop kan sakon ot tigammuk un tuttuwa dit ibagbaga na. ");
INSERT INTO kmk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nangibaun kayu’t ummoy kan Juan ot imbaga na dit katuttuwaan. ");
INSERT INTO kmk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bokona masapul ku ud tagu’n mangipanoknok sit maipanggop kan sakon ta ibagak ullawa dit imbagan Juan daḻapnu nu tuttuwaon yu, matagu kayu’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ta si Juan, kama’t silaw un gumilagilab kan napaddapadda ot piniya yu si sin-akitan dit namaddaana kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yoong awad pammanoknok maipanggop kan sakon un amo nalawag nu sat pammanonok Juan. Siya dat nakaskasdaawa kokkook un ipakwan Amak. Dida ud mangipaila un imbaunak kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ot si Amak un nangibaun kan sakon pinanoknokana un mismu dit maipanggop kan sakon. Yoong adiyu magngoḻ dit ginga na kan adiyu maila nu kamaana. ");
INSERT INTO kmk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Adina mansilnad sinat somsomok yu dat ugud na onta adiyu tuttuwaon sakon un imbaun na. ");
INSERT INTO kmk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Adaadaḻon yu dat naikanglita ugud Apudyus ta kanan yu un siya’d makaodasan yu utdit mataguwan yu un maid kigad na. Ot siya danata ugud Apudyus dat mismu un mangibagbaga’t dit maipanggop kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yoong madi yu kampay piyaona umoy kan sakon daḻapnu itdak dikayu si mataguwan un maid si kigad. ");
INSERT INTO kmk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Adik inapon nat mangidayawan di tagu kan sakon ");
INSERT INTO kmk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ta tigtigammuk dikayu. Tigammuk un maid mampipiya yu kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dummatongak un awad kan sakon dit tulay Amak yoong sinumdiyan yu ud sakon. Yoong nu awad dumatong sidit kinatulay na pay lawan, siya’d awaton yu. ");
INSERT INTO kmk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Mandidinnayaw kayu ot bokona gamgaman yu dit pammadayaw un manligwat sidin ossaana Apudyus ot inon yu un manuttuwa kan sakon? ");
INSERT INTO kmk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Adiyu kanan un sakon nat mamabasuḻ kan dikayu kan Amak ta si Moses nat mamabasuḻ kan dikayu. Ta namnamaon yu un taguwon dikayu kan Apudyus sit manuttuwaan yu utdat ingkanglit Moses. ");
INSERT INTO kmk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ot nu tuttuwa’n manuttuwa kayu utdat ingkanglit Moses, manuttuwa kayu kan sakon. Ta sat ingkanglit Moses, sat maipanggop kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yoong nu adiyu tuttuwaon dat ingkanglit na, inon yu un tuttuwaon datun ugud ku?” ");
INSERT INTO kmk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Maabus man piga’n aḻgaw, kaysan da Jesus sit kapon domang din bananaw sidin Galilea un mangngadan pay si bananaw Tiberias. ");
INSERT INTO kmk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aduadu dadit tagu’n naitung-ud kan dida ta innila da dat nakaskasdaawa kingwana un nampapiya utdat masakit. ");
INSERT INTO kmk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dumatong man da Jesus sit domang, nanagada da utdin bateled ot nantupak da. ");
INSERT INTO kmk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sadi un timpu, dandani dit piyestan di Judio un Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Naotap Jesus dat aduadu’n tagu’n dumoḻdoḻdoḻa umoy kan siya ot inimus na kan Felipe un, “Sinnat mangaḻ-an taku’t ipakan sidatu’n tagu?” ");
INSERT INTO kmk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Doda’n tigammunon Jesus dit koona yoong imbagana ullawa di un mamadpadas na kan Felipe. ");
INSERT INTO kmk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Summungbat si Felipe un, “Bokona umanay nat duwa’n gasuta denario un igatang si makan ut ipakan sidanata un-unaya tagu, ulay sin-akikitan da ullawa.” ");
INSERT INTO kmk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Guminga man tun osa un sunud Simon Pedro un si Andres kanana’n, ");
INSERT INTO kmk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Antu’d abeng un nambaḻun si lima’n bukoḻa tinapay kan duwa’n ikan, yoong umanay kad tu un kanon di un-unaya tagu?” ");
INSERT INTO kmk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kinnanan Jesus un, “Mantupakon yu dida.” Kabolbollatan dit inggawan da ot pinantupak da dida’n losan. Sadit bilang dat laḻaki ullawa un inggaw, lima’n libu. ");
INSERT INTO kmk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kadon inaḻan Jesus dat tinapay, ot nanyaman kan Apudyus asina painwaḻas sidat tagu. Padana pay sit kingwa na utdat ikan. Ot nangan dat tagu inggana’t napnok da. ");
INSERT INTO kmk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mabsug da man un losan, kinnanan Jesus sidat disipulus na un, “Sinupon yu dat nabun-an ta adina kaynga.” ");
INSERT INTO kmk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sininup da dit nabun-an ot napnu dit kagwampuḻu’t duwa’n lakba dit buna da un tinapay. ");
INSERT INTO kmk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mailan man dat tagu dit am-amuga kingwan Jesus, “Tuttuwa’n siyatu dit propetan Apudyus un ibaun na uttun lubung,” kanan da. ");
INSERT INTO kmk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yoong matigammun man Jesus un umoy dat tagu aḻan daḻapnu isaad da un ali da, ummoy nampakni utdin bateled un os-ossaan. ");
INSERT INTO kmk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gumidgidam man gummusad dat disipulus na utdit igid dit bananaw. ");
INSERT INTO kmk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ot nanlugan da utdit bangka’n mandoḻmanga mangulin ud Capernaum. Lumabi ullawaon, naid payyan sumaaḻ kan Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Masulsulit man, maḻukuḻukuton dit danum ta nabilog dit bayogbog. ");
INSERT INTO kmk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Utdit inggaw daon sit umoya onoma kilometro dit kaadayu na manipud sit dupit, naila da si Jesus un mangkikkiyang sit lap-at dit danuma dumoḻdoḻdoḻ ot nakakimut da. ");
INSERT INTO kmk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yoong gumminga’t Jesus un, “Adi kayu kumimut ta sakon,” kanana. ");
INSERT INTO kmk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kadon, nataḻok da un nampalugan kan siya’t dit bangka ot dagusa dintong da dit umoyan da. ");
INSERT INTO kmk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Utdit mabigat, sadat tagu’n nataynan sit domang dit bananaw, uuwayon da un ilan si Jesus ta tigammu da un natengyan. Naila da ussiya un ossaan dit bangka ot inaḻan dat disipulus na un nanluganana kaysan yoong naid si Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Inggaw da ud bangka’n nanligwat Tiberias un dummatong sit adani’t dit igawa nanganan da utdit tinapay un impakan Jesus sit naabusa nanyaman kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yoong mailan man dat tagu un naid si Jesus onnu sadat disipulus na utdi, nanlugan da’l lawa payon sidat bangka’n umoy Capernaum un umoy manginap kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Utdit maodasan da si Jesus sin Capernaum un domang dit bananaw inimus da un, “Mistulu, kapiga nat dummatongam situ?” ");
INSERT INTO kmk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kanan Jesus un summungbat un, “Tuttuwa tun ibagak kan dikayu un bokona inapon yu ud sakon gaputa naila yu dat am-amuga kingwak, nu adi gaputa nabsug kayu utdit tinapaya kinan yu. ");
INSERT INTO kmk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Adiyu sad mambannugan din makan un mabangḻos, nu adi sad mambannugan yu, sadin makana mandonoy un mangtod si mataguwana maid kigad na. Ot sakona Inyanak di Tagu ud mangtod kan dikayu uttuwa makan, ta umanamung si Apudyus un Ama kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ot inimus da kan Jesus un, “Ngadan dat piyaon Apudyus ipakwa daḻapnu siya’d koon mi?” ");
INSERT INTO kmk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Summungbat si Jesus kan dida un, “Sad piyaon Apudyus ipakwa kan dikayu, manuttuwa kayu kan sakona imbaun na.” ");
INSERT INTO kmk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ot imbaga da kan siya un, “Ngadan nat am-amuga kooma mangilasinan mi daḻapnu tuttuwaon mi nat ibagbagam? Ngadan na pay nat mabalina koom? ");
INSERT INTO kmk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ta sadat dadakkoḻ taku, nangan da si manna utdit ininggawan da utdit disyerto. Ta kanana’t dit naikanglita ugud Apudyus un, ‘Initdana dida si makan un nanligwat langit.’ ” ");
INSERT INTO kmk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kadon kinnanan Jesus un, “Tuttuwa tun ibagak kan dikayu, bokona si Moses dit nangitod sit makan un nanligwat langit. Si Apudyus un Amak dit mangtod kan dikayu si gattoka makana manligwat langit. ");
INSERT INTO kmk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta sat gattoka makan un itdon Apudyus, siya dit nanligwat langit un mangitod si mataguwan un maid kigad na utdan losana tagu’t tun lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Imbaga da un, “Apu, itdom kan dikami un kankanayun nata makan.” ");
INSERT INTO kmk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Summungbat si Jesus un, “Sakon ud makana mataguwan di tagu. Singngadan na mana umoy kan sakon un manuttuwa adina’n taḻonon mabitil onnu mauwaw. ");
INSERT INTO kmk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Imbagakon kan dikayu utdit un ulay iillanak, adi kayu kampay manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Umoy kan sakon dat itaḻgod Amak un tagu kan sakon. Ot losana umoy kan sakon, adik un taḻon sumdiyan. ");
INSERT INTO kmk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta bokona tinengyak langit un umoy inggaw situn lubunga mangwa’t dit kasomsomkaka osa nu adi sat piyaon dit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ot sad piyaon dit nangibaun kan sakon, ayyuwanak dat intaḻgod na kan sakon daḻapnu maid osa’t mataḻak kan dida kan paungaḻok dida’t din maudi’n aḻ-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta sad gattoka piyaon Amak, losana makaimatun kan manuttuwa kan sakon un Anak na, matagu da si inggaingga ta paungaḻok dida nu maudi’n aḻ-aḻgaw.” ");
INSERT INTO kmk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Utdiyon, nampangonot dat Judio kan Jesus gapu’t dit imbagana un siya dit makan un nanligwat langit. ");
INSERT INTO kmk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ot kanan da un, “Bokon kada siyatu si Jesus un anak da Jose? Tigammu taku da ama kan ina na. Ot inona’n kanana un nanligwat langit nu?” ");
INSERT INTO kmk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Summungbat si Jesus kan dida un kanana’n, “Ustu naon nat ngonongonot yu. ");
INSERT INTO kmk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Naid umoy manuttuwa kan sakon nu adin yan ud Ama un nangibaun kan sakon awisona manuttuwa. Ot sadat manuttuwa, paungaḻok dida nu maudi’n aḻ-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ta sat ingkanglit dat propetan Apudyus sidit un, ‘Losana tagu, suḻuwan Apudyus dida.’ Ot losana dumngoḻ kan manuttuwa’t dit isuḻuna, dida’d umoy kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yoong bokona piyaona’n ugudon un awad nakaila kan Apudyus un Amak. Ta sakona lawa un nanligwat kan Apudyus ud nakaila. ");
INSERT INTO kmk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Tuttuwa’n taḻon tun ibagak kan dikayu un losana manuttuwa kan sakon, matagu’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sakon ud makan un mangitod si mataguwan di tagu. ");
INSERT INTO kmk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sadat dadakkoḻ yu, kinan da dit manna un intod Apudyus sit ininggawan dat dit disyerto yoong bokona nandonoy da ta natoy da payon. ");
INSERT INTO kmk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yoong satun makana ibagbagak, siya’d kustu’n makana nanligwat langit ot nu awad mangan, adinaon matoy nu adi matagu’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ot sakon tun matattaguwana makan un nanligwat langit. Ngadan na mana mangan situwa makan, matagu si inggaingga. Satuwa makan un ug-ugudok, siya tun long-ag ku un itdok daḻapnu matagu dan losana tagu’t tun lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Gapu’t diya imbagan Jesus, nakasuḻag dat Judio ot nansisinnungbatan da pay lawan un kanan dan, “In-inona’n itdon dituwa tagu tun long-ag na ut kanon taku?” ");
INSERT INTO kmk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ot imbagan Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu un, sakona Inyanak di Tagu, inggana’t adiyu kanon tun long-ag ku kan inumon tun daḻak, maid kan dikayu dit mataguwan un maid si kigad. ");
INSERT INTO kmk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Singngadan na mana mangan situn long-ag ku kan uminum situn daḻak, siya’d maitdan si mataguwan un maid kigad na. Ot paungaḻok sin maudi’n aḻ-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta satun long-ag ku, siya’d gattoka makan kan satun daḻak, siya’d gattoka mainum. ");
INSERT INTO kmk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ot singngadan na mana mangan situn long-ag ku kan manginum situn daḻak, adina’d sakon sinaan kan adik pay sinaan. ");
INSERT INTO kmk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Si Amak un matatagu ud nangibaun kan sakon ot matattaguwak maipagapu kan siya. Padana pay sidat mangan kan sakon, ta matagu da maipagapu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sakon dit makana nanligwat langit un bokona kama’t dit kinan dat dadakkoḻ yu un adida nandonoy. Sanat mangan situn long-ag ku, matagu’t inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Siyadatu dat intudtudun Jesus sidit nantudtuduwana’t dit sinagoga utdin Capernaum. ");
INSERT INTO kmk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Utdit nagngoḻan dadit maitungtung-ud kan Jesus dit imbagbaga na, kaaduwan kan dida dit manguguda, “Nasigaba maawatan tun itudtudu na. Ngadan nat mamiya’n dumngoḻ situ nu?” ");
INSERT INTO kmk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Naid nangibaga kan Jesus yoong titiggammu na un mampangonot da utdit intudtudu na ot imbaga na kan dida un, “Apay, madismaya kayu kad sit imbagak? ");
INSERT INTO kmk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Inonaon nu, nu ilan yu ud sakona Inyanak di Tagu un ngumatu’n mangulin sit nanligwatak? ");
INSERT INTO kmk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sat Ispiritun Apudyus ud makaitod si mataguwan, bokona mabooḻan di tagu. Ot sadat ugud un imbagak kan dikayu iyoy da dit Ispiritun Apudyus un mangtod si mataguwan. ");
INSERT INTO kmk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yoong annat da ud adi manuttuwa kan dikayu.” Imbagan Jesus tu, ta siguda tigammu na dadit adi manuttuwa kan siya kan sadit mangituyuk kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ot kanana payyan un, “Siyadi ud gapuna un imbagaka naid mabalina manuttuwa kan sakon nu adin Amak ipalubus.” ");
INSERT INTO kmk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Maipagapu’t tuwa imbagan Jesus, adu dadit nangkadaḻan sidat tagu ot adidaon naitungtung-ud kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Utdi, inimusan Jesus dat kagwampuḻu’t duwa’n disipulus na un, “Piyaon yu kad payon taynan sakon?” ");
INSERT INTO kmk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Summungbat si Simon Pedro un kanana’n, “Apu, sinnat manaḻnan mi? Maid mit udum nu adi annat kan sika dat uguda manligwatan di mataguwana maid kigad na. ");
INSERT INTO kmk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ot sinsadinon manuttuwa kami kan tigammu mi un sika dit Nasantuwan un imbaun Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Summungbat si Jesus un kanana’n, “Adik kad pinili dikayu’n kagwampuḻu’t duwa’n disipulus ku? Yoong annat osa’n diablo kan dikayu!” ");
INSERT INTO kmk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si Judas un anak Simon Iscariote dit ug-ugudon Jesus. Ta osa si Judas sidat kagwampuḻu’t duwa’n disipulus yoong siya’d mangituyuk kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Maabus man di, dinakdak Jesus dat losana boboḻoy sin Galilea. Adina piyaon un umoy Judea ta man-uuwaya lawa dadit pappangat di Judio si gundaway da un mamatoy kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dumoḻdoḻdoḻ man dit piyestan dat Judio un ngadanon dat Piyestan di Sigay, ");
INSERT INTO kmk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","imbagan dat sunud Jesus kan siya un, “Taynam tun Galilea ta umoy ka ud Judea daḻapnu ilan pay dadit buyut nu utdi danat am-amuga kokkoom. ");
INSERT INTO kmk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta nu piyaon nat osa’n tagu un mandinadinamag, masapula adina ilimod dat kokkoona. Ot nu mangwa ka si am-amug, ipailam sidan losana tagu’t tun lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Imbaga da tu, ta ulay dida un sunud na adida manuttuwa kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kinnanan Jesus kan dida un, “Adina payyan dinumtong nat timpuka umoy. Dikayu, mabalin yu nat umoy si kumpolmi’n timpu. ");
INSERT INTO kmk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Onta maid manlaweng kan dikayu, yoong sakon lalawwengonak sidat tagu ta kanayun un ibagabagak un laweng dat koko-on da. ");
INSERT INTO kmk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dikayu ullawa’d umoy makapiyesta. Bokona makaoyak kan dikayu ta bokon payyana dinumtong nat kustu’n timpuk.” ");
INSERT INTO kmk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Imbagana tu utdat sunud na ot nataynan sin Galilea. ");
INSERT INTO kmk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Utdit nangkadaḻan daon dat sunud na un umoy makapiyesta, ummoy pay si Jesus un maid nakaila kan nakatigammu’t dit kaysanana. ");
INSERT INTO kmk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","In-innapon dadit pappangat di Judio si Jesus sidit pipiyestaan un kanan dan, “Kawad na kadnin?” ");
INSERT INTO kmk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mampaagum-um dat tagu maipanggop kan Jesus. Sadat udum kanan da un, “Nabaḻu’n tagu si Jesus.” Yoong sadat udum, kanan da un, “Bokon, ta paḻpaḻmukana’l lawa danat tagu.” ");
INSERT INTO kmk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yoong maid makaituḻoda mambagbaga’t napiya un maipanggop kan Jesus si nadangsoḻa ginga ta kumimut da utdat pappangat di Judio. ");
INSERT INTO kmk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Utdit maikapata aḻ-aḻgaw didit waḻu’n aḻgawa piyesta, ummoy si Jesus nantudtudu’t dit timplu. ");
INSERT INTO kmk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nasnasdaaw dadit pappangat di Judio ot kanan dan, “Sintun nangaḻ-an ditu’t tun laing na, angka ummoy nan-uswila?” ");
INSERT INTO kmk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sumungbat si Jesus ot kanana’n, “Satun itudtuduk, bokona nanligwat si kasomsomkak pay lawana osa nu adi nanligwat sit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nu singngadan nat mamiya un manungpal sinat pakwan Apudyus, matigammuwana nu nanligwat kan Apudyus dat itudtuduk onnu mantudtuduwak sit kabukbukudaka tulay. ");
INSERT INTO kmk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sanat tagu un manudtudu utdit kabukbukudana’n tulay, piyaona’n maidayaw dit long-ag na. Yoong sanat tagu un manginap sit maidayawan dit nangibaun kan siya, siya’d gattoka tuttuwa ot maid tuli kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bokon kada impatigammun Moses dit lintog Apudyus kan dikayu? Yoong maid manuttuwa kan dikayu utdiya lintog ta nu manuttuwa kayu, apay piyaonak patoyon nu?” ");
INSERT INTO kmk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ot kanan dat tagu kan siya un, “Nadimunyu ka! Ngadan pay nat mamatoy kan sikan?” ");
INSERT INTO kmk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Summungbat si Jesus un, “Ossaana am-amug dit kingwak sit aḻ-aḻgawa iillongan ot nasnasdaaw kayu. ");
INSERT INTO kmk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ulay dikayu, mantuḻgi kayu pay ulay nu aḻ-aḻgawa iillongan gaputa imbilin Moses, yoong sat katuttuwaana bokona siya dit nangilugi nu adi sadat dadakkol yu. ");
INSERT INTO kmk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ot nu koon yu dit mantuḻgi ulay nu aḻ-aḻgawa iillongan daḻapnu adina masalungasing dit lintoga tinawid yu, apay nasuḻag kayu utdit nampabilogak sit masakit si aḻ-aḻgawa iillongan? ");
INSERT INTO kmk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Adi kayu man-ukum maibasal sit maila yu ullawa nu adi man-ukum kayu udsi nalintoga wagas,” kanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Dongḻon man dat uduma tagu’n iJerusalem dit itudtudun Jesus kanan da un, “Bokon kada siyatu dit piyaon dat pappangat un patoyon? ");
INSERT INTO kmk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yoong ilan yu kad ot antu’n mantudtudu’t datun adu’n tagu yoong adida mit suganggangon? Tigammun kad ninon datun pappangat un siya dit Kristu? ");
INSERT INTO kmk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yoong bokon kad un nu dumatong dit Kristu maid makatigammu nu sin dit manligwatana? Tigammu taku un losan mit tun nanligwatan ditu un tagu,” kanan da. ");
INSERT INTO kmk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Siyadi dit gapuna un indangsoḻ Jesus dit nantudtudu’t dit timplu un kanana’n, “Kanan yu un tigammu yu ud sakon kan tigammu yu nat nanligwatak. Yoong bokona kasomsomkak pay lawana ossaan tun ummoyak nu adi awad nangibaun kan sakon. Ot satu un nangibaun tuttuwa’n losan dat ibaga na yoong maid tigammu yu kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tigtigammuk ta nanligwatak kan siya ot siya’d nangibaun kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Utdi piyaon da okyan dokmaanon, yoong naid nakatuḻod un nanokma kan siya, onta adina payyan dinumtong dit timpu na. ");
INSERT INTO kmk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yoong adu payon dadit nanuttuwa kan siya ta kanan da un, “Nu dumatong dit Kristu, makakokwa kad nin si ad-adu’n am-amug nu satun kingwan ditu?” kanan da. ");
INSERT INTO kmk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dongḻon man dadit Fariseo dit palpaliw-an dat tagu un ag-agum-umona maipanggop kan Jesus, nangibaun dat aap-apun di padi kan dat Fariseo si suldadu un umoy manokma kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gaputa tigammun Jesus dit panggop da, imbagana utdat kaaduwan un, “Sin-akitana lawaon nat inggawak kan dikayu kadon, mangulinak sit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Inainaponak yoong maid odasan yu kan sakon kan adi kayu makaoy sin igawa manaḻnak.” ");
INSERT INTO kmk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nampaim-imus dadit pappangat di Judio un, “Sin kadnin manaḻnana un adi taku maodasan? Manaḻan kad nin sidan ilin dat Griego un kawadan dat nan-asiwaḻaka buḻun taku ta umoy manudtudu utdan Griego? ");
INSERT INTO kmk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sin din piyaona un ugudon sin kanana’n, ‘Inaponak yoong adiyu ud sakon maodasan kan adi kayu makaoy sin manaḻnak?’ ” ");
INSERT INTO kmk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Anungus aḻ-aḻgaw man didit piyesta un siya’d kapotgana aḻ-aḻgaw, summikad si Jesus sit atubang dat adu’n tagu un nambagbaga si nadangsoḻ ot kanana’n, “Nu singngadan nat mauwaw, dumatong kan sakon ta painumak. ");
INSERT INTO kmk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta kanana’t dit naikanglita ugud Apudyus un, ‘Singngadan na mana manuttuwa kan sakon, man-ayus dit matatagu’n danum manipud sit aangsona.’ ” ");
INSERT INTO kmk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sat ug-ugudon Jesus situwa imbaga na, sadit Ispiritu Santu un umoy inggaw sidat manuttuwa kan Jesus. Yoong adina payyan naitod dit Ispiritu Santu utdiya timpu ta adina payyan napadayawan kan naipangatu’d langit si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Magngoḻ man dat tagu dit imbaga na, kanan dat udum un, “Siya’n tuttuwa tu dit propetan Apudyus!” ");
INSERT INTO kmk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kanan pay dat udum un, “Siyatu dit Kristu!” Yoong kanan dat udum un, “San Galilea kad manligwatan dit Kristu? ");
INSERT INTO kmk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bokon kada kanana’t dit naikanglita Ugud Apudyus un, si Kristu, kaganakan ali David un maiyanak sidin Betlehem un ili un ininggawan ali David sidit?” ");
INSERT INTO kmk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Utdiyon, nagogwa dat tagu ta nanuttuwa dat udum yoong adin dat udum. ");
INSERT INTO kmk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ot piyaon dat udumona dokmaan, yoong naid osa’t nanekgel kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Utdit mangulin dat suldadu, sadat aappun di padi kan Fariseo un nangibaun kan dida inimusan da dida un, “Apay adiyu indatong situ?” ");
INSERT INTO kmk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Summungbat dat suldadu un, “Naid makapada utdin laing na un man-ugud!” ");
INSERT INTO kmk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ot summungbat dadit Fariseo kan dida un, “Naallilaw kayu kad payon kan siya? ");
INSERT INTO kmk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Awad kad tigammu yu utdan pappangat yu onnu Fariseo ut manuttuwa kan siya? ");
INSERT INTO kmk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yoong naigiyaw danata manuttuwa kan siya ta maid tigammu da utdit lintog Moses.” ");
INSERT INTO kmk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yoong si Nicodemo un osa utdat Fariseo un ummoy nakabagbaga kan Jesus sidit, kananana un, ");
INSERT INTO kmk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Utdit lintog taku, maukum kad nat osa un tagu nu adi taku yan dongḻon kan adaḻon nu nakabasuḻ onnu adina?” ");
INSERT INTO kmk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Summungbat da un, “Apay iGalilea ka kad pay? Basaom dit naikanglita ugud Apudyus ot matigammuwam un naid propetan Apudyus si manligwat Galilea.” ");
INSERT INTO kmk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Abuson man dat Fariseo un ugudon di, nangkadaḻan da un losan dat tagu’t dat boboḻoy da, yoong si Jesus kaysan sin bateled Olivo. ");
INSERT INTO kmk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bigbigat man sit mabigat nangulin si Jesus sidit timplu. Adu dat tagu’n nandatdatong un ummoy kan siya ot nantupak si Jesus un dit nantudtudu kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Utdit madama’n mantudtudu, indatong dadit mimistulun di lintog kan Fariseo dit osa’n babai un nakadagdagas ot pinasikad da utdit atubang dat kaaduwan. ");
INSERT INTO kmk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kanan da kan Jesus un, “Mistulu, naodasan tuwa babai un nakadagdagas. ");
INSERT INTO kmk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sigun sit lintog taku un intudtudun Moses, masapul un mabatubatu inggana si matoy, ot sinnat makanam?” ");
INSERT INTO kmk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Imbaga da tu ta piyaon da un sikapan si Jesus tuwan nu makaibaga si makabasuḻana, kad siya’d mangidaḻuman da kan siya. Yoong nanyuk-ung si Jesus un nangangkanglit sit gabu utdit patimmudu na. ");
INSERT INTO kmk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Utdit makaimuimus da, lummunga si Jesus ot kanana’n, “Sat maid si basubasuḻ kan dikayu, siya’d umuna un mamatu kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nanyuk-ung uman si Jesus un nangangkanglit sit gabu utdit patimmudu na. ");
INSERT INTO kmk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Magngoḻ da man dit insungbat Jesus, nasin-ossa da un kaysan un ummun-una dadit lalallakay da, ot sad nataynana lawa da Jesus sidit babai un sumisikad sit sangu na. ");
INSERT INTO kmk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lummunga si Jesus ot kanana’t dit babai un, “Dumman da? Naid kad osa’t nabun-an si manusa kan sika?” ");
INSERT INTO kmk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Naid Apu,” kanan dit babai. Ot kanan Jesus kan siya un, “Bokon paya dusaok sika. Manaḻan ka ot adikaon mambasbasuḻ.” ");
INSERT INTO kmk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Namingsan payyana nambagbaga’t Jesus sidat tagu kanana un, “Sakon silaw dat tagu’t tun lubung. Singngadan na mana umunud kan sakon, adinaon umoy sit nakoḻop ta awadon kan siya dit silaw un mangtod si mataguwan un maid kigad na.” ");
INSERT INTO kmk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Utdi, kanan dat Fariseo kan siya un, “Kustiguwam pay lawan nat long-ag nu, bokona tuttuwa dat ibagbagam.” ");
INSERT INTO kmk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Summungbat si Jesus un, “Ulay nu kustiguwak tun long-ag ku pay lawan, tuttuwa tun ibagak onta, tigammuk tun nanligwatak kan tigammuk tun manaḻnak, yoong dikayu maid tigammu yu si nanligwatak kan manaḻnak. ");
INSERT INTO kmk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sanat man-uukum yu maibasal sit kasomsomkan yu. Yoong sakon bokona mangukumak si tagu. ");
INSERT INTO kmk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ulay nu mangukumak, kustukustu nat man-uukum ku ta bokona lawa’n sakon nu adi duwa kami utdit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sanat lintog yu kanana un, ‘Nu awad duwa’t mangustigu ta man-unud dit ibaga da, tuttuwa dit ibagbaga da.’ ");
INSERT INTO kmk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kustiguwak tun long-ag ku kan kustiguwanak pay kan Ama un nangibaun kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Utdi, kanan da kan siya un, “Kawad Amam nu?” Summungbat si Jesus un, “Naid tigammu yu kan sakon kan naid tigammu yu kan Amak. Nu tigammu yu ud sakon tigammu yu payon si Amak.” ");
INSERT INTO kmk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Imbagan Jesus datu un losan sidit nantudtuduwana’t dit timplu, utdit kuwaltu’n inggawan dit pipissukan di datun. Yoong naid nanokma kan siya ta adina payyan dinumtong dit timpu na. ");
INSERT INTO kmk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Intultuluy Jesus un nambagbaga ot kanana uman kan dida un, “Taynak dikayu. Kadon inapon yu ud sakon yoong adi kayu makaoy sin ayak. Matoy kayu un sibabasuḻ.” ");
INSERT INTO kmk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Utdi, kanan dadit pappangat di Judio un, “Apay, patoyona kad din long-ag na pay lawan ta kanana’n adi taku makaoy sin ayana?” ");
INSERT INTO kmk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kanan Jesus kan dida un, “Nanligwat kayu’t tun pita yoong sakon nanligwatak langit. Satun lubung tun igaw yu yoong san langit din igaw ku. ");
INSERT INTO kmk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ot siya’d gapuna un imbagak un matoy kayu’n sibabasuḻ, ta tuttuwa’n matoy kayu un sibabasuḻ nu adiyu tuttuwaon un sakon, gattoka sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Inimus da un kanan dan, “Singngad kad nat kinatatagum?” Summungbat si Jesus ot kanana’n, “Sakon payon dit imbagak kan dikayu manipud sidit lugin ditu’n mantudtuduwak. ");
INSERT INTO kmk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ot nu maipanggop kan dikayu, adu’n maugud ku un maipabaḻaw kan dikayu. Yoong san ibagaka lawa utdan tagu, sat dingngoḻ ku un imbagan dit nangibaun kan sakon ta losana ibagana tutuwa.” ");
INSERT INTO kmk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yoong adin dat tagu naawatan un sadit ug-ugudona, si Apudyus un Ama na. ");
INSERT INTO kmk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Utdi, imbagan Jesus un, “Nu ibayug yu ud sakona Inyanak di Tagu, matigammuwan yu un sakon dit imbagak kan dikayu kan matigammuwan yu pay un naid kook sit kabukbukudaka tulay nu adi sad ipatigammuk ullawa dit insuḻun Amak kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iinggaw kan sakon dit nangibaun kan sakon, adiyanak taynan ta sad kanayuna kokkook dat mas-omana.” ");
INSERT INTO kmk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ot utdit imbagana tu, adu dat nangngoḻ un nanuttuwa kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Utdi, imbagan Jesus sidat Judio un nanuttuwa kan siya un, “Nu itultuluy yu un tuttuwaon datun ibagbagak, dikayu’d gattoka disipulus ku. ");
INSERT INTO kmk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Matigammuwan yu dit katuttuwaan ot satuwa katuttuwaan dit mangiwaya kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yoong summungbat da un kanan dan, “Kaganakan dikami’t dit Abraham ot naid payyan namuyung kan dikami. Singngadan din piyaoma ugudon sin imbagama mapawayaan kami?” ");
INSERT INTO kmk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Summungbat si Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu un losana gumabasuḻ, puyung di basuḻ. ");
INSERT INTO kmk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sanat anak mannanayuna kamang di pamilya, yoong sanat puyung, bokon. ");
INSERT INTO kmk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ot nu sat Anak ud mangiwaya kan dikayu, gattoka wayawaya kayu. ");
INSERT INTO kmk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tigammuk un kaganakan dikayu kan Abraham, yoong piyaon yu un patoyon sakon gaputa adiyu iptog datun ibagbagak. ");
INSERT INTO kmk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sad ibagak kan dikayu dat maipanggop sit impailan Amak kan sakon, yoong dikayu, sad uunnudon yu dat dingngoḻ yu kan ama yu payon.” ");
INSERT INTO kmk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Summungbat da un, “Sat ama mi, sat Abraham.” Sumungbat pay si Jesus un, “Nu tuttuwa’n ganak dikayu kan Abraham, koon yu dit padan dit kingwana. ");
INSERT INTO kmk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yoong sabali nat koon yu ta piyaon yu ud sakon patoyon gaputa imbagak kan dikayu nat katuttuwaan un dingngoḻ ku kan Apudyus ot bokona siya’d kingwan Abraham nat. ");
INSERT INTO kmk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sad uunnudon yu, sanat koko-on ama yu.” Nakasuḻag da ot kanan da kan siya un, “Bokona aggabak kami, tigammu mi un si Apudyus ullawa’d ama mi.” ");
INSERT INTO kmk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kinnanan Jesus kan dida un, “Nu tuttuwa’n Ama yu si Apudyus, pipiyaonak okyan ta nanligwatak kan Apudyus. Bokona kasomsomkak pay lawana ossaan tun ummoyak situ nu adi si Apudyus un mismu dit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Apay adiyu maawatan datun ibagbagak? Onta adiyu piyaona dongḻon tun ugud ku. ");
INSERT INTO kmk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ganak dikayu kan ama yu un Satanas ot sat piyaona dit tuttuwaon yu. Doda’n kumapatoy manipud sit luglugi na ot adina un taḻon umampayun sit katuttuwaan ta maid gapu’d katuttuwaan kan siya. Nu mantuli, ipaila na din gattoka kinatatagu na ta doda’n matuli ot siya’d puun dit losana kinatuli. ");
INSERT INTO kmk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yoong sakon, ibagak nat tuttuwa ot siya nat adiyu mamatiyan kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Singngadan na kan dikayu ud makapanoknok un nakabasuḻak? Ot nu tuttuwa nat losana ibagak apay adiyu tuttuwaon? ");
INSERT INTO kmk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sadat anak Apudyus, piyaon da un dongḻon din ugud Apudyus. Yoong dikayu, bokona anak dikayu kan Apudyus, siya’d gapuna un adiyu dongḻon nat ugud na,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Summungbat dat Judio un kanan dan, “Bokon kada tuttuwa dit imbaga mi un, iSamaria ka ot nadimunyu ka?” ");
INSERT INTO kmk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Summungbat si Jesus un, “Bokona nadimunyuwak nu adi dayawok si Ama, yoong adiyu dayawon sakon. ");
INSERT INTO kmk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yoong bokona inapok dit madayawak, ta awad osa un manginap sit madayawak un siya dit gattoka ukum. ");
INSERT INTO kmk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ot tuttuwa tun ibagak kan dikayu un, nu singngadan nat mangiyaangosa manuttuwa’t tun ibagbagak, adinaon taḻon matoy.” ");
INSERT INTO kmk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kinnanan dadit Judio kan siya un, “Tuttuwa’n nadimunyuwan ka, ta ammin dan natoy da Abraham sidadit propetan Apudyus, annat kanamota sanat manuttuwa utnat ibagbagam, adinaon taḻon matoy. ");
INSERT INTO kmk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nangatngatu ka kad nu si Abraham un ama mi kan sadat propetan Apudyus un nangkatoy? Ngadan nat kanam sinat long-ag nu?” ");
INSERT INTO kmk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Summungbat si Jesus un, “Naid selbina nu sakon pay lawan mangidayaw situn long-ag ku. Si Amak un Apudyus ud mangidayaw kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Adiyu tigtigammu si Apudyus yoong sakon tigtigammuk. Nu kanaka adik tigtigammu, matuliyak un pada yu. Tigtigammuk ot tuttuwaok dan ibaga na. ");
INSERT INTO kmk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nantattaḻok dit Abraham un ginnapuwan yu ta namnamaona’n maila dit aḻ-aḻgawa dummakngak situ ot naila na siya’d gapuna un nantattaḻok.” ");
INSERT INTO kmk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kinnanan dat Judio un, “Naid payyan limampuḻu’n tawon nu, inona’n nailam si Abraham un naawwe’n natoy?” ");
INSERT INTO kmk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kanan Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu un, utdit daan Abraham maiyanak, awadakon.” ");
INSERT INTO kmk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Magngoḻ man dat Judio di un imbaga na, nan-aknam da utdat batu si ibatu da kan siya yoong nansaḻ-in si Jesus ot lummaksun sidit timplu. ");
INSERT INTO kmk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Namingsan un mangkikkiyang da Jesus, inila na tun osa’n laḻaki’n siguda nakuḻap sit naiyabengana. ");
INSERT INTO kmk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ot inimus dat disipulus na kan siya un, “Sin dit nambasuḻ un gapun din nakuḻapana? Siya pay lawan onnu sadan maḻong-ag na?” ");
INSERT INTO kmk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Summungbat si Jesus un kanana’n, “Bokona maipagapu’t basuḻ na onnu basuḻ dat maḻong-ag na din nakuḻapana, nu adi napasamak daḻapnu maipaila dit pannakabalin Apudyus un mangaan sin kuḻap na. ");
INSERT INTO kmk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Masapula koon taku dat pakwan Apudyus un nangibaun kan sakon ta aḻ-aḻgaw payyan. Ta annat lumabiyon ot maidon mangkokwa. ");
INSERT INTO kmk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yoong inggana’t awadak situn lubung, sakon ud silaw dat tagu’t tun lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Utdit naibaga naon di, nanlugpa’t dit pita ot tinamay na un pinambalin si piyok. Impeket na utdit atan didit laḻaki’n nakuḻap, ");
INSERT INTO kmk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","asina pinadaḻana kanana’n, “Ingkan ta umoy ka mandaḻ-up sin bananaw Siloe,” piyaona’n ugudon tuwa ngadan, Naibaun. Utdiyon, kaysan dit laḻaki’n umoy nandaḻ-up ot nangulin un makailaon. ");
INSERT INTO kmk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mailan man dat kailiyana kan uduma tagu’n nangila kan siya’t dit tumaptappayaana’n mangkodawan, kanan da un, “Bokon kada siyatu dit tumapatapaya’n mangkodaw sidit?” ");
INSERT INTO kmk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kanan dat udum un, “Siya.” Yoong kanan dat udum un, “Bokon, kamugmuging na ullawa.” Gumminga dit laḻaki ot kanana’n, “Sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Inimus da un, “Innon nat kingwam un annat umila kaon?” ");
INSERT INTO kmk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Summungbat dit laḻaki un, “Sadit tagu’n mangngadan kan Jesus, nanamay si gabu utdit lugpana ot impeket na uttun atak asina umoy pinandaḻ-up sakon sin bananaw Siloe. Inummoyak ot sidit maabusak mandaḻ-up makailaakon!” ");
INSERT INTO kmk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Inimus da un, “Sin kawad na nu?” Ot summungbat dit laḻaki un, “Maid tigammuk,” kinnanana. ");
INSERT INTO kmk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Utdi, indallay da dit laḻaki’n napapiya utdat Fariseo, ");
INSERT INTO kmk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ta sadit aḻ-aḻgawa nanamayan Jesus sit piyoka nampapiya na utdit nakuḻap, aḻ-aḻgawa iillongan di Judio. ");
INSERT INTO kmk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ot inimus payon dadit Fariseo utdit laḻaki nu inona’n makailaon ot summungbat un kanana’n, “Pineketana si piyok tun atak asina pinandaḻ-up sakon ot umilaakon.” ");
INSERT INTO kmk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kanan dat uduma Fariseo un, “Sat tagu’n nangwa’t tu, bokona nanligwat kan Apudyus ta adina potgon tun aḻ-aḻgawa iillongan.” Yoong kanan pay dat udum un, “Innon nat osa’n tagu un gumabasuḻ mangwa’t am-amuga kama’t tu.” Utdiyon, nagogwa dadit Fariseo utdit kingwan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kadon, inimus da payyan sit laḻaki un, “Ot singngadan nat maibagam sin kinatatagu na nu ta kanama makaila kaon sit kingwa na kan sika?” “Propetan Apudyus,” insungbat dit laḻaki. ");
INSERT INTO kmk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yoong adin dat pappangat di Judio tuttuwaon un siguda nakuḻap dit laḻaki utdit naiyanakana, inggana’t inayagan da dat maḻong-ag na. ");
INSERT INTO kmk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ot inimus da kan dida un, “Anak yu kad tu? Kanan yu un naisiguda nakuḻap sit naiyanakana ot apay makaila’t tun satun nu?” ");
INSERT INTO kmk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sumungbat dat maḻong-ag na un, “Tuttuwa’n anak mi tu ot tuttuwa’n siguda nakuḻap sit naiyanakana. ");
INSERT INTO kmk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yoong nu inona’n makailaon, siyanat nat naid tigammu mi kan maid pay tigammu mi nu singngadan nat nampapiya kan siya. Imuson yu a kan siya ta naangsan manona ot tigammu na pay lawan nat isungbat na.” ");
INSERT INTO kmk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Imbagan dat maḻong-ag na tu ta umogyat da utdadit pappangat di Judio ta nantutulagan daon un singngadan na mana mangugud un si Jesus, siya’d Kristu makaan sit sinagoga da. ");
INSERT INTO kmk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Siyadi dit gapun dit nangibagaan dat maḻong-ag na utdit, “Naangsanon ot imuson yu kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Utdi, inayagan da uman dit laḻaki’n nakuḻap sidit ot imbaga da kan siya un, “Padayawam si Apudyus ot ibagam nat tuttuwa ta tigammu mi un si Jesus, gumabasuḻ.” ");
INSERT INTO kmk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Summungbat dit laḻaki ot kanana’n, “Maid tigammuk nu gumabasuḻa tagu, yoong sad tigammuk, nakuḻapak sidit ot sinsatun makailaakon.” ");
INSERT INTO kmk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inimus da payyan un, “Ngadan dit kingwa na kan sika nu? Innona’n makaila kaon?” ");
INSERT INTO kmk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Summungbat dit laḻaki ot kanana’n, “Inabus kuwon imbaga yoong adiyu man dongḻona! Ot ngadan nat koon yu payyan imuson? Piyaon yu kadpay mambalin si disipulus na?” ");
INSERT INTO kmk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Utdi, ininsultu da un kanan dan, “Sika’d disipulus na, disipulus dikami kan Moses. ");
INSERT INTO kmk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ta tigammu mi un nakabagbaga’t Apudyus kan Moses yoong nu satu un tagu, maid tigammu mi si nanligwatana!” ");
INSERT INTO kmk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Summungbat dit laḻaki’n kanana’n, “Siyanat nat nakaskasdaaw. Naid tigammu yu si nanligwatana yoong pinapiya na tun atak. ");
INSERT INTO kmk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Doda’n tigammu taku un adin Apudyus dongḻon dat gumabasuḻ yoong dongḻona dat mandayaw kan siya kan mangwa utdan ipakwa na. ");
INSERT INTO kmk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manipud sit luglugin ditun lubung naid payyan nagngoḻ si osa’t nampapiya si tagu’n siguda nakuḻap sit naiyanakana. ");
INSERT INTO kmk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ot nu bokona nanligwat tu un tagu kan Apudyus maid gapu’d makwa na.” ");
INSERT INTO kmk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Summungbat dat Judio un kanan dan, “Gumabasuḻ ka manipud sit naiyanakam ot piyaoma ugudon isuḻum dikami?” Ot pinaḻaksun da utdit sinagoga. ");
INSERT INTO kmk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nagngoḻan Jesus un pinaḻaksun dadit Judio dit nakuḻap ot utdit maila na inimus na un, “Manuttuwa ka utdit Inyanak di Tagu?” ");
INSERT INTO kmk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Summungbat dit laḻaki un, “Ibagam ud Apu, nu singngadan na daḻapnu manuttuwaak kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ot kanan Jesus un, “Inilamon inabus ot maid sabali nu adi siyatun kabagbagbagam.” ");
INSERT INTO kmk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Apu, manuttuwaak,” kanan didit laḻaki ot nandaydayaw kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kinnanan Jesus un, “Inummoyak situn lubung daḻapnu kuisok dat tagu. Ot sadat nakuḻap, pailaok dida ot sadat makaila, ipailak un nakuḻap da.” ");
INSERT INTO kmk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Magngoḻ man dat Fariseo un inggaw sidit sog-on na dit imbagan Jesus, “Nakuḻap kami kad pay?” kanan da. ");
INSERT INTO kmk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Imbagan Jesus un, “Nu tuttuwan nakuḻap kayu, mapakawan dat basuḻ yu yoong gaputa kanan yu un makaila kayu, gasissiya un sibabasuḻ kayu.” ");
INSERT INTO kmk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Inyabalig Jesus un nantudtudu kan dida un kanana’n, “Tuttuwa tun ibagak kan dikayu un, sat tagu’n adi mangoy sit soobana lumnok sit pukuk dat kannelu ta sumakyat sit aḻad, osa’n man-aakaw kan tulisan. ");
INSERT INTO kmk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sat mangoy sit soobana lumnok, siyadi dit man-aayyuwan sidat kannelu. ");
INSERT INTO kmk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Siya’d ibukatan dit mambabantay sit sooban. Ot nu dongḻon dadit kannelu dit ginga na nu ayagana dit ngadan da umoy da kan siya ot ipuyut na un ilaksun dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu mailaksun naon un losan dat kuwa na, ipuyut na dida ot maitungtung-ud dat kannelu na kan siya ta mailasin da dit ginga na. ");
INSERT INTO kmk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nu uduma tagu dit mangayag kan dida, bokona maitung-ud da nu adi gumtik da ta adida mailasin dit ginga na.” ");
INSERT INTO kmk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Satu un inyabalig Jesus kan dida, adida naaw-awatan dit piyaona’n ugudon. ");
INSERT INTO kmk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Utdi, imbagan uman Jesus kan dida un, “Tuttuwa tun ibagak kan dikayu un, sakon dit sooban un ayon di lumnoka kannelu. ");
INSERT INTO kmk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Losan dat ummun-una nu sakon, bokona dida dit kustu’n man-aayyuwan nu adi man-aakaw kan tulisan da. Yoong adin dat kanneluk tinuttuwa dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Sakon dit sooban. Singngadan na mana mangoy kan sakona lumnok, taguwok. Mabalina lumnok onnu lumaksun ot mangdas si manggaḻabana. ");
INSERT INTO kmk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sat panggop dat man-aakaw, umoy da ullawa man-akaw, mampatoy kan manyam-an. Yoong sat panggop ku, umoyak mangitod si mataguwan di tagu un taḻona kapkapnokan da. ");
INSERT INTO kmk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sakon ud nabaḻu’n man-aayyuwan. Sat nabaḻu’n man-aayyuwan, nasasaggana’n mangitod sit katoy na maipagapu utdat ayyuwan na. ");
INSERT INTO kmk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sanat matangdanan un bokona gattoka man-aayyuwan, gumtik nu awad ilana si tanana asu un dumatong onta bokona kuwana dida. Kadon, man-asiwaḻak dadit kannelu nu manikmatan di asu dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Sat gapuna un gumtik nat matangtangdanan, bokona kuwa na dat kannelu ot adina ikasigab dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Sakon sad nabaḻu’n man-aayyuwan. Tigtigammuk si Amak kan tigtigammu na ud sakon. Tigtigammuk dan kanneluk kan tigtigammu da pay sakon. Nasasagganaak un mangitod sit katoy ku maipagapu kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Awad da payyan uduma kanneluk un naid situ un naidagamung. Masapula ayagak dida daḻapnu maidoga da. Dongḻon da pay tun gingak, kadon mambalin da si ossaana bungguy ot ossaan pay dit mangayyuwan kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Pipiyaonak kan Ama ta nasasagganaak un mapatoy daḻapnu mataguwak obos. ");
INSERT INTO kmk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maid makapatoy kan sakon. Sakon pay lawan nat mangipalubus un mapatoy. Kalintogak un mangipalubus sin mapatoyak ot kalintogak pay un matagu obos, ta siya’d imbilin Amak kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Utdi, nagogwa uman dat Judio maipanggop sit imbagan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Adu dat mangibaga un, “Nadimunyuwan ot natiwong. Ot koon taku ullawa’n dongdongḻon nat ibaga na?” ");
INSERT INTO kmk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yoong kanan dat udum un, “Bokona makabagbaga’t kama’t tu nat tagu’n sinakayan di dimunyu. Ona mabalin kad un pailaon nat dimunyu nat nakuḻap?” ");
INSERT INTO kmk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Si timpun di kukummogan, awad piyestan di Judio un mangisomsomkan da utdit naidatunan obos didit timplu utdin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dumtong man diya timpu, inggaw si Jesus un mankikkikkiyang sit balkun dit timplu un mangngadan si Balkun Solomon. ");
INSERT INTO kmk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Awad da ud nandatdatong un Judio kan siya ot kanan da un, “Kapiga nat mangibag-am sinat kustukustu? Nu sika dit Kristu ibagam si nalawag kan dikami.” ");
INSERT INTO kmk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Summungbat si Jesus kan dida un, “Inabus ku un imbaga kan dikayuwon yoong adiyu tuttuwaon. Sadanat kook maipagapu’t dit kalintogaka intod Amak, siya’d mangipanoknok nu singngadan ku. ");
INSERT INTO kmk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yoong adiyu tuttuwaon ta bokon kayu si kanneluk. ");
INSERT INTO kmk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta sadat kanneluk dumngoḻ da utdan ibagak, tigammuk dida ot unudon da ud sakon. ");
INSERT INTO kmk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Itdok kan dida dit mataguwan un maid si kigad ot adidaon maisina kan Apudyus kan naid makapuḻos kan dida kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ta si Amak un nangitod kan dida kan sakon nangatngatu nu sadan losana nangatu ot naid makapuḻos un mangisina kan dida sin mangoognana. ");
INSERT INTO kmk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ta sakon kan si Ama ossaan kami.” ");
INSERT INTO kmk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Utdi, nan-aknam uman dat Judio utdat batu si ibatu da okyan kan siya, ");
INSERT INTO kmk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yoong kanan Jesus kan dida un, “Adu dat napiya’n kingwaka impailak kan dikayu un impakwan Ama ot singngadan na utdatu’n kingwak nat mamatuwan yu kan sakon?” ");
INSERT INTO kmk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Summungbat dadit Judio un kanan dan, “Bokona sanat napiya’n kookoom nat mamatuwan mi kan sika nu adi sanat inugud nu un maisuganggang kan Apudyus kan sanat mangabawama Apudyus ka ta tagu ka ullawa.” ");
INSERT INTO kmk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Summungbat si Jesus kan dida un, “Bokon kada naikanglit sit lintog yu un kanan Apudyus un, ‘Ibagak kan dikayu un aapudyus kayu?’ ");
INSERT INTO kmk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ot tigammu taku un sat ugud Apudyus naid mabaliwana si inggaingga. Nu imbagan Apudyus un aapudyus dat tagu’n nangitdana uttun ugud na, ");
INSERT INTO kmk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","apay ibaga yu un mambagbagaak si laweng un maisuganggang kan Apudyus nu ibagak un Anak na ud sakon? Sakon dit pinili na un imbaun situn lubung. ");
INSERT INTO kmk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu bokon okyan un sad pakwan Ama dan kook siya, adiyu’d sakon tuttuwaon. ");
INSERT INTO kmk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yoong gaputa sad kook dan pakwa na, ulay madi yu ud sakon tuttuwaon, masapula tuttuwaon yu danat kookook daḻapnu manigammuwan kan makaawatan yu un iinggaw si Amak kan sakon ot iinggawak pay kan Amak.” ");
INSERT INTO kmk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Utdi, dokmaan da uman yoong adida naaḻa ta nailisi na dida. ");
INSERT INTO kmk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Utdiyon, kaysan uman si Jesus sidin kapon domang din wangwang Jordan un nambunyagan Juan sidit ot ininggaw sidi. ");
INSERT INTO kmk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Adu dat tagu’n ummoy kan siya ot kanan dan mambabagbaga un, “Naid am-amug si kingwan Juan yoong losana imbaga na maipanggop situwa tagu, tuttuwa da.” ");
INSERT INTO kmk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ot adu dat nanuttuwa kan siya utdi un igaw. ");
INSERT INTO kmk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Utdin Betania un ilin da Maria kan Marta, masakit si Lazaro un sunud da. ");
INSERT INTO kmk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Satun mangngadan si Maria siya payon dit nangiyisig sit nabutilya’n bangbangu utdit ikin Jesus asina pinunasan sit buuk na. ");
INSERT INTO kmk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gapu kad ta masakit si Lazaro, nangibaun da Maria kan Marta un sunud na si umoy kan Jesus ot paimbaga da un, “Apu, masakit si Lazaro un pipiyaoma gayyom nu.” ");
INSERT INTO kmk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yoong dongḻon man Jesus di kanana un, “Bokona ikatoy Lazaro din sakit na ta sadin sakit na napasamak daḻapnu maidayaw si Apudyus kan maipaila pay dit kinangatuk un Anak na.” ");
INSERT INTO kmk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Pipiyaon Jesus dat tuḻu’n mansusunud un sada Maria, Marta kan Lazaro, ");
INSERT INTO kmk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","yoong intantan na payyan si duwa’n aḻgaw sidit nangngoḻana’t dit damag un masakit si Lazaro. ");
INSERT INTO kmk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lumabas man dit duwa’n aḻgaw, kanana’t dat disipulus na un, “Intakun, ta umoy taku uman Judea.” ");
INSERT INTO kmk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Summungbat dat disipulus na un, “Mistulu adina payyan nabayag dit mamiyaan dat Judio un mamatuwan kan sika, kanama mangulin taku uman sidi?” ");
INSERT INTO kmk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Inyabalig Jesus un dit summungbat un, “Bokon kad un kagwampuḻu’t duwa’n olas nat aḻ-aḻgaw? Ot sat kumiyang nu aḻ-aḻgaw adina maidangtuḻ ta mailana dit ayona ta awad dit silaw tun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yoong nu labi nat kumiyangana, maidangtuḻ ta maid dit silaw kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Utdit inabus na un inugud di, impasaḻonson na payyan un kanana’n, “Masusuyop si gayyom taku’n Lazaro yoong takun ta umoyak pukawon.” ");
INSERT INTO kmk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Summungbat dat disipulus na un, “Napiya nu mansussuyop daḻapnu gumilog sooni.” ");
INSERT INTO kmk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kanan da nu tuttuwa’n masusuyopa lawa si Lazaro yoong sat piyaon Jesus gayam ugudon, naabusona natoy. ");
INSERT INTO kmk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ot imbaganon Jesus kan dida ut nalawaga bagbaga un, “Natoyon si Lazaro. ");
INSERT INTO kmk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yoong napiya di ta naidak sin natoyana daḻapnu manuttuwa kayu kan sakon nu paungaḻok. Ot takun ta intaku dakngon.” ");
INSERT INTO kmk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Utdi, kinnanan Tomas un mangadan Pingi utdat buḻun na un, “Maitung-ud taku’n losan kan mistulu daḻapnu maipangkatoy taku kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dumatong man da Jesus sidin Betania, opata aḻgaw naon si Lazaro un nailbon. ");
INSERT INTO kmk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Gaputa umoya lawa’n tuḻu’n kilometro din boḻaat din Betania utdin ili un Jerusalem, ");
INSERT INTO kmk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","adu pay dadit Judio un ummoy nakabuḻbuḻun kan da Maria kan Marta daḻapnu maliwliwa dit angos da utdit natoyan Lazaro un sunud da. ");
INSERT INTO kmk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Magngoḻ man Marta un dumoḻdoḻdoḻ si Jesus, lummaksun un ummoy nangabat kan siya yoong iniinggaw si Maria utdit boḻoy. ");
INSERT INTO kmk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kinnanan Marta kan Jesus un, “Apu nu ininggaw ka ullawa’t tu, adina okyan natoy si sunud ku! ");
INSERT INTO kmk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yoong tigammuk un ulay sinsadin, itdon Apudyus nat losana piyaom kodawon kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Imbagan Jesus kan siya un, “Umungaḻ si sunud yu.” ");
INSERT INTO kmk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Tigammuk un umungaḻ nu umungaḻ dadit losana natoy nu maudi’n aḻ-aḻgaw,” kanan Marta kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Summungbat si Jesus un, “Sakon mampaungaḻ sidan natoy kan mangtod si mataguwan di tagu. Singngadan na mana manuttuwa kan sakon, ulay nu matoy da, matagu da un obos. ");
INSERT INTO kmk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ot singngadan na mana matagu un manuttuwa kan sakon adinaon taḻon matoy, manuttuwa ka utdi?” kanana kan Marta. ");
INSERT INTO kmk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Summungbat si Marta un, “On Apu, tuttuwaok un sika dit Kristu un Anak Apudyus un umoy situn lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Utdit abuson Marta un ibaga di, nangulin kan Maria ot inlimod na un imbaga kan siya un, “Annat dumoḻdoḻdoḻ si Mistulu, ot imuson dika.” ");
INSERT INTO kmk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Magngoḻ man Maria di, lummigwata dagus un ummoy nangabat kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Si Jesus adina payyan nakadatong sit boboḻoy ta ininggaw payyan sit ummoy Marta nangabatan kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ot mailan man dat Judio un ininggaw sit boḻoya mangliwliwa kan Maria un nanggadusa lummaksun si Maria, naitung-ud da pay kan siya ta kanan da nu umoy man-ibil sit lobon. ");
INSERT INTO kmk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Utdit makadatong si Maria utdit ininggawan Jesus, nampalintumong sit atubang na un kanana’n, “Apu, nu ininggaw ka uttu adina natoy si sunud ku.” ");
INSERT INTO kmk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mailan man Jesus si Maria un man-i-ibil padana pay sidat Judio un mampaibil un naitung-ud kan siya, amod dit sigab dit angos na kan nadaguwan kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ot kanana kan dida un, “Kawad dit nangilbonan yu kan siya?” Summungbat da un, “Intaku, ta umoy taku ilan, Apu.” ");
INSERT INTO kmk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nakaibil si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Utdi kanan dadit Judio un, “Ilan yu ot amod din mampipiya na kan Lazaro!” ");
INSERT INTO kmk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yoong kanan dat udum un, “Bokon kada siyatu dit tagu’n nampapiya’t dit nakuḻapa tagu? Ot apay impalubus na un natoy si Lazaro?” ");
INSERT INTO kmk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Utdi, amod uman dit sigab dit angos Jesus un kaysan sit nangilbonan da kan Lazaro un liyanga natubot si dakoḻa batu. ");
INSERT INTO kmk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Imbagan Jesus un, “Kaanon yu nat batu’n naitubot.” Yoong kinnanan Marta un, “Apu, nabuyuk sooni ta maikapata aḻgaw naon tu.” ");
INSERT INTO kmk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kinnanan Jesus kan siya un, “Adik kad imbaga kan sika un, nu manuttuwa ka, mailam dit nakaskasdaawa pannakabalin Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Utdi kinaan da dit tubot didit lobon ot nantangad si Jesus langit un kanana’n, “Yamanok Ama ta dingngoḻ nu ud sakon. ");
INSERT INTO kmk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tigammuk un kankanayuna dodongḻom sakon yoong ibagak tu maipagapu’t datu’n tagu’t tu daḻapnu manuttuwa da un imbaun nu ud sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Abuson man Jesus ibaga di, nampakuya kanana’n, “Lazaro lumaksun ka!” ");
INSERT INTO kmk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Utdi, lummaksun si Lazaro utdit lobon un sissiya dat bugus na un naiputiput sidat ima kan iki na kan nabugus si pangyu dit muging na. Ot imbagan Jesus kan dida un, “Kaanon yu nat bugus na ot palubusan yu un manaḻan.” ");
INSERT INTO kmk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sadat Judio un naibuḻun kan da Maria, innila da dit kingwan Jesus ot kaaduwan kan dida dat nanuttuwa kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yoong sadat udum, ummoy da imbaga’t dat Fariseo dit kingwan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ot sadat aappun di padi kan dat Fariseo, pinandadatdatong da dadit lalallakay da un mangipangat sit simbaan ot kanan dan, “Ngadan nat koon taku? Ta adu dan nakaskasdaawa impailan didi un tagu un am-amug. ");
INSERT INTO kmk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu patungadon taku ullawa, manuttuwa danat losana tagu kan siya kad, umoy dat apu taku’n iRoma yam-anon tun timplu kan ili taku.” ");
INSERT INTO kmk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yoong inggaw osa’n mangngadan kan Caifas un siya’d kangattuwana padi utdiya tawon ot siya’d nangibaga un, “Naid tigatigammu yu! ");
INSERT INTO kmk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Adiyu kad maawatan un unnay nat ossaana tagu un matoy nu sanat mayam-an nat sin-iliyan?” ");
INSERT INTO kmk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bokona nanligwat sit kasomsomkan pay lawan ud Caifas dit imbaga na yoong gaputa siya’d kangattuwana padi utdiya tawon, impadtuna dit matoyan Jesus un mampooy sidat Judio. ");
INSERT INTO kmk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ot bokona lawa’n sadat Judio nu adi matoy daḻapnu man-os-ossaan dadit nan-asiwaḻaka aanak Apudyus sidan nadumaduma’n ili. ");
INSERT INTO kmk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ot manipud sidiya aḻgaw, nantutulagan daon un patoyon si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ot siya’d gapuna un adinon Jesus nampappaila utdat Judio utdin Judea, nu adi kaysan sin Efraim un adani’t din disyerto ot siya’d ininggawan da pati utdat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dandaniyon dit Piyestan di Nalausan ot adu dat tagu’n nanligwat si nadumaduma’n boboḻoy un nanagada ud Jerusalem ta umoy da koon dit kadawiyan da mandadaḻus sit daan dit piyesta. ");
INSERT INTO kmk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Inainapon da si Jesus ot mampaim-imus da utdit mandatdatong da utdit timplu un kanan dan, “Ngadan nat makanan yu? Umoy kadnin si Jesus pay makapiyesta?” ");
INSERT INTO kmk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Imbilin dadit aap-apun di padi kan dat Fariseo utdat tagu un, nu awad makatigammu’t dit inggawan Jesus masapula ipatigammu na kan dida daḻapnu padokma da. ");
INSERT INTO kmk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Utdit inggaw payyan onoma aḻgaw sit daan didit Piyestan di Nalausan, ummoy si Jesus ud Betania un ilin Lazaro un pinaungaḻ na. ");
INSERT INTO kmk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Insaganaan da utdi si kakan si labi. Si Marta dit nansunad ot osa si Lazaro un nakaubung kan Jesus sidit kakakkanan. ");
INSERT INTO kmk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nangaḻa si Maria si kagogwa’n kilu un nangina’n bangbangu un nakwa si natang-il un lanan di nardu. Inyisig na utdit ikin Jesus asina pinunasan sit buuk na ot napnu dit boḻoy sit bangun dit bangbangu. ");
INSERT INTO kmk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yoong si Judas Iscariote un osa’t dat disipulus Jesus un siya dit mangituyuk sit mapatoyan Jesus kanana’n, ");
INSERT INTO kmk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Apay adina ullawa inlaku tuwa bangbangu si tuḻu’n gasut un denario daḻapnu maitod sidan kapus?” ");
INSERT INTO kmk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kanana’l lawa tu un bokona gaputa nakaasi utdat kapus nu adi man-aakaw. Siya’d man-aaggom sit iiggaan dit pilak dat simbungguyan ot akaakawona dat pilaka maigga. ");
INSERT INTO kmk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yoong kinnanan Jesus kan Judas un, “Baybay-am gaputa insuḻuk na tuwa bangbangu daḻapnu saganaona tun long-ag ku un mailbon. ");
INSERT INTO kmk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta sadanat nakapus kanayuna iinggaw da kan dikayu yoong bokona kanayuna inggawak kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Magngoḻ man dat kaaduwana Judio un inggaw si Jesus Betania, ummoy da dintong yoong bokona lawa’n si Jesus dit umoy da ilan ta ulay si Lazaro un dit natoya pinaungaḻ na. ");
INSERT INTO kmk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ot panggop dat aappun di padi un mamatoy pay kan Lazaro, ");
INSERT INTO kmk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta gapu’t dit namaungaḻan Jesus kan siya, adu dadit summina un Judio un nanuttuwa kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kabigatana man, dingngoḻ dat kaaduwana ummoy nakapiyesta un awad si Jesus dumoḻdoḻdoḻa umoy Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Utdi, nanggap-id dat tagu si tubun di muḻa un kama’t iyug un ummoy nangabat kan Jesus ot ipappakuy da un, “Madaydayaw si Apudyus! Bindisyunana tun imbaun na un pannakalong-ag na. Bindisyunana tun Alin di Israel!” ");
INSERT INTO kmk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nangdas si Jesus si ubbun di dangki un siya payon dit tungpal dit naikanglit sit aw-awe un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Dikayu’n tagu’d Sion, adi kayu umogyat ta annata dumatong nat ali yu un nangkabayu si ubbun di dangki.” ");
INSERT INTO kmk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sadat disipulus Jesus, adida naawatan tu utdit nakwaana yoong utdit naipaila dit kinangatu na utdit ummungaḻ kan nangulin langit, asida ullawa nagasmok un naikanglit sit ugud Apudyus dadi un naipasamak un kingwa da kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sadat adu’n tagu un ininggaw kan Jesus sidit namaungaḻana kan namaḻaksunana kan Lazaro utdit lobon na, intultuluy da un nangibaga’t dat kaaduwan maipanggop kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ot gaputa dingngoḻ dat adu’n tagu dit am-amuga kingwa na, aduadu dat ummoy ummabat kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Utdi, nambabagbaga dat Fariseo un kanan dan, “Ilan yu, maid makwa takuwon ta manaḻan dan losanon dan tagu kan siya.” ");
INSERT INTO kmk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Inggaw da pay piga’l lawa’n Griego un ummoy nandaydayaw kan Apudyus sidiya Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ummoy datu un Griego kan Felipe un iBetsaida, osa’n ili ud Galilea ot imbaga da kan siya un, “Apu, piyaon mi pay okyan un ilan si Jesus.” ");
INSERT INTO kmk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ummoy Felipe imbaga kan Andres ot ummoy da un duwaon imbaga kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ot sat insungbat Jesus kanana’n, “Timpu naon daḻapnu maipaila dit nakaskasdaaw un kinangatun dit Inyanak di Tagu. ");
INSERT INTO kmk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tuttuwa tun ibagak kan dikayu. Sat osa’n bukoḻ, adina umadu nu adina maiyosok si pita. Ot kamanu matoy ta maḻbog yoong tumubu asi mamunga’t adu. ");
INSERT INTO kmk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Singngadan na man nat tagu’n mangipotog sit mataguwana’t tun pita, naid ayana nu adi matoy, yoong singngadan na man nat adi mangipotog sit mataguwana uttun lubung maipagapu’t manuttuwaana, matagu’t inggaingga. ");
INSERT INTO kmk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Singngadan na man un manselbi kan sakon, masapula unudonak ot singngadan na mana kawadak, siya pay kawadana. Dayawon Amak nat tagu’n manselbi kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Intultuluy Jesus dit nambagbaga un kanana’n, “Sinsatun mabulungak. Singngadan kadnin ibagak kan Ama? Ibagak kadnin un, ‘Ama, adim ipalubusa sagapaḻok dat ligata dumatong?’ Yoong siya’d gapuna un inummoyak situn pita daḻapnu mansagapaḻak. ");
INSERT INTO kmk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ama, ipailam nat nakaskasdaawa kinangatum dalapnu madaydayaw nat ngadan nu!” Abuson man Jesus ibaga di, inggaw ginga’n nanligwat langit un kanana’n, “Impailak inabus dit nakaskasdaaw un kinangatuk ot ipailak uman.” ");
INSERT INTO kmk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Magngoḻ man dat tagu dit ginga’n nanligwat langit, kanan da nu kummiduḻ. Yoong kanan dat udum un, “Inggaw anghel un nakabagbaga kan siya!” ");
INSERT INTO kmk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kanan Jesus kan dida un, “Bokona mampooy kan sakon dit ginga’n dingngoḻ yu nu adi mampooy kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sinsatun ud timpu’n maikoddongan dit madusaan dat tagu’n gumusuḻ kan sakon situn lubung ot siya pay timpu’n mangabakan Apudyus kan Satanas un pangat situn lubung. ");
INSERT INTO kmk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ot nu maibayugak situn pita, maawis tu dan losana tagu’n manuttuwa kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Satuwa imbagan Jesus piyaona’n ipakaawat sidat tagu nu inon didit mangkakatoy na. ");
INSERT INTO kmk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Summungbat dat tagu un, “Sat naawatan mi utdit lintog, bokona matoy ta mannanayun dit Kristu, ot inona’n ibagam un maibayug dit Inyanak di Tagu? Singngadan dit Inyanak di Tagu nu?” ");
INSERT INTO kmk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kanan Jesus kan dida un, “Annat akita timpu utnat inggawan nat silaw kan dikayu ot unudon yu kigad si iinggaw nat silaw kan dikayu daḻap adi kayu makoḻopan. Ta sanat kumiyang sinat nakoḻop, maid tigammu na si ayana. ");
INSERT INTO kmk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tuttuwaon yu tuwa silaw kigad si iinggaw kan dikayu daḻapnu mambalin kayu un tagun di padda.” Abuson man Jesus ibaga di tinengyana dat tagu ot ummoy sit adida maila. ");
INSERT INTO kmk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ulay nu adu dat impailan Jesus un nakaskasdaawa am-amug sidat tagu, adida nanuttuwa kan siya, ");
INSERT INTO kmk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","daḻapnu matungpal dit paingkanglit Apudyus kan propeta Isaias un, “Apu, singngadan nat nanuttuwa utdat impadamag mi? Singngadan nat nakaawat sit impailam un pannakabalin nu.” ");
INSERT INTO kmk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Siyadi ud gapuna’n adida manuttuwa kan inggaw payyan paingkanglit Apudyus kan propeta Isaias un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kinuḻap Apudyus dida kan pinaboḻang na dit somsomok da daḻapnu adida makaila kan adida makaawat. Adida umoy kan sakon kanan Apudyus, daḻapnu papiyaok dida.” ");
INSERT INTO kmk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Siyatu’d ingkanglit Isaias sidit ta naipaila kan siya dit kinaapudyus Jesus utdit daan na payyan maiyanak ot impatigammun Isaias dit maipanggop kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yoong ulay kama’t di dit imbagan Isaias, adu dat pappangat di Judio un nanuttuwa kan Jesus yoong adida inlatlatak gaputa kumimut da utdadit Fariseo ta amangan nu kaanon da dida’t dit sinagoga da. ");
INSERT INTO kmk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ta sad gamgaman da, sadit mangidayawan dat pada da un tagu kan dida un bokona sadit mangidayawan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Namingsana nantudtuduwan Jesus, indangsoḻ na un nambagbaga’n, “Singngadan na mana manuttuwa kan sakon, bokona sakona lawa’d tinuttuwana nu adi nanuttuwa pay sit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ot singngadan na mana mangila kan sakon maila na pay dit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Dummatongak situn lubung un manilaw sidan losana manuttuwa kan sakon daḻapnu adidaon iinggaw sin kakoḻpan. ");
INSERT INTO kmk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nu awad tagu’t mangngoḻ sidat ibagak ot adina tuttuwaon, bokona sakon mangikoddong sit madusaana ta bokona ummoyak situn pita un umoy mangikoddong sit madusaan dat tagu nu adi, ummoyak daḻapnu taguwok dat tagu’t dit madusaan da. ");
INSERT INTO kmk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Awad mangikoddong sit madusaan dan adi mangawat kan sakon kan adi manuttuwa utdatu’n imbagak. Sadan imbagbagak dat mangikoddonga madusa da nu dumatong dit maudi’n aḻ-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta sadan imbagak, bokona nanligwat sit kuwak pay lawan un tulay nu adi si Apudyus un Amak un siya’d nangibaun kan sakon, imbilin na dat losana ibagak kan itudtuduk. ");
INSERT INTO kmk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ot tigammuk un satu un bilin na siya’d manligwatan di mataguwan un maid kigad na. Siya’d gapuna un sad ibagak ullawa dat imbilin na un ibagak.” ");
INSERT INTO kmk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Inggaw sin-aḻgawa lawaon sit daan didit Piyestan di Nalausan ot tigammun Jesus un dumtongon dit timpu’n manengyana uttun lubung un mangulinana kan Ama na. Amod dit mampipiyana utdat tagu’n nanuttuwa kan siya uttun lubung ot impaila na diya amoda mampipiya na kan dida inggana’t dit natoyana. ");
INSERT INTO kmk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Utdit mangan da Jesus sidiya labi, impasomsomok Satanas kan Judas un anak Simon Iscariote un ituyuk na si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tigammun Jesus un intod Ama na dit losana pannakabalin kan siya. Tigammu na pay un nanligwat kan Apudyus kan mangulin payon kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kadon, lummigwat ot kinaan na dit kagoy na asina inaḻa dit tuwalya asina inggakos sit awak na. ");
INSERT INTO kmk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kinuana dit palangga si danum ot inlugi na un nambuḻu utdat ikin dat disipulus na asina pinunasan sit tuwalya un naigakos sit awak na. ");
INSERT INTO kmk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dakngona man si Simon Pedro kanan Pedro kan siya un, “Apu, sika kad mamuḻu uttun ikik?” ");
INSERT INTO kmk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Summungbat si Jesus un, “Maid payyan tigammum situn kook, yoong maawatam nu timpu na.” ");
INSERT INTO kmk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kinnanan Pedro un, “Adik ipalubusa buḻuwam tun ikik!” Yoong summungbat si Jesus un, “Nu adik buḻuwan nat ikim, bokona maidagamung ka kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Nu siya nat Apu, bokona satun ikika lawa’d buḻuwam nu adi buḻuwam aminon tun imak kan uḻuk,” kinnanan Pedro un dit summungbat. ");
INSERT INTO kmk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Inyabalig Jesus un kanana’n, “Sanat naabusa nan-omos, nadaḻuson ot adinaon masapula mambuḻu nu adi sat iki na ullawa. Losan kayu un nadaḻuson malaksig sinat osa.” ");
INSERT INTO kmk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tigammu naon dit mangituyuk kan siya ot siya’d nangibag-ana utdit, “Nadaḻus kayu’n losan malaksig sinat osa.” ");
INSERT INTO kmk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Utdit inamin Jesus binuḻuwan dit ikin dat disipulus na, nangkagoy obos ot nangulin sidit igaw na utdit kakakkanan ot inimus na un, “Naawatan yu din kingwak? ");
INSERT INTO kmk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ngadnon yu ud sakon si Mistulu yu kan Apu yu ot tuttuwa nat. ");
INSERT INTO kmk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ot nu sakon un Mistulu yu kan Apu yu, binuḻuwak danat iki yu, masapul paya siya’d koon yu un mambibinnuḻu kayu si iki. ");
INSERT INTO kmk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta kingwak di si man-aligan yu, ot koon yu utdan udum din padan din kingwak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ot tuttuwa tun ibagak kan dikayu un naid puyung si nangatu nu sadit apu na onnu naibaun si nangatu nu sat nangibaun kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sinsadinon ta tigammu yu un tuttuwa tun imbagak nagasat kayu nu siya’d koon yu. ");
INSERT INTO kmk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Bokona losan kayu’n disipulus ku tun mangibagaak situ ta tigammuk dikayu’n pinilik. Yoong masapula matungpal dit naikanglita un kanana’n, ‘Sadit buḻun ku un pinakanak siya’d nambalin si kabusuḻ ku.’ ");
INSERT INTO kmk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ibagak kan dikayuwon tu daan na un mapasamak, daḻapnu maipasamak kad, tuttuwaon yu un sakon, gattoka sakon. ");
INSERT INTO kmk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ot tuttuwa tun ibagak kan dikayu un singngadan na mana mangawat sidat ibaun ku awatona’d sakon ot sanat mangawat kan sakon, awatona dit nangibaun kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Abuson man Jesus ibaga di, nasigasigab dit angos na ot imbaga na payyan kan dida’n dit disipulus na un, “Tuttuwa tun ibagak kan dikayu un osa kan dikayu ud mangituyuk kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nampatuktukkoḻ dat disipulus na un naid tigammu da nu singngadan na kan dida dit ug-ugudona. ");
INSERT INTO kmk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sadit disipulus na un taḻona pipiyyaona, siya pay dit naisog-on kan siya utdit nanganan da, ");
INSERT INTO kmk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ot insinyas Simon Pedro utdi un disipulus un imusona kan Jesus nu singngadan na kan dida dit ug-ugudona. ");
INSERT INTO kmk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Utdi, nanselay dit disipulus kan Jesus ot inimus na un, “Apu, singngadan na kan dikami?” ");
INSERT INTO kmk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Summungbat si Jesus un kanana’n, “Sanat tagu’n mangitdak situn tinapay un sinanong ku, siya’d mangwa.” Inaḻan Jesus dit osa’n tinapay ot sinanong na asina intod kan Judas un anak Simon Iscariote. ");
INSERT INTO kmk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aḻan man Judas dit tinapay, sinakayanon Satanas ot kinnanan Jesus kan siya un, “Ikanon ta ikamum koon nat koom!” ");
INSERT INTO kmk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yoong naid nakaawat kan dida’n dit buḻun na un nangan nu sin dit koon Jesus ullawa’n imbaga di kan Judas. ");
INSERT INTO kmk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kanan dat udum nu imbaun Jesus ullawa’n umoy gumatang sidat masapul da utdit piyesta, onnu ibaun na un umoy mangtod si tuḻung da utdat kapus, ta si Judas dit nangaggom sit pilak dan dit simbungguyan. ");
INSERT INTO kmk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Utdit abuson Judas awaton dit tinapay, dagusa lummaksun ot kaysan. Labiyon sit kaysanana. ");
INSERT INTO kmk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Malisgud man si Judas imbagan Jesus kan dida un, “Satuwon sad timpu un maidayawak un Inyanak di Tagu. Ot timpu payon un maidayaw si Apudyus maipagapu utdan maipasamak kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ot nu maidayaw si Apudyus maipagapu kan sakon, adina mabayag maidayawak pay maipagapu kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Dikayu un aanak ku, sin-akitana lawa nat inggawakon kan dikayu ot inaponak, yoong ibagak kan dikayu, padan dit imbagak sidat Judio utdit un, ‘Adi kayu makaoy sin manaḻnak.’ ");
INSERT INTO kmk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Satu’d bagu’n ibilin ku kan dikayu, mampipinniya kayu. Nu kamaan dit mampipiyak kan dikayu masapul paya siya’d padan nat mampipinniyaan yu. ");
INSERT INTO kmk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nu mampipinniya kayu, siya’d manigammuwan dat losana tagu un dikayu’d disipulus ku.” ");
INSERT INTO kmk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Inimus Simon Pedro kan Jesus un, “Sinnat ayam, Apu?” Summungbat si Jesus un kanana’n, “Adika makaoy situn satun sinat ayak, yoong maitung-ud ka nu timpu na.” ");
INSERT INTO kmk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kanan Pedro un, “Apu, apay un adina mabalina maibuḻunak kan sika’t tun satun? Itdok tun katoy ku maipagapu kan sika!” ");
INSERT INTO kmk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Summungbat si Jesus un, “Tuttuwa kad un itdom nat katoy nu maipagapu kan sakon? Tuttuwa tun ibagak kan sika un, daan din manuk manullauk, mamitlu’n isulib nu un naid tigammum kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Imbagan payyan Jesus sidat disipulus na un, “Adi kayu madanagan, manuttuwa kayu kan Apudyus ot manuttuwa kayu pay kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adu’n makgawan sin kawadan Amak. Nu bokona tuttuwa tu, adik imbaga un maunaak un umoy mangisagana’t inggawan yu. ");
INSERT INTO kmk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ot nu maisaganak, mangulinak ta umoyak aḻan dikayu daḻapnu singngadan na man un awadak, awad kayu pay. ");
INSERT INTO kmk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ot tigammu yuwon nat daḻana umoy sin manaḻnak?” ");
INSERT INTO kmk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Utdi imbagan Tomas kan siya un, “Apu, maid tigammu mi utnat manaḻnam ot inona’n matigammuwan mi dit daḻan?” ");
INSERT INTO kmk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Summungbat si Jesus un, “Sakon ud daḻan, katuttuwaan, kan mataguwan. Maid makaoy kan Amak nu adina mangoy kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu natigammu yu ud sakon natigammu yu payon si Amak. Ot gaputa tigammu yuwon sakon, tigammu yu kan naila yu payon si Amak.” ");
INSERT INTO kmk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Imbagan Felipe un, “Apu, ipailam ud kan dikami si Amam, ta nu maila mi mapnok kamiyon.” ");
INSERT INTO kmk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Summungbat si Jesus un, “Felipe, nabayagakona iniinggaw kan dikayu naid payyan tigammum kan sakon? Losana nangila kan sakon naila da pay si Amak. Inona’n kanam payyana ipailak si Amak? ");
INSERT INTO kmk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Adim kad tuttuwaon un iinggawak kan Amak ot iinggaw pay si Amak kan sakon? Ot losana ibagak kan dikayu, bokona nanligwat sit kuwak pay lawana tulay. Si Ama un iinggaw kan sakon, koona dan losana kasomsomkana. ");
INSERT INTO kmk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Manuttuwa kayu’t tun ibagak un, iinggawak kan Ama ot si Ama iinggaw pay kan sakon. Yoong nu adiyu tuttuwaon tu un imbagak, sad manuttuwaan yuwon dat naila yu un kingkingwak. ");
INSERT INTO kmk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tuttuwa tun ibagak kan dikayu un, sanat manuttuwa kan sakon, mabalin na pay koon dit padan dat am-amuga kook. Sat katuttuwaana ad-adu pay dat koona nu sadat kingwak ta manaḻanak kan Amak ot ");
INSERT INTO kmk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","losana kodawon yu maipagapu’t dit manuttuwaan yu kan sakon, itdok dida daḻapnu maipaila un lobbong na un madaydayaw si Ama gapu utdan kook un Anak na. ");
INSERT INTO kmk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Itdok dan losana kodawon yu kan sakon nu kodawon yu maipagapu’t dit manuttuwaan yu kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nu pipiyaon yu ud sakon tuttuwaon yu dat bilin ku. ");
INSERT INTO kmk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ot kodawok kan Amak ta mangibaun si Katuḻungan yu un maisukat kan sakon un iinggaw kan dikayu si inggaingga. ");
INSERT INTO kmk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Satun ibaun na, siya si Ispiritu Santu un mangipatigammu’t dan losana katuttuwaan, yoong sadat tagu’t tun lubung, adida maawat si Ispiritu Santu ta adida maimatunan kan adida tigtigammu. Yoong tigtigammu yu si Ispiritu Santu ta bokona sumina kan dikayu, kanayuna iinggaw kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Adik dikayu ulilaon ta ulay nu manaḻanak, mangulinak payon kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Adina mabayag adiyakon maila utdat tagu’t tun lubung. Yoong dikayu maila yu payon sakon, ot gaputa mataguwak matagu kayu pay. ");
INSERT INTO kmk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nu dumatong di un timpu matigammuwan yu un sakon, iinggawak kan Amak, dikayu iinggaw kayu kan sakon un padan nat iinggawak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Sanat umawat kan tumuttuwa utdan bilin ku siya’d mamippiya kan sakon ot sat mamippiya kan sakon pipiyaon pay Amak, padana pay kan sakon ta pipiyaok ot ipatigammuk pay kan siya nat maipanggop kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Utdi, kinnanan Judas, un bokon kan Judas un Iscariote, un, “Apu, apay un dikami ullawa’d mangipatigammuwam sinat maipanggop kan sika un bokona utdat losana tagu’t tun lubung?” ");
INSERT INTO kmk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Summungbat si Jesus un, “Nu pipiyaonak sinat osa’n tagu, tuttuwaona dat ibagbagak. Pipiyaon Amak ot dikami kan Ama, umoy kami inggaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Singngadan na mana adi mamippiya kan sakon, adina tuttuwaon dat ibagbagak. Ot sadatu’n uguda dingngoḻ yu kan sakon, bokona kasomsomkak pay lawana osa nu adi nanligwat kan Amak un nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Imbagak datu uttun iinggawak payyan kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yoong sadit Katuḻungan yu un si Ispiritu Santu, ibaun Amak gaputa kodawok un ibaun na ot siya’d mangitudtudu kan dikayu’t dat losana banag. Siya pay mangipalagip utdat losana imbagak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kapiya ud ibanat ku kan dikayu. Satun kuwaka kappiya tun itdok kan dikayu. Bokona kama’t dit kappiya un manligwat situn lubung tun kappiya un itdok. Adi kayu mandandanag kan kumimut. ");
INSERT INTO kmk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Dingngoḻ yu dat imbagak kan dikayu un manaḻanak yoong mangulinak. Nu pipiyaonak kan dikayu, mataḻok kayu ta manaḻanak kan Ama un nangatngatu nu sakon. ");
INSERT INTO kmk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Imbagak kan dikayu datu daan da un mapasamak daḻapnu nu mapasamak da, manuttuwa kayu. ");
INSERT INTO kmk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Maid andu si makabagbagaakon kan dikayu ta annat dummatongon si Satanas un apun dat tagu’t tun lubung. Maid mabalin dit pannakabalin na kan sakon, ");
INSERT INTO kmk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","yoong ipalubus ku ullawa nat koona daḻapnu ilan dat tagu un pipiyaok si Apudyus un Amak ot tungpaḻok nat losana pakwana.” “Intakunon!” kinnanana utdat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Inyabalig Jesus un kanana’n, “Sakon dit kustu’n puun di ubas ot si Amak siya’d mangayyuwan. ");
INSERT INTO kmk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ot sadat sangak un adi mamunga, kaanona dida yoong sadat mamunga salingsingana’n daḻusan dida daḻapnu umad-adu dit ibunga da. ");
INSERT INTO kmk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nadaḻusan kayuwon sidat uguda imbagak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Adi kayu sumina kan sakon ot adiyak pay sumina kan dikayu. Ta adi kayu makabunga nu maisina kayu kan sakon un padan dit sanga nu maisina’t dit puun. ");
INSERT INTO kmk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Sakon dit kustu’n puun dit ubas ot dikayu pay dat sanga. Sat adi sumina kan sakon kan adiyak pay sumina kan siya, siyadi dit mamunga’t adu. Ta maid gapu ud makwaan nat tagu un maisina kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sat tagun sumina kan sakon, maidawat un kama’t dat sanga un nakaan sidat puun da ot maḻangu da kad, mauḻmung da asi maisubba’t dit apuy daḻapnu masgob da. ");
INSERT INTO kmk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nu adi kayu sumina kan sakon kan mansilnad dat ugud ku kan dikayu, ulay nu ngadan nat kodawon yu kan Apudyus maitod kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Siya’d maidayawan Amak, nu mamunga kayu’t adu ot siya pay mangipaila un tuttuwa’n disipulus ku dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pipiyaok dikayu un padan dit mampipiyan Ama kan sakon, adiyu sinaan tun mampipiyak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu tuttuwaon yu dat bilin ku, adi kayu maisina uttun mampipiyak, padan dit manuttuwaak sidat bilin Amak ot adiyak pay maisina utdit mampipiya na. ");
INSERT INTO kmk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Imbagak datu kan dikayu daḻapnu satun taḻok ku awad kan dikayu kad maid mangkulangan nat taḻok yu. ");
INSERT INTO kmk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Siyatu’d bilin ku kan dikayu, mampipinniya kayu un padan dit mampipiyak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maid amod si mampipiya ut ipailan di osa’n tagu nu adi sat mangibadosana utdit long-ag na un maipooy sidat gagayyom na. ");
INSERT INTO kmk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dikayu’d gagayyom ku nu tuttuwaon yu dat bilin ku. ");
INSERT INTO kmk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Adikon ibilang dikayu un baba-unok ta sanat mauguda baba-unon, adina tigammu dit inggaw sit somsomok apu na. Yoong ibilang ku dikayu un gagayyom ku ot impatigammuk kan dikayu dat losana dingngoḻ ku kan Amak. ");
INSERT INTO kmk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bokona dikayu nat namili kan sakon nu adi sakon namili kan dikayu ot imbaun ku dikayu un umoy kan mamunga’t adu un bunga’n mandonoy. Ot nu siyadi ud koon yu, itdon Ama dat losana kodawon yu maipagapu’t dit manuttuwaan yu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ot satu’d bilin ku kan dikayu, mampipinniya kayu.” ");
INSERT INTO kmk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Intuluy Jesus un, “Lawengon dikayu’t dan tagu’t tun lubung yoong somsomkon yu un linaweng da un inuna’d sakon. ");
INSERT INTO kmk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu osa kayu utdat tagu’t tun lubung, pipiyaon da dikayu. Yoong gaputa pinilik dikayu, bokon kayuwon si buḻun da, siya’d gapuna’n lalawwengon dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sosomkon yu dit imbagak kan dikayu un, ‘Naid nangatngatu’t baba-unon nu sat apuwona.’ Ta nu pinaligat da ud sakon, paligaton dikayu pay. Nu awad nanuttuwa utdat intudtuduk, tuttuwaon da pay danat itudtudu yu. ");
INSERT INTO kmk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yoong gaputa manuttuwa kayu kan sakon koon da datu un ligat kan dikayu ta maid tigammu da utdit nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bokon okyana kabasuḻan da nat adida manuttuwaan kan sakon nu adiyak inummoy nantudtudu kan dida. Yoong gaputa nantudtuduwak kan dida maid lasun daon sin adida manuttuwaan kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Singngadan na mana manadag kan sakon dadagona pay si Amak. ");
INSERT INTO kmk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nu naid okyan inila da utdat nakaskasdaawa kingwak un maid udum si makakwa, bokon okyana kabasuḻan da. Yoong inila da, ot lalawwengon da dikami kampay kan Amak. ");
INSERT INTO kmk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ot maipasamak datu ta siya’d tungpal dit ugud un paingkanglit Apudyus sidit lintog da un kanana’n, ‘Dinadagak un naid gapugapuna.’ ");
INSERT INTO kmk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nu dumatong dit Katuḻungan yu un ibaun ku un manligwat kan Amak, un siya dit Ispiritu Santu un manligwatan di losana kinatuttuwa, siya’d mamanoknok sit maipanggop kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ulay dikayu, panoknokan yu pay nat maipanggop kan sakon ta manipud sit damu’n nanudtuduwak naibuḻubuḻun kayuwon kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ibagaka losan datu kan dikayu daḻapnu adiyu lipsutan nat pammati yu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ta kaanon dikayu utdan sinagoga. Ot dumtong nat timpu un mamatoyan da kan dikayu ta kanan da un naselbi kan Apudyus nat mamatoyan da kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Koon da datu kan dikayu ta maid tigammu da kan sakon kama pay kan Ama. ");
INSERT INTO kmk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yoong imbagak kan dikayu datu ta dumtong kad nat timpu un mapasamakan da, magasmok yu un imbagak dida kan dikayu.” “Adik indaddaan un imbaga kan dikayu datu utdit damu ta iniinggawak payyan kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sinsadinon, mangulinakon kan Amak un nangibaun kan sakon, yoong maid mangalikagum kan dikayu un mangimus nu sin dit manaḻnak. ");
INSERT INTO kmk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sinsatun ta imbagak kan dikayu, manduduuy kayu. ");
INSERT INTO kmk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yoong ibagak kan dikayu nat kinatuttuwana un mangkapiyaan yu nat manaḻnak. Ta nu adiyak ud manaḻan, bokona umoy dit Katuḻungan yu. Yoong nu manaḻanak ibaun ku kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nu dumatong, panoknokana utdat tagu’t tun lubung un bokona kustu dit kasomsomkan da maipanggop si basuḻ, kinalintog kan sat mangukuman Apudyus. ");
INSERT INTO kmk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Panoknokana un bokona kustu dit kasomsomkan da maipanggop si makabasuḻan di tagu, ta nakabasuḻ da gapu’t dit adida manuttuwaan kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Panoknokana un bokona kustu dit kasomsomokan da maipanggop sit kinalintog ta mangulinak kan Amak ot siya’d anungus mangil-an yu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Panoknokana un bokona kustu dit kasomsomkan da maipanggop si mangukuman Apudyus, ta naukumon si Satanas un apun dat tagu uttun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Adu payyan danat piyaoka ibaga kan dikayu, yoong tigammuk un adiyu payyan kabooḻana maawat situn satun. ");
INSERT INTO kmk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yoong nu dumatong si Ispiritu Santu, siya’d mangipuyut kan dikayu utdit manigammuwan yu utnat losana katuttuwaan. Ta losana ipatigammu na, bokona manligwat sit kuwana pay lawana tulay, nu adi ibagana dat dingngoḻ na kan Apudyus. Ot ibaga na pay dat maipasamak nu mandinonyana. ");
INSERT INTO kmk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Idayaw na ud sakon, ta losan dan manligwat kan sakon dat ibaga na kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Losana awad kan Amak, awad pay kan sakon ot siya’d gapuna un imbagak kan dikayu’n losan dan manligwat kan sakon dat ibaga na kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Bokona mabayag, adiyuwon maila’d sakon, yoong adina uman mabayag ilan yu ud sakon payyan,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Utdi, nampaim-imus dat uduma disipulus Jesus un kanan dan, “Ngadan din piyaona’n ugudon sin kanana’n, ‘Adina mabayag adiyu maila’d sakon, yoong adina uman mabayag ilan yu ud sakon payyan?’ Kan imbagana pay un, ‘Ta manaḻanakon kan Amak.’ ” ");
INSERT INTO kmk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kanan da un, “Ngadan din piyaona’n ugudon din kanana’n, ‘Adina mabayag?’ Maid tigammu taku nu ngadan din piyaona’n ugudon.” ");
INSERT INTO kmk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gaputa tigammun Jesus un piyaon da un imuson kan siya nu ngadan dit piayona’n ugudon, kinnanana kan dida un, “Sad mampaim-imusan yu kad din imbagak un, ‘Adina mabayag adiyu maila’d sakon, yoong adina pay mabayag ilan yu ud sakon payyan?’ ");
INSERT INTO kmk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tuttuwa tun ibagak kan dikayu un, ibilan kan lamatan yu nat mapasamak kan sakon nu dumtong dit timpu, yoong mataḻokan dat tagu’t tun lubung. Taḻona manduduuy kayu yoong mambalin si amoda taḻok nat manduduuyan yu. ");
INSERT INTO kmk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Padana nu dumtong nat olas un man-abengan nat osa’n babai, taḻona mampasigab yoong nu maiyabengon dit posik maliuwana dit sigab na gapu’t dit taḻok na utdit naiyanakan dit abeng na uttun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ot siya’d padana pay kan dikayu ta manduduuy kayu uttun satun yoong man-iinnila taku uman ot amod tu nat taḻok yu un maid taḻon makakaan kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nu dumatong diya timpu, bokona sakonon nat man-imusan yu. Ta tuttuwa tun ibagak kan dikayu un singngadan na mana kodawon yu kan Amak, itdona nu kodawon yu maipagapu’t dit manuttuwaan yu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Inggana’t tun satun, naid payyan kindaw yu kan Amak maipagapu’t dit manuttuwaan yu kan sakon. Mangkodaw kayu kan Ama ta itdana dikayu daḻapnu gattoka mataḻok kayu.” ");
INSERT INTO kmk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Inyabalig ku dat imbagak kan dikayu yoong dumatong nat timpu un ilawag ku un ibaga kan dikayu nat maipanggop kan Amak. ");
INSERT INTO kmk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ot nu dumatong di un timpu, mangkodaw kayu kan siya maipagapu’t dit manuttuwaan yu kan sakon. Bokona ibagak un sakon mangodaw sinat piyaon yu un kodawon kan Ama. ");
INSERT INTO kmk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta si Ama pipiyaona dikayu gaputa pipiyaonak kan dikayu kan manuttuwa kayu un nanligwatak kan Apudyus un Ama. ");
INSERT INTO kmk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Si Apudyus un Ama ud nanligwatak un inummoy situn lubung ot sinsadinon tengyak tun lubung ta mangulinak kan siya,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","“Ah! Ilamot nalawag nat ibagbagam ta bokona iyabalig nu un mambagbaga,” kinnanan dat disipulus Jesus kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","“Sinsatunon tigammu miyon un titiggammum dat losana kakigad. Adim masapula awad man-imus kan sika. Siya’d manuttuwaan mi un nanligwat ka kan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Imbagan Jesus kan dida un, “Tuttuwa’n manuttuwa kayuwon? ");
INSERT INTO kmk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dandaniyon nat timpu, sat katuttuwaana dummatongon nat timpu’n man-asiwaḻak kayu’n losan ot osaosa manaḻan sit boḻoy na ot taynan yu ud sakona ossaan. Yoong sat katuttuwaana, bokona os-ossaanak ta iinggaw si Ama kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Indaan ku un imbaga datu kan dikayu daḻapnu kapkapiya kayu utnat naiyossaanan yu kan sakon. Adu’n ligat nat sagapaḻon yu uttun lubung yoong pabilgon yu nat somsomok yu. Inabak kuwon dat losana laweng situn lubung.” ");
INSERT INTO kmk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Magangput mana ibagan Jesus datu, nantangad langit un kanana’n, “Ama, dinumtongon nat timpu’n ingkoddong nu. Ipailam dit kinangatuk un Anak nu daḻapnu maipagapu utdan kook maipaila pay nat kinangatum. ");
INSERT INTO kmk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ta intod nu kan sakon dit pannakabalin un mangiyapu’t dat losana tagu daḻapnu itdak si mataguwan un maid kigad na dat losana impooy nu un manuttuwa kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sat makaitod si mataguwan un maid si kigad, sadin makatigammuwan da kan sika, un sika ullawa’d gattoka Apudyus kan sadin makatigammuwan da kan sakon un si Jesu Kristu un imbaun nu. ");
INSERT INTO kmk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Impailak situn pita nat kinangatum gaputa tinungpal ku dat losana impakwam kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sinsatun Ama, ipailam dit kinangatuk un ininggawon kan sakon sidit ininggawak kan sika utdit daan tun lubung nakwa. ");
INSERT INTO kmk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Impatigammuk dit maipanggop kan sika utdan tagu’t tun lubunga intod nu kan sakon. Tagum dida ot intod nu dida kan sakon. Tinuttuwa da dat losana ugud nu. ");
INSERT INTO kmk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tigammu daon un sika’d nanligwatan dan losana intod nu kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta imbagak kan dida dat losana paimbagam ot tinuttuwa da. Titiggammu da un tuttuwa’n sika’d nanligwatak kan sika’d nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Iluwaḻuwak dida. Bokona sadat tagu’t tun lubung dat iluwaḻuwak nu adi sadat intod nu un manuttuwa kan sakon, ta tagum dida. ");
INSERT INTO kmk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Losana kukuwak, kukuwam kan kukuwak pay dan losana kukuwam ot madaydayawak maipagapu kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ot sinsatunon mangulinak kan sika ot matengyan situn lubung datun tagu’n intod nu kan sakon. Nasantuwan un Ama, ayyuwanam dida udsi pannakabalin nat ngadan nu un intod nu kan sakon daḻapnu man-os-ossaan da un pada ta. ");
INSERT INTO kmk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Manipud sit ininggawak kan dida, inayyuwanak dida udsi pannakabalin nat ngadan nu un intod nu kan sakon. Inayyuwanak dida ot naid osa’t naisina, malaksig sit osa’n naitudinga madusa daḻapnu matungpal dit naikanglita ugud nu. ");
INSERT INTO kmk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sinsatunon, mangulinak kan sika ot siya’d gapuna un kodawok datu uttun antuwak payyan situn lubung daḻapnu inggaw pay kan dida tun taḻok ku un maid mangkulangana. ");
INSERT INTO kmk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Intod ku kan dida dit ugud nu ot lawengon dat tagu’t tun lubung dida gaputa padak dida un bokona tagu’t tun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bokona kodawok un kaanom dida’t tun lubung nu adi saḻakabam dida kan Satanas. ");
INSERT INTO kmk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Maipada da kan sakon un bokona tagu’t tun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ilasin nu dida un manselbi kan sika maipagapu’t dan katuttuwaan. Sat ugud nu din katuttuwaan. ");
INSERT INTO kmk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imbaun nu ud sakon situn lubung ot padana pay un ibaun ku dida’n umoy mantudtudu’t dat tagu’t tun lubung. ");
INSERT INTO kmk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ot maipagapu kan dida itdok tun long-ag ku kan sika daḻapnu itdon da pay dit long-ag da un manselbi kan sika maipagapu utdan katuttuwaan. ");
INSERT INTO kmk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bokona sadatu’n disipulus ku ud iluwaḻuwaka lawa, nu adi losan dan manuttuwa kan sakon maipagapu utdat itudtudun dat disipulus ku. ");
INSERT INTO kmk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Man-os-ossaanom dida. Ot padan dit inggawak kan sika kan inggawam pay kan sakon, iinggaw da kan dita, daḻapnu ilan kad dat uduma tagu, manuttuwa da un imbaun nu ud sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ta sadit kinangatu un intod nu kan sakon, siya’d padan dit kinangatu un intod ku kan dida daḻapnu man-os-ossaan da un maipada kan dita. ");
INSERT INTO kmk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inggawak kan dida ot inggaw ka pay kan sakon daḻapnu taḻona man-os-ossaan da kad, siya’d manigammuwan dan tagu’t tun lubung un imbaun nu ud sakon. Pipiyaom dida un padan dit mampipiyam kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, sadatuwa tagu’n intod nu kan sakon, piyaok un umoy da pay sit umoyak daḻapnu ilan da pay dit kinangatuka intod nu, gaputa pipiyaonaka taḻon sit daan payyan tun lubung nakwa. ");
INSERT INTO kmk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nalintoga Ama, naid tigammun dan tagu’t tun lubung kan sika, yoong tigammuk sika. Ot tigammun pay datun tagu’n intod nu kan sakon un sika’d nangibaun kan sakon. ");
INSERT INTO kmk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impatigammukon kan dida ot ituluy ku un ipatigammu nat maipanggop kan sika daḻapnu awad kan dida dit mampipiya un padan dit mampipiyam kan sakon kan inggawak pay kan dida.” ");
INSERT INTO kmk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Maabus man si Jesus un manluwaḻu, kaysan pati utdat disipulus na utdin kapon domang didin suḻung Kidron, un siya’d kawadan didit mumuḻ-ana nilumnokan da. ");
INSERT INTO kmk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas un siya dit mangituyuk kan Jesus, titiggammu na diya igaw ta siya’d kanayuna man-aabtan da Jesus sidat disipulus na. ");
INSERT INTO kmk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Inummoy si Judas sidi un buḻun na dat simbungguyana suldadu’n iRoma kan uduma man-aandog sit timplu un imbaun dat aappun di padi kan dat Fariseo. Nan-almas da ya nansilaw da un dummatong. ");
INSERT INTO kmk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gaputa tigammunon Jesus dat losana maipasamak kan siya, ummoy na inab-abot dida un dit dumoḻdoḻ ot kinnanana’n, “Sin nat inapon yu?” ");
INSERT INTO kmk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Summungbat da ot kinnanan da un, “Si Jesus un iNazaret.” “Sakon!” kinnanan Jesus. Si Judas un siya’d mangituyuk kan Jesus, buḻun da un dit gasikadan sit atubang Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Utdit “Sakon,” kanan Jesus, nakasuggayat da ot nalikwad da un losan. ");
INSERT INTO kmk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Inimus payyan Jesus un, “Sinnat inapon yu?” Ot kanan da payyan un, “Si Jesus un iNazaret.” ");
INSERT INTO kmk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Imbagak kan dikayu un, sakon,” kanan Jesus un dit summungbat, “ot nu sakon nat inapon yu, palubusan yu un manaḻan datun buḻun ku.” ");
INSERT INTO kmk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Imbagan Jesus tu daḻapnu matungpal dit imbaga na kan Ama na utdit un, “Maid makaanan si ulay osa utdat tagu’n intod nu kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yoong gumngat man si Simon Pedro, inasut na dit ispada na ot binakag na dit babbaun didit kangattuwana padi ot nasokdap dit kapon diwanana inga na. Sat ngadan dituwa babbaun, si Malco. ");
INSERT INTO kmk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kinnanan Jesus kan Pedro un, “Iboḻoy nu nat ispadam! Masapula sagapaḻok dat ligata itdon Ama kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Utdi, sadat susuldadu pati utdit apu da kan sadat man-aandog sit timplu, dinokmaan da si Jesus asida piningil dat imana. ");
INSERT INTO kmk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Indallay da un ummun-una kan Anas un katugangan Caifas un kangattuwana padi utdiya tawon. ");
INSERT INTO kmk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Caifas siya dit nangibaga utdat Judio utdit un, unnaya lawa un osa’n tagu nat matoy nu sadat kaaduwan. ");
INSERT INTO kmk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sada Simon Pedro kan sadit osa’n disipulus, naitung-ud da utdit nangitallayan da kan Jesus. Gaputa tigtigammun didiya disipulus dit kangattuwana padi, naitutung-ud kan Jesus un nilumnok sit nalaguma paway dit boḻoy didit kangattuwana padi. ");
INSERT INTO kmk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yoong si Pedro nataynan sit lasin dit luwangan. Utdi, nan-ulin dit buḻun na un disipulus un tigtigammun didit kangattuwana padi un umoy nakabagbaga’t dit babai’n man-aandog sit sooban ot pinaḻnok na si Pedro. ");
INSERT INTO kmk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kanan dit babai kan Pedro un, “Bokon kada sika’d osa’t dat disipulus dinata tagu?” “Bokonak,” kinnanan Pedro. ");
INSERT INTO kmk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gaputa nakumog, nan-apuy dadit baba-unon kan man-aandogon dit padi si man-aniduwan da ot sumisikad da un dit man-anidu ot ummoy pay si Pedro nakaanidu kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Inimusan dit kangattuwana padi si Jesus maipanggop sidat disipulus na kan maipanggop sidat intudtudu na. ");
INSERT INTO kmk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Summungbat si Jesus un kanana’n, “Napatakak un dit nambagbaga kan nantudtuduwak sidan sinagoga kan timplu un mandatdatngan dan losana Judio. Naid gapu’d imbagak si nalimod nu adi dodongḻon di losana tagu. ");
INSERT INTO kmk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ot apay imusan yu ud sakon. Sad imusan yu, sadan kaaduwan un nangngoḻ kan sakon. Tigammu da dat imbagak.” ");
INSERT INTO kmk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Abuson man Jesus ibaga di, tinipak dit osa’n man-aandog si Jesus un kanana’n, “Apay kama’t nat nat mansusungbat nu utnat kangattuwana padi?” ");
INSERT INTO kmk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Summungbat si Jesus un kanana’n, “Nu bokobokon din imbagak, ibagam sidatun kaaduwan nu singngadan din imbokon na, yoong nu kustu din imbagak, apay tipakonak?” ");
INSERT INTO kmk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Utdi, paindallay Anas si Jesus un napipingil kan Caifas un kangattuwana padi. ");
INSERT INTO kmk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sumisikad si Pedro un dit man-aannidu ot kanan da kan siya un, “Bokon ka kad si osa utdat disipulus na?” Yoong insulib na payyan un kanana’n, “Bokonak.” ");
INSERT INTO kmk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gumminga dit osa’t dat baba-unon dit kangattuwana padi un kabagiyan didit pinengngasan Pedro si inga un kanana’n, “Bokon kada sika dit buḻun na un innilak sin mumuḻ-an kanad?” ");
INSERT INTO kmk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Insulib uman Pedro ot dagusa nanullauk dit osa’n kawitan. ");
INSERT INTO kmk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wiswis-it man, inlaksun da si Jesus sidit boḻoy Caifas ot indallay da utdit boḻoy gubinnadul. Yoong adin dat pappangat di Judio nilumnok sit daḻom daḻapnu adida maibilang un naisaw kad, mabalin da un makakan sit kakan di Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Utdi, lummaksun si Pilato ot umoy na inimus kan dida un, “Ngadan nat ipabasuḻ yu uttun tagu’n satu?” ");
INSERT INTO kmk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Summungbat da un, “Bokona indatong mi kan sika nat tagu’n sanat nu adina nangwa si nadadag.” ");
INSERT INTO kmk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Imbagan Pilato kan dida un, “Ot aḻan yu ta lintogan yu utnat lintog yu pay lawan.” Summungbat dadit Judio un, “Adin dit lintog yu un iRoma ipalubus un dikami ud mamatoy si tagu’n makabasuḻ.” ");
INSERT INTO kmk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kama’t tu dit sungbat da daḻapnu matungpal dit imbagabagan Jesus sidit nu inon dit mangkakatoy na. ");
INSERT INTO kmk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nangulin si Pilato utdit daḻom ot pinaadani na si Jesus asina inimusan un, “Sika kad dit Alin dat Judio?” ");
INSERT INTO kmk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yoong summungbat si Jesus un, “Nanligwat kan sika nata imus onnu awad nangibaga kan sika?” ");
INSERT INTO kmk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kinnanan Pilato un, “Judiowak kad sinat kanam? Sadan padam pay lawana Judio kan aap-apun di padi ud nangidaḻum kan sika. Ot ngadan kad nat kingwam?” ");
INSERT INTO kmk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Summungbat si Jesus un, “Bokona satun lubung ud man-aliyak. Ta nu satun lubung, kapilitana makapinnatoy dan buyut ku daḻapnu adiyak maiyawat sidan aap-apun di Judio, yoong bokona satun lubung man-aliyak.” ");
INSERT INTO kmk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Adi an ali ka?” kinnanan payyan Pilato. “Kustu nat imbagam un Aliyak,” insungbat Jesus. “Siya’d ummoyak situn lubung maiyanakan daḻapnu panoknokak dit katuttuwaan ot dumngoḻ kan sakon dan manuttuwa utdan katuttuwaan.” ");
INSERT INTO kmk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Inimus Pilato uman un, “Ngadan na un katuttuwaan?” Abuson man Pilato un ibaga di, lummaksun uman ot imbagana’t dat Judio un, “Maid odasak si basuḻ dituwa tagu. ");
INSERT INTO kmk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yoong awad kadawiyan yu un, nu timpun di Piyestan di Nalausan awad pawayaak si osa’n baḻud. Piyaon yu un sad pawayaak tun Ali yu un Judio?” ");
INSERT INTO kmk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Utdi gummiya da un summungbat un, “Bokona siya’d pawayaam nata tagu. Si Barrabas nat piyaon mi!” Yoong si Barrabas, tulisan. ");
INSERT INTO kmk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Utdi, paindallay Pilato utdat suldadu si Jesus ot pinasabid na. ");
INSERT INTO kmk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ot sadat suldadu namalikawog da ut nasaisaitana wakaḻ si imbaḻangat da utdit uḻun Jesus asida kinagoyan si andu’n kagoya naduḻaw. ");
INSERT INTO kmk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Masukasukat da un umadani kan Jesus un kanan dan, “Matattagu tun alin di Judio,” asida tipakon. ");
INSERT INTO kmk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lummaksun uman si Pilato ot kanana’t dat kaaduwan un, “Antu, ilaksun ku kan dikayu daḻapnu manigammuwan yu un naid maodasak si nakabasuḻana.” ");
INSERT INTO kmk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Utdi, lummaksun pay si Jesus un nababaḻḻangatan si sait kan nakakaggoyan si andu’n naduḻaw. Kanan Pilato kan dida un, “Antu tun tagu!” ");
INSERT INTO kmk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ilan man dat aappun di padi kan dat man-aandog sit timplu, “Pailansam sin kulus, pailansam sin kulus!” kanan da un dit gummiyagiya. Yoong kinnanan Pilato un, “Aḻan yu, ta dikayu’d mangilansa pay lawan kan siya utdin kulus, ta naid odasak si nakabasuḻana.” ");
INSERT INTO kmk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Summungbat dadit Judio un, “Awad lintog mi! Sigun sit lintog, masapula mapatoy ta kabawona’n Anak Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Magngoḻ man Pilato dit imbagan dat Judio, naam-amod ummogyat. ");
INSERT INTO kmk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Painyulin na si Jesus sit daḻom ot ummoy na inimus kan siya un, “Sin nanligwatam?” kanana. Yoong naid insungbat Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ot kinnanan uman Pilato kan siya un, “Apay adika sumungbat? Adim kad tigammu un kalintogaka mangiwaya onnu mampailansa kan sika’t din kulus?” ");
INSERT INTO kmk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Summungbat si Jesus un kanana’n, “Naid kalintogam un mangwa’t nat un koom nu adin Apudyus intod nat saad nu. Isunga nadagdagson nat basuḻ dinat tagu’n nangiyawat kan sakon kan sika.” ");
INSERT INTO kmk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Magngoḻ man Pilato di un imbagan Jesus, taḻonona piyaona’n pawayaan si Jesus. Yoong gummiya dat Judio un kanan dan, “Nu pawayaam nat tagu’n sanat, bokona gayyom nu si Emperador ta singngadan na man nat mangabawa siya’d ali, gumusuḻ kan Emperador.” ");
INSERT INTO kmk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Magngoḻ man Pilato diya ugud, inlaksun na ut Jesus sidit paway asi umoy nantupak sidit tutuppakan di kuis un ininggaw sit “Plataporma Un Batu” un ngadanon dat “Gabata” utdit bagbagan di Hebreo. ");
INSERT INTO kmk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sadiya aḻ-aḻgaw dit mansaganaan dat Judio utdit Piyestan di Nalausan ot dandaniyon mamatuk. Mantupak man si Pilato, “Antu, aḻan yu tun ali yu,” kanana’t dat Judio. ");
INSERT INTO kmk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gummiya da un kanan dan, “Papatoy nu! Papatoy nu! Pailansam sidin kulus!” Inimus Pilato kan dida un, “Piyaon yu kad un pailansak sin kulus tun Ali yu?” Summungbat dadit aappun di padi un, “Naid udum si ali mi nu adi si Emperador ullawa!” ");
INSERT INTO kmk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Utdiyon, inyawat Pilato si Jesus kan dida daḻapnu mailansa’t dit kulus. ");
INSERT INTO kmk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Utdi, indallay da si Jesus sit lasin didit boboḻoy un bubukkudona dit kulus na inggana’t dummatong da utdit Igaw Di Battukag un ngadanon da’t Golgota utdin bagbagan di Hebreo. ");
INSERT INTO kmk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Siyadi ud nangilansaan da kan siya utdit kulus ot inggaw da pay duwa’n inlansa da utdit nan-asisupang kan siya. ");
INSERT INTO kmk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Inggaw pay patigammu un ingkanglit Pilato un paimpakot na utdit kulus un kanana’n, “Siyatu si Jesus un iNazaret un Alin dat Judio.” ");
INSERT INTO kmk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ot adu dadit Judio un nakabasa utdit naikanglit ta adani’t dit boboḻoy dit nailansaan Jesus. Naikanglit dit patigammu si bagbaga un Hebreo, Latin kan Griego. ");
INSERT INTO kmk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Basaon man dat Judio’n aap-apun di padi, kanan da kan Pilato un, “Adim okyan innigga un, ‘Alin dat Judio.’ Sat inniggam okyan, ‘Imbagan ditu un tagu: Sakon Ud Alin Di Judio.’ ” ");
INSERT INTO kmk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","“Sanat inabus ku un ingkanglit siyaon,” kinnanan Pilato un dit summungbat. ");
INSERT INTO kmk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Abuson man dat suldadu’n ilansa’t Jesus sidit kulus, inaḻa da dit kagoy na ot pinangkapat da kan dida. Inaḻa da pay dit nangindaḻom un badut na un andu un naaboḻa lawa’n naid si dait. ");
INSERT INTO kmk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Utdi nambabagbagaan da un, “Adi taku pissayon ta mambubunutan taku nu singngadan na nat makagasat un mangaḻa.” Siya’d tungpal dit naikanglita ugud Apudyus un kanana’n, “Nambibingayan da dit kagoy ku ot nambubunutan da dit mangindaḻom un badut ku.” Kama’t di dit kingwan dat suldadu. ");
INSERT INTO kmk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Utdit adani’t dit naipasdokan dit kulus Jesus inggaw da un gasikadan da ina na, sunud ina na, inggaw pay si Maria un asawan Cleofas kan si Maria Magdalena. ");
INSERT INTO kmk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mailan man Jesus dit ina na kan sat pipiyaona un disipulus na, imbaga na kan ina na un, “Ina, siyanat sad anak nu.” ");
INSERT INTO kmk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ot imbaga na pay sit disipulus un, “Siyanat sad inam,” kanana. Utdi payona timpu, indallay dit disipulus si Maria daḻapnu umoy inggaw sit boḻoy na. ");
INSERT INTO kmk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Maabus man di, tigammunon Jesus un ginangput naon dit losana impakwan Apudyus, ot daḻapnu matungpal dit naikanglit un ugud Apudyus kanana un, “Nauwawak.” ");
INSERT INTO kmk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Inggaw gusi utdi un napnu’t nakiloma basi. Insawsaw da dit kama’t kapos, asida inniggat dit pungtun dit gaḻuttigit dit kayu’n mangngadan si isop asida idukmit sit subil Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Utdit matamtaman Jesus dit nakiloma basi, kinnanana un, “Nagangputon!” Maibaga na man di, nanting-oy ot insuku naon dit angos na. ");
INSERT INTO kmk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sadi un aḻ-aḻgaw, kalima ot adin dat Judio piyaon un iinggaw dat ladag dat matoy sidit kulus nu aḻ-aḻgawa iillongan kan dida, kan napotog pay un aḻ-aḻgaw kan dida di ta naitimpu’t dit Piyestan di Nalausan. Siya’d gapuna’n ummoy da kan Pilato ta umoy da kodawon un ipalubus na okyan ta aminon da un umoy putdon dit ikin dat nailansa’t dit kulus daḻapnu mapgos da un matoy kad, makaan da utdit kulus da. ");
INSERT INTO kmk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Impalubus Pilato ot ummoy dat suldadu pintod dit ikin dat duwa’n inggaw sit nan-asisupang kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yoong dakngon da man si Jesus naila da un naabus natoyon ot adidaon pintod dit iki na. ");
INSERT INTO kmk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yoong osa’t dat suldadu dit nangiduy-uk sit say-ang na utdit butik Jesus ot dagusa naibuyayang dit nangkinamos un daḻa kan danum. ");
INSERT INTO kmk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sadit nakaila’t tuwa napasamak siya’d mangipanpanoknok un tuttuwa ot ipatigammu na kan dikayu daḻapnu manuttuwa kayu pay. Tuttuwa tun ipanoknok na ta innila na ot tigammu na un tuttuwa dit ibagbaga na. ");
INSERT INTO kmk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Napasamak datu’n losan daḻapnu matungpal dit naikanglita ugud Apudyus un paingkanglit na utdit un kanana’n, “Naid osa’t maptod sit tung-aḻ na.” ");
INSERT INTO kmk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ot awad payyan osa un naikanglita ugud Apudyus sidit un kanana’n, “Ilan dan tu dit dinuy-uk da si say-ang.” ");
INSERT INTO kmk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Maabus man di, ummoy Jose un iyArimatea inimus kan Pilato nu mabalin na un aḻan dit ladag Jesus. Satuwa Jose siya’d osa’t dat manuttuwa kan Jesus yoong adina nampatpatak ta kumimut sidat pappangat di Judio. Gaputa impalubus Pilato, kaysan ot umoy na inaḻa dit ladag asina indallay. ");
INSERT INTO kmk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naitung-ud pay kan siya si Nicodemo un siya dit ummoy kan Jesus si sinlabiyan. Nangidallay si umoya tuḻumpuḻu’n kilu’n bangbangu’n nakwa si nangkinamos un mira kan aloe. ");
INSERT INTO kmk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Linsan da Nicodemo kan Jose dit ladag Jesus sit kulus asida pinutiputan si napoḻkasa luput un nakuan si bangbangu un siya’d ugali da un Judio nu ilbon da dat minatoy da. ");
INSERT INTO kmk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sat adani’n didiya nailansaan Jesus inggaw mumuḻ-an ot utdit lagum na, ininggaw bagu’n lobon un naid payyan nailbon si ladag. ");
INSERT INTO kmk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ot siya’d ummoy da ullawa nangiggaan sit ladag Jesus, onta siya’d adani ta dandaniyon dit aḻ-aḻgawa iillongan. ");
INSERT INTO kmk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wiswis-it man di umuna’n aḻ-aḻgaw di sin-dumingguwan, ummoy si Maria Magdalena utdit lobon. Naila na un naid dit batu’n naitubot sit sagangaban dit lobon. ");
INSERT INTO kmk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Utdi, nanodtoddaka ummoy kan da Simon Pedro kan sat osa’n disipulus un siyadit pipiyaon Jesus. Kanana kan dida un, “Inaḻa da dit ladag ud Apu taku’t din lobon ot naid tigammu mi nu sin nangiggaan da kan siya!” ");
INSERT INTO kmk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Utdiyon, kaysan da Pedro kan sadit osa’n disipulus un umoy sit lobon. ");
INSERT INTO kmk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nanodtoddak da yoong nadaḻdaḻas dit osa’n disipulus ot naun-una’n dummatong nu si Pedro. ");
INSERT INTO kmk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nanyuk-ung un dit mangisiim ot nailana dit napoḻkasa luput yoong adina nilumnok daḻom. ");
INSERT INTO kmk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Dumatong man si Pedro un dit naitungtung-ud, nandawosa nilumnok sit lobon ot inila na dit luputa napoḻkas un naiputiput kan Jesus un maibabannata lawa. ");
INSERT INTO kmk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ot sadit luputa naiputiput sit uḻuna, naam-ammaana naḻpota naisina. ");
INSERT INTO kmk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sadit disipulus un naun-una’n dummatong nilumnok payon daḻom ot innila na dat luput ot nanuttuwa’n ummungaḻ si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Utdi un timpu adida payyan naawatan dit paingkanglit Apudyus sidit un masapula umungaḻ si Jesus kan katoy. ");
INSERT INTO kmk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Utdiyon, kaysan dat duwa’n disipulus. ");
INSERT INTO kmk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nataynan si Maria Magdalena un sumisikada man-i-ibil sit sog-on dit lobon. Man-okog man un dit mangisiim sit daḻom dit lobon, ");
INSERT INTO kmk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nailana dat duwa’n anghel un nambadut si napoḻkasa gatupakan sit naibanatan dit ladag Jesus, osa’t dit nan-uḻuwana kan osa’t dit nan-uyadana. ");
INSERT INTO kmk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Gumminga dat duwa’n anghel un, “Apay man-i-ibil ka?” kinnanan da kan Maria. Summungbat si Maria un kanana’n, “Inaḻa da dit long-ag ud Apuk ot naid tigammuk nu sindit umoy da nangiggaan kan siya!” ");
INSERT INTO kmk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Abuson man Maria un ibaga di utdit man-aswing naila na si Jesus un sumisikad, yoong maid tigammuna nu si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Gumminga si Jesus ot kinnanana’n, “Apay man-i-ibil ka? Singngadan nat inapom?” Kanan nin Maria nu sadit man-aayyuwan sit mumuḻ-an dit nakabagbaga kan siya ot kinnanana’n, “Apu, nu inaḻam dit ladag Jesus, pangaasim ta ibagam nu kawad dit umoy ka nangiggaan ta umoyak aḻan.” ");
INSERT INTO kmk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria!” kinnanan Jesus kan siya. Nansagung si Maria kan siya ot kinnanana utdit ugud un Hebreo un, “Rabboni!” un piyaona’n ugudon, Mistulu. ");
INSERT INTO kmk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Imbagan Jesus kan siya un, “Adiyanak aggoman, ta bokona nangulinak payyan kan Ama, yoong umoy ka utdat disipulus ku ta ibagam un mangulinak kan Apudyus un Amak un siya’d Apudyus kan Ama yu pay.” ");
INSERT INTO kmk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Utdi, kaysan si Maria Magdalena un ummoy nangibaga utdat disipulus un kanana’n, “Innilak ud Apu.” Ot imbaga na pay dit paimbagan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Labin man didiya aḻ-aḻgaw un siya’d umuna’n aḻ-aḻgaw dit sin-dumingguwan, nandatdatong dat disipulus Jesus si osa’n boḻoy ot nangkuḻung da utdit daḻom ta kumimut da utdat pappangat di Judio. Kakḻata lawa’n nilumtaw si Jesus un nasanikad sit gaggawa da un kanana’n, “Kapiya nat awad kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Abusona man ibaga di, impaila na kan dida dadit ima na kan butik na un nasugat, ot nantattaḻok da un nangila uman sit Apu. ");
INSERT INTO kmk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Imbagan uman Jesus kan dida un, “Kapiya nat awad kan dikayu. Padan dit nangibaunan Ama kan sakon, ibaun ku pay dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Abusona man ibaga di, sinang-awana dida asina kinnanan un, “Awaton yu si Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ot nu pakawanon yu nat basuḻ di osa’n tagu, napakawanon, yoong nu adiyu pakawanon dat basuḻ na, adina napakawan.” ");
INSERT INTO kmk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Utdiya dummakngan Jesus naid si Tomas un mangadan Pingi un osa’t dat kagwampuḻu’t duwa’n disipulus. ");
INSERT INTO kmk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ot imbagan dat uduma disipulus kan siya un, “Innila mi dit Apu!” Yoong kanan Tomas un, “Nu adik maila dat abut dat lansa’t dit ima na kan ikawot tun patimmuduk, kan nu adik ikawot tun imak sit butik na adik tuttuwaon.” ");
INSERT INTO kmk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mapalabas man dit sindumingguwan, nandatdatong uman dat disipulus Jesus sit daḻom dit osa’n boḻoy ot ininggaw pay si Tomas kan didaon. Naomban dit boḻoy yoong kakḻata lawa’n dummatong un nasanikad si Jesus sit gaggawa mi ot kanana un, “Kapiya nat awad kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ot imbaga na kan Tomas un, “Ilam datun imak kan apuwapom tun butik ku. Adim manduwaduwaan sakon, manuttuwa ka!” ");
INSERT INTO kmk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kanan Tomas un, “Sika’d Apuk kan Apudyus ku!” ");
INSERT INTO kmk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kinnanan Jesus kan siya un, “Manuttuwa ka kad gaputa innilamon sakon? Nagasat dadit manuttuwa un ulay adida naila’d sakon.” ");
INSERT INTO kmk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Aduadu payyan dat uduma am-amuga kingwan Jesus un innilan dat disipulus na un adi naikanglit situwa iblu. ");
INSERT INTO kmk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sadatu’n naikanglit, naikanglit da un manuttuwaan yu un si Jesus, siya dit Kristu un Anak Apudyus ot maipagapu’t manuttuwaan yu kan siya maitdan kayu’t mataguwana maid kigad na. ");
INSERT INTO kmk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Utdit maabus di, nampaila payyan sidat disipulus na utdin bananaw Tiberias ot kama’t tu dit nampapailana. ");
INSERT INTO kmk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ininggaw da Simon Pedro, Tomas un mangngadan si Pingi, Nataniel un iCana un osa’n ili utdin Galilea, sadat mansunuda anak Zebedeo, kan duwa pay un buḻun da un disipulus. ");
INSERT INTO kmk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Imbagan Simon Pedro utdat buḻun na un, “Umoyak manabukuḻ.” Ot kanan dat buḻun na un, “Umoy kami pay kan sika.” Utdi, kaysan da un losan un umoy nanlugan sit bangka yoong naida taḻon naaḻa da un nampasinlabi. ");
INSERT INTO kmk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Utdit suminaḻ si init sit mabigat, inggaw tagu’n innila da un sumisikad sit igid dit danum yoong adida tigammu un siya si Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ot kingwanana kan dida un, “Buḻun, nangaḻa kayu?” “Naida taḻon!” kinnanan da un dit summungbat. ");
INSERT INTO kmk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ot kinnanan Jesus un, “Isab-uk yu nat tabukuḻ yu utnat kapon diwanan nat bangka yu daḻapnu mangaḻa kayu.” Utdi, insab-uk dan tuttuwa dit tabukuḻ da utdit kapon sit imbaga na ot adida magammid dit tabukuḻ sit kaadun dat ikan. ");
INSERT INTO kmk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sadit pipiyaon Jesus sidat disipulus na, imbaga na kan Pedro un, “Si Apu Jesus di!” Magngoḻ man Simon Pedro di, nansilup ot lummayug sit danum un ummoy kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yoong sadat udum nataynan da utdit bangka’n mangamgammid sit tabukuḻa napnu’t ikan ta bokona adayu da un taḻon sit dupit ta umoya singgasuta dopa ullawa nin dit kaadayu da utdit dupit dit bananaw. ");
INSERT INTO kmk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dakngon da man dit dupit, inggaw apuya innila da un gumaḻabaḻa un ininggaw da ud ikana naitunu kan ininggaw pay ud tinapay. ");
INSERT INTO kmk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","“Mangidatong kayu’t tu utdanat ikana ka-aḻa yu,” kanan Jesus kan dida. ");
INSERT INTO kmk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Utdi, kaysan si Pedro utdit bangka ot umoy na binutbut dit tabukuḻa napnu’t nangkaddakkoḻa ikan un kagwan gasut si limampuḻu’t tuḻu dit bilang da. Yoong ulay nu aduadu dat nakna adina nabuḻtug dit tabukuḻ. ");
INSERT INTO kmk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ummayag si Jesus kan dida un, “Aweyu ta mangan,” kanana. Naidon nangalikagum sidat disipulus un nangimus nu singngadan na, onta tigammu daon un siya si Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Utdiyon, inaḻan Jesus dit tinapay ot intod na kan dida, padana pay sidat ikan. ");
INSERT INTO kmk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ot siyatu’d maikatlu’n nampail-an Jesus sidat disipulus na manipud ummungaḻana un natoy. ");
INSERT INTO kmk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Maabus da mana mangan, inimus Jesus kan Simon Pedro un, “Simon un anak Juan, amod kad nat mampipiyam kan sakon nu sat mampipiyan datun buḻun nu?” “Apu, tigammum un pipiyaok sika,” kinnanan Pedro un dit summungbat. Imbagan Jesus un, “Ayyuwanam dat ubbu un kanneluk.” ");
INSERT INTO kmk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ot impigwa na payyan inimus kan Pedro un, “Simon un anak Juan, pipiyaom kad sakon?” Summungbat uman si Pedro un kanana’n, “On, Apu. Tigammuma pipiyaok sika.” Imbagan Jesus uman un, “Ayyuwanam dat kanneluk.” ");
INSERT INTO kmk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ot impitlun payyan Jesus inimus un, “Simon un anak Juan, pipiyaom kad sakon?” Laweng dit angoson Pedro ta pitlun Jesus un nangimus un, “Pipiyaonak kad?” Ot imbagan Pedro un, “Apu, titiggammum nat kakigad, tigammum un pipiyaok sika.” Imbagan Jesus kan siya un, “Ayyuwanam dat kanneluk. ");
INSERT INTO kmk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tuttuwa tun ibagak kan sika un, sadit kaban-og nu, sika’d nangisuḻgong pay lawan sit bakakat nu ot ummoy ka utdat piniyama ummoyan, yoong nu mammaḻong-ag kaon, uknadom nat imam ot awad mangisuḻgong si bakakat kan sika un mangidallay sit adim piyaon un ayan.” ");
INSERT INTO kmk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Imbagan Jesus tu un nangipatigammuwana nu inon dit mapatoyan Pedro un maidayawan Apudyus. Ot imbagan Jesus kan Pedro un, “Unudonak!” ");
INSERT INTO kmk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Man-awing man si Pedro, naila na dit disipulus un pipiyaon Jesus un maitungtung-ud kan dida. Siya dit disipulus un naisog-on kan Jesus sidit nanganan da kan nangimus un, “Ngadan dit mangituyuk kan sika?” ");
INSERT INTO kmk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Utdi, inimus Pedro kan Jesus un, “Inon ditun tagu’n satu nu?” kanana. ");
INSERT INTO kmk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Summungbat si Jesus kan siya un, “Nu piyaoka matagu’t inggana’t mangulinak, singngadan nat biyang nu utdi? Unudomot sakon,” kinnanan Jesus. ");
INSERT INTO kmk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ot gapu’t diya imbagan Jesus, nandinamag sidat manuttuwa un sadi un disipulus adina matoy. Yoong bokona siya’d imbagan Jesus di, ta imbagana ullawa un, “Nu piyaoka matagu inggana’t mangulinak, sinnat biyang nu utdi?” ");
INSERT INTO kmk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Sadi un disipulus, siya payon tun mangpanpanoknok sit kinatuttuwan datu un maipanggop kan Jesus kan siya payon tun nangikanglit situ. Ot tigammu mi un tuttuwa’n losan dan ibagbaga na. ");
INSERT INTO kmk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Adu payyan dat kingkingwan Jesus. Yoong nu masin-ossa da un maikanglit, akit nin tun lubung si inggawan di iblu un maikanglitan dat maipanggop kan Jesus.");
INSERT INTO kmk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Potpotgoka Teofilo, Utdit ummuna’n iblu, ingkanglit ku dat losan un kingkingwan Jesus kan intudtudu na manipud sidit inlugi na un nantudtudu, ");
INSERT INTO kmk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","aginggana’t dit kaysanana’d langit. Utdit daan na un manaḻan langit, binilin na maipagapu’t dit pannakabalin ud Ispiritu Santu dat pinili na un apostoles na. ");
INSERT INTO kmk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Namin-adu un nampaila kan dida udsi nadumaduma’n wagas si unus di opata puḻu’n aḻgaw manipud sit ummungaḻana un natoy daḻapnu ipanoknok na un tuttuwa’n ummungaḻ ot intudtudu na dit maipanggop sit mangiyapuwan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Namingsan un naammungan da Jesus sidat apostoles na binilin na dida un, “Adi kayu umat-atun situn Jerusalem ta uwayon yu aginggana’t ibaun Amak kan dikayu dit insapatana’n itdona un siya payon dit imbagbagak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Si Juan binunyagana dat tagu’t danum yoong Adina masulit mabunyagan kayu kan Ispiritu Santu.” ");
INSERT INTO kmk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Namingsan un naammungan da payyan, inimus dat apostoles kan Jesus un, “Apu, sinsatun kadon nat mangiyulinam sit tulay dat iyIsrael un mangiyapu utdan uduma ili un padan dit aw-awe?” ");
INSERT INTO kmk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Summungbat si Jesus un, “Si Amak ullawa’d makatigammu utdit timpu un mapasamakan dat intuding na un mapasamak maipagapu’t tulay na ot bokona naipalubusa matigammuwan yu. ");
INSERT INTO kmk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yoong nu dumatong si Ispiritu Santu un umoy inggaw kan dikayu, maitdan kayu si pannakabalin ot dikayu ud mangipanoknok sidan tagu utdit maipanggop kan sakon un bokona lawa’n satun ili’d Jerusalem kan lakub Judea kan Samaria nu adi losan dan kailin-ili’t tun pita.” ");
INSERT INTO kmk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Abusona man un maibaga datu, nampangatu si Jesus sin langita iillan da inggana’t nasaḻ-inan sit bunot. ");
INSERT INTO kmk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Gasissiya payyana tumutukkoḻ da ud langit sidit kakḻata lawa’n inggaw da ud duwa’n tagu un nakabadut si napoḻkas un sumisikad sidit sog-on da un kanan da’n, ");
INSERT INTO kmk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Apay kayu’n iGalilea un gasikadana tumutukkoḻ langit? Satuwa Jesus un nampangatu’d langit mangulin payon nu timpu na, ot sat man-uulin na padan dit naila yu un nampapangatu na un kaysan langit.” ");
INSERT INTO kmk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Utdi, nangkaulin dat apostoles ud Jerusalem un nanligwat sidin bateled Olivo un umoya sinlikwod dit kaadayuna. ");
INSERT INTO kmk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dumatong da man ud Jerusalem nandawos da utdit nangingngatu un kuwaltun dit boḻoy un dadaggusan da. Ininggaw da Pedro, Juan, Santiago kan Andres, Felipe kan Tomas, Bartolome kan Mateo, Santiago un anak Alfeo, Simon un Patriota kan si Judas un anak Santiago. ");
INSERT INTO kmk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kanayun datu un maammung un manluwaḻu un maidagamungan dat piga’n babai un kama kan Maria un inan Jesus kan ininggaw pay dat susunud Jesus un laḻaki. ");
INSERT INTO kmk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lumabas man piga’n aḻgaw naammung dadit umoya kagwanggasut si duwampuḻu’n manuttuwa. Summikad si Pedro utdit atubang da ot kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Susunud, masapula matungpal dit naikanglita ugud Apudyus un impapadtun Ispiritu Santu kan David maipanggop kan Judas un nangipuyut sidat ummoy nanokma kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas, buḻun mi un apostoles ot nadutukan un maipankokwa uttun talibasu mi un apostoles.” ");
INSERT INTO kmk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yoong si Judas, sadit pilak un tangdan na utdit lawenga kingwa na, inggatang na si pita un siya payon natoyana utdit naibuḻsukana un naotdag ot ginumtak dit buwang na ot naiwakat dat bagis na. ");
INSERT INTO kmk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dingngoḻ dat losana tagu’d Jerusalem dit napasamak kan Judas ot nginadan da dit pita si “Akeldama,” un sat piyaona’n ugudon, “Pitan di Daḻa.” ");
INSERT INTO kmk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Naikanglit sidit iblun dat Salmo un, ‘Mantuttungad dit boḻoy na un mabaawan kan maidon tagu’t inggaw.’ Naikanglit pay un kanana’n, ‘Masapula awad osa si manongwat sidit saad na.’ ");
INSERT INTO kmk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Siya’d gapuna un masapula mamili taku si osa un buḻun mi un mangipanoknok sit ummungaḻan Apu Jesus. Masapul un sanat mapili osa kan ditaku’n naibuḻubuḻun kan siya manipud sit nantudtuduwan Juan maipanggop si bunyag aginggana’t dit nampangatuwan Jesus ud langit.” ");
INSERT INTO kmk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Utdi, nangidatag da si duwa’n laḻaki, un sada Matias kan Jose un mangngadan Barsabas un ngadnon da pay kan Justo. ");
INSERT INTO kmk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Utdiyon nanluwaḻu da un kanan da’n, “Apu, tigammum nat kasomsomkan di losana tagu, ipailam okyan kan dikami nu singngadan na utdatu un duwa dit pinilim ");
INSERT INTO kmk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","un manongwat sit igaw Judas situ un talibasu kan sadit kinaapostoles un tinengyana ta kaysan sit naikoddonga inggawana.” ");
INSERT INTO kmk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Magangput da man un manluwaḻu, nambubunut da ot nabunut si Matias un maidoga utdadit kagwampuḻu’t osa’n apostoles. ");
INSERT INTO kmk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Utdit dumatong dit aḻ-aḻgawa Piyestan di Pentecostes, naammung dat losana manuttuwa si osa’n boḻoy sin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Utdi, kakḻata nakagngoḻ da si ag-agguwod un nanligwat langit un kama’t gingan di nabiloga bayogbog un nauḻmuum sit boḻoya ininggawan da. ");
INSERT INTO kmk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ot naila da dat sinan-dila un gilab di apuy un nilumtaw un inumpa utdit uḻun di kada osa kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kadon napnu da kan Ispiritu Santu ot kabooḻan daon mambagbaga’t sabali un bagbaga ta initdan Ispiritu Santu dida si kabooḻan. ");
INSERT INTO kmk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Utdiya timpu ininggaw da ud Judio utdin Jerusalem un nanligwat sit nadumaduma’n ili’t tun lubung un kankanayuna mandaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Utdit magngoḻ da dit damit, nadatdatong da utdit boḻoy ot nasnasdaaw da ta nambagbaga dat apostoles kan dida sit kuwa da pay lawana bagbaga. ");
INSERT INTO kmk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gapu’t dit amoda nasdaawan da nampaim-imus da un, “Bokon kada iGalilea un losan datu un mambagbaga’t ugud taku? ");
INSERT INTO kmk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ot inona’n tigammu da tun bagbagan datun losana tagu’n awad situ? ");
INSERT INTO kmk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Awad da ud iPartia kan ditaku, awad da ud iMedia, iyElam, iMesopotamia, iJudea, iCapadocia, iPonto, kan iyAsia. ");
INSERT INTO kmk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Awad da pay iFrigia, iPamfilia, iyEgipto kan lakub ud Libya un adani’t din Cirene. Awad da pay Judio kan bokona Judio un nangunud sit ugalin di Judio un nanligwat Roma. ");
INSERT INTO kmk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Awad da pay udum kan ditaku ud nanligwat Creta kan Arabia yoong dodongḻon taku un ibagbaga da dat maipanggop sidat nakaskasdaawa kingwan Apudyus sit tunggal bagbagan dat tagu un awad situ.” ");
INSERT INTO kmk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Losan dat tagu’n nasdaaw kan matikatikaw ot nampaim-imus da pay lawan un, “Ngad tun kaipooyan ditu?” ");
INSERT INTO kmk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yoong sadat udum inyeemeng da dat apostoles un kanan da’n, “Ay, nabuuk datu un tagu!” ");
INSERT INTO kmk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Utdi, summikad si Pedro pati utdat kagwampuḻu’t osa’n apostoles ot nambagbaga si nadangsoḻa kanana’n, “Susunud ku un Judio kan losana inggaw situn Jerusalem, dumngoḻ kayu kan sakon ta ibagak kan dikayu tun piyaona’n ugudon tu. ");
INSERT INTO kmk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sadatu un tagu bokona nabuuk da un kama’t nat somsomok yu kan dida ta maikasiyama olas payyan si bigbigat, ");
INSERT INTO kmk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","nu adi siyatu dit tungpal dit imbagan Apudyus un impadtun dit propeta Joel un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Satu tun kook sidan maudi’n aḻ-aḻgaw sin daan tun lubung mangkigad. Itdok tun Ispirituk sidan losana tagu ot maipagapu’t dit tuḻung na paibagak sidan aabeng yu un laḻaki kan babai dan piyaoka ibaga utdan tagu. Mangil-ok dat babbagu yu si kama si in-inop. Ot awad da ud ipain-inop ku utdat lallakay kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pada na pay un sidiya timpu, itdok tun Ispirituk sidan babbaun ku un laḻaki kan babai ot paibagak kan dida dat piyaoka ibaga utdan tagu. ");
INSERT INTO kmk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mangipailaak si nakaskasdaawa am-amug sidin langit kan nakaskasdaawa mangilasinan situn pita ot awad da ud daḻa, apuy kan amoda asuk. ");
INSERT INTO kmk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kumḻop din init kan dumuḻaw din buḻan un kama’t daḻa asi naon dumatong dit napotog kan maid maipadaana un aḻ-aḻgaw un dumakngan ud Apu. ");
INSERT INTO kmk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ot singngadan na mana mampakpakaasi un mampatuḻung kan siya taguwona dida.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Intuluy Pedro un kanana’n, “Susunud ku un kaganakan Israel dongḻon yu datu’n ibagak. Nalawag un imbaun Apudyus si Jesus un iNazaret, ta panoknokan dat am-amug kan nakaskasdaawa mangilasinan un impakwan Apudyus kan siya. Tigammu yu datu ta napasamak da uttun mismu’n kawadan yu. ");
INSERT INTO kmk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Naipaima kan dikayu si Jesus maisayun sit pinanggop kan doda’n tigammun Apudyus un makwa kan siya. Pinapatoy yu kan painlansa yu utdit kulus sidadit gumabasuḻa tagu. ");
INSERT INTO kmk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yoong pinaungaḻ Apudyus kan katoy ot winayaana utdit pannakabalin katoy ta adi mabalin un itulayan katoy. ");
INSERT INTO kmk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Si David kama’t tu dit imbaga na utdit aw-awe maipanggop kan siya, ‘Kankanayuna mailak si Apu. Iinggaw situn kapon madiwanan ku daḻapnu naid gapun di mabulungak. ");
INSERT INTO kmk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Siya’d gapuna un mantattaḻokak ot ipailak tun taḻok ku utdat ugud ku. Ulay nu taguwaka lawa, mannamnamaak kan sika Apu, ");
INSERT INTO kmk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","un adim ipalubus un mampatungad tun kadogwak sin igaw dan natoy kan adim pay ipalubusa maḻpos tun potpotgoma baba-unon. ");
INSERT INTO kmk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Impatigammum kan sakon dit daḻan un mangipuyut sit mataguwan un maid kigad na. Ot gaputa iinggaw ka kan sakon maid mangkulangan tun taḻok ku,’ kanan dit impadtun David. ");
INSERT INTO kmk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Susunud, piyaok ibaga kan dikayu dit maipanggop sidit Ali David un puun taku. Natoy dit David ot nailbon ot ulay situn satun gasissiya din lobon na kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Osa’n propetan Apudyus ot tigammuna dit insapatan Apudyus kan siya un awad kaganakana’n man-aliyon Apudyus un maisukat kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tigammu na dit mapasamak isunga impadtu na un: ‘Adina maiduya utdit igaw dadit natoy, Ot sadit long-ag na Adina maḻpos,’ sadit umungalan Kristu kan katoy dit ug-ugudona. ");
INSERT INTO kmk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Sadi un Kristu siya payon si Jesus un pinaungaḻ Apudyus kan katoy ot losan kami’n mangustigu’t dit napasamak. ");
INSERT INTO kmk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nampangatu si Jesus sit kapon madiwanan Apudyus un Ama na ot intod Apudyus kan siya dit insapata na un Ispiritu Santu. Satu un Ispiritu Santu, siya payon tun intod Jesus un umoy inggaw kan dikami ot siya’d maigapuwan datu un inila yu ya dingngoḻ yu uttun satun. ");
INSERT INTO kmk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ta si David, bokona nampangatu’t din langit un kama kan Jesus nu adi imbaga na un, ‘Si Apudyus kinnanana utdit Apuk: Mantupak ka uttun kapon madiwanan ku, ");
INSERT INTO kmk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","aginggana’t abakok dan kabusuḻ nu.’ ");
INSERT INTO kmk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ot gaputa kama’t di, masapul un tigammuwon dat katagun-tagu’t tun Israel un maid duwaduwa na un satu un Jesus un painlansa yu utdit kulus, pinambalin Apudyus si Apu kan Kristu un managu.” ");
INSERT INTO kmk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Utdit nagngoḻ dat tagu dit imbagan Pedro, nabulubulung da ot inyimus da kan Pedro kan dat uduma apostoles un, “Susunud, singngadan din koon mi nu?” ");
INSERT INTO kmk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kinnanan Pedro kan dida un, “Mambabawi kayu ot lipsutan yu dan basuḻ yu ot mampabunyag kayu si mangipatigammuwan yu un tuttuwaon yu si Jesu Kristu daḻapnu mapakawan dat basuḻ yu kad maawat yu dit Ispiritu Santu un itdon Apudyus kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Satu un sapatan Apudyus mampooy kan dikayu kan sidat aabeng yu kama pay sidan losana tagu’t dan adaddayuwana igaw. On, mampooy sidan losana ayagan Apudyus un Apu taku un umoy kan siya.” ");
INSERT INTO kmk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Aduadu dadit impalawag Pedro un pammanoknok na kan nangawis na utdat tagu. Ot kanana’n, “Ilisi yu nat long-ag yu utdin dumatonga madusaan dan nadadaga tagu’t tun satun.” ");
INSERT INTO kmk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Utdi, sadat nakagngoḻ kan nanuttuwa utdit imbagan Pedro, nampabunyag da. Ot umoya tuḻu’n libu un tagu dat naidoga kan dida un manuttuwa utdiya aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Impapasnok da un nan-adaḻ sidat apostoles kan naitimpuyug kan nakaamung da kan dida’t dan manluwaḻuwan da kan manganan da un mangisomsomkan sit natoyan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Adu un am-amug kan nakaskasdaawa mangilasinan dat impakwan Apudyus sidat apostoles ot taḻona ummogyat kan nasnasdaaw dat losana tagu. ");
INSERT INTO kmk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Intultuluy dat losana manuttuwa un nandatdatonga simbungguyan kan imbingay da dan losana awad kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nu awad mangkasapulan, mangilaku da utdat pita da kan udum paya kukuwa da asi da iwaḻas dit gatang na kan dida pay lawan sigun sit kasapulan di kada osa. ");
INSERT INTO kmk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ot kaaḻgaw-aḻgaw un mandaydayaw da un simbungguyan sidit timplu. Maabus man, umoy da mangan sit boloy di osa kan dida un naanggoanggom da kan bokona naimut da. ");
INSERT INTO kmk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Indaydayaw da si Apudyus ot masmas-oman dat losana tagu dida. Kaaḻgaw-aḻgaw un dogaan Apu dit bilang dat taguwona. ");
INSERT INTO kmk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sin-aḻgawan si nandangwilis, ummoy da Pedro kan Juan sidit timplu ta siya’d timpun di luluwaḻuwan. ");
INSERT INTO kmk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Naisammu un indatong da tun laḻaki’n napilay manipud sit naiyabengana utdit luwangan dit timplu un mangadan si “Nabaḻbaḻu un Luwangan.” Kaaḻgaw-aḻgawa buligan da un iyoy sidi daḻapnu tumapaya utdat tagu’n lumnok sidit timplu. ");
INSERT INTO kmk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Maila na man da Pedro kan Juan un lumnok sidit timplu nantapaya kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Intutukkoḻ da dit laḻaki ot imbagan Pedro kan siya un, “Ilam dikami.” ");
INSERT INTO kmk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ot tummukkoḻ kan dida ot nanam-ona un mangtod da kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yoong kinnanan Pedro kan siya un, “Maida taḻon pilak ku yoong sad itdok kan sika san awad kan sakon. Maipagapu utdit pannakabalin dit ngadan Jesu Kristu un iNazaret, ibagak kan sika un kumiyang ka.” ");
INSERT INTO kmk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ot inaggoman Pedro dit diwanan un iman dit napilay, asina tinuḻungan un summikad ot dagusa gummilog dat um-um dat iki na. ");
INSERT INTO kmk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kadon nakalagkanga summikad ot asina nakakkiyakiyang. Nilumnok pay sit timplu kan dida un lumagkang pay ya kumiyang un dit mangidaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Losan dat tagu’t di naila da un mangkikkikkiyang kan idaydayaw na si Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ot maimatunan da man un siya dit tagu’n mantutupaka tumapatapaya utdit Nabaḻbaḻu’n Sooban dit timplu, taḻona nasnasdaaw da ot nataag da utdit napasamak kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Utdi, ummoy da Pedro kan Juan sit balkun dit timplu un mangngadan Balkun Solomon ot naikewekewed dit tagu kan dida. Nanggugunoda nampatodtoddak dat tagu un masmasdaawana ummoy mangila kan dida utdit balkun. ");
INSERT INTO kmk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Utdit nailan Pedro dat tagu kinnanana kan dida un, “Susunud un kaganakan Israel, apay un masmasdaawan kayu’t tu? Apay itutukkoḻ yu dikami un kama nu kummiyang tu un tagu gapu’t pannakabalin mi pay lawan onnu kinabaḻu mi un tagu? ");
INSERT INTO kmk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Si Apudyus un siya’d nandaydayawan da Abraham, Isaac kan Jacob, padana pay sidat kapuunan taku, impaila na dit kinangatun Jesus un babbaun na. Siya si Jesus un impaima yu kan gubinnadul Pilato un piyaona okyana pawayaan yoong ummadi yu. ");
INSERT INTO kmk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Adi yu piniya dit Nasantuwan kan Nalintog ot sad kindaw yu un mawayaan, sadit kumapatoy un naibaḻud. ");
INSERT INTO kmk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinatoy yu dit mangitod si mataguwan yoong pinaungaḻ Apudyus sidat natoy. Ot dikami’d makapanoknok ta dikami’d nakaila kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ot maipagapu utdit pannakabalin dit ngadan Jesus kan sadit pammati mi kan siya napabilog tu un tagu’n tigtigammu yu un napilay. On, maipagapu’t pammati kan taḻgod kan Jesus kummiyan taḻon tun tagu kas maila yu. ");
INSERT INTO kmk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sinsadin susunud, tigammuk un kingwa yu di kan Jesus ta adiyu naawatan dit kaipooyan dit kingkingwa yu, padana pay sidat pappangat yu. ");
INSERT INTO kmk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Adi yu tigammu un siyadi dit tungpal dit impapadtun Apudyus sidat propeta na utdit un sadit Kristu un ibaun na masapula mapaligat. ");
INSERT INTO kmk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kadon, masapula mandadaoli kayu ot mangulin kayu kan Apudyus daḻapnu pakawanona dat basbasuḻ yu. ");
INSERT INTO kmk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ta nu siya’d koon yu, itdan dikayu kan Apudyus si gin-awan di somsomok ot ibaun na pay si Jesus un siya si Kristu un dinutukana un mangiyapu kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yoong sinsatun masapula inggaw si Jesus ud langit aginggana’t dit timpu’n mapabaḻu dat losan un kama’t dit impapadtun Apudyus sidat propeta na utdit aw-awe. ");
INSERT INTO kmk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kinnanan Moses sidit un, ‘Mangibaun tu si Apudyus un Apu si propeta na un padan dit nangibaunana kan sakon. Osa pay lawan kan dikayu’n Judio. Ot masapula tuttuwaon yu dat losana ibagana. ");
INSERT INTO kmk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ot singngadan na mana adi manuttuwa utdi un man-uugudon, kaanon Apudyus sidat tagu na ot patoyona.’ ");
INSERT INTO kmk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ulay dadit losana propetan Apudyus manipud kan Samuel kan dat naisongwat kan siya imbagabaga da dit maipanggop sidat makmakwa’t tun satun. ");
INSERT INTO kmk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ditaku dit mampooyan dat insapatan Apudyus un impaibagana utdat propeta na. Maibilang taku utdat intulag Apudyus sidat aappu taku utdit kanana kan Abraham un, ‘Maipagapu utdit kaganakam, bindisyunak dat losana tagu’t tun pita.’ ");
INSERT INTO kmk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ditaku’n Judio dit ummuna un binindisyunan Apudyus sidit namiliyana kan nangibaunana kan Jesus un babbaun na un umoy mampabalbaliw kan ditaku utdat nadadaga koko-on taku,” kinnanan Pedro. ");
INSERT INTO kmk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Utdit madama payyana mampalpalawag da Pedro kan Juan sidat tagu, dummatong kan dida dat papadi, sat kapitan dat man-aandog sidit timplu kan dat Saduceo. ");
INSERT INTO kmk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Amod dit suḻag da gapu utdit itudtudun da Pedro utdat tagu un ummungaḻ si Jesus un natoy ot siya’d mangipanoknoka umungaḻ dadit matoy. ");
INSERT INTO kmk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Utdi, dinokmaan da dida yoong gaputa nasdomon kinuḻung da dida yan sit babaḻḻudan agingga si mabigat. ");
INSERT INTO kmk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yoong adu payon dat nanuttuwa utdat tagu un nakagngoḻ sidit impalawag da Pedro ot nambalin si lima’n libu dit bilang dat losana laḻaki un nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Utdit mabigat, sadat pappangat kan lalallakay dat Judio kan dat mimistulun di lintog, naammung da ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ininggaw da Anas un kangattuwana padi, da Caifas, Juan kan Alejandro kan sadat udum paya kabagiyan dit kangattuwana padi. ");
INSERT INTO kmk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pinasikad da dat duwa’n apostoles sidit atubang da asida inimusan dida un, “Ngadan dit nanligwatan dit pannakabalin yu un nangagas sit napilay? Sin dit ngadan un inusal yu?” ");
INSERT INTO kmk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Utdi, napnu si Pedro utdit pannakabalin Ispiritu Santu ot summungbat kan dida un, “Mangitultulay kan lalallakay mi, ");
INSERT INTO kmk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nu imusan yu dikami maipanggop si kingwa mi un napiya utdit tagu’n napilay kan nu inona’n kummiya, ");
INSERT INTO kmk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","masapula tigammuwon yu un losan kan losana tagu’t tun Israel, un satuwa tagu’n sumisikad situn atubang yu kummiya maipagapu’t dit pannakabalin dit ngadan Jesu Kristu un iNazaret un pinailansa yu utdit kulus yoong pinaungaḻ Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jesus dit ug-ugudon dit naikanglita ugud Apudyus sit aw-awe un, ‘Sadit batu un sinumdiyan dat mantutuud si boḻoy, siya oton dit nambalin si gattoka pannan.’ ");
INSERT INTO kmk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Si Jesus ullawa’d mataguwan taku. Maid sabali si imbaun Apudyus si singngadan na mana tagu’t tun lubung un managu kan ditaku nu adi si Jesus ullawa.” ");
INSERT INTO kmk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Utdit nailan dat nakamiting dit kinatuḻod da Pedro kan Juan kan natigammuwan da pay un tagu da ullawa un naid si adaadaḻ, nasnasdaaw da. Ot nailasin da un naibuḻubuḻun da kan Jesus sidit. ");
INSERT INTO kmk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yoong naid maibaga da ut maisuganggang kan dida ta iillan da dit tagu un kummiya un sumisikad sit sog-on da Pedro kan Juan. ");
INSERT INTO kmk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Utdiyon pinaḻaksun da da Pedro kan Juan sidit mimittingan asida nambabagbaga dat pappangat. ");
INSERT INTO kmk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kanan da un, “Ngad kad nin nat koon taku utdatuwa tagu? Tigammun di losana tagu’t tun Jerusalem dit kingwa da un nakaskasdaawa am-amug ot adi taku mabalin un maisulib. ");
INSERT INTO kmk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yoong daḻapnu matupod tun sumayakan tun damag sidat tagu, masapula bagaan taku dida ta adi daon mantudtudu utdat udum un usalon da dit ngadan Jesus.” ");
INSERT INTO kmk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Utdi, pinaḻnok da uman dat duwa’n apostoles ot binilin da dida un taḻona adidaon mambagbaga onnu mantudtudu un usalon da dit ngadan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yoong summungbat da Pedro kan Juan un, “Somsomkon yu ud nu kustu utdin mangiil-an Apudyus un dikayu ud tuttuwaon mi un bokon kan Apudyus? ");
INSERT INTO kmk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ta nu dikami, adina mabalin un adimi ibaga dat naila kan nagngoḻ mi kan Jesus.” ");
INSERT INTO kmk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Utdi, inog-ogyat da payyan dida asida pinadaḻan dida ta naid gapun di manusaan da kan dida onta umogyat da utdat tagu ta losan da un mangidaydayaw kan Apudyus gapu’t dit nakaskasdaawa napasamak. ");
INSERT INTO kmk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Onta, sadit tagu un nakwaan dit am-amuga kummiyaana, nakalimampuḻuwan dit tawon naon. ");
INSERT INTO kmk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Utdit nawayawayaan da Pedro kan Juan, nangulin da utdat buḻun da un manuttuwa ot impadamag da kan dida dat imbagan dat aap-apun di papadi kan dat lalallakay dat Judio. ");
INSERT INTO kmk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Magngoḻan da man dit impadamag da, nan-os-ossaan da un nanluwaḻu’n losan kan Apudyus un kanan da’n, “Apu un mannakabalin un nangwa’t din langit, kan pita, baybay kan losana awad kan dida, ");
INSERT INTO kmk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","paimbagam kan ap-apu mi un David sidit tuḻung Ispiritu Santu un, ‘Apay taḻona makasuḻag dan bokona Judio? Apay manomsomok dat tagu ut maid si selselbi? ");
INSERT INTO kmk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nandatdatong kan nansagana dat aali kan pappangat situn lubung un gumusuḻ kan Apudyus un Apu kan si Kristu un dinutukana un managu.’ ");
INSERT INTO kmk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Siyadi un gattok dit napasamak ta nandatdatong da uttun Jerusalem da Herodes kan da Poncio Pilato, pati payon sidat bokona Judio kan dat kaganakan Israel ot losan da un gummusuḻ kan Jesus un nasantuwan un baba-unom, un siya dit dinutukam un Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nandatdatong da un nangwa utdat losana ingkoddong nu utdit un piyaoma makwa maipagapu’t dit pannakabalin nu. ");
INSERT INTO kmk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ot sinsatunon Apu, dongḻom dan og-ogyat da kan dikami un baba-unom. Tuḻungam dikami un tumuḻod un mangipalawag sit ugud nu. ");
INSERT INTO kmk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipailam nat pannakabalin nu utdan man-agasam sidan masakit kan mangwaam si am-amug kan nakaskasdaawa mangilasinan maipagapu utdit mannakabalin un ngadan Jesus un nasantuwana baba-unom.” ");
INSERT INTO kmk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Utdit magangput da un manluluwaḻu nanyugayug dit boḻoya nadatdatngan da ot napnu da utdit pannakabalin ud Ispiritu Santu ot tummuḻod da un losana mangipalawag sidit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nan-uunud dit somsomok kan giknan dadit manuttuwa. Naid osa si mangibaga un, “Kuwak tu,” ta kanan da un sadit kuwan di osa kuwa da un losan. ");
INSERT INTO kmk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ot maipagapu utdit pannakabalin un naitod kan dida intultuluy da dit nangipanoknok sit ummungaḻan Apu Jesus ot taḻona binindisyunan Apudyus dida’n losan. ");
INSERT INTO kmk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ot naid osa si makulangan kan dida ta sadat awadan si pita onnu boḻoy ilaku da ot sat gatang na umoy da ");
INSERT INTO kmk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","itdon sidat apostoles ta dida ud nangamunga mangiwaḻas sidat uduma manuttuwa sigun sit kasapulan di osa kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Inggaw osa’n Levita kan dida un mangngadan Jose un naiyanak sidin Chipre kan nginadan dat apostoles si Bernabe un piyaona’n ugudon, “mampabilog si aangson.” ");
INSERT INTO kmk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Inlaku na dit pita na asina intod dit gatang na utdat apostoles daḻapnu dida ud nangamunga mangiwaḻas. ");
INSERT INTO kmk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Inggaw pay osa’n laḻaki un mangngadan kan Ananias ot Safira dit ngadan asawa na. Inlaku na pay dit udum sit pita da. ");
INSERT INTO kmk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yoong nangisuḻuk si Ananias sidit gatang dit pita da ot inampayunan pay asawa na, asin Ananias umoy inyoy dit udum sidat apostoles ta dida’d mangiwaḻas. ");
INSERT INTO kmk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yoong kinnanan Pedro kan siya un, “Ananias, apay impalubus nu un iyapuwan dika kan Satanas ot tinuliyam si Ispiritu Santu ta insuḻuk nu dit uduma gatang dit pita yu? ");
INSERT INTO kmk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Utdit daan nu un nangilaku utdit pita, bokon kad un kuwa yu dit pita? Ot utdit nailaku bokon kad un kuwa yu dit gatang na ot kalintogan yu un usalon sit piyaon yu un mangusalan? Apay sad sinomsomok nu dit mantuli? Bokona nantuli ka si tagu nu adi si Apudyus ud tinuliyam.” ");
INSERT INTO kmk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Magngoḻ man Ananias di, natukas ot natoy. Ot sadat losana nakagngoḻ sidiya napasamak amod dit kimut da. ");
INSERT INTO kmk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Utdi, nilumnok dat babbagu ot ummoy da binugus dit ladag na asida ummoy innilbon. ");
INSERT INTO kmk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lumabas man umoya tuḻu’n olas, dummatong si Safira un naid tigammu na utdit napasamak kan asawana. ");
INSERT INTO kmk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Inimus Pedro kan siya un, “Siyatu kada lawa ud gatang dit inlaku yu un pita yu?” “On,” kinnanan dit babai. “Siya’n losan nat dit gatang na.” ");
INSERT INTO kmk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Utdi, kanan Pedro kan siya un, “Apay nantulagan yu kan asawam un padpadason dit Ispiritun Apudyus? Annat daon sinat sawang danat babbagu un ummoy nangilbon kan asawam ot maisongwat ka payona ilaksun da.” ");
INSERT INTO kmk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ot dagusa natukas si Safira ot natoy sidit atubang Pedro. Lumnok man dat babbagu, naila da un natoyon ot inakkat da un inlaksun ot ida innilbon sidit sog-on dit asawa na. ");
INSERT INTO kmk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Taḻona nakakimut dat losana manuttuwa kan udum un nakagngoḻ situwa napasamak. ");
INSERT INTO kmk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Adu un am-amug kan nakaskasdaawa mangilasinan dat kingwan dat apostoles un nailan dat tagu. Ot sadat losana manuttuwa taḻona natimpuyug da ot kankanayuna maammung da utdit Balkun Solomon sidit timplu. ");
INSERT INTO kmk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ot naid makatuḻoda umoy tumipun sit bungguy da si bokona buḻun da. Yoong taḻona idaydayaw dat tagu dat manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ot sad koona’n ummaduadu dat bilang dat babai kan laḻaki un nanuttuwa ot naidoga da utdat manuttuwa kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Maipagapu utdit kokkoon dat apostoles un nakaskasdaaw, ummoy payon dat tagu inawit dat masakit ot ida innigga dida utdit kaḻsa un naiyobog si katli onnu obok. Ta namnamaon da un ulay maayyungan da ullawa utdit angngingiwan Pedro nu lumaus, kumiya da. ");
INSERT INTO kmk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Adu-adu’n tagu un nanligwat si kailin-ili sin nangkalliput ud Jerusalem dat nan-idatong sidat masakit kan sinakayan di nadadaga ispiritu ot kummiya da’l losan. ");
INSERT INTO kmk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Utdi, amoamod dit apaḻ dit kangattuwana padi kan losan dat buyut na un kabungguyan dat Saduceo utdat apostoles ot nantutulagan da dit koon da. ");
INSERT INTO kmk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ot ummoy da dinopap dat apostoles asida imbaḻud dida. ");
INSERT INTO kmk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yoong utdiya labi binukatan dit anghel Apudyus dit onob dit babaḻḻudan ot pinaḻaksun na dat apostoles un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Umoy kayu’t din timplu ta itudtudu yu utdat tagu dit maipanggop sit bagu kan maid kigad na un mataguwan.” ");
INSERT INTO kmk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Utdit nagngoḻ da tu, nantungpal da ot nilumnok da utdit timplu si wiswis-it ot inlugi da un nantudtudu. Utdi payona timpu, sadit kangattuwana padi kan dat buyut na un Saduceo, pinandatdatong da dat bungguy di Sanhedrin un maibilangan dat losana pappangat kan lalallakay di Judio ta mammimiting da. Ot nangibaun da si umoy mangaḻa utdat apostoles sit babaḻḻudan daḻapnu maimusan da. ");
INSERT INTO kmk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yoong dumatong man dat naibaun un opisyal sit babaḻḻudan naid gapu’d apostoles sit daḻom ot nangulin da’l lawa utdit mimittingan ot kinnanan da un, ");
INSERT INTO kmk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dinakngan mi dit babaḻḻudan un naitutuḻbok kan iinggaw dat man-aandog sidit lasin dit sawang yoong bukatan mi man, naid odasan mi si ulay osa utdit daḻom.” ");
INSERT INTO kmk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Utdit magngoḻ dit kapitan dat man-aandog sit timplu kan dat aap-apun dat papadi dit imbaga da, nampaim-imkaw da nu sin dit nakwa utdat apostoles. ");
INSERT INTO kmk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Utdi, inggaw tagu’n dummatong ot kanana kan dida un, “Sadat tagu’n paimbaḻud yu awad da’t din timplu un mantudtudu utdan tagu!” ");
INSERT INTO kmk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ot sadit kapitan dat man-aandog sit timplu kan dat tagu na, ummoy da utdit timplu ot inam-ammaan da dida un innaḻa ta umogyat da nu batuwon dat tagu dida. ");
INSERT INTO kmk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Maidatong da man dat apostoles, indatag da dida utdat Sanhedrin. Ot inimusan dit kangattuwana padi dida. ");
INSERT INTO kmk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kinnanana un, “Binilibilin mi dikayu un adi kayuwon mantudtudu si maipanggop kan Jesus. Apay kingwa yu payyan? Ilan yu ot summayakon nat tudtudu yu uttun losana lakub Jerusalem kan piyaon yu pay ipabasuḻ kan dikami dit napatoyana!” ");
INSERT INTO kmk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Summungbat si Pedro kan dat uduma apostoles un, “Masapula si Apudyus tungpaḻon mi, bokona tagu. ");
INSERT INTO kmk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Si Apudyus un nandaydayawan dadit aamma taku, pinaungaḻ na si Jesus un pinapatoy yu utdit nampainlansaan yu utdit kulus. ");
INSERT INTO kmk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Impangatun Apudyus si Jesus sidit kapon madiwanan na ot pinambalin na ut Pangat kan Managu’t tagu. Kingwana tu daḻapnu awad gundaway taku un kaganakan Israel un mambabawi utdat basuḻ taku kad pakawanona ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dikami ud mamanoknok sidatu un pasamak kan panoknokan pay Ispiritu Santu un intod Apudyus sidat tagu un manuttuwa kan siya.” ");
INSERT INTO kmk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dongḻon man dat kamang di Sanhedrin di, amod dit suḻag da ot piyaon da un mapatoy dat apostoles. ");
INSERT INTO kmk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yoong inggaw osa’n Fariseo un mangngadan Gamaliel un mistulun di lintog kan madayaw sidat losana tagu. Summikad ot imbilin na un mailaksun dat apostoles si sin-akitan. ");
INSERT INTO kmk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Utdit mailaksun da dida, kinnanan Gamaliel sidat buḻun na un, “Susunud un kaganakan Israel, masapula ammaan yu un somsomkon nat panggop yu un koon sidatuwa tagu. ");
INSERT INTO kmk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ta utdit un adi na payyan nabayaga timpu, inggaw osa’n laḻaki un mangngadan Teudas un nangabaw un nangatu’n tagu, ot umoya opata gasuta tagu dat naibuyut kan siya. Yoong utdit napatoy si Teudas nan-asiwaḻak dat buyut na ot naid nambanagan da. ");
INSERT INTO kmk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Magangput man di, naisongwat payyan un nampalang si Judas un iGalilea utdit timpun dit masensusan dat tagu. Adu uman dat naawis na yoong mapatoy man, losan dat buyut na uman un nan-asiwaḻak. ");
INSERT INTO kmk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Ot san ibagak kan dikayu maipanggop situwa mapaspasamak, adi taku bibiyangan datuwa tagu ot baybay-an taku dida. Ta nu satun panggop da onnu kokkoon da nanligwat si tagu, maid payon mambanagana. ");
INSERT INTO kmk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yoong nu si Apudyus ud makinnakom sit koon da, adi taku maabak dida. Isunga adi taku suganggangon dida ta amangan nu si Apudyus nat suganggangon taku.” ");
INSERT INTO kmk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ot siya’d inunud da dit ugud Gamaliel. Pinaḻnok da dat apostoles ot pinasabisabid da dida asida binilibilin dida un adi daon mantudtudu si maipanggop kan Jesus, asida inwaya dida. ");
INSERT INTO kmk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Utdi, tinaynan dat apostoles dat kamang di Sanhedrin un amod dit taḻok da ta imbilang Apudyus un maikali da un mababbainan maipagapu kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ot kaaḻgaw-aḻgaw un umoy da utdit timplu kan kaboḻoyboḻoy ot intulutuluy da un nantudtudu kan nan-iwalagawag sit Nabaḻu’n Damag un si Jesus, siya dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Utdiya timpu un ummaduadu dit bilang dat manuttuwa, nilumtaw tun lilin dat Judio un mambagbaga si Griego utdat Judio un mambagbaga si Hebreo. Nanlili dat Griego un mabaybay-an dat bilug da utdat maiwaḻasa lasyun kan dida si kaaḻgaw-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Utdi, pinandatdatong dat kagwampuḻut-duwa’n apostoles dat losana manuttuwa ot kinnanan da un, “Bokona lumbong un baybay-an mi din mangiwalagawagan mi utdit ugud Apudyus maipagapu’l lawa si mangipapuutan mi utdan maiwaḻas un lasyun. ");
INSERT INTO kmk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Isunga susunud, mamili kayu si pitu’n laḻaki kan dikayu un nabaḻu ud kaugudana, nasilib kan napnu si pannakabalin Ispiritu Santu, ta dida ud dutukan taku un mangipapuut sidatuwa makwa. ");
INSERT INTO kmk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kad sidi, maiyossaan mi un manluwaḻu kan mangiwalagawag sidit ugud Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nas-oman da un losan dit kanan dat apostoles ot pinili da si Esteban un osa’n tagu un nabilog dit pammati na kan napnu’t pannakabalin Ispiritu Santu. Pinili da pay dat udum un sada Felipe, Procoro, Nicanor, Timon, Parmenas kan si Nicolas un osa’n bokona Judio un iyAntiokia un ummunud sit ugalin dat Judio. ");
INSERT INTO kmk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Indatag da dat napili utdat apostoles ot inyagpad dat apostoles dat ima da utdit uḻun dit kada osa un napili asida inluwaḻuwan dida. ");
INSERT INTO kmk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Utdiyon summayasayak dit ugud Apudyus ot ummaduadu dat manuttuwa utdin Jerusalem kan adu pay dat papadi un nangunud sit kustu un pammati. ");
INSERT INTO kmk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban un taḻona binindisyunan Apudyus kan initdana si amoda pannakabalin, nangkokwa utdat am-amug kan nakaskasdaawa mangilasinan un iillan dat tagu. ");
INSERT INTO kmk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yoong inggaw da ud Judio un nanuganggang kan siya. Dida dat iCirene kan iyAlejandria un nanligwat sit sinagoga un ngadnon da ut “Sinagogan di Nawayaana Tagu.” Buḻun da dat uduma Judio un iCilicia kan iyAsia un nakasinnungbat kan Esteban. ");
INSERT INTO kmk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yoong adida kabooḻana maabak si Esteban gapu utdit kinasilib na kan gaputa si Ispiritu Santu ud mangibaga utdat ugudona. ");
INSERT INTO kmk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Utdi, namasuksuk da si piga’l lawa’n laḻaki daḻapnu ibaga da un, “Nagngoḻ mi tuwa tagu un nambagbaga’t maisuganggang kan Moses kan si Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kama’t tu dit nansusugsug da daḻapnu makasuḻag dat tagu padana pay sidat lalallakay di Judio kan mimistulun di lintog kan Esteban. Ot ummoy da dinokmaan asida indallay sit Sanhedrin. ");
INSERT INTO kmk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nangipalang da utdat tagu si umoy mantuli un mangustigu maipanggop kan Esteban un kanan da’n, “Adina gumongda tuwa tagu un mambagbaga’t maisuganggang situn timplu taku kan sidit lintog Moses. ");
INSERT INTO kmk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ta nagngoḻ mi dit imbaga na un si Jesus un iNazaret, yam-anona tun timplu ot baliwana dat ugali un impatawid Moses kan ditaku.” ");
INSERT INTO kmk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Utdi, intutukkoḻ dat losana kamang di Sanhedrin si Esteban ot naila da dit muging na un nadoḻanga kama si muging di anghel. ");
INSERT INTO kmk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Utdi, inimusan dit kangattuwana padi si Esteban un, “Tuttuwa kad tu un ipabasuḻ da kan sika?” ");
INSERT INTO kmk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Summungbat si Esteban un, “Susunud ya aamma, dumngoḻ kayu kan sakon. Utdit ininggawan dit ginnapuwan taku un Abraham sidin Mesopotamia, utdit daan na payyan un umoy inggaw Haran, nampaila dit mannakabalin kan madaydayawa Apudyus kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ot kinnanan Apudyus kan siya un, ‘Taynam nat ilim kan dat kakabbagiyam ot umoy ka utdin ili’n ibagak kan sika.’ ");
INSERT INTO kmk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Utdi, tinaynan Abraham dit ilin dat Caldeo ot inummoy ininggaw sidin Haran. Utdit natoyon dit aman Abraham, binilin Apudyus un umoy situwa ili un inggawan taku’t tun satun. ");
INSERT INTO kmk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Naid intod Apudyus kan Abraham si pita ut mangkuwa na uttu ulay nu singkulligonga lawa. Yoong insapatan Apudyus kan siya un mangkuwa da utdat kaganakana tuwa pita ulay nu naid payyan anak Abraham sidit. ");
INSERT INTO kmk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Imbagan pay Apudyus kan siya un, ‘Umoy dat kaganakam inggaw si uduma ili ot mambalinon da dida si puyung kan mapalpaligat da si unus di opata gasut un dagun. ");
INSERT INTO kmk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yoong dusaok dat tagu’n mamuyung kan dida kad taynan dat kaganakam diya ili ot man-ulin da un mandaydayaw kan sakon situwa igaw.’ ");
INSERT INTO kmk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Imbilin pay Apudyus un matuḻgiyan dat losana anaka laḻaki daḻapnu awad mangilasinan situwa intulag na. Siyadi dit gapuna un tinuḻgiyan Abraham dit abeng na un si Isaac sidit maikawaḻu’n aḻgaw na un naiyabeng. Ot si Isaac, tinuḻgiyana si Jacob ot siya payon kingwan Jacob sidat kagwampuḻu’t duwa un abeng na un siya dat nadayawa ginnapuwan taku. ");
INSERT INTO kmk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Gapu’t dit apaḻ dat anak Jacob kan Jose un sunud da inlaku da un mapuyung sidin Egipto. Yoong si Apudyus tinatakkudog na si Jose. ");
INSERT INTO kmk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Inlisin Apudyus sidat losana mapaligatana kan initdana si gasossoom un ugali kan silib ot nas-om dit Faraon un alin dat Egipto kan siya. Ot dinutukana si Jose un gubinnadul un mangitulay sidin Egipto kan ulay sidat losana kaboḻoy na. ");
INSERT INTO kmk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Utdiyon dinumtong dit amoda uḻat un siya’d gapun dit amoda ligat sidin losana Egipto kan Canaan ta naid mangaḻ-an dat ginnapuwan taku si kanon da. ");
INSERT INTO kmk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yoong utdit nadamag Jacob un awad ilik sidin Egipto, imbaun na dat abeng na un siya dat ginnapuwan taku. Siyadi ud damu’n ummoyan da ud Egipto. ");
INSERT INTO kmk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Utdit maikagwa’n ummoyan da, intigtigammun Jose dit long-ag na kan dida’n susunud na ot siyadi payon dit nakatigtigammuwan Faraon sidat susunud Jose. ");
INSERT INTO kmk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Utdi, impaayag Jose si ama na un Jacob pati utdat losana pamilyan dat susunud na ta dumatong da ud Egipto. Pitumpuḻu ya lima da’l losan. ");
INSERT INTO kmk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Kadon inummoy da Jacob ininggaw ud Egipto ot siyadi ud natoyana kan dat uduma ginnapuwan taku. ");
INSERT INTO kmk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yoong inyulin da dat ladag da ud Sikem un innilbon da utdit loḻobnan un ginatang Abraham sidat kaganakan Hamor. ");
INSERT INTO kmk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Utdit umadaniyon dit timpu’n matungpaḻan dat insapatan Apudyus kan Abraham, aduadu daon dat ginnapuwan taku ud Egipto. ");
INSERT INTO kmk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Utdiyon summongwat tun osa’n ali un mangiyapu’d Egipto un naid tigtigammuna kan Jose. ");
INSERT INTO kmk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sadiya ali sinikasikapana dat ginnapuwan taku ot pinapilit na dida un tengyan da dat abit da utdit lasin daḻapnu matoy da. ");
INSERT INTO kmk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Utdiya timpu naiyabeng si Moses ot naḻungpuḻungpu un abit. Tinagibin dat maḻong-ag na si tuḻu’n buḻan sidit boḻoy da. ");
INSERT INTO kmk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Utdit adi daon maisuḻuk, kapilitana tinengyan da utdit lasin yoong indasan dit babai un abeng Ali Faraon. Inaḻa na ot pinadakoḻ na un kama si kustu un abeng na. ");
INSERT INTO kmk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Utdi, natudtuduwan si Moses sidat losana silib dadit iyEgipto ot nambalina mabigbigbig un tagu gapu utdit man-uugud na kan angwat na. ");
INSERT INTO kmk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Utdit opatapuḻu’n dagunon si Moses, nagasmok na un umoy ay-ayawon dat pada na un kaganakan Israel. ");
INSERT INTO kmk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Utdit ininggawana’t di, naila na un palpaligaton dit iyEgipto dit osa’n iyIsrael. Ummoy na tinuḻungan ot imbaḻos na un pinatoy dit iyEgipto. ");
INSERT INTO kmk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Impagalup Moses nu naawatan dat pada na un kaganakan Israel un siya ud usalon Apudyus un mangiwaya kan dida utdat iyEgipto yoong adida naawatan. ");
INSERT INTO kmk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Mabigat man uman, naila na dat duwa un mantilitiliw ot pinadas na dida un mangkapiyaon un kanana’n, ‘Buḻun, apay mantilitiliw kayu un nampada kayu’n kaganakan Israel?’ ");
INSERT INTO kmk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Yoong sadit mamalpaligat sit osa, indubḻang na si Moses un kanana’n, ‘Singngadan nat nangisaad kan sika un mangipangat kan manguis kan dikami? ");
INSERT INTO kmk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Piyaom kad patoyon sakon un padan dit namatoyam sidit iyEgipto ud kaḻabyan?’ ");
INSERT INTO kmk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Utdit nagngoḻ Moses tu, nambutik ot ummoy ininggaw sit adayu’n ili un Midian. Siyadi ud nangasaw-ana kan gummanakana si duwa’n laḻaki. ");
INSERT INTO kmk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Lumakpus man dit opatapuḻu un dagun, ininggaw si Moses sit igawa maid tagtaguwan sidin bateled Sinai ot nampaila kan siya dit anghel Apudyus sit gumilagilaba kaykayyu. ");
INSERT INTO kmk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nasdaaw si Moses sidit naila na. Utdit umad-adaniyana ta ina am-ammaan ilan, nagngoḻ na dit gingan ud Apu un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Sakon si Apudyus un nandaydayawan da Abraham, Isaac kan Jacob un ginnapuwam.’ Namilpil si Moses sidit kimut na ot adi naon maituḻoda tumukkoḻ. ");
INSERT INTO kmk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Utdi, imbagan Apudyus kan siya un, ‘Kaanom nat kapatus nu ta nasantuwan nat igaw un sumisikkadam. ");
INSERT INTO kmk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nailaka taḻon dit mamalpaligatan dat iyEgipto utdat taguk kan nagngoḻ ku pay dat ayuwong da. Ot dummobaaka umoy mangiwaya kan dida. Awe nu ta ibaun ku ud sika’t din Egipto.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Intuluy Esteban un, “Si Moses, siya dit sinumdiyan dat kaganakan Israel sidit imbaga da kan siya un, ‘Singngadan nat nangisaad kan sika un mangipangat kan manguis kan dikami?’ Yoong siya payon dit imbaun Apudyus un mangipangat kan mangiwaya kan dida’t dit napuyungan da maipagapu utdit tuḻung dit anghel un nampaila kan siya utdit gumilgilaba kaykayyu. ");
INSERT INTO kmk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Ot inlaksun na dat kaganakan Israel sidin Egipto ot adu dat kingwa na un am-amug kan nakaskasdaawa mangilasinan sidin Egipto, utdin Nadokota Baybay kan sidit ininggawan da utdit igawa naid tagtagguwan si opatapuḻu’n dagun. ");
INSERT INTO kmk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Siya payon si Moses un nangibaga utdat kaganakan Israel un kanana’n, ‘Mangibaun si Apudyus kan dikayu si osa’n propeta na un pada yu pay lawan un Judio un padan dit nangibaunana kan sakon.’ ");
INSERT INTO kmk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Utdit naammung dat ginnapuwan taku utdit igawa maid tagtaguwan sidin Bateled Sinai, si Moses dit nakabagbagaan dit anghel Apudyus ot inawat Moses dit mannanayun un ugud Apudyus daḻapnu itdona kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Yoong adin dat ginnapuwan taku tinuttuwa si Moses, taḻona adi daon piyaona unudon ta piyaon da un mangulin yoong sidin Egipto. ");
INSERT INTO kmk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Siya’d gapuna un utdit mauwayan da kan Moses un ummoy sidin bateled Sinai, imbaga da kan Aaron un sunud Moses un, ‘Ikokwaam dikami si sinan-apudyus un tungtung-udon mi. Ta si Moses un nangilaksun kan dikami’t din Egipto naid tigammu miyon nu ngadan nat napasamak kan siya.’ ");
INSERT INTO kmk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Kadon, nangwa da si sinan-apudyus un kama si ubbun di baka ot nan-idatun da kan siya kan inpiyestaan da dit kingwa da pay lawana sinan-apudyus da. ");
INSERT INTO kmk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Gapu’t di, impatungad Apudyus dida ot binay-ana dida un nandaydayaw sidat bituwon ud langit un siya payon dit ingkanglit dat propetan Apudyus sidit un kanan da’n, ‘Kaganakan Israel! Sakon kad nangidatunan yu utdat pinalti yu un ayam un indatun yu utdit ininggawan yu utdit igawa maid tagtaguwan si unus di opata puḻu’n dagun? Bokon. ");
INSERT INTO kmk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ta sadit tulda un ininggawan dit sinan-apudyus un Moloch dit inawit yu kan sadit sinanbituwon dit sinan-apudyus yu un Refam. Sadatu dat sinan-apudyus un nandaydayawan yu. Siya’d gapuna un ibaun ku dat umoy gumusuḻ kan dikayu ot idallay dikayu utdin labos Babilonia.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Intulutuluy Esteban un kanana’n, “Utdit ininggaw dat ginnapuwan taku utdit igawa maid tagtagguwan, inggaw tulda da un mangilasinan un awad si Apudyus kan dida un siya payon dit intulag na. Nakwa di un tulda sigun sit imbilin Apudyus kan Moses un makwaana un maipada utdit tutulladan un naipaila kan Moses. ");
INSERT INTO kmk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Utdit natoy si Moses naisongwat si Josue un nangipangat kan dida. Ot tinawid dat ginnapuwan taku di un tulda ot intaltallay da utdit impangatan Josue dida un nanakup sidat pita un nampakaanan Apudyus sidat ininggaw. Ot sadita tulda iniinggaw kan dida inggana utdit timpun Ali David. ");
INSERT INTO kmk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nasnas-om si Apudyus kan Ali David. Kindaw David un mapalubusan un manuud si boḻoy un mandaydayawan da kan Apudyus un nandaydayawan Jacob. ");
INSERT INTO kmk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yoong bokona si David dit nanuud nu adi si Solomon un abeng na. ");
INSERT INTO kmk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Yoong ulay nu kama’t di, bokona inggaw si boḻoya kingwan di tagu si Apudyus un Kangattuwan ta paimbaga na utdit osa’n man-uugudon un, ");
INSERT INTO kmk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘San langit ud mangiyapuwak ot satun pita ud papattayak sidan ikik. Ot kamaana’n boḻoy nat mabalin yu un tuudon un boḻoy ku? Ngadan na un igaw dit maibagaya man-illongak? ");
INSERT INTO kmk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bokon kad un sakon ud nampaloswa utdatu’n losana kakigad?’ ” ");
INSERT INTO kmk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Intuluy Esteban un nambagbaga’n kanana’n, “Ginumḻang nat uḻu yu un tagu. Kama’t aangson di paganu nat aangson yu ta adiyu piyaona dongḻon dan ugud Apudyus. Kanayuna suganggangon yu si Ispiritu Santu un padan dat kingwan dat ginnapuwan yu. ");
INSERT INTO kmk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Awad kad propetan Apudyus si adin dat ginnapuwan yu pinalpaligatan? Ot pinatoy da pay dat imbaun Apudyus un ummoy nangidaana nangipadamag sidit dumakngan Jesus un Nalintoga Babbaun na. Ot sinsatun dikayu’d nangituyuk kan nampapatoy kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dikayu’d nangawat sidit lintog Apudyus un paintod na kan Moses sidit anghel yoong adiyu tinuttuwa,” kinnanan Esteban kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Utdit magngoḻan dat pappangat di Judio dat imbagan Esteban, ngumilongilot dit ngipon da utdit suḻag da kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yoong napnu si Esteban sit pannakabalin Ispiritu Santu ot mantangad man langit, naila na dit nakaskasdaawa doḻang Apudyus kan si Jesus un sumisikad sidit kapon madiwanan na. ");
INSERT INTO kmk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Ilan yu,” kanan Esteban, “Mailak langit un mabubuktan ot sadit Inyanak di Tagu un si Jesus, andi un sumisikad sidin kapon madiwanan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yoong gapappakuyan dat tagu ot inuput da dat inga da daḻapnu adi da magngoḻ dit bagbagan Esteban asida dinukusana naab-abtan. ");
INSERT INTO kmk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ot linagayad da un inlaksun sidit lasin dit ili asida binatubatu. Ot sadat tagu un nampabasuḻ kan siya, imbanat da dat kagoy da un impaadog sidit osa’n babbagu un mangngadan Saulo. ");
INSERT INTO kmk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Utdit madama un batubatuwon da si Esteban, nanluwaḻu un kanana’n, “Apu Jesus, awatom tun kadogwak.” ");
INSERT INTO kmk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Utdiyon nampalintumong ot impakuy na un, “Apu Jesus, adim okyan ipabasuḻ kan dida tuwa kokkoon da.” Maibaga na man tu, napungdiwon dit angos na. ");
INSERT INTO kmk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Utdi, inggaw da ud tagu un kanayuna mandaydayaw kan Apudyus un ummoy nangilbon kan Esteban ot taḻona inibiibilan da. Yoong si Saulo nas-omana dit namatoyan da kan Esteban. Ot manipud sidiya aḻ-aḻgaw nanlugi dit amoda namalpaligatan da utdat manuttuwa utdin Jerusalem. Ot losan dat manuttuwa malaksig sidat apostoles, nan-asiwaḻak da utdin losana lakub Judea kan Samaria. ");
INSERT INTO kmk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Si Saulo taḻona piyaona’n maid dat losana manuttuwa kan Jesus ot linnok na dat kaboḻoyboḻoy, linagayad na dat manuttuwa un babai kan da laḻaki ot paimbaḻud na dida. ");
INSERT INTO kmk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sadat manuttuwa un nan-asiwaḻak, intudtudu da dit ugud Apudyus sidat il-ili un ummoyan da. ");
INSERT INTO kmk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ot osa kan dida si Felipe un inummoy si osa’n ili ud lakub Samaria ot impatigammu na utdat tagu’t di dit maipanggop kan Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Utdit magngoḻan dat tagu dit itudtudu na kan naila da dat nakaskasdaawa mangilasinan un kingwa na, impapasnok da dit nandongoḻ kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ta pinaḻaksun na dat dimunyu utdat tagu un sinakayan da ot gapappakuyan da un lummaksun kan adu pay dat pinapiya na un adi makakuliit kan napilay. ");
INSERT INTO kmk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kad, amod dit lagsak dat tagu’t diya ili. ");
INSERT INTO kmk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yoong inggaw pay osa’n laḻaki utdiya ili un mangngadan kan Simon. Nabayag un masmasdaaw dat iSamaria utdit mansasalumangka na kan ibagbaga na pay un siya ud nangatu’n tagu. ");
INSERT INTO kmk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ot losana tagu’t diya ili, nangatu man kan da nadoba, impapasnok da un nandongoḻ sidat imbaga na. Ta kanan da un, “Satu un tagu siya dit initdan Apudyus si pannakabalin ot mangadan si Taḻona Mannakabalin.” ");
INSERT INTO kmk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Impasnok da un nandongoḻ kan siya gaputa nabayag un taḻona nasnasdaaw da utdit mangkokwaana’t dat salsalumangka. ");
INSERT INTO kmk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yoong utdit nanuttuwa da utdan intudtudun Felipe un Nabaḻu’n Damaga maipanggop sit mangiyapuwan Apudyus kan sat maipanggop kan Jesu Kristu, nampabunyag da’l losan, laḻaki kan da babai. ");
INSERT INTO kmk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pati si Simon nanuttuwa payon ot magangput man un mabunyagan naitungtung-udon kan Felipe. Ot maila na man dat am-amug kan nakaskasdaawa mangilasinan un kingwan Felipe, taḻona nasnasdaaw. ");
INSERT INTO kmk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Utdit nagngoḻ dat apostoles Jerusalem un nanuttuwa dat iSamaria utdit ugud Apudyus, imbaun da kan dida da Pedro kan Juan. ");
INSERT INTO kmk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ot utdit dumatong da, inluwaḻuwan da dat iSamaria un manuttuwa daḻapnu umoy inggaw dit Ispiritu Santu kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ta utdiya timpu naid payyan si Ispiritu Santu kan dida nu adi nabunyagan da’l lawa utdit ngadan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ot utdiyon, inyagpad da Pedro kan Juan dat ima da utdat uḻun dat manuttuwa ot naawat da si Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Utdit mailan Simon un intod Apudyus si Ispiritu Santu utdat manuttuwa maipagapu’t dit nangiyagpadan dat apostoles sidat ima da kan dida, induyaw na dit pilak na kan da Pedro kan Juan ta ibayad na ");
INSERT INTO kmk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","un kanana’n, “Itdanak pay situwa pannakabalin yu daḻapnu awad kad tagu’t mangiyagpadak situn imak, maawat na pay si Ispiritu Santu.” ");
INSERT INTO kmk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yoong summungbat si Pedro kan siya un, “Maidoga ka utnat pilak nu un maipisuk sidin impiyelnu ta kanam nin nu mabalin un magatang si pilak dit pakdaw Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maid maikankanamungam onnu kalintogama maipankokwa kan dikami utdan pakwan Apudyus ta bokona nalintog nat aangsom sidin man-iila na. ");
INSERT INTO kmk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Isunga mambabawi ka uttuwa nadadaga sinomsomok nu ot iluwaḻum un nu mabalin pakawanon dika kan Apudyus sinata sinomsomok nu. ");
INSERT INTO kmk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ta mailak un amod nat apaḻ un ginumḻoy kan sika ot pinuyung dika’t basuḻ.” ");
INSERT INTO kmk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ot summungbat si Simon kan da Pedro kan Juan un, “Mangaasi kayu ta iluwaḻuwanak kan Apudyus daḻapnu adi na mapasamak kan sakon tu un inugud yu.” ");
INSERT INTO kmk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Utdit maabusa panoknokan da Pedro kan Juan dit maipanggop kan Jesus kan maabusa maibaga da dat ugud na, nangulin da ud Jerusalem un inoy da dat adu un boboḻoya sakup Samaria ot inwalagawag da dit Nabaḻu’n Damag maipanggop kan Jesus sidat tagu’t di. ");
INSERT INTO kmk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Utdi payona timpu inggaw anghel Apudyus un nampaila kan Felipe un nangibaga kan siya un, “Manlakkat ka ta umoy ka utdin daya un kaḻsa un manaḻan Gaza un nanligwat ud Jerusalem.” Satuwa kaḻsa bokona mausalon situn satun. ");
INSERT INTO kmk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Utdi, nanlakkat si Felipe ot kaysan. Utdiya inggawana’t dit kaḻsa naabat na tun osa’n opisyal un iyEtiopia un siya ud man-aayyuwan sidat losana kinabaknang dit Candace onnu reynan di Etiopia. Inummoy Jerusalem nandaydayaw kan Apudyus, ");
INSERT INTO kmk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ot utdit mangulinon un nanlugan sidit kalesa na, basabasaona dit iblu’n ingkanglit propeta Isaias. ");
INSERT INTO kmk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Utdi, imbagan Ispiritu Santu kan Felipe un, “Umoy ka dakngon din kalesa.” ");
INSERT INTO kmk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Utdi, nanoddak si Felipe ot dakngona man dit kalesa, nagngoḻ na un basabasaon dit opisyal dit iblun ingkanglit Isaias. Ot inimus na kan siya un, “Maawatam kad nat basabasaom?” ");
INSERT INTO kmk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Summungbat dit pangat un, “Innon nat man-aawat ku nu maid mangilawag kan sakon?” Ot pinanlugan na si Felipe utdit kalesa un nandoḻ-ag da. ");
INSERT INTO kmk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Satu dat naikanglita ugud Apudyus un basabasaona utdit iblun Isaias, “Kama si kannelu un maidallay sidit papaltiyan, Kama si ubbun di kannelu un gumiginnok nu pukisan da, Adina un pulus gumguminga. ");
INSERT INTO kmk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Binabbainan da ot bokona nalintog dit nangkukuis da kan siya. Maid makaugud si maipanggop si kaganakana ta pinangkigad da dit mataguwana uttun pita.” ");
INSERT INTO kmk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ot sadit pangat, inimus na kan Felipe un, “Ibagam ud kan sakon nu singngadan na dit mangibagbagaan dit propetan Apudyus situ, maipanggop kan siya pay lawan onnu awad udum?” ");
INSERT INTO kmk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Utdi, inlawlawag Felipe ot inlapu na utdit binasan dit opisyal un ugud Apudyus dit nangibagaana’t dit Nabaḻu’n Damag maipanggop kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Utdiya manlulluganan dat dit kalesa, dintong da dit danum ot sadit pangat kinnanana un, “Antu ud danum. Adina kad mabalina mampabunyagak?” ");
INSERT INTO kmk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kinnanan Felipe kan siya un, “Mabalin un mabunyagan ka, nu ipapasnok nu un manuttuwa kan Jesus.” “On, manuttuwaak,” insungbat na. “Tuttuwaok un si Jesu Kristu dit Anak Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ot pinan-illong dit pangat dit kalesa ot inummoy da un duwa utdit danum ot binunyagan Felipe. ");
INSERT INTO kmk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Utdit tumakdang da, dagusa indallay Ispiritu Santu si Felipe ot naidon inilan dit opisyal kan siya yoong intulutuluy na un kaysan un mantattaḻok. ");
INSERT INTO kmk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Utdit makadlaw si Felipe ininggawon sin ili un Azoto. Ot inwalagawag na dit Nabaḻu’n Damag sidat losana ili’n inoy na aginggana’t dummatong ud Cesarea. ");
INSERT INTO kmk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Utdi payon un timpu, nantultuluy dit angos Saulo un taḻona mangog-ogyat kan mamatoy sidat manuttuwa kan Jesus ot inummoy sidit kangattuwana padi, ");
INSERT INTO kmk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","un umoy nangdaw si sulat un pammalubus kan siya un itdona utdat pangat di sinagogan dat Judio utdin Damasco. Ta nu awad maodasana ut manuttuwa’t di utdit Wagas di mantatagu un intudtudun Jesus, dokmaana dida, babai man onnu laḻaki asina punguwona idallay dida ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Inggaw man si Saulo utdit daḻan un adaniyon ud Damasco, kakḻata lawa’n dinoḻangan dit napaddapadda un silawa nanligwat langit. ");
INSERT INTO kmk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Dagusa naidugsut ot nagngoḻ na dit ginga un kanana kan siya un, “Saulo, Saulo, apay palpaligatom sakon?” ");
INSERT INTO kmk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Singngadan nu kad Apu?” inimus Saulo. “Sakon si Jesus un palpaligatom,” insungbat dit ginga. ");
INSERT INTO kmk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Gumangun ka ta ituluy nu un umoy sidin ili’d Damasco ot awad mangipatigammu kan sika’t di utdat koom.” ");
INSERT INTO kmk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sadat buḻun Saulo, natataag da ta nagngoḻ da dit ginga yoong naid naila da si tagu. ");
INSERT INTO kmk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Utdi, summikad si Saulo ot indiyat na dat ata na yoong Adina makaila. Ot kiniwida lawan dat buḻun na un indallay Damasco. ");
INSERT INTO kmk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tuḻu’n aḻgawa adina makaila ot sidatuwa aḻ-aḻgaw adina un taḻon nangan kan umminum. ");
INSERT INTO kmk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Utdin ili’d Damasco, inggaw osa’n manuttuwa un mangngadan Ananias. Nampaila si Apu Jesus kan siya si kama’t in-inop na un kanana’n, “Ananias!” Ot summungbata kanana’n, “On, antuwak Apu?” ");
INSERT INTO kmk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Imbagan ud Apu kan siya un, “Mansagana ka ta ika’t din kaḻsa un ngadnon dat Nagdong, umoy ka utdin boḻoy Judas ot imusom nu kawad dit laḻaki’n iTarso un mangngadan si Saulo. Ta madama un manlulluwaḻu si Saulo uttun satun. ");
INSERT INTO kmk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ot naipaila pay kan siya si kama’t in-inop na un annat dumatonga mangngadan si Ananias un umoy mangiyagpad sit ima na kan siya daḻapnu makaila uman.” ");
INSERT INTO kmk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yoong summungbat si Ananias un, “Apu adu un tagu ud nangibaga kan sakon maipanggop situwa tagu utdat nangkadadaga kingkingwa na utdat tagum sin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ot dummatong situn Damasco un awad kan siya dit naikanglita palubus dat aap-apun di padi un manokma utdat losana manuttuwa kan sika.” ");
INSERT INTO kmk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yoong imbagan ud Apu kan siya un, “Umoy ka! Gaputa siya’d pinilik un manselbi kan sakona umoy mangipatigammu utdit maipanggop kan sakon sidat bokona Judio kan sidat al-ali da kan pati pay sidat tagu un kaganakan Israel. ");
INSERT INTO kmk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ot ipailak kan siya dat losana ligat un sagapaḻona maipagapu’t mangipatigammuwana utdit maipanggop kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Utdi, inummoy si Ananias. Nilumnok sidit boḻoy Judas ot inyagpad na dit ima na kan Saulo un kanana’n, “Sunuda Saulo, si Apu Jesus un nampaila kan sika utdit daḻan nu un umoy situ ud nangibaun kan sakon daḻapnu makaila ka uman kan daḻapnu mapnu ka utdit pannakabalin Ispiritu Santu.” ");
INSERT INTO kmk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ot dagusa inggaw naotdaga kama’t siksik di ikan un nanligwat sidat atan Saulo ot makaila umanon. Manon summikad ot nampabunyag. ");
INSERT INTO kmk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Utdiyon, nangan ot gummilog. Utdiyon nakaigaw si Saulo si piga’n aḻgaw sidat manuttuwa ud Damasco. ");
INSERT INTO kmk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Inummoy sidat sinagogan di Judio ot dagusa inlapu na un nantudtudu maipanggop kan Jesus un kanana’n, “Siya ud Anak Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ot nasnasdaaw dat losana tagu un nakagngoḻ sidat imbaga na ot nampaim-imus da pay lawan un, “Bokon kada siyatu dit tagu’n mamalpaligat sidat manuttuwa kan Jesus sidin Jerusalem? Ot bokon kada dummatong situ daḻapnu umoy na dokmaan dat manuttuwa asina punguwona idallay dida’t dat aap-apun di padi ud Jerusalem?” ");
INSERT INTO kmk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yoong ummamod dit kabooḻan kan tuḻod Saulo un mantudtudu ot taḻona nasnasdaaw dat Judio un inggaw sidin Damasco ot naid makaabak kan siya utdit pammanoknok na un si Jesus siya dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lumabas man adu’n aḻ-aḻgaw, nandatdatong dat Judio ot nantutulagan da un patoyon si Saulo. ");
INSERT INTO kmk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Inaḻgaw kan linabi un linopang dat Judio dit pudayan sidiya ili daḻapnu patoyon da si Saulo. Yoong napatagimmuwan si Saulo utdit panggop da un koon kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Adi kad gaputa kama’t di, ummoy dat buyut na inaḻa si labi ot innigga dat dit baḻuḻang asida inuyud sidit lasin dit gibaw dit boboḻoy. ");
INSERT INTO kmk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kaysan si Saulo utdin Jerusalem ot dumatong man pinadas na un maibuḻun okyan sidat manuttuwa’t di. Yoong adi da tuttuwaon un osaon un manuttuwa ot kummimut da’l losan kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yoong ummoy Bernabe tinuḻungan si Saulo ot ummoy na intuḻud sidat apostoles. Ot impalawag Bernabe kan dida nu in-inon dit nan-iilan Saulo kan Apu Jesus sidit daḻan kan nakabagbagaana kan siya. Impadamag na pay kan dida dit tuḻod Saulo un nangiwalagawag maipanggop kan Jesus sidin Damasco. ");
INSERT INTO kmk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kad manipud sidiyon nawayaon si Saulo un naibuḻubuḻun sidat apostoles sidin Jerusalem ot taḻona natuḻoda nangiwalagawag sidit maipanggop kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nakabagbaga pay kan nakadisdiskutil sidat Judio un Griego dit bagbaga da yoong adi da maabak ot pinanggop da un patoyon. ");
INSERT INTO kmk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Utdit natigammuwan dat buḻun na un manuttuwa dit panggop da, intuḻud da si Saulo ud Cesarea asida pinadaḻan sidin Tarso. ");
INSERT INTO kmk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kad sidiyon gumminok dit mapalpaligatan dat manuttuwa utdin losana lakub Judea, Galilea kan Samaria. Gapu utdit tuḻung ud Ispiritu Santu napabilog dit pammati da. Ummaduadu dit bilang da kan intultuluy da un dit nanuttuwa kan nangiyogyat kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ot si Pedro payon, ummoy nandakdak sidat boboḻoya namiling sidat tagun Apudyus. Ot utdiya mandakdakana ummoy na pay inila dat inggaw sidin Lidda. ");
INSERT INTO kmk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Insangkat na utdi dit osa’n laḻaki’n mangngadan kan Eneas un adina’n pulus makakuliit ot uumbog ullawa un waḻu’n dagunon. ");
INSERT INTO kmk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kinnanan Pedro kan siya un, “Eneas, papiyaon dika kan Jesu Kristu. Gumangun ka ot lukutom nat obok nu.” Ot dagusa gummangun si Eneas. ");
INSERT INTO kmk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kad sadat losana iLidda kan iSarona un nakaila kan Eneas un kummiyaon, nanuttuwa da kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Utdin Joppe pay, ininggaw osa’n manuttuwa un babai un mangngadan si Tabita. Sad kokkoona ullawa kampay dat napiya kan tumuḻung sidat nakapus. ");
INSERT INTO kmk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Utdiya timpu’n ininggawan Pedro utdin Lidda nansakit si Tabita ot natoy. Immos da dit ladag na asida umoy inyobog sidit nanginngatu’n kuwaltun dit boḻoy na. ");
INSERT INTO kmk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Madamag man dat manuttuwa’t di un awad si Pedro utdin Lidda, nangibaun da si duwa’n laḻaki un umoy mangibaga kan siya un kanan da un, “Pangaasim ta daḻasoma maitung-ud kan dikami’t din Joppe.” Ta bokona adayu din Joppe utdin Lidda. ");
INSERT INTO kmk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Utdi, nanlakkat si Pedro un naibuḻun kan dida. Utdit dumatong da, indallay da si Pedro utdit nanginngatu’n kuwaltu. Mampaibil dat losana bilug un nangalibungbung kan Pedro ot impaila da dat kagoy kan udum paya silup un kingwan Tabita sidit katattagu na. ");
INSERT INTO kmk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yoong pinaḻaksun Pedro dida’l losan asina nampalintumonga nanluwaḻu. Magangput man, inatubang na dit ladag ot kinnanana’n, “Tabita, gumangun ka.” Indiyat Tabita dat ata na ot maila na man si Pedro, nantupak. ");
INSERT INTO kmk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Induwawan Pedro dit ima na kan siya asina tinuḻungana summikad. Utdiyon inayagana dat manuttuwa kan sadadit losana bilug ot impaila na kan dida si Tabita un matatagu. ");
INSERT INTO kmk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kadon nandinadinamag tuwa napasamak sidin losana lakub Joppe ot adu dat nanuttuwa kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nabayag un ininggaw si Pedro utdin Joppe utdit boḻoy ud Simon un mambobosaḻ si geddang. ");
INSERT INTO kmk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Utdin Cesarea, ininggaw osa’n tagu un mangngadan kan Cornelio un kapitan di simbungguyana suldadun di Roma un mangadan si Bungguy dat iyItalia. ");
INSERT INTO kmk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bokona Judio yoong kanayuna mandaydayaw kan Apudyus, pada na pay sidat losana kaboḻoy na. Taḻona nalaay sidat nakapusa Judio kan kankanayuna manluwaḻu kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sin-aḻgawan sidit mandangwilis kama si nan-in-inop si Cornelio ot nalawaga naila na dit anghel Apudyus un nilumnok un kanana kan siya un, “Cornelio.” ");
INSERT INTO kmk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Amod dit kimut na un nangitukkoḻ sidit anghel ot kinnanana un, “Ngadan na Apu?” Summungbat dit anghel un kanana’n, “Dingngoḻ Apudyus danat luwaḻum kan tigammu na nat kinalaay nu utdan nakapus. ");
INSERT INTO kmk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mangibaun ka’t tun satun si umoy ud Joppe ta ida ayagan dit mangngadan si Simon un ngadnon da pay si Pedro. ");
INSERT INTO kmk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Awada sangailin Simon un mambobosaḻ si geddang. Adani’t din igid baybay dit boḻoy na.” ");
INSERT INTO kmk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Utdit nabatin dit anghel, inayagan Cornelio dat duwa’n babbaun na kan osa’t dat manselselbi kan siya’n suldadu un kanayuna mandaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Imbagan Cornelio kan dida dit napasamak ot imbaun na dida ud Joppe. ");
INSERT INTO kmk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mabigat man sidit manaddaḻanan dat naibaun un umadani daon Joppe, inummoy si Pedro utdit otop dit boḻoy Simon si mamatuk daḻapnu manluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nabitil un dit manluwaḻu ot piyaona okyana mangan. Yoong utdit madama un maisagsagana dat kanona, inggaw impailan Apudyus kan siya un kama si in-inop. ");
INSERT INTO kmk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naila na un nabuktan langit ot inggaw dumobadoba’t tun pita un kama si dakoḻa uḻos un naikisin dat opata siku na. ");
INSERT INTO kmk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Utdit daḻom na inggawa losan dat nadumaduma’n ayam kan losan dat kumayap kan dat tumaud un adin dat Judio mabalina isida. ");
INSERT INTO kmk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Inggaw ginga’n nambagbaga’n kanana kan siya un, “Pedro sumikad ka ot mamalti ka si isidam.” ");
INSERT INTO kmk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yoong kinnanan Pedro un, “Adik makwa Apu, ta naid payyan nanganak sidan maibilanga naisaw onnu adi mabalina makan sidit lintog mi.” ");
INSERT INTO kmk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nambagbaga payyan dit ginga ot kanana’n, “Adim ibilang un naisaw nat imbilang Apudyus un nadaḻus.” ");
INSERT INTO kmk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Namitlu tuwa naipasamak ot maabus man, dagusa nagulluy un naipangatu dit kama si uḻos ud langit. ");
INSERT INTO kmk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Madama mana makassomosomok si Pedro nu singngadan dit kaipooyan dituwa naila na, dummatong dat imbaun Cornelio ta indasan da dit boḻoy Simon ot summisikad daon sidit luwangan. ");
INSERT INTO kmk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Utdi, inimus da nu awad sangaili’t di ut mangngadan si Simon Pedro. ");
INSERT INTO kmk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Makainsomosomok payyan si Pedro utdit naila na, utdit imbagan dit Ispiritu Santu kan siya un, “Awad da ud tuḻu’n tagu un mangina-inap kan sika. ");
INSERT INTO kmk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dumoba ka ot adika mansumdi un maitung-ud kan dida ta sakon ud nangibaun kan dida.” ");
INSERT INTO kmk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Utdi, dummoba si Pedro ot kinnanana utdat tagu un, “Sakon nat inainapon yu. Apay, ngadan nat ibaga yu?” ");
INSERT INTO kmk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ot summungbat da un, “Imbaun dikami kan Cornelio un kapitan mi un susuldadu. Siya’d osa’n tagu un nalintog, mandaydayaw kan Apudyus kan lislispituwon da’l losana Judio. Imbilin dit anghel Apudyus kan siya un awison dika utdin boḻoy na daḻapnu dongḻona’n losan ud ibagam.” ");
INSERT INTO kmk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Utdi pinaḻnok Pedro dida ot nakaigaw da kan siya utdiya labi. Mabigat man nanlakkat si Pedro ot naitung-ud kan dida ot inggaw da pay uduma manuttuwa’n iJoppe un namuḻun kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mabigat man summaaḻ da Pedro ud Cesarea. Uuwayon Cornelio dida pati utdat kakabbagiyana kan adani’n gagayyom na un inawis na. ");
INSERT INTO kmk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Utdit lumnok okyanon si Pedro utdit boḻoy, ummabat si Cornelio kan siya ot nanlukgub sidit atubang Pedro un mandayaw kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Yoong pinasikad Pedro un kanana’n, “Sumikad ka, ta taguwak paya lawa’n padam.” ");
INSERT INTO kmk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Utdi un makabagbagbagaan Pedro kan Cornelio nilumnok sit boḻoy ot naila na dat adu’n tagu un naammung. ");
INSERT INTO kmk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ot kinnanan Pedro kan dida un, “Titiggammu yu un adin dit lintog mi un Judio ud ipalubus un mangay-ayaw onnu makabuḻbuḻun kami utdan bokona Judio. Yoong impailan Apudyus kan sakon un masapula maid ibilang ku ut naisaw onnu kaniyaw. ");
INSERT INTO kmk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Siya’d gapuna’n utdit pinaayagak, naitung-udaka dagus un maid nanduwaduwaak. Ot imusok ud nu apay pinaayag yu ud sakon?” ");
INSERT INTO kmk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Summungbat si Cornelio un kanana’n, “Tuḻu’n aḻgawon ud napalabas si kama’t tuwa olas sidit manlulluwaḻuwak situn boḻoy ku si mandangwilis. Kakḻata lawa’n nasanikad ud osa’n laḻaki un nambadut si makasiling kan napoḻkapoḻkas sidit atubang ku. ");
INSERT INTO kmk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ot kinnanana’n, ‘Cornelio, dingngoḻ Apudyus danat luwaḻum kan tigammu na nat kinalaay nu utdan nakapus. ");
INSERT INTO kmk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mangibaun ka ud Joppe si umoy mangayag sit tagu un mangngadan si Simon un ngadnon da pay si Pedro un sangailin Simon un mambobosaḻ si geddang un adani’t din igid baybay dit boḻoy na,’ kinnanan dit anghel. ");
INSERT INTO kmk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Siyatu’d gapuna un dagusa pinaayag ku ud sika ot napiya mampay ta inan-anusama dummatong. Ot sinsatun antu kami un iillan Apudyus un manguuway un dumngoḻ sidat imbilin Apudyus un ipatigammum kan dikami.” ");
INSERT INTO kmk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Utdi, nambagbaga si Pedro un kanana’n, “Sinsatun taḻona maawatakon un maid tagu’t idumduman Apudyus, ");
INSERT INTO kmk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","nu adi awatona nat singngadan na mana mandayaw kan siya kan mangwa utdan nalintog, singngadan na mana ili’t tun pita ud nanligwatana. ");
INSERT INTO kmk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tigammu yuwon dit Nabaḻu’n Damag un impatigammun Apudyus kan dikami’n kaganakan Israel un, mabalin un maikappiya taku kan Apudyus maipagapu’t dit kingwan Jesu Kristu un siya’d Apun da’l losana paloswa. ");
INSERT INTO kmk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tigammu yu dat pasamak sidin losana Judea. Nanlapu dat pasamak sidin Galilea utdit magangput si Juan un nantudtudu maipanggop si bunyag. ");
INSERT INTO kmk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","“Ot tigammu yu pay dit maipanggop kan Jesus un iNazaret un siya’d pinilin Apudyus ot intod na kan siya dit Ispiritu Santu kan initdana si pannakabalin. Ot inummoy sidan losana igaw un nankokkokwa si nabaḻu kan pinapiya na dat tagu’n pinalpaligat Satanas. Nakwa na di gaputa ininggaw si Apudyus kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ot dikami ud mamanoknok sidat losana kingkingwa na utdan losana ili mi un Judio kan pati utdin Jerusalem. Panoknokan mi un pinatoy dat pada mi un Judio utdit nampailansaan da kan siya utdit kulus. ");
INSERT INTO kmk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yoong maikatlu’n aḻgaw man pinaungaḻ Apudyus ot nampaila kan dikami. ");
INSERT INTO kmk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Bokona nampaila utdan losana tagu nu adi dikami ullawa un pinilin Apudyus un kustigu, dikami un nakaubung kan siya un nangan kan umminum sidit ummungaḻanaon. ");
INSERT INTO kmk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Binilin dikami kan siya un mangiwalagawag sidit Nabaḻu’n Damag maipanggop kan siya utdat tagu kan ipanoknok mi un siya dit pinilin Apudyus un mangukum nu timpu na utdat matattaguwan kan dat natoy. ");
INSERT INTO kmk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pati dat losana propetan Apudyus sidit, kustiguwan da un sat tagu’n manuttuwa kan mantaḻgod kan Jesus mapakawan da utdat basuḻ da maipagapu utdit pannakabalin dit ngadan na.” ");
INSERT INTO kmk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Utdi un madama payyan si Pedro un mampalpalawag kan dida, ummoy si Ispiritu Santu ininggaw sidat losana mandodongngoḻ sidat tudtudu na. ");
INSERT INTO kmk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ot sadat Judio un manuttuwa’n nanligwat Joppe un naibuḻun kan Pedro, nasnasdaaw da ta pati dat bokona Judio naitod pay dit Ispiritu Santu kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ta dingngoḻ da un mambagbaga da si sabsabali’n bagbaga kan idaydayaw da dit kinangatun Apudyus. Utdi imbagan Pedro kan dida un, ");
INSERT INTO kmk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Singngadan nat makaiyapa utdit mabunyagan datu si danum? Ta ulay dida, inawat da payon si Ispiritu Santu un pada taku.” ");
INSERT INTO kmk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Utdi, binilin Pedro dida un mabunyagan da un mangipaila utdit manuttuwaan da kan Jesu Kristu. Maabus da man un mabunyagan nakapangpangngaasi da un makaigaw okyan kan dida si piga’n aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nagngoḻ dat apostoles kan sadat sunuda manuttuwa utdin Judea un nanuttuwa pay dat bokona Judio utdit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ot dumatong man si Pedro ud Jerusalem sinuḻagan dat Judio un umampayun sit lintog maipanggop sit matuḻgiyan di tagu. ");
INSERT INTO kmk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ot kanan da kan siya un, “Apay un pinasangaili ka kan nakaubung ka un nangan sidan bokona natuḻgiyan?” ");
INSERT INTO kmk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Utdi impakaawat Pedro kan dida un inatontad dat losana naipasamak manipud sidit lapḻapu na un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ininggawak sidin ili’d Joppe utdit, ot namingsana manlulluwaḻuwak nailak si kama’t in-inop dit dakoḻa uḻosa naikisin dit opata siku na un nanligwat langit ot dumobadoba utdit ininggawak. ");
INSERT INTO kmk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Binilbilik dit daḻom na ot nailak dat naamu kan tanana ayam, sadat kumayap kan tumaud. ");
INSERT INTO kmk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Utdi, nagngoḻ ku dit ginga un kanana kan sakona, ‘Sumikad ka Pedro ta mamalti ka si isidam.’ ");
INSERT INTO kmk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Yoong summungbatak un, ‘Adik makwa nat Apu, ta naid payyan nanganak sidan maibilanga naisaw onnu Adina mabalina makan sidit lintog mi.’ ");
INSERT INTO kmk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Yoong summungbat payyan dit ginga un nanligwat langit un kanana’n, ‘Adim ibilang un naisaw nat imbilang Apudyus un nadaḻus.’ ");
INSERT INTO kmk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Namitlu tuwa naipasamak kan sakon ot utdiyon nampangatu dit uḻos ud langit. ");
INSERT INTO kmk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Utdi payona olas dummatong sidit boḻoya inggawak dat tuḻu’n tagu un naibaun kan sakon un nanligwat Cesarea. ");
INSERT INTO kmk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ot imbagan Ispiritu Santu kan sakon un maitung-udak kan dida un adiyak mangidumduma. Binuḻunanak pay sidatun onoma susunuda manuttuwa’n iJoppe un inummoy ud Cesarea. Ot dumatong kami man, nilumnok kami utdit boḻoy Cornelio. ");
INSERT INTO kmk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Ot imbaga na kan dikami dit nangil-ana’t dit anghel un sumisikad sidit boḻoy na un kanana kan siya un, ‘Mangibaun ka ud Joppe ut umoy mangidallay sit tagu un mangngadan si Simon un ngadnon da pay si Pedro. ");
INSERT INTO kmk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ta siya ud mangibaga utdit damaga maigapuwan dit mataguwam kan Apudyus pati utdat losana kaboḻoy nu,’ kanan dit anghel kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Utdiya madamaak un mampalpalawag, dummoba si Ispiritu Santu kan dida un padan dit napasamak kan ditaku utdit luglugi na. ");
INSERT INTO kmk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Utdiyon nagasmok ku dit kinnanan Apu Jesus un, ‘Si Juan nambunyag si danum yoong mabunyagan kayu kan Ispiritu Santu.’ ");
INSERT INTO kmk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“Ot nu intod Apudyus kan dida dit Ispiritu Santu un padan dit nangitdana kan ditaku utdit nanuttuwaan taku kan Apu Jesu Kristu, singngadan ku kad okyan un manuganggang kan Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Utdit nagngoḻan dat Judio tu, naid dit suḻag da ot nandaydayaw da kan Apudyus un kanan da’n, “Boot intod pay an Apudyus sidat bokona Judio dit gundaway da un mambabawi kan matagu si inggaingga.” ");
INSERT INTO kmk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Utdit nan-asiwaḻak dat manuttuwa maipagapu’t dit napaligatan da un nanlapu’t dit napatoyan Esteban, nakagtong da inggana’t din ili’n Fenicia, Chipre kan Antiokia. Ot impatigammu da dit Nabaḻu’n Damag sidat Judio ullawa. ");
INSERT INTO kmk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yoong awad da ud uduma manuttuwa un Judio un nanligwat Chipre kan Cirene un inummoy ud Antiokia ot inwalagawag da pay sidat bokona Judio dit Nabaḻu’n Damag un maipanggop kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tinuḻungan Apudyus dida ot aduadu dat iyAntiokia un nanuttuwa kan ummunud kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Utdit magngoḻan dat manuttuwa’t din Jerusalem tuwa damag imbaun da si Bernabe utdin Antiokia. ");
INSERT INTO kmk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Dumatong man sidi, nataḻok sit naila na dit kinakaasin Apudyus sidat manuttuwa. Ot binagbagaana dida un itultuluy da okyan un manuttuwa kan Apu Jesus sidit losana somsomok da. ");
INSERT INTO kmk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nabaḻu’n tagu si Bernabe kan napnu’t pannakabalin ud Ispiritu Santu kan nabakod dit pammati na. Ot gapu kan siya ummaduadu dat bilang dat manuttuwa kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Utdiyon inummoy Bernabe ininap si Saulo utdin Tarso. ");
INSERT INTO kmk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Maodasana man indallay na ud Antiokia. Ot sin-daguna nakaam-ammung da utdat manuttuwa’t di ot aduadu dat tagu’n tinudtuduwan da. Sadin Antiokia ud ummuna’n nangingadanan da utdat manuttuwa kan Kristu si “Kristianu.” ");
INSERT INTO kmk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Utdi payona timpu gummusad dat propetan Apudyus ud Antiokia un nanligwat Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Osa kan dida ud mangngadan kan Agabo un siya dit nangipadtu gapu’t dit pannakabalin Ispiritu Santu un awad amoda uḻat un dumatong situn lubung. Ot tuttuwa’n natungpal tu utdit nangiyapuwan Claudio un Ali ud Roma. ");
INSERT INTO kmk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kadon, ingkoddong dat manuttuwa un kada-osa kan dida masapula mangitod si tuḻung sidat susunud da un manuttuwa un inggaw Judea sigun sit kabooḻan di osa un maituḻung. ");
INSERT INTO kmk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ot siya’d kingwa da. Kadon impaiyoy da kan da Bernabe kan Saulo dit nauḻup sidat lallakay di manuttuwa utdin Judea. ");
INSERT INTO kmk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Utdiya timpu inlapun Ali Herodes un mampaligat sidat uduma manuttuwa kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pinaputuḻ na si Santiago un sunud Juan si ispada. ");
INSERT INTO kmk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Utdit mailan Herodes un nataḻok dat Judio utdit kingwa na, pinadokmana pay si Pedro. Napasamak tu utdit Piyestan di Tinapay un maid kamos na si bubud. ");
INSERT INTO kmk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Utdit nadokmaanon si Pedro paimbaḻud na asina pinaandog sidat mansisinnukat un opata bungguy di suldadu un sin-oppat dat dit simbungguyan. Ta panggop Herodes un kuison si Pedro utdit atubang dat tagu nu kobaas dit Piyestan di Nalausan. ");
INSERT INTO kmk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Yoong utdiya naipukukan Pedro utdit babaḻḻudan, taḻona impapasnok pay dat manuttuwa un nangiluwaḻuwaḻu kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Utdi un labi un daan Herodes un mangilaksun kan Pedro utdit atubang dat kaaduwan, masusuyop si Pedro un napingil si duwa’n kinawad sidit boḻaat dat duwa’n suldadu kan inggaw da pay uduma suldadu un man-aandog sit sooban dit babaḻḻudan. ");
INSERT INTO kmk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Utdi, kakḻata lawa’n nampaila dit anghel Apudyus ot nasilawan dit igaw na. Inggoyagoy dit anghel dit abaḻana un namukaw kan siya un kanana’n, “Daḻasom! Gumangun ka.” Ot dagusa napkis dat kinawad sidat iman Pedro. ");
INSERT INTO kmk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Utdiyon kinnanan dit anghel kan siya un, “Igakos nu nat badut nu ot iggam nat kapatus nu.” Ot tinungpal Pedro di. Kadon, “Mangkagoy ka ot tung-udonak,” kinnanan dit anghel. ");
INSERT INTO kmk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Utdi, tinung-ud Pedro dit anghel un lummaksun sidit babaḻḻudan. Adina tigammu un tuttuwa dit koon dit anghel ta kanana’t dit somsomok na nu man-in-in-inopa lawa. ");
INSERT INTO kmk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Utdit nalausan da dit umuna kan maikagwa’n aandogan dat suldadu, dintong da dit baḻyanga sooban un umoy sit ili. Nambukat pay lawan dit sooban ot lummaksun da. Utdit manaddaḻanan da nadtong da dit osa’n kaḻsa ot kakḻata lawa’n nabatin dit anghel kan Pedro. ");
INSERT INTO kmk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Utdi, naawatan Pedro un tuttuwa dit naipasamak kan siya ot kinnanana’t dit somsomok na pay lawan un, “Naid duwaduwak un imbaun Apudyus dit anghel na un umoy mangilisi kan sakon kan Herodes kan sidat losana pangpanggopon dat Judio un koon kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Apaman un nadlaw Pedro un tuttuwa dit napasamak kan siya, inummoy sidit boḻoy Maria un inan Juan un ngadnon da pay si Marcos. Aduadu un tagu dat naammung sidi un manlulluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Utdit mangkogkog si Pedro utdit onob, inummoy dit baba-unon un babai’n mangngadan si Roda inila. ");
INSERT INTO kmk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mailasinana man dit gingan Pedro, Adina imbukat dit onob sit amoda taḻok na ta nanoddaka nangulin daḻapnu ipadamag na un awada sumisikad si Pedro utdit lasin. ");
INSERT INTO kmk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Ay, natingang ka nin,” kinnanan da kan siya yoong impapilit na un taḻona tuttuwa. Ot kinnanan da un, “Ay, sat anghel na nat.” ");
INSERT INTO kmk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nakainkogkokogkog kampay si Pedro ot ida man ibukat dit onob, naila da un siya ot taḻona nasnasdaaw da. ");
INSERT INTO kmk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sininyasana dida utdit ima na un walling da asina inyuḻ-uḻnug kan dida nu inon Apudyus nangilaksun kan siya utdit babaḻḻudan. Ot kinnanana pay kan dida un, “Ibaga yu tu kan Santiago kan dat uduma susunud.” Utdiyon kaysan ot inummoy si sabali un igaw. ");
INSERT INTO kmk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mabigat man taḻona mabulubulung dadit suldadu un nangandog kan Pedro nu apay un naid. ");
INSERT INTO kmk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Utdi pinainap Herodes si Pedro yoong utdit naid indasan da kan siya, binistigal na dat suldadu ot imbilin na un mapatoy da. Magangput man di, nanlakkat si Herodes ud Jerusalem sidin Judea ot ummoy ininggaw Cesarea. ");
INSERT INTO kmk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Utdiya timpu, amoamod dit suḻag Herodes sidat iTiro kan iSidon. Yoong piyaon dat tagu’t di un umaḻu kan siya ta sadit ili na ussiya dit manligwatan dit kanon da. Isunga sat kingwa da, ummuna un ginayyom da si Blasto ta siya dit mangipangat sidit boḻoy Herodes daḻapnu tuḻungana dida. Utdiyon nan-os-ossaan da un inummoy kan Herodes daḻapnu man-iinnaḻu da. ");
INSERT INTO kmk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Utdit dinumtong dit aḻ-aḻgawa ingkoddong Herodes, nambadut sit badut di ali ot ummoy nantupak sidit trono na ot nampalawag sidat tagu. ");
INSERT INTO kmk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sadat tagu’t di gapappakuyan da un kanan dan, “Bokona tagu ullawa’n mambagbaga nu adi apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ot gaputa adin Herodes intod kan Apudyus dit dayaw, dagusa pinansakit dit anghel Apudyus ot naogsan dit long-ag na inggana’t natoy. ");
INSERT INTO kmk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yoong nantultuluya summayak dit ugud Apudyus ot ummaduadu dat manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Utdit natungpaḻon da Bernabe kan Saulo dit naibaunan da utdin Jerusalem, nangulin da ud Antiokia ot indallay da si Juan un mangngadan pay si Marcos. ");
INSERT INTO kmk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Utdat manuttuwa ud Antiokia, inggaw da ud propetan Apudyus kan mimistulu kan dida un maibilangan da Bernabe, Simeon un ngadnon dat Nangisit, Lucio un iCirene, Manaen un dummakoḻ sit boḻoy gubinnadul Herodes un buḻubuḻun na manipud sit kaabeng da kan si Saulo. ");
INSERT INTO kmk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sin-aḻgawana mandaydayawan da kan Apudyus kan manlanganan da un mangan un manluwaḻu, imbagan Ispiritu Santu kan dida un, “Isina yu da Bernabe kan Saulo ta awad talibasu’n intuding ku un koon da.” ");
INSERT INTO kmk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Magangput man dit manlanganan da un mangana manluwaḻu, inyagpad da dat ima da utdit uḻun da Bernabe kan Saulo asida dida pinalisgud. ");
INSERT INTO kmk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Utdi, gummusad da Bernabe kan Saulo ud Seleucia ta indaḻan ud Ispiritu Santu dida. Ot manipud Seleucia nanlugan da si bapul un inummoy sidin pugun Chipre. ");
INSERT INTO kmk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dumatong da man ud Salamina utdin Chipre, inummoy da inwalagawag dit ugud Apudyus sidit sinagogan dat Judio. Ot ininggaw pay si Juan un mangngadan si Marcos un katuḻungan da. ");
INSERT INTO kmk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Dinakdak da dit pugu aginggana si dummatong da utdin ili ud Pafo. Utdi inabat da tun osa’n Judio un mansasalumangka un mangngadan Bar-Jesus un man-ag-agin propeta. ");
INSERT INTO kmk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Satuwa tagu gayyom dit gubinnadul sidiya pugu un si Sergio Paulo. Nasiliba tagu dit gubinnadul ot pinaayag na da Bernabe kan Saulo ta piyaona un dongḻon dit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yoong sadit mansasalumangka un si Elimas (siya’d ngadan na utdin bagbaga un Griego) sinuganggang na dida ot pinadas na un lappodan dit gubinnadul daḻapnu adina manuttuwa kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yoong si Saulo un mangadngaddanan pay si Pablo, napnu utdit pannakabalin Ispiritu Santu ot intutukkoḻ na dit mansasalumangka, ");
INSERT INTO kmk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ot kinnanana kan siya un, “Sika un Anak Satanas, sika’d kabusuḻ di losana kinalintog. Annat kan sika dat losana kalasin di kinasikap kan man-aallew. Kamunay kampaya lawa’n balbaliktadom dan kinatuttuwa un maipanggop kan Apudyus ot itudtudum dat tuli! ");
INSERT INTO kmk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sinsatun dusaon dika kan Apudyus ot mangkuḻap ka un adika makaila si padda si piga’n aḻgaw.” Ot dagusa kinumḻop dit man-iilan Elimas ot mandapudapudap un manginap si mangiwid kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Utdit nailan dit gubinnadul dit napasamak, nanuttuwa. Ta taḻona nasnasdaaw sidat tudtudu maipanggop kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Utdiyon tinengyan da Pablo kan dat buḻun na ud Pafo ot nambapul da un inummoy Perge utdin Pamfilia. Yoong tinengyan Juan Marcos dida’t di ot nangulin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yoong nantuluy da Pablo kan Bernabe ot manipud Perge inummoy da ud Antiokia utdin Pisidia. Utdit aḻgaw un iillongan di Judio nilumnok da utdit sinagoga ot nantupak da. ");
INSERT INTO kmk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Magangput mana maibasa dit naikanglita lintog Moses kan dat ingkanglit dat propetan Apudyus, nangibaun dat pangat di sinagoga si umoy mangibaga kan da Pablo un, “Susunud, nu awad ud maibaga yu si mampataḻgod si angos sidatu’n tagu, pangngaasi yu ta ibaga yu.” ");
INSERT INTO kmk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Utdi, summikad si Pablo ot sininyasana dat tagu un guminok da ot inlugi na un nambagbaga’n, “Kabbuḻunak un kaganakan Israel kan losan kan dikayu’n bokona Judio un mandaydayaw kan Apudyus, dumngoḻ kayu okyan. ");
INSERT INTO kmk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Si Apudyus un mandaydayawan taku’n kaganakan Israel pinili na dat ginnapuwan taku utdit aw-awe un mambalina tagu na. Utdit ininggawan da ud Egipto un bokona ili da binindisyunana dida kan ummaduadu da. Impuyut na dida un lummaksun sidiya ili utdit amoda pannakabalin na. ");
INSERT INTO kmk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ot umoya opatapuḻu’n daguna innan-anusana dida utdit igawa maid amo taguna ulay nu makabbasubasuḻ da. ");
INSERT INTO kmk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dumatong da man Canaan tinuḻungana dida un nangabak sidat pitu’n iliyan sidi ot impakuwa na kan dida diya pita. ");
INSERT INTO kmk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Umoya opata gasut ya limampuḻu’n dagun ud lummabas manipud inummoyan da ud Egipto agingga na utdiya timpu un nangitdan Apudyus kan dida utdiya pita da. “Maabus man di, paimpangat Apudyus dida utdat kuis agingga’t dit timpu’n nampangatan Samuel un propetan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Utdiyon nangdaw da si ali un mangiyapu kan dida ot painsaad Apudyus kan Samuel si Saulo un abeng Kis un kaganakan Benjamin. Ot siya ud nangiyali kan dida si opata puḻu’n dagun. ");
INSERT INTO kmk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Utdit kinaan Apudyus si Saulo un ali, painsaad na si David un mangiyali kan dida. Ot kama’t tu dit imbagan Apudyus maipanggop kan David, ‘Si David un abeng Jesse ud tagu’n taḻona piyaok ta tungpaḻona da’l losana piyaoka pakwa kan siya.’ ");
INSERT INTO kmk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Manligwat sidat kaganakan dit David dit imbaun Apudyus un umoy managu kan ditaku’n kaganakan Israel ot siya si Jesus un insapatana’t dat ginnapuwan taku. ");
INSERT INTO kmk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Utdit daan Jesus manlugi’n mantudtudu, inwalagawag Juan sidat losana kaganakan Israel un masapula mambabawi da utdat basuḻ da kan mampabunyag da. ");
INSERT INTO kmk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Utdit dandani un gangputon Juan dit talibasu’n naibaunana, kanana’t dat tagu un, ‘Singngadan ku utnat kanan yu? Bokona sakon dit Kristu un uuwayon yu nu adi awada maitagtagnob kan sakon ot adiyak pay maikali un mangussag sidit sandalyas na,’ kinnanan ud Juan. ");
INSERT INTO kmk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Isunga susunud,” kinnanan Pablo. “Dikayu un kaganakan Abraham, kan dikayu’l losana bokona Judio uttu un mandaydayaw kan Apudyus, ditaku ud nangitdan Apudyus situwa damag maipanggop sidit managuwana kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ta sadat Judio utdin Jerusalem kan dat pappangat da, adi da nabigbig si Jesus un siya dit Managu. Adida pay naawatan dat maibasbasa kan dida utdit sinagoga nu aḻ-aḻgawa iillongan un ingkanglit dat propeta maipanggop kan siya, ot tinungpal da dadiya naikanglit sidit ingkoddong da un mapatoy si Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ot ulay nu naid indasan da si gapun di mamatoyan da, impapilit da un kindaw kan Pilato un papatoy na. ");
INSERT INTO kmk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Magangput da mana tungpaḻona losan dadit naikanglit sit ugud Apudyus un maipasamak kan siya, indoba da utdit kulus ot ummoy da innilbon. ");
INSERT INTO kmk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Yoong pinaungaḻ Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ot nampaila si adu’n aḻ-aḻgaw sidat buḻun na un nanligwat Galilea un umoy Jerusalem. Didaon dat mangipanoknok kan siya utdat kaganakan Israel situn satun. ");
INSERT INTO kmk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ot antu kami’t tu un mangidatong sidit Nabaḻu’n Damag un sadit insapatan Apudyus sidat ginnapuwan taku’n Judio, ");
INSERT INTO kmk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tinungpal naon kan ditaku’n kaganakan da utdit namaungaḻana kan Jesus. Ta naikanglit pay sidit maikagwa’n Salmo un kanana’n, ‘Sika ud Anak ku. Sinsatun ipailak un sakon ud Amam.’ ");
INSERT INTO kmk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ot nu maipanggop sit namaungaḻan Apudyus kan Jesus un adi naon matoy obos, awad naikanglit sit ugud Apudyus un kanana’n, ‘Itdok kan dikayu dit nasantuwana bindisyun un insapatak kan David un maid duwaduwa na un matungpal.’ ");
INSERT INTO kmk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ot kanana payyan sidin Salmo un, ‘Adim ipalubus un maḻpos sit lobon dit nasantuwan un manselselbi kan sika.’ ");
INSERT INTO kmk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bokona si David tun ug-ugudona’t tu ta utdit nagangput David un kingwa dat impakwan Apudyus kan siya, natoy ot innilbon da utdit sog-on dat aappu na ot naḻpos dit ladag na. ");
INSERT INTO kmk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yoong si Jesus un pinaungaḻ Apudyus, Adina naḻpos. ");
INSERT INTO kmk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Isunga susunud, masapula matigammuwan yu un maipagapu kan Jesus, mapakawan dat basuḻ taku. ");
INSERT INTO kmk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","On, singngadan na mana mantaḻgod kan siya mawayaan sidat losana basuḻ na un adi mabalina makwa utdit umunudana utdat lintog Moses. ");
INSERT INTO kmk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Siya’d gapuna’n ammaan yu daḻapnu Adina maipasamak kan dikayu dat ingkanglit dat propetan Apudyus un, ");
INSERT INTO kmk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ilan yu, dikayu un dumuduḻa! Masdaawan kayu utdan kook yoong siya payon un matoy kayu. Onta adiyu un taḻon patiyon dan kook utdan timpu yu ulay nu awad mangipakaawat kan dikayu.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Utdit lumaksun da Pablo kan Bernabe utdit sinagoga, inawis dat tagu dida un dumatong da payyan sit dumoḻdoḻa aḻ-aḻgawa iillongan ta dogdog-an da dat intudtudu da. ");
INSERT INTO kmk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Utdit mangkadaḻan dat tagu un nadatdatong sidit sinagoga, naitung-ud kan da Pablo kan Bernabe dadit adu’n Judio kan bokona Judio un naawisa ummunud sit lintog dat Judio. Binagbagaan da Pablo dida un ituluy da un mantaḻgod sit kinakaasin Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Utdit maisongwata aḻ-aḻgawa iillongan, istay ta losan dat tagu’t dit ili un dummatonga umoy mandongoḻ sidit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mailan man dat Judio dat adu’n tagu amod dit apaḻ da ot sinuganggang da dat imbagan Pablo asida pay inin-insultu. ");
INSERT INTO kmk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yoong taḻona natuḻod kampay da Pablo kan Bernabe un nambagbaga un kanan da’n, “Lobbong na un dikayu dit umuna’n maipatigammuwan dit ugud Apudyus. Yoong gaputa adiyu mangwaan, ibilang yu un adi kayu maibagay un maitdan sit mataguwana maid kigad na. Ot tengyan mi dikayu ta umoy kami’t dan bokona Judio. ");
INSERT INTO kmk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ta siyatu dit imbilin Apudyus kan dikami utdit naikanglit un ugud na un kanana’n, ‘Insaad ku ud sika un manilaw sit somsomok dat bokona Judio daḻapnu maipagapu kan sika taguwon Apudyus dat losana tagu’t tun lubung.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Utdit magngoḻ dat bokona Judio tu, amod dit taḻok da ot indaydayaw da dit ugud Apudyus. Ot losan dadit pinilin Apudyus un matagu si inggaingga, nanuttuwa da. ");
INSERT INTO kmk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Utdi, summayasayak dit ugud maipanggop kan Apu Jesus sidat losana boboḻoy sidi. ");
INSERT INTO kmk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yoong sinugsugan dadit Judio dat matangada babai un mandaydayaw kan Apudyus kan sadat mabigbigbiga laḻaki utdiya ili. Ot inlapu da un pinalpaligat da Pablo kan Bernabe ot yinagyag da dida. ");
INSERT INTO kmk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Utdi, ingkagkag da Pablo kan Bernabe dat gabu utdat iki da un mangipaila un nangamung da pay lawanon, asidakaysan ud Iconio. ");
INSERT INTO kmk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yoong ulay nu kama’t di, amoamod dit taḻok dat manuttuwa’n nataynan kan napnu da utdit pannakabalin ud Ispiritu Santu. ");
INSERT INTO kmk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Dumatong da man ud Iconio, ummoy da uman sidit sinagogan di Judio nantudtudu ot aduadu dat Judio kan bokona Judio un nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yoong mangwa man dat Judio un adi manuttuwa, sinugsugan da dat bokona Judio un lumaweng sidat sunuda manuttuwa’t di. ");
INSERT INTO kmk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yoong ulay nu kama’t di, nabayaga iniinggaw da Pablo kan Bernabe utdiya ili. Natuḻod da un nantudtudu maipanggop kan Apu Jesus. Ot pinanoknokan Apudyus un tuttuwa dat itudtudu da maipanggop sit mangkakaasina ta initdana dida’t pannakabalin un mangkokwa si nakaskasdaawa mangilasinan kan am-amug. ");
INSERT INTO kmk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yoong sadat tagu’t diya ili nangkagwa da, ta sadat udum inampayunan da dat Judio ot sadat udum inampayunan da pay dat apostoles. ");
INSERT INTO kmk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Utdiyon, sadat Judio kan bokona Judio padana pay sidat pappangat pinanggop da un paligaton kan batubatuwon dat apostoles. ");
INSERT INTO kmk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Yoong natigammuwan da Pablo ot nambutik da ud Listra kan Derbe utdin Licaonia kan sidan uduma ili un sakup na. ");
INSERT INTO kmk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ot intuluy da un inwalagawag dit Nabaḻu’n Damag sidi. ");
INSERT INTO kmk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Utdin Listra, inggaw osa’n laḻaki un napikon manipud sit naiyabengana ot Adina un taḻon napadasan kummiyang. ");
INSERT INTO kmk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mantutupak sidi un dudumngoḻ sidat ugud Pablo. Ot utdit mailan Pablo un awad pammati na un mapapiya, intutukkoḻ na, ");
INSERT INTO kmk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","asina dinangsoḻa imbaga un, “Sumikad ka.” Dagusa lummigwat dit tagu ot nangkiyakiyang. ");
INSERT INTO kmk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mailan man dat adu’n tagu dit kingwan Pablo impappakuy da utdit ugud da pay lawana iLicaonia un, “Nambalin si tagu dat apudyus ot dummoba da kan ditaku.” ");
INSERT INTO kmk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ot nginadanan da si Bernabe kan Zeus un osa’t dat apudyus da. Ot gaputa si Pablo dit ammagbagaon, nginadanan da kan Hermes. ");
INSERT INTO kmk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Utdi, sadit padin dit apudyus da un si Zeus un awad si timplu utdit lasin didit ili, nan-idatong si baka kan da sabsabung sidit pudayan ta piyaona kan dat tagu un idatunan da Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Yoong matigammuwan man da Bernabe kan Pablo dit umoy dadit tagu koon, binelke da dat badut da asida nanoddaka ummoy sit kawadan dat tagu un nangipakuy un, ");
INSERT INTO kmk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Susunud, apay koon yu tu! Tagu kami’l lawa un pada yu. Antu kami’t tu un mangipatigammu utdit Nabaḻu’n Damag daḻapnu adi kayuwon mandaydayaw si kama’t tu un maid si selselbi nu adi mandaydayaw kayu okyan kan Apudyus un matatagu. Siya’d nangwa’t tun langit, pita, baybay kan losana awad kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Utdat kaykaysana timpu pinalubusan Apudyus dikayu un bokona Judio un mangwa utdat piyaon yu un koon. ");
INSERT INTO kmk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yoong adina impalubus un maid mangipanoknok sit kina-apudyus na, ot ipaila na utdat nabaḻu un kokkoona, ta mangitod si udan kan wadawada apit, mangtod si adu’n makan kan nalagsaka aangson.” ");
INSERT INTO kmk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yoong ulay nu kama’t di dit imbagan da Pablo, naligatan da payon un nangatipa utdat tagu’n nandatun kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yoong dummatong dat Judio un nanligwat Iconio kan Antiokia un lakub Pisidia ot adu dat tagu’n naawis da un mangkapon kan dida. Kadon, binatubatu da si Pablo ot utdit kanan da nu natoyon, nilagayad da un inlaksun sidit ili. ");
INSERT INTO kmk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yoong utdit ummoy dat manuttuwa inalibungbung, gummangun ot nangulin sidit ili. Mabigat man kaysan da kan Bernabe ud Derbe. ");
INSERT INTO kmk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Inwalagawag da Pablo kan Bernabe dit Nabaḻu’n Damag sidin Derbe ot adu dat naawis da un nanuttuwa. Utdiyon nangulin da ud Listra asida kanan Iconio kan Antiokia ud Pisidia. ");
INSERT INTO kmk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinabilog da dat aangson dat losana manuttuwa utdatuwa ili ot binagbagaan da dida un itultuluy dan dit manuttuwa kan Jesus. Ot kanan da un, “Masapula mansagapaḻ taku si adu’n ligat asi taku maidagamung sin mangiyapuwan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kada gimung di manuttuwa un inoy da Pablo nanutuk da utdat lalallakay si mangipangat. Nanlangan da un nangan un nangiluwaḻu kan dida asida intaḻgod dida kan Apu Jesus un siya’d mantaḻgodan da. ");
INSERT INTO kmk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Utdiyon nangoy da Pablo utdin Pisidia ot dummatong da utdin Pamfilia. ");
INSERT INTO kmk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Inwalagawag da dit Nabaḻu’n Damag sidin Perge asida gummusad sidin Atalia. ");
INSERT INTO kmk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ot manipud Atalia nambapul da un nangulin Antiokia utdin Siria. Sadiya igaw dit nangitaḻgodan dat manuttuwa kan dida daḻapnu tuḻungan Apudyus dida utdit talibasu da un siya dit kaggangput da. ");
INSERT INTO kmk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Utdit dumatong da ud Antiokia pinandatdatong da dat manuttuwa ot impadamag da dat losana impakwan Apudyus kan dida kan nu in-inon Apudyus nangitod sidat bokona Judio si gundaway da un manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ot nabayaga nakaigaw da utdat manuttuwa’t diya ili. ");
INSERT INTO kmk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Utdi un iinggawan da ud Antiokia inggaw da ud laḻaki un dummatonga nanligwat Judea. Intudtudu da utdat sunuda manuttuwa’t di un kanan da un, “Nu adi kayu matuḻgiyan, adin Apudyus dikayu taguwon ta siya’d ipakwan dit lintog Moses.” ");
INSERT INTO kmk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Adin da Pablo kan Bernabe inampayunan di ot siya’d taḻona nakasinnungbatan da kan dida. Utdi, nan-aanamungan da un ibaun da Pablo kan Bernabe kan sadat uduma iyAntiokia un umoy sidin Jerusalem daḻapnu umoy da makabagbaga utdat apostoles kan sidat lalallakay di manuttuwa’t di maipanggop situwa banag. ");
INSERT INTO kmk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Utdi, pinalisgud da dida ot inoy da ud Fenicia kan Samaria un nangipadamag sidit manuttuwaan dat bokona Judio ot amoamod dit taḻok dat susunuda manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sumaaḻ da man sidin Jerusalem, naanggoanggom dat manuttuwa, dat apostoles kan dat lalallakay di manuttuwa un namadatong kan dida. Ot imbagan da Pablo dat losana impakwan Apudyus kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Yoong inggaw da ud manuttuwa un kabbuḻunan dit bungguy dat Fariseo un summikada kanan da un, “Masapula matuḻgiyan dan bokona Judio ot maibilin kan dida un tuttuwaon da dit lintog Moses.” ");
INSERT INTO kmk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Utdi, nadatdatong dat apostoles kan dat lalallakay ta babagbagaon da tuwa banag. ");
INSERT INTO kmk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Utdit maabus dit nabayaga sisinnungbat da, summikad si Pedro un kanana’n, “Susunud, titiggammu yu un pinilin Apudyus sakon kan ditaku’t dit un umoy mangiwalagawag sit Nabaḻu’n Damag sidan bokona Judio daḻapnu magngoḻan da kad, manuttuwa da. ");
INSERT INTO kmk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ot si Apudyus un manigammu’t aangson di tagu impaila na un inawat na dida utdit nangitdana kan Ispiritu Santu un padan dit kingwana kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Naidon naidumaan taku kan dida, ta dinalusan Apudyus dat basuḻ da gapu’t nanuttuwa da un padan dit kingwa na kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ot nu kama’t di, apay nangatngatu taku kad nu si Apudyus? Apay un paligatan taku dan bokona Judio utdatu un lintog un adi taku kan dat ginnapuwan taku matungpal? ");
INSERT INTO kmk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ditaku kad, tuttuwaon taku un taguwon ditaku kan Apudyus maipagapu utdit kaasin Apu Jesus, ot pada na pay kan dida.” ");
INSERT INTO kmk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Gummiginnok dat losana naammung ot nandodongngoḻ da utdat impadamag da Pablo kan Bernabe maipanggop sidat nakaskasdaawa mangilasinan kan am-amuga pinakwan Apudyus kan dida utdit ininggawan da utdat bokona Judio. ");
INSERT INTO kmk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Utdit magangput da un mambagbaga, gumminga si Santiago un kanana’n, “Susunud, dumngoḻ kayu. ");
INSERT INTO kmk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Imbagan Simon Pedro kan ditaku’d kanad dit nangipail-an Apudyus sidit man-iipotog na utdan bokona Judio ta nangaḻa kan dida si mambalina tagu na. ");
INSERT INTO kmk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Satuwa nakwa maiyannatup sidit ingkanglit dat propetan Apudyus sidit un, ");
INSERT INTO kmk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Kanan ud Apu un, ‘Nu maabus tu, mangulinak, ot tuudok uman dit naḻba un mangiyapuwan David. Ipaḻ-og ku dat nayam-an, ot tuudok. ");
INSERT INTO kmk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kad sidi, inapon dat losana tagu’d sakona Apu, losan dat bokona Judio un pinilika mambalina taguk.’ ");
INSERT INTO kmk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Siyatu’d kanan ud Apu un nangipatigammu utdatu utdit aw-awe.” ");
INSERT INTO kmk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ot intuluy Santiago un, “Isunga san kasomsomkaka osa, adi taku okyan paligatan dan bokona Judio un manuttuwa kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nu adi sulatan taku’l lawa dida un adi da mangan sidan naidatun si sinan-apudyus; adi da sog-onon dan bokona asawa da; adi da mansida si napsoḻa ayam onnu daḻa. ");
INSERT INTO kmk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ta manipud sit aw-awe, maibasa kan maitudtudu datu un lintog Moses sidin sinagogan di kailin-ili nu Aḻgawa Iillongan.” ");
INSERT INTO kmk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Utdiyon, nan-aanamungan dat apostoles kan dat lalallakay pati utdat losana manuttuwa’t di un mamili da utdat buḻun da si maibuḻun kan da Pablo kan Bernabe un umoy Antiokia. Pinili da dat duwa utdat pangat da un sada Silas kan Judas un ngadnon da pay un Barsabas. ");
INSERT INTO kmk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ot siyatu dit insulat da: “Kan dikayu’n susunuda manuttuwa un bokona Judio utnat ili’d Antiokia, Siria kan Cilicia. Dikami un susunud yu un apostoles kan lalallakay di manuttuwa uttun Jerusalem datun mansulat kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nagngoḻan mi un awad da ud uduma kabbuḻunan mi un ummoy sinat ot naulaw kayu maipagapu utdat intudtudu da. Bokona imbaun mi dida. ");
INSERT INTO kmk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Siya’d gapuna un nammimiting kami ot nan-aampayunan mi un mamili si ibaun mi kan dikayu un maibuḻun kan da Bernabe kan Pablo un potpotgon mi un buḻun. ");
INSERT INTO kmk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Sadatuwa duwa, imbados da dit long-ag da maipagapu utdit manselbiyan da kan Apu Jesu Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ot ibaun mi kan dikayu da Judas kan Silas ta dida ud mismu’n mangilawlawag sidatun insulat mi kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nampada dit piyaon Ispiritu Santu kan sat piyaon mi un adimi dikayu paligatan malaksig sidatu un siya’d masapula tuntunan yu: ");
INSERT INTO kmk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","“Adi kayu mangan si naidatun sidan sinan-apudyus; adi kayu mansida si daḻa onnu ayam un napsoḻ kan adiyu sog-onon nat bokona asawa yu. “Nabaḻu ud mambanagan yu nu tungpaḻon yu datu. Abus na tu.” ");
INSERT INTO kmk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Utdi, pinalisgud da dida ot ummoy da ud Antiokia. Dumatong da man, pinandatdatong da’l losan dat manuttuwa asida intod kan dida dit sulat. ");
INSERT INTO kmk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Utdit mabasa da, nantattaḻok da gaputa makapabos-oḻ si angos dat imbaga da. ");
INSERT INTO kmk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ot gaputa propetan Apudyus da Judas kan Silas, adu dat imbagbaga da un nampabos-oḻ sit somsomok kan nampabilog sit pammati da. ");
INSERT INTO kmk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Utdit maikabas dit piga’n duminggu un nakaikgawan da utdi, pinalisgud dat susunuda manuttuwa dida un kanan da’n, si Apudyus okyan mangaayyuwan kan dida. Ot nangulin da utdat nangibaun kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Yoong si Silas ingkoddong na un inggaw yan. ");
INSERT INTO kmk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Sada Pablo kan Bernabe iniinggaw da utdin Antiokia ot intudtudu kan inwalagawag da dit ugud maipanggop kan Apu Jesus un buḻun da dat uduma manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lumabas man piga’n aḻgaw, imbagan Pablo kan Bernabe un, “Umoy ta bilingon dat sunuda manuttuwa utdan kailin-ili un nangiwalagawagan ta utdit ugud maipanggop kan Apu Jesus sidit, ta tigammuwon ta nu in-inon daon.” ");
INSERT INTO kmk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Piyaon Bernabe un idallay si Juan Marcos un buḻun da. ");
INSERT INTO kmk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Yoong adin Pablo piyaon un idallay gaputa tinengyana dida’t dit sin Pamfilia un adina payyan nagangput dit talibasu da. ");
INSERT INTO kmk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Utdi, taḻona nansinsinnungbat da un duwa ot siya’d gapun dit nangkaswayan da. Indallay Bernabe si Juan Marcos ot nambangka da un kaysan Chipre. ");
INSERT INTO kmk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ot si Pablo pinili na si Silas un buḻun na. Pinalisgud dat manuttuwa dida ot intaḻgod da dida kan Apudyus un siya’d tumuḻung kan dida utdan losana ayan da. ");
INSERT INTO kmk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ot dinakdak da Pablo ud Siria kan Cilicia un nampabilog sidit pammatin dat manuttuwa’t di. ");
INSERT INTO kmk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Inummoy da Pablo ud Derbe asida kingwanan Listra ot inggaw osa’n manuttuwa’t di un mangngadan Timoteo. Judio dit ina na kan manuttuwa pay, yoong Griego dit ama na. ");
INSERT INTO kmk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Taḻona nabaḻbaḻu ud kaugudan Timoteo utdat manuttuwa’d Listra kan Iconio. ");
INSERT INTO kmk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ot piyaon Pablo un idallay si Timoteo ta buḻun da. Ot gaputa tigammun dat losana Judio utdi un Griego dit amana, pinatuḻgiyana. ");
INSERT INTO kmk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Utdiyon, kada ili un ummoyan da, impatigammu da utdat manuttuwa dat bilin un nan-aanamungan dadit apostoles kan dat lalallakay ud Jerusalem daḻapnu unudon da. ");
INSERT INTO kmk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Utdi, napabilog dit pammatin dat manuttuwa ot inaḻgawa umaduadu da. ");
INSERT INTO kmk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Utdi, dinakdak da Pablo din lakub Frigia kan Galacia ta adin Ispiritu Santu pinalubusan dida un man-iwalagawag sidit Nabaḻu’n Damag sidin probinsiya’d Asia. ");
INSERT INTO kmk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Utdit dakngon da din boddong Misia pinadas da un lumnok sin Bitinia yoong adin payyan dit Ispiritun Apu Jesus dida pinalubusan. ");
INSERT INTO kmk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Isunga linausan da ud Misia ot nangkaw-as da un kaysan Troas. ");
INSERT INTO kmk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ot lumabi man, nailan Pablo si kama’t in-inop ud osa’n laḻaki un iMacedonia un sumisikad kan makapangpangngaasi kan siya un kanana’n, “Mangaasi ka ud ta umoy ka uttun Macedonia ta tuḻungan dikami.” ");
INSERT INTO kmk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Apaman un maabus diya kama’t in-inop ud Pablo, naawatan mi un piyaon Apudyus un umoy mi iwalagawag dit Nabaḻu’n Damag sidat tagu’d Macedonia ot dagus kami un nanlakkat. ");
INSERT INTO kmk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nambapul kami manipud Troas ot nandawos kami ud Samotracia asi mi ingkaw-as ud Neapolis sit mabigat. ");
INSERT INTO kmk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Manipud sidi, nanaddaḻan kami un kaysan ud Filipos un dakoḻana ili’t din distritun di Macedonia kan sinakup di Roma. Ininggaw kami’t diya ili si piga’n aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Utdit aḻ-aḻgawa iillongan lummaksun kami’t dit lasin didiya ili utdit dupit dit wangwang ta siya kanu’d kawadan dit luluwaḻuwan. Nantupak kami ot nakabagbaga kami utdat naammunga babai un dintong mi. ");
INSERT INTO kmk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Osa utdat mandodongngoḻ kan dikami ud mangngadan si Lydia un iTiatira un manlakḻaku si nangingina un luput kan osa’n mandaydayaw kan Apudyus. Impakaawat Apudyus dat imbagbagan Pablo ot nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Utdi, nampabunyag si Lydia pati utdat losana kabboḻoy na. Maabus man, inawis na dikami un kanana’n, “Nu ibilangak un gattoka manuttuwa utdit Apu, umoy taku’t din boḻoy mi.” Ot impapilit na un indallay dikami. ");
INSERT INTO kmk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sin-aḻgawan un ummoyan mi utdit igawa luluwaḻuwan, inabat dikami si puyunga baḻasanga sinakayan di nadadaga ispiritu ot makwa na ud mampadtu. Adu dit mapilak dit apuwona utdit mampadpadtuwana. ");
INSERT INTO kmk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tinungtung-ud na dikami kan da Pablo un mampappakuya kanana’n, “Babbaun dit kangattuwana Apudyus datu un tagu ot ipatigammu da kan dikayu nu in-inon Apudyus managu kan dikayu.” ");
INSERT INTO kmk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Piga’n aḻgawa siya’d kingkingwa na di aginggana’t adin Pablo nakaanus ot sininagung na dit baḻasang asina kinnanan sit nadadaga ispiritu un, “Bilinok sika utdin ngadan Apu Jesu Kristu, lumaksun ka utnata baḻasang.” Ot dagusa lummaksun dit nadadaga ispiritu. ");
INSERT INTO kmk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yoong utdit mailan dat apuwona un maidon dit mamilakan da, dinokmaan da da Pablo kan Silas ot linagayad da dida un indallay sit palasaan un indatag sidat opisyal didiya ili. ");
INSERT INTO kmk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ot imbaga da kan dida un, “Judio datu ot umoy da manggulu uttun ili taku. ");
INSERT INTO kmk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Itudtudu da dat kadawiyan da un adin dit lintog taku’n iRoma ipalubusa unudon taku.” ");
INSERT INTO kmk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Utdi, naidoga pay dat adu’n tagu un namabpabasuḻ kan da Pablo kan Silas ot binelken dat opisyal un pinantiway dida asida dida pinasabid. ");
INSERT INTO kmk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Magangput man un sabisabidan da dida paimpabaḻud da dida ot binilin da dit man-aandog un taḻona aandogana dida. ");
INSERT INTO kmk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Utdit maawat dit man-aandog dit bilin indallay na dida utdit daḻodaḻom dit babaḻḻudan asina ginilpit dit iki da si tolosu un kayu. ");
INSERT INTO kmk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Manggawa man dit labi, manlulluwaḻu da Pablo kan Silas kan mangkankanta da un mandaydayaw kan Apudyus un dodongḻon dat uduma baḻud dida. ");
INSERT INTO kmk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yoong kakḻata lawa un nabilobilog dit lunig un nangiyugayug sidit babaḻḻudan ot naligad dat pannan na. Ot dagusa nabuktan dat losana sooban kan napkis dat kinawad sidat losana baḻud. ");
INSERT INTO kmk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Utdi, napukaw dit man-aandog ot nailana un nabuktana losan dat sooban dit babaḻḻudan ot kanana nu nambutik dat losana baḻud. Utdi, sinukmut na dit ispada na ta patoyona okyanon dit long-ag na pay lawan. ");
INSERT INTO kmk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Yoong impakuy Pablo un, “Adim pasibgan nat long-ag nu ta antu kami’l losan situ.” ");
INSERT INTO kmk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Utdi, nampaidatong dit man-aandog si silaw ot dagusa nilumnok sidit babaḻḻudan ot inummoy nampalintumong sit atubang da Pablo kan Silas un mamilpilpil ta amod dit kimut na. ");
INSERT INTO kmk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Utdiyon inlaksun na dida ot inimus na kan dida un, “Apu, ngadan nat masapula kook daḻapnu taguwonak kan Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ot kinnanan da kan siya un, “Manuttuwa ka kan Apu Jesus ot taguwon dika kan Apudyus kan pati utdat kaboḻoy nu.” ");
INSERT INTO kmk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Utdi, intudtudu da dit ugud maipanggop kan Apu Jesus kan dida un losana mangkakabboḻoy. ");
INSERT INTO kmk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Utdi payona gawan labi indallay dit man-aandog dida sit kawadan dit danum ot binuḻuwana dit sugat da. Ot maabus man di, nampabunyag dit man-aandog kan dat losana kaboḻoy na. ");
INSERT INTO kmk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Utdiyon indallay na da Pablo kan Silas sidit boḻoy da ot sinunadana dida si kinan da. Ot amod dit taḻok dit man-aandog kan dat kaboḻoy na ta manuttuwa daon kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mabigat man imbilin dat opisyal di Roma utdat pulis un umoy da ibaga’t dit man-aandog un, “Pawayaam danata tagu.” ");
INSERT INTO kmk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Utdi imbagan dit man-aandog sit babaḻḻudan kan Pablo un, “Imbilin dat opisyal mi un wayaak dikayu kan Silas. Mabalin yuwona manaḻan un kapkapiya.” ");
INSERT INTO kmk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Yoong imbagan Pablo utdat pulis un, “Bokona napanoknokana nakabasuḻ kami yoong pinasabid dikami’t dit atubang di adu’n tagu. Romano kami yoong paimbaḻud dikami ot sinsatun ilimod daon un padaḻnon dikami. Adina makwa nat! Masapula sadat opisyal di Roma ud umoy situ mangilaksun kan dikami.” ");
INSERT INTO kmk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Utdi, impadamag dat pulis dit imbagan Pablo utdat opisyal di Roma ot magngoḻ da man un tagu’n di Roma da Pablo kan Silas, kummimut da. ");
INSERT INTO kmk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ot inummoy da nampakpakaoli kan dida utdit kingwa da. Inlaksun da dida’t dit babaḻḻudan ot imbaga da kan dida un tengyan da di un ili. ");
INSERT INTO kmk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Utdiyon lummaksun da Pablo kan Silas sidit babaḻḻudan ot nandawos da utdit boḻoy Lydia. Ot utdit naila da dat susunuda manuttuwa binagbaga da dida si nampabos-oḻ sit somsomok da asida kaysan. ");
INSERT INTO kmk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Dinakdak da Pablo kan Silas din ili’d Amfipolis kan Apolonia asidadintong din Tesalonica un kawadan dit osa’n sinagogan di Judio. ");
INSERT INTO kmk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kama’t dit gagangaya kokkoona, ummoy si Pablo utdit sinagoga ot tuḻu’n Aḻgawa Iillongan un nakadiskutil sidat tagu un imbasal na utdit naikanglita ugud Apudyus dat sungbat na. ");
INSERT INTO kmk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Inlawlawag na kan pinanoknokana un masapula mapaligatan kan mapatoy dit mangadan si Kristu asina umungaḻ kan katoy. Ot kinnanan pay Pablo un, “Satu un Jesus un ibagabagak kan dikayu, siya dit Kristu.” ");
INSERT INTO kmk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ot sadat udum sidat Judio nanuttuwa da utdat imbagan Pablo ot naidagamung da kan dida. Adu pay dat Griego un mandaydayaw kan Apudyus kan mabigbigbiga babai dat nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yoong ummapaḻ dat Judio un adi manuttuwa ot pinandatdatong da dat nauyunga mandoyadoyaw ot ginaygay da dida un manggulu’t dit ili. Linnok da dit boḻoy Jason ta inapon da da Pablo kan Silas daḻapnu ilaksun da dida utdat tagu. ");
INSERT INTO kmk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ot utdit naid maodasan da kan dida, linagayad da si Jason kan sadat udum pay un manuttuwa’t di ot indallay da dida’t dat opisyal di ili ot impappakuy da un, “Sadat tagu’n manggulugulu’t dat losana ili un ayan da antu da payon situn ili taku, ");
INSERT INTO kmk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ot sinangailin Jason dida’t din boḻoy na. Sumugangganga losan datu sit lintog dit Ali ud Roma. Kanan da un, awad sabali’n ali un mangngadan si Jesus.” ");
INSERT INTO kmk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Utdit magngoḻ dat opisyal kan dat losana tagu’t di dit imbaga da, nabulung da. ");
INSERT INTO kmk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ot pinanpiyansan dat opisyal sidi un ili si Jason kan dat buḻun na asida pinadaḻan dida. ");
INSERT INTO kmk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lumabi man, dagusa pinadaḻan dat manuttuwa da Pablo kan Silas sidin Berea. Ot sumaaḻ da man sidi, inummoy da utdit sinagogan di Judio. ");
INSERT INTO kmk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Un-unnay pay dat Judio utdin Berea nu sadat Judio utdin Tesalonica ta taḻona piyaon da’n mandongoḻ sidat tudtudun da Pablo. Ot kaaḻgaw-aḻgaw un adaḻon da dit naikanglita ugud Apudyus daḻapnu ilan da nu tuttuwa dat ug-ugudon da Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Adu kan dida dat nanuttuwa kan adu pay dat Griego un matangada babai kan dat laḻaki un nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yoong magngoḻan man dat Judio utdin Tesalonica un inwalagawag pay Pablo dit ugud Apudyus sidin Berea, inummoy da uman sidi ot ginaygay da dat tagu un manggulu. ");
INSERT INTO kmk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Utdi, dagusa pinadaḻan dat manuttuwa da Pablo utdin dupit baybay yoong sada Silas kan Timoteo ininggaw da. ");
INSERT INTO kmk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Sadat tagu un ummoy nangituḻud kan Pablo nangkigad da ud Atenas. Ot utdit daan da un mangulin ud Berea imbilin Pablo kan dida un maitung-ud un dagus kan siya da Silas kan Timoteo. ");
INSERT INTO kmk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Utdiya manguuwayan Pablo kan da Silas kan Timoteo utdin Atenas taḻona mabulubulung gapu’t dit kinaadun dat sinan-apudyus un nailana utdiya ili. ");
INSERT INTO kmk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Isunga ummoy sit sinagoga nakabagbagbaga kan nantudtudu utdat Judio kan bokona Judio un mandaydayaw kan Apudyus. Kaaḻgaw-aḻgaw pay un umoy sit palasaan un nakabagbagbaga kan nantudtudu utdat tagu’n naiyaspuḻ un nangoy sidi un mamiya’n mandongoḻ. ");
INSERT INTO kmk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ininggaw da pay uduma mimistulu’n ngadnon da si Epicureo kan Estoico ud nakadiskutil kan siya ot kanan dat udum kan dida un, “Ngadan kanun tun palpalawagon tun aginngangatu’n tagu?” Ot kanan pay dat udum un, “Mistulun nin di sabali’n apudyus.” Imbaga da tu ta inwalagawag Pablo dit maipanggop kan Jesus kan sadit umungaḻana. ");
INSERT INTO kmk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Utdi, inawis da un indallay si Pablo utdit ammung dat pappangat un ngadnon da’t Areopago ot kanan da un, “Tigammuwon mi ud tun bagu’n maitudtudu un ibagbagam. ");
INSERT INTO kmk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ta annat da ud kaddongoḻ mi un sabali’n banag ot piyaon mi ud un tigammuwon nat kaipooyan da.” ");
INSERT INTO kmk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Siyadi dit kanan da ta sadat tagu’d Atenas kan sadat kakkaili’t di, maida lawa’d tigammu da un koon nu adi sat mandodongngoḻ onnu man-ibagabaga utdat bagu un damag. ");
INSERT INTO kmk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Utdi, summikad si Pablo utdit atubang da ot kanana’n, “Mailak un dikayu’n iyAtenas relihiyoso kayu. ");
INSERT INTO kmk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ta utdit nangay-ayawak situn ili yu kan nan-iilak utdat igawa mandaydayawan yu utdan apudyus yu nailak pay dit dadattunan un kama’t tu dit naikanglit, ‘Satu ud dadattunan sit Apudyus un naid yan makatigammu.’ Sadi un Apudyus un daydayawon yu un adiyu tigtigammu, siyaon tun ibagak kan dikayu. ");
INSERT INTO kmk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Siya si Apudyus un nangwa’t tun lubung kan losana nilaun na kan siya ud Apu utdin langit kan situn pita kan bokona inggaw sidat timplu un kingwan di tagu. ");
INSERT INTO kmk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Adi na masapul dan makwan di tagu un manselbi kan siya gaputa siya pay lawan mangitod si mataguwan kan dat losana kasapulan di tagu. ");
INSERT INTO kmk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Pinaloswa na dit osa’n tagu un siya’d nanligwatan dat losana tagu’t dan kailin-ili uttun lap-at tun pita. Ot ingkoddong na pay lawan dit timpu un mantulayan dat kailin-ili kan boddong dat igaw da. ");
INSERT INTO kmk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Pinaloswa na dida daḻapnu siya ud inapon da okyan. Ta dakoḻ dit namnama na un maodasan da utdin mangina-inapan da yoong sat katuttuwaana bokona adayu si Apudyus si ulay singngadan na kan ditaku. ");
INSERT INTO kmk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kama’t dit kanan da un, ‘Gapu kan siya matatagu taku, manggidu taku kan awad taku.’ Kama pay sit kanan dat nalalainga umaantu un buḻun yu un, ‘Ta ulay ditaku, aabeng na pay ditaku.’ ");
INSERT INTO kmk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kadon, gaputa aabeng ditaku kan Apudyus, masapula adi taku somsomkon un si Apudyus kapadan dan sinan-apudyus un buḻawan, pilak kan batu un nakwa’l lawa maisayun sit laing kan somsomok di tagu. ");
INSERT INTO kmk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ta utdit timpu’n naid payyan tigammun dat tagu kan Apudyus, Adina kinankankanan dat basuḻ da yoong sinsatunon bilinona dan losana tagu’t tun pita ta mandadaoli da ot lipsutan da dat basuḻ da. ");
INSERT INTO kmk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ta ingkoddongon Apudyus dit aḻ-aḻgaw un paukum na dat losana tagu’t tun pita utdit pinili na un ukum un nalintog si man-uukum. Pinanoknokana utdat losana tagu un siya dit pinili na utdit pinaungaḻ na kan katoy.” ");
INSERT INTO kmk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Utdit magngoḻan da dit imbagan Pablo maipanggop sit umungaḻan dat matoy inyeemeng dat udum yoong kanan dat udum un, “Piyaon mi payyan un dongḻon tun maipanggop situ.” ");
INSERT INTO kmk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Utdiyon, tinengyan Pablo dit ammung dat pappangat. ");
INSERT INTO kmk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yoong naitung-ud dat udum kan siya ot nanuttuwa da. Osa kan dida si Dionisio un osa utdat Areopago kan osa’n babai un mangngadan si Damaris. Inggaw da pay uduma tagu un nanuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Magangput man di, tinengyan Pablo ud Atenas ot kaysan sidin Corinto. ");
INSERT INTO kmk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Natigtigammu na utdi si Akila un osa’n Judio un iPonto kan sat asawa na un si Priscila. Kaligligwat da ud Italia ta imbilin Emperador Claudio un tengyan dat losana Judio ud Roma. Maabus man un mantitigtigammu da naitung-ud si Pablo kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ot gaputa nampapada dit kewaaḻ da un mankokokwa si tulda, nakaigaw si Pablo kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ot kada Aḻgawa Iillongan umoy si Pablo mantudtudu utdat tagu’t dit sinagoga ta piyaona’n awison dat Judio kan Griego un manuttuwa kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sumaaḻ man da Silas kan Timoteo un nanligwat Macedonia, inyossaanon Pablo un nan-iwalagawag sidit ugud Apudyus. Pinanoknokana utdat Judio un si Jesus dit Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yoong utdit suganggangon kan in-insultuwon dat tagu, intoḻkag na dat gabu utdit badut na un mangipaila un nangamung daon ot kinnanana kan dida un, “Basuḻ yu pay lawan nu madusa kayu. Bokonona basuḻ ku. Manipud sinsadinon tengyak dikayu ot umoyak manwalagawag sidan bokona Judio.” ");
INSERT INTO kmk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Utdi tinaynana dit sinagoga ot nan-atun sidit boḻoy sit sog-on dit sinagoga un kuwan dit osa’n bokona Judio un mangngadan kan Ticio Justo un osa’n mandaydayaw kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ot si Crispo un pangaton dit sinagoga nanuttuwa kan Apudyus pati utdat kaboḻoy na. Adu pay dat nanuttuwa kan nabunyagan sidat iCorinto un nakagngoḻ sidit inwalagawag Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sinlabiyan, imbagan Apudyus kan Pablo si kama’t in-inop un, “Adika kumimut. Itulutuluy nu un mantudtudu ot adim gongdaan. ");
INSERT INTO kmk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ta awadak kan sika ot maid tagu si mamaligat kan sika’t tu ta adu dan tagu un manuttuwa kan sakon situwa ili.” ");
INSERT INTO kmk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Utdi, sindagun ya kagogwa un iniinggaw si Pablo utdi un nangitudtudu utdat tagu utdit ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Yoong utdit naisaad si Galion un gubinnadul ud Acaya, nandatdatong dat Judio un adi manuttuwa ot nan-aampayunan da un dokmaan si Pablo asida ummoy indatag sit uukkuman. ");
INSERT INTO kmk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ot kinnanan da’n, “Satuwa tagu aw-awisona dan tagu un mandaydayaw kan Apudyus udsi wagas un maisuganggang sit lintog.” ");
INSERT INTO kmk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Yoong utdit sumungbat okyanon si Pablo kinnanan Galion sidat Judio un, “Nu awad okyan nadagson si nakabasuḻan onnu nangwaan dituwa tagu si nadadag kalobbongak okyana dongḻon nat ibaga yu un Judio. ");
INSERT INTO kmk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Yoong nu maipanggopa lawa utdan ugud, ngadngadan kan linlintog yu pay lawana Judio nat manlililiyan yu, dikayu pay lawan manguḻnus. Bokona sadanata banag nat umoy ku ukumon.” ");
INSERT INTO kmk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Utdi pinaḻaksun na dida utdit uukkuman. ");
INSERT INTO kmk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Utdiyon dinokmaan da si Sostenes un pangat di sinagogan di Judio asida sinabisabidan sidit atubang dit uukkuman. Yoong adin Galion winiliwili dida. ");
INSERT INTO kmk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Maabus man di, nabayag un nakaigaw yan si Pablo kan dida’d Corinto. Utdiyon, nampalanga umoy Siria un buḻun na da Priscila kan Akila. Utdin Cencrea dit nanluganan dat bapul yoong utdit daan da un manaḻan pinapulug Pablo dit uḻu na ta awad ud insapatana kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Dumatong da man sidin Efeso dummoba da ot ummoy si Pablo utdin sinagoga’n nanudtudu kan nakadiskutil sidat Judio. Siyadi ud nanengyana kan da Priscila kan Akila. ");
INSERT INTO kmk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kindaw da un makaigaw yan kan dida yoong ummadi na. ");
INSERT INTO kmk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Utdi, nampalang si Pablo ot kanana kan dida un, “Mangulinak kan dikayu nu ipalubus Apudyus.” Utdi, nambapul ot kaysan. ");
INSERT INTO kmk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Dumatong man ud Cesarea nanagada si Pablo ud Jerusalem un ummoy nangila utdat manuttuwa asina gummusada nangaw-as sidin Antiokia ud Siria. ");
INSERT INTO kmk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Maabus man dit piga’n aḻgawa ininggawana’t di, kaysan umanon ot dinakdak na dan probinsiya’d Galacia kan Frigia un nampabilog sit pammatin dat losana manuttuwa’t di. ");
INSERT INTO kmk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Utdi, inggaw osa’n Judio un mangngadan kan Apolos un iyAlejandria un dummatong ud Efeso. Nalainga mampalawag kan adu pay dit tigammuna utdit naikanglita ugud Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Natudtuduwan sidit maipanggop kan Jesus yoong sad kigad tigammuna ullawa sadat intudtudun Juan sidit mambunbunyag. Yoong ulay nu siya’l lawa’d tigammu na di un maipanggop kan Jesus, Adina maag-aggagan un mangipalawag kan kustu dit itudtudu na. ");
INSERT INTO kmk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Isunga ilugi na mana mantudtudu utdit sinagoga’t din Efeso, natuḻoda mampalawag. Yoong magngoḻ man da Priscila kan Akila, indallay da utdit boḻoy da ot inlawlawag da un kustu kan siya dit wagas di mantatagu un impailan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ot utdit piyaon Apolos mandoḻmang un umoy ud Acaya, pinabos-oḻ dat manuttuwa utdin Efeso dit somsomok na kan nansulat da utdat manuttuwa utdi un awaton da si Apolos nu sumaaḻ. Dumatong man, dakoḻ dit naituḻung na utdat tagu’t di un manuttuwa maipagapu’t dit kaasin Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ta nalailaing sit mansusungbat na ot inabak na dat Judio un nakadiskutil kan siya utdit sangun dat kaaduwan ta aḻana utdit naikanglita ugud Apudyus dat pammanoknok na un si Jesus dit mangadan si Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Utdit inggawan Apolos sidin Corinto kummiyang si Pablo manipud Galacia kan Frigia agingga ud Efeso. Ot dintong na dat piga’n manuttuwa kan Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ot inimusana dida un, “Naawat yu kad si Ispiritu Santu utdit nanuttuwaan yu?” Summungbat da un, “Naid! Pulus nu nagngoḻan mi un awad Ispiritu Santu.” ");
INSERT INTO kmk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ot inimus Pablo un, “Ngadan nan bunyag dit nakwa kan dikayu nu?” “Padan dit intudtudun Juan,” insungbat da. ");
INSERT INTO kmk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Imbagan Pablo kan dida un, “Sadit intudtudun Juan, masapula mandadaoili nat osa’n tagu utdat basuḻ na asi mampabunyag. Imbaga na un masapula manuttuwa da utdit osa un maitagtagnob kan siya un siya si Jesus.” ");
INSERT INTO kmk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Magngoḻ da man di, nampabunyag da uman daḻapnu mangipatigammuwan da un manuttuwa da kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ot utdit inyagpad Pablo dit ima na utdit uḻu da, dummoba si Ispiritu Santu kan dida. Ot makabagbaga daon sidat sabali un bagbaga un adi da inadaḻ kan imbaga da pay dit paimpadtun Apudyus kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Umoya kagwampuḻu’t duwa datuwa laḻaki. ");
INSERT INTO kmk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Si unus di tuḻu’n buḻan, nakaoo-ooy si Pablo utdit sinagoga nu Aḻgawa Iillongan ot natuḻoda nan-ugud kan nangilawlawag sidit maipanggop sit mangiyapuwan Apudyus daḻapnu maawis na okyan dat tagu un manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yoong inggaw da ud udum kan dida un nasukil un adi manuttuwa. Dinuḻaduḻa da utdit atubang dat adu’n tagu dit Wagas di mantatagu un intudtudun Apu Jesus. Utdi, tinengyan Pablo di un sinagoga un buḻun na dat manuttuwa ot ummoy da utdit igawa tutudtuduwan Tirano. Ot kaaḻgaw-aḻgawa ummoy si Pablo nanudtudu’t di ");
INSERT INTO kmk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","si unus di duwa’n dagun ot losana Judio kan bokona Judio un ininggaw sidin Asia dingngoḻ da dit ugud maipanggop kan Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Adu dat nakaskasdaawa am-amug un pinakwan Apudyus kan Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ta ulay sadat pangyu kan luputa inusal na, nu idallay da utdat masakit makaan dat sakit da kan maaddag dat dimunyu utdat nadimunyu. ");
INSERT INTO kmk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yoong inggaw da pay piga’n Judio un mandakdakiwas un man-addag da pay sidat dimunyu un awad sidat tagu. Ot pinadas da un usalon dit ngadan Apu Jesus un kanan da utdat nadadaga ispiritu un, “Gapu’t dit pannakabalin dit ngadan Jesus un iwalwalagawag Pablo, lumaksun kayu.” ");
INSERT INTO kmk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sadat pitu’n laḻaki un abeng dit nangatu’n padin di Judio un mangngadan Sceva dat mangmangwa si kama’t tu. ");
INSERT INTO kmk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yoong inggaw namingsana summungbat dit dimunyu un kanana’n, “Tigammuk si Jesus kan tigammuk pay si Pablo. Yoong dikayu, singngadan yu?” ");
INSERT INTO kmk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Utdiyon, dinukusan dit tagu’n sinakayan di dimunyu dida’n tinilitiliw agingga si inabak na dida’l losan. Ot nambutik da un nasugasugat kan gatittiwayan. ");
INSERT INTO kmk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Madamag man dat losana Judio kan dat bokona Judio un inggaw ud Efeso tuwa napasamak, amoamod dit kimut da ot taḻona indaydayaw da si Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kadon, adu utdat manuttuwa dat dummatonga nangipudnu utdat lawenga kingkingwa da kan nambabawi da utdit atubang dat tagu. ");
INSERT INTO kmk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Adu pay sidat manuttuwaon un mansalsalumangka dat nan-idatong sidat iblu da ot insubba da utdit apuy un iillan dat losana tagu. Umoya limampuḻu’n libu utdit pilak da dit kadagupan dit losana bayad dat iblu. ");
INSERT INTO kmk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ot gapu’t tuwa naipasamak, summayasayak dit ugud Apudyus ot umaduadu dat bilang dat manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Magangput man tuwa naipasamak, ingkoddong Pablo un dakdakona’d Macedonia kan Acaya asina umoy ud Jerusalem. Ta kanana un, “Nu maabusak umoy Jerusalem masapula umoyak pay sin Roma.” ");
INSERT INTO kmk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Utdi, pinauna na da Timoteo kan Erasto ud Macedonia un siya dat duwa un katuḻungana ta ininggaw yan si Pablo si sin-akitan sin probinsiya ud Asia. ");
INSERT INTO kmk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Utdiya timpu amoamod dit gulu ud Efeso gapu’t dit Wagas di mantatagu un intudtudun Apu Jesus. ");
INSERT INTO kmk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ta ininggaw osa’n tagu un mangngadan kan Demetrio un mampapanday si palata un koona si sinan-timplu un mangiggaan da utdit sinan-apudyus da un babai un si Artemis. Ot adu dit mapilak dat mankokokwaona utdi un nigusiyu na. ");
INSERT INTO kmk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Sat kingwan Demetrio, pinandatdatong na dat mangkokokwaona kan dat udum pay un pada da un mampapanday si sinan-timplun Artemis asina kinnanan kan dida un, “Gagayyom, titiggammu yu un satuwa talibasu ud gumaknangan taku. ");
INSERT INTO kmk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yoong maila kan magngoḻ yuwon nat kokkoon dinata Pablo. Itudtudu na un bokona ustu un apudyus danat sinan-apudyus un koon di tagu, ot aduwon dan naawis na un manuttuwa utdan ibagbaga na uttun Efeso kan agistay payon tun losana lakub Asia. ");
INSERT INTO kmk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ot sad kalaweng na mayam-anan tun nigusiyu taku kan osa pay adi daon ibilbilang dit timplun ud Artemis. Ot adinon dat tagu bigbigon dit kinangatun Artemis un daydayawon dat losana tagu’t tun Asia kan losan situn pita!” ");
INSERT INTO kmk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Magngoḻan man dat adu’n tagu dit ugud Demetrio, nakasuḻag da ot impappakuy da un, “Si Artemis ud Efeso dit gattoka tulay!” ");
INSERT INTO kmk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Utdiyon summayak dit gulu utdat losana ili ot dinokmaan da da Gayo kan Aristarco un iMacedonia un maibuḻubuḻun kan Pablo asida linagayada indallay dida utdit bubuyyaan. ");
INSERT INTO kmk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Utdi, piyaon okyan Pablo un umoy sit atubang dat losan yoong adin dat manuttuwa pinalubusan. ");
INSERT INTO kmk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ot ulay sadat uduma opisyal sidiya ili un gagayyom Pablo nangibaun da si umoy mangibaga kan siya un Adina un taḻon mampappaila utdit bubuyyaan. ");
INSERT INTO kmk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Taḻona nagulugulu dat tagu’n naammung ot naid masalimutad sidat ipappakuy da ta osaosa kan dida nan-ipakuy paya lawa. Onta kaaduwan kan dida dat adi makatigammu nu apay awad da utdi. ");
INSERT INTO kmk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Gaputa kama’t di, pinaoy dat Judio dit buḻun da un si Alejandro utdit atubang dat tagu daḻapnu ipakaawat na un bokona sadat Judio dit gapun dit gulu. Utdi intayag Alejandro dit ima na un nampaginok sidat tagu ta mampalawag okyan, ");
INSERT INTO kmk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","yoong maimatunan man dat tagu un Judio, nandidisan da un nangipappakuy si duwa’n olas sit, “Si Artemis ud Efeso dit gattoka tulay!” ");
INSERT INTO kmk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mansidi, napaginok payon dit isklibentin di ili dat un-unaya tagu ot kanana un, “Katagun-tagu’t tun Efeso, bokon kada tigammun dat losana tagu’t tun lubung un satun ili’n Efeso ud manga-ayyuwan sidit timplun ud nangatu’n Artemis kan sadit nasantuwana batu un nan-otdaga nanligwat langit? ");
INSERT INTO kmk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Maid ud makaisulib situ. Isunga masapul un guminok kayu kan adiyu babaḻangona lawa. ");
INSERT INTO kmk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Indatong yu datuwa tagu’t tu ulay nu naid inakawan da si timplu onnu imbaga da si sumuganggang kan apudyus taku. ");
INSERT INTO kmk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Isunga nu piyaon Demetrio kan dat buḻun na un mampapanday un kasuwan nat osa’n tagu, awad aḻ-aḻgaw un nakabukat din uukkuman ot awad dadit kukuis sidi un umoy da mandaḻuman. ");
INSERT INTO kmk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ot nu awad udum si lili yu masapul un babagbagaon taku nu timpun di miting. ");
INSERT INTO kmk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ta sad kalaweng na mabalin un maidaḻum taku utdin gubilnun di Roma maipanggop situ un gulu uttun aḻgaw ot adi taku masungbatan ta maid ud nadotok si gapuna.” ");
INSERT INTO kmk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Gangputon man Alejandro un ibaga tu pinadaḻan na dat tagu. ");
INSERT INTO kmk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Utdit gumminok dit gulu, pinandatdatong Pablo dat manuttuwa ot binagbagaana dida’t mampabos-oḻ sit somsomok da asina nampalang un umoy probinsiya’d Macedonia. ");
INSERT INTO kmk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Dumatong man sidi, dinakdak na dat kailin-ili un ummoy nangila’t dat manuttuwa ot adu dat imbagabaga na kan dida un nampabos-oḻ sit somsomok da asina inummoy ud Acaya un mangngadan Grecia. ");
INSERT INTO kmk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ininggaw sidi si tuḻu’n buḻan. Ot utdit man-ulin okyanon ud Siria, natigammuwana un pangpanggopon dat Judio un patoyon. Isunga nan-ulin ullawa un nangoy Macedonia. ");
INSERT INTO kmk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Buḻun na da Sopatro un abeng Pirro un iBerea, da Aristarco kan Segundo un iTesalonica, si Gayo un iDerbe, si Timoteo kan pati pay da Tikico kan Trofimo un nanligwat sin probinsiya’d Asia. ");
INSERT INTO kmk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dumatong da man sin Filipos sidin Macedonia pinaunan Pablo dat buḻun na ot inuway dikami’d Troas. ");
INSERT INTO kmk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Magangput man dit piyestan di tinapay un naid kamos na si bubud, nambapul kami kan da Pablo manipud Filipos si lima’n aḻgaw asi mi dakngon dida ud Troas un ininggawan mi si sindumingguwan. ");
INSERT INTO kmk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Utdit umuna’n aḻ-aḻgaw di sindumingguwan, nandatdatong kami’t dat losana manuttuwa’n iTroas daḻapnu mangan kami’t dit kakan un mangisomsomkan mi utdit natoyan Jesus. Maabus man, nambagbaga si Pablo kan dida ot gaputa manaḻan nu mabigat, intulutuluy na un nambagbaga agingga’t gawan labi. ");
INSERT INTO kmk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Adu dit silaw sidit nanginngatu’n kuwaltu un naammungan mi. ");
INSERT INTO kmk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ot nantupak sit sawang dit osa’n babbagu un mangngadan kan Eutico. Utdiya mampalpalawagan Pablo, nailig-op sit amoda suyop na ot naotdag sit pita un nanligwat sidit maikatulu’n tuug dit boḻoy. Ot natoya inakup da. ");
INSERT INTO kmk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Yoong dummoba si Pablo ot ummoy na inapawoḻ. Utdi kanana’n, “Adi kayu madanagan ta antu’n umungaḻon.” ");
INSERT INTO kmk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Utdi, summakyat obos si Pablo ot biniibiik na dit tinapay asi kami nangan. Maabus man di, intulutuluy na un nakabagbaga kan dida aginggana si wiswis-it asi kami kaysan. ");
INSERT INTO kmk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ot sadit babbagu’n naotdag, binuḻunan da un kaysan sit boḻoy da un amoamod dit taḻok da ta adina natoy. ");
INSERT INTO kmk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Utdi, ummun-una kami’n nambapul un inummoy sin ili’d Asson ta nangakaḻsa si Pablo ot nantutulagan mi un uuwayon mi utdi. ");
INSERT INTO kmk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Utdit dakngon dikami’d Asson nakalugan kan dikamiyon un kaysan ud Mitilene. ");
INSERT INTO kmk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Manipud sidi intuluy mi un nambapul ot mabigat man dummatong kami utdin domangon ud Chio. Utdit osa’n mabigat dummatong kami ud Samos ot utdit mabigat dintong mi ud Mileto. ");
INSERT INTO kmk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Utdi, ingkoddong Pablo un adi naon mangoy Efeso daḻapnu adina mambayag sidin lakub Asia ta makamu un dumatong Jerusalem. Ta nu awad kakwaana, makadatong okyan sit kaaḻgawan dit Piyestan di Pentecostes. ");
INSERT INTO kmk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Inggaw kami man Mileto nangibaun si Pablo si mangayag sidat lalallakay un mangipangpangat sidan manuttuwa utdin Efeso. ");
INSERT INTO kmk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Sumaaḻ da man kinnanana kan dida un, “Tigammu yu nu kamaan dit nantataguk manipud sit damu un dummakngak situn lakub Asia. ");
INSERT INTO kmk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Imbados ku un nanselbi kan Apu Jesus un napakumbaba kan nan-alluboy dat luwak gapu utdat adu’n ligata linak-am ku utdat lawenga panggop dat Judio un koon kan sakon. ");
INSERT INTO kmk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tigammu yu pay un adik impaidama intudtudu ud singngadan na man un makatuḻung kan dikayu nu adi inwalagawag kan intudtuduk sit atubang di kaaduwan kan ulay pay sidat kaboḻoyboḻoy. ");
INSERT INTO kmk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Binagaak dat Judio kan bokona Judio un masapula ibabawi da dat basuḻ da kan Apudyus kan manuttuwa da kan Apu Jesu Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ot sinsatun tungpaḻok si Ispiritu Santu ot umoyak sin Jerusalem ulay maid tigammuk nu ngadan nat mapasamak kan sakon sidi. ");
INSERT INTO kmk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sad tigammuka lawa, sat impagiknan Ispiritu Santu un sit kailin-ili uuwayon dat tagu un baḻudon kan paligaton sakon. ");
INSERT INTO kmk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yoong bokona sad napotog kan sakon dit mataguwak ta sad taḻona piyaok, tungpaḻok dat pakwan Apu Jesus kan sakon un siyadit mangiwalagawagak sidit Nabaḻu’n Damag maipanggop sidit nangkakaasin Apudyus kan ditaku.” ");
INSERT INTO kmk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ot sin satun, dikayu un tinudtuduwak sidit Nabaḻu’n Damag maipanggop sin mangiyapuwan Apudyus, tigammuk un maidon man-iinnilaan taku. ");
INSERT INTO kmk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Siya’d gapuna un, uttun satuna aḻgaw ibagak kan dikayu un nu awad kan dikayu ud maisina kan Apudyus un madusa bokonona sakon ud sinbasuḻ. ");
INSERT INTO kmk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ta adik impaidama impatigammu kan dikayu dat losana panggop Apudyus un koon. ");
INSERT INTO kmk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Siya’d gapuna un aayyuwana’n yu nat long-ag yu padana pay sidat losana labban un ipaayyuwan Ispiritu Santu kan dikayu. On, ayyuwanan yu dat tagun Apudyus un sinubbut na utdit daḻan dit mismu’n Anak na. ");
INSERT INTO kmk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Tigammuk un nu manaḻanak awad da ud tagu’n dumatong kan dikayu un nauyunga kama’t tanana asu un umoy manam-an sinat pammati yu kan pati pay sit pammatin dat manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dumtong pay nat timpu un sadat udum sidat kabbuḻunan yu pay lawan, mantuli da daḻapnu maawis dat udum kan dikayu un kumapon kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Siya’d gapuna’n mansiput kayu ot gagasmokon yu dit nangiyan-anusaka nanudtuduwan kan dikayu un inaḻgaw kan linabi si unus di tuḻu’n dagun un ulaya lawa’n iyibil ku nu udum na. ");
INSERT INTO kmk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ot sinsatunon itaḻgod ku dikayu kan Apudyus kan sadit sapatana un kaasiyana dikayu. Siya ud makapabilog sinat pammati yu kan itdona dit insapatana’n itdon sidan losana inlasin na un tagu na. ");
INSERT INTO kmk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Naid ginamgamaka innaḻa si pilak, buḻawan onnu badut si singngadan na mana tagu. ");
INSERT INTO kmk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Dikayu un mismu’d makatigammu un inlabbuk un losan dat nasapul mi utdat kabbuḻunak. ");
INSERT INTO kmk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Impapasnok ku dat losana talibasuk daḻapnu awad mangilasinan yu un masapula makatuḻung taku utdan nakapsut kan nakapus. Adi taku liuwan dit imbagan Apu Jesus un kanana’n, ‘Naang-anggom nat mangitod nu sadin maitdan.” ’ ");
INSERT INTO kmk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Utdit magangput Pablo un ibaga datu nampalintumong dan losana nanluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ot gaibilan dat tagu’t di un nangapawoḻ kan nangogok kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ta sad amoda indomdom da, sadit ugud na un adi daon man-iinnila. Ot utdiyon ummoy da intuḻud sidit bapula manluganana. ");
INSERT INTO kmk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Utdi, nampalang kami utdat manuttuwa ot nambapul kamiyona nandadawwos Coos. Mabigat man dintong mi ud Rodas ot manipud sidi ummoy kami’d Patara. ");
INSERT INTO kmk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Utdi insangkat mi ud osa’n bapul un manaḻan Fenicia ot siya’d nambapulan mi un kaysan. ");
INSERT INTO kmk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Utdit dumatong kami si igawa nangtapan mi ud Chipre, ingkaḻwes mi utdin kapon daya na agingga’t dintong mi din probinsiya’d Siria. Tummakdang kami’t din Tiro ta man-idoba dit bapul sidat awit na. ");
INSERT INTO kmk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ininap mi dat manuttuwa’t di ot nakaigaw kami kan dida si sindumingguwan. Utdiya ininggawan mi kan dida, imbabagga da kan Pablo un Adina umoy ud Jerusalem ta siya’d impatigammun Ispiritu Santu kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Yoong madtong man dit aḻgawa manaḻnan mi, nanlakkat kami daḻapnu ituluy mi dit daddaḻan mi. Losan dat manuttuwa pati utdat aassawa kan aabeng da un ummoy namalisgud kan dikami inggana’t dit lasin dit ili. Dumatong kami man sit dupit dit baybay nampalintumong kami’n losana nanluwaḻu. ");
INSERT INTO kmk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Utdiyon nanlugan kami’t dit bapul ot nangulin da payon sidat boboḻoy da. ");
INSERT INTO kmk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Manipud Tiro intuluy mi un nambapul aginggana’t dummatong kami’t din Tolemaida. Biniling mi dat manuttuwa’t di ot nakaigaw kami kan dida si sin-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Utdit mabigat nambapul kami payyan ot dummatong kami ud Cesarea. Tummakdang kami ot ummoy kami nakaigaw sit boḻoy ud Felipe un osa’n mangiwalwalagawag sidit Nabaḻu’n Damag. Siya’d osa utdat pitu’n laḻaki un napili utdin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Inggaw da ud opata bababbaḻasang un abeng na un propetan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Utdiya ininggawan mi si piga’n aḻgaw dummatong tun osa’n man-uugudon un mangngadan kan Agabo un nanligwat Judea. ");
INSERT INTO kmk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ummoy kan dikami ot innaḻa na dit gakos Pablo asinapiningil pay lawan dat iki na kan ima na ot kinnanana’n, “Satu dit kanan ud Ispiritu Santu un, ‘Kama’t tu ud mampipingil dan Judio ud Jerusalem sidit sin-gakos situ asida ipaima utdan bokona Judio.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Utdit magngoḻ mi tu, nakapangpangngaasi kami kan dat tagu’t di un adin okyanon Pablo umoy ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yoong summungbat si Pablo un, “Apay gaibilan kayu un kama’t tu un pasigabon yu tun angos ku? Bokona lawa’n nakasaganaak un mapingil sidin Jerusalem nu adi nakasaganaak pay un mapatoy sidi maipagapu kan Apu Jesus.” ");
INSERT INTO kmk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ot gaputa adina mabagaan, inggongda mi ot imbaga mi ullawa un, “Sat piyaon ud Apu ud matungpal.” ");
INSERT INTO kmk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Lumabas man ud piga’n aḻgawa ininggawan mi utdi, insagana mi dat masapul mi ot intuluy mi un ummoy ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Inummoy pay kan dikami dat piga’n manuttuwa’n iCesarea ot intuḻud dikami utdit mandagusan mi un boḻoy Mnason un iChipre un osa utdat nabayagona manuttuwa. ");
INSERT INTO kmk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Utdit dummakngan mi ud Jerusalem, nantattaḻok dat manuttuwa un namadatong kan dikami. ");
INSERT INTO kmk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mabigat man naitung-ud si Pablo kan dikami un umoy namiling kan Santiago. Ot dintong mi dat losana lalallakay dat manuttuwa’t di. ");
INSERT INTO kmk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Maabus man un kumustaon Pablo dida, imbaga na kan dida dat losana kingkingwan Apudyus sidat bokona Judio maipagapu’t dit nanudtuduwana kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Magngoḻ da man dat impadamag na indaydayaw da si Apudyus. Yoong imbaga da kan Pablo un, “Sunud, tigammumon un linibulibu’n Judio ud nanuttuwa kan Jesus yoong ipapasnok da un unudon dit lintog Moses. ");
INSERT INTO kmk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nagngoḻan da un itudtudum kanu utdat Judio un inggaw sit boboḻoy dat bokona Judio un umadsan da dit lintog Moses. Ibagbagam kanu pay un Adina masapula matuḻgiyan dat aabeng da kan ulay adi da uunnudon dat ugali taku. ");
INSERT INTO kmk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ot ngadan nat koonon? Maid duwaduwa na un matigammuwan da un summaaḻ kaon. ");
INSERT INTO kmk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Isunga koom tu un ibaga mi. Antu da ud opata laḻaki un nansapata kan Apudyus. ");
INSERT INTO kmk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Maibuḻun kaon kan dida utdin timplu un umoy mangwa utdit kadawiyana mandadaḻus. Ibayadam didaon sidat mabayadan daḻapnu mabalin daon un mampapulug. Ot siya ud manigammuwan di losan un maid katuttuwaan dat dingngoḻ da un maipanggop kan sika nu adi gasissiya ka un manutungpal sidat lintog Moses. ");
INSERT INTO kmk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yoong sidat bokona Judio un manuttuwa impaw-itan miyon dida si sulat un mangibilin kan dida un adi da mangan si makan un naidatun sidan sinan-apudyus onnu daḻa onnu ayam un napsoḻ kan adi da sog-onon dat bokona asawa da.” ");
INSERT INTO kmk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ummampayun si Pablo ot utdit mabigat indallay na dat opata laḻaki utdit timplu ot naidoga un nangilugi utdit kadawiyana koko-on daḻapnu madaḻusan da. Utdiyon, nilumnok un ummoy nangipatigammu’t dit padi nu kapiga dit magangputan dit madaḻusan da kad makwa dit datun di kada-osa kan dida. ");
INSERT INTO kmk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Dandani mana magangput dit naituding un pitu’n aḻgaw, inggaw da ud Judio un iyAsia un nakaila kan Pablo utdit timplu. Ot ginaygay da dat tagu un makasuḻag kan Pablo ot dinokmaan da. ");
INSERT INTO kmk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Impappakuy da un, “Kabbuḻunana Judio tumuḻung kayu! Ta antuwon dit tagu un mandakdakdak sida’l losana igaw un mangitudtudu’t dat losan un naidon selbin dat ugali taku’n Judio kan sat lintog Moses padana pay ta dinimok na tun nasantuwana timplu ta nangilnok sidat bokona Judio.” ");
INSERT INTO kmk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Imbaga da tu ta naila da si Pablo utdin Jerusalem un naibuḻun si bokona Judio un iyEfeso un mangngadan si Trofimo. Ot sat somsomok da innilnok na utdit timplu. ");
INSERT INTO kmk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Utdi, nabukaḻ dat losana tagu’d Jerusalem ot nanggugunod da un ummoy nanokma kan Pablo. Linagayad da un inlaksun sidit timplu asida dagusa inyonob dit timplu. ");
INSERT INTO kmk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Patoyon okyanon dat tagu si Pablo, yoong inggaw ummoy nangipadamag sidit ap-apun dat suldadu’d Roma un nagulu ud Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Utdi, dagusa nangayag dit ap-apu utdat oopisyal kan pati utdat suldadu da ot nanukḻus da un inummoy sit kawadan dat tagu. Mailan man dat tagu’t di dit ap-apu kan dat suldadu na inillongan da un manabisabid kan Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Utdi, kummatam dit ap-apun di suldadu ot inaḻa na si Pablo un pinapingil sidat suldadu na si duwa’n kinawad. Utdiyon inimusana dat tagu un kanana’n, “Ngadan dituwa tagu? Ngadan dit kingwa na?” ");
INSERT INTO kmk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Summungbat da un gapappakuyana nadumaduma dit sungbat da. Gaputa amod dit damit da, adin dit ap-apun di suldadu masinog nu singngadan dit gattoka napasamak ot binilin na dat suldadu na un idallay da si Pablo utdit kampu da. ");
INSERT INTO kmk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Utdit dakngon da dit aḻdan intayag dat suldadu un nangawit kan Pablo un nangilnok kan siya gapu utdit amoda suḻag dat tagu. ");
INSERT INTO kmk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ta gapappakuyan da un maitungtung-ud un kanan da un, “Patoyon taku.” ");
INSERT INTO kmk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Utdit ilnok da okyanon si Pablo utdit kampun dat suldadu imbagan Pablo utdit ap-apu un, “Antu okyan ibagak kan sika nu mabalin?” Ot kanan dit ap-apun di suldadu un, “Tigammum gayam man-iGriego? ");
INSERT INTO kmk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bokon kad nin un sika dit iyEgipto utdit adi payyan nasulit un gummusuḻ sit gubilnu ot impangat na dat opata libu’n tulisan un ummoy sit igaw un maid tagtagguwan?” ");
INSERT INTO kmk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Summungbat si Pablo un, “Bokona sakon. Judiowak un iTarso un mandindinamaga ili’t din probinsiya’d Cilicia. Pangaasim ud ta mampalawagak sidan tagu.” ");
INSERT INTO kmk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Utdi, pinalubusan dit ap-apun di suldadu ot summikad si Pablo utdit palikad dit aḻdan asina intayag dit ima na un nampaginok sidat tagu. Guminok da man nambagbaga kan dida utdit ugud da un Hebreo. ");
INSERT INTO kmk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mamaḻḻong-ag kan susunud ku, dumngoḻ kayu ta ipalawag ku tun sungbat ku utnat ipabpabasuḻ yu kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Magngoḻ da mana mambagbaga utdit bagbaga da un Hebreo, amo gummiginnok da’l losan ot intuluy Pablo un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Judiowak un naiyabeng sidin Tarso ud Cilicia yoong dummakoḻak situn Jerusalem un uswelan ud Gamaliel. Natudtuduwanak sit gattoka kokwan dat linlintog dat aappu taku ot napasnokak un manselbi kan Apudyus un pada yu pay sinsatun. ");
INSERT INTO kmk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pinalipaligatak inggana’t natoy dat udum sidat tagu un manuttuwa utdit intudtudun Jesus un Daḻan. Dinokmaak dida, babai man onnu laḻaki ot paimbaḻud ku dida. ");
INSERT INTO kmk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ot sat kangattuwana padi kan dat lalallakay taku dat makakustigu un tuttuwa datu un ibagbagak kan dikayu. Ta dida’d nangitod kan sakon sit sulat un ipailak sidat buḻun taku ud Damasco daḻapnu dokmaak dat manuttuwa’t di asik iyoy dida un mapingil situn Jerusalem daḻapnu madusa da.” ");
INSERT INTO kmk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Utdiya manaddaḻanak un dumoḻdoḻ ud Damasco si mamatuk, kakḻata lawa’n inggaw napaddapadda’n silaw un nanligwat langit un naipaslang kan sakon kan sidit nangkalliput ku. ");
INSERT INTO kmk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Naidugsutak sit pita ot nagngoḻ ku dit ginga’n kanana kan sakon un, ‘Saulo, Saulo, apay palpaligatom sakon?’ ");
INSERT INTO kmk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“‘Singngadan nu kad Apu?’ inimus ku. “Kinnanana kan sakon un, ‘Sakon si Jesus un iNazaret un palpaligatom.’ ");
INSERT INTO kmk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“Sadat buḻun ku naila da dit silaw yoong adi da nagngoḻ dit gingan dit nakabagbaga kan sakon. ");
INSERT INTO kmk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ot inimus ku un, ‘Ngadan nat kook, Apu?’ “Ot summungbat si Apu un, ‘Gumangun ka ta ituluy nu un umoy Damasco ta awad mangibaga’t di kan sika utdat naitudinga koom.’ ");
INSERT INTO kmk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Adiyak makaila gaputa kinuḻapak sidit doḻang didiya silaw ot kinebedak sidat buḻun ku un indallay ud Damasco. ");
INSERT INTO kmk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Utdiya ili, inggaw osa’n tagu un mangngadan kan Ananias un taḻona manuttuwa utdat linlintog taku kan nabaḻu ud kaugudana utdat losana Judio un iinggaw sidi. ");
INSERT INTO kmk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Dummatong kan sakon ot summikad sidit sog-on ku un kanana’n, ‘Sunuda Saulo, makaila ka umanon.’ “Utdi, dagusa nakailaak ot tummukkoḻak kan siya.” ");
INSERT INTO kmk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ot imbaga na kan sakon un, ‘Sadit Apudyus dat aamma taku pinilina’d sika un manigammu utdat piyaona kan mailam dit Nalintoga Anak na kan magngoḻ nu dit mismu un ginga na. ");
INSERT INTO kmk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sika’d kustigu na un mangipanoknok sidat tagu utdat losana nailam kan dingngoḻ nu. ");
INSERT INTO kmk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ot sinsatun, ngadan payyan nat uuwayom? Lumigwat ka ot pabunyag ka. Ot kodawom kan Apu Jesus un pakawanona dat basuḻ nu.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Utdiyon nangulinak situn Jerusalem ot madamaak mana manluwaḻu utdin timplu kama’t in-inop dit nangil-ak ");
INSERT INTO kmk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","kan Apu ot imbaga na un, ‘Daḻasom ot tengyam tun Jerusalem ta adin dat tagu’t tu tuttuwaon nat pammanoknok nu maipanggop kan sakon.’ ");
INSERT INTO kmk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Yoong kinnanaka summungbat un, ‘Apu, tuttuwaon da ud sakon situn kanak ta gagangay titiggammu da un inummoyak sidat kasinasinagoga uttun Jerusalem ot dinokmaaka paimbaḻud dat manuttuwa kan sinabisabidak dida. ");
INSERT INTO kmk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ot utdit napatoyan Esteban un nangustigu kan sika nakasikadaka mismu’t di un nangiyoon kan nangadog sidat badut dat namatoy kan siya.’ ");
INSERT INTO kmk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Yoong imbagan ud Apu kan sakon un, ‘Ikan, ta ibaun ku’d sika utdin adaddayuwana igaw dan bokona Judio.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Dinudumngoḻ dat tagu kan Pablo yoong utdit nagngoḻan da tuwona imbaga na nakasuḻag da ot nampappakuy da un kanan da’n, “Patoyon yu nata tagu! Bokona lumbong un matagu!” ");
INSERT INTO kmk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Utdi gapappakuyan da kan iwasiwasiwas da dat badut da kan itaballu da dat gabu ud ngatu utdit amod un suḻag da. ");
INSERT INTO kmk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Utdiyon imbilin dit ap-apun dat suldadu utdat tagu na un ilnok da si Pablo utdit kampu da asina imbaga un sabisabidan da un imusan daḻapnu matigammuwan da nu apay un amod dit mampapakuy dat Judio kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Utdit mapingil daon daḻapnu masabidan, imbagan Pablo utdit opisyal un sumisikad sidit sog-on na un, “Ipalubus kad dit lintog un masabidan nat iRoma un adina payyan nabistigal?” ");
INSERT INTO kmk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Magngoḻ man dit opisyal tu, inummoy sit ap-apu da ot kanana’n, “Ay ilama lawa nu ngadan nat koom kan siya ta iRoma gayam tuwa tagu!” ");
INSERT INTO kmk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Utdi, ummoy dit ap-apu kan Pablo inimus un, “Tuttuwa kad un iRoma ka?” “On,” insungbat Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ot summungbat dit apun di suldadu un, “Nanggastuwak si dakoḻa pilak udsi nambalinaka tagun di Roma.” Summungbat si Pablo un, “Yoong iRomaak un naiyabeng.” ");
INSERT INTO kmk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Utdiyon, dagusa kummunukunud dat suldadu un mamistigal kan siya utdit magngoḻan da dit imbaga na kan ulay sadit opisyal, ummogyat payon sidit matigammuwana un iRoma si Pablo gaputa siya dit namingil kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Utdi, piyaon dit ap-apun di suldadu un matigammuwan dit ipabpabasuḻ dat Judio kan Pablo. Isunga utdit mabigat, imbilin na un makaan dat kinawad un namingil da kan Pablo kan binilin na dat aap-apun di padi kan sadat Sanhedrin un mammimiting da. Utdi, ummoy na indatag si Pablo utdit sanguwan da. ");
INSERT INTO kmk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Utdi, intutukkoḻ Pablo dadit losana mammimiting asina kinnanan un, “Susunud ku un kaganakan Israel, kigad nataguwak inggana’t tuwa aḻgaw, naid tigammuk si kingwak ut laweng sidin man-iilan Apudyus.” ");
INSERT INTO kmk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Magngoḻ man Ananias un kangattuwana padi, imbilin na utdat adani un sumisikad sidit sog-on Pablo un tigpapon da dit sangi na. ");
INSERT INTO kmk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Utdi, kinnanan Pablo kan siya un, “Si Apudyus ud manigpap kan sika un man-ag-agin. Alig nu ud alisut un pinambalin da un kama nu napoḻkas ta kuisom okyan sakon un maibasal sit lintog yoong salungasingom dit lintog sinat mampatigpapam kan sakon.” ");
INSERT INTO kmk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ot kinnanan dat tagu un kaadaniyan kan Pablo un, “Apay in-insultuwom nat kangattuwana padin Apudyus?” ");
INSERT INTO kmk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","“Naid ussiya’d tigammuk susunud, un siya dit kangattuwana padi,” kinnanan Pablo. “Ta naikanglit pay-an sidit ugud Apudyus un, ‘Adi yu pabainan nat tagu un mangipangat kan dikayu.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Utdit nadlaw Pablo un sadat udum sidat mammimiting, Saduceo da kan Fariseo dat udum indangsoḻ na un nambagbaga un, “Susunud ku, Fariseowak pay ta Fariseo dat ginnapuwak isunga namnamaok un paungaḻon Apudyus dat natoy ot siya ud gapun tun naidaḻumak situnsatun.” ");
INSERT INTO kmk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Utdit naibaga na tu, nansisinnungbat dat Fariseo kan dat Saduceo ot nagogwa da un dit mammimiting. ");
INSERT INTO kmk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ta sadat Saduceo adi da manuttuwa un umungaḻ dat natoy kan adi da pay tuttuwaon un awad anghel onnu kadogwa yoong sadat Fariseo manuttuwa da utdatu un losan. ");
INSERT INTO kmk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Utdi, taḻona dummangsoḻ dit pinnaleset dat Saduceo kan dat Fariseo ot sadat uduma mimistulun di lintog un buḻun dat Fariseo summikad da ot kinnanan da un, “Naid maodasan mi si laweng situwa tagu. Tuwan nu tuttuwa’n awad ispiritu onnu anghel ud si nakabagbaga kan siya.” ");
INSERT INTO kmk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Taḻona ummengeenget dit sisinnungbat ot kummimut dit ap-apun di suldadu nu manwewwesang da si Pablo. Utdi, binilin na dat suldadu na un dumoba da ta umoy da aḻan si Pablo daḻapnu idallay da utdit kampu da. ");
INSERT INTO kmk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Utdiya labi nampaila dit Apu utdit sog-on Pablo ot kinnanana un, “Pabilgom nat angos nu. Pinanoknokam dit maipanggop kan sakon situn Jerusalem ot masapula siya pay koom sin Roma.” ");
INSERT INTO kmk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mabigat man nan-aanamungan dat piga’n Judio ot insapata da un adi dan taḻon mangan kan uminum agingga’t mapatoy da si Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nakalimampuḻuwan dat laḻaki un nantutulag. ");
INSERT INTO kmk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Utdiyon inummoy da utdat aap-apun dat papadi kan lalallakay ot kinnanan da un, “Taḻona insapata mi’l losana adi kami’n taḻon mangan agingga’t mapatoy mi si Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Isunga kodawon mi kan dikayu kan sidat Sanhedrin un mangipatuḻud kayu si bilin kan ap-apun di suldadu ta idatong da si Pablo kan dikayu, un kama nu piyaon yu un maawatana kustukustu dit kasu na. Ta nasasaggana kami un umoy mangilpang kan siya sin daan na un dumatong situ.” ");
INSERT INTO kmk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Yoong inggaw ud abeng dit sunud Pablo un babai un nakagngoḻ sidit nantutulagan da, ot inummoy sidit kampun dat suldadu ot imbaga na kan Pablo dit panggop da. ");
INSERT INTO kmk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Utdi, inayagan Pablo dit osa’n opisyal ot imbaga na kan siya un, “Idallay nu tuwa mamabbagu utdin ap-apu yu ta antu ud ibaga na kan siya.” ");
INSERT INTO kmk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Utdi, indallay dit opisyal ot impuyut na utdit ap-apu da un kanana’n, “Inayaganak kan Pablo un baḻud ot imbaga na un iyoy ku tuwa mamabbagu kan sika ta antu ud ibaga na.” ");
INSERT INTO kmk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Utdiyon kinebed dit ap-apun di suldadu dit mamabbagu ot inyadayuna daḻapnu maid makagngoḻ si sabali, asina inimusan un, “Ngadan nat ibagam kan sakon?” ");
INSERT INTO kmk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Summungbat un, “Nantutulag dat pangaton dat Judio un kodawon da kan sika un idallay nu si Pablo nu bigat sidin mammimitingan da, ta ag-agin piyaon da un maawatan dit kustukustu’n maipanggop sit kasu na. ");
INSERT INTO kmk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Yoong adim okyan tuttuwaon dida ta awad da ud makalimampuḻuwana laḻaki un mangiilpang kan siya. Insapata da un adi da mangan kan uminum agingga’t mapatoy da si Pablo. Nakasagana da un mangipatungpal situwa koon da ot uuwayon da’l ullawa nat ibagam.” ");
INSERT INTO kmk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Utdiyon binilin dit ap-apun dat suldadu dit mamabbagu un kanana’n, “Adim ibagbaga si udum un imbagam tu kan sakon.” Asi naon pinadaḻan. ");
INSERT INTO kmk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Utdit lapuwan dit mamabbagu inayagan dit ap-apun di suldadu dat duwa’n opisyal na ot binilinana dida un, “Mangisagana kayu si duwa’n gasuta suldadu kan pitumpuḻu’n mangabayu kan duwa’n gasuta gasay-angan ta manaḻan kayu’d Cesarea nu pogpoga’n suyop sooni nu labi. ");
INSERT INTO kmk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Isaganaan yu pay si Pablo utdat kabayu ut mangabayuwana ot ituḻud yu kan gubinnadul Felix un maid mapaspasamak kan siya si laweng.” ");
INSERT INTO kmk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Utdiyon nansulat dit ap-apun di suldadu kan gubinnadul Felix un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kan sika un nangatu’n gubinnadul Felix. Kapkapiya ka okyan, Apu. ");
INSERT INTO kmk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Dinokmaan dan Judio tuwa tagu ot dandani da un pinatoy. Natigammuwak un tagun di Roma ot ummoy kami’t dat suldaduk ud sinaḻakan. ");
INSERT INTO kmk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Piyaok tigammuwon dit nangidaḻuman da kan siya isunga indatag ku utdat Sanhedrin. ");
INSERT INTO kmk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ot naodasak un naid kingkingwa na si laweng un gapun di mapatoyana onnu maibaḻudana. Ta sad ipabasuḻ da’l lawa kan siya dit maipanggop sidit lintog da. ");
INSERT INTO kmk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Utdit matigammuwaka panggop dat Judio un patoyon tuwa tagu dagusa impadaḻan ku kan sika. Ot imbilin ku pay sidan mamabpabasuḻ kan siya un sika’d mandaḻuman da. Satun nansulat, Claudio Lisias.” ");
INSERT INTO kmk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Utdiyon tinungpal dat suldadu dit imbilin na kan dida ot inaḻa da si Pablo ot utdiya labi kaysan da inggana’t dummatong da ud Antipatrisa. ");
INSERT INTO kmk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mabigat man nangulin dadit adi nangabayu utdit kampu da. Ot sadat nangabayu’l lawa ud nantuluy un nangituḻud kan Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Dumatong da man ud Cesarea intod da dit sulat kan gubinnadul Felix asida inyawat pay si Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Binasan dit gubinnadul dit sulat asina inimusan si Pablo nu singngadan dit ili na. Utdit matigammuwana un iCilicia, ");
INSERT INTO kmk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kinnanana un, “Dongḻok kan kuisok sika nu dumatong dat mangidaḻum kan sika.” Utdiyon binilin na un maiyoya maandogan si Pablo utdit boḻoy un pinatuud didit Ali Herodes sidit. ");
INSERT INTO kmk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Lumabas man lima’n aḻgaw, inummoy Cesarea si Ananias un kangattuwana padi un buḻun na dat piga’n lalallakay kan inggaw pay osa’n abugadu un mangngadan kan Tertulo. Ummoy da kan gubinnadul Felix ot indatag da dit daḻum da kan Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Utdit naayagan da si Pablo, inlapun Tertulo un man-ibaga’t dat ipabasuḻ da kan siya un kanana’n, “Apu, madaydayawa Gubinnadul! Gapu utnat kalaing nu un mangipangat nabayagona kapkapiya kami uttuwa igaw. Maipagapu kan sika adu un nabaḻu’n nakwa un nangkapiyaan tun ili. ");
INSERT INTO kmk_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Singngadan na mana ayan mi’t tun losana linakub tun ili mi bigbigon mi dat nakwaam ot dakoḻ tun yaman mi kan sika. ");
INSERT INTO kmk_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Adi mi piyaon un mataktak ka yoong pangaasim ta anusama dongḻon tun aboba un palawag mi. ");
INSERT INTO kmk_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ta sigun sit padas mi ga-oogyat tuwa tagu ta gumugulu. Siya ud nangilapu si gulu utdat losana Judio uttun lubung, kan siya ud pangat dat buyut dit osa’n iNazaret. ");
INSERT INTO kmk_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pinadas na paya dimokon dit kinasantun dit timplu ud Jerusalem yoong dinokmaan mi. Ot kuison mi okyan sidit lintog mi ");
INSERT INTO kmk_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","yoong dummatong da Lisias un ap-apun di suldadu pati utdat suldadu na ot pinḻos da un innaḻa kan dikami. ");
INSERT INTO kmk_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Utdiyon imbilin Lisias kan dikami un sika’d umoyan mi mandaḻuman. Nu imusam tuwa tagu matigammuwam kan siya dat losana ipabasuḻ mi kan siya.” ");
INSERT INTO kmk_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ummampayun pay dat Judio un buḻun na utdit daḻum ot pinanoknokan da’l losana tuttuwa datu’n imbaga na. ");
INSERT INTO kmk_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Magangput man di, sininyasan Felix si Pablo un mambagbaga. Ot kinnanan Pablo un, “Apu Gubinnadul, tigammuk un nabayag kaon un kuis situn ili mi, siya’d gapuna un malagsakanak un mangipalawag situn kalintogak sinat atubang nu. ");
INSERT INTO kmk_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nu man-im-imus ka, matigammuwam un naid payyan kagwampuḻu’t duwa’n aḻgaw si lummabas manipud sit ummoyak nandaydayawan kan Apudyus sidin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ot utdit ininggawak sidi naid osa si Judio ut nakaila kan sakon un nakasinnungbat onnu nanggulu utdat tagu utdin timplu onnu sinagoga onnu ulay sidin ili’d Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ot maid maidatag da ut pammanoknok da utdan ipabpabasuḻ da kan sakon. ");
INSERT INTO kmk_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Yoong aminok un tuttuwan mandaydayawak kan Apudyus un siya’d nandaydayawan dat ginnapuwan mi ot un-unudok dit Wagas un intudtudun Jesus un kanan da un bokona siya’d kustun tudtudu. Manuttuwaak pay sidat losana naikanglit sidit lintog Moses kan sidat iblun dat propetan Apudyus sidit. ");
INSERT INTO kmk_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mannamnamaak kan Apudyus un padan din mannanamnaman datun mamabpabasuḻ kan sakon. Namnamaok un paungaḻona kan katoy da’l losana tagu, laweng man onnu nabaḻu. ");
INSERT INTO kmk_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Isunga taḻona naammaak sidan losana kook daḻapnu adiyak makakokwa’t laweng sidin man-iilan Apudyus kan sidan tagu. ");
INSERT INTO kmk_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Lumabas man piga’n dagun un naidak Jerusalem, nangulinak ta umoyak mangitod si pilak un maituḻung sidat buḻun ku un Judio kan umoyak mandatun kan Apudyus sidin timplu. ");
INSERT INTO kmk_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Madama payyana mandatdatunak sit naka-il-an da kan sakon sidin timplu utdit magangputanon dit ugali un mandadaḻus. Naid adu si tagu’t di ot naid pay gulu. ");
INSERT INTO kmk_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yoong ininggaw da ud piga’n Judio un nanligwat sin lakub Asia ot dida okyan sad umoy mandaḻum nu awad ipabasuḻ da kan sakon. ");
INSERT INTO kmk_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Onnu, sadatu okyana tagu ud mangibaga nu singngadan dit indasan da un basuḻ ku utdit indatag da ud sakon sidat Sanhedrin. ");
INSERT INTO kmk_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Satu’l lawa ud magasmok ku’n indangsoḻa imbaga utdit summikadak sit atubang da un, ‘Mabistigalak kan dikayu’t tun satuna aḻgaw gaputa manuttuwaak un umungaḻ dat matoy nu timpu na.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Utdi, gaputa gattoka napatigammuwan si Felix maipanggop sidit Wagas di mantatagu un intudtudun Apu Jesus, pinansaḻdong na dit mambistigalan da kan Pablo un kanana’n, “Asik ibanag tuwa daḻum nu dumatong si Lisias un ap-apun di suldadun di Roma.” ");
INSERT INTO kmk_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ot binilin na dit opisyal un maituluy un maandogan si Pablo yoong palubusana si akita waya na kan adina iyapa dat gayyom na un umoy tumuḻung sidat kasapulana. ");
INSERT INTO kmk_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lumabas man piga’n aḻgaw dummatong da Felix kan Drusila un asawa na un osa’n Judio. Pinaayag na si Pablo ot didingngoḻ da dat imbaga na maipanggop sidit manuttuwaana kan Jesu Kristu. ");
INSERT INTO kmk_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Yoong utdit ipalpalawagon Pablo dat maipanggop si kinalintog, kina-attom un adi mangwa si laweng kan sadit dumakngan dit aḻ-aḻgaw un mangukuman Apudyus, nakakimut si Felix. Ot kinnanana un, “Manaḻan ka yan. Asik payyan sika ayagan nu awad timpuk.” ");
INSERT INTO kmk_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Utdi payona timpu, kanayuna paayagan Felix si Pablo daḻapnu kabagbaga na ta mannamnama un itdan Pablo si pilak. ");
INSERT INTO kmk_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Lumabas man duwa’n dagun naisukat si Porcio Festo kan Felix un gubinnadul. Yoong gaputa piyaon Felix un maaḻa dit mampipiyan dat Judio kan siya binaybay-ana si Pablo un dit mababaḻud. ");
INSERT INTO kmk_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Dummatong si Festo utdin Cesarea daḻapnu mantulaya gubinnadul. Ot lumabas man tuḻu’n aḻgaw inummoy Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Dumatong man sidi, indatag dat aappun di padi kan pappangat di Judio kan siya dit daḻum da kan Pablo. Nakapangpangngaasi da kan Festo ");
INSERT INTO kmk_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","un ipadaḻan na si Pablo ud Jerusalem daḻapnu dida’d manguis kan siya, yoong sat panggop da lopangon da utdit daḻan. ");
INSERT INTO kmk_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Summungbat si Festo un, “Maaandogan si Pablo ud Cesarea ot adi bali ta mangulinak sidi un masapa. ");
INSERT INTO kmk_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ot ibaun yu dat pappangat yu un maibuḻun kan sakon ud Cesarea daḻapnu dida ud mangidatag sit daḻum yu kan siya nu awad nakabasuḻana.” ");
INSERT INTO kmk_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ininggaw si Festo utdin Jerusalem si waḻu onnu simpuḻu’n aḻgaw asina gummusada nangulin ud Cesarea. Mabigat man inummoy sidit kukuisana ot imbaga na un idatong da si Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Makaḻnok man si Pablo dinalinup dat Judio un nanligwat ud Jerusalem ot inlapu daona man-ibaga’t dat adu’n nadagsona ipabasuḻ da kan siya yoong adi da mapanoknokan dida. ");
INSERT INTO kmk_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ot summungbat si Pablo un, “Naid ud kingkingwak si maisuganggang sit lintog mi un Judio onnu utdit timplu kan ulay sit Emperador ud Roma.” ");
INSERT INTO kmk_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Yoong piyaon Festo un maaḻa dit mampipiyan dat Judio kan siya ot inimusana si Pablo un, “Piyaom kada umoy sin Jerusalem ta siya’d manguisak sidatuwa naipabasuḻ kan sika?” ");
INSERT INTO kmk_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Yoong summungbat si Pablo un, “Madik Apu, ta antuwakon un sumisikad situn uukkuman di Emperador ud Roma un siya’d lumbonga makuisak. Ot titiggammum un naid gapu’d kingwak si laweng sidan kailiyaka Judio. ");
INSERT INTO kmk_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nu awad sinalungasing ku ut lintog kan kingwak si laweng un lobbonga mapatoyak maid kimut ku un matoy. Yoong nu maid katuttuwaan nat ipabasuḻ da kan sakon maid makabalina mangiyawat kan sakon kan dida. Kodawok un maiyoy tun kasuk kan Emperador ud Roma.” ");
INSERT INTO kmk_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Utdi, inimusan Festo dat buḻun na nu mabalin dit kindaw Pablo ot imbaga da un mabalin. Ot summungbat un, “Gapu ta kindaw nu un si Emperador ud Roma ud manguis kan sika boot padaḻnon mi ud sika’t di.” ");
INSERT INTO kmk_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Lumabas man ud piga’n duminggu dummatong da Ali Agripa kan Bernice un asawa na ud Cesarea daḻapnu ida umanggom kan Festo un bagu’n gubinnadul. ");
INSERT INTO kmk_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Utdiya ininggawan da’t di si piga’n duminggu, imbagan Festo kan Ali Agripa dit kasun Pablo un kanana’n, “Awad osa’n baḻud situ un tinengyan Felix. ");
INSERT INTO kmk_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ot utdit ininggawak Jerusalem, nandaḻum dat aap-apun di padi kan dat lalallakay di Judio kan sakon ot kindaw da un koddongak si Pablo un mapatoy. ");
INSERT INTO kmk_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Yoong kinnanak kan dida un bokona kadawiyan mi un iRoma un mangiyawat si tagu un naidaḻum nu daan na un makasinnangu’t nat nandaḻum kan siya daḻapnu awad waya na un manungbat sidat ipabasuḻ da kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Siya’d gapuna un utdit dummatong da uttun Cesarea, adiyak nantaktak. Utdit mabigat ummoyak sin kukuisan ot paindatong ku dit baḻud. ");
INSERT INTO kmk_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ot utdit summikada mambagbaga dat nangidaḻum kan siya, naid ud imbaga da si nakabasuḻana un kama’t dit ninamnamak. ");
INSERT INTO kmk_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nu adi sad oḻog da’l lawa’n nansisinnungbatan dit maipanggop sidit pammati da un Judio kan sadit tagu’n mangngadan kan Jesus un natoy yoong ibagabagan Pablo un matatagu. ");
INSERT INTO kmk_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Gaputa adik tigammu nu innok un mamistigal situwa kasu, inimus ku kan Pablo nu piyaona un umoy ud Jerusalem ta siyadi ud mabistigalana. ");
INSERT INTO kmk_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Yoong kindaw na un maandogan agingga’t sadit Emperador ud Roma ud mangoddong kan siya. Ot imbilin ku un maandogan agingga si maipadaḻan kan Emperador.” ");
INSERT INTO kmk_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Utdi, kinnanan Ali Agripa un, “Piyaok paya dongḻon tuwa tagu.” “Dongḻom an nu bigat,” insungbat Festo. ");
INSERT INTO kmk_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kadon sit mabigat, dummatong da Ali Agripa kan Bernice un nangkababḻu dat usal da kan taḻona napadayawan da un nilumnok sidit mimittingan un binuḻunan dat aap-apun di suldadu kan pappangat didiya ili. Ot imbilin Festo un maidatong si Pablo. ");
INSERT INTO kmk_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Idatong da man imbagan Festo un, “Apu Ali Agripa, kan dikayu’l losana awad situ, antu dit tagu un indaḻum dat losana Judio kan sakon sidin Jerusalem kan situn Cesarea un ipappakuy da un, Adina lumbong un matagu. ");
INSERT INTO kmk_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Yoong naid maodasak si laweng ut kingwa na un lobbonga mapatoyana. Ot gaputa kindaw na un si Emperador ud manguis kan siya impalubus ku un maipadaḻan kan siya. ");
INSERT INTO kmk_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Yoong naid nadotok si nakabasuḻana ut isulat ku kan Apu Emperador. Ot siya’d nampaiyoyak kan siya uttun atubang yu taḻon kan sika Apu Ali Agripa daḻapnu magangput kada maimusam, awad ud maisulat ku. ");
INSERT INTO kmk_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ta uttun somsomok ku lawenga ibaun ku’l lawa nat osa’n baḻud kan Emperador un maid nadotok si gapun di nakabasuḻana.” ");
INSERT INTO kmk_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Utdiyon imbagan Ali Agripa kan Pablo un, “Mabalin nu un mangikalintogan sinat long-ag nu.” Utdi intayag Pablo dit ima na daḻapnu guminok da asina nambagbaga un kanana’n, ");
INSERT INTO kmk_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nadayawa Ali Agripa, nagasatak situwa aḻgaw ta uttun atubang nu ud manungbatak sida’l losana nangidaḻuman dan buḻun un Judio kan sakon. ");
INSERT INTO kmk_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mataḻokak gaputa titiggammuma losan dat ugali taku’n Judio kan dat adi taku man-aannamungan. Isunga kodawok kan sika ta anusama dongḻon datu’n ibagak. ");
INSERT INTO kmk_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Sadan losana kailiyaka Judio titiggammu da dit mantataguk manipud naiyabengak sidin ili mi un Tarsus kan sit ininggawak sidin Jerusalem. ");
INSERT INTO kmk_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Titiggammu da kan mapanoknokan da nu piyaon da, un osaak un Fariseo un napegota manguunnud sidit relihiyon taku un Judio. ");
INSERT INTO kmk_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ot gaputa nanam-ok un matungpal dit insapatan Apudyus sidat ginnapuwan taku un paungaḻona dat natoy, antuwak sinsatun un mabistigal situn atubang nu. ");
INSERT INTO kmk_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Satu un insapatan Apudyus, siya pay ud nanam-on dat kaganakan dat kagwampuḻu’t duwa un aappu taku un matungpal, siya’d gapuna’n mandaydayaw da kan Apudyus si inaḻgaw kan linabi. Apu Ari, gaputa mannamnamaak situwa insapatan Apudyus, siya’d namabasuḻan dan Judio kan sakon. ");
INSERT INTO kmk_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kan dikayu’l losana naammung, apay ligaton yu un tuttuwaon un paungaḻon Apudyus dat natoy?” ");
INSERT INTO kmk_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Yoong ulay sakon sidit, sad tigammuk masapula kook ud kabooḻaka manuganggang sidat manuttuwa kan Jesus un iNazaret. ");
INSERT INTO kmk_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ot siyadi’d kingwaka tuwa’d Jerusalem. Adu dadit paimbaḻud ku un tagun Apudyus gaputa initdanak sidat aap-apun di padi si kalintogana mangwa. Ot nu makoddongan da un mapatoy, dagusa ampayunak pay. ");
INSERT INTO kmk_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Namin-adu un ummoyak sidat kasinasinagogan di Judio un mamaligat sidat manuttuwa ot pinadas ku un pinapilit dida’n mangibaga si maisuganggang kan Jesus. Gapu’t dit amod un suḻag ku kan dida inummoyak ulay pay sin adayu’n il-ili daḻapnu paligatok dat manuttuwa.” ");
INSERT INTO kmk_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Siya’d gapuna un inummoyak ud Damasco ot inggaw kan sakon dit kalintogan kan bilin dat aap-apun di padi. ");
INSERT INTO kmk_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ot utdiya inggawak sin daḻan si mamatuk, nadayawa Ali, nailak dit silawa nanligwat langit un amo napadda nu sadin init, naipaslang kan sakon kan sidat buḻun ku. ");
INSERT INTO kmk_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Utdi, losan kami un naidugsut sidit pita ot nagngoḻ ku dit ginga un kanana kan sakon sidit bagbaga un Hebreo un, ‘Saulo, Saulo, apay palpaligatom sakon? Paligatom pay lawan nat long-ag nu utnata kokkoom un padan dit baka nu ikussad na dit tutuduk.’ ");
INSERT INTO kmk_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Utdi inimus ku un, ‘Ngadan nu kad Apu?’ Summungbat dit Apu un, ‘Sakon si Jesus un palpaligatom. ");
INSERT INTO kmk_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yoong gumangun ka. Nampailaak kan sika ta dutukak sika un manselbi kan sakon. Sika ud mangipanoknok sidan udum sidan nailama maipanggop kan sakon situwa aḻ-aḻgaw kan uduma ipailak kan sika utdan madoḻdoḻa aḻ-aḻgaw. ");
INSERT INTO kmk_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Salaknibak sika utdan padama Judio kan sidan bokona Judio un dida’d mangibaunak kan sika. ");
INSERT INTO kmk_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tudtuduwam dida daḻapnu maila da dit katuttuwaan ot kumaan da utdit kakoḻpan ot umoy da utdin napadda. Tudtuduwam dida daḻapnu adi daon paitulayan kan Satanas nu adi paitulayan da kan Apudyus. Ta nu manuttuwa da, mapakawan dat basuḻ da kan maidoga da utdat pinilin Apudyus un tagu na.’ ” ");
INSERT INTO kmk_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Intuluy Pablo un kanana’n, “Nadayawa Ali Agripa, nanungpaḻak sidit impailan Apudyus kan sakon un nanligwat langit. ");
INSERT INTO kmk_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ot inwalagawag ku un masapula ibabawin dat tagu dat basuḻ da kad tuttuwaon da si Apudyus ot ipaila da utdat angwat da un tuttuwa’n nambabawi da. Siyatu’d inwalagawag ku un inlugik ud Damasco asi ud Jerusalem, kan sida’l losana lakub Judea, kadon sidan bokona Judio. ");
INSERT INTO kmk_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Siyatu ud gapugapun dit nanokmaan dat Judio kan sakon sidit ininggawak sidin timplu ot pinanggop da un patoyon sakon. ");
INSERT INTO kmk_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Yoong aginggana’t tuwa aḻgaw tinuḻutuḻunganak kan Apudyus ot antuwak situ un mangiwalagawag kan mangipanoknok kan dikayu’l losana tagu’n nangatu man onnu nadoba. Satu’n ibagak siya payon dit imbagan Moses kan dat propetan Apudyus un mapasamak, ");
INSERT INTO kmk_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","un sadit Kristu, masapula mampaligat kan mapatoy ot siya’d umuna un paungaḻon Apudyus un natoy daḻapnu ipatigammu na dit managuwan Apudyus sidan Judio kan bokon Judio ot siyadi dit kama’t silaw kan dida.” ");
INSERT INTO kmk_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Utdiya mampalpalawagan Pablo pinalesetan Festo un kanana’n, “Natingang ka Pablo, sanat amoda inadaḻ nu ud nampatingang kan sika.” ");
INSERT INTO kmk_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Yoong summungbat si Pablo un, “Bokona natingangak, Apu gubinnadul Festo. Tuttuwa datu’n ibagbagak kan dikayu kan nalimpiyu tun somsomok ku un mambagbaga. ");
INSERT INTO kmk_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Natuḻodaka man-ugud gaputa tigammuk un titiggammun Ali Agripa datu’n ibagbagak. Naid duwaduwak un titiggammuna dat losana naipasamak ta bokona nakwa da utdan nalingoda igaw. ");
INSERT INTO kmk_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Apu Ali Agripa, bokon kada manuttuwa ka utdat ingkanglit dadit propetan Apudyus? Titiggammuk un manuttuwa ka.” ");
INSERT INTO kmk_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Utdi summungbat si Agripa kan Pablo un, “Utnat somsomok nu maawis nu kad sakon un manuttuwa kan Kristu utnat sin-akitana lawa’n timpu?” ");
INSERT INTO kmk_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Summungbat si Pablo un, “Sin-akitan man onnu andu un timpu, iluwaḻuk kan Apudyus un sika kan sadatu’n mandodongngoḻ kan sakon situwa aḻgaw mambalin kayu si manuttuwa kan Kristu un kama kan sakon, puwela ullawa’n mabaḻud kayu.” ");
INSERT INTO kmk_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Utdi summikad si Ali Agripa, si Gubinnadul Festo, si Bernice kan dat udum paya ininggaw sidi. ");
INSERT INTO kmk_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Utdit makaḻaksun da, nambabagbagaan da pay lawan un, “Naid kingwan ditu un tagu si laweng un gapun di mapatoyana onnu mabaḻudana.” ");
INSERT INTO kmk_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ot imbagan Ali Agripa kan Festo un, “Nu Adina okyan kindaw un maiyoy kan Emperador ud Roma tu un kasu na, mabalin taku okyanon un pawayaan.” ");
INSERT INTO kmk_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Utdit maikoddong dit aḻ-aḻgawa mambapulan mi un umoy ud Italia, naipaima si Pablo kan dat uduma baḻud kan Julio un osa’t dat opisyal dat bungguy dat suldadu un mangadan si “Man-aandogon di Emperador.” ");
INSERT INTO kmk_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nanlugan kami utdit bapul un nanligwat Adrumeto un mansagsagana un manaḻan sidan gigillongan di bapul sidin probinsiya’d Asia. Kaysan kami ot buḻun mi si Aristarco un iTesalonica utdin probinsiya’d Macedonia. ");
INSERT INTO kmk_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mabigat man dummatong kami ud Sidon. Naanus si Julio kan Pablo ot pinalubusana un umoy na ilan dat gagayyom na utdi daḻapnu maitdan sidat masapul na. ");
INSERT INTO kmk_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Utdi, nambapul kami payyan manipud Sidon ot gaputa dupakon dikami utdit bayogbog nangoy kami utdin biik Chipre un maid bayogbog na. ");
INSERT INTO kmk_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Dinoḻmang mi din baybaya adani ud Cilicia kan Pamfilia ot dummatong kami ud Mira utdin Licia. ");
INSERT INTO kmk_vpl VALUES ("AC27_6","074_27_6","ACT","27","