﻿USE sofia;
DROP TABLE IF EXISTS sofia.kmh_vpl;
CREATE TABLE kmh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kmh_vpl WRITE;
INSERT INTO kmh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiysis Krays nop nusind yes nuk gok tikey amiy apiy gek nup tikyak rek aŋgniŋg gispiyn. Biyomb Ebraham tikek tik dand amiy, kiyŋ Depiyt nup tikeyak mey; Depiyt nund tikek tik dand amiy mey, Jiysis Krays nup tikyak. ");
INSERT INTO kmh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Kun giyak: Ebraham Aysek nup tikak. Aysek, Jekop nup tikak. Jekop nund pen, Jiwda nup tikiy, numam onep aŋgip ak tikiy gak. ");
INSERT INTO kmh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jiwda nuk biyn Tema yip mindiy, Peres yip Sera yip kuyip tikak. Peres, Hesron nup tikak. Hesron, Aram nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, Amiynadap nup tikak. Amiynadap, Nason nup tikak. Nason, Salmon nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Bowas nup tikak. Bowas nonim nuk ak Reyap. Bowas, Obet nup tikak. Obet, nonim nuk ak Rut. Obet, Jesiy nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesiy, kiyŋ Depiyt nup tikak. Depiyt, Solomon nup tikak. Solomon nonim nuk ak nind binak Yiwraya nup dek kumek, kisen Depiyt nup diy, Solomon nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, Riyabowam nup tikak. Riyabowam, Abaysa nup tikak. Abaysa, Esa nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa, Jospet nup tikak. Jospet, Joram nup tikak. Joram, Asaya nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaya, Jotam nup tikak. Jotam, Ewas nup tikak. Ewas, Hesekaya nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya, Manase nup tikak. Manase, Emos nup tikak. Emos, Josaya nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya, Jekoyakiyn nup tikiy, numam gunap tikiy gak. Ñin kun ak, Babiylon biynimb ap, Yisrel biynimb kuyip kalambis ay, dand Babiylon amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dand ameyak, Jekoyakiyn kun okok mindiy, Siyaltiyel nup tikak. Siyaltiyel, Serababel nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel, Abayat nup tikak. Abayat, Eliyakim nup tikak. Eliyakim, Yisow nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yisow, Sedak nup tikak. Sedak, Ekim nup tikak. Ekim, Elayat nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elayat, Eleysa nup tikak. Eleysa, Matan nup tikak. Matan, Jekop nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop, Josep nup tikak. Josep mey, biyn Mariya nup ñeyak, nuk yip ma kinak won ak, Mariya koŋgiy mindiy mey, Jiysis bi kiyŋ yomb key yimb kond mindyiŋgipay ak nup tikak. ");
INSERT INTO kmh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kun ak, basind chin Ebraham nund tikek tik dand, amiy apiy giy mey, basind kiyŋ Depiyt nup wanjrem piskind ak tikyak. Tikey Depiyt nund pen tikek amiy apiy gek, kunep wanjrem piskind ak amek, Babiylon kay ap kuyip kalambis ay dand miñmon kiyk ak amniyak. Dand ameyak, kisen pen tip ak tik dand amiy apiy giy, Krays nup wanjrem piskind ak tikyak. ");
INSERT INTO kmh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiysis Krays nup tikyak minim ak tikniŋg gispiyn: Jiysis nonim Mariya, Josep nup ñeyak, yip ma kinrik ñin ak niŋyak; Mariya ñapan koŋgiy mindek. Gor Kawnan nuk ak key gek, ñapan koŋgiy kun ak mindek. ");
INSERT INTO kmh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pen Josep bi suŋ-tep ak mey, minim yomb ma aŋgak. Ñapan koŋgiy mindip kun ak, biynimb okok aŋgñeniŋgayn, nup nambiŋ giniŋgamb. Kun ak nup kapkap aŋgyokiyn aŋgiy niŋak ak pen, ");
INSERT INTO kmh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","kisyim biyaŋ wisin niŋak: enjol bap aŋgak, “Josep, Depiyt ñinuk! Biyn kun ak yenen dinim aŋgiy gos ak ma niŋnimin; monmon dinimin. Ñapan koŋgiy mindip ak, Gor Kawnan anep gek mindip. ");
INSERT INTO kmh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kisen ñi ak tikek yomb giy, biynimb nuk gok gach kuyip ak wiykyokiy, di Nop yip jimñiy ayniŋgamb ak mey; yimb nup Jiysis aŋgnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aŋgak kun ak, bi Gor minim aŋgep bap giniŋgamb aŋgiy tikak rek nep gak. ");
INSERT INTO kmh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nuk aŋgak: “Biyn piñ bi yip ma kiniŋgamb bap, ñapan koŋgiy mindiy, ñi bap tikeniŋgamb; yimb nup ak Yimanwel aŋgniŋgambay aŋgak.” Yimanwel minim kiñiŋ ak, Gor chin yip mindip apay. ");
INSERT INTO kmh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pen Josep, enjol minim aŋgak ak diy, biyn Mariya nup dinim aŋgiy niŋak. ");
INSERT INTO kmh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kun ak Mariya ñi ak tikek, Josep ñi kun ak yimb Jiysis aŋgiy, kisen mey; Mariya nup pisnep dak. ");
INSERT INTO kmh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pen kiyŋ Herot mindek ñin ak, Mariya Jiysis nup tikak miñmon sikoy Betliyhem; Jiwdiya propens namb okok. Tikek, bi gap niŋep gok, pumb limgip tam okok nimb ap Jerusalem apiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Jiwda biynimb, kiyŋ chin apay ak nup tikpay! Miñiy dayey mindip akay? Miñmon chin okok mindiy niŋbun; gap ak limgamb niŋiy mey, nup lotiw giniŋg aswun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kun aŋgeyak, kiyŋ Herot minim kun ak niŋiy, ñapan kun ak nup gosimb niŋiy yip kirginiŋgiy rek ayip aŋgiy, gos kuŋay niŋak. Jerusalem biynimb kunep, gos kuŋay niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pen kiyŋ Herot, bi Gor nup simboŋgep yomb gok sek, bi low tiysa gok sek kuyip suk aŋgek apeyak aŋgak, “Bi kiyn yomb key yimb ak nup tikniŋgambay miñmon akay?” ");
INSERT INTO kmh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aŋgek aŋgyak, “Bi Gor minim aŋgep bap minim tikiy aŋgak rek: nup tikniŋgambay miñmon sikoy Betliyhem. Bi Gor minim aŋgep kun ak tikiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Jiwdiya propens namb okok, miñmon keykey kuŋay mindip, miñmon Betliyhem niŋey sikoy rek ayniŋgamb ak pen; Biyomb ak miñmon kun ak nimb apiy, biynimb yand Yisrel kay kuyip kond mindeniŋgamb. Kun giniŋgamb rek Betliyhem yimb yomb mindeniŋgamb aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kun aŋgeyak, kiyŋ Herot niŋiy, am bi gap niŋep gok kuyip kapkap suk aŋgek apeyak aŋgak, “Ñin akay rek gap kun ak limgak?” ");
INSERT INTO kmh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aŋgek, nup minim kun ak aŋgñeyak; kuyip Betliyhem aŋgyokniŋg, tom giy aŋgak, “Nimb am ñapan kun ak piyow niŋrep giy, yip ap aŋgem, yand kunep am nup lotiw ginim.” ");
INSERT INTO kmh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aŋgek kiyk saŋdiyakniŋ, gap ak nind nind gakniŋ; kiyk kisen giyak. Gap ak am am, ñapan ŋaŋ ak korip mindek namb siŋak nep aland gak. ");
INSERT INTO kmh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kun gek kuyip tep yimb gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","korip miŋgan biyaŋ amiy niŋyak: ñapan ŋaŋ ak nonim Mariya yip minderik. Am koŋgim yimiy, nup lotiw giy, wand kiyk gok aŋiy, nup gol gunap, pawil kuyrep wip rek gunap, wel kuy wip rek gunap ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pen kiniy wisin niŋyak: Gor aŋgak, “Andkind Herot ker ma amnimimb aŋgak.” Kun aŋgek niŋiy, kinjeŋ par bap amiy, korip kiyk amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pen kiyk kun giy amey, Josep wisin niŋak: enjol bap apiy nup aŋgak, “Herot ñapan ŋaŋ ak pikayin aŋgiy, piyow niŋniŋg gisap. Kun ak ñapan ŋaŋ amiymiŋay ak kasek poŋind, pirik Yijip amnimin. Pen winimin aŋgen nep, tip ak andkind winimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aŋgek, Josep kisyimnamb biyaŋ nep tikjakiy, ñapan ŋaŋ amiymiŋay ak poŋind Yijip amnak. ");
INSERT INTO kmh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Poŋind amnak kun ak, bi Gor minim aŋgep gok giniŋgamb aŋgiy tikyak rek nep gak. Tikiy aŋgyak, “Ñi yand ak Yijip nimb suk aŋgen winiŋgamb aŋgip aŋgyak.” Pen Josep amyoŋg apyoŋg am Yijip mindey, Herot kumek, tip ak andkind wiyak. ");
INSERT INTO kmh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pen Herot bi gap niŋep gok kuyip aŋgak rek ma geyak; nup milukrimey yimb yapek aŋgak, “Yip gipay kun ak, ñiŋaŋ biyomb mindniŋg gisap ak yergiy pik aynim aŋgak.” Pen gos bap niŋiy aŋgak, “Ñiŋaŋ kun ak kisen tikyak ñin ak, gap ak limgek, yip aŋgrep giy amniyak. Kun ak yand niŋbiyn: Betliyhem ñiŋaŋ tikey, simiy omiŋal yinimb gok sek, ñiŋaŋ kisen tiksipay gok sek pikjirikiy mey, ñi kun ak sek pikjirik ayniŋgambun aŋgak.” Kun aŋgiy, binuk gunap aŋgyokek am ñiŋaŋ Betliyhem maŋ okok mindeyak gok maŋgiysek pikjirik aydiyak. ");
INSERT INTO kmh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Betliyhem ñiŋaŋ pikjirik ayak kun ak, bi Gor minim aŋgep Jeriymaya giniŋgamb aŋgiy tikak rek nep giyak. Jeriymaya minim kun ak tikiy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Miñmon Rama simb gek, kilpul yomb aŋgiy, siy yomb aŋgniŋgambay. Biyn Resel tikek, tikey amiy apiy giniŋgamb gok, simb gek siy aŋgniŋgambay. Pen biynimb gunap, kuyip aŋgdep rek ma ayniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pen kisen biyomb Herot kumek, Josep miñmon Yijip kiniy wisin niŋak: enjol bap apiy nup aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bi ñapan ŋaŋ pikayniŋg giyak gok kumbay ak mey; biyn amiymiŋay ak poŋind, andkind miñmon Yisrel amnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aŋgek, Josep biyn amiymiŋay ak poŋind, andkind Yisrel amnak. ");
INSERT INTO kmh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pen amjakek, minim bap aŋgyak, “Herot kumek, ñinuk Akeleyas, Jiwdiya biynimb kuyip kond mindip aŋgyak.” Aŋgeyak Josep nuk Akeleyas mindip ak yergiy miñmon kun ak amnim aŋgiy pirikak ak pen, kiniy wisin niŋak: Gor nup aŋgak, “Jiwdiya propens ma andkind amnimin; Galiyliy propens amnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aŋgek, Josep Jiysis amiymiŋay kuyip poŋind am miñmon Nasaret mindyiŋgip. Amnak kun ak, bi Gor minim aŋgep gok giniŋgamb aŋgiy tikyak rek nep gak. Kiyk aŋgyak, “Nup bi Nasaret nimb aŋgniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nasaret mindeyak ñin namb kun ak, Jon bi ñiŋg pikñemb ap Jiwdiya miñmon nep namb okok mindiy, biynimb gok kuyip Gor minim tep ak aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kuyip aŋgñiy aŋgyiŋgip, “Maŋ mindip; Gor biynimb diy kond mindeniŋgamb ak mey; tap siy tap timey gipim ak yenen kun gipun aŋgiy kirgiy, Gor nup nep gosimb niŋnimimb aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon aŋgak kun ak, bi Gor minim aŋgep Asaya wosrey giniŋgamb aŋgiy tikak rek nep gak. Asaya minim kun ak tikiy aŋgak, “Bi bap biynimb kuŋay ma mindpay namb okok suk yomb aŋgiy aŋgniŋgamb, ‘Per biyomb ak asaw aŋgiy, biynimb gok kinjeŋ pindrep giy, kond mindey opay. Kun ak rek, nimb Biyomb ak asaw aŋgiy, tap siy tap timey gipim ak kirgiy, nup kond mindenimimb aŋgniŋgamb,’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pen Jon nuk kanj kamel kas diy giyak chech ak ay, ler ak namb ak pimbrikyiŋgip. Tap nuk ñimbyiŋgip ak; joŋ golbind ak sek, bum ñiŋg ak sek. ");
INSERT INTO kmh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ñin kun ak, Jerusalem biynimb diy, Jiwdiya miñmon namb okok maŋgiysek diy, Joden ñiŋg maŋ okok mindeyak gok diy, Jon mindek ak apiy, ");
INSERT INTO kmh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","tap siy tap timey giyak gok aŋg yikyakniŋ, kuyip Joden ñiŋg namb ak ñiŋg pikñak. ");
INSERT INTO kmh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pen Peresiy biynimb gok sek, Sanjiwsiy biynimb gok sek kuŋaynep, Jon chinup ñiŋg pikñaŋ aŋgiy apeyak, kuyip aŋg giy aŋgak, “Nimb siyŋ saraw ñapan guniy! Yerip gos ak niŋiy pirik opim? Ñiŋg pikon, Gor biynimb gunap kuyip aŋg giniŋgamb ñin ak, chinup ma aŋg giniŋgamb aŋgiy, pirik opim? ");
INSERT INTO kmh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ñiŋg pikniŋg, tap siy tap timey gipim ak kirgiy, mindrep gem mey, Gor nup gosimb niŋbay aŋgiy, nimbip ñiŋg pikñinim. ");
INSERT INTO kmh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pen nimb gos bap niŋiy; chin basind yes Ebraham ñapan nuk mindpun aŋgiy ma aŋgnimimb. Ebraham ñapan nuk apim ak tap yikop! Gor kamb guniy diy, Ebraham ñapan nuk gok gayniŋg gaypikop! ");
INSERT INTO kmh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Niŋrep ginimimb! Gor mon ak junj sek timbjiwniŋg, tiw ak mamb giy mindip. Mon siŋok, maŋgiy ñiŋemb tep gunap ma piyip gok, timbek amek, di mon yinjap ak yokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nimb tap siy tap timey gipim ak yenen kun gipun aŋgiy kirgiy, Gor nup gosimb niŋem mey, nimbip ñiŋg pikñimbiyn. Pen Bi kisen winiŋgamb ak biyomb yimb: yand bi yikop. Tomb tirup nup tuŋgasikyiŋg tap nup gok marik ginim rek ma ayip; yip nambiŋ gip. Yand nimbip yikop ñiŋg pikñimbiyn; Bi kun ak apiy, nimbip Gor Kawnan ak sek, mon maŋlaŋ rek ak sek ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Nuk wiyt maŋgiy pik gek gipay rek ak giniŋg gisap. Wiyt maŋgiy tep ak key ay, day day ak key ay giniŋgamb. Kun giy, wiyt maŋgiy tep gok dam korip miŋgan ayniŋgamb; day day gok dam mon per yin mindip ak yokniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ñin kun ak, Jiysis Jon yip ñiŋg pikñaŋ aŋgiy, miñmon Galiyliy kirgiy, Joden ñiŋg mindek ak amiy, ");
INSERT INTO kmh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","aŋgak, ‘Yip ñiŋg pikñan.’ Aŋgek Jon aŋgak “Nand nep mey, yip ñiŋg pikñimbinap. Pen yand nip yergiy ñiŋg pikñinim?” ");
INSERT INTO kmh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aŋgek Jiysis aŋgak, “Nand aspan ak kirgiy, yand apiyn rek gey mey, Gor aŋgip aŋgip rek nep giniŋgambur aŋgak.” Aŋgek Jon “Niŋind apan” aŋgiy, Jiysis nup ñiŋg pikñak. ");
INSERT INTO kmh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pikñek, Jiysis ñiŋg gol siŋak apiy niŋak: semb biyoŋ miŋgan yikiy, Gor Kawnan ak yakir kochir rek nup ker wiŋind wak. ");
INSERT INTO kmh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kun giy wakniŋ, minim bap semb biyoŋ nimb apiy aŋgak, “Ñi kun ak, Ñi mapin yand. Nup niŋen, yip tep yimb gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ñin kun ak Gor Kawnan ak, Seytan biynimb gok kuyip per gip rek, nup kunep ginimuŋ aŋgiy, Jiysis nup poŋind, miñmon nep namb okok amnak. ");
INSERT INTO kmh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Poŋind amek, Jiysis miñmon nep namb kun okok tap ñimbiy mer; yikop nep mindek ñin nokom jiwiy, andikiy onep ar piskind ak amnak. Kun giy yikop nep mindek, nup yiwan yomb yimb ak gek, ");
INSERT INTO kmh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seytan apiy nup aŋgak, “Nand Gor Ñinuk mindiy ker, kamb biy diy aŋgey, biret ayek ñiŋan.” ");
INSERT INTO kmh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aŋgek Jiysis pen aŋgak, “Baybol buk ak tikiy aŋgyak, ‘Biynimb gok, tap ñiŋemb nep ñimbiy ma mindeniŋgambay; Gor minim aŋgip ak niŋiy mey, per mindeniŋgambay aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kun aŋgek, Seytan Jiysis nup dand Jerusalem amiy, dam Gor aŋgniŋep korip yiy akyoŋ giyak ar ak ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Yand Gor Ñinuk mindpiyn aŋgiy, pindeŋg man biyaŋ ayan. Baybol buk ak tikiy aŋgyak, ‘Gor enjol nuk gok aŋgek, ñin kind nip ak di mindeniŋgambay mey, kamb tomb nip ma piŋiyniŋgamb aŋgyak’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aŋgek Jiysis aŋgak, “Baybol buk ak minim gunap sek tikiy aŋgyak, ‘Gor Biyomb ak nup ñiñloŋ ay ma aŋgniŋnimimb aŋgyak’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aŋgek, Seytan Jiysis nup dand dum yomb bap amiy aŋgak, “Miñmon tep tep biyomb keykey kond mindpay guniy niŋan! ");
INSERT INTO kmh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nand koŋgim yimiy yip lotiw geniŋgamban, miñmon kun guniy nip maŋgiysek aŋgniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aŋgek Jiysis Seytan nup aŋgak, “Nand key okok amnoŋ! Baybol buk ak tikiy aŋgyak, ‘Biyomb Gor nup nep aŋgniŋiy, woŋg nup gok nep ginimimb aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aŋgek Seytan Jiysis nup kirgiy amnakniŋ, enjol gunap ap Jiysis nup kond mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ñin kun siŋak, Jon bi ñiŋg pikñemb ak nup kalambis ayeyak, Jiysis minim kun ak niŋiy, miñmon Galiyliy amnak. ");
INSERT INTO kmh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amiy miñmon nuk Nasaret ma am mindek; am mindek miñmon Kapaniyam, Galiyliy chemb gol ak. ");
INSERT INTO kmh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Biynimb miñmon kun okok kuyip minim tep ak aŋgñi mindyiŋgip ak mey; bi Gor minim aŋgep Asaya giniŋgamb aŋgiy tikak rek nep gak. Nuk aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Miñmon Sebyiwlan Naptalay, Galiyliy chemb pis biy sek, biynimb Jiwda mer Joden ñiŋg kind bindoŋ mindpay gok sek melik ak niŋniŋgambay. Kisyim okok mindiy kumniŋgiy rek ayniŋgamb ak pen; melik yomb yimb ak niŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jiysis ñin kun ak kiñiŋ giy, biynimb okok kuyip Gor minim tep ak aŋgñiyiŋg aŋgak, “Tap siy tap timey gipim ak yenen kun gipun aŋgiy kirgiy, Gor nup gosimb ak niŋnimimb. Yenen Gor biynimb diy kond mindeniŋgamb ñin ak maŋ yimb asaw aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jiysis Galiyliy chemb gol ak apiy niŋak: bi piys dep mamiymiŋay ak, wimben yokiy, piys derik. Bi mamiymiŋay kun ak, numam bap yimb nuk Enjriw; numam bap Saymon. Saymon nup ñin gunap, Piyta aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jiysis kuyipmiŋay niŋiy aŋgak, “Yip kindik ger mey, nirip aŋgen, bi piys dep mer, biynimb dep omiŋal ak mindeniŋgayr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aŋgek, aŋgak rek niŋiy, piys derik wimben ak kirgiy, Jiysis chirup aŋgñirep ginimuŋ aŋgiy nuk yip taŋgyiŋgipiyr. ");
INSERT INTO kmh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pen won bap tapin amiy niŋak: Jemis yip, Jon yip, nop Sebediy yip bot miŋgan ak apyoŋgon mindyiŋg, wimben ak girep geyak. ");
INSERT INTO kmh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jiysis niŋiy kuyipmiŋay suk aŋgek, wimben gok kirgiy, Jiysis chirup aŋgñirep gaŋ aŋgiy yip amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiysis miñmon Galiyliy namb okok giraŋgyiŋg, Jiwda lotiw korip miŋgan okok amiy; Gor biynimb diy kond mindeniŋgamb minim tep ak, kuyip aŋgñiyiŋg, biynimb tap gak gok sek, tap yerip yerip gak gok sek gek suŋ ayiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kun gek, Siyriya biynimb miñmon sikoy okok maŋgiysek minim kun ak niŋiy, biynimb tap keykey gak gok dand apey, nuk gek suŋ ayak. Biynimb kun gok, gunap yikop tap gak; gunap windin mayn apek apyap pikiy jep diyiŋgipay; gunap ñin tomb kalaw gak. ");
INSERT INTO kmh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pen Jerusalem biynimb diy, Jiwdiya biynimb diy, Joden ñiŋg taw akdoŋ ken mindeyak biynimb gok diy, kuŋaynep Jiysis amnakniŋ, kisen amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jiysis, biynimb kuŋaynep kun gok niŋiy, am dum biyoŋ binuk onep wimiŋgan ak yip bisiŋg mindyiŋg, kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nuk kuyip aŋgñiyiŋg aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Biynimb Gor minim niŋrep ma gipun aŋgiy, yimgeprek mindpay gok, Gor kuyip diy kond mindeniŋgamb ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Biynimb siy apay gok, Gor kuyip aŋgdiniŋgamb ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Biynimb sayn kapkap mindpay gok, kiyk mankumb diniŋgambay ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Gor biynimb tep nuk mindenjun aŋgiy, niŋbay gok kuyip kond mindeniŋgamb ak mey; miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Biynimb simb niŋbay gok, Gor kuyip pen simb niŋiy diniŋgamb ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Biynimb Gor nup gosimb nokom niŋbay gok, Gor nup niŋniŋgambay ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Jimñiy mindenjun aŋgiy gipay biynimb gok, Gor kuyip ñapan yand aŋgniŋgamb ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Biynimb suŋ-tep mindey kuyip timey gipay gok, Gor kuyip diy kond mindeniŋgamb ak mey, miñmiñ giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nimbip Jiysis biynimb nuk aŋgiy, gi timey giy, minim yesek aŋgiy aŋgjiweniŋgiy, miñmiñ yimb ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bi Gor minim aŋgep wosrey gok kuyip, ar kun ak nep giyak. Kun ak nimbip kunep giyakniŋ, gos yomb ma niŋnimimb; Gor chinup direp giniŋgamb aŋgiy miñmiñ yimb ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nimb biynimb mankumb biy sol kiyk rek mindpim. Pen sol ak yindik nuk ak amdek, pisnep timey gip aŋgiy diyokey, tawsimbjakpay. ");
INSERT INTO kmh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Dawin yomb dum biyoŋ mindiy, weyginiŋgiy rek ma ayniŋgamb; miseŋ yimb mindeniŋgamb. Kun ak rek biynimb yand gok. Nimb biynimb gunap melik kuyip ak mindpim. ");
INSERT INTO kmh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lam ak daŋgiy tiyn miŋgan okok ma aypay; biynimb niŋrep giyaŋ aŋgiy, ar siŋbiyoŋ tik aypay. ");
INSERT INTO kmh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kun ak rek, nimb mind tep gem, biynimb niŋiy, Nap semb biyoŋ mindip anup yimb ak dand araniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nimb yip aŋgniŋgambim: Gor low minim, Mosis aŋgak gok sek, bi Gor minim aŋgep gunap aŋgyak gok sek kirginimimb aŋgniŋg wip aŋgniŋgambim ak pen; ak mer! Yand winik ak, bi Gor minim aŋgep gok giniŋgamb aŋgiy aŋgyak rek, maŋgiysek ginimuŋ aŋgiy winik. ");
INSERT INTO kmh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yand nimbip niŋind yimb apiyn. Semb biyoŋ sek, mankumb biy sek pisnep kurginimuŋ rek ayip ak pen; Gor minim nuk ak ma kurginiŋgamb; perper nep mindeniŋgamb. Minim yerip yerip aŋgak ak, aŋgak rek nep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Kun ak biynimb an Gor low minim ak niŋiy, minim sikoy won bap kirsipiyn aŋgiy, biynimb gok sisker aŋgñey kirginiŋgambay ak; Gor biynimb diy kond mindeniŋgamb ñin ak, yimb kuyip apyowniŋgamb. Pen biynimb an Gor low minim niŋiy, niŋrep giy, biynimb gok kuyip aŋgñirep giniŋgambay ak; Gor biynimb diy kond mindeniŋgamb ñin ak, yimb kuyip ak araniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bi Peresiy gok sek, bi low tiysa gok sek ‘Tep gipun’ apay ak pen; biynimb suŋ-tep ma mindpay. Kiyk gipay rek nep gem amniŋgamb ak; Gor miñmon tep nuk ma amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Wosrey napis nasind yes gok, Gor low minim aŋgyiŋgipay ar ak nimb niŋbim. Kiyk aŋgyiŋgipay, ‘Biynimb ma ñaŋgnimimb. Biynimb bap, biynimb bap nup ñaŋgayniŋgamb ak, kor niŋniŋgamb aŋgyiŋgipay.’ ");
INSERT INTO kmh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Minim kun ak niŋbim ak pen, nimbip miñiy aŋgrep giniŋgayn. Biynimb bap, biynimb bap nup miluk niŋniŋgamb ak, kor giniŋgamb. Biynimb bap, biynimb bap nup aŋgjiweniŋgamb; Jiwda kanjsol gok ap nan-giy, nup minim yomb aŋgniŋgambay. Biynimb bap, biynimb bap nup pen aŋgniŋgamb, ‘Nand bi sakiy sek yimb’ aŋgniŋgamb ak, mon key yinjap miŋgan ak amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kun ak nimb tap dam Gor nup kamb bind ar ak simboŋg ñiniŋg; mam ay gunap kuyip gipik rek minim mindip aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","am kuyip minim aŋgrep giy apiy nep, tap kun ak Gor nup simboŋg ñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tap yerip timey giniŋgambim ak, nimbip kor giniŋg, dand kinjeŋnamb okok kisen amniyakniŋ, kiy yip minim kun ak aŋg sayn giy, jimñiy mindenimimb. Mer ak, dam biyomb kor niŋep ak nup ñeniŋgambay, nuk pen nimbip di poliys kay kuyip ñek, nimbip dam kalambis ayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nimbip niŋind yimb apiyn: tap day nimb ak pisnep day paŋg diy rek, mis ambikip. ");
INSERT INTO kmh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Pen nimb niŋbim; minim bap aŋgyak ‘Biyn siy bi siy ma ginimimb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pen yand nimbip aspiyn: bi bap biyn bap nup niŋiy, nup dipnip aŋgiy gos niŋniŋgamb ak, Gor niŋek bi kun ak gosimb nuk namb biyaŋ, tap siy giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kun ak, windin maŋgiy yipund pis ak niŋiy, tap siy tap timey gep rek ayonimuŋ, windin piskind kun ak tuŋgjiwyoknimimb. Pen windin nimb ak simb niŋniŋgambim ak; tap siy tap timey giy, mon key yinjap ak amnimimb rek ayip. ");
INSERT INTO kmh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pen ñin yipund kind ak kunep, tap siy tap timey giniŋg gonimuŋ, timbrik yoknimimb. Kun giy mey, ñin piskind ak nep mindiy kim amniŋgambim. Yikop ak, mon key yinjap ak amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nimb niŋbim; minim bap aŋgyak, ‘Bi bap biynuk nup kirginiŋg, biyn biy pisnep kirsipiyn aŋgiy, ñiwkil band bap tikiy biyn kun anup ñiy mey, pisnep kirginiŋgamb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pen yand nimbip aspiyn: bi biyn kiyk gok waŋ siy dey mer, yikop nep aŋgyokey am bi kisen diniŋgambay akaŋ yergeniŋgambay, bi kun gok minim yomb diniŋgambay. Pen kisen bi biyn aŋgyokniŋgambay kun ak diniŋgambay ak, kunep timey giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Wosrey minim bap aŋgyak ak kunep niŋbim. Minim kun ak aŋgyak, ‘Gor nup tap bap giniŋgayn aŋgiy, aŋgnimimb rek nep ginimimb; nup minim nep ma aŋgnimimb aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pen nimbip aspiyn: minim bap aŋgniŋg, Gor windin maŋgiy ar ak niŋind aspiyn aŋgiy, ma aŋgnimimb. Semb biyoŋ mindip rek, niŋind apiyn aŋgiy ma aŋgnimimb. Ak Gor miñmon nuk yimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lum biy mindip rek niŋind apiyn aŋgiy ma aŋgnimimb. Ak Gor miñmon sikoy nuk bap mey kun ak. Jerusalem mindip rek niŋind apiyn aŋgiy ma aŋgnimimb. Ak Biyomb ak miñmon nuk bap mey kun ak. ");
INSERT INTO kmh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jun won yand mindip rek, niŋind apiyn aŋgiy ma aŋgnimimb. Nimb key gem, jun kas nimb ak, sum akaŋ mosimb jakniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kun ak, giniŋgayn aŋgiy, giniŋgayn nep aŋgnimimb. Pen ma giniŋgayn aŋgiy, ma giniŋgayn nep aŋgnimimb. Minim kilis yimb aŋgjun aŋgniŋgambim ak, Seytan nimbip gos ñek aŋgniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Pen minim bap aŋgyak, ‘Windin maŋgiy ak piŋiy jiweniŋgiy, kuyip pen kunep piŋiy jiwnimimb. Meŋg kamb pikpaŋgeniŋgiy, kuyip pen kunep pikpaŋgnimimb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pen nimbip aspiyn: Bi bap nimbip timey gonimuŋ, nup pen ma timey ginimimb. Bi bap nimbip mikem piksil gonimuŋ; andikem piskind ak kunep piknimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nimbip kor giy, tiŋgliys nak ak yip sanj gan aŋgonimuŋ, tiŋgliys nep ma ñinimimb; kolsiyor ak sek ñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nimbip tap wand biy dam tip siŋak yokiy wan aŋgey; yiruk ma niŋnimimb; tip aŋgniŋgiy siŋak silgiy, yesek tip ak yokiy winimimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chinup tap gunap ñim aŋgeniŋgiy, monmon ñinimimb. Pen chinup tap gunap yikop ñem; kisen nimbip tip ak ñiniŋgambun aŋgeniŋgiy, ma kirginimimb, monmon ñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Minim bap aŋgyak, ‘Buŋgiy nimb gok kuyip wasemb aynimimb; biynimb penpen ñaŋgep nimb gok kuyip miluk niŋnimimb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pen nimbip aspiyn: Biynimb penpen ñaŋgep nimb gok kuyip wasemb ay; biynimb nimbip gi timey gipay gok Gor nup aŋgniŋem kuyip kond mindonimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Kun giniŋgambim ak, Nap semb biyoŋ ñapan nuk yimb mindiy mey, kun giniŋgambim. Nuk biynimb mindrep gipay gok sek, biynimb mindrep ma gipay gok sek simb niŋimb rek, gek pumb niŋiy miñmon pikiy tap woŋg kuyip gok jakip. ");
INSERT INTO kmh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Biynimb nimbip wasemb aypay gok nep kuyip direp giniŋgambim ak; bi takes dipay gok gipay rek nep giniŋgambim. Kun ak Gor nup yergiy tep gek, nimbip kond mindrep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Buŋgiy nimb gok kuyip nep ñin piksakniŋgambim ak, biynimb Gor nup gosimb ma niŋbay gok gipay rek nep giniŋgambim. Kun gem, Gor nup yergiy tep giniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Kun ak Nap semb biyoŋ mindrep yimb gip rek, nimb kunep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pen nimb biynimb windin yirik ar ak nep mindrep ginjun aŋgiy, gem amniŋgamb ak; Gor nimbip yergiy direp giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Biynimb Gor nup gosimb niŋbun aŋgiy tom nep gipay gok, gipay rek ma ginimimb. Kiyk biynimb simbgeprek gok kuyip maniy ñiniŋg nan-gep korip biynimb kuŋay mindpay namb ak akaŋ, kinjeŋ yomb okok nep ñimbay. Yimb yomb dun aŋgiy gipay kun ak, Gor kuyip direp ginimuŋ rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Pen nimb biynimb simbgeprek gok kuyip tap ñiniŋg, miseŋ ma ñinimimb; ");
INSERT INTO kmh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kapkap weygiy ñinimimb. Tap weygiy gipun gok Bapiy Gor niŋimb ak mey, giniŋgambim kun ak niŋiy, nimbip direp giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nimb Gor nup aŋgniŋniŋg, biynimb yesek gunap gipay rek ma ginimimb. Kiyk biynimb gunap chinup niŋey yimb yomb diniŋgambun aŋgiy, am lotiw korip namb ak mindiy akaŋ, am kinjeŋram okok mindiy, Gor nup aŋgniŋbay. Yimb yomb diniŋg gipay kun ak, Gor minim kuyip ak ma niŋniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kun ak nimb Gor nup aŋgniŋniŋg; korip ñiluk miŋgan ak amiy, kinjeŋ giñiy, Bapiy nup aŋgniŋnimimb. Tap kapkap gipim ak maŋgiysek niŋimb rek, minim kun ak niŋiy, aŋgniŋniŋgambim rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Biynimb Gor minim ma niŋbay gok, nup aŋgniŋniŋg, minim paryomb yimb apay. Gos kiyk ak minim paryomb aŋgon mey niŋniŋgamb apay! ");
INSERT INTO kmh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pen nimb kun ak rek ma ginimimb. Minim yerip Gor nup aŋgniŋniŋg gipim gok, nuk nind niŋimb. ");
INSERT INTO kmh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nup aŋgniŋniŋg, kun giy aŋgnimimb: ‘Bapiy yomb semb biyoŋ; yimb nand yiy ar biyoŋ mindip. ");
INSERT INTO kmh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nand chinup diy kond mindenimin; semb biyoŋ aŋgek niŋbay rek ak, chinup gey kun ak rek niŋjun. ");
INSERT INTO kmh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chinup tap ñiŋemb minek minek ñimbun rek ak ñinimin. ");
INSERT INTO kmh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Biynimb gunap chinup timey gey niŋiy kirpun rek, tap siy tap timey chin gipun gok niŋiy kirginimin. ");
INSERT INTO kmh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Chin yikop mindiy, tap siy tap timey giniŋgambun rek ayip ak; chinup kond mindey, timey ma ginjun.’ ");
INSERT INTO kmh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pen biynimb gunap nimbip timey gey, niŋiy kirgeniŋgambim; Gor tap siy tap timey nimb giniŋgambim gok niŋiy kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pen nimb niŋiy ma kirginiŋgambim ak, Gor pen tap siy tap timey nimb giniŋgambim gok niŋiy ma kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nimb tap ñiŋemb kirginiŋg, biynimb yesek gok per gipay rek, ma ginimimb. Kiyk apay, miluk mer mer mindon, biynimb niŋiy aŋgniŋgambay, Gor nup gosimb niŋiy, tap ñiŋemb kirgiy mey, miluk mer mer mindpay aŋgniŋgambay. Nimbip niŋind yimb aspiyn: biynimb chinup niŋyaŋ aŋgiy giniŋgambay kun gok, yimb kuyip dand araniŋgambay ak pen, Gor kuyip direp ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nimb pen tap ñiŋemb gok kirginiŋg ginimimb ak; miluk mer mer ma mindenimimb. Ñiŋg pik tep giy, wel ay, kom giy mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kun geniŋgambim, biynimb gunap nimbip tap keñmaŋgiy bul gipay aŋgiy, ma niŋniŋgambay; Gor nep tap weygiy gipun gok maŋgiysek niŋimb rek, nimbip niŋiy direp giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pen man ar biy tap tep tep gok di nan-ginjun aŋgiy gos ak ma niŋnimimb. Tap kun gok nan-geniŋgambim; bi siydep apiy siy diniŋgambay akaŋ; simbsis giy, siplep siwiy giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kun ak tap tep nimb rek gok semb biyoŋ nan-gem; simbsis ma ginimuŋ, siplep ma siwnimuŋ, siy ma diniŋgiy, mindnep mindonimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tap tep nimb gok man ar biy di nan-geniŋgambim, gos nimb ak mindeniŋgamb man ar biy; semb ar biyoŋ nan-geniŋgambim; gos nimb ak amniŋgamb kun biyoŋ. ");
INSERT INTO kmh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Windin maŋgiy chin ak mey, lam rek mindip. Windin maŋgiy ak tep mindek; melik tep gamb niŋrep gipun. ");
INSERT INTO kmh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pen timey gek; kisyim apek ma niŋbun. Biynimb melik ma niŋbay gok, kisyimnamb okok mindpay. ");
INSERT INTO kmh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Bi nokom bap, biyomb omiŋal woŋg giñinimuŋ rek ma ayip. Yenen: biyomb bap nup niŋek tep geniŋgamb, bap nup kirginiŋgamb: akaŋ bap nup niŋek tep geniŋgamb, bap nup kirginiŋgamb. Kun ak rek, nimb maniy tap tep lum ar biy mindip gok niŋem tep gek, Gor nup kirginiŋgambim rek ayip ak; niŋrep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ar kun ak mey nimbip aspiyn: tap yerip ñimbiy mindenjun; chech akay nimb ay mindenjun aŋgiy, gos yomb ak ma niŋnimimb. Gor nimbip gayek mindpim ak; tap sikoy kun gok ma ñiniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nimb niŋbim: yakir gok tap yiŋ ma yimbay; wiyt, rays, tap gok ma tik dap nan-gipay. Bapiy semb biyoŋ ak kuyip kond mindek tap ñimbay. Yakir tap yikop ak tap ñek ñimbay; nimbip kunep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Akaŋ, gosimb kuŋay niŋiy mey, tapin mindiy kumniŋgambun aŋgiy niŋbim? ");
INSERT INTO kmh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pen yenen chech tap gok gos kuŋay niŋbim? Tap key jakip gok, chech napnap tap gok giniŋgiy rek ma ayip ak pen, sumsum teprep yimb gok mindip. ");
INSERT INTO kmh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kiyŋ Solomon tap kuŋay mindek ak pen; mokyaŋ tep kun gok rek ma gak. ");
INSERT INTO kmh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tap kaskas ak tap yikop. Per mindiy mer; miñiy rek mindiy, toy rek daŋgiypay. Pen Gor tap yikop kun gok gay mokyaŋ giñimb ak, yenen chinup ma kond mindeniŋgamb aŋgiy niŋbim? ");
INSERT INTO kmh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kun ak ñiŋg akay ñiŋjun; tap yerip ñiŋjun; chech akay nimb ayjun aŋgiy, gos yomb ak ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Biynimb Gor minim ma niŋbay gok, tap kun gok dun aŋgiy gos yomb kun ak rek niŋbay. Pen nimb niŋbim: Bapiy chin semb biyoŋ mindip ak tap nimb yerip tikdip ak niŋimb. ");
INSERT INTO kmh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kun ak, Gor biynimb gunap diy kond mindeniŋgamb ak, chinup sek dek biynimb suŋ-tep nuk gok mindonjun aŋgiy, nup gos nokom niŋiy gem amek mey; tap yikop kun gok diniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kun ak toy yergiy mindenjun aŋgiy gos yomb ak ma niŋnimimb; Gor nimbip minek minek nep kond mindip. ");
INSERT INTO kmh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Chin biynimb tep aŋgiy, biynimb gunap kuyip gos timey niŋniŋgambim ak, minim kun ak andkind nimbip ker winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kun ak niŋrep ginimimb. Nimb biynimb gunap kuyip giniŋgambim rek, Gor nimbip pen kun ak rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mon bopis windin nimbip pik yiwgiy mindip ak, yenen niŋaŋgiy mer, namam tap achip mindip ak nup niŋapim? ");
INSERT INTO kmh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Mon bopis yomb windin nimbip pik yiwgiy mindip kun ak diyokiy, windin niŋrep giy rek, namam tap achip mindip ak nup, diyokan aŋgiy apim. ");
INSERT INTO kmh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gor tap suŋ-tep nuk gok, kayn ayndik gok kuyip ma moknimimb; kumbap milip gok kanj sakiy mindeniŋgiy kiñiŋ siŋak monmon ma ginimimb. Kun giy monmon gem; kiyk tawpaŋg pikey amek, andkind apiy nimbip siwniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Tap yerip tikdonimuŋ, Gor nup aŋgniŋem nimbip ñiniŋgamb. Pen tap gunap piyow niŋiy niŋniŋgambim. Kinjeŋ yikan aŋgiy pik giygiw gem, nimbip yikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Biynimb nup aŋgniŋbay gok, aŋgniŋbay rek gip. Tap piyow niŋbay ak kuyip ñimb. Kinjeŋ ak yikan aŋgiy pik giygiw gey, apay rek niŋiy yikip. ");
INSERT INTO kmh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nimb bi ñapan sek gok, ñapan nimb bap biret nen aŋgek, kamb bap di ñimbikip? ");
INSERT INTO kmh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Akaŋ pen, piys nen aŋgek, siyŋ bap ñimbikip? Ak kun ma gipkip. ");
INSERT INTO kmh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nimb biynimb tep mer ak pen; ñapan nimb gok, kuyip tap tep gok nep ñimbim. Bapiy semb biyoŋ, bi tep yimb ak, nimbip yesek ar ak ma giniŋgamb; nimbip tep giniŋgamb ar ak nep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Pen biynimb gunap, chinup kun giyaŋ aŋgiy niŋbim rek nep, biynimb gok kuyip ginimimb. Gor low minim Mosis tikayak ak sek, bi Gor minim aŋgep gunap tikayak ak sek kiñiŋ mey kun ak. ");
INSERT INTO kmh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Mon key yinjap kinjeŋ yomb ak; miseŋ niŋiy amrep gipay. Biynimb kuŋaynep miŋgan kun ak ambay. Kun ak nimb niŋrep giy, permindep kinjeŋ sikoy ak diy amnimimb. Kinjeŋ sikoy kun ak kosyam tapay. Biynimb nokom nokom nep, kinjeŋ sikoy par kun ak piyow niŋiy ambay. ");
INSERT INTO kmh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pen biynimb Gor minim aspun aŋgiy yesek apay gok, kanj siypsiyp sayn tep rek silok ay winiŋgambay ak pen; ap mindyiŋg kayn ayndik biynimb siw ayip rek ak nimbip giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kun ak miñ giniŋgambay ak niŋiy, kiyk biynimb yerip rek mindpay ak niŋrep giniŋgambim. Nimb niŋbim: Miñ ñiwñiw sek yikop gok, tap maŋgiy ñiŋemb ma piyniŋgamb. Mon gok kunep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Mon ñiŋemb bind gok, maŋgiy ma ñiŋemb gok ma piyniŋgamb. Mon maŋgiy ma ñiŋemb bind gok ñiŋemb gok ma piyniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pen mon bind maŋgiy tep ma piyniŋgamb gok, timb dam mon yinjap ak yokniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kun ak miñ giniŋgambay ar ak niŋiy, biynimb gok tep, biynimb gok timey aŋgiy niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Biynimb yip Biyomb chin, Biyomb chin, apay gok Gor kuyip maŋgiysek diy kond mindeniŋgamb aŋgiy ma aŋgnimimb. Bapiy semb biyoŋ aŋgip rek gipay gok nep kuyip diy kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ñin kisen ak apek, biynimb kuŋaynep yip aŋgniŋgambay, ‘Biyomb chin mey nand nep. Minim tep woŋg nip ak ginuk. Yimb nip nep aŋgiy, tap biynimb ambaŋ ayak gok aŋgyokiy, tap mageprek gok giy ginuk aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yip kun aŋgniŋgambay ak pen, kuyip aŋgniŋgayn, ‘Nimbik biynimb yand mer: timey nep gipim! Key okok amnimimb aŋgniŋgayn.’ ");
INSERT INTO kmh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Bi gos niŋep yimb bap, korip nuk ak giniŋg, kamb ar ak gak. Kisen yiŋgen yomb diy, miñmon yomb pikiy, ñiŋg wilik apiy gak ak pen, korip nup ak ma pikjiw dand amnak. Kun ak rek mey, biynimb minim yip niŋiy dipay gok. ");
INSERT INTO kmh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","“Pen bi gos niŋrep ma gak bap, korip nuk ak giniŋg lum sayn ar siŋak gak. Kisen yiŋgen yomb diy, miñmon yomb pikiy, ñiŋg wilik apiy, korip nup ak pisnep pikjiw dand amnak. Kun ak rek mey, biynimb minim yip niŋiy kirpay gok aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jiysis minim kun ak aŋgjiwakniŋ, biynimb kuŋaynep ap mindeyak gok wal aŋgiy aŋgyak, “Bi low tiysa chin gok apay rek ma aŋgip; nuk bi minim niŋrep yimb giy aŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jiysis dum biyoŋ mindek ak kirgiy, mak biyaŋ apyowakniŋ, biynimb kuŋaynep kisen giyak. ");
INSERT INTO kmh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pen bi soy ayndik ayak bap, Jiysis mindek maŋ siŋak amiy, koŋgim yimiy, jiy kuyaŋgiy aŋgak, “Biyomb. Nand yip gey suŋ ayniŋg, gey suŋ ayniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kun aŋgek, Jiysis nup diniŋyiŋg, “Nip suŋ ayaŋ aŋgak.” Aŋgek, won kun anep suŋ ayakniŋ aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","“Nip gen suŋ ayip kun ak, biynimb gunap kuyip ma aŋgñinimin. Am bi Gor nup simboŋgep gok kuyip nep yomiy, ‘Yip suŋ ayip aŋgnimin!’ Kun aŋgiy, Mosis aŋgak rek, yakir dam Gor nup pik simboŋg ñinimin. Kun geniŋgamban, biynimb gok niŋiy, nup suŋ ayip ak mey kun gisap aŋgniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jiysis miñmon Kapaniyam amnakniŋ, amiybi gok kuyip kond mindyiŋgip biyomb bap ap Jiysis nup aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bi yip woŋg gip anup tap yomb giy, yiwur nembnemb gek, kawin kaskas ma giy; korip ak kum mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aŋgek Jiysis aŋgak, “Am nup gen suŋ ayniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Aŋgek amiy biyomb kun ak aŋgak, “Niŋind apan ak pen, yand bi tep rek korip yip ak amnimin. Yand niŋbiyn ak, amiy biyomb gunap yip kond mindey, yand pen amiybi gunap kuyip kond mindiy; amnimimb aŋgen, ambay sek; winimimb aŋgen, opay sek. Bi yip woŋg gip ak nup, woŋg gok kun kun giy ginimin aŋgen gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kun aŋgek, Jiysis gos kuŋay yimb niŋiy, biynimb kisen ameyak gok kuyip aŋgak, “Bi kun biy par okok nimb ak pen, Gor gip rek niŋrep yimb giy kun aŋgip. Bi chin Yisrel nimb bap, Gor nup gosimb niŋiy aŋgip kun ak rek aŋgey, yand ma niŋnik. ");
INSERT INTO kmh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kisen biynimb par okok nimb gok, Ebraham, Aysek, Jekop biriwin yip Gor biynimb diy kond mindeniŋgamb namb ak amiy; miñmiñ giyiŋg mindeniŋgambay ak pen; ");
INSERT INTO kmh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","biynimb chin Yisrel nimb gok, am namb kun ak ma mindeniŋgambay rek ayip. Gor kuyip aŋgyokeniŋgamb, am mindeniŋgambay mis kisyim owip ar biyaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jiysis kun aŋgiy, amiy biyomb kun anup aŋgak, “Nandkaw amnoŋ! Apan rek nep giniŋgamb aŋgak.” Kun aŋgek, korip amiy niŋak: binuk tap gak ak, Jiysis aŋgak won kun ak nep suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pen Jiysis Piyta korip amiy niŋak; Piyta numok nup mumbwak okok mon rek yinek kum mindek. ");
INSERT INTO kmh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Niŋiy am diniŋek, won anep suŋ ayek tikjakiy, Jiysis binuk gok yip kuyip tap keñmaŋgiy gayrep gak. ");
INSERT INTO kmh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Duŋgep won ak, biynimb kichekiy ambaŋ ayak gok sek, biynimb tap gak gok sek dand Jiysis mindek ak apeyak, nuk kichekiy gok aŋg mis yokiy, biynimb tap gak gok gek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nuk gak kun ak, bi Gor minim aŋgep Asaya, nind giniŋgamb aŋgiy tikak rek nep gak. Nuk tikiy aŋgak: “Tap chinup gip gok gek suŋ ayniŋgamb. Tap yerip yerip chinup timey gip gok aŋgyokek mind tep giniŋgambun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jiysis biynimb kuŋaynep ap nup piŋiy kus kus geyak niŋiy, binuk gok kuyip aŋgak, “Ñiŋg chemb kind bindoŋ amnun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kun aŋgakniŋ, bi low tiysa bap apiy nup aŋgak, “Tiysa. Nand miñmon akay akay amniŋgamban ak, yand yip nep amniŋgambur.” ");
INSERT INTO kmh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aŋgek Jiysis aŋgak, “Yakir gok, tip kiyk kinbay ak mindip. Kayn sakiy gok, man miŋgan okok kinbay; pen Bi bap Ñinuk kinimuŋ miŋgan ak ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pen bi Jiysis minim niŋyiŋgip bap aŋgak, “Yand nand yip amjur ak pen, yip yaw aŋgey, bapiy nup kumek komiy, nand yip giraŋgonjur.” ");
INSERT INTO kmh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aŋgek, Jiysis aŋgak, “Bi yip gosimb ma niŋbay gunap kumeniŋgiy, bi yip ma niŋbay gunap dam komniŋgiy; nand apey yand yip taŋgonjur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jiysis bot diy amniŋg gek, binuk gok yip saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ñiŋg namb siŋak amniyakniŋ, day yiŋgen yomb sikerek ak diy, ñiŋg paŋg apiy, bot ak tuŋgandikniŋg rek gak. Pen Jiysis nuk kinek rek, ");
INSERT INTO kmh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","binuk gok am nup aŋgey tikjakek aŋgyak, “Biyomb! Yiŋgen yomb ak chinup tuŋgandikek ñiŋg ñiŋjun rek ayip ak, aŋgey kirgaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aŋgeyak kuyip aŋgak, “Yenen piriksipim? Gor nup gosimb ak ma niŋbim rek ayip!” Kun aŋgiy tikjakiy, yiŋgen dek ak aŋgek kirgiy, ñiŋg paŋg apek ak wilekiy gak. ");
INSERT INTO kmh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kun gek, kiyk gos kuŋay niŋiy, “Biyomb biy yergiy aŋgek, yiŋgen ak kirgiy, ñiŋg paŋg apamb ak kirgiy gip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jiysis ñiŋg tikiy, miñmon Gadara pis bindoŋ amjakakniŋ, bi sakiy kichekiy ambaŋ ayak omiŋal ak, chip komyiŋgipay kamb miŋgan okok nimb apchakrik. Bi omiŋal kun ak kuyip kichekiy ambaŋ ayak rek, bi kilis yimb mindyiŋgipiyr. Biynimb bap mindyiŋgipiyr kinjeŋ tam kun ak ma amyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pen kiyk omiŋal apchakiy, Jiysis nup aŋgrik, “Gor Ñinuk! Chirup yerginiŋg aswan? Ñin nand chinup aŋg miñmon timey yokniŋgamban ak ma wip aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pen won kun ak, kanj kuŋaynep amil ñimbeyak yep gol kun siŋak ak mey, ");
INSERT INTO kmh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kichekiy bi omiŋal kun ak kuyip abaŋ ayak gok, Jiysis nup nembnemb giyiŋg aŋgyak, “Chinup aŋgyokniŋg ginimin ak, aŋgey am kanj mindpay gindoŋ kuyip molik sikun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aŋgeyak, amnim aŋgek, bi omiŋal kun ak kuyip kirgiy, am kanj gok kuyip molik sikeyak; kanj gok pirik miñmon minduŋ pis okok amiy, gindam ñiŋg maŋgiy chemb biyaŋ pikiy, ñiŋg ñimbiy maŋgiysek kumdiyak. ");
INSERT INTO kmh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pen bi kanj mokyiŋgipay gok gak kun ak niŋiy, kasek miñmon dawin yomb ak amiy, Jiysis yerer gak minim ak, biynimb okok kuyip aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aŋgñeyak kiyk maŋgiysek Jiysis nup niŋun aŋgiy, ap nup niŋiy, nembnemb giyiŋg aŋgyak, “Miñmon chinup biy kirgiy, key okok amnoŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jiysis tip ak bot diy, ñiŋg tikiy miñmon nuk kind bindoŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pen biynimb gunap, bi ñin tomb kalaw gak bap Jiysis gek suŋ ayniŋgamb aŋgiy yirar ay dand mindek ak wiyak. Pen Jiysis gek suŋ ayniŋgamb aŋgiy niŋyak rek, bi ñin tomb kalaw gak kun ak nup aŋgak, “Ñiyand. Gos sek mindenimin. Tap timey gipan gach ak miñiy niŋiy kirsipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aŋgek bi low tiysa gok, gunap aŋgyak, “Bi biy Gor nup aŋgjiwyiŋg asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pen Jiysis gos niŋyak kun ak key niŋiy aŋgak, “Nimb yenen yip gos timey niŋiy kun aspim? ");
INSERT INTO kmh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nup tap timey gipan gach ak wiykyokpiyn aŋgen, nimbip tep giniŋgamb akaŋ, tikjakiy amnoŋ aŋgen, nimbip tep giniŋgamb? Akaŋ minim yerip ak aŋgen, nimbip tep giniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nimb niŋbim. Yand Bapiy minim nup ak diy mey, man ar biy apiy, tap siy tap timey gipay gach ak wiykyokpiyn aŋgak.” Jiysis kun aŋgiy, bi ñin tomb kalaw gak anup aŋgak, “Tikjakiy, minj nak ak diy, dand korip amnoŋ!” ");
INSERT INTO kmh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aŋgek tikjakiy minj band ak dand korip nuk amek, ");
INSERT INTO kmh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","biynimb gok niŋiy, aŋgyak, “Bi man ar biy nimb bap kun ak rek gek ma niŋnuk;” nuk Gor nep aŋgek ap gisap aŋgiy, gos kuŋay niŋiy, yimb nup ak dand araniyak. ");
INSERT INTO kmh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jiysis miñmon kun ak kirgiy, wikan bap amiy niŋak: bi takes dep ak, woŋg giyiŋgip opiys miŋgan ak bisiŋg mindek. Bi kun ak yimb nuk Matyiw. Jiysis nup niŋiy aŋgak, “Yip kondan.” Aŋgek, nup kondak. ");
INSERT INTO kmh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pen bi takes dep gok diy, bi tap timey giyak gok diy, Jiysis binuk gok sek ap Matyiw korip ak tap ñiŋyak. ");
INSERT INTO kmh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ñimbeyak, bi Peresiy gok niŋiy, Jiysis binuk gok kuyip aŋgyak, “Tiysa nimb ak yenen, bi takes dep gok sek, bi tap siy tap timey gipay gok sek yip jimñiy tap ñiŋimb?” ");
INSERT INTO kmh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aŋgeyak, Jiysis minim kun ak niŋiy aŋgak, “Biynimb tap ma gip gok, dokta niŋniŋg ma ambay; biynimb tap gip gok nep dokta niŋniŋg ambay. ");
INSERT INTO kmh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pen Gor minim bap aŋgak ak junj ak niŋrep giy, niŋyiŋg mindenimimb. Nuk aŋgak, ‘Yip tap simboŋg ñem, tep ma giniŋgamb; biynimb gok simb niŋeniŋgambim, yip tep giniŋgamb aŋgak.’ Pen yand winik ak, biynimb suŋ-tep gunap piyow niŋniŋg ma winik; biynimb tap siy tap timey gipay gok diyn aŋgiy winik aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ñin bap, Jon bi ñiŋg pikñemb ak binuk gok Jiysis mindek ak apiy aŋgyak, “Chin yip bi Peresiy gok yip, ñin gunap Gor nup nep gos niŋun aŋgiy, tap ma ñimbun. Pen bi nand gok yenen kunep ma gipay?” ");
INSERT INTO kmh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aŋgeyak, Jiysis kuyip aŋgak, “Biynimb gok, biyomb kiyk ak yip mindeniŋgambay ñin ak, miñmiñ giy tap ñiŋniŋgambay; pen biyomb anup ñaŋg pikayniŋgambay ñin anep, simb gek tap bul giy ma ñiŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pen Jiysis nind giyiŋgipay ar ak key, miñiy aŋgen giniŋgambay ar ak key aŋgiy, kuyip minim bap paydoŋ ay aŋgak, “Chech kim ak diy, chech wor ay puŋgrikniŋgamb tam ak ma ñaŋgdiniŋgambay. Yenen: kun giy yim taŋgey, tam yomb sikerek ak puŋgrikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pen ñiŋg wayn ak kunep; wayn kisenimb ak giy, di meymey wak milip miŋgan ak ma paŋg ayniŋgambay. Yenen: kun geniŋgambay, ñiŋg wayn kim ak taniy, biŋ yimb aŋgiy, meymey wak ak puŋgrikiy, soŋgniŋgamb. Kun ak ñiŋg wayn kim ak diy, meymey wak kim nimb miŋgan ak dayey nep mey, tep giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jiysis minim kun ak aŋgakniŋ, Jiwda biyomb bap mindek siŋak ap koŋgim yimiy aŋgak, “Pañ yand ak pisnep kumimb ak pen, nand am nup diniŋey, tikjaknimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aŋgek, Jiysis binuk gok yip tikjakiy, bi kun ak yip amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pen biyn bap nup, biyn kinjeŋ pandikakniŋ mindek, simiy yin ayak wimiŋgan ak. Kun gek gos nuk anep niŋiy Jiysis chech paryomb nup gol okok nep diniŋen yip suŋ ayniŋgamb aŋgiy, Jiysis amnakniŋ kund okok ken amiy, chech nup ak diniŋak. ");
INSERT INTO kmh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Diniŋek, Jiysis tuŋgandikiy biyn kun ak nup niŋiy aŋgak, “Yip gosimb niŋban rek, nip gen suŋ ayip. Gos sek mindenimin aŋgak.” Aŋgek, tap nup giyiŋgip ak won kun ak nep suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pen Jiysis am am, biyomb korip ak amjakiy niŋak: biykul puŋgyiŋg, minim kilpul yomb yimb aŋgeyak. ");
INSERT INTO kmh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Niŋiy kuyip aŋgak, “Key okok amnim! Pañ biy ma kumimb; yikop wisin kinjap aŋgak.” Kun aŋgek nup sik aŋgeyak, ");
INSERT INTO kmh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kuyip aŋg mis yokiy, korip ñiluk miŋgan biyaŋ amiy pañ kumak anup, ñin kind ak dek, tikjakak. ");
INSERT INTO kmh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kun gek minim kun ak yiŋg dand miñmon okok maŋgiysek amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pen Jiysis miñmon kun ak kirgiy amnakniŋ, bi windin koy gak omiŋal ak nup kisen giyiŋg suk aŋgyiŋg aŋgrik, “Depiyt Ñinuk! Chirup simb niŋnimin aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kun aŋgerik, Jiysis nuk korip kinak miŋgan ak amnakniŋ, bi omiŋal kun ak apiy korip miŋgan amer, kuyipmiŋay aŋgak, “Nirmiŋay, chirup gek suŋ ayaŋ aŋgiy, yip aspiyr?” Aŋgek aŋgrik, “Yaw! Chir niŋbur, nand chirup geniŋgamban suŋ ayniŋgamb aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aŋgerik Jiysis windin kuyipmiŋay ak diniŋiy aŋgak, “Yip gosimb niŋbiyr ak, apiyr rek ginimuŋ.” ");
INSERT INTO kmh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aŋgek windin kuyipmiŋay ak suŋ ayek niŋrikniŋ, kuyipmiŋay aŋgrep giy aŋgak, “Jiysis gamb chirup suŋ ayip aŋgiy ma aŋgnimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kun aŋgak ak pen; kiykmiŋay amiy biynimb miñmon namb kun ak maŋgiysek aŋgñirik. ");
INSERT INTO kmh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pen kiymiŋay amnirikniŋ, biynimb gunap, bi tap abaŋ ayek minim aŋgep rek ma ayak bap, dand Jiysis mindek ak apeyak, ");
INSERT INTO kmh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tap nup ambaŋ ayak kun ak aŋgyokek, minim aŋgak. Kun gek, biynimb gok wal aŋgiy aŋgyak, “Miñmon Yisrel biy, bi bap kun ak rek gek ma niŋnuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pen bi Peresiy gok aŋgyak, “Nuk kichekiy malñiluk tap gok nop kiyk Seytan kilis ak diy mey, kun gisap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pen Jiysis nuk, dawin sikoy okok sek, dawin yomb okok sek giraŋgiy, Jiwda nan-gep korip okok amiy, kiyŋ yomb key yimb ak biynimb diy kond mindeniŋgamb minim tep ak aŋgñiyiŋgip. Biynimb gok kuyip tap yerip yerip gak ak kunep gek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nuk biynimb kun gok niŋak: kanj siypsiyp gok bi kond mindep kiyk bap ma mindip rek ak mindeyak. Gos yomb niŋiy kosyam mindeyak ak, kuyip simb niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","binuk gok kuyip aŋgak, “Tap keñmaŋgiy kuŋay yimb nep woŋg day ak wos gi mindip ak pen; biynimb pipaŋg dand winiŋgiy ak kuŋay ma mindpay. ");
INSERT INTO kmh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kun ak nimb Bi woŋgday nop nimb ak nup aŋgniŋem, bi pipaŋg dand owep gunap yokek, pipaŋg dand nup ker winiŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jiysis binuk onep wimiŋgan ak suk aŋgek apey aŋgak, “Yand key nimbip aspiyn ak mey, kichekiy malñiluk tap gok aŋgyokniŋg, aŋgyokniŋgambim. Biynimb tap yerip yerip giniŋgamb gok kunep gem, suŋ ayniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bi Jiysis minim dand amemb onep wimiŋgan kun ak, yimb kiyk mey; Bap Saymon, yimb nup bap Piyta aŋgyiŋgipay. Bap Enjriw: Piyta numam nuk ak. Bap Jemis: Sebediy ñinuk. Bap Jon: Jemis numam nuk ak. ");
INSERT INTO kmh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Bap Piyliyp. Bap Batlomiyiw. Bap Tomas. Bap Matyiw. Nuk takes diyiŋgip. Bap Jemis: Alpiyas ñinuk. Bap Taydiyas. ");
INSERT INTO kmh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Bap Saymon: yimb nup bap Selot aŋgyiŋgipay. Bap Jiwdas: nuk mey, kisen Jiysis nup mimuŋg gak. ");
INSERT INTO kmh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jiysis binuk kun gok kuyip minim tep woŋg ak ginimimb aŋgiy, aŋg keykey yokyiŋg aŋgak, “Nimb Samariya kay mindpay namb okok sek, biynimb Jiwda mer namb okok sek ma amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pen nimb am biynimb chin Yisrel, Gor nup gosimb ma niŋbay gok kuyip aŋgñiyiŋg aŋgnimimb, ");
INSERT INTO kmh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‘Gor biynimb diy kond mindeniŋgamb ñin ak maŋ wip aŋgnimimb.’ ");
INSERT INTO kmh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kun aŋgyiŋg biynimb tap ginimuŋ gok gem suŋ ay, biynimb pisnep kumniŋgiy gok gem, tip ak tikjakniŋgiy. Biynimb soy ayndik aynimuŋ gok, biynimb kichekiy malñiluk abaŋ aynimuŋ gok gem, suŋ ayniŋgiy. Bapiy chirapiy, nimbip per yikop woŋg gipur rek, nimb biynimb kun gok kuyip yikop woŋg giñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Maniy gunap dand ma amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wand, chech, tomb tirup, yirkondim, tap gok, dand ma amnimimb. Yenen: biynimb woŋg giñimbay gok, pen tap ñey ñimbay. ");
INSERT INTO kmh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pen dawin akaŋ, miñmon bap amjakiy, biynimb nimbip sik aŋgdiniŋgiy rek gunap niŋiy, kiy yip nep mindiy, miñmon bap key amniŋg nep kuyip kirgiy amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","Kun ak korip bap amiy, nimb mindpim aŋgem, yaw mindpun aŋgeniŋgiy, korip miŋgan kun ak amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pen nimbip ma sik aŋgdeniŋgiy; kiriŋg amniŋg, silkul tom beŋ nimbip chiŋgdiy mindonimuŋ ak, pipal pikem yapek amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nimbip niŋind yimb apiyn: kor yomb ñin ak, Sodom Gomora biynimb yiwur siskoy diniŋgambay; biynimb nimbip ma diniŋgambay kun gok, yiwur yomb yimb ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pen niŋim! Yand nimbip kanj siypsiyp rek ak, yoksipiyn: biynimb kayn ayndik rek mindpay namb okok. Kun ak gos niŋrep giyiŋg, kapkap mindrep giy kuyip aŋgñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Pen biynimb gunap nimbip chichiy diy, dam Jiwda nan-gep korip ak amey, kanjsol kiyk gok ap kor giy, nimbip pikniŋgambay. Kun ak niŋrep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nimbip Jiysis binuk aŋgiy, lipiŋg dand gapman biyomb mindeniŋgambay ak amey, minim tep yip ak, biyomb gok sek, bi miñmon paryomb okok nimb gok sek kuyip aŋgñiniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Nimbip kor giniŋgambay kun ak, minim yerip aŋgjun aŋgiy pirikiy, gos kuŋay ma niŋnimimb. Apikniŋ, Nap Gor Kawnan nuk nimb yip mindip ak, gos tep ñeniŋgamb, minim nimbik ar ak key ma aŋgniŋgambim; minim yipund giy yimb anep aŋgniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ñin kun ak numam gunap tikjakiy, numam gunap kuyip pikayaŋ aŋgiy, biyomb gok kuyip ñiniŋgambay. Nop gok tikjakiy, ñapan kiyk key gok pikayaŋ aŋgiy, biyomb gok kuyip ñiniŋgambay. Ñapan gok, nonim nop sikop kuyip kunep giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yip ker mindeniŋgambim rek, biynimb okok maŋgiysek nimbip niŋey, miluk yowniŋgamb. Pen biynimb kilis giy yip ker nep mindeniŋgambay gok; ñin kisen ak apek, Gor kuyip diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pen wikan bap amem, nimbip gi timey geniŋgiy, pirik wikan bap pen amnimimb. Nimbip niŋind aspiyn: Yisrel biynimb kuyip sayn nep aŋgñem amnakniŋ, Bi bap Ñinuk ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Ñapan sikul apay gok yomb mindey; tiysa kiyk gok sikoy ma mindpay. Pen tiysa mindip rek mindon aŋgiy mey, sikul apay. Biynimb woŋg giñimbay gok yomb mindey, biynimb kuyip kond mindpay gok sikoy ma mindpay. Woŋg gipay ak, biynimb yomb mindpay rek mindon aŋgiy, woŋg gipay. Kun ak rek, biynimb yand gok yand mindpiyn rek mindon aŋgiy gipay. Pen yip aŋgjiwiy, Seytan yimb nup bap ay, ‘Belsiybul’ apay ak, nimbip timey yimb giniŋgiy rek ayip. ");
INSERT INTO kmh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Biynimb kun gok kuyip niŋiy ma piriknimimb. Minim yerip miñiy yiwgiy mindip ak, kisen miseŋ mindeniŋgamb. Tap yerip kapkap gipay gok, kisen miseŋ niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Minim nimbip weygiy apiyn gok, nimb am miseŋ aŋgñinimimb. Nimbip mimuŋg tikyiŋg apiyn gok, korip ar biyoŋ amiy, aŋgñem niŋniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Nimb biynimb sinjrimey pikpay gok kuyip niŋiy ma piriknimimb. Kiyk yikop wak band anep pikayniŋgambay; mindmaŋgiy ak sek timey giniŋgiy rek ma ayip. Pirikniŋg mey, Biyomb biynimb mumbwak ak sek, mindmaŋgiy ak sek pikay, miñmon mon key yinjap yokniŋgamb anup piriknimimb. ");
INSERT INTO kmh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yakir sikoy gok, tap yikop. Maniy gach won nokom nep yokiy, omiŋal dipay. Tap yikop ak pen, Gor kuyip niŋmindip ak, yikop ma yap pikpay. ");
INSERT INTO kmh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jun kas nimbip ak, Gor maŋgiysek ñin paŋgip. ");
INSERT INTO kmh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kun ak ma piriknimimb. Yakir gok ma kond mindep rek kond mindip. ");
INSERT INTO kmh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Biynimb yip ker mindiy, biynimb okok kuyip miseŋ aŋgñiniŋgambay gok, yand pen Bapiy yomb semb biyoŋ mindip ak nup, yip ker mindpay aŋgiy, miseŋ aŋgñiniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pen biynimb an yip aŋgiy mindeniŋgambay namb ak, bi kun ak yand ma niŋbiyn aŋgniŋgambay gok, yand pen Bapiy semb biyoŋ anup, biynimb guniy yand ma niŋbiyn aŋgniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yand man ar biy opiyn ak, kapkap mindrep giniŋgambun aŋgiy, gos ak ma niŋnimimb. Yand winik rek, minim yomb aŋgiy, penpen giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ñi gok tikjakiy, nop yip penpen giniŋgambay. Pañ gok tikjakiy, nonim yip penpen giniŋgambay. Ñi biyn gok tikjakiy, nupis yip penpen giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kun giniŋgambay kun ak, korip keykey mindpay rek nep penpen giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Biynimb nop nonim kuyip akaŋ, ñi pañ kiyk gok nep gos niŋiy, yip ma niŋniŋgambay ak; biynimb yand rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Biynimb yip gosimb niŋniŋg, pen pikayniŋgambay rek ayip aŋgiy kirginiŋgambay ak, biynimb yand rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Biynimb keynep mindiy, mind tep giniŋgayn aŋgniŋgambay gok, mon key yinjap ak amniŋgambay. Biynimb Jiysis ker minden, yip pikayniŋg pikayniŋgiy aŋgniŋgambay gok, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nimb amem, biynimb nimbip wasiw aŋgdiniŋgambay gok, yip diniŋgambay. Pen yip diniŋgambay rek, Bi yip yokek winik ak nup diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Biynimb bi Gor minim aŋgep bap niŋiy, Gor woŋg gip rek, nup diniŋgambay ak, tep yimb giniŋgambay ak mey; Gor bi minim nup aŋgep ak direp giniŋgamb rek, kuyip kunep giniŋgamb. Biynimb Gor biyn bi suŋ-tep nuk bap niŋiy, Gor biynimb suŋ-tep nuk aŋgiy diniŋgambay ak, tep yimb giniŋgambay ak mey; Gor biynimb suŋ-tep nuk ak direp giniŋgamb rek, kuyip kunep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pen biynimb yip yikop yimb bap niŋiy, Jiysis ker mindip aŋgiy ñiŋg marik giniŋgambay gok; Gor niŋek tep gek, pen sakiy ma giniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jiysis binuk onep wimiŋgan ak kuyip, kun kun giy ginimimb aŋgiy aŋgñirep giy, miñmon kun ak kirgiy, dawin yep maŋ kun okok amiy, biynimb gok kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pen Jon bi ñiŋg pikñemb ak kalambis mindiy, Krays yerer gak minim ak niŋiy, binuk gunap aŋgyokek Jiysis mindek ak amiy, ");
INSERT INTO kmh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nup aŋgniŋiy aŋgyak, “Nand mey bi kiyŋ yomb key yimb aŋgiy per kond mindpun ak nep opan akaŋ, bi kisenimb kun ak key kond mindonjun?” ");
INSERT INTO kmh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aŋgeyak Jiysis kuyip aŋgak, “Nimb Jon mindip amiy aŋgnimimb, ‘Chin amiy niŋbun: ");
INSERT INTO kmh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bi kun ak biynimb windin koy gip gok gamb windin niŋbay. Biynimb timund miŋgan pil gip gok gamb gos niŋbay. Biynimb tomb timey gip gok gamb kinjeŋ taŋgrep gipay. Biynimb soy ayndik ayip gok gamb milip gip. Biynimb kumbay gok gamb tip tikjakpay. Biynimb simbgeprek gok kunep Gor minim tep ak aŋgek niŋbay aŋgnimimb.’ ");
INSERT INTO kmh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pen minim bap aŋgnimimb, ‘Biynimb yip gosimb niŋiy, gosow gosow ma niŋbay gok, miñmiñ yimb giniŋgiy aŋgnimimb aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kun aŋgek, Jon binuk gok amniyakniŋ, Jiysis biynimb ap mindeyak gok kuyip, Jon minim ar ak aŋgiy aŋgak, “Nimb nind miñmon nep namb okok amnimbik ñin ak, yerip giniŋg ambik? Sund par nokom bap yiŋgen diy, dand amiy apiy gek niŋniŋg ambik? ");
INSERT INTO kmh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Akaŋ yenen ambik? Bi chech teprep nep aypay gok niŋniŋg ambik? Bi chech teprep dun aŋgiy niŋbay gok, biyomb korip kilrimey okok kinbay. ");
INSERT INTO kmh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pen tap yerip ak niŋniŋg ambik? Yikop ma ambik. Jon bi Gor minim aŋgep ak niŋniŋg ambik. Bi Gor minim aŋgep winiŋgamb aŋgiy kond mindyiŋgipim mey, bi kun ak. ");
INSERT INTO kmh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nup aŋgiy Baybol buk ak tikiy aŋgyak: ‘Bi minim aŋgep yand ak aŋgen nind amiy, biynimb gok aŋgrep gek, kisen Ñiyand ak aŋgen niniŋgamb aŋgiy tikyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nimbip aspiyn: Jon biynimb man ar biy, maŋgiysek wiyniym gip ak pen; Gor biynimb yikop yimb diy kond mindeniŋgamb gok, Jon rek ma mindeniŋgambay; Gor biynimb tep nuk yimb gok mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon bi ñiŋg pikñemb ap minim tep aŋgñak ñin ak tikiy, biynimb gok Gor chinup diy kond mindonimuŋ aŋgiy, kilis gi dand apiy, miñiy kunep kilisrimey yimb gipay. ");
INSERT INTO kmh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Mosis low minim tikak ak sek, bi Gor minim aŋgep gunap minim tikyak ak sek kiñiŋ ak mey, Gor Kiyŋ yomb key yimb ak nup yokek, nuk biynimb gok kuyip diy kond mindeniŋgamb. Minim kun ak aŋg dand apey apey mey, Jon owak. ");
INSERT INTO kmh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pen minim aŋgniŋg gispiyn ak diniŋgambim akaŋ ma niŋbiyn. Gor Jon nup aŋgek ap biynimb gok kuyip minim aŋgñak ak; Baybol buk ak tikiy giniŋgamb aŋgyak rek nep gak. Tikiy aŋgyak, ‘Bi Gor minim aŋgep Yilayja rek bap nind apek; bi kiyŋ yomb key yimb ak kisen winiŋgamb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nimb biynimb gos timund sek gok, minim kun ak niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Biynimb miñiy ñin biy mindpay gok yand niŋbiyn: kiyk ñapan ŋaŋ gunap, ñapan ŋaŋ gunap kuyip apay rek ak mindpay. ");
INSERT INTO kmh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ñapan ŋaŋ gunap meŋg miŋgan dand araniy apay, ‘Chin akil puŋgon, nimb yenen kamep ma apim? Kamep siy aŋgep rek ak aŋgon, nimb yenen siy ma apim apay?’ ");
INSERT INTO kmh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kun ak rek Gor Jon nup yokek apiy, ñin gunap tap ma ñimbiy, ñiŋg wayn ak ma yimb ñimbiy gek aŋgyak, ‘Bi kun biy nup tap yerip ak ambaŋ ayek kun gip aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bi bap Ñinuk pen apek apay, ‘Bi tap yomb ñimbiy, ñiŋg wayn kuŋay ñimbiy, bi takes dipay gok yip, bi tap siy tap timey gipay gok yip taŋgip apay.’ Apay kun ak, biynimb gosimb ma mindip gok rek apay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Jiysis miñmon yomb gunap nind giraŋgiy, tap mageprek gek niŋyak ak pen; yenen tap siy tap timey gipun aŋgiy, nup chiŋgiy mindrep ma giyak. Kun gey, Jiysis kuyip kuŋay yimb aŋgiy aŋgak, “Korasin biynimb gok diy, Betsayda biynimb gok diy tap mageprek gok gen niŋiy kirpay rek, minim yomb yimb diniŋgambay. Taya biynimb gok sek, Saydon biynimb gok sek kuyip tap mageprek kun gok nind rek gembinip niŋiy, chech bek band rek gunap yimiy, tun maŋgiysek giy mindembiyap. ");
INSERT INTO kmh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kun ak kor yomb ñin ak, Taya biynimb sek, Saydon biynimb sek minim sikoy rek diniŋgambay; Korasin biynimb gok sek, Betsayda biynimb gok sek minim yomb yimb ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Pen ñin kun ak Kapaniyam biynimb gok, semb biyoŋ ma amniŋgambay; pisnep mon key yinjap kaw miŋgan ak amniŋgambay. Sodom biynimb, nimb timey yimb gipim rek ma giyak ak pen, kuyip mon yinak. Nimbik tap mageprek gok gen niŋbik ak pen, Gor nup gosimb ak ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ar kun ak yand nimbip niŋind yimb aspiyn: kor yomb ñin ak apek, Sodom biynimb gok minim sikoy rek diniŋgambay; nimb Kapaniyam biynimb gok, minim yomb yimb ak diniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Ñin kun ak Jiysis Nop nup aŋgak, “Bapiy nand Biyomb. Semb biyoŋ sek, man biy sek kond mindpan ak, gos nand key niŋey tep gip rek, biynimb gos tipaŋgiy niŋbun apay gok kuyip kirgiy, biynimb ñapan ŋaŋ rek mindpay gok kuyip gos tep ñimban ak, nip tep aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kun aŋgiy aŋgak, “Bapiy kilis nuk mindip rek, yip ñimb. Biynimb gunap yip ma niŋrep gipay; Bapiy nep yip niŋimb. Yand nep Bapiy nup niŋrep gipiyn. Pen biynimb gos tep ñiyn aŋgiy niŋbiyn gok, gos tep ñen, nup niŋbay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kun aŋgiy aŋgak, “Nimb biynimb mindrep ma giy kosyam mindpim gok maŋgiysek, yip ker apem, gen kapkap mindrep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yand bi sayn tep kapkap mindpiyn rek, yand yip nep taŋgiy miñ yand ak niŋrep giy mey, mind tep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Minim yip niŋiy yand yip taŋgem mey, nimbip miker per gip rek ma giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jiwda lotiw ñin ak, Jiysis binuk gok yip wiyt woŋg namb ak amyiŋg, binuk gok yiwan gek, wiyt maŋgiy kun gok gunap diy, wak pikyokiy ñimbyiŋg ñimbyiŋg amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kun geyak, bi Peresiy gok niŋiy, Jiysis nup aŋgyak, “Binak gok yenen lotiw ñin woŋg magep biy, wiyt maŋgiy tik wak pikyoksipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aŋgeyak kuyip aŋgak, “Depiyt wosrey binuk gok yip yiwan gek, ");
INSERT INTO kmh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gor aŋgniŋep korip ak amjakiy, biret Gor windin yirik ar ak ay, bi yikop ma ñimbay: bi Gor nup simboŋgipay gok nep ñimbay biret ak kuyip aŋgniŋek nup ñey, binuk gok yip ñiŋyak. Pen yiwan gek giyak kesim kun ak, Baybol buk biyaŋ tikyak ak nimb ma niŋbim? ");
INSERT INTO kmh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Nimb Mosis Baybol buk tikak ak ma niŋbim rek ayip. Nuk tikiy aŋgak, ‘Bi Gor nup tap simboŋgep gok, lotiw ñin ak Gor aŋgniŋep korip ak mindiy, niŋind woŋg gipay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pen lotiw korip kun ak tap yikop: Bi bap Ñinuk ap mindip biy Biyomb yimb. ");
INSERT INTO kmh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pen minim bap Baybol buk tikyak ak, niŋrep ma gipim rek ayip. Minim kun ak tikiy aŋgyak, ‘Biynimb yip tap simboŋg ñimbay ak, tep ma gip; biynimb gok kuyip simb niŋbay ak yip tep gip aŋgyak.’ Minim kun ak niŋiy ma gipim ak mey, bi yand gok mindrep giyakniŋ, kuyip aŋg gipik. ");
INSERT INTO kmh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","‘Lotiw ñin Lotiw ñin’ apim ak, Bi bap Ñinuk nep kond mindip aŋgiy niŋnimimb ak pen, gos kun ak ma niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jiysis miñmon kun ak kirgiy, miñmon bap amiy, Jiwda nan-gep korip miŋgan ak amnak. ");
INSERT INTO kmh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pen korip miŋgan kun ak bi ñin pipich gak bap mindek. Biynimb ap mindeyak gok, Jiysis minim gunap aŋgek nup dand kor amnun aŋgiy, nup aŋgyak, “Lotiw ñin ak, biynimb suŋ ayaŋ aŋgiy gep akaŋ mer?” ");
INSERT INTO kmh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aŋgeyak, Jiysis kuyip aŋgak, “Kanj siypsiyp nimb bap lotiw ñin ak kaw miŋgan ameniŋgamb, yiŋgpaŋg yokniŋgambim akaŋ mer? Yiŋgpaŋg yoknimimb rek ayip. ");
INSERT INTO kmh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pen kanj siypsiyp ak tap yikop. Biynimb ak tap yimb. Lotiw ñin gok suŋ ayaŋ aŋgiy giniŋgambun ak, minim ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jiysis kun aŋgiy, bi ñin pipich gak ak nup aŋgak, “Ñin almil ayan!” Aŋgek, ñin almil aysipiyn aŋgak, pisnep suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kun gek niŋiy, bi Peresiy gok am nan-giy aŋgyak, “Nup kun kun giy pikayjun aŋgiy, minim kapkap aŋgayrep giyak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kun aŋgeyak niŋiy, nuk miñmon kun ak kirgiy, wikan gunap amniŋg saŋdakniŋ, biynimb kuŋaynep kisen giyak. Kun geyak, nuk biynimb tap gak gok gek suŋ ayakniŋ, ");
INSERT INTO kmh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kuyip aŋgak, “Bi ak kun kun gip aŋgiy, ma aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jiysis gak kun ak, bi Gor minim aŋgep Asaya giniŋgamb aŋgak rek nep gak. Nuk tikiy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bi yand pisnep yiŋ dipiyn biy, woŋg yip giñimb. Bi kun ak yip niŋen tep yimb gip. Kawnan yand ak nup bak ayek, minim tep yip ak biynimb miñmon keykey maŋgiysek aŋgñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pen nup miluk yapek minim yomb yimb ma aŋgniŋgamb. Biynimb mindpay okok yip nep niŋniŋgiy aŋgiy, meŋg miŋgan dand araniy ma aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Biynimb ma niŋbay gok kuyip kapkap aŋgrep giniŋgamb. Lam suŋgniŋg gek, kalasin paŋgey yin nep mindip rek ak kuyip aŋgniŋgamb. Nuk kun giy gi dand amiy, Gor aŋgip rek pis ak aranek; tap siy tap timey gep pis ak pisnep apyowniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Biynimb miñmon okok nimb gok kunep, nup gos sek kond mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bi kichekiy ambaŋ ayek, windin koy giy minim ma aŋgyiŋgip bap dand apeyak; Jiysis kichekiy ak aŋg mis yokek; windin yimb niŋiy, minim aŋgiy gak. ");
INSERT INTO kmh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Biynimb mindeyak gok, gak kun ak niŋiy, wal aŋgiy aŋgyak, “Bi kun biy basind Depiyt Ñinuk per kond mindpun ak rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pen bi Peresiy gok minim kun ak niŋiy, gos kiyk okok nep niŋiy aŋgyak, “Bi kun ak Gor nup aŋgniŋiy ma aŋgyokip; nuk kichekiy malñiluk tap gok nop kiyk Belsiybul kilis ak diy aŋgyokip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Pen gos niŋyak kun ak Jiysis key niŋiy, kuyip aŋgak, “Seytan tikjakiy, biynimb nuk gunap aŋgyokniŋgamb ak; yergiy biyomb mindeniŋgamb? Miñmon bap penpen aŋgiy asik keykey ayniŋgambay ak; apyap pikniŋgambay. Miñmon yomb bap akaŋ biynimb kiñiŋ nokom bap, penpen aŋgiy asik keykey ayniŋgambay ak; apyap pikniŋgambay. Nimb kun ak rek aspim ak pen; Seytan layn nuk key gok kuyip ma aŋgyokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Yip kichekiy malñiluk tap okok nop kiyk Belsiybul kilis ak diy aŋgyokip apim ak pen; yip aŋgem niŋyin: biynimb nimb gok key Belsiybul kilis ak diy aŋgyokpay? Kiyk key nimbip aŋgniŋgambay, ‘Biynimb bap kun giniŋgiy rek ma ayip aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Pen Gor Kawnan ak yip kilis ñek aŋgyokpiyn ak, yenen Gor binuk biynimb diy kond mindeniŋgamb ak wip biy aŋgiy ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bi kalrimey bap mindek, tap nup gok diniŋg, yikop ma ambay. Nup miñ tiwniŋg ay nep, am tap nup gok dipay. ");
INSERT INTO kmh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Biynimb yip ker mindpay gok, biynimb gok kuyip dand yip ker opay. Biynimb yand mer gok, biynimb yip ker winiŋg gipay gok kuyip yuk dam yokpay. ");
INSERT INTO kmh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kun ak nimb niŋrep ginimimb. Biynimb gok tap timey geniŋgambay akaŋ, Gor nup minim deniŋgambay, nuk niŋiy kirginimuŋ rek ayip; pen Gor Kawnan ak nup minim dey; kuyip niŋiy kirginimuŋ rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bi bap Ñinuk ak nup minim timey aŋgeniŋgambay, Gor niŋiy kirginiŋgamb. Pen Gor Kawnan ak nup minim timey aŋgeniŋgambay; ñin biy kunep, ñin kisen ak kunep niŋiy kirginimuŋ rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yip yenen, ‘Seytan ambaŋ ayek, woŋg tep ak gip apim?’ Mon tep gok maŋgiy timey ma piyip; mon timey gok maŋgiy tep ma piyip. ");
INSERT INTO kmh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pen nimb siyŋ saraw ñapan tikpay gok mey kun apim. Nimb biynimb timey kun ak rek, yergiy minim tep aŋgniŋgambim? Biynimb minim apay rek niŋiy gos yerip niŋbay ak, niŋniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Biynimb tep gok gos tep niŋiy mey, tep gipay; biynimb timey gok, gos timey niŋiy mey, timey gipay. ");
INSERT INTO kmh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Niŋrep ginimimb. Kisen kor yomb ñin ak, Gor biynimb gok kuyip maŋgiysek minim monmon aŋgiy akaŋ, timey aŋgiy giyak rek, yenen kun gipik aŋgiy, kuyip aŋgniŋniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kun ak minim aŋgniŋgambim rek niŋiy, biynimb gok suŋ-tep, biynimb gok yiwur dep aŋgniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bi low minim niŋep gok sek, bi Peresiy gok sek ap Jiysis nup aŋgyak, “Tiysa! Tap mageprek bap gey, chin niŋiy mey, nip Gor nep yokek wip aŋgniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aŋgeyak aŋgak, “Nimb biynimb tap siy tap timey nep gipim. Tap mageprek bap gey niŋun apim ak pen; nimbip tap bap gen ma niŋniŋgambim. Bi Gor minim aŋgep Jona nup gak ar ak nep yip gek, niŋniŋg niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wosrey piys yomb ak Jona nup kal ayek, koŋgiy namb akyaŋ ñin omiŋal nokom mindiy, andkind owak. Kun ak rek, yand kunep ñin omiŋal nokom man namb okok mindiy, andkind winiŋgayn. ");
INSERT INTO kmh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wosrey Jona am Niyniypa biynimb kuyip aŋgek, tap siy tap timey giyak gok kasek kirgiy, Gor nup gosimb niŋyak. Jona bi yikop ak aŋgek niŋyak; nimb pen biyomb yimb miñiy mindip biy, minim aŋgip ak ma dipim. Kun ak kor yomb ñin ak, miker yomb yimb diniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Biyn Kiwiyn yomb, miñmon Siyba nimb ak, wosrey gak rek ak niŋbim. Miñmon nuk par okok nimb ak pen, Jiwda kiyŋ yomb Solomon minim nup ak niŋniŋg owak. Solomon bi yikop ak nup kun gak; pen yenen biyomb miñiy mindip biy minim aŋgip ak ma niŋbim. Kun ak kor yomb ñin ak, minim yomb diniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Seytan layn nuk kichekiy tap gok bap biynimb abaŋ ay mindiy, mis amiy, biynimb gunap kuyip abaŋ ayin aŋgiy, niŋraŋg mer niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","andkind apiy niŋniŋgamb: bi nind kiriŋg amniŋgamb ak, Gor Kawnan ak yip ma mindeniŋgamb; tip teprep ak nep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nuk niŋiy, bi timey nuk rek mer, timey yimb onep ar ak poŋind apeniŋgamb, bi kun ak nup molik sikniŋgambay. Kun gey, nind tep tep mindek rek mer; kisen pisnep mind timey yimb giniŋgamb. Kun ak rek mey, biynimb ñin namb biy mindiy, alemb alemb ñi mindpay gok.” ");
INSERT INTO kmh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jiysis biynimb gok kuyip minim aŋgakniŋ, nonim numam nuk yimb gok mis biyaŋ apiy aŋgyak, “Chin Jiysis nup minim aŋgniŋg aswun.” ");
INSERT INTO kmh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aŋgeyak bi bap korip miŋgan amiy, nup aŋgak, “Nanim namam nak gok, nip minim aŋgniŋg ap mindpay mis biyaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Aŋgek biynimb nuk yip korip miŋgan biyaŋ mindeyak gok kuyip niŋkus giy aŋgak, “Niŋind apan ak pen, biynimb korip miŋgan mindpay guniy kunep amiy yand, mam yand gok nep mindpay. ");
INSERT INTO kmh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Biynimb Bapiy yomb semb biyoŋ aŋgip rek niŋbay gok, amiy, mam, ay yand gok nep mindpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ñin kun ak, Jiysis korip kun ak kirgiy am Galiyliy chemb gol ak bisgiy minim aŋgñiniŋg gek, ");
INSERT INTO kmh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","biynimb kuŋay yimb nep ap nup piŋiy kus kus geyak, nuk am bot ar ak bisgiy, am ñiŋg namb siŋbindoŋ mindyiŋg; kuyip minim paydoŋ ayiŋg aŋgñak. Aŋgñiyiŋg aŋgak, “Bi bap wiyt jakaŋ aŋgiy, wiyt maŋgiy ak dam woŋgday okok yokek, ");
INSERT INTO kmh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","gunap kinjeŋ kosemb ar ak yapek, yakir gok apiy ñiŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gunap kamb ar man siskoy ayniŋgamb okok yapiy kasek gup giniŋgamb ak pen, kindiy am wos ma giniŋgamb rek, ");
INSERT INTO kmh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pumb niŋiy milip giyowniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pen gunap kikasik dindbiliŋ namb okok yapiy jakniŋgamb ak pen, miñ kun ak saw giy pikñimbek, milip giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pen gunap lum teprep ar okok yapiy, jak tep yimb giy, maŋgiy kuŋay yimb nep piyniŋgamb. Gunap ñin jiwiy rek piyniŋgamb; gunap ñin jiwiy omiŋal rek piyniŋgamb; gunap ñin jiwiy kaw bap rek piyniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jiysis kun aŋgiy aŋgak, “Nimb biynimb gos timund sek mindenimimb gok, minim aspiyn biy niŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jiysis kun aŋgek, binuk gok apiy, nup aŋgniŋiy aŋgyak, “Biynimb gok kuyip, yenen minim paydoŋ ay nep apan?” ");
INSERT INTO kmh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aŋgeyak aŋgak, “Gor biynimb nuk diy kond mindeniŋgamb minim weygiy mindyiŋgip ak, nimbip gos ñek niŋniŋgambim; pen biynimb yikop gok ma niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Biynimb minim yip niŋiy dipay gok minim gunap sek niŋiy, junj ak niŋrep giniŋgambay; pen biynimb minim yip niŋiy ma dipay gok, minim sikoy niŋbay ak pisnep kurginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kuyip minim paydoŋ ay apiyn ak; kiyk windin sek, gos timund sek ak pen, aŋgip mey ak aŋgiy, ma niŋbay. ");
INSERT INTO kmh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Gipay kun ak, bi Gor minim aŋgep Asaya nind giniŋgamb aŋgiy tikak rek nep gipay. Minim kun ak tikiy aŋgak: ‘Minim niŋniŋgambay ak pen, minim aŋgip kun aŋgiy ma niŋniŋgambay. Windin niŋniŋgambay ak pen, tap bap ma niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Biynimb guniy minim yand apiyn ak kuyip yiruk gek ma yimb niŋbay. Gor minim niŋon chinup gek biynimb nuk mindenjun rek ayip aŋgiy, timund pilgiy, windin jukiy nep mindpay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","“Kun ak kiyk ma niŋbay; Gor nimbip gos tep ñek niŋbim ak, miñmiñ ginimimb. Biynimb Gor nup chiŋgyak gok sek, minim nup aŋgep gok sek kuŋaynep Kiyŋ yomb key yimb ak nup niŋun aŋgyiŋgipay ak pen, yip ma niŋiy, minim yip ma niŋiy giyak. Miñiy nimb minim yip niŋiy, yip niŋiy gispim ak, miñmiñ ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pen minim paydoŋ ay aŋgambiyn junj ak nimbip aŋgen niŋim. ");
INSERT INTO kmh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wiyt maŋgiy gunap kinjeŋ kosemb ar ak yapeniŋgamb, yakir gok ñimbdiniŋgambay apiyn ak; biynimb gok, Gor biynimb diy kond mindeniŋgamb minim tep ak niŋniŋg gey, Seytan gek sakiy giniŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Pen maŋgiy gunap kamb ar man siskoy ayniŋgamb okok yapiy, kasek gup giniŋgamb ak pen kindiy am wos ma gek, pumb niŋiy milip giniŋgamb apiyn ak; biynimb gok minim yip ak kisen niŋniŋgambay won ak niŋiy miñmiñ giniŋgambay ak pen; won ak sakiy giy gos ar gunap niŋniŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Maŋgiy gunap yowniŋgamb kikasik dindbiliŋ namb okok apiyn ak; minim yip ak niŋniŋgambay ak pen; woŋg wariy, korip kanj, tiw minan, maniy tap gok nep gos niŋiy; Gor minim tep ak kirginiŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pen maŋgiy gunap man tep ar ak yapiy, jak tep giy, maŋgiy kuŋay piyniŋgamb apiyn ak; biynimb gok minim yip ak niŋiy, yip chiŋgrep yimb giniŋgambay. Gunap mindrep giniŋgambay, gunap mindrep yimb giniŋgambay, gunap mindrep giy ar kun ak key yimb giniŋgambay aŋgiy apiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiysis kuyip minim bap sek paydoŋ ay aŋgak, “Gor biynimb diy kond mindeniŋgamb ak kesim dispiyn biy rek giniŋgamb. Biyomb bap wiyt maŋgiy gok jakaŋ aŋgiy, dam woŋgday nuk okok yokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pen kisyim biyaŋ kin amniŋgambay won ak, bi timey bap tap yiŋ timey gunap dand apiy, namb kun okok yokiy amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pen wiyt yiŋ tep gok jakakniŋ, tap yiŋ timey gok sesek jakniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kun gek, bi woŋg giñemb gok apiy aŋgniŋgambay, ‘Biyomb! Tap yiŋ tep gok nep dam woŋgday ak yokpan; tap yiŋ timey gok yergiy namb kun okok sesek jaksap?’ ");
INSERT INTO kmh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aŋgey kuyip aŋgniŋgamb, ‘Bi yip miluk niŋimb bap dap yokip.’ Aŋgek aŋgniŋgambay, ‘Chin am tap yiŋ timey jakip kun gok tuŋgjiw yokjun akaŋ?’ Aŋgey bi woŋgday nop nimb ak aŋgniŋgamb, ");
INSERT INTO kmh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","‘Mer! Ñin biy, tap yiŋ timey kun gok tuŋgjiwim aŋgen, am tap yiŋ tep gunap sek tuŋgjiwnimimb rek ayip ak, kirgem omiŋal giy jaknimuŋ. Pen jakiy maŋgiy piy, dep ñin ak apek ker, bi yand gok aŋgen, tap timey gok tuŋgjiwiy, dam mon daŋgiyey yin simbok amek; wiyt maŋgiy gok nep di nan-giy, dam korip miŋgan yip ak yokniŋgambay aŋgniŋgamb.’” ");
INSERT INTO kmh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jiysis kuyip minim bap pen paydoŋ ay aŋgak, “Bi bap mon mastet yiŋ ak dam woŋgday nuk ak yokniŋgamb. Mon yiŋ kun ak maŋgiy sikoy ak pen; jak yomb giy, alik tep ak pikek, yakir gok ap alik keykey korip giniŋgambay. Kun ak rek mey, Gor biynimb diy kond mindeniŋgamb minim tep ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Minim bap pen paydoŋ ay aŋgak, “Biyn gok tap yiys ak di pilaw sek tuŋgandik mandik giy daŋgiyey yin yomb yimb tanimb. Kun ak rek mey, Gor biynimb diy kond mindeniŋgamb minim tep ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiysis biynimb gok kuyip minim guniy aŋgñiniŋg miseŋ ma aŋgyiŋgip; paydoŋ ay nep kuyip aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gak kun ak, bi Gor minim aŋgep bap nind giniŋgamb aŋgiy tikak rek nep gak. Nuk minim kun ak tikiy aŋgak: “Miñmon alwol gayak ñin ak tikiy mind dand apiy miñiy mindpun ñin biy, minim ma niŋyak ak; kuyip paydoŋ ay aŋgñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jiysis biynimb gok kuyip kun aŋgiy, korip miŋgan amnakniŋ, binuk onep wimiŋgan gok apiy nup aŋgyak, “Tap yiŋ timey woŋgday namb okok jakip aŋgiy paydoŋ ay apan ak, chinup aŋgey niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aŋgeyak aŋgak, “Bi tap yiŋ tep woŋgday okok yokip apiyn ak, Bi bap Ñinuk. ");
INSERT INTO kmh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Woŋgday apiyn ak, mankumb biy maŋgiysek. Tap yiŋ tep apiyn gok, Gor biynimb diy kond mindeniŋgamb gok. Bi tap yiŋ timey dap yokek jakak apiyn ak, bi yip miluk niŋimb Seytan nup apiyn. Tap yiŋ timey jakip gok, Seytan biynimb nuk gok kuyip apiyn. Pen wiyt maŋgiy pik giniŋgamb ñin apiyn ak, ñin kisen ak apiyn. Bi tik dand owep apiyn ak enjol gok kuyip apiyn. ");
INSERT INTO kmh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tap monmon jakip gok tuŋgjiw di mon yinjap yokniŋgambay apiyn ak: ");
INSERT INTO kmh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bi bap Ñinuk enjol gok kuyip aŋgek, am biynimb Gor biynimb nuk gok yip yiŋgoŋg giy mindyiŋg, key timey gipay rek, biynimb gunap kuyip gey timey gipay ak, ");
INSERT INTO kmh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","aŋg mon sinjrimey yinimb ak yokey, yiwur gakniŋ, meŋg siwbirikiy siy aŋgniŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ñin kun ak Gor biynimb suŋ-tep nuk gok nuk yip mindiy, mindrep giy, sup melik pik mindeniŋgambay. Nimb biynimb gos timund sek gok, minim kun ak niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Pen Gor biynimb diy kond mindeniŋgamb gok, kesim ar biy rek mindip. Bi bap amiy niŋniŋgamb, maniy kes wosrey weygiyak bap mindeniŋgamb. Nuk niŋiy tap gunap di aybirik tep giy korip amiy, tap nuk gok maŋgiysek monmon yokiy maniy diy, maniy kun ak dand amiy tip wikan kun ak tawiy, am maniy kes kun ak diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Bi sikyim gep gok kunep kumbap piyow niŋraŋgiy kumbap milip yimb bap niŋiy korip amiy, tap kiyk gok maŋgiysek yokiy maniy diy, am kumbap kun ak tawniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Gor biynimb diy kond mindeniŋgamb ak; bap mey kesim ar aŋgniŋg gispiyn biy rek. Biynimb gunap wimben dand amiy, ñiŋg maŋgiy chemb ak yokey, piys kuŋaynep apiy miŋgan kun ak ambay. ");
INSERT INTO kmh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kun gey wimben ak lipiŋg dand gol okok amiy, piys tep gok yipruŋg piys ayep baket miŋgan ak ay, piys timey gok diyokpay. ");
INSERT INTO kmh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ñin kisen ak kun ak rek giniŋgamb. Gor enjol nuk gok aŋgyokek apiy, biynimb suŋ-tep gok key ay, biynimb tap siy tap timey gipay gok key ay, ");
INSERT INTO kmh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","dam mon yinjap ak yokeniŋgambay; meŋg siwbirikiy, siy aŋg mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kun aŋgiy aŋgak, “Minim aspiyn gok niŋbim?” Aŋgek, binuk gok, “Yaw. Niŋbun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aŋgeyak aŋgak, “Basind sikop Gor minim aŋgyiŋgipay ak niŋiy, Gor biynimb diy kond mindeniŋgamb minim yand apiyn ak niŋiy gipim ak mey, biynimb gunap aŋgñiniŋg; minim tep nindnimb ak sek, kisenimb ak sek aŋgñiniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pen Jiysis paydoŋ ay minim aŋgak kun gok aŋgjiwiy, miñmon nuk amiy, ");
INSERT INTO kmh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jiwda nan-gep korip ak amiy biynimb gok kuyip minim aŋgñek niŋiy, wal yimb aŋgyak. Kisen pen aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Bi kun biy nop nonim, numam nunay nuk gok, chin yip mindpay ak, nuk yergiy biyomb rek mindiy, minim key aŋgiy, tap mageprek gok gisap. Nop nuk ak bi kapenda; nonim Mariya; numam nuk gok; Jemis ak, Josep ak, Saymon ak, Jiwdas ak. Kun ak nuk yergiy ap kun asap?” ");
INSERT INTO kmh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kun aŋgiy, nup miluk niŋyak. Pen Jiysis kuyip aŋgak, “Bi Gor minim aŋgep gok biynimb miñmon par okok amiy aŋgey, niŋind apay aŋgiy niŋbay ak pen korip miñmon kiyk key ak aŋgey, yesek apay aŋgiy kirpay rek ak nimb gispim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Minim aŋgak ak ma niŋeyak, miñmon kun ak tap mageprek tapin ginimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pen gapman biyomb miñmon Galiyliy kond mindep Herot, Jiysis nuk yerer gak minim ak niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","am binuk gok kuyip aŋgak, “Jiysis tap mageprek gip ak, nuk bi bap key mer; nuk Jon bi ñiŋg pikñemb anep. Nup pikaynik ak pen; tip ak tikjakiy ap mindip rek, niŋind tap mageprek kun gok gisap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Pen Jon nup kalambis ay, pikyak minim kiñiŋ ak kun giy mindip: Herot nuk tikjakiy numam Piyliyp biyn nup ak di gek, Jon aŋgak, “Ak girep ma gip.” Kun aŋgek nup sen tiwniŋgiy, dam kalambis ay, pisnep pikayen kumaŋ aŋgiy gos niŋak ak pen; biynimb gok Jon nup bi Gor minim aŋgep chin aŋgyak rek, pirikiy kirgak. ");
INSERT INTO kmh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pen kisen Herot nup nonim tikak ñin ak apek, biynimb kuŋaynep ap nan-giy patiy geyak, Herodiyas panuk ak, ap namb kun ak deniys gek, Herot niŋek tep yimb gak. ");
INSERT INTO kmh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kun gek, nuk pañ kun anup minim aŋgay aŋgak, “Yand niŋind aspiyn. Nak tap bap aŋgniŋeniŋgamban; monmon ñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aŋgek, pañ kun ak, nonim aŋgak rek niŋiy aŋgak, “Jon bi ñiŋg pikñemb jun won ak piler ar ay, dap ñinimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Kun aŋgek Herot niŋek simb gak ak pen; biynimb gok niŋmindyakniŋ, pañ kun anup miseŋ minim aŋgay, “Tap bap aŋgniŋeniŋgamban monmon ñiniŋgayn aŋgak” rek niŋiy, bi gunap aŋgyokek, Jon kalambis mindek ak amiy, jun won nup ak timbrikiy, ");
INSERT INTO kmh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","di piler ar ak ay dapiy pañ kun ak nup ñeyak, nuk pen dand amiy, nonim nup yomek niŋiy, ak niŋind apay aŋgiy niŋak. ");
INSERT INTO kmh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pen Jon nup kun giy kuŋam timbrikeyak, binuk gok apiy, nup dam komiy, am Jiysis nup aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jiysis minim kun ak niŋiy, am miñmon wikan bap key minden aŋgiy bot diy, miñmon kun ak kirgiy saŋdak. Pen biynimb gok, Jiysis amnakniŋ kisen amnun aŋgiy, miñmon kiyk gok kirgiy, lum ar amiy, Jiysis amniŋg gek okok amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jiysis amjakiy bot ak kirgiy gol okok apiy niŋak: biynimb kuŋaynep mindeyak. Kuyip niŋek simb gek, biynimb tap gak gok gek, suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pen duŋgek wakniŋ, binuk gok mindek ak apiy nup aŋgyak, “Kisyim asaw. Akniy miñmon nep namb ak; biynimb kuŋaynep guniy aŋgey, korip namb akniy amiy, keñmaŋgiy kiyk gunap tawiy ñiŋyaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kun aŋgeyak kuyip aŋgak, “Nimb kuyip tap keñmaŋgiy ñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aŋgek aŋgyak, “Chin tap keñmaŋgiy kuŋay ma mindip; yikop biret onep mamind ak, piys omiŋal sek mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aŋgeyak Jiysis aŋgak, “Tap kun gok dand wim.” ");
INSERT INTO kmh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kun aŋgiy, biynimb gok kuyip aŋgek, tap kaskas ar okok bis giyakniŋ, biret kamb ak diy, piys omiŋal ak diy, kuyoŋgiy niŋiy, Gor nup tep aŋgiy, biret ak tipaŋgiy binuk gok kuyip ñakniŋ, kiyk diyiŋg biynimb gok kuyip bilok ñiyak. Piys ak kunep giyak. ");
INSERT INTO kmh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kun giy bilok ñeyak, ñimb gey gey tapin ayek day day kirgiyak gok, binuk gok wand onep wimiŋgan ak di yiŋgey pisnep arachakak. ");
INSERT INTO kmh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Biynimb tap ñiŋyak kun ak, biyn gok sek, ñapan sikoy gok sek mer; bi gok nep mey, payp tawsin rek amnak. ");
INSERT INTO kmh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jiysis binuk gok kuyip pis bindoŋ amniyaŋ aŋgiy, aŋgek bot diy saŋdiyakniŋ, biynimb gok kuyip aŋgyokiy, ");
INSERT INTO kmh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","nuk key Gor nup aŋgniŋniŋg, miñmon dum bap amnak. Duŋgek wakniŋ, nuk dum kun ak asiy mindek. ");
INSERT INTO kmh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pen binuk gok bot dand ñiŋg namb yomb siŋak amniyakniŋ, yiŋgen yomb sikerek ak apiy, bot ak tuŋgandikniŋg rek gak. ");
INSERT INTO kmh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Won kun ak miñmon yowniŋg gek ak mey, Jiysis ñiŋg kas ar ak tawind apiy, mindeyak maŋ siŋak apek niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ak chip kawnan bap asaw aŋgiy, jel pirikiy wal aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jiysis pen kuyip aŋgak, “Ma piriknimimb! Yand nep aswiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aŋgek Piyta aŋgak, “Biyomb! Nand nep apiy ker; yip aŋgey, ñiŋg kas ar ak tawind kayaŋ ak niyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","Aŋgek Jiysis aŋgak, “Kun ak owan aŋgak.” Aŋgek, Piyta bot ar ak kirgiy, ñiŋg kas ar ak tawind Jiysis mindek siŋak amiy niŋak: yiŋgen yomb sikerek ak apiy, nup ñiŋg namb akyaŋ poŋgek yowniŋg rek gek pirikiy, “Biyomb! Ak-ey aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kun aŋgek, Jiysis kasek nup chichiy diy aŋgak, “Yip gosimb niŋban ak pen, yenen gos omiŋal niŋamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kun aŋgiy, bot miŋgan ak amnirikniŋ, yiŋgen yomb dek ak kirgak. ");
INSERT INTO kmh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kun gek niŋiy, binuk bot miŋgan biyaŋ bisiŋg mindeyak gok, Jiysis nup lotiw giyiŋg aŋgyak, “Nand Gor Ñinuk yimb aŋgyak!” ");
INSERT INTO kmh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pen kiyk ñiŋg tikiy miñmon Genesaret pis bindoŋ amjakeyak, ");
INSERT INTO kmh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","biynimb kun gok Jiysis nep wip aŋgiy, biynimb maŋ kun okok maŋgiysek suk aŋgey, biynimb tap gak gok dand wiyak. ");
INSERT INTO kmh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dand apiy, Jiysis nup nembnemb giyiŋg aŋgyak, “Chinup yaw aŋgey ker, biynimb tap gip guniy, chech nip gol okok nep diniŋey suŋ ayaŋ aŋgyak.” Aŋgeyak yaw aŋgek, biynimb nup diniŋyak gok kuyip maŋgiysek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pen ñin kun ak, bi Peresiy gunap, bi low tiysa gunap Jerusalem nimb apiy, Jiysis nup aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bi nand guniy, yenen apis basind sikop minim per ak kirgiy, ñin kiyk ñiŋg ayokiy mer, yikop nep tap ñimbay?” ");
INSERT INTO kmh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aŋgeyak Jiysis aŋgak, “Nimb yenen Gor minim nup ak kirgiy, nimb key gipim rek giniŋgiy aspim? ");
INSERT INTO kmh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gor aŋgak, ‘Nap nanim aŋgnimiyr rek niŋdinimimb! Pen ma niŋdey, kuyip pikayniŋgiy aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","7","Pen nimb minim kun ak yipund giy ma aŋgñimbim. Biynimb gunap nop nonim kuyip kirginiŋg, ‘Bapiy amiy kuyip tap ñimbinup ak pen, maniy biy Gor nup ñiniŋgambun rek kirsipun aŋgey,’ nimb niŋiy, ‘Tep apay’ apim. Kun ak, yesek yimb apim. Biynimb nep minim aŋgaypay gok aŋgñiyiŋg, Gor minim aspun apim. Nimb biynimb minim anep aŋgrapim gok, Gor niŋind yimb bi minim nup aŋgep Asaya nup gos ñek, minim tikiy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","‘Biynimb guniy yip yesek nep Gor biyomb chin; chinup tep gip apay. Ak minim nep apay; yip gosimb ma niŋbay. Gor minim tep ak aŋgñispun aŋgiy, minim kiyk key gok nep aŋgñimbay aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jiysis kun aŋgiy, biynimb mindeyak gok aŋgek maŋ siŋak apeyak aŋgak, “Minim aŋgniŋg gispiyn ak niŋrep ginimimb! ");
INSERT INTO kmh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Biynimb gok tap monmon okok ñimbey, simbwur namb kuyip biyaŋ amiy gach ma gip; namb kiyk biyaŋ gos timey niŋbay ak mey gach sek mindpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pen Jiysis binuk gok apiy nup aŋgyak, “Bi Peresiy gok, minim apan ak niŋey kuyip miluk yowip ak niŋban?” ");
INSERT INTO kmh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aŋgeyak aŋgak, “Ak minim ma mindip. Bapiy semb biyoŋ tap yiŋ nuk ma yimimb gok junj sek piŋiyjiw diyokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bi kun gok windin koy! Bi windin koy bap, bi windin koy bap nup poŋind dand amiy, omiŋal giy kaw miŋgan ak apyap pikniŋgayr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jiysis kun aŋgek, Piyta aŋgak, “Minim kun giy paydoŋ ay apan kiñiŋ ak, chinup aŋgñey niŋun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Aŋgek aŋgak, “Kiyk ma niŋbay rek, nimb kunep ma niŋbim? Niŋim! Tap yerip yerip monmon ñimbay gok, Gor niŋek, minim ma mindip. Ak yikop ñimbiy, simb kiy yokpay. ");
INSERT INTO kmh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Namb kiyk biyaŋ gos timey niŋbay ak gek mey, gach sek mindpay. ");
INSERT INTO kmh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gos kiyk key niŋiy: biynimb pikay, biyn siy bi siy giy, tap okok siy diy, tom giy, biynimb aŋgjiwiy gipay. ");
INSERT INTO kmh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gipay kun ak mey, Gor niŋek timey yimb gip; pen tap ñiŋniŋg, ñin ñiŋg ma ayokiy monmon ñimbay ak; Gor niŋek minim ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jiysis miñmon Genesaret kun ak kirgiy, miñmon yomb Taya sek, Saydon sek amnak. ");
INSERT INTO kmh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Am kun okok mindek, biyn Keynan nimb bap miñmon kun ak mindek ak apiy, Jiysis nup aŋgak, “Biyomb. Depiyt Ñinuk! Yip simb niŋnimin. Pañ yip ak kichekiy ambaŋ ayek, mindrep ma yimb gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aŋgek, Jiysis pen ma yimb aŋgak. Pen binuk gok apiy nup aŋgyak, “Biyn biy chinup kisen giyiŋg, kilpul nep aŋgip. Nup aŋgyokan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aŋgeyak aŋgak, “Gor yip yokek Jiwda biynimb Gor nup kirpay gok kuyip diyn aŋgiy winik aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kun aŋgek, biyn Jiwda mer kun ak, ap Jiysis mindek kiñiŋ siŋak koŋgim yimiy aŋgak, “Biyomb! Yip simb niŋnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aŋgek aŋgak, “Keñmaŋgiy ñapan chin ñinjun ak, yenen di kayn gok mokjun?” ");
INSERT INTO kmh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aŋgek biyn kun ak aŋgak, “Biyomb. Niŋind apan ak pen; kayn gok nop kiyk apyoŋg tap ñiŋyakniŋ, day day boŋg molik okok yowip gok nep ñimbay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aŋgek Jiysis aŋgak, “Gor nup gosimb niŋiy apan ak, apan rek giniŋgamb aŋgak.” Kun aŋgakniŋ, kichekiy ak won kun anep panuk nup kirgiy mis amnak. ");
INSERT INTO kmh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jiysis andkind Galiyliy chemb gol taw akdoŋ ken amiy, mak ak kuyoŋgiy am dum biyoŋ bisgak. ");
INSERT INTO kmh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bisiŋg mindakniŋ, biynimb tiwin yomb gok keykey biynimb tomb timey gak gok, windin koy gak gok, minim ma aŋgyiŋgipay gok, ñin tomb tind mand gak gok, tap yerip yerip gak gok maŋgiysek dand apiy Jiysis mindek tomb aŋgin siŋak ayakniŋ, kuyip gek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kun gek, biynimb kun gok niŋiy wal aŋgyiŋg aŋgyak, “Chin Yisrel biynimb Gor chin ak tep yimb. Biynimb windin koy gok gek niŋsipay; biynimb minim ma apay gok gek minim aspay; biynimb ñin tomb timey gak gok gek taŋgrep gispay aŋgiy,” yimb nup dand aranyak. ");
INSERT INTO kmh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiysis binuk onep wimiŋgan ak kuyip aŋgek apeyak aŋgak, “Biynimb guniy kuyip simb niŋsipiyn. Ñin omiŋal nokom yand yip nep mindpay ak pen, kuyip tap ñen ñiŋniŋgiy ak ma mindip. Kuyip yikop aŋgen amey, kinjeŋnamb okok windin mayn apek, apyap pikniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aŋgek binuk gok aŋgyak, “Miñmon biynimb kuŋay ma mindpay namb kun akniy, keñmaŋgiy akay nimb piyow niŋiy dapiy, biynimb kuŋaynep kun guniy ñon ñiniŋgambay?” ");
INSERT INTO kmh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aŋgeyak Jiysis aŋgak, “Biret nimb yerip yerip mindip?” ");
INSERT INTO kmh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aŋgek aŋgyak, “Biret onep ar ak mindiy, pis sikoy gunap sek mindip aŋgyak.” Aŋgeyak, Jiysis biynimb gok kuyip aŋgek, man ar kun siŋak bisgiyak. ");
INSERT INTO kmh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bisgiyakniŋ, biret onep ar ak diy, piys sikoy gok diy, Gor nup tep aŋgiy, tipaŋgiy binuk gok kuyip ñek, kiyk diy biynimb gok kuyip bilok ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ñeyak, ñimb gey gey tapin ayek, day day kirgiyak gok, binuk gok wand onep ar ak diy, yiŋgey, pisnep arachakak. ");
INSERT INTO kmh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Biynimb tap ñiŋyak kun gok, biyn gok sek ñapan sikoy gok sek mer; bi gok nep mey, pow tawsin rek amnak. ");
INSERT INTO kmh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pen kun giy tap ñimbiy, Jiysis kuyip aŋgyokek amniyakniŋ, nuk bot diy, miñmon Makadan pis biym amiy, miñmon namb kun okok amnak. ");
INSERT INTO kmh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bi Peresiy gunap, bi Sanjiwsiy gunap Jiysis yergonimuŋ nup aŋgjiwjun aŋgiy, ap nup aŋgyak, “Nand kiyŋ yomb key yimb mindpiyn apan ak, tap mageprek bap semb biyoŋ genimin, niŋind apan aŋgiy niŋjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aŋgeyak kuyip aŋgak, “Pumb saŋind amiy, likañ likañ pikakniŋ, ‘Miñmon tikrep giniŋgamb apim.’ ");
INSERT INTO kmh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Miñmon yowakniŋ, semb biyoŋ gach giy, likañ likañ gakniŋ, ‘Ak miñmon pikniŋg gisap apim.’ Kun giy niŋrep gipim ak pen; Gor kun giy rek gip, kun giy rek giniŋg gisap aŋgiy, gos ak ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nimb biynimb miñiy mindpim gok, mindrep ma giy, Gor nup gosimb ak ma nep niŋbim. Tap mageprek bap gey niŋun apim ak, yand gen ma niŋniŋgambim. Bi Jona nup gak rek yip gek niŋniŋg niŋniŋgambim aŋgak.” Jiysis kun aŋgiy, kuyip kirgiy wikan bap amnak. ");
INSERT INTO kmh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jiysis binuk gok bot diy, pis bindoŋ amiy niŋyak: biret gok sakiy giy dand ma amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kun ak mey, kisen Jiysis kuyip bi Peresiy gok sek, bi Sanjiwsiy gok sek yiys kuyip ak asikrep ginimimb aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","kiyk key aŋgniŋ aŋgniŋ giy aŋgyak, “Chin biret ak dand ma opun ak mey, kun asap akaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Pen Jiysis aŋgyak kun ak key niŋiy aŋgak, “Nimb yenen biret ma dand opun aŋgiy aŋg amiy apiy gispim? Yand Gor Ñinuk. Yerer giniŋg giniŋgayn gos ak ma niŋbim? Pen bi payp tawsin rek mindeyak ñin ak, biret onep mamind ak diy, tipaŋg ñenik, ñimb dand doŋwiy geyak; wand yerip yerip yiŋgem arachakak? ");
INSERT INTO kmh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Pen kisen bi pow tawsin rek mindyakniŋ, biret onep ar ak ñenik, ñimb dand doŋwiy geyak, wand yerip yerip yiŋgem arachakak? ");
INSERT INTO kmh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ñin kun ak nimb key mindiy biret wand yipik ak pen, paydoŋ ay aŋgambiyn ak ma niŋiy, yip biret nen asap apim. Biret nen ma aspiyn. Bi Peresiy gok sek, bi Sanjiwsiy gok sek yiys kiyk ak nimbip dinimuŋ rek ayip aŋgiy aspiyn.” ");
INSERT INTO kmh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kun aŋgek niŋyak, tap yiys biret sek aypay ak ma aŋgak: bi Peresiy gok sek, bi Sanjiwsiy gok sek minim aŋgñimbay gok ma niŋnimimb aŋgiy aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kisen Jiysis binuk gok yip miñmon Siysariya-Piyliypay namb ak taŋgyiŋg, kuyip aŋgak, “Biynimb okok yip bi an apay?” ");
INSERT INTO kmh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aŋgek binuk gok aŋgyak, “Gunap Jon bi ñiŋg pikñemb ak apay; gunap Yilayja apay; gunap Jeriymaya apay. Gunap pen, bi Gor minim aŋgep gunap apay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aŋgeyak Jiysis kuyip aŋgak, “Nimb key pen, yip an aŋgiy niŋbim?” ");
INSERT INTO kmh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aŋgek binuk Saymon Piyta aŋgak, “Nand bi kiyŋ yomb key yimb Gor biynimb gek kim mindpay ak Ñinuk aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aŋgek Jiysis aŋgak, “Saymon Jona ñinuk. Nand gos niŋban kun ak, key okok nimb ma wip; Bapiy semb biyoŋ anep nip gos tep ñek niŋban. ");
INSERT INTO kmh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Piyta. Nand bi kamb rek kilis timey giy apan kun ak, tep apan. Biynimb yand diniŋgayn gok mey kun ak rek. Seytan ap kuyip yergeniŋgamb; yip ma kirginiŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Biynimb Gor miñmon amniŋgambay kiywur ak nip ñiniŋgayn. Ñen nand lum ar biy mindiy, miñ ar akay niŋey yipund ma gek mer aŋgniŋgamban ak, Gor kunep aŋgniŋgamb. Pen miñ ar akay niŋey yipund gek, yaw aŋgniŋgamban ak, Gor kunep aŋgniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jiysis kun aŋgiy binuk gok kuyip aŋgak, “Biynimb gok kuyip, yip bi kiyŋ yomb key yimb mey kun ak aŋgiy, ma aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ñin namb kun siŋak Jiysis binuk gok kuyip, biynimb gunap nup timey giniŋgambay rek miseŋ aŋgiy aŋgak, “Kisen Jerusalem amen, bi minim tuŋgasikep gok diy, bi low tiysa gok diy, bi Gor nup tap simboŋgep yomb gok diy, yip yiwur ñiy pikayniŋgambay ak pen; ñin omiŋal nokom mindiy tip ak tikjakniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kun aŋgek Piyta, Jiysis nup dand gol siŋak amiy, minim yiñ rek aŋgiy aŋgak, “Minim kun ak tep ma apan. Gor nip kond mindek, kun ma ginimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aŋgek, Jiysis pen Piyta nup aŋgak, “Seytan. Yip kirgiy amnoŋ! Yip yenen mer aŋgiy aspan? Gor gos niŋimb rek ma niŋban; biynimb gos niŋbay rek nep niŋiy aspan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kun aŋgiy binuk gok kuyip aŋgak, “Biynimb an yip ker mindniŋg ginimuŋ ak; tap man ar biy gos yomb niŋbay ak kirgiy, pumbnamb kisyimken yip kisen giy; miker yomb dep akaŋ kumemb gos ak sakiy giy, yip chiŋgiy nep taŋgeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Biynimb Jiysis nup diy mindon tep ma giniŋgamb aŋgiy niŋniŋgambay gok, pisnep apyap pikniŋgambay; pen biynimb nup diy mindon chinup yerginiŋgamb ak, minim ma mindip aŋgniŋgambay gok kuyip den perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Biynimb tap man ar biy dun aŋgiy gey amniŋgamb gok, gos yomb kiyk ak ar kun anep ameniŋgamb mey; perper ma mindeniŋgambay. Akaŋ Gor nup tap kun gok tawiy, kilis diniŋgambay? Mer yimb! ");
INSERT INTO kmh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Kisen Bapiy minim ak diy, enjol gok yip, andkind winiŋgayn ñin ak, biynimb mindrep giniŋgambay gok key ay, biynimb mindrep ma giniŋgambay gok key ay giniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nimbip niŋind yimb aspiyn: biynimb mindpim guniy gunap kim mindpikniŋ, Bi bap Ñinuk biynimb diy kond mindeniŋgamb ñin ak apek niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jiysis minim kun ak aŋgiy, ñin onep kaŋgol ak mindiy; Piyta, Jemis, Jemis numam Jon ak, kuyip yakam poŋind, dum yiy akyoŋ bap amiy, key mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mindyakniŋ, Jiysis wak nup ak key yimb ay, jomluk ak pumb rek niŋiy, chech nuk ak ñiñakol yimb gak. ");
INSERT INTO kmh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kun gakniŋ niŋyak: bi Gor minim aŋgep nind kumrik Mosis yip Yilayja yip, ap Jiysis yip minim aŋg minderik. ");
INSERT INTO kmh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kiyk niŋiy, Piyta Jiysis nup aŋgak, “Biyomb! Chin biy mindpun ak, tep yimb mindpun. Nand yaw aŋgey ker, korip bandak band omiŋal nokom ginjun. Nip bap, Mosis nup bap, Yilayja nup bap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kun aŋgakniŋ, semb tund yimb ak apiy, kuyip maŋgiysek yiwgak. Yiwiŋg dakniŋ, minim bap semb namb kun ak nimb aŋgak, “Ñi mapin yand biy, yip tep yimb gip. Minim yerip yerip aŋgnimuŋ ak, niŋdinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Minim kun ak kun giy aŋgek niŋiy, Jiysis binuk gok gos kuŋay niŋiy pirikiy, apyap koŋgim yimiy, jomluk kiyk ak man akyaŋ ken ay mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jiysis ap kuyip diniŋiy aŋgak, “Ma piriknimimb. Tikjakim!” ");
INSERT INTO kmh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aŋgek tikjakiy niŋyak, nuk nep mindek. ");
INSERT INTO kmh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pen mak ak kuyaŋgiyiŋg, Jiysis kuyip aŋgak, “Miñiy yerer gamb niŋbim kun ak biynimb gok kuyip ma aŋgñinimimb. Kisen kumiy tikjaken mey, biynimb okok kuyip aŋgñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aŋgek nup aŋgyak, “Bi low tiysa gok yenen, Yilayja nind apeniŋgamb; kisen Kiyŋ yomb key yimb ak mankumb biy winiŋgamb apay?” ");
INSERT INTO kmh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aŋgeyak aŋgak, “Niŋind apay. Minim kun ak mindip. ‘Yilayja nind apiy kuyip aŋgrep gek, kisen Kiyŋ yomb key yimb ak winiŋgamb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pen niŋim: Yilayja owak ak pen, apek nup ma niŋyak. Gos kiyk key niŋyak rek nup timey giyak. Bi bap Ñinuk ak nup kunep giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kun aŋgek, binuk gok niŋyak; Yilayja aŋgak kun ak, Jon bi ñiŋg pikñemb ak nup nep aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pen kiyk giw biyaŋ amjakiy niŋyak biynimb kuŋaynep mindeyak. Bi bap biynimb mindeyak namb kun animb ap Jiysis mindek siŋak koŋgim yimiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Biyomb! Ñi yip ak simb niŋnimin. Nup sakiy ayek mindrep ma gip. Per am mon yinimb namb okok sek, ñiŋg namb okok sek gi dam pikip. ");
INSERT INTO kmh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nup dand binak gok mindambay ak amen, nup gi mer niŋiy kirpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aŋgek Jiysis aŋgak, “Nimb biynimb miñiy ñin biy mindpim gok, Gor nup gosimb ma niŋiy mindrep ma gipim. Minek akay niŋiy key giniŋgambim. Minim per aŋgen niŋbim ak, yergiy minim kil sek aŋgnim?” ");
INSERT INTO kmh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kun aŋgiy aŋgek dand apeyak, kichekiy nup ambaŋ ayak ak aŋgyokek; won anep suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kun gek, binuk gok Jiysis mindek ak apiy, kiyk nep mindyiŋg nup aŋgniŋiy aŋgyak, “Yergek kichekiy ambaŋ ayak kun ak, aŋgyok mer niŋiy kirpun?” ");
INSERT INTO kmh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aŋgeyak aŋgak, “Gor gek mis amniŋgamb aŋgiy, gos kilis giy ma niŋbim ak mey kun gip. Pen niŋim! Gos nimb ak mon mastet yiŋ maŋgiy sikoy mindip rek ak niŋiy, niŋwos giniŋgambim ak; tap yerip okok aŋgem, aŋgniŋgambim rek giniŋgamb. Miñmon yirik biy liŋg siŋbindoŋ amnoŋ aŋgeniŋgambim, Gor gek amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pen kichekiy ambaŋ ayip kun ak, yikop aŋgyokep rek ma ayip. Tap keñmaŋgiy kirgiy Gor nup aŋgniŋ mindiy mey, aŋgyokpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jiysis binuk gok, miñmon Galiyliy ap nan-geyak, kuyip aŋgak, “Maŋ mindip: Bi bap Ñinuk nup dand amiy, biynimb gunap kuyip ñeniŋgambay, ");
INSERT INTO kmh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nup pisnep pikayey kumniŋgamb ak pen; ñin omiŋal nokom mindiy, tip ak tikjakniŋgamb aŋgak.” Kun aŋgek, binuk gok nup simb niŋiy, gos kuŋay yimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pen kisen Jiysis binuk gok yip miñmon Kapaniyam ameyak, bi Gor aŋgniŋep korip takes dep gok apiy, Piyta nup aŋgyak, “Tiysa nimbik ak takes pikip sek?” ");
INSERT INTO kmh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aŋgeyak aŋgak, “Yaw! Nuk takes pikip sek aŋgak.” Piyta pen kun aŋgiy korip miŋgan amek, Jiysis nup aŋgniŋiy aŋgak, “Gos nand yerip niŋban? Gapman biyomb gok, takes maniy akay nimb dipay? Biynimb miñmon kiyk key gok nimb dipay akaŋ, biynimb par okok nimb dipay aŋgak?” ");
INSERT INTO kmh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kun aŋgek Piyta aŋgak, “Biynimb par okok nimb dipay aŋgak.” Aŋgek Jiysis aŋgak, “Bi kiyk key gok takes ma pikpay ak pen; ");
INSERT INTO kmh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","chin ma pikoniŋgambun; kuyip miluk yowniŋgamb rek ayip. Nand wik ak dam ñiŋg biyaŋ yokiy piys nind diniŋgamban ak, meŋg minim ak tuŋglakiy niŋniŋgamban; maniy maŋgiy won bap mindeniŋgamb. Diy dam takes chirmiŋay ak ñinimin aŋgak.” Aŋgek mey, am aŋgak rek gak. ");
INSERT INTO kmh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jiysis binuk gok apiy nup aŋgyak, “Biynimb Gor diy kond mindip gok, an yomb yimb rek mindip?” ");
INSERT INTO kmh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aŋgeyak Jiysis ñapan sikoy bap suk aŋgek apek, di windin yirik ar kuyip siŋak jakñek mindakniŋ aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Nimbip niŋind yimb aspiyn! Yimb yomb dun aŋgiy niŋbim ak kirgiy ñapan sikoy siskoy diy mindpay rek mindem mey; Gor nimbip dinimuŋ rek ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kun ak biynimb yimb yomb diniŋg ñapan sikoy biy rek mindiy mey, biynimb nuk diy kond mindeniŋgamb namb ak biynimb yomb rek mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pen biynimb yip gosimb niŋiy, ñapan sikoy biy rek direp giniŋgambay gok; kuyip nep mer, yip sek direp giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Pen biynimb gunap biynimb yip gos kilis giy ma niŋbay bap gey apyap pikniŋgamb ak, timey yimb giniŋgambay. Kuyip tiwniŋg dam ñiŋg yomb ak yokey ñiŋg ñimbiy kumbiyap ak girep gipyap. Yenen: kim mindiy timey giniŋgambay kun rek yiwur yomb yimb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Biynimb mankumb biy mindpay gok miker yimb giniŋgamb. Miñ timey ar ak giy, biynimb gunap kuyip gos ñey, ar kun ak giy apyap pikpay ak, timey yimb gip. Miñ ar kun ak; nind giyiŋgipay, miñiy gipay, kisen kunep giniŋgambay. Pen biynimb miñ ar kun ak gi yombay gok yiwur yomb yimb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ñin akaŋ, tomb kind nimb bap tap siy tap timey gep rek ayonimuŋ; kind kun ak timbrikyoknimimb. Kun giy mey, tap siy tap timey gep ar ak kirgiy, permindep ak diniŋgambim. Pen mindrep ma giy, tap siy tap timey gep ar ak gi dand amiy, mon per yin mindip ak amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Pen windin niŋiy tap siy tap timey gep rek ayonimuŋ, windin piskind kun ak tuŋgjiwyoknimimb. Kun giy perper mindenimimb rek ayniŋgamb. Pen mer ak; tap siy tap timey gi mindiy miñmon Hel, mon key yinjap ak amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Niŋrep ginimimb. ‘Ñapan sikoy gok tap yikop aŋgiy gos ak ma niŋnimimb. Gor kuyip niŋmindiy, enjol kuyip gok aŋgek, am windin yirik ar nup ak mindyiŋg opay. ");
INSERT INTO kmh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bi bap Ñinuk lum biy wak ak biynimb Nop ker ma mindpay gok kuyip diniŋg owak. ");
INSERT INTO kmh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bi bap kanj siypsiyp nuk ñin jiwiy onep mamind ak rek mindeniŋgamb. Pen nokom bap kurgeniŋgamb nuk yerer giniŋgamb? Gunap kuyip kirgek tap kaskas ñiŋyakniŋ, nokom kurginiŋgamb anup piyowek amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nimbip niŋind aspiyn. Am piyow giraŋgraŋg diy, miñmiñ yimb giniŋgamb. Kanj nuk niŋek tep gip rek ma giniŋgamb; kanj nuk kurgek piyow niŋniŋgamb anup niŋek tep kun ak key yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kun ak rek, Bapiy chin semb biyoŋ mindip ak, ñapan sikoy nuk bap ma kurginimuŋ aŋgiy niŋimb. ");
INSERT INTO kmh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Biynimb Gor nup chiŋgey mam ay aŋgniŋgambim gok, bap nimbip timey gonimuŋ; am nund yip key mindiy, tap ginimuŋ kun ak miseŋ aŋgnimimb. Kun giy aŋgem niŋdek mey, namam nanay nimbik yimb mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pen ma niŋdek; am biynimb nokom akaŋ omiŋal rek poŋind amiy niŋmindyakniŋ, minim aŋgnimiyr. ");
INSERT INTO kmh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pen kun gem ma yimb niŋdonimuŋ; biynimb lotiw opay rek maŋgiysek niŋmindyakniŋ aŋgnimin. Pen ma niŋdonimuŋ, biynimb tap siy tap timey gipay gok kuyip gipim rek ak ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Kun ak nimbip niŋind aspiyn. Minim kun ak rek man ar biy tuŋgasik ay, mer aŋgeniŋgambim, Gor nuk semb biyoŋ mindiy, kunep mer aŋgniŋgamb; pen yaw aŋgeniŋgambim, nuk kunep yaw aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Niŋind yimb aspiyn. Biynimb omiŋal mankumb biy mindiy, minim aŋg ar nokom ay, Gor nup aŋgniŋeniŋgayr; Bapiy semb biyoŋ mindip ak aŋgniŋgayr rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pen biynimb omiŋal akaŋ, omiŋal nokom rek, gos yip niŋiy, ap nan-geniŋgambay, yand namb kuyip okok wopsakiy mindeniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piyta Jiysis mindek maŋ siŋak apiy aŋgak, “Biyomb! Mam gunap yip ñin yerip yerip rek timey gey kuyip niŋiy kirginim? Ñin onep ar ak rek akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aŋgek Jiysis aŋgak, “Yand nip, ñin onep ar rek ma aŋgniŋgayn; ñin jiwiy ñin jiwiy onep ar ak rek aŋgniŋgayn.” ");
INSERT INTO kmh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mam gunap nimbip timey gey, niŋiy ma kirginiŋgambim ak, minim mindeniŋgamb. Pen Gor nuk giniŋgamb ak; kesim aŋgniŋg gispiyn biy rek. ");
INSERT INTO kmh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","25","Biyomb ak, bi nup woŋg giyak gok, tap day yip gok pen ñim aŋgek, bi tap day nuk maniy yir ñin jiwiy kuŋay yimb nep mindek bap nup dand wiyak. Pen bi kun ak tap day yomb yimb mindek, pen ñinimuŋ rek ma ayak. Kun gek biyomb ak niŋiy, binuk gunap kuyip aŋgak, ‘Gip kun ak nup diy; biyn ñapan, tap nuk yerip yerip mindip gok maŋgiysek diy, dam maker ayem taweniŋgiy, maniy kun ak dap yip ñinimimb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kun aŋgek bi kun ak pen; koŋgim yimiy, jiy kuyaŋgiy, biyomb anup aŋgak, ‘Nand yip simb niŋiy kond mindenimin; tap day nak kun ak maŋgiysek day paŋgniŋgayn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aŋgek, biyomb ak nup simb niŋiy, tap day nuk kun ak kirgak. ");
INSERT INTO kmh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kun giy kirgakniŋ, nuk pen amiy niŋak; binuk yip woŋg giyiŋgipiyr ak ap mindek. Niŋiy nup kuŋam chichiy diy aŋgak, ‘Nip maniy yir nokom bap ñinik ak, yip pen ñan aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aŋgek binuk yip woŋg giyiŋgipiyr kun ak koŋgim yimiy, jiy kuyaŋgiy aŋgak, ‘Yip simb niŋiy kond mindenimin; tap day nak kun ak, maŋgiysek day paŋgniŋgayn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aŋgek bi kun ak minim nup ak ma niŋiy aŋgak, ‘Nip dam kalambis ayeniŋgayn, tap day kun ak day paŋgiy nep mey, mis amniŋgamban aŋgiy,’ nup dam kalambis ayak. ");
INSERT INTO kmh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kun gek binuk yip woŋg giyiŋgipay gok kuyip simbwur timey gek, am biyomb kiyk anup minim kun ak aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aŋgñeyak, biyomb ak, binuk kun anup suk aŋgek apek aŋgak, ‘Nand bi timey yimb. Yip siy aŋgamban, nip simb niŋiy tap day yand nip mindip ak kirpiyn. ");
INSERT INTO kmh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pen yenen, bi yip woŋg gipiyr anup simb niŋiy, ma kirpan? ");
INSERT INTO kmh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nup pen yenen dam kalambis ay, bi kalambis kond mindip anup apan, “Nup kalambis ayey, yiwur gakniŋ mindiy, tap day yip ak day paŋgiy nep mis amniŋgamb apan” aŋgak.’ “Bi kun ak, binuk yip woŋg giyiŋgipiyr anup, simb ma niŋak ak mey; biyomb ak, bi kun anup dam kalambis ayak. ");
INSERT INTO kmh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nimb mam gunap kuyip kunep geniŋgambim, Bapiy semb biyoŋ mindip ak, nimbip pen kunep giniŋgamb. Kun ak kuyip simb yimb niŋiy, nimbip timey gipay ak niŋiy kirginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jiysis minim kun ak aŋgjiwiy, miñmon Galiyliy kirgiy; miñmon Jiwdiya Joden ñiŋg kind akdoŋ ken amnak. ");
INSERT INTO kmh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Amek biynimb kuŋay yimb nep nup kisen geyak, biynimb tap gak gok kuyip gek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pen bi Peresiy gok, nup aŋgniŋon yerip rek aŋgnimuŋ aŋgiy, apiy aŋgyak, “Low chin ak, biyn ak tap sikoy bap girep ma gek, nup aŋgyokniŋg aŋgyokniŋgambun akaŋ; nand yerip gos niŋban?” ");
INSERT INTO kmh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aŋgey Jiysis aŋgak, “Baybol buk tikyak ak nimb ma niŋbim? Miñmon alwol gayak ñin ak, bi bap biyn bap gayak. ");
INSERT INTO kmh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gor aŋgak ‘Ar kun ak mey bi gok, nop nonim yip mindiy, biyn diyiŋg kuyip kirgiy kiykber jimñiy kiner mumbwak nokom yimb ayip aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kun ak Gor aŋgek mumbwak kiyk nokom ayniŋgamb kun ak, bi gunap tikjakiy kuyip aŋg tuŋgasik keykey ma ayniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jiysis kun aŋgek, bi Peresiy gok nup aŋgyak, “Pen yenen Mosis minim bap tikiy aŋgak, ‘Biyn aŋgyokniŋg; biyn biy pisnep kirsipiyn aŋgiy, minj band bap tikñiy aŋgyoknimimb aŋgak?’” ");
INSERT INTO kmh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aŋgeyak Jiysis aŋgak, “Nimb biynimb maŋgiysek, minim kun ak ma niŋdiyiŋgipim ak mey, Mosis kun aŋgak. Pen Gor biynimb gayak ñin ak kun ma giyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nimbip aspiyn; bi an biynuk bi bap yip di ger mer; yikop nep aŋgyokiy, biyn kisen diniŋgamb ak; Gor niŋek timey yimb giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aŋgek binuk gok aŋgyak, “Bi gok biyn diy yikop kirginiŋgiy rek ma ayip ak, biyn ma diniŋgiy ak tep rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aŋgeyak Jiysis aŋgak, “Bi maŋgiysek yikop mindeniŋgiy rek ma ayip. Gor biynimb yikop mindeniŋgiy aŋgiy aŋgayak gok nep, yikop mindeniŋgiy rek ayip. ");
INSERT INTO kmh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bi gunap walak dey mey, biyn ma dipay. Gunap ma ayek mey ma dipay. Gunap Gor biynimb diy kond mindeniŋgamb woŋg ak gun aŋgiy, ma dipay. Pen minim apim kun ak, biynimb diniŋg giniŋgiy gok, diniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Biynimb gok Jiysis ñapan chinup gok ñin jun ar biyoŋ diniŋaŋ aŋgiy, dand apeyak, binuk gok kuyip niŋchikiy aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kun aŋgeyak Jiysis pen ñapan kun gok suk aŋgek wiyakniŋ, binuk gok kuyip aŋgak, “Kuyip yenen aŋg gipim! Ñapan sikoy gok kirgem yip ker wiyaŋ. Gor biynimb diy kond mindeniŋgamb gok mey, ñapan sikoy kun gok rek aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kun aŋgiy, ñin nuk ak ñapan sikoy kun gok jun ar ak ay, kuyip bilesiym giy, miñmon wikan bap amnak. ");
INSERT INTO kmh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bi bap Jiysis mindek ak apiy aŋgak, “Tiysa. Yand tap yerip tep ak giy, Gor yip dek perper mindeniŋgayn?” ");
INSERT INTO kmh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aŋgek Jiysis aŋgak, “Yenen yip tap yerip tep, tap yerip timey aŋgiy aŋgniŋban? Gor nokom mey bi tep. Pen perper mindenim aŋgiy, low minim aŋgiy tikyak gok ma timbriknimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aŋgek aŋgak, “Low ar akay rek aspan?” Aŋgek Jiysis aŋgak, “Chip ma ñaŋgnimimb. Biyn siy bi siy ma ginimimb. Tap siy ma dinimimb. Yesek ma aŋgnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nap nanim minim aŋgniŋgiy rek niŋiy kindik ginimimb. Biynimb gunap kuyip, nimb key wasemb aypim rek ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kun aŋgek, bi paranj kun ak aŋgak, “Low minim gok maŋgiysek niŋdipiyn. Pen tap yerip ak giy, Gor yip dek perper mindeniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aŋgek Jiysis aŋgak, “Mindrep yimb giyn aŋgiy, tap nak gok maŋgiysek yokiy maniy diy, biynimb yimgeprek gok kuyip ñiy mey, mind tep gep nand ak mindeniŋgamb Gor miñmon biyoŋ. Pen apiyn rek giy apiy, yand yip taŋgonjur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aŋgek, tap nuk kuŋay mindek rek, minim kun ak niŋiy, gos kuŋay niŋyiŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pen nuk kun giy amnakniŋ, Jiysis binuk gok kuyip aŋgak, “Yand nimbip niŋind yimb aspiyn. Biynimb maniy tap kiyk kuŋay mindeniŋgamb gok, Gor nup kosyam gosimb niŋey, kuyip diy kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kanj kamel gok, ñiw lekpay miŋgan ak amniŋg amniŋgambay; pen biynimb tap kuŋay mindip gok, Gor nup kosyam gos niŋey, kuyip diy kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jiysis binuk gok minim kun ak niŋiy, gos yomb niŋiy aŋgyak, “Aspan kun ak, biynimb yerip rek gok Gor diy kond mindeniŋgamb?” ");
INSERT INTO kmh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aŋgeyak Jiysis kuyip niŋyiŋg aŋgak, “Biynimb gok key giniŋgiy rek ma ayniŋgamb; Gor nep mey yerer giniŋg giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jiysis kun aŋgek, Piyta aŋgak, “Niŋan! Tap chin gok maŋgiysek kirgiy, nand yip nep chiŋgiy tapun ak; chin pen tap yerip diniŋgambun?” ");
INSERT INTO kmh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aŋgek Jiysis aŋgak, “Yand nimbip aspiyn; Bi bap Ñinuk ñin kisen ak mokyaŋ ñiluk giy apiy, biynimb maŋgiysek kond mindeniŋgamb. Ñin kun ak mey, nimb bi yip kisen giniŋgambim gok kunep aŋgen Yisrel biynimb kiñiŋ onep wimiŋgan ak kuyip kond mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Biynimb yip gosimb niŋiy; numam nunay, nop nonim, korip woŋgday, tap yerip yerip okok kirginiŋgambay gok, Bapiy kuyip sakiy ma giniŋgamb. Tap kun gok rek kuyip pen kuŋay yimb ñiy, gek perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Biynimb kuŋaynep miñiy yomb mindpay gok, sikoy tam okok mindeniŋgambay; biynimb sikoy tam okok mindpay gok, biynimb yomb mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jiysis kun aŋgiy aŋgak, “Gor biynimb diy kond mindeniŋgamb ak, kesim ar biy rek mindip. Bi wayn woŋg nop bap, bi gunap am dand apen woŋg yip ak giyaŋ aŋgiy, kisyim tikjakiy, ");
INSERT INTO kmh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","am bi gunap piyow niŋiy, nimbip maniy kun kun giy tawniŋgayn aŋgiy, kiy yip minim aŋg ar nokom ay, aŋgyokek am wayn woŋg nup ak gi mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pen pumb ak yep namb siŋak araniŋgamb won ak, maker namb ak amiy niŋniŋgamb; bi gunap yikop mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kuyip niŋiy aŋgniŋgamb, ‘Nimb kunep am woŋg yip ak geniŋgambim; nimbip maniy ñimbay rek namb ak ñiniŋgayn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aŋgek, am woŋg nup ak geniŋgambay. Pen pumbnamb yomb biyoŋ won ak sek, pumb kuyim giniŋgamb won ak sek minim kun ak nep aŋgiy, bi gunap sek dek, woŋg nup ak geniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pumb saŋind amniŋg giniŋgamb won ak, tip ak maker namb amiy niŋniŋgamb: bi gunap sek ap mindeniŋgambay mey; kuyip aŋgniŋgamb, ‘Nimb yenen ñin biy woŋg ma giy, yikop yimb mindpim?’ ");
INSERT INTO kmh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Aŋgek, nup aŋgniŋgambay, ‘Bi bap chinup woŋg bap ma ñimb aŋgniŋgambay.’ Aŋgeniŋgambay aŋgniŋgamb, ‘Nimb kunep am wayn woŋg yip ak gem aŋgek;’ ");
INSERT INTO kmh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","am woŋg geniŋgambay. Duŋgep won ak, biyomb kuskus nuk anup aŋgniŋgamb, ‘Am bi woŋg yip gispay gok kuyip aŋgey apey; bi kisen opay gok maniy kuyip ak nind ñiy, bi nind opay gok kuyip, kisen ñinimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Aŋgek bi kuskus ak, bi kun gok kuyip suk aŋgek apey, bi pumb paŋind amnakniŋ ap woŋg geniŋgambay gok, ap maniy kiyk ak nind diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pen kiyk kun giy diyakniŋ, bi nind aŋgek ap woŋg geniŋgambay gok maniy yomb ak diniŋgambun aŋgniŋgambay ak pen, kisen diyiŋg niŋniŋgambay maniy namb kun anep diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Diy, day bi wayn woŋg nop nimb ak yip penpen aŋgiy aŋgniŋgambay, ");
INSERT INTO kmh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Chin yenen bi kisen opay gok maniy dipay rek nep dipun? Kisyim tikjakiy pumb sinjrimey niŋakniŋ, woŋg gon gon yiruk gip ak pen; bi ap sikoy won bap gambay gok, kuyip maniy ñimban rek nep chinup ñimban aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Aŋgeniŋgambay bi woŋgday nop nimb ak niŋiy, bi kiyk bap nup aŋgniŋgamb, ‘Mam niŋan! Nimbip timey ma gipiyn; maniy ñiniŋgayn apiyn rek ñimbiyn. ");
INSERT INTO kmh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Bi kisen opay gok, bi nind opay gok yip andip andip ñiniŋg ñiniŋgayn; ak tap yand. Kun ak bi gunap yergiy mer aŋgniŋgambay. Kuyip monmon ñimbiyn ak nimbip yenen miluk yowip. Maniy ñimbiyn ak dand korip nimbik amnim aŋgniŋgamb!’ ");
INSERT INTO kmh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jiysis kesim kun ak aŋg day jiwiy aŋgak, “Biynimb nind mindpay gok, kisen mindeniŋgambay; biynimb kisen mindpay gok, nind mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jiysis Jerusalem amyiŋg, kinjeŋnamb okok binuk onep wimiŋgan ak kuyip dand gol okok amiy key mindyakniŋ aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Niŋim! Chin Jerusalem amon, Bi bap Ñinuk nup mimuŋg giy, di biyomb Gor nup simboŋgep gok sek, bi low tiysa gok sek ñin ar kuyip ak ayeniŋgambay, kiyk minim aŋgiy aŋgniŋgambay ‘Bi biy nup pikayep aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kun aŋgiy, Jiwda kay kuyip ñeniŋgambay, nup aŋgjiwiy, tapin pikiy, dam mon kiros bak biyoŋ ñaŋgbirikayey kumniŋgamb ak pen; ñin omiŋal nokom mindiy, tip ak tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebediy ñinuk omiŋal ak kuyip, nonim poŋind Jiysis mindek ak apiy, jun paŋgiy aŋgak, “Yand minim bap mindamb aswiyn aŋgak.” Aŋgek Jiysis aŋgak, “Minim kun ak yerip?” ");
INSERT INTO kmh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aŋgek aŋgak, “Yip tep giniŋgamb ak; kisen nand kiyŋ yomb mindiy, biynimb kond mindeniŋgamban ñin ak, ñi yand omiŋal ak bak nip siŋak pis pis bisginiŋgayr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kun aŋgek Jiysis pen, yiwur diniŋgamb rek paydoŋ ay aŋgak, “Minim yip aŋgniŋbim ak, niŋrep ma gipim. Nirmiŋay ñiŋg silik yand ñiŋniŋg gispiyn ak kunep ñiŋniŋgayr?” Aŋgek, “Yaw! Ñiŋniŋgambur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aŋgerik aŋgak, “Niŋind apiyr. Ñiŋg silik ñiŋniŋg gispiyn ak ñiŋniŋgayr ak pen, an aŋind pis, an yipund pis mindeniŋgayr ak ma aŋgayniŋgayn; minim kun ak Bapiy minim nuk. Binuk aŋgayip gok biyomb kun ak rek mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Binuk omiŋal minim kun ak aŋgerik, binuk onep wanjrem ak niŋiy, kuyip mamiymiŋay minim yomb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jiysis pen kuyip maŋgiysek aŋgek apey aŋgak, “Biyomb miñmon okok, biynimb gok kuyip kond mindiy minim kilis giy aŋgey ñawil dipay ak niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pen kiyk gipay rek ma ginimimb. Bi nimb bap biyomb mindniŋg ginimuŋ ak, bi tam okok rek mindiy, nimbip gunap woŋg giñinimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pen bi nimb bap, biyomb yimb mindniŋg ginimuŋ ak, bi sikoy tam okok rek mindiy, biynimb gok woŋg giñinimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bi bap Ñinuk ak, woŋg yip giyaŋ aŋgiy ma wak; biynimb gunap kuyip woŋg giñi dand amiy, kisen tap siy tap timey gipay rek tip kuyip ak diy kumen kiyk kim amniŋgiy aŋgiy awak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pen Jiysis dawin yomb Jeriykow kiriŋg amnakniŋ, biynimb kuŋaynep kisen giyak. ");
INSERT INTO kmh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bi windin koy omiŋal ak lor gol siŋak bisiŋg mindrikniŋ, Jiysis asaw aŋgey niŋiy, meŋg miŋgan dand araniy aŋgrik, “Depiyt Ñinuk. Chirup simb niŋnimin aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aŋgerik biynimb gok, kuyipmiŋay niŋchikiy aŋgiy, “Kilpul ma aŋgiyr aŋgyak.” Kun aŋgeyak, minim kuyip ak ma diy, meŋg miŋgan dand araniy aŋgrik, “Depiyt Ñinuk! Chirup simb niŋnimin aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kun aŋger Jiysis ap minderik siŋak aland giy, kuyipmiŋay aŋgak, “Chirup yergaŋ aŋgiy, suk aspiyr?” ");
INSERT INTO kmh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aŋgek aŋgrik, “Biyomb! Chirup windin koy gip ak, gey niŋur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aŋgerik Jiysis kuyipmiŋay simb niŋiy, windin kuyip ak diniŋek, won kun anep suŋ ayek, nuk amnakniŋ, kisen girik. ");
INSERT INTO kmh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jiysis binuk gok yip Jerusalem maŋ maŋ giy, miñmon sikoy Betpasiy, Oliyp dum maŋ siŋak amjakiy, binuk omiŋal aŋgyokiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Nirmiŋay miñmon wikan bindoŋ amiy niŋniŋgayr: doŋgiy marip biynimb ma dand tapay bap nonim yip tiwniŋg ayey mindeniŋgamb. Miñ ak wisikiy poŋind winimiyr. ");
INSERT INTO kmh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pen biynimb gunap apiy yenen kanj doŋgiy chinup ak wisik dand amjipiyr aŋgeniŋgiy aŋgnimiyr, ‘Biyomb ak woŋg mindek aŋgamb diniŋg opur aŋger, yaw aŋgey dand winiŋgayr aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pen kuyipmiŋay yokek diniŋg amnirik kun ak, bi Gor minim aŋgep bap giniŋgamb aŋgiy tikak rek nep gak. Nuk aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem biynimb kuyip aŋgnimimb, ‘Biyomb nimb ak doŋgiy ar bisgiy nimbip ker asaw. Nuk bi yikop rek bap doŋgiy ñiluk ar ak bisgiy asaw aŋgnimimb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pen Jiysis binuk aŋgyokek amnirik omiŋal kun ak, aŋgak aŋgak rek, ");
INSERT INTO kmh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","doŋgiy marip ak sek poŋind aperik, binuk gok chech tuŋgasikiy, doŋgiy marip ar ak ayeyak, ar kun ak bisgak. ");
INSERT INTO kmh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Biynimb kuŋaynep Biyomb asaw aŋgiy, chech paryomb kiyk aryoŋ ay mindeyak gok tuŋgasik kinjeŋram ak ayak. Gunap am minj kas mon kas okok timbrik dapiy ayak. ");
INSERT INTO kmh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pen nup piŋiy kus kus giy amyiŋg aŋgyak: “Depiyt tikek, tik dand amiy tikip ak owip biy. Niŋim! Gor nup yokek owip. Gor nup tep aspun aŋgyak!” ");
INSERT INTO kmh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jiysis Jerusalem amjakakniŋ, biynimb gok aŋg amiy apiy giy aŋgyak, “Bi kun ak an aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aŋgeyak, biynimb Jiysis yip wiyak gok aŋgyak, “Bi biy mey Jiysis; bi Gor minim aŋgep Nasaret Galiyliy propens nimb ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiysis Gor aŋgniŋep korip miŋgan biyaŋ amiy: biynimb tap maker ay geyak gok, kuyip maŋgiysek yukyokiy, boŋg band maniy ay yimjik geyak gok tuŋgandikiy, bi yakir yokyiŋg cheya bisiŋg mindeyak gok tuŋgandikiy gak. ");
INSERT INTO kmh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kun giyiŋg, kuyip aŋg giy aŋgak, “Baybol buk tikyak ak, Gor aŋgak, ‘Korip yand ak yip aŋgniŋep.’ Pen nimb gispim ak, bi tap siydep kapkap weyiŋg mindpay korip bap rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pen Jiysis Gor aŋgniŋep korip miŋgan kun ak mindakniŋ, biynimb windin koy giy, tomb timey giy gak gunap apeyak, kuyip gek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nuk tap mageprek gek, ñapan sikoy gok suk aŋgyiŋg aŋgyak, “Depiyt Ñinuk. Tap mageprek gipan! Wis-ey! aŋgyak.” Pen kiyk kun aŋgeyak, bi Gor nup tap simboŋgep yomb gok sek, bi low tiysa gok sek, kuyip miluk yimb yapek aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Nip aspay ak niŋsipan? Aŋgey kirgiyaŋ aŋgyak.” Aŋgeyak Jiysis aŋgak, “Aspay ak niŋsipiyn ak pen; ñapan ŋaŋ gok kuyip gos tep ñen, yimb yip dand araniŋgambay aŋgiy tikyak ak ma niŋbim?” ");
INSERT INTO kmh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kun aŋgiy, kuyip kirgiy, am miñmon sikoy Beteniy kinak. ");
INSERT INTO kmh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Minek Jiysis andkind Jerusalem winiŋg, kinjeŋnamb okok apek yiwan gek, ");
INSERT INTO kmh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","kinjeŋram gol siŋak mon kiyaw bind bap niŋiy kiñiŋ siŋak amiy niŋak: maŋgiy ma piyak; kas gok nep mindek. Kun gek aŋgak, “Mon bind biy kisen maŋgiy ma yimb piyniŋgamb aŋgak.” Kun aŋgakniŋ, day kiyaw bind kun ak milip gak. ");
INSERT INTO kmh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Binuk gok niŋiy, wal aŋgiy aŋgyak, “Yergiy mon kun biy kasek milip gisap?” ");
INSERT INTO kmh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aŋgeyak Jiysis kuyip aŋgak, “Pen niŋim! Chin aŋgon kunep ginimuŋ aŋgiy, gos okok ma niŋnimimb; Bapiy yomb nuk giniŋgamb aŋgiy, gos nokom niŋem, giniŋgamb. Pen kun anep mer; miñmon dum biy liŋg ñiŋg yomb namb siŋak amnaŋ aŋgem, gek amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gor chinup direp giniŋgamb aŋgiy aŋgniŋem, aŋgniŋgambim rek giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiysis Gor aŋgniŋep korip ak amiy, biynimb gok kuyip minim aŋgñakniŋ, bi Gor nup simboŋgep yomb gok sek, bi minim tuŋgasikep gok sek apiy, nup aŋgyak, “Nip an kun ginimin, kun ginimin aŋgek, girapan?” ");
INSERT INTO kmh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aŋgeyak Jiysis pen aŋgak, “Nimbip minim bap aŋgniŋen, yip aŋgñem, pen an aŋgek girapiyn ak, nimbip aŋgñiniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon biynimb gok kuyip ap ñiŋg pikñak ak, gos nuk key niŋiy gak akaŋ, Gor aŋgek ap kun gak?” Jiysis kun aŋgek, kiyk key aŋgniŋ aŋgniŋ giy aŋgyak, “Chin Gor yokek ap gak aŋgoniŋgambun; chinup aŋgniŋgamb, ‘Kun ak Jon aŋgip ak yenen ma niŋdipim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pen Jon gos nuk key niŋiy ap gak aŋgoniŋgambun; biynimb gok Jon bi Gor minim aŋgñemb apay rek chinup kuŋay aŋgniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kun aŋgiy Jiysis nup aŋgyak, “Chin ma yimb niŋbun aŋgyak.” Aŋgeyak kuyip aŋgak, “Yip ma aŋgñimbim rek yand pen, an aŋgek ap gispiyn ak nimbip ma aŋgñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Pen nimb yerip gos niŋbim? Bi bap ñinuk omiŋal mindeniŋgamb. Ñinuk nind ak nup miñiy wayn woŋg ak am gey aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ma am giniŋgayn aŋgiy, kisen pen gos andikiy niŋiy, am wayn woŋg ak geniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nop pen am ñi kisen anup kunep aŋgek, yaw giniŋgayn aŋgniŋgamb ak pen, ma am giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pen ñi omiŋal kun ak, an nop aŋgniŋgamb rek niŋdiniŋgamb?” Aŋgek Jiwda biyomb kun gok aŋgyak, “Ñinuk nind ak nop aŋgniŋgamb rek giniŋgamb aŋgyak.” Aŋgeyak Jiysis aŋgak,” Nimbip niŋind aspiyn: nimb yikop mindpikniŋ bi takes diy maniy yesek gunap dipay gok sek, kinjeŋram biyn gok sek Gor biynimb diy kond mindeniŋgamb kiñiŋ ak mindonjun aŋgiy, nimbip tawsak aysipay. ");
INSERT INTO kmh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon bi ñiŋg pikñemb ak apiy nimbip, suŋ mindeniŋgambim minim ar ak aŋgñiyiŋgip ak pen; kindik ma gipik. Bi takes diy maniy yesek gunap dipay gok sek, biyn waŋ siy dipay gok sek minim kun ak niŋiy kindik giyak. Kiyk giyak kun ak niŋiy, nimb yenen gos kisenimb bap niŋiy, Jon nup minim ak ma dipik. ");
INSERT INTO kmh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jiysis aŋgak “Miñiy minim paydoŋ ay bap sek aŋgniŋg gispiyn. Bi mankumb nop nimb bap miñ wayn woŋg ak gi yimiy wariy giy, miñ maŋgiy piksimbjakep kiwok bap gayniŋgamb. Gay, miñ maŋgiy ak ap siy ñiŋniŋgiy rek ayip ak niŋmindenjun aŋgiy, korip paryomb yiy akyoŋ bap giy; bi gunap kuyip miñ woŋg yip ak kond mindenimimb; kisen piy pik gek, yip gunap nimb gunap dinimimb aŋgiy, miñmon paryomb okok amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Miñ maŋgiy ak pik gakniŋ, binuk gok kuyip, yip gunap am dand wim aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kiyk amjakey, bi wayn woŋg gi mindeniŋgambay gok tikjakiy, bi bap nup gamb pikniŋgambay; bap nup kamb jiw pikniŋgambay, bap nup pisnep pikayey kumniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kun gey bi miñ wayn woŋg nop nimb kun ak, bi tapin kaw bap pen aŋgyokniŋgamb. Aŋgyokek ameniŋgambay, bi miñ wayn woŋg geniŋgambay gok, kuyip kunep giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kun gey, bi wayn woŋg nop nimb ak, Ñiyand ak yoken mey, minim nup ak niŋniŋgambay aŋgiy, aŋgyokek amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amjakek, bi wayn woŋg gi mindeniŋgambay gok nup niŋiy, kiyk key aŋgniŋgambay, ‘Bi woŋg nop nimb ñinuk ak asaw biy. Nop tip ak diniŋg gisap rek nup pikayon kumek, kisen tap woŋg guniy maŋgiysek diniŋgambun aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kun aŋgiy, nup dand woŋgday gol okok amiy, pisnep pikayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Kun geniŋgambay, kisen bi woŋgday nop nimb ak apiy, kuyip yerer giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aŋgek Jiwda kay aŋgyak, “Bi timey giniŋgambay kun gok kuyip geniŋgamb, yiwur yomb yimb diy kumniŋgambay. Kisen pen biynimb tep gunap diy, kuyip miñ wayn woŋg nup dayeniŋgamb, woŋg kun ak giniŋgambay. Miñ maŋgiy pik giniŋgamb ñin ak, nup rek ak jiw dam ñiniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aŋgeyak Jiysis aŋgak “Ak niŋind apim. Baybol buk minim tikyak ak niŋbim rek ayip. Tikiy aŋgyak; ‘Bi korip gep gok kamb ma dinjun aŋgiy kirgiyak ak; miñiy korip sap namb biyaŋ rek ak mindip. Gor kun gek niŋon, tep yimb gip aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Korip sap namb biyaŋ nup ma dipim kun ak, Gor nimbip Jiwda kirgiy, biynimb key okok nimb tap nup ñemb rek mindeniŋgambay gok kuyip diy kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Biynimb kamb ar kun ak apyap pikniŋgambay gok kuyip tapin nep pikniŋgamb; biynimb kamb kun ak puŋgjiw apyapiy aybirikniŋgamb gok, pisnep piksimbjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bi Gor nup simboŋgep yomb gok sek bi Peresiy gok sek, Jiysis minim paydoŋ ayak kun ak kuyip nep aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nup miñ ayun aŋgiy gos niŋyak ak pen; biynimb gok Jiysis nup bi Gor minim aŋgep aŋgyak ak niŋiy, chinup kuŋay aŋgniŋgambay aŋgiy, nup tap bap ma giyak. ");
INSERT INTO kmh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiysis tip ak paydoŋ ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Gor biynimb diy kond mindeniŋgamb minim ak aspiyn biy rek: “Bi kiyŋ bap ñinuk ak biyn diniŋg gek, tap yomb ñiŋniŋg, keñmaŋgiy dap nan-giy, ");
INSERT INTO kmh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","binuk gunap aŋgyokiy, biynimb aŋgaynik gok am aŋgem apey, tap yomb ak ñiŋun. Aŋgek am biynimb kun gok kuyip aŋgniŋgambay ak pen; kiyk kirginiŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kun gey binuk gunap pen tip ak aŋgyokiy aŋgniŋgamb, ‘Nimb am biynimb kun gok kuyip aŋgnimimb, “Biyomb ak, makaw yomb gunap, marip gunap pikay, tap okok maŋgiysek moka giy, winiŋgiy aŋgip aŋgnimimb!” ’ ");
INSERT INTO kmh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kun aŋgek kiyk am aŋgeniŋgambay, minim kuyip ak diyokniŋgambay. Gunap tap woŋg kiyk okok amniŋgambay. Gunap maniy woŋg kiyk ak geniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pen gunap, kiyŋ bi nup gok gi timey giy, pikayey kumniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Kun gey, kiyŋ niŋek simbwur nup ak timey gek, amiybi nuk gok aŋgyokek, am biynimb timey giniŋgambay kun gok kuyip pikaydiy, korip kuyip gok daŋgiyjiw pikey amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pen bi nup woŋg giñemb gok kuyip aŋgniŋgamb, ‘Keñmaŋgiy tap gok daŋgiy nan-gipun ak pen; biynimb nind suk aŋgnik gok ma opay. ");
INSERT INTO kmh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kun ak nimb am kinjeŋ tam okok mindiy, biynimb niŋnimimb okok kuyip monmon poŋind apem tap yomb ñiŋjun aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kun aŋgek binuk gok am kinjeŋ tam okok mindiy, biynimb timey giniŋgambay gok, biynimb tep giniŋgambay gok monmon poŋind apey; biyn diy tap yomb ñiŋniŋgambay korip miŋgan kun ak timbik giy yimb aŋgiy mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Bi kiyŋ ak pen; biynimb opay kun gok niŋiyn aŋgiy, korip miŋgan biyaŋ amiy niŋniŋgamb: bi bap chech ay korip miŋgan kun biyaŋ owep ak ay ma mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kun gek nup aŋgniŋgamb ‘Buŋgiy! Yenen, biyn diy tap ñiŋniŋg chech aypay ak ay mer; yikop nep ap mindpan?’ Aŋgek bi kun ak pen minim bap ma aŋgeniŋgamb, ");
INSERT INTO kmh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","bi kiyŋ ak binuk gok kuyip aŋgniŋgamb, ‘Bi biy ñin tomb nup gok tiwniŋgrimbikiy, dam kisyim owip namb akyaŋ diyokem, biynimb mindpay kun gok yip meŋg kamb siwbirikiy, siy aŋg mindeniŋgiy aŋgniŋgamb.’” ");
INSERT INTO kmh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jiysis paydoŋ ayak minim kun ak aŋgdiy, kuyip aŋgak, “Gor biynimb kuŋaynep suk aŋgip ak pen; maŋgiysek ma diniŋgamb. Biynimb gunap nep diniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pen bi Peresiy gok, Jiysis nup minim yerip ak aŋgon, pen aŋgek niŋiy, nup dam miñ ayjun aŋgiy, minim aŋgniŋ aŋgniŋ giy, ");
INSERT INTO kmh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","bi kiyk key gunap, Herot binuk gunap yokey, Jiysis mindek ak amiy aŋgyak, “Nand bi minim niŋind yimb nep apan. Bi gunap niŋiy ma pirikpan, Gor aŋgip rek nep niŋiy biynimb aŋgñimban. ");
INSERT INTO kmh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kun ak nand gos yerip niŋban? Chin Yisrel biynimb gok, Siysa biyomb miñmon Rom nimb anup takes pikep akaŋ ma pikep?” ");
INSERT INTO kmh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aŋgeyak Jiysis minim yesek aŋgyak kun ak niŋiy aŋgak, “Yip yenen nembnemb giyiŋg ap kun giy aŋgniŋbim? ");
INSERT INTO kmh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takes pikpay maniy bap ñem niŋiyn aŋgak.” Aŋgek nup maniy won bap dap ñeyak niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","kuyip aŋgak, “Maniy won kun biy an kawnan ak sek, yimb ak sek mindip?” ");
INSERT INTO kmh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aŋgek aŋgyak, “Ak biyomb Siysa mindip aŋgyak.” Aŋgeyak Jiysis kuyip aŋgak, “Kun ak Siysa yip ginimimb aŋgip gok, nup ginimimb; Gor yip ginimimb aŋgiy niŋimb gok, nup ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kun aŋgek kiyk gos kuŋay niŋiy, nup kirgiy amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ñin kun anep, Sanjiwsiy bi gunap Jiysis mindek ak wiyak. Sanjiwsiy biynimb gok biynimb kumiy tip ma tikjakpay apay ak mey, ");
INSERT INTO kmh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Jiysis mindek ak apiy aŋgyak, “Tiysa. Mosis aŋgak, ‘Bi bap biyn diy, ñapan tikiy mer, yikop kumeniŋgamb, numam bap biyn kun ak diy, ñapan nup gok aŋgiy tikniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","28","Kun ak, bi kiñiŋ sek onep ar ak mindeniŋgambay. Numam nind ak biyn diy, ñapan tikiy mer yikop kumniŋgamb. Kun gek, numam namb ak pen, biyn kun anep diy, ñapan tikiy mer, yikop kumniŋgamb. Kun anep gi dam dam, numam onep ar ak, maŋgiysek ñapan tikiy mer; yikop nep kumniŋgambay. Pen biyn ak kunep kumniŋgamb. Kun ak biynimb kumbay gok tikjakniŋgambay ñin ak, biyn kun ak an diniŋgamb?” ");
INSERT INTO kmh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aŋgeyak Jiysis kuyip pen aŋgak, “Nimb Baybol buk minim ak ma niŋiy, Gor gip rek ma niŋiy gipim ak mey, yesek aŋgiy apim, ‘Biynimb gok kumiy ma tikjakniŋgambay apim.’ ");
INSERT INTO kmh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pen tikjakniŋgambay ñin ak, biyn gok bi ma diniŋgambay bi gok biyn ma diniŋgambay; enjol semb biyoŋ gok mindpay rek ak yikop mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Nimb biynimb kumiy ma tikjakpay apim ak, Baybol buk minim tikyak gunap ma niŋbim rek ayip. ");
INSERT INTO kmh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Gor aŋgak, ‘Yand Gor yikop bap mer: Ebraham, Aysek, Jekop Gor kiyk mey, yand mindpiyn aŋgak.’ Biynimb pisnep kumbiyap ak, Gor yergiy bi nind kumyak kun gok bi yand apkop. Bi kumey komyak kun gok, kim mindpay ak mey; kuyip aŋgak, ‘Gor kiyk yand mindpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jiysis minim kun ak aŋgek, biynimb mindeyak gok niŋey kuyip tep yimb gak. ");
INSERT INTO kmh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jiysis minim kun ak aŋgrep gek, Sanjiwsiy bi gok minim bap pen aŋgniŋgiy rek ma ayak. Pen bi Peresiy gunap, Jiysis aŋgak minim kun ak niŋiy, mindek ak wiyak. ");
INSERT INTO kmh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bi kiyk low niŋrep gak bap Jiysis yerip rek aŋgnimuŋ aŋgiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tiysa. Gor low ayak minim ak, minim ar akay nup, minim yomb yimb mindip?” ");
INSERT INTO kmh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aŋgek Jiysis aŋgak, “‘Gos timund nand ak maŋgiysek Gor ker amek, nup wasemb yimb aynimin.’ ");
INSERT INTO kmh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Minim yomb yimb mey kun ak. ");
INSERT INTO kmh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Minim yomb bap mey; ‘Nand key wasemb aypan rek biynimb gunap kuyip, wasemb aynimin.’ ");
INSERT INTO kmh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gor low minim Mosis tikak gok sek, bi minim nup aŋgep gunap tikyak gok sek maŋgiysek, minim junj yomb yimb mey omiŋal kun ak nep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Peresiy kay ap nan-giy mindyakniŋ, Jiysis kuyip minim bap aŋgniŋiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nimb Kiyŋ yomb key yimb ak nup yerip gos niŋbim? Nup an ñinuk aŋgiy niŋbim?” Aŋgek, “Depiyt ñinuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aŋgey Jiysis aŋgak, “Niŋind apim ak pen, Gor Kawnan ak Depiyt nup gos ñakniŋ, nuk Kiyŋ yomb chin anup ‘Biyomb yand’ aŋgak. Minim aŋgak kun ak, Baybol buk tikiy aŋgyak ak niŋbim. Depiyt aŋgak: ");
INSERT INTO kmh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Gor Biyomb yip anup minim aŋgay aŋgip, “Nand kund bak yip ak mindiy mey; yand gen biynimb nip alemb alemb ñimbay gok kuyip, tomb beŋ okok tawbirikniŋgamban aŋgip” aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depiyt aŋgak kun ak nimb yenen apim, ‘Depiyt tikek, tik dand amiy, bi kiyŋ yomb key yimb ak nup tikpay apim.’ Pen Depiyt Biyomb yimb nuk ak mey, kiyŋ yomb key yimb apkip ak tep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jiysis minim nuk ak aŋgrep gek, kiyk nup pen aŋgniŋgiy rek ma ayek mey, kisen nup minim kun gok rek gunap sek ma aŋgniŋyak. ");
INSERT INTO kmh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kisen ñin bap, Jiysis binuk gok sek, biynimb yikop gunap sek kuyip minim aŋgiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","“Bi low tiysa gok sek, bi Peresiy gok sek minim kilrimey aŋgñimbay ar ak ma ginimimb; Mosis wosrey aŋgak rek aŋgñimbay ak nep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Minim kilrimey apay ak wand miker yomb gok rek biynimb gok kuyip gom ñimbay ak pen; kuyip simb niŋiy ma tuŋgasik dipay. ");
INSERT INTO kmh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chinup niŋyaŋ aŋgiy, Baybol buk tikyak minim gunap di jun-cheŋg biyoŋ akaŋ, ñin kind okok aybirikiy tapay. Gor binuk mey gok aŋgyaŋ aŋgiy, chech paryomb miñ daywur sek tep gok aypay. ");
INSERT INTO kmh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lotiw akaŋ, tap yomb ñimbay namb ak amiy, biyomb bispay cheya ar ak nep bispay. ");
INSERT INTO kmh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Biynimb kuŋay mindpay namb okok amon, tiysa aswan-ey aŋgey, chinup tep gaŋ aŋgiy niŋbay. ");
INSERT INTO kmh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pen nimb mam kiñiŋ nokom mindpim rek, nimbip tiysa ma aŋgniŋgiy. Tiysa nimb ak, nokom bap nep mindip. ");
INSERT INTO kmh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Man ar biy, bi gunap kuyip ‘Bapiy’ ma aŋgnimimb. Nap nimbik nokom yimb ak mindip; semb biyoŋ. ");
INSERT INTO kmh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nimbip biyomb chin ma aŋgniŋgiy. Biyomb nimbik ak mey, Kiyŋ yomb anep. ");
INSERT INTO kmh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nimb biyomb yimb mindniŋg ginimimb ak; bi woŋg giñemb rek ak mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Biynimb yimb kiyk key dand araniŋgambay gok, yimb kuyip yowniŋgamb: pen biynimb yimb ma dand araniŋgambay gok, yimb yomb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nimb low tiysa gok sek, Peresiy gok sek nimbip minim yomb mindip rek, nimbip simb niŋsipiyn. Nimb key Gor biynimb diy kond mindeniŋgamb miŋgan ak ma amiy, biynimb amniŋg gipay gok kuyip kinjeŋ tikpim. ");
INSERT INTO kmh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nimb low tiysa gok sek, Peresiy gok sek minim yomb yimb mindip rek, nimbip simb niŋsipiyn. Nimb biyn palpal korip tap kuyip gok siy diy apiy, gipun kun ak niŋniŋgambay aŋgiy, Gor nup minim paryomb yesek gok nep aŋgniŋbim. Gipim kun ak, yiwur yomb yimb ak nimbip giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nimb low tiysa gok sek, Peresiy gok sek minim yomb yimb mindip rek, nimbip simb niŋsipiyn. Nimb yesek yimb gipim! Biynimb gok minim chinup ak niŋiy kisen giyaŋ aŋgiy, miñmon okok piyow taŋgiy, gunap niŋiy aŋgrep gem, nimb rek mer; Seytan biynimb nuk yipund giy yimb aypay. ");
INSERT INTO kmh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Biynimb gok kuyip Gor kinjeŋ ar ak yomrep gipun apim ak pen; nimb bi windin koy ma niŋbim. Gipim kun ak, minim yomb yimb mindip; nimbip simb niŋsipiyn. Biynimb gok kuyip minim aŋgñiy apim, ‘Gor aŋgniŋep korip mindip rek, niŋind apun aŋgiy minim aŋgay, kisen minim kun ak kirginiŋg kirginiŋgambun. Pen tap gol diy giyak korip miŋgan akyaŋ mindip gok, yimb aŋgyiŋg minim aŋgay, giniŋgambun apim.’ ");
INSERT INTO kmh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nimb bi windin koy yimb. Yesek aŋgiy, ‘Gor aŋgniŋep korip ak tap yimb mer, tap gol diy gipay gok mey tap yimb apim.’ ");
INSERT INTO kmh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Minim bap kunep niŋrep ma giy, biynimb gok kuyip aŋgñiyiŋg apim, ‘Gor kamb bind nuk mindip rek niŋind aspun aŋgiy, minim aŋgay giniŋgambun ak, yikop minim aŋgayniŋgambun; kisen gos bap niŋiy, minim aŋgay aŋgnuk kun ak kirginiŋg kirginiŋgambun. Pen tap Gor nup simboŋgipay gok mindip rek niŋind aspun aŋgiy, kisen gos bap key niŋiy key ginjun rek ma ayniŋgamb; apun rek nep giniŋgambun apim.’ ");
INSERT INTO kmh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nimb biynimb gos timund ma ayak gok. Tap yerip yomb? Tap pik Gor nup simboŋgipay gok yomb akaŋ; kamb bind suŋ-tep nup tap pik simboŋgipay ak yomb? Omiŋal giy tap yomb yimb! ");
INSERT INTO kmh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kamb bind mindip rek niŋind apun aŋgniŋgambun ak; tap daŋgiypay ar kun ak sek aŋgniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pen Gor aŋgniŋep korip mindip rek niŋind apun aŋgniŋgambun ak; korip nuk ak nup sek aŋgniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Semb biyoŋ mindip rek niŋind apun aŋgniŋgambun ak; miñmon nuk ak, nup sek aŋgniŋgambun. Minim kilis kun ak rek aŋgiy, kisen kirgep rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nimb low tiysa gok sek, Peresiy gok sek minim yomb mindip rek, nimbip simb niŋsipiyn. Minim biynimb gunap kuyip aŋgñimbim gok nimb key ma gipim. Sinimb silik, tap monmon woŋgday jakip ak niŋem tap yimb rek ayek, ñin paŋgem wanjrem ak amek, Gor nup nokom bap ñun aŋgiy per opriyŋ ñimbim. Tap sikoy sikoy gok per kun gipim ak pen; yenen minim junj yimb ak kun ma gipim. Biynimb gok kuyip timey ginimuŋ miñ ar ak ma ginimimb; kuyip simb niŋiy yipund ginimuŋ ar ak ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Biynimb gok kuyip kinjeŋ yomun apim ak pen; nimb key biynimb windin koy. Tap achimb gok niŋem tap yimb rek ayip ak pen; tap miseŋ mindip gok ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nimb low tiysa gok sek, Peresiy gok sek minim yomb mindip rek, nimbip simb niŋsipiyn. Piler kap nimb gok rek mis okok ken ñiŋg ayokrep gipim ak pen; namb biyaŋ tap siy tap timey gach ak aranjakiy mindip. ");
INSERT INTO kmh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nimb Peresiy biynimb gok gos timund ma ayak. Piler kap nimb gok miŋgan akyaŋ nind wasyim gi tep gem mey; mis okok ken kunep mind tep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nimb bi low tiysa gok sek, Peresiy gok sek minim yomb mindip rek, nimbip simb niŋsipiyn. Chip kamb miŋgan okok komiy, kinjeŋ giñiy, pen tund ak pikey, biynimb niŋey tep mindip ak pen; miŋgan akyaŋ kuy timey apyiŋg mindip. ");
INSERT INTO kmh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kun ak rek meŋg miŋgan nimb ak mindip. ");
INSERT INTO kmh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Pen nimb bi low tiysa gok sek, Peresiy gok sek minim yomb mindip rek, nimbip simb niŋsipiyn. Nimb bi minim ñiŋg nep pikpim ak, nimbip yiwur yomb yimb giniŋgamb. Bi Gor minim aŋgep wosrey ñaŋgey komyak kaw ar ak, girep giyiŋg apim, ");
INSERT INTO kmh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Apis basind sikop giyak rek, chin kuyip ma ñapnup apim.’ ");
INSERT INTO kmh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pen apim kun ak; bi Gor minim aŋgep gok kuyip pikayiŋgipay kind ak mindpun aŋgiy apim. ");
INSERT INTO kmh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nimb miñ key ar ak ma gipim; kiyk giyak rek gipim. ");
INSERT INTO kmh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Siyŋ saraw rek giraŋg giraŋg, kisen Gor biynimb kor giy, mon key yinjap yokniŋgamb ñin ak, yergiy pirik key okok amniŋgambim? Mer yimb! Kinjeŋ nimb bap ma mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Kun ak nimbip aspiyn: Gor aŋgak, ‘Yand bi Gor minim aŋgep gunap, bi niŋrep gipay gunap, bi tiysa gunap yoken nimbip ker apeniŋgambay, gunap pik ayniŋgambim; gunap mon bak biyoŋ ñaŋgbirikniŋgambim, gunap lotiw korip nimbik miŋgan ak pikniŋgambim, gunap pirik amniyakniŋ, miñmon okok okok yuk yokniŋgambim aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gor aŋgak kun ak rek gipik ak mey; Gor biynimb suŋ-tep nup gok wosrey ñaŋgey wip rek minim yomb ak diniŋgambim. Andam ñinuk Ebol nup nind kiñiŋ gi ñaŋgiy, ñaŋg dand apiy ñaŋg dand apiy, kisen Berekaya ñinuk Sekaraya nup, Gor nup aŋgniŋep korip ak bindoŋ, kamb diy giyak bind ak bindoŋ mindakniŋ, namb siŋak ñaŋgpikayak. ");
INSERT INTO kmh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gipim kun ak, miker yomb ak nimbip Jiwda kay miñiy mindpim gok ker andkind winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem biynimb simb gip yand guniy. Bi Gor minim aŋgep gok kuyip yoken korip miñmon nimbip ak apey, kamb diy pernep pikaypim. Nimbip kakaruk nonim ñiluk gok kuyip gipay rek, dam pil miŋgan yand okok ayniŋg gipiyn ak pen; yip niŋiy kirpim. ");
INSERT INTO kmh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Miñiy Gor yip ma mindeniŋgambim; Gor aŋgniŋep korip nimbik mindip ak pen; keynep mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yip ma yimb niŋniŋgambim; Gor kiyŋ yomb chinup aŋgiy yokip biy, tep yimb yokek wip aŋgniŋgambim ñin anep mey, yip tip ak niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jiysis Gor aŋgniŋep korip ak kirgiy mis amnakniŋ, binuk gok nup aŋgyak, “Gor aŋgniŋep korip tep guniy niŋan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aŋgeyak kuyip aŋgak, “Nimb tap kun gok maŋgiysek niŋiy aspim ak pen; yand nimbip niŋind yimb aspiyn; kisen ap korip kun ak tuŋg waniŋgeniŋgambay, kamb bap kamb bap ar ak ma mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jiysis am Oliyp dum bisiŋg mindakniŋ, binuk gok apiy, nup kapkap aŋgniŋiy aŋgyak, “Gor aŋgniŋep korip tuŋg waniŋgniŋgambay apan ak, minek akay rek kun giniŋgambay? Chin tap yerip ak gek niŋiy aŋgniŋgambun, Jiysis maŋ asaw; miñmon biy maŋgiysek kurginiŋgamb aŋgiy niŋniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aŋgeyak Jiysis aŋgak, “Niŋrep yimb ginimimb. Biynimb gunap nimbip tom giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bi kuŋaynep apiy, biynimb gok kuyip tom giy, yimb yip ak diy yand nep Krays aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maŋ okok penpen gey giw aŋgek niŋniŋgambim; paryomb okok penpen gey minim anep apek niŋniŋgambim. Kun gek niŋiy, ñin kisen ak winiŋg gisap aŋgiy ma piriknimimb. Ak yikop penpen ñaŋgniŋgambay. Ñin kun ak kisen winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Biynimb wikan gunap tikjakiy, biynimb wikan gunap yip penpen giniŋgambay. Miñmon okok maŋgiysek monmon apiy, yiwan yomb sikerek apiy giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kun geniŋgamb nimbip biyn ñapan ñiŋimb rek ak gek, maŋ mindip aŋgiy niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Biynimb yand mindeniŋgambim rek, biynimb miñmon okok maŋgiysek nimbip yiruk niŋiy, dam kalambis ay, gi timey giy, pisnep pik ayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ñin kun ak, biynimb kuŋaynep Gor nup gos ak kirgiy, numiy numam kiyk key gok yiruk niŋiy, di bi ñaŋgep gok ñin ar ak ayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pen kuŋaynep, chin biynimb Gor minim aŋgep aŋgiy, biynimb gok kuyip tom giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Miñ timey ar ak gey gey, biynimb maŋgiysek rek gos ar kun ak niŋiy; wasemb ayep ar ak sakiy giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pen biynimb Gor nup chiŋgiy, wasemb ayiŋg nep mindeniŋgambay gok, dand amek perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pen Gor biynimb diy kond mindeniŋgamb minim tep ak, miñmon okok maŋgiysek aŋgñey amdeniŋgamb nep, ñin kisen kun ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pen bi Gor minim aŋgep Daniyel wosrey aŋgak rek ak giniŋgamb. Nuk aŋgak, ‘Gor aŋgniŋep korip, nup tap simboŋgipay tip siŋak, tap asik timey yimb bap dayeniŋgambay niŋniŋgambim aŋgak.’ Minim kun biy riyt giniŋgambim gok niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nimb Jiwda biynimb, tap timey kun ak niŋiy, kasek pirik yirik okok amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Biynimb korip aryoŋ mindeniŋgiy gok, tap chin gunap dun aŋgiy, andkind korip miŋgan ma amniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Biynimb woŋgday okok taŋgeniŋgiy gok, chech chin gok dun aŋgiy, andkind korip ma amniŋgiy. Kasek pirik amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Biyn ñapan koŋgiy sek mindeniŋgambay gok, biyn ñapan ŋaŋ dand taŋgeniŋgambay gok kosyam yimb amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Giniŋgamb kun ak, Gor nup aŋgniŋey, yombip ñin ak ma ginimuŋ. Lotiw ñin nimb ak ma ginimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yenen, wosrey miñmon alwol gayak ñin ak tikiy, mind dand apiy miñiy mindpun ñin biy, timey kun ak rek ma gak. Kisen kunep timey kun ak rek ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yikop ak per gek, biynimb maŋgiysek kumdipyap. Pen Biyomb ak biynimb nuk diniŋgamb gok kuyip simb niŋiy mer aŋgek mey, per ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ñin kun ak biynimb gunap nimbip Kiyŋ yomb key yimb ak mindip biy, mindip bindoŋ aŋgey, niŋind apay aŋgiy gos ak ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bi gunap Gor biynimb aŋgayak nuk gok kuyip diniŋg yesek aŋgiy yand mey Krays; yand mey bi Gor minim aŋgep ak aŋgiy, tap mageprek gunap giniŋgambay. Kun ak niŋrep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tap yerip yerip kisen giniŋgamb ak, nimbip aŋgñispiyn ak mey; niŋyiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Biynimb gunap Kiyŋ yomb key yimb ak ap mindip miñmon nep namb okok aŋgey, niŋniŋg ma amnimimb. Pen ap weyiŋg mindip akniy aŋgey, niŋind apay aŋgiy ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bi bap Ñinuk winiŋgamb ñin ak, añiñak diy, kasin maŋgiy bol ak, day biym nimb day bineŋ amimb rek ak gakniŋ winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Miñ miŋgan mon miŋgan, kamb miŋgan okok ma kun giniŋgamb; miseŋ nep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pen miker yomb kun ak gi tikdakniŋ, pumb ak kisyim apiy takin ak melik ma giniŋgamb. Gap gok semb biyoŋ nimb puŋgjiw yowniŋgamb. Kun gakniŋ tap semb ar biyoŋ gok, okok nimb okok nimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ñin kun ak, Bi bap Ñinuk winiŋg gakniŋ, semb ar biyoŋ key ayek, biynimb miñmon okok keykey mindpay rek niŋiy, siy aŋgniŋgambay. Nuk Nop kilis ak diy, melik yomb sek, semb sek awakniŋ niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Biykul yomb aŋgakniŋ, enjol nuk gok aŋgek, biynimb nuk diniŋgayn aŋgiy niŋayak gok diniŋg, mankumb biy ayak rek kind kind amiy diy, dand nup ker winiŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nimb niŋbim. Mon gok silup ay wos gakniŋ, pumb ayniŋg gisap aŋgiy niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kun ak rek, kisen tap apiyn gok gakniŋ, “Jiysis winiŋgamb ñin ak miñiy maŋ yimb asaw; won ñap mindiy, apchakniŋgamb aŋgiy niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Biynimb miñiy mindpay gok ma kumniŋgambay, kim mindyakniŋ, tap kun gok maŋgiysek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Semb ar biyoŋ sek, mankumb biy sek kurginiŋgamb; minim yand ak perper mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Won akay rek, ñin akay rek winiŋgayn ak, biynimb ma niŋbay: enjol gok ma niŋbay; yand kunep ma niŋbiyn; Bapiy nuk nep niŋimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Pen andkind winiŋgayn ñin ak, Nowa mindek ñin ak, gi mindyiŋgipay rek nep gi mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa mindek ñin kun ak, ñiŋg ak biynimb gok kuyip ma yiw gak won ak; biyn bi diyiŋg, tap ñimbyiŋg gi mindyakniŋ, Nowa siyip miŋgan ak amek, ñiŋg ap kuyip maŋgiysek yiw gak. ");
INSERT INTO kmh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pen kiyk tap bap giniŋgamb aŋgiy am niŋyak; ñiŋg ak kuyip yiw gakniŋ nep niŋyak. Bi bap Ñinuk winiŋgamb minek ak, kun ak rek nep gi mindyakniŋ, winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ñin kun ak, bi omiŋal woŋgday okok, woŋg gi mindeniŋgayr ak; bap diy, bap kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pen biyn omiŋal palaw giniŋg, wiyt maŋgiy piksimbjakyiŋg gi mindeniŋgayr; bap diy, bap kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kun ak Bi bap Ñinuk winiŋgamb ñin ak ma niŋbim rek, niŋrep giyiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bi korip nop nimb ak bi tap siydep gok asway aŋgiy, niŋmindek, tap nup gok ma siy dipay. ");
INSERT INTO kmh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kun ak rek nimb minj moka giy mindenimimb. Mer ak: Bi bap Ñinuk ma asaw aŋgiy, sakiy sakiy giy mindeniŋgambim ñin ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Biyomb bap kinjeŋ amniŋg giy, bi nup direp giniŋgamb ak nup aŋgniŋgamb, ‘Bi woŋg yip giñimbay gunap kuyip kond mindiy, tap keñmaŋgiy kuyip gok bilok ñirep giyiŋg mindenimin aŋgiy,” aŋgay amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kisen andkind apiy aŋgniŋgamb rek gek niŋiy, nup di tep yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Niŋind yimb aspiyn: nup aŋgek tap nuk gok maŋgiysek kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pen binuk aŋgayniŋgamb ak mind dand amiy mindrep ma giy, biyomb ak miñiy ma winiŋgamb aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","biynimb woŋg giñemb gunap kuyip tapin pikiy, am bi ñiŋg ñimbiy sakiy aypay gok yip wopsakiy, tap yomb ñimb gi mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pen biyomb kasek ma winiŋgamb aŋgiy, monmon gi mindeniŋgamb ñin ak apiy, ");
INSERT INTO kmh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nup gi timey yimb giy, biynimb tap siy tap timey wey weygiy gi mindpay gok yip aŋgayeniŋgamb; am meŋg siwbirikiy, siy aŋgmindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Gor biynimb diy kond mindeniŋgamb ñin kun ak; kesim diniŋg gispiyn biy rek giniŋgamb. Biyomb bap biyn diniŋg gek, tap yomb ñiŋniŋg biyn piñ onep wanjrem ak lam keykey diy dand amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Biyn piñ kun gok, onep mamind ak gos tep niŋniŋgambay; onep mamind ak gos niŋrep ma giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Niŋrep ma giniŋgambay kun gok, lam daŋgiyep wel gunap sek dand ma amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pen biyn piñ gos niŋrep giniŋgambay gok, lam diy, lam daŋgiyep wel gunap botol miŋgan ak paŋgiy, dand amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pen biyn piñ kun gok kiyk maŋgiysek amjakiy, kond mindey mindey, bi biyn diniŋg giniŋgamb ak kasek ma apeniŋgamb mey, wisin apek kinamniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pen kisyimnamb yomb biyaŋ, biynimb gunap suk aŋgiy aŋgniŋgambay, ‘Bi biyn diniŋg gisap ak asaw. Nup am kinjeŋnamb ak niŋiy, poŋind owim aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kun aŋgeniŋgambay, biyn tiwin onep wanjrem kun ak maŋgiysek tikjakiy, lam wiyk kiyk gok girep giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kun giy biyn gos niŋrep ma giniŋgambay tiwin ak, biyn gos niŋrep giniŋgambay tiwin ak kuyip aŋgniŋgambay, ‘Lam chin gok suŋgniŋg gisap ak; wel nimb gok chinup gunap ñim aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aŋgey biyn gos niŋrep giniŋgambay tiwin ak aŋgniŋgambay, ‘Mer! Wel kun gok, nimbip gunap ñiy, chin gunap dinjun rek ma ayip. Nimb stowa amiy, nimbik gok key tawim aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kun aŋgeniŋgambay wel tawniŋg stowa amniŋgambay won ak, bi biyn diniŋg giniŋgamb ak apchakeniŋgamb. Biyn gos niŋrep giniŋgambay tiwin ak, bi kun ak yip korip miŋgan ameniŋgambay; nuk kinjeŋ giñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kisen pen biyn piñ gos niŋrep ma giniŋgambay tiwin ak apchakiy aŋgniŋgambay, ‘Biyomb! Biyomb! Chinup kinjeŋ ak yikan aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aŋgey, biyomb biyn nuk diniŋgamb ñin kun ak aŋgniŋgamb, ‘Yand nimbip ma niŋbiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kun ak nimb Biyomb ak ñin akay akaŋ, won akay winiŋgamb ak ma niŋbim rek, minj moka giy mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Pen kesim diniŋg gispiyn biy rek giniŋgamb. Biyomb bap miñmon paryomb okok amniŋg, bi woŋg nup giñiniŋgambay gok kuyip suk aŋgek apey, tap gok kond mindeyaŋ aŋgiy, kuyip ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","16","Binuk kun gok, woŋg keykey giniŋgambay rek niŋiy, maniy bilokiy, bi bap nup payp tawsin ñiniŋgamb, bap nup tiw tawsin ñiniŋgamb, bap nup wan tawsin ñiniŋgamb. Ñiy, nuk am okok mindakniŋ, bi payp tawsin diniŋgamb ak maniy kun ak diy, sikyim gi dand amiy apiy giy, maniy siyniŋ payp tawsin diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bi tiw tawsin diniŋgamb ak kunep, sikyim gi dand amiy apiy giy, maniy siyniŋ tiw tawsin diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pen bi maniy wan tawsin diniŋgamb ak, dand amiy, kaw tikiy lum ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kisen mind dand amiy, biyomb kiyk ak andkind apiy, maniy ñimbiyn kun ak yerer gipay aŋgiy, kuyip aŋgniŋniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aŋgniŋek, bi payp tawsin diniŋgamb ak, maniy nuk ak ñiy aŋgniŋgamb, ‘Biyomb niŋan! Yip maniy payp tawsin nep ñinak ak pen, yand maniy kun ak di, sikyim gi andik mandik giy, pen payp tawsin siyniŋ dipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aŋgek, biyomb ak pen aŋgniŋgamb, ‘Tep. Nand bi woŋg tep giñimban. Tap sikoy ak kun gipan ak, nip aŋgen tap yomb gok kond mindeniŋgamban. Ap korip yip ak miñmiñ yimb giyiŋg mindenimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Bi maniy tiw tawsin diniŋgamb ak kunep maniy nuk ak dap ñiy aŋgniŋgamb, ‘Biyomb. Yip tiw tawsin nep ñinak ak pen, yand maniy kun ak diy, sikyim gi andik mandik giy, maniy siyniŋ tiw tawsin dipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Aŋgek, biyomb ak aŋgniŋgamb, ‘Tep. Nand bi woŋg tep giñimban ak mey; kun gipan. Tap sikoy ak kun gipan ak, nip aŋgen tap yomb gok kond mindeniŋgamban. Ap korip yip ak miñmiñ yimb giyiŋg mindenimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pen bi maniy wan tawsin diniŋgamb ak dap ñiy aŋgniŋgamb, ‘Biyomb. Yand nip niŋbiyn; nand bi kalrimey yimb. Biynimb nak gunap woŋg wariy kiyk gipay gok nand yikop pipaŋg dapiy ñimban. ");
INSERT INTO kmh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nand kun gipan rek, yand pirikiy, maniy ñinak ak dand amiy, kaw tikiy lum ñen mindyiŋgip ak, miñiy dand aswiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Aŋgek biyomb ak aŋgniŋgamb, ‘Nand bi timey woŋg magep bap. Yand biynimb gunap woŋg gipay gok nep dapiy ñimben niŋban kun ak; ");
INSERT INTO kmh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","yenen maniy yip biy dam pasbuk ayey, miñiy apiy maniy siyniŋ gunap sek ma dipiyn?’ ");
INSERT INTO kmh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kun aŋgiy, binuk gunap kuyip aŋgniŋgamb, ‘Kun gip ak, maniy wan tawsin kun ak jiw diy, bi payp tawsin ñinik ak nup ñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Per apun rek: Biynimb gin yimb gok kuyip gunap sek ñey mindrep giniŋgambay; pen biynimb gin mer gok, kuyip siskoy nind aŋgayak ak piliŋg dey, yikop yimb mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kun ak bi woŋg ma gip kun anup kisyim yomb wip mis ar akyaŋ yokem, biynimb meŋg siwbirikiy, siy aŋgmindpay gok yip siy aŋg mindeŋ aŋgniŋgamb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Bi bap Ñinuk kiyŋ yomb mindiy winiŋgamb ñin ak, enjol gok yip maŋgiysek apiy, nuk siya kiyŋ ar ak bisgek, ");
INSERT INTO kmh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","biynimb miñmon okok keykey mindpay rek, ap windin yirik ar nup siŋak nan-geniŋgambay, kuyip bilok pis ak key, pis ak key ayniŋgamb. Bi kanj siypsiyp meymey mokep gok, siypsiyp gok wikan bap tuŋgasik ay, meymey gok wikan bap key tuŋgasik ay gipay rek ak giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Biynimb siypsiyp rek mindpay gok niŋiy, ñin yipund kind ak ayniŋgamb; biynimb meymey rek mindpay gok niŋiy, ñin aŋind kind ak ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nuk kiyŋ yomb ak mey, biynimb tep gok kuyip aŋgniŋgamb, ‘Bapiy nimbip niŋimb. Wosrey nuk miñmon alwol gayak ñin ak, tip nimbip gayak ak mey, apiy tip tep kun ak dim. ");
INSERT INTO kmh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yenen: yip yiwan gek, tap keñmaŋgiy ñimbim. Ñiŋg nen gek, ñiŋg ñimbim. Miñmon par okok nimb apen, yip aŋgdiy di korip nimbik ak aypim. ");
INSERT INTO kmh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Chech ma mindek, yip chech ak ñimbim. Yip tap gek, niŋmindrep gipim. Kalambis minden, yip ap niŋbim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kun aŋgeniŋgamb, biynimb tep gok nup pen aŋgniŋgambay, ‘Biyomb. ñin akay nip yiwan gek keñmaŋgiy ñimbun? Ñin akay ñiŋg nen gek, nip ñiŋg ñimbun? ");
INSERT INTO kmh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ñin akay par okok nimb apey, nip aŋgdiy dam korip chin ak aypun. Ñin akay chech ak ma mindek, nip chech ñimbun? ");
INSERT INTO kmh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ñin akay tap gek akaŋ, kalambis mindey, nip am niŋbun?’ ");
INSERT INTO kmh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aŋgeniŋgambay, kiyŋ yomb ak aŋgniŋgamb, ‘Mam yip yikop gunap kuyip girep gipim ak mey, yip girep gipim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kuyip kun aŋgiy, biynimb aŋind kind okok ken mindeniŋgambay gok kuyip aŋgniŋgamb, ‘Bapiy Gor Seytan nup sek, Seytan enjol nuk gok sek kuyip yiwur gakniŋ mindeyaŋ aŋgiy, tip mon key yinjap bap gayak. Nimb biynimb timey yiwur yomb diniŋgambim gok, yip kirgiy, mon key yinjap kun ak amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","“Yenen: yip yiwan gek, tap keñmaŋgiy ma ñimbik. Ñiŋg nen gek, ñiŋg ma ñimbik. ");
INSERT INTO kmh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Par okok nimb apen, yip ma aŋgdipik. Chech ma mindek; yip ma ñimbik. Yip tap gak ñin ak akaŋ, kalambis mindenik ñin ak, yip ma ap niŋbik aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aŋgeniŋgamb, nup aŋgniŋgambay, ‘Biyomb. Ñin akay yiwan mindenak nip keñmaŋgiy ma ñinuk? Ñin akay ñiŋg nen gek nip ñiŋg ma ñinuk? Ñin akay okok nimb apey nip ma aŋgdinuk? Ñin akay chech nip ma mindek, nip ma ñinuk? Ñin akay tap gek akaŋ, kalambis mindenak, nip ma am niŋnuk?’ ");
INSERT INTO kmh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Kun aŋgeniŋgambay, kiyŋ ak aŋgniŋgamb, ‘Nimb mam yip yikop gok kuyip direp ma gipik rek mey, yip sek gipik aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kun aŋgiy, kuyip aŋgyokek am tip pernep yiwur gakniŋ mindeniŋgambay ak amniŋgambay. Pen biynimb tep nuk gok aŋgek, perper mindeniŋgambay tip ak amniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jiysis minim kun ak aŋgiy, binuk onep wimiŋgan ak kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nimb niŋbim: ñin omiŋal mindiy, Pasopa ñin yomb ak miñiy aŋgiy, ap nan-giy mindeniŋgambay. Pen kiyk kun giy ap nan-giy, yip di gapman biyomb gok kuyip ñiy aŋgniŋgambay, ‘Nup mon kiros bak biyaŋ ñaŋgbiriknimimb aŋgniŋgambay’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pen bi Gor nup tap simboŋgep yomb gok sek, bi minim tuŋgasikep gok sek ap Gor nup simboŋgep biyomb yimb Kayapas korip ak nan-giy, ");
INSERT INTO kmh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jiysis nup yerer giy, ñaŋgayjun aŋgiy, minim aŋgay geyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pen, “Pasopa ñin biy kun gon, biynimb kuŋaynep ap mindpay gok penpen giniŋgiy rek ayip. Kun ak miñiy kirgiy, ñin bap nup pikayjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jiysis miñmon Beteniy mindiy, Saymon bi soysek korip ak am tap ñimbeyak. Ñiŋyakniŋ, biyn bap wel kuyrep, maniy yomb tawpay ak, botol sek dand apiy, Jiysis nup jun dum ak soŋgak. ");
INSERT INTO kmh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Soŋgek, Jiysis binuk gok simbwur kuyip ak timey gek aŋgyak, “Wel kun ak dand amiy maniy yomb diy, biynimb tap ma mindip gok kuyip ñemb rek ak pen, yenen yikop soŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Minim kun ak aŋgeyak Jiysis niŋiy kuyip aŋgak, “Nuk yip girep yimb gip; yenen kun aspim? ");
INSERT INTO kmh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Biynimb tap ma mindip gok yip per mindeniŋgambim yand yip per ma mindoniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Biynimb komniŋg; wel ayñiy dam kombay rek ak yip ayñisap. ");
INSERT INTO kmh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pen niŋind yimb aspiyn! Kisen miñmon okok maŋgiysek, minim yip ak aŋgñiyiŋg, biyn ak Jiysis nup wel ayñak aŋgiy nup kesim diyiŋg, gak kun ak niŋnep mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ñin kun ak, Jiysis binuk Jiwdas Yiskariyot; Jiysis nup kayn gi dand amen pik ayniŋgiy aŋgiy, Gor nup tap simboŋg ñiyiŋgipay biyomb gok kuyip niŋniŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Amiy aŋgak, “Jiysis nup kayn gi dand apiy nimbip ñeniŋgayn, yip tap yerip ñiniŋgambim?” Aŋgek nup maniy siylpa ñin jiwiy andikiy anep ar ak ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ñeyak Jiwdas pen yerip giy kuyip aŋgen, Jiysis nup ap dand amniŋgiy aŋgiy, gos ak niŋak. ");
INSERT INTO kmh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kisen Pasopa wiyk ak kiñiŋ gi gakniŋ, binuk gok Jiysis mindek ak apiy aŋgyak, “Ñin Pasopa siypsiyp ñiluk pikñiŋniŋgambun ak maŋ mindip. Kun ak chin korip akay amiy tap ñiŋniŋgambun gok gayrep ginjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aŋgeyak kuyip aŋgak, “Nimb dawin yomb ak amiy bi bap nup aŋgniŋiy aŋgnimimb, ‘Tiysa aŋgip ñin yand ak maŋ mindip ak mey, bi yand gok yip siypsiyp ñiluk pik daŋgiy ñiŋniŋgambun korip nund ak aŋgip’ aŋgnimimb.” ");
INSERT INTO kmh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jiysis kun aŋgek binuk gok aŋgak rek niŋiy, am siypsiyp kun ak korip miŋgan kun ak pik daŋgiy gayrep geyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Duŋgep won ak binuk onep wimiŋgan ak yip bisgiy, ");
INSERT INTO kmh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","tap ñimbyiŋg aŋgak, “Yand nimbip niŋind yimb aspiyn. Bi chin yip tap ñimbsipun biy, bap yip kayn gi dand amniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aŋgek binuk gok gos yomb niŋiy, nokom nokom nup aŋgniŋyiŋg aŋgyak, “Biyomb! Yip ma apan rek?” ");
INSERT INTO kmh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aŋgeyak aŋgak, “Bi yand yip piler nokom ñimbsipur ak yip kayn gi dand amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Baybol buk ak wosrey aŋgiy tikyak rek, yip kayn gi dand amiy, pikayey kumniŋgayn ak pen; bi yip kayn gi dand amniŋgamb anup simb niŋsipiyn. Nonim nup ma tikpikop ak tep. Pen tikek, mindyiŋg kun giniŋgamb ak, kisen yiwur yomb yimb ak diniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aŋgek binuk Jiwdas nup kayn giniŋg gak ak aŋgak, “Tiysa. Yip ma apan rek?” Aŋgek aŋgak, “Mey nip aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tap ñimb mindyiŋg Jiysis biret ak diy, Gor nup tep aŋgiy, tipaŋg kuyip ñiyiŋg aŋgak, “Diy ñiŋim. Ak mumbwak yand rek aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kun aŋgiy, ñiŋg wayn kap ak kunep diy, Gor nup tep aŋgiy, kuyip ñiyiŋg aŋgak, “Nimb maŋgiysek ñiŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ñiŋg biy mey, likañ yand biynimb kuŋaynep kuyip nen yowniŋgamb rek nimbip ñispiyn. Likañ yand yowniŋgamb kun ak mey; Gor tap siy tap timey gipay gok niŋiy kirginiŋgayn aŋgak minim ak wos amniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kun aŋgiy aŋgak, “Yand nimbip niŋind aspiyn. Wayn ñiŋg biy miñiy gunap sek ma ñiŋniŋgayn. Kisen Gor biynimb diy kond mindeniŋgamb ñin ak, nimb yip wayn ñiŋg kisenimb ak ñiŋniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kun aŋgiy binuk gok yip lotiw kamep bap aŋgyiŋg, miñmon Oliyp dum amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jiysis kuyip aŋgak, “Gor aŋgak rek Baybol buk ak tikiy aŋgyak: ‘Yand bi kanj siypsiyp mokep ak nup pik ayen, kanj siypsiyp gok maŋgiysek pirik amniŋgambay aŋgyak.’ Aŋgyak kun ak mey, mindak maynamb biyaŋ nimb maŋgiysek yip kirgiy, pirik amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pen yand kumiy tikjakiy, miñmon Galiyliy nind ameniŋgayn; nimb kisen ninimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aŋgek Piyta aŋgak, “Bi maŋgiysek nip kirgiy kund ñiniŋgambay rek ayip; yand kun ma giniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aŋgek Jiysis aŋgak, “Niŋind apiyn: kisyimnamb biyaŋ kakaruk suk ma aŋgniŋgamb won ak, Bi kun anup ma niŋbiyn aŋgiy, won omiŋal nokom aŋgniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aŋgek Piyta kilis timey giy aŋgak, “Yip pikayniŋg pikayniŋgambay ak pen; Jiysis bi yand mer aŋgiy ma aŋgniŋgayn aŋgak.” Jiysis binuk gunap kunep Piyta aŋgak rek nep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jiysis binuk gok yip miñmon Getsemeniy amiy, binuk gunap kuyip aŋgak, “Nimb biy bisiŋg mindenimimb. Yand siŋbindoŋ amiy, Bapiy nup aŋgniŋ mindeniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kun aŋgiy Piyta nup poŋind, Sebediy ñinuk Jemis yip Jon kuyip poŋind saŋdak. Amyiŋg, Jiysis nuk gos yomb niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kuyip yakam aŋgak, “Mindmaŋgiy yip piŋiyñiy nep aysap ak kumnim rek ayip. Biy mindiy, yip kond mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kun aŋgiy, kuyip kun siŋak aŋgay, nuk yep kondoŋ siŋak amiy, jiy kuyaŋgiy, jomluk ak di man biyaŋ ay, Gor nup aŋgniŋiy aŋgak, “Bapiy. Tap yip giniŋg gisap kun ak mer aŋgiy ker, mer aŋgnimin; pen yand gos niŋbiyn ar ak ma ginimin; gos nand key niŋban rek ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kun aŋgiy andkind apiy niŋak: binuk gok kineyak; Piyta nup aŋgak, “Won bap yenen yand yip niŋmindiy ma kinjipim? ");
INSERT INTO kmh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Timey ginjun rek ayip aŋgiy, Gor nup aŋgniŋyiŋg mindenimimb. Gos nimbik ak ginimimb rek ayip ak pen; mumbwak anep mawses gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jiysis kun aŋgiy, tip am Nop nup aŋgniŋiy aŋgak, “Tap yip giniŋg gisap ak, kirgep rek ma mindip monmon gaŋ; gos nak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kun aŋgiy, tip ak andkind apiy niŋak: binuk gok ma niŋmindeyak, wisin kineyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pen nuk andkind amiy, Nop nup nind aŋgniŋak rek nep tip ak aŋgniŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","andkind apiy, binuk gok kuyip aŋgak, “Nimbip mawses gek kin mindpim? Tikjakem amnun. Niŋim! Bi yip mimuŋg niŋimb ak, bi tap siy tap timey gipay gok kuyip ñiyn aŋgiy poŋind asaw biy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Minim aŋgakniŋ, Jiwdas nuk, bi Gor nup simboŋgep yomb gok sek, Jiwda kanjsol gok sek nup aŋgyak rek, bi kiyk kuŋaynep dand owak. Kiyk baynat gunap, kur gunap diy dand sesek wiyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jiwdas kuyip aŋgay aŋgak, “Yand bi bap nup am diy, kaykol ginikniŋ aŋgnimimb; Jiysis mey ak aŋgiy, nup dinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aŋgak rek Jiysis mindek ak apchakiy, mindpan aŋgiy, nup kaykol gak. ");
INSERT INTO kmh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kun gek Jiysis aŋgak, “Buŋgiy. Giniŋg gispan kun ak kasek gan aŋgak.” Aŋgek, bi Jiwdas yip wiyak gok Jiysis nup chichiy diyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pen nup kun giy diyakniŋ, Jiysis binuk bap baynat ak lipiŋg diy, bi Gor nup simboŋgep yomb yimb woŋg giñiyiŋgip anup timund piskind ak pisnep timbrik yokak. ");
INSERT INTO kmh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kun gek Jiysis nup aŋgak, “Ñayip baynat ak dipan okok tip ak liŋgey amnaŋ. Biynimb ñayip baynat diy penpen gipay gok, ar kun ak nep kumbay. ");
INSERT INTO kmh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yand ‘Bapiy ak-ey!’ aŋgembinip, nuk enjol tiwin keykey onep wimiŋgan ak rek yokek, ap yip kond mindembiyap. ");
INSERT INTO kmh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pen wosrey Baybol buk ak tikiy; yip kun kun giy kumniŋgamb aŋgyak ak mey, kun ginimuŋ. Yand ar bap key geniŋgayn yipund ma giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pen bi nup diniŋg wiyak kun gok kuyip aŋgak, “Yand per am Gor aŋgniŋep korip ak bisgiy, biynimb gok kuyip minim aŋgñimbiyn ak pen, yip ma dipim. Miñiy pen baynat sek, kur sek dand apiy, bi tap siydep rek ak yip dipim. ");
INSERT INTO kmh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pen gipim kun ak, bi Gor minim aŋgep gok giniŋgamb aŋgyak rek nep gipim aŋgak.” Won kun ak Jiysis binuk gok maŋgiysek nup kirgiy, pirik amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pen bi low tiysa gok sek, bi Jiwda kanjsol gok sek ap nan-gi mindeyak Kayapas bi Gor nup simboŋgep yomb yimb korip ak mey; Jiysis nup chichiy diy, dand korip kun ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pen Piyta kindik kindik amiy, korip mis ar ak mindiy, Gor aŋgniŋep korip poliys gok yip bisgiy, yerip rek giniŋgambay aŋgiy niŋmindek. ");
INSERT INTO kmh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Bi Gor nup simboŋgep yomb gok sek, bi kanjsol yikop gok sek aŋgyak, “Chin bi minim yesek aŋgniŋgiy gunap kuyip aŋgniŋon, kiyk minim bap aŋgey, yipund giy mindek, minim kiñiŋ mey ak aŋgiy, Jiysis nup pikayjun aŋgyak.” Kun aŋgyak ak pen, minim kun ak keykey amek kiñiŋ niŋiy nup pikayniŋgiy rek bap ma mindek. ");
INSERT INTO kmh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Pen bi omiŋal apiy aŋgrik, “Bi kun biy, ‘Gor aŋgniŋep korip ak timbrikyokem, ñin omiŋal nokom mindiy, tip ak giniŋgayn aŋgak’ aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kun aŋgerik, bi Gor nup simboŋgep yomb yimb ak, Jiysis nup aŋgak, “Minim nip apay ak; pen ma aŋgniŋgamban?” ");
INSERT INTO kmh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aŋgek, Jiysis pen minim bap ma yimb aŋgak. Kun gek, bi Gor nup simboŋgep biyomb yimb ak aŋgak, “Miñiy kor mindpun biy, yesek ma aŋgnimin. Gor Biyomb gek perper mindpay ak kunep niŋmindip. Kun ak chinup yipund giy aŋgnimin. Nand Gor Ñinuk Kiyŋ yomb key yimb ak akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aŋgek Jiysis aŋgak, “Mey apan ak. Nimb maŋgiysek niŋim! Yand nimbip aspiyn: yand Gor ñin yipund kind okok mindiy, semb ar biyoŋ nimb lum biy apeniŋgayn niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jiysis kun aŋgek, bi Gor nup simboŋgep yomb ak, yenen kun aŋgip aŋgiy, chech nuk gok key tuŋgralikyiŋg aŋgak, “Nuk Gor nup yimb ak dand apyapyiŋg asap! Kun ak biynimb gunap ma aŋgniŋjun. Nuk timey gip rek miseŋ aŋgip. ");
INSERT INTO kmh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Akaŋ nimb gos yerip niŋbim?” Aŋgek aŋgyak, “Mey aŋgip ak nen; kumnimuŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kun aŋgiy, nup jomluk okok kiñuk giñiy, pikyiŋg giyak. Gunap weygiy, mikem nup okok piksil giyiŋg aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nand Kiyŋ yomb key yimb tap okok maŋgiysek niŋban ak; an nip piksap ak, chinup aŋgey niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pen Piyta korgep korip mis ar biyaŋ bisiŋg mindek ak mey, bi Gor nup simboŋgep yomb yimb anup woŋg giñiyiŋgip pañ ak apiy, nup aŋgak, “Nand Jiysis bi Galiyliy nimb ak yip mindambiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aŋgek, Piyta biynimb gok maŋgiysek niŋmindyakniŋ aŋgak, “Minim nand aspan ak yand ma niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kun aŋgiy, tikjakiy, am kinjeŋrumb siŋak mindakniŋ, biyn korip kun ak woŋg giyiŋgip bap ap nup niŋiy, bi mindeyak gok kuyip aŋgak, “Nuk bi Jiysis Nasaret nimb ak yip minder niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aŋgek, Piyta aŋg silokiy aŋgak, “Yand niŋind yimb apiyn! Bi apim kun ak yand ma yimb niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sikoy won bap mindiy, bi Piyta yip jak mindeyak gok nup aŋgyak, “Niŋind nep apun. Nand bi kiyk bap. Meŋg miŋgan kiyk apay rek apan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aŋgeyak, Piyta minim kasek aŋgiy aŋgak, “Yand nimbip niŋind yimb apiyn! Bi nimb apim kun ak yand ma yimb niŋbiyn aŋgak.” Kun aŋgakniŋ day kakaruk ak suk aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyta Jiysis minim nup aŋgak ak niŋyiŋg gospar ayak. Yenen: Jiysis aŋgak, “Kakaruk ma aŋgniŋgamb won ak yand nup ma niŋbiyn aŋgiy, won omiŋal nokom aŋgniŋgamban aŋgak.” Gos kun ak niŋiy mey gospar ay, mis amiy siy yomb aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Miñmon yowakniŋ, bi Gor nup simboŋgep yomb gok sek, bi minim tuŋgasikep yikop gok sek minim aŋgniŋ aŋgniŋ giy Jiysis nup pikayun aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","nup miñ ay dand amiy, gapman biyomb Paylat nup ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pen Jiysis nup kor giy, pikayniŋg geyak niŋiy, Jiwdas, yenen Jiysis nup mimuŋg niŋbiyn aŋgiy, maniy dak ak, bi Gor nup simboŋgep yomb gok sek, biyomb yikop gok sek kuyip jiw dam ñiniŋg, Gor aŋgniŋep korip ak amnak. ");
INSERT INTO kmh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Amiy, maniy kun ak kuyip ñiyiŋg aŋgak, “Jiysis timey ma gip ak pen, nup mimuŋg niŋbiyn rek mindak kumniŋgamb aŋgak.” Aŋgek kiyk aŋgyak, “Ak tap chin mer. Nak keynep kun gipan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aŋgeyak, maniy ñiyak ak Gor aŋgniŋep korip miŋgan ak diyokiy, am miñ ñiŋak. ");
INSERT INTO kmh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bi Gor nup simboŋgep yomb gok maniy kun ak diy aŋgyak, “Maniy kun biy, bi pikayun aŋgiy mimuŋg ginuk ak mey, opriyŋ ñinjun rek ma ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kun aŋgiy, minim aŋgniŋ aŋgniŋ giy, bi par okok nimb ap biy kumey dam komjun miñmon wikan bap tawun aŋgiy, am man yiŋgiy siŋgey tiyn giyiŋgipay miñmon wikan ak tawyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tawiy, miñmon wikan kun biy, mimuŋg piŋiy ñimbun maniy ak diy tawnuk ak mey; yimb ‘Likañsek’ aŋgjun aŋgyak. Miñiy kunep miñmon wikan kun ak, yimb ‘Likañsek’ apay. ");
INSERT INTO kmh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pen kiyk mankumb tawyak kun ak, bi Gor minim aŋgep Jeriymaya nind aŋgiy tikak rek nep giyak. Nuk tikiy aŋgak: “Kiyk maniy ñin jiwiy andikiy onep ar ak, Jiwda biynimb mimuŋg piŋiyñinuk maniy ak aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","dand amiy, miñmon man yiŋgiy siŋgey tiyn giyiŋgipay wikan ak tawniŋgambay. Biyomb ak yip giniŋgambay aŋgiy aŋgak rek nep giyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jiysis nup dand gapman biyomb Paylat mindek ak amniyakniŋ, Paylat, Jiysis nup aŋgak, “Nand Jiwda kay kiyŋ yomb kiyk ak mindpan?” Aŋgek Jiysis aŋgak, “Mey apan ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pen bi Gor nup simboŋgep yomb gok sek, bi kanjsol yikop gok sek nup minim gunap aŋgeyak, nuk pen minim bap ma nep aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kun gek, gapman biyomb Paylat aŋgak, “Minim keykey aŋgiy nip kor gispay ak ma niŋban?” ");
INSERT INTO kmh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aŋgek, Jiysis nup minim bap ma aŋgek, Paylat gos kuŋay yimb niŋak. ");
INSERT INTO kmh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Pen Paylat kiyŋ bispay siya ar ak bisiŋg mindakniŋ, biynuk minim bap aŋgek apek aŋgak, “Yand maynamb wisin niŋbiyn: Bi kor gispim ak bi tep. Nup minim yiñ ma aŋgnimin. Yand wisin niŋbiyn kun ak, gos kuŋay niŋsipiyn aŋgak.” Minim kun ak Paylat nuk nep niŋiy aŋgak, Jiysis tap bap ma gak, biyomb guniy nup yikop miluk niŋiy dand opay. Kun ak kinjeŋ yerip ak piyow niŋiy nup aŋgyoken amnaŋ aŋgiy, gos ak niŋak. Pen Rom gapman biyomb gok per simiy ak simiy ak Jiwda kay biret yiys sek ma ñimbay ñin yomb ak, kuyip kalambis bi bap key aŋgniŋyiŋgipay ak, yikop wisik yokyiŋgip. Ñin kun ak, Jiwda kay bi kiyk niŋrep giyiŋgipay bap ap kalambis mindek. Yimb nuk ak Barabas. Kun ak biynimb kuŋaynep ap nan-geyak Paylat aŋgak, “Bi nimbip akay yikop aŋgyoknim? Jiysis, Kiyŋ yomb key yimb apay ak akaŋ, Barabas nup aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aŋgek bi Gor nup tap simboŋgep yomb gok sek, bi kanjsol yikop gok sek biynimb gok kuyip aŋgyak, “Gapman biyomb Paylat nup aŋgenimimb, Barabas nup wisik yokiy, Jiysis nup mon kiros bak biyoŋ ñaŋgbirik ayniŋgiy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kun ak kisen gapman biyomb ak kuyip aŋgak, “Bi omiŋal biy, an nup rek nimbip wisik yoknim?” Aŋgek aŋgyak, “Barabas nup wisik yoknimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aŋgeyak Paylat aŋgak, “Kun apim ak, Jiysis Kiyŋ yomb key yimb apay ak nup yerginim?” Aŋgek, kiyk maŋgiysek aŋgyak, “Nup mon bak biyoŋ ñaŋgbiriknimimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aŋgeyak gapman biyomb Paylat aŋgak, “Yenen? Nuk tap yerip ak timey gak?” Pen minim aŋgak ak ma niŋiy, minim dand araniy aŋgyak, “Nup mon kiros bak biyoŋ ñaŋgrimbik aynimimb! Nup mon kiros bak biyoŋ ñaŋgrimbik aynimimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aŋgeyak minim gunap sek aŋgen penpen giniŋgiy rek ayip aŋgiy, Paylat ñiŋg diy ñin ayokyiŋg kuyip aŋgak, “Jiysis nup pikayniŋg gispim ak, minim kun ak yip ma winiŋgamb; nimbip key andkind winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aŋgek aŋgyak, “Ak chip nambinj chin key. Minim kun ak, chin sek, ñapan chin gok sek niŋniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kun aŋgeyak, Paylat kuyip Barabas nup wisik yokiy, Jiysis nup miñ diy pikiy, mon kiros bak biyoŋ ñaŋgbirik ayaŋ aŋgiy, amiybi gok kuyip yomak. ");
INSERT INTO kmh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Amiybi yomb gok nup diy, dand korip yomb kiyk ak amiy, amiybi yikop gok kuyip maŋgiysek suk aŋgey, ");
INSERT INTO kmh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ap nan-giy, chech nup ak tuŋgjiwiy chech likañ biyomb yimbay rek bap dand apiy nup yimñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yimñiy miñ ñiwñiw sek gok dand apiy, kiyŋ kay aypay arband rek bap giy, nup ayñiyiŋg, biyomb gok kur kunep dipay aŋgiy, gamil par bap di Jiysis nup ñin yipund kind ak ñiy, ap nup koŋgim yimiy, aŋgjiwyiŋg aŋgyak, “Jiwda kiyŋ kiyk biy per mindonimuŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kun aŋgiy, nup kiñuk giy, gamil kur kun ak jiw diy, nup jun dum biyoŋ pikyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nup kun giy gi timey giy, chech likañ ayñiyak ak tuŋgasikyokiy, chech nuk gok key ayñiy, nup mon kiros bak biyoŋ ñaŋgbirik ayniŋg, poŋind amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kinjeŋnamb okok dand amyiŋg niŋyak, bi bap Sayriyniy nimb apek. Yimb nuk ak Saymon. Nup namb pikiy, kilis giy aŋgyak, “Jiysis nup ñaŋgbirik ayniŋgambun mon kiros biy dand amnoŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aŋgey dakniŋ, miñmon Golgota dum amniyak. Golgota kun ak, chip jun dum apay. ");
INSERT INTO kmh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pen dum kun ak amjakiy, amiybi gok malasin silik bap diy, wayn ñiŋg ak diy, sesek tuŋgandik mandik giy, Jiysis nup ñeyak, nuk ñimb niŋiy kirgak. ");
INSERT INTO kmh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nup mon kiros bak biyoŋ ñaŋgbirik ay, chech nup gok bilok keykey diniŋg, sandiw rek giy diyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Diy mey, nup mon ñaŋgbirikyak kiñiŋ siŋak bisgiy niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nup ñaŋgbirikiy, kiros bak biyoŋ yimb tikay aŋgyak, “Jiwda kay Kiyŋ yomb kiyk ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pen Jiysis nup ñaŋgbirik ay, bi tap siydep omiŋal ak, bap ñin yipund pis ak, bap aŋind pis ak, ñaŋgbirik ayak. ");
INSERT INTO kmh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Biynimb kinjeŋram aran apyan geyak gok, jun gormar giy, nup aŋgjiwiy aŋgyak, “Nand Gor Ñinuk rek! Gor aŋgniŋep korip ak timbrikyokiy, ñin omiŋal nokom mindiy tip ak gi diniŋgamban ak mey; mon kiros bak biyoŋ kirgiy apey chin niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bi Gor nup simboŋgep yomb gok, bi low tiysa gok, bi kanjsol yikop gok sek kunep; nup aŋgjiwiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Biynimb gunap kuyip gamb kim ambay ak pen, nuk key kun ginimuŋ rek ma ayip. Yisrel, Kiyŋ yomb chin ak, mon kiros bak biyoŋ kirgiy man ar biy apey, niŋind aŋgip aŋgiy niŋjun. ");
INSERT INTO kmh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nuk Gor nup gosimb niŋiy, yand Gor Ñinuk aŋgip ak, miñiy ap Ñinuk nup diyokek chin niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bi tap siydep Jiysis yip ñaŋgrimbikyak omiŋal ak kunep, nup minim timey kun ak rek nep aŋgrik. ");
INSERT INTO kmh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ñin kun ak pumbnamb yomb yoŋ won ak, kisyim apiy mind dand amiy pumb kuyim gak won ak tip ak melik gak. ");
INSERT INTO kmh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Won kun ak Jiysis suk yomb aŋgiy aŋgak, “Yilay. Yilay, lema sambaktaniy aŋgak.” Aŋgak kun ak, “Gor Bapiy yomb. Gor Bapiy yomb. Yip yenen kirpan aŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nuk kun giy suk yomb aŋgek, biynimb gunap maŋ kun siŋak mindeyak gok niŋiy aŋgyak, “Bi kun biy bi Gor minim aŋgep Yilayja nup suk asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kun aŋgiy, bi bap am tap machres rek ayak band bap dand apiy, ñiŋg wayn silik ak tawiy, gamil kur par ak diy, kambis ñaŋgiy, ñen ñiŋaŋ aŋgiy ñak. ");
INSERT INTO kmh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kun giy ñek, bi gunap aŋgyak, “Kapkap niŋmindon. Bi Yilayja apiy, nup diyokniŋgamb akaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aŋgiy, niŋmindyakniŋ, Jiysis suk yomb aŋgiy, añiŋ band mindek ak kurgak. ");
INSERT INTO kmh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Won kun anep, chech paryomb Gor aŋgniŋep korip ñiluk miŋgan biyaŋ kinjeŋrumb pilgiyak ak, namb ak puŋgrik biyoŋ biyaŋ ay mindek. Kun gakniŋ, monmon diy, kamb gok puŋglakiy, ");
INSERT INTO kmh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","chip komyak kamb miŋgan pilgiyak gok miŋgan yikiy, Gor biynimb nuk nind kumey komyak gok kuŋaynep gek, tip ak tikjakyak ak mey; ");
INSERT INTO kmh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jiysis tikjakak ñin ak Jerusalem ameyak, biynimb kuŋaynep niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pen monmon diy, yerer gak ak niŋiy amiybi yomb ak sek, binuk gok sek niŋiy aŋgyak, “Yaw-ey! Nuk Gor Ñinuk yimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pen biyn kuŋaynep ap keykey siŋak mindiy niŋmindeyak. Biyn kun gok Jiysis nup kondiy, Galiyliy nimb wiyak. ");
INSERT INTO kmh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Biyn mindeyak kun gok bap Mariya Makdala; bap Jemis yip Josep yip nonim Mariya; bap Sebediy ñinuk omiŋal nonim ak. ");
INSERT INTO kmh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Bi tap kuŋay mindek miñmon Armatiya nimb bap Jiysis kumek niŋiy, duŋgep won ak ap gapman biyomb Paylat nup Jiysis mumbwak ak dinim akaŋ aŋgek, Paylat yaw aŋgiy, binuk gok kuyip aŋgek, nup ñiyak. Bi kun ak yimb nuk Josep. Nuk Jiysis binuk bap. ");
INSERT INTO kmh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep nup Jiysis mumbwak ak ñiyakniŋ, nuk chech tund tep ak diy, nup maŋgiysek pipkomiy, ");
INSERT INTO kmh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","dam kamb miŋgan kisen nep, yip komniŋgambay aŋgiy aŋgek kiluk ayak miŋgan ak komiy, kamb yomb bap tuŋg milokek amek, kamb miŋgan ak pilgiy amnak. ");
INSERT INTO kmh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Biyn yimb aloŋg Mariya omiŋal ak ap niŋmindrikniŋ, kun giy komak. ");
INSERT INTO kmh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jiysis kumek komyak ñin kun ak, bi Gor nup simboŋgep yomb gok sek, Peresiy gok sek lotiw ñin ak toy aŋgiy, tap dap nan-giyak. Minek, gapman biyomb Paylat mindek ak amiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Biyomb. Bi yesek aŋgep kun ak aŋgak, ‘Yand kumiy, ñin omiŋal nokom mindiy tikjakniŋgayn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kun ak bi gunap aŋgey, ñin omiŋal nokom kawrumb ak kond mindeniŋgiy. Mer ak binuk gok ap mumbwak nup ak siy dand amiy, biynimb okok kuyip yesek aŋgiy aŋgniŋgambay, ‘Nuk tip ak tikjakip aŋgniŋgambay.’ Kun gey, minim yesek aŋgyiŋgipay ak sikoy rek ayniŋgamb, kisen aŋgniŋgambay ak yomb yimb giniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aŋgeyak Paylat kuyip aŋgak, “Kun ak nimb amiybi kaw bap aŋgrep gem, am kun siŋak niŋmindeniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aŋgek am kinjeŋ pilgiyak kamb yomb ak wiren rek giy, amiybi kaw bap aŋgeyak am kun siŋak niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Minek miñmon tikdam yokakniŋ, biyn yimb aloŋg Mariya omiŋal ak, Jiysis nup komyak ak niŋniŋg amnirik. ");
INSERT INTO kmh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Won kun ak enjol bap semb biyoŋ nimb apiy, Jiysis nup komiy kamb pilgiyak ak, tuŋgmilok gol okok yokiy, ar kun ak bisgakniŋ, monmon yomb yimb ak owak. ");
INSERT INTO kmh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enjol kamb ar bisiŋg mindek kun ak, jomluk nuk ak ñiñakol giyiŋg mindek. Chech nuk ak, tund tep yimb ak ayak. ");
INSERT INTO kmh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pen amiybi niŋmindeyak gok, nup niŋiy jel pirikiy, kin ambun tikiy mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pen enjol ak biyn omiŋal ak kuyip aŋgak, “Ma piriknimiyr! Yand niŋbiyn: nirmiŋay Jiysis bi mon kiros bak biyoŋ ñaŋgbirik ayak anup niŋraspiyr. ");
INSERT INTO kmh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nuk biy ma mindip. Nind aŋgak rek mindarik tip tikjakiy amimb. Apiy nup dayak ar ak niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","am binuk gok kuyip aŋgnimiyr, ‘Tip tikjakiy Galiyliy amimb aŋgnimiyr.’ Nimb biynimb nuk gok, nup niŋniŋgambim kun okok. Minim kun ak nep nimbip aŋgñiniŋg aswiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kun aŋgek niŋiy, biyn omiŋal ak pirikrik ak pen; miñmiñ giyiŋg, binuk gok kuyip minim kun ak aŋgniŋg kasek amnirik. ");
INSERT INTO kmh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kinjeŋnamb okok amnirikniŋ, Jiysis kuyipmiŋay namb pikiy, “Nir mindpiyr aŋgak.” Aŋgek, kiymiŋay ap koŋgim yimiy, nup diniŋiy lotiw gerik, ");
INSERT INTO kmh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","kuyipmiŋay aŋgak, “Ma piriknimiyr! Yand Galiyliy amjipiyn ak; nir am mam yand gok kuyip aŋgnimiyr, ‘Nup am niŋnimimb miñmon Galiyliy aŋgnimiyr’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Biyn omiŋal ak, kinjeŋnamb okok amnirikniŋ, amiybi niŋmindeyak gok, dawin yomb Jerusalem amiy, bi Gor nup simboŋgep yomb gok kuyip, Jiysis tikjakak minim ak aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aŋgñeyak, bi Gor nup simboŋgep yomb gok, am bi kanjsol gunap yip, minim aŋg ar nokom ay apiy, amiybi kun gok kuyip maniy yomb ñiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Jiysis kun kun giy tikjakip aŋgiy ma aŋgnimimb. Pen aŋgnimimb, ‘Chin kinambun won ak binuk gok apiy, mumbwak nup ak siy dand ambay aŋgnimimb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kun gey, gapman biyomb ak minim kun ak niŋiy aŋgek, chin yip aŋgoniŋgambun; nimbip miker gunap ma ñiniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kun aŋgey, amiybi gok maniy kun ak diy, am biyomb kun gok aŋgyak rek nep aŋgyak. Kiyk tom giy, Jiysis mumbwak nup ak, binuk gok siy dand ambay aŋgeyak, miñiy Jiwda biynimb gok minim kun ak aŋgyiŋg mindpay. ");
INSERT INTO kmh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jiysis binuk onep aŋgip ak Galiyliy amiy, kuyip nind aŋgak dum ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amiy Jiysis nup niŋiy, lotiw giyak. Pen gunap niŋsindol giy aŋgyak, “Ak Jiysis akaŋ bi ak key aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jiysis maŋ siŋak apiy, kuyip aŋgak, “Bapiy yip aŋgek mey, man ar biy kond mindiy, semb biyoŋ kond mindiy gipiyn. ");
INSERT INTO kmh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kun ak nimb miñmon okok kind kind amiy, biynimb gok yip ker dinimimb. Diy, Bapiy Gor ker mindpay, Ñinuk ker mindpay, Kawnan nuk ak ker mindpay aŋgiy, kuyip ñiŋg pikñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pikñiy, yand nimbip ginimimb aŋgiy minim yerip yerip aŋgñimbiyn ak maŋgiysek, kuyip aŋgñirep gem niŋiy kindik giniŋgiy. Pen yand nimb yip nep mindiy, mind dand amiy, ñin kisen ak winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jiysis Krays, Gor Ñinuk minim tep ak aŋgniŋg gispiyn. ");
INSERT INTO kmh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wosrey, bi Gor minim aŋgep Asaya, Gor Ñinuk Jiysis Krays nup minim aŋgak rek, tikiy aŋgak: “Niŋan! Bi minim yand dand amniŋgamb ak nind aŋgyoken am, kinjeŋ nip ak pindrep geniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bi kun ak miñmon biynimb kuŋay ma mindpay namb okok suk aŋgiy aŋgniŋgamb, ‘Biyomb ak asaw! Kinjeŋ yik mayik giy mindonimuŋ gok pind yipund yimb giy mindenimimb aŋgniŋgamb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gor kun aŋgek mey, kisen Jon bi ñiŋg pikñemb ak, miñmon biynimb kuŋay ma mindeyak namb okok mindyiŋg, biynimb gok apey kuyip minim aŋgñiy aŋgyiŋgip, “Tap siy tap timey gipun gok, yenen kun gipun aŋgiy kirgiy, ñiŋg pikem mey, Gor tap siy tap timey gipim gach ak wiykyokniŋgamb aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nuk kun aŋgakniŋ, biynimb Jiwdiya propens yep kun okok mindeyak gok sek, Jerusalem biynimb sek minim nup ak niŋniŋg amniyak. Amiy, tap yerip yerip timey giyak gok miseŋ aŋgñey, kuyip Joden ñiŋg namb ak ñiŋg pikñak. ");
INSERT INTO kmh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon chech yikop kanj kamel kas diy giyak ak ay, kaw wak ler ak namb ak poŋgayiŋgip. Tap ñiŋemb nuk ak, joŋ golbind ak sek, bum ñiŋg ak sek ñimbyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nuk biynimb gok kuyip aŋgyiŋgip, “Bi kisen winiŋgamb ak Biyomb yimb, yand bi sikoy; nup niŋen yip nambiŋ gip. Tomb tirup nup ak tuŋgasikyiŋg, tap nup gok marik ginim rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yand nimbip yikop ñiŋg pikñimbiyn; nuk apiy nimbip Gor Kawnan ak yokniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pen ñin bap, Jiysis miñmon Nasaret Galiyliy propens mindyiŋgip ak kirgiy, Jon mindek ak apek, nup Joden ñiŋg namb ak ñiŋg pikñak. Nup kun giy ñiŋg pikñek, ");
INSERT INTO kmh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jiysis kumb biyoŋ amnakniŋ; semb biyoŋ miŋgan yikiy, Gor Kawnan ak yakir kochir rek, wiŋind nup ker owak. ");
INSERT INTO kmh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kun giy owakniŋ, minim bap semb biyoŋ nimb apiy aŋgak, “Nand Ñi mapin yand yimb. Nip niŋen, yip tep yimb gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pen won kun anep, Gor Kawnan ak Jiysis nup gek, miñmon nep namb okok amiy; ");
INSERT INTO kmh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ñin onep ñin jiwiy andikiy ar piskind ak mindyiŋgip. Kun okok mindakniŋ, Seytan, Jiysis nup gen minim yip ak kindik giy timey gaŋ aŋgiy, ap aŋgyiŋgip. Miñmon mindyiŋgip wikan kun ak kayn ayndik tap gok nep mindyiŋgip. Pen enjol gok, ap Jiysis nup bak ay kond mindyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pen Gapman biyomb Herot Jon nup kalambis ayakniŋ, Jiysis nuk miñmon Galiyliy amiy, Gor minim tep ak biynimb gok kuyip aŋgñiyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Gor chinup diy kond mindeniŋgamb aŋgiy ñin per kond mindyiŋgipim ak, miñiy wip! Tap siy tap timey gipim ak, yenen kun gipun aŋgiy kirgiy, Gor biynimb simb niŋiy diniŋgamb minim tep ak, niŋind aŋgip aŋgiy dinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jiysis Galiyliy chemb gol ak pandikyiŋg niŋak; bi piysdep mamiymiŋay ak piys dur aŋgiy, wimben ak di ñiŋg namb biyaŋ yokiy minderik. Bi mamiymiŋay kun ak yimb kiykmiŋay ak, Saymon yip, Enjriw yip. ");
INSERT INTO kmh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kuyipmiŋay niŋiy aŋgak “Aper yand yip taŋgiy, nirip aŋgñirep gen, bi biynimb dep omiŋal ak mindeniŋgayr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aŋgek niŋind aŋgip aŋgiy, wimben gok kirgiy, Jiysis yip nep taŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pen Jiysis tapin sikoy won bap amiy niŋak: Sebediy ñinuk Jemis yip, Jon yip bot miŋgan ak mindyiŋg, wimben puŋgrikak ak kopis kopis gi minderik. ");
INSERT INTO kmh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kuyipmiŋay niŋiy aŋgak, “Nirmiŋay owiyr-ey aŋgak.” Aŋgek kiykmiŋay niŋiy, nop nup bi gunap yip bot ar ak kirgiy, Jiysis yip amiy taŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pen kiyk miñmon yomb Kapaniyam amiy, Jiysis Jiwda lotiw minek ak; nan-gep korip miŋgan biyaŋ amiy, Gor minim ak aŋgñek; ");
INSERT INTO kmh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","biynimb gok niŋiy jiwdiy aŋgyak, “Bi low tiysa apay rek ma aŋgip, biyomb yimb niŋrep giy apay rek aŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pen won kun ak, bi kichekiy ambaŋ ayak bap, korip miŋgan kun ak mindek ak suk aŋgiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jiysis bi Nasaret nimb! Nand yerginiŋg opan? Chinup gi timey giniŋg opan rek ayip? Pen Gor ñin chinup aŋgayak ak ma wip. Yand nip niŋbiyn: timey ma gipan; Gor Ñi tep nuk ak mindpan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aŋgek, Jiysis kichekiy anup aŋgak, “Minim ma aŋgnimin! Bi anup kirgiy mis amnoŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aŋgek, bi anup gek jep diy, suk yomb aŋgakniŋ, mis amnak. ");
INSERT INTO kmh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kun gek niŋiy, biynimb ap mindeyak gok wal yimb aŋgiy, minim aŋgniŋ aŋgniŋ giy aŋgyak, “Bi biy minim kisenimb ar bap dand wip rek ayip. Nuk bi kilis sek; kichekiy malñiluk gok aŋgip rek niŋiy mis ambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kun aŋgiy, Jiysis kichekiy malñiluk aŋgyokak minim kun ak, Galiyliy Propens okok maŋgiysek aŋgñey amnak. ");
INSERT INTO kmh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pen Jiysis, Jemis, Jon, Saymon, Enjriw kiyk Jiwda nan-gep korip ak kirgiy, mis apiy, Saymon yip numam Enjriw yip korip ak amniŋg saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Korip amjakiy Jiysis nup aŋgyak, “Saymon numok nup, mumbwak okok mon rek yinek, kin mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aŋgeyak, Jiysis am nup di jakñakniŋ, wak mon rek yinek ak suŋ ayakniŋ, day tap keñmaŋgiy kuyip gok daŋgiyak. ");
INSERT INTO kmh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pen pumb saŋind amnak won ak, biynimb tap gak gok yip, kichekiy ambaŋ ayak gok yip Jiysis gek suŋ ayaŋ aŋgiy, mindek ak dand wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kapaniyam biynimb gok, ap kinjeŋrumb mis akyaŋ ken niŋmindyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","biynimb tap gak gok gek suŋ ay, kichekiy malñiluk ambaŋ ayak gok aŋg mis yokiy gak. Pen kichekiy malñiluk kun gok Jiysis nup niŋrep giyak rek, Gor Ñinuk ap mindip biy aŋgiy miseŋ aŋgniŋg geyak, kuyip minim ma aŋgnimimb aŋgiy, aŋg mis yokak. ");
INSERT INTO kmh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Minek, Jiysis maynamb yimb tikjakiy, dawin kun ak kirgiy wikan bap key amiy, Nop nup aŋgniŋ mindek. ");
INSERT INTO kmh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pen binuk Saymon; binuk gunap yip Jiysis akay aŋgiy, piyow dand amiy, ");
INSERT INTO kmh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","nup niŋiy aŋgyak, “Biynimb maŋgiysek nip akay aŋgiy piyowsipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kun aŋgeyak, Jiysis aŋgak, “Miñmon wikan bap nep aŋgñiyn aŋgiy ma winik; miñmon gunap kunep aŋgñiyn aŋgiy winik rek nem amnun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kun aŋgiy, miñmon Galiyliy namb okok giraŋgyiŋg, am Jiwda nan-gep korip miŋgan gok amiy, Gor minim aŋgñiyiŋg, biynimb kichekiy malñiluk ambaŋ ayak gok Jiysis kichekiy malñiluk gok aŋgek mis amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bi soy ayndik ayak bap Jiysis mindek siŋak apiy, koŋgim yimiy aŋgak, “Nand soy yip ak gey suŋ ayniŋg; gey suŋ aynimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kun aŋgek, Jiysis nup simb niŋiy aŋgak, “Nip gen suŋ ayniŋgamb aŋgiy,” ");
INSERT INTO kmh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","diniŋakniŋ suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pen nup minim kilis aŋgiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kinjeŋnamb okok amyiŋg, biynimb gunap kuyip Jiysis yip gek suŋ ayip aŋgiy ma aŋgnimin. Yipund giy nep am bi Gor nup simboŋgep anup yomiy, soy ayndik yip ak suŋ ayip aŋgiy, Mosis nind aŋgak rek tap gunap pikiy, dam Gor nup simboŋg ñenimin mey; biynimb gok bi ak miñiy suŋ ayip aŋgiy niŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kun aŋgak ak pen; bi kun ak nuk amiy, biynimb okok monmon aŋgñek mey, Jiysis miñmon okok miseŋ giraŋgonimuŋ rek ma ayek, nuk am biynimb kuŋay ma mindeyak namb okok mindakniŋ, biynimb miñmon kind kind nup niŋniŋg apyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Kisen pen Jiysis tip ak miñmon Kapaniyam apek, ap mindip korip ak aŋgey niŋiy, biynimb kuŋaynep ap gey gey, korip miŋgan, kinjeŋrumb mis ar akyaŋ timbik giy yimb aŋgak. Kun gek, Jiysis korip miŋgan akyaŋ nep mindyiŋg, minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kuyip Gor minim aŋgñi mindakniŋ, bi onep tiŋgawip ak, bi ñin tomb kalaw gak bap, yirar ay dand apiy niŋyak: ");
INSERT INTO kmh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","tip ak timbik giy yimb aŋgek, bi ñin tomb kalaw gak anup dand korip ar biyoŋ amiy, korip ak tuŋgyikiy, yokey Jiysis mindek biyaŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pen nuk gek suŋ ayniŋgamb aŋgiy niŋyak rek, Jiysis aŋgak, “Ñi yand. Tap siy tap timey gipan gach ak wiykyoksipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kun aŋgek, Jiwda low tiysa gunap bisiŋg mindeyak gok gos kiyk okok nep niŋiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bi biy yenen Gor nup aŋg sikoy giyiŋg, ap tom gisap? Biynimb gok tap siy tap timey gey, bi bap gach kuyip ak wiykyoknimuŋ rek ma ayip; Gor nep mey, gach wiykyokniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pen Jiysis gos niŋyak kun ak key niŋiy aŋgak, “Yenen gos kun ak rek kun giy niŋbim? ");
INSERT INTO kmh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bi ñin tomb kalaw gip anup yerip aŋgen, nimbip tep giniŋgamb? Tap siy tap timey gipan gach ak wiykyoksipiyn aŋgen nimbip tep giniŋgamb akaŋ; tikjakiy minj nak ak winiŋg dand amnoŋ aŋgen, nimbip tep giniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yand nimbip aspiyn: Bi bap Ñinuk man ar biy awak ak, key niŋiy ma awak, Gor aŋgek awak ak mey; nuk tap siy tap timey gipay ak niŋiy kirginiŋg, kirginiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kun aŋgiy, bi ñin tomb kalaw gak anup aŋgak, “Yand nip aspiyn: tikjakiy, minj band nak ak dand korip amnoŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aŋgek, won kun anep tikjakiy, minj band nuk ak dand saŋdak. Kun gek niŋiy, biynimb gok wal yimb aŋgiy, Gor nup yimb ak dand aranyiŋg aŋgyak, “Nind tap kun ak rek bap gey, ma niŋnuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiysis ñin bap tip ak andkind Galiyliy chemb gol okok amek, biynimb kuŋaynep nup niŋiy ap nan-geyak, kuyip Gor minim tep ak aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kun giy aŋgñi diy; kinjeŋnamb okok amyiŋg niŋak; Alpiyas ñinuk Liypay, bi takes dep ak, woŋg giyiŋgip korip miŋgan ak bisiŋg mindek. Nup niŋiy, “Apey yand yip taŋgor aŋgek,” tikjakiy yip taŋgyiŋgipiyr. ");
INSERT INTO kmh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jiysis pen, binuk gok yip am Liypay korip ak tap ñiŋyakniŋ, bi takes dep gok sek, bi tap siy tap timey giyak gok sek Jiysis yip taŋgeyak rek, yip jimñiy tap ñiŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bi Peresiy low tiysa mindeyak gunap, Jiysis binuk gok kuyip aŋgyak, “Jiysis yenen bi takes dipay gok yip, tap timey gipay gok yip tap ñiŋimb?” ");
INSERT INTO kmh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aŋgeyak, Jiysis minim kun ak key niŋiy aŋgak, “Biynimb suŋ gok, dokta niŋniŋg ma ambay; biynimb tap gip gok nep niŋniŋg ambay. Bi bap Ñinuk biynimb suŋ-tep mindpun aŋgiy niŋbay gok kuyip, di Nop yip jimñiniŋg ma awak; biynimb tap siy tap timey gipun aŋgiy niŋbay gok kuyip, di Nop yip jimñiniŋg awak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Peresiy kay bi kiyk gok sek, Jon binuk gok sek ñin gunap lotiw nep mindonjun aŋgiy, tap ma ñimbyiŋgipay ak mey, biynimb gunap apiy Jiysis nup aŋgyak, “Peresiy kay bi kiyk gok sek, Jon binuk gok sek ñin nokom nokom tap ma ñimbay. Pen binak gok, yenen kun ma gipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aŋgeyak, Jiysis miñ giyiŋgipay ar kun ak ma giniŋgambun aŋgiy, paydoŋ ay aŋgak, “Bi biyn diniŋg giniŋgamb bap, numiy numam gok yip mindiy, tep gakniŋ mindeniŋgambay ak mey, tap keñmaŋgiy ma kirginiŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pen kisen biynimb gunap bi kiyk kun anup dand ameniŋgambay, simb gek, ñin kun ak tap ma ñiŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pen chech kisenimb band bap diy, chech wor ay puŋgrikniŋgamb tam ak ñaŋg dey; chech kisenimb ak kilis mindyiŋg, chech wor ayniŋgamb band ak puŋgrikiy, chech kiyk ak takiy nep puŋgrikek amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ñiŋg wayn ak kunep. Ñiŋg wayn kimnimb ak diy, meymey wak nindnimb miŋgan ak ma soŋg aypay. Yenen: soŋg ay simjen ñey; meymey wak ak biŋ aŋgiy, puŋgrikiy soŋg am diniŋgamb. Kun ak mey, ñiŋg wayn kimnimb ak, meymey wak kimnimb miŋgan ak nep soŋg ayep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kisen Jiwda lotiw ñin bap, Jiysis binuk gok yip wiyt woŋg namb ak amyiŋg, binuk gok wiyt maŋgiy gunap tikiy, wak pik yokiy ñimbyiŋg ameyak. ");
INSERT INTO kmh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kun gey, Peresiy bi gok niŋiy, Jiysis nup aŋgyak, “Miñiy lotiw ñin chin woŋg magep ak, binak gok yenen wiyt maŋgiy tik wak pikyokiy ñimbsipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aŋgeyak, Jiysis aŋgak, “Basind Depiyt wosrey yiwan gek gak kesim tikyak ak, ma niŋbim? ");
INSERT INTO kmh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wosrey binak Abayra bi Gor nup simboŋgep yomb yimb mindyiŋgip ñin ak, Depiyt binuk gok yip kuyip yiwan gek, Gor aŋgniŋep korip ak amiy, biret biynimb yikop gok ma ñimbay; bi Gor nup simboŋgep gok nep ñimbay ak aŋgniŋey, ñek ñiŋyak ak pen, Depiyt timey gak aŋgiy ma apun. Yiwan gek gak apun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kun aŋgiy aŋgak, “Ñin bap yikop mindep minim ak nind aŋgiy, kisen biynimb gok ma gayak; kuyip gay añiŋ ay mindrep giyaŋ aŋgiy, ñin bap yikop mindeniŋgiy aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pen Nop aŋgek, “Bi bap Ñinuk tap okok kond mindiy, lotiw ñin ak kunep kond mindiy gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ñin bap pen, Jiysis tip ak andkind Jiwda nan-gep korip ak amiy niŋak: bi ñin kalaw gak bap korip miŋgan kun ak ap mindek. ");
INSERT INTO kmh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bi Peresiy gok Jiysis yerip rek gek, Jiwda kanjsol miytiyŋ giy nup kor ginjun aŋgiy, kapkap niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jiysis bi ñin kalaw gak anup aŋgak, “Tikjakiy, siŋbiy owan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aŋgek, nuk mindek siŋak apek, kuyip aŋgak, “Lotiw ñin chin ak yergep? Tep gep akaŋ timey gep? Biynimb gok kuyip simb niŋiy gon kim amniŋgiy akaŋ, kirgon kumniŋgiy?” Aŋgek, nup pen minim bap ma aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Biynimb minim nup ma dinjun aŋgiy niŋyak kun gok kuyip, niŋek nup mapin akak ak pen; gos tep ma niŋbay aŋgiy, kuyip simb niŋak. Kun ak kuyip niŋdand pandikiy, bi ñin kalaw gak ak nup, ñin parsek ayan aŋgek, parsek ayakniŋ suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kun gek niŋiy, bi Peresiy gok am Herot binuk mindeyak ak amiy, minim aŋgniŋ aŋgniŋ giy, Jiysis nup kun kun giy ñaŋgjun aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jiysis pen kuyip kirgiy, binuk gok diy, am Galiyliy chemb gol siŋak mindyakniŋ, biynimb kuŋaynep wiyak. Galiyliy biynimb gunap, Taya-Saydon biynimb gunap, Jerusalem biynimb gunap, Jiwdiya biynimb gunap, Yidumiya biynimb gunap, Joden ñiŋg pis tawakdoŋ ken biynimb gunap nuk giyiŋgip ar ak aŋgey niŋyak ak mey, nup niŋniŋg wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Pen nup diniŋon chinup suŋ ayniŋgamb aŋgiy, ap chichmiy yim gey apek, binuk gok kuyip aŋgek, bot bap di ayrep giyak. ");
INSERT INTO kmh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pen biynimb kichekiy malñiluk tap yerip ambaŋ ayak gok, Jiysis mindek siŋak koŋgim yimiy, minim yomb aŋgiy aŋgyak, “Nand Gor Ñinuk yimb aŋgyak!” ");
INSERT INTO kmh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jiysis pen, kichekiy malñiluk gok kuyip minim kilis aŋgiy aŋgak, “Minim kun ak miseŋ ma aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pen Jiysis miñmon taw bap amiy, binuk diniŋg gak gok aŋgek apeyak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","“Yand nimbip bi onep wimiŋgan ak dispiyn ak mey, yand yip taŋgiy, bi minim yip dand amemb gok mindiy, aŋgyoken am biynimb okok kuyip aŋgñiniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nimbip aspiyn ak mey, kichekiy malñiluk tap gok kunep aŋgyokniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jiysis binuk dak kun gok yimb kiyk mey, bap Saymon, kisen Jiysis yimb nup bap Piyta aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","19","Bap Jemis, numam bap Jon, nop kiymiŋay yimb ak Sebediy. Jiysis kuyipmiŋay, timuk-bi aŋgak. Binuk bap Enjriw; bap Piyliyp; bap Batlomiyiw; bap Matyiw; bap Tomas; bap Jemis, nop nuk yimb ak Alpiyas. Bap Taydiyas, bap Saymon, nup Saymon Selot aŋgyak. Bap Jiwdas Yiskariyot. Nuk mey, kisen Jiysis nup mimuŋg gak. ");
INSERT INTO kmh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pen Jiysis korip amek, tip ak biynimb kuŋaynep ap nan-gi mindyakniŋ, binuk gok yip tap ñiŋniŋgiy rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kun gek, biynimb gunap Jiysis sakiy ayip aŋgey niŋiy, nonim, nunay, numam sikop nup poŋdiniŋg wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pen Jiwda low tiysa Jerusalem nimb wiyak gok aŋgyak, “Belsiybul Jiysis nup ambaŋ ayip rek, malñiluk tap gok aŋgyokip aŋgyak.” Nup yesek kun aŋgeyak, ");
INSERT INTO kmh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","nuk biynimb gok kuyip aŋgek apeyak, minim ar kun ak paydoŋ ay kuyip aŋgrep giy aŋgak, “Seytan yergiy Seytan nup aŋgyokniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","25","Biynimb miñmon nokom bap kiyk keynep penpen giniŋgambay ak, wikan kun ak asik keykey ayniŋgambay. Pen amyoŋg apyoŋg gok kunep penpen giy, asik keykey ayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kun ak rek, Seytan nuk key kichekiy, malñiluk tap nuk gok ma aŋgyokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bi kalrimey bap mindakniŋ, bi bap am, tap nup gok ma diniŋgamb; miñ di tiwniŋg ay nep mey, am tap nup gok diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Pen niŋrep ginimimb! Biynimb gok tap siy tap timey yerip yerip giniŋgambay ak, Gor nup aŋgniŋey, niŋiy kirginiŋgamb. Bapiy nup akaŋ yip aŋgjiwniŋgambay ak, kunep, kuyip niŋiy kirginiŋgamb ak pen, ");
INSERT INTO kmh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kawnan nuk ak nup aŋgjiwniŋgambay ak, niŋiy ma kirginiŋgamb. Miker kun ak perper mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jiysis nup, Seytan yip mindip aŋgeyak mey; kun aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pen Jiysis nonim numam sikop ap mis akyaŋ mindyiŋg, nup “Owan” aŋgey, ");
INSERT INTO kmh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","35","biynimb korip miŋgan biyaŋ nup piŋiy kuskus gi mindeyak gok aŋgyak, “Nanim namam sikop ap mis biyaŋ mindiy, nip owan aspay aŋgyak.” Kun aŋgeyak, Jiysis biynimb mindeyak gok niŋdand pandikiy aŋgak, “Nimb mey amiy yand, mam yand gok mindpim. Biynimb Gor aŋgip rek niŋdipay gok mey, amiy, mam, ay yand gok rek mindpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jiysis Galiyliy chemb gol ak amiy, biynimb gok kuyip tip ak minim aŋgñi mindakniŋ, biynimb kuŋaynep ap nan-giyak. Kun geyak, Jiysis bot ar ak bisgiy, am ñiŋg namb siŋak mindyiŋg, kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Minim kun gok paydoŋ ay, ar keykey nep aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ar bap paydoŋ ay aŋgak, “Minim aŋgniŋg gispiyn ak niŋim! Bi bap woŋgday nuk ak piken piŋiy gayrep giy, wiyt maŋgiy dam diyokek amnakniŋ, ");
INSERT INTO kmh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","gunap kinjeŋ kosemb ar ak yapeniŋgamb, yakir gok ap ñiŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gunap kamb ar man siskoy ayniŋgamb okok yapiy jakniŋgamb ak pen; ");
INSERT INTO kmh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kindiy paryomb ma amnak rek, pumb niŋiy milip giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gunap kikasik dindbiliŋ mindeniŋgamb namb okok yapiy jakniŋgamb ak pen, kikasik dindbiliŋ gok pik ñimbek maŋgiy ma piyniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pen gunap man tep ar ak yapiy, jakrep giy, maŋgiy piyrep yimb giniŋgamb. Gunap maŋgiy ñin jiwiy rek piyniŋgamb, gunap maŋgiy ñin jiwiy omiŋal rek piyniŋgamb; gunap ñin jiwiy onep tiŋgawip ak rek piyniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jiysis minim kun ak aŋgjiwyiŋg aŋgak, “Nimb biynimb gos timund sek mindenimimb gok, minim aspiyn biy niŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Biynimb Jiysis minim aŋgakniŋ, ap niŋmindeyak kun gok keykey amniyakniŋ, binuk onep wimiŋgan ak sek, biynimb nuk gunap sek nup aŋgyak, “Minim paydoŋ ay apan kiñiŋ ak yerip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aŋgeyak aŋgak, “Gor biynimb diy kond mindeniŋgamb minim ma niŋyiŋgipay ak; nimb niŋiy niŋniŋgambim ak pen; biynimb gunap minim nup ma niŋjun apay rek, kuyip paydoŋ ay nep aŋgñimbiyn. ");
INSERT INTO kmh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kiyk Asaya aŋgak rek: ‘Windin niŋbay ak pen, tap gunap ma niŋbay. Minim niŋbay ak pen, minim kiñiŋ aŋgip kun aŋgiy ma niŋbay. Niŋrep gipyap rek, Gor nup aŋgniŋembiyap, tap siy tap timey gipay ak niŋiy kirgipkop’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jiysis kun aŋgiy kuyip aŋgak, “Minim paydoŋ ay aŋgen ma niŋbim kun ak; yergiy kisen minim paydoŋ ay aŋgeniŋgayn niŋniŋgambim? ");
INSERT INTO kmh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wiyt yiŋ ak, Gor minim nup ak aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maŋgiy gunap kinjeŋ yomb ar ak yapek, yakir gok ap ñiŋniŋgambay apiyn ak; biynimb gok Gor minim niŋbay ak pen, won ak Seytan ap gek, sakiy gipay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Pen gunap kamb ar man siskoy ayniŋgamb okok yapiy jakniŋgamb ak pen, kindiy am wos ma gek, pumb niŋiy milip giniŋgamb apiyn ak; Gor minim ak kisen won ak niŋey tep gakniŋ diniŋgambay ak pen, yep won bap mindiy, biynimb gunap minim aŋgey niŋiy akaŋ, miker gunap apek, minim nup ak kirginiŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Pen kikasik dindbiliŋ namb ak yapiy jakiy maŋgiy ma piyniŋgamb rek mey; biynimb Gor nup minim niŋniŋgambay ak pen; woŋg wariy, korip minj kinemb, tiw minan, maniy, tap okok gosimb niŋiy, aŋgip rek ma giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wiyt maŋgiy man tep ar ak yapiy jakrep giy, maŋgiy ñin jiwiy akaŋ, ñin jiwiy gunap rek piyniŋgamb apiyn ak; biynimb Gor minim niŋiy nup pisnep chiŋgipay gok apiyn. Gunap nup direp gipay; gunap nup direp yimb gipay; gunap nup direp giyiŋg, ar kun ak key yimb gipay aŋgiy apiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jiysis pen tip ak, minim bap paydoŋ ay aŋgak, “Lam ak daŋgiy, boŋg molik okok akaŋ, tiyn miŋgan okok ma aypay. Melik ginimuŋ aŋgiy, ar siŋbiyoŋ tik aypay. ");
INSERT INTO kmh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kun ak rek, minim yerip yerip miñiy weygiy mindip gok, kisen Gor gek miseŋ niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nimb biynimb gos timund sek mindenimimb gok minim aspiyn biy niŋrep ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kuyip minim bap aŋgak, “Minim niŋsipim ak niŋiy, niŋrep ginimimb. Biynimb minim yiñrimey rek aŋgniŋgambay gok, Gor kuyip kunep yiñrimey rek aŋgniŋgamb. Biynimb minim sayn rek aŋgniŋgambay gok, Gor kuyip kunep minim sayn rek aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Biynimb minim niŋiy niŋdiniŋgambay gok, Gor kuyip gos tep ñek gunap sek niŋniŋgambay; pen ma niŋniŋgambay gok, kiyk siskoy niŋbay ak niŋek tap rek ma ayek, yiwur yomb ñiniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Minim bap pen aŋgak, “Gor biynimb diy kond mindeniŋgamb ak, bi woŋg nop gok wiyt maŋgiy jakaŋ aŋgiy, dam woŋgday kiyk okok yokey jakip rek nep giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wiyt maŋgiy woŋgday okok yokiy, kin taŋgyakniŋ, gup giy jakniŋgamb ak pen; yergiy jakip aŋgiy ma niŋniŋgambay; ");
INSERT INTO kmh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","man ak key gek jakiy, maŋgiy piy, pik giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pen woŋgday nop nimb ak pikgek niŋiy, tik dand wep ñin ak wip aŋgiy, tik dand winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jiysis kun aŋgiy aŋgak, “Gor biynimb diy kond mindeniŋgamb ak, kesim yerip rek ak diy aŋgen niŋniŋgambim? ");
INSERT INTO kmh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Mey, mon mastet yiŋ rek ak aŋgnim. Tap yiŋ gunap yomb yimbay gok sikoy jakip, pen mastet yiŋ ak sikoy yimb yimey jak yomb giy, alik pikek, yakir gok ap sisiy kun okok aymindpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jiysis biynimb gok kuyip minim paydoŋ ay kun gok rek kuŋaynep aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Minim miseŋ aŋgñen ma diniŋgambay aŋgiy, paydoŋ ay nep aŋgñiy, kisen binuk gok yip key mindyiŋg, minim junj gok aŋgñirep giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ñin kun anep duŋgep won ak, Jiysis binuk gok kuyip aŋgak, “Kind bindoŋ amnun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kun aŋgiy, binuk gok yip biynimb kuŋaynep ap mindeyak gok kuyip kirgiy, bot Jiysis mindek miŋgan ak amiy, bot gunap mindakniŋ, kiyk saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Namb amniyakniŋ, day yiŋgen yindmund apiy, ñiŋg siy paŋg bot miŋgan ak amiy, poŋgek yowniŋg rek gak. ");
INSERT INTO kmh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jiysis nuk pen bot miŋgan day akneŋ ken, piylow jun ay kinakniŋ; binuk gok nup am kikawin giy aŋgyak, “Tiysa, chin maŋgiysek kumniŋg gispun gos ak ma niŋban?” ");
INSERT INTO kmh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aŋgeyak, Jiysis tikjakiy, yiŋgen yindmund dek ak sek, ñiŋg siy paŋg apek ak sek aŋgek kirgak. ");
INSERT INTO kmh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pen binuk gok kuyip aŋgak, “Yenen pirikpim? Gor chinup ma kond mindip aŋgiy niŋbim?” ");
INSERT INTO kmh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aŋgek, kiyk wal aŋgiy, pen aŋgniŋek pen aŋgniŋek giy aŋgyak, “Bi kun biy an? Yergiy aŋgamb yiŋgen yindmund ak sek, ñiŋg paŋg apamb ak sek aŋgip rek gip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jiysis binuk gok yip bot diy, Galiyliy chemb tikiy Gerasa biynimb mindeyak kind akdoŋ ken amjakyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","bi kichekiy ambaŋ ayak bap Jiysis mindek ak awak. ");
INSERT INTO kmh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Bi kun ak chip komyak kamb miŋgan okok kin taŋgyiŋgip. Nup per sen diy, ñin tomb okok aybirikyiŋgipay ak pen, sen gok gek puŋgrikek, amyiŋgip. Giyiŋgip kun ak, nup gey gos niŋnimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pumbnamb kisyimken, chip komyiŋgipay kamb miŋgan okok sek, miñmon yirik okok sek gawil giraŋgyiŋg, kamb diy mumbwak nuk gok key timbyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pen ñin kun ak nuk Jiysis nup parchim niŋiy, puŋgrikind aŋgiy am apek siŋak koŋgim yimek, ");
INSERT INTO kmh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jiysis kichekiy ambaŋ aymindek anup aŋgak, “Kiriŋg mis amnoŋ aŋgak.” Aŋgek aŋgak, “Jiysis. Gor Biyomb sikerek Ñinuk. Yip yerginiŋg opan? Gor mindip rek yip miker ma ñinimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kun aŋgek, Jiysis bi kun anup aŋgak, “Yimb nand yerip?” Aŋgek aŋgak, “Yip kichekiy kuŋaynep ambaŋ ayip rek, yimb yand ‘Kuŋaynep’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pen Jiysis nup, kichekiy gok kuyip paryomb okok ma aŋgyoknimin aŋgiy, aŋgniŋyiŋg nep mindek. ");
INSERT INTO kmh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Won kun ak, kanj kuŋay yimb, tiw tawsin rek, amil ñimbeyak pir siŋak ak mey, ");
INSERT INTO kmh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kichekiy gok Jiysis nup aŋgyak, “Chinup aŋgey, am kanj guniyoŋ kuyip molik sikun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kun aŋgey, kichekiy gok aŋgyokek, am kanj gok kuyip molik sikey, puŋgjiw minduŋ biyaŋ amiy, gi dam ñiŋg biyaŋ pikiy, maŋgiysek ñiŋg ñimbiy kumdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pen bi kanj mokyiŋgipay gok, am dawin yomb gok, miñmon yikop gok minim kun ak aŋgñeyak, biynimb gok am niŋun aŋgiy, Jiysis mindek ak wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Apiy niŋyak: bi kichekiy kuŋaynep ambaŋ ayak kun ak; chech yimiy bisiŋg mindrep gek, kuyip jel gak. ");
INSERT INTO kmh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Biynimb nind ap mindeyak gok, kisen wiyak gok kuyip, Jiysis yerer gak ak aŋgñiyak. Pen kanj gok kuyip yerer gak ak kunep aŋgñeyak niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jiysis nup aŋgyak, “Miñmon chinup biy kirgiy amnoŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aŋgeyak, Jiysis bot diy amniŋg gek, bi gek suŋ ayak ak aŋgak, “Yand yip amjur akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aŋgek aŋgak, “Korip nak amiy, biynimb nak gok kuyip, Gor nip simb niŋiy yerer gip minim ak, aŋgñinimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aŋgek, bi kun ak miñmon Dekapoliys giraŋgyiŋg, Jiysis nup yerer gak ak, biynimb gok kuyip aŋgñek niŋiy, wal yimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jiysis pen bot diy, tip ak andkind am Galiyliy chemb pis tawakdoŋ ken mindakniŋ, biynimb kuŋaynep wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Bi bap yimb nuk Jayras. Nuk Jiwda nan-gep korip ak kond mindyiŋgip. Jiysis nup niŋiy, ap mindek siŋak koŋgim yimiy aŋgak, “Pañ mapin yand ak kumniŋg gisap. Nand ap nup diniŋey, jak amnaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aŋgek, Jiysis tikjakiy Jayras yip amnirikniŋ, biynimb kuŋaynep am Jiysis nup namb ay dand amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pen biyn bap, biyn kinjeŋ pandikakniŋ mindek simiy yin wimiŋgan ak ayak. ");
INSERT INTO kmh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Biyn kun ak dokta gok kuyip, yip gey suŋ ayaŋ aŋgiy, maniy tawyiŋgip ak pen, nup gey suŋ ma ay, tapin yomb yimb gak. ");
INSERT INTO kmh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Pen nuk Jiysis giyiŋgip minim ak aŋgey niŋak rek, am chech band nup ak nep diniŋen suŋ ayniŋgamb aŋgiy, biynimb kuŋay mindeyak namb ak, ");
INSERT INTO kmh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","mindek kund okok ken apiy, chech nup ak diniŋek, likañ yapyiŋgip ak milip gak. Namb nuk akyaŋ key niŋak nup suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pen Jiysis nup gak kun ak key niŋiy; tuŋgandikiy biynimb gok kuyip aŋgak, “Chech yip ak an diniŋsap?” ");
INSERT INTO kmh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aŋgek, binuk gok aŋgyak, “Biynimb kuŋaynep nip chirok ñimbay ak, yenen yip an diniŋimb aŋgiy aspan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kun aŋgey, Jiysis minim kuyip aŋgyak ak ma diy, an diniŋimb aŋgiy piyowniŋ mindek. ");
INSERT INTO kmh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pen biyn kun ak, nup yerer gak ak niŋiy, pirikiy jep di giy, ap Jiysis mindek siŋak koŋgim yimiy, nup suŋ ayak minim ak miseŋ aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jiysis pen aŋgak, “Pañ yand. Gor yip gek suŋ ayniŋgamb aŋgiy gos niŋban rek, nip gek suŋ ayip nen, amiy mindrep ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jiysis minim kun ak aŋgakniŋ, Jayras binuk gunap, korip nuk animb apiy aŋgyak, “Panak mindarik kumimb; tiysa nup aŋgey tomb yiwur ma winimuŋ; aŋgey andkind amnimuŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kun aŋgyak ak pen; Jiysis minim kuyip ak ma diy, Jayras nup aŋgak, “Ma piriknimin; yip nep gos niŋnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pen biynimb gok kuyip, kun okok aŋgay, Piyta ak, Jemis ak, Jemis numam Jon ak kuyipyakam nep poŋind amnak. ");
INSERT INTO kmh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jayras korip ak amjakiy niŋak: biynimb kilpul aŋgyiŋg, siy aŋgyiŋg gi mindeyak. Niŋiy korip miŋgan biyaŋ amiy aŋgak, “Yenen kilpul aŋgyiŋg, siy aŋgyiŋg gispim? ");
INSERT INTO kmh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pañ ak ma kumimb; yikop wisin kinjap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kun aŋgek, nup sik aŋgeyak, kuyip aŋg mis yokiy, pañ nop nonim ber ak diy, binuk kaw ak diy, poŋind pañ ak kumek, korip ñiluk miŋgan dayey mindek biyaŋ amiy, ");
INSERT INTO kmh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ñin kind nup ak diy, Jiwda minim aŋgiy aŋgak, “Taliyta kawim aŋgak.” Minim aŋgak kiñiŋ kun ak mey, “Paskoy! Nip aspiyn; tikjakan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aŋgek, pañ kun ak simiy nuk onep wimiŋgan amnak ak mey, tikjakiy aran apyan gakniŋ, biynimb gok wal yimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kun geyak, Jiysis minim kilis aŋgiy aŋgak, “Gipiyn kun ak biynimb gok kuyip miseŋ ma aŋgñinimimb aŋgak.” Kun aŋgyiŋg aŋgak, “Pañ anup keñmaŋgiy gunap ñem ñiŋaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jiysis binuk gok poŋind miñmon kun ak kirgiy, miñmon nuk Nasaret amnak. ");
INSERT INTO kmh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Am mindiy Jiwda lotiw ñin ak apek, nan-gep korip ak amiy, biynimb kuŋay ap mindeyak gok kuyip minim aŋgñakniŋ, niŋiy wal aŋgiy aŋgyak, “Bi kun biy kapenda miñmon biy nimb nep; Mariya ñinuk bap. Numam nuk Jemis, Josis, Jiwdas, Saymon sek, nunay nuk gok sek yip mindpun biy. Pen minim kun ak akay nimb niŋiy aŋgip? Tap mageprek yergiy gip?” Kun aŋgiy, nup ma diyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pen Jiysis kuyip aŋgak, “Bi Gor minim aŋgep gok, miñmon wikan gunap giraŋgey, biyomb chin aŋgiy dipay ak pen; biynimb korip miñmon kiyk key gok, minim kuyip ak ma dipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nup gosimb ma niŋyak kun ak, tap mageprek gunap ginimuŋ rek ma ayak. Biynimb tap gak gunap nep diniŋek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pen Nasaret biynimb nup, Gor Ñinuk yimb aŋgiy gos ak ma niŋeyak, nuk wal yimb aŋgak. Jiysis pen korip miñmon kun okok taŋgyiŋg, biynimb gok kuyip Gor minim ak aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ñin bap binuk onep wimiŋgan ak suk aŋgek apey aŋgak, “Bi omiŋal ak key, bi omiŋal ak key miñmon okok keykey amiy, minim aŋgñinimimb. Yand nimbip aŋgyoksipiyn rek, minim aŋgñi taŋgyiŋg, kichekiy malñiluk tap gok aŋg mis yokniŋg, aŋgyokniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Minim bap pen aŋgak “Amniŋg; tap ñiŋemb, maniy, wand sikoy, tap gok dand ma amnimimb; yir kondim anep dand amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tomb tirup ay amnimimb ak pen, tiŋgliys nokom bap nep ay amnimimb, gunap sek dand ma amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Korip bap amem nimbip aŋgdeniŋgiy, korip kun anep mindiy, amniŋg ginimimb ñin anep amnimimb. ");
INSERT INTO kmh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Miñmon bap amjakem nimbip ma aŋgdiy, minim nimbip ak ma niŋeniŋgiy, miñmon kun ak kiriŋg amniŋg, niŋyaŋ aŋgiy, tomb silkul pikem yapek amnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aŋgek, kiyk miñmon sikoy keykey amiy, biynimb gok kuyip minim aŋgñiyiŋg aŋgyak, “Tap siy tap timey gipim gok, Gor nup yenen kun gipun aŋgiy, kirginimimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kun aŋgiy, biynimb kichekiy malñiluk ambaŋ ay mindek gok, kichekiy malñiluk aŋg mis yokiy, biynimb tap gak gok wel ayñey jak amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pen Jiysis gak rek, minim ak miñmon okok kind kind amek, kiyŋ Herot kunep niŋak. Biynimb gok, minim kun ak aŋg amiy apiy giyiŋg, gunap aŋgyak, “Jon bi ñiŋg pikñemb kumek komyak ak, tip tikjakiy mey, ap tap mageprek kun gok gisap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gunap aŋgyak, “Bi kun ak binak Yilayja; bi siŋok nind apek, Jiwda Kiyŋ yomb key yimb kisen winiŋgamb apay ak aŋgyak.” Gunap aŋgyak, “Bi Gor minim aŋgep wosrey mindyiŋgipay rek bap ap mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pen kiyŋ Herot nuk niŋiy aŋgak, “Ak Jon bi ñiŋg pikñemb nind kuŋam tiknik anep tikjakiy, ap kun gisap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Yenen, nind Herot, numam Piyliyp biynuk Herodiyas nup dek, Jon aŋgak ak timey gip aŋgek, Herodiyas Jon nup miluk niŋiy aŋgek, Herot binuk gunap aŋgyokek, am Jon nup dand apiy, kalambis ayak. Biyn Herodiyas, Jon nup pikayin aŋgiy gos niŋak ak pen; ");
INSERT INTO kmh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jon tap timey ma giyiŋgip; minim nuk yerip yerip aŋgek Herot niŋiy, minim tep, yipund giy nep aŋgip aŋgiy, pirikiy biyn Herodiyas nup yaw aŋgnimuŋ rek ma ayek, ");
INSERT INTO kmh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jon nup yergiy pikaynim aŋgiy, gos okok nep niŋmindyiŋgip. Mind mind minek bap, Herot nonim nup tikak ñin ak apek, tap yomb ñiŋniŋg, gapman biyomb gok, amiybi yomb gok, biyomb miñmon Galiyliy nimb gok suk aŋgek, tap yomb ñiŋniŋg wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ap tap ñiŋyakniŋ, Herodiyas panuk ap deniys gek, biyomb ap mindeyak gok sek, Herot sek niŋey kuyip tep gek, Herot pañ kun anup aŋgak, “Gipan kun ak tap yerip aŋgniŋeniŋgamban nip ñiniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pen miñmon yomb kond mindpiyn ak aŋgniŋey, nip day ak aŋgen kond mindeniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kun aŋgek, pañ ak am nonim Herodiyas nup tap yerip ak aŋgniŋnim aŋgek aŋgak, “Jon bi ñiŋg pikñemb jun won nup ak aŋgnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aŋgek, panuk kasek kiyŋ Herot mindek ak amiy aŋgak, “Yep won biy nep, Jon bi ñiŋg pikñemb kuŋam ak tikiy, jun won nup ak di piler ar ay, dap yip ñey niŋiy mey; pisnep kumimb aŋgiy niŋnim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","28","Kun aŋgek, kiyŋ Herot Jon nup niŋek simb timey gak ak pen, nuk biyomb gok niŋmindey pañ anup, tap yerip yip aŋgniŋey ñiniŋgayn aŋgak rek niŋiy, amiybi nuk bap aŋgyokek, am Jon nup jun won ak timbrikiy, di piler ar ay dand apiy, pañ kun ak nup ñek, nuk dand amiy, nonim nup ñak. ");
INSERT INTO kmh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pen Jon binuk gok, nup kuŋam tikyak ak aŋgey niŋiy, am mumbwak dand apiy, kamb miŋgan ak komyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jiysis binuk gok andkind apiy, biynimb gok kuyip minim aŋgñiyiŋg yerer giyak gok, Jiysis nup aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pen biynimb kuŋay yimb nep amiy apiy geyak, Jiysis binuk gok yip tap ñiŋniŋgiy rek ma ayek, kuyip aŋgak, “Chin biynimb ma mindpay namb okok amiy, yikop mindenjun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","34","Kun aŋgiy, binuk gok yip bot diy amniyakniŋ, biynimb miñmon kun okok Jiysis amjap aŋgiy, ñiŋg gol ar kinjeŋ par ak nind amiy, Jiysis binuk gok yip amniŋg geyak okok, nind am mindeyak. Jiysis amjakiy kuyip niŋek, kiyk kanj siypsiyp bi kond mindep bap ma mindip rek ak mindeyak. Kun ak niŋek simb gek, kuyip minim gunap tapin aŋgñi mindek. ");
INSERT INTO kmh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pumb paŋind amnakniŋ, binuk gok apiy nup aŋgyak, “Pumb saŋind amimb. Akniy miñmon nep namb okok nen, ");
INSERT INTO kmh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","biynimb guniy aŋgyokey, miñmon korip yep maŋ akniy amiy, tap keñmaŋgiy kiyk gunap taw ñiŋyaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aŋgeyak aŋgak, “Nimb key kuyip keñmaŋgiy ñinimimb aŋgak.” Aŋgek aŋgyak, “Kun apan ak, chin maniy yir anep tiŋgawip piskind ak dand amiy, keñmaŋgiy taw dand apiy kuyip ñinjun?” ");
INSERT INTO kmh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aŋgey, Jiysis aŋgak, “Biret nimb yerip yerip mindip am niŋim aŋgak.” Aŋgek am niŋiy aŋgyak, “Biret onep mamind ak, piys omiŋal sek mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kun aŋgeyak aŋgak, “Biynimb guniy aŋgem, asik bum keykey ay, tap kaskas ar akniy bisgey amnaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aŋgek, kuyip aŋgeyak, gunap piyptiy rek bum giyak; gunap wan handret rek bum giyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pen Jiysis biret kaw ak sek, piys omiŋal ak sek diy, kiyoŋgiy niŋiy, Gor nup tep aŋgiy, biret ak tipaŋg binuk gok kuyip ñek, kiyk biynimb gok kuyip bilok ñiyak. Piys omiŋal ak kunep ñek, biynimb gok kuyip bilok ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ñeyak, ñimb gey gey kuyip tapin ayak. ");
INSERT INTO kmh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tap day day kirgiyak gok, Jiysis binuk gok wand diy yiŋg gey gey, wand onep wimiŋgan ak arachakak. ");
INSERT INTO kmh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tap ñiŋyak ñin kun ak bi gok nep mey, payp tawsin amnak. ");
INSERT INTO kmh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pen Jiysis binuk gok kuyip aŋgek, bot diy Betsayda kind bindoŋ amniyakniŋ, biynimb gok kuyip key aŋgyokek amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aŋgyokiy, nuk miñmon yirik bap amiy, Gor nup aŋgniŋ mindek. ");
INSERT INTO kmh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Kisyim winiŋg gak won ak, Jiysis nep mindiy niŋak: Binuk gok bot diy ñiŋg namb siŋbindoŋ amniyakniŋ, yiŋgen ak ameyak okok ken apek, kosyam ñiŋg kas pikrikyiŋg amniyak. Miñmon tirgum tikak won ak, nuk ñiŋg kas ar ak amiy, kuyip tawsak ay amniŋg gek, ");
INSERT INTO kmh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nup aŋgniŋyak-eŋ chip kawnan aŋgiy, pirikiy kumb gawil giyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kun giy pirikeyak, Jiysis kuyip aŋgak, “Ma piriknimimb! Yand nep aswiyn! Gos yomb ma niŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aŋgiy, bot miŋgan amek, pinim dek ak kirgak. Kun gek, yergiy kun gip aŋgiy, gos kuŋay yimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Biret diy biynimb kuŋaynep bilok ñak ak niŋyak ak pen, gos kuyip pikñiŋak rek, Gor Ñinuk ak mey kun gip aŋgiy ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pen ñiŋg namb ak am am miñmon Genesaret amjakiy, bot ak tiwniŋg ayak. ");
INSERT INTO kmh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bot ak kiriŋg amniyakniŋ, biynimb kun okok Jiysis owip aŋgey niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kasek miñmon kind kind amiy, biynimb tap gak gok kuyip dand Jiysis am mindek okok amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ñin kun gok Jiysis miñmon yikop akaŋ, dawin yomb okok amjakek, biynimb tap gak gok kuyip dap maker namb ak ay aŋgyak, “Nand mindey biynimb tap gip gok, chech day nip okok nep di niŋey, kuyip suŋ ayaŋ aŋgyak.” Kun aŋgeyak, nuk minim kuyip ak diy niŋmindakniŋ, biynimb nup diniŋyak gok suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bi Peresiy gunap, bi low tiysa gunap Jerusalem nimb ap mindiy niŋyak: ");
INSERT INTO kmh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jiysis binuk gunap nusind nupis sikop asikrep giy, tap ñimbyiŋgipay rek ma giyak. ");
INSERT INTO kmh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Peresiy biynimb gok diy, Jiwda biynimb gok maŋgiysek, nusind nupis sikop aŋgyiŋgipay rek niŋiy, monmon ma giy; ñin ñiŋg ay giluŋg yokiy nep tap ñimbay. Biynimb Jiwda mer gok mindpay namb ak amiy, kunep ñin ñiŋg ay giluŋg yokiy nep tap ñimbay. Pen tiyn, piler, kap tap okok kunep kilrimey gipay. ");
INSERT INTO kmh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kun ak Jiysis binuk gok yikop ñiŋyak kun ak niŋiy, bi Peresiy gok sek, bi low tiysa gok sek nup aŋgyak, “Bi nand gok yenen, basind apis sikop aŋgyak rek ma gipay?” ");
INSERT INTO kmh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aŋgeyak, Jiysis aŋgak, “Asaya nimbip bi minim nep apim gok, niŋind yimb aŋgiy Baybol buk ak tikiy aŋgak, ‘Biynimb guniy Gor Biyomb chin; Gor Biyomb chin apay ak pen, kiyk yikop minim anep apay; yip gosimb ma niŋbay. ");
INSERT INTO kmh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gor minim tep ak aŋgñispun aŋgiy, biynimb apay minim anep aŋgñimbay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nimb Gor nup minim ak kirgiy, biynimb minim apay ak dun aŋgiy, nap nasind sikop aŋgyiŋgipay ar ak kindik gipim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jiysis kuyip tip ak aŋgiy aŋgak, “Nimb Gor minim aŋgip ak kirgiy, minim nimbik key anep apim. ");
INSERT INTO kmh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","11","Mosis minim bap tikiy aŋgak, ‘Nap nanim minim aŋgnimiyr rek niŋdiy, kuyip direp ginimimb. Pen ñapan gunap nop nonim kuyip minim timey aŋgeniŋgiy, pikayem kumniŋgiy aŋgak.’ Pen nimb yenen minim kun ak rek ma aŋgñimbim. Biynimb gunap nop nonim kuyip kirginiŋg, tap kuyip ñimbinup rek ak, Gor nup aŋgiy aypun aŋgey, ");
INSERT INTO kmh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","‘Ak aŋgrep gispim apim.’ ");
INSERT INTO kmh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gipim kun ak, Gor nup minim ak kirgiy, nap nasind sikop giyiŋgipay miñ ar ak nep gem amimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jiysis kun aŋgiy, biynimb gok kuyip aŋgek mindek kiñiŋ siŋak apey aŋgak, “Minim aŋgniŋg gispiyn ak niŋiy, niŋrep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tap ñimbey namb biyaŋ amniŋgamb ak gach ma mindeniŋgamb; namb biyaŋ nimb mis winiŋgamb anep mey, gach mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nimb biynimb gos timund sek mindenimimb gok, timund ay niŋrep ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiysis kun aŋgiy, biynimb gok kuyip kirgiy korip miŋgan amek, binuk gok nup aŋgyak, “Minim paydoŋ ay apan kun ak, kiñiŋ nuk ak yerip?” ");
INSERT INTO kmh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aŋgey aŋgak, “Kiyk ma niŋbay rek, nimb kunep ma niŋbim? Tap asikpay gok, monmon ñimbey koŋgiy namb biyaŋ amek, Gor niŋek gach ma mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yenen: tap ñimbay kun gok gosimb niŋbay namb biyaŋ ma amniŋgamb; koŋgiy namb biyaŋ nep amek, simb sek kiy yokniŋgambay aŋgak.” Jiysis minim aŋgak kun ak, tap okok maŋgiysek ñiŋemb nep; asikep gunap ma mindip aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pen Jiysis aŋgak, gos timey namb kuyip akyaŋ nimb apek mey; timey gey Gor niŋek minim mindip. ");
INSERT INTO kmh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Biynimb gok namb kuyip biyaŋ gos timey awakniŋ, timey giy, tap siy diy, chip ñaŋgiy, biyn siy bi siy giy, ");
INSERT INTO kmh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","timey nep giy, minim timey aŋgiy, tap gok yip rek mindembikop aŋgiy, miluk niŋiy, biynimb aŋgjiwiy, monmon giy, yimb key dand araniy timey gep gos nokom niŋiy gipay. ");
INSERT INTO kmh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tap timey gipay kun gok key okok nimb ma wip, gos timey ak namb kiyk biyaŋ nimb apamb timey gambay mey, gach mindip. ");
INSERT INTO kmh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jiysis Galiyliy kirgiy, am miñmon Taya maŋ okok amnak. Amiy, biynimb gok yip miñiy ma niŋniŋgiy aŋgiy, korip miŋgan bap am weyiŋg mindek ak pen; weygiy mindonimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Biyn bap, panuk nup kichekiy abaŋ ayak ak mey, Jiysis wip aŋgey niŋiy, am mindek kiñiŋ siŋak jun paŋgiy aŋgak, “Pañ yip kichekiy abaŋ ayip ak, gey mis amnaŋ aŋgak.” Biyn kun ak nuk Jiwda mer bap. Nup tikyak miñmon Siyriya; dawin yomb nuk mey Poniysiya. ");
INSERT INTO kmh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pen kun aŋgek, Jiysis nup tikdam ay aŋgak, “Keñmaŋgiy ñapan chin gok ñemb ak di kayn mokon, timey giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aŋgek, biyn ak pen aŋgak, “Biyomb! Ak tep apan ak pen, ñapan gok tap ñimbey, day day gok nep boŋg molik okok yapek, kayn ñiluk gok ñimbay sek aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aŋgek, Jiysis minim kun ak niŋiy aŋgak, “Nand kun apan ak, pañ nand kichekiy molik sikiy mindamb ak, gambiyn mis amimb nen amnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aŋgek, andkind amiy niŋak: kichekiy kiriŋg mis amek, panuk minj ar ak kapkap kin mindek. ");
INSERT INTO kmh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jiysis miñmon Taya kun ak kirgiy, am miñmon Saydon amiy, miñmon Dekapoliys namb okok amiy, Galiyliy chemb amnak. ");
INSERT INTO kmh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Amjakakniŋ, biynimb gok bi timund pilgiy minim aŋgrep ma giyiŋgip bap dand apiy, Jiysis nup aŋgyak, “Bi biy nup diniŋey suŋ ayaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aŋgeyak, Jiysis bi kun anup poŋind keykey siŋak amiy, ñin maŋgiy par ak timund miŋgan nup ak yokiy, ñin maŋgiy kuñik giy alemb nup ak diniŋyiŋg, ");
INSERT INTO kmh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kuyoŋgiy niŋiy, miker gakniŋ, “Epata” aŋgak. Epata aŋgak minim kiñiŋ kun ak “Paŋgyikan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kun aŋgakniŋ, bi kun ak timund miŋgan ak paŋgyikiy, alemb awan amnakniŋ, day minim yipund giy aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aŋgakniŋ, Jiysis kuyip minim kun ak biynimb okok ma aŋgñinimimb aŋgak ak pen, kiyk amiy biynimb kuŋaynep aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Minim kun ak aŋgñey niŋiy, wal aŋgiy aŋgyak, “Jiysis tap okok maŋgiysek, biyomb ak apiy giniŋgamb aŋgyak rek nep gip. Biynimb timund pilgip gok gek niŋrep gipay, biynimb alemb miker gip gok gek, minim aŋgrep gipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ñin namb kun siŋak nep biynimb kuŋaynep ap mindey, keñmaŋgiy ma mindek, Jiysis binuk gok suk aŋgek apey aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yand biynimb guniy kuyip simb niŋsipiyn. Ñin omiŋal nokom yand yip mindiy, yikop mindpay. ");
INSERT INTO kmh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kuyip yiwan nep aŋgyoken, gunap paryomb okok nimb opay rek, kinjeŋnamb okok amiy, windin mayn apek milokniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aŋgek, binuk gok aŋgyak, “Miñmon nep namb akniy, keñmaŋgiy akay nimb diy ñinjun?” ");
INSERT INTO kmh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aŋgey, Jiysis aŋgak, “Biret nimb yerip yerip mindip?” Aŋgek, “Onep ar ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kun aŋgey, Jiysis biynimb gok kuyip aŋgek bisgiyakniŋ, biret onep ar kun ak diy, Gor nup tep aŋgiy, tipaŋgiy binuk gok kuyip ñek, kiyk diyiŋg biynimb gok kuyip bilok ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Piys sikoy kaw bap di mindeyak ak sek ñey, Gor nup tep aŋgiy ñek, bilok ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","10","Ñey, ñimbey ñimbey kuyip giy aŋgakniŋ, Jiysis binuk gok wand onep ar ak diy, day day mindek gok yiŋgey arachakak. Bi tap ñiŋyak kun gok, pow tawsin rek. Jiysis pen, biynimb kun gok kuyip aŋgyokiy, binuk gok yip bot diy, miñmon Dalmaniwra amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bi Peresiy gunap Jiysis nup nembnemb gon yerip rek aŋgnimuŋ aŋgiy, ap nuk yip minim aŋg amiy apiy giy aŋgyak, “Tap mageprek bap semb biyoŋ nimb gey, chin niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kun aŋgey, nup yiruk gakniŋ aŋgak, “Biynimb miñiy mindpay ñin biy, yenen apay, ‘Tap mageprek semb biyoŋ nimb bap gey niŋun apay?’ Yand nimbip niŋind yimb aspiyn. Gor nimbip tap mageprek kun ak rek bap ma gek niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kun aŋgiy, kuyip kirgiy, binuk gok yip ñiŋg tikiy kind bindoŋ amniŋg, bot diy saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pen binuk gok sakiy giy, biret kuŋay mer: nokom bap dand amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Namb okok amyiŋg, Jiysis kuyip aŋgak, “Peresiy yiys kiyk ak sek, Herot yiys nuk ak sek ma ñiŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kun aŋgek, binuk gok kiyk key aŋgniŋ aŋgniŋ giy aŋgyak “Biret gunap sek ma dowpun rek asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jiysis pen, kiyk aŋgyak kun ak key niŋiy aŋgak, “Yenen, biret dand ma owpun aŋgiy aspim? Nimbip gos tep mayak ak mey, niŋrep ma gipim? ");
INSERT INTO kmh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Windin ayak ak ma niŋbim? Pen timund ayak ak ma niŋbim? Akaŋ niŋiy sakiy gipim. ");
INSERT INTO kmh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bi payp tawsin mindeyak ñin ak, biret onep mamind ak di tipaŋg ñenik, ñimbiy kirgiyak gok, wand yerip yerip yiŋgpik?” Aŋgek, “Wand anep wimiŋgan ak yiŋgnuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kun aŋgeyak aŋgak, “Pen bi pow tawsin mindeyak ñin ak, biret anep ar ak di tipaŋg ñen, ñimbiy day day kirgiyak gok wand yerip yerip yipik?” Aŋgek aŋgyak, “Wand onep ar ak yiŋgnuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aŋgey aŋgak, “Pen nimb gos kun ak ma niŋiy sakiy gipim?” ");
INSERT INTO kmh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pen kiyk miñmon Betsayda kind bindoŋ amjakyakniŋ, biynimb gunap bi windin koy gak bap dand apiy, Jiysis nup aŋgyak, “Nup diniŋan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aŋgeyak, Jiysis bi windin koy kun anup ñin kind ak diy, poŋind gol okok amiy, windin nup ak kuñik giñiy, nup diniŋiy aŋgak, “Tap gunap niŋsipan akaŋ aŋgek,” ");
INSERT INTO kmh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","“Yaw. Biynimb gok niŋsipiyn ak pen, mon bind rek gok giraspay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aŋgek, Jiysis tip ak windin maŋgiy nup ak diniŋek, day tap okok maŋgiysek niŋkind yimb aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pen Jiysis bi kun anup aŋgak, “Tip ak andkind biynimb mindpay bindoŋ ma amnimin; korip nak yipund giy amnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jiysis binuk gok yip miñmon Siysariya Piyliypay amniŋg saŋdiyak. Kinjeŋnamb okok amyiŋg kuyip aŋgak, “Biynimb gok, yip an aŋgiy niŋbay?” ");
INSERT INTO kmh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aŋgek aŋgyak, “Biynimb gunap nip Jon bi ñiŋg pikñemb ak apay; gunap Yilayja apay; gunap bi Gor minim aŋgep bap apay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aŋgeyak, Jiysis kuyip aŋgak, “Nimb pen yip an aŋgiy niŋbim?” Aŋgek, Piyta aŋgak, “Nand nep mey, Jiwda Kiyŋ yomb key yimb per kond mindyiŋgipun ak nep aŋgiy niŋbun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aŋgek, Jiysis aŋgak, “Biynimb okok kuyip minim kun ak ma aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jiysis pen, binuk gok kuyip minim aŋgñiyiŋg aŋgak, “Bi bap Ñinuk yiwur yomb yimb diniŋgamb. Biyomb minim tuŋgasikep gok sek, biyomb Gor nup simboŋgep gok sek, bi low tiysa gok sek nup miluk niŋiy pikayeniŋgambay kumiy, ñin omiŋal nokom mindiy, tip ak tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jiysis minim kun ak miseŋ aŋgek, Piyta nup dand gol okok amiy, aŋg giyiŋg aŋgak, “Minim kun ak rek ma aŋgnimin. Nip kun ak rek ma giniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jiysis tuŋgandikiy binuk gok kuyip niŋiy, Piyta nup aŋgak, “Seytan! Key okok amnoŋ! Gor gos ñimb rek ma aspan; biynimb gos key niŋbay rek niŋiy aspan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kun aŋgiy, binuk gok sek, biynimb kuŋaynep ap mindeyak gok sek suk aŋgek, kiñiŋ siŋak apeyak aŋgak, “Biynimb yip ker mindniŋg giniŋgiy gok; tap yerip man ar biy gos niŋbay ak kirgiy, pumbnamb kisyimken yip kisen giy, miker yomb dep akaŋ, kumemb gos ak sakiy giy, yip nep chiŋgiy taŋgeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Biynimb Jiysis nup diy mindon, tep ma giniŋgamb aŋgiy niŋniŋgambay gok; pisnep apyap pikniŋgambay. Pen biynimb Jiysis nup diy, minim tep nup diy mindon, chinup timey giniŋgambay ak minim ma mindip aŋgiy gey amniŋgamb gok; Gor gek perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Pen nimb tap man ar biy dun aŋgiy gem amek, gos yomb nimbik ak ar kun anep ameniŋgamb; perper mindenimimb rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Akaŋ, tap yerip rek Gor nup yomem, nuk pen nimbip gek perper mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kun ak, biynimb an biynimb tap siy tap timey gipay namb ak mindyiŋg, nambiŋ ginimuŋ rek ayek niŋiy, Jiysis nup gosimb ma niŋbun aŋgniŋgambay ak, kisen kuyip simb giniŋgamb. Yenen: Bi bap Ñinuk Nop aŋgek, enjol melik tep gok sek winiŋgamb ñin ak, Nop nuk anup aŋgniŋgamb, ‘Biynimb kun gok yand ma niŋbiyn aŋgniŋgamb aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pen Jiysis kun aŋgiy, minim bap aŋgak, “Minim aspiyn biy niŋrep ginimimb! Nimb biynimb mindpim guniy gunap kim mindpikniŋ, Gor biynimb diy kond mindeniŋgamb ñin ak, Jiwda Kiyŋ yomb key yimb ak, yimb yomb sek apek niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pen kisen ñin onep kaŋgol ak mindiy, Jiysis gak: Piyta ak, Jemis ak, Jon ak kuyip yakam poŋind, miñmon dum yiy akyoŋ bap amniyak. Amiy, Jiysis nup niŋey mumbwak nup ak key yimb ayak. ");
INSERT INTO kmh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Chech nuk ak tundrimey yimb giy, ñiñakol yimb gak. Pen biynimb man ar biy bap chech gunap wasyim gey, tund kun ak rek, aynimuŋ rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pen won kun ak niŋyak; Mosis yip Yilayja yip ap, Jiysis yip minim aŋgerik. ");
INSERT INTO kmh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kiyk niŋiy, Piyta Jiysis nup aŋgak, “Tiysa. Chin tep yimb ap biy mindpun! Kun ak chin korip bandak band omiŋal nokom ginjun; nip bap, Mosis nup bap, Yilayja nup bap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kiyk yakam pirikyak rek, Piyta aŋgnim kun aŋgiy niŋrep giy mer, monmon kun aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pen semb ak ap kuyip yiw gakniŋ, minim bap semb namb kun ak aŋgak, “Ak Ñi mapin yand yimb. Minim aŋgnimuŋ rek niŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kun aŋgakniŋ, kiyk niŋkuskus giy niŋyak, bi omiŋal kun ak ma minderik; Jiysis nep mindek. ");
INSERT INTO kmh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pen dum biyoŋ kirgiy, apyapyiŋg, Jiysis aŋgak, “Dum biy apambun tap gamb niŋbim ak, miñiy biynimb gunap kuyip ma aŋgñinimimb. Kisen Bi bap Ñinuk kumiy tikjakek, miseŋ aŋgñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aŋgek, kiyk minim kun ak niŋind aŋgip aŋgiy, biynimb gunap kuyip ma aŋgñiyak, kiyk keynep aŋgniŋ aŋgniŋ giy aŋgyak, “Kumiy tikjakniŋgayn aŋgip minim kiñiŋ ak yerip?” ");
INSERT INTO kmh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kun aŋgiy, Jiysis nup aŋgniŋiy aŋgyak, “Bi low tiysa gok yenen apay, Yilayja nind apek, kisen bi kiyŋ yomb key yimb ak winiŋgamb apay?” ");
INSERT INTO kmh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aŋgeyak, Jiysis aŋgak, “Niŋind apay. Baybol buk ak tikiy aŋgyak, ‘Bi Yilayja nind apiy aŋgek, biynimb gok minj moka giy mindyakniŋ, Bi bap Ñinuk ak kisen winiŋgamb aŋgyak.’ Pen biynimb gok Bi bap Ñinuk nup ma diy, yiwur yomb ñiniŋgambay aŋgyak minim ak, nimb ma niŋbim? ");
INSERT INTO kmh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pen bi Yilayja aŋgyak kun ak, kisen winiŋgamb aŋgiy gos ak ma niŋnimimb. Nup nind tikey yomb giy, minim aŋgñakniŋ nup timey yimb giyak. Kun ak Baybol buk ak tikiy, giniŋgambay aŋgyak rek nep gak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pen kiyk biyaŋ amiy niŋyak; bi low tiysa gunap, Jiysis binuk onep anjip gok yip penpen aŋg mindyakniŋ, biynimb kuŋaynep ap kuyip piŋiy kuskus gi mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kun giy niŋmindyakniŋ, Jiysis apchakek jiw di giy, am nup wasiw aŋgdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jiysis binuk gok kuyip aŋgniŋiy aŋgak, “Yenen pen aŋgek pen aŋgek gispim?” ");
INSERT INTO kmh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Kun aŋgakniŋ, bi bap biynimb mindeyak namb kun ak nimb aŋgak, “Tiysa. Ñiyand ak kichekiy abaŋ ayek, minim ma aŋgip. Ñin gunap nup tapin gek, apyap pikiy, meŋg sipyimiy, kosimb asimb apiy, ñin tomb yindgiy gip. Per kun gek gek mey, dand opiyn ak pen; binak gok kuyip aŋgen, kichekiy ak aŋgyok merniŋ kirpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kun aŋgek, Jiysis kuyip aŋgak, “Nimb biynimb miñiy mindpim ar biy, Gor nup gosimb ma niŋbim. Ñin akay nup gosimb niŋiy, tap kun gok key giniŋgambim? Minim per aŋgen niŋbim ak, yergiy minim kilsek aŋgen niŋniŋgambim? Ñi kun ak dand mindpiyn biy wim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aŋgek, dand mindek kiñiŋ siŋak apey, kichekiy ñi kun anup abaŋ ayak ak, Jiysis nup niŋiy, ñi anup gek apyap pikiy, andik mandik gakniŋ, kosimb asimb apiy amnak. ");
INSERT INTO kmh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kun gek, Jiysis ñi kun ak nop nup aŋgniŋiy aŋgak, “Tap kun ak, ñin akay rek gak?” Aŋgek aŋgak, “Wosrey ñiskoy miŋg gak. ");
INSERT INTO kmh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kichekiy kun ak, nup per pikayin aŋgiy, mon yinimb namb okok sek, ñiŋg namb okok sek diyokip. “Kun ak chirupapiy simb niŋiy, tap kun ak aŋgyokep rek ayek, aŋgyokan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aŋgek, Jiysis aŋgak, “Yenen aŋgyokep rek ayek, aŋgyoknimin aspan; yand tap okok maŋgiysek ginim anep mindip. Nand nep mey, yip aŋgniŋbiyn rek giniŋgamb aŋgiy niŋey mey, apan rek giniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aŋgek aŋgak, “Kun giniŋgamban aŋgiy gos ak niŋbiyn ak pen, gos omiŋal niŋnim rek ayip ak, yip gos tep yimb ñinimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pen biynimb kuŋaynep ap nan-giyakniŋ, Jiysis kichekiy anup aŋgak, “Nand bi biynimb gey timund pil giy, minim ma apay ak, nip aspiyn: ñi anup pisnep kiriŋg amnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aŋgek, kichekiy kun ak wal aŋgiy, ñi anup gek apyap pikiy, jep di di wosgek, kumimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kun aŋgyak ak pen, Jiysis nup di jakñak. ");
INSERT INTO kmh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kisen Jiysis korip miŋgan amiy, binuk gok yip, kiyk nep mindyiŋg, nup aŋgyak, “Yenen chin kichekiy kun anup aŋgyok mer niŋbun?” ");
INSERT INTO kmh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aŋgeyak aŋgak, “Kichekiy kun ak rek yikop ma aŋgyokpay; Gor nup aŋgniŋey mey, aŋg mis yokniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jiysis binuk gok poŋind miñmon kun ak kirgiy, Kapaniyam amniŋg, saŋdiyak. Galiyliy namb okok amyiŋg, binuk gok kuyip minim aŋgñirep ginim aŋgiy, kapkap weyiŋg mindyiŋg, kuyip aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Aŋgñiy aŋgyiŋgip, “Bi bap Ñinuk nup pikayey kumiy, ñin omiŋal nokom mindiy, tip ak tikjakniŋgamb aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nuk aŋgakniŋ, minim kiñiŋ kun ak yerip aŋgip aŋgiy, nup aŋgniŋniŋgiy ak pen; jel gek ma aŋgniŋyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Pen kinjeŋnamb okok amyiŋg binuk gok, nimb mer yand nep biyomb mindpiyn aŋgyiŋg, penpen aŋgey amnak. Am Kapaniyam amjakiy, korip miŋgan ak amiy, Jiysis kuyip aŋgniŋiy aŋgak, “Nimb kinjeŋnamb okok apyiŋg, minim yerip aŋgem apamb?” Aŋgek, minim kun ak aŋgey awak ak niŋiy, pen ma aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma aŋgñeyak, Jiysis am bisgiy kuyip aŋgek apeyak aŋgak, “Biynimb yomb mindniŋg giniŋgiy gok, biynimb yikop woŋg giñimbay rek gok mindiy, biynimb gunap kuyip woŋg giñiniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kun aŋgiy, ñapan sikoy bap dap mindeyak namb siŋak ay, kaygiyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Biynimb yip gosimb niŋiy, ñapan sikoy biy rek direp giniŋgambay gok, kuyip nep mer, yip sek diniŋgambay. Pen yip diniŋgambay ak, yip nep mer, Biyomb yip aŋgyokek winik ak nup sek diniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pen Jon Jiysis nup aŋgak, “Tiysa. Chin niŋnuk: bi bap yimb nip ak aŋgiy, kichekiy malñiluk aŋg mis yokek niŋiy aŋgnuk, ‘Nand bi chin yip jimñiy ma tapun ak, kun ma ginimin aŋgnuk.’” ");
INSERT INTO kmh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aŋgek, Jiysis nup aŋgak, “Nup yenen mer apim? Bi yip gosimb niŋiy, tap mageprek gunap giniŋgambay gok, kisen andikiy yip minim timey ma aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Biynimb chinup miluk ma niŋbay gok, biynimb chin mindiy mey; chinup miluk ma niŋbay. ");
INSERT INTO kmh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pen niŋim! Biynimb nimbip Jiysis binuk aŋgiy, ñiŋg malñey ñiŋniŋgambim gok, Gor kuyip direp giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pen biynimb gunap, biynimb yip gos kilis giy ma niŋbay bap gey apyap pikniŋgamb ak, timey yimb giniŋgambay. Kuyip nind tiwniŋg dam ñiŋg yokpiyap ak girep gipyap. Yenen: kim mindiy timey giniŋgambay kun ak, yiwur yomb diniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kun aŋgiy aŋgak, “Ñin maŋgiy ak tap siy tap timey giniŋg gonimuŋ, piskind kun ak timbrik yokem; piskind anep mindonimuŋ. Kun ak yiwur tap ak pen; sikoy won bap nep giniŋgamb. Pen tap siy tap timey ma giniŋgambim rek, kim amniŋgambim. Mer ak: miñmon Hel, mon yin nep mindip ak amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Miñmon kun ak kuyip kisow pernep ay mindyiŋg, mon yin nep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Tomb kind bap timey giniŋg gonimuŋ, piskind kun ak timbrik yokem; piskind anep mindonimuŋ. Kun ak yiwur tap ak pen; sikoy won bap nep giniŋgamb. Pen tap siy tap timey ma giniŋgambim rek, kim amniŋgambim. Pen tomb omiŋal giy mindek, timey gem, nimbip aŋg Hel yokek yiwur yomb diniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Miñmon kun ak kuyip kisow pernep ay mindyiŋg, mon yin nep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Pen windin maŋgiy ak gek, tap siy tap timey gep rek ayonimuŋ, windin piskind kun ak tuŋgjiwyoknimimb. Kun giy kapkap mindrep giy, Gor nimbip diy kond mindonimuŋ rek ayip. Pen omiŋal giy mindek, tap siy tap timey gem nimbip miñmon Hel aŋgyokek, yiwur yomb diniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Miñmon kun ak kuyip kisow pernep ay mindyiŋg, mon yin nep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Gor biynimb maŋgiysek yip gosimb niŋniŋgiy aŋgiy, kuyip miker gunap ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol tap yindik tep yimb ak pen, yindik nuk ak amek, yergiy gem tip ak yindik giniŋgamb? Kun ak, nimb biynimb yindik gok kapkap aw aŋgiy mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jiysis Kapaniyam kirgiy, Jiwdiya miñmon namb okok amiy, am Joden ñiŋg tikiy, pis bindoŋ amnak. Amek, biynimb gok niŋiy, ap nan-geyak, nuk per giyiŋgip rek kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bi Peresiy gok Jiysis yerip rek aŋgniŋgamb aŋgiy, mindek ak apiy, aŋgniŋiy aŋgyak, “Bi gok biyn diy, aŋgyokniŋg aŋgyokniŋgambay akaŋ, yerip gos niŋban?” ");
INSERT INTO kmh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aŋgeyak, Jiysis aŋgak, “Mosis minim yerip aŋgiy tikak?” ");
INSERT INTO kmh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aŋgek aŋgyak “Mosis aŋgak, ‘Biyn aŋgyokniŋg; nip aŋgyoksipiyn aŋgiy, nup ñiwkil band bap tikñiy aŋgyoknimuŋ aŋgak’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aŋgeyak, Jiysis aŋgak, “Minim aŋgñey kasek ma dipim rek, Mosis minim kun ak tikak. ");
INSERT INTO kmh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pen Gor miñmon alwol gayak ñin ak, bi gay biyn gay gak. ");
INSERT INTO kmh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ar kun ak mey, bi gok nop nonim sikop yip mindiy, biyn diyiŋg kuyip kirgiy, ");
INSERT INTO kmh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kiykber jimñiy kiner mumbwak nokom ayip. Gor aŋgek mumbwak nokom yimb ayniŋgamb kun ak, ");
INSERT INTO kmh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","bi gunap tikjakiy, kuyip aŋg tuŋgasik keykey ma ayniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kun aŋgiy, binuk gok yip tip ak korip miŋgan biyaŋ amiy, ");
INSERT INTO kmh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","nup minim kun ak tip aŋgniŋeyak aŋgak, “Bi gok biyn diy aŋgyokiy, biyn kisenimb diniŋgambay ak, tap siy tap timey giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pen biyn gok kunep bi diy kirgiy, bi kisenimb diniŋgambay ak, tap siy tap timey giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Biynimb gunap, Jiysis ñapan chinup gok bilesiym gaŋ aŋgiy, dand apey, binuk gok kuyip aŋg geyak, ");
INSERT INTO kmh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jiysis kuyip pen aŋg giy aŋgak, “Ñapan sikoy gok kirgem yip ker wiyaŋ. Gor biynimb nuk diyn aŋgiy niŋimb mey kun gok rek. ");
INSERT INTO kmh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Biynimb yomb gok, ñapan ŋaŋ Gor ker opay rek ma apeniŋgambay, kuyip ma diniŋgamb. Nimbip niŋind yimb aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kun aŋgiy, ñapan ŋaŋ gok kuyip kaygiy, ñin jun ar ay aŋgak, “Gor nimbip kond mindonimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pen Jiysis amnakniŋ, bi bap puŋgrikind aŋgiy amek kiñiŋ siŋak koŋgim yimiy aŋgak, “Tiysa tep yimb! Yand yerer gen, Gor gek perper mindeniŋgayn?” ");
INSERT INTO kmh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aŋgek, Jiysis aŋgak, “Yip yenen tiysa tep yimb apan? Biynimb bap tep yimb ma mindpay; Gor nokom mey bi tep yimb mindip. ");
INSERT INTO kmh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pen nand niŋban: Gor low anep wanjrem biyoŋ aŋgip, ‘Chip ma ñaŋgnimimb; biyn siy bi siy ma ginimimb; tap siy ma dinimimb; yesek ma aŋgnimimb; yesek yesek aŋgyiŋg biynimb gunap tap gok ma taw piliŋg dinimimb; nap nanim aŋgnimiyr rek niŋnimimb aŋgip’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kun aŋgek, bi kun ak Jiysis nup aŋgak, “Tiysa. Yand ñiskoy miŋg tikiy, low kun gok niŋyiŋg mindpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aŋgek, Jiysis nup wasemb ay aŋgak, “Tap nokom bap nep ma gipan. Amiy, tap nand yerip yerip mindip gok yokiy maniy diy, biynimb tap ma mindip gok kuyip ñinimin. Kun giy mey, mindrep gep nand ak mindeniŋgamb Gor miñmon biyoŋ. Apiyn rek giy apiy, yand yip taŋgonjur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kun aŋgek, bi kun ak tap nuk kuŋay mindek rek, simb gek gos par yimb ayiŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jiysis binuk gok kuyip niŋkuskus giy aŋgak, “Biynimb tap kuŋay mindeniŋgamb gok kosyam yimb Gor biynimb nuk mindey, kuyip diy kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kun aŋgek, gos kuŋaynep niŋeyak, kuyip tip ak aŋgak, “Ñapan yand guniy. Gor biynimb nuk mindniŋg, kosyam yimb biynimb nuk mindeniŋgambay! ");
INSERT INTO kmh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kanj kamel gok ñiw lekpay miŋgan ak amniŋg, kasek amniŋgiy rek ayniŋgamb; biynimb maniy tap kuŋay mindip gok, kosyam yimb Gor nup gosimb niŋey, kuyip diy kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kun aŋgek, binuk gok wal yimb aŋgiy, pen aŋgniŋek pen aŋgniŋek giy aŋgyak, “Kun ak Gor biynimb yerip rek gok diy kond mindeniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aŋgeyak, Jiysis kuyip niŋyiŋg aŋgak, “Biynimb gok key giniŋgiy rek ma ayip; Gor nep mey yerer giniŋg, ginimuŋ rek nep mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pen Piyta Jiysis nup aŋgak “Niŋan! Chin nand yip taŋgniŋg, tap chin gok maŋgiysek kirpun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Aŋgek aŋgak, “Biynimb yip gosimb niŋiy, minim tep woŋg ak giniŋg: korip miñmon kiyk kirgiy akaŋ, numam nunay kiyk kirgiy akaŋ, nop nonim kiyk kirgiy akaŋ, ñapan kiyk gok kirgiy akaŋ, tap woŋg kiyk gok kirgiy taŋgeniŋgambay ak; Gor kuyip direp yimb giniŋgamb. Kuyip kond mindek lum ar biy mindeniŋgambay ñin ak, nop, nonim, numam, nunay, ñapan, korip, tap kiyk gok kuŋay yimb mindeniŋgamb. Pen ñin gunap biynimb yikop gok, yip ker mindpay rek niŋiy kuyip timey giniŋgambay. Pen kisen Gor kuyip dand miñmon nuk amek, pernep mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Biynimb kuŋaynep miñiy mindrep gipay gok, kisen mindrep ma giniŋgambay; biynimb kuŋaynep miñiy kosyam mindpay gok, kisen mindrep giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pen kiyk Jerusalem amyiŋg, Jiysis nind gak; binuk gok kisen giy gospar ayiŋg amniyakniŋ, biynimb kisen giy apeyak gok niŋiy pirikyak. Jiysis pen, binuk onep wimiŋgan ak kuyip poŋind gol siŋak amiy, tap nup yerip giniŋgamb ak kuyip aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Aŋgñiyiŋg aŋgak, “Niŋim; Jerusalem amon, Bi bap Ñinuk nup dam biyomb Gor nup simboŋgep gok sek, bi low tiysa gok sek kuyip ñeniŋgambay, nup kor giy ñaŋgbirik ayep aŋgiy, di bi Jiwda mer gok kuyip ñey, ");
INSERT INTO kmh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nup aŋgjiwiy, kiñuk giy, miñ diy pikiy, dam pisnep pikayeniŋgambay kumniŋgamb. Pen ñin omiŋal nokom mindiy, tip ak tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebediy ñinuk Jemis yip, Jon yip ñin bap ap Jiysis nup aŋgrik, “Tiysa. Chirmiŋay nip minim bap aŋgniŋniŋg gispur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kun aŋgerik, Jiysis aŋgak, “Yip aŋgniŋniŋg gispiyr kun ak, nirip yerginim?” ");
INSERT INTO kmh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aŋgek aŋgrik, “Kisen nand Biyomb yimb mindiy, miñmon maŋgiysek kond mindeniŋgamban ñin ak, chirupmiŋay bi kond mindep aŋgiy, bap ñin yipund kind okok ken, bap ñin aŋind kind okok ken mindonjur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kun aŋger, Jiysis nuk yiwur diniŋgamb rek aŋgiy aŋgak, “Nirmiŋay niŋrep giy ma aspiyr. Ñiŋg silik yand ñiŋniŋgayn ak nirmiŋay kunep ñiŋniŋgayr? Miker yand diniŋgayn ak kunep diniŋgayr?” ");
INSERT INTO kmh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aŋgek, “Yaw aŋgrik.” Aŋgerik, Jiysis aŋgak, “Niŋind apiyr ak pen; ");
INSERT INTO kmh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ñin yipund kind ak an mindeniŋgamb, ñin aŋind kind ak an mindeniŋgamb ak yand ma aŋgniŋgayn; ak Bapiy tap nuk; nuk key niŋimb rek giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pen Jiysis binuk onep wanjrem ak minim kun ak niŋiy, Jemis yip, Jon yip kuyip kuŋay aŋgniŋg geyak, ");
INSERT INTO kmh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jiysis kuyip maŋgiysek aŋgek apey aŋgak, “Nimb niŋbim: miñmon okok, biyomb yimb gok biyomb namb kayaŋ gok kuyip kond mindey, biyomb namb kayaŋ biyomb kayaŋ gok kuyip kond mindey, kiy pen biynimb gok kuyip kond mindpay. ");
INSERT INTO kmh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pen nimb kun ak rek ma ginimimb. Bi nimb bap biyomb mindniŋg ginimuŋ ak, biynimb gok kuyip woŋg giñinimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pen biyomb yimb mindniŋg ginimuŋ ak, biynimb gok kuyip monmon yimb woŋg giñinimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bi bap Ñinuk kunep, yip woŋg giñiyaŋ aŋgiy lum biy ma awak; biynimb Gor nup kirpay gok kuyip nen kumiy, di Gor yip jimñiy ayin aŋgiy owak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jiysis binuk gok yip miñmon Jeriykow kirgiy amniŋg, biynimb kuŋaynep yip amniyak. Bi Timiyas ñinuk Batiymeyas windin koy gek, kinjeŋ gol siŋak bisiŋg mindyiŋg, maniy tap gok nen asimb aŋg mindek. ");
INSERT INTO kmh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aŋg mindakniŋ, Jiysis bi Nasaret nimb asaw aŋgey niŋiy, nuk suk aŋgiy aŋgak, “Jiysis, Depiyt Ñinuk. Yip simb niŋan aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aŋgek, biynimb gok nup aŋg giy aŋgyak, “Ma aŋgan! Kapkap mindey aŋgyak.” Kun aŋgyak ak pen, nuk kapkap ma mindek, suk yomb aŋgiy aŋgak, “Depiyt Ñinuk yip simb niŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aŋgek, Jiysis maŋ kun siŋak apiy aŋgak, “Nup aŋgem awaŋ.” Aŋgek, biynimb gok bi windin koy anup aŋgyak, “Jiysis nip asap nen; tikjakiy gos sek winimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aŋgeyak, chech parsek nuk ak tuŋgasik yokiy, Jiysis mindek ak kasek amnak. ");
INSERT INTO kmh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Amek, Jiysis nup aŋgak, “Yip yergaŋ aŋgiy aswan?” Aŋgek aŋgak, “Tiysa. Windin ak tip niŋiyn aŋgiy aswiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aŋgek, Jiysis aŋgak, “Tep. Yip gek suŋ ayniŋgamb aŋgiy gos niŋban rek, suŋ ayip nen, amnoŋ aŋgak.” Kun aŋgakniŋ, day windin yimb niŋiy, Jiysis yip amnak. ");
INSERT INTO kmh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jiysis binuk gok yip am am Jerusalem maŋ maŋ giyiŋg, Oliyp dum amiy, miñmon Betpasiy sek, Beteniy sek amjakiy, Jiysis binuk omiŋal nind aŋgyokiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Miñmon wikan bindoŋ amiy niŋniŋgayr: kanj doŋgiy marip biynimb ma dand tapay bap tiwniŋg ayey mindeniŋgamb. Niŋiy, wisik dand winimiyr. ");
INSERT INTO kmh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Biynimb gunap nirip yenen kun gispiyr aŋgeniŋgiy aŋgnimiyr ‘Biyomb ak woŋg bap giy, tip ak yokek winiŋgamb aŋgnimiyr’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kun aŋgek, amiy niŋrik: doŋgiy marip ak, korip kinjeŋrumb gol siŋak tiwniŋg ayey mindek. Wisik girikniŋ, ");
INSERT INTO kmh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","biynimb yep maŋ kun okok mindeyak gok aŋgyak, “Yerginiŋg, doŋgiy marip kun ak wisiksipiyr?” ");
INSERT INTO kmh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aŋgeyak, Jiysis aŋgak rek aŋgerik, yaw aŋgey, ");
INSERT INTO kmh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","doŋgiy marip kun ak dand Jiysis mindek ak apiy, chech paryomb kiyk ar biyoŋ ayrik gok tuŋgasikiy, di doŋgiy ar ayerik, Jiysis ar kun ak bisgak. ");
INSERT INTO kmh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Biynimb gok: gunap chech parsek kiyk gok tuŋgasik kinjeŋram ar ak ayiŋg; gunap tap kas gok tipaŋg dap ayiŋg, nup di namb ay, ");
INSERT INTO kmh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","biynimb gunap nind giyak, gunap kisen giy, suk yomb aŋgyiŋg aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Gor nup yimb dand aranjun! Biyomb chinup yokip biy, kond mindrep ginimuŋ! Basind Depiyt kiyŋ mindiy biynimb kond mindyiŋgip rek chinup giniŋgamb! Gor nup tep yimb aspun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jiysis kun giy Jerusalem amiy, Gor nup aŋgniŋep korip miŋgan ak amiy, tap okok niŋraŋgakniŋ, pumb paŋind amek niŋiy, binuk onep wimiŋgan ak yip andkind Beteniy amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Minek pen, Beteniy nimb andkind kinjeŋnamb okok apyiŋg, Jiysis nup yiwan gek, ");
INSERT INTO kmh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","par chim niŋak; mon kiyaw bind bap mindek. Maŋgiy gunap piy mindip akaŋ aŋgiy amiy niŋak; ma piyak. Yenen: maŋgiy nuk piyep ñin ak ma awak. ");
INSERT INTO kmh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kun gek, Jiysis aŋgak, “Mon bind kun gip ak, kisen ma piyek ñiŋniŋgambay aŋgak.” Kun aŋgek, binuk gok maŋgiysek niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jiysis binuk gok poŋind Jerusalem amiy, Gor aŋgniŋep korip miŋgan biyaŋ amiy niŋak: biynimb gok sikyim giyiŋg, maniy seniys giyiŋg gi mindeyak. Kun geyak, maniy seniys giyiŋg, yakir dap ayey tawyiŋg gi mindeyak boŋg ar gok tuŋgandikiy, biynimb sikyim giyiŋg tap tawyiŋg gi mindeyak gok maŋgiysek yuk mis yokak. ");
INSERT INTO kmh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yuk yokiy aŋgak, “Kisen biynimb bap, tap gunap dand Gor aŋgniŋep korip kamb wariy kusgiy mindip namb biy ma pandiknimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kun aŋgyiŋg aŋgak, “Baybol buk ak tikiy aŋgyak, ‘Gor aŋgip “Korip yand ak biynimb miñmon okok maŋgiysek ap yip aŋgniŋniŋgambay aŋgip” aŋgyak.’ Pen nimb kun gem, bi tap siy diy weyiŋg mindpay korip bap rek ayip aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kun aŋgek, bi low tiysa gok sek, bi lotiw korip kond mindep gok sek nup pikayun aŋgiy niŋyak ak pen; biynimb maŋgiysek minim nup niŋyak rek, nup yergiy pikayjun aŋgiy gos gunap niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Duŋgep won ak, Jiysis binuk gok yip Jerusalem kirgiy Beteniy amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Minek kiyk andkind kinjeŋnamb okok apiy, Piyta aŋgak, “Tiysa. Niŋan! Kiyaw bind kisen ma piyek ñiŋniŋgambay aŋgnak biy, pisnep milip giyowip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Aŋgek, Jiysis aŋgak, “Biynimb an miñmon yirik akaŋ, tap bap kuyip kinjeŋ tikonimuŋ, Gor nep gek keykey siŋbindoŋ amniŋgamb aŋgiy, nup aŋgniŋey, aŋgniŋgambay rek giniŋgamb. Pen giniŋgamb akaŋ ma giniŋgamb aŋgiy gos niŋniŋgambim ak, ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gor giniŋgamb aŋgiy, gos nokom niŋiy aŋgniŋem, aŋgniŋgambim rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pen nup aŋgniŋniŋg, biynimb minim mindip gok kuyip niŋiy kirgem mey, Nap semb biyoŋ mindip ak, tap siy tap timey nimb gipim gok, pen kunep niŋiy kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kun ma geniŋgambim, nimb pen gipim gok niŋiy ma kirginiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pen Jiysis binuk gok yip Jerusalem apchakiy, Gor aŋgniŋep korip miŋgan ak giraŋgakniŋ, bi Gor nup simboŋgep yomb gok sek, low tiysa gok sek, bi minim tuŋgasikep gok sek Jiysis mindek ak apiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Nip an kun ginimin aŋgek, girapan?” ");
INSERT INTO kmh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aŋgeyak aŋgak, “Yand nimbip minim bap aŋgniŋen, yip pen aŋgñeniŋgambim mey, yip an aŋgek girapiyn ak aŋgñiniŋgayn! ");
INSERT INTO kmh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon biynimb gok kuyip ñiŋg pikñak ak, Gor aŋgek pikñak akaŋ, gos nuk key niŋiy pikñak? Yip aŋgñem niŋiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kun aŋgek, kiyk key aŋgniŋ aŋgniŋ giy aŋgyak, “Chin aŋgniŋgambun: Gor aŋgek biynimb gok kuyip ñiŋg pikñak aŋgon, yenen minim nup ak ma dipim aŋgniŋgamb; ");
INSERT INTO kmh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","pen Jon gos nuk key niŋiy gak aŋgon, biynimb guniy, Gor aŋgek woŋg nup giñiyiŋgip aŋgiy niŋbay rek, Gor nup aŋgjiwsipay aŋgiy, chinup kamb silok pikayniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gos kun ak niŋiy, “Chin ma niŋbun aŋgyak.” Kun aŋgeyak, Jiysis kuyip aŋgak, “Nimb yip ma aŋgñimbim rek, yip an aŋgek girapiyn ak nimbip pen ma aŋgñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pen Jiysis kuyip paydoŋ ay aŋgak, “Bi bap wariy giy, miñ wayn woŋg ak gi yimiy, wayn maŋgiy piksimbjakep aŋgiy, kiwok bap gayrep giniŋgamb. Biynimb ap miñ maŋgiy siy diniŋgambay ak niŋmindenjun aŋgiy, korip kiyoŋgiy paryomb bap giy, bi gunap kuyip aŋgniŋgamb, ‘Nimb miñ woŋg yip ak kond mindiy, kisen pik gek, yip gunap, nimb gunap dinimimb aŋgiy,’ miñmon paryomb okok amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wayn maŋgiy pik giniŋgamb ñin ak, binuk bap aŋgyokiy aŋgniŋgamb, ‘Wayn maŋgiy yip gunap ñey dand winimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aŋgek amjakek, bi woŋg giniŋgambay gok nup di pik pik ay, yikop nep aŋgyokniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kun gey, bi wayn woŋg nop nimb ak, bi bap pen aŋgyokniŋgamb. Amjakek, nup jun biyoŋ pikiy, timey yimb giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kun gey, bi wayn woŋg nop nimb ak, bi bap pen yokek amek, nup pisnep pikayniŋgambay. Kun anep giyiŋg; gunap gamb pikniŋgambay, gunap pisnep pikayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kun gey gey, bi woŋg nop nimb ak binuk bap ma mindeniŋgamb; ñi mapin nuk nokom mindeniŋgamb ak, minim nup ak diniŋgambay aŋgiy aŋgyokek amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pen amjakakniŋ, biynimb wayn woŋg gi mindeniŋgambay gok niŋiy aŋgniŋgambay, ‘Ñi wip biy, bi wayn woŋg nop nimb ak ñinuk wip. Nup pikay mey, tap nuk dinimuŋ rek gok chin diniŋgambun aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kun aŋgiy, nup pisnep pikay, dam mis okok diyokniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kun geniŋgambay, bi wayn woŋg nop nimb ak apiy yerginiŋgamb? Nuk apiy, biynimb wayn woŋg geniŋgambay kun gok kuyip pikay, biynimb gunap kuyip aŋgek, wayn woŋg kun ak kond mindeniŋgambay aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kun aŋgiy, kuyip aŋgak, “Baybol buk tikiy aŋgyak, ‘Bi korip gep gok kamb par kirgiyak ak, miñiy korip sap namb yaŋ ak piŋiyñiy mindip. ");
INSERT INTO kmh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Biyomb chin kun gak ak, tep yimb gak aŋgyak’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jiysis kun aŋgek, bi low tiysa gok sek, Gor nup tap simboŋgep yomb gok sek chinup nep asap aŋgiy, nup chichiy dun aŋgyak ak pen, biynimb gok kuyip pirikiy, kirgiyak. ");
INSERT INTO kmh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pen kisen bi Peresiy gunap, Herot binuk gunap kuyip aŋgyak, “Nimb Jiysis mindip amiy, nup minim gunap aŋgniŋem, nuk yerip aŋgek, nup dam kalambis ayniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kun aŋgeyak, Jiysis mindek ak amiy aŋgyak, “Tiysa. Chin niŋbun: nand bi niŋind yimb nep apan. Biyomb yimb gok sek, biynimb yikop gok sek kuyip niŋiy ma pirikpan. Gor aŋgip rek nep niŋiy, biynimb okok kuyip yipund giy nep aŋgñimban. Kun ak chinup aŋgñan! Chin Jiwda biynimb low gok yergiy mindip: gapman biyomb Rom nimb anup takes pikep akaŋ ma pikep?” ");
INSERT INTO kmh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aŋgeyak, Jiysis minim yesek aŋgyak kun ak niŋiy aŋgak, “Yip yenen minim yesek kun ak aŋgniŋbim? Maniy maŋgiy takes pikpim bap dapem yand niŋiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aŋgek, dap ñey niŋiy aŋgak, “Maniy bak ak, an jomluk ak sek, yimb ak sek mindip?” Aŋgek aŋgyak, “Biyomb Siysa mindip.” ");
INSERT INTO kmh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aŋgeyak, Jiysis aŋgak, “Siysa yip ginimimb aŋgip gok, nup ginimimb; Gor yip ginimimb aŋgiy niŋimb gok, nup ginimimb aŋgak.” Aŋgek niŋiy, minim yesek aŋgyak kun ak silgirep gak rek, wal yimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sanjiwsiy biynimb gok, biynimb kumiy ma tikjakpay aŋgiy niŋyiŋgipay rek, gunap Jiysis mindek ak apiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tiysa, Mosis, minim bap chinup tikiy aŋgak, ‘Bi bap biyn diy, ñapan tikiy mer, yikop kumeniŋgamb, numam nuk bap pen biyn kaŋil kun ak diy, mam kumak ak ñapan nup aŋgiy tikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kun ak bi kiñiŋ sek onep ar ak mindeniŋgambay. Numam nind biyn diy, ñapan tikiy mer, yikop kumek, ");
INSERT INTO kmh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","numam namb pen biyn kun ak diy, kunep ñapan tikiy mer, yikop kumniŋgamb. Kun gek, numam ak pen diniŋgamb. Ak kunep ñapan tikiy mer, yikop kumniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kun gi dam dam numam onep ar ak ñapan tikiy mer, maŋgiysek yikop kumeniŋgambay, kisen biyn ak kunep kumniŋgamb. Pen biynimb kumiy tikjakniŋgambay apan ak, ");
INSERT INTO kmh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","biyn nokom binuk di onep ar ayak kun ak, kisen numam akay yip mindeniŋgamb?’” ");
INSERT INTO kmh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aŋgeyak, Jiysis aŋgak, “Nimb Baybol buk minim tikyak ak ma niŋbim rek, niŋind ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Biynimb kumbay gok tikjakniŋgambay ñin ak, Gor enjol nuk gok mindpay rek mindiy, biyn gok bi ma dey, bi gok kunep biyn ma diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pen biynimb tip ma tikjakniŋgambay apim ak, Mosis mon sikoy bind yin nep mindek kesim tikak ak, aŋgiy ma niŋbim rek ayip. Gor mon yinek namb ak mindiy, Mosis nup aŋgak ‘Ebraham, Aysek, Jekop Gor kiyk mey, yand mindpiyn aŋgak.’ Kun ak yenen, basind sikop nind kumyak gok kuyip, Gor kiyk mindpiyn aŋgak? Pen nimb apim rek, biynimb gok pisnep kumbiyap ak, ");
INSERT INTO kmh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gor kiyk mindpiyn aŋgiy ma apkop. Biynimb kim mindpay akaŋ kumbay ak, Gor niŋimb maŋgiysek kim mindpay. Nimb niŋrep ma gipim rek, pisnep kumbay aŋgiy niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bi low tiysa bap, Jiysis Sanjiwsiy biynimb gok kuyip aŋgrep gak ak niŋiy, ap nup aŋgniŋiy aŋgak, “Low ar akay yomb yimb?” ");
INSERT INTO kmh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aŋgek, Jiysis aŋgak, “Low yomb yimb ak, Baybol buk ak tikiy aŋgyak: ‘Yisrel biynimb niŋim! Biyomb chin Gor nep Biyomb yimb mindip. ");
INSERT INTO kmh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nup wasemb yimb ay, gos timund may may nimb ak maŋgiysek nup ker amnimuŋ aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Minim yomb yimb bap mey; ‘Biynimb gunap kuyip, nimb key wasemb yimb aypim rek, wasemb aynimimb aŋgyak.’ Low okok maŋgiysek, low yomb yimb mey omiŋal kun ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aŋgek, bi low tiysa ak aŋgak, “Tiysa, nand niŋind yimb apan. Gor nokom mey, Biyomb yimb mindip. Nuk rek gunap ma mindpay. ");
INSERT INTO kmh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chin Gor nup tap pik dam pisnep ñiniŋgambun akaŋ, yergiy simboŋg ñiniŋgambun ak tap yikop; pen gos timund may may chin ak maŋgiysek nup ker amek, nup wasemb yimb ay, biynimb gunap kuyip wasemb ayniŋgambun ak, tap yomb yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kun aŋgek, Jiysis bi ak niŋrep yimb giy aŋgip aŋgiy, nup aŋgak, ‘Nand Gor binuk kond mindeniŋgamb bap, mindniŋg gispan rek ayip aŋgak.’ Pen Jiysis minim niŋind yimb gok nep aŋgek niŋiy, biynimb gok kisen minim yesek okok nimb, nup nembnemb giy aŋgyiŋgipay rek tip ma aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jiysis kisen Gor aŋgniŋep korip ak mindiy, biynimb gok kuyip aŋgak, “Bi low tiysa nimbik gok yenen apay, ‘Depiyt tikek tik dand amiy, Biyomb chinup kond mindeniŋgamb bap tikniŋgambay apay?’ ");
INSERT INTO kmh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pen Gor Kawnan ak nup gos ñek, Depiyt key tikiy aŋgak, ‘Gor Biyomb yip anup aŋgak, “Nand ñin yipund kind yand okok ken mindiy, biynimb ñaŋgep nand gok kuyip tomb beŋ nip okok ayen, kond mindeniŋgamban aŋgak.” ’ ");
INSERT INTO kmh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kun ak, Depiyt Kiyŋ yomb key yimb ak nup, Biyomb yand aŋgak. Pen Ñinuk nup nep yergiy Biyomb yand apkop? Yikop nep kun ma apkop ak pen; Kiyŋ yomb key yimb ak, Gor Ñinuk aŋgiy niŋiy mey, Biyomb yand aŋgak.” Jiysis minim kiñiŋ aŋgrep gak rek, biynimb gok minim nup ak miñmiñ yimb giyiŋg niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Jiysis biynimb gok kuyip minim aŋgñiyiŋg aŋgak, “Niŋrep ginimimb. Bi low tiysa gok miñ kiyk ak, chech paryomb gok ay, biynimb ap nan-gipay tip ak akaŋ, lotiw gipay namb ak amon, biynimb gok aswim-ey aŋgey, yimb chinup yiy ar biyoŋ mindeŋ aŋgiy niŋbay. Tap yomb ñimbay ñin ak kunep, biynimb windin yirik ar ak bisgon, chinup niŋey, yimb chinup yiy ar biyoŋ mindeŋ aŋgiy niŋbay. ");
INSERT INTO kmh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pen biyn kaŋil korip tap kuyip gok siy diy, Gor nup minim paryomb yesek nep gok aŋgniŋbay. Gipay kun ak, yiwur yomb yimb diniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","42","Jiysis Gor aŋgniŋep korip opriyŋ dayiŋgipay maŋ siŋak bisiŋg mindiy niŋak: biynimb maniy kuŋay mindek gok, maniy kuŋaynep dap yokyak. Pen biyn kaŋil maniy ma mindek bap, maniy likañsek sikoy omiŋal dap yokek niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","binuk gok kuyip aŋgek apeyak aŋgak, “Niŋim! Biyn kaŋil biy, biynimb gunap kuyip wiyniym giy, opriyŋ yomb yimb ak Gor nup yokip. Biynimb maniy kuŋay mindip gok, maniy kiyk gunap sek mindakniŋ, opriyŋ dap yokpay; biyn kaŋil biy, maniy nuk won omiŋal mindamb anep dap yokip; nuk tap taw ñiŋnimuŋ bap ma mindip. Kun ak Gor niŋek, biynimb gunap sikoy yokpay; biyn kaŋil ak yomb yimb yokip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jiysis Gor aŋgniŋep korip ak kirgiy mis amnakniŋ, binuk bap nup aŋgak, “Tiysa. Kamb tep diy, korip kil tep giyak biy niŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aŋgek, Jiysis aŋgak, “Nand kamb korip yomb kun ak niŋey tep gek aspan? Kisen korip kun ak gi timey gey, kamb bap kamb bap ar ak ma mindeniŋgamb; pisnep pipaŋg pikey amdiniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jiysis kun aŋgiy, Gor aŋgniŋep korip ak kirgiy am Oliyp dum bisiŋg mindakniŋ; Piyta, Jon, Jemis, Enjriw kiykyakam nep apchakiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tap aŋgambun gok, ñin akay rek giniŋgamb? Pen yerip rek gek niŋiy aŋgniŋgambun, Biyomb aŋgak ñin ak, miñiy giniŋg gisap aŋgiy niŋniŋgambun?” ");
INSERT INTO kmh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Aŋgey, Jiysis kuyip aŋgak, “Niŋrep ginimimb! Biynimb kuŋaynep yesek tom giy, yimb yip ak diyiŋg aŋgniŋgambay, ‘Yand Jiysis nep aswiyn aŋgniŋniŋgambay.’ Kun aŋgey, niŋind aspay aŋgiy ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Miñmon akniy penpen gispay, miñmon okok penpen gispay aŋgeniŋgiy, gos kuŋay ma niŋnimimb. Tap kun gok rek giniŋgamb ak pen, ñin kisen ak winiŋg gisap aŋgiy gos ak ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Miñmon yomb gunap tikjakiy, miñmon yomb gunap yip penpen ñaŋgniŋgambay. Biynimb wikan gunap tikjakiy, biynimb wikan gunap yip penpen ñaŋgniŋgambay. Pen miñmon okok maŋgiysek monmon diy, yiwan yomb apiy giniŋgamb. Tap giniŋgamb kun gok, biyn ñapan ñimbamb, maŋ mindip aŋgiy niŋbay rek nep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pen niŋrep giy mindenimimb. Ñin gunap nimbip dand Jiwda kanjsol mindeniŋgambay ak amey, kor giniŋgambay. Ñin gunap nimbip Jiwda nan-gep korip okok dand amiy, kur diy pikniŋgambay. Ñin gunap Jiysis binuk aŋgiy, dand gapman biyomb mindeniŋgambay ak amey, kor giniŋgambay. Pen dand amniŋgambay rek, minim tep yip ak gapman biyomb gok kuyip aŋgñiniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pen minim tep yip ak aŋgñey, miñmon okok maŋgiysek amek nep, ñin kisen ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Pen nimbip kor giniŋg dand ameniŋgiy, minim yerip diy aŋgjun aŋgiy, gos kuŋay ma niŋnimimb. Aŋgniŋg ginimbikniŋ, Gor nimbip gos tep ñek aŋgniŋgambim. Minim kun ak nimb key ma aŋgniŋgambim; Gor Kawnan ak nuk aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Pen numam gunap tikjakiy, numam gunap kuyip ñaŋgayaŋ aŋgiy, dam biyomb gok kuyip ñiniŋgambay. Nop gok tikjakiy, ñapan kiyk key gok kuyip ñaŋgayaŋ aŋgiy, dam biyomb gok kuyip ñiniŋgambay. Ñapan gok tikjakiy, nop nonim sikop kuyip miluk niŋiy, ñaŋgniŋgiy aŋgiy dam ñiniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yip ker mindeniŋgambim rek niŋiy, nimbip miluk niŋniŋgambay ak pen; nimb biynimb an yip ma kirgiy, chiŋgiy nep mindeniŋgambim gok, perper mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tap asikep yimb bap, Gor aŋgniŋep korip miŋgan ak ayey mindeniŋgamb. Minim tiksipiyn kun biy niŋrep ginimimb. Kun gakniŋ, biynimb Jiwda propens mindeniŋgiy gok, pirik miñmon yirik okok amniŋgiy; ");
INSERT INTO kmh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","biynimb korip ar biyoŋ mindeniŋgiy gok, andkind korip miŋgan ma amniŋgiy; ");
INSERT INTO kmh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","biynimb woŋgday okok taŋgeniŋgiy gok, chech tap gok diniŋg, andkind korip ma amniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Biyn ñapan koŋgiy mindeniŋgambay gok sek, ñapan tiy ñeniŋgambay gok sek kosyam pirik amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tap giniŋgamb kun gok, Gor nup aŋgniŋem, yombip aynimuŋ ñin ak ma ginimuŋ. ");
INSERT INTO kmh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Alwol gayak ñin ak tikiy mind dand apiy mindpun ñin biy, timey kun ak rek ma gak; kisen kun ak rek ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ginep mindek, biynimb maŋgiysek kumdipyap. Pen Biyomb biynimb nuk diniŋg aŋgayak gok gosimb niŋiy, yep won bap nep ginimuŋ aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Pen ñin kun ak, biynimb gunap aŋgniŋgambay, ‘Niŋim! Jiwda kiyŋ yomb key yimb ak mindip biy; mindip bindoŋ aŋgeniŋgiy,’ niŋind apay aŋgiy ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Biynimb gunap, Gor biynimb nuk aŋgayak gok, kind chinup ak winiŋgiy aŋgiy aŋgniŋgambay, ‘Yand mey, Jiwda kiyŋ yomb key yimb ak; yand mey bi Gor minim aŋgep ak aswiyn aŋgyiŋg,’ yesek tom giyiŋg, tap mageprek gunap giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tap yerip yerip kisen giniŋgamb ak, nimbip aŋgen niŋbim ak mey; niŋrep giyiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pen miker yomb kun gok gi tikdakniŋ, pumb ak, gach giy, takin ak melik ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gap gok semb biyoŋ nimb puŋgjiwyowakniŋ, tap semb biyoŋ gok, okok nimb okok nimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kun geniŋgamb, Bi bap Ñinuk, Nop aŋgek melik yomb gakniŋ, semb band sek winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pen enjol nuk gok aŋgyokeniŋgamb, miñmon kiñiŋ omiŋal ak maŋgiysek am kus giy, biynimb nup ker mindeniŋgambay gok dand mindeniŋgamb ak winiŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nimb niŋbim; mon gok silup ay wos gakniŋ, miñiy pumb ayniŋg gisap apim. ");
INSERT INTO kmh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kun ak rek, miker yomb aspiyn gok gakniŋ, ‘Miñiy maŋ mindip! Jiysis aŋgak rek, giniŋg gisap aŋgiy niŋniŋgambim.’ ");
INSERT INTO kmh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Apiyn ak niŋrep ginimimb! Biynimb kiñiŋ miñiy mindpay ar biy gunap mindyakniŋ, tap kun gok gek niŋiy kisen kumniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Semb ar biyoŋ sek, man ar biy sek kurginiŋgamb; pen minim yand ak perper nep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ñin akay akaŋ, won akay winiŋgayn ak, biynimb gunap ma niŋbay, enjol gok ma niŋbay, yand kunep ma niŋbiyn. Bapiy Gor, nuk nep niŋimb. ");
INSERT INTO kmh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kun ak mey, ñin akay winiŋgayn ak ma niŋbim rek, niŋrep giyiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Winiŋgayn ñin kun ak, biyomb bap korip nuk ak kirgiy wikan bap amniŋg, bi woŋg gep nuk gok kuyip woŋg ar keykey aŋgay, binuk kinjeŋrumb kond mindeniŋgamb anup aŋgniŋgamb, ‘Niŋmindenimin aŋgiy amniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nimbip kun ak rek giniŋgamb. Won akay bi korip nop nimb ak winiŋgamb aŋgiy ma niŋbim rek, niŋrep giy mindenimimb. Duŋgep won ak akaŋ, kisyimnamb yomb biyaŋ akaŋ, pumbnamb akaŋ, sekemb won ak winiŋgamb aŋgiy ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kinimbikniŋ kasek winimuŋ rek ayip. ");
INSERT INTO kmh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pen nimbip nep ma aspiyn; biynimb okok kuyip maŋgiysek aspiyn; niŋrep yimb giy mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Pen Jiwda biynimb, biret yiys sek ma ñimbay ñin yomb Pasopa apay ak, ñin omiŋal nep mindakniŋ, bi Gor nup simboŋgep yomb gok sek, bi low tiysa gok sek Jiysis nup yergiy kapkap chichiy diy, dam ñaŋgayun aŋgyak. Pen gos bap niŋiy aŋgyak, Pasopa ñin biy kun gon, biynimb kuŋaynep guniy, chinup gi timey giniŋgambay aŋgiy kirgiyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jiysis miñmon Beteniy amiy, bi Saymon korip ak am bisgiy tap ñiŋyak. Bi kun ak, nind soy ayndik ayek, Jiysis gek suŋ ayak. Pen tap ñiŋyakniŋ, biyn bap wel kuyrep wak maniy yomb tawpay ak, botol sek dand apiy, namb ak pikpaŋgiy, Jiysis nup jun biyoŋ soŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Soŋgek, bi mindeyak kun gok, gunap niŋey simbwur kuyip ak timey gek, kiyk key aŋgyak, “Wel kun ak yokiy, maniy yir ñin jiwiy andikiy onep ar ak rek diy, biynimb tap ma mindip gok kuyip ñemb ak pen, yenen kun giy yikop soŋgip?” Kun aŋgiy, nup aŋgjiwyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kun aŋgeyak, Jiysis kuyip aŋgak, “Nup kirgim; yip gip kun ak, girep yimb gip. ");
INSERT INTO kmh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Biynimb tap ma mindip gok, nimb yip per mindeniŋgambim rek, tap ñiniŋg ñinimimb; yand yip per ma mindoniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Biyn kun biy tap nuk gep rek ak gip. Kumen wel kuyrep wip ak ayñiy komniŋgambay rek, yip nind ayñisap. ");
INSERT INTO kmh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kun ak nimbip niŋind yimb aspiyn. Minim tep yip ak miñmon okok aŋgñey amnakniŋ, gip kun ak sek aŋgyiŋg, gos nup sakiy ma giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pen Jiysis binuk Jiwdas Yiskariyot, bi Gor nup simboŋgep yomb gok kuyip mimuŋg giniŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bi Gor nup simboŋgep yomb kun gok, mimuŋg kun ak niŋiy, tep gek aŋgyak, “Nip maniy gunap ñiniŋgambun aŋgyak.” Aŋgeyak mey, Jiwdas yergiy aŋgen apiy, Jiysis nup dand amniyaŋ aŋgiy, gos piyow niŋmindek. ");
INSERT INTO kmh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Biret yiys sek ma ñimbay ñin yomb Pasopa apay ak apek, kanj siypsiyp ñiluk pikñiŋemb ñin ak, Jiysis binuk gok nup aŋgyak, “Tap chin ñiŋniŋgambun gok, wikan akay gayrep ginjun?” ");
INSERT INTO kmh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aŋgeyak, binuk omiŋal aŋgyokiy aŋgak, “Nir miñmon dawin yomb ak amiy niŋniŋgayr: bi bap ñiŋg mal dand ameniŋgamb. Nup namb pikiy, korip kun ak amiy, ");
INSERT INTO kmh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","bi korip nop nimb anup aŋgniŋiy aŋgnimiyr, ‘Tiysa aŋgip, “Bi yand gok yip tap ñiŋniŋgambun miŋgan akay aŋgip,” aŋgiy aŋgniŋer’ ");
INSERT INTO kmh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","nirip dam korip ar biyoŋ cheya tap okok maŋgiysek mindip miŋgan ak yomniŋgamb. Yomek, tap ñiŋniŋgambun gok tip kun ak gayrep genimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kun giy aŋgyokek, miñmon dawin yomb ak amiy aŋgak rek nep mindek mey; Pasopa tap ñiŋniŋg giyak ak, gayrep gerik. ");
INSERT INTO kmh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Duŋgep won ak, Jiysis binuk gunap yip amjakiy, ");
INSERT INTO kmh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","tap ñimbyiŋg aŋgak, “Nimbip niŋind yimb aspiyn. Bi chin yip tap jimñiy ñimbsipun biy, bap yip pikayaŋ aŋgiy mimuŋg giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kun aŋgek, binuk gok simb gek gos par ayiŋg, nup nokom nokom aŋgniŋyiŋg aŋgyak, “Yand mer akaŋ aŋgiy,” aŋgniŋeyak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Nimb bi yand onep wimiŋgan ak, bap kun giniŋgamb. Bi kun ak mey, yand yip tap diys nokom jimñiy ñimbsipur biy. ");
INSERT INTO kmh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Baybol buk ak tikiy aŋgyak rek kumniŋgayn ak pen, bi yip pikayaŋ aŋgiy, mimuŋg giniŋgamb anup simb niŋsipiyn. Nup ma tikpiyap rek, timey kun ak rek ma giy, yiwur yomb kun ak ma dipkop aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tap ñimbyiŋg Jiysis biret ak diy, Gor nup tep aŋgiy, tipaŋg binuk gok kuyip ñiyiŋg aŋgak, “Diy ñiŋim! Ak mumbwak yand ak nimbip ñispiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pen ñiŋg wayn kap ak kunep diy, Gor nup tep aŋgiy, binuk gok kuyip ñek ñiŋyakniŋ aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Ñiŋg biy mey, likañ yand biynimb kuŋaynep, kuyip nen yowniŋgamb rek nimbip ñispiyn. Likañ yand yowniŋgamb kun ak mey, biynimb kuŋaynep diniŋgayn aŋgak minim ak wos amniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kun aŋgiy aŋgak, “Yand nimbip niŋind yimb aspiyn. Miñiy ñin biy tikiy ñiŋg wayn ma ñiŋniŋgayn. Yikop nep minden minden, Gor biynimb diy kond mindeniŋgamb ñin ak winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kun aŋgiy, binuk gok yip lotiw kamep bap aŋgyiŋg, miñmon Oliyp dum amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jiysis aŋgak, “Baybol buk ak tikiy aŋgyak ‘Gor bi kanj siypsiyp mokep anup pikayeniŋgamb, kanj siypsiyp gok pirik keykey amniŋgambay aŋgak.’ Kun ak rek, mindak nimb maŋgiysek yip kirgiy pirik amniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pen yand kumiy tikjakiy, miñmon Galiyliy ameniŋgayn, nimb kisen niniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aŋgek, Piyta aŋgak, “Bi gunap nip kirginiŋgiy rek ayip ak pen; yand nip ma kirginiŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aŋgek, Jiysis aŋgak, “Yand nip niŋind aspiyn; kisyimnamb biyaŋ kakaruk suk omiŋal ma aŋgniŋgamb won ak, Jiysis nup ma niŋbiyn aŋgiy, yinj omiŋal nokom aŋgniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aŋgek, Piyta kilis yimb giy aŋgak, “Yip nip sek pikayniŋg pikayniŋgiy ak pen; nip ma niŋbiyn aŋgiy ma aŋgniŋgayn aŋgak.” Jiysis binuk gunap, Piyta aŋgak rek nep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jiysis binuk gok yip miñmon Getsemeniy amiy kuyip aŋgak, “Nimb siŋbiy bisiŋg mindem, yand am Bapiy nup aŋgniŋiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kun aŋgiy Piyta, Jemis, Jon kuyip poŋind amiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Mindmaŋgiy yip piŋiyñiy nep aysap ak, kumnim rek ayip. Biy mindiy, niŋmindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kun aŋgiy kuyip aŋgay, nuk yep maŋ kun siŋak amiy, jomluk ak man biyaŋ ay, Nop nup aŋgniŋyiŋg aŋgak, “Tap yip giniŋg gisap ak, mer aŋgiy ker, mer aŋgnimin. ");
INSERT INTO kmh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Bapiy, nand Biyomb mindpan rek, yerer giniŋg giniŋgamban. Tap yip giniŋg gisap ak mer aŋgniŋg aŋgniŋgamban. Pen gos yand niŋbiyn rek ma ginimin, gos nak key niŋban ar ak ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aŋgiy, andkind binuk omiŋal nokom mindeyak ak apiy niŋak; pisnep kin ameyak, Saymon Piyta nup aŋgak, “Yenen kinjipan? Tapin won bap niŋmindenimin rek ma ayip? ");
INSERT INTO kmh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Timey ginjun rek ayip aŋgiy, gos tep niŋiy, Gor nup aŋgniŋyiŋg mindenimimb. Gosimb nimbik ak giniŋg niŋimb ak pen, mumbwak anep mawses gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kun aŋgiy, andkind amiy, Nop nup aŋgniŋak rek, tip ak aŋgniŋak. ");
INSERT INTO kmh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pen andkind apiy niŋak, wisin apek pisnep kin amniyak. Niŋiy kuyip aŋgak, “Nimb kinjipim?” Aŋgek siskoy diy, pen aŋgniŋgiy rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pen kisen amiy andkind apiy, tip ak kineyak niŋiy, aŋgak, “Nimb yikop kin mindpim? Mey tep! Bi Gor minim ma niŋbay gok yip diniŋg asway. ");
INSERT INTO kmh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Biriwin. Niŋim! Bi yip mimuŋg gip ak yakam lipiŋg dand apchakip nen, tikjakem, asway miŋgan bindoŋ amnun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kun aŋgakniŋ, bi low tiysa gok, bi Gor nup simboŋgep yomb gok, bi minim tuŋgasikep gok aŋgyak rek, binuk Jiwdas Yiskariyot, bi gunap poŋind amjakak. Bi poŋind owak kun gok, baynat gunap, kur gunap sek diy, nuk yip wiyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pen maŋ maŋ giyiŋg, Jiwdas bi kun gok kuyip aŋgak, “Bi am kaykol giniŋgayn anup, chichiy diy dand kor amnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kun aŋgiy, Jiysis mindek siŋak amjakiy, Tiysa aŋgiy, nup kaykol gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","bi gunap apiy nup chichiy diyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kun giyakniŋ, Jiysis binuk bap baynat nuk ak lipiŋg diy, bi Gor nup simboŋgep yomb yimb woŋg giñemb anup, timund piskind ak pisnep timbrik yokak. ");
INSERT INTO kmh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pen Jiysis nup kun giy chichiy deyak aŋgak, “Yand bi tap siy diy minden rek; baynat, yir, tap gok kun giy dapiy yip dispim. ");
INSERT INTO kmh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Per Gor aŋgniŋep korip ak amiy, nimb yip mindiy, biynimb minim aŋgñimbiyn ak pen, yip ma dipim. Pen miñiy giniŋgamb aŋgiy, Baybol buk ak tikyak rek gispim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pen Jiysis nup kun giy diyakniŋ, binuk gok nup kirgiy, maŋgiysek pirik amdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Bi paranj bap, chech parsek nep yimiy, Jiysis nup dand ameyak ak kindik amek, nup kunep chichiy dun aŋgey, chech band nuk ak kirgiy, daynep pirik amnak. ");
INSERT INTO kmh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jiysis nup dand bi Gor nup simboŋgep yomb yimb korip ak amniyak. Dand ameyak, bi Gor nup simboŋgep yomb gok diy, bi low tiysa gok diy, bi Jiwda kanjsol yikop gok diy, ap korip kun ak nan-geyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyta loslos ay dand amiy, bi Gor nup simboŋgep yomb yimb korip ak amjakiy, bi korip kun ak woŋg giyiŋgipay gok yip bisgiy, mon maŋiy mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bi Gor nup simboŋgep yomb gok sek, bi Jiwda kanjsol yikop gok sek Jiysis giraŋgyiŋgip minim kiñiŋ bap diy nup ñaŋgayun aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","biynimb gunap dand apey, kuŋaynep yesek tom giyak ak pen; minim kun gok, okok nimb okok nimb aŋgey, nup chiŋgnimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Pen gunap tikjakiy yesek aŋgiy aŋgyak, “Chin niŋmindon nuk aŋgak, ‘Gor aŋgniŋep korip ñin maŋgiy diy giyak biy timbrik yokiy, ñin omiŋal nokom mindiy, tip ak giniŋgayn. Ñin maŋgiy diy gipay rek ak ma giniŋgayn; korip kun ak key yimb bap giniŋgayn aŋgip’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Minim aŋgyak kun ak kunep niŋey sisker yimb ayak. ");
INSERT INTO kmh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bi Gor nup simboŋgep yomb yimb ak, biynimb mindeyak namb ak tikjakiy, Jiysis nup aŋgak, “Minim nip aspay ak pen bap ma aŋgniŋgamban?” ");
INSERT INTO kmh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aŋgek, Jiysis minim bap pen ma yimb aŋgek, tip ak aŋgniŋiy aŋgak, “Nand mey Jiwda kiyŋ yomb kiyk; Biyomb tep ak Ñinuk yimb?” ");
INSERT INTO kmh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aŋgek, Jiysis aŋgak, “Yaw. Mey yand nep. Bi bap Ñinuk Nop ñin yipund kind okok ken mindiy, semb band sek apek niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kun aŋgek, bi Gor nup simboŋgep yomb yimb kun ak, yenen Gor nup aŋgjiwyiŋg kun asap aŋgiy, chech nuk ak key tuŋgrikiy, ");
INSERT INTO kmh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kuyip aŋgak, “Nuk minim timey asap kun ak yerip gos niŋsipim?” Aŋgek, bi Jiwda kanjsol gok maŋgiysek aŋgyak, “Kun giy aŋgip rek, nup pikayep aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aŋgiy, bi gunap Jiysis nup kiñuk giy, chech band bap di windin nup ak pik yiwgiy, pikyiŋg aŋgyak, “Yand Gor Ñinuk aŋgiy, tap key yimb gipan ak, miñiy nip an piksap ak key niŋiy, chinup aŋgey niŋun aŋgyak.” Bi Gor aŋgniŋep korip poliys gok kunep nup tapin nep pikyak. ");
INSERT INTO kmh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Piyta am bisgak siŋak nep mindakniŋ, biyn piñ bi Gor nup simboŋgep yomb yimb anup woŋg giyiŋgip bap apchakiy aŋgak, “Nand kunep Jiysis bi Nasaret nimb ak yip mindamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aŋgek, Piyta aŋgak, “Nak yerip aspan! Minim aspan ak ma niŋbiyn aŋgak.” Kun aŋgiy, mis biyaŋ amnakniŋ, kakaruk suk aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Biyn kun anep, Piyta nup tip ak niŋiy, bi mindeyak gok kuyip aŋgak, “Bi biy kunep Jiysis binuk bap aŋgak.” Aŋgek aŋgak, “Bi kun ak ma niŋbiyn aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tapin won bap mindiy, bi mindeyak kun gok Piyta nup tip ak aŋgyak, “Nak kunep miñmon Galiyliy nimb ak, chin niŋbun: nand bi kiyk bap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aŋgeyak aŋgak, “Biyomb niŋmindip; yesek aŋgen yip pikaynimuŋ. Pen niŋind yimb apiyn! Bi kun apim ak yand ma niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kun aŋgakniŋ, kakaruk ak tip suk aŋgek, Jiysis nind kakaruk omiŋal suk ma aŋgniŋgamb won ak, nup ma niŋbiyn aŋgiy, yinj omiŋal nokom aŋgniŋgamban aŋgak minim ak niŋek, simb gek siy yomb aŋgak. ");
INSERT INTO kmh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Miñmon yowakniŋ, bi Gor nup simboŋgep yomb gok diy, bi low tiysa gok diy, bi kanjsol yikop gok diy miytiyŋ giy, minim aŋg ar nokom ay, Jiysis nup sen ayñiy, dand gapman biyomb Paylat mindek ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dand amey, Paylat nup aŋgak, “Nand Jiwda biynimb Kiyŋ yomb kiyk key yimb ak akaŋ?” Aŋgek, Jiysis aŋgak, “Mey nak apan ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bi Gor nup simboŋgep yomb gok, Jiysis nup minim yesek yesek ar gunap aŋgeyak, nuk pen minim bap ma aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Paylat aŋgak “Nip minim kuŋay aspay ak, pen minim bap ma aŋgniŋgamban?” ");
INSERT INTO kmh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aŋgek, Jiysis minim ma yimb aŋgek, Paylat gospar ayak. ");
INSERT INTO kmh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jiwda biynimb ñin yomb kiyk Pasopa apay ak apek niŋiy, per am Rom gapman biyomb Paylat nup aŋgniŋey, kuyip kalambis bi aŋgniŋyiŋgipay anep aŋg mis yokyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pen simiy kun ak, bi bap yimb nuk Barabas biynimb gunap diy, Rom gapman yip penpen giy chip ñaŋgyak rek, kuyip kalambis ayey mindeyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Biynimb gok ap nan-giy, Paylat nup kalambis bi bap per aŋgniŋyiŋgipay rek aŋgniŋey aŋgak, ");
INSERT INTO kmh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","“Kiyŋ yomb nimbik ak, wisik yoknim akaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yenen: nuk key niŋak; bi Gor nup simboŋgep yomb gok, Jiysis nup yikop miluk niŋyak rek dap ñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pen bi Gor nup simboŋgep yomb gok, biynimb gok kuyip aŋgyak, Paylat nup aŋgem, Barabas nup wisik yokiy; Jiysis nup kirginimuŋ. Aŋgeyak, biynimb gok Paylat nup aŋgyak, “Barabas nup, chinup wisik yoknimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kun aŋgeyak, Paylat aŋgak, “Kun apim ak, kiyŋ yomb nimbik anup yerginim?” ");
INSERT INTO kmh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aŋgek, kiyk meŋg miŋgan dand araniy aŋgyak, “Nup mon kiros bak biyoŋ ñaŋgbirik aynimimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aŋgeyak, Paylat aŋgak, “Nuk tap yerip timey gek, kun ginim?” Aŋgek, kiyk meŋg miŋgan dand araniy aŋgyak, “Mon kiros bak biyoŋ ñaŋgbirik aynimimb! Mon kiros bak biyoŋ ñaŋgbirik aynimimb aŋgyak!” ");
INSERT INTO kmh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aŋgyak kun ak, biynimb gok kuyip tep ginimuŋ aŋgiy, Paylat Barabas nup yikop aŋgyokiy, binuk gunap kuyip aŋgak, “Jiysis nup miñ diy, tapin nep pikiy, amiybi gok kuyip ñem, dam mon kiros bak biyoŋ ñaŋgbirik ayniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aŋgek, amiybi gok Jiysis nup dand gapman biyomb Paylat korip ak amiy, bi kiyk gunap kuyip suk aŋgey apey, ");
INSERT INTO kmh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","chech likañ paryomb gapman yomb gok aypay rek ak dand apiy, Jiysis nup ayñiy, tap ñiwñiw sek gunap tik dand apiy, kiyŋ aypay arband rek bap giy, jun biyoŋ ayñiyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ayñiy, nup poliys gipay rek chimkom diy aŋgyak, “Jiwda kiyŋ yomb kiyk biy perper mindonimuŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kun aŋgiy, nup kur diy, jun biyoŋ pikiy, kiñuk giñiy, mindek kiñiŋ siŋak koŋgim yimiy, jun paŋgyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nup kun giy aŋgjiwiy, chech likañ paryomb nup ayñiyak ak tuŋgasik diy, chech nuk key ak ayñiy, ñaŋgbirik ayniŋg dand saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kiyk namb okok amyiŋg, Saymon miñmon Sayriyniy nimb ak, okok giraŋgiy apiy Jerusalem amniŋg gek, nup namb pikiy minim kilis aŋgiy aŋgyak, “Jiysis nup mon kiros ak dand amnoŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pen kun giy amiy, Jiysis nup dand miñmon chip jun won tip ak, yimb Golgota apay ak amjakiy, ");
INSERT INTO kmh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","nup ñiŋg wayn ak diy, malasin silik gunap sek ay ñeyak, ma ñiŋak. ");
INSERT INTO kmh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma ñimbek, nup mon kiros bak biyoŋ ñaŋgbirik ay, chech nup gok bilok keykey diniŋg, sandiw gipay rek giyiŋg diyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","26","Pumb lim giy yep namb siŋbikyoŋ owak won ak, Jiysis nup ñaŋgbirik ay, yenen ñaŋgbirikyak minim ak kiros bak biyoŋ tikay aŋgyak, “Jiwda kay kiyŋ yomb kiyk ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pen minek kun ak, bi tap siydep omiŋal bap kunep ñaŋgbirik ayak. Bap gol pis bineŋ, bap gol pis biym, Jiysis nup namb biyaŋ ñaŋgbirik ayak. ");
INSERT INTO kmh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Giyak kun ak, Baybol buk ak tikiy, giniŋgambay aŋgyak rek nep giyak. Minim kun ak tikiy aŋgyak, “Nup niŋey, bi tap timey gep bap rek ayniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Biynimb gok kiyk aran apyan giyiŋg, Jiysis nup niŋiy jun gormar giy, nup aŋgjiwyiŋg aŋgyak, “Gor aŋgniŋep korip ak timbrikem, ñin omiŋal nokom tip giniŋgayn apan ak, ");
INSERT INTO kmh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","miñiy nand key giy kim amey, chin niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gor nup simboŋgep biyomb gok sek, bi low tiysa gok sek Jiysis nup kunep aŋgjiwiy aŋgyak, “Biynimb gunap kuyip gamb kim ambay rek, nuk key kunep giy kim amnaŋ akaŋ. ");
INSERT INTO kmh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Per Yisrel biynimb kiyŋ yomb kiyk mindpiyn aŋgip rek, miñiy nup ñaŋgbirik aypay ak, key giy kim amek ker, niŋind aŋgip aŋgiy niŋun akaŋ aŋgyak.” Pen bi Jiysis yip ñaŋgbirik ayak omiŋal ak nup kunep aŋgjiwrik. ");
INSERT INTO kmh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pumbnamb yomb biyoŋ won ak kisyim apiy, mind dand amiy, pumb kuyim gak won ak tip melik gak. ");
INSERT INTO kmh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Melik gakniŋ, Jiysis Jiwda minim ay, meŋg miŋgan dand araniy aŋgak, “Eloy, Eloy, lema sambaktaniy aŋgak.” Minim aŋgak kun ak, kiñiŋ nuk ak aŋgak, “Bapiy Gor! Bapiy Gor! Yip yenen kirpan aŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aŋgek, biynimb maŋ kun siŋak mindeyak gok niŋiy aŋgyak, “Niŋim! Yilayja nup suk asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pen bi bap tap kipromb rek band bap diy, ñiŋg wayn maniy sikoy tawpay miŋgan biyaŋ tawek amek, Jiysis nup ñen ñiŋaŋ aŋgiy, gamil par ak di kambis ñaŋgiy, mindek biyoŋ ñiyiŋg aŋgak, “Chin niŋmindon, Yilayja apiy, nup tuŋgasik dam man biyaŋ ayniŋgamb akaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kun aŋgiy niŋmindyakniŋ, Jiysis meŋg miŋgan dand araniy minim yomb aŋgiy kumak. ");
INSERT INTO kmh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Won kun anep, chech paryomb Gor aŋgniŋep korip ñiluk kapkap miŋgan biyaŋ pilgiyak ak, puŋgrik biyoŋ biyaŋ ay, miŋgan sek mindek. ");
INSERT INTO kmh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Amiybi gok biyomb kiyk ak, kiros bak namb akniy ken siŋak mindiy niŋak, Jiysis kun aŋgiy kumek, tap yerip yerip gak gok niŋiy aŋgak, “Niŋind apay. Bi kun ak Gor Ñinuk yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Biyn Jiysis yip Jerusalem wiyak gunap ap gol siŋak mindeyak. Namb kun ak, omiŋal nokom Jiysis nup woŋg siskoy gunap giñiyiŋgipay miñmon Galiyliy. Bap yimb nuk Salomiy; Mariya omiŋal. Biyn yimb aloŋg omiŋal kun ak, bap miñmon Makdala nimb; bap Jemis yip, numam kisen Josis yip nonim ak. Biyn kun gok maŋgiysek niŋmindeyak, Jiysis kumak. ");
INSERT INTO kmh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Josep bi Armatiya nimb, Jiwda kanjsol tep yimb bap aŋgiy niŋyiŋgipay ak, Gor biynimb diy kond mindeniŋgamb aŋgiy kond mindyiŋgip. Bi kun ak ñimñam giniŋg gakniŋ, nuk amjakiy niŋak Jiysis kumek, toy lotiw ñin ak, miñiy tuŋgasik dam komnim aŋgiy; ma pirikiy, Paylat mindek ak amiy aŋgniŋak. ");
INSERT INTO kmh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aŋgniŋek, Paylat Jiysis won akay kumimb aŋgiy jiwdiy, poliys opiysa yomb anup aŋgek apek aŋgniŋak. Aŋgniŋek aŋgak, “Mindarik kumimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kun aŋgek, Paylat Josep nup aŋgak, “Dam komnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aŋgek, Josep chech tund yomb bap tawiy, bi gunap yip Jiysis nup tuŋgasik dand apyapiy, maŋgiysek pipkomiy, dam kamb miŋgan kisenimb nep kilukiy, chip ma komyak miŋgan ak komyak. Komiy, kamb yomb bap tuŋgmilokey amek, kawrumb ak pil giyak. ");
INSERT INTO kmh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pen Mariya Makdala yip, Mariya Josis nonim yip niŋmindrikniŋ nup komyak. ");
INSERT INTO kmh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jiwda lotiw ñin kiyk ak apiy pandikek, Mariya Makdala ak, Mariya Jemis nonim ak, biyn Salomiy ak Jiysis mumbwak nup ak wel ayñinjun aŋgiy, am wel kuyrep wak ak taw dap ayey kinak. ");
INSERT INTO kmh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Minek Sandey ñin ak maynamb yimb tikjakiy, Jiysis nup komyak bindoŋ amniŋg saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Namb okok amyiŋg aŋgyak, “An chinup kamb yomb kawrumb pilgiyak ak, tuŋgmilok dam gol okok ayniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kun aŋgiy amjakiy niŋyak: kamb yomb kawrumb pil giyak kun ak, gol okok mindek. ");
INSERT INTO kmh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Niŋiy, miŋgan bineŋ sikind amiy niŋyak: bi paranj chech tund paryomb yimak bap, ñin yipund kind okok ken bisiŋg mindek. Nup niŋiy pirikyak ak pen; ");
INSERT INTO kmh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","kuyip aŋgak, “Ma piriknimimb. Yand niŋbiyn; Jiysis bi Nasaret nimb, mon kiros bak biyoŋ ñaŋgbirik ayak anup niŋniŋg aswim. Pen niŋim! Tip ar nup komyak biy; nuk ma mindip. Mindarik tikjakiy amimb. ");
INSERT INTO kmh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pen ma kumak ñin ak aŋgak rek, nuk nind tikjakiy Galiyliy am mindeniŋgamb; nimb kisen amiy nup niŋniŋgambim. Piyta sek, Jiysis binuk gunap sek kuyip minim kun ak aŋgñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kun aŋgek, mis amiy, jel pirikyak rek biynimb gunap kuyip minim kun ak ma aŋgñiyak; puŋgrikind aŋgiy korip amniyak. ");
INSERT INTO kmh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jiysis kumiy, Sandey ñin ak tikjakiy, nind yimb Mariya Makdala mindek siŋak miseŋ gek niŋak. Pen biyn kun anup, nind kichekiy onep ar ak abaŋ ayek, Jiysis aŋg mis yokak. ");
INSERT INTO kmh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nuk Jiysis nup niŋiy, am binuk gok siy aŋg mindeyak namb ak, Jiysis kim mindip nup niŋbiyn aŋgek, ");
INSERT INTO kmh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kiyk pisnep kumimb aŋgiy minim nup ak ma diyak. ");
INSERT INTO kmh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Minek bap pen tip ak, Jiysis binuk omiŋal miñmon wikan bap giraŋgiy, Jiysis bi ak key rek ay apiy, kinjeŋnamb ak miseŋ gek nup niŋiy, ");
INSERT INTO kmh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","am binuk gunap kuyip aŋgñer, kunep niŋind aspiyr aŋgiy ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pen minek bap tip ak, Jiysis binuk onep aŋgip ak tap ñimbeyak namb siŋak miseŋ giy, kuyip aŋg giyiŋg aŋgak, “Tikjaken biynimb gunap miseŋ niŋiy aŋgey, yenen Gor Ñinuk ak niŋind tikjakip aŋgiy gos ak ma niŋbim?” ");
INSERT INTO kmh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kun aŋgiy kuyip aŋgak, “Minim tep yip ak dand miñmon okok maŋgiysek amiy, biynimb okok maŋgiysek aŋgñinimimb. ");
INSERT INTO kmh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aŋgñem, biynimb an yip gosimb niŋiy, ñiŋg pikniŋgambay gok, kim amniŋgambay. Pen biynimb an yesek apay aŋgniŋgambay ak, kor yomb niŋiy, miñmon timey ak amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","“Biynimb yip gosimb niŋniŋgambay gok, yip aŋgniŋiy tap mageprek gunap giniŋgambay, ñin gunap minim yimb kiyk ak mindakniŋ, minim kisenimb ar bap key yimb aŋgniŋgambay; siyŋ saraw tap biynimb siwip gok diniŋiy akaŋ, tap ñimbiy kumbay gunap ñimbiy, ma kumniŋgambay. Pen biynimb tap giniŋgamb gok, kuyip ñin maŋgiy diniŋey suŋ ay; kichekiy tap yerip gunap biynimb ambaŋ ayniŋgamb gok, aŋg mis yokniŋgambay. Kiy yip minden tap mageprek kun gok giyakniŋ, biynimb gok minim chinup aŋgñispay ak niŋind aspay aŋgiy, niŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jiysis minim kun ak aŋgjiwakniŋ, Nop nup dand arachak semb biyoŋ amnak. Dand amek, ñin yipund kind okok ken mindip. ");
INSERT INTO kmh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pen binuk gok minim tep ak miñmon okok kind kind aŋgñey amnakniŋ, Biyomb ak minim kun ak niŋind aynimuŋ aŋgiy, kuyip kond mindakniŋ, tap mageprek gok giyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Biyomb Tiyopiylas. Krays nup namb chinup biy tikey yomb giy, gak gak rek, bi gunap windin niŋiy aŋgñeyak, bi gunap niŋiy, kesim nokom kun ak nep ar keykey tikyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pen biyomb niŋan: Jiysis nind gek owak rek, yand per kiñiŋ piyowniŋ tep gipiyn ak mey, kunep tikniŋg gispiyn. ");
INSERT INTO kmh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kun giy tiken mey, minim nip aŋgey niŋban ak, niŋind yimb nep apay aŋgiy niŋniŋgamban. ");
INSERT INTO kmh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nind Herot Jiwdiya propens kond mindyiŋgip ñin ak, binak Sekaraya, Gor nup simboŋgep woŋg ak gi mindyiŋgip. Bi layn nuk yip woŋg jimñiy giyiŋgipay gok kuyip, Abayja Layn aŋgyiŋgipay. Pen bi Sekaraya kun ak biynuk yimb ak Eliysabet. Nup kunep bi Gor nup tap simboŋgep Eron kiñiŋ ak tik dand amiy tikyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kiykber Gor minim ar ak maŋgiysek kisen giy minder; Gor niŋek minim bap ma mindek. ");
INSERT INTO kmh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pen Sekaraya biynuk Eliysabet ñapan wom ak mey; ñapan bap tikiy mer, pisnep yimb tokiy ayrik. ");
INSERT INTO kmh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ñin bap Sekaraya binuk yip woŋg jimñiy giyiŋgipay gok, ap Gor nup simboŋgep woŋg ak tip giniŋg aŋgyak, “Woŋg giniŋgambun kun ak, bi chin an rek biyomb aŋgayon chinup gunap kond mindeniŋgamb aŋgiy,” sandiw rek ak giy mey, Sekaraya nuk wiyn giy, kuyip kond mindyiŋgip. Tap kuyrep apyiŋgip gok Gor aŋgniŋep korip miŋgan ak amiy, daŋgiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pen ñin bap, tap kuyrep daŋgiyep won ak apek, biynimb kuŋaynep ap mis biyaŋ nan-giy lotiw mindyakniŋ, Sekaraya nuk tap kuyrep wak kun ak daŋgiyniŋg, korip ñiluk miŋgan ak amniŋg saŋdak. ");
INSERT INTO kmh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Amjakakniŋ, enjol bap ap tap kuyrep wip daŋgiy ayiŋgipay ñin yipund kind okok ken miseŋ gak. ");
INSERT INTO kmh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","13","Sekaraya niŋiy jiwdiy pirikek, enjol ak nup aŋgak, “Ma piriknimin! Gor nup minim aŋgniŋban ak niŋimb. Biynak Eliysabet ñi bap tikniŋgamb. Tikek yimb nup Jon aŋgnimin. ");
INSERT INTO kmh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Nuk Gor nup woŋg gek; Gor nup tep giy, nip key tep giy, biynimb gok kuyip tep giy giniŋgamb. Nonim nup tikek, Gor Kawnan ak yip nep mindeniŋgamb ak mey; ñiŋg wayn akaŋ, ñiŋg kilis gunap ma ñiŋnimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kisen Yisrel biynimb Gor nup kirpay gok kuŋaynep aŋgrep gek, Gor nup Biyomb chin aŋgiy diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pen ñi nand kun ak, Gor Yilayja nup kilis ñiyiŋgip rek ñakniŋ, nop sikop kuyip diy, ñapan nuk sikop kuyip diy di jimñiy ayniŋgamb. Biynimb Gor nup alemb alemb ñimbay gok aŋg tep gek; biynimb nup gosimb niŋiy suŋ-tep mindpay gok yip mind tep giyiŋg, Biyomb anup kond mindyakniŋ winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Enjol ak kun aŋgek, Sekaraya aŋgak, “Chir tokiy yimb aypur ak, yergiy ñapan tikniŋgambur? Kun ak yergey niŋiy, niŋind yimb apan aŋgniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aŋgek, enjol ak Sekaraya nup aŋgak, “Yand Gebriyel, Gor windin yirik ar ak minden yip yokek, minim tep kun ak dand opiyn. ");
INSERT INTO kmh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pen niŋind aŋgip aŋgiy ma niŋban rek, joŋimb nip ak miker gek, minim aŋgyiŋg ma mindeniŋgamban. Yikop nep mind mind, ñi ak tikiy nep, tip ak minim aŋgniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pen biynimb mis biyaŋ mindeyak gok, Sekaraya Gor aŋgniŋep korip ñiluk miŋgan ak am tapin yimb mindek niŋiy, gos kuŋay yimb nep niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kisen nuk mis apiy, yip kun kun gip aŋgiy, ñin anep yomek; korip miŋgan biyaŋ am mindiy, tap bap key niŋiy wip aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pen Sekaraya Gor aŋgniŋep korip woŋg ak gi mindek, ñin nuk ak day jiwakniŋ, bi gunap ap tip nup ak diyakniŋ, nuk andkind korip amnak. ");
INSERT INTO kmh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Mind dand amiy, biynuk Eliysabet ñapan koŋgiy mindiy aŋgak, “Biyn ñapan wom minden yip nambiŋ gak ak pen, miñiy Biyomb ak yip simb niŋiy kond mindek, ñapan koŋgiy mindpiyn ak; yip tep gip rek, nambiŋ ma giniŋgamb aŋgak.” Kun aŋgiy, takin onep mamind ak, kapkap korip miŋgan okok nep mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Takin kaŋgol ak, Gor enjol Gebriyel nup aŋgyokek, pañ Mariya nup niŋniŋg miñmon sikoy Nasaret amnak. ");
INSERT INTO kmh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pañ kun ak, binak Josep nup diniŋgamb aŋgiy minim aŋgyak. Bi Josep kun ak, kiyŋ Depiyt tikek, tik dand amiy tikyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enjol Gebriyel pañ Mariya mindek ak amjakiy aŋgak, “Mariya mindpan? Gor nip direp gip. Nuk yip mindpiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kun aŋgek, Mariya minim kun ak niŋiy, yip yenen kun asap aŋgiy gos kuŋay niŋek, ");
INSERT INTO kmh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","enjol ak nup aŋgak, “Ma piriknimin! Gor nip direp yimb gip. ");
INSERT INTO kmh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nand ñapan koŋgiy mindiy, ñi bap tikniŋgamban. Tikiy yimb nup Jiysis aŋgnimin. ");
INSERT INTO kmh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pen nuk biyomb yimb mindek, Gor Ñinuk aŋgniŋgambay. Gor gek, nusind yes Depiyt, kiyŋ yomb mindyiŋgip rek mindiy, ");
INSERT INTO kmh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","nimbip Jekop tikek tikey mindpim gok maŋgiysek, perper yimb kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Enjol ak kun aŋgek, Mariya aŋgak, “Yand bi bap yip ma mindpur ak, yergiy ñapan kun ak tikniŋgayn?” ");
INSERT INTO kmh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aŋgek, enjol ak nup aŋgak, “Gor Kawnan ak nep gek, ñapan suŋ-tep yimb ak tikniŋgamban ak mey, nup Gor Ñinuk aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Niŋan! Namind Eliysabet nup biyn ñapan wom aŋgyiŋgipay ak pen; miñiy tokiy yimb ay, ñapan koŋgiy mindip. Takin omiŋal omiŋal mindiy, ñi bap tikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gor tap ma ginimuŋ rek bap ma mindip; tap okok maŋgiysek ginimuŋ rek anep mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kun aŋgek, Mariya aŋgak, “Yand Gor nup woŋg giñemb pañ bap ak, aspan rek nep yip ginimuŋ aŋgak.” Kun aŋgakniŋ, enjol ak nup kirgiy amnak. ");
INSERT INTO kmh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Pen Mariya kasek amniyn aŋgiy, Jiwdiya propens yirik okok kinjeŋ par ak am am, Sekaraya korip ak amjakak. Amjakiy, numind Eliysabet nup aŋgak, “Nand mindpan?” ");
INSERT INTO kmh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aŋgek, numind Eliysabet ñapan mindek ak kawin ayak. Pen Gor Kawnan ak Eliysabet nup gek, ");
INSERT INTO kmh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","meŋg miŋgan dand araniy Mariya nup aŋgak, “Gor biyn gunap kuyip kond mindip ak pen; nip key yimb direp gip. Ñapan koŋgiy mindpan kayaŋ ak kunep kond mindip. ");
INSERT INTO kmh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yergiy rek minden, Gor yip direp giyiŋg, Biyomb chin nonim ak yip ker apek niŋsipiyn? ");
INSERT INTO kmh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nand ap yip ‘Mindpan?’ aŋgey, ñapan koŋgiy mindpiyn ak, tep gakniŋ kawin ayip. ");
INSERT INTO kmh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pen Gor nip aŋgip rek giniŋgamb aŋgiy niŋban ak, tep yimb gipan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eliysabet kun aŋgek, Mariya Gor nup gosimb niŋyiŋg, tep gakniŋ aŋgak: ");
INSERT INTO kmh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","“Yand pisnep kumemb rek mindenik, Gor yip simb niŋiy tuŋgasik dak ak, nup niŋen yip tep gip. Yand yikop pañ nup woŋg giñimbiyn ak pen; yip sakiy ma gip. Kun gip ak, miñiy tikiy, biynimb gok maŋgiysek, Gor biyn kun ak nup direp yimb gak aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","“Gor Biyomb tap okok maŋgiysek gip ak, yip direp yimb gip. Nuk bi suŋ-tep kun ak key yimb mindip. ");
INSERT INTO kmh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Biynimb minim nup niŋiy ñawil diy, kisen giniŋgambay gok, kuyip simb niŋiy diniŋgamb. Ñapan kiy tikeniŋgambay tikey amniŋgamb gok, kunep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nuk bi ñin paryomb yimb. Biynimb chin key biynimb yomb mindpun apay gok kuyip, yuk yokip. ");
INSERT INTO kmh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Kun ak, biynimb yimb mindip gok keykey amey, biynimb yimb ma mindip gok tip kuyip ak dipay. ");
INSERT INTO kmh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pen biynimb yiwan gip gok kuyip niŋiy, tap ñimb; biynimb tap kuŋay mindip gok niŋiy, yikop aŋgyokek ambay. ");
INSERT INTO kmh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","“Apis basind yes chin gok kuyip minim aŋgak ak sakiy ma giy, chinup Yisrel biynimb per simb niŋiy kond mindrep gip. ");
INSERT INTO kmh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","“Basind Ebraham sek, basind chin gunap sek ñapan tikeniŋgambay tikey amniŋgamb gok, kuyip kond mindeniŋgayn aŋgiy aŋgak rek chinup gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya minim kun ak aŋgiy, numind Eliysabet yip takin omiŋal nokom mindiy, andkind korip nuk amnak. ");
INSERT INTO kmh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mind dand amiy, Eliysabet ñi won ak tikak. ");
INSERT INTO kmh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Gor nup kond mindek, tokiy yimb ay ñapan tikak kun ak; biynimb nuk gok niŋiy, nuk yip miñmiñ yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pen ñi ak tikiy ñin onep ar ak mindiy, ñin jiy ak kumbak nup ak tikiy aŋgyak, “Ñi kun biy, nop Sekaraya yimb ak tiŋiy yinj gep aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aŋgey, nonim aŋgak, “Mer. Yimb nup Jon aŋgep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aŋgek, biynimb nuk gok aŋgyak, “Binuk gok, Jon yimb bap ma mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kun aŋgiy, nop Sekaraya nup ñin anep yomiy aŋgniŋeyak, ");
INSERT INTO kmh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","nuk ñin anep yomiy aŋgak, “Yip tap pisband bap sek, kil tikep tap par bap sek dowim aŋgak.” Aŋgek, dand apey, ar kun ak yimb tikiy, enjol ak nind aŋgak rek, “Yimb nup ak Jon aŋgak.” Kun giy tikek niŋiy, kiyk gos kuŋay yimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pen Sekaraya joŋimb miker gak kun ak awan amnakniŋ, day minim aŋgyiŋg, Gor nup yimb ak dand aranak. ");
INSERT INTO kmh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Biynimb mindeyak gok, gak kun ak niŋiy, minim kun ak yiŋg dand miñmon Jiwdiya yirik okok maŋgiysek yimb amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Biynimb gok minim kun ak niŋiy aŋgyak, “Gor gek ñapan kun giy tikip ak, kisen yergiy rek mindeniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon nop Sekaraya, Gor Kawnan ak bak ayek, Gor nup minim tep gunap kamep rek aŋgiy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Chin Yisrel biynimb, Bapiy Gor nup yimb ak dand aranjun. “Chinup pisnep kirgiyn aŋgiy gos ak ma niŋimb; simb niŋiy diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","“Kun ak bi minim nup aŋgep gok wosrey aŋgyak rek, Biyomb bap yokek apiy, chinup kond mindek, kim amniŋgambun. “Biyomb kun ak, basind Depiyt Gor nup woŋg giñiyiŋgip bi ak ñapan tikek; kiy pen tik dand amiy apiy giy, nup tikniŋg gispay. ");
INSERT INTO kmh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Gor aŋgak, ‘Yand mindpiyn rek, nimbip miluk niŋiy, timey giniŋgiy rek ma ayniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“Nuk chinup simb niŋiy direp gip kun ak, basind sikop kuyip sakiy ma giy, giniŋgayn aŋgiy aŋgayak rek nep gip. ");
INSERT INTO kmh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","“Nuk basind Ebraham nup minim aŋgay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Nimbip kond minden biynimb miluk niŋbay gok, nimbip timey giniŋgiy rek ma ayniŋgamb. Ma pirikniŋgambim; gos yip ak niŋiy, woŋg yip ak giy, biynimb tep yand gok nep mindiy, mind tep giniŋgambim aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Pen ñi yand. Nand woŋg giniŋgamban rek niŋiy, aŋgniŋgambay, Gor Biyomb yimb ak, bi minim aŋgep nuk aŋgniŋgambay. Yenen, nand nind amiy, biynimb gok kuyip aŋgrep gey, Biyomb anup kond mindyakniŋ, nuk winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nand kuyip aŋgrep gey, Biyomb ak apiy, tap siy tap timey gipay gach ak wiykyokiy, kuyip diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","“Gor bi tep biynimb simb niŋimb ak, melik tep semb biyoŋ nimb ak chinup yokeniŋgamb mey; kisyimnamb okok taŋgiy, gi dam pikiy, kumemb rek ayip ak kirgiy, kinjeŋ tep ar ak taŋgeniŋgambun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pen Sekaraya ñinuk Jon, miñmon nep namb okok mind mind, pisnep yomb gi day tikiy apek, Yisrel biynimb nup niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pen Jon nup tikyak ñin namb kun ak, gapman biyomb Siysa Ogastas, low ay aŋgak, “Biynimb yand kond mind asikpiyn rek, maŋgiysek yimb diniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nind kiñiŋ giy, yimb dinimimb aŋgiy diyak ñin kun ak, gapman biyomb Sayriyniyas, Siyriya biynimb kuyip kond mindek. ");
INSERT INTO kmh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pen biynimb miñmon paryomb okok nimb ap yikop mindeyak gok yimb diniŋg, andkind miñmon kiyk key okok amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kun gey niŋiy, Josep nup Depiyt kiñiŋ ak tik dand amiy tikyak rek; Mariya nup poŋind, miñmon sikoy Nasaret Galiyliy propens ak kirgiy, Jiwdiya propens amiy, kiyŋ Depiyt nup tikey mindyiŋgip miñmon sikoy Betliyhem amnak. ");
INSERT INTO kmh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pen biyn nup minim aŋgyak kun ak, ñapan koŋgiy sek mindakniŋ, poŋind yimb diniŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Amjakiy niŋak; maniy tawiy kinyiŋgipay korip ak pisnep timbik dak ak mey, kaw mokyiŋgipay korip ak mindiy, Mariya ñapan nind won ak tikak. Tikiy chech kom kom giy, di kaw tap kaskas ayey ñimbyiŋgipay kes miŋgan ak ayak. ");
INSERT INTO kmh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pen Mariya Jiysis nup tikak ñin kun ak, bi kanj siypsiyp mokep gok, gunap kisyimken ak kond mindeyak miñmon kun okok. ");
INSERT INTO kmh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gor enjol bap melik sek yokek, melik kun ak ap kuyip pikniŋek niŋiy, pirikyak. ");
INSERT INTO kmh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pirikey, enjol ak kuyip aŋgak, “Ma piriknimimb! Yand nimbip biynimb okok maŋgiysek, minim tep miñmiñ gep ak dand opiyn. ");
INSERT INTO kmh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Miñiy biyn bap, Biyomb chin per kond mindpun ak tikip; Depiyt mindyiŋgip miñmon ak. Kisen nuk Biyomb mindiy, tap siy tap timey gipim gach ak wiykyokiy, nimbip di Gor yip jimñiy ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nup am piyow niŋiy niŋniŋgambim: nonim nup chech kom kom giy, di kaw tap kaskas ayey ñimbay kes miŋgan ak ayek mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kun aŋgakniŋ, enjol kuŋay yimb nep semb biyoŋ nimb apiy, Gor nup yimb ak dand aranyiŋg aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Gor yimb nup ak dand yiy ar biyoŋ aranemb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Enjol gok andkind semb biyoŋ amniyakniŋ, bi kanj siypsiyp mokep gok minim aŋgniŋ aŋgniŋ giy aŋgyak, “Gor aŋgamb, chinup minim kun giy apay ak, kasek Betliyhem amiy niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aŋgiy, amiy niŋyak: Josep yip, Mariya yip ñapan aŋgyak kun ak, chech kom kom giy, kaw tap kaskas ayey ñimbay kes miŋgan ak ayer mindek. ");
INSERT INTO kmh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Niŋiy aŋgyak, “Enjol gok, kisen ñapan kun ak nimbip kond mindeniŋgamb apay ak, mey biy-ey! aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bi kanj siypsiyp mokep gok minim kun ak aŋgey, biynimb gok niŋiy, gos kuŋay yimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pen Mariya nup tap key yimb ak gak rek, tep gek gos niŋyiŋg nep mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bi kanj siypsiyp mokep gok, Gor enjol nuk gok aŋgyak rek nep gek, windin key niŋiy, yimb nup ak dand aranyiŋg, andkind korip amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mariya ñi ak tikiy ñin onep ar ak mindiy, minek jiy ak kumbak tikiy yimb ayniŋg, enjol ak nind nonim nup, yimb ak kun giy aynimin aŋgak rek, yimb nup ak Jiysis aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Pen Mosis Gor low minim ak tikiy, ñi nind tikniŋgambay gok, Gor nup aŋgniŋgambay aŋgak ak mey, Mariya ñapan ak tikiy, Jiwda biynimb giyiŋgipay rek, Gor aŋgniŋep korip ak asikiy mindek suŋ ayakniŋ, Josep yip, Gor ñapan nup ak aŋgniŋg, dand Jerusalem amiy, Gor aŋgniŋep korip amnirik. ");
INSERT INTO kmh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pen low minim bap tikiy, “Biyn ñapan tikniŋgiy gok suŋ ayek, yakir maliŋg akaŋ, kochir omiŋal dand Gor aŋgniŋep korip mis ar ak amiy, pik Gor nup simboŋg ñiy mey, suŋ ayip aŋgiy, Gor aŋgniŋep korip miŋgan ak amniŋgambay aŋgyak.” Gos kun ak kunep niŋiy mey, yakir omiŋal sek dand amnirik. ");
INSERT INTO kmh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Pen Jerusalem amiy, yakir omiŋal ak Gor nup simboŋg ñiy, korip miŋgan amiy niŋrik: bi mind tep yimb giy, Gor nup nep aŋgniŋyiŋgip bap mindek. Yimb nuk ak Simiyon. Nuk Gor Kawnan ak yip mindyiŋgip ak mey; nup nind aŋgak, “Biyomb Gor yokek Yisrel biynimb kuyip diy kond mindeniŋgamb ak apek niŋiy, kisen kumniŋgamban aŋgek,” niŋmindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pen ñin kun ak, Gor Kawnan ak Simiyon nup gos ñek, Gor nup aŋgniŋep korip ak amiy niŋak; Josep ber, Jiysis nup dand apiy, Mosis aŋgak rek giniŋg ap minderik. ");
INSERT INTO kmh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kuyip niŋiy, Jiysis nup di kaygiy, Gor nup yimb ak dand aranyiŋg aŋgak: ");
INSERT INTO kmh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Biyomb. Ñapan biy yomb giy, chinup di nip yip jimñiy ayniŋgamb ak, tep yokey miseŋ niŋsipiyn. Kun ak yip aŋgnak rek yepyey, tep gakniŋ kumnim. ");
INSERT INTO kmh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","“Ñapan kun biy, biynimb nand Yisrel kuyip nep daŋ aŋgiy ma yokpan; biynimb yikop okok kuyip kunep daŋ aŋgiy yokpan. “Pen melik tep nand ak kuyip niŋakniŋ, chinup Yisrel biynimb yimb ak dand araniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyon Jiysis nup kaygiy, minim kun ak aŋgakniŋ, Josep ber gos kuŋay niŋrik. ");
INSERT INTO kmh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pen nuk kuyip bilesiym giyiŋg, Jiysis nonim Mariya nup aŋgak, “Ñi nand kun biy mindakniŋ, Yisrel biynimb kuŋaynep namb ak anjilakiy, kinjeŋ tep diy amniŋgambay gok, Gor ker amniŋgambay; kinjeŋ timey diy amniŋgambay gok, apyap pikniŋgambay. Niŋyaŋ aŋgiy, nup yokak ak pen, nup ma diy aŋgjiwniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kun giy mey, yerer giy gos niŋiy mindpay rek, biynimb niŋniŋgambay. Pen mindmaŋgiy nip ak kalaw yimb giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pen ñin kun ak, biyn Gor minim aŋgep bap kunep ap mindek. Yimb nuk ak Ana. Nop yimb ak Pañiwel. Biynimb Esa aŋgyiŋgipay kiñiŋ ak tik dand apiy mey, Ana nup tikyak. Pen Ana simiy nuk ñin jiwiy omiŋal nokom, andikiy onep anjip piskind ak yinak. Nind bi diy, nuŋgumiy yip minder simiy yin ayak ar ak. ");
INSERT INTO kmh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pen nuŋgumiy kumakniŋ, Gor nup gos anep ayek, ñin gunap tap ñimbiy mer, Gor aŋgniŋep korip ak amiy, pumbnamb kisyimken aŋgniŋ mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pen nuk Jiysis nup di mindeyak maŋ siŋak apiy, Gor nup tep aŋgiy, biynimb Gor chinup diy kond mindeniŋgamb aŋgiy niŋyak gok kuyip aŋgak, “Ñapan biy yomb giy, chinup di Nop yip jimñiy ayniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep ber Gor low minim aŋgiy tikyak rek giy, tip ak andkind Galiyliy propens amiy, miñmon kiyk Nasaret amnirik. ");
INSERT INTO kmh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Am mindiy Jiysis yomb giy, Gor nup kond mindakniŋ, gos tep yimb niŋiy, mind tep gak. ");
INSERT INTO kmh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nop nonim ber simiy ak simiy ak, enjol ak Yijip biynimb kuyip pikayiŋg, chinup Jiwda biynimb gok kirgak ñin yomb Pasopa ak miñiy aŋgiy, am Jerusalem nan-giyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kun giy mey, Jiysis simiy nuk yin wimiŋgan ak ayek, nop nonim yip Jerusalem am mindey, ");
INSERT INTO kmh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","ñin yomb kiyk kun ak apiy pandikakniŋ, korip amjipun aŋgiy, andkind kinjeŋnamb ak apiy niŋrik: Jiysis yip ma apeyak. Nuk Jerusalem nep mindek ak pen, kiyk ma niŋiy aŋgrik, nuk biynimb gunap yip asaw aŋgiy niŋrik. Pen kinjeŋnamb ak kiniy, nup ma nep niŋiy, ");
INSERT INTO kmh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","48","numiy numam sikop yip mindip akaŋ aŋgiy, piyow andkind Jerusalem amiy niŋrik: nuk am Gor nup aŋgniŋep korip ak mindiy, biyomb low tiysa gok yip minim aŋg mindek. Biynimb ap niŋmindeyak gok, Jiysis aŋgak rek niŋiy, ñi gos kind aŋgiy niŋiy, minim aŋg tep yimb gip ak aŋgiy, wal aŋgyak. Pen nop nonim ber nup kunep niŋiy, ñi ak gos nuk ak key niŋiy kun gamb, nup ñin omiŋal nokom ma niŋbur aŋgiy, wal aŋgrik. Nonim pen, Jiysis nup aŋgak, “Nap chirup yenen kun gey, mindmaŋgiy kalaw gakniŋ, nip piyow niŋraspur?” ");
INSERT INTO kmh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aŋgek, Jiysis aŋgak, “Yenen yip piyow taŋgyiŋg aspiyr? Bapiy yand korip mindeniŋgayn ak ma niŋbiyr?” ");
INSERT INTO kmh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jiysis kun aŋgak ak pen, minim asap ak aŋgiy ma tik niŋrik. ");
INSERT INTO kmh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pen ñin kun ak, Jiysis nup poŋind andkind miñmon kiyk Nasaret amerik, nuk kun okok mindyiŋg, nop nonim aŋgyiŋgipiyr rek nep niŋiy kindik giyiŋgip. Pen nonim, nuk yerer gak ak niŋyiŋg nep mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jiysis miñmon Nasaret mindiy, pisnep yomb giy, gos niŋrep yimb gek, Gor sek, biynimb gok sek nup niŋey tep gak. ");
INSERT INTO kmh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rom gapman biyomb yimb Siysa Taybiyriyas, miñmon okok kond mindek, simiy ak yin ayak anjip piskind ak. Pen nuk paryomb okok mindiy, bi kond mindep namb kayaŋ nuk gunap aŋgek, am miñmon sikoy gunap kond mindeyak. Binuk Ponsis Paylat, Jiwdiya biynimb gok kuyip kond mindek. Binuk Herot, Galiyliy biynimb gok kuyip kond mindek. Herot numam nuk Piyliyp, Yitiwriya biynimb gok sek, Trakonaytis biynimb gok sek kond mindek. Layseniyas, miñmon Abiyliyniy biynimb gok kuyip kond mindek. ");
INSERT INTO kmh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pen won kun ak, binak Anas yip, Kayapas yip, biyomb Gor nup simboŋgep omiŋal ak Jerusalem minderik. Pen ñin namb kun ak, Sekaraya ñinuk Jon, biynimb kuŋay ma mindeyak namb okok kin mindakniŋ, Gor nup gos ñek, ");
INSERT INTO kmh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Joden ñiŋg gol okok amiy, biynimb gok kuyip minim aŋgñiyiŋg aŋgyiŋgip, “Tap siy tap timey gipim ak, yenen kun gipun aŋgiy kirgiy, Gor nup nep gosimb niŋem, nimbip ñiŋg pikñen mey; Gor niŋiy kirginiŋgamb aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon kuyip Gor minim aŋgñak kun ak, bi Gor minim aŋgep Asaya, giniŋgamb aŋgiy tikak rek nep gak. Asaya minim tikiy aŋgak: “Bi bap biynimb kuŋay ma mindpay namb okok meŋg miŋgan dand araniy aŋgniŋgamb, ‘Per, biyomb asaw aŋgiy, kinjeŋ pindrep giy kond mindpay. ");
INSERT INTO kmh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kun ak, dum okok piŋiysak tep giy, giw miŋgan okok lum ñi tep giy, kinjeŋ tind mand giy mindonimuŋ gok; pind yipund giy, kamb gok diyok tep giy, tap siy tap timey gipim ak kirgiy, Biyomb anup kond mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kun giy mey, biynimb okok maŋgiysek, Gor binuk yokek biynimb diniŋgamb anup niŋrep giniŋgiy aŋgniŋgamb’ aŋgiy” tikak. ");
INSERT INTO kmh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon Asaya aŋgiy tikak rek aŋgakniŋ, biynimb kuŋaynep mindek ak apiy aŋgyak, “Chinup ñiŋg pikñan aŋgey,” kuyip aŋg giy aŋgak, “Siyŋ saraw ñapan nuk guniy. Yerip gos ak niŋiy pirik opim? ‘Ñiŋg pikon, Gor biynimb gunap kuyip aŋg giniŋgamb ñin ak, chinup ma aŋg giniŋgamb aŋgiy’ pirik opim? ");
INSERT INTO kmh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ñiŋg pikniŋg, tap siy tap timey gipim gok yenen kun gipun aŋgiy kirgem mey, Gor nup gosimb niŋbay aŋgiy, nimbip ñiŋg pikñinim! Pen gos bap niŋiy, chin Ebraham ñapan nuk aŋgiy, Ebraham nup nep gos ak ma niŋnimimb. Nuk tikek, tikey wak gok chin mindpun apim ak, tap yikop. Gor kamb guniy diy, Ebraham ñapan nuk gunap giniŋg gipkop. Kun ak bi tep Ebraham tikek; tikey amiy apiy gek chinup tikpay apim ak, Gor niŋek minim rek ma apim. ");
INSERT INTO kmh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Pen niŋrep ginimimb! Gor mon maŋgiy ma piyip gok timb daŋgiyniŋg, tiw ak mamb giy mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon minim kun ak rek aŋgakniŋ, nup pen aŋgniŋiy aŋgyiŋgipay, “Chinup yergiyaŋ aŋgiy apan?” Aŋgey, kuyip aŋgyiŋgip, ");
INSERT INTO kmh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Biynimb tiŋgliys omiŋal mindonimuŋ gok, bap biynimb tiŋgliys ma mindonimuŋ gok kuyip ñiniŋgiy. Pen biynimb tap keñmaŋgiy mindonimuŋ gok, gunap biynimb tap ma mindonimuŋ gok kuyip ñiniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pen bi takes dep gok, Jon chinup ñiŋg pikñaŋ aŋgiy, ap nup aŋgniŋiy aŋgyiŋgipay, “Tiysa. Chin yerginjun?” ");
INSERT INTO kmh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aŋgey, kuyip aŋgyiŋgip, “Takes ak diniŋg, gapman kay apay rek nep dinimimb. Yesek gunap ma dinimimb aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Rom biynimb, amiybi kiyk ap poliys rek mindyiŋgipay gok, Jon nup minim kun ak rek nep aŋgniŋiy aŋgyiŋgipay, “Chin yerginjun?” Aŋgey, kuyip aŋgyiŋgip, “Biynimb gok kuyip timey ma giy, kor yesek giy maniy kuyip ak ma dinimimb. Woŋg gipim rek nep dinimimb aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pen kun gi mind dand amiy, biynimb gok gos ar bap niŋiy aŋgyak, “Bi biy, Kiyŋ yomb key yimb per kond mindpun ak rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aŋgey, nuk minim kun ak niŋiy kuyip aŋgak, “Yand nimbip yikop ñiŋg pikñimbiyn; Biyomb yimb ak kisen winiŋgamb. Nuk Biyomb yimb; yand bi yikop. Nup niŋen yip nambiŋ gip. Tomb tirup nup gok tuŋgasikyiŋg, tap nup gok marik ginim rek ma ayip. Nuk apiy, Gor Kawnan yipund giy, mon maŋlaŋ rek ak nimbip yokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Pen nuk wiyt maŋgiy pikgek gipay rek ak giniŋgamb. Wiyt maŋgiy ñiŋemb gok key ay, wiyt cheŋg gok key ay giniŋgamb. Kun giy, wiyt maŋgiy ñiŋemb gok dand korip nuk amniŋgamb, cheŋg gok dam mon per yin mindip ak yokniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon biynimb gok kuyip, Gor minim tep ak ar gunap aŋgen niŋrep giyaŋ aŋgiy, minim tep kun ak rek sikoy ma aŋgyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Pen gapman biyomb Herot, tap siy tap timey okok gi dand amiy, numam Piyliyp biynuk Herodiyas nup kunep di gek, Jon, ak girep ma gip aŋgek, Herot niŋiy, nup dam kalambis ayak. Herot kisen timey gak ar bap mey kun ak. ");
INSERT INTO kmh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Pen Jon nup kalambis ma ayak won ak, biynimb gok kuyip ñiŋg pikñiyiŋgip. Jiysis nup kunep ñiŋg pikñek, nuk Nop Gor nup aŋgniŋ mindakniŋ, semb biyoŋ liŋg keykey amek, Gor Kawnan ak yakir kochir rek Jiysis ker wakniŋ, minim bap semb biyoŋ nimb apiy aŋgak, “Ñi tep yand! Nip niŋen yip tep yimb gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pen Jiysis simiy nuk ak ñin jiwiy, andikiy onep ar ak amnakniŋ, tikjak Nop Gor nup woŋg ak gak. Biynimb gok Jiysis nup aŋgniŋyak-eŋ, “Nop nuk mey; binak Josep aŋgniŋyak.” Josep nop ak Heliy. ");
INSERT INTO kmh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heliy nop ak Matat. Matat nop ak Liypay. Liypay nop ak Melkay. Melkay nop ak Janay. Janay nop ak Josep. ");
INSERT INTO kmh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nop ak Matatayas. Matatayas nop ak Emos. Emos nop ak Neyam. Neyam nop ak Eslay. Eslay nop ak Nagay. ");
INSERT INTO kmh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay nop ak Mat. Mat nop ak Matatayas. Matatayas nop ak Semen. Semen nop ak Josek. Josek nop ak Joda. ");
INSERT INTO kmh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nop ak Jowanan. Jowanan nop ak Resa. Resa nop ak Serababel. Serababel nop ak Siyaltiyel. Siyaltiyel nop ak Neray. ");
INSERT INTO kmh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neray nop ak Melkay. Melkay nop ak Eday. Eday nop ak Kosam. Kosam nop ak Elmandam. Elmandam nop ak Yer. ");
INSERT INTO kmh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yer nop ak Josiwa. Josiwa nop ak Eliysa. Eliysa nop ak Jorim. Jorim nop ak Matat. Matat nop ak Liypay. ");
INSERT INTO kmh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liypay nop ak Simiyon. Simiyon nop ak Jiwda. Jiwda nop ak Josep. Josep nop ak Jonam. Jonam nop ak Eliyakim. ");
INSERT INTO kmh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim nop ak Meliya. Meliya nop ak Mena. Mena nop ak Matata. Matata nop ak Netan. Netan nop ak Depiyt. ");
INSERT INTO kmh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depiyt nop ak Jesiy. Jesiy nop ak Obet. Obet nop ak Bowas. Bowas nop ak Salmon. Salmon nop ak Nason. ");
INSERT INTO kmh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nop ak Amiynadap. Amiynadap nop ak Atmiyn. Atmiyn nop ak Anay. Anay nop ak Hesron. Hesron nop ak Peres. Peres nop ak Jiwda. ");
INSERT INTO kmh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jiwda nop ak Jekop. Jekop nop ak Aysek. Aysek nop ak Ebraham. Ebraham nop ak Tera. Tera nop ak Nowa. ");
INSERT INTO kmh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nowa nop ak Seruk. Seruk nop ak Reyiw. Reyiw nop ak Pelek. Pelek nop ak Ebey. Ebey nop ak Sela. ");
INSERT INTO kmh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nop ak Keynan. Keynan nop ak Apaksat. Apaksat nop ak Siyem. Siyem nop ak Nowa. Nowa nop ak Lamek. ");
INSERT INTO kmh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nop ak Metiwsala. Metiwsala nop ak Yinok. Yinok nop ak Jaret. ");
INSERT INTO kmh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jaret nop ak Makalalel. Makalalel nop ak Keynan. Keynan nop ak Enos. Enos nop ak Set. Set nop ak Andam. Andam nup mey, Gor gayak. ");
INSERT INTO kmh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Pen Jiysis Joden ñiŋg mindiy andkind owakniŋ, Gor Kawnan ak nup bak ay, dand miñmon nep namb okok amek, nuk tap ñimbiy mer; yikop nep mindek ñin omiŋal jiwak. Pen nuk kun okok giraŋgakniŋ, Seytan minim yip ak niŋaŋ aŋgiy, ap nup aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","“Nand Gor Ñinuk mindiy ker, kamb biy aŋgey biret rek ayek ñiŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aŋgek, Jiysis nup pen aŋgak, “Baybol buk ak tikiy aŋgyak, ‘Biynimb gok biret nep ñimbiy ma mindeniŋgambay aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aŋgek, Seytan Jiysis nup dand miñmon yirik paryomb yimb bap amiy, miñmon okok maŋgiysek yimb yomiy ");
INSERT INTO kmh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","aŋgak, “Miñmon teprep guniy niŋan! Biyomb keykey kond mindpay. Yand miñmon kun gok maŋgiysek kond mindpiyn rek, bi bap nup aŋgniŋg aŋgniŋgayn. Kun ak nand koŋgim yimiy yip aŋgniŋeniŋgamban, miñmon kun guniy maŋgiysek nip aŋgen, yimb yomb mindakniŋ kond mindeniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aŋgek, Jiysis pen aŋgak, “Nip ma nep aŋgniŋniŋgayn! Baybol buk ak tikiy aŋgyak, ‘Biyomb chin Gor nup nep aŋgniŋiy, woŋg nup anep giñinimimb aŋgyak’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kun aŋgek, Seytan Jiysis nup poŋind Jerusalem amiy, dand Gor aŋgniŋep korip yiy akyoŋ giyak ar ak amiy aŋgak, “Nand Gor Ñinuk mindpiyn aŋgiy, pindeŋg man biyaŋ ayan! ");
INSERT INTO kmh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Baybol buk ak tikiy aŋgyak, ‘Gor enjol nuk gok aŋgek nip kond mindeniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Minim bap pen tikiy aŋgyak, ‘Apyap pikniŋg gey, nip dand araney, kamb tomb nip ak ma pikniŋgamb aŋgyak’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Seytan kun aŋgek, Jiysis aŋgak, “Biyomb Gor windin yirik ar ak, ñiñloŋ ay kun ak rek ma giniŋgayn. Baybol buk ak, ‘Nup ñiñloŋ ma ayep aŋgiy tikyak’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seytan Jiysis nup minim tom gi mer niŋiy, kiriŋg amiy, gos nuk okok nep, ‘Minek gunap, nup tip ak tom ginim aŋgiy’ kasek ma andkind owak. ");
INSERT INTO kmh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pen Gor Kawnan ak Jiysis nup kond mindakniŋ, andkind ap miñmon Galiyliy mindiy, key yimb gek niŋiy, minim nup ak yiŋg dand, miñmon Galiyliy namb okok maŋgiysek amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nuk Jiwda nan-gep korip okok amiy, minim aŋgrep gek, nup bi tep yimb aŋgiy, miñmiñ yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pen Jiysis nuk miñmon Galiyliy namb okok giraŋg diy, miñmon sikoy mindiy yomb gak Nasaret am mindek. Jiwda lotiw ñin ak apek, per giyiŋgip rek, nan-gep korip ak amiy, tikjakiy Baybol buk ak riytiym giniŋg gek, ");
INSERT INTO kmh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","nup bi Gor minim aŋgep Asaya tikak buk band ak dap ñey, di wisikiy, minim aŋgniŋg gak day ak niŋiy, kuyip riyt giy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Biyomb ak, woŋg nuk gunap yip gaŋ aŋgiy, Kawnan nuk ak yokek yand yip mindip. Kun ak biynimb simbgeprek gok aŋgrep gen niŋniŋgambay. Biynimb kalambis rek mindpay gok wisik yoken amniŋgambay. Biynimb windin koy rek mindpay gok gen niŋniŋgambay. Biynimb kosyam mindpay gok direp giniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pen Gor biynimb diniŋgamb ñin tep ak, miñiy owip aŋgiy, biynimb gok kuyip aŋgñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jiysis minim kun ak riyt gi day jiwiy, buk band ak kom kom giy, bi buk kond mindyiŋgip anup tip ak ñiy bisgek, biynimb mindeyak gok maŋgiysek windin ak jiwiy nup nep niŋeyak, kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","“Asaya Biyomb aŋgek, per kond mindpim kun ak miñiy miseŋ niŋsipim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kun aŋgek, minim tep yimb nuk aŋgak ak niŋiy, yimb nup ak dand araniyak. Pen gos bap niŋiy aŋgyak, “Bi kun biy Josep ñinuk rek?” ");
INSERT INTO kmh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kun aŋgey, Jiysis kuyip aŋgak, “Pen yand niŋbiyn! Yip aŋgniŋgambim, ‘Nand Kiyŋ yomb key yimb per kond mindpun ak, miñmon Kapaniyam mindiy, tap mageprek gey, yind achimal apek niŋbun rek ak, miñmon nak biy kunep gey niŋjun aŋgniŋgambim.’ ");
INSERT INTO kmh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pen nimbip niŋind aspiyn. Bi Gor minim aŋgep gok, miñmon bapik okok taŋgiy, minim tep ak aŋgey, niŋind apay aŋgiy dipay. Pen miñmon kiyk ak key ap aŋgey, bi chin gok key aspay aŋgiy minim kuyip ak ma dipay. ");
INSERT INTO kmh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Pen niŋim! Bi Gor minim aŋgep Yilayja mindek ñin ak, simiy omiŋal nokom takin onep kaŋgol ak, miñmon ma yimb pikiy, tap ma jakiy, yiwan yomb sikerek yimb ak gak. ");
INSERT INTO kmh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yisrel biyn yandiw yiwan gak gok, kuŋaynep mindeyak ak pen; Gor Yilayja nup yokek, am miñmon yomb Saydon miñmon sikoy Sareypar amiy, tap mageprek ak gek, biyn yandiw bap keñmaŋgiy nuk kuŋaynep mindek. ");
INSERT INTO kmh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pen ar kun ak rek, kisen, bi Gor minim aŋgep Yilayja mindek ñin ak, Yisrel biynimb soy ayndik ayak gok, kuŋay yimb mindeyak ak pen; kuyip gunap gek suŋ ma ayak; bi Neman miñmon paryomb Siyriya nimb ak nep gek suŋ ayak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jiysis kun aŋgek, biynimb lotiw korip mindeyak gok niŋey miluk timey yimb yapek, ");
INSERT INTO kmh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","nup yuk dam minduŋ okok yokon kumaŋ aŋgiy, yukey amnakniŋ, biynimb kuŋay mindeyak namb okok amiy kapkap amnak. ");
INSERT INTO kmh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nuk miñmon sikoy Kapaniyam Galiyliy propens ak am mindiy, Jiwda lotiw ñin ak apek, tikjakiy kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Gor minim ak yiñrimey giy, yipund giy yimb nep aŋgek, wal yimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pen nan-gep korip namb kun ak, bi kichekiy ambaŋ ayak bap mindek. Nuk suk yomb aŋgiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Bi Jiysis Nasaret nimb! Yerginiŋg opan? Chinup timey giniŋg opan rek ayip. Yand nip niŋbiyn; Gor bi suŋ-tep nuk anep opan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pen Jiysis kichekiy ambaŋ ay mindek kun anup aŋgak, “Minim ma aŋgiy, bi ak kirgiy mis amnoŋ.” Aŋgek, mis amyiŋg, bi nonim yipund giy anup, biynimb mindeyak namb siŋak diyokiy amnak ak pen, nup tapin ma pikak. ");
INSERT INTO kmh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kun gek, biynimb niŋmindeyak gok, kiyk nep aŋgniŋ aŋgniŋ giy aŋgyak, “Bi kalrimey kun biy, minim kun ak akay nimb dand apiy aŋgek, kichekiy gok mis ambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pen Jiysis gak minim kun ak, yiŋg dand miñmon kun okok maŋgiysek amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pen Jiysis Jiwda nan-gep korip ak kirgiy, Saymon korip ak amnak. Saymon biyn numok nuk ak tap yomb giy, mumbwak okok maŋgiysek mon rek yinek mey, biynimb gok apiy Jiysis nup aŋgyak, “Apiy, Saymon numok nup gey, jak amnaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aŋgey, nuk biyn tap gek kum mindek maŋ siŋak apiy aŋgak “Tap gip biy suŋ ayaŋ aŋgak” Kun aŋgakniŋ, won anep suŋ ayek, tikjakiy biynimb ap mindeyak gok kuyip tap keñmaŋgiy gak. ");
INSERT INTO kmh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Biynimb kun okok mindeyak gok, minim kun ak niŋiy, pumb paŋind amnak won ak, biynimb kiyk tap gak gok maŋgiysek dand Jiysis mindek ak apeyak, kuyip nokom nokom diniŋakniŋ suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pen biynimb malñiluk akaŋ, tap yerip ambaŋ ay mindek gok, aŋgek mis amyiŋg, nup niŋyak rek suk yomb aŋgiy aŋgyak, “Nand Gor Ñinuk.” Kun aŋgey, kuyip kun ma aŋgnimimb aŋgek, aŋgak rek niŋiy mis amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Minek miñmon yowakniŋ, Jiysis miñmon kun ak kirgiy, key minden aŋgiy, miñmon nep namb okok amnak. Amek, biynimb gok kisen amiy, nup piyow niŋiy aŋgyak, “Okok ma amnimin; chin yip mindon aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kun aŋgey, Jiysis aŋgak, “Gor yip aŋgyokamb opiyn rek, am biynimb wikan gunap kuyip kunep, Gor biynimb diy kond mindeniŋgamb rek minim ak aŋgniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kun aŋgiy, okok giraŋgyiŋg, am Jiwda nan-gep korip okok amiy, minim tep kun ak kuyip aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jiysis ñin bap am ñiŋg Galiyliy chemb gol ak mindiy, Gor minim tep ak aŋgñakniŋ, biynimb kuŋay yimb nep, minim tep kun ak niŋun aŋgiy, chichmiy yimyiŋg wiyak. ");
INSERT INTO kmh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kun giy wiyakniŋ, Jiysis niŋak, bi piys dep gok, bot omiŋal dap ñiŋg chemb gol kun siŋak ay, piys dep wimben gok wasyim gi mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nuk Saymon Piyta bot ar ak pindeŋg ay aŋgak, “Yip di nembnemb gey, ñiŋg namb siŋbindoŋ amnaŋ aŋgak.” Aŋgek, Saymon Piyta bot ak di nembnemb gek, ñiŋg namb siŋak amek, Jiysis bot ar kun ak bisiŋg mindyiŋg, biynimb gok kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Minim aŋgjiwiy, Saymon Piyta nup aŋgak, “Bot biy pul gi dand ñiŋg namb yomb siŋbindoŋ amiy, wimben ak yokiy piys dim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aŋgek, Saymon Piyta aŋgak, “Biyomb. Miñiy kisyim biyaŋ piys nen taŋgon taŋgon, miñmon yowip ak pen; piys gunap ma dipun. Nand kun apan ak, wimben ak monmon yokniŋun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kun aŋgiy, wimben yokyakniŋ, piys kuŋaynep apiy wimben miŋgan ak amey, wimben ak aranjakiy puŋgrikniŋg rek gak. ");
INSERT INTO kmh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kun gek niŋiy, numam bot ar bap mindeyak gok kuyip ñinan gek apeyak; piys kun gok diy, bot omiŋal kun ak ayey, pisnep aranjakiy, poŋgek yowniŋg rek gak. ");
INSERT INTO kmh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Kun gek niŋiy, Saymon Piyta binuk yip bot ar mindeyak gok gos kuŋay yimb niŋyak. Pen Sebediy ñinuk Jemis yip, Jon yip, bot bap diy Saymon yip woŋg jimñiy giyiŋgipiyr ak, kunep gos kuŋay niŋrik. Pen Saymon am Jiysis mindek maŋ siŋak koŋgim yimiy aŋgak, “Biyomb. Yand bi tap siy tap timey gipiyn ak, nand key okok amnoŋ aŋgak.” Aŋgek, Jiysis aŋgak, “Ma piriknimin. Miñiy ñin biy tikiy, bi piys dep ak kirgiy, bi biynimb dand Gor ker owep ak mindeniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kun aŋgek, bot omiŋal ak dam ñiŋg gol okok ay, piys tap gok kirgiy, Jiysis nup gosimb niŋiy, yip amiy taŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pen kisen Jiysis am miñmon yomb bap mindek, bi soy ayndik mumbwak okok maŋgiysek ayak bap, ap mindek maŋ siŋak koŋgim yimiy aŋgak, “Nand yip gey suŋ ayniŋg, gey suŋ aynimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aŋgek, nip gen suŋ ayniŋgamb aŋgiy, nup diniŋakniŋ, suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Suŋ ayek, bi kun anup aŋgak, “Jiysis yip diniŋek suŋ ayip ma aŋgnimin. Mosis Baybol buk ak tikiy aŋgak rek, soy ayndik yip ak suŋ ayip aŋgiy, am bi Gor nup simboŋgipay gok kuyip yomey, kiyk niŋiy, niŋind apan aŋgey, am siypsiyp ñiluk bap kim tiwniŋg dap kuyip ñiyiŋg aŋgnimin, ‘Yip suŋ ayip rek, Gor nup simboŋgim aŋgiy, siypsiyp ñiluk biy daswiyn aŋgnimin.’ Kun gey, biynimb maŋgiysek niŋiy aŋgniŋgambay, ‘Nup suŋ ayip rek kun gip aŋgniŋgambay.’” ");
INSERT INTO kmh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pen Jiysis nup minim ak, miñmon okok kind kind amek, biynimb kuŋaynep, nup niŋun aŋgiy apyiŋgipay. Biynimb kun gok, gunap minim tep nup ak niŋniŋg apyiŋgipay; gunap chinup gek suŋ ayaŋ aŋgiy apyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Apey, kuyip minim tep aŋgñiy, gek suŋ ayiŋgip. Pen ñin gunap nuk am tip bap key mindiy, Nop Gor nup aŋgniŋ mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ñin bap Jiysis biynimb gok kuyip minim aŋgñi mindek. Pen namb kun ak, bi Peresiy gunap, bi low tiysa gunap ap bisiŋg mindeyak. Bi kun gok, gunap miñmon yomb Galiyliy keykey okok nimb; gunap Jiwdiya keykey okok nimb, gunap Jerusalem nimb wiyak. Pen Jiysis Nop kond mindek ak mey, biynimb tap gak gok gek suŋ aynimuŋ rek ayak. ");
INSERT INTO kmh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pen bi gunap, bi ñin tomb kalaw gak bap nup, Jiysis mindek korip miŋgan ak dand amon, gek suŋ ayaŋ aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","yirar ay dand amiy niŋyak: biynimb gok korip miŋgan kun ak pisnep timbikdak. Kun gek, bi yirar ay dand wiyak kun ak, dand korip ar biyoŋ amiy, korip ak tuŋgyikiy, Jiysis mindek namb siŋak yokey amnak. ");
INSERT INTO kmh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kiyk nuk gek suŋ aynimuŋ rek ayip aŋgiy niŋeyak, Jiysis bi ñin tomb kalaw gak anup aŋgak, “Mam. Tap siy tap timey gach nip chiŋgip ak, niŋiy kirsipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kun aŋgek, bi Peresiy gok sek, bi low tiysa gok sek, gos namb kiyk okok nep key niŋiy aŋgyak, “Bi kun biy an? Nuk Gor nup aŋgjiwyiŋg asap. Gor nep mey, tap siy tap timey gach ak, niŋiy kirginimuŋ rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pen gos niŋyak kun ak, Jiysis key tik niŋiy aŋgak, “Nimb yenen yip gos timey niŋiy kun aspim? ");
INSERT INTO kmh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yand bi ñin tomb kalaw gip biy nup, ‘Tap siy tap timey nip chiŋgip gach ak, wiykyokpiyn aŋgnim?’ Akaŋ; ‘Nip suŋ ayip nen; tikjakiy amnoŋ aŋgnim?’ Akaŋ, minim yerip ak aŋgen, nimbip tep giniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pen niŋrep yimb ginimimb! Minim nup apiyn kun ak, kiñiŋ ak mindip. Bi bap Ñinuk Nop minim ak diy mey; man ar biy apiy, tap siy tap timey gipay gach ak wiykyokniŋgamb aŋgak.” Kun aŋgiy, bi ñin tomb kalaw gak anup aŋgak, “Miñiy nip suŋ ayip nen; tikjakiy yirar band ak dand andkind korip amnoŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kun aŋgek, biynimb gok niŋmindyakniŋ, won kun anep tikjakiy, nup yirar ay dand wiyak band ak diy, Gor nup tep aŋgyiŋg, korip nuk amnak. ");
INSERT INTO kmh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kun gek, niŋiy jiwdiy, Gor nup yimb ak dand aranyiŋg, miñiy key yimb gamb niŋsipun aŋgiy wal aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pen kisen Jiysis amiy niŋak: bi takes dep ak, takes pikyiŋgipay korip miŋgan ak bisiŋg mindek. Yimb nuk ak Liypay. Jiysis nup niŋiy aŋgak, “Apey, yand yip taŋgor aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aŋgek, woŋg giyiŋgip kun ak kirgiy, tap nuk gok maŋgiysek kirgiy, Jiysis yip taŋgyiŋgipiyr. ");
INSERT INTO kmh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pen Liypay, Jiysis nup tap yomb ak korip nuk ak daŋgiy ay, bi takes dep gunap, biynimb yikop gunap suk aŋgek apeyak, kiy yip bisgiy tap ñiŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pen Jiysis kiy yip tap ñimbek niŋiy, bi Peresiy gunap, low tiysa kiyk gok sek ap, Jiysis binuk gok kuyip aŋgyak, “Nimb yenen bi tap siy diy, bi takes diyiŋg maniy siy dipay gok yip bisgiy tap ñimbim?” ");
INSERT INTO kmh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kun aŋgeyak, Jiysis kuyip aŋgak, “Biynimb kim mindpun apay gok, dokta niŋniŋg ma ambay; biynimb tap gip gok nep, chinup gek suŋ ayaŋ aŋgiy, dokta niŋniŋg ambay. ");
INSERT INTO kmh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kun ak rek, yand biynimb tep tep gok kuyip diniŋg ma opiyn; biynimb tap siy tap timey giy, mindrep ma gipun aŋgiy niŋniŋgambay biynimb gok kuyip diniŋg opiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Biynimb gunap Jiysis nup aŋgyak, “Jon binuk gok yip, Peresiy bi kiyk gok yip ñin gunap, Gor nup gos nokom niŋjun aŋgiy, tap ma ñimbiy yiwan nep mindiy, Gor nup aŋgniŋbay. Pen binak gok yenen tap ñimbyiŋg, ñiŋg ñimbyiŋg nep mindpay?” ");
INSERT INTO kmh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kun aŋgeyak, Jiysis kuyip tikdam ay aŋgak, “Chin Jiwda biynimb gipun ar ak; bi bap biyn diniŋg gek, binuk gunap tap yomb ñiŋniŋg geniŋgambay, biynimb gunap pen tikjakiy, yenen kun gispim aŋgiy, ma aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pen kisen biyomb kiyk ak nup ñaŋg ayeniŋgambay mey, simb gek tap ma ñiŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pen Jiysis, Jiwda biynimb minim nind aŋgyiŋgipay ak, minim yand kisen dand ownik ak sesek wopsakniŋgiy rek ayip aŋgiy, kuyip minim gunap paydoŋ ay aŋgak, “Chech nindnimb ak talikek, chech kisenimb bap tuŋgralikiy, dap ñaŋgdey, andip andip ma mindeniŋgamb. Keykey yimb ay, omiŋal giy timey yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pen ñiŋg wayn ak kunep; ñiŋg wayn kim ak diy, kanj meymey wak milip miŋgan ak ma sopay. Yenen: soŋgiy simjen ñeniŋgambay, tan araniy, biŋ timey yimb aŋgiy puŋgrikiy soŋgek, meymey wak ak timey giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kun ak niŋiy mey, ñiŋg wayn kim ak diy, meymey wak kim miŋgan ak nep soŋg ayep. ");
INSERT INTO kmh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pen biynimb ñiŋg wayn nindnimb ñimbay gok apay, ‘Ñiŋg wayn nindnimb ak tep yimb aŋgiy,’ ñiŋg wayn kim kisenimb ak niŋey, kuyip tep ma gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kisen Jiwda lotiw ñin bap, Jiysis binuk gok yip wiyt woŋg namb ak amyiŋg, binuk gok wiyt maŋgiy kun gok gunap tik ñin beŋ okok ay, wak pikyokiy ñimbyiŋg ñimbyiŋg amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kun geyak, bi Peresiy gunap niŋiy aŋgyak, “Nimb yenen lotiw ñin woŋg magep biy, wiyt maŋgiy wak pik yoksipim?” ");
INSERT INTO kmh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Aŋgeyak, Jiysis binuk gok giyak kun ak timey ma giyak ak niŋiy, bi Peresiy kun gok kuyip aŋgak, “Depiyt wosrey binuk gok yip yiwan gek, Gor aŋgniŋep korip ak amjakiy, biret Gor windin yirik ar ak ay, bi yikop ma ñimbay; bi Gor nup simboŋgipay gok nep ñimbay biret ak, Depiyt aŋgniŋek, nup ñey, binuk gok yip ñiŋyak. Kuyip yiwan gek giyak kesim kun ak, Baybol buk tikyak ak, nimb ma niŋbim? ");
INSERT INTO kmh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pen lotiw ñin apim ak, bi bap Ñinuk nep kond mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","7","Pen Jiwda lotiw ñin kisen bap, Jiysis Jiwda nan-gep korip ak amiy, kuyip minim aŋgñiyiŋg mindek. Korip miŋgan kun ak, bi ñin pipich gak bap ap mindek. Bi Peresiy gok sek, bi low tiysa gok sek bi kun ak nup niŋyak rek, Jiysis lotiw ñin biy gek suŋ ayniŋgamb akaŋ yergek, nup aŋg gun aŋgiy, niŋyinjsek ay mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pen gos niŋyak kun ak, Jiysis key niŋiy, bi ñin pipich gak anup aŋgak, “Nand jakiy namb siŋbiy owan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aŋgek, jakiy owakniŋ, nuk bi Peresiy gok sek, bi low tiysa gok sek kuyip aŋgak, “Yikop mindep ñin biy rek, biynimb gok kuyip direp giniŋgambun akaŋ; lotiw ñin aŋgiy kuyip kirginiŋgambun? Akaŋ pen, kuyip gon ma jak amniŋgiy; kirgon kumniŋgiy?” ");
INSERT INTO kmh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kun aŋgiy, kuyip niŋkuskus giy, bi ñin timey gak anup aŋgak, “Ñin ak almil ayan!” Aŋgek, almil ayakniŋ, day suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jiysis bi kun anup gek suŋ ayek niŋiy, bi Peresiy gok sek, bi low tiysa gok sek kuyip miluk yimb yapek, Jiysis nup yerginjun aŋgiy, aŋgniŋ aŋgniŋ gi mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pen ñin namb kun siŋak ñin bap, Jiysis Nop nup aŋgniŋiyn aŋgiy, dum akyoŋ amiy, Nop nup aŋgniŋ mindek mindek, miñmon yowak. ");
INSERT INTO kmh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Minek pumb wakniŋ, biynimb nuk gok maŋgiysek aŋgek apeyak, binuk onep wimiŋgan ak kuyip tuŋgasik key ay, kuyip bi minim yip dand amemb gok mindeniŋgambim aŋgiy, aŋgayak. ");
INSERT INTO kmh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Binuk aŋgayak kun gok yimb kiyk mey; Bap Saymon. Jiysis yimb nup bap ay, “Piyta” aŋgak. Bap Enjriw. Saymon numam nuk ak. Bap Saymon yimb aloŋg, Saymon Selot aŋgyak. Bap Jemis. Bap “Jemis Alpiyas” aŋgyak. Bap Jon. Bap Piyliyp Bap Batlomiyiw. Bap Matyiw Bap Tomas. ");
INSERT INTO kmh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Bap Jiwdas. Nop yimb ak Jemis. Bap “Jiwdas Yiskariyot” aŋgyak. Nuk nep mey, kisen Jiysis nup ñaŋgyaŋ aŋgiy mimuŋg gak. ");
INSERT INTO kmh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pen Jiysis biynimb nuk kun gok yip, dum biyoŋ kirgiy, am giw tep biyaŋ mindyakniŋ, biynimb kuŋay yimb nep, nup niŋun aŋgiy ap nan-giyak. Biynimb kun gok gunap Jerusalem nimb, gunap Jiwdiya namb okok nimb, gunap miñmon nambiys Taya nimb, gunap miñmon nambiys Saydon nimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pen biynimb wiyak kun gok, gunap Jiysis minim nup ak niŋniŋg wiyak; gunap tap gek, chinup gek suŋ ayaŋ aŋgiy wiyak. Pen biynimb kichekiy ambaŋ ayek mindrep ma giyak gok, chinup gek suŋ ayaŋ aŋgiy, kunep wiyak. ");
INSERT INTO kmh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kiyk kun giy apiy mey, Jiysis nup diniŋon, chinup suŋ ayniŋgamb aŋgiy, ap diniŋyakniŋ kuyip suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jiysis binuk gok kuyip niŋyiŋg aŋgak, “Nimb biynimb simbgeprek mindpim gok, Gor nimbip diy kond mindeniŋgamb! ");
INSERT INTO kmh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nimb Gor biynimb tep nuk mindenjun aŋgiy, mindmaŋgiy piŋiyñimb gok, biynimb nuk yimb mindeniŋgambim! “Nimbip miñiy yiwan yomb gip gok, kisen yiwan ma giniŋgamb! “Nimbip simb gek siy aŋgmindpim gok, kisen tep gakniŋ, miñmiñ giyiŋg mindeniŋgambim! ");
INSERT INTO kmh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Bi bap Ñinuk nup chiŋgiy mindem, nimbip yiruk niŋiy, ‘Biynimb timey kun guniy, an yip mindeniŋgambim aŋgiy,’ nimbip yimb timey ay aŋgjiweniŋgiy, miñmiñ yimb ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Giniŋgambay kun ak nusind yes kiyk gok, bi Gor minim aŋgep gok kuyip, giyiŋgipay rek nep nimbip giniŋgambay. Kun ak niŋiy, Gor chinup direp yimb giniŋgamb miñmon nuk biyoŋ aŋgiy tep gakniŋ, ñin beŋ pikyiŋg, miñmiñ giyiŋg mindenimimb! ");
INSERT INTO kmh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pen nimb biynimb maniy tap okok kuŋay mindip gok, niŋrep yimb ginimimb! Tap nimbik dep rek ak man ar biy pisnep dipim. ");
INSERT INTO kmh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pen nimb miñiy tap rek ñimb gem gem koŋgiy tanimb ak, kisen yiwan yomb giniŋgamb ak niŋ-tep ginimimb! Pen miñiy sik minim aŋgyiŋg mindpim ak, kisen simb gek siy aŋgmindeniŋgambim! ");
INSERT INTO kmh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Pen nimbip yimb dand aranyiŋg nep mindeniŋgambay ak, niŋrep yimb ginimimb. Nusind yes kiyk gok, bi Gor minim yesek aŋgyiŋgipay gok kuyip, kun ak rek giyiŋgipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pen biynimb minim yand aŋgen niŋsipim guniy. Biynimb nimb yip penpen gep gok kuyip wasemb aynimimb. Biynimb nimbip miluk niŋbay gok kuyip direp ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Biynimb gunap, nimbip kunj timey geniŋgiy, kuyip pen wasemb aynimimb. “Biynimb gunap, Gor nimbip timey ginimuŋ aŋgeniŋgiy, nup aŋgniŋem, kuyip kond mindonimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Pen biynimb gunap, nimbip mikem pis ak pikeniŋgiy, andikem, piskind ak kunep pikniŋgiy. “Pen biynimb gunap, kolsiyor nimbip ak deniŋgiy; tiŋgliys ak kunep dim aŋgiy, monmon ñinimimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Biynimb gunap, tap nen asimb aŋgeniŋgiy, niŋind apim aŋgiy ñinimimb. “Pen tap nimbip bap niŋiy deniŋgiy, chinup jiwñan aŋgiy ma aŋgnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Chinup giyaŋ aŋgiy niŋbim rek nep, biynimb gok kuyip ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Biynimb nimbip wasemb aypay gok nep wasemb ayniŋgambim ak, yergiy Gor nup tep giniŋgamb. Biynimb tap siy tap timey gipay gok, biynimb kiyk key gok penpen wasemb aypay. ");
INSERT INTO kmh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Pen biynimb nimbip direp gipay gok nep direp giniŋgambim ak, Gor nimbip yergiy niŋek tep giniŋgamb. Giniŋgambim kun ak, biynimb tap siy tap timey gipay gok, gipay rek nep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Tap ñon pen ñiniŋgambay aŋgiy, gos anep niŋiy tap ñiniŋgambim ak; Gor nimbip yergiy niŋek tep giniŋgamb. Giniŋgambim kun ak, biynimb tap siy tap timey gipay gok, gipay rek nep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kun ak biynimb nimb yip penpen ñaŋgep gok wasemb ay, direp giy, tap monmon ñinimimb. Chinup pen ñiniŋgambay aŋgiy, gos ak ma niŋnimimb. Nap yomb jel gip ak gip rek geniŋgambim mey; nimbip sakiy ma giniŋgamb. Nuk biynimb tap siy tap timey gipay gok sek, nup tep ma apay gok sek kuyip kond mindip. ");
INSERT INTO kmh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Nuk biynimb simb niŋiy dip rek, nimb kunep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Pen chin biynimb tep aŋgiy, biynimb gunap kuyip gos timey niŋniŋgambim ak, minim kun ak andkind nimbip ker winiŋgamb. “Biynimb nimbip timey gipay gok niŋiy kirgeniŋgambim, Gor pen tap timey nimb gipim gok niŋiy kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Tap nimb gok mapin kamb ma giy, biynimb gok kuyip monmon ñeniŋgambim mey; Gor nimbip pen kunep ñiniŋgamb. Pen mapin kamb giy, sikoy sikoy nep ñeniŋgambim, Gor nimbip pen kunep giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pen Jiysis minim bap paydoŋ ay aŋgak, “Bi windin koy bap, bi windin koy bap nup kinjeŋ ak mindip kun aŋgiy, ma yomniŋgamb. Yenen, nuk kun gek, omiŋal giy kaw miŋgan ak apyap pikniŋgayr. ");
INSERT INTO kmh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Biynimb sikul apay gok, am sikul apay won ak, tiysa kiyk gok kuyip wiyniym ma gipay. Pen kisen sikul ak aŋg tep giy mey; tiysa kiyk gok yip andip andip mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Yenen mon bopis windin nimbip pik yiw giy mindip ak niŋaŋgiy mer, namam tap achip windin nup mindip anep niŋapim? ");
INSERT INTO kmh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mon bopis yomb nimbip pik yiw giy mindip ak diyokem, windin yimb ayek rek, yesek namam tap achip sikoy windin nup mindip ak ‘Diyokan aŋgiy apim.’ ");
INSERT INTO kmh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pen mon teprep bind ak maŋgiy timey ma piyp. Mon timey bind ak, maŋgiy tep ma piyp. ");
INSERT INTO kmh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kun ak mon gok piyek niŋiy, mon ak tep; mon ak timey aŋgiy niŋbay. Mon ñiwñiw sek saŋgandlem rek gok, mon tep kondyap rek ma piyniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Biynimb mindrep gipay gok, namb kuyip biyaŋ tep mindip rek, mind tep gipay. Biynimb mindrep ma gipay gok, namb kuyip biyaŋ mindrep ma gip rek, mind tep ma gipay. Pen biynimb yerip rek mindpay ak, minim kiyk aŋgey niŋiy; biynimb gok tep, biynimb gok timey aŋgiy niŋniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Yip Biyomb chin, Biyomb chin, apim ak pen; minim apiyn ak kisen ma gipim. ");
INSERT INTO kmh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Biynimb minim yip ak niŋiy, apiyn rek gipay gok; ");
INSERT INTO kmh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","bi man kilis ar ak korip gek, ñiŋg wilik apiy ma dand amnak rek ak mindpay. ");
INSERT INTO kmh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pen minim yip niŋiy kisen ma gipay gok, bi man sayn ar ak korip gek, ñiŋg wilik apiy, pisnep tuŋgjispuk giy, dand amnak rek ak mindpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jiysis biynimb kun gok kuyip minim aŋgñindiy, Kapaniyam amnak. ");
INSERT INTO kmh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Pen miñmon tiŋgoŋ kun okok, biyomb amiybi kuŋaynep kond mindyiŋgip bap mindek. Nuk minim bap niŋak: Jiysis ap Kapaniyam mindek. Kun ak niŋiy, Jiwdiya miñmon nop nimb biyomb gunap aŋgyokiy aŋgak, “Bi tep woŋg yip giñemb ak, tap giy kumniŋg gisap nen, nimb am Jiysis nup poŋind apem, gek suŋ ayaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Aŋgek, Jiysis mindek ak apiy, kilis giy aŋgyak, “Amiybi kond mindep ak, bi tep yimb. Chinup Jiwda biynimb gok per kond mind tep giy, nan-gep korip chinup bap gak. Kun ak nand bi woŋg giñemb nup ak am gey, suŋ aynimuŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aŋgey, Jiysis bi kun gok yip am am korip siŋak maŋ maŋ giyakniŋ, amiybi kond mindep kun ak, minim bap pen, buŋgiy nuk gunap kuyip aŋgyokek, am Jiysis nup namb pikiy aŋgyak, “Biyomb ak nip aŋgip, ‘Biyomb! Yand bi tep mer, korip yip ak tomb yiwur ma winimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yand bi tep rek nip ker ninim. Pen yand niŋbiyn; Gor nip bak ay mindip ak, suŋ ayaŋ aŋgiy minim anep aŋgenimin, bi yip tap gip biy suŋ aynimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kond mindep yomb yimb yand ak yip kond mindek; yand pen, amiybi gok kuyip kond mindiy, “Amnim!” aŋgen ambay; “Wim!” aŋgen opay; woŋg ak kun kun giy gim aŋgen gipay aŋgip’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kun aŋgeyak Jiysis, bi kun ak gos nuk key niŋiy aŋgip aŋgiy, wal aŋgyiŋg, biynimb nup kisen giy apeyak gok kuyip aŋgak, “Amiybi Rom nimb ak, yip gosimb niŋmindiy, chiŋgrep yimb gip. Yisrel biynimb gunap, yip gos niŋrep giy gip kun ak rek gey, ma niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pen amiybi kond mindep ak, binuk gok andkind amiy niŋyak; Jiysis par okok nep mindiy aŋgek, bi tap gak kun ak pisnep suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ñin namb kun siŋak nep, Jiysis dawin sikoy Nayn amniyn aŋgiy amnakniŋ, binuk gok sek, biynimb yikop gok sek kuŋaynep, nup kisen giy amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Am am miñmon kun ak, kinjeŋ day ak amjakyakniŋ, biyn yandiw bap ñi nokom tikak ak kumek, biynimb kuŋaynep yirar ay dand apeyak. ");
INSERT INTO kmh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jiysis biyn yandiw kun anup niŋek, simb gek aŋgak, “Siy ma aŋgan!” ");
INSERT INTO kmh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kun aŋgiy, chip yirar ay dand apeyak ak am diniŋakniŋ, lum siŋak dayak. Day niŋmindyakniŋ, Jiysis bi paranj kun anup aŋgak, “Ñi tikjakan!” ");
INSERT INTO kmh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aŋgek, tikjak bisgiy minim aŋgakniŋ, nonim nup, “Ñinak ak biy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pen biynimb niŋmindeyak gok gos kuŋay niŋiy, Gor nup yimb ak dand aranyiŋg aŋgyak, “Gor bi minim nup aŋgep yomb bap yokamb, chinup ker wip. Gor chinup aymindniŋg wip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pen Jiysis gak kun ak niŋiy, kesim dey, miñmon Jiwdiya amiy, miñmon yikop okok amiy gak. ");
INSERT INTO kmh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon binuk gok, Jiysis gak rek maŋgiysek niŋiy, am Jon nup aŋgñeyak, Jon binuk omiŋal aŋgek aperik aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Nirmiŋay am nup aŋgniŋiy aŋgnimiyr, ‘Nand Kiyŋ yomb key yimb kond mindpun anep opan akaŋ, bi kun ak key kond mindenjun aŋgnimiyr’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aŋgek, Jiysis mindek ak amiy aŋgrik, “Jon bi ñiŋg pikñemb ak nip aŋgip, ‘Nand Kiyŋ yomb key yimb kond mindpun ak nep opan akaŋ, bi kun ak key kond mindonjun aŋgiy,’ chirup aŋgyokek, nip aŋgniŋniŋg aswur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pen kiykmiŋay kun aŋgiy niŋmindrikniŋ, Jiysis biynimb miñak ar keykey gak gok gek suŋ ayak. Biynimb tap gak gok, gek suŋ ay, windin koy gak gok, gek windin yimb ay, biynimb kichekiy malñiluk ambaŋ ay mindek gok, gek biynimb yimb ay gak. ");
INSERT INTO kmh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kun giy, Jiysis bi omiŋal kun ak kuyip aŋgak, “Nirmiŋay andkind amiy, Jon nup aŋgnimiyr, ‘Chir amiy niŋbur: bi kun ak biynimb windin koy gip gok, gek windin yimb ay; biynimb ñin tomb soy ayndik ayip gok, gek suŋ ay; biynimb timund sakiy ayip gok, gek suŋ ay; biynimb kumbay gok, gek tip ak tikjakiy; biynimb simbgeprek gok, minim tep nuk ak aŋgek niŋbay aŋgnimiyr’ aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pen minim bap aŋgnimiyr, ‘Biynimb yip gosimb niŋiy, chiŋgiy nep mindeniŋgambay gok, miñmiñ yimb giniŋgambay aŋgnimiyr’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kun aŋgek, bi Jon nup minim dand orik omiŋal ak andkind amnirikniŋ, Jiysis biynimb ap mindeyak gok kuyip, Jon nup minim ar ak aŋgiy aŋgak, “Nimb nind miñmon nep namb okok ambik ñin ak, yerginiŋg ambik? Sund par nokom bap yiŋgen diy, dand amiy apiy gek ak niŋniŋg ambik? ");
INSERT INTO kmh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Akaŋ yenen ambik? Bi chech tep ayak bap niŋniŋg ambik? Bi chech tep yimb diy, tap tep tep dun aŋgiy niŋbay gok, mindpay biyomb korip okok nep. ");
INSERT INTO kmh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pen tap yerip ak niŋniŋg ambik? Yikop ma ambik! Bi Gor minim aŋgep, Jon nup nep niŋniŋg ambik. Nuk bi Gor minim aŋgep yikop bap mer; woŋg bap key mindek, Gor nup aŋgek ap minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bi Gor minim aŋgep kun anup mey, wosrey Baybol buk ak tikiy aŋgyak, ‘Gor aŋgip, “Bi minim aŋgep yand ak aŋgen, nind amiy, biynimb gok aŋgrep gek, kisen Ñi yand ak aŋgen niniŋgamb aŋgip” aŋgiy’ tikyak. ");
INSERT INTO kmh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nimbip aspiyn, Jon biynimb nind mindyiŋgipay gok yip, miñiy mindpay gok yip maŋgiysek wiyniym gip ak pen, Gor biynimb yikop diy kond mindeniŋgamb gok, Jon rek ma mindeniŋgambay; kiyk biynimb yomb mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jiysis minim aŋgak kun ak; biynimb yikop gok sek, bi takes dep gok sek nind apey, Jon kuyip ñiŋg pikñek, Gor nup yimb ak dand araneyak mey kun aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pen bi Peresiy gok sek, bi Jiwda low tiysa gok sek alemb alemb ñiy, Gor minim tep ak ma diyak rek, chinup ñiŋg ma pikñiniŋgamb aŋgey mey, kuyip ñiŋg ma pikñak. ");
INSERT INTO kmh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Jiysis kun aŋgiy, kuyip aŋgak, “Nimb biynimb miñiy, ñin namb biy mindpim gok, ñapan sikoy gok silpiŋ ñiyiŋg, gunap apay, ‘Dachiŋ pikon, yenen koŋgim ma papim? Pen kamep simbgeprek aŋgon, yenen siy ma apim apay’ rek ak gipim. Nimb niŋem, Jon gak ak tep ma giy, yand gipiyn ak tep ma giy gip. ");
INSERT INTO kmh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon bi ñiŋg pikñemb ak, ap tap ma ñimbiy, ñiŋg wayn ma ñimbiy gek, nup aŋgjiwiy aŋgyiŋgipim, ‘Bi kichekiy malñiluk ambaŋ ayek mindip ak aŋgyiŋgipim!’ ");
INSERT INTO kmh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pen miñiy bi bap Ñinuk apiy, tap ñimbiy, ñiŋg wayn ñimbiy gek, nup aŋgjiwiy apim, “Tap kuŋay ñimbiy, ñiŋg wayn ñimbiy gip ak mey; nuk biynimb tap siy tap timey gipay gok sek, bi takes dep gok sek bi kiyk apim.” ");
INSERT INTO kmh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pen, biynimb Gor miñ ar ak, chinup tep gip aŋgiy niŋbay gok nep, ar kun ak ambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bi Peresiy bap, yimb nuk Saymon. Nuk Jiysis nup aŋgak, “Apey korip yand ak am tap ñiŋjur aŋgak.” Aŋgek, Jiysis korip nup ak amiy tap ñiŋrikniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","kinjeŋram biyn miñmon kun ak nimb ak, minim bap niŋak; Jiysis ap bi Peresiy ak yip tap ñimberik. Kun ak niŋiy, wel kuy tep wak, kamb botol diy paryak ak dand apiy, ");
INSERT INTO kmh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jiysis mindek kund okok ken amiy, tomb aŋgin ak bisgiy, siy aŋg mindek. Kun giy, siy aŋg mindakniŋ, siy ñiŋg ak tik Jiysis tomb ar ak yapek, jun kas nuk ak wiykyokyiŋg, tomb kind nup ak wel ayñiy, bom silokyiŋg silokyiŋg mindek. ");
INSERT INTO kmh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kun gek, bi Peresiy ak gos nuk anep niŋiy aŋgak, “Bi kun biy, bi Gor minim aŋgep yipund giy mindembikop rek, biyn kinjeŋram ker ap nup diniŋsap ak, tik niŋbikop aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jiysis bi Peresiy gos niŋak kun ak niŋiy, nup aŋgak, “Saymon! Minim nip nokom bap aŋgniŋg gispiyn aŋgak.” Aŋgek, Saymon aŋgak, “Tiysa. Minim kun ak aŋgan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aŋgek, Jiysis tikdam ay aŋgak, “Bi bap tikjakiy, bi omiŋal kuyip, bap nup payp handret kiyna ñiy, bap nup piyptiy kiyna ñiy, giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pen kisen bi omiŋal kun ak, pen ñemb rek ma ayek, bi maniy ñiniŋgamb kun ak, kuyipmiŋay aŋgniŋgamb, ‘Maniy nirip ñimbiyn ak, pen ñinjur aŋgiy gos ak ma niŋnimiyr aŋgniŋgamb.’ Kun aŋgek, bi an bi kun ak nup miñmiñ yimb giniŋgamb? Bi tap day yomb mindeniŋgamb ak akaŋ, bi tap day sikoy mindeniŋgamb ak?” ");
INSERT INTO kmh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aŋgek, Saymon aŋgak, “Gos yand niŋbiyn ak, bi tap day yomb mindeniŋgamb ak aŋgak.” Aŋgek, Jiysis aŋgak, “Niŋind yimb apan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kun aŋgiy, Jiysis andikiy biyn anup niŋyiŋg, Saymon nup aŋgak, “Biyn biy nup niŋan! Yand korip miŋgan nip biy apen, ñiŋg ak diy tomb yip ak ma wasyim gipan; biyn biy yip miñmiñ giyiŋg, siy ñiŋg nuk ak tik yapek wasyim giy, jun kas nuk ak wiykek milip gip. ");
INSERT INTO kmh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yip ma bom silokpan; biyn biy nep apiy tomb kind yip ak bom silokip. ");
INSERT INTO kmh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yip wel ak ma ayñimban; biyn biy nep tomb kind yip ak, wel kuyrep wip ak ayñimb. ");
INSERT INTO kmh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kun ak nip aspiyn: biyn kun biy tap siy tap timey kuŋaynep gip ak niŋiy kirgen, yip pen direp yimb gip. Pen biynimb tap siy tap timey siskoy gipay gok niŋiy kirgen; yip pen direp ma gipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kun aŋgiy, biyn kun ak nup aŋgak, “Tap siy tap timey gipan ak, niŋiy kirpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kun aŋgek, bi nund yip tap ñimbeyak gok, kiyk key aŋgniŋ aŋgniŋ giy aŋgyak, “Bi kun biy yenen, ‘Tap siy tap timey gipim ak niŋiy kirsipiyn asap?’ Gor nep mey kun gipkop aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kun aŋgyak ak pen, Jiysis biyn kun anup aŋgak, “Gos nand anep, tap siy tap timey gipiyn rek, Jiysis niŋiy kirgaŋ aŋgiy opan ak, nip niŋiy kirsipiyn nen, andkind amiy, Gor ñin ar ak mindenimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pen kisen ñin namb kun siŋak, Jiysis binuk onep wimiŋgan ak yip, miñmon yomb miñmon sikoy okok amiy, Gor biynimb nuk diy kond mindeniŋgamb minim tep ak, biynimb okok kuyip aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pen ñin kun ak, biyn tap gek, Jiysis gek suŋ ayak gunap, kichekiy malñiluk sek mindey, nuk gek biyn yimb ayak gunap, yip taŋgyiŋgipay. Biyn kun gok yimb kiyk mey, bap “Makdala biyn Mariya” aŋgyiŋgipay. Nup kichekiy onep ar ak mindek Jiysis aŋgyokak. ");
INSERT INTO kmh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Biyn bap Jowana. Nuŋgumiy yimb ak Chiwsa. Nuk biyomb Herot korip tap nup gok kond mindyiŋgip. Biyn bap Siwsana. Kiyk biyn yikop gunap yip, maniy kiyk gok key dam tap taw dand apiy, Jiysis binuk gok yip, tap jimñiy ñimbyiŋg giraŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Biynimb miñmon keykey, tiwin gok tiwin gok, Jiysis nup niŋniŋg kisen wiyakniŋ, biynimb nind wiyak gok kuyip, minim bap paydoŋ ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Bi bap wiyt jakaŋ aŋgiy, wiyt maŋgiy ak dam woŋgday okok yokeniŋgamb, gunap kinjeŋ kosemb ar ak yapek, biynimb gok taw amiy apiy gey, yakir gok pen ap niŋiy ñiŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gunap kamb ar man siskoy ayniŋgamb okok yapiy, gup giniŋgamb ak pen, kindiy am wos ma giniŋgamb rek, pisnep milip giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pen gunap, kikasik dindbiliŋ namb okok yapeniŋgamb, tap kun ak saw giy, yiwiŋg dek, ma jakniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pen gunap, lum teprep okok yapiy, jakrep yimb giy, maŋgiy kuŋay yimb nep piyniŋgamb aŋgak.” Jiysis kun aŋgiy aŋgak, “Nimb biynimb gos timund sek mindenimimb gok, minim aspiyn biy niŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kun aŋgek, binuk gok nup aŋgniŋiy aŋgyak, “Minim paydoŋ ay aŋgamban kun ak, minim junj nuk yergiy mindip?” ");
INSERT INTO kmh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aŋgey, Jiysis kuyip aŋgak, “Gor biynimb nuk diy kond mindeniŋgamb minim weygiy mindyiŋgip ak, nimbip gos ñek niŋniŋgambim; pen biynimb yikop gok: ‘Aŋgip kun aŋgiy ma piyow niŋniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pen minim paydoŋ ay tap yiŋ rek apiyn ak, Gor minim ar ak apiyn. ");
INSERT INTO kmh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Maŋgiy gunap, yowniŋgamb kinjeŋ kosemb ar apiyn ak; biynimb gok Gor minim ak niŋniŋg gey, Seytan gek sakiy giniŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pen maŋgiy gunap, yowniŋgamb kamb ar man siskoy ayak okok apiyn ak, Gor minim ak niŋey tep gakniŋ, nup gos niŋniŋgambay ak pen, gos kilis yimb giy ma niŋniŋgambay rek, miker gunap apek nup kirginiŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pen maŋgiy gunap, yowniŋgamb kikasik dindbiliŋ namb okok apiyn ak; biynimb gok Gor minim niŋniŋgambay ak pen, kisen minim miker akaŋ; miñmiñ gep ar ak nep gos niŋiy, Gor nup gos kilis giy ma niŋniŋgambay aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pen yiŋ maŋgiy gunap, man tep yimb siŋak yapiy, jak tep giy, maŋgiy kuŋay yimb nep piyniŋgamb apiyn ak; biynimb gok minim tep ak niŋiy, di wos yimb giy, mindrep yimb giniŋgambay gok kuyip apiyn.” ");
INSERT INTO kmh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Pen biynimb gok lam daŋgiy, tiyn miŋgan okok akaŋ, boŋg ar kinbay beŋ okok ma aypay. Melik gek biynimb niŋyaŋ aŋgiy, ar siŋbiyoŋ ayey mey, biynimb gok korip miŋgan apyiŋg, melik kun ak niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Minim weygiy rek mindyiŋgip ak; niŋnimimb rek nep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kun ak minim apiyn gok niŋrep yimb ginimimb. Biynimb minim niŋiy, niŋdiniŋgambay gok, minim tep gunap sek niŋniŋgambay; pen biynimb minim niŋiy ma niŋdiniŋgambay gok, sikoy niŋjun aŋgiy niŋbay ak sek, pisnep kurginiŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pen ñin kun ak, Jiysis numam gunap nonim yip, nup niŋniŋg wiyak. Apiy niŋyak: korip miŋgan kun ak timbik giy aŋgiy mindek niŋiy, mis ar akyaŋ mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kun gek, biynimb ap mindeyak gok niŋiy, Jiysis nup aŋgyak, “Nanim namam nak gok, nip niŋniŋg ap mindpay mis biyaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aŋgey, Jiysis kuyip aŋgak, “Biynimb siŋok Bapiy Gor nup minim ak niŋiy, kindik gipay gok mey; amiy yand, mam yand rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pen ñin bap Jiysis binuk gok yip, “Galiyliy chemb tikiy pis bindoŋ amnun aŋgiy,” bot ak diy saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Namb okok amyiŋg, Jiysis nuk wisin kin amnak won ak, pinim yomb yimb ak ñiŋg namb kun ak diy, ñiŋg paŋg bot miŋgan ak amek, kumniŋgiy rek nep ayak. ");
INSERT INTO kmh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kun gek, binuk gok ap, Jiysis nup kikawin gey tikjakek aŋgyak, “Biyomb! Chin maŋgiysek kumniŋg gispun aŋgyak.” Aŋgey, Jiysis aŋgek pinim yomb dek kun ak won anep kirgiy, ñiŋg paŋg apek ak kirgiy, nind mindek rek mindek. ");
INSERT INTO kmh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pen binuk gok kuyip aŋgak, “Gor nup gosimb niŋbim rek ayip ak, yenen nup aŋgniŋem tap gamb kun ak ma kirgip?” Aŋgek, kiyk pirikiy, aŋgniŋ aŋgniŋ giy, “Bi kun biy an? Pinim yomb dip ak sek, ñiŋg yomb paŋgip ak sek minim aŋgip rek nep gip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pen bot kun ak diy, Galiyliy chemb namb ak am am, Gerasa biynimb mindeyak pis okdoŋ ken amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pen miñmon kun ak, bi kichekiy malñiluk kuŋay yimb ambaŋ ayak bap mindek. Bi kun ak nuk daynep mindiy, korip yimb miŋgan ak ma kinyiŋgip; chip komyiŋgipay kamb miŋgan okok nep kin taŋgyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bi nup kond mindep gok, sen diy, ñin tomb nup gok tiwniŋg wos giyiŋgipay ak pen, kichekiy tap gok ap kilis gey, sen ayiŋgipay kun gok gek puŋgrikek, miñmon nep namb okok pernep amyiŋgip. Pen bi kun ak, Jiysis nup niŋiy wal aŋgiy, ap tomb aŋgin siŋak koŋgim yimek, Jiysis tap nup ambaŋ ayak kun gok kuyip aŋgak, “Bi kun biy nup kirgiy mis amnim aŋgak.” Kun aŋgakniŋ, bi kun ak nup tap ambaŋ ayak kun gok, nembnemb gey, minim yomb aŋgiy aŋgak, “Nand Gor Biyomb jel gip Ñinuk ak, yip tap giniŋg gispan ak ma ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aŋgek, Jiysis aŋgak, “Yimb nand ak aŋgan.” Aŋgek aŋgak, “Yimb yand ak ‘Ñin jiwiy’ aŋgak.” Kichekiy malñiluk gok kuŋay yimb molik sikiy mindeyak rek mey, kun aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pen kichekiy gok, Jiysis nup minim yomb aŋgiy aŋgyak, “Chinup aŋg mon key yinjap kaw miŋgan yomb ak ma yoknimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kun aŋgiy niŋyak; kanj kuŋay yimb nep amil geyak yep pir kun siŋak. Jiysis nup aŋgyak, “Chinup aŋgey, am kanj mindpay gindoŋ kuyip molik sikun aŋgey, ");
INSERT INTO kmh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jiysis “Yaw” aŋgek, bi anup kirgiy, am kanj kun gok kuyip molik sikey, kanj gok puŋgjiw minduŋ biyaŋ amiy, gindam ñiŋg maŋgiy chemb namb biyaŋ pikiy, ñiŋg ñimbiy maŋgiysek kumdiyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pen bi kanj mokep gok, Jiysis gak kun ak niŋiy, puŋgrikind aŋgiy am biynimb miñmon yomb mindeyak gok kuyip aŋgñiy, am biynimb miñmon yikop okok mindeyak gok kuyip aŋgñiy giyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kun giy aŋgñeyak, “Tap kun ak yergek niŋiy aspay aŋgiy,” apiy niŋyak: bi kichekiy molik sikiy mindyiŋgip ak, biyimb ay, walinj yimiy, Jiysis tomb aŋgin siŋak bisiŋg mindek niŋiy, pirikyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pen biynimb niŋmindey Jiysis kichekiy aŋg mis yokak gok, biynimb kisen wiyak gok kuyip, kun kun gip aŋgiy aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pen Gerasa biynimb maŋgiysek kuyip jel gek, pirikiy, Jiysis nup aŋgyak, “Nand andkind amnoŋ aŋgey,” bot diy amniŋg gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","bi kichekiy ambaŋ ay mindek, Jiysis gek biyimb ayak ak, Jiysis nup aŋgak, “Yand nand yip amjipur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kun aŋgek, Jiysis nup aŋgak, “Mer. Gor nip yerer gip ak, am biynimb nand gok kuyip aŋgñinimin aŋgak.” Aŋgek, nuk andkind amiy, biynimb gok kuyip, Jiysis yip kun kun gip aŋgiy aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pen biynimb Jiysis asaw aŋgiy kond mindeyak gok, nuk bot diy amjakek niŋiy, “Tep aswan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Pen biyomb Jiwda nan-gep korip kond mindyiŋgip bap, yimb nuk Jayras. Pañ nuk nokom yimb simiy yin ayak wimiŋgan ak kumniŋg gek, Jiysis mindek siŋak ap koŋgim yimiy aŋgak, “Apey, korip yand amnur aŋgak.” Aŋgek, Jiysis niŋniŋg amnakniŋ, biynimb kuŋay yimb nep, ap nup pis pis chichmiy yimyiŋg amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Pen biyn bap, biyn kinjeŋ pandikakniŋ mindek, simiy yin wimiŋgan ayak bap, Jiysis amek kund okok ken apiy, chech paryomb ayak ak diniŋakniŋ, suŋ ayak. Biyn kun ak, dokta gok yip gey suŋ ayaŋ aŋgiy, kuyip maniy ñiyiŋgip ak pen, nup gey suŋ aynimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pen Jiysis kuyip aŋgak, “Yip an diniŋimb?” Aŋgek, biynimb gok aŋgyak, “Chin ma niŋbun aŋgyak.” Aŋgey, Piyta aŋgak, “Biyomb. Biynimb kuŋaynep akniy, ap nip chichmiy yimey niŋiy aspan rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aŋgek, Jiysis aŋgak, “Biynimb nokom bap yip diniŋek, suŋ ayip ak niŋiy aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pen biyn Jiysis nup diniŋak kun ak, weyginimuŋ rek ma ayek niŋiy, jep diyiŋg, Jiysis mindek maŋ siŋak ap koŋgim yimiy, biynimb gok niŋmindyakniŋ aŋgak, “Yip biyn kinjeŋ minek minek pandikip ak, nip diniŋen pisnep suŋ ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aŋgek, Jiysis aŋgak, “Pañ yand. Yip gosimb niŋiy, nup diniŋen yip suŋ ayniŋgamb aŋgiy, diniŋey nip suŋ ayip ak, minim ma mindip. Amnoŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jiysis kun aŋgakniŋ, bi Jayras nup woŋg giñiyiŋgip ak apiy, Jayras nup aŋgak, “Panak pisnep kumimb; tiysa nup aŋgey tomb yiwur ma winimuŋ. Aŋgey, andkind amnaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aŋgek, Jiysis minim kun ak niŋiy, Jayras nup aŋgak, “Pañ yand ak kumimb aŋgiy gos ak ma niŋnimin. Yip gosimb niŋeniŋgamban, gen tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kun aŋgiy korip ak amjakiy, biynimb gok kuyip maŋgiysek aŋg mis akyaŋ ay; pañ nop nonim omiŋal ak, Piyta ak, Jon ak, Jemis ak kuyip poŋind pañ kun ak niŋniŋg, korip miŋgan biyaŋ amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pen pañ ak kumimb aŋgiy, biynimb siy aŋg mindeyak gok, Jiysis kuyip aŋgak, “Siy ak ma aŋgim. Ñapan kun biy ma kumimb; yikop wisin kinjap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kun aŋgek, nup sik aŋgiy aŋgyak, “Ñapan pisnep kumimb ak, yenen kun asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pen Jiysis pañ kumak kun anup, ñin kind ak diy aŋgak, “Tikjakan!” ");
INSERT INTO kmh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kun aŋgakniŋ, kawnan nuk ak tip ap tokow gek tikjakak. Jiysis nop nonim kuyip aŋgak, “Tap gunap ñer ñiŋaŋ.” ");
INSERT INTO kmh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kun aŋgiy, kuyip ber aŋgak, “Biynimb gunap kuyip, minim kun ak ma yimb aŋgñinimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jiysis binuk onep wimiŋgan ak kuyip aŋgek apeyak, aŋgak, “Nimbip kond mindeniŋgayn ak mey, okok amiy, kichekiy malñiluk biynimb molik sikek mindpay gok aŋgem mis amiy, biynimb tap gip gok gem suŋ ay, Gor biynimb diy kond mindeniŋgamb minim ak aŋgñiy, ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Pen amniŋg; yir kondim, maniy, wand, chech, tap ñiŋemb tap gok sek dand ma amnimimb. Yikop amnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Korip bap amjakem, nimbip aŋgdeniŋgiy, kiy yip kin tep giy, amniŋg ginimimb ñin ak nep amnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Pen miñmon wikan gunap amem, nimbip ma aŋgdeniŋgiy, miñmon kun ak kiriŋg amniŋg, kuyip aŋgnimimb, ‘Minim tep ak dand apambun ma dipim rek, miñmon nimbip biy apon, silkul day day tomb chinup dip ak wiykyokiy amjipun aŋgiy,’ wiykyokiy amnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kun aŋgakniŋ, kiyk miñmon sikoy okok amiy, minim tep nup ak aŋgñiyiŋg, biynimb tap gak gok, gey suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pen biynimb gok, Jiysis yerer gak minim ak aŋg amiy apiy giyakniŋ, gapman biyomb Herot niŋiy, gos kuŋay yimb niŋak. Biynimb gunap aŋgyak, “Jon bi ñiŋg pikñemb kuŋam tikey kumimb ak, tip tikjakip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gunap, “Bi Gor minim aŋgep nindnimb Yilayja, tikjakip aŋgyak.” Gunap, “Bi Gor minim aŋgep wosrey bap tikjakip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kun aŋgey, biyomb Herot aŋgak, Jon nup kuŋam tiken kumimb ak, bi kun ak an ap mindakniŋ aspay ak, yand am niŋnim aŋgiy gos niŋak. ");
INSERT INTO kmh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pen Jiysis binuk onep wimiŋgan ak andkind apiy, miñmon okok taŋgiy, yerip yerip giyak minim ak nup aŋgñiyakniŋ, am miñmon wikan bap key mindon aŋgiy, kuyip poŋind miñmon Betsayda amniŋg, saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kinjeŋnamb okok amniyakniŋ, minim bap aŋgyak, “Jiysis binuk gok yip apiy pandiksipay aŋgyak.” Kun aŋgey, biynimb tiwin gok tiwin gok, nup niŋniŋg wiyak. Apeyak, tep opim aŋgiy, Gor biynimb diy kond mindeniŋgamb minim ak kuyip aŋgñiyiŋg, biynimb tap gak gok, gek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pen duŋgep pumb paŋind amnak won ak, binuk onep wimiŋgan ak apiy, nup aŋgyak, “Miñmon akniy, biynimb ma mindpay namb okok mindpun ak; biynimb guniy aŋgyokey, biynimb mindpay okok amiy, keñmaŋgiy kiyk gok key piyow niŋyiŋg, kiniŋgiy miŋgan ak piyow niŋyiŋg giyaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kun aŋgeyak, Jiysis aŋgak, “Nimb key kuyip keñmaŋgiy ñinimimb aŋgak.” Aŋgek aŋgyak, “Chin tap ñiŋemb kuŋay ma mindip. Yikop biret onep mamind ak mindiy, piys omiŋal mindiy gip. Nand yerip gos niŋban? Biynimb biy kuŋay yimb mindpay ak, chin am tap ñiŋemb kuyip gunap taw dand winjun? aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ñin kun ak, biynimb ap nan-giyak gok, biyn gok sek, ñapan ŋaŋ gok sek mer, bi gok nep mey payp tawsin amnak. Pen Jiysis binuk gok kuyip aŋgak, “Biynimb kuŋay ap mindpay biy aŋgem, tiwin keykey bisgiyaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aŋgek, aŋgak rek gey, ");
INSERT INTO kmh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","nuk biret onep mamind ak sek, piys omiŋal ak sek diy, kuyoŋgiy niŋiy, Gor nup “Tep” aŋgiy, tipaŋg binuk gok kuyip ñek, kiy pen diyiŋg, biynimb gok kuyip bilok ñiyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ñeyak, ñimb dand amiy, ñimb diniŋgiy rek ma ayek, day day kirgiyak gok, binuk gok wand onep wimiŋgan ak yiŋgey arachakak. ");
INSERT INTO kmh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pen ñin bap Jiysis am keynep mindiy, Gor nup aŋgniŋ mindakniŋ, binuk gok amjakey, kuyip aŋgniŋiy aŋgak, “Biynimb yikop gok yip an aŋgiy niŋbay?” ");
INSERT INTO kmh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aŋgek aŋgyak, “Biynimb gunap, nip Jon bi ñiŋg pikñemb ak aŋgiy niŋbay. Gunap, bi Gor minim aŋgep nindnimb Yilayja aŋgiy niŋbay. Gunap, bi Gor minim aŋgep nindnimb bap, tikjakip aŋgiy niŋbay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aŋgeyak, kuyip aŋgak, “Nimb key yip bi an aŋgiy niŋbim?” Aŋgek, Piyta aŋgak, “Nand Bi kiyŋ yomb key yimb, Gor chinup wosrey yokniŋgayn aŋgak ak nep opan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kun aŋgek, Jiysis kuyip aŋgak, “Minim kun ak, biynimb gunap kuyip ma aŋgñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kun aŋgiy, minim bap pen aŋgak, “Bi bap Ñinuk nup yiwur yomb yimb ak ñiniŋgambay. Bi minim tuŋgasikep yomb gok, bi low tiysa yomb gok, bi Peresiy yomb gok nup ma diy, miluk niŋiy ñaŋgayniŋgambay ak pen; ñin omiŋal nokom mindiy, tip ak tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pen nuk binuk gok sek, biynimb mindeyak gok sek kuyip aŋgak, “Biynimb an yip ker mindniŋg ginimuŋ ak, tap man ar biy gos yomb niŋbay ak kirgiy, pumbnamb kisyimken, gos yand niŋiy apiyn ar ak nep giy; miker diy kumniŋgambay gos ak ma niŋiy, sakiy giy nep yip chiŋgiy taŋgeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Biynimb Jiysis nup diy mindon, tep ma giniŋgamb aŋgiy niŋniŋgambay gok, pisnep apyap pikniŋgambay. Pen biynimb nup diy mindon, chinup yerer giniŋgamb ak, minim ma mindip aŋgniŋgambay gok, mind tep gep ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Biynimb tap man ar biy dun aŋgiy gey amniŋgamb gok, gos yomb kiyk ak tap man ar biy ker nep amek, Gor yip perper mindeniŋgiy rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Biynimb an kuyip nambiŋ ginimuŋ rek ayek niŋiy, “Jiysis nup ma niŋbun aŋgniŋgambay ak, kisen yand Bapiy melik chirapiy ak diy, enjol suŋ-tep gok sek winiŋgayn ñin ak, kuyip pen kunep Bapiy nup, ‘Kuyip ma niŋbiyn aŋgniŋgayn.’ ");
INSERT INTO kmh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Pen nimbip niŋind yimb aspiyn. Biynimb miñiy mindpim guniy, gunap ma kumniŋgambim; kim nep mindiy, Gor biynimb diy kond mindeniŋgamb ak niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jiysis kun aŋgiy, ñin anep jiy ak rek mindiy; Jon, Jemis, Piyta kuyip yakam poŋind, Gor nup aŋgniŋniŋg yep dum kun siŋak amnak. ");
INSERT INTO kmh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Amiy, Gor nup aŋgniŋ mindakniŋ, jomluk nup ak key yimb ay, chech nup ak tund giy ñiñakol yimb gak. ");
INSERT INTO kmh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kun gakniŋ, bi wosrey kumrik, Mosis yip, Yilayja yip Gor melik ak diy apiy, Jiysis Jerusalem ameniŋgamb nup mon kiros bak biyoŋ ñaŋgbirik ayey, kumniŋgamb minim ak aŋg mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pen Piyta, Jemis, Jon kuyip yakam wisin apek, windin jukjuk gi mindeyak ak pen, tikjakiy Jiysis melik tep nup ak niŋiy, bi omiŋal yip jak mindeyak gok niŋiy giyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bi omiŋal kun ak amniŋg girikniŋ, Piyta gos niŋrep giy mer, Jiysis nup aŋgak, “Biyomb. Chin biy mindpun ak tep yimb mindpun. Chinup yaw aŋgey, korip bandak band omiŋal nokom gun. Nip bap, Mosis nup bap, Yilayja nup bap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kun aŋgakniŋ, won kun anep, semb tund yomb ak kuyip ap maŋgiysek yiw gakniŋ pirikyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pen minim bap semb namb kun ak nimb apiy aŋgak, “Bi biy, Ñi mapin yand. Minim aŋgnimuŋ rek niŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Won kun ak nep; bi omiŋal kun ak ma minderik; Jiysis nep mindek. Pen dum biyoŋ mindey tap gek niŋyak kun ak, ñin namb kun siŋak biynimb gunap kuyip ma aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pen minek dum biyoŋ kirgiy, kinjeŋnamb okok apyapyiŋg niŋyak, biynimb kuŋay yimb nep, Jiysis nup piyowey apek. ");
INSERT INTO kmh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bi bap biynimb namb kun ak, suk yomb aŋgiy aŋgak, “Tiysa! Ñi yip nokom biy simb niŋan aŋgiy dand aswiyn. ");
INSERT INTO kmh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kichekiy ak pernep ambaŋ ay mindiy, nup gek suk yomb sikerek aŋgiy, gi dam pikiy, kosimb asimb apiy, kumdam namb ayiŋg wip. Nup kun giy, perper gek mey, mind tep ma gip. ");
INSERT INTO kmh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bi nak gok kuyip, kichekiy mindip kun ak aŋgyokim apiyn ak pen; kiyk aŋgyok mer niŋiy kirpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kun aŋgek, Jiysis aŋgak, “Biynimb miñiy mindpim ar biy, minek akay Gor nup gosimb niŋniŋgambim? Ma yimb niŋbim kun ak, yergiy minim kil sek aŋgnim?” Kun aŋgiy, bi kun anup aŋgak, “Ñi nand kun ak dand siŋbiy owan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aŋgek, dand owakniŋ, kichekiy ak ñi kun anup tip ak kilis giy pipaŋg yokek gindam pikak. Jiysis pen kichekiy anup aŋg gek, key amnakniŋ, ñi kun ak ñiyimb ayek, di nop nup ñak. ");
INSERT INTO kmh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Biynimb ap mindeyak gok, Nop Gor gak kun ak niŋiy, ñawil diyak. Kiyk gos yomb kun ak niŋmindyakniŋ, Jiysis binuk gok kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Minim aspiyn biy timund ay niŋ-tep yimb ginimimb. Maŋ mindip, Bi bap Ñinuk nup mimuŋg niŋiy, biyomb gunap kuyip ñiniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Minim aŋgak kun ak, kiyk tik niŋep rek ma ayek; pirikiy Jiysis nup ma aŋgniŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Binuk gok kiyk key aŋg amiy apiy giy aŋgyak, “Yand biyomb minden,” “Yand biyomb minden,” aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jiysis binuk gok, gosimb timey niŋyak kun ak key niŋiy, ñapan sikoy yimb bap, dap mindek bak siŋak ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Biynimb gosimb yip niŋiy, ñapan sikoy biy rek diniŋgambay gok, yip diniŋgambay. Pen biynimb yip diniŋgambay gok, Biyomb yip yokek winik anup diniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jiysis kun aŋgek, Jon aŋgak, “Biyomb. Chin niŋbun: bi bap yimb nip ak aŋgiy; kichekiy malñiluk tap okok aŋgyokip. Pen bi kun ak, chin yip ma tapun rek, kun ma ginimin apun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aŋgek, Jiysis aŋgak, “Yenen nup kun apim? Biynimb chinup miluk ma niŋbay gok, buŋgiy chin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pen Nop Gor, nup dand miñmon nuk biyoŋ amniŋg gak ñin ak, maŋ mindakniŋ, Jiysis Jerusalem amniyn aŋgiy, gos kilis giy niŋak ak mey; ");
INSERT INTO kmh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","bi gunap kuyip nind aŋgyokiy aŋgak, “Nimb nind amiy, kinemb tip yip ak niŋayem aŋgak.” Aŋgek, kiyk am Samariya biynimb korip layn bap amjakiy, Jiysis kinemb tip nup bap ayem aŋgey, ");
INSERT INTO kmh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","biynimb miñmon nop nimb kun gok, Jiysis Jerusalem amniŋg gak rek niŋiy, kuyip tep ma gek, nup ma diyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma deyak niŋiy, Jemis yip, Jon yip am, Jiysis nup aŋgrik, “Biyomb! Chin mon maŋlaŋ semb biyoŋ nimb ak aŋgon apiy, biynimb kun gipay gok kuyip yinimuŋ akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kun aŋger, Jiysis andikiy kuyipmiŋay niŋyiŋg, kun ma ginjun aŋgiy kuŋay aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Biynimb kun gok, Jiysis nup ma deyak, miñmon kun ak kirgiy, miñmon bap key amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pen kinjeŋnamb okok amniyakniŋ, bi bap apiy, Jiysis nup aŋgak, “Miñmon akay akay amniŋgamban okok, yand yip nep taŋgoniŋgambur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kun aŋgek, Jiysis aŋgak, “Yand yip kosyam taŋgeniŋgamban. Kayn ayndik gok korip kiyk kinemb ak, man miŋgan okok mindip. Yakir gok korip kiyk ak key mindip. Pen Bi bap Ñinuk, tip kinemb ar nuk ak ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pen Jiysis bi bap nup aŋgak, “Yip kondey, yand yip taŋgor aŋgak.” Aŋgek, bi kun ak pen aŋgak, “Yip yaw aŋgey, yand bapiy nup kond minden, kumek komiy winim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aŋgek, Jiysis aŋgak, “Biynimb permindep ma dipay gok, chip kumemb kun gok kuyip komniŋgiy, nand pen am, Gor biynimb diy kond mindeniŋgamb minim ak aŋgñey amnaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bi bap pen aŋgak, “Yand nand yip nep taŋgoniŋgambur ak pen, yip yaw aŋgey, am amiy bapiy, mam ay yand gok kuyip ñin piksakiy, aŋgñiy winim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Aŋgek, Jiysis aŋgak, “Biynimb Gor nup marik giniŋg giy pen, gos yomb kiyk ak, andkind biynimb kiyk, tap kiyk gok amniŋgamb ak; Gor biynimb yand aŋgiy diy, kond mindonimuŋ rek ma ayniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kisen Jiysis bi ñin jiwiy omiŋal nokom, andikiy omiŋal nokom (72) diy, kuyip bilok omiŋal ak key, omiŋal ak key miñmon okok keykey aŋgyokyiŋg aŋgak, “Nimb nind amiy, minim yip ak aŋgñem, yand kisen niniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pen kuyip minim bap aŋgak, “Tap woŋg ak kuŋay yimb nep mindip ak pen, biynimb pipaŋg dand wep gok nep kuŋay ma mindpay. Kun ak, bi woŋgday nop nimb anup aŋgniŋ mindem, biynimb tap pipaŋg dand wep gunap sek aŋgek, am pipaŋg dand winiŋgiy. ");
INSERT INTO kmh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nimb pen woŋg ar kun anep ginimimb. Pen siypsiyp ñiluk yand gok nimbip yoksipiyn; kayn ayndik mindpay namb ak, ");
INSERT INTO kmh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","anpawis, wand, tomb tirup gok sek, dand ma amnimimb. Biynimb kinjeŋnamb okok niŋiy, minim ma aŋgnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pen korip bap amjakiy, korip miŋgan amyiŋg, kuyip minim tep won ak aŋgiy aŋgnimimb, ‘Gor nimbip kond mindeŋ.’ ");
INSERT INTO kmh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aŋgem, biynimb Gor nup dep rek mindeniŋgambay gok, minim nimbip kun ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Pen korip kun anep mindiy, tap keñmaŋgiy dap ñiniŋgambay gok, ñimbyiŋg mindenimimb. Chinup tap minek minek ñey ñimbun ak, nambiŋ gip aŋgiy, korip ok korip ok ma ginimimb. Bi woŋg gipay gok pey dipay. Kun ak rek, kuyip minim tep aŋgem niŋniŋgambay rek, nimbip pen keñmaŋgiy ñiniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Pen miñmon bap amem, nimbip sik aŋgdiy, keñmaŋgiy ñiniŋgiy gok ñiŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Miñmon kun ak, biynimb tap ginimuŋ gok, gem suŋ ayakniŋ, biynimb gok kuyip maŋgiysek aŋg tep giy aŋgnimimb, ‘Kiyŋ yomb biynimb diy kond mindeniŋgamb ak, tomb aŋgin nimbip ak wip aŋgnimimb.’ ");
INSERT INTO kmh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Pen miñmon bap amem, nimbip ma sik aŋgdey, lor namb siŋak amiy, ‘Miñmon nimb biy apon silkul dip gok, wiyk nimbip ker yokiy amjipun. ");
INSERT INTO kmh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Pen niŋim: Kiyŋ yomb biynimb diy kond mindeniŋgamb ak, tomb aŋgin nimbip ak wip aŋgnimimb.’ ");
INSERT INTO kmh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Nimbip aspiyn: kisen kor yomb ñin ak, miñmon Sodom Gomora biynimb tap siy tap timey nep gey gey yin simbok amnak ak, kor giy yiwur sikoy rek diniŋgambay; biynimb minim nimb am aŋgem ma diniŋgambay gok, kor giy yiwur yomb yimb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin biynimb gok sek, Betsayda biynimb gok sek tap mageprek ak gen, niŋiy kirpay rek, yiwur yomb yimb diniŋgambay. Pen Taya-Saydon biynimb gok kuyip, tap magep kun ak rek, gunap gen niŋbiyap ak, chech talik yowip gunap yimiy, bisgiy tun diyiŋg diyiŋg mindembiyap. ");
INSERT INTO kmh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kor yomb ñin ak, Taya-Saydon biynimb yiwur sikoy rek diniŋgambay; Korasin biynimb gok sek, Betsayda biynimb gok sek yiwur yomb yimb ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pen ñin kun ak, Kapaniyam biynimb kunep, semb biyoŋ ma amniŋgambay; pisnep kaw miŋgan yomb ak amniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jiysis binuk gok kuyip aŋgak, “Biynimb minim nimbip dipay gok, minim nimbip ak mer: minim yip ak dipay. Nimbip ma dipay gok, nimbip mer: yip ma dipay. Pen yip ma dipay ak, yip mer: Biyomb yip yokek winik ak nup ma dipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pen kisen binuk ñin jiwiy omiŋal nokom, andikiy omiŋal nokom (72) kun gok, miñmon okok taŋgjiwiy apiy, tep gakniŋ Jiysis nup aŋgyak, “Biyomb! Kichekiy malñiluk biynimb ambaŋ ayip gok yimb nip ak aŋgiy, ‘Jiysis mindip rek mis amnim’ aŋgon, apun rek niŋiy ambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aŋgeyak, kuyip aŋgak, “Yand niŋmindnikniŋ, kichekiy malñiluk nop kiyk Seytan, kasek won anep, añiñak rek diy apyap pikip. ");
INSERT INTO kmh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Siyŋ saraw, kondal, maploŋgim, tap okok nimbip miluk niŋiy, timey giniŋgiy rek ma ayip. Nimbip ñinen aspiyn rek, yuk yokem amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Pen kichekiy malñiluk gok, apun rek niŋiy ambay aŋgiy, miñmiñ ma ginimimb; Gor Biyomb chin ak, yimb chinup di ayip miñmon nuk biyoŋ aŋgiy, miñmiñ ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Won kun siŋak, Gor Kawnan ak Jiysis nup bak ayek, nup tep gakniŋ, Gor nup aŋgniŋiy aŋgak, “Bapiy. Nand Biyomb semb biyoŋ sek, man biy sek kond mindpan ak, gos nak ak key niŋey tep gip ar ak gipan. Chin biynimb yomb gos tipaŋgiy niŋbun apay gok kuyip kirgiy, chin biynimb tep ma mindpun, ñapan sikoy rek mindpun apay gok kuyip diy, kuyip gos tep ñimban ak, nip tep aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kun aŋgiy aŋgak, “Biynimb gunap yip ma niŋbay; Bapiy nep yip niŋimb. Pen Bapiy nup kunep biynimb gunap ma niŋbay; yand nep nup niŋrep gipiyn. Pen Bapiy yip aŋgek, nuk gip rek gipiyn ak mey, biynimb gos tep ñiyn aŋgiy niŋbiyn gok, gos tep ñen, Bapiy nup niŋrep gipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Kun aŋgiy, andikiy binuk gok nep kuyip aŋgak, “Gapman biyomb gok sek, Gor minim aŋgep biyomb gok sek kuŋaynep rek, yand gipiyn ak, minim apiyn ak, niŋun aŋgiy kond mindyiŋgipay ak pen; ma niŋyak. Gor nimbip di tep yimb gek mey, niŋsipim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bi low tiysa bap, Jiysis yerip rek aŋgnimuŋ aŋgiy, ap nup aŋgak, “Tiysa. Yand yerer giy, perper mindeniŋgayn?” ");
INSERT INTO kmh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aŋgek, nup aŋgak, “Baybol buk ak tikiy, yerip aŋgyak?” ");
INSERT INTO kmh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aŋgek, bi low tiysa kun ak aŋgak, “Baybol buk riytiym gi niŋbiyn ak aŋgyak: ‘Gor Biyomb nak anup wasemb yimb ay, gos timund nak ak, kilis nak ak maŋgiysek nup ker amnimuŋ. Nand key wasemb aypan rek, biynimb gunap kuyip, kunep wasemb aynimin aŋgiy’ tikyak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kun aŋgek, Jiysis bi kun anup aŋgak, “Mey yipund giy apan ak. Ar kun ak kisen giy, perper mindeniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aŋgek, bi low tiysa kun ak, yimb yip ak sikoy giniŋgamb aŋgiy, Jiysis nup tip aŋgniŋiy aŋgak, “Baybol buk tikyak ak, biynimb gunap kuyip wasemb aynimimb aŋgiy tikyak. Kun ak biynimb gunkay kuyip, kun giyaŋ aŋgiy tikyak?” ");
INSERT INTO kmh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aŋgek, Jiysis bi low tiysa ak nup, kesim diy aŋgak, “Bi bap Jerusalem kirgiy, miñmon Jeriykow amniyn aŋgiy, kinjeŋnamb ak amnakniŋ, bi tap siy dep gunap apiy, nup tapin nep pikiy, chech tap nup gok piliŋg dand amniyakniŋ, nuk kinjeŋnamb siŋak kumniŋg kumniŋg gi mindek. ");
INSERT INTO kmh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bi Gor nup simboŋgep bap, lor ar kun ak amiy niŋak; bi kun ak kumniŋg gi mindek. Nuk niŋiy pis anep amnak. ");
INSERT INTO kmh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pen bi Liypay kiñiŋ Gor aŋgniŋep korip kond mindyiŋgip bap, lor ar kun anep amiy niŋak, bi kun ak kumniŋg gi mindek. Niŋiy, kunep pis anep amnak. ");
INSERT INTO kmh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pen bi Jiwda mer, miñmon Samariya nimb bap, kinjeŋ par nokom kun ak nep amiy niŋak; bi kun ak kumniŋg gi mindek. Niŋiy, nup simb niŋiy, ");
INSERT INTO kmh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","mindek maŋ siŋak amiy, soy nup gok wel gunap ay, wayn ñiŋg gunap ay tiwniŋgak. Tiwniŋgiy, di doŋgiy ar nuk ak ay dand amiy, korip maniy tawiy kinyiŋgipay ak dam ay, kond mind tep yimb gak. ");
INSERT INTO kmh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Minek amniŋg giyiŋg, bi korip kond mindyiŋgip kun anup, maniy kind nokom bap ñiy aŋgak, ‘Nand bi kun biy nup direp ginimin. Pen maniy yerip yerip aŋgniŋgamban ak, andkind apiy nip ñiniŋgayn aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jiysis kesim kun ak diy, bi low tiysa kun anup aŋgak, “Bi kinjeŋnamb pikayak ak, bi omiŋal nokom pandikiy, bi an nuk key wasemb ayip rek, nup wasemb ayak?” ");
INSERT INTO kmh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aŋgek, bi low tiysa ak aŋgak, “Bi nup simb niŋiy direp gak ak aŋgak.” Aŋgek, Jiysis nup aŋgak, “Niŋind apan. Mey ar kun anep ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pen Jiysis binuk gok yip miñmon bap amjakeyak, biyn miñmon kun ak mindek bap, kuyip poŋind korip nuk ak amnak. Biyn kun ak yimb nuk Mata. ");
INSERT INTO kmh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Korip nuk ak, nunay bap mindek. Yimb nuk Mariya. Pañ Mariya kun ak, Jiysis mindek maŋ siŋak ap bisgiy, Jiysis minim aŋgakniŋ, niŋmindek. ");
INSERT INTO kmh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata nuk keynep tap keñmaŋgiy daŋgiy gi gi, gos kuŋay niŋiy, ap Jiysis nup aŋgak, “Biyomb. Mariya yip kirgek, key nep tap chin gok daŋgiysipiyn ak tep ma gip. Nup aŋgey apek, omiŋal giy tap daŋgiyur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aŋgek, Jiysis aŋgak, “Mata. Mata. Nip tap kun gok nep gos ayip! ");
INSERT INTO kmh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ak tap yikop! Mariya minim tep ak diyn aŋgiy, gos ak ayek, ap niŋmindip. Kun ak, yand nup kiriŋg amnoŋ aŋgnim rek, ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ñin bap, Jiysis miñmon wikan bap mindiy, Nop Gor nup aŋgniŋ jiwakniŋ, binuk bap ap nup aŋgak, “Gor nup yergiy rek aŋgniŋbay? Jon binuk gok kuyip, aŋgñek niŋyak rek, chinup kunep aŋgñey niŋjun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aŋgek, Jiysis kuyip aŋgak, “Gor nup aŋgniŋniŋg, kun giy aŋgnimimb: ‘Bapiy. Nand timey ma giy, Bi tep yimb mindpan ak, yimb nip dand aranemb. Nand nep Biyomb chin mindiy, chinup kond mindenimin. ");
INSERT INTO kmh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pen tap keñmaŋgiy gok, minek minek ñimbun rek ak ñinimin. ");
INSERT INTO kmh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Biynimb gunap chinup timey gey, kuyip pen miluk niŋiy timey ma gipun rek, tap siy tap timey chin gipun ak, kunep niŋiy kirginimin. Chinup kond mindey, gos bap apek timey ma ginjun aŋgnimimb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kun aŋgiy, binuk gok kuyip aŋgak, “Nimb bap, kisyimnamb yomb akyaŋ, buŋgiy nimb bap korip ak amiy aŋgniŋgambim, ‘Buŋgiy. Bi yand niŋep rek bap, par okok nimb apiy amniyn aŋgiy, korip yip ak apchakamb, tap nup ñen ñiŋnimuŋ ak ma mindek mey; nip ker aswiyn. Yip biret omiŋal nokom ñan aŋgeniŋgambim,’ buŋgiy nimbik kun ak minim bap aŋgniŋgamb; ");
INSERT INTO kmh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Kisyimnamb biy, yip kun giy ma ap aŋgnimin! Ñapan yand gok yip kinjeŋ giñiy kinjipun. Kun ak yergiy tikjakiy, nip tap aspan ak diñinim aŋgniŋgamb?’ ");
INSERT INTO kmh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Pen nimbip aspiyn: bi korip nop nimb ak, buŋgiy yand aŋgiy, kasek ma diñeniŋgamb; nup ñan aŋgiy kond mindyiŋg, kilis gi mindem mindem, aŋgniŋgambim rek niŋiy, diñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kun ak nimbip aspiyn: tap yerip tikdenimuŋ, Gor nup aŋgniŋem, nimbip ñiniŋgamb. Pen tap yerip piyowniŋniŋgambim ak, kunep diniŋgambim. Chinup kinjeŋ ak yikaŋ aŋgiy, pik giygiw gem, yikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Yenen: biynimb an Gor nup aŋgniŋbay gok, apay rek gip. Tap piyowpay ak kuyip yomimb. Pen kinjeŋ ak yikaŋ aŋgiy, pik giygiw gey, apay rek niŋiy yikip. ");
INSERT INTO kmh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nimb bi ñapan nop gok, ñapan nimb bap piys nen aŋgek, siyŋ timey bap ñimbikip? ");
INSERT INTO kmh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Akaŋ pen, yakir maŋgiy nen aŋgek; kondal bap ñimbikip? Ak kun ma gipkip! ");
INSERT INTO kmh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nimb biynimb tep mer ak pen; ñapan nimb gok tap tep gok nep ñimbim. Bapiy tep semb biyoŋ ak bi tep yimb. Nuk tap yesek bap key ma ñiniŋgamb. ‘Kawnan nand ak chinup yokan aŋgem,’ yokniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pen bi bap kichekiy ak ambaŋ ayek, minim aŋgiy mer, yikop nep mindek. Jiysis kichekiy abaŋ ayak kun ak aŋgyokek, minim aŋgakniŋ, biynimb ap niŋmindeyak gok, gos kuŋay yimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pen biynimb kun gok gunap aŋgyak, “Nuk kichekiy malñiluk nop kiyk Seytan, yimb bap Belsiybul apay kilis ak diy, aŋgyoksap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pen biynimb gunap, Jiysis yerip giniŋgamb aŋgiy aŋgyak, “Tap bap key semb siŋbiyoŋ gey niŋiy mey; Gor nep aŋgyokek winak aŋgniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pen Jiysis gos yesek niŋyak kun ak niŋiy aŋgak, “Miñmon yomb nokom bap, asik keykey ay mindrep ma giniŋgambay. Biynimb kiñiŋ nokom bap, kunep asik keykey ay mindrep ma giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","19","Kun ak rek, Seytan kiñiŋ ak tuŋgasik keykey ay, yergiy mind tep giniŋgambay? Yip Belsiybul nup kond mindek, kichekiy malñiluk aŋg mis yoksap apim ak pen, yand kun gembinip, yergiy biynimb nimb gok kichekiy malñiluk aŋg mis yokpiyap. Kiyk key nimbip aŋgniŋgambay, biynimb bap kun giniŋgiy rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pen Gor yip kond mindek aŋgyokpiyn ak; yip yenen, Gor binuk biynimb diy kond mindeniŋgamb ak wip biy aŋgiy ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pen bi kalrimey bap mindiy, chim yakam nuk ay tep giy, korip nuk niŋmindek, biynimb tap nuk bap piliŋg diniŋgiy rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pen bi kalrimey yimb bap key apiy, chim tap nuk siy di mindip gok piliŋg diy mey, key niŋimb rek bilokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Biynimb yand ker ma mindpay gok, Seytan kind ak mindiy mey, yip ma dipay. Pen biynimb yand yip woŋg ma gipay gok, kinjeŋ day aŋg tikey, biynimb yip ker winiŋg gipay gok ma opay. ");
INSERT INTO kmh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kichekiy malñiluk timey bap, biynimb ambaŋ ay mindek, aŋgyokeniŋgambay, am miñmon nep namb okok tip bap niŋiy minden aŋgiy, am kun okok taŋg taŋg mer niŋiy, korip miŋgan nind mindiy opiyn ak amniyn aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aŋgiy, amiy niŋniŋgamb: korip kun ak girep yimb gey, tip anep mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nuk niŋiy okok amiy, nund rek mer; kichekiy malñiluk timey yimb onep ar ak sek poŋind apiy, miŋgan kun ak mindeniŋgambay. Kun gek, nind mindrep giyiŋgip rek mer; pisnep timey yimb giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jiysis kun aŋgek niŋiy, biyn bap namb kun ak tikjakiy, meŋg miŋgan dand araniy aŋgak, “Nanim nip tikiy tiy ñak ak, miñmiñ yimb ginimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aŋgek, Jiysis aŋgak, “Kun apan ak pen; biynimb Gor nup minim ak niŋiy, aŋgip aŋgip rek giniŋgambay gok, miñmiñ giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Pen biynimb kuŋay yimb nep, ap nanan giyakniŋ, Jiysis aŋgak, “Biynimb miñiy mindpim ñin namb biy, tap siy tap timey giyiŋg apim, ‘Tap key rek bap semb biyoŋ gek niŋiy, Kiyŋ yomb key yimb per kond mindpun ak nep, wip aŋgiy niŋniŋgambun apim.’ Pen nimbip aspiyn, tap bap key gen ma niŋniŋgambim. Niŋniŋg: Jona wosrey ñin omiŋal nokom, piys yomb koŋgiy namb biyaŋ mindiy, owak rek ak yip kunep gek, niŋniŋgambim. Gor Jona nup kond mindrep gak rek, Niyniypa biynimb niŋiy, Gor nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Pen wosrey, Kiwiyn biyn yomb miñmon paryomb Yitiyopiya nimb ak, kiyŋ Solomon biyomb rek ayek niŋiy, minim nup ak niŋiyn aŋgiy owak. Pen biynimb miñiy mindpay gok, Biyomb yimb ak ap mindiy, minim aŋgip ak ma dipay rek, kisen kor yomb ñin ak, minim yomb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Wosrey, Jona am Niyniypa biynimb kuyip aŋgek, tap siy tap timey giyak gok kirgiy, Gor nup diyak. Jona bi yikop ak aŋgek niŋyak ak pen, miñiy Biyomb yimb ap mindip biy nup, kun ma gipim. Kisen kor yomb ñin ak minim yomb diniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Biynimb gok lam daŋgiy tiyn miŋgan okok akaŋ, boŋg ar kinbay molik okok ma aypay; ar siŋak tik ayey melik gek, biynimb gok korip miŋgan kun ak apiy miseŋ niŋbay. ");
INSERT INTO kmh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pen windin maŋgiy ak sup rek mindip ak mey, mind tep gek, mumbwak ak mind tep yimb giniŋgamb. Pen mind tep ma gek; kisyim wip rek ak mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Namb chinup ak melik mindip aŋgiy niŋniŋgambim ak pen; kisyim wip rek ayip ak, niŋrep yimb ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mumbwak nimb maŋgiysek melik yimb giy mindeniŋgamb ak, wikan bap kisyim ma mindeniŋgamb; lam melik gip rek ak, giyiŋg nep mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pen Jiysis minim aŋgjiwakniŋ, bi Peresiy bap nup aŋgak, “Apey, korip yand ak amiy tap ñiŋur aŋgak.” Aŋgek, Jiysis am korip nup ak, ");
INSERT INTO kmh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","bisgiy tap ñiŋakniŋ, bi Peresiy kun ak, gos nuk namb okok nep niŋiy, bi kun biy yenen, chin Jiwda kay per gipun rek, ñin nuk ak ñiŋg ay giluŋg yokiy mer; yikop nep tap ñimbsap aŋgiy, gos ak niŋak. ");
INSERT INTO kmh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gos kun ak kun giy niŋek, Jiysis aŋgak, “Nimb Peresiy kay, piler kap gok mis okok ken, ñiŋg pik tep gipay rek ak gipim ak pen, namb nimb biyaŋ tap siy tap timey gipim gach ak, arachakiy mindip. ");
INSERT INTO kmh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nimb sakiy sek yimb. Gor nimbip wak ak nep ma gayak; namb biyaŋ kunep gayak. ");
INSERT INTO kmh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kun ak, tap piler kap miŋgan biyaŋ mindip ak, biynimb simbgeprek gok kuyip ñinimimb. Kun giy mind tep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pen nimb Peresiy kay niŋrep yimb ginimimb. Sinimb tap monmon gok niŋem tap yomb rek ayek, ñin paŋgniŋ dand amiy, wanjrem ak amek, Gor nup nokom bap ñun aŋgiy, per ñimbim. Ak tep gipim; minim ma mindip. Tap siskoy okok per kun giy gipim ak pen, yenen minim junj yimb ak kunep ma gipim. Gor nup niŋiy dep akaŋ, biynimb gok kuyip niŋiy dep ar ak, per kirpim. ");
INSERT INTO kmh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nimb Peresiy kay niŋrep yimb ginimimb. Gos nimbik niŋbim ak, lotiw namb ak akaŋ, miytiyŋ gipay namb ak amon, aswim-ey aŋgey, yimb chinup anep dand araniyaŋ aŋgiy, gos ak nokom niŋbim. ");
INSERT INTO kmh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Pen gipim kun ak, Gor nimbip pen kunep giniŋgamb ak, niŋrep ginimimb. Biynimb gunap niŋiy, nimbip bi tep yimb apay ak pen; chip kuy giy mindip rek ak, mindpim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kun aŋgek, bi low tiysa bap, Jiysis nup aŋgak, “Tiysa. Minim kilis timey yimb apan kun ak, chinup kunep apan akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aŋgek, Jiysis aŋgak, “Nimb bi low tiysa gok niŋrep yimb ginimimb. Minim kilrimey apim ak, wand miker yomb gok rek, biynimb gok kuyip gom ñimbim ak pen; kuyip simb niŋiy ma tuŋgasik dipim. ");
INSERT INTO kmh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kun ak niŋrep yimb ginimimb! Nasind yes nimb gok wosrey, bi Gor minim aŋgep gok kuyip pikayey, nimb kaw kuyip komemb gok gayrep giyiŋg mindpim. ");
INSERT INTO kmh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gipim kun ak tep nep pikyak aŋgiy gipim. ");
INSERT INTO kmh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kun ak Gor niŋrep giy aŋgak, ‘Bi minim yip aŋgep gok, bi minim yip dand amemb gok kuyip yokniŋgayn ak pen, kuyip yiruk niŋiy, gunap timey giniŋgambay; gunap pisnep pikayniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Pen wosrey, miñmon alwol gayak ñin ak tikiy, bi Gor minim aŋgep gok kuyip per pikey wip rek, biynimb miñiy mindpay gok, minim miker kun ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Miker kun ak mey, bi Ebol nup nind kiñiŋ giy ñaŋgiy, ñaŋg dand apiy, ñaŋg dand apiy, kisen Sekaraya nup, Gor nup tip tap simboŋg ñemb korip miŋgan ak bindoŋ, kamb diy giyak bind ar ak biy, namb siŋak ñaŋgayak. Nimbip niŋind yimb aspiyn. Minim miker kun ak maŋgiysek, biynimb miñiy mindpay gok diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Pen nimb bi low tiysa gok niŋrep yimb ginimimb. Kiy diy, kinjeŋ yikiy korip miŋgan amiy niŋrep gep ak, yiruk gek kirpim. Kirgiy, biynimb korip miŋgan amniŋg gipay gok kuyip, per kinjeŋ day aŋgrikpim. Kun ak niŋrep yimb ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jiysis kuyip kun aŋgiy, mis amnakniŋ; bi Peresiy gok sek, bi low tiysa gok sek nup yiruk niŋiy aŋgyak, “Minim yerip ak aŋgon, pen aŋgek niŋiy, dand kor yomb amnun aŋgyak.” Kun ak mey, nup minim yesek yesek ar keykey gok aŋgniŋyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pen won kun ak, biynimb kuŋay yimb nep ap nan-giy, chichmiy yimyakniŋ, Jiysis binuk gok kuyip aŋgak, “Peresiy kay per timey gipay ak weygiy, mind tep gipun apay. Kun ak rek, nimb kunep ginimimb rek ayip ak, niŋrep yimb ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tap weygiy gipim gok, kisen miseŋ niŋniŋgambay. Minim kapkap aŋg weygipim gok, kunep miseŋ gek niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pen minim kisyimken apim gok, melik sek aŋgey niŋniŋgambay. Minim kapkap korip miŋgan okok apim gok, korip ar biyoŋ aŋgey, yiŋg dand miñmon okok amniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Biynimb yand guniy. Nimbip aspiyn, Gor nup chiŋgon, chinup ñaŋgniŋgambay aŋgiy ma piriknimimb. Ak yikop mumbwak ar anep timey giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kun ak nimbip aspiyn: pirikniŋg, Gor Biyomb nimbip pikay, mon key yinjap yokniŋgamb ak nup piriknimimb. Kun ak nimbip niŋind yimb apiyn. ");
INSERT INTO kmh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nimb niŋbim: yakir sikoy onep mamind ak yokiy, maniy likañ sikoy won omiŋal nep dipay. Yakir sikoy kun gok, Gor ma niŋnimuŋ rek bap ma mindip; maŋgiysek niŋimb ak nep mindip. ");
INSERT INTO kmh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pen nimb biynimb gok, tap yimb; yakir gok kuyip wiyniym gipim. Kun ak, Gor jun kas nimbip maŋgiysek ñin paŋgip ak mey; gos sek mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nimbip aspiyn: biynimb Jiysis ker mindpun aŋgiy, biynimb mindpay namb ak aŋgyikey; kuyip pen, biynimb guniy yip ker mindpay aŋgiy, enjol mindpay namb ak miseŋ aŋgyikniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Pen biynimb ‘Jiysis ker ma mindpun aŋgiy’ biynimb mindpay namb ak aŋgey, kuyip pen, yip ker ma mindpay aŋgiy, enjol mindpay namb ak aŋgniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bi bap Ñinuk nup aŋgjiweniŋgambay, Gor niŋiy kirginiŋg kirginiŋgamb; pen Kawnan nuk ak nup aŋgjiweniŋgambay, nuk niŋiy ma kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pen nimbip kor giniŋg, dand lotiw giniŋg biynimb ap nan-gipay namb ak amey akaŋ; kanjsol mindpay namb ak amey akaŋ, gapman biyomb mindpay namb ak amey, pen minim yerip ak diy aŋgjun aŋgiy, gos ak ma piyow niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tikjak apikniŋ, Gor Kawnan ak nimbip gos ñakniŋ, aŋgniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Biynimb kuŋay mindeyak namb kun ak, bi bap Jiysis nup aŋgak, “Tiysa. Mam yand ak nup aŋgey, bapiy tap nuk day kumak gok, bilok yip pis ak key ñaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aŋgek, Jiysis nup aŋgak, “Yip an aŋgip, ‘Bi tap pikasik ñemb ak mindonimuŋ aŋgek,’ tap nimbip gok pikasik ñinim? ");
INSERT INTO kmh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tap kuŋay dun aŋgiy gos ak ma niŋnimimb. Tap dun aŋgiy niŋbim kun gok, nimbip gek mindrep ginimimb rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pen Jiysis minim bap kuyip paydoŋ ay aŋgak, “Bi maniy kuŋay mindeniŋgamb bap, woŋgday nuk ak, wiyt maŋgiy tap gok kuŋay yimb mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gos nuk okok nep key niŋdand amiy, tap ñiŋemb yand kuŋay mindip gok, korip miŋgan akay dap ay ñimb mindenim aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pen gos bap niŋiy, korip sikoy gok timbrik yokiy, korip yomb yomb gok nep giy, keñmaŋgiy tap yand okok maŋgiysek, di miŋgan kun okok ay woŋg ak kirgiy, ");
INSERT INTO kmh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","tap yand kun gok nep ñimbyiŋg, ñiŋg ñimbyiŋg, miñmiñ giyiŋg, gi mindeniŋgayn aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pen kun giy niŋek, Gor nup aŋgniŋgamb, ‘Nand bi sakiy sek yimb. Miñiy kisyimnamb biyaŋ kumeniŋgamban, tap nand kuŋaynep mindip gok, an rek diniŋgamb aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Kun ak rek mey, biynimb tap kiyk gok nep mapin tikjakek, Gor nup niŋey tap yikop rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jiysis kun aŋgiy, binuk gok kuyip aŋgak, “Chech akay nimb diy yimniŋgambun; tap akay nimb diy ñiŋniŋgambun aŋgiy gos yomb ak ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nimbip gayak ak, chech, tap ñiŋemb nep piyow niŋniŋgiy aŋgiy ma gayak. ");
INSERT INTO kmh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Yakir gok biynimb gipay rek, wiyt yimey, pikgek tik dand ma opay. Pen wiyt maŋgiy tik dap nan-giniŋgiy korip bap ma mindip. Gor nep mey, tap ñiŋemb kuyip ak ñimb. Nuk tap yikop gok niŋiy kun gip ak, yenen chinup ma kond mindeniŋgamb aŋgiy gos kuŋay niŋbim? ");
INSERT INTO kmh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Akaŋ pen, kumniŋg giniŋgambim ñin ak kirgiy, won bap sek mindenimimb rek ayek; tap yesek kun gok gos kuŋay niŋbim? ");
INSERT INTO kmh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tap saŋgiy okok jakiy, maŋgiy piyniŋg sum gip gok, key mokyaŋ giniŋgiy rek ma ayip, Gor nep gek, mokyaŋ tep yimb ak giy mindpay. Pen wosrey, biyomb Solomon mokyaŋ giyiŋgip ak, mokyaŋ tep kun ak rek ma giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tap saŋgiy okok jakip kun gok tap yikop; per ma mindeniŋgamb. Miñiy rek mindiy, toy rek pikrik mon daŋgiyey yiniŋgamb. Pen Gor tap ma kond mindep rek kun gok kond mindip ak, chinup kond mindeniŋgamb aŋgiy niŋnimimb ak pen; gos nimb ak parsek ma mindip. ");
INSERT INTO kmh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Keñmaŋgiy, ñiŋg, tap gok akay nimb diy ñiŋjun aŋgiy, gos ak ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Biynimb Gor ker ma mindpay gok, gos kun ak rek niŋbay; pen Nap yomb ak nimbip sakiy ma gip; tap nimbip tikdip gok niŋimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kun ak nuk biynimb diy kond mindeniŋgamb ak, chinup sek dinimuŋ aŋgiy, gos nokom niŋiy gem amek mey, nimbip kond mindakniŋ, tap kun gok ma tik diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kanj siypsiyp sikoy tiwin biy. Nap yomb nimbip diy kond mindeniŋgayn aŋgiy niŋimb ak mindip ak mey; ma piriknimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tap nimb gok mindip rek yokiy maniy diy, biynimb tap ma mindip gok kuyip ñinimimb. Kun gem mey, tap mapin nimb gok lum ar biy ma mindeniŋgamb; mindeniŋgamb Gor miñmon biyoŋ. Kun biyoŋ ma kurginiŋgamb; siplep ma siwiy, bi siydep gok siy diniŋgiy rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tap tep nimb gok man ar biy di nan-gem, gos nimbip ak mindeniŋgamb man ar biy; pen semb biyoŋ nan-gem, gos nimbip ak amniŋgamb kun biyoŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kun ak laplap nimb ak dem apek, maŋ maŋ paŋgiy, ler ak pimbirikiy, lam ak daŋgiy ay niŋmindenimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bi woŋg giñimbay gok aŋgniŋgambay, ‘Biyomb chin ak, biyn diyiŋg tap yomb ñimbsipay namb ak amimb rek, maŋ mindip winiŋgamb aŋgiy,’ niŋnep mindeniŋgambay. Kun ak biyomb kiyk ak giraŋgiy, ap kinjeŋ ak pik giygiw gek, kasek yikniŋgambay. Kun ak rek nimb ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pen nuk andkind apiy niŋniŋgamb: niŋmindeniŋgambay ak, kuyip di tep yimb giniŋgamb. Biyomb kun ak nuk key, chech nuk ak lip gek apek, maŋ maŋ paŋgiy, ler ak pimbirikiy, kuyip aŋgek, am tap ayñimbay tip ak bisiŋg kus kus gey, nuk key kuyip tap ñiŋemb gok dam ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pen Biyomb ak kisyimnamb biyaŋ akaŋ; kakaruk aŋgakniŋ apiy niŋniŋgamb: binuk gok wisin ma kineniŋgambay, kuyip di tep yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kun ak niŋim. Biynimb korip nop nimb gok, bi tap siy dep bap ñin ak rek winiŋgamb aŋgiy niŋmindembiyap ak; korip kuyip ak piklakiy, tap kuyip gok siy ma dipkop. ");
INSERT INTO kmh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kun ak rek Bi bap Ñinuk winiŋgamb aŋgiy, kond mindenimimb. Ma asaw aŋgiy, niŋniŋgambim ñin ak winimuŋ rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jiysis kun aŋgek, Piyta aŋgak, “Biyomb. Minim paydoŋ ay apan kun ak, chinup nep apan akaŋ, biynimb maŋgiysek apan?” ");
INSERT INTO kmh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aŋgek, Jiysis aŋgak, “Bi an gos tep mindek, woŋg gi tep yimb giniŋgamb ak, biyomb nuk ak amniŋg giy, nup aŋgniŋgamb, ‘Bi woŋg yip giñimbay gunap kuyip kond mindiy, tap ñiŋemb kuyip gok bilok ñiyiŋg gi mindenimin aŋgiy’ amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kun ak kisen andkind apiy, aŋgniŋgamb rek gek niŋiy, nup di tep yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Niŋind apiyn. Nup aŋgek, tap nuk gok maŋgiysek kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Pen bi woŋg nup giniŋgamb ak, biyomb yand ak kasek ma winiŋgamb aŋgiy, biynimb woŋg giñiniŋgambay gunap kuyip tapin pikiy, tap ñimbiy, ñiŋg kilis ñimbiy, sakiy ay gi mindakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","biyomb nuk ak kasek ma winiŋgamb aŋgiy niŋniŋgamb ñin ak apiy, nup timey yimb giy, biynimb minim nup ma niŋiy, am mindpay kind ak aŋgyokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Biyomb ak apiy mey, minim nuk aŋgak ak niŋrep giy, kindik ma gipay biynimb gok kuyip, yiwur yomb yimb rek ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Biynimb minim nup nind ma niŋiy, timey giniŋgambay gok kuyip, yiwur siskoy rek ñiniŋgamb. Pen ar kun ak rek, bi bap nimbip tap yomb ñiy, pen kun ak rek ñim aŋgniŋgamb. Pen tap kuŋaynep di ñin ar nimbip ak ayek, direp ma geniŋgambim, apiy nimbip minim yomb yimb ak aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yand opiyn ak, man ar biy sup puŋg aŋgiyniŋg opiyn. Okok maŋgiysek yinbikop ak tep! ");
INSERT INTO kmh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yiwur yomb diniŋgayn ak, yip miker yimb gisap. Kun ak pisnep di den mey, yip tep giniŋgamb! ");
INSERT INTO kmh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Yip aŋgniŋgambim, biynimb di jimñiniŋg gisap aŋgniŋgambim ak pen; yand opiyn rek, gos ar keykey niŋiy, asik keykey ayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Miñiy ñin biy tikiy, amyoŋg apyoŋg onep mamind rek mindeniŋgambay ak; omiŋal nokom yip dey, omiŋal yip ma diy, asik keykey ayniŋgambay. Pen mer ak: omiŋal yip der, omiŋal nokom yip ma diy, asik keykey ayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bi apiymiŋay ak, ñinuk akaŋ nop, yip ma dek mey, asik keykey ayniŋgayr. Biyn amiymiŋay ak, panuk akaŋ nonim, yip ma dek mey; asik keykey ayniŋgayr. Nonim yip, ñinuk biyn ak yip kunep: nonim akaŋ, ñinuk biyn ak yip ma dek mey, asik keykey ayniŋgayr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pen Jiysis minim bap sek kuyip aŋgak, “Pumb paŋind amimb okok ken semb ayek niŋiy, miñiy miñmon pikniŋg gisap aŋgiy niŋmindem, apim rek nep gip. ");
INSERT INTO kmh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pinim yomb ak akyim ken apek niŋiy, miñiy pumb yomb giniŋg gisap aŋgem, apim rek nep gip. ");
INSERT INTO kmh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tap semb ar biyoŋ niŋrep giy; man ar biy niŋrep giy gipim ak pen, yenen ñin yomb kond mindyiŋgipim ak, miñiy wip biy ma niŋbim? ");
INSERT INTO kmh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Pen yenen, Gor kinjeŋ tep ar niŋrep giy dinimimb ak mindakniŋ, tap yesek ar gok apun rek gip aŋgiy niŋbim? ");
INSERT INTO kmh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Pen bi bap nimbip kor dand amjipiyn aŋgek, kor yomb kun ak yenen amjipun aŋgiy, kinjeŋnamb okok amyiŋg, nund yip minim aŋg tuŋgasik ayrep ginimimb. Pen mer ak, nimbip pisnep dam biyomb kor niŋimb ñin ar ak yokek, nuk pen di poliys ñin ar ak ayek, nimbip dam kalambis ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kun ak nimbip aspiyn; kalambis kun ak mindnep mindeniŋgambim. Tap day nimbik gok pisnep day paŋg diy nep, mis amniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Won kun ak nep, biynimb gunap ap, Jiysis nup kesim diy aŋgyak, “Galiyliy biynimb gunap ap Gor aŋgniŋep korip ak, tap simboŋg ñiyakniŋ, gapman biyomb Paylat kuyip pisnep pikayamb, likañ kuyip yowip, meymey siypsiyp pikayey likañ yowip namb siŋak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aŋgeyak, Jiysis kuyip aŋgak, “Galiyliy biynimb kun gok, tap siy tap timey key yimb geyak, kuyip kun gip aŋgiy niŋbim? ");
INSERT INTO kmh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ak mer! Pen niŋim! Tap siy tap timey gipim gok, yenen kun gipun aŋgiy ma kirgeniŋgambim, maŋgiysek kun ak rek nep kumniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Pen miñmon Saylom, korip paryomb yiy akyoŋ giyak ak paŋg apyapiy, biynimb onep kaŋgol pis ak kuyip pikayak ak niŋbim. Pen nimb aŋgniŋgambim, ‘Jerusalem biynimb gunap tap siy tap timey giyak rek mer; kiyk tap siy tap timey yomb yimb ak gey, Gor gek korip kun ak paŋg apyapiy, kuyip pikayak aŋgniŋgambim.’ ");
INSERT INTO kmh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pen ak kunep mer! Nimbip niŋind yimb aspiyn. Nimb maŋgiysek tap siy tap timey gipim gok, yenen kun gipun aŋgiy ma kirginiŋgambim ak; maŋgiysek kumyak kun ak rek nep kumniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pen Jiysis minim bap paydoŋ ay aŋgak, “Bi bap kiyaw maŋgiy ak piyaŋ aŋgiy, yiŋ ak jiw dand apiy, miñ wayn woŋg namb nuk ak yimniŋgamb. Kisen andkind apiy niŋniŋgamb; maŋgiy ma nep piyeniŋgamb, ");
INSERT INTO kmh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","bi woŋg nup giñiniŋgamb ak nup aŋgniŋgamb, ‘Simiy nokom nokom yinakniŋ, per apiy niŋbiyn; kiyaw yimnik ak, maŋgiy ñiŋemb ak ma nep piyp. Kun ak woŋgday namb yip ak mindek tep ma gip. Timb yoknimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Aŋgek, bi woŋg nup giniŋgamb ak aŋgniŋgamb, ‘Biyomb. Kiyaw kun ak miñiy ma timb yokep. Yand kiyaw kiñiŋ kun ak kipil gi tep giy, tap kaskas gunap dap ayen, ");
INSERT INTO kmh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","simiy andikiy ak maŋgiy piyek kirginimin; pen ma piyek, ñin kun ak timb yoknimin aŋgniŋgamb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pen Jiwda lotiw ñin bap, Jiysis Jiwda nan-gep korip miŋgan ak amiy, kuyip minim aŋgñi mindek. ");
INSERT INTO kmh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Korip miŋgan kun ak, biyn kichekiy gek, kund ñikgiy nep taŋgek taŋgek, simiy yin kaŋgol piskind ayak ak, ap mindek. ");
INSERT INTO kmh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jiysis biyn kun anup, aŋgek apek aŋgak, “Tap nip gip ak suŋ ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kun aŋgiy, nup diniŋakniŋ, kund ak yipund gek, Gor nup yimb ak dand aranak. ");
INSERT INTO kmh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pen Jiwda lotiw ñin ak, gek suŋ ayak ak niŋiy, biyomb Jiwda nan-gep korip kond mindek ak nup miluk yapek, biynimb ap mindeyak gok kuyip aŋgak, “Nimbip biynimb tap gip gok, woŋg ñin onep kaŋgol ak mindip; apem gek suŋ aynimuŋ. Miñiy ñin biy lotiw ñin ak pen, kun gispim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Aŋgek, Jiysis aŋgak, “Kanj kaw, doŋgiy nimb gok tiwniŋg ayem mindeniŋgamb ak, lotiw ñin ak ñiŋg nen gek, kuyip simb niŋiy miñ wisikiy, dand amem ñiŋg ñiŋniŋgambay akaŋ mer? Pen basind yes chin Ebraham tikek, tik dand amiy tikpay pañ biy, Seytan nup wosrey tiwniŋgayek, simiy yin kaŋgol piskind ayip ak, nup simb ma niŋbim? Miñiy lotiw ñin biy, miñ nup ayip ak tuŋgasiken, minim yomb aspim? Kun ak tom yimb gipim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jiysis kun aŋgek, bi nup miluk niŋyak gok, kuyip nambiŋ yimb gak. Pen biynimb yikop gok, Jiysis tap mageprek giyiŋgip rek niŋiy, miñmiñ yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jiysis minim bap sek aŋgiy aŋgak, “Gor biynimb diy kond mindeniŋgamb minim aŋgniŋg gispiyn ak, yergiy rek aŋgen niŋrep yimb giniŋgambim? ");
INSERT INTO kmh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mey minim ar aŋgniŋg gispiyn biy rek mindip. Bi bap mon mastet maŋgiy ak, di woŋgday nuk ak yimek, jak yomb giy, alik tep ak pikek, yakir gok ap ay mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Minim bap pen tip ak aŋgak, “Gor biynimb diy kond mindeniŋgamb minim ak, yergiy aŋgen niŋrep giniŋgambim? ");
INSERT INTO kmh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ar kun ak rek, biyn gok yiys ak sikoy band bap diy, palaw tiyn yomb ak sek, tuŋgandik mandik gey, mindyiŋg yomb yimb tanimb rek ak giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pen Jiysis Jerusalem amniŋg, yipund giy ma amnak. Nuk miñmon dawin yomb okok sek, miñmon sikoy okok sek namb namb kinyiŋg, minim aŋgñek amnak. ");
INSERT INTO kmh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Biynimb kun okok mindeyak gok, bap Jiysis nup aŋgak, “Gor biynimb gunap nep diniŋgamb?” Aŋgek, kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kun ak nimbip aspiyn, nimb kilis giy nep, kinjeŋrumb sikoy tam ak amniŋgambim. Biynimb kuŋay yimb nep, korip miŋgan amnun aŋgiy, gi mer niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yenen, bi korip nop nimb ak kinjeŋ giñek, nimb mis okok nep mindiy, pik giygiw giyiŋg aŋgniŋgambim, ‘Biyomb! Kinjeŋ ak yikan aŋgem,’ nuk aŋgniŋgamb, ‘Nimb akay nimb? Yand nimbip ma niŋbiyn’ aŋgniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Aŋgek, nimb pen aŋgniŋgambim, ‘Nind miñmon chinup ak, ap minim aŋgñinakniŋ, nand yip tap ñiŋnuk aŋgem,’ ");
INSERT INTO kmh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","nimbip tip ak aŋgniŋgamb, ‘Yand nimbip ma niŋbiyn. Nimb akay nimb? Nimb biynimb tap siy tap timey nep gipim ak, kinjeŋ ma yikniŋgayn! Amnimimb’ aŋgniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kun ak kisen Ebraham, Aysek, Jekop, bi Gor minim aŋgep gok, Gor ñin ar ak mindyakniŋ, nimbip pen aŋg mis yokek, siy aŋgyiŋg, meŋg siwbirik mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pen biynimb Jiwda mer gok, gunap pumb lim gip okok ken apiy; gunap paŋind amimb okok ken apiy, gunap akdoŋ nimb apiy, gunap akdoŋ nimb apiy, Gor biynimb diy kond mindeniŋgamb namb ak apiy, jimñiy tap yomb ñiŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Kun ak, biynimb nind opay gok, kasek amnun aŋgiy gos ak ma niŋey, biynimb kisenimb gok apiy, kuyip tawsak ay nind amniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Won kun siŋak nep bi Peresiy gunap apiy, Jiysis nup aŋgyak, “Gapman biyomb Herot nip pikayniŋg gisap ak, miñmon biy kirgiy, miñmon bap key amnimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aŋgeyak aŋgak, “Nimb am kayn ayndik kun ak nup aŋgem, niŋmindonimuŋ. Miñiy sek, toy sek biynimb tap gip gok gen suŋ ay, biynimb kichekiy malñiluk ambaŋ ayip gok, gen biynimb yimb ay giniŋgamb. Menik mey, Jerusalem amiy, woŋg yand ak gi diniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Pen miñiy ñin kaw biy, Gor woŋg yip aŋgak anep gi mindeniŋgayn. Jerusalem amen yip pikayniŋgambay. Bi Gor minim aŋgep gok kuyip, per miñmon gunap ma pikaypay; Jerusalem nep pikaypay. ");
INSERT INTO kmh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem! Jerusalem! Gor, bi minim nup aŋgep nimbip ker yokip gok, yenen per kamb diy pikaypim! Per biynimb nimbip gok kakaruk ñiluk rek, pil beŋ okok ayin aŋgen, yip yiruk niŋiy ma dipim! ");
INSERT INTO kmh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kun ak niŋim; Gor aŋgniŋep korip yomb nimbik ak, yikop yimb mindeniŋgamb. Yip ma niŋniŋgambim. Kisen, bi Gor chinup nen aŋgyokek asaw ak, tep yimb asaw aŋgniŋgambim ñin ak nep, yip niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jiwda lotiw ñin bap, Jiysis am, Peresiy biyomb bap korip ak tap ñiŋakniŋ, nuk yerip rek ginimuŋ aŋgiy, niŋyinjsek ay mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yenen: ñin kun ak, bi ñin tomb siw gak bap ap mindek. ");
INSERT INTO kmh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jiysis bi kun anup niŋiy, bi Peresiy gok sek, bi low tiysa gok sek kuyip aŋgak, “Bi tap gip gok, lotiw ñin ak gon suŋ aynimuŋ akaŋ, mer?” ");
INSERT INTO kmh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aŋgek, minim bap pen ma yimb aŋgeyak; nuk bi ñin tomb siw gak anup, diniŋek suŋ ayek, aŋgyokyiŋg, ");
INSERT INTO kmh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","bi kun gok kuyip aŋgak, “Ñapan nimb bap akaŋ; makaw nimb bap, lotiw ñin ak ñiŋg malpim kaw miŋgan ak amek, nimb simb ma niŋiy, ma diyokniŋgambim?” ");
INSERT INTO kmh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aŋgek, kiyk pen minim bap ma aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pen bi kun gok tap ñiŋniŋg, cheya ar tep tep gok nep bisgey amnakniŋ, Jiysis minim bap paydoŋ ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bi bap biyn diniŋg giy, tap yomb ñiŋniŋg nimbip suk aŋgek amiy, cheya tep aynimuŋ ar ak, ma bisginimimb. Bi kun ak nuk, biyomb yimb bap apiy bisgaŋ aŋgiy, aynimuŋ rek ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kun ak nimb ar kun ak bisgeniŋgambim, bi nimbip suk aŋgniŋgamb ak apiy aŋgniŋgamb, ‘Nimb key siŋak amem, biyomb biy bisgaŋ aŋgek,’ nimbip nambiŋ gakniŋ, am gol okok bisginiŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Pen nimbip tap ñiŋun aŋgiy suk aŋgeniŋgiy, amiy gol okok bisiŋg mindem mey, bi nimbip suk aŋgniŋgamb ak apiy aŋgnimuŋ, ‘Buŋgiy sikop. Nimb apiy cheya tep ar biy bisgim aŋgek,’ biynimb tap ñiŋniŋg ap mindeniŋgambay gok nimbip niŋiy, bi gok namb biy biyomb mindpay aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kun ak rek, biynimb chin yimb yomb mindip aŋgiy niŋbay gok, Gor niŋek yimb kuyip apyowniŋgamb. Pen biynimb, Gor Biyomb yimb mindip aŋgiy siskoy diy mindpay gok, Gor yimb kuyip gek araniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jiysis minim kun ak aŋgiy, bi tap yomb ñiŋniŋg, biynimb suk aŋgak ak nup aŋgak, “Nand tap yomb ñiŋniŋg; namam nak gok, buŋgiy nak gok, biynimb miñmon nak jimñiy gok, bi maniy kuŋay mindeniŋgamb gok kuyip nep suk ma aŋgnimin. Biynimb kun gok rek, nip pen ambey ñiniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tap yomb ñiŋniŋg; biynimb yimgeprek gok, biynimb ñin tomb paŋg pikek amdip gok, biynimb windin koy gok, biynimb ñin tomb timey gip gok kuyip suk aŋgey apiy; tap ñiŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","“Biynimb simbgeprek kun gok, nip pen ñiniŋgiy rek ma ayniŋgamb ak mey; kisen Gor biynimb suŋ-tep nuk gok, gek tikjakniŋgambay ñin ak, nip pen ñiniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pen minim kun ak niŋiy, bi kiy yip tap ñimbek bap, Jiysis nup aŋgak, “Gor biynimb nuk diy kond mindeniŋgamb gok, nuk yip jimñiy tap yomb ñiŋniŋgambay rek, miñmiñ yimb giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aŋgek, Jiysis aŋgak, “Bi bap tap yomb ñiŋniŋg, biynimb kuŋaynep suk aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pen tap yomb ñiŋemb ñin kun ak apeniŋgamb, bi nup woŋg giñiniŋgamb ak nup aŋgyokiy aŋgniŋgamb, ‘Miñiy am biynimb aŋgaypiyn gok kuyip am poŋind wan aŋgek,’ amiy aŋgniŋgamb, ‘Tap maŋgiysek dap nan-gip nen, apem amnun aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Aŋgek, biynimb kun gok bap aŋgniŋgamb, ‘Yand amnim ak pen; mankumb bap tawpiyn ak, niŋniŋg amjipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Bap aŋgniŋgamb, ‘Amnim ak pen; woŋg giyaŋ aŋgiy, makaw anep wanjrem tawpiyn ak, woŋg girep giniŋgiy akaŋ aŋgiy, tiwniŋg diniŋniŋg amjipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Bap aŋgniŋgamb, ‘Amnim ak pen, biyn yand ak kisen nep dipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kun aŋgey, bi kun ak andkind amiy biyomb nuk anup aŋgniŋgamb, ‘Biyomb! Biynimb apan gok am aŋgen, kiyk kun kun apay.’ Aŋgek, biyomb ak simbwur nup ak timey gek, binuk kun anup, tip ak dawin yomb kun okok aŋgyokiy aŋgniŋgamb, ‘Nand kasek kinjeŋ tam yomb okok sek, kinjeŋ tam sikoy okok sek amyiŋg; biynimb simbgeprek gok diy, biynimb ñin tomb beŋ beŋ gip gok diy, biynimb windin koy gip gok diy, mumbwak mind tep ma gip gok diy, dand winimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Aŋgek, aŋgniŋgamb rek giy, kisen bi woŋg giñemb kun ak aŋgniŋgamb, ‘Biyomb. Apan rek kisen gipiyn ak pen; wikan gunap tip anep mindip aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Aŋgek, biyomb ak bi kun ak nup, miñmon yikop okok aŋgyokiy aŋgniŋgamb, ‘Kinjeŋ tam yomb okok sek, kinjeŋ tam sikoy okok sek amiy, biynimb kuŋay yimb dand apey, korip miŋgan yip ak pisnep timbik dinimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pen biynimb nind suk aŋgen ma opay gok, tap yip siskoy gunap ma ñiŋniŋgambay. Mer yimb aŋgniŋgamb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jiysis kun aŋgiy amnakniŋ, biynimb kuŋay yimb nep, nup kisen giyakniŋ, nuk andikiy kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Biynimb gok yip ker winiŋgambay ak pen, gos yomb kiyk amniŋgamb; nop, nonim, nunay, numam, biyn, ñapan kiyk, akaŋ mumbwak kiyk key ak; yand niŋen biynimb yand mindeniŋgiy rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Biynimb gunap aŋgniŋgambay, Jiysis biynimb nuk mindenjun ak pen; kun gon, biynimb gunap chinup timey giniŋgiy rek ayip aŋgiy, mumbwak kiyk keynep gos niŋyiŋg mindeniŋgambay ak, kuyip ma diniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Pen bi nimb bap, korip yomb bap giniŋg, maniy ak yerip yerip diy ginim aŋgiy, gos ak niŋrep giy ginimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pen giyn giyn aŋgiy, simen ak nind nep giniŋgamb ak pen, korip par kun ak sisak gek, biynimb gok nup aŋgjiwiy aŋgniŋgambay, ");
INSERT INTO kmh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Bi par ak korip giniŋg rek gi dand amiy, day sek kirgip aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Pen kun ak rek, bi bap, biyomb bap yip penpen giniŋg; gos niŋ-tep giy amnimuŋ. Gos niŋdand amiy, amiybi yand ak ten tawsin nep mindip; biyomb kun ak amiybi nuk tiwendiy tawsin mindip; penpen giy, yip ñaŋg aynimuŋ rek ayip aŋgiy mey, ");
INSERT INTO kmh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","par okok kisen owakniŋ, minim ak yokiy aŋgniŋgamb, ‘Minim aŋg jimñinjur aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Kun ak niŋrep ginimimb. Tap nimb gok nep wasemb ay, biynimb nimb gok nep wasemb ay giniŋgambim ak, biynimb yand ma mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol tap yindik tep yimb ak pen; yindik nuk ak amek, yergiy gey tip ak yindik giniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol kun ak rek, di woŋgday ak ayey, timey giniŋgamb. Kun ak woŋg nuk bap ma mindip; diyokep rek nep ayip. Minim kun ak, biynimb gos timund sek ak tikniŋnimimb aŋgak” ");
INSERT INTO kmh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Biynimb tap siy tap timey giyak gok sek, bi takes dep gok sek Jiysis minim asap ak niŋun aŋgiy, ap niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pen bi Peresiy gok sek, bi low tiysa gok sek Jiysis nup, aŋgjiwiy aŋgyak, “Nuk yenen bi tap siy dep gok yip, bi takes diyiŋg maniy yesek gunap dipay gok yip, per tap jimñiy ñiŋimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kun aŋgey, Jiysis niŋiy, minim bap kuyip paydoŋ ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bi nimb bap, kanj siypsiyp ñin jiwiy onep mamind ak mok mindeniŋgamb. Pen nokom bap kurgek, gunap dam wikan bap ayek, tap kaskas ñiŋyakniŋ, kanj nuk kurginiŋgamb ak, mapin piŋiyñiy nep ayek, piyowek amniŋgamb. Am piyow giraŋgraŋg niŋiy, ");
INSERT INTO kmh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","nup tep yimb gakniŋ, di wanjrem ar ak ay dand korip winiŋgamb. Dand apiy, ");
INSERT INTO kmh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","buŋgiy nuk gok kuyip suk aŋgiy, biynimb miñmon nuk yip jimñiy gok kuyip suk aŋgiy gek, ap nan-gey aŋgniŋgamb, ‘Kanj yand kurgip ak piyow niŋiy dipiyn nen; maŋgiysek apem miñmiñ gun aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Kun ak rek, Gor biynimb nuk kuŋaynep suŋ-tep rek ayniŋgamb ak pen; gos nuk ak amniŋgamb biynimb minim nup timbrikiy, pisnep kumjun rek ayip aŋgiy, niŋniŋgambay gok. Kun ak mey, bap nup ker apek, enjol nuk gok yip miñmiñ yimb giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Akaŋ pen, biyn bap maniy maŋgiy nuk onep wanjrem ak mindeniŋgamb. Pen won bap, korip miŋgan okok kapkap yapeniŋgamb, nuk yerginiŋgamb? Nuk lam daŋgiy ay, tap day day liŋg liŋg, maniy nuk won kun ak niŋiy dek, ");
INSERT INTO kmh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","nup tep yimb gakniŋ, buŋgiy nuk gok kuyip, maŋgiysek suk aŋgek ap nan-gey aŋgniŋgamb, ‘Maniy yowip won ak piyow niŋbiyn nen, maŋgiysek apem miñmiñ gun aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Kun ak rek, Gor biynimb nup kirpay gok kuyip giniŋgamb. Biynimb nup kirpay kun gok, bap gos kisenimb niŋiy, nup deniŋgamb, nuk enjol nuk gok yip miñmiñ yimb giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jiysis kun aŋgiy aŋgak, “Bi bap ñi omiŋal tikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ñinuk kisen ak, ap nop nup aŋgniŋgamb, ‘Bapiy. Tap chirupmiŋay apan gok, pikasik yip gok key ñan aŋgek,’ nop tap kuyipmiŋay gok pikasik keykey ñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ñek, ñinuk kisen ak permindiy mer, nop tap pikasik ñiniŋgamb gok yokiy maniy diy, dand miñmon paryomb okok amniŋgamb. Am kun okok mindiy, biyn siy tap timey okok giyiŋg, maniy dand amniŋgamb gok, maŋgiysek giñimb diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Kun giy ñimbdeniŋgamb, yiwan yomb yimb ak winiŋgamb miñmon kun ak. Maniy diy, tap taw ñiŋnimuŋ rek bap, ma yimb mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kun gek, am bi miñmon nop nimb, kun ak nimb bap aŋgniŋek, nup kanj woŋg ak aŋgayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pen nup yiwan yomb yimb ak ginep mindek mindek, kanj mokniŋgambay tap day gok gunap, ñiŋnimuŋ rek ayniŋgamb ak pen; biynimb gunap, nup tap keñmaŋgiy ma ñiniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Pen kisen, gos nuk ak asik ayek aŋgniŋgamb, ‘Bapiy bi nup woŋg giñimbay gok, keñmaŋgiy kuŋay mindip. Yand biy minden, yiwan yomb yimb ak gip. ");
INSERT INTO kmh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bapiy mindip ak tip andkind amiy, nup aŋgniŋgayn, “Windin yirik ar nip ak timey giy, Gor windin yirik ar ak timey giy gipiyn rek, ");
INSERT INTO kmh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","yip ñiyand ma aŋgnimin. Bi woŋg nip giñemb yikop rek bap, aŋgayey mindenim, aŋgniŋgayn” aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Kun aŋgiy, saŋdiniŋgamb. Am am, nop mindeniŋgamb siŋak maŋ maŋ gakniŋ, nop ñinuk nup parchim niŋek, simb timey yimb gek, kasek am nup di kaykol gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","aŋgniŋgamb, ‘Bapiy. Gor windin yirik ar ak timey giy, windin yirik ar nip ak timey giy gipiyn rek, yip “Ñiyand” ma aŋgnimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","“Nop pen, bi woŋg nup giñiniŋgambay gok kuyip aŋgniŋgamb, ‘Ñiyand ak pisnep kurgiy kumak rek ayak ak pen; miñiy niŋsipiyn. Nup chech paryomb ak ayñiy, ñin riyŋ ayñiy, tomb tirup ayñiy ginimimb. Kun giy, am makaw ñiluk tep yimb bap pik dand apem, daŋgiy ñimbyiŋg, miñmiñ ginjun aŋgniŋgamb.’ Aŋgek, aŋgniŋgamb rek giy, keñmaŋgiy daŋgiy ñimbyiŋg, miñmiñ giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Pen ñinuk nind ak, woŋgday okok giraŋgiy, andkind yep korip maŋ siŋak apiy niŋniŋgamb; giyta pikiy, miñmiñ giyiŋg geniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kun gey niŋiy, bi nop nup woŋg giñemb bap nup aŋgniŋiy aŋgniŋgamb, ‘Yergispay?’ ");
INSERT INTO kmh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aŋgek aŋgniŋgamb, ‘Namam kisen kumimb aŋgiy niŋbun ak pen; miñiy andkind apek, nap makaw ñiluk tep yimb bap, pik daŋgiy ñimbyiŋg, miñmiñ gispay aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aŋgek, nup miluk timey yimb yapek, korip miŋgan ma yimb amniŋgamb; mis akyaŋ nep mindeniŋgamb. Nop pen mis apiy, ‘Korip miŋgan wan aŋgiy’ nup minim sisayn aŋgek, ");
INSERT INTO kmh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ñinuk aŋgniŋgamb, ‘Yand minim apan rek kindik giy, bi yikop woŋg giñimbay rek ak mindiy, woŋg nip ak per gen gen, simiy kuŋay yimb nep yinimb. Pen yip meymey ñiluk bap ñey, buŋgiy yand gok yip pik daŋgiy ñimbyiŋg, miñmiñ ma gipun. ");
INSERT INTO kmh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ñinak kun ak, tap bilok ñinak gok dam biyn siy, tap okok giy, ñimbdiy apek, nup simb niŋiy, makaw ñiluk tep yimb ak pikpan aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kun aŋgek, nop ñinuk nup aŋgniŋgamb, ‘Chirapiy per mindpur rek, tap yand gok maŋgiysek nak diniŋgamban. ");
INSERT INTO kmh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Namam kisen kumimb rek ayak ak pen; miñiy tip ak apek yimb niŋiy mey, miñmiñ gispun aŋgniŋgamb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jiysis binuk gok kuyip aŋgak, “Biyomb tap nuk kuŋay mindeniŋgamb bap, bi kond mindep nuk bap aŋgayek, tap nup gok kond mindeniŋgamb. Pen biyomb ak, minim bap niŋniŋgamb; bi tap nup kond mindeniŋgamb ak, tap nup gok monmon giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kun ak niŋiy, nup suk aŋgek apek aŋgniŋgamb, ‘Tap yip kond mind tep ma gipan ak, yip aŋgñey niŋbiyn. Kun ak nand am, tap yand yerip yerip mindip gok ñin paŋg tep giy; biynimb okok kuyip, tap day yand yerip yerip mindip gok ñin paŋg tep giy, ap yip aŋgñinimin. Pen woŋg yip ak kisen ma giniŋgamban aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Aŋgek, bi tap nup kond mindep kun ak, namb nuk okok nep gos kuŋay niŋiy aŋgniŋgamb, ‘Biyomb ak yip aŋgyoksap rek yerginim? Yand bi kilis ma mindpiyn ak, man piŋiy paŋgnim rek ma ayip. Biynimb gunap tap kuyip ak asimb aŋgñimben, yip nambiŋ giniŋgamb aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pen kisen gosimb niŋrep giy aŋgniŋgamb, ‘Yerginim ak niŋsipiyn. Ar kun ak gen biyomb ak yip aŋgyokek, biynimb gunap yip dey, korip kiy ak kin mindeniŋgayn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kun aŋgiy, biyomb nuk ak biynimb gunap kuyip, tap day mindeniŋgamb gok suk aŋgek, bi nind winiŋgamb anup aŋgniŋgamb, ‘Biyomb yand ak, tap day nuk nip yerip yerip mindip?’ ");
INSERT INTO kmh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aŋgek, ‘Wel diram ñin jiwiy onep kaŋgol ak aŋgniŋgamb.’ Aŋgek aŋgniŋgamb, ‘Tiker biy diy, kasek ñin jiwiy omiŋal nokom nep tikan aŋgniŋgamb.’ Aŋgek, aŋgniŋgamb rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kisen bi bap apek aŋgniŋgamb, ‘Biyomb yand ak, tap day nuk nip yerip yerip mindip?’ Aŋgek, ‘Wan tawsin rays bek aŋgniŋgamb.’ Aŋgek aŋgniŋgamb, ‘Tiker biy diy, kasek eyit handret nep tiknimin aŋgniŋgamb.’ Aŋgek, aŋgniŋgamb rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kun gek, kisen biyomb ak niŋiy aŋgniŋgamb, ‘Bi tap yip kond mindep ak, yerer giy mindrep giniŋgamb ak, niŋrep gip aŋgniŋgamb.’ “Kun ak niŋim: Biynimb yikop gok apay, ‘Miñiy yergiy gon, kisen bisgep chin ak mindeniŋgamb aŋgiy’ gos ak niŋyiŋg, gey amimb. Pen biynimb Gor ker mindpay gok, kun rek gey ambikop ak tep. ");
INSERT INTO kmh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Maniy tap yerip man ar biy mindip gok, biynimb yimgeprek gok kuyip simb niŋiy ñem mey; kisen tap kun gok pisnep kurginiŋgamb ñin ak, kinjeŋ tep nimb ak mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tap sikoy bap, biynimb gunap kuyip ñin ar ak ayey, direp ma giniŋgambay ak; tap yomb bap ñey, kunep giniŋgambay. Pen tap sikoy bap, di ñin ar kuyip ayey, direp giniŋgambay ak; tap yomb gok ñey, kunep giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pen nimb taprep lum ar biy diyiŋg, niŋrep giy ma geniŋgambim; an nimbip gek perper mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Biyomb ak tap nuk, pen ñin ar nimbip ayek, direp ma geniŋgambim, gos yerip niŋiy, tip tep miñmon nuk biyoŋ ak nimbip aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Bi nokom bap, biyomb omiŋal kuyip woŋg giñinimuŋ rek ma ayip. Yenen: nuk biyomb bap nup niŋek tep geniŋgamb, biyomb bap nup kirginiŋgamb. Akaŋ biyomb bap nup niŋek tep geniŋgamb; bap nup kirginiŋgamb. Kun ak, nimb maniy tap yikop gok, tap tep yimb aŋgiy, Gor nup kirginimimb rek ayip ak; niŋrep ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bi Peresiy gok, gosimb yomb kiyk maniy ar ak nep niŋyiŋgipay ak mey, Jiysis minim aŋgak kun ak niŋiy, aŋgjiwyak. ");
INSERT INTO kmh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aŋgjiweyak, kuyip aŋgak, “Tap biynimb niŋey tep gip gok, Gor niŋek tap yikop rek ayip. Nimb biynimb windin yirik ar ak, chin biynimb tep mindpun apim ak pen; Gor namb nimbip biyaŋ niŋimb. ");
INSERT INTO kmh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Pen Jon bi ñiŋg pikñemb ma mindek ñin ak, biynimb gok Mosis low minim tikak ak sek, bi Gor minim aŋgep gunap minim tikyak ak sek niŋiy, ar kun ak gey amyiŋgip. Pen miñiy, Jon apiy, minim tep Gor biynimb diy kond mindeniŋgamb ak aŋgek niŋiy, biynimb maŋgiysek ar kun ak nep amnun aŋgiy, gey amjap. ");
INSERT INTO kmh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pen semb biyoŋ sek, mankumb biy sek kurginiŋgamb rek ayip: Gor low minim ar ak, kurginimuŋ rek ma mindip. ");
INSERT INTO kmh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kun ak bi biyn diy kirgiy, am biyn kisenimb bap dipay gok, timey gipay. Pen bi an tikjakiy, biyn bi diy kirgak bap nup diniŋgamb ak; kunep timey giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Bi bap maniy tap nuk kuŋay yimb mindyiŋgip. Nuk chech teprep yimb gok nep yimiy, tap ñiŋemb teprep gok nep ñimbyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pen korip kinjeŋrumb gol nuk siŋak, bi soy sek tap ma mindek bap, dap ayey mindyiŋgip. Yimb nuk Lasaras. ");
INSERT INTO kmh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gosimb nuk ak, yand bi tap kuŋay mindip biy tap ñimbek, day day boŋg molik okok yowniŋgamb gok ñimben mey, yip yiwan ma giniŋgamb aŋgyiŋgip. Pen kayn gok apiy, soy nup gok bileŋg ñimbyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kindik, bi maniy tap nuk ma mindyiŋgip kun ak kumek, enjol gok ap nup dand Gor miñmon biyoŋ amiy, Ebraham yip ayak. Bi maniy tap nuk kuŋay mindyiŋgip ak, kunep kumek komyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","am mon key yinjap ak, yiwur yomb yimb gakniŋ mindyiŋgip. Pen mindiy, kiyoŋgiy niŋak: Ebraham, Lasaras yip keykey siŋbiyoŋ minderik. ");
INSERT INTO kmh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Niŋiy, suk aŋgiy aŋgak, ‘Bapiy Ebraham. Yip simb niŋan. Lasaras nup aŋgey, ñin maŋgiy par nuk bap ñiŋg ak tawiy, dap alemb yip ak diniŋek, yip sayn gaŋ. Mon ak yiniy, yip yiwur timey yimb gip aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aŋgek, Ebraham aŋgak, ‘Ñi niŋan! Man ar biyaŋ mindenak ñin ak, nak tap tep gok nep dinak; Lasaras tap timey gok nep dak. Pen miñiy miñmon biy, nuk sayn tep mindakniŋ, nip yiwur yomb gisap. ");
INSERT INTO kmh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gor mol yomb yimb ak, namb biy gayak ak mey; chin biynimb pis biy, talakiy kayaŋ ak ma amniŋgambun. Pen nimb pis kayaŋ ak talakiy, biy ma winiŋgambim aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Aŋgek, bi kun ak aŋgak, ‘Kun apan ak, Lasaras nup aŋgey, bapiy korip amiy, ");
INSERT INTO kmh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mam yand onep mamind ak kuyip, minim kilis yimb ak aŋgenimuŋ, miñmon yiwur pernep gip biy, ma winiŋgiy aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Kun aŋgek, Ebraham aŋgak, ‘Gor Mosis nup gos ñek, Baybol buk minim tikak ak sek, bi minim nup aŋgep gunap kuyip gos, ñek Baybol buk tikyak minim ak sek mindip. Niŋniŋg, kun gok niŋniŋgiy aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Aŋgek, maniy bi kun ak aŋgak, ‘Bapiy. Ak tep ma apan. Biynimb bap kumiy tikjakiy, am aŋgeniŋgamb mey, niŋind aŋgip aŋgiy, tap siy tap timey gipay ar ak kirgiy, Gor nup nep gosimb niŋniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aŋgek, Ebraham aŋgak, ‘Kiyk Mosis minim tikak ak ma niŋiy, bi Gor minim aŋgep gunap, minim tikyak ak ma niŋiy gipay ak; bi bap kumiy tikjakiy, am aŋgek, kunep ma niŋniŋgambay aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jiysis binuk gok kuyip aŋgak, “Biyn bap akaŋ, bi bap miñ timey ar ak giy, biynimb gunap kuyip gos ñey, ar kun ak giy apyap pikpay ak; timey yimb gip. Miñ ar kun ak nind giyiŋgipay, miñiy gipay, kisen kunep giniŋgambay. Pen gipay kun ak rek, yiwur kun ak key yimb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kiyk won kun siŋak nep, giniŋg giyakniŋ, kuyip kamb yomb bap, kuŋam ak sek miñ aybirikiy, dam ñiŋg yokpiyap ak, kuyip tep gipyap. Yenen: kiyk kim mindiy, biynimb yip ker ñin tomb wos ma gip gunap, kuyip gey apyap pikniŋgambay ak, yiwur yomb yimb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kun ak nimb asik tep ginimimb. Pen mam akaŋ, ay bap tap siy tap timey gonimuŋ, nup niŋchikiy aŋgem, yenen kun gipiyn aŋgiy niŋonimuŋ; niŋiy kirginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pen tap nimbip rek gunap timey giyiŋg, yenen kun gipiyn aŋgiy, ap aŋgonimuŋ, niŋiy kirginimimb. Ñin nokom bap, kun gek gek onep ar ak rek amek, kunep niŋiy kirginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jiysis kun aŋgek, binuk gok aŋgyak, “Chin key kun ginjun rek ma ayip; kuyip yiruk niŋjun rek ayip. Kun ak nand gey, chin Gor nup gosimb nokom niŋon, chinup kond mindakniŋ, kun ginjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aŋgey, Jiysis kuyip aŋgak, “Pen Gor nup gosimb niŋbim ak yomb mer: mon mastet maŋgiy achimb rek nep mindek; aŋgniŋgambim, ‘Mon biy junj sek jiwiy, ñiŋg yomb namb siŋbindoŋ, jak mindey aŋgem,’ Gor aŋgniŋgambim rek nep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Bi bap, bi woŋg giñemb nuk bap diy aŋgek, am man piŋiy paŋgiy akaŋ, kanj siypsiyp gok mok taŋgiy, andkind korip apek, biyomb nuk ak, nup yerip aŋgniŋgamb? ‘Nip yiwan gip, kasek ap bisgiy tap ñiŋan aŋgniŋgamb?’ ");
INSERT INTO kmh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mer! Kun ma aŋgniŋgamb. Nuk aŋgniŋgamb, ‘Chech ak dey apek, ler ak aybirikiy, ñiŋg tap yip gok dapey ñimben, kisen ñiŋg tap nand gok ñiŋan aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bi woŋg giñemb nuk ak, aŋgniŋgamb rek gek, nup minim tep gunap ma aŋgniŋgamb. ‘Bi woŋg giñemb yand ak mey, apiyn rek gip aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Kun ak rek mey nimb. Gor nimbip aŋgniŋgamb rek giy, kisen aŋgniŋgambim, ‘Chin biynimb tep mer: ar bap key ma gipun; woŋg chin gep rek ak mey, gipun aŋgniŋgambim’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jiysis Jerusalem amniyn aŋgiy, miñmon Samariya biy Galiyliy bindoŋ, namb ak am am miñmon bap amjakakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","bi soy ayndik ayak onep wanjrem ak, nup namb pikiy, keykey siŋbindoŋ mindiy, ");
INSERT INTO kmh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aŋgyak, “Biyomb Jiysis. Chinup simb niŋan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aŋgeyak, kuyip aŋgak, “Nimbip suŋ ayip nen, am bi Gor nup simboŋgep gok kuyip, yomnimimb aŋgak.” Kun aŋgek, kinjeŋnamb okok amniyakniŋ, kuyip maŋgiysek suŋ ayek, ");
INSERT INTO kmh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","bi Samariya nimb ak nup suŋ ayak ak niŋiy, minim yomb aŋgyiŋg, Gor nup yimb ak dand aranyiŋg, ");
INSERT INTO kmh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","andkind ap Jiysis mindek siŋak koŋgim yimiy, nup “Tep” aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kun gek niŋiy, Jiysis aŋgak, “Yand aŋgniŋbiyn-eŋ; bi onep wanjrem ak suŋ ayip aŋgiy niŋbiyn ak pen; bi onep anjip ak akay? ");
INSERT INTO kmh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bi gunap yenen ma opay? Bi par okok nimb ak nep apiy, Gor nup tep aŋgip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kun aŋgiy, bi kun anup aŋgak, “Jiysis yip gek, suŋ ayniŋgamb aŋgiy gos ak niŋban rek, nip gen suŋ ayip nen, amnoŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pen bi Peresiy gok, Jiysis nup aŋgyak, “Kiyŋ yomb key per kond mindpun ak ñin akay rek apiy, chinup diy kond mindeniŋgamb?” Aŋgey, Jiysis aŋgak, “Biyomb biynimb diy kond mindeniŋgamb apim kun ak, biyomb kiyŋ gunap, biynimb miseŋ kond mindey niŋiy apay, ");
INSERT INTO kmh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Biynimb kond mindip biy, kond mindip bindoŋ apay’ rek ma aŋgniŋgambim. Yenen, nuk nimbip bak ay, kapkap kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kun aŋgiy, binuk gok kuyip aŋgak, “Kisen ñin bap, Bi bap Ñinuk nup niŋun aŋgiy, mapin nimbip ak, piŋiyñiy nep ayniŋgamb ak pen, nup miseŋ ma niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Biynimb gunap mindip bindoŋ, mindip biy aŋgey, minim kun ak niŋind apay aŋgiy, ma am piyow niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yenen: Bi bap Ñinuk winiŋgamb ñin ak, añiñak diy, melik parsek gip rek ak, gakniŋ winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pen biynimb miñiy mindpay gok, nup yiruk niŋiy ma dey; yiwur yomb yimb ak diy, kumiy tikjak semb biyoŋ amiy, kisen tip ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nuk winiŋgamb ñin kun ak, wosrey Nowa mindek ñin ak, gak rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Biynimb gok tap ñimbyiŋg, ñiŋg ñimbyiŋg, biyn penpen ñiyiŋg gi mindyakniŋ, Nowa amyoŋg apyoŋgon siyip miŋgan sikind amdey, miñmon yomb sikerek ak pikiy, ñiŋg wilik apiy, biynimb kun gok kuyip, maŋgiysek yiwiŋgdek kumyak. ");
INSERT INTO kmh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Pen bi Lot mindek ñin ak, Sodom Gomora biynimb gok kunep tap ñimbyiŋg, ñiŋg ñimbyiŋg, sikyim giyiŋg, tap woŋg giyiŋg, korip giyiŋg gi mindyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot miñmon kun ak kirgiy, miñmon wikan bap key amnakniŋ, mon maŋlaŋ yomb yimb ak, semb biyoŋ nimb apiy, Sodom Gomora biynimb kuyip, maŋgiysek yin simbok amnak. ");
INSERT INTO kmh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bi bap, Ñinuk winiŋgamb ñin ak; Nowa mindyiŋgip ñin ak sek, Lot mindyiŋgip ñin ak sek gi mindyiŋgipay rek, gi mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ñin kun ak, biynimb korip ar biyoŋ mindeniŋgiy gok, tap kiyk gok diniŋg, korip miŋgan ma amniŋgiy. Pen biynimb woŋgday okok taŋgeniŋgiy gok, tap gunap diniŋg, andkind korip ma amniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot biynuk nup gak ar ak niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pen biynimb key nep mindiy, mindrep giniŋgayn aŋgniŋgambay gok, mon key yinjap ak amniŋgambay. Biynimb Jiysis ker minden, yip pikayniŋg pikayniŋgiy aŋgiy, yip kisen giniŋgambay gok, biynimb yand yimb mindiy mey, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nimbip aspiyn: ñin kun ak, bi omiŋal minj ar nokom bap, kineniŋgayr ak; Gor bi bap nup diy, bap nup kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pen biyn omiŋal biret jimñiy gi mindeniŋgayr ak; bap diy, bap nup kirginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bi omiŋal woŋgday okok taŋgeniŋgayr ak; bap diy, bap nup kirginiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kun aŋgek aŋgyak, “Biyomb. Minim aspan kun ak, akay kun giniŋgamb?” Aŋgey, Jiysis aŋgak, “Miñ miŋgan, mon miŋgan, kamb miŋgan okok ma giniŋgamb; miseŋ nep namb siŋak giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jiysis binuk gok, yiruk ma niŋniŋgiy, Gor nup aŋgniŋyiŋg nep mindeniŋgiy aŋgiy, kuyip minim bap paydoŋ ay aŋgak: ");
INSERT INTO kmh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Miñmon bap, biyomb kor niŋep bap mindeniŋgamb. Pen bi kun ak, Gor nup gosimb ak ma niŋiy, biynimb gok kuyip simb ma niŋniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Biyn kaŋil miñmon kun ak nimb bap, pernep apiy nup aŋgniŋgamb, ‘Bi ñaŋgep yand ak, minim chirup ak niŋnimin aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kun aŋgniŋgamb ak pen, biyomb kor niŋep kun ak, minim nup ak ma diniŋgamb. Ma dek, nup ap minek minek aŋgniŋ gek gek, kisen biyomb kun ak aŋgniŋgamb, ‘Yand Gor nup, gosimb ak ma niŋiy, biynimb gok kuyip, simb ma niŋiy gipiyn ak pen; ");
INSERT INTO kmh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","biyn kaŋil biy minek minek ap aŋgek aŋgek, yip yiruk giniŋgamb nen, kor kun ak niŋnim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Bi yikop biynimb simb ma niŋep ak, kun gak ak pen; ");
INSERT INTO kmh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Gor ma giniŋgamb aŋgiy niŋbim? Akaŋ pen, takiy mindiy giniŋgamb aŋgiy niŋbim? Mer! Nimbip aspiyn: biynimb nuk key niŋiy dak gok kuyip, timey giyakniŋ, pumbnamb kisyimken nup aŋgniŋyiŋg mindpay rek, per ma kond mindeniŋgamb; aŋgniŋgambay rek niŋiy giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pen chin mind tep gipun; biynimb gunap, mind tep ma gipay aŋgyak rek, kuyip minim bap paydoŋ ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bi Peresiy bap, bi takes diyiŋgip bap Gor nup aŋgniŋniŋg, Gor aŋgniŋep korip ak amnirik. ");
INSERT INTO kmh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bi Peresiy ak namb nuk okok nep, Gor nup lotiw giy aŋgak, ‘Nip tep yimb aspiyn. Yand bi gunap gipay rek; biyn siy, tap siy, tap timey okok ma gipiyn. Yand bi takes dep biy rek mer. ");
INSERT INTO kmh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wiyk minek minek lotiw minden aŋgiy, per ñin omiŋal tap ma ñimbiyn sek. Per tap yand onep wanjrem ak diyiŋg, nip nokom bap ñiy, yand onep anjip ak nep dipiyn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Pen bi takes dep ak, keykey siŋbikdoŋ jiy kuyaŋgiy mindiy, gos kuŋay niŋiy aŋgak, ‘Gor. Yand bi tap siy tap timey gipiyn ak, yip simb niŋnimin aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nimbip aspiyn: Gor bi takes dep ak kun aŋgek niŋiy, nup diy, bi suŋ-tep yimb mindpiyn aŋgak ak nup ma dak. Yenen: biynimb yimb kiyk key dand aranimbay gok, Gor gek apyap pikniŋgambay. Pen biynimb, Gor Biyomb mindip aŋgiy, pirikiy, kapkap mindeniŋgambay gok; Gor gek yimb mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Biynimb gok Jiysis ñapan chinup gok bilesiym gaŋ aŋgiy, dand apey, bilesiym gakniŋ, binuk gok, biynimb kun gok kuyip niŋchikiy aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kun geyak, Jiysis ñapan sikoy gok suk aŋgek wiyakniŋ, binuk gok kuyip aŋgak, “Yenen kun apim? Ñapan sikoy gok kirgem, yip ker wiyaŋ. Gor nup dipay mey; ñapan sikoy kun gok rek. ");
INSERT INTO kmh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñapan sikoy gok, Gor minim ak kun kun giy mindip aŋgey niŋiy, kasek dipay. Kun ak nimbip niŋind aspiyn; biynimb ñapan sikoy yip gosimb niŋbay rek niŋniŋgambay gok, Gor kuyip diy, kond mindeniŋgamb; biynimb yikop gok kuyip kirginiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jiwda biyomb bap, Jiysis mindek ak apiy aŋgak, “Tiysa nand bi tep yimb. Yand yergen, Gor gek per mindeniŋgayn?” ");
INSERT INTO kmh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aŋgek, Jiysis aŋgak, “Biynimb gunap tep ma mindpay; Gor nuk nep mey, bi tep yimb mindip. Kun ak gos yerip niŋiy, yip bi tep yimb apan? ");
INSERT INTO kmh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pen nand Gor low minim ak niŋban: ‘Biyn siy bi siy ma ginimimb. Chip ma ñaŋgnimimb. Tap siy ma dinimimb. Yesek ma aŋgnimimb. Nap nanim minim aŋgnimiyr ar ak nep niŋiy, kindik ginimimb aŋgip’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aŋgek, bi kun ak aŋgak, “Yand ñiskoy miŋg tikiy, low minim ar kun ak kindik gi dap dap, miñiy ñin biy, kindik ginep mindpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jiysis minim kun ak niŋiy aŋgak, “Tap nokom bap nep ma gipan. Tap nak gok maŋgiysek yokiy maniy diy, biynimb yimgeprek gok kuyip ñiy mey; mindrep gep nand ak, mindeniŋgamb Gor miñmon biyoŋ. Kun ak apiyn rek giy apiy, bi yand bap mindenimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aŋgek, nuk minim kun ak niŋiy, gospar yimb ayak. ");
INSERT INTO kmh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gospar ayek, Jiysis aŋgak, “Biynimb tap kuŋay mindip gok, kosyam yimb Gor nup gosimb niŋey, kuyip diy kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kanj kamel gok, ñiw lekpay miŋgan ak amniŋg, kasek amniŋgiy rek ayniŋgamb; pen biynimb maniy tap kiyk kuŋay mindip gok, kosyam yimb Gor nup gosimb niŋey, kuyip diy kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kun aŋgek, biynimb mindeyak gok aŋgyak, “Minim aspan kun ak, biynimb gunap Gor ker mindenjun rek ma ayip. Akaŋ yerip?” ");
INSERT INTO kmh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aŋgey, Jiysis aŋgak, “Ar gunap biynimb giniŋgiy rek ma ayniŋgamb ak pen; Gor nuk giniŋg, ginimuŋ rek nep mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kun aŋgek, Piyta aŋgak, “Niŋan! Korip tap chin gok maŋgiysek kirgiy, nip chiŋgiy nep tapun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aŋgek, Jiysis kuyip aŋgak, “Nimbip niŋind aspiyn. Biynimb Gor biynimb nuk kuŋay diy kond mindonimuŋ aŋgiy; korip, biyn, numam, nop, nonim, ñapan kiyk gok kuyip kirgey, Gor sakiy ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Miñiy mindpun ñin namb biy, kuyip kond mind tep gek, tap kiyk gok, biynimb kiyk gok kuŋaynep mindeniŋgamb. Pen ñin kisen ak apek, nuk yip perper mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jiysis binuk onep wimiŋgan ak kuyip, dand gol okok amiy aŋgak, “Niŋim. Miñiy Jerusalem amoniŋgambun, Bi bap Ñinuk nup, wosrey Baybol buk ak tikiy aŋgyak rek giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nup di bi Jiwda mer gok, ñin ar ak ayeniŋgambay, nup aŋgjiwyiŋg, ñiñloŋ ayiŋg, kiñuk giyiŋg, ");
INSERT INTO kmh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","miñ diy pikyiŋg, pisnep pikayniŋgambay. Pen minek omiŋal nokom mindiy, tip ak tikjakiy, kim mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pen kun aŋgek, binuk gok gos paŋgyiknimuŋ rek ma ayek, minim asap ar ak aŋgiy, ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pen kisen, am miñmon Jeriykow amjakyakniŋ, bi windin koy, maniy tap gok nen asimb aŋgyiŋgip bap, kinjeŋ yomb gol siŋak bisiŋg mindek ak mey; ");
INSERT INTO kmh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","biynimb kuŋaynep minim aŋg pandikyakniŋ, biynimb gunap kuyip aŋgniŋiy aŋgak, “Yergispay?” ");
INSERT INTO kmh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aŋgek aŋgyak, “Jiysis bi Nasaret nimb ak, apiy pandiksap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kun aŋgeyak, nuk suk yomb aŋgiy aŋgak, “Jiysis! Depiyt Ñinuk! Yip simb niŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aŋgek, biynimb pandikeyak gok, nup aŋg giy aŋgyak, “Yenen kun aspan? Kapkap mindey aŋgyak.” Kun aŋgyak ak pen, nuk kapkap ma mindek, suk yomb aŋgyiŋg aŋgak, “Jiysis! Depiyt Ñinuk! Yip simb niŋan aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aŋgek, Jiysis niŋiy aland giy, biynimb gok kuyip aŋgak, “Poŋind yep maŋ siŋbiy wim aŋgak.” Aŋgek, poŋind apeyak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nip yerginim?” Aŋgek aŋgak, “Biyomb. Yip gey windin ak tip niŋiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aŋgek, Jiysis nup aŋgak, “Yip geniŋgamb, windin yimb niŋniŋgayn aŋgiy gos niŋban ak, windin niŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aŋgek, won kun anep windin niŋiy, Gor nup yimb ak dand aranyiŋg, Jiysis amnakniŋ, kindik gak. Biynimb maŋgiysek Jiysis gak kun ak niŋiy, Gor nup yimb ak dand aranyak. ");
INSERT INTO kmh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Pen miñmon Jeriykow namb kun ak, bi maŋ nep won bap, maniy tap nuk kuŋay mindyiŋgip ak mindek. Yimb nuk ak Sakiyas. Nuk bi takes dep gok kuyip, maŋgiysek kond mindyiŋgip. Jiysis pandikakniŋ, biynimb kuŋaynep ap niŋniŋg geyak, Sakiyas bi maŋ won ak mey, Jiysis bi yerip rek ak niŋiyn aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","nind amiy, mon bind bap tanaraniy, Jiysis apek tam bineŋ niŋmindek. ");
INSERT INTO kmh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jiysis pen ap, mon tan mindek kiñiŋ siŋak apiy, kuyoŋgiy niŋiy, Sakiyas nup aŋgak, “Kasek luŋg yowan! Miñiy korip nand ak, am mindeniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aŋgek, Sakiyas luŋg yapiy, miñmiñ giyiŋg, Jiysis nup poŋind korip nuk amnak. ");
INSERT INTO kmh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Biynimb gok gak kun ak niŋiy, miluk yapek aŋgyak, “Bi kun ak am, bi tap siy tap timey gip korip ak, kiniŋg amjap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pen kisen am, Sakiyas korip ak minim aŋg mindyiŋg, Sakiyas Jiysis nup aŋgak, “Biyomb. Nand niŋan! Miñiy tap yand gok bilok pis ak ay, pis ak biynimb simbgeprek gok kuyip ñiniŋgayn. Yand nind tom giy, biynimb gunap tap kuyip siy dinik rek ayip gok, pen ñiniŋg, tap nokom bap dinik rek, pen omiŋal omiŋal ñiniŋgayn. Pen tap omiŋal siy dinik rek, pen ñiniŋg, onep jiy ak ñiniŋgayn. Kun giy, gi dam dam maŋgiysek day paŋg diy, kirginiŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pen biynimb gok niŋmindyakniŋ, Jiysis Sakiyas nup minim ak aŋgiy aŋgak, “Bi biy nusind Ebraham, Gor nup gosimb niŋak rek niŋimb ak mey; Gor miñiy nup diy, biynimb nuk yip korip jimñiy kinbay gok kuyip diy gip. ");
INSERT INTO kmh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yenen: bi bap Ñinuk wak ak, biynimb Gor ker mindpay gok kuyip diniŋg ma wak; biynimb nup ker ma mindpay gok kuyip diniŋg awak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pen biynimb kun gok, Jiysis mey, Biyomb per kond mindpun ak; Jerusalem amek, nup kiyŋ aŋgayon, chinup kond mindek, mindrep yimb giniŋgambun aŋgiy niŋyak. Jiysis gos niŋyak kun ak key niŋiy, minim nind aŋgak ak niŋyakniŋ, minim bap sek paydoŋ ay aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Bi biyomb mindep rek bap, kond mindep yand ak mindip amen, yip kiyŋ aŋgayek, andkind apiy, biynimb miñmon yand guniy kuyip kond mindenim aŋgiy, miñmon paryomb okok amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pen kisen amniŋgamb: nind bi nup woŋg giñiniŋgambay onep wanjrem ak kuyip suk aŋgek apey, maniy yir omiŋal, omiŋal keykey bilok ñiy aŋgniŋgamb, ‘Maniy ñispiyn biy diy, woŋg biysniys genimimb. Kisen yand tip ak winiŋgayn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Kun aŋgiy, amniŋgamb ak pen; biynimb miñmon nuk yip jimñiy gok, nup miluk niŋiy, bi gunap aŋgyokey kisen amiy, bi kond mindep ak nup aŋgniŋgambay, ‘Bi chinup kiyŋ aŋg ayniŋg gispan biy, chin ma diniŋgambun aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pen nup kiyŋ aŋgayek, tip ak andkind apiy, bi nup woŋg giñiniŋgambay gok kuyip, suk aŋgek apey aŋgniŋgamb, ‘Maniy ñinik gok sikyim gi andik mandik giy; pen yerip yerip dipim?’ ");
INSERT INTO kmh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aŋgek, bi nind winiŋgamb ak aŋgniŋgamb, “Biyomb. Maniy yir yip ñinak omiŋal ak, sikyim gi andik mandik giy, pen yir ñin jiwiy ak dipiyn aŋgniŋgamb.” ");
INSERT INTO kmh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Aŋgek, biyomb ak aŋgniŋgamb, ‘Nand girep gipan. Tap sikoy ak ñenik, woŋg girep ginak rek, miñiy miñmon dawin yomb onep wanjrem ak aŋgen, kond mindeniŋgamban aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Bi namb ak apiy aŋgniŋgamb, ‘Biyomb. Maniy yir yip ñinak omiŋal ak, sikyim gi andik mandik giy, pen yir onep mamind ak dipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Aŋgek, biyomb ak aŋgniŋgamb, ‘Gipan kun ak rek, miñiy nip aŋgen, dawin yomb onep mamind ak kond mindeniŋgamban aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Pen bi nup woŋg giñemb bap apiy aŋgniŋgamb, ‘Biyomb. Yand nip niŋbiyn. Nand bi kalrimey yimb. Biynimb gunap tap kuyip gok sikyim girep giy mer; pilgiy rek dipan. Tap woŋg kosyam giy yimbay gok, nand kilis giy nep ñimban. Kun ak yand nip pirikiy mey, maniy yir yip ñinak omiŋal ak, yikop dam tiwniŋg ayen mindek, miñiy dand opiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Aŋgek, biyomb ak aŋgniŋgamb, ‘Minim nak apan ak tuŋgandikiy, nip key kor giniŋgayn. Yip bi timey yimb, biynimb tap kuyip gok sikyim girep giy mer; yikop diy, tap woŋg kosyam gi yimbay gok, nand kilis giy nep, taw piliŋg dipan apan kun ak; ");
INSERT INTO kmh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","yenen maniy yip ak diy, dam beŋ ayey, andkind apiy siyniŋ gunap sek ma dipiyn aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kun aŋgiy, bi yep maŋ siŋak mindeniŋgambay gok kuyip aŋgniŋgamb, ‘Maniy yir yip omiŋal ak piliŋg diy, bi maniy yir ñin jiwiy mindip ak nup ñim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aŋgek aŋgniŋgambay, ‘Biyomb. Nuk maniy yir ñin jiwiy ak, di mindip aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Aŋgey aŋgniŋgamb, ‘Nimbip aspiyn. Per biynimb tap kiyk kuŋay mindip gok, gunap sek dipay; pen biynimb tap kiyk siskoy mindip gok, gey pisnep yap amimb. ");
INSERT INTO kmh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pen biynimb, ‘Kiyŋ kun ak chin ma diniŋgambun aŋgiy, miluk niŋbay gok kuyip am dand apiy, windin yirik ar yip siŋbiy, ñaŋg aynimimb aŋgniŋgamb’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jiysis kuyip minim kun ak aŋgiy, binuk gok yip Jerusalem amnun aŋgiy, nuk nind giy, ");
INSERT INTO kmh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","am am, Oliyp pir miñmon Betpasiy-Beteniy gol siŋak amjakiy, binuk omiŋal kuyip aŋgyokiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Miñmon wikan bindoŋ amiy niŋniŋgayr; doŋgiy marip biynimb ma dand tapay bap, tiwniŋgayey mindeniŋgamb. Wisikiy dand winimiyr. ");
INSERT INTO kmh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pen biynimb gunap apiy aŋgniŋgiy, ‘Kanj doŋgiy chinup ak yenen wisik dand amjipiyr aŋgeniŋgiy’ aŋgnimiyr, ‘Biyomb ak woŋg mindek aŋgyokamb, diniŋg opur aŋgnimiyr’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kun aŋgek, amiy niŋrik: aŋgak rek nep mindek. ");
INSERT INTO kmh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am miñ ak wisik girikniŋ, bi doŋgiy nop nimb gok apiy aŋgyak, “Doŋgiy marip chinup ak yenen miñ wisiksipiyr?” ");
INSERT INTO kmh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aŋgey aŋgrik, “Biyomb ak woŋg mindamb aŋgip ak mey, wisiksipur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kun aŋgiy, doŋgiy marip kun ak miñ wisikiy, poŋind dand Jiysis mindek ak amjakiy, chech kiyk band gunap tuŋgjiwiy, di doŋgiy ar ak ay, Jiysis nup di ar kun biyoŋ ayer bisgak. ");
INSERT INTO kmh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bisgiy, lor ar ak amnakniŋ, biynimb gok, chech tap okok dap lor ar kun ak ayakniŋ, tawyiŋg tawyiŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am am, Jerusalem maŋ maŋ gakniŋ, Oliyp dum kinjeŋ kuyaŋgipay tip ak, biynimb nuk gok kuŋaynep, nup miñmiñ yimb giyiŋg, tap yerip yerip gak gok gos ak niŋiy, suk yomb aŋgyiŋg, Gor nup yimb ak dand aranyiŋg, ");
INSERT INTO kmh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","aŋgyak: “Gor kiyŋ yomb chinup aŋgyokamb wip biy, chinup kond mindrep giniŋgamb. Chinup direp yimb gip kun ak, yimb nup dand yiy ar biyoŋ aranjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kun aŋgyakniŋ, bi Peresiy gunap namb kun okok mindeyak gok, Jiysis nup aŋgyak, “Tiysa. Biynimb nak gok kuyip aŋg gey, kun ma aŋgyaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aŋgeyak, Jiysis aŋgak, “Nimbip aspiyn; kun ak ma aŋgeniŋgambay, Gor kamb gok gek, minim aŋgniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jiysis Jerusalem maŋ maŋ giyiŋg, dawin yomb kun ak niŋiy, siy ñiŋg tik dam yokyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Miñmon Jerusalem. Nimbip simb yimb niŋsipiyn. Nimbip di Gor yip jimñiniŋg winik ak niŋbikip rek, tep yimb gipkip! Pen ma niŋiy, windin koy rek mindpim! Gor nimbip ker apek ma dipim rek, ");
INSERT INTO kmh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","kisen bi gunap ap dawin yomb nimbip biy, ñiluk ay kus kus gi mindiy, ");
INSERT INTO kmh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","pisnep gi timey yimb gey, woŋg wariy, minj, korip, tap gunap ma yimb mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kun aŋgiy, nuk Gor aŋgniŋep korip ak amiy, biynimb sikyim geyak gok kuyip, aŋg mis yokyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Baybol buk tikiy aŋgyak, ‘Korip yand ak, yip aŋgniŋep korip ak mindip aŋgyak’ ak pen, nimb sikyim gem gem, biynimb tap siy diy, ap kapkap kinbay korip bap rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pen Jiysis minek minek, ap Gor aŋgniŋep korip miŋgan ak, biynimb gok kuyip minim aŋgñiyiŋgip. Bi Gor nup tap simboŋgep yomb gok, bi low tiysa gok, bi minim tuŋgasikep gok nup pikayun aŋgiy, gos nokom niŋyak ak pen, ");
INSERT INTO kmh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","biynimb maŋgiysek minim tep nup ak niŋun aŋgiy, yiñrimey yimb geyak, minim bap aŋgiy nup pikayniŋgiy rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pen ñin namb kun siŋak, Jiysis Gor aŋgniŋep korip miŋgan ak amiy, nuk biynimb di Gor yip jimñiy ayniŋgamb minim tep ak aŋgñakniŋ, bi Gor nup tap simboŋgep yomb gok, bi low tiysa gok, bi minim tuŋgasikep gok apiy, ");
INSERT INTO kmh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nup aŋgyak, “An nip aŋgek, ap Gor aŋgniŋep korip biy, biynimb gok kuyip yuk yokyiŋg, minim aŋgñiyiŋg girapan?” ");
INSERT INTO kmh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aŋgey aŋgak, “Yand nimbip pen, aŋgniŋep bap aŋgniŋniŋg gispiyn. ");
INSERT INTO kmh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon biynimb gok kuyip ñiŋg pikñak ak, gos nuk key niŋiy gak akaŋ, Gor aŋgek gak?” ");
INSERT INTO kmh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aŋgek, kiyk key aŋgniŋ aŋgniŋ giy aŋgyak, “‘Gor aŋgek Jon biynimb gok kuyip ñiŋg pikñak aŋgon,’ nuk aŋgniŋgamb, ‘Kun ak minim nup ak, yenen ma niŋbim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pen Jon gos nuk key niŋiy, biynimb gok kuyip ñiŋg pikñak aŋgon, biynimb guniy, Gor aŋgek apiy gek niŋbay rek, chinup kamb jiw pikayniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kun aŋgiy, Jiysis nup aŋgyak, “Jon ap biynimb gok kuyip minim aŋgñiy, ñiŋg pikñiy gak ak, chin ma niŋbun. Gos nuk key niŋiy gak akaŋ, Gor aŋgek gak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kun aŋgey, kuyip aŋgak, “Nimb yip pen ma aŋgñimbim rek, yand pen; an aŋgek ap gispiyn ak, nimbip ma aŋgñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pen Jiysis kuyip paydoŋ ay aŋgak, “Bi bap wayn woŋg ak gi yimiy, biynimb woŋg nup giniŋgambay gunap kuyip aŋgay, nuk am miñmon paryomb okok mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pen wayn maŋgiy pik giniŋgamb ñin ak, binuk bap aŋgyokiy aŋgniŋgamb, ‘Am aŋgey, wayn maŋgiy yip gunap ñey, dand winimin aŋgniŋgamb.’ Aŋgek amjakek, biynimb wayn woŋg gi mindeniŋgambay gok, nup pik pik ay, yikop aŋgyokey andkind winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kun gey, bi wayn woŋg nop nimb ak, bi bap pen aŋgyokek amniŋgamb. Pen nup kunep pik pik ay, yikop aŋgyokey andkind winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kun gey, bi kisenimb bap aŋgyokek amjakek, nup tapin yimb pikiy, lipiŋg dam mis akyaŋ yokniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kun geniŋgambay, bi woŋgday nop nimb ak, Ñi mapin yand ak yoken, minim aŋgeniŋgamb niŋniŋgambay aŋgiy, yokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yokek amjakek, biynimb wayn woŋg gi mindeniŋgambay kun gok aŋgniŋgambay, ‘Ñi wip biy, nop wayn woŋg ak, nuk dinimuŋ rek ayip. Nup pisnep pikay, chin dun aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kun aŋgiy, nup lipiŋg dand mis okok amiy, pisnep pikayey kumniŋgamb. Pen kun geniŋgambay, bi woŋgday nop nimb ak kuyip yerginiŋgamb? ");
INSERT INTO kmh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nuk apiy, biynimb kun gok kuyip pikay, woŋgday kun ak biynimb gunap kuyip pen aŋgek, kond mindeniŋgambay aŋgak.” Jiysis kun aŋgek, biynimb niŋmindeyak gok aŋgyak, “Mer! Chinup Jiwda biynimb kun ma ginimuŋ. Biynimb kisenimb gok aŋgek, ma kond mindeniŋgiy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aŋgeyak, kuyip niŋkuskus giy aŋgak, “Baybol buk ak, minim kun ak rek tikiy aŋgyak: ‘Bi korip gep gok, kamb bap tep ma gek kirgiyak ak pen, miñiy korip sap namb yomb biyaŋ ak piŋiyñiy mindip aŋgiy’ tikyak. ");
INSERT INTO kmh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Biynimb kamb ar kun ak apyap pikniŋgambay gok, tapin nep pikniŋgamb. Pen kamb kun ak puŋgjiw apyapiy, biynimb aybirikniŋgamb gok, pisnep piksimbjakniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jiysis kun aŋgek, “Chinup nep asap aŋgiy,” bi low tiysa gok sek, bi Gor nup tap simboŋgep yomb gok sek nup kor gun aŋgiy niŋyak ak pen; biynimb kuŋaynep niŋmindeyak niŋiy, pirikiy kirgiyak. ");
INSERT INTO kmh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pen minim aŋgak gok niŋiy, nup yergiy dand kor amjun aŋgiy, am biynimb gunap kuyip mimuŋg giy aŋgyak, “Nimb biynimb tep rek silok ay, am tom giy, nup minim gunap aŋgem, pen yerip aŋgonimuŋ niŋiy, nup dand gapman kor yomb ak amniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kun aŋgey, nup am aŋgniŋiy aŋgyak, “Tiysa. Chin niŋbun; yip yerip gos niŋniŋgambay aŋgiy minim key gunap ma apan; biynimb gok kuyip Gor minim aŋgñiniŋg akaŋ, yerip aŋgniŋg, yipund giy nep apan. ");
INSERT INTO kmh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kun ak yerginjun. Rom gapman biyomb Siysa nup, takes pikjun akaŋ, mer?” ");
INSERT INTO kmh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kiyk yesek tom giyak kun ak, Jiysis key niŋiy, kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Maniy takes pikpay kun ak bap yip diñem niŋiyn aŋgak.” Aŋgek, diñey niŋiy aŋgak, “Maniy bak ak, kawnan an ker mindiy, yimb tikyak kun ak, an yimb ak mindiy gip?” Aŋgek aŋgyak, “Siysa kawnan ak mindiy, yimb nuk ak mindiy gip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aŋgey, kuyip aŋgak, “Kun ak Siysa yip ginimimb aŋgip gok, nup ginimimb; Gor yip ginimimb aŋgiy niŋimb gok, nup ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pen minim aŋgak kun ak, kiyk niŋey, miker nup bap, dinimuŋ rek ma ayek, wal aŋgyak. Bi gos tipaŋgiy niŋiy aŋgip aŋgiy, pen minim gunap ma aŋgiy, minim gomb pisnep kurgak. ");
INSERT INTO kmh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Biynimb gunap, biynimb kumiy ma tikjakpay aŋgiy, gos ak niŋyiŋgipay. Biynimb kun gok kuyip, “Sanjiwsiy biynimb” aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kiyk gos kun ak niŋyiŋgipay rek, ap Jiysis nup nembnemb giyiŋg aŋgyak, “Tiysa. Bi Gor minim aŋgep Mosis; minim bap chinup tikiy aŋgak: ‘Bi bap biyn diy, ñapan tikiy mer yikop kumeniŋgamb, numam nuk bap pen, biyn kun ak diy, ñapan nup ak aŋgiy tikniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kun ak, bi kiñiŋ sek onep ar ak mindeniŋgambay; numam nind ak biyn diy, ñapan tikiy mer; yikop kumniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kumek, numam namb pen, biyn kun ak diy, kunep ñapan tikiy mer; yikop kumniŋgamb. Kun gek, numam namb ak pen diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ak kunep ñapan tikiy mer; yikop kumniŋgamb. Kun gi dam dam, numam onep ar ak maŋgiysek ñapan tikiy mer; yikop kumniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kisen biyn kun ak kunep kumniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pen kumiy tikjakniŋgambay apan ak, biyn nokom binuk di onep ar ak ayniŋgamb kun ak, kisen an ker mindeniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aŋgey, Jiysis kuyip aŋgak, “Miñiy mindpun ñin biy, biyn gok bi dipay; bi gok biyn dipay. ");
INSERT INTO kmh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pen Gor biynimb nuk gok kumiy tikjakiy, biyn gok bi ma diniŋgambay; bi gok biyn ma diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pen tip ak ma kumniŋgambay; Gor ñi pañ nuk gok mindiy, enjol nuk gok per mindpay rek mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Biynimb kumiy tikjakpay minim ak, Mosis kunep aŋgiy tikak ak niŋbun. Gor mon bind maŋlaŋ gek namb ak mindiy, basind nind kumyak gok yimb aŋgiy, Mosis nup aŋgak, ‘Yand Gor yesek bap mer; Ebraham, Aysek, Jekop Gor kiyk yand mindpiyn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Biynimb nind kumyak gok, ‘Gor kiyk mindpiyn’ aŋgak rek chin niŋbun; biynimb kim mindpay akaŋ, kumbay gok Gor niŋimb, maŋgiysek kim mindpay.” ");
INSERT INTO kmh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jiysis kun aŋgek, bi low tiysa gunap aŋgyak, “Tiysa. Minim yipund giy nep aspan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Minim aŋg tep gak kun ak pirikiy, kisen minim gunap nup ma aŋgniŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pen Jiysis kuyip aŋgak, “Biynimb gok, Kiyŋ yomb key yimb ak nup, Depiyt Biyomb nuk aŋgniŋgiy ak pen; yenen nup Depiyt tik dand amiy apiy gek, tikpay ñi ak nep apay. ");
INSERT INTO kmh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Depiyt nuk key, Kiyŋ yomb key yimb ak nup minim aŋgiy, Baybol buk day ‘Sam’ apay ak tikiy aŋgak: ‘Biyomb Gor, Biyomb yip ak nup aŋgip, “Nand ñin yipund kind yip okok mindiy, ");
INSERT INTO kmh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mind dand amiy, biynimb nip alemb alemb ñimbay gok kuyip, tomb beŋ nand okok ayen, tawbirikniŋgamban aŋgip” aŋgiy’ tikak. ");
INSERT INTO kmh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pen Depiyt Kiyŋ yomb key yimb ak nup, Biyomb yand aŋgak kun ak, yenen nup Depiyt ñinuk ak nep apay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pen biynimb gok niŋmindyakniŋ, Jiysis binuk gok kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nimb bi low tiysa gok gipay rek ginimimb rek ayip ak, niŋrep yimb ginimimb. Kiyk gipay ar ak, okok taŋgon yimb chinup anep aŋgyaŋ aŋgiy, chech paryomb gok yimiy, nan-gep korip ak amiy, biyomb bispay ar ak bisgiy, tap yomb ñimbay ñin ak, am biyomb bisginiŋgiy tip ak dipay. ");
INSERT INTO kmh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pen biyn yandiw gok korip tap kuyip okok, chinup nimb tikaŋ aŋgiy lip lip giyiŋg, Gor nup aŋgniŋsipun aŋgiy, minim paryomb yesek yesek ar gok apay. Kun gipay ak, kisen yiwur yomb key yimb ak, diniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jiysis Gor aŋgniŋep korip miŋgan ak, am mindiy niŋak: biynimb maniy sek gok, maniy gunap dap kes opriyŋ ayiŋgipay miŋgan ak yokeyak. ");
INSERT INTO kmh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pen biyn yandiw simbgeprek bap, maniy likañsek sikoy omiŋal ak dap yokak. ");
INSERT INTO kmh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yokek, Jiysis niŋiy aŋgak, “Nimbip niŋind aspiyn. Biynimb gunap maniy siskoy yokpay; biyn yandiw simbgeprek biy, maniy nuk yomb yimb ak yokip. ");
INSERT INTO kmh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pen biynimb gunap, maniy kiyk kuŋaynep mindakniŋ opriyŋ ñimbay; biyn yandiw simbgeprek biy, maniy nuk mindip rek maŋgiysek yokip. Tap taw ñiŋnimuŋ bap ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pen binuk gunap aŋgyak, “Gor aŋgniŋep korip biy, kamb tep tep tap okok dand apiy giyak ak, tep yimb mindip aŋgyak.” Kun aŋgey, Jiysis kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kun apim ak pen, kisen tap tep niŋsipim kun gok ma mindeniŋgamb. Amiybi miñmon okok nimb gok apiy, maŋgiysek tuŋgwaniŋg diyokey, kamb bap, kamb bap ar ak ma mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aŋgek, nup aŋgniŋiy aŋgyak, “Tiysa. Tap kun ak ñin akay rek kun giniŋgamb. Pen tap yerip rek ak gek niŋiy, miñiy giniŋg gisap aŋgniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aŋgey, Jiysis kuyip aŋgak, “Niŋrep ginimimb! Biynimb kuŋaynep ap tom giy, yimb yip ak diy aŋgniŋgambay, ‘Yand nep aswiyn. Ñin yomb ak wip aŋgniŋgambay.’ Kun aŋgey, niŋind apay aŋgiy ma niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Pen miñmon wikan gunap tikjakiy, miñmon wikan gunap yip penpen giniŋgambay; miñmon wikan gunap kiyk keynep penpen gey niŋiy, ñin kisen apay ak winiŋg gakniŋ gispay aŋgiy, ma piriknimimb. Ñin kun ak kisen winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kun aŋgiy, kuyip aŋgak, “Miñmon gunap, miñmon gunap yip penpen giniŋgambay. Biyomb gunap layn nuk gok tikjakiy, biyomb gunap layn nuk gok yip penpen giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Miñmon okok kuŋaynep monmon yomb diy, yiwan yomb giy, miñak yomb giy giniŋgamb. Tap semb ar biyoŋ gok key kindik nimb ayek, pirikep rek ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pen tap kun gok kisen kun giniŋgamb; nind yip ker mindpim rek, nimbip timey giniŋgambay. Nimbip kor giniŋg, dand Jiwda nan-gep korip ak amiy, kor giy, kalambis ay, dand gapman biyomb kor ak amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nimbip giniŋgambay kun ak, minim tep yip ak miseŋ aŋgñinimimb rek ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pen minim yerip rek aŋgjun aŋgiy, nind ma piyow niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yand key nimbip gos tep ñen, aŋgñimbikniŋ, kiyk niŋey diyokep rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Pen nap, nanim, namam, buŋgiy nimb, biynimb nimb key gok mimuŋg giy; nimbip gunap pisnep pikayniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yip dipim rek, biynimb maŋgiysek nimbip miluk niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pen jun kas nimbip bap ma kurginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yip chiŋgiy nep mindiy mey; perper mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pen amiybi gok ap, Jerusalem kus kus giyakniŋ; maŋ mindip Jerusalem timey giniŋgambay aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","biynimb Jiwdiya mindeniŋgiy gok, pirik miñmon yirik okok amniŋgiy. Biynimb Jerusalem mindeniŋgiy gok, pirik mis amniŋgiy. Pen biynimb mis okok mindeniŋgiy gok, dawin yomb miŋgan biyaŋ ma amniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yenen: Gor nup kirpay rek, ñin kun ak, Baybol buk tikiy aŋgyak aŋgyak rek nep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pen biyn ñapan koŋgiy mindeniŋgambay gok sek, biyn ñapan tiy ñeniŋgambay gok sek kuyip, miker yomb giniŋgamb. Gor Yisrel biynimb gok kuyip, miker yomb ñinim aŋgiy, miñmon biy gi timey yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Biynimb gunap kuyip, baynat diy piŋiy ayniŋgambay; biynimb gunap kuyip miñ ay, dand miñmon gunap amniŋgambay. Pen biynimb Jiwda mer gok, dawin yomb Jerusalem timey gi mindey mindey, Gor kuyip ñin aŋgayak ak pandikek nep, kirginiŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Pen pumb ak key yimb ay, takin ak key yimb ay, gap gok key yimb ay giniŋgamb. Ñiŋg siy paŋg apiy giw yomb aŋgek, biynimb miñmon kind kind maŋgiysek gospar ayiŋg, gos kuŋaynep niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tap semb ar biyoŋ mindip gok, okok nimb okok nimb gek, miñmon biy yerginiŋg gisap aŋgiy, jel pirikiy, gos tikek apek, kumemb rek ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nind kun geniŋgamb, kisen Bi bap Ñinuk semb biyoŋ nimb Nop kilis ak diy, melik tep nuk ak sek winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tap aspiyn biy kisen gakniŋ, Biyomb chinup tuŋgasik diniŋgamb ak, maŋ mindip winiŋgamb aŋgiy, niŋmindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jiysis kun aŋgiy, minim bap tikdam ay aŋgak, “Mon kiyaw ak sek, mon yikop gunap sek silup ayek niŋiy, ");
INSERT INTO kmh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","miñiy pumb ayniŋg gisap aŋgiy niŋbim. ");
INSERT INTO kmh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kun ak rek, tap apiyn gok gakniŋ aŋgniŋgambim, ‘Gor biynimb diy kond mindeniŋgamb ñin ak, maŋ asaw aŋgniŋgambim.’ ");
INSERT INTO kmh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Biynimb mindeniŋgambay ñin kun ak, ma kumniŋgambay; kim mindyakniŋ, tap aspiyn gok maŋgiysek gek niŋniŋgambay. Niŋind yimb apiyn. ");
INSERT INTO kmh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Semb ar biyoŋ sek, mankumb biy sek kurginiŋgamb; pen minim yand ak ma kurginiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pen niŋrep ginimimb. Ñiŋg kilis tap gok kuŋay ñimbiy, sikyim, simiy yiŋg chendbil, tap man ar biy nep gos niŋmindeniŋgambim; ñin kun ak apiy, nimbip yakir tap gok gon ayey dip rek ak diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Akniy nep ma giniŋgamb; biynimb miñmon kiñiŋ waŋgin omiŋal ak mindpay rek maŋgiysek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kun ak niŋrep ginimimb. Gor nup aŋgniŋyiŋg nep mindem mey; tap kun gok gakniŋ, nimbip kond mindek, kim amiy, am Bi bap Ñinuk windin yirik ar ak mindeniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Jiysis ñin kaw kun ak, am Gor aŋgniŋep korip miŋgan ak mindiy, biynimb gok kuyip minim aŋgñiyiŋgip. Kiyk minim nup niŋun aŋgiy, maynamb yimb tikjakiy, Gor aŋgniŋep korip ak amyiŋgipay. Pen kisyim wakniŋ, Jiysis nuk am miñmon Oliyp dum kinyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jiwda ñin yomb biret yiys sek ma ñimbay ñin ak, maŋ maŋ wak. Ñin yomb kun ak, enjol bap, Yijip biynimb kuyip pikayiŋg, Yisrel biynimb kuyip niŋiy kirgak ak mey, “Pasopa” apay. ");
INSERT INTO kmh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pasopa ñin yomb kun ak maŋ gakniŋ, Gor nup simboŋgep biyomb gok sek, bi low tiysa gok sek Jiysis nup ñaŋgun aŋgyak ak pen, biynimb gok kuyip pirikiy, yergiy ñaŋgjun aŋgiy, aŋgniŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aŋgniŋ mindyakniŋ, Seytan, Jiysis binuk Jiwdas, Yiskariyot nup molik sikak. ");
INSERT INTO kmh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sikek, nuk am Gor nup simboŋgep biyomb gok sek, Gor aŋgniŋep korip kond mindyiŋgipay poliys biyomb gok sek mindeyak ak amiy aŋgak, “Jiysis nup kayn gi dand amen, nup pikayniŋgambim aŋgiy minim ak kuyip aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aŋgñek, kuyip tep gakniŋ, nup aŋgyak, “Nip maniy ñiniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aŋgeyak mey; nuk Jiysis biynimb gok yip ma mindonimuŋ won ak, nup kayn gi dand amiy, biyomb gok kuyip ñinim aŋgiy, kond mindek. ");
INSERT INTO kmh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pen biret yiys sek ma ñimbay ñin kun ak apek, siypsiyp ñiluk pik Gor nup simboŋg ñiŋjun aŋgiy, ");
INSERT INTO kmh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jiysis nuk Piyta yip, Jon yip kuyip aŋgyokiy aŋgak, “Nirmiŋay am Pasopa tap ñiŋniŋgambun gok gayrep genimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aŋgek aŋgrik, “Akay kun ginjur?” ");
INSERT INTO kmh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aŋger aŋgak, “Nirmiŋay dawin yomb ak amiy niŋniŋgayr; bi bap ñiŋg mal dand apeniŋgamb. Nup namb pikiy, amnimuŋ miŋgan okok amiy, ");
INSERT INTO kmh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bi korip nop nimb kun ak nup aŋgnimiyr, ‘Tiysa nip aŋgip, Korip miŋgan akay, bi yand gok yip, Pasopa tap ñiŋniŋgambun aŋgip aŋgnimiyr.’ ");
INSERT INTO kmh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aŋger, niripmiŋay dam korip miŋgan yomb cheya tap gok sek mindeniŋgamb ar biyoŋ ak aŋgek, Pasopa tap ñiŋniŋgambun gok, miŋgan kun ak gayrep genimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aŋgek amiy niŋrik: aŋgak aŋgak rek nep mindek, Pasopa tap ñiŋniŋg giyak gok gayrep gerik. ");
INSERT INTO kmh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pen duŋgek wakniŋ, tap ñiŋniŋg, bi minim nup dand amemb gok yip ap bisiŋg kus kus giy, ");
INSERT INTO kmh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kuyip aŋgak, “Per gosimb yip wip ak, nimb yip Pasopa tap ñiŋniŋg gispun biy ñimbiy mey, kisen yiwur yomb diniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yenen: nimbip aspiyn, kisen tip ak ma ñiŋniŋgayn; yikop nep minden minden, siypsiyp ñiluk per ñimbun junj ak miseŋ gek, Gor biynimb nuk diy kond mindeniŋgamb ñin ak nep, tap yomb ak ñiŋniŋgambun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jiysis kun aŋgiy, ñiŋg wayn kap ak diy, Gor nup tep aŋgiy, binuk gok kuyip ñiyiŋg aŋgak, “Ñiŋg ñispiyn biy diy ñiŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pen nimbip aspiyn: miñiy ñin biy tikiy, ñiŋg wayn ak ma ñimben, Gor biynimb nuk gok kuyip diy kond mindeniŋgamb ñin ak winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kun aŋgiy, biret ak kunep diy, Gor nup tep aŋgiy, tipaŋg kuyip ñiyiŋg aŋgak, “Mumbwak yip yiwur yomb giniŋgamb rek, nimbip aspiyn. Ar kun ak biret biy diy, gos yip niŋyiŋg ñiŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pen tap ñimbdiy, wayn ñiŋg ak diy, kap miŋgan ak soŋgiy, kuyip ñiyiŋg aŋgak, “Likañ yip yapek kumen nep, Gor nimbip biynimb yand aŋgiy, diniŋgayn aŋgak minim ar ak wos amniŋgamb ak mey; nimbip ñiŋg wayn biy ñispiyn. ");
INSERT INTO kmh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Pen niŋim! Bi yip kayn gi dand amniŋgamb ak yip bisiŋg mindpun. ");
INSERT INTO kmh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bi bap Ñinuk, Gor aŋgak kinjeŋ ar ak kindik giy kumniŋgamb ak pen; bi nup kayn gi dand amniŋgamb anup, simb niŋsipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jiysis kun aŋgek, binuk gok kiykaw nep “An rek kun giniŋgamb aŋgiy,” pen aŋgek pen aŋgek gi mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jiysis binuk gok “Nimb mer! Yand biyomb minden aŋgiy,” kiykaw nep, key penpen aŋg mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jiysis kuyip aŋgak, “Gapman biyomb Gor ker ma mindpay gok, biynimb gok kilis giy kond mindyiŋg apay, ‘Kuyip direp yimb gipun apay.’ ");
INSERT INTO kmh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pen nimb kun ak rek ma ginimimb. Biyomb nimb gok, ñi paranj rek mindeniŋgiy; biyomb sikerek gok, bi woŋg giñemb rek mindeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mankumb biy gipay miñ ar ak, biyomb am bisgey, bi woŋg giñimbay gok, keñmaŋgiy tap kuyip gok marik gipay. Pen yand nimbip yikop, bi woŋg giñimbay rek ak gipiyn. Nimb kun ak rek ginimimb. ");
INSERT INTO kmh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yip miker yimb gip ñin biy ma kirpim; kond nep mindpim. ");
INSERT INTO kmh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kun gipim ak Gor yip aŋgip, ‘Biynimb gok kuyip diy kond mindeniŋgamban,’ aŋgip rek, yand pen nimbip aspiyn ak mey; ");
INSERT INTO kmh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ñin kun ak tomb aŋgin yip ak mindiy, Jiwda kiñiŋ yomb keykey onep wimiŋgan ak kuyip, kond mindeniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jiysis Piyta nup aŋgak, “Saymon, Saymon. Niŋan! Gor Seytan nup ‘Yaw’ aŋgek, nimbip wiyt maŋgiy soŋgey soŋgey, maŋgiy yimb ak key ay, day day ak key ay gipay rek ak giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pen Gor nup aŋgniŋbiyn rek, yip pisnep ma kirginiŋgamban. Pen tap siy tap timey giniŋgamban ak, ‘Yenen kun gipiyn aŋgiy,’ tip ak andkind yip ker winiŋgamban. Apiy, namiy namam gunap kuyip aŋg tep gey, mind tep giniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jiysis kun aŋgek, Piyta aŋgak, “Biyomb. Nip ma kirginiŋgayn. Omiŋal giy nep giraŋgor, nip kalambis ay, yip kunep ayniŋgiy. Pen nip pikay, yip kunep pikayniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aŋgek, Jiysis aŋgak, “Piyta. Nip aspiyn: miñiy kisyimken biyaŋ kakaruk ma suk aŋgniŋgamb won ak, Jiysis nup ma niŋbiyn aŋgiy, yinj omiŋal nokom aŋgniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kun aŋgiy, kuyip aŋgak, “Nind nimbip aŋgyokiy aŋgnik, ‘Anpawis, wand, tomb tirup gok dand ma amnimimb: yikop amnimimb aŋgnik.’ Aŋgen ambik ñin kun ak, nimbip tap gunap mindek akaŋ, tikdak?” Aŋgek aŋgyak, “Mer! Tap chinup gunap ma tikdak. Mindek aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aŋgeyak, Jiysis aŋgak, “Pen miñiy nimb anpawis, wand, tap gok mindonimuŋ, dand sesek amnimimb. Bi an ñayip baynat ma mindonimuŋ ak, kolsiyor nuk ak bi gunap kuyip yokiy maniy diy, baynat ak tawnimuŋ. ");
INSERT INTO kmh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pen niŋim! Yip nind, Baybol buk ak tikiy aŋgyak, ‘Nup bi timey monmon gip bap aŋgniŋgambay aŋgyak.’ Minim aŋgiy tikayak kun ak, miñiy giniŋg gisap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kun aŋgek, aŋgyak, “Biyomb. Baynat chin omiŋal mindip aŋgyak.” Aŋgey, “Mey ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kun aŋgiy, mis amiy, Gor nup aŋgniŋniŋg, per miñmon Oliyp dum amyiŋgipay ak amnakniŋ, binuk gok kisen giyak. ");
INSERT INTO kmh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dum kun ak amjakiy kuyip aŋgak, “Gos timey apek timey ginimimb rek ayip ak, lotiw giyiŋg mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kun aŋgiy, kuyip kirgiy, nuk keykey siŋbindoŋ amiy, koŋgim yimiy, Nop nup aŋgniŋiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapiy. Gos yand niŋbiyn ak, ñiŋg silik kap yip ñiniŋg gispan ak ma ñinimin. Pen yand niŋbiyn ar ak ma ginimin; gos nand key niŋban ar ak nep ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Kun aŋgiy, nup miker yimb gek, Nop nup aŋgniŋ mindakniŋ, wisimb ak likañ rek puŋgrik yowak. Kun gakniŋ, enjol bap semb biyoŋ nimb apiy, nup kilis ñak. ");
INSERT INTO kmh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nop nup aŋgniŋjiwiy, amiy niŋak: binuk gok miker gakniŋ wisin kineyak. ");
INSERT INTO kmh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Niŋiy, kuyip aŋgak, “Yenen wisin kinjipim? Gos timey apek, timey ginimimb rek ayip ak, tikjakiy, Bapiy nup aŋgniŋyiŋg mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jiysis minim kun ak aŋg mindakniŋ, binuk Jiwdas bi tiwin yomb bap poŋind apchakiy, Jiysis nup kaykol giyn aŋgek, ");
INSERT INTO kmh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jiysis aŋgak, “Jiwdas. Mey bi biy ñaŋgim aŋgiy, yip kaykol giniŋg gispan?” ");
INSERT INTO kmh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kun aŋgakniŋ, binuk gok giniŋg geyak kun ak niŋiy aŋgyak, “Biyomb. Kuyip baynat diy piŋiyjun akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kun aŋgyiŋg, binuk bap baynat ak diy, bi Gor nup simboŋgep yomb yimb woŋg giñemb anup, timund yipund kind ak, pisnep timbrik yokak. ");
INSERT INTO kmh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kun gek, Jiysis niŋiy aŋgak, “Kun ma ginimimb! Mey tep aŋgak.” Kun aŋgiy, timund ak tip gek yimñak. ");
INSERT INTO kmh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pen biyomb Gor nup simboŋgep gok, Gor aŋgniŋep korip poliys gok, bi minim tuŋgasikep gok nup ap, diniŋg gey, kuyip aŋgak, “Nimb baynat diy, kur diy dand opim ak: yip bi penpen ñaŋgep bap rek ayek niŋiy, chichiy diniŋg opim? ");
INSERT INTO kmh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nimb yip minek minek, Gor aŋgniŋep korip ak minden, yip ma dipik! Pen miñiy Seytan, bi kisyim kind okok ken mindip ak, ñin nuk ak mey; kun gispim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nuk kun aŋgakniŋ, nup chichiy diy, dand bi Gor nup simboŋgep yomb yimb korip ak amniyak. Piyta pen kikisen amiy, ");
INSERT INTO kmh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","mon daŋgiy mindeyak korip namb ak amiy, biynimb gunap yip jimñiy bisiŋg mindek. ");
INSERT INTO kmh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bisiŋg mindakniŋ, pañ korip kun ak woŋg giyiŋgip bap, nup niŋdand aran apyan giyiŋg aŋgak, “Bi biy kunep, Jiysis yip mindek aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aŋgek, Piyta aŋgak, “Pañ. Bi kun ak yand ma niŋbiyn aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pen yep sikoy won bap mindiy, bi bap pen, ap nup niŋiy aŋgak, “Nand kunep Jiysis binuk bap aŋgak.” Aŋgek Piyta, “Yand mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pen kisen tapin won bap mindiy, bi bap pen apiy, kilis giy aŋgak, “Bi biy Jiysis yip mindamb. Nuk kunep miñmon Galiyliy nimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aŋgek, Piyta aŋgak, “Minim aspan ak yand ma niŋbiyn aŋgak.” Kun aŋg mindakniŋ, day kakaruk aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aŋgek, Jiysis andikiy Piyta nup niŋyinjsek ayek, Piyta pen, Jiysis kun kun giniŋgamban aŋgak minim ak niŋiy, ");
INSERT INTO kmh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","kuŋam kinjik gek, mis amiy siy aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Bi Jiysis nup di mindeyak gok, chech band ak di windin nup ak pik yiwgiy, nup aŋgjiwyiŋg, pikyiŋg aŋgyak, “Nand bi key niŋban ak, nip an piksap ak chinup aŋgñan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pen minim timey kun ak rek, nup tapin kuŋaynep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Miñmon yowakniŋ, miytiyŋ gun aŋgiy, Jiwda bi minim tuŋgasikep gok, biyomb Gor nup simboŋgep gok, bi low tiysa gok ap nan-giy, Jiysis nup dand Jiwda kanjsol miytiyŋ kun ak amiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nand Jiwda Kiyŋ yomb key yimb per kond mindpun ak akaŋ aŋgyak.” Aŋgey, kuyip aŋgak, “Yaw aŋgen, niŋind aŋgip aŋgiy, ma niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pen aŋgniŋep yand mindip gok nimbip aŋgniŋen, yip pen ma aŋgniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pen miñiy, Bi bap Ñinuk am, Nop Biyomb tap yerip giyn aŋgiy giniŋgamb ak nup, ñin yipund kind ak mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kun aŋgek, bi kanjsol kun gok maŋgiysek nup aŋgyak, “Nak key Gor Ñinuk?” Aŋgey aŋgak, “Mey nimb key apim ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aŋgek aŋgyak, “Yenen, kor nup ak tapin aŋgmindenjun? Nuk key tom giy, Gor Ñinuk mindpiyn aŋgek niŋbun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kun aŋgiy, maŋgiysek tikjakiy, Jiysis nup dand gapman biyomb Paylat mindek ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dand amiy, nup kor giniŋg, minim okok nimb okok nimb dand apiy aŋgyak, “Chin piyow niŋiy niŋbun; bi biy biynimb chinup gok aŋgip, ‘Biyomb yimb Siysa nup takes ma pikiy, gapman kay minim ak kunep ma niŋnimimb aŋgip.’ Pen minim bap aŋgip, ‘Yand Krays, bi kiyŋ bap aŋgip’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aŋgeyak, Paylat Jiysis nup aŋgniŋiy aŋgak, “Nand Jiwda kay kiyŋ kiyk ak mindpan akaŋ?” “Aŋgek aŋgak, “Mey apan ak, aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aŋgek, Paylat pen, bi Gor nup simboŋgep yomb gok sek, biynimb yikop ap mindeyak gok sek kuyip aŋgak, “Yand niŋbiyn; bi biy nup kor gep junj bap ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kun aŋgak ak pen, kiyk meŋg miŋgan dand araniy aŋgyak, “Nuk gapman minim ma niŋnimimb aŋgiy, biynimb miñmon Jiwdiya okok maŋgiysek aŋgñimb. Miñmon Galiyliy tikiy, aŋgñi dap dap, miñiy Jerusalem biy wip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aŋgeyak, Paylat kuyip aŋgniŋiy aŋgak, “Bi kun biy Galiyliy nimb?” ");
INSERT INTO kmh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aŋgek, yaw aŋgey, biyomb Herot Galiyliy propens kond mindip ak, ap Jerusalem biy mindip rek, nup ker yoken kor biy niŋnimuŋ aŋgiy, kuyip aŋgek, dand mindek ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot, Jiysis tap giyiŋgip ak per minim anep niŋiy, minek akay rek, tap mageprek bap gek niŋniŋgayn aŋgiy, gos ak niŋmindyiŋgip ak mey, ñin kun ak Jiysis nup dand apchakey niŋiy, nuk miñmiñ yimb gak. ");
INSERT INTO kmh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pen Herot Jiysis nup minim kuŋaynep yiŋgin wiŋgin gek, Jiysis pen minim bap ma aŋgak. ");
INSERT INTO kmh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pen bi Gor nup tap simboŋgep yomb gok sek, bi low tiysa gok sek kilis giy, minim kuŋaynep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot, amiybi nuk gok yip, Jiysis nup gi timey giyiŋg, ñiñloŋ ayiŋg, gapman biyomb aypay chech tep bap yimñiy, tip ak Paylat mindek ak dand amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nind Herot yip, Paylat yip penpen aŋgmindyiŋgipiyr ak pen; ñin kun ak minim aŋg jimñirik. ");
INSERT INTO kmh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pen Paylat, biyomb Gor nup tap simboŋgep gok sek, bi minim tuŋgasikep gok sek, biynimb yikop gok sek aŋgek, ap nan-gey aŋgak, ");
INSERT INTO kmh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Yip apim, ‘Bi biy, biynimb gok kuyip kun kun aŋgip apim’ ak pen, miñiy windin yirik ar nimbip biy kor gipiyn ak, minim kor ginimbik junj bap mindek, ma niŋbiyn. ");
INSERT INTO kmh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot kunep minim junj bap ma piyow niŋiy mey; chinup ker tip ak aŋgyokamb dand opay. Bi kun biy, tap timey bap gek rek, minim nimbip ak diy nup ñaŋgnim. ");
INSERT INTO kmh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kun ak yikop pikiy, aŋgyoken amnaŋ aŋgak.”  ");
INSERT INTO kmh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jiwda ñin yomb kiyk “Pasopa” aŋgyiŋgipay ak apek, Paylat per kalambis bi kiyk bap yikop aŋgyokyiŋgip ak mey; ");
INSERT INTO kmh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ñin kun ak, kiyk maŋgiysek meŋg miŋgan dand araniy aŋgyak, “Bi kun ak ñaŋgay, Barabas nup aŋgyokem chinup ker owaŋ aŋgyak!” ");
INSERT INTO kmh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bi Barabas kun ak, dawin yomb namb ak, biynimb gunap diy penpen giy, bi bap pisnep pikayak rek nup kor giy kalambis ayak. ");
INSERT INTO kmh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pen Paylat tip ak, meŋg miŋgan dand araniy kuyip aŋgak, “Jiysis nup yikop aŋgyoken amnaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aŋgek, kiyk meŋg miŋgan dand araniy aŋgyak, “Nup mon kiros bak biyoŋ ñaŋgbirik ayim aŋgyak!” “Nup mon kiros bak biyoŋ ñaŋgbirik ayim aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aŋgeyak, Paylat tip ak kuyip aŋgak, “Yenen? Bi kun biy, tap yerip timey gip? Nup niŋen tap timey bap ma gip ak, ñaŋgjun rek ma ayip. Kun ak nup yikop pikiy, aŋgyoken amnaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aŋgek, kiyk kilis yimb giyiŋg, Jiysis nup ñaŋgbirik aynimimb aŋgiy, aŋg gey gey, ");
INSERT INTO kmh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paylat minim kuyip ak diy, ");
INSERT INTO kmh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","bi timey biynimb kuŋay diy, penpen giy, bi bap nup pikayak anup kirgek amnakniŋ aŋgak, “Jiysis nup ñaŋg aynimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","27","Jiysis nup ñaŋgniŋg dand saŋdiyakniŋ, biynimb kuŋaynep kisen giy amniyak. Namb okok amyiŋg niŋyak; bi Saymon, miñmon Sayriyniy nimb ak, Jerusalem apek. Nup niŋiy, mon kiros di wanjrem ar nup ak ayñiyiŋg aŋgyak, “Jiysis amjap ak kisen amnoŋ aŋgey,” dand kisen gak. Pen biynimb kuŋaynep ameyak namb kun ak, biyn gunap Jiysis nup simb niŋiy siy aŋgey, ");
INSERT INTO kmh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","nuk tuŋgandikiy kuyip aŋgak, “Nimb Jerusalem biyn! Yip giniŋg gisap ak siy ma aŋgnimimb. Nimbip timey giy, ñapan nimbip gok timey giy giniŋgamb ak, siy aŋgnimimb! ");
INSERT INTO kmh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kisen miker yomb asaw ak apek, aŋgniŋgambay, ‘Biyn ñapan ma tikpay gok sek, biyn ñapan tiy ma ñimbay gok sek tep, aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Ñin kun ak, yenen mindiy kumjun aŋgiy aŋgniŋgambay, ‘Miñmon yirik gok paŋg apiy, chinup pikaypikop akaŋ, konjiy diy chinup yiw gipkop ak, tep aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Yip mon kim tep, timey ma giniŋgiy rek ak pen, timey giniŋg gispay. Nimb mon milip rek wiŋind amiy mindpim ak, nimbip niŋind giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pen bi gapman low minim timbrikrik omiŋal ak, mon kiros bak biyoŋ ñaŋgbirik ayniŋg, dand sesek amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dand miñmon Chip jun won apay ak amjakiy, bi gapman low timbrikrik omiŋal ak pis pis ñaŋgbirikiy, Jiysis nup namb biyaŋ ñaŋgbirikyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nup kun giy, ñaŋgbirik ayey, nuk Nop nup aŋgak, “Bapiy. Yip gispay ak yerip gispun aŋgiy, niŋrep giy ma gispay. Kun ak kuyip niŋiy kirginimin aŋgak.” Pen amiybi gok, Jiysis nup mon kiros bak biyoŋ ñaŋgbirik ay, chech nup tuŋgjiw ayey mindek gok, kiyk key sandiw gipay rek ak giyiŋg diyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Biynimb kuŋaynep niŋmindyakniŋ, Jiwda biyomb gok, Jiysis nup panj aŋgiy aŋgyak, “Nuk ‘Yand Jiwda Kiyŋ yomb key yimb ak; Gor yip damb nuk yip mindpiyn aŋgiy,’ biynimb gunap kumey gamb tikjakpay. Gip kun ak rek, nuk key kunep giy, kim amek niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pen amiybi gok kunep nup panj aŋgyiŋg, maŋ siŋak apiy, ñiŋg silik ak ñiyiŋg aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Nand Jiwda bi kiyŋ yomb kiyk mindpiyn apan ak, nand key giy kim amnoŋ akaŋ aŋgyak!” ");
INSERT INTO kmh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pen mon boŋg band bap, Jiysis nup ñaŋgrimbikyak mon kiros bak biyoŋ, yimb tikay aŋgyak, “Jiwda biynimb kiyŋ yomb kiyk ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bi low minim timbriker, mon kiros bak biyoŋ ñaŋgbirikyak omiŋal ak, bap Jiysis nup aŋgak, “Nand Jiwda Kiyŋ yomb key yimb mindpan ak, nand key giy kim amiy, chirup kunep gey, kim amnur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aŋgek, bi bap nup pen aŋg giy aŋgak, “Chir miker dipur rek, nuk kunep dip ak, nand Gor nup ma pirikpan? ");
INSERT INTO kmh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Chirmiŋay timey gipur rek yiwur dispur, pen Jiysis tap bap ma giy, yikop nep yiwur disap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kun aŋgiy, Jiysis nup aŋgak, “Kisen nand Biyomb Kiyŋ mindiy winiŋgamban ñin ak, yip gosimb niŋnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kun aŋgek, Jiysis aŋgak, “Nip niŋind yimb aspiyn. Miñiy ñin biy, yand yip am tip tep ak mindeniŋgambur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ñin kun ak, pumbnamb yomb yoŋ won ak kisyim apiy, mind dand amiy pumb kuyim gak won ak, tip ak pen melik gak. ");
INSERT INTO kmh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Pen Jiysis kumniŋg aŋgak, “Bapiy. Kawnan yand ak ñin ar nip ak aysipiyn aŋgiy,” kumakniŋ, Gor aŋgniŋep korip ñiluk miŋgan suŋrep yimb biyaŋ, laplap di kinjeŋrumb pil giyak ak, puŋgrik biyoŋ biyaŋ ay, miŋgan yikiy mindek. ");
INSERT INTO kmh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pen amiybi kond mindep kiyk ak, Jiysis minim aŋgiy kumak kun ak niŋiy, Gor nup yimb ak dand aranyiŋg aŋgak, “Niŋind apay; bi tep yimb ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Biynimb ap mindeyak gok, tap gak kun ak niŋiy, simb yimb gakniŋ, andkind korip kiyk amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pen Jiysis buŋgiy nuk gok sek, biyn Galiyliy nimb wiyak gok sek kiyk keykey siŋbindoŋ mindiy, tap gak kun ak niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pen bi Jiwda minim tuŋgasikep, Gor minim di tep yimb giyiŋgip bap, miñmon Armatiya mindyiŋgip. Yimb nuk ak Josep. Nuk bi minim tuŋgasikep gunap, Jiysis nup ñaŋg ayun aŋgiy, gos niŋyak rek ma niŋak. Nuk Gor biynimb diy kond mindeniŋgamb ñin ak, maŋ mindip aŋgiy, kond mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nuk Jiysis nup dam komniŋg, Paylat mindek ak am aŋgniŋek, yaw aŋgek, ");
INSERT INTO kmh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","bi gunap yip am Jiysis nup tuŋgasik dand apyapiy, chech tund teprep yimb ak di kom kom giy, dam kamb miŋgan kisen nep kilukiy chip ma komyak miŋgan ak komyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pen Jiwda lotiw ñin ak, maŋ gip aŋgiy, Praydey duŋgep won ak, Jiysis nup kun giy dam komyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pen biyn tiwin, Jiysis yip Galiyliy nimb wiyak gok, Josep amnakniŋ kisen amiy, Jiysis nup komyak tip ak niŋrep giy, andkind korip amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Amiy, wel kuy tep wak gunap, Jiysis mumbwak nup ak ayñinjun aŋgiy, gay tep giyak. Minek kun anep dand ambiyap ak pen, Sarirey ñin ak, ñin yomb kiyk yikop mindep ak niŋiy mey, yikop mind mind kinyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Minek Sandey miñmon kisen tikak won ak, biyn tiwin kun ak, wel kuy tep wak ak diy, Jiysis mumbwak nup ayñinjun aŋgiy, dand Jiysis nup komyak ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amiy niŋyak: kamb kolim yomb chip kaw pil giyak won ak, milok am gol okok mindek. ");
INSERT INTO kmh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pen kiyk miŋgan kun ak amiy niŋyak: Jiysis ma mindek. ");
INSERT INTO kmh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yergip aŋgiy, aŋg mindyakniŋ, bi chech tund ñiñakol yimrik omiŋal ak, gol kun siŋak jakiy minderik. ");
INSERT INTO kmh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kiyk niŋiy, jel pirikiy, koŋgim yimiy kuyaŋgiyakniŋ, bi omiŋal kun ak aŋgrik, “Yenen bi kim mindip anup, chip kombay namb akniy piyow niŋsipim? ");
INSERT INTO kmh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nuk biy ma mindip. Mindarik tikjakip. Pen nimb gos niŋnimimb; Galiyliy mindiy, nimbip minim aŋgak ar ak. ");
INSERT INTO kmh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nimbip aŋgak, ‘Bi bap Ñinuk ak nup, di biynimb tap siy tap timey gipay ñin ar ak ayey, mon kiros bak biyoŋ ñaŋgrimbik ayey kumiy, minek omiŋal nokom mindiy, tip tikjakniŋgamb aŋgak’ aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kun aŋgrikniŋ, gosimb kuyip ak paŋgyikek, Jiysis nind Galiyliy mindiy, minim aŋgak kun ak niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Niŋiy, tip ak andkind amiy, tap gek niŋyak kun ak, Jiysis binuk onep aŋgip ak sek, biynimb nuk yikop gok sek kuyip aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Biyn tiwin, minim aŋgñiyak kun ak, Mariya miñmon Makdala nimb ak, Jowana ak, Jemis nonim Mariya ak, biyn yikop gunap sek. ");
INSERT INTO kmh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pen kiyk kun giy aŋgñeyak, minim kun ak niŋind apay aŋgiy ma niŋyak; ñiñloŋ ay aspay aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pen Piyta minim kun ak niŋiy, puŋgrikind yimb aŋgiy bindoŋ amiy, komyak kamb miŋgan ak sipsip niŋak: Jiysis nup chech kom kom giyak band gok nep mindek. Niŋiy, yergip aŋgiy, gospar yimb ayiŋg, tip ak andkind amnak. ");
INSERT INTO kmh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ñin kun anep, bi omiŋal miñmon sikoy Emeyas, yep Jerusalem maŋ kun okok amnur aŋgiy amyiŋg; ");
INSERT INTO kmh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tap yerip yerip gek niŋrik minim ak kapkap aŋgyiŋg amerik. ");
INSERT INTO kmh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Amnirikniŋ, Jiysis kund okok ken apiy, kiy yip yiŋgoŋg giy amnak. ");
INSERT INTO kmh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pen bi omiŋal kun ak, Jiysis nup niŋbirip ak pen, Gor gosimb kuyipmiŋay ak gek sakiy ayek, Jiysis nup niŋer, bi ak key rek ayak. ");
INSERT INTO kmh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nuk kuyipmiŋay aŋgniŋiy aŋgak, “Minim gok yerip aŋgyiŋg, aŋger asaw?” Kun aŋgek, yimgeprek jak mindyiŋg, ");
INSERT INTO kmh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","numam Kiliyowpas aŋgak, “Nand nep mey, miñiy ñin kaw biy, tap Jerusalem biy gisap ak ma niŋban?” ");
INSERT INTO kmh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aŋgek aŋgak, “Tap kun ak yergek aspiyr aŋgak.” Aŋgek aŋgrik, “Bi Gor minim aŋgep Jiysis Nasaret nimb ak, minim aŋg tep giyiŋg, tap mageprek gok giyiŋg gek; Gor nup tep giy, biynimb gok kuyip tep giy gak. ");
INSERT INTO kmh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Kun gek, gosimb chin niŋiy aŋgnuk; nuk bi chinup Yisrel biynimb diy, kond mind-tep giniŋgamb aŋgiy niŋnuk ak pen; biyomb Gor nup tap simboŋgep gok sek, bi minim tuŋgasikep gok sek minim aŋg nan-giy, di Rom gapman biyomb anup ñeyak, nuk amiybi nuk gok kuyip ñek, dam mon kiros bak biyoŋ ñaŋgrimbik ayey kumak. Tap gak kun ak, ñin omiŋal pandikak. ");
INSERT INTO kmh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Miñiy sekemb won ak, biyn tiwin chin bap, am nup komyak kawrumb bindoŋ niŋiy, ap chinup tap yerip yerip gip ak aŋgñey, niŋiy jiwdipun. ");
INSERT INTO kmh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kiyk apay, chip par ak ma mindamb. Enjol omiŋal ak apiy apiyr, ‘Nuk tikjakiy, kim mindip apiyr’ apay. ");
INSERT INTO kmh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kun aŋgey, bi chin gunap kawrumb bindoŋ amiy niŋbay; biyn gok apay rek nep, mindamb aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kiliyowpas kun aŋgek, Jiysis aŋgak, “Nirmiŋay gos tep ma niŋbiyr. Bi Gor minim aŋgep gok minim aŋgyak ak, yenen niŋind aŋgyak aŋgiy kasek ma niŋbiyr. ");
INSERT INTO kmh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pen Gor aŋgak rek, Kiyŋ yomb key yimb ak yiwur yomb diy kumiy, tikjakiy mey, biynimb kuŋaynep diy kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kun aŋgiy, kuyipmiŋay Mosis; bi kiyŋ yomb key yimb ak nup, minim tikak ak sek, bi Gor minim aŋgep gunap, minim nup tikyak ak sek maŋgiysek aŋgñirep gak. ");
INSERT INTO kmh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pen bi omiŋal kun ak, miñmon amerik maŋ kun siŋak amjakiy, Jiysis kuyipmiŋay tawsak ay, amniŋg rek gek, ");
INSERT INTO kmh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","kiykmiŋay nup kilis giy aŋgrik, “Duŋgep day biy aswun. Kisyim winiŋg gisap nen, apey chirmiŋay yip amnun aŋgrik.” Aŋger, kiymiŋay yip amnak. ");
INSERT INTO kmh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Korip am mindiy, tap ñiŋniŋg, nuk biret ak diy, Gor nup tep aŋgiy, tipaŋg kuyipmiŋay ñakniŋ, ");
INSERT INTO kmh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","gosimb kuyipmiŋay ak paŋgyikek, ak Jiysis nep aŋgiy, aŋgrikniŋ, kapkap kurgak. ");
INSERT INTO kmh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kun gek, niŋiy aŋgrik, “Kinjeŋnamb okok apyiŋg, minim gunap aŋgñiyiŋg, Baybol buk tikyak minim kiñiŋ ak aŋgñiyiŋg gamb, mindmaŋgiy chirup ak niŋind yimb limgamb aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kun aŋgiy, won kun ak nep, tip andkind Jerusalem amiy niŋrik: Jiysis binuk onep aŋgip ak sek, buŋgiy kiyk gunap sek ap nan-giy mindeyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Amjakrikniŋ, kuyipmiŋay aŋgyak, “Niŋind yimb apun. Jiysis kumimb ak pen; tip ak tikjakiy, ap Saymon mindamb siŋak miseŋ gamb, niŋimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aŋgey, kiy pen aŋgrik, “Chirmiŋay kunep kinjeŋnamb okok amambur, Jiysis chirup namb pikamb, dand korip chirmiŋay ak amiy, tap ñiŋniŋg giy, nuk biret ak di Gor nup tep aŋgamb, ak Jiysis nep aŋgiy niŋbur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Minim kun ak aŋgrikniŋ, Jiysis mindeyak namb ak miseŋ giy aŋgak, “Nimb mindpim?” ");
INSERT INTO kmh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aŋgek, kiyk chip kawnan aŋgiy ");
INSERT INTO kmh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","pirikeyak, kuyip aŋgak, “Yenen, yip Jiysis aŋgiy ma niŋiy, gos kuŋay niŋsipim? ");
INSERT INTO kmh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñin tomb yip gok niŋim. Yand Jiysis nep. Chip kawnan rek, mumbwak tiŋiy sek ma mindembinip; yand yipul sek, tiŋiy sek mindpiyn ak, yip diniŋim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kun aŋgyiŋg, ñin tomb nuk gok kuyip yomek niŋiy, ");
INSERT INTO kmh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","kiyk miñmiñ giyiŋg, pen gospar ayiŋg, ak Jiysis nep akaŋ aŋgiy, gos kuŋay niŋeyak; kuyip aŋgak, “Tap ñiŋemb nimb gunap mindip akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aŋgek, nup piys daŋgiy ayak ak ñiy, ");
INSERT INTO kmh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","niŋmindyakniŋ ñiŋak. ");
INSERT INTO kmh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pen Jiysis kuyip aŋgak, “Nimb yip mindiy, yip gip ar ak, giniŋgamb aŋgiy nimbip aŋgñiyiŋgipiyn. Mosis low minim aŋgiy tikak rek, bi Gor minim aŋgep aŋgiy tikyak rek, pen Baybol buk Sam ak minim aŋgiy tikyak rek, yip yerer giniŋgamb aŋgiy, maŋgiysek aŋgñiyiŋgipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kun aŋgiy, minim nind tikyak ak niŋrep giyaŋ aŋgiy, gos tep yimb ak kuyip ñiy, ");
INSERT INTO kmh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","aŋgak, “Minim kun ak tikiy aŋgyak, ‘Kiyŋ yomb key yimb ak yiwur yomb diy kumek, komey, minek omiŋal nokom mindiy, tip ak tikjakniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tikjakiy mindeniŋgamb rek, minim nup ak miñmon Jerusalem kiñiŋ giy aŋgiy, aŋg dand amiy, biynimb miñmon okok maŋgiysek aŋgñey amnakniŋ, biynimb tap siy tap timey giniŋgambay gok, yenen kun gipun aŋgiy, nup chiŋgyakniŋ, gach kuyip ak wiykyokniŋgamb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pen yip gak kun ak, windin nimb key niŋbim. ");
INSERT INTO kmh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pen Bapiy minim aŋgayak rek, nimbip giniŋgayn ak mey; dawin yomb Jerusalem biy mindiy, kond mindenimimb. Gor Kawnan ak, ap nimbip bak ayek, miñmon okok keykey amnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kun aŋgiy, kuyip poŋind Beteniy amiy, Gor kuyip kond mindeŋ aŋgiy, ñin dand araniy, ");
INSERT INTO kmh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gor nup aŋgniŋakniŋ, nup dand aranjak semb biyoŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kun gek, kuyip tep gakniŋ, yimb nup ak dand aranyiŋg, andkind Jerusalem amniyak. ");
INSERT INTO kmh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amiy, minek minek, Gor aŋgniŋep korip miŋgan ak amiy, Gor nup yimb ak dand aranyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Miñmon ma alwol gayak ñin ak, Minim Maŋgiy Won aŋgniŋg gispiyn ak mindek. Minim Maŋgiy Won kun ak, nuk kunep Gor ak mey, Gor yip mindek. ");
INSERT INTO kmh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Miñmon kindik alwol gayak; nind yimb yimb nuk Gor yip mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nuk nep, tap okok maŋgiysek gayak. Tap bap key ma ayak; nuk gayak gok nep mindip. ");
INSERT INTO kmh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nuk kim mindep junj ak mey, kim mindep melik nuk ak, biynimb gok kuyip niŋimb. ");
INSERT INTO kmh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Melik nuk kun ak, kisyim wip namb okok apek, tuŋgsuŋg mer niŋiy kirpay. ");
INSERT INTO kmh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Gor pen biynimb gok maŋgiysek Minim Maŋgiy Won kun anup gosimb niŋniŋgiy aŋgiy, Jon bi ñiŋg pikñemb anup aŋgek, melik minim ak aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon nuk melik kun ak mer; nuk yikop biynimb gok kuyip minim kun ak aŋgñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Melik yimb ak mey, Minim Maŋgiy Won kun ak. Nuk man ar biy apek melik nuk ak, biynimb okok kuyip maŋgiysek amnak. ");
INSERT INTO kmh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nuk nep miñmon alwol gay, biynimb gok gay gak ak pen; ap mindek nup ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Miñmon yand key ak amniyn aŋgiy, awak ak pen; nup ma diyak. ");
INSERT INTO kmh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Biynimb Biyomb chin aŋgiy diyak gok nep kuyip gek, Gor ñapan nuk mindpay. ");
INSERT INTO kmh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ñapan nuk mindpay kun ak, bi beryoŋgon gok di giy, ñapan tikey mindpay rek ma mindpay. Pen biynimb gunap mumbwak tikjakek, di giy ñapan tikey mindpay rek mer; Gor nuk key gek ñapan nuk mindpay. ");
INSERT INTO kmh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pen Minim Maŋgiy Won kun ak, biyimb ay apiy, chin yip kin mindyiŋgip. Kun ak nup niŋbun: nuk bi simb niŋep tep yimb kun ak key. Nuk Gor Ñinuk nokom yimb ak mey; Gor nuk key Biyomb teprep yimb mindip rek ak mindip. ");
INSERT INTO kmh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pen Bi kun ak apek niŋiy, Jon biynimb gok kuyip aŋgak, “Bi wip biy nep mey, nimbip nind aŋgnik, ‘Bi kisen winiŋgamb ak, nind yimb yimb mindyiŋgip ak mey, yand rek mer; nuk Biyomb yimb mindip aŋgnik’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bi kun ak, chinup maŋgiysek simb niŋiy kumiy tikjakak rek, biynimb gok kuyip bilesiyŋ keykey ñimb. ");
INSERT INTO kmh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Low minim ar ak, Gor Mosis nup ñek chinup aŋgñak ak pen, Gor biynimb simb niŋiy dip minim yipul yimb ak, Jiysis Krays owak rek miseŋ niŋbun. ");
INSERT INTO kmh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Biynimb bap Gor nup ma niŋyak. Ñi tep nuk ak nep, nuk yip mindiy miseŋ apek niŋiy mey; Nop bi yerip rek mindip ak niŋbun. ");
INSERT INTO kmh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Biyomb Jerusalem kond mindyiŋgipay gok, bi Gor nup simboŋgep gunap, bi Gor aŋgniŋep korip kond mindyiŋgipay gunap aŋgyokiy aŋgyak, “Nimb Jon mindip amiy, nand bi an aŋgiy aŋgniŋnimimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kun giy aŋgyokey, Jon mindek ak amjakiy, nup aŋgniŋiy aŋgyak, “Nand bi an?” Aŋgeyak, aŋg weygiy mer; kuyip miseŋ aŋgiy aŋgak, “Yand Kiyŋ yomb key yimb ak mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kun aŋgek aŋgyak, “Kun apan ak, nand an? Nand Yilayja akaŋ?” Aŋgey aŋgak, “Yand Yilayja mer aŋgak.” Kun aŋgek aŋgyak, “Nand bi Gor minim aŋgep per kond mindpun ak akaŋ?” Aŋgey, “Mer” aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kun aŋgek, bi kun gok nup aŋgyak, “Kun ak nand an? Pen yand bi yerip aŋgiy aŋgenimin; chin am biyomb chinup aŋgyokpay gok kuyip aŋgñinjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aŋgey, Jon kuyip aŋgak, “Bi Gor minim aŋgep Asaya kisen giniŋgamb aŋgak rek nep gispiyn. Nuk aŋgak: “Bi bap biynimb kuŋay ma mindpay namb okok mindiy, meŋg miŋgan dand araniy aŋgniŋgamb: Per biyomb asaw aŋgiy, kinjeŋ pindrep giy kond mindpay rek ak ginimimb aŋgniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pen bi Jon nup aŋgniŋniŋg wiyak kun gok, bi Peresiy gunap sek, aŋgyokey wiyak ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kiyk Jon nup aŋgyak, “Nand apan: yand Kiyŋ yomb key yimb ak mer, Yilayja mer, bi Gor minim aŋgep kond mindpun ak mer apan ak; yenen pen biynimb gok kuyip ñiŋg pikñispan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aŋgeyak aŋgak, “Yand kuyip yikop ñiŋg pikñimbiyn. Pen bi bap namb nimbip biy mindip. Nup bi yerip rek aŋgiy ma niŋbim ak pen, ");
INSERT INTO kmh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","nuk yand rek mer; nuk Biyomb yimb. Nup niŋen yip nambiŋ gip. Tomb tirup nup ak tuŋgasikyiŋg, tap nup gok marik ginim rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gak kun ak, Jon biynimb gok kuyip ñiŋg pikñiyiŋgip miñmon Beteniy, Joden ñiŋg gol pis tawakdoŋ ken. ");
INSERT INTO kmh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Minek Jiysis Jon ker apek, nup ñiŋg pikñiy, biynimb gok kuyip aŋgak, “Niŋim! Bi biy mey Gor Siypsiyp Ñiluk nuk chinup aŋgip ak. Nuk mey, Gor nup simboŋgiy, biynimb mankumb biy kuyip gach ak wiykyokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Bi kun biy mey nind aŋgnik, ‘Nuk Biyomb yimb, yand bi sikoy, nuk nind yimb yimb mindek, yip kisen tikpay aŋgnik.’ ");
INSERT INTO kmh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nuk mindip aŋgiy per niŋyiŋgipiyn ak pen, an rek mindip aŋgiy ma niŋnik; miñiy mey niŋrep gispiyn. Nuk Kiyŋ yomb key yimb kond mindpun anep mindip ak; niŋiy dim aŋgiy, nimbip Yisrel biynimb ñiŋg pikñimbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Pen Jon Jiysis nup minim ar ak aŋgiy aŋgak, “Bi kun biy an aŋgiy ma niŋbinip; Bi yip aŋgek biynimb ñiŋg pikñimbiyn ak aŋgak, ‘Nand niŋniŋgamban; Kawnan yand ak bi bap ker apiy, yip mindeniŋgamb. Bi kun ak, biynimb gok kuyip ñiŋg ma pikñiniŋgamb; nuk gek Kawnan yip ak diniŋgambay aŋgak.’ Aŋgak kun ak mey, miñiy Gor Kawnan ak, yakir kochir rek nup ker apamb, ");
INSERT INTO kmh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","niŋrep giy apiyn: ‘Bi biy Gor Ñinuk ak nep apiyn aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Minek pen, Jon binuk omiŋal ak yip, tip ak ap ñiŋg pikñiyiŋgip siŋak mindyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jiysis apiy pandikek, Jon niŋiy aŋgak, “Bi biy, Gor Siypsiyp Ñiluk nuk chinup yokek owak anep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kun aŋgek, Jon binuk omiŋal ak, minim kun ak niŋiy, Jon nup kirgiy, Jiysis amek miŋgan ak kisen amnirik. ");
INSERT INTO kmh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pen Jiysis andikiy kuyipmiŋay niŋiy aŋgak, “Yenen aswiyr?” Aŋgek aŋgrik, “Rabay! Nand kinban akay?” ");
INSERT INTO kmh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pen kun giy aŋgniŋer, Jiysis aŋgak, “Kun ak yand yip amiy niŋniŋgayr aŋgak.” Aŋgek, ñin kun ak duŋgep won ak amiy, nuk yip mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon binuk omiŋal kun ak, bi bap yimb nuk Enjriw. Enjriw numam nuk mey, Saymon Piyta. ");
INSERT INTO kmh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Enjriw won kun anep, am numam Saymon nup piyow niŋiy aŋgak, “Bi Kiyŋ winiŋgamb aŋgiy per kond mindpun ak, miñiy niŋbun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Enjriw kun aŋgiy, numam Saymon nup poŋind Jiysis mindek ak amek, Jiysis Saymon nup niŋiy aŋgak, “Jon ñinuk Saymon. Nip Siypas aŋgniŋgambun aŋgak.” Yimb Siypas aŋgak kun ak, Griyk minim aŋgiy mey, Piyta apay. ");
INSERT INTO kmh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Minek Jiysis Galiyliy propens amniŋg, am Piyliyp nup niŋiy aŋgak, “Yand yip amnur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piyliyp, Enjriw, Piyta miñmon kiykyakam mey Betsayda nep. ");
INSERT INTO kmh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pen Piyliyp am Nataniyel nup niŋiy aŋgak, “Chin bi siŋok, Mosis sek, bi Gor minim aŋgep gunap sek Baybol buk tikiy aŋgyak anup, miñiy niŋbun. Nuk mey Josep ñinuk; miñmon Nasaret nimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Piyliyp kun aŋgek, Nataniyel aŋgak, “Bi tep bap miñmon timey kun ak nimb winiŋgamb?” Aŋgek, Piyliyp aŋgak, “Kun apan ak, apey am niŋur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kun aŋgiy, maŋmaŋ girikniŋ, Jiysis Nataniyel nup niŋiy aŋgak, “Bi kun ak, bi Yisrel yipund giy ak mey, nuk yesek ar ak ma aŋgniŋgamb; yipund giniŋgamb ar ak nep aŋgniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kun aŋgek, Nataniyel aŋgak, “Yip yergiy niŋban?” Aŋgek, Jiysis aŋgak, “Enjriw nip kisen poŋdiniŋg nimb; nip niŋbiyn bisiŋg mindamban kiyaw kiñiŋ siŋak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kun aŋgek, Nataniyel aŋgak, “Tiysa. Nip niŋbiyn! Nand Gor Ñinuk. Yisrel biynimb Kiyŋ yomb chin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kun aŋgek, Jiysis aŋgak, “Nip yikop kiyaw kiñiŋ siŋak niŋbiyn aŋgen, yip Gor Ñinuk yimb aŋgiy niŋban? Kisen tap key yimb gunap gen niŋniŋgamban. ");
INSERT INTO kmh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nimbip maŋgiysek niŋind aspiyn: enjol gok bi bap Ñinuk nup, niŋniŋg amiy apiy geniŋgambay niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Ñin omiŋal mindiy, biber bap diniŋg ger, biynimb suk aŋgey amiy, tap ñiŋyak miñmon Keyna-Galiyliy propens namb okok. Ñin kun ak, Jiysis sek, binuk gok sek kuyip kunep suk aŋgeyak amniyak. Pen Jiysis nonim am korip kun ak nind mindek ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ñiŋg wayn ak ñimbdeyak, nuk apiy Jiysis nup aŋgak, “Wayn ak ñimbdipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kun aŋgek aŋgak, “Yip kun gan kun gan ma aŋgnimin. Ñin yand ak ma wip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aŋgek, nonim am bi woŋg giñemb gok kuyip aŋgak, “Jiysis minim bap aŋgonimuŋ; aŋgnimuŋ rek nep ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pen Jiwda biynimb kamb diy giyiŋgipay tiyn yomb yimb onep kaŋgol ak dayey mindek. Tiyn kun gok, miñ ar kiyk ak giyiŋgipay rek, suŋ-tep mindon aŋgiy, ñiŋg mal dap soŋgiy, ñin tomb ñiŋg ay giluŋg yokyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jiysis pen, bi woŋg giñemb gok kuyip aŋgak, “Kamb tiyn guniy ñiŋg mal dand apiy, soŋgem arachaknimuŋ aŋgak.” Aŋgek, aŋgak rek geyak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Miñiy ñiŋg mal dap aypim ak gunap paŋg dand amiy, bi tap ñimbsipun biy kond mindip anup ñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aŋgek, ñiŋg yimb kun ak paŋg dam biyomb anup ñeyak, nuk ñimbiy niŋak; ñiŋg wayn tep ak mindek. Pen nuk ñiŋg wayn kun ak akay nimb aŋgiy ma niŋak; bi woŋg giñemb gok kiyk nep niŋyak. Pen nuk ma niŋak rek mey, bi biyn diniŋg gek kun anup suk aŋgek apek aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Pernep, ñiŋg wayn tep ak dap ñey ñimbdey mey, ñiŋg wayn timey ak kisen ñey ñimbay. Pen nand ñiŋg wayn tep ak day mindiy, miñiy nep dap ñispan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Pen Jiysis ñin kun ak miñmon Keyna mindiy, tap mageprek ak kiñiŋ giy gek, nuk bi key yimb mindek ak miseŋ niŋep rek ayek, binuk gok nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pen tap ñimbdiy, Jiysis nuk; nonim, numam, binuk gok kuyip poŋind miñmon Kapaniyam amiy, yep ñin kaw bap kun ak mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jiwda ñin yomb kiyk Pasopa apay ak maŋ gakniŋ, Jiysis Jerusalem amiy niŋak; ");
INSERT INTO kmh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","biynimb gok, Gor aŋgniŋep korip miŋgan ak; kaw, siypsiyp, yakir tap gok dap maker ayiŋg, maniy seniys giyiŋg geyak. ");
INSERT INTO kmh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Niŋiy miñ bap diy, kaw, siypsiyp gok yuk mis yokiy, maniy dap penpen seniys geyak boŋg band gok maniy sek tuŋgandikiy, ");
INSERT INTO kmh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","biynimb yakir dap maker geyak gok kuyip aŋgak, “Tap kun gok dand amnimimb. Bapiy korip nup ak gem maker korip rek ma aynimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nuk kun gek, binuk gok gos kiyk amnak; Baybol buk minim tikyak ar ak. Minim kun ak tikiy aŋgyak, “Aŋgniŋep korip nand ak gos nokom niŋbiyn rek, yip timey giniŋgiy rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pen Jiwda biyomb gunap apiy, Jiysis nup aŋgyak, “Nip an aŋgamb ap kun girapan? Gor nep aŋgek ap girapiyn aŋgiy, tap mageprek bap gey niŋiy, niŋind apan aŋgun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kun aŋgey, Jiysis kuyip pen aŋgak, “Lotiw korip biy timbrikem, ñin omiŋal nokom mindiy tip ak giniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kun aŋgek aŋgyak, “Korip kun biy, simiy ñin omiŋal jiwek, gi diyak ak pen; nand ñin omiŋal nokom nep gaynimin rek mindip?” ");
INSERT INTO kmh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pen Jiysis korip minim aŋgak kun ak, nuk key aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kun ak mey, kisen nup ñaŋgbirik ayey kumiy, ñin omiŋal nokom mindiy tikjakek, binuk gok Baybol buk minim nup aŋgiy tikyak ak sek, Jiysis minim aŋgak kun ak sek gos niŋiy, niŋind aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jiysis, Jiwda ñin yomb kiyk Pasopa apay kun ak Jerusalem mindiy, tap mageprek gunap gakniŋ, biynimb gok niŋiy, ak Kiyŋ yomb key yimb kond mindyiŋgipun ak nep aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Pen Jiysis biynimb maŋgiysek gos namb kuyip biyaŋ key niŋrep gip rek, biynimb kun gok gosimb kiyk ar akay amnak ak, niŋrep gak ak mey; nuk kuyip biynimb yand yipund giy aŋgiy ma niŋak. ");
INSERT INTO kmh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bi Peresiy bap Jiwda kanjsol mindyiŋgip ak; yimb nuk Niykodiymas. ");
INSERT INTO kmh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nuk kisyimken am Jiysis nup niŋiy aŋgak, “Tiysa. Chin niŋbun: tap mageprek gipan gok nak key ma gipnap; Gor nep nip yokek apiy mey, tap mageprek kun gok giyiŋg, chinup minim aŋgñiyiŋg gipan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aŋgek, Jiysis aŋgak, “Yand nip niŋind yimb aspiyn; biynimb Gor gek key kisenimb aypay gok nep, nuk diy kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kun aŋgek, Niykodiymas aŋgak, “Yergiy biynimb tikayey yomb gipay gok, nonim koŋgiy namb okok tip ak amey, tikayey, biynimb key kisenimb ayniŋgambay?” ");
INSERT INTO kmh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aŋgek, Jiysis aŋgak, “Nip niŋind yimb aspiyn. Biynimb ñiŋg ak sek, Gor Kawnan ak sek gek, Gor biynimb nuk mindpay gok nep, biynimb yand aŋgiy diy kond mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Biynimb tikpay rek tikey mindpay ak pen; Gor Kawnan ak gek nep mey, Gor biynimb nuk mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kun ak minim kim kisenimb aŋgambiyn ak niŋiy, gos okok ma niŋnimin. ");
INSERT INTO kmh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yiŋgen ak damb niŋbim ak pen; wip okok sek, amimb okok sek ma niŋbim. Kun ak rek mey, biynimb Gor Kawnan bak ayek, kim kisenimb aypay gok aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kun aŋgek, Niykodiymas aŋgak, “Nand aspan ar kun ak, yergiy giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aŋgek, Jiysis aŋgak, “Nand Yisrel biynimb lotiw tiysa yomb kiyk ak pen, ma niŋban? ");
INSERT INTO kmh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nip niŋind yimb aspiyn: chin windin key niŋiy, niŋrep giy nep nimbip aŋgñimbun ak pen; minim chinup ak ma dipim. ");
INSERT INTO kmh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yand nip man ar biy gip rek aŋgen, ma dipan ak, yergiy Gor miñmon biyoŋ gip rek aŋgen diniŋgamban? ");
INSERT INTO kmh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pen biynimb bap Gor miñmon biyoŋ ma taŋg niŋbay; Bi bap Ñinuk nep kun biyoŋ nimb mindiy owak. ");
INSERT INTO kmh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pen wosrey siyŋ timey gok, Yisrel biynimb kuyip siwey kumyakniŋ, Mosis tap siyŋ rek bap mon bak siŋbiyoŋ gayek, biynimb siyŋ kun ak niŋyak gok, kuyip suŋ ayak. Kun ak rek nep, Bi bap Ñinuk nup mon kiros bak biyoŋ ñaŋgbirik ayey, ");
INSERT INTO kmh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","biynimb nup gosimb niŋniŋgambay gok, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gor biynimb mankumb biy maŋgiysek wasemb ay, Ñinuk nokom yimb ak kuyip nen aŋgiy yokek owak ak mey; biynimb nup gosimb niŋniŋgambay gok, kumiy ma kurginiŋgambay; nuk yip perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yenen: Gor Ñinuk nup yokak kun ak, biynimb gok kuyip, kor ginimuŋ aŋgiy ma yokak; yip ker dinimuŋ aŋgiy yokak. ");
INSERT INTO kmh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Biynimb an Ñinuk nup gosimb niŋbay gok, kor ma niŋniŋgambay. Pen biynimb nup gosimb ma niŋiy kirpay gok, minim yomb yimb ak mindip. ");
INSERT INTO kmh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Minim yomb yimb diniŋgambay junj kun ak, kun giy mindip: Melik tep ak man ar biy wip ak pen; biynimb gok Melik kun ak ker amnun aŋgey, kuyip tep ma gip. Kiyk timey gi mindpay rek, kisyim wip okok nep niŋey tep gip. ");
INSERT INTO kmh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bi meliksek ak nup niŋey tep ma gek, timey gipun ak miseŋ niŋniŋgambay aŋgiy, nup ker ma opay. ");
INSERT INTO kmh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pen biynimb yipund gip ar ak gipay gok, Gor aŋgip rek gispun ak, miseŋ niŋep rek ayaŋ aŋgiy, Melik mindip kiñiŋ siŋak opay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kisen Jiysis, binuk gok yip am Jiwdiya propens namb okok mindiy, biynimb gok kuyip ñiŋg pikñiyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pen ñin namb kun siŋak, Jon bi ñiŋg pikñemb ak kunep, miñmon Yinon yep miñmon Salyim ñiŋg kuŋay mindek siŋak mindiy; biynimb gok wiyakniŋ, kuyip ñiŋg pikñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jon nind kun giyiŋgip; kisen mey nup kalambis ayak. ");
INSERT INTO kmh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pen Jiwda bi bap apiy, Jiwda miñ ar kiyk ñiŋg pikyiŋgipay minim ar ak aŋgiy, Jon binuk gunap yip penpen aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Penpen aŋgiy, Jon binuk gok apiy nup aŋgyak, “Tiysa. Bi siŋok Joden ñiŋg gol kind bindoŋ mindek, nup biyomb aŋgenak ak, miñiy ap ñiŋg pikñakniŋ, biynimb maŋgiysek nup ker amjipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kun aŋgeyak, Jon aŋgak, “Gor gos nuk key niŋimb rek, chinup woŋg ar keykey aŋgayip. ");
INSERT INTO kmh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nimb key niŋbim; nimbip aŋgnik, ‘Yand Kiyŋ yomb key yimb ak mer; yikop kinjeŋ nup ak, Gor aŋgek pindsipiyn aŋgnik.’ ");
INSERT INTO kmh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bi gok biyn dipay ñin ak, buŋgiy kiyk yimb gok, ‘Biyn kun ak chin rek ma dipun aŋgiy’ gos ak ma niŋbay. ‘Buŋgiy chin ak, biyn nuk ak pisnep dip aŋgiy,’ miñmiñ yimb gipay. Yand mey kun ak rek. Nuk biynimb gok kuyip kun giy disap ak, yip tep gip. ");
INSERT INTO kmh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yimb nup aranakniŋ, yimb yip apyowniŋgamb ak, tep yimb. ");
INSERT INTO kmh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Bi semb biyoŋ nimb wip ak, Biyomb yimb. Biynimb man ar biy nimb gok, semb biyoŋ nimb apiy rek, minim yipul yimb nuk niŋiy aŋgip rek aŋgniŋgiy. Kiyk lum ar biy nimb ak mey; lum ar biy minim ak aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nuk Nop yip mindiy wak rek, minim yipul yimb ak aŋgip ak pen; minim nup ak ma dipay. ");
INSERT INTO kmh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pen biynimb minim nup dipay gok, Gor minim ak niŋind nep aŋgip aŋgiy dipay. ");
INSERT INTO kmh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gor bi yokak kun ak nup, Kawnan nuk ak yokek ap yip nep mindip ak mey; minim aŋgñimb ak, Gor minim yipund giy ak aŋgñimb. ");
INSERT INTO kmh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nop Ñinuk nup wasemb ay, tap okok maŋgiysek kond mindonimuŋ aŋgiy, di ñin ar nup ak ayip. ");
INSERT INTO kmh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Biynimb an Ñinuk nup gosimb niŋniŋgambay gok gek, perper mindeniŋgambay; pen biynimb nup kirginiŋgambay gok kuyip gek, miker diyiŋg nep mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pen bi Peresiy gok niŋyak; biynimb kuŋaynep, Jiysis ker mindon aŋgiy, apey kuyip ñiŋg pikñak; pen Jon ker, biynimb gunap nep apey kuyip ñiŋg pikñak. ");
INSERT INTO kmh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pen Jiysis nuk key kuyip ñiŋg ma pikñak; binuk gok nep, biynimb gok kuyip ñiŋg pikñiyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Pen Peresiy kay minim kun ak rek aŋgeyak niŋiy, Jiysis Jiwdiya kirgiy, andkind Galiyliy amniŋg, Samariya biynimb mindeyak namb ak amiy, ");
INSERT INTO kmh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","miñmon Siyka amjakak. Miñmon Siyka maŋ kun siŋak mey, Jekop nind ñinuk Josep nup mankumb bap aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pen Jekop ñiŋg kaw dak ak mindek ak mey, Jiysis apek apek, pumbnamb yomb yoŋ won ak yiruk gek, am ñiŋg kawrumb gol kun ak bisgak. ");
INSERT INTO kmh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Pen binuk gok, keñmaŋgiy tawniŋg miñmon Siyka maŋ kun ak amniyakniŋ, nuk nep bisiŋg mindek. Kun giy bisiŋg mindakniŋ, biyn Samariya nimb bap ñiŋg malniŋg apek, Jiysis aŋgak, “Yip ñiŋg mal ñey ñiŋiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aŋgek, biyn kun ak aŋgak, “Nimb Jiwda biynimb, chinup Samariya biynimb niŋiy asikrep gipim ak pen, yergiy yip ñiŋg mal ñey ñiŋiyn aŋgiy aspan?” ");
INSERT INTO kmh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kun aŋgek, Jiysis aŋgak, “Nand Gor Bi yokek miñiy ap minim asap biy nup niŋbinap rek, nup ñiŋg ñimbiy perper mindeniŋgambay ak aŋgniŋembnap, nip ñimbikop aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aŋgek aŋgak, “Bi. Ñiŋg malep tiyn nand bap ma mindiy, ñiŋg ak kunep yiy akyaŋ mindip. Kun ak, ñiŋg ñimbiy perper mindeniŋgambay kun ak, akay nimb diniŋgamban? ");
INSERT INTO kmh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Basind yes chin Jekop tikayep biynimb nuk gok sek, kanj siypsiyp nuk gok sek ñimbyiŋgipay ak mey; chinup aŋgek ñimbun. Pen aspan kun ak, yand biyomb Jekop bi sikoy aŋgiy aspan?” ");
INSERT INTO kmh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aŋgek, Jiysis aŋgak, “Biynimb ñiŋg biy ñiŋniŋgambay gok, tip ak ñiŋg nen giniŋgamb; ");
INSERT INTO kmh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pen biynimb ñiŋg yand ñen ñiŋniŋgambay gok, tip ak ñiŋg nen ma giniŋgamb. Pen ñiŋg yand ñen ñimb namb kiyk biyaŋ ayniŋgambay kun ak, ñiŋg kilam rek jiwyiŋg, kuyip gek perper mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kun aŋgek, biyn kun ak aŋgak, “Yip ñiŋg kun ak ñey ñimben, kisen yip ñiŋg nen ma ginimuŋ. Pen ap ñiŋg biy ma malnim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aŋgek, Jiysis aŋgak, “Am naŋgumiy nup poŋind owan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aŋgek aŋgak, “Yand bi sek mer aŋgak.” Aŋgek, Jiysis aŋgak, “Minim kun ak niŋind aspan. ");
INSERT INTO kmh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bi onep mamind ak dinak ak pen; bi miñiy yip mindpiyr ak, naŋgumiy mer. Kun ak niŋind aspan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kun aŋgek, biyn ak aŋgak, “Yand niŋbiyn; nand bi Gor minim aŋgep bap. ");
INSERT INTO kmh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Apis basind chin wosrey gok, dum biy Gor nup lotiw giyiŋgipay rek, chin kunep lotiw gi mindpun ak pen; nimb Jiwda kay, Jerusalem nep lotiw giniŋgiy apim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aŋgek aŋgak, “Nip niŋind yimb aspiyn. Kisen dum kun biy akaŋ, Jerusalem nep lotiw ma giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nimb Samariya biynimb, bi aŋgniŋbim ak nup ma niŋbim. Bi biynimb tuŋgasik dep kun ak Jiwda nimb ak mey, chin Jiwda gok niŋbun. ");
INSERT INTO kmh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ñin per kond mindyiŋgipun ak miñiy wip. Biynimb Gor nup lotiw niŋind yimb giniŋgambay gok, Kawnan nuk ak gos ñakniŋ giniŋgambay ak mey; kuyip niŋek tep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nuk Kawnan ak mey; biynimb nup lotiw giniŋgambay gok, Kawnan nuk ak yip mindiy, gos tep ñakniŋ lotiw niŋind yimb ar ak giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jiysis kun aŋgek, biyn ak aŋgak, “Yand niŋbiyn; kisen Kiyŋ yomb key yimb “Krays” apay ak apiy, chinup aŋgñirep giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aŋgek, Jiysis aŋgak, “Bi kun ak mey yand. Nand yip minim aspur biy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kun aŋgakniŋ, binuk gok kiyk apchakiy, Jiysis biyn ak yip minim aŋg minderik niŋiy, jiwdiyak. Pen kiyk bap tikjakiy, biyn anup minim nand yerip mindip aŋgiy, ma aŋgniŋyak. Jiysis nup kunep, yenen biyn kun biy yip minim aspiyr aŋgiy ma aŋgniŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pen biyn ak, ñiŋg tiyn ak kirgiy, tip ak andkind dawin amiy, biynimb mindeyak kun okok kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Apiy, tap okok maŋgiysek gipiyn rek aŋgñimb bi ak niŋim! Nuk Kiyŋ yomb key yimb ak rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kun aŋgek, biynimb kun gok Jiysis nup niŋniŋg dawin ak kirgiy, saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma wiyak won ak Jiysis binuk gok, nup nembnemb giy aŋgyak, “Tiysa. Tap ñiŋan aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aŋgey, nuk aŋgak, “Tap ñiŋemb yand per ñimbiyn ak nimb ma niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kun aŋgek, binuk gok kiyk keynep aŋgniŋ aŋgniŋ giy aŋgyak, “Biynimb gunap nup tap keñmaŋgiy dap ñey ñimbamb?” ");
INSERT INTO kmh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pen Jiysis kuyip aŋgak, “Nimbip keñmaŋgiy nen gip; yip pen tap kun gok nen ma gip. Bapiy minim aŋgak anep gos ayamb, woŋg aŋgip kun ak gi jiwiyn aŋgiy niŋbiyn. ");
INSERT INTO kmh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Minim bap apun, miñiy wiyt maŋgiy yoksipun ak takin omiŋal omiŋal mindiy, maŋgiy pikgek am tik dand winiŋgambun apun ak pen; miñiy kun ma aŋgjun. Windin nimb ak niŋdand pandikiy niŋim! Wiyt woŋg gok pikgiy, tik dand owep rek mindip. ");
INSERT INTO kmh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kun ak mey per gep rek, biynimb man piŋiypaŋgiy wiyt maŋgiy yokpay gok sek, tik dand opay gok sek tap ñiŋemb dipay ak niŋiy miñmiñ gipay. ");
INSERT INTO kmh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pen minim bap: bi bap tap yiŋ yokniŋgamb; bi bap tap ñiŋemb kun ak diniŋgamb apay. Minim kun ak niŋind apay. ");
INSERT INTO kmh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nimbip aŋgyoken, am wiyt maŋgiy tik dand opim. Pen wiyt woŋg kun ak nimbik ma gipik; biynimb gunap kilis kiyk ak gey jakek, nimb yikop tik dand opim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Biyn Samariya nimb ak, am biynimb nuk gok kuyip aŋgak, “Bi kun ak tap yeripyerip gipiyn gok maŋgiysek aŋgñimb aŋgak.” Kun aŋgek kiyk, ak Biyomb chinup biynimb pisnep kumjun rek ayip gok, kim diniŋgamb aŋgiy; nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pen Samariya biynimb Jiysis mindek ak apiy, nup aŋgyak, “Ñin gunap chin yip mindey aŋgey,” am ñin omiŋal kiy yip mindyiŋg, ");
INSERT INTO kmh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","minim aŋgñek, biynimb tapin gunap sek nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pen biyn kun anup aŋgyak, “Miñiy minim nak anep aŋgey ma niŋbun; minim nuk ak key aŋgek niŋbun: nuk nep mey; bi chinup biynimb miñmon keykey di Nop yip jimñiy ayniŋgamb ak niŋiy, nup gosimb niŋbun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jiysis ñin omiŋal Samariya miñmon sikoy kun ak mindiy, minek ak kuyip kirgiy, Galiyliy propens amnak. ");
INSERT INTO kmh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nind minim bap aŋgiy aŋgak, “Bi Gor minim aŋgep gok, miñmon kiyk key ak mindiy aŋgey, kuyip ma dipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pen Pasopa ñin ak, Galiyliy biynimb gunap am Jerusalem mindeyak, Jiysis tap mageprek gok gek niŋyak ak mey, Galiyliy apchakek niŋiy, nup miñmiñ giyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pen Jiysis Galiyliy amiy, miñmon sikoy Keyna amnak. Miñmon kun ak mey, nind ñiŋg yimb ak gek wayn ayak. Pen biyomb miñmon Kapaniyam nimb bap, ñinuk nup tap gek, ");
INSERT INTO kmh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","minim bap niŋak; Jiysis Jiwdiya kirgiy, ap Galiyliy mindek. Kun ak niŋiy mey, mindek ak apiy, nembnemb giyiŋg aŋgak, “Ñiyand ak tap giy kumniŋg gisap. Nand kasek amiy, nup gey suŋ ayaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kun aŋgek, Jiysis aŋgak, “Yip yikop ma gosimb niŋniŋgambim; tap mageprek gunap gen niŋiy nep, yip gosimb niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pen biyomb kun ak aŋgak, “Biyomb! Apey amnur! Mer ak; ñiyand ak kumniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aŋgek, Jiysis aŋgak, “Amnoŋ! Ñinak mindeniŋgamb aŋgak.” Kun aŋgek, niŋind aŋgip aŋgiy saŋdak. ");
INSERT INTO kmh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kinjeŋnamb okok amnakniŋ, bi nup woŋg giyiŋgipay gunap ap, nup namb pikiy aŋgyak, “Ñinak ak ma kumniŋgamb; mindeniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kun aŋgey, won akay rek suŋ ayip aŋgiy, kuyip aŋgniŋek aŋgyak, “Toyrik pumb kuyim gak won ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kun aŋgey, nuk niŋak: ñinak mindeniŋgamb aŋgak won anep suŋ ayak ak mey, biynimb nuk gok yip, Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pen Jiysis nind Keyna apiy, ñiŋg ak gek wayn ayak; kisen pen am miñmon Jiwdiya mindiy apiy, biyomb ak ñinuk nup gek suŋ ayak. Kun gek nup bi yerip rek ak miseŋ yimb niŋniŋgiy rek ayak. ");
INSERT INTO kmh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kisen pen, Jiwda lotiw ñin yomb bap apek, Jiysis Jerusalem amnak. ");
INSERT INTO kmh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem kinjeŋram kanj siypsiyp dand amiy apiy giyiŋgipay gol siŋak; ñiŋg maŋgiy chemb won bap mindek. Ñiŋg maŋgiy chemb won kun ak Hiybriw minim aŋgiy, Betsayda aŋgyiŋgipay. Pen ñiŋg gol kun siŋak, korip sikoy band onep mamind ak mindek ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","biynimb tap gak gunap, windin koy gak gunap, ñin tomb kalaw gak gunap ap, korip band kun gok mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yenen: Gor enjol bap gip rek, apiy am ñiŋg maŋgiy chemb biyaŋ kaskas gakniŋ, nind amiy maŋgiysek tawon amek, chinup suŋ ayniŋgamb aŋgiy ap mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pen bi tap gek pernep kum mindek, simiy yin ñin jiwiy, andikiy anjip piskind ak amnak bap mindek. ");
INSERT INTO kmh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jiysis bi kun ak per kum mindyiŋgip rek, nup aŋgniŋiy aŋgak, “Nip suŋ aynimuŋ aŋgiy niŋban?” ");
INSERT INTO kmh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aŋgek, bi tap gak kun ak aŋgak, “Biyomb! Ñiŋg ak kaskas gakniŋ, biynimb yip diy, ñiŋg maŋgiy chemb namb biyaŋ ayniŋgiy bap ma mindpay. Ñiŋg namb biyaŋ nind amniyn aŋgen; biynimb gunap kasek nind nep ambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kun aŋgek, Jiysis aŋgak, “Tikjakiy, minj nak ak winiŋg dand saŋdan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aŋgek, won kun anep nup suŋ ayakniŋ, minj nuk ak winiŋg dand amnak. ");
INSERT INTO kmh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pen Jiysis bi gek suŋ ayak ñin kun ak, Jiwda lotiw ñin ak mey, biyomb kiyk gok, bi kun ak nup aŋgyak, “Ñin biy lotiw ñin ak, yenen minj band ak dand taspan?” ");
INSERT INTO kmh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aŋgey aŋgak, “Bi yip gek suŋ ayip ak aŋgip, ‘Tikjakiy minj band nak ak winiŋg dand amnoŋ aŋgamb,’ dand taspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aŋgek aŋgyak, “Bi nip aŋgek, minj band winiŋg dand taspan kun ak mey akay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pen Jiysis biynimb kuŋay mindeyak namb kun okok kapkap amnak rek, bi yip gek suŋ ayip mey biy aŋgiy, aŋgnimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kisen pen, Jiysis bi kun anup, Gor aŋgniŋep korip miŋgan ak niŋiy aŋgak, “Niŋan! Nip suŋ ayip. Kun ak tap siy tap timey gipan ak kirginimin. Mer ak, nip tap yomb yimb ginimuŋ rek ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pen bi kun ak nuk andkind amiy, Jiwda biyomb gok kuyip aŋgak, “Jiysis nep yip gamb suŋ ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kun aŋgek niŋiy, lotiw ñin ak gek suŋ ayak aŋgiy, Jiysis nup miluk niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nuk pen aŋgak, “Bapiy yand ak woŋg ginep mindip rek, yand kunep ginim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kun aŋgek, Jiwda biyomb gok, nup nind ñaŋgjun aŋgiy gos niŋyak ak, kilis yimb giy niŋyak. “Lotiw ñin chinup low ar ak nep ma timbrikip; yand Gor Ñinuk aŋgip ak, Gor mindip rek mindpiyn aŋgiy asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jiysis pen kuyip aŋgak, “Nimbip niŋind aspiyn: Ñi ak nuk key tap bap ginimuŋ rek ma ayip; Nop tap giniŋgamb gok nep niŋiy giniŋgamb. Kun ak, Nop giniŋgamb rek, Ñinuk kunep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nop Ñinuk nup wasemb ay, tap nuk gip gip gok maŋgiysek yomimb. Gunap yomek mey, tap key yimb gok gek niŋiy, nimb maŋgiysek wal aŋgniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pen Nop biynimb kumbay gok, gek tikjakpay rek, Ñinuk kunep, biynimb gunap gen tikjakyaŋ aŋgiy, gek tikjakniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Biynimb yerer gipay; gos yerip yerip niŋbay ak, Nop key kuyip ma bilokip; Ñinuk nup aŋgek bilokip. ");
INSERT INTO kmh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kun ak mey, Nop yimb ak dand araniy, Ñinuk nup yimb ak dand araniy giniŋgiy. Pen biynimb Ñinuk anup yimb ma dand aranimbay gok, Nop yokek owak anup yimb ak kunep, ma dand aranimbay. ");
INSERT INTO kmh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nimbip niŋind yimb aspiyn. Biynimb minim yip ak niŋiy, Bi yip aŋgyokek winik anup, gosimb niŋniŋgambay gok, kumemb kind ak kirgiy, perper mindep kind ak mindpay. Kun ak mey, kor yomb ak ma niŋniŋgambay; perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nimbip niŋind yimb aspiyn. Ñin kisen per kond mindpun ak miñiy wip biy, biynimb kumniŋgiy rek mindpay gok, Gor Ñinuk minim ak niŋey, kuyip dek, biynimb nuk mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nop tap okok maŋgiysek kim mindep kiñiŋ ak mindip rek, Ñinuk kunep kim mindep kiñiŋ ak mindip. ");
INSERT INTO kmh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nuk Bi bap Ñinuk ak mey; Nop aŋgek biynimb gok kuyip bilokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Minim aspiyn kun ak niŋiy wal ma aŋgnimimb; kisen nuk, biynimb kumey komyak gok aŋgek, ");
INSERT INTO kmh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","maŋgiysek tikjakiy; biynimb mindrep giyiŋgipay gok, am Gor yip mindeniŋgambay; pen mindrep ma giyiŋgipay gok, miker yomb diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yand yerip yerip gipiyn ak, key niŋiy ma gipiyn; Bapiy nep yip aŋgamb gipiyn. Kun ak biynimb bilokpiyn ak, Bapiy aŋgip rek niŋiy, yipund giy nep bilokpiyn. Key niŋiy gen, bilokrep ma gip apkip ak pen; Bi yip aŋgek winik ak, gos nuk ñimb rek niŋiy gipiyn. ");
INSERT INTO kmh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","“Yand nep Gor yip yokek winik apnip ak, yipund ma gipkop. Pen yand niŋbiyn: Bi yip yokek winik ak, minim nuk aŋgip ak, niŋind yimb nep aŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nimb Jiwda kay am Jon nup, yip bi yerip rek aŋgiy aŋgniŋem, minim yipul yimb ak nimbip aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Gor aŋgyokek awak ak mey; lam yin tep gip rek ak aŋgak. Melik kun ak niŋiy, miñmiñ gipik ak pen, won ak kirpik. Yand niŋen, Jon akaŋ biynimb gunap minim aŋgniŋgambay ak, minim yomb mer ak pen; minim yand apiyn ak niŋrep giy, Gor nup chiŋgem, miker yomb ak nimbip ma dinimuŋ aŋgiy aspiyn. ");
INSERT INTO kmh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon nimbip aŋgrep gak ak pen; ak yikop minim nep aŋgak. Yand apiy, Bapiy ginimin aŋgak rek, tap key yimb gok gipiyn ak mey; nuk yip yokak ak niŋun aŋgiy, miseŋ yimb niŋbikip. ");
INSERT INTO kmh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Pen Bapiy yip yokak ak, yip aŋgiy minim aŋgip ak pen; minim nup ma diy, yip gosimb ma niŋbim. Kun ak minim nup ak ma niŋiy, nup Bi yerip rek ak ma niŋiy gipim. ");
INSERT INTO kmh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Nimb perper mindenjun aŋgiy, Baybol buk day nind tikyak gok niŋrep gun aŋgiy, per niŋbim ak, tep gipim ak pen; yip aŋgiy tikyak rek niŋiy, yip ker apem, nimbip gen suŋ-tep mindiy perper ma mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Biynimb gok yimb yip dand araniyaŋ aŋgiy ma aspiyn; ");
INSERT INTO kmh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gor nup gosimb ma niŋbim ak niŋiy aspiyn. ");
INSERT INTO kmh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bapiy nep yip aŋgek opiyn ak pen, yip ma dipim. Pen bi kisen bap gos nuk key niŋiy apeniŋgamb, nup diniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Biynimb gok chinup niŋey tep ginimuŋ aŋgiy nep niŋbim; Biyomb yimb ak chinup niŋek tep ginimuŋ aŋgiy, gos ak ma niŋbim. Kun ak yergiy nup gosimb niŋem, nimbip diniŋgamb? ");
INSERT INTO kmh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Pen Nop Ñinuk minim ak diy, chinup kor giniŋgamb aŋgiy gos ak ma niŋnimimb. Mosis aŋgiy tikak rek nep giniŋgambun apim ak pen; minim aŋgak kun ak diy, nimbip kor giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pen Mosis Baybol buk minim tikak gunap ma dipik rek; minim yip aŋgak ak sesek ma dipik. ");
INSERT INTO kmh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Minim nup ak diy rek, minim yip ak kunep dipkip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pen Jiysis kun giy mindiy, bot diy Galiyliy chemb tikiy, pis bindoŋ amnak. Galiyliy chemb kun ak nep, yimb bap Taybiyriyas aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","6","Pen nuk biynimb gok gek, suŋ ayek niŋyak rek, biynimb kuŋaynep nup kisen giyiŋgipay. Ñin namb kun ak, Jiwda ñin yomb Pasopa apay ak maŋ maŋ gak rek, biynimb kuŋaynep miñmon namb kun ak taŋgeyak. Kun ak niŋiy, Jiysis binuk gok yip am dum bap, bisiŋg mindyiŋg niŋak; biynimb kuŋay yimb nep nup niŋniŋg apeyak. Niŋiy, yerer giniŋgamb ak key niŋak ak pen; binuk Piyliyp yerip aŋgniŋgamb aŋgiy, nup aŋgak, “Chin keñmaŋgiy akay nimb diy, biynimb guniy kuyip ñon ñiŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aŋgek, Piyliyp aŋgak, “Tiw handret kiyna rek dand amiy, biret taw dand apiy, tipaŋg siskoy giy, maŋgiysek ñey ñiŋniŋgiy rek ma ayniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kun aŋgek, Saymon Piyta numam Enjriw aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ñiskoy bap, biret onep mamind ak, piys omiŋal sek di mindip biy ak pen, ak tap yomb mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aŋgek, Jiysis aŋgak, “Biynimb gok aŋgem, bisgiyaŋ aŋgak.” Kun aŋgek, binuk gok biynimb gok kuyip aŋgeyak, tap kaskas ar kun okok bisgiyak. Biynimb kuŋaynep kun gok, bi gok nep, payp tawsin rek amnak. ");
INSERT INTO kmh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kiyk kun giy bisgiyakniŋ, Jiysis biret ak diy, Gor nup tep aŋgiy, kuyip bilok ñak. Piys ak kunep gak. Kuyip kun giy bilok ñek, ñimbey ñimbey tapin ayek, day gok kirgiyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kun gey, binuk gok kuyip aŋgak, “Tap ñimbiy kirpay gok, dand doŋwiy ma gep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aŋgek, binuk gok yipruŋg wand yiŋgey yiŋgey, wand onep wimiŋgan ak arachakak. ");
INSERT INTO kmh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Biynimb gok tap mageprek gak kun ak niŋiy aŋgyak, “Chin miñiy niŋbun; bi biy mey, bi Gor minim aŋgep mankumb biy winiŋgamb aŋgiy, per apun ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pen Jiysis niŋak; biynimb gok nup ap kilis giy, kiyŋ chin mindeŋ aŋgniŋgambay ak niŋiy, nuk tip ak am, yirik okok key asiy mindek. ");
INSERT INTO kmh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pen duŋgep won ak, Jiysis binuk gok tip ak Kapaniyam amniŋg, am ñiŋg chemb biyaŋ amiy, ");
INSERT INTO kmh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jiysis apek amnun aŋgiy, kond mind gey gey kisyim apek, kiyk nep bot diy saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Amniyakniŋ, pinim yomb diy, ñiŋg ak paŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pen tapin nep pul gi dand ñiŋg namb siŋak amyiŋg niŋyak; Jiysis ñiŋg kas ar ak tawind kiñiŋ kun siŋak apchakek, niŋiy pirikeyak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Ma piriknimimb! Ak yand nep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kun aŋgek, ma pirikiy, nup bot miŋgan aŋgey amnakniŋ, miñmon wikan amniŋg giyak ak amjakyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Minek biynimb gok tip ak Jiysis nup niŋniŋg; Gor nup tep aŋgiy, tap ñek ñiŋyak tip ak amniyak. Amiy, minim bap niŋyak: bot diy wiyak ak, binuk gok nep diy amniyak; Jiysis yip ma amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pen Jiysis yip ma amniyak rek, nup niŋun aŋgiy, Taybiyriyas nimb bot gunap diy, Kapaniyam amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kapaniyam amjakiy, Jiysis nup niŋiy aŋgyak, “Tiysa. Nand won akay biy opan?” ");
INSERT INTO kmh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aŋgey aŋgak, “Nimbip niŋind aspiyn. Keñmaŋgiy ñen, ñimb mer niŋiy kirgipim rek, yip tip piyow taspim; pen tap mageprek gipiyn minim junj ak ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tap ñimbiy per ma mindeniŋgambim gok piyow niŋraspim ak kirgiy, Bi bap Ñinuk nimbip gek perper mindeniŋgambim ak niŋiy, ar kun ak amnimimb. Bapiy Gor Bi kun ak nup, bi yand yimb aŋgiy yip mindek mey, tap mageprek ak gek niŋbik aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kun aŋgek aŋgyak, “Perper mindonjun aŋgiy, Gor gos nuk niŋimb ak, nup yergiy rek direp ginjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aŋgeyak, Jiysis aŋgak, “Gor nup tep giniŋgamb ak mey, Binuk yokek wak ak, Gor nep yokek awak aŋgiy, nup gosimb niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kun aŋgek aŋgyak, “Chinup tap mageprek bap gey niŋiy, Gor nep nip yokek winak aŋgiy niŋjun. Kun ak chinup tap yerip rek giniŋgamban? ");
INSERT INTO kmh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Apis basind sikop wosrey, miñmon nep namb okok mindiy, tap mana apay ak ñimbyiŋgipay. Mosis kuyip gi tep gek, tap mana kun ak di biret rek gay ñimbyiŋgipay ak, Baybol buk ak tikiy aŋgyak, ‘Kuyip keñmaŋgiy semb biyoŋ nimb ak ñek, ñimbyiŋgipay aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kun aŋgeyak, Jiysis kuyip aŋgak, “Nimbip niŋind yimb aspiyn. Biret semb biyoŋ nimb diy ñiŋyak kun ak, Mosis mer: Bapiy yand ak ñek ñimbyiŋgipay. Nuk nep mey; nimbip biret niŋind yimb anup, yokek wip. ");
INSERT INTO kmh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Biret niŋind yimb yokek wip aspiyn kun ak, Bi semb biyoŋ nimb biy apiy, biynimb gok kuyip gek suŋ-tep mindiy, perper mindeniŋgambay anup aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jiysis kun aŋgek aŋgyak, “Biyomb. Biret kun ak chinup ñiyiŋg nep mindenimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aŋgeyak aŋgak, “Yand nep mey biret rek; biynimb yip dipay gok perper mindeniŋgambay. Biynimb yip gosimb niŋiy, yip ker winiŋgambay gok, tip ak yiwan rek akaŋ, ñiŋg nen rek ma giniŋgamb; mey tep aŋgiy niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pen nimbip aŋgambiyn rek: yip windin niŋbim ak pen, yip gosimb ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bapiy biynimb yip aŋgniŋgamb gok, yip ker winiŋgambay. Biynimb yip ker winiŋgambay gok, ma yimb aŋgyokniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yenen: yand semb biyoŋ nimb winik ak, key niŋbiyn rek giyn aŋgiy ma winik; Bi yip yokek winik ak, gos nuk niŋiy aŋgip rek, giyn aŋgiy winik. ");
INSERT INTO kmh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nup tep giniŋgamb ak mey: biynimb yip aŋgip gok niŋminden, gunap ma kurginiŋgiy; ñin kisen ak apek, maŋgiysek gen tip ak tikjakniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bapiy nuk aŋgip ak, ‘Biynimb gok Ñiyand anup minim ak niŋey, nup gosimb niŋey mey; kuyip gen perper mindeniŋgambay aŋgip.’ Kun ak ñin kisen ak apek, kuyip gen tikjakniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pen Jiysis minim kun aŋgyiŋg, yand nep mey, biret semb biyoŋ nimb wip ak aŋgek, ");
INSERT INTO kmh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jiwda biynimb gok pemiy aŋgiy aŋgyak, “Bi biy Josep ñinuk Jiysis nep rek? Nop nonim nuk ak chin niŋbun. Kun ak yergiy pen, semb biyoŋ nimb opiyn aŋgip?” ");
INSERT INTO kmh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kun aŋgeyak, nuk pen aŋgak, “Pemiy ma aŋgnimimb. ");
INSERT INTO kmh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Biynimb bap gos peyiŋg yip ker ma winiŋgambay; Bapiy gos tep ñek nep mey, yip ker apey, ñin kisen ak kuyip gen tip ak tikjakniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Baybol buk ak tikiy aŋgyak, ‘Gor biynimb maŋgiysek nimbip gok kuyip gos ñiniŋgamb aŋgyak.’ Biynimb gos nuk nimb rek niŋbay gok maŋgiysek, yip ker opay. ");
INSERT INTO kmh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Biynimb gunap Bapiy Gor nup windin ma niŋbay; Bi yokek wip anep nup niŋimb. ");
INSERT INTO kmh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nimbip niŋind yimb apiyn; biynimb yip gosimb niŋniŋgambay gok, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kun ak yand mey, biret ñimbiy kim mindeniŋgambay ak. ");
INSERT INTO kmh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nasind napis sikop wosrey, miñmon nep namb okok mindiy, tap mana ak ñiŋyak ak pen, yep won bap mindiy kumyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Biret Gor yokek owak aŋgiy, yand aspiyn ak; biynimb ñimbiy, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Yand biret kim mindep semb biyoŋ nimb winik. Biynimb biret kim mindep semb biyoŋ nimb kun ak, ñimb namb biyaŋ ayniŋgambay gok, perper mindeniŋgambay. Pen biynimb gok tap ñimbyiŋg nep mindpay. Mumbwak yand ak mey, kun ak rek. Biynimb miñmon okok maŋgiysek kuyip aŋgiy, mumbwak yand ak Gor nup simboŋginiŋgayn ak mey; chinup nen kumimb aŋgiy gosimb niŋniŋgambay biynimb gok, perper mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jiysis kun aŋgek, Jiwda biynimb kiyk keynep penpen aŋgiy, gunap aŋgyak, “Bi biy chinup yergiy, mumbwak nuk ak ñek ñiŋniŋgambun?” ");
INSERT INTO kmh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aŋgeyak, Jiysis aŋgak, “Nimbip niŋind yimb aspiyn. Biynimb Bi bap Ñinuk kiros bak biyoŋ kumniŋgamb ak, chinup nen kumniŋgamb; likañ nuk yowniŋgamb ak, chinup nen yowniŋgamb aŋgiy, yip di namb kiyk biyaŋ ayniŋgambay gok nep, Gor deniŋgamb perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kun ak biynimb mumbwak likañ yip diniŋgambay gok, perper mindeniŋgiy rek ayniŋgamb. Ñin kisen ak apek, kuyip gen tip ak tikjakiy, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Kun ak keñmaŋgiy gok, tap yikop ñimbay ak pen; mumbwak yand ak sek, likañ yand ak sek tap yimb. ");
INSERT INTO kmh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Biynimb mumbwak likañ yip niŋind yimb aŋgiy dipay gok, yip chiŋgipay. Yand kuyip pen kunep chiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bapiy biynimb gok kim mindeniŋgiy aŋgiy, yip yokek winik ak, yip nep mindip ak mey, biynimb yip di namb biyaŋ ayniŋgambay gok kuyip gen, perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Minim ar kun ak mey, biret semb biyoŋ nimb wip apiyn ak. Biret kun ak, basind apis sikop tap mana apay ak ñimbiy, mind dand amiy kumyak rek mer; biynimb biret yand apiyn ak, ñimb namb biyaŋ ayniŋgambay gok, perper nep mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jiysis Kapaniyam nan-gep korip ak mindiy, minim kun ak aŋgek, ");
INSERT INTO kmh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","biynimb nuk gok kuŋaynep niŋiy aŋgyak, “Minim miker gip kun ak, an rek niŋniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aŋgyak kun ak, Jiysis key niŋiy aŋgak, “Minim kun ak aŋgen nimbip tep ma gip? ");
INSERT INTO kmh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pen Bi bap Ñinuk mindiy, owak biyoŋ tip andkind amnakniŋ, gos yerip niŋniŋgambim? ");
INSERT INTO kmh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mumbwak ak tap yikop; Gor Kawnan ak tap yimb. Minim nimbip apiyn ak, Gor Kawnan ak gos ñek apiyn ak mey; biynimb minim kun ak diniŋgambay gok, kuyip gek perper mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pen Jiysis nuk nind nep: an nup gos niŋniŋgamb, an nup gos ma niŋniŋgamb, an nup mimuŋg giniŋgamb ak niŋak ak mey, aŋgak, “Nimb gunap yip ma gosimb niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pen minim gunap sek aŋgiy aŋgak, “Ar kun ak nep nimbip apiyn; biynimb gos keynep niŋiy, yip gosimb niŋniŋgiy rek ma ayip; Bapiy nep mey, kuyip gos tep ñakniŋ, yip gosimb niŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jiysis minim kun ak aŋgjiwakniŋ, biynimb ap minim nup niŋyiŋgipay gok, kuŋaynep nup kirgiy, keykey amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nup kiriŋg ameyak, binuk onep wimiŋgan ak kuyip aŋgniŋiy aŋgak, “Nimb kunep yip kiriŋg amniŋgambim?” ");
INSERT INTO kmh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aŋgek, Saymon Piyta aŋgak, “Biyomb. An ker amjun? Minim nand apan ak niŋiy mey, perper mindeniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nip niŋbun: nand Gor Bi suŋ-tep nuk, chinup yokip anep mindpan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","71","Kun aŋgek, Jiysis pen, Jiwdas Yiskariyot Saymon ñinuk ak, kisen nup mimuŋg giniŋgamb rek niŋiy, kuyip aŋgak, “Nimbip onep wimiŋgan ak dipiyn ak pen; nimb bap bi timey Seytan ker mindpim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kisen pen Jiwda biyomb gok, Jiysis nup ñaŋgniŋg gey niŋiy, Jiwdiya propens ma giraŋgyiŋgip; Galiyliy propens nep giraŋgyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pen Jiwda ñin yomb kiyk, korip bandak band giy miñmiñ giyiŋgipay ak, maŋ maŋ gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","4","Jiysis numam sikop, nup kunep ma gos niŋyak rek, mindek ak apiy aŋgyak, “Nand Biyomb mindpan rek, Jiwdiya amiy, biynimb minim nip niŋniŋg winiŋgiy gok, tap mageprek gipan rek gunap gey niŋniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Biynimb yomb mindniŋg gipay gok, tap kiyk gok weygiy ma gipay; miseŋ yimb gipay. Kun ak nand bi key yimb gipan ak, tap mageprek gunap gey, biynimb maŋgiysek niŋniŋgiy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kun aŋgey, Jiysis kuyip aŋgak, “Ñin monmon gok, ñin nimb ak mey, amniŋg amniŋgambim. Pen Gor yip aŋgayip ñin ak ma wip. ");
INSERT INTO kmh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Biynimb Gor nup ma chiŋgpay gok, tap siy tap timey gipim aŋgen niŋiy, yip miluk niŋbay; pen nimbip niŋiy miluk niŋniŋgiy rek ma mindip. ");
INSERT INTO kmh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kun ak ñin yomb ak maŋ asaw rek, Jerusalem amnimimb; pen ñin yand ak ma wip rek, yand yip ma amniŋgambun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kun aŋgiy, nuk Galiyliy mindek. ");
INSERT INTO kmh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pen kun aŋgek numam sikop nind amniyak. Kisen nuk amniŋg; miseŋ ma amnak, wey wey giyiŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pen Jiwda biyomb gok, Jiysis akay aŋgiy, biynimb kuŋay ap mindeyak gok kuyip aŋgniŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Pen biynimb yikop gok, Jiwda biyomb kun gok kuyip pirikyak rek, minim kapkap aŋgyiŋg aŋgyak, “Jiysis bi tep yimb aŋgyak.” Gunap pen aŋgyak, “Mer. Nuk biynimb gok kuyip tom gip sek aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ñin yomb kiyk kun ak, yep ñin kaw bap nep mindakniŋ, Jiysis apchakiy, Gor aŋgniŋep korip ak amiy, kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aŋgñek niŋiy, Jiwda biyomb gok wal aŋgiy aŋgyak, “Bi biy sikul ma aŋgak ak pen, yergiy minim okok maŋgiysek niŋimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kun aŋgyak ak pen, Jiysis aŋgak, “Minim aŋgñimbiyn gok, yand key niŋiy ma apiyn; Bi yip aŋgyokek winik anep gos ñamb apiyn. ");
INSERT INTO kmh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Biynimb Gor aŋgip rek gun aŋgiy gi dand amniŋgambay gok, Gor minim nup akaŋ, minim yand key apiyn ak, kuyip gos ñek niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nimb niŋbim: biynimb minim kiyk key aŋgniŋgambay gok, yimb chin aranimuŋ aŋgiy, minim okok nimb okok nimb aŋgniŋgambay. Pen Gor bi yokek minim nup aŋgniŋg wip ak; bi minim yipund giy nep aŋgniŋgamb ak mey; yesek aŋgnimuŋ rek ma mindip. ");
INSERT INTO kmh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosis, Gor aŋgak aŋgak rek low gunap aŋgñak ak pen; nimb bap low ar kun gok kindik ma gipim. Minim bap mindek mer; yip yikop yimb ñaŋgniŋg gispim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jiysis kun aŋgek, biynimb ap mindeyak gok aŋgyak, “Nip an ñaŋgniŋg gisap. Nip kichekiy ambaŋ ayamb aspan?” ");
INSERT INTO kmh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aŋgey, Jiysis aŋgak, “Yand tap mageprek nokom bap genik, nimb maŋgiysek lotiw ñin ak yenen kun gip aŋgiy, jiwdipik. ");
INSERT INTO kmh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Nimb Mosis aŋgak rek, ñi gok tikiy, ñin onep ar ak mindiy, minek jiy ak kumbak tikpim. Gipim kun ak Mosis nuk mer, nasind yes sikop nind kiñiŋ gi gey mey kun gipim. Pen kumbak tikpim kun ak, ñin gunap Jiwda lotiw ñin ak apek, ma kirpim; monmon kumbak tikpim. Gipim kun ak rek, lotiw ñin ak, bi bap nup gen pisnep suŋ ayak ak; yip yenen miluk niŋbim. ");
INSERT INTO kmh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kun ak kisen minim ar ar nep niŋiy ma aŋgnimimb; niŋrep giy, yipund giniŋgamb ar ak niŋiy aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem biynimb gunap aŋgyak, “Biyomb gok, bi ñaŋgun aŋgiy niŋbay ak, mey biy rek ayip? ");
INSERT INTO kmh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pen niŋim! Bi kun ak nuk biynimb namb yomb biy minim aŋgakniŋ, pen minim bap ma aspay. Kun ak kiyk key, nuk bi kiyŋ yomb key yimb ak aŋgiy niŋbay rek ayip! ");
INSERT INTO kmh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pen bi kiyŋ yomb key yimb opkop ak, akay nimb wip aŋgiy ma niŋbinup; bi biy akay nimb wip ak chin maŋgiysek niŋbun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Pen Jiysis Gor aŋgniŋep korip miŋgan biyaŋ, minim aŋg nep mindyiŋg, meŋg miŋgan dand araniy aŋgak, “Nimbik yip niŋrep yimb giy, akay nimb winik ak niŋbim. Pen yand key ma winik; Bi biynimb aŋgdep ak nep yip aŋgyokek winik. Yand nuk yip mindiy, yip aŋgyokek winik rek nup niŋbiyn; pen nimbik nup ma niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kun aŋgek, nup chichiy diy dand kor amnun aŋgiy niŋyak ak pen; Nop Gor nup pikayniŋgambay aŋgiy aŋgayak ñin ak ma owak rek, biynimb bap nup ma chichiy diyak. ");
INSERT INTO kmh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pen biynimb kuŋaynep kun gok, gunap Jiysis bi kiyŋ yomb key yimb ak aŋgiy niŋyak. Niŋiy aŋgyak, “Bi kiyŋ yomb key yimb kisen winiŋgamb apay ak, tap mageprek kuŋaynep giy, bi biy nup wiyniym ginimuŋ rek ma ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pen biynimb gok, bi kiyŋ yomb key yimb anup minim kun ak kapkap aŋgeyak niŋiy, bi Peresiy gok sek, bi Gor nup tap simboŋgep yomb gok sek Jiysis nup am dand winimimb aŋgiy, Jiwda poliys gunap aŋgyokyak. ");
INSERT INTO kmh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jiysis pen aŋgak, “Yand yep won bap mindiy, Bi yip yokamb opiyn ak ker tip amniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yip akay amimb aŋgiy piyowniŋgambim ak pen, ma niŋniŋgambim. Yand amniŋgayn ar ak, nimb kisen ginimimb rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kun aŋgek, Jiwda biyomb gok kiyk keynep aŋgniŋ aŋgniŋ giy aŋgyak, “Nuk akay amek, nup ma niŋniŋgambun? Nuk am Jiwda biynimb jiw am Griyk mindpay okok amiy, biynimb kun okok kuyip minim aŋgñiyiŋg mindeniŋgamb nup ma niŋniŋgambun? ");
INSERT INTO kmh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pen yenen aŋgip, ‘Yip piyow niŋiy ma niŋniŋgambim; amniŋgayn ar ak kisen ginimimb rek ma ayip aŋgip’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jiwda ñin yomb kiyk kun ak, ñin kisen yimb ak apek, Jiysis tikjakiy, meŋg miŋgan dand araniy aŋgak, “Biynimb an kuŋam kinjik gek, yip ker apiy ñiŋg ñiŋniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Biynimb yip gosimb niŋniŋgambay gok, Baybol buk ak aŋgip rek, ñiŋg ñimbiy perper mindeniŋgambay ak, namb kuyip biyaŋ kilam jiwiy winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ñin kun ak, Jiysis kumiy tikjakiy Nop ker ma amek mey, Gor Kawnan nuk ak biynimb gok kuyip ma yokak. Ñiŋg kilam jiwiy winiŋgamb minim aŋgak kun ak; nup gosimb niŋey, Gor Kawnan ap kiy yip mindiy, giniŋgamb rek aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jiysis kun aŋgek, biynimb kuŋaynep kun gok, gunap minim aŋgak kun ak niŋiy aŋgyak, “Bi biy, bi Gor minim aŋgep winiŋgamb aŋgiy kond mindyiŋgipun ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gunap aŋgyak, “Nuk bi kiyŋ yomb key yimb ak aŋgyak!” Kun aŋgeyak, gunap pen aŋgyak, “Kiyŋ yomb key yimb ak Galiyliy nimb ma winiŋgamb! ");
INSERT INTO kmh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Baybol buk ak aŋgip rek, Jiwda bi kiyŋ yomb key yimb ak, Depiyt tikek tik dand amiy apiy giy, tikniŋgambay Depiyt miñmon nuk Betliyhem aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jiysis nup nen aŋgiy, biynimb kuŋay mindeyak kun gok, asik pis ak key, pis ak key ay, ");
INSERT INTO kmh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","gunap nup diy dand kor amnun aŋgyak ak pen, nup ma diyak. ");
INSERT INTO kmh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pen Jiwda poliys gok andkind amey, bi Peresiy gok sek, bi Gor nup simboŋgep yomb gok sek aŋgyak, “Bi kun anup yenen ma dand opim?” ");
INSERT INTO kmh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aŋgey, bi poliys kun gok aŋgyak, “Biynimb bap, bi kun ak minim tep yimb aŋgip rek ma apay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kun aŋgey, bi Peresiy gok aŋgyak, “Nimb biynimb gunap bi tom gip kun ak niŋind aŋgip aŋgiy niŋbay rek niŋbim? ");
INSERT INTO kmh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bi chin Peresiy bap akaŋ, Jiwda biyomb gunap nup gos niŋiy ma dipay. ");
INSERT INTO kmh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Biynimb guniy kiyk Mosis low ak ma niŋbay rek, yiwur yomb diniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pen bi kiyk Niykodiymas, bi nind kisyimken amiy Jiysis nup minim gunap aŋgniŋak ak, kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Jiwda low chin ar ak, bi bap nup timey gipan aŋgiy, yikop kalambis ma aypun; kor giy junj bap niŋiy nep mey, kun gipun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aŋgek aŋgyak, “Nak kunep Galiyliy nimb rek? Baybol buk ak riytiym gi dand amiy niŋniŋgamban: bi Gor minim aŋgep bap, Galiyliy nimb ma winiŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kun aŋgiy, kiyk maŋgiysek korip kiyk keykey amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pen Jiysis nuk miñmon Oliyp dum am kiniy, ");
INSERT INTO kmh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","minek miñmon tikdam yokakniŋ, tip ak andkind Gor aŋgniŋep korip ak apek, biynimb kuŋaynep ap nup piŋiy kus kus gey, nuk bisiŋg mindyiŋg, minim aŋgñi mindek. ");
INSERT INTO kmh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Aŋgñi mindakniŋ, bi low tiysa gok sek, bi Peresiy gok sek biyn bap, bi bap yip di gek, dap biynimb mindeyak namb siŋak ay, Jiysis nup aŋgyak, “Tiysa. Biyn biy bi sek ak pen, bi bap yip di gambiyr niŋiy, dand aswun. ");
INSERT INTO kmh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosis low ak biyn bi kun gok rek, kamb jiw pikayniŋgiy aŋgak. Kun ak biyn gip kun biy, nand yerip gos niŋban aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pen kiyk minim kun ak yesek kun aŋgon, nuk yerip aŋgek, nup kor gun aŋgiy aŋgyak ak mey, nuk yikop jiy kuyaŋgiy, lum ar ak kil tik mindek. ");
INSERT INTO kmh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pen nup minim kun ak aŋgniŋnep mindeyak, nuk tikjakiy kuyip aŋgak, “Bi tap siy tap timey ma gip bap mindonimuŋ ak, kamb bap diy, biyn kun ak mindonimuŋ siŋak nind diyoknimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kun aŋgiy, tip ak kuyaŋgiy, man biyaŋ kil tik mindakniŋ, ");
INSERT INTO kmh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","bi nup kor gun aŋgyak kun gok, minim aŋgak kun ak niŋiy, biyomb yomb rek gok nokom nokom kiriŋg amniyakniŋ, maŋgiysek kiriŋg keykey amdiyak. Jiysis yip, biyn ak yip nep minderik. ");
INSERT INTO kmh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kun ak nuk kund almil ay bisiŋg mindyiŋg; biyn kun anup aŋgak, “Bi gok akay? Bi nip kor ginimuŋ bap ma mindip rek?” ");
INSERT INTO kmh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aŋgek, biyn ak aŋgak, “Biyomb. Bi yip kor ginimuŋ bap ma mindip aŋgak.” Aŋgek, Jiysis aŋgak, “Yand kunep nip kor ma giniŋgayn nen amnoŋ! Pen tap siy tap timey ak tip ma ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jiysis kuyip tip ak aŋgiy aŋgak, “Mankumb biy melik ak yand mindpiyn. Biynimb an yip chiŋgiy taŋgeniŋgambay gok, kisyimnamb okok ma taŋgeniŋgambay; permindep melik tep ak diy taŋgeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kun aŋgek, bi Peresiy gok nup aŋgyak, “Minim nak keynep apan ak, dep rek ma ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kun aŋgey, Jiysis aŋgak, “Minim kun ak yand key aspiyn ak pen, niŋind aspiyn. Yenen: yand opiyn okok niŋiy, amniŋgayn okok niŋiy gipiyn. Pen nimb, opiyn okok, amniŋgayn okok ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nimb minim tuŋgasikyiŋg, ar ak tep gipim, ar ak timey gipim apim ak, biynimb Gor nup ma chiŋgipay gok gos niŋiy apay rek nep apim. Pen yand nimb apim ar kun ak rek ma apiyn. ");
INSERT INTO kmh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bapiy yip yokek winik ak, yip mindpiyn rek, minim tuŋgasikniŋg; niŋind nep aŋgiy tuŋgasikpiyn. ");
INSERT INTO kmh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Low minim nimbik ar ak apim, ‘Bi omiŋal minim ar nokom kun anep aŋgeniŋgayr mey; ak niŋind apiyr aŋgiy niŋniŋgambay apim.’ ");
INSERT INTO kmh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Low nimb kun ak rek. Bapiy yip yokip ak, minim chirapiy nokom kun anep apur ak mey, niŋind apur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kun aŋgek, nup aŋgyak “Nap akay?” Aŋgey aŋgak, “Nimbik yip ma niŋbim rek, Bapiy nup kunep ma niŋbim. Yip niŋiy rek, Bapiy nup kunep niŋbikip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jiysis lotiw korip opriyŋ dap yokpay miŋgan ak, minim kun ak aŋgñak ak pen, Gor ñin nup aŋgayak ak ma wak rek, biynimb bap nup chichiy diy, dand kor amniŋgiy rek ma ayak! ");
INSERT INTO kmh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jiysis kuyip tip ak aŋgak, “Yand amen, yip piyowniŋgambim ak pen, nimbik tap timey ginep mindiy kumniŋgambim rek, amniŋgayn tip ak ma niniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kun aŋgek, Jiwda biyomb gok aŋgyak, “Nuk aŋgip yand amjipiyn okok ma niniŋgambim aŋgip ak, yenen kun aŋgip? Nuk key pikayniŋg kun aŋgip?” ");
INSERT INTO kmh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kun aŋgyak ak pen, Jiysis kuyip aŋgak, “Nimb biy nimb; yand biyoŋ nimb winik. Nimb mankumb biy ker; yand pen mankumb biy ker ma mindpiyn. ");
INSERT INTO kmh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kun ak niŋiy mey, ‘Nimb tap siy tap timey gi mindiy kumniŋgambim apiyn.’ Pen yip mey bi kun ak nep aŋgiy, gosimb ma niŋniŋgambim ak; gach sek mindpim rek mindiy, kumniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kun aŋgek aŋgyak, “Nand an?” Aŋgey, Jiysis aŋgak, “Nimbip per ma aŋgñimbiyn? ");
INSERT INTO kmh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nimbip minim aŋg ginim ar ak, kuŋaynep mindip. Bi yip aŋgyokek winik ak, gos okok maŋgiysek niŋrep gip rek, yip gos ñakniŋ, biynimb gok kuyip aŋgñimbiyn ak pen; nimb ma niŋjun aŋgiy nep niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jiysis Nop nup aŋgiy minim aŋgak kun ak ma niŋyak rek, kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Bi bap Ñinuk nup ñaŋgbirikniŋgambim ñin ak, giniŋgamb giniŋgamb rek niŋiy aŋgniŋgambim, ‘Ak Bi kun anep. Nuk tap bap key niŋiy ma giyiŋgip; Nop minim aŋgñiyiŋgip rek nep niŋiy aŋgyiŋgip aŋgniŋgambim.’ ");
INSERT INTO kmh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bi yip yokek winik anup, tep gip ar anep gipiyn ak mey, yip ma kirgip; nuk yip nep mindpur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jiysis minim kun ak aŋgakniŋ, biynimb kuŋaynep nup Kiyŋ yomb key yimb ak aŋgiy gos niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pen Jiwda biynimb nup Kiyŋ yomb key yimb aŋgiy niŋyak kun gok kuyip aŋgak, “Biynimb minim yip ar ar diniŋgambay gok, biynimb yand mer. Biynimb yand mey, minim yip pisnep dipay gok. ");
INSERT INTO kmh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Biynimb yand mindeniŋgambim rek, Gor nimbip gos tep ñek, minim yerip yipund giy mindip ak niŋiy, kalambis woŋg rek gi mindpim ak kirgiy, mindrep giniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kun aŋgek aŋgyak, “Minim apan kun ak yerip? Chin basind Ebraham ñapan nuk mindpun ak, chin biynimb gunap kuyip kalambis woŋg rek ma gipun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kun aŋgeyak, Jiysis aŋgak, “Nimbip niŋind aspiyn. Biynimb tap siy tap timey gipay gok, key mindrep giniŋgiy rek ma ayamb mey, kalambis woŋg rek gi mindpay. ");
INSERT INTO kmh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Biynimb kalambis woŋg gipay kun gok, Biyomb ak biynimb kiñiŋ nuk yimb ma mindpay. Pen Bi bap Ñinuk ak nep mey; Biyomb ak Ñinuk yimb. ");
INSERT INTO kmh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nuk nimbip biynimb kalambis woŋg rek gi mindpim gok, wisik yokeniŋgamb, biynimb kalambis woŋg gipay rek ma mindeniŋgambim; Biyomb ak biynimb nuk yimb mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nimbip Ebraham tikek tikey apek mindpim ak niŋbiyn ak pen; nuk giyiŋgip rek ma giy, minim apiyn ak ma diy, yip ñaŋgniŋg gispim. ");
INSERT INTO kmh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yand Bapiy yip mindiy niŋnik rek nimbip aŋgñimbiyn; pen nimb, nap nimbik ak minim aŋgip ar gok nep gipim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aŋgek aŋgyak, “Bapiy chin mey Ebraham aŋgyak.” Aŋgey, Jiysis aŋgak, “Nimbik Ebraham ñapan nuk mindembikip rek, nuk giyiŋgip rek gipkip. ");
INSERT INTO kmh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yand Gor aŋgip rek, minim niŋind yimb ak nimbip aŋgñimbiyn ak pen, yip ñaŋgniŋg gispim. Ebraham nuk, nimbik giniŋg gispim kun ak rek ma giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kun ak, nap nimbik yimb ak gip rek gispim aŋgak.” Kun aŋgek aŋgyak, “Chinup waŋ siy diy ma tikyak, Gor nokom mey, Bapiy chin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kun aŋgey, Jiysis pen aŋgak, “Gor bapiy chin apim ak pen; yand nuk yip mindiy opiyn ak, yenen yip wasemb ma aypim. Gos yand key niŋiy ma winik; nuk nep yip aŋgyokek winik. ");
INSERT INTO kmh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pen minim yip ak yenen niŋrep ma gipim. Gipim kun ak minim nup ak ma niŋun aŋgiy gipim. ");
INSERT INTO kmh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nap nimbik Seytan ak mey, nuk gos niŋimb ar anep gun aŋgiy niŋbim. Nuk kiñiŋ giy biynimb gok kuyip ñaŋgpikayiŋgip. Miñ ar nuk kun ak mindnep mindip. Gos tep gunap niŋiy mindrep ma gip. Minim tom nep gek gek mey, minim kun ak minim nuk yimb ayip. Nuk biynimb tom gipay gok nop kiyk ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","yand nimbip minim niŋind apiyn ak niŋiy, ma dipim. ");
INSERT INTO kmh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pen yand gipiyn ak timey gipan aŋgiy aŋgnimimb rek ma ayek, yenen minim yip ak ma dipim? ");
INSERT INTO kmh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Biynimb Gor ker mindpay gok, minim nup ak dipay. Pen nimb nup ker ma mindpim rek, minim nup ak ma dipim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jiwda kay Jiysis nup aŋgyak, “Nand bi Samariya nimb. Nip kichekiy abaŋ ayip aŋgambun ak, niŋind apun rek?” ");
INSERT INTO kmh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aŋgey aŋgak, “Yip kichekiy ma abaŋ ayip. Bapiy nup yimb ak dand aranimbiyn ak pen; nimb yimb yip ak dand apyopim. ");
INSERT INTO kmh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yimb yand ak key dand araniyn aŋgiy ma niŋbiyn; Biyomb biynimb yerer gipay gok niŋrep gip ak, yimb yip ak aranaŋ aŋgiy niŋimb. ");
INSERT INTO kmh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nimbip niŋind aspiyn: Biynimb an minim yip ak diy kisen giniŋgamb ak, ma kumniŋgamb, perper nep mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jiysis kun aŋgek, nup aŋgyak, “Ebraham kumek, bi Gor minim aŋgep gunap kunep kumyak ak, yergiy nand pen apan, ‘Minim yip diniŋgambim ak, ma kumniŋgambim apan?’ Kun ak chin niŋbun, niŋind nip kichekiy abaŋ ayip. ");
INSERT INTO kmh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bapiy chin Ebraham sek, bi Gor minim aŋgep gunap sek kumyak ak; kiyk bi sikoy, yand biyomb aŋgiy niŋban?” ");
INSERT INTO kmh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aŋgey, Jiysis aŋgak, “Yimb yand key dand araniŋgayn ak tep ma giniŋgamb. Bi yimb yip dand aranimb ak, Bapiy yand. Nimbik nup Bapiy chin apim ak pen; ");
INSERT INTO kmh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","nup ma niŋbim. Yand mey nup niŋbiyn. Pen nup ma niŋbiyn aŋgniŋgayn ak, nimb tom gipim rek giniŋgayn. Kun ak nup niŋbiyn ak mey, minim aŋgip rek dipiyn. ");
INSERT INTO kmh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pen Gor wosrey nap Ebraham nup, miñiy yand ap mindpiyn biy winiŋgamb aŋgek, niŋind aŋgip aŋgiy, gos sek mindiy miñmiñ gak ak mey, yand apen nup tep yimb gak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kun aŋgek, Jiwda biyomb gok minim nup kun ak niŋrep ma giy aŋgyak, “Simiy nak ñin jiwiy omiŋal rek ma mindpan ak pen, yergiy Ebraham wosrey kondoŋ okok mindyiŋgip anup niŋnik aŋgiy aspan?” ");
INSERT INTO kmh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aŋgeyak, kuyip aŋgak, “Nimbip niŋind aspiyn. Yand bi perper mindep ak mey, yand mindnikniŋ, Ebraham nup kisen tikyak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kun aŋgek, Gor rek mey minim kun ak kun giy apkop aŋgiy, nup kamb jiw pikayniŋg geyak, Gor aŋgniŋep korip miŋgan mindek ak siliŋg ay mis amnak. ");
INSERT INTO kmh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pen Jiysis binuk gok yip amyiŋg, bi windin koysek tikyak bap mindek. ");
INSERT INTO kmh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bi kun ak niŋiy, binuk gok Jiysis nup aŋgyak, “Tiysa! Tap siy tap timey an gek, bi kun biy windin nup ak koy gak? Nuk key akaŋ, nop nonim ger gak?” ");
INSERT INTO kmh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aŋgeyak, Jiysis aŋgak, “Windin nup koy gak ak, nuk key akaŋ, nop nonim tap siy tap timey ger ma gak. Yand nup gen suŋ ayek, biynimb gok niŋiy, Gor Biyomb yimb mindip ak niŋyaŋ aŋgiy mey, windin nup kun ak koy gak. ");
INSERT INTO kmh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Miñiy melik mindip rek, bi yip yokek winik ak, woŋg nup ak ginjun. Yenen, nimb niŋbim; kisyim apek woŋg gep rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yand mankumb biy mindpiyn rek, biynimb gok melik kiyk ak mindpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jiysis minim kun ak aŋgiy, man biyaŋ kiñuk giy, gek wilemb ayek diy, bi windin koy gak anup windin ak wiykiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Saylom chemb amiy, jomluk ak ñiŋg ayoknimin aŋgak.” Kun giy aŋgyokek, am ñiŋg ayokiy windin ak niŋyiŋg, korip nuk owak. ");
INSERT INTO kmh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pen biynimb korip layn nuk yip jimñiy gok sek, biynimb okok kuyip tap nen asimb aŋgyiŋgip gok sek key aŋgniŋ aŋgniŋ giy aŋgyak, “Bi biy mey, bi bisiŋg mindyiŋg tap nen asimb aŋgyiŋgip ak rek ayip?” ");
INSERT INTO kmh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aŋgey, gunap aŋgyak, “Yaw. Mey bi kun anep aŋgyak.” Gunap pen aŋgyak, “Mer. Bi kun ak rek ayip ak pen, bi biy key aŋgyak.” Kun aŋgey, bi kun ak nuk key aŋgak, “Yand mey bi kun ak nep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aŋgek, nup aŋgyak, “Windin nip ak yergiy suŋ ayip?” ");
INSERT INTO kmh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aŋgey aŋgak, “Bi Jiysis apay ak, man biyaŋ kiñuk giy, gek wilemb ayek, diy windin yip ak wiykiy aŋgip, ‘Am Saylom chemb biyaŋ ñiŋg ayoknimin aŋgek,’ am ñiŋg ayokiy day windin yimb niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aŋgek aŋgyak, “Bi kun ak miñiy akay?” Aŋgey aŋgak, “Ma niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Pen Jiysis gek windin niŋak kun ak, Jiwda lotiw ñin ak gak ak mey, biynimb gunap bi kun anup dand Peresiy kay mindeyak ak amey, ");
INSERT INTO kmh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","nup aŋgyak “Yergiy windin niŋban?” Aŋgey aŋgak, “Jiysis man ak diy, windin yip ak wiykamb, am windin ak ñiŋg ayokiy, windin yimb niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kun aŋgek, bi Peresiy gunap aŋgyak, “Lotiw ñin ak kun gip rek, Gor nup yokamb ma wip aŋgyak.” Aŋgeyak, bi kiyk gunap pen aŋgyak, “Bi tap siy tap timey gep bap mindombikop ak; yergiy tap mageprek kun ak gipkop aŋgyak.” Kun aŋgiy kiyk keynep, asik keykey ayak. ");
INSERT INTO kmh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bi Peresiy gok, bi kun anup tip aŋgniŋiy aŋgyak, “Bi windin nip gek niŋban kun ak, nup bi yerip aŋgiy niŋban?” Aŋgey aŋgak, “Yand niŋbiyn ak, nuk bi Gor minim aŋgep bap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pen Jiwda biyomb gok, Jiysis gek suŋ ayak minim ak ma diy, nop nonim kuyip suk aŋgey aperik ŋgyak, ");
INSERT INTO kmh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ñi biy ñi nirik?” Aŋgey aŋgrik, “Yaw! Ñi chir aŋgrik.” Aŋger aŋgyak, “Nup windin koysek tikrik?” Aŋgey aŋgrik, “Yaw! Nup windin koysek tikruk aŋgrik.” Kun aŋger aŋgyak, “Kun ak yergiy windin yimb niŋimb?” ");
INSERT INTO kmh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Pen kiyk ber niŋrik: Jiwda biyomb kun gok, nind minim kilis ar bap aŋgiy aŋgyak, “Biynimb Jiysis nup bi kiyŋ yomb key yimb aŋgiy niŋniŋgambay gok, lotiw korip chinup ak ma winiŋgambay aŋgyak.” Kun ak kiymiŋay pirikrik rek, Jiysis gek suŋ ayip aŋgiy ma aŋgrik, “Ñi ak windin koysek tikruk ak pen, miñiy yergiy windin yimb niŋimb ak ma niŋbur; nuk ñiskoy mer ak, nup key aŋgniŋem, aŋgñiniŋgamb aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kun aŋgerik, biyomb gok bi kun anup tip ak suk aŋgey apek aŋgyak, “Nip suŋ ayip kun ak, Gor nup yimb anep dand aranimin. Chin niŋbun, bi Jiysis kun ak, bi tap siy tap timey gep aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kun aŋgey, kuyip pen aŋgak, “Nuk bi tap siy tap timey gep bap akaŋ ma niŋbiyn; pen nind windin koy mindenik, miñiy niŋrep gipiyn ak niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aŋgek aŋgyak, “Nip yerer gip? Pen yergiy gamb windin yimb niŋban?” ");
INSERT INTO kmh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aŋgey aŋgak, “Nimbip mindarik aŋgñen niŋbim ak pen, yenen tip ak niŋun aŋgiy aspim? Nimbik kunep binuk mindniŋg gos niŋbim?” ");
INSERT INTO kmh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kun aŋgek, nup aŋg giy aŋgyak, “Nand bi kun ak binuk. Pen chin Mosis binuk. ");
INSERT INTO kmh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gor Mosis nup minim aŋgñek aŋgyiŋgip ak niŋbun ak pen; bi biy akay nimb wip?” ");
INSERT INTO kmh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aŋgeyak aŋgak, “Ayaw-ey! Nuk windin yip ak gek suŋ ayip ak pen; akay nimb aŋgiy ma niŋbim! ");
INSERT INTO kmh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pen chin niŋbun; tap siy tap timey giyiŋg, Gor nup aŋgniŋon ma niŋniŋgamb; biynimb mindrep gipay gok nep aŋgniŋey, aŋgniŋgambay rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Miñmon alwol gayak ñin ak tikiy, mind dand apiy mindpun ñin biy, biynimb windin koysek tikyak bap gey suŋ ma ayak. ");
INSERT INTO kmh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bi kun ak Gor yokek ma opkop ak, biynimb gok gek kun giy suŋ ma aypikop aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kun aŋgek aŋgyak, “Nanim nip tikak ñin ak, bi tap siy tap timey gep ak tikayak ak pen; chinup minim aŋgñiniŋg gispan?” Kun aŋgiy, Jiwda nan-gep korip biy tip ma winiŋgamban aŋgiy, nup aŋgyokyak. ");
INSERT INTO kmh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pen Jiysis bi kun anup aŋgyokyak minim ak niŋiy, am nup piyow niŋiy aŋgak, “Nand Bi bap Ñinuk ak nup gosimb niŋban?” ");
INSERT INTO kmh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aŋgek aŋgak, “Bi kun ak mey ak aŋgey, nup gosimb niŋnim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kun aŋgek, Jiysis aŋgak, “Bi kun ak mindarik niŋban. Mey nand yip minim aspiyr biy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kun aŋgek, Jiysis mindek kiñiŋ siŋak koŋgim yimiy aŋgak, “Biyomb! Nip gosimb niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aŋgek, Jiysis aŋgak, “Yand opiyn rek, biynimb mankumb biy yerer giy rek mindpay ak niŋniŋgambay. Biynimb mindrep ma gipun apay gok, windin sek rek ayniŋgamb; biynimb mindrep gipun apay gok, windin koy rek ayniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kun aŋgek, bi Peresiy maŋ kun siŋak mindeyak gunap, minim kun ak niŋiy aŋgyak, “Kun apan ak, chin kunep windin koy?” ");
INSERT INTO kmh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aŋgey, Jiysis aŋgak, “Nimb windin koy mindpun apkip rek, timey gipim ak, minim yomb yimb ma dipkip. Pen niŋrep gipun aŋgiy niŋbim rek, minim yomb yimb ak diniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jiysis minim ar bap paydoŋ ay aŋgak, “Nimbip niŋind yimb aspiyn. Bi kinjeŋram yipund giy miŋgan ak mindakniŋ, tam yesek bap talakiy amniŋgambay gok, bi tap siy sinjrimey dipay ak mey kun giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bi siypsiyp mokep ak, wariy miŋgan amniŋg, yesek tam okok talakiy ma amniŋgamb; kinjeŋram yipund giy miŋgan anep amiy, amniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","4","“Pen bi siypsiyp mokep ak amjakek, bi kinjeŋram kond mindep ak nup niŋrep giniŋgamb rek, kinjeŋ yikniŋgamb. Siypsiyp gok kunep, bi kun ak meŋg miŋgan nup ak niŋniŋgambay rek, kuyip yimb aŋgyiŋg, poŋind mis amiy, nuk nind gakniŋ, kiyk kisen giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pen bi yesek bap ap aŋgek, meŋg miŋgan nup ak ma niŋniŋgambay rek, pirik amniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jiysis kun giy paydoŋ ay aŋgek, minim asap ar ak aŋgiy ma tik niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","9","Ma niŋeyak, Jiysis tip ak aŋgak, “Nimbip niŋind yimb aspiyn. Yand mey kinjeŋram yipund giy ak. Biynimb kinjeŋram kun ak apiy amniŋgambay gok, bap ma kurginiŋgambay. Amiy apiy giyiŋg, tap kaskas ñiŋniŋgambay. “Pen chin bi kanj siypsiyp mokep aŋgiy nind wiyak gok, bi siypsiyp siydep ak mey, kanj siypsiyp gok minim kuyip ak ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kuyip siy diniŋg, timey giniŋg, pikayniŋg nep wiyak. Yand winik ak, kim mindiy mindrep yimb giniŋgiy aŋgiy winik. ");
INSERT INTO kmh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yand bi kanj siypsiyp mokep tep yimb ak. Bi kanj siypsiyp mokep kun ak, ma pirikniŋgamb; kanj siypsiyp kond minden aŋgiy monmon kumniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Bi woŋg maniy nep giyiŋg, kanj siypsiyp kond mindeniŋgambay gok, bi kanj siypsiyp mokep yipund giy mer ak mey, siypsiyp gok kuyip gosimb ma niŋniŋgambay. Kayn ayndik gok niŋiy, pirik ameniŋgambay mey, siypsiyp gok kuyip yuk dam kind keykey yokniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Bapiy chirapiy penpen niŋrep gipur rek; yand siypsiyp gok yip penpen niŋrep gipun. Kun ak kuyip aŋgiy kumniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Bapiy woŋg yip aŋgip rek, siypsiyp yand gok miñmon Jiwda biy nep mer; miñmon okok kunep diniŋgayn. Pen kiyk minim yip ak niŋniŋgambay rek; siypsiyp tiwin nokom bap mindiy, bi mokep kiyk nokom bap nep mindiy giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kuyip nen aŋgiy kumiy tikjakniŋgayn rek, Bapiy yip wasemb ayip. ");
INSERT INTO kmh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Biynimb gunap gos kiyk niŋiy gey ma kumniŋgayn; yand key kumiyn aŋgiy kumniŋgayn; tikjakiyn aŋgiy tikjakniŋgayn. Minim kun ak rek Bapiy yip aŋgip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jiysis minim kun ak kun giy aŋgek, Jiwda kay tip ak asik pis ak key, pis ak key ay; ");
INSERT INTO kmh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","gunap aŋgyak, “Nup kichekiy ambaŋ ayek, minim tom gisap ak, yenen niŋsipim aŋgyak?” ");
INSERT INTO kmh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pen gunap aŋgyak, “Nup kichekiy ambaŋ ayombikop; kun giy ma apkop. Pen kichekiy ambaŋ ayek, yergiy biynimb windin koy gok gek, tip ak niŋbiyap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pen kisen Jiwda biynimb, Gor aŋgniŋep korip opyim giyak ñin ak miñiy wip aŋgiy, Jerusalem am nan-giyak. Ñin kun ak, yombip ñin ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jiysis Gor aŋgniŋep korip mis ar “Solomon korip bandak band” aŋgyiŋgipay ak mindakniŋ, ");
INSERT INTO kmh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jiwda biyomb gok mindek siŋak apiy aŋgyak, “Chinup gey pernep ma kond mindenjun; bi kiyŋ yomb key yimb mindenimin ak, miseŋ aŋgey niŋjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aŋgey, Jiysis aŋgak, “Nimbip aŋgñimbiyn ak pen, niŋind aŋgip aŋgiy ma niŋbim. Tap mageprek gipiyn ak niŋiy, Gor nep aŋgek gip aŋgiy niŋnimimb ak pen, ");
INSERT INTO kmh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","siypsiyp yand ma mindpim rek, yip gosimb ma niŋbim. ");
INSERT INTO kmh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kanj siypsiyp yand gok kuyip niŋbiyn; kiyk pen meŋg miŋgan yip ak niŋiy, yip kindik gipay. ");
INSERT INTO kmh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kiyk yip dipay rek, gen perper mindeniŋgambay. Ñin ar yip mindpay ak, biynimb gunap ap kuyip lipiŋg dand amniŋgiy rek ma mindip. ");
INSERT INTO kmh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bapiy bi kilis yimb ak, kuyip di yip ñimb ak mey; biynimb gunap kuyip piliŋg dand amniŋgiy rek ma mindip. ");
INSERT INTO kmh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bapiy key, yand key mer; chirapiy bi nokom yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jiysis kun aŋgek, Jiwda kay nup tip ak, kamb jiw pikniŋg geyak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","“Bapiy aŋgek, tap mageprek gunap keykey gipiyn. Pen gipiyn kun ak, ar akay sisker gen niŋiy, yip ñaŋg pikayniŋg gispim?” ");
INSERT INTO kmh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aŋgek aŋgyak, “Tap mageprek gipan kun gok niŋiy, nip ñaŋg pikayniŋg ma gispun; Gor nup yimb ak aŋg sikoy giyiŋg, yand nuk rek aŋgey mey, nip ñaŋg pikayniŋg gispun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kun aŋgeyak, Jiysis aŋgak, “Baybol buk low per apim ak, ar bap tikiy, biynimb yomb gor rek mindpim aŋgiy tikyak. ");
INSERT INTO kmh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pen Baybol buk minim bap yesek ma aŋgniŋgamb ak mey, biynimb yikop woŋg nup giñiyiŋgipay gok kuyip, gor rek mindpim aŋgiy tikyak ak niŋind aŋgiy tikyak. ");
INSERT INTO kmh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yand mankumb biy opiyn ak, Bapiy yip, woŋg ginimin aŋgiy yokek opiyn. Pen nimb yerip gos ak niŋiy, Gor Ñinuk mindpiyn ak nep aŋgen, Gor nup yimb aŋg sikoy gisap aŋgiy, yip ñaŋg pikayniŋg gispim? ");
INSERT INTO kmh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Woŋg nup ak ma gen, minim yip ak ma dinimimb; pen genim, minim yip ak dinimimb. ");
INSERT INTO kmh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pen dep rek ma ayek, tap mageprek gipiyn gok niŋiy, yand Bapiy yip mindpiyn, nuk yand yip mindip ak; niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pen tip ak nup chichiy dun aŋgeyak, nuk kapkap silgiy amnak. ");
INSERT INTO kmh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Siliŋg ay amiy, Joden ñiŋg tikiy pis bindoŋ amiy, Jon mindiy biynimb ñiŋg pikñiyiŋgip miñmon tiŋgoŋ okok am mindek. ");
INSERT INTO kmh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Biynimb kuŋaynep, mindek ak apiy aŋgyak, “Jon tap mageprek gunap ma giyiŋgip; pen bi biy nup aŋgiy minim yerip yerip aŋgak ak, niŋind yimb aŋgyiŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kun aŋgiy, kuŋaynep Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bi bap tap gak miñmon Beteniy. Yimb nuk ak Lasaras. Bi kun ak, nunay nuk omiŋal mindyiŋgipiyr. Bap Mariya, bap Mata. ");
INSERT INTO kmh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariya mey, biyn Jiysis nup tomb kind ak wel soŋgñiy, jun kas nuk wiykyokak ak. ");
INSERT INTO kmh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasaras nup kun giy tap gek, nunay omiŋal Jiysis nup minim piŋiy yokiy aŋgrik, “Biyomb! Buŋgiy nak anup, tap yomb yimb gip aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pen Jiysis minim aŋgyokrik kun ak niŋiy aŋgak, “Nup tap gip kun ak pisnep kumnimuŋ aŋgiy ma gip. Pen Bapiy nuk key niŋimb rek gek, biynimb gok yimb nup ak sek, Ñinuk nup yimb ak sek dand araniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jiysis nuk Mata, Mariya, Lasaras kuyipyakam wasemb ayiŋgip ak pen; ");
INSERT INTO kmh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","minim kun ak niŋiy, kasek ma amnak; miñmon mindyiŋgip kun okok minek omiŋal sek mindiy, ");
INSERT INTO kmh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","binuk gok kuyip aŋgak, “Tip ak Jiwdiya amnun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kun aŋgek, binuk gok aŋgyak, “Tiysa. Menikarik namb siŋbiy, Jiwdiya biyomb gok nip kamb jiw pikniŋg geyak ak pen; tip ak miñmon kun okok amniŋg gispan?” ");
INSERT INTO kmh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aŋgeyak aŋgak, “Nimb niŋbim: minek nokom bap, tapin mindiy kisyim wip. Kun ak biynimb melik sek giraŋgeniŋgambay gok, melik ak niŋyiŋg taŋgeniŋgambay rek, tap gunap tawey pilachakek, ma gindam pikniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pen kisyimken giraŋgiy, melik ma niŋniŋgambay rek, tap gunap tawey pilachakek, gindam pikniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jiysis kun aŋgiy, minim bap pen aŋgak, “Mam chin Lasaras wisin kinjap ak amiy, nup aŋgen tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aŋgek, binuk gok aŋgyak, “Biyomb. Nuk kinjap apan ak suŋ ayniŋgamb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jiysis Lasaras kumimb aŋgiy aŋgak ak pen, kiyk aŋgniŋyak-eŋ, yikop wisin kinek kun asap aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Binuk gok ma niŋey, kuyip miseŋ aŋgiy aŋgak, “Lasaras kumimb. ");
INSERT INTO kmh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pen nuk yip ma minden kumak kun ak, nimbip nen aŋgiy miñmiñ gispiyn. Yenen, nup gen tikjakek, yip Gor Ñinuk aŋgiy gosimb niŋniŋgambim nen, amnun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aŋgek, Tomas yimb nuk bap Didiymas, numam gunap kuyip aŋgak, “Kun ak chin Tiysa yip amiy, maŋgiysek kumjun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pen kiyk Beteniy amjakeyak, Jiysis nup aŋgyak, “Lasaras kumek komnuk ak, ñin omiŋal omiŋal pandikip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pen miñmon Beteniy kun ak, Jerusalem maŋ siŋak ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lasaras kumek, Jiwda biynimb kuŋaynep, ap Mata yip, Mariya yip kuyip simb niŋiy aymindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pen Mata Jiysis asaw aŋgey niŋiy, nunay Mariya nup korip ak kirgiy, ");
INSERT INTO kmh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","nuk am Jiysis nup niŋiy aŋgak, “Biyomb. Biy mindembinap rek, mam yand ak ma kumbikop. ");
INSERT INTO kmh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pen yand niŋbiyn: miñiy Gor nup aŋgniŋeniŋgamban, aŋgniŋgamban rek giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aŋgek, Jiysis aŋgak, “Namam tip ak tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Aŋgek aŋgak, “Yand niŋbiyn. Ñin kisen ak apek, tikjakniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aŋgek, nup aŋgak, “Kumiy tikjakpay ak sek, perper mindpay ak sek junj ak mey yand mindpiyn. Biynimb yip gosimb niŋbay gok, kumiy pisnep ma kumniŋgambay; ");
INSERT INTO kmh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yip gosimb niŋniŋgambay rek, kim mindiy perper nep mindeniŋgambay. Minim ar kun ak niŋban?” ");
INSERT INTO kmh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aŋgek, “Yaw. Biyomb! Nip niŋbiyn; nand mey Kiyŋ yomb key yimb Gor Ñinuk mankumb biy winiŋgamb aŋgyiŋgipay anep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pen Jiysis Mata nup, nanay akay aŋgiy aŋgniŋek, andkind nunay Mariya mindek ak amiy, nup timund simb tikiy aŋgak, “Tiysa nip akay aŋgiy aŋgniŋsap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Aŋgek, Mariya minim kun ak niŋiy, kasek tikjakiy, nup niŋniŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jiysis pen korip ma owak; Mata niŋak tip siŋak nep mindek. ");
INSERT INTO kmh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariya nuk kun giy kasek amek, biynimb nuk yip mindeyak gok aŋgniŋyak-eŋ, chip kawrumb ar ak amjap aŋgiy, kisen amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya am nup niŋiy, mindek ak jun paŋgiy aŋgak, “Biyomb. Biy mindembinap rek, mam yand ak ma kumbikop aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pen Mariya sek, Jiwda biynimb nuk yip wiyak gok sek siy aŋgeyak, Jiysis nup miker yimb gek aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Nup kombim akay?” Aŋgek aŋgyak, “Apey am niŋun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jiysis pen siy ñiŋg tikdam yokek, Jiwda biynimb gok niŋiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","“Niŋim! Lasaras nup wasemb yimb ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gunap pen aŋgyak, “Nuk bi windin koy gip gok gek windin yimb niŋbay rek; yenen tap nup gak kun ak gek ma suŋ ayak?” ");
INSERT INTO kmh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","39","Kun aŋgeyak, Jiysis nup tip ak miker yimb gek, Lasaras nup komyak bindoŋ amiy aŋgak, “Kamb yomb di chip kaw pil giyak ak diyokim aŋgak.” Aŋgek, bi Lasaras kumak kun ak, nunay Mata aŋgak, “Biyomb. Chip ak kumek komonuk, ñin omiŋal omiŋal pandikip ak, kuyrimey yimb winiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aŋgek, pen aŋgak, “Nip yerip aŋgambiyn? Yip gosimb niŋmindiy mey, Gor key yimb gek niŋniŋgamban apiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kun aŋgek, kamb ak diyokey, Jiysis kuyoŋgiy niŋiy aŋgak, “Bapiy. Nip per aŋgniŋen yip niŋban ak pen; ");
INSERT INTO kmh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","miñiy aŋgniŋsipiyn ak, biynimb guniy nak nep yip yokpan ak, niŋrep giniŋgiy aŋgiy aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kun aŋgiy, meŋg miŋgan dand araniy aŋgak, “Lasaras. Mis awan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aŋgek, chech nup pipkomiy dam kaw diyak gok, kun giy mindakniŋ, mis owak. Apek, Jiysis aŋgak, “Chech nup jun biyoŋ pipkomyak ak sek, ñin tomb okok pipkomyak gok sek wisik yokim aŋgak.” Aŋgek, aŋgak rek giyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jiwda biynimb Mariya nup niŋniŋg wiyak kun gok, kuŋaynep rek Jiysis Lasaras nup gek tikjakak ak niŋiy, Gor nep nup yokek wak aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pen gunap andkind bi Peresiy gok mindeyak ak amiy, Jiysis gak kun ak aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aŋgñey, bi Peresiy gok sek, bi Gor nup simboŋgep yomb gok sek Jiwda kanjsol miytiyŋ ak, ap nan-giy aŋgyak, “Bi kun ak tap mageprek gisap ak, yerginjun? ");
INSERT INTO kmh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Niŋiy kirgon; nuk kun anep gek amek, biynimb maŋgiysek nup biyomb chin Gor yokek wip aŋgey, Rom biyomb gok kiyŋ kiyk bap key aŋgaysipay aŋgiy, chinup girimey giy, Gor aŋgniŋep korip chinup ak girimey giy giniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pen simiy nokom kun anep, binak Kayapas nup aŋgayeyak, nuk bi Gor nup simboŋgep yomb yimb ak mindek. Nuk miytiyŋ namb ak tikjakiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“Nimbip sakiy ayip? Bi nokom bap kumek, chin maŋgiysek kim amemb rek ayniŋgamb ak, tep yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pen aŋgak kun ak, key ma aŋgak; nuk simiy kun ak bi Gor nup simboŋgep yomb yimb mindek ak mey, Gor niŋiy gek, Jiysis Jiwda biynimb gok kuyip nen kumniŋgamb aŋgiy minim kun ak aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pen Jiwda nep mer: Jiysis Gor ñapan nuk miñmon okok maŋgiysek di jimñiy ay, kiñiŋ nokom yimb mindeniŋgiy rek ayek, minim kun ak aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pen Jiwda biyomb kun gok, ñin kun ak tikiy Jiysis nup yerer giy ñaŋgjun aŋgiy, aŋg amiy apiy giyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nup ñaŋgniŋg gey mey, miñmon Jiwdiya mindiy miseŋ ma giraŋgyiŋgip. Binuk gok yip jiw am, dawin Yeprim biynimb kuŋay ma mindyiŋgipay gol siŋak mindyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pen Jiwda ñin yomb Pasopa aŋgyak ak maŋmaŋ gakniŋ, suŋ mindonjun aŋgiy, biynimb kuŋaynep miñmon siskoy kiyk okok nimb Jerusalem apiy, Gor nup tap gunap pik simboŋg ñiyiŋg mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pen ap Gor aŋgniŋep korip miŋgan ak mindiy, Jiysis nup niŋun aŋgiy, pen aŋgniŋek pen aŋgniŋek giy aŋgyak, “Nimb yerip gos niŋbim? Nuk Pasopa ñin biy winiŋgamb akaŋ mer aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yenen: Bi Gor nup simboŋgep yomb gok sek, bi Peresiy gok sek minim kilis bap aŋgiy aŋgyak, “Nimb Jiysis nup niŋiy, ap chinup aŋgenimimb, nup am dand winiŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasopa tap ñiŋniŋg giyak ak, ñin onep kaŋgol anep mindakniŋ, Jiysis Lasaras nup gek tikjakak miñmon ak amnak. Miñmon kun ak yimb Beteniy. ");
INSERT INTO kmh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Amek, tap yomb ñiŋun aŋgiy, Lasaras ak, Jiysis ak, biynimb gunap sek pom yomb ar ak bisiŋg mindyakniŋ, Mata keñmaŋgiy gok bilok ñak. ");
INSERT INTO kmh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nunay Mariya pen, wel kuyrep maniy yomb yimb tawpay bap dapiy, Jiysis tomb ar ak soŋgñiy, jun kas nuk ak diy wiykak. Kun gek, wel kuyrep kun ak, korip miŋgan kun ak maŋgiysek tawek amek, ");
INSERT INTO kmh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jiwdas Yiskariyot, Jiysis binuk, nup kisen mimuŋg gak ak aŋgak, ");
INSERT INTO kmh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Maniy yomb yimb tawpay wel kun biy rek yokiy, maniy diy, biynimb tap ma mindip gok kuyip ñimbinup ak tep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nuk kun aŋgak ak pen, biynimb tap ma mindip gok kuyip ñiniŋg ma aŋgak; maniy wand ak dand taŋgiy, gunap kapkap siy diyiŋgip rek kun aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pen Jiysis aŋgak, “Mariya nup ma aŋg gan. Wel kun ak yip komniŋgambay ñin ak ayñiniŋg dayak ak mey, miñiy dap ayñimb. ");
INSERT INTO kmh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pen nimb biynimb yimgeprek gok yip, per mindeniŋgambim; yand nimb yip per ma mindeniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jiysis ap mindip miñmon Beteniy aŋgey niŋiy, Jerusalem biynimb kuŋaynep niŋniŋg wiyak. Pen nup nep niŋniŋg ma wiyak; Lasaras bi Jiysis gek tikjakak anup kunep niŋniŋg wiyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pen Lasaras nup gek tikjakak rek, biynimb kuŋaynep Jiysis nup gosimb niŋeyak, bi Gor nup simboŋgep yomb gok, Lasaras nup kunep ñaŋgun aŋgiy gos ak niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Minek, biynimb Pasopa tap ñiŋniŋg wiyak gok, Jiysis Jerusalem asaw aŋgey niŋiy, ");
INSERT INTO kmh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nup am niŋun aŋgiy, alband kas tik dand apyiŋg, suk yomb aŋgyiŋg aŋgyak: “Gor nup yimb ak dand aranjun! Binuk, chinup Yisrel biynimb kond mindeniŋgamb ak yokek wip. Bi kun biy mey: kiyŋ chin mindeniŋgamb. Gor nup kond mindonimuŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jiysis doŋgiy marip ar bisgiy amnak ak; Baybol buk ak nind tikiy aŋgyak rek nep gak. Minim kun ak tikiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sayon biynimb. Ma piriknimimb. Kiyŋ nimb ak doŋgiy marip ar ak bisgiy asaw aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gak ñin kun ak, binuk gok Gor giniŋgamb aŋgak rek nep gisap aŋgiy ma niŋyak; pen kisen Jiysis kumiy tikjakek mey, Baybol buk ak tikiy aŋgyak rek giyak kun ak, niŋrep yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pen biynimb Jiysis Lasaras nup gek tikjakek niŋyak gok, minim kun ak aŋg amiy apiy gi mindeyak ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","biynimb kuŋaynep tap mageprek gak kun ak niŋiy, Jerusalem kirgiy, nup kinjeŋnamb ak niŋniŋg amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pen bi Peresiy gok niŋiy, kiyk nep minim aŋgiy aŋgyak, “Niŋim! Gi mer niŋiy kirpun. Biynimb mankumb biy maŋgiysek nup kindik gispay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pen Pasopa ñin ak asaw aŋgiy, Gor nup simboŋgniŋg Jerusalem wiyak ñin kun ak, Griyk biynimb gunap sesek wiyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Biynimb kun gok, bi Piyliyp miñmon nuk Betsayda Galiyliy propens nimb ak mey, ap nup niŋiy aŋgyak, “Buŋgiy. Chin Jiysis nup niŋniŋg aswun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kun aŋgey, Piyliyp am Enjriw nup minim kun ak aŋgñiy, omiŋal giy amiy Jiysis nup aŋgñirik. ");
INSERT INTO kmh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aŋgñer, Jiysis aŋgak, “Miñiy Bi bap Ñinuk ñin yomb nuk ak wip ak mey, Nop gek yimb nup dand araniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nimbip niŋind yimb aspiyn. Wiyt maŋgiy ak man biyaŋ yapek lum ñey nep, jakiy maŋgiy kuŋaynep piyniŋgamb. Pen man biyaŋ ma yowniŋgamb ak, tap bap ma giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Biynimb man ar biy mindrep ginjun aŋgiy nep niŋiy gey amniŋgamb gok, mindrep ma giniŋgambay; pen biynimb man ar biy mindrep giniŋgambun akaŋ, mindrep ma giniŋgambun ak tap yikop aŋgiy niŋniŋgambay gok; permindep ak diniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pen biynimb yip direp giniŋg, minim yip ak kindik giniŋgiy. Yip chiŋgiy mey; akay mindeniŋgayn ak, yip nep mindoniŋgambun. Pen Bapiy biynimb yip direp giniŋgambay gok kuyip direp giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Miñiy yip miker gisap ak yerip aŋgnim? Bapiy yip miker ñiniŋg gispan ak, kirgan aŋgnim? Mer! Kun ma aŋgnim. Miker kun ak diniŋg ownik. ");
INSERT INTO kmh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bapiy! Gos nand niŋban rek yip gey, yimb nip ak aranimuŋ aŋgak.” Kun aŋgakniŋ, minim bap semb biyoŋ nimb aŋgak, “Yand genik yimb yip aranak ak pen; tip ak kunep geniŋgayn aranek niŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pen biynimb mindeyak gok minim kun ak niŋiy, gunap aŋgyak, “Timuk asap aŋgyak,” gunap aŋgyak, “Enjol ak, Jiysis nup minim gunap aŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kun aŋgeyak, Jiysis kuyip aŋgak, “Minim kun ak yip niŋaŋ aŋgiy ma aŋgip, nimbip niŋim aŋgiy aŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yenen: miñiy biynimb gok kuyip aŋgiy giniŋgayn rek, Gor kuyip pen giniŋgambay ar ak niŋiy mey, kuyip bilok keykey ayniŋgamb. Miñiy gen, bi biynimb mankumb biy nimb gok kuyip kond mindip ak, apyap pikniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yip mon kiros bak biyoŋ ñaŋgbirik ayey, arachak Bapiy ker amen mey, biynimb miñmon keykey yip gosimb niŋniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pen Jiysis minim aŋgak kun ak, chinup nen aŋgiy kumniŋgamb rek aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pen biynimb kuŋaynep ap mindeyak kun gok, nup pen aŋgyak, “Low minim buk chin ak tikiy aŋgyak, Jiwda Kiyŋ yomb key yimb ak pernep mindeniŋgamb aŋgayak ak pen, yergiy apan, ‘Bi bap Ñinuk nup mon kiros bak biyoŋ ñaŋgbirikniŋgambay apan?’ Pen Bi bap Ñinuk apan ak, anup apan?” ");
INSERT INTO kmh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","36","Aŋgey aŋgak, “Bi meliksek ak, nimb yip yep sikoy won bap nep mindeniŋgamb. Mindip won biy nup chiŋgiy mey, melik pis ak mindiy, akay amjipun aŋgiy niŋrep giniŋgambim. Mer ak, kisyim ap nimbip yiwiŋg dek, piŋiy aran apyan gi mindeniŋgambim. Kun ak, bi meliksek ak nup mindip won biy chiŋgiy, biynimb meliksek gok mindenimimb aŋgak.” Jiysis minim kun ak aŋgiy, nup miluk niŋyak rek, yip ma niŋyaŋ aŋgiy am wikan bap key weyiŋg mindek. ");
INSERT INTO kmh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tap mageprek gok windin yirik ar kuyip ak gek niŋyiŋgipay ak pen; nup gosimb ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Giyak kun ak, bi Gor minim aŋgep Asaya Baybol buk tikiy aŋgak rek nep giyak. Minim kun ak tikiy aŋgak: “Biyomb. Minim nip kuyip aŋgñimbun ak ma dipay. Pen nand gipan ar ak niŋiy, nip gosimb ma niŋbay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pen nup gosimb ma niŋyak kun ak, Asaya minim ar bap tikak rek giyak. Tikiy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gor Yisrel biynimb gok kuyip gek, windin koy rek mindey, kuyip gos timund teprep ak ma ñiniŋgamb. Yenen: nuk aŋgak, kuyip gen windin ma niŋiy, gos timund teprep ak ma niŋiy, nup ker amon chinup suŋ ayniŋgamb aŋgiy, yip ker ma winiŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asaya wosrey minim aŋgiy tikak kun ak, Jiwda Kiyŋ yomb key yimb ak bi teprep mindip rek ak day niŋiy tikak. ");
INSERT INTO kmh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pen maŋgiysek Krays nup ma kirgiyak. Bi yomb yomb gunap sek nup gosimb niŋyak ak pen; bi Peresiy gok chinup pisnep aŋgyokey, kisen nan-gep korip ak ma amniŋgambun aŋgiy, nup gosimb niŋyak ak pen, biynimb gok kuyip miseŋ ma aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Giyak kun ak; Gor niŋek tep ginimuŋ ar ak kirgiy, biynimb gok yimb chinup dand araniyaŋ aŋgiy giyak. ");
INSERT INTO kmh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pen Jiysis meŋg miŋgan dand araniy aŋgak, “Biynimb an yip gosimb niŋniŋgamb ak, yip nep mer; Bi yip aŋgyokek winik ak nup kunep gosimb niŋniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yip niŋiy mey, Bi yip aŋgyokek winik ak nup kunep niŋbay. ");
INSERT INTO kmh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yand biynimb mankumb biy, melik kiyk ak opiyn. Biynimb yip ker opay gok, kisyimnamb okok ma mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yand winik ak biynimb okok kuyip kor giniŋg ma winik; di Bapiy yip jimñiy ayniŋg winik. Biynimb minim yip niŋiy ma diniŋgambay gok, kuyip kor ma giniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pen biynimb minim yip kirgiy, yip ma dipay gok ñin yomb kisen ak apek, Bapiy minim aŋgñimbiyn ar ak diy, kuyip kor giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","50","Yenen: minim apiyn gok, key niŋiy ma apiyn; Bapiy minim nup ak niŋey, nuk gek perper mindeniŋgiy aŋgiy, minim nup ak diy apiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ñin yomb Pasopa ak toy rek mindakniŋ, miñiy rek ak siypsiyp ñiluk ma ñiŋyak won ak, Jiysis niŋak: Nop nup mankumb biy aŋgayak ñin ak pandikek, andkind Nop ker amemb ñin ak owak. Pen biynimb nuk man ar biy wasemb yimb ayiŋgip gok, wasemb ayiŋg nep mind mind, nup ñaŋg ayey kumiy Nop ker amnak. ");
INSERT INTO kmh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Seytan pen, Saymon ñinuk Jiwdas Yiskariyot nup gos ñek, Jiysis nup yergiy di biyomb gok kuyip ñiniŋgayn aŋgiy, gos ak nind nep niŋek; kisen mey tap ñiŋniŋg bisgiyak. ");
INSERT INTO kmh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Gor tap yerip yerip okok maŋgiysek di Ñinuk nup ñin ar ak ayak ak mey, kumiy andkind Nop ker amniŋg gak rek niŋiy, ");
INSERT INTO kmh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tikjak chech paryomb nuk ak tuŋgasikiy, tawil ak simbnaŋg rek poŋgay, ");
INSERT INTO kmh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ñiŋg ak diys miŋgan ak paŋgiy, binuk gok kuyip tomb ñiŋg ay yokyiŋg, tawil paŋgak kun ak wiykyiŋg gak. ");
INSERT INTO kmh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kun gi dap dap, Saymon Piyta tomb nup ak ñiŋg ay yokiyn aŋgek aŋgak, “Biyomb. Tomb yip ak ñiŋg ay yokniŋg gispan?” ");
INSERT INTO kmh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aŋgek, Jiysis aŋgak, “Miñiy gispiyn ak ma niŋban ak pen, mindiy niŋniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aŋgek, Piyta aŋgak, “Biyomb! Tomb yip ak ñiŋg ma ay yokniŋgamban. Mer yimb aŋgak.” Aŋgek, Jiysis aŋgak, “Tomb nip ma ñiŋg ay yokniŋgayn ak; bi yand yimb ma mindeniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aŋgek, Saymon Piyta aŋgak, “Biyomb! Tomb yip anep ma ñiŋg ay yoknimin; ñin kind gok sek, jun ak sek ñiŋg pikñinimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","11","Kun aŋgak ak pen, Jiysis aŋgak, “Biynimb gok ñiŋg pikyokey, mumbwak okok maŋgiysek tep mindip ak pen; kinjeŋ giraŋgey tomb kind ak gach gip rek, tomb kind anep ñiŋg ay yokpay aŋgak.” Pen Jiysis bi nup mimuŋg giniŋg gak ak niŋak ak mey aŋgak, “Nimb gunap gach ma mindip; nokom bap nep gach sek mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pen tomb kuyip ak ñiŋg ay yokdiy, chech tuŋgasik ayak ak ay, am bisgiy aŋgak, “Nimbip tomb ñiŋg ay yokpiyn minim kiñiŋ ak, niŋbim akaŋ? ");
INSERT INTO kmh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yip Tiysa aŋgiy, Biyomb aŋgiy gipim ak, niŋind apim. ");
INSERT INTO kmh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kun ak yand Biyomb mindiy, tomb nimbip ñiŋg ay yokpiyn ak, nimb namam gunap kuyip tomb ak ñiŋg ay yoknimimb. ");
INSERT INTO kmh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","16","Nimbip niŋind yimb aspiyn: biyomb kond mindep gok sikoy, biynimb woŋg kuyip giñimbay gok yomb ma mindpay. Pen bi minim yokpay gok sikoy, biynimb minim kuyip dand ambay gok yomb ma mindpay. Kun ak yand Biyomb nimb mindiy, monmon woŋg giñimbiyn rek, nimb kunep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Miñ tep ar kun ak aŋgñambiyn niŋbim ak mey; ar kun ak gem amek tep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Pen nimbip dipiyn gok, niŋrep gipiyn ak mey, maŋgiysek gek tep giniŋgamb aŋgiy ma aspiyn. Bi bap yip mimuŋg giniŋg gisap ak, Baybol buk ak tikiy aŋgyak rek nep giniŋgamb. Minim kun ak tikiy aŋgyak, ‘Bi yand yip tap jimñiy ñimbur ak, tuŋgandikiy yip timey gisap aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nimbip nind kun giy aspiyn ak mey, kisen gek, Biyomb aŋgak rek nep gisap aŋgiy, yand Biyomb yerip rek mindpiyn ak niŋiy, yip gosimb niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Pen nimbip niŋind yimb aspiyn: biynimb yand gunap aŋgyoken amey, biynimb kuyip dipay gok, kuyip nep mer; yip sek dipay. Pen yip dipay gok, yip nep mer; Bi yip yokek winik anup sek dipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jiysis minim kun ak aŋgek, nup miker yimb gek aŋgak, “Nimbip niŋind yimb aspiyn: nimb bap yip mimuŋg gem ñaŋgniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kun aŋgek, binuk gok an nup asap aŋgiy, gos par ayiŋg penpen niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pen Jiysis binuk wasemb yimb ayiŋgip ak, kiñiŋ siŋak bisiŋg mindek ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saymon Piyta bi kun anup ñin anep yomiy aŋgak, “An nup asap ak aŋgniŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aŋgek, Jiysis mindek siŋak bibeŋind amiy aŋgak, “Biyomb! Bi kun ak an nup apan?” ");
INSERT INTO kmh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aŋgek aŋgak, “Bi biret ak diy, ñiŋg sup biyaŋ tawiy ñiniŋgayn anep aŋgak.” Kun aŋgiy biret ak diy, di ñiŋg sup biyaŋ tawiy, di Saymon ñinuk Jiwdas Yiskariyot nup ñek ñiŋak. ");
INSERT INTO kmh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Seytan pen won kun anep, ap Jiwdas nup molik sikakniŋ, Jiysis nup aŋgak, “Giniŋg gispan ak, kasek gan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","Aŋgek, Jiwdas mis amnakniŋ, day kisyim owak. Pen binuk gunap, Jiwdas nup yenen kun asap aŋgiy ma niŋyak. Kiyk aŋgniŋyak-eŋ, nuk maniy wand kond mindip rek, Pasopa tap ñiŋniŋgambun gok tawaŋ aŋgiy akaŋ; biynimb tap ma mindip gok kuyip, maniy gunap ñaŋ aŋgiy asap aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jiwdas kun giy mis amnakniŋ, Jiysis aŋgak, “Miñiy bi bap Ñinuk, Nop aŋgip rek geniŋgamb mey, Nop gek yimb nup araniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pen Ñinuk yimb ak araniŋgamb rek, Nop yimb ak kunep araniŋgamb ak mey, miñiy ñin biy nep Nop gek, Ñinuk nup yimb ak araniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ñapan yand guniy! Nimb yip tapin ma mindeniŋgayn. Amen, yip piyow mer niŋniŋgambim. Jiwda kay kuyip apiyn rek, nimbip kunep aspiyn. Yand amjipiyn ar ak, kisen amnimimb rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Pen miñiy nimbip low kisenimb bap aŋgñiniŋg gispiyn. Low kisenimb kun ak mey, nimb key penpen wasemb aynimimb. Yand nimbip wasemb aypiyn rek, nimb kunep penpen wasemb aynimimb. ");
INSERT INTO kmh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kun geniŋgambim, biynimb gok yip ker mindpim ak niŋrep giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kun aŋgek, Saymon Piyta aŋgak, “Biyomb. Nand akay amniŋg gispan?” Aŋgek, Jiysis aŋgak, “Yand amjipiyn okok miñiy yip kindik ginimin rek ma ayip. Pen kisen mey, yip kindik giniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aŋgek, Piyta aŋgak, “Yenen nip miñiy kindik ma giniŋgayn? Nip konden yip ñaŋgayniŋgambay ak, minim ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aŋgek, Jiysis pen aŋgak, “Nand yip nen kumiyn aŋgiy gos nokom niŋban? Nip niŋind yimb aspiyn; kakaruk kisen suk aŋgniŋgamb; nind nep, yand nup ma niŋbiyn aŋgiy, won omiŋal nokom aŋgniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pen Jiysis aŋgak, “Gos yomb ma niŋnimimb. Bapiy nup gosimb niŋiy, yip gosimb niŋiy ginimimb. ");
INSERT INTO kmh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bapiy korip nuk ak, tip kuŋaynep mindip. Yand amiy, tip nimbip wikan gunap gayrep geniŋgayn. Pen tip kuŋay ma mindombikop ak, nimbip ma apnip. ");
INSERT INTO kmh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yand am tip nimbip ak gayrep giy mey, apiy nimbip poŋind amniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Amniŋg gispiyn kinjeŋ ar ak nimb niŋbim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jiysis kun aŋgek, Tomas aŋgak, “Biyomb! Akay amjipan? Chin ma niŋbun. Kun ak yergiy, kinjeŋ amniŋgamban ar kun ak niŋiy amniŋgambun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aŋgek aŋgak, “Yand nep mey, kinjeŋram ak; yand nep mey minim yipul yimb ak, yand nep mey, gen biynimb perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yip niŋrep giy mey, Bapiy nup kunep niŋrep gipkip. Pen maŋ mindip, yip niŋrep giniŋgambim rek, nup kunep niŋrep giniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kun aŋgek, Piyliyp aŋgak, “Biyomb! Nap nup chinup yomniŋgamban ak, tep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aŋgek, Jiysis aŋgak, “Piyliyp. Nimb yip per mindpiyn ak pen, yip ma niŋiy kun aspan? Biynimb yip niŋbay gok, Bapiy nup niŋbay. Kun ak yergiy aspan, ‘Bapiy nup chinup yomey niŋjun aspan?’ ");
INSERT INTO kmh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yand Bapiy yip mindpiyn; nuk yand yip mindip. Kun ak yenen, Nop yip apiymiŋay giy mindpiyr aŋgiy gos ak ma niŋban? Minim nimbip apiyn gok, yand keynep ma apiyn; Bapiy yip apur. Pen tap yerip yerip gipiyn gok, keynep ma gipiyn; Bapiy yip nep gipur. ");
INSERT INTO kmh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kun ak yand Bapiy yip mindpiyn; nuk yand yip mindip minim ak, niŋind aŋgiy niŋnimimb. Pen gos kun ak niŋep rek ma ayek, yerip yerip gipiyn gok niŋiy, Nop yip mindiy mey, kun gip aŋgiy gos ak niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nimbip niŋind yimb aspiyn: Biynimb yip gosimb niŋniŋgambay gok, yand gipiyn rek giniŋgambay. Pen Bapiy ker amniŋgayn rek, nimb biy mindiy key yimb giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Jiysis mindip rek nip aŋgniŋsipun aŋgiy, Bapiy nup aŋgniŋeniŋgambim, yand yimb nup aranaŋ aŋgiy, aŋgniŋgambim rek giniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kun ak yimb yip ak diy aŋgniŋem, aŋgniŋgambim rek giniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Yip wasemb ay mey, minim yip ak kindik giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yand Bapiy nup aŋgniŋen, bi Noman nuk ak yokek apiy, nimb yip perper mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bi Noman kun ak mey, Gor Kawnan minim yipul yimb aŋgip ak nep. Biynimb yikop Gor ker ma mindpay gok, bi kun mey ak aŋgiy ma niŋbay; windin kunep ma niŋbay; aŋgniŋey kuyip bak aynimuŋ rek ma ayip. Pen nuk nimb yip mindiy, kisen pisnep bak ay mindeniŋgamb ak; nup niŋbim. ");
INSERT INTO kmh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kun ak nimbip pisnep kiriŋg amen, biynimb yimgeprek ma mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Biynimb yikop Gor ker ma mindpay gok, yip yep won bap nep niŋiy, kisen ma niŋniŋgambay. Pen yand bi kim mindep ak, kim mindeniŋgayn rek; nimb kunep kim mindiy, yip niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ñin kun ak, yand Bapiy yip mindpur ak niŋrep giniŋgambim. Nimb yand yip mindpim, yand nimb yip mindpiyn ak; kunep niŋrep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nimb biynimb minim yip niŋiy dipim gok, yip wasemb ay mey minim yip dipim. Pen yip wasemb aypim rek, Bapiy nimbip kunep wasemb ayip. Yand pen nimbip wasemb aypiyn rek, nimbip Gor Kawnan ak yoken, yip niŋrep giniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jiysis kun aŋgek, Jiwdas nup mimuŋg gak ak mer: Jiwdas bap nup aŋgak, “Biyomb! Yergiy chin nip niŋrep giniŋgambun: pen biynimb yikop gok nip ma niŋniŋgambay?” ");
INSERT INTO kmh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aŋgek aŋgak, “Biynimb yip wasemb aypay gok, minim apiyn ak niŋdipay. Kun giy niŋdey mey, Bapiy chirapiy kuyip wasemb ay, ap kiy yip mindiy, kond mindpur. ");
INSERT INTO kmh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Biynimb yip wasemb ma aypay gok, apiyn rek ma gipay. Minim yip ma dipay kun ak, minim yand mer; Bi yip aŋgyokek winik ak, minim nup ak ma dipay. ");
INSERT INTO kmh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nimb yip mindpiyn ñin biy, minim kun biy aŋgñispiyn. ");
INSERT INTO kmh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amen; Bapiy nuk pen, bi Noman nimbip apiyn ak yokeniŋgamb mey, nuk apiy nimbip kond mindakniŋ, minim apiyn gok gos niŋyiŋg nep mindiy, niŋrep yimb giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Amjipiyn rek, nimbip aspiyn: Gor nimbip kond mindeŋ. Minim kun ak biynimb yikop gok monmon apay rek ma aspiyn; Gor nimbip kond mindakniŋ, kapkap mindrep giy, gos yomb ma niŋnimimb aŋgiy aspiyn. Kun ak ma piriknimimb. ");
INSERT INTO kmh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yand amiy andkind winiŋgayn apiyn ak niŋiy, yenen simb gakniŋ mindpim. Am Nop yip mindniŋg gisap aŋgiy, miñmiñ giyiŋg nep mindembikip. ");
INSERT INTO kmh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kun ak nup ker ma ambiyn ñin biy, nimbip aspiyn ak mey, kisen ameniŋgayn, gos okok ma piyow niŋniŋgambim; yip Gor Ñinuk yimb aŋgiy; niŋrep yimb giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Bi biynimb yikop gok kuyip kond mindip ak miñiy asaw ak mey, minim paryomb aŋgnim rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pen bi biynimb yikop gok kond mindip kun ak, kilis nuk ma mindip. Yand Bapiy aŋgip rek giniŋgayn ak mey; Bapiy nup wasemb aypiyn ak niŋrep giniŋgambay. Kun ak apem amnun. ");
INSERT INTO kmh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yand mey miñ wayn junj ak; Bapiy mey bi woŋgday nop nimb ak. ");
INSERT INTO kmh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Alik maŋgiy ma piyip gok, Bapiy nuk timbsak yokip. Pen alik piyrep gip gok, kuŋaynep piynimuŋ aŋgiy timbrik tep gek, kuŋaynep piyip. ");
INSERT INTO kmh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Nimbip minim tep aŋgñen niŋbim rek, suŋrep mindpim ak mey, ma timbsak yokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","6","Pen alik kind gok, junj ak sek jimñiy mindiy nep maŋgiy piyniŋgamb; key mindiy maŋgiy ma piyniŋgamb. “Yand mey miñ wayn junj ak; nimb mey piñ alik gok. Kun ak an yip yimñiy mindeniŋgamb ak, maŋgiy kuŋay yimb piyniŋgamb; pen an yip yimñiy ma mindeniŋgamb ak, mon alik timbsak yokey milip giyapek, di mon daŋgiypay rek ak mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pen minim apiyn gok niŋyiŋg, yip chiŋgiy nep mindem mey; minim yerip aŋgniŋniŋgambim ak; aŋgniŋgambim rek giniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nimb mindrep yimb giniŋgambim rek, biynimb yand mindpim ak niŋiy, Bapiy nup yimb ak dand araniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Bapiy yip wasemb yimb ayip rek, nimbip pen kunep wasemb yimb aypiyn. Kun ak, penpen wasemb ayiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yand Bapiy nup minim ak kindik gen, yip wasemb ayiŋg nep mindip; kun ak minim yip ak kindik giniŋgambim rek; nimbip wasemb ayiŋg nep mindeniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Pen minim aspiyn gok niŋiy mindrep gem mey, yip tep yimb giniŋgamb rek, nimbip kunep giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","13","Pen minim bap aspiyn ak: nimbip wasemb yimb ayiŋg, nimbip aŋgiy kumniŋgayn rek; nimb key kunep penpen wasemb ayiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Apiyn ar ak giniŋgambim rek, buŋgiy yand yimb gok mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Miñiy tikiy, nimbip bi woŋg giñemb ma aŋgniŋgayn; buŋgiy woŋg aloŋg yand gok aŋgniŋgayn. Bi woŋg giñemb gok, kond mindep kiyk ak gisap ar ak, giniŋgamb ar ak aŋgiy, ma niŋbay; pen Bapiy minim yerip yerip yip aŋgñimb gok, nimbip aŋgñimbiyn ak mey, buŋgiy woŋg aloŋg yand mindpim. ");
INSERT INTO kmh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nimb yip dun aŋgiy ma dipik, gos yand key niŋiy, maŋgiy piy perper mindeniŋgamb ak piyniŋgiy aŋgiy, nimbip diy, woŋg ar kun ak yoknik. Kun ak nimb maŋgiy tep gok piyiŋg, Bapiy nup Jiysis biynimb nuk mindpun aŋgiy aŋgniŋeniŋgambim, aŋgniŋgambim rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Kun ak nimbip aspiyn: penpen wasemb ayiŋg mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pen biynimb yikop gok nimbip miluk niŋey, gos yomb kun ak ma niŋnimimb; Jiysis nup miluk niŋyak rek nep chinup gispay aŋgiy niŋnimimb. ");
INSERT INTO kmh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pen miñ ar kiyk ak gembikip, biynimb chin aŋgiy, di wasemb aypiyap. Wosrey nimbip ma dinik ñin ak, miñ ar kun ak gi mindyiŋgipim ak pen, nimbip key niŋiy denik, yip ker mindem, nimbip miluk niŋbay. ");
INSERT INTO kmh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pen niŋbim! Nimbip aŋgnik, ‘Bi kond mindep gok sikoy, biynimb kuyip woŋg giñimbay gok yomb ma mindpay aŋgnik.’ Kun ak yip timey giy, nimbip kunep giniŋgambay. Pen minim yip gok diy rek, minim nimbip gok kunep diniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nimbip monmon giniŋgambay kun ak, biynimb yand mindpim rek kun giniŋgambay. Bi yip yokek winik anup, ma dipay rek kun giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Pen yand ap kuyip minim tep ma aŋgñembinip, tap siy tap timey gipay ak, minim yomb yimb ak ma dipyap. Pen ap kuyip aŋgñirep gen, yip ma dipay ak; minim gunap aŋgiy kim amniŋgiy rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","24","Miker yomb kun ak rek ma dipyap ak pen; ap tap mageprek gok gen niŋiy yip kirpay ak, miker yomb yimb ak diniŋgambay. “Pen yip miluk niŋbay ak, yip nep mer; Bapiy nup kunep miluk niŋbay. ");
INSERT INTO kmh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Gipay kun ak, Depiyt tikiy aŋgak rek nep gipay. Nuk Jiwda kay low chin, low chin apay buk ak tikiy aŋgak, ‘Minim junj mindek mer: yip yikop nep miluk niŋbay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pen yand am Bapiy nup aŋgen, bi Noman apiyn ak nup yokek, ap nimbip kond mindeniŋgamb. Noman minim niŋind nep aŋgip kun ak, yand bi yerip rek ak, nimbip gos ñek niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pen nimb kiñiŋ giy yand yip nep mindpun ak, nimb kunep biynimb gok kuyip, yip bi yerip rek ak aŋgiy aŋgñiniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nimbip minim kun giy apiyn ak niŋrep giy mey, kisen yergek, yip ma kirgiy, ma apyap pikniŋgambim aŋgiy apiyn. ");
INSERT INTO kmh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","3","Yenen: nimbip Jiwda nan-gep korip gok aŋg mis yokiy, tip ma winimimb aŋgniŋgambay. Kun anep mer; kisen Bapiy chirupapiy ma niŋbay rek, gos yesek ar gok niŋiy, Gor nup tep ginimuŋ aŋgiy, nimbip pikayniŋg nep gi mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pen nimbip nind aŋgñispiyn ak mey, kisen yergek niŋiy, aŋgak rek nep gisap aŋgniŋgambim. “Pen nimb yip nep mindyiŋgipiyn rek, minim kun ak ma aŋgnik; ");
INSERT INTO kmh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","miñiy bi yip yokek winik ak ker andkind amjipiyn rek, nimbip aspiyn. Pen nimb bap, akay amjipan aŋgiy, ma aŋgniŋsipim. ");
INSERT INTO kmh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amjipiyn aŋgen niŋiy, mindmaŋgiy nimbip ak piŋiyñiy nep ayek, minim ma aspim. ");
INSERT INTO kmh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pen amjipiyn ak, tep yimb amjipiyn. Yand amen nep mey, bi Noman nimbip kond mindeniŋgamb ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nuk apiy mey, biynimb yikop gok kuyip gos ñek, gach sek mindpay ak niŋiy, yergiy suŋ-tep mindeniŋgambay ak niŋiy, Gor niŋek minim yomb mindip kiñiŋ ak niŋiy giniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kun ak yip gosimb ma niŋbay rek, bi Noman kun ak, kuyip gach sek mindpim aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yand kumiy tikjakiy am Bapiy yip mindeniŋgayn rek, kuyip aŋgniŋgamb, ‘Biynimb suŋ-tep mindniŋg, biynimb suŋ-tep nuk mindeniŋgambim aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pen bi timey biynimb yikop gok kuyip kond mindip ak nup, talak miŋgan ayniŋgsipiyn rek, kunep aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Minim yand kuŋaynep mindip ak pen; minim kun gok miñiy aŋgen, niŋdinimimb rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","14","Pen Gor Kawnan niŋind nep aŋgip ak apiy, minim nuk key gunap diy ma gos ñiniŋgamb; Gor aŋgniŋgamb minim anep gos ñiyiŋg; nimbip kisen giniŋgamb minim ak gos ñek niŋniŋgambim. Nuk minim yipul yimb ak, nimbip gos ñek niŋiy mindrep gem, yimb yip araniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pen Bapiy key, yand key mer; minim chirapiy ak ar nokom yimb mindip ak mey, Gor Kawnan nuk ak nimbip gos ñek, minim yipul yimb yip ak niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Yep won bap mindip, yip ma yimb niŋniŋgambim; pen kisen yep won bap mindiy, tip ak niŋniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Jiysis kun aŋgek, binuk gok kiyk keynep aŋgyak, “Sikoy won bap mindiy, Bapiy ker amniŋgayn; pen sikoy won bap mindiy, yip tip ak niŋniŋgambim aŋgip minim ak yerip?” ");
INSERT INTO kmh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kun aŋgiy, Jiysis nup aŋgniŋniŋg geyak, nuk key niŋiy aŋgak, “Yep won ak yip ma niŋniŋgambim; pen yep won bap mindiy, yip tip ak niŋniŋgambim apiyn ak niŋiy mey, penpen aŋgniŋsipim? ");
INSERT INTO kmh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nimbip niŋind yimb aspiyn: biynimb yikop gok miñmiñ giniŋgambay; pen nimbip simb gek, siy aŋg mindiy, tip ak tep gakniŋ mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Biyn gok ñapan ñiŋakniŋ, gos yomb niŋbay ak pen; won ak tikey, kuyip tep yimb gip. ");
INSERT INTO kmh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nimb biyn ñapan ñiŋakniŋ, gipay kun ak rek gi mindpim ak pen; yip tip ak niŋem nimbip key yimb tep gek, biynimb gunap gey, miñ kun ak puŋgriknimuŋ rek ma ayniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nimbip niŋind yimb aspiyn: ñin kun ak yip ma aŋgniŋniŋgambim. Miker nimbip gunap mindonimuŋ, Bapiy nup Jiysis mindip rek, nip aŋgniŋsipun aŋgiy, aŋgniŋeniŋgambim aŋgniŋgambim rek giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nind kun ak rek ma gipik ak pen, miñiy Jiysis mindip rek, nip aŋgniŋsipun aŋgiy aŋgniŋem, aŋgniŋniŋgambim rek gek, nimbip tep yimb giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Bapiy minim nup ar ak aŋgniŋg, per minim paydoŋ ay apiyn ak pen; miñiy tikiy minim kun ak rek ma aŋgniŋgayn; miseŋ nep aŋgniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ñin kun ak apek, Bapiy nup Jiysis mindip rek, nip aŋgniŋsipun aŋgiy aŋgniŋeniŋgambim, aŋgniŋgambim rek giniŋgamb. Pen minim apiyn kun ak yip aŋgniŋem, yand pen nup aŋgniŋniŋgayn aŋgiy, ma aspiyn. ");
INSERT INTO kmh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bapiy nep yip yokek winik ak niŋiy, yip gosimb niŋbim ak mey, nuk key nimbip wasemb ayip. ");
INSERT INTO kmh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bapiy nep yip yokek, man ar biy winik ak mey, miñiy tip ak nuk ker amjipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jiysis kun aŋgek, binuk gok aŋgyak, “Miñiy minim bak okok ay ma aspan; miseŋ yimb aspan ak mey, ");
INSERT INTO kmh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","chin niŋbun: nand minim okok maŋgiysek niŋban. Biynimb gunap minim aŋgniŋep kiyk mindek, nip ma aŋgniŋbay won ak, key niŋiy kuyip aŋgñimban. Gipan kun ak chin niŋbun: nand Gor yip mindiy winak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kun aŋgeyak, Jiysis aŋgak, “Kun ak miñiy niŋrep gipim? ");
INSERT INTO kmh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Niŋim! Yep maŋ mindip, yip kirgiy keykey amem, key asiy mindeniŋgayn. Pen key asiy ma mindeniŋgayn; Bapiy yip mindpur rek mindoniŋgambur. ");
INSERT INTO kmh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Pen yand yip jimñiy mindiy, gos yomb ma niŋnimimb aŋgiy, nimbip minim aŋgñimbiyn. Lum ar biy mindiy, nimbip miker giniŋgamb ak pen; gos sek mindenimimb. Tap yerip yerip nimbip ginimuŋ rek gok, maŋgiysek di talak miŋgan yand ak ayniŋgsipiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jiysis minim kun ak aŋgjiwiy, kuyoŋgiy niŋiy aŋgak, “Bapiy. Ñin yip aŋgaynak ak miñiy wip. Kun ak yip aŋgnak rek gey, Biyomb minden, yimb nip ak aranimuŋ. ");
INSERT INTO kmh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yip key aŋgnak rek, biynimb okok maŋgiysek niŋmindiy, biynimb yip aŋgaynak gok kuyip den perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tap gunap aŋgniŋbay gok aŋgniŋiy akaŋ; ar gunap key giy perper ma mindeniŋgambay; nand Gor mindpan ak niŋiy, yip yoknak ak niŋiy mey, kuyip dor perper mindeniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Yimb nip aranimuŋ aŋgiy yip woŋg aŋgnak ak; gi dand amiy gi diniŋg gispiyn. ");
INSERT INTO kmh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Miñiy gey kumen, miñmon ma gayruk ñin ak, omiŋal giy Biyomb tep meliksek mindoruk rek mindonjur. ");
INSERT INTO kmh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Biynimb nip gosimb ma niŋeyak yip aŋgnak gok, miñiy yip ker mindpay. Nak ker mindembiyap ak pen, yip aŋgenak mey, yip ker mindpay. Kuyip nand bi yerip rek ak aŋgiy, aŋgñirep gen, nip gosimb niŋiy, minim nip ak diy kisen gipay. ");
INSERT INTO kmh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pen yerer gipiyn ak, keynep ma gipiyn; yip gos ñimban ar ak nep gipiyn ak niŋbay. ");
INSERT INTO kmh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Minim aŋgnimin aŋgnak gok, kuyip aŋgñen niŋbay ak mey; nand nep yip aŋgyokenak winik ak, kunep niŋrep yimb gipay. ");
INSERT INTO kmh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Biynimb yip aŋgnak kun gok, biynimb nand mindpay rek, kuyip kond mindenimin aŋgiy, nip aŋgniŋsipiyn. Biynimb yikop gok kuyip ma aspiyn; biynimb nip ker mindpay gok kuyip, kond mindenimin aŋgiy asipiyn. ");
INSERT INTO kmh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Biynimb yand gok key, biynimb nand gok key mer, biynimb chirapiy ak mey, yimb yip dand aranbay. ");
INSERT INTO kmh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Pen mindpan ak niniŋgayn rek, kiyk keynep mindeniŋgambay. Bapiy Gor. Nand Biyomb mindpan rek, yip aŋgenak kunep mindpiyn ak mey, chirapiy bi nokom rek ayip. Kun ak rek kuyip kond mindenimin, kiñiŋ nokom jimñiy mindeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yand kiy yip nep minden, bap ma kurgip; maŋgiysek nip chiŋgiy mindpay. Bi yiwur diyn aŋgiy niŋimb anep, Baybol buk giniŋgamb aŋgiy tikyak rek, nip ker ma mindip. ");
INSERT INTO kmh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Pen mindpan ak niniŋg gispiyn rek, miñiy kiyk niŋmindyakniŋ, nip minim kun biy aŋgniŋsipiyn. Aŋgniŋsipiyn kun ak niŋey, yip tep gisap rek, kuyip kunep ginimuŋ aŋgiy aspiyn. ");
INSERT INTO kmh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Minim nip ak aŋgñen niŋbay rek, biynimb yikop gok, kuyip miluk niŋbay. Yand bi yikop nip gosimb ma niŋimb bap rek ma mindpiyn ak mey, kiyk kunep mindey kuyip miluk niŋbay. ");
INSERT INTO kmh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pen kuyip dand amey, biynimb yikop gok yip ma mindeniŋgiy aŋgiy ma aspiyn; kuyip man ar biy kond mindenimin, Seytan gek timey ma giniŋgiy aŋgiy aspiyn. ");
INSERT INTO kmh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yand bi yikop nip gosimb ma niŋimb bap rek ma mindpiyn ak mey, kiyk kunep mindpay. ");
INSERT INTO kmh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","18","Nand biynimb yikop gok kuyip gos niŋiy yip yokenak winik rek; yand pen, biynimb yand yimb gok, biynimb yikop gok kuyip nen miñmon keykey yoksipiyn. Kun ak kuyip gey suŋ-tep mindiy, minim yipul yimb nip ak niŋnep mindyiŋg, nip marik giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yand bi marik nand yimb mindpiyn rek, kuyip aŋgiy yiwur den, kiyk kunep biynimb marik nand yimb gok mindeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kuyip nep ma aŋgniŋsipiyn; kiy minim aŋgey, yip kisen gosimb niŋniŋgambay gok kuyip sek nip aŋgniŋsipiyn. ");
INSERT INTO kmh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chirapiy keykey mer, bi nokom yimb mindpur rek, biynimb yip gosimb niŋbay gok, maŋgiysek jimñiy kun ak rek mindey, biynimb yikop gok niŋiy, nand nep yip yokenak winik ak niŋniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yip gey, nand bi teprep mindpan rek mindpiyn ak; kuyip kun ak rek gen, chir jimñiy mindpur rek mindeniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kun ak nand, yand yip nep mindpan rek, yand kiy yip nep minden mey; kiyk jimñiy mindeniŋgiy. Jimñiy mindyakniŋ, biynimb yikop gok nand nep yip yokiy, yip wasemb ay, biynimb yip gok kuyip wasemb ay gipan ak niŋniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Bapiy! Yip tep gip ak; biynimb yip aŋgnak gok, yand yip nep mindiy mey; miñmon ma alwol gayruk ñin ak yip wasemb ay, biyomb yimb mindonimuŋ aŋgiy niŋaynak rek mindnikniŋ, yip niŋniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Bapiy! Nand mey Bi suŋrep! Biynimb man ar biy yikop gok nip ma niŋbay; yand nip niŋbiyn. Nip niŋbiyn ak mey, biynimb yand guniy kuyip aŋgñen; nand nep yip yokenak winik ak niŋbay. ");
INSERT INTO kmh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pen miñiy giniŋgayn rek niŋiy, nip Bi yerip rek ak niŋrep giniŋgambay. Kun ak kuyip gos tep ñenimin, yip wasemb aypan ak niŋrep giniŋgiy. Pen yand kiy yip minden, nand biynimb wasemb aypan rek giniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","2","Jiysis Nop nup kun giy aŋgniŋiy, binuk gok yip ñiŋg sikoy Kiydron par ak tikiy, pis tawakdoŋ ken amiy, mon oliyp woŋg per am nan-giyiŋgipay miŋgan ak amniyak. Pen Jiwdas bi Jiysis nup mimuŋg gak ak, tip kun ak niŋrep gak rek, Peresiy bi gok sek, bi Gor nup simboŋgep yomb gok sek nup aŋgeyak, ");
INSERT INTO kmh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","am amiybi gunap, Jiwda poliys gunap poŋind, sup gunap, lam gunap baynat tap gok gunap diy, dand mindeyak kun ak amjakyak. ");
INSERT INTO kmh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pen Jiysis nup tap yerip giniŋg gak ak key niŋak rek, apeyak siŋak amiy aŋgak, “An nup piyow taspim?” ");
INSERT INTO kmh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aŋgek aŋgyak, “Jiysis, bi Nasaret nimb ak aŋgyak.” Aŋgey aŋgak, “Bi kun ak mey yand biy aŋgak.” Aŋgak won kun ak, Jiwdas kiy yip kun siŋak mindek. ");
INSERT INTO kmh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pen Jiysis yand biy aŋgek, ak Gor nep aŋgiy, kiyk sumb sumb ken liŋg amiy, gindam pikyak. ");
INSERT INTO kmh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pen kuyip tip ak aŋgak, “Anup piyow taspim?” Aŋgek aŋgyak, “Jiysis bi Nasaret nimb ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aŋgey aŋgak, “Nimbip mindarik apiyn, ‘Bi kun ak mey yand mindpiyn biy.’ Yip piyow taŋgiy ker, bi guniy kuyip kirgem amniŋgiy aŋgak.” Kun aŋgek, binuk gok kuyip kirgiy nup nep diyak. ");
INSERT INTO kmh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Giyak kun ak, Jiysis nind Nop nup lotiw giy, aŋgak rek nep gak. Nuk aŋgak, “Bapiy. Bi yip aŋgnak gok, bap ma kurgip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pen won kun ak, Saymon Piyta baynat dand owak ak lipiŋg diy, bi bap nup timund yipund kind ak, pisnep timbrik yokak. Yimb nuk Malkas. Gor nup simboŋgep biyomb yimb anup woŋg giñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Piyta kun gek, Jiysis aŋgak, “Baynat ak dipan okok tip liŋgey amnaŋ! Ñiŋg silik kap Bapiy yip ñimb ak, ma ñiŋnimuŋ aŋgiy niŋban?” ");
INSERT INTO kmh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kun aŋgakniŋ, amiybi gok sek, Jiwda poliys gok sek Jiysis nup chichiy diy, tiwniŋgrimbikiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","“Nup dand Anas korip ak nind amjun aŋgiy,” dand Anas mindek ak amniyak. Bi Anas kun ak, Kayapas numok nuk. Kayapas mey Gor nup simboŋgep yomb yimb ak, simiy nokom kun ak aŋgayeyak woŋg gi mindek. ");
INSERT INTO kmh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nuk nep mey, nind Jiwda kanjsol gok kuyip aŋgak, “Bi nokom bap kumek, chin Jiwda maŋgiysek kim amemb rek ayniŋgamb ak, tep yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pen Jiysis nup kun giy dand Anas korip ak amniyakniŋ, Saymon Piyta yip, Jon yip, kisen kisen amnirik. Bi Gor nup simboŋgep yomb yimb ak, Jon nup niŋrep gak rek nuk amiy, pisnep korip kor giyiŋgipay baniys miŋgan biyaŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piyta nuk mis akyaŋ mindek. Jon pen andkind apiy, biyn kinjeŋram kond mindek anup aŋgiy, Piyta nup poŋind baniys miŋgan biyaŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pen biyn kinjeŋram kond mindek ak, Piyta nup aŋgak, “Nand kunep Jiysis binuk bap rek?” Aŋgek aŋgak, “Yand mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pen Kayapas nup woŋg giñiyiŋgipay bi gok sek, Jiwda poliys gok sek kuyip takil gek, mon bap namb kun siŋak daŋgiy, jakiy nep maŋiy mindeyak. Piyta nup kunep takil gek, ap namb kun okok wopsakiy, kiy yip mon maŋiy mindek. ");
INSERT INTO kmh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pen Anas, bi Gor nup simboŋgep yomb yimb nind mindyiŋgip ak Jiysis nup, biynimb nup yenen kisen giyak ak sek, minim yerip aŋgñiyiŋgip ak sek aŋgniŋak. ");
INSERT INTO kmh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kun giy aŋgniŋek aŋgak, “Yand minim gunap weygiy ma aŋgñinik; bi nimb gok niŋmindyakniŋ, nan-gep korip gok sek, Gor aŋgniŋep korip ak sek per miseŋ aŋgñimbiyn. ");
INSERT INTO kmh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kun ak yenen wiysniys ma dand apiy, yip minim kun ak rek aŋgniŋsipim? Biynimb yip niŋyak guniy, minim aŋgnik ak niŋbay rek ayip ak, kuyip aŋgniŋnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jiysis kun aŋgek, Jiwda poliys bap, nup mikem kind siŋak pikiy aŋgak, “Yenen bi Gor nup simboŋgep yomb yimb anup, minim kun ak rek aspan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aŋgek aŋgak, “Minim yesek bap aŋgen, minim yesek apiyn kun ak, biynimb guniy kuyip aŋgñan. Pen minim niŋind yimb ak aŋgen, yenen yip pikpan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pen Anas, bi Gor nup simboŋgep yomb yimb nindnimb ak, Jiysis nup tiwniŋgrimbikyak rek mindakniŋ, aŋgek dand binak Kayapas, bi Gor nup simboŋgep yomb yimb kisenimb mindek ak, amniyak. ");
INSERT INTO kmh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pen Piyta nuk kun giy nep, jakiy mon maŋiy mindakniŋ, bi gunap nup aŋgyak, “Bi kun ak, binuk bap mey nak rek?” Aŋgey, aŋg silokiy aŋgak, “Yand mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pen Piyta bi timund timbrikak ak, bi lek lek nuk rek bap apiy, Piyta nup aŋgak, “Yand nip niŋbiyn; nak bi kun ak yip woŋgday ak mindamban rek?” ");
INSERT INTO kmh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aŋgek, Piyta tip ak, aŋg silokiy aŋgak, “Yand mer aŋgak.” Kun aŋgakniŋ, day kakaruk suk aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Miñmon yowakniŋ, Jiysis nup Kayapas korip animb, dand Rom gapman biyomb Paylat korip ak amniyak. Jiwda biynimb Pasopa tap ñiŋniŋg giyak rek, Rom biynimb korip miŋgan amon, chinup asiŋ wilikniŋgamb aŋgiy, mis akyaŋ mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kun giy nep mindyakniŋ, Paylat mis amiy aŋgak, “Bi biy nup minim yerip niŋiy dand opim?” ");
INSERT INTO kmh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aŋgek aŋgyak, “Nuk tap timey bap ma gembikop, nup kun giy ma dand opnup aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aŋgey, Paylat aŋgak, “Nimbik dam low nimbik ar ak key aŋgip rek niŋiy, kor gim aŋgak.” Aŋgek, Jiwda kay pen aŋgyak, “Rom low ar ak, chin biynimb gok kuyip kor giy, ñaŋgayon kumniŋgiy aŋgiy bap ma mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aŋgyak kun ak, Jiysis yip kun giy ñaŋgbirik ayniŋgambay aŋgiy, nind aŋgyak rek nep gak. ");
INSERT INTO kmh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pen Jiwda biynimb kun aŋgeyak, Paylat tip ak andkind korip miŋgan biyaŋ amiy, Jiysis nup aŋgak, “Nak Jiwda kay kiyŋ kiyk ak akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aŋgek aŋgak, “Minim yip aŋgniŋsipan ak; meŋg miŋgan nak ak key aspan akaŋ, biynimb gunap meŋg miŋgan ak diy aspan?” ");
INSERT INTO kmh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aŋgek, Paylat aŋgak, “Yand Jiwda bi rek, Kiyŋ yomb key yimb chin mindeniŋgamb aŋgiy kond mindpay ak nup kond mindenim. Pen biynimb nak gok nep, bi Gor nup simboŋgep yomb nak gok nep nip dand opay. Nand kiyŋ mindniŋg gey, nip kun giy dand opay akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aŋgek, Jiysis aŋgak, “Yand biynimb diy kond mindeniŋgayn ak; kiyŋ man ar biy mindpay rek ma mindeniŋgayn. Yand man ar biy kiyŋ mindniŋg gembinip, Jiwda biyomb gok yip miñ ayun aŋgey, biynimb yand gok tikjakiy, kiy yip penpen ñapyap. Pen yand biynimb diy kond mindeniŋgayn miñ ak key mindip; mankumb biy kiyŋ mindpay rek mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kun aŋgek, Paylat aŋgak, “Kun ak nand kiyŋ bap?” Aŋgek, Jiysis aŋgak, “Mey nak apan ak. Ar kun anep mey, Bapiy Gor gek, yip mankumb biy tikayey, yomb giy, minim yipul yimb ak aŋgñimbiyn. Biynimb minim niŋind yimb ak dinjun aŋgiy niŋbay gok, minim yip ak dipay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kun aŋgek, Paylat aŋgak, “Pen minim okok nimb okok nimb keykey kuŋaynep mindip ak, yergiy minim yipul yimb mey ak aŋgiy niŋjun aŋgak.” Paylat minim kun ak aŋgiy, tip andkind mis amiy, Jiwda kay kuyip aŋgak, “Nuk tap timey bap gamb ma niŋbiyn. ");
INSERT INTO kmh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pen chin Rom gapman, simiy ak simiy ak, Pasopa ñin ak apamb, kalambis bi nimb bap yikop wisik yokpun. Kun ak, Jiwda kay kiyŋ nimbip ak, yikop wisik yoken amnimuŋ akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aŋgek, kiyk meŋg miŋgan dand araniy aŋgyak, “Nup mer! Chinup Barabas nup wisik yoknimin aŋgyak.” Bi Barabas kun ak, bi tap siydep gapman kay yip penpen giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kun aŋgeyak, Paylat amiybi nuk gok aŋgek, Barabas nup wisik yokiy, Jiysis nup miñ diy tapin nep pikyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kun giy pikiy, tap ñiwñiw sek gunap diy, kiyŋ aypay rek ar band bap giy, jun ar nup biyoŋ ayñiy, chech muk parsek bap ayñiyiŋg aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","“Jiwda kiyŋ kiyk ak, pernep mindonimuŋ aŋgyak.” Kun aŋgyiŋg, nup mikem piksil giyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pen Paylat tip ak mis amiy, Jiwda biynimb kuyip aŋgak, “Nup dand mis biy apiy, minim gunap aŋgniŋen, aŋgek niŋniŋgambim. Nuk tap timey gip junj bap ma piyow niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pen Jiysis nup ar band ñiwñiw sek ak ayñiy, chech muk parsek ak ayñey mis owakniŋ, Paylat kuyip aŋgak, “Nup niŋim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kun aŋgek, bi Gor nup simboŋgep yomb gok sek, Jiwda poliys gok sek Jiysis nup niŋiy aŋgyak, “Nup mon kiros bak biyoŋ ñaŋgbirik aynimimb! Mon kiros bak biyoŋ ñaŋgbirik aynimimb aŋgyak.” Kun aŋgeyak, Paylat aŋgak, “Nimbik key dand amiy, kun ginimimb. Yand tap timey gip junj bap ma piyow niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aŋgek, Jiwda kay aŋgyak, “Gor Ñinuk mindpiyn aŋgip ak, low chin ar ak kumnimuŋ nokom aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kun aŋgeyak niŋiy, Paylat tapin nep pirikiy, ");
INSERT INTO kmh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","tip ak korip miŋgan biyaŋ amiy, Jiysis nup aŋgniŋiy aŋgak, “Nand miñmon akay nimb?” Aŋgek, minim bap pen ma yimb aŋgek, ");
INSERT INTO kmh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paylat aŋgak, “Yip minim ma aŋgniŋgamban? Nand niŋban: yand nep nip kond mindpiyn. Wisik yokniŋg wisik yokniŋgayn; pen mon kiros bak biyoŋ ñaŋgbirikim aŋgen, ñaŋgbirik ayniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aŋgek, Jiysis aŋgak, “Pen yip kond mindpan ak nand key mer; Gor nep aŋgek kond mindpan. Kun ak yip timey gispim miker ak, nand nep ma diniŋgamban; bi yip dand opay gok, miker yomb yimb ak diniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jiysis kun aŋgek, Paylat nup yikop aŋgyokiyn aŋgiy gos niŋak ak pen, Jiwda kay meŋg miŋgan dand araniy aŋgyak, “Jiysis nup wisik yokniŋgamban ak, biyomb yimb Siysa buŋgiy nuk ma mindeniŋgamban. Bi kiyŋ mindpun apay gok, Siysa yip penpen ñaŋgun aŋgiy niŋbay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kun aŋgeyak, Paylat am Jiysis nup poŋind mis apiy, am bi minim tuŋgasikep siya ar ar siŋbiyoŋ giyak ar ak bisgak. Tip ar bisgak kun ak, “Kamb Simen” aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pen ñin kun ak, Jiwda biynimb Pasopa tap kiyk nan-gep ñin ak. Pumbnamb yomb biyoŋ won ak, Paylat kuyip aŋgak, “Kiyŋ nimbik ak aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aŋgek, meŋg miŋgan dand araniy aŋgyak, “Ñaŋg ayan!” “Mon kiros bak biyoŋ ñaŋgbirik ayan aŋgyak.” Aŋgey, Paylat aŋgak, “Kiyŋ yomb nimbik ak, mon kiros bak biyoŋ ñaŋgbirik aynim?” Aŋgek, bi Gor nup simboŋgep yomb gok aŋgyak, “Kiyŋ chin bap ma mindip; Rom biyomb yimb Siysa nep mindip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pen kun giy aŋg dand amiy, Paylat minim kuyip ak diy, amiybi gok kuyip aŋgak, “Jiysis nup dam mon kiros bak biyoŋ ñaŋgbiriknimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","18","Pen Jiysis nup kiros ak ñey, dand Chip junwon apay dum ak amek, nup namb biyaŋ ñaŋgbirikiy; bi omiŋal, bap pis bap pis ñaŋgbirikyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pen Paylat aŋgek, Jiysis nup ñaŋgbirik ayak kiros bak biyoŋ, yimb tikay aŋgyak, “Jiysis bi Nasaret nimb ak, Jiwda kay kiyŋ yomb kiyk ak aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Minim ar nokom kun anep, Griyk minim tikiy, Hiybriw minim tikiy, Latin minim tikiy geyak mey, dawin yomb ak maŋ kun siŋak mindek rek, biynimb kuŋaynep niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pen Gor nup simboŋgep biyomb gok, am Paylat nup aŋgyak, “Minim tikpan ak timey. Jiwda kay Kiyŋ yomb key yimb kiyk ak aŋgiy ma mindonimuŋ; yikop aŋgnimin, ‘Nuk aŋgip, yand Jiwda kay kiyŋ yomb kiyk ak aŋgip aŋgiy tiknimin aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kun aŋgeyak, Paylat aŋgak, “Minim yerip yerip aŋgiy tikniŋgayn ak, kun giy nep mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pen Jiysis nup mon kiros bak biyoŋ ñaŋgrimbik ay, amiybi omiŋal omiŋal Jiysis chech nup gok pikasik keykey diy, chech parsek giy ma ñaŋg diyak ak, kunep pikasik diniŋg aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Ma tuŋgralikjun! Yikop sandiw rek giy, bi an wiyn giniŋgamb ak, nuk dinimuŋ aŋgiy,” sandiw rek giy diyak.” Giyak kun ak, Gor giniŋgambay rek niŋiy gos ñek, Baybol buk tikyak ar ak nep giyak. Minim kun ak tikiy aŋgyak, “Chech yip ak bilok keykey diy, chech parsek yip ak dun aŋgiy, sandiw rek giy dinjun aŋgniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pen ñin kun ak, Jiysis nonim ak, numkan ak, Mariya binak Kiliyowpas biynuk ak, Mariya Makdala nimb ak ap, Jiysis nup ñaŋgbirikyak gol siŋak mindeyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Binuk Jiysis wasemb yimb ayiŋgip ak, kunep ap maŋ kun siŋak mindek ak mey, nonim Mariya nup aŋgak, “Ñinak mey ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kun aŋgiy, bi kun ak nup aŋgak, “Nanim nak mey ak aŋgak.” Kun aŋgakniŋ, ñin kun ak, Jiysis nonim nup poŋind korip amiy, yip mindyiŋgipiyr. ");
INSERT INTO kmh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jiysis niŋak; woŋg ar nuk ak maŋgiysek gindak ak mey, Baybol minim tikyak ak niŋind aynimuŋ aŋgiy aŋgak, “Yip kuŋam kinjik gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pen wayn silik botol bap dap kun siŋak ayey mindek ak mey, amiybi bap, tap sayn band bap diy, wayn silik kun ak tawek amek, di mon alik day ak kambis ñaŋgiy, dand araniy, Jiysis joŋimb ar nup ak ayak. ");
INSERT INTO kmh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ayek, wayn silik kun ak ñimbiy aŋgak, “Mey tep aŋgak.” Pen day jiwip aŋgiy, jiy kuyaŋgiy aŋgak, “Bapiy. Kawnan yip ak dan aŋgiy,” kumak. ");
INSERT INTO kmh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pen Jiwda kay, Praydey duŋgep won ak niŋiy, toy lotiw ñin chin ak, chip gok kiros bak biyoŋ ma mindonimuŋ aŋgiy, am Paylat nup aŋgyak, “Bi mon kiros bak biyoŋ ñaŋgbirik aypay gok, tomb kuyip gok pikpaŋgey kasek kumey, di man biyaŋ ayniŋgiy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aŋgeyak, Paylat amiybi gok kuyip aŋgek, am bi Jiysis yip ñaŋgbirik ayak omiŋal ak, tomb pikpaŋgey kumrik. ");
INSERT INTO kmh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pen Jiysis nup tomb ak pikpaŋgun aŋgiy amiy niŋyak: nuk kumek tomb nup ak ma pikpaŋgyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amiybi bap, kusay ak diy, Jiysis nup tiŋglim anjiŋ siŋak piŋiyek, likañ sek, ñiŋgsek yowak. ");
INSERT INTO kmh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","Pen gak kun ak, Baybol buk ak aŋgiy tikyak rek nep gak. Tikiy aŋgyak, “Tiŋiy nup ak, bap ma pikpaŋgniŋgambay aŋgyak.” Pen minim bap aŋgyak, “Bi piŋiyak anup niŋniŋgambay aŋgyak.” Kun ak nup gosimb niŋbiyn rek, nimb kunep niŋnimimb aŋgiy, Jiysis nup gak kun ak windin yand key niŋiy, nimbip minim niŋind yimb ak aspiyn. ");
INSERT INTO kmh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pen bi miñmon Armatiya nimb bap, Jiysis nup gosimb niŋyiŋgip ak pen, Jiwda biyomb gunap kuyip niŋiy pirikiy, miseŋ ma aŋgyiŋgip. Bi kun ak yimb nuk Josep. Nuk Jiysis nup dam komiyn aŋgiy, am Paylat nup aŋgniŋek, yaw aŋgakniŋ, diniŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Amek, Niykodiymas bi nind am Jiysis nup kisyimken niŋak ak; tap kuyrep wak ak, kuŋaynep tawiy, dand Josep yip amnirik. Tap kuyrep wak kun ak mon “alos” apay mik ak sek, mon “mer” apay mik ak sek diy giyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pen kiyk omiŋal am Jiysis nup komniŋg, Jiwda biynimb giyiŋgipay rek, mon mik dand amnirik gok mumbwak nup okok wiykiy, chech tund sikoy par ak diy, kom kom gayrik. ");
INSERT INTO kmh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jiysis nup ñaŋgrimbik ayak maŋ kun siŋak woŋgday bap mindek. Pen woŋgday namb kun ak, chip kaw kisen nep bap kiluk ay chip ma komyak ak mey, Jiysis nup dam miŋgan kun ak komyak. ");
INSERT INTO kmh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pen Jiwda lotiw ñin ak maŋ maŋ gak rek, kasek komjun aŋgiy, kamb miŋgan yep maŋ kun ak komyak. ");
INSERT INTO kmh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sandey ñin ak miñmon tikniŋg gakniŋ, Mariya miñmon Makdala nimb ak, chip komyak kawrumb bineŋ amiy niŋak; kamb yomb chip kawrumb pilgiyak ak, gol okok mindek. ");
INSERT INTO kmh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nuk niŋiy, tip ak puŋgrikind aŋgiy Saymon Piyta yip, Jon yip minderik ak apiy aŋgak, “Biyomb anup dand kapkap ambay; pen daypay okok ma niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kun aŋgek, Piyta yip, Jon yip niŋniŋg, ");
INSERT INTO kmh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","puŋgrikind yimb aŋgiy saŋdirik. Piyta nuk sisayn gakniŋ, Jon nind amjakiy, ");
INSERT INTO kmh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","mis akyaŋ nep mindiy, ñik giy kamb miŋgan bineŋ niŋnak: chech band gok nep mindek. ");
INSERT INTO kmh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saymon Piyta nuk kisen apiy, sikind miŋgan bineŋ amiy niŋak: ");
INSERT INTO kmh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jiysis nup chech pipkomyak gok ma wisik gak; kom kom giyak rek nep mindek. Pen chech jun neŋ paŋg kus kus giyak ak kunep ma wisikak; paŋg kus kus giyak rek, pis amiy mindek. ");
INSERT INTO kmh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jon pen kunep kamb miŋgan sikind amiy niŋnak: chech gok pipkomyak rek mindek mey, Jiysis tikjakip aŋgiy niŋak. ");
INSERT INTO kmh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pen ñin kun ak, Baybol buk tikiy, Jiwda Kiyŋ yomb key yimb ak tip tikjakniŋgamb aŋgyak minim ak niŋrep ma girik. ");
INSERT INTO kmh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pen kiymiŋay Jiysis nup komyak ak niŋiy, tip andkind korip amnirik. ");
INSERT INTO kmh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya pen chip komyak kawrumb kun ak siy aŋg mindyiŋg, miŋgan bineŋ niŋak: ");
INSERT INTO kmh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","enjol chech tund ayrik omiŋal ak, bap jun day bineŋ, bap tomb day biym minderik. ");
INSERT INTO kmh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Enjol omiŋal kun ak, Mariya nup aŋgrik, “Yenen siy aspan aŋgrik.” Aŋger aŋgak, “Biyomb yand anup dand amiy, akay daypay ak ma niŋbiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kun aŋgiy tuŋgandikiy niŋak: bi bap ap mindek. Pen Jiysis nep aŋgiy ma niŋak. ");
INSERT INTO kmh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jiysis pen Mariya nup aŋgak, “Yenen siy aspan? Anup piyowsipan?” Aŋgek, Mariya aŋgak-eŋ, bi woŋgday nop nimb anep yip asap aŋgiy aŋgak, “Chip ak dand ambiyn aŋgiy ker, akay daypan ak yip aŋgenimin, dand amnim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aŋgek aŋgak, “Mariya!” Aŋgek, Mariya pen tuŋgandikiy Hiybriw minim aŋgiy, “Rabonay!” aŋgak. ");
INSERT INTO kmh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aŋgek aŋgak, “Bapiy ker biyoŋ andkind ma ambiyn rek, yip ma diniŋ mindenimin. Pen am mam sikop kuyip aŋgnimin: Jiysis aŋgip, ‘Bapiy Gor mindip biyoŋ tip andkind amjipiyn. Pen nuk miñiy Bapiy yand nep ma mindip, Bapiy chin mindip aŋgnimin aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jiysis kun aŋgek, Mariya Makdala am Jiysis binuk gok kuyip aŋgak, “Biyomb anup niŋiy aswiyn aŋgak.” Kun aŋgiy, Jiysis minim aŋgak gok kuyip aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pen Sandey ñin ak, pumb saŋind amnakniŋ, binuk gok Jiwda biyomb gok kuyip pirikiy, korip miŋgan amiy, kinjeŋ ak lok giy kapkap mindyakniŋ, Jiysis ap namb kun ak miseŋ giy aŋgak, “Gor nimbip kond mindeŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kun aŋgiy ñin wur gok sek, tiŋglim pis piŋyak ak sek yomiy gek, kiyk niŋiy, ak Jiysis nep aŋgiy kuyip tep yimb gak. ");
INSERT INTO kmh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nuk pen kuyip tip ak aŋgak, “Gor nimbip kond mindeŋ. Bapiy yip aŋgyokek apiy woŋg nup gipiyn rek, nimbip kunep aŋgyoksipiyn. Nimb Bapiy woŋg chirupapiy ak gem amnimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kun aŋgiy, añiŋ band nuk ak kuyip puŋg yokyiŋg aŋgak, “Gor Kawnan ak dinimimb. ");
INSERT INTO kmh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Diy, biynimb tap siy tap timey gipay gok, niŋiy kirginiŋg kirginiŋgambim. Pen niŋiy ma kirginiŋgambim ak, gach sek mindpay rek mindeniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pen Jiysis ap miseŋ giy kuyip minim aŋgak ñin kun ak, binuk Tomas, kiy yip ma mindek ak mey, kisen nup niŋiy, ");
INSERT INTO kmh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Biyomb chin ak nup niŋbun aŋgeyak, aŋgak, “Kun aspim ak pen; nup ñapay miŋgan gok sek, tiŋglim pis nup piŋiypay ak sek diniŋiy nep, minim kun ak diy, tikjakip aŋgiy niŋniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kun aŋgiy, pen wiyk nokom bap mindiy, Jiysis binuk gok Tomas yip tip ak, korip miŋgan ak kinjeŋ lok giy mindeyak. Mindyakniŋ, Jiysis ap namb kun ak miseŋ giy aŋgak, “Gor nimbip kond mindeŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kun aŋgiy, Tomas nup aŋgak, “Ñin maŋgiy nand ak, yip ñaŋgyak miŋgan gok sek, tiŋglim pis piŋiyak ak sek ñin ayniŋan! Gos par ma ay, Gor Ñinuk aŋgiy yip gosimb niŋnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aŋgek, Tomas aŋgak, “Biyomb. Nand mey, Gor yand aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aŋgek, Jiysis aŋgak, “Miseŋ niŋiy mey, yip gosimb niŋban ak pen; biynimb yip miseŋ ma niŋiy, yip gosimb niŋiy chiŋgniŋgambay gok, tep yimb giniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pen buk tikpiyn biy, chin Jiysis binuk gok niŋmindnukniŋ, tap yomb keykey kuŋaynep giyiŋgip rek, maŋgiysek ma tikpiyn. ");
INSERT INTO kmh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pen minim tikpiyn biy, Jiysis nup Gor Ñinuk yimb, Kiyŋ yomb key yimb per kond mindyiŋgipun ak nep aŋgiy, nup gosimb niŋem mey; nimbip dek, nuk yip kim mindeniŋgambim aŋgiy tikpiyn. ");
INSERT INTO kmh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","Pen kisen ñin bap, Saymon Piyta ak, Tomas Pireŋgiy ak, Nataniyel miñmon Keyna Galiyliy propens nimb ak, Jon ak, numam Jemis ak, Jiysis minim nup dirik bi omiŋal bap yip, jimñiy am ñiŋg chemb yomb Taybiyriyas mindiy, Jiysis miseŋ gek niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pen ñin kun ak Saymon Piyta aŋgak, “Yand piys nen amjipiyn aŋgak.” Aŋgek, binuk gunap chin yip amniŋgambun aŋgiy, am nuk yip bot diy, giraŋgeyraŋgey miñmon yowak ak pen; piys gunap ma nep diyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pen pumb limgakniŋ, Jiysis ap ñiŋg chemb gol siŋak mindek, nup niŋyak ak pen; ak Jiysis nep aŋgiy ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nuk aŋgak, “Buŋgiy sikop. Nimb piys nen giraŋg mer niŋbim?” Aŋgek, “Yaw aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kun aŋgey aŋgak, “Wimben ak di bot yipund pis okok ken yokiy mey, piys gunap diniŋgambim aŋgak.” Aŋgek, wimben ak di ñiŋg namb biyaŋ yokiy, piys kuŋay yimb nep diy, lipiŋgey winimuŋ rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kun gek, Jon Piyta nup aŋgak, “Bi kun ak Biyomb chin ak nep aŋgak.” Kun aŋgek niŋiy, Piyta chech yomb nuk ayak ak tuŋgasik ay, pindeŋg ñiŋg namb biyaŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gunap pen bot ar ak mindiy, wimben piys sek aranjakiy mindek ak, lipiŋg dand ñiŋg gol okok wiyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Apiy niŋyak: mon yin binj amnak ar ak, piys gunap yin mindek. Pen biret gunap kunep mindek. ");
INSERT INTO kmh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jiysis aŋgak, “Piys miñiy dipim gok, gunap dowim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aŋgek, Saymon Piyta bot ar ak amiy, nuk yip wimben piys kuŋaynep mindek kun ak, lipiŋg dand wiyak. Wimben ak miker gak ak pen, ma puŋgrikak. ");
INSERT INTO kmh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jiysis aŋgak, “Apiy, tap ñiŋim aŋgek,” kiyk pen nand bi an ap mindpan aŋgiy nup ma aŋgniŋyak. Ak Biyomb chin anep aŋgiy, kirgiyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nuk biret ak bilok ñiy, piys ak bilok ñiy gek ñiŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pen Jiysis kumiy tikjakiy, miseŋ gek binuk gok nup minek omiŋal nokom niŋyak. Minek omiŋal korip miŋgan ak niŋyak; minek bap ñiŋg gol ak niŋyak. ");
INSERT INTO kmh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pen kun giy tap ñimbiy, Jiysis Saymon Piyta nup aŋgak, “Saymon, Jon ñinuk. Nand bi guniy rek mer; nand yip gosimb niŋiy ma nep kirpan?” Aŋgek aŋgak, “Yaw! Biyomb. Nip gosimb niŋbiyn ak, nand niŋban aŋgak.” Kun aŋgek aŋgak, “Siypsiyp ñiluk yip gok kond mindenimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kun aŋgiy, tip ak aŋgak, “Saymon Jon ñinuk. Yip gos niŋban akaŋ?” Aŋgek aŋgak, “Yaw! Biyomb. Nip gosimb niŋbiyn ak nand niŋban aŋgak.” Kun aŋgek aŋgak, “Siypsiyp yip gok kond mindenimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jiysis tip ak, Saymon Jon ñinuk; yip gosimb niŋban akaŋ aŋgek mey, omiŋal nokom amnak. Pen kun giy yinj omiŋal nokom aŋgniŋek, Piyta gos miker ayiŋg aŋgak, “Biyomb. Nak tap okok maŋgiysek niŋban. Kun ak, nip gosimb niŋbiyn ak, nand key niŋban aŋgak.” Aŋgek aŋgak, “Kun ak siypsiyp yip gok kond mindenimin! ");
INSERT INTO kmh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nip niŋind yimb aspiyn: miñiy gos nand key niŋban rek gipan. Pen kisen kun ma giniŋgamban; ñin ak pandkaw ñaŋgiy mindnakniŋ, nip miñ tiwniŋgiy, ma amniŋg giniŋgamban okok dand amniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jiysis minim aŋgak kun ak, Piyta tokiy ayek, biynimb gunap nup ñaŋg ayniŋg gey, nuk aŋgniŋgamb, “Yand Krays ker mindpiyn rek, yip monmon ñaŋgnimimb aŋgek,” nup ñaŋgniŋgambay rek aŋgak. Pen Jiysis Piyta nup aŋgak, “Yip chiŋgiy nep mindenimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Minim kun ak aŋgakniŋ, Piyta tuŋgandikiy niŋak: Jiysis wasemb yimb ayiŋgip bi ak ap mindek. Bi kun ak mey, nind Jiysis mindek kiñiŋ siŋak bisiŋg mindiy aŋgak, “An nip mimuŋg giniŋgamb aŋgak ak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyta bi kun ak nup niŋiy, Jiysis nup aŋgak, “Yip kisen kun giniŋgamb apan ak pen, bi biy nup yerginiŋgamb?” ");
INSERT INTO kmh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aŋgek aŋgak, “Ak gos yand. Nup gen mindnep mindakniŋ, andkind winiŋgayn ak, minim nak mer. Pen nand yip chiŋgiy nep mindenimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jiysis minim kun ak rek aŋgek, biynimb nuk gok minim bap aŋgyiŋgipay, “Binuk kun ak ma kumniŋgamb aŋgyiŋgipay.” Pen Jiysis binuk kun ak ma kumniŋgamb aŋgiy ma aŋgak; yikop aŋgak, “Yand aŋgen, nuk mindnep mindakniŋ winiŋgayn ak, minim nak mer aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pen binuk aŋgak kun ak, yip nep aŋgak. Yand mey binuk, yerer gak gok windin niŋiy minim kun ak tiksipiyn. Chin maŋgiysek niŋbun; minim tiksipiyn kun ak, minim niŋind yimb anep tiksipiyn. ");
INSERT INTO kmh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jiysis tap ar keykey kuŋaynep gak ak pen, minim kun ak, yep gunap nep tiksipiyn. Pen minim kun gok maŋgiysek tik buk biyaŋ ayombinup, mankumb biy sikoy gek, dayep tip ak ma mindombikop. ");
INSERT INTO kmh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Mam Tiyopiylas. Yand nip minj nind tiknik ak; Jiysis nup tikey yomb giy, tikjak woŋg gi mind dand amiy, woŋg yerip yerip gak, minim yerip yerip biynimb gok kuyip aŋgñak ak, nip aŋgnik. Kisen nuk Nop miñmon amniŋg, Nop Kawnan ak gos ñakniŋ, bi minim nup dand amemb gok kuyip aŋgñirep giy amnak. ");
INSERT INTO kmh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pen kumiy tikjakiy, binuk gok mindyakniŋ, ñin kuŋaynep miseŋ giy, kuyip Gor biynimb diy kond mindeniŋgamb minim ak aŋgñiyiŋgip. Pen nuk yerer gak ak niŋiy, ak Jiysis nep kumiy tikjakip aŋgiy, niŋrep giyak. Pen kumiy tikjakiy, ñin jiwiy andikiy onep kaŋgol piskind (40) ak man ar biy mindiy, aranjak semb biyoŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pen kumiy tikjakiy, man ar biy mindyiŋgip ñin kun gok, ñin bap ap binuk gok yip mindiy aŋgak, “Nimbip nind aŋgnik rek, Bapiy Kawnan nuk ak nimbip yokniŋgamb ak mey; miñmon Jerusalem biy nep kond mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon bi ñiŋg pikñemb ak, nimbip ñiŋg anep pikñak ak pen; Bapiy nimbip Kawnan nuk ak yokniŋgamb. Ñin kun ak maŋ mindip, kond mindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pen ñin bap, Jiysis binuk gok mindeyak siŋak miseŋ gek, nup aŋgyak, “Biyomb. Nand miñiy kiyŋ chin mindey, miñmon Yisrel biy tip ak key kond mindiy, miñmon gunap kond mindiy giniŋgambun?” ");
INSERT INTO kmh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aŋgeyak, kuyip aŋgak, “Kond mindeniŋgambim ñin kun ak, tap nimbik niŋep rek niŋnimimb; Bapiy nuk key gek niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pen Bapiy Kawnan ak ap nimbip kond mindakniŋ; nimb am Jerusalem biynimb, Jiwdiya biynimb, Samariya biynimb, biynimb miñmon okok maŋgiysek, yand yerer gipiyn ak kuyip aŋgñiniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kun aŋgakniŋ, Nop nup dand aranjak semb biyoŋ amnak. Binuk gok niŋmindyakniŋ, semb band ak ap nup yiwgak. ");
INSERT INTO kmh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pen kun giy kuyoŋgiy niŋmindyakniŋ, bi chech tund tep yimb yimrik omiŋal ap mindeyak maŋ siŋak miseŋ giy, aŋgrik, ");
INSERT INTO kmh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galiyliy biynimb. Yenen semb biyoŋ niŋmindpim? Jiysis andkind winiŋgamb ñin ak, giy amimb rek nep winiŋgamb aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bi omiŋal kun ak, kun aŋgiy amnirikniŋ, kiyk miñmon Oliyp dum mindeyak ak kirgiy, Jerusalem amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","Am mindiy, Gor nup aŋgniŋniŋg, kinyiŋgipay korip ar biyoŋ miŋgan ak nan-giy, Gor nup aŋgniŋyiŋgipay. Biynimb kun gok mey: Piyta, Jon, Jemis, Enjriw, Piyliyp, Tomas, Batlomiyiw, Matyiw, Alpiyas ñinuk Jemis ak, Saymon Selot ak, Jemis ñinuk Jiwdas ak, Jiysis nonim Mariya ak, Jiysis numam sikop ak, biyn gunap sek. ");
INSERT INTO kmh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pen ñin kun siŋak, biynimb wan handret tiwendiy rek ap nan-giyakniŋ, Piyta tikjakiy kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mam ay sikop niŋim. Gor Kawnan ak wosrey Depiyt nup gos ñek, Jiwdas bi Jiysis nup mimuŋg niŋak anup giniŋgamb rek aŋgiy tikek, miñiy aŋgak aŋgak rek nep gisap. ");
INSERT INTO kmh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jiysis bi Jiwdas kun ak dek chin yip mindiy, Gor woŋg ak jimñiy giyiŋgipun ak pen; ");
INSERT INTO kmh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","kisen nuk Jiysis nup mimuŋg niŋiy, maniy dak ak dand amiy, mankumb bap tawiy, mind dand amiy, ñin bap apyap pikek, koŋgiy nup ak pikjakiy, simbwur gok limiŋg mis amek kumak. ");
INSERT INTO kmh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kun giy kumek, Jerusalem biynimb maŋgiysek niŋiy, mankumb tawiy kumak kun ak, yimb Akeldama aŋgyak. Akeldama aŋgyak minim kiñiŋ ak, likañ yowak miñmon aŋgiy aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pen Piyta aŋgak, “Depiyt wosrey Baybol buk day Sam apay ak tikiy aŋgak, ‘Biynimb gunap miñmon nuk kun ak, ma am mindeniŋgiy aŋgak.’” Minim bap pen aŋgak, ‘Woŋg nuk ak, bi bap pen dinimuŋ aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Aŋgak kun ak, chin bi bap niŋiy dinjun. Bi kun ak bi yikop bap mer; bi chin yip per taŋgiy, Jon Jiysis nup ñiŋg pikñak ak niŋiy, mind dand amiy, Jiysis kumiy tikjak semb biyoŋ amek niŋak bi bap niŋiy dinjun. Bi kun ak rek don mey, Biyomb Jiysis kumiy tikjakak minim ak, aŋgñirep giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Piyta kun aŋgek, binak Matayas yip, Josep Jastas yip kuyip aŋgayak. Pen Josep nup ñin gunap ‘Basabas’ aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Bi omiŋal kun ak, kun giy aŋgay, Jiysis nup aŋgniŋiy aŋgyak, “Biyomb. Jiwdas nind timey giy kumak ak, tip nup ak an dinimuŋ aŋgiy bi omiŋal biy aŋgaypun. Kun ak nand biynimb maŋgiysek gos niŋiy gipay rek niŋban ak mey, nip aŋgniŋsipun! Nand key ‘Bi ak aŋgey,’ niŋiy dinjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kun aŋgiy, sandiw rek giy, Matayas wiyn giy, Jiwdas tip nup ak dak. ");
INSERT INTO kmh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Biynimb Jiysis nup gosimb niŋyak gok, Pendiykos ñin yomb ak miñiy wip aŋgiy, ap korip miŋgan nokom bap mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kun giy mindyakniŋ, giw yomb ak semb ar biyoŋ aŋgiy, yiŋgen rek diy, korip mindeyak ak apek, maŋgiysek niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pen won kun anep mon maŋlaŋ biñ rek ak apiy, kuyip jun ar keykey amnakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Gor Kawnan ak kuyip bak ayek, minim yimb ar keykey aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ñin kun ak, Jiwda biynimb wikan keykey ap Jerusalem nan-gi mindeyak ak mey, ");
INSERT INTO kmh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","giw yomb kun ak aŋgek niŋiy, yergip aŋgiy, biynimb kuŋaynep kasek korip kun ak apiy niŋyak: minim yimb ar keykey yipund giy nep aŋgeyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Kiyk niŋiy, wal aŋgiy aŋgyak, “Biynimb guniy maŋgiysek Galiyliy nimb ak pen; yergiy minim yimb chin keykey apun rek yipund giy aspay? ");
INSERT INTO kmh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chin gunap Patiya nimb, gunap Miydiya nimb, gunap Yilam nimb, gunap Mesopotemiya nimb, gunap Jiwdiya nimb, gunap Kapadosiya nimb, gunap Pontas nimb, gunap Esiya nimb, ");
INSERT INTO kmh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","gunap Priysiya nimb, gunap Pampiyliya nimb, gunap Yijip nimb, gunap miñmon yomb Liybiya, Sayriyniy gol okok nimb. ");
INSERT INTO kmh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Chin gunap Jiwda yipund giy yimb; gunap miñmon Rom nimb winuk ak pen, Jiwda biynimb gipay rek ak gipun. Gunap Kriyt nimb, gunap Areybiya nimb. Pen Gor kuyip key yimb gek, minim yimb chin keykey mindip rek ak aŋgey niŋsipun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kun aŋgiy, gos kuŋay niŋyiŋg, pen aŋgniŋek, pen aŋgniŋek giy aŋgyak, “Key yimb gisap kun ak yerginiŋg gisap aŋgiy,” gos kuŋay yimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pen biynimb gunap aŋgyak, “Ak ñiŋg wayn kuŋay ñimbiy, sakiy ay aspay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kun aŋgeyak, Piyta bi Jiysis minim dand amemb gunap yip tikjakiy, meŋg miŋgan dand araniy aŋgak, “Nimb Jiwda biynimb diy, Jiwda biynimb mer gok diy, Jerusalem mindpim gok, minim aspiyn ak niŋim. ");
INSERT INTO kmh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Chin minim yimb keykey aspun ak, ñiŋg wayn ñimbiy ma aspun. Ñiŋg wayn ak pumb kisen owip won ak ma ñimbay; duŋgep won anep ñimbay. ");
INSERT INTO kmh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chin pen minim yimb keykey aŋgambun niŋsipim kun biy, bi Gor minim aŋgep Jowel, wosrey aŋgiy tikak rek nep gip. ");
INSERT INTO kmh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nuk minim kun ak tikiy aŋgak: ‘Gor aŋgip, “Ñin kisen ak biynimb maŋgiysek okok biyn piñ, bi paranj, biyn yomb, biyomb gok kuyip; Kawnan yand ak yokniŋgayn. Bi paranj gok day niŋniŋgambay. Biyomb gok wisin niŋniŋgambay. Ñi, pañ gok, minim tep yip ak miseŋ aŋgyikniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ñin kun ak, biyn bi yip woŋg giñimbay gok kuyip, Kawnan yand ak yoken, minim tep yip ak biynimb okok kuyip aŋgñiniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pen semb biyoŋ tap key yimb gunap giy, man ar biy tap mageprek gunap key giniŋgayn. Pen likañ giy, mon yiniy, sikum yomb giy giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Takin ak likañ giy, pumb ak melik ma giniŋgamb. Kun gek, kisen mey, ñin yand Biyomb yimb mindiy winiŋgayn ak winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pen biynimb yip aŋgniŋniŋgambay gok, kuyip diniŋgayn aŋgip” aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyta Jowel tikak minim kun ak aŋgjiwiy aŋgak, “Nimb Yisrel biynimb. Minim aŋgniŋg gispiyn biy niŋnimimb. Jiysis bi Nasaret nimb ak, bi yikop mer; Gor nep nup yokek owak. Ñiyand ak yoken, tap mageprek gek niŋiy, Gor Ñinuk nep aŋgniŋgambay aŋgiy, yokek apiy, tap mageprek gok gek niŋbim. ");
INSERT INTO kmh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nuk giniŋgambim rek niŋiy, Ñinuk Jiysis nup di ñin ar nimbip ak ayek; dam biynimb Gor minim ma niŋbay gok kuyip ñembik, mon kiros bak biyoŋ ñaŋgbirik ayey kumak. ");
INSERT INTO kmh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yiwur yomb diy kumak ak pen, pisnep lum namb okok mindiy, kuyiŋg yownimuŋ rek ma ayak. Nop gek tip ak tikjakak. ");
INSERT INTO kmh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pen Depiyt wosrey Jiysis nup minim ak tikiy aŋgak: ‘Bapiy yand. Yip per aymindpan rek, tap bap yip ginimuŋ rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kun gip ak, yip tep gek, miñmiñ yimb gipiyn. Kumniŋg kunep ma pirikpiyn. ");
INSERT INTO kmh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","‘Yip aŋgiy “Ñi suŋ-tep yand ak biynimb kumbay gok yip mindiy ma kuyiŋg yowniŋgamb apan” ak, yip tep gip. ");
INSERT INTO kmh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Permindep kinjeŋ ak yip yomnak rek, nand yip perper mindiy, miñmiñ giniŋgayn aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyta minim kun ak aŋgiy aŋgak, “Mam ay sikop. Nimb key niŋrep gipim. Basind yes chin Depiyt, bi minim tikak kun ak kumek, komyak kaw miŋgan ak, miñiy kunep niŋbun. Kun ak nuk key ma aŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pen nuk bi Gor minim aŋgep ak mey, nuk niŋak: Gor nup niŋind yimb aŋgiy aŋgak, “Ñi nand tikey, kiy tikey amiy apiy giniŋgamb gok, kisen ñi bap nand kiyŋ mindpan rek mindiy, biynimb kond mindeniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gor aŋgak kun ak mey, Depiyt niŋak: kisen Krays kumiy pisnep kuyiŋg yownimuŋ rek ma ayak. Gor gek tip ak tikjakniŋgamb rek niŋiy minim kun ak aŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gor gek, Jiysis tip ak tikjakek, windin chin key niŋiy aspun. ");
INSERT INTO kmh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nuk tikjakek, Nop Ñi tep yand aŋgiy, dand amiy, ñin yipund kind okok ken ayek, nuk yip mindiy, Nop nind aŋgak rek Kawnan ak yoker mey; ap giw yomb aŋgek, minim keykey aspun biy niŋsipim. ");
INSERT INTO kmh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pen Depiyt minim aŋgak kun ak, nuk key ma aŋgak. Nuk biy mindiy, semb ar biyoŋ ma amnak. Pen nuk minim gunap tikiy aŋgak: ‘Biyomb ak Biyomb yip ak nup aŋgak, “Ñin yipund kind yip okok ken mindenimin mey; ");
INSERT INTO kmh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yand gen biynimb nip yiruk niŋbay gok, talak miŋgan nand okok mindeniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Depiyt minim aŋgak kun ak, nimb Yisrel biynimb niŋrep ginimimb. Jiysis bi mon Kiros bak biyoŋ ñaŋgbirik aypik ak nup, Gor gek Biyomb yimb mindip. Nuk nep Kiyŋ yomb key yimb per kond mindyiŋgipun ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Piyta minim kun ak aŋgek, biynimb mindeyak gok gos kuŋay yimb niŋiy; Piyta sek, Jiysis minim dand amemb binuk gunap sek kuyip aŋgyak, “Kun ak mam sikop: chin miñiy yerginjun?” ");
INSERT INTO kmh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aŋgeyak, Piyta aŋgak, “Nimb nokom nokom mindpim rek, tap siy tap timey gipim ar ak kirgiy, Jiysis nup gosimb niŋiy, ñiŋg piknimimb. Kun geniŋgambim, Gor tap siy tap timey gipim ak niŋiy kirgiy, Kawnan nuk ak nimbip yokniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gor wosrey aŋgak, ‘Kawnan yand ak nimbip Yisrel biynimb yokiy, ñapan nimb tikayniŋgambim gok yokiy, biynimb okok kuyip yokiy giniŋgayn aŋgak.’ Kun ak niŋbun. Gor biynimb nuk diniŋg gip gok kuyip maŋgiysek, Kawnan nuk ak yokniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyta kuyip simb niŋiy, minim gunap aŋgiy aŋgak “Nimb biynimb gunap monmon gipay rek kirgiy, mindrep ginimimb. Mer ak, yiwur yomb diniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Piyta ñin kun ak, kun giy aŋgek, biynimb kuŋaynep, chiriy tawsin (3000) rek, Jiysis nup gosimb niŋiy, ñiŋg pikyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kun ak bi Jiysis minim dand amemb minim aŋgñiyiŋgipay ak niŋrep gun aŋgiy, aŋg amiy apiy giyiŋg, biret tipaŋg jimñiy ñimbyiŋg, Gor nup aŋgniŋyiŋg mindyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gor bi Jiysis minim dand amemb gok kuyip kond mindakniŋ, tap mageprek gunap geyak, biynimb maŋgiysek jel pirikyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Biynimb Jiysis nup gosimb niŋyak gok jimñiy mindiy mey, biynimb an tap kuyip tikdak gok, biynimb gunap monmon ñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mankumb, tap okok kunep yokyiŋg, maniy diy, biynimb tap ma mindek gok kuyip bilok ñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Minek minek, Gor nup yimb ak dand araniŋg; Gor aŋgniŋep korip ak am nan-giyiŋgipay. Pen korip kiyk okok kunep nan-giy, Gor nup yimb dand aranyiŋg, biret tipaŋgiy, miñmiñ giyiŋg, tap jimñiy ñimbyiŋgipay. Biynimb yikop gok kuyip niŋey tep gak. Gor gek minek minek biynimb gunap sek apey, Jiysis nup gosimb niŋiy, ap biynimb nuk nindnimb gok yip jimñiyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","3","Bi nonim tikak ñin anep tomb timey gak bap nup, minek minek dand apiy; Gor aŋgniŋep korip kinjeŋrumb yomb, kil tep giyak gol siŋak ayey, bisiŋg mindyiŋgip. Mindyiŋg, biynimb Gor aŋgniŋep korip miŋgan apiy amyiŋgipay gok kuyip, maniy nen asimb aŋgyiŋgip. Pen minek bap, Piyta yip, Jon yip pumb kuyim gak won ak, Gor nup aŋgniŋniŋg, apiy pandikrikniŋ, bi tomb timey gak kun ak kuyipmiŋay niŋiy aŋgak, “Yip tap gunap ñiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aŋgek, kiymiŋay nup niŋyinjsek ay mindyiŋg, Piyta aŋgak, “Chirupmiŋay niŋan aŋgak!” ");
INSERT INTO kmh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aŋgek, yip tap ñiniŋg gispiyr aŋgiy, niŋmindek, ");
INSERT INTO kmh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piyta aŋgak, “Maniy yand ma mindip; pen tap nokom bap nip giniŋgayn. Jiysis Krays Biyomb Nasaret nimb ak mindip rek, nip aspiyn, ‘Tikjakiy saŋdan!’” ");
INSERT INTO kmh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kun aŋgiy, ñin yipund kind nup ak diy, di jakñakniŋ, won kun anep, ñin tomb nup gok suŋ ayek, ");
INSERT INTO kmh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Gor nup tep yimb aŋgyiŋg, talak talak giyiŋg, kiymiŋay yip Gor aŋgniŋep korip miŋgan ak amnak. ");
INSERT INTO kmh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Kun gek, biynimb mindeyak gok, bi tomb timey per ap kinjeŋrumb kil tep giyak gol siŋak mindyiŋg, maniy tap gok nen asimb aŋgip ak, yergiy tomb yimb tawiy asaw aŋgiy, gos kuŋay niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Won kun ak, bi kun ak nuk, Gor aŋgniŋep korip mis ar; Solomon korip bandak band aŋgyiŋgipay miŋgan ak mindiy, Piyta yip, Jon yip kuyip namb namb dakniŋ, biynimb kuŋaynep kasek ap niŋiy, gos kuŋay niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kun geyak, Piyta aŋgak, “Yisrel biynimb. Chirup yenen niŋiy wal aspim? Kiymiŋay bi suŋ-tep omiŋal kun ak key yimb ak mey; gambiyr, bi kun biy kinjeŋ tasap aŋgiy gos ak niŋsipim? ");
INSERT INTO kmh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ak mer. Basind chin Ebraham, Aysek, Jekop bi gok aŋgniŋyiŋgipay Gor ak nep gek suŋ ayip. Nuk gip kun ak, Ñinuk Jiysis yimb ak dand araniyaŋ aŋgiy gip. Nimb pen, Ñinuk kun ak nup ma dipik. Nup mon kiros bak biyoŋ ñaŋgbirik ayniŋg giyak ñin ak, gapman biyomb Paylat wisik yokiyn aŋgek, ");
INSERT INTO kmh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","15","nimb nup kirgiy, bi biynimb pikayep ak nup wisik yokiy, bi tap siy tap timey ma giy, biynimb gek perper mindpay ak nup pisnep pikaypik. Kun gipik ak pen; Gor gek tip ak tikjakiy kim mindip ak, chir niŋiy aspur. ");
INSERT INTO kmh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Bi tomb timey per niŋbim biy, miñiy suŋ ayamb niŋbim. Bi Jiysis kun ak nep chirupmiŋay gos ñek, gek suŋ ayniŋgamb aŋgiy di jakñirukniŋ, gek suŋ ayip. ");
INSERT INTO kmh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Pen mam ay sikop. Nimb biyomb nimbik gok yip, sakiy sek mindembik ak mey, Jiysis nup kun gipik. ");
INSERT INTO kmh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pen Gor, bi minim nup aŋgep gok kuyip wosrey gos ñek aŋgyak, ‘Kisen Kiyŋ yomb key yimb ak yiwur yomb yimb diy, kumniŋgamb aŋgyak’ ak mey; aŋgyak rek nep gipik. ");
INSERT INTO kmh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pen tap yerip yerip timey gipim ak, Gor niŋmindip. Kun ak tap siy tap timey gipim ak kirgiy, gos kisenimb ar ak niŋeniŋgambim; Gor tap siy tap timey gipim gach ak wiykyokek mey, nuk yip jimñiy mindiy tep gakniŋ mindeniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kun giy mey, Ñinuk Jiysis ‘Nimbip nen yokiyn aŋgiy’ kond mindip ak yokniŋgamb. Kiyŋ yomb key yimb ak, Jiysis nep. ");
INSERT INTO kmh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pen bi Gor minim aŋgep gok wosrey aŋgyak rek, nuk semb biyoŋ mindip rek mindiy, kisen tap mankumb biy mindip gok tip ak girep giniŋg winiŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bi Gor minim aŋgep Mosis aŋgak, ‘Gor kisen bi minim nup aŋgep yand rek bap yokek, minim aŋgniŋgamb ak niŋrep ginimimb. ");
INSERT INTO kmh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Biynimb ma niŋniŋgambay gok, biynimb nuk yimb gok yip jimñiy ma mindeniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Bi Gor minim aŋgep Samwel sek, bi Gor minim aŋgep kisen wiyak gok sek minim aŋgyak gok, miñiy mindpun ñin namb biy aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bi minim aŋgyak kun gok, ñapan tikey, kiy pen tik dand amiy, tik dand amiy tikey mey, chin mindpun. Kun ak minim chinup bap Gor basind Ebraham nup giniŋgayn aŋgiy minim aŋgayak. Nup minim aŋgay aŋgak, ‘Ñapan nand tikey, kiy tik dand amiy apiy giy tikniŋgambay gok, bap mindek mey; biynimb okok maŋgiysek tep giniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pen, Gor Ñinuk ak yokniŋg aŋgak, Yisrel biynimb kuyip nind yoken maŋgiysek mindpay rek tap siy tap timey gipay ak kirgiy, mindrep giniŋgiy aŋgiy’ yokek awak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Piyta yip, Jon yip Jiysis kumiy tikjakak minim ak aŋgñirikniŋ, bi Gor nup simboŋgep yomb gok sek, bi Sanjiwsiy gok sek, Jiwda poliys kond mindep yomb ak sek minim aŋgrik kun ak niŋiy, biynimb gunap kumiy ma tikjakpay ak yenen minim kun ak aŋgñispiyr aŋgiy, miluk yapek di kalambis ay; miñiy duŋgep won biy mer, toy kor gep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pen minim aŋgrik ñin kun ak, biynimb kuŋay yimb nep, Jiysis nup gosimb niŋyak. Biyn gok sek mer, bi gok nep mey; payp tawsin rek amnak. ");
INSERT INTO kmh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Pen minek, Jiwda kanjsol nan-giniŋg, per giyiŋgipay rek, bi low tiysa gunap, bi Gor nup tap simboŋgep yomb gunap, bi kanjsol yikop gunap ap nan-giyak. Pen Anas ak, Kayapas ak, Jon ak, Aleksanda ak, Anas biynimb nuk gunap sek minim aŋgeyak namb kun ak, ap niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kun giy niŋmindyakniŋ, Piyta yip, Jon yip kuyip dap namb siŋak ay aŋgyak, “Bi tomb timey gak ak yergiy ger suŋ ayip? Tap yerip ak aŋgniŋiy, tap mageprek kun ak gipiyr?” ");
INSERT INTO kmh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aŋgeyak, Piyta Gor Kawnan yip mindek ak mey aŋgak, “Nimb Yisrel biyomb gok sek, ");
INSERT INTO kmh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bi kanjsol yomb gok sek chirup bi tomb timey gak anup, yergiy ger suŋ ayip aŋgiy, aŋgniŋsipim? ");
INSERT INTO kmh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nimb Yisrel biynimb maŋgiysek, minim aspiyn ak niŋrep ginimimb. Jiysis Krays bi Nasaret nimb ak nup, mon kiros bak biyoŋ ñaŋgrimbikaypik ak pen; Gor gek tip ak tikjakak. Bi kun ak nep aŋgniŋor, bi tomb timey gak kun biy nup gek pisnep suŋ ayek, taŋgrep gisap. ");
INSERT INTO kmh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bi Jiysis kun anup mey, Baybol buk tikiy aŋgyak, ‘Kamb par bi korip gep gok yiruk gek kirgiyak ak, miñiy korip sap nambyaŋ ak piŋiyñiy mindip aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nop Ñinuk kun ak nep chinup aŋgak ak mey; nup don, nuk gek, Gor biynimb nuk mindoniŋgambun. Pen biynimb gunap chinup di Gor yip jimñiy ayniŋgiy rek ma mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Piyta kun giy aŋgek, biyomb kun gok niŋiy aŋgyak, “Bi omiŋal biy sikul ma aŋgrik ak pen, minim kun biy ma pirikiy, monmon aspiyr. Jiysis yip taŋgyiŋgipay ak mey, kun gispiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","16","Bi tomb timey suŋ ayak ak, biynimb windin yirik ar ak mindakniŋ, kuyipmiŋay aŋg giniŋgiy rek ma ayek aŋgyak, “Kanjsol korip biy kirgiy, mis biyaŋ amnimiyr aŋgyak.” Kun aŋgey, mis amerik, kiyk key aŋgniŋ aŋgniŋ giy aŋgyak, “Bi omiŋal biy tap mageprek ak ger, Jerusalem biynimb maŋgiysek niŋbay. Kun ak kuyipmiŋay yesek gipiyr aŋgiy, aŋgjun rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","18","Pen minim kun ak, biynimb gunap kunep aŋger niŋniŋgiy rek ayip ak, kuyip mer aŋgjun aŋgyak.” Kun aŋgiy, kuyipmiŋay aŋgey aper aŋgyak, “Jiysis nup yimb ak kisen ma yimb aŋgnimiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kun aŋgey, pen aŋgrik, “Chir Gor minim nup ak kirgiy, minim nimbip ak niŋor, Gor nup tep giniŋgamb akaŋ; nimb key niŋim. ");
INSERT INTO kmh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pen Jiysis yerer gak, minim yerip yerip aŋgak ak kirginjur rek ma ayip; biynimb gok kuyip aŋgñiniŋgambur aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Kun aŋgerik, Kanjsol biyomb gok gos key niŋiy, bi biy simiy ñin jiwiy ñin jiwiy mindiy, kisen suŋ ayip ak; biynimb gok Gor nup tep aspay. Bi omiŋal kun biy kuyip, tap bap goniŋgambun; kaljiwniŋgambay aŋgiy, kuyipmiŋay yikop minim yomb aŋgiy, aŋg mis yokyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Piyta yip, Jon yip kuyipmiŋay kun giy aŋg mis yokey, kiyk am, Jiysis biynimb nuk gunap kuyip niŋiy, bi kanjsol yomb gok, minim yerip yerip aŋgyak ak aŋgñirik. ");
INSERT INTO kmh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aŋgerik niŋiy, maŋgiysek Gor nup aŋgniŋiy aŋgyak, “Nand Biyomb! Semb biyoŋ gay, man biy gay, ñiŋg solwara gay, tap yerip yerip mindip okok maŋgiysek gaynak. ");
INSERT INTO kmh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wosrey Kawnan nand ak basind Depiyt nup gos ñek, minim nip ak aŋgiy aŋgak: ‘Jiwda biynimb gok sek, Jiwda biynimb mer gok sek kaljiwiy, Gor apiymiŋay yip penpen gun apay ak pen; kuyip apiymiŋay tap bap giniŋgiy rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kiyŋ miñmon okok nimb gok sek, Jiwda biyomb gok sek minim aŋg jimñiy, Gor apiymiŋay yip penpen ginjun aŋgiy, minj moka giy mindpay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Basind Depiyt, minim nip tikak kun ak niŋind yimb aŋgiy tikak. Gapman biyomb Herot ak, Ponsis Paylat ak, biynimb okok nimb gunap, Yisrel guniy nimb gunap ap minim aŋg ar nokom ay; Ñi nip Jiysis nup timey giyak miñmon Jerusalem biy. Bi yikop bap mer; Ñi tep nand Krays nup kun giyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pen nind ‘Krays nup kun giniŋgambay aŋgnak’ ak mey, yaw aŋgey giyak; yikop ak kun ma gipyap. ");
INSERT INTO kmh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Bapiy yomb. Miñiy chinup minim kilis timey yimb aspay. Pen ak yikop aspay; nand mindpan. Chin biynimb nak yimb. Chinup kond mindenimin, ma pirikiy, minim nand ak biynimb okok kuyip monmon aŋgñinjun. ");
INSERT INTO kmh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Aŋgñiyiŋg, Ñinak suŋ-tep ak chin yip nep mindiy, biynimb tap gip gok gon suŋ ay, tap mageprek gunap sek ginjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pen Gor nup kun giy aŋgniŋ mindyakniŋ, korip mindeyak ak monmon rek diy, Gor Kawnan ak ap kuyip bak ayek, ma pirikiy, Gor minim ak monmon yimb aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pen biynimb Jiysis nup gosimb niŋyak kun gok, minim ar nokom aŋgiy, gos ar nokom niŋiy, tap kiyk yerip yerip mindek gok, tap chin asiy aŋgiy ma niŋyak; tap chin jimñiy aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bi Jiysis minim dand amemb gok, kilis giy aŋgyiŋgipay, “Jiysis nup ñaŋg ayey kumiy tikjakek, nup niŋnuk aŋgyiŋgipay.” Gor kuyip direp yimb gak. ");
INSERT INTO kmh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kiyk bap tap gunap tikdek ma mindeyak; maŋgiysek tap mindek. Biynimb mankumb akaŋ korip gunap mindek gok, bap yokiy maniy diyiŋg, dam bi Jiysis minim dand amemb gok kuyip ñiyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kiy pen diy, biynimb tap ma mindek gok kuyip bilok ñiyiŋgipay. Kun gey mey, biynimb gunap yimgeprek ma mindeyak; tap yerip tikdak ak mindek. ");
INSERT INTO kmh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pen bi Liypay kiñiŋ tik dand amiy tikyak bi bap, yimb nuk Josep. Miñmon nuk Saypras nimb. Bi kun ak nuk minim aŋgñirep giyiŋgip rek, bi Jiysis minim dand amemb gok, nup Banabas aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josep miñmon nuk wikan bap aŋgek tawyakniŋ, maniy kun ak dap bi Jiysis minim dand amemb gok kuyip ñak. ");
INSERT INTO kmh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Pen biber bap minderik. Nuŋgumiy yimb ak Ananayas, biynuk yimb ak Sapayra. Kiykber mankumb bap yoker, tawyakniŋ, maniy kun ak piskind ak ay piskind ak nuŋgumiy dand amiy, bi Jiysis minim dand amemb onep wimiŋgan ak kuyip ñak. ");
INSERT INTO kmh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pen nuŋgumiy maniy ak kun giy dap ñek, Piyta aŋgak, “Ananayas. Yenen Seytan yip mindiy, yesek aŋgiy apan, ‘Maniy maŋgiysek dand opiyn apan?’ Yesek apan kun ak, yip nep ma apan; Gor Kawnan ak nup kunep apan. Maniy nip mankumb tawpay kun ak, piskind ak weygiy opan. ");
INSERT INTO kmh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mankumb kun ak, mankumb nak. Yokniŋg yokpinap; kirginiŋg kirgipnap. Pen yokey maniy tawembiyap; maŋgiysek dand winiŋg dand opnap. Piskind ak korip kiriŋg winiŋg; kiriŋg opnap. Nak yesek apan ak, chinup nep ma apan; Gor nup kunep apan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Piyta kun aŋgek, Ananayas won kun ak nep pisnep kumiy, apyap lum biyaŋ pikak. Kun giy kumek, biynimb gok gak kun ak niŋiy, jel pirikyak. Pen bi paranj gok apiy, nup chech kom kom giy, dam komyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Biynuk, nuŋgumiy nup kumek dam komyak kun ak ma niŋak. Nuk yep takiy won bap mindiy apchakek, Piyta nup aŋgak, “Mankumb nirber ak yoker, yerip yerip tawyak?” Aŋgek aŋgak, “Mey bi ak dand wip rek tawyak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kun aŋgek, Piyta nup aŋgak, “Nirber yenen minim ayniŋ ayniŋ giy, yesek apiyr? Gor Kawnan ak minim kun ak ma niŋniŋgamb aŋgiy kun apiyr? Niŋan! Naŋgumiy kumamb, dam kombay bi gok, mindpay kinjeŋrumb biy. Nip kunep, dand amniŋg gispay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kun aŋgakniŋ, won kun anep, pisnep kumiy, Piyta tomb aŋgin siŋak apyap pikak. Bi paranj tiwin nuŋgumiy nup dam komyak kun ak apiy niŋyak; biynuk kunep pisnep kumek, nup dand amiy nuŋgumiy nup komyak gol siŋak komyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Biynimb Jiysis ker mindeyak gok sek, biynimb yikop gok sek tap gak kun ak niŋiy, pirikyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bi Jiysis minim dand amemb onep wimiŋgan ak, tap mageprek gunap biynimb namb okok giyiŋg mindeyak. Biynimb Jiysis nup gosimb niŋyak gok maŋgiysek ap nan-giyiŋgipay; Gor aŋgniŋep korip mis ar “Solomon korip bandak band aŋgyiŋgipay ak. ");
INSERT INTO kmh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Biynimb yikop gok, kuyip niŋey tep gak ak pen, Gor yip mindpay kun ak yergiy am kiy yip yiŋgoŋg ginjun aŋgiy pirikyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pen minek minek biynimb gunap sek Jiysis nup gosimb niŋiy, biynimb nindnimb gok yip ap yiŋgoŋg giyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jerusalem biynimb bi Jiysis minim dand amemb gok giyak rek niŋiy, biynimb tap gak gok dand kinjeŋ yomb gol ak apiy, minj dam miŋgan miŋgan par ay aŋgyak, “Piyta pandikek, pumb kawnan nuk ak, kuyip pikniŋeniŋgamb, suŋ ayniŋgamb aŋgyak” ");
INSERT INTO kmh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Biynimb miñmon yep maŋ kun okok mindeyak gok kunep: biynimb tap gak gok diy, kichekiy malñiluk sek mindeyak gok diy, dand wiyak. Dand apeyak, Piyta kuyip gek maŋgiysek suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pen Piyta kun gek niŋiy, bi Gor nup simboŋgep yomb yimb ak sek, buŋgiy nuk Sanjiwsiy gok sek bi Jiysis minim dand amemb gok kuyip miluk niŋiy, ");
INSERT INTO kmh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","miñ ay, dam gapman kuyip ñeyak; kalambis ayak. ");
INSERT INTO kmh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kuyip kun giy dam kalambis ayak ak pen, ñin kun anep kisyim biyaŋ, Gor aŋgek, enjol bap apiy, kinjeŋ ak yikiy, kuyip aŋgek mis amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Amey aŋgak, “Nimb Gor aŋgniŋep korip ak amiy, biynimb gok kuyip, yerip gey Gor gek perper mindeniŋgambay minim ak, aŋgñinimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aŋgek, miñmon tikakniŋ, Gor aŋgniŋep korip ak amiy, enjol ak aŋgak rek, biynimb gok kuyip minim aŋgñiyak. Kun giy aŋgñiyakniŋ, Gor nup simboŋgep yomb yimb ak binuk gok sek, Jiwda biyomb gunap sek kuyip suk aŋgek, ap kanjsol miytiyŋ ak nan-giy, Jiwda poliys gok kuyip aŋgyak, “Bi Jiysis minim dand amemb kalambis aypun ak, miñiy am poŋind owim aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aŋgeyak, bi Jiwda poliys kun gok amiy niŋyak: bi Jiysis minim dand amemb kun gok, ma mindeyak. Kun gek andkind apiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Chin amiy niŋbun; kinjeŋ ak giñiyak rek mindamb; bi poliys gok kunep kinjeŋrumb ak niŋmindambay ak pen, kinjeŋ yikiy, korip miŋgan biyaŋ amiy niŋbun; bi bap ma yimb mindambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kun aŋgeyak, Jiwda poliys kond mindep yomb ak sek, Gor nup simboŋgep yomb gok sek niŋiy, yergip aŋgiy, gos kuŋaynep niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kun giy niŋmindyakniŋ, bi bap apiy, kuyip aŋgak, “Bi kalambis aypik gok, kiyk am Gor aŋgniŋep korip miŋgan ak mindyiŋg, biynimb gok kuyip minim aŋgñispay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","Kun aŋgek, Jiwda poliys kond mindep yomb ak, poliys gunap poŋind, bi Jiysis minim dand amemb kun gok diniŋg amniyak. Amiy, Jerusalem biynimb chinup kamb jiw pikniŋgambay aŋgiy, kuyip ma aŋg giyak; kapkap poŋind kanjsol ap nan-gi mindeyak ak wiyak. Poŋind apeyak, Gor nup simboŋgep biyomb yimb ak kuyip aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nimbip Jiysis minim ak ma aŋgnimimb aŋgiy, kilis giy apun ak pen; aŋg mer niŋiy kirpun! Nimb Jerusalem biynimb kuyip maŋgiysek Jiysis minim ak aŋgñiyiŋg apim, ‘Kiyk nep nup pikayak aŋgiy aŋgñimbim’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kun aŋgek, Piyta binuk gunap yip aŋgyak, “Biynimb minim apay ak ma diniŋgambun; Gor minim ak diniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","Jiysis nup mon bak biyoŋ ñaŋgbirik ayenimbik kumak ak pen, apis basind sikop aŋgniŋyiŋgipay Gor anep gek, tip ak tikjakiy, semb biyoŋ amiy, Nop ñin yipund kind okok ken mindip. Kun ak niŋbun; nuk nep mey Biyomb chin, chinup Gor ker diniŋgamb. Nuk chinup Yisrel biynimb simb niŋimb ak mey; tap siy tap timey yerip yerip gipun ak kirgiy, nup aŋgniŋon, chinup dip. ");
INSERT INTO kmh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Gor gip kun ak niŋrep gipun rek, biynimb gok aŋgñimbun. Gor Kawnan ak kunep niŋrep giy, minim kun ak rek nep aŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kun aŋgeyak, bi kanjsol ap nan-gi mindeyak kun gok, kaljiwiy aŋgyak “Kuyip pisnep pikayjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kun aŋgyak ak pen, namb kun ak, bi bap mindek. Yimb nuk ak Gameliyel. Nuk bi Peresiy low tiysa kiyk bap. Jiwda biynimb maŋgiysek nup niŋey tep giyiŋgip. Bi Gameliyel kun ak tikjakiy aŋgak, “Bi tiwin biy kuyip aŋgem mis amey, nimbip minim bap aŋgiyn aŋgak.” Kun aŋgek, aŋg mis yokyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","kuyip aŋgak, “Yisrel bi guniy. Kuyip yerer giniŋg gispim ak, gos niŋrep giy ginimimb. ");
INSERT INTO kmh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nimb niŋbim; nind bi Tiyiwdas yand biyomb aŋgiy aŋgek mey, minim nuk aŋgyiŋgip ak biynimb kuŋaynep niŋyiŋgipay. Pen kisen gapman biyomb gok nup pisnep pikayeyak; biynimb minim nup niŋyak gok, keykey amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pen kisen, yimb diyak ñin ak kunep, bi Jiwdas Galiyliy nimb ak aŋgak, ‘Yand biyomb yimb mindpiyn. Minim apiyn rek nep giniŋgamb.’ Chin gapman gok yip penpen giy, kuyip aŋgyokniŋgambun aŋgakniŋ, biynimb kuŋaynep minim nup kisen giyak ak pen; mind dand amiy, bi kun ak nup ñaŋgeyak kumek, biynimb minim nuk aŋgek niŋyak gok, keykey amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Kun ak mey, nimbip aspiyn: bi kor gispun guniy kuyip, gi timey ma ginimimb. Minim kiyk keynep aŋgniŋgambay ak, yomb giniŋg rek giy apyowniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pen Gor nep aŋgek giniŋgambay ak, kuyip tap bap ginimimb rek ma ayniŋgamb. Kuyip timey giniŋg, kiyk yip ma penpen giniŋgambim; Gor yip penpen giniŋgambim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gameliyel kun aŋgek, aŋgak rek niŋiy, bi Jiysis minim dand amemb gok kuyip aŋgey apey, miñ diy tapin pikiy, Jiysis minim ak kisen ma yimb aŋgnimimb aŋgiy, kuyip aŋgyokeyak amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kiyk pen, chinup yenen kun gipay aŋgiy ma niŋyak; Gor chinup Jiysis binuk yipund giy aŋgiy gek mey, chinup kun gispay aŋgiy, tep gakniŋ amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amiy, minek minek, korip okok amiy, Gor aŋgniŋep korip mis ar ak amiy, minim tep ak aŋgñiyiŋg, Jiysis nep mey, Kiyŋ yomb key yimb ak aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pen mind dand amiy, biynimb Jiysis nup gosimb niŋyak gok kuŋay yimb amek, Jiwda biynimb Griyk minim nep niŋyak gok; Jiwda minim yipund giy niŋyak gok kuyip aŋgjiwiy aŋgyak, “Biyn yandiw kiyk gok kuyip, maniy keñmaŋgiy tap okok bilok ñirep gipay ak pen; yenen biyn yandiw chinup gok kuyip kun ma gipay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Kun aŋgeyak, bi Jiysis minim dand amemb gok, biynimb Jiysis nup chiŋgiyak gok maŋgiysek suk aŋgey apey aŋgyak, “Mam ay sikop. Chin Gor minim aŋgñimbun ak kirgiy, biynimb gok kuyip tap bilok ñiniŋgambun ak, yipund ma giniŋgamb. Kun ak, nimb bi onep ar ak niŋiy dem, kuyip woŋg kun ak aŋgayjun. Bi yikop gunap ma dinimimb; Bi Gor Kawnan yip mindiy, gosimb niŋrep giy, biynimb niŋey tep gip gok nep dinimimb. ");
INSERT INTO kmh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kun giy dem mey, kuyip tap bilokep woŋg ar kun ak aŋgay, chin pen, Gor nup aŋgniŋyiŋg, biynimb gok kuyip minim tep ak aŋgñiyiŋg gi mindeniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","6","Kun aŋgeyak, niŋey kuyip tep gek, bi onep ar ak aŋgay, dand bi Jiysis minim dand amemb gok mindeyak ak apey, ñin jun ar ay aŋgyak, “Gor. Nand bi guniy kuyip kond mindenimin aŋgyak.” Bi kun gok mey, Stiypin bi Gor nup chiŋgiy, Gor Kawnan yip nep mindek ak; Piyliyp ak; Prokoras ak; Naykena ak; Tiymon ak; Pamiynas ak; Niykolas ak. Bi Niykolas kun ak, nuk miñmon Antiyok nimb ak pen; nind Jiwda lotiw minim ar ak kindik giy, kisen Jiysis nup chiŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pen bi Jiysis minim dand amemb gok, kiyk Gor minim ak aŋgñey amnakniŋ, Jerusalem biynimb kuŋay yimb nep niŋyak. Bi Gor nup simboŋgep yomb gok kunep; kuŋaynep, Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiypin, bi Gor Kawnan yip mindek ak, tap mageprek gok, biynimb mindyiŋgipay namb okok giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pen Jiwda bi miñmon keykey okok nimb gunap ap nan-giy, minim ar nokom aŋgey niŋiy kuyip “Priyman” aŋgyiŋgipay. Bi kun gok, gunap Sayriyniy nimb, gunap Aleksandriya nimb, gunap Siyliysiya nimb, gunap Esiya nimb. Kiyk Stiypin gak rek niŋiy, nup minim kilis yimb giy aŋgyak ak pen, ");
INSERT INTO kmh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gor Kawnan ak nup gos tep yimb ñakniŋ, minim yerip aŋgyak ak, gosimb niŋrep giy pen kunep aŋgek, nup pen aŋgniŋgiy rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pen kiyk Stiypin nup aŋg mer niŋiy, am bi minim yesek aŋgep gok kuyip kapkap aŋgrep gey, kiyk apiy aŋgyak, “Chin niŋbun; bi biy Mosis minim tikak ak aŋgjiwiy, Gor nup aŋgjiwiy gip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kun aŋgiy, bi low tiysa gok diy, bi kanjsol gok diy, biynimb yikop gok diy simbwur kuyip ak timey gek, Stiypin nup kor giniŋg, dand kanjsol kay mindeyak ak amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dand amiy, bi yesek aŋgep gunap sek dand apey, kiyk aŋgyak, “Chin niŋbun: bi kun biy per Gor aŋgniŋep korip ak aŋgjiwiy, chinup Jiwda kay low minim apun ak aŋgjiwiy gip aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pen nuk minim bap aŋgek niŋnuk ak aŋgak, ‘Jiysis bi Nasaret nimb ak, kisen Gor aŋgniŋep korip biy timey giy, Mosis minim aŋgek gipay ak aŋgek, kirgiy giniŋgambay aŋgak’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pen bi kun gok, bi kanjsol gok yip niŋmindyakniŋ, Stiypin jomluk nup ak, enjol jomluk rek ayak. ");
INSERT INTO kmh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pen bi Gor nup simboŋgep yomb yimb ak, Stiypin nup aŋgak, “Minim nip apay kun ak, niŋind apay akaŋ?” ");
INSERT INTO kmh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aŋgek, Stiypin aŋgak, “Bapiy mam sikop. Niŋim! Basind yes chin Ebraham, wosrey miñmon Haran ma amnak, miñmon Mesopotemiya nep mindakniŋ, Gor Biyomb tep yimb chin ak nup aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Miñmon nak biy kirgiy, biynimb kanj kayn nak gok kirgiy, miñmon yand nip aŋgñiniŋgayn ak amnimin aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aŋgek, Ebraham miñmon yomb Kaldiya mindyiŋgip ak kirgiy, miñmon Haran am mindyiŋgip. Kisen nop kumek, Gor aŋgek, ap mindyiŋgip miñmon Jiwda biy. ");
INSERT INTO kmh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ñin kun ak, Gor Ebraham nup, mankumb wikan bap ma aŋgak; yikop ap mindyiŋgip. “Pen ñin kun ak, Ebraham ñapan bap ma tikak, yikop nep mindek. Gor Ebraham nup aŋgak, ‘Kisen mankumb kun biy, nand diniŋgamban. Ñapan nand tikeniŋgamban tikey amniŋgamb gok, mankumb kun biy kunep diy mindeniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pen Gor minim bap aŋgak, ‘Ñapan nand tikeniŋgamban tikey amniŋgamb gok, am biynimb gunap miñmon okok mindey, kuyip maŋgiysek miñ ay, timey yimb giy, kalambis woŋg rek aŋgayey giyakniŋ; simiy pow handret (400) yiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Biynimb nip gok kuyip kun giniŋgambay ak, yand kuyip timey giniŋgayn. Biynimb nak gok, miñmon kun ak kirgiy, ap yip lotiw gi mindeniŋgambay miñmon biy aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Pen Gor Ebraham nup minim bap aŋgay aŋgak, ‘Ñapan nand tikeniŋgamban tikey amniŋgamb gok, nimbip maŋgiysek kond mindeniŋgayn ak mey, kumbak tiknimimb aŋgak.’ Aŋgek, kisen Ebraham ñinuk Aysek nup tikiy, ñin onep jiy ak mindiy, kumbak nup ak tikak. Aysek pen Jekop nup tikak. Jekop nund pen, ñi onep wimiŋgan ak kuyip tikek mey, chin Jiwda biynimb kiñiŋ keykey mindpun. ");
INSERT INTO kmh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Basind kun gok, numam Josep nup niŋey yiruk gek, bi gunap kuyip ñeyak, taw dand miñmon Yijip amniyak. Dand amey, mindrep ma gak ak pen, Gor Josep nup sakiy ma gak; nuk yip nep mindiy, ");
INSERT INTO kmh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yijip biyomb Perow nup gos ñek aŋgak, ‘Bi Josep biy, niŋrep yimb gip aŋgiy’ nup aŋgek, korip tap nup gok sek, miñmon Yijip sek kond mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kisen ñin bap yiwan yomb sikerek ak, miñmon Yijip sek, miñmon Keynan sek apek, basind chin tap keñmaŋgiy piyow niŋiy, ñiŋniŋgiy rek bap ma mindek; gos par yimb ayak. ");
INSERT INTO kmh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekop minim bap niŋak; tap keñmaŋgiy kuŋay mindek miñmon Yijip ak mey, ñinuk sikop kuyip aŋgek, keñmaŋgiy tawniŋg amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Am taw dand apiy, ñimb diy, tip ak pen tawniŋg amniyak. Amjakey, numam Josep kuyip aŋgak, ‘Mam sikop, nimb yip an aŋgiy niŋbim? Yand namam nimbik Josep nep aŋgak.’ Aŋgek, Yijip biyomb Perow, minim kun ak niŋiy aŋgak, ‘Ak Josep numam sikop-ey aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep pen, bapiy Jekop, biynimb nuk gok yip kasek winiŋgiy aŋgiy, minim yokek, nop Jekop biynimb ñin jiwiy omiŋal nokom rek diy, yip wiyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ap miñmon Yijip mindiy nuk kumak. Mind dand amiy, basind sikop kun gok maŋgiysek kumdiyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kuyip komniŋg; dand andkind miñmon Sekem amiy, komyak. Miñmon Sekem kun ak, basind yes Ebraham, binak Hemow nup tawiy, ñinuk sikop kuyip aŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pen Gor Ebraham nup nind giniŋgayn aŋgiy aŋgayak rek giniŋg gakniŋ, biynimb chin gok, tikey amiy apiy giy, kuŋay yimb mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","19","Ñin kun ak Yijip biynimb kiyŋ yomb kiyk kisenimb bap diyak. Kiyŋ kun ak, basind Josep nup ma niŋak ak mey, biynimb chinup gok timey yimb giy, minim kilis aŋgek, ñapan kiyk gok tikiy, mis okok yokey, key mindiy kumyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","22","“Kun giyak ak pen, ñin kun ak, biber bap ñi tep yimb bap tikiy, yimb nup Mosis aŋgrik. Ñi kun ak nup takin omiŋal nokom, korip miŋgan okok nep weyger mindyiŋgip. Kisen dam mis akyaŋ ayerik, kiyŋ panuk ak ap nup niŋiy, dand amiy, ñapan yand aŋgiy yimaŋgiyiŋgip. Nup kun giy yimaŋgiyek yomb gek, Yijip biynimb kiyk yerer giyiŋgipay ak, nup aŋgñirep giyak. Nuk bi minim kilis giy aŋgiy, woŋg kilis giy giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","24","“Pen Mosis simiy nuk kuŋaynep yinek aŋgak, ‘Biynimb yand Yisrel kuyip am niŋiy wiyn aŋgak.’ Pen ñin kun ak niŋak; Yijip bi bap, Yisrel bap yip penpen gerik. Mosis niŋiy, Yijip bi anup pisnep yimb pikayek kumak. ");
INSERT INTO kmh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pen, Mosis gosimb nuk niŋak ak: Biynimb yand Yisrel biynimb gok aŋgniŋgambay, ‘Gor Mosis nup gosimb ñek, ap chinup kond mindniŋg gisap ak mey; kisen mindrep giniŋgambun aŋgniŋgambay aŋgiy’ niŋak ak pen, gos kun ak rek kiyk ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Pen minek ap niŋak; Yisrel bi omiŋal penpen gerik. Niŋiy aŋgak, ‘Mam omiŋal. Nir omiŋal penpen gispiyr ak kirgiyr aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aŋgek, numam bap Mosis nup diyokiy aŋgak, ‘Nip an aŋgek, biyomb mindiy, chinup kond mindpan? ");
INSERT INTO kmh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Toyrik Yijip bi bap pikaynak ak; miñiy pen yip pikayniŋg ap aspan?’ ");
INSERT INTO kmh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","30","“Kun aŋgek, bi pikaypiyn kun ak niŋbay aŋgiy, Mosis pirik miñmon Miydiyen amiy, bi yikop bap rek mindek, simiy ñin jiwiy omiŋal rek yinak. Ñin namb kun ak, nuk biyn diy, ñi omiŋal tikak. Kisen minek bap, am miñmon nep Saynay dum maŋ okok mindiy niŋak: enjol bap ap mon bind ak mindiy, mon maŋlaŋ rek gak. ");
INSERT INTO kmh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Kun gek, Mosis niŋiy, tap kun ak yerip gip aŋgiy, maŋ siŋak apiy niŋakniŋ, Gor aŋgak, ‘Nasind yes Ebraham, Aysek, Jekop, Gor kiyk mey yand nep aŋgak.’ Kun aŋgek, ‘Ak Gor nep aŋgip aŋgiy,’ pirikiy kuyaŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pen Gor Mosis nup aŋgak, ‘Yand Biyomb suŋ-tep yimb ak; wikan biy opan rek, tomb tirup nand ak tuŋgasikan. ");
INSERT INTO kmh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yand niŋbiyn: Yijip biynimb gok, biynimb yip Yisrel kay kuyip timey yimb gey, siy apay. Kun ak niŋiy, kuyip ap dand amniŋg gispiyn. Nand Yijip amnimin aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Gak kun ak mey, bi Yisrel biynimb nup nind, an aŋgek chinup kond mindniŋg gispan aŋgyak ak nep; Gor mon maŋlaŋ rek giyiŋg aŋgek, biyomb kiyk mindiy, kuyip diniŋg andkind Yijip amnak. ");
INSERT INTO kmh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yijip amiy, tap mageprek gunap kuŋay yimb nep giy, biynimb nuk Yisrel kuyip dand ñiŋg solwara ‘Likañ’ apay ak, tikiy kind bindoŋ ameyak, tap mageprek gok gi mindyiŋgip. Kun gi mindek, simiy ñin jiwiy omiŋal yinak. ");
INSERT INTO kmh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","38","Nuk kun okok mindiy, enjol minim aŋgek niŋiy, biynimb gok kuyip aŋgñiyiŋgip. Nuk nep mey, minim bap aŋgak, ‘Kisen Gor namam nimbip bap deniŋgamb, nimbip Gor minim aŋgñimbiyn rek ak aŋgñiniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nuk Gor minim tep ak chinup maŋgiysek aŋgñak ak pen, basind chin gok minim aŋgak ak ma niŋyak. Kiyk Mosis nup kirgiy, andkind Yijip amnun aŋgiy gos ak niŋiy, ");
INSERT INTO kmh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mosis numam Eron nup aŋgyak, ‘Namam chinup Yijip nimb dand owak ak, akay amimb ak ma niŋbun. kun ak nand tap chin aŋgniŋjun gunap gayey, chinup kond mindyakniŋ, andkind Yijip amnun aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Kun aŋgiy, kaw ñiluk rek bap gay, kuyip tep gakniŋ, tap ñiŋemb pik dap simboŋg ñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Kun geyak, Gor kuyip kirgiy aŋgak, ‘Kun gipay ak, pumb, takin, gap gok monmon aŋgniŋyaŋ aŋgak.’ Ñin kun ak kiyk tap kun gok nep aŋgniŋyak ak mey, bi Gor minim aŋgep bap, Gor aŋgak rek, buk ak tikiy aŋgak: ‘Yisrel biynimb. Nimb nind simiy ñin jiwiy omiŋal rek, miñmon nep namb okok taŋgyiŋgipim ñin ak, kanj kaw siypsiyp tap okok pikiy yip simboŋgipik? Ak yip ma simboŋgipik. Nimb pen tap yesek omiŋal, key gaypik ak aŋgniŋyiŋgipim. ");
INSERT INTO kmh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tap kun ak, bap Molok aŋgyiŋgipim. Bap gap rek gay, Repan aŋgyiŋgipim. Tap gor yesek omiŋal kun ak nep, ser korip gi dand taŋgyiŋg, lotiw gi mindyiŋgipim. Gipik kun ak, yand nimbip aŋgyoken, am kalambis mindeniŋgambim miñmon Babiylon bak okok aŋgak.’.” ");
INSERT INTO kmh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stiypin kun aŋgiy, minim bap pen aŋgak, “Wosrey basind sikop miñmon nep namb okok mindyiŋgipay ñin ak, Mosis Saynay dum biyoŋ amek, Gor nup minim gunap aŋgiy aŋgak, ‘Sel korip yip gosimb niŋniŋgiy bap kun kun giy giniŋgiy aŋgek,’ Mosis ap kuyip aŋgek, korip aŋgak kun ak rek giyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","46","Geyak, pernep mindyiŋgip. Pen Mosis kumek, basind Josiwa kuyip poŋind, ser korip kun ak dand wiyakniŋ, biynimb kind akniy mindeyak gok, ñawil di mindyakniŋ, kuyip pisnep yuk yokyak. Ser korip kun ak mindiy, mind dand amiy, kisen kiyŋ Depiyt, bi Gor niŋek tep gak ak, Gor nup aŋgniŋiy aŋgak, ‘Yand korip nip tep bap gen, chin Jekop ñapan nuk gok ap korip kun ak nip aŋgniŋjun?’ ");
INSERT INTO kmh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aŋgek, Gor aŋgak ‘Mer. Ñi nand Solomon nep korip yip ak giniŋgamb aŋgak.’ Aŋgek, kisen ñinuk Solomon Gor aŋgniŋep korip aŋgak kun ak gak. ");
INSERT INTO kmh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pen Biyomb Gor tap okok maŋgiysek gayak ak, biynimb ñin maŋgiy diy korip giniŋgambay ak, nuk ma mindeniŋgamb. Bi Gor minim aŋgep bap minim kun ak aŋgiy aŋgak: ");
INSERT INTO kmh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Semb biyoŋ gay, yand mindpiyn. Man biy gay, tomb yand aypiyn. Yip yerip korip tep ak giy, añiŋ ayaŋ aŋgiy apim? ");
INSERT INTO kmh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tap gok maŋgiysek ñin maŋgiy yand ak ma gaypiyn akaŋ aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiypin minim kun ak kun giy aŋgiy aŋgak, “Nimb minim ma niŋiy, timey yimb nep gipim. Gor Kawnan ak nimbip gos tep ñek niŋbikip ak pen, per mer apim. Nasind sikop giyiŋgipay rek nep gipim. ");
INSERT INTO kmh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nasind sikop bi Gor minim aŋgep gunap kuyip ma kirgiyak, maŋgiysek timey giyak. Gor Ñi tep ak winiŋgamb aŋgyak gok kuyip maŋgiysek pikayak. Nimb pen; Ñinuk tep ak apek, mimuŋg niŋiy ñapik. ");
INSERT INTO kmh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pen Gor low minim nuk, enjol gok kuyip aŋgek dand wiyak ak, niŋiy ma dipik aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiypin minim kun ak aŋgakniŋ, kuyip milukrimey yimb yapek, meŋg siwbirikiy kaljiwyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pen Gor Kawnan ak Stiypin yip mindek ak mey; semb ar biyoŋ niŋak: Gor melik tep ak sek mindiy, Jiysis bak siŋak mindek. ");
INSERT INTO kmh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Niŋiy aŋgak, “Niŋim! Yand niŋsipiyn; semb biyoŋ miŋgan sek mindip. Gor Ñinuk ñin yipund kind okok ken jakiy mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Stiypin kun aŋgek, timund kiyk ak pilgiy, nup minim yomb yimb aŋgiy, maŋgiysek tikjakiy, ap nup chichiy diy, dand mis akyaŋ ken amniyak. Dand amiy, bi nup minim yesek aŋgyak gok, kaljiwiy, tiŋgliys kiyk gok tuŋgasik, bi paranj Sol mindek maŋ siŋak ayey, nuk kond mindakniŋ, kiyk Stiypin nup kamb jiw pikyak. ");
INSERT INTO kmh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nup kun giy pikyakniŋ, aŋgak, “Jiysis! Kawnan yip ak dan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kun aŋgiy koŋgim piŋiy, meŋg miŋgan dand araniy aŋgak, “Biyomb. Yip pikaysipay biy, tap siy tap timey gispay ak niŋiy kirginimin aŋgak.” Kun aŋgiy kumak. ");
INSERT INTO kmh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Stiypin kumek, bi Jiysis nup gosimb niŋyak gunap, simb gek siy aŋgyiŋg, dam komyak. Nup pikey kumak kun ak, binak Sol panj aŋgak. Ñin kun ak, Jerusalem kay, biynimb Jiysis nup gosimb niŋyak gok kuyip, timey giniŋg nep giyak. Sol nuk korip korip giyiŋg, biynimb gok kuyip monmon nep pik lipiŋg dam miñ ayiŋgip. Kun gek, gunap pirik, Samariya amniyak; gunap pirik miñmon Jiwdiya tiŋgoŋ okok amniyak. Bi Jiysis minim dand amemb onep wimiŋgan ak, kiyk Jerusalem nep mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Biynimb Jiysis nup gosimb niŋiy, pirik am miñmon okok mindeyak gok, biynimb kun okok kuyip, Jiysis minim tep ak aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Binak Piyliyp pen, am miñmon Samariya mindiy, biynimb gok kuyip, Biyomb per kond mindyiŋgipun ak wip aŋgiy, aŋgñiyiŋg, tap mageprek gok gak. Minim nuk yerip yerip aŋgak ak, timund pik niŋrep yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Biynimb kichekiy malñiluk sek mindeyak gok, gosimb niŋyaŋ aŋgiy, tap kun gok aŋgek, wal aŋgyiŋg mis amniyak. Biynimb ñin tomb kalaw gak gok sek, biynimb ñin tomb timey gak gok sek gek, suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kun gek, biynimb maŋgiysek miñmiñ yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pen miñmon yomb kun ak, bi bap mindyiŋgip. Yimb nuk Saymon. Nuk kunj giy, tap mageprek gunap giy, yesek aŋgiy aŋgyiŋgip, “Yand biyomb.” Aŋgek, Samariya biynimb gos kuŋay yimb niŋyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Biynimb yimb mindek gok, biynimb yimb ma mindek gok, Saymon minim aŋgak rek nep niŋyak. Niŋiy aŋgyak, “Bi kal timey kun biy, bi bap key mer; mey biyomb kond mindyiŋgipun anep aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tap mageprek gok per gakniŋ, biynimb gok gos kuŋay niŋiy; minim aŋgak rek nep niŋyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pen kisen Piyliyp apiy, kuyip Gor biynimb diy kond mindeniŋgamb minim tep ak aŋgñiyiŋg, Jiysis mey, bi Kiyŋ yomb key yimb per kond mindpun ak aŋgek, Jiysis nup gosimb niŋiy, ñiŋg pikyak. ");
INSERT INTO kmh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saymon kunep, Jiysis nup gosimb niŋiy, ñiŋg pikiy, Piyliyp nup kisen gakniŋ, nuk tap mageprek gok kuŋay yimb nep gek niŋiy, Saymon gos par yimb ayak. ");
INSERT INTO kmh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bi Jiysis minim dand amemb onep wimiŋgan ak, Jerusalem mindey, kuyip minim bap aŋgyak, “Samariya biynimb Gor minim niŋsipay aŋgyak.” Kun aŋgeyak niŋiy, Piyta yip, Jon yip kuyip aŋgyokey, Samariya amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Amiy, Gor nup aŋgniŋiy aŋgrik, “Biynimb guniy Jiysis nup gosimb niŋyak ak pen, Kawnan nip ak diy ñiŋg ma pikyak aŋgrik.” Kun aŋgiy, kuyip diniŋyiŋg aŋgrik, “Kawnan nand ak kuyip nokom nokom yoknimin aŋger,” Gor Kawnan nuk ak kuyip keykey yokak. ");
INSERT INTO kmh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kiykmiŋay kun giy Gor nup aŋgniŋer, Kawnan nuk ak biynimb gok kuyip yokak ak, Saymon niŋiy, yand kunep ginim aŋgiy, kuyipmiŋay maniy yomyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Gor niripmiŋay kond mindakniŋ, biynimb gok yikop diniŋer, Kawnan nuk kuyip ker amimb ak, nirip tawiy yand kunep ginim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kun aŋgek, Piyta aŋgak, “Gor Kawnan nuk yikop ñimb kun ak, yenen tawniŋg gispan? Maniy kun ak nak yip key kuyiŋg yownimuŋ! ");
INSERT INTO kmh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Woŋg chir gipur ak nak yip mer. Gosimb nand niŋban ak, Gor niŋek tep ma gip. ");
INSERT INTO kmh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Yand niŋbiyn: gos timey niŋban kun ak, nip miñ ay wos giniŋg gisap. Tap siy tap timey ginim aŋgiy gos niŋban ak kirgiy, miluk niŋban ak kirgiy, Gor nup aŋgniŋeniŋgamban, timey yimb gipan kun gok niŋiy kirginiŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Aŋgek, Saymon aŋgak, “Nirmiŋay biyomb anup aŋgniŋer, tap yip ginimuŋ aŋgiy aspiyr kun ak ma ginimuŋ aŋgak.” Aŋgek, aŋgak rek girik. ");
INSERT INTO kmh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pen Piyta yip, Jon yip biynimb okok kuyip, Jiysis kuyipmiŋay yerer gak minim ak aŋgñiy, andkind Jerusalem amniŋg, kinjeŋnamb okok amyiŋg, Samariya biynimb wikan gunap kuyip, Gor minim tep ak aŋgñiyiŋg amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pen Gor enjol bap apiy, Piyliyp nup aŋgak, “Jerusalem nimb Gasa ambay kinjeŋ par ak amnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aŋgek, Piyliyp kinjeŋ aŋgak par kun ak amiy niŋak: biyomb bap, kanj hos lipiŋg dand taŋgip tap band ar ak bisgiy, kinjeŋ ar kun ak amek. Bi kun ak nuk, kiwiyn biyn yomb miñmon Yitiyopiya kond mindep ak nup woŋg giyiŋg, maniy nup ak kond mindyiŋgip. Pen nuk Jerusalem Gor aŋgniŋep korip ak amiy, lotiw mindiy, ");
INSERT INTO kmh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","andkind miñmon Yitiyopiya amniŋg, Baybol buk band, Asaya tikak ak diy, niŋyiŋg amek. ");
INSERT INTO kmh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pen Gor Kawnan ak Piyliyp nup aŋgak, “Hos tap band lipiŋg dand amjap bak siŋak amiy, yip amnimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aŋgek, Piyliyp aŋgak rek amiy niŋak: biyomb Yitiyopiya nimb kun ak, bi Gor minim aŋgep Asaya buk band tikak ak, niŋyiŋg amek. Piyliyp niŋiy aŋgak, “Buk niŋyiŋg amjipan kayaŋ ak, minim kiñiŋ ak aspiyn kun aŋgiy niŋsipan akaŋ mer?” ");
INSERT INTO kmh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Aŋgek aŋgak, “Biynimb gunap yip minim kun ak aŋgñey niŋiy rek, niŋnim aŋgak.” Kun aŋgiy, Piyliyp nup aŋgak, “Ap ar biy bisgey amnur aŋgak.” Aŋgek, am ar kun ak bisgak. ");
INSERT INTO kmh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pen Baybol buk band Asaya tikak kun ak aŋgak: “Kanj siypsiyp ñiluk pikniŋg; yikop poŋind amiy pikpay. Pen kas kuyip gok tikyakniŋ, wal ma apay. Kun ak rek nup kunep gey, minim ma aŋgniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tap timey bap ma yimb giniŋgamb ak pen; nup yesek aŋgiy, pikniŋgambay ak, kisen bi an rek mindiy kun kun giyiŋgip aŋgniŋgamb? Nuk ñi pañ gunap tikayek ak, kun apyap aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Asaya minim aŋgiy tikak kun ak niŋiy, biyomb Yitiyopiya nimb ak Piyliyp nup aŋgak, “Anup aŋgak? Nuk key akaŋ, biynimb gunap kuyip aŋgak?” ");
INSERT INTO kmh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aŋgek, Piyliyp bi kun anup, Asaya minim tikak kiñiŋ kun ak aŋgiy, Jiysis nup minim tep ak aŋgñirep gak. ");
INSERT INTO kmh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pen kun giy minim aŋg dand amyiŋg niŋrik, ñiŋg bap mindek. Bi kun ak Piyliyp nup aŋgak, “Ñiŋg mindip biy, yip ñiŋg pik ñiniŋgamban?” ");
INSERT INTO kmh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Aŋgek aŋgak, “Nand Krays nup gosimb niŋiy mey, ñiŋg pikniŋgamban aŋgak.” Kun aŋgek aŋgak, “Yand niŋbiyn; Jiysis Krays mey Gor Ñinuk yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aŋgek, hos tap lipiŋg dand taŋgip ar bisgiy aperik ak, hos ak sek kun siŋak ay, ñiŋg biyaŋ amiy, Piyliyp bi kun anup, ñiŋg pikñak. ");
INSERT INTO kmh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kun giy ñiŋg pikñiy, kumb biyoŋ wirikniŋ, Gor Kawnan ak, Piyliyp nup dand wikan bap amek, bi kun ak nup ma niŋak. Nuk pen miñiy Jiysis yip mindpiyn aŋgiy, tep gakniŋ, Yitiyopiya amnak. ");
INSERT INTO kmh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pen Gor Kawnan ak Piyliyp nup dam miñmon Esdot ayek, biynimb miñmon kun okok mindeyak gok kuyip, Jiysis minim tep ak aŋgñiyiŋg aŋgñiyiŋg, gi dam dam miñmon Siysariya amjakak. ");
INSERT INTO kmh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pen Sol biynimb Jiysis minim niŋyak gok kuyip pikayin aŋgiy, per kilis yimb giyiŋgip. Minek bap am bi Gor nup simboŋgep yomb yimb anup aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Yip minj gunap tikñenimin; dand Jiwda nan-gep korip keykey mindip miñmon yomb Damaskas amiy, kuyip ñiniŋgayn. Minj kun ak tikiy aŋgnimin, ‘Nimb biynimb Jiwda nan-gep korip miñmon Damaskas nimb opim gok, biynimb Jiysis nup gosimb niŋbay gunap mindeniŋgiy ak; Sol nup aŋgem, miñ ay, dand Jerusalem winimuŋ aŋgiy,’ tiknimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kun aŋgek, minj keykey tikñakniŋ, dand Damaskas maŋ maŋ gakniŋ; melik yomb ak, semb biyoŋ nimb nup niŋak. ");
INSERT INTO kmh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Niŋek, Sol kanj hos ar biyoŋ nimb apyap man biyaŋ pikakniŋ, minim bap aŋgak, “Sol! Sol! Yip yenen per pikniŋg gipan?” ");
INSERT INTO kmh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Aŋgek aŋgak, “Biyomb. Nand an?” Aŋgek aŋgak, “Yand Jiysis, yip per pikayniŋg gipan ak nep nip aspiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kun aŋgiy aŋgak, “Nand tikjakiy, miñmon yomb Damaskas amiy, bi bap ap nip minim aŋgnimuŋ rek niŋiy ginimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pen bi Sol yip wiyak gok, nuk apyap pikakniŋ, minim maŋgiy anep niŋiy, bi nonim ak ma niŋiy, gospar ay minim gunap ma yimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nuk kun giy apyap pikiy, tikjakiy niŋak; windin nup ak pisnep koy gak. Kun gek, binuk yip wiyak gok, ñin kind nup ak diy, poŋind Damaskas amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nup kun giy windin koy gek; ñiŋg, keñmaŋgiy tap gok ma ñimbiy, ñin omiŋal nokom, yikop nep mindek. ");
INSERT INTO kmh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pen bi bap miñmon kun ak mindek. Yimb nuk ak Ananayas. Nuk day niŋak; Jiysis nup aŋgak, “Ananayas!” ");
INSERT INTO kmh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Aŋgek, Jiysis aŋgak, “Sol bi miñmon Tasas nimb ak, day niŋimb: nup am diniŋamban, windin koy gak ak suŋ ayip. Nuk miñiy yip aŋgniŋyiŋg mindip Jiwdas korip ak. Kun ak nand kinjeŋ ‘Yipund’ apay ak amiy, Jiwdas korip amjakiy kuyip aŋgnimin, ‘Sol nup niŋniŋg aswiyn aŋgnimin’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jiysis kun aŋgek, Ananayas aŋgak, “Biyomb. Yand niŋbiyn: biynimb kuŋay yimb nep apay, ‘Bi Sol kun ak biynimb nip ker mindpay gok kuyip, per timey yimb gip miñmon Jerusalem apay.’ ");
INSERT INTO kmh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nuk miñiy wip biy, yikop ma wip: biyomb Gor nup simboŋgipay gok, minim kuyip ak niŋiy, chin lotiw mindiy yimb nip apun gok, miñ ayin aŋgiy wip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananayas kun aŋgek, Jiysis aŋgak, “Amnimin apiyn kun ak, ma piriknimin. Bi kun anup woŋg gunap pisnep aŋgaypiyn. Nuk minim tep yip ak Yisrel biynimb guniy aŋgñiy, biynimb okok kuyip aŋgñiy, biyomb gunap aŋgñiy, giniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pen yand gen nup añiŋ yapiy, miker yomb diyiŋg, woŋg kun ak giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pen Ananayas kun giy day niŋiy, Jiwdas korip ak amiy niŋak: Sol mindek. Nup diniŋyiŋg aŋgak, “Mam Sol. Bi Jiysis kinjeŋnamb miseŋ gek niŋnak ak, yip aŋgyokamb aswiyn. Windin ak tip niŋiy, Gor Kawnan ak kunep dinimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kun aŋgakniŋ, tap aŋoy band rek windin nup yiwgiy mindek ak, waniŋgyowakniŋ, day windin niŋak. Won kun anep, Ananayas Sol nup ñiŋg pikñak. ");
INSERT INTO kmh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pen Sol ñin omiŋal nokom yikop kinak rek; tap ñimbek nup giy aŋgak. Pen Sol nuk Jiysis biynimb nuk gok yip Damaskas mindiy, ");
INSERT INTO kmh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jiwda nan-gep korip okok taŋgiy, Jiysis minim ak, biynimb gok kuyip aŋgñiy aŋgak, “Jiysis, Gor Ñinuk yipund giy yimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kun giy aŋgñek, niŋiy jiw di giyiŋg aŋgyak, “Bi biy mey, biynimb Jiysis nup gosimb niŋyak gok kuyip girimey giyiŋgip miñmon Jerusalem rek? Miñiy gunap sek miñ ay, dam Jerusalem biyomb gok kuyip ñiyn aŋgiy wip rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol Jiysis minim aŋg dand amiy, bi kiyŋ yomb key per kond mindyiŋgipun ak mey, Jiysis nep aŋgiy, yipund giy yimb nep aŋgek, bi Jiwda Damaskas mindeyak gok, minim bap pen aŋgniŋgiy rek ma ayak. ");
INSERT INTO kmh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pen kisen mind dand amiy, Jiwda kay ap nan-giy, minim aŋg ar nokom ay aŋgyak, “Sol nup pikayjun aŋgyak.” Minim aŋgyak kun ak Sol niŋak. ");
INSERT INTO kmh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","25","Miñmon yomb kun ak, kamb wariy nep gi kus kus giyak ak mey, kinjeŋ tam taŋgyiŋgipay taŋgyiŋgipay gok, Sol nup ñaŋgun aŋgiy, pumbnamb kisyimken ñiluk aymindyiŋgipay. Kun geyak minek bap, kisyimken biyaŋ Sol minim aŋgek bi minim nup niŋyiŋgipay gok, nup wand miŋgan yomb ak yiŋgiy, miñ tiwniŋgiy, lipiŋg wiyndiw miŋgan biyoŋ nimb lum biyaŋ yokeyak, pirik amnak. ");
INSERT INTO kmh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pen Sol Jerusalem amiy, biynimb Jiysis ker mindeyak gok yip jimñiy mindon aŋgek, kiyk niŋiy, bi biy Jiysis nup ma chiŋgip; chinup pikayniŋg nep wip aŋgiy, pirikyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kun geyak Banabas, Sol nup dand, bi Jiysis minim dand amemb gok mindeyak ak amiy, kuyip aŋgak, “Bi kun biy nup niŋiy ma piriknimimb. Minim tep chin niŋbun rek niŋimb. Minek bap miñmon Damaskas amniŋg, kinjeŋnamb ak amek, Jiysis miseŋ giy nup minim gunap aŋgek niŋak. Kisen am Damaskas biynimb kuyip, ma pirikiy, Jiysis minim tep ak monmon yimb aŋgñak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas kun aŋgek, Sol nup deyak, kiy yip Jerusalem mindiy, Jiysis minim tep ak ma pirikiy, monmon yimb aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pen bi Jiwda, Griyk minim aŋgyak gok, nuk yip penpen aŋg amiy apiy giy, pisnep pikayun aŋgiy gos ak niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pen bi Jiysis nup gosimb niŋyak gunap, minim kun ak niŋiy, nup poŋind dam Siysariya amiy, yokey miñmon nuk Tasas amnak. ");
INSERT INTO kmh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ñin kun ak, miñmon Jiwdiya, Galiyliy, Samariya, biynimb Jiysis nup gosimb niŋyak gok, mind tep giy, Gor minim ma kirgiy; direp yimb ginjun aŋgyak. Gor Kawnan ak, kuyip kond mindakniŋ, mindrep giy, biynimb kuŋaynep Jiysis nup diyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyta biynimb Jiysis nup gosimb niŋyak gok, miñmon keykey niŋraŋgyiŋgip. Kun giy niŋraŋgiy, minek bap biynimb Jiysis nup gosimb niŋyak gok kuyip, niŋiyn aŋgiy miñmon Liyda amnak. ");
INSERT INTO kmh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Miñmon kun ak, bi ñin tomb kalaw gek, minj ar nep kin mindek simiy yin jiy ayak bap mindek. Yimb nuk Yiniyas. ");
INSERT INTO kmh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyta bi kun anup aŋgak, “Yiniyas. Tap nip gip ak, Jiysis gek suŋ ayniŋgamb. Jakiy, minj ak par tep gan aŋgak.” Kun aŋgakniŋ, nup suŋ ayek, ");
INSERT INTO kmh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","giraŋgakniŋ, Liyda biynimb gok sek, Saron biynimb gok sek nup niŋyak rek, Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pen Piyta miñmon Liyda nep mindakniŋ, biyn Jiysis nup gosimb niŋak bap kumak, yep miñmon yomb Jopa. Biyn kun ak yimb nuk Tabiyta. Pen Griyk minim aŋgiy, nup Dokas aŋgyak. Nuk biynimb okok kuyip kond mindrep giy, biynimb simbgeprek gok kuyip woŋg giñiyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Biyn kun ak kumek, nup ñiŋg pikñiy dam ayak korip miŋgan ar akyoŋ. ");
INSERT INTO kmh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Biynimb Jiysis nup gosimb niŋyak gok, minim bap niŋyak; Piyta ap mindek miñmon Liyda. Kiyk niŋiy, bi omiŋal yokey, amiy aŋgrik, “Nand chir yip kasek apey amnun aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aŋgerik, Piyta tikjakiy, kiymiŋay yip Jopa amiy, nup poŋind Tabiyta kumek, dam ayak korip ar biyoŋ amniyak. Pen biyn kaŋil ap mindeyak gok, biyn kumak kun ak, nind kim mindyiŋg chech tap kuyip yikop ñiyiŋgip gok, Piyta nup yomyiŋg, siy aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nuk pen biynimb ap mindeyak gok kuyip, aŋg mis biyaŋ yokiy, koŋgim yimiy, Gor nup aŋgniŋiy, tuŋgandikiy Tabiyta nup niŋyiŋg aŋgak, “Tabiyta. Tikjakan!” Aŋgek, Tabiyta Piyta nup niŋiy, tikjakiy bisgak. ");
INSERT INTO kmh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyta ñin kind nup ak diy, di jakñiy, am biyn palpal gok sek, biynimb Jiysis nup gosimb niŋyak gok sek kuyip, aŋgek apey, “Tabiyta biy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pen Piyta kun gek, minim kun ak Jopa biynimb maŋgiysek niŋiy, biynimb kuŋaynep, Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pen Piyta nuk miñmon Jopa kun ak, bi kaw wak woŋg giyiŋgip bap yip, ñin gunap tapin mindyiŋgipiyr. Bi kun ak yimb nuk Saymon. ");
INSERT INTO kmh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","2","Pen bi amiybi gok kuyip kond mindyiŋgip biyomb bap, miñmon Siysariya mindyiŋgip. Yimb nuk ak Konliyas. Amiybi nuk kond mindyiŋgip gok kuyip “Yitaliy amiybi,” aŋgyiŋgipay. Biyomb Konliyas kun ak, biynimb korip nup ap mindyiŋgipay gok yip, Gor nup lotiw giyiŋgipay. Nuk Jiwda biynimb tap gunap ma mindek; maniy tap gok monmon ñiyiŋgip. Pen nuk Gor nup minek minek aŋgniŋyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Minek bap pumb kuyim gak won ak, day niŋak: Gor enjol bap yokek apiy aŋgak, “Konliyas!” ");
INSERT INTO kmh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Aŋgek, pirikiy aŋgak, “Biyomb. Yip yenen aŋgak.” Aŋgek, enjol ak nup aŋgak, “Nand Gor nup aŋgniŋying, biynimb simbgeprek gok kuyip tap monmon ñiyiŋg gipan ak; nip sakiy ma gip. ");
INSERT INTO kmh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nand bi gunap aŋgey, am miñmon Jopa amiy, bi Saymon Piyta apay ak nup, am aŋgey winimuŋ. ");
INSERT INTO kmh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nuk Saymon, bi kaw wak woŋg gip ak yip mindpiyr, ñiŋg solwara gol ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pen enjol ak minim kun ak aŋgiy amnakniŋ, Konliyas bi nup woŋg giñirik omiŋal ak sek, amiybi Gor nup gosimb niŋak bap sek aŋgek apeyak, ");
INSERT INTO kmh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kuyip enjol ak minim yerip yerip aŋgak ak aŋgñi tep giy, aŋgyokek, Jopa amniŋg saŋdiyak. ");
INSERT INTO kmh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Am am kinjeŋnamb ak kinyak. Minek am am, pumbnamb yomb yoŋ won ak, miñmon Jopa maŋ maŋ giyak. Won kun ak Piyta, Gor nup aŋgniŋniŋg amnak, korip miŋgan ar biyoŋ. ");
INSERT INTO kmh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Amiy, Gor nup aŋgniŋ mindakniŋ, nup yiwan yomb yimb ak gak. Pen biynimb nuk gok, tap daŋgiy giyakniŋ, nuk day niŋiy niŋak: semb biyoŋ miŋgan yikiy, wand yomb bap kun biyoŋ nimb lum biyaŋ owak. ");
INSERT INTO kmh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wand miŋgan kun ak kanj, kimin, yakir, siyŋ, saraw, Jiwda biynimb ma ñimbay tap gok keykey kuŋaynep mindek. ");
INSERT INTO kmh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Minim bap pen aŋgak, “Piyta. Tikjakiy tap ñiŋemb kun kayaŋ gok pik daŋgiy ñiŋan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aŋgek, pen aŋgak, “Biyomb. Mer! Yenen ñiŋan aŋgiy apan? Chin Jiwda biynimb tap asik kun gok ma ñimbun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aŋgek, minim kun ak tip aŋgak, “Tap yerip yerip yand gen suŋ mindip gok, asikep aŋgiy ma aŋgnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Day niŋak kun ak, tip ak niŋiy, tip ak niŋiy gak. Kisen mey, tap wand yomb kun ak, andkind semb biyoŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Kun gek, Piyta “Day niŋbiyn kun ak yerginiŋgamb aŋgiy,” gos kuŋay niŋmindakniŋ, bi Konliyas yokek nup aŋgniŋg wiyak bi kaw ak, kinjeŋrumb ak amjakiy aŋgyak, “Bi Saymon, yimb nuk bap Piyta apay ak, biy mindip akaŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Pen Gor Kawnan ak Piyta nup aŋgak, “Bi omiŋal nokom, yand key aŋgen, nip piyowsipay ak; kuyip gos kuŋay ma niŋiy; biyaŋ amiy, kiy yip minim aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Aŋgek, biyaŋ amiy, kuyip niŋiy aŋgak, “Bi piyowniŋsipim ak mey, yand nep. Yip minim bap aŋgniŋg opim?” ");
INSERT INTO kmh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Aŋgek aŋgyak, “Biyomb Konliyas, amiybi gok kuyip kond mindip ak, chinup aŋgyokek opun. Nuk Gor nup gosimb niŋek, Jiwda kay nup niŋey tep gip. Nuk day niŋak: enjol bap apiy nup aŋgak, ‘Nand bi gunap yokey, am Saymon Piyta nup poŋind apey, minim aŋgnimuŋ ak niŋnimimb aŋgak.’ Enjol ak kun aŋgek mey, Konliyas niŋiy, chinup aŋgyokek aswun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","24","Kun aŋgey, Piyta kuyip aŋgek korip miŋgan amiy kinyak. Minek Piyta, bi Jopa nimb Jiysis nup gosimb niŋyak gunap diy, Konliyas yokak biriwin ak yip am am kinjeŋnamb ak kinyak. Minek mey, Siysariya amjakiy, Konliyas korip ak amniyak. Pen Konliyas nuk Piyta asaw aŋgiy, biynimb nuk gok sek, numiy numam nuk gok sek kuyip suk aŋgek ap nan-giy mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piyta amiy, korip miŋgan amniŋg gakniŋ, Konliyas nup tep gek, am tomb kiñiŋ siŋak koŋgim yimak. ");
INSERT INTO kmh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kun gek, Piyta nup di jakñiy aŋgak, “Yand Gor mer; yand bi yikop nen, Jakan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Aŋgek jakakniŋ, minim aŋgyiŋg korip miŋgan biyaŋ amnirik. Amiy, Piyta niŋak: biynimb kuŋaynep ap nan-giy mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Niŋiy, kuyip aŋgak, “Nimb key niŋbim: chin Jiwda biynimb gok asik tep gipun. Korip miñmon gunap ma ambun sek; Jiwda mer gok yip yiŋgoŋg giy ma tapun. Pen yand day niŋnik; Gor yip minim bap aŋgak ak mey, biynimb gunap asiŋ mindpay aŋgiy, kuyip asiknim rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kun ak niŋiy mey, Konliyas minim aŋgip ak niŋiy ma kirpiyn; aŋgip rek niŋiy opiyn. Kun ak yip yerginiŋg aŋgem opiyn?” ");
INSERT INTO kmh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Piyta kun aŋgek, Konliyas aŋgak, “Yand menikarik namb siŋbiy pumb kuyim gip won biy rek, korip miŋgan biyaŋ Gor nup aŋgniŋ mindyiŋg niŋnik: bi chech tund yimb yimak bap, ap mindenik siŋak miseŋ giy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Konliyas. Nand Gor nup aŋgniŋying, maniy tap gok biynimb yimgeprek gok kuyip monmon ñimban ak, Gor niŋimb. ");
INSERT INTO kmh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kun ak mey, bi gunap aŋgyokey, miñmon Jopa amiy, bi Saymon yimb nup bap Piyta apay ak, poŋind winiŋgiy. Nuk Saymon, bi kaw wak woŋg gip ak yip mindpiyr solwara gol ak aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Enjol ak yip kun aŋgek, yand kasek bi yand gunap aŋgenik, nip am poŋind apey mey, yip tep gip. Biy Gor yip mindpun rek, minim kuyip aŋgnimin aŋgiy nip aŋgip ak, chinup aŋgey niŋun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Konliyas kun aŋgek, Piyta aŋgak: “Yand miñiy niŋbiyn. Gor chinup Jiwda nep diyn aŋgiy gos ak ma niŋimb; biynimb miñmon okok maŋgiysek diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Miñmon okok maŋgiysek, biynimb an siskoy diy, minim nup diniŋgambay gok kuyip diniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pen Gor chinup Yisrel biynimb diniŋg, minim tep aŋgak ak niŋbim. Nund yip jimñiy mindeyaŋ aŋgiy, biyomb chin kond mindyiŋgipun Jiysis Krays nup yokek owak. Nuk nep mey, biynimb okok maŋgiysek Biyomb chin yipund giy yimb mindip. ");
INSERT INTO kmh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nimb key niŋbim! Wosrey, Jon bi ñiŋg pikñemb ak ñiŋg pikñiyiŋg, minim tep kun ak kiñiŋ giy aŋgak miñmon Galiyliy. Kun giy aŋgek, aŋg dand amiy, aŋg dand amiy, biynimb Jiwdiya mindpay gok maŋgiysek niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pen niŋbim! Bi Jiysis miñmon Nasaret nimb apun ak; Gor yip mindiy Kawnan nuk ak nup yokek kond mindakniŋ, miñmon okok taŋgiy, biynimb yikop gok direp giyiŋg, biynimb Seytan gek kosyam mindeyak gok kuyip gek, suŋ ayak. ");
INSERT INTO kmh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","40","“Pen Jiysis, Jiwda miñmon okok giraŋgiy, miñmon yomb Jerusalem giraŋgiy gak gak rek, chin key niŋnuk rek aspiyn. Nup mon kiros bak biyoŋ ñaŋgbirikayey kumak ak pen, ñin omiŋal nokom mindiy, Gor gek tip tikjakiy, ap miseŋ gek niŋnuk. ");
INSERT INTO kmh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Biynimb maŋgiysek nup ma niŋyak; Gor chinup biynimb nuk niŋayak gok nep, Ñinuk nup yomek miseŋ niŋnuk. Chin mey nuk kumiy tikjakek, yip jimñiy tap ñiŋnuk. ");
INSERT INTO kmh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Chinup aŋgak, ‘Minim tep yand ak biynimb okok kuyip aŋgñirep giyiŋg aŋgnimimb. Kisen Gor aŋgek, Ñinuk Jiysis, biynimb kumyak gok sek, biynimb kim mindeniŋgambay gok sek kor niŋniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pen ar kun ak, bi Gor minim aŋgep gok maŋgiysek aŋgyak, “Krays nuk apiy giniŋgamb rek Nop biynimb nup gosimb niŋniŋgambay gok kuyip tap siy tap timey gipay ak wiykyokniŋgamb’ aŋgyak.” ” ");
INSERT INTO kmh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pen Piyta kun giy minim aŋg mindakniŋ, Gor Kawnan ak kuyip bak ayek, ");
INSERT INTO kmh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Gor yimb nup dand aranyiŋg, minim yimb keykey aŋgyak. Kun geyak, bi Jiwda Jiysis nup gosimb niŋiy, Piyta yip wiyak gok niŋiy aŋgyak, “Gor Kawnan nuk ak, biynimb Jiwda mer guniy kuyip monmon yokek ap bak ayek, minim keykey yimb aspay aŋgyak.” Piyta pen aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gor Kawnan chinup yokak rek ak, miñiy biynimb guniy kuyip kunep yokip. Kun ak ñiŋg pikniŋg aŋgey, biynimb gunap kuyip mer aŋgniŋgiy rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kun aŋgiy, binuk gunap aŋgek, Jiysis ker mindpay aŋgiy, kuyip ñiŋg pikñeyak aŋgyak, “Piyta! Ñin kaw bap chin yip mindenimin aŋgyak.” Aŋgeyak, ñin kaw bap, kiy yip mindek miñmon kun ak. ");
INSERT INTO kmh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","3","Pen Piyta biynimb Jiwda mer gok kuyip, Gor minim ak aŋgñek diyak kun ak, bi Jiysis minim dand amemb gok sek, biynimb Jiysis ker mindeyak gok sek niŋyak. Kun ak kisen Piyta Jerusalem amek, Jiwda bi kumbak tikniŋgiy aŋgyiŋgipay gok, nup kuŋay aŋgiy aŋgyak, “Nand yenen amiy, biynimb kumbak ma tikpay gok yip tap jimñiy ñimban?” ");
INSERT INTO kmh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kun aŋgeyak, Piyta Jopa mindiy, day niŋak kesim ak kuyip aŋgñiyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yand miñmon yomb Jopa mindiy, Gor nup aŋgniŋ mindiy, day niŋnik: wand yomb yimb ak semb biyoŋ nimb yip ker owak. ");
INSERT INTO kmh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Apek, yand wand kun ak mindek maŋ siŋak amiy niŋnik: siyŋ saraw, yakir kimin, kanj kayn, tap chin Jiwda kay ma ñimbun gok, maŋgiysek mindek. ");
INSERT INTO kmh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Minim bap pen semb ar biyoŋ nimb apiy, yip aŋgak, ‘Piyta! Nand tap kun gok pik ñiŋan aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Aŋgek, pen aŋgnik, ‘Biyomb. Mer! Yand tap kun gok asik tep giy, ma ñimbiyn aŋgnik.’ ");
INSERT INTO kmh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Aŋgen, minim kun ak tip aŋgak, ‘Gor tap yerip yerip gek suŋ ayip gok, tap asikep aŋgiy ma aŋgnimin aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Day niŋnik ar kun anep, tip ak niŋiy, tip ak niŋiy ginik. Pen kisen tap wand yomb kun ak, tip ak semb biyoŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Won kun ak, bi omiŋal nokom korip chin mindonuk ak apchakyak. Bi kun gok biyomb Konliyas, miñmon Siysariya nimb ak aŋgyokek, yip poŋdiniŋg wiyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Gor Kawnan ak yip aŋgak, ‘Gos kuŋay ma niŋnimin, kiy yip monmon amnimin aŋgak.’ Kun aŋgek, yand mam Jiysis minim niŋbay kaw biy kuyip diy, kiy yip Konliyas korip ak amninuk. ");
INSERT INTO kmh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Amjakon, Konliyas aŋgak, ‘Enjol bap apiy yip aŋgak, “Bi gunap aŋgenimin, miñmon Jopa amiy, bi Saymon Piyta apay ak nup poŋind apey, nip Jiysis minim tep ak aŋgñiniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Gor nuk biynimb korip nand yip mindpim gok maŋgiysek dek, biynimb nuk mindeniŋgambim aŋgak.” Enjol ak kun aŋgek mey, nip suk aŋgen opan aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Konliyas yip kun aŋgek, yand kiñiŋ giy minim aŋgnikniŋ, Gor Kawnan nuk ak chinup nind yokak rek, biynimb kun gok kuyip kunep yokek, ");
INSERT INTO kmh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jiysis chinup aŋgak minim ak gos niŋnik. Nuk aŋgak, ‘Jon nimbip yikop ñiŋg band anep ñiŋg pikñak; pen maŋ mindip, Gor nimbip Kawnan nuk yipund giy ak yokniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pen chin Biyomb Jiysis Krays nup gosimb niŋnuk ñin ak, Gor Kawnan nuk ak chinup yikop yokak rek, kuyip kunep yokak. Kun ak yergiy, Gor nup kirgan apnip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Piyta kun aŋgek, bi nup kuŋay aŋgyak gok niŋiy aŋgyak, “Gos nand key niŋiy, biynimb Jiwda mer gok kuyip ker ma amninak. Gor kuyip diniŋg, nip aŋgek amninak ak, minim ma mindip aŋgyak.” Kun aŋgiy, Gor nup tep aŋgyiŋg aŋgyak, “Chinup nep mer; biynimb Jiwda mer gok kunep: yenen tap siy tap timey gipun aŋgiy, nup aŋgniŋeniŋgambay, kuyip gek perper mindeniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pen Stiypin nup pikayak ñin ak; Jerusalem biynimb Jiysis nup gosimb niŋyak gok, pirik keykey amniyak. Gunap pirik Saypras amniyak; gunap Piniysiya amniyak, gunap Antiyok amniyak. Amiy, Jiysis minim tep ak biynimb Jiwda mer gok kuyip ma aŋgñiyak; Jiwda biynimb jiw am kun okok mindyiŋgipay gok kuyip nep aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pen biynimb Gor nup gosimb niŋyak gok gunap Saypras nimb, gunap Sayriyniy nimb pirik miñmon Antiyok amiy; Jiysis minim tep ak, Jiwda biynimb sek, Jiwda mer gok sek kuyip aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jiysis kiy yip mindakniŋ, minim aŋgñeyak mey, biynimb kuŋaynep, nind niŋyiŋgipay ar ak kirgiy, Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pen Jerusalem biynimb Jiysis nup gosimb niŋyak gok, minim kun ak niŋiy, bi kiyk Banabas nup aŋgey Antiyok amnak. ");
INSERT INTO kmh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Nuk bi tep, Gor Kawnan nup bak ayek, Gor aŋgip rek nep giniŋgamb aŋgiy niŋyiŋgip ak mey, Antiyok amjakiy niŋak: Gor biynimb Jiwda mer kun gok yip nep mindek niŋiy, nup tep gakniŋ, kuyip minim gunap sek aŋgñirep giyiŋg aŋgak, “Gor nup dipim ak, ma kirginimimb; nup chiŋgiy nep mindenimimb aŋgak.” Kun giy aŋgñakniŋ, biynimb kuŋaynep, Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Banabas pen, Sol nup am dand wiyn aŋgiy, miñmon Tasas amiy piyow niŋiy, poŋind andkind apiy, simiy nokom kun ak, biynimb Jiysis nup gosimb niŋyak gok kuyip, Gor minim tep ak aŋgñiyiŋg minderik. Antiyok biynimb yikop gok, biynimb Jiysis Krays nup gosimb niŋyak gok kuyip niŋiy aŋgyak, “Krays biynimb nuk” aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ñin kun ak, bi Gor minim aŋgep Jerusalem nimb gunap, Antiyok wiyak. ");
INSERT INTO kmh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Apey, Gor Kawnan ak bi kiyk Aŋgabas nup gos ñek aŋgak, “Yiwan yomb yimb ak, miñmon biy maŋgiysek giniŋg gisap aŋgak.” Aŋgek, aŋgak rek yiwan yomb sikerek ak, gapman biyomb Kilodiyas kond mindyiŋgip ñin ak owak. ");
INSERT INTO kmh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kun giy yiwan yomb gakniŋ, Antiyok biynimb Jiysis nup gosimb niŋyak gok, aŋgyak, “Mam ay chin Jiwdiya mindpay gok, yiwan mindpay rek, chin nokom nokom kuyip maniy gunap ñinjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kun aŋgiy, maniy ay nan-giy, Banabas yip Sol yip kuyip ñiy aŋgyak, “Dand amiy, biyomb Gor minim aŋgñimbay gok kuyip ñer; kiy pen, biynimb gok kuyip bilok ñiniŋgiy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","2","Ñin namb kun ak, gapman biyomb Herot, Krays ker mindeyak biynimb gunap kuyip timey giyiŋg, dam kalambis ayiŋg gak. Amiybi nuk gok kuyip aŋgek, Jon numam Jemis nup, baynat diy pisnep piŋiy ayey kumak. ");
INSERT INTO kmh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot aŋgek kun geyak, Jiwda biynimb gok tep aŋgiy niŋyak. Pen kun giy niŋyak rek, Herot Piyta nup kunep aŋgek, di kalambis ayak. Giyak kun ak, Jiwda biynimb biret yiys sek ma ñimbay ñin namb siŋak giyak. ");
INSERT INTO kmh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herot Piyta nup kun giy dam kalambis ay, amiybi onep jiy piskind ak kuyip bilok tiŋgawip tiŋgawip ay, pumbnamb kisyimken kond nep mindenimimb aŋgak. Herot gos nuk niŋak ak; pasopa ñin ak apiy pandikek ker, kisen nup dand biynimb mindeniŋgambay namb ak amiy, kor giniŋgambun aŋgiy niŋak. ");
INSERT INTO kmh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pen Piyta kun giy kalambis mindakniŋ, biynimb Jiysis nup gosimb niŋyak gok, nup nen aŋgiy, Gor nup aŋgniŋ mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pen gapman biyomb Herot nup kor ginim aŋgiy niŋak ñin ak; kisyimken biyaŋ nup sen omiŋal tiwniŋgiy, amiybi omiŋal bindoŋ bindoŋ niŋmindrikniŋ, Piyta namb biyaŋ kinek. Amiybi gunap mis akyaŋ mindiy, kinjeŋrumb ak niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pen Gor enjol bap aŋgyokek mon melik rek gakniŋ, kalambis korip miŋgan ak amnak. Amiy, Piyta nup pik niŋiy aŋgak, “Kasek tikjakan!” Aŋgek tikjakakniŋ, sen nup tiwniŋgiyak ak wisikak. ");
INSERT INTO kmh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Enjol ak nup aŋgak, “Simbnaŋg nand ak poŋgay, sendol ak ay gan aŋgak.” Aŋgek, aŋgak rek gek; enjol ak aŋgak, “Chech paryomb ak ayey amnur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Aŋgek, chech paryomb nuk ak ay, korip miŋgan mindek ak kirgiy, enjol ak yip saŋdirik. Enjol gak kun ak, Piyta nuk aŋgniŋak-eŋ, “Ak day niŋsipiyn aŋgiy niŋak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pen amiybi niŋmindeyak kinjeŋrumb omiŋal ak silgiy, kinjeŋ kilis timey mis biyaŋ ak key yikakniŋ, mis amnirik. Amiy, kinjeŋnamb okok amyiŋg, Piyta niŋak; enjol ak ma mindek. ");
INSERT INTO kmh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kun gek, niŋiy aŋgak, “Miñiy niŋrep gispiyn. Ak Bapiy yomb nep, enjol nuk ak aŋgyokek, ap gapman biyomb Herot yip miñ kilis ayip ak wisikip. Gapman biyomb Herot sek, Jiwda biynimb gok sek tap yip giniŋg gipay ak, giniŋgiy rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kun aŋgiy, gos kun ak niŋrep giy, binak Jon Mak nonim Mariya korip ak amnak. Korip kun ak biynimb kuŋaynep apiy, Gor nup aŋgniŋ mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyta apiy, kinjeŋ ak pik giygiw gek, pañ Ronda, korip kun ak woŋg giyiŋgip ak, kinjeŋ ak yikniŋg owak. ");
INSERT INTO kmh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Apiy niŋak, Piyta meŋg miŋgan anep aŋgek niŋiy, miñmiñ yimb giyiŋg kinjeŋ ak sakiy giy ma yikak; am biynimb gok kuyip aŋgak, “Piyta ap mindip mis bikyaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Aŋgek aŋgyak, “Nip sakiy ayamb aspan aŋgyak.” Kun aŋgeyak, kilis yimb giy aŋgak, “Yesek ma apiyn. Niŋind yimb apiyn. Piyta mindip mis bikyaŋ aŋgak.” Aŋgek, “Ak kawnan nuk ak rek ayip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pen kinjeŋ ak tip pik giygiw gek, am kinjeŋ ak yikiy niŋyak; Piyta nep ap mindek niŋiy, wal yimb aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wal aŋgyakniŋ, kuyip ñin tuŋg milich giy aŋgak, “Ma yimb aŋgnimimb aŋgak.” Kun aŋgiy, kalambis korip mindek, Gor enjol bap yokek apiy, nup yerer giy dand owak minim ak, kuyip aŋgñiy aŋgak, “Nimb Jemis nup aŋgñiy, bi Jiysis ker mindpay gunap kuyip aŋgñiy ginimimb; yand wikan bap key amjipiyn aŋgiy,” amnak. ");
INSERT INTO kmh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Minek miñmon tikakniŋ, amiybi gok Piyta ma mindek niŋiy, yergip aŋgiy aŋg apran apyan gi mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gapman biyomb Herot, kun ak niŋiy, nup kasek piyow niŋiy dand wim aŋgek, piyow mer niŋeyak; kuyip kor giy aŋgek, amiybi kun gok kuyip pisnep yimb pik ayak. Kisen gapman biyomb Herot Jiwda kirgiy, am Siysariya mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mindiy, Taya biynimb gok sek, Saydon biynimb gok sek niŋek, nup miluk yowak. Pen Taya-Saydon biynimb ap bi Herot korip nup kond mindep, Blastas nup siy aŋgiy aŋgyak, “Chinup per yiwan gek, ap Herot miñmon nuk biy, keñmaŋgiy taw dand ambun sek. Kun ak chinup miluk ma niŋnimuŋ; kapkap jimñiy mindenjun aŋgyak.” Aŋgeyak, bi Blastas kun ak aŋgak, “Ak niŋind apim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","22","Herot minim kun ak niŋiy, ñin bap minim aŋgniŋgayn aŋgiy aŋgayak. Ñin kun ak apek; bi kiyŋ kay aypay chech tep tep yimb gok ay siya kiyŋ yomb nuk ar ak bisgiy, biynimb gok kuyip minim aŋgñek aŋgyak, “Ak bi rek ma asap, gor rek bap asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pen Gor nup kirgiy, yimb nuk ak key dand aranak rek, Gor enjol bap yokek, ap nup gek tap yomb giy, kisow ayek kumak. ");
INSERT INTO kmh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pen Gor minim ak aŋgñey amnakniŋ, miñmon okok kind kind amnak. ");
INSERT INTO kmh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas yip Sol yip Jerusalem mindiy, giniŋg orik ak gindipur aŋgiy, Jon Mak nup poŋind andkind Antiyok amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Miñmon Antiyok kun ak, bi Gor minim aŋgep gunap, bi Gor minim aŋgñiyiŋgipay tiysa gunap mindeyak. Bi kun gok mey, bap Banabas; bap Sol; bap Simiyon. Bi Simiyon kun anup bi mosimb aŋgyiŋgipay. Bap mey, Liwsiyas. Nuk miñmon Sayriyniy nimb. Bap Maneyen, nuk mey biyomb Herot buŋgiy nuk ak. ");
INSERT INTO kmh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pen bi Gor minim aŋgñemb kun gok, tap ma ñimbiy, Gor nup nep aŋgniŋ mindyakniŋ, Gor Kawnan ak kuyip aŋgak, “Nimb Banabas yip, Sol yip kuyip aŋgenimimb, woŋg kuyip aŋgnik ak ger amnimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kun aŋgek, tap ma ñimbiy, Gor nup nep aŋgniŋ mindiy, Banabas yip, Sol yip kuyip diniŋiy, bilesiym giyiŋg, Gor nirmiŋay yip mindeniŋgamb aŋgiy aŋgyokeyak; ");
INSERT INTO kmh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Gor Kawnan ak kuyip kond mindakniŋ, binak Jon Mak nup woŋg chinup siskoy gunap ginimuŋ aŋgiy poŋind, Seliwsiya biyaŋ amiy, siyip diy, miñmon ñiŋg timb kusgak Saypras amniyak. Amiy, miñmon yomb Seliwsiya amiy, Sol yip, Banabas yip Jiwda nan-gep korip gok amiy, biynimb gok kuyip Gor minim aŋgñirik. ");
INSERT INTO kmh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Pen biynimb miñmon kun okok, Gor minim aŋgñi dam dam; miñmon yomb Pepos amjakyak. Miñmon Pepos kun ak, gapman biyomb kiyk ak yimb nuk, Sesiyas Polas. Bi kun ak nuk bi gos kind yimb aŋgiy niŋyiŋgip. Nuk Banabas yip, Sol yip kuyip, yip Gor minim tep ak aŋger niŋiyn aŋgiy, aŋgek apiy, minim tep ak aŋgñirik. Aŋgñer niŋiy, buŋgiy nuk Jiwda nimb, kunj tap gok nep giyiŋg, ‘Yand bi Gor minim aŋgep aŋgyiŋgip ak aŋgak,’ “Bi omiŋal kun ak, minim aspiyr ak ma dinimin aŋgak.” Bi kun ak yimb nuk Bajiysis. Pen Griyk minim aŋgiy, Eliymas aŋgyak. Eliymas aŋgyak minim kiñiŋ ak; koyimb sek aŋgiy aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol nup yimb bap mey, Pol aŋgyiŋgipay. Gor Kawnan ak Pol nup gos tep ñakniŋ, Bajiysis nup niŋyinjsek aymindiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nip kichekiy tikak; timey nep gipan. Gor minim tep apay ak ma nep niŋban. Tap yerip yerip tep mindip ak kirgiy, biynimb gok kuyip tom nep gipan. Yerip ñin ak niŋniŋgamban? ");
INSERT INTO kmh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kun gipan ak Gor gek, ñin kaw bap windin koy giy nep mindeniŋgamban aŋgak.” Pol minim kun ak aŋgakniŋ, Eliymas niŋak; semb gach rek band bap, ap windin nup ak yiwgak. Kun gek, bi bap yip kinjeŋ yomaŋ aŋgiy, tuŋgrirkoy gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","gapman biyomb Sesiyas Polas niŋiy, wal yimb aŋgiy, Jiysis nup gosimb niŋak. ");
INSERT INTO kmh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pen Pol binuk gok yip siyip diy, Pepos kirgiy, miñmon Pega, Pampiyliya propens ak amniyak. Am mindiy, Jon Mak nuk, kuyipmiŋay kirgiy, andkind Jerusalem amnak. ");
INSERT INTO kmh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kiyk pen Pega kirgiy, miñmon Antiyok, Pisiydiya propens ak amnirik. Am mindiy, Jiwda lotiw ñin ak apek, Jiwda nan-gep korip ak amiy, bisiŋg mindrikniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","bi lotiw kond mindyiŋgipay gok tikjakiy, Mosis minim tikak gunap, bi Gor minim aŋgep tikyak gunap, riytiym giy, ap Pol yip, Banabas yip kuyip aŋgyak, “Mam omiŋal. Biynimb guniy niŋdiniŋgiy rek minim ar gunap mindonimuŋ; kuyip aŋgñinimiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aŋgeyak, Pol tikjakiy minim aŋgniŋg, ñin dand araniy aŋgak, “Nimb Jiwda biynimb gok sek, Jiwda biynimb mer gok sek Gor nup niŋem tep gip gok, minim aŋgniŋg gispiyn biy, timund pik niŋmindenimimb. ");
INSERT INTO kmh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","18","Chin Jiwda biynimb miñiy mindpun biy, wosrey apis basind chinup gok, Gor niŋek tep gek aŋgak, ‘Biynimb kun gok rek diniŋgayn aŋgak.’ Kun aŋgiy kuyip dak ak mey, kisen kiyk miñmon Yijip am mindeyak, kuyip kond mindrep gek; ñi pañ gay, kuŋay yimb mindeyak. Ñin kun ak, biyomb Perow kuyip ma amniŋgiy aŋgak ak pen, Gor tap mageprek gunap giy, kuyip dand miñmon nep namb Saynay owak. Kiyk keñmaŋgiy tap gok nen, yiruk marik aŋgyiŋgipay ak pen; kuyip kond mindrep gek, simiy yin ñin jiwiy, andikiy ar piskind ak amnak. ");
INSERT INTO kmh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pen kisen kuyip dap miñmon Keynan biy, miñmon onep ar ak wikan keykey ayniŋg, apis basind sikop kuyip kond mindek, biynimb nind mindeyak gok gunap pik ay, gunap yuk yokiy, ap tip kun ak diyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Kiyk Yijip mindey simiy yinak ak ñin paŋgiy, miñmon nep namb okok mindey simiy yinak ak ñin paŋgiy, biynimb yuk yokiy, miñmon kun ak diyak simiy yinak ak kunep ñin paŋgiy gey mey, simiy yin ñin jiwiy onep tiŋgawip piskind rek amnak. “Pen Gor kuyip dap miñmon kun okok ay, bi minim tuŋgasikep gunap aŋgayek, kuyip kond mindyiŋgipay. Kisen bi minim nup aŋgep Samwel mindek ñin ak, ");
INSERT INTO kmh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","kiyk aŋgyak, ‘Chin kiyŋ, biyomb miñmon chinup maŋgiysek kond mindeniŋgamb bap dinjun aŋgyak.’ Aŋgeyak, Gor binak Kiys ñinuk Sol nup aŋgayek, kiyŋ kiyk mindyiŋgip. Nup Benjamen kiñiŋ ak tik dand amiy tikyak. Nuk kuyip kond mindek, simiy yin ñin jiwiy, andikiy onep ar piskind ak amnak. ");
INSERT INTO kmh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pen kisen Gor Sol nup kirgiy, Jesiy ñinuk Depiyt nup dek, kiyŋ mindiy, kuyip kond mindyiŋgip. Kun giy kond mindakniŋ, Gor aŋgak, ‘Jesiy ñinuk Depiyt bi tep yimb; apiyn rek nep giniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kun aŋgiy kisen aŋgak, ‘Yand gen, Depiyt tikek tik dand amiy tikniŋgambay bi bap, Yisrel biynimb biyomb kiyk mindiy, kuyip di Gor yip jimñiy ayniŋgamb aŋgak.’ Aŋgek mey, Jiysis Krays nup tikeyak; aŋgak rek nep gak. ");
INSERT INTO kmh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Pen Jiysis Krays tikjak woŋg ma gak ñin ak, Jon bi ñiŋg pikñemb ak ap Yisrel biynimb kuyip aŋgak, ‘Gor nup yenen timey gipun aŋgiy, tap siy tap timey gipim ak kirgem, nimbip ñiŋg pikñiniŋgayn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon biynimb okok kuyip Gor minim aŋgñi dand amiy, kisen ñin bap aŋgak, ‘Nimb yip an aŋgiy gos niŋbim? Biyomb per kond mindpun ak mey, wip aŋgiy niŋbim? Yand biyomb yimb kun ak mer; Nuk kisen winiŋgamb. Yand bi tep mer; tomb tirup nup ak tuŋgasikyiŋg, tap nup gok marik ginim rek ma ayip aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Pen nimb Ebraham kiñiŋ ak sek, biynimb okok nimb Gor nup aŋgniŋbim gok sek Jiysis chinup aŋgiy kumak minim ak, minim chin yimb. ");
INSERT INTO kmh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","“Jerusalem biynimb gok sek, biyomb kiyk gok sek minek minek Jiwda nan-gep korip ak amiy, Krays kisen winiŋgamb aŋgiy tikyak minim ak, niŋrep giyak ak pen; Jiysis apek, biyomb chin per kond mindpun ak, mey wip biy aŋgiy nup ma kirgiyak; nind bi Gor minim aŋgep gok nup pisnep pik ayniŋgambay aŋgyak rek nep giyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","“Nuk tap timey bap gip akaŋ aŋgiy, piyow mer niŋyak ak pen; gapman biyomb Paylat nup aŋgyak, ‘Nup ñaŋgbirik aynimin aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Aŋgey, nup dam mon kiros bak ak ñaŋgbirik ay, bi Gor minim aŋgep gok giniŋgamb aŋgiy aŋgyak rek nep giyak. Pen kun giy geyak, biynimb nuk gok ap nup tuŋgasik dam kamb miŋgan ak komey, ");
INSERT INTO kmh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Gor gek tip ak tikjakiy, ");
INSERT INTO kmh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","kim mindakniŋ, Galiyliy biynimb nuk yip Jerusalem wiyak gok, nup minek kuŋaynep niŋyak rek, Yisrel biynimb gok kuyip aŋgñey niŋsipay. ");
INSERT INTO kmh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Miñiy mindpun namb biy, Jiysis nup gek tip tikjakip minim tep ak, nimbip aspur. Pen minim kun ak kisenimb mer; Gor wosrey apis basind sikop kuyip aŋgek, kond mindyiŋgipay minim anep aspur. Baybol buk day sam namba tiw apay ak tikiy aŋgyak, ‘Ñiyand. Yand miñiy Nap nand mindpiyn aŋgip’ aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Gor aŋgak kun ak, Ñinuk kumek, tip gek tikjakak ak mey, kisen kumiy kuyiŋg yownimuŋ rek ma ayip. Gor Ñinuk Jiysis nup gek pisnep tikjakniŋgamb minim ak aŋgniŋg aŋgak: ‘Yand Depiyt nup; kuyip direp giniŋgayn aŋgiy minim aŋgaynik rek, nimbip giniŋgayn aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Ar kun ak nep mey, baybol buk ‘Sam’ apay ak, minim gunap tikiy aŋgyak: ‘Ñi suŋ-tep nand, nip woŋg giñimb ak, ma kuyiŋg yowniŋgamb; nand gey tip tikjakniŋgamb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Pen nimb gunap aŋgniŋgambim, Gor minim aŋgiy tikyak kun ak, Depiyt nup aŋgiy tikyak aŋgniŋgambim ak pen; Depiyt nup aŋgiy ma tikyak. Depiyt Gor nup gosimb niŋiy aŋgak rek, biynimb nup gok kuyip woŋg giñi dand amiy kumek, nop nusind sikop kuyip komyiŋgipay okok dam komeyak, kuyiŋg yowak. ");
INSERT INTO kmh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","38","Kun ak mam ay sikop niŋim! Depiyt nup ma aŋgyak, bi aŋgyak kun ak kumek, Gor gek tikjakak ak mey, ma kuyiŋg yowak. Bi kun ak Jiysis nup nep aŋgyak. Kun ak mey, Gor tap siy tap timey gipim ak niŋiy kirginiŋgamb aŋgiy, nimbip aspur. ");
INSERT INTO kmh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chin Jiwda low minim ar anep niŋiy goniŋgambun; Gor tap siy tap timey gipun ak niŋnep mindeniŋgamb. Pen Jiysis nup gosimb niŋoniŋgambun; tap siy tap timey ginuk ak, niŋiy kirgiy, ‘Biynimb suŋ-tep yand gok aŋgniŋgamb.’ ");
INSERT INTO kmh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pen nimb bi Gor minim aŋgep gok, wosrey aŋgyak rek ginimimb rek ayip ak, niŋrep ginimimb. Kiyk aŋgyak: ");
INSERT INTO kmh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Biynimb niŋiy sik nep apim gok niŋim! Nimb mindpim won biy, tap giniŋgayn ak nimbip nind aŋgñembiyap, “Yesek apay” apkip rek ayip. Kun ak gos kuŋay niŋyiŋg kumnimimb aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol yip, Banabas yip minim kun ak aŋgiy mis amnirikniŋ, biynimb gok aŋgyak, “Lotiw ñin kisen ak tip apiy, chinup minim kun ak gunap sek aŋgñinimiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jiwda nan-gep korip ak kirgiy, keykey amniyakniŋ, Jiwda biynimb yipund giy gunap, biynimb okok nimb, Jiwda biynimb niŋyak rek niŋyak gok gunap Pol yip, Banabas yip kuyip kindik giy amniyak. Kinjeŋnamb ak amyiŋg, kuyip aŋgrep giy aŋgrik, “Gor chinup simb niŋimb rek dip aŋgiy, gos ak niŋyiŋg nep mindenimimb aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jiwda lotiw ñin kisen ak, biynimb miñmon yomb kun ak mindeyak gok maŋgiysek rek, Gor minim niŋniŋg ap nan-giyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kun geyak, Jiwda biyomb gok Pol yip, Banabas yip kuyip niŋey, milukrimey yimb yapek, biynimb gok kuyip minim yerip yerip aŋgrik ak aŋgjiwiy, kuyipmiŋay aŋgjiwiy giyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kun giy aŋgjiweyak, Pol yip, Banabas yip kuyip aŋgrik, “Minim kun ak, nimbip Jiwda biynimb nind aŋgep rek ak apur ak pen; nimb key permindep ma diniŋgambun apim ak; miñiy Jiwda biynimb mer gok kuyip aŋgñiniŋgambur. ");
INSERT INTO kmh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kun ak, Gor wosrey aŋgek tikyak rek giniŋgamb. Nuk aŋgak: ‘Yand apiyn ak mey, nimb Jiwda biynimb gok, Jiwda mer gok kuyip melik kiyk ak mindiy, minim yip ak miñmon okok maŋgiysek aŋg ñem mey; biynimb minim yip niŋiy diniŋgambay gok kuyip, di yand yip jimñiniŋgayn aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jiwda mer gok minim kun ak niŋeyak, kuyip tep yimb gek, Gor minim nuk ak tep yimb aŋgyak. Kun ak biynimb Gor perper mindeniŋgiy aŋgiy niŋayak gok maŋgiysek, nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pen Jiysis minim ak, miñmon Antiyok okok maŋgiysek tapin nep amnakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Jiwda biynimb gok kuyip miluk yapek, am Antiyok biyomb, biynyomb Jiwda lotiw wiyak gok kuyip aŋgeyak, kiy am biynimb kuŋaynep dand apiy, Pol yip, Banabas yip kuyip timey giy, aŋgyokyak. ");
INSERT INTO kmh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Aŋgyokeyak, miñmon Antiyok kun ak kiriŋg amniŋg, biyn bi guniy minim ak dand apor ma niŋbay aŋgiy, tomb silkul gok pipal piker yapek, miñmon Aykoniyam amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pen Antiyok biynimb Jiysis nup gosimb niŋyak gok, Gor Kawnan ak yip mindiy, miñmiñ yimb giyiŋg mindyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Banabas yip, Pol yip am Aykoniyam mindiy, Jiwda nan-gep korip ak amiy, minim aŋgrep gerik, Jiwda biynimb diy, Jiwda biynimb mer gok diy, kuŋaynep Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pen Jiwda biynimb gunap aŋgyak, “Minim kiymiŋay apiyr ak ma diniŋgambun aŋgiy,” am Jiwda biynimb mer gok kuyip aŋgey, biynimb Jiysis nup gosimb niŋyak gok kuyip, miluk niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pen Banabas yip, Pol yip minim kun ak niŋiy, miñmon kun ak ma kiriŋg amnirik; mindyiŋg Gor minim tep ak aŋgñiyiŋgipiyr. Gor kuyipmiŋay kond mindakniŋ, tap mageprek gunap gerik, biynimb Jiwda mer gok niŋiy, minim aspiyr kun biy, niŋind yimb nep aspiyr aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pen Aykoniyam biynimb kun gok, asik keykey ay; pis bap Banabas yip, Pol yip minim aŋgrik rek niŋyak, pis bap, Jiwda biynimb aŋgyak rek niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pen, Jiwda biynimb gok, Jiwda biynimb mer gok, biyomb kiyk gok sek Banabas yip, Pol yip kuyip timey giy, kamb jiw pikayun aŋgiy gos ak niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Kiykmiŋay pen minim kun ak niŋiy, pirik miñmon Liystra Debiy, Likoniya propens ak amiy, kun okok giraŋgyiŋg, Gor minim tep ak aŋgñirik. ");
INSERT INTO kmh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","10","Pen miñmon Liystra kun ak, bi bap nonim nup tikak ñin anep tomb timey gak bap mindek. Bi kun ak nuk ap bisiŋg mindyiŋg, Pol minim aŋgakniŋ, niŋmindek. Pol bi kun ak nup niŋiy, bi kun biy Gor yip gek suŋ ayniŋgamb aŋgiy niŋmindip rek ayip aŋgiy, nup niŋyiŋg, meŋg miŋgan dand araniy aŋgak, “Jakan!” Aŋgek, tikjakiy amnak. ");
INSERT INTO kmh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pol kun gek, biynimb niŋmindeyak gok wal aŋgiy, minim yimb kiyk Likoniya minim ak aŋgiy aŋgyak, “Bi semb biyoŋ nimb gok, biyimb rek ay, ap aspiyr biy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kun aŋgiy, Pol nup aŋgyak, “Ak bi minim aŋgep Hemis, per aŋgniŋbun ak wip aŋgyak.” Banabas nup pen aŋgyak, “Ak bi Sus, lotiw korip giy per aŋgniŋbun ak wip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tap Sus aŋgiy aŋgniŋyiŋgipay kun ak, lotiw korip nup ak gayak dawin gol kun ak mey, bi lotiw yesek kond mindep kun ak, bi Sus per aŋgniŋbun ak miñiy wip biy aŋgiy, makaw aŋlam gunap diy, mon sum tep tep gunap diy dand apek, biynimb kuŋay yimb nep wiyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Pen Pol yip, Banabas yip giyak kun ak niŋiy, chirup Gor rek kun gispay aŋgiy, chech kiyk gok tuŋgralikiy, biynimb kuŋay mindeyak namb kun ak amiy aŋgrik, “Chirmiŋay gor mer! Biynimb yimb yipund giy. Pen Gor Biyomb yimb tap okok maŋgiysek gayak ak, minim tep nup ak dand aswur. Nuk semb biyoŋ gay, man ar biy gay, ñiŋg solwara ak gay gak. Chir minim tep nup ak aŋgor, tap yikop aŋgniŋbim gok kirgiy, Gor permindep ak nup, aŋg niŋmindenimimb aŋgiy nimbip aspur. ");
INSERT INTO kmh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pen wosrey tikiy, Gor biynimb miñmon keykey okok, yerer giyak ak, minim ma aŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pen nimbip kirgek, yikop yimb ma mindpim; Minek minek nimbip direp giyiŋg; gek miñmon pikiy, tap keñmaŋgiy kuŋay mindakniŋ, miñmiñ gipim. Kun ak biynimb akay akay nuk mindip aŋgiy niŋniŋg, miseŋ niŋniŋgambay aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kun aŋgrik ak pen, biynimb kun gok bi omiŋal biy semb biyoŋ nimb opiyr aŋgiy, kaw aŋlam gunap pik simboŋg ñiniŋg geyak, kosyam aŋg aŋg kuyip mer aŋgrik. ");
INSERT INTO kmh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pen kiymiŋay miñmon Liystra kun ak nep mindrikniŋ, Jiwda biynimb Antiyok Pisiydiya propens mindyiŋgipay gunap, Aykoniyam mindyiŋgipay gunap ap, biynimb kun gok kuyip yesek aŋgiy aŋgyak, “Minim tep ma aspiyr. Yesek aspiyr aŋgyak.” Kun aŋgeyak, biynimb kun gok niŋiy, Pol nup kamb jiw pikay, pisnep kumimb aŋgiy, lipiŋg dam kamb wariy giyak ak taw akyaŋ ken yokyak. ");
INSERT INTO kmh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yokeyak, biynimb Jiysis nup gosimb niŋyak gok, ap piŋiy kus kus geyak, Pol tikjakakniŋ, nup tip ak poŋind dawin yomb miŋgan biyaŋ amniyak. Minek, Banabas yip, Pol yip Liystra kirgiy, miñmon Debiy amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Amiy, Jiysis minim tep ak biynimb gok kuyip aŋgñerik, biynimb kuŋaynep Jiysis nup gosimb niŋyak. Pen kiykmiŋay nind opur ar anep amjur aŋgiy, andkind Liystra, Aykoniyam, Antiyok Pisiydiya propens ak amyiŋg; biynimb nind Jiysis minim aŋger niŋyak gok kuyip, tip ak aŋgñirep giyiŋg amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pen aŋgrep giyiŋg aŋgrik, “Jiysis minim ak ma kirginimimb; nup gosimb niŋbim rek nep niŋnimimb. Kun gem, nimbip miker ñiniŋgambay ak pen; kosyam mindpun aŋgiy gos ak ma niŋnimimb; Gor chinup diy kond mindeniŋgamb aŋgiy kilis giy gem amnimuŋ aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kun aŋgyiŋg, biyomb kuyip miñmon keykey kun gok kond mindeniŋgiy gunap aŋgay, kiymiŋay tap ma ñimbiy, Gor nup aŋgniŋyiŋg aŋgrik, “Biynimb guniy, nip gosimb niŋbay rek, kuyip kond mindenimin aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kun giy Pisiydiya propens okok taŋgiy, andkind ap Peka, Pampiyliya propens ak amiy; ");
INSERT INTO kmh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Gor minim ak biynimb kun gok kuyip aŋgñiy, miñmon Ataliya amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Amiy, siyip diy; Antiyok Siyriya propens nind mindiy wirik ak andkind amnirik. Kiyk nind amniŋg gerik, Antiyok biynimb Jiysis nup gosimb niŋyak gok, Gor nup aŋgniŋiy aŋgyak, “Minim tep nand ak biynimb okok kuyip aŋgñiniŋg amjipiyr rek, kuyipmiŋay kond mindrep ginimin aŋgiy, kuyip miŋay aŋgyokey, am Aŋgeyak, minim kun ak aŋgñi taŋgyiŋgipiyr. ");
INSERT INTO kmh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kun ak andkind Antiyok apiy, biynimb Jiysis nup gosimb niŋyak gok kuyip suk aŋger, apeyak aŋgrik, “Nimb chirup, Gor nup aŋgniŋ mindnimbikniŋ mey, Gor chirup kond mind tep gakniŋ, Jiysis minim tep ak aŋgñi taŋgor; biynimb Jiwda mer gok kuŋaynep Jiysis nup gosimb niŋbay aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kuyip kun giy aŋgñiy, kiy yip tapin mindyiŋgipiyr. ");
INSERT INTO kmh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pen Jiwda bi Jiysis nup gosimb niŋyak gunap, Jiwdiya nimb apiy, bi Jiwda mer Jiysis nup gosimb niŋyak gok kuyip aŋgyak, “Basind Mosis chinup Jiwda biynimb gok aŋgak, ‘Gor binuk mindniŋg, kumbak tiknimimb aŋgak.’ Kun ak nimb kun ma giniŋgambim ak, Gor binuk ma mindeniŋgambim aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pen Pol yip, Banabas yip minim ak yipund ma gip aŋgiy, kiy yip penpen yimb aŋg amniyak. Kun geyak, Antiyok biynimb Jiysis nup gosimb niŋyak gok aŋgyak, “Bi gunap yokon, Pol yip, Banabas yip Jerusalem amiy, bi Jiysis minim dand amemb gok sek, bi lotiw kond mindpay gok sek minim aŋg amiy apiy giy, ap aŋgey chin niŋjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kun aŋgiy, kuyip yokyakniŋ, am am Piniysiya propens namb ak amyiŋg, biynimb Jiysis nup gosimb niŋyak gok kuyip aŋgyak, “Miñmon okok biynimb Jiwda mer gok kunep, Jiysis nup gosimb niŋsipay aŋgyak.” Kun aŋgeyak, kuyip tep gak. Miñmon Piniysiya kun ak kirgiy, Samariya amiy, kuyip minim kun ak rek nep aŋgeyak, kiyk kunep niŋey tep gak. ");
INSERT INTO kmh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pen Samariya kirgiy, Jerusalem amjakeyak, bi Jiysis minim dand amemb gok sek, Jiysis biynimb nuk gok kuyip kond mindeyak bi gok sek, biynimb Jiysis nup gosimb niŋyak yikop gok sek kuyip niŋiy aŋgyak, “Mam sikop aswim aŋgyak.” Aŋgeyak, Banabas yip, Pol yip pen aŋgrik, “Gor chin yip taŋgiy mey, minim tep aŋgñon; biynimb miñmon okok kuŋaynep Jiysis nup gosimb niŋsipay aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kun aŋgerik, bi Peresiy Jiysis nup gosimb niŋyak gunap aŋgyak, “Biynimb Jiwda mer gok, Jiysis nup gosimb niŋsipay ak, kumbak tikiy Mosis aŋgak aŋgak rek giy, Gor biynimb nuk yipund giy mindeniŋgambay aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kun aŋgeyak, Jiysis biynimb nuk gok kuyip kond mindep bi gok sek, bi Jiysis minim dand amemb gok sek minim kun ak aŋgrep gun aŋgiy ap nan-giyak. ");
INSERT INTO kmh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ap nan-giy, minim aŋg dam namb pikyiŋg, Piyta tikjakiy aŋgak, “Mam sikop. Nimb niŋbim: Gor chinup woŋg keykey aŋgip rek, wosrey Jiwda mer gok aŋgem niŋniŋgiy aŋgiy, yip aŋgek, am kuyip minim tep nup ak aŋgñinik. ");
INSERT INTO kmh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","“Gor gos timund chinup maŋgiysek niŋimb ak, chinup Jiwda diy, Jiwda mer gok kuyip ma kirgip; Kawnan nuk chinup yokak rek, kuyip kunep yokak. ");
INSERT INTO kmh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Chinup minim bap key aŋgiy; kuyip minim bap key aŋgiy ma gip. Chinup maŋgiysek minim ar nokom aŋgak ak mey, nup gosimb niŋon; tap siy tap timey gipun ak niŋiy kirgip rek, kuyip kunep gip. ");
INSERT INTO kmh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Gor kuyip pisnep dip kun ak, nimb yenen, Gor chinup yerip ginimuŋ aŋgiy nembnemb giyiŋg apim, ‘Mosis minim sikoy aŋgak aŋgak rek ma giniŋgambay ak, kuyip ma diniŋgamb apim?’ Asik mosik girep giniŋgiy apim kun ak, apis basind sikop gi mer niŋyak. Chin kunep gi mer niŋbun ak pen, nimb tip ak aspim. ");
INSERT INTO kmh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Jiysis chinup simb niŋiy kumak rek, Gor chinup diy, biynimb okok kuyip diy gip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pen biynimb ap mindeyak gok, minim bap aŋgiy mer, kapkap mindeyak; Banabas yip, Pol yip aŋgrik, “Chir biynimb okok kuyip minim tep ak aŋgñi taŋgyiŋg, Gor tap mageprek gunap kun kun giy gak aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pen minim kiymiŋay ak aŋgjiwrikniŋ, Jemis tikjakiy aŋgak, “Mam sikop. Minim yand aŋgniŋg gispiyn biy niŋim! ");
INSERT INTO kmh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Gor biynimb Jiwda mer okok kuyip gunap nind dak minim ak, Piyta mindarik nimbip aŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Biynimb Jiwda mer gok kuyip dak kun ak, bi Gor minim aŋgep gok wosrey aŋgiy tikyak rek nep gak. Minim kun ak tikiy aŋgyak: ");
INSERT INTO kmh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","17","Biyomb ak aŋgip, ‘Wosrey Jiwda kay nusind kiyk Depiyt mindek ñin ak, kuŋaynep mindrep giyak ak pen; miñiy yip kirgiy, gos kiyk key niŋbay ar ak nep gipay. Kun ak, kisen yand biynimb miñmon okok maŋgiysek diniŋg gipiyn gok kuyip den, gos yip ak niŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tap yerip yerip kisen giniŋgamb ak niŋbiyn ak mey, kun aspiyn aŋgip’ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jemis minim kun ak aŋgiy aŋgak, “Biynimb Jiwda mer gok, Jiysis nup gosimb niŋsipay ak, kuyip tap asik mosik gep gok kuŋay mindip aŋgiy ma aŋgjun! ");
INSERT INTO kmh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kuyip yikop minj tikyokiy aŋgjun: ‘Biynimb gunap gor yesek gunap sinboŋgniŋg, kimin kanj tap okok pikeniŋgiy, ma ñiŋnimimb. Kimin kanj tap gok, likañ ak ma ñiŋnimimb. Kuŋam tuŋgwikey kumek, likañ sek mindeniŋgamb rek ma ñiŋnimimb. Kuŋam tikem, likañ amdek nep ñiŋnimimb. Pen biyn siy bi siy ma ginimimb aŋgjun aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Yenen, chin Jiwda asik mosik gipun minim Mosis tikak ak, wosrey aŋgeyak niŋbay. Miñiy kunep miñmon okok maŋgiysek, lotiw ñin ak ap Jiwda nan-gep korip ak nan-giy, minim Mosis aŋgiy tikak ak aŋgey niŋbay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jemis kun aŋgek, Jiysis biynimb nuk gok kuyip kond mindeyak bi gok diy, bi Jiysis minim dand amemb gok diy, biynimb yikop Jiysis nup gosimb niŋyak gok diy maŋgiysek aŋgyak, “Antiyok biynimb kuyip minj bap tikiy, biyomb Jiwdas yip, Salas yip ñon; Pol yip, Banabas yip amjipiyr rek, dand kawsek amniyaŋ aŋgyak.” Bi Jiwdas kun ak yimb bap “Basabas” aŋgyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pen kiyk kun aŋgiy, minj tik miñmon Antiyok Siyriya propens ak yokiy, miñmon Siyliysiya propens ak yokiy, aŋgyak, “Mam sikop nimb mindpim? “Chin numam nimbik Jiysis minim dand amemb gok sek, Jiysis biynimb nuk gok kuyip kond mindep gok sek nimbip biynimb Jiwda mer, Jiysis nup gosimb niŋbim gok minj tikyoksipun. ");
INSERT INTO kmh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Yenen: minim bap wip ak; biynimb guniy nimb gunap, chinup aŋgniŋiy mer, gos kiyk anep niŋiy, nimbip am minim yomb gospar ayep rek gunap aŋgeyak mey, ");
INSERT INTO kmh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","nimbip minj biy tiksipun. Bi chin omiŋal sek aŋgyokon; Pol yip, Banabas yip kawsek niniŋgambay. Yimb kiymiŋay ak, Jiwdas yip, Salas yip. Pen Pol yip, Banabas yip bi tep yimb omiŋal ak; chirup ñaŋg pikayniŋgambay aŋgiy gos ak ma niŋbiyr: Jiysis minim tep ak, monmon aŋgñirep giyiŋg tapiyr. ");
INSERT INTO kmh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bi kiymiŋay yip yokniŋgambun omiŋal kun ak, minj tikpun minim ar anep nimbip aŋgñiniŋgayr. ");
INSERT INTO kmh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gor Kawnan ak chinup gos tep ñek, minim kun biy tiksipun. Chin Jiwda gipun gipun rek ginimimb aŋgoniŋgambun; kosyam giniŋgambim ak mey, tap magep yep kaw bap nep aspun. ");
INSERT INTO kmh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nimb Jiysis nup gosimb niŋbim rek, biynimb gunap, kimin kanj tap yesek gunap simboŋgiy pikeniŋgiy; ma ñiŋnimimb. Kimin kanj tap gok likañ ak ma ñiŋnimimb. Kuŋam miñ wok gey kumek, likañ sek mindonimuŋ ak kunep ma ñiŋnimimb. Biyn siy bi siy ma ginimimb. Tap apun kun gok asikrep giniŋgambim ak, tep yimb. Minim kun ak aŋgdipun. Tep.” ");
INSERT INTO kmh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","31","Pen biynimb Jerusalem nimb Jiysis nup gosimb niŋyak gok, minim kun ak tikiy, Jiwdas yip, Salas yip kuyip ñey, Banabas yip, Pol yip miñmon Antiyok amniyak ñin ak, dand sesek amniyak. Dand amjakeyak, biynimb Jiysis nup gosimb niŋyak gok ap nan-giy, minj tikyokyak kun ak riytiym giy niŋey, kuyip tep yimb gak. ");
INSERT INTO kmh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","33","Jiwdas yip, Salas yip bi Gor minim aŋgep omiŋal ak mey, ñin kaw bap Antiyok mindiy, mind tep giyaŋ aŋgiy, minim tep gunap kuŋaynep aŋgñirik. Kun giy aŋgñindiy amnirikniŋ, mam ay kun gok aŋgyak, “Tep. Amniyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pen Salas gos nuk key niŋiy aŋgak, “Yand Antiyok biy mindenim aŋgiy,” Antiyok mindek; Jiwdas nep andkind Jerusalem amnak. ");
INSERT INTO kmh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol yip, Banabas yip Antiyok mindiy, bi kun okok nimb gunap yip, Jiysis minim tep ak aŋgiy, aŋgñirep giyiŋg mindyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pen mind dand amiy, Pol Banabas nup aŋgak, “Chirmiŋay nind taŋgiy Jiysis minim aŋgor amnak miñmon okok, Jiysis nup gosimb niŋyiŋg nep mindpay akaŋ aŋgiy, am niŋiy wur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Aŋgek, Banabas aŋgak, “Kun ak Jon Mak nup poŋind amjur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Aŋgek, Pol aŋgak, “Ñi kun ak nind poŋind amor, woŋg gi diy ma owak; nuk Pampiyliya nep amiy kiriŋg owak. Kun ak miñiy nup poŋind ma amniŋgambur aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pol kun aŋgek, kiykmiŋay keynep penpen aŋgiy, Banabas nuk Jon Mak yip siyip diy, miñmon Saypras amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol nuk pen, binak Salas nup dak. Biynimb Jiysis nup gosimb niŋyak gok, Pol yip, Salas yip kuyip, Gor niripmiŋay kond mindakniŋ, taŋgiy winimiyr aŋgiy aŋgyokeyak, ");
INSERT INTO kmh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","am Siyriya propens okok, Siyliysiya propens okok taŋgyiŋg, biynimb Jiysis nup gosimb niŋyak gok kuyip, minim gunap sek aŋgrep girik. ");
INSERT INTO kmh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","2","Kiymiŋay am am, miñmon Debiy amiy, miñmon Liystra amjakrik. Miñmon kun ak, bi Jiysis nup gosimb niŋak bap mindek. Yimb nuk Timotiy. Biynimb Jiysis nup gosimb niŋyak miñmon Liystra sek, Aykoniyam sek nuk bi tep yimb aŋgyak. Bi kun ak, nonim nuk Jiwda nimb Jiysis nup gosimb niŋak; nop nuk ak Griyk nimb. ");
INSERT INTO kmh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol pen, Timotiy nup niŋek tep gek, nund yip Jiysis minim ak aŋgñi taŋgor aŋgiy niŋak ak pen; Jiwda biynimb gok, nop Griyk nimb ak ñinuk kumbak ma tikip rek, minim nup ma niŋjun aŋgniŋgiy rek ayek niŋiy, Timotiy nup dand amek kumbak tikyak. ");
INSERT INTO kmh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tikiy kisen mey, Pol, Salas, Timotiy kiykyakam, dawin yomb okok taŋgyiŋg, biynimb Jiysis nup gosimb niŋyak gok kuyip aŋgyak, “Bi Jiysis minim dand amemb gok sek, Jerusalem Jiysis biynimb nuk gok kuyip kond mindpay bi gok sek apay, ‘Mosis Jiwda asik mosik minim aŋgak ak maŋgiysek mer; kaw bap nep dinimimb apay aŋgiy kuyip aŋgrep giyak.’” ");
INSERT INTO kmh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Aŋgrep geyak mey, biynimb Jiysis nup gosimb niŋyak gok, mindrep geyak, biynimb yikop gok kunep tep gek, minek minek gunap sek Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","7","Pol binuk gok yip Esiya taŋgey, Gor Kawnan ak aŋgak, “Miñmon biy minim tep ak kuyip ma aŋgñinimimb aŋgak.” Kun aŋgek, Priysiya propens namb okok taŋgiy, Galesiya propens namb okok taŋgiy, ap miñmon Miysiya maŋ maŋ giyiŋg, Biytiyniya propens amnun aŋgeyak, Jiysis Kawnan ak kuyip aŋgak, “Ma amnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kun aŋgek, miñmon Biytiyniya ma amniyak; Miysiya kirgiy, miñmon Trowas amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Amiy, kisyimnamb biyaŋ Pol day niŋak; bi Masedoniya propens nimb bap tikjakiy, nup suk aŋgyiŋg aŋgak, “Chinup simb niŋiy, ñiŋg tikiy, pis biy winimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol kun giy day niŋek, ak Gor nep, Masedoniya biynimb kuyip minim tep ak aŋgñinimimb aŋgip aŋgiy, am siyip diy, ");
INSERT INTO kmh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","am am, miñmon ñiŋg timb kusgak Samotres amjaknuk. Minek pen, miñmon ñiŋg timb kusgak Niyapoliys amjakiy, ");
INSERT INTO kmh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","siyip ak kirgiy, Masedoniya biynimb miñmon yomb kiyk Piyliypay amjaknuk. Miñmon Piyliypay kun ak, Rom gapman kuŋaynep ap mindiy kond mindyiŋgipay. Ñin kaw bap miñmon kun okok yikop mindiy, ");
INSERT INTO kmh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jiwda lotiw ñin ak apek, miñmon yomb biy ñiŋg gol akyim, Gor nup aŋgniŋbay tip bap mindip aŋgiy, miñmon yomb kun ak kirgiy, amiy niŋnuk: biyn gunap ap mindeyak. Niŋiy, kun siŋak bisgiy, kuyip minim aŋgñinuk. ");
INSERT INTO kmh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Biyn mindeyak kun gok, bap yimb nuk Liydiya. Nuk chech muk gok gayek tawyiŋgipay. Nuk Tayatayra nimb. Gor nup nep aŋgniŋyiŋgip. Biyn kun anup, Jiysis gos tep ñek, Pol minim aŋgak ak niŋind aŋgip aŋgiy dek, ");
INSERT INTO kmh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","nup ñiŋg pikñiy, biynimb nuk yip kinyak gok kuyip ñiŋg pikñiy ginuk. Biyn Liydiya kun ak aŋgak, “Nimb yip niŋem, Jiysis nup gosimb niŋbiyn rek ayip ak, ap korip yip biy mindenimimb aŋgak.” Chinup kun aŋgek, niŋind aŋgip aŋgiy, am korip nup ak kininuk. ");
INSERT INTO kmh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pen chin minek bap tip ak, Gor nup aŋgniŋniŋg amiy, pañ woŋg yikop giñemb bap nup namb piknuk. Pañ kun anup kichekiy abaŋ ayek mey, tap yerip yerip kisen giniŋgamb ak, biynimb gok kuyip aŋgñek, nup maniy tawyiŋgipay. Kun gek, bi nup taw dand apey, woŋg kuyip giñiyiŋgip gok, maniy yomb diyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chin amninukniŋ, pañ kun ak chinup kisen giyiŋg aŋgyiŋgip, “Bi guniy, Gor Biyomb ak nup woŋg giyiŋg, nimb yergem Gor nimbip diniŋgamb minim ak aŋgñiraspay aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pen minim kun ak rek, minek minek aŋgek, minek bap Pol nup yiruk gek, andikiy pañ kun anup kichekiy ambaŋ ayak anup aŋgak, “Jiysis Krays yip ginimin aŋgip rek, nip aspiyn, pañ anup kirgiy amnoŋ aŋgak.” Kun aŋgakniŋ, kichekiy nup ambaŋ ayak ak, mis amnak. ");
INSERT INTO kmh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pen pañ kun anup kond mindyiŋgipay bi gok, Pol kichekiy aŋgyokak minim ak niŋiy, maniy yomb dipun ak, kisen ma diniŋgambun aŋgiy, Pol yip, Salas yip kuyip kor giniŋg, lipiŋg dand, Rom biyomb mindeyak ak amiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","“Jiwda nimb bi omiŋal biy, ap miñmon chinup biy monmon gispiyr ak, yesek gispiyr. ");
INSERT INTO kmh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Chin Rom biynimb, minim nindik ar ak key mindip ak pen; kiyk yerginiŋg, minim kisenimb ak niŋyaŋ aŋgiy aŋgraspiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Biynimb mindeyak gok kunep, minim ar kun anep aŋgeyak, biyomb gok tikjakiy, chech kuyipmiŋay gok tuŋgasikiy aŋgyak, “Kur diy pikim aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aŋgeyak, kur diy pik andik mandik giy, dam kalambis miŋgan ak yokiy, bi kalambis kond mindek anup aŋgyak, “Kuyipmiŋay niŋmindenimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aŋgeyak, bi kalambis kond mindek ak, kuyipmiŋay poŋind dam korip miŋgan yimb biyaŋ ay, tomb kind kuyip omiŋal ak diy mon yomb miŋgan ak aŋgek liŋger amek, lokiym gak. ");
INSERT INTO kmh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pen kisyimnamb yomb biyaŋ, Pol yip, Salas yip Gor nup aŋgniŋyiŋg, lotiw kamep gunap aŋg mindrikniŋ, kalambis bi gok maŋgiysek niŋmindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kun giy niŋmindyakniŋ, day monmon yomb ak diy, kalambis korip ak dand doŋwiy giy, kinjeŋ gok yikiy, kalambis kay kuyip tiwniŋgiyak senwur gok, maŋgiysek asikak. ");
INSERT INTO kmh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kun gek, bi kalambis kay kuyip kond mindek ak tikjakiy niŋak; kinjeŋ gok maŋgiysek yikiy mindek. Nuk niŋiy, kalambis kay kinjeŋ yikiy pirik amdipay rek, biyomb ak yip ñaŋgniŋgamb aŋgiy, ñayip baynat ak lipiŋg diy, nuk key piŋiy ayin aŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pol pen, meŋg miŋgan dand araniy aŋgak, “Yenen nak key piŋiy ayniŋg gispan? Chin ma pirik ambun. Maŋgiysek mindpun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Aŋgek, bi kalambis kond mindek ak meŋg miŋgan dand araniy aŋgak, “Kalambis kay amdipay rek ayip! Sup ak kasek dowim aŋgak.” Aŋgek, sup dand apeyak, dand korip miŋgan amiy, jel gek, jep jep diyiŋg, am Pol yip, Salas yip minderik kiñiŋ siŋak koŋgim yimak. ");
INSERT INTO kmh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pen kun giy koŋgim yimiy tikjakiy, kuyipmiŋay poŋind mis biyaŋ amiy aŋgak, “Bomiŋal. Yand yergen, Gor yip diniŋgamb?” ");
INSERT INTO kmh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Aŋgek, nup aŋgrik, “Jiysis nup gosimb niŋeniŋgamban; Gor nip diniŋgamb; biynimb nand yip kinban gok kunep aŋgrik.” ");
INSERT INTO kmh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","33","Kun aŋgerik, kuyipmiŋay kisyimken biyaŋ nep dand amiy, pikyak gok ñiŋg ayokak. Pen Pol yip, Salas yip biynimb nuk yip kinyak gok sek kuyip, Gor minim ak aŋgñerik, nup gosimb niŋeyak, kuyip maŋgiysek ñiŋg pikñirik. ");
INSERT INTO kmh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ñiŋg pikñerik, bi kalambis kay kuyip kond mindek kun ak, kuyipmiŋay poŋind korip nuk ar biyoŋ amiy, tap keñmaŋgiy ñek ñiŋrik. Bi kun ak, biynuk ñapan nuk gok sek, “Miñiy Gor nup gosimb niŋbun aŋgiy,” tep gakniŋ mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Minek pen, Rom biyomb gok, poliys gok kuyip aŋgyak, “Bi kalambis mindpiyr omiŋal ak kuyip wisik yokem, amnimiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Aŋgeyak, bi kalambis kay kuyip kond mindyiŋgip ak, minim kun ak dand Pol yip, Salas yip minderik ak amiy aŋgak, “Biyomb gok nirip apay, ‘Wisik yokem amnimiyr apay.’ Kun ak gos sek amnimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aŋgek, Pol aŋgak, “Chirmiŋay kunep bi Rom nimb ak pen, kor niŋiy mer; biynimb namb ak chirupmiŋay kur diy pikiy, dam kalambis aypay ak tep ma gip. Kun ak chirup kapkap weygiy aŋgyokun aŋgiy aspay? Kiyk key apiy, chirup wisik yokniŋgambay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","39","Pol kun giy aŋgek, poliys gok minim kun ak niŋiy, andkind am biyomb gok kuyip minim kun ak aŋgñeyak, kiyk kunep Rom nimb aŋgiy pirikiy, am Pol yip, Salas yip kuyip minim sayn aŋgiy aŋgyak, “Nirmiŋay miñmon yomb kun biy kiriŋg amnimiyr aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Aŋgeyak, Pol yip, Salas yip kalambis korip ak kirgiy, biyn Liydiya korip ak am mindiy, biynimb Jiysis nup gosimb niŋyak gok kuyip minim aŋgrep giy, amnirik. ");
INSERT INTO kmh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kiymiŋay miñmon Piyliypay kirgiy, am am miñmon Ambiypoliys amjakrik. Ambiypoliys nimb am am, miñmon Apoloniya amjakrik. Pen Apoloniya nimb am am miñmon Tesalonayka amjakiy niŋrik; Jiwda nan-gep korip bap mindek. ");
INSERT INTO kmh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Niŋiy, Pol per giyiŋgip, Jiwda lotiw ñin omiŋal nokom, biynimb gok yip nan-gep korip miŋgan ak amiy, Gor minim nind aŋgiy tikyak ak, aŋg amiy apiy giyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kun giy aŋg amiy apiy giyiŋg, kuyip Jiysis minim tep ak aŋgñirep giyiŋg aŋgak, “Bi Krays winiŋgamb aŋgiy kond mindpim ak, nuk apiy, chinup nen aŋgiy, yiwur dak. Bi Kiyŋ yomb key yimb kond mindyiŋgipun ak mey, bi Jiysis nimbip kesim dispiyn ak nep. Baybol buk ak nup nind aŋgiy tikyak rek, kumiy tip ak tikjakak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kun aŋgek, gunap niŋind aŋgip aŋgiy, Pol yip, Salas yip kind ak amniyak. Griyk biynimb Gor nup aŋgniŋyiŋgipay gunap; biyn yimb sek gunap kunep, Pol yip, Salas yip aŋgrik minim ak diyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Deyak, Jiwda bi gok niŋey miluk yapek, bi timey yikop mindeyak gunap dey, kiyk pen am biynimb kuŋaynep dand apey, kilpul yomb aŋgyak. Pen Pol yip, Salas yip kuyip piyow niŋiy, biynimb guniy kuyip ñon, pikyaŋ aŋgiy, am Jeson korip ak piŋiy kus kus giy, piyow mer niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Piyow mer niŋiy, Jeson nup diy, biynimb Jiysis nup gosimb niŋyak gunap sek diy, dand gapman biyomb mindeyak ak amiy, kor giyak. Kor giy aŋgyak, “Bi miñmon okok maŋgiysek taŋgiy minim aŋgñiyakniŋ, kilpul yomb apay gok, miñiy ap mindpay miñmon chin biy. ");
INSERT INTO kmh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Kiyk gapman biyomb chinup Siysa nup kirgiy, Biyomb kiyk Jiysis nup nep dipay. Pen bi Jeson biy, bi kun gok kuyip dam korip nuk ak ayip ak mey, nup dand aswun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kun aŋgeyak, biynimb kuŋay ap mindeyak gok sek, gapman biyomb gok sek niŋiy, gos kuŋay niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Gos kuŋay niŋiy, Jeson nup maniy gunap diy, biynimb nup sek dand wiyak gok maniy gunap diy aŋgyak, “Kisen minim kun ak tip aŋgñeniŋgambim, maniy nimbip kun biy pisnep diniŋgambun aŋgyak.” Kun aŋgiy, kuyip aŋg mis yokyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kisyim owakniŋ, mam Tesalonayka nimb gok, Pol yip, Salas yip kuyip aŋgyokey, miñmon Beriya amnirik. Amiy, Jiwda nan-gep korip miŋgan ak amiy, biynimb gok kuyip minim aŋgñirik. ");
INSERT INTO kmh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jiwda biynimb kun gok, Jiwda biynimb Tesalonayka mindeyak gok rek mer; kiyk mindrep giyak ak mey; minim kuyipmiŋay ak niŋey tep gakniŋ, niŋind apiyr akaŋ aŋgiy, Baybol buk ak minek minek riytiym gi niŋiy mey, ");
INSERT INTO kmh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","13","biynimb kuŋaynep, Jiysis nup gosimb niŋyak. Griyk biyn yimb mindek gok kunep, kuŋaynep Jiysis nup gosimb niŋyak. Pen Pol am Beriya biynimb kuyip, Gor minim ak aŋgñisap aŋgey, Jiwda biynimb Jiw ap Tesalonayka mindyiŋgipay gok miluk yapek, apiy Beriya biynimb kuyip nembnemb gey, kal jiwniŋg geyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kun ak niŋiy, biynimb Jiysis nup gosimb niŋyak gok, Timotiy yip, Salas yip kuyipmiŋay miñmon Beriya kun ak kirgiy, Pol nup dam miñmon nambiys gol okok yokyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pen bi gunap Pol nup dam miñmon Atens yokiy, andkind amniyakniŋ, Pol kuyip aŋgak, “Timotiy yip, Salas yip kuyip aŋgyokem, kasek winimiyr aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nuk kun aŋgiy, kuyipmiŋay miñmon Atens kun ak kond mindyiŋg niŋak; biynimb kun gok, gor yesek kiyk aŋgniŋyiŋgipay gok, kuŋay yimb nep mindek. Niŋek, simbwur nup ak timey yimb gek, ");
INSERT INTO kmh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","lotiw ñin gok Jiwda nan-gep korip ak amiy, bi Jiwda nimb gunap, bi yikop Gor nup aŋgniŋyiŋgipay gunap yip minim aŋg amiy apiy giyiŋgipay. Pen ñin yikop gunap kunep, ap biynimb nan-giyiŋgipay tip ak nan-giy, kiy yip minim aŋg amiy apiy gi mindyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Miñmon kun okok, biynimb gos ar keykey niŋyak gok, yimb keykey aŋgiy, gunap Epkiwriyan biynimb aŋgyak, gunap Stoyik biynimb aŋgyak. Minek bap, Pol biynimb kun gok yip minim aŋg amiy apiy giy, Jiysis kumiy tikjakak minim ak aŋgek, bi tiysa kiyk gok sek niŋiy; gunap aŋgyak, “Bi minim monmon aŋgip biy, minim kun ak yerip asap?” Pen gunap aŋgyak, “Biynimb par okok aŋgniŋbay tap gok asap aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Pen Pol nup dand kanjsol kay mindeyak ak amiy aŋgyak, “Nand minim kisenimb, biynimb okok kuyip apan ak, miñiy chinup aŋgey, minim kiñiŋ kun ak niŋrep gun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pen biynimb miñmon Atens nimb gok sek, biynimb okok nimb ap Atens mindeyak gok sek minim kisenimb gunap niŋiy, aŋg mindonjun aŋgiy gos anep niŋyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pen Pol kanjsol mindeyak namb ak tikjakiy aŋgak, “Nimb Atens biynimb. Yand nimbip niŋbiyn. Nimb kilis yimb giy, tap gunap aŋgniŋun aŋgiy, gos ak niŋbim. ");
INSERT INTO kmh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Yand akniy taŋgiy niŋbiyn; nimb kamb bind keykey giy, tap keykey aŋgniŋbim rek, yimb ak ar kun ak tikpik. Kamb bind bap gaypik ak, yimb ak tikiy apik, ‘Bi ma niŋbun ak: kamb bind nup biy apik.’ Minim ma niŋbun aŋgiy tikpik kun ak, nimbip miñiy kiñiŋ ak aŋgniŋg gispiyn. ");
INSERT INTO kmh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Gor mankumb biy gay, tap okok maŋgiysek gay gak ak, nuk biyomb yimb. Semb biyoŋ sek, man biy sek kond mindip. Biynimb gok korip akaŋ, tap gunap gayey, nuk ap tap gayniŋgambay namb kun okok mindonimuŋ rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nuk chinup gay, añiŋ band ak yokek, añiŋ ayiŋg mindpun. Tap chin okok maŋgiysek, nuk nep gayak. Nuk Bi kalrimey kun ak, chin tap tep bap giy, nup ñinjun rek ma ayip. ");
INSERT INTO kmh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nuk Andam nup nep gayek, Andam nuk pen tik dand amiy apiy gek mey, biynimb keykey okok maŋgiysek mindpun. Gor nuk nep gek mey, biynimb gunap miñmon bap mindiy, mind dand amiy, kisen nuk key aŋgak ñin ak apek, biynimb okok nimb gunap ap tip kun ak dipay. ");
INSERT INTO kmh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Gor gek, ñin gunap kosyam mindpun ak, yip gosimb niŋyaŋ aŋgiy gip. Nup gosimb niŋniŋg, nuk par okok ma mindip; chin yip mindip. ");
INSERT INTO kmh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ñin ar nuk ak mey, chin mindpun. Pen bi minim kil tikep nimb key gunap, Gor nup Bapiy chin aŋgyak ak, niŋind aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pen biynimb gok yenen gol, kamb, tap gok diy, gos kiyk key niŋiy, tap gunap gay aŋgniŋbay. ");
INSERT INTO kmh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Wosrey Gor minim nup ak ma niŋyiŋgipay rek, kuyip minim gunap kuŋay ma aŋgak. Pen miñiy biynimb miñmon okok maŋgiysek kuyip aŋgip, ‘Tap gunap aŋgniŋbim ak kirgiy, tap yerip yerip timey gipim ak kirgiy, yip nep gosimb niŋnimimb aŋgip.’ ");
INSERT INTO kmh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Aŋgip kun ak niŋrep yimb ginjun. Kisen nuk key niŋimb ñin bap apek, binuk yipund giy nep gip ak yokek apiy, biynimb maŋgiysek kor giy, bilokniŋgamb. Chin niŋbun: binuk chinup kor yomb giniŋgamb kun ak, Gor gek kumiy tip ak tikjakak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pol minim kun ak kun giy aŋgek, biynimb mindeyak gok niŋyiŋg, gunap sik aŋgyak; gunap aŋgyak, “Ñin gunap minim kun ak tip aŋgenimin, chin niŋjun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kun aŋgyakniŋ, Pol kuyip kiriŋg amnak. ");
INSERT INTO kmh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pen miñmon Atens kun ak, biyn bi gunap, minim nup ak kindik giy, Jiysis nup gosimb niŋyak. Biyn bi kun gok mey, bi bap yimb nup ak Dayoniysiyas. Nuk biyomb kanjsol kiyk kun ak nimb bap. Biyn bap yimb nuk Damariys. Pen biynimb bi yikop gunap sek Jiysis nup gosimb niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol miñmon Atens kun ak kirgiy, miñmon Koriyn amiy niŋak; ");
INSERT INTO kmh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","bi Jiwda ber, miñmon Pontas nimb bap ap minderik. Biynuk yimb ak Priysiyla; nuŋgumiy yimb ak, Akiwiyla. Biber kun ak, kiyk am mindyiŋgipiyr; miñmon Yitaliy, Rom maŋ okok. Kiyk kun giy am mindyiŋgipiyr ak pen, ñin kun ak biyomb Kilodiyas, Jiwda gunap miñmon Rom biy ma mindeniŋgiy aŋgek mey, ap miñmon Atens kun ak minderik. Biber kun ak, kiyk ser korip gayiŋgipiyr. Pen Pol kunep, woŋg kun ak rek giyiŋgip ak mey, am kiy yip mindiy, ser gok gayiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pol nuk pen, Jiwda biynimb, Griyk biynimb maŋgiysek niŋyaŋ aŋgiy, Jiwda lotiw ñin ak wakniŋ, nan-gep korip ak amiy, kiy yip minim aŋg amiy apiy giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kun gi dand amiy, kisen Salas yip, Timotiy yip miñmon Masedoniya kirgiy aperik, ser giyiŋgip woŋg ak kirgiy, minek minek Jiwda biynimb gok kuyip minim aŋgñiraŋgyiŋg aŋgyiŋgip, “Bi Kiyŋ yomb key yimb per kond mindyiŋgipun ak mey, Jiysis nep aŋgyiŋgip.” ");
INSERT INTO kmh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kun aŋgek, minim nup ak ma niŋiy, nup aŋgjiweyak; Gor nup yenen kirpay aŋgiy, chech nuk ak pipal pikyiŋg, kuyip aŋgak, “Yand nimbip Gor minim ak aŋgñen ma niŋbim ak, tap nimbik key. Miñiy nimbip Jiwda biynimb kirgiy, biynimb Jiwda mer gok kuyip aŋgñiniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kun aŋgiy, kuyip kirgiy, bi Jiwda mer bap korip ak amnak. Bi kun ak yimb nuk Taytas Jastas. Nuk Gor nup aŋgniŋyiŋgip. Korip nuk ak mindek; Jiwda nan-gep korip gol siŋak. ");
INSERT INTO kmh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pen Kriyspas, bi Jiwda nan-gep korip kond mindyiŋgip ak; biynimb nuk yip mindeyak gok yip, Pol Jiysis minim aŋgak ak, niŋind aŋgip aŋgiy, Jiysis nup gosimb niŋiy ñiŋg pikyak. Koriyn biynimb gunap kunep, Pol minim aŋgak ak niŋiy, Jiysis nup gosimb niŋiy, ñiŋg pikyak. ");
INSERT INTO kmh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Minek bap, Pol day niŋak; Biyomb ak nup aŋgak, “Yand nand yip nep mindpiyn ak mey, ma piriknimin; minim yip ak biynimb gok kuyip monmon aŋgñinimin. ");
INSERT INTO kmh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Miñmon yomb biy, biynimb yand kuŋay yimb nep mindpay; biynimb gunap nip timey giniŋgiy rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kun aŋgek, Pol miñmon okok ma amnak; miñmon kun anep mindiy, simiy nokom, takin onep kaŋgol ak, Gor minim ak aŋgñi mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pen Rom biynimb gok, biyomb Galiyow nup aŋgey, ap Akaya propens kond mindek ñin ak; Jiwda biynimb gok, Pol nup niŋey miluk yapek, nup dand kor amiy aŋgyak, ");
INSERT INTO kmh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Bi biy biynimb gok kuyip Gor minim aŋgñispiyn aŋgiy, Rom biynimb mer apay minim gok nep kuyip aŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kun aŋgeyak, Pol minim kun ak pen aŋgiyn aŋgakniŋ, biyomb Galiyow tikjakiy kuyip aŋgak, “Nimb Jiwda biynimb. Bi biy tap timey bap gombikop, minim nimb kor gipim ak niŋbinip. ");
INSERT INTO kmh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pen nimb yikop apim, ‘Bi biy yesek aŋgiy aŋgip, “Bi Kiyŋ yomb key yimb per kond mindpun ak mey, Jiysis nep aŋgiy,” nasind sikop minim mer apay ak gunap aŋgiy gip apim’ ak, yand ma niŋniŋgayn. Ak minim yand mer. Minim kun ak nimbik key aŋgnimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kun aŋgiy, kuyip aŋg mis yokakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","kiyk mis amyiŋg, bi Jiwda nan-gep korip kond mindep, Sosteniys nup kur diy pikyak. Nup kun giyak ak pen; biyomb Galiyow niŋiy, minim bap ma aŋgak. ");
INSERT INTO kmh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pen Pol miñmon Koriyn tapin mindiy, mam ay gok kuyip aŋgak, “Nimbkaw mindem aŋgiy,” Akiwiyla ber yip miñmon Siyriya amnun aŋgiy, siyip diy saŋdiyak. Am am miñmon Senkriya apay ak amjakiy, Pol yand Gor nup chiŋgiy nep mindeniŋgayn aŋgiy minim aŋgayiŋg, jun kas nuk ak tikak. ");
INSERT INTO kmh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","22","Pen kiyk am am miñmon Yipiyses amjakiy, Pol nuk Jiwda nan-gep korip miŋgan ak amiy, Jiwda biynimb gok yip, minim aŋg amiy apiy gak. Kun gek, nup aŋgyak, “Ñin gunap sek, chin yip biy mindenimin aŋgyak.” Kun aŋgyak ak pen, minim kuyip ak ma diy aŋgak, “Nimb kaw mindem. Gor yip yaw aŋgeniŋgamb; kisen andkind winiŋgayn aŋgak.” Kun aŋgiy, Akiwiyla ber kuyip, biynimb kun gok yip aŋgay, nuk siyip diy, am am miñmon Siysariya amjakiy, biynimb Jiysis nup gosimb niŋyak gok kuyip, nimb mindpim aŋgiy, tip ak siyip diy, miñmon Antiyok amnak. ");
INSERT INTO kmh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Amiy, tapin yep ñin kaw bap mindiy kuyip kirgiy, nuk am Galesiya propens okok sek, Priysiya propens okok sek giraŋgyiŋg; biynimb Jiysis nup nind gosimb niŋyak gok kuyip, aŋgñirep gek, niŋrep giyak. ");
INSERT INTO kmh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","25","Pen bi Jiwda miñmon Aleksandriya nimb bap, ap Yipiyses mindek. Yimb nuk ak Apolas. Nuk bi minim aŋgrep yimb giy; Baybol buk day nind tikyak ak niŋrep yimb giy gak ak mey; Jiysis minim ak biynimb okok kuyip yipund giy nep aŋgak. Minim aŋgak kun ak, Jon bi ñiŋg pikñemb niŋak rek nep niŋiy aŋgak. Pen nuk Jiysis minim gunap sek niŋrep ma gak. ");
INSERT INTO kmh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ñin kun ak tikiy nuk ma pirikiy, Jiwda nan-gep korip ak amiy, Jiysis minim ak monmon yimb aŋgñak. Aŋgñek, Akiwiyla ber niŋiy, nup dand korip kiyk ak amiy, Jiysis minim ma niŋak won gunap, aŋgñirep yimb girik. ");
INSERT INTO kmh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","28","Kisen nuk Akaya propens amniŋg gek, Yipiyses biynimb Jiysis nup gosimb niŋyak gok, tep yimb am kuyip aŋgñiniŋgamb aŋgiy, Akaya biynimb Jiysis nup gosimb niŋyak gok kuyip minj bap tikiy aŋgyak, “Bi Gor woŋg gip Apolas amjakek, nup dinimimb aŋgyak.” Kun aŋgey mey, Apolas amjakiy, minj ak yomek, Akaya biynimb Gor kuyip simb niŋiy gos tep ñek, Jiysis nup gosimb niŋyak gok maŋgiysek, Apolas nup diyak. Deyak, nuk pen tip kuyip ak diy, Jiwda biynimb gok kuyip minek minek, Baybol buk minim ar ak aŋgrep giyiŋg aŋgak, “Bi Kiyŋ yomb key yimb aŋgiy, kond mindpim ak mey, Jiysis nep aŋgak.” Kun giy aŋgrep gek, nup minim bap pen aŋgniŋgiy rek ma ayak. Kun gek, biynimb gok Jiysis nup gosimb niŋiy, mindrep yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolas miñmon Koriyn mindakniŋ, Pol miñmon dum bap paŋind amiy, miñmon Yipiyses amjakiy, biynimb Jiysis nup minim niŋun aŋgyak gunap mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kuyip niŋiy aŋgak, “Nimb Jiysis nup gosimb niŋbik ñin ak, Gor Kawnan kunep dipik?” Aŋgek aŋgyak, “Mer. Gor Kawnan mindip aŋgiy chin ma niŋbun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Aŋgeyak, Pol kuyip aŋgak, “Pen nimb yenen ñiŋg pik pik?” Aŋgek aŋgyak, “Chin Jon aŋgyiŋgip minim ak diy, ñiŋg piknuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kun aŋgeyak aŋgak, “Jon biynimb gok aŋgek ñiŋg pikyiŋgipay ak; tap siy tap timey gipun ak, yenen kun gipun aŋgiy niŋey mey, kuyip ñiŋg pikñiyiŋgip. Pen kuyip aŋgyiŋgip, ‘Biyomb kisen winiŋgamb ak apek, nup gosimb niŋnimimb aŋgyiŋgip.’ Bi kisen winiŋgamb aŋgak kun ak, Jiysis nep aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pol kun aŋgek, Jiysis biynimb nuk yimb mindenjun aŋgiy, tip ak ñiŋg pikyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol kuyip diniŋek, Gor Kawnan nuk ak kuyip yokek, minim yimb keykey aŋgiy, day Gor minim tep ak aŋgñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bi anep wimiŋgan ak rek kun giyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol takin omiŋal nokom, biynimb Jiwda nan-gep korip wiyak gok yip, Gor biynimb diy kond mindeniŋgamb minim ak aŋg amiy apiy gi mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pen biynimb gunap, minim tep ak ma yimb diy, biynimb mindeyak namb ak aŋgyak, “Kinjeŋ tep amemb apay minim kun ak minim rek ma ayip aŋgyak.” Kun aŋgeyak, Pol biynimb Jiysis nup gosimb niŋyak gok kuyip nep dand Tayrenas sikul korip yomb ak amiy, kuyip minim aŋgñi mindyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kun giy aŋgñi mindek, simiy omiŋal yinek mey, Jiwda biynimb gok diy, Griyk biynimb gok diy, miñmon yomb Esiya mindeyak rek maŋgiysek, Jiysis nup minim ak, kun kun giy apay aŋgiy niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Gor, Pol yip mindakniŋ, nuk tap mageprek key yimb gunap giyiŋgip. ");
INSERT INTO kmh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Biynimb gok tap gek, Pol aŋgsiyip chech band nup gok dam, mumbwak ar kiyk gok ay, jak amyiŋgipay. Kichekiy tap gok ambaŋ ayiŋgip gok kunep mis amyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jiwda bi kunj tap gok giyiŋg, kichekiy tap gok aŋgyokpun aŋgiy giraŋgyiŋgipay gok, Pol gak rek niŋiy chin kunep gun aŋgiy, kichekiy gok kuyip aŋgyak, “Jiysis Biyomb Pol per aŋgniŋimb ak mindip rek, mis amnoŋ aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","16","Pen bi Gor nup simboŋgep yomb Siypa, ñinuk onep ar ak mindeyak. Kiyk kunep kichekiy tap gok aŋgyokun aŋgiy aŋgeyak, kichekiy biynimb ambaŋ ayak gok pen aŋgyak, “Jiysis yip, Pol yip kuyip niŋbun ak pen, nimb bi an?” Kun aŋgiy, bi kun gok kuyip talakiy, tapin nep pikiy, chech kuyip gok tuŋgralikyokey, daynep mindiy, korip kun ak kirgiy pirik amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Pen minim kun ak, Jiwda biynimb, Griyk biynimb, miñmon Yipiyses mindeyak gok maŋgiysek niŋiy pirikiy, Jiysis yimb nup ak tapin nep dand aranyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Jiysis biynimb nuk mindeyak gok, gunap ap nan-giy, kunj tap yerip timey giyak gok, miseŋ aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kunj tap gok giy, buk tik ayiŋgipay gok, biynimb niŋmindyakniŋ, mon pik daŋgiyey yinak. Buk tap kun gok, maniy tawep namb ak ñin paŋgey, piyptiy tawsin (50,000) rek amnak. ");
INSERT INTO kmh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pen miñmon Yipiyses kun geyak, Biyomb minim nuk ak yomb yimb gak. ");
INSERT INTO kmh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pen kun giy, kisen Gor Kawnan ak Pol nup gos ñek aŋgak, “Yand Masedoniya amiy, Akaya amiy, Jerusalem amniŋgayn. Amiy, miñmon Rom kunep amniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kun aŋgiy, bi nup kond minderik, Timotiy yip, Yirastas yip kuyip aŋgyokek, miñmon Masedoniya amerik; nuk miñmon Yipiyses takiy ñin kaw bap mindek. ");
INSERT INTO kmh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ñin namb kun ak, Yipiyses biynimb yikop gunap, Jiysis nep mey; Gor yip jimñiy mindep kinjeŋram ak mindip aŋgeyak, kiy yip penpen giniŋg rek giyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Bi bap, yimb nuk Demetriyas ak, bi gunap yip, tap gol rek ak diy, tap yesek aŋgniŋyiŋgipay korip achimb kilrimey gunap gayey, biynimb gunap ap taw dam ay, biyn yomb chin Atemis nup aŋgniŋep korip ak aŋgiy, aŋgniŋyiŋgipay. Bi kun gok woŋg kun ak giy, maniy yomb yimb diyiŋgipay rek, ");
INSERT INTO kmh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriyas nuk bi nup woŋg giyak gok sek, bi woŋg kiyk giyiŋgipay kun ak rek giyak gok sek aŋgek, ap nan-geyak aŋgak, “Nimb niŋbim; chin woŋg nokom kun biy giy mey, maniy yomb yimb dipun. ");
INSERT INTO kmh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pen Pol apiy, biynimb gok kuyip yesek aŋgiy aŋgip, ‘Ñin maŋgiy diy tap gipay gok, tap aŋgniŋep mer aŋgip.’ Kun aŋgamb, Yipiyses biynimb gok diy, Esiya propens biynimb okok diy maŋgiysek niŋsipay. ");
INSERT INTO kmh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Pol minim nuk ak aŋgek, tap gon tawyiŋgipay ak, miñiy ma tawpay. Pen ar kun anep ma aspiyn; biyn yomb chin Atemis nup aŋgniŋbun ak kirgiy, korip yomb nup aŋgniŋbay ak kirgiy gispay aŋgiy aspiyn. Biynimb akniy nep nup ma kirpay, biynimb okok kunep nup kirginiŋg gispay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","29","Demetriyas kun aŋgek, bi kun gok niŋiy, biyn yomb chin aŋgniŋbun ak nep aŋgiy, meŋg miŋgan dand araniy aŋg amiy apiy giyakniŋ, biynimb dawin yomb kun animb kuŋaynep apiy, Pol binup omiŋal ak kuyip, lipiŋg dand minim aŋgep tip ak amniyak. Binuk omiŋal kun ak, nuk yip Masedoniya nimb ap minderik. Yimb kiymiŋay ak, Gayas yip, Ariystakas yip. ");
INSERT INTO kmh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol pen, biynimb ap nan-giy, minim aŋgeyak namb ak amniyn aŋgek, bi Jiysis nup gosimb niŋyak gok nup mer aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Gapman biyomb gunap, Pol nup buŋgiy kiyk ak mey, nup minim yokiy aŋgyak, “Biynimb ap nan-giy, minim aspay namb ak ma amnimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pen biynimb kuŋaynep ap nan-giy, minim yomb aŋgiy, minim keykey yimb nep aŋgyak. Kiyk minim kiñiŋ niŋiy aspun ak aŋgiy ma niŋyak; monmon nep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bi Jiwda gunap, bi chin Aleksanda, kuyip aŋgrep giniŋgamb aŋgiy, nup biynimb namb ak yokeyak, nuk kuyip ñin tuŋg milich giy, minim aŋgniŋg gakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kiyk niŋyak; nuk Jiwda nimb ak mey, meŋg miŋgan dand araniy aŋgak, “Atemis nep mey, biyn yomb chin aŋgiy,” tapin nep aŋg mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kun giy aŋg mindey mindey; bi ñiwkil tikep yomb kiyk ak tikjakiy kuyip aŋgak, “Kapkap mindem aŋgak.” Kun aŋgek, kapkap mindyakniŋ aŋgak, “Yipiyses biynimb. Miñmon chin biy, biyn yomb Atemis kamb nuk gap rek, semb biyoŋ nimb jiw owak ak diy, korip gayrep giy aŋgniŋbun ak; an ma niŋimb aŋgiy, kilpul yomb ak aspim? ");
INSERT INTO kmh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Minim kun ak, biynimb maŋgiysek niŋbay nen: kirgim. ");
INSERT INTO kmh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","“Pen bi dand opim omiŋal biy, biyn yomb Atemis nup aŋgniŋbun ak, nup ma aŋgjiwiy, korip nup aŋgniŋbun tap gunap siy ma dipiyr ak pen; kuyip dand opim. ");
INSERT INTO kmh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kun ak Demetriyas akaŋ, binuk gunap minim mindek kor giniŋg, biyomb gok mindpay ak mey, kor giniŋgiy. ");
INSERT INTO kmh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pen minim miker gunap mindonimuŋ, ap nan-gipun ñin ak nep aŋgnimimb. ");
INSERT INTO kmh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Chin miñiy ap nan-giy kilpul aspun ak, minim kiñiŋ bap mindek ma aspun. Gapman biyomb yimb bap, yenen ap nan-giy minim aspim aŋgek, pen minim bap aŋgjun rek ma ayip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nuk kun aŋgiy, kuyip aŋgyokek, keykey amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pen biynimb gok minim yomb aŋg mindiy keykey amniyakniŋ, Pol biynimb Jiysis nup gosimb niŋyak gok kuyip suk aŋgek apeyak; Gor minim gunap aŋgñirep yimb giy, kuyip kirgiy, nuk miñmon Masedoniya amnak. ");
INSERT INTO kmh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Amiy, kun okok taŋgyiŋg, biynimb Jiysis nup gosimb niŋyak gok kuyip, Jiysis minim ak aŋgñi dam dam, miñmon Griyk amjakak. ");
INSERT INTO kmh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Amjakiy, takin omiŋal nokom kun ak mindiy, kisen siyip diy, Siyriya amniyn aŋgak ak pen; nuk minim bap niŋak; Jiwda kay nup pik ayniŋg geyak. Minim kun ak niŋiy, lum ar nep andkind Masedoniya amniyn aŋgiy niŋak. ");
INSERT INTO kmh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","5","Pen Pol binuk yip taŋgeyak gok mey Timotiy; Piras ñinuk Sopata miñmon Beriya nimb; Ariystakas yip, Sekundas yip Tesalonayka nimb; Gayas Debiy nimb; Tikiykas yip, Tropiymas yip Esiya nimb. Bi kun gok, Pol yip ap ap miñmon Piyliypay apiy, kiyk nind miñmon Trowas amiy, chinup kond mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Jiwda ñin yomb biret yiys sek ma ñimbun ñin ak mindon pandikakniŋ, kisen siyip diy, ñin onep mamind ak namb kiniy, miñmon Trowas amjaknuk. Amiy, wiyk nokom bap kun okok mindonuk. ");
INSERT INTO kmh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","8","Wiyk mindonuk kun ak, Sarirey duŋgep won ak, biret wayn ñiŋniŋg am korip ar biyoŋ nan-giy, Pol toy amniŋgayn aŋgiy, minim aŋgakniŋ, niŋmindonuk. Kun giy niŋmindon mindon, kisyim apek, lam daŋgiy ay niŋmindonuk. ");
INSERT INTO kmh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pen bi paranj bap, wiyndiw ar ak bisgiy, Pol minim aŋgakniŋ, niŋmindek. Yimb nuk ak Yiwtiykas. Nuk kun giy niŋmind mind, wisin kalrimey yimb apek, wisin juk juk gi gi, biyoŋ nimb gindam man biyaŋ pikek, am biyaŋ diy niŋyak: pisnep kumiy mindek. ");
INSERT INTO kmh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol nuk pen biyaŋ amiy, nup namb namb diy aŋgak, “Gos kuŋay ma niŋnimimb; nuk kim mindip aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kun aŋgiy, tip biyoŋ amiy, biret gunap tipaŋg jimñiy ñimbiy, Pol tip ak minim aŋg mindek mindek, miñmon yapiy, pumb owakniŋ amnak. ");
INSERT INTO kmh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pen bi paranj apyap pikak anup, dand korip amiy, miñmiñ yimb giyak. ");
INSERT INTO kmh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pol chinup aŋgak, “Nimb siyip diy miñmon Asos amenimimb; yand man ar apiy, siyip diniŋgayn miñmon kun ak aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kun aŋgek, chin siyip diy am Asos amiy, Pol nup kun ak diy, miñmon Mitiliyniy amninuk. ");
INSERT INTO kmh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","16","Minek Mitiliyniy kirgiy, miñmon Chiyos maŋ ak amjaknuk. Minek ak, miñmon Samos amjakiy, Pol nuk gos bap niŋak: Yipiyses amiy, sayn nep giraŋgiy, Pendiykos ñin ak, Jerusalem ma niŋjun rek ayek mey, Yipiyses silgiy, Miletas amninuk. ");
INSERT INTO kmh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletas amiy, Pol minim yokek Yipiyses amek, Jiysis biynimb nuk gok kuyip kond mindeyak bi gok kuyip aŋgak, “Mindpiyn biy winiŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kun aŋgek, apeyak aŋgak, “Nind propens nimbip biy mawep ñin ak apiy, nimb yip mindiy, mind dand amiy, yerip yerip giyiŋgipiyn ak niŋbim. ");
INSERT INTO kmh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yimb yand ma dand araninik; Krays nup woŋg ak giñinikniŋ, Jiwda biynimb yip timey giniŋg geyak, yip simb gek, siy aŋgyiŋg, minim aŋgñinik. ");
INSERT INTO kmh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pen yand korip nimbip okok akaŋ, nan-gipim tip okok amiy, minim tep nup bap weygiy ma aŋgñinik; maŋgiysek nep aŋgñinik. ");
INSERT INTO kmh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nimbip Jiwda biynimb gok diy, Jiwda biynimb mer gok diy, aŋgrep giy aŋgnik, ‘Tap timey gipim ak kirgiy, Gor aŋgip minim ak diy, Jiysis nup gosimb niŋnimimb aŋgnik.’ ");
INSERT INTO kmh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Pen miñiy niŋim! Gor Kawnan ak, yip miñ rek ay, dand Jerusalem amjap ak; yip yerip rek giniŋgamb ak ma niŋbiyn. ");
INSERT INTO kmh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Pen yand niŋbiyn: miñmon gok miñmon gok amjaken; Gor Kawnan ak yip aŋgip, “Nand Jerusalem amey, nip kalambis ayey, kosyam yimb mindeniŋgamban aŋgip.” ");
INSERT INTO kmh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pen ak minim ma mindip. Yand keynep mindrep giyn aŋgiy gos ak ma niŋbiyn. Yip pikniŋgambay aŋgiy, ma pirikpiyn. Biyomb Jiysis, woŋg yip aŋgak ak nep gosimb niŋbiyn ak mey, Gor chinup simb niŋiy dip minim tep ak, aŋgyiŋg nep mindeniŋgayn. ");
INSERT INTO kmh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Pen niŋim. Nimb biynimb akay akay, Gor biynimb diy kond mindeniŋgamb aŋgen niŋbim gok, yip tip ak ma niŋniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Miñiy amniŋg mey, nimbip miseŋ aspiyn. Biynimb Gor minim ma niŋiy yiwur yomb diniŋgambay gok; tap kiyk key. Yand yip mer. ");
INSERT INTO kmh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Yand Gor minim bap ma aŋgñimbiyn mer; maŋgiysek yimb nimbip aŋgñimbiyn. ");
INSERT INTO kmh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nimb key niŋrep giy, biynimb Gor Kawnan aŋgek kond mindpim gok kuyip, niŋrep giy ginimimb. Bi kanj siypsiyp mokep gok, kanj kiyk gok kond mindrep gipay rek, nimb biynimb Jiysis nup gosimb niŋbay gok kuyip, kond mindrep ginimimb. Gor chinup simb niŋiy, Ñinuk nup yokek ap chinup aŋgiy kumak ak, sakiy ma ginimimb. Niŋmindiy, biynimb nup ker mindpay gok kuyip kond mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yand niŋbiyn. Yand amen, kayn sakiy gok apiy, kanj siypsiyp nimb mokpim gok gunap siw ñiŋniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Biynimb gunap pen tikjakiy, minim yesek yesek aŋgiy, biynimb Jiysis nup gosimb niŋbay gunap kuyip, lipiŋg dand kind kiyk okok amniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pen yand simiy omiŋal nokom, miñmon nimbip Yipiyses mindiy, pumbnamb kisyimken, simb gakniŋ, siy aŋgyiŋg nimbip maŋgiysek aŋgñirep ginik. Minim aŋgñinik kun ak sakiy ma ginimimb; niŋyiŋg nep mindenimimb. ");
INSERT INTO kmh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Yand nimbip Gor ñin ar ak ay amjipiyn. Nuk nimb yip mindeniŋgamb. Minim tep nup ak niŋnep mindiy mey; biynimb suŋ-tep nuk gunap yip mindrep giniŋgambim. ");
INSERT INTO kmh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Nimb yip mindenik ñin ak, biynimb gunap, chech maniy tap kuyip gok asimb ma aŋgnik. ");
INSERT INTO kmh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ñin maŋgiy yand ak keynep woŋg giy, bi yip taŋgyiŋgipun gok yip, tap ñimbyiŋgipun. ");
INSERT INTO kmh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Pen gipiyn kun ak rek nimb kunep giy, biynimb simbgeprek gok kuyip direp ginimimb. Biyomb chin Jiysis, minim aŋgak ak niŋbim. Nuk aŋgak, ‘Bi gunap nimbip tap ñeniŋgambay, nimbip tep giniŋgamb ak pen; nimb biynimb gunap kuyip tap ñiniŋgambim ak, nimbip tep yimb giniŋgamb aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol minim kun ak aŋgjiwiy, biyomb Yipiyses nimb kun gok yip koŋgim yimiy, Gor nup aŋgniŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Pen Pol bi kun gok kuyip, kisen jomluk yip ak ma niŋniŋgambim aŋgek, nup am kaykol giy, siy aŋgiy, kuyip simb gakniŋ, nup namb ay dam siyip miŋgan ak yokyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pen chin Yipiyses biynimb kuyip, nimb mindem aŋgiy saŋdinuk. Yiŋgen ak aprep gek, yipund giy nep am am, Kos amninuk. Pen minek Kos kirgiy, Rowdes amiy, Patara amninuk. ");
INSERT INTO kmh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Amiy niŋnuk; siyip bap Piniysiya amniŋg gek mey, chin siyip kun ak diy saŋdinuk. ");
INSERT INTO kmh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Am am, Saypras ñin aŋind kind okok ken mindakniŋ, niŋyiŋg am am, Siyriya niŋnuk. Tap kakaw gok, Siyriya yisik yokniŋg mey, am sua ginuk Taya. ");
INSERT INTO kmh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Taya sua giy, am biynimb Jiysis nup gosimb niŋyak gok kuyip piyow niŋiy, kiy yip wiyk nokom bap mindonuk. Pen Gor Kawnan ak biynimb kun gok kuyip gos ñek, Pol nup aŋgyak, “Jerusalem amniŋg gispan ak ma amnimin aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Pen siyip ak tap kakaw yisik yokdey, amjipun aŋgon, biynimb Jiysis nup gosimb niŋyak kun gok, biyn ñapan kiyk gok maŋgiysek, chinup dam ñiŋg gol ak yokey, kiy yip koŋgim yimiy, Gor nup aŋgniŋnuk. Pen chin penpen ñin piksakiy, ");
INSERT INTO kmh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","am siyip ak dinukniŋ, kiyk andkind korip amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Pen chin siyip diy Taya kirgiy, am sua ginuk: Tolemeys. Sua giy, biynimb Jiysis nup gosimb niŋyak gok kuyip aŋgnuk, “Nimb mindpim aŋgnuk.” Kun aŋgiy, ñin bap kiy yip kun ak mindonuk. ");
INSERT INTO kmh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Minek ak kuyip kirgiy, am Siysariya amjakiy, Piyliyp korip ak amninuk. Nuk bi yipenjiliys bap. Nup mey, nind Jerusalem mindek, bi onep kaŋgol ak yip aŋgayeyak, keñmaŋgiy bilok ñiyiŋgipay. ");
INSERT INTO kmh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pen bi Piyliyp kun ak, panuk onep tiŋgawip ak Gor minim aŋgyiŋgipay. Pañ kun gok kiyk bi ma diyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","11","Chin Piyliyp yip mindonuk ñin namb kun ak, bi Gor minim aŋgep Aŋgabas; miñmon Jiwdiya nimb ak apiy, Pol ler nup ak diy, ñin tomb nuk gok tiwniŋgrimbikiy aŋgak, “Gor Kawnan ak aŋgip, ‘Bi ler nop kun biy nup, Jerusalem amek, Jiwda biynimb nup tiwniŋgrimbikiy, dam Rom biyomb gok kuyip ñiniŋgambay aŋgip aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kun aŋgek, chin maŋgiysek minim kun ak niŋiy, Pol nup aŋgnuk, “Jerusalem ma amnimin aŋgnuk.” ");
INSERT INTO kmh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Aŋgonuk, nuk pen aŋgak, “Yip yenen simb niŋiy siy aŋgem, yip simb gisap. Yand Jerusalem amiy, Jiysis minim ak aŋgniŋgayn. Yip kalambis ayniŋgambay akaŋ, pik ayniŋgambay ak, ma piriksipiyn. Monmon am aŋgniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pen chin Pol nup kun giy aŋg mer niŋiy aŋgnuk, “Bapiy Gor key niŋimb rek giniŋgamb aŋgnuk.” ");
INSERT INTO kmh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","16","Pen chin kun giy Siysariya mindiy, Jerusalem amniŋg, tap chin gok moka giy, biynimb Jiysis nup gosimb niŋyak miñmon kun okok nimb gunap poŋind, Jerusalem amonuk; chinup dam Nason korip ak ayey kininuk. Bi Nason kun ak, miñmon Saypras nimb. Nuk Jiysis nup nind nep gosimb niŋak. ");
INSERT INTO kmh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Biynimb Jiysis nup gosimb niŋyak gok maŋgiysek, chinup niŋey tep gak. ");
INSERT INTO kmh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Minek minim aŋgniŋg; biyomb Jiysis biynimb nuk gok kuyip kond mindyiŋgip Jemis nup niŋniŋg amiy niŋnuk: nuk bi woŋg jimñiy gep gunap yip, ap nan-giy mindeyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pen chin amjakiy, Pol kuyip, nimb mindpim aŋgak. Pol pen, Gor nup kond mindakniŋ, Jiwda biynimb mer miñmon okok taŋgiy, tap yerip yerip gak ak, biyomb kun gok kuyip kesim diñak. ");
INSERT INTO kmh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kiyk minim kun ak niŋiy, Gor nup tep aŋgiy, Pol nup aŋgyak, “Mam. Nand niŋban: Jiwda biynimb tawsin kuŋaynep, Jiysis nup gosimb niŋbay ak pen, kilis timey giy apay, ‘Chin Jiwda gok, Jiwda biynimb giyiŋgipay ar ak nep ginjun apay.’ ");
INSERT INTO kmh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kun gipay rek, Jiwda biynimb okok nimb gunap, Jerusalem biy apiy, niŋrep ma giy apay, ‘Pol nuk, Gor minim Mosis wosrey aŋgiy tikak ak kirgiy, chin Jiwda gipun gipun ar ak kirgiy, Jiwda biynimb miñmon paryomb okok mindpay gok kuyip aŋgip, “Ñi nimb gok kumbak ma tiknimimb aŋgip” apay.’ ");
INSERT INTO kmh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Kiyk minim niŋrep ma giy, nip apay kun ak, chin yerginjun? Nand Jerusalem biy opan rek, biynimb kun gok nip niŋiy, minim yomb aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","24","Kun ak bi chin omiŋal omiŋal, chin Jiwda gipun miñ ar ak kindik giy, Gor nup minim bap niŋind yimb aspun aŋgyak ak mey, Gor nup tap pik daŋgiy simboŋg ñiniŋg gispay rek; nand am ñin onep ar ak kiy yip ñiŋg pik tep giy, tap Gor nup simboŋg ñiniŋgambay gok taw ñenimin simboŋg ñiy mey, jun kas kiyk ak tikniŋgambay. Kun geniŋgamban mey, biynimb maŋgiysek nip minim aŋgyak kun ak, yesek nep aŋgyak ak niŋniŋgambay. Nand Jiwda nimb ak mey, chin Jiwda gipun rek nep gipan aŋgniŋgambay. ");
INSERT INTO kmh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pen biynimb Jiwda mer Jiysis nup gosimb niŋbay gok kuyip, minj tikyokiy aŋgnuk: ‘Jiwda kay gipay gipay rek gun aŋgiy, kosyam giniŋgambim. Kun ak tap gunap nep ginimimb. Biynimb gunap tap yesek okok simboŋgyiŋg, kimin kanj pikeniŋgiy, nimb ma ñiŋnimimb. Kimin kanj tap gok likañ sek ma ñiŋnimimb. Kun ak kimin, kanj tap gok kuŋam tuŋgwikey kumek, likañ sek mindeniŋgamb rek ma ñiŋnimimb. Biyn siy bi siy ma ginimimb aŋgiy,’ minj tiknuk aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kun aŋgeyak, Pol minim kuyip ak diy; minek, bi omiŋal omiŋal tap simboŋg ñiniŋg giyak kun gok yip, ñiŋg pik tep giy; Gor aŋgniŋep korip ak amniyak. Amiy, Pol bi mindeyak gok kuyip aŋgak, “Chin ñin onep kaŋgol ak mindiy, ñin ar ak, Gor nup tap ñiŋemb gunap keykey dand apiy, nup simboŋg ñiniŋgambun aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","Kun aŋgiy, ñiŋg pik mindyakniŋ, ar ñin ak maŋ owakniŋ, Jiwda biynimb Esiya mindiy wiyak gunap niŋyak: Pol Gor aŋgniŋep korip miŋgan ak mindek. Niŋiy, nup chichiy diy, meŋg miŋgan dand araniy aŋgyak, “Chin Yisrel biynimb maŋgiysek tikjakiy, bi timey gip biy di mindenjun. Miñmon okok taŋgiy, per timey nep gip bi ak mey biy. Chin Jiwda biynimb gipun ar ak timey aŋgiy, Mosis aŋgiy tikak minim ak timey aŋgiy, Gor aŋgniŋep korip biy aŋgjiwiy gip. Jiwda biynimb mer Gor aŋgniŋep korip miŋgan biy ma dand owep gok kuyip, monmon dand wip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kiyk minim aŋgyak kun ak, gos nep niŋiy aŋgyak. Pol yikop Tropiymas yip, Gor aŋgniŋep korip maŋ okok taŋgek niŋiy mey aŋgyak, “Pol binak Tropiymas miñmon Yipiyses nimb ak yip, Gor aŋgniŋep korip miŋgan ak amimb aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kun aŋgey, minim kun ak biynimb okok maŋgiysek niŋiy, ap Pol nup di mis biyaŋ yokiy, kinjeŋ ak giñiyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","32","Giñiy, kilpul yomb aŋgyiŋg, Pol nup pisnep pikayniŋg rek giyak. Pen giyak minim kun ak, amiybi yomb yimb mindek ak amek, nuk binuk kuŋaynep poŋind kasek apchakeyak niŋiy, Pol nup pikayniŋg geyak ak kirgiyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Amiybi yomb kun ak apiy, Pol nup chichiy diy, binuk gok kuyip aŋgak “Nup sen omiŋal ayñinimimb aŋgak.” Aŋgek, aŋgak rek geyak, biynimb mindeyak gok kuyip aŋgak, “Nuk tap yergamb nup kun gispim?” ");
INSERT INTO kmh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Aŋgek, kiyk minim keykey aŋgey, kilpul yomb yimb gak. Kun gek amiybi yomb ak, binuk gok kuyip aŋgek, Pol nup dand korip yomb kiyk ak amniŋg; ");
INSERT INTO kmh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","dand korip kinjeŋrumb gol siŋak amjakyakniŋ, biynimb kuŋaynep kisen giy, Pol nup timey giniŋg nep giyak. Kun giyak rek, amiybi gok nup di wanjrem ar ak ay, dand amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pen biynimb kun gok, Pol nup aŋgyak, “Nup pisnep pikayim! Nup pisnep pikayim aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kun aŋgyak ak pen; amiybi gok Pol nup dand korip miŋgan biyaŋ amniŋg giyakniŋ, nuk Griyk minim aŋgiy, amiybi yomb yimb anup aŋgak, “Yand minim nip bap aŋgnim akaŋ?” Aŋgek, amiybi yomb yimb ak aŋgak, “Nand Griyk minim niŋban sek? ");
INSERT INTO kmh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Yand aŋgniŋbiyn-eŋ, nand mey, bi Yijip nimb; bi penpen gipay kuŋay yimb diy, dam miñmon nep okok, weygey mindeyak bi anep aŋgniŋbiyn. Pen nand Griyk minim ak aspan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Aŋgek, Pol aŋgak, “Yand bi Jiwda bap. Yip tikyak, miñmon yomb Tasas Siyliysiya propens. Pen yip yaw aŋgenimin, yand biynimb guniy kuyip minim aŋgnim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Aŋgek, amiybi yomb yimb ak, yaw kun ginimin aŋgek, Pol korip ak yirar rek giy tawind tapay ar ak taw mindiy, ñin dand aranek, biynimb gok minim ma aŋgyakniŋ; nuk Hiybriw minim aŋgiy kuyip minim aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol nuk kuyip kun giy, Hiybriw minim aŋgiy aŋgak, “Bapiy sikop diy, mam sikop diy, nimb minim aŋgniŋg gispiyn ak niŋmindenimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kun aŋgek, minim minim aŋgiy mer, kapkap yimb mindyakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","kuyip aŋgak, “Yand Jiwda nimb ak pen, yip tikyak miñmon yomb Tasas Siyliysiya propens. Pen yand ap Jerusalem biy, tiysa Gameliyel yip mindiy, yomb ginik ak mey, apis basind sikop yerip yerip aŋgyak minim ak maŋgiysek, yip aŋgñek niŋnik. Kun ak, nimb Gor nup direp gun aŋgiy, kilrimey nep gipim rek, yand kunep giyiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Biynimb Jiysis nup gosimb niŋyak gok kuyip, timey yimb giyiŋgipiyn. Kuyip pik ayin aŋgiy, biynimb gok monmon miñ ay, dand kalambis amyiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","“Giyiŋgipiyn kun ak, biyomb Gor nup simboŋgep gok sek, bi kanjsol gok sek aŋgniŋem, kiyk yesek aŋgip ma aŋgniŋgambay; niŋind aŋgip aŋgniŋgambay. Biyomb kun gok, yand Damaskas amniŋg genik, yip minj gunap tikñiyak. Minj kun ak tikiy aŋgyak, ‘Pol nup kondenimimb; nuk Damaskas biynimb Jiysis nup gosimb niŋbay gok kuyip miñ ay, dand Jerusalem biy winimuŋ aŋgyak.’ Pen yand minj kun ak diy kuyip miñ ay, dand Jerusalem apen, gos niŋniŋgambay aŋgnik. ");
INSERT INTO kmh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Pen yand minj kun gok bi gunap yip dand am am, pumbnamb yoŋ won ak, Damaskas maŋ maŋ ginukniŋ, melik yomb ak, semb ar biyoŋ nimb añiñak rek diy owak. ");
INSERT INTO kmh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kun gek, yand apyap piknikniŋ, minim bap yip aŋgak, ‘Sol! Sol! Yip yenen per timey gipan?’ ");
INSERT INTO kmh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Aŋgek, yand aŋgnik, ‘Biyomb! Nand an?’ “Aŋgenik, ‘Yand bi Jiysis Nasaret nimb: yip per timey gipan anep aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“Bi yand yip amonuk gok, melik yomb ak niŋyak ak pen; minim maŋgiy ak ma niŋyak. ");
INSERT INTO kmh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yand pen aŋgnik, ‘Biyomb. Yerginim?’ “Aŋgenik, yip aŋgak, ‘Tikjakiy, Damaskas amiy, Gor nup yerer giniŋgamban ak, nip aŋgniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Melik kun ak, yomb yimb giy, windin yip ak pisnep koy gek, niŋnim rek ma ayak. Kun gek, bi yand yip amninuk gok, yip ñin kind ak diy, dand Damaskas amniyak. ");
INSERT INTO kmh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Pen Damaskas bi bap mindek. Yimb nuk ak Ananayas. Nuk Gor minim ak niŋrep giy, minim chin yerip yerip mindip ak niŋrep yimb giy gak. Bi kun anup, Jiwda biynimb Damaskas mindeyak gok, maŋgiysek aŋgyak, ‘Ak bi tep yimb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Pen nuk, yand mindenik maŋ siŋak apiy aŋgak, ‘Mam Pol, windin tip niŋan aŋgak.’ Kun aŋgakniŋ, windin yip koy gak ak, pisnep suŋ ayakniŋ, nup niŋnik. ");
INSERT INTO kmh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yip aŋgak, ‘Gor Biyomb, basind apis sikop aŋgniŋyiŋgipay ak, nip diy woŋg nuk ak ayniŋg gisap ak mey, Ñinuk Krays nup miseŋ niŋiy, minim nuk ak miseŋ niŋiy gipan. ");
INSERT INTO kmh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nip yerer gamb niŋban kun ak, biynimb gok kuyip aŋgñiniŋgamban. ");
INSERT INTO kmh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kun ak ma kond mindenimin; tikjakiy Gor nup aŋgniŋiy, ñiŋg pikeniŋgamban; timey gipan gach ak, Gor wiykyokniŋgamb aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Kun aŋgek, aŋgak rek nep ginik. Kisen miñmon Jerusalem biy apiy, Gor aŋgniŋep korip ak amiy, Gor nup aŋgniŋ mindiy, day niŋnik ak: ");
INSERT INTO kmh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jiysis yip aŋgak, ‘Kasek Jerusalem kirgiy, miñmon key okok amnimin. Biynimb guniy minim tep yip ak aŋgeniŋgamban, ma niŋniŋgambay aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Kun aŋgek, yand aŋgnik, ‘Biyomb. Kiyk key yip niŋbay; yand nind nan-gep korip okok amiy, biynimb nip gosimb niŋyak gok kuyip kalambis ay, takiy nep pikyiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pen ñin bap, bi minim tep nip aŋgep Stiypin nup pikayakniŋ, panj aŋgiy, bi nup pikeyak gok chech kiyk tuŋgasik ayak gok kond mindenik aŋgnik.’ ");
INSERT INTO kmh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kun aŋgenik, Biyomb ak yip aŋgak, ‘Yand nip aŋgyoken, am Jiwda mer gok kuyip, minim aŋgñiniŋgamban aŋgak.’” ");
INSERT INTO kmh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Jiwda biynimb, Pol minim aŋgak ak niŋmind dand amiy, minim kun ak aŋgek niŋiy, kiyk minim yomb yimb aŋgiy aŋgyak, “Bi kun ak rek ma mindenimuŋ; nuk Gor nup aŋgjiwsap rek, nup pisnep pikayep aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kun aŋgyiŋg, chech yomb kiyk gok tuŋgasik yokiy, silkul gok yipruŋg diŋgey aranak. ");
INSERT INTO kmh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kun geyak, amiybi yomb yimb ak, binuk gunap kuyip aŋgak, “Nup dand korip miŋgan amiy, pikenimimb, biynimb guniy yenen nup minim yomb aspay kiñiŋ ak, nimbip aŋgnimuŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kun aŋgek, nup pikniŋg, dand amiy miñ tiwniŋg ayak. Pen Pol amiybi yomb yep maŋ kun siŋak jak mindek anup aŋgak, “Chin Rom biynimb low bap kun giy mindip? Bi Rom nimb yipund giy gok kuyip kor ma giy, monmon pikpay sek?” ");
INSERT INTO kmh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pol kun aŋgek, amiybi yomb kun ak, amiybi yomb yimb anup aŋgak, “Nand yerginiŋg gispan? Bi kun ak nuk Rom yipund giy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kun aŋgek, amiybi yomb yimb ak apiy, Pol nup aŋgak, “Nand Rom nimb yipund giy akaŋ, yip aŋgey niŋiyn?” Aŋgek, Pol aŋgak, “Yaw. Yand Rom nimb yipund giy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Aŋgek, amiybi yomb yimb ak aŋgak, “Yand maniy yomb yimb ak yokiy mey, Rom bi mindpiyn aŋgak.” Aŋgek, Pol pen aŋgak, “Rom kay yip tikyak ak mey, yand Rom bi mindpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kun aŋgek, bi nup miñ ayak gok pirikyak. Amiybi yomb yimb ak, bi biy Rom nimb ak pen; nup miñ aypiyn aŋgiy, kunep pirikak. ");
INSERT INTO kmh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Minek pen, amiybi yomb yimb ak, Jiwda kay Pol nup minim yerip aspay ak niŋrep giyn aŋgiy, Gor nup simboŋgep yomb gok sek, bi Jiwda kanjsol gok sek maŋgiysek, suk aŋgek ap nan-geyak, aŋgek Pol nup am wisik dand apiy, mindeyak maŋ siŋak ayak. ");
INSERT INTO kmh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol nup kun giy wisik dap ayeyak; nuk Jiwda kanjsol kun gok kuyip niŋmindyiŋg aŋgak, “Mam sikop. Yand Gor aŋgip rek per gipiyn ak mey, gospar ayiŋg ma mindpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kun aŋgek, Ananayas Gor nup simboŋgep biyomb yimb ak, bi maŋ siŋak mindeyak gok kuyip aŋgak, “Minim yesek aŋgip joŋimb band, ak piktopil gim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kun aŋgek, nup pikeyak, Pol nuk biyomb kun anup aŋgak, “Biynimb gok nip niŋey, bi tep rek mindpan ak pen; gos timund nak ak, timey yimb niŋban. Kun gipan kun ak, Gor nip pen pikniŋgamb. Chin Jiwda gipun rek niŋiy, yip kor gipan ak pen; Jiwda gipun ar ak kirgiy, ‘Nup monmon pikim apan’ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Pol kun aŋgek, bi maŋ siŋak mindeyak kun gok aŋgyak, “Gor nup simboŋgep biyomb yimb anup aŋgjiwsipan?” ");
INSERT INTO kmh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Aŋgey, Pol aŋgak, “Mam sikop. Nuk Gor nup simboŋgep biyomb yimb aŋgiy ma niŋbiyn. Baybol buk ak tikiy aŋgyak, ‘Biyomb nimb gok kuyip ma aŋgjiwnimimb aŋgyak.’” ");
INSERT INTO kmh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Won kun ak Pol niŋak; bi kanjsol mindeyak kun gok, gunap Sanjiwsiy biynimb niŋbay rek niŋyak, gunap Peresiy biynimb niŋbay rek niŋyak. Bi Sanjiwsiy gok gos kiyk ak niŋiy aŋgyiŋgipay, “Enjol gok ma mindpay. Kawnan ma mindip. Biynimb gok kumiy pisnep kumbay aŋgyiŋgipay.” Pol nuk layn keykey mindeyak kun ak niŋiy, minim yomb aŋgiy aŋgak, “Mam sikop. Basind apis yand gok maŋgiysek Peresiy biynimb: yand kunep Peresiy bap. Biynimb kumiy tikjakpay minim ak aŋgen, yip pen kor gispay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","10","Kun aŋgek, bi Sanjiwsiy kanjsol gok asik key ay, bi Peresiy kanjsol gok asik key ay, kilpul yomb aŋgyak. Aŋgeyak, Peresiy kay bi low tiysa kiyk gok, meŋg miŋgan dand araniy aŋgyak, “Bi biy tap timey bap gip aŋgiy, ma apun. Nuk Damaskas amnak ñin ak, Gor Kawnan ak akaŋ, enjol bap niŋak rek ayip; chin ma niŋbun aŋgyak.” Kun aŋgiy, penpen aŋg dand amniyakniŋ, amiybi yomb yimb ak niŋiy, mindak kun aŋg dand amiy, Pol nup tuŋgrik day day ayniŋgiy rek ayek niŋiy, amiybi nuk gok kuyip aŋgek, Pol nup poŋind dam korip kiyk yomb miŋgan ak ayak. ");
INSERT INTO kmh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pen ñin kun ak kisyimken biyaŋ, Jiysis ap Pol mindek siŋak jak mindiy aŋgak, “Gos sek mindenimin. Minim tep yand ak Jerusalem biy apan rek, Rom amiy, kunep aŋgnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Minek pen, Jiwda biynimb ñin jiwiy omiŋal rek ap nan-giy, minim aŋg ar nokom ay aŋgyak, “Chin Pol nup ma pikaypun won biy; tap ma ñimbiy, ñiŋg ma ñimbiy giniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kun aŋgiy, am Gor nup simboŋgep biyomb gok sek, bi kanjsol yikop gok sek kuyip aŋgyak, “Chin niŋind yimb apun. Tap ma ñiŋniŋgambun: Pol nup pisnep pik ay mey, kisen tap ñiŋniŋgambun. ");
INSERT INTO kmh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kun ak nimb, amiybi yomb anup minim yokiy, yesek aŋgiy aŋgnimimb, ‘Pol nup dand biy apey, nup minim gunap sek aŋgniŋ tep ginjun aŋgnimimb.’ Yesek kun aŋgem mey, chin ñiluk ay mindoniŋgambun; apeniŋgamb, pisnep pikayniŋgambun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pen Pol nunay ñinuk ak, Pol nup pikayniŋg giyak minim kun ak niŋiy, numbap Pol nup dam ayak korip ak amiy, aŋgñak. ");
INSERT INTO kmh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Aŋgñek, Pol niŋiy, amiybi kuyip kond mindep bi bap nup aŋgak, “Bi paranj biy, minim bap mindip. Nup poŋind amiybi yomb yimb mindip ak amey, minim kun ak aŋgaŋ aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Aŋgek, nunay ñinuk kun anup poŋind amiybi yomb yimb mindek ak amiy aŋgak, “Pol kalambis bi ak aŋgip, ‘Bi paranj biy minim bap mindip nen, nup poŋind dand, biyomb yimb ak mindip amey, minim kun ak aŋgnimuŋ aŋgek;’ poŋind aswiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kun aŋgek, amiybi yomb yimb ak, ñi kun anup ñin kind ak diy, poŋind gol okok amiy aŋgak, “Yip minim aŋgniŋg apan kun ak, aŋgan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Aŋgek, ñi paranj kun ak aŋgak, “Jiwda biynimb gok toy nip minim yokiy, yesek aŋgniŋgambay, ‘Pol nup dand kanjsol mindpay ak apenimin, minim gunap sek aŋgniŋrep ginjun aŋgniŋgambay.’ ");
INSERT INTO kmh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kun ak minim kiy aŋgniŋgiy ak, ma niŋnimin. Bi kiyk ñin jiwiy omiŋal rek, Pol nup ñaŋg ay nep mey, tap ñiŋniŋgambun aŋgiy, minim aŋgaypay. Kiyk minim nip ak niŋiy, kun ginjun aŋgiy kond mindpay aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kun aŋgek, amiybi yomb yimb ak niŋiy, nup aŋgyokyiŋg aŋgak, “Biynimb gunap kuyip niŋiy, amiybi yomb yimb anup, kun kun giy aŋgiy aswiyn ma aŋgnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Amiybi yomb yimb ak kun aŋgiy, amiybi kond mindep nuk omiŋal ak suk aŋgek aper aŋgak, “Pol nup pik ayniŋg minim aspay. Kun ak miñiy kisyimnamb biyaŋ, nup poŋind dand Siysariya amnimimb. Bi kusay diniŋgiy gok, ñin jiwiy onep wanjrem ak diy, amiybi gok, ñin jiwiy onep wanjrem ak diy, kanj hos sek diniŋgiy gok, ñin jiwiy omiŋal nokom, andikiy onep wanjrem ak diy dand amnimimb. ");
INSERT INTO kmh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pol nup hos gunap sek di namb ay, poŋind dam, gapman biyomb Piyliyks mindip ak yokiy winimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kun aŋgiy, nuk biyomb Piyliyks nup minj bap tikiy aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Yand Kilodiyas Liysiyas; nip gapman biyomb Piyliyks minj tiksipiyn. ‘Nand mindpan?’ ");
INSERT INTO kmh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bi nip yoksipiyn biy, Jiwda biynimb pikayniŋg gey, yand niŋnik: nuk bi Rom nimb ak niŋiy mey, amiybi yand gunap yip amiy, nup dand winuk. ");
INSERT INTO kmh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Dand apiy, nup pikniŋg giyak minim kiñiŋ kun ak niŋiyn aŋgiy, nup dand kanjsol miytiyŋ kiyk ak amiy niŋnik: ");
INSERT INTO kmh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Jiwda biynimb kiyk gipay rek minim ar gunap nep mindek. Pen nuk tap gunap gek, nup pisnep pik ayep akaŋ, kalambis ayep minim kiñiŋ bap ma mindek. ");
INSERT INTO kmh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pen minim bap apay, ‘Bi kun anup ñiluk ay mindiy ñaŋgniŋgambun aŋgey’ mey, nand mindpan ak yoksipiyn. Bi nup minim aspay kun gok, kunep aŋgyoken amiy, minim kiñiŋ kun ak nip aŋgniŋgambay. Tep.” ");
INSERT INTO kmh_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Amiybi yomb yimb ak kun aŋgiy, minj tikñek; amiybi gok, Pol nup kisyim biyaŋ nep poŋind am am, Antiypatriys amjakyak. ");
INSERT INTO kmh_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Minek, amiybi yikop gok maŋgiysek andkind korip wiyak. Amiybi kanj hos sek gok nep, Pol nup dand Sisariya amiy, ");
INSERT INTO kmh_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","gapman biyomb anup minj ñiy aŋgyak, “Kalambis bi dand opun biy, yimb nuk Pol aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Biyomb ak nuk minj riytiym giniŋgiy, Pol nup aŋgak, “Nand propens akay nimb?” Aŋgek, Pol aŋgak, “Propens yand Siyliysiya aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Kun aŋgek, biyomb ak niŋiy nup aŋgak, “Bi nip minim apay gok apey, minim aŋgniŋgambun aŋgak.” Kun aŋgiy, binuk gunap kuyip aŋgak, “Nup dam gapman biyomb Herot korip ak ay, kond mindrep ginimimb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pol nup kun giy dam ayey, ñin onep tiŋgawip ak mindek. Minek mamind ak, Gor nup simboŋgep biyomb yimb Ananayas, Siysariya amniŋg, Jiwda kanjsol kiyk gunap poŋind, bi minim aŋgep kiyk Tetiwlas yip, Siysariya amniyak. Amiy, gapman biyomb Piyliyks nup niŋiy aŋgyak, “Pol nup kor gun aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kun aŋgeyak, gapman biyomb ak, Pol nup aŋgek apek, bi minim aŋgep Tetiwlas, Pol nup kor giniŋg, gapman biyomb Piyliyks nup aŋgak, “Nand mey, gos niŋrep giy chinup kond mindey mindrep gipun. ");
INSERT INTO kmh_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Gipan kun ak, chin nip tep yimb apun. ");
INSERT INTO kmh_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nip minim paryomb ma aŋgniŋgayn; minim maŋ won aŋgniŋg gispiyn ak, timund pik niŋnimin. ");
INSERT INTO kmh_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Chin niŋbun: bi kun biy per timey nep gip. Miñmon akay akay amimb okok, Jiwda kay kuyip tuŋgasik keykey ayakniŋ, pernep penpen gipay. Biynimb Jiysis bi Nasaret nimb anup gosimb niŋbay gok, biyomb kiyk mey kun ak. ");
INSERT INTO kmh_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Nuk Gor aŋgniŋep korip chinup ak kunep gek timey ginimuŋ rek ayek mey, nup diy, tap chinup gip kun ak kor giniŋg gonuk, amiybi yomb yimb Laysiyas, kaljiw apiy, ");
INSERT INTO kmh_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","nup dand amiy aŋgak, ‘Bi nup kor giniŋg gipay gok, biyomb Piyliyks mindip ak amiy, kor giniŋgiy aŋgak.’ Kun aŋgek mey, miñiy opun. Minim kun ak, Pol nup aŋgniŋeniŋgamban, nuk key, nup kor gipun minim kiñiŋ ak aŋgek, niŋniŋgamban.” ");
INSERT INTO kmh_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tetiwlas kun aŋgek, bi Jiwda ap mindeyak gok, minim nup ak kindik giy aŋgyak, “Niŋind yimb aŋgip aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gapman biyomb ak, Pol nup minim aŋgan aŋgek, Pol aŋgak, “Nand simiy kuŋaynep miñmon biy kond mindiy, niŋrep gipan rek, yipund giy nep aŋgniŋgamban. Kun ak mey, yip tep gakniŋ nip minim aspiyn. ");
INSERT INTO kmh_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yip Jerusalem per giraŋgip aŋgey ma niŋniŋgamban; yand Gor nup aŋgniŋiyn aŋgiy, menikarik siŋbiy nep, Gor aŋgniŋep korip ak amninik. ");
INSERT INTO kmh_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Yand biynimb gunap diy Gor aŋgniŋep korip ak akaŋ, Jiwda nan-gep korip okok akaŋ, dawin yomb namb okok akaŋ; simbwur timey gep rek minim gunap ma aŋgnik. ");
INSERT INTO kmh_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Yip miñiy kor gispay ak, nand niŋniŋgamban; minim kiñiŋ bap ma mindeniŋgamb. ");
INSERT INTO kmh_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Pen nip minim bap miseŋ aŋgniŋg gispiyn. Yip apay ‘Pol chin Jiwda gunap gipun rek ma gip. Nuk Jiysis nup kisen giyiŋg, Gor nup aŋgniŋimb apay.’ Minim kun ak niŋind apay. Yand Jiysis binuk yimb ak mey, kun gipiyn. Apis basind sikop Gor aŋgniŋyiŋgipay anep, yand aŋgniŋbiyn. Bi Gor minim aŋgep gok, minim tikyak ak ma kirpiyn. ");
INSERT INTO kmh_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","16","Jiwda gunap, ‘Biynimb tep gok sek, biynimb timey gok sek maŋgiysek, kumiy tikjakniŋgambay aŋgiy niŋbay rek ak’ yand kunep niŋbiyn. Gor yip am mindeniŋgambiyn aŋgiy, monmon ma gipiyn. Gor niŋiy akaŋ, biynimb gok niŋiy, sisker gip aŋgniŋgambay ak niŋiy mey, niŋrep giy, mindrep gipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Pen yand simiy gunap, miñmon okok taŋgiy, biynimb yand tap ma mindip gok kuyip maniy ñiy, Gor nup tap simboŋg ñiyn aŋgiy, Jerusalem amninik. ");
INSERT INTO kmh_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Amiy, Gor nup tap simboŋg ñiyn aŋgiy, ñiŋg pikrep giy, Gor aŋgniŋep korip ak am mindenik. Pen biynimb kuŋay ma ap mindeyak ak mey, penpen aŋgep rek minim gunap ma aŋgnik. ");
INSERT INTO kmh_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","“Pen Jiwda biynimb Esiya nimb gok, ap yesek aŋgiy, yip diyak. Minim kiyk mindombikop ak, biy apiy minim kun ak apyap. ");
INSERT INTO kmh_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ma opay ak, bi kanjsol guniy, yip Jerusalem biy kor giy, timey gen minim kiñiŋ niŋyak ak, aŋgey niŋnimin! ");
INSERT INTO kmh_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Pen yip kor giyak ñin ak, minim nokom bap nep aŋgnik. Meŋg miŋgan dand araniy aŋgnik, ‘Yand biynimb kumiy tikjakpay aŋgiy gos anep niŋen, yip kor gispim aŋgnik.’” ");
INSERT INTO kmh_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pol kun aŋgakniŋ, gapman biyomb Piyliyks, biynimb Jiysis nup gosimb niŋyiŋgipay gok per girep gey niŋak ak mey, Jiwda biynimb minim ar kuyip ak ma diy aŋgak, “Kisen amiybi yomb yimb Liysiyas apek, minim nup ak niŋiy, minim kun ak aŋgniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kun aŋgiy, bi kalambis kay kuyip kond mindep anup aŋgak, “Pol nup miñ ay, kond mindrep ginimin. Pen nup pisnep miñ wos ma aynimin; nuk tap gunap ma mindek, biynimb nuk gok kuyip aŋgniŋek, nup ñiniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kisen minek bap, Piyliyks biynuk Driwsiyla yip, Pol nup niŋniŋg wirik. Biyn Driwsiyla kun ak, nuk Jiwda biyn bap. Pen kiyber apiy, nuŋgumiy Pol nup suk aŋgek apek, Pol nuk Jiysis nup yergiy chiŋgipay minim ak aŋg dand amyiŋg aŋgak, ");
INSERT INTO kmh_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","“Gos chin ar ak key ma niŋjun, Gor aŋgip rek niŋiy, mindrep ginjun. Mer ak kor yomb ak niŋniŋgambun aŋgak.” Kun aŋgek, gapman biyomb Piyliyks minim kun ak niŋiy pirikiy, jep di giy, Pol nup aŋgak, “Nand miñiy am mindenimin; kisen yikop mindiy ker nip suk aŋgen winimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pen biyomb kun ak, gos nuk okok nep niŋiy aŋgak, yand Pol nup minek minek suk aŋgen apek mey, gos nuk ak niŋiy aŋgniŋgamb, ‘Yand nup kapkap maniy ñiy amniyn aŋgiy, yip maniy ñiniŋgamb aŋgak. Pen gos kun ak niŋak rek, Pol nup minek minek suk aŋgek apek, minim aŋgyiŋgipiyr.” ");
INSERT INTO kmh_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pen Piyliyks, Pol nup yikop wisik yoknim aŋgiy niŋak ak pen; Jiwda biynimb yip yiruk niŋniŋgambay aŋgiy kirgak. Pol kalambis nep mindek, simiy omiŋal yinakniŋ, binak Posiyas Pestas, Piyliyks tip nup ak diy, Siysariya propens ak kond mindek. ");
INSERT INTO kmh_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pen biyomb Pestas, Siysariya apiy, ñin omiŋal nokom mindiy, Jerusalem amnakniŋ, ");
INSERT INTO kmh_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Gor nup simboŋgep biyomb gok sek, Jiwda biyomb gunap sek nup niŋiy; Pol nup kinjeŋnamb ak ñiluk ay pikayniŋg aŋgyak, “Chinup simb niŋiy, bi nand gunap aŋgenimin, Pol nup kasek dand Jerusalem winiŋgiy aŋgyak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kun aŋgeyak, Pestas aŋgak, “Pol kalambis mindip Siysariya. Kun ak, yand amniŋg gispiyn rek, ");
INSERT INTO kmh_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","nup minim gunap mindonimuŋ, biyomb nimb gunap aŋgem, yand yip Siysariya amiy, nup kor giniŋgiy aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Kun aŋgiy, nuk ñin kaw bap mindiy, biyomb kiyk gunap Pestas yip Siysariya amniyak. Minek, kor gep miŋgan ak amiy, Pestas aŋgek, ");
INSERT INTO kmh_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol nup dand apeyak, Jiwda bi Jerusalem nimb wiyak gok ap nup piŋiy kus kus giy, minim ar keykey kuŋaynep aŋgyak. Pen minim aŋgyak ar kun gok, minim kiñiŋ mindek ma aŋgyak; yesek nep aŋgyak. ");
INSERT INTO kmh_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pen Pol tikjakiy aŋgak, “Yand Jiwda biynimb minim ar ak akaŋ, Gor aŋgniŋep korip minim ar ak akaŋ, Rom biyomb Siysa low minim nup ar ak, ma timbrikpiyn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Aŋgek, biyomb Pestas gos nuk ak key niŋiy aŋgak, “Pol nup Jerusalem yoken, Jiwda biynimb yip niŋey tep giniŋgamb aŋgiy,” Pol nup aŋgniŋiy aŋgak, “Kor minim kun biy, Jerusalem amiy aŋgjun?” ");
INSERT INTO kmh_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Aŋgek Pol aŋgak, “Miñiy Rom biyomb Siysa kor ar nuk ak mindpiyn. Yenen Jerusalem amiy aŋgjun? Yand Jiwda biynimb kuyip tap bap ma yimb gipiyn ak, nand kunep niŋban. ");
INSERT INTO kmh_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Pen tap bap gen, kor giy yip pikayun apyap ak; ma pirikpinip. Ak yip monmon pikpiyap. Pen kor giy, minim kiñiŋ ma mindip ak, yip Jiwda biynimb kuyip ñiniŋg gispan ak, yipund ma gip. Rom biyomb yimb Siysa, low nuk bap kun giy ma mindip. Kun ak yand biyomb Siysa mindip ak amiy, minim kun biy aŋgniŋgayn. Pen yand Jerusalem ma amniŋgayn aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pol kun aŋgek, biyomb Pestas am binuk gok yip minim kun ak aŋg amiy apiy giy, andkind apiy aŋgak, “Biyomb Siysa kor yip ak niŋniŋgamb apan ak mey, nip Siysa mindip Rom aŋgyokon, kor kun ak giniŋgamban aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","14","Pen ñin bap, kiyŋ Aŋgriypa yip, nunay nuk Baniys yip aŋgrik, “Binak Pestas miñiy ap biynimb kond mindip Siysariya. Chir am nup niŋiy owiyr aŋgrik.” Kun aŋgiy, Siysariya amiy, Pestas yip ñin kaw bap mindyiŋg; Pestas kiyŋ Aŋgriypa nup aŋgak, “Yand kisen winik; nind Piyliyks miñmon biy kond mindek ñin ak, bi Pol apay anup, kor giyak ak mey, kor giniŋg ap kond mindip biy. ");
INSERT INTO kmh_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yand Jerusalem amenik, Gor nup simboŋgep biyomb gok sek, bi Jiwda kanjsol gok sek maŋgiysek aŋgyak, ‘Pol nup pikaynimimb aŋgyak.’ ");
INSERT INTO kmh_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Pen minim kiñiŋ bap ma aŋgeyak kuyip aŋgnik, ‘Chin Rom biynimb low bap kun giy ma mindip. Biynimb yikop ma pikpun; kor giy, minim junj bap mindamb nep mey, kun gipun aŋgnik.’ ");
INSERT INTO kmh_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kun aŋgiy, yand yip Jerusalem biy apiy, minek mey, am kor gipay korip miŋgan ak bisgiy, Pol nup suk aŋgen owak. ");
INSERT INTO kmh_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Yand aŋgniŋnik-eŋ, minim yomb yimb mindip aŋgnik ak pen, bi nup kor giyak gok, minim aŋgyakniŋ niŋnik; minim yomb ma mindek. ");
INSERT INTO kmh_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kiyk yikop aŋgyak, ‘Gor minim ak, chin aŋgrep gipun rek ma aŋgip; nuk gunap sisker aŋgip aŋgyak.’ Bi bap yimb nuk Jiysis aŋgyak ak kunep; kiyk pisnep kumimb aŋgyak’ ak pen; Pol aŋgak, ‘Miñiy tikjakiy kim mindip aŋgak.’ ");
INSERT INTO kmh_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Gor minim aŋgiy kor gipay ak, yand niŋrep ma gipiyn rek, nup aŋgnik, ‘Jerusalem amiy, minim kiñiŋ kun ak aŋgñiniŋgamban akaŋ aŋgenik,’ ");
INSERT INTO kmh_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","‘Mer! Yand kalambis nep mindeniŋgayn. Kisen Rom biyomb yimb Siysa, nuk key minim kun ak aŋgniŋgamb aŋgak.’ Kun aŋgek, yand nup Siysa ker yokniŋg, kalambis aypiyn rek mindip aŋgnik.” ");
INSERT INTO kmh_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Pestas kun aŋgek, kiyŋ Aŋgriypa aŋgak, “Pestas. Bi kun ak minim nuk key aŋgek, yand niŋniŋgayn aŋgak.” Aŋgek aŋgak, “Kun ak toy niŋnimin aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kun aŋgek, minek, Aŋgriypa nunay Baniys yip, chech tep tep nep ay, amiybi yomb gunap, biyomb miñmon kun ak nimb gunap yip wilikiy, biynimb yomb aswun aŋgiy, yiñrimey giyiŋg, kor niŋep korip miŋgan ak wiyak. Ap mindyakniŋ, Pestas bi gunap kuyip aŋgak, “Pol nup am dand owim aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Aŋgek, dand apeyak, Pestas tikjakiy aŋgak, “Kiyŋ Aŋgriypa sek, biynimb ap mindpim guniy sek bi biy nup niŋim. Jiwda biynimb nup kor giy, minim yomb aŋgiy, bi kun biy pisnep pikayep apay. Jerusalem minden, yip kun anep apay; biy apen, kun anep apay. ");
INSERT INTO kmh_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Yand niŋbiyn: biynimb gok tap timey yimb gey, ñin gunap pikaypay ak pen, bi biy nup kor giy niŋnik: tap kun ak rek bap ma gak. Nuk key aŋgak, ‘Biyomb Siysa nep minim yip kun ak aŋgniŋgamb aŋgak.’ Kun ak mey, yand gos kun ak niŋiy, Siysa ker yokniŋg gispiyn. ");
INSERT INTO kmh_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Pen yand bi kun biy tap yerip yerip gip minim kiñiŋ ak, minj sek tikñinim rek ma ayip. Kun ak, kiyŋ Aŋgriypa sek, biynimb yikop gok sek nimb minim nup ak niŋiy, tap gunap yerip yerip gip ak aŋgem, minj sek tikiy, biyomb Siysa mindip ak yoknim. ");
INSERT INTO kmh_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Yikop yokniŋgambiyn ak, yand niŋen yipund ma giniŋgamb aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Pen kiyŋ Aŋgriypa Pol nup aŋgak, “Yand nip niŋsipiyn nen, minim aŋgan aŋgak.” ");
INSERT INTO kmh_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Aŋgek, Pol ñin dand araniy aŋgak, “Kiyŋ Aŋgriypa. Nand nep apiy yip minim aŋgnimin aŋgey, Jiwda biynimb minim yip apay ak, nip aŋgniŋg gispiyn ak; yip tep gip. ");
INSERT INTO kmh_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Chin Jiwda biynimb gipun gipun ar ak nand maŋgiysek niŋban ak mey; nip nep aŋgniŋg gispiyn ak, yip tep gip. Kun ak minim aŋgen, yip yiruk ma niŋnimin. ");
INSERT INTO kmh_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","6","“Jiwda biynimb Jerusalem nimb gok, yip kor gispay ak; Gor wosrey basind apis sikop kuyip minim tep aŋgek, gos sek kond mindyiŋgipay minim anep aŋgen, yip kor gispay. Pen yand bi key okok nimb rek, minim bap key aŋgnim: yand bi key okok nimb mer; bi Peresiy, Jiwda low minim niŋiy, asik tep yimb gipiyn bap. Ñiskoy miŋg mindiy, mind dand apiy, miñiy mindpiyn ñin biy, miñmon yand Tasas nimb, Jerusalem nimb gipiyn. Kun ak yip Peresiy aŋgiy niŋbay ak pen, minim kun ak weygiy, yip kor gispay. ");
INSERT INTO kmh_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","“Nand niŋban: ‘Chin Jiwda biynimb gok kiñiŋ keykey onep wimiŋgan ak mindpun. Chin maŋgiysek, Gor basind apis sikop kuyip aŋgak minim tep ak kond mindpun. Nuk biynimb kumbay gok, gen tikjakniŋgambay aŋgak minim ak niŋmindiy, pumbnamb kisyimken, nup aŋgniŋyiŋg mindpun. Pen kiyŋ Aŋgriypa nand niŋan! Kumiy tip tikjakniŋgambun minim anep aŋgen, yip kor gipay! ");
INSERT INTO kmh_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Pen nimb yenen biynimb kumbay gok, Gor gek ma tikjakniŋgambay aŋgiy niŋbim? ");
INSERT INTO kmh_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Pen yand key, nind Jiysis Nasaret nimb minim ak, yipund ma gip aŋgiy, Gor biynimb nuk gok kuyip, timey yimb giyiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Pen Jerusalem minden, Gor nup simboŋgep biyomb gok yip aŋgey, Jiysis ker mindeyak biynimb gok kuyip am dand apen, kalambis ayiŋgipay. Gunap pisnep pikayiŋgipay. Biynimb pikayiŋgipay gok kuyip panj aŋgyiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Jiwda nan-gep korip okok taŋgiy, biynimb Jiysis nup gosimb niŋyak gok kuyip niŋen, yip milukrimey yapek; minim kun ak kirginimimb aŋgiy, kuyip timey giyiŋgipiyn. Ñin gunap biynimb kun gok piyow niŋiyn aŋgiy, miñmon paryomb okok amyiŋgipiyn. ");
INSERT INTO kmh_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Pen ñin bap Damaskas biynimb Jiysis nup gosimb niŋyak gok kuyip, miñ ay dand wiyn aŋgen, Gor nup simboŋgep biyomb gok yaw aŋgiy, minj tikñey, dand saŋdinik. ");
INSERT INTO kmh_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Pumbnamb yomb yoŋ won ak, kinjeŋnamb ak amyiŋg niŋnik; melik yomb ak semb biyoŋ nimb, chin amninuk ak niŋak. Biyomb niŋan! Melik niŋak kun ak, pumb melik rek mer; melik kun ak key yimb gak. ");
INSERT INTO kmh_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kun gek, chin ma