﻿USE sofia;
DROP TABLE IF EXISTS sofia.kmh_m_vpl;
CREATE TABLE kmh_m_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kmh_m_vpl WRITE;
INSERT INTO kmh_m_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais nop nɨsed acɨk ne okok tɨkel tɨk amɨl apɨl gɨl nop tɨk dolak rek agnɨg gebin. Bɨ kɨb Ebraham tɨkek tɨk damɨl, kiŋ Depid nop tɨk dolak. Depid ne tɨkek tɨk damɨl, Jisas Krais nop tɨk dolak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nɨg gɨlak: Ebraham Aisak nop tɨk dowak. Aisak Jekop nop tɨk dowak. Jekop ne pen, Juda nop tɨkɨl, nɨmam kɨsen won ak umɨgan tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ne bin Dema eip mɨdɨl, Peres eip Sera eip kɨrop tɨk dowak. Peres, Hesron nop tɨk dowak. Hesron, Ram nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, Aminadap nop tɨk dowak. Aminadap, Nason nop tɨk dowak. Nason, Salmon nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Boas nop tɨk dowak. Boas nonɨm ne ak Rehap. Boas, Obed nop tɨk dowak. Obed, nonɨm ne ak Rut. Obed, Jesi nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi, kiŋ Depid nop tɨk dowak. Depid, Solomon nop tɨk dowak. Solomon nonɨm ne ak, ned bɨ nak Yuraia nop dek kɨmek, kɨsen Depid nop dɨl me, Solomon nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, Riaboam nop tɨk dowak. Riaboam, Abaija nop tɨk dowak. Abaija, Esa nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa, Jihosapat nop tɨk dowak. Jihosapat, Joram nop tɨk dowak. Joram, Asaia nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia, Jodam nop tɨk dowak. Jodam, Ehas nop tɨk dowak. Ehas, Hesekaia nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia, Manasa nop tɨk dowak. Manasa, Emos nop tɨk dowak. Emos, Josaia nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia, Jekonaia nop tɨk dapɨl, nɨmam ognap tɨk dowak. Ñɨn nɨbak, taun kɨb Babilon bin bɨ apɨl, Isrel bin bɨ kɨrop nag lɨ dam Babilon dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dad amelak, Jekonaia nɨb okok mɨdɨl, Sialtiel nop tɨk dowak. Isrel bin bɨ kɨri Babilon kɨrɨg gɨl karɨp lɨm Juda adɨk gɨ amnɨlak ak, Sialtiel, Serababel nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel, Abaiad nop tɨk dowak. Abaiad, Eliakim nop tɨk dowak. Eliakim, Eso nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso, Sedok nop tɨk dowak. Sedok, Ekim nop tɨk dowak. Ekim, Elaiad nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiad, Eliesa nop tɨk dowak. Eliesa, Matan nop tɨk dowak. Matan, Jekop nop tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop, Josep nop tɨk dowak. Josep me, bin Maria nop ñelak. Maria ne Jisas nop tɨk dowak. Jisas nop Krais apal. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nɨb ak me, based cɨn Ebraham ne tɨkek tɨkel tɨk dam dapɨl gɨl aknɨb wajrem pɨs adaŋ amnak ak, kɨsen based kiŋ Depid nop tɨk dolak. Tɨk dapel, Depid ne pen tɨkek tɨkel tɨk dam dapɨl gɨl ak rek nep wajrem pɨs adaŋ amek, kɨsen Babilon bɨ ke okok nɨb apɨl kɨrop nag lɨ dam karɨp lɨm kɨri ak dad amnɨlak. Dad amelak, kɨsen pen kauyaŋ tɨk dam dapɨl gɨl aknɨb wajrem pɨs adaŋ amnak ak, kɨsen Krais nop tɨk dolak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais nop tɨk dolak mɨnɨm ak agnɨg gebin. Jisas nonɨm Maria, Josep nop ñelak, ne eip ajɨl mer, kɨri nɨŋlak Maria ñɨ kogi mɨdek. Kaun Sɨŋ ne ak ke gek, ñɨ kogi nɨbak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pen nɨgmɨl ne Josep bɨ tep ak me, mɨnɨm kɨb ma agak; gos ak nep nɨŋɨl agak, “Ñɨ kogi mɨdeb nɨbak, bin bɨ okok ag ñɨnɨgain, nop nabɨŋ gɨnɨgab. Nɨb ak, kapkap ag yokin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep nɨg nɨŋak ak pen, kɨslɨm eyaŋ wɨsɨn nɨŋak, Bɨ Kɨb ejol ne alap nop agak, “Josep, Depid ñɨ ne! ‘Bin nɨbak, tari gɨnɨg dɨnɨm?’ agɨl, gos ak ma nɨŋnɨmɨn; abramek dɨnɨmɨn. Ñɨ kogi mɨdeb ak, Kaun Sɨŋ ak nep gek mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kɨsen ñɨ ak tɨk dapek ne kɨb gɨl, bin bɨ ne okok tap si tap tɨmel gɨpal gac ak lɨg gɨ yoknɨgab ak me, yɨb ne Jisas agnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nɨg gak nɨbak, Bɨ Kɨb ne bɨ mɨnɨm ne agep bɨ alap nop ag ñak nɨŋɨl ne pen nɨg gɨnɨgab agɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ne agak, “Bin praj bɨ alap eip ajɨl mer, ñɨ kogi mɨdɨl, ñɨ alap tɨk dapenɨgab, yɨb ne ak Emanyuel agnɨgal,” agak. Emanyuel mɨnɨm wagɨn ak, God cɨn eip mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pen Josep wɨsɨn kɨnɨl warɨkɨl, Bɨ Kɨb ejol ne mɨnɨm agak ak dɨl, bin Maria nop dɨnɨm, agɨl gos nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ned Josep Maria eip ajɨl mer, Maria ñɨ ak tɨk dapek, Josep ñɨ nɨbak yɨb ne Jisas agɨl me, Maria nop pɨs nep dak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pen Herod Judia Propins kiŋ mɨdolɨgɨp ñɨn ak, Maria Jisas nop tɨk dowak Betlehem taun, karɨp lɨm Judia nab sɨŋak. Tɨk dapek, bɨ gap kɨd yɨk nɨŋeb okok, pɨb apeb kɨd okok nɨb Jerusalem apɨl, bin bɨ okok kɨrop ag nɨŋɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda bin bɨ, Kiŋ cɨn, apɨm ak nop tɨk dopal! Mɨñi lɨpal mɨdeb akal? Cɨn karɨp lɨm cɨn pɨb apeb kɨd nɨb okok mɨdɨl nɨpɨn gap ak mɨseŋ lɨp; nɨŋɨl me, yɨb ne agon ar amnaŋ agɨl opɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nɨb agelak, kiŋ Herod mɨnɨm nɨbak nɨŋɨl, bin bɨ sɨŋ aul kɨri ñɨ nɨbak nop gos nɨŋɨl yɨp ma nɨŋnɨmel rek lɨp, agɨl, gos par nɨŋak. Jerusalem bin bɨ okok magɨlsek ak rek nep gos par nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pen kiŋ Herod, God nop tap sobok gep bɨ kɨb okok abe, God lo mɨnɨm ag ñeb bɨ okok abe, kɨrop sɨk agek apelak agak, “God mɨnɨm agep bɨ okok Krais nop tɨk donɨgal karɨp lɨm akal aglak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nɨb agek aglak, “Bɨ God mɨnɨm agep alap, bɨrarɨk nep mɨnɨm ñu kɨl tɨkɨl agak rek, nop tɨk donɨgal Betlehem taun, karɨp lɨm Judia nab sɨŋak. God mɨnɨm agep bɨ nɨbak God Mɨnɨm ñu kɨl tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Karɨp lɨm Judia nab okok karɨp lɨm ke ke koŋai mɨdeb ak me, karɨp lɨm Betlehem nɨŋek sɨkol rek lɨnɨgab ak pen Bɨ Kɨb ak karɨp lɨm nɨbak nɨb apɨl, bin bɨ yad Isrel bin bɨ okok kɨrop kod mɨdenɨgab. Nɨg gɨnɨgab rek, Betlehem yɨb kɨb mɨdenɨgab,’ agak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nɨb agelak, kiŋ Herod nɨŋɨl, am bɨ gos kɨd yɨk nɨŋeb okok kɨrop kapkap sɨk agek apelak agak, “Won akal rek gap nɨbak mɨseŋ lak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Agek, nop mɨnɨm nɨbak ag ñelak, kɨrop Betlehem ag yokɨl tom agɨl agak, “Nɨbi am ñɨ nɨbak pɨyo nɨŋ tep yɨb gɨl, adɨk gɨ apɨl yɨp agem, yad abe amɨl yɨb ne agen ar amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiŋ Herod nɨb agek, kɨri paŋdel nɨŋlɨg gɨ, gap kɨri pɨb apeb kɨd okok nɨb nɨŋlak ak ned ned gek nɨŋlɨg gɨ, kɨri kɨsen gɨlak. Gap ak amɨl amɨl, ñɨŋaŋ ak karɨp mɨdek nab sɨŋak alaŋ nep wös gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nɨg gek kɨri gap ak nɨŋel, tep gek nɨŋlɨg gɨ, mɨñ mɨñ yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Karɨp ñɨlɨk mɨgan eyaŋ amɨl nɨŋlak, ñɨŋaŋ ak nonɨm Maria eip mɨderek. Kɨri am kogɨm yɨmɨl, ñɨŋaŋ ak yɨb agel ar amek nɨŋlɨg gɨ, wad kɨri okok aŋ lɨl, nop tap tep ognap ñɨlak. Gol ognap, pauda ki tep owep ognap, wel ki tep owep ognap ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pen kɨri kɨslɨm nab eyaŋ kɨnɨl wɨsɨn nɨŋlak, God agak, “Adɨk gɨ Herod mɨdeb ak ma amnɨmɨb!” agak. Nɨb ak, agak rek nɨŋɨl, kanɨb par alap amɨl, karɨp kɨri adɨk gɨ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pen bɨ gos kɨd yɨk nɨŋeb okok kɨri nɨg gɨl amnɨlak nɨŋlɨg gɨ, Josep wɨsɨn nɨŋak, ejol alap apɨl nop agak, “Herod ñɨŋaŋ ak ñag pak lɨnɨm agɨl, pɨyo nɨŋnɨg geb. Nɨb ak, ñɨŋaŋ amɨl mal kɨrop kasek poŋɨd dɨl, pɨrɨk gɨ karɨp lɨm Ijip amnɨmɨn. Onɨmɨn agenɨm nep, kauyaŋ adɨk gɨ onɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Agek, Josep kɨslɨm nab eyaŋ nep warɨkɨl, ñɨŋaŋ amɨl mal poŋ dɨl karɨp lɨm Ijip dad amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Poŋ dɨl amnak nɨbak, Bɨ Kɨb ne bɨ mɨnɨm ne agep alap nop ag ñak nɨŋɨl ne pen ñu kɨl tɨkɨl agak, “Ñɨ yad ak Ijip nɨb sɨk agen owɨp,” agak. Pen Josep amɨlgon am Ijip nep mɨdel, Herod kɨmek me, kɨsen kauyaŋ adɨk gɨ olak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pen Herod ne nɨŋak, bɨ gos kɨd yɨk nɨŋeb okok, ne agak rek ma gelak, nop mɨlɨk kal yɨb yapek agak, “Yɨp gɨpal nɨbak, ñɨŋaŋ bɨ kɨb mɨdenɨgab ak yad ti gɨl nop ñag pak lɨnɨm?” agɨl gos nɨŋak. Pen ne gos alap nɨŋɨl agak, “Bɨ gos kɨd yɨk nɨŋeb okok kɨrop gap ak mɨseŋ lak ñɨn ak, yɨp ag tep gɨl amnɨlak. Nɨb ak yad nɨpin, Betlehem ulep sɨŋak ñɨŋaŋ tɨk dapel, mɨ omal yowɨp okok abe, ñɨŋaŋ kɨsen tɨk dopal okok abe, ñag pak lɨnɨgal ak, ñɨ nɨbak abe ñag pak lɨnɨgal,” agak. Nɨb agɨl me, bɨ ne ognap ag yokek amɨl, ñɨŋaŋ Betlehem ulep sɨŋak okok mɨdelak magɨlsek ñag pak lɨ saklak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Betlehem ñɨŋaŋ ñag pak lɨlak nɨbak, bɨ God mɨnɨm agep Jeremaia gɨnɨgab agɨl ñu kɨl tɨkak rek nep gɨlak. Jeremaia mɨnɨm nɨbak ñu kɨl tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama taun sɨŋak cɨb gek, mɨnɨm saköl kɨb agɨl, sɨl kɨb agnɨgal. Bin Resel tɨkek, tɨkel tɨk amɨl apɨl gɨnɨgab okok, mapɨn gek sɨl agnɨgal. Ñɨ ne kɨm saknɨgal nɨŋɨl bin bɨ ognap kɨrop ag dɨnɨmel rek ma lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pen sain bɨ kɨb Herod kɨmek, Josep Ijip okok mɨdɨl kɨnɨl wɨsɨn nɨŋak, Bɨ Kɨb ejol ne alap apɨl nop agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bɨ ñɨŋaŋ ñag pak lɨnɨg gelak okok bɨr kɨmbal ak me, bin nak amɨl mal kɨrop poŋ dɨl, adɨk gɨ karɨp lɨm Isrel amnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Agek, Josep ñɨŋaŋ amɨl mal poŋ dɨl, adɨk gɨ Isrel amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pen amjakek, mɨnɨm alap aglak, “Herod kɨmek, ñɨ ne Akeleas Judia Propins bin bɨ kɨrop kod mɨdeb,” aglak. Agelak, Josep ne Akeleas mɨdeb karɨp lɨm nɨbak tari gɨnɨg amnɨm agɨl, pɨrɨkak ak pen, kɨnɨl wɨsɨn nɨŋak God nop agak, “Nak karɨp lɨm Judia ma adɨk gɨ amnɨmɨn, karɨp lɨm Galili amnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Agek, Josep ñɨŋaŋ amɨl mal kɨrop poŋ dɨl Nasaret taun amɨl mɨdelɨgɨpal. Amnɨlak nɨbak, bɨ God mɨnɨm agep okok nɨg gɨnɨgab agɨl ñu kɨl tɨklak rek nep gak. Kɨri ñu kɨl tɨkɨl aglak, “Nop bɨ Nasaret nɨb alap agnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nasaret mɨdelak ñɨn nab nɨbak, Jon bɨ ñɨg pak ñeb ak apɨl, karɨp lɨm Judia nab sɨŋak, karɨp lɨm bin bɨ koŋai ma mɨdelɨgɨpal, mɨñ mab kab nep mɨdolɨgɨp nab okok mɨdek nɨŋlɨg gɨ, bin bɨ okok apel, ne kɨrop mɨnɨm ag ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kɨrop ag ñɨl agolɨgɨp, “Ulep mɨdeb, God bin bɨ dɨl kod mɨdenɨgab. Nɨb ak, tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn agɨl, kɨrɨg gɨnɨmɨb,” agolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon kɨrop mɨnɨm ag ñolɨgɨp nɨbak, bɨ God mɨnɨm agep Aisaia bɨrarɨk nep gɨnɨgab agɨl, ñu kɨl tɨkak rek nep gak. Aisaia mɨnɨm nɨbak ñu kɨl tɨkɨl agak, “Bɨ alap, karɨp lɨm bin bɨ koŋai ma mɨdebal, mɨñ mab kab nep mɨdeb nab sɨŋak am mɨdɨl, sɨk agɨl agnɨgab, ‘Bɨ Kɨb ak apeb! Kanɨb mak kɨlan kɨyan gɨ mɨdonɨmɨŋ okok, dɨm gol pɨlɨs gɨ mɨdonɨmɨŋ okok, pɨŋɨl pag tep gɨ mɨdenɨmɨb,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pen Jon walɨj ne ak, kaj kamel kas dɨl gɨlak walɨj alap yɨmɨl, kaj kau wak sɨb nag nab sɨŋak pɨg lolɨgɨp. Tap ñɨŋeb ne ak, joŋ golbɨd ak abe, bom ñɨg ak abe ñɨbolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ñɨn nɨbak, Jerusalem bin bɨ mɨdelak okok abe, bin bɨ karɨp lɨm Judia yokop nɨb okok mɨdelak okok abe, ñɨg Jodan ulep okok bin bɨ mɨdelak okok abe, kɨri magɨlsek Jon mɨdek sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jon mɨdek sɨŋak amɨl, tap si tap tɨmel gɨlak okok mɨseŋ ag pɨwak pe gel nɨŋlɨg gɨ, Jon kɨrop ñɨg Jodan nab sɨŋak ñɨg pak ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pen bɨ Perisi okok abe, bɨ Sadyusi okok abe koŋai nep, Jon cɨnop ñɨg pak ñaŋ agɨl apelak, Jon kɨrop sɨlɨk ag gɨl agak, “Nɨbi soiŋ ñɨ pai sɨŋ aul! Gos tari nɨŋɨl pɨrɨk gɨ apebɨm? ‘Ñɨg pakon, God bin bɨ ke nɨb okok kɨrop ag gɨnɨgab ñɨn ak, cɨnop ma ag gɨnɨgab,’ agɨl, pɨrɨk gɨ apebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nɨbi ñɨg paknɨg gɨnɨgabɨm ak, tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨl, mɨd tep gɨnɨmɨb. Nɨg gɨnɨgabɨm ak, bin bɨ nɨŋnɨgal, nɨbi tap si tap tɨmel gölɨgɨpɨm ak bɨr kɨrɨg gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pen nɨbi gos alap nɨŋɨl, ‘Cɨn based acɨk Ebraham ñɨ pai ne mɨdobɨn nɨŋɨl God cɨnop tap tɨmel alap ma gɨnɨgab,’ agɨl, gos ak ma nɨŋnɨmɨb. Ebraham ñɨ pai ne mɨdobɨn apɨm ak tap yokop! God kab sɨŋ aul dɨl, Ebraham ñɨ pai ne okok gɨ lɨnɨg gɨl, gɨ lɨpkop! Nɨb ak, ‘Bɨ tep Ebraham tɨkɨl tɨk amɨl apɨl gɨl cɨn ke tɨk dap lɨpal,’ apɨm ak, mɨnɨm ak rek ma agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Nɨŋ tep gɨnɨmɨb! God mab ak wagɨn sek tɨb junɨg, tu ak mab wagɨn eyaŋ kɨd gɨl mɨdeb. Mab alap magɨl ñɨŋeb tep ognap ma pɨlnɨgab ak, tɨb gɨ rɨk dɨ mab yɨneb eyaŋ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nɨbi tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn agɨl, kɨrɨg gem me, yad nɨbep ñɨg nep pak ñɨnɨgain. Pen bɨ yɨp kɨsen onɨgab ak, ne yad rek mer; ne bɨ kɨb yɨb, yad bɨ sɨkol. Yad nop nɨŋen nabɨŋ gɨnɨgab. Tob wak ne dad ajenɨm rek ma lɨp. Yad nɨbep ñɨg nep pak ñebin, pen bɨ nɨbak ne apɨl, nɨbep Kaun Sɨŋ ak pak ñɨl, mab mɨlaŋ pak ñɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Ne wid magɨl pok gek, tɨk dap pakpal rek ak gɨnɨg geb. Wid magɨl ñɨŋeb okok ke lɨl, wid cög dai dai okok ke lɨnɨgab. Nɨg gɨl, wid magɨl ñɨŋeb ne okok dam karɨp ñɨlɨk mɨgan sɨŋak lɨnɨgab; pen dai dai okok dam mab per ke yɨn mɨdeb ak dagɨlnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ñɨn nɨbak, Jisas ne, Jon yɨp ñɨg pak ñaŋ, agɨl, karɨp lɨm Galili kɨrɨg gɨl, ñɨg Jodan amɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon nop agak, “Yɨp ñɨg pak ñan,” agak. Agek, Jon agak, “Nak nep me yɨp ñɨg pak ñɨbnap. Pen yad titi gɨl nep ñɨg pak ñɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Agek, Jisas agak, “Nak ageban ar ak kɨrɨg gɨnɨmɨn, yad agebin rek nep gɨl me, God agɨp agɨp rek nep gɨnɨgabɨr,” agak. Agek Jon, “Nɨŋɨd ageban,” agɨl, Jisas nop ñɨg pak ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon Jisas nop ñɨg pak ñek nɨŋlɨg gɨ, Jisas ñɨg gol sɨŋak alaŋ apɨl nɨŋak, seb kab ar alaŋ mɨgan pag yɨkek, God Kaun ak yakɨr tɨbaglem rek ug gɨ nop owak. ");
INSERT INTO kmh_m_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kaun Sɨŋ nɨg gɨl apek nɨŋlɨg gɨ, mɨnɨm alap seb kab ar alaŋ nɨb apɨl agak, “Ñɨ tep nɨbaul, ñɨ mɨdmagɨl yad yɨb. Yad nop nɨŋen, yɨp tep yɨb gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ñɨn nɨbak God Kaun ak, Jisas nop poŋ dɨl, karɨp lɨm bin bɨ ma mɨdelɨgɨpal, mɨñ mab kab nep mɨdolɨgɨp nab okok dad amek, Seten ne Jisas tap si tap tɨmel ognap gɨnɨmɨŋ akaŋ agɨl gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas mɨñ mab nep nab nɨb okok tap ñɨbɨl mer, ñɨn aknɨb ñɨn juɨl omal (40) melɨk abe kɨslɨm abe yokop nep mɨdek. Nɨg gɨl yokop nep mɨdek nɨŋlɨg gɨ, nop yuan kɨb yɨb gek, ");
INSERT INTO kmh_m_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Seten Jisas nop gos ñen, tɨmel gɨnɨmɨŋ agɨl, apɨl Jisas nop agak, “Yad God Ñɨ ne mɨdebin apan ak, kab ognɨl agek, bred rek laŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Agek, Jisas pen agak, “God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Bin bɨ okok bred nep ñɨbɨl komɨŋ ma mɨdenɨgal; God mɨnɨm ageb nɨbak magɨlsek nɨŋ dɨl me, komɨŋ mɨdenɨgal,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas nɨb agek, kɨjeki Jisas nop poŋ dɨl dam taun kɨb tɨd Jerusalem amɨl, God sobok gep karɨp i ar alaŋ gɨlak ak lɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Yad God Ñɨ ne mɨdebin apan ak, preŋɨd lɨm eyaŋ yowan. God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘God ejol ne okok agek, apɨl nep ñɨnmagɨl kɨri denɨgal me, kab tob nep ak ma pɨŋɨl gɨnɨgab,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Agek, Jisas pen agak, “Mer! God Mɨnɨm ak mɨnɨm ognap sek ñu kɨl tɨkɨl aglak, ‘God Bɨ Kɨb ak, ne bɨ nɨŋɨd akaŋ bɨ tom agep, ma agnɨmɨb,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Agek, Seten Jisas nop dam dɨm kɨb yɨb alap amɨl, karɨp lɨm tep tep bɨ kɨb ke ke kod mɨdelak okok Jisas nop yomɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Nak kogɨm yɨmɨl, yɨb yɨp agek ar alaŋ amek, yad karɨp lɨm nɨb sɨŋaul magɨlsek nep ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Agek, Jisas Seten nop agak, “Nak ke okok amnoŋ! God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘God Bɨ Kɨb yɨb nop ak nep agem ar amnaŋ; wög nop nep gɨnɨmɨb,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas nɨb agek nɨŋlɨg gɨ, kɨjeki, Jisas ne tap tɨmel ognap gɨnɨmɨŋ agɨl, gɨ gɨ mer nɨŋɨl, nop kɨrɨg gɨl amek nɨŋlɨg gɨ, ejol ognap apɨl, nop ap goŋ lɨl kod mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ñɨn nɨbak Jon bɨ ñɨg pak ñeb ak nop mɨñ lɨlak. Jisas mɨnɨm nɨbak peyɨg nɨŋɨl, karɨp lɨm Galili adɨk gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amɨl taun ne Nasaret ma am mɨdek; am mɨdek taun sɨkol Kapaneam, karɨp lɨm Sebyulan Naptalai nab sɨŋak mɨdeb Ñɨg Cöb Galili gol sɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas karɨp lɨm nɨbak amɨl, bin bɨ okok kɨrop mɨnɨm tep ak ag ñɨ ajolɨgɨp ak me, bɨ God mɨnɨm agep Aisaia gɨnɨgab agɨl ñu kɨl tɨkak rek nep gak. Ne agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Karɨp lɨm Sebyulan abe Naptalai abe, Ñɨg Cöb Galili gol sɨŋak, Ñɨg Jodan pɨb paŋɨd ameb pɨs kɨd, Juda bin bɨ mer karɨp lɨm Galili sɨŋak mɨdebal okok kɨri melɨk kɨb yɨb nɨpal. Kɨslɨm okok mɨdɨl kɨmnɨmel rek lak ak pen melɨk kɨb ak bɨr nɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas ñɨn nɨbak wagɨn gɨl, bin bɨ okok kɨrop God mɨnɨm tep ak ag ñɨ ajlɨg gɨ agak, “Tap si tap tɨmel gɨpɨm ar ak, tari gɨnɨg nɨg gɨpɨn agɨl, kɨrɨg gɨnɨmɨb. Maŋ mɨdeb, God bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab; ñɨn kɨsen nɨbi per kod mɨdelɨgɨpɨm ak mɨñi owɨp!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Ñɨg Cöb Galili gol ar sɨŋak ap yap amɨl nɨŋak, bɨ kɨbsal dep mamɨl mal, uben yoklɨg gɨ kɨbsal derek. Bɨ mamɨl mal, nɨmam alap yɨb ne ak Saimon, nɨmam alap yɨb ne ak Edru. Saimon nop yɨb alap Pita agölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas kɨrop mal nɨŋɨl agak, “Yɨp sain gir. Yad nɨrep gen, nɨri mamɨl mal, kɨbsal dep bɨ mer, bin bɨ dep bɨ mɨdenɨgair,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Agek, agak rek nep nɨŋɨl, kɨbsal derek uben okok kɨrɨg gɨl, Jisas eip ajölɨgɨpir. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pen won alap tapɨn amlɨg gɨ nɨŋak, Jems eip Jon eip nap Sebedi eip ñɨg magöb mɨgan ak apɨlgon mɨdlɨg gɨ, uben luöl dɨlɨg gɨ mɨdelak. Jisas nɨŋɨl, kɨrop mal sɨk agek, ");
INSERT INTO kmh_m_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kɨri nap Sebedi ñɨg magöb sɨŋak kɨrɨg gɨl, Jisas eip amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas karɨp lɨm Galili nab sɨŋak gɨ ajlɨg gɨ, Juda mogɨm gep karɨp okok okok amɨl, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak, bin bɨ okok kɨrop ag ñɨ ajlɨg gɨ, tap tari tari bin bɨ okok kɨrop gak okok gek komɨŋ lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɨg gek, karɨp lɨm Siria bin bɨ okok magɨlsek mɨnɨm nɨbak nɨŋɨl, bin bɨ kɨrop tap tari tari gak okok dad apel, Jisas gek komɨŋ lolɨgɨp. Bin bɨ nɨb okok, ognap tap gak; ognap mɨb goŋ yur kɨb gak; ognap kɨjeki abaŋ ñagak; ognap udɨn mɨmain apek, ap yap pakɨl jep jep dölɨgɨpal; ognap ñɨn tob kalau gak; pen bin bɨ kɨrop tap tari tari gak okok dapel, Jisas gek magɨlsek komɨŋ lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pen Galili bin bɨ dɨl, Dekapolis bin bɨ dɨl, Jerusalem bin bɨ dɨl, Judia bin bɨ dɨl, ñɨg Jodan kɨd adaŋ sɨŋak bin bɨ dɨl, koŋai nep Jisas amek nɨŋlɨg gɨ, kɨsen amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas, bin bɨ koŋai nep nɨb okok nɨŋɨl, am dɨm yɨrɨk alaŋ bɨ ne aknɨb umɨgan alaŋ dak okok eip bɨsɨg mɨdlɨg, kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisas ne bin bɨ kɨrop mɨnɨm ag ñɨlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Bin bɨ okok, cɨn bin bɨ tep mer, God ne nep cɨnop gɨ ñɨnɨgab agɨl, God nop ag nɨŋnɨgal okok, God kɨrop dɨl seb kab ar alaŋ kod mɨdenɨgab ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bin bɨ sɨl agebal okok, God kɨrop ag dɨnɨgab ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bin bɨ sain kapkap mɨdebal okok, kɨri lɨm dai wagɨn aul dɨnɨgal ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bin bɨ, God agak rek nep gɨnɨgabɨn agɨl, nɨpal okok, God kɨrop kod mɨdenɨgab ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bin bɨ kɨri bin bɨ okok kɨrop mapɨn nɨŋɨl dɨ tep gɨnɨgal okok, God kɨrop pen ak rek nep mapɨn nɨŋɨl dɨ tep gɨnɨgab ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bin bɨ God nop gos nokɨm nɨŋebal okok, God nop nɨŋnɨgal ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bin bɨ nɨŋnɨgal, bin bɨ ognap pen pen gɨnɨgal okok, kɨri apɨl agnɨgal, ‘Nɨbi aknɨb ma gɨnɨmɨb, kapkap mɨdenɨmɨb,’ agnɨgal okok, God kɨrop ñɨ pai yad agnɨgab ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bin bɨ kɨri God ageb rek nep gɨnɨgabɨn agɨl mɨdel, bin bɨ ognap kɨrop gɨ tɨmel genɨgal ak, God kɨrop dɨl seb kab ar alaŋ kod mɨdenɨgab ak me, mɨñ mɨñ gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nɨbep Jisas bin bɨ ne agɨl gɨ tɨmel gɨl, mɨnɨm tom agɨl ag juenɨmel, nɨbi mɨñ mɨñ yɨb gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bɨ God mɨnɨm agep bɨrarɨk ped okok kɨrop ar nɨbak nep gɨlak. Nɨb ak, nɨbep ak rek nep genɨgal ak, gos par ma nɨŋnɨmɨb; God cɨnop seb kab ar alaŋ dɨ tep gɨnɨgab ag gos nɨŋlɨg gɨ, mɨñ mɨñ yɨb gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas mɨnɨm nɨbak agɨl agak, “Bin bɨ lɨm dai ar wagɨn aul mɨdebal okok, nɨbi dek sol rek kɨri mɨdebɨm. Pen dek sol kabiam ak am sakek kauyaŋ kabiam ma gɨnɨgab; pɨs nep tɨmel gɨp agɨl, tau cɨb jakɨl dɨ yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Taun kɨb dɨm alaŋ mɨdɨl, we gɨl mɨdenɨmɨŋ rek ma lɨnɨgab; mɨseŋ yɨb mɨdenɨgab. Nɨb ak rek, bin bɨ lɨm dai wagɨn aul mɨdebal okok kɨrop sɨp melɨk rek mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bin bɨ okok sɨp dagɨl tin cög mɨgan okok ma we gɨnɨgal. Ar sɨŋak alaŋ tɨk lel melɨk gek, bin bɨ karɨp ñɨlɨk mɨgan okok magɨlsek nɨŋ tep gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nɨb ak rek, nɨbi bin bɨ okok kɨrop gɨ tep gem, bin bɨ okok nɨbep nɨŋɨl, Nap nɨbi seb kab ar alaŋ mɨdeb yɨb nop nep agel ar amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nɨbi agnɨgabɨm, Jisas owɨp ak, God Mosɨs nop lo mɨnɨm agak mɨnɨm ar ak abe, bɨ God mɨnɨm agep ognap aglak mɨnɨm ar ak abe, kɨrɨg gɨnɨmɨb agnɨg owɨp agnɨgabɨm ak pen ak mer! Yad opin ak, bɨ God mɨnɨm agep okok gɨnɨgab aglak rek magɨlsek gɨnɨm agɨl opin. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yad nɨbep nɨŋɨd yɨb agebin. Seb kab ar alaŋ abe, lɨm dai wagɨn aul abe pɨs nep kɨr gɨnɨgab ak pen God Mɨnɨm ne ak mɨnɨm magɨl alap ma kɨrɨg gɨnɨgab; magɨlsek per per nep mɨdenɨgab. Mɨnɨm tari tari agak ak, magɨlsek agak rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Nɨb ak, bin bɨ an an God lo mɨnɨm ak nɨŋɨl, mɨnɨm sɨkol won alap kɨrɨg gɨnɨm agɨl, bin bɨ okok abramek ag ñek kɨrɨg gɨnɨgal ak, God bin bɨ dɨl kod mɨdenɨgab ñɨn ak, yɨb kɨri ap yonɨgab. Pen bin bɨ an an God lo mɨnɨm nɨŋɨl, nɨŋ tep gɨl, bin bɨ okok kɨrop ag ñɨ tep gɨnɨgal ak, God bin bɨ dɨl kod mɨdenɨgab ñɨn ak, yɨb kɨri ap rannɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bɨ Perisi okok abe, God lo mɨnɨm ag ñeb bɨ okok abe, ‘God mɨnɨm ageb ar ak nep gɨpɨn,’ apal ak pen kɨri yokop mɨnɨm agɨl God mɨnɨm ageb ar ak ma gɨpal, mer. Nɨbi ke pen, God mɨnɨm ageb rek nep yɨpɨd gɨl nep nɨŋ dɨl kɨsen gɨnɨmɨb. Nɨb gɨnɨgabɨm ak me, God nɨbep dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bɨrarɨk nep napɨs nased yes okok God lo mɨnɨm agelɨgɨpal ar ak nɨbi nɨpɨm. Kɨri agölɨgɨpal, ‘Cɨp ñag ma paknɨmɨb. Bin bɨ alap, bin bɨ alap ñag pak lɨnɨgab ak, mɨnɨm kɨb nɨŋnɨgab,’ agölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mɨnɨm nɨbak nɨpɨm ak pen nɨbep mɨñi ag tep gɨnɨm. Bin bɨ alap, bin bɨ alap nop nɨŋek mɨlɨk yonɨgab ak, mɨnɨm kɨb nɨŋnɨgab. Bin bɨ alap, bin bɨ alap yɨb dap yonɨgab ak, Juda Kansol okok ap mogɨm gɨl, nop mɨnɨm kɨb agnɨgal. Bin bɨ alap, bin bɨ alap nop agnɨgab, ‘Nak bɨ saköl sek,’ agnɨgab ak, karɨp lɨm mab ke yɨneb mɨgan eyaŋ amnɨmɨŋ rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nɨb ak, nak tap God nop sobok gɨ ñeb dam kab bɨd ar ak sobok gɨ ñɨnɨg, nanai namam nak alap nop gɨ tɨmel gɨpan rek mɨnɨm mɨdeb ag gos nɨŋnɨgan ak, ");
INSERT INTO kmh_m_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tap God nop sobok gɨ ñeb nɨbak kab bɨd ar sɨŋak kɨrɨg gɨl, nop eip mɨnɨm ag tep gɨl, mɨñi kapkap jɨm ñɨl mɨdor agɨl, adɨk gɨ apɨl tap nɨbak God nop sobok gɨ ñɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tap tari gɨ tɨmel gɨnɨgabɨm ak, nɨbep mɨnɨm kɨb agnɨg, dam kanɨb nab okok kɨsen dad amel nɨŋlɨg gɨ, kɨrop eip mɨnɨm nɨbak ag tɨg asɨkɨl, jɨm ñɨl mɨdenɨmɨb. Mer ak, nɨbep dam bɨ kɨb ak nop ñenɨgal, ne pen nɨbep dɨ polisman kai kɨrop ñek, nɨbep dam nag lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yad nɨbep nɨŋɨd yɨb agebin, tap dai nɨbi mɨdonɨmɨŋ ak pɨs nep magɨlsek dai pag juɨl me söŋ amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Pen mɨnɨm alap aglak ak, ak rek nep nɨpɨm. Mɨnɨm nɨbak aglak, ‘Bin si bɨ si ma gɨnɨmɨb,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pen yad nɨbep agebin, bɨ alap bin alap nop nɨŋɨl, nop gɨpnep agɨl gos nɨŋnɨgab ak, God nɨŋek, bɨ nɨbak gos ne nab eyaŋ bin nɨbak si gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nɨb ak, udɨn magɨl yɨpɨd kɨd nɨŋɨl, tap si tap tɨmel gɨnɨmɨŋ rek lonɨmɨŋ ak, udɨn pɨs nɨbak tɨg ju yoknɨmɨb. Pen udɨn nɨbi ak yɨmɨg nɨŋnɨgabɨm ak, tap si tap tɨmel gɨl, mab ke yɨneb mɨgan eyaŋ amnɨmɨb rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pen ñɨnmagɨl yɨpɨd kɨd ak, ak rek nep, tap si tap tɨmel gɨnɨmɨŋ rek lonɨmɨŋ ak, tɨb gɨ rɨk dɨ yoknɨmɨb. Nɨg gɨl me, ñɨn pɨs kɨd nep mɨdek komɨŋ amnɨgabɨm. Mer ak, mab ke yɨneb mɨgan eyaŋ amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nɨbi nɨpɨm, mɨnɨm alap aglak, ‘Bɨ alap bɨn ne nop kɨrɨg gɨnɨg, bin aul pɨs nep kɨrɨg gɨnɨm, agɨl, ñu kɨl bad alap tɨkɨl, bin nɨbak nop ñɨl me, pɨs nep kɨrɨg gɨnɨgab,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pen yad nɨbep agebin: bɨ alap, bin ne bɨ alap si ma dɨnɨgab mer, pen nɨgmɨl ne bɨn ne yokop nep kɨrɨg gɨnɨgab ak, gɨ tɨmel gɨnɨgab. Pen bin ak nop nɨg gɨl kɨrɨg gek, am bɨ kɨsen nɨb alap dɨnɨgab ak, bɨ nɨbak ne bin ne kɨrɨg gɨnɨgab ak me, ne nɨg gek, bin ne bɨ si dep bin lɨnɨgab. Pen bɨ an bin nɨbak dɨnɨgab ak, ne ak rek nep bin si dep bɨ lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bɨrarɨk nep mɨnɨm alap aglak ak, ak rek nep nɨpɨm. Mɨnɨm nɨbak aglak, ‘Nɨbi Bɨ Kɨb udɨn yɨrɨk ne mɨnɨm nɨŋɨd yɨb agnɨgabɨm ak, agnɨgabɨm rek nep gɨnɨmɨb. God ne nɨŋ mɨdeb nɨŋɨl agnɨgabɨm rek nep gɨnɨmɨb,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pen yad nɨbep agebin: mɨnɨm alap agnɨg, ‘God udɨn yɨrɨk ar ak nɨŋɨd agebin,’ agɨl ma agnɨmɨb. ‘Karɨp lɨm seb kab ar alaŋ sɨŋak mɨdeb rek nɨŋɨd agebin,’ agɨl ma agnɨmɨb; God ne karɨp lɨm nɨb sɨŋak sea kiŋ ar sɨŋak bɨsɨg mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘Lɨm dai wagɨn aul mɨdeb rek nɨŋɨd agebin,’ agɨl ma agnɨmɨb; God ne sea kiŋ ar sɨŋak bɨsɨg gɨl, karɨp lɨm wagɨn aul tob ar sɨŋak tau mɨdeb. ‘Jerusalem mɨdeb rek nɨŋɨd agebin,’ agɨl ma agnɨmɨb; ak Kiŋ Kɨb yɨb taun kɨb ne me. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‘Nabɨc yad mɨdeb rek, nɨŋɨd agebin,’ agɨl ma agnɨmɨb. Nɨbi ke gem, nabɨc kas nɨbi nokɨm alap kɨloi akaŋ mosɨb ma tannɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nɨb ak, ‘Gɨnɨgain’ agɨl, ‘Gɨnɨgain’ nep agnɨmɨb; pen ‘Ma gɨnɨgain’ agɨl, ‘Ma gɨnɨgain’ nep agnɨmɨb. Mɨnɨm kauyaŋ lɨl agɨl, lɨl agnɨgabɨm ak, Seten nɨbep gos ñek, nɨb agnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Pen mɨnɨm alap aglak ak, ak rek nep nɨpɨm. Mɨnɨm nɨbak aglak, ‘Udɨn magɨl ak pɨŋɨl juenɨmel, kɨrop pen abe pɨŋɨl junɨmɨb. Meg magɨl pɨpag genɨmel, kɨrop pen abe pɨpag gɨnɨmɨb,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pen yad nɨbep agebin: bɨ alap nɨbep gɨ tɨmel genɨmɨŋ, nop pen gɨ tɨmel ma gɨnɨmɨb. Bɨ alap nɨbep mɨkem pak sɨl genɨmɨŋ, adɨk gem pɨs kɨd abe paknɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bɨ alap apɨl nɨbep mɨnɨm kɨb agɨl, ‘Sior nak ak yɨp saj gan,’ agenɨmɨŋ, sior nep ma ñɨnɨmɨb, kolsior ak abe ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bɨ alap nɨbep ag nɨŋɨl, ‘Tap wad aul dam kau sɨŋak yokɨl onɨmɨn,’ agenɨgab ak, ma yo nɨŋnɨmɨb; kau agnɨmel sɨŋak sɨl gɨl, dam yokop kau sɨŋak yokɨl onɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bin bɨ ognap nɨbep, ‘Cɨnop tap ognap ñɨm,’ ag nɨŋenɨmel, abramek ñɨnɨmɨb. Pen bin bɨ ognap nɨbep, ‘Cɨnop tap ognap yokop ñem, kɨdek nɨbep pen adɨk gɨ dam ñɨnɨgabɨn,’ agenɨmel, ma kɨrɨg gɨnɨmɨb, abramek ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mɨnɨm alap aglak ak, ak rek nep nɨpɨm. Mɨnɨm nɨbak aglak, ‘Namɨd namam nɨbi okok kɨrop mɨdmagɨl lɨnɨmɨb; bin bɨ kaual maual nɨbi okok kɨrop mɨlɨk dai nɨŋnɨmɨb,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pen yad nɨbep agebin: bin bɨ kaual maual nɨbi okok, kɨrop mɨdmagɨl lɨnɨmɨb; bin bɨ nɨbep gɨ tɨmel gɨpal okok, God nop sobok gɨl, ‘Kɨrop kod mɨd tep gɨnɨmɨn,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Nɨbi nɨg gɨnɨgabɨm ak, Nap seb kab ar alaŋ mɨdeb ak, ñɨ pai ne yɨb mɨdenɨgabɨm. Ne gek, pɨb melɨk gek, bin bɨ gɨ tep gɨpal okok abe, bin bɨ gɨ tɨmel gɨpal okok abe, melɨk geb. Ne gek, mɨñab pakɨl, bin bɨ gɨ tep gɨpal okok tap wög kɨri okok tanɨl, bin bɨ gɨ tɨmel gɨpal okok tap wög kɨri okok tanɨl gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nɨbi bin bɨ nɨbep mɨdmagɨl lɨpal okok nep dɨ tep gɨnɨgabɨm ak, bɨ takɨs dɨpal okok gɨpal rek nep gɨnɨgabɨm. Nɨg gɨnɨgabɨm ak, God ne titi gɨl mɨñ mɨñ gɨl nɨbep tap tep ñɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nɨbi nanai namam nɨbi okok nep ag wasu ag dɨnɨgabɨm ak, bin bɨ God nop gos ma nɨpal okok, bin bɨ yokop okok kɨrop gɨpal rek nep gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Nɨb ak, Nap seb kab ar alaŋ gɨ tep yɨb geb rek, nɨbi ak rek nep gɨ tep yɨb gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pen nɨbi, yɨb kɨb dɨn agɨl, bin bɨ udɨn yɨrɨk ar kɨrop ak nep God ageb rek nep gɨn, agɨl gɨpɨm ak, Nap nɨbi seb kab ar alaŋ mɨdeb ak nɨŋɨl nɨbep pen tap tep alap ma ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bin bɨ ognap, God nop nɨŋ dɨpɨn, agɨl, tom nep gɨpal. Yɨb kɨb dɨn, agɨl, kɨri bin bɨ yɨm gep rek okok kab magɨl tap ognap ñɨnɨg, Juda mogɨm gep karɨp bin bɨ koŋai mɨdenɨgal mɨgan ak akaŋ, kanɨb kɨb bin bɨ koŋai nep ajenɨgal okok nep amɨl, bin bɨ udɨn yɨrɨk ar sɨŋak ñɨnɨgal. Gɨnɨgal nɨbak yad nɨbep agebin: yɨb kɨb dɨn, agɨl, tap kɨri pen dɨnɨgal nɨbak; Bapi kɨrop tap ognap sek ma ñɨnɨgab. Kɨri nɨg gɨpal rek ma gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Pen nɨbi bin bɨ yɨm gep rek okok kɨrop tap ñɨnɨg, mɨseŋ ma ñɨnɨmɨb; ");
INSERT INTO kmh_m_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kapkap we gɨl rek ñɨnɨmɨb. Tap tari kapkap gɨpɨm ak, Nap nɨbi magɨlsek nɨŋeb rek, tap tari tari gɨnɨgabɨm nɨŋɨl, nɨbep pen tap tep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nɨbi God nop sobok gɨnɨg gɨnɨmɨb ak, bin bɨ ognap, God nop gos nɨpɨn, agɨl, tom nep gɨpal rek ma gɨnɨmɨb. Kɨri bin bɨ ognap cɨnop nɨŋel, yɨb kɨb dɨnɨgabɨn, agɨl, am Juda mogɨm gep karɨp nab sɨŋak mɨdɨl akaŋ am kanɨb tam okok mɨdɨl, bin bɨ udɨn yɨrɨk ar sɨŋak God nop sobok gɨpal. Gɨpal nɨbak yad nɨbep agebin, yɨb kɨb dɨn, agɨl, tap kɨri pen dɨnɨgal nɨbak; God ne mɨnɨm kɨrop ak ma dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nɨb ak, nɨbi God nop sobok gɨnɨg, karɨp magɨl ñɨlɨk mɨgan nɨbi ak amɨl, kɨjoŋ gɨ ñɨl, Bapi cɨn udɨn ma nɨŋobɨn ak nop sobok gɨnɨmɨb. Tap tari kapkap gɨpɨm ak, Nap nɨbi magɨlsek nɨŋeb rek, tari tari gɨnɨgabɨm nɨŋɨl, mɨnɨm nɨbep nɨŋɨl, nɨbep pen tap tep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bin bɨ God Mɨnɨm ma nɨpal okok, nop sobok gɨnɨg, mɨnɨm par kɨb yɨb apal. Gos kɨri nep nɨŋɨl apal, ‘Mɨnɨm par kɨb agon me nɨŋnɨgab,’ apal. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pen nɨbi aknɨb rek ma gɨnɨmɨb. Mɨnɨm tari Nap nop sobok gɨnɨg gebɨm ak, ne ned nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nɨb ak, God nop sobok gɨnɨg, agnɨmɨb, ‘Bapi cɨn seb kab ar alaŋ mɨdeban; yɨb nak i ar alaŋ mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nak cɨnop dɨl kod mɨdenɨmɨn. Seb kab ar alaŋ ageban rek nɨŋɨl gɨpal ak, cɨnop lɨm dai ar wagɨn aul gɨ ñɨnɨmɨn, cɨn abe mɨnɨm nep nɨŋɨl kɨsen gɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cɨnop tap ñɨŋeb ognap nonɨm lɨ ñɨnɨmɨn; per ñɨban rek ñɨn nokɨm nokɨm ñɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bin bɨ ognap cɨnop gɨ tɨmel gɨpal nɨŋɨl kɨrɨg gɨpɨn rek, cɨn gɨ tɨmel gɨpɨn ak rek nep nɨŋɨl kɨrɨg gɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kɨjeki lɨp gek, cɨn gɨ tɨmel gɨjɨn rek lɨp ak, nak cɨnop kod mɨdek, cɨn gɨ tɨmel ma gɨn,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bin bɨ ognap nɨbep gɨ tɨmel gel nɨŋɨl kɨrɨg gɨnɨgabɨm ak, Nap nɨbi seb kab ar alaŋ mɨdeb ak tap si tap tɨmel nɨbi gɨnɨgabɨm ak, ak rek nep nɨŋɨl, kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pen bin bɨ ognap nɨbep gɨ tɨmel gel nɨŋɨl ma kɨrɨg gɨnɨgabɨm ak, Nap nɨbi tap si tap tɨmel nɨbi gɨnɨgabɨm ak, ak rek nep nɨŋɨl ma kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nɨbi tap ñɨŋeb kɨrɨg gɨnɨg, bin bɨ God nop gos nɨpɨn, agɨl, tom nep gɨpal rek, ma gɨnɨmɨb. Kɨri, ‘Cɨn mɨlɨk agrob gɨ yapɨl rek mɨdon, bin bɨ nɨŋɨl agnɨgal, “God nop gos nɨŋɨl, tap ñɨŋeb bɨl gɨl me, mɨlɨk agrob gɨ yapɨl mɨdebal,” agnɨgal,’ agɨl, tom gɨl nɨg gɨpal. Yad nɨbep nɨŋɨd yɨb agebin: bin bɨ cɨnop nɨŋlaŋ, agɨl gɨnɨgal nɨb okok, bin bɨ okok nɨŋɨl yɨb kɨrop agel ar amnɨgab ak pen God kɨrop tap tep seb kab ar alaŋ ma ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nɨbi pen tap ñɨŋeb okok bɨl genɨgabɨm ak, mɨlɨk agrob gɨ yapɨl rek ma mɨdenɨmɨb. Ñɨg pak tep gɨl, wel lɨl, kom gɨl mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nɨg genɨgabɨm ak me, nɨbep bin bɨ tap magɨl bɨl gɨpal okok, agɨl, ma nɨŋnɨgal. Pen tap kapkap gɨpɨm ak, Nap nɨbi, cɨn udɨn ma nɨŋobɨn Bɨ ak, ne magɨlsek kapkap we gɨl mɨdeb ak nɨŋeb rek, nɨŋɨl nɨbep pen ñɨl tap tep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pen lɨm dai ar wagɨn aul tap tep tep okok dɨ mogɨm gɨn, agɨl gos ak ma nɨŋnɨmɨb. Tari gɨnɨg: tap nɨb okok dɨ mogɨm genɨgabɨm ak, sɨpsep ñɨbɨl, ki gɨl, si dɨl gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nɨb ak, tap tep nɨbi rek okok, God karɨp lɨm seb kab ar alaŋ sɨŋak dɨ mogɨm gem, sɨpsep ma ñɨŋnɨgab, ki ma gɨnɨgab, si ma dɨnɨgal, mɨdep nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tap tep nɨbi lɨm dai ar wagɨn aul dɨ mogɨm genɨgabɨm ak, gos nɨbi mɨdenɨgab lɨm dai ar wagɨn aul; tap tep nɨbi God karɨp lɨm seb kab ar alaŋ sɨŋak dɨ mogɨm genɨgabɨm ak, gos nɨbi ak amnɨgab nɨb alaŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Udɨn magɨl mɨb goŋ sɨp melɨk rek mɨdeb. Udɨn magɨl nɨbi ak tep mɨdek, melɨk tep gek nɨŋ tep gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pen udɨn magɨl nɨbi ak tɨmel gek, mɨb goŋ nɨbi ak kɨslɨm gɨnɨgab. Melɨk gɨpkop pen pɨs nep kɨslɨm gek, tap alap ma nɨŋnɨgabɨm. Nɨbi melɨk ma nɨpɨm ak, kɨslɨm gɨp rek mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Bɨ nokɨm alap, bɨ kɨb omal kɨrop wög gɨ ñɨnɨmɨŋ rek ma lɨp. Tari gɨnɨg: bɨ kɨb alap nop nɨŋek tep genɨgab, alap nop kɨrɨg gɨnɨgab: pen bɨ kɨb alap nop nɨŋek tep genɨgab, alap nop kɨrɨg gɨnɨgab. Nɨb ak, nɨbi mani tap tep lɨm dai ar wagɨn aul mɨdeb okok nɨŋem tep gek, God nop kɨrɨg gɨnɨgabɨm rek lɨp ak, nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ar nɨbak me nɨbep agebin: tap akal nɨb ñɨŋɨl mɨdojɨn, walɨj akal nɨb tol gɨl mɨdojɨn, agɨl, gos par ak ma nɨŋnɨmɨb. Komɨŋ mɨdep ak tap kɨb; tap ñɨŋeb tap sɨkol. Mɨñi mɨdobɨn aul, mɨb goŋ tap yɨb; mɨb goŋ walɨj tol gep tap sɨkol. Nɨg gek nɨŋɨl, God nɨbep gɨ lak ak, ne tap ñɨŋeb, walɨj mɨb goŋ tol gep, tap sɨkol nɨb okok ma ñɨnɨgab ag gos nɨŋebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nɨbi nɨpɨm, yakɨr okok tap yɨŋ ma yɨbal; wid tap okok tɨk dap mogɨm ma gɨpal. Pen Nap kɨri seb kab ar alaŋ ak kɨrop kod mɨdek, tap ñɨbal. Nɨb ak, yakɨr okok tap yokop ak pen ne tap ñek ñɨbal rek, nɨbep ak rek nep ma ñɨnɨgab ag gos nɨŋebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Akaŋ, gos par nɨŋɨl me, tapɨn mɨdɨl kɨmnɨgabɨn ag gos nɨŋebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pen tari gɨnɨg walɨj tap okok gos par nɨŋebɨm? Tap pɨlpɨl be okok tanɨb okok, wög ma gɨl, walɨj ma gɨl, gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pen kiŋ Solomon mani koŋai mɨdek tɨb kadɨg tep yɨb golɨgɨp ak, tap pɨlpɨl nɨb okok rek tɨb kadɨg tep ma golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tap pɨlpɨl nɨb okok tap yokop. Per mɨdɨl mer, mɨñi rek mɨdɨl, tol rek tɨb gɨ rɨk dagɨlpal. Pen God tap yokop nɨb okok gɨ lɨl tɨb kadɨg tep gɨ ñɨb ak, tari gɨnɨg cɨnop ma kod mɨdenɨgab ag gos nɨŋebɨm? Nɨbi nɨbak rek gos nɨŋnɨgabɨm ak, nɨbi God nop nɨŋ dɨ tep ma gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nɨb ak, tap akal nɨb ñɨŋɨn, ñɨg akal nɨb ñɨŋɨn, walɨj tari tol gɨn, agɨl, gos par ak ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bin bɨ God Mɨnɨm ma nɨpal okok, tap nɨb okok dɨn, agɨl, gos par nɨbak rek nɨpal. Pen nɨbi nɨpɨm, Nap nɨbi seb kab ar alaŋ mɨdeb ak, nɨbi tap tari tari ma mɨdeb ak bɨr nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nɨb ak, God bin bɨ ognap dɨl kod mɨdenɨgab ak, cɨnop ak rek nep dɨnɨgab, agɨl, gos ar nokɨm nɨŋnɨmɨb; God ne ageb rek nep gɨ mɨdon, agɨl, gos ar nokɨm nɨŋnɨmɨb; nɨbi nɨg gem amek me, tap ñɨŋeb, ñɨg ñɨŋeb, walɨj tol gep, tap nɨb okok magɨlsek nɨbep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nɨb ak, tol menɨk tari gɨl mɨdojɨn, agɨl, gos par ak ma nɨŋnɨmɨb. Ñɨn mɨñi ak ñɨn mɨñi. Mɨñi ñɨn aul nep tap mɨker ognap mɨdeb ak, ak nep gos nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Cɨn bin bɨ tep agɨl, bin bɨ ognap kɨrop gos tɨmel nɨŋnɨgabɨm ak, mɨnɨm nɨbak adɨk gɨ nɨbepe ke onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nɨb ak, nɨŋ tep gɨnɨmɨb. Nɨbi bin bɨ ognap kɨrop gɨnɨgabɨm rek, God nɨbep pen gɨnɨgab. Nɨbi bin bɨ ognap nɨŋɨl mɨnɨm kɨb ag gɨnɨgabɨm rek, God nɨbep ak rek nep mɨnɨm kɨb ag gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mab bog udɨn nɨbi pak karɨkɨl mɨdeb ak, tari gɨnɨg mab bog nɨbak tap yokop agɨl, namam tap acɨp udɨn ne mɨdeb ak nɨŋɨl agebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Nak bɨ mɨnɨm tom agep bɨ. Mab bog udɨn nɨbi pak karɨkɨl mɨdeb ak ned dɨ yokɨl, udɨn nɨŋ tep gɨl, namam tap acɨp udɨn nop mɨdeb ak nop, ‘Dɨ yokin’ agɨl agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God tap sɨŋ ne okok, kain sapeb okok kɨrop ma ñɨnɨmɨb. Kɨbap mɨlep okok, kaj okok mɨdeb, agɨl, ma dɨ yoknɨmɨb. Pen tari gɨnɨg: dɨ yoknɨgabɨm, kɨri tau acɨp acɨp gɨ yokɨl, adɨk gɨ apɨl nɨbep sunɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Tap tari ma mɨdonɨmɨŋ ak, God nop ag nɨŋem nɨbep ñɨnɨgab. Pen tap ognap pɨyo nɨŋnɨgabɨm ak, dɨnɨgabɨm. Cɨnop kɨjoŋ yɨkan, agɨl, pak gu gu gem, nɨbep kɨjoŋ ak yɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pen tari gɨnɨg: bin bɨ God nop ag nɨŋnɨgal ak, ag nɨŋnɨgal rek nep gɨnɨgab. Tap pɨyo nɨŋnɨgal ak kɨrop yomnɨgab. Pen, kɨjoŋ ak yɨkan, agɨl, pak gu gu gel, agnɨgal rek nɨŋɨl yɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nɨbi bɨ nap sɨkop, ñɨ pai nɨbi alap bred alap ñan agek, nɨbi kab ñɨnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Akaŋ pen, kɨbsal alap ñan agek, soiŋ alap ñɨnɨgabɨm? Aknɨb gɨl ma gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nɨbi bin bɨ tep mer ak pen ñɨ pai nɨbi okok, tap tep okok nep ñɨnɨgabɨm. Nap nɨbi seb kab ar alaŋ Bɨ tep yɨb ak, esek ma agnɨgab; nɨbi ag nɨŋnɨgabɨm ak, ne nɨbep tap tep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Pen nɨbi ke, cɨnop ar ak gɨlaŋ, ar ak ma gɨlaŋ, agɨl gos nɨpɨm, ar ak nep bin bɨ okok kɨrop gɨnɨmɨb. Mosɨs God lo mɨnɨm dɨl ñu kɨl tɨkak mɨnɨm ak abe, bɨ God mɨnɨm agep ñu kɨl tɨklak mɨnɨm ak abe, wagɨn me nɨbak. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Mab ke eyaŋ kɨjoŋ kɨb ak mɨseŋ nɨŋɨl am tep gɨpal. Bin bɨ koŋai nep mɨgan nɨbak amebal. Nɨb ak, nɨbi nɨŋ rep gɨl, per mɨdep kɨjoŋ sɨkol ak nɨŋɨl amnɨmɨb. Kɨjoŋ sɨkol nɨbak koslam amnɨgal. Bin bɨ nokɨm nokɨm nep, kanɨb sɨkol par nɨbak kɨlɨs gɨl pɨyo nɨŋɨl amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pen bin bɨ God mɨnɨm agobɨn agɨl tom apal okok, kaj sipsip sain tep rek ulek lɨl onɨgal ak pen apɨl mɨdlɨg gɨ, kain sapeb bin bɨ suɨp rek ak nɨbep gɨnɨgal. Nɨb ak, nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bin bɨ mɨd tep gɨpal rek ulek lɨl onɨgal ak pen kɨri tap si tap tɨmel gɨnɨgal rek nɨŋɨl, kɨrop nɨŋ tep gɨnɨgabɨm. Nɨbi nɨpɨm, nag yokop ñu ñu sek okok magɨl ñɨŋeb ak pɨlek ma ju ñɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Mab okok ak rek nep gɨnɨgab. Mab magɨl ñɨŋeb bɨd okok, mab magɨl ma ñɨŋeb ma pɨlnɨgab. Pen mab magɨl ma ñɨŋeb bɨd okok, magɨl ñɨŋeb ma pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pen mab magɨl tep ma pɨlnɨgab okok, tɨb gɨ rɨk marɨk gɨ dam mab yɨneb eyaŋ yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nɨb ak, bin bɨ okok mɨñ gɨnɨgal ar ak nɨŋɨl, bin bɨ okok tep, bin bɨ okok tɨmel, agɨl nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bin bɨ yɨp, ‘Bɨ Kɨb cɨn!’ ‘Bɨ Kɨb cɨn!’ agebal okok magɨlsek, God kɨrop dɨl kod mɨdenɨgab, agɨl gos ak ma nɨŋnɨmɨb. Bapi yad seb kab ar alaŋ mɨdeb ak ageb rek gɨpal bin bɨ okok nep kɨrop dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","God bin bɨ mɨnɨm kɨb agnɨgab ñɨn ak, bin bɨ koŋai nep yɨp agnɨgal, ‘Bɨ Kɨb, cɨn bin bɨ nak nep. Yɨb nak nep agɨl, mɨnɨm nep ag ñɨnok. Yɨb nak nep agɨl, tap bin bɨ kɨjeki abaŋ ñagak okok ag yoknok. Yɨb nak nep agɨl, tap ma gep rek okok koŋai nep gɨnok,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yɨp nɨb agnɨgal ak pen yad kɨrop pen agnɨgain, ‘Yad nɨbep ma nɨŋölɨgɨpin; nɨbi gɨ tɨmel nep gɨpɨm ak, ke okok amnɨm!’ agnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Bɨ gos nɨŋ tep gɨnɨgab alap, karɨp ne ak gɨnɨg, kab mɨdenɨgab ar alaŋ gɨnɨgab. Kɨsen yɨgen kɨb apɨl, mɨñab kɨb pakɨl, ñɨg ulɨk apɨl gɨnɨgab ak pen karɨp ne kab ar alaŋ gɨ kɨlɨs gɨnɨgab ak, pag jɨsɨpɨk masɨpɨk gɨ ma dad amnɨgab. Nɨb ak rek me, bin bɨ mɨnɨm yad nɨŋɨl, nɨŋ dɨl, agebin rek gɨnɨgal bin bɨ okok. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","“Pen bɨ gos nɨŋ tep ma gɨnɨgab alap, karɨp ne ak gɨnɨg, lɨm kab kɨlɨp lenɨgab ar alaŋ gɨnɨgab. Kɨsen yɨgen kɨb apɨl, mɨñab kɨb pakɨl, ñɨg ulɨk apɨl, karɨp ne ak pɨs nep pag jɨsɨpɨk masɨpɨk gɨ dad amnɨgab. Nɨb ak rek me, bin bɨ mɨnɨm yad nɨŋɨl agebin rek ma gɨnɨgal bin bɨ okok,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas mɨnɨm nɨbak ag juek nɨŋlɨg gɨ, bin bɨ koŋai nep ap mɨdelak okok nɨŋɨl aglak, “God lo mɨnɨm ag ñeb bɨ cɨn okok mɨnɨm apal rek ma agɨp; ne bɨ mɨnɨm nɨŋ tep yɨb gɨp rek agɨp,” agɨl, wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas dɨm yɨrɨk alaŋ mɨdek ak kɨrɨg gɨl, mak eyaŋ ap yapek nɨŋlɨg gɨ, bin bɨ koŋai nep nop kɨsen gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pen bɨ soi sapeb lak bɨ alap, Jisas mɨdek ulep sɨŋak amɨl, kogɨm yɨmɨl, kɨbor kɨyan gɨl agak, “Bɨ Kɨb. Nak yɨp cɨb nɨŋɨl komɨŋ laŋ agɨl genɨgan ak, yɨp soi sapeb lɨp ak komɨŋ lɨnɨgab. Yɨp komɨŋ lenɨgab ak, yad God sobok gep karɨp mɨgan amnɨgain ak, yɨp mer ma agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nɨb agek, Jisas ñɨnmagɨl parsek lɨl bɨ nɨbak dɨ nɨŋɨl agak, “Yad gɨnɨgain; nep komɨŋ laŋ,” agek, won nɨbak nep nop komɨŋ lek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas bɨ nɨbak nop agak, “Nep gen komɨŋ lɨp nɨbak, bin bɨ ognap kɨrop ma ag ñɨnɨmɨn mer. Am bɨ God nop tap sobok gep bɨ okok kɨrop nep yomɨl agnɨmɨn, ‘Yɨp komɨŋ lɨp nɨŋɨm!’ agnɨmɨn. Nɨb agɨl, Mosɨs agak rek, yakɨr alap God nop pak sobok gɨ ñɨnɨmɨn. Nɨg genɨgan, bin bɨ okok nɨŋɨl agnɨgal, ‘Nop komɨŋ lɨp ak me nɨg geb,’ agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas taun sɨkol Kapaneam amek nɨŋlɨg gɨ, ami bɨ koŋai nep kod mɨdolɨgɨp bɨ kɨb alap, Jisas yɨp gɨ ñɨnɨmɨŋ agɨl apɨl Jisas nop agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bɨ Kɨb, bɨ wög gɨ ñeb yad ak nop mɨñak kɨb gɨl, yur bɨr gek, kaun ma gɨp; karɨp sɨŋak kɨm mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Agek, Jisas agak, “Yad am nop gen komɨŋ lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Agek, ami bɨ kɨb nɨbak agak, “Bɨ Kɨb, nɨŋɨd ageban ak pen yad bɨ kɨb rek karɨp yad ak onɨmɨn. Yad nɨpin ak, ami bɨ kɨb ognap yɨp kod mɨdel, yad pen ami bɨ ognap kɨrop kod mɨdɨl, ‘Amnɨm,’ agen, ambal sek; ‘Owɨm,’ agen, opal sek. Bɨ yɨp wög gɨp ak nop, wög okok nɨg gɨnɨmɨn nɨg gɨnɨmɨn agen, gɨp. Nɨb ak rek, nak yokop, ‘Komɨŋ laŋ,’ agenɨmɨn, nop komɨŋ lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nɨb agek Jisas wal agɨl, bin bɨ kɨsen amelak okok kɨrop agak, “Bɨ nɨbaul par okok nɨb ak pen, God gɨp rek nɨŋ tep yɨb gɨl me, nɨb agɨp. Bɨ cɨn Isrel nɨb alap, God nop nɨŋ dɨ kɨlɨs gɨl agɨp nɨbak rek agek, yad ma nɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nɨb ak, kɨsen bin bɨ par okok nɨb okok, God bin bɨ dɨl seb kab ar alaŋ kod mɨdenɨgab nab ak amɨl, Ebraham, Aisak, Jekop bɨ eip bɨsɨg gɨl, tap ñɨŋeb koŋai ñɨbɨl, mɨñ mɨñ gɨlɨg gɨ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kɨri nɨg gɨl am mɨdenɨgal, pen bin bɨ cɨn Isrel nɨb okok, am nab nɨbak ma mɨdenɨgal rek lɨp. God kɨrop ag yoknɨgab, am mɨdenɨgal söŋ kɨslɨm gɨp ar eyaŋ. Kɨri sɨl magɨl agɨl meg magɨl su pag pe pag gɨ ñɨblɨg gɨ mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nɨb agɨl, Jisas ami bɨ kɨb nɨbak nop agak, “Nak adɨk gɨ amnoŋ! Nɨŋ dɨl apan rek nep gɨnɨgab,” agak. Jisas nɨb agek, ne karɨp amɨl nɨŋak, bɨ ne tap gak ak, Jisas agak won nɨbak nep komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pen Jisas Pita karɨp amɨl nɨŋak, Pita nɨbor ak, mɨb goŋ okok mab rek yɨnek, abañ ar alaŋ kɨm mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas nɨŋɨl, am Pita nɨbor ñɨnmagɨl kɨd nop dɨ nɨŋek nɨŋlɨg gɨ, magɨl nɨbak nep komɨŋ lek, ne warɨkɨl, Jisas nop tap magɨl dɨ lɨ rep gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dɨgep won ak, bin bɨ kɨjeki abaŋ ñagak okok abe, bin bɨ tap gak okok abe, dam Jisas mɨdek sɨŋak apelak, ne kɨjeki okok ag söŋ yokɨl, bin bɨ ñɨ pai tap gak okok gek magɨlsek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ne gak nɨbak, bɨ God mɨnɨm agep Aisaia, bɨrarɨk nep gɨnɨgab agɨl ñu kɨl tɨkak rek nep gak. Ne ñu kɨl tɨkɨl agak, “Cɨnop tap gak okok gek komɨŋ lak. Tap tari tari cɨnop tɨmel gak okok ag yokek mɨd tep gɨpɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas nɨŋak, bin bɨ koŋai nep apɨl nop pɨŋɨl kɨs kɨs gelak, bɨ ne okok kɨrop agak, “Ñɨg cöb juɨl pɨs adaŋ amnɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nɨb agek nɨŋlɨg gɨ, God lo mɨnɨm ag ñeb bɨ alap apɨl nop agak, “Mɨnɨm ag ñeb bɨ. Nak karɨp lɨm akal akal amnɨgan ak, yad nak eip amnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Agek, Jisas agak, “Kain saköl okok, kɨri lɨm mɨgan okok kɨnbal. Yakɨr okok, kau kɨri kɨneb ak mɨdeb. Pen yad Bɨ Ñɨ ne kɨneb mɨgan ak ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pen bɨ Jisas nop nɨŋ dak bɨ alap agak, “Bɨ Kɨb, yad nak eip amnɨm ak pen, yɨp yau agek, bapi nop kɨmek tɨgel gɨl, nak eip ajenɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Agek, Jisas agak, “Bin bɨ yɨp ma nɨŋ dɨpal ognap kɨmenɨmel, bin bɨ yɨp ma nɨpal ognap dam tɨgel gɨnɨmel; pen nak apek yad eip amnɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas ñɨg magöb dɨl amnɨg gek, bɨ ne okok eip paŋdɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ñɨg nab sɨŋak amelak nɨŋlɨg gɨ, dai yɨgen kɨb yɨb ak dɨl, ñɨg pag apɨl, ñɨg magöb ak tɨg adɨk gɨnɨg rek gak. Pen Jisas ne wɨsɨn kɨnek rek, ");
INSERT INTO kmh_m_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","bɨ ne okok nop am agel warɨkek aglak, “Bɨ Kɨb! Yɨgen asad kɨb ak cɨnop tɨg adɨk gek, ñɨg ñɨŋjɨn rek lɨp ak, nak cɨnop dɨ komɨŋ yokan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Agelak, kɨrop agak, “Tari gɨnɨg pɨrɨkebɨm? Nɨbi mɨnɨm yad sɨkol sɨkol ognap ma nɨŋ dɨpɨm ar?” agak. Nɨb agɨl, warɨkɨl, yɨgen asad dek ak agek kɨr gɨl, ñɨg pag apek ak abe pɨgɨl gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nɨg gek, kɨri wal agɨl aglak, “Bɨ kal yɨb aul ne bɨ titi bɨ rek mɨdɨl agek yɨgen asad dosɨp ak kɨrɨg gɨl, ñɨg pag aposɨp ak kɨrɨg gɨl gɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ñɨg juɨl, karɨp lɨm Gadara pɨs adaŋ amjakek nɨŋlɨg gɨ, bɨ saköl kɨjeki abaŋ ñagak omal cɨp tɨgel gölɨgɨpal kab mɨgan okok nɨb apjakrek. Bɨ nɨb omal kɨrop kɨjeki kɨyob ñɨlɨk abaŋ ñagak rek, bɨ sapeb yɨb omal mɨderek. Kɨri mɨdölɨgɨpir sɨŋak, bin bɨ ognap kanɨb par nɨbak ma tagelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pen kɨri mal apjakɨl, Jisas nop agrek, “God Ñɨ ne. Tari gɨnɨg apeban? Cɨnop yur kɨb ñɨnɨg apeban aka? Ñɨn nak cɨnop karɨp lɨm tɨmel ag yokep ñɨn ak ma owɨp,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pen magɨl nɨbak nep, kaj koŋai nep amɨl ñɨbelak ulep gol nɨb sɨŋak me, ");
INSERT INTO kmh_m_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kɨjeki kɨyob ñɨlɨk bɨ nɨb omal kɨrop abaŋ ñagak okok, Jisas nop neb neb gɨlɨg gɨ aglak, “Cɨnop ag yoknɨg genɨmɨn ak, agek, cɨn amɨl kaj mɨdebal okdaŋ kɨrop yɨpɨl sɨkɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Agelak, Jisas “Amnɨm,” agek, bɨ nɨb omal kɨrop yem gɨ amɨl kaj okok kɨrop yɨpɨl sɨklak. Yɨpɨl sɨkel kaj okok pɨg ju lɨm mɨdɨŋ gol sɨŋak amɨl, gɨ dam ñɨg cöb eyaŋ pakɨl, ñɨg ñɨbɨl, magɨlsek kɨm saklak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pen bɨ kaj mɨkelak okok, gak nɨbak nɨŋɨl, kasek taun sɨŋak amɨl, Jisas tari tari gak ak, bɨ kɨjeki abaŋ ñagak omal tari tari gak mɨnɨm ak, bin bɨ okok kɨrop magɨlsek ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ag ñelak, bin bɨ taun mɨdelak nɨb okok magɨlsek Jisas nop nɨŋɨn agɨl, ap nop nɨŋɨl, neb neb gɨlɨg gɨ aglak, “Karɨp lɨm cɨn aul kɨrɨg gɨl, ke okok amnoŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas kauyaŋ ñɨg magöb dɨl, ñɨg cöb juɨl, karɨp lɨm ne kɨnolɨgɨp ak pɨs kɨd adaŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pen bin bɨ ognap, bɨ ñɨnmagɨl tob kalau gak alap, Jisas gek komɨŋ lɨnɨgab, agɨl, nop yɨr ar lɨl dapɨl Jisas mɨdek sɨŋak dolak. Pen, Jisas gek komɨŋ lɨnɨgab, agɨl nɨŋlak rek, Jisas bɨ ñɨn tob kalau gak nɨbak nop agak, “Ñɨ aul! Gos sek mɨdenɨmɨn. Tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jisas nɨb agek, God lo mɨnɨm ag ñeb bɨ okok ognap aglak, “Bɨ aul God nop ag julɨg gɨ me nɨb ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pen Jisas gos kɨri nɨŋlak nɨbak ke nɨŋɨl agak, “Nɨbi tari gɨnɨg yɨp gos tɨmel nɨŋɨl nɨb agebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yad nop, ‘Tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gebin,’ agen, nɨbep tep gɨnɨgab, akaŋ ‘Warɨk amnoŋ!’ agen, nɨbep tep gɨnɨgab? Akaŋ mɨnɨm tari agen, nɨbep tep gɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mɨñi nɨbi nɨŋnɨgabɨm, Bapi God yɨp Bɨ Ñɨ ne ag lak nɨŋɨl, yad lɨm dai wagɨn aul apɨl, tap si tap tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨnɨgain, agnɨgain ak, kɨrɨg gɨnɨgain,” agak. Jisas nɨb agɨl, bɨ ñɨn tob kalau gak ak nop agak, “Warɨkɨl, mɨj nak bad pɨyak wɨnɨg dɨl, karɨp nak amnoŋ!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jisas nɨb agek, bɨ nɨbak warɨkɨl mɨj bad ne ak wɨnɨg dɨl karɨp ne amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Karɨp ne amek nɨŋlɨg gɨ, bin bɨ okok nɨŋɨl, God agek Jisas apɨl geb, agɨl, pɨrɨkɨl, bɨ alap lɨm dai wagɨn aul nɨb aknɨb rek gek ma nɨpɨn agɨl, God yɨb nop agel ar amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas karɨp lɨm nɨbak kɨrɨg gɨl, mɨgan alap amɨl nɨŋak, bɨ takɨs dep wög golɨgɨp bɨ alap karɨp ñɨlɨk mɨgan ak bɨsɨg mɨdek. Bɨ nɨbak yɨb ne Matyu. Jisas nop nɨŋɨl agak, “Nak owan e, yad eip ajor!” agek, warɨkɨl Jisas eip amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas bɨ ne okok eip Matyu karɨp amɨl, tap ñɨbel nɨŋlɨg gɨ, bɨ takɨs dep okok abe, bɨ tap si tap tɨmel gölɨgɨpal bɨ okok abe, koŋai nep apɨl Jisas bɨ ne okok eip tap ñɨbelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tap ñɨbelak, bɨ Perisi okok nɨŋɨl, Jisas bɨ ne okok kɨrop aglak, “Mɨnɨm ag ñeb bɨ nɨbi ak, ne tari gɨnɨg, bɨ takɨs dep okok abe, bin bɨ tap si tap tɨmel gɨpal okok abe, eip jɨm ñɨl tap ñɨbeb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Agelak, Jisas mɨnɨm nɨbak peyɨg nɨŋɨl agak, “Bin bɨ tap ma gɨp okok, soi ñon gep bɨ okok ma ambal; bin bɨ tap gɨp okok nep soi ñon gep bɨ okok ambal. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pen God mɨnɨm alap agak wagɨn ak nɨŋ tep gɨl mɨdenɨmɨb. Ne agak, ‘Yɨp tap sobok gɨ ñɨnɨgabɨm ak, yɨp tep ma gɨnɨgab; pen bin bɨ okok kɨrop yɨmɨg nɨŋɨl, gɨ tep genɨgabɨm ak, yɨp tep gɨnɨgab,’ agak. Pen yad onek ak, bin bɨ, cɨn bin bɨ tep, mɨd tep gɨpɨn agɨl gos nɨpal bin bɨ okok, kɨrop pɨyo nɨŋ dɨnɨg ma onek; yad bin bɨ, cɨn tap si tap tɨmel gɨpɨn agɨl gos nɨpal bin bɨ okok, kɨrop pɨyo nɨŋ dɨnɨm agɨl onek,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ñɨn alap, Jon ñɨg pak ñeb bɨ ne okok, Jisas mɨdek sɨŋak apɨl aglak, “Cɨn abe, bɨ Perisi okok abe, ñɨn ognap, God nop nep gos nɨŋɨn, agɨl, tap ma ñɨbɨn. Pen bɨ nak okok tari gɨnɨg ak rek nep ma gɨpal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Agelak, Jisas kɨrop agak, “Bin bɨ okok, bɨ bin dɨnɨg geb bɨ ak eip mɨdenɨgal ñɨn ak, mɨñ mɨñ gɨlɨg gɨ tap ñɨŋnɨgal; pen bɨ ognap apɨl bɨ nɨbak nop tɨg junɨgal ñɨn ak, yɨmɨg gek tap bɨl gɨl ma ñɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pen Jisas ne kɨrop mɨnɨm alap sɨd tɨkɨl agak, “Walɨj kɨsen alap dɨl, walɨj ajɨl gɨ, pɨg gɨ rɨk gɨnɨgab tam ak ñag dör ma gɨnɨgal. Pen ti gɨnɨg gɨl ñag dör ma gɨnɨgal? Nɨg genɨgal ak, walɨj wör gebin agnɨgab, mɨgan kɨb yɨb pak bɨl bɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pen ñɨg wain ak, ak rek nep. Wain kɨsen nɨb gɨl, dɨ kaj meme wak mɨlep mɨgan ak ma pag lɨnɨgal. Pen tari: nɨg genɨgal ak, ñɨg wain komɨŋ ak tanɨl, bɨŋ yɨb agɨl, kaj meme wak ak pɨg gɨ rɨk gɨl, soŋ gɨl amnɨgab. Nɨb ak, ñɨg wain komɨŋ ak dɨl, kaj meme wak komɨŋ nɨb mɨgan ak dɨ lel nep me, tep gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas mɨnɨm nɨbak agek nɨŋlɨg gɨ, Juda bɨ kɨb alap Jisas mɨdek sɨŋak apɨl, kogɨm yɨmɨl agak, “Pai yad ak pɨs nep kɨmɨb ak pen nak am nop dɨ nɨŋek, warɨknɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Agek, Jisas bɨ ne okok eip warɨkɨl, bɨ nɨbak eip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pen adɨkeyan alap, lakañ yaplɨg gɨ yaplɨg gɨ mɨdek, mɨ aknɨb umɨgan alaŋ yɨnak. Nɨg gek, gos ne ak nep nɨŋɨl, “Jisas walɨj ne par kɨb gol okok nep dɨ nɨŋen, yɨp komɨŋ lɨnɨgab,” agɨl, Jisas amek nɨŋlɨg gɨ, kɨd ken okok amɨl, walɨj nop ak dɨ nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dɨ nɨŋek, Jisas adɨk gɨl adɨkeyan nɨbak nop nɨŋɨl agak, “Yɨp nɨŋ dɨpan ak me, nep komɨŋ lɨp. Gos sek mɨdenɨmɨn,” agak. Agek, tap nop golɨgɨp ak won nɨbak nep komɨŋ lek, lakañ apolɨgɨp ak mɨlep gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pen Jisas adɨklon adɨkeyan nɨb okok kɨrop kɨrɨg gɨl amɨl, bɨ kɨb karɨp ak amjakɨl nɨŋak, akɨl magɨl pɨglɨg gɨ, mɨnɨm saköl kɨb yɨb agelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas nɨŋɨl kɨrop agak, “Nɨbi ke okok amnɨm! Pai aul ma kɨmɨb; yokop wɨsɨn kɨneb,” agak. Nɨb agek, nop sɨk aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pen Jisas bin bɨ nɨb okok kɨrop ag söŋ yokɨl, karɨp ñɨlɨk mɨgan eyaŋ amɨl, pai kɨmak ak nop, ñɨnmagɨl kɨd ak dɨ nɨŋek, warɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nɨg gek, mɨnɨm nɨbak yɨg dad karɨp lɨm nɨb okok magɨlsek dɨ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pen Jisas karɨp lɨm nɨbak kɨrɨg gɨl amek nɨŋlɨg gɨ, bɨ udɨn magɨl kwoi gak omal nop sain gɨlɨg gɨ, meg mɨgan dap ranlɨg gɨ agrek, “Depid Ñɨ ne! Cɨrop mal yɨmɨg nɨŋan!” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nɨb agerek, pen Jisas ne karɨp ñɨlɨk mɨgan eyaŋ amnak. Bɨ nɨb omal sain amɨl karɨp ak amjakrek, Jisas kɨrop mal agak, “Nɨri mal, yad nɨrep gen komɨŋ lɨnɨgab agɨl, yɨp apɨl agebir? Yad yau agnɨgain, nɨri gos nɨpir udɨn nɨri ñɨl nɨŋnɨgair aka mer?” agak. Agek, agrek, “Yau. Bɨ Kɨb, cɨr mal nɨg gos nɨpɨr,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Agerek, Jisas udɨn kɨrop mal dɨ nɨŋɨl agak, “Yɨp nɨŋ dɨpir ak me, apir rek gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Agek, udɨn kɨrop mal komɨŋ lek, udɨn ñɨl nɨŋer nɨŋlɨg gɨ, Jisas kɨrop mal mɨnɨm kɨlɨs agɨl ag tep gɨl agak, “Bin bɨ nɨb okok, Jisas gek cɨrop komɨŋ lɨp, agɨl ma ag ñɨnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nɨb agak ak pen kɨri mal amɨl, bin bɨ karɨp lɨm nab nɨb okok magɨlsek ag ñer amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pen kɨri mal amer nɨŋlɨg gɨ, bin bɨ ognap, bɨ kɨyob ñɨlɨk sek aleb adɨk gak bɨ alap, dap Jisas mɨdek sɨŋak dapelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas kɨyob ñɨlɨk bɨ nɨbak nop abaŋ ñagak ak ag yokek, mɨnɨm ag tep gak. Nɨg gek, bin bɨ okok wal agɨl aglak, “Karɨp lɨm Isrel aul, bɨ alap nɨb aknɨb rek gek ma nɨpɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pen bɨ Perisi okok aglak, “Ne kɨjeki kɨyob ñɨlɨk nap kɨri Seten kɨlɨs ak dɨl me, kɨyob ñɨlɨk okok ag söŋ yokeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pen Jisas ne taun sɨkol okok abe, taun kɨb okok abe gɨ ajlɨg gɨ, Juda mogɨm gep karɨp okok amɨl, Kiŋ kɨb ke yɨb ak bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak ag ñak. Pen bin bɨ okok kɨrop tap tari tari gak ak, ak rek nep gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jisas nɨŋak, bin bɨ nɨb okok kaj sipsip okok bɨ kod mɨdep kɨri alap ma mɨdeb rek ak mɨdelak. Gos par nɨŋɨl koslam mɨdelak ak pen kɨrop bɨ gɨ ñeb alap ma mɨdek. Nɨb ak nɨŋɨl, Jisas ne mapɨn yɨb nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","bɨ ne okok kɨrop agak, “Tap magɨl koŋai yɨb nep wög dai sɨŋak pɨlɨl pok gɨ mɨdeb ak pen bin bɨ pag dowep koŋai ma mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nɨb ak, nɨbi Bɨ Kɨb wög dai nap nɨb ak nop ag nɨŋem, bɨ pag dowep ognap sek ag yokek, pag dap nop pɨs ken dolaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas bɨ ne aknɨb umɨgan alaŋ kɨrop sɨk agek apelak agak, “Yad ke nɨbep agebin ak me, kɨjeki kɨyob ñɨlɨk tap okok ag yoknɨg, ag yoknɨgabɨm. Bin bɨ tap tari tari gɨnɨgab okok ak rek nep gem, komɨŋ lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bɨ Jisas mɨnɨm dad ameb aknɨb umɨgan alaŋ Jisas ag yokak bɨ okok, yɨb kɨri okok me, bɨ alap Saimon, yɨb ne alap Pita agölɨgɨpal; bɨ alap Edru, Pita nɨmam ne ak; bɨ alap Jems, Sebedi ñɨ ne; bɨ alap Jon, Jems nɨmam ne; ");
INSERT INTO kmh_m_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","bɨ alap Pilip; alap Batolomyu; alap Tomas; alap Matyu, ne takɨs dolɨgɨp; bɨ alap Jems, Alpias ñɨ ne; bɨ alap Tadias; ");
INSERT INTO kmh_m_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bɨ alap Saimon, yɨb ne alap Selot agölɨgɨpal; bɨ alap Judas Iskariot, ne me kɨsen Jisas nop mɨmɨg nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas bɨ ne nɨb okok kɨrop mɨnɨm tep wög ak gɨnɨmel agɨl, kɨrop ag ke ke yoklɨg gɨ agak, “Nɨbi Juda bin bɨ mer nab okok abe, Sameria kai mɨdebal nab okok abe, ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pen nɨbi amɨl bin bɨ cɨn Isrel, bin bɨ kɨri God nop gos ma nɨpal okok, kɨrop ag ñɨlɨg gɨ agnɨmɨb, ");
INSERT INTO kmh_m_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“God bin bɨ dɨl kod mɨdenɨgab ñɨn ak, bɨr maŋ apeb,” agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bin bɨ tap gɨnɨmɨŋ okok gem, komɨŋ lɨnɨmɨŋ. Bin bɨ pɨs nep kɨmlak okok gem, kauyaŋ warɨknɨmel. Bin bɨ soi sapeb lɨnɨmɨŋ okok gem, komɨŋ lɨnɨmɨŋ. Bin bɨ kɨjeki kɨyob ñɨlɨk abaŋ ñagnɨmɨŋ okok ag söŋ yokem amnɨmɨŋ. Bapi cɨr apɨl nɨbep per yokop wög gɨpɨr rek, nɨbi ak rek nep bin bɨ nɨb okok kɨrop yokop wög gɨ ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kab magɨl gol, kab magɨl silpa, kab magɨl lakañ ognap ma dad amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wad, walɨj ognap sek, tob tɨrɨp, yɨr dai, tap okok ma dad amnɨmɨb. Pen tari: bin bɨ wög gɨ ñɨnɨgal okok pen tap ñel ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pen taun alap akaŋ karɨp tɨrɨg tɨroŋ alap amjakem, bin bɨ nɨbep ag wasu dɨnɨmel rek ognap nɨŋɨl, kɨrop eip nep mɨdɨl, karɨp lɨm ke alap okok amnɨg gɨnɨgabɨm ñɨn ak nep, kɨrop kɨrɨg gɨl amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","14","Pen karɨp alap amɨl, “Nɨbi mɨdebɨm!” agem, “Yau, mɨdobɨn; tep apebɨm,” agenɨmel, karɨp ñɨlɨk mɨgan nɨbak amnɨmɨb. Pen kɨrop mɨnɨm yad ag ñem ag wasu ma denɨmel ak, kɨrɨg amnɨg, acɨp acɨp tob kɨd nɨbi cɨg dɨl mɨdonɨmɨŋ ak, tau lɨlɨg gɨ yokɨl amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yad nɨbep nɨŋɨd yɨb agebin: mɨnɨm kɨb agep ñɨn ak, Sodom Gomora bin bɨ yur sɨkol sɨkol dɨnɨgal; bin bɨ nɨbep ma dɨnɨgal nɨb okok, yur kɨb yɨb dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pen nɨŋɨm! Yad nɨbep kaj sipsip rek ak, bin bɨ kain saköl rek mɨdebal nab okok ag yokebin. Nɨb ak, gos nɨŋ rep gɨlɨg gɨ, kapkap kɨrop ag ñɨlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Pen bin bɨ ognap nɨbep dɨ wös gɨl, dam Juda mogɨm gep karɨp okok amel, kansol kɨri okok ap mɨnɨm kɨb agɨl, nɨbep paknɨgal. Nɨb ak, nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nɨbep bɨ yad mɨdebɨm agɨl, lɨp gɨ dam gapman bɨ kɨb akaŋ kiŋ mɨdenɨgal sɨŋak dad amel, nɨbi mɨnɨm tep yad ak, bɨ kɨb okok abe, Juda bin bɨ mer karɨp lɨm par kɨb okok nɨb okok abe, kɨrop ag ñɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Nɨbep mɨnɨm kɨb agnɨgal nɨbak, mɨnɨm tari ar agɨn akaŋ mɨnɨm titi gɨl agɨn, agɨl, pɨrɨkɨl, gos par ma nɨŋnɨmɨb. Nɨbi mɨnɨm agem nɨŋlɨg gɨ, Nap God Kaun ne nɨbep eip mɨdeb ak, gos tep ñek nɨŋlɨg gɨ, mɨnɨm gos nɨbi ke ma agnɨgabɨm; Nap God Kaun ne nɨbep agnɨgab rek nep agnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ñɨn nɨbak, nɨmam sɨkop okok warɨkɨl, nɨmam kɨri ke okok ñag paklaŋ agɨl, bɨ kɨb okok kɨrop mɨmɨg gɨnɨgal. Nap sɨkop okok warɨkɨl, ñɨ pai kɨri ke okok ñag paklaŋ agɨl, bɨ kɨb okok kɨrop mɨmɨg gɨnɨgal. Ñɨ pai okok warɨkɨl, nonɨm nap kɨri ke okok kɨd ñɨl ak rek nep gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yɨp pɨs ken ar mɨdenɨgabɨm rek, bin bɨ okok magɨlsek nɨbep nɨŋel, mɨlɨk kal yonɨgab. Pen bin bɨ an an kɨlɨs gɨl, yad eip nep mɨdenɨgal okok, ñɨn kɨsen ak apek, God kɨrop dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pen mɨgan alap amem, nɨbep gɨ tɨmel genɨmel ak, pɨrɨk gɨ mɨgan alap amnɨmɨb. Yad nɨbep nɨŋɨd agebin, Isrel taun okok bin bɨ okok kɨrop ag ñem ma amnɨgab adek, yad Bɨ Ñɨ ne onɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Ñɨ pai skul apal okok kɨb mɨdel, ag ñeb bɨ kɨri okok sɨkol ma mɨdebal. Pen ag ñeb bɨ mɨdeb rek mɨdon agɨl me, skul apal. Bin bɨ wög gɨ ñɨbal okok kɨb mɨdel, bin bɨ kɨrop kod mɨdebal okok sɨkol ma mɨdebal. Wög gɨpal ak, bin bɨ kɨb mɨdebal rek mɨdon agɨl, wög gɨpal. Nɨb ak rek, bin bɨ yad okok, yad mɨdebin rek mɨdon agɨl, gɨpal. Pen bin bɨ okok yɨp ag juɨl, Seten yɨb ne alap lɨl yɨp Bielsebul apal rek, nɨbep bɨ wög gɨ ñeb yad ak rek nep ag juɨl mɨnɨm tɨmel agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bin bɨ okok kɨrop nɨŋɨl ma pɨrɨknɨmɨb. Mɨnɨm tari mɨñi karɨkɨl mɨdeb ak, kɨsen mɨseŋ mɨdenɨgab. Tap tari kɨri kapkap gɨ we gɨl gɨpal okok, kɨsen mɨseŋ lek nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mɨnɨm yad nɨbep we gɨl agnɨgain ak, nɨbi am kɨrop mɨseŋ ag ñɨnɨmɨb. Mɨnɨm yad nɨbep tɨmɨd wagɨn agnɨgain ak, karɨp ar alaŋ amɨl, mɨnɨm kɨb ag ñem nɨŋnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Nɨbi bin bɨ ñag pak lɨpal bɨ okok nɨŋem jel gek ma pɨrɨknɨmɨb. Kɨri yokop mɨb goŋ ak nep ñag pak lɨnɨgal; kaun ak sek gɨ tɨmel gɨnɨmel rek ma lɨp. Pɨrɨk gɨnɨg me, Bɨ Kɨb bin bɨ mɨb goŋ abe kaun abe mab ke yɨneb mɨgan eyaŋ dɨ yoknɨgab nɨbak nep pɨrɨknɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yakɨr sɨkol okok, tap yokop. Kab magɨl lakañ nokɨm nep yokɨl, yakɨr omal dɨpal. Tap yokop ak pen, God kɨrop nɨŋ mɨdeb rek, alap yokop ma yap paknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kɨmkas nɨbep ak, God magɨlsek wök pagɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nɨb ak, ma pɨrɨknɨmɨb. Yakɨr okok tap sɨkol yɨb; nɨbi pen tap yɨb mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bin bɨ an an yɨp pɨs ken ar mɨdɨl, bin bɨ okok kɨrop mɨseŋ ag ñenɨgal okok, yad pen Bapi yad seb kab ar alaŋ mɨdeb ak nop, yɨp pɨs ken ar mɨdebal, agɨl, mɨseŋ agnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pen bin bɨ an an yɨp cɨg tep ma gɨl, bin bɨ eip mɨdenɨgal nab sɨŋak agnɨgal, bɨ nɨbak yad ma nɨpin, agnɨgal ak, yad pen Bapi yad seb kab ar alaŋ ak nop, bin bɨ sɨŋaul yad ma nɨpin, agnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yad lɨm dai wagɨn aul onek ak, ‘Jisas ne lɨm dai wagɨn aul owak rek, kapkap mɨd tep gɨnɨgabɨn,’ agɨl, gos ak ma nɨŋnɨmɨb. Yad onek ak me, bin bɨ okok mɨnɨm kɨb agɨl, pen pen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nɨb gɨnɨgab: ñɨ okok warɨkɨl, nap bɨ eip pen pen gɨnɨgal. Pai okok warɨkɨl, nonɨm eip pen pen gɨnɨgal. Ñɨne bin okok warɨkɨl, nɨpɨs eip pen pen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nɨg gɨnɨgal nɨbak, karɨp kɨri nokɨm kɨn mɨdebal ak, kɨri ke nep pen pen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bin bɨ an an nonɨm nap akaŋ ñɨ pai kɨri okok nep mɨdmagɨl lɨl, yɨp mɨdmagɨl ma lɨnɨgal ak, bin bɨ yad mɨdenɨmel rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bin bɨ an an yad eip mɨdnɨg gos nɨŋnɨgal ak pen gos alap nɨŋɨl agnɨgal, ‘Bin bɨ ognap cɨnop gɨ tɨmel gɨnɨmel rek lɨp,’ agɨl, mab kros kɨri dɨ ka gɨl yɨp sain ma gɨnɨgal ak, bin bɨ yad mɨdenɨmel rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bin bɨ an, yad ke ausek mɨdɨl, mɨd tep gin agnɨgab ak, mab ke yɨneb eyaŋ amnɨgab. Bin bɨ an pen agnɨgab, yad Jisas pɨs ken mɨden, yɨp ñag pak lɨnɨg, ñag pak lɨlaŋ, agnɨgab ak, komɨŋ per per mɨdep ak dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nɨbi amem, bin bɨ ognap nɨbep ag wasu denɨmel ak, yɨp abe ag wasu dɨnɨgal. Pen yɨp ag wasu dɨnɨgal rek, Bɨ yɨp ag yokek onek ak nop abe ag wasu dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bin bɨ an, God mɨnɨm agep bɨ alap nɨŋɨl agnɨgab, ‘Bɨ owɨp aul, God wög gɨp ak me, nop dɨnɨgain,’ agɨl dɨnɨgab ak, tep yɨb gɨnɨgab. God mɨnɨm agep bɨ nɨbak dɨ tep gɨnɨgab rek, kɨsen God nop ak rek nep dɨ tep gɨnɨgab. Bin bɨ an, God bin bɨ komɨŋ tep ne alap nɨŋɨl agnɨgab, ‘Bɨ owɨp aul, God bɨ komɨŋ tep ne ak me, nop dɨnɨgain,’ agɨl dɨnɨgab ak, tep yɨb gɨnɨgab. God bin bɨ komɨŋ tep ne ak dɨ tep gɨnɨgab rek, kɨsen God nop ak rek nep dɨ tep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pen bin bɨ an, bɨ yokop yad alap nɨŋɨl, Jisas bɨ ne ak agɨl, ñɨg mɨl dap ñɨnɨgab ak, God nɨŋek, tep gek, pen yɨpɨn ma gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas bɨ ne aknɨb umɨgan alaŋ okok kɨrop nɨg gɨl nɨg gɨl gɨnɨmɨb agɨl ag ñɨ tep gɨl, karɨp lɨm nɨbak kɨrɨg gɨl, taun yokop ulep nɨb okok amɨl, bin bɨ okok kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pen Jon bɨ ñɨg pak ñeb ak mɨñ mɨdɨl, Krais tari tari gak mɨnɨm ak nɨŋɨl, bɨ ne ognap ag yokek, Jisas mɨdek sɨŋak amjakɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nop ag nɨŋɨl aglak, “Cɨnop ag ñan, nak bɨ ‘Krais’ agɨl per kod mɨdobɨn ak nep opan akaŋ cɨn bɨ kɨsen nɨb bɨ alap ke kod mɨdon?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Agelak, Jisas kɨrop pen agak, “Nɨbi Jon mɨdeb sɨŋak amɨl agnɨmɨb, ‘Cɨn amɨl udɨn cɨn ke nɨŋɨl, tɨmɨd cɨn ke nɨpɨn, ");
INSERT INTO kmh_m_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bɨ nɨbak bin bɨ udɨn kwoi gɨp okok gosɨp udɨn ñɨl nɨpal. Bin bɨ tob tɨmel gɨp okok gosɨp kanɨb tag tep gɨpal. Bin bɨ soi sapeb lɨp okok gosɨp mɨlep gɨp. Bin bɨ tɨmɨd mɨgan pɨlɨŋ gɨp okok gosɨp gos pɨwakek nɨpal. Bin bɨ kɨmbal okok gosɨp kauyaŋ warɨkpal. Bin bɨ yɨm gep rek okok, ak rek nep Krais mɨnɨm tep ak agek nɨpal,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pen mɨnɨm alap agnɨmɨb, ‘Bin bɨ yɨp nɨŋ dɨl, gos alap alap ma nɨŋnɨgal okok, mɨñ mɨñ yɨb gɨnɨgal,’ agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nɨb agek, Jon bɨ ne okok amel nɨŋlɨg gɨ, Jisas bin bɨ ap mɨdelak okok kɨrop Jon mɨnɨm ar ak agɨl agak, “Nɨbi ned mɨñ mab kab nep mɨdeb nab okok ambek ñɨn ak, tari nɨŋnɨg ambek? Sɨd par nokɨm alap yɨgen dɨ adaŋ aul gɨp alap nɨŋnɨg ambek aka? ");
INSERT INTO kmh_m_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Akaŋ tari nɨŋnɨg ambek? Bɨ walɨj tep tep nep lɨpal bɨ alap nɨŋnɨg ambek aka? Bɨ walɨj tep tep dɨn agɨl nɨpal okok, bɨ kɨb karɨp kɨl tep okok kɨnbal. Kɨri Jon mɨdolɨgɨp mɨñ mab nep nab sɨŋak ma kɨnbal. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pen tap tari nɨŋnɨg ambek? Yokop ma ambek. Jon bɨ God mɨnɨm agep bɨ nɨbak nɨŋnɨg ambek. Bɨ God mɨnɨm agep onɨgab, agɨl kod mɨdelɨgɨpɨm me, bɨ nɨbak me ak. Pen Jon ne God mɨnɨm agep bɨ alap nep mer. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon nop gos nɨŋɨl, bɨrarɨk nep God ne Ñɨ ne nop mɨnɨm agak mɨnɨm nɨbak, God Mɨnɨm eyaŋ ñu kɨl tɨkɨl aglak, ‘Bɨ mɨnɨm agep yad ak, ag yoken ned amɨl, bin bɨ okok ag ñɨ tep gek, kɨsen nak ke amnɨgan,’ agɨl ñu kɨl tɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nɨbep nɨŋɨd agebin, bin bɨ lɨm dai wagɨn aul mɨdebal okok, nokɨm alap Jon rek mer. Pen God bin bɨ yokop yɨb dam seb kab ar alaŋ sɨŋak kod mɨdenɨgab okok, kɨri Jon rek ma mɨdenɨgal; God ne bin bɨ yokop yɨb okok dɨ tep yɨb gek, bin bɨ tep ne yɨb mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon bɨ ñɨg pak ñeb bɨ apɨl mɨnɨm tep ag ñak ñɨn ak tɨkɨl, bin bɨ okok, God cɨnop dɨl seb kab ar alaŋ sɨŋak kod mɨdonɨmɨŋ agɨl, mɨnɨm nɨbak kɨlɨs yɨb gɨ dam dam, mɨñi ak rek nep kɨlɨs yɨb gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Bɨ God mɨnɨm agep mɨnɨm ñu kɨl tɨklak okok abe, Mosɨs God lo mɨnɨm ñu kɨl tɨkak ak abe, wagɨn ak me, God Mesaia ak nop ag yokek, ne bin bɨ okok kɨrop dɨl kod mɨdenɨgab. Mɨnɨm nɨbak nep ag dapel dapel me, Jon owak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pen mɨnɨm agnɨg gebin ak dɨnɨgabɨm akaŋ ma nɨpin. God Jon nop agek, apɨl bin bɨ okok kɨrop mɨnɨm ag ñak ak, God Mɨnɨm ñu kɨl tɨkɨl, gɨnɨgab aglak rek nep gak. Ñu kɨl tɨkɨl aglak, bɨ God mɨnɨm agep Ilaija rek bɨ alap onɨgab, aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bin bɨ mɨñi ñɨn aul mɨdebal okok yad nɨpin, kɨri ñɨ paiŋaŋ ognap maker sɨŋak bɨsɨg gɨl, ñɨ paiŋaŋ ognap meg mɨgan dap ranɨl kɨrop apal rek ak mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kɨri apal, ‘Cɨn akɨl pɨgon, nɨbi tari gɨnɨg kogɨm ma papɨm? Kɨmep sɨl agep rek alap agon, nɨbi tari gɨnɨg sɨl ma apɨm?’ apal. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nɨb ak rek, God Jon nop ag yokek apɨl, ñɨn ognap tap magɨl ma ñɨbɨl, ñɨg wain ma ñɨbɨl gek, apal, ‘Bɨ nɨbaul nop tap tari abaŋ ñagek nɨg gɨp?’ apal. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bɨ Ñɨ ne pen apek apal, ‘Bɨ tap kɨb ñɨbɨl, ñɨg wain ñɨbɨl, bɨ takɨs dɨpal okok eip ajɨl, bɨ tap si tap tɨmel gɨpal okok eip ajɨl gɨp,’ apal. Pen bin bɨ God Mɨnɨm ak nɨŋ dɨl, gɨ tep gɨl, mɨd tep gɨnɨgal ak, bin bɨ okok nɨŋɨl agnɨgal, God Mɨnɨm ak mɨnɨm tep yɨb, agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Jisas taun kɨb ned gɨ ajɨl, tap ma gep koŋai nep gek, bin bɨ okok nɨŋlak ak pen kɨri, tari gɨnɨg tap si tap tɨmel gɨpɨn agɨl, tap si tap tɨmel gölɨgɨpal ak kɨrɨg gɨl, Jisas nop ma nɨŋ dɨlak. Nɨg gel, Jisas kɨrop ag gɨl agak, “Korasin taun bin bɨ okok! Betsaida taun bin bɨ okok! Tap ma gep okok gen, nɨpek. Pen tap si tap tɨmel gɨpɨm ak kɨrɨg gɨl, yɨp ma nɨŋ dɨpɨm. Nɨg gɨpɨm ak, nɨbi mɨnɨm kɨb yɨb dɨnɨgabɨm. Taun kɨb Taia, Juda bin bɨ mer okok, taun kɨb Saidon, Juda bin bɨ mer okok, tap ma gep nɨb okok kɨrop ak rek nep gebnep, kɨri tap si tap tɨmel gölɨgɨpal okok kɨrɨg gɨl, wad ajɨl rek ognap yɨmɨl, tɨn sɨlɨkɨl lɨlɨg gɨ lɨlɨg gɨ mɨdeblap. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nɨb ak, mɨnɨm kɨb agep ñɨn ak, Taia bin bɨ abe, Saidon bin bɨ abe, mɨnɨm sɨkol rek dɨnɨgal; pen nɨbi Korasin bin bɨ abe, Betsaida bin bɨ abe, mɨnɨm kɨb yɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapaneam bin bɨ okok. Ñɨn nɨbak nɨbi seb kab ar alaŋ sɨŋak ma amnɨgabɨm; pɨs nep mab ke yɨneb kau mɨgan eyaŋ ak amnɨgabɨm. Tap ma gep rek nɨbep nab aul gɨnek ak, taun kɨb Sodom gebnep, kɨri tap si tap tɨmel gölɨgɨpal okok kɨrɨg gɨl, mɨñi komɨŋ mɨdeblap. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ar nɨbak yad nɨbep agebin, mɨnɨm kɨb agep ñɨn ak, Sodom bin bɨ okok mɨnɨm sɨkol rek dɨnɨgal; nɨbi Kapaneam bin bɨ mɨnɨm kɨb yɨb dɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Ñɨn nɨbak Jisas Nap nop agak, “Bapi, yad yɨb nep agen ar alaŋ amnaŋ. Nak Bɨ Kɨb, seb kab ar alaŋ abe, lɨm dai wagɨn aul abe kod mɨdeban ak, gos nak ke nɨŋek tep gɨp rek, bin bɨ gos kɨd yɨk nɨŋɨl nɨŋobɨn apal okok, kɨrop mɨnɨm yad agebin wagɨn ak ma ag ñɨban; pen bin bɨ ñɨ paiŋaŋ rek mɨdebal okok kɨrop gos tep ñɨl, mɨnɨm yad agebin wagɨn ak ag mɨseŋ lɨpan ak, nep tep agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisas nɨb agɨl agak, “Bapi kɨlɨs ne mɨdeb rek, yɨp ñɨb. Bin bɨ ognap yɨp nɨŋ tep ma gɨpal; Bapi nep yɨp nɨŋɨp. Yad nep Bapi nop nɨŋ tep gɨpin. Pen bin bɨ gos tep ñɨnɨm ag gos nɨŋnɨgain okok, kɨrop gos tep ñen, Bapi nop nɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jisas nɨb agɨl agak, “Nɨbi bin bɨ tap wad tɨbrɨb tɨkrok mɨker per dɨ ajɨl gos par nɨŋɨl mɨdebɨm okok, yɨp onɨmɨb nɨŋɨl tap wad kɨb mɨker dɨ ajebɨm okok yad ke tɨg asɨk den ake lɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yad bɨ sain tep kapkap mɨdebin; kal ma gɨnɨgain; nɨb ak, yɨp apɨl, wög yad gɨ ñɨl, cɨbur gos mɨdmagɨl nɨbep nab adaŋ ake lɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nɨbi yɨp apɨl wög yad genɨgabɨm ak, dɨ mɨker alap ma gɨnɨgab; auan amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juda God nop sobok gep ñɨn ak, Jisas bɨ ne okok eip wid wög nab sɨŋak amlɨg gɨ, bɨ ne okok yuan gek, wid magɨl nɨb okok ognap dɨl, wak pak yokɨl, ñɨblɨg gɨ ñɨblɨg gɨ amelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nɨg gelak, bɨ Perisi okok nɨŋɨl, Jisas nop aglak, “Lo mɨnɨm cɨn ageb, bin bɨ God nop sobok gep ñɨn ak wög ma gɨnɨgal. Pen bɨ nak okok tari gɨnɨg God nop sobok gep ñɨn wög ma gep ñɨn aul, wid magɨl wak pak yokebal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Agelak, Jisas kɨrop pen agak, “Depid bɨrarɨk nep bɨ ne okok eip yuan gek, God sobok gep karɨp ak amjakɨl, bred God udɨn yɨrɨk ar sɨŋak lel, bɨ yokop ma ñɨbal, bɨ God nop tap sobok gɨpal okok nep ñɨbal bred ak, kɨrop ag nɨŋek nop ñel, bɨ ne okok eip ñɨŋlak. Pen yuan lek gɨlak kesɨm nɨbak, God Mɨnɨm eyaŋ ñu kɨl tɨklak ak nɨbi ma nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Nɨbi Mosɨs God Mɨnɨm ñu kɨl tɨkak ak ma nɨpɨm rek lɨp. Ne ñu kɨl tɨkɨl agak, ‘Bɨ God nop tap sobok gep bɨ okok, God nop sobok gep ñɨn ak, God sobok gep karɨp mɨgan ak am mɨdɨl, wög gɨpal. Pen God kɨrop mɨnɨm kɨb ma agnɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pen yad nɨbep agebin, God sobok gep karɨp nɨbak tap kɨb mer; nɨŋebɨm aul me kɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pen mɨnɨm alap God Mɨnɨm ñu kɨl tɨklak ak, nɨŋ tep ma gɨpɨm akaŋ? Mɨnɨm nɨbak ñu kɨl tɨkɨl aglak, ‘Bin bɨ yɨp tap pak sobok gɨ ñɨnɨgal ak, yɨp tep ma gɨnɨgab; bin bɨ okok kɨrop yɨmɨg nɨŋnɨgal ak, yɨp tep gɨnɨgab,’ aglak. Mɨnɨm nɨbak nɨŋɨl ma gɨpɨm ak me, bɨ yad okok gɨ tep gel nɨŋlɨg gɨ, kɨrop dɨ sɨlɨkɨl apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","‘God nop sobok gep ñɨn! God nop sobok gep ñɨn!’ apɨm ak pen Bɨ Ñɨ ne nep God nop sobok gep ñɨn ak kod mɨdeb ag gos ak ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas karɨp lɨm nɨbak kɨrɨg gɨl, karɨp lɨm alap amɨl, Juda mogɨm gep karɨp ñɨlɨk mɨgan ak amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pen karɨp ñɨlɨk mɨgan nɨbak bɨ ñɨnmagɨl pɨpɨc gak alap mɨdek. Bin bɨ ap mɨdelak okok, Jisas mɨnɨm ognap agek nop dam mɨnɨm kɨb agɨn, agɨl, nop mɨnɨm tom agɨl aglak, “God nop sobok gep ñɨn aul, bin bɨ komɨŋ lep akaŋ mer?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Agelak, Jisas kɨrop pen agak, “Kaj sipsip nɨbi alap God nop sobok gep ñɨn aul kau mɨgan amenɨgab ak, dɨ yoknɨgabɨm aka mer? Dɨ yoknɨgabɨm rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pen kaj sipsip ak tap yokop. Bin bɨ okok tap yɨb. God nop sobok gep ñɨn aul komɨŋ laŋ agɨl gɨnɨgabɨn ak, mɨnɨm ma mɨdeb, gɨnɨgabɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jisas nɨb agɨl, bɨ ñɨnmagɨl pɨpɨc gak ak nop agak, “Ñɨnmagɨl parsek lan!” agak. Nɨb agek, ñɨnmagɨl parsek lebin agak. Nɨg gak nɨŋɨl ñɨnmagɨl pɨpɨc gak ak pɨs nep komɨŋ lɨl, ñɨnmagɨl pɨs kɨd tep mɨdek ak rek lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nɨg gek nɨŋɨl, bɨ Perisi okok am mogɨm gɨl, nop nɨg nɨg gɨl ñag pak lɨn, agɨl, mɨnɨm ag nɨŋ ag nɨŋ gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nɨg gelak, Jisas nɨŋɨl, karɨp lɨm nɨbak kɨrɨg gɨl, mɨgan alap amnɨg gɨl amnak. Amek nɨŋlɨg gɨ, bin bɨ koŋai nep nop kɨsen gɨlak. Nɨg gelak, bin bɨ tap gak okok, ne gek magɨlsek komɨŋ lek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kɨrop agak, “Bɨ ak nɨg nɨg gɨp, agɨl, ma agnɨmɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisas gak nɨbak, bɨ God mɨnɨm agep Aisaia gɨnɨgab agak rek nep gak. Ne ñu kɨl tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nɨbi nɨŋɨm! Bɨ yad pɨs nep ag lɨpin aul, wög yad gɨ ñeb bɨ me ak. Bɨ yad nɨŋen, yɨp tep yɨb gɨp me ak. Yad nop mɨdmagɨl lɨpin. Kaun yad ak nop bak goŋ lek, bin bɨ kɨri titi gɨl bɨsɨg mɨd tep gɨnɨgal mɨnɨm yad ak, bin bɨ okok kɨrop magɨlsek ag ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ne bin bɨ okok nɨŋek mɨlɨk yapek, mɨnɨm pen pen ma agnɨgab. Bin bɨ mɨdebal okok, yɨp nep nɨŋlaŋ agɨl, meg mɨgan dap ranɨl ma agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bin bɨ ma nɨpal okok kɨrop kapkap ag tep gɨnɨgab. Lam soŋ gɨnɨg gek, wel tɨm lel yɨn mɨdeb rek ak kɨrop agnɨgab. Ne nɨg gɨlɨg gɨ damɨl me, God agɨp rek mɨñ ar ak gek ap ranek, tap si tap tɨmel gep mɨñ ar ak pɨs nep ap yonɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bin bɨ karɨp lɨm okok nɨb okok nɨb ak rek nep, nop gos sek kod mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bɨ kɨjeki abaŋ ñagek, udɨn kwoi gɨl, meg mɨgan pɨlɨŋ gɨl gak bɨ alap dam Jisas mɨdek sɨŋak dapelak. Jisas kɨjeki ak ag söŋ yokek, udɨn yɨb ñɨl nɨŋɨl, mɨnɨm agɨl gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bin bɨ mɨdelak okok, Jisas gak nɨbak nɨŋɨl, wal agɨl aglak, “Bɨ nɨbaul based Depid Ñɨ ne per kod mɨdobɨn ak rek lɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pen bɨ Perisi okok mɨnɨm nɨbak nɨŋɨl, gos kɨri okok nep nɨŋɨl aglak, “Bɨ nɨbak God kɨlɨs ne dɨl ag söŋ ma yokɨp; ne kɨjeki kɨyob ñɨlɨk tap okok, nap kɨri Bielsebul kɨlɨs dɨl ag yokɨp,” ag gos nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Pen gos nɨŋlak nɨbak, Jisas ke nɨŋɨl, kɨrop agak, “Seten warɨkɨl, bin bɨ ne ognap ag yoknɨgab ak, titi gɨl bɨ kɨb mɨdenɨgab? Karɨp lɨm alap, kɨri ke pen pen gɨl asɨk ke ke lɨnɨgal ak, ap yap paknɨgal. Karɨp lɨm kɨb alap akaŋ bin bɨ wagɨn nokɨm alap, kɨri ke pen pen gɨl asɨk ke ke lɨnɨgal ak, ap yap paknɨgal. Nɨbi gos aknɨb rek nɨŋɨl agebɨm ak pen Seten ne yakam ne ke okok kɨrop ma ag yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Yɨp agebɨm, ‘Kɨjeki kɨyob ñɨlɨk tap okok nap kɨri Bielsebul kɨlɨs ak dɨl ag söŋ yokeban,’ agebɨm ak pen nɨbi yɨp agem nɨŋin. Bɨ nɨbi ke okok Bielsebul kɨlɨs ak dɨl kɨjeki kɨyob ñɨlɨk tap okok ag söŋ yokebal aka tari? Kɨri ke agnɨgal, ‘Bin bɨ alap nɨg gɨnɨmel rek ma lɨp,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Pen God Kaun kɨlɨs ak dɨl, kɨjeki kɨyob ñɨlɨk tap okok ag söŋ yokebin ak, tari gɨnɨg God ne bin bɨ dɨl kod mɨdenɨgab ñɨn ak bɨr owɨp aul, agɨl, yɨp ma dɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bɨ kɨlɨs yɨb alap mɨdek, tap nop okok dɨnɨg, yokop ma amnɨgal. Ned nop pɨs nep nag dɨ ñon gɨ lɨl amɨl me tap nop okok me si dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Bin bɨ yad eip mɨdebal okok, bin bɨ okok kɨrop yɨp donɨgal. Pen bin bɨ yad mer okok, bin bɨ yɨp onɨg gebal okok kɨrop yɨk gɨ yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nɨb ak, nɨbi nɨŋ tep gɨnɨmɨb. Bin bɨ okok tap si tap tɨmel tari tari genɨgal ak, God nɨŋɨl kɨrɨg gɨnɨgab. Bin bɨ God nop mɨnɨm tɨb junɨgal ak, ak rek nep God nɨŋɨl kɨrɨg gɨnɨgab. Pen God Kaun nop mɨnɨm tɨb junɨgal ak, God nɨŋɨl ma kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bɨ Ñɨ ne ak nop mɨnɨm tɨmel agenɨgal ak, God nɨŋɨl kɨrɨg gɨnɨgab. Pen Kaun Sɨŋ nop mɨnɨm tɨmel agenɨgal ak, ñɨn aul abe, ñɨn kɨsen ak abe, God ne gos nɨŋ nep mɨdɨl ma kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nɨbi yɨp tari gɨnɨg agebɨm, ‘Seten abaŋ ñagek, wög tep ak geb,’ agebɨm? Mab tep okok magɨl tep pɨlnɨgab; mab tɨmel okok magɨl tɨmel pɨlnɨgab. Mab magɨl pɨlnɨgab magɨl nɨbak nɨŋɨl me, mab ak tep mab ak tɨmel agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nɨbi soiŋ ñɨ pai tɨk dopal okok me nɨb agebɨm. Nɨbi bin bɨ tɨmel nɨbak rek, titi gɨl mɨnɨm tep agnɨgabɨm? Bin bɨ mɨnɨm agebal rek nɨŋnɨgabɨn me, cɨbur gos mɨdmagɨl kɨrop nab adaŋ tari rek mɨdeb ak nɨŋnɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bin bɨ tep okok, cɨbur gos mɨdmagɨl nab kɨri adaŋ tap tep mɨdeb nɨŋlɨg gɨ, gɨ tep gɨpal; bin bɨ tɨmel okok, cɨbur gos mɨdmagɨl nab kɨri adaŋ tap tɨmel mɨdeb nɨŋlɨg gɨ, gɨ tɨmel gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nɨŋ tep gɨnɨmɨb. Kɨsen mɨnɨm kɨb agep ñɨn ak, God bin bɨ okok kɨrop magɨlsek, mɨnɨm abramek agɨl bin bɨ ognap gɨ tɨmel gɨlak ak, tari gɨnɨg nɨb apek agɨl, kɨrop ag gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nɨb ak me, nɨbi ke mɨnɨm agnɨgabɨm ak nep God nɨŋɨl agek komɨŋ amnɨgabɨm akaŋ yur dɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","God lo mɨnɨm ag ñeb bɨ ognap abe, bɨ Perisi ognap abe, apɨl Jisas nop aglak, “Mɨnɨm ag ñeb bɨ! Tap ma gep rek alap gek, cɨn nɨŋɨl me, nak God nep ag yokɨp opan agnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Agelak, Jisas agak, “Nɨbi bin bɨ tap si tap tɨmel nep gɨl, God mɨnɨm agak ak ma nɨpɨm. Tap ma gep rek alap gek nɨŋɨn agebɨm ak, pen nɨbep tap alap gen ma nɨŋnɨgabɨm. Bɨ God mɨnɨm agep Jona nop gak ar ak nep, yɨp ak rek nep gek, nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bɨrarɨk nep kɨbsal kɨb ak Jona nop kom jal yokek, cɨbur nab eyaŋ ñɨn omal nokɨm mɨdɨl, adɨk gɨ owak. Nɨb ak rek, yad, Bɨ Ñɨ ne, ak rek nep ñɨn omal nokɨm lɨm nab okok mɨdɨl, adɨk gɨ onɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bɨrarɨk nep Jona amɨl, taun kɨb Ninepa bin bɨ kɨrop agek, tap si tap tɨmel gɨlak okok kasek kɨrɨg gɨl, God nop nɨŋ dɨlak. Jona bɨ yokop ak agek nɨŋlak; nɨbi pen Bɨ Kɨb mɨñi mɨdeb aul, mɨnɨm ageb ak ma dɨpɨm. Nɨb ak, kɨsen mɨnɨm kɨb agep ñɨn ak, Ninepa bɨ warɨkɨl nɨbep mɨnɨm kɨb agel, nɨbi mɨnɨm kɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Bin kwin kɨb, karɨp lɨm Siba nɨb ak, bɨrarɨk nep gak rek ak nɨpɨm. Karɨp lɨm ne par okok nɨb ak pen, Juda kiŋ kɨb Solomon gos kɨd yɨk nɨŋak bɨ ak mɨnɨm nop nɨŋnɨg owak. Solomon bɨ yokop ak nop nɨg gak; pen tari gɨnɨg Bɨ Kɨb mɨñi mɨdeb aul mɨnɨm ageb ak ma nɨpɨm? Kɨsen mɨnɨm kɨb agep ñɨn ak, Siba kwin warɨkɨl nɨbep mɨnɨm kɨb agek, nɨbi mɨnɨm kɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Seten yakam ne kɨjeki tap okok apɨl bin bɨ abaŋ ñag mɨdɨl, söŋ amɨl, bin bɨ ognap abaŋ ñagin, agɨl, nɨŋ tag mer nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","adɨk gɨ apɨl nɨŋnɨgab, bɨ ned kɨrɨg amnɨgab kau ar ak tep tep nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ne nɨŋɨl, kɨjeki tɨmel ne rek mer, kɨjeki tɨmel yɨb, aknɨb ar oŋɨd ak poŋ dapɨl, bɨ nɨbak nop yɨpɨl sɨknɨgal. Nɨg gek, ned mɨd tɨmel gak rek mer; kɨsen mɨd tɨmel yɨb gɨnɨgab. Nɨbi bin bɨ mɨñi mɨdebɨm nɨbi tap si tap tɨmel ned gɨ mɨdelɨgɨpɨm rek mer, kɨsen tap si tap tɨmel yɨb gɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas bin bɨ okok kɨrop mɨnɨm agek nɨŋlɨg gɨ, nonɨm nɨmam ne ke okok söŋ eyaŋ apɨl aglak, “Cɨn Jisas nop mɨnɨm agnɨg opɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Agelak, bɨ alap karɨp ñɨlɨk mɨgan amɨl, Jisas nop agak, “Nanɨm namam nak okok, nep mɨnɨm agnɨg ap mɨdebal söŋ eyaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Agek, bin bɨ ne eip karɨp ñɨlɨk mɨgan eyaŋ mɨdelak okok kɨrop nɨŋ padɨklɨg gɨ agak, “Nɨŋɨd apan ak pen, bin bɨ karɨp ñɨlɨk mɨgan mɨdebal sɨŋ aul, kɨri me ami yad, mam yad mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bin bɨ Bapi yad seb kab ar alaŋ mɨnɨm ageb rek nɨŋɨl, nɨg aknɨb rek nep gebal okok, kɨri me ami yad, ai yad, mam yad mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ñɨn nokɨm nɨbak nep, Jisas karɨp ne ak kɨrɨg gɨl am Ñɨg Cöb Galili gol sɨŋak bɨsɨgek, ");
INSERT INTO kmh_m_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","bin bɨ koŋai yɨb nep apɨl nop pɨŋɨl kɨs kɨs gelak. Nɨg gelak nɨŋɨl ne am ñɨg magöb ar ak bɨsɨg gɨl, amɨl ñɨg nab sɨŋak adaŋ mɨdek nɨŋlɨg gɨ, bin bɨ ñɨg cöb gol sɨŋak warɨk mɨdelak. Jisas bin bɨ okok kɨrop mɨnɨm sɨd tɨkɨl mɨnɨm koŋai nep ag ñak. Ag ñɨlɨg gɨ agak, “Bɨ alap wid tanaŋ agɨl, wid magɨl ak dam wög dai okok yokenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yɨŋ dɨ yokek, ognap kanɨb ar sɨŋak yapek, yakɨr okok apɨl ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ognap kab ar lɨm sɨkol sɨkol mɨdenɨgab sɨŋak yapɨl, kasek marɨp gɨnɨgab ");
INSERT INTO kmh_m_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pen kɨdɨl am kɨlɨs ma gɨnɨgab rek, pɨb nɨŋɨl mɨlep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pen ognap nag ñu ñu sek nab okok yapɨl tannɨgab ak pen nag nɨbak sau gɨl pak ñɨbek, mɨlep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pen ognap lɨm tep ar sɨŋak yapɨl, tan tep yɨb gɨl, magɨl koŋai yɨb nep pɨlnɨgab. Ognap ñɨn juɨl mamɨd ak (100) rek pɨlnɨgab; ognap ñɨn juɨl omal nokɨm (60) rek pɨlnɨgab; ognap ñɨn juɨl nokɨm alap adɨk gɨ dam aknɨb wajrem alaŋ (30) rek pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas nɨb agek, bɨ ne okok apɨl, nop ag nɨŋɨl aglak, “Bin bɨ okok kɨrop tari gɨnɨg mɨnɨm sɨd tɨkɨl nep apan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Agelak, ne pen agak, “God bin bɨ ne dɨl kod mɨdenɨgab mɨnɨm we gɨl mɨdeb ak, nɨbep gos ñek nɨŋnɨgabɨm; pen bin bɨ yokop okok ma nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bin bɨ mɨnɨm yɨp nɨŋɨl nɨŋ dɨpal okok, mɨnɨm ognap sek nɨŋɨl, wagɨn ak nɨŋ tep gɨnɨgal; pen bin bɨ mɨnɨm yɨp nɨŋɨl ma nɨŋ dɨpal okok, mɨnɨm sɨkol nɨpal ak pɨs nep kɨr gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kɨrop mɨnɨm sɨd tɨkɨl apin ak, kɨri udɨn sek, gos tɨmɨd sek ak pen, agɨp ar me ak, agɨl, ma nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Gɨpal nɨbak, bɨ God mɨnɨm agep Aisaia ned gɨnɨgab agɨl ñu kɨl tɨkak rek nep gɨpal. Aisaia mɨnɨm nɨbak ñu kɨl tɨkɨl agak, ‘Mɨnɨm nɨŋnɨgal ak pen mɨnɨm agɨp nɨb, agɨl, mɨnɨm wagɨn tɨg dam ma nɨŋnɨgal. Udɨn nɨŋnɨgal ak pen tap alap ma nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bin bɨ sɨŋ aul mɨnɨm yad apin ak kɨri yɨrɨk gek ma nɨpal. God Mɨnɨm nɨŋon, cɨnop gek, bin bɨ ne mɨdojɨn rek lɨp agɨl, tɨmɨd mɨgan pɨlɨŋ gɨl, udɨn jɨkɨl nep mɨdebal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","“Nɨb ak, kɨri ma nɨpal; pen God nɨbep gos tep ñek nɨpɨm ak, mɨñ mɨñ gɨnɨmɨb. Yad nɨbep nɨŋɨd agebin, God mɨnɨm agep bɨ okok abe, bin bɨ God Mɨnɨm ageb rek nɨŋɨl gölɨgɨpal bin bɨ okok abe, koŋai nep Mesaia nop nɨŋɨn ag gos nɨŋölɨgɨpal ak pen udɨn nɨŋɨl, peyɨg ma nɨŋlak. Pen mɨñi nɨbi udɨn nɨŋɨl, peyɨg nɨŋebɨm ak, mɨñ mɨñ yɨb gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pen mɨnɨm sɨd tɨkɨl agesin ak, bɨ ne wid magɨl dam wög dai okok dɨ yokak ak, wagɨn ak agen nɨŋɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Wid magɨl ognap kanɨb ar sɨŋak yapek, yakɨr okok apɨl ñɨŋnɨgal agesin ak, bin bɨ okok, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak nɨŋnɨgal ak pen wagɨn ak ma nɨŋnɨgal nɨŋɨl Seten ne gek pɨs nep saköl gɨnɨgal, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Pen magɨl ognap kab ar lɨm sɨkol sɨkol mɨdenɨgab sɨŋak yapɨl, kasek marɨp gɨnɨgab pen kɨdɨl am kɨlɨs ma gɨnɨgab rek, pɨb nɨŋɨl mɨlep gɨnɨgab agesin ak, bin bɨ okok kɨri mɨnɨm yad kɨsen nɨŋnɨgal won ak, mɨñ mɨñ gɨnɨgal ak pen mɨñi nep bin bɨ ognap apɨl, bin bɨ mɨnɨm yad nɨŋnɨgal okok gos tɨmel nɨŋɨl, kaual maual rek mɨdɨl, kɨrop gɨ tɨmel gɨnɨgal nɨŋɨl bin bɨ mɨnɨm yad ned nɨŋ dɨlak okok, mɨñi mɨnɨm yad ak saköl gɨl, gos ar ognap nɨŋnɨgal, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Magɨl ognap yonɨgab nag ñu ñu sek nab okok agesin ak, bin bɨ okok mɨnɨm yad ak nɨŋnɨgal ak pen wög wari, karɨp, kaj, tu mɨŋol, agon kɨlnok kɨbap tap okok nep gos nɨŋɨl, God mɨnɨm tep ak kɨrɨg gɨnɨgal nɨŋɨl tap ñɨŋeb ognap ma pɨlnɨgab, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pen magɨl ognap lɨm tep ar sɨŋak yapɨl, tan tep gɨl, magɨl koŋai pɨlnɨgab agesin ak, bin bɨ okok mɨnɨm yad ak nɨŋɨl, dɨ kɨlɨs yɨb gɨl, ognap gɨ tep gɨnɨgal, ognap gɨ tep yɨb gɨnɨgal, ognap gɨ tep ar ke yɨb gɨnɨgal, agɨl agesin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas kɨrop mɨnɨm alap sek mɨnɨm sɨd tɨkɨl agak, “God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm dɨnɨg gebin aul rek gɨnɨgab. Bɨ kɨb alap wid magɨl okok tanaŋ agɨl, dam wög dai ne okok yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pen kɨslɨm eyaŋ kɨn amnɨgal won ak, bɨ tɨmel alap tap yɨŋ tɨmel ognap dapɨl, nab nɨb okok yokɨl amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nɨb ak, wid yɨŋ tep ak tannɨgab ak pen tap yɨŋ tɨmel ak abe tannɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nɨg gek, bɨ wög gɨ ñeb okok apɨl bɨ kɨb ak nop agnɨgal, ‘Bɨ kɨb! Tap yɨŋ tep okok nep dam wög dai ak yokpan ak pen tap yɨŋ tɨmel okok akal nɨb apɨl sek taneb?’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ne kɨrop pen agnɨgab, ‘Bɨ kaual maual yad alap dap yokɨp,’ agnɨgab. Pen kɨri agnɨgal, ‘Cɨn amɨl tap yɨŋ tɨmel taneb nɨb okok tɨg ju yokɨn akaŋ?’ agnɨgal. Bɨ wög dai nap nɨb bɨ nɨbak pen agɨl agnɨgab, ");
INSERT INTO kmh_m_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Mer! Ñɨn aul, tap yɨŋ tɨmel nɨb okok tɨg juɨm agen, nɨbi amɨl tap yɨŋ tep ognap sek tɨg junɨmɨb rek lɨp! ");
INSERT INTO kmh_m_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kɨrɨg gem omalgɨl tannɨmɨŋ. Pen tanɨl magɨl pɨlek, tɨkep ñɨn ak bɨ tap tɨkep bɨ yad okok agnɨgain, “Tap yɨŋ tɨmel nɨb okok tɨg juɨl, dam ñon ñon gɨ lem, mab dagɨlel yɨn sɨbok ñɨb amnɨmɨŋ; pen wid magɨl okok nep dɨ mogɨm gɨl, dam wid magɨl lep ñɨlɨk mɨgan yad ak yoknɨmɨb,” agnɨgabin,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jisas kɨrop mɨnɨm alap sek mɨnɨm sɨd tɨkɨl agak, “Bɨ alap mab mastad magɨl sɨkol ak dam wög dai ne ak yokenɨgab, tan kɨb gɨl, lek tep ak lek, yakɨr okok apɨl, lek ke ke karɨp gɨnɨgal. Nɨb ak rek me, God bin bɨ dɨl, karɨp lɨm tep ne seb kab ar alaŋ sɨŋak kod mɨdenɨgab ak me,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas mɨnɨm alap sek mɨnɨm sɨd tɨkɨl agak, “Bin okok tap yɨs apal ak, dɨ plaua tin kɨb eyaŋ sek dɨ adɨk madɨk gel, tap kɨb yɨb tanɨb. Nɨb ak rek me, God bin bɨ dɨl, karɨp lɨm tep seb kab ar alaŋ sɨŋak kod mɨdenɨgab ak me,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas bin bɨ okok kɨrop mɨnɨm ognap ag ñɨnɨg gɨl mɨseŋ ma agolɨgɨp; mɨnɨm sɨd tɨkɨl nep kɨrop ag ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gak nɨbak, bɨ God mɨnɨm agep alap ned gɨnɨgab agɨl ñu kɨl tɨkak rek nep gak. Ne mɨnɨm nɨbak ñu kɨl tɨkɨl agak, “Karɨp lɨm bɨrarɨk ped okok gɨ lak ñɨn ak tɨkɨl, mɨd damɨl mɨñi mɨdobɨn ñɨn aul, mɨnɨm ma nɨŋlak ak, mɨnɨm sɨd tɨkep mɨnɨm ak nep kɨrop ag ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas nɨb agɨl, bin bɨ okok kɨrop kɨrɨg gɨl, karɨp ñɨlɨk mɨgan amek nɨŋlɨg gɨ, bɨ ne aknɨb umɨgan alaŋ okok apɨl, nop aglak, “Tap yɨŋ tɨmel wög dai nab okok tanɨb, agɨl, mɨnɨm sɨd tɨkɨl apan ak, cɨnop agek nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Agelak, ne pen agak, “Bɨ tap yɨŋ tep yokɨp, apin ak, yad Bɨ Ñɨ ne. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Wög dai apin ak, lɨm dai wagɨn aul magɨlsek. Tap yɨŋ tep apin ak, bin bɨ God kɨrop dɨl kod mɨdenɨgab bin bɨ okok. Bɨ tap yɨŋ tɨmel dap yokek tanɨb apin ak, bɨ yɨp nɨŋek mɨlɨk yowɨp Seten nop nep apin. Tap yɨŋ tɨmel tanɨb apin ak, Seten bin bɨ ne okok kɨrop apin. Pen wid magɨl pok gɨnɨgab ñɨn apin ak, ñɨn karɨp lɨm wagɨn aul kɨr gɨnɨgab ñɨn nɨbak apin. Bɨ tɨk dowep apin ak, ejol okok kɨrop apin. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tap abramek tanɨb okok tɨg juɨl, dam mab ke yɨneb eyaŋ yoknɨgal apin ak, ñɨn karɨp lɨm wagɨn aul kɨr gɨnɨgab ñɨn nɨbak me ak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bɨ Ñɨ ne ejol ne okok kɨrop ag yokek, apɨl, bin bɨ tap si tap tɨmel gɨpal okok abe, bin bɨ bin bɨ ognap kɨrop agel, kɨri tap si tap tɨmel gɨpal okok abe, ejol kɨri apɨl kɨrop dɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","mab ke yɨneb mɨgan eyaŋ ak yoknɨgal, yur gek nɨŋlɨg gɨ, meg magɨl su rɨbɨkɨl sɨl agnɨgal, agɨl apin. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ñɨn nɨbak, bin bɨ Nap kɨri dɨl seb kab ar alaŋ kod mɨdenɨgab okok, kɨri pɨb melɨk rek paklɨg gɨ mɨdenɨgal. Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Pen God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek mɨdeb. Bɨ alap amɨl nɨŋnɨgab, mani kes bɨrarɨk nep we gɨlak alap wög dai alap mɨdenɨgab. Ne nɨŋɨl, tap ognap dɨ pak rɨbɨk tep gɨl, karɨp amnɨgab. Amɨl, mɨñ mɨñ yɨb gɨl, tap ne okok magɨlsek sɨkim gɨl, mani dɨl, mani nɨbak damɨl, wög dai nɨbak tauɨl, am mani kes nɨbak dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Pen God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek mɨdeb. Bɨ sɨkim gep okok magɨl sɨkol kɨbap mɨlep rek tɨd geb “pöl” apal tap okok pɨyo nɨŋ ajɨl, pöl magɨl mɨlep yɨb alap nɨŋɨl, karɨp amɨl, tap kɨri okok magɨlsek sɨkim gɨl, mani dɨl, am pöl magɨl mɨlep nɨbak taunɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek mɨdeb. Bin bɨ ognap uben damɨl, ñɨg cöb sɨŋak yokel, kɨbsal koŋai nep apɨl mɨgan nɨbak ambal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nɨg gel, uben lɨp gɨ dam gol okok amɨl, kɨbsal tep okok yɨprɨg kɨbsal lep tin mɨgan ak lɨl, kɨbsal tɨmel okok dɨ yokpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Karɨp lɨm wagɨn aul kɨr gɨnɨgab ñɨn ak, nɨb aknɨb rek nep gɨnɨgab. God ejol ne okok apɨl, bin bɨ God Mɨnɨm ageb rek gɨpal okok dɨ bɨlok ke lɨl, bin bɨ God Mɨnɨm ageb rek ma gɨpal okok dɨ bɨlok ke lɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","dam mab ke yɨneb eyaŋ ak yoknɨgal. Yokel yur gek, meg magɨl kɨri su rɨbɨkɨl sɨl aglɨg gɨ mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nɨb agɨl agak, “Yad mɨnɨm agesin wagɨn ak nɨpɨm aka mer?” agak. Agek, bɨ ne okok aglak, “Yau, nɨpɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Agelak, agak, “Nɨbi ned God lo mɨnɨm ak nep ag ñölɨgɨpɨm ak pen mɨñi nɨbi God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep agebin ak bɨr nɨpɨm. Nɨg nɨŋɨl nɨbi mɨñi bin bɨ okok ag ñɨnɨgabɨm ak, nɨbi God Mɨnɨm tep ned nɨb ak abe, God Mɨnɨm tep kɨsen nɨb ak abe ag ñɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Pen Jisas ne mɨnɨm sɨd tɨkɨl mɨnɨm agak nɨbak ag juɨl, taun ne ke Nasaret amɨl, Juda mogɨm gep karɨp ñɨlɨk mɨgan ak amɨl, bin bɨ okok kɨrop ag ñek, kɨri nɨŋɨl wal yɨb aglak. Kɨri pen aglak, ‘Bɨ nɨbaul ne titi gɨl gos kɨd yɨk nɨŋɨl tap ma gep aknɨb rek geb?’ aglak. Kɨsen pen aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Bɨ nɨbaul nonɨm nap, nɨnai nɨmam ne okok, cɨn eip mɨdebal ak pen ne titi gɨl bɨ kɨb rek mɨdɨl, mɨnɨm ke agɨl, tap ma gep rek okok geb? Nap ne ak bɨ kapeda; nonɨm Maria; nɨmam bɨ ne okok Jems ak, Josep ak, Saimon ak, Judas ak. Nɨb ak, ne titi gɨl apɨl nɨg geb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nɨb agɨl, kɨri Jisas nop gos tɨmel nɨŋɨl, mɨnɨm ne agak ak ma dɨlak. Pen Jisas kɨrop agak, “Bɨ God mɨnɨm agep okok karɨp lɨm par okok amɨl ag ñel, nɨŋɨd agebal agɨl nɨŋnɨgal; pen karɨp lɨm kɨri ke ak ag ñel, tom agebal rek lɨp agɨl kɨrɨg gɨpal ak rek gebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mɨnɨm agak ak ma nɨŋlak ak me, karɨp lɨm nɨbak tap ma gep rek koŋai nep ma gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pen gapman bɨ kɨb karɨp lɨm Galili kod mɨdolɨgɨp Herod, Jisas ne tari tari gak mɨnɨm ak nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","am bɨ nop wög gɨ ñeb ognap kɨrop agak, “Bɨ Jisas tap ma gep rek geb bɨ nɨbak, ne bɨ alap ke mer; ne Jon bɨ ñɨg pak ñeb bɨ nɨbak nep. Nop ñag pak lɨnek ak pen kauyaŋ warɨkɨl ap mɨdeb rek, tap ma gep rek nɨb okok geb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Pen Herod ne Jon nop mɨñ lɨl ñag pak lak mɨnɨm wagɨn ak nɨg gɨl mɨdeb. Herod ne nɨmam Pilip bin ne ak Herodias dad amek, Jon ne Herod nop agak, “Nak aknɨb gɨpan, gɨ tɨmel gɨpan. Bɨ alap nɨmam ne komɨŋ mɨdenɨgab bin nuwi ne ma dɨnɨgab,” agak. Jon nɨb agek, bin nɨbak Herodias ne Herod nop mɨnɨm agak nɨŋɨl Herod Jon nop dam mɨñ lɨl, ñag pak lɨn, ag gos nɨŋak ak pen bin bɨ okok Jon nop, bɨ God mɨnɨm agep cɨn aglak rek, pɨrɨkɨl kɨrɨg gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pen kɨsen Herod nonɨm nop tɨk dowak kos tɨkep ñɨn ak amek, bin bɨ koŋai nep ap mogɨm gɨl, tap magɨl dagɨl ñɨŋnɨg gɨlak. Ñɨn nɨbak, Herodias pai ne ak apɨl nab nɨb sɨŋak kogɨm pagek, Herod nɨŋek, tep yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nɨg gek, ne pai nɨbak nop mɨnɨm agɨl agak, “Yad mɨnɨm nɨŋɨd yɨb agɨl nep agebin, nak tap alap ag nɨŋenɨgan, nep abramek dɨ ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Agek, pai nɨbak, nonɨm agak rek nɨŋɨl agak, “Jon bɨ ñɨg pak ñeb kɨmɨg cög ne ak, kɨnaŋ cög mɨgan eyaŋ lɨl, dap ñɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Nɨb agek, Herod nɨŋek yɨmɨg gak, pen bin bɨ okok nɨŋ mɨdel nɨŋlɨg gɨ, pai nɨbak nop mɨseŋ mɨnɨm nɨŋɨd ag lɨl agak, “Nak tap alap ag nɨŋenɨgan, nep abramek ñɨnɨgain,” agak rek nɨŋɨl, bɨ ognap ag yokek, am Jon mɨñ mɨdek sɨŋak amɨl, kɨmɨg cög nop ak tɨb gɨ rɨk gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","dɨ kɨnaŋ cög mɨgan eyaŋ lɨl, dap pai nɨbak nop ñɨlak. Ñelak, ne pen damɨl nonɨm nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pen Jon bɨ ne okok apɨl, cɨp se dam tɨgel gɨl, am Jisas nop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas mɨnɨm nɨbak nɨŋɨl, am karɨp lɨm ke mɨgan alap mɨdenɨm, agɨl, ñɨg magöb dɨl, karɨp lɨm nɨbak kɨrɨg gɨl, paŋdak. Pen bin bɨ okok, Jisas ameb sɨŋak sain amnɨn, agɨl, karɨp lɨm kɨri okok kɨrɨg gɨl, wagɨn ar amlɨg gɨ, Jisas amnɨg gek sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas ne pen karɨp lɨm mɨgan nɨbak apjakɨl, ñɨg magöb ak kɨrɨg gɨl, gol okok apɨl nɨŋak, bin bɨ koŋai nep mɨdelak. Kɨrop nɨŋek, yɨmɨg gek, bin bɨ tap gak okok gek, komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pen dɨgep won ak, bɨ ne okok Jisas mɨdek sɨŋak apɨl, nop aglak, “Maŋ kɨslɨm gɨnɨg geb. Mɨdarɨk nep tap magɨl ñɨŋeb won ak padɨkɨp. Sɨŋ aul mɨñ mab nep nab sɨŋaul. Nɨbak nak bin bɨ koŋai nep sɨŋ aul agek, karɨp maŋ sɨŋ aul amɨl, tap magɨl kɨri ognap tau ñɨŋlaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nɨb agelak, Jisas kɨrop pen agak, “Mer, kɨri ma amnɨgal. Nɨbi ke kɨrop tap magɨl ñɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Agek, aglak, “Cɨn tap magɨl koŋai ma mɨdeb. Yokop bred magɨl aknɨb mamɨd kɨbsal omal mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Agelak, Jisas kɨrop pen agak, “Tap nɨb okok dɨl yɨp dowɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɨb agɨl, bin bɨ okok kɨrop agek, tap kas ar okok bɨsɨg gel amek nɨŋlɨg gɨ, bred kab ak dɨl, kɨbsal omal ak dɨl, kɨlan gɨ nɨŋɨl, God nop tep agɨl, bred ak dɨ pag gɨl, bɨ ne okok kɨrop ñek nɨŋlɨg gɨ, kɨri dɨlɨg gɨ, bin bɨ okok kɨrop nonɨm lɨ ñɨlak. Kɨbsal ak ak rek nep gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nɨg gɨl nonɨm lɨ ñelak, ñɨbel, ñɨbel, kogi gek, ñɨb saknɨmel rek ma lak. Dai dai kɨrɨg gɨlak okok me, Jisas bɨ ne okok wad aknɨb umɨgan alaŋ ak dɨ yɨgel, pɨs nep ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bin bɨ tap ñɨbelak nɨb okok, bin okok mer, ñɨ pai sɨkol okok mer, bɨ okok nep me paip tausan rek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas, bɨ ne okok kɨri ñɨg pɨs kɨdadaŋ amnɨlaŋ ag gos nɨŋɨl agek, ñɨg magöb dɨl amelak nɨŋɨl ne bin bɨ okok kɨrop ag yokɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ne ke God nop sobok gɨnɨg karɨp lɨm dɨm alap amnak. Mɨdek, karɨp dɨgnɨg gek pen ne ausek nep dɨm nɨb alaŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pen bɨ ne okok ñɨg magöb dɨl ñɨg cöb nab kɨb sɨŋak amel nɨŋlɨg gɨ, yɨgen asad kɨb yɨb ak apɨl, ñɨg magöb ak tɨg adɨk gɨnɨg rek gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Won nɨbak karɨp kɨsen nep tɨknɨg gek ak me, Jisas ñɨg kas ar ak taulɨg gɨ apɨl, bɨ ne okok mɨdelak ulep sɨŋak apek, ");
INSERT INTO kmh_m_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kɨri nɨŋɨl, “Ak cɨp kaun alap apeb!” agɨl, jel gek pɨrɨkɨl, wal kɨb agɨl bleble gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas pen kɨrop agak, “Ma pɨrɨknɨmɨb! Yad nep apebin!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Agek, Pita agak, “Bɨ Kɨb! Nak nep apenɨmɨn ak, yɨp abe agek, ñɨg kas ar sɨŋak taulɨg gɨ pɨyak sɨŋak nin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","Agek, Jisas pen agak, “Nɨb ak, nak owan!” agak. Agek, Pita ñɨg magöb ar ak kɨrɨg gɨl, ñɨg kas ar ak taulɨg gɨ am Jisas mɨdek sɨŋak am am nab sɨŋak amɨl nɨŋak, yɨgen kɨb yɨb apɨl, ñɨg ak pag aposɨp. Nɨg gek ne pɨrɨkɨl, ñɨg eyaŋ paŋɨd yaplɨg gɨ, sɨk kɨb agɨl agak, “Bɨ Kɨb! Nak yɨp kasek dɨ yokan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nɨb agek, Jisas kasek nop dɨ rɨbɨkɨl agak, “Nɨŋ dep won nak ak maŋ yɨb gɨp. Tari gɨnɨg gos omal nɨŋesan?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nɨb agɨl, Jisas eip Pita eip ñɨg magöb mɨgan ak amel nɨŋlɨg gɨ, yɨgen asad kɨb dek ak pɨs nep kɨr gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɨg gek nɨŋɨl, bɨ ne ñɨg magöb mɨgan eyaŋ bɨsɨg mɨdelak okok, Jisas yɨb nop agel ar amek nɨŋlɨg gɨ aglak, “Nɨŋɨd! Nak God Ñɨ ne yɨb!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pen kɨri ñɨg cöb juɨl, karɨp lɨm Genesaret pɨs kɨdadaŋ amjaklak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Amjakel, bin bɨ kɨn mɨdelɨgɨpal okok Jisas nop nɨŋɨl, Jisas nep owɨp agɨl, bin bɨ karɨp lɨm ulep nɨb okok magɨlsek sɨk agel, bin bɨ tap gak okok magɨlsek dolak. ");
INSERT INTO kmh_m_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dapɨl, Jisas nop neb neb gɨlɨg gɨ aglak, “Nak cɨnop yau agek, bin bɨ tap gɨp sɨŋ aul, walɨj nep gol sɨŋak nep dɨ nɨŋel, komɨŋ laŋ,” aglak. Agelak ne yau agek, bin bɨ walɨj ne dɨ nɨŋlak okok kɨrop magɨlsek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pen ñɨn nɨbak, bɨ Perisi ognap, bɨ lo mɨnɨm ag ñeb bɨ ognap, Jerusalem nɨb apɨl Jisas nop aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bɨ nak sɨŋ aul, tari gɨnɨg apɨs based sɨkop mɨnɨm per ak kɨrɨg gɨl, ñɨnmagɨl kɨri ñɨg lɨ yokɨl mer, yokop nep tap ñɨbal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Agelak, Jisas pen agak, “Nɨbi tari gɨnɨg God Mɨnɨm ne ak kɨrɨg gɨl, napɨs nased sɨkop gölɨgɨpal rek nep gɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God agak, ‘Nanɨm nap kɨrop gɨ tep gɨl dɨ tep gɨnɨmɨb,’ agak. God mɨnɨm alap agɨl agak, ‘Bɨ alap nonɨm nap kɨrop mɨnɨm tɨmel ognap agnɨgab ak, kɨri bɨ nɨbak nop ñag pak lɨlaŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","7","Pen nɨbi mɨnɨm nɨbak yɨpɨd gɨl ma ag ñɨbɨm. Bɨ alap, nonɨm nap kɨrɨg gɨnɨgain agnɨgab ak, kɨrop agnɨgab, ‘Ami bapi, yad tap tep ognap nɨrep mal ñɨbnep pen mani nɨrep mal ñeb mani ak, mɨñi yad God nop ñɨnɨgain apin, nɨŋɨl mani nɨrep mal ñeb alap ma mɨdeb,’ agnɨgab. Nɨg gel, nɨbi nɨŋɨl apɨm, ‘Kɨri nɨg gɨpal ak, mɨnɨm ma mɨdeb,’ apɨm. Nɨb apɨm ak, ‘God Mɨnɨm agobɨn,’ apɨm ak pen nɨbi mɨnɨm esek yɨb agɨl, nɨbi ke apɨm rek ma gɨpɨm. Nɨbi mɨnɨm nɨbak rek bin bɨ okok kɨrop ag ñɨbɨm ak, God mɨnɨm agep bɨ nak Aisaia ne bɨ nɨbep rek nep gos nɨŋɨl, mɨnɨm nɨŋɨd yɨb alap ñu kɨl tɨkak. Mɨnɨm nɨbak ñu kɨl tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","‘Bin bɨ sɨŋ aul mɨnɨm tom agɨl apal, “God Bɨ Kɨb cɨn,” apal ak pen yokop mɨnɨm nep apal; yɨp mɨdmagɨl ma lɨpal. Yɨp sobok gɨl, yokop mɨnɨm nep apal. God Mɨnɨm bin bɨ okok kɨrop ag ñobɨn apal ak pen bɨ karɨp lɨm wagɨn aul nɨb mɨnɨm kɨri ke apal mɨnɨm ak nep dad ag ñɨ ajebal!’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas nɨb agɨl, bin bɨ mɨdelak okok sɨk agek apelak agak, “Mɨnɨm agebin aul, nɨŋ tep gɨnɨmɨb! ");
INSERT INTO kmh_m_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bin bɨ okok tap magɨl okok abramek ñɨbel, cɨbur nab kɨri eyaŋ amɨl kɨñɨr ma gɨp; cɨbur nab kɨri eyaŋ gos tɨmel nɨŋɨl agebal ak me, kɨñɨr gac sek mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pen Jisas bɨ ne okok apɨl Jisas nop aglak, “Bɨ Perisi okok mɨnɨm apan ak nɨŋel, nep mɨlɨk yowɨp ak, nak nɨpan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Agelak, Jisas agak, “Ak mɨnɨm ma mɨdeb. Bapi yad seb kab ar alaŋ mɨdeb ak, tap yɨŋ ne ma yɨmɨb okok magɨlsek wagɨn sek pɨŋɨl ju dɨ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bɨ nɨb okok kɨri udɨn kwoi. Bɨ udɨn kwoi alap, bɨ udɨn kwoi alap nop poŋɨd damɨl, omalgɨl kau mɨgan ak ap yap paknɨgair,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jisas nɨb agek, Pita agak, “Mɨnɨm nɨbak mɨnɨm sɨd tɨkɨl apan wagɨn ak cɨnop ag ñek nɨŋɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Agek, Jisas pen agak, “Kɨri ma nɨpal rek, nɨbi ak rek nep ma nɨpɨm ar? Nɨŋɨm! Tap tari tari abramek ñɨbal okok, God nɨŋek, mɨnɨm ma mɨdeb. Ak yokop ñɨbɨl, cɨb sek kɨl yokpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Cɨbur nab kɨri eyaŋ gos tɨmel nɨpal ak me gek, kɨñɨr sek mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gos kɨri ke nɨŋɨl, gos tɨmel nɨŋɨl, bin bɨ ñag pak lɨl, bin si bɨ si gɨl, tap okok si dɨl, mɨnɨm kɨb agnɨgal ñɨn ak mɨnɨm tom agɨl, bin bɨ ognap kɨrop ag juɨl, gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gɨpal nɨbak me, God nɨŋek gac sek mɨdebal; pen tap ñɨŋnɨg, ñɨnmagɨl ñɨg lɨ ma yokɨl abramek ñɨbal ak, God nɨŋek gac ma gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas karɨp lɨm Genesaret nɨbak kɨrɨg gɨl, karɨp lɨm kɨb, taun kɨb omal Taia Saidon nab okok amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amɨl nɨb okok karɨp lɨm Kenan okok mɨdek, bin karɨp lɨm nɨb okok nɨb alap, Jisas nop apɨl agak, “Bɨ Kɨb, Depid Ñɨ ne, yɨp yɨmɨg nɨŋan! Pai yad ak kɨjeki abaŋ ñagek, mɨd tep ma gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Agek, Jisas pen ma agak. Pen bɨ ne okok apɨl, Jisas nop aglak, “Bin aul cɨnop kɨsen gɨlɨg gɨ, mɨnɨm sosɨm aiŋeb ageb. Nop ag yokek okok amnaŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Agelak, Jisas agak, “God yɨp ag yokek onek ak, Juda bin bɨ God nop kɨrɨg gɨpal okok, kɨrop nep dɨnɨm, agɨl, onek,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nɨb agek, bin Juda mer nɨbak apɨl, Jisas mɨdek wagɨn sɨŋak kogɨm yɨmɨl agak, “Bɨ Kɨb, yɨp gɨ ñɨnɨmɨn!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Agek, Jisas nop pen agak, “Tap magɨl ñɨ pai cɨn ñeb ak, dɨ kain okok ma yokɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Agek, bin nɨbak pen agak, “Bɨ Kɨb, nɨŋɨd apan ak pen, bɨ kɨb okok tap ñɨbel, dai dai okok abañ mok okok yapek, kain okok sek ñɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Agek, Jisas nop pen agak, “Bin aul, yɨp nɨŋ dɨ wös gɨpan ak me, tap ag nɨŋeban ak gɨnɨgain,” agak. Nɨb agek nɨŋlɨg gɨ, kɨjeki ak won nɨbak nep pai ne ak nop kɨrɨg gɨl söŋ amek, nop komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas adɨk gɨ Ñɨg Cöb Galili gol pɨs kɨdadaŋ amɨl, mak ak kɨlan gɨl, am dɨm alaŋ bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bɨsɨg mɨdek nɨŋlɨg gɨ, bin bɨ koŋai nep, bin bɨ tob tɨmel gak okok, udɨn kwoi gak okok, ñɨnmagɨl tob gɨ gogeb mogeb gak okok, aleb adɨk gek mɨnɨm ma agelak okok, tap tari tari gak okok magɨlsek dapɨl, Jisas mɨdek tob wagɨn sɨŋak lel nɨŋlɨg gɨ, kɨrop gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nɨg gek, bin bɨ nɨb okok nɨŋɨl, wal agɨl aglak, “Cɨn Isrel bin bɨ God cɨn ak tep yɨb. Bin bɨ aleb adɨk gak okok gek, mɨnɨm agebal; bin bɨ ñɨn tob gɨ gogeb mogeb gak okok gek, komɨŋ lɨp; bin bɨ tob tɨmel gak okok gek, tag tep gebal; bin bɨ udɨn kwoi gak okok gek, udɨn ñɨl nɨŋebal,” agɨl, yɨb nop agel ar amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas bɨ ne aknɨb umɨgan alaŋ kɨrop sɨk agek, apelak, agak, “Bin bɨ sɨŋ aul kɨrop yɨmɨg nɨŋebin. Ñɨn omal nokɨm yad eip mɨdesal pen kɨri tap magɨl ma mɨdeb. Kɨrop yokop ag yoken, amɨl kanɨb nab sɨŋak udɨn mɨmain apek, ap yap paknɨmel rek lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Agek, bɨ ne okok pen aglak, “Karɨp lɨm bin bɨ koŋai ma mɨdebal nab nɨb sɨŋ aul, cɨn tap magɨl akal nɨb pɨyo nɨŋɨl dapɨl, bin bɨ koŋai nep nɨb sɨŋ aul kɨrop ñon ñɨŋnɨgal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Agelak, Jisas agak, “Bred won nɨbi titi gɨ rek mɨdeb?” agak. Agek, aglak, “Bred aknɨb ar oŋɨd kɨbsal sɨkol ognap sek mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Agelak, Jisas bin bɨ okok kɨrop agek, lɨm ar nɨb sɨŋak bɨsɨglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kɨri nɨg gɨl bɨsɨgel nɨŋlɨg gɨ, ne bred magɨl aknɨb ar oŋɨd ak dɨl, kɨbsal sɨkol okok abe dɨl, God nop tep agɨl, tɨ paŋɨl, bɨ ne okok kɨrop ñek, kɨri pen dɨl, bin bɨ okok kɨrop nonɨm lɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nɨg gɨl nonɨm lɨ ñelak, ñɨbel, ñɨbel, kogi gek, ñɨb saknɨmel rek ma lak. Dai dai kɨrɨg gɨlak okok me, Jisas bɨ ne okok wad aknɨb ar oŋɨd dɨ yɨgel, pɨs nep ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bin bɨ tap ñɨŋlak nɨb okok, bin okok mer, ñɨ pai sɨkol okok mer, bɨ okok nep me, po tausan rek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pen nɨg gɨl tap ñɨbɨl, Jisas bin bɨ nɨb okok kɨrop ag yokɨl, ne ñɨg magöb dɨl, karɨp lɨm Magadan pɨs kɨdeim amɨl, karɨp lɨm nab nɨb okok amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bɨ Perisi ognap, bɨ Sadyusi ognap, Jisas tari gɨnɨmɨŋ nop ag juɨn, agɨl, apɨl nop aglak, “Nak Mesaia ak mɨdebin apan ak, tap ma gep rek alap seb kab ar alaŋ nɨb gek nɨŋɨl, nɨŋɨd apan agɨl, nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Agelak, Jisas pen agak, “Pɨb paŋɨd amɨl, seb kab lakañ lakañ gek nɨŋlɨg gɨ agnɨgabɨm, ‘Karɨp tɨk tep gɨnɨgab,’ agnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kɨslɨm sek pɨb lɨm gɨnɨg gɨl lakañ lakañ gɨl seb karɨk ñek nɨŋlɨg gɨ, agnɨgabɨm, ‘Mɨñab paknɨg geb,’ agnɨgabɨm. Nɨg gɨl nɨŋ tep gɨpɨm ak pen yad mɨñi tap tari tari gebin aul, nɨbi nɨpɨm pen wagɨn ak ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nɨbi bin bɨ mɨñi mɨdebɨm okok, mɨd tep ma gɨl, God nop gos ak ma nɨpɨm. Tap ma gep rek alap gek nɨŋɨn, agebɨm ak, yad gen ma nɨŋnɨgabɨm. Bɨ Jona nop gak rek, ar ak yɨp gek, nɨŋnɨgabɨm,” agak. Jisas nɨb agɨl, kɨrop kɨrɨg gɨl mɨgan alap amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas abe, bɨ ne okok abe ñɨg magöb dɨl, ñɨg cöb pɨs kɨdadaŋ amɨl nɨŋlak, bred okok saköl gɨl ma dolak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nɨg nɨŋɨl Jisas bɨ ne okok kɨrop agak, “Bɨ Perisi, bɨ Sadyusi, yɨs kɨri ak, nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jisas nɨb agak nɨŋɨl, bɨ ne okok, ke ag nɨŋ ag nɨŋ gɨl aglak, “Cɨn bred ma dopɨn ak me, nɨb ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Pen Jisas kɨri agelak nɨbak ke nɨŋɨl agak, “Nɨbi tari gɨnɨg bred ma dopɨn, agɨl, ag amɨl apɨl gebɨm? Nɨbi yɨp nɨŋ dɨ tep ma gɨpɨm. Bɨ paip tausan rek mɨdelak ñɨn ak, bred won aknɨb mamɨd ak dɨl, dɨ pag gɨ ñenek, ñɨbɨl dai dai yepɨl yepɨl gelak, wad titi rek yɨgem ap ran jakak? ");
INSERT INTO kmh_m_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Pen ñɨn kɨsen ak, bred won aknɨb ar oŋɨd dɨl, bɨ po tausan rek mɨdelak ak ñenek, ñɨbɨl dai dai yepɨl yepɨl gelak, wad titi rek yɨgem ap ran jakak? ");
INSERT INTO kmh_m_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ñɨn nɨbak nɨbi ke mɨdɨl, bred wad yɨpek ak pen mɨñi mɨnɨm sɨd tɨkɨl agesin ak ma nɨŋɨl, ‘Bred tap agɨl ageb,’ agebɨm. Bred tap okok agɨl ma agebin. Bɨ Perisi okok abe, bɨ Sadyusi okok abe, yɨs kɨri ak nɨbep dɨnɨmɨŋ rek lɨp ak, agɨl, agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nɨb agek, kɨri nɨŋlak tap yɨs bred sek lɨpal ak ma agak; bɨ Perisi okok abe, bɨ Sadyusi okok abe, mɨnɨm ag ñɨbal ak ma nɨŋnɨmɨb, agɨl, mɨnɨm sɨd tɨkɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kɨsen Jisas taun kɨb Sisaria Pilipai nab sɨŋak amjakɨl, bɨ ne okok kɨrop ag nɨŋɨl agak, “Bin bɨ okok Bɨ Ñɨ ne bɨ an apal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Agek, bɨ ne okok aglak, “Ognap Jon bɨ ñɨg pak ñeb ak, apal; ognap, Ilaija, apal; ognap, Jeremaia, apal; ognap pen bɨ God mɨnɨm agep alap, apal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Agelak, Jisas kɨrop agak, “Nɨbi ke pen, yɨp an agɨl nɨpɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Agek, bɨ ne Saimon Pita agak, “Nak Mesaia, God komɨŋ Ñɨ ne ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Agek, Jisas agak, “Jona ñɨ ne Saimon. Mɨnɨm ageban nɨbak, tep ageban. Nak gos yɨpɨd gɨl nɨpan nɨbak, ke okok nɨb ma owɨp; Bapi seb kab ar alaŋ ak nep, nep gos nɨbak ñek, nak yɨpɨd gɨl nɨpan. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Yad nep agebin, nak Pita. Gos yɨpɨd gɨl nɨpan nɨbak, yad bin bɨ yad tɨgoŋ tɨgoŋ poŋ dapɨl, cöc yad kab nɨbak ar ak lɨnɨgain. Kɨmeb magɨl ak cöc yad gek, yap paknɨmɨŋ rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“God karɨp lɨm seb kab ar alaŋ sɨŋak, pɨyam ur ak nep ñɨnɨgain. Nak lɨm dai wagɨn aul mɨdɨl, mɨñ ar akal nɨŋɨl, yɨpɨd gɨl ma gɨp, mer agenɨgan ak, God seb kab ar alaŋ sɨŋak, ak rek nep mer agnɨgab. Pen mɨñ ar akal nɨŋɨl, yɨpɨd gɨl mɨdeb, yau agenɨgan ak, God seb kab ar alaŋ sɨŋak, ak rek nep yau agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jisas nɨb agɨl, bɨ ne okok kɨrop agak, “Bin bɨ okok kɨrop, yad Mesaia me nɨbak, agɨl, ma agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ñɨn nab nɨb ak, Jisas bɨ ne okok kɨrop, bɨ okok yɨp nɨg nɨg gɨnɨgal, agɨl, mɨseŋ agɨl agak, “Yad kɨsen Jerusalem amen, bɨ mɨnɨm dɨ bɨlokep okok lɨl, bɨ God nop tap sobok gep bɨ kɨb okok lɨl, bɨ God lo mɨnɨm ag ñeb bɨ okok lɨl, yɨp yur ñɨl ñag pak lɨnɨgal. Pen ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nɨb agek, Pita, Jisas nop dam gol sɨŋak amɨl, mɨnɨm kɨlɨs rek agɨl agak, “Bɨ Kɨb! Nep nɨg ma gɨnɨmɨŋ! Mɨnɨm nɨbak ag tep ma gɨpan. God nep kod mɨdek, nɨg ma gɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Agek, Jisas adɨk gɨl, Pita nop agak, “Seten, yɨp kɨrɨg gɨl amnoŋ! Yɨp tari gɨnɨg mer agɨl ageban? God gos nɨŋɨp rek ma nɨpan; bin bɨ gos nɨpal rek nep nɨŋɨl ageban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jisas nɨb agɨl, bɨ ne okok kɨrop agak, “Bin bɨ an an, Jisas pɨs ken ar mɨdon, agenɨmel ak, tap lɨm dai wagɨn aul gos kɨb nɨpal ak kɨrɨg gɨl, mɨb goŋ kɨri ke gos kɨb nɨpal ak kɨrɨg gɨl, mab kros dɨ ka gɨl yɨp sain gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bin bɨ an, yad Jisas nop den tep ma gɨnɨgab, agɨl, nɨŋnɨgab ak, komɨŋ ma mɨdenɨgab; pen bin bɨ an, yad Jisas nop nɨŋ dɨ mɨden yɨp tap tari tari genɨmel ak, mɨnɨm ma mɨdeb, agnɨgab ak, per nep komɨŋ nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Bin bɨ an, tap lɨm dai ar wagɨn aul dɨnɨm, agɨl, gek amnɨgab ak, gos kɨb ne ak ar nɨbak nep amenɨgab me, komɨŋ per mɨdep ak ma dɨnɨgab. Akaŋ God nop tap nɨb okok tauɨl, komɨŋ per mɨdep ak dɨnɨgab? Mer yɨb! ");
INSERT INTO kmh_m_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Kɨsen yad Bɨ Ñɨ ne, Bapi melɨk kɨlɨs dɨl, ejol okok eip adɨk gɨ onɨgain ñɨn ak, mɨnɨm kɨb nɨŋɨl, bin bɨ okok kɨri tap tari tari rek gɨpal okok nɨŋɨl kɨrop pen ñɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Yad nɨbep nɨŋɨd yɨb agebin, nɨbi bin bɨ mɨdebɨm sɨŋ aul, ognap komɨŋ mɨdenɨgabɨm ak me, Bɨ Ñɨ ne bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab ñɨn ak, Bɨ Ñɨ ne apek nɨŋlɨg gɨ, nop nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisas mɨnɨm nɨbak agɨl, ñɨn aknɨb kagol oŋɨd ak mɨdɨl, Pita, Jems, Jems nɨmam Jon kɨrop yakam poŋ dɨl, dɨm i oklaŋ alap amɨl, ke mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nɨg gɨl mɨdel nɨŋlɨg gɨ, Jisas mɨb goŋ ne ak ke yɨb lɨl, mɨlɨk dai ak pɨb rek nɨŋɨl, walɨj ne ak melɨk melɨk yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nɨg gek nɨŋlɨg gɨ, kɨri nɨŋlak, bɨ God mɨnɨm agep ned kɨmrek, Mosɨs eip Ilaija eip, apɨl Jisas eip mɨnɨm ag mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kɨri nɨŋɨl, Pita ne Jisas nop agak, “Bɨ Kɨb. Cɨn sɨŋaul mɨdobɨn ak, tep yɨb mɨdobɨn. Nak yau agnɨmɨn, karɨp badak omal nokɨm gɨn, nep alap, Mosɨs nop alap, Ilaija nop alap,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita nɨb agek nɨŋlɨg gɨ, seb tɨd yɨb bad alap apɨl, kɨrop magɨlsek pɨrau yɨpɨl yokak. Pɨrau yɨpɨl yokek nɨŋlɨg gɨ, mɨnɨm alap seb nab nɨbak nɨb agak, “Ñɨ mɨdmagɨl yad aul, yɨp tep yɨb gɨp. Mɨnɨm tari tari agnɨmɨŋ ak, nɨŋ dɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mɨnɨm nɨbak nɨg gɨl apek nɨŋɨl, Jisas bɨ ne okok gos par nɨŋɨl, pɨrɨkɨl, am lɨm wagɨn sɨŋak pakɨl, mɨlɨk dai kɨri ak lɨm eyaŋ lɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas apɨl, kɨrop dɨ nɨŋɨl agak, “Ma pɨrɨknɨmɨb. Warɨkɨm!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Agek, warɨkɨl nɨŋlak, Jisas ne ausek nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pen kɨri mak ak kɨyan gɨ amlɨg gɨ, Jisas kɨrop agak, “Mɨñi tari tari gosɨp nɨpɨm nɨbak, bin bɨ okok kɨrop ma ag ñɨnɨmɨb. Kɨsen Bɨ Ñɨ ne kɨmɨl warɨknɨgab ñɨn ak me, bin bɨ okok kɨrop ag ñɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Agek, bɨ ne okok nop aglak, “Lo mɨnɨm ag ñeb bɨ okok tari gɨnɨg apal, ‘Ilaija ned onɨgab, kɨsen Mesaia lɨm dai wagɨn aul onɨgab,’ apal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Agelak, Jisas pen agak, “Nɨŋɨd apal. Mɨnɨm nɨbak mɨdeb: ‘Ilaija ned apɨl kɨrop ag tep genɨgab, kɨsen Mesaia onɨgab.’ ");
INSERT INTO kmh_m_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pen nɨŋɨm. Ilaija owak ak pen apek, nop ma nɨŋlak. Gos kɨri ke nɨŋlak rek, nop gɨ tɨmel gɨlak. Bɨ Ñɨ ne ak nop ak rek nep gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas nɨb agek, bɨ ne okok nɨŋlak, Jisas Ilaija yɨb agak ak pen Jon bɨ ñɨg pak ñeb ak nop nep agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pen kɨri gɨmeŋ eyaŋ amjakɨl nɨŋlak, bin bɨ koŋai nep mɨdelak. Bɨ alap, bin bɨ mɨdelak nab nɨb sɨŋak apɨl, Jisas mɨdek sɨŋak kogɨm yɨmɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bɨ Kɨb. Ñɨ yad ak yɨmɨg nɨŋnɨmɨn. Nop saköl ñagek, mɨd tep ma gɨp. Per amɨl, mab yɨneb nab okok abe, ñɨg nab okok abe gɨ dam pakeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nop dam bɨ nak okok mɨdesal sɨŋak dad amen, gɨ mer nɨŋɨl kɨrɨg gɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Agek, Jisas agak, “Nɨbi bin bɨ mɨñi ñɨn aul mɨdebɨm okok, God nop gos nɨŋɨl ma nɨŋ dɨpɨm; God ageb rek ma gɨpɨm. Mɨnek akal nɨbi nɨŋ dɨl ke gɨnɨgabɨm? Ñɨ nɨbak dɨ yad mɨdebin sɨŋaul dowɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Agek, ñɨ nɨbak dapelak, Jisas kɨjeki nop abaŋ ñagak ak ag gek, söŋ amek, won ak nep komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nɨg gek, Jisas bɨ ne okok ne mɨdek sɨŋak apɨl, ke nep mɨdlɨg gɨ, nop ag nɨŋɨl aglak, “Tari gek, kɨjeki abaŋ ñagak nɨbak, ag yok mer nɨŋɨl kɨrɨg gɨpɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Agelak, Jisas pen agak, “Nɨŋ dep won nɨbi ak ulep gɨp ak me, ag yok mer nɨŋɨl kɨrɨg gɨpɨm. Pen nɨŋɨm! Nɨŋ dep won nɨbi ak mab mastad yɨŋ magɨl sɨkol mɨdeb rek ak mɨdenɨgab ak, tap tari tari gɨnɨgabɨn, ag gos nɨŋnɨgabɨm ak, gɨnɨgabɨm. Dɨm yɨrɨk aul, ‘Pag okdaŋ amnoŋ,’ agnɨgabɨm ak, amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pen kɨjeki abaŋ ñagɨp nɨbak, yokop ag yoknɨmɨb rek ma lɨp. Tap magɨl kɨrɨg gɨl, God nop sobok gɨlɨg gɨ mɨdɨl me, ag yoknɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas bɨ ne okok eip karɨp lɨm Galili apɨl mogɨm gɨl, kɨrop agak, “Maŋ mɨdeb, Bɨ Ñɨ ne nop dam bin bɨ ognap kɨrop ñɨnɨgal, ");
INSERT INTO kmh_m_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nop pɨs nep ñag pak lel kɨmnɨgab ak pen ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. Jisas nɨb agek, bɨ ne okok nop mapɨn nɨŋɨl, gos par yɨb nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pen kɨsen, Jisas bɨ ne okok eip taun sɨkol Kapaneam amjakel, bɨ God sobok gep karɨp takɨs dep bɨ okok kɨri apɨl Pita nop aglak, “Mɨnɨm ag ñeb bɨ nɨbi ak takɨs ñɨb sek aka mer?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Agelak, Pita pen agak, “Yau, ne takɨs ñɨb sek,” agak. Pen Pita nɨb agɨl, karɨp mɨgan amek nɨŋlɨg gɨ, Jisas ne ned agɨl, Pita nop ag nɨŋɨl agak, “Gos nak tari nɨpan? Gapman bɨ kɨb okok, takɨs mani akal nɨb dɨpal? Bin bɨ kɨri ke okok nɨb dɨpal akaŋ bin bɨ par okok nɨb dɨpal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Agek, Pita pen agak, “Bin bɨ par okok nɨb dɨpal,” agak. Agek, Jisas agak, “Nɨŋɨd, bɨ kɨri ke okok takɨs ma ñɨbal. ");
INSERT INTO kmh_m_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pen cɨr mal ma ñonɨgabɨr ak, kɨrop mɨlɨk yonɨmɨŋ rek lɨp. Nɨb ak, nak ñɨg cöb sɨŋak amɨl, nag wɨk yokɨl, kɨbsal ned dɨnɨgan ak, meg mɨgan tɨg lakɨl nɨŋnɨgan, kab magɨl nokɨm alap meg mɨgan ak mɨdenɨgab. Dɨl dam takɨs cɨr mal ak ñɨnɨmɨn,” agak. Agek me, am agak rek nep gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jisas bɨ ne okok apɨl, nop ag nɨŋlak, “Bin bɨ God dɨl, seb kab ar alaŋ sɨŋak kod mɨdenɨgab okok, an bin kɨb bɨ kɨb mɨdenɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Agelak, Jisas ñɨ pai sɨkol alap sɨk agek apek, dɨ udɨn yɨrɨk ar kɨrop sɨŋak warɨk ñɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","agak, “Yad nɨbep nɨŋɨd yɨb agebin, nɨbi ñɨ pai sɨkol okok gos nɨpal rek ma nɨŋnɨgabɨm ak, God karɨp lɨm seb kab ar alaŋ sɨŋak ma amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nɨb ak, bin bɨ cɨn bin bɨ kɨb ma mɨdobɨn agɨl, ñɨ pai sɨkol aul rek mɨdenɨgal ak me, God bin bɨ ne ke dɨl, kod mɨdenɨgab nab sɨŋak, bin bɨ kɨb rek mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pen bin bɨ yɨp nɨŋ dɨl, ñɨ pai sɨkol aul rek dɨ tep gɨnɨgal ak, kɨrop nep mer, yɨp abe dɨ tep gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Pen bin bɨ ognap apɨl, ñɨ pai yɨp gos nɨŋ dɨpal okok, kɨrop tap si tap tɨmel ar ak gɨ yomel, kɨri gos yɨp ak yɨpɨn gɨl, tap si tap tɨmel gɨnɨgal. Bin bɨ nɨg gɨnɨg genɨgal ak, ned makɨd kɨb alap kɨŋam kɨri mɨñ dɨ lɨ rɨbɨkɨl, dam ñɨg solwara nab sɨŋak yoknɨgal ak tep. Komɨŋ mɨdɨl, nɨg gɨ tɨmel yɨb gɨnɨgal ak, yur kɨb yɨb dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Bin bɨ lɨm dai wagɨn aul mɨdebal okok mɨker yɨb gɨnɨgab. Mɨñ tɨmel ar ak gɨl, bin bɨ ognap kɨrop gos ñel, ar nɨbak gɨl ap yap paknɨgal ak, tɨmel yɨb gɨnɨgab. Mɨñ ar nɨbak ned gölɨgɨpal, mɨñi gɨpal, kɨsen ak rek nep gɨnɨgal. Nɨg gɨnɨgab ak pen bin bɨ ar nɨbak gɨ yomnɨgal okok, yur ke yɨb dɨnɨgabal. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ñɨnmagɨl tob nɨbi ak nɨŋɨl, tap si tap tɨmel gɨnɨg genɨmɨŋ, ñɨnmagɨl tob nɨbak tɨb gɨ rɨk dɨ yoknɨmɨb. Nɨg gɨl me, tap si tap tɨmel gep ar ak kɨrɨg gɨl, God karɨp lɨm sɨŋak amɨl, per per mɨdenɨgabɨm. Mer ak, ñɨnmagɨl tob sek mɨdɨl, pen mɨd tep ma gɨl, tap si tap tɨmel gep ar ak gɨ damɨl, karɨp lɨm mab ke per yɨn mɨdeb sɨŋak amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Pen udɨn ak nɨŋɨl, tap si tap tɨmel gɨnɨg genɨmɨŋ, udɨn nɨbak tɨg gɨlɨg gɨ yoknɨmɨb. Nɨg gɨl me, tap si tap tɨmel gep ar ak kɨrɨg gɨl, God karɨp lɨm sɨŋak amɨl, per per mɨdenɨgabɨm. Mer ak, udɨn omal sek mɨdɨl, pen mɨd tep ma gɨl, tap si tap tɨmel gep ar ak gɨ damɨl, karɨp lɨm mab ke per yɨn mɨdeb sɨŋak amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nɨbi nɨŋ tep gɨnɨmɨb, ñɨ pai sɨkol okok tap yokop, agɨl, gos ak ma nɨŋnɨmɨb. Yad nɨbep agebin, ñɨ pai sɨkol okok ejol kɨri okok, Bɨñen yad udɨn yɨrɨk ar ne ak karɨp lɨm seb kab ar alaŋ sɨŋak mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Bɨ Ñɨ ne ak, bin bɨ kɨr gɨpal okok, kɨrop dɨnɨg owak. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bɨ alap kaj sipsip ne ñɨn juɨl aknɨb mamɨd alaŋ rek mɨdenɨgab. Pen nokɨm alap kɨr genɨgab ak, ne tari gɨnɨgab? Sipsip ne ognap kɨrop kɨrɨg gek, tap kas kas ñɨb mɨdel nɨŋlɨg gɨ, ne amɨl sipsip ne kɨr gɨnɨgab ak nop pɨyo nɨŋek amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Am pɨyo pɨyo nɨŋ dɨl, mɨñ mɨñ yɨb gɨnɨgab. Nɨbep nɨŋɨd agebin, kaj sipsip ne magɨlsek mɨñ mɨñ gɨp, pen kaj sipsip ne alap kɨr gek, pɨyo nɨŋ dam dam dɨnɨgab ak, sipsip nɨbak nep mɨñ mɨñ yɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nɨb ak rek, Bɨñen nɨbi seb kab ar alaŋ mɨdeb ak, ñɨ pai sɨkol ne alap ma kɨr gɨnɨmɨŋ, agɨl, nɨŋ nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Bin bɨ ai mam, agnɨgan okok, bɨ alap nep gɨ tɨmel genɨmɨŋ, nak pen amɨl, nop eip ke mɨdɨl, nep tap tari gak nɨbak mɨseŋ agnɨmɨn. Nɨb agek, nɨŋ denɨgab ak me, nanai namam nak yɨb mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pen nak nɨg gek, ne ma nɨŋenɨgab ak, nak amɨl, ai mam omal sek ulɨk gɨ damɨl, kɨri nɨŋ mɨdel nɨŋlɨg gɨ, nak bɨ nɨbak eip mɨnɨm agnɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pen nak nɨg gek, ne mɨnɨm nɨrep ma donɨmɨŋ ak, bin bɨ cöc opal rek magɨlsek nɨŋ mɨdel nɨŋlɨg gɨ, mɨnɨm nɨbak kɨrop ag ñɨnɨmɨn. Pen nak nɨg gek, bɨ nɨbak bin bɨ cöc opal mɨnɨm ma donɨmɨŋ ak, nop kɨrɨg gɨnɨmɨn. Bɨ nɨbak bin bɨ God Mɨnɨm ma nɨŋɨl, bɨ takɨs dep rek ak me, nɨg gɨp, agɨl, nop kɨrɨg gɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nɨb ak, yad nɨbep nɨŋɨd agebin, lɨm dai ar wagɨn aul mer genɨgabɨm ak, God ne seb kab ar alaŋ mɨdɨl, ak rek nep mer agnɨgab; pen yau agenɨgabɨm ak, ne ak rek nep yau agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Yad nɨbep agebin, bin bɨ omal lɨm dai wagɨn aul mɨdɨl, mɨnɨm ag ar nokɨm lɨl, Bapi yad seb kab ar alaŋ mɨdeb ak nop ag nɨŋenɨgair ak, ag nɨŋnɨgair rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pen bin bɨ omal akaŋ omal nokɨm rek, gos yɨp nɨŋɨl, ap mogɨm genɨgal ak, yad kɨrop nab nɨb sɨŋak mɨdenɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Jisas mɨdek maŋ sɨŋak apɨl agak, “Bɨ Kɨb. Mam alap yɨp gɨ tɨmel genɨmɨŋ ak, ñɨn titi rek gɨ tɨmel genɨgab, yad nɨŋɨl kɨrɨg gɨnɨm? Ñɨn aknɨb ar oŋɨd ak rek aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Agek, Jisas agak, “Ñɨn aknɨb ar oŋɨd mer; nak bɨ nɨbak nep gɨ tɨmel gɨnɨgab ak nɨŋɨl kɨrɨg gɨnɨgan ak, ñɨn juɨl ñɨn juɨl aknɨb ar oŋɨd ak nɨŋɨl kɨrɨg gɨnɨgan. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","God bin bɨ dɨl karɨp lɨm seb kab ar alaŋ sɨŋak kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek mɨdeb. Kiŋ alap ne bɨ wög gɨ ñeb ne ognap kɨrop mani ognap ñɨl, kɨsen pen ñɨm agnɨgab. Kɨsen ne gos nɨŋɨl agnɨgab, ‘Kɨri dai ñɨlaŋ,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pen mɨdeb ak pen ñɨnɨgal, agek, bɨ alap ne mani yɨr ñɨn juɨl koŋai yɨb tap dai mɨdenɨgab bɨ ak donɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pen bɨ nɨbak pen ne kɨb yɨb mɨdenɨgab ak me, pen ñɨnɨmɨŋ rek ma lɨnɨgab. Nɨg gek, bɨ kɨb ak nɨŋɨl, bɨ wög gep bɨ ne ognap kɨrop agnɨgab, ‘Ne gɨp nɨbak rek, nop dɨl, bin ñɨ pai, tap ne tari tari mɨdeb okok magɨlsek dɨl, dam sɨkim gem, tauenɨmel nɨŋlɨg gɨ, mani nɨbak dap yɨp ñɨnɨmɨb,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nɨb agek, bɨ nɨbak pen, kogɨm yɨmɨl, bɨ kɨb ak nop agnɨgab, ‘Nak yɨp mapɨn nɨŋɨl, kod mɨdenɨmɨn; tap dai nak nɨb okok magɨlsek dai pagnɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Agek, bɨ kɨb ak nop mapɨn nɨŋɨl, tap dai ne ak, nak kɨrɨg gɨl amnoŋ, agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bɨ kɨb ak dai nɨbak kɨrɨg gek nɨŋlɨg gɨ, bɨ wög gɨ ñeb nɨbak ne pen amɨl nɨŋnɨgab, bɨ ne eip wög gölɨgɨpir bɨ alap mɨdenɨgab. Nop nɨŋɨl, kɨŋam nop dɨ cɨcɨ lɨl agnɨgab, ‘Nep mani yɨr nokɨm alap ñɨnek ak dai pagan!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Agek, bɨ ne eip wög gölɨgɨpir nɨbak kogɨm yɨmɨl mɨnɨm neb neb gɨ agɨl agnɨgab, ‘Nak yɨp mapɨn nɨŋɨl, kod mɨdenɨmɨn; tap dai nak nɨbak magɨlsek dai pagnɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Agek, bɨ nɨbak mɨnɨm nop ak ma nɨŋɨl agnɨgab, ‘Nep dam mɨñ lenɨgain, tap dai nɨbak magɨlsek dai pagenɨgan ak me, söŋ amnɨgan,’ agɨl, nop dam mɨñ lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nɨg gek, bɨ ne eip wög gɨpal okok, kɨrop cɨbur tɨmel gek, amɨl kiŋ ak nop mɨnɨm nɨbak magɨlsek ag ñɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ag ñel, bɨ kɨb ak, bɨ ne nɨbak nop sɨk agek apek agnɨgab, ‘Nak wög gɨ ñeb bɨ tɨmel yɨb. Nak yɨp sɨl agesan, nep yɨmɨg nɨŋɨl, tap dai yad nep mɨdeb ak kɨrɨg gɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nak pen tari gɨnɨg, bɨ nak eip wög gɨpir ak nop ak rek nep yɨmɨg nɨŋɨl, ma kɨrɨg gɨpan?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bɨ nɨbak bɨ ne eip wög gölɨgɨpir ak nop yɨmɨg ma nɨŋnɨgab ak me, bɨ kɨb nɨbak kal juɨl, wög gɨ ñeb bɨ nɨbak nop dam mɨñ lep kau kodep bɨ okok ñɨl agnɨgab, ‘Nop mɨñ lek, yur gek nɨŋlɨg gɨ mɨdɨl, tap dai yɨp ak magɨlsek dai pag juɨl me söŋ amnɨgab,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nɨbi ai mam ognap kɨrop ak rek nep genɨgabɨm, Bapi yad seb kab ar alaŋ sɨŋak mɨdeb ak, nɨbep pen ak rek nep gɨnɨgab. Nɨb ak, nanai namam nɨbi okok nɨbep gɨ tɨmel genɨgal ak, kɨrop yɨmɨg nɨŋɨl, mɨdmagɨl lɨl, kɨrɨg gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas mɨnɨm nɨbak ag mɨbɨl juɨl, karɨp lɨm Galili kɨrɨg gɨl, karɨp lɨm Judia, ñɨg Jodan pɨs kɨdadaŋ ken amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Amek, bin bɨ koŋai yɨb nop kɨsen gelak nɨŋɨl bin bɨ tap gak okok gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pen bɨ Perisi okok, Jisas nop ag nɨŋon, mɨnɨm tɨmel ognap agnɨmɨŋ, agɨl, apɨl aglak, “God Mosɨs nop ag ñak lo mɨnɨm ak, bin alap tap sɨkol alap gɨ tɨmel gɨnɨgab ak, bɨ ne nop ag yoknɨg, ag yoknɨgab aka mer? Nak tari gos nɨpan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Agelak, Jisas pen agak, “God Mɨnɨm ñu kɨl tɨklak ak nɨbi udɨn lɨ ma nɨpɨm ar? Karɨp lɨm bɨrarɨk ped okok gɨ lak ñɨn ak, God ne bɨ alap, bin alap, gɨ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God agak, ‘Ar nɨbak me, bɨ okok nonɨm nap sɨkop eip mɨdɨl, bin dɨl, nonɨm nap kɨrɨg gɨl, kɨri ber mal jɨm ñɨl kɨn mɨdel mɨb goŋ nokɨm yɨb lɨnɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nɨb ak me, God agek mɨb goŋ kɨri mal mer, mɨñi jɨm ñɨl nokɨm lɨnɨgab nɨbak, bɨ alap apɨl, kɨrop ag tɨg asɨk ke ke ma lɨnɨgab mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jisas nɨb agek, bɨ Perisi okok nop aglak, “Pen tari gɨnɨg Mosɨs mɨnɨm alap ñu kɨl tɨkɨl agak, ‘Bin ag yoknɨg, bin aul pɨs nep kɨrɨg gebin, agɨl, mɨj alap ñu kɨl tɨk ñɨl, ag yoknɨmɨb,’ agak?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Agelak, Jisas pen agak, “Nɨbi bin bɨ mɨnɨm ma nɨŋ dɨpɨm ak me, Mosɨs nɨb agak. Pen God bin bɨ bɨrarɨk okok gɨ lak ñɨn ak, nɨg ma gölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pen yad nɨbep agebin, bɨ an, bine ak bɨ alap eip dɨ ger mer, yokop nep ag yokɨl, bin kɨsen nɨb dɨnɨgab ak, bin si dɨnɨgab nɨŋɨl God nɨŋek tɨmel yɨb gɨnɨgab; ne bin si dep bɨ me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas nɨb agek, bɨ ne okok aglak, “Bɨ okok bin kɨri yokop ma ag yoknɨgal ak, bɨ praj mɨdɨl bin ma dɨnɨgal ak tep,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Agelak, Jisas agak, “Bɨ magɨlsek yokop mɨdenɨmel rek ma lɨp. God bɨ yokop mɨdenɨmel, agɨl, ag lak bɨ okok nep, yokop mɨdenɨmel rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bɨ ognap, kɨri walak ma lek tɨk dopal okok, bin ma dɨpal. Bɨ ognap, bɨ ognap walak kɨrop tɨb gɨ rɨk gɨpal okok, bin ma dɨpal. Pen bɨ ognap, God bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab wög ak gɨn, agɨl, bin ma dɨpal. Nɨbi, bɨ praj mɨdon, agɨl, bɨ praj nep mɨdenɨmɨb ak tep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bin bɨ okok, “Jisas ñɨnmagɨl ñɨ pai cɨn nabɨc cög ar alaŋ lɨl, God nop sobok gaŋ,” agɨl dapelak, pen bɨ ne okok kɨrop nɨŋ i sek lɨl ag gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nɨg gel, Jisas pen ñɨ pai nɨb okok sɨk agek apelak nɨŋlɨg gɨ, bɨ ne okok kɨrop agak, “Tari gɨnɨg kɨrop nɨb ag gɨpɨm? Ñɨ pai sɨkol nɨb okok kɨrɨg gem yɨp olaŋ. God bin bɨ dɨl, seb kab ar alaŋ sɨŋak kod mɨdenɨgab ak, ñɨ pai sɨkol nɨb okok rek,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jisas nɨb agɨl, ñɨnmagɨl arak ne ak ñɨ pai sɨkol nabɨc cög ar alaŋ lɨl, karɨp lɨm mɨgan alap amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bɨ alap Jisas mɨdek sɨŋak apɨl agak, “Mɨnɨm ag ñeb bɨ. Yad tap tari tep ak gɨl, per komɨŋ mɨdep magɨl ak dɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Agek, Jisas pen agak, “Yɨp tari gɨnɨg, tap tep akal, agɨl, ag nɨŋeban? God nokɨm me Bɨ tep. Pen per per mɨdenɨm, agnɨmɨn ak, lo mɨnɨm agɨl ñu kɨl tɨklak okok nɨŋɨl ageb rek gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Agek, agak, “Lo ar akal rek ageban?” agak. Agek, Jisas agak, “Cɨp ma ñag paknɨmɨn; bin si bɨ si ma gɨnɨmɨn; tap si ma dɨnɨmɨn; mɨnɨm kɨb agnɨgal ak, mɨnɨm tom ma agnɨmɨn; ");
INSERT INTO kmh_m_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nanɨm nap mɨnɨm agnɨmir ar ak nep nɨŋɨl kɨsen gɨnɨmɨn; nak ke mɨdmagɨl lɨpan rek, bin bɨ ke nɨb okok kɨrop ak rek nep mɨdmagɨl lɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɨb agek, bɨ praj nɨbak agak, “Lo mɨnɨm okok magɨlsek nɨŋ sakpin. Pen yad tari tap tep ak gɨl, komɨŋ per mɨdep ak dɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Agek, Jisas agak, “Mɨd tep yɨb gɨnɨm, agnɨmɨn ak, tap nak okok magɨlsek sɨkim gɨl, mani dɨl, bin bɨ mapɨn gep rek okok kɨrop ñɨnɨmɨn. Nak nɨg genɨgan ak me, mɨd tep gep nak ak mɨdenɨgab God karɨp lɨm seb kab ar alaŋ sɨŋak. Pen yad agebin rek gɨl, apek yad eip ajor,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Agek, bɨ praj nɨbak tap ne koŋai mɨdek rek, mɨnɨm nɨbak nɨŋɨl, gos par lɨlɨg gɨ lɨlɨg gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pen ne nɨg gɨl amek nɨŋlɨg gɨ, Jisas bɨ ne okok kɨrop agak, “Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ mani tap kɨri koŋai mɨdenɨgab okok, God nop koslam gos nɨŋ del, kɨrop dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kaj kamel okok, ñu mauöl nag yokpal mɨgan ak amnɨg amnɨgal; pen bin bɨ tap koŋai mɨdeb okok, God nop koslam gos nɨŋ del, kɨrop dɨl kod mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jisas bɨ ne okok mɨnɨm nɨbak nɨŋɨl, gos par nɨŋlɨg gɨ aglak, “Pen bɨ tep nɨbak, God dɨ seb kab ar alaŋ sɨŋak ma dad amnɨgab, apan ak, bin bɨ an rek dad amnɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Agelak, Jisas kɨrop nɨŋlɨg gɨ agak, “Bin bɨ okok ke gɨnɨmel rek ma lɨp. God ne nep me, tap tari tari gɨnɨg, gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas nɨb agek, Pita agak, “Nɨŋan! Cɨn tap cɨn okok magɨlsek kɨrɨg gɨl, nak eip nep cɨg gɨl ajobɨn ak, cɨn pen tap tari dɨnɨgabɨn?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Agek, Jisas agak, “Yad nɨbep nɨŋɨd agebin, ñɨn kɨsen ak yad melɨk kɨlɨs sek apɨl, bin bɨ magɨlsek kod mɨdenɨgain. Ñɨn nɨbak me, nɨbep bɨ yɨp kɨsen genɨgabɨm okok agen, Isrel bin bɨ wagɨn ke ke aknɨb umɨgan alaŋ okok, kɨrop kod mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bin bɨ yɨp nɨŋ dɨl, karɨp, nɨnai nɨmam, nonɨm nap, ñɨ pai, wög dai, tap tari tari okok kɨrɨg gɨnɨgal okok, God kɨrop yɨpɨn ma gɨnɨgab; tap nɨb okok rek kɨrop pen koŋai yɨb ñɨl, per mɨdep kɨrop ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pen bin bɨ mɨñi ned amebal okok, kɨsen koŋai nep kɨd ken yɨb okok mɨdenɨgal. Pen bin bɨ mɨñi kɨd ken yɨb sɨŋak mɨdebal okok, kɨsen koŋai nep ned am mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas nɨb agɨl agak, “God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek mɨdeb. Bɨ wain wög nap nɨb alap, yad amɨl bɨ ognap dapen, wög yɨp ak gɨlaŋ, agɨl, mɨñab kɨsen tɨkak won ak warɨkɨl, am bɨ ognap pɨyo nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","nɨbep kab magɨl silpa won nokɨm nokɨm taunɨgain, agɨl, kɨrop eip mɨnɨm ag ar nokɨm alap lɨl, ag yokek, am wain wög ne ak wög gelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pen pɨb yokop nab sɨŋak ap raneb won ak, am maker sɨŋak amɨl nɨŋak, bɨ ognap yokop mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kɨrop nɨŋɨl agak, ‘Nɨbi ak rek nep am wain wög yad ak genɨgabɨm, yad nɨbep kab magɨl yɨpɨd gɨl taunɨgain,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Agek, am wög ne ak gelak. Pen pɨb nab kɨb alaŋ won ak abe, pɨb kim geb won ak abe, mɨnɨm nɨbak nep agɨl, bɨ ognap sek dek, wög ne ak gelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pɨb paŋɨd amnɨg geb won ak, kauyaŋ maker sɨŋak amɨl nɨŋak, bɨ ognap sek apɨl mɨdep nep mɨdelak. Kɨrop agak, ‘Nɨbi tari gɨnɨg ñɨn aul wög ma gɨl, yokop nep mɨdebɨm?’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Agek, nop aglak, ‘Bɨ alap cɨnop wög alap ma ñɨb,’ aglak. Agelak, kɨrop agak, ‘Nɨbi ak rek nep am wain wög yad ak gɨnɨmɨb,’ agek, am wög gelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dɨgep won ak, wain wög bɨ nap nɨb ak, bɨ kod mɨdep ne ak nop agak, ‘Nak amɨl, bɨ wög yɨp gebal okok kɨrop agek, apel, bɨ kɨsen agen opal okok, kab magɨl kɨrop ak ned ñɨnɨmɨn; bɨ ned agen opal okok, kab magɨl kɨrop ak kɨsen ñɨnɨmɨn,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Agek, bɨ kod mɨdep ak, bɨ nɨb okok kɨrop sɨk agek apelak, bɨ pɨb paŋɨd amek nɨŋlɨg gɨ, ap wög gelak okok, ap kab magɨl kɨri ak ned dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pen kɨri nɨg gɨl del nɨŋlɨg gɨ, bɨ ned agek ap wög gelak bɨ okok gos nɨŋlak, ‘Cɨn kab magɨl kɨb ak dɨnɨgabɨn,’ ag gos nɨŋlak ak pen kɨsen dɨlɨg gɨ nɨŋlak, kɨri kab magɨl ar nokɨm nɨbak nep dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dɨl, dai bɨ wain wög nap nɨb ak eip pen pen agɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Cɨn tari gɨnɨg, bɨ kɨsen opal okok kab magɨl dɨpal nokɨm ak rek nep dɨpɨn? Cɨn kɨslɨm sek warɨkɨl, pɨb kal nɨŋek nɨŋlɨg gɨ, wög gon gon yɨrɨk gɨp ak, pen bɨ alap aua eper alap nep wög gesal kab magɨl ñɨban rek nep cɨnop ñɨban!’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Agelak, bɨ wain wög dai nap nɨb ak nɨŋɨl, bɨ kɨri alap nop agak, ‘Mam, nɨŋan! Nep gɨ tɨmel ma gɨpin. Nep kab magɨl ñɨnɨgain apin rek ñɨbin. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Bɨ kɨsen opal okok, bɨ ned opal okok eip adɨp adɨp ñɨnɨg, ñɨnɨgain. Ak tap yad. Nɨb ak, bɨ ognap titi gɨl mer agnɨgal? Kɨrop abramek ñɨbin ak, nep ti gɨnɨg mɨlɨk yowɨp? Kab magɨl ñɨbin ak dad karɨp nak amnoŋ!’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas kesɨm nɨbak agɨl, agak, “Bin bɨ kɨsen mɨdebal okok, ned mɨdenɨgal; bin bɨ ned mɨdebal okok, kɨsen mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalem amlɨg gɨ, kanɨb nab sɨŋak, bɨ ne aknɨb umɨgan alaŋ kɨrop dam gol okok amɨl, ke mɨdelak nɨŋlɨg gɨ kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nɨbi nɨŋɨm! Cɨn Jerusalem amenɨgabɨn, Bɨ Ñɨ ne nop mɨmɨg gɨl, nop dam God nop tap sobok gep bɨ kɨb okok abe, lo mɨnɨm ag ñeb bɨ okok abe, ñɨnmagɨl ar kɨrop ak lenɨgal, kɨri nop mɨnɨm kɨb agɨl agnɨgal, ‘Bɨ aul nop ñag pak lep,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nɨb agɨl, Juda bɨ mer okok kɨrop ñenɨgal, nop ag juɨl, tapɨn pakɨl, dam mab bak alaŋ ñag pak lel kɨmnɨgab. Ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi ñɨ ne omal, nonɨm ñɨ nɨb omal poŋ dɨl, Jisas mɨdek sɨŋak apɨl, kɨbor kɨyan gɨl agak, “Yad mɨnɨm alap mɨdosɨp apebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Agek agak, “Mɨnɨm nɨbak tari?” agak. Agek, agak, “Yɨp tep gɨnɨgab ak, kɨsen nak kiŋ mɨdɨl, bin bɨ kod mɨdenɨgan ñɨn ak, ñɨ yad omal bak nep sɨŋak bɨsɨgnɨgair, alap yɨpɨd kɨd, alap aŋɨdken kɨd,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nɨb agek, Jisas bɨ omal kɨrop pen agak, “Mɨnɨm yɨp ag nɨŋebir ak, nɨŋ rep ma gebir. Ñɨg sɨlek yad ñɨŋnɨg gebin ak, nɨri mal ak rek nep ñɨŋnɨgair?” agak. Agek, agrek, “Yau! Ñɨŋnɨgabɨr!” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Agerek, agak, “Nɨŋɨd agebir. Ñɨg sɨlek ñɨŋnɨg gebin ak ñɨŋnɨgair. Pen bɨ an yɨpɨd pɨs kɨd, bɨ an aŋɨdken pɨs kɨd bɨsɨg mɨdenɨgair ak, ma agnɨgain. Mɨnɨm ak mɨnɨm yad mer; Bapi mɨnɨm ne. Bin bɨ ne ke ag lɨp okok nɨb rek mɨdenɨgair,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bɨ ne nɨb omal mɨnɨm nɨbak nɨb agerek, bɨ ne aknɨb wajrem alaŋ mɨnɨm ak nɨŋel, mɨlɨk yapek, madɨl mal kɨrop mɨnɨm ag gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisas pen bɨ ne okok kɨrop magɨlsek agek apelak agak, “Nɨbi nɨpɨm, Juda bin bɨ mer okok, kiŋ kɨri kɨlɨs gɨl, kod mɨdebal; bɨ kɨb kɨri mɨnɨm tari tari agnɨgal ak nɨŋɨl, kaun dɨl, sain gɨnɨgabal me. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pen kɨri gɨpal rek ma gɨnɨmɨb. Bɨ an bɨ kɨb mɨdonɨmɨŋ ak, bɨ sɨkol rek mɨdɨl, bin bɨ ognap kɨrop wög gɨ ñeb bɨ rek mɨdonɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bɨ an bɨ kɨb yɨb mɨdonɨmɨŋ ak, bɨ sɨkol tam okok rek mɨdɨl, bin bɨ ognap kɨrop mɨñ wög gep bɨ rek mɨdonɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bɨ Ñɨ ne owak ak, bin bɨ okok kɨri wög yɨp gɨlaŋ, agɨl, ma owak; wög kɨrop gɨ ñɨ damɨl, kɨsen tap si tap tɨmel gɨpal ar ak saj gɨ kɨmen, kɨri komɨŋ amnɨlaŋ, agɨl, owak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pen Jisas taun kɨb Jeriko kɨrɨg gɨl amek nɨŋlɨg gɨ, bin bɨ koŋai nep nop kɨsen gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bɨ udɨn kwoi gak omal kanɨb gol sɨŋak bɨsɨg mɨder nɨŋlɨg gɨ, “Jisas apeb,” agel nɨŋɨl, meg mɨgan dap ranɨl agrek, “Depid Ñɨ ne, cɨrop yɨmɨg nɨŋan!” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Agerek, bin bɨ okok kɨrop mal nɨŋ i sek agɨl aglak, “Mɨnɨm saköl ma agir!” aglak. Nɨb aglak ak pen, mɨnɨm kɨrop ak ma dɨl, meg mɨgan tapɨn dap ranɨl agrek, “Depid Ñɨ ne, cɨrop yɨmɨg nɨŋan!” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nɨb agerek, Jisas wös gɨl, kɨrop mal sɨk agɨl agak, “Cɨrop tari gaŋ, agɨl, yɨp sɨk agebir?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Agek, agrek, “Bɨ Kɨb, cɨrop udɨn kwoi gɨp ak gek ñɨl nɨŋɨr!” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Agerek, Jisas kɨrop mal yɨmɨg nɨŋɨl, udɨn kɨrop ak dɨ nɨŋek, magɨl ak nep udɨn ñɨl nɨŋɨl, ne amek nɨŋlɨg gɨ, kɨsen gɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas bɨ ne okok eip Jerusalem am maŋ maŋ gɨl, karɨp lɨm sɨkol Betpagi, Olip Dɨm ulep amjaklak. Amjakɨl, bɨ ne omal ag yokɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Nɨri mal karɨp tɨrɨg tɨroŋ pɨs adaŋ amɨl nɨŋnɨgair, kaj donki nonɨm ñɨlɨk amɨl mal mɨñ ñon gɨ lel mɨdenɨgair. Nɨŋɨl, mɨñ ak wɨsɨbɨl poŋɨd donɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pen bin bɨ alap apɨl, tari gɨnɨg kaj donki cɨnop ak wɨsɨb dad amebir agenɨmɨŋ ak, pen agnɨmir, ‘Bɨ Kɨb ak wög mɨdek, agosɨp dɨnɨg opɨr,’ agɨl, kasek yau agenɨgab, donɨgair,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pen kɨrop mal ag yokek amnɨrek nɨbak, bɨ God mɨnɨm agep alap gɨnɨgal, agɨl, ñu kɨl tɨkak rek nep gak. Ne agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem bin bɨ kɨrop agnɨmɨb, ‘Kiŋ nɨbi bɨ sain ak, kaj donki ar ak bɨsɨg gɨl, nɨbep apeb. Ne kaj donki ñɨlɨk ar ak bɨsɨg gɨl apeb,’ agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pen Jisas bɨ ne ag yokek amnɨrek nɨb omal, agak agak rek, ");
INSERT INTO kmh_m_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","kaj donki nonɨm abe, ñɨlɨk marɨp abe poŋɨd daperek, bɨ ne okok walɨj par tɨg juɨl, kaj donki ar alaŋ lelak, Jisas ar sɨŋak bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bin bɨ koŋai nep, Bɨ Kɨb apeb, agɨl, walɨj par kɨri ar alaŋ tol gɨ lölɨgɨpal okok tɨg juɨl, kanɨb kɨb sɨŋak lɨlak. Ognap am mɨj kas, mab kas okok tɨb gɨ rɨk dɨ dapɨl kanɨb kɨb sɨŋak lelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bin bɨ okok Jisas nop pɨŋɨl kɨs kɨs gɨlɨg gɨ, amlɨg gɨ, meg mɨgan dap ranlɨg gɨ, aglak, “Nɨŋɨm! Depid tɨkek, tɨk damɨl tɨkɨp ak, apeb me aul. Nop tep agobɨn! Bɨ Kɨb nop ag yokek apeb bɨ nɨbaul me, nop tep agobɨn!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jerusalem amjakek nɨŋlɨg gɨ, bin bɨ okok magɨlsek ag amɨl apɨl gɨl aglak, “Bɨ nɨbak bɨ an?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Agelak, bin bɨ Jisas eip olak okok aglak, “Bɨ aul me Jisas, bɨ God mɨnɨm agep Nasaret karɨp lɨm Galili nɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas God sobok gep karɨp mɨgan eyaŋ amɨl nɨŋak, bin bɨ okok tap sɨkim gɨ mɨdelak. Ne nɨŋɨl, kɨrop magɨlsek yɨk yokɨl, abañ bad kab magɨl lɨl pen pen yɨmjɨk gelak okok tɨg adɨk gɨl, bɨ yakɨr sɨkim gɨl mab bog ar bɨsɨg mɨdelak okok, tɨg adɨk gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nɨg gɨl kɨrop ag gɨl agak, “God Mɨnɨm ñu kɨl tɨklak ak, God agak, ‘Karɨp yad ak yɨp sobok gep karɨp, pen nɨbi gɨpɨm ak, bɨ tap si dep karɨp alap rek lɨp,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pen Jisas ne God sobok gep karɨp ñɨlɨk mɨgan nɨbak mɨdek nɨŋlɨg gɨ, bin bɨ udɨn kwoi gak ognap, bin bɨ tob tɨmel gak ognap apelak, kɨrop gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne tap ma gep rek gek, ñɨ pai sɨkol okok sɨk aglɨg gɨ aglak, “Nep tep agobɨn! Depid Ñɨ ne! Use!” aglak. Pen kɨri nɨg gelak ak, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe nɨŋel, kɨrop mɨlɨk yɨb yowak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mɨlɨk yapek aglak, “Mɨnɨm nep agebal ak nɨŋeban?” aglak. Agelak, Jisas kɨrop agak, “Yau! Agebal ak nɨŋebin ak pen kɨri mɨnɨm ognap ñu kɨl tɨkɨl aglak, ‘God, nak genɨgan nɨŋɨl ñɨ pai sɨkol ñɨ paiŋaŋ okok yɨb nep agel ar amnɨgab,’ aglak. Kɨri mɨnɨm ñu kɨl tɨklak nɨbak, udɨn lɨ ma nɨpɨm ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nɨb agɨl, kɨrop kɨrɨg gɨl, am karɨp tɨrɨg tɨroŋ Betani kɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mɨnek Jisas adɨk gɨ Jerusalem amɨl kanɨb nab okok amek, nop yuan gek, ");
INSERT INTO kmh_m_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","kanɨb kɨb gol sɨŋak nɨŋak, mab kɨyau ur alap mɨdek. Wagɨn sɨŋak amɨl nɨŋak, magɨl ñɨŋeb ma pɨlak; kas kab nep mɨdek. Nɨg gek Jisas agak, “Nak kɨsen magɨl alap ma pɨlnɨgan!” agak. Nɨb agek nɨŋlɨg gɨ, won nɨbak nep kɨyau mab ur ak mɨlep gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nɨg gek, bɨ ne okok nɨŋɨl, wal agɨl aglak, “Titi gɨl mab nɨbaul kasek mɨlep gɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Agelak, Jisas kɨrop agak, “Yad nɨbep nɨŋɨd agebin, cɨn agon God ak rek nep gɨnɨgab, agɨl, gos omal mer, gos nokɨm nep nɨŋnɨgabɨm ak, gɨnɨgab. Pen mab kɨyau mɨlep gak ak nep mer; dɨm yɨrɨk nɨbaul lɨlɨg gɨ ñɨg kɨb nab sɨŋ adaŋ amnoŋ, agenɨgabɨm ak, amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Pen nɨbi God nop nɨŋ dɨ kɨlɨs gɨl, nop ag nɨŋnɨgabɨm ak, agnɨgabɨm rek nep gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas God sobok gep karɨp ak amɨl, bin bɨ okok kɨrop mɨnɨm ag ñek nɨŋlɨg gɨ, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm dɨ bɨlokep okok abe apɨl nop aglak, “Nep bɨ an, nɨg gɨnɨmɨn, agɨp, nɨŋɨl nɨg gɨ ajeban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Agelak, Jisas pen agak, “Yad nɨbep mɨnɨm alap ag nɨŋen, yɨp ag ñem, yad pen bɨ an agek wög gɨpin ak, nɨbep ag ñɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon bin bɨ okok kɨrop ñɨg pak ñak ak, ne ke gos nɨŋɨl owak akaŋ God agek apɨl nɨg gak?” agak. Jisas nɨb agek, kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “Cɨn, ‘God ag yokek apɨl gak,’ agenɨgabɨn ak, cɨnop agnɨgab, ‘Nɨb ak, Jon agɨp ak tari gɨnɨg ma nɨŋ dɨpɨm?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pen, ‘Jon gos ne ke nɨŋɨl apɨl gak,’ agenɨgabɨn ak, bin bɨ okok cɨnop kabiam junɨgal. Gos kɨri ak, Jon ne bɨ God mɨnɨm agep bɨ alap owak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nɨb agɨl, Jisas nop aglak, “Cɨn ma nɨpɨn,” aglak. Agelak, Jisas kɨrop agak, “Nɨbi yɨp ma ag ñebɨm rek, yad pen bɨ an agek yad apɨl gebin ak, nɨbep ak rek nep ma ag ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas nɨb agɨl agak, “Pen nɨbi tari gos nɨŋebɨm? Bɨ alap ñɨ ne omal mɨdenɨgab. Ñɨ ne ned ak nop agnɨgab, ‘Ñɨ aul! Mɨñi wain wög ak am wög gan,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Agek, ñɨ ne agnɨgab, ‘Adi am ma gɨnɨm,’ agɨl, kɨsen pen gos adɨk nɨŋɨl, am wain wög ak genɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nap pen am ñɨ sain ak nop ak rek nep ag nɨŋek, agnɨgab, ‘Yau, gɨnɨm!’ agnɨgab ak pen am ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pen ñɨ nɨb omal, an bɨñen agnɨgab rek gɨnɨgab?” agak. Agek, Juda bɨ kɨb nɨb okok aglak, “Ñɨ ne ned ak nep bɨñen agnɨgab rek gɨnɨgab,” aglak. Agelak, Jisas agak, “Yad nɨbep nɨŋɨd agebin, nɨbi yokop mɨdem nɨŋlɨg gɨ, bɨ takɨs dɨpal bɨ okok abe, bɨ si dep bin okok abe, God bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab karɨp lɨm ak, nɨbep tausak lɨl amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon bɨ ñɨg pak ñeb ak, nɨbi tari tari gem God nop tep gɨnɨgab ak, nɨbep ag ñak ak pen mɨnɨm ne ak ma nɨŋ dɨpek. Bɨ takɨs dɨpal okok abe, bɨ si dep bin okok abe, kɨri Jon mɨnɨm agak ar nɨbak nɨŋɨl, dɨlak. Dɨlak nɨbak nɨbi ke bɨr nɨpek, pen nɨbi ke, Jon mɨnɨm ak dɨl, tap si tap tɨmel gɨpɨm ak tari gɨnɨg nɨg gɨpɨn agɨl, ma kɨrɨg gɨpek,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas agak, “Mɨñi mɨnɨm sɨd tɨkɨl alap sek agnɨg gebin aul nɨŋɨm. Bɨ wög dai nap nɨb alap nag wain wög ak gɨ yɨmɨl, wari gɨl, nag wain magɨl pak cɨb jakep mɨgan alap gɨnɨgab. Gɨ lɨl, nag wain magɨl alap si ñɨŋnɨgal ak nɨŋ mɨdojɨn, agɨl, karɨp par kɨb alap gɨ lɨl, bɨ ognap kɨrop agnɨgab, ‘Nɨbi nag wain wög yɨp ak kod mɨdɨl, kɨsen pɨlɨl pok gek, yɨp ognap, nɨbi ognap dɨnɨmɨb,’ agɨl, karɨp lɨm par yɨb okok amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nag wain magɨl ak pok gek nɨŋlɨg gɨ, bɨ ne okok kɨrop agnɨgab, ‘Wain wög yad okok amɨl, bɨ wög kod mɨdebal okok agɨl, nag wain magɨl yɨp ognap dowɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kɨri wain wög okok amjakel, bɨ wain wög gɨ mɨdenɨgal okok warɨkɨl, bɨ alap nop gab gab paknɨgal, bɨ alap nop pɨs nep ñag pak lel kɨmnɨgab, bɨ alap nop makɨd ju paknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nɨg gel, bɨ nag wain wög nap nɨb nɨbak, bɨ ne tapɨn bad alap pen ag yoknɨgab. Ag yokek, amenɨgal, bɨ nag wain wög genɨgal okok kɨrop ak rek nep gɨnɨgabal. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nɨg gel, bɨ wain wög nap nɨb nɨbak agnɨgab, ‘Ñɨ yad ak ag yoken me, mɨnɨm nop ak nɨŋnɨgal,’ agɨl, ag yokek amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ñɨ ne ak amjakek, bɨ wain wög gɨ mɨdenɨgal okok nop nɨŋɨl, kɨri ke agnɨgal, ‘Bɨ wain wög dai nap nɨb ñɨ ne ak apeb aul. Bɨñen kɨsen kɨmenɨgab, tap wög sɨŋ aul ñɨ ne dɨnɨgab. Nɨb ak, nop ñag pak lon kɨmek, kɨsen tap wög sɨŋ aul magɨlsek dɨnɨgabɨn,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nɨb agɨl, nop dam wög dai gol okok amɨl, pɨs nep ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nɨg genɨgal ak, kɨsen bɨ nag wain wög dai nap nɨb ak apɨl, kɨrop tari tari gɨnɨgab?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Agek, aglak, “Bɨ tɨmel gɨnɨgal nɨb okok kɨrop genɨgab, yur kɨb yɨb dɨl kɨmnɨgal; kɨsen pen bin bɨ ognap sek dɨl, kɨrop nag wain wög ak ag lek, wög nɨbak gɨnɨgal. Nag wain magɨl pok gɨnɨgab ñɨn ak, nop tɨk dam ñɨnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Agelak, Jisas agak, “God Mɨnɨm ñu kɨl tɨklak ak ma nɨpɨm rek lɨp. Kɨri ñu kɨl tɨkɨl aglak, ‘Bɨ karɨp gep okok, kɨri makɨd karɨp gɨnɨg gɨ, makɨd alap dɨl aglak, “Kab aul kab tɨmel gɨp gö kɨrɨg gɨn,” aglak. Pen Bɨ Kɨb ne gek nɨŋɨl kab nɨbak nep karɨp ne sɨŋak kab tep ke yɨb mɨdeb. Bɨ Kɨb ne nɨg gek, cɨn nɨŋɨl wal yɨb agobɨn,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kab tep ma dɨpɨm nɨbak, God nɨbep Juda kai kɨrɨg gɨl, bin bɨ ke okok nɨb, tap nop ñeb ñɨnɨgal bin bɨ nɨb okok kɨrop dɨl kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bin bɨ kab ar nɨbak ap yap paknɨgal okok, kɨrop tapɨn nep paknɨgab; pen kab nɨbak ju yapɨl, bin bɨ pak rɨbɨknɨgab okok, pɨs nep pag jɨsɨpɨk masɨpɨk gɨ amnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ Perisi okok abe, Jisas mɨnɨm sɨd tɨkɨl agak nɨbak, kɨrope nep agak ak nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nop mɨñ lɨn, agɨl, gos nɨŋlak ak pen bin bɨ okok, Jisas nop bɨ God mɨnɨm agep bɨ alap ag gos nɨŋlak ak me, cɨnop kal gɨnɨgal, agɨl, nop tap alap gɨnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas kauyaŋ mɨnɨm sɨd tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek: “Bɨ kiŋ alap ñɨ ne ak bin dɨnɨg gek, tap kɨb ñɨŋnɨg, tap magɨl dap mogɨm gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nɨg gɨl, bɨ ne ognap ag yokɨl agnɨgab, ‘Bin bɨ ag lɨnek okok am agem apel, tap kɨb ñɨŋɨn,’ agnɨgab. Nɨb agek, kɨri am bin bɨ nɨb okok kɨrop agnɨgal ak pen kɨri kɨrɨg gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nɨg gel, bɨ ne ognap pen kauyaŋ ag yokɨl agnɨgab, ‘Nɨbi am bin bɨ nɨb okok kɨrop agnɨmɨb, “Kiŋ ak, kaj kau kɨb ognap, kaj kau ñɨlɨk marɨp ognap pak dagɨl, tap okok magɨlsek gɨ jɨn gɨl, ‘Owɨm,’ agɨp,” agnɨmɨb,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nɨb agek, kɨri am agnɨgal ak pen mɨnɨm kɨrop ak dɨ yoknɨgal. Ognap tap wög kɨri okok amnɨgal; ognap mani wög kɨri okok genɨgal; ");
INSERT INTO kmh_m_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","pen ognap, kiŋ bɨ ne okok gɨ tɨmel gɨl, ñag pak lel kɨmnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nɨg gel, kiŋ nɨbak nɨŋek, cɨbur nop ak tɨmel gek, ami bɨ ne okok ag yokek, am bin bɨ bɨ ne ñag pak lɨnɨgal nɨb okok kɨrop magɨlsek ñag pak lɨ sakɨl, taun kɨb kɨri ak dagɨl ju yokel amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pen bɨ nop wög gɨ ñeb okok kɨrop agnɨgab, ‘Tap magɨl tap okok bɨr mogɨm gɨpɨn, pen bin bɨ ned sɨk agnek okok onɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nɨb ak, nɨbi kanɨb tam okok amɨl, bin bɨ nɨŋnɨmɨb okok, kɨrop magɨlsek, “Apem tap kɨb ñɨŋɨn,” agɨl, abramek poŋ dɨl dapem, tap kɨb ñɨŋɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nɨb agek, bɨ ne okok am kanɨb tam tam okok amɨl, bin bɨ tep okok, bin bɨ tɨmel okok kɨrop magɨlsek, ‘Apem tap kɨb ñɨŋɨn,’ agɨl, abramek poŋ dapɨl, bɨ bin dɨl tap kɨb ñɨŋnɨgal karɨp mɨgan nɨbak amɨl, tɨbɨk gi yɨb agɨl mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kiŋ nɨbak pen, bin bɨ opal okok nɨŋin, agɨl, karɨp mɨgan eyaŋ amɨl nɨŋnɨgab, bɨ alap, tap ñɨŋnɨg walɨj lɨpal ak lɨl mer, yokop nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nɨg gek, nop agnɨgab, ‘Bɨ aul! Tari gɨnɨg, bin dɨl tap ñɨŋnɨg walɨj lɨpal ak lɨl mer, yokop nep opan?’ agnɨgab. Agek, bɨ nɨbak pen mɨnɨm alap ma agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pen kiŋ ak bɨ ne okok kɨrop agnɨgab, ‘Bɨ aul ñɨn tob nop okok mɨñ lɨl, dam kɨslɨm gɨp nab eyaŋ dɨ yokem, bin bɨ nɨb okok eip meg magɨl su pag pe gɨlɨg gɨ, sɨl magɨl aglɨg gɨ mɨdelaŋ,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas kesɨm nɨbak ag dai juɨl, kɨrop agak, “God bin bɨ koŋai nep sɨk agnɨgab, pen kɨrop magɨlsek ma dɨnɨgab. Bin bɨ ognap nep dɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pen bɨ Perisi okok, Jisas nop mɨnɨm tari agon, pen agek nɨŋɨl, nop dam mɨñ lɨn, agɨl, mɨnɨm ag nɨŋ ag nɨŋ gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","bɨ kɨri ke ognap, Herod bɨ ne ognap ag yokel, Jisas mɨdek sɨŋak amɨl aglak, “Mɨnɨm ag ñeb bɨ. Nak bɨ mɨnɨm nɨŋɨd yɨb nep ageban. Bɨ ognap nɨŋɨl ma pɨrɨkpan. God mɨnɨm ageb rek nep nɨŋɨl, bin bɨ ag ñeban. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nɨb ak, nak gos tari nɨŋeban? Cɨn Isrel bin bɨ, Sisa bɨ kɨb taun kɨb Rom nɨb ak, nop takɨs ñeb akaŋ ma ñeb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Agelak, Jisas gos tɨmel kɨri ak nɨŋɨl agak, “Yɨp tari gɨnɨg coco gɨlɨg gɨ apɨl, nɨg gɨl ag nɨŋebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nɨbi takɨs ñɨbal kab magɨl alap ñem nɨŋin!” agak. Agek, nop kab magɨl alap dap ñelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisas kab magɨl nɨbak nɨŋɨl kɨrop agak, “Kab magɨl aul, bɨ kɨmɨg cög aul, bɨ an kɨmɨg cög mɨdeb? Yɨb ak, bɨ an yɨb mɨdeb?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Agek, aglak, “Ak bɨ kɨb Sisa,” aglak. Agelak, Jisas kɨrop agak, “Nɨb ak, Sisa tap ne mɨdonɨmɨŋ, Sisa nop ñɨnɨmɨb. God tap ne mɨdonɨmɨŋ, God nop ñɨnɨmɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nɨb agek, kɨri gos par nɨŋɨl, nop kɨrɨg gɨl amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ñɨn nɨbak nep, Sadyusi bɨ ognap Jisas mɨdek sɨŋak olak. Sadyusi bin bɨ nɨb okok apal, bin bɨ kɨmɨl kauyaŋ ma warɨknɨgal, apal. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kɨri Jisas mɨdek sɨŋak apɨl aglak, “Mɨnɨm ag ñeb bɨ. Mosɨs agak, ‘Bɨ alap bin dɨl, ñɨ pai tɨk dapɨl mer, yokop nep kɨmenɨgab ak, nɨmam ne ak, bin nɨbak dɨl, mam yad ñɨ pai ne okok, agɨl, tɨk donɨmɨŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nɨb ak, bɨ wagɨn sek aknɨb ar oŋɨd ak mɨdenɨgal. Nɨmam ned ak bin dɨl, ñɨ pai tɨk dapɨl mer womleb kɨmnɨgab. Nɨg gek, nɨmam yɨgwu nab nɨb ak pen bin nɨbak nep dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nɨmam yɨgwu nab nɨb ak pen bin nɨbak dɨl, ak rek nep ñɨ pai tɨk dapɨl mer, womleb kɨmnɨgab. Nɨb ak, nɨmam yɨgwu nokɨm nɨb ak bin nɨbak dɨl, ak rek nep ñɨ pai tɨk dapɨl mer, womleb kɨmnɨgab. Nɨbak nep gɨ dam dam, nɨmam aknɨb ar oŋɨd ak, magɨlsek ñɨ pai tɨk dapɨl mer, womleb nep kɨmnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pen bin ak, ak rek nep kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nɨmam okok kɨri magɨlsek bin nɨbak dɨlak. Nɨb ak, bin bɨ kɨmbal okok warɨknɨgal ñɨn ak, bin nɨbak bɨ an dɨnɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Agelak, Jisas kɨrop pen agak, “Nɨbi God Mɨnɨm ageb ak abe, God kɨlɨs mɨdeb ak abe, ma nɨpɨm ak me, tɨtɨmel agɨl apɨm, ‘Bin bɨ okok kɨmɨl ma warɨknɨgal,’ apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bin bɨ warɨknɨgal ñɨn ak, bin okok bɨ ma dɨnɨgal, bɨ okok bin ma dɨnɨgal. Ejol seb kab ar alaŋ mɨdebal rek ak mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nɨbi, ‘Bin bɨ kɨmɨl ma warɨknɨgal,’ apɨm ak, God Mɨnɨm ñu kɨl tɨklak ognap ma nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","God agak, ‘Yad Ebraham, Aisak, Jekop, God kɨri ak me mɨdebin,’ agak. Bɨ okok pɨs nep kɨmblap ak, God bɨ ned kɨmlak nɨb okok kɨrop agɨl, ‘Yad God kɨri mɨdebin,’ ma apkop. Bɨ kɨmel, tɨgel gɨlak nɨb okok komɨŋ mɨdebal ak me, kɨrop agak, ‘Yad God kɨri mɨdebin,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisas mɨnɨm nɨbak ag ñek, bin bɨ mɨdelak okok nɨŋɨl, kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas mɨnɨm nɨbak ag tep gek, Sadyusi bɨ okok mɨnɨm alap pen agnɨmel rek ma lak. Pen Perisi bɨ ognap, Jisas nɨg gak ak nɨŋɨl Jisas mɨdek sɨŋak olak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bɨ kɨri lo mɨnɨm nɨŋ tep gak bɨ alap, Jisas tari rek agnɨmɨŋ, agɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mɨnɨm ag ñeb bɨ. Lo mɨnɨm ak, mɨnɨm ar akal mɨnɨm kɨb yɨb mɨdeb?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Agek, Jisas agak, “Mɨdmagɨl nak ak magɨlsek, gos tɨmɨd nak ak magɨlsek dɨl, God Bɨ Kɨb nak ak nop mɨdmagɨl lɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mɨnɨm kɨb ned yɨb me ak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mɨnɨm kɨb yɨgwu nab nɨb ak pen nɨbgɨl mɨdeb: nak ke mɨdmagɨl lɨpan rek, bin bɨ ke nɨb okok kɨrop ak rek nep mɨdmagɨl lɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mɨnɨm omal agesin aul, Mosɨs lo mɨnɨm ñu kɨl tɨkak mɨnɨm ak magɨlsek abe, God mɨnɨm agep bɨ okok ñu kɨl tɨklak mɨnɨm ak magɨlsek abe, mɨnɨm wagɨn kɨb yɨb me mɨnɨm nɨb omal nep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Perisi kai ap mogɨm gɨl mɨdel nɨŋlɨg gɨ, Jisas kɨrop mɨnɨm alap ag nɨŋɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nɨbi Mesaia ak nop tari gos nɨpɨm? Nop bɨ an ñɨ ne agɨl nɨpɨm?” agak. Agek, aglak, “Depid ñɨ ne,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Agelak, Jisas agak, “God Kaun ak Depid nop gos ñek nɨŋlɨg gɨ, Depid ne Mesaia ak nop ‘Bɨ Kɨb yad’ agak. Depid agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bɨ Kɨb mɨnɨm agɨl, Bɨ Kɨb yad ak nop agɨp, “Nak ñɨnmagɨl yɨpɨd ken kɨd yad bɨsɨg mɨdenɨmɨn me, yad gen, kaual maual nak okok kɨrop tau lɨlɨg gɨ yoknɨgan,” agɨp,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mesaia ak, Depid nap acɨk ne apɨm ak pen Depid nop ‘Bɨ Kɨb yad’ agak. Nɨb ak, nɨbi tari gos nɨpɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas mɨnɨm ne ak ag tep gek, kɨri nop pen agnɨmel rek ma lek me, pɨrɨk gɨ mɨdelak nɨŋɨl kɨsen Jisas nop mɨnɨm ognap sek ma ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kɨsen ñɨn alap, Jisas bɨ ne okok abe, bin bɨ ognap abe, kɨrop mɨnɨm agɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, Mosɨs kau ne ak dɨl, God lo mɨnɨm Mosɨs bɨrarɨk nep ñu kɨl tɨkak rek ag ñɨbal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nɨb ak, bɨ nɨb okok kɨri God lo mɨnɨm tari agnɨmel ak nɨŋ dɨl kɨsen gɨnɨmɨb; pen mɨñ kɨri gɨnɨmel ar ak nɨŋɨl, kɨsen ma gɨnɨmɨb. God lo mɨnɨm ag ñɨbal ak pen kɨri ke mɨnɨm nɨbak kɨsen ma gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tap okok gɨnɨmɨb, tap okok ma gɨnɨmɨb, apal ak, mɨnɨm koŋai yɨb nep agebal. Kɨri apal nɨbak, wad mɨker kɨb yɨb ak rek, bin bɨ okok kɨrop gom ñɨbal ak pen kɨrop mapɨn nɨŋɨl, ognap tɨg asɨk ma yokpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bin bɨ okok cɨnop nep nɨŋlaŋ, agɨl, God Mɨnɨm ñu kɨl tɨklak mɨnɨm ognap dɨ aun beŋ ar alaŋ abe, ñɨnmagɨl okok abe lɨ rɨbɨkɨl ajpal. Cɨn God bɨ ne ke me okok, aglaŋ, agɨl, walɨj par kɨb mɨñ dai sek tep okok tol gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kɨri tap kɨb ñɨŋeb nab sɨŋak amɨl akaŋ Juda mogɨm gep karɨp okok amɨl, bɨ kɨb mab bog bɨsɨgpal ar sɨŋak nep bɨsɨgpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gos kɨri nɨpal ak, bin bɨ koŋai mɨdebal nab okok amon, ‘Mɨnɨm ag ñeb bɨ kɨb apeban e!’ agel, cɨnop tep gɨnɨgab, agɨl, nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pen nɨbi mam wagɨn nokɨm mɨdebɨm rek, nɨbep, ‘Ag ñeb bɨ kɨb yad,’ agɨl ma agnɨmel. Ag Ñeb Bɨ Kɨb nɨbi nokɨm alap nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lɨm dai wagɨn aul bɨ alap, ‘Bapi bɨ kɨb yad,’ agɨl ma agnɨmɨb. Nap nɨbi nokɨm alap nep mɨdeb karɨp lɨm seb kab ar alaŋ sɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɨbi ak rek nep, ‘Bɨ nabɨc bɨ kɨb yad,’ agɨl ma agnɨmel. Bɨ nabɨc bɨ kɨb nɨbi nokɨm alap nep, Mesaia ak nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nɨbi nab sɨŋak, bin bɨ an ne bin bɨ kɨb rek mɨdonɨmɨŋ, ne bin bɨ wög gɨ ñeb rek mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bin bɨ yɨb kɨri ke agel ar amenɨgab okok, yɨb kɨri ap yonɨgab; pen bin bɨ yɨb kɨri ke agel ar ma amenɨgab okok, kɨsen yɨb kɨri kɨb yɨb mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, kɨri mɨnɨm tom agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Nɨbi ke God bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab mɨgan ak ma amnɨgabɨm. Pen bin bɨ amnɨg gebal okok kɨrop kɨjoŋ tɨkebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, nɨbi mɨnɨm tom agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Nɨbi bin kaŋɨl karɨp sek si dɨpɨm. Nɨbak pen, bin bɨ cɨnop nɨŋnɨmel, agɨl, God nop mɨnɨm par kɨb esek okok nep apɨm. Gɨpɨm nɨbak me, yur kɨb yɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, nɨbi mɨnɨm esek agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Bin bɨ okok mɨnɨm cɨnop ak nɨŋɨl sain gɨlaŋ, agɨl, karɨp lɨm par okok pɨyo nɨŋ ajɨl, ognap nɨŋɨl ag ñem, kɨri ke Seten bɨ ne mɨdebɨm rek mer, kɨri Seten bin bɨ ne yɨpɨd gɨl yɨb lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Bin bɨ okok kɨrop God kanɨb ak yom tep gɨpɨn, apɨm ak pen nɨbi bɨ udɨn kwoi ak me, nɨbi ke ma nɨpɨm! Nɨg gɨpɨm nɨbak, mɨnɨm kɨb yɨb mɨdeb. Bin bɨ okok kɨrop mɨnɨm esek agɨl apɨm, ‘Cɨn, “God sobok gep karɨp mɨdeb rek, nɨŋɨd agobɨn,” agnɨgabɨn ak, kɨsen kɨrɨg gɨn, agenɨgabɨn ak, kɨrɨg gɨnɨgabɨn. Pen gol dɨl, tap God sobok gep karɨp mɨgan eyaŋ gɨlak okok yɨb nɨbak aglɨg gɨ, “Nɨŋɨd agobɨn,” agenɨgabɨn ak, agnɨgabɨn rek nep gɨnɨgabɨn me alek; ma kɨrɨg gɨnɨgabɨn,’ apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nɨbi bɨ udɨn kwoi, bɨ saköl! Nɨbi gos tari nɨpɨm: gol ak tap yɨb aka God sobok gep karɨp tɨd ak tap yɨb? Tap yɨb me, God sobok gep karɨp tɨd ne ak. Karɨp tɨd mɨdenɨgab ak, tap karɨp mɨgan mɨdeb abe tɨd mɨdenɨgab me. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mɨnɨm alap ak rek nep, bin bɨ okok kɨrop mɨnɨm tom agɨl apɨm, ‘Cɨn, “God kab bɨd ne mɨdeb rek nɨŋɨd agobɨn,” agenɨgabɨn ak, mɨnɨm nɨŋɨd agnɨgabɨn ak tap yokop; kɨsen gos alap nɨŋɨl, kɨrɨg gɨn, agenɨgabɨn ak, kɨrɨg gɨnɨgabɨn. Pen, tap God kab bɨd ar sɨŋak God nop pak sobok gɨ ñɨbal okok, yɨb nɨbak aglɨg gɨ, “Nɨŋɨd agobɨn,” agenɨgabɨn ak, kɨsen gos ke alap nɨŋɨl ke gɨjɨn rek ma lɨnɨgab; agnɨgabɨn rek nep gɨnɨgabɨn,’ apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nɨbi bɨ gos tɨmɨd ma lɨp okok, tap tari ak tap kɨb? Tap God nop pak sobok gɨ ñɨbal tap ak. aka kab bɨd ar sɨŋak sobok gɨ ñɨbal ak? Tap yɨb me, kab bɨd ak. Kab bɨd ar sɨŋak mɨdenɨgab ak me, tap nɨbak tap God nop ñeb rek lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pen ‘Kab bɨd mɨdeb rek, nɨŋɨd agobɨn,’ agenɨgal ak, bɨd ar nɨbak tap dap dagɨlölɨgɨpal sek agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pen ‘God sobok gep karɨp mɨdeb rek, nɨŋɨd agobɨn,’ agenɨgal ak, karɨp ak God karɨp ne nɨŋɨl God yɨb ne ak abe agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","‘Seb kab ar alaŋ mɨdeb rek, nɨŋɨd agobɨn,’ agenɨgal ak, God sea kiŋ bɨsɨg mɨdeb sɨŋak nɨŋɨl sea kiŋ nɨbak abe, God sea kiŋ nɨbak bɨsɨg mɨdeb ak abe mɨdeb rek, nɨŋɨd agobɨn agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, nɨbi mɨnɨm esek agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Mɨnɨm bin bɨ ognap kɨrop apɨm ar ak nɨbi ke ma gɨpɨm. Sɨnɨb sɨlek, tap abramek wög dai tanɨb ak nɨŋem, tap yɨb rek lek, wök pagem, am wajrem alaŋ amek, God nop nokɨm alap ñɨn, agɨl, per tap nɨbi God nop ñɨbɨm. Tap sɨkol sɨkol nɨbak rek per nɨg gɨpɨm, pen tari gɨnɨg mɨnɨm jɨj yɨb ak nɨg ma gɨpɨm? Bin bɨ okok kɨrop tɨmel gɨnɨmɨŋ ar ak ma gɨnɨmɨb; yɨpɨd gɨl gɨnɨmɨŋ ar ak gɨnɨmɨb. Kɨrop yɨmɨg nɨŋɨl, dɨ tep gɨnɨmɨb. Gɨnɨgabɨn, agenɨmɨb ak, nɨg gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bin bɨ okok, nɨbep kanɨb yomobɨn, apɨm ak pen nɨbi ke bɨ udɨn kwoi. Tap sɨkol sɨkol okok nɨŋem, tap yɨb rek lɨp, pen tap kɨb tap yɨb mɨseŋ mɨdeb okok ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, nɨbi mɨnɨm esek agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Pler kap nɨbi okok rek, söŋ ar okok ñɨg lɨ yok tep gɨpɨm ak pen nab eyaŋ tap si tap tɨmel kɨñɨr ak ap ran jakɨl mɨdeb. Cɨn tap koŋai dɨn, agɨl, mɨb goŋ cɨn ke gɨ tep gɨn, apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nɨbi Perisi bɨ okok gos tɨmɨd ma lɨp. Pler kap nɨbi nab eyaŋ ñɨg lɨ yok tep gɨpkep, söŋ ar okok ak rek nep mɨd tep gɨpkop. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, nɨbi mɨnɨm esek agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Cɨp kab mɨgan okok tɨgel gɨl, kɨjoŋ pɨlɨŋ gɨl, cɨku tɨd lel melɨk tep gek, bin bɨ okok nɨŋel, tep gɨp, pen mɨgan nab eyaŋ cɨp tɨŋɨl ki tɨmel aplɨg gɨ mɨdeb; nɨbi aknɨb rek nep mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nɨbi aknɨb rek nep, söŋ ar mɨb goŋ nɨpɨn ak, nɨbi bɨ tep rek lɨp ak pen nab nɨbep eyaŋ, mɨnɨm esek okok abe, tap si tap tɨmel okok abe, gac ak ap ran jakɨl mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nɨbi God lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe, nɨbi mɨnɨm esek agɨl gɨ tɨmel gep bɨ. God nɨbep gɨ tɨmel gɨnɨgab. Bɨ God mɨnɨm agep bɨrarɨk nep ñag pak lel tɨgel gɨlak kau mɨgan tɨb ar ak tɨb kadɨg gɨ tep gɨ lɨl apɨm, ");
INSERT INTO kmh_m_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Apɨs based sɨkop gɨlak rek ak, cɨn God mɨnɨm agep bɨ okok kɨrop ma ñag pakpnop,’ apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pen apɨm nɨbak, bɨ God mɨnɨm agep okok kɨrop ñag pak lölɨgɨpal wagɨn ak me, cɨn mɨdobɨn, agɨl, apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nɨb ak, apɨs based sɨkop gɨ tɨmel gɨlak ak rek, nɨbi ak rek nep gɨnɨgabɨn, agenɨgabɨm ak, nɨbak rek nep gɨnɨmɨb! ");
INSERT INTO kmh_m_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nɨbi soiŋ ñɨ pai sɨŋ aul. Kɨsen God bin bɨ mɨnɨm kɨb agɨl, mab ke yɨneb eyaŋ yoknɨgab ñɨn ak, nɨbi titi gɨl pɨrɨk gɨ ke okok amnɨgabɨm? Mer yɨb. Kanɨb nɨbi ameb alap ma mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Nɨb ak, yad nɨbep agebin, yad bɨ God mɨnɨm agep ognap, bɨ gos kɨd yɨk nɨŋeb ognap, bɨ mɨnɨm ag ñeb ognap ag yoken, nɨbep apenɨgal, ognap ñag pak lɨnɨgabɨm, ognap mab bak alaŋ ñag pak lɨnɨgabɨm, ognap Juda mogɨm gep karɨp ñɨlɨk mɨgan nɨbi ak paknɨgabɨm, ognap pɨrɨk gɨ amel nɨŋlɨg gɨ, karɨp lɨm tɨgoŋ tɨgoŋ yɨk gɨ dam yoknɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɨb ak me, God bin bɨ komɨŋ tep ne okok, bɨrarɨk nep ñagel owɨp aul rek, mɨnɨm mɨker ak dɨnɨgabɨm. Adam ñɨ ne, gɨ tep nep golɨgɨp bɨ ak Ebol, nop ned wagɨn gɨl ñag pak lɨl, ñag dapɨl, ñag dapɨl, kɨsen Berekaia ñɨ ne Sekaraia nop, God nop sobok gep karɨp sɨŋ adaŋ, kab dɨ gɨlak bɨd sɨŋ adaŋ mɨdek nɨŋlɨg gɨ, nop nab nɨb sɨŋak ñag pak lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yad nɨbep nɨŋɨd yɨb agebin: tap gɨpɨm nɨbak, mɨnɨm nɨbak nɨbep mɨñi mɨdebɨm sɨŋ aul adɨk gɨ onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem bin bɨ, bin bɨ mapɨn gep rek yad sɨŋ aul. Bɨ God mɨnɨm agep God kɨrop ag yokak bɨ okok, karɨp lɨm nɨbep ak apel, kab juɨl per nep ñag pak lɨpɨm. Yad nɨbep kɨlokɨl nonɨm ñɨlɨk okok gɨpal rek, dam auan mok yad ak dɨ lin agɨl dɨ lɨpin ak pen yɨp nɨŋɨl kɨrɨg gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","God ne God sobok gep karɨp nɨbi ak kɨrɨg amnak; söŋ nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mɨñi yɨp ma nɨŋnɨgabɨm; kɨsen, ‘God bɨ cɨnop nen ag yokak bɨ aul tep yɨb apeb,’ agenɨmɨb, ñɨn nɨbak nep yɨp kauyaŋ nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas God sobok gep karɨp ak kɨrɨg gɨl, söŋ amek nɨŋlɨg gɨ, bɨ ne okok nop aglak, “God sobok gep karɨp tep sɨŋ aul nɨŋan!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Agelak, kɨrop agak, “Nɨbi tap nɨb okok magɨlsek nɨŋɨl agebɨm ak pen yad nɨbep nɨŋɨd yɨb agebin, kɨsen karɨp aul tɨg wal gɨnɨgal ak, makɨd alap makɨd alap ar ak rek ma mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas am Olip Dɨm alaŋ bɨsɨg mɨdek nɨŋlɨg gɨ, bɨ ne okok kɨri ke nep apɨl, Jisas nop kapkap ag nɨŋɨl aglak, “God sobok gep karɨp dɨ wal gɨnɨgal apan ak, mɨnek akal rek nɨg gɨnɨgabal? Cɨn tap tari ak gek nɨŋɨn, nak maŋ onɨgan nɨŋɨl karɨp lɨm dai wagɨn aul kɨr gɨnɨgab, agɨl nɨŋnɨgabɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Agelak, Jisas pen agak, “Nɨŋ tep yɨb gɨnɨmɨb. Bin bɨ ognap nɨbep esek agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bɨ koŋai nep apɨl, bin bɨ okok kɨrop esek agɨl, yɨb yad ak dɨl agnɨgal, ‘Yad nep Krais ak,’ agnɨgal. Bin bɨ koŋai nep mɨnɨm tom kɨri ak nɨŋ dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ulep sɨŋak pen pen gel, gu agek nɨŋnɨgabɨm; pen par yɨb okok pen pen gɨnɨgal ak, mɨnɨm ak nep apek nɨŋnɨgabɨm. Nɨg gek nɨŋɨl, ñɨn kɨsen ak onɨg geb agɨl ma pɨrɨknɨmɨb. Ak yokop pen pen ñagnɨgal. Ñɨn kɨsen ak kɨsen onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bin bɨ mɨgan ognap warɨkɨl, bin bɨ mɨgan ognap eip pen pen gɨnɨgal. Kiŋ mɨgan ognap warɨkɨl, kiŋ mɨgan ognap eip pen pen gɨnɨgal. Karɨp lɨm okok magɨlsek monmon dɨl, yuan kɨb yɨb apɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nɨg genɨgab, nɨbep bin ñɨ pai ñɨŋeb rek ak gek, ulep mɨdeb agɨl nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nɨbi bin bɨ yad mɨdenɨgabɨm rek, bin bɨ karɨp lɨm okok magɨlsek nɨbep yɨrɨk nɨŋɨl, dam mɨñ lɨl, gɨ tɨmel gɨl, pɨs nep ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ñɨn nɨbak, bin bɨ God nop nɨŋ dɨpal okok koŋai nep nɨŋ dep won kɨri ak kɨrɨg gɨl, nɨmɨd nɨmam kɨri ke okok nɨŋel mɨlɨk yapek, kɨrop dɨ bɨ kaual maual ñɨnmagɨl ar ak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pen bin bɨ koŋai nep apɨl, “Cɨn God mɨnɨm agep bɨ,” agɨl, mɨnɨm esek agel, bin bɨ koŋai nep mɨnɨm esek kɨri ak nɨŋ dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bin bɨ okok mɨñ tɨmel ar ak gel gel, magɨlsek rek gos ar nɨbak nɨŋɨl, mɨdmagɨl lep ar ak yɨpɨn gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pen bin bɨ an an God mɨnɨm tep ak nɨŋ dɨ wös gɨl, ageb rek gɨl, bin bɨ ke nɨb okok mɨdmagɨl lɨl gɨlɨg gɨ nep mɨdenɨgal okok, God bin bɨ nɨb okok kɨrop magɨlsek dɨ komɨŋ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pen God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak, karɨp lɨm ke tɨgoŋ tɨgoŋ bin bɨ ke ke okok nɨb okok nɨb magɨlsek yɨb agel agel am saknɨg geb ak me, ñɨn kɨsen nɨbak onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pen bɨ God mɨnɨm agep Daniel bɨrarɨk nep agak rek ak gɨnɨgab. Ne agak, ‘Nɨbi nɨŋnɨgabɨm, God sobok gep karɨp ñɨlɨk mɨgan tɨd ak, tap asɨk mosɨk tɨmel yɨb gep ak apɨl warɨk mɨdenɨgab,’ agak. (Nɨbi bin bɨ mɨnɨm aul mɨñi nep udɨn lɨ nɨŋebɨm okok, mɨnɨm nɨbaul wagɨn ak nɨŋ tep gɨnɨmɨb!) ");
INSERT INTO kmh_m_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nɨbi bin bɨ karɨp lɨm Judia mɨdenɨmɨb okok, tap tɨmel nɨbak nɨŋɨl, kasek pɨrɨk gɨ dɨm yɨrɨk okok amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bin bɨ karɨp ar alaŋ mɨdenɨmɨb okok, tap cɨn ognap dɨn agɨl, adɨk gɨ karɨp mɨgan ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bin bɨ wög dai okok ajenɨmɨb okok, walɨj par alap dɨn agɨl, adɨk gɨ karɨp ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pen ñɨn nɨbak bin ñɨ kogi sek mɨdenɨmɨb okok abe, bin ñɨ paiŋaŋ ci ñenɨmɨb okok abe, koslam yɨb amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Pen God nop sobok gɨl agnɨmɨb, karɨp yɨgen gɨp ñɨn ak ma pɨrɨk gɨ amnɨn, agnɨmɨb; God nop sobok gep ñɨn nɨbi ak ma gɨnɨmɨŋ, agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tari gɨnɨg, God bɨrarɨk ped okok karɨp lɨm gɨ lak ñɨn ak tɨkɨl, mɨd damɨl mɨñi mɨdobɨn ñɨn aul, tap tɨmel nɨbak rek ma gak; kɨsen aknɨb rek ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yokop ak, tap tɨmel nɨbak per gek, bin bɨ magɨlsek kɨm sakplap. Pen Bɨ Kɨb ak bin bɨ ne dɨnɨgab okok kɨrop gos nɨŋɨl, mer agek me, tap tɨmel nɨbak yokop won alap gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ñɨn nɨbak bin bɨ ognap nɨbep agnɨgal, ‘Nɨŋɨm! Krais mɨdeb aul! Krais mɨdeb adaŋ!’ agnɨgal ak pen nɨŋɨd agebal agɨl, ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bin bɨ ognap, God bin bɨ ne ag lak okok, pɨs cɨnop kɨd olaŋ, agɨl, esek agɨl agnɨgal, ‘Yad nep Krais; yad nep bɨ God mɨnɨm agep bɨ alap,’ agɨl, tap ma gep rek ognap gɨnɨgal. Pen God bin bɨ ne ag lak okok ma dɨnɨgal, mer. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nɨb ak, nɨŋ tep gɨnɨmɨb. Tap tari tari kɨsen gɨnɨgab ak, yad nɨbep bɨr agen nɨpɨm ak me, nɨŋ tep gɨlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nɨb ak, bin bɨ ognap apɨl nɨbep agnɨgal, ‘Krais apɨl mɨdeb mɨñ mab kab nep mɨdeb nab okok,’ agenɨgal ak, nɨb okok ma amnɨmɨb. Pen bin bɨ ognap apɨl nɨbep agnɨgal, ‘Krais apɨl we gɨl mɨdeb sɨŋ aul,’ agenɨgal ak, nɨŋɨd agebal agɨl ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yad Bɨ Ñɨ ne onɨgain ñɨn ak, añɨm añɨm dɨl, kasɨn magɨl bol ak dai eim nɨb dai oŋɨd amɨb rek ak gek nɨŋlɨg gɨ, onɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kɨmɨn kobri alap kɨmɨl mɨdenɨgab ak, yakɨr apɨl mogɨm gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pen mɨker kɨb nɨbak gɨ dam dai juek nɨŋlɨg gɨ, pɨb ak melɨk ma gɨnɨgab; takɨn ak melɨk ma gɨnɨgab; gap okok seb kab alaŋ nɨb ju yonɨgab; tap seb kab ar alaŋ okok, eim nɨb oŋɨd nɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ñɨn nɨbak, Bɨ Ñɨ ne onɨg gek nɨŋlɨg gɨ, seb kab ar alaŋ ke lek, bin bɨ karɨp lɨm okok ke ke mɨdebal rek nɨŋɨl, sɨl agnɨgal. Bɨ Ñɨ ne Nap kɨlɨs ak dɨl, melɨk tep aknɨb ke sek seb bad ar sɨŋak apek nɨŋlɨg gɨ, nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Akɨl magɨl kɨb agek nɨŋlɨg gɨ, ejol ne okok ag yokek, bin bɨ ne, dɨnɨgain, agɨl ag lak okok dɨnɨg, karɨp lɨm wagɨn aul mɨdeb mɨdeb rek tɨgoŋ tɨgoŋ magɨlsek amɨl, dɨl nop donɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nɨbi nɨpɨm, mab tauan kas sɨlɨp lɨl, maŋ kɨlɨs gɨnɨg geb nɨŋlɨg gɨ, pɨb lɨnɨg geb agɨl nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nɨb ak rek, kɨsen tap agebin okok gek nɨŋlɨg gɨ, “Bɨ Ñɨ ne adɨk gɨ onɨgab ñɨn ak mɨñi ulep yɨb mɨdeb; won sɨkol eñap mɨdɨl, apjaknɨgab,” agɨl, nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yad nɨbep nɨŋɨd agebin, bin bɨ mɨñi mɨdebal okok ma kɨmnɨgal, komɨŋ mɨdel nɨŋlɨg gɨ, tap nɨb okok magɨlsek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Seb kab ar alaŋ abe, lɨm dai wagɨn aul abe kɨr gɨnɨgab, pen mɨnɨm magɨl yad ma kɨr gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yad won akal rek, ñɨn akal rek onɨgain ak, bin bɨ ma nɨpal; ejol okok ma nɨpal; yad ke God Ñɨ ak pen yad abe ma nɨpin; Bapi ne ke nep nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Yad Bɨ Ñɨ ne adɨk gɨ onɨgain ñɨn ak, Noa mɨdek ñɨn ak gɨ mɨdelɨgɨpal rek nep gɨ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bɨrarɨk nep Noa mɨdek ñɨn nɨbak, ñɨg ak bin bɨ okok kɨrop dɨ yɨpɨl ma yokak won ak, kɨri tap ñɨblɨg gɨ, ñɨg ñɨblɨg gɨ, bin bɨ dɨlɨg gɨ, gɨ mɨdel nɨŋlɨg gɨ, Noa ñɨg magöb kɨb mɨgan ak amek, ñɨg apɨl kɨrop magɨlsek dɨ yɨpɨl yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pen kɨri tap alap cɨnop gɨnɨgab agɨl ma nɨŋlak; ñɨg ak apɨl kɨrop magɨlsek dɨ yɨpɨl yokek nɨŋlɨg gɨ nep nɨŋlak. Kɨsen yad Bɨ Ñɨ ne onɨgain mɨnek, nɨg aknɨb rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ñɨn nɨbak, bɨ omal wög dai okok wög gɨ mɨdenɨgair ak, bɨ alap dɨl, alap kɨrɨg gɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pen bin omal plaua gɨnɨg, wid magɨl pak jɨsɨpɨk masɨpɨk lɨgolɨg genɨgair ak, alap dɨl, alap kɨrɨg gɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Yad Bɨ Kɨb onɨgain ñɨn ak ma nɨpɨm ak me, nɨŋ tep gɨlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bɨ karɨp nap nɨb ak, bɨ tap si dep ak won akal onɨgab ak nɨpkop, nɨŋ tep gɨpkop; karɨp ne pak ju lɨl mɨgan adaŋ amɨl tap ne okok si ma dɨpkop. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɨb ak rek, nɨbi gɨ jɨn gɨl mɨdenɨmɨb. Mer ak, Bɨ Ñɨ ne ma apeb agɨl, saköl padek gɨ mɨdenɨgabɨm ñɨn ak nep onɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bɨ kɨb alap kanɨb amnɨg gɨl, bɨ an wög gɨ rep gɨnɨgab ak nop ag lɨl agnɨgab, ‘Bɨ wög yɨp gɨ ñebal okok kɨrop kod mɨdlɨg gɨ, tap magɨl kɨrop nonɨm lɨ tep gɨ ñɨlɨg gɨ mɨdenɨmɨn,’ agɨl, amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kɨsen adɨk gɨ apɨl nɨŋnɨgab, agak rek nep gɨnɨgab. Nɨg nɨŋɨl nop dɨ tep yɨb gek nɨŋlɨg gɨ, bɨ wög gɨ ñeb ne mɨñ mɨñ gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yad nɨbep nɨŋɨd agebin, nop ag lek, tap ne okok magɨlsek kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Pen bɨ ne ag lɨnɨgab nɨbak mɨd damɨl, bɨ kɨb mɨñi ma onɨgab, agɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bin bɨ wög gɨ ñeb ognap kɨrop tapɨn magɨl pakɨl, amɨl bɨ ñɨg ñɨbɨl saköl ñapal okok eip nab sakɨl, tap ñɨbɨl, ñɨg ñɨbɨl gɨ mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bɨ wög gep nɨbak, bɨ kɨb kasek ma onɨgab, agɨl, saköl padek agɨl mɨdenɨgab ñɨn ak nep, bɨ kɨb onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Apɨl, nop gɨ tɨmel yɨb gɨl, bin bɨ esek agɨl, “Cɨn Bɨ Kɨb bin bɨ ne mɨdobɨn,” agɨl esek apal okok eip ag yoknɨgab. Ag yokek, kɨri am meg magɨl su rɨbɨkɨl, sɨl aglɨg gɨ nep mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“God bin bɨ dɨl kod mɨdenɨgab ñɨn nɨbak, kesɨm agnɨg gebin ar aul rek gɨnɨgab. Bɨ alap bin dɨnɨg geb. Bin praj aknɨb wajrem alaŋ tap kɨb ñɨŋnɨg amnɨgal. Bin praj nɨb okok, bɨ nɨbak nop am kanɨb nab sɨŋak nɨŋɨl poŋɨd dɨ dad karɨp onɨgabɨn, agɨl, lam ke ke dɨl amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pen bin praj nɨb okok, aknɨb mamɨd alaŋ gos nɨŋ tep gɨnɨgal; aknɨb mamɨd alaŋ gos nɨŋ tep ma gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bin praj gos nɨŋ tep ma gɨnɨgal okok, lam dɨl, lam dagɨlep wel ognap sek ma dad amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pen bin praj gos nɨŋ tep gɨnɨgal nɨb okok, lam dɨl, lam dagɨlep wel ognap pag barol mɨgan ak lɨl, sek sek dad amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pen bin praj nɨb okok kɨri magɨlsek amjakɨl, kod mɨdel mɨdel, bɨ bin dɨnɨg gɨnɨgab ak kasek ma apenɨgab me, wɨsɨn apek wɨsɨn kɨn amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pen kɨslɨm nab kɨb eyaŋ, bin bɨ ognap sɨk agɨl agnɨgal, ‘Bɨ bin dɨnɨg geb ak apeb. Nop am kanɨb nab sɨŋak nɨŋɨl, poŋɨd dowɨm,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nɨb agenɨgal, bin ñon aknɨb wajrem alaŋ nɨbak magɨlsek warɨkɨl, lam wik kɨri okok gɨ tep gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nɨg gɨl, bin gos nɨŋ tep ma gɨnɨgal ñon ak, bin gos nɨŋ tep gɨnɨgal ñon ak kɨrop agnɨgal, ‘Lam cɨn okok soŋ gɨnɨg geb ak, wel ognap nɨbi kam cɨnop ognap ñɨm,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nɨb agenɨgal ak pen bin gos nɨŋ tep gɨnɨgal ñon ak agnɨgal, ‘Mer! Cɨn wel cɨn nɨbepe ognap ñɨnɨgabɨn ak, wel cɨn ulep gɨnɨgab. Nɨbi wel tauep karɨp alap okok amɨl, nɨbi ke tauɨm,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nɨb agenɨgal, wel tauep karɨp ak amnɨgal magɨl ak, bɨ bin dɨnɨg gɨnɨgab ak apjaknɨgab. Bin gos nɨŋ tep gɨnɨgal ñon ak, bɨ nɨbak eip karɨp ñɨlɨk mɨgan amel nɨŋlɨg gɨ, ne kɨjoŋ gɨ ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kɨsen pen bin praj gos nɨŋ tep ma nɨŋnɨgal ñon ak apjakɨl agnɨgal, ‘Bɨ kɨb! Bɨ kɨb! Cɨnop kɨjoŋ ak yɨkan,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Agenɨgal, agnɨgab, ‘Yad nɨbep nɨŋɨd yɨb agebin, yad nɨbep ma nɨpin,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas mɨnɨm nɨbak agɨl bin bɨ okok kɨrop agak, “Nɨb ak, nɨbi Bɨ Kɨb ak ñɨn akal aka won akal onɨgab ak ma nɨpɨm rek, nɨŋ tep gɨl mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Pen kesɨm dɨnɨg gebin ar aul rek gɨnɨgab. Bɨ kɨb alap karɨp lɨm par kɨb okok amnɨg, bɨ wög gɨ ñeb ne okok kɨrop sɨk agek apel, tap ne okok kod mɨdelaŋ, agɨl, kɨrop ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","16","Bɨ ne nɨb okok, wög gɨnɨgal gɨnɨgal rek nɨŋɨl, mani nonɨm lɨl, bɨ alap nop paip tausan ñɨnɨgab, alap nop tu tausan ñɨnɨgab, alap nop wan tausan ñɨnɨgab. Ñɨl, ne am okok mɨdek nɨŋlɨg gɨ, bɨ paip tausan dɨnɨgab ak, mani nɨbak dɨl, sɨkim gɨ dad amɨl apɨl gɨl, mani sinɨŋ paip tausan dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bɨ tu tausan dɨnɨgab ak, ak rek nep, mani nɨbak dɨl, sɨkim gɨ dad amɨl apɨl gɨl, mani sinɨŋ tu tausan dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pen bɨ mani wan tausan dɨnɨgab ak, damɨl, kau dɨl, lɨm ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kɨsen mɨd damɨl, bɨ wög gɨ ñeb nɨb okok bɨ kɨb kɨri ak adɨk gɨ apɨl, mani ñɨbin nɨbak tari tari gɨpal, agɨl, kɨrop ag nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ag nɨŋek, bɨ paip tausan dɨnɨgab ak, mani ne ak dap ñɨl agnɨgab, ‘Bɨ kɨb, nɨŋan! Yɨp mani paip tausan nep ñɨnak pen yad mani nɨbak dɨl, sɨkim gɨ adɨk madɨk gɨ damɨl, paip tausan mani sinɨŋ dɨpin me aul,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Agek, bɨ kɨb ak nop pen agnɨgab, ‘Tep gɨp. Nak wög gɨ ñeb bɨ tep. Nak yɨp wög gɨ tep gɨ ñɨban ak me, nɨg gɨpan. Nak tap sɨkol ak nɨg gɨ tep gɨpan ak, nep agen, tap kɨb okok kod mɨdenɨgan. Nak apɨl, karɨp yad ak mɨñ mɨñ yɨb gɨlɨg gɨ mɨdenɨmɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Bɨ mani tu tausan dɨnɨgab ak, ak rek nep mani ne ak dap ñɨl agnɨgab, ‘Bɨ kɨb. Yɨp tu tausan nep ñɨnak pen yad mani nɨbak dɨl, sɨkim gɨ adɨk madɨk gɨ damɨl, tu tausan mani sinɨŋ dɨpin me aul,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Agek, bɨ kɨb ak agnɨgab, ‘Tep gɨp. Nak wög gɨ ñeb bɨ tep. Nak yɨp wög gɨ tep gɨ ñɨban ak me, nɨg gɨpan. Nak tap sɨkol ak nɨg gɨ tep gɨpan ak, nep agen, tap kɨb okok kod mɨdenɨgan. Nak apɨl, karɨp yad ak mɨñ mɨñ yɨb gɨlɨg gɨ mɨdenɨmɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pen bɨ mani wan tausan dɨnɨgab ak, mani ne ak dap ñɨl agnɨgab, ‘Bɨ kɨb. Yad nep nɨpin; nak bɨ kal yɨb. Bin bɨ nak ognap wög wari kɨri gɨpal okok, nak yokop yɨg dap ñɨban. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nak nɨg gɨpan rek, yad pɨrɨkɨl, mani ñɨnak ak damɨl, kau dɨl, lɨm ñɨnek mɨdolɨgɨp ak, mɨñi mani nak dap ñebin me aul,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Agek, bɨ kɨb ak agnɨgab, ‘Nak bɨ tɨmel wög ma gep bɨ alap. Bin bɨ yɨp wög wari gɨpal okok, tap yokop yɨg dap ñɨbin, apan ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nɨb ak, nak mani yɨp aul dam beg pasbuk lɨpnap, mɨñi yad apɨl mani sinɨŋ ognap sek yokop dɨpnep,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nɨb agɨl, bɨ ne ognap kɨrop agnɨgab, ‘Nɨg gɨp ak, mani wan tausan nɨbak ju dɨl, bɨ ten tausan mɨdeb ak nop ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bin bɨ gep okok, kɨrop ognap sek ñel, dɨl mɨd tep gɨnɨgal; pen bin bɨ gep mer okok, tap sɨkol kɨri mɨdeb ak pɨlɨ gɨ del, yokop mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nɨb ak, bɨ wög ma gɨp nɨbak nop dam kɨslɨm kɨb owɨp söŋ ar sɨŋ eyaŋ yokem, bin bɨ meg magɨl su rɨbɨkɨl, sɨl aglɨg gɨ mɨdebal okok eip mɨdeŋ,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Bɨ Ñɨ ne Kiŋ kɨb mɨdɨl, melɨk tep aknɨb ke sek onɨgab ñɨn ak, ejol okok magɨlsek eip apɨl, sea Kiŋ ne bɨsɨg mɨdep ar ak bɨsɨg gek, ");
INSERT INTO kmh_m_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","bin bɨ lɨm dai ke tɨgoŋ tɨgoŋ mɨdebal rek magɨlsek apɨl, udɨn yɨrɨk nop sɨŋak mogɨm gel nɨŋlɨg gɨ, kɨrop nonɨm lɨ pɨs ak ke lɨl, pɨs ak ke lɨl gɨnɨgab. Bɨ kaj sipsip kaj meme mɨkep bɨ okok, kaj sipsip okok mɨgan alap ke yokɨl, kaj meme okok mɨgan alap ke yokɨl gɨpal rek ak gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bin bɨ kaj sipsip rek mɨdebal okok nɨŋɨl, ñɨnmagɨl yɨpɨd pɨs kɨd lɨnɨgab; bin bɨ kaj meme rek mɨdebal okok nɨŋɨl, ñɨnmagɨl aŋɨdken pɨs kɨd lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ne Kiŋ kɨb ak me, bin bɨ ñɨnmagɨl yɨpɨd pɨs kɨd ne mɨdenɨgal okok, kɨrop agnɨgab, ‘Bapi nɨbep dɨ tep gɨp ak me, mɨñ mɨñ gɨnɨmɨb. Ne karɨp lɨm bɨrarɨk ped okok gɨ lak ñɨn ak, kau nɨbep ak gɨ lak. Apɨl, kau tep nɨbak dɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pen tari: yɨp yuan gek, tap magɨl ñɨbɨm. Yɨp ñɨg nen gek, ñɨg ñɨbɨm. Yad karɨp lɨm par okok nɨb apen, yɨp ag dɨl dam karɨp nɨbi ak lɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yad walɨj ma mɨdek, yɨp walɨj ak ñɨbɨm. Yad tap gek, yɨp gɨ tep gɨpɨm. Mɨñ mɨdenek, yɨp am nɨpɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nɨb agenɨgab, bin bɨ tep okok nop pen agnɨgal, ‘Bɨ Kɨb. Won akal nep yuan gek tap magɨl ñɨbɨn? Won akal nep ñɨg nen gek, nep ñɨg ñɨbɨn? ");
INSERT INTO kmh_m_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Won akal nak bɨ par okok nɨb rek apek, nep ag dɨl dam karɨp cɨn ak lɨpɨn? Won akal nak walɨj ma mɨdek, nep walɨj ñɨbɨn? ");
INSERT INTO kmh_m_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Won akal nep tap gak aka nak mɨñ mɨdenak, nep am nɨpɨn?’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Agenɨgal, Kiŋ ak agnɨgab, ‘Mam yad yokop alap gɨ tep gɨpɨm ak me, yɨp gɨ tep gɨpɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kɨrop nɨb agɨl, bin bɨ ñɨnmagɨl aŋɨdken pɨs kɨd ne mɨdenɨgal okok, kɨrop agnɨgab, ‘God nɨbep nɨŋɨl gos tɨmel nɨŋeb. Ne Seten nop abe, Seten ejol ne okok abe, kɨrop yur gek nɨŋlɨg gɨ mɨdelaŋ, agɨl, kau mab ke yɨneb alap gɨ lak. Nɨbi bin bɨ tɨmel, yur kɨb dɨnɨgabɨm okok, yɨp kɨrɨg gɨl, mab ke yɨneb kau nɨbak amnɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tari gɨnɨg: yɨp yuan gek, tap magɨl ma ñɨbek. Yɨp ñɨg nen gek, ñɨg ma ñɨbek. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yad par okok nɨb apen, yɨp ag dɨl dam karɨp nɨbi ak ma lɨpek. Yad walɨj ma mɨdek, yɨp walɨj ma ñɨbek. Yad tap gak ñɨn ak aka mɨñ mɨdenek ñɨn ak, yɨp ap nɨŋɨl gɨ tep ma gɨpek,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Agenɨgab, kɨri nop pen agnɨgal, ‘Bɨ Kɨb. Ñɨn akal nak yuan mɨdenak, tap magɨl ma ñɨnok? Ñɨn akal nep ñɨg nen gek, ñɨg ma ñɨnok? Ñɨn akal nak par okok nɨb apek, nep ma ag dɨnok? Ñɨn akal nak walɨj ma mɨdek, nep ma ñɨnok? Ñɨn akal nep tap gak aka mɨñ mɨdenak, nep am nɨŋɨl gɨ tep ma gɨnok?’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nɨb agenɨgal, Kiŋ ak kɨrop pen agnɨgab, ‘Yad nɨbep nɨŋɨd agebin, nɨbi mam yad yokop alap gɨ tep ma gɨpɨm ak me, yɨp ak rek nep gɨ tep ma gɨpɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nɨb agɨl, kɨrop ag yokek amɨl, per nep yur gek nɨŋlɨg gɨ mɨdenɨgabal kau ak amnɨgabal; pen bin bɨ tep ne okok agek, kɨri amɨl, per nep per nep komɨŋ mɨdep karɨp lɨm sɨŋak amnɨgabal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas mɨnɨm nɨbak agɨl, bɨ ne aknɨb umɨgan alaŋ okok kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nɨbi nɨpɨm, ñɨn omal mɨdɨl, Pasopa ñɨn kɨb ak mɨñi, agɨl, ap mogɨm gɨl yokop mɨdenɨgal. Pen kɨri nɨg gɨl ap mogɨm gɨl, yɨp Bɨ Ñɨ ne ak, dɨ gapman bɨ kɨb okok kɨrop ñɨl agnɨgal, ‘Nop mab bak alaŋ ñag pak lɨm,’ agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pen God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm dɨ bɨlokep okok abe, apɨl bɨ God nop tap sobok gep bɨ kɨb yɨb Kaiapas karɨp kɨb ne ak ap mogɨm gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jisas nop titi gɨl, kapkap dɨ cɨcɨ lɨl, ñag pak lɨnɨgabɨn, agɨl, mɨnɨm ag lɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pen kɨri aglak, “Pasopa tap ñɨŋeb yokop mɨdep ñɨn aul, cɨn nɨg gon, bin bɨ koŋai nep mɨdebal sɨŋ aul pen pen gɨnɨmel rek lɨp. Nɨb ak, mɨñi kɨrɨg gɨl, ñɨn alap nop ñag pak lɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jisas karɨp tɨrɨg tɨroŋ Betani am mɨdɨl, Saimon bɨ soi sapeb ned lak ak karɨp ne ak am bɨsɨg gɨl tap ñɨbelak. Tap ñɨbel nɨŋlɨg gɨ, bin alap wel ki tep owep, mani kɨb taupal ak, barol sek dapɨl, Jisas nabɨc cög ar alaŋ soŋ gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Soŋ gek, Jisas bɨ ne okok nɨŋel, cɨbur kɨrop ak tɨmel gek, aglak, “Wel nɨbak damɨl mani kɨb dɨl, bin bɨ tap ma mɨdeb okok kɨrop ñeb rek ak, pen tari gɨnɨg nɨg gɨl yokop soŋ gɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mɨnɨm nɨbak agelak, Jisas ke nɨŋɨl, kɨrop agak, “Bin nɨbaul ne yɨp gɨ tep yɨb gɨp ak, tari gɨnɨg nɨb agebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bin bɨ tap ma mɨdeb okok eip per mɨdenɨgabɨm, pen yad eip per ma mɨdonɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bin bɨ kɨmel, cɨp tɨgel gɨnɨg, wel lɨ ñɨl dam tɨgel gɨpal. Yɨp tɨgel gɨnɨg gebal ak me, ne wel nɨbak mɨb goŋ yɨp lɨ ñɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pen yad nɨbep nɨŋɨd agebin, kɨsen karɨp lɨm wagɨn aul ke tɨgoŋ tɨgoŋ magɨlsek, mɨnɨm tep yad ak aglɨg gɨ, bin nɨbaul nɨg gosɨp ak kesɨm dɨlɨg gɨ, gak nɨbak saköl ma gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Ñɨn nɨbak, Jisas bɨ ne Judas Iskariot, Jisas nop kain gɨ dam ñen, ñag pak lɨlaŋ, agɨl, God nop tap sobok gep bɨ kɨb okok kɨrop agnɨg amnak. Amɨl agak, “Yad Jisas nop kain gɨ dapɨl nɨbep ñɨnɨgain ak, yɨp pen tap tari ñɨnɨgabɨm?” agak. Agek, nop silpa magɨl ñɨn juɨl nokɨm alap adɨk gɨ dam aknɨb wajrem alaŋ (30) ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ñelak, Judas ne, “Yad titi gɨl Jisas nop mɨmɨg gen, nop dɨ cɨcɨ lɨl dad amnɨlaŋ,” agɨl, gos ak nɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kɨsen tap ñɨŋeb kɨb Bred Yɨs Ma Mɨdeb agölɨgɨpal ñɨn ak wagɨn gek, ñɨn sabdaŋ ak nep, bɨ ne okok Jisas mɨdek sɨŋak apɨl aglak, “Pasopa sipsip ñɨlɨk pak ñɨŋnɨgabɨn ñɨn ak ulep mɨdeb. Nɨb ak, cɨn karɨp akal amɨl tap ñɨŋnɨgabɨn okok gɨ lɨ tep gɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Agelak, kɨrop agak, “Nɨbi taun kɨb ak amɨl, bɨ alap mɨdeb sɨŋak karɨp ne amɨl nop agnɨmɨb, ‘Mɨnɨm ag ñeb bɨ agɨp, “Ñɨn yad ak ulep mɨdeb ak me, bɨ yad okok eip kaj sipsip ñɨlɨk pak dagɨl ñɨŋnɨgabɨn karɨp nak ak,” agɨp,’ agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisas nɨb agek, bɨ ne okok agak rek nɨŋɨl, amɨl kaj sipsip nɨbak karɨp nɨbak pak dagɨl, gɨ lɨ tep gelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dɨgep won ak, bɨ ne aknɨb umɨgan alaŋ okok eip bɨsɨg gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","tap ñɨblɨg gɨ agak, “Yad nɨbep nɨŋɨd agebin, nɨbi bɨ alap yɨp kain gɨ dam amnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Agek, bɨ ne okok gos par lɨl, nokɨm nokɨm nop ag nɨŋlɨg gɨ aglak, “Bɨ Kɨb! Yɨp ageban aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Agelak, agak, “Bɨ yad eip kɨnaŋ mɨgan nokɨm tap ñɨbobɨr aul, yɨp kain gɨ dam amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God Mɨnɨm ak bɨrarɨk nep ñu kɨl tɨkɨl aglak rek, yɨp kain gɨ damɨl, ñag pak lel kɨmnɨgain ak, pen bɨ yɨp kain gɨ dam amnɨgab ak, God bɨ nɨbak nop gɨ tɨmel gɨnɨgab. Nonɨm nop ma tɨk dopkop ak tep. Pen tɨk dapek, mɨdlɨg gɨ nɨg gɨnɨgab ak, kɨsen yur kɨb yɨb dɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Agek, bɨ ne Judas, nop kain gɨnɨg gak bɨ nɨbak agak, “Mɨnɨm ag ñeb bɨ. Yɨp ma ageban aŋ?” agak. Agek, agak, “Me nep agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tap ñɨb mɨdlɨg gɨ, Jisas bred dɨl, God nop tep agɨl, tɨ paŋɨl, bɨ ne okok kɨrop ñɨlɨg gɨ agak, “Nɨbi dɨ ñɨŋɨm. Ak mɨb goŋ yad,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nɨb agɨl, ñɨg wain kap ak, ak rek nep dɨl, God nop tep agɨl, kɨrop ñɨlɨg gɨ agak, “Nɨbi magɨlsek ñɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ak lakañ yad soŋ gɨ yonɨgab ak. Soŋ gɨ yapek, God bɨrarɨk okok agak mɨnɨm ak kɨlɨs gek amnɨgab. Soŋ gɨ yapek, bin bɨ koŋai nep tap si tap tɨmel gɨpal okok, God nɨŋɨl kɨrɨg gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɨb agɨl agak, “Yad nɨbep agebin, ñɨg wain aul mɨñi ognap sek ma ñɨŋnɨgain. Kɨsen, God bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab ñɨn ak nep, yad nɨbep eip ñɨg wain kɨsen ñɨŋnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nɨb agɨl, bɨ ne okok eip God yɨb dap raneb kɨmep alap aglɨg gɨ, Olip Dɨm amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas agak, “God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Yad bɨ kaj sipsip mɨkep ak nop pak len, kaj sipsip ne okok magɨlsek pɨrɨk gɨ amnɨgal,’ aglak. Aglak nɨbak me, mɨdek kɨslɨm nab eyaŋ nɨbi magɨlsek yɨp kɨrɨg gɨl, pɨrɨk gɨ amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pen yad kɨmɨl warɨkɨl, karɨp lɨm Galili ned amenɨgain, nɨbi sain nɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Agek, Pita agak, “Bɨ magɨlsek nep kɨrɨg gɨl, kɨd ñɨnɨmel rek lɨp, pen yad nɨg ma gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Agek, Jisas pen agak, “Yad nep mɨnɨm nɨŋɨd agebin, kɨslɨm nab eyaŋ kɨlokɨl sɨk ma agnɨgab won ak, ‘Jisas nop ma nɨpin,’ agɨl, yɨj omal nokɨm agnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Agek, Pita kɨlɨs yɨb gɨl agak, “Yɨp ñag pak lɨnɨg, ñag pak lɨnɨgal ak pen, ‘Jisas bɨ yad mer,’ agɨl ma agnɨgain,” agak. Jisas bɨ ne magɨlsek ak rek nep Pita agak rek nep aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas bɨ ne okok eip mab wög dai Getsemani amɨl, bɨ ne ognap kɨrop agak, “Nɨbi sɨŋaul bɨsɨg mɨdenɨmɨb. Yad sɨŋ adaŋ amɨl, Bapi nop sobok gɨlɨg gɨ mɨdenɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nɨb agɨl, Pita eip, Sebedi ñɨ ne omal Jems Jon eip kɨrop poŋ dɨl amnak. Amlɨg gɨ, Jisas ne gos par lɨlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kɨrop yakam agak, “Mɨdmagɨl yɨp ak pɨŋɨl ñɨl nep lɨp ak, kɨmnɨm rek lɨp. Nɨbi sɨŋaul mɨdɨl, yɨp kod mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nɨb agɨl, kɨrop nɨb sɨŋak ag lɨl, ne yokop ulep ped sɨŋak amɨl, kɨbor kɨyan gɨl, mɨlɨk dai ak dɨ lɨm eyaŋ lɨl, God nop sobok gɨl agak, “Bapi, tap yɨp gɨnɨg geb nɨbak, mer agnɨg, mer agnɨmɨn. Pen yad gos nɨpin ar ak ma gɨnɨmɨn; gos nak ke nɨpan ar ak rek gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nɨb agɨl, adɨk gɨ apɨl nɨŋak, bɨ ne okok wɨsɨn kɨnelak. Jisas Pita nop agak, “Nɨbi aua nokɨm alap nep yɨp ma kod mɨdebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tap tɨmel gɨjɨn rek lɨp, agɨl, God nop sobok gɨlɨg gɨ mɨdenɨmɨb. Gos nɨbi ak gɨnɨmɨb rek lɨp ak pen mɨb goŋ ak nep masos gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas nɨb agɨl, kauyaŋ am Nap nop sobok gɨl agak, “Tap yɨp gɨnɨg geb yur dɨnɨg gebin ak, kɨrɨg gep rek ma mɨdeb ak, abramek gaŋ; gos nak ke nɨpan ar ak rek gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nɨb agɨl, kauyaŋ adɨk gɨ apɨl nɨŋak, bɨ ne okok udɨn ma nɨŋ mɨdelak; wɨsɨn kɨnelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pen ne adɨk gɨ amɨl, Nap nop ned sobok gak rek nep, kauyaŋ sobok gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","adɨk gɨ apɨl, bɨ ne okok kɨrop agak, “Nɨbi masos gek, kɨn mɨdebɨm ar? Bɨ ognɨl, nɨŋɨm! Bɨ yɨp kain gɨl, Bɨ Ñɨ ne bɨ tap si tap tɨmel gɨpal okok kɨrop ñɨnɨg geb. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Warɨkem amnɨn! Nɨŋɨm! Bɨ kain gɨp bɨ apeb aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas mɨnɨm agek nɨŋlɨg gɨ, bɨ ne aknɨb umɨgan alaŋ alap, Judas, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, nop aglak rek, bɨ kɨri koŋai nep dɨl apjakak. Kɨri tu par kɨd ognap, yɨr pakep ognap dɨl, olak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ned kɨrop ag lɨl agak, “Yad bɨ alap nop am ag wasu dɨl, dɨ bom sɨlokɨl, mɨlɨk ñɨbenɨm ak, bɨ me ak, agɨl, nop dɨ cɨcɨ lɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pen Judas ne Jisas mɨdek sɨŋak kasek nep apjakɨl, “Mɨnɨm ag ñeb bɨ, nak mɨdeban?” agɨl, nop mɨlɨk ñɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nɨg gek, Jisas agak, “Bɨ aul. Tap gɨnɨg geban ak kasek gan!” agak. Agek, bɨ Judas eip olak okok Jisas nop dɨ cɨcɨ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisas dɨ cɨcɨ lel nɨŋlɨg gɨ, Jisas bɨ ne alap tu par kɨd ne ak lɨp gɨ dɨl, bɨ God nop tap sobok gep bɨ kɨb yɨb ak wög nop golɨgɨp bɨ ak, nop tɨmɨd pɨs kɨd ak pɨs nep tɨb gɨ rɨk yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nɨg gek, Jisas nop agak, “Tu par kɨd dɨpan ak adɨk gɨ lɨgek mɨgan eyaŋ yokek yowaŋ. Bin bɨ tu par kɨd dɨl pen pen gɨnɨgal okok, ar nɨbak nep kɨmnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yad ‘Bapi ake!’ agebnep, ne kasek nep ejol yakam ke ke aknɨb umɨgan alaŋ rek ag yokek, apɨl yɨp kod mɨdeblap. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pen bɨrarɨk nep God Mɨnɨm ak ñu kɨl tɨkɨl, yɨp nɨb nɨb gɨl kɨmnɨgab aglak ak me, nɨg gɨnɨmɨŋ. Yad ar alap ke genɨgain ak, yɨpɨd gɨl ma gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pen bɨ nop dɨnɨg olak nɨb okok kɨrop agak, “Yad per am God sobok gep karɨp ak bɨsɨg mɨdɨl, bin bɨ okok kɨrop mɨnɨm ag ñɨbin ak pen yɨp ma dɨpɨm. Mɨñi pen, tu par kɨd sek, yɨr pakep sek dapɨl, bɨ tap si dep rek ak yɨp dɨnɨg opɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nɨbi gebɨm nɨbak, God mɨnɨm agep bɨ okok God Mɨnɨm ñu kɨl tɨkɨl aglak rek nep gebɨm,” agak. Pen won nɨbak, Jisas bɨ ne okok magɨlsek nop kɨrɨg gɨl pɨrɨk gɨ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pen God lo mɨnɨm ag ñeb bɨ okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, ap mogɨm gɨ mɨdelak bɨ Kaiapas God nop tap sobok gep bɨ kɨb yɨb ak karɨp ne sɨŋak me, Jisas nop dɨ cɨcɨ lɨl, dam karɨp nɨbak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pen Pita ne kɨsen kɨsen amɨl, karɨp söŋ ar ak mɨdɨl, God sobok gep karɨp polisman okok eip bɨsɨg gɨl, tari rek gɨnɨgal agɨl, nɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bɨ God nop tap sobok gep bɨ kɨb okok abe, Juda Kansol kɨb bɨ okok abe aglak, “Cɨn bɨ mɨnɨm esek agep bɨ ognap kɨrop ag nɨŋon, kɨri mɨnɨm ognap agel, yɨpɨd gɨl mɨdek, mɨnɨm jɨj me ak, agɨl, Jisas nop ñag pak lɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nɨb aglak ak pen mɨnɨm nɨbak ke ke amek, Jisas nop ñag pak lep wagɨn alap ma mɨdek. Nɨg gak ak pen kɨsen bɨ omal apɨl agrek, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Bɨ nɨbaul agak, ‘Yad God sobok gep karɨp ak tɨ paŋ yokɨl, mɨdak ñɨn omal nokɨm kauyaŋ gɨ lɨnɨgain,’ agak,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nɨb agerek, God nop tap sobok gep bɨ kɨb yɨb ak Jisas nop agak, “Mɨnɨm nep agebir ak, nak pen alap ma agnɨgan ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Agek, Jisas pen mɨnɨm alap ma agak. Nɨg gek, bɨ God nop tap sobok gep bɨ kɨb yɨb ak agak, “Mɨñi mɨnɨm kɨb agnɨg mɨdobɨn aul, mɨnɨm tom ma agnɨmɨn. God per komɨŋ mɨdeb ak, ak rek nep nɨŋ mɨdeb. Nɨb ak, cɨnop yɨpɨd gɨl agnɨmɨn: nak Mesaia ak, God Ñɨ ne aka mer?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Agek, Jisas pen agak, “Me nak ageban ak. Pen nɨbi magɨlsek nɨŋɨm! Yad nɨbep agebin, yad Bɨ Kɨb kɨlɨs ke sek ak ñɨnmagɨl yɨpɨd pɨs ar ne mɨdɨl, seb bad ar sɨŋak amɨl, lɨm dai wagɨn aul apenɨgain ak nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas nɨb agek, bɨ God nop tap sobok gep bɨ kɨb yɨb ak, walɨj ne okok ke tɨg bɨlɨlɨ gɨlɨg gɨ agak, “Ne God yɨb ak tɨb juosɨp nɨpɨm! Nɨb ak, bin bɨ ognap kɨrop ma ag nɨŋnɨgabɨn. Ne gɨ tɨmel gɨp ak mɨseŋ agɨp me ak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aka nɨbi gos tari nɨŋebɨm?” agak. Agek, kɨri pen aglak, “Me agɨp me ak; ne kɨmaŋ nokɨm,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nɨb agɨl, mɨlɨk jo mɨlɨk nop ak kɨñɨk ñag ñɨlɨg gɨ, paklɨg gɨ, gɨlak. Ognap Jisas ñölep won ne pɨrau karɨk ñɨl, mɨkem ne okok paklɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aglak, “Nak Mesaia ak, bɨ an nep pakeb ak, cɨnop agek nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pen Pita mɨnɨm kɨb agep karɨp mɨs ar eyaŋ bɨsɨg mɨdek ak me, bɨ God nop tap sobok gep bɨ kɨb yɨb ak nop wög golɨgɨp pai alap apɨl, nop agak, “Nak Jisas bɨ Galili nɨb ak eip mɨdesir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Agek, Pita bin bɨ okok magɨlsek nɨŋ mɨdel nɨŋlɨg gɨ, agak, “Mɨnɨm nak ageban ak adi ma nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nɨb agɨl, warɨkɨl, am kɨjoŋ wagɨn sɨŋak mɨdek nɨŋlɨg gɨ, bin karɨp nɨbak wög golɨgɨp alap apɨl, Pita nop nɨŋɨl, bin bɨ mɨdelak okok kɨrop agak, “Bɨ aul ne bɨ Jisas Nasaret nɨb ak eip mɨderek nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Agek, Pita we ñɨl agak, “Yad nɨŋɨd yɨb agebin, bɨ agebɨm nɨbak adi ma nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sɨkol magɨl alap mɨdɨl, bin bɨ Pita eip jak mɨdelak okok nop aglak, “Nɨŋɨd nep agobɨn. Nak bɨ kɨri alap. Meg mɨgan kɨri agebal rek, nak abe ak rek nep ageban,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Agelak, Pita pak bleble gɨl agak, “Yad nɨbep nɨŋɨd yɨb agebin. Mer ak, God yɨp yur mab ñɨnɨmɨŋ tep. Bɨ nɨbi agebɨm nɨbak adi ma nɨpin!” agak. Nɨb agek nɨŋlɨg gɨ, dai kɨlokɨl ak gaul gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kɨlokɨl ak gaul gek, Pita Jisas mɨnɨm nop ned agak nɨbak gos nɨŋɨl, gos par nɨŋak. Tari gɨnɨg: Jisas ned agak, “Kɨlokɨl gaul ma gɨnɨgab won ak, ‘Jisas nop ma nɨpin,’ agɨl, yɨj omal nokɨm agnɨgan,” agak. Gos nɨbak nɨŋɨl me, gos par nɨŋɨl, mɨs amɨl, sɨl kɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Karɨp kɨsen tɨkak nɨŋɨl, God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, mɨnɨm ag nɨŋ ag nɨŋ gɨl, mɨnɨm ag ar nokɨm lɨl, Jisas nop ñag pak lɨn, aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nɨb ak, Jisas nop nag lɨl, damɨl gapman bɨ kɨb gapna Pailot nop ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pen Jisas nop mɨnɨm kɨb agɨl, ñag pak lɨnɨg gelak nɨŋɨl, Judas, tari gɨnɨg Jisas nop mɨmɨg nɨpin, agɨl, kab magɨl dak ak, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, kɨrop ju dam ñɨnɨm, agɨl, God sobok gep karɨp ak amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Amɨl, kab magɨl nɨb okok kɨrop ñɨlɨg gɨ agak, “Jisas gɨ tɨmel ma gɨp ak pen yad nop mɨmɨg nɨpin ak, mɨdak kɨmnɨgab. Nɨb ak, yad tap si tap tɨmel gɨpin,” agak. Agek, kɨri aglak, “Ak tap cɨn mer. Nak ke nep nɨg gɨpan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Agelak, Judas kab magɨl ñɨlak nɨbak God sobok gep karɨp mɨgan ak dɨ yokɨl, amɨl mɨñ ñɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɨ God nop tap sobok gep bɨ kɨb okok, kab magɨl nɨbak dɨl aglak, “Kab magɨl nɨbaul, bɨ ñag pak lɨn, agɨl, mɨmɨg gɨnok ak me, God nop ñɨjɨn rek ma lɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nɨb agɨl, mɨnɨm ag nɨŋ ag nɨŋ gɨl aglak, “Bɨ par okok nɨb apɨl kɨmel, dam tɨgel gɨjɨn ak, lɨm dai mɨgan alap tauɨl tɨgel gɨn,” agɨl, am bɨ alap makjak dɨl tin cög golɨgɨp lɨm dai mɨgan nɨbak taulak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lɨm dai mɨgan nɨbak, mɨmɨg pɨŋɨl ñɨlak kab magɨl ak dɨl taulak ak me, kɨsen bin bɨ lɨm dai mɨgan nɨbak, yɨb “Lɨm Mɨgan Lakañ Sek” aglak. Mɨñi ak rek nep lɨm dai mɨgan nɨbak, yɨb “Lɨm Mɨgan Lakañ Sek” apal. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pen kɨri lɨm dai taulak nɨbak, bɨ God mɨnɨm agep Jeremaia ned agɨl ñu kɨl tɨkak rek nep gɨlak. Ne God Mɨnɨm ak dai alap ñu kɨl tɨkɨl agak, “Kɨri kab magɨl silpa ñɨn juɨl nokɨm alap adɨk gɨ dam aknɨb wajrem alaŋ (30) ak, Juda bɨ aglak kab magɨl ak yɨg damɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bɨ makjak dɨl tin cög golɨgɨp lɨm dai mɨgan nɨbak taulak. Bɨ Kɨb yɨp agak rek nep gɨlak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas nop damɨl, gapman bɨ kɨb Pailot mɨdek sɨŋak amel nɨŋlɨg gɨ, gapna Pailot Jisas nop agak, “Nak Juda kai kiŋ kɨb kɨri mɨdeban aka?” agak. Agek, Jisas pen agak, “Me nak ageban me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pen bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, nop mɨnɨm ognap agelak, ne pen mɨnɨm alap ma agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nɨg gek, gapman bɨ kɨb Pailot nop agak, “Mɨnɨm pen pen agɨl, mɨnɨm ke ke agebal ak, nak ma nɨpan ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Agek, Jisas mɨnɨm pen alap ma agek, Pailot gos par yɨb nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Pen Pailot ne bɨ kɨb mɨnɨm tɨg bɨlokep sea ar ak bɨsɨg mɨdek nɨŋlɨg gɨ, bine mɨnɨm alap agek, apek agak, “Yad mɨdarɨk nep kɨslɨm eyaŋ wɨsɨn nɨpin, bɨ mɨnɨm kɨb ageban bɨ ak bɨ tep. Nop mɨnɨm kɨlɨs ma agnɨmɨn. Yad wɨsɨn nɨpin nɨbak, gos par yɨb nɨŋebin,” agak. Pen Pailot gos ne ke okok nep nɨŋak, Jisas tap tɨmel alap ma gak; bɨ kɨb okok nep nop nɨŋel mɨlɨk yowɨp dopal. Nɨb ak, yad titi gɨl, nop ag yoken amnaŋ, agɨl, gos ak nɨŋak. Pen Rom gapna bɨ kɨb ak per mɨ nokɨm nokɨm Juda kai Pasopa ñɨn kɨb ak, kɨrop bɨ nagɨman kɨri ke ag nɨŋölɨgɨpal ak, yokop wɨsɨb yokolɨgɨp. Ñɨn nɨbak, bɨ tɨmel yɨb alap mɨñ mɨdek; yɨb ne ak Barabas. Bin bɨ koŋai nep ap mogɨm gelak okok, Pailot kɨrop agak, “Nɨbep bɨ akal yokop ag yoknɨm? Jisas, Mesaia apal bɨ ak aka Barabas nop ag yoknɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Agek, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, bin bɨ koŋai mɨdelak okok kɨrop aglak, “Nɨbi Pailot nop agem, ne Barabas nop wɨsɨb yokɨl, Jisas nop ñag pak lɨnɨmɨŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pen Pailot bin bɨ ap mogɨm gɨ mɨdelak okok kɨrop agak, “Bɨ omal aul, bɨ an nop wɨsɨb yoknɨm?” agak. Agek, kɨri pen aglak, “Barabas nop wɨsɨb yokan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Agelak, Pailot agak, “Nɨb agebɨm ak, Jisas Mesaia ak apal ak, nop tari gɨnɨm?” agak. Agek, kɨri magɨlsek aglak, “Nop mab bak alaŋ ñag pak lɨlaŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Agelak, Pailot agak, “Pen tari? Ne tap tari tap gɨ tɨmel gɨp?” agak. Agek, mɨnɨm agak ak ma nɨŋɨl, mɨnɨm dap ranɨl aglak, “Nop mab bak alaŋ ñag pak lɨlaŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Agelak, Pailot gos nɨŋak, mɨnɨm yad ma dɨnɨgal; pen mɨnɨm ognap sek kɨrop ag ñen, pen pen paknɨmel rek lɨp, ag gos nɨŋak. Nɨg gos nɨŋɨl, bin bɨ okok udɨn yɨrɨk ar kɨri sɨŋak, ñɨg dɨl ñɨnmagɨl kɨd ne ñɨg lɨ yoklɨg gɨ, kɨrop agak, “Bɨ nɨbaul nop ñag pak lɨnɨg gebɨm ak, mɨnɨm nɨbak yɨp ma onɨgab; nɨbepe ke adɨk gɨ nɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Agek, bin bɨ okok magɨlsek aglak, “Ak cɨp kɨmɨg cɨni ke! Lakañ ne cɨnop apɨl, ñɨ cɨn okok amnɨgab! Mɨnɨm nɨbak, cɨn abe, ñɨ pai cɨn okok abe onɨgab!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nɨb agelak, Pailot kɨrop Barabas nop wɨsɨb yokɨl, Jisas nop ami bɨ ne okok ñak nɨŋɨl kɨri nag dɨ Jisas paklak. Nɨg gel, Pailot ne Jisas nop mab bak alaŋ ñag pak lɨlaŋ, agɨl, ami bɨ ne okok kɨrop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gapna Pailot ami bɨ ne okok Jisas nop dɨl, dam karɨp kɨb kɨri ak amɨl, ami bɨ yokop okok kɨrop magɨlsek sɨk agel, ");
INSERT INTO kmh_m_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ap mogɨm gɨl, walɨj nop ak tɨg juɨl, walɨj sapai, bɨ kɨb yɨbal rek alap dapɨl, nop yɨm ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yɨm ñɨl, nag ñu ñu sek okok dapɨl, kiŋ kai tol gɨpal rek usajɨl bad alap gɨl, nop tol gɨ ñɨl, bɨ kɨb okok yɨr dɨpal, agɨl, gamɨl par alap dɨ Jisas nop ñɨnmagɨl yɨpɨd kɨd ne ak ñɨl, apɨl nop kogɨm yɨmɨl, ag julɨg gɨ aglak, “Bɨ kɨb nak apeban? Juda kai kiŋ kɨri nak apeban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nɨb agɨl, nop kɨñɨk ñagɨl, gamɨl par nɨbak ju dɨl, nop nabɨc cög ar alaŋ paklak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pen Jisas nop nɨg gɨl ag juɨl, walɨj sapai nop yɨm ñɨlak ak tɨg ju yokɨl, walɨj ne ke yɨm ñɨl, nop mab bak alaŋ ñag pak lɨnɨg, poŋɨd dɨ dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kanɨb nab okok amlɨg gɨ nɨŋlak, Sairini taun nɨb bɨ alap apek. Yɨb ne ak Saimon. Nop nabɨŋ pakɨl, kɨlɨs gɨl aglak, “Jisas nop ñag pak lɨnɨgabɨn mab kros aul dad noŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Agel, ne dɨlɨg gɨ, karɨp lɨm Golgota dɨm amnɨlak. Golgota agölɨgɨpal ak mɨnɨm wagɨn ak, “Cɨp Nabɨc Cög Tɨŋɨl.” ");
INSERT INTO kmh_m_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pen dɨm nɨbak amjakɨl, ami bɨ okok ñɨg wain dɨl, ñɨg sɨlek alap dɨl, sek tɨg adɨk madɨk gɨl, Jisas nop ñelak, pen ne ñɨb nɨŋɨl kɨrɨg gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jisas nop mab bak alaŋ ñag pak lɨl, walɨj nop okok nonɨm lɨ ke ke dɨnɨg, sadu rek gɨl dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nɨg gɨl, Jisas nop mab bak alaŋ ñag pak lɨlak wagɨn sɨŋak bɨsɨg gɨl, kod nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisas nop ñag pak lɨl, mab bak alaŋ ñu kɨl tɨklak: ");
INSERT INTO kmh_m_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pen Jisas nop ñag pak lɨl, bɨ tap si dep omal, alap pɨs kɨd, alap pɨs kɨd, ñag pak lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Bin bɨ kanɨb nɨbak ar ap ran ap yap gelak okok, kɨmɨg cög gor mar gɨl, nop ag juɨl aglak, “Nak God Ñɨ ne rek! God sobok gep karɨp ak tɨg wal gɨ yokɨl, ñɨn omal nokɨm kauyaŋ gɨ lɨnɨgan ak me, mab kros bak alaŋ kɨrɨg gɨl yapek cɨn nɨŋɨn!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɨ God nop tap sobok gep bɨ kɨb okok, bɨ lo mɨnɨm ag ñeb bɨ okok, bɨ mɨnɨm tɨg bɨlokep okok, kɨri ak rek nep nop ag juɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Bin bɨ ognap kɨrop gosɨp komɨŋ ambal, pen ne ke nɨg gɨnɨmɨŋ rek ma lɨp. Isrel Kiŋ kɨb cɨn ak, mab kros bak alaŋ kɨrɨg gɨl, lɨm wagɨn aul yapek, nɨŋɨd agɨp, agɨl, nop nɨŋ dɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ne God nop nɨŋ dɨl agɨp, ‘Yad God Ñɨ ne,’ agɨp. God ne ke ak rek nep gos nɨŋenɨgab ak, mɨñi apɨl, nop dɨ komɨŋ yokaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɨ tap si dep Jisas eip ñag pak lɨlak bɨ omal, kɨri ak rek nep, nop mɨnɨm tɨmel nɨbak rek nep agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ñɨn nɨbak pɨb nab epel won ak, kɨslɨm apɨl, mɨd damɨl, pɨb kim gak won ak kauyaŋ melɨk gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pɨb kim gak won ak, Jisas sɨk kɨb agɨl agak, “Eli, Eli, lama sabaktani,” agak. Agak nɨbak, “God yad. God yad. Yɨp ti gɨnɨg kɨrɨg gɨpan?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nɨb agek, bin bɨ ognap ulep nɨb sɨŋak mɨdelak okok nɨŋɨl aglak, “Bɨ nɨbaul bɨ God mɨnɨm agep Ilaija nop sɨk ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɨb agɨl, bɨ alap am tap dai wɨs sain rek bad alap dɨ dapɨl, ñɨg wain sɨlek ak tauɨl, gamɨl par alap dɨl, kabɨs ñagɨl, ñen ñɨŋaŋ agɨl, ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nɨg gɨl ñek, bɨ ognap aglak, “Kɨrɨgan! Kapkap nɨŋ mɨdon. Ilaija apɨl, nop dɨ komɨŋ yoknɨgab aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pen Jisas kauyaŋ sɨk kɨb agɨl, kaun ne God nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Won nɨbak nep, walɨj par kɨb God sobok gep karɨp ñɨlɨk mɨgan eyaŋ, kɨjoŋ pak pɨlɨŋ gɨlak ak, nab eyaŋ pak bɨl bɨl gɨl pɨs kɨd ke pɨs kɨd ke amnak. Nɨg gek nɨŋlɨg gɨ, monmon dɨl, kab okok pawɨkɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","cɨp kab mɨgan tɨgel gɨl pak pɨlɨŋ gɨlak okok, mɨgan yɨkɨl, God bin bɨ sɨŋ ne ned kɨmlak tɨgel gɨlak okok, koŋai nep gek, kauyaŋ warɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Warɨkɨl, kab mɨgan okok kɨrɨg gɨ söŋ amɨl, Jisas warɨkak ñɨn ak kɨri taun kɨb tɨd Jerusalem amelak, bin bɨ koŋai nep kɨrop mɨseŋ lel mɨseŋ nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pen monmon dɨl, tari tari gak ak nɨŋɨl, ami bɨ kɨb ak abe, bɨ ne okok eip mɨdelak okok abe, kɨri jel gek pɨrɨkɨl, mɨdmagɨl kɨri amek nɨŋlɨg gɨ, kɨri aglak, “Yaue! Bɨ aul ne God Ñɨ ne nɨŋɨd yɨb!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pen bin koŋai nep apɨl, ke ke sɨŋak mɨdɨl, nɨŋ mɨdelak. Bin nɨb okok Jisas nop gɨ ñɨnɨg Galili nɨb olak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bin mɨdelak nɨb okok alap Maria Magdala ak, alap Jems eip Josep eip nonɨm Maria ak, alap Sebedi ñɨ ne omal nonɨm ak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Bɨ gep yɨb alap, Josep, Arimatia taun nɨb ak, ne Jisas bɨ ne alap mɨdek. Bɨ nɨbak, Jisas kɨmɨb nɨŋɨl, dɨgep dɨgep won ak apɨl, gapna Pailot nop, Jisas mɨb goŋ ak dɨnɨm aka agek, Pailot yau agɨl, bɨ ne okok kɨrop agek, Josep nop ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jisas mɨb goŋ ne ak Josep nop ñel, ne walɨj tɨd tep alap dɨl, cɨp se par ak magɨlsek kom sɨlok yokɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","dam kab mɨgan kɨsen nep alap, yɨpe tɨgel gɨnɨgal, agɨl, pɨŋɨl jɨrɨk lɨlak mɨgan ak tɨgel gɨl, kab salai kɨb alap dɨ go ga gɨ dam kɨjoŋ pɨlɨŋ gɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bin omal mɨderek, bin alap Maria Magdala, bin alap Maria alap. Bin Maria omal apɨl nɨŋ mɨderek nɨŋlɨg gɨ, Josep nɨg gɨl tɨgel gak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas kɨmek tɨgel gɨlak ñɨn nɨbak, God nop tap sobok gep bɨ kɨb okok abe, bɨ Perisi okok abe, God nop sobok gɨnɨg ñɨn ak tol, agɨl, tap gɨ dap jɨn gɨlak. Pen mɨnek, God nop sobok gɨnɨg ñɨn kɨri ak me, gapman bɨ kɨb Pailot mɨdek sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Amɨl aglak, “Bɨ kɨb. Bɨ esek agep nɨbak agak, ‘Yad kɨmɨl, ñɨn omal nokɨm ak warɨknɨgain,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nɨb ak, nak bɨ ognap agek, ñɨn omal nokɨm cɨp tɨgel ak kod mɨdenɨmel. Mer ak, bɨ ne okok apɨl, cɨp se par ak si dɨl, bin bɨ okok kɨrop esek agɨl agnɨgal, ‘Ne kauyaŋ warɨkɨp,’ agnɨgal. Nɨg gel, Jisas ned mɨnɨm esek agak ak tap sɨkol; kɨri kɨsen mɨnɨm esek agnɨgal ak kɨb yɨb gɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Agelak, Pailot kɨrop agak, “Nɨb ak, nɨbi ami sɨkop bad alap dɨl, cɨp tɨgel gɨlak okok amɨl, gos nɨbi ke nɨŋ tep gɨl, cɨp tɨgel kab lɨ wös gem, ami bɨ kod nɨŋ mɨdenɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Agek, Juda bɨ kɨb nɨb okok amɨl, kɨjoŋ pɨlɨŋ gɨlak kab kɨb ak uren rek gɨl, ami bɨ bad alap kɨrop agel, kɨri nɨb sɨŋak kod nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mɨnek karɨp tɨk dam lek nɨŋlɨg gɨ, bin omal Maria Magdala abe Maria alap abe kɨri amɨl, Jisas nop tɨgel gɨlak sɨŋak nɨŋnɨg amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Won nɨbak monmon kɨb yɨb dek nɨŋlɨg gɨ, ejol alap seb kab ar alaŋ nɨb apɨl, Jisas nop tɨgel gɨl kab salai pɨlɨŋ gɨlak ak, tɨg ju bak sɨŋak yokɨl, ar nɨbak bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ejol nɨbak, mɨlɨk dai ne melɨk melɨk gɨlɨg gɨ mɨdek. Walɨj ne ak, tɨd tep yɨb ak lak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pen ami bɨ nɨŋ mɨdelak okok, nop nɨŋɨl, jel gek pɨrɨkɨl, jep jep dɨl, kɨmɨl rek mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pen ejol ak bin omal kɨrop agak, “Ma pɨrɨknɨmir! Yad nɨpin, nɨri mal Jisas mab bak alaŋ ñag pak lɨlak ak nop nɨŋ ajebir. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ne sɨŋaul ma mɨdeb. Ned agak rek, mɨdarɨk nep kauyaŋ warɨkɨl amɨb. Pen nɨri apɨl, nop dam lɨlak kau ar ak nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","kasek amɨl, bɨ ne okok kɨrop agnɨmir, ‘Jisas kauyaŋ warɨkɨl Galili ameb. Nɨbi bɨ ne amɨl nop nɨb okok nɨŋnɨgabɨm,’ agnɨmir. Mɨnɨm nɨbak nep nɨrep ag ñɨnɨg opin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nɨb agek nɨŋɨl, bin omal pɨrɨkrek ak pen mɨñ mɨñ gɨlɨg gɨ, cɨp tɨgel nɨbak kasek kɨrɨg gɨl, bɨ ne okok kɨrop agnɨg kasek amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kanɨb nab okok amerek nɨŋlɨg gɨ, Jisas kɨrop mal nabɨŋ pakɨl agak, “Nɨri mɨdebir?” agak. Agek, kɨri mal ap kogɨm yɨmɨl, tob ne dɨ wös gɨl, yɨb ne ak ager ar amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas kɨrop mal agak, “Ma pɨrɨknɨmir! Nɨri amɨl mam sɨkop yad okok kɨrop agnɨmir, ‘Galili amɨl Jisas nop nɨŋnɨgabɨm,’ agnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bin omal, kanɨb nab okok amer nɨŋlɨg gɨ, ami bɨ nɨŋ mɨdelak okok ognap, taun kɨb wari mɨgan eyaŋ amɨl, bɨ God nop tap sobok gep bɨ kɨb okok kɨrop, tari tari gak nɨbak magɨlsek ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ag ñelak, bɨ God nop tap sobok gep bɨ kɨb okok amɨl, bɨ mɨnɨm tɨg bɨlokep eip mɨnɨm ag ar nokɨm lɨl, ami bɨ nɨb okok kɨrop mani kɨb ñɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Nɨbi mɨnɨm aul nep agnɨmɨb, ‘Kɨslɨm nab eyaŋ wɨsɨn kɨnosɨn won ak, bɨ ne okok apɨl, cɨp se par ak si dad ambal,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nɨb agem, gapna Pailot mɨnɨm nɨbak nɨŋnɨgab ak, cɨn nop eip agon, nɨbep mɨker ognap ma ñɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nɨb agel, ami bɨ okok mani nɨbak dɨl, amɨl Juda bɨ kɨb nɨb okok aglak rek nep gɨlak. Kɨri esek agɨl, Jisas cɨp se par ne ak, bɨ ne okok si dɨ ambal, agelak mɨnɨm ak, mɨñi Juda bin bɨ okok mɨnɨm esek nɨbak nep aglɨg gɨ nep mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisas bɨ ne aknɨb agɨp alaŋ okok Galili amɨl, Jisas ned agak dɨm ak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kɨri amɨl, Jisas nop nɨŋɨl, yɨb ne agel ar amnak. Pen bɨ ne ognap nɨŋɨl sɨdol gɨl aglak, “Ak Jisas aka bɨ aknɨb ke?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pen Jisas maŋ sɨŋak apɨl, kɨrop agak, “Bapi yɨp agek, karɨp lɨm seb kab ar alaŋ sɨŋak abe, lɨm dai wagɨn aul abe, yad magɨlsek kod mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nɨb ak, nɨbi karɨp lɨm okok magɨlsek tɨgoŋ tɨgoŋ amɨl, bin bɨ ke ke okok magɨlsek mɨnɨm tep yad ag ñem, kɨri yɨp nɨŋ dɨl bin bɨ yad mɨdɨl yɨp kɨsen gɨnɨmel. Nɨbi nɨg gɨl, Bapi ak, Ñɨ ak, Kaun Sɨŋ ak yɨb agɨl, kɨrop ñɨg pak ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nɨg gɨl, yad nɨbep gɨnɨmɨb, agɨl, mɨnɨm tari tari ag ñɨbin ak, nɨbi ak rek nep mɨnɨm nɨbak magɨlsek kɨrop ag ñɨ tep gem, magɨlsek kɨsen gɨnɨmel. Pen yad nɨbep nɨŋɨd yɨb agebin, yad nɨbep eip mɨdɨl, mɨd damɨl, mɨden nɨŋlɨg gɨ, lɨm dai wagɨn aul kɨr gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Krais, God Ñɨ ne mɨnɨm tep ak agnɨg gebin. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God bɨrarɨk nep Ñɨ ne Jisas Krais nop mɨnɨm agak rek, bɨ God mɨnɨm agep Aisaia, mɨnɨm nɨbak God Mɨnɨm ñu kɨl tɨkɨl agak, “Nɨŋan! Bɨ mɨnɨm yad dad ameb ak, ned ag yoken amɨl, kanɨb nep ak lɨg gɨ tep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bɨ nɨbak, karɨp lɨm bin bɨ koŋai ma mɨdebal, mɨñ mab kab nep mɨdeb nab sɨŋak am mɨdɨl, sɨk agɨl agnɨgab, ‘Bɨ Kɨb ak apeb! Kanɨb mak kɨlan kɨyan gɨ mɨdonɨmɨŋ okok, dɨm gol pɨlɨs gɨ mɨdonɨmɨŋ okok, pɨŋɨl pag tep gɨnɨmɨb,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","God mɨnɨm agep bɨ nɨbak ned nɨb agak rek nep me, Jon bɨ ñɨg pak ñeb ak amɨl, karɨp lɨm bin bɨ koŋai ma mɨdelɨgɨpal, mɨñ mab kab nep mɨdolɨgɨp nab sɨŋak mɨdek nɨŋlɨg gɨ, bin bɨ okok apel, kɨrop mɨnɨm ag ñɨl agolɨgɨp, “Tap si tap tɨmel gɨpɨm okok, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gem, yad nɨbep ñɨg pak ñen, God tap si tap tɨmel gɨpɨm okok nɨŋɨl kɨrɨg gɨnɨgab,” agolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne nɨb agek nɨŋlɨg gɨ, bin bɨ karɨp lɨm Judia yokop nɨb okok mɨdelak okok abe, Jerusalem bin bɨ mɨdelak okok abe, kɨri magɨlsek mɨnɨm nop ak nɨŋnɨg amnɨlak. Amɨl, tap si tap tɨmel gölɨgɨpal okok, ag mɨseŋ lel, Jon kɨrop ñɨg Jodan nab sɨŋak ñɨg pak ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pen Jon walɨj ne ak, kaj kamel kas dɨl gɨlak walɨj alap yɨmɨl, kaj kau wak sɨb nag nab sɨŋak pog lolɨgɨp. Tap ñɨŋeb ne ak, joŋ golbɨd ak abe, bom ñɨg ak abe ñɨbolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ne bin bɨ okok kɨrop agolɨgɨp, “Bɨ yɨp sain apeb ak, ne yad rek mer; ne bɨ kɨb yɨb, yad bɨ sɨkol. Yad nop nɨŋen nabɨŋ gɨnɨgab. Yad amɨl ulep sɨŋak kogɨm yɨmɨl tob tɨrɨp ne ak nag wɨsɨbnɨm rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yad nɨbep ñɨg nep pak ñebin ak pen ne apɨl, nɨbep Kaun Sɨŋ ak nep pak ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pen ñɨn alap, Jisas Nasaret taun, karɨp lɨm Galili Propins mɨdolɨgɨp ak kɨrɨg gɨl, Jon mɨdek sɨŋak apek, Jon Jisas nop ñɨg Jodan nab sɨŋak ñɨg pak ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nop ñɨg pak ñek, Jisas ñɨg gol sɨŋak alaŋ amɨl nɨŋak, seb kab ar alaŋ pag yɨkek, God Kaun ak yakɨr tɨbaglem rek, Jisas nop ug gɨ owak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nɨg gɨl ug gɨ apek nɨŋlɨg gɨ, mɨnɨm alap seb kab ar alaŋ sɨŋak nɨb apɨl agak, “Nak Ñɨ mɨdmagɨl yad yɨb. Nep nɨŋen, yɨp tep yɨb gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pen won nɨbak nep, God Kaun ak Jisas nop ag yokek, mɨñ mab kab nep mɨdolɨgɨp nab okok amɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ñɨn aknɨb ñɨn juɨl omal (40) sɨŋak mɨdek. Nɨb okok mɨdek nɨŋlɨg gɨ, Seten, “Jisas nop gen, mɨnɨm yɨp ak kɨsen gɨl, tɨmel gaŋ,” agɨl, apɨl agolɨgɨp. Karɨp lɨm mɨdolɨgɨp mɨgan nɨbak ke kain tap okok nep mɨdolɨgɨp. Pen ejol okok apɨl, Jisas nop kod mɨdelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pen kɨsen gapman bɨ kɨb Herod Jon nop mɨñ lak nɨŋɨl Jisas ne karɨp lɨm Galili Propins amɨl, God mɨnɨm tep ak bin bɨ okok kɨrop ag ñɨlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“God bin bɨ dɨl kod mɨdenɨgab ñɨn per kod mɨdelɨgɨpɨm ak, mɨñi owɨp! Tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn agɨl kɨrɨg gɨnɨmɨb, God mɨnɨm tep ak nɨŋɨd ageb, agɨl, nɨŋ dɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Ñɨg Cöb Galili gol sɨŋak padɨklɨg gɨ nɨŋak, bɨ kɨbsal dep mamɨl mal, kɨbsal dɨr, agɨl, uben alap dɨ ñɨg nab eyaŋ yokɨl mɨderek. Bɨ mamɨl nɨb mal yɨb kɨri mal ak, Saimon eip Edru eip. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas kɨrop mal nɨŋɨl agak, “Aper, yad eip ajɨl, yad nɨrep mal ag ñɨ tep gen, bin bɨ dep bɨ omal mɨdenɨgair,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jisas agek, nɨŋɨd ageb agɨl, dai uben okok kɨrɨg gɨl, Jisas eip amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pen Jisas yokop sɨkol won alap amɨl nɨŋak, Sebedi ñɨ ne Jems eip, Jon eip ñɨg magöb mɨgan ak mɨdlɨg gɨ, uben pɨg gɨ rɨkak tam ak, ñag dör gɨlɨg gɨ mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas kɨrop mal nɨŋɨl agak, “Nɨri mal owir e!” agak. Jisas nɨb agek, kɨri mamɨl mal nɨŋɨl, nap nop wög gɨ ñeb bɨ ognap eip kɨrop ñɨg magöb ar sɨŋak kɨrɨg gɨl, Jisas eip amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pen kɨri taun sɨkol Kapaneam amɨl, Juda God nop sobok gep ñɨn ak, Jisas Juda mogɨm gep karɨp ñɨlɨk mɨgan eyaŋ amɨl, God Mɨnɨm ak ag ñek, ");
INSERT INTO kmh_m_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","bin bɨ okok nɨŋɨl, pak ju dɨl aglak, “God lo mɨnɨm ag ñeb bɨ okok agebal rek ma ageb; ne bɨ kɨb yɨb nɨŋ tep gɨl agebal rek ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pen magɨl nɨbak, bɨ kɨjeki abaŋ ñagak bɨ alap, mogɨm gep karɨp ñɨlɨk mɨgan nɨbak apjakɨl bleble gɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas bɨ Nasaret nɨb! Nak cɨnop tari gɨnɨg opan? Cɨnop kɨjeki okok ñag pak lɨnɨg opan aka? Yad nep nɨpin, nak God Ñɨ Sɨŋ ne ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Agek, Jisas pen kɨjeki bɨ nɨbak abaŋ ñagak ak nop mɨnɨm kɨlɨs agɨl agak, “Mɨnɨm ma agan! Bɨ ak nop kɨrɨg gɨl, mɨs amnoŋ!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jisas nɨb agek, kɨjeki nɨbak bɨ ak nop dɨ jep jep dɨl, sɨk gaul gɨl, söŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jisas nɨg gek, bin bɨ mɨdelak okok wal yɨb agɨl, mɨnɨm ag nɨŋ ag nɨŋ gɨl aglak, “Ak tari? Bɨ aul mɨnɨm kɨsen nɨb alap dapɨl ag ñeb. Ne bɨ kɨlɨs sek. Kɨjeki kɨyob ñɨlɨk okok mɨnɨm ne dɨl ageb rek gebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bin bɨ okok nɨb aglɨg gɨ, Jisas kɨjeki kɨyob ñɨlɨk ag söŋ yokak mɨnɨm nɨbak, karɨp lɨm Galili okok magɨlsek ag ñel amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pen Jisas, Jems, Jon, Saimon, Edru, kɨri Juda mogɨm gep karɨp ak kɨrɨg gɨl, söŋ amɨl, Saimon eip nɨmam Edru eip karɨp kɨri ak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Karɨp amjakel, Jisas nop aglak, “Saimon nɨbor ne mɨb goŋ ak mab rek yɨnek, kɨn mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Agel, Jisas amɨl ñɨnmagɨl kɨd ne ak dɨl dɨ warɨk ñek nɨŋlɨg gɨ, wak ne mab rek yɨnek ak komɨŋ lak nɨŋɨl dai tap magɨl kɨrop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pen pɨb paŋɨd amnak magɨl ak, bin bɨ tap gak okok abe, bin bɨ kɨjeki abaŋ ñagak okok abe, Jisas gek komɨŋ laŋ, agɨl, Jisas mɨdek sɨŋak dolak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taun sɨkol Kapaneam bin bɨ okok magɨlsek apɨl, karɨp kɨjoŋ wagɨn söŋ kɨd eyaŋ ar nɨŋ mɨdel nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","bin bɨ koŋai nep tap ke ke gak okok, Jisas gek, komɨŋ lak. Kɨjeki kɨyob ñɨlɨk abaŋ ñagak okok koŋai nep ag mɨs yokak. Pen kɨjeki kɨyob ñɨlɨk nɨb okok, Jisas nop bɨ an, nɨŋ tep gɨlak rek, Jisas kɨrop, “Mɨnɨm ma gɨm,” agɨl, ag mɨs yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mɨnek, Jisas kɨslɨm sek yɨb warɨkɨl, karɨp kɨnak ak kɨrɨg gɨl, taun nɨbak abe kɨrɨg gɨl, am mɨgan alap ke amɨl, Nap nop sobok gɨlɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pen bɨ ne Saimon, bɨ ne ognap eip, Jisas akal, agɨl, nop pɨyo nɨŋnɨg amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jisas nop pɨyo nɨŋ dam nɨŋɨl aglak, “Bin bɨ magɨlsek nep akal, agɨl, pɨyoebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nɨb agelak, Jisas agak, “Cɨn karɨp tɨrɨg tɨroŋ ognap sek ulep sɨŋaul amnɨn. Yad opin ak, bin bɨ karɨp lɨm mɨgan tɨgoŋ tɨgoŋ kɨrop mɨnɨm ag ñɨnɨm, agɨl, opin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nɨb agɨl, karɨp lɨm Galili nab okok gɨ taglɨg gɨ, am Juda mogɨm gep karɨp mɨgan okok amɨl, God Mɨnɨm ag ñɨlɨg gɨ, kɨjeki kɨyob ñɨlɨk bin bɨ kɨrop abaŋ ñagak okok ag söŋ yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Soi sapeb lak bɨ alap, Jisas mɨdek sɨŋak apɨl, kogɨm yɨmɨl, agak, “Nak soi yɨp ak komɨŋ laŋ, agenɨgan ak, komɨŋ lɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nɨb agek, Jisas nop yɨmɨg nɨŋɨl, ñɨnmagɨl parsek lɨl, bɨ nɨbak nop dɨ nɨŋɨl, agak, “Yau, gɨnɨgain. Komɨŋ lan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nop dɨ nɨŋek, dai soi sapeb lak ak ulek lɨl komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Pen Jisas bɨ nɨbak nop mɨnɨm kɨlɨs agɨl agak, “Kanɨb nab okok bin bɨ ognap kɨrop nɨŋɨl, Jisas yɨp gek komɨŋ lɨp, agɨl, ma agnɨmɨn. Yɨpɨd gɨl nep amɨl, bɨ God nop tap sobok gep ak nop mɨb goŋ nak ak yomɨl, agnɨmɨn, ‘Soi sapeb yad ak komɨŋ lɨp,’ agnɨmɨn. Nɨb agɨl, Mosɨs ned agak rek, tap ognap dam bɨ God nop tap sobok gep bɨ ak ñenɨmɨn, ne pak God nop sobok gɨ ñek me, bin bɨ okok, bɨ ak mɨñi komɨŋ lɨp, agɨl, nɨŋnɨgal,” agak. Jisas mɨnɨm nɨbak nep agɨl, bɨ ak ag yokek, amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisas nɨb agak ak pen bɨ nɨbak ne amɨl, bin bɨ okok abramek ag ñek amnak. Nɨg gek, Jisas taun okok mɨseŋ ajonɨmɨŋ rek ma lek, ne amɨl, bin bɨ koŋai ma mɨdelak nab okok nep mɨdek nɨŋlɨg gɨ, bin bɨ karɨp lɨm tɨgoŋ tɨgoŋ magɨlsek nop nɨŋnɨg apelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Ñɨn omal nep padɨkek nɨŋlɨg gɨ, Jisas kauyaŋ taun sɨkol Kapaneam apek, Jisas ap mɨdeb karɨp ne ak, agel, bin bɨ koŋai nep apɨl gel gel, karɨp mɨgan mɨnɨm ag ñek mɨgan ak tɨbɨk gɨl, kɨjoŋ wagɨn söŋ ar sɨŋ eyaŋ ak rek nep tɨbɨk gi yɨb gak. Pen Jisas kɨrop God Mɨnɨm ag ñɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jisas kɨrop ag ñɨ mɨdek nɨŋlɨg gɨ, bɨ aknɨb tɨgaup par alaŋ ak bɨ ognap eip, bɨ ñɨnmagɨl tob kalau gak alap yɨr ar lɨl, dapɨl Jisas mɨdek sɨŋak dolak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Apɨl nɨŋlak, bin bɨ tɨbɨk dɨl mɨdelak nɨŋɨl bɨ ñɨnmagɨl tob kalau gak ak nop dam karɨp ar alaŋ amɨl, karɨp nab sɨŋak tɨg mɨgan juɨl, yɨr ar kɨnek ak nag lɨl bɨ nɨbak sek yokel, am Jisas mɨdek eyaŋ yowak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pen kɨri Jisas gek komɨŋ lɨnɨgab, agɨl, gos nɨŋ dɨlak ak nɨŋɨl, Jisas agak, “Ñɨ yad. Tap si tap tɨmel gɨpan okok nɨŋɨl, kɨrɨg gebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nɨb agek, Juda lo mɨnɨm ag ñeb bɨ ognap bɨsɨg mɨdelak okok, gos kɨri okok nep nɨŋɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bɨ aul tari gɨnɨg, God nop ag julɨg gɨ, mɨnɨm tom ageb? Bin bɨ okok tap si tap tɨmel gel, bɨ alap acɨr kɨrop ak lɨg gɨ yoknɨmɨŋ rek ma lɨp; God nokɨm nep me nɨg gɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pen gos nɨŋlak nɨbak, dai Jisas ke nɨŋɨl agak, “Nɨbi tari gɨnɨg gos nɨbak rek nɨŋebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Bɨ ñɨnmagɨl tob kalau gɨp ak nop tari agen, nɨbep tep gɨnɨgab? Tap si tap tɨmel gɨpan ak nɨŋɨl kɨrɨg gebin, agen, nɨbep tep gɨnɨgab; aka, warɨkɨl mɨj bad nak pɨyak wɨnɨg dad amnoŋ, agen, nɨbep tep gɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pen yad gen, nɨbi nɨŋnɨgabɨm, Bɨ Ñɨ ne lɨm dai ar wagɨn aul onek ak, gos yad ke nɨŋɨl ma onek. God agek onek ak me, tap si tap tɨmel gɨpal ak nɨŋɨl kɨrɨg gɨnɨgain, agnɨgain ak, kɨrɨg gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nɨb agɨl, bɨ ñɨnmagɨl tob kalau gak ak nop agak, “Yad nep agebin, warɨkɨl, mɨj nak bad pɨyak wɨnɨg dɨl, karɨp amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jisas nɨb agek, bin bɨ nɨŋ mɨdel nɨŋlɨg gɨ, bɨ nɨbak warɨkɨl, mɨj bad ne ak wɨnɨg dɨl paŋdak. Nɨg gek nɨŋlɨg gɨ, bin bɨ okok magɨlsek wal yɨb agɨl, God yɨb ne ak agel ar amek nɨŋlɨg gɨ, aglak, “Ned tap nɨbak rek alap gel, cɨn ma nɨŋolɨgɨpɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas kauyaŋ amɨl, Ñɨg Cöb Galili gol sɨŋak tagek nɨŋlɨg gɨ, bin bɨ koŋai nep nɨŋɨl, mɨdek sɨŋak ap mogɨm gelak nɨŋlɨg gɨ, Jisas kɨrop God Mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas mɨnɨm ag ñɨ dai juɨl, kanɨb nab sɨŋak amlɨg gɨ nɨŋak, Alpias ñɨ ne Lipai, bɨ takɨs dep bɨ alap, wög golɨgɨp karɨp ñɨlɨk mɨgan ak bɨsɨg mɨdek. Jisas nop nɨŋɨl agak, “Apek, yad eip amnɨr,” agek, warɨkɨl Jisas eip amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas pen, bɨ ne okok eip Lipai karɨp ak amɨl, bɨsɨgɨl tap ñɨbel nɨŋlɨg gɨ, bɨ takɨs dep okok abe, bɨ tap si tap tɨmel gɨlak okok abe, Jisas eip ajelak rek, karɨp nɨbak amɨl jɨm ñɨl tap ñɨbelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bɨ lo mɨnɨm ag ñeb bɨ Perisi ognap, Jisas ne bɨ takɨs dep okok eip, bɨ tap si tap tɨmel gölɨgɨpal okok eip mɨdɨl tap ñɨbek ak nɨŋɨl, bɨ ne okok kɨrop aglak, “Jisas tari gɨnɨg bɨ takɨs debal okok eip, bɨ tap si tap tɨmel gebal okok eip bɨsɨg mɨdɨl tap ñɨbeb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Agelak, Jisas mɨnɨm nɨbak nɨŋɨl agak, “Bin bɨ komɨŋ mɨdebal okok, soi ñon gep bɨ nɨŋnɨg ma ambal; bin bɨ tap gɨp okok nep soi ñon gep bɨ nɨŋnɨg ambal. Nɨb ak rek, bin bɨ, gɨ tep gɨpɨn, ag gos nɨpal okok, kɨrop dɨnɨg ma opin; bin bɨ, tap si tap tɨmel gɨpɨn, ag gos nɨpal okok, kɨrop dɨnɨg opin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon bɨ ñɨg pak ñeb bɨ ne okok abe, Perisi kai bɨ kɨri okok abe, ñɨn ognap God nop sobok gɨlɨg gɨ nep mɨdojɨn, agɨl, tap ma ñɨbelɨgɨpal. Ñɨn alap kɨri nɨg gelak ak nɨŋɨl bin bɨ ognap apɨl Jisas nop aglak, “Jon bɨ ne okok abe, Perisi kai bɨ kɨri okok abe, ñɨn nokɨm nokɨm tap bɨl gɨpal. Pen bɨ nak okok, tari gɨnɨg nɨg ma gɨpal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Agelak, Jisas mɨnɨm sɨd tɨkɨl agak, “Bɨ bin dɨnɨg gɨnɨgab bɨ alap, nɨmɨd nɨmam ne okok eip mɨdɨl, tep gek nɨŋlɨg gɨ mɨdenɨgal ak me, tap magɨl ma kɨrɨg gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pen kɨsen, bin bɨ ognap apɨl, bɨ kɨri nɨbak nop dad amenɨgal ak, mapɨn gek, ñɨn nɨbak tap ma ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pen walɨj kɨsen nɨb bad alap dɨl, walɨj ajɨl gɨl pɨg gɨ rɨk gɨnɨgab tam ak ñag del, walɨj kɨsen ak kɨlɨs mɨdlɨg gɨ, walɨj ajɨl gɨnɨgab ak pɨg gɨ rɨkɨl, walɨj nɨbak tapɨn nep pɨg gɨ rɨk dek amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ñɨg wain ak, ak rek nep. Ñɨg wain komɨŋ ak dɨl, kaj meme wak ned nɨb mɨgan ak ma soŋ gɨ lɨpal. Pen tari: soŋ gɨ lɨl sɨmjen ñel, kaj meme wak ak bɨŋ agɨl, pɨg gɨ rɨkɨl soŋ gɨ am saknɨgab. Nɨb ak me, ñɨg wain komɨŋ ak, kaj meme wak komɨŋ mɨgan ak nep soŋ gɨ lep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kɨsen Juda God nop sobok gep ñɨn kɨri alap, Jisas bɨ ne okok eip wid wög nab sɨŋak padɨklɨg gɨ, bɨ ne okok wid magɨl ognap tɨklɨg gɨ amelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nɨg gel, Perisi bɨ okok nɨŋɨl, Jisas nop aglak, “Mɨñi God nop sobok gep ñɨn cɨn wög ma gep ak, tari gɨnɨg bɨ nak okok nɨg gɨl wög gɨl lo cɨn tɨb juebal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Agelak, Jisas agak, “Based Depid bɨrarɨk nep yuan lek gak kesɨm ñu kɨl tɨklak ak, nɨbi ma nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bɨrarɨk nep bɨ nak Abiata God nop tap sobok gep bɨ kɨb yɨb mɨdolɨgɨp ñɨn ak, Depid bɨ ne okok eip kɨrop yuan lek, God sobok gep karɨp ak amɨl, bred bin bɨ yokop okok ma ñɨbelɨgɨpal, bɨ God nop tap sobok gep bɨ okok nep ñɨbelɨgɨpal ak dɨl, bɨ ne okok kɨrop ñek, ñɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“God ne ñɨn yokop mɨdep mɨnɨm ak ned agɨl, kɨsen bin bɨ ma gɨ lak; bin bɨ ned gɨ lɨl, kɨri ake lɨl mɨd tep genɨmel, agɨl, ñɨn alap yokop mɨdenɨmel, agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nɨb ak, cɨn nɨpɨn, Bɨ Ñɨ ne God nop sobok gep ñɨn ak abe Bɨ Kɨb mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ñɨn alap pen, Jisas kauyaŋ Juda mogɨm gep karɨp ak amɨl nɨŋak, bɨ ñɨnmagɨl kalau gak alap karɨp ñɨlɨk mɨgan nɨbak ap mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bɨ Perisi mɨdelak okok ognap, Jisas tari rek gek, nop dam mɨnɨm kɨb agɨn, agɨl, bɨ nɨbak God nop sobok gep ñɨn aul gek komɨŋ lɨnɨgab aka mer agɨl, kapkap nɨŋ i sek lɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas pen bɨ ñɨnmagɨl kalau gak ak nop agak, “Warɨkɨl, sɨŋaul owan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Agek, ne mɨdek sɨŋak alaŋ apek, Jisas bin bɨ nɨb okok kɨrop agak, “God nop sobok gep ñɨn ak tari gep? Tep gep aka tɨmel gep? Bin bɨ okok kɨrop yɨmɨg nɨŋɨl gon, komɨŋ amnɨmel, aka gos tɨmel nɨŋɨl kɨrɨg gon, kɨmnɨmel?” agak. Agek, kɨri nop pen mɨnɨm alap ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas mɨnɨm ma dɨjɨn ag gos nɨŋlak bɨ nɨb okok, Jisas kɨrop nɨŋek, mɨlɨk yowak. Kɨri bɨ ñɨnmagɨl kɨlau gak nɨbak nop mɨdmagɨl ma lɨlak ak nɨŋɨl, Jisas kɨrop nɨŋ padɨklɨg gɨ sɨlɨkak. Nɨg gɨl, bɨ ñɨnmagɨl kalau gak ak nop agak, “Ñɨnmagɨl nak parsek lan!” agak. Agek, ñɨnmagɨl parsek lek nɨŋlɨg gɨ, komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nɨg gak nɨŋɨl, bɨ Perisi Juda mogɨm gep karɨp ak kɨrɨg gɨl, Herod bɨ ne okok mɨdelak sɨŋak amɨl, mɨnɨm ag nɨŋ ag nɨŋ gɨl, “Jisas nop titi gɨl dam ñag pak lɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas pen bɨ ne okok eip amɨl, Ñɨg Cöb Galili gol sɨŋak am mɨdelak. Pen bin bɨ Galili nɨb koŋai nep nop kɨsen gɨl olak. Ne tap tari tari golɨgɨp ar ak magɨlsek agel okok amek nɨŋlɨg gɨ, Judia bin bɨ ognap, Jerusalem bin bɨ ognap, karɨp lɨm Idumia bin bɨ ognap, ñɨg Jodan pɨs kɨd adaŋ bin bɨ ognap, taun kɨb omal Taia Saidon karɨp lɨm ulep sɨŋak nɨb bin bɨ ognap, bin bɨ koŋai yɨb Jisas nop nɨŋnɨg olak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jisas bin bɨ koŋai nep gek, komɨŋ lak ak me, nop dɨ nɨŋon komɨŋ lɨnɨmɨŋ, agɨl, bin bɨ koŋai yɨb nep apɨl, nop cɨrok cɨrok ñɨlɨg gɨ apel, yɨp pɨŋɨl kɨs gɨnɨgal, agɨl, bɨ ne okok kɨrop agek, ñɨg magöb alap dɨ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pen bin bɨ kɨjeki kɨyob ñɨlɨk tap tari abaŋ ñagak okok, Jisas nop nɨŋɨl, tob wagɨn ne sɨŋak lɨm eyaŋ yap pakɨl, mɨnɨm kɨb agɨl, “Nak God Ñɨ ne!” agölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisas pen kɨjeki kɨyob ñɨlɨk okok kɨrop mɨnɨm kɨlɨs agɨl agolɨgɨp, “Yad Bɨ an mɨdebin ak mɨseŋ ma agnɨmɨb mer,” agolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pen Jisas karɨp lɨm dɨm alap amɨl, bɨ ne dɨnɨg gak okok agek apelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bɨ aknɨb umɨgan alaŋ ag lɨl agak, “Nɨbi yad eip ajɨl, bɨ mɨnɨm yad dad ameb okok mɨdɨl, nɨbep ag yoken, amɨl bin bɨ okok kɨrop God Mɨnɨm tep ak ag ñɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yad nɨbep agebin ak me, kɨjeki kɨyob ñɨlɨk tap okok ak rek nep ag yoknɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jisas bɨ ne dak nɨb okok yɨb kɨri me, alap Saimon, kɨsen Jisas yɨb ne alap Pita agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Alap Jems, nɨmam alap Jon, nap kɨri mal yɨb ak Sebedi. Jisas kɨrop mal Boanerges agak. Yɨb nɨbak wagɨn ak “Tɨmɨk Bɨ”. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bɨ ne alap Edru; alap Pilip; alap Batolomyu; alap Matyu; alap Tomas; alap Jems, Alpias ñɨ ne; alap Padias; alap Saimon, nop Saimon Selot agölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Pen alap Judas Iskariot. Ne me kɨsen Jisas nop mɨmɨg gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pen Jisas karɨp alap amek, kauyaŋ bin bɨ koŋai nep ap mogɨm gɨ mɨdelak nɨŋɨl, bɨ ne okok eip tap ñɨŋnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nɨg gek, bin bɨ ognap Jisas saköl ñagɨp agel nɨŋlɨg gɨ, nonɨm nɨmam sɨkop nop poŋ dɨnɨg olak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pen lo mɨnɨm ag ñeb bɨ Jerusalem nɨb olak okok aglak, “Kɨjeki kɨyob ñɨlɨk tap okok nap kɨri Bielsebul Jisas nop abaŋ ñagɨp rek, kɨyob ñɨlɨk tap okok ag yokeb,” aglak. Mɨnɨm esek nɨbak agelak, ");
INSERT INTO kmh_m_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas ne nɨŋɨl, bin bɨ okok kɨrop agek apelak, mɨnɨm ar nɨbak mɨnɨm sɨd tɨkɨl agak, “Seten ne titi gɨl Seten nop ag yoknɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bin bɨ karɨp lɨm kiŋ nokɨm alap nep kod mɨdenɨgab bin bɨ okok, kɨri bin bɨ kɨri ke pen pen genɨgal ak, tɨgoŋ nɨbak asɨk ke ke lɨl ap yap paknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pen amɨlgon apɨlgon okok ak rek nep, kɨri bin bɨ kɨri ke pen pen genɨgal ak, kɨñɨŋ nɨbak asɨk ke ke lɨl ap yap paknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nɨb ak rek, Seten ne ke kɨjeki kɨyob ñɨlɨk tap ne okok ag yokenɨgab ak, asɨk ke ke lɨl pɨs nep yap paknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bɨ kal yɨb alap karɨp ne sɨŋak mɨdek nɨŋlɨg gɨ, bɨ alap apɨl, tap nop okok ma dad amnɨgab; ned bɨ kal nɨbak nop nag ñon gɨ lɨl me, amɨl tap karɨp ne okok mɨdeb ak dad amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ okok tap si tap tɨmel tari tari gɨnɨgal ak, God nɨŋɨl kɨrɨg gɨnɨgab. God nop ag juenɨgal ak, ne nɨŋɨl kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pen Kaun Sɨŋ ak nop ag juenɨgal ak, God nɨŋɨl ma kɨrɨg gɨnɨgab. Tap si tap tɨmel gɨnɨgab nɨbak per nep mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas nop, “Kɨjeki kɨyob ñɨlɨk tap okok nop abaŋ ñagɨp,” agelak ak me, nɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pen Jisas nonɨm nɨmam sɨkop apɨl, söŋ eyaŋ mɨdɨl, bɨ alap nop, “Nak amɨl Jisas nop agek owaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nɨb ak, bin bɨ karɨp ñɨlɨk mɨgan eyaŋ Jisas nop pɨŋɨl kɨs kɨs gɨ bɨsɨg gɨ mɨdelak okok nop aglak, “Nanɨm nanai namam sɨkop okok söŋ eyaŋ am mɨdɨl, ‘Nak owan e,’ agebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nɨb agelak, Jisas agak, “Ami yad, mam yad bɨ an?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nɨb agɨl, Jisas bin bɨ mɨdelak okok nɨŋ padɨklɨg gɨ agak, “Nɨbi me ami yad, mam yad mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bin bɨ God ageb rek gɨpal okok me, mam yad, ai yad, ami yad mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas Ñɨg Cöb Galili gol sɨŋak amɨl, bin bɨ okok kɨrop kauyaŋ mɨnɨm ag ñɨ mɨdek nɨŋlɨg gɨ, bin bɨ koŋai yɨb nep ap mogɨm gɨlak. Nɨg gelak, Jisas ñɨg magöb alap ar ak bɨsɨg gɨl, amɨl ñɨg nab ulep sɨŋak mɨdlɨg gɨ, bin bɨ ñɨg gol okok warɨk mɨdelak okok kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mɨnɨm nɨb okok mɨnɨm sɨd tɨkɨl ar ke ke koŋai nep ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Mɨnɨm ar alap mɨnɨm sɨd tɨkɨl agak, “Mɨnɨm agnɨg gebin aul nɨŋɨm! Bɨ alap wög dai ne ak wid yɨŋ tanaŋ, agɨl, dɨ yokek amek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","yɨŋ ognap kanɨb ameb ar sɨŋak yapek, yakɨr okok apɨl ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yɨŋ ognap kab ar lɨm sɨkol sɨkol lenɨgab sɨŋak yapɨl tannɨgab ak pen ");
INSERT INTO kmh_m_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kɨdɨl yɨpɨl ma amnɨgab rek, pɨb nɨŋɨl, mɨlep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yɨŋ ognap kɨlɨkasɨk mɨdenɨgab nab sɨŋak yapɨl, tannɨgab ak pen kɨlɨkasɨk okok sau gɨ pak ñɨbek, magɨl ma pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pen yɨŋ ognap lɨm tep ar ak yapɨl, tan tep gɨl, magɨl pɨl tep gɨnɨgab. Ognap magɨl ñɨn juɨl nokɨm alap adɨk gɨ dam wajrem alaŋ (30) rek pɨlnɨgab, ognap magɨl ñɨn juɨl omal nokɨm (60) rek pɨlnɨgab, ognap ñɨn juɨl aknɨb mamɨd alaŋ (100) rek pɨlnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas mɨnɨm nɨbak ag dai julɨg gɨ agak, “Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas mɨnɨm agek nɨŋlɨg gɨ, bin bɨ nɨŋ mɨdelak nɨb okok ke ke amnɨlak nɨŋlɨg gɨ, bɨ ne aknɨb umɨgan alaŋ okok abe, bin bɨ ne ognap sek abe, Jisas nop aglak, “Mɨnɨm sɨd tɨkɨl apan wagɨn ak tari?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Agelak agak, “God bin bɨ dɨl kod mɨdenɨgab mɨnɨm ak, God gek nɨbi nɨpɨm ak pen bin bɨ okok kɨrop sɨd tɨkɨl nep ag ñebin. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nɨg gen, bɨ God mɨnɨm agep alap God Mɨnɨm ñu kɨl tɨkɨl agak rek nep gɨnɨgab. Ne agak, ‘Udɨn nɨŋnɨgal ak pen tap ognap ma nɨŋnɨgal. Mɨnɨm nɨŋnɨgal ak pen mɨnɨm wagɨn ageb nɨb gɨl rek agɨl ma nɨŋnɨgal. Nɨŋ rep gɨplap, God nop ag nɨŋeblap, tap si tap tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨpkop,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas nɨb agɨl kɨrop agak, “Mɨnɨm sɨd tɨkɨl agesin nɨbak ma nepɨm ak, kɨsen mɨnɨm ognap sek sɨd tɨkɨl agenɨgain ak, titi gɨl nɨŋnɨgabɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wid yɨŋ bɨ dɨ yoknɨgab, agesin ak, God Mɨnɨm ne ak, agɨl, agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yɨŋ ognap kanɨb ameb ar sɨŋak yonɨgab, agesin ak, bin bɨ okok God Mɨnɨm nɨŋnɨgal ak pen magɨl nɨbak nep Seten apɨl mɨnɨm nɨbak ju dad amnɨgab, agɨl, agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Pen yɨŋ ognap kab ar lɨm sɨkol sɨkol lɨnɨgab sɨŋak yapɨl, tannɨgab ak pen kɨdɨl yɨpɨl amɨl kɨlɨs ma gek, pɨb nɨŋɨl mɨlep gɨnɨgab, agesin ak, bin bɨ okok God Mɨnɨm ak kɨsen won ak nɨŋel, tep gek nɨŋlɨg gɨ, mɨñ mɨñ gɨlɨg gɨ kasek dɨnɨgal ak pen yokop ulep magɨl ak mɨdel nɨŋlɨg gɨ, mɨker ognap apenɨgab aka bɨ okok kɨrop gɨ tɨmel genɨgal nɨŋɨl mɨnɨm nɨbak kasek nep kɨrɨg gɨnɨgal, agɨl, agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yɨŋ ognap kɨlɨkasɨk nab sɨŋak yapɨl tannɨgab, agesin ak, bin bɨ God Mɨnɨm nɨŋnɨgal ak pen ");
INSERT INTO kmh_m_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wög wari, karɨp mɨj kɨneb, kaj tap okok gos par nɨŋɨl, tu kɨbap, kɨlnok mani tap okok gos par nɨŋɨl, tap okok okok nep gos nɨŋnɨgal ak me, God Mɨnɨm ak sau gɨ pak ñɨbek, magɨl ma pɨlnɨgab, agɨl, agesin. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wid yɨŋ lɨm tep ar sɨŋak yonɨgab, agesin ak, bin bɨ God Mɨnɨm nɨŋɨl, nɨŋ denɨgal nɨŋɨl magɨl ñɨn juɨl nokɨm alap adɨk gɨ dam wajrem alaŋ (30), aka ñɨn juɨl omal nokɨm (60), aka ñɨn juɨl aknɨb mamɨd alaŋ (100) rek pɨlnɨgab; gos nɨbak nɨŋɨl agesin me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas pen kauyaŋ mɨnɨm alap sɨd tɨkɨl agak, “Bin bɨ okok sɨp dagɨl tin cög mɨgan okok aka abañ ar kɨnebal mok okpi okok ma we gɨnɨgal; ar epel dɨ lel melɨk gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nɨb aknɨb rek, tari tari mɨñi we gɨl mɨdeb ak, kɨsen mɨseŋ lek nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kɨrop mɨnɨm alap agak, “Mɨnɨm nɨŋebɨm ak, tɨk dam nɨŋ tep gɨnɨmɨb. Nɨbi bin bɨ okok kɨrop mɨnɨm kɨb agɨl, pen titi rek ñɨm agnɨgabɨm ak, God ne nɨŋɨl nɨbep ke ak rek nep mɨnɨm kɨb agɨl, pen ak rek nep aknɨb rek ñɨm, agnɨgab. Pen ne nɨbep pen ognap sek ar alaŋ abe ñɨm, agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bin bɨ tap ognap mɨdeb okok ognap sek dɨnɨgal; pen bin bɨ tap ognap ma mɨdeb okok, tap ognap sɨkol sɨkol mɨdeb ak sek dad amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas mɨnɨm alap mɨnɨm sɨd tɨkɨl agak, “God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm agnɨg gebin ar aul rek mɨdeb. Bɨ wög nap alap wid yɨŋ tanaŋ, agɨl, dam wög dai ne okok yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wid yɨŋ wög dai sɨŋak yokɨl, kɨn tagek nɨŋlɨg gɨ, marɨp gɨl, tannɨgab. Titi gɨl tanɨb, agɨl, ma nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lɨm ak ke gek, sɨlɨp ap ran jakɨl, tanɨl, magɨl pɨlɨl, pok gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pen wög dai nap nɨb ak pok gek nɨŋɨl, tɨk dam lep ñɨn ak owɨp, agɨl, tu gomej ak damɨl, tɨk donɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas nɨb agɨl agak, “God bin bɨ dɨl kod mɨdenɨgab ak, kesɨm tari rek dɨl agen nɨŋnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Me, mab mastad yɨŋ rek ak agnɨgain. Tap yɨŋ ognap kɨb yɨmebal okok sɨkol taneb, pen mab mastad yɨŋ ak sɨkol yɨb yɨmel, tan kɨb gɨl, tam kɨb ñagek, yakɨr okok apɨl sisi nɨb okok lɨ mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas bin bɨ okok kɨrop mɨnɨm sɨd tɨkep nɨb okok rek koŋai nep ag ñolɨgɨp; nɨg gɨl, mɨnɨm tep ak kɨrop ag ñolɨgɨp. Kɨri mɨnɨm nɨŋ tep gɨnɨgal mɨnɨm ak nep kɨrop ag ñolɨgɨp; mɨnɨm nɨŋ tep ma gɨnɨgal mɨnɨm ak ma ag ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ne kɨrop mɨnɨm sɨd tɨkɨl nep ag ñolɨgɨp. Kɨsen bɨ ne okok eip ke mɨdlɨg gɨ, mɨnɨm wagɨn magɨlsek ag ñɨ tep golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ñɨn nɨbak nep karɨp bɨr dɨgɨp won ak, Jisas bɨ ne okok kɨrop agak, “Ñɨg cöb pɨs kɨd adaŋ amnɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nɨb agek, bɨ ne okok bin bɨ koŋai nep ap mɨdelak okok kɨrop kɨrɨg gɨl, ñɨg magöb Jisas mɨdek mɨgan ak tanɨl, paŋdɨlak. Ñɨg magöb ognap sek eip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nab amel nɨŋlɨg gɨ, dai pɨnem asad apɨl, ñɨg si pag ñɨg magöb mɨgan ak amɨl pɨge ap yonɨg rek gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ne pen ñɨg magöb mɨgan dai oŋɨd ar, nabɨc yɨr lɨl kɨnek nɨŋlɨg gɨ, bɨ ne okok nop am kaun gɨl aglak, “Mɨnɨm ag ñeb bɨ, cɨn magɨlsek kɨmnɨg gobɨn ak nak nɨŋesan tap yokop rek lɨp ar?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Agelak, Jisas warɨkɨl, pɨnem asad dek ak abe, ñɨg si pag apek ak abe, kapkap mɨdei, agek, pɨnem asad dek ak kɨr gɨl, ñɨg si pag apek ak pɨs nep kɨr gɨl gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pen Jisas bɨ ne okok kɨrop agak, “Nɨbi tari gɨnɨg pɨrɨkebɨm? Nɨŋ dep magɨl nɨbi sɨkol yɨb mɨdeb nɨŋɨl pɨrɨkebɨm aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Agek, kɨri wal agɨl, pen ag nɨŋek pen ag nɨŋek gɨl aglak, “Bɨ nɨbaul bɨ an? Titi gɨl agosɨp, pɨnem asad dosɨp ak abe, ñɨg si pag aposɨp ak abe, mɨnɨm nop ak nɨŋɨl, agosɨp rek gɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas bɨ ne okok eip ñɨg magöb dɨl, Ñɨg Cöb Galili juɨl, karɨp lɨm Gerasa bin bɨ mɨdelak pɨs kɨd adaŋ ar amjakɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ñɨg magöb ak kɨrɨg gɨl, preŋɨd yapek nɨŋlɨg gɨ, won nɨbak nep, kɨjeki abaŋ ñag mɨdek bɨ alap, cɨp tɨgel mɨgan okok nɨb apɨl, Jisas mɨdek sɨŋak owak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Bɨ nɨbak cɨp tɨgel gɨlak kab mɨgan okok kɨn tagolɨgɨp. Nop per sen dɨl, ñɨn tob ne okok lɨ tɨbɨkelɨgɨpal ak pen sen okok gek, pɨg gɨ rɨkek, amolɨgɨp. Ne kɨlɨs yɨb golɨgɨp ak me, nop gel gos nɨŋnɨmɨŋ rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pɨb nab, kɨslɨm eyaŋ, cɨp tɨgel gɨlak kab mɨgan okok abe, dɨm gol okok abe, gaul par gɨlɨg gɨ, kab dɨl mɨb goŋ ne ke tɨbolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pen ñɨn nɨbak, ne Jisas nop yɨpɨd nɨŋɨl, pɨg gɨ rɨkɨd ag amɨl, Jisas mɨdek sɨŋak kogɨm yɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ne kogɨm yɨmek, Jisas kɨjeki bɨ nɨbak nop abaŋ ñag mɨdek ak nop agak, “Nak kɨjeki kɨyob ñɨlɨk, bɨ aul nop kɨrɨg gɨl söŋ amnoŋ!” agak. Jisas nɨb agek, ne pen agak, “Jisas, God kɨlɨs aknɨb ke yɨb Ñɨ ne. Yɨp tari gɨnɨg apeban? Mɨnɨm nɨŋɨd agnɨmɨn, ‘God nɨŋ mɨdeb rek, yad nep yur mab rek ma ñɨnɨgain,’ agnɨmɨn!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɨb agek, Jisas bɨ nɨbak nop agak, “Yɨb nak tari?” agak. Jisas nɨb agek, ne pen agak, “Yɨp kɨjeki koŋai nep abaŋ ñagɨp rek, yɨb yad ‘Koŋai Nep,’” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne Jisas nop, kɨjeki kɨyob ñɨlɨk okok mɨñ mab ke par okok ma ag yoknɨmɨn, agɨl, ag nɨŋlɨg gɨ nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pen magɨl nɨbak, kaj koŋai yɨb amɨl ñɨbelak pɨrbak nɨb okok. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nɨb ak, kɨjeki okok Jisas nop neb neb gɨl aglak, “Cɨnop agek, amɨl kaj oklaŋ kɨrop mɨjem sɨkɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nɨb agel, Jisas yau agek, kɨjeki okok bɨ nɨbak nop kɨrɨg gɨl, amɨl kaj okok kɨrop mɨjem sɨkel, magɨlsek tu tausan rek pɨg juɨl mɨdɨŋ eyaŋ amɨl, gɨ dam ñɨg cöb eyaŋ pakɨl, magɨlsek ñɨg ñɨbɨl kɨm saklak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pen bɨ kaj mɨkelak okok, gak nɨbak nɨŋɨl, kasek amɨl taun nɨbak abe, karɨp lɨm okok abe, mɨnɨm nɨbak ag ñel nɨŋlɨg gɨ, bin bɨ okok amɨl nɨŋɨn, agɨl, Jisas mɨdek sɨŋak olak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Apɨl nɨŋlak, bɨ ned kɨjeki koŋai nep abaŋ ñagak nɨbak, walɨj yɨmɨl, mɨd tep gɨl, bɨsɨg mɨdek. Nɨŋel, jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bin bɨ ned mɨdelak okok, bin bɨ kɨsen olak okok kɨrop, bɨ kɨjeki abaŋ ñag mɨdek bɨ ak nop Jisas tari tari gak ak ag ñɨlak. Pen kaj okok kɨrop tari tari gak ak abe ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pen bin bɨ nɨb okok, mɨnɨm aglak nɨbak nɨŋɨl, Jisas nop mɨnɨm neb neb gɨl aglak, “Karɨp lɨm cɨn aul kɨrɨg gɨl amnoŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Agelak, Jisas ñɨg magöb dɨl amnɨg gek, bɨ kɨjeki abaŋ ñagak Jisas gek komɨŋ lak bɨ ak nop neb neb gɨl agak, “Yad eip amnɨr aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Agek, Jisas bɨ ak nop mer agɨl, agak, “Karɨp nak amɨl, bin bɨ nak okok kɨrop, Bɨ Kɨb nep yɨmɨg yɨb nɨŋɨl, tari tari gɨp mɨnɨm ak magɨlsek ag ñɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Agek, bɨ nɨbak karɨp lɨm Dekapolis nab sɨŋak, taun okok gɨ taglɨg gɨ, Jisas nop tari tari gak mɨnɨm nɨbak magɨlsek bin bɨ okok kɨrop ag ñek, kɨri magɨlsek wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas pen ñɨg magöb dɨl, kauyaŋ adɨk gɨ amɨl, Ñɨg Cöb Galili pɨs kɨd adaŋ gol sɨŋak mɨdek nɨŋlɨg gɨ, bin bɨ koŋai nep apɨl ne mɨdek sɨŋak bɨm kɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bɨ alap yɨb ne Jairas. Ne Juda mogɨm gep karɨp alap kod mɨdolɨgɨp. Jairas Jisas nop nɨŋɨl, apɨl mɨdek sɨŋak kogɨm yɨmɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nop neb neb gɨlɨg gɨ agak, “Pai sɨkol mɨdmagɨl yad ak kɨmnɨg geb. Nak yad eip apɨl nop dɨ nɨŋek, warɨk komɨŋ amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Agek, Jisas Jairas eip amer nɨŋlɨg gɨ, bin bɨ koŋai nep amɨl, Jisas nop cɨrok cɨrok ñɨlɨg gɨ nab nab lɨlɨg gɨ dad amelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pen bin alap, ne bin kanɨb ajolɨgɨp mɨ aknɨb umɨgan alaŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bin nɨbak soi ñon gep bɨ okok kɨrop, yɨp gel komɨŋ laŋ, agɨl, mani ne magɨlsek bɨr tauak ak pen nop gel komɨŋ ma lɨl, tapɨn kɨb yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Pen ne Jisas golɨgɨp mɨnɨm ak agel nɨŋak rek, amɨl walɨj bad nop ak dɨ nɨŋen komɨŋ lɨnɨgab, agɨl, bin bɨ koŋai mɨdelak nab sɨŋak kɨd ken apɨl, walɨj nop ak dɨ nɨŋek, ");
INSERT INTO kmh_m_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","magɨl nɨbak nep lakañ yapolɨgɨp ak mɨlep gek, nab ne sɨŋ eyaŋ nɨŋak, nop tap gak ak komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pen Jisas dai ke nɨŋak, kɨlɨs ne ognap amnak nɨŋɨl, adɨk gɨl, bin bɨ koŋai mɨdelak okok kɨrop agak, “Walɨj yɨp ak bɨ an dɨ nɨŋɨp?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Agek, bɨ ne okok aglak, “Bin bɨ koŋai sɨkerek nep cɨrok marok ñebal ak, tari gɨnɨg yɨp bɨ an dɨ nɨŋɨp, agɨl, ageban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pen Jisas mɨnɨm kɨri aglak ak ma dɨl, yɨp bɨ an dɨ nɨŋɨp, agɨl, pɨyo nɨŋlɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pen bin nɨbak, nop tari tari gak ak nɨŋɨl, pɨrɨkɨl jep jep dɨlɨg gɨ apɨl, Jisas mɨdek tob wagɨn ne sɨŋak kogɨm yɨmɨl, nop komɨŋ lak mɨnɨm ak magɨlsek mɨseŋ ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas pen nop agak, “Pai yad. Jisas yɨp gek komɨŋ lɨnɨgab, agɨl, nɨŋ dɨpan rek, nep gen komɨŋ lɨp me ak. Nak amɨl kapkap mɨd rep gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas mɨnɨm nɨbak agek nɨŋlɨg gɨ, Jairas bɨ ne ognap, karɨp ne sɨŋak nɨb apɨl aglak, “Pai nak ak bɨr kɨmɨb; ag ñeb bɨ aul agek, tob yur ma onɨmɨŋ, adɨk gɨ amnɨmɨŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nɨb aglak ak pen Jisas mɨnɨm kɨrop ak ma dɨl, Jairas nop agak, “Ma pɨrɨknɨmɨn; gos kɨlɨs gɨ nɨŋnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jisas nɨb agɨl, bin bɨ okok eip ma amnɨgabɨn, agɨl, kɨrop nɨb okok ag lɨl, Pita ak, Jems ak, Jems nɨmam Jon ak, kɨrop yakam nep poŋ dɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kɨri Jairas karɨp ak amjakɨl Jisas nɨŋak, bin bɨ mɨnɨm pɨg agɨl, sɨl magɨl kɨb yɨb aglɨg gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Karɨp ñɨlɨk mɨgan eyaŋ amɨl agak, “Tari gɨnɨg mɨnɨm saköl agɨl, sɨl agebɨm? Pai ak ma kɨmɨb; yokop wɨsɨn kɨneb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nɨb agek, nop sɨk agel, kɨrop ag mɨs yokɨl, pai nonɨm nap ber ak dɨl, bɨ ne ñon ak dɨl, poŋ dɨl pai ak kɨm mɨdek karɨp ñɨlɨk mɨgan eyaŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amɨl, pai nɨbak ñɨnmagɨl kɨd nop ak dɨl, Arameik mɨnɨm lɨl agak, “Talita kom!” agak. Mɨnɨm agak nɨbak wagɨn me, “Pai sɨkol! Nep agebin, warɨkan!” ");
INSERT INTO kmh_m_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas pai nɨbak nop mɨnɨm agek, magɨl nɨbak nep warɨkɨl, ap ran ap yap gek nɨŋlɨg gɨ, bin bɨ okok nɨŋɨl wal yɨb aglak. Pai nɨbak mɨ ne aknɨb umɨgan alaŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bin bɨ mɨdelak okok wal agel nɨŋlɨg gɨ, Jisas mɨnɨm kɨlɨs agɨl agak, “Gɨpin nɨbak bin bɨ okok kɨrop mɨseŋ ma ag ñɨnɨmɨb,” agak. Nɨb agɨl kɨrop agak, “Pai ak nop tap magɨl ognap ñem ñɨŋaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas bɨ ne okok poŋ dɨl karɨp lɨm nɨbak kɨrɨg gɨl, taun ne ke Nasaret amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Am mɨdɨl, Juda God nop sobok gep ñɨn ak, mogɨm gep karɨp ak amɨl, bin bɨ koŋai nep ap mɨdelak okok kɨrop mɨnɨm ag ñek nɨŋlɨg gɨ, wal agɨl aglak, “Bɨ nɨbaul kapeda karɨp lɨm aul nɨb bɨ ak, Maria ñɨ ne alap. Nɨmam ne ak Jems, Josep, Judas, Saimon me. Nɨnai sɨkop ne okok eip mɨdobɨn aul. Pen mɨnɨm tep nɨbak akal nɨb nɨŋɨl ageb? Tap ma gep rek titi gɨl geb?” aglak. Nɨb agɨl, nop gos tɨmel nɨŋɨl kɨd ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pen Jisas kɨrop agak, “Bɨ God mɨnɨm agep okok, karɨp lɨm mɨgan ognap gɨ tagel, bɨ kɨb cɨn, agɨl, dɨnɨgal ak pen karɨp lɨm kɨri ke sɨŋak gɨ tagel, bin bɨ yakam kɨri ke okok mɨnɨm kɨrop ma dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nop ma nɨŋ dɨlak ak me, tap ma gep rek ognap gɨnɨmɨŋ rek ma lak; bin bɨ tap gak okok omal nep dɨ nɨŋek, komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pen Nasaret bin bɨ nop ma nɨŋ dɨlak ak nɨŋɨl Jisas ne wal yɨb agak. Jisas pen karɨp tɨrɨg tɨroŋ karɨp lɨm nɨb okok gɨ ajlɨg gɨ, bin bɨ okok kɨrop God Mɨnɨm ak ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ñɨn alap bɨ ne aknɨb umɨgan alaŋ okok sɨk agek apelak agak, “Bɨ omal ke, bɨ omal ke, karɨp lɨm okok ke ke amɨl, mɨnɨm tep yad ak ag ñɨnɨmɨb. Yad nɨbep ag yokebin rek, mɨnɨm ag ñɨ ajlɨg gɨ, kɨjeki kɨyob ñɨlɨk tap okok ag yoknɨg, ag söŋ yoknɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mɨnɨm alap pen agak, “Amnɨg gɨl ak, tap ñɨŋeb, wad, mani dad ma amnɨmɨb; yɨr dai ak nep dad amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tob tɨrɨp lɨl pen sior par nokɨm alap nep lɨl amnɨmɨb; sior ognap sek dad ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Karɨp alap amem nɨbep ag denɨmel, karɨp nɨbak nep mɨdɨl, wög gɨ dai juɨl, taun nɨbak kɨrɨg amnɨg gɨnɨmɨb ñɨn ak nep amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pen karɨp lɨm alap amjakem nɨbep ag dɨl, mɨnɨm nɨbep ak ma nɨŋenɨmel, karɨp lɨm nɨbak kɨrɨg amnɨg gɨnɨmɨb ñɨn ak, nɨŋlaŋ, agɨl, tob sɨlɨkɨl pakem yapek amnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas nɨb agek, bɨ ne aknɨb umɨgan alaŋ okok kɨri karɨp lɨm tɨgoŋ tɨgoŋ amɨl, bin bɨ okok kɨrop mɨnɨm ag ñɨlɨg gɨ aglak, “Tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨnɨmɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nɨb agɨl, kɨjeki kɨyob ñɨlɨk bin bɨ abaŋ ñag mɨdek okok koŋai nep ag söŋ yokɨl, bin bɨ tap gak okok koŋai nep wel lɨ ñel, komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pen Jisas gak rek mɨnɨm ak, karɨp lɨm tɨgoŋ tɨgoŋ okok amek, kiŋ Herod ak rek nep nɨŋak. Bin bɨ okok, mɨnɨm nɨbak ag amɨl apɨl gɨlɨg gɨ, ognap aglak, “Jon bɨ ñɨg pak ñeb kɨmek tɨgel gɨlak ak, kauyaŋ warɨkɨl me, apɨl tap ma gep rek nɨb okok geb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ognap aglak, “Bɨ nɨbak bɨ nak Ilaija,” aglak. Pen bɨ ognap aglak, “Bɨ God mɨnɨm agep bɨrarɨk nep mɨdelɨgɨpal rek bɨ alap apɨl mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pen kiŋ Herod ne nɨŋɨl agak, “Ak Jon bɨ ñɨg pak ñeb ned kɨŋam tɨb gɨ rɨk gɨnek ak nep warɨkɨl, apɨl nɨg geb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Pen tari: ned Herod, nɨmam Pilip bine Herodias nop dak. Dek, Jon “Gɨpan nɨbak, gɨ tɨmel gɨpan. Bɨ nuwi ne ma dɨnɨgab,” agak. Pen Jon nɨb agek, Herodias Jon nop nɨŋek mɨlɨk yapek agek, Herod bɨ ne okok ognap ag yokek, amɨl Jon nop mɨñ lɨlak. Bin Herodias, Jon nop titi gɨl ñag pak lɨnɨm, agɨl, gos ak nep nɨŋolɨgɨp ak pen ");
INSERT INTO kmh_m_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jon tap tɨmel alap ma golɨgɨp. Ne mɨnɨm tari tari agak ak, Herod nɨŋɨl mɨnɨm tep yɨpɨd gɨl nep ageb, agɨl, mɨñ mɨñ gɨl, Jon ne bɨ tep alap bɨ sɨŋ alap mɨdeb, agɨl, pɨrɨkɨl, Herodias nop gɨ tɨmel gɨnɨgab, agɨl, nop kod mɨd tep golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bin Herodias, Jon nop ñag pak lin, agɨl nɨŋ mɨd mɨd, mɨnek alap, Herod nonɨm nop tɨk dowak kos tɨkep ñɨn ak nep, tap kɨb ñɨŋnɨg, gapman bɨ kɨb okok, ami bɨ kɨb okok, karɨp lɨm Galili bɨ kɨb okok sɨk agek, tap kɨb ñɨŋnɨg olak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Apɨl tap ñɨbel nɨŋlɨg gɨ, Herodias pai ne ak karɨp mɨgan nɨbak apɨl kogɨm pagek, Herod abe, bɨ kɨb ne eip tap ñɨb mɨdelak okok abe nɨŋel, kɨrop tep gek, kiŋ Herod pai nɨbak nop agak, “Tap tari ag nɨŋenɨgan, nep ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pen mɨnɨm kɨlɨs, mɨnɨm nɨŋɨd yɨb nep agɨl agak, “Yad nep mɨnɨm nɨŋɨd yɨb agebin, nak tap tari ag nɨŋenɨgan ak nep ñɨnɨgain. Karɨp lɨm kɨb kod mɨdebin aul ag nɨŋenɨgan, nep dai ak agen, kod mɨdenɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nɨb agek, pai ak amɨl nonɨm Herodias nop, tap tari ak ag nɨŋnɨm, ag nɨŋek, nonɨm pen agak, “Jon bɨ ñɨg pak ñeb kɨmɨg cög magɨl ne ak agnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nonɨm nɨb agek, dai pai ne kasek kiŋ Herod mɨdek sɨŋak amɨl agak, “Mɨñi won aul nep, Jon bɨ ñɨg pak ñeb kɨmɨg cög magɨl ne ak dɨ kɨnaŋ cög mɨgan alap lɨl, yɨp dap ñan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nɨb agek, kiŋ Herod Jon nop gos nɨŋek, mapɨn yɨb gak. Pen ne bɨ kɨb okok nɨŋ mɨdel nɨŋlɨg gɨ, mɨnɨm kɨlɨs mɨnɨm nɨŋɨd yɨb pai ak nop agak ak nep gos nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","magɨl nɨbak nep ami bɨ ne alap, “Amɨl Jon nabɨc cög magɨl ak dowan,” agɨl ag yokek, amɨl Jon nop nabɨc cög magɨl ne ak tɨb gɨ rɨk gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","dɨ kɨnaŋ cög mɨgan alap lɨl, dapɨl pai nɨbak nop ñek, ne pen damɨl nonɨm nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pen Jon bɨ ne okok, Jon nop kɨŋam tɨb gɨ rɨk gɨlak mɨnɨm ak nɨŋɨl, kɨri am cɨp se damɨl, kab mɨgan sɨŋak tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas mɨnɨm dad ameb bɨ okok, kɨri tɨgoŋ tɨgoŋ wög gɨ taglɨg gɨ, adɨk gɨ apɨl, bin bɨ okok kɨrop mɨnɨm tari tari ag ñɨl, tap tari tari gɨlak okok, magɨlsek Jisas nop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pen bin bɨ koŋai yɨb nep amɨl apɨl gelak ak me, Jisas bɨ ne okok eip tap ñɨŋnɨmel rek ma lek, ne kɨrop agak, “Cɨn, bin bɨ ma mɨdebal nab sɨŋak amɨl, yokop mɨdojɨn, nɨbi magɨl alap ake lɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nɨb agɨl, bɨ ne okok eip ñɨg magöb dɨl, karɨp lɨm bin bɨ ma mɨdelɨgɨpal sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pen kɨri ñɨg magöb dad amel nɨŋlɨg gɨ, bin bɨ koŋai nep, Jisas bɨ ne okok eip tɨgoŋ ke alap amebal, agɨl, taun okok nɨb okok nɨb kasek pɨg gɨ rɨkɨd ag amɨl, ñɨg gol ar kanɨb par ak ned amɨl, Jisas bɨ ne okok eip amnɨg gelak sɨŋak ned am mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas bɨ ne okok eip ñɨg gol sɨŋak amjakɨl wös gɨl, ñɨg magöb kɨrɨg gɨl, bin bɨ koŋai mɨdelak okok kɨrop nɨŋɨl, gos ne ke gos nɨŋɨl nɨŋak, kɨri kaj sipsip bɨ kod mɨdep alap ma mɨdeb rek ak mɨdelak. Nɨbak nɨŋek, mapɨn gek, ne wagɨn gɨl kɨrop mɨnɨm ognap tapɨn ag ñɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pɨb bɨr paŋɨd amek nɨŋlɨg gɨ, bɨ ne okok apɨl nop aglak, “Pɨb bɨr paŋɨd amɨb. Sɨŋaul mɨñ mab nep nab sɨŋaul. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nɨb ak, bin bɨ sɨŋ aul ag yokek, kɨri amɨl karɨp tɨrɨg tɨroŋ karɨp lɨm yokop ulep sɨŋ aul amɨl, tap magɨl kɨri ke ognap tau ñɨŋlaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Agelak, Jisas agak, “Nɨbi ke kɨrop tap magɨl ognap ñɨnɨmɨb,” agak. Agek aglak, “Nɨb ageban ak, bɨ takɨn aknɨb jɨl oŋɨd wög gɨl mani dɨpal rek dɨl, tap magɨl tau dapɨl kɨrop ñɨn aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Agelak, Jisas agak, “Bred magɨl nɨbi titi gɨ rek mɨdeb? Am nɨŋɨm!” agak. Agek, am nɨŋɨl aglak, “Cɨn bred magɨl aknɨb mamɨd alaŋ, kɨbsal omal sek mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nɨb agelak, Jisas agak, “Bin bɨ sɨŋ aul agem, asɨk bɨlok ke ke lɨl, tap kas kɨkomɨŋ ar sɨŋ aul bɨsɨg mɨdel amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Agek, bin bɨ okok kɨrop agel, ognap ñɨn juɨl omal adɨk gɨ dam wajrem alaŋ (50) rek mogɨm bɨlok lɨl, ognap ñon bin bɨ ñɨn juɨl aknɨb mamɨd alaŋ (100) rek bɨlok lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pen Jisas ne bred magɨl aknɨb mamɨd alaŋ abe, kɨbsal omal abe dɨl, seb kab ar alaŋ sɨŋak nɨŋɨl, God nop, tep agɨl, bred ak dɨ tɨ paŋɨl, bɨ ne okok kɨrop ñek, kɨri pen bin bɨ okok kɨrop nonɨm lɨ ñɨlak. Kɨbsal omal ak, ak rek nep bɨ ne okok ñek, bin bɨ okok kɨrop nonɨm lɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ñelak, ñɨbel ñɨbel, kɨrop kogi gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bred kɨbsal dai dai ñɨb tɨrauñ gɨlak okok, Jisas bɨ ne okok wad dɨl yɨgel yɨgel, wad aknɨb umɨgan alaŋ ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tap ñɨŋlak ñɨn nɨbak, bɨ okok nep me, paip tausan amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pen magɨl nɨbak nep Jisas bɨ ne okok kɨrop agek, ñɨg magöb dɨl, Betsaida taun kɨd adaŋ amel nɨŋlɨg gɨ, Jisas sɨŋak mɨdɨl bin bɨ okok kɨrop ag yokek amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ag yokɨl, dɨm gol mak alap kɨlan gɨl amɨl, God nop sobok gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Kɨslɨm gɨnɨg gek magɨl ak, Jisas nep mɨdɨl nɨŋak, bɨ ne okok kɨri ñɨg magöb dɨl, ñɨg nab sɨŋak adaŋ amel nɨŋlɨg gɨ, yɨgen ak amelak pɨs ken apek, koslam ñɨg kas ar alaŋ parɨk yoklɨg gɨ amelak. Karɨp jɨn parɨkek won ak, Jisas ñɨg kas ar alaŋ bɨ ne mɨdelak sɨŋak amɨl, kɨrop tausak lɨl, amnɨg gek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","nop ñɨg kas ar alaŋ sɨŋak amek ak nɨŋɨl, ak cɨp kaunan alap, agɨl, jel gek pɨrɨkɨl sɨk gaul gɨlak. Dai Jisas kɨrop agak, “Gos par ma nɨŋnɨmɨb! Yad nep apebin! Ma pɨrɨknɨmɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Agɨl, ñɨg magöb mɨgan eyaŋ amek, yɨgen dek ak kɨr gak. Nɨg gek, Jisas ne titi gɨl nɨg gɨp, agɨl, gos par yɨb nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ne bred dɨl bin bɨ koŋai nep nonɨm lɨ ñak ak nɨŋlak ak pen ñɨn nɨbak Jisas nop nɨŋ dɨ tep ma gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pen ñɨg nab sɨŋak amɨl amɨl karɨp lɨm Genesaret amjakɨl, ñɨg magöb ak nag dɨ ñon gɨ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ñɨg magöb sɨŋak kɨrɨg amel nɨŋlɨg gɨ, bin bɨ nɨb okok Jisas owɨp, agel nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kasek karɨp lɨm tɨgoŋ tɨgoŋ kɨd kɨd amɨl, bin bɨ tap gak okok kɨrop dam Jisas am mɨdek sɨŋak dapelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ñɨn nɨb okok, Jisas karɨp tɨrɨg tɨroŋ okok aka taun okok aka karɨp lɨm yokop okok amjakek, bin bɨ tap gak okok kɨrop dap maker nab sɨŋak lɨl, Jisas nop neb neb gɨl aglak, “Nak mɨdek, bin bɨ tap gɨp okok, walɨj dai nep ak dɨ nɨŋel, kɨrop komɨŋ laŋ,” aglak. Jisas yau agek nɨŋlɨg gɨ, bin bɨ nop dɨ nɨŋlak okok kɨrop magɨlsek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bɨ Perisi ognap, bɨ lo mɨnɨm ag ñeb ognap, Jerusalem nɨb apɨl, Jisas mɨdek sɨŋak nɨŋ mɨdɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","kɨri nɨŋlak Jisas bɨ ne ognap, nɨpɨs nɨsed sɨkop asɨk mosɨk gɨ rep gɨl, ñɨnmagɨl ñɨg lɨ yokɨl nep tap ñɨbelɨgɨpal rek, ma gelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Perisi bɨ okok abe, Juda bin bɨ okok magɨlsek abe, nɨpɨs nɨsed sɨkop agelɨgɨpal rek nɨŋɨl, ñɨnmagɨl ñɨg lɨ yokɨl nep, tap ñɨbal. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maker nab sɨŋak am mɨdɨl, karɨp adɨk gɨ apɨl, ak rek nep ñɨg lɨ yokɨl nep, tap ñɨbal. Pen kap, tin cög, kapa, mɨj par kɨneb tap okok ak rek nep ñɨg lɨ yokɨl nep, tap ñɨbal. Tap nɨbak rek magɨlsek kɨl tep gɨpal.) ");
INSERT INTO kmh_m_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nɨb ak, Jisas bɨ ne okok tap yokop ñɨŋlak ak nɨŋɨl, bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb okok abe, Jisas nop aglak, “Bɨ nak okok tari gɨnɨg, apɨs based sɨkop aglak rek, ñɨnmagɨl kɨri ak ñɨg lɨ yokɨl mer, yokop nep tap ñɨbebal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Agelak, Jisas pen agak, “Nɨbi mɨnɨm tom agebɨm ak, Aisaia mɨnɨm nɨŋɨd yɨb agɨl, God Mɨnɨm ak ñu kɨl tɨkɨl agak, ‘Bin bɨ sɨŋ aul, God yɨb agon ar ameb apal ak pen yokop mɨnɨm nep apal; yɨp mɨdmagɨl ma lɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","God lo mɨnɨm ak ag ñobɨn, apal ak pen bin bɨ mɨnɨm kɨri ke apal mɨnɨm ak nep ag ñebal. Nɨb ak, yɨp sobok gɨl yɨb yad agel ar ma ameb. Yokop mɨnɨm nep agebal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ar nɨbak rek, nɨbi God mɨnɨm ag lak ak kɨrɨg gɨl, bin bɨ mɨnɨm kɨri ke apal ak dɨl, nap nased sɨkop agelɨgɨpal ar ak kɨsen gɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisas kɨrop kauyaŋ agɨl agak, “Nɨbi gos kɨd yɨk nɨŋɨl, God mɨnɨm ag lak ak dɨ ke okok yokɨl, gos magɨl nɨbi ke ak nep nɨŋ dɨl kɨsen gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosɨs God Mɨnɨm dai alap ñu kɨl tɨkɨl agak, ‘Nanɨm nap agnɨmir rek nɨŋ dɨl, kɨrop dɨ tep gɨnɨmɨb; pen ñɨ pai ognap nonɨm nap kɨrop mɨnɨm mɨlɨk kal yapek agenɨgal ak, nɨbi kɨrop ñag pak lem kɨmlaŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pen nɨbi mɨnɨm ar nɨbak yɨpɨd gɨl ma ag ñɨbɨm. Bɨ alap, nonɨm nap kɨrɨg gɨnɨgain, agnɨgab ak, kɨrop agnɨgab, ‘Ami bapi, yad tap tep ognap nɨrepe mal ñɨbnep ak pen mani nɨrep mal ñeb mani ak, mɨñi yad God nop ñɨnɨgain, apin ak me, mani nɨrep mal ñeb alap ma mɨdeb,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nɨg gel, nɨbi nɨŋɨl agnɨgabɨm, ‘Kɨri nɨg gɨpal ak, mɨnɨm ma mɨdeb,’ agnɨgabɨm. Nɨb agem, kɨri God Mɨnɨm ak kɨrɨg gɨl, tap tep ognap nonɨm nap kɨrop ma ñɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nɨb ak, gos magɨl nɨbi ke ak nep nɨŋɨl, kɨsen gɨl, bɨ kɨsen nɨb ognap sek ag ñem, kɨri pen ak rek nep bɨ kɨsen nɨb ognap ag ñel, ag ñɨ dam dapɨl gel nɨŋlɨg gɨ, God Mɨnɨm tap yokop rek dɨ ke okok yokpal. Pen nonɨm nap mɨnɨm agesin ak nep mer; nɨbi tap koŋai nep nɨg aknɨb rek nep gɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas nɨb agɨl, bin bɨ koŋai nep mɨdelak okok kɨrop agek, ne mɨdek wagɨn sɨŋak apelak agak, “Mɨnɨm agnɨg gebin aul nɨbi magɨlsek nɨŋɨl, mɨnɨm wagɨn tɨk nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nɨbi tap ñɨbem nab eyaŋ amnɨgab ak gac ma mɨdenɨgab; tap cɨbur mɨdmagɨl nab nɨbi adaŋ nɨb söŋ onɨgab ak nep gek, nɨbi acɨr sek mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, tɨmɨd lɨ nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas nɨb agɨl, bin bɨ okok kɨrop kɨrɨg gɨl, karɨp ñɨlɨk mɨgan eyaŋ amek, bɨ ne okok nop ag nɨŋlak, “Mɨnɨm sɨd tɨkɨl apan nɨbak, wagɨn ak tari?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Agelak, agak, “Bin bɨ okok kɨri ma nɨpal rek, nɨbi ak rek nep ma nɨpɨm ar? Tap asɨk mosɨk gɨpal okok, abramek ñɨbel, cɨbur nab eyaŋ amnɨgab, God nɨŋɨp gac ma mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pen tari: tap ñɨbal nɨb okok, mɨdmagɨl nab eyaŋ ma amnɨgab; cɨbur nab eyaŋ nep amek, cɨb sek kɨl yoknɨgal,” agak. Jisas mɨnɨm agak nɨbak, tap okok magɨlsek ñɨŋeb ak nep mɨdeb, asɨk mosɨk gep tap alap ma mɨdeb, agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pen Jisas nɨb agɨl agak, “Gos tɨmel nab kɨri eyaŋ nɨb onɨgab ak me, bin bɨ acɨr sek mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bin bɨ okok nab kɨrop eyaŋ gos tɨmel apek nɨŋlɨg gɨ, kɨri gɨ tɨmel gɨl, tap si dɨl, cɨp ñagɨl, bin si bɨ si gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tap okok cɨn rek laŋ, agɨl, bin bɨ ognap gos tɨmel nɨŋɨl, mɨnɨm esek agɨl, mɨnɨm tɨmel agɨl, tap okok cɨn rek ma lɨp, agek, mɨlɨk yapek, bin bɨ ag juɨl, yɨb kɨri ke dap ranɨl, abramek gɨl, tɨmel gep gos nokɨm nɨŋɨl gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tap tɨmel gɨpal nɨb okok gos ke okok nɨb ma owɨp. Gos tɨmel nab kɨri eyaŋ nɨb onɨgab ak me gek, bin bɨ God udɨn yɨrɨk ar ne sɨŋak gac sek mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas karɨp lɨm nɨbak kɨrɨg gɨl, amɨl karɨp lɨm taun kɨb Taia ulep nɨb sɨŋak amnak. Amɨl, bin bɨ okok yɨp mɨñi ma nɨŋnɨmel, agɨl, karɨp ñɨlɨk mɨgan alap amɨl we gɨl mɨdek ak pen we gɨl mɨdonɨmɨŋ rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bin alap, pai ne nop kɨjeki abaŋ ñagak ak me, Jisas owɨp, agel, ne amɨl Jisas mɨdek sɨŋak tob wagɨn nop sɨŋak kogɨm yɨmɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jisas nop neb neb gɨlɨg gɨ agak, “Pai yad kɨjeki abaŋ ñagɨp ak, ag söŋ yokek amnaŋ,” agak. Bin nɨbak ne Juda bin mer. Ne tɨk dolak karɨp lɨm Pönisia, bɨ karɨp lɨm Siria nɨb kod mɨdelɨgɨpal ak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pen nɨb agek, Jisas nop agak, “Ned ñɨ pai tap ñɨbel, kogi gɨnɨgab ak tep. Tap magɨl ñɨ pai ñeb ak dɨl, kain yoknɨgabɨn ak tep ma gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Agek, bin ak pen agak, “Bɨ Kɨb! Ak tep ageban ak pen ñɨ pai okok tap ñɨbel, dai dai okok abañ mok okok yapek, kain okok sek ñɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Agek, Jisas mɨnɨm nɨbak nɨŋɨl agak, “Nak nɨb apan ak, pai nak kɨjeki yɨpɨl sɨkɨl mɨdosɨp ak bɨr mɨs amɨb; nak amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jisas nɨb agek, bin nɨbak adɨk gɨ amɨl nɨŋak, kɨjeki kɨrɨg mɨs amek, pai ne mɨj ar sɨŋak kapkap kɨn mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas karɨp lɨm taun kɨb Taia ulep nɨb sɨŋak kɨrɨg gɨl, amɨl karɨp lɨm taun kɨb Saidon ulep nɨb sɨŋak pakɨl, karɨp lɨm Dekapolis nab okok amɨl, Ñɨg Cöb Galili amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Amjakek nɨŋlɨg gɨ, bin bɨ okok bɨ tɨmɨd pɨlɨŋ gak mɨnɨm ag tep ma golɨgɨp bɨ alap dapɨl, Jisas nop neb neb gɨl aglak, “Bɨ aul nop dɨ nɨŋek, komɨŋ laŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Agelak, Jisas bɨ nɨbak nop poŋ dɨl ke ke sɨŋak amɨl, ñɨnmagɨl par ne ak tɨmɨd mɨgan nop ak yokɨl, ñɨnmagɨl kɨñɨk ñagɨl, aleb nop ak dɨ nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","seb kab alaŋ nɨŋɨl, ake lɨlɨg gɨ, “Epata!” agak. Mɨnɨm yɨb agɨl, “Epata,” agak ak, mɨnɨm wagɨn ak “Yɨkan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nɨb agek nɨŋlɨg gɨ, bɨ nɨbak tɨmɨd mɨgan ak pag yɨkɨl, aleb ne auan amek nɨŋlɨg gɨ, dai mɨnɨm yɨpɨd gɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas pen bin bɨ okok kɨrop agak, “Mɨnɨm nɨbak bin bɨ ognap kɨrop ma ag ñɨnɨmɨb,” agak. Mɨnɨm nɨbak mɨnɨm kɨlɨs gɨl agak ak pen kɨri amɨl kɨlɨs gɨl bin bɨ koŋai nep ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mɨnɨm nɨbak ag ñelak bin bɨ nɨŋɨl wal yɨb agɨl aglak, “Jisas tap okok magɨlsek gosɨp tep yɨb gɨp. Ne bin bɨ tɨmɨd pɨlɨŋ gɨp okok gek, pag yɨkɨl, bin bɨ aleb mɨker gɨp okok gek mɨnɨm ag tep gɨpal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ñɨn nab nɨb sɨŋak nep, bin bɨ koŋai nep ap mɨdel, tap magɨl ma mɨdek, Jisas bɨ ne okok sɨk agek apelak agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yad bin bɨ sɨŋ aul kɨrop yɨmɨg nɨŋebin. Ñɨn omal nokɨm yad eip mɨdɨl, yokop mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kɨrop yuan nep ag yoken, ognap par okok nɨb opal rek, kanɨb nab okok amɨl, udɨn mɨmain dek, yap paknɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Agek, bɨ ne okok aglak, “Mɨñ mab nep nab nɨb sɨŋ aul, tap magɨl akal nɨb dɨl ñɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Agelak, Jisas agak, “Bred magɨl nɨbi titi gɨ rek mɨdeb?” agak. Agek aglak, “Aknɨb ar oŋɨd ak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nɨb agel, Jisas bin bɨ okok kɨrop agek, bɨsɨgel nɨŋlɨg gɨ, bred magɨl aknɨb ar oŋɨd nɨbak dɨl, God nop tep agɨl, tɨ paŋɨl, bɨ ne okok kɨrop ñek, kɨri pen dɨl, bin bɨ okok kɨrop nonɨm lɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kɨbsal sɨkol bad alap dɨ mɨdelak ak, ak rek nep dɨl, God nop tep agɨl, bɨ ne okok kɨrop ñek, dɨl nonɨm lɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ñel, ñɨbel ñɨbel kɨrop kogi gek, dai dai yepɨl yepɨl gɨlak okok, Jisas bɨ ne okok wad aknɨb ar oŋɨd ak yɨgel ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bɨ tap ñɨŋelak nɨb okok, po tausan rek. Jisas pen, bin bɨ nɨb okok kɨrop ag yokɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bɨ ne okok eip ñɨg magöb dɨl, karɨp lɨm Dalmanuta amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bɨ Perisi ognap Jisas nop neb neb gon, tari rek agnɨmɨŋ, agɨl, apɨl nop eip mɨnɨm ag amɨl apɨl gɨl aglak, “Tap ma gep rek alap seb kab ar alaŋ sɨŋak gek, cɨn nɨŋɨl, God nep ag yokek opan, agɨl nɨŋnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nɨb agel, Jisas ake lɨlɨg gɨ agak, “Bin bɨ mɨñi mɨdebal ñɨn aul, tari gɨnɨg apal, ‘Tap ma gep rek alap gek nɨŋɨn,’ apal? Yad nɨbep nɨŋɨd yɨb agebin, nɨbep tap ma gep rek alap gen, ma nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nɨb agɨl, kɨrop kɨrɨg gɨl, bɨ ne okok eip ñɨg magöb dɨl, ñɨg cöb pɨs kɨd adaŋ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pen bɨ ne okok saköl gɨl, bred koŋai mer, magɨl nokɨm alap nep dɨ ñɨg magöb ar ak lɨl, dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nab okok amlɨg gɨ, Jisas kɨrop agak, “Perisi yɨs kɨri ak abe, Herod yɨs ne ak abe, nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nɨb agek, bɨ ne okok kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “Bred magɨl ognap sek ma dopɨn rek ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas pen kɨri aglak nɨbak ke nɨŋɨl agak, “Tari gɨnɨg bred magɨl ma dopɨn, agɨl, agebɨm? Nɨbi mɨnɨm nɨŋɨl, wagɨn ak ma nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Udɨn lak ak ma nɨpɨm? Tɨmɨd lak ak ma nɨpɨm? Aka nɨŋɨl saköl gɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bɨ paip tausan mɨdelak ñɨn ak, bred magɨl aknɨb mamɨd alaŋ tɨ paŋ gɨ ñen, ñɨbɨl dai dai yepɨl yepɨl gɨlak okok, wad titi gɨ rek yɨpek?” agak. Agek aglak, “Wad aknɨb umɨgan alaŋ yɨgnok,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nɨb agelak agak, “Pen bɨ po tausan mɨdelak ñɨn ak, bred magɨl aknɨb ar oŋɨd ak tɨ paŋ gɨ ñen, ñɨbɨl dai dai yepɨl yepɨl gɨlak okok, wad titi gɨ rek yɨpek?” agak. Agek aglak, “Wad aknɨb ar oŋɨd ak yɨgnok,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Agelak agak, “Nɨbi mɨnɨm nɨŋɨl, wagɨn ak ma nɨpɨm ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pen kɨri Betsaida taun amjakel nɨŋlɨg gɨ, bin bɨ ognap bɨ udɨn kwoi gak alap dapɨl, Jisas nop neb neb gɨl aglak, “Nop dɨ nɨŋan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Agelak, Jisas bɨ udɨn kwoi nɨbak nop ñɨnmagɨl kɨd ak dɨl, poŋ dɨl karɨp tɨrɨg tɨroŋ gol sɨŋak amɨl, udɨn nop ak kɨñɨk ñagɨl, nop dɨ nɨŋɨl, agak, “Udɨn nak tap ognap nɨŋeban aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Agek agak, “Yau. Bin bɨ okok nɨŋebin ak, pen mab bɨd rek okok gɨ tagebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agek, Jisas kauyaŋ udɨn magɨl nop dɨ nɨŋek, dai komɨŋ lek tap okok magɨlsek nɨŋ tep yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pen Jisas bɨ nɨbak nop agak, “Kauyaŋ adɨk gɨ karɨp tɨrɨg tɨroŋ bin bɨ mɨdebal kɨdadaŋ ma amnɨmɨn; karɨp nak yɨpɨd gɨl amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas bɨ ne okok eip karɨp tɨrɨg tɨroŋ taun kɨb Sisaria Pilipai maŋ sɨŋak amnɨlak. Kanɨb nab sɨŋak amlɨg gɨ kɨrop agak, “Bin bɨ okok, yɨp bɨ an agɨl nɨŋebal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Agek aglak, “Bin bɨ ognap nep Jon bɨ ñɨg pak ñeb ak, agebal; ognap Ilaija, agebal; ognap bɨ God mɨnɨm agep ke nɨb alap, agebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Agelak, Jisas kɨrop agak, “Nɨbi ke pen yɨp bɨ an, agɨl, nɨpɨm?” agak. Agek, Pita agak, “Nak nep me Mesaia ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Agek, Jisas agak, “Nɨbi bin bɨ ognap kɨrop mɨnɨm nɨbak ma ag ñɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas pen wagɨn gɨl bɨ ne okok kɨrop mɨnɨm ag ñɨlɨg gɨ agak, “Bɨ Ñɨ ne yur kɨb yɨb dɨnɨgab. Bɨ kɨb mɨnɨm tɨg bɨlokep okok abe, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb okok abe, nop nɨŋel, mɨlɨk yapek, ñag pak lel, ne kɨmɨl, ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas mɨnɨm nɨbak mɨseŋ agek, Pita nɨŋek, tep ma gek, Jisas nop dam gol sɨŋak amɨl, nop ag gɨlɨg gɨ agak, “Mɨnɨm nɨbak rek ma agan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pen Jisas adɨk gɨl, bɨ ne okok kɨrop nɨŋɨl, Pita nop agak, “Seten! Nak kɨd yad okok amnoŋ! God gos ñeb rek ma ageban; bin bɨ okok gos nɨpal rek nep nɨŋɨl ageban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nɨb agɨl, bɨ ne okok abe, bin bɨ koŋai nep mɨdelak okok abe, sɨk agek, wagɨn sɨŋak apelak agak, “Bin bɨ an an yad eip mɨdenɨmel okok, tap tari lɨm dai ar wagɨn aul gos kɨb nɨpal ak kɨrɨg gɨl, mɨb goŋ kɨri ke gos kɨb nɨpal ak kɨrɨg gɨl, mab kros dɨ ka gɨl yɨp kɨsen gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bin bɨ, Jisas nop nɨŋ dɨ mɨdon, tep ma gɨnɨgab agɨl nɨŋnɨgal bin bɨ okok, pɨs nep ap yap paknɨgal. Pen bin bɨ, Jisas nop nɨŋ dɨl, mɨnɨm tep ne nɨŋ dɨ mɨdon, cɨnop gɨ tɨmel genɨgal ak, mɨnɨm ma mɨdeb agɨl gel amnɨgab bin bɨ okok, God gek per nep per nep komɨŋ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Pen bin bɨ, tap tep lɨm dai ar wagɨn aul koŋai nep dɨn, ag gos nɨpal bin bɨ okok, karɨp lɨm wagɨn aul mɨdeb tap okok magɨlsek dɨnɨgal ak pen komɨŋ per mɨdep won ak ma dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tap tep okok magɨlsek dam sɨkim gɨl, komɨŋ per mɨdep won ak taunɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Mɨñi ñɨn nɨbaul bin bɨ kɨri bin si bɨ si gɨl, tap si tap tɨmel gɨlɨg gɨ mɨdebal ak, bin bɨ an, yɨp abe mɨnɨm yad abe nabɨŋ gɨnɨgab, kɨsen Bɨ Ñɨ ne Nap melɨk tep aknɨb ke dɨl, ejol sɨŋ okok sek apenɨgab ñɨn ak, ne bɨ nɨbak nop ak rek nep nabɨŋ gek, ‘Nop ma nɨpin,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pen Jisas nɨb agɨl, mɨnɨm alap agak, “Yad nɨbep mɨnɨm nɨŋɨd agebin, nɨbi bin bɨ mɨdebɨm sɨŋ aul ognap komɨŋ mɨdem nɨŋlɨg gɨ, God bin bɨ dɨl kod mɨdenɨgab ñɨn ak, kɨlɨs kɨb sek apek nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pen kɨsen ñɨn aknɨb kagol oŋɨd ak mɨdɨl, Jisas ne Pita Jems Jon kɨrop yakam poŋ dɨl, karɨp lɨm bin bɨ ma mɨdelak dɨm yɨrɨk alaŋ alap kɨlan gɨ amnɨlak. Amɨl, Jisas nop nɨŋel nɨŋlɨg gɨ, mɨb goŋ ne ak ke yɨb lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Walɨj ne ak tɨd tep ke yɨb lɨl, mɨmelɨk yɨb gak. Pen bin bɨ lɨm dai ar wagɨn aul alap walɨj ognap ñɨg lɨl ulɨk malɨk gel, tɨd nɨbak rek lɨnɨmɨŋ rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pen magɨl nɨbak nɨŋlak, Ilaija eip Mosɨs eip apɨl Jisas eip mɨnɨm ag mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kɨri nɨŋɨl, Pita Jisas nop agak, “Mɨnɨm ag ñeb bɨ, cɨn tep yɨb apɨl sɨŋaul mɨdobɨn! Nɨb ak, cɨn karɨp badak bad omal nokɨm gɨn; nep alap, Mosɨs nop alap, Ilaija nop alap,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kɨri pɨrɨkelak rek me, Pita gos nɨŋ tep gɨl mer, abramek nɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pen kɨmi bad alap apɨl, kɨrop dɨ yɨpɨl yokek nɨŋlɨg gɨ, mɨnɨm alap kɨmi nab nɨb sɨŋak agak, “Alek Ñɨ mɨdmagɨl yad yɨb. Mɨnɨm agnɨgab rek nɨŋɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nɨb agek nɨŋlɨg gɨ, kɨri nɨŋ padɨklɨg gɨ nɨŋlak, bɨ nɨb omal ma mɨderek; Jisas nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pen kɨri dɨm alaŋ kɨrɨg gɨl, mak eyaŋ ap yaplɨg gɨ, Jisas agak, “Dɨm aul aposɨn tap gosɨp nɨŋesɨm ak, mɨñi bin bɨ ognap kɨrop ma ag ñɨnɨmɨb. Kɨsen Bɨ Ñɨ ne kɨmɨl warɨknɨgab ñɨn ak nep mɨseŋ ag ñɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Agek, bɨ ne okok bin bɨ ognap kɨrop ma ag ñɨlak; kɨri ke nep ag nɨŋ ag nɨŋ gɨl aglak, “Kɨmɨl warɨknɨgain, agɨp ak, mɨnɨm wagɨn ak tari?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nɨb agɨl, Jisas nop ag nɨŋɨl aglak, “Bɨ lo mɨnɨm ag ñeb bɨ okok tari gɨnɨg apal, ‘Ilaija ned onɨgab,’ apal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Agelak, Jisas agak, “Nɨŋɨd apal. God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Ilaija ned apɨl tap okok gɨ jɨn gɨnɨgab,’ aglak. Pen God Mɨnɨm ak mɨnɨm alap ñu kɨl tɨkɨl aglak, ‘Bin bɨ okok Bɨ Ñɨ ne nop kɨd ñɨl, nop yur kɨb ñɨnɨgal,’ aglak mɨnɨm ak, tari gɨnɨg nɨg aglak, agɨl nɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pen Ilaija aglak nɨbak, kɨsen onɨgab, agɨl, gos ak ma nɨŋnɨmɨb. Ne bɨr owak nɨŋɨl gos kɨri ke nɨŋɨl nop abramek gɨ tɨmel yɨb gɨlak. Nɨb ak, God Mɨnɨm ak ñu kɨl tɨkɨl, nop gɨnɨgal, aglak rek nep gɨlak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pen kɨri ban eyaŋ amɨl nɨŋlak, bɨ lo mɨnɨm ag ñeb bɨ ognap, Jisas bɨ ne aknɨb ajɨp okok eip pen pen ag mɨdel nɨŋlɨg gɨ, bin bɨ koŋai nep apɨl, kɨrop pɨŋɨl kos kos gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nɨg gɨ nɨŋ mɨdel nɨŋlɨg gɨ, Jisas apjakek, bin bɨ ap mɨdelak okok nop nɨŋɨl, wal agɨl, amɨl nop ag wasu dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas bɨ ne okok kɨrop ag nɨŋɨl agak, “Tari gɨnɨg pen agek pen agek gesɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nɨb agek nɨŋlɨg gɨ, bɨ alap bin bɨ mɨdelak nab nɨb sɨŋak agak, “Mɨnɨm ag ñeb bɨ. Ñɨ yad ak, kɨjeki abaŋ ñagek, mɨnɨm ma geb. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ñɨn ognap nop tapɨn gek, ap yap pakɨl, kɨñɨk kobkob kosɨb masɨb apɨl, meg sɨp yɨmɨl, ñɨnmagɨl tob mɨb goŋ yɨñ gɨl gɨp. Per nɨg gek gek me, dopin ak pen bɨ nak okok kɨrop agen, kɨjeki ak ag yok mer nɨŋɨl kɨrɨg gɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nɨb agek, Jisas kɨrop agak, “Nɨbi bin bɨ mɨñi mɨdebɨm aul God nop nɨŋ dɨ kɨlɨs ma gɨpɨm. Mɨnek akal nop nɨŋ dɨl, tap nɨb okok ke gɨnɨgabɨm? Mɨnɨm per agen nɨpɨm ak, titi gɨl mɨnɨm kɨl sek alap agen nɨŋnɨgabɨm? Ñɨ nɨbak dad mɨdebin aul dowɨm!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Agek, dam Jisas mɨdek wagɨn sɨŋak dapel, kɨjeki ñɨ nɨbak nop abaŋ ñagak ak, Jisas nop nɨŋɨl, ñɨ ak nop gek, ap yap pakɨl, adɨk madɨk gɨlɨg gɨ, kɨñɨk kobkob kosɨb masɨb apɨl yowak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nɨg gek, Jisas ñɨ nɨbak nap nop ag nɨŋɨl agak, “Tap nɨbak ñɨn akal rek gak?” agak. Agek agak, “Bɨrarɨk nep ñɨ sɨkol won ak nep gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kɨjeki nɨbak, nop per ñag pak lin, agɨl, mab yɨneb nab okok abe, ñɨg nab okok abe dɨ yokeb. Nɨb ak, cɨrop apɨl yɨmɨg nɨŋɨl, tap nɨbak ag yokep rek lonɨmɨŋ ak, ag yokan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Agek, Jisas agak, “Yɨp tari gɨnɨg, ‘Ag yokep rek lonɨmɨŋ ak, ag yokan,’ agɨl ageban? Ag nɨŋnɨgain rek gɨnɨgab, ag gos nɨŋnɨgan ak, ag nɨŋnɨgan ak rek gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Agek, ñɨ nap ak kasek nep agak, “Nep nɨŋ debin; nɨg gɨnɨgan, agɨl, gos ak nɨŋebin ak pen gos omal nɨŋnɨm rek lɨp ak, yɨp gos tep ñek nɨŋɨl yad pɨs nep nɨŋ dɨnɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pen bin bɨ koŋai nep, apɨl mal Jisas eip mɨdelak sɨŋak, pɨg gɨ rɨkɨd ag apelak nɨŋlɨg gɨ, Jisas kɨjeki ak nop agak, “Nak kɨjeki, bin bɨ gek tɨmɨd saköl ñagek mɨnɨm ma apal ak, nep agebin, ñɨ pɨyak nop kɨrɨg gɨl, pɨs nep amɨl, kɨsen kauyaŋ ma adɨk gɨ onɨmɨn!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Agek, kɨjeki nɨbak gaul kɨb gɨl, söŋ amnɨg gɨl, ñɨ ak nop gek, ap yap pakɨl, jep jep dɨ wös gek, bin bɨ koŋai nep aglak, “Bɨr kɨmɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nɨb aglak ak pen Jisas ñɨnmagɨl kɨd ne ak dɨl, nop dɨ warɨk ñek, warɨk komɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kɨsen Jisas karɨp ñɨlɨk mɨgan eyaŋ amɨl, bɨ ne okok eip kɨri nep mɨdlɨg gɨ, nop aglak, “Tari gɨnɨg cɨn kɨjeki nɨbak nop ag yok mer nɨpɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Agelak, Jisas agak, “Kɨjeki nɨbak rek yokop ma ag yoknɨgal; God nop sobok gel me, mɨs amnɨgal. Mer ak, mɨs ma amnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jisas bɨ ne okok poŋ dɨl, karɨp lɨm nɨbak kɨrɨg gɨl, karɨp lɨm Galili nab sɨŋak amlɨg gɨ, bɨ yad okok kɨrop mɨnɨm ag ñɨ tep gɨnɨm, agɨl, kapkap we gɨl mɨdlɨg gɨ, kɨrop ag ñolɨgɨp. Kɨrop ag ñɨl agak, “Bɨ Ñɨ ne nop mɨmɨg gɨl bɨ ognap kɨrop ñek, nop ñag pak lel, kɨmɨl, ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne nɨb agek nɨŋlɨg gɨ, mɨnɨm wagɨn nɨbak tari, agɨl, nop ag nɨplap ak pen pɨrɨkɨl, ma ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Pen kanɨb nab sɨŋak amlɨg gɨ, Jisas bɨ ne okok, “Yad nep bɨ kɨb, nak bɨ kɨb mer,” aglɨg gɨ, pen pen agel amnak. Amɨl Kapaneam amjakɨl, karɨp mɨgan eyaŋ ak amɨl, Jisas kɨrop ag nɨŋɨl, agak, “Kanɨb nab sɨŋak aplɨg gɨ, mɨnɨm tari agem aposɨp?” agak. Agek, bɨ ne okok mɨnɨm nɨbak ag nɨŋlɨg gɨ apelak ak nɨŋɨl, nabɨŋ gek, pen ma ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma ag ñelak, Jisas am bɨsɨg gɨl, bɨ ne aknɨb umɨgan alaŋ okok kɨrop agek apelak agak, “Bin bɨ pobɨŋ mɨdenɨmel okok, bin bɨ yokop wög gɨ ñɨbal rek mɨdɨl, bin bɨ ognap kɨrop magɨlsek wög gɨ ñɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nɨb agɨl, ñɨ pai sɨkol alap dapɨl mɨdelak nab sɨŋak lɨl, kaig gɨlɨg gɨ, agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bin bɨ yɨp nɨŋ dɨl, ñɨ pai sɨkol aul rek nokɨm alap dɨ tep gɨnɨgal ak, ñɨ ak nop nep mer, yɨp abe dɨnɨgal. Pen yɨp dɨnɨgal ak, yɨp nep mer, Bapi yɨp ag yokek onek ak nop abe dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pen Jon Jisas nop agak, “Mɨnɨm ag ñeb bɨ. Bɨ alap yɨb nep agɨl, kɨjeki kɨyob ñɨlɨk ag söŋ ag yokek, cɨn nɨŋɨl nop agnok, ‘Nak bɨ cɨn eip jɨm ñɨl ma tageban ak, nɨg ma gɨnɨmɨn,’ agnok,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Agek, Jisas nop pen agak, “Nop tari gɨnɨg mer apek? Bin bɨ yɨp gos nɨŋɨl, yɨb yad agɨl, tap ma gep rek ognap gɨnɨgal okok, kɨsen adɨk gɨl yɨp mɨnɨm tɨmel ma agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bin bɨ kaual maual cɨn ma gɨnɨgal okok, kɨri bin bɨ nɨŋeb cɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pen nɨŋɨm! Bin bɨ an an, nɨbep Jisas bɨ ne, agɨl, ñɨg mɨl ñel ñɨŋnɨgabɨm ak, God kɨrop dɨ tep gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pen bin bɨ ognap apɨl, ñɨ pai yɨp nɨŋ debal okok, kɨrop tap si tap tɨmel ar ak gɨ yomel, kɨri gos yɨp ak saköl gɨl, tap si tap tɨmel gɨnɨgal. Bin bɨ nɨg gɨnɨg genɨgal ak, ned kab kɨb alap kɨŋam ak nag dɨ lɨ tɨbɨkɨl, dam ñɨg solwara nab sɨŋak yokplap ak tep. Pen komɨŋ mɨdɨl, nɨg gɨ tɨmel gɨnɨgal ak, yur kɨb yɨb dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jisas nɨb agɨl agak, “Ñɨnmagɨl alap gek, nɨbi tap si tap tɨmel gɨnɨg gebɨm ak, ñɨnmagɨl pɨs kɨd nɨb ak tɨb gɨ rɨk gɨ yokem, pɨs kɨd ak nep mɨdonɨmɨŋ. Nɨg gɨl, tap si tap tɨmel nɨbak ma gɨnɨgabɨm rek, komɨŋ amnɨgabɨm. Pen ñɨnmagɨl omalgɨl mɨdek, gɨ tɨmel gɨl, karɨp lɨm Hel, mab per nep yɨn mɨdeb sɨŋak amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Karɨp lɨm nɨbak, ‘kɨrop kɨsoi per nep lɨ mɨdlɨg gɨ, mab yɨn nep mɨdenɨgab.’ ");
INSERT INTO kmh_m_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Tob kɨd ak, ak rek nep. Tob kɨd alap gek, nɨbi tap si tap tɨmel gɨnɨg gebɨm ak, tob kɨd pɨs nɨbak tɨb gɨ rɨk gɨ yokem, pɨs kɨd ak nep mɨdonɨmɨŋ. Nɨg gɨl, tap si tap tɨmel nɨbak ma gɨnɨgabɨm rek, komɨŋ amnɨgabɨm. Pen tob omalgɨl mɨdek, gɨ tɨmel gem, nɨbep karɨp lɨm Hel, mab ke yɨneb ak yokek, yur kɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Karɨp lɨm nɨbak, ‘kɨrop kɨsoi per nep lɨ mɨdlɨg gɨ, mab yɨn nep mɨdenɨgab.’ ");
INSERT INTO kmh_m_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Udɨn magɨl ak, ak rek nep. Udɨn magɨl alap gek, nɨbi tap si tap tɨmel gɨnɨg gebɨm ak, udɨn magɨl pɨs nɨb kɨd ak tɨg gɨlɨg gɨ yokem, pɨs kɨd ak nep mɨdonɨmɨŋ. Nɨg gɨl, tap si tap tɨmel nɨbak ma gɨnɨgabɨm rek, God karɨp lɨm ne sɨŋak amnɨgabɨm. Pen udɨn magɨl omalgɨl mɨdek, gɨ tɨmel gem, nɨbep karɨp lɨm Hel, mab ke yɨneb ak yokek, yur kɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Karɨp lɨm nɨbak, ‘kɨrop kɨsoi per nep lɨ mɨdlɨg gɨ, mab yɨn nep mɨdenɨgab.’ ");
INSERT INTO kmh_m_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Gam wak nawöj mab dagɨlel yɨn dek tep lɨnɨgab ak rek, God ne bin bɨ magɨlsek kɨrop nɨg aknɨb rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Dek sol tap dek kal tep yɨb ak pen dek kal ne ak amek, titi gɨl gem, kauyaŋ dek kal gɨnɨgab? Nɨb ak, nɨbi bin bɨ dek kal rek mɨdɨl, bin bɨ ognap mɨdmagɨl lɨl eip kapkap mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas Kapaneam kɨrɨg gɨl, karɨp lɨm Judia nab okok amɨl, am ñɨg Jodan juɨl, pɨs kɨd adaŋ amnak. Bin bɨ okok nɨŋɨl, ap mogɨm gelak nɨŋɨl ne per golɨgɨp rek kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɨ Perisi ognap, Jisas tari rek agnɨgab, agɨl, apɨl, nop ag nɨŋɨl aglak, “Lo mɨnɨm tari rek mɨdeb? Bɨ okok bin dɨl, ag yoknɨg, ag yoknɨgal aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Agelak, Jisas pen agak, “Mosɨs God Mɨnɨm ñu kɨl tɨkɨl, nɨbep mɨnɨm tari agak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Agek aglak, “Mosɨs agak, ‘Bin ag yoknɨg, “Nep ag yokebin,” agɨl, mɨj bad alap ñu kɨl tɨkɨl nop ñɨl, ag yoknɨmɨŋ,’ agak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Agelak, Jisas agak, “Nɨŋɨd agebɨm ak pen wös rek God ne bɨ nɨg gɨnɨgal agɨl ma gos nɨŋak. Mosɨs nɨbep God mɨnɨm ag ñek, nɨbi kasek ma dɨpɨm ak me, ne lo mɨnɨm nɨbak ñu kɨl tɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pen God karɨp lɨm bɨrarɨk ped okok gɨ lak ñɨn ak, bɨ gɨ lɨl, bin gɨ lɨl, gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ar nɨbak me, bɨ okok nonɨm nap sɨkop eip mɨdɨl, amɨl bin dɨl, kɨrop kɨrɨg gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kɨri ber mal jɨm ñɨl kɨner nɨŋlɨg gɨ, mɨb goŋ nokɨm lɨnɨgab. Kɨsen ke ke mer, jɨm ñɨl nep mɨdenɨgair. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God agek, bɨ bin dɨl mɨb goŋ par nokɨm lɨnɨgab nɨbak, bɨ ognap amɨl kɨrop ag pak asɨk ke ke ma lɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nɨb agɨl, bɨ ne okok eip kauyaŋ karɨp ñɨlɨk mɨgan eyaŋ amɨl, Jisas nop mɨnɨm ar nɨbak kauyaŋ ag nɨŋelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas agak, “Bɨ alap bin dɨl, ag yokɨl, amɨl bin kɨsen nɨb alap dɨnɨgab ak, God udɨn yɨrɨk ne sɨŋak ne bin si dep bɨ. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bin ak, ak rek nep, bɨ dɨl, kɨrɨg gɨl, amɨl bɨ kɨsen nɨb dɨnɨgab ak, ne bɨ si dep bin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bin bɨ ognap, Jisas ñɨ pai cɨn okok dɨ nɨŋaŋ, agɨl, dapelak, pen bɨ ne okok kɨrop ag gelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nɨb agelak, Jisas nɨŋek, mɨlɨk yapek, agak, “Ñɨ pai sɨkol okok kɨrɨg gem, yɨp olaŋ. God karɨp lɨm ak ñɨ pai sɨkol nɨb okok rek mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ okok, ñɨ pai sɨkol okok God karɨp lɨm ar alaŋ mɨnɨm ak nɨŋ dɨpal rek ma nɨŋ dɨnɨgal ak, God karɨp lɨm ne sɨŋak ma amnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nɨb agɨl, ñɨ pai sɨkol okok kɨrop dɨ kaig gɨl, ñɨnmagɨl ne nabɨc kɨrop ar alaŋ lɨl agak, “God nɨbep kod mɨdonɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pen Jisas amek nɨŋlɨg gɨ, bɨ alap pɨg gɨ rɨkɨd ag apɨl, Jisas mɨdek wagɨn sɨŋak kogɨm yɨmɨl, agak, “Mɨnɨm ag ñeb bɨ tep! Yad tari gɨl per mɨdep ak dɨnɨgain?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Agek, Jisas agak, “Yɨp tari gɨnɨg, ‘Bɨ tep,’ ageban? Bin bɨ alap tep ma mɨdebal; God nokɨm me tep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pen nak God lo mɨnɨm ak nɨpan: ‘Cɨp ma ñagnɨmɨb; bin si bɨ si ma gɨnɨmɨb; tap si ma dɨnɨmɨb; mɨnɨm kɨb agɨl tom ma agnɨmɨb; mɨnɨm tom agɨl bin bɨ ognap tap kɨrop okok ma pɨlɨ gɨ dɨnɨmɨb; nanɨm nap agnɨmir ar ak (rek nep) nɨŋɨl, kɨsen gɨnɨmɨb,’” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jisas nɨb agek, bɨ nɨbak Jisas nop agak, “Mɨnɨm ag ñeb bɨ. Yad kapaŋ apɨc nep mɨdɨl, lo mɨnɨm nɨb okok magɨlsek nɨŋlɨg gɨ mɨdebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Agek, Jisas nop nɨŋɨl, mɨdmagɨl lɨl, agak, “Nak tap nokɨm alap nep ma gɨpan. Nak amɨl, tap nak tari tari mɨdeb okok magɨlsek sɨkim gɨl, mani dɨl, bin bɨ tap ma mɨdeb okok kɨrop ñɨnɨmɨn. Nɨg gɨl me, tap tep nak ak mɨdenɨgab God karɨp lɨm seb kab ar alaŋ sɨŋak. Apin rek gɨl, apɨl, yad eip tagor,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nɨb agek, bɨ nɨbak tap ne koŋai mɨdek rek, cɨb gek, gos par yɨb lɨlɨg gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas bɨ ne okok kɨrop nɨŋ padɨklɨg gɨ agak, “Bin bɨ tap koŋai mɨdenɨgab okok koslam yɨb God bin bɨ ne mɨdel, kɨrop dɨl karɨp ne sɨŋak kod mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nɨb agek, bɨ ne okok mɨnɨm nɨbak nɨŋɨl, gos par nep nɨŋel nɨŋlɨg gɨ, Jisas kɨrop kauyaŋ agak, “Ñɨ pai yad sɨŋ aul, mɨnɨm agebin aul nɨŋɨm. God karɨp lɨm ak koslam ameb rek mɨdeb! ");
INSERT INTO kmh_m_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kaj kamel okok ñu mauöl nag yokpal mɨgan ak amnɨg, amnɨgal ak pen bin bɨ kɨlnok kɨbap mani tap okok koŋai mɨdeb okok, God karɨp lɨm ne sɨŋak koslam yɨb amnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jisas nɨb agek, bɨ ne okok wal yɨb agɨl, pen ag nɨŋek pen ag nɨŋek gɨl aglak, “Nɨb ak, bɨ an rek komɨŋ per mɨdep won ak dɨnɨmɨŋ?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Agelak, Jisas kɨrop nɨŋlɨg gɨ agak, “Bin bɨ okok kɨri ke gɨnɨmel rek ma lɨp; God nep me tari tari gɨnɨg, gɨnɨmɨŋ rek nep mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pen Pita Jisas nop agak, “Nɨŋan! Cɨn nak eip taglɨg gɨ, tap cɨn okok magɨlsek kɨrɨg gɨpɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Agek, Jisas agak, “Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ yɨp gos nɨŋɨl, mɨnɨm tep yad wög ak gɨnɨg, karɨp lɨm kɨri kɨrɨg gɨl aka, nɨnai nɨmam kɨri okok kɨrɨg gɨl aka, nonɨm kɨri okok kɨrɨg gɨl aka, ñɨ pai kɨri okok kɨrɨg gɨl aka, wög dai kɨri okok kɨrɨg gɨl, wög yɨp genɨgal ak, ");
INSERT INTO kmh_m_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","God kɨrop dɨ rep gɨnɨgab. Kɨrop kod mɨdek, lɨm dai ar wagɨn aul mɨdenɨgal ñɨn ak, karɨp, nɨnai nɨmam, nonɨm, ñɨ pai, wög dai kɨri koŋai yɨb mɨdenɨgab. Pen ñɨn ognap bin bɨ ognap okok, kɨri bin bɨ yad eip mɨdebal ak nɨŋɨl, kɨrop gɨ tɨmel gɨnɨgal. Kɨsen pen God kɨrop dam karɨp lɨm ne sɨŋak dad amek, ne eip per nep mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pen bin bɨ mɨñi ned amebal okok, kɨsen koŋai nep kɨd ken yɨb okok mɨdenɨgal. Pen bin bɨ mɨñi kɨd ken yɨb okok mɨdebal okok, kɨsen koŋai nep ned am mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pen kɨri Jerusalem amlɨg gɨ, Jisas ned gak; bɨ ne okok kɨsen gɨl, gos par par nɨŋlɨg gɨ amelak nɨŋlɨg gɨ, bin bɨ kɨsen apelak okok nɨŋɨl pɨrɨklak. Jisas pen bɨ ne aknɨb umɨgan alaŋ okok kɨrop nep poŋ dɨl, gol sɨŋak amɨl, tap tari nop gɨnɨg gak ak kauyaŋ kɨrop ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jisas agak, “Cɨn Jerusalem amon nɨŋlɨg gɨ, bɨ alap Bɨ Ñɨ ne nop kain gɨ dam, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, ñɨnmagɨl kɨrop ñek, nop mɨnɨm kɨb agɨl, ‘Bɨ nɨbaul nop ñag pak lep,’ agɨl, dɨ bɨ Juda mer okok kɨrop ñɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ñel, nop ag juɨl, kɨñɨk ñagɨl, nag dɨ pakɨl, dam pɨs nep ñag pak lel kɨmnɨgab. Pen ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi ñɨ ne omal, Jems eip Jon eip apɨl Jisas nop agrek, “Mɨnɨm ag ñeb bɨ, cɨr mal nep mɨnɨm alap ag nɨŋor, nak yau agɨl gɨnɨgan ak tep,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nɨb agerek, Jisas kɨrop agak, “Nɨri yɨp ag nɨŋnɨg gebir nɨbak, yad nɨrep tari gɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Agek agrek, “Kɨsen nak melɨk tep ke sek mɨdɨl, karɨp lɨm magɨlsek kiŋ rek kod mɨdenɨgan ñɨn ak, cɨrop mal, bɨ alap dɨ ñɨnmagɨl yɨpɨd pɨs kɨd nak ar lɨl, bɨ alap dɨ ñɨnmagɨl aŋɨdken pɨs kɨd nak ar lek, bɨsɨg mɨdojɨr,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nɨb ager, Jisas agak, “Nɨri mal nɨŋ rep gɨl ma agebir. Ñɨg sɨlek yad ñɨŋnɨgain ak nɨri mal ak rek nep ñɨŋnɨgair? Yad ñɨg paknɨgain ak, nɨri mal ak rek nep paknɨgair?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Agek, “Yau, nɨg gɨnɨgabɨr,” agrek. Agerek, Jisas agak, “Nɨŋɨd agebir. Ñɨg yad ñɨŋnɨgain ak, nɨri mal ak rek nep ñɨŋnɨgair; ñɨg paknɨgain ak, nɨri mal ak rek nep paknɨgair ak pen ");
INSERT INTO kmh_m_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ñɨnmagɨl yɨpɨd ken pɨs kɨd yad bɨ an mɨdenɨgab, ñɨnmagɨl aŋɨdken pɨs kɨd yad bɨ an mɨdenɨgab ak yad ma agnɨgain; ak Bɨñen tap ne; ne ke nɨŋɨp rek gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pen Jisas bɨ ne aknɨb wajrem alaŋ mɨnɨm nɨbak nɨŋel, kɨrop mɨlɨk yapek, Jems Jon bɨ omal kɨrop ag gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nɨg gel, Jisas kɨrop magɨlsek agek apelak agak, “Nɨbi nɨpɨm, Juda bin bɨ mer okok, kiŋ kɨri kɨlɨs gɨl kod mɨdebal; bɨ kɨb kɨri mɨnɨm tari tari agnɨgal ak nɨŋɨl kaunan dɨl kɨsen gɨnɨgal me. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pen kɨri gebal rek ma gɨnɨmɨb. Bɨ an bɨ kɨb mɨdonɨmɨŋ ak, bɨ sɨkol rek mɨdɨl, bin bɨ ognap kɨrop wög gɨ ñeb bɨ rek mɨdonɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bɨ an bɨ kɨb yɨb mɨdonɨmɨŋ ak, bɨ sɨkol tam okok rek mɨdɨl, bin bɨ ognap kɨrop magɨlsek mɨñ wög gep bɨ alap rek mɨdonɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bɨ Ñɨ ne ak, bin bɨ okok kɨri wög yɨp gɨlaŋ, agɨl, ma owɨp; wög kɨrop gɨ ñɨ damɨl, kɨsen tap si tap tɨmel gɨpal ar ak saj gɨ kɨmen, bin bɨ koŋai nep komɨŋ amnɨlaŋ, agɨl, owɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas bɨ ne okok eip taun kɨb Jeriko amjaklak. Kɨri Jeriko kɨrɨg amnɨg, bin bɨ koŋai yɨb nep eip amnɨlak. Bɨ Timeas ñɨ ne Batimeas udɨn kwoi gak ak, mani ñɨm, agɨl, asɨb aglɨg gɨ, kanɨb gol sɨŋak bɨsɨg mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bɨsɨg mɨdek nɨŋlɨg gɨ, “Jisas bɨ Nasaret nɨb ak apeb,” agel nɨŋɨl, ne sɨk agɨl agak, “Jisas, Depid Ñɨ ne, yɨp yɨmɨg nɨŋan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Agek, bin bɨ okok nop sɨlɨkɨl aglak, “Mɨnɨm ma agan! Kapkap mɨdei!” aglak. Nɨb aglak ak pen ne kapkap mɨdɨl mer, meg mɨgan dap ranɨl sɨk kɨb agɨl agak, “Depid Ñɨ ne, yɨp yɨmɨg nɨŋan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Agek, Jisas maŋ nɨb sɨŋak wös gɨl agak, “Nop sɨk agem, sɨŋaul owaŋ,” agak. Agek, bin bɨ okok bɨ udɨn kwoi ak nop aglak, “Jisas nep sɨk ageb. Warɨkɨl gos sek owan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Agelak, walɨj parsek ne ak tɨg ju yokɨl, kasek nep warɨkɨl, Jisas mɨdek sɨŋak amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Amek, Jisas nop agak, “Yɨp tari gaŋ, agɨl, apeban?” agak. Agek bɨ udɨn kwoi gak ak agak, “Mɨnɨm ag ñeb bɨ. Udɨn ak kauyaŋ ñɨl nɨŋin, agɨl, apebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Agek, Jisas agak, “Jisas yɨp gek komɨŋ lɨnɨgab, agɨl, nɨŋ dɨpan ak rek, me nep komɨŋ lɨp, bɨr nak amnoŋ,” agak. Nɨb agek nɨŋlɨg gɨ, won nɨbak nep udɨn ñɨl nɨŋɨl Jisas eip amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas bɨ ne okok eip amɨl amɨl Jerusalem ulep ulep gɨlɨg gɨ, Olip Dɨm, karɨp tɨrɨg tɨroŋ Betpagi Betani amjakɨl, Jisas bɨ ne omal agɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Karɨp lɨm mɨgan kɨdadaŋ amɨl nɨŋnɨgair, kaj donki marɨp bin bɨ dad ma tapal alap ñon gɨ lel mɨdenɨgab. Nɨŋɨl, wɨsɨb donɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bin bɨ ognap nɨrep tari gɨnɨg nɨg gebir, agenɨmel, agnɨmir, ‘Bɨ Kɨb wög alap gɨl, kauyaŋ yokek, onɨgab,’ agnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nɨb agek, amɨl nɨŋrek, kaj donki marɨp alap kanɨb sɨŋak karɨp kɨjoŋ wagɨn gol sɨŋak nag ñon gɨ lel mɨdek. Mɨñ wɨsɨber nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bin bɨ yokop ulep nɨb sɨŋak mɨdelak okok aglak, “Tari gɨnɨg kaj donki marɨp nɨbak mɨñ wɨsɨbebir?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Agelak, Jisas agak rek nep agerek, yau agel, ");
INSERT INTO kmh_m_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","kaj donki marɨp nɨbak dam Jisas mɨdek sɨŋak apɨl, walɨj par kɨb kɨri tɨg juɨl, kaj donki ar alaŋ lɨrek, Jisas ar nɨbak bɨsɨgɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bin bɨ okok koŋai nep, walɨj parsek kɨri okok tɨg juɨl, kanɨb kɨb ar sɨŋak lɨlak; ognap mab kas okok tɨb rɨk dap lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nɨg gɨl, bin bɨ nop ned gɨlak okok abe, nop kɨsen gɨlak okok abe, sɨk aglɨg gɨ aglak, “God yɨb ne agon ar amnaŋ! Bɨ Kɨb bɨ ne ag yokek apeb aul; God nop kod mɨd tep gɨnɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Based Depid kiŋ mɨdɨl, bin bɨ kod mɨdolɨgɨp rek, ne cɨnop ak rek nep kod mɨdenɨgab! God yɨb ne agon ar amnaŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas nɨg gɨl, Jerusalem amɨl, God sobok gep karɨp mɨgan ak amɨl, tap okok nɨŋ tagek nɨŋlɨg gɨ, pɨb paŋɨd amek nɨŋlɨg gɨ, bɨ ne aknɨb umɨgan alaŋ okok eip karɨp tɨrɨg tɨroŋ Betani amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mɨnek pen, Betani nɨb adɨk gɨl kanɨb nab sɨŋak aplɨg gɨ, Jisas nop yuan lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yuan lek, par yɨpɨd nɨŋak mab uɫem alap mɨdek. Magɨl ognap pɨlɨl mɨdeb aka agɨl, amɨl nɨŋak, magɨl ma pɨlak; mab kas nep mɨdek. Pen tari: magɨl pɨlep ñɨn ak ma owak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nɨg gek, Jisas mab nɨbak agak, “Kɨsen bin bɨ ognap mab magɨl nak ak ma ñɨŋnɨgal,” agak. Bɨ ne okok mɨnɨm agak nɨbak nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas bɨ ne okok poŋ dɨl, Jerusalem amɨl, God sobok gep karɨp mɨgan amɨl nɨŋak, bin bɨ okok sɨkim gɨlɨg gɨ, mani yɨmjɨklɨg gɨ mɨdelak. Nɨg gelak, mani yɨmjɨk gelak abañ bad okok tɨg adɨk gɨl, yakɨr dap lel taulɨg gɨ mɨdelak mab bog okok tɨg adɨk gɨl, bin bɨ sɨkim gɨlɨg gɨ, tap taulɨg gɨ, karɨp mɨgan nɨbak mɨdelak okok, kɨrop yɨk gɨ mɨs yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yɨk gɨ mɨs yokɨl agak, “Tap ognap dap God sobok gep karɨp kab wari kɨs kɨs gɨl mɨdeb nab aul ma padɨknɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nɨb agɨl agak, “God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘God agɨp, “Karɨp yad ak, bin bɨ karɨp lɨm tɨgoŋ tɨgoŋ magɨlsek apɨl, yɨp sobok gɨnɨgal,” agɨp,’ aglak. Pen nɨbi nɨg gesɨm, bɨ tap si dɨ we gɨl mɨdebal karɨp alap rek lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nɨb agek, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, mɨnɨm nɨbak nɨŋɨl, nop ñag pak lɨn, aglak. Pen bin bɨ okok magɨlsek mɨnɨm nop ak nɨŋɨl wal aglak rek me, Jisas nop pɨrɨkɨl, titi gɨl nop ñag pak lɨn, agɨl, gos ak pɨyo nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kɨslɨm gak magɨl ak, Jisas bɨ ne okok eip Jerusalem kɨrɨg gɨl amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mɨnek kɨslɨm sek kanɨb nab sɨŋak kauyaŋ amlɨg gɨ nɨŋlak, mab uɫem Jisas ag gak ak wagɨn sek pɨs nep mɨlep gɨl mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nɨg gek nɨŋlɨg gɨ Pita agak, “Mɨnɨm ag ñeb bɨ, nɨŋan! Mab uɫem tol ag genak aul mɨlep gɨ yowɨp!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Agek, Jisas agak, “God nop nɨŋ dɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yad nɨbep nɨŋɨd agebin, cɨn agon God ak rek nep gɨnɨmɨŋ, agɨl, gos omal mer, gos nokɨm nɨŋɨl, dɨm gol nɨbaul ‘Ñɨg solwara nab sɨŋak adaŋ gɨ dam pakan,’ agenɨgabɨm ak, agnɨgabɨm rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nɨb ak me, God nop ag nɨŋnɨgabɨn rek gɨnɨgab, agɨl, gos nokɨm nɨŋɨl ag nɨŋem, ag nɨŋnɨgabɨm rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pen God nop sobok gɨnɨg gebɨm ak, bin bɨ ognap nɨbep gɨ tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨnɨmɨb, nɨŋɨl Nap nɨbi seb kab ar alaŋ mɨdeb ak, tap si tap tɨmel nɨbi gɨpɨm okok nɨŋɨl kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pen bin bɨ ognap nɨbep gɨ tɨmel gɨpal okok nɨŋɨl ma kɨrɨg gɨnɨgabɨm ak, Nap nɨbi seb kab ar alaŋ mɨdeb ak, tap si tap tɨmel nɨbi gɨpɨm okok ak rek nep nɨŋɨl ma kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pen Jisas bɨ ne okok eip kauyaŋ Jerusalem apjakɨl, ne God sobok gep karɨp mɨgan okok gɨ tagek nɨŋlɨg gɨ, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, Jisas mɨdek sɨŋak apɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Nep bɨ an, nɨg gɨnɨmɨn, agek, nɨg gɨlɨg gɨ ajeban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Agelak, Jisas pen agak, “Yad nɨbep mɨnɨm alap ag nɨŋen, yɨp ag ñenɨgabɨm ak, yad pen yad bɨ an agek nɨg gɨ ajebin ak, nɨbep ag ñɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon bin bɨ okok kɨrop ñɨg pak ñak ak, God agek ñɨg pak ñak aka gos ne ke nɨŋɨl ñɨg pak ñak? Yɨp agem nɨŋin!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nɨb agek, kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “Cɨn agnɨgabɨn, ‘God agek, Jon bin bɨ okok kɨrop ñɨg pak ñak,’ agenɨgabɨn ak, cɨnop agnɨgab, ‘Nɨb ak, tari gɨnɨg Jon mɨnɨm nop ak ma nɨŋ dɨpɨm?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pen cɨn agnɨgabɨn, ‘Jon gos ne ke nɨŋɨl kɨrop ñɨg pak ñak,’ agnɨgabɨn ak, cɨnop tari gɨnɨgab?” aglak. Pen tari: bin bɨ okok magɨlsek, God agek, Jon wög ne golɨgɨp ag gos nɨŋölɨgɨpal ak me, Juda bɨ kɨb nɨb okok pɨrɨkɨl mɨnɨm ke alap ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gos nɨbak nɨŋɨl aglak, “Cɨn ma nɨpɨn,” aglak. Nɨb agelak, Jisas kɨrop pen agak, “Nɨbi yɨp pen ma ag ñɨbɨm rek, yad bɨ an agek gɨ ajebin ak, nɨbep ak rek nep pen ma ag ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas pen kɨrop mɨnɨm ar alap sɨd tɨkɨl agak, “Bɨ alap wari gɨl, nag wain wög ak gɨ yɨmɨl, wain magɨl pak cɨb jakep, agɨl, mɨgan alap gɨ lɨ tep gɨnɨgab. Bin bɨ apɨl nag magɨl si dɨnɨgal ak nɨŋ mɨdojɨn, agɨl, karɨp kɨlan gɨ par kɨb alap gɨl, bɨ ognap kɨrop agnɨgab, ‘Nɨbi nag wain wög yad ak kod mɨdɨl, kɨsen pɨlɨl pok gek, yɨp ognap, nɨbi ognap dɨnɨmɨb,’ agɨl, karɨp lɨm par okok amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain magɨl pok gɨnɨgab magɨl ak, bɨ ne alap ag yokɨl, agnɨgab, ‘Wain magɨl yɨp ognap ñel donɨmɨn!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Agek, amjakek, bɨ wög gɨnɨgal okok, nop dɨ pak pak lɨl, yokop nep ag yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nɨg gel, bɨ wain wög nap nɨb ak bɨ alap pen ag yoknɨgab. Amjakek, nop nabɨc alaŋ pakɨl, gɨ tɨmel yɨb gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nɨg gel, bɨ wain wög nap nɨb ak, bɨ alap pen ag yokek amek, nop pɨs nep ñag pak lɨnɨgal. Bɨ ognap koŋai nep ag yokek, nɨb aknɨb nep gɨlɨg gɨ, ognap tapɨn magɨl paknɨgal, ognap pɨs nep ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nɨg gel gel me, bɨ wain wög nap nɨb ak bɨ ne alap ma mɨdenɨgab; ñɨ mɨdmagɨl ne nokɨm mɨdenɨgab ak, mɨnɨm ne ak dɨnɨgal, agɨl, ag yokek amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pen amjakek, bin bɨ wain wög gɨ mɨdenɨgal okok nɨŋɨl agnɨgal, ‘Ñɨ apeb aul, bɨ wain wög nap nɨb ak ñɨ ne apeb. Nɨb ak, nop ñag pak lɨl me, tap ne dɨnɨmɨŋ rek okok cɨn dɨnɨgabɨn,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nɨb agɨl, ñɨ nɨbak nop pɨs nep ñag pak lɨl, dam wain wög mɨs okok dɨ yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nɨg genɨgal, bɨ wain wög nap nɨb ak apɨl, tari gɨnɨgab? Ne apɨl, bin bɨ wain wög genɨgal nɨb okok kɨrop ñag pak lɨl, bin bɨ ognap kɨrop agek, wain wög nɨbak kod mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nɨb agɨl kɨrop agak, “Nɨbi God Mɨnɨm ñu kɨl tɨklak dai alap ma nɨpɨm rek lɨp. God Mɨnɨm dai nɨbak ñu kɨl tɨkɨl aglak, ‘Bɨ karɨp gep okok kab par kɨrɨg gɨlak ak, kab nɨbak nep mɨñi karɨp sap nab eyaŋ sɨŋak pɨŋɨl ñɨl mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bɨ Kɨb nɨg gak ak, cɨn nɨŋɨl tep agobɨn,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas nɨb agek, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, cɨnop nep ageb, agɨl, nop cɨcɨ dɨn, ag nɨŋlak ak pen bin bɨ okok kɨrop pɨrɨkɨl, kɨrɨg gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pen kɨsen Juda bɨ kɨb nɨb okok, bɨ Perisi ognap eip, Herod bɨ ne ognap eip kɨrop aglak, “Nɨbi Jisas mɨdeb sɨŋak amɨl, nop mɨnɨm ognap ag nɨŋem, ne tari nɨnöl mɨnɨm agenɨgab, nop dam mɨñ lɨnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nɨb agelak, Jisas mɨdek sɨŋak amɨl, aglak, “Mɨnɨm ag ñeb bɨ. Cɨn nɨpɨn nak bɨ nɨŋɨd yɨb nep ageban. Bɨ kɨb okok abe, bin bɨ yokop okok abe, kɨrop nɨŋɨl ma pɨrɨkpan. God ageb rek nep nɨŋɨl, bin bɨ okok kɨrop yɨpɨd gɨl nep ag ñeban. Nɨb ak, cɨnop ag ñan! Cɨn Juda bin bɨ lo okok titi gɨl mɨdeb? Gapman bɨ kɨb Sisa nop takɨs ñɨjɨn aka ma ñɨjɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nɨb agelak, Jisas mɨnɨm tom agelak ak nɨŋɨl agak, “Tari gɨnɨg, nɨnöl mɨnɨm agaŋ, agɨl, yɨp mɨnɨm esek nɨbak agebɨm? Kab magɨl alap dapem, yad nɨŋin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Agek, kab magɨl alap dap ñel nɨŋɨl agak, “Kab magɨl bak ak, bɨ an mɨlɨk dai ak mɨdɨl, an yɨb ak mɨdeb?” agak. Agek aglak, “Bɨ kɨb Sisa ak nep,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Agelak, Jisas agak, “Sisa tap ne mɨdonɨmɨŋ ak Sisa nop ñɨnɨmɨb; God tap ne mɨdonɨmɨŋ ak God nop ñɨnɨmɨb,” agak. Nɨb agɨl, mɨnɨm tom kɨri ak talak gɨ tep gak nɨbak nɨŋɨl, wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadyusi bin bɨ okok, bin bɨ kɨmɨl, ma warɨknɨgal, agɨl, nɨŋölɨgɨpal rek, ognap Jisas mɨdek sɨŋak apɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mɨnɨm ag ñeb bɨ. Bɨ God mɨnɨm agep Mosɨs, mɨnɨm alap cɨnop ñu kɨl tɨkɨl agak, ‘Bɨ alap bin dɨl, ñɨ pai tɨkɨl mer, yokop kɨmenɨgab ak, nɨmam ne alap pen bin kaŋɨl nɨbak dɨl, mam kɨmak ak ñɨ pai ne ak, agɨl, tɨknɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nɨb ak, bɨ wagɨn sek aknɨb ar oŋɨd ak mɨdenɨgal. Nɨmam ned bin dɨl, ñɨ pai tɨkɨl mer, yokop kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kɨmek, nɨmam yɨgwu nab nɨb ak pen bin nɨbak nop dɨl, ak rek nep ñɨ pai tɨkɨl mer, yokop kɨmnɨgab. Nɨg gek, nɨmam yɨgwu nokɨm nɨb ak pen bin nɨbak nop dɨl, ak rek nep ñɨ pai tɨkɨl mer, yokop kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nɨg gɨ dam dam, nɨmam aknɨb ar oŋɨd okok ñɨ pai tɨkɨl mer, magɨlsek yokop kɨmnɨgal. Kɨsen bin ak, ak rek nep kɨmnɨgab. Pen bin bɨ kɨmɨl warɨknɨgal, apan ak, ");
INSERT INTO kmh_m_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","bin nokɨm alap bɨ ne aknɨb ar oŋɨd lɨnɨgab nɨbak, kɨsen nɨmam akal bin ne mɨdenɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Agelak, Jisas agak, “Nɨbi God Mɨnɨm ñu kɨl tɨklak ak abe, God kɨlɨs ne ak abe ma nɨpɨm rek, gos nɨŋɨd ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bin bɨ kɨmbal okok warɨknɨgal ñɨn ak, God ejol ne okok mɨdebal rek mɨdɨl, bɨ okok bin ma dɨnɨgal; bin okok bɨ ma dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pen bin bɨ kauyaŋ ma warɨknɨgal, apɨm ak, Mosɨs mab sɨkol yɨn nep mɨdek kesɨm ñu kɨl tɨkak ak ma nɨpɨm rek lɨp. God, mab yɨnek nab sɨŋak mɨdɨl, Mosɨs nop agak, ‘Ebraham, Aisak, Jekop, God kɨri me, yad mɨdebin,’ agak. Nɨb ak, based sɨkop ned kɨmlak okok kɨrop agɨl, ‘God kɨri mɨdebin,’ agak. Pen nɨbi apɨm rek, bin bɨ okok kɨmɨl, pɨs nep kɨmblap ak, God ne, ‘Ebraham, Aisak, Jekop, God kɨri mɨdebin,’ ma apkop. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nɨbi gos nɨŋ tep ma gɨl, bin bɨ kɨmbal okok nɨŋɨl, bɨr pɨs nep kɨmbal apɨm ak pen God nɨŋɨp kɨri komɨŋ mɨdebal. Bin bɨ komɨŋ mɨdebal nɨb okok ne God kɨri mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bɨ lo mɨnɨm ag ñeb bɨ alap, Jisas Sadyusi bin bɨ okok kɨrop ag tep gak ak nɨŋɨl, apɨl nop ag nɨŋɨl agak, “Lo ar akal kɨb yɨb?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Agek, Jisas agak, “Lo kɨb yɨb ak, God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Isrel bin bɨ nɨŋɨm! Bɨ Kɨb cɨn God, ne nokɨm nep Bɨ Kɨb mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mɨdmagɨl nak ak magɨlsek, gos tɨmɨd nak ak magɨlsek, kɨlɨs nak ak magɨlsek dɨl, God Bɨ Kɨb nak ak nop mɨdmagɨl lɨnɨmɨn,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mɨnɨm kɨb yɨb alap, God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Nak ke mɨdmagɨl lɨpan rek, bin bɨ ke nɨb okok kɨrop ak rek nep mɨdmagɨl lɨnɨmɨn,’ aglak. Lo mɨnɨm okok magɨlsek, lo nɨb omal me lo kɨb yɨb mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Agek, bɨ lo mɨnɨm ag ñeb bɨ ak pen agak, “Mɨnɨm ag ñeb bɨ. Nak nɨŋɨd yɨb ageban, God nokɨm me Bɨ Kɨb yɨb mɨdeb; ne rek ognap ma mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cɨn God nop tap pak sobok gɨ ñɨnɨgabɨn aka tap pak sobok gɨ ñɨ pɨs nep dagɨlnɨgabɨn ak tap kɨb mer. Tap kɨb yɨb me, mɨdmagɨl cɨn ak magɨlsek, gos tɨmɨd cɨn ak magɨlsek, kɨlɨs cɨn ak magɨlsek dɨl, God Bɨ Kɨb ak nop mɨdmagɨl lɨjɨn; cɨn ke mɨdmagɨl lɨpɨn rek, bin bɨ okok kɨrop ak rek nep mɨdmagɨl lɨjɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nɨb agek, Jisas bɨ ak, ne gos nɨŋ tep yɨb gɨl ageb, agɨl, nop agak, “Nak God bɨ ne alap mɨdenɨmɨn rek lɨp,” agak. Jisas pen mɨnɨm nɨŋɨd yɨb okok nep agek ak nɨŋɨl, bin bɨ nɨŋ mɨdelak okok pɨrɨkɨl, kɨsen mɨnɨm esek okok nɨb nop neb neb gɨl agelɨgɨpal rek, ognap sek nop ma ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas God sobok gep karɨp sɨŋak bin bɨ okok kɨrop mɨnɨm ag ñɨ mɨdlɨg gɨ, bin bɨ okok kɨrop agak, “Bɨ lo mɨnɨm ag ñeb bɨ okok tari gɨnɨg apal, ‘Krais ak ne Depid ñɨ ne nep,’ apal? ");
INSERT INTO kmh_m_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kaun Sɨŋ ak, Depid nop gos ñek, Depid ne ke ñu kɨl tɨkɨl agak, ‘Bɨ Kɨb ne Bɨ Kɨb yad ak nop agak, “Nak ñɨnmagɨl yɨpɨd ken kɨd yad bɨsɨg mɨdenɨmɨn me, yad bin bɨ kaual maual nak okok kɨrop tob mok nep okok lɨnɨgain,” agak,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nɨb ak, Depid ne ke Krais nop ‘Bɨ Kɨb yad’ agak. Pen Krais Depid ñɨ ne mɨdobkop, nop ‘Bɨ Kɨb yad’ ma apkop,” agak. Jisas mɨnɨm wagɨn nɨbgɨl nɨŋɨl ag tep gek rek, bin bɨ koŋai yɨb mɨdelak okok mɨnɨm nop ak mɨñ mɨñ gɨlɨg gɨ nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas bin bɨ okok kɨrop mɨnɨm ag ñɨlɨg gɨ agak, “Bɨ lo mɨnɨm ag ñeb bɨ okok kɨrop nɨŋ tep gɨnɨmɨb. Kɨri gɨpal ar ak, walɨj par kɨb okok lɨl, maker okok amon, bin bɨ okok, apebɨm e, agel, yɨb cɨn i ar alaŋ mɨdeŋ, agɨl, gos ak nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pen Juda mogɨm gep karɨp ak amon, cɨnop kau ar tep tep bɨ kɨb bɨsɨgpal, ar ak bɨsɨgɨm, agnɨgal, agɨl, gos ak nɨpal. Bin bɨ tap kɨb ñɨbal nab ak, ak rek nep, bin bɨ udɨn yɨrɨk ar sɨŋak bɨsɨgon, cɨnop nɨŋɨl, cɨn bɨ gep bɨ yɨb mɨdeb, agnɨgal, agɨl, gos ak nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɨ lo mɨnɨm ag ñeb bɨ okok, bin kaŋɨl karɨp tap kɨri okok tap cɨn rek laŋ, agɨl, pɨlɨ gɨ dɨpal. God nop sobok gɨnɨgabɨn ak, bin bɨ nɨŋnɨmel, agɨl, mɨnɨm par kɨb tom tom ar ognap nep okok apal. Nɨg gɨpal ak, kɨsen God kɨrop yur kɨb aknɨb ke yɨb ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas God sobok gep karɨp mani dap ñölɨgɨpal mɨgan ulep sɨŋak bɨsɨg mɨdɨl nɨŋak, bin bɨ okok apɨl mani dap yokelak. Bin bɨ gep okok, mani koŋai nep dap yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pen bin kaŋɨl mani ma mɨdek alap, kab magɨl lakañ magɨl sɨkol omal dap yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɨg gek nɨŋɨl, Jisas ne bɨ ne okok agek apelak agak, “Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ okok kɨri mani sɨkol ñebal, pen bin kaŋɨl aul mani kɨb yɨb ñɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tari gɨnɨg: bin bɨ mani koŋai mɨdeb okok, mani kɨri ognap sek koŋai nep mɨdek nɨŋlɨg gɨ, mani kɨri God nop ognap nep dap ñɨbal; pen bin kaŋɨl aul, mani ne magɨl omal mɨdosɨp ak magɨlsek dap ñɨb. Ne tap tau ñɨŋeb mani alap ma mɨdeb. Nɨg gɨp ak, God nɨŋek, bin bɨ ognap kɨri tap sɨkol ñɨbal ak pen bin kaŋɨl aul ne tap kɨb yɨb ñɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas God sobok gep karɨp ak kɨrɨg gɨl söŋ amek nɨŋlɨg gɨ, bɨ ne alap nop agak, “Mɨnɨm ag ñeb bɨ. Kab tep dɨl, karɨp tep gɨlak aul nɨŋan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Agek, Jisas agak, “Nak kab karɨp kɨb nɨbak nɨŋɨl ageban ar? Kɨsen karɨp nɨb aul pag jɨsɨpɨk masɨpɨk gɨ yokel, kab alap, kab alap ar sɨŋak ma mɨdenɨgab; pɨs nep pag yoknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas nɨb agɨl, God sobok gep karɨp ak kɨrɨg gɨl, Olip Dɨm amnak. God sobok gep karɨp ak tau kɨd adaŋ mɨdeb, Olip Dɨm tau kɨd aul mɨdeb. Jisas Olip Dɨm sɨŋak bɨsɨg mɨdek nɨŋlɨg gɨ, Pita, Jon, Jems, Edru kɨri yakam apɨl nop aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tap agesan ak, ñɨn akal rek gɨnɨgab? Pen tap tari rek gek nɨŋɨl agnɨgabɨn, ‘Tap nɨb okok mɨñi gɨnɨg geb,’ agnɨgabɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Agelak, Jisas kɨrop agak, “Nɨŋ tep gɨl, mɨnɨm esek agel ma dɨnɨmɨb! ");
INSERT INTO kmh_m_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bin bɨ koŋai nep apɨl, esek agɨl, yɨb yɨp ak dɨl, agnɨgal, ‘Yad Jisas nep apebin,’ agnɨgal. Nɨb agel, bin bɨ koŋai nep, nɨŋɨd agebal agɨl, kɨrop kɨsen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Karɨp lɨm sɨŋ aul pen pen gebal, karɨp lɨm okok pen pen gebal,’ agenɨmel, gos par ma nɨŋnɨmɨb. Tap nɨb okok gɨnɨgab ak pen mɨñi karɨp lɨm wagɨn aul tap okok magɨlsek kɨr gɨnɨgab, agɨl, gos ak ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bin bɨ mɨgan ognap warɨkɨl, bin bɨ mɨgan ognap eip pen pen gɨnɨgal. Kiŋ mɨgan ognap warɨkɨl, kiŋ mɨgan ognap eip pen pen gɨnɨgal. Karɨp lɨm okok magɨlsek monmon dɨl, yuan kɨb yɨb apɨl gɨnɨgab. Tap gɨnɨgab nɨb okok, bin okok kɨrop ned ñɨ pai ñɨbosɨp, kɨsen ñɨ pai tɨkpal rek ak gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pen nɨbi nɨŋ rep gɨlɨg gɨ mɨdenɨmɨb. Ñɨn ognap nɨbep dam Juda kansol bɨ okok kɨrop ñel, mɨnɨm kɨb agnɨgal. Ñɨn ognap, Juda mogɨm gep karɨp mɨgan okok, yɨr dɨl, nɨbep paknɨgal. Ñɨn ognap, Jisas bɨ ne, agɨl, nɨbep dam gapman bɨ kɨb abe kiŋ abe mɨdenɨgal sɨŋak amɨl, mɨnɨm kɨb agnɨgal. Pen nɨg dad amenɨmel ak, mɨnɨm tep yad ak gapman bɨ kɨb okok abe, kiŋ okok abe kɨrop ag ñɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ned mɨnɨm tep yad ak, bin bɨ karɨp lɨm ke tɨgoŋ tɨgoŋ magɨlsek ag ñel amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Pen yad pɨs ken mɨdenɨgabɨm ak nɨŋɨl, nɨbep mɨnɨm kɨb agnɨg dad amenɨmel ak, mɨnɨm pen titi gɨl agjɨn, agɨl, gos par ma nɨŋnɨmɨb. Agnɨg gem nɨŋlɨg gɨ, Kaun Sɨŋ nɨbep gos tep ñek, agnɨgabɨm. Mɨnɨm nɨbak nɨbi ke ma agnɨgabɨm; Kaun Sɨŋ ne ke agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ñɨn nɨbak, mam bɨ okok warɨkɨl, mam ognap kɨrop ñag pak lɨlaŋ, agɨl, kain gɨ dam bɨ mɨnɨm nɨŋep bɨ okok ñɨnmagɨl ar kɨrop ñel, ñag pak lɨnɨgal. Nap bɨ okok warɨkɨl, ñɨ pai kɨri ke okok kɨrop ñag pak lɨlaŋ, agɨl, kain gɨ dam bɨ mɨnɨm nɨŋep bɨ okok ñɨnmagɨl ar kɨrop ñel, ñag pak lɨnɨgal. Ñɨ pai okok warɨkɨl, nonɨm nap sɨkop kɨrop nɨŋel, mɨlɨk yapek, kɨrop ñag pak lɨlaŋ, agɨl, kain gɨ dam bɨ mɨnɨm nɨŋep bɨ okok ñɨnmagɨl ar kɨrop ñel, ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yad pɨs ken mɨdenɨgabɨm ak nɨŋɨl, nɨbep mɨlɨk kal nɨŋnɨgal ak pen, nɨbi bin bɨ an an, kɨlɨs gɨlɨg gɨ, yɨp ma kɨrɨg gɨl, cɨg gɨlɨg gɨ nep mɨdenɨgabɨm okok, ñɨn kɨsen agebin ak apenɨgab ak, God nɨbep dɨ komɨŋ yoknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pen tap bɨl asɨk mosɨk gep ak, kau ne ma ameb sɨŋak amɨl warɨkɨl mɨdenɨgab, nɨŋnɨgabɨm ak, nɨbi bin bɨ karɨp lɨm Judia mɨdenɨmɨb okok, kasek pɨrɨk gɨ dɨm gol okok amnɨmɨb. (Nɨbi bin bɨ mɨnɨm aul mɨñi nep udɨn lɨ nɨŋebɨm okok, mɨnɨm wagɨn ak tɨk nɨŋ tep gɨnɨmɨb.) ");
INSERT INTO kmh_m_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bin bɨ karɨp ar alaŋ mɨdenɨmɨb okok, tap yad ognap dɨnɨm, agɨl, adɨk gɨ sɨŋak eyaŋ ma amnɨmɨb; karɨp mɨgan eyaŋ ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bin bɨ wög dai okok ajenɨmɨb okok, walɨj par yad alap dɨnɨm, agɨl, adɨk gɨ karɨp ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pen ñɨn nɨbak, bin ñɨ pabag sek mɨdenɨmel okok abe, bin ñɨ paiŋaŋ ci ñenɨmel okok abe, koslam yɨb pɨrɨk gɨ amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tap gɨnɨgab nɨbak, God nop sobok gɨl, karɨp yɨgen geb ñɨn ak ma gɨnɨmɨŋ, agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tari gɨnɨg: God bɨrarɨk ped okok karɨp lɨm gɨ lak ñɨn ak tɨkɨl, mɨd damɨl mɨñi mɨdobɨn ñɨn aul, tap tɨmel nɨbak rek alap ma gak; kɨsen okok ak rek nep tap tɨmel nɨbak rek alap ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tap tɨmel nɨbak per gɨpkop, bin bɨ magɨlsek kɨm sakplap. Pen Bɨ Kɨb ne bin bɨ ne dɨnɨgab okok kɨrop gos nɨŋɨl, mer agek me, tap tɨmel nɨbak yokop won alap gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ñɨn nɨbak bin bɨ ognap nɨbep apɨl, ‘Nɨŋɨm! Krais mɨdeb aul! Krais mɨdeb adaŋ!’ agenɨmel ak, nɨŋɨd agebal agɨl, gos ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bin bɨ ognap, God bin bɨ ne ke ag lak okok kɨrop dɨn, agɨl, esek agɨl agnɨgal, ‘Yad me Krais; yad me bɨ God mɨnɨm agep bɨ alap,’ agɨl, tap ma gep rek ognap gɨnɨgal. Pen God bin bɨ ne ke ag lak okok ma dɨnɨgal, mer. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nɨb ak, nɨŋ tep gɨnɨmɨb. Tap tari tari kɨsen gɨnɨgab ak, yad nɨbep agen nɨpɨm ak me, nɨŋ tep gɨlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pen mɨker kɨb nɨb okok gɨ sakek nɨŋlɨg gɨ, pɨb ak kɨslɨm gɨl, takɨn ak melɨk ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gap okok seb kab ar alaŋ nɨb pɨg ju yap apek nɨŋlɨg gɨ, tap seb kab ar alaŋ mɨdeb okok, okdaŋ nɨb okol nɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ñɨn nɨbak, Bɨ Ñɨ ne kɨlɨs ke yɨb dɨl, melɨk tep aknɨb ke sek kɨmi bad nab sɨŋak apek nɨŋlɨg gɨ, bin bɨ nop nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pen ejol ne okok ag yokek karɨp lɨm ke yɨmñak yɨmñak magɨlsek tɨgoŋ tɨgoŋ okok amɨl, bin bɨ ne ke ag lak okok poŋ dɨl nop donɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas agak, “Nɨbi mab tauan okok nɨŋnɨgabɨm ak, mɨnɨm agebin aul nɨŋ tep gɨnɨgabɨm. Mab tauan okok sɨlɨp lɨl, wös gek nɨŋlɨg gɨ, mɨñi pɨb lɨnɨg geb, agɨl nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nɨb ak rek, kɨsen tap agebin okok gek nɨŋlɨg gɨ, ‘Mɨñi maŋ mɨdeb, Jisas agak rek gɨnɨg geb,’ agɨl nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yad nɨbep nɨŋɨd yɨb agebin. Bin bɨ mɨñi mɨdebal okok ognap mɨdel nɨŋlɨg gɨ, tap nɨb okok gɨ sakek, kɨsen kɨmnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Seb kab ar alaŋ abe, lɨm dai wagɨn aul abe kɨr gɨnɨgab; pen mɨnɨm magɨl yad okok ma kɨr gɨnɨgab; per per nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ñɨn akal aka magɨl akal onɨgain ak, bin bɨ ognap ma nɨpal, ejol okok ma nɨpal, yad Ñɨ ak, ak rek nep ma nɨpin; Bapi nep nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nɨb ak me, ñɨn akal onɨgain ak ma nɨpɨm rek, per per nɨŋ tep yɨb gɨlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Onɨgain ñɨn nɨbak, kesɨm agnɨg gebin ar aul rek. Bɨ kɨb alap karɨp ne ak kɨrɨg gɨl mɨgan alap amnɨg gɨ, bɨ wög gep ne okok kɨrop wög ar ke ke ag lɨl, ‘Wög nɨg nɨg gɨnɨmɨb,’ agɨl, bɨ ne kɨjoŋ wagɨn kod mɨdenɨgab ak nop agnɨgab, ‘Nɨŋ tep yɨb gɨl mɨdenɨmɨn,’ agɨl, amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nɨbi ak rek nep, magɨl akal bɨ karɨp nap nɨb ak onɨgab ak ma nɨpɨm rek, nɨŋ tep gɨl mɨdenɨmɨb. Dɨgep won ak onɨgab aka, kɨslɨm nab kɨb eyaŋ onɨgab aka, kɨlokɨl gaul gɨnɨgab won ak onɨgab aka, kɨslɨm sek onɨgab, agɨl, ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nɨbi kɨnem nɨŋlɨg gɨ, kasek onɨmɨŋ rek lɨp ak me, nɨŋ tep gɨl mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pen nɨbep nep ma agebin; bin bɨ okok magɨlsek ak rek nep agebin, nɨŋ tep gɨl mɨdenɨmɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pen Juda kai Pasopa ñɨn kɨb ak abe, Bred Yɨs Sek Ma Ñɨŋeb ñɨn kɨb ak abe yokop ñɨn omal nep mɨdek nɨŋlɨg gɨ, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, Jisas nop titi gɨl, kapkap dɨ cɨcɨ lɨl, dam ñag pak lɨn, agɨl, nɨg gɨl gos nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pen gos alap nɨŋɨl aglak, “Pasopa ñɨn aul nɨg gon, bin bɨ koŋai nep sɨŋ aul warɨkɨl, pen pen gɨl, cɨnop gɨ tɨmel gɨnɨgal,” agɨl, kɨrɨg gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas karɨp tɨrɨg tɨroŋ Betani amɨl, Saimon karɨp ak am bɨsɨg gɨl, tap ñɨbelak. Bɨ Saimon nɨbak, ned soi sapeb lak ak, Jisas gek, komɨŋ lak. Pen tap ñɨbel nɨŋlɨg gɨ, bin alap wel ki tep owep mani kɨb taupal ak, barol sek dapɨl, nab sɨŋak tɨ paŋɨl, Jisas nop nabɨc ar alaŋ soŋ gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Soŋ gek, bɨ mɨdelak nɨb okok, ognap nɨŋel, cɨbur kɨrop alɨksek lek, kɨri ke aglak, “Wel nɨbak sɨkim gɨl, mɨ nokɨm alap bɨ alap wög gɨl mani dɨnɨgab rek ak dɨl me, bin bɨ tap ma mɨdeb okok kɨrop ñeb ak pen tari gɨnɨg nɨg gɨl yokop soŋ gɨp?” aglak. Nɨb agɨl, bin nɨbak nop ag julak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nɨb agelak, Jisas kɨrop agak, “Tari gɨnɨg nɨb agebɨm? Nop kɨrɨg gɨm! Yɨp gɨp nɨbak, gɨ rep yɨb gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bin bɨ tap ma mɨdeb okok, nɨbep eip per nep mɨdenɨgal rek, ñɨn ognap kɨrop tap ñɨnɨg, ñɨnɨgabɨm. Pen yad eip per ma mɨdenɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Bin nɨbaul, tap ne gep rek ak, gɨp. Kɨmen, wel ki tep owep ak lɨ ñɨl tɨgel gɨnɨgal rek, yɨp ned lɨ ñɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nɨb ak, yad nɨbep nɨŋɨd agebin, kɨsen mɨnɨm tep yad ak karɨp lɨm yɨmñak yɨmñak magɨlsek ag ñel amek nɨŋlɨg gɨ, ne gɨp nɨbak sek agel, kɨri bin nɨbaul nop gos saköl ma gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pen Jisas bɨ ne alap Judas Iskariot, Jisas nop mɨmɨg gɨnɨm agɨl, bɨ God nop tap sobok gep bɨ kɨb okok amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bɨ God nop tap sobok gep bɨ kɨb nɨb okok, mɨmɨg gak nɨbak nɨŋɨl, tep gek, aglak, “Nep mani ognap ñɨnɨgabɨn,” aglak. Agelak me, Judas, “Titi gɨl agen, kɨri apɨl Jisas nop dad amnɨmel,” agɨl, gos ak pɨyo nɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bred Yɨs Sek Ma Ñɨŋeb ñɨn kɨb ak apek, Pasopa kaj sipsip ñɨlɨk pak sobok gɨ ñɨŋeb ñɨn ak, Jisas bɨ ne okok nop ag nɨŋɨl aglak, “Pasopa tap cɨn ñɨŋnɨgabɨn ak, mɨgan akal gɨ jɨn gɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Agelak, Jisas bɨ ne omal ag yokɨl agak, “Nɨri taun kɨb ak amɨl nɨŋnɨgair, bɨ alap ñɨg mɨl dap padɨkenɨgab; nop nabɨŋ pakɨl eip amnɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bɨ nɨbak amɨl karɨp mɨgan amonɨmɨŋ, nɨri mal bɨ karɨp nɨbak nap nɨb ak nop ag nɨŋɨl agnɨmir, ‘Mɨnɨm ag ñeb bɨ agɨp, “Bɨ yad okok eip Pasopa tap ñɨŋnɨgabɨn karɨp mɨgan akal?” agɨp,’ agnɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nɨri ag nɨŋer, ne nɨrep dam karɨp ar alaŋ, tap okok magɨlsek mɨdeb ñɨlɨk mɨgan kɨb ak yomnɨgab. Yomek, tap ñɨŋnɨgabɨn ak ñɨlɨk mɨgan nɨbak gɨ jɨn genɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jisas kɨrop mal nɨb ag yokek, taun kɨb ak amɨl nɨŋrek, Jisas agak rek nep mɨdek. Nɨŋɨl, Pasopa tap ñɨŋnɨg gɨlak ak, gɨ jɨn gɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dɨgep won ak, Jisas bɨ ne aknɨb umɨgan alaŋ okok eip amjakɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","bɨsɨg gɨl tap ñɨblɨg gɨ agak, “Yad nɨbep nɨŋɨd agebin, bɨ yad eip tap jɨm ñɨl ñɨbobɨn sɨŋaul nep, bɨ alap, yɨp ñag pak lɨlaŋ, agɨl, yɨp mɨmɨg gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nɨb agek, bɨ ne okok yɨmɨg gek, gos mɨker nɨŋlɨg gɨ, nop nokɨm nokɨm ag nɨŋlɨg gɨ aglak, “Nak yɨp ageban aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Agelak, Jisas agak, “Nɨbi bɨ yad aknɨb umɨgan alaŋ mɨdebɨm okok, bɨ alap nɨg gɨnɨgab. Bɨ nɨbak me, yad eip tap kɨnaŋ nokɨm jɨm ñɨl ñɨbobɨr aul. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yad Bɨ Ñɨ ne, God Mɨnɨm ñu kɨl tɨkɨl aglak rek nep kɨmnɨgain ak pen bɨ yɨp ñag pak lɨlaŋ, agɨl, mɨmɨg gɨnɨgab ak, nop yɨmɨg nɨŋebin. Ne yur kɨb dɨnɨgab ak me, nop ma tɨk doplap ak tep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tap ñɨblɨg gɨ, Jisas bred ak dɨl, God nop tep, agɨl, tɨ paŋɨl, bɨ ne okok kɨrop ñɨlɨg gɨ agak, “Dɨ ñɨŋɨm! Ak mɨb goŋ yad,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pen ñɨg wain kap ak, ak rek nep dɨl, God nop tep, agɨl, bɨ ne okok kɨrop ñek, magɨlsek ñɨbel nɨŋlɨg gɨ, agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Ñɨg aul, lakañ yad. Lakañ yad soŋ gɨ yonɨgab ak me, God mɨnɨm kɨlɨs nɨŋɨd ag lak rek, bin bɨ koŋai nep nop eip dɨ jɨm ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɨb agɨl agak, “Yad nɨbep nɨŋɨd agebin, yad ñɨg wain kauyaŋ ma ñɨŋnɨgain. Yokop nep mɨden, God bin bɨ dɨl seb kab ar alaŋ sɨŋak kod mɨdenɨgab ñɨn ak nep, ñɨg wain kɨsen nɨb ñɨŋnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nɨb agɨl, bɨ ne okok eip God nop sobok gep kɨmep alap agɨl, Olip Dɨm amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas bɨ ne okok kɨrop agak, “God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘God ne agak, “Yad bɨ kaj sipsip mɨkep ak nop pak len, kaj sipsip okok pɨrɨk gɨ ke ke amnɨgal,” agak,’ aglak. Nɨb ak rek, mɨdak mɨdak nɨbi magɨlsek yɨp kɨrɨg gɨl, pɨrɨk gɨ amnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pen yad kɨmɨl, warɨkɨl karɨp lɨm Galili amen, nɨbi kɨsen nɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nɨb agek, Pita agak, “Bɨ ognap nep kɨrɨg gɨnɨmel rek lɨp ak pen yad nep ma kɨrɨg gɨnɨgain, mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Agek, Jisas agak, “Yad nep nɨŋɨd agebin, mɨñi ñɨn aul nep, kɨslɨm nab eyaŋ kɨlokɨl sɨk omal ma agnɨgab won ak, ‘Yad Jisas nop ma nɨpin,’ agɨl, yɨj omal nokɨm we ñɨnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Agek, Pita mɨnɨm kɨlɨs yɨb agɨl agak, “Yɨp nak eip ñag pak lɨnɨg, ñag pak lɨnɨmel ak pen yad Jisas nop ma nɨpin, agɨl, ma agnɨgain,” agak. Jisas bɨ ne okok magɨlsek, Pita agak rek nep aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas bɨ ne okok eip mab wög dai Getsemani amɨl kɨrop agak, “Nɨbi sɨŋaul bɨsɨg mɨdem, yad am sobok gɨnɨg amebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nɨb agɨl, Pita, Jems, Jon kɨrop poŋ dɨ damɨl, gos par lɨlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Mɨdmagɨl yad ak yur gɨ dap yowɨp ak, kɨmnɨm rek lɨp. Nɨbi wagɨn aul mɨdɨl, nɨŋ mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nɨb agɨl, kɨrop sɨŋak ag lɨl, ne yokop ulep nɨb sɨŋak amɨl, lɨm dai eyaŋ yap pakɨl, yur kɨb dɨnɨg gek nɨbak, Nap ne mer agnɨmɨŋ aka mer ma agnɨmɨŋ, agɨl, sobok gɨlɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nap nop sobok gɨlɨg gɨ agak, “Bapi, nak tap okok magɨlsek gep ak nep mɨdeb. Tap yɨp gɨnɨg geb ak, yad mɨker kɨb mɨdeb. Nak yau agnɨmɨn, yɨp aknɨb ma gɨnɨmɨŋ. Pen tap yɨp tari gɨnɨg genɨmɨŋ ak, gos yad nɨŋnɨm ar ak ma gɨnɨmɨŋ, gos nak ke nɨŋeban ar ak nep yɨp gɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jisas nɨb agɨl, adɨk gɨl bɨ ne omal nokɨm mɨdelak sɨŋak apɨl nɨŋak, kɨri pɨs nep wɨsɨn kɨn amnɨlak. Nɨb ak, ne Pita nop agak, “Saimon, ti gɨnɨg gɨl wɨsɨn kaneban? Yokop aua nokɨm alap nep nɨŋ mɨdenɨmɨn rek ma lɨp ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nɨb agɨl, bɨ ne okok kɨrop agak, “Cɨn tap tɨmel gɨjɨn rek lɨp, agɨl, nɨŋ rep gɨl, God nop sobok gɨlɨg gɨ mɨdenɨmɨb. Gos nɨbi ak gɨnɨmɨb rek lɨp ak pen mɨb goŋ nɨbi yɨrɨk marɨk gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nɨb agɨl, kauyaŋ adɨk gɨ amɨl, Nap nop ned sobok gak rek, kauyaŋ sobok gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pen kauyaŋ adɨk gɨ apɨl nɨŋak, bɨ ne okok pɨs nep wɨsɨn kal apek kɨn amnɨlak. Nɨŋɨl, kɨrop agak, “Nɨbi wɨsɨn kɨnebɨm ar?” agak. Agek, nabɨŋ dɨl, pen agnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pen Jisas kɨsen amɨl, adɨk gɨ apɨl kauyaŋ wɨsɨn kɨnelak ak nɨŋɨl agak, “Nɨbi yokop kɨn mɨdebɨm ar? Me tep! Ne bɨr owɨp. Nɨbi nɨŋɨm! Bɨ alap apɨl, Bɨ Ñɨ ne kain gɨl, bɨ tap si tap tɨmel gɨpal okok kɨrop ñɨnɨg geb. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Warɨkem amnɨn! Nɨŋɨm! Bɨ yɨp kain gɨp apeb aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas kɨrop mɨnɨm nɨbak agek nɨŋlɨg gɨ, magɨl nɨbak nep, bɨ ne aknɨb umɨgan alaŋ bɨ alap, Judas, bɨ koŋai nep poŋ dɨl apjakak. Bɨ nɨb okok, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, ag yokel olak. Kɨri tu par kɨd ognap dɨl, yɨr pakep ognap dɨl, olak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ned kɨrop ag lɨl agak, “Yad bɨ alap nop amɨl ag wasu dɨl, tɨg bom sɨlokɨl, mɨlɨk ñɨbenɨgain ak, bɨ me elek, agɨl, nop tɨg cɨcɨ lɨl, dɨ wös gɨl dad amnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Jisas mɨdek sɨŋak amjakɨl, “Mɨnɨm ag ñeb bɨ,” agɨl, nop dɨ bom sɨlokek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","bɨ ognap apɨl, Jisas nop tɨg cɨcɨ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jisas tɨg cɨcɨ lel nɨŋlɨg gɨ, Jisas bɨ ne alap warɨkɨl, tu par kɨd ne ak dɨ lɨp gɨ dɨl, bɨ God nop tap sobok gep bɨ kɨb yɨb ak wög nop gɨ ñolɨgɨp bɨ ak, nop tɨmɨd pɨs kɨd ak pɨs nep tɨb ajaŋ ñag yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pen Jisas bɨ nop tɨg cɨcɨ lɨlak okok kɨrop agak, “Nɨbi tu par kɨd dɨl, yɨr pakep dɨl, yɨp tap si pɨlɨ gɨ dep bɨ alap, agɨl, apebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yad per per God sobok gep karɨp ak amɨl, nɨbep eip mɨdɨl, bin bɨ okok kɨrop mɨnɨm ag ñölɨgɨpin ak pen yɨp tɨg cɨcɨ ma lɨpek. Pen mɨñi kɨri God Mɨnɨm ak ñu kɨl tɨkɨl aglak rek nep gebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pen won nɨbak nep, Jisas bɨ ne okok magɨlsek nop kɨrɨg gɨl pɨrɨk gɨ am saklak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bɨ praj alap, walɨj parsek alap nep yɨmɨl, Jisas nop dad amelak ak kɨsen amek, nop abe tɨg cɨcɨ lɨn, agel, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pɨrɨk amek, walɨj par nop ak tɨg ju del, ne magɨl nep pɨrɨk amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisas nop dam, bɨ God nop tap sobok gep bɨ kɨb yɨb karɨp ak amnɨlak. Dad amelak, bɨ God nop tap sobok gep bɨ kɨb okok lɨl, bɨ mɨnɨm tɨg bɨlokep okok lɨl, bɨ lo mɨnɨm ag ñeb bɨ okok lɨl, apɨl karɨp nɨbak mogɨm gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita pen lɨsɨm lɨsɨm nɨŋ damɨl, bɨ God nop tap sobok gep bɨ kɨb yɨb karɨp ne ak amjakɨl, bɨ karɨp nɨbak wög gelak okok eip bɨsɨg gɨl, mab maŋɨl mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bɨ God nop tap sobok gep bɨ kɨb okok abe, Juda Kansol kɨb bɨ okok magɨlsek abe, Jisas gɨ tagolɨgɨp mɨnɨm wagɨn alap dɨl, nop ñag pak lɨn, ag pɨyo nɨŋ mer nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bin bɨ koŋai nep dapel, Jisas nop mɨnɨm esek ar ognap aglak ak pen mɨnɨm aglak ak adɨp adɨp ma aglak. Ke ke agel, mɨnɨm wagɨn ognap ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pen ognap warɨkɨl, tom agɨl, aglak, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Cɨn nɨŋ mɨdon, ne agak, ‘God sobok gep karɨp, ñɨnmagɨl dɨl gɨlak aul, yad tɨb wal gɨ yokɨl, ñɨn omal nokɨm ak, kauyaŋ gɨ lɨnɨgain. Kɨri ñɨnmagɨl dɨl gɨpal rek ma gɨnɨgain; yad ke karɨp kɨsen nɨb gɨnɨgain,’ agak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mɨnɨm aglak nɨbak ak rek nep adɨp adɨp ma aglak; ke ke aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bɨ God nop tap sobok gep bɨ kɨb yɨb ak warɨkɨl, Jisas nop agak, “Mɨnɨm nep agebal ak, nak mɨnɨm pen alap ma ageban aŋ?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Agek, Jisas mɨnɨm alap pen ma agek, kauyaŋ ag nɨŋɨl agak, “Nak me Mesaia ak, Bɨ Kɨb tep ak Ñɨ ne ak akaŋ?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Agek, Jisas agak, “Yau me. Me yad nep. Yad, Bɨ Ñɨ ne, Bɨ Kɨb kɨlɨs ke yɨb ñɨnmagɨl yɨpɨd pɨs ar ne bɨsɨg mɨd kɨrɨg gɨl, seb kab ar alaŋ sɨŋak nɨb, kɨmi bad nab nab lɨl apenɨgain, nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Jisas nɨb agek, bɨ God nop tap sobok gep bɨ kɨb yɨb ak, walɨj ne okok ke tɨg bɨl bɨl gɨlɨg gɨ agak, “Ne God yɨb ne ak tɨb juosɨp ak bɨr nɨpɨm! Nɨb ak, bin bɨ ognap ma ag nɨŋjɨn. Ne gɨ tɨmel gɨp ak mɨseŋ agɨp me ak. Nɨb ak, nɨbi tari gos nɨŋebɨm?” agak. Agek, bɨ kɨb okok magɨlsek warɨkɨl, aglak, “Bɨ nɨb gɨl ageb nɨbak, nop ñag pak lep,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nɨb agɨl, bɨ ognap Jisas nop kɨñɨk ñagɨl, walɨj bad alap dɨ udɨn nop ak karɨk ñɨl, nop paklɨg gɨ aglak, “Nak ke nɨŋɨl, cɨnop agek nɨŋɨn, nep bɨ an pakeb?” aglak. God sobok gep karɨp bɨ polisman okok, ak rek nep nop tapɨn magɨl nep paklak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita amɨl bɨsɨgak sɨŋak nep mɨdek nɨŋlɨg gɨ, bin praj alap, bɨ God nop tap sobok gep bɨ kɨb yɨb ak nop wög gɨ ñolɨgɨp alap apjakɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita mab tɨn kab mɨdek sɨŋak nɨŋɨl, agak, “Nak ak rek nep Jisas bɨ Nasaret nɨb ak eip ajenak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Agek, Pita agak, “Nak tari ageban? Mɨnɨm ageban ak adi ma nɨpin,” agak. Nɨb agɨl, mɨs eyaŋ amek nɨŋlɨg gɨ, kɨlokɨl sɨk agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bin praj nɨbak nep, Pita nop kauyaŋ nɨŋɨl, bin bɨ mɨdelak okok kɨrop agak, “Bɨ aul bɨ ne alap,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Agek, Pita kauyaŋ mer agak. Yokop magɨl alap mɨdɨl, bin bɨ warɨk mɨdelak nɨb okok, Pita nop kauyaŋ aglak, “Nak ak rek nep karɨp lɨm Galili nɨb ak me, cɨn nɨpɨn nak abe bɨ ne alap,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Agelak, Pita agak, “Bɨ Kɨb nɨŋ mɨdeb; tom agen, yɨp ñag pak lɨnɨgab. Pen nɨŋɨd yɨb agebin! Bɨ nɨb agebɨm ak yad ma nɨpin yɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nɨb agek nɨŋlɨg gɨ, kɨlokɨl ak kauyaŋ sɨk agak. Sɨk agek, Pita Jisas ned agak, “Kɨlokɨl sɨk omal ma agnɨgab won ak, ‘Yad Jisas nop ma nɨpin,’ agɨl, yɨj omal nokɨm we ñɨnɨgan,” agak mɨnɨm ak nɨŋek, mapɨn gek, sɨl kɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kɨslɨm sek, bɨ God nop tap sobok gep bɨ kɨb okok lɨl, bɨ lo mɨnɨm ag ñeb bɨ okok lɨl, bɨ mɨnɨm tɨg bɨlokep okok lɨl, Juda Kansol bɨ kɨb okok magɨlsek lɨl, magɨlsek mɨnɨm ag bɨm gɨl, Jisas nop nag lɨl, dam gapman bɨ kɨb Pailot mɨdek sɨŋak dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dad amel, Pailot Jisas nop agak, “Nak Juda bin bɨ kiŋ kɨri ak akaŋ?” agak. Agek, Jisas agak, “Me nak apan me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bɨ God nop tap sobok gep bɨ kɨb okok Jisas mɨnɨm kɨb agɨl mɨnɨm ke ke koŋai nep aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nɨg gek, Pailot Jisas nop agak, “Nep mɨnɨm koŋai agebal ak, nak pen mɨnɨm ognap ma ageban aŋ?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Agek, Jisas pen mɨnɨm ma agek, Pailot gos par yɨb nep nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pen Juda kai Pasopa ñɨn kɨb ak apek, per amɨl Rom gapman bɨ kɨb Pailot nop ag nɨŋel, kɨrop bɨ nagɨman kɨri ag nɨŋölɨgɨpal bɨ ak nep yokop ag söŋ yokolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pen mɨnek nɨbak, bɨ alap yɨb ne Barabas bin bɨ ognap dɨl, Rom gapman eip pen pen gɨl, cɨp ñag pak lɨlak rek, kɨrop mɨñ lel mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bin bɨ okok ap mogɨm gɨl, Pailot nop bɨ nagɨman per ag nɨŋölɨgɨpal rek ag nɨŋel, ");
INSERT INTO kmh_m_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailot kɨrop agak, “Juda kiŋ kɨb nɨbi ak, nɨbep wɨsɨb yoknɨm aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tari gɨnɨg: Pailot ne ke nɨŋak, bɨ God nop tap sobok gep bɨ kɨb okok, Jisas nop yokop mɨlɨk yapek, nop dap ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pen bɨ God nop tap sobok gep bɨ kɨb okok, bin bɨ okok kɨrop aglak, “Pailot nop agem, Jisas mer, Barabas nop wɨsɨb yoknɨmɨŋ,” aglak. Nɨg gel, bin bɨ okok Pailot nop aglak, “Barabas nop cɨnop wɨsɨb yokan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nɨb agelak, Pailot agak, “Nɨb apɨm ak, pen bɨ nɨbaul nɨbi Juda kiŋ cɨn apɨm ak, nop tari gɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Agek, kɨri mɨnɨm bleble gɨl aglak, “Nop mab bak alaŋ ñag pak lan!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Agelak, Pailot agak, “Ne tari gɨ tɨmel gek, nop nɨg gɨnɨm?” agak. Nɨb agek pen kɨri bleble yɨb gɨl aglak, “Mab bak alaŋ ñag pak lan!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pen Pailot, mɨnɨm kɨlɨs aglak nɨbak dɨl, bin bɨ okok kɨrop tep gaŋ, agɨl, Barabas nop yokop ag yokɨl, bɨ ne ognap kɨrop agek, Jisas nop nag lɨl, tapɨn magɨl paklak. Jisas nop pak dai juel nɨŋlɨg gɨ, Pailot agak, “Nop dam mab bak alaŋ ñag pak lɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami bɨ okok, Jisas nop dam gapna Pailot karɨp ne mɨgan eyaŋ dad amɨl, bɨ yakam kɨri magɨlsek kɨrop sɨk agel apelak, ");
INSERT INTO kmh_m_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","walɨj lakañ parsek alap, gapman bɨ kɨb okok tol gɨ mɨdelɨgɨpal rek Jisas nop tɨm ñɨl, tap ñu ñu sek ognap tɨk dapɨl, kiŋ tol gɨpal usajɨl bad rek alap gɨl, nop nabɨc alaŋ tol gɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tol gɨ ñɨl, Jisas nop aleb aleb ñɨlɨg gɨ aglak, “Nak Juda kiŋ kɨb per nep mɨdenɨmɨn!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nɨb agɨl, yɨr dɨl, nabɨc nop pakɨl, nop kɨñɨk ñag ñɨlak. Mɨdek ulep sɨŋak kogɨm yɨmɨl, kɨri kiŋ nop gölɨgɨpal rek, nop kɨbor kɨyan gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nop nɨg gɨl ag juɨl, walɨj lakañ parsek nop tɨm ñɨlak ak tɨg ju yokɨl, walɨj ne ke ak yɨm ñɨl, mab bak alaŋ ñag pak lɨnɨg dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kɨri nab sɨŋak amlɨg gɨ, Aleksada Rupas mamɨl mal nap kɨri Saimon, Sairini taun nɨb bɨ ak, okok gɨ tagɨl, apɨl Jerusalem amnɨg amek ak, nop nabɨŋ pakɨl, kɨlɨs gɨl, aglak, “Jisas mab kros ak dɨ ka gɨl dad noŋ!” agel, dɨl kɨrop eip amnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nɨg gɨl amɨl, Jisas nop damɨl karɨp lɨm sɨŋak mɨnɨm yɨb yɨb Golgota agölɨgɨpal kau sɨŋak amjaklak. Golgota mɨnɨm wagɨn ak “Cɨp Nabɨc Cög Tɨŋɨl.” ");
INSERT INTO kmh_m_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Amjakɨl, kɨri ñɨg wain alap dɨl, marasɨn mö apal ognap dɨ pɨŋɨl adɨk madɨk gɨl, Jisas nop ñɨlak pen ma ñɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jisas nop mab bak alaŋ ñag pak lɨl, walɨj nop okok dɨl, nonɨm lɨ ke ke dɨnɨg, sadu rek gɨlɨg gɨ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pɨb kɨslɨm sek lɨm gɨ yokɨl yokop sɨŋeped alaŋ owak won ak, Jisas nop mab bak alaŋ cɨpɨl pak lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cɨpɨl pak lɨl, tari gɨnɨg ñag pak lɨlak mɨnɨm ak, mab kros bak ar alaŋ ñu kɨl tɨklak: ");
INSERT INTO kmh_m_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mɨnek nɨbak, bɨ tap si dep omal ak rek nep ñag pak lɨlak, alap ñɨn yɨpɨd gɨl pɨs kɨd, alap ñɨn aŋɨdken pɨs kɨd. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Gɨlak nɨbak, God Mɨnɨm ak ñu kɨl tɨkɨl, gɨnɨgal aglak rek nep gɨlak. Mɨnɨm nɨbak ñu kɨl tɨkɨl aglak, “Nop nɨŋel, bɨ tap tɨmel gep alap rek lɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bin bɨ okok ap ran ap yaplɨg gɨ, Jisas nop nɨŋɨl, nabɨc gor mar gɨl, nop ag julɨg gɨ aglak, “Nak, ‘God sobok gep karɨp ak tɨb wal gɨl, ñɨn omal nokɨm kauyaŋ gɨ lɨnɨgain,’ agnak ak, ");
INSERT INTO kmh_m_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mɨñi nak ke gɨl, mab kros bak alaŋ kɨrɨg gɨl, lɨm wagɨn eyaŋ yapɨl komɨŋ amnoŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, Jisas nop ak rek nep ag julɨg gɨ, kɨri ke nep pen agek pen agek gɨl aglak, “Bin bɨ ognap kɨrop gek komɨŋ amnɨlak ak pen mɨñi nod ke gek komɨŋ amnɨmɨŋ rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ne per agɨp, ‘Isrel bin bɨ Mesaia mɨdebin, Isrel Kiŋ mɨdebin,’ agɨp rek, mɨñi nop mab kros bak sɨŋ alaŋ cɨpɨl pak lɨpal ak, ne ke ak rek nep warɨkɨl wagɨn eyaŋ yapɨl sɨŋaul apek, nɨŋɨl nɨŋɨd agɨp, agɨl, nop nɨŋ dɨnɨgabɨn,” aglak. Pen bɨ Jisas eip ñag pak lɨlak omal Jisas nop ak rek nep ag jurek. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pɨb nab sɨŋepel owak won ak, kɨslɨm gɨl, mɨd damɨl, pɨb kim gak won ak kauyaŋ melɨk gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Melɨk gek nɨŋlɨg gɨ, Jisas meg mɨgan dap ranɨl, sɨk agɨl agak, “Eloi, Eloi, lama sabaktani?” agak. Hibru mɨnɨm agak nɨbak mɨnɨm wagɨn ak, “God yad. God yad. Yɨp ti gɨnɨg kɨrɨg gɨpan?” ");
INSERT INTO kmh_m_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Agek, bin bɨ ulep nɨb sɨŋak mɨdelak okok nɨŋɨl aglak, “Nɨŋɨm! Ne Ilaija nop sɨk ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pen bɨ alap tap sain matres rek bad alap dɨl, ñɨg wain mani sɨkol taupal mɨgan eyaŋ tauɨl, Jisas nop ñen ñɨŋaŋ, agɨl, gamɨl par alap dɨ kabɨs ñagɨl, mɨdek ar alaŋ ñɨlɨg gɨ, agak, “Cɨn nɨŋ mɨdon, Ilaija apɨl, nop tɨg asɨk dap lɨm wagɨn eyaŋ lɨnɨgab aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nɨb agɨl, nɨŋ mɨdel nɨŋlɨg gɨ, Jisas sɨk kɨb agɨl, ake bad kɨr gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Won nɨbak nep, walɨj par kɨb God sobok gep karɨp magɨl ñɨlɨk mɨgan eyaŋ kɨjoŋ pɨlɨŋ gɨlak ak, nab sɨŋak pak bɨl bɨl gɨl, ke ke pɨs pɨs amɨl mɨgan yɨk mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bɨ ami okok kod mɨdek bɨ kɨb ak, mab kros bak nab sɨŋaul ar sɨŋ alaŋ mɨdek ak, Jisas nɨb agɨl kɨmak ak nɨŋɨl, agak, “Nɨŋɨd! Bɨ nɨbaul God Ñɨ ne yɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Bin koŋai nep Jisas eip Jerusalem olak okok, apɨl gol sɨŋak mɨdelak. Nab nɨbak, bin omal nokɨm Jisas nop kɨsen gɨl wög ognap gɨ ñölɨgɨpal karɨp lɨm Galili. Bin Maria omal mɨderek; bin yɨb alog nɨb omal, alap Magdala taun nɨb, alap Jems Josep mamɨl mal nonɨm kɨri ak. Bin alap yɨb ne Salomi. Bin nɨb okok magɨlsek nɨŋ mɨdel nɨŋlɨg gɨ, Jisas kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Josep bɨ Arimatia taun nɨb, Juda Kansol kɨb bɨ gep alap, God bin bɨ dɨl kod mɨdenɨgab ñɨn nɨbak kod mɨdolɨgɨp. Bɨ nɨbak, tol God nop sobok gep ñɨn ak, mɨñi tap gɨ jɨn gep, agɨl, tap gɨ jɨn gek. Jisas kɨmak ak nɨŋɨl, karɨp maŋ dɨgnɨg geb, agɨl, mɨñi cɨp se tɨg asɨk dam tɨgel gɨnɨm, agɨl, ma pɨrɨkak; Pailot mɨdek ak amɨl, ag nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ag nɨŋek, Pailot, Jisas bɨr kɨmak mɨnɨm ak nɨŋɨl, pak ju dɨl, bɨ ami sɨkop kod mɨdek bɨ kɨb ak nop sɨk agek, apek, ag nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ag nɨŋek agak, “Mɨdarɨk kɨmɨb,” agak. Nɨb agek, Pailot Josep nop agak, “Yau. Cɨp se dam tɨgel gan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Agek, Josep walɨj tɨd kɨb alap tauɨl, amɨl cɨp se tɨg asɨk dap yapɨl, walɨj ak dɨ magɨlsek kom kam gɨl, damɨl kab mɨgan kɨsen nɨb nep jɨrɨk lɨlak kab mɨgan ak tɨgel gak. Tɨgel gɨl, kab salai kɨb alap tɨg go ga gɨ damɨl, cɨp tɨgel kɨjoŋ ak pɨlɨŋ gak. ");
INSERT INTO kmh_m_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdala eip, Maria Josep nonɨm ak eip, nɨŋ mɨdel nɨŋlɨg gɨ, cɨp tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juda God nop sobok gep ñɨn kɨri ak ap padɨkek, Maria Magdala ak, Maria Jems nonɨm ak, bin Salomi ak, cɨp se ak wel lɨ ñɨjɨn, agɨl, amɨl wel ki tep owep ognap tau dap lel kɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mɨnek Sade kɨslɨm sek warɨkɨl, pɨb bɨr kɨsen nep lɨm gɨ yokek, cɨp tɨgel gɨlak sɨŋak amelak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kanɨb nab sɨŋak amlɨg gɨ aglak, “Kab kɨb cɨp tɨgel kɨjoŋ pak pɨlɨŋ gɨlak ak, bɨ an tɨg kɨlɨlɨ gɨ gol okok yoknɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nɨb agɨl, amjakɨl nɨŋlak, kab kɨb yɨb cɨp tɨgel kɨjoŋ pak pɨlɨŋ gɨlak nɨbak, bɨr lɨlɨg gɨ amɨl gol sɨŋak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nɨŋɨl, kɨri mɨgan nɨbak sɨkɨd amɨl nɨŋlak, bɨ praj walɨj tɨd parsek yɨmak alap, ñɨnmagɨl yɨpɨd pɨs ken bɨsɨg mɨdek. Nop nɨŋɨl pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pɨrɨkelak, kɨrop agak, “Ma pɨrɨknɨmɨb. Yad nɨpin, nɨbi Jisas bɨ Nasaret nɨb, mab bak alaŋ ñag pak lɨlak ak nop nɨŋnɨg apebɨm. Pen nɨŋɨm! Ne sɨŋaul ma mɨdeb. Ne mɨdarɨk nep warɨkɨl amɨb. Nop tɨgel gɨl lɨlak kau aul ap nɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pen kasek amɨl, bɨ ne okok Pita eip agnɨmir, ‘Jisas ne ned amɨl Galili mɨdenɨgab. Ne ke nɨbep ned agak rek, nɨbi amɨl nop nɨŋnɨgabɨm nɨb okok,’ agnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nɨb agek, bin okok jel gek, ñɨn tob jep jep dek, cɨp tɨgel söŋ amɨl kɨrɨg gɨl, pɨg gɨ rɨkɨd ag amnɨlak. Pɨrɨklak nɨŋɨl bin bɨ ognap kɨrop mɨnɨm nɨbak ma ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas kɨmɨl, ñɨn sabdaŋ eyaŋ ak warɨkɨl, ned yɨb amɨl, Maria Magdala mɨdek sɨŋak mɨseŋ lek, nop nɨŋak. Pen bin nɨbak nop ned kɨjeki kɨyob ñɨlɨk aknɨb ar oŋɨd ak abaŋ ñag mɨdek nɨŋɨl Jisas ag mɨs yokak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Ne Jisas nop nɨŋɨl, amɨl bɨ ne okok sɨl ag mɨdelak nab sɨŋak amɨl, Jisas komɨŋ mɨdeb nop nɨpin, agek, kɨri pɨs nep kɨmɨb, agɨl, mɨnɨm nop ak ma nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kɨsen pen, Jisas bɨ ne omal karɨp lɨm mɨgan alap gɨ ajerek, Jisas bɨ aknɨb ke rek lɨl apɨl, kanɨb nab sɨŋak mɨseŋ lek, nop nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","amɨl bɨ ne ognap kɨrop ag ñerek ak pen, nɨŋɨd agebir, agɨl, mɨnɨm kɨrop ma nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kɨsen mɨnek alap me, Jisas bɨ ne aknɨb agɨp alaŋ tap ñɨb mɨdel nɨŋlɨg gɨ, Jisas nab kɨri sɨŋak mɨseŋ lek, nop udɨn kɨri ke nɨŋel, kɨrop ag gɨl agak, “Yad warɨken, bin bɨ ognap yɨp mɨseŋ nɨŋɨl, apɨl nɨbep ag ñel, tari gɨnɨg tom agebal, ma warɨkɨp, agɨl gos nɨpɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nɨb agɨl, kɨrop agak, “Nɨbi mɨnɨm tep yad ak damɨl karɨp lɨm tɨgoŋ tɨgoŋ magɨlsek amɨl, bin bɨ okok magɨlsek ag ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bin bɨ an an, mɨnɨm tep yad ak nɨŋ dɨl, ñɨg paknɨgal okok, komɨŋ amnɨgal. Pen bin bɨ an an, mɨnɨm tep yad ak ma nɨŋ dɨnɨgal okok, God kɨrop mɨnɨm kɨb agek yur dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Bin bɨ mɨnɨm yad nɨŋɨl, ‘Nɨŋɨd ageb,’ agɨl, nɨŋ dɨnɨgal okok, tap ma gep rek ognap gɨnɨgal. Kɨjeki kɨyob ñɨlɨk tap okok bin bɨ kɨrop abaŋ lɨnɨgab okok, yɨb yad ak agɨl, ag mɨs yoknɨgal. Mɨnɨm yɨb kɨri ke ak kɨrɨg gɨl, mɨnɨm kɨsen nɨb ar alap ke agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Toi gadkol bin bɨ suɨp okok dɨ nɨŋel, tap alap kɨrop gek ma kɨmnɨgal. Tap tɨmel bin bɨ ñɨbɨl kɨmbal okok ognap ñɨbel, tap alap gek ma kɨmnɨgal. Pen bin bɨ tap gɨnɨgab okok, kɨrop ñɨnmagɨl lel, komɨŋ lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bɨ Kɨb Jisas mɨnɨm nɨbak kɨrop ag mɨbɨl juek nɨŋlɨg gɨ, God nop dɨl, karɨp lɨm ne seb kab ar alaŋ sɨŋak dad amnak. Dad amek, God ñɨnmagɨl yɨpɨd pɨs ar nop ar bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pen bɨ ne okok amɨl, Jisas mɨnɨm tep ak karɨp lɨm yɨmñak yɨmñak magɨlsek ag ñel amek nɨŋlɨg gɨ, Bɨ Kɨb, mɨnɨm tep yad nɨŋɨd nep lɨnɨmɨŋ, agɨl, kɨrop eip mɨdɨl, kɨlɨs ñek, tap ma gep rek okok gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jisas Krais nab cɨnop aul tɨk dapel kɨb gɨl gak gak rek, bɨ ognap udɨn magɨl kɨri ke nɨŋɨl, mɨnɨm tep nɨbak ag ñɨ ajɨl, yɨp abe, bin bɨ okok ognap sek kɨrop abe, ag ñɨlak. Ag ñelak bɨ koŋai rek mɨnɨm nɨbak nɨŋ tep gɨl ñu kɨl tɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pen bɨ kɨb Tiopilas, yad ak rek nep mɨnɨm yɨp ag ñɨlak nɨbak wagɨn ak magɨlsek pɨyo nɨŋ tep gɨpin ak me, yad ak rek nep mɨnɨm nɨbak magɨlsek gos nɨŋ tep gɨl, nep ñu kɨl tɨknɨg gebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nɨg gen me, mɨnɨm nep aglak nɨpan ak, nɨŋɨd aglak agɨl nɨŋnɨgan. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ned Kiŋ Herod Judia Propins kod mɨdolɨgɨp ñɨn ak, bɨ nak Sekaraia, God nop tap sobok gep bɨ alap mɨdolɨgɨp. Bɨ yakam ne eip wög jɨm ñɨl gölɨgɨpal okok kɨrop Abaija Yakam agölɨgɨpal. Sekaraia bin ne Ilisabet. Ilisabet ak rek nep God nop tap sobok gep bɨ Eron wagɨn ak tɨk damɨl dapɨl gɨl tɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kɨri ber mal God lo mɨnɨm ar ak magɨlsek sain gɨlɨg gɨ mɨdel, God nɨŋek, mɨnɨm alap ma mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pen Sekaraia bin ne Ilisabet ñɨ pai womleb ak me, ñɨ pai alap tɨk dapɨl mer, pɨs nep bin mɨlep bɨ mɨlep lɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ñɨn alap Sekaraia bɨ ne eip wög jɨm ñɨl gölɨgɨpal bɨ okok apɨl, God nop sobok gep wög ak gelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pen wög kɨri ak gɨlɨg gɨ, bɨ God nop tap sobok gep bɨ okok per gölɨgɨpal rek, bɨ cɨn an rek God sobok gep karɨp ñɨlɨk mɨgan eyaŋ amɨl tap ki tep owep ak dagɨlnɨgab, agɨl, yɨr bopɨs tɨg gɨlɨg gɨ dɨlak. Del, Sekaraia ne yɨr bopɨs ke tɨg gɨlɨg gɨ dɨl, God sobok gep karɨp ñɨlɨk mɨgan eyaŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bin bɨ koŋai nep God sobok gep karɨp söŋ adek sɨŋak God nop sobok gɨlɨg gɨ mɨdelak nɨŋlɨg gɨ, Sekaraia ne ñɨlɨk mɨgan eyaŋ amɨl tap ki tep owep nɨbak dagɨlek. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pen Bɨ Kɨb ejol ne alap apɨl, tap ki tep owep dagɨlelɨgɨpal kab kɨnaŋ ak ñɨnmagɨl yɨpɨd adek kɨd mɨseŋ warɨk mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ejol nɨbak nɨŋɨl pak ju dak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pen ejol nɨbak nop agak, “Nak ma pɨrɨknɨmɨn. God nop sobok gɨpan ak, ne nɨŋɨp. Bin nak Ilisabet ñɨ nak alap tɨk donɨgab. Tɨk dapek, yɨb ne Jon agnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nonɨm ñɨ ak tɨk donɨgab ak, nak mɨñ mɨñ gɨnɨgan; bin bɨ koŋai nep okok ak rek nep mɨñ mɨñ gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bɨ Kɨb udɨn yɨrɨk ar ne ak, Jon bɨ kɨb rek mɨdenɨgab. Ne ñɨg wain aka ñɨg kɨlɨs ognap ma ñɨŋnɨmɨŋ. Nonɨm ñɨ kogi mɨdenɨgab ñɨn nɨbak nep, Kaun Sɨŋ ne ñɨ nɨbak nop nab adaŋ amɨl ap ran jaknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kɨsen ne Isrel bin bɨ God nop kɨrɨg gɨpal okok koŋai nep mɨnɨm tep ag ñek, God nop, Bɨ Kɨb cɨn, agɨl, nɨŋ dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pen ñɨ nak nɨbak ne bɨ God mɨnɨm agep Ilaija bɨrarɨk nep God kɨlɨs dɨl golɨgɨp rek gɨnɨgab. Nap sɨkop kɨrop dɨl, ñɨ pai kɨri okok dɨl, kɨrop dɨ jɨm ñɨl lɨnɨgab. Bin bɨ God nop aleb aleb ñɨbal okok, kɨrop mɨnɨm tep ag ñek, bin bɨ komɨŋ tep ne gos nɨpal rek nɨŋɨl, gɨ tep gɨl, Bɨ Kɨb onɨgab, agɨl, kod mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ejol ak nɨb agek, Sekaraia agak, “Cɨr ber mal mɨlep yɨb lɨpɨr. Nɨb ak, yad titi gɨl, nak nɨŋɨd apan, agɨl nɨŋnɨgain?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Agek, ejol ak Sekaraia nop agak, “Yad Gebriel. Yad God udɨn yɨrɨk adek ak mɨdɨl, yɨp ag yokek apɨl mɨnɨm tep nɨbaul nep ag ñɨnɨg opin. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nak mɨnɨm yad agesin ak, nɨŋɨd ageb agɨl ma nɨpan rek, aleb nep ak mɨker gek, mɨnɨm aglɨg gɨ ma mɨdenɨgan. Yokop nep mɨd mɨd, ñɨ ak tɨk donɨgair mɨnek ak nep kauyaŋ mɨnɨm agnɨgaban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pen Sekaraia God sobok gep karɨp nab ñɨlɨk eyaŋ mɨlek par mɨdek nɨŋɨl, bin bɨ söŋ eyaŋ mɨdelak okok gos par nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kɨsen ne söŋ apɨl, mɨnɨm ognap agnɨmɨŋ rek ma lak. Nɨb ak, yɨp nɨg nɨg gɨp, agɨl, ñɨnmagɨl nep yomek. Kɨri nɨŋɨl aglak, ne karɨp ñɨlɨk mɨgan eyaŋ am mɨdɨl, nɨgrɨkep alap ke nɨŋɨl owɨp, agɨl, nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pen Sekaraia God sobok gep karɨp wög ak gɨ mɨdek, ñɨn ne ak padɨkek, bɨ ognap apɨl kau ne ak del nɨŋlɨg gɨ, ne adɨk gɨ karɨp ne amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Kɨsen mɨd damɨl, bin ne Ilisabet ñɨ pabag mɨdɨl agak, “Ned yad bin ñɨ pai womleb mɨdölɨgɨpin ak me, yɨp nabɨŋ gak, pen mɨñi Bɨ Kɨb yɨp yɨmɨg nɨŋɨl kod mɨd tep gek, ñɨ pabag mɨdebin ak yɨp nabɨŋ ma gɨnɨgab, mer,” agak. Nɨb agɨl, takɨn aknɨb mamɨd kapkap karɨp ñɨlɨk mɨgan okok nep we gɨl mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet takɨn aknɨb kagol oŋɨd ñɨ kogi mɨdek nɨŋlɨg gɨ, God ejol Gebriel nop ag yokek amnak Nasaret taun, karɨp lɨm Galili sɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nasaret sɨŋak bin praj alap mɨdolɨgɨp, yɨb ne Maria. Bin praj nɨbak bɨ alap eip gɨ gek mer. Bin praj nɨbak, bɨ nak Josep dɨnɨgab, agɨl mɨnɨm aglak. Bɨ Josep nɨbak, nop kiŋ Depid bɨ kɨgɨn nɨbak alap tɨk dam lɨlak ak me. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","God ejol Gebriel ag yokek, bin praj Maria mɨdek sɨŋak amjakɨl agak, “Bin praj, nak mɨdeban? Bɨ Kɨb nep dɨ tep gɨp. Ne eip mɨdebir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nɨb agek, Maria mɨnɨm nɨbak nɨŋɨl, yɨp ti gɨnɨg nɨb ageb, agɨl, gos par nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne gos par nɨŋek nɨŋlɨg gɨ, ejol nop agak, “Maria, nak ma pɨrɨknɨmɨn. God nep dɨ tep yɨb gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kɨsen nak ñɨ pabag mɨdɨl, ñɨ alap tɨk donɨgan. Tɨk donɨmɨn, yɨb ne Jisas, agnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pen ne bɨ kɨb yɨb mɨdenɨgab. Bin bɨ nop agnɨgal, Bɨ Kɨb yɨb adek i alaŋ mɨdeb Ñɨ ne, agnɨgal. God Bɨ Kɨb genɨgab nɨŋɨl ne nɨsed acɨk Depid kiŋ kɨb mɨdolɨgɨp rek, mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jekop tɨkek tɨk amɨl apɨl gel mɨdenɨgal okok kɨrop magɨlsek per nep per nep kiŋ kɨri mɨdɨl kod mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ejol nɨb agek, Maria nop pen agak, “Yad bɨ alap eip ma mɨdobɨr ak, titi gɨl ñɨ nɨbak tɨk donɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Agek, ejol nop pen agak, “Kaun Sɨŋ ak nep apɨl, Bɨ Kɨb yɨb adek i alaŋ mɨdeb kɨlɨs ne nep kob ñɨnɨgab. Nɨg gek, ñɨ sɨŋ tɨk donɨgan ak, bin bɨ nɨŋɨl agnɨgal, ne God Ñɨ ne, agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nɨŋan! Nawal nak Ilisabet ne bin mɨlep lɨp. Kɨri nop bin ñɨ pai womleb agölɨgɨpal ak pen mɨñi ne ñɨ pabag mɨdeb, takɨn aknɨb kagol oŋɨd bɨr amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God tap ma gɨnɨmɨŋ rek alap ma mɨdeb; tap okok magɨlsek gɨnɨmɨŋ rek nep mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nɨb agek, Maria agak, “Yad God nop wög gɨ ñeb pai. Ageban rek nep yɨp gɨnɨmɨŋ,” agak. Nɨb agek nɨŋlɨg gɨ, ejol nop kɨrɨg gɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Pen Maria kasek amnɨm, agɨl, karɨp lɨm nɨbak kɨrɨg gɨl karɨp lɨm Judia dɨm yɨrɨk okok kanɨb par ak amɨl amɨl, Sekaraia Ilisabet ber mal mɨdölɨgɨpir taun ak amnak. Karɨp kɨri amjakɨl, nuwal Ilisabet nop agak, “Nak mɨdeban?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","“Nak mɨdeban?” agek, nuwal Ilisabet mɨnɨm nɨbak nɨŋek, ñɨ pabag mɨdek ak preŋɨd lak. Pen magɨl nɨbak nep Kaun Sɨŋ ak ne Ilisabet nab adaŋ amɨl nop ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","God Kaun ap ran jakek, Ilisabet ne meg mɨgan dap ranɨl Maria nop agak, “God bin ognap kɨrop kod mɨdeb ak pen nep dɨ tep yɨb gɨp. Ñɨ kogi nak mɨdeban pɨyak ñɨ ak abe dɨ tep yɨb gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yad bin tep mer pen nak Bɨ Kɨb yad nonɨm ne ak, yɨp nɨŋnɨg opan ak, yad wal agɨl, God nop tep agebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nak apɨl yɨp, ‘Mɨdeban?’ agesan magɨl ak, ñɨ kogi mɨdebin aul mɨñ mɨñ yɨb lɨl preŋɨd lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nak, ‘Yɨp God agɨp rek gɨnɨgab,’ agɨl nɨŋ mɨdeban ak me, nak mɨñ mɨñ gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ilisabet nɨb agek, Maria God nop gos nɨŋlɨg gɨ, mɨñ mɨñ yɨb gɨlɨg gɨ agak, “Yad Bɨ Kɨb nop gos nɨŋɨl, yɨb ne agen, i ar alaŋ amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Yad pɨs nep kɨmeb rek mɨdenek, God yɨp cɨb nɨŋɨl dɨ komɨŋ yokak ak, nop gos nɨŋɨl mɨñ mɨñ yɨb gebin. Yad yokop pai nop wög gɨ ñeb mɨdebin ak pen yɨp saköl ma gɨp. Nɨg gɨp ak, mɨñi tɨkɨl, kɨsen tɨkɨl, tɨk dam lɨnɨgal okok, bin bɨ magɨlsek yɨp gos nɨŋɨl agnɨgal, ‘God bin nɨbak dɨ tep yɨb gak,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ne kɨlɨs magɨlsek mɨdeb ak, ne tap kɨlɨs yɨb yɨp gɨp. Yad nɨpin ne nokɨm nep Bɨ Sɨŋ mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bin bɨ mɨnɨm ne nɨŋɨl, kaun dɨl, sain gɨnɨgal okok, kɨrop cɨb nɨŋɨl dɨ tep gɨnɨgab. Kɨri ñɨ pai tɨkɨl, tɨk damɨl, tɨk lɨnɨgal okok, kɨrop ak rek nep cɨb nɨŋɨl dɨ tep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ne Bɨ ñɨnmagɨl par kɨb yɨb; ne tap kɨlɨs kɨlɨs koŋai nep gɨp. Bin bɨ, cɨn ke bin kɨb bɨ kɨb mɨdobɨn, apal okok, God kɨrop yɨk gɨ yokɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nɨb ak, kiŋ bɨ kɨb karɨp lɨm kɨb kod mɨdel yɨb kɨb mɨdolɨgɨp okok, God gek ke ke amel, bin bɨ yɨb ma mɨdolɨgɨp okok, God kɨrop dɨl dɨ pɨŋɨl ar ar gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bin bɨ yuan lɨp okok, God kɨrop tap nonɨm lek ñɨbel kogi gɨp. Pen bin bɨ tap koŋai mɨdeb okok kɨrop yokop ag yokek ambal. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","God ne apɨs based acɨk cɨn okok kɨrop mɨnɨm agak ak saköl ma gɨl, cɨnop Isrel bin bɨ per cɨb nɨŋɨl kod mɨd tep gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Based Ebraham abe, based cɨn ognap abe, ñɨ pai kɨri tɨkɨl tɨkel amnɨgab okok, God kɨrop kod mɨdenɨgain, agɨl, agak rek nep cɨnop gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria mɨnɨm nɨbak agɨl, nuwal Ilisabet eip takɨn omal nokɨm mɨdɨl, kɨsen adɨk gɨ karɨp ne amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mɨd damɨl, Ilisabet ñɨ alap tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","God nop cɨb nɨŋɨl kod mɨdek, ne bin mɨlep yɨb lɨl ñɨ tɨk dowak nɨbak, bin bɨ nɨnai nuwal nɨmam nuwo sɨkop ne okok nɨŋɨl, ne eip mɨñ mɨñ yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ñɨ ak tɨk dapɨl, ñɨn aknɨb ar oŋɨd mɨdɨl, jɨl oŋɨd ñɨn ak ñɨŋaŋ nɨbak waŋ wak ne tɨb gɨ rɨk gɨnɨg gɨ, ap mogɨm gɨlak. Ap mogɨm gɨl, kɨri ñɨ ak nop yɨb ñɨnɨg gɨ aglak, “Ñɨ nɨbaul, nap Sekaraia yɨb ak lak yɨpɨd gep,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Agelak, nonɨm agak, “Mer, yɨb ne Jon agnɨgabɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nɨb agek, bin bɨ ne okok aglak, “Cɨn nɨg ma gɨpɨn. Based baid buwo nak okok yɨb alap Jon ma mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɨb agɨl, nap Sekaraia nop ñɨnmagɨl ak nep yomɨl ag nɨŋlak, “Ñɨ yɨb tari ñɨnɨgan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ag nɨŋel, nap ñɨnmagɨl ak nep yomɨl agak, “Yɨp mɨj ñu kɨl tɨkep alap dowɨm,” agak. Agek dapelak, ar nɨbak mɨnɨm ñu kɨl tɨkɨl, “Yɨb ne Jon,” agak. Nɨg gɨl yɨb ñu kɨl tɨkek, kɨri nɨŋɨl magɨlsek wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pen magɨl nɨbak nep Sekaraia aleb mɨker gak ak auan amek nɨŋlɨg gɨ, ned mɨnɨm agolɨgɨp rek aglɨg gɨ, God yɨb ne agek ar amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bin bɨ ulep sɨŋak kɨn mɨdelak okok, gak nɨbak nɨŋɨl pɨrɨkɨl, mɨnɨm nɨbak yɨg dam karɨp lɨm Judia yɨrɨk okok magɨlsek yɨb, bin bɨ okok kɨrop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ag ñelak, bin bɨ mɨnɨm nɨbak nɨŋlak okok, kɨri magɨlsek gos par nɨŋɨl aglak, “God gek, ñɨ nɨbak nɨg gɨl tɨk dowɨp ak me, kɨsen bɨ tigep bɨ rek mɨdenɨgab?” aglak. God kɨlɨs ñɨ nɨbak eip mɨdek ak nɨŋlak ak me, nɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kaun Sɨŋ ne ñɨŋaŋ nap Sekaraia nab ne adaŋ apɨl ap ran jakak nɨŋɨl God yɨb ne ak dap ranlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Cɨn Isrel bin bɨ, God Bɨ Kɨb cɨn yɨb ne dap ranɨl agon ar amnaŋ. Ne ke karɨp lɨm wagɨn aul apɨl, bin bɨ ne tau adɨk dɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God Bɨ Kɨb ne gek, Depid tɨkek, tɨkel, tɨk amɨl apɨl gel, ñɨŋaŋ alap tɨk dapek cɨnop dɨ komɨŋ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bɨrarɨk nep, mɨnɨm yad bin bɨ okok agnɨgain, agɨl, God ne bɨ ognap wög nɨbak ag lak. God mɨnɨm agep bɨ sɨŋ ne okok kɨri God mɨnɨm agak ak nɨŋɨl, bin bɨ okok kɨrop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bɨ ñag ñɨŋeb cɨn okok apɨl, cɨnop ñag pak lɨnɨg gebal pen ne apɨl cɨnop dɨ komɨŋ yoknɨgab; bɨ cɨnop mɨlɨk yapek nɨpal okok cɨnop gɨ tɨmel gɨnɨg gebal ak pen ne cɨnop kod mɨdek komɨŋ amnɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","God bɨrarɨk nep based acɨk cɨn yɨmɨg nɨŋɨl dɨ tep gɨnɨgain, agɨl, mɨnɨm kɨlɨs nɨŋɨd ognap ag lak. God ne mɨnɨm based cɨn Ebraham nop ag lak ak saköl ma gɨp; mɨnɨm sɨŋ nɨbak agak rek nep gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Bɨ Kɨb cɨnop kod mɨdek, kaual maual okok cɨnop gɨ tɨmel gɨnɨmel rek ma lɨnɨgab. Nɨb ak, cɨn bɨ ñag ñɨŋeb okok ma pɨrɨkɨl, komɨŋ mɨdenɨgabɨn rek, per per nep Bɨ Kɨb nep gos nɨŋɨl, tap si tap tɨmel okok kɨrɨg gɨl, Bɨ Kɨb bin bɨ sɨŋ ne mɨdɨl, wög nop gɨlɨg gɨ, gɨ mɨdonɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pen ñɨ yad, nak God Bɨ Kɨb nop wög gek, bin bɨ okok kɨri nɨŋɨl agnɨgal, ‘God Bɨ Kɨb yɨb ar i oklaŋ mɨdeb ak, bɨ mɨnɨm ne agep me ak,’ agnɨgal. Tari gɨnɨg: nak ned amɨl, bin bɨ okok kɨrop ag ñɨ tep gek, kɨri nɨŋɨl Bɨ Kɨb ak nop kod mɨdel nɨŋlɨg gɨ, ne onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nak bin bɨ ne okok kɨrop mɨnɨm tep ne ak ag ñɨ tep gek, Bɨ Kɨb kɨri ak apɨl, tap si tap tɨmel gɨpal gac ak lɨg gɨ yokɨl kɨrop dɨnɨgab, mɨnɨm tep ak nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God Bɨ sain kapkap tɨkɨl, ne bin bɨ cɨb nɨŋɨl, melɨk tep ne pɨb melɨk rek seb kab ar alaŋ nɨb apɨl, cɨnop melɨk pak ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Cɨn bin bɨ an an kɨslɨm okok mɨdɨl kɨmnɨg gɨnɨgabɨn okok, ne gek melɨk magɨl nɨbak cɨnop mɨdmagɨl nab adaŋ melɨk pak ñɨnɨgab nɨŋɨl, cɨn cɨbur sain sain mɨdep kanɨb tep ak pɨyo nɨŋɨl, ar nɨbak nep ajonɨgabɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pen ñɨŋaŋ nɨbak Jon, kɨb gek nɨŋlɨg gɨ, kaun ne sek sek kɨlɨs gak. Ne karɨp lɨm bin bɨ ma mɨdelɨgɨpal, mɨñ mab kab nep mɨdolɨgɨp nab sɨŋak mɨd mɨd, pɨs nep kɨb gɨl apek, Isrel bin bɨ nop nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pen ñɨn nab nɨbak, gapman bɨ kɨb Sisa Ogastas ne lo lɨl agak, “Bin bɨ yad kod mɨdebin okok, kɨri magɨlsek yɨb kɨri dɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ñɨn nɨbak gapman bɨ kɨb Kwairinias Siria Propins bin bɨ kɨrop kod mɨdolɨgɨp. Ne gapna mɨdek mɨnek ak kɨri ned yɨb kɨri ma dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nɨb ak, bin bɨ karɨp lɨm par kɨb ke okok nɨb apɨl mɨdelak bin bɨ okok, adɨk gɨl karɨp lɨm kɨri ke yɨb dɨnɨg amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ne kiŋ Depid kɨgɨn tɨk damɨl tɨklak rek, ne Depid taun ne Betlehem amnɨg gak. Bin praj Maria nop poŋɨd dɨl, Nasaret taun, karɨp lɨm Galili sɨŋak kɨrɨg gɨl, amɨl amɨl karɨp lɨm Judia amɨl, kiŋ Depid nop tɨkel mɨdolɨgɨp taun ne Betlehem amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pen bin praj Maria, Josep dɨnɨgab aglak ak me, ñɨ kogi sek mɨdek nɨŋlɨg gɨ, Josep Maria nop poŋɨd dɨl yɨb dɨnɨg amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kɨri Betlehem amel, Maria ñɨŋaŋ tɨk dowep ñɨn ak ulep gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pen Betlehem okok amjakɨl nɨŋrek, kab magɨl tauɨl kɨnelɨgɨpal karɨp ak pɨs nep tɨbɨk dak. Nɨb ak me, kaj kau mɨkelɨgɨpal karɨp alap am mɨdɨl, Maria ñɨŋaŋ ned nokɨm ak tɨk dowak. Tɨk dapɨl ñɨŋaŋ laplap kom kam gɨl, dɨ kaj sipsip tap bep kɨsad kas ak tɨk dap lel ñɨbelɨgɨpal mab kɨnaŋ mɨgan ak lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Maria Jisas nop tɨk dowak ñɨn nɨbak, kaj sipsip mɨkep bɨ okok ognap kɨslɨm eyaŋ kaj sipsip kod mɨdelak karɨp lɨm ulep nɨb sɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bɨ Kɨb ejol ne alap ag yokek, Bɨ Kɨb melɨk tep magɨl ne apɨl kɨrop pak nɨŋek, jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kɨri pɨrɨkel nɨŋlɨg gɨ, ejol ak kɨrop agak, “Nɨbi ma pɨrɨknɨmɨb. Yad nɨbep abe bin bɨ okok magɨlsek kɨrop abe, mɨnɨm tep mɨñ mɨñ gep alap dapebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mɨñi nep bin alap ñɨ aknɨb ke alap tɨk dowɨp Depid taun ne sɨŋak. Ñɨ nɨbak nɨbep dɨ komɨŋ yoknɨgab. Ne Krais Bɨ Kɨb ak me. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nop am pɨyo nɨŋɨl nɨŋnɨgabɨm, nonɨm nop walɨj kom kam gɨl, dɨ kaj sipsip tap bep kɨsad kas ak tɨk dap lel ñɨbelɨgɨpal mab kɨnaŋ mɨgan ak lek mɨdenɨgab. Nɨbi am nɨŋɨl, agebin rek gɨnɨgab ak, nɨŋɨd agɨp, agnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ejol nɨbak nɨb agek nɨŋlɨg gɨ, dai ejol seb kab ar alaŋ sɨŋak nɨb koŋai yɨb nep apɨl ejol ned nɨb ak eip mɨdɨl, God yɨb ne ak dap ranlɨg gɨ aglak, ");
INSERT INTO kmh_m_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God yɨb ne i ar oklaŋ mɨdeb; ne bin bɨ an an cɨb nɨŋɨl dɨ tep gɨnɨgab okok, cɨbur sain sain gos mɨdmagɨl ar nokɨm lep magɨl ak kɨri eip mɨdenɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ejol okok adɨk gɨ seb kab ar alaŋ amel nɨŋlɨg gɨ, bɨ kaj sipsip mɨkep okok mɨnɨm ag nɨŋ ag nɨŋ gɨl aglak, “Bɨ Kɨb cɨnop mɨnɨm agosɨp ak, mɨñi Betlehem am nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nɨb agɨl kasek amɨl nɨŋlak, Josep eip Maria eip ñɨŋaŋ aglak nɨbak, walɨj kom kam gɨl, kaj sipsip tap bep kɨsad kas ak dap lel ñɨbelɨgɨpal mab kɨnaŋ mɨgan ak lel mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kɨri ñɨŋaŋ nɨbak nɨŋɨl, amɨl, ejol kɨrop tari tari aglak mɨnɨm ak, bin bɨ okok okok kɨrop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bɨ kaj sipsip mɨkep okok bin bɨ okok mɨnɨm nɨbak ag ñel, kɨri nɨŋɨl magɨlsek wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pen Maria nop tap ke yɨb nɨbak gak rek, tep gek, gos tep nep nɨŋ mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɨ kaj sipsip mɨkep okok, God ejol ne okok aglak rek nep gek udɨn kɨri ke nɨŋlak ak me, God yɨb ne ak dap ranlɨg gɨ, olak okok adɨk gɨ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maria ñɨŋaŋ ak tɨk dapɨl ñɨn aknɨb ar oŋɨd mɨdɨl, mɨnek jɨl ñɨn ak waŋ wak ne tɨb gɨ rɨk gɨlak. Ned ejol ak nonɨm Maria nop, ñɨ tɨk donɨmɨn yɨb ne ak nɨg gɨl lɨnɨmɨn agak rek, yɨb ne ak Jisas, aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Pen ned Mosɨs ne lo mɨnɨm ñu kɨl tɨkɨl, ñɨ ned tɨk donɨgal okok God nop ñɨnɨgal agak. Nɨb ak me, Maria ñɨŋaŋ ak tɨk dapɨl, Juda bin bɨ gölɨgɨpal rek, God sobok gep karɨp ak asɨk mosɨk gɨl, karɨp ne ke okok nep mɨdek, komɨŋ lek nɨŋlɨg gɨ, Josep eip, Jisas nop dam Bɨ Kɨb nop ñɨnɨg, God sobok gep karɨp Jerusalem sɨŋak amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pen Bɨ Kɨb lo mɨnɨm alap sek ageb, “Bin ñɨ pai tɨk donɨgal okok komɨŋ lek, yakɨr malɨg aka yakɨr tɨbaglem omal dam God sobok gep karɨp söŋ eyaŋ amɨl, pak God nop sobok gɨ ñɨl me, pɨs nep komɨŋ lɨp, agɨl, God sobok gep karɨp ñɨlɨk mɨgan ak amnɨgal.” Gos nɨbak ak rek nep nɨŋɨl me, yakɨr omal sek dad amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pen Jerusalem sɨŋak bɨ tep yɨb alap mɨdek, yɨb ne Simion. Bɨ nɨbak ne God Mɨnɨm ak nɨŋɨl, agɨp rek nep golɨgɨp. Kaun Sɨŋ ne Simion eip mɨdek; ne Krais ak Isrel bin bɨ dɨ komɨŋ yoknɨgab, agɨl, kod mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kaun Sɨŋ ne Simion nop ned agak, “Bɨ Kɨb ne Krais nop ag yokek onɨgab ak, nak udɨn magɨl nɨŋɨl kɨsen kɨmnɨgan,” agak nɨŋɨl ne nɨŋlɨg gɨ mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pen ñɨn nɨbak, Kaun ne Simion nop gos ñek, God sobok gep karɨp ak amɨl nɨŋak, Josep ber mal Jisas nop damɨl, lo mɨnɨm agak rek gɨjɨr, agɨl, ap mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion kɨrop mal nɨŋɨl, Jisas nop dɨ kaiŋɨd dɨl, God yɨb nop ak dap ranlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Nak nokɨm nep Bɨ Kɨb. Ñɨŋaŋ aul kɨb gɨl, cɨnop bin bɨ dɨ komɨŋ yoknɨgab ak, ned yɨp agnak rek, mɨñi udɨn magɨl yad ke bɨr nɨŋebin. Nɨb ak, mɨñi yɨp kɨrɨg gek, tep gek nɨŋlɨg gɨ kɨmnɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ñɨŋaŋ nɨbaul, bin bɨ karɨp lɨm okok okok magɨlsek dɨ nep eip jɨm ñɨl lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ne melɨk tep rek apɨl, Juda bin bɨ mer okok kɨrop pak ñek, God bɨ tigep bɨ rek mɨdeb ak nɨŋnɨgal. Ne melɨk tep aknɨb ke nak dapɨl, Isrel bin bɨ nak okok kɨrop pak ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion Jisas nop mɨnɨm nɨbak agek ak nɨŋɨl, Josep ber mal wal yɨb agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pen Simion ne Josep Maria Jisas amɨlgon kɨrop, “God nɨbep kod mɨdeŋ,” agɨl, Jisas nonɨm Maria nop agak, “Ñɨ nɨbaul mɨdek nɨŋlɨg gɨ, Isrel bin bɨ koŋai nep nab ak tɨg asɨk ke ke lɨl, kanɨb tɨmel dɨl amnɨgal okok, ap yap paknɨgal; pen kanɨb tep dɨl amnɨgal okok, God kɨd adek amnɨgal. God Isrel bin bɨ nɨŋlaŋ, agɨl, ñɨ aul ag yokak ak pen bin bɨ ognap nop ma dɨl ag junɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nɨg gɨl me, bin bɨ koŋai nep tari tari gos nɨŋɨl nɨŋ mɨdebal rek, bin bɨ okok mɨseŋ nɨŋnɨgal. Pen tu par kɨd alap mɨdmagɨl nab nep ke adaŋ pɨŋɨl gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pen ñɨn nɨbak nep, God mɨnɨm agep bin alap ap mɨdek. Yɨb ne ak Ana; nap yɨb ak Panuel. Panuel ak, Asa tɨkek tɨk dapɨl tɨklak. Ne bin mɨlep yɨb. Ned bin praj bɨ dɨl, nɨgmɨl eip mɨderek mɨ aknɨb ar oŋɨd yɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nɨgmɨl kɨmak pen Ana mɨ ne ñɨnjuɨl omal omal aknɨb yɨgwu par alaŋ (84) yɨnak. Ne God nop nep gos nɨŋɨl ñɨn ognap tap magɨl ñɨbɨl mer, God sobok gep karɨp ak am mɨdɨl, pɨb nab kɨslɨm eyaŋ God nop sobok gɨlɨg gɨ mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pen bin Ana ak, magɨl nɨbak nep Jisas nop dɨ mɨdelak ulep sɨŋak apɨl, God nop tep agɨl, bin bɨ kɨri, Bɨ Kɨb apɨl Jerusalem bin bɨ nag mɨdelak ak wɨsɨbnɨmɨŋ, agɨl, kod mɨdelɨgɨpal bin bɨ okok kɨrop agɨl, ñɨŋaŋ nɨbak tari tari rek gɨnɨgab ak, mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep ber mal Bɨ Kɨb lo mɨnɨm agak rek magɨlsek gɨ sakɨl, kɨri adɨk gɨ karɨp lɨm Galili amɨl, taun kɨri Nasaret amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Am mɨdɨl Jisas kɨb gɨl, God nop kod mɨd tep gek nɨŋlɨg gɨ, gos tep yɨb nɨŋɨl, mɨd tep gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pasopa ñɨn kɨb ak ulep apek, Jisas nonɨm nap mɨ nokɨm nokɨm, Pasopa ñɨn kɨb ak mɨñi, agɨl, Jerusalem amelɨgɨpir. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nɨg gɨl me, Jisas mɨ ne yɨn mɨgan alaŋ lek, Juda kai gɨpal rek, nonɨm nap nop poŋɨd dɨl Pasopa tap ñɨŋnɨg Jerusalem am mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ñɨn kɨb nɨbak ap padɨkek nɨŋlɨg gɨ, karɨp amobɨn agɨl, adɨk gɨ am kanɨb nab sɨŋak amɨl nɨŋrek, Jisas eip ma apelak. Ne Jerusalem nep mɨdek pen kɨri ma nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ne bin bɨ ognap eip apeb, agɨl gos nɨŋrek. Pen kanɨb nab sɨŋak kɨnnɨg gɨl, am nɨmɨd nɨmam bin bɨ ognap eip mɨdeb, agɨl, nop pɨyo nɨŋerek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pɨyo nɨŋ dam mer nɨŋɨl, adɨk gɨ Jerusalem nop pɨyo nɨŋnɨg amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amɨl ñɨn omal nokɨm mɨnek nɨŋrek, ne amɨl God sobok gep karɨp ak mɨdɨl, bɨ lo mɨnɨm ag ñeb bɨ okok eip bɨsɨg mɨdɨl, mɨnɨm agelak ak nɨŋɨl, mɨnɨm ognap ag nɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bin bɨ nɨŋ mɨdelak okok, Jisas agak rek nɨŋɨl, ñɨ nɨbak gos nɨŋ kɨd yɨkɨl mɨnɨm tep ageb ak, agɨl, kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pen nonɨm nap ber Jisas nop nɨŋɨl kɨri ak rek nep wal agrek. Nonɨm pen Jisas nop agak, “Nak nap cɨrop tari gɨnɨg nɨg gɨpan? Mɨdmagɨl cɨr yur gek nɨŋlɨg gɨ nep pɨyo nɨŋ ajosɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nonɨm nɨb agek, Jisas agak, “Nɨri tari gɨnɨg yɨp pɨyo nɨŋ ajesir? Bapi yad karɨp am mɨdebin ak nɨri ma nɨpir ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jisas nɨb agak ak pen kɨri mɨnɨm ageb ak, agɨl, ma tɨk nɨŋrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jisas nop poŋɨd dɨl karɨp kɨri Nasaret adɨk gɨ amnɨlak. Jisas nɨb okok nep mɨdɨl, nonɨm nap agelɨgɨpir rek nep nɨŋɨl sain golɨgɨp. Pen nonɨm Jisas tari tari gak ak gos nɨŋlɨg gɨ nep mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas nonɨm nap eip mɨdɨl, kɨb gɨl gos nɨŋ tep yɨb gek nɨŋlɨg gɨ, God abe, bin bɨ okok abe nop nɨŋel tep gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rom gapman bɨ kɨb yɨb Sisa Taibirias karɨp lɨm okok okok kod mɨdolɨgɨp, mɨ yɨn lak aknɨb ajɨp pɨs adaŋ (15). Pen ne par okok mɨdɨl, bɨ kod mɨdep nab pɨyak ne ognap ag lek, am karɨp lɨm ognap kod mɨdelɨgɨpal. Bɨ ne Podias Pailot karɨp lɨm Judia bin bɨ okok kɨrop kod mɨdolɨgɨp. Bɨ ne Herod karɨp lɨm Galili bin bɨ okok kɨrop kod mɨdolɨgɨp. Herod nɨmam ne Pilip karɨp lɨm Ituria bin bɨ okok abe, karɨp lɨm Trakonaitis bin bɨ okok abe kɨrop kod mɨdolɨgɨp. Bɨ ne Laisenias karɨp lɨm Abilini bin bɨ okok kɨrop kod mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pen magɨl nɨbak, bɨ nak Anas eip, Kaiapas eip, God nop tap sobok gep bɨ kɨb yɨb omal Jerusalem mɨdölɨgɨpir. Pen ñɨn nab nɨbak, Sekaraia ñɨ ne Jon, bin bɨ koŋai ma mɨdelɨgɨpal, mɨñ mab kab nep mɨdolɨgɨp nab sɨŋak kɨn mɨdolɨgɨp. Nab okok kɨn mɨdek nɨŋlɨg gɨ, God ne Jon nop gos ñek, ");
INSERT INTO kmh_m_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","karɨp lɨm ñɨg Jodan gol okok okok ajolɨgɨp nɨŋlɨg bin bɨ okok apel, kɨrop mɨnɨm ag ñolɨgɨp, “Tap si tap tɨmel gɨpɨm okok, tari gɨnɨg nɨg gɨpɨn agɨl kɨrɨg gɨl yɨp apem yad nɨbep ñɨg pak ñen, God tap si tap tɨmel gɨpɨm okok nɨŋɨl kɨrɨg gɨnɨgab,” agolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon kɨrop mɨnɨm ag ñolɨgɨp nɨbak, bɨ God mɨnɨm agep Aisaia bɨrarɨk nep gɨnɨgab agɨl, ñu kɨl tɨkak rek nep gak. Aisaia mɨnɨm nɨbak ñu kɨl tɨkɨl agak, “Bɨ alap, karɨp lɨm bin bɨ koŋai ma mɨdebal, mɨñ mab kab nep mɨdeb nab sɨŋak am mɨdɨl, sɨk agɨl agnɨgab, ‘Bɨ Kɨb ak apeb, agɨl, nop kod mɨdenɨmɨb! Nɨb ak, kanɨb mak kɨlan kɨyan gɨnɨmɨŋ okok, dɨm gol pɨlɨs gɨnɨmɨŋ okok, pɨŋɨl pag tep gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nɨb ak, lɨm ban gɨp okok pɨŋɨl pag tep gɨnɨmɨb, dɨm okok pɨŋɨl pag tep gɨnɨmɨb, kanɨb yɨk mayɨk gɨnɨmɨŋ okok, yɨpɨd gɨl gɨnɨmɨb, kab okok dɨ yok tep gɨl mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nɨg gɨl me, bin bɨ okok magɨlsek nɨŋnɨgal, God ne titi gɨl kɨrop dɨ komɨŋ yoknɨgab,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon ne Aisaia mɨnɨm ñu kɨl tɨkak nɨbak rek ag ñek nɨŋlɨg gɨ, bin bɨ koŋai nep ne mɨdek sɨŋak apɨl aglak, “Cɨnop ñɨg pak ñɨnɨmɨn,” aglak. Jon kɨrop sɨlɨk ag gɨl agak, “Nɨbi soiŋ ñɨ pai sɨŋ aul! Gos tari nɨŋɨl pɨrɨk gɨ opɨm? ‘Ñɨg pakon, God bin bɨ ognap kɨrop ag gɨnɨgab ñɨn ak, cɨnop ma ag gɨnɨgab,’ agɨl, pɨrɨk gɨ opɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nɨbi ñɨg paknɨg gɨnɨgabɨm ak, tap si tap tɨmel gɨpɨm okok tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨl, mɨd tep gɨnɨmɨb. Nɨg gem me, bin bɨ nɨŋnɨgal, nɨbi tap si tap tɨmel gölɨgɨpɨm okok kɨrɨg gɨpɨm. Pen nɨbi gos alap nɨŋɨl, ‘Cɨn based acɨk Ebraham ñɨ pai ne mɨdobɨn,’ agɨl, gos ak ma nɨŋnɨmɨb. Cɨn Ebraham ñɨ pai ne mɨdobɨn apɨm ak tap yokop! God kab sɨŋ aul dɨl, Ebraham ñɨ pai ne okok gɨ lin, agɨl, gɨ lɨnɨgab! ");
INSERT INTO kmh_m_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nɨŋ tep gɨnɨmɨb! God mab ak wagɨn sek tɨb junɨg, tu ak mab wagɨn eyaŋ kɨd gɨ mɨdeb. Mab alap, magɨl ñɨŋeb tep ognap ma pɨlnɨgab ak, tɨb paŋɨl dɨ mab yɨneb eyaŋ yoknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon mɨnɨm nɨbak rek agek, kɨri nop pen ag nɨŋɨl aglak, “Cɨn tari gɨn, agɨl, nɨb ageban?” aglak. Agel, Jon kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Bin bɨ sior omal mɨdonɨmɨŋ ak, sior alap dɨ bin bɨ sior ma mɨdonɨmɨŋ okok kɨrop ñɨnɨmel. Pen bin bɨ tap magɨl mɨdonɨmɨŋ ak, bin bɨ tap magɨl ma mɨdonɨmɨŋ okok kɨrop ognap nonɨm lɨ ñɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pen bɨ takɨs dep okok, Jon cɨnop ñɨg pak ñaŋ, agɨl, apɨl nop ag nɨŋɨl aglak, “Mɨnɨm ag ñeb bɨ, cɨn tari gɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Agelak, Jon kɨrop agak, “Takɨs ak dɨnɨg gɨnɨmɨb, gapman apal rek nep dɨnɨmɨb. Yokop ognap ma dɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pen ami bɨ ognap Jon nop mɨnɨm nɨbak rek nep ag nɨŋɨl aglak, “Cɨn tari gɨn?” aglak. Agelak, Jon kɨrop agak, “Nɨbi mɨnɨm tom agɨl bin bɨ okok mani kɨrop si ma dɨnɨmɨb. Mɨnɨm tom agɨl bin bɨ okok mɨnɨm kɨb ma agnɨmɨb. Wög saj dɨnɨgabɨm ak alap sek dɨn, agɨl, gos ak ma nɨŋnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pen nɨg gɨl mɨd damɨl bin bɨ okok gos ar alap nɨŋɨl aglak, “Bɨ nɨbaul Krais per kod mɨdobɨn ak rek lɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Agelak, ne mɨnɨm nɨbak nɨŋɨl kɨrop pen agak, “Mer! Yad nɨbep yokop ñɨg nep pak ñebin, pen yɨp sain onɨgab bɨ ak, ne yad rek mer; ne bɨ kɨb yɨb, yad bɨ sɨkol. Yad nop nɨŋen nabɨŋ gɨnɨgab. Tob tɨrɨp ne ak nag dɨ wɨsɨbnɨm rek ma lɨp,” agak. Bɨ nɨbak ne apɨl, nɨbep Kaun Sɨŋ ak nep pak ñɨl, mab mɨlaŋ pak ñɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Ne wid magɨl pok gek, tɨk dap pakpal rek ak gɨnɨg geb. Wid magɨl ñɨŋeb okok ke lɨl, wid cög dai dai okok ke lɨl gɨnɨgab. Nɨg gɨl, wid magɨl ñɨŋeb okok dam karɨp ñɨlɨk mɨgan ne lɨnɨgab; pen dai dai okok dam mab per yɨn mɨdeb ak dagɨlnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon, bin bɨ okok kɨrop God mɨnɨm tep ak ognap sek ag ñen nɨŋ tep gɨlaŋ, agɨl, kɨrop mɨnɨm tep nɨbak rek sɨkol ma agolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pen gapman bɨ kɨb Herod, tap si tap tɨmel okok gɨ damɨl, kɨsen nɨmam Pilip bin ne Herodias nop dɨ gek, Jon ak tep ma gɨp, agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jon mɨnɨm nɨb agek, Herod nɨŋɨl, tɨmel gak ar alap sek gɨl, Jon nop dam nag lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Pen Herod Jon nop mɨñ ma lak magɨl ak, Jon ne bin bɨ okok kɨrop ñɨg pak ñolɨgɨp. Jisas nop abe ñɨg pak ñak. Jisas nop ñɨg pak ñek, ne Nap God nop sobok gɨ mɨdek nɨŋlɨg gɨ, seb kab ar alaŋ sɨŋak lɨlɨg gɨ pɨs pɨs amek, kɨjoŋ yɨkek, Kaun Sɨŋ ne yakɨr tɨbaglem rek ulek lɨl, Jisas nop ug gɨ owak. Nɨg gɨl apek nɨŋlɨg gɨ, mɨnɨm alap seb kab ar alaŋ sɨŋak nɨb apɨl agak, “Nak Ñɨ mɨdmagɨl yad yɨb. Nep nɨŋen, yɨp tep yɨb gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pen Jisas mɨ ne aknɨb ñɨnjuɨl nokɨm alap adɨk gɨ dam aknɨb wajrem alaŋ (30) amek nɨŋlɨg gɨ, ne wagɨn gɨl bin bɨ okok kɨrop God Mɨnɨm ag ñak. Bin bɨ okok Jisas nop, nap ne ak bɨ nak Josep, ag gos nɨŋlak. Josep nap ne ak Heli. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nap ne ak Matat. Matat nap ne ak Lipai. Lipai nap ne ak Melkai. Melkai nap ne ak Janai. Janai nap ne ak Josep. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nap ne ak Matataias. Matataias nap ne ak Emos. Emos nap ne ak Neham. Neham nap ne ak Esli. Esli nap ne ak Nagai. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nap ne ak Mead. Mead nap ne ak Matataias. Matataias nap ne ak Semein. Semein nap ne ak Josek. Josek nap ne ak Joda. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nap ne ak Joanan. Joanan nap ne ak Resa. Resa nap ne ak Serababel. Serababel nap ne ak Sialtiel. Sialtiel nap ne ak Nerai. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai nap ne ak Melkai. Melkai nap ne ak Adai. Adai nap ne ak Kosam. Kosam nap ne ak Elmadam. Elmadam nap ne ak Er. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nap ne ak Josua. Josua nap ne ak Eliesa. Eliesa nap ne ak Jorim. Jorim nap ne ak Matat. Matat nap ne ak Lipai. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai nap ne ak Simion. Simion nap ne ak Juda. Juda nap ne ak Josep. Josep nap ne ak Jonam. Jonam nap ne ak Eliakim. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nap ne ak Melea. Melea nap ne ak Mena. Mena nap ne ak Matata. Matata nap ne ak Natam. Natam nap ne ak Depid. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depid nap ne ak Jesi. Jesi nap ne ak Obed. Obed nap ne ak Boas. Boas nap ne ak Salmon. Salmon nap ne ak Nason. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nap ne ak Aminadap. Aminadap nap ne ak Admin. Admin nap ne ak Arni. Arni nap ne ak Hesron. Hesron nap ne ak Peres. Peres nap ne ak Juda. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nap ne ak Jekop. Jekop nap ne ak Aisak. Aisak nap ne ak Ebraham. Ebraham nap ne ak Tera. Tera nap ne ak Nahor. Nahor nap ne ak Seruk. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk nap ne ak Rehu. Rehu nap ne ak Pelek. Pelek nap ne ak Eber. Eber nap ne ak Sela. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nap ne ak Kenam. Kenam nap ne ak Apaksad. Apaksad nap ne ak Sem. Sem nap ne ak Noa. Noa nap ne ak Lemek. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek nap ne ak Metusela. Metusela nap ne ak Inok. Inok nap ne ak Jaret. Jaret nap ne ak Malelael. Malelael nap ne ak Kenan. ");
INSERT INTO kmh_m_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nap ne ak Inos. Inos nap ne ak Set. Set nap ne ak Adam. Adam nap ne ak God. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Kaun Sɨŋ ak Jisas nop ap ran jakɨl, nop poŋɨd dɨl ñɨg Jodan okok nɨb dad amek, Jisas karɨp lɨm bin bɨ ma mɨdelɨgɨpal, mɨñ mab kab nep mɨdolɨgɨp nab okok mɨdek. Seten ne Jisas tap si tap tɨmel ognap gɨnɨmɨŋ aka mer gɨ nɨŋlɨg gɨ, gɨ gɨ gek, ñɨn aknɨb ñɨn juɨl omal (40) amnak. Jisas tap magɨl ñɨbɨl mer, nop yuan kɨb lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nop yuan kɨb lek, Seten agak, “Nak ‘God Ñɨ ne mɨdebin,’ apan ak, kab sɨŋ aul agek, bred rek laŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Agek, Jisas pen agak, “God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Bin bɨ okok, bred nep ñɨbɨl komɨŋ ma mɨdenɨgal,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Agek, Seten Jisas nop dam dɨm kɨb alap ar alaŋ amɨl, karɨp lɨm tep tep kiŋ ke ke kodpal okok magɨlsek, magɨl nɨbak nep, Jisas nop yomɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“Karɨp lɨm tep tep sɨŋ aul nɨŋan! Bin bɨ ke ke kodpal. Yad me karɨp lɨm nɨb okok magɨlsek kod mɨdebin rek, bɨ alap nop agnɨg, agnɨgain. Nɨb ak, nak yɨp kogɨm yɨmɨl sobok genɨgan ak, karɨp lɨm nɨb sɨŋ aul magɨlsek nepe agen, nak kod mɨdenɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Agek, Jisas pen agak, “God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘God Bɨ Kɨb nɨbi ak ageb rek nep gɨl yɨb ne nep agem ar amnaŋ,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jisas nɨb agek, Seten ne Jisas nop poŋɨd dɨl Jerusalem amɨl, dam God sobok gep karɨp i ar alaŋ gɨ lɨlak ar ak amɨl agak, “Nak, ‘God Ñɨ ne mɨdebin,’ apan ak, preŋɨd lɨm wagɨn eyaŋ yowan. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘God ejol ne okok agek, nep kod mɨdenɨgal. Ap yap paknɨg genɨgan ak, nep ñɨnmagɨl kɨri dɨnɨgal nɨŋlɨg kab tob nep ak pɨŋɨl ma gɨnɨgab,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Seten nɨb agek, Jisas pen agak, “God Mɨnɨm ak mɨnɨm ognap sek ñu kɨl tɨkɨl aglak, ‘God Bɨ Kɨb ak, ne bɨ nɨŋɨd agep aka bɨ tom agep, agɨl ma agnɨmɨb,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɨjeki Jisas nop mɨnɨm tom ag mer nɨŋɨl, kɨrɨg amnin, agɨl, gos ne okok nep nɨŋak, “Mɨñi mer pen kɨsen ñɨn ognap apɨl mɨnɨm ognap sek tom agɨl agnɨm,” agɨl, kɨrɨg amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pen God Kaun Jisas nop kɨlɨs ñek, Jisas ne adɨk gɨ apɨl karɨp lɨm Galili mɨdek nɨŋlɨg gɨ, bin bɨ okok, mɨnɨm ne ak nɨŋɨl, dam karɨp lɨm Galili nab sɨŋak magɨlsek dɨ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne Juda mogɨm gep karɨp okok amɨl, mɨnɨm ag ñɨ tep gek, bin bɨ okok ne bɨ tep yɨb, agɨl, mɨñ mɨñ yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pen Jisas ne karɨp lɨm Galili nab okok gɨ tag juɨl, Nasaret am mɨdek. Taun nɨbak ne ned mɨdɨl kɨb gak. Juda God nop sobok gep ñɨn kɨri ak apek, ne per golɨgɨp rek, mogɨm gep karɨp ak amɨl, warɨkɨl, God Mɨnɨm ak udɨn lɨ nɨŋɨl agnɨg gek. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bɨ God mɨnɨm agep Aisaia ñu kɨl tɨkak mɨj ak nop dap ñel, dɨ pɨs gɨl, mɨnɨm agnɨg gek dai ak udɨn lɨ nɨŋɨl kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bɨ Kɨb ak yɨp, wög yad gɨnɨmɨn, agɨl, Kaun ne ag yokek yad eip mɨdeb. Nɨb ak, bin bɨ cɨb gep rek mɨdebal okok kɨrop mɨnɨm tep ak ag ñen, nɨŋ tep gɨnɨgal. Bin bɨ nagɨman rek mɨdebal okok kɨrop wɨsɨb yoken, komɨŋ amnɨgal. Bin bɨ udɨn kwoi gɨp rek mɨdebal okok kɨrop gen, udɨn ñɨl nɨŋnɨgal. Bin bɨ koslam mɨdebal okok kɨrop dɨ tep gen, mɨd tep gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pen, Bɨ Kɨb bin bɨ dɨnɨgab ñɨn tep ak mɨñi owɨp, agɨl, bin bɨ okok kɨrop ag ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas mɨnɨm kɨl nɨbak udɨn lɨ nɨŋ ag juɨl, mɨj bad ak dɨ kom kam gɨl, bɨ mɨj kod mɨdolɨgɨp ak nop adɨk ñɨl bɨsɨgek nɨŋlɨg gɨ, bin bɨ mogɨm gep karɨp ñɨlɨk mɨdelak okok magɨlsek udɨn juɨl nop nɨŋ i sek lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nɨg nɨŋelak, Jisas kɨrop agak, “God Mɨnɨm dai nɨbak dɨ udɨn lɨ nɨŋ nɨbep agen nɨŋesɨm nɨbak, mɨñi nɨg aknɨb rek nep gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nɨb agek, mɨnɨm tep yɨb agak ak nɨŋɨl, bin bɨ nop mɨñ mɨñ gɨl, wal aglak. Pen gos alap nɨŋɨl, “Bɨ nɨbaul Josep ñɨ ne nep aka?” agɨl, kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nɨb agel, Jisas kɨrop agak, “Pen yad nɨpin, yɨp agnɨgabɨm, ‘Nak soi komeb bɨ, nak ke gɨnɨmɨn tap nak ke gɨp ak komɨŋ lɨnɨgab. Nak taun sɨkol Kapaneam am mɨdɨl, tap ma gep rek genak, yɨd acmal tagosɨp nɨpɨn ak rek, mɨñi karɨp lɨm nak ke sɨŋaul abe gek yɨd acmal tagek nɨŋɨn,’ agnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pen nɨbep nɨŋɨd agebin, bɨ God mɨnɨm agep okok, karɨp lɨm ke okok amɨl, mɨnɨm tep ak agel, nɨŋɨd agebal, agɨl, dɨnɨgal. Pen karɨp lɨm kɨri ke ak apɨl agel, bɨ cɨn okok ke agebal, agɨl, mɨnɨm kɨrop ma dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pen nɨŋɨm! Bɨ God mɨnɨm agep Ilaija mɨdek ñɨn ak, bin kaŋɨl koŋai nep Isrel sɨŋak mɨdelɨgɨpal. Mɨ omal nokɨm takɨn aknɨb kagol oŋɨd ak, mɨñab ma pakek, tap magɨl ma tanek, yuan kɨb yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Isrel bin kaŋɨl ognap yuan lak okok koŋai yɨb nep mɨdelak sɨŋak, pen God Ilaija nop ag yokek, am taun sɨkol Sarepat karɨp lɨm taun kɨb Saidon ulep sɨŋak amɨl, tap ma gep rek gek, bin kaŋɨl alap tap magɨl ne koŋai nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pen ar nɨbak rek, kɨsen bɨ God mɨnɨm agep Ilaisa mɨdek ñɨn ak, Isrel bin bɨ ognap soi kɨsak lak okok koŋai yɨb nep mɨdelak sɨŋak, pen kɨrop ognap gek komɨŋ ma lak; Ilaisa bɨ Neman karɨp lɨm par kɨb Siria nɨb ak nop nep gek, komɨŋ lak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas nɨb agek, Juda bin bɨ mogɨm gep karɨp ñɨlɨk mɨdelak okok nɨŋel mɨlɨk kal yɨb yapek, ");
INSERT INTO kmh_m_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","nop yɨk gɨ dam mɨdɨŋ yokon kɨmaŋ, agɨl, yɨk gɨ dam amnɨlak ak pen Jisas ne adɨk gɨl nab kɨri sɨŋak amɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas taun sɨkol Kapaneam, karɨp lɨm Galili sɨŋak am mɨdɨl, Juda kai God nop sobok gep ñɨn ak bin bɨ kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","God Mɨnɨm ak, Jisas kɨlɨs tɨmel gɨl yɨpɨd gɨl nep agek, kɨri nɨŋɨl wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pen Juda mogɨm gep karɨp ñɨlɨk nab nɨb sɨŋak, bɨ kɨjeki abaŋ ñagak alap ap mɨdek. Ne meg mɨgan dap ranɨl sɨk par agɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Bɨ Jisas Nasaret nɨb! Nak tari gɨnɨg opan? Cɨnop gɨ tɨmel gɨnɨg opan aka? Yad nep nɨpin. God Bɨ Sɨŋ ne ak nep opan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pen Jisas kɨjeki abaŋ ñag mɨdek nɨbak nop ag gɨl agak, “Mɨnɨm ma agnɨmɨn! Bɨ ak nop kɨrɨg gɨl söŋ amnoŋ!” agak. Jisas agek, kɨjeki kɨyob ñɨlɨk söŋ amlɨg gɨ bɨ nɨbak nop, bin bɨ mɨdelak nab sɨŋak dɨ yokɨl amnak. Pen nop tapɨn magɨl ma pakak; komɨŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nɨg gek, bin bɨ nɨŋ mɨdelak okok kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “Bɨ kɨlɨs yɨb nɨbaul, mɨnɨm nɨbak akal nɨb dapɨl agek, kɨjeki okok söŋ ambal?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pen Jisas gak mɨnɨm nɨbak karɨp lɨm nɨb okok magɨlsek yɨg dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pen Jisas Juda mogɨm gep karɨp ak kɨrɨg gɨl Saimon karɨp ak amnak. Saimon nɨbor ne ak tap gek, mɨb goŋ ne okok magɨlsek mab rek yɨnek me, bin bɨ okok apɨl Jisas nop aglak, “Onɨmɨn, nak Saimon nɨbor nop gek warɨk amnaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Agelak, ne bin tap gek kɨm mɨdek ulep sɨŋak apɨl, tap gek nɨbak ag gek nɨŋlɨg gɨ, magɨl nɨbak nep nop kɨrɨg gɨl amnak. Nop komɨŋ lek, warɨkɨl, bin bɨ ap mɨdelak okok kɨrop tap magɨl bɨlok ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bin bɨ nɨb sɨŋak mɨdelak okok, mɨnɨm nɨbak nɨŋɨl, pɨb paŋɨd amnak magɨl ak, bin bɨ kɨri mɨñak gak okok magɨlsek dap Jisas mɨdek sɨŋak dolak. Dapelak, Jisas kɨrop nokɨm nokɨm dɨ nɨŋek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pen bin bɨ kɨjeki kɨyob ñɨlɨk tap okok abaŋ ñag mɨdek okok ag yokek, söŋ amlɨg gɨ sɨk gaul gɨlɨg gɨ aglak, “Nak God Ñɨ ne!” aglak. Kɨri Jisas ne Krais ak nɨŋɨl nɨb agelak nɨŋɨl Jisas ne kɨrop ag gɨl agak, “Mɨnɨm alap ma agnɨmɨb,” agek, agak rek nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mɨnek kɨslɨm sek, Jisas karɨp lɨm nɨbak kɨrɨg gɨl, ke am mɨden, agɨl, mɨñ mab nep nab okok amnak. Amnak pen bin bɨ okok kɨsen amɨl, nop pɨyo nɨŋɨl aglak, “Okok ma amnɨmɨn; cɨn eip mɨdon,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nɨb agelak Jisas agak, “God yɨp ag yokek onek ak, yad amɨl bin bɨ ke mɨgan ognap sek kɨrop ak rek nep God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak ag ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nɨb agɨl, Jisas Juda bin bɨ karɨp lɨm kɨri okok magɨlsek gɨ ajlɨg gɨ, am Juda mogɨm gep karɨp okok amɨl, mɨnɨm tep nɨbak kɨrop ag ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisas ñɨn alap am Ñɨg Cöb Genesaret gol sɨŋak mɨdɨl, God Mɨnɨm ak ag ñek nɨŋlɨg gɨ, bin bɨ koŋai yɨb, mɨnɨm tep nɨbak nɨŋɨn, agɨl, cɨrok cɨrok ñɨlɨg gɨ olak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nɨg gɨl apel nɨŋlɨg gɨ, Jisas nɨŋak, bɨ kɨbsal dep okok ñɨg magöb omal dap ñɨg cöb gol nɨb sɨŋak lɨl, kɨbsal dep uben okok acɨp dɨ yoklɨg gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas ne Saimon ñɨg magöb adek ak preŋɨd lɨl agak, “Yɨp dɨ neb neb gek, ñɨg cöb nab ulep sɨŋ adaŋ amnin,” agak. Agek, Saimon ñɨg magöb ak dɨ neb neb gek, Jisas ñɨg cöb nab ulep sɨŋak amɨl ñɨg magöb ar nɨbak bɨsɨg gɨ mɨdɨl, bin bɨ okok kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mɨnɨm ag mɨbɨl juɨl, Jisas Saimon nop agak, “Ñɨg magöb aul ñɨg kas pɨrɨk gɨ dam ñɨg cöb nab kɨb sɨŋ adaŋ amɨl, uben yokɨl kɨbsal dɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Agek, Saimon pen agak, “Bɨ Kɨb, mɨñi kɨslɨm eyaŋ nep cɨn kɨbsal nɨŋ tag tag tag, karɨp sek tɨk dam lɨp pen cɨn kɨbsal ognap ma dɨpɨn. Pen nak nɨb apan rek, uben ak abramek dɨ yok nɨŋɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nɨb agɨl kɨri uben dɨ yokel nɨŋlɨg gɨ, kɨbsal koŋai nep ap uben mɨgan ak amel, uben okok ap ran jakɨl, pɨg rɨknɨg rek gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nɨg gak nɨŋlɨg gɨ, nɨmam sɨkop ñɨg magöb ar alap mɨdelak okok kɨrop ñɨn owan gel, kɨri apɨl kɨbsal nɨb okok dɨl, ñɨg magöb nɨb omal lel, pɨs nep ap ran jakɨl, ñɨg magöb omal pɨge yonɨg rek gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Nɨg gak nɨŋɨl, Saimon Pita bɨ ne eip ñɨg magöb ar mɨdelak okok, kɨbsal koŋai yɨb dɨlak okok nɨŋɨl, gos par nep nɨŋlak. Pen Sebedi ñɨ ne Jems eip Jon eip, ñɨg magöb alap dɨl Saimon eip wög jɨm ñɨl gölɨgɨpir bɨ omal, ak rek nep gos par nɨŋrek. Pen Saimon amɨl Jisas mɨdek ulep sɨŋak kogɨm yɨmɨl agak, “Bɨ Kɨb, yad bɨ tap si tap tɨmel gɨpin ak, nak ke okok amnoŋ,” agak. Agek Jisas agak, “Nak ma pɨrɨknɨmɨn. Mɨñi ñɨn aul tɨkɨl, bɨ kɨbsal dep ak kɨrɨg gɨl, bin bɨ dɨl God nop dowep bɨ mɨdenɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jisas nɨb agek, ñɨg magöb omal dam ñɨg gol sɨŋak lɨl, kɨbsal tap okok kɨrɨg gɨl, Jisas eip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pen kɨsen Jisas am taun alap mɨdek, bɨ mɨb goŋ ne okok magɨlsek soi sapeb bɨrbɨr gak bɨ alap apɨl, Jisas mɨdek ulep sɨŋak kogɨm yɨmɨl nabɨc kɨyan gɨl, agak, “Nak yɨp gek komɨŋ lɨnɨg, gek komɨŋ lɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nɨb agek, Jisas agak, “Yau, yad gen, nep komɨŋ lɨnɨmɨŋ,” agak. Nɨb agɨl, Jisas ñɨnmagɨl ne parsek lɨl bɨ nɨbak dɨ nɨŋek, magɨl nɨbak nep soi sapeb okok pɨs nep kɨrɨg gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Soi sapeb okok kɨr gek, Jisas bɨ nɨbak nop agak, “Yad nep dɨ nɨŋen komɨŋ lɨp ak bin bɨ okok ma agnɨmɨn. Pen bɨ Mosɨs bɨrarɨk nep ñu kɨl tɨkɨl agak rek, soi sapeb yɨp ak komɨŋ lɨp, agɨl, ne amɨl bɨ God nop tap sobok gɨpal okok kɨrop yomɨl, tap sobok gep ak kɨrop ñɨl agnɨmɨn, ‘Yɨp komɨŋ lɨp rek, tap aul God nop sobok gɨm,’ agnɨmɨn. Nak nɨg genɨgan, bin bɨ nɨŋɨl agnɨgal, ‘Ne komɨŋ lɨp rek nɨg gɨp,’ agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pen Jisas mɨnɨm ne ak, karɨp lɨm okok magɨlsek tɨgoŋ tɨgoŋ amek, bin bɨ koŋai nep, nop nɨŋɨn, agɨl, cɨrok marok ñɨlɨg gɨ apelɨgɨpal. Bin bɨ nɨb okok, ognap mɨnɨm tep ne ak nɨŋnɨg apelɨgɨpal; ognap cɨnop gek komɨŋ laŋ agɨl apelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pen ñɨn ognap Jisas am ke mɨgan alap mɨdɨl, Nap nop sobok golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ñɨn alap Jisas bin bɨ okok kɨrop mɨnɨm ag ñɨ mɨdek. Perisi bɨ ognap abe, lo mɨnɨm ag ñeb bɨ ognap abe, karɨp lɨm Galili nab sɨŋak karɨp tɨrɨg tɨroŋ magɨlsek okok nɨb abe, karɨp lɨm Judia nab sɨŋak karɨp tɨrɨg tɨroŋ magɨlsek okok nɨb abe, Jerusalem nɨb abe apɨl, Jisas mɨnɨm ag ñɨ mɨdek sɨŋak bɨsɨg mɨdelak. Pen Bɨ Kɨb kɨlɨs ne eip mɨdek ak me, Jisas bin bɨ tap gak okok kɨrop gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pen bɨ ognap, bɨ ñɨnmagɨl tob kalau gak alap yɨr lɨ dapɨl, Jisas nop gek komɨŋ laŋ, agɨl, nop Jisas mɨdeb karɨp ñɨlɨk mɨgan ak dad amnɨn, ag gos nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pen Jisas mɨdek karɨp ak nɨŋlak, bin bɨ okok karɨp ñɨlɨk mɨgan nɨbak pɨs nep tɨbɨk dak. Nɨg gek, cɨp yɨr lɨ dolak nɨbak dam karɨp ar alaŋ amɨl, karɨp ak tɨg mɨgan juɨl, nag lɨl, Jisas mɨdek nab sɨŋak kɨyan yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kɨri gos nɨŋlak, Jisas gek komɨŋ lɨnɨmɨŋ rek lɨp, agɨl nɨŋelak rek, Jisas gos kɨri ak nɨŋɨl, bɨ ñɨnmagɨl tob kalau gak ak nop agak, “Bɨ nɨŋeb yad, tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas nɨb agek, bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, gos nab kɨri okok nep ke nɨŋɨl aglak, “Bɨ nɨbaul bɨ an? Ne God nop ag julɨg gɨ ageb. God ne nokɨm nep me tap si tap tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨnɨmɨŋ rek lɨp,” agɨl, gos kɨri ak nep nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pen gos nɨŋelak nɨbak, Jisas ke tɨk nɨŋɨl agak, “Nɨbi tari gɨnɨg yɨp gos tɨmel nɨŋebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bɨ alap bɨ alap nop agnɨgab, ‘Tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gebin,’ agnɨgab ak, nɨbi titi gɨl nɨŋnɨgabɨm ne mɨnɨm nɨŋɨd ageb aka mɨnɨm tom ageb? Pen bɨ ñɨnmagɨl tob kalau gɨp alap mɨdenɨgab, bɨ alap nop agnɨgab, ‘Nak mɨñi nep warɨk amnoŋ,’ agnɨgab ak, nɨbi titi gɨl nɨŋnɨgabɨm ne mɨnɨm nɨŋɨd ageb aka mɨnɨm tom ageb? ");
INSERT INTO kmh_m_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bɨ Ñɨ ne bin bɨ lɨm dai ar wagɨn aul tap si tap tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨnɨmɨŋ rek lɨp ak, nɨbi mɨnɨm nɨbak mɨnɨm nɨŋɨd agɨl nɨŋ dɨnɨmɨb, agɨl, yad mɨnɨm nɨg gɨl agnɨg gebin,” agak. Nɨb agɨl, Jisas bɨ ñɨnmagɨl tob kalau gak ak nop agak, “Nak mɨñi nep warɨkɨl, nep yɨr lɨ dopal abañ bad ak dɨl, adɨk gɨ karɨp nak amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jisas nɨb agek, bin bɨ okok nɨŋ mɨdel nɨŋlɨg gɨ, bɨ nɨbak magɨl nɨbak nep warɨkɨl, nop yɨr lɨ dolak abañ bad nɨbak dɨl, God nop tep aglɨg gɨ, karɨp ne amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nɨg gek, bin bɨ nɨŋ mɨdelak okok magɨlsek pak ju dɨlɨg gɨ, God yɨb ak dap ranlɨg gɨ aglak, “Mɨñi tap ke nɨb yɨb alap gosɨp nɨpɨn,” agɨl, kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pen kɨsen Jisas amɨl nɨŋak, bɨ takɨs dep alap takɨs ñeb karɨp ñɨlɨk mɨgan ak bɨsɨg mɨdek. Yɨb ne ak Lipai. Jisas nop nɨŋɨl agak, “Nak owan, yad eip amnɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Agek, Lipai warɨkɨl, wög golɨgɨp ak kɨrɨg gɨl, tap ne okok magɨlsek kɨrɨg gɨl, Jisas eip amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pen Lipai mɨñ mɨñ gɨl, Jisas nop tap magɨl kɨb karɨp ne ak dagɨl lɨl, bɨ takɨs dep ognap, bin bɨ ognap koŋai nep sɨk agek, apɨl Jisas eip bɨsɨg gɨl tap magɨl ñɨbelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pen Jisas kɨri eip tap magɨl ñɨbek ak nɨŋɨl, bɨ Perisi ognap abe, bɨ lo mɨnɨm ag ñeb bɨ kɨri ognap abe apɨl, Jisas bɨ ne okok kɨrop aglak, “Nɨbi tari gɨnɨg bin bɨ tap si tap tɨmel gɨpal okok abe, bɨ takɨs dep okok abe eip bɨsɨgɨl tap ñɨbebɨm?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nɨb agel, Jisas mɨnɨm nɨbak nɨŋɨl kɨrop pen agɨl agak, “Bin bɨ komɨŋ mɨdobɨn apal bin bɨ okok, soi ñon gep bɨ sɨk ma apal; bin bɨ tap gɨp okok nep, cɨnop gek komɨŋ laŋ, agɨl, soi ñon gep bɨ sɨk apal. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nɨb aknɨb rek nep, yad bin bɨ, mɨd tep gɨpɨn, agɨl gos nɨpal bin bɨ okok, kɨrop agnɨg ma opin; bin bɨ, cɨn tap si tap tɨmel gɨl, mɨd tep ma gɨpɨn, agɨl gos nɨpal bin bɨ okok, kɨrop agnɨg opin. Yad kɨrop mɨnɨm tep ag ñen, kɨri mɨnɨm yad ak nɨŋ dɨl, tap tɨmel gɨpal okok, tari gɨnɨg nɨg gɨpɨn agɨl, kɨrɨg gɨl, God ageb rek nep gɨnɨmel,” agɨl opin. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pen kɨri ognap Jisas nop aglak, “Jon bɨ ne okok abe, Perisi bɨ kɨri okok abe ñɨn ognap, God nop nep gos nokɨm nɨŋɨn, agɨl, tap magɨl ma ñɨbɨl yuan nep mɨdɨl, God nop sobok gɨpal. Pen bɨ nak okok tap magɨl ñɨblɨg gɨ, ñɨg ñɨblɨg gɨ nep mɨdebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nɨb agelak, Jisas kɨrop pen agak, “Bɨ alap bin dɨl, bin bɨ ne okok eip tap kɨb ñɨŋnɨgal ak, bɨ ognap warɨkɨl, tari gɨnɨg nɨg gebɨm agɨl ma agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pen kɨsen bɨ ognap apɨl bɨ nɨbak dad amel, ñɨn nɨbak bin bɨ ne okok cɨb gek, tap magɨl ma ñɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pen Jisas mɨnɨm sɨd tɨkɨl kɨrop agak, “Walɨj ned nɨb alap gɨ rɨk genɨgab ak, walɨj kɨsen nɨb alap dɨ gɨ rɨk gɨl, dap ñag dör gel, adɨp adɨp ma lɨnɨgab. Ke ke yɨb lɨl, omalgɨl tɨmel yɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pen ñɨg wain ak, ak rek nep. Ñɨg wain komɨŋ ak dɨl, kaj meme wak mɨlep mɨgan eyaŋ soŋ ma lɨpal. Tari gɨnɨg: soŋ lɨl sɨmjen ñel, tan ap ranɨl, bɨŋ tɨmel yɨb agɨl pɨg gɨ rɨkɨl soŋ gek, kaj meme wak ak abe tɨmel gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gos nɨbak nɨŋɨl me, ñɨg wain komɨŋ dɨl, kaj meme wak komɨŋ mɨgan ak nep soŋ lep. ");
INSERT INTO kmh_m_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pen bin bɨ ñɨg wain ned nɨb bɨr ñɨbal okok, kɨsen ñɨg wain komɨŋ kɨsen nɨb ak ñɨbel kɨrop tep ma gɨnɨgab; ‘Ñɨg wain ned nɨb ak tep,’ agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kɨsen Juda God nop sobok gep ñɨn alap, Jisas bɨ ne okok eip wid wög dai nab sɨŋak amlɨg gɨ, bɨ ne okok wid magɨl nɨb okok ognap tɨk ñɨnmagɨl ar kɨri sɨŋak lɨl, wak pak yokɨl ñɨblɨg gɨ amelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nɨg gelak, bɨ Perisi ognap nɨŋɨl aglak, “Nɨbi tari gɨnɨg God nop sobok gep ñɨn wög ma gep aul, wid magɨl wak pak yokɨl wög gebɨm?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Agelak, Jisas bɨ ne okok gelak nɨbak gɨ tɨmel ma gelak ak nɨŋɨl, bɨ Perisi okok kɨrop agak, “Depid bɨrarɨk nep bɨ ne okok eip yuan gek, God sobok gep karɨp ak amjakɨl, bred God udɨn yɨrɨk ar ak lɨl, bɨ yokop ma ñɨbal, bɨ God nop tap sobok gɨpal okok nep ñɨbal bred ak, Depid ag nɨŋek, nop ñel, bɨ ne okok eip ñɨŋlak. Kɨrop yuan gek gɨlak kesɨm ar nɨbak God Mɨnɨm ñu kɨl tɨklak ak, nɨbi ma nɨpɨm ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisas mɨnɨm alap sek agɨl agak, “Bɨ Ñɨ ne Bɨ Kɨb mɨdɨl, ñɨn yokop mɨdep ñɨn ak, tari gɨnɨm, ag gos nɨŋnɨgab ak, gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","7","Pen Juda God nop sobok gep ñɨn kɨsen alap, Jisas Juda mogɨm gep karɨp ak amɨl, kɨrop God Mɨnɨm ak ag ñɨlɨg gɨ mɨdek. Karɨp ñɨlɨk mɨgan nɨbak, bɨ ñɨnmagɨl yɨpɨd kɨd ne ak pɨs nep pɨpɨc gak alap ap mɨdek. Bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, bɨ nɨbak nop nɨŋlak rek, Jisas ne God nop sobok gep ñɨn aul nop gek komɨŋ lɨnɨgab aka tari gek, nop ag gɨn, agɨl, nop nɨŋ i sek lɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pen gos nɨŋlak nɨbak, Jisas ke nɨŋɨl, bɨ ñɨnmagɨl pɨpɨc gak nɨbak nop agak, “Nak warɨkɨl nab sɨŋaul owan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Agek, warɨk apek nɨŋlɨg gɨ, Jisas bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe kɨrop agak, “Yokop mɨdep ñɨn aul rek, bin bɨ okok kɨrop dɨ tep gɨnɨgabɨn aka, yokop mɨdep ñɨn mɨñi, agɨl, kɨrop yem gɨnɨgabɨn? Kɨrop gon warɨk amnɨmel aka kɨrop yem gon kɨmnɨmel?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nɨb agɨl, kɨrop nɨŋ kɨs kɨs gɨl, bɨ ñɨnmagɨl pɨpɨc gak ak nop agak, “Ñɨnmagɨl nak ak parsek yokan!” agak. Agek, ñɨnmagɨl ne parsek lek nɨŋlɨg gɨ, dai komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jisas bɨ nɨbak nop gek komɨŋ lak ak nɨŋɨl, bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, mɨlɨk kal yɨb nɨŋɨl, Jisas nop tari gɨn, agɨl, ag nɨŋ ag nɨŋ gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pen ñɨn nab nɨb sɨŋak, Jisas Nap nop sobok gɨnɨgain, agɨl, dɨm gol alap amɨl, Nap nop sobok gɨ mɨdek mɨdek, mɨñab tɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pen mɨnek pɨb owak magɨl ak, bɨ ne okok magɨlsek agek apelak, bɨ ne aknɨb umɨgan alaŋ kɨrop tɨg asɨk ke lɨl, nɨbi bɨ mɨnɨm yad dad ameb okok mɨdenɨgabɨm, agɨl ag lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Bɨ ne ag lak nɨb okok yɨb kɨri me: alap Saimon, kɨsen Jisas yɨb ne alap lɨl Pita agak; alap Edru, Saimon nɨmam ne ak; alap Jems; alap Jon; alap Pilip; alap Batolomyu; alap Matyu; alap Tomas; alap Jems, Alpias ñɨ ne ak; alap Saimon yɨb alog Saimon Selot agölɨgɨpal ak; ");
INSERT INTO kmh_m_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","alap Judas, Jems ñɨ ne ak; alap Judas Iskariot. Ne nep me kɨsen Jisas ñag pak lɨlaŋ, agɨl, nop mɨmɨg nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pen Jisas bɨ ne nɨb okok eip dɨm gol alaŋ kɨrɨg gɨl, mak sɨŋak eyaŋ kɨyan gɨ am gɨmeŋ tep eyaŋ mɨdel nɨŋlɨg gɨ, bin bɨ koŋai nep, nop nɨŋɨn, agɨl, ap mogɨm gɨlak. Bin bɨ nɨb okok, ognap Jerusalem nɨb, ognap karɨp lɨm Judia okok nɨb okok nɨb, ognap karɨp lɨm nabis taun kɨb omal Taia Saidon nɨb, ");
INSERT INTO kmh_m_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jisas mɨnɨm ne nɨŋɨl, cɨnop tap gɨp gek komɨŋ lɨnɨmɨŋ, agɨl apelak. Bin bɨ kɨjeki kɨyob ñɨlɨk tap okok abaŋ ñagek mɨd tep ma gelak okok, Jisas gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kɨlɨs ne nɨb apɨl, kɨrop tap tari tari gak okok gek, magɨlsek komɨŋ losɨp ak nɨŋɨl, bin bɨ nɨb okok magɨlsek apɨl, cɨn abe Jisas nop dɨ nɨŋɨn, agɨl, nop cɨrok marok ñɨlɨg gɨ olak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas bɨ ne okok kɨrop udɨn nɨŋlɨg gɨ agak, “Nɨbi bin bɨ yɨm gep rek mɨdebɨm okok, God nɨbep dɨ tep gɨl kod mɨdenɨgab. Gos nɨbak nɨŋɨl mɨñ mɨñ gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nɨbep mɨñi yuan kɨb leb okok, kɨsen yuan ma lɨnɨgab. Gos nɨbak nɨŋɨl mɨñ mɨñ gɨnɨmɨb. Nɨbep mapɨn gek, sɨl magɨl agebɨm okok, kɨsen tep gek nɨŋlɨg gɨ, sɨk agnɨgabɨm. Gos nɨbak nɨŋɨl mɨñ mɨñ gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bɨ Ñɨ ne nop cɨg mɨdem, bin bɨ okok nɨbep mɨlɨk kal nɨŋɨl, yo nɨŋɨl, bin bɨ tɨmel nɨb sɨŋ aul, bɨ an eip mɨdenɨgal, agɨl, nɨbep yɨb gos tɨmel nɨŋɨl mɨnɨm dɨl ag juenɨmel ak, nɨbi mɨñ mɨñ gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gɨnɨgal nɨbak, nɨsed acɨk kɨri okok, bɨ God mɨnɨm agep okok kɨrop gölɨgɨpal rek nep nɨbep gɨnɨgal. Nɨbi gos ar nɨbak nɨŋɨl, God cɨnop dɨ tep yɨb gɨnɨgab karɨp lɨm ne ar alaŋ sɨŋak, agɨl, tep gek nɨŋlɨg gɨ, ñɨn tob ju ar ar gɨ warɨklɨg gɨ, mɨñ mɨñ gɨlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pen nɨbi bin bɨ mani tap koŋai mɨdeb okok nɨŋ tep gɨnɨmɨb. Tap nɨbi dep rek ak, lɨm dai ar wagɨn aul bɨr dɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pen nɨbi mɨñi tap magɨl rek ñɨb gem gem kogi gɨp okok, kɨsen yuan gɨnɨgab ak nɨŋ tep gɨnɨmɨb. Pen nɨbi mɨñi mɨnɨm sɨk gaul gɨ mɨdebɨm okok, kɨsen mapɨn gek sɨl magɨl ag mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pen nɨbep yɨb dap ranlɨg gɨ nep mɨdenɨgal ak, nɨbi nɨŋ rep yɨb gɨnɨmɨb. Nɨsed acɨk sɨkop kɨri okok, bɨ God Mɨnɨm esek agelɨgɨpal okok, kɨrop aknɨb rek gölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pen bin bɨ mɨnɨm yad nɨŋebɨm sɨŋ aul. Kaual maual nɨbi okok kɨrop mɨdmagɨl lɨnɨmɨb. Bin bɨ nɨbep mɨlɨk yapek nɨpal okok kɨrop dɨ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bin bɨ nɨbep ag juenɨmel, God kɨrop kod mɨdeŋ, agɨl, nop sobok gɨnɨmɨb. Bin bɨ nɨbep gɨ tɨmel genɨmel, kɨrop God nop sobok gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pen bin bɨ ognap nɨbep mɨkem pɨs kɨd pakenɨmel, adɨk gem, pɨs kɨd abe paknɨmel. Pen bin bɨ ognap kolsior nɨbep ak denɨmel, sior ak rek abe dɨm, agɨl, abramek ñɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bin bɨ ognap tap ma mɨdonɨmɨŋ asɨb agenɨmel, kɨrop ñɨnɨmɨb. Pen tap nɨbi alap nɨŋɨl denɨmel, cɨnop adɨk ñɨm, agɨl, ma agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Cɨnop gɨlaŋ agɨl gos nɨŋebɨm rek ak, nɨbi ke bin bɨ ognap okok kɨrop ak rek nep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bin bɨ nɨbep mɨdmagɨl lɨpal okok nep mɨdmagɨl lɨnɨgabɨm ak, God nɨbep titi gɨl nɨŋek, tep gɨnɨgab? Bin bɨ tap si tap tɨmel gɨpal okok, bin bɨ kɨri ke okok ak rek nep pen pen mɨdmagɨl lɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pen bin bɨ nɨbep dɨ tep gɨpal okok nep kɨrop dɨ tep gɨnɨgabɨm ak, God nɨbep titi gɨl nɨŋek, tep gɨnɨgab? Gɨnɨgabɨm nɨbak, bin bɨ tap si tap tɨmel gɨpal okok gɨpal rek nep gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tap ñon pen ñɨnɨgal, agɨl, gos ak nep nɨŋɨl tap ñɨnɨgabɨm ak, God nɨbep titi gɨl nɨŋek, tep gɨnɨgab? Gɨnɨgabɨm nɨbak, bin bɨ tap si tap tɨmel gɨpal okok gɨpal rek nep gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nɨb ak, kaual maual nɨbi okok mɨdmagɨl lɨl, kɨrop gɨ tep gɨl, tap abramek ñɨnɨmɨb. Cɨnop pen ñɨnɨgal, agɨl, gos ar ak ma nɨŋnɨmɨb. Nɨg genɨgabɨm ak, God kɨlɨs yɨb ar i alaŋ mɨdeb ak, ñɨ pai ne mɨdenɨgabɨm. Ne geb rek gɨnɨgabɨm ak me, nɨbep saköl ma gɨl, pen tep ñɨnɨgab. God ne bin bɨ tap si tap tɨmel gɨpal okok abe, bin bɨ nop, tep gɨp, ma apal okok abe, kɨrop ak rek nep gɨ tep gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nap nɨbi bin bɨ yɨmɨg nɨŋɨl dɨ tep gɨp rek, nɨbi ak rek nep bin bɨ yɨmɨg nɨŋɨl dɨ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nɨbi bin bɨ ognap, ‘Nɨg nɨg gɨpɨm rek, nɨbi bin bɨ tɨmel mɨdebɨm,’ ma agenɨgabɨm ak, God nɨbep pen ak rek nep, ‘Nɨg nɨg gɨpɨm rek, nɨbi bin bɨ tɨmel mɨdebɨm,’ agɨl ma agnɨgab. Nɨbi bin bɨ ognap mɨnɨm kɨb agɨl, ‘Nɨbi bin bɨ tɨmel, pen dɨnɨgabɨm,’ ma agenɨgabɨm ak, God nɨbep pen ak rek nep mɨnɨm kɨb agɨl, ‘Nɨbi bin bɨ tɨmel, pen dɨnɨgabɨm,’ agɨl ma agnɨgab. Bin bɨ okok nɨbep gɨ tɨmel genɨgal ak nɨŋɨl yem genɨgabɨm ak, God tap tɨmel nɨbi gɨpɨm ak, ak rek nep nɨŋɨl yem gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tap nɨbi okok bin bɨ okok kɨrop abramek ñenɨgabɨm ak, God nɨbep pen ak rek nep abramek yɨb ñɨnɨgab. Nɨbi sɨkel tari rek dɨl bin bɨ okok kɨrop tap nonɨm lɨ ñɨnɨgabɨm ak rek, God sɨkel nɨbak nep dɨ nɨbep ak rek nep tap nonɨm lɨ ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pen Jisas mɨnɨm alap sɨd tɨkɨl agak, “Bɨ udɨn kwoi gɨnɨgab alap, bɨ udɨn kwoi alap nop, kanɨb nɨb nɨb mɨdeb, agɨl, ma yomnɨgab. Tari gɨnɨg: ne nɨg gek, omalgɨl kau mɨgan eyaŋ ap yap paknɨgair. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Bin bɨ skul apal okok, am skul apal won ak, ag ñeb bɨ kɨri okok kɨrop ar alaŋ ma mɨdebal. Pen kɨsen skul ak ag tep gɨl ag saknɨgal ak, ag ñeb bɨ kɨri okok eip adɨp adɨp mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pen tari gɨnɨg mab bog udɨn nɨbep ke pak karɨkɨl mɨdeb ak nɨŋ agɨl mer, namam tap acɨp udɨn ne mɨdeb ak nep nɨŋ agebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mab bog kɨb udɨn nɨbep pak karɨkɨl mɨdeb ak ned dɨ yokem, udɨn nɨbi udɨn yɨb lek, kɨsen namam tap acɨp sɨkol udɨn ne mɨdeb ak, dɨ yokɨn, agɨl agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pen mab tep alap magɨl tɨmel alap ma pɨlnɨgab; pen mab tɨmel alap magɨl tep alap ma pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nɨb ak, mab okok magɨl pɨlnɨgab ak nep nɨŋɨl, mab ak tep, mab ak tɨmel, agɨl, nɨŋnɨgal. Nag mɨgoñɨb ak kɨyau magɨl ma pɨlnɨgab. Nag gablog ak tapok magɨl ma pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bin bɨ tep okok, cɨbur gos mɨdmagɨl nab kɨri adaŋ tep mɨdeb rek, gɨ tep gɨpal. Bin bɨ tɨmel okok, cɨbur gos mɨdmagɨl nab kɨri adaŋ tɨmel mɨdeb rek, gɨ tɨmel gɨpal. Pen bin bɨ tigep bin bɨ rek mɨdebal ak, mɨnɨm agnɨgal ak nep peyɨg nɨŋɨl, bin bɨ okok tep, bin bɨ okok tɨmel, agɨl, nɨŋnɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Yɨp Bɨ Kɨb cɨn, Bɨ Kɨb cɨn, apɨm ak pen tari gɨnɨg mɨnɨm agebin ar ak ma gɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bin bɨ mɨnɨm yad ak nɨŋɨl, agebin rek gɨpal okok, mɨnɨm agnɨg gebin aul rek mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bin bɨ mɨnɨm yad ak nɨŋɨl, agebin rek gɨpal okok, bɨ karɨp gɨ lɨnɨg gɨnɨgab, kau par dɨl, karɨp sap kab ar sɨŋak dɨ pɨŋɨl tep gɨl, karɨp ar nɨbak nep gɨ lɨnɨgab rek mɨdebal. Nɨg gek, ñɨg ulɨk apɨl, karɨp sek pag jɨsɨpɨk masɨpɨk gɨ dad amnɨm ag mer nɨŋɨl, karɨp gɨ tep gɨnɨgab nɨbak kɨlɨs gɨl nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pen bin bɨ mɨnɨm yad ak nɨŋɨl, agebin rek ma gɨpal okok, bɨ karɨp gɨ lɨnɨg gɨnɨgab, kau par ma dɨl, karɨp sap ma pɨŋɨl, yokop karɨp lɨm ar ar sɨŋak gɨ lɨnɨgab rek mɨdebal. Nɨg gek, ñɨg ulɨk apɨl, karɨp sek pag jɨsɨpɨk masɨpɨk gɨ dad amnɨm, agɨl, magɨl nɨbak nep karɨp sek pɨs nep dad amek, lɨm cög nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas bin bɨ nɨb okok kɨrop mɨnɨm nɨbak ag ñɨ dai juɨl, taun sɨkol Kapaneam amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Pen taun nɨbak, bɨ kɨb ami sɨkop koŋai nep kod mɨdolɨgɨp bɨ alap mɨdek. Bɨ ognap Jisas ap Kapaneam mɨdeb agel, mɨnɨm nɨbak nɨŋɨl, Rom ami bɨ kɨb Juda bɨ mɨnɨm tɨg bɨlokep ognap ag yokɨl agak, “Bɨ mɨñ wög gɨ ñeb tep yɨb yad alap tap gɨp kɨmnɨg geb nɨŋɨl nɨbi am Jisas nop ag nɨŋɨl poŋ dɨl dapem, nop gek komɨŋ laŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Agek, kɨri Jisas mɨdek sɨŋak amjakɨl, nop mɨnɨm kɨlɨs neb neb gɨlɨg gɨ aglak, “Ami bɨ kod mɨdep bɨ kɨb alap, bɨ tep yɨb. Cɨnop Juda bin bɨ okok mɨdmagɨl lɨl per kod mɨd tep gɨp. Mogɨm gep karɨp cɨnop alap gɨ lak. Nɨb ak, nak amɨl bɨ mɨñ wög gɨ ñeb ne ak gek komɨŋ lɨnɨmɨŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kɨri agelak nɨŋɨl Jisas kɨrop eip amɨl amɨl karɨp sɨŋak ulep sɨŋak amlɨg gel nɨŋlɨg gɨ, ami bɨ kod mɨdep nɨbak bɨ nɨŋeb ne ognap ag yokek, am Jisas nop nabɨŋ pakɨl aglak, “Bɨ ami kod mɨdep bɨ cɨn ak nep ageb, ‘Bɨ Kɨb, yad bɨ tep mer, karɨp yad ak tob yur ma onɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yad bɨ tep rek nep nɨnɨm, pen yad nɨpin, God nak eip mɨdeb rek, “Komɨŋ laŋ,” mɨnɨm ak nep agenɨmɨn, bɨ yad tap gɨp nɨbak komɨŋ lɨnɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bɨ kɨb yɨb alap yɨp kod mɨdeb; yad ke pen ami bɨ okok kɨrop kod mɨdɨl, “Amnɨm!” agen ambal; “Owɨm!” agen opal; “Wög nɨbak gɨm!” agen gɨpal,’ ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nɨb agel, Jisas, bɨ nɨbak gos ne ke nɨŋɨl nɨb agɨp, agɨl, wal agɨl, bin bɨ nop kɨsen gɨl apelak okok kɨrop agak, “Ami bɨ Rom nɨb ak, yɨp nɨŋ dɨ kɨlɨs gɨp. Ne gɨp nɨbak, Isrel bɨ alap aknɨb rek gɨp yad ma nɨpin yɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pen ami bɨ kod mɨdep bɨ ak, bɨ ne okok adɨk gɨ amɨl nɨŋlak, bɨ tap gak nɨbak bɨr komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ñɨn nab nɨbak nep, Jisas eip bɨ ne okok eip Nen taun amnɨlak. Bin bɨ okok koŋai yɨb nep eip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Taun kɨjoŋ wagɨn ulep sɨŋak amjakel nɨŋlɨg gɨ, bin kaŋɨl alap ñɨ nokɨm ne tɨk dowak kɨmak ak, cɨp se yɨr ar lɨl dapelak. Bin bɨ koŋai nep taun nɨbak nɨb apɨl bin nɨbak eip apelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas bin kaŋɨl nɨbak nop nɨŋek, yɨmɨg gek agak, “Sɨl ma agan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nɨb agɨl, ne amɨl cɨp se yɨr ar lɨ dapelak mab ak dɨ nɨŋek nɨŋlɨg gɨ, bɨ yɨr ar dapelak okok wös gɨlak. Jisas bɨ praj kɨmak ak nop agak, “Ñɨ aul, nep agebin, warɨkan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɨb agek, ñɨ warɨkɨl bɨsɨg gɨl mɨnɨm agek nɨŋlɨg gɨ, Jisas nonɨm nop, ñɨ nak ak, agɨl, dɨ ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pen bin bɨ nɨŋ mɨdelak okok magɨlsek pak ju dɨl, God yɨb nop ak dap ranlɨg gɨ aglak, “God mɨnɨm agep bɨ kɨb yɨb cɨnop owɨp. God cɨnop gɨ ñɨnɨg owɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisas gak nɨbak nɨŋɨl, kesɨm del, mɨnɨm nɨbak Juda bin bɨ karɨp lɨm kɨri tɨgoŋ tɨgoŋ amɨl, karɨp lɨm ke tɨgoŋ tɨgoŋ magɨlsek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon bɨ ne okok, Jisas gak rek magɨlsek nɨŋɨl, am Jon nop ag ñel, bɨ ne omal agek aperek agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Nɨri mal amɨl Bɨ Kɨb nop ag nɨmir, ‘Nak Mesaia per kod mɨdobɨn ak nep opan aka bɨ ke nɨb alap sek kod mɨdojɨn?’ agnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Agek, bɨ omal Jisas mɨdek sɨŋak amɨl agrek, “Jon bɨ ñɨg pak ñeb ak cɨrop bɨ mal agɨp, ‘Nɨri mal amɨl Bɨ Kɨb ag nɨmir, “Nak Mesaia per kod mɨdobɨn ak nep opan aka bɨ ke nɨb alap sek kod mɨdojɨn,” agnɨmir,’ agɨl, cɨrop mal ag yokek, nep ag nɨŋnɨg apobɨr me aul,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pen kɨri mal nɨb agɨl nɨŋ mɨder nɨŋlɨg gɨ, Jisas bin bɨ koŋai nep tap ar ke ke gak okok gek komɨŋ lak; bin bɨ koŋai nep mɨñak gak okok gek komɨŋ lak; bin bɨ koŋai nep kɨjeki kɨyob ñɨlɨk abaŋ ñag mɨdek okok gek komɨŋ lak; bin bɨ koŋai nep udɨn kwoi gak okok gek udɨn ñɨl nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nɨg gɨl, Jisas bɨ nɨb omal kɨrop agak, “Nɨri mal adɨk gɨ amɨl Jon nop agnɨmir, ‘Cɨr am nɨpɨr, bɨ nɨbak bin bɨ udɨn kwoi gɨp okok gek udɨn ñɨl nɨŋebal; bin bɨ tob pɨs nep tɨmel gɨp okok gek kauyaŋ ajebal; bin bɨ mɨb goŋ soi sapeb lɨp okok gek mɨlep gɨp; bin bɨ tɨmɨd mɨgan pɨlɨŋ gɨp okok gek mɨnɨm peyɨg nɨŋebal; bin bɨ kɨmbal okok gek komɨŋ mɨdebal; bin bɨ yɨm gep rek okok mɨnɨm tep ak ageb nɨŋebal. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bin bɨ yɨp gos nɨŋɨl cɨg gɨlɨg gɨ nep mɨdenɨgal okok, mɨñ mɨñ yɨb gɨnɨgal,’ agnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nɨb agek, bɨ Jon mɨnɨm dad orek bɨ omal adɨk gɨ amer nɨŋlɨg gɨ, Jisas ne, Jon nop mɨnɨm ar ak kesɨm dɨl bin bɨ mɨdelak okok kɨrop agak, “Nɨbi ned mɨñ mab kab nep mɨdeb nab sɨŋak ambek ñɨn ak, tari nɨŋnɨg ambek? Nɨbi sɨd par nokɨm alap yɨgen dɨ kaun gɨ adaŋ aul gɨp alap nɨŋnɨg ambek? ");
INSERT INTO kmh_m_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nɨbi tari nɨŋnɨg ambek? Bɨ walɨj tep yɨb yɨmɨb alap nɨŋnɨg ambek? Nɨbak mer. Bɨ walɨj tep yɨb dɨl, tap tep tep dɨn, agɨl gos nɨpal okok, bɨ kɨb karɨp okok nep kɨnbal. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pen nɨbi tari nɨŋnɨg ambek? God mɨnɨm agep bɨ alap nop nɨŋnɨg ambek aka? Nɨŋɨd me, God mɨnɨm agep bɨ alap nop nɨŋnɨg ambek, pen bɨ Jon nɨpek ak ne wög ar ke nɨb gɨnɨg owak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bɨ Jon nɨbak me, bɨrarɨk nep God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Bɨ mɨnɨm agep yad ak ag yoken, ned amɨl, bin bɨ okok kɨrop ag ñɨ tep gɨnɨgab; kɨsen nak ke ag yoken nɨnɨgan,’ agɨl ñu kɨl tɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nɨbep agebin, bin bɨ ned mɨdelɨgɨpal okok abe, bin bɨ mɨñi mɨdebal okok abe, magɨlsek bin bɨ yokop, Jon bɨ kɨb. Pen God bin bɨ yokop okok dɨl, karɨp lɨm ne seb kab ar alaŋ sɨŋak kod mɨdenɨgab bin bɨ okok, kɨri Jon rek ma mɨdenɨgal; kɨri bin bɨ kɨb mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bin bɨ okok, bɨ takɨs dep okok sek, ned Jon nop apel, kɨrop magɨlsek ñɨg pak ñak. Nɨg gek, Jisas mɨnɨm agak ak nɨŋɨl aglak, “God kanɨb ne nep yɨpɨd gɨl mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pen bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ kɨb okok abe, kɨri tari tari gɨlaŋ, God agak mɨnɨm ak gos kɨri ke nɨŋɨl yo sɨj rɨmel nɨŋɨl, Jon cɨnop ñɨg pak ñaŋ, agɨl, ma olak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Pen Jisas bin bɨ nɨb okok kɨrop mɨnɨm alap agɨl agak, “Bin bɨ mɨñi ñɨn aul mɨdebɨm okok yad nɨpin, kɨri ñɨ pai sɨkol okok, bin bɨ mogɨm gep kau sɨŋak bɨsɨg gɨl, ñɨ pai sɨkol ognap meg mɨgan dap ranɨl ag amɨl apɨl gɨl apal, ‘Cɨn akɨl pɨgon, nɨbi tari gɨnɨg kogɨm ma papɨm? Pen kɨmep sɨl agep rek alap agon, nɨbi tari gɨnɨg sɨl ma apɨm?’ apal rek ak, nɨbi gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tari gɨnɨg: Jon bɨ ñɨg pak ñeb ak apɨl, tap magɨl ma ñɨbɨl, ñɨg wain ma ñɨbɨl gek, nɨbi nop ag juɨl apɨm, ‘Bɨ kɨjeki kɨyob ñɨlɨk abaŋ ñagɨp mɨdeb ak,’ apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pen mɨñi yad Bɨ Ñɨ ne apɨl, tap ñɨbɨl, ñɨg wain ñɨbɨl gen, yɨp ag juɨl agebɨm, ‘Tap koŋai ñɨbɨl, ñɨg wain ñɨbɨl geb ak me, ne bin bɨ tap si tap tɨmel gɨpal bɨ okok, bɨ takɨs dep bɨ okok, bɨ kɨri alap mɨdeb ak,’ agɨl agebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pen bin bɨ God Mɨnɨm tep ak nɨŋ dɨl, kɨsen gɨl, gɨ tep gɨl, mɨd tep genɨgal ak, bin bɨ okok kɨrop nɨŋɨl agnɨgal, God Mɨnɨm ak mɨnɨm nɨŋɨd yɨb, agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bɨ Perisi alap yɨb ne Saimon. Ne Jisas nop agak, “Nak onɨmɨn karɨp yad ak tap magɨl ñɨŋɨr,” agak. Agek, Jisas karɨp ne ak amɨl tap magɨl ñɨbel nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","bin taun nɨbak mɨdɨl tap si tap tɨmel golɨgɨp mɨnɨm alap agel nɨŋak, Jisas bɨ Perisi karɨp amɨl eip tap ñɨberek. Nɨb ak nɨŋɨl, ñɨg ki tep owep kab barol dɨ tɨm lɨlak alap dapɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisas mɨdek kɨd ken okok apɨl, tob wagɨn sɨŋak sɨl ag mɨdek. Nɨg gɨl sɨl agek nɨŋlɨg gɨ, udɨn ñɨg ak pɨg gɨ rɨk Jisas tob ar eyaŋ yapek, kɨmkas ne ak dɨ lɨlɨg gɨ yoklɨg gɨ, tob kɨd ne ak bom sɨlokɨl, mɨlɨk ñɨbɨl, ñɨg ki tep owep nɨbak tob kɨd ne ar sɨŋak soŋ gɨ lɨ ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nɨg gek, bɨ Perisi Saimon ak, gos magɨl nab ne ak nep gos nɨŋɨl ne ke agak, “Bɨ nɨbaul bɨ God mɨnɨm agep yɨpɨd gɨl mɨdobkop, bin nɨbaul ne tap si tap tɨmel gɨp bin tɨmel alap apɨl nop dɨ nɨŋeb ak tɨk dam nɨpkop,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas pen, bɨ Perisi gos nɨŋak nɨbak nɨŋɨl, nop agak, “Saimon, mɨnɨm yad nokɨm alap mɨdeb nep ag ñɨnɨg gebin,” agak. Agek, Saimon agak, “Mɨnɨm ag ñeb bɨ yad, mɨnɨm nɨbak agan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Agek, Jisas mɨnɨm sɨd tɨkɨl agak, “Bɨ alap warɨkɨl, bɨ omal kɨrop bɨ alap paip hadred (500) denariai ñɨl, alap pipti denariai (50) ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pen kɨsen bɨ nɨb omal pen ñeb rek ma lek, bɨ mani ñɨnɨgab nɨbak kɨrop mal agnɨgab, ‘Yem gir. Mani nɨrep mal ñɨbin ak, pen ñɨr, agɨl gos ak ma nɨŋnɨmir,’ agnɨgab. Nɨb agek, bɨ an bɨ nɨbak nop mɨdmagɨl yɨb lɨnɨgab, bɨ tap dai kɨb mɨdenɨgab ak aka bɨ tap dai sɨkol mɨdenɨgab ak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Agek, Saimon agak, “Gos yad nɨŋebin ak, bɨ tap dai kɨb mɨdenɨgab ak,” agak. Agek, Jisas agak, “Nɨŋɨd yɨb ageban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nɨb agɨl, Jisas adɨk gɨl bin ak nop nɨŋɨl, Saimon nop agak, “Bin aul nop nɨŋan. Yad karɨp ñɨlɨk mɨgan nep aul apesin, nak ñɨg alap dɨl tob kɨd yɨp lɨg gɨ yokep ognap ma ñɨban, pen bin nɨbaul, udɨn ñɨg ne ak pɨg gɨ rɨk yapɨl tob yad ñɨg lek, kɨmkas ne dɨl lɨlɨg gɨ yokɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nak yɨp tɨg bom ma sɨlokpan, pen bin aul, yad karɨp ñɨlɨk mɨgan nep apjakesin won ak tɨkek, ne tob kɨd yad tɨg bom sɨloklɨg gɨ nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yɨp wel nabɨc cög alaŋ ma lɨ ñɨban, pen bin aul ne tob kɨd yad ñɨg ki tep owep ak soŋ gɨ lɨ ñɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nɨb ak, nep agebin, bin nɨbaul tap si tap tɨmel koŋai nep gɨp ak nɨŋɨl yem gebin. Nɨb ak, ne yɨp pen mɨdmagɨl yɨb leb. Pen bin bɨ tap si tap tɨmel sɨkol sɨkol gɨpal okok nɨŋɨl yem gen, yɨp pen mɨdmagɨl sɨkol sɨkol lɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pen Jisas nɨb agɨl bin nɨbak nop agak, “Tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nɨb agek, bɨ ne eip tap ñɨbelak okok, kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “Bɨ nɨbaul tari gɨnɨg, ‘Tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gebin,’ ageb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nɨb agelak ak pen Jisas bin nɨbak nop agak, “Gos nak ke ak nep nɨŋ dɨl, tap si tap tɨmel gɨpin okok Jisas nɨŋɨl kɨrɨg gaŋ, agɨl opan rek, tap si tap tɨmel gɨpan okok nɨŋɨl kɨrɨg gɨpin. Nak amɨl, God ñɨnmagɨl arak ar ne ak mɨdenɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pen kɨsen ñɨn nab nɨb sɨŋak, Jisas bɨ ne aknɨb umɨgan alaŋ eip taun okok abe, karɨp tɨrɨg tɨroŋ okok abe amɨl, God bin bɨ ne dɨl kod mɨdenɨgab mɨnɨm tep ak, bin bɨ okok kɨrop ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pen ñɨn nɨbak, bin ognap kɨjeki kɨyob ñɨlɨk sek mɨdelak okok Jisas gek komɨŋ lak, ognap tap gak okok gek komɨŋ lak, nɨŋɨl bin nɨb okok ognap Jisas eip ajölɨgɨpal. Bin nɨb okok yɨb kɨri me, alap Maria Magdala agölɨgɨpal. Kɨjeki kɨyob ñɨlɨk aknɨb ar oŋɨd bin nɨbak nab adaŋ mɨdɨl söŋ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bin alap Joana. Nɨgmɨl ne yɨb ak Kuja. Ne kiŋ Herod karɨp tap ne okok kod mɨdolɨgɨp. Bin alap Susana. Pen bin ognap sek koŋai nep eip ajölɨgɨpal. Bin nɨb okok kɨri magɨlsek mani kɨri ke dɨl, tap magɨl tau dapɨl, Jisas bɨ ne okok eip tap magɨl jɨm ñɨl ñɨb ajölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bin bɨ taun ke ke, yakam ñon kɨb yɨb okok nɨb okok nɨb Jisas nop nɨŋnɨg apel nɨŋlɨg gɨ, bin bɨ ned olak okok kɨrop mɨnɨm alap sɨd tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Bɨ alap, goñbɨl magɨl tanaŋ, agɨl, goñbɨl magɨl ak dam wög dai okok yoknɨgab. Ognap wög dai ameb majɨl okok yapek, bin bɨ talak gɨ amɨl apɨl gel, yakɨr okok pen ap nɨŋɨl ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pen yɨŋ ognap kab ar lɨm sɨkol sɨkol mɨdenɨgab okok yapɨl, marɨp gɨnɨgab ak pen kab lɨm sɨŋak ñɨg ñɨg sek ma mɨdenɨgab ak me, pɨs nep mɨlep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pen yɨŋ ognap nag kɨlɨkasɨk nab okok yapek, nag nɨbak sau gɨ pak ñɨbek, tan tep ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pen yɨŋ ognap lɨm tep sɨŋak yapɨl, tan tep gɨl, magɨl koŋai yɨb nep pɨlnɨgab. Nokɨm nokɨm magɨl ñɨn juɨl aknɨb mamɨd alaŋ pɨlnɨgab,” agak. Jisas kɨrop nɨb agɨl agak, “Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas mɨnɨm sɨd tɨkɨl kesɨm nɨbak agek, bɨ ne okok nop ag nɨŋɨl aglak, “Mɨnɨm sɨd tɨkɨl agesan nɨbak, mɨnɨm wagɨn ak titi gɨl rek mɨdeb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Agelak, Jisas kɨrop agak, “God bin bɨ ne dɨl kod mɨdenɨgab mɨnɨm we gɨl mɨdolɨgɨp ak, God nɨbep gos ñek nɨŋebɨm, pen bin bɨ ognap okok, yad kɨrop mɨnɨm sɨd tɨkɨl nep agen, ‘kɨri nɨŋɨl ma nɨŋnɨmel, mɨnɨm magɨl peyɨg nɨŋɨl mɨnɨm wagɨn ma nɨŋ dɨnɨmel.’ ");
INSERT INTO kmh_m_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pen mɨnɨm sɨd tɨkɨl tap yɨŋ rek agesin ak, God Mɨnɨm ar ak agesin. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yɨŋ ognap yonɨgab wög dai ameb majɨl ar sɨŋak agesin ak, bin bɨ okok God Mɨnɨm ak nɨŋnɨgal ak pen Seten gos tɨmel nɨŋɨl, kɨri God Mɨnɨm ak nɨŋ del, God kɨrop dɨ komɨŋ yoknɨgab ak tɨmel gɨp, agɨl, apɨl God Mɨnɨm gos kɨrop nab adaŋ mɨdeb ak tɨg ju dek, saköl gɨnɨgal, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pen yɨŋ ognap yonɨgab kab ar lɨm sɨkol sɨkol mɨdenɨgab okok agesin ak, bin bɨ okok God Mɨnɨm ak nɨŋɨl, mɨñ mɨñ gɨlɨg gɨ, mɨnɨm nɨbak nɨŋ dɨnɨgal ak pen nɨŋ dɨ kɨlɨs ma gɨnɨgal rek, mɨker ognap apek saköl gɨl kɨrɨg gɨnɨgal, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pen yɨŋ ognap yonɨgab nag kɨlɨkasɨk nab okok agesin ak, bin bɨ okok God Mɨnɨm ak nɨŋnɨgal ak pen kɨsen mɨnɨm mɨker aka mani kɨb tap okok aka mɨñ mɨñ gep ar ak nep gos nɨŋɨl, God Mɨnɨm nɨŋ dɨ kɨlɨs ma gɨnɨgal, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pen yɨŋ ognap lɨm tep ar sɨŋak yapɨl, tan tep gɨl, magɨl koŋai yɨb nep pɨlnɨgab agesin ak, bin bɨ okok God Mɨnɨm ak nɨŋɨl, nɨŋ dɨ kɨlɨs yɨb gɨl, gɨ dam dam, tap magɨl tep pɨlnɨgab, agɨl agesin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas nɨb agɨl agak, “Bin bɨ okok sɨp dagɨl tin cög mɨgan aka abañ ar kɨnbal ak mok okpi okok we ma gɨnɨgal. Ar sɨŋak alaŋ tɨk lel melɨk gek, bin bɨ okok karɨp ñɨlɨk mɨgan nɨbak apɨl melɨk nɨbak nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ak rek nep me, tap tari tari we gɨl mɨdeb okok, magɨlsek mɨseŋ lɨnɨgab; tap tari tari karɨkɨl mɨdeb okok, magɨlsek dɨ melɨk geb sɨŋak lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nɨb ak, mɨnɨm agebin ak nɨŋ tep gɨnɨmɨb. Bin bɨ mɨnɨm nɨŋɨl, nɨŋ dɨnɨgal okok, mɨnɨm tep ognap sek nɨŋnɨgal; pen bin bɨ mɨnɨm nɨŋɨl ma nɨŋ dɨnɨgal okok, sɨkol sɨkol nɨŋɨn agɨl nɨpal ak sek, pɨs nep kɨr gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pen ñɨn nɨbak nep, Jisas nonɨm eip, nɨmam kɨsen ne okok eip, Jisas nop nɨŋnɨg olak. Apɨl nɨŋlak, karɨp ñɨlɨk mɨgan nɨb eyaŋ Jisas bin bɨ tɨbɨk dɨl mɨdelak nɨŋɨl mɨs okeyaŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nɨg gel, bin bɨ karɨp ñɨlɨk mɨgan ap mɨdelak okok nɨŋɨl, bɨ alap Jisas nop agak, “Nanɨm namam nak okok nep nɨŋnɨg ap mɨdebal söŋ eyaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Agek, Jisas agak, “Bin bɨ God Mɨnɨm ak nɨŋɨl kɨsen gɨpal bin bɨ okok me, ami yad, mam yad mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pen ñɨn alap, Jisas bɨ ne okok kɨrop agɨl agak, “Ñɨg Cöb Galili juɨl pɨs kɨdadaŋ amnɨn,” agɨl, ñɨg magöb dɨl amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pen nab okok amel nɨŋlɨg gɨ, Jisas ne wɨsɨn kɨn amnak. Wɨsɨn kɨnek won ak, yɨgen asad kɨb yɨb apɨl ñɨg nab nɨbak dɨl, ñɨg pag ñɨg magöb mɨgan ak apek, kɨmnɨmel rek nep lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nɨg gek, bɨ ne okok apɨl, Jisas nop kaun gel warɨkek aglak, “Bɨ Kɨb! Cɨn magɨlsek kɨmnɨg gobɨn!” aglak. Agelak, Jisas yɨgen dek ak abe, ñɨg pag apek ak abe ag gek, won nɨbak nep yɨgen ak kɨr gɨl, ñɨg ak ulekɨl, ned mɨdek rek mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pen Jisas bɨ ne okok kɨrop agak, “Nɨbi ti gɨnɨg yɨp ma nɨŋ dɨpɨm?” agak. Agek, kɨri pɨrɨkɨl kɨb gaul gɨl, kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “Bɨ nɨbaul bɨ an? Ne agek, yɨgen abe, ñɨg kɨb abe mɨnɨm ne ageb rek nep geb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ñɨg magöb dɨl, amɨl Ñɨg Cöb Galili nab sɨŋak amɨl amɨl, karɨp lɨm Gerasa bin bɨ mɨdelɨgɨpal pɨs kɨdadaŋ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pen Jisas ñɨg magöb ak kɨrɨg gɨl, ñɨg cöb gol sɨŋak kab kɨlɨp ar sɨŋak tob tau gek nɨŋlɨg gɨ, magɨl nɨbak nep, kɨjeki kɨyob ñɨlɨk abaŋ ñag mɨdelak bɨ alap, taun nɨbak nɨb apɨl, Jisas nop nabɨŋ pakak. Bɨ nɨbak ne magɨl nep mɨdɨl, karɨp yɨb ñɨlɨk mɨgan ak ma kɨnolɨgɨp; cɨp tɨgel gölɨgɨpal kab mɨgan okok nep kɨn ajolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bɨ ne kod mɨdep okok, sen dɨl ñɨnmagɨl tob ne okok ñon gɨ kɨlɨs gölɨgɨpal ak pen kɨjeki tap okok apɨl kɨlɨs gel, sen lölɨgɨpal nɨb okok pɨg gɨ rɨkek, mɨñ mab nep nab okok per per amolɨgɨp. Pen bɨ nɨbak, Jisas nop nɨŋɨl wal agɨl, apɨl tob wagɨn sɨŋak yap pakak. Jisas kɨjeki kɨyob ñɨlɨk nop abaŋ ñaglak nɨb okok kɨrop agak, “Bɨ nɨbaul nop kɨrɨg gɨl söŋ amnɨm!” agak. Jisas nɨb agek, kɨjeki kɨyob ñɨlɨk nop abaŋ ñaglak bɨ ak, coco gɨl, mɨnɨm kɨb agɨl agak, “Nak Jisas, God Bɨ Kɨb ar i oklaŋ mɨdeb Ñɨ ne ak, yɨp tari gɨnɨg geban? Yɨp yur kɨb ma ñɨnɨmɨn!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Agek, Jisas agak, “Yɨb nak ak agan!” agak. Jisas agek, ne pen agak, “Yɨb yad ak Koŋai Nep,” agak. Kɨjeki kɨyob ñɨlɨk tap okok koŋai yɨb nep nop yɨpɨl sɨkɨl mɨdelak rek ak me, nɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pen kɨjeki kɨyob ñɨlɨk okok Jisas nop neb neb gɨl aglak, “Cɨnop agenɨmɨn, mab ke eyaŋ kau mɨgan kɨrɨŋ ma juɨp ak ma ag yoknɨmɨn!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nɨb agɨl, kaj koŋai yɨb nep amɨl ñɨbelak yokop pɨrbak nɨb okok nɨŋɨl, Jisas nop neb neb gɨl aglak, “Nak cɨnop agek, am kaj mɨdebal okdaŋ kɨrop yɨpɨl sɨkɨn,” agel, Jisas yau agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jisas yau agek, kɨjeki kɨyob ñɨlɨk tap okok, bɨ ak nop kɨrɨg gɨl, am kaj nɨb okok kɨrop yɨpɨl sɨkel, kaj okok pɨg ju mak bak eyaŋ amɨl, gɨ dam ñɨg cöb nab eyaŋ pakɨl, ñɨg ñɨbɨl magɨlsek kɨm saklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pen bɨ kaj mɨkelɨgɨpal okok, gak nɨbak nɨŋɨl, pɨg gɨ rɨkɨd ag amɨl, bin bɨ taun mɨdelak okok kɨrop ag ñɨl, amɨl bin bɨ karɨp lɨm taun ulep sɨŋak mɨdelak okok kɨrop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ag ñel, tap nɨbak tari geb agebal, agɨl, apɨl nɨŋlak, bɨ kɨjeki yɨpɨl sɨkɨl mɨdolɨgɨp ak, komɨŋ lek, walɨj yɨmɨl, Jisas tob wagɨn ulep sɨŋak bɨsɨg mɨdek. Kɨri nɨbak nɨŋɨl jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pen bin bɨ nɨŋ mɨdel nɨŋlɨg gɨ, Jisas kɨjeki ag söŋ yokak ak, bin bɨ okok, bin bɨ kɨsen olak okok kɨrop, nɨb nɨb gɨp, agɨl, ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pen Gerasa bin bɨ magɨlsek jel gek pɨrɨkɨl, Jisas nop, nak adɨk gɨ amnoŋ agel, ñɨg magöb dɨl paŋdak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jisas kɨrɨg amnɨg gek nɨŋɨl, ne gek kɨjeki kɨyob ñɨlɨk söŋ amnɨlak bɨ nɨbak, nop mɨnɨm neb neb gɨl agak, “Yad nak eip amnɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nɨb agek, Jisas nop pen agak, “Mer. God nep tap tep yɨb tari tari gɨp ak, nak karɨp nak amɨl bin bɨ nak okok kɨrop ag ñɨnɨmɨn,” agak. Nɨb ak, ne taun ne adɨk gɨ amɨl, bin bɨ okok kɨrop magɨlsek, Jisas yɨp nɨb nɨb gɨp, agɨl, ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pen bin bɨ Jisas apeb, agɨl, kod mɨdelak okok, Jisas ñɨg magöb dɨl amjakek, use tep yɨb apeban e, aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Pen bɨ kɨb Juda mogɨm gep karɨp kod mɨdolɨgɨp bɨ alap yɨb ne Jairas. Pai ne nokɨm yɨb mɨ yɨn lak umɨgan alaŋ ak kɨmnɨg gek, Jairas ne apɨl, Jisas mɨdek ulep sɨŋak kogɨm yɨmɨl agak, “Karɨp yad amnɨr. Pai yad nokɨm ak kɨmnɨg geb,” agak. Agek, Jisas nɨŋnɨg amek nɨŋlɨg gɨ, bin bɨ koŋai yɨb nep apɨl, nop pɨs pɨs cɨrok cɨrok ñɨlɨg gɨ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pen bin alap per per ne bin ajep amolɨgɨp mɨ aknɨb umɨgan alaŋ lak. Bin nɨbak, soi ñon gep bɨ okok yɨp gel, yɨp komɨŋ laŋ, agɨl, kɨrop mani ñolɨgɨp ak pen nop gel mɨlep gɨnɨmɨŋ rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ne Jisas amek kɨd ken pɨs apɨl, walɨj par kɨb lak ak dɨ nɨŋek nɨŋlɨg gɨ, magɨl nɨbak nep nop mɨlep gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pen Jisas kɨrop agak, “Yɨp bɨ an dɨ nɨŋɨp?” agak. Agek, bin bɨ okok aglak, “Cɨn ma dɨ nɨpɨn,” aglak. Pen Pita agak, “Bɨ Kɨb, bin bɨ koŋai nep sɨŋ aul apɨl, nep cɨrok cɨrok ñebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Agek, Jisas agak, “Bin bɨ alap yɨp dɨ nɨŋosɨp. Kɨlɨs yad ak amɨb nɨŋɨl agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pen bin Jisas dɨ nɨŋak nɨbak, ne we gɨnɨmɨŋ rek ma lak ak nɨŋɨl, jep jep dɨlɨg gɨ, Jisas mɨdek ulep sɨŋak ap kogɨm yɨmak. Bin bɨ nɨb okok nɨŋ mɨdelak nab okok Jisas nop agɨl, ne tap gak ak, Jisas dɨ nɨŋek, magɨl nɨbak nep komɨŋ lak kesɨm ak magɨlsek mɨseŋ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Agek, Jisas nop agak, “Pai yad. Nak yɨp dɨ nɨŋen komɨŋ laŋ agɨl nɨŋ dɨpan ak, yɨp dɨ nɨŋek komɨŋ lɨp me ak. Mɨnɨm ma mɨdeb. Nak amɨl, God ñɨnmagɨl arak ar ne ak mɨdenɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas nɨb agek nɨŋlɨg gɨ, bɨ Jairas nop wög golɨgɨp bɨ alap apɨl, Jairas nop agak, “Pai nak pɨs nep kɨmɨb; ag ñeb bɨ nop agek tob yur ma onɨmɨŋ; adɨk gɨ amnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Agek, Jisas mɨnɨm nɨbak nɨŋɨl, Jairas nop agak, “Pai yad ak bɨr kɨmɨb, agɨl, gos ak ma nɨŋnɨmɨn. Nɨŋ denɨgan ak, nop komɨŋ lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisas nɨb agɨl, Jairas karɨp ne ak amjakɨl, bin bɨ okok kɨrop magɨlsek ag söŋ sɨŋ eyaŋ lɨl, pai nonɨm nap ber mal, Pita ak, Jon ak, Jems ak kɨrop poŋ dɨl, pai ak nop nɨŋnɨg karɨp ñɨlɨk mɨgan eyaŋ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pen bin bɨ, pai nɨbak kɨmɨb, agɨl, sɨl ag mɨdelak okok, Jisas kɨrop agak, “Nɨbi sɨl ma agɨm. Pai ak ma kɨmɨb; yokop wɨsɨn kɨneb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jisas nɨb agek, bin bɨ okok, pai nɨbak pɨs nep kɨmɨb ak nɨŋɨl, nop sɨk aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pen Jisas pai ak ñɨnmagɨl kɨd ne ak dɨl agak, “Pai yad, warɨkan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɨb agek, kaun ne ak apɨl kauyaŋ kauper gek warɨkak. Warɨkek, Jisas agak, “Tap ognap ñem ñɨŋaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pai nonɨm nap kɨri kɨb gaul gɨrek. Pen Jisas kɨrop ber mal agak, “Bin bɨ ognap kɨrop mɨnɨm nɨbak ma ag ñɨnɨmir, mer!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jisas bɨ ne aknɨb umɨgan alaŋ kɨrop agek apelak agak, “Yad nɨbep bɨ yad, kɨlɨs yad ke ñɨl, ag yoknɨgain. Nɨb ak, nɨbi okok amɨl, kɨjeki kɨyob ñɨlɨk bin bɨ yɨpɨl sɨkɨl mɨdebal okok agem söŋ amnɨmel; bin bɨ tap gɨp okok gem komɨŋ lɨnɨmɨŋ; bin bɨ mɨñak gɨp okok gem sɨn lɨnɨmɨŋ; God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak ag ñem nɨŋnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pen amnɨg gɨl, kɨsal dai, wad, tap ñɨŋeb, mani, walɨj, tap okok sek ma dad amnɨmɨb; yokop amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Taun alap amɨl karɨp alap amjakem, nɨbep ag denɨmel, kɨrop eip kɨn mɨdɨl, taun nɨbak kɨrɨg amnɨn agnɨgabɨm ak, magɨl ak nep kɨrɨg amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pen karɨp lɨm mɨgan alap amem, nɨbep ma ag denɨmel, taun nɨbak kɨrɨg amnɨn, agnɨgabɨm ak, kɨrop agnɨmɨb, ‘Mɨnɨm tep ak daposɨn ma dɨpɨm rek, lɨm dai nɨbep aul aposɨn, tap acɨp acɨp tob cɨnop dɨp ak lɨg gɨ yokɨl amobɨn,’ agɨl, lɨg gɨ yokɨl amnɨmɨb. Nɨg genɨgabɨm, kɨri gɨ tɨmel gɨpal ak nɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nɨb agek, kɨri karɨp tɨrɨg tɨroŋ magɨlsek tɨgoŋ tɨgoŋ amɨl amɨl mɨnɨm tep ak ag ñɨlɨg gɨ, bin bɨ mɨñak gak okok gel komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pen bin bɨ okok, Jisas tari tari gak mɨnɨm ak ag amɨl apɨl gel nɨŋlɨg gɨ, gapman bɨ kɨb Herod nɨŋɨl, gos par yɨb nɨŋak. Bin bɨ ognap aglak, “Jon bɨ ñɨg pak ñeb kɨŋam tɨb gɨ rɨk gɨlak kɨmak ak, kauyaŋ warɨkɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ognap aglak, “Bɨ ned nɨb God mɨnɨm agep bɨ ak Ilaija ne owɨp,” aglak. Ognap aglak, “Bɨ bɨrarɨk ped okok God mɨnɨm ag ñolɨgɨp bɨ alap kauyaŋ komɨŋ lɨl owɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nɨb agel, bɨ kɨb Herod agak, “Jon nop kɨŋam tɨb gɨ rɨk gen bɨr kɨmak rek, bɨ nɨbak bɨ an ap mɨdek nɨŋlɨg gɨ agebal ak am nɨŋnɨm,” agɨl, gos ak nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pen Jisas bɨ ne aknɨb umɨgan alaŋ adɨk gɨ apɨl, karɨp lɨm okok ajɨl tap tari tari gɨlak mɨnɨm ak, Jisas nop ag ñɨlak. Ag ñel, am karɨp lɨm mɨgan alap ke am mɨdojɨn, agɨl, Jisas kɨrop poŋ dɨl Betsaida taun sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pen majɨl nab okok amel nɨŋlɨg gɨ, bin bɨ ognap aglak, “Jisas bɨ ne okok eip apɨl padɨkebal,” aglak. Nɨb agel, bin bɨ koŋai nep nop nɨŋnɨg kɨsen gɨlak. Apelak, ne tep apebɨm e, agɨl, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm ak kɨrop ag ñɨlɨg gɨ, bin bɨ tap gak okok gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pen dɨgep pɨb paŋɨd amnɨg gek magɨl ak, bɨ ne aknɨb umɨgan alaŋ apɨl, Jisas nop aglak, “Karɨp lɨm sɨŋ aul, bin bɨ ma mɨdebal, mɨñ mab nep nab sɨŋaul mɨdobɨn rek ak, bin bɨ sɨŋ aul kɨrop ag yokek, karɨp bin bɨ mɨdebal okok ke ke amɨl, tap ñɨŋeb kɨri okok ke pɨyo nɨŋɨl, kɨneb mɨgan okok pɨyo nɨŋlaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nɨb agelak, Jisas pen agak, “Nɨbi ke tap magɨl kɨrop ñɨm,” agak. Agek, kɨri aglak, “Cɨn tap ñɨŋeb koŋai ma mɨdeb. Yokop bred magɨl aknɨb mamɨd alaŋ mɨdɨl, kɨbsal omal mɨdeb. Nak tari gos nɨŋeban? Bin bɨ sɨŋ aul koŋai nep mɨdebal ak, cɨn am tap ñɨŋeb kɨrop ognap tau dowɨn aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ñɨn nɨbak, bin bɨ apɨl mogɨm gɨlak okok, bin ñɨ pai okok mer, bɨ okok nep me wök pagel paip tausan (5000) rek amnak. Pen Jisas bɨ ne okok kɨrop agak, “Bin bɨ koŋai nep ap mɨdebal sɨŋ aul agem, bin bɨ aknɨb ñɨnjuɨl omal adɨk gɨ dam aknɨb wajrem alaŋ (50) ñon ke ke bɨsɨglaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Agek, bɨ ne okok ne agak rek nep gel, bin bɨ okok magɨlsek sɨŋak bɨsɨglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ne bred magɨl aknɨb mamɨd alaŋ dɨl, kɨbsal omal sek dɨl, kɨlan gɨ seb kab ar alaŋ sɨŋak nɨŋɨl, God nop tep agɨl, tap ñɨŋeb nɨbak tɨ paŋɨl, bɨ ne okok kɨrop ñek, kɨri pen dɨl, bin bɨ okok kɨrop nonɨm lɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ñelak, kɨri magɨlsek ñɨb damɨl, ñɨb saknɨmel rek ma lek, dai dai yepɨl yepɨl gɨlak okok, bɨ ne okok dɨ wad aknɨb umɨgan alaŋ yɨgel ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pen ñɨn alap, Jisas amɨl ke sɨŋak God nop sobok gɨ mɨdɨl, bɨ ne okok kɨrop ag nɨŋɨl agak, “Bin bɨ okok yɨp bɨ an ag gos nɨpal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Agek aglak, “Bin bɨ ognap nep Jon bɨ ñɨg pak ñeb ak ag gos nɨpal; ognap nep bɨ ned nɨb God mɨnɨm agep bɨ ak Ilaija ag gos nɨpal; ognap nep bɨ bɨrarɨk ped okok God mɨnɨm ag ñolɨgɨp bɨ alap kauyaŋ komɨŋ lɨl owɨp ag gos nɨpal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Agelak, Jisas kɨrop pen ag nɨŋak, “Pen nɨbi ke yɨp bɨ ban, agɨl, gos nɨŋebɨm?” agak. Agek, Pita pen agak, “Nak God Krais ne ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nɨb agek, Jisas kɨrop agak, “Mɨnɨm nɨbak bin bɨ ognap kɨrop ma ag ñɨnɨmɨb, mer yɨb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jisas nɨb agɨl, mɨnɨm alap agɨl agak, “Bɨ Ñɨ ne nop yur kɨb yɨb ñɨnɨgal. Bɨ mɨnɨm tɨg bɨlokep okok, bɨ God nop tap sobok gep bɨ kɨb okok, bɨ lo mɨnɨm ag ñeb bɨ okok, nop nɨŋel mɨlɨk yapek ñag pak lel, kɨmnɨgab ak pen ñɨn omal mɨdɨl mɨnek ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pen Jisas bɨ ne okok abe, bin bɨ mɨdelak okok abe, kɨrop magɨlsek agɨl agak, “Bin bɨ yɨp kɨsen gɨn, agɨl, gos nɨŋenɨgal okok, tap lɨm dai ar wagɨn aul gos kɨb nɨpal ak kɨrɨg gɨl, mɨb goŋ kɨri ke gos kɨb nɨpal ak kɨrɨg gɨl, ñɨn nokɨm nokɨm mab kros kɨri dɨ ka gɨl yɨp kɨsen gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bin bɨ an an, mɨb goŋ cɨn ke, komɨŋ mɨdep magɨl cɨn ke, gos nɨŋɨl mɨd tep gɨnɨgabɨn, agɨl gos nɨŋnɨgal bin bɨ okok, pɨs nep ap yap paknɨgal. Pen bin bɨ an an, Jisas nop nɨŋ dɨl, mɨb goŋ cɨn, komɨŋ mɨdep magɨl cɨn, tari tari gɨnɨgab ak mɨnɨm ma mɨdeb, agɨl gos nɨŋnɨgal bin bɨ okok, komɨŋ mɨdep magɨl ak dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bin bɨ tap lɨm dai ar wagɨn aul dɨn, agɨl gel amnɨgab bin bɨ okok, tap tep tep okok dɨl, lɨm dai ar wagɨn aul mɨd tep gɨnɨgal, pen kɨsen kɨmɨl lɨm dai ar wagɨn aul kɨrɨg gɨl, God eip per per mɨdenɨmel rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bin bɨ an yɨp nabɨŋ gek, yad Jisas nop ma nɨpin, agɨl, mɨnɨm yɨp ma nɨŋ dɨnɨgab ak, yad kɨsen Bapi cɨr apɨl melɨk tep ke ak dɨl, ejol sɨŋ melɨk tep sek okok eip onɨgain ñɨn ak, bɨ nɨbak nop nabɨŋ gek, ma nɨpin agnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pen nɨbep nɨŋɨd yɨb agebin, bin bɨ mɨñi mɨdebɨm sɨŋ aul ognap ma kɨmnɨgabɨm; komɨŋ nep mɨdɨl, God bin bɨ dɨl kod mɨdenɨgab ñɨn ak nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas nɨb agɨl, ñɨn aknɨb jɨl oŋɨd rek mɨdɨl, Jon, Jems, Pita kɨrop poŋ dɨl, God nop sobok gɨnɨg gɨ yokop dɨm nɨb sɨŋak amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Amɨl, God sobok gɨ mɨdek nɨŋlɨg gɨ, mɨlɨk dai ne ke yɨb lɨl, walɨj ne tɨd yɨb lɨl, melɨk aknɨb ke yɨb gek nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Nɨg gek nɨŋlɨg gɨ, bɨ bɨrarɨk nep kɨmrek, Mosɨs eip, Ilaija eip, God melɨk tep aknɨb ke magɨl ak dɨl apɨl, Jisas Jerusalem amɨl kɨmɨl, wög ne gɨ saknɨg gek mɨnɨm ak ag mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pen Pita, Jems, Jon kɨrop yakam wɨsɨn apek, udɨn jɨk jɨk gɨlɨg gɨ mɨdelak, pen mɨdarɨk kɨri udɨn ñɨl nɨŋɨl, Jisas melɨk tep ne ak abe, bɨ nɨb omal Jisas eip warɨk mɨderek okok abe, nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bɨ nɨb omal amnɨg ger nɨŋlɨg gɨ, Pita gos nɨŋ tep gɨl mer, Jisas nop agak, “Bɨ Kɨb, cɨn sɨŋaul mɨdobɨn ak, tep yɨb mɨdobɨn. Nak cɨnop yau agek, karɨp badak yokop omal nokɨm, nep alap, Mosɨs nop alap, Ilaija nop alap gɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nɨb agek nɨŋlɨg gɨ, magɨl nɨbak nep, kɨmi tɨd kɨb alap apɨl kɨrop magɨlsek kob ñek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pen mɨnɨm alap kɨmi nab sɨŋak nɨb apɨl agak, “Bɨ aul Ñɨ yad; yad nop ag lɨnek. Nɨbi mɨnɨm ne agnɨmɨŋ rek nɨŋnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mɨnɨm ag dai juek, magɨl nɨbak nep nɨŋlak, bɨ nɨb omal kɨri ma mɨderek; Jisas nep mɨdek. Pen dɨm yɨrɨk alaŋ mɨdɨl, tap gak ak nɨŋelak ak, ñɨn nab nɨb sɨŋak bin bɨ ognap kɨrop ma ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pen mɨnek, dɨm gol alaŋ mɨdelak nɨbak kɨrɨg gɨl, majɨl sɨŋak kɨyan gɨ ap yapel nɨŋlɨg gɨ, bin bɨ koŋai nep apɨl kɨrop nabɨŋ paklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bɨ alap bin bɨ nab nɨbak sɨk kɨb agɨl agak, “Mɨnɨm ag ñeb bɨ. Ñɨ yad nokɨm aul, nak nop yɨmɨg nɨŋnɨmɨn, agɨl, dapebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kɨjeki kɨyob ñɨlɨk per nop abaŋ ñag mɨdɨl nop gek, sɨk kɨb yɨb agɨl gɨ dam pakɨl, kɨñɨk kobkob kosɨb masɨb apɨl, kɨm dam nab lɨlɨg gɨ apeb. Nop nɨg gɨl, per per nep gek gek me, ne yur mab dɨlɨg gɨ mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bɨ nak okok kɨrop, kɨjeki mɨdeb nɨbak ag yokɨm, apin ak pen kɨri ag yok mer nɨŋɨl kɨrɨg gɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nɨb agek, Jisas agak, “Bin bɨ mɨñi mɨdebɨm lɨm dai wagɨn aul, ñɨn akal mɨnɨm nɨŋ dɨnɨgabɨm? Yad bɨrarɨk nep mɨker nɨbep dad ajebin; pen kɨsen ñɨn titi gɨl mɨker nɨbi dɨ amnɨm?” agak. Nɨb agɨl, bɨ nɨbak nop agak, “Ñɨ nak nɨbak ulep sɨŋaul dowan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jisas nɨb agek, ñɨ nɨbak dad apek nɨŋlɨg gɨ, kɨjeki kɨyob ñɨlɨk ñɨ ak nop kɨlɨs yɨb gɨl, pag pe gɨ yokek gɨ dam lɨm eyaŋ paɫab sakak. Jisas pen kɨjeki kɨyob ñɨlɨk ak nop ag gek, ke amek nɨŋlɨg gɨ, ñɨ nɨbak komɨŋ lek, Jisas dam nap nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bin bɨ ap mɨdelak okok, God kɨlɨs ne aknɨb ke nɨbak nɨŋɨl, ñaul dɨlak. Bin bɨ nɨŋ mɨdelak okok, Jisas tap tari tari gak ak nɨŋɨl, ñaul dɨl nɨŋ mɨdel nɨŋlɨg gɨ, Jisas bɨ ne okok kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mɨnɨm agnɨg gebin nɨbaul, nɨbi tɨmɨd lɨ nɨŋ tep yɨb gɨl mɨdenɨmɨb. Ulep mɨdeb, Bɨ Ñɨ ne nop mɨmɨg nɨŋɨl, bɨ ognap kɨrop ñɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pen mɨnɨm agak nɨbak, kɨri tɨk nɨŋnɨmel rek ma lak. Pen pɨrɨkɨl Jisas nop ma ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas bɨ ne nɨb okok kɨri ke ag amɨl apɨl gɨl, bɨ alap agak, “Yad bɨ kɨb mɨden,” agak. Pen bɨ alap pen agak, “Wɨs! Nak mer, yad bɨ kɨb mɨden,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas bɨ ne okok gos nɨŋlak nɨbak ke nɨŋɨl, ñɨ sɨkol alap dap ne mɨdek bak sɨŋak lɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Bin bɨ an yɨp gos nɨŋɨl, ñɨ pai sɨkol aul nɨb rek dɨnɨgab ak, yɨp abe dɨnɨgab. Pen bin bɨ an yɨp dɨnɨgab ak, Bɨ yɨp ag yokek onek nop abe dɨnɨgab. Pen bɨ an nab nɨbi sɨŋak bɨ yokop yɨb rek mɨdeb, bɨ nɨbak nep ne bɨ kɨb yɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas nɨb agek, Jon agak, “Bɨ Kɨb, cɨn nɨpɨn, bɨ alap yɨb nak agɨl, kɨjeki kɨyob ñɨlɨk tap okok ag yokak. Pen bɨ nɨbak cɨn eip ma ajobɨn rek, ‘Nak nɨg ma gɨnɨmɨn,’ agnok,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Agek, Jisas agak, “Tari gɨnɨg nop nɨb ag gɨpek? Bin bɨ nɨbep nɨŋel mɨlɨk ma yonɨgab okok, bɨ nɨŋeb cɨn, agɨl nɨŋnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pen Nap ne Jisas nop dam karɨp lɨm ne seb kab ar alaŋ dad ameb ñɨn ak ulep gak nɨŋɨl Jisas, Jerusalem amnɨm, agɨl, gos kɨlɨs gɨ nɨŋɨl me amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ne bɨ ne ognap ned ag yokak. Kɨri amɨl tap nop gɨ jɨn gɨnɨg, karɨp lɨm Sameria nab sɨŋak karɨp tɨrɨg tɨroŋ alap amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pen Sameria bin bɨ karɨp tɨrɨg tɨroŋ nɨbak kɨnelɨgɨpal okok, Jisas Jerusalem amnɨg gek mɨnɨm ak nɨŋɨl, nop ag wasu ma dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nɨg gelak, Jisas bɨ ne Jems eip Jon eip nɨŋɨl, Jisas nop agrek, “Bɨ Kɨb, seb kab ar alaŋ nɨb mab mɨlaŋ agor, apɨl bin bɨ nɨg gɨpal okok kɨrop yɨnnɨmɨŋ akaŋ?” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nɨb agerek, Jisas adɨk gɨl kɨrop mal nɨŋɨl, nɨg ma gɨnɨgabɨn, agɨl, kɨrop mal ag gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bin bɨ nɨb okok kɨri Jisas nop ma dɨnɨgal ak nɨŋɨl, kɨri karɨp tɨrɨg tɨroŋ nɨbak kɨrɨg gɨl, karɨp tɨrɨg tɨroŋ ke nɨb alap amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pen majɨl nab okok amel nɨŋlɨg gɨ, bɨ alap apɨl, Jisas nop agak, “Karɨp lɨm akal akal amnɨgan okok, yad eip ajonɨgabɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nɨb agek, Jisas nop agak, “Yad eip koslam ajenɨgan. Kain sapeb okok karɨp kɨneb kɨri lɨm mɨgan okok mɨdeb; yakɨr okok tin kɨri ak ke mɨdeb; pen Bɨ Ñɨ ne, kau kɨneb ne alap ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pen Jisas bɨ alap nop agak, “Nak yad eip ajor,” agak. Nɨb agek, bɨ nɨbak pen agak, “Bɨ Kɨb, yɨp yau agek, yad am bapi yad tɨgel gɨl onɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Agek, Jisas nop pen agak, “Bin bɨ yɨp ma nɨŋ dɨpal ognap kɨmel, bin bɨ yɨp ma nɨŋ dɨpal ognap dam tɨgel gɨnɨmel. Nak pen amɨl, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm ak ag ñek amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pen bɨ alap agak, “Yad nak eip ajonɨgabɨr ak pen yɨp yau agek, yad amɨl ami bapi, ai mam yad okok kɨrop mɨnɨm ag ñɨ tep gɨl, ñɨnmagɨl pakɨl, onɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Agek, Jisas pen agak, “Bin bɨ an wög dai wagɨn gɨl, gos par nɨŋɨl, nab sɨŋak kɨrɨg gɨnɨgab ak, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak ag ñeb bɨ wög ak gɨnɨmɨŋ rek ma lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kɨsen Jisas bɨ ne ñɨnjuɨl omal nokɨm adɨk gɨ dam umɨgan alaŋ (72) dɨl, kɨrop bɨlokɨl omal ke, omal ke, karɨp lɨm okok ke ke ag yoknɨg gɨl agak, “Nɨbi ned amɨl, mɨnɨm yad ak ag ñem, yad kɨsen nɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pen kɨrop mɨnɨm alap agak, “Tap wög kɨb yɨb mɨdeb ak pen bin bɨ tap magɨl pag dowep okok koŋai ma mɨdebal. Nɨb ak, Bɨ Kɨb wög dai nap nɨb ak nop ag nɨŋem, bin bɨ tap magɨl pag dowep ognap sek agek, am pag dolaŋ. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɨbi amnɨm! Pen nɨbep kaj sipsip ñɨlɨk rek kain sapeb mɨdebal nab sɨŋak ag yokebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nɨbi mani tin, wad, tob tɨrɨp okok sek ma dad amnɨmɨb. Bin bɨ ognap eip majɨl nab sɨŋak mɨnɨm ag parsek ma mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pen karɨp alap amjakɨl, karɨp ñɨlɨk mɨgan amlɨg gɨ, kɨrop mɨnɨm tep ag ñɨl agnɨmɨb, ‘God nɨbep kod mɨdeŋ,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nɨb agenɨgabɨm, bin bɨ God mɨnɨm sain tep ne dep rek alap mɨdenɨgab ak, mɨnɨm sain nɨbi nɨbak dɨnɨgab. Mer ak, mɨnɨm sain agnɨgabɨm ak nɨbep ke adɨk gɨ onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pen karɨp nɨbak nep mɨdɨl, tap magɨl dap ñɨnɨgal ak ñɨblɨg gɨ mɨdenɨmɨb. Bɨ wög gɨpal okok pen saj dɨnɨmel. Nɨbak rek, kɨrop mɨnɨm tep ak ag ñenɨgabɨm rek, kɨri pen tap magɨl dap ñɨnɨgal. Pen nɨbi karɨp karɨp ma gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pen taun alap amem, nɨbep ag wasu dɨl, tap magɨl ñenɨmel ak, dɨ ñɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Karɨp lɨm nɨbak, bin bɨ tap gonɨmɨŋ okok kɨrop gem, komɨŋ lɨnɨmɨŋ. Bin bɨ okok magɨlsek kɨrop ag tep gɨl agnɨmɨb, ‘God bin bɨ dɨl kod mɨdenɨgab ak, tob wagɨn nɨbep ak bɨr owɨp,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pen taun alap amem, nɨbep ag wasu ma denɨmel ak, majɨl nab sɨŋak amɨl agnɨmɨb, ");
INSERT INTO kmh_m_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Karɨp lɨm nɨbep aul aposɨn ak, sɨlpɨl acɨp acɨp tob cɨnop cɨg dɨp ak, nɨbepe ke lɨg gɨ yokɨl amobɨn. Pen nɨŋ tep gɨm! God bin bɨ dɨl kod mɨdenɨgab ak, tob wagɨn nɨbep ak bɨr owɨp,’ agnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yad nɨbep agebin, kɨsen mɨnɨm kɨb nɨŋnɨgal ñɨn ak, taun kɨb Sodom bin bɨ tap si tap tɨmel nep gel gel yɨn sɨbok ñɨb amnak ak, mɨnɨm kɨb nɨŋɨl yur sɨkol rek dɨnɨgal; pen bin bɨ mɨnɨm nɨbi am agem ma dɨnɨgal okok, mɨnɨm kɨb nɨŋɨl yur kɨb yɨb dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin bin bɨ okok abe, Betsaida bin bɨ okok abe, tap ma gep rek ak gen, nɨŋɨl kɨrɨg gɨpɨm rek, yur kɨb yɨb dɨnɨgabɨm. Pen taun kɨb omal Taia Saidon bin bɨ okok kɨrop, tap ma gep nɨbak rek ognap gen nɨplap ak, kɨri walɨj pɨg gɨ rɨk yowɨp ognap yɨmɨl bɨsɨg gɨl, tɨn se dɨ lɨlɨg gɨ dɨ lɨlɨg gɨ mɨdɨl, tap tɨmel gölɨgɨpal nɨbak kɨrɨg gɨplap. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mɨnɨm kɨb nɨŋnɨgal ñɨn ak, Taia Saidon bin bɨ okok yur sɨkol rek dɨnɨgal; pen nɨbi Korasin bin bɨ okok abe, nɨbi Betsaida bin bɨ okok abe, yur kɨb yɨb dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pen ñɨn nɨbak, nɨbi Kapaneam bin bɨ okok ak rek nep, seb kab ar alaŋ sɨŋak ma amnɨgabɨm; pɨs nep kau mɨgan kɨb eyaŋ amnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas bɨ ne okok kɨrop agak, “Bin bɨ mɨnɨm nɨbep dɨnɨgal okok, mɨnɨm nɨbep nep mer, mɨnɨm yad ak, kɨri ak rek nep dɨnɨgal. Pen nɨbep ma dɨnɨgal okok, nɨbep nep mer, yɨp ak rek nep ma dɨnɨgal. Pen yɨp ma dɨnɨgal okok, yɨp nep mer, Bɨ yɨp ag yokek onek ak, nop ak rek nep ma dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pen kɨsen bɨ ne ñɨnjuɨl omal nokɨm adɨk gɨ dam umɨgan alaŋ (72) nɨb okok, karɨp lɨm okok gɨ rag kɨrɨg gɨl apɨl, tep aglɨg gɨ Jisas nop aglak, “Bɨ Kɨb! Kɨjeki kɨyob ñɨlɨk bin bɨ abaŋ ñapal okok, yɨb nak agɨl, ‘Jisas mɨdeb rek amnɨm!’ agon, apɨn rek nɨŋɨl ambal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Agelak, Jisas kɨrop agak, “Yad nɨŋ mɨden nɨŋlɨg gɨ, kɨjeki kɨyob ñɨlɨk nap kɨri Seten, añɨm añɨm rek dɨl seb kab ar alaŋ nɨb ap yap pakak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nɨbep ag lɨpin ak me, toi soiŋ sarau, gaiwadö, kodal, tap sapeb nɨb okok abe, Bɨ Kaual Maual kɨlɨs ne ak abe, nɨbep gɨ tɨmel gɨnɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pen kɨjeki kɨyob ñɨlɨk tap okok apɨn rek nɨŋɨl söŋ ambal, agɨl, mɨñ mɨñ ma gɨnɨmɨb; God ne yɨb cɨnop seb kab ar alaŋ sɨŋak ñu kɨl tɨkɨp, agɨl, mɨñ mɨñ gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Magɨl nɨbak, Kaun Sɨŋ ak Jisas nop ap ran jakɨl mɨdek nɨŋlɨg gɨ, ne mɨñ mɨñ gɨlɨg gɨ, Nap ne nop agak, “Bapi, nak Bɨ Kɨb seb kab ar alaŋ abe, lɨm dai wagɨn aul abe kod mɨdeban ak, gos nak ke nɨŋek tep gɨp ar ak nep gɨpan. Cɨn bin bɨ kɨb gos nɨŋ kɨd yɨkɨl ke nɨpɨn, apal bin bɨ okok, kɨrop mɨnɨm tep wagɨn ak ma yomban, pen ñɨ pai sɨkol okok, nak kɨrop gos tep ñek, mɨnɨm tep wagɨn ak nɨpal ak me, nep tep agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisas nɨb agɨl agak, “Bin bɨ ognap yad bɨ tigep bɨ rek mɨdebin ak ma nɨpal; Bapi ne nep yɨp nɨŋɨp. Pen Bapi ne bɨ tigep bɨ rek mɨdeb ak, bin bɨ ognap ma nɨpal; yad ke nep nɨpin. Ne yɨp kɨlɨs tap ne okok magɨlsek ñɨb rek, bin bɨ kɨrop yomnɨm agnɨgain bin bɨ okok nep, Bapi kɨrop yomen nop nɨŋnɨgal. Bin bɨ ognap sek Bapi nop ma nɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas nɨb agɨl, adɨk gɨl, bɨ ne okok nep kɨrop agɨl agak, “Tap nɨbaul nɨŋebɨm ak, mɨñ mɨñ gɨnɨmɨb. God nɨbep nep me dɨ tep yɨb gek nɨŋebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","God mɨnɨm agep bɨ okok koŋai nep abe, kiŋ okok koŋai nep abe, tap nɨbi udɨn nɨŋebɨm nɨbaul, nɨŋɨn, agɨl, kod mɨdelɨgɨpal ak pen kɨri ma nɨŋlak; mɨnɨm nɨbi peyɨg nɨŋebɨm nɨbaul, nɨŋɨn, agɨl, kod mɨdelɨgɨpal ak pen kɨri ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ñɨn alap nab sɨŋak, bɨ lo mɨnɨm ag ñeb bɨ alap, Jisas yɨp tari mɨnɨm agnɨmɨŋ, agɨl, apɨl nop ag nɨŋɨl agak, “Mɨnɨm ag ñeb bɨ, yad tari tari gɨl, komɨŋ per mɨdep magɨl ak dɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Agek, Jisas nop agak, “Lo mɨnɨm ak ñu kɨl tɨkɨl, tari aglak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Agek, bɨ lo mɨnɨm ag ñeb bɨ nɨbak agak, “Lo mɨnɨm ak nɨpin, Mosɨs ñu kɨl tɨkɨl agak, ‘God Bɨ Kɨb nak ak nop mɨñ mɨñ gɨl, gos tɨmɨd nak ak nop ñɨl, kɨlɨs nak ak magɨlsek nop ñɨl, nop mɨdmagɨl yɨb lɨnɨmɨn. Nak ke mɨdmagɨl lɨpan rek, bin bɨ ognap kɨrop ak rek nep mɨdmagɨl lɨnɨmɨn,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nɨb agek, Jisas bɨ nɨbak nop agak, “Nak yɨpɨd gɨl apan; ar nɨbak nep kɨsen gɨl, komɨŋ per mɨdep magɨl ak dɨnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jisas nɨb agek, bɨ lo mɨnɨm ag ñeb bɨ nɨbak, yɨb yad ak sɨkol gɨnɨgab, agɨl, Jisas nop kauyaŋ ag nɨŋɨl agak, “Lo mɨnɨm ñu kɨl tɨkak ak, bin bɨ ognap kɨrop mɨdmagɨl lɨnɨmɨb, agɨl, ñu kɨl tɨkak. Nɨb ak, bin bɨ akal kɨrop mɨdmagɨl lɨnɨmɨb, agɨl, ñu kɨl tɨkak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Agek, Jisas bɨ lo mɨnɨm ag ñeb bɨ nɨbak nop, mɨnɨm pen aglɨg gɨ, kesɨm dɨl agak, “Bɨ alap Jerusalem kɨrɨg gɨl, taun kɨb Jeriko amnɨm, agɨl, majɨl nab sɨŋak amek nɨŋlɨg gɨ, bɨ tap si dep ognap apɨl, nop tapɨn magɨl pakɨl, walɨj tap ne okok pɨlɨ gɨ dad amel nɨŋlɨg gɨ, ne majɨl nab sɨŋak kɨmnɨg mapal tɨb mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bɨ God nop tap sobok gep bɨ alap, majɨl ar nɨbak amɨl bɨ nɨbak kɨmnɨg mapal tɨb mɨdek sɨŋak nɨŋɨl, pɨs kɨd nep ajep lɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pen bɨ Lipai wagɨn bɨ alap, majɨl ar nɨbak nep amɨl, bɨ nɨbak kɨmnɨg mapal tɨb mɨdek sɨŋak nɨŋɨl, ne ak rek nep pɨs kɨd nep ajep lɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pen bɨ Juda mer, karɨp lɨm Sameria nɨb bɨ alap, majɨl par nokɨm nɨbak nep amɨl, bɨ nɨbak kɨmnɨg mapal tɨb mɨdek sɨŋak nɨŋɨl, nop yɨmɨg yɨb nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nop yɨmɨg yɨb nɨŋɨl, mɨdek maŋ sɨŋak amɨl, soi nop okok wel ognap lɨl, ñɨg wain ognap lɨl, soi nop okok ñon gak. Soi ñon gɨl, dɨ donki ar ne ak lɨl, karɨp mani tauɨl kɨnelɨgɨpal ak dam lɨl, kod mɨd tep yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mɨnek amnɨg gɨl, bɨ karɨp kod mɨdolɨgɨp nɨbak nop silpa kɨd omal ñɨl agak, ‘Nak bɨ nɨbaul nop kod mɨd tep gɨnɨmɨn. Pen mani titi agnɨgan ak, adɨk gɨ apɨl nep ñɨnɨgain,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas kesɨm nɨbak dɨl, ne bɨ lo mɨnɨm ag ñeb bɨ nɨbak nop ag nɨŋak, “Bɨ majɨl nab sɨŋak pak lɨlak ak, bɨ omal nokɨm padɨklɨg gɨ amnɨlak okok, bɨ an ne ke mɨdmagɨl lak rek, nop mɨdmagɨl lak?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Agek, bɨ lo mɨnɨm ag ñeb bɨ ak agak, “Bɨ nop yɨmɨg nɨŋɨl gɨ tep gak bɨ nɨbak,” agak. Agek, Jisas nop agak, “Nɨŋɨd nep ageban. Me nak amɨl, ar nɨbak rek nep gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pen Jisas bɨ ne okok eip karɨp lɨm alap amjakelak, bin karɨp lɨm nɨbak mɨdek alap apɨl, kɨrop poŋ dɨl dam karɨp ne ak amnak. Bin nɨbak yɨb ne Mata. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Karɨp ne ak nɨnai alap mɨdek. Yɨb ne ak Maria. Maria ne Jisas mɨdek ulep sɨŋak ap bɨsɨg gɨl, Jisas mɨnɨm agek ak nɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata ne ke nep tap magɨl dagɨl, gos par nɨŋɨl, ap Jisas nop agak, “Bɨ Kɨb, Maria yɨp kɨrɨg gek, yad ke nep tap magɨl cɨn dagɨlebin ak tep ma gɨp. Nop agek apɨl yad eip tap magɨl dagɨlɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Agek, Jisas agak, “Mata, Mata, nak tap koŋai nep gos par nɨŋeban ak tep mer. ");
INSERT INTO kmh_m_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria mɨnɨm tep yad nɨŋnɨm, agɨl, gos nokɨm ak nep nɨŋɨl, ap mɨnɨm yad nɨŋ mɨdeb. Bin bɨ alap tap tep dɨp nɨbak pɨlɨ gɨ dɨnɨmɨŋ rek ma lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ñɨn alap, Jisas karɨp lɨm ke mɨgan alap mɨdɨl, Nap God nop sobok gɨlɨg gɨ mɨdek. Sobok gɨ juek nɨŋlɨg gɨ, bɨ ne alap apɨl nop agak, “Bɨ Kɨb, God nop titi gɨl sobok gɨn? Jon bɨ ne okok kɨrop ag ñek nɨpal rek, nak cɨnop ak rek nep ag ñek nɨŋɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Agek, Jisas kɨrop pen agak, “God nop sobok gɨnɨg gɨl, nɨbgɨl agnɨmɨb, ‘Bapi, bin bɨ okok yɨb nak agel ar amnaŋ. Nak bin bɨ dɨl kod mɨdenɨgan ñɨn ak kasek onɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tap magɨl cɨnop ñɨn nokɨm nokɨm per per ñɨban rek ñɨnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bin bɨ ognap cɨnop gɨ tɨmel gel, kɨrop pen gɨ tɨmel ma gɨpɨn rek, cɨn tap si tap tɨmel gɨpɨn okok nɨŋɨl kɨrɨg gɨnɨmɨn. Cɨnop kod mɨdenɨmɨn, gos alap pɨwakonɨmɨŋ, gɨ tɨmel ma gɨjɨn,’ agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jisas mɨnɨm nɨbak agɨl, bɨ ne okok kɨrop mɨnɨm sɨd tɨkɨl agak, “Nɨbi bɨ alap, kɨslɨm nab kɨb eyaŋ, bɨ nɨŋeb ne karɨp amɨl agnɨgab, ‘Ñɨbemmam, bɨ nɨŋeb yad alap par okok nɨb apɨl karɨp yad ak apjakosɨp. Pen tap nop ñen ñɨŋnɨmɨŋ ak ma mɨdeb ak me, nep apebin. Yɨp bred magɨl omal nokɨm ñan,’ agnɨgab. Agenɨgab, bɨ nɨŋeb ne nɨbak mɨnɨm pen agnɨgab, ");
INSERT INTO kmh_m_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Kɨslɨm nab kɨb aul apɨl yɨp aknɨb ma agnɨmɨn! Yad ñɨ pai yad okok eip kɨjoŋ gɨñɨl kɨnobɨn. Nɨb ak, yad titi gɨl warɨkɨl, nep tap ageban nɨb okok dɨ ñɨnɨm?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pen nɨbep agebin, bɨ karɨp nap nɨb ak, bɨ nɨŋeb yad, agɨl, kasek dɨ ma ñɨnɨgab, pen nop ñan agɨl kod mɨdlɨg gɨ, kɨlɨs gɨ mɨdek mɨdek, agnɨgab rek ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nɨb ak, nɨbep agebin, tap tari ma mɨdonɨmɨŋ, God nop ag nɨŋem, nɨbep ñɨnɨgab. Tap tari pɨyo nɨŋnɨgabɨm ak, dɨnɨgabɨm. Cɨnop kɨjoŋ ak yɨkaŋ, agɨl, pak gu gu gem, yɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tari gɨnɨg: bin bɨ God nop ag nɨŋnɨgal okok, dɨnɨgal. Bin bɨ tap pɨyo nɨŋnɨgal okok, dɨnɨgal. Bin bɨ cɨnop kɨjoŋ yɨkaŋ, agɨl, pak gu gu gel, kɨrop kɨjoŋ yɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nɨbi ñɨ pai nap okok, ñɨ nɨbi alap kɨbsal nen agenɨgab, toi alap ñɨnɨgan aka? ");
INSERT INTO kmh_m_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aka pen, yakɨr magɨl nen agenɨgab, kodal alap ñɨnɨgan aka? Ak rek nep nɨg ma gɨnɨgan. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nɨbi bin bɨ tep mer ak pen ñɨ pai nɨbi okok tap tep okok nep ñɨnɨgabɨm. Bapi seb kab ar alaŋ sɨŋak mɨdeb ak Bɨ tep yɨb. Ne tap tɨmel alap ma ñɨnɨgab. Kaun Sɨŋ ak cɨnop ñan, agenɨgabɨm ak, Bapi nɨbep ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pen bɨ alap nop kɨjeki abaŋ ñagek, mɨnɨm agɨl mer, yokop nep mɨdek. Jisas kɨjeki nɨbak ag yokek, bɨ abaŋ ñag mɨdek ak mɨnɨm agek nɨŋlɨg gɨ, bin bɨ nɨŋ mɨdelak okok kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pen bin bɨ nɨb okok ognap aglak, “Ne kɨjeki kɨyob ñɨlɨk nap kɨri Bielsebul kɨlɨs ne ak dɨl, kɨjeki kɨyob ñɨlɨk okok ag yokeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pen bin bɨ nɨb okok ognap, Jisas tari gɨnɨgab, agɨl, aglak, “Tap ma nɨŋep alap ke seb kab ar epel gek nɨŋɨl me, God nep ag yokek onak ak, nɨŋnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pen Jisas gos tom kɨri ke nɨŋlak ak ke nɨŋɨl agak, “Karɨp lɨm kɨb nokɨm alap, tɨg asɨk ke ke lɨl, bin bɨ kɨri ke eip pen pen genɨgal ak, karɨp lɨm nɨbak pɨs nep ap yap paknɨgab. Bin bɨ wagɨn nokɨm alap, ak rek nep tɨg asɨk ke ke lɨl, bin bɨ kɨri ke eip pen pen ñagenɨgal ak, bin bɨ wagɨn nokɨm nɨbak ap yap paknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nɨb aknɨb rek nep, Seten wagɨn ne ak tɨg asɨk ke ke lenɨgab ak, titi gɨl mɨd tep gɨnɨmɨŋ? Pen nɨbi yɨp agebɨm, ‘Bielsebul kɨlɨs ne ak dɨl, kɨjeki kɨyob ñɨlɨk ag yokek söŋ ambal,’ agebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɨb agebɨm ak, yakam nɨbi ke okok kɨjeki kɨyob ñɨlɨk okok titi gɨl ag söŋ yokpal? Yakam nɨbi ke agnɨgal, bin bɨ nɨg gɨnɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pen yad God kɨlɨs ne dɨl, kɨjeki kɨyob ñɨlɨk tap okok ag söŋ yokebin rek, nɨbi nɨŋnɨgabɨm, God bin bɨ dɨl kod mɨdep ñɨn ak cɨnop bɨr owɨp aul, agɨl nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pen bɨ kɨlɨs alap, cɨm tu ne lɨ tep gɨl, karɨp ne ak nɨŋ mɨdenɨgab, bin bɨ ognap tap ne alap pɨlɨ gɨ dɨnɨmel rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pen bɨ kɨlɨs yɨb alap ke apɨl, nop eip pen pen gɨl pakenɨgab ak, cɨm tu karɨp sɨŋak lɨ tep gak ak sek pɨlɨ gɨ dɨl, tap si dɨnɨgab okok dam nonɨm lɨ ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Bin bɨ an an yad eip ma mɨdebal okok, wög yad gebin ak tɨb wal gebal. Bin bɨ an an kɨri bin bɨ ognap yɨp ma dapenɨgal okok, bin bɨ yɨp onɨg gebal okok kɨrop yɨk gɨ dam yokebal. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kɨjeki kɨyob ñɨlɨk alap, bin bɨ abaŋ ñag mɨdek, ag söŋ yokek amnɨgab ak, am mɨñ mab nep nab okok amɨl, kau alap pɨyo nɨŋɨl mɨdenɨm, agɨl, am nab nɨb okok pɨyo nɨŋ tag tag mer nɨŋɨl, ‘Karɨp ñɨlɨk mɨgan ned mɨdɨl opin ak amnin,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Agɨl, amɨl nɨŋnɨgab, karɨp nɨbak lɨg gɨ tep gek, kau tep nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ne nɨŋɨl okok amɨl, ne rek mer, kɨjeki kɨyob ñɨlɨk tɨmel yɨb aknɨb ar oŋɨd ak sek poŋ dɨ dapɨl, mɨgan nɨbak am mɨdenɨgal. Nɨg gek, bɨ nɨbak ned tep sɨkol sɨkol mɨdolɨgɨp rek mer; mɨñi ne pɨs nep tɨmel yɨb gɨl mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas mɨnɨm nɨbak agek, bin bɨ koŋai mɨdelak nab nɨb sɨŋak bin alap warɨkɨl, sɨk sɨk agɨl agak, “Nanɨm nep tɨk dap ci ñak ak, mɨñ mɨñ yɨb gɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Agek, Jisas pen agak, “Nɨb ageban ak pen bin bɨ an an God Mɨnɨm ak nɨŋɨl ageb rek gɨnɨgal okok, kɨri mɨñ mɨñ gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pen bin bɨ koŋai yɨb nep ap mogɨm gel nɨŋlɨg gɨ, Jisas kɨrop agak, “Bin bɨ mɨñi mɨdebɨm nab sɨŋaul, tap si tap tɨmel gɨlɨg gɨ mɨdɨl agebɨm, ‘Tap ma gep rek alap seb kab ar alaŋ gek nɨŋɨn,’ agebɨm. Pen yad nɨbep agebin, tap alap ke gen ma nɨŋnɨgabɨm. Bɨ God mɨnɨm agep Jona nop gak ar ak nep yɨp gek, nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Taun kɨb Ninepa bin bɨ okok, God mɨnɨm agep bɨ Jona apɨl gak rek nɨŋɨl God nop nɨŋ dɨlak rek, bin bɨ mɨñi mɨdebɨm okok, yad Bɨ Ñɨ ne gɨnɨgain rek nɨŋɨl, nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pen bɨrarɨk nep bin kwin karɨp lɨm par mɨdek okok nɨb apɨl, Kiŋ Solomon mɨnɨm tep ageb ak nɨŋin, agɨl, owak. Pen nɨbi bin bɨ mɨñi mɨdebɨm okok, bɨ kɨb Solomon rek mer, yad Bɨ Kɨb yɨb apɨl nab nɨbep sɨŋaul mɨdɨl, nɨbep mɨnɨm tep yɨb ag ñen ma nɨŋ dɨpɨm. Nɨb ak, mɨnɨm kɨb agep ñɨn ak, kwin nɨbak warɨkɨl nɨbep bin bɨ mɨñi mɨdebɨm okok mɨnɨm kɨb agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bɨrarɨk nep Jona am Ninepa bin bɨ okok kɨrop agek, tap si tap tɨmel gölɨgɨpal okok, tari gɨnɨg nɨg gɨpɨn agɨl kɨrɨg gɨl, God nop nɨŋ dɨlak. Jona ne agek nɨŋ dɨlak ak pen mɨñi yad Bɨ Kɨb yɨb apɨl nab nɨbep sɨŋaul mɨdɨl, mɨnɨm tep yɨb ag ñen, tap si tap tɨmel gɨpɨm okok ma kɨrɨg gɨpɨm. Nɨb ak, mɨnɨm kɨb agep ñɨn ak, Jona ne warɨkɨl nɨbep bin bɨ mɨñi mɨdebɨm okok mɨnɨm kɨb agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Bin bɨ okok sɨp dagɨl tin cög mɨgan okok ma we gɨnɨgal; ar sɨŋak alaŋ tɨk lel melɨk gek, bin bɨ okok karɨp ñɨlɨk mɨgan nɨbak apɨl mɨseŋ nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pen udɨn magɨl ak sɨp melɨk rek mɨdeb. Udɨn magɨl ak mɨd tep gɨnɨgab ak, mɨb goŋ nab adaŋ melɨk gɨl mɨd tep gɨnɨgab, pen udɨn magɨl mɨd tep ma gɨnɨgab ak, mɨb goŋ nab adaŋ kɨslɨm gɨp ak rek mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɨbi nɨŋ rep gɨnɨmɨb, nab nɨbi adaŋ melɨk mɨdeb aka kɨslɨm mɨdeb. Nɨbi gos nɨpɨm, nab cɨn adaŋ melɨk mɨdeb ag gos nɨpɨm ak pen kɨslɨm onɨmɨŋ rek lɨp rek, nɨbi ke nɨŋ rep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mɨb goŋ nɨbi nab adaŋ magɨlsek melɨk gɨ mɨdlɨg gɨ, mɨgan sɨkol eñap kɨslɨm ma mɨdenɨgab ak, sɨp melɨk gek nɨbep melɨk pak ñɨnɨgab aknɨb rek lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pen Jisas mɨnɨm ag juek nɨŋlɨg gɨ, bɨ Perisi alap nop agak, “Apek karɨp yad amɨl tap ñɨŋɨr,” agak. Agek, Jisas karɨp ne amɨl, karɨp mɨgan eyaŋ tap ñɨŋnɨg bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bɨsɨgɨl, tap ñɨbek nɨŋlɨg gɨ, bɨ Perisi nɨbak, gos ne ke nab okok nep nɨŋɨl, bɨ nɨbaul tari gɨnɨg cɨn Juda kai per gɨpɨn rek, ñɨnmagɨl ne ak ñɨg lɨ yokɨl mer, yokop nep tap ñɨbeb, agɨl, gos ak nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisas gos nɨŋak nɨbak ke nɨŋɨl nop agak, “Nɨbi Perisi kai, kɨri pler kap okok söŋ ken okok ñɨg pak tep gɨpal rek ak gɨpɨm ak pen nab nɨbi eyaŋ tap si tap tɨmel gɨpɨm gac ak ap ran jakɨl mɨdeb. Nɨbi bin bɨ tap tep kɨrop okok dɨn, agɨl, gɨ tɨmel yɨb nep gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nɨbi saköl sek yɨb. God nɨbep wak ak nep ma gɨ lak; nab adaŋ abe gɨ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nɨb ak, tap pler kap mɨgan eyaŋ mɨdeb ak, bin bɨ tap ma mɨdeb okok kɨrop ñɨnɨmɨb. Nɨg genɨgabɨm ak, tap nɨbi magɨlsek tɨd gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pen nɨbi Perisi kai, nɨŋ tep yɨb gɨnɨmɨb: nɨbi mɨker kɨb yɨb dɨnɨgabɨm. Sɨnɨb, dil, tap yokop ki tep owep wög dai tanɨb okok nɨŋem, tap kɨb rek lek, wök pag nɨŋ damɨl, wajrem alaŋ amek, nonɨm lɨl God nop nokɨm alap ñɨn, agɨl, per gos nɨpɨm. Tap sɨkol sɨkol okok per nɨg gɨl gɨpɨm ak tep, pen tari gɨnɨg mɨnɨm wagɨn yɨb ak nɨŋɨl kɨsen ma gɨpɨm? Bin bɨ okok kɨrop yɨpɨd gɨl gɨp ar ak ma gɨpɨm; kɨrop tɨmel gɨp ar ak nep gɨpɨm. God nop mɨdmagɨl ma lɨpɨm. Nɨg gɨl, gɨ tɨmel gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pen nɨbi Perisi kai, nɨŋ tep yɨb gɨnɨmɨb: nɨbi mɨker kɨb yɨb dɨnɨgabɨm. Nɨbi Juda mogɨm gep karɨp okok amɨl, bɨ kɨb mab bog bɨsɨgpal ar ak nep bɨsɨgpɨm. Gos nɨbi nɨpɨm ak, bin bɨ koŋai mɨdebal nab okok amon, ‘Mɨnɨm ag ñeb bɨ apeban e!’ agel, cɨnop tep gɨnɨgab, agɨl, nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pen nɨbi Perisi kai, nɨŋ tep yɨb gɨnɨmɨb: nɨbi mɨker kɨb yɨb dɨnɨgabɨm. Bin bɨ ognap nɨŋɨl, nɨbep bɨ tep yɨb apal ak pen cɨp tɨgel gɨpal ki tɨmel mɨdeb mɨgan okok bin bɨ ma nɨŋɨl ar alaŋ ajpal rek mɨdebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas nɨb agek, lo mɨnɨm ag ñeb bɨ alap nop agak, “Mɨnɨm ag ñeb bɨ, mɨnɨm kɨlɨs yɨb lɨl ageban nɨbak, cɨnop ak rek nep ag jueban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Agek, Jisas agak, “Pen nɨbi lo mɨnɨm ag ñeb bɨ okok, nɨŋ tep yɨb gɨnɨmɨb. Nɨbi mɨker kɨb yɨb dɨnɨgabɨm. Mɨnɨm kɨl tep apɨm ak, wad mɨker kɨb okok rek, bin bɨ okok kɨrop gom ñɨbɨm ak pen kɨrop yɨmɨg nɨŋɨl ag tausak ma dɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Pen nɨbi lo mɨnɨm ag ñeb bɨ okok, nɨŋ tep yɨb gɨnɨmɨb. Nɨbi mɨker kɨb yɨb dɨnɨgabɨm. Nased acɨk nɨbi okok bɨrarɨk nep bɨ God mɨnɨm agep bɨ okok kɨrop ñag pak lɨlak. Pen nɨbi God mɨnɨm agep bɨ okok cɨp tɨgel kɨrop gɨ lɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gɨpɨm nɨbak, tep nep paklak, agɨl, gɨpɨm. Nased acɨk God mɨnɨm agep bɨ okok ñag pak lɨlak; nɨbi pen cɨp tɨgel kɨrop gɨ lɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nɨb ak, God gos tep ke nɨŋɨp ak agak, ‘Bɨ mɨnɨm yad agep okok, bɨ mɨnɨm tep yad dad ameb okok kɨrop ag yoknɨgain, pen kɨrop yo nɨŋɨl, ognap gɨ tɨmel gɨl, ognap pɨs nep ñag pak lɨnɨgal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pen bɨrarɨk nep, God lɨm dai wagɨn aul gɨ lɨnɨg gak ñɨn ak tɨkɨl, bɨ God mɨnɨm agep okok kɨrop per pakel owɨp rek, bin bɨ mɨñi mɨdebɨm sɨŋ aul, tap dai nɨbak pen dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mɨker nɨbak me, bɨ Ebol nop ned wagɨn gɨl ñag pakɨl, ñag pak dapɨl, ñag pak dapɨl, kɨsen Sekaraia nop, kau tap sobok gɨ ñeb karɨp ñɨlɨk mɨgan ak kɨdadaŋ, kab kolɨm dɨ gɨlak bɨd ar sɨŋ aul, nab sɨŋak ñag pak lɨlak. Nɨbep nɨŋɨd yɨb agebin, mɨnɨm mɨker nɨbak magɨlsek, bin bɨ mɨñi mɨdebɨm okok dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pen nɨbi lo mɨnɨm ag ñeb bɨ okok, nɨŋ tep yɨb gɨnɨmɨb. Nɨbi mɨker kɨb yɨb dɨnɨgabɨm. Mɨnɨm tep ak, gos tep nɨŋeb karɨp ñɨlɨk mɨgan kɨjoŋ ki ak nɨbi dɨl, okok we gɨpɨm. Okok we gɨpɨm ak, bin bɨ karɨp ñɨlɨk mɨgan am nɨŋɨn, agɨl gos nɨpal okok, kɨrop per majɨl magrem ag rɨkpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisas kɨrop nɨb agɨl söŋ amek nɨŋlɨg gɨ, lo mɨnɨm ag ñeb bɨ okok abe, bɨ Perisi okok abe nop yo nɨŋlɨg gɨ aglak, “Mɨnɨm tari ak agon, pen agek nɨŋɨl, nop dam mɨnɨm kɨb agɨn,” agɨl, Jisas nop mɨnɨm esek esek ar ognap agel amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pen ñɨn alap, bin bɨ koŋai yɨb nep ap mogɨm gɨl, pen pen cɨrok cɨrok ñɨl bin bɨ ognap tob tau pag jɨsɨpɨk masɨpɨk gɨlɨg gɨ amel nɨŋlɨg gɨ, Jisas bɨ ne okok kɨrop agak, “Perisi kai per gɨ tɨmel gɨpal ak we gɨl, mɨd tep gɨpɨn, ag gos nɨpal. Nɨbi nɨb aknɨb rek gɨnɨmɨb rek lɨp ak, nɨbi yɨs kɨri ak nɨŋ tep yɨb gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tap we gɨl gɨpɨm okok, kɨsen mɨseŋ lek nɨŋnɨgal. Mɨnɨm kapkap ag we gɨpɨm okok, ak rek nep mɨseŋ lek nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pen mɨnɨm kɨslɨm eyaŋ apɨm ak, melɨk sek agel nɨŋnɨgal. Mɨnɨm kapkap karɨp mɨgan eyaŋ apɨm ak, meg mɨgan dap ranɨl karɨp ar alaŋ agel, yɨg dad karɨp lɨm okok dad amnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Bin bɨ yad sɨŋ aul, nɨbep agebin, God nop cɨg gon, cɨnop ñag paknɨgal, agɨl, ma pɨrɨknɨmɨb. Ak yokop mɨb goŋ ar ak nep gɨ tɨmel gel, ki gɨnɨgab. Kɨsen kɨri tap alap nɨbep gɨnɨmel rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nɨb ak, yad nɨbep agebin, nɨbi pɨrɨk gɨnɨg, Bɨ nɨbep mɨb goŋ ñag pak lɨl, kɨsen nɨbep mab ke yɨneb mɨgan eyaŋ dɨ yoknɨmɨŋ rek lɨp, Bɨ nɨbak nep pɨrɨknɨmɨb. Ne nep Bɨ pɨrɨkep me; nop nep pɨrɨknɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nɨbi nɨpɨm, bin bɨ yakɨr sɨkol aknɨb mamɨd alaŋ sɨkim gɨl, mani lakañ sɨkol omal nep dɨpal. Yakɨr sɨkol nɨb okok, God nokɨm alap ma nɨŋnɨmɨŋ rek ma lɨp; magɨlsek nɨŋeb ak nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pen nɨbi bin bɨ okok tap yɨb; yakɨr okok nɨbep eip adɨp adɨp rek mer. God nabɨc cög kɨmkas nɨbep ak magɨlsek wök pagɨp ak me, nɨbi ma pɨrɨkɨl, gos sek mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nɨbep mɨnɨm nɨŋɨd agebin, bin bɨ Jisas pɨs ken mɨdobɨn, agɨl, bin bɨ mɨdebal nab sɨŋak mɨseŋ ag yɨkenɨgal ak, yad kɨrop pen abe bin bɨ sɨŋ aul yɨp pɨs ken mɨdebal, agɨl, God ejol ne mɨdebal nab sɨŋak mɨseŋ ag yɨknɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pen bin bɨ Jisas pɨs ken ma mɨdobɨn, agɨl, bin bɨ mɨdebal nab sɨŋak mɨseŋ agenɨgal ak, yad kɨrop pen abe bin bɨ sɨŋ aul yɨp pɨs ken ma mɨdebal, agɨl, God ejol ne mɨdebal nab sɨŋak mɨseŋ agnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bɨ Ñɨ ne nop ag juenɨgal ak, God nɨŋɨl kɨrɨg gɨnɨg, kɨrɨg gɨnɨgab; pen Kaun Sɨŋ ak nop ag juenɨgal ak, God ne nɨŋɨl ma kɨrɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pen nɨbep mɨnɨm kɨb agnɨg gɨl, dad Juda mogɨm gep karɨp sɨŋak, aka gapman bɨ kɨb mɨdebal nab sɨŋak, aka kiŋ mɨdebal nab sɨŋak, dapenɨgal ak, pen mɨnɨm tari ak dɨl agɨn, agɨl, gos par ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Warɨk agem nɨŋlɨg gɨ, won nɨbak nep Kaun Sɨŋ ne nɨbep gos ñek nɨŋlɨg gɨ, nɨŋɨl agnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bin bɨ koŋai mɨdelak nab nɨb sɨŋak, bɨ alap Jisas nop agak, “Mɨnɨm ag ñeb bɨ, nak mam yad ak nop agek, bapi tap ne dɨ lɨl kɨmak okok, nonɨm lɨ yɨp pɨs kɨd ke ñaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Agek, Jisas nop pen agak, “Yɨp bɨ an agɨl, ‘Bɨ tap tɨg bɨlok ñeb ak mɨdenɨmɨn,’ agek nɨŋɨl tap nɨbep okok dɨ nonɨm lɨ ñɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jisas nɨb agɨl, bin bɨ mɨdelak okok kɨrop agak, “Nɨŋ tep yɨb gɨnɨmɨb. Tap koŋai nep dɨn, agɨl, gos ak ma nɨŋnɨmɨb. Tap koŋai dɨn, agɨl, gos nɨŋnɨgabɨm ak, mɨd tep gɨnɨmɨb rek ma lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pen Jisas mɨnɨm alap kɨrop mɨnɨm sɨd tɨkɨl agak, “Bɨ mani koŋai mɨdenɨgab alap, wög dai ne ak, wid magɨl tap okok koŋai yɨb nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Gos ne okok nep ke nɨŋ damɨl, ‘Tap ñɨŋeb yad koŋai nep mɨdeb okok, karɨp ñɨlɨk mɨgan akal dap lɨl, ñɨb mɨdenɨm?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pen gos alap nɨŋɨl, ‘Karɨp sɨkol okok tɨb wal gɨ yokɨl, karɨp kɨb kɨb okok nep gɨ lɨl, wid magɨl yad abe, tap yad okok abe magɨlsek dɨ karɨp ñɨlɨk mɨgan nɨb okok dam lɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yad nɨg gɨl, adi ke agnɨgain, “Bɨ aul. Nak tap tep koŋai yɨb mɨdeb ak mɨ koŋai yɨb nep mɨdɨl ma kɨr gɨnɨgab. Nɨb ak, wög nak ak kɨrɨg gɨl, tap nak nɨb okok nep ñɨblɨg gɨ, ñɨg ñɨblɨg gɨ, mɨñ mɨñ gɨlɨg gɨ, gɨ mɨdenɨmɨn,” agnɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nɨb agɨl gos nɨŋnɨgab, pen God nop agnɨgab, ‘Nak bɨ saköl sek yɨb! Mɨñi kɨslɨm nab eyaŋ nep kɨmnɨgan. Tap nak koŋai nep gɨ jɨn gɨ lek mɨdeb nɨb okok, an rek dɨ ñɨb mɨdenɨgab?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Nɨbak rek me, bin bɨ tap tep okok koŋai nep dɨ mogɨm gɨpal ak pen God udɨn yɨrɨk ne sɨŋak kɨri bin bɨ yɨm gep rek mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas nɨb agɨl, bɨ ne okok kɨrop agak, “Nɨb ak, ‘Tap magɨl akal nɨb dɨl ñɨb mɨdojɨn, walɨj akal nɨb dɨl yɨm mɨdojɨn,’ agɨl, gos par ak ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tap ñɨŋeb ak tap kɨb mer. Komɨŋ mɨdep won ak tap yɨb. Walɨj tap okok tap kɨb mer. Mɨb goŋ ak tap yɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yakɨr mɨdebal okok nɨŋɨm. Yakɨr okok, bin bɨ gɨpal rek, wid wög gɨ yɨmel, pok gek ma tɨk dopal. Wid magɨl tɨk dap mogɨm gep karɨp kɨri alap ma mɨdeb. God nep me tap ñɨŋeb kɨrop ñɨb. Ne tap sɨkol okok gos nɨŋɨl nɨg gɨp ak, nɨbi tari gɨnɨg cɨnop bin bɨ ma kod mɨdenɨgab, agɨl, gos par nɨpɨm? Yakɨr okok tap sɨkol; nɨbi tap sɨkol mer. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pen nɨbi gos par nɨŋenɨgabɨm ak, kɨmnɨg gɨnɨgabɨm ñɨn ak kɨrɨg gɨl, magɨl alap sek mɨdenɨgabɨm aka? ");
INSERT INTO kmh_m_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ak tap sɨkol, pen nɨbi ke tap sɨkol nɨbak gɨnɨmɨb rek ma lɨp. Nɨb ak, nɨbi tari gɨnɨg tap yokop ar ognap gos par nɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tap be okok tanɨl, magɨl pɨlɨl sɨm yokɨp ak pen ke walɨj gɨl tɨb kadɨg gɨnɨmɨŋ rek ma lɨp. God nep gek, tɨb kadɨg tep yɨb gɨ mɨdeb. Pen Kiŋ Solomon tɨb kadɨg tep yɨb golɨgɨp ak, kausɨl okok tɨb kadɨg tep gɨ mɨdeb ak rek ma golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tap be okok tanɨb nɨb okok tap yokop; per ma mɨdenɨgab. Mɨñi rek mɨdɨl, tol menɨk tɨb gɨ rɨk dɨ mab dagɨlel yɨnnɨgab. God ne tap yokop okok gos nɨŋɨl nɨb gɨp ak, nɨbi tari gɨnɨg cɨnop walɨj ma ñɨnɨgab, agɨl, gos par nɨpɨm? Nɨŋ dep magɨl nɨbi ak par ma mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Cɨn tap magɨl, ñɨg, tap okok akal nɨb dɨl ñɨŋɨn, agɨl, gos mɨker ak ma nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bin bɨ God nop ma nɨpal okok, gos nɨbak rek nɨpal. Pen Nap nɨbi ak nɨbep saköl ma gɨp; tap nɨbi ma mɨdeb okok nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nɨb ak pen, God bin bɨ dɨl kod mɨdenɨgab ak, cɨnop sek dɨnɨmɨŋ, agɨl, gos nokɨm nɨŋɨl gem amek me, nɨbep kod mɨdlɨg gɨ, tap nɨb okok nɨbep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kaj sipsip bad sɨkol yad sɨŋ aul, Nap nɨbi ak, nɨbep dɨl kod mɨdenɨgain, agɨl nɨŋɨp ak me, nɨbi ma pɨrɨknɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tap nɨbi mɨdeb rek okok, sɨkim gɨ mani dɨl, bin bɨ tap ma mɨdeb okok kɨrop ñɨnɨmɨb. Nɨg genɨgabɨm ak, mani tin nɨbi wor ma gɨl per per nep mɨdenɨgab; tap tep tep nɨbi seb kab ar alaŋ sɨŋak mɨdɨl ma kɨr gɨnɨgab; bɨ si dep apɨl si ma dɨnɨgab; sɨpsep tap okok ma ñɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pen tap tep nɨbi okok lɨm dai ar wagɨn aul dɨ mogɨm genɨgabɨm ak, cɨbur gos mɨdmagɨl nɨbi ak, ak rek nep lɨm dai ar wagɨn aul mɨdenɨgab. Pen tap tep nɨbi seb kab ar alaŋ sɨŋak dɨ mogɨm genɨgabɨm ak, cɨbur gos mɨdmagɨl nɨbi ak, ak rek nep nɨb alaŋ mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nɨb ak, walɨj nɨbi ak ulep ulep pag tep gɨl, sɨb nag pog lɨ tep gɨl, sɨp dagɨl lɨl nɨŋlɨg gɨ mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bɨ wög gɨ ñeb okok agnɨgal, ‘Bɨ kɨb cɨn ak, bɨ nɨŋeb ne bin dɨl eip tap kɨb ñɨb mɨdel nɨŋlɨg gɨ, ulep adɨk gɨ onɨgab,’ agɨl, nɨŋ nep mɨdenɨgal. Bɨ kɨb kɨri ak adɨk gɨ apɨl, kɨjoŋ pak gu gu gek, kasek yɨknɨgal. Nɨb aknɨb rek nɨbi nɨg gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pen ne adɨk gɨ apɨl, kɨri nɨŋ mɨdenɨgal ak nɨŋɨl, kɨrop dɨ tep yɨb gɨnɨgab. Bɨ kɨb nɨbak ne ke, walɨj ne ak ulep ulep pag tep gɨl, sɨb nag pog lɨ tep gɨl, kɨrop agek, apɨl tap ñɨŋeb lɨ ñɨbal kau ak bɨsɨg kɨs kɨs gel, ne ke tap ñɨŋeb okok dam kɨrop ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pen bɨ kɨb kɨslɨm nab kɨb eyaŋ aka kɨlokɨl agenɨgab won ak apɨl nɨŋnɨgab, bɨ ne okok wɨsɨn ma kɨnenɨgal, kɨrop dɨ tep yɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nɨb ak, nɨŋɨm. Bin bɨ karɨp nap nɨb okok, bɨ tap si dep bɨ onɨgab ñɨn ak, agɨl, nɨŋ mɨdeblap ak, karɨp kɨrop pɨpagɨl, tap kɨrop okok ma si dɨpkop. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɨb aknɨb rek, Bɨ Ñɨ ne onɨgab, agɨl, kod mɨdenɨmɨb. Ma onɨgab agɨl gos nɨŋnɨgabɨm magɨl ak nep onɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas nɨb agek, Pita agak, “Bɨ Kɨb, mɨnɨm sɨd tɨkɨl ageban nɨbak, cɨnop nep ageban aka bin bɨ okok magɨlsek ageban?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Agek, Bɨ Kɨb pen agak, “Bɨ an gos tep mɨdek, wög gɨ tep gɨnɨgab bɨ ak, bɨ kɨb ne karɨp ne ak amnɨg gɨl bɨ nɨbak nop agnɨgab, ‘Bɨ wög yɨp gɨpal ognap kɨrop kod mɨdɨl, tap ñɨŋeb kɨrop okok nonɨm lɨ ñɨlɨg gɨ mɨdenɨmɨn,’ agɨl, amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nɨb ak, kɨsen adɨk gɨ apɨl, agnɨgab rek nep genɨgab ak nɨŋɨl, nop dɨ tep yɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yad nɨbep agebin, bɨ kɨb nɨbak agek, bɨ ne gɨ tep gɨnɨgab nɨbak tap ne okok magɨlsek kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pen bɨ wög gɨ ñeb ne ak, bɨ kɨb yad ak kasek ma apeb, agɨl, bin bɨ wög gɨ ñeb ognap kɨrop tapɨn magɨl pakɨl, tap kɨb ñɨbɨl, ñɨg wain koŋai ñɨbɨl, saköl ñagɨl, gɨ mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pen bɨ kɨb ne ma onɨgab, agɨl, nɨŋnɨgab ñɨn ak nep apɨl, nop tɨb gɨ rɨk ma rɨk gɨl, bin bɨ mɨnɨm nop ma nɨpal nab kɨrop sɨŋak ag yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Bɨ wög gɨ ñeb bɨ alap, bɨ kɨb ne mɨnɨm agnɨgab ak nɨŋ tep gɨnɨgab, pen mɨnɨm nop ak tɨb juɨl, agnɨgab rek ma gɨnɨgab ak, bɨ kɨb agek, kɨri nop tapɨn paknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pen bɨ wög gɨ ñeb bɨ alap, bɨ kɨb ne mɨnɨm agnɨgab ak ma nɨŋɨl, mɨnɨm agnɨgab rek ma gɨnɨgab ak, bɨ kɨb agek, kɨri nop pakɨl yur sɨkol rek ñɨnɨgal. God bin bɨ kɨrop tap koŋai ñɨnɨgab okok, yɨp pen tap koŋai ñɨnɨmɨb, agnɨgab; pen bin bɨ kɨrop tap koŋai yɨb ñɨnɨgab okok, yɨp pen tap koŋai yɨb ñɨnɨmɨb, agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yad opin ak, lɨm dai ar wagɨn aul sɨp pɨg yoknɨg opin. Karɨp lɨm okok magɨlsek bɨr yɨnbkop ak tep! ");
INSERT INTO kmh_m_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yɨp yur pak ñɨnɨg gebal ak, yɨp mɨker kɨb yɨb gɨp. Mɨker kɨb nɨbak mɨd dam dam, yɨp yur pak saknɨgal ñɨn ak nep auan amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɨbi yɨp agnɨgabɨm, bin bɨ tɨg jɨm ñɨnɨg owɨp agnɨgabɨm ak pen ak mer. Yad opin rek, bin bɨ okok gos ar ke ke nɨŋɨl asɨk ke ke lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mɨñi ñɨn aul tɨkɨl, amɨlgon apɨlgon aknɨb mamɨd rek mɨdenɨgal ak, omal nokɨm yɨp del, omal yɨp ma dɨl, asɨk ke ke lɨnɨgair. Pen mer ak, omal yɨp der, omal nokɨm yɨp ma dɨl, asɨk ke ke lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bɨ apɨl mal, ñɨ ne aka nap yɨp ma dek me, asɨk ke ke lɨnɨgair. Bin amɨl mal, pai ne aka nonɨm yɨp ma dek me, asɨk ke ke lɨnɨgair. Nonɨm eip ñɨ ne bine ak eip, ak rek nep gɨnɨgair; nonɨm aka ñɨ ne bine ak yɨp ma dek, asɨk ke ke lɨnɨgair,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pen Jisas mɨnɨm alap sek kɨrop agak, “Pɨb paŋɨd ameb pɨs kɨd kɨmi komɨb nɨŋɨl, mɨñi mɨñab ñagnɨg geb, agɨl nɨŋ mɨdem, mɨdak mɨdak apɨm rek nep mɨñab ñagnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɨgen kɨb okim nɨb okol gɨ apek nɨŋlɨg gɨ, mɨñi pɨb kɨb lɨnɨg geb, agɨl nɨŋ mɨdem, mɨdak mɨdak apɨm rek nep pɨb kɨb lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nɨbi bɨ esek agep! Tap lɨm dai wagɨn aul nɨŋ tep gɨl, tap seb kab ar alaŋ nɨŋ tep gɨl gɨpɨm ak, pen tari gɨnɨg ñɨn kɨb per kod mɨdelɨgɨpɨm ak, mɨñi bɨr owɨp, agɨl ma nɨpɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nɨbi ti gɨnɨg, majɨl nɨbak tep, majɨl nɨbak tɨmel, agɨl ma nɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pen bɨ alap, nep mɨnɨm kɨb agnɨg dad amebin, agonɨmɨŋ, mɨnɨm kɨb nɨbak tari gɨnɨg agnɨg amobɨr, agɨl, majɨl nab sɨŋak amlɨg gɨ, nop eip mɨnɨm ag tɨg asɨk tep gɨnɨmir. Mer ak, nep dam bɨ kɨb mɨnɨm nɨŋeb ñɨnmagɨl ar ne ak yokek, ne pen nep dam polisman ñɨnmagɨl ar kɨrop okok lek, nep pɨs nep dam mɨñ lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nɨb ak, yad nep agebin, nak nagɨman nep mɨdɨl, tap dai nak okok pɨs nep dai pag ju sakɨl me, söŋ amnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Magɨl nɨbak, bin bɨ ognap apɨl, Jisas nop agɨl aglak, “Galili bin bɨ ognap apɨl, God sobok gep karɨp ak tap sobok gɨ ñel nɨŋlɨg gɨ, magɨl nɨbak nep gapman bɨ kɨb Pailot kɨrop pɨs nep ñag pak lak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Agelak, Jisas kɨrop agak, “Galili bin bɨ nɨb okok nep, tap si tap tɨmel aknɨb ke gel nɨb gɨp, pen Galili bin bɨ ognap tap si tap tɨmel sɨkol sɨkol gɨpal rek nɨb ma gɨp, agɨl, nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ak mer! Yad nɨbep agebin, tap si tap tɨmel gɨpɨm okok tari gɨnɨg nɨg gɨpɨn, agɨl, ma kɨrɨg gɨnɨgabɨm ak, bin bɨ nɨb okok kɨmlak rek nep, nɨbi magɨlsek ak rek nep kɨmnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pen Siloam cöb ulep sɨŋak, karɨp par kɨb tɨ paŋ pe gɨl bin bɨ aknɨb kagol pɨs kɨd adaŋ (18) kɨrop pak lak ak, tap si tap tɨmel aknɨb ke gel nɨg gɨp, pen bin bɨ Jerusalem mɨdebal ognap tap si tap tɨmel sɨkol sɨkol gɨpal rek nɨg ma gɨp, agɨl, nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ak mer! Yad nɨbep agebin, tap si tap tɨmel gɨpɨm okok tari gɨnɨg nɨg gɨpɨn, agɨl, ma kɨrɨg gɨnɨgabɨm ak, bin bɨ nɨb okok kɨmlak rek nep, nɨbi magɨlsek ak rek nep kɨmnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pen Jisas mɨnɨm sɨd tɨkɨl kɨrop agak, “Bɨ alap uɫem magɨl alap pɨlaŋ, agɨl, yɨŋ ak ju dapɨl, nag wain wög ne sɨŋak yɨmnɨgab. Kɨsen adɨk gɨ apɨl nɨŋnɨgab magɨl alap ma pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bɨ wög gep ne ak nop agnɨgab, ‘Mɨ omal nokɨm mɨ nokɨm nokɨm yɨnek nɨŋlɨg gɨ, per apɨl nɨpin uɫem yɨmnek ak magɨl ñɨŋeb alap ma pɨlɨp. Nɨb ak, wög dai yad nab sɨŋak mɨdeb ak tep ma gɨp. Tɨb yokan!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Agenɨgab, bɨ wög gɨ ñeb ne agnɨgab, ‘Bɨ kɨb, uɫem wagɨn nɨbak mɨñi tɨb ma yokep. Yad uɫem wagɨn nɨbak kɨpɨl gɨ tep gɨl, tap kas kas ognap dap len, ");
INSERT INTO kmh_m_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","mɨ kɨsen nɨb ak magɨl pɨlnɨmɨŋ ak, kɨrɨg gɨnɨmɨn; pen magɨl ma pɨlnɨmɨŋ ak, tɨb gɨ rɨk yoknɨmɨn,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pen Juda God nop sobok gep ñɨn alap, Jisas Juda mogɨm gep karɨp alap amɨl, kɨrop mɨnɨm ag ñɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Karɨp ñɨlɨk mɨgan nɨbak bin alap ap mɨdek. Bin nɨbak nop kɨjeki kɨyob ñɨlɨk gek, kɨd magɨl ne ak ñɨk ñɨk gɨl nep ajolɨgɨp mɨ aknɨb kagol pɨs kɨd adaŋ (18) yɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas bin nɨbak nop agek apek agak, “Tap nep gɨp ak komɨŋ lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nɨb agɨl, nop dɨ nɨŋek nɨŋlɨg gɨ, magɨl nɨbak nep kɨd magɨl ne ak yɨpɨd gek, God yɨb ne ak agek ar amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pen Jisas God nop sobok gep ñɨn ak gek komɨŋ lak ak nɨŋɨl, bɨ kɨb Juda mogɨm gep karɨp nɨbak kod mɨdolɨgɨp ak, Jisas nop nɨŋek mɨlɨk yapek, bin bɨ ap mɨdelak okok kɨrop agak, “Nɨbi bin bɨ tap gɨp okok, wög gep ñɨn aknɨb kagol oŋɨd nep apem komɨŋ lɨnɨmɨŋ. Mɨñi God nop sobok gep ñɨn aul nɨg ma gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nɨb agek, Bɨ Kɨb nop pen agak, “Nɨbi bɨ esek agep! Kaj kau, kaj donki nɨbi okok ñon gɨ lem mɨdenɨgab sɨŋak, God nop sobok gep ñɨn ak ñɨg nen gek, kɨrop nag wɨsɨbɨl, dad amem ñɨg ñɨŋnɨgal aka mer? ");
INSERT INTO kmh_m_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pen based acɨk cɨn Ebraham tɨkɨl, tɨk dap lɨlak pai aul, Seten nop bɨrarɨk nep ñon gɨ lek, mɨ yɨn kagol pɨs kɨd adaŋ mɨdeb ak, nop yɨmɨg ma nepɨm ar? Mɨñi God nop sobok gep ñɨn aul, nag ne wɨsɨb yokesin, yɨp mɨnɨm kɨb agebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas nɨb agek, bɨ nop nɨŋel mɨlɨk yowak okok nabɨŋ yɨb gak. Pen bin bɨ ognap okok, Jisas tap ma gep rek golɨgɨp okok nɨŋɨl, mɨñ mɨñ yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas mɨnɨm alap sek agɨl agak, “God bin bɨ dɨl kod mɨdenɨgab mɨnɨm ak nɨbep ag ñɨnɨg gebin ak, titi gɨl agen, nɨbi nɨŋ tep gɨnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Me mɨnɨm agnɨg gebin ar nɨbaul rek mɨdeb. Bɨ alap mab mastad magɨl ak dam wög dai ne ak yɨmek, tan kɨb gɨl tam lɨl kɨd kɨd amenɨgab, yakɨr okok apɨl lek lek kɨd kɨd mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mɨnɨm alap pen kauyaŋ agak, “God bin bɨ dɨl kod mɨdenɨgab mɨnɨm ak, titi gɨl agen, nɨbi nɨŋ tep gɨnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ar nɨbak rek, bin alap yɨs bad sɨkol sɨkol alap dɨl, plaua tin kɨb eyaŋ sek tɨg adɨk madɨk gek mɨdlɨg gɨ, kɨb yɨb tannɨgab rek ak gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pen Jisas Jerusalem amnɨg gɨl, yɨpɨd gɨl ma amnak. Ne taun okok abe, bin bɨ karɨp tɨrɨg tɨroŋ mɨdelak okok abe, nab nab kɨnlɨg gɨ, mɨnɨm ag ñɨlɨg gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bin bɨ mɨdelak nɨb okok, bɨ alap Jisas nop agak, “Bɨ Kɨb, God yokop bin bɨ omal nep dɨ komɨŋ yoknɨgab aka?” agak. Agek, Jisas kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nɨb ak, nɨbi kɨlɨs gɨl nep, kɨjoŋ wagɨn sɨkol tam nɨbak amnɨgabɨm. Bin bɨ koŋai yɨb nep, kɨjoŋ tam sɨkol nɨbak amnɨn, agɨl, am sɨsɨŋ tɨk mer nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tari gɨnɨg, bɨ karɨp nap nɨb ak kɨjoŋ gɨñnɨgab, nɨbi söŋ okok nep mɨdɨl, pak gu gu gɨl agnɨgabɨm, ‘Bɨ kɨb, kɨjoŋ yɨkan!’ agnɨgabɨm. Nɨbi nɨb agem, ne pen pe agnɨgab, ‘Nɨbi akal nɨb? Yad nɨbep ma nɨpin!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Agenɨgab, nɨbi pen agnɨgabɨm, ‘Nak ned karɨp lɨm cɨn ak apɨl, nep eip tap ñɨbɨl ñɨg ñɨbɨl golɨgɨpɨn; nak cɨnop mɨnɨm ag ñölɨgɨpan,’ agnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nɨbep pen agnɨgab, ‘Yad nɨbep ma nɨpin. Nɨbi akal nɨb yad ma nɨpin. Nɨbi bin bɨ tap si tap tɨmel gɨpɨm ak me, nɨbep kɨjoŋ ma yɨknɨgain. Amnɨm!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kɨsen nɨbi nɨŋnɨgabɨm, Ebraham, Aisak, Jekop, bɨ God mɨnɨm agep bɨ okok, God karɨp lɨm per mɨdep ak God eip mɨdenɨgal, pen nɨbep ag söŋ yokek, sɨl kɨb aglɨg gɨ, meg mɨgan su tɨbɨklɨg gɨ nep mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pen bin bɨ par okok nɨb, pɨb apeb pɨs ken nɨb, pɨb paŋɨd ameb pɨs ken nɨb, okim okok nɨb, okɨd okok nɨb, God karɨp lɨm per mɨdep ne ak apɨl, bɨsɨg gɨ jɨm ñɨl tap kɨb ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pen bin bɨ mɨñi kɨd ken yɨb sɨŋak mɨdebal okok, kɨsen ognap ned am mɨdenɨgal. Pen bin bɨ mɨñi ned amebal okok, kɨsen ognap kɨd ken yɨb okok mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Won nɨbak nep, bɨ Perisi ognap apɨl Jisas nop aglak, “Gapman bɨ kɨb Herod nep ñag pak lɨnɨg geb. Nɨb ak, nak karɨp lɨm aul kɨrɨg gɨl, karɨp lɨm ke alap amnoŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Agelak, Jisas agak, “Nɨbi am kain sapeb nɨbak nop agem, nɨŋ mɨdonɨmɨŋ. Mɨñi abe, tol abe, bin bɨ kɨjeki kɨyob ñɨlɨk abaŋ ñagɨp okok gen komɨŋ lɨl, bin bɨ tap gɨp okok gen komɨŋ lɨl, gɨnɨgab. Mɨnek pen, ñɨn omal nokɨm ak me, wög yad ak gɨ saknɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pen mɨñi, tol, menɨk yad majɨl amnin ag gos nɨpin ak amnɨgain. Bɨ God mɨnɨm agep okok kɨrop Jerusalem nep ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem! Jerusalem! God ne mɨnɨm agep bɨ ne nɨbep nen agɨl ag yokak bɨ okok, tari gɨnɨg per kab ju pak lɨpɨm? Kɨlokɨl ñɨlɨk dɨ auan mok okok lɨp rek ak, yad per ñɨ pai nak okok dɨ tep gɨnɨm, agɨl, nɨpin ak pen yɨp yɨrɨk nɨŋɨl mer apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nɨb ak, nɨŋɨm. Karɨp nɨbi ak kau nep mɨdeb. Mɨdak, nɨbi yɨp ma nɨŋnɨgabɨm; kɨsen okok, ‘Bɨ nɨbaul Bɨ Kɨb ag yokɨp apeb aul, God gek, yɨb ne ar alaŋ amnaŋ,’ agnɨgabɨm ñɨn ak me, yɨp kauyaŋ nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juda God nop sobok gep ñɨn alap, Jisas amɨl Perisi bɨ kɨb alap karɨp ne ak tap ñɨbek nɨŋlɨg gɨ, bin bɨ mɨdelak okok, ne tari rek gɨnɨmɨŋ, agɨl, nɨŋ i sek lɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tari gɨnɨg: ñɨn nɨbak, bɨ ñɨnmagɨl tob su gak alap ap mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas, bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, kɨrop agak, “God nop sobok gep ñɨn aul, bɨ tap gɨp alap gon komɨŋ lɨnɨgab ak tep aka mer? Lo mɨnɨm tari ageb?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Agek, mɨnɨm alap pen ma aglak. Nɨb ak, Jisas bɨ ñɨnmagɨl tob su gak ak nop dɨ nɨŋek komɨŋ lak. Komɨŋ lek, Jisas bɨ nɨbak nop ag yokek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jisas bɨ nɨbak ag yokɨl, bɨ nɨb okok kɨrop agak, “Ñɨ pai nɨbi alap aka kaj kau nɨbi alap, God nop sobok gep ñɨn ak ñɨg mɨlpɨm kau mɨgan eyaŋ yapenɨgab ak, nɨbi kasek am dɨ yoknɨgabɨm aka mer?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Agek, kɨri pen mɨnɨm alap agnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pen bin bɨ nɨb okok tap magɨl ñɨŋnɨg apɨl, kau bɨsɨgep tep tep ar ak nep nɨŋɨl bɨsɨgɨn, agɨl, bɨsɨglak ak, Jisas nɨŋɨl, mɨnɨm alap mɨnɨm sɨd tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bɨ alap bin dɨnɨg gɨl, tap kɨb ñɨŋnɨg nɨbep sɨk agek amɨl, kau bɨsɨgep tep lɨnɨmɨŋ ar ak ma bɨsɨgnɨmɨb. Tari gɨnɨg: bin bɨ kɨb ognap onɨmel rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nɨb ak, nɨbi kau bɨsɨgep tep ar nɨbak bɨsɨg genɨgabɨm ak, bɨ nɨbep sɨk agnɨgab ak apɨl agnɨgab, ‘Nak ke sɨŋak amnoŋ, bɨ kɨb aul ar nɨb sɨŋak bɨsɨgaŋ,’ agek, nod nabɨŋ gek nɨŋlɨg gɨ, am lɨlɨg gɨ am bak okok bɨsɨgnɨgaban. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pen nɨbep, tap ñɨŋɨn, agɨl, sɨk agenɨmel, am gol okok bɨsɨg mɨdem me, bɨ nɨbep sɨk agnɨgab ak apɨl agnɨgab, ‘Bɨ ñɨbemmam. Nak apɨl kau ar tep aul bɨsɨg gan,’ agek, bin bɨ tap ñɨŋnɨg ap mɨdenɨgal okok nep nɨŋɨl, bɨ ak nab aul bɨ kɨb nep mɨdeb, agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nɨb aknɨb rek, cɨn yɨb kɨb mɨdeb, ag gos nɨpal bin bɨ okok, God yɨb kɨrop gek ap yonɨgab. Pen cɨn yɨb kɨb ma mɨdeb, ag gos nɨpal bin bɨ okok, God yɨb kɨrop gek ap rannɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas mɨnɨm ar nɨbak agɨl, bɨ tap kɨb ñɨŋnɨg bin bɨ sɨk agak bɨ ak nop agak, “Nak tap kɨb ñɨŋnɨg, bɨ nɨŋeb nak okok, nanai namam yakam nak okok, bin bɨ karɨp lɨm alog nak mani koŋai mɨdeb bin bɨ okok, kɨrop ma sɨk agnɨmɨn. Bin bɨ nɨb okok, cɨn dai ñɨn, agɨl, nep pen tap ñɨŋnɨg sɨk agnɨmel rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nak tap kɨb ñɨŋnɨg, bin bɨ yɨm gep rek okok, bin bɨ ñɨnmagɨl tob kalau gɨp okok, bin bɨ tob tɨmel gɨp okok, bin bɨ udɨn kwoi gɨp okok, kɨrop sɨk agem, apenɨgal, tap ñɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bin bɨ yɨm gep rek nɨb okok, nep pen ñɨnɨmel rek ma lɨnɨgab ak me, kɨsen God bin bɨ komɨŋ tep ne okok gek warɨknɨgal ñɨn ak, ne ke nep pen ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pen mɨnɨm nɨbak nɨŋɨl, bɨ kɨri eip tap ñɨbelak alap Jisas nop agak, “God bin bɨ ne dɨl kod mɨdenɨgab ak, ne eip jɨm ñɨl tap kɨb ñɨbenɨgal okok, mɨñ mɨñ yɨb gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Agek, Jisas agak, “Bɨ alap tap kɨb ñɨŋnɨg gɨl, bin bɨ koŋai nep sɨk agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pen tap kɨb ñɨŋeb ñɨn nɨbak apenɨgab, bɨ wög gɨ ñeb ne ak nop agnɨgab, ‘Mɨñi nak amɨl bin bɨ ned ag lɨpin okok kɨrop am poŋɨd dowan,’ agnɨgab. Bɨ wög gɨ ñeb ne pen amɨl agnɨgab, ‘Tap magɨlsek dap gɨjɨn gɨpɨn; apem amnɨn!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Agenɨgab, bin bɨ nɨb okok alap agnɨgab, ‘Yad amnɨm ak pen lɨm dai alap taupin ak nɨŋnɨg amebin,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pen alap agnɨgab, ‘Yad amnɨm ak pen kaj kau aknɨb wajrem alaŋ taupin ak, wög gɨ tep gɨnɨgal aka, agɨl, am nɨŋnɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Alap agnɨgab, ‘Yad amnɨm ak pen bin yad kɨsen nep dɨpin ak me, onɨm rek ma lɨp,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nɨb agenɨgal, bɨ nɨbak adɨk gɨ amɨl, bin bɨ okok kɨri tari tari agnɨgal ak, bɨ kɨb ne ak nop agnɨgab. Agenɨgab, bɨ kɨb ak cɨbur nop ak tɨmel gek, bɨ ne ak nop kauyaŋ ag yokɨl agnɨgab, ‘Nak kasek am majɨl kɨb okok abe, majɨl sɨkol okok abe amɨl, bin bɨ yɨm gep rek okok, bin bɨ ñɨnmagɨl tob kalau gɨp okok, bin bɨ udɨn kwoi gɨp okok, bin bɨ tob tɨmel gɨp okok, kɨrop poŋɨd dowan,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Agenɨgab, agnɨgab rek gɨl, kɨsen bɨ wög gɨ ñeb nɨbak agnɨgab, ‘Bɨ kɨb, apan rek gɨpin ak pen mɨgan ognap kau nep mɨdeb,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Agenɨgab, bɨ kɨb ak bɨ wög gɨ ñeb ne nop agnɨgab, ‘Nak majɨl kɨb okok abe, majɨl sɨkol okok abe amɨl, bin bɨ mɨnɨm kɨlɨs agɨl agek, kɨri apel, karɨp ñɨlɨk mɨgan yad ak pɨs nep tɨb dɨnɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pen bin bɨ ned sɨk agen ma opal okok, bin bɨ alap tap yad sɨkol sɨkol ognap ma ñɨŋnɨgab, mer yɨb,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jisas majɨl amek ak, bin bɨ koŋai yɨb nop kɨsen gɨlak. Ne adɨk gɨl kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bin bɨ okok yɨp pɨs ken amnɨn agnɨgal ak pen gos kɨb kɨri amnɨgab nonɨm nap, bin ñɨ pai, nɨnai nɨmam, aka mɨb goŋ kɨri ke, bin bɨ okok bin bɨ yad mɨdenɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bin bɨ ognap agnɨgal, Jisas bin bɨ ne mɨdojɨn ak pen nɨg gon, bin bɨ ognap cɨnop gɨ tɨmel gɨnɨmel rek lɨp, agɨl, mɨb goŋ kɨri ke nep gos nɨŋlɨg gɨ, mab kros kɨri dɨ ka gɨl yɨp sain ma gɨnɨgal ak, bin bɨ yad mɨdenɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pen bɨ nɨbi alap, karɨp par kɨb i ar alaŋ alap gɨnɨg, ned mani titi gɨl rek dɨl gɨnɨm, agɨl, gos nɨŋ tep gɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pen, gɨnɨm gɨnɨm, agɨl, kab ned nep gɨnɨgab ak pen kɨsen mani ulep gek, karɨp ulep gek, bin bɨ okok nop ag juɨl agnɨgal, ");
INSERT INTO kmh_m_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ake! Bɨ par aul karɨp gɨnɨg gɨ rek gɨ damɨl, karɨp dai kɨrɨg gɨp sɨsak geb,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pen nɨbak rek, bɨ kiŋ alap, bɨ kiŋ alap eip pen pen gɨnɨg, ned gos nɨŋ tep gɨl amnɨgab. Pen ne gos nɨŋ damɨl, ami bɨ yad ak ten tausan nep mɨdeb; pen kiŋ nɨbak ami bɨ ne twenti tausan mɨdeb; pen pen gɨl, ne ami bɨ yad ñag pak lɨnɨmɨŋ rek lɨp, agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gos nɨbak nɨŋɨl, kiŋ alap par okok kɨsen apek nɨŋlɨg gɨ, mɨnɨm yokɨl agnɨgab, ‘Cɨr titi gɨl, mɨnɨm ag jɨm ñɨr?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nɨb ak, nɨŋ tep gɨnɨmɨb. Tap nɨbi okok magɨlsek kɨrɨg gɨl, yad eip ma onɨgabɨm ak, bin bɨ yad mɨdenɨmɨb rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Dek tap tep yɨb ak pen dek kal ne amnɨgab ak, kɨri tari gel kauyaŋ yɨdek gɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dek nɨbak rek, dɨ wög dai aka kɨlokɨl cɨb sɨŋak yokel tap magɨl tan tep ma gɨnɨgab. Dek nɨbak rek wög alap ma mɨdeb; dɨ yokep rek nep lɨp. Nɨbi bin bɨ gos tɨmɨd mɨdonɨmɨŋ okok, mɨnɨm agebin aul tɨmɨd lɨ nɨŋ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pen bɨ takɨs dep okok abe, bin bɨ tap si tap tɨmel gɨlak okok abe, Jisas mɨnɨm ageb ak nɨŋɨn, agɨl, ap nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pen bɨ Perisi okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, Jisas nop ag juɨl aglak, “Ne tari gɨnɨg bɨ tap si tap tɨmel gɨpal okok dɨl, eip tap magɨl jɨm ñɨl ñɨbeb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nɨb agelak, Jisas mɨnɨm alap sɨd tɨkɨl kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bɨ nɨbi alap, kaj sipsip ñɨnjuɨl aknɨb mamɨd alaŋ (100) mɨk mɨdenɨgab. Pen nokɨm nɨb alap kɨr genɨgab ak, ognap dam lɨm sɨlɨn sɨlɨn mɨdeb okok lɨl, am kaj sipsip ne kɨr gɨnɨgab ak pɨyo nɨŋ tag tag, nop pɨyo nɨŋ dam dam nɨŋ dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kaj sipsip ne nɨbak pɨyo nɨŋ dek, tep gek nɨŋlɨg gɨ, dɨ wajrem ne ak ar alaŋ lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wajrem alaŋ dap karɨp amɨl, bin bɨ nɨŋeb ne okok, bin bɨ karɨp lɨm alog ne okok, kɨrop sɨk agɨl, ap mogɨm genɨgal agnɨgab, ‘Kaj sipsip yad kɨr gɨp ak, pɨyo nɨŋɨl bɨr dɨpin ak, nɨbi apem yad eip mɨñ mɨñ gɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nɨg aknɨb rek me, bin bɨ koŋai nep okok, cɨn gɨ tep gɨl tap si tap tɨmel ma gɨpɨn, agɨl, gos nɨpal okok, seb kab ar alaŋ sɨŋak mɨdebal okok nɨŋɨl mɨñ mɨñ ma gɨnɨgal; pen bin bɨ nokɨm alap, tap si tap tɨmel gɨpin okok tari gɨnɨg nɨg gɨpin, agɨl, kɨrɨg genɨgab ak, seb kab ar alaŋ sɨŋak nɨŋɨl mɨñ mɨñ gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aka pen, bin alap mani silpa magɨl ne aknɨb wajrem alaŋ mɨdenɨgab. Pen magɨl alap, karɨp ñɨlɨk mɨgan okok kapkap ap yapenɨgab ak, ne tari gɨnɨgab? Ne sɨp dagɨl ar sɨŋ epel lɨl, pɨyo nɨŋ nɨŋ kau acɨp acɨp lɨg lɨg, kab magɨl ne nɨbak dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kab magɨl ne nɨbak pɨyo nɨŋ dek, tep gek nɨŋlɨg gɨ, bin bɨ nɨŋeb ne okok, bin bɨ karɨp lɨm alog ne okok, kɨrop sɨk agek, ap mogɨm genɨgal agnɨgab, ‘Kab magɨl yad yowɨp magɨl nokɨm nɨbak pɨyo nɨŋɨl bɨr dɨpin ak, nɨbi apem yad eip mɨñ mɨñ gɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nɨbak rek me, bin bɨ nokɨm alap, tap si tap tɨmel gɨpin okok tari gɨnɨg nɨg gɨpin, agɨl, kɨrɨg genɨgab ak, seb kab ar alaŋ sɨŋak God ejol ne okok nɨŋɨl mɨñ mɨñ gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas mɨnɨm nɨbak agɨl agak, “Bɨ alap ñɨ ne omal mɨdenɨgab ak. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ñɨ ne kɨsen ak, apɨl nap nop agnɨgab, ‘Bapi, tap cɨrop mal apan okok, tɨg asɨk yɨp okok ke ñan,’ agek, nap tap kɨrop mal okok tɨg asɨk ke ke ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ñek, ñɨ ne kɨsen ak magɨl ulep magɨl alap mɨdɨl, nap tap nop tɨg asɨk ñak okok magɨlsek sɨkim gɨl, mani dɨl, dad karɨp lɨm par okok amnɨgab. Am nɨb okok mɨdɨl, bin si tap tɨmel okok gɨlɨg gɨ, mani tap ne dad amnɨgab okok, abramek bin bɨ okok ñɨ saknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nɨg gek, mani ne sakek, karɨp lɨm nɨbak yuan kɨb yɨb lɨnɨgab. Pen tap magɨl tau ñɨŋnɨmɨŋ mani alap ma mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nɨg gek, ne amɨl, bɨ karɨp lɨm nɨbak nɨb nap kɨri alap ag nɨŋek, nop kaj mɨkep wög ak ag lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pen nop yuan kɨb yɨb ak lek gɨ mɨdek mɨdek, kaj mɨkelɨgɨpal womai wak okok ognap ñɨŋnɨm agnɨgab ak pen bin bɨ ognap nop tap magɨl ma ñɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pen gos magɨl ne nɨŋ dad amek gos tep magɨl ak apek agnɨgab, ‘Bapi yad bɨ nop wög gɨpal okok, tap magɨl koŋai mɨdeb. Pen yad sɨŋaul mɨdebin, yɨp yuan kɨb yɨb lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nɨb ak, yad karɨp lɨm aul kɨrɨg gɨl, bapi mɨdeb sɨŋak kauyaŋ adɨk gɨ amɨl, nop agnɨgain, “God udɨn yɨrɨk ar ne ak gɨ tɨmel gɨl, udɨn yɨrɨk ar nep ak gɨ tɨmel gɨl, gɨpin rek, ");
INSERT INTO kmh_m_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","nak yɨp ñɨ yad ma agnɨmɨn. Yɨp bɨ wög gɨ ñeb nak alap rek ag lek gɨnɨgain,” agnɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gos nɨbak nɨŋɨl, bapi karɨp adɨk gɨ amnɨgain, agɨl, paŋ dɨnɨgab. Am am am, nap ne par okok nɨb ñɨ ne nɨbak nop yɨpɨd nɨŋnɨgab. Nap ñɨ ne nɨŋɨl, nop yɨmɨg yɨb gɨnɨgab. Ne kasek pɨg gɨ rɨkɨd ag amɨl nop nab nab lɨ dɨ kaiŋ gɨl, tɨg bom sɨlokɨl mɨlɨk ñɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nap nɨg gek, ñɨ agnɨgab, ‘Bapi, God udɨn yɨrɨk ar ne ak gɨ tɨmel gɨl, udɨn yɨrɨk ar nep ak gɨ tɨmel gɨl, gɨpin rek, nak yɨp ñɨ yad ma agnɨmɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nap pen, bɨ wög gɨ ñeb ne okok kɨrop agnɨgab, ‘Nɨbi kasek nep am walɨj par kɨb yad ak dap nop yɨm ñɨl, ñɨnmagɨl nop ak riŋ lɨ ñɨl, tob tɨrɨp lɨ ñɨl, gɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nɨg gɨl, amɨl kaj kau ñɨlɨk marɨp sɨlɨn tep yɨb ak pak dam dagɨlem, mɨñ mɨñ gɨlɨg gɨ tap kɨb ñɨŋɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ñɨ yad ak pɨs nep kɨmak rek lak ak, pen mɨñi ne kauyaŋ komɨŋ mɨdeb. Ned ne pɨs nep kɨrɨg gak ak, pen mɨñi nop pɨyo nɨŋɨl adɨk dɨpin,’ agnɨgab. Nap nɨb agek, kɨri am kaj kau ñɨlɨk pak dapɨl, tap magɨl dagɨlel, mɨñ mɨñ gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Pen ñɨ ne ned ak, wög dai okok gɨ tag kɨrɨg gɨl, adɨk gɨ yokop karɨp ulep sɨŋak apɨl nɨŋnɨgab, cacɨŋ, mab cög paklɨg gɨ, kogɨm paglɨg gɨ, mɨñ mɨñ gɨlɨg gɨ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nɨg genɨgal, ñɨ ned ak nap bɨ wög gɨ ñeb ne alap nop sɨk agek apek ag nɨŋɨl agnɨgab, ‘Tari gebal?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Agenɨgab, agnɨgab, ‘Namam kɨsen nak kɨmɨb agɨl nɨŋɨp ak pen mɨñi adɨk gɨ aposɨp, nap kaj kau ñɨlɨk marɨp sɨlɨn tep ak pak dagɨl ñɨblɨg gɨ mɨñ mɨñ gebal,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Agenɨgab, nop mɨlɨk kal yɨb yapek, karɨp ñɨlɨk mɨgan ma amnɨgab; söŋ sɨŋak eyaŋ nep mɨdenɨgab. Nap pen söŋ amɨl, apek karɨp ñɨlɨk mɨgan amnɨr, agɨl, nop mɨnɨm sain sain agɨl agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nap ne mɨnɨm sain sain agenɨgab pen ñɨ ned ne agnɨgab, ‘Yad mɨnɨm nak apan rek per nep kɨsen gɨl, bɨ mɨñ wög gep nak rek mɨdɨl, wög nep per per gen gen mɨ koŋai yɨb nep amɨb. Pen yɨp kaj meme ñɨlɨk alap ñek, ñɨbemmam yad okok eip pak dagɨl ñɨbɨl mɨñ mɨñ ma gɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pen ñɨ nak nɨbak, tap nonɨm lɨ ñɨnak okok damɨl, bin si tap okok gɨl gɨ ñɨb yok sakɨl owɨp, nop yɨmɨg nɨŋɨl, kaj kau ñɨlɨk marɨp sɨlɨn tep yɨb ak pakpan!’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nɨb agenɨgab, nap ñɨ ne ned nop agnɨgab, ‘Cɨr apɨl per mɨdobɨr rek, tap yad okok magɨlsek nak dɨnɨgan. ");
INSERT INTO kmh_m_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Namam kɨsen nak pɨs nep kɨmak rek lak ak, pen mɨñi ne kauyaŋ komɨŋ mɨdeb. Ne pɨs nep kɨr gak rek lak ak, pen mɨñi nop pɨyo nɨŋ adɨk dɨpin. Nɨb ak me, cɨn mɨñ mɨñ gɨn,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas bɨ ne okok kɨrop agak, “Bɨ kɨb tap koŋai mɨdenɨgab alap, bɨ tap ne kod mɨdeb bɨ alap ag lek, tap ne okok kod mɨdenɨgab. Pen bɨ kɨb ak, mɨnɨm alap nɨŋnɨgab, bɨ tap ne kod mɨdenɨgab nɨbak, tap ne okok abramek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bɨ kɨb mɨnɨm nɨbak nɨŋɨl, nop sɨk agek apenɨgab agnɨgab, ‘Tap yad okok kod mɨd tep ma geban ak, yɨp ag ñel nɨpin. Nɨb ak, nak amɨl, tap yad titi mɨdeb okok magɨlsek wök pag nɨŋ tep gɨl, bin bɨ okok kɨrop tap dai yad titi mɨdeb okok magɨlsek wök pag nɨŋ tep gɨl, ap yɨp ag ñɨl, wög yad geban ak kɨsen ma gɨnɨgan,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Agenɨgab, bɨ tap ne kod mɨdeb nɨbak, nab ne okok nep gos par nɨŋɨl agnɨgab, ‘Bɨ kɨb ak yɨp ag yoknɨg geb ak pen yad tari gɨnɨm? Yad bɨ kɨlɨs ma mɨdebin rek, lɨm pɨŋɨl pag gɨnɨm rek ma lɨp. Bin bɨ ognap tap kɨrop ak asɨb ag gɨ ñɨbenɨgain ak, yɨp nabɨŋ gɨnɨgab,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pen kɨsen gos nɨŋ tep gɨl agnɨgab, ‘Yad tari gɨnɨm ak mɨñi nɨpin. Ar nɨbak gen, kɨsen bɨ kɨb yad yɨp ag yoknɨgab ñɨn ak, bin bɨ ognap yɨp del, karɨp kɨrop sɨŋak kɨn mɨdenɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nɨb agɨl, bin bɨ ognap kɨrop bɨ kɨb ne tap dai mɨdenɨgab okok sɨk agnɨgab. Sɨk agek, bɨ ned onɨgab ak nop agnɨgab, ‘Nak bɨ kɨb yad tap dai titi mɨdeb?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Agenɨgab agnɨgab, ‘Wel ñɨŋeb dɨlam ñɨnjuɨl aknɨb mamɨd alaŋ (100),’ agnɨgab. Agenɨgab agnɨgab, ‘Tiket aul dɨl, kasek bɨsɨgɨl dɨlam ñɨnjuɨl omal adɨk gɨ dam aknɨb wajrem alaŋ (50) ñu kɨl tɨkan,’ agnɨgab. Agenɨgab, agnɨgab rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kɨsen bɨ alap apenɨgab, agnɨgab, ‘Nak bɨ kɨb yad tap dai titi mɨdeb?’ agnɨgab. Agenɨgab agnɨgab, ‘Wid bek ñɨnjuɨl aknɨb mamɨd alaŋ (100),’ agnɨgab. Agenɨgab agnɨgab, ‘Tiket aul dɨl, kasek bɨsɨgɨl bek ñɨnjuɨl omal omal (80) ñu kɨl tɨkan,’ agnɨgab. Agenɨgab, agnɨgab rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nɨg genɨgab, kɨsen bɨ kɨb ne ak nɨŋɨl agnɨgab, ‘Bɨ tap yad kod mɨdep bɨ nɨbak, gos nɨŋ tep gɨl, tari tari gɨl mɨd tep gɨnɨgain, agɨp ak, ne gɨ tep gɨp,’ agnɨgab. Nɨb ak nɨŋɨm. Bin bɨ lɨm dai ar wagɨn aul gos nɨpal okok apal, ‘Mɨñi titi gɨl kɨsen bɨsɨg mɨdep cɨn ak mɨd tep gɨnɨmɨŋ?’ apal. Pen melɨk tep nɨpal bin bɨ okok nɨg aknɨb rek nep gɨplap ak tep. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Mani tap lɨm dai ar wagɨn aul mɨdeb okok, bin bɨ ognap okok ñem me, kɨsen tap nɨb okok pɨs nep kɨr gɨnɨgab ñɨn ak, God karɨp lɨm per mɨdep ne sɨŋak nɨbep ag wasu dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mani tap sɨkol alap, bin bɨ alap ñɨnmagɨl ar ak lel, kod mɨd tep gɨnɨgab ak, tap kɨb okok ñel, ak rek nep gɨnɨgab. Pen mani tap sɨkol alap, bin bɨ alap ñɨnmagɨl ar ak lel, kod mɨd tep ma gɨnɨgab ak, tap kɨb okok ñel, ak rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pen nɨbi mani tap lɨm dai ar wagɨn aul mɨdeb ak dɨl, esek agɨl, kod mɨd tep ma gɨnɨgabɨm ak, bɨ an nɨbep tap tep yɨb ar alaŋ nɨb ñɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bɨ alap mani tap ne dɨ ñɨnmagɨl ar nɨbep lɨnɨgab ak, nɨbi esek agɨl, kod mɨd tep ma genɨgabɨm ak, bɨ an mani tap nɨbep ke ñɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bɨ nokɨm alap, bɨ kɨb omal kɨrop wög gɨnɨmɨŋ rek ma lɨp. Bɨ omalgɨl kɨrop wög gɨnɨgab ak pen ne bɨ kɨb alap nop mɨdmagɨl lɨl, bɨ alap nop mɨdmagɨl ma lɨnɨgab. Aka bɨ kɨb alap nop mɨdmagɨl lɨl, bɨ alap nop mɨdmagɨl ma lɨnɨgab. Aknɨb rek, nɨbi mani tap okok tap tep yɨb agɨl nɨŋenɨgabɨm ak, God nop wög gɨpɨm ak kɨrɨg gɨnɨmɨb rek lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bɨ Perisi okok, gos kɨb kɨri mani ar ak nep nɨŋölɨgɨpal ak me, Jisas mɨnɨm agek ak nɨŋɨl sɨk agɨl ag juelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ag juelak, kɨrop agak, “Nɨbi bin bɨ udɨn yɨrɨk ar ak, cɨn bin bɨ tep mɨdobɨn, apɨm ak, pen God cɨbur gos mɨdmagɨl nab nɨbep adaŋ nɨŋɨp. Tap bin bɨ nɨŋel tep gɨp okok, God nɨŋek tap tɨmel rek lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Jon bɨ ñɨg pak ñeb ma owak ñɨn ak, lo mɨnɨm ñu kɨl tɨklak ak abe, bɨ God mɨnɨm agep mɨnɨm ñu kɨl tɨklak ak abe agel, bin bɨ nɨŋɨl, ar nɨbak gel amolɨgɨp. Pen Jon owak ñɨn ak tɨkek, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm tep ak agel, bin bɨ nɨŋɨl kɨri magɨlsek ar nɨbak nep amnɨn, agɨl, kɨlɨs gɨl gel ameb. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Seb kab ar alaŋ abe lɨm dai wagɨn aul abe kɨr gɨnɨmɨŋ rek lɨp, pen lo mɨnɨm ak dai sɨkol alap kɨr gɨnɨmɨŋ rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pen, bɨ alap bin dɨl kɨrɨg gɨl, am bin kɨsen nɨb alap dɨnɨgab ak, bin si dɨnɨgab. Pen bɨ alap warɨkɨl, bin ak, bɨ dɨl kɨrɨg gɨnɨgab bin nɨbak dɨnɨgab ak, ne ak rek nep bin si dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Bɨ alap mani tap ne koŋai yɨb mɨdolɨgɨp. Ne walɨj tep tep nep yɨmɨl, tap ñɨŋeb tep tep nep ñɨbolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pen karɨp kɨjoŋ wagɨn gol ne sɨŋak, bɨ soi bɨrbɨr sek tap ma mɨdolɨgɨp bɨ alap dap lel mɨdolɨgɨp. Yɨb ne Lasaras. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gos ne ak nep nɨŋɨl, ‘Bɨ tap koŋai mɨdeb aul tap ñɨbek, tap yɨpɨl yɨpɨl abañ mok sɨŋ aul yonɨgab ak, yad ñɨbenɨgain yuan ma lɨnɨgab,’ agɨl, nɨŋolɨgɨp. Pen kain okok apɨl, soi ne okok bɨleg gɨ ñɨbelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kɨsen bɨ yɨgen nɨbak kɨmak. Ne kɨmek, ejol okok apɨl, nop dam karɨp lɨm ar alaŋ sɨŋak amɨl, Ebraham pɨs ne pɨs kɨd lek tap kɨb ñɨŋak. Pen bɨ gep nɨbak abe kɨmek, tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bɨ gep nɨbak kɨmɨl, mab ke yɨneb eyaŋ sɨŋak amek, nop yur kɨb yɨb gek nɨŋlɨg gɨ mɨdolɨgɨp. Pen mɨdɨl kɨlan gɨ nɨŋak, Ebraham Lasaras eip ke ke sɨŋ alaŋ mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nɨŋɨl, sɨk par agɨl agak, ‘Bapi Ebraham, yɨp yɨmɨg nɨŋɨl, Lasaras nop agek, ñɨnmagɨl par ne alap ñɨg alap tauɨl, dap aleb yɨp ak dɨ nɨŋek, yɨp sain gaŋ. Mab ak sɨj yɨnɨl, yɨp yur kɨb yɨb gɨp,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Agek, Ebraham agak, ‘Ñɨ nɨŋan! Lɨm dai ar wagɨn eyaŋ mɨdelɨgɨpan ñɨn ak, nak tap tep tep nak bɨr dölɨgɨpan, pen Lasaras tap tɨmel tɨmel nep dolɨgɨp. Pen mɨñi karɨp lɨm aul, ne sain tep mɨdek nɨŋlɨg gɨ, nep yur kɨb gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","God ne mol kɨb yɨb nab aul gɨ lak ak me, cɨn bin bɨ pɨs kɨd aul talak gɨl pɨs kɨd adaŋ nɨjɨn rek ma lɨp; pen nɨbi pɨs kɨd talak gɨl pɨs kɨd aul onɨmɨb rek ma lɨp,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Agek, bɨ nɨbak agak, ‘Nɨb ageban rek, Lasaras nop agek, ne bapi yad karɨp amɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mam yad aknɨb mamɨd alaŋ kɨrop mɨnɨm kɨlɨs yɨb agek, karɨp lɨm yur ke tɨmel per nep gɨp sɨŋaul ma onɨmel,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Agek, Ebraham pen agak, ‘Mosɨs abe, bɨ God mɨnɨm agep bɨ okok abe, mɨnɨm ñu kɨl tɨklak ak nɨŋnɨmel,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Agek, agak, ‘Bapi Ebraham, nɨg ma gɨnɨgal; pen bin bɨ alap kɨmɨl warɨkɨl, am agenɨgab ak me, nɨŋɨd agɨp, agɨl, tap si tap tɨmel gɨpal ar ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨnɨgal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Agek, Ebraham agak, ‘Kɨri Mosɨs abe, bɨ God mɨnɨm agep bɨ okok abe, mɨnɨm ñu kɨl tɨklak mɨnɨm nɨbak ma nɨŋnɨgal ak, bɨ alap kɨmɨl warɨknɨgab ak, kɨri ak rek nep ma nɨŋnɨgal,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas bɨ ne okok kɨrop agak, “Bɨ alap aka bin alap nag tɨmel ar ak gɨl, bin bɨ ognap kɨrop gos ñek, kɨri abe nag tɨmel ar nɨbak gɨl ap yap paknɨgal. Nag ar nɨbak ned gölɨgɨpal, mɨñi gɨpal, kɨsen ak rek nep gɨnɨgal. Pen bin bɨ kɨri gos tɨmel ñɨnɨgal okok, kɨri yur aknɨb ke yɨb dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pen bɨ alap aka bin alap, ñɨ pai okok nokɨm alap nɨg gɨnɨg gɨnɨgab ak, ned kab kɨb wid pa cɨb jakep kab alap dɨl kɨŋam nop ak sek nag lɨ rɨbɨkɨl, dam ñɨg solwara yokplap ak tep. Tari gɨnɨg: ne komɨŋ mɨdɨl, ñɨ pai alap nop gek ap yap paknɨgab ak, yur kɨb yɨb dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nɨb ak, nɨbi ke gos nɨŋ tep gɨl gɨnɨmɨb. “Nanai namam nak alap tap si tap tɨmel gonɨmɨŋ, nop sɨlɨk agem, tari gɨnɨg nɨg gɨpin, agɨl gos nɨŋenɨgab ak, gɨ tɨmel gak nɨbak nɨŋɨl kɨrɨg gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tap nɨbep rek ognap gɨ tɨmel gɨl, kɨsen apɨl, tari gɨnɨg nɨg gɨpin, agɨl agenɨgab ak, tap tɨmel gak nɨbak nɨŋɨl kɨrɨg gɨnɨmɨb. Pen ñɨn nokɨm alap, nɨg gek gek aknɨb ar oŋɨd ak genɨmɨŋ ak, ak rek nep nɨŋɨl kɨrɨg gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas nɨb agek, bɨ mɨnɨm ne dad ameb okok aglak, “Nak cɨnop gek, nɨŋ dep magɨl cɨn kɨb gɨnɨmɨŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Agelak, Jisas kɨrop agak, “Nɨŋ dep magɨl kɨb mer, nɨŋ dep magɨl nɨbi mab mastad magɨl sɨkol yɨb ak rek nep mɨdenɨgab ak, nɨbi mab nɨbaul, wagɨn sek ju amɨl ñɨg solwara nab sɨŋ adaŋ tan mɨdei, agɨl agem, agnɨgabɨm rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nɨbi gos tari nɨpɨm? Bɨ wög gɨ ñeb bɨ alap lɨm dai pɨŋɨl pag sakɨl, aka kaj sipsip mɨk sakɨl, adɨk gɨ karɨp apek, bɨ nap ne ak nop mɨnɨm tari agnɨgab? ‘Nep yuan gɨp ak, nak sɨŋaul bɨsɨgɨl tap magɨl ñɨŋan,’ agnɨgab aka? ");
INSERT INTO kmh_m_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mer. Nɨb ma agnɨgab. Ne agnɨgab, ‘Walɨj dek ap ranek, sɨb nag pog lɨl, ñɨg tap yad okok dap ñek ñɨben, kɨsen ñɨg tap nak okok ñɨŋan,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nɨbi gos tari nɨpɨm? Bɨ wög gɨ ñeb nɨbak, bɨ kɨb agnɨgab rek genɨgab ak, bɨ kɨb mɨnɨm tep ognap nop agnɨgab aka? Mer. Bɨ wög gɨ ñeb ne mɨdeb ak me, bɨ kɨb ne agnɨgab rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nɨb aknɨb rek me nɨbi. God nɨbep wög ag lɨnɨgab rek, gɨ sakɨl, agnɨgabɨm, ‘Cɨn bin bɨ wög gɨ ñeb tep mer. Tap ar alap ke ma gɨpɨn; wög cɨn ke gep ak rek nep gɨpɨn,’ agnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalem amnɨm, agɨl, karɨp lɨm Sameria aul, karɨp lɨm Galili kɨdadaŋ nab sɨŋak adaŋ amɨl amɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","karɨp tɨrɨg tɨroŋ alap ajek nɨŋlɨg gɨ, bɨ soi kɨsak lak aknɨb wajrem alaŋ, nop nabɨŋ pakɨl, ke ke sɨŋ adaŋ mɨdɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","meg mɨgan dap ranɨl aglak, “Jisas, Bɨ Kɨb, cɨnop yɨmɨg nɨŋan,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Agelak, Jisas kɨrop agak, “Nɨbi amɨl, bɨ God nop tap sobok gep okok kɨrop wak nɨbi okok yomnɨmɨb,” agak. Nɨb agek, kɨri amɨl, majɨl nab sɨŋak amel nɨŋlɨg gɨ, kɨrop komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pen kɨrop nɨg gɨl komɨŋ lek, bɨ Sameria nɨb alap, nop komɨŋ lak ak nɨŋɨl, mɨnɨm kɨb aglɨg gɨ, God yɨb nop agek ar amek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","adɨk gɨ apɨl, Jisas mɨdek ulep tob wagɨn sɨŋak yap pakɨl, mɨlɨk dai ne kɨyan gɨ lɨm eyaŋ nɨŋɨl, Jisas nop tep agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ne nɨg gek, Jisas agak, “Yad gos nɨpin e, bɨ aknɨb wajrem alaŋ komɨŋ lɨp ak, pen bɨ aknɨb ajɨp alaŋ okok akal? ");
INSERT INTO kmh_m_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bɨ ognap tari gɨnɨg ma opal? Bɨ par okok nɨb, bɨ Juda mer ak nep apɨl God nop tep ageb ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas nɨb agɨl bɨ nɨbak nop agak, “Jisas yɨp gek komɨŋ lɨnɨgab, agɨl, nɨŋ dɨpan rek, nep komɨŋ lɨp amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pen ñɨn alap bɨ Perisi okok Jisas nop ag nɨŋɨl, “God bin bɨ dɨl kod mɨdenɨgab ñɨn nɨbak ñɨn akal onɨgab?” aglak. Agelak, Jisas pen agak, “God bin bɨ dɨl kod mɨdenɨgab, agebɨm nɨbak, bin bɨ okok kiŋ kɨri ak kod mɨdɨl mɨdɨl, nɨŋ tep gel gel, kɨsen kiŋ kɨri apek, bin bɨ nop udɨn nɨŋɨl, mɨñi apeb, agnɨgal rek ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Mɨdeb aul,’ aka ‘Mɨdeb adaŋ,’ ma agnɨgal. Tari gɨnɨg: ne kapkap apɨl, nab nɨbep sɨŋaul bɨr mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nɨb agɨl, bɨ ne okok kɨrop agak, “Kɨsen okok, Bɨ Ñɨ ne apek nop nɨŋɨn, agɨl, mɨdmagɨl nɨbep pɨŋɨl ñɨl nep mɨdenɨgab, pen nop ma nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bin bɨ ognap nɨbep agnɨgal, ‘Mɨdeb aul,’ aka ‘Mɨdeb adaŋ,’ agenɨgal ak pen mɨnɨm nɨbak nɨŋɨd agebal, agɨl, pɨg gɨ rɨkɨd ag amɨl, kɨrop eip ma amnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tari gɨnɨg: Bɨ Ñɨ ne onɨgab ñɨn ak, añɨm añɨm dɨl, melɨk parsek amɨb nɨpal ak rek onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pen nɨbi bin bɨ mɨñi mɨdebɨm sɨŋ aul, Bɨ Ñɨ ne nop yɨrɨk nɨŋɨl, nop ma dɨl, nop mɨker kɨb yɨb ñɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bɨ Ñɨ ne onɨgab ñɨn nɨbak, bɨrarɨk nep Noa mɨdek ñɨn ak gak rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa mɨdek ñɨn ak, bin bɨ okok tap magɨl ñɨblɨg gɨ, ñɨg ñɨblɨg gɨ, bin pen pen ñɨlɨg gɨ, gɨ mɨdel nɨŋlɨg gɨ, Noa amɨlgon apɨlgon ñɨg magöb kɨb ñɨlɨk mɨgan amel nɨŋlɨg gɨ, nogob asad kɨb yɨb ñagebin, agek, ñɨg ulɨk apɨl bin bɨ okok kɨrop magɨlsek dɨ yɨpɨl yɨpɨl yokek kɨm saklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pen bɨ Lot mɨdek ñɨn ak, Sodom bin bɨ okok ak rek nep tap ñɨblɨg gɨ, ñɨg ñɨblɨg gɨ, tap okok sɨkim gɨlɨg gɨ, tap wög dai okok gɨlɨg gɨ, karɨp gɨlɨg gɨ, gɨ mɨdel nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot karɨp lɨm nɨbak kɨrɨg gɨl, karɨp lɨm mɨgan alap ke amek nɨŋlɨg gɨ, won nɨbak nep, mab mɨlaŋ kɨb seb kab ar alaŋ nɨb apɨl, Sodom bin bɨ kɨrop magɨlsek yɨn sɨbok ñɨb amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bɨ Ñɨ ne onɨgab ñɨn ak, nɨg aknɨb rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ñɨn nɨbak, bin bɨ karɨp ar alaŋ mɨdenɨmel okok, tap kɨri karɨp ñɨlɨk mɨgan eyaŋ mɨdeb ak dɨnɨg karɨp mɨgan eyaŋ ma amnɨmel. Pen bin bɨ wög dai okok ajenɨmel okok, tap ognap dɨnɨg adɨk gɨ karɨp ma amnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot bine nop gak ar ak nep gos nɨŋɨl, nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bin bɨ an, yad ke nɨŋ tep gɨl komɨŋ mɨdenɨgain, agɨl nɨŋnɨgab ak, kɨmnɨgab; pen bin bɨ an, Krais mɨnɨm tep ageb rek wög nop gɨ damɨl kɨmnɨgain, agɨl nɨŋnɨgab ak, komɨŋ mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nɨbep agebin, ñɨn nɨbak kɨslɨm eyaŋ bɨ omal abañ ar nokɨm alap kɨnenɨgair ak, alap dɨl, alap kɨrɨg gɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pen bin omal wid magɨl pak jɨsɨpɨk masɨpɨk lɨgolɨg genɨgair ak, alap dɨl, alap kɨrɨg gɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bɨ omal wög dai okok wög gɨ mɨdenɨgair ak, alap dɨl, alap kɨrɨg gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisas nɨb agek, kɨri aglak, “Bɨ Kɨb, mɨnɨm ageban nɨbak, karɨp lɨm akal nɨg gɨnɨgab?” aglak. Agelak, Jisas agak, “Kɨmɨn kobri alap kɨmɨl mɨdenɨgab sɨŋak, yakɨr gɨlgalap nɨŋɨl ap sɨbaibai gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas, bɨ yad okok gos par ma nɨŋnɨmel, God nop sobok gɨlɨg gɨ nep mɨdenɨmel, agɨl, kɨrop mɨnɨm alap mɨnɨm sɨd tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Karɨp lɨm alap, bɨ kɨb mɨnɨm tɨg bɨlokep bɨ alap mɨdenɨgab. Pen bɨ nɨbak, God nop gos ak ma nɨŋɨl, bin bɨ okok kɨrop yɨmɨg ma nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pen bin kaŋɨl karɨp lɨm nɨbak nɨb alap, per nep apɨl nop agnɨgab, ‘Bɨ kaual maual yad alap mɨnɨm cɨrop ak nɨŋnɨmɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nɨb agnɨgab ak pen bɨ mɨnɨm tɨg bɨlokep bɨ kɨb nɨbak mɨnɨm ne ak ma dɨnɨgab. Pen bin kaŋɨl nɨbak, ne per per apɨl ag nɨŋ gek gek, kɨsen bɨ kɨb nɨbak agnɨgab, ‘Yad God nop ma pɨrɨkpin; bin bɨ okok kɨrop yɨmɨg ma nɨpin; ");
INSERT INTO kmh_m_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pen bin kaŋɨl aul yɨp per per apɨl ag nɨŋ gek gek yɨp yɨrɨk gɨp ak me, yad am mɨnɨm kɨb nɨbak nɨŋnɨm,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bɨ Kɨb nɨb agɨl agak, “Bɨ mɨnɨm tɨg bɨlokep nɨbak bin bɨ yɨmɨg ma gak, pen ne mɨnɨm tari agak ak nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nɨbi gos tari nɨpɨm? God ne bin bɨ ne ke ag lɨp okok, pɨb nab kɨslɨm eyaŋ nop sobok genɨgal ak, mɨnɨm kɨrop nɨŋɨl yɨmɨg ma nɨŋnɨgab, agɨl, nɨpɨm? Kɨri mɨlek par kod mɨdenɨgal, agɨl, nɨpɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yad nɨbep agebin, ne mɨnɨm agnɨgal nɨbak nɨŋɨl, kɨrop yɨmɨg nɨŋɨl, kasek nep bɨ kaual maual kɨrop gɨ tɨmel gɨnɨgal okok majɨl pɨlɨŋ gɨnɨgab. Pen Bɨ Ñɨ ne lɨm dai ar wagɨn aul adɨk gɨ onɨgab ñɨn ak, bin bɨ ognap nop nɨŋ dɨlɨg gɨ mɨdenɨgal aka mer?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bin bɨ ognap, cɨn bin bɨ tep, bin bɨ ognap okok bin bɨ tɨmel, agɨl, nɨŋlak rek, Jisas kɨrop mɨnɨm alap mɨnɨm sɨd tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bɨ Perisi alap, bɨ takɨs dep alap, God nop sobok gɨnɨg, God sobok gep karɨp ak amnɨgair. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bɨ Perisi nɨbak, nab ne okok nep God nop sobok gɨl agnɨgab, ‘Nep tep yɨb agebin. Yad bɨ ognap gɨpal rek, tap tep koŋai nep dɨl, tap si dɨl, bin si dɨl, ma gɨpin. Yad bɨ takɨs dep epim aul rek mer. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wik per per, ñɨn omal tap magɨl bɨl gɨpin sek. Per tap yad aknɨb wajrem alaŋ dɨl, nep nokɨm nɨb alap ñɨbin,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pen bɨ takɨs dep nɨbak, nop nabɨŋ gek, seb kab ar alaŋ ma nɨŋɨl, ke ke sɨŋ adaŋ kɨbor kɨyan gɨl, pabɨl cög ne ke pakɨl, gos par nɨŋɨl agnɨgab, ‘God, yad bɨ tap si tap tɨmel gɨpin ak, yɨp yɨmɨg nɨŋnɨmɨn,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nɨbep agebin, bɨ takɨs dep ak nɨb agek, God nop, tap si tap tɨmel gɨpan ak nɨŋɨl kɨrɨg gebin, agnɨgab. Pen bɨ Perisi ak nop God nɨb ma agnɨgab. Tari gɨnɨg: bin bɨ yɨb kɨri ke dap rannɨgal okok, God gek ap yap paknɨgal. Pen bin bɨ yɨb kɨri ke ma dap rannɨgal okok, God gek kɨri yɨb mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bin bɨ okok, Jisas ñɨ pai sɨkol cɨnop dɨ nɨŋaŋ, agɨl, dapelak. Jisas kɨrop dɨ nɨŋek nɨŋlɨg gɨ, bɨ ne okok nɨg gesal ak nɨŋɨl, bin bɨ nɨb okok kɨrop sɨlɨk agɨl aglak, “Nɨbi aknɨb ma gɨnɨmɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisas pen ñɨ pai nɨb okok sɨk agek apelak, bɨ ne okok kɨrop agak, “Tari gɨnɨg kɨrop nɨb ag gebɨm? Ñɨ pai sɨkol nɨb okok kɨrɨg gem yɨp olaŋ. God bin bɨ dɨl seb kab ar alaŋ kod mɨdenɨgab ak, ñɨ pai sɨkol nɨb okok rek mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","God Mɨnɨm ag ñɨl nɨb gɨl mɨdeb agenɨgal ak, ñɨ pai sɨkol okok God Mɨnɨm nɨbak nɨŋɨl, kasek nɨŋ dɨnɨgal. Nɨb ak, yad nɨbep nɨŋɨd agebin, bin bɨ ñɨ pai sɨkol yɨp nɨŋ dɨpal rek, yɨp nɨŋ denɨgal bin bɨ okok, God kɨrop dɨl kod mɨdenɨgab. Pen bin bɨ ñɨ pai sɨkol yɨp nɨŋ dɨpal rek, yɨp ma nɨŋ dɨnɨgal bin bɨ okok, God karɨp lɨm ne sɨŋak ma amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda bɨ kɨb alap Jisas mɨdek sɨŋak apɨl agak, “Bɨ mɨnɨm ag ñeb bɨ tep yad. Yad tari gɨl, komɨŋ per mɨdep won ak dɨnɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Agek, Jisas agak, “Yɨp tari gɨnɨg, ‘Bɨ tep,’ ageban? Bin bɨ alap tep ma mɨdeb; God nokɨm me Bɨ tep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pen nak God lo mɨnɨm ak nɨpan: ‘Bin si bɨ si ma gɨnɨmɨb; cɨp ma ñagnɨmɨb; tap si ma dɨnɨmɨb; mɨnɨm kɨb agnɨgal okok am mɨnɨm esek ma agnɨmɨb; nanɨm nap agnɨmir ar ak nep nɨŋɨl, kɨsen gɨnɨmɨb,’” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nɨb agek, bɨ nɨbak agak, “Yad ñɨ sɨkol nep tɨkɨl, lo mɨnɨm ar nɨb okok magɨlsek gɨ dap dap, mɨñi ñɨn aul ak rek nep gɨ mɨdebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas mɨnɨm nɨbak nɨŋɨl nop pen agak, “Tap nokɨm alap nep ma gɨpan. Tap nak okok magɨlsek sɨkim gɨl, mani dɨl, bin bɨ yɨm gep rek okok kɨrop nonɨm lɨ ñɨnɨmɨn. Nɨg genɨgan ak me, mɨd tep gep nak ak mɨdenɨgab God karɨp lɨm seb kab ar alaŋ sɨŋak. Agebin rek gɨl, apek, yad eip ajor,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jisas mɨnɨm nɨbak agek, Juda bɨ kɨb nɨbak mani tap ne okok koŋai nep mɨdek ak gos nɨŋɨl mapɨn gek, gos par nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gos par nɨŋek ak, Jisas nop nɨŋɨl agak, “Bin bɨ tap koŋai mɨdenɨgab okok, koslam yɨb God bin bɨ ne mɨdel, kɨrop dɨl, karɨp ne sɨŋak kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kaj kamel okok ñu mauöl nag yokpal mɨgan ak amnɨg, koslam amnɨgal ak pen bin bɨ kɨbap kɨlnok tap okok koŋai nep mɨdeb okok, God karɨp lɨm ne ak koslam yɨb amnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nɨb agek, bin bɨ mɨdelak okok aglak, “Mɨnɨm ageban nɨbak, God ne bin bɨ alap dɨ komɨŋ yoknɨmɨŋ rek ma lɨp aka tari?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Agelak, Jisas agak, “Ar ognap bin bɨ gɨnɨmel rek ma lɨp ak pen God ne gɨnɨg, gɨnɨmɨŋ rek nep lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nɨb agek, Pita agak, “Nɨŋan! Karɨp tap cɨn okok magɨlsek kɨrɨg gɨl, nep eip nep jɨm ñɨl ajobɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Agek, Jisas kɨrop agak, “Nɨbep nɨŋɨd agebin, bin bɨ, God mɨnɨm tep ne ak dad ajojɨn, agɨl, karɨp, bin, nɨmam, nonɨm nap, ñɨ pai kɨri okok kɨrɨg gɨnɨgal okok, God kɨrop saköl ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mɨñi mɨdobɨn ñɨn nab aul, God ne kɨrop kod mɨd tep gek, tap kɨri okok, bin bɨ kɨri okok koŋai nep mɨdenɨgab. Pen ñɨn kɨsen ak, ne eip per per nep mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas bɨ ne aknɨb umɨgan alaŋ kɨrop dam gol okok amɨl agak, “Nɨŋɨm. Mɨñi Jerusalem amobɨn. Amjaknɨgabɨn ak, Bɨ Ñɨ ne nop, God mɨnɨm agep bɨ okok bɨrarɨk nep God Mɨnɨm ak ñu kɨl tɨkɨl aglak rek nep gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nop dɨl, bɨ Juda mer okok ñɨnmagɨl ar kɨrop lel, nop ag juɨl, ñɨloŋ lɨl, kɨñɨk ñagɨl, nag dɨ pakɨl, pɨs nep ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pen ñɨn omal mɨdɨl, mɨnek ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pen Jisas nɨb agek, bɨ ne okok gos pag yɨknɨmɨŋ rek ma lek, mɨnɨm ageb ar ak, agɨl, ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pen kɨsen, Jisas am Jeriko amjakek nɨŋlɨg gɨ, bɨ udɨn kwoi alap mɨdek. Bɨ nɨbak ne majɨl gol sɨŋak bɨsɨg mɨdɨl, mani tap ñɨm, agɨl, asɨb aglɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bin bɨ koŋai nep mɨnɨm ag padɨkel nɨŋlɨg gɨ, bin bɨ ognap kɨrop ag nɨŋɨl agak, “Tari gebal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Agek aglak, “Jisas bɨ Nasaret nɨb ak apɨl padɨkeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nɨb agelak, ne sɨk kɨb agɨl agak, “Jisas, Depid Ñɨ ne, yɨp yɨmɨg nɨŋan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Agek, bin bɨ padɨkelak okok nop ag gɨl aglak, “Tari gɨnɨg ap raneban? Kapkap mɨdei!” aglak. Nɨb aglak ak pen ne kapkap ma mɨdek. Sɨk par yɨb aglɨg gɨ agak, “Jisas, Depid Ñɨ ne, yɨp yɨmɨg nɨŋan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Agek, Jisas nɨŋɨl wös gɨl, bin bɨ okok kɨrop agak, “Poŋɨd ulep sɨŋaul dowɨm,” agak. Agek, poŋɨd dapelak agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nep tari gɨnɨm?” agak. Agek agak, “Bɨ Kɨb, yɨp gek udɨn magɨl ak kauyaŋ nɨŋin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Agek, Jisas nop agak, “Jisas yɨp gek, udɨn magɨl ñɨl nɨŋnɨgain, agɨl, gos nɨŋ deban rek, udɨn magɨl ñɨl nɨŋan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Agek, magɨl nɨbak nep udɨn ñɨl nɨŋɨl, God yɨb ne ak agek ar amek nɨŋlɨg gɨ, Jisas amek sɨŋak kɨsen gak. Bin bɨ magɨlsek Jisas gak nɨbak nɨŋɨl, God yɨb ne ak agel ar amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jeriko amɨl, nab nɨb sɨŋak ap padɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pen Jeriko sɨŋak, bɨ mani tap okok koŋai mɨdolɨgɨp alap, bɨ takɨs bɨ dölɨgɨpal okok kɨrop magɨlsek kod mɨdolɨgɨp. Yɨb ne Sakias. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisas taun nab sɨŋak padɨkek nɨŋlɨg gɨ, bin bɨ koŋai nep ap nɨŋnɨg gelak. Sakias ne bɨ ulep won ak me, Jisas bɨ tigep bɨ rek mɨdeb ak nɨŋin, agɨl, nɨŋak ak pen ma nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nɨg gek, ne ned pɨg gɨ rɨkɨd ag am mab bɨd alap tan ar alaŋ amɨl, Jisas apek tam oŋɨd nɨŋlɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas pen mab tan mɨdek wagɨn nɨb sɨŋak apɨl, kɨlan gɨ nɨŋɨl, Sakias nop agak, “Sakias, nak kasek wagɨn aul yowan! Mɨñi am karɨp nep ak eip mɨdenɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Agek, Sakias kasek wagɨn eyaŋ yapɨl, mɨñ mɨñ gɨlɨg gɨ, Jisas nop poŋ dɨ dam karɨp ne dad amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bin bɨ okok gak nɨbak nɨŋel mɨlɨk yapek nɨŋɨl aglak, “Bɨ nɨbak am bɨ tap si tap tɨmel gɨp karɨp ak kɨnnɨg ameb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pen Sakias warɨkɨl, Jisas nop agak, “Bɨ Kɨb, nak nɨŋan! Mɨñi tap yad okok nonɨm lɨ pɨs ak ke lɨl, pɨs ak bin bɨ yɨm gep rek okok kɨrop ñɨnɨgain. Pen yad ned wai ñɨl, bin bɨ ognap tap kɨri si dɨnek rek lɨp okok pen ñɨnɨgain, agɨl, tap nokɨm alap si dɨnek rek, pen omal omal ñɨnɨgain; pen tap omal si dɨnek rek, pen aknɨb jɨl oŋɨd ak ñɨnɨgain. Nɨg gɨ dam dam magɨlsek dai pag ju sakɨl, kɨrɨg gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Agek, Jisas agak, “Bɨ aul Ebraham ñɨ ne alap. Mɨñi God ne yakam karɨp aul kɨnebal tap si tap tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨl dɨ komɨŋ yokɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bɨ Ñɨ ne owak ak, bin bɨ kɨr gɨpal okok kɨrop pɨyo nɨŋɨl dɨ komɨŋ yoknɨm, agɨl, owak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pen bin bɨ nɨb okok, Jisas me, Bɨ Kɨb per kod mɨdobɨn ak, Jerusalem amek, nop kiŋ ag lon, cɨnop kod mɨdek, mɨd tep yɨb gɨnɨgabɨn, agɨl gos ak nɨŋlak. Jisas, gos kɨri nɨŋlak nɨbak ke nɨŋɨl, kɨrop mɨnɨm alap sek sɨd tɨkɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jisas mɨnɨm sɨd tɨkɨl agak, “Bɨ kɨb alap, bɨ kɨb kod mɨdep yad mɨdeb sɨŋak amen, yɨp kiŋ ag lek, adɨk gɨ apɨl, bin bɨ karɨp lɨm yad sɨŋ aul kɨrop kiŋ kod mɨdenɨm, agɨl, karɨp lɨm par mɨlek okok amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pen ned bɨ wög gep ne aknɨb wajrem alaŋ kɨrop sɨk agek apenɨgal, bɨ kɨb ne kab magɨl gol nokɨm nokɨm ke ke nonɨm lɨl agnɨgab, ‘Kab magɨl ñebin aul dɨl, sɨkim gɨ adɨk madɨk gɨl, koŋai dɨ lɨnɨmɨb; kɨsen yad kauyaŋ onɨgain,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nɨb agɨl amnɨgab ak pen bin bɨ karɨp lɨm ne kod mɨdek okok, nop mɨlɨk yapek nɨŋlɨg gɨ, bɨ ognap ag yokel, kɨsen amɨl, bɨ kɨb yɨb ak nop agnɨgal, ‘Bɨ nɨbaul ne kiŋ cɨn ma mɨdenɨgab,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pen bɨ kɨb yɨb ak mɨnɨm kɨri ak ma dɨl, bɨ kɨb nɨbak nop kiŋ kɨri ag lɨnɨgab. Nɨg gek, ne kauyaŋ adɨk gɨ apɨl, bɨ wög gɨ ñeb ne okok kɨrop sɨk agek apenɨgal, kiŋ kɨri ak agnɨgab, ‘Kab magɨl gol ñɨbin okok, nɨbi dɨ sɨkim gɨ adɨk madɨk gɨl, pen titi gɨl dɨpɨm?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Agek, bɨ ned ak apɨl agnɨgab, ‘Bɨ kɨb, kab magɨl gol nokɨm yɨp ñɨnak ak, sɨkim gɨ adɨk madɨk gɨl, pen aknɨb wajrem alaŋ kab magɨl gol dɨpin,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Agenɨgab, bɨ kɨb ne ak agnɨgab, ‘Nak gɨ tep gɨpan. Tap sɨkol ak ñɨnek wög gɨ tep gɨpan rek, mɨñi taun kɨb aknɨb wajrem alaŋ nep agen, kod mɨdenɨgan,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pen bɨ alap apɨl agnɨgab, ‘Bɨ kɨb, kab magɨl gol nokɨm yɨp ñɨnak ak, sɨkim gɨ adɨk madɨk gɨl, pen aknɨb mamɨd alaŋ kab magɨl gol dɨpin,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Agenɨgab, bɨ kɨb ne ak agnɨgab, ‘Gɨpan nɨbak rek, mɨñi taun kɨb aknɨb mamɨd alaŋ nep agen, kod mɨdenɨgan,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pen bɨ wög gep ne alap apɨl agnɨgab, ‘Bɨ kɨb, yad nep nɨpin. Nak bɨ kal yɨb. Bin bɨ ognap tap kɨri okok, nak sɨkim gɨ tep gɨl mer, tau pɨlɨ gɨ dɨpan. Tap wög koslam gɨ yɨbal okok, nak kɨlɨs gɨl nep ñɨban. Nɨb ak, yad nep pɨrɨkɨl me, kab magɨl gol nokɨm yɨp ñɨnak ak, dam lɨpsam tin ñon gɨ len mɨdek. Magɨl gol nokɨm nak ak mɨñi dopin aul,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Agenɨgab, bɨ kɨb ne ak agnɨgab, ‘Mɨnɨm nak apan ak tɨg adɨk gɨl, mɨnɨm kɨb nak eip agnɨgain. “Nak bɨ kal yɨb, bin bɨ ognap tap kɨri okok, nak sɨkim gɨ tep gɨl mer, tau pɨlɨ gɨ dɨpan; tap wög koslam gɨ yɨbal okok, nak kɨlɨs gɨl nep ñɨban,” ageban ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nɨb ak, tari gɨnɨg kab magɨl yad ak dam beg pasbuk lek, adɨk gɨ apɨl sinɨŋ ognap sek ma dɨpin?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nɨb agɨl, bɨ ulep sɨŋak mɨdenɨgal okok kɨrop agnɨgab, ‘Kab magɨl gol yad ak pɨlɨ gɨ dɨl, bɨ sɨŋak kab magɨl gol wajrem alaŋ mɨdeb ak nop ñɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Agenɨgab agnɨgal, ‘Bɨ kɨb. Ne kab magɨl gol wajrem alaŋ bɨr mɨdeb!’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Agenɨgal agnɨgab, ‘Nɨbep agebin, per bin bɨ tap kɨri koŋai mɨdenɨgab okok ognap sek dɨnɨgal, pen bin bɨ tap kɨri sɨkol sɨkol mɨdenɨgab okok gel, tap sɨkol nɨbak pɨs nep yap lɨg amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pen bin bɨ yɨp nɨŋɨl mɨlɨk nɨŋɨl, bɨ nɨbak ne kiŋ cɨn ma mɨdenɨgab, aglak bin bɨ okok, kɨrop am dapɨl, udɨn yɨrɨk ar yad sɨŋaul ñag pak lɨm,’ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas kɨrop mɨnɨm nɨbak agɨl, bɨ ne okok eip Jerusalem amnɨn, agɨl, ne ned gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Am am Olip Dɨm sɨŋak, karɨp tɨrɨg tɨroŋ Betpagi Betani gol sɨŋak ulep amjakɨl, bɨ ne omal kɨrop ned ag yokɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Karɨp tɨrɨg tɨroŋ mɨgan kɨdadaŋ amɨl nɨŋnɨgair, kaj donki marɨp bin bɨ dad ma ajpal alap, nag ñon gɨ lel mɨdenɨgab ak, wɨsɨb donɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pen bin bɨ ognap apɨl, ‘Kaj donki ak tari gɨnɨg wɨsɨb dad amebir,’ agenɨmel ak, agnɨmir, ‘Bɨ Kɨb ak wög mɨdek cɨrop ag yokosɨp, dɨnɨg apobɨr,’ agnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nɨb agek, amɨl nɨŋrek, agak rek nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am nag wɨsɨb ger nɨŋlɨg gɨ, bɨ kaj donki nap nɨb okok apɨl aglak, “Kaj donki marɨp ak tari gɨnɨg nag wɨsɨbebir?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Agelak agrek, “Bɨ Kɨb ak wög mɨdek cɨrop ag yokosɨp, apɨl nag wɨsɨbobɨr,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nɨb agɨl, kaj donki marɨp nɨbak nag wɨsɨbɨl, poŋ dapɨl Jisas mɨdek sɨŋak amjakɨl, walɨj kɨri bad ognap tɨg juɨl, dɨ kaj donki ar ak lɨl, Jisas nop dɨ kaj donki ar nɨb alaŋ lɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisas donki ar alaŋ bɨsɨg gɨl, majɨl ar ak amek nɨŋlɨg gɨ, bin bɨ okok walɨj tap kɨri ognap dap majɨl ar nɨbak lel nɨŋlɨg gɨ, kaj donki Jisas bɨsɨg mɨdek nɨbak walɨj tap kɨri ar nɨbak taulɨg gɨ taulɨg gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am am Jerusalem ulep ulep gel nɨŋlɨg gɨ, Olip Dɨm majɨl tam kɨyan gep kau sɨŋak, bin bɨ ne okok koŋai yɨb nep, magɨlsek nop mɨñ mɨñ yɨb gɨlɨg gɨ, Jisas tap tari tari gak okok gos ak nɨŋlɨg gɨ, sɨk kɨb aglɨg gɨ, God yɨb ne dap ranɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Bɨ Kɨb ne Kiŋ cɨnop ag yokek apeb aul, God nop dɨ tep gɨnɨmɨŋ! God karɨp lɨm seb kab ar alaŋ sɨŋak, cɨbur sain sain won ak nep mɨdeb. God ne ar i oklaŋ mɨdɨl, ne melɨk tep aknɨb ke sek mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nɨb agel nɨŋlɨg gɨ, bɨ Perisi ognap nab nɨb sɨŋak mɨdelak okok, Jisas nop aglak, “Mɨnɨm ag ñeb bɨ. Bin bɨ nak okok kɨrop ag gek, nɨg aknɨb rek ma aglaŋ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Agelak, Jisas pen agak, “Nɨbep agebin, kɨri mɨnɨm nɨbak rek ma agenɨgal ak, kab okok ke sɨk agnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jerusalem ulep ulep gɨlɨg gɨ, taun kɨb nɨbak nɨŋɨl, udɨn ñɨg pɨg gɨ rɨk yapek nɨŋlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Karɨp lɨm Jerusalem aul, nɨbep yɨmɨg yɨb nɨŋebin. Yad nɨbep dɨ God eip jɨm ñɨl, cɨbur sain sain magɨl ak nɨbep ñɨnɨg onek ak nɨpkep ak, tep yɨb gɨpkop. Pen mɨñi nɨbi ma nɨŋɨl, udɨn kwoi rek mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kɨsen bɨ kaual maual nɨbi apɨl, taun kɨb nɨbi aul, ulɨŋɨn lɨl kɨs kɨs gɨ mɨdɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","apɨl gɨ tɨmel yɨb gel, wög wari, karɨp okok magɨlsek, kab alap kab alap ar alaŋ kosɨgɨl ma mɨdenɨgab; bin bɨ, ñɨ pai, kab wari mɨgan nab eyaŋ mɨdenɨgal okok, karɨp sek pag jɨsɨpɨk masɨpɨk gɨ yoknɨgal. God nɨbep dɨnɨg owɨp ñɨn aul ma nɨpɨm ak me, nɨg gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas nɨb agɨl, God sobok gep karɨp ak amɨl, bin bɨ sɨkim gelak okok kɨrop ag söŋ yoklɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“God Mɨnɨm ak ñu kɨl tɨkɨl aglak, ‘Karɨp yad ak, yɨp sobok gep karɨp mɨdenɨgab,’ aglak ak pen nɨbi sɨkim gɨ gem gem, bin bɨ tap si dɨl dap we gɨl kɨnbal karɨp alap rek lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pen Jisas ne per per, ñɨn nokɨm nokɨm amɨl God sobok gep karɨp ñɨlɨk mɨgan ak, bin bɨ okok kɨrop mɨnɨm ag ñolɨgɨp. Bɨ God nop tap sobok gep bɨ kɨb okok, bɨ lo mɨnɨm ag ñeb bɨ okok, bɨ mɨnɨm tɨg bɨlokep okok, nop ñag pak lɨn, agɨl, gos nokɨm ak nɨŋelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nɨg gos nɨŋlak ak pen bin bɨ magɨlsek, mɨnɨm tep ne nɨŋɨn, agɨl, nop mɨñ mɨñ gel nɨŋlɨg gɨ, kɨri Jisas nop ñag pak lɨnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pen ñɨn nab nɨb sɨŋak, Jisas ne God sobok gep karɨp ñɨlɨk mɨgan ak amɨl, ne bin bɨ dɨ God eip jɨm ñɨl lɨnɨgab mɨnɨm tep ak bin bɨ okok kɨrop ag ñɨ mɨdek nɨŋlɨg gɨ, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe olak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Apɨl nop aglak, “Bɨ an nep agek, nak apɨl nɨg gɨ ajeban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Agelak agak, “Yad nɨbep pen ag nɨŋeb alap ag nɨŋnɨg gebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon bin bɨ okok kɨrop ñɨg pak ñek ak, God nop agek nɨg gek aka gos ne ke nɨŋɨl gek?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Agek, kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, “‘God agek Jon bin bɨ okok kɨrop ñɨg pak ñak,’ agenɨgabɨn ak, ne agnɨgab, ‘Nɨb ak, mɨnɨm ne ak tari gɨnɨg ma dɨpɨm?’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pen, ‘Jon gos ne ke nep nɨŋɨl bin bɨ okok kɨrop ñɨg pak ñak,’ agenɨgabɨn ak, bin bɨ sɨŋ aul, God ne Jon mɨnɨm agep bɨ ne ag lek apɨl gek, agɨl gos nɨpal rek, kɨri kal juɨl cɨnop kab ju pak lɨnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pen kɨri gos nɨbak nɨŋɨl, Jisas nop pen aglak, “Jon apɨl bin bɨ okok kɨrop mɨnɨm ag ñɨl, ñɨg pak ñɨl gak ak, cɨn ma nɨpɨn, God agek gak aka gos ne ke gak ak ma nɨpɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɨb agelak, Jisas kɨrop agak, “Nɨbi yɨp pen ma ag ñɨbɨm rek, yad pen an agek apɨl gebin ak, nɨbep ak rek nep ma ag ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas bin bɨ okok kɨrop mɨnɨm sɨd tɨkɨl agak, “Bɨ alap wain wög dai alap gɨ yɨmɨl, bin bɨ ognap ag lɨl, am karɨp lɨm par okok mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pen wain magɨl pok gɨnɨgab ñɨn ak, bɨ ne alap ag yokɨl agnɨgab, ‘Am bin bɨ wain wög gɨ mɨdebal okok kɨrop agek, wain magɨl yɨp ognap ñel dowan,’ agnɨgab. Agek, ne amjakek, bin bɨ wain wög gɨ mɨdenɨgal okok nop pak pak lɨl, yokop ag yokel adɨk gɨ onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɨg gel, bɨ wain wög nap nɨb ak, bɨ alap pen ag yokek amnɨgab. Amenɨgab nop ak rek nep pak pak lɨl, yokop ag yokel adɨk gɨ onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nɨg gel, bɨ kɨsen nɨb alap ag yokek amjakek, nop tapɨn magɨl pakɨl, lɨp gɨ dam söŋ sɨŋak eyaŋ yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nɨg gel, bɨ wög dai nap nɨb ak agnɨgab, ‘Yad ti gɨnɨm? Ñɨ mɨdmagɨl yad ak ag yokenɨgain ak, mɨnɨm ne agnɨgab rek nɨŋnɨmel rek lɨp,’ agɨl ag yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ag yokek amjakek, bin bɨ wain wög gɨ mɨdenɨgal nɨb okok agnɨgal, ‘Ñɨ apeb aul, nap wain wög ak ne dɨnɨmɨŋ rek lɨp. Nop pɨs nep ñag pak lɨl, cɨn dɨn,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nɨb agɨl, nop lɨp lɨp gɨ dam söŋ okok amɨl, pɨs nep ñag pak lel kɨmnɨgab. “Pen nɨg genɨgal ak, bɨ wain wög dai nap nɨb ak kɨrop tari gɨnɨgab? ");
INSERT INTO kmh_m_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne apɨl, bin bɨ nɨb okok kɨrop ñag pak lɨl, wain wög dai nɨbak bin bɨ ognap kɨrop pen agek kod mɨdenɨgal,” agak. Jisas nɨb agek, bin bɨ nɨŋ mɨdelak okok aglak, “Ageban nɨbak rek ma gɨnɨmɨŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Agelak, Jisas kɨrop nɨŋ kɨs kɨs gɨlɨg gɨ agak, “Nɨb agebɨm ak pen nɨb ak, God Mɨnɨm ñu kɨl tɨklak dai alap tɨk nɨŋɨl wagɨn ak yɨp ag ñɨnɨmɨb. Dai agebin nɨbak nɨg gɨl mɨdeb, ‘Bɨ karɨp gep okok, kab alap tep ma gɨp, agɨl, kɨrɨg gɨlak kab nɨbak nep mɨñi karɨp sap nab eyaŋ ak pɨŋɨl ñɨl mɨdeb,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Bin bɨ an an ap yap kab ar nɨbak paknɨgal okok, kɨrop pɨs nep pag jɨsɨpɨk masɨpɨk gɨ lɨnɨgab. Pen kab nɨbak pa ju ap yap bin bɨ pak tɨbɨknɨgab ak, kɨrop pɨs nep pak cɨb ma cɨb jak lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas nɨb agek, cɨnop nep ageb, agɨl, bɨ lo mɨnɨm ag ñeb bɨ okok abe, bɨ God nop tap sobok gep bɨ kɨb okok abe, mɨñi nep nop mɨnɨm kɨb agɨn, agɨl nɨŋlak ak, pen bin bɨ koŋai nep nɨŋ mɨdelak okok nɨŋɨl, pɨrɨkɨl kɨrɨg gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pen Jisas nop titi gɨl dam mɨnɨm kɨb agnɨg amnɨn, agɨl, am bin bɨ ognap kɨrop mɨmɨg gɨl aglak, “Nɨbi bin bɨ tep rek ulek lɨl, am mɨnɨm tom tom pagɨl, nop mɨnɨm ognap agem, ne pen mɨnɨm tari agonɨmɨŋ nɨŋɨl, nop dam gapman bɨ mɨnɨm kɨb dɨ bɨlokep ak dad amnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nɨb agel, bɨ okok kɨri amɨl Jisas nop mɨnɨm ognap tom pagɨl aglak, “Mɨnɨm ag ñeb bɨ, cɨn nɨpɨn nak pɨs kɨd alap nep ma amban; yɨpɨd gɨl nep apan. God Mɨnɨm ak bin bɨ okok kɨrop ag ñɨban ak, ak rek nep yɨpɨd gɨl nep apan. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nɨb ak, cɨn tari gɨn? Rom gapman bɨ kɨb Sisa nop takɨs ñɨn aka mer?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kɨri mɨnɨm tom pagɨl aglak nɨbak nɨŋɨl, Jisas kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mani takɨs ñɨbal nɨbak alap yɨp dɨ yomem nɨŋin,” agak. Agek, dɨ yomelak, nɨŋɨl agak, “Mani bak ak, kaunan an rek mɨdeb? Yɨb ñu kɨl tɨklak nɨbak, an yɨb rek mɨdeb?” agak. Agek aglak, “Sisa kaunan ne ak mɨdɨl, yɨb ne ak nep mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Agelak, Jisas kɨrop agak, “Nɨb ak, Sisa tap ne mɨdonɨmɨŋ, Sisa nop ñɨnɨmɨb. God tap ne mɨdonɨmɨŋ, God nop ñɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas ne bin bɨ mɨdelak nab nɨb sɨŋak nɨb agek, mɨnɨm ne tɨb junɨmel rek ma lek, gos par nɨŋɨl mɨnɨm alap ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bin bɨ Sadyusi okok, bin bɨ kɨmɨl ma warɨknɨgal, agɨl, gos ak nɨpal. Pen Sadyusi bɨ ognap Jisas mɨdek sɨŋak apɨl, nop ag nɨŋeb alap ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ag nɨŋɨl aglak, “Mɨnɨm ag ñeb bɨ. Mosɨs mɨnɨm alap cɨnop ñu kɨl tɨkɨl agak, ‘Bɨ alap bin dɨl, ñɨ pai tɨk dapɨl mer, yokop kɨmnɨgab ak, nɨmam ne alap pen bin nɨbak dɨl, ñɨ pai ne ak, agɨl, tɨk donɨmɨŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nɨb ak, bɨ wagɨn sek aknɨb ar oŋɨd okok mɨdenɨgal. Nɨmam ned ak bin dɨl, ñɨ pai tɨk dapɨl mer, yokop kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kɨmek, nɨmam yɨgwu nab nɨb ak pen bin nɨbak dɨl, ak rek nep ñɨ pai tɨk dapɨl mer, yokop kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nɨg gek, nɨmam yɨgwu nokɨm nɨb ak pen bin nɨbak dɨl, ak rek nep ñɨ pai tɨk dapɨl mer, yokop kɨmnɨgab. Nɨg gɨ dam dam, nɨmam aknɨb ar oŋɨd magɨlsek ñɨ pai tɨk dapɨl mer, yokop kɨmnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kɨsen bin nɨbak ak rek nep kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pen kɨmɨl warɨknɨgal apan ak, bin nokɨm nɨbak bɨ ne aknɨb dɨ ar oŋɨd lɨnɨgab ak, kɨsen bɨ an bine mɨdenɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Agelak, Jisas kɨrop pen agak, “Mɨñi mɨdobɨn ñɨn aul, bin okok bɨ dɨpal, bɨ okok bin dɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pen bin bɨ God gek warɨkɨl, karɨp ne seb kab ar alaŋ sɨŋak amnɨgal okok, bin okok bɨ ma dɨnɨgal, bɨ okok bin ma dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pen kɨri kauyaŋ ma kɨmnɨgal; ejol okok rek per per nep komɨŋ mɨdenɨgal. Kɨri warɨknɨgal ak me, God ñɨ pai ne mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bin bɨ kɨmɨl warɨkpal mɨnɨm ak, Mosɨs ak rek nep mab yɨnek kesɨm ak agɨl ñu kɨl tɨkak. Mosɨs mɨnɨm nɨbak ñu kɨl tɨkɨl agak, ‘Bɨ Kɨb ne Ebraham, Aisak, Jekop, God kɨri mɨdeb,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bin bɨ ned kɨmlak okok, ‘God kɨri mɨdeb,’ agak rek, cɨn nɨpɨn, bin bɨ ned kɨmlak okok mɨñi komɨŋ mɨdebal. God nɨŋeb, bin bɨ ne magɨlsek komɨŋ mɨdebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisas nɨb agek, bɨ lo mɨnɨm ag ñeb bɨ ognap aglak, “Mɨnɨm ag ñeb bɨ, mɨnɨm yɨpɨd gɨl nep agesan!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mɨnɨm ag tep gak nɨbak nɨŋɨl, pɨrɨkɨl, kɨsen mɨnɨm ognap nop ma ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pen Jisas kɨrop agak, “Bin bɨ okok tari gɨnɨg, Mesaia ak Depid ñɨ ne ak nep mɨdeb, apal? ");
INSERT INTO kmh_m_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Depid ne ke God Mɨnɨm dai Sam alap ñu kɨl tɨkɨl agak, ‘Bɨ Kɨb ne Bɨ Kɨb yad nop agak, “Nak ñɨnmagɨl yɨpɨd ken kɨd yad bɨsɨg mɨdenɨmɨn; ");
INSERT INTO kmh_m_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mɨd damɨl yad kaual maual nak okok kɨrop gen, tob mok nak okok kɨrop tob tau rɨbɨknɨgan,” ’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pen Depid ne Mesaia ak nop, ‘Bɨ Kɨb yad,’ agak rek, tari gɨnɨg, Mesaia ak Depid ñɨ ne ak nep mɨdeb, apal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bin bɨ okok nɨŋ mɨdel nɨŋlɨg gɨ, Jisas bɨ ne okok kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nɨbi lo mɨnɨm ag ñeb bɨ okok gɨpal rek gɨnɨmɨb rek lɨp ak, nɨŋ tep gɨnɨmɨb. Kɨri gɨpal ar ak, cɨn okok gɨ ajon, bin bɨ okok cɨnop bɨ kɨb ag gos nɨŋlaŋ, agɨl, walɨj par tol gɨl, bin bɨ okok eip mogɨm gel, bin bɨ okok kɨrop nɨŋɨl, ‘Bɨ kɨb apebɨm e!’ agenɨgal ak, mɨñ mɨñ gɨnɨgal; Juda mogɨm gep karɨp okok amɨl, bɨ kɨb bɨsɨgpal sea ar ak nep bɨsɨgnɨgal; pen tap kɨb ñɨŋnɨgal ñɨn ak, am bɨ kɨb bɨsɨgpal kau ak nep bɨsɨgnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɨ lo mɨnɨm ag ñeb bɨ okok, bin kaŋɨl karɨp tap kɨri okok si dɨl, God nop sobok gɨnɨgabɨn ak, bin bɨ nɨŋlaŋ, agɨl, mɨnɨm par kɨb tom tom ar ognap apal. Nɨg gɨpal ak, kɨsen yur kɨb ke yɨb dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas God sobok gep karɨp ñɨlɨk mɨgan am mɨdɨl nɨŋak, bin bɨ mani sek okok mani ognap dap mab kɨnaŋ mɨgan ak yokelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pen bin yadu yɨm gep rek eñap kab magɨl lakañ sɨkol magɨl omal dap yokak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nɨg gek Jisas nɨŋɨl agak, “Yad nɨŋɨd agebin, bin bɨ ognap mani sɨkol dap yokebal; pen bin yadu yɨm gep rek aul mani ne kɨb yɨb dap yokɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pen bin bɨ ognap mani kɨri koŋai nep mɨdek nɨŋlɨg gɨ mani yokebal; pen bin yadu yɨm gep rek aul mani ne mɨdeb rek magɨlsek yokɨp. Tap tau ñɨŋeb mani alap ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pen bɨ ne ognap aglak, “God sobok gep karɨp aul kab tep tep, tap tep tep dap God nop ñɨl tɨb kadɨg ñɨlak ak, tep yɨb mɨdeb,” aglak. Nɨb agelak, Jisas kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nɨb agebɨm ak pen kɨsen tap tep nɨŋebɨm nɨb okok ma mɨdenɨgab. Magɨlsek tɨg wal gɨ yokel, kab alap kab alap ar alaŋ ma mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Agek, nop ag nɨŋɨl aglak, “Mɨnɨm ag ñeb bɨ, tap nɨbak ñɨn akal rek nɨg gɨnɨgab? Pen tap tari rek gek nɨŋɨl, mɨñi gɨnɨg geb agnɨgabɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Agelak, Jisas kɨrop agak, “Nɨŋ tep gɨnɨmɨb! Bin bɨ koŋai nep apɨl tom pagɨl, yɨb yad ak dɨl agnɨgal, ‘Yad nep apebin. Ñɨn kɨb ak owɨp,’ agnɨgal. Nɨb agenɨgal ak, nɨŋɨd agebal agɨl, kɨrop kɨsen ma gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pen karɨp lɨm mɨgan ognap warɨkɨl, karɨp lɨm mɨgan ognap eip pen pen gɨnɨgal. Karɨp lɨm mɨgan ognap kɨri ke nep pen pen gɨnɨgal. Nɨg genɨgal ak nɨŋɨl, ñɨn kɨb apal ak onɨg geb nɨŋɨl nɨg gebal agɨl, ma pɨrɨknɨmɨb. Ñɨn kɨb nɨbak kɨsen onɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nɨb agɨl kɨrop agak, “Karɨp lɨm mɨgan ognap warɨkɨl, karɨp lɨm mɨgan ognap eip pen pen gɨnɨgal. Kiŋ ognap yakam kɨri warɨkɨl, kiŋ ognap yakam kɨri eip pen pen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Karɨp lɨm okok koŋai nep monmon kɨb yɨb dɨl, yuan kɨb gɨl, mɨñak kɨb yɨb gɨl gɨnɨgab. Tap seb kab ar alaŋ sɨŋak ke kɨsen nɨb lɨl, tap aknɨb ke pɨrɨkep rek ar alaŋ sɨŋak lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tap nɨb okok kɨsen nɨg gɨnɨgab pen ned yad jɨm ñɨl eip mɨdobɨm rek, nɨbep gɨ tɨmel gɨnɨgal. Nɨbep mɨnɨm kɨb agnɨg, dam Juda mogɨm gep karɨp okok amɨl, mɨnɨm kɨb agɨl, nɨbep mɨñ lɨl, dam kiŋ gapman bɨ kɨb okok dad amnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nɨbep gɨnɨgal nɨbak, mɨnɨm tep yad ak kɨrop mɨseŋ ag ñɨnɨmɨb rek lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pen nɨbep mɨnɨm kɨb agenɨmel ak, mɨnɨm tari rek pen agɨn, agɨl, ned ma pɨyo nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yad ke nɨbep gos tep ñɨl mɨnɨm magɨl ñen, nɨbi mɨnɨm nɨbak nep ag ñem, kɨri pen agɨl dɨ yokep rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pen nanɨm nap, namam sɨkop, bɨ tɨdɨg nɨŋeb, bɨ nɨŋeb kɨri ke ognap nɨbep mɨmɨg nɨŋɨl, dɨ kaual maual ñɨnmagɨl ar lel, nɨbep ognap pɨs nep ñag pak lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yɨp nɨŋ dɨpɨm rek, bin bɨ okok magɨlsek nɨbep mɨlɨk kal nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pen nabɨc kɨmkas nɨbi nokɨm alap ma kɨr gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pen yɨp cɨg dɨ kɨlɨs gɨl mɨdenɨgabɨm ak, nɨbi komɨŋ mɨdep magɨl ak dɨl, per per nep mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pen ami bɨ okok apɨl, Jerusalem bɨnem yokɨl kɨs kɨs gɨnɨgal ñɨn ak, mɨñi ulep mɨdeb Jerusalem gɨ tɨmel gɨnɨgal, agɨl nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bin bɨ karɨp lɨm Judia mɨdenɨmel okok, pɨrɨk gɨ dɨm gol okok amnɨmel. Bin bɨ Jerusalem mɨdenɨmel okok, pɨrɨk gɨ mɨs ken ar amnɨmel. Pen bin bɨ mɨs ken ar mɨdenɨmel okok, Jerusalem wari mɨgan ma amnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tari gɨnɨg: ñɨn nɨbak me, kɨri God nop kɨrɨg gɨpal rek, God mɨnɨm agep bɨ okok magɨlsek God Mɨnɨm ñu kɨl tɨkɨl aglak rek nep gɨnɨgab nɨŋɨl kɨri pen yur kɨb dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pen ñɨn nɨbak, bin ñɨ kogi mɨdenɨgal okok abe, bin ñɨ paiŋaŋ ci ñenɨgal okok abe, kɨrop mɨker kɨb yɨb gɨnɨgab. God Juda bin bɨ kɨrop mɨker kɨb yɨb gɨnɨm, agɨl, bin bɨ karɨp lɨm nɨbaul mɨdebal kɨrop gɨ tɨmel yɨb gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɨ par okok nɨb apɨl, bin bɨ ognap kɨrop tu par kɨd dɨl tɨb lɨnɨgal, bin bɨ ognap kɨrop nag lɨl dam karɨp lɨm ke tɨgoŋ tɨgoŋ magɨlsek dad amnɨgal. Pen Juda bin bɨ mer okok apɨl, Jerusalem gɨ tɨmel gel gel, God ñɨn ne agak ak ap padɨkek, kɨrɨg gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Pen kɨsen, pɨb takɨn gap tap ke alap mɨseŋ lɨl, ñɨg si pag apɨl gu kɨb genɨgab. Pen karɨp lɨm wagɨn aul bin bɨ karɨp lɨm tɨgoŋ tɨgoŋ magɨlsek gos par nɨŋɨl, tari geb, agɨl, gos par lɨl pɨrɨknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tap seb kab ar alaŋ mɨdeb tap okok, adaŋ nɨb aul nɨb gek, lɨm dai aul tari gɨnɨg geb, agɨl, pɨrɨkɨl, gos magɨl tɨke apek kɨmeb rek lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nɨg gɨnɨgab ñɨn ak, Bɨ Ñɨ ne kɨmi nab sɨŋak apek nɨŋlɨg gɨ, bin bɨ kɨri kɨlɨs ne ak abe, melɨk tep aknɨb ke yɨb ne ak abe nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tap agebin aul genɨgab ak, Bɨ Kɨb cɨnop dɨ komɨŋ yoknɨgab ñɨn ak ulep mɨdeb, agɨl, udɨn kɨlan gɨl salmol gɨ nɨŋlɨg gɨ mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas nɨb agɨl, kɨrop mɨnɨm sɨd tɨkɨl agak, “Mab kanɨŋaj abe, mab ognap abe, ");
INSERT INTO kmh_m_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","sɨlɨp lek, mɨñi pɨb lɨnɨg gɨ geb, agɨl, nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nɨb ak rek, tap agebin okok gek, God bin bɨ dɨl kod mɨdenɨgab ñɨn ak ulep apeb, agɨl nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yad nɨbep nɨŋɨd agebin, bin bɨ mɨñi mɨdebal sɨŋ aul magɨlsek ma kɨmnɨgal; ognap komɨŋ mɨdel nɨŋlɨg gɨ, tap agebin aul magɨlsek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Seb kab ar alaŋ abe, lɨm dai wagɨn aul abe kɨr gɨnɨgab, pen mɨnɨm magɨl yad okok ma kɨr gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pen nɨŋ tep gɨnɨmɨb. Nɨbi ñɨg wain ñɨg kɨlɨs koŋai ñɨbɨl saköl lɨl, tap lɨm dai ar wagɨn aul nep gos nɨŋ mɨdenɨgabɨm ñɨn nɨbak nep, yakɨr kaj kɨmɨn kobri gon lel, kasek nep dɨp rek ak gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sɨŋ aul nep ma gɨnɨgab; bin bɨ karɨp lɨm wagɨn kɨgɨn yɨm ñak okok magɨlsek mɨdebal mɨdebal rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nɨb ak, nɨbi per per nɨŋ tep gɨnɨmɨb, God nop sobok gɨlɨg gɨ nep mɨdlɨg gɨ agnɨmɨb, ‘Tap nɨb okok cɨnop ñag pak ma lɨnɨmɨŋ; nak cɨnop kod mɨdek, komɨŋ amɨl, am Bɨ Ñɨ ne udɨn yɨrɨk ar ne ak mɨdojɨn,’ agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ñɨn sɨkol bad nɨbak, Jisas per am God sobok gep karɨp ñɨlɨk mɨgan ak am mɨdɨl, bin bɨ okok kɨrop mɨnɨm ag ñolɨgɨp. Pen kɨslɨm gek nɨŋlɨg gɨ, Jisas ne am karɨp lɨm alap Olip Dɨm apal ak kɨnolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bin bɨ okok magɨlsek, mɨnɨm nop ak nɨŋɨn, agɨl, kɨslɨm sek yɨb warɨkɨl, God sobok gep karɨp ak amelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Juda kai Bred Yɨs Sek Ma Ñɨŋeb ñɨn kɨb kɨri ak, Pasopa apal ñɨn kɨb kɨri ak, maŋ maŋ gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, Jisas nop ñag pak lɨn, aglak ak pen bin bɨ okok kɨrop pɨrɨkɨl, titi gɨl ñag pak lɨn, agɨl, ag nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ag nɨŋ mɨdel nɨŋlɨg gɨ, Seten ne apɨl, Judas yɨb ne alap Iskariot agölɨgɨpal bɨ nɨbak, nop yɨpɨl sɨkak. Bɨ nɨbak Jisas bɨ ne aknɨb umɨgan alaŋ okok bɨ alap. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yɨpɨl sɨkek, Judas ne am God nop tap sobok gep bɨ kɨb okok abe, God sobok gep karɨp kod mɨdelɨgɨpal polisman bɨ kɨb kɨri okok abe mɨdelak sɨŋak amɨl, Jisas nop titi gɨl mɨmɨg gɨ dam ñen nop ñag pak lɨlaŋ, agɨl, mɨnɨm nɨbak kɨrop eip ag nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Agek, kɨrop tep gek nɨŋlɨg gɨ aglak, “Nep mani ñɨnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Agelak, Judas ne, won akal rek Jisas bin bɨ okok eip ma mɨdenɨgab ak, nop mɨmɨg gɨ dam bɨ kɨb okok kɨrop ñɨnɨgain, agɨl, kod nɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pen Bred Yɨs Sek Ma Ñɨŋeb ñɨn nɨbak apek, Pasopa kaj sipsip ñɨlɨk pak sobok gep ñɨn mɨñi, agɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas ne Pita eip Jon eip kɨrop mal ag yokɨl agak, “Nɨri mal am Pasopa tap ñɨŋnɨgabɨn ak gɨ lɨ tep gɨnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Agek agrek, “Akal nɨg gɨr?” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Agerek, Jisas agak, “Nɨri mal taun kɨb ak amɨl nɨŋnɨgair, bɨ alap ñɨg mɨl dapenɨgab. Nop nabɨŋ pakɨl, amonɨmɨŋ karɨp ak amɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","bɨ karɨp nap nɨb nɨbak nop agnɨmir, ‘Mɨnɨm Ag Ñeb Bɨ nep ag nɨŋɨp, “Karɨp ñɨlɨk mɨgan akal bɨ yad okok eip Pasopa tap ñɨŋnɨgabɨn?” agɨp,’ agnɨmir. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nɨb agenɨgair, nɨrep mal dam karɨp ñɨlɨk mɨgan kɨb tebol tap okok sek mɨdenɨgab ar alaŋ ak agenɨgab ak, Pasopa tap ñɨŋnɨgabɨn okok ñɨlɨk mɨgan nɨbak gɨ jɨn gɨnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Agek amɨl nɨŋrek, agak agak rek nep mɨdek. Nɨb ak, Pasopa tap ñɨŋnɨg gɨlak okok gɨ lɨ tep gɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pen karɨp dɨgep magɨl ak tap ñɨŋnɨg gɨl, bɨ mɨnɨm ne dad ameb okok eip tebol ak bɨsɨg kɨs kɨs gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kɨrop agak, “Gos yad per nɨpin ak, nɨbep eip Pasopa tap ñɨŋnɨg gobɨn aul ñɨbɨl me, kɨsen yur kɨb dɨnɨm, agɨl, gos ak nɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pen yad nɨbep agebin, Pasopa tap ak kɨsen kauyaŋ ma ñɨŋnɨgain; kɨsen Pasopa kaj sipsip ñɨlɨk per pak ñɨbɨn wagɨn nɨbak mɨseŋ lɨnɨgab nɨŋɨl God bin bɨ ne dɨl kod mɨdenɨgab ñɨn ak nep tap kɨb ñɨŋnɨgabɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisas nɨb agɨl, ñɨg wain kap dɨl, God nop tep agɨl, bɨ ne okok kɨrop ñɨlɨg gɨ agak, “Ñɨg ñebin aul nɨbi ke dɨ ñɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pen nɨbep agebin, mɨñi ñɨn aul tɨkek, ñɨg wain kauyaŋ ma ñɨŋnɨgain; God bin bɨ ne dɨl kod mɨdenɨgab ñɨn ak nep ñɨg wain kauyaŋ ñɨŋnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nɨb agɨl, bred alap dɨl, God nop tep agɨl, tɨ paŋɨl kɨrop ñɨlɨg gɨ agak, “Mɨb goŋ yad aul nɨbep ñebin. Nɨbi kɨsen nɨg aknɨb rek nep gɨl, yɨp gos nɨŋlɨg gɨ mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kɨri tap ñɨb sakɨl, Jisas ñɨg wain kap ak dɨl, kɨrop ñɨlɨg gɨ agak, “Lakañ yad soŋ gɨ yapek kɨmen me, God nɨbep, bin bɨ yad, agɨl, dɨnɨgain agak mɨnɨm ar ak am kɨlɨs gɨnɨgab ak me, nɨbep ñɨg wain aul ñebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pen bɨ yɨp kain gɨ dad amnɨgab ak eip bɨsɨg mɨdobɨn. Ñɨnmagɨl yad tebol ar aul mɨdeb ñɨnmagɨl ne abe ar aul mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bɨ Ñɨ ne, God bɨrarɨk nep agak mɨñ ar ak nep kɨsen gɨl kɨmnɨgab ak pen bɨ nop kain gɨ dam amnɨgab ak nop yɨmɨg nɨŋebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jisas nɨb agek, bɨ ne okok kɨri ke nep, an rek nɨg gɨnɨgab, agɨl, pen pen ag nɨŋlɨg gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisas bɨ ne okok, nɨbi mer, yad nep bɨ kɨb mɨdebin, agɨl, kɨri ke nep pen pen agelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nɨb agelak, Jisas kɨrop agak, “Kiŋ okok Juda bin bɨ mer okok kɨlɨs gɨl kod mɨdlɨg gɨ apal, ‘Kɨrop dɨ tep yɨb gɨpɨn,’ apal. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pen nɨbi aknɨb rek ma gɨnɨmɨb. Bɨ kɨb nɨbi okok, ñɨ praj rek mɨdenɨmel; bɨ kɨb yɨb okok, bɨ wög gɨ ñeb rek mɨdenɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lɨm dai ar wagɨn aul gɨpal nag ar ak, bɨ kɨb am bɨsɨgel, bɨ wög gɨ ñeb okok tap magɨl tap kɨrop okok pɨɫak pɨɫak gɨpal. Pen yad nab nɨbep bɨ wög gɨ ñeb rek nep mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yɨp mɨker yɨb golɨgɨp ak nɨŋɨl yɨp ma kɨrɨg gɨpɨm; yɨp kod mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɨg gɨpɨm ak, God yɨp agɨp, ‘Nak Kiŋ mɨdɨl, bin bɨ okok kɨrop kod mɨdenɨgan,’ agɨp rek, yad pen ak rek nep nɨbep agebin, nɨbi kiŋ rek mɨdɨl bin bɨ okok kɨrop kod mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ñɨn nɨbak nɨbi karɨp lɨm yad ak amɨl, yad eip bɨsɨgɨl tap magɨl ñɨbɨl, ñɨg ñɨbɨl, gɨnɨgabɨm; nɨbi kiŋ bɨsɨgpal sea ar ak bɨsɨgɨl, Isrel wagɨn ke ke aknɨb umɨgan alaŋ kɨrop mɨnɨm kɨb nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas ne Pita nop agak, “Saimon, Saimon, nɨŋan. God ne Seten nop yau agek, nɨbep bɨ, wid magɨl soŋ gel soŋ gel, magɨl yɨb ak ke lɨl, dai dai ak ke lɨl gɨpal rek ak gɨl, nɨbi gɨ tɨmel gɨnɨgabɨm aka mer agɨl gɨ nɨŋnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pen yad God nop sobok gɨpin rek, yɨp pɨs nep ma kɨrɨg gɨnɨgan. Pen tap si tap tɨmel gɨnɨgan ak, tari gɨnɨg nɨg gɨpin, agɨl, yɨp kauyaŋ adɨk gɨ onɨgan. Pen nɨg gɨl, kɨsen apɨl namɨd namam nak ognap kɨrop mɨnɨm ag ñɨ tep gek, kɨri kɨlɨs gɨl yɨp kɨsen gɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jisas nɨb agek Pita agak, “Bɨ Kɨb, yad nep ma kɨrɨg gɨnɨgain. Omalgɨl nep ajonɨgabɨr. Nep mɨñ lɨl, yɨp abe mɨñ lɨnɨmel. Pen nep ñag pak lɨl, yɨp abe ñag pak lɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Agek, Jisas agak, “Pita, yad nep agebin, mɨñi kɨslɨm eyaŋ kɨlokɨl sɨk ma agnɨgab won ak, Jisas nop ma nɨpin, agɨl, yɨj omal nokɨm wai ñɨnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas nɨb agɨl kɨrop agak, “Ned nɨbep ag yokɨl agnek, ‘Mani tin, wad, tob tɨrɨp okok dɨl ma dad amnɨmɨb; yokop amnɨmɨb,’ agnek. Agnek ambek ñɨn nɨbak, tap nɨbi ognap mɨdek aka ma mɨdek?” agak. Agek aglak, “Mer, tap cɨn ulep ma gak; mɨdek,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Agelak, Jisas agak, “Pen mɨñi nɨbi mani tin, wad mɨdonɨmɨŋ ak, sek dad amnɨmɨb. Bɨ an tu par kɨd ma mɨdonɨmɨŋ ak, kolsior ne ak bɨ ognap kɨrop sɨkim gɨl mani dɨl tu par kɨd alap tauaŋ. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pen nɨŋɨm! Ned God mɨnɨm agep bɨ Aisaia God Mɨnɨm dai alap ñu kɨl tɨkɨl agak, ‘ “Ne bɨ tap si tap tɨmel gep bɨ alap,” agnɨgal,’ agak. Agak nɨbak yɨp nep agak. Mɨnɨm agɨl ñu kɨl tɨkak nɨbak mɨñi gɨnɨg geb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jisas nɨb agek, kɨri aglak, “Bɨ Kɨb, tu par kɨd cɨn omal mɨdeb,” aglak. Agelak agak, “Ak nɨg ma agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas Jerusalem söŋ amɨl, per Nap nop sobok golɨgɨp Olip Dɨm sɨŋak amnak; bɨ ne okok kɨsen gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Karɨp lɨm nɨbak amjakɨl kɨrop agak, “Gos tɨmel apek gɨ tɨmel gɨnɨmɨb rek lɨp ak, God nop sobok gɨlɨg gɨ mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nɨb agɨl, kɨrop kɨrɨg gɨl, ne ke ke sɨŋak amɨl, kogɨm yɨmɨl God nop sobok gɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapi, gos yad nɨpin ak ñɨg sɨlek kap yɨp ñɨnɨg geban ak ma ñɨnɨmɨn. Pen yad gos nɨpin ar ak ma gɨnɨmɨn; gos nak ke nɨpan ar ak nep gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jisas nɨb agek, ejol alap seb kab ar alaŋ sɨŋak nɨb apɨl nop kɨlɨs ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nop mɨker yɨb gek, Jisas ne Nap nop kɨlɨs yɨb gɨl sobok gɨlɨg gɨ mɨdek nɨŋlɨg gɨ, wɨsɨb ak lakañ rek pɨg gɨ rɨkɨl wagɨn eyaŋ yowak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nap nop sobok gɨ mɨd juɨl amɨl nɨŋak, bɨ ne okok mɨker gɨ dap yapek nɨŋlɨg gɨ, wɨsɨn kɨnelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nɨg gelak ak nɨŋɨl kɨrop agak, “Tari gɨnɨg wɨsɨn kɨnebɨm? Seten ne gos ñek nɨbi gɨ tɨmel gɨnɨmɨb rek lɨp ak, warɨkɨl, sobok gɨlɨg gɨ mɨdem,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas mɨnɨm nɨbak ag mɨdek nɨŋlɨg gɨ, bɨ ne Judas bɨ ñon kɨb alap poŋ dɨl dad apjakɨl, Jisas nop dɨ bom sɨloknɨg gek. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nɨg gek, Jisas nop agak, “Judas, ‘Bɨ me aul nop ñag pak lɨm,’ agɨl, yɨp Bɨ Ñɨ ne dɨ bom sɨloknɨg geban ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nɨb agek nɨŋlɨg gɨ, bɨ ne okok tap tari gɨnɨg gelak nɨbak nɨŋɨl aglak, “Bɨ Kɨb, cɨn kɨrop tu par kɨd dɨl tɨbɨn aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nɨb aglɨg gɨ, bɨ alap tu par kɨd ne ak dɨl, bɨ God nop tap sobok gep bɨ kɨb yɨb bɨ wög gɨ ñeb ne ak, nop tɨmɨd yɨpɨd kɨd pɨs nep tɨb gɨ rɨk yokak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nɨg gek, Jisas nɨŋɨl agak, “Nɨg ma gɨm! Me tep,” agak. Nɨb agɨl, tɨmɨd ak dɨ nɨŋek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pen God nop tap sobok gep bɨ kɨb okok abe, God sobok gep karɨp kod mɨdelɨgɨpal polisman bɨ kɨb kɨri okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, ap nop dɨnɨg gelak okok, kɨrop agak, “Nɨbi tu par kɨd dɨl, yɨr pakep dɨl dopɨm ak, yɨp bɨ pen pen ñagep bɨ alap rek ag gos nɨŋɨl, dɨ cɨcɨ lɨnɨg opɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yad nɨbi eip per per God sobok gep karɨp ak mɨdenek yɨp ma dɨpek. Pen mɨñi Seten, bɨ kɨslɨm pɨs ken mɨdeb ak, ñɨn ne ak me, nɨg gebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas nɨb agek nɨŋlɨg gɨ, nop dɨ cɨcɨ lɨl, dam God nop tap sobok gep bɨ kɨb yɨb karɨp ak dad amnɨlak. Pita pen kɨsen kɨsen nɨŋlɨg amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Karɨp nɨbak amjakɨl, karɨp gol sɨŋak mab dagɨl bɨsɨg mɨdelak. Pita kɨsen amjakɨl kɨrop eip bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita eip bɨsɨg mɨdek nɨŋlɨg gɨ, pai karɨp nɨbak wög gɨ ñolɨgɨp alap nop nɨŋ dap ran dap yaplɨg gɨ agak, “Bɨ aul abe Jisas eip mɨdolɨgɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Agek, Pita agak, “Pai, bɨ nɨbak adi ma nɨpin!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nɨb agɨl, yokop sɨkol won alap mɨdek nɨŋlɨg gɨ, bɨ alap pen apɨl Pita nop nɨŋɨl agak, “Nak ak rek nep Jisas bɨ ne alap,” agak. Agek, Pita agak, “Bɨ aul, yad mer!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pen kɨsen sɨkol sɨkol magɨl alap aua nokɨm alap rek mɨdek, bɨ alap pen apɨl, kɨlɨs gɨl agak, “Nɨŋɨd agebin, bɨ aul Jisas eip mɨdolɨgɨp. Ne abe karɨp lɨm Galili nɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Agek, Pita agak, “Bɨ aul, mɨnɨm ageban ak adi ma nɨpin me!” agak. Nɨb agek nɨŋlɨg gɨ, dai kɨlokɨl sɨk agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nɨg gek, Jisas adɨk gɨl, Pita nop nɨŋ i sek lek, Pita pen Jisas, “Mɨñi kɨslɨm eyaŋ kɨlokɨl sɨk ma agnɨgab won ak, Jisas nop ma nɨpin, agɨl, yɨj omal nokɨm wai ñɨnɨgan,” agak mɨnɨm ak gos nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nɨg nɨŋɨl, kɨŋam mɨlep gek, molɨl pag apek, söŋ amɨl sɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɨ Jisas nop dɨ mɨdelak okok nop ag julɨg gɨ, paklɨg gɨ gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kɨri walɨj bad alap dɨ udɨn nop ak karɨk ñɨl, nop paklɨg gɨ aglak, “Nak bɨ ke nɨpan ak, nep an pakeb ak cɨnop ag ñan!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pen mɨnɨm tɨmel nɨbak rek, nop tapɨn koŋai nep aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kɨslɨm sek, Juda bɨ mɨnɨm tɨg bɨlokep okok lɨl, God nop tap sobok gep bɨ kɨb okok lɨl, bɨ lo mɨnɨm ag ñeb okok lɨl, ap mogɨm gel, Jisas nop poŋ dɨl Kansol kɨb nɨbak mɨdelak nab sɨŋak dad olak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pen Kansol bɨ okok kɨri Jisas nop aglak, “Pen nak ke agnɨmɨn, nak Mesaia ak aka mer,” aglak. Agelak, Jisas kɨrop agak, “Pen yad nɨbep agenɨgain ak, nɨŋɨd ageb, agɨl, ma nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pen ag nɨŋeb yad mɨdeb ak, nɨbep ag nɨŋenɨgain ak, yɨp pen ma ag ñɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pen mɨñi tɨkɨl mɨd damɨl kɨsen okok, Bɨ Ñɨ ne God Bɨ kɨlɨs aknɨb ke sek mɨdeb ak, ñɨnmagɨl yɨpɨd pɨs ar ne sɨŋak bɨsɨg mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nɨb agek, bɨ kansol okok magɨlsek nop aglak, “Nɨb ak, nak ke God Ñɨ ne ak aka?” aglak. Agelak, Jisas agak, “Me nɨbi ke agebɨm me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Agek aglak, “Tari gɨnɨg mɨnɨm kɨb tapɨn ag mɨdɨl, bɨ ognap ag nɨŋon, Jisas nɨg gɨp nɨg gɨp agenɨmel? Meg mɨgan ne ke agosɨp nɨpɨn ak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nɨb agɨl, magɨlsek warɨkɨl, Jisas nop dam gapman bɨ kɨb Pailot mɨdek sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Damɨl, nop mɨnɨm kɨb agnɨg, mɨnɨm okok nɨb okok nɨb dapɨl aglak, “Cɨn pɨyo nɨŋɨl nɨpɨn, bɨ nɨbaul bin bɨ cɨn okok mɨnɨm esek agɨl agɨp, ‘Bɨ kɨb Sisa nop takɨs ma ñɨnɨmɨb, gapman kai mɨnɨm ak, ak rek nep ma nɨŋnɨmɨb,’ agɨp. Pen mɨnɨm alap agɨp, ‘Yad ke Mesaia ak, yad ke kiŋ nɨbak,’ agɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Agelak, Pailot Jisas nop ag nɨŋɨl agak, “Nak Juda kai kiŋ kɨri ak aka?” agak. Agek, Jisas nop pen agak, “Me nak ke ageban me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Agek, Pailot pen bɨ God nop tap sobok gep bɨ kɨb okok abe, bin bɨ yokop ap mɨdelak okok abe kɨrop agak, “Yad nepin, bɨ aul nop mɨnɨm kɨb agep wagɨn alap ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nɨb agak ak pen kɨri mɨnɨm kɨlɨs agɨl aglak, “Gapman mɨnɨm ma nɨŋnɨmel, agɨl, mɨnɨm ag ñɨ ajɨl, Juda bin bɨ karɨp lɨm cɨn okok magɨlsek ag ñɨ ajolɨgɨp. Karɨp lɨm Galili tɨkɨl, ag ñɨ ajɨl dam dam mɨñi Jerusalem sɨŋaul owɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Agelak, Pailot kɨrop ag nɨŋɨl agak, “Bɨ nɨbaul Galili nɨb aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Agek, yau aglak. Pen kiŋ Herod karɨp lɨm Galili kod mɨdolɨgɨp ak, ñɨn nab ak apɨl Jerusalem mɨdek. Nɨb ak, Jisas ne Galili nɨb bɨ alap aglak ak nɨŋɨl, nop Herod ñɨnmagɨl ar ag yoken mɨnɨm kɨb aul nɨŋnɨmɨŋ, agɨl, Pailot kɨrop agek, Jisas nop dam Herod mɨdek sɨŋak dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod, Jisas tap tari tari golɨgɨp ak per mɨnɨm nep nɨŋɨl, ñɨn akal rek tap ma gep rek alap gek nɨŋnɨgain, agɨl, gos ak nep nɨŋ mɨdolɨgɨp rek, ñɨn nɨbak Jisas nop poŋɨd dɨ dapjakel, ne mɨñ mɨñ yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pen Herod ne Jisas nop mɨnɨm koŋai nep ag yɨgɨn wagɨn gak, pen Jisas mɨnɨm alap pen ma agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pen bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, mɨnɨm kɨlɨs agɨl, bɨ koŋai nep pedak pedak aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod abe, ami bɨ ne okok abe, Jisas nop gɨ tɨmel gɨlɨg gɨ, ñɨñɨloŋ lɨlɨg gɨ, gapman bɨ kɨb tol gɨpal walɨj tep alap tol gɨ ñɨl, kauyaŋ Pailot mɨdek sɨŋak ag yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ned Herod eip Pailot eip ñag ñɨŋeb rek mɨdölɨgɨpir ak pen ñɨn nɨbak mɨnɨm nɨŋ jɨm ñɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pen Pailot, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep bɨ kɨb okok abe, bin bɨ yokop okok abe kɨrop agek ap mogɨm gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kɨri ap mogɨm gelak, ne kɨrop agak, “‘Bɨ aul mɨnɨm nab pag agɨl, bin bɨ okok kɨrop nɨb nɨb agɨp,’ agebɨm ak pen mɨñi udɨn yɨrɨk ar nɨbep aul mɨnɨm nɨpin ak, ne tap tɨmel gɨp mɨnɨm wagɨn alap ma pɨyo nɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod ak rek nep mɨnɨm wagɨn alap ma pɨyo nɨŋɨp ak me, adɨk cɨnope ke ñɨb. Yad nɨpin, tap tɨmel alap ma gɨp; nɨb ak nop ñag pak lep rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nɨb ak, ami bɨ yad okok agen, nop yokop pakɨl, ag yokel amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pen Juda kai ñɨn kɨb kɨri Pasopa ak apek, Pailot per mɨ nokɨm nokɨm nagɨman kɨri nokɨm alap yokop ag yokolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pen ñɨn nɨbak kɨri magɨlsek meg mɨgan bleble gɨl sɨk kɨlɨs gɨl aglak, “Bɨ nɨbak ñag pak lɨm! Barabas nop ag yokem cɨnop owaŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bɨ Barabas nɨbak ne taun kɨb nɨbak bin bɨ ognap dɨl, karɨp lɨm nɨbak kod mɨdolɨgɨp bɨ kɨb nɨbak eip pen pen gɨl, cɨp alap pɨs nep ñag pak lak rek, nop mɨnɨm kɨb agɨl mɨñ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pen Pailot Jisas yokop ag yoken amnaŋ, ag gos nɨŋɨl, kɨrop kauyaŋ agɨl nɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Agek, kɨri kauyaŋ meg mɨgan bleble gɨl sɨk agɨl aglak, “Nop mab bak alaŋ ñag pak lɨm! Nop mab bak alaŋ ñag pak lɨm!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Agelak, Pailot kɨrop kauyaŋ agɨl agak, “Bɨ nɨbaul tap tari gɨ tɨmel gɨp? Yad nɨpin, tap tɨmel alap ma gɨp rek, nop ñag pak lɨjɨn rek ma lɨp. Nɨb ak, ami bɨ yad agen, nop yokop pakɨl, ag yokel amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Agek, kɨri kɨlɨs yɨb gɨl, Jisas nop ñag pak lel kɨmaŋ, agɨl, meg mɨgan kɨri bɨlalö gɨ dap ranɨl, ag gel gel, ");
INSERT INTO kmh_m_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailot mɨnɨm kɨrop ak dɨl, ");
INSERT INTO kmh_m_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","bɨ alap, bin bɨ ognap dɨl karɨp lɨm kod mɨdolɨgɨp bɨ kɨb ak eip pen pen gɨl, cɨp alap pɨs nep ñag pak lak bɨ nɨbak nop ag yokek komɨŋ amnak; pen ami bɨ ne okok kɨrop agak, “Kɨri Jisas tari gɨnɨg gɨn, agɨl agebal ak, nep gɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jisas nop ñag pak lɨnɨg dad amnɨlak. Nab sɨŋak amlɨg gɨ, Sairini taun nɨb bɨ alap Jerusalem apek. Bɨ nɨbak yɨb ne Saimon. Nop nabɨŋ pakɨl, dɨ cɨcɨ lɨl, mab kros dɨ ka gɨ ñɨl aglak, “Jisas ameb ak kɨsen amnoŋ,” agel, dad kɨsen amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pen Jisas nop dad amel nɨŋlɨg gɨ, bin bɨ koŋai nep kɨsen gɨlak. Bin bɨ amelak nab nɨbak bin ognap Jisas nop yɨmɨg nɨŋɨl sɨl agelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nɨg gel, Jisas adɨk gɨl kɨrop agak, “Nɨbi Jerusalem bin, yɨp gɨnɨg geb ak sɨl ma agɨm. Nɨbep gɨ tɨmel gɨl, ñɨ pai nɨbi okok gɨ tɨmel gɨl genɨgab nɨbak sɨl agɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kɨsen mɨker kɨb ak apek, agnɨgal, ‘Bin ñɨ pai ma tɨk dopal okok abe, bin ñɨ pai ci ma ñɨbal okok abe, kɨri nep mɨñ mɨñ gɨnɨmel,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ñɨn nɨbak, tari gɨnɨg mɨdojɨn, agɨl, pɨs nep kɨmɨn, agɨl, agnɨgal ‘Dɨm gol okok pag pe gɨ apɨl, cɨnop ñag pak lɨnɨmɨŋ aka koji dɨl cɨnop lɨm ñɨnɨmɨŋ ak tep,’ agnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yad mab komɨŋ rek mɨdebin pen yɨp nɨg gɨl gɨ tɨmel gebal. Pen nɨbi mab mɨlep rek mɨdebɨm rek, nɨbep tari rek gɨ tɨmel gɨnɨgal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pen bɨ gapman lo mɨnɨm tɨb jurek bɨ omal, mab bak alaŋ ñag pak lɨnɨg sek dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dam karɨp lɨm Cɨp Nabɨc Cög Tɨŋɨl apal sɨŋak amjakɨl, Jisas nop dam mab bak alaŋ cɨpɨl pak lɨl, bɨ gapman lo tɨb jurek bɨ omal kɨrop dam mab pɨs pɨs cɨpɨl pak lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɨg gel, Jisas agak, “Bapi, yɨp gebal ak, ti gɨnɨg nɨg gobɨn, agɨl, nɨŋ tep gɨl ma gebal. Nɨb ak, kɨri gɨ tɨmel gebal ak nɨŋɨl kɨrɨg gɨnɨmɨn,” agak. Pen ami bɨ okok, Jisas walɨj ne tɨg ju lel mɨdek okok, kɨri ke sadu gɨlolo gɨpal rek ak gɨl dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bin bɨ koŋai nep nɨŋ mɨdel nɨŋlɨg gɨ, Juda bɨ kɨb okok Jisas nop paj agɨl aglak, “Ne, ‘Yad Mesaia ak; God yɨp dosɨp ne eip mɨdobɨr,’ agɨl, bin bɨ ognap kɨmbal gosɨp warɨkpal. Gɨp nɨbak rek, ne ke ak rek nep nɨg gɨl komɨŋ amek nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pen ami bɨ okok ak rek nep, Jisas mɨdek ulep sɨŋak apɨl nop paj agɨl, ñɨg wain sɨlek ñɨlɨg gɨ aglak, ");
INSERT INTO kmh_m_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Nak, ‘Juda Kiŋ kɨri mɨdebin,’ apan ak, nak ke gɨl komɨŋ amnoŋ!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pen Jisas nop cɨpɨl pak lɨlak mab bak sɨŋak alaŋ, mab bog bad alap ar ak mɨnɨm ñu kɨl tɨklak: ");
INSERT INTO kmh_m_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bɨ gapman lo mɨnɨm tɨb juel, mab bak alaŋ ñag pak lɨlak omal, bɨ alap Jisas nop ag juɨl agak, “Nak Mesaia mɨdeban ak, nak ke gɨl komɨŋ amɨl, cɨrop mal ak rek nep gek, komɨŋ amnɨr!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Agek, bɨ alap pen nop ag gɨl agak, “Bɨ nɨbaul yur kɨb dɨl kɨmnɨg geb; cɨr mal ke ak rek nep yur kɨb dɨl kɨmnɨg gobɨr ak, agɨl, God nop ma pɨrɨkpan ar? ");
INSERT INTO kmh_m_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Cɨr mal gɨ tɨmel gɨpɨr rek yur dobɨr, pen bɨ nɨbaul tap tɨmel alap ma gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne nɨb agɨl, Jisas nop agak, “Nak karɨp lɨm nak sɨŋak am kiŋ mɨdɨl, yɨp gos nɨŋnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nɨb agek, Jisas nop pen pe agak, “Yad nep nɨŋɨd yɨb agebin, mɨñi ñɨn aul nep nak yad eip am karɨp lɨm tep ak mɨdonɨgabɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Magɨl nɨbak, pɨb nab epel magɨl ak kɨslɨm gɨl, mɨd damɨl pɨb sɨŋeim okol gak magɨl ak kauyaŋ melɨk gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Pen Jisas sɨk kɨb agɨl agak, “Bapi, kaun yad ak ñɨnmagɨl ar nep ak lebin,” agak. Nɨb agɨl ake bad kɨr gak. Jisas ake bad kɨr gak, magɨl nɨbak nep, God sobok gep karɨp magɨl ñɨlɨk kapkap mɨgan eyaŋ, walɨj dɨ kɨjoŋ pɨlɨŋ gɨlak ak, nab eyaŋ pak talɨkɨl, lɨlɨg gɨ pɨs pɨs amek, kɨjoŋ yɨkɨl mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pen ami bɨ kod mɨdep bɨ kɨb ak, gek nɨbak nɨŋɨl, God yɨb ne ak dap ranlɨg gɨ agak, “Nɨŋɨd yɨb! Bɨ nɨbaul bɨ tep nep!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bin bɨ ap nɨŋ mɨdelak okok, tap gak nɨbak nɨŋɨl, molɨl pag apek pabɨl paklɨg gɨ, adɨk gɨl karɨp kɨri amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pen Jisas bin bɨ nɨŋeb ne okok abe, bin Galili nɨb nop kɨsen gɨlak okok abe, kɨri ke ke sɨŋ adaŋ mɨdɨl, tap gak nɨbak nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pen Juda Kansol kɨb bɨ alap, yɨb ne Josep. Ne bɨ tep, mɨnɨm tɨg bɨlok tep golɨgɨp. Ne Arimatia taun, karɨp lɨm Judia nab sɨŋak nɨb. Ne Juda Kansol bɨ ognap, Jisas nop ñag pak lɨn, agɨl, gos nɨŋlak rek ma nɨŋak. Ne, God bin bɨ dɨl kod mɨdenɨgab ñɨn ak onɨgab, agɨl, kod mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ne Jisas kɨmak, cɨp se dam tɨgel gɨnɨg gɨl, Pailot mɨdek sɨŋak amɨl, ag nɨŋek yau agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nɨb ak, Josep ne amɨl cɨp se tɨg asɨk dap yapɨl, walɨj tɨd tep alap dɨ kom kam gɨl, dam kab mɨgan kɨsen nep yɨg jɨrɨk lɨl cɨp tɨgel ma gɨlak mɨgan ak tɨgel gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pen Juda God nop sobok gep ñɨn ak maŋ apeb, agɨl, Praide dɨgep dɨgep magɨl ak cɨp tɨgel gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pen bin ñon, Jisas eip Galili nɨb olak okok, Josep amek nɨŋlɨg gɨ, kɨsen gɨ amɨl cɨp tɨgel amjakɨl, cɨp se titi gɨl tɨgel gak ak nɨŋ tep gɨl, adɨk gɨ karɨp kɨri amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Karɨp kɨri amɨl, agnoŋ ñɨg ki tep owep ognap cɨp se lɨ ñɨnɨg gɨl, gɨ lɨ tep gɨlak. Mɨnek ñɨn ak nep doplap ak pen Sarere ñɨn kɨb kɨri yokop mɨdep ak nɨŋɨl me, yokop mɨd mɨd kɨnlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mɨnek Sade ñɨn ak, karɨp kɨsen tɨkak magɨl ak, bin ñon nɨbak agnoŋ ñɨg ki tep owep ak dɨl, cɨp se mɨb goŋ anöŋ lɨ ñɨn, agɨl, dad cɨp tɨgel gɨlak sɨŋak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amɨl nɨŋlak, kab salai kɨb cɨp tɨgel mɨgan pɨlɨŋ gɨlak ak, lɨlɨg gɨ am bak kɨd sɨŋak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pen kɨri mɨgan nɨbak amɨl nɨŋlak, Bɨ Kɨb Jisas mɨb goŋ ne ma mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ti gɨp, agɨl, ag mɨdel nɨŋlɨg gɨ, dai bɨ omal gol nɨb sɨŋak warɨkɨl mɨderek. Bɨ omal walɨj kɨri tɨd melɨk sek aknɨb ke mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bin okok kɨrop nɨŋɨl, jel gek pɨrɨkɨl, kogɨm yɨmɨl jɨl kɨyan gɨl mɨdel nɨŋlɨg gɨ, bɨ nɨb omal agrek, “Tari gɨnɨg bɨ komɨŋ mɨdeb ak nop cɨp tɨgel gɨpal nab sɨŋ aul pɨyo nɨŋ ajebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ne sɨŋaul ma mɨdeb; mɨdarɨk nep warɨkɨp. Pen ne nɨbep eip Galili mɨdɨl mɨnɨm agak ak gos nɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ne nɨbep agak, ‘Bɨ Ñɨ ne ak nop, dɨ bin bɨ tap si tap tɨmel gɨpal ñɨnmagɨl ar kɨrop lel, nop mab bak alaŋ ñag pak lel, kɨmɨl ñɨn omal mɨdɨl, mɨnek ñɨn omal nokɨm ak kauyaŋ warɨknɨgab,’ agak,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nɨb ager nɨŋlɨg gɨ, gos magɨl kɨri ak pag yɨkek, Jisas ned Galili mɨdɨl mɨnɨm agak nɨbak gos nɨŋ dam nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bin okok kɨri cɨp tɨgel ak kɨrɨg gɨl, kauyaŋ adɨk gɨ amɨl, tap gak nɨŋlak nɨbak, Jisas bɨ ne aknɨb agɨp alaŋ okok abe, bin bɨ ne ognap okok abe ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bin ñon mɨnɨm ag ñɨlak nɨbak, Maria Magdala ak, Joana ak, Jems nonɨm Maria ak, bin ognap sek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pen kɨri mɨnɨm ag ñɨlak nɨbak peyɨg nɨŋɨl, nɨŋɨd agebal, agɨl, ma nɨŋlak. Ñɨñɨloŋ lɨl rek agebal, agɨl gos ak nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pen Pita mɨnɨm nɨbak nɨŋɨl, pɨg gɨ rɨkɨd ag amɨl, tɨgel gɨlak kab mɨgan ak sɨpsɨp nɨŋak, cɨp walɨj kom kam gɨlak bad ak nep mɨdek. Nɨbak nɨŋɨl, tari gɨp, agɨl, gos par yɨb lɨlɨg gɨ, cɨp tɨgel ak kɨrɨg gɨl kauyaŋ adɨk gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ñɨn nɨbak nep, bɨ omal karɨp tɨrɨg tɨroŋ Emeas, yokop Jerusalem ulep nɨb sɨŋak amnɨr, agɨl, majɨl amlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tap tari tari gek nɨŋrek mɨnɨm ak kapkap ag nɨŋlɨg gɨ amerek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Amerek nɨŋlɨg gɨ, Jisas kɨd ken apɨl, kɨrop mal poŋ dɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pen bɨ nɨb omal Jisas nop nɨprep ak pen God gos magɨl kɨrop mal dɨ we gek, Jisas nop nɨŋer bɨ aknɨb ke rek lak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne kɨrop mal ag nɨŋɨl agak, “Mɨnɨm ak tari mɨnɨm ager ameb?” agak. Nɨb agek, kɨri cɨb gep rek wös gɨ warɨk mɨdlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","bɨ Kliopas agak, “Nak nep me, mɨñi ñɨn sɨkol bad aul Jerusalem sɨŋaul ap mɨdɨl tap tari tari gɨp ak ma nɨpan ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Agek, Jisas agak, “Tap nɨbak tari gek agebir?” agak. Agek agrek, “Jisas Nasaret nɨb gak ak me. Bɨ God mɨnɨm agep ak, mɨnɨm ag ñɨ tep gɨl, tap ma gep rek okok golɨgɨp ak me, God nop tep gɨl, bin bɨ okok kɨrop tep gɨl gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ne nɨg golɨgɨp ak, gos cɨn nɨŋɨl agnok, ‘God nop ag yokek cɨnop Isrel bin bɨ dɨl, kod mɨd tep gɨnɨgab,’ ag gos nɨŋnok ak pen God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep bɨ kɨb okok abe, nop mɨnɨm ag gɨl, dam Rom gapman bɨ kɨb ak nop ñel, ne mɨnɨm kɨb agɨl, nop ami bɨ ne okok kɨrop ñek, dam mab bak alaŋ ñag pak lel kɨmak. Pen tap gak nɨbak ñɨn omal nep ap amnak me. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mɨñi kɨslɨm sek magɨl ak, bin ñon cɨn alap, amɨl nop tɨgel gɨlak kau mɨgan kau ak nɨŋɨl, apɨl cɨnop tap tari tari gɨp ak ag ñel nɨŋɨl pak ju dɨpɨn. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Bin okok kɨri apal, ‘Cɨp se par ak ma mɨdosɨp, pen ejol omal apɨl apir, “Ne warɨkɨl komɨŋ mɨdeb,” apir,’ apal. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nɨb agel, bɨ cɨn ognap nop tɨgel gɨlak kau mɨgan kau ak amɨl nɨpal, bin okok agesal rek nep mɨdosɨp. Pen Jisas nop ma nɨpal,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nɨb agerek, Jisas agak, “Nɨri mal gos nɨŋ tep ma gɨpir. Bɨ God mɨnɨm agep okok mɨnɨm aglak ak magɨlsek, tari gɨnɨg mɨnɨm nɨŋɨd apal, agɨl, ma nɨpir? ");
INSERT INTO kmh_m_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bɨ God mɨnɨm agep bɨ okok aglak rek, Mesaia ak ned yur kɨb yɨb denɨgab me, pen kɨsen ne melɨk tep ke sek mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nɨb agɨl, Mosɨs abe, bɨ God mɨnɨm agep bɨ okok magɨlsek abe, Krais nop God Mɨnɨm ñu kɨl tɨklak mɨdeb mɨnɨm nɨbak magɨlsek kɨrop ag ñɨ tep gek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Karɨp lɨm amelak ulep nɨb sɨŋak amjakɨl, Jisas kɨrop mal tausak lɨl, kɨrɨg amnɨg rek gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pen kɨri mal nop mɨnɨm kɨlɨs agɨl agrek, “Dɨgep aul opɨn. Kɨslɨm gɨnɨg geb nɨŋɨl nak apek cɨr mal eip kɨnɨn,” agrek. Ager, kɨrop mal eip karɨp amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Karɨp am mɨdɨl, tap ñɨŋnɨg, ne bred dɨl, God nop tep agɨl, tɨ paŋɨl kɨrop mal ñek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","gos magɨl kɨri mal ak gos pɨwakek, ak Jisas nep, agɨl nɨŋel nɨŋlɨg gɨ, kapkap kɨr gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nɨg gak ak nɨŋɨl agrek, “Majɨl nab sɨŋak aplɨg gɨ, mɨnɨm ognap ag ñɨlɨg gɨ, God Mɨnɨm ñu kɨl tɨklak mɨnɨm wagɨn ak ag ñɨlɨg gosɨp ak, mɨdmagɨl cɨrop ak mab rek yɨnɨl pɨlɨs gɨ ñɨb,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nɨb agɨl, magɨl nɨbak nep kauyaŋ adɨk gɨ Jerusalem amɨl nɨŋrek, Jisas bɨ ne aknɨb agɨp alaŋ, bin bɨ nɨŋeb kɨri ognap sek eip ap mogɨm gɨl mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Amjakɨl kɨri nɨŋrek, bin bɨ okok kɨri ke Jisas nop mɨnɨm ag mɨdelak. “Nɨŋɨd nep! Jisas kɨmak ak pen kauyaŋ warɨkɨl, ap Saimon mɨdosɨp sɨŋak mɨseŋ losɨp nɨŋɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mɨnɨm agelak nɨbak nɨŋɨl, bɨ omal agrek, “Cɨr mal majɨl nab sɨŋak amosɨr, Jisas cɨrop nabɨŋ pakosɨp, dam karɨp cɨr mal ak amɨl, tap ñɨŋnɨg gɨl, ne bred dɨl, God nop tep agosɨp ak, ak Jisas nep, agɨl nɨpɨr,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pen mɨnɨm nɨbak ag mɨdel nɨŋlɨg gɨ, Jisas ne ke mɨdelak nab sɨŋak mɨseŋ lɨl, nab sɨŋak alaŋ warɨk mɨdɨl agak, “God nɨbep kod mɨdeŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Agek, kɨri cɨp kaun, agɨl, jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pɨrɨkelak, Jisas kɨrop agak, “Tari gɨnɨg pɨrɨkebɨm? Udɨn nɨbi ke nɨŋebɨm ak pen tari gɨnɨg gos omal nɨŋebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñɨnmagɨl tob yad okok nɨŋɨm. Yad nep me! Yɨp dɨ pok nɨŋɨl nɨŋɨm. Cɨp kaun mɨb goŋ tɨpɨk sek ma mɨdeb. Pen yad yɨpɨl abe, tɨpɨk abe mɨdebin ak, udɨn nɨbi ke bɨr nɨŋebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nɨb aglɨg gɨ, ñɨnmagɨl tob ne okok kɨrop yomak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nɨg gek, kɨri mɨñ mɨñ gɨlɨg gɨ, gos par lɨlɨg gɨ, ak Jisas nep aka agɨl, gos omal nɨŋel nɨŋlɨg gɨ, Jisas kɨrop agak, “Tap ñɨŋeb nɨbi ognap sɨŋaul mɨdeb aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Agek, nop kɨbsal dagɨl lɨlak alap ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kɨri nɨŋ mɨdel nɨŋlɨg gɨ, ne kɨbsal nɨbak dɨ ñɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pen Jisas kɨrop agak, “Ned yad nɨbep eip mɨdɨl, mɨñi yɨp geb aknɨb rek ak gɨnɨgab, agɨl, nɨbep ag ñölɨgɨpin. Mosɨs yɨp mɨnɨm ñu kɨl tɨkak ak, bɨ God mɨnɨm agep yɨp mɨnɨm ñu kɨl tɨklak ak, God Mɨnɨm dai Sam ak yɨp mɨnɨm ñu kɨl tɨkak ak, yɨp ñu kɨl tɨklak rek nep magɨlsek aknɨb rek nep gɨnɨgab, agɨl, nɨbep ag ñɨ tep gɨnek,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nɨb agɨl, God Mɨnɨm ñu kɨl tɨklak ak nɨŋ tep gɨlaŋ, agɨl, gos tep yɨb ak kɨrop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne nɨg gɨl, kɨrop agak, “Ned okok ñu kɨl tɨkɨl aglak, ‘Mesaia ak yur kɨb dɨl kɨmek, tɨgel gel, ñɨn omal mɨdɨl, ñɨn omal nokɨm ak kauyaŋ warɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nɨb ak, mɨnɨm tep ne ak karɨp lɨm Jerusalem wagɨn gɨ ag ñɨl, ag ñɨ damɨl, bin bɨ karɨp lɨm tɨgoŋ tɨgoŋ magɨlsek ag ñel amek nɨŋlɨg gɨ, bin bɨ tap si tap tɨmel gɨpal okok, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨl, Krais nop cɨg gel nɨŋlɨg gɨ, tap tɨmel acɨr kɨrop ak lɨg gɨ yoknɨgab,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pen yɨp gak nɨbak udɨn magɨl nɨbi ke nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pen Bapi yad mɨnɨm ned ag lak rek, yad nɨbep ñɨnɨgain. Nɨb ak, nɨbi taun kɨb sɨŋaul nep mɨdɨl, kod mɨdenɨmɨb. Seb kab ar alaŋ sɨŋak nɨb kɨlɨs ke apɨl nɨbep goŋ lenɨgab ak nɨŋɨl amnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas nɨb agɨl, kɨrop poŋɨd damɨl, Jerusalem kɨrɨg gɨl, karɨp tɨrɨg tɨroŋ Betani ulep sɨŋak amɨl, God kɨrop kod mɨdeŋ, agɨl, ñɨnmagɨl ne dap ranɨl, God nop sobok gak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jisas nɨg gek nɨŋlɨg gɨ, God nop dam ap ran jak karɨp lɨm seb kab ar alaŋ sɨŋak dad amnak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nɨg gek, kɨrop tep gek nɨŋlɨg gɨ, yɨb ne ak agel ar amek nɨŋlɨg gɨ, adɨk gɨ Jerusalem amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amɨl, per per nep God nop sobok gep karɨp ñɨlɨk mɨgan ak amɨl, God yɨb ne agel ar amolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Karɨp lɨm bɨrarɨk ped okok ma gɨ lak ñɨn ak, God Mɨnɨm mɨdek. God Mɨnɨm ne God eip mɨdek. God Mɨnɨm ne ak rek nep God. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wös rek God Mɨnɨm ne God eip mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God ne gek, God Mɨnɨm ne tap okok magɨlsek gɨ lak. Tap alap ke ma lak; ne ke gɨ lak tap okok nep mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","God Mɨnɨm ne komɨŋ mɨdep wagɨn ak. Komɨŋ mɨdep won nɨbak bin bɨ kɨrop melɨk ñak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Melɨk nɨbak amɨl bin bɨ kɨslɨm gɨp nab sɨŋak mɨdebal okok ñɨ leb nɨŋɨl kɨslɨm Melɨk nɨbak posɨg gɨnɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Bin bɨ okok magɨlsek Melɨk nɨbak nop nɨŋ dɨnɨmel, agɨl, God bɨ alap nop ag lek, ne apɨl Melɨk nɨbak nop mɨnɨm ag ñolɨgɨp. Bɨ mɨnɨm ag ñolɨgɨp bɨ nɨbak yɨb ne Jon. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon ne Melɨk nɨbak mer. Ne yokop bɨ an Melɨk mɨdeb mɨnɨm ak bin bɨ okok kɨrop ag ñɨnɨg owak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Melɨk nɨŋɨd yɨb nɨbak ne karɨp lɨm wagɨn aul apɨl, bin bɨ okok magɨlsek kɨrop melɨk ñeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ne karɨp lɨm wagɨn aul apɨl mɨdolɨgɨp. God ne gek, ne lɨm dai wagɨn aul gɨ lɨl, bin bɨ okok gɨ lak. Pen ne karɨp lɨm wagɨn aul ap mɨdek ak, bin bɨ nop udɨn nɨŋɨl, ne bɨ an, agɨl, ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ne karɨp lɨm ne ke owak ak pen bin bɨ ne ke nop ma dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pen bin bɨ an an, mɨnɨm tep ne ak nɨŋ dɨl, nop Bɨ Kɨb cɨn, agɨl, nɨŋ dɨpal bin bɨ okok, ne kɨrop gek kɨri magɨlsek God ñɨ pai ne mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God ñɨ pai ne mɨdenɨgal ak, bɨ ber gon okok dɨl, ñɨ pai tɨk dapel mɨdebal rek ma mɨdenɨgal. God ne ke gek ñɨ pai ne mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pen Mɨnɨm nɨbak, ne apɨl bɨ mɨb goŋ lɨl, cɨnop eip kɨn mɨdolɨgɨp. Nɨb ak, cɨn melɨk won tep ne bɨr nɨpɨn. Ne Bɨñen Ñɨ ne nokɨm yɨb ak me, Bɨñen ne ke melɨk won tep ke sek mɨdeb rek, Ñɨ ne ak rek nep melɨk won tep ke sek mɨdeb. Pen ne bɨ mɨb goŋ lɨl apɨl, cɨnop magɨlsek yɨmɨg yɨb nɨŋɨl dɨ tep yɨb gɨl, mɨnɨm nɨŋɨd magɨlsek ag ñɨ tep golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne owak ak, Jon ne nɨŋɨl, sɨk agɨl bin bɨ okok kɨrop agak, “Bɨ mɨñi apeb aul nep, yad nɨbep ned agnek, ‘Bɨ alap ne yɨp kɨsen onɨgab ak pen yɨp ma tɨk dorek ar ak, ne bɨrarɨk ped okok mɨdolɨgɨp. Nɨb ak, ne yad rek mer; ne Bɨ Kɨb yɨb,’ agnek ak, bɨ nɨbak me aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ne cɨnop bin bɨ magɨlsek yɨmɨg yɨb nɨŋɨl, dɨ tep yɨb gɨl, tap tep tep koŋai nep ñɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wösrek nep lo mɨnɨm ar ak, God Mosɨs nop ñek, Mosɨs cɨnop ñak ak pen God bin bɨ yɨmɨg nɨŋɨl dɨ tep gɨp mɨnɨm nɨŋɨd nɨbak, Jisas Krais owak ak me, mɨñi mɨseŋ nɨŋobɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Bin bɨ ognap God nop ma nɨpal. God Ñɨ nokɨm ne ak nep Nap eip mɨdebir. Ne Nap ne ag mɨseŋ lak nɨŋɨl mɨñi cɨn Bapi God bɨr nɨpɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda bɨ kɨb Jerusalem nɨb okok kɨri bɨ God nop tap sobok gep bɨ ognap abe, bɨ God sobok gep karɨp wög gɨ ñölɨgɨpal bɨ ognap abe ag yokɨl aglak, “Nɨbi Jon mɨdeb sɨŋak amɨl, ‘Nak bɨ an?’ agɨl, ag nɨŋnɨmɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kɨri Jon mɨdek sɨŋak amjakɨl, nop ag nɨŋɨl aglak, “Nak bɨ an?” aglak. Ag nɨŋelak, ne we ma ñak. Kɨrop mɨseŋ agɨl agak, “Yad Krais ak mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nɨb agek, kɨri pen aglak, “Nɨb apan ak, nak bɨ an? Nak Ilaija aka?” aglak. Nɨb agelak, Jon agak, “Yad Ilaija mer,” agak. Nɨb agek, kɨri pen aglak, “Nak bɨ God mɨnɨm agep per kod mɨdobɨn ak aka?” aglak. Agelak, Jon mer agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nɨb agek, bɨ nɨb okok pen aglak, “Nɨb ak, nak bɨ an? Pen, yad bɨ an, agɨl, agnɨgan ak, cɨn amɨl bɨ kɨb cɨnop ag yokpal okok kɨrop ag ñɨnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Agelak, Jon kɨrop agak, “Yad mɨñi gebin aul, bɨ God mɨnɨm agep Aisaia ned agak rek nep gebin. Ne agak, ‘Yad bɨ alap karɨp lɨm bin bɨ koŋai ma mɨdebal, mɨñ mab kab nep mɨdeb nab sɨŋak am mɨdɨl, sɨk kɨb aglɨg gɨ agebin, “Per Bɨ Kɨb apeb, agɨl, kanɨb lɨg gɨ tep gɨnɨmɨb,” agebin,’ agak. Yad Jon mɨñi gebin me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pen bɨ Jon nop ag nɨŋnɨg olak nɨb okok, bɨ Perisi ognap eip olak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kɨri Jon nop ag nɨŋɨl aglak, “Nak apan, yad Krais mer, Ilaija mer, bɨ God mɨnɨm agep kod mɨdobɨn ak mer apan gö pen tari gɨnɨg bin bɨ okok kɨrop ñɨg pak ñeban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Agelak, Jon agak, “Yad kɨrop yokop ñɨg pak ñebin. Pen bɨ alap nab nɨbep sɨŋaul mɨdeb, ne tigep bɨ rek mɨdeb, agɨl, ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Bɨ nɨbak ne yad kɨsen onɨgab pen ne yad rek mer; ne bɨ kɨb yɨb, yad bɨ sɨkol. Yad tob tɨrɨp ne ak nag wɨsɨbnɨm rek ma lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon bin bɨ okok kɨrop ñɨg pak ñolɨgɨp karɨp tɨrɨg tɨroŋ Betani, ñɨg Jodan gol pɨs kɨd adaŋ nɨŋɨl bɨ nɨb okok apɨl nop mɨnɨm nɨbak ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mɨnek Jisas apek nɨŋlɨg gɨ, Jon Jisas nɨŋɨl bin bɨ okok kɨrop agak, “Nɨŋɨm! God Sipsip Ñɨlɨk ne cɨnop ag yokɨp me ak. Ne me bin bɨ lɨm dai ar wagɨn aul tɨgoŋ tɨgoŋ magɨlsek tap si tap tɨmel gɨpal gac ak lɨg gɨ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Bɨ nɨbak me, yad agnek, ‘Bɨ alap ne yɨp kɨsen onɨgab ak pen yɨp ma tɨk dorek ar ak, ne bɨrarɨk ped okok mɨdolɨgɨp. Nɨb ak, ne yad rek mer; ne Bɨ Kɨb yɨb,’ agnek. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bɨ Kɨb nɨbak bɨ an, agɨl, adi ma nɨŋölɨgɨpin. Pen Isrel bin bɨ, Bɨ Kɨb nɨbak bɨ tigep bɨ rek mɨdeb ak nɨŋnɨmel, agɨl, kɨrop ñɨg pak ñɨnɨg onek,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Pen Jon Jisas mɨnɨm ar nɨbak nep agɨl agak, “Bɨ nɨbaul bɨ an, agɨl, yad ke ma nɨpnep; pen bɨ yɨp ag yokek apɨl bin bɨ kɨrop ñɨg pak ñebin ak agak, ‘Nak nɨŋnɨgan, Kaun ne bɨ an apɨl, eip mɨdenɨgab, bɨ nɨbak nep bin bɨ okok kɨrop Kaun Sɨŋ pak ñɨnɨgab,’ agak. Agak nɨbak me, mɨñi Kaun ak seb kab ar alaŋ nɨb yakɨr tɨbaglem rek ug gɨ nop aposɨp ");
INSERT INTO kmh_m_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","nɨŋɨl yad nɨŋ tep gɨl kɨrop mɨnɨm nɨŋɨd agebin, bɨ nɨbaul ne God Ñɨ ne ak nep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mɨnek pen, Jon bɨ ne omal eip, kauyaŋ ap ñɨg pak ñolɨgɨp kau sɨŋak mɨdel nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisas ap padɨkek, Jon ne Jisas nɨŋɨl bin bɨ okok kɨrop agak, “Bɨ nɨbaul me God Sipsip Ñɨlɨk ne ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nɨb agek, Jon bɨ ne omal, mɨnɨm nɨbak nɨŋɨl, Jisas amek mɨgan ak sain amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pen Jisas adɨk gɨl kɨrop mal nɨŋɨl agak, “Tari gɨnɨg apebir?” agak. Agek agrek, “Rabai! Nak kɨnban akal?” agrek. Hibru mɨnɨm agɨl “Rabai” agrek mɨnɨm nɨbak wagɨn ak “Mɨnɨm Ag Ñeb Bɨ.” ");
INSERT INTO kmh_m_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pen kɨri nɨg gɨl ag nɨŋrek, Jisas agak, “Nɨb ak, yad eip amɨl nɨŋnɨgair,” agak. Agak ñɨn nɨbak nep dɨgep won ak amɨl, ne eip mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon bɨ ne nɨb omal, bɨ alap yɨb ne Edru. Edru nɨmam ne me Saimon Pita. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Edru won nɨbak nep am nɨmam Saimon nop pɨyo nɨŋɨl agak, “Mesaia ak onɨgab agɨl per kod mɨdobɨn ak mɨñi nɨpɨr,” agak. (“Mesaia” agak mɨnɨm won ak, Grik mɨnɨm agɨl “Krais” apal.) ");
INSERT INTO kmh_m_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Edru nɨb agɨl, nɨmam Saimon nop poŋ dɨl Jisas mɨdek sɨŋak amek, Jisas Saimon nop nɨŋɨl agak, “Jon ñɨ ne Saimon. Nep Sipas agnɨgal,” agak. Arameik mɨnɨm agɨl, yɨb Sipas agak mɨnɨm won nɨbak, Grik mɨnɨm agɨl Pita apal. Sipas abe Pita abe wagɨn nokɨm nɨbak “kab.” ");
INSERT INTO kmh_m_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mɨnek, Jisas karɨp lɨm Galili amnɨg, am Pilip nop nɨŋɨl agak, “Yad eip amnɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip, Edru, Pita, karɨp lɨm kɨri Betsaida nɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pen Pilip am Natanyel nop nɨŋɨl agak, “Cɨn bɨ ak, Mosɨs abe, bɨ God mɨnɨm agep ognap abe ñu kɨl tɨkɨl aglak bɨ nɨbak nop mɨñi nɨpɨn. Ne me Jisas, Josep ñɨ ne. Karɨp lɨm ne Nasaret nɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pilip nɨb agek, Natanyel agak, “Bɨ tep alap karɨp lɨm tɨmel nɨbak nɨb ma onɨgab,” agak. Agek, Pilip agak, “Nɨb ageban ak, apek am nɨŋɨr!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nɨb agɨl, kɨri bɨ omal amɨl ulep ulep ger nɨŋlɨg gɨ, Jisas Natanyel nop nɨŋɨl agak, “Bɨ nɨbak bɨ Isrel yɨpɨd gɨl ak me, ne esek ar ak ma agnɨgab; ne nɨŋɨd nep mɨseŋ agnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nɨb agek, Natanyel agak, “Nak titi gɨl yɨp nɨpan?” agak. Agek, Jisas agak, “Pilip nep kɨsen poŋ dɨnɨg nɨb; yad nep ned nɨpin, nak bɨsɨg mɨdesan tauan wagɨn sɨŋak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nɨb agek, Natanyel agak, “Mɨnɨm ag ñeb bɨ, nep nɨpin! Nak God Ñɨ ne, Isrel bin bɨ Kiŋ cɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nɨb agek, Jisas agak, “Nep yokop tauan wagɨn sɨŋak nɨpin apin ak me, yɨp nɨŋ dɨpan? Kɨsen tap ke nɨb ognap nɨŋnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisas nɨb agɨl agak, “Nɨbep magɨlsek nɨŋɨd agebin, seb kab ar alaŋ sɨŋak pag yɨkek, ejol okok apɨl, yɨp Bɨ Ñɨ ne nɨŋ amɨl apɨl, nɨŋ amɨl apɨl, genɨgal nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Ñɨn omal mɨdɨl, bɨ alap bin dɨnɨg gɨl, bin bɨ sɨk agek amɨl, tap ñɨŋlak Kena taun, karɨp lɨm Galili nab sɨŋak. Mɨnek nɨbak, Jisas abe, bɨ ne okok abe, kɨrop ak rek nep sɨk agel amnɨlak. Pen Jisas nonɨm abe am karɨp nɨbak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ñɨg wain ak ñɨb sakelak, Jisas nonɨm apɨl Jisas nop agak, “Wain ak ñɨb sakpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nɨb agek, Jisas agak, “Yɨp nɨg gan nɨg gan, agɨl, yɨp ma agnɨmɨn. Ñɨn yad ak ma owɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Agek, nonɨm ne am bɨ wög gɨ ñeb okok kɨrop agak, “Jisas mɨnɨm alap agonɨmɨŋ, agnɨmɨŋ rek nep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pen Juda bin bɨ kab dɨl gɨlak tin kɨb yɨb aknɨb kagol oŋɨd ak dɨ lel mɨdek. Tin kɨb nokɨm nokɨm ñɨg lita aknɨb ñɨnjuɨl mamɨd ak mɨl dap lep. Pen Juda bin bɨ nag ar kɨri gölɨgɨpal rek, God udɨn yɨrɨk bin bɨ tɨd tep mɨdojɨn, agɨl, tin nɨb okok ñɨg mɨl dap soŋ gɨl, ñɨn tob ñɨg lɨ yokölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas pen, bɨ wög gɨ ñeb okok kɨrop agak, “Kab tin ognɨl, ñɨg mɨl dap soŋ gem, ap ran jaknɨmɨŋ,” agak. Agek, agak rek gelak agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Mɨñi ñɨg mɨl dap lɨpɨm ak, mɨl damɨl, bɨ tap ñɨbobɨn aul kod mɨdeb ak nop ñɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Agek, ñɨg yɨb nɨbak mɨl dam bɨ kɨb ak nop ñelak, ne dɨl ñɨb nɨŋak, ñɨg wain tep ak mɨdek. Pen ne ñɨg wain nɨbak akal nɨb, agɨl, ma nɨŋak; bɨ wög gɨ ñeb okok kɨri nep nɨŋlak. Pen ne ma nɨŋak rek me, bɨ bin dɨnɨg gak nɨbak nop sɨk agek apek agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Per nep, ñɨg wain tep ak ned dap ñel ñɨb sakel me, kɨsen ñɨg wain tɨmel ak ñel ñɨbal. Pen nak ñɨg wain tep ak dap lek mɨdosɨp, mɨñi nep dap ñeban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas tap ma gep rek ned sabdaŋ eyaŋ gak nɨbak, ne Kena taun, karɨp lɨm Galili nab sɨŋak mɨdɨl gak. Tap ma gep nɨbak gɨl, ne titi bɨ rek mɨdek ak yomek bɨ ne okok nɨŋɨl, nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pen Kena taun kɨrɨg gɨl, Jisas ne ke, nonɨm, nɨmam kɨsen, bɨ ne okok eip taun sɨkol Kapaneam amɨl, yokop ñɨn bad alap nɨb sɨŋak mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda kai Pasopa ñɨn kɨb kɨri ak maŋ gak nɨŋɨl Jisas Jerusalem amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jisas Jerusalem amɨl, God sobok gep karɨp mɨgan ak nɨŋak, bɨ ognap kɨri kaj kau, kaj sipsip, yakɨr tɨbaglem okok dap sɨkim gɨl, bɨ ognap abañ bad okok lɨl, mab bog ar bɨsɨg gɨl, mani yɨmjɨklɨg gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisas nɨŋɨl, nag alap dɨl malɨkɨl, kaj sipsip kaj kau okok yɨklɨg gɨ söŋ eyaŋ yokɨl, mani dap pen pen yɨmjɨklɨg gelak abañ bad okok mani sek tɨg soŋ gɨ yokak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɨg gɨl, bin bɨ yakɨr tɨbaglem dap sɨkim gelak okok kɨrop agak, “Tap nɨb okok dad amnɨm. Bapi yad karɨp ne ak gem sɨkim gep karɨp rek ma lɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas nɨg gek, bɨ ne okok gos kɨri amnak God Mɨnɨm ñu kɨl tɨklak mɨnɨm alap ar ak. Mɨnɨm nɨbak ñu kɨl tɨkɨl aglak, “Sobok gep karɨp nak ak mɨdmagɨl yɨb lɨl kɨmnɨgain,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pen Juda bɨ kɨb ognap apɨl, Jisas nop ag nɨŋɨl aglak, “Nep bɨ an agosɨp apɨl nɨg geban? God nep agek apɨl gebin, agɨl, tap ma gep rek alap gek cɨn nɨŋɨl, ‘Nɨŋɨd ageban,’ ag nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nɨb agelak, Jisas kɨrop pen agak, “Nɨbi God sobok gep karɨp nɨbaul tɨb wal genɨgabɨm, ñɨn omal nokɨm kauyaŋ gɨ lɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nɨb agek aglak, “God sobok gep karɨp nɨbaul, mɨ ñɨnjuɨl omal adɨk gɨ dam aknɨb kagol oŋɨd (46) gɨ saklak ak pen nak ñɨn omal nokɨm kauyaŋ gɨ lɨnɨgain ageban ar?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pen Jisas ne sobok gep karɨp mɨnɨm agak nɨbak, mɨb goŋ ne ke nep agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nɨb ak me, kɨsen Jisas ne kɨmɨl warɨkak ak, bɨ nop kɨsen gölɨgɨpal okok, God Mɨnɨm ak abe, Jisas ne ke mɨnɨm agak nɨbak abe gos nɨŋɨl, “Nɨŋɨd agɨp,” agɨl nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas, Juda kai Pasopa ñɨn kɨb kɨri ak Jerusalem kɨn mɨdɨl, tap ma gep rek ognap gek ak nɨŋɨl, bin bɨ okok, “Ne nep Mesaia ak,” agɨl, nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Bin bɨ titi gɨl rek mɨdebal ak, bɨ alap Jisas nop ma ag ñölɨgɨpal. Jisas ne ke bin bɨ nag ar gɨpal bɨr nɨŋ tep gɨp. Bin bɨ nɨb okok gos kɨri ar akal ameb ak nɨŋ tep gɨp ak me, ne bin bɨ nɨb okok bin bɨ nɨŋeb yad, agɨl, kɨrop ma dak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bɨ Juda Kansol kɨb ak bɨ alap mɨdolɨgɨp, yɨb ne ak Nikodimas. Ne Perisi bɨ alap. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ne kɨslɨm eyaŋ, Jisas nop nɨŋnɨg, mɨdek sɨŋak apɨl agak, “Mɨnɨm ag ñeb bɨ. Cɨn nɨpɨn, tap ma gep rek gɨpan okok, nak ke ma gɨpnap; God ne ke nep nep eip mɨdeb ak me, tap ma gep rek nɨb okok gɨpan. Nɨb ak, cɨn nɨpɨn, God ne nep nep ag yokek apɨl cɨnop mɨnɨm ag ñɨban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Agek, Jisas agak, “Yad nep nɨŋɨd yɨb agebin, bin bɨ ke komɨŋ kɨsen nɨb lɨnɨgal okok nep, God kɨrop dɨl, ‘Bin bɨ yad’ agɨl, kod mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nɨb agek, Nikodimas wal agɨl gos par nɨŋɨl agak, “Bin bɨ tɨk lel kɨb gɨpal okok, kauyaŋ nonɨm kogi nab adaŋ amel, kauyaŋ tɨk dapel, bin bɨ ke komɨŋ kɨsen nɨb lɨlaŋ, agɨl, ageban aka tari?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Agek, Jisas agak, “Nep nɨŋɨd yɨb agebin, bin bɨ sɨŋak, ñɨg ak abe, God Kaun ak abe dɨl ke komɨŋ kɨsen nɨb lɨnɨgal okok nep, God kɨrop dɨl, ‘Bin bɨ yad’ agɨl, kod mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bin bɨ tɨk dopal rek tɨk dapel mɨdebal ak pen God Kaun ne apɨl kaun won nɨbep nab adaŋ gek komɨŋ mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nɨb ak, “Nɨbi bin bɨ magɨlsek ke komɨŋ kɨsen nɨb lɨnɨmɨb,” mɨnɨm agesin nɨbak, nak wal agɨl gos par ma nɨŋnɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pɨnem ak gos ne ke apɨl ameb. Pɨnem dosɨp nɨpɨm ak pen apeb tam ak sek, ameb tam ak sek, nɨbi ma nɨpɨm. Nɨb ak rek me, bin bɨ God Kaun bak lek, ke komɨŋ kɨsen nɨb lɨpal okok,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nɨb agek, Nikodimas agak, “Nak ageban ar nɨbak, titi gɨl gɨnɨmɨŋ?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Agek, Jisas agak, “Nak Isrel bin bɨ mɨnɨm ag ñeb bɨ kɨb kɨri alap pen nak ma nɨpan ar? ");
INSERT INTO kmh_m_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nep nɨŋɨd yɨb agebin, cɨn ke tap tari nɨŋ tep gɨl, tap tari udɨn cɨn ke nɨŋɨl nɨpɨn nɨbak nep nɨbep ag ñobɨn ak pen mɨnɨm agobɨn nɨbak ma nɨŋ dɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yad nɨbep lɨm dai ar wagɨn aul gɨp rek agen, ma nɨŋ dɨpɨm rek, titi gɨl God karɨp lɨm seb kab ar alaŋ sɨŋak gɨp rek agen, nɨŋ dɨnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pen bin bɨ alap God karɨp lɨm seb kab ar alaŋ sɨŋak ajɨl ma nɨŋak; yad ke Bɨ Ñɨ ne nep nɨb alaŋ mɨdɨl onek. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Pen bɨrarɨk nep mɨñ mab kab nep mɨdolɨgɨp nab sɨŋak, soiŋ tɨmel okok Isrel bin bɨ kɨrop su lel kɨmlak ak nɨŋɨl Mosɨs soiŋ tɨmel nɨb okok rek alap dɨ mab bak sɨŋ alaŋ lek, bin bɨ an an soiŋ nɨb alaŋ nɨŋlak okok, kɨrop komɨŋ lak. Nɨb ak rek me, Bɨ Ñɨ ne nop mab bak alaŋ ñag pak lel, ");
INSERT INTO kmh_m_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bin bɨ an an nop nɨŋ dɨnɨgal okok, komɨŋ per mɨdep ak dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God bin bɨ karɨp lɨm wagɨn aul mɨdebal okok kɨrop mɨdmagɨl yɨb lɨl, Ñɨ ne nokɨm yɨb ak kɨrop nen agɨl ñak. Nɨb ak, bin bɨ an an Ñɨ ne nɨbak nop nɨŋ dɨnɨgal okok, kɨrop komɨŋ per mɨdep magɨl ak ñek, kɨmɨl ma kɨr gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God Ñɨ ne ag yokak ak, bin bɨ okok kɨrop mɨnɨm kɨb agnɨmɨŋ, agɨl, ma ag yokak; bin bɨ okok dɨ komɨŋ yoknɨmɨŋ, agɨl, ag yokak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Bin bɨ an an Ñɨ ne nop nɨŋ dɨnɨgabal okok, God kɨrop mɨnɨm kɨb agɨl pen yur ma ñɨnɨgab. Pen bin bɨ nop ma nɨŋ dɨnɨgal okok, God Ñɨ ne nokɨm yɨb nɨbak nop ma nɨŋ dɨnɨgal rek, God kɨrop bɨr mɨnɨm kɨb agɨl, pen yur kɨb dɨnɨgal, agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God bin bɨ okok kɨrop mɨnɨm kɨb agɨl pen yur ñɨnɨgab, wagɨn nɨbak nɨg gɨl mɨdeb: Melɨk lɨm dai ar wagɨn aul owɨp ak pen bin bɨ okok, melɨk mɨdeb sɨŋak amnɨn, agɨl gos ak ma nɨpal. Kɨri tap si tap tɨmel gɨ mɨdebal rek, kɨslɨm gɨp okok nep mɨdojɨn, agɨl gos ak nep nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Melɨk nɨbak nɨŋel mɨlɨk yapek, ‘Tɨmel gɨpɨn ak, mɨseŋ ma nɨŋnɨmel,’ agɨl, melɨk mɨdeb sɨŋak ma onɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pen bin bɨ yɨpɨd gɨl gɨpal okok, ‘God agɨp rek nep gobɨn ak mɨseŋ nɨŋlaŋ,’ agɨl, melɨk mɨdeb ar sɨŋak opal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kɨsen Jisas bɨ ne okok eip am karɨp lɨm Judia nab okok am mɨdlɨg gɨ, bin bɨ okok kɨrop ñɨg pak ñɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ainon karɨp lɨm Salim maŋ nɨb sɨŋak mɨdek. Pen karɨp lɨm Ainon sɨŋak ñɨg koŋai mɨdek. Nɨb ak, ñɨn nab nɨb sɨŋak, Jon ne Ainon sɨŋak am kɨn mɨdɨl, bin bɨ koŋai nep apelɨgɨpal okok kɨrop ñɨg pak ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ñɨn nɨbak kɨri Jon bɨ ñɨg pak ñeb nop mɨñ ma lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pen Juda bɨ alap apɨl, Juda nag ar kɨri, ñɨg lɨ yokɨl God udɨn yɨrɨk ar sɨŋak mɨd tep gɨjɨn, agölɨgɨpal mɨnɨm ar ak agɨl, Jon bɨ ne ognap eip mɨnɨm pen pen aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mɨnɨm pen pen agɨl, Jon bɨ ne okok apɨl Jon nop aglak, “Mɨnɨm ag ñeb bɨ. Bɨ aul ñɨg Jodan gol pɨs kɨdadaŋ mɨdek, nop Bɨ Kɨb agenak bɨ nɨbak, mɨñi apɨl bin bɨ kɨrop ñɨg pak ñeb nɨŋɨl bin bɨ magɨlsek nop amebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nɨb agelak, Jon pen agak, “God gos ne ke nɨŋɨp rek, cɨnop wög ar ke ke ag lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nɨbi ke nɨpɨm yad nɨbep agnek, ‘Yad Krais mer; God agek yad yokop kanɨb ne ak lɨg yɨpɨd gebin,’ agnek. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bɨ alap bin dɨnɨgab ñɨn ak, ne bin ne dɨnɨgab. Bin nɨbak bin ne me ak. Bɨ bin dɨnɨgab bɨ ak, bɨ nɨŋeb ne alap apɨl nop gɨ ñɨnɨgab. Mɨnek akal bin ne dɨnɨg onɨgab, agɨl, nop kod mɨdenɨgab. Pen ne bin dɨnɨg apɨl ‘Bɨr opin aul’ agenɨgab ak, bɨ nɨŋeb ne mɨnɨm ne nɨŋɨl mɨñ mɨñ gɨnɨgab. Yad me nɨbak rek. Jisas ne bin bɨ okok kɨrop nɨg gɨl geb ak, yɨp tep gɨp. Mɨñi yad mɨñ mɨñ yɨb gebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yɨb ne ap ranek nɨŋlɨg gɨ, yɨb yad ap yonɨgab ak tep. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Bɨ seb kab ar alaŋ sɨŋak nɨb owɨp ak, ne bin bɨ okok magɨlsek ar i alaŋ mɨdeb. Bɨ lɨm dai wagɨn aul nɨb bɨ ak, ne lɨm dai wagɨn aul nɨb ak me, lɨm dai ar wagɨn aul gos nɨŋɨl mɨnɨm apal rek ageb. Pen bɨ seb kab ar alaŋ sɨŋak nɨb owɨp ak, ne bin bɨ okok magɨlsek ar i alaŋ mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ne seb kab ar alaŋ sɨŋak mɨdɨl tap tari udɨn nɨŋɨp ak, mɨnɨm tari peyɨg nɨŋɨp ak, bin bɨ okok kɨrop ag ñeb, pen mɨnɨm ne ak ma debal. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pen bin bɨ mɨnɨm ne nɨŋ dɨpal okok, God mɨnɨm nɨŋɨd ak nep ageb, agɨl, nɨŋ dɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God ne Jisas ag yokak ak, Kaun ne ak nop ñek ap ran jakek, God mɨnɨm magɨl ne nep ag ñeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nap Ñɨ ne nop mɨdmagɨl lɨl, ‘Tap okok magɨlsek kod mɨdenɨmɨn,’ agɨl, dɨ ñɨnmagɨl ar nop ak lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bin bɨ an an Ñɨ ne nop nɨŋ dɨpal okok, per komɨŋ mɨdep won ak bɨr dɨpal. Pen bin bɨ an an Ñɨ ne nop ma nɨŋ dɨpal okok, kɨri per komɨŋ mɨdep won ak ma dɨnɨgal; God bin bɨ nɨb okok kɨrop mɨnɨm kɨb agek, mɨker dɨlɨg gɨ nep mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pen bɨ Perisi okok mɨnɨm alap peyɨg nɨŋlak, bin bɨ koŋai nep, Jisas eip mɨdon, agɨl, ne mɨdek sɨŋak apel ne kɨrop bin bɨ koŋai nep ñɨg pak ñɨlɨg mɨdek; pen bin bɨ sɨkol bad alap nep Jon mɨdek sɨŋak apel ne kɨrop ñɨg pak ñɨlɨg mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pen Jisas ne ke bin bɨ okok kɨrop ñɨg ma pak ñak; bɨ ne okok nep kɨrop ñɨg pak ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pen Perisi kai mɨnɨm nɨbak rek agelak nɨŋɨl, Jisas karɨp lɨm Judia kɨrɨg gɨl, adɨk gɨ karɨp lɨm Galili amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pen kanɨb nab sɨŋak amlɨg gɨ, ne karɨp lɨm Sameria amjakak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pen karɨp lɨm Sameria nab sɨŋak amlɨg gɨ, Sikar taun amjakak. Sikar maŋ nɨb sɨŋak me, bɨrarɨk nep Jekop ñɨ ne Josep nop lɨm dai alap agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pen Jekop ñɨg kau dak ak mɨdek ak me, Jisas apek apek, pɨb nab alaŋ won ak nop masos gek rek, ne amɨl ñɨg kau gol maŋ nɨb sɨŋak bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Pen bɨ ne okok tap magɨl taunɨg, Sikar taun nɨbak amnɨlak. Jisas ñɨg kau maŋ sɨŋak bɨsɨg mɨdek nɨŋlɨg gɨ, bin Sameria nɨb alap ñɨg mɨlnɨg owak. Apek, Jisas nop nɨŋɨl agak, “Yɨp ñɨg mɨl ñek ñɨŋin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Agek, bin nɨbak agak, “Nɨbi Juda bin bɨ, cɨnop Sameria bin bɨ nɨŋɨl, asɨk mosɨk gɨ rep gɨpɨm rek, tari gɨnɨg, ‘Yɨp ñɨg mɨl ñek ñɨŋin,’ agɨl ageban?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nɨb agek, Jisas pen agak, “Nak God tap tep bin bɨ ñɨnɨg geb ak nɨŋɨl, yad nep, ñɨg mɨl dap ñan, agebin, yad bɨ an mɨdebin nɨpnap ak, nak yɨp apnap, yad nep ñɨg komɨŋ magɨl ñeb ñɨbnep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Agek, bin nɨbak agak, “Bɨ kɨb. Ñɨg mɨlep tin nak alap ma mɨdeb; ñɨg kau ak rek nep i okeyaŋ mɨdeb. Nɨb ak, ñɨg komɨŋ magɨl ñeb nɨbak akal nɨb dɨnɨgan? ");
INSERT INTO kmh_m_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Based acɨk cɨn Jekop ñɨg kau nɨbaul cɨnop ñak. Ñɨg nɨbaul nep, ne ke abe, ñɨ ne sɨkop abe ñɨbɨl, kaj sipsip tap ne okok ñɨbɨl gölɨgɨpal. Nɨb ak, yad bɨ kɨb, Jekop bɨ sɨkol, agɨl gos nɨpan ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Agek, Jisas agak, “Bin bɨ ñɨg aul ñɨŋnɨgal okok, kɨrop kauyaŋ ñɨg nen gɨnɨgab; ");
INSERT INTO kmh_m_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pen bin bɨ ñɨg yad ñen ñɨŋnɨgal okok, kɨrop kauyaŋ ñɨg nen ma gɨnɨgab. Pen ñɨg yad ñɨnɨgain nɨbak ñɨbel, kɨrop nab adaŋ ñɨg kɨlam kajoŋ rek julɨg gɨ, kɨrop per mɨdep ak ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jisas nɨb agek, bin nɨbak pen agak, “Bɨ kɨb. Yɨp ñɨg nɨbak ñek ñɨŋen, kɨsen yɨp ñɨg nen ma gɨnɨmɨŋ; apɨl ñɨg aul ma mɨlnɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nɨb agek, Jisas agak, “Am bɨ nagɨmɨl nak poŋɨd dowan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Agek agak, “Yad bɨ sek mer,” agak. Agek, Jisas agak, “Mɨnɨm nɨbak nɨŋɨd ageban. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bɨ aknɨb mamɨd alaŋ dɨnak ak pen bɨ mɨñi eip mɨdebir ak, bɨ nagɨmɨl nak mer. Nɨb ak, nɨŋɨd ageban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nɨb agek, bin nɨbak agak, “Bɨ kɨb. Yad nɨpin, nak bɨ God mɨnɨm agep bɨ alap. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Apɨs based cɨn bɨrarɨk nep okok dɨm aul God nop sobok gölɨgɨpal rek, cɨn ak rek nep sobok gɨ mɨdobɨn ak pen nɨbi Juda kai apɨm, ‘Jerusalem nep God nop sobok gɨnɨmel,’ apɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nɨb agek, Jisas agak, “Yad mɨnɨm nɨŋɨd agebin nɨbaul nɨŋan. Kɨsen dɨm nɨbaul abe Jerusalem abe Bapi nop ma sobok gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nɨbi Sameria bin bɨ sobok gɨpɨm pen bɨ tigep bɨ rek nop sobok gɨpɨm ak ma nɨpɨm; pen cɨn Juda bin bɨ, Bɨ sobok gɨpɨn Bɨ ak nɨpɨn. Tari gɨnɨg: God ne titi gɨl bin bɨ dɨ komɨŋ yoknɨgab ak, cɨnop Juda bin bɨ agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ñɨn ulep apeb, pen mɨñi bɨr owɨp aul, God Kaun ne bin bɨ gos ñek nɨŋlɨg gɨ, kɨri Bapi nop yɨpɨd gɨl sobok gɨnɨgal; nɨg gɨnɨgal ak, nop tep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God ne Kaun mɨdeb ak me, bin bɨ God nop sobok gɨl, kaun kɨrop nab adaŋ nɨŋɨd nep sobok gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jisas nɨb agek, bin nɨbak pen agak, “Yad nɨpin, kɨsen Mesaia ak apɨl, cɨnop tap magɨlsek ag ñɨ tep gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Agek, Jisas agak, “Bɨ nɨbak me yad mɨdebin. Nak eip mɨnɨm agobɨr me aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas nɨb agek nɨŋlɨg gɨ won nɨbak bɨ ne okok apjakɨl nɨŋlak, Jisas bin alap eip mɨnɨm ag mɨderek, nɨŋɨl kɨri pak ju dɨlak. Pen bɨ kɨri alap warɨkɨl, bin ak nop “Nak mɨnɨm tari mɨdeb?” agɨl ma aglak. Jisas nop ak rek nep, “Tari gɨnɨg bin nɨbak eip mɨnɨm dai dai agesan?” agɨl ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pen bin nɨbak, ñɨg tin ak kɨrɨg gɨl, kauyaŋ adɨk gɨ taun nɨbak amɨl, bin bɨ mɨdelak nɨb okok kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Apɨl, tap okok magɨlsek gɨpin rek ag ñɨb bɨ ak nɨŋɨm! Ne Mesaia ak aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nɨb agek, bin bɨ nɨb okok taun nɨbak kɨrɨg gɨl, Jisas nop nɨŋɨn, agɨl, apelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pen Jisas bɨ ne okok Jisas nop neb neb gɨl aglak, “Mɨnɨm ag ñeb bɨ. Tap ñɨŋan!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Agelak, ne pen agak, “Tap ñɨŋeb yad mɨdeb ak nɨbi ma nɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nɨb agek, bɨ ne okok kɨri ke nep ag nɨŋ ag nɨŋ gɨl aglak, “Bin bɨ ognap nop tap magɨl dap ñɨbal aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pen Jisas kɨrop agak, “Nɨbep tap magɨl nɨb okok nen gɨp; yɨp pen tap magɨl nɨb okok nen ma gɨp. Bapi mɨnɨm agak ak nep gos gɨp ak me, gos nɨbak nɨŋɨl, ne yɨp wög ag lɨp nɨbak gɨ juin, agɨl gos nɨpin. Tap ñɨŋeb yad me ak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pen nɨbi mɨnɨm alap apɨm, ‘Takɨn omal omal mɨdɨl, wid magɨl pok gek am tɨk donɨgabɨn,’ apɨm ak pen mɨñi nɨg ma agnɨmɨb. Udɨn nɨbi ke sɨŋak nɨŋ padɨklɨg nɨŋɨm! Wid wög okok bɨr pok gɨl tɨk dowep rek mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pen mɨñi nep, bin bɨ wid pok tɨk dopal bin bɨ okok, mɨñ mɨñ gɨlɨg gɨ wid pok gɨp nɨbak tɨk dam komɨŋ per mɨdep mɨgan ak lɨl, saj kɨri dɨpal me ak. Nɨb ak me, bin bɨ wid magɨl tanaŋ, agɨl, dam yokpal okok abe, bin bɨ wid pok gɨp tɨk dopal okok abe jɨm ñɨl, wid pok ak komɨŋ per mɨdep mɨgan ak mɨdenɨgab ak nɨŋɨl, mɨñ mɨñ gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cɨn mɨnɨm alap apɨn, ‘Bin bɨ ognap wid magɨl yokel tannɨgab, bin bɨ ognap am tɨk donɨgal,’ apɨn ak, nɨŋɨd yɨb apɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yad nɨbep ag yoken, am wid tɨk dapebɨm. Wid wög dai nɨbak nɨbi wög kɨlɨs gɨl ma gɨpɨm; bin bɨ ognap kɨlɨs kɨri ak gel tanɨb. Nɨbi yokop am tɨk dapɨl tap tep ak debɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bin Sameria nɨb nɨbak am bin bɨ ne okok kɨrop agak, “Bɨ nɨbak tap gɨpin gɨpin okok magɨlsek yɨp ag ñɨb,” agak ak me, bin bɨ Sameria nɨb taun nɨbak mɨdelak okok koŋai nep Jisas nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pen Sameria bin bɨ, kɨri Jisas mɨdek sɨŋak apɨl, Jisas mɨnɨm neb neb gɨl aglak, cɨn eip am mɨdon, agel, Jisas ñɨn omal am kɨri eip mɨdɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","mɨnɨm ag ñek, bin bɨ ognap sek koŋai nep mɨnɨm nɨbak nɨŋɨl nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pen kɨri nɨg gɨl nɨŋ dɨl, bin nɨbak nop aglak, “Mɨñi mɨnɨm nak ak nep agek cɨn ma nɨŋ dɨpɨn; Jisas mɨnɨm ne ak ke agek nɨŋɨl nɨpɨn, ne nep bin bɨ karɨp lɨm ar wagɨn aul mɨdebal tɨgoŋ tɨgoŋ magɨlsek kɨrop dɨ komɨŋ yoknɨg owak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas ñɨn nɨb omal karɨp lɨm nɨbak mɨdɨl, mɨnek karɨp lɨm Galili amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ne ned mɨnɨm alap agɨl agak, “Bɨ God mɨnɨm agep bɨ okok, karɨp lɨm kɨri ke sɨŋak mɨdɨl mɨnɨm agnɨgal ak, mɨnɨm kɨrop ma dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pen Pasopa ñɨn ak, Galili bin bɨ ognap am Jerusalem mɨdelak. Kɨri Jerusalem mɨdelak nɨŋlɨg gɨ, Jisas tap ma gep rek okok gek nɨŋlak ak me, Jisas mɨñi karɨp lɨm Galili amjakek, kɨri tap ma gep rek Jerusalem gak ak gos nɨŋɨl, nop mɨñ mɨñ gɨlɨg gɨ ag dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pen Jisas am Galili mɨdɨl, kauyaŋ Kena taun amnak. Kena taun nɨbak me, ned ñɨg yɨb ak gek ñɨg wain lak. Pen taun sɨkol Kapaneam sɨŋak, bɨ kɨb alap ñɨ ne tap gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bɨ kɨb nɨbak mɨnɨm alap nɨŋak, Jisas karɨp lɨm Judia kɨrɨg gɨl, ap karɨp lɨm Galili mɨdek. Nɨb ak, Jisas mɨdek ak apɨl, nop neb neb gɨlɨg gɨ agak, “Ñɨ yad ak tap gɨp kɨmnɨg geb. Nak kasek am nop gek komɨŋ laŋ!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nɨb agek, Jisas agak, “Nɨbi yokop yɨp ma nɨŋ dɨnɨgabɨm; tap ma gep rek ognap gen nɨŋɨl nep, yɨp nɨŋ dɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pen bɨ kɨb nɨbak agak, “Bɨ Kɨb! Apek amnɨr! Mer ak, ñɨ yad ak kɨmnɨgab!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Agek, Jisas pen agak, “Amnoŋ! Ñɨ nak ak komɨŋ lɨl mɨdenɨgab,” agak. Nɨb agek, Jisas nɨŋɨd agɨp, agɨl, paŋdak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kanɨb nab sɨŋak amek nɨŋlɨg gɨ, bɨ wög gɨ ñeb ne ognap apɨl nop nabɨŋ pakɨl aglak, “Ñɨ nak ak ma kɨmɨb; mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nɨb agelak, ñɨ yad ak won akal rek komɨŋ lɨp, agɨl, kɨrop ag nɨŋek aglak, “Tol pɨb kim gak won ak, wak pɨboŋ gak ak komɨŋ lak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nɨb agelak bɨ nap ne nɨŋak, Jisas, “Ñɨ nak ak komɨŋ lɨl mɨdenɨgab,” agak won ak nep komɨŋ lak. Nɨb ak me, bin bɨ ne okok eip magɨlsek Jisas nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pen Jisas ne ned Kena apɨl, tap ma gep ned nɨb gɨl, ñɨg yɨb ak gek adɨk gɨl ñɨg wain lak; kɨsen pen tap ma gep yɨgwu nab nɨb ak gɨl bɨ kɨb ak ñɨ ne nop gek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kɨsen pen Juda kai tap kɨb ñɨŋeb ñɨn ak mɨñi, agɨl, Jisas Jerusalem amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Karɨp lɨm Jerusalem nɨbak, kaj sipsip dap amɨl apɨl gɨpal kɨjoŋ tam gol sɨŋak ñɨg cöb kɨb alap mɨdeb. Ñɨg cöb nɨbak Arameik mɨnɨm lɨl, Betesda apal. Pen ñɨg gol omal omal abe ñɨg kɨbɨŋ nab sɨŋak mɨdeb ar ak abe, karɨp badak par aknɨb mamɨd alaŋ mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pen bin bɨ tap gak okok koŋai nep ap karɨp badak nɨb okok kɨn mɨdelak. Bin bɨ nɨb okok, ognap udɨn kwoi gak, ognap tob tɨmel gak nɨŋɨl ma ajölɨgɨpal, ognap mɨb goŋ kɨri pɨs nep kalau gak. Pen ñɨg cöb ak kaun gɨnɨgab aka agɨl, apɨl kod mɨdlɨg gɨ kɨn mɨdölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ñɨn ognap God ejol alap apɨl, ñɨg cöb ak dɨ kaun gek, bin bɨ an ned preŋɨd ñɨg cöb nɨb eyaŋ yapolɨgɨp ak, nop tap tari golɨgɨp ak komɨŋ lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pen bɨ alap tap gek, per nep kɨm mɨdek, mɨ yɨn ñɨn juɨl nokɨm alap adɨk gɨ dam kagol pɨs adaŋ (38) lak, ñɨg cöb gol sɨŋak dap lɨlak kɨn mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas bɨ nɨbak nɨŋɨl, mɨlek padek nɨg gɨlɨg gɨ mɨdolɨgɨp ak nɨŋɨl, nop agak, “Yɨp komɨŋ lɨnɨmɨŋ, agɨl, nɨpan aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Agek, bɨ tap gak nɨbak agak, “Bɨ kɨb. Ñɨg ak kaun gek nɨŋlɨg gɨ, yɨp dɨ ñɨg cöb nab eyaŋ lɨnɨmel bin bɨ alap ma mɨdebal. Yad ñɨg nab eyaŋ ned amnɨm ag gos nɨpin ak pen bin bɨ ognap kasek nep ned ambal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nɨb agek, Jisas pen nop agak, “Warɨkɨl, mɨj nak pɨyak wɨnɨg dad amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Agek, won nɨbak nep nop komɨŋ lek nɨŋlɨg gɨ, warɨkɨl mɨj ne ak wɨnɨg dɨl, dad amnak. Pen Jisas bɨ nɨbak nop gek komɨŋ lak ñɨn nɨbak, Juda kai God nop sobok gep ñɨn kɨri ak me, ");
INSERT INTO kmh_m_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda bɨ kɨb okok, bɨ komɨŋ lak nɨbak nop aglak, “Ñɨn aul God nop sobok gep ñɨn cɨn. Pen nak mɨj bad nak ak dad ajeban ak, lo mɨnɨm cɨn ak mer agɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Agelak, agak, “Bɨ yɨp gosɨp komɨŋ lɨp ak agɨp, ‘Warɨkɨl, mɨj bad nak ak wɨnɨg dad amnoŋ,’ agosɨp ak me, dad ajebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Agek, aglak, “Bɨ nep agek, mɨj bad wɨnɨg dad ajeban bɨ nɨbak bɨ an?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pen Jisas ne bin bɨ koŋai mɨdelak nab nɨb sɨŋak kapkap amnak rek, bɨ komɨŋ lak nɨbak, bɨ yɨp gɨp komɨŋ lɨp me aul, agɨl, agnɨmɨŋ rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kɨsen pen, Jisas bɨ nɨbak nop God sobok gep karɨp mɨgan ak nɨŋɨl agak, “Nɨŋan! Nep komɨŋ lɨp. Nɨb ak, tap si tap tɨmel gölɨgɨpan ak kɨrɨg gɨnɨmɨn. Mer ak, nep tap kɨb yɨb gɨnɨmɨŋ rek lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pen bɨ nɨbak ne adɨk gɨ amɨl, Juda bɨ kɨb okok kɨrop agak, “Jisas nep yɨp gɨp komɨŋ lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nɨb agek nɨŋɨl, God nop sobok gep ñɨn ak gek komɨŋ lak, agɨl, Juda bɨ okok Jisas nop mɨlɨk kal nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas pen kɨrop agak, “Bapi yad ak per nep wög gɨlɨg gɨ nep mɨdeb rek, yad ak rek nep gɨnɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nɨb agek, Juda bɨ kɨb okok, ned nop ñagɨn, agɨl gos nɨŋlak ak, mɨñi kɨlɨs yɨb gɨl nɨŋlak. Kɨri aglak, “Ne God nop sobok gep ñɨn cɨn ak tɨb rɨkɨl, ‘Yad God Ñɨ ne,’ agɨp. Nɨb ak, God ne mɨdeb rek, yad nɨb aknɨb rek nep mɨdebin, agɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas pen kɨrop agak, “Nɨbep nɨŋɨd agebin, Ñɨ ak ne ke tap alap gɨnɨmɨŋ rek ma lɨp; Nap tap gɨnɨgab okok nep nɨŋɨl gɨnɨgab. Nɨb ak, Nap gɨnɨgab rek, Ñɨ ne ak rek nep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nap Ñɨ ne nop mɨdmagɨl lɨl, tap ne geb geb okok magɨlsek yomeb. Nap ognap sek abe yomek me, Ñɨ ne tap ke yɨb okok gek nɨŋɨl, nɨbi magɨlsek wal agnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pen Nap bin bɨ kɨmbal okok gek warɨkpal rek, Ñɨ ne ak rek nep, bin bɨ ognap, kɨrop gen warɨklaŋ, agnɨgab ak, gek warɨknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bin bɨ tari tari gɨpal, gos tari tari nɨpal ak, Nap nɨŋɨl kɨrop mɨnɨm kɨb ma agnɨgab; Ñɨ ne nop agek, ne kɨrop magɨlsek mɨnɨm kɨb agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nɨb ak me, bin bɨ kɨri Nap yɨb ne agel ar amnɨgab ak rek, Ñɨ ne yɨb ak abe ak rek nep agel ar amnɨgab. Pen bin bɨ God Ñɨ ne ak nop nɨŋɨl, yɨb ne agel ar ma amnɨgab okok, Nap Ñɨ ne ag yokak ak abe, ak rek nep yɨb agel ar ma amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nɨbep nɨŋɨd agebin, bin bɨ an mɨnɨm yad ak nɨŋɨl, Bɨ yɨp ag yokek onek ak nop nɨŋ dɨpal okok, mɨnɨm kɨb ag yur dep ar ak ma nɨŋnɨgal; kɨri komɨŋ per mɨdep magɨl ak bɨr dɨpal. Nɨb ak, kɨri kɨmeb magɨl ar ak kɨrɨg gɨl, komɨŋ per mɨdep ar ak bɨr mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nɨbep nɨŋɨd yɨb agebin, ñɨn kɨsen per kod mɨdebɨm ak maŋ apeb—pen mɨñi bɨr owɨp aul—bin bɨ kɨmɨl rek mɨdebal okok, God Ñɨ ne mɨnɨm agek, mɨnɨm nɨbak nɨŋɨl nɨŋ dɨnɨgal okok, komɨŋ lɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bapi tap okok magɨlsek komɨŋ mɨdep wagɨn ak mɨdeb rek, yad Ñɨ ne ak rek nep komɨŋ mɨdep wagɨn ak mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yad Ñɨ ne pen, Bɨ Ñɨ ne mɨdebin rek, yɨp agek, bin bɨ okok kɨrop mɨnɨm kɨb agɨl nonɨm lɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mɨnɨm agebin nɨbak nɨŋɨl wal ma gɨnɨmɨb: kɨsen yad agen, bin bɨ kɨmel tɨgel gɨpal okok, ");
INSERT INTO kmh_m_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","magɨlsek mɨnɨm yad nɨŋɨl, warɨkɨl, bin bɨ gɨ tep gɨpal okok, am yad eip komɨŋ mɨdenɨgal; pen bin bɨ gɨ tɨmel gɨpal okok, warɨkɨl mɨnɨm kɨb nɨŋɨl pen yur kɨb dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Pen yad tap tari tari gɨnɨgain okok, ke nɨŋɨl ma gɨnɨgain; Bapi yɨp agnɨgab rek nep gɨnɨgain. Nɨb ak, bin bɨ mɨnɨm kɨb agɨl nonɨm lɨnɨgain ak, Bapi agnɨgab rek nɨŋɨl, yɨpɨd gɨl nep nonɨm lɨnɨgain. Tari gɨnɨg: yɨp tep gɨnɨgab ar ak mɨnɨm kɨb ma agnɨgain. Bɨ yɨp ag yokek onek Bɨ nɨbak nop tep gɨnɨgab ar ak nep gos nɨŋɨl, mɨnɨm kɨb agɨl nonɨm lɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yad ke, ‘God yɨp ag yokek opin,’ apnep ak, mɨnɨm nɨbak yɨpɨd gɨl ma mɨdeb apkep. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pen Bɨ alap sek yad bɨ tigep bɨ rek mɨdebin ak ageb. Yad nɨpin, mɨnɨm ageb nɨbak nɨŋɨd nep ageb. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nɨbi Juda kai bɨ nɨbi ognap ag yokem, kɨri Jon nop amɨl, yad bɨ tigep bɨ rek mɨdebin, agɨl, ag nɨŋlak ak, ne mɨnɨm nɨŋɨd nep kɨrop agak me ak. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jon aka bɨ karɨp lɨm ar wagɨn aul bɨ alap yad bɨ tigep bɨ rek mɨdebin agnɨgab ak, yɨp tap kɨb mer. Pen nɨbi Jon mɨnɨm agak ak nɨŋɨl, mɨnɨm nɨŋɨd yɨb, agɨl, nɨŋ dɨl, komɨŋ amnɨgabɨm, agɨl, Jon mɨnɨm yɨp nɨg gɨl agak, agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon mɨnɨm agak ak, ne sɨp mɨlaŋ melɨk ñeb rek mɨdek, nɨbi mɨnɨm agak nɨbak melɨk rek nɨŋɨl, won sɨkol ulep won alap nep mɨñ mɨñ gɨpek. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon nɨbep ag tep gak pen ak yokop mɨnɨm nep agak. Yad lɨm dai wagɨn aul apɨl, Bapi yɨp gɨnɨmɨn agak rek, tap ke yɨb okok gebin ak me, nɨbi Bapi ne nep yɨp ag yokɨp ak, agɨl, mɨseŋ yɨb nɨpkep. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bapi yɨp ag yokak ak, ne ke, yad bɨ tigep bɨ rek mɨdebin ak, nɨbep mɨnɨm nɨŋɨd ageb. Pen nɨbi meg mɨgan ne ak peyɨg ma nɨpɨm. Ne bɨ tigep bɨ rek mɨdeb ak, agɨl, ma nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nɨbi yad bɨ ne ag yokak mɨnɨm yad ak ma nɨŋ dɨpɨm rek, God Mɨnɨm mɨdmagɨl nɨbep nab adaŋ ma mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Nɨbi, komɨŋ per mɨdep magɨl dɨn, agɨl, God Mɨnɨm ak udɨn lɨ nɨŋ tep gɨpɨm ak pen mɨnɨm nɨbak, yɨp agɨl ñu kɨl tɨklak rek nɨŋɨl, komɨŋ per mɨdep magɨl dɨn, agɨl, yɨp ma apebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Bin bɨ okok yɨb yɨp agel ar amnaŋ, agɨl, ma agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pen nɨbi bin bɨ tigep bɨ rek mɨdebɨm ak bɨr nɨpin. Nɨbi God nop mɨdmagɨl ma lɨpɨm ak nɨŋɨl agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bapi ne ke yɨp ag yokek opin ak pen nɨbi yɨp ma dɨpɨm. Pen bɨ yokop alap gos ne ke nɨŋɨl apenɨgab ak, nop dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bin bɨ ognap okok yɨb kɨri agel ar amenɨgab ak, nɨbep tep gɨnɨgab. Pen Bɨ God nokɨm nep mɨdeb ak cɨnop nɨŋek tep gɨnɨmɨŋ, agɨl, gos ar ak ma nɨpɨm. Nɨb ak, nɨbi titi gɨl yɨp nɨŋ dɨnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Pen Bapi mɨnɨm yad dɨl, nɨbep mɨnɨm kɨb agnɨgab, agɨl, gos ak ma nɨŋnɨmɨb, mer. Mosɨs cɨnop gɨ ñɨnɨgab apɨm ak pen Bapi ne Mosɨs mɨnɨm ne agak mɨnɨm nɨbak dɨl nɨbep mɨnɨm kɨb agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosɨs ne God Mɨnɨm ñu kɨl tɨkɨl mɨnɨm ognap yad bɨ tigep bɨ rek mɨdebin mɨnɨm ak ñu kɨl tɨkak. Pen Mosɨs mɨnɨm ñu kɨl tɨkak mɨnɨm nɨbak ma dɨpɨm rek, mɨnɨm yad agebin ak rek nep ma dɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mosɨs mɨnɨm ñu kɨl tɨkak ma dɨpɨm rek, nɨbi ti gɨl mɨnɨm yad agebin ak dɨnɨgabɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pen Jisas nɨg gɨ mɨdɨl, kɨsen ñɨg magöb dɨl, Ñɨg Cöb Galili juɨl, pɨs kɨdadaŋ amnak. Ñɨg Cöb Galili nɨbak nep me, yɨb alap Ñɨg Cöb Taibirias apal. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pen Jisas ne bin bɨ tap gak okok gek komɨŋ lak ak nɨŋölɨgɨpal rek, bin bɨ koŋai nep nop kɨsen gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pen Jisas bɨ ne okok eip am dɨm sɨŋak alaŋ amɨl, bɨsɨg mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ñɨn nab nɨb sɨŋak Juda kai Pasopa ñɨn kɨb kɨri ak ulep ulep gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Jisas bɨ ne eip dɨm sɨŋak bɨsɨg mɨdɨl, udɨn kɨlan gɨl nɨŋak, bin bɨ koŋai sɨkerek yɨb nep nop apelak. Jisas nɨŋɨl, ne tari tari gɨnɨgab ak ke nɨŋak ak pen bɨ ne Pilip tari agnɨgab, agɨl, nop agak, “Cɨn tap magɨl akal nɨb dɨl, bin bɨ koŋai nep sɨŋ aul kɨrop ñon ñɨŋnɨmel?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Agek, Pilip pen agak, “Kab magɨl silpa won aknɨb ñɨn juɨl wajrem alaŋ (200) rek yokɨl, bred tau dapɨl, dɨ pag gɨl sɨkol sɨkol gɨl, bin bɨ nɨb sɨŋ aul ñon, magɨlsek tap sɨkol sɨkol ñɨbenɨmel rek lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nɨb agek, bɨ ne Edru, Saimon Pita nɨmam ak agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ñɨ sɨkol alap bred bali plaua dɨ dagɨlpal bred won aknɨb mamɨd alaŋ, kɨbsal omal sek dɨ mɨdeb aul, pen tap nɨbak bin bɨ koŋai yɨb sɨŋ aul tap kɨb mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Agek, Jisas agak, “Bin bɨ okok agem bɨsɨglaŋ,” agak. Agek, bɨ ne okok bin bɨ okok kɨrop agelak, tap kas koŋai nep tan tep gak ain ar nɨb sɨŋak magɨlsek bɨsɨgel amnak. Bɨ okok nep me paip tausan (5000) rek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kɨri nɨg gɨl bɨsɨglak nɨŋɨl, Jisas bred won nɨb okok dɨl, God nop tep agɨl, kɨrop nonɨm lɨ ñak. Kɨbsal ak, ak rek nep gak. Kɨrop nɨg gɨl nonɨm lɨ ñek, bin bɨ okok kɨri magɨlsek bred kɨbsal titi rek dɨjɨn agɨl gos nɨŋlak ak rek nep dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nɨg gɨl ñɨbel ñɨbel kogi gek kɨrɨg gɨlak. Jisas bɨ ne okok kɨrop agak, “Bin bɨ tap ñɨbɨl kɨrɨg gɨpal okok, dɨ adaŋ aul ma gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Agek, bɨ ne okok bred dai dai okok yɨprɨg wad yɨgel yɨgel, wad aknɨb umɨgan alaŋ ak ap ran jakak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bin bɨ okok Jisas tap ma gep rek gak nɨbak nɨŋɨl aglak, “Cɨn mɨñi nɨpɨn, bɨ aul me, Bɨ God Mɨnɨm Agep lɨm dai wagɨn aul onɨgab agɨl per agobɨn bɨ me ak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pen Jisas nɨŋak, bin bɨ okok, yɨp kiŋ bɨ kɨb kɨri mɨdenɨm, agɨl, apɨl yɨp kɨlɨs gɨl dad amnɨgal, ag gos nɨŋɨl, ne kauyaŋ amɨl dɨm okok ne ke ausek mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pen dɨgep won ak, Jisas bɨ ne okok am Ñɨg Cöb Galili eyaŋ amɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jisas ma owak rek, kɨslɨm gek, kɨri nep ñɨg magöb dɨl kauyaŋ taun sɨkol Kapaneam amnɨg paŋdɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Amelak nɨŋlɨg gɨ, yɨgen kɨb dɨl, ñɨg ak pagak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pen kɨri tapɨn ñɨg magöb ñɨg kas parɨk nab sɨŋak kilomita aknɨb mamɨd alaŋ aka kagol oŋɨd amɨl nɨŋlak, Jisas ñɨg ar sɨŋak tauɨd apek. Kɨri nɨŋɨl mɨdmagɨl kɨb amnak nɨŋɨl pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pen Jisas agak, “Nɨbi ma pɨrɨknɨmɨb. Yad nep apebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nɨb agek, kɨri ma pɨrɨkɨl, nop dɨ ñɨg magöb mɨgan ak lel nɨŋlɨg gɨ, ñɨg magöb ak mɨñi nep karɨp lɨm amnɨg gɨlak mɨgan ak amjakak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mɨnek bin bɨ Ñɨg Cöb Galili pɨs kɨdadaŋ kɨnlak okok gos nɨŋɨl nɨŋlak, tol dɨgep ñɨg magöb nokɨm alap nep mɨdek nɨŋɨl Jisas bɨ ne okok nep ñɨg magöb nɨbak amnɨlak; Jisas ne ke ñɨg magöb nɨbak ma amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mɨdel nɨŋlɨg gɨ, ñɨg magöb ognap bin bɨ ognap taun kɨb Taibirias nɨb apɨl, Bɨ Kɨb ne God nop tep agɨl tap ñek ñɨŋlak kau ak ñɨg gol sɨŋak ap wös gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pen bin bɨ mɨdelak okok nɨŋlak, Jisas abe bɨ ne okok abe ma mɨdelak; nɨbak Jisas nop pɨyo nɨŋɨn, agɨl, kɨri ñɨg magöb nɨb okok amɨl Kapaneam amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ñɨg Cöb Galili am am pɨs kɨdadaŋ amjakɨl, Jisas nop nɨŋɨl aglak, “Mɨnɨm ag ñeb bɨ. Nak won akal aul opan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Agelak agak, “Nɨbep mɨnɨm nɨŋɨd agebin, bred ñen ñɨbem kogi gak rek, yɨp pɨyo nɨŋ ajebɨm; pen tap ma gep rek gɨpin okok mɨnɨm wagɨn ak nɨŋɨl yɨp pɨyo nɨŋ ma ajebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tap magɨl ki gɨ yonɨg geb ak dɨn, agɨl, wög kɨlɨs ma gɨnɨmɨb; God ne Bɨ Ñɨ ne nɨŋebir agek owɨp rek, tap magɨl per mɨdep ne ñɨnɨgab ak dɨn, agɨl, wög kɨlɨs gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nɨb agek aglak, “Cɨn wög tari gon, God nop tep gɨnɨgab?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Agelak, Jisas agak, “God ne Bɨ ag yokek owɨp ak, Bɨ nɨbak nop nɨŋ dɨnɨgabɨm ak, God nop tep gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nɨb agek aglak, “Cɨn tap ma gep rek alap nɨŋnɨgabɨn ak, agnɨgabɨn, ‘God nep nep ag yokɨp,’ agɨl, nep nɨŋ dɨnɨgabɨn. Nɨb ak, cɨnop tap ma gep tari rek gɨnɨgaban? ");
INSERT INTO kmh_m_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bɨrarɨk nep apɨs based sɨkop mɨñ mab kab nep mɨdolɨgɨp nab okok mɨdɨl, tap mana agölɨgɨpal ak ñɨbelɨgɨpal. God Mɨnɨm ñu kɨl tɨkɨl aglak, ‘Ne bred seb kab ar alaŋ sɨŋak nɨb ognap kɨrop ñek ñɨbelɨgɨpal,’ aglak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nɨb aglak ak pen Jisas kɨrop pen agak, “Nɨbep mɨnɨm nɨŋɨd yɨb agebin, Mosɨs bɨrarɨk okok bred kɨrop ñek ñɨŋlak bred nɨbak, bred seb kab ar alaŋ sɨŋak nɨb mer. Bred seb kab ar alaŋ sɨŋak nɨb bred nɨŋɨd nɨbak, Bapi yad nɨbep ñeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God bred ne ak, God ag yokek, seb kab ar alaŋ sɨŋak nɨb lɨm dai wagɨn aul apɨl, bin bɨ okok kɨrop komɨŋ mɨdep won ak ñeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jisas nɨb agek aglak, “Bɨ Kɨb. Mɨñi bred nɨbak cɨnop per nep ñɨlɨg gɨ nep mɨdenɨmɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Agelak, Jisas agak, “Yad nep me bred komɨŋ mɨdep bred nɨbak. Bin bɨ yɨp onɨgal okok, kɨrop kauyaŋ yuan ma gɨnɨgab. Bin bɨ yɨp nɨŋ dɨnɨgal okok, kɨrop kauyaŋ ñɨg nen ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pen nɨbep mɨdarɨk nep ag ñesin ak, yɨp udɨn nɨpɨm ak pen yɨp ma nɨŋ dɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bapi yɨp agɨp bin bɨ okok kɨri magɨlsek yɨp onɨgal. Bin bɨ yɨp onɨgal okok, ma ag yoknɨgain, mer yɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pen tari: yad seb kab ar alaŋ sɨŋak nɨb opin ak, gos yad nɨpin ar ak gɨnɨm, agɨl, ma opin; Bapi yɨp ag yokɨp ak, gos ne nɨŋɨl agɨp rek gɨnɨm, agɨl, opin. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bapi bin bɨ yɨp agɨp okok kɨrop nɨŋ mɨden, alap ma kɨr gɨnɨmɨŋ; mɨnɨm kɨb agep ñɨn ak, yad gen, kɨri magɨlsek warɨknɨmel. Nɨg gɨnɨgab ak, Bapi yɨp ag yokak ak, nop tep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bapi yad nop tep gɨnɨgab ak, bin bɨ an an yɨp nɨŋɨl nɨŋ dɨnɨgal okok, kɨri magɨlsek per per nep komɨŋ mɨdenɨgal. Pen mɨnɨm kɨb agep ñɨn ak, yad ke gen kɨri magɨlsek warɨknɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pen Jisas, “Yad me, bred seb kab ar alaŋ sɨŋak nɨb opin ak,” agak ak me, Juda bin bɨ okok mɨnɨm ali gɨrɨra gɨrɨra gelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Juda bin bɨ okok ali gɨrɨra gɨrɨra gɨl aglak, “Bɨ aul, nonɨm nap ne ak cɨn ke nɨpɨn. Ne Josep ñɨ ne Jisas nep. Nɨb ak, ne titi gɨ agɨp, ‘Yad seb kab ar alaŋ sɨŋak nɨb opin,’ agɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nɨb agelak, Jisas pen agak, “Ali gɨrɨra gɨrɨra ma gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Bin bɨ alap ne ke yɨp ma nɨŋ dɨnɨgab. God nop gos tep ñek nep me, yɨp apek, mɨnɨm kɨb agep ñɨn kɨsen ak yad gen ne kauyaŋ warɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bɨ God mɨnɨm agep bɨ okok kɨri God Mɨnɨm ñu kɨl tɨkɨl aglak, ‘God ne bin bɨ nɨb okok magɨlsek kɨrop ag ñɨnɨgab,’ aglak. Bin bɨ Bapi kɨrop mɨnɨm ag ñek nɨŋ dɨnɨgal okok, kɨri magɨlsek yɨp onɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bin bɨ ognap kɨri God nop udɨn ma nɨpal; yad Bɨ ne ag yokek onek ak nep Bapi nop udɨn nɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Pen yad nɨbep nɨŋɨd yɨb agebin, bin bɨ yɨp nɨŋ dɨnɨgal okok, komɨŋ per mɨdep won nɨbak bɨr dɨl, per per nep mɨdenɨgabal. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bred ñɨbɨl komɨŋ mɨdenɨgal ak, yad me bred nɨbak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nased yes sɨkop bɨrarɨk nep mɨñ mab kab nep mɨdolɨgɨp nab okok mɨdɨl, tap mana ak ñɨŋlak ak pen mɨd damɨl kɨmlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pen bred Bɨñen ag yokek seb kab ar alaŋ nɨb apeb bred nɨbak, bin bɨ ñɨbɨl, komɨŋ per per nep mɨdɨl ma kɨmnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Yad ke bred komɨŋ seb kab ar alaŋ sɨŋak nɨb opin bred nɨbak. Bin bɨ an an bred nɨbaul ñɨb nab eyaŋ lɨnɨgal okok, per nep per nep komɨŋ mɨdenɨgal. Bred agebin nɨbaul mɨb goŋ yad ak me. Bin bɨ karɨp lɨm ar wagɨn aul mɨdebal kɨri per nep per nep komɨŋ mɨdenɨmel, agɨl, mɨb goŋ yad ak ñɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisas nɨb agek, Juda bin bɨ nɨb okok kɨri ke nep mɨnɨm pen pen agɨl, ognap aglak, “Bɨ aul titi gɨl, cɨnop mɨb goŋ ne ak ñek ñɨŋnɨgabɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Agelak, Jisas kɨrop agak, “Yad nɨbep nɨŋɨd yɨb agebin, nɨbi Bɨ Ñɨ ne mɨb goŋ ne, lakañ ne ma ñɨŋnɨgabɨm ak, komɨŋ mɨdep won ak nɨbep nab adaŋ ma mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bin bɨ an mɨb goŋ yad, lakañ yad ñɨŋnɨgab ak, ne komɨŋ per mɨdep won ak bɨr dɨp nɨŋɨl mɨnɨm kɨb agep ñɨn ak yad gen ne kauyaŋ warɨknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Pen tari: mɨb goŋ yad ak tap ñɨŋeb yɨb; lakañ yad ak ñɨg ñɨŋeb yɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bin bɨ an an mɨb goŋ yad lakañ yad ñɨŋnɨgal okok, yad nab adaŋ mɨdenɨgal; yad kɨrop nab adaŋ mɨdenɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bapi per per nep komɨŋ mɨdeb ak, ne yɨp ag yokɨp Bapi nɨbak, ne yɨp gek komɨŋ mɨdebin ak me, bin bɨ yɨp dɨ nab kɨri adaŋ lɨnɨgal okok, kɨrop ak rek nep gek, komɨŋ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mɨnɨm ar nɨbak me, bred seb kab ar alaŋ sɨŋak nɨb owɨp, agɨl agesin. Bred nɨbak, apɨs based sɨkop tap mana agölɨgɨpal ak ñɨbɨl mɨd damɨl kɨmlak rek mer; bin bɨ bred yad agesin aul kɨri ñɨb nab eyaŋ lɨnɨgal ak, komɨŋ per nep per nep mɨdenɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas Juda mogɨm gep karɨp Kapaneam sɨŋak mɨdɨl, mɨnɨm nɨbak agek, ");
INSERT INTO kmh_m_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","bin bɨ ne okok koŋai nep nɨŋɨl aglak, “Jisas mɨnɨm ageb nɨbak mɨnɨm kɨlɨs yɨb. Mɨnɨm ne nɨŋ dɨjɨn rek ma lɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kɨri ali gɨrɨra gɨrɨra gɨl agelak, Jisas ke nɨŋɨl agak, “Mɨnɨm agesin nɨbak nɨŋɨl gos par nɨŋɨl kɨrɨg gɨn ag gos nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pen Bɨ Ñɨ ne seb kab ar alaŋ sɨŋak mɨdɨl owak ak, ne kau nɨb ar sɨŋak alaŋ kauyaŋ adɨk gɨ amenɨgab ak, nɨbi gos tari nɨŋnɨgabɨm? ");
INSERT INTO kmh_m_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God Kaun komɨŋ mɨdep won ak ñek, bin bɨ komɨŋ lɨnɨgal; bin bɨ kɨlɨs kɨri ke komɨŋ ma lɨnɨgal, mer yɨb. Yad mɨnɨm nɨbep agesin ak, mɨnɨm nɨbak gek, God Kaun ne nɨbep apɨl, komɨŋ mɨdep won ak nɨbep ñɨnɨgab nɨŋɨl nɨbi komɨŋ lɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pen Jisas ne ned nep, bin bɨ an nop ma nɨŋ dɨnɨgab, an nop mɨmɨg nɨŋnɨgab ak nɨŋak ak me, ne agak, “Nɨbi ognap yɨp ma nɨŋ dɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pen mɨnɨm ognap sek agɨl agak, “Ar nɨbak nep nɨbep apin, bin bɨ alap gos ne ke nep nɨŋɨl yɨp ma nɨŋ dɨnɨgab; Bapi nep genɨgab ak me, bin bɨ alap yɨp apɨl yɨp nɨŋ dɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas mɨnɨm nɨbak ag juek nɨŋlɨg gɨ, bin bɨ apɨl mɨnɨm nop nɨŋölɨgɨpal okok, koŋai nep nop kɨrɨg gɨl, ke ke amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nɨg gɨl amel nɨŋlɨg gɨ, Jisas bɨ ne aknɨb umɨgan alaŋ okok kɨrop ag nɨŋɨl agak, “Nɨbi ak rek nep yɨp kɨrɨg amnɨgabɨm aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Agek, Saimon Pita agak, “Bɨ Kɨb. Bɨ an nop amjɨn? Mɨnɨm nak ageban ak nɨŋɨl me, per per nep komɨŋ mɨdonɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cɨn nep nɨŋ dɨpɨn rek, cɨn nɨpɨn, God ne Bɨ Sɨŋ cɨnop ag yokɨp ak, nak Bɨ nɨbak me ak, agɨl nɨpɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","71","Saimon Pita nɨb agek, Jisas pen Saimon Iskariot ñɨ ne Judas ak, kɨsen nop mɨmɨg nɨŋnɨgab ak nɨŋɨl, kɨrop agak, “Yad nɨbep bɨ aknɨb umɨgan alaŋ dɨpin ak pen bɨ nɨbi nokɨm alap kɨjeki bɨ ne,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kɨsen pen Juda bɨ kɨb okok Jisas nop ñagnɨg gelak nɨŋɨl Jisas karɨp lɨm Judia okok ma ajolɨgɨp; karɨp lɨm Galili okok nep ajolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pen Juda ñɨn kɨb kɨri, karɨp badak sɨkol gɨ lɨl ñɨn ognap kɨnbal ñɨn ak maŋ maŋ gek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisas nɨmam kɨsen okok mɨdek sɨŋak apɨl nop aglak, “Nak mɨgan nɨbaul kɨrɨg gɨl karɨp lɨm Judia amɨl, bin bɨ mɨnɨm nep nɨŋ dɨpal okok ak rek nep tap ma gep rek geban okok ognap nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bɨ kɨri bɨ kɨb mɨdon agnɨgal okok, tap kɨri okok we gɨl ma gɨnɨgal; mɨseŋ yɨb gɨnɨgal. Nɨb ak, nak tap ke yɨb gɨpan rek, bin bɨ koŋai mɨdebal nab sɨŋak tap ma gep ognap gek, bin bɨ magɨlsek nɨŋnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pen Jisas nɨmam kɨsen ne ke okok nop ma nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nɨb agelak, Jisas kɨrop pen agak, “Nɨbi ñɨn akal amnɨgabɨm ak amnɨgabɨm; pen ñɨn yad ameb ak ma owɨp nɨŋɨl adi mɨñi ma amnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bin bɨ lɨm dai ar wagɨn aul okok, nɨbep bɨ mɨlɨk kal nɨŋnɨmel wagɨn alap ma mɨdeb. Pen yad bin bɨ lɨm dai ar wagɨn aul okok tap si tap tɨmel gɨpal ak ag mɨseŋ len yɨp mɨlɨk kal nɨŋebal. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɨb ak, Karɨp Badak ñɨn kɨb maŋ apeb rek, nɨbi Jerusalem amnɨmɨb; pen yad ñɨn ameb ak ma owɨp rek, yad eip ma amnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nɨb agɨl, ne karɨp lɨm Galili mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pen Jisas nɨmam sɨkop okok Jerusalem amnɨlak nɨŋɨl Jisas ne kapkap sain amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda bɨ kɨb okok, “Jisas akal?” agɨl, bin bɨ koŋai nep ap mɨdelak okok kɨrop ag nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pen bin bɨ yokop okok, Jisas mɨnɨm ak kɨri ke ag nɨŋ ag nɨŋ gɨl, ognap aglak, “Ne bɨ tep alap,” aglak; ognap pen aglak, “Mer, ne bin bɨ okok kɨrop wai ñeb bɨ,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pen bin bɨ yokop okok, Juda bɨ kɨb nɨb okok kɨrop pɨrɨklak rek, kɨri mɨnɨm ognap mɨseŋ ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Karɨp Badak ñɨn kɨb kɨri nɨbak ñɨn ognap padɨkak. Yokop ñɨn bad alap nep mɨdek, Jisas apjakɨl, God sobok gep karɨp ak amɨl, bin bɨ okok kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jisas mɨnɨm ag ñɨ mɨdek nɨŋlɨg gɨ, Juda bɨ kɨb okok wal agɨl aglak, “Bɨ aul skul ma agak ak pen ne titi gɨl mɨnɨm okok magɨlsek nɨŋɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nɨb agelak, Jisas agak, “Mɨnɨm yad ag ñebin ak, gos yad ke nɨŋɨl ma ag ñebin; Bɨ yɨp ag yokek onek ak nep yɨp gos ñek ag ñebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bin bɨ an, God ageb rek gɨnɨm, agɨl, gɨ dad amnɨgab ak, God ne mɨnɨm yɨp ñek agebin aka mɨnɨm yad ke agebin ak, nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nɨbi nɨpɨm, bin bɨ an mɨnɨm ne ke ageb ak, yɨb yad ke ap ranaŋ, ag gos nɨŋɨl, mɨnɨm okok nɨb okok nɨb dɨl ageb. Pen bɨ an ne Bɨ ne ag yokak yɨb ne nep ap ranaŋ, ag gos nɨŋɨp ak, bɨ nɨbak bɨ yɨpɨd gɨl mɨnɨm nɨŋɨd nep ageb; ne mɨnɨm esek ognap ma ageb. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosɨs, God agak agak rek kɨrop lo mɨnɨm ag ñak ak pen lo ar nɨb okok nɨbi bɨ alap ma gɨpɨm. Pen yad mɨnɨm alap mɨdek mer, yɨp yokop ñag pak lɨnɨg gebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jisas nɨb agek, bin bɨ ap mɨdelak okok aglak, “Nep bɨ an ñag pak lɨnɨg gek ageban? Nep kɨjeki abaŋ ñagɨp ageban,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Agelak, Jisas agak, “Yad tap ma gep nokɨm alap gen, nɨbi magɨlsek pak ju dɨpek. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Nɨbi Mosɨs God lo mɨnɨm agak rek, ñɨ nɨbi okok tɨk dapɨl, ñɨn aknɨb ar oŋɨd ak mɨdɨl, mɨnek jɨl ñɨn ak waŋ wak tɨb rɨkpɨm. Gɨpɨm nɨbak, Mosɨs ne mer, nased acɨk sɨkop ned wagɨn gɨl gölɨgɨpal mɨñ ar ak me kɨsen gɨl nɨg gɨpɨm. Pen wak tɨb rɨkep ñɨn jɨl nɨbak, ñɨn ognap God nop sobok gep ñɨn ak nep lɨnɨgab pen, mɨñi God nop sobok gep ñɨn ak, agɨl, ma kɨrɨg gɨpɨm; abramek wak tɨb rɨkpɨm. Gɨpɨm nɨbak rek, yad God nop sobok gep ñɨn ak bɨ alap nop gen, mɨb goŋ magɨlsek komɨŋ lak ak, nɨbi ti gɨnɨg yɨp nɨŋem mɨlɨk yowɨp? ");
INSERT INTO kmh_m_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nɨb ak, kɨsen mɨnɨm ar ar nep nɨŋɨl ma agnɨmɨb; yɨpɨd gɨl mɨdonɨmɨŋ ar ak nep nɨŋ tep gɨl agnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem bin bɨ ognap aglak, “Juda bɨ kɨb okok warɨkɨl bɨ ñag pak lɨnɨg gebal bɨ me aul aka? ");
INSERT INTO kmh_m_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pen nɨŋɨm! Ne bin bɨ nab kɨb aul mɨnɨm agek nɨŋlɨg gɨ, kɨri pen mɨnɨm alap ma agebal. Nɨb ak, kɨri ke nɨpal ne Krais ak mɨdeb rek yɨpɨd gɨl rek lɨp! ");
INSERT INTO kmh_m_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pen ne Krais ak opkop ak, cɨn ne karɨp lɨm akal nɨb owɨp ak ma nɨpnop; pen bɨ aul ne karɨp lɨm akal nɨb owɨp ak cɨn magɨlsek nɨpɨn. Nɨb ak, ne Krais ak mer,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Pen Jisas ne God sobok gep karɨp mɨgan eyaŋ mɨnɨm ag ñɨlɨg gɨ nep mɨdɨl, meg mɨgan dap ranɨl agak, “Nɨbi gos nɨpɨm, nɨbi yɨp nɨŋ tep yɨb gɨl, akal nɨb onek ak nɨpɨm. Pen mer. Gos yad ke nep ma onek. Bɨ yɨp ag yokek onek ak, ne Bɨ yɨpɨd gɨl, Bɨ mɨnɨm nɨŋɨd nep ageb. Yad ne eip mɨdɨl, yɨp ag yokek onek rek, nop nɨpin; pen nɨbi nop ma nɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɨb agek, nop dɨ cɨcɨ lɨn, agɨl nɨŋlak ak pen ñɨn ne ma owak rek, bɨ alap nop dɨ cɨcɨ ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pen bin bɨ nɨb okok, bin bɨ koŋai nep Jisas tap ma gep okok gak nɨŋɨl aglak, “Krais ak kɨsen onɨgab apal ak, pen tap ma gep koŋai yɨb gɨl, bɨ nɨbaul geb rek gɨnɨmɨŋ rek ma lɨnɨgab,” aglak. Gos nɨbak nɨŋɨl kɨri aglak, “Jisas ne Krais ak nep,” agɨl, nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pen bin bɨ okok Krais mɨnɨm nɨbak kapkap agelak nɨŋɨl, Perisi bɨ kɨb okok abe, bɨ God nop tap sobok gep bɨ kɨb okok abe, Jisas nop am dɨ cɨcɨ lɨl donɨmɨb, agɨl, God sobok gep karɨp kod mɨdelɨgɨpal polisman ognap ag yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas pen agak, “Yad nɨbep eip tapɨn won alap mɨdɨl, Bɨ yɨp ag yokek onek ak ker adɨk gɨ amnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yɨp, akal amɨb, agɨl, pɨyonɨgabɨm ak pen yɨp ma nɨŋnɨgabɨm. Yad amnɨgain ar ak, nɨbi kɨsen gɨnɨmɨb rek ma lɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nɨb agek, Juda bɨ kɨb okok kɨri ke nep aglak, “Ne akal amnɨgab, nop ma nɨŋnɨgabɨn? Ne am Juda bin bɨ ju am Grik bin bɨ eip mɨdebal okok amɨl, bin bɨ nɨb okok kɨrop mɨnɨm ag ñɨlɨg gɨ mɨdenɨgab aka tari? ");
INSERT INTO kmh_m_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pen ne ti gɨnɨg agɨp, ‘Yɨp, akal amɨb, agɨl, pɨyonɨgabɨm ak pen yɨp ma nɨŋnɨgabɨm. Yad amnɨgain ar ak, nɨbi kɨsen gɨnɨmɨb rek ma lɨnɨgab,’ agɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juda Karɨp Badak ñɨn kɨb kɨri nɨbak, ñɨn kɨsen, ñɨn kɨb yɨb ak, Jisas warɨkɨl, meg mɨgan dap ranɨl agak, “Bin bɨ an kɨŋam mɨlep gɨnɨmɨŋ ak, yɨp apɨl ñɨg ñɨŋaŋ. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bin bɨ an yɨp nɨŋ dɨnɨgab ak, God Mɨnɨm ageb rek, ñɨg komɨŋ mɨdep ak nab nop adaŋ nɨb kɨlam juɨl onɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ñɨn nɨbak Jisas kɨmɨl warɨkɨl Nap nop ma amnak ar ak me, Jisas ne Kaun ak bin bɨ okok kɨrop ma ñak. Pen ñɨg kɨlam juɨl onɨgab mɨnɨm agak nɨbak wagɨn nɨbgɨl mɨdeb: bin bɨ Jisas nop nɨŋ dɨnɨgal okok, Jisas ne Kaun ak kɨrop ñɨnɨgab, agɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas nɨb agek, bin bɨ koŋai nep mɨdelak nɨb okok, ognap mɨnɨm agak nɨbak nɨŋɨl aglak, “Bɨ aul, ne bɨ God Mɨnɨm agep onɨgab, agɨl, kod mɨdolɨgɨpɨn bɨ nɨbak nep me,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ognap aglak, “Mer, ne Krais ak!” aglak. Nɨb agelak, ognap pen aglak, “Mer, Jisas ne Galili nɨb; Krais ak ne Galili nɨb ma onɨgab! ");
INSERT INTO kmh_m_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God Mɨnɨm ak agɨp rek, Krais ak, Depid tɨkek tɨkel tɨk dam dapɨl gɨl, Krais ak Depid taun ne Betlehem sɨŋak tɨk donɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jisas mɨnɨm nɨbak agek nɨŋɨl, bin bɨ koŋai nɨŋ mɨdelak nɨb okok bɨlok ke ke lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ognap nop dɨ cɨcɨ lɨl dam mɨnɨm kɨb agnɨg dad amnɨn aglak ak pen bɨ nokɨm alap nop ma dak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pen God sobok gep karɨp polisman okok adɨk gɨ amel nɨŋlɨg gɨ, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ Perisi okok abe kɨrop ag gɨl aglak, “Bɨ nɨbak nop tari gɨnɨg ma dopɨm?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Agelak, God sobok gep karɨp polisman nɨb okok aglak, “Bin bɨ ognap okok bɨ nɨbak mɨnɨm tep yɨb ageb rek ma apal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nɨb agelak, pen bɨ Perisi okok pen aglak, “Bɨ esek agɨp nɨbak, bin bɨ ognap ne nɨŋɨd agɨp agɨl nɨpal rek, nɨbi ak rek nep nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Cɨn bɨ kɨb bɨ alap aka bɨ Perisi bɨ alap Jisas nop ma nɨŋ dɨpɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bin bɨ sɨŋ aul kɨri lo mɨnɨm ak ma nɨpal rek, God kɨrop mɨlɨk kal nɨŋɨl gɨ tɨmel yɨb gɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pen bɨ kɨri Nikodimas, bɨ sɨŋak ned kɨslɨm eyaŋ amɨl, Jisas nop mɨnɨm ognap ag nɨŋak bɨ nɨbak me, kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Cɨn Juda lo ar ak, bɨ alap nop yokop pen yur ñɨl gɨ tɨmel ma gɨnɨgabɨn; mɨnɨm kɨb agɨl mɨnɨm wagɨn alap pɨyo nɨŋɨl nep me, nɨg gɨnɨgabɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nɨb agek aglak, “Nak ak rek nep Galili nɨb rek? God Mɨnɨm ak udɨn lɨ nɨŋ damɨl nɨŋnɨgan, bɨ God mɨnɨm agep alap Galili nɨb ma onɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nɨb agɨl kɨri kɨrɨg karɨp kɨri ke ke amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pen Jisas Olip Dɨm amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mɨnek karɨp tɨk dam lak nɨŋɨl, kauyaŋ adɨk gɨ God sobok gep karɨp ak apek, bin bɨ koŋai nep apɨl nop pɨŋɨl kos kos gelak nɨŋɨl ne bɨsɨg mɨdɨl, kɨrop mɨnɨm ag ñɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jisas nɨg gɨl mɨnɨm ag ñɨ mɨdek nɨŋlɨg gɨ, bɨ lo mɨnɨm ag ñeb bɨ okok ognap abe, bɨ Perisi ognap abe, kɨri bin alap am bɨ alap eip dosɨp, bin ak nop dap bin bɨ mɨdelak udɨn yɨrɨk ar sɨŋak warɨk ñɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jisas nop aglak, “Mɨnɨm ag ñeb bɨ. Bin aul bɨ sek ak pen bɨ alap eip desir nɨŋɨl dapobɨn me aul. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosɨs lo cɨnop ñak ak agak, ‘Bin nɨb okok rek, kab ju pak lel kɨmlaŋ,’ agak. Pen nak tari agnɨgan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kɨri mɨnɨm tom aglak nɨbak, nɨb agon Jisas tari agek, nop mɨnɨm kɨb agɨn, agɨl, aglak. Pen Jisas ne kɨbor kɨyan gɨl, sɨlpɨl ar ak ñɨnmagɨl mɨnɨm won ognap ñu kɨl tɨklɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pen kɨri Jisas nop mɨnɨm nɨbak rek ag nɨŋlɨg gɨ mɨdelak, ne kɨd almɨl lɨl kɨrop agak, “Bɨ tap si tap tɨmel ma gɨp alap mɨdonɨmɨŋ ak, kab dɨ bin nɨbaul ned paknɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nɨb agɨl kauyaŋ kɨyan gɨl, lɨm eyaŋ mɨnɨm won ognap ñu kɨl tɨk mɨdek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","bɨ Jisas nop mɨnɨm kɨb agɨn aglak nɨb okok, Jisas mɨnɨm agak nɨbak nɨŋɨl, bɨ kɨb kɨb kɨrɨg amnɨlak nɨŋɨl bɨ okok magɨlsek nokɨm nokɨm kɨrɨg gɨl ke ke am saklak; Jisas eip bin ak eip nep mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas ne kɨd almɨl lɨl, bin nɨbak nop agak, “Bɨ okok akal? Bɨ nep mɨnɨm kɨb agnɨmɨŋ alap ma mɨdeb ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Agek, bin ak agak, “Bɨ Kɨb. Bɨ yɨp mɨnɨm kɨb agnɨmɨŋ alap ma mɨdeb,” agak. Agek, Jisas agak, “Yad ak rek nep nep mɨnɨm kɨb ma agnɨgain. Pen tap si tap tɨmel gölɨgɨpan ak kɨsen ma gɨnɨmɨn; mɨñi nak bɨr amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas mɨnɨm alap bin bɨ okok kɨrop kauyaŋ agɨl agak, “Bin bɨ lɨm dai ar wagɨn aul mɨdebal okok, yad melɨk kɨri mɨdebin. Bin bɨ an yɨp sain gɨl ajenɨgab ak, kɨslɨm nab okok rek ma ajenɨgab; komɨŋ per mɨdep melɨk tep ak dɨl ajenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jisas nɨb agek, bɨ Perisi okok nop pen aglak, “Mɨnɨm nak ke ag ñeban ak, cɨn nɨpɨn mɨnɨm nɨbak dɨjɨn rek ma lɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nɨb agelak, Jisas agak, “Mɨnɨm nɨbak yad ke agebin ak pen mɨnɨm nɨŋɨd agebin. Pen tari: yad opin okok nɨŋɨl, amnɨgain okok abe nɨŋɨl gɨpin. Pen nɨbi, yad opin okok ma nɨŋɨl, amnɨgain okok abe ma nɨŋɨl gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nɨbi mɨnɨm tɨg bɨloklɨg gɨ, ‘Ar ak gɨ tep gɨpɨm; ar ak gɨ tɨmel gɨpɨm,’ apɨm ak, bin bɨ lɨm dai ar wagɨn aul gos nɨŋɨl apal rek nep apɨm. Pen yad bɨ alap nop mɨnɨm kɨb ma apin. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bapi yɨp ag yokek onek ak, ne yad eip mɨdobɨr rek, yad mɨnɨm tɨg bɨlok gɨnɨg, nɨŋɨd nep agɨl mɨnɨm tɨg bɨloknɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo mɨnɨm nɨbi ar ak apɨm, ‘Bin bɨ omal mɨnɨm ar nokɨm nep agnɨgair ak me, bin bɨ nɨŋɨl agnɨgal, ak nɨŋɨd apir, agnɨgal,’ apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lo nɨbi agɨp nɨbak rek, yad tigep bɨ rek mɨdebin ak, yad ke mɨnɨm bɨr apin; pen Bapi yɨp ag yokak ak, ak rek nep yad tigep bɨ rek mɨdebin mɨnɨm ak bɨr agɨp. Mɨnɨm cɨr apɨl mɨnɨm ar nokɨm nep apɨr ak me, nɨŋɨd apir apkep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nɨb agek, nop aglak, “Nap nak me akal?” aglak. Agelak, Jisas pen agak, “Nɨbi yɨp ma nɨpɨm rek, Bapi yad nop ak rek nep ma nɨpɨm. Yɨp nɨpkep rek, Bapi yad ak rek nep nɨpkep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas God sobok gep karɨp mɨgan, kab magɨl kɨri God nop ñeb dap yokpal mɨgan ak, mɨnɨm nɨbak ag ñɨ mɨdek pen ñɨn ne ma owak rek, bɨ alap nop dɨ cɨcɨ ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas kɨrop kauyaŋ agak, “Yad kɨrɨg gɨl amenɨgain; yɨp pɨyo nɨŋnɨgabɨm ak pen nɨbi tap si tap tɨmel gɨlɨg gɨ nep mɨdɨl kɨmnɨgabɨm rek, yad amnɨgain okok nɨbi ma amnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nɨb agek, Juda bɨ kɨb okok aglak, “Ne agɨp, ‘Yad amnɨgain okok nɨbi ma amnɨgabɨm,’ agɨp ak, tari gɨnɨg nɨb agɨp? Ne ke ñag pak lɨnɨg gɨl nɨb agɨp aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nɨb aglak ak pen Jisas kɨrop agak, “Nɨbi eyaŋ nɨb; yad alaŋ nɨb. Nɨbi lɨm dai ar wagɨn aul nɨb; yad lɨm dai ar wagɨn aul nɨb mer. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nɨb ak nɨŋɨl me, ‘Nɨbi tap si tap tɨmel gɨlɨg gɨ nep mɨdɨl kɨmnɨgabɨm,’ agesin. Pen yɨp, Yad Mɨdebin Rek Mɨdebin, ma nɨŋ dɨnɨgabɨm ak, tap si tap tɨmel gac sek mɨdebɨm rek mɨdɨl kɨmnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nɨb agek, nop ag nɨŋɨl aglak, “Nak bɨ an?” aglak. Agelak, Jisas agak, “Yad nɨbep per nep ag ñebin rek nep mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nɨbep mɨnɨm kɨb ag gɨnɨm ar ak, mɨnɨm koŋai nep mɨdeb. Bɨ yɨp ag yokek onek ak, magɨlsek nɨŋ tep gɨp rek, yɨp gos ñek nɨŋlɨg gɨ, yad pen bin bɨ okok kɨrop ag ñebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas ne Nap mɨnɨm ag ñak nɨbak ma nɨŋlak rek, kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Bɨ Ñɨ ne nop dɨ oklaŋ lɨnɨgabɨm ñɨn ak, gɨnɨgab gɨnɨgab rek nɨŋɨl ñɨn nɨbak nɨŋnɨgabɨm, Yad Mɨdebin Rek Mɨdebin me. Yad tap alap ke nep nɨŋɨl ma gɨpin; Bapi mɨnɨm yɨp agɨp rek nep ag ñebin ak, nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bɨ yɨp ag yokek onek ak, yad eip mɨdeb. Nop tep gɨp ar ak nep per per gɨpin rek, yɨp ma kɨrɨg gɨp; yad eip nep mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas mɨnɨm nɨbak agek nɨŋlɨg gɨ, bin bɨ koŋai nep nop Krais ak, agɨl, nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pen Jisas ne Juda bin bɨ nop Krais ak agɨl nɨŋlak nɨb okok kɨrop agak, “Nɨbi mɨnɨm yad pɨs nep nɨŋ dɨl, apin rek nep genɨgabɨm ak me, nɨŋɨd nep bin bɨ yad mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nɨg genɨgabɨm ak, God ne tigep Bɨ rek mɨdeb ak nɨŋɨl, mɨñ wög rek gɨpɨm ak kɨrɨg gɨl, mɨd tep gɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nɨb agek aglak, “Mɨnɨm ageban nɨbak tari? Cɨn based Ebraham ñɨ pai ne mɨdobɨn ak, cɨn bin bɨ ognap kɨrop mɨñ wög rek ma gɨpɨn. Nɨb ak, cɨnop tari gɨnɨg, ‘Mɨñ wög rek gɨpɨm ak kɨrɨg gɨl, mɨd tep gɨnɨgabɨm,’ ageban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Agelak, Jisas pen agak, “Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ tap si tap tɨmel gɨpal okok, tap si tap tɨmel gep won ak nep mɨñ wög gep bin bɨ rek mɨdebal. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mɨñ wög gep bɨ alap, nap ne karɨp ak per ma mɨdenɨgab; kɨsen bɨ ke nɨb alap mani yokɨl nop tauek, nap ned nɨb karɨp ne ak kɨrɨg gɨl, karɨp ke amɨl nap kɨsen nɨb ak nop mɨñ wög gɨnɨgab. Pen ñɨ alap nap karɨp sɨŋak kau ne per per nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","God Ñɨ ne nɨbep bin bɨ tauɨl, mɨñ mɨdebɨm ak wɨsɨb yokenɨgab ak, nɨbi mɨñ wög gölɨgɨpɨm ak pɨs nep kɨrɨg gɨl, mɨd tep yɨb gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɨbep Ebraham tɨkek tɨkel tɨk dam dapɨl gɨl apek mɨdebɨm ak nɨpin ak pen mɨnɨm apin ak ma dɨl, yɨp ñag pak lɨnɨg gebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yad Bapi eip mɨdɨl nɨpin rek nɨbep ag ñebin; pen nɨbi, nap nɨbi ak mɨnɨm agek nɨpɨm ar ak nep gebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Agek aglak, “Bapi cɨn me Ebraham,” aglak. Agelak, Jisas agak, “Nɨbi Ebraham ñɨ pai ne mɨdebkep rek, ne golɨgɨp rek gɨpkep. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yad God mɨnɨm agɨp rek nɨŋɨl, mɨnɨm nɨŋɨd yɨb ak nɨbep ag ñɨbin ak pen yɨp ñag pak lɨnɨg gebɨm. Pen nɨbi gɨnɨg gebɨm nɨbak rek, Ebraham ne ma gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nɨb ak, nap nɨbi gɨp rek, nɨbi ke nɨb aknɨb rek nep gɨpɨm,” agak. Nɨb agek aglak, “Cɨnop bin si dɨl ma tɨkpal; God nokɨm me Bapi cɨn yɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nɨb agelak, Jisas pen agak, “‘God nokɨm me Bapi cɨn yɨb,’ apɨm ak pen God ne Nap nɨbi mɨdobkop, yad God nɨb apɨl, mɨñi sɨŋaul mɨdebin ak nɨŋɨl, yɨp mɨdmagɨl lɨpkep. Yad okok mɨdɨl, gos yad ke nɨŋɨl ma onek; God eip mɨdɨl, yɨp nɨŋebir ag yokek sɨŋaul onek. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nɨb ak, mɨnɨm yad ak tari gɨnɨg nɨŋ tep ma gɨpɨm? Gɨpɨm nɨbak, cɨn ma nɨpɨn, agɨl, gɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nɨbi nap nɨbi kɨjeki ñɨ pai ne mɨdebɨm ak me, nop tep gɨp ar ak nep gɨn, agɨl gos nɨpɨm. Ne ned wagɨn gɨl, bin bɨ okok kɨrop ñag pak lolɨgɨp rek, mɨñ ar ne nɨbak nɨg gɨl nep mɨdeb. Gos tep ognap, gos nɨŋɨd ognap ma nɨŋɨp yɨb; ne mɨnɨm nɨŋɨd ognap ma nɨŋɨp. Mɨnɨm esek ageb ak, mɨnɨm yɨb ne me ak. Ne per nep mɨnɨm esek ageb; tom agep wagɨn ak kɨjeki me ak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pen yad nɨbep mɨnɨm nɨŋɨd nep agebin ak me, nɨbi nɨŋɨl ma dɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pen yad gebin ar ak nɨŋɨl, ar ak tap si tap tɨmel geban, agɨl, agnɨmɨb rek ma lɨp. Nɨb ak, yad mɨnɨm nɨŋɨd nep agebin ak nɨŋɨl, nɨbi tari gɨnɨg mɨnɨm yad ma nɨŋ debɨm? ");
INSERT INTO kmh_m_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bin bɨ God eip mɨdebal okok, mɨnɨm ne ak nɨŋ dɨpal. Pen nɨbi nop eip ma mɨdebɨm rek, mɨnɨm ne ak ma nɨŋ dɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda bɨ kɨb okok Jisas nop aglak, “Nak bɨ Sameria nɨb, nep kɨjeki abaŋ ñagɨp, apɨn ak, nɨŋɨd apɨn aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Agelak, Jisas agak, “Yɨp kɨjeki abaŋ ma ñagɨp. Yad Bapi yɨb ne ak agen ar ameb pen nɨbi yɨb yad ak agem sɨŋak eyaŋ ap yapeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yɨb yad ke agen ar amnaŋ, agɨl gos ma nɨpin; pen God ne bin bɨ tari tari gɨpal nɨŋ tep gɨp ak, bin bɨ yɨb yad agel ar amnaŋ, agɨl gos nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nɨbep nɨŋɨd agebin, bin bɨ an mɨnɨm yad ak nɨŋɨl, agebin rek gɨnɨgab ak, ne ma kɨmnɨgab; ne per nep per nep komɨŋ mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jisas nɨb agek, kɨri aglak, “Nak mɨnɨm ageban nɨbak nɨŋɨl nɨpɨn, nak kɨjeki abaŋ ñagɨp ageban. Ebraham abe, bɨ God mɨnɨm agep okok magɨlsek abe kɨmlak, pen nak tari gɨl ageban, ‘Bin bɨ an mɨnɨm yad ak nɨŋɨl, agebin rek gɨnɨgab ak, ne ma kɨmnɨgab; ne per nep per nep komɨŋ mɨdenɨgab,’ ageban? ");
INSERT INTO kmh_m_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Based cɨn Ebraham abe, bɨ God mɨnɨm agep okok magɨlsek abe kɨmlak rek, bɨ nɨb okok bɨ sɨkol, yad bɨ kɨb, agɨl gos nɨpan aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Agelak, Jisas agak, “Yɨb yad ke agen ar ambkop, tap yokop rek lɨpkop. Pen Bɨ yɨb yad agek ar ameb bɨ nɨbak Bapi yad. Nɨbi bɨ nokɨm nɨbak nep, God cɨn, apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","God cɨn, apɨm ak pen nop ma nɨpɨm; pen yad nop nɨpin. ‘Nop ma nɨpin,’ apnep, nɨbi mɨnɨm tom apɨm rek apnep. Nɨb ak, yad nop nɨpin ak me, mɨnɨm ne ageb rek nɨŋɨl gɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","God bɨrarɨk nep nap Ebraham nop agɨl, yad Jisas mɨñi apɨl mɨdebin ñɨn aul nep agɨl, ‘Ñɨn kɨsen ak onɨgab,’ agak. Pen nap Ebraham God mɨnɨm agak ak nɨŋɨl, mɨnɨm nɨbak God nɨŋɨd agɨp, agɨl, mɨñ mɨñ gɨlɨg gɨ gos sek mɨdek; ñɨn nɨbak nɨŋɨl mɨñ mɨñ gak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jisas nɨb agek, Juda bɨ okok aglak, “Mɨ nak ñɨn juɨl omal adɨk gɨ dam aknɨb wajrem alaŋ (50) rek ma mɨdeban ak pen nak tari gɨl, Ebraham bɨrarɨk ped okok gak ak nɨŋnek, ageban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Agelak, Jisas kɨrop agak, “Nɨbep nɨŋɨd yɨb agebin, Ebraham nop ma tɨk dowep ar ak, Yad Mɨdebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jisas nɨb agek, nop kab ju ñag pak lɨnɨg gelak ak pen ne God sobok gep karɨp mɨgan mɨdek ak sɨl gɨ lɨl söŋ amɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pen Jisas bɨ ne okok eip amlɨg gɨ nɨŋlak, bɨ tɨk dolak ñɨn ak nep udɨn kwoi gek udɨn magɨl ma nɨŋolɨgɨp bɨ alap mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisas bɨ ne okok bɨ nɨbak nɨŋɨl Jisas nop aglak, “Mɨnɨm ag ñeb bɨ. Bɨ an tap si tap tɨmel gek, bɨ nɨbaul tɨk dolak ñɨn ak udɨn ne ak kwoi gek udɨn magɨl ma nɨŋeb? Ne ke aka nonɨm nap gerek gɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Agelak, Jisas agak, “Udɨn ne kwoi gɨl mɨdeb ak, ne ke aka nonɨm nap tap si tap tɨmel gerek ma gɨp. Pen udɨn ne kwoi gɨl mɨdeb ak, bin bɨ okok God ne Bɨ kɨlɨs aknɨb ke mɨdeb nɨŋ tep gɨlaŋ agɨl gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mɨñi pɨb nab won aul, Bɨ yɨp ag yokek onek ak, wög nop ak gɨn. Kɨslɨm gɨnɨg geb nɨŋɨl cɨn wög gɨjɨn rek ma lɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yad lɨm dai ar wagɨn aul mɨdebin won aul, bin bɨ lɨm dai ar wagɨn aul mɨdebal okok melɨk kɨri ak yad mɨdebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas mɨnɨm nɨbak agɨl, lɨm eyaŋ kɨñɨk ñagɨl, gek uleb lek, dɨl bɨ udɨn kwoi gɨ mɨdek ak nop udɨn magɨl ne sɨŋak lɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","agak, “Nak Siloam cöb sɨŋak amɨl, udɨn nak ak ñɨg lɨnɨmɨn,” agak. Nɨg gɨl ag yokek, am ñɨg lɨl, udɨn ne ak ñɨl nɨŋɨl, karɨp ne amnak. Siloam mɨnɨm wagɨn ak “Ag Yokek Amnak”. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pen bin bɨ karɨp yakam ne eip jɨm ñɨl okok abe, ned ne tap asɨb golɨgɨp nɨŋölɨgɨpal bin bɨ okok abe aglak, “Bɨ aul, bɨ sɨŋak bɨsɨg mɨdlɨg gɨ, tap asɨb golɨgɨp ak rek lɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Agelak, ognap aglak, “Yau me, bɨ nɨbak nep,” aglak. Ognap pen aglak, “Mer. Bɨ nɨbak rek lɨp ak pen bɨ aul bɨ ke nɨb,” aglak. Nɨb agelak, bɨ nɨbak ne ke agak, “Yad me bɨ nɨbak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Agek, nop aglak, “Udɨn nep ak titi gɨl komɨŋ lɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Agelak agak, “Bɨ Jisas apal ak, lɨm eyaŋ kɨñɨk ñagɨl, gek uleb lek, dɨl udɨn magɨl yɨp ak lɨl agɨp, ‘Siloam cöb amɨl, udɨn nak ak ñɨg lɨnɨmɨn,’ agek, am udɨn yad ak ñɨg lɨl, dai udɨn ñɨl nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Agek aglak, “Bɨ nɨbak mɨñi mɨdeb akal?” aglak. Agelak agak, “Adi ma nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Pen Jisas gek udɨn ñɨl nɨŋak bɨ nɨbak, Juda kai God nop sobok gep ñɨn kɨri ak nɨg gak ak me, bin bɨ ognap bɨ nɨbak nop dam bɨ Perisi mɨdelak sɨŋak dolak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bɨ Perisi bɨ nɨbak nop aglak, “Nak titi gɨl udɨn ñɨl nɨpan?” aglak. Agelak agak, “Jisas lɨm uleb alap dɨl, udɨn yad ak lek, yad am udɨn yad ak ñɨg lɨl, mɨñi udɨn ñɨl nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nɨb agek, bɨ Perisi ognap aglak, “God nop sobok gep ñɨn ak nɨb gɨp rek, ne God nop sobok gep ñɨn lo ar ak tɨb juɨp. Nɨb ak, cɨn nɨpɨn, God nop ag yokek ma owɨp,” aglak. Nɨb agelak, bɨ kɨri ognap pen aglak, “Bɨ tap si tap tɨmel gep alap mɨdobkop, ne titi gɨl tap ma gep nɨbak gɨpkop?” aglak. Nɨb agɨl kɨri ke nep asɨk ke ke lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bɨ Perisi okok, bɨ nɨbak nop kauyaŋ ag nɨŋɨl aglak, “‘Bɨ udɨn yɨp gek udɨn ñɨl nɨpin,’ apan ak, nak bɨ nɨbak bɨ tari, agɨl gos nɨpan?” aglak. Agelak agak, “Yad nɨpin ne bɨ God mɨnɨm agep bɨ alap,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pen Juda bɨ kɨb okok, bɨ udɨn kwoi gak komɨŋ lak mɨnɨm ne ak ma dɨl, nonɨm nap ne cɨnop onɨmir, agel, ber mal aperek, ");
INSERT INTO kmh_m_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aglak, “Ñɨ aul ñɨ nɨri aka?” aglak. Agelak agrek, “Yau, ñɨ ak ñɨ cɨr,” agrek. Agerek aglak, “Nɨri nop udɨn kwoi sek tɨk dorek aka?” aglak. Agelak agrek, “Yau, nop udɨn kwoi sek tɨk dorok,” agrek. Nɨb agerek aglak, “Nɨb ak, mɨñi titi gɨl udɨn ñɨl nɨŋeb?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Agelak, kɨri ber pen bɨr nɨŋrek, Juda bɨ kɨb nɨb okok ned mɨnɨm kɨlɨs ar alap agɨl aglak, “Bin bɨ an an Jisas ne Krais ak agɨl mɨseŋ agnɨgal okok, Juda mogɨm gep karɨp nɨbak kauyaŋ ma onɨgal,” aglak. Mɨnɨm aglak nɨbak bɨr nɨŋɨl me, pɨrɨkɨl, agrek, “Ñɨ ak, ñɨ cɨr mɨdeb ak, nɨpɨr; ñɨ cɨr nɨbak udɨn kwoi sek tɨk dorok ak abe nɨpɨr; pen mɨñi titi gɨl udɨn ñɨl nɨŋeb ak ma nɨpɨr; bɨ an ne gek udɨn ñɨl nɨŋeb ak abe cɨr ma nɨpɨr. Pen ne ñɨ sɨkol mer; nop ke ag nɨŋenɨgabɨm ak, ne ke agnɨgab,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nɨb agerek, bɨ kɨb okok bɨ nɨbak nop kauyaŋ sɨk agel apek aglak, “Nep komɨŋ lɨp nɨbak, God udɨn yɨrɨk ne ar ak mɨnɨm nɨŋɨd nep agan. Cɨn nɨpɨn, bɨ agesɨn ak, bɨ nɨbak bɨ tap si tap tɨmel gep bɨ alap,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nɨb agelak, bɨ nɨbak pen agak, “Ne bɨ tap si tap tɨmel gep bɨ alap aka mer, yad ma nɨpin. Yad tap nokɨm alap nep nɨpin. Ned udɨn kwoi gɨ mɨdenek pen mɨñi udɨn ñɨl nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Agek aglak, “Nep titi gɨl gosɨp, udɨn ñɨl nɨpan?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Agelak agak, “Yad nɨbep mɨdarɨk nep ag ñɨbin ak pen nɨbi mɨnɨm yɨp ak ma dɨpɨm. Tari gɨnɨg mɨnɨm mɨdarɨk nep agesin mɨnɨm ak kauyaŋ agan, agɨl agebɨm? Nɨbi ke ak rek nep bɨ ne alap mɨdon, agɨl, ag nɨŋebɨm aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nɨb agek, nop mɨlɨk kal nɨŋɨl, nop mɨnɨm tɨmel agɨl aglak, “Cɨn Mosɨs bɨ ne me, pen nak bɨ yokop ak bɨ ne alap! ");
INSERT INTO kmh_m_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God Mosɨs nop mɨnɨm ag ñek agolɨgɨp ak nɨpɨn, pen bɨ aul akal nɨb owɨp ak ma nɨpɨn!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Agelak bɨ nɨbak ne pen agak, “Ake! Bɨ ognɨl! Ne udɨn yɨp ak gek komɨŋ lɨp, pen ne akal nɨb ak nɨbi ma nɨpɨm e! ");
INSERT INTO kmh_m_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pen cɨn nɨpɨn, bin bɨ tap si tap tɨmel gɨlɨg gɨ, God nop sobok genɨmel ak, ne mɨnɨm kɨrop ma dɨnɨgab; bin bɨ God nop nɨŋ dɨl, ne mɨnɨm ageb rek gɨlɨg gɨ, nop sobok genɨmel ak, ne mɨnɨm kɨrop nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lɨm dai gɨ lak ñɨn ak tɨkɨl, mɨd dap mɨñi mɨdobɨn ñɨn aul, bin bɨ udɨn kwoi sek tɨk dolak alap gek udɨn ma ñɨl nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bɨ nɨbak God ag yokek ma opkop, ne tap alap gɨnɨmɨŋ rek ma lɨpkop,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nɨb agek, kɨri pen aglak, “Nanɨm nap nep tɨk dorek ñɨn ak, bɨ tap si tap tɨmel gep ak tɨk dorek, pen nak cɨnop mɨnɨm ag ñɨnɨg geban ar? Nɨb agɨl, Juda mogɨm gep karɨp aul kauyaŋ ma onɨgan,” agɨl, nop dɨ neb neb gɨ dam mɨs eyaŋ yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pen bɨ nɨbak nop dɨ mɨs yoklak, Jisas mɨnɨm nɨbak nɨŋɨl, am nop pɨyo nɨŋɨl agak, “Nak Bɨ Ñɨ ne nop nɨŋ dɨpan aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Agek agak, “Bɨ Ñɨ ne bɨ an? Bɨ nɨbak me ak, agek, yad nop nɨŋ dɨnɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nɨb agek, Jisas agak, “Bɨ nɨbak mɨdarɨk nep nɨpan. Me nak eip mɨnɨm ag mɨdobɨr aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nɨb agek, bɨ nɨbak Jisas mɨdek wagɨn sɨŋak kogɨm yɨmɨl agak, “Bɨ Kɨb! Yad nep nɨŋ debin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Agek, Jisas agak, “Yad lɨm dai wagɨn aul opin ak, bin bɨ lɨm dai ar wagɨn aul mɨdebal okok kɨrop nonɨm lɨnɨg opin. Bin bɨ udɨn kwoi gɨp okok melɨk sɨŋak apɨl nɨŋnɨgal; pen bin bɨ, cɨn bɨr nɨŋ tep gɨpɨn ag gos nɨpal bin bɨ okok, kɨri melɨk kɨrɨg gɨl, kɨslɨm eyaŋ amɨl, ma nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nɨb agek, bɨ Perisi ulep nɨb sɨŋak mɨdelak ognap, mɨnɨm nɨbak nɨŋɨl aglak, “Nɨb ageban ak, cɨn abe udɨn kwoi gɨp, agɨl, ageban ar?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Agelak, Jisas kɨrop agak, “Nɨbi udɨn kwoi mɨdebkep rek, tap si tap tɨmel gɨpɨm ak mɨnɨm kɨb ma dɨpkep; pen nɨŋ tep gɨpɨn, apɨm ak me, nɨbi gac sek mɨdɨl mɨnɨm kɨb dɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas mɨnɨm alap sɨd tɨkɨl agak, “Yad nɨbep nɨŋɨd yɨb agebin, kaj sipsip mɨdebal wari mɨgan ak amnɨg, kɨjoŋ wagɨn yɨpɨd gɨl mɨgan ak mɨdek nɨŋlɨg gɨ, yokop tam sɨŋak talak gɨl amnɨgal okok, kɨri tap si dep bin bɨ. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bɨ sipsip mɨkep ak, yokop tam ak talak gɨl ma amnɨgab; kɨjoŋ wagɨn yɨpɨd gɨl mɨgan ak nep amɨl, wari karɨp mɨgan eyaŋ amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Pen bɨ sipsip mɨkep ak amjakek, bɨ kɨjoŋ wagɨn kod mɨdeb ak nop nɨŋ tep gɨnɨgab rek, kɨjoŋ ak yɨknɨgab. Pen sipsip okok ak rek nep, bɨ nɨbak meg mɨgan nop ak nɨŋnɨgal rek, sipsip ne ke okok yɨb ñɨlɨg gɨ poŋɨd söŋ amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sipsip ne poŋɨd söŋ amɨl, ne ned gek nɨŋlɨg gɨ, kɨri meg mɨgan ne ak nɨŋnɨgal rek, nop kɨsen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pen bɨ poñɨŋ nɨb alap ap agek, nop kɨsen ma gɨnɨgal; meg mɨgan ne ma nɨŋnɨgal rek, pɨrɨk amnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas nɨbgɨl mɨnɨm sɨd tɨkɨl agak pen mɨnɨm ageb ar ak agɨl ma tɨk nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisas mɨnɨm ma tɨk nɨŋlak rek, ne kauyaŋ agak, “Yad nɨbep nɨŋɨd yɨb agebin, yad ke sipsip okok kɨjoŋ tam ameb mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pen, ‘Cɨn kaj sipsip mɨkep bɨ,’ agɨl, ned olak bɨ okok, kɨri magɨlsek tap si dep bɨ mɨdelɨgɨpal. Sipsip okok mɨnɨm kɨrop ak ma nɨŋelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Pen yad ke sipsip okok kɨjoŋ tam ameb rek mɨdebin. Bin bɨ yɨp apɨl wari karɨp mɨgan amnɨgal okok, komɨŋ nep mɨdenɨgal. Kɨjoŋ tam amɨl apɨl gɨlɨg gɨ, tap kas kas ñɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bɨ si dep okok, tap si dɨnɨg, cɨp ñag pak lɨnɨg, gɨ tɨmel gɨnɨg nep opal. Pen yad opin ak, nɨbep gen, nɨbi komɨŋ per mɨdep won nɨbak dɨl, komɨŋ mɨd tep gep ar ak nep mɨdem amnaŋ, agɨl, opin. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yad Sipsip Mɨkep Bɨ Tep. Sipsip Mɨkep Bɨ Tep ak kaj sipsip okok nen kɨmnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bɨ sɨŋak mani dɨnɨg kaj sipsip kod mɨdenɨgab ak, bɨ kaj sipsip mɨkep yɨpɨd gɨl mer; sipsip okok sipsip ne mer ak me, kain sapeb okok apenɨgal ak nɨŋɨl pɨrɨk gɨ amnɨgab. Nɨb ak me, kain sapeb nɨb okok sipsip okok kɨrop yɨk gɨ dam ke tɨgoŋ tɨgoŋ yoknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bɨ nɨbak mani dɨnɨg kaj sipsip kod mɨdɨl, sipsip okok kɨrop gos ma nɨŋnɨgab ak me, pɨrɨk gɨ amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Yad Sipsip Mɨkep Bɨ Tep. Bapi cɨr apɨl pen pen nɨŋ tep gɨpɨr rek, yad sipsip okok eip pen pen nɨŋ tep gɨpɨn. Nɨb ak, yad kɨrop nen agɨl kɨmnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipsip wari karɨp mɨgan aul mɨdebal nep mer, sipsip ognap sek mɨdebal. Sipsip nɨb okok ak rek nep dɨnɨgain. Kɨri ak rek nep mɨnɨm yad ak nɨŋnɨgal. Sipsip karɨp mɨgan nokɨm alap mogɨm gɨ mɨdɨl, bɨ mɨkep kɨri nokɨm alap nep mɨdɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Yad nɨbep nen agɨl kɨmɨl warɨknɨgain rek, Bapi yɨp mɨdmagɨl lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Bin bɨ ognap gos kɨri nɨŋɨl gel ma kɨmnɨgain; pen yad gos yad ke nɨŋɨl kɨmnɨgain. Yad ke kɨmnɨm, agɨl, kɨmnɨgain; yad ke warɨknɨm, agɨl, warɨknɨgain. Nɨb ak, Bapi yad, nak aknɨb gɨnɨmɨn, agɨp mɨnɨm ne ak dɨl, agɨp rek nep gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisas mɨnɨm nɨbak agek, Juda kai kauyaŋ asɨk pɨs ak ke, pɨs ak ke lɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ognap aglak, “Ne kɨjeki abaŋ ñagek, mɨnɨm tom ageb ak, tari gɨnɨg mɨnɨm ne ak nɨŋebɨm?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nɨb agelak, ognap pen aglak, “Ne kɨjeki abaŋ ñapkop ak, nɨb ag rep ma gɨpkop. Pen kɨjeki abaŋ ñagek, titi gɨl bin bɨ udɨn kwoi gɨ mɨdelak okok gek kauyaŋ udɨn ñɨl nɨplap?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pen kɨsen Juda bin bɨ, God sobok gep karɨp sɨŋ tep mɨdeb ak mɨñ mɨñ gep ñɨn kɨb ak mɨñi, agɨl, Jerusalem am mogɨm gɨlak. Pen ñɨn kɨb nɨbak, karɨp yɨgen ñɨn ak me, ");
INSERT INTO kmh_m_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas ne God sobok gep karɨp söŋ ar “Solomon Karɨp Badak” apal sɨŋak tagek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda bin bɨ okok Jisas mɨdek sɨŋak apɨl aglak, “Cɨnop gek per nep ma kod mɨdojɨn; nak Krais ak mɨdenɨmɨn ak, mɨseŋ agek nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Agelak, Jisas pen agak, “Yad nɨbep bɨr ag ñɨbin ak pen mɨnɨm yad ak mɨnɨm nɨŋɨd, agɨl, ma nɨŋ dɨpek. Bapi yad kɨlɨs ne dɨl tap ma gep okok gɨpin ak nɨŋɨl, mɨnɨm yad ak mɨnɨm nɨŋɨd ageb, agɨl, nɨŋ dɨpkep. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pen sipsip yad ma mɨdebɨm rek, mɨnɨm yad ak mɨnɨm nɨŋɨd, agɨl, ma nɨŋ dɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip yad okok mɨnɨm yad agebin ak nɨpal; yad kɨrop nɨpin nɨŋɨl kɨri yɨp kɨsen gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sipsip yɨp kɨsen gɨpal okok, kɨrop komɨŋ per mɨdep won ak ñɨbin ak me, kɨri ma kɨmnɨgal. Ñɨnmagɨl ar yad mɨdebal rek, bin bɨ ognap apɨl kɨrop tɨg sak dad amnɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bapi yad kɨrop dɨ yɨp ñɨb ak, ne Bɨ kɨlɨs aknɨb ke yɨb mɨdeb ak me. Ñɨnmagɨl ar ne mɨdebal rek, bin bɨ ognap apɨl kɨrop tɨg sak dad amnɨmel rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bapi ke, yad ke, mer; cɨr apɨl nokɨm yɨb mɨdobɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jisas nɨb agek, Juda kai nop kauyaŋ kab ju paknɨg gelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nɨg gelak, Jisas kɨrop pen agak, “Bapi yɨp agek, nɨbi mɨdebek nɨŋɨl tap tep ke ke koŋai nep gɨnek. Pen tap tep gɨnek nɨb okok, ar akal gɨ tɨmel gɨnek nɨŋɨl yɨp ñag pak lɨnɨg gebɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Agek aglak, “Tap tep ar nɨb okok nɨŋɨl, nep ñag pak lɨnɨg ma gobɨn; nak bɨ yɨb pen, yad God rek mɨdebin, agɨl, God yɨb ne tau dap yap lɨpan ak me, nep ñag pak lɨnɨg gobɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nɨb agelak, Jisas pen agak, “Lo nɨbi ke dai alap ñu kɨl tɨkɨl aglak, ‘God ne agak, “Nɨbi ke god rek mɨdebɨm,” agak,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God Mɨnɨm ak mɨnɨm alap esek ma agnɨgab; per nep per nep nɨŋɨd nep mɨdenɨgab. God ne bin bɨ yokop okok mɨnɨm agesin nɨbaul ñɨl, ‘Nɨbi god rek mɨdebɨm,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pen yad, yad lɨm dai wagɨn aul opin ak, Bapi yɨp wög ne ag lɨl ag yokek opin. Pen yad God Ñɨ ne mɨdebin agnek mɨnɨm nɨbak nɨŋɨl, nɨbi tari gɨnɨg, God yɨb ne tau dap yap lɨp, agɨl, yɨp ñag pak lɨnɨg gebɨm? ");
INSERT INTO kmh_m_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yad God wög ne genɨgabin ak, mɨnɨm yad nɨŋ dɨnɨmɨb. Mer ak, mer. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pen mɨnɨm yad ma nɨŋ dɨpɨn, agnɨgabɨm ak, yad tap ma gep rek gɨpin okok nɨŋɨl, nɨŋ dɨnɨmɨb. Nɨbi nɨg gɨl nɨŋ dɨl me, yad Bapi eip mɨdebin Bapi yad eip mɨdeb ak nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jisas nop kauyaŋ dɨ cɨcɨ lɨn aglak ak pen ne kapkap sɨl gɨ lɨl amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas nɨg sɨl gɨ amɨl, kauyaŋ ñɨg Jodan juɨl pɨs kɨdadaŋ amɨl, Jon ned mɨdɨl bin bɨ ñɨg pak ñolɨgɨp karɨp lɨm tɨgoŋ okok am mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bin bɨ koŋai nep mɨdek sɨŋak apɨl aglak, “Jon ne tap ma gep rek ognap ma golɨgɨp, pen ne bɨ aul nop agɨl, mɨnɨm tari tari agolɨgɨp ak, magɨlsek mɨnɨm nɨŋɨd nep agolɨgɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nɨb agɨl, bin bɨ mɨgan nɨbak mɨdelak okok koŋai nep Jisas nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Karɨp tɨrɨg tɨroŋ Betani nɨb bɨ alap tap gak; yɨb ne ak Lasaras. Bɨ nɨbak, nɨnai ne omal mɨdölɨgɨpir; alap Maria, alap Mata. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria me, Jisas nop tob kɨd ne ak wel soŋ gɨ ñɨl, kɨmkas ne dɨ lɨg gɨ yokak bin nɨbak. Nɨmam ne Lasaras tap gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasaras nɨnai mal Jisas nop mɨnɨm pɨŋɨl yokɨl agrek, “Bɨ Kɨb! Bɨ mɨdmagɨl nak ak tap gɨp,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pen Jisas mɨnɨm ag yokrek nɨbak nɨŋɨl agak, “Ne tap gɨp pen pɨs nep ma kɨmnɨgab. Pen God ne ke nɨŋɨp rek, ne kɨlɨs ke ne gek, bin bɨ okok God yɨb ne ak abe, God Ñɨ yɨb ne ak abe agel ar amnɨgab, agɨl, gak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ne Mata, nɨnai ne Maria, nɨmam nɨri Lasaras kɨrop yakam mɨdmagɨl lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pen Lasaras tap gak mɨnɨm nɨbak nɨŋɨl, Jisas nop nɨŋnɨg kasek ma amnak; karɨp lɨm mɨdek sɨŋak ñɨn omal sek mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ñɨn omal yapek, bɨ ne okok kɨrop agak, “Karɨp lɨm Judia adɨk gɨ amnɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nɨb agek, bɨ ne okok aglak, “Mɨnɨm ag ñeb bɨ. Tol won ak nep, bɨ Juda okok nep kab ju paknɨg gelak ak pen nak kauyaŋ karɨp lɨm nɨbak adɨk gɨ amnɨg geban aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Agelak, Jisas agak, “Nɨbi nɨpɨm, ñɨn nokɨm alap, aua aknɨb umɨgan alaŋ nep mɨdeb. Bin bɨ melɨk sek ajenɨgal okok, lɨm dai melɨk nɨbak melɨk ñek, tap ognap kɨrop lɨ dɨl amek ma ap yap paknɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pen bin bɨ kɨslɨm eyaŋ ajenɨgal okok, melɨk kɨri ma mɨdek, tap ognap kɨrop lɨ dɨl amek ap yap paknɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas nɨb agɨl, mɨnɨm alap sek kɨrop agɨl agak, “Bɨ nɨŋeb cɨn Lasaras wɨsɨn kɨneb; pen yad amɨl nop agen warɨk onɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Agek, bɨ ne okok pen aglak, “Bɨ Kɨb. Ne wɨsɨn kɨneb, apan rek, komɨŋ lɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas ne Lasaras bɨr kɨmɨb ak nɨŋɨl, “Lasaras wɨsɨn kɨneb,” agak. Pen bɨ ne okok Jisas mɨnɨm ne nɨŋɨl, Lasaras yokop wɨsɨn kɨneb, agɨl gos nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bɨ ne okok ma nɨŋep ar mɨdelak nɨŋɨl Jisas kɨrop mɨseŋ agɨl agak, “Lasaras bɨr kɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pen yad Lasaras eip ma mɨdenek kɨmɨb ak, nɨbep nen agɨl mɨñ mɨñ gɨpin. Nɨb gɨp ak me, nɨbi mɨnɨm yad nɨŋ dɨnɨmɨb rek lɨp. Pen Lasaras mɨdeb sɨŋak amnɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Agek, Tomas Didimas ne Jisas bɨ ne ognap okok kɨrop agak, “Cɨn magɨlsek mɨnɨm ag ñeb bɨ cɨn eip karɨp lɨm Judia amon, nop ñag pak lɨl, cɨnop abe ñag pak lɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pen kɨri karɨp tɨrɨg tɨroŋ Betani amjakelak, bin bɨ okok Jisas nop aglak, “Lasaras kɨmak tɨgel gɨnok, ñɨn omal omal padɨkɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pen karɨp tɨrɨg tɨroŋ Betani nɨbak, Jerusalem maŋ sɨŋak, kilomita aknɨb omal nokɨm rek nep mɨdolɨgɨp rek me, ");
INSERT INTO kmh_m_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lasaras kɨmek, Juda bin bɨ koŋai nep apɨl, Mata Maria air mal yɨmɨg nɨŋɨl sɨl magɨl ag mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pen Jisas apeb, agel, Mata nɨŋɨl, nɨnai Maria nop karɨp ak kɨrɨg gɨl, am Jisas nop nɨŋnɨg amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ne am Jisas nop nɨŋɨl agak, “Bɨ Kɨb. Nak aul mɨdebnap, mam yad Lasaras ma kɨmbkop. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pen yad nɨpin, mɨñi nak God nop tap tari ag nɨŋenɨgan ak, agnɨgan rek gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Agek, Jisas agak, “Namam kauyaŋ warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Agek, Mata agak, “Yad nɨpin mɨnɨm kɨb agep ñɨn ak warɨknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Agek, Jisas agak, “Yad ke gen bin bɨ warɨknɨgal; yad ke gen bin bɨ komɨŋ mɨdenɨgal. Bin bɨ yɨp nɨŋ dɨl kɨmnɨgal okok, komɨŋ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Bin bɨ komɨŋ mɨdɨl yɨp nɨŋ dɨnɨgal okok, ma kɨmnɨgal; per nep per nep komɨŋ mɨdenɨgal. Mɨnɨm agebin nɨbaul nɨŋ dɨpan aka mer?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jisas nɨb agek, Mata agak, “Bɨ Kɨb. Yaue, yad nɨŋ dɨpin, nak me Krais ak, God Ñɨ ne lɨm wagɨn aul onɨgab, agölɨgɨpal ak nep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata mɨnɨm nɨbak agɨl, karɨp adɨk gɨ amɨl, nɨnai ne Maria nop tɨmɨd wagɨn okok mɨmɨg tɨkɨl agak, “Mɨnɨm ag ñeb bɨ bɨr owɨp; nep akal agɨl ag nɨŋeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria mɨnɨm nɨbak nɨŋɨl kasek warɨkɨl, Jisas nop nɨŋnɨg amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pen Jisas karɨp tɨrɨg tɨroŋ Betani bɨr ma owak; Mata nop nɨŋak mɨgan nɨb sɨŋak nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria ne nɨg kasek amek, Juda bin bɨ nop eip karɨp mɨgan mɨdelak okok ag nɨŋlak e, cɨp tɨgel adaŋ sɨl agnɨg ameb, agɨl, amek nɨŋlɨg gɨ sain amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria am Jisas nop nɨŋɨl, mɨdek tob wagɨn sɨŋak mapɨk yɨmɨl agak, “Bɨ Kɨb, nak sɨŋaul mɨdebnap, mam yad ma kɨmbkop!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pen Maria abe, Juda bin bɨ ne eip olak okok abe sɨl agelak ak nɨŋɨl, Jisas gos cɨbur mɨdmagɨl ne mapɨn kɨb yɨb gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nɨb gek, Jisas agak, “Nop tɨgel gɨpɨm akal?” agak. Agek aglak, “Apek am nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas udɨn ñɨg yowak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jisas udɨn ñɨg yapek ak nɨŋɨl, Juda bin bɨ okok nɨŋɨl aglak, “Nɨŋɨm! Lasaras nop mɨdmagɨl yɨb lɨp!” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ognap pen aglak, “Ne bɨ udɨn kwoi gak ak nop gek udɨn ñɨl nɨŋak rek, tari gɨnɨg tap bɨ nɨbaul nop gak ak gek komɨŋ ma lak?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pen Jisas kauyaŋ gos cɨbur mɨdmagɨl ne mapɨn kɨb yɨb nɨŋɨl, Lasaras nop tɨgel gɨlak mɨgan ak amjakak. Cɨp tɨgel gɨlak nɨbak, kab mɨgan alap tɨgel gɨlak; pen kab kɨb alap dɨ kɨjoŋ pɨlɨŋ gel mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pen Jisas bɨ okok agak, “Kab ak dɨ yokɨm,” agak. Jisas nɨb agek, bɨ Lasaras kɨmak nɨbak nɨnai ne Mata agak, “Bɨ Kɨb, cɨp ak kɨmek tɨgel gɨnok, ñɨn omal omal padɨkɨp ak, ki tɨmel yɨb onɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Agek, Jisas pen agak, “Nep tari agesin? Nep apin, ‘Yɨp nɨŋ dɨ mɨdɨl me, God kɨlɨs ne ke nɨŋnɨgan,’ apin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nɨb agek, kab ak dɨ yokel, Jisas kɨlan gɨ nɨŋɨl agak, “Bapi, yad nep ag nɨŋen yɨp nɨpan ak, nep tep agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yad nep ag nɨŋen yɨp per nɨpan ak bɨr nɨpin ak pen mɨnɨm agebin nɨbaul, bin bɨ sɨŋaul warɨk mɨdebal okok, nak nep yɨp ag yokek onek ak kɨri nɨŋ dɨnɨmel, agɨl, agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas nɨb agɨl, meg mɨgan dap ranɨl agak, “Lasaras, nak mɨs aul owan e!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Agek, walɨj ñɨn tob nop kom kam sɨlokɨl, nabɨc meg mɨgan walɨj kom kam gɨl, dam tɨgel gɨlak walɨj okok, nɨg gɨl mɨdek nɨŋlɨg gɨ, cɨp se par ak warɨkɨl walɨj sek kom kam gɨl mɨs owak. Apek, Jisas bɨ okok kɨrop agak, “Walɨj nop kom sɨlokpɨm okok wɨsɨb yokem amnaŋ,” agak. Agek, agak rek gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda bin bɨ Maria nop nɨŋnɨg olak nɨb okok, Jisas Lasaras nop gek warɨkak ak nɨŋɨl, bin bɨ koŋai nep Jisas ne Krais ak, agɨl, nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pen ognap adɨk gɨ bɨ Perisi mɨdelak sɨŋak amɨl, Jisas gak nɨbak kɨrop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ag ñelak, bɨ Perisi okok abe, bɨ God nop tap sobok gep bɨ kɨb okok abe, kɨri Juda Kansol mɨnɨm tɨg asɨk lölɨgɨpal bɨ kɨb okok kɨrop sɨk agel, am mogɨm gelak, kɨrop aglak, “Bɨ nɨbak tap ma gep koŋai nep geb ak, cɨn tari gɨn? ");
INSERT INTO kmh_m_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cɨn nɨŋɨl kɨrɨg gon, ne ar nɨbak nep gek amek, bin bɨ magɨlsek nop nɨŋ dɨl, kiŋ kɨb cɨn, agenɨgal ak, Rom bɨ kɨb okok apɨl, God sobok gep karɨp cɨn ak gɨ tɨmel gɨl, cɨnop Juda bin bɨ gɨ tɨmel gɨl, gɨnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pen mɨ nɨbak nep, bɨ alap nop ag lel, ne bɨ God nop tap sobok gep bɨ kɨb yɨb ak mɨdek. Bɨ nɨbak yɨb ne Kaiapas. Ne mogɨm gelak nab ak mɨnɨm agɨl agak, “Nɨbep gos ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yad nɨbep agebin, bɨ nokɨm alap kɨmek cɨn magɨlsek komɨŋ amnɨgabɨn ak tep; cɨn magɨlsek kɨmnɨgabɨn ak tɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas ne mɨnɨm agak nɨbak, ne ke ma agak; ne bɨ God nop tap sobok gep bɨ kɨb yɨb mɨ nɨbak mɨdek rek, ne tap tari tari kɨsen gɨnɨgab okok gos nɨŋɨl, Jisas ne Juda bin bɨ okok kɨrop nen agɨl kɨmnɨgab, agɨl, mɨnɨm nɨbak agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pen Juda kai kɨrop nep mer; bin bɨ God ñɨ pai ne dɨnɨg geb okok magɨlsek dɨ jɨm ñɨl lek, wagɨn ne nokɨm yɨb mɨdenɨgal, agɨl, kɨmnɨgab, agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nɨb ak, ñɨn nɨbak wagɨn gɨl, Juda bɨ kɨb nɨb okok Jisas nop titi gɨl ñag pak lɨn, agɨl, per nep mɨnɨm nɨbak nep ag amɨl apɨl gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Juda bɨ kɨb okok Jisas nop ñag pak lɨnɨg gelak ak nɨŋɨl, Jisas ne karɨp lɨm kɨri Judia nab sɨŋak mɨseŋ ma tagolɨgɨp; ne bɨ ne okok eip karɨp lɨm Judia sɨŋak ju am Epraim taun amjakɨl, mɨñ mab kab nep mɨdolɨgɨp gol sɨŋak mɨdelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pen Juda kai Pasopa ñɨn kɨb kɨri ak ulep ulep gek nɨŋɨl, bin bɨ koŋai nep karɨp lɨm kɨri ke okok kɨrɨg gɨl, cɨn God udɨn yɨrɨk bin bɨ tɨd tep mɨdɨl, Pasopa tap ñɨŋɨn, agɨl, wög ar kɨri bɨrarɨk okok gölɨgɨpal rek gɨnɨg Jerusalem amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kɨri Jerusalem apjakɨl, Jisas nop pɨyo nɨŋ mɨdelak. Kɨri amɨl God sobok gep karɨp ñɨlɨk mɨgan ak mɨdɨl, Jisas akal, agɨl, pen ag nɨŋ pen ag nɨŋ gɨl aglak, “Nɨbi tari gos nɨpɨm? Ne Pasopa ñɨn aul onɨgab aka mer?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pen God nop tap sobok gep bɨ kɨb okok abe, bɨ Perisi okok abe, mɨnɨm alap aglak, “Bin bɨ alap Jisas nop nɨŋonɨmɨŋ ak, ne ap cɨnop agenɨgab, cɨn am nop dɨ cɨcɨ lɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasopa tap ñɨŋnɨg gɨlak ak, ñɨn aknɨb kagol oŋɨd ak nep mɨdek nɨŋlɨg gɨ, Jisas Lasaras kɨmak nop gek warɨkak karɨp ne ak amnak. Karɨp tɨrɨg tɨroŋ nɨbak yɨb Betani. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Betani amɨl, tap ñɨŋɨn, agɨl, Jisas ak, Lasaras ak, bin bɨ ognap abe, bɨsɨg mɨdelak nɨŋlɨg gɨ, Mata tap magɨl okok nonɨm lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nɨnai Maria pen, agnoŋ ki tep mani kɨb yɨb taupal barol alap dapɨl, Jisas tob ar ak soŋ gɨ ñɨl, kɨmkas ne ak dɨl tob nop lɨlɨg gak. Nɨg gek, agnoŋ ki tep nɨbak, karɨp mɨgan mɨdelak nɨbak magɨlsek ki tep yɨb pak ñek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nɨg gek, Judas Iskariot, Jisas bɨ ne sɨŋok nop kɨsen mɨmɨg nɨŋak bɨ nɨbak, ki tep nɨbak nɨŋɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mani kɨb yɨb taupal agnoŋ nɨbaul rek yokɨl, mani dɨl, bin bɨ tap ma mɨdeb okok kɨrop ñɨbkop ak tep. Bɨ agnoŋ nɨb rek taunɨg geb ak, ne takɨn aknɨb wajrem alaŋ wög gɨl mani dɨl amɨl agnoŋ nɨbaul taunɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ne nɨb agak ak, bin bɨ tap ma mɨdeb okok yɨmɨg nɨŋɨl ma agak; ne mani wad ak dɨ ajɨl, ognap kapkap si dolɨgɨp ak me nɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pen Jisas agak, “Nop ma ag gɨnɨmɨn. Yɨp tɨgel gɨnɨgal ñɨn ak lɨ ñɨnɨg dap lɨp ak, mɨñi dap lɨ ñeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bin bɨ mani ma mɨdeb okok eip per mɨdenɨgabɨm; pen yad eip per ma mɨdenɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisas Betani ap mɨdeb aglak mɨnɨm nɨbak nɨŋɨl, Juda bin bɨ koŋai nep okok nop nɨŋnɨg amnɨlak. Pen Jisas nop nep nɨŋnɨg ma amnɨlak; Lasaras bɨ kɨmak Jisas gek warɨkak bɨ nɨbak nop abe nɨŋnɨg amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pen Lasaras kɨmak Jisas nop gek warɨkak rek, Juda bin bɨ koŋai nep mɨñ ar kɨri gɨ mɨdelɨgɨpal ak kɨrɨg gɨl, Jisas nop nɨŋ dɨlak. Nɨg gelak, bɨ God nop tap sobok gep bɨ kɨb okok, Lasaras nop abe ñag pak lɨnɨgabɨn, agɨl gos ak nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mɨnek, bin bɨ koŋai yɨb Pasopa tap ñɨŋnɨg olak okok, Jisas Jerusalem apeb aglak mɨnɨm nɨbak nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nop am nɨŋɨn, agɨl, albad kas ognap tɨk dap pɨpal paklɨg gɨ, sɨk kɨb aglɨg gɨ aglak, “Bɨ Kɨb yɨb ne ak agon ar amnaŋ!” “Bɨ Kɨb ne Bɨ ne nɨbaul ag yokek owɨp me aul!” “Ne Bɨ tep. Yɨb ne agon ar amnaŋ!” “Ne Isrel Kiŋ apeb me aul! Yɨb ne agon ar amnaŋ!” ");
INSERT INTO kmh_m_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas kaj donki marɨp alap dɨl, ar nɨbak bɨsɨg gɨl amek. Nɨg gak ak, God Mɨnɨm ak ñu kɨl tɨkɨl aglak rek nep gak. God Mɨnɨm dai nɨbak ñu kɨl tɨkɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion pai, nak ma pɨrɨknɨmɨn. Kiŋ nak ak kaj donki marɨp ar ak bɨsɨg gɨl apeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gak ñɨn nɨbak, Jisas bɨ ne okok, God ne nɨg gɨnɨgab agak rek nep geb ak, agɨl, ma nɨŋlak; pen kɨsen Jisas kɨmɨl warɨkɨl, God ker karɨp lɨm seb kab ar alaŋ sɨŋak bɨr amnak ñɨn nɨbak nep, Jisas bɨ ne okok gos nɨŋ tep gɨl nɨŋlak, Jisas Jerusalem amek ñɨn nɨbak tap tari tari nop gɨlak okok, ned God mɨnɨm agep bɨ okok God Mɨnɨm ñu kɨl tɨkɨl aglak rek nep gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisas Lasaras kɨmak nop gek warɨkak ak, bin bɨ nɨŋlɨg gɨ mɨdelak okok mɨnɨm nɨbak ag amɨl apɨl gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nɨb ak, bin bɨ koŋai nep tap ma gep gak nɨbak nɨŋɨl, Jerusalem kɨrɨg gɨl, nop kanɨb nab sɨŋak nɨŋnɨg amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kɨri nɨg gɨlak rek, bɨ Perisi okok nɨŋɨl, kɨri ke nep mɨnɨm agɨl aglak, “Nɨŋɨm! Cɨn tap alap gɨjɨn rek ma lɨp. Bin bɨ lɨm dai ar wagɨn aul magɨlsek bɨ nɨbak nop sain gebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pen Pasopa ñɨn ak apeb, agɨl, God nop sobok gɨnɨg Jerusalem amnɨlak ñɨn nɨbak, Grik bin bɨ ognap eip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik bin bɨ nɨb okok apɨl, Pilip karɨp lɨm Galili sɨŋak Betsaida taun nɨb bɨ ak nop aglak, “Bɨ kɨb yɨb, cɨn Jisas nop nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nɨb agelak, Pilip am Edru nop ag ñɨl, Edru eip omalgɨl amɨl Jisas nop ag ñɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ag ñerek, Jisas agak, “Mɨñi God gek, Bɨ Ñɨ ne Bɨ melɨk tep ke sek mɨdeb ak nɨŋnɨgal ñɨn ak bɨr owɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yad nɨbep nɨŋɨd yɨb agebin, wid magɨl alap lɨm eyaŋ yapɨl ma kɨmnɨgab ak, yokop wid magɨl nokɨm alap nep mɨdenɨgab. Pen wid magɨl nɨbak lɨm eyaŋ yapɨl kɨmenɨgab ak, kɨsen tanɨl magɨl koŋai nep pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bin bɨ an, ‘Lɨm dai ar wagɨn aul komɨŋ mɨdep won yad ke nep gos nɨŋɨl mɨd tep gɨnɨm,’ agɨl gek amnɨgab ak, ne kɨmɨl pɨs nep kɨmnɨgab; pen bin bɨ an, ‘Lɨm dai ar wagɨn aul komɨŋ mɨdep won yad ke gos par ma nɨŋnɨm; mɨd tep gɨnɨgain aka mɨd tep ma gɨnɨgain ak tap kɨb mer,’ agɨl gek amnɨgab ak, komɨŋ mɨdep won ne ak per nep per nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pen bin bɨ an yɨp wög gɨnɨg gɨnɨgain, agnɨgab ak, ne yɨp sain gɨnɨmɨŋ; yad akal mɨdenɨgain ak, bin bɨ wög gɨ ñeb yad eip mɨdenɨgab. Bin bɨ an wög yɨp gɨ ñɨnɨgab, Bapi yad bin bɨ nɨbak yɨb nop ak dap rannɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Mɨñi yɨp mɨker geb ak tari agnɨm? ‘Bapi yɨp talak tauek, yɨp tap tari gɨnɨg geb ak ma gɨnɨmɨŋ,’ agɨl agnɨm aka? Mer! Mɨker nɨbak dɨnɨg onek. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pen Bapi, nak gek bin bɨ okok nɨŋnɨgal, nak Bɨ melɨk tep ke sek mɨdeban,” agak. Jisas nɨb agek nɨŋlɨg gɨ, mɨnɨm alap seb kab ar alaŋ nɨb apɨl agak, “Yad gen, bin bɨ okok bɨr nɨpal yad Bɨ melɨk tep ke sek mɨdebin. Pen yad kauyaŋ gen, bin bɨ okok aknɨb rek me kauyaŋ nɨŋnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pen bin bɨ mɨdelak okok, God mɨnɨm agak nɨbak nɨŋɨl, ognap aglak, “Tɨmɨk agosɨp,” aglak; ognap pen aglak, “Ejol alap Jisas nop mɨnɨm ognap agosɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nɨb aglak ak pen Jisas kɨrop agak, “Mɨnɨm agosɨp nɨbak yɨp nen agɨl ma agosɨp; nɨbep nen agɨl agosɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pen tari: mɨñi bin bɨ lɨm dai ar wagɨn aul okok, kɨri tari tari gɨpal ak, God ne ke nɨŋɨl, pen ñɨl, kɨrop dɨ bɨlok ke ke lɨnɨgab. Bin bɨ lɨm dai ar wagɨn aul yɨp ma nɨŋ dɨpal okok kɨrop kiŋ rek kod mɨdeb bɨ tɨmel nɨbak, God nop yɨk gɨ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yɨp dɨ ar sɨŋ alaŋ lenɨgal ak, yad bin bɨ karɨp lɨm ke okok nɨb okok nɨb magɨlsek lɨp gɨ dam dɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisas mɨnɨm agak nɨbak, yɨp titi gɨl gel kɨmnɨgain, agɨl, agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pen bin bɨ koŋai nep ap mɨdelak nɨb okok Jisas nop pen aglak, “Lo mɨnɨm cɨn ak agɨp, ‘Krais ak per per nep komɨŋ mɨdenɨgab,’ agɨp ak pen nak ti gɨnɨg gɨl ageban, ‘Bɨ Ñɨ ne nop dɨ ar sɨŋ alaŋ lɨnɨgal,’ ageban? Pen Bɨ Ñɨ ne agɨl ageban ak, bɨ an nop ageban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Agelak, Jisas agak, “Melɨk ak sɨkol eñap sek nɨbep eip mɨdenɨgab. Nɨb ak, melɨk nɨbep eip mɨdeb won aul, kanɨb tag tep gɨnɨmɨb; mer ak, kɨslɨm apɨl nɨbep karɨk yugnɨgab. Bin bɨ an kɨslɨm sɨŋak ajenɨgab, akal amebin, agɨl ma nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Melɨk nɨbep eip mɨdeb won aul, melɨk ak nɨŋ dɨnɨmɨb. Melɨk ak nɨŋ denɨgabɨm ak, melɨk ñɨ pai ne lɨnɨgabɨm,” agak. Jisas nɨb agɨl, bin bɨ nɨb okok kɨrɨg gɨl ke okok amɨl we gɨl mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas ne tap ma gep koŋai nep bin bɨ okok udɨn yɨrɨk ar kɨri gek nɨŋlak pen nop ma nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bin bɨ Jisas nop ma nɨŋ dɨlak ak, bɨ God mɨnɨm agep Aisaia bɨrarɨk nep God Mɨnɨm dai alap ñu kɨl tɨkɨl agak rek nep gɨlak. Ne mɨnɨm nɨbak ñu kɨl tɨkɨl agak, “Bɨ Kɨb, mɨnɨm tep nak kɨrop ag ñɨbɨn pen kɨri mɨnɨm nɨbak mɨnɨm tep agɨl ma dɨpal; nak kɨlɨs ke yɨb nak ke gɨl genak ak nɨpal ak pen nep Bɨ Kɨb agɨl ma nɨŋ dɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Nɨb ak, kɨri Jisas nop ma nɨŋ dɨlak. Nɨg gɨlak ak, Aisaia God Mɨnɨm dai alap ñu kɨl tɨkɨl agak rek nep gɨlak. Ne mɨnɨm nɨbak ñu kɨl tɨkɨl agak, “God ne bin bɨ okok kɨrop gek kɨri udɨn kwoi rek mɨdebal; God ne gek kɨri gos tɨmɨd tep ma mɨdeb. God ne kɨrop gak nɨbak, kɨri udɨn magɨl nɨŋ tep gɨl, gos tɨmɨd nɨŋ tep gɨl, yɨp oplap, yad gen kɨrop komɨŋ lɨpkop, agɨl, gak,” agak. Ar nɨbak nep kɨri Jisas nop nɨŋ dɨnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia bɨrarɨk nep mɨnɨm agak nɨbak, ne Jisas melɨk tep ne ak nɨŋɨl nɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pen Juda bɨ kɨb okok kɨri magɨlsek Jisas nop ma kɨrɨg gɨlak; bɨ kɨb koŋai yɨb nep nop nɨŋ dɨlak. Pen, bɨ Perisi cɨnop ag yokel cɨn Juda mogɨm gep karɨp ñɨlɨk mɨgan ak kauyaŋ ameb rek ma lɨnɨgab, agɨl me, Jisas nɨŋ dɨlak ak mɨseŋ ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jisas nɨŋ dɨlak ak mɨseŋ ma aglak ak, bin bɨ okok yɨb cɨn agel ar amnaŋ, agɨl gos nɨŋɨl, nɨg gɨlak. Pen tap tari gon God nɨŋek, nop tep gɨnɨgab, agɨl, gos ar nɨbak ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pen Jisas meg mɨgan dap ranɨl agak, “Bin bɨ an yɨp nɨŋ dɨnɨgab ak, yɨp nep mer, bɨ yɨp ag yokek onek nop abe nɨŋ dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bin bɨ an yɨp udɨn nɨŋnɨgab ak, yɨp nep mer, bɨ yɨp ag yokek onek nop abe udɨn nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yad lɨm dai wagɨn aul apɨl bin bɨ okok kɨrop melɨk ñebin. Nɨb ak, bin bɨ yɨp nɨŋ dɨnɨgal okok, kɨslɨm nab okok ma mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Bin bɨ mɨnɨm yad ak nɨŋɨl agebin rek ma gɨnɨgal okok, kɨrop mɨnɨm kɨb ma agnɨgain. Pen tari: yad bin bɨ lɨm dai ar wagɨn aul mɨdebal kɨrop mɨnɨm kɨb agnɨg ma onek; kɨrop dɨ komɨŋ yoknɨg onek. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pen bin bɨ yɨp ma dɨl, mɨnɨm yad ma dɨnɨgal okok, mɨnɨm kɨb agep ñɨn ak, mɨnɨm yad apin ak nep kɨrop mɨnɨm kɨb agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tari gɨnɨg: mɨnɨm yad apin ak, ke nɨŋɨl ma apin; Bapi yɨp ag yokak ak, nɨb nɨb agnɨmɨn, agɨp rek nep apin. ");
INSERT INTO kmh_m_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yad nɨpin, mɨnɨm ne ak nɨŋ denɨgal ak, kɨrop komɨŋ per mɨdep magɨl ak ñɨnɨgab. Nɨb ak, mɨnɨm yad agebin ak, Bapi mɨnɨm nɨb nɨb rek agnɨmɨn, agɨp rek nep agebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ñɨn kɨb Pasopa ñɨŋeb ñɨn ak tol, agɨl, Jisas nɨŋak, Nap nop lɨm dai ar wagɨn aul ag lak ñɨn ak padɨk amnak nɨŋɨl ne adɨk gɨ Nap ameb ñɨn ak maŋ owak. Pen bin bɨ ne ke lɨm dai ar wagɨn aul mɨdmagɨl lɨ mɨdɨl, mɨd damɨl, nop ñag pak lel, ne kɨmɨl Nap ne ker adɨk amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kɨjeki pen Saimon Iskariot ñɨ ne Judas nop gos ñek, Jisas nop titi gɨl damɨl bɨ kɨb okok kɨrop ñɨnɨm, agɨl, gos ak ned nep nɨŋ we gɨ lɨl, kɨsen cɨn Jisas bɨ ne okok Jisas eip Pasopa tap ñɨŋnɨg bɨsɨg gɨnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas ne nɨŋɨp, God ne tap okok magɨlsek dɨ ñɨnmagɨl ar ne lak. Jisas nɨŋɨp, ne Nap God eip mɨdɨl lɨm dai wagɨn aul apɨl, mɨd damɨl, kɨsen kɨmɨl, adɨk gɨ Nap mɨdeb amnɨg gek. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nɨb ak, Jisas warɨkɨl, walɨj par kɨb ne ak tɨg juɨl, tauel alap nab sɨŋak adaŋ paŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ñɨg ognap dɨ cög mɨgan alap soŋ gɨl, cɨnop bɨ ne okok tob cɨn ak ñɨg lɨlɨg gɨ, tauel pagak nɨbak dɨ lɨg gɨ yoklɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas nɨg gɨ dam dam, Saimon Pita tob ne ñɨg lɨnɨm, agek, Pita nop agak, “Bɨ Kɨb. Nak ke tob yɨp ak ñɨg lɨg gɨ yoknɨg geban?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Agek, Jisas agak, “Mɨñi gebin aul, nak mɨñi ma nɨpan, pen kɨsen mɨdɨl nɨŋnɨgaban,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jisas nɨb agek, Pita agak, “Mɨñi aka kɨsen okok, tob yɨp ak ñɨg lɨg gɨ ma yoknɨgan, mer yɨb!” agak. Agek, Jisas pen agak, “Tob nep ñɨg lɨg gɨ ma yokenɨgain ak, bɨ yad alap ma mɨdenɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jisas nɨb agek, Saimon Pita agak, “Bɨ Kɨb! Nɨb ageban ak, tob yɨp ak nep ñɨg lɨg gɨ ma yoknɨmɨn; ñɨn kɨd, kɨmɨg cög yad abe ñɨg lɨg gɨ yokan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nɨb agek, Jisas pen agak, “Bin bɨ an ñɨg bɨr pakɨp, bɨ nɨbak mɨb goŋ ne magɨlsek tɨd tep mɨdeb. Kauyaŋ ñɨg ma paknɨgab; tob kɨd ak nep ñɨg lɨg gɨ yoknɨgab. Nɨbi tɨd tep mɨdebɨm; pen nɨbi nokɨm alap nep tɨd tep ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas agak ak, nop mɨmɨg nɨŋnɨg gek bɨ nɨbak nop bɨr nɨŋak ak me, ne agak, “Nɨbi nokɨm alap nep tɨd tep ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pen Jisas tob cɨnop ñɨg lɨg gɨ yok sakɨl, walɨj tɨg ju lak ak dɨ tol gɨl, am kau ne sɨŋak bɨsɨg gɨl agak, “Nɨbep tob ñɨg lɨg gɨ yokpin mɨnɨm wagɨn ak nɨpɨm aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nɨb agɨl Jisas agak, “Yɨp Mɨnɨm Ag Ñeb Bɨ aka Bɨ Kɨb apɨm ak, nɨŋɨd apɨm. Yad Mɨnɨm Ag Ñeb Bɨ nɨbi abe Bɨ Kɨb nɨbi abe mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nɨb ak, yad Mɨnɨm Ag Ñeb Bɨ nɨbi, Bɨ Kɨb nɨbi, tob nɨbep ñɨg lɨg gɨ yokpin rek, nɨbi ak rek nep pen pen tob ñɨg lɨg gɨ yokɨl, tob ñɨg lɨg gɨ yokɨl, gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yad nɨbep gɨpin rek ak nɨŋɨl, nɨbi pen am bin bɨ ognap kɨrop nɨg aknɨb rek nep gɨnɨmɨb, agɨl, nɨbep kanɨb tep nɨbaul yobin. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nɨbep nɨŋɨd yɨb agebin, bɨ wög gɨ ñeb bɨ ak bɨ kɨb, bɨ nop kodeb bɨ ak bɨ sɨkol, ma mɨdeb; ak rek nep bɨ mɨnɨm dad ameb bɨ ak bɨ kɨb, bɨ nop ag yokak ak bɨ sɨkol, ma mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nag tep agesin nɨpɨm ar nɨbak gem amek, nɨbi mɨñ mɨñ gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“‘Nɨbi nokɨm alap nep tɨd tep ma mɨdeb,’ agesin ak, nɨbep magɨlsek, agɨl ma apin. Pen yad nɨbep bɨ yad dɨpin okok nɨŋ tep gɨpin. Bɨ alap yɨp mɨmɨg gɨnɨg gɨnɨgab ak, God Mɨnɨm ak ñu kɨl tɨkɨl aglak rek nep gɨnɨgab. Mɨnɨm nɨbak ñu kɨl tɨkɨl aglak, ‘Bɨ yad eip tap jɨm ñɨl ñɨborok bɨ nɨbak kaual maual rek lɨl yɨp gɨ tɨmel gak,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nɨbep ned, nɨb gɨl nɨb gɨl gɨnɨgab, agɨl agebin rek, kɨsen nɨg aknɨb rek nep genɨgab ak, ‘Yad Mɨdebin Rek Mɨdebin’ apin mɨnɨm nɨbak mɨnɨm nɨŋɨd, agɨl, nɨŋ dɨnɨgabɨm, agɨl, agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ yad ag yoknɨgain okok, bin bɨ an an kɨrop dɨnɨgal okok, kɨrop nep ma dɨnɨgal; yɨp abe dɨnɨgal. Pen bin bɨ an yɨp dɨnɨgal okok, yɨp nep ma dɨnɨgal; Bɨ yɨp ag yokek onek ak abe dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas mɨnɨm nɨbak agek, gos cɨbur mɨdmagɨl ne mɨker yɨb gek, agak, “Nɨbep nɨŋɨd yɨb agebin, nɨbi bɨ alap yɨp mɨmɨg gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nɨb agek, cɨn bɨ ne okok, bɨ an nop ageb ak, agɨl, gos par lɨl udɨn pen pen nɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pen Jisas bɨ ne mɨdmagɨl yɨb lolɨgɨp bɨ nɨbak, Jisas mɨdek maŋ sɨŋak bɨsɨg mɨdek ak me, ");
INSERT INTO kmh_m_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita bɨ nɨbak nop udɨn kɨbɨŋ nɨŋ padɨkɨl agak, “Bɨ an nop ageb ak ag nɨŋan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Agek, ne Jisas mɨdek maŋ sɨŋak lɨlɨg gɨ amɨl agak, “Bɨ Kɨb. Bɨ nɨbak bɨ an agesan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Agek, Jisas agak, “Yad bred kɨd aul dɨ ñɨg kɨnaŋ eyaŋ tauɨl nop ñɨnɨgain bɨ me ak,” agak. Nɨb agɨl, bred kɨd dɨ mɨdosɨp ak ñɨg acab eyaŋ tauɨl, dɨ Saimon Iskariot ñɨ ne Judas nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bred kɨd ak dɨp won nɨbak nep Seten ne Judas yɨpɨl nab ne eyaŋ sɨkak. Jisas Judas nop agak, “Tari gɨnɨg geban ak, kasek gan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pen cɨn Jisas bɨ ne, tari gɨnɨg Judas nop nɨb ageb, agɨl gos ma nɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ne mani wad ak kod mɨdolɨgɨp rek, cɨn Jisas bɨ ne ognap gos nɨŋnok, Jisas ne Judas nop agɨl, “Nak amɨl Pasopa tap ñɨŋnɨgabɨn ognap taunɨmɨn,” agɨl ag yokeb, agɨl gos nɨŋnok; cɨn ognap pen gos nɨŋnok, Jisas ne Judas nop agɨl, “Nak amɨl bin bɨ mani ma mɨdeb okok kɨrop mani ognap ñɨnɨmɨn,” agɨl ag yokeb, agɨl gos nɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pen Judas bred kɨd nɨbak dɨl warɨkɨl mɨs amnak. Karɨp bɨr kɨslɨm gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas mɨs amnak nɨŋɨl Jisas agak, “Maŋ mɨdeb God ne gek bin bɨ okok nɨŋnɨgal, Bɨ Ñɨ ne melɨk tep ke sek mɨdeb. Pen Bɨ Ñɨ ne melɨk tep ke sek mɨdeb ak nɨŋɨl, God melɨk tep ne abe nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pen bin bɨ kɨri Bɨ Ñɨ ne nɨŋ denɨgal ak, God melɨk tep aknɨb ke sek mɨdeb ak nɨŋnɨgal. Nɨb ak, dai God gek bin bɨ okok Bɨ Ñɨ ne melɨk tep aknɨb ke sek mɨdeb ak mɨseŋ nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ñɨ mɨdmagɨl yad sɨŋ aul! Yad nɨbep eip tapɨn ma mɨdenɨgain. Yad amenɨgain, yɨp amɨb akal, agɨl, yɨp pɨyo mer nɨŋnɨgabɨm. Pen Juda bɨ kɨb okok kɨrop apin rek, mɨñi nɨbep ak rek nep agebin: yad amnɨgain ak, nɨbi amnɨmɨb rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Pen mɨñi nɨbep lo kɨsen nɨb alap ag ñebin: nɨbi pen pen mɨdmagɨl lɨnɨmɨb. Yad nɨbep mɨdmagɨl lɨpin rek ak, nɨbi ak rek nep pen pen mɨdmagɨl lɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pen pen mɨdmagɨl lenɨgabɨm ak, bin bɨ okok magɨlsek mɨseŋ nɨŋnɨgal, nɨbi bɨ yad mɨdebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nɨb agek, Saimon Pita agak, “Bɨ Kɨb. Nak akal amnɨg geban?” agak. Agek, Jisas agak, “Yad amnɨgain okok nak mɨñi kɨsen gɨnɨmɨn rek ma lɨp; pen kɨsen me, yɨp kɨsen gɨnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Agek, Pita agak, “Tari gɨnɨg mɨñi nep kɨsen ma gɨnɨm? Nep kodnɨgain; yɨp ñag pak lenɨgal ak, mɨnɨm ma mɨdeb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Agek, Jisas pen agak, “Eip kɨmnɨgabɨr ageban mɨnɨm nɨbak mɨnɨm nɨŋɨd ageban aka? Nep nɨŋɨd yɨb agebin, kɨlokɨl kɨsen gaul gɨnɨgab; ned nep yɨj omal nokɨm agnɨgan, ‘Yad Jisas nop ma nɨpin,’ agnɨgan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pen Jisas agak, “Nɨbi gos mɨker nɨŋɨl ma pɨrɨknɨmɨb. Bapi nop nɨŋ dɨpɨm rek, yɨp ak rek nep nɨŋ dɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bapi yad karɨp ne ak ñɨlɨk mɨgan koŋai nep mɨdeb. Yad amɨl kau nɨbep gɨ jɨn gɨnɨgain. Mer ak, nɨb ma apnep. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yad am kau nɨbep gɨ jɨn gɨl, apɨl nɨbep poŋɨd dɨ dam, yad mɨdenɨgain sɨŋak nɨbi eip kabsek mɨdonɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yad amnɨg gebin kanɨb ak nɨbi nɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jisas nɨb agek, Tomas agak, “Bɨ Kɨb! Nak akal amnɨgan ak cɨn ma nɨpɨn. Nɨb ak, cɨn titi gɨl kanɨb ameb nɨŋɨn?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Agek, Jisas agak, “Yad nep kanɨb; yad nep mɨnɨm nɨŋɨd; yad nep komɨŋ mɨdep wagɨn ak. Bin bɨ yɨp onɨgal okok nep, Bapi onɨgal. Bin bɨ yɨp ma onɨgal okok, Bapi ma onɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yɨp nɨŋ tep gɨpkep, Bapi yad ak rek nep nɨŋ tep gɨpkep. Pen mɨñi nɨbi Bapi bɨr nɨpɨm; udɨn magɨl nɨbi ke Bapi bɨr nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nɨb agek, Pilip agak, “Bɨ Kɨb! Nak Bapi cɨnop yomek, nɨŋɨl, kɨsen tap alap nep ma ag nɨŋnɨgabɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Agek, Jisas agak, “Pilip. Yad nɨbep eip mɨlek padek mɨdenek ak, yɨp ma nɨŋɨl nɨb ageban ar? Bin bɨ yɨp udɨn nɨpal okok, Bapi abe bɨr udɨn nɨpal. Nɨb ak, nak tari gɨnɨg ageban, ‘Bapi cɨnop yomek nɨŋɨn,’ ageban? ");
INSERT INTO kmh_m_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yad Bapi nab ne adaŋ mɨdebin, Bapi nab yad adaŋ mɨdeb mɨnɨm ak ma nɨŋ dɨpan ar? Mɨnɨm nɨbep agebin ak mɨnɨm yad ke mer. Pen Bapi ne nab yad adaŋ mɨdɨl gek, cɨr apɨl mal wög ne nep gobɨr me ak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nɨb ak, yad Bapi nab ne adaŋ mɨdebin, Bapi nab yad adaŋ mɨdeb mɨnɨm ak, mɨnɨm nɨŋɨd, agɨl, nɨŋ dɨpkep. Pen mɨnɨm agebin ak ma nɨŋ dɨnɨgabɨm ak, Bapi gek cɨr apɨl mal tap ma gep okok gobɨr ak gos nɨŋɨl, ‘Ñɨ ak Bapi nab ne adaŋ mɨdeb, Bapi Ñɨ ne nab adaŋ mɨdeb ak me, nɨg gebir,’ agɨl, nɨŋ dɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ yɨp nɨŋ dɨnɨgal okok, yad tap ma gep gɨpin okok, kɨri abe ak rek nep gɨnɨgal. Pen yad Bapi ker amnɨgain rek, kɨri aknɨb rek nep ma gɨnɨgal; kɨri ke yɨb gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pen nɨbi bɨ yad mɨdebɨm rek, yɨb yad ak agɨl, tap tari tari ag nɨŋnɨgabɨm ak, Bapi melɨk tep ke sek mɨdeb ak nɨŋel, agɨl, agnɨgabɨm rek gɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nɨb ak me, tap tari tari yɨb yad ak agɨl ag nɨŋnɨgabɨm ak, agnɨgabɨm rek gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nɨbi yɨp mɨdmagɨl lenɨgabɨm ak, nɨbep agebin rek nep gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɨbi nɨg genɨgabɨm ak, yad pen Bapi nop agen, ne nɨbep Bɨ Goŋ Bak Lep ak ag yokek apɨl, nɨbep eip per per nep mɨdɨl, yad nɨbep gɨ ñölɨgɨpin rek, ne nɨbep ak rek nep gɨ ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bɨ Goŋ Bak Lep ak ne Kaun mɨnɨm nɨŋɨd ag ñeb ak. Ne God ne bɨ tigep bɨ rek mɨdeb mɨnɨm nɨŋɨd nɨbak ag ñeb. Bin bɨ lɨm dai ar wagɨn aul okok Bɨ Goŋ Bak Lep nop udɨn ma nɨpal; ne bɨ tigep bɨ rek mɨdeb ak ma nɨpal. Nɨb ak, nop nɨŋ dɨnɨmel rek ma lɨp. Pen mɨñi Bɨ Goŋ Bak Lep ne nɨbep eip mɨdeb; pen kɨsen nab nɨbep adaŋ mɨdenɨgab. Nɨb ak, nɨbi nop bɨr nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yad kɨmɨl, nɨbep ñɨ nap ma mɨdeb rek pɨs nep ma kɨrɨg gɨnɨgain; yad nɨbep adɨk gɨ onɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Maŋ mɨdeb, bin bɨ lɨm dai ar wagɨn aul mɨdebal okok yɨp ma nɨŋnɨgal pen nɨbi yɨp nɨŋnɨgabɨm. Yad komɨŋ mɨdenɨgain rek, nɨbi ak rek nep komɨŋ mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ñɨn nɨbak yad Bapi yad nab ne adaŋ mɨdebin mɨnɨm agnek wagɨn ak nɨŋ tep gɨnɨgabɨm. Pen nɨbi yɨp nab adaŋ mɨdebɨm, yad nɨbep nab adaŋ mɨdebin wagɨn ak, ak rek nep nɨŋ tep gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bin bɨ mɨnɨm yad agebin ak nɨŋ dɨl, agebin rek nep kɨsen gebal okok, yɨp mɨdmagɨl lɨl me, nɨg gebal. Pen bin bɨ yɨp mɨdmagɨl lɨpal okok, Bapi yad kɨrop ak rek nep mɨdmagɨl lɨnɨgab; yad ak rek nep kɨrop mɨdmagɨl lɨl, yad bɨ tigep bɨ rek mɨdebin kɨrop yomen, kɨri yɨp nɨŋ tep gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas nɨb agek, Judas (Judas nop mɨmɨg nɨŋak ak mer, Judas ke alap) ne Jisas nop agak, “Bɨ Kɨb. Tari gɨnɨg nak bɨ tigep bɨ rek mɨdeban ak, cɨnop bɨ ñon nep yomnɨgan, pen bin bɨ lɨm dai ke ke okok nep ma nɨŋ dɨpal bin bɨ okok kɨrop ma yomnɨgan?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Agek, Jisas agak, “Bin bɨ an yɨp mɨdmagɨl lɨnɨgab ak, mɨnɨm agebin ak dɨl agebin rek nep gɨnɨgab. Bapi yad nop mɨdmagɨl lɨl, cɨr apɨl nop apɨl, nop eip mɨdonɨgabɨr. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bin bɨ an yɨp mɨdmagɨl ma lɨnɨgab ak, mɨnɨm agebin ak dɨl agebin rek ma gɨnɨgab. Pen yad mɨnɨm agen nɨŋebɨm ak mɨnɨm yad ke mer; Bapi yɨp ag yokek onek ak, mɨnɨm ne me. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Yad nɨbep eip mɨdebin ñɨn aul me, mɨnɨm nɨbaul ag ñesin. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yad amnɨgain pen Bapi ne Bɨ Goŋ Bak Lep ak, Kaun Sɨŋ ak, ag yokek apɨl wög yad gɨpin rek gɨnɨgab. Kaun Sɨŋ ak ne nɨbep eip mɨdɨl mɨnɨm tep ak magɨlsek ag ñɨ tep gɨl, nɨbep gos tep ñek, nɨbi yad mɨnɨm tari tari apin okok magɨlsek gos nɨŋlɨg gɨ mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yad amnɨgain pen nɨbi kapkap mɨd tep gɨl mɨdenɨmɨb. Mɨnɨm nɨbak bin bɨ lɨm dai ar wagɨn aul okok yokop apal rek ma agebin. Yad ke apɨl gen, bin bɨ kapkap mɨd tep genɨmel rek lɨp. Nɨb ak nɨŋɨl yad nɨbep agebin, kapkap sain tɨkɨl mɨd tep gɨl mɨdenɨmɨb. Nɨb ak, cɨbur gos mɨdmagɨl mɨker nɨŋɨl ma pɨrɨknɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yad amɨl adɨk gɨ onɨgain, agesin mɨnɨm ak nɨŋɨl, nɨbi ti gɨnɨg cɨbur gos mɨdmagɨl mɨker nɨŋlɨg gɨ mɨdebɨm? Nɨbi yɨp mɨdmagɨl lɨpkep ak, Jisas amɨl Nap ne eip mɨdenɨgab, agɨl, mɨñ mɨñ gɨlɨg gɨ mɨdebkep. Ti gɨnɨg: Bapi ne yad rek mer; Bapi ne Bɨ kɨb yɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nɨb ak, nɨbep kɨrɨg ma ambin magɨl aul, nɨbep ned agebin me ak; kɨsen amenɨgain, gos ognap ma pɨyo nɨŋnɨgabɨm; mɨnɨm agebin ak nɨŋ dɨnɨgabɨm, agɨl agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Bin bɨ lɨm dai ar wagɨn aul yɨp ma nɨŋ dɨpal okok kɨrop kiŋ rek kod mɨdeb bɨ tɨmel nɨbak apeb ak me, yad nɨbep eip mɨnɨm par kɨb ag mɨdenɨm rek ma lɨp. Pen bɨ tɨmel nɨbak yɨp gɨ tɨmel gɨnɨgain ageb ak, kɨlɨs ne ma mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yad Bapi yad mɨdmagɨl lɨpin ak, bin bɨ okok nɨŋnɨmel, agɨl, Bapi yɨp agɨp rek nep magɨlsek gebin. “Pen mɨñi apem bɨr amnɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas mɨnɨm agɨl agak, “Yad me nag wain ak; Bapi yad me bɨ wög dai nap nɨb ak. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lek kɨd yad alap magɨl ma pɨlnɨgab ak, Bapi ne lek kɨd nɨbak tɨb yoknɨgab. Pen lek kɨd pɨlnɨgab ak, kɨsen magɨl koŋai nep pɨlnɨgab, agɨl, ne tɨb gɨ rɨk dɨ tep gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Yad nɨbep mɨnɨm tep ag ñen nɨpɨm rek, nɨbi bɨr sɨŋ tep rek mɨdebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yɨp nab adaŋ mɨdenɨmɨb; yad nɨbep nab adaŋ mɨdenɨgain. Lek kɨd okok, wagɨn sek jɨm ñɨl mɨdɨl nep, magɨl pɨlnɨgab; ke nep mɨdɨl magɨl ma pɨlnɨgab. Nɨb aknɨb rek nep, nɨbi yɨp jɨm ñɨl ma mɨdenɨgabɨm ak, magɨl ognap ma pɨlnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yad me nag wain ak, nɨbi me mɨbɨl lek okok. Bin bɨ an an yad eip jɨm ñɨl mɨdenɨgal okok, magɨl koŋai nep pɨlnɨgal; pen nɨbi ke ausek nep mɨdenɨgabɨm ak, tap alap ma gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nɨb ak, bin bɨ an yɨp nab adaŋ ma mɨdenɨgab ak, nag lek tɨb gɨ rɨk gel wagɨn eyaŋ yapɨl mɨlep gɨnɨgab rek ak mɨdenɨgab; nag lek nɨb okok dɨl dam mab dagɨlel yɨnnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pen nɨbi yɨp nab adaŋ mɨdɨl, mɨnɨm magɨl yad nab nɨbep adaŋ nɨŋ dɨlɨg gɨ mɨdenɨgabɨm ak, tap tari tari ag nɨŋnɨgabɨm ak, Bapi agnɨgabɨm rek gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɨbi tap magɨl koŋai yɨb nep pɨlnɨgab ak, bin bɨ yad nɨŋɨd yɨb mɨdenɨgabɨm. Nɨb ak, bin bɨ okok kɨri nɨŋɨl, Bapi yad Bɨ melɨk tep ke sek mɨdeb ak nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Bapi yɨp mɨdmagɨl yɨb lɨp rek, yad nɨbep ak rek nep mɨdmagɨl yɨb lɨpin. Nɨb ak, nɨbi yɨp cɨg gɨlɨg gɨ nep mɨdenɨmɨb, nɨŋɨl yad nɨbep mɨdmagɨl lɨlɨg gɨ mɨdenɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yad Bapi mɨnɨm ne ak kɨsen gen, yɨp mɨdmagɨl lɨlɨg gɨ nep mɨdeb. Nɨb aknɨb rek nep, nɨbi mɨnɨm yad ak kɨsen genɨgabɨm ak, yad nɨbep mɨdmagɨl lɨlɨg gɨ nep mɨdenɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mɨnɨm nɨbep agebin nɨbaul, yad ti gɨnɨg gɨl agebin? Yad mɨñ mɨñ yɨb gebin rek, nɨbi ak rek nep mɨñ mɨñ yɨb gɨnɨmɨb, agɨl, mɨnɨm nɨbaul agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yad pen nɨbep mɨnɨm kɨlɨs alap agnɨgain: yad nɨbep mɨdmagɨl yɨb lɨpin rek ak, nɨbi abe ak rek nep pen pen mɨdmagɨl yɨb lɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bɨ alap ne bɨ nɨŋeb ne okok gos nɨŋɨl kɨrop nen agɨl kɨmnɨgab ak, bɨ nɨbak bɨ nɨŋeb ne mɨdmagɨl yɨb lɨl me, nɨg gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yad agnɨgain rek gɨnɨgabɨm ak, nɨbi bɨ nɨŋeb yad mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Pen mɨñi yad nɨbep bɨ wög gɨ ñeb yad ma agebin; nɨbep bɨ nɨŋeb yad agebin. Bɨ wög gɨ ñeb okok, bɨ kod mɨdep kɨri, tap kɨri ar ak ma nɨpal. Pen yad Bapi mɨnɨm tari tari yɨp ag ñɨb ak, nɨbep mɨseŋ ag ñɨbin rek, nɨbep bɨ nɨŋeb yad apin. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nɨbi yɨp dɨn, agɨl, ma gɨpek; yad me nɨbep dɨnɨm, agɨl, nɨbep dɨnek. Nɨbi amem, tap magɨl koŋai nep, tap magɨl per per nep mɨdenɨgab ak pɨlnɨmɨŋ, agɨl, nɨbep wög nɨbak ag lɨpin. Nɨbi nɨg genɨgabɨm ak, nɨbi yɨb yad agɨl Bapi nop ag nɨŋem, tap tari tari ag nɨŋnɨgabɨm ak, ag nɨŋnɨgabɨm rek nɨbep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Yad nɨbep mɨnɨm kɨlɨs agɨl agebin, pen pen mɨdmagɨl lɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas bɨ ne okok kɨrop mɨnɨm ognap sek agɨl agak, “Bin bɨ lɨm dai ar wagɨn aul nɨbep mɨlɨk kal nɨŋnɨgal ak, gos kɨb ar nɨbak ma nɨŋnɨmɨb; Jisas nop ned mɨlɨk kal nɨŋlak rek, cɨnop gebal, agɨl gos ak nɨŋnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nɨbi bin bɨ lɨm dai ar wagɨn aul yɨp ma nɨŋ dɨpal okok rek mɨdebkep ak, nɨbep, bin bɨ cɨn, agɨl, dɨ mɨdmagɨl lɨplap. Nɨbep ma dɨnek ñɨn ak, lɨm dai ar wagɨn aul gos nɨpal rek gos nɨŋölɨgɨpɨm ak pen nɨbep dɨnɨgain agɨl den bɨ yad mɨdebɨm. Nɨb ak me, bin bɨ lɨm dai ar wagɨn aul nɨbep mɨlɨk kal nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pen ned nɨbep mɨnɨm agnek ak saköl ma gɨnɨmɨb: ‘Bɨ wög gɨ ñeb bɨ ak bɨ kɨb, bɨ nop kod mɨdeb bɨ ak bɨ sɨkol, ma mɨdeb.’ Nɨb ak, bin bɨ okok ognap yɨp gɨ tɨmel gɨpal rek, bin bɨ okok ognap nɨbep ak rek nep gɨ tɨmel gɨnɨgal; pen bin bɨ okok ognap mɨnɨm yad nɨŋ dɨl kɨsen gɨpal okok rek, bin bɨ okok ognap mɨnɨm nɨbi ag ñɨnɨgabɨm ak, ak rek nep dɨl kɨsen gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kɨri bɨ yɨp ag yokek onek ak nop ma nɨpal rek, nɨbi bɨ yad mɨdebɨm ak nɨŋɨl, nɨbep gɨ tɨmel gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Yad apɨl kɨrop mɨnɨm tep ma apnep ak, tap si tap tɨmel gɨl mɨnɨm kɨb yɨb ma dɨplap. Pen yad apɨl kɨrop ag ñɨ tep gɨnek rek, kanɨb kɨri ameb alap ma mɨdeb; kɨri tap si tap tɨmel gɨpal ak bɨr nɨpal, pen mɨñi kɨri ak rek nep tap si tap tɨmel nɨŋebir gebal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pen yɨp mɨlɨk kal nɨpal rek, yɨp nep mer, Bapi nop abe mɨlɨk kal nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yad kɨrop eip mɨdɨl, tap ma gep okok ma gɨpnep ak, tap si tap tɨmel gɨl mɨnɨm kɨb yɨb ma dɨplap. Pen yad apɨl tap ma gep okok gen yɨp mɨlɨk kal nɨpal rek, Bapi yad abe nop mɨlɨk kal nɨpal ak me, mɨnɨm kɨb nɨbak dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Gɨpal nɨbak, Depid ne God Mɨnɨm ak Juda kai lo cɨn apal mɨnɨm ognap ñu kɨl tɨkɨl agak rek nep gɨpal. Ne mɨnɨm nɨbak ñu kɨl tɨkɨl agak, ‘Mɨnɨm wagɨn mɨdek mer, yɨp yokop nep mɨlɨk kal nɨpal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pen yad am Bapi nop agen, ne pen Bɨ Goŋ Bak Lep ak nop ag yokek apɨl nɨbep eip kod mɨdenɨgab. Kaun mɨnɨm nɨŋɨd nep ag ñeb ak, yad bɨ tigep bɨ rek mɨdebin ak, nɨbep gos ñek, nɨŋnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pen nɨbi yad eip per ajölɨgɨpɨm ak rek, nɨbi abe amɨl bin bɨ okok kɨrop, yad tigep bɨ rek mɨdebin mɨnɨm ak ag ñem amnaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas mɨnɨm agɨl agak, “Yad nɨbep mɨnɨm agesin nɨbaul, nɨŋ tep gem me, kɨsen tari gek, yɨp kɨrɨg gɨl ma ap yap paknɨgabɨm, agɨl agesin. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pen nɨbep Juda mogɨm gep karɨp okok ag söŋ yokɨl, ‘Kauyaŋ ma onɨmɨb,’ agnɨgal. Pen nɨbak nep mer; kɨsen nɨbep ñag pak lɨnɨg genɨgal ak, nɨg genɨgabɨn God nop tep gɨnɨgab, agɨl gos nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nɨg gɨnɨgal ak, Bapi cɨrop apɨl ma nɨpal rek, nɨg gɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yad nɨbep ned, nɨg gɨl nɨg gɨl gɨnɨgab, agɨl mɨnɨm agesin nɨbak, kɨsen nɨg aknɨb rek nep genɨgab ak, Jisas ned cɨnop nɨg gɨnɨgab agak rek nep geb, agɨl gos nɨŋnɨgabɨm, agɨl, nɨbep mɨnɨm nɨbaul ag ñesin. “Pen ned yad ke nɨbepe eip mɨdölɨgɨpin ak me, yad nɨbep ned mɨnɨm nɨbak rek ma ag ñɨnek. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mɨñi Bɨ yɨp ag yokek onek ak adɨk gɨ amnɨg gebin pen nɨbi bɨ alap yɨp, ‘Akal amnɨg geban?’ agɨl, ma ag nɨŋeb. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mɨnɨm yad nɨbaul nɨŋem, mɨdmagɨl nɨbep ak pɨŋɨl ñek, gos par nɨŋebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pen yad nɨbep nɨŋɨd agebin, yad amenɨgain ak, nɨbep tep gɨnɨgab. Pen tari: yad ma amnɨgain ak, Bɨ Goŋ Bak Lep ak nɨbep ma onɨgab; pen yad amenɨgain ak, yad nop ag yoken, nɨbep onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne apɨl, bin bɨ lɨm dai ar wagɨn aul mɨdebal okok kɨrop gos kɨlɨs ñek, kɨri tap si tap tɨmel gɨl gac sek mɨdebal wagɨn ak nɨŋɨl, kɨri titi gɨl komɨŋ tep mɨdenɨgal wagɨn ak nɨŋɨl, God kɨrop mɨnɨm kɨb agnɨgab wagɨn ak nɨŋɨl, nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nɨb ak, yɨp ma nɨŋ dɨpal rek, Bɨ Goŋ Bak Lep ak kɨrop tap si tap tɨmel gɨpal ak yɨpɨd gɨl ag ñɨl, ‘Gac sek mɨdebɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yad am Bapi eip mɨdenɨgain nɨŋɨl kɨri yɨp ma nɨŋnɨgal rek, Bɨ Goŋ Bak Lep ak bin bɨ okok kɨrop komɨŋ tep mɨdep wagɨn ak yɨpɨd gɨl ag ñɨl, ‘Gac sek mɨdebɨm,’ agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pen bin bɨ lɨm dai ar wagɨn aul yɨp ma nɨŋ dɨpal okok kɨrop kiŋ rek kod mɨdeb bɨ tɨmel nɨbak, God ne nop mɨnɨm kɨb bɨr agak rek, Bɨ Goŋ Bak Lep ak, Seten bin bɨ ne okok ak rek nep mɨnɨm kɨb nɨŋnɨgal, agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mɨnɨm yad koŋai nep mɨdeb pen nɨbi mɨnɨm nɨb okok mɨñi nɨŋ dɨnɨmɨb rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pen Kaun mɨnɨm nɨŋɨd nep ag ñeb ak apenɨgab ak, God ne bɨ tigep bɨ rek mɨdeb mɨnɨm nɨŋɨd nɨbak magɨlsek nɨbep ag ñɨ tep gɨnɨgab. Mɨnɨm ne ar ognap ke dɨl ma agnɨgab; mɨnɨm peyɨg nɨŋnɨgab mɨnɨm nɨbak nep ag ñɨlɨg gɨ, kɨsen gɨnɨgab mɨnɨm ar ak nɨbep ag ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mɨnɨm yad ak dɨl, nɨbep ag ñɨnɨgab. Ne nɨg gek, bin bɨ okok melɨk tep ke yad ak nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pen Bapi tap ne tari tari mɨdeb okok, magɨlsek tap yad mɨdeb. Nɨb ak me agesin, ‘Kaun ne mɨnɨm yad ak dɨl, nɨbep ag ñɨnɨgab,’ agesin. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Yokop won alap mɨdeb, yɨp ma nɨŋnɨgabɨm; pen kɨsen yokop won alap mɨdɨl, yɨp kauyaŋ nɨŋnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisas nɨb agek, bɨ ne okok kɨri ke nep aglak, “‘Yokop won alap mɨdeb, yɨp ma nɨŋnɨgabɨm; pen kɨsen yokop won alap mɨdɨl, yɨp kauyaŋ nɨŋnɨgabɨm,’ agosɨp mɨnɨm nɨbak wagɨn tari mɨdeb? Pen mɨnɨm alap agosɨp, ‘Yad Bapi ker amnɨgain,’ agosɨp ak, tari mɨnɨm agosɨp?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nɨb agɨl, kɨri pen ag nɨŋ, pen ag nɨŋ gɨl aglak, “‘Yokop won alap’ agosɨp ak, tari gɨnɨg gɨl agosɨp? Agosɨp ak cɨn wagɨn alap ma tɨg nɨŋobɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nɨb agɨl, Jisas nop ag nɨŋnɨg gelak ak, ne ke nɨŋɨl kɨrop agak, “‘Yokop won alap mɨdeb, yɨp ma nɨŋnɨgabɨm; pen kɨsen yokop won alap mɨdɨl, yɨp kauyaŋ nɨŋnɨgabɨm,’ agesin mɨnɨm nɨbak nɨŋɨl me, pen pen ag nɨŋebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yad nɨbep nɨŋɨd yɨb agebin, bin bɨ lɨm dai ar wagɨn aul yɨp ma nɨŋ dɨpal okok, tap kɨri ke okok nep gos nɨŋɨl mɨñ mɨñ gɨnɨgal; pen nɨbi mapɨn gek sɨl aglɨg gɨ mɨdenɨgabɨm. Sɨl ag mɨdenɨgabɨm pen kɨsen nɨbi kauyaŋ mɨñ mɨñ yɨb gɨ mɨdenɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bin alap ñɨ pai ñɨbek nɨŋlɨg gɨ, yur kɨb dɨp, pen kɨsen ñɨ pai tɨk dap lɨl, won ak nep ne ñɨŋaŋ kɨsen karɨp lɨm sɨŋaul owɨp ak nɨŋɨl, yur mab ak saköl gɨl, mɨñ mɨñ gɨlɨg gɨ nep mɨdenɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nɨbi nɨb aknɨb rek, mɨñi mɨdmagɨl yur nɨbep pɨŋɨl ñɨl mɨdeb ak pen yɨp kauyaŋ nɨŋɨl, mɨñ mɨñ yɨb gɨnɨgabɨm. Bin bɨ ognap apɨl mɨñ mɨñ gep nɨbi ak ma pɨlɨ gɨ dɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ñɨn kɨsen nɨbak, nɨbi tap alap yɨp ma ag nɨŋnɨgabɨm. Nɨbep nɨŋɨd yɨb agebin, nɨbi yɨb yad agɨl Bapi nop ag nɨŋem, tap tari tari ag nɨŋnɨgabɨm ak, ag nɨŋnɨgabɨm rek nɨbep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nɨbi ned yɨb yad agɨl Bapi nop tap alap ma ag nɨpɨm. Pen mɨñi, yɨb yad agɨl ag nɨŋem, ag nɨŋnɨgabɨm rek nep gɨnɨgab nɨŋɨl nɨbi mɨñ mɨñ yɨb gɨnɨgabɨm. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Yad Bapi mɨnɨm ne ar ak agɨl, per mɨnɨm bak okok lɨl apin ak pen mɨñi maŋ mɨdeb, mɨnɨm nɨbak rek ma agnɨgain; mɨseŋ nep agnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ñɨn nɨbak apek, Bapi nop ag nɨŋnɨgabɨm ak, yɨb yad agɨl ag nɨŋnɨgabɨm. Pen yɨb yad ag nɨŋnɨgabɨm ak, yad ke Bapi ag nɨŋnɨgabɨm ar ak ma agnɨgain, mer; nɨbi ke yɨb yad agɨl Bapi ag nɨŋnɨgabɨm ak, nɨŋnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pen tari: Bapi nep yɨp ag yokek onek ak nɨŋ dɨl, yɨp mɨdmagɨl lɨpɨm ak me, ne ke nɨbep mɨdmagɨl lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bapi eip mɨdɨl kɨrɨg gɨl lɨm dai wagɨn aul onek; mɨñi lɨm dai wagɨn aul kɨrɨg gɨl kauyaŋ Bapi mɨdeb sɨŋak amɨl eip mɨdonɨgabɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jisas nɨb agek, bɨ ne okok aglak, “Mɨñi mɨnɨm bak okok lɨl ma ageban; mɨseŋ yɨb ageban. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mɨñi cɨn nɨpɨn, nak mɨnɨm okok magɨlsek bɨr nɨpan. Bin bɨ ognap mɨnɨm ag nɨŋeb kɨri mɨdenɨgab ak, nep ma ag nɨpal won ak, nak ke nɨŋɨl kɨrop ag ñɨnɨgan. Gɨpan nɨbak cɨn nɨpɨn, nak God eip mɨdɨl onak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nɨb agelak, Jisas agak, “Nɨb ak, ‘Cɨn mɨñi nɨŋ dɨpɨn,’ agɨl gos nɨpɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ulep apeb—pen mɨñi bɨr owɨp aul—yɨp kɨrɨg gɨl nɨbi karɨp ke ke amem, yad ke ausek mɨdenɨgain. Pen yad ke ausek ma mɨdenɨgain; Bapi yad mɨdeb rek, eip mɨdonɨgabɨr. ");
INSERT INTO kmh_m_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Pen nɨbep mɨnɨm ag ñesin nɨbaul, yɨp nab adaŋ nep mɨdɨl, kapkap mɨd tep gɨnɨmɨb, agɨl, ag ñesin. Lɨm dai ar wagɨn aul mɨdebɨm rek, nɨbep mɨker ñɨnɨgal. Pen gos sek mɨdenɨmɨb, tap tari tari lɨm dai ar wagɨn aul nɨbep gɨnɨgab ak, yad kɨlɨs nɨbak magɨlsek dɨ talak mɨgan yad ak bɨr lɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas mɨnɨm nɨbak ag dai juɨl, seb kab alaŋ nɨŋɨl agak, “Bapi. Ñɨn yɨp agnak ak mɨñi owɨp. Nɨb ak, nak gek, bin bɨ okok nɨŋnɨgal, yad Ñɨ nak melɨk tep aknɨb ke sek mɨdebin; pen yad Ñɨ nak gen, kɨri nɨŋnɨgal, nak Bapi melɨk tep aknɨb ke sek mɨdeban. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tari gɨnɨg: yɨp ke agnak rek, yad bin bɨ tɨgoŋ tɨgoŋ magɨlsek kod mɨdɨl, bin bɨ yɨp ag lɨnak okok kɨrop dɨl, komɨŋ per mɨdep won ak kɨrop ñɨnɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bin bɨ kɨri, nak God nɨŋɨd nokɨm nep mɨdeban ak nɨŋɨl, yɨp Jisas Krais ag yoknak ak nɨŋnɨgal bin bɨ okok, per per nep komɨŋ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Wög yɨp karɨp lɨm ar wagɨn aul agnak ak, gɨ damɨl gɨ sakpin ak me, bin bɨ lɨm dai ar wagɨn aul mɨdebal okok kɨri nɨpal, nak Bɨ melɨk tep aknɨb ke sek mɨdeban. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pen Bapi. Mɨñi nak genɨmɨn, ned karɨp lɨm ma gɨ lɨrok ñɨn ak, cɨri apɨl melɨk tep aknɨb ke sek mɨdölɨgɨpɨr rek, mɨñi kauyaŋ nɨb aknɨb rek nep mɨdenɨgabɨr. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Bin bɨ lɨm dai ar wagɨn aul okok ognap yɨp ñɨnak. Bin bɨ nɨb okok, kɨri bin bɨ nak mɨdölɨgɨpal pen yɨp ñɨnak. Nak tigep bɨ rek mɨdeban ak kɨrop ag ñɨnek. Yad mɨnɨm tep nak kɨrop ag ñɨnek, kɨri nɨŋ dɨl, ageb rek nep gɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mɨñi kɨri bɨr nɨpal, yad tap tari gɨpin okok, yad ke ma gɨpin. Kɨri nɨpal tap tari nak yɨp ñɨban ak nep dɨl kɨrop ñɨbin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mɨnɨm tari tari yɨp agnak ak, kɨrop ag ñen nɨŋ dɨpal. Nɨb ak, yad ned nak eip mɨdolɨgɨpɨr, nak yɨp ag yokek lɨm dai wagɨn aul onek mɨnɨm ak, nɨŋ dɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Kɨrop nep sobok gebin. Bin bɨ lɨm dai ar wagɨn aul nep nɨŋel mɨlɨk yowɨp okok ma sobok gebin. Bin bɨ yɨp apan okok nep, bin bɨ nak mɨdebal rek, nep sobok gebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bin bɨ yad okok ke, bin bɨ nak okok ke mer, bin bɨ cɨr apɨl nokɨm nep mɨdebal me. Kɨri gɨpal nɨbak nɨŋɨl, bin bɨ ognap okok nɨpal, yad bɨ melɨk tep ke sek mɨdebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pen mɨñi yad mɨdeban ak nɨnɨgain rek, kɨri ke ausek mɨdenɨgal. Bapi Sɨŋ! Nak kɨlɨs ke sek mɨdeban rek, yɨb yɨp ñɨnak yad ak rek nep mɨdebin. Yɨb kɨlɨs ke yɨb nak ak dɨl, kɨrop talak tauenɨmɨn, cɨr apɨl jɨm ñɨl mɨdobɨr rek, kɨri nɨb aknɨb rek nep jɨm ñɨl mɨdenɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yad kɨrop eip mɨdɨl, yɨb nak kɨlɨs nɨbak yɨp ñɨnak ak dɨl, kɨrop talak tauɨl kod mɨd tep gɨpin. Bɨ alap ma kɨr gɨp. God Mɨnɨm ñu kɨl tɨkɨl, bɨ alap pɨs nep ap yap pakɨl yur kɨb dɨnɨgab, aglak rek, bɨ nɨbak nep kɨr gak. Gak nɨbak, God Mɨnɨm ned ñu kɨl tɨklak rek nep gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Pen nak mɨdeban sɨŋak nɨnɨg gebin rek, mɨñi maŋ won alap sek lɨm dai ar wagɨn aul mɨdebin rek, kɨri nɨŋ mɨdel nɨŋlɨg gɨ, nep mɨnɨm nɨbaul agebin. Nɨb ak, yad mɨñ mɨñ yɨb gɨpin rek, kɨri ak rek nep mɨñ mɨñ yɨb gɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɨnɨm tep nak ak kɨrop ag ñen nɨŋ dɨpal rek, bin bɨ lɨm dai ar wagɨn aul okok kɨrop mɨlɨk kal nɨpal. Yad bin bɨ lɨm dai ar wagɨn aul gos nɨpal rek gos ma nɨpin rek, kɨri ak rek nep bin bɨ lɨm dai ar wagɨn aul gos nɨpal rek gos ma nɨpal. Nɨb ak me, bin bɨ lɨm dai ar wagɨn aul kɨrop mɨlɨk kal nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pen kɨrop lɨm dai wagɨn aul nɨb dam nak mɨdeban sɨŋak dad amnoŋ, agɨl ma agebin; nak kɨrop lɨm dai ar wagɨn aul kod mɨdenɨmɨn, Seten kɨrop gɨ tɨmel gɨnɨmɨŋ rek ma lɨnɨgab, agɨl agebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yad bin bɨ lɨm dai ar wagɨn aul gos nɨpal rek gos ma nɨpin; kɨri ak rek nep bin bɨ lɨm dai ar wagɨn aul gos nɨpal rek gos ma nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mɨnɨm nak ak, mɨnɨm nɨŋɨd nep nɨbak, kɨrop ag ñenɨmɨn, kɨri sɨŋ mɨdenɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nak yɨp bin bɨ lɨm dai ar wagɨn aul mɨdebal nab okok ag yoknak rek, yad kɨrop ak rek nep bin bɨ lɨm dai ar wagɨn aul mɨdebal nab okok ag yokpin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wög tari tari yɨp ñɨban ak, yad gɨ saknɨgain. Yad nɨg gebin ak, bɨ yad okok kɨri yɨp nɨŋɨl, cɨn ak rek nep God bɨ wög gep bɨ ne nep mɨdon, agɨl, wög kɨrop tari tari ñɨban ak, ak rek nep gɨ saklaŋ, agɨl, gebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Yad nep sobok gebin aul, bɨ mɨñi agesin kɨrop nep ma sobok gebin; kɨri mɨnɨm ag ñel, bin bɨ okok mɨnɨm kɨrop nɨŋ dɨl, yɨp nɨŋ dɨnɨgal okok, kɨrop abe sobok gebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bapi, nak yɨp nab adaŋ mɨdeban, yad nep nab adaŋ mɨdebin. Cɨr apɨl jɨm ñɨl mɨdobɨr rek, kɨri magɨlsek nɨb aknɨb rek nep cɨr apɨl eip jɨm ñɨl mɨdenɨmel. Nɨg gɨnɨgab ak, nak nep yɨp ag yokek onek ak, bin bɨ lɨm dai ar wagɨn aul mɨdebal okok nɨŋ dɨnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Cɨr apɨl jɨm ñɨl mɨdobɨr rek, kɨri ak rek nep jɨm ñɨl mɨdenɨmel, agɨl, nak melɨk tep aknɨb ke yɨp ñɨnak ak, yad pen kɨrop abe ak rek nep ñɨbin. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nɨb ak, nak yɨp nab adaŋ mɨdeban rek, yad kɨrop nab adaŋ mɨden me, kɨri jɨm ñɨl yɨb mɨdenɨmel. Nɨg gek me, bin bɨ lɨm dai ar wagɨn aul okok nɨŋnɨgal, nak nep yɨp ag yokek onek nɨŋɨl nak yɨp mɨdmagɨl lɨpan rek, kɨrop ak rek nep mɨdmagɨl lɨpan. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Bapi! Yɨp tep gɨp ak, bin bɨ yɨp ñɨban okok, am yad mɨdenɨgain sɨŋak eip mɨdɨl, lɨm dai ma gɨ lɨrok ñɨn ak, yɨp mɨdmagɨl lɨl melɨk tep aknɨb ke yɨp ñɨnak ak nɨŋnɨmel. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Bapi! Nak me bɨ asɨŋ ma mɨdeb! Bin bɨ lɨm dai ar wagɨn aul okok kɨri nep ma nɨpal. Pen yad nep nɨpin. Bin bɨ yad sɨŋ aul nak nep yɨp ag yokek onek ak, nɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nak tigep bɨ rek mɨdeban ak, yad kɨrop ag ñɨbin. Pen kɨsen ak rek nep, nak tigep bɨ rek mɨdeban ak yad kɨrop ag ñɨ tep gɨnɨgain. Nɨg gɨl, yad ke kɨrop nab adaŋ mɨden, nak yɨp mɨdmagɨl lɨpan rek nɨŋ tep gɨl, kɨri ak rek nep pen pen mɨdmagɨl lɨnɨmel,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas Nap nop sobok gɨ mɨbɨl juɨl, bɨ ne okok eip ñɨg sɨkol Kidron juɨl, pɨs kɨdadaŋ amɨl, mab olip wög dai ak amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mab olip wög dai nɨbak Jisas bɨ ne okok eip per am mogɨm gölɨgɨpal rek, Judas bɨ Jisas nop mɨmɨg nɨŋnɨg gek ak, mɨgan nɨbak nɨŋ tep gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Perisi bɨ okok abe, bɨ God nop tap sobok gep bɨ kɨb okok abe, Judas nop agelak, ne am ami bɨ ognap poŋ dɨl, God sobok gep karɨp polisman ognap poŋ dɨl, dam Jisas mɨdek sɨŋak amjakak. Kɨri pen pen ñagep tap ognap dɨl, sɨp ognap lam ognap dagɨl dɨl, apelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas nop tap tari gɨnɨg gak ak nɨŋak ak me, apelak ak amɨl agak, “Bɨ an nop pɨyo nɨŋ ajebɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Agek aglak, “Jisas, bɨ Nasaret nɨb ak,” aglak. Agelak, Jisas agak, “Bɨ nɨbak me yad aul,” agak. Pen won nɨbak, bɨ nop mɨmɨg nɨŋak ak, Judas, kɨri eip nɨb sɨŋak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pen Jisas, “Bɨ nɨbak me yad aul,” agek, kɨri kɨd ken lɨlɨg gɨ amɨl gɨ dam pak lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisas pen kɨrop kauyaŋ agak, “Bɨ an nop pɨyo nɨŋ ajebɨm?” agak. Agek aglak, “Jisas, bɨ Nasaret nɨb ak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Agelak, Jisas agak, “Nɨbep mɨdarɨk nep apin, ‘Bɨ nɨbak me yad aul.’ Yɨp pɨyo nɨŋ ajebɨm rek, bɨ sɨŋ aul kɨrop kɨrɨg gem amnɨlaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Gak nɨbak, Jisas ned Nap nop agak rek nep gak. Ne Nap nop agak, “Bapi. Bɨ yɨp ñɨnak okok, nokɨm alap ma kɨr gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pen won nɨbak nep, Saimon Pita tu par kɨd dowak ak lɨp gɨ dɨl, bɨ alap nop tɨmɨd yɨpɨd pɨs kɨd pɨs nep tɨb sak yokak. Bɨ nɨbak yɨb ne Malkas. Ne God nop tap sobok gep bɨ kɨb yɨb ak nop bɨ wög gɨ ñeb ne ak mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pita nɨg gek, Jisas agak, “Tu par kɨd dɨpan kauyaŋ lek amnaŋ! Nak Bapi ñɨg sɨlek yɨp ñɨb ak ma ñɨŋnɨgain, agɨl nɨpan ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jisas nɨb agek nɨŋlɨg gɨ, ami bɨ okok abe, God sobok gep karɨp polisman okok abe, Jisas nop dɨ cɨcɨ lɨl, nag lɨ wös gɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","kɨri ned Jisas dam Anas mɨdek sɨŋak amnɨlak. Bɨ Anas nɨbak, Kaiapas nɨmak ne. Kaiapas me, mɨ nokɨm nɨbak, God nop tap sobok gep bɨ kɨb yɨb wög ak ag lel gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas ne me ned Juda bɨ mɨnɨm dɨ bɨlokep kɨrop agak, “Bɨ nokɨm alap kɨmek cɨn magɨlsek komɨŋ amnɨgabɨn ak tep,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pen Jisas nop nɨg gɨl, dam Anas karɨp ak amelak nɨŋɨl, Saimon Pita eip, yad Jon eip, cɨr mal kɨsen kɨsen amnɨrok. Bɨ God nop tap sobok gep bɨ kɨb yɨb ak yɨp nɨŋ tep gak rek, yad amɨl pɨs nep karɨp ne wari mɨgan eyaŋ am nɨnek; ");
INSERT INTO kmh_m_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pen Pita ne söŋ kɨd eyaŋ ar mɨdek. Yad pen adɨk gɨ apɨl, bin kɨjoŋ wagɨn kod mɨdek ak nop agɨl, Pita nop poŋ dɨl wari mɨgan eyaŋ amnɨrok. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pen bin kɨjoŋ wagɨn kod mɨdek ak, Pita nop agak, “Nak ak rek nep Jisas bɨ ne alap ar?” agak. Agek, Pita pen agak, “Yad mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pen Kaiapas nop wög gɨ ñeb bin bɨ ognap abe, God sobok gep karɨp polisman ognap abe, kɨrop yɨgen gek, mab bɨj tɨn kab nab nɨb sɨŋak pɨboŋ mɨdek, warɨkɨl maŋɨl mɨdelak. Pita nop ak rek nep yɨgen gek, ap nab nɨb sɨŋak kab sek, kɨrop eip mab maŋɨl mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pen Anas, bɨ God nop tap sobok gep bɨ kɨb yɨb ned mɨdolɨgɨp ak, Jisas nop ag nɨŋak, “Bin bɨ nak bin bɨ an an? Nak mɨnɨm tari tari bin bɨ nak ag ñɨban?” ag nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Agek, Jisas pen agak, “Yad mɨnɨm ognap we gɨl ma ag ñɨbin; bɨ nɨbi okok nɨŋ mɨdel nɨŋlɨg gɨ, Juda mogɨm gep karɨp okok abe, God sobok gep karɨp ak abe, per mɨseŋ ag ñɨbin. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nɨb ak, tari gɨnɨg yɨp mɨnɨm ag nɨŋeban? Bin bɨ mɨnɨm ag ñɨnek nɨŋ mɨdelak ognap dapɨl ag nɨŋɨm. Mɨnɨm tari tari ag ñɨbin ak nɨpal me,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas nɨb agek, God sobok gep karɨp kod mɨdolɨgɨp polisman alap, nop mɨkem ak pakɨl agak, “Tari gɨnɨg bɨ God nop tap sobok gep bɨ kɨb yɨb ak nop mɨnɨm nɨbak rek ageban?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Agek, Jisas pen agak, “Yad mɨnɨm esek alap apin, agɨl, mɨnɨm esek apin nɨbak bin bɨ sɨŋ aul kɨrop mɨseŋ ag ñan. Pen mɨnɨm nɨŋɨd apin ak, nak tari gɨnɨg yɨp pakesan?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jisas nop nag lɨ rɨbɨklak rek mɨdek nɨŋlɨg gɨ, Anas agek kɨri Jisas nop dam, bɨ God nop tap sobok gep bɨ kɨb yɨb kɨsen nɨb ak, Kaiapas, dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pen Pita ne nɨg warɨkɨl gɨ mɨdɨl mab maŋɨl mɨdek nɨŋlɨg gɨ, bɨ ognap nop aglak, “Nak abe bɨ ne alap eip aka?” aglak. Agelak, Pita ag sɨlokɨl agak, “Yad mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pen bɨ Pita tɨmɨd tɨb sak yokak ak, bɨ tɨdɨg lek lek ne alap, God nop tap sobok gep bɨ kɨb ak nop wög gɨ ñeb bɨ ne alap ap mɨdek. Ne apɨl, Pita nop agak, “Yad nep nɨpin, nak bɨ nɨbak eip mab olip wög dai sɨŋak mɨdesan ar?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Agek Pita kauyaŋ ag sɨlokɨl agak, “Yad mer,” agak. Nɨb agek nɨŋlɨg gɨ, dai kɨlokɨl gaul gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Karɨp tɨk dam lek nɨŋlɨg gɨ, Juda kai kɨri Jisas nop Kaiapas karɨp nɨbak nɨb dam Rom gapman bɨ kɨb Pailot karɨp kɨb ak amnɨlak. Juda kai aglak, “Cɨn Rom bɨ karɨp mɨgan aul amon, cɨnop asɨŋ ulɨk gɨnɨgab nɨŋɨl cɨn Pasopa tap ñɨŋjɨn rek ma lɨnɨgab,” agɨl, mɨs eyaŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nɨb ak, Pailot mɨs amɨl agak, “Bɨ aul nop tari mɨnɨm nɨŋɨl dopɨm?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Agek, kɨri aglak, “Ne tap tɨmel alap ma apkop, nep nɨg ma dopnop,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Agelak, Pailot agak, “Nɨbi dam lo nɨbi ke ageb rek ar ak nɨŋɨl, nɨbi ke mɨnɨm kɨb agɨm,” agak. Agek, Juda kai pen aglak, “Cɨn bin bɨ okok kɨrop mɨnɨm kɨb agɨl, ñag pak lon kɨmnɨmel, lo ar ak ma mɨdeb. Rom gapman kai cɨnop mer apal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Juda kai nɨg gɨlak ak, Jisas yɨp titi gel kɨmnɨgain, agɨl, agak rek nep gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pen Juda kai nɨb agelak, Pailot kauyaŋ adɨk gɨ karɨp mɨgan eyaŋ amɨl, Jisas owaŋ, agek, apek nop agak, “Nak Juda kai kiŋ kɨri ak aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Agek, Jisas agak, “Mɨnɨm yɨp ag nɨŋeban ak, meg mɨgan nak ak ke ageban aka bin bɨ ognap meg mɨgan kɨri ak dɨl ageban?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Agek, Pailot agak, “Yad Juda bɨ mer. Juda kai nak okok nep, bɨ God nop tap sobok gep bɨ kɨb nak okok nep me, nep dapɨl ñɨnmagɨl ar yɨp ñɨbal. Nak tap tari genak nɨg gɨpal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Agek, Jisas agak, “Yad bin bɨ dɨl kod mɨdenɨgain ak, kiŋ lɨm dai ar wagɨn aul mɨdebal rek ma mɨdenɨgain. Yad lɨm dai wagɨn aul kiŋ mɨdnɨg gebnep, Juda bin bɨ okok yɨp nag lɨn, agebal okok, bin bɨ yad okok warɨkɨl kɨrop eip pen pen ñaplap. Pen yad bin bɨ dɨl kod mɨdenɨgain nag ar yad ke mɨdeb; lɨm dai wagɨn aul gɨpal rek mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nɨb agek, Pailot agak, “Nɨb ak, nak kiŋ alap aka?” agak. Agek, Jisas pen agak, “Me nak eyɨk apan me ak. Ar nɨbak nep me, yɨp lɨm dai ar wagɨn aul tɨk dapel, yad mɨd kɨb gɨl, mɨnɨm nɨŋɨd yɨpɨl yɨb ak ag ñebin. Bin bɨ mɨnɨm nɨŋɨd yɨb dɨn, agɨl gos nɨpal okok, mɨnɨm yad ak nɨŋ dɨpal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nɨb agek, Pailot agak, “Pen mɨnɨm okok nɨb okok nɨb koŋai nep pɨg dɨl mɨdeb ak, cɨn titi gɨl mɨnɨm nɨŋɨd yɨb me ak, agɨl nɨŋɨn?” agak. Pailot mɨnɨm nɨbak agɨl, kauyaŋ söŋ amɨl, Juda kai kɨrop agak, “Yad ne tap tɨmel alap gɨp ma nɨpin. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pen cɨn Rom gapman, mɨ nokɨm nokɨm, Pasopa ñɨn kɨb ak apek, bɨ nagɨman nɨbi alap yokop wɨsɨb yokpɨn. Nɨb ak, Juda kai kiŋ kɨri ak, yokop wɨsɨb yoken amnɨmɨŋ aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Agek, meg mɨgan dap ranɨl aglak, “Nop mer! Cɨnop Barabas nop wɨsɨb yokan!” aglak. Bɨ Barabas nɨbak, bin bɨ okok kañ kañ gek gapman kai kɨrop eip pen pen ñaglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nɨb agelak, Pailot ami bɨ ne okok agek, Jisas nop nag dɨl pak adɨk madɨk gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nɨg gɨl pakɨl, nag mɨgoñɨb ñu ñu sek ognap dɨl, kiŋ lɨpal rek usajɨl bad alap gɨl, Jisas nop tol gɨ ñɨl, walɨj mɨk par sek alap lɨ ñɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","nop kauyaŋ amɨl kauyaŋ amɨl aglak, “Nak Juda kai kiŋ kɨri, nak per nep mɨdenɨmɨn!” aglak. Nɨb aglɨg gɨ, nop mɨlɨk jo mɨlɨk paklak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pen Pailot kauyaŋ söŋ amɨl, Juda bin bɨ kɨrop agak, “Nɨŋɨm! Yad Jisas nop söŋ aul donɨgain nɨŋɨl nɨbi nɨŋnɨgabɨm, yad ne tap tɨmel gɨp wagɨn alap ma pɨyo nɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pen Jisas nop usajɨl ñu ñu sek bad ak tol gɨ ñɨl, walɨj mɨk par sek ar lɨ ñɨlak ak sek apek nɨŋlɨg gɨ, Pailot kɨrop agak, “Nop nɨŋɨm!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nɨb agek, bɨ God nop tap sobok gep bɨ kɨb okok abe, God sobok gep karɨp polisman okok abe, Jisas nop nɨŋɨl mɨnɨm bleble gɨl aglak, “Nop mab bak alaŋ ñag pak lɨm! Nop mab bak alaŋ ñag pak lɨm!” aglak. Nɨb agelak, Pailot agak, “Nɨbi ke nop damɨl, mab bak alaŋ ñag pak lɨm. Yad ne tap tɨmel gɨp wagɨn alap ma pɨyo nɨpin!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Agek, Juda kai aglak, “Ne, ‘Yad God Ñɨ ne,’ agɨp ak, lo cɨn alap agɨp, ‘Kɨmnɨmɨŋ,’ agɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nɨb agelak, Pailot nɨŋɨl, tapɨn pɨrɨkɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kauyaŋ karɨp mɨgan eyaŋ amɨl, Jisas nop ag nɨŋɨl agak, “Nak karɨp lɨm akal nɨb?” agak. Agek, Jisas mɨnɨm alap pen ma agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailot agak, “Nak yɨp mɨnɨm ma agnɨgan ar? Nak nɨpan. Yad nep kod mɨdebin. Nɨb ak, nep wɨsɨb yoknɨg wɨsɨb yoknɨgain; pen nep mab bak alaŋ ñag pak lɨlaŋ, agen, nep ñag pak lɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Agek, Jisas pen agak, “Pen nak yɨp kod mɨdeban ak, nak ke mer, God nep agek kod mɨdeban. Nɨb ak, yɨp gɨ tɨmel geban mɨker ak, nak nep ma dɨnɨgan; bɨ yɨp dɨl nep ñɨb ak, mɨker kɨb yɨb ak dɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jisas nɨb agek, Pailot nop yokop ag yokin, agɨl, gos nɨŋak ak pen Juda kai nop bɨlalö gɨ agɨl aglak, “Nak Jisas nop wɨsɨb yokenɨgan ak, Rom bɨ kɨb Sisa bɨ nɨŋeb ne ma mɨdenɨgan. Bɨ, yad kiŋ mɨdebin, apal okok, Sisa eip pen pen ñag lɨn, agɨl me, mɨnɨm nɨbak rek apal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nɨb agelak, Pailot mɨnɨm nɨbak nɨŋɨl, am Jisas nop poŋ dɨl söŋ amɨl, ne am bɨ mɨnɨm dɨ bɨlokep sea ar sɨŋak alaŋ gɨlak ar ak bɨsɨgak. Kau bɨsɨgak nɨbak, “Kab Kɨjoŋ” apal. Pen Arameik mɨnɨm lɨl, “Gabada” apal. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pen ñɨn nɨbak, Juda bin bɨ Pasopa tap kɨri mogɨm gep ñɨn. Pɨb nab kɨb alaŋ won ak, Pailot kɨrop agak, “Kiŋ nɨbi me aul!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Agek, meg mɨgan dap ranɨl aglak, “Nop ñag pak lan! Nop mab bak alaŋ ñag pak lan!” aglak. Agelak, Pailot agak, “Kiŋ nɨbi nɨbaul mab bak alaŋ ñag pak lɨnɨm aka?” agak. Agek, bɨ God nop tap sobok gep bɨ kɨb okok aglak, “Kiŋ cɨn alap ma mɨdeb; Rom bɨ kɨb Sisa nep mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pen nɨg gɨ ag damɨl, Pailot mɨnɨm kɨrop ak dɨl, ami bɨ okok kɨrop agak, “Jisas nop dam mab bak alaŋ ñag pak lɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pen nop ñag pak lɨnɨg gɨlak mab kros ak, Jisas nop ke ñel, ne dɨ ka gɨ dam “Cɨp Nabɨc Cög Tɨŋɨl” apal dɨm ak apjakak. Dɨm nɨbak Arameik mɨnɨm lɨl “Golgota” apal. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jisas nop mab kros cɨpɨl pak lɨl, bɨ omal, alap pɨs kɨd, alap pɨs kɨd, ñag pak lɨlak. Jisas nab sɨŋak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pen Pailot agek, bɨ ne okok mab bog alap dɨl ñu kɨl tɨkɨl, Jisas nop ñag pak lɨlak mab kros bak nabɨc sɨŋak adaŋ dɨlam gɨ lɨlak. Ñu kɨl tɨklak mɨnɨm ak: ");
INSERT INTO kmh_m_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mɨnɨm nokɨm ar nɨbak nep, Arameik mɨnɨm ñu kɨl tɨkɨl, Latin mɨnɨm ñu kɨl tɨkɨl, Grik mɨnɨm ñu kɨl tɨkɨl gɨlak me, Jerusalem ulep nɨb sɨŋak mɨdek rek, Juda bin bɨ koŋai nep udɨn lɨ nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pen God nop tap sobok gep bɨ kɨb okok am Pailot nop aglak, “Mɨnɨm ñu kɨl tɨkpan ak yɨpɨd gɨl ma gɨp. ‘Juda kai kiŋ kɨri’ mɨnɨm ak ma mɨdonɨmɨŋ; yokop agnɨmɨn, ‘Ne agɨp, “Yad Juda kai kiŋ kɨri mɨdebin,” agɨp,’ agɨl, mɨnɨm nɨbak nep ñu kɨl tɨknɨmɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nɨb agelak pen Pailot kɨrop pen agak, “Yad mɨnɨm tari ñu kɨl tɨkpin ak, nɨg gɨl nep mɨdenɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pen Jisas nop mab bak alaŋ ñag pak lɨl, ami bɨ omal omal Jisas walɨj ne okok bɨlok ke ke dɨl, walɨj par sek gɨl ñag dör ma gɨlak ak, ak rek nep bɨlok dɨnɨg aglak, ");
INSERT INTO kmh_m_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Tɨg bɨlɨlɨ ma gɨn! Yokop sadu rek gɨl, bɨ an dɨnɨmɨŋ ak, ne dɨnɨgab,” aglak. Gɨlak nɨbak, God bɨrarɨk nep bin bɨ okok kɨrop gos ñek, God Mɨnɨm ak ñu kɨl tɨkɨl, kɨsen nɨb gɨnɨgal, aglak ak me, kɨsen aknɨb rek nep gɨlak. Mɨnɨm nɨbak ñu kɨl tɨkɨl aglak, “Walɨj yɨp ak bɨlok ke ke dɨl, walɨj par sek yad ak, sadu rek gɨl dɨn, aglak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pen ñɨn nɨbak, Jisas nonɨm ak, nɨmañ ak, Klopas bine Maria ak, Maria Magdala ak, apɨl Jisas nop mab kros ñag pak lɨlak maŋ gol nɨb sɨŋak mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yad Jon, Jisas yɨp mɨdmagɨl lolɨgɨp bɨ ak, ak rek nep ap maŋ nɨb sɨŋak mɨdenek ak me, Jisas yɨp nɨŋɨl, nonɨm Maria nop agak, “Bin aul, ñɨ nak me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nɨb agɨl, ne pen nonɨm Maria nɨŋɨl yɨp agak, “Nanɨm nak me ak,” agak. Nɨb agek nɨŋlɨg gɨ, ñɨn nɨbak, Jisas nonɨm nop poŋ dɨl karɨp yad ak damɨl, eip mɨdolɨgɨpɨr. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas nɨŋak, wög ar ne ak magɨlsek gɨ sakak ak me, God Mɨnɨm agak ak nɨŋɨd lɨnɨmɨŋ, agɨl, agak, “Yɨp kɨŋam mɨlep gɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pen ñɨg wain sɨlek barol alap dap nɨb sɨŋak lel mɨdek ak me, ami bɨ alap, tap sain bad alap dɨl, wain sɨlek nɨbak lɨl, dɨ mab hisop lek dai ak kabɨs ñagɨl, dap ranɨl Jisas nop joŋɨb wak ar sɨŋak lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas ñɨg wain sɨlek nɨbak ñɨbɨl agak, “Dai juɨp,” agɨl, kɨbor kɨyan gɨl, kaun ne God nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pen Juda bɨ kɨb okok, kagol ñɨn ak dɨgep won ak bɨr aposɨp nɨŋɨl aglak, “Tol God nop sobok gep ñɨn cɨn ak, cɨp okok mab bak alaŋ ma mɨdenɨmel,” agɨl, am Pailot nop aglak, “Bɨ mab bak alaŋ ñag pak lɨpal okok, ami bɨ okok tob kɨrop okok pak pagel, kasek kɨmel, dɨ lɨm eyaŋ lɨnɨmel,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Agelak, Pailot ami bɨ okok kɨrop agek, am bɨ Jisas eip ñag pak lɨlak omal, tob kɨrop mal pak paglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pen Jisas tob nop ak pak pagɨn, agɨl, nɨŋlak, ne bɨr kɨmak. Nɨb gak ak me, tob nop ak pak pag ma gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pen ami bɨ alap, golɨŋ alap dɨl, Jisas nop tɨglem dai sɨŋak pɨŋ lek, dai lakañ sek, ñɨg sek soŋ gak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nɨb ak, nɨbi bin bɨ mɨnɨm ñu kɨl tɨkebin nɨbaul nɨŋnɨgabɨm okok abe Jisas nop nɨŋ dɨnɨmɨb, agɨl, yad Jon, Jisas nop gak ak udɨn yad ke nɨpin rek, nɨbep mɨnɨm nɨŋɨd yɨb nɨbaul agɨl ñu kɨl tɨkebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pen gak nɨbak, God bɨrarɨk nep bin bɨ okok kɨrop gos ñek, God Mɨnɨm ak ñu kɨl tɨkɨl, kɨsen nɨb gɨnɨgal, aglak ak me, kɨsen nɨg anɨb rek nep gɨlak. God Mɨnɨm ak ñu kɨl tɨkɨl aglak, “Tɨŋɨl nop ak, alap pak pag ma gɨnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pen mɨnɨm alap aglak, “Bɨ nop pɨŋɨl gesal ak nop nɨŋnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bɨ Arimatia taun nɨb alap, Jisas mɨnɨm nop nɨŋ dak ak pen, Juda bɨ kɨb kɨrop pɨrɨkɨl, Jisas nop nɨŋ dɨpin, agɨl, mɨseŋ ma agolɨgɨp. Bɨ nɨbak yɨb ne Josep. Ne Jisas nop dam tɨgel gɨnɨm, agɨl, am Pailot nop ag nɨŋek, yau agek, dad amnak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas ne Josep eip amnɨrek. Nikodimas, bɨ ned am Jisas nop kɨslɨm eyaŋ nɨŋak bɨ nɨbak. Nikodimas tap ki tep owep koŋai nep, kilo aknɨb ñɨnjuɨl nokɨm alap adɨk gɨ dam aknɨb ajɨp pɨs adaŋ (35) rek, dɨl amnak. Tap ki tep owep nɨbak, mab mö mok ak abe, mab alos mok ak abe dɨl gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pen kɨri mal am cɨp se ak tɨg asɨk dap yapɨl, Juda bin bɨ gölɨgɨpal rek, mab mok dad amnak ak, cɨp se par anöŋ lɨ ñɨl, linɨn dɨl walɨj tɨd gɨlak sɨkol par ak dɨl, kom kam gɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas mab bak alaŋ ñag pak lɨlak kau nɨb ulep sɨŋak wög dai alap mɨdek. Wög dai nɨbak nab sɨŋak kab mɨgan kɨsen nep kɨrɨkɨl, cɨp tɨgel ma gɨlak alap mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juda kai God nop sobok gep ñɨn kɨri ak ulep ulep gak rek, kasek tɨgel gɨr, agɨl, kab mɨgan yokop ulep nɨb sɨŋak dam tɨgel gɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sade ñɨn ak, karɨp tɨknɨg gek nɨŋlɨg gɨ, Maria Magdala cɨp tɨgel gɨlak mɨgan amɨl nɨŋak, kab kɨb cɨp tɨgel pɨlɨŋ gɨlak ak, lɨlɨg gɨ am gol sɨŋak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ne nɨŋɨl, kauyaŋ pɨg gɨ rɨkɨd ag apɨl Saimon Pita cɨr mal mɨdorok sɨŋak apɨl agak, “Bɨ Kɨb ak nop kapkap dad ambal; pen dap lɨpal okok ma nɨpɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Nɨb agek, Pita cɨr mal nɨŋnɨg kasek pɨg gɨ rɨkɨd yɨb ag amɨl paŋ dɨrok. Yad ned amjakɨl, ");
INSERT INTO kmh_m_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","mɨs ar kɨdeyaŋ nep mɨdɨl, kab mɨgan oŋɨd sɨpsɨp nɨŋnek walɨj bad okok nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Pen Saimon Pita ne kɨsen apɨl, kab mɨgan ak sɨkɨd amɨl nɨŋak, Jisas nop walɨj kom sɨlok yoklak okok wɨsɨb ma gak; tɨgel gɨlak rek nep mɨdek. Pen walɨj nabɨc oŋɨd pag kom mɨd pakɨd gɨlak ak, ak rek nep ma wɨsɨbak; pag kom mɨd pakɨd gɨlak rek nep asɨk gɨ ke sɨŋak mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yad ned cɨp tɨgel gɨlak sɨŋak apjaknek pen mɨñi yad ak rek nep kab mɨgan sɨkɨd amɨl nɨŋnek, walɨj okok kom sɨloklak rek mɨdek ak me, ak me Jisas warɨkɨp, agɨl, nɨŋ dɨnek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pen ñɨn nɨbak, God Mɨnɨm ñu kɨl tɨkɨl, Jisas kɨmɨl warɨknɨmɨŋ, aglak mɨnɨm ak, cɨr nɨŋ rep ma gɨrok. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nɨg nɨŋɨl adɨk gɨ karɨp amnɨrok. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Pen Maria cɨp tɨgel gɨlak tɨgel mɨgan nɨbak söŋ ar sɨŋak warɨkɨl mɨdɨl sɨl aglɨg gɨ mɨdek. Sɨl ag mɨdlɨg gɨ, kɨd magɨl ñɨk gɨl kab mɨgan oŋɨd sɨpsɨp nɨŋak, ejol walɨj tɨd lɨrek omal, Jisas cɨp se ned mɨdek kau nɨbak bɨsɨg mɨdlɨg gɨ, alap nabɨc dai oŋɨd, alap tob dai eim, mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ejol nɨb omal Maria nop agrek, “Tari gɨnɨg sɨl ageban?” agrek. Agerek agak, “Bɨ Kɨb yad ak nop damɨl akal dam lɨpal ak ma nɨpin!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nɨb agɨl, adɨk gɨl nɨŋak, Jisas warɨk mɨdek. Pen nop nɨŋek, bɨ aknɨb ke rek lak. Jisas nɨŋak ak pen ak Jisas nep, agɨl ma nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas pen Maria nop agak, “Bin aul. Tari gɨnɨg sɨl ageban? Bɨ an nop pɨyo nɨŋeban?” agak. Agek, Maria agak e, bɨ wög dai nap nɨb ak nep yɨp ageb, agɨl, agak, “Bɨ kɨb nɨŋeb. Cɨp ak dad ambin, agɨl, akal dam lɨpan ak yɨp agenɨmɨn, yad dad amnin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Agek, Jisas agak, “Maria!” agak. Agek, Maria, Arameik mɨnɨm lɨl, “Rabonai!” agak. (Mɨnɨm agak nɨbak, “Mɨnɨm Ag Ñeb Bɨ.”) ");
INSERT INTO kmh_m_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Agek, Jisas agak, “Yad karɨp lɨm wagɨn aul kɨrɨg gɨl, Bapi ker adɨk gɨ sɨŋ alaŋ ma ambin rek, yɨp ma dan. Pen nak amɨl, mam sɨkop kɨrop agnɨmɨn, ‘Jisas agɨp, “Yad Bapi yad, Nap nɨbi, God yad, God nɨbi mɨdeb sɨŋak adɨk gɨ amebin,” agɨp,’ agnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jisas nɨb agek, Maria Magdala amɨl Jisas bɨ ne okok kɨrop agak, “Yad Bɨ Kɨb ak nop nɨŋɨl apebin,” agak. Nɨb agɨl, Jisas mɨnɨm tari tari nop agak ak, Maria ne Jisas bɨ ne okok kɨrop mɨnɨm nɨbak agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pen Sade ñɨn ak, pɨb paŋɨd amnak nɨŋɨl, bɨ ne okok Juda bɨ kɨb okok kɨrop pɨrɨkɨl, karɨp mɨgan amɨl kɨjoŋ ak gɨñ wös gɨl, kapkap mɨdelak nɨŋɨl, Jisas apɨl nab nɨb sɨŋak mɨseŋ lɨl agak, “God nɨbep kod mɨdeŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nɨb agɨl, ñɨnmagɨl ur ne ak kɨrop yomɨl, tɨglem pɨs kɨd ne ak yom ñak. Yom ñek Bɨ ne okok nɨŋɨl, ak Bɨ Kɨb nep, agɨl, mɨñ mɨñ yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas pen kɨrop kauyaŋ agak, “God nɨbep kod mɨdeŋ. Bapi yɨp ag yokek apɨl wög ne gɨpin rek, nɨbep pen abe ag yokebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nɨb agɨl, kɨrop pɨglɨg gɨ agak, “Kaun Sɨŋ ak dɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bin bɨ ognap tap si tap tɨmel gɨpal okok nɨŋɨl kɨrɨg gɨnɨgabɨm ak, God ak rek nep nɨŋɨl kɨrɨg gɨnɨgab. Pen nɨŋɨl ma kɨrɨg gɨnɨgabɨm ak, God ak rek nep nɨŋɨl ma kɨrɨg gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pen Jisas ap mɨseŋ lɨl kɨrop mɨnɨm agak ñɨn nɨbak, bɨ ne Tomas, yɨb alap Ñɨ Tam apal bɨ nɨbak, kɨrop eip ma mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nɨb ak, kɨsen Jisas bɨ ne Tomas nop aglak, “Bɨ Kɨb ak nɨpɨn,” aglak. Agelak, ne pen agak, “Nɨb agebɨm ak pen ñɨnmagɨl nop cɨpɨl paklak ak abe, tɨglem pɨŋɨl lɨlak ak abe, udɨn yad ke nɨŋɨl ñɨnmagɨl yad dɨ nɨŋnɨgain ak me, mɨnɨm nɨbak nɨŋ dɨl, warɨkɨp, agɨl, nɨŋ dɨnɨgain; mer ak, mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nɨb agɨl, pen wik nokɨm alap mɨdɨl, Jisas bɨ ne okok Tomas eip kauyaŋ karɨp mɨgan ak mɨdelak. Kɨjoŋ gɨñ wös gɨlak ak pen Jisas ne apɨl nab nɨb sɨŋak mɨseŋ lɨl agak, “God nɨbep kod mɨdeŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jisas nɨb agɨl, Tomas nop agak, “Ñɨnmagɨl nak ak, yɨp cɨpɨl paklak aul dɨ nɨŋan. Ñɨnmagɨl yad nɨŋan. Tɨglem pɨs yad pɨŋɨl lɨlak aul abe dɨ nɨŋan. Gos par ma lɨl, yɨp nɨŋ dɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Agek, Tomas agak, “Bɨ Kɨb yad, God yad!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pen Jisas Tomas nop agak, “Yɨp mɨseŋ nɨŋɨl me, yɨp nɨŋ dɨpan. Pen bin bɨ yɨp mɨseŋ ma nɨŋɨl, yɨp nɨŋ dɨnɨgal okok, mɨñ mɨñ yɨb gɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pen mɨnɨm ñu kɨl tɨkebin nɨbaul, cɨn Jisas bɨ ne okok nɨŋ mɨdon nɨŋlɨg gɨ, Jisas tap ma gep ke ke koŋai nep golɨgɨp rek, magɨlsek ñu kɨl ma tɨkpin. ");
INSERT INTO kmh_m_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pen nɨbi, Jisas nep me Krais ak, God Ñɨ ne yɨb ak nep, agɨl, nop nɨŋ dem, nɨbep dek, nop eip komɨŋ mɨdenɨgabɨm, agɨl, mɨnɨm nɨbaul ñu kɨl tɨkpin. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pen kɨsen cɨn Jisas bɨ ne okok Ñɨg Cöb Taibirias sɨŋak mɨdonok nɨŋɨl Jisas ne mɨseŋ lek nɨŋnok. Tari gak ak agnɨg gebin. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita ak, Tomas ak (yɨb alap Ñɨ Tam apal bɨ nɨbak), Natanyel bɨ Kena taun karɨp lɨm Galili sɨŋak nɨb ak, Sebedi ñɨ Jems cɨr mamɨl mal, Jisas bɨ ne omal sek eip, jɨm ñɨl am Ñɨg Cöb Taibirias sɨŋak mɨdonok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita cɨnop agak, “Yad kɨbsal nen amebin,” agak. Agek, “Cɨn eip amnɨgabɨn,” agɨl, am nop eip ñɨg magöb dɨl, gɨ ajon ajon mɨñab tɨk da yokak pen kɨbsal ognap ma dɨnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pen pɨb lɨm gɨnɨg gek nɨŋlɨg gɨ, Jisas apɨl ñɨg cöb gol sɨŋak warɨk mɨdek. Nop nɨŋnok pen ak Jisas nep, agɨl, ma nɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne cɨnop agak, “Ñɨ ognɨl. Nɨbi kɨbsal nen gɨ tag mer nɨpɨm ar?” agak. Agek, cɨn yau agnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nɨb agonok, cɨnop agak, “Uben ak dɨ ñɨg magöb ñɨnmagɨl yɨpɨd kɨd pɨs ken yokɨl me, kɨbsal ognap dɨnɨgabɨm!” agak. Agek, uben ak dɨ ñɨg nab eyaŋ yokɨl, kɨbsal koŋai yɨb nep dɨl, lɨp gon onɨmɨŋ rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nɨg gek, yad Jon, Pita nop agnek, “Bɨ nɨbak Bɨ Kɨb ak nep,” agnek. Nɨb agenek, Pita nɨŋɨl, walɨj ne sɨŋak lak ak dɨ sɨb nag nab sɨŋak adaŋ paŋɨl, preŋɨd ñɨg nab eyaŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Cɨn bɨ ognap ñɨg magöb ar ak mɨdɨl, uben kɨbsal sek ap ran jakɨl mɨdek ak, lɨp gɨ dap, par okok mer, mita aknɨb ñɨnjuɨl mamɨd alaŋ (100) rek nep, ñɨg gol sɨŋak onok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gol nɨb sɨŋak apɨl nɨŋnok, mab yɨn bɨj yowak ar ak, kɨbsal ognap yɨn mɨdek. Bred ognap ak rek nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pen Jisas cɨnop agak, “Kɨbsal mɨñi dɨpɨm okok, ognap dowɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Agek, Saimon Pita ñɨg magöb ar ak amɨl, ne eip uben kɨbsal koŋai nep (153) mɨdek nɨbak kab kɨlɨp ar sɨŋak lɨp gɨ donok. Uben ak mɨker gak pen ma pɨg rɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas pen cɨnop agak, “Apɨl, tap ñɨŋɨm,” agak. Cɨn pen nabɨŋ gek, nak bɨ an amɨl mɨdeban, agɨl, nop ma ag nɨŋnok; ak Bɨ Kɨb ak nep, ag gos nɨŋɨl, kɨrɨg gɨnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas ne am bred ak dɨl, cɨnop nonɨm lɨl, kɨbsal abe dɨ cɨnop nonɨm lɨl gek, ñɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pen Jisas kɨmɨl warɨkɨl, cɨnop bɨ ne okok ñɨn omal eper mɨseŋ lek nop nɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pen cɨn tap ñɨb sakɨl, Jisas Saimon Pita nop ag nɨŋak, “Saimon Jon ñɨ ne. Bɨ sɨŋ aul rek mer; nak yɨp nɨŋɨd nep mɨdmagɨl lɨpan aka?” agak. Agek, Pita agak, “Bɨ Kɨb. Yad nep mɨdmagɨl lɨpin ak, nak nɨpan,” agak. Nɨb agek, Jisas agak, “Sipsip ñɨlɨk yad okok kod mɨdenɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas nɨb agɨl, kauyaŋ ag nɨŋak, “Saimon Jon ñɨ ne. Nak yɨp nɨŋɨd nep mɨdmagɨl lɨpan aka?” agak. Agek, Pita agak, “Bɨ Kɨb. Yad nep mɨdmagɨl lɨpin ak, nak nɨpan,” agak. Nɨb agek, Jisas agak, “Sipsip yad okok kod mɨdenɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas kauyaŋ pen ag nɨŋak, “Saimon Jon ñɨ ne. Nak yɨp mɨdmagɨl lɨpan aka?” agak. Pen Jisas nɨg gɨl, mɨnɨm ar nokɨm nɨbak nep, “Nak yɨp mɨdmagɨl lɨpan aka?” ag nɨŋɨl ag nɨŋɨl gek me, Pita gos par nɨŋlɨg gɨ agak, “Bɨ Kɨb. Nak tap okok magɨlsek nɨpan. Nɨb ak, yad nep mɨdmagɨl lɨpin ak, nak bɨr nɨpan,” agak. Agek, Jisas agak, “Nɨb ak, sipsip yad okok kod mɨdenɨmɨn. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yad nep nɨŋɨd yɨb agebin, nak bɨ praj rek mɨdenak ñɨn ak, walɨj gos nak ke nɨŋnak rek dɨ lɨl ajelɨgɨpan. Pen nak kɨsen bɨ mɨlep lɨnɨgan ñɨn ak, nak ñɨnmagɨl nak kɨlan gɨ mɨdek nɨŋlɨg gɨ, bɨ ke nɨb alap nep nag ñon gɨl, ma amnɨgan mɨgan ak poŋ dɨl dad amnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas mɨnɨm agak nɨbak, bin bɨ ognap kɨsen Pita ñag pak lɨnɨgal ak, Jisas ned nɨŋak me ak. Bin bɨ kɨsen nɨb okok, Pita nop tap tari gɨnɨgal kɨmnɨgab ak nɨŋɨl, God ne melɨk tep sɨŋ ke sek mɨdeb ak nɨŋnɨgal. Pen Jisas Pita nop agak, “Yɨp kɨsen gan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisas mɨnɨm nɨbak agak nɨŋɨl Pita adɨk gɨl nɨŋak, yad bɨ Jisas mɨdmagɨl lolɨgɨp ak mɨdenek. Yad bɨ nɨbak me, ned Jisas Pasopa tap ñɨb mɨdek wagɨn sɨŋak bɨsɨg mɨdɨl ag nɨŋnek, “Bɨ Kɨb. Bɨ an nep mɨmɨg gɨnɨgab?” agnek. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pen Pita yɨp nɨŋɨl Jisas nop agak, “Bɨ Kɨb. Bɨ aul nop tari gɨnɨgab?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Agek, Jisas agak, “Ak gos yad. Yad agen ne mɨdep nep mɨdek nɨŋlɨg gɨ, adɨk gɨ onɨgain ak, mɨnɨm nak mer. Pen nak yɨp kɨsen gan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jisas mɨnɨm agak nɨbak, bin bɨ nop nɨŋ dɨlak ognap aglak, “Jisas bɨ ne nɨbak ma kɨmnɨgab,” aglak. Pen Jisas bɨ ne nɨbak ma kɨmnɨgab, agɨl, mɨnɨm nɨbak ma agak; ne yokop agak, “Yad agen, ne mɨdep nep mɨdek nɨŋlɨg gɨ, adɨk gɨ onɨgain ak, mɨnɨm nak mer,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jisas bɨ ne nɨbak me, ne ke mɨnɨm nɨbaul ñu kɨl tɨkɨl, magɨlsek mɨnɨm nɨŋɨd yɨb nep mɨdeb ak nɨŋɨl, ñu kɨl tɨkɨp me ak. ");
INSERT INTO kmh_m_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas tap ar ke ke koŋai nep gak ak pen mɨnɨm nɨbak yokop ognap nep nab sɨŋaul ñu kɨl tɨkpin. Yad nɨpin, mɨnɨm nɨb okok magɨlsek ñu kɨl tɨk buk koŋai nep eyaŋ lɨplap, lɨm dai aul sɨkol gek, dam lep kau ak ma mɨdobkop. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mam Tiopilas. Yad nep mɨnɨm ned ñu kɨl tɨknek ak, Jisas nop tɨk dapek, pobɨŋ gɨl, wög wagɨn gɨl mɨd damɨl, tap tari tari gɨl, mɨnɨm tari tari ag ñɨl gak ak, nep mɨj ned ak ñu kɨl tɨknek. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Kɨsen, God Jisas nop dad ap ran jak seb kab alaŋ sɨŋak dad amnak. Pen ne seb kab ar alaŋ sɨŋak amnɨg gak won ak, ne gek Kaun Sɨŋ ne mɨnɨm ne dad ameb ag lak bɨ okok kɨrop ag ñɨ tep gak. Mɨnɨm nɨbak magɨlsek ned ñu kɨl tɨkɨl nep ñɨnek. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas kɨmak pen kauyaŋ warɨkɨl, ñɨn aknɨb ñɨnjuɨl omal (40) nab ak ñɨn koŋai nep mɨseŋ lɨl, mɨnɨm ne dad ameb bɨ ne okok eip mɨdɨl, God bin bɨ dɨl kod mɨdenɨgab mɨnɨm ak kɨrop ag ñolɨgɨp. Nɨg gek, kɨri udɨn magɨl kɨri ke nɨŋlak ne komɨŋ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pen kɨmɨl warɨkɨl, lɨm dai ar wagɨn aul mɨdolɨgɨp ñɨn nab nɨb sɨŋak, ñɨn alap bɨ ne nɨb okok eip tap magɨl ñɨblɨg gɨ agak, “Yad nɨbep ned agnek rek, Bapi yad tap tari nɨbep ñɨnɨgain agak ak, Jerusalem sɨŋaul nep mɨdɨl, kod mɨdenɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ñɨg pak ñeb bɨ ak bin bɨ kɨrop ñɨg ak nep pak ñolɨgɨp, pen ñɨn omal nep ap padɨkek, Kaun Sɨŋ ak apɨl nɨbep pak ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pen ñɨn alap Jisas ne bɨ ne nɨb okok mɨdelak nab sɨŋak mɨseŋ lek, nop aglak, “Bɨ Kɨb, nak mɨñi kiŋ cɨn mɨdek, cɨn Isrel bin bɨ karɨp lɨm cɨn aul kauyaŋ ke kod mɨdɨl, karɨp lɨm ognap sek kod mɨdɨl gɨnɨgabɨn aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Agelak, kɨrop agak, “Ñɨn akal gɨnɨgab ak, Bapi gos ne ke nɨŋɨl ag lak; tap nɨbi mer. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pen Kaun Sɨŋ ne nɨbep apek, nɨbi kɨlɨs dɨl amɨl, Jerusalem bin bɨ, Judia bin bɨ, Sameria bin bɨ, bin bɨ karɨp lɨm tɨgoŋ tɨgoŋ magɨlsek okok, yad tari tari gɨpin ak kɨrop ag ñɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nɨb agɨl, bɨ ne okok nɨŋ mɨdel nɨŋlɨg gɨ, God nop dad ap ran jak seb kab ar alaŋ sɨŋak dad amek nɨŋlɨg gɨ, kɨmi bad alap apɨl nop karɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pen ne amek, kɨri seb kab alaŋ nɨŋ mɨdel nɨŋlɨg gɨ, magɨl nɨbak nep bɨ walɨj tɨd yɨmrek omal apɨl kɨrop eip warɨk mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bɨ nɨb omal agrek, “Bɨ Galili nɨb sɨŋ aul, nɨbi tari gɨnɨg seb kab alaŋ nɨŋ mɨdebɨm? Nɨbi nɨŋlɨg gɨ mɨdem nɨŋlɨg gɨ, God ne gek, Jisas ap ran jak seb kab ar alaŋ sɨŋak dad amɨb ak, kɨsen ne ke aknɨb rek nep adɨk gɨ onɨgab,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olip Dɨm alaŋ mɨdelak ak kɨrɨg gɨl, Jerusalem adɨk gɨ amnɨlak. Kanɨb par mer, Olip Dɨm Jerusalem nɨb ulep; Juda God nop sobok gep ñɨn ak ajpal rek nep. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem amɨl, karɨp kɨneb kɨri amjakɨl, karɨp ñɨlɨk ar alaŋ mɨgan ak amnɨlak. Bɨ mɨdelak okok: Pita, Jon, Jems, Edru, Pilip, Tomas, Batolomyu, Matyu, Alpias ñɨ ne Jems ak, Saimon Selot ak, Jems ñɨ ne Judas ak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kɨri per per mogɨm gɨl, God nop sobok gölɨgɨpal. Jisas nonɨm Maria ak, Jisas nɨmam sɨkop okok, bin ognap sek per nɨg gölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pen ñɨn nab nɨb sɨŋak, bin bɨ ñɨnjuɨl aknɨb kagol oŋɨd (120) rek ap mogɨm gel nɨŋlɨg gɨ, Pita warɨkɨl kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ai mam sɨkop nɨŋɨm. Kaun Sɨŋ ne bɨrarɨk nep Depid nop gos ñek, Judas Jisas nop mɨmɨg nɨŋak bɨ ak gɨnɨgab rek nɨŋɨl ñu kɨl tɨkek, agak agak rek nep gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jisas bɨ Judas nɨbak dek, cɨn eip mɨdɨl, wög ne ak jɨm ñɨl golɨgɨpɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pen kɨsen ne Jisas nop mɨmɨg nɨŋɨl, kab magɨl dak ak damɨl, lɨm dai alap tauɨl, mɨd damɨl, ñɨn nokɨm alap ap yap pakɨl, kogi ne ak pawɨkɨl, cɨbur magɨlsek lɨm gɨ söŋ apek kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nɨg gɨl kɨmek, Jerusalem bin bɨ magɨlsek nɨŋɨl, lɨm dai tauɨl kɨmak nɨbak, yɨb Akeldama, aglak. Akeldama aglak mɨnɨm wagɨn ak, “Lakañ Yowak Lɨm Dai,” agɨl aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita agak, “Depid bɨrarɨk nep God Mɨnɨm dai Sam ñu kɨl tɨkɨl agak, ‘Karɨp ne cög nep mɨdonɨmɨŋ; bin bɨ ognap karɨp ne am ma mɨdenɨmel,’ agak. Depid mɨnɨm alap pen agak, ‘Wög ne ak bɨ alap dɨnɨmɨŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Agak nɨbak, bɨ cɨn ke alap nɨŋɨl dɨnɨgabɨn. Cɨn Bɨ Kɨb Jisas eip tagolɨgɨpɨn ak, bɨ cɨn eip per tagolɨgɨp bɨ alap nɨŋɨl dɨnɨgabɨn. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bɨ cɨn eip per tagɨl, Jon Jisas nop ñɨg pak ñak ak nɨŋɨl, mɨd damɨl, Jisas kɨmɨl warɨkɨl seb kab ar alaŋ amnak nɨŋak bɨ alap nɨŋɨl dɨnɨgabɨn. Bɨ nɨbak rek don me, Bɨ Kɨb Jisas kɨmɨl warɨkak mɨnɨm ak ag ñɨ tep gɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nɨb agek, bɨ nak Mataias eip Josep eip kɨrop mal ag lɨlak. Pen Josep ñɨn ognap yɨb ne alap Basabas, alap Jastas, agölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Bɨ nɨb omal kɨrop nɨg gɨl ag lɨl, God nop sobok gɨl aglak, “Bɨ Kɨb, Judas ned gɨ tɨmel gɨl kɨmɨl, karɨp ne mɨdonɨmɨŋ sɨŋak amnak ak, kau ne ak an dɨnɨmɨŋ, agɨl, bɨ omal aul ag lɨpɨn. Nɨb ak, nak bin bɨ magɨlsek gos nɨŋɨl gɨpal rek nɨpan ak me, nep ag nɨŋobɨn, nak ke bɨ ak agek, cɨn nɨŋɨl dɨnɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nɨb agɨl, bɨ nɨb omal yɨr bopɨs tɨg gɨlɨg gɨ del, Mataias yɨb ap ranek, Jisas mɨnɨm dad ameb aknɨb agɨp alaŋ eip jɨm ñɨl, kauyaŋ bɨ aknɨb umɨgan alaŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bin bɨ Jisas nop nɨŋ dɨlak okok, Pedikos ñɨn kɨb ak mɨñi, agɨl, apɨl karɨp ñɨlɨk mɨgan nokɨm alap mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nɨg gɨl mɨdel nɨŋlɨg gɨ, dai gu kɨb seb kab ar alaŋ nɨb agɨl, yɨgen rek dɨl, karɨp ñɨlɨk mɨgan bɨsɨg mɨdelak sɨŋak eyaŋ owak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pen magɨl nɨbak nep nɨŋlak, mab mɨlaŋ ñon rek ak apɨl, pɨlajɨkɨl ke ke pɨg gɨ rɨk amɨl, bin bɨ nabɨc cög ar alaŋ nokɨm nokɨm am mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Am mɨdek nɨŋlɨg gɨ, Kaun Sɨŋ apɨl, kaun kɨrop nab adaŋ ap ran jakak nɨŋɨl kɨri mɨnɨm yɨb ar ke ke aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pen ñɨn nɨbak, Juda bin bɨ okok, kɨri mɨgan ke ke, karɨp lɨm okok nɨb okok nɨb apɨl, Jerusalem mogɨm gɨ mɨdelak. Bin bɨ nɨb okok kɨri God Mɨnɨm ageb rek nɨŋɨl, ar nɨbak rek nep gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gu kɨb nɨbak agek nɨŋɨl, tari geb, agɨl, bin bɨ koŋai nep kasek karɨp nɨbak apɨl nɨŋlak, mɨnɨm yɨb ar ke ke yɨpɨd gɨl nep agelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kɨri nɨŋɨl, kɨb gaul gɨl aglak, “Bin bɨ sɨŋ aul magɨlsek Galili nɨb. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pen titi gɨl mɨnɨm yɨb cɨn ke ke apɨn rek yɨpɨd gɨl agebal nɨŋobɨn? ");
INSERT INTO kmh_m_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Cɨn ognap Padia nɨb, ognap Midia nɨb, ognap Ilam nɨb, ognap Mesopotemia nɨb, ognap Judia nɨb, ognap Kapadosia nɨb, ognap Podas nɨb, ognap Esia nɨb, ");
INSERT INTO kmh_m_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ognap Prijia nɨb, ognap Pampilia nɨb, ognap Ijip nɨb, ognap karɨp lɨm Libia, Sairini taun gol okok nɨb, ognap Rom nɨb opɨn. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bin bɨ Rom nɨb opal okok, ognap Juda bin bɨ yɨpɨd gɨl, ognap Juda bin bɨ mer pen mɨñi Juda bin bɨ gɨpal rek ar ak gɨpal. Ognap Krit nɨb, ognap Arebia nɨb opɨn. Pen cɨn nɨŋ mɨdon nɨŋlɨg gɨ, mɨnɨm yɨb cɨn ke ke agobɨn rek yɨpɨd gɨl agɨl, God ne tap aknɨb ke yɨb gɨp, agɨl, yɨb ne agel ar amek, nɨŋobɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nɨb agɨl, gos par nɨŋlɨg gɨ, pen ag nɨŋek, pen ag nɨŋek gɨl aglak, “Ke yɨb geb nɨbak tari gɨnɨg geb,” agɨl, gos par yɨb nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bin bɨ ognap pen kɨri ñɨñɨloŋ lɨl aglak, “Ak ñɨg wain koŋai nep ñɨbɨl, saköl ñagɨp agebal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pen Pita bɨ Jisas mɨnɨm dad ameb bɨ aknɨb agɨp alaŋ eip warɨkɨl, meg mɨgan dap ranɨl, bin bɨ koŋai nep mɨdelak okok kɨrop agak, “Nɨbi Juda bin bɨ cɨn abe, nɨbi bin bɨ Jerusalem sɨŋaul kɨn mɨdebɨm okok abe, sɨŋaul tari gosɨp ak yad nɨbep mɨnɨm agnɨg gebin aul nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nɨbi ognap agebɨm, ‘Bɨ sɨŋ aul ñɨg wain koŋai nep ñɨbɨl, saköl ñagɨp agebal,’ agebɨm ak, pen kɨri ñɨg wain ñɨbel saköl ma ñagɨp. Mɨñi pɨb kɨsen nep aposɨp won ak nep me. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pen mɨnɨm yɨb ke ke agebal nɨŋebɨm nɨbaul, bɨ God mɨnɨm agep Joel bɨrarɨk nep agɨl ñu kɨl tɨkak rek nep geb me ak. Ne mɨnɨm nɨbak ñu kɨl tɨkɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God ageb, “Ñɨn kɨsen ak, bin bɨ magɨlsek okok kɨrop Kaun yad soŋ gɨ yoknɨgain. Ñɨ pai nɨbi okok God mɨnɨm ne ak bin bɨ okok kɨrop ag ñɨnɨgal. Bɨ praj nɨbi okok dai nɨŋnɨgal. Bɨ pobɨŋ nɨbi okok wɨsɨn nɨŋnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ñɨn nɨbak, wög gɨ ñeb bin bɨ yad okok, bin okok abe bɨ okok abe, kɨrop Kaun yad soŋ gɨ yoken, mɨnɨm tep yad ak bin bɨ okok kɨrop ag ñɨnɨgal. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pen yad seb kab ar alaŋ tap ke ma gep rek ognap gɨl, lɨm dai ar wagɨn aul tap nɨŋep ma nɨŋep ke nɨb ognap gɨnɨgain. Lakañ gɨl, mab yɨnɨl, sɨkɨm adpɨl kɨb gɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pɨb melɨk ma gɨnɨgab; takɨn lakañ sek lɨnɨgab. Nɨg genɨgab, kɨsen ñɨn aknɨb ke nɨb mɨseŋ lɨnɨgab. Bɨ Kɨb melɨk tep aknɨb ke sek onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pen bin bɨ an an, Bɨ Kɨb yɨp dɨ komɨŋ yokaŋ, agɨl, ag nɨŋnɨgal okok, kɨrop dɨ komɨŋ yoknɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita ne Joel ñu kɨl tɨkak mɨnɨm nɨbak ag dai juɨl agak, “Nɨbi Isrel bin bɨ, mɨnɨm agnɨg gebin aul nɨŋ rep gɨnɨmɨb. Jisas bɨ Nasaret nɨb ak bɨ yokop mer; God ne ke nop ag yokek owak. Ñɨ yad ak ag yoken, tap ma gep rek koŋai nep gɨl, tap nɨŋep ma nɨŋep koŋai nep gɨl gɨnɨgab nab kɨrop sɨŋak nɨŋɨl, bɨ nɨbak God ne ke ag yokek owak ak nɨŋlaŋ, agɨl, nop ag yokek owak. Jisas ne tap ma gep rek nab nɨbi sɨŋak gak ak, nɨbi ke bɨr nɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God nɨbi gɨnɨgabɨm rek ned nɨŋɨl, Jisas nop dɨ ñɨnmagɨl ar nɨbep ak lek, nɨbi dam bin bɨ tap si tap tɨmel gɨpal okok kɨrop ñem, nop mab kros bak alaŋ ñag pak lel kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ne yur kɨb yɨb dɨl kɨmak ak pen pɨs nep cɨp tɨgel sɨŋak mɨdɨl, ki gɨ yap pak amnɨmɨŋ rek ma lak. God gek kauyaŋ warɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Depid pen bɨrarɨk nep Jisas nop mɨnɨm ñu kɨl tɨkɨl agak, ‘Yad nɨpin, Bɨ Kɨb yad eip per per mɨdeb. Ne ñɨnmagɨl yɨpɨd yad pɨs ken mɨdeb ak me, yad ma pɨrɨknɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nɨg gɨp ak, cɨbur mɨdmagɨl yad pɨs geb nɨŋɨl yad mɨñ mɨñ yɨb gɨl agebin. Mɨb goŋ yad kɨmnɨg geb pen gos sek mɨdɨl ma pɨrɨknɨgain. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ti gɨnɨg? Nak yɨp cɨp tɨgel mɨgan ma kɨrɨg gɨnɨgan. Nak Bɨ Sɨŋ nak kɨrɨg gek, mɨb goŋ ne ki gɨ yap pak ma amnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nak yɨp komɨŋ mɨdep kanɨb ak yomnak. Yad nak eip mɨdɨl, mɨñ mɨñ yɨb gɨnɨgain,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita Depid agak mɨnɨm nɨbak ag juɨl agak, “Ai mam sɨkop, yad nɨbep mɨnɨm yɨpɨd gɨl agen, nɨŋ tep gɨnɨgabɨm. Based acɨk Depid kɨmek tɨgel gɨlak kau mɨgan ak mɨdeb; kau mɨgan nɨbak mɨñi cɨn ak rek nep nɨpɨn. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pen Depid ne God mɨnɨm agep bɨ alap mɨdolɨgɨp ak me, ne nɨŋak, God bɨrarɨk nep mɨnɨm ag lɨl agak, ‘Nak ñɨ tɨknɨgan tɨk damɨl tɨk lɨnɨgal ñɨ alap ne kau nep dɨl, kiŋ mɨdenɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Depid tap kɨsen gɨnɨgab ak nɨŋɨl, Mesaia ak ne kɨmɨl warɨknɨgab, agɨl, agak, ‘Nop cɨp tɨgel mɨgan ma kɨrɨg gak. Mɨb goŋ ne ki gɨ yap pak ma amnak,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Mɨñi God gek, Jisas ne warɨkɨl komɨŋ mɨdeb. Ne komɨŋ mɨdeb ak cɨn magɨlsek udɨn magɨl cɨn ke nɨpɨn. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God Jisas nop dam ñɨnmagɨl yɨpɨd pɨs ar ne ak lak. Lɨl, ne Kaun Sɨŋ ñɨnɨgain, agɨl agak ak, Jisas nop ñek, ne pen cɨnop ñek, apɨl gu kɨb agek, cɨn mɨnɨm ke ke agosɨn sɨŋaul nɨbi ke nɨŋebɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pen Depid mɨnɨm agak nɨbak, ne ke ma agak. Depid ne lɨm dai ar wagɨn aul mɨdɨl, seb kab ar alaŋ ma amnak. Pen ne agak, ‘Bɨ Kɨb ne Bɨ Kɨb yad ak nop agak, “Ñɨnmagɨl yɨpɨd yad pɨs ar bɨsɨg mɨdenɨmɨn; ");
INSERT INTO kmh_m_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yad gen kaual maual nak okok, talak mɨgan nak okok mɨdenɨgal,” agak,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nɨb ak, nɨbi Isrel bin bɨ magɨlsek nɨŋ rep gɨnɨmɨb: Jisas bɨ mab bak alaŋ ñag pak lem kɨmak bɨ nɨbak nep, God gek Bɨ Kɨb yɨb mɨdeb. Ne nep Mesaia per kod mɨdolɨgɨpɨn me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita mɨnɨm nɨbak agek, bin bɨ nɨŋ mɨdelak okok nɨŋel ñaul amnak. Nɨg gek, kɨri Pita abe, Jisas mɨnɨm dad ameb bɨ okok abe, ag nɨŋɨl aglak, “Nɨb ak, mam sɨkop, cɨn mɨñi tari gɨn?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Agelak, Pita agak, “Nɨbi nokɨm nokɨm magɨlsek mɨdebɨm rek, tap si tap tɨmel gɨpɨm ar ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨl, Jisas Krais nop nɨŋ dɨl, ñɨg paknɨmɨb. Nɨg genɨgabɨm, God tap si tap tɨmel gɨpɨm ak nɨŋɨl kɨrɨg gɨl, Kaun Sɨŋ ne ak nɨbep ñɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God bɨrarɨk nep agak, ‘Yad Kaun yad nɨbep Isrel bin bɨ ñɨl, ñɨ pai nɨbi tɨk donɨgabɨm okok kɨrop ñɨl, bin bɨ par okok kɨrop abe ñɨl gɨnɨgain,’ agak. Nɨb ak, cɨn nɨpɨn, God bin bɨ an an olaŋ, agnɨgab okok, kɨrop magɨlsek Kaun Sɨŋ ak ñɨnɨgab,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita kɨrop yɨmɨg nɨŋɨl, mɨnɨm koŋai nep agɨl agak, “Bin bɨ mɨñi mɨdebal ognap abramek gɨ tɨmel gɨpal rek, nɨbi kɨrɨg gɨl, mɨd tep gɨnɨmɨb. Mer ak, yur kɨb dɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bin bɨ koŋai nep Pita mɨnɨm agak ak nɨŋɨl, Jisas Krais nop nɨŋ dɨl, ñɨg paklak. Ñɨn nɨbak nep, bin bɨ tri tausan (3000) rek Jisas Krais nop nɨŋ dɨl, Jisas bin bɨ ne eip jɨm ñɨl mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nɨb ak, kɨri per per apɨl, bɨ Jisas mɨnɨm dad ameb okok eip jɨm ñɨl mɨdɨl, God Mɨnɨm ag ñelak ak nɨŋ tep gɨn, agɨl, ag amɨl apɨl gɨlɨg gɨ, bred tɨ paŋɨl jɨm ñɨl ñɨblɨg gɨ, God nop sobok gɨlɨg gɨ mɨdelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God bɨ Jisas mɨnɨm dad ameb okok kɨrop kɨlɨs ñek, tap ma gep rek koŋai nep gɨl, tap nɨŋep ma nɨŋep koŋai nep gɨl gel, bin bɨ okok nɨŋɨl, kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bin bɨ Jisas nop nɨŋ dɨlak okok, jɨm ñɨl mɨdɨl, bin bɨ tap ma mɨdek okok, bin bɨ ognap kɨrop tap abramek bɨlok ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Lɨm dai, tap okok ak rek nep sɨkim gɨl, mani dɨl, bin bɨ tap ma mɨdek okok kɨrop nonɨm lɨ ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kɨri per per, ñɨn nokɨm nokɨm, God sobok gep karɨp ak am mogɨm gölɨgɨpal. Pen karɨp kɨri okok ak rek nep am mogɨm gɨl, bred tɨ paŋɨl, mɨdmagɨl ar nokɨm lɨlɨg gɨ, mɨñ mɨñ gɨlɨg gɨ, tap jɨm ñɨl ñɨbelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pen bin bɨ mɨdelak okok magɨlsek, Jisas nɨŋ dɨlak bin bɨ kɨrop nɨŋel, tep gak. Per per, ñɨn nokɨm nokɨm, Bɨ Kɨb ne bin bɨ ognap sek dɨ komɨŋ yokek, kɨri Jisas nop nɨŋ dɨl, apɨl Jisas bin bɨ ne ned nɨb okok eip nab sakɨl mɨdelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","3","Praj nonɨm tɨk dowak ñɨn ak nep tob tɨmel gak alap, nop ñɨn nokɨm nokɨm per per dapɨl, God sobok gep karɨp kɨjoŋ wagɨn, Kɨjoŋ Kɨl Tep, apal ak, gol sɨŋak lel bɨsɨg mɨdolɨgɨp. Mɨdlɨg gɨ, bin bɨ God sobok gep karɨp ñɨlɨk mɨgan ap amelɨgɨpal okok, kɨrop mani tap yɨp alap ñɨm, agɨl asɨb golɨgɨp. Pen mɨnek alap, Pita eip, Jon eip pɨb kim gak dɨgep won ak, God nop sobok gep won ak, God nop sobok gɨnɨg, ap padɨker nɨŋlɨg gɨ, bɨ tob tɨmel gak nɨbak kɨrop mal nɨŋɨl agak, “Yɨp mani ognap ñɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Agek, kɨri mal nop nɨŋ i sek lɨ mɨdɨl, Pita agak, “Cɨrop mal nɨŋan!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Agek, yɨp tap alap ñɨnɨg gebir, agɨl, kɨrop mal nɨŋ mɨdek nɨŋlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita agak, “Mani silpa, mani gol, yad ma mɨdeb ak pen tap yad nokɨm alap mɨdeb ak nep ñɨnɨgain. Jisas Krais Nasaret nɨb ak, yɨb ne agɨl nep agebin, ‘Warɨk amnoŋ!’” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita nɨb agɨl, ñɨnmagɨl yɨpɨd pɨs kɨd nop dɨl, dɨ warɨk ñek nɨŋlɨg gɨ, magɨl nɨbak nep tob abe, tob gol abe tep gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tep gek, kasek warɨk amlɨg gɨ, talak talak gɨlɨg gɨ, God nop tep aglɨg gɨ, kɨri mal eip God sobok gep karɨp ñɨlɨk mɨgan ak amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","God nop tep, agɨl, tob taulɨg gɨ ajek ak, bin bɨ mɨdelak okok nɨŋɨl, ");
INSERT INTO kmh_m_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bɨ tob tɨmel per apɨl, God sobok gep karɨp kɨjoŋ wagɨn, Kɨjoŋ Kɨl Tep, apal ak, gol sɨŋak bɨsɨg mɨdɨl, mani tap okok asɨb agolɨgɨp bɨ nɨbak, titi gɨl tob yɨb taulɨg gɨ apeb, agɨl, kɨri gos par nɨŋɨl kɨb gaul gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bɨ nɨbak ne, God sobok gep karɨp mɨs ken, Solomon Karɨp Badak, apal, mɨgan ak mɨdɨl, Pita eip, Jon eip kɨrop mal nab nab lɨl dɨ mɨdek nɨŋlɨg gɨ, bin bɨ magɨlsek kɨb gaul gɨlɨg gɨ, pɨg gɨ rɨkɨd ag apelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bin bɨ apelak, Pita ne nɨŋɨl agak, “Isrel bin bɨ sɨŋ aul, nɨbi tari gɨnɨg gos par nɨŋɨl cɨrop bɨ mal nɨŋ i sek lebɨm? ‘Cɨr mal bɨ kɨlɨs, bɨ tep mɨdɨl gesir, bɨ nɨbaul kanɨb tag tep geb,’ agɨl, gos ak nɨŋebɨm ar? Ak mer. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraham, Aisak, Jekop, based acɨk cɨn sɨkop okok sobok gölɨgɨpal, God nɨbak nep ne ke gek, bɨ wög gɨ ñeb ne Jisas warɨkek, bin bɨ okok nɨŋɨl, ne melɨk tep aknɨb ke sek mɨdeb, agɨl, nɨpal. Nɨbi pen Jisas nop ma dɨpek. Pailot, Jisas nop wɨsɨb yokin, agak ak pen nɨbi ke, nop dam mab bak alaŋ ñag pak lɨlaŋ, apek. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisas ne Bɨ Sɨŋ; ne Bɨ Komɨŋ Tep per nep God ageb rek nep geb. Pen nɨbi apek, Jisas ne bɨ nɨŋeb cɨn mer, bɨ cɨp ñagolɨgɨp bɨ ak cɨnop wɨsɨb yokan, apek. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nɨg gɨl, Bɨ komɨŋ mɨdep magɨl ñeb Bɨ ak nop ñag pak lɨpek. Pen God gek, ne warɨkak ak, cɨn udɨn magɨl cɨn ke nɨŋɨl agobɨr. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bɨ tob tɨmel per nɨpɨm aul, mɨñi komɨŋ losɨp nɨpɨm. Jisas kɨlɨs ne gek me, komɨŋ lɨp. Jisas nɨŋ dɨl, yɨb ne agor, ne gek pɨs nep komɨŋ lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Pen mɨdemam yad sɨŋaul. Nɨbi ke abe, bɨ kɨb nɨbi okok abe, sakɨl sek mɨdɨl, Jisas nop nɨg gɨpek. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pen God ne bɨ mɨnɨm ne agep okok kɨrop bɨrarɨk nep gos ñek aglak, ‘Kɨsen God Mesaia ne yur kɨb yɨb dɨl kɨmnɨgab,’ aglak ak me, aglak rek nep gɨpek. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nɨb ak, tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gɨl, God nop adɨk gɨ apem, ne tap si tap tɨmel gɨpɨm acɨr ak lɨg gɨ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nɨg gem, Bɨ Kɨb ne kaun nɨbep nab adaŋ kɨlɨs ne ñɨl, Krais ak nɨbep bɨrarɨk nep ag lak ak ag yoknɨgab. Krais ak Jisas. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","God ne bɨrarɨk nep agek, bɨ mɨnɨm agep sɨŋ ne okok aglak rek, Jisas ne karɨp lɨm seb kab ar alaŋ sɨŋak mɨdeb rek mɨdenɨgab nɨŋlɨg gɨ, God tap magɨlsek kauyaŋ gɨ lɨ rep gɨnɨgab ñɨn ak onɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosɨs agak, ‘Kɨsen Bɨ Kɨb God nɨbi, ne bɨ mɨnɨm agep yad rek, bɨ wagɨn nɨbi ke alap, ag yoknɨgab. Ne apɨl, mɨnɨm agnɨgab ak magɨlsek nɨŋ tep gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bin bɨ mɨnɨm ne ma dɨnɨgal okok, bin bɨ ne ma mɨdenɨgal; kɨri pɨs nep söŋ ar eyaŋ amɨl, kɨmnɨgal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Bɨ God mɨnɨm agep Samyuel abe, bɨ God mɨnɨm agep kɨsen olak okok abe, magɨlsek tap mɨñi mɨseŋ leb nɨŋobɨn ak, bɨr ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God bɨrarɨk nep nased acɨk nɨbi mɨnɨm ag lak ak, nɨbi ke tap ame debɨm me ak. God based Ebraham nop gɨnɨgain, agɨl, mɨnɨm ag lak. Mɨnɨm ag lɨl agak, ‘Ñɨ pai nak tɨkek, kɨri tɨk dam dapɨl gɨl tɨknɨgal okok, bɨ alap mɨdɨl me, ne gek bin bɨ okok magɨlsek mɨñ mɨñ gɨnɨgal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pen God Bɨ Wög Gɨ Ñeb ne Jisas karɨp lɨm wagɨn aul ag yokak ak, nɨbep nep nen agɨl, ned ag yokek owak. Isrel bin bɨ tap si tɨmel tɨmel yɨb gɨpal ak, tari gɨnɨg nɨg gɨpɨn, agɨl, ar nɨbak kɨrɨg gɨl, mɨd tep gɨlaŋ, agɨl, nɨbep Isrel bin bɨ sɨŋ aul ned ag yokek owak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita eip, Jon eip bin bɨ kɨrop mɨnɨm ag ñerek nɨŋlɨg gɨ, bɨ God nop tap sobok gep bɨ okok abe, God sobok gep karɨp polisman bɨ nabɨc kɨri ak abe, bɨ Sadyusi okok abe, amɨl mɨnɨm agelak nɨbak peyɨg nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jisas kɨmɨl warɨkak rek, bin bɨ Jisas nop nɨŋ dɨnɨgal okok ak rek nep kɨmɨl warɨknɨgal mɨnɨm ak, tari gɨnɨg nɨb ag ñebir, agel, mɨlɨk yowak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nɨb ak, kɨri Pita eip Jon eip dɨ cɨcɨ lɨl, mɨñi dɨgep magɨl aul mer, tol mɨnɨm kɨb agnɨgabɨn, agɨl, kɨrop mal dam mɨñ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pen Pita Jon bɨ omal mɨnɨm tep nɨbak ag ñerek, bin bɨ nɨŋɨl, koŋai yɨb nɨŋ dɨlak. Nɨb ak, bin bɨ Jisas nɨŋ dɨlak okok aknɨb paip tausan (5000) rek amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pen mɨnek, Juda bɨ kɨb karɨp lɨm nɨbak kod mɨdelɨgɨpal okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, bɨ lo mɨnɨm ag ñeb bɨ okok abe, Jerusalem sɨŋak ap mogɨm gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","God nop tap sobok gep bɨ kɨb yɨb Anas eip, Kaiapas eip, yakam kɨri bɨ Jon ak, Aleksada ak, bɨ yakam kɨri ognap sek apɨl, nab nɨb sɨŋak mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kɨri mogɨm gɨl agel, Pita Jon kɨrop mal poŋ dɨl dap nab sɨŋak lel, kɨrop mal ag nɨŋɨl aglak, “Bɨ tob tɨmel gak ak titi gɨ gesir komɨŋ lɨp? Kɨlɨs akal nɨb dɨl, yɨb tari agɨl, nɨg gɨpir?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Agelak, Kaun Sɨŋ ne am Pita nab adaŋ ap ran jakek nɨŋlɨg gɨ, Pita agak, “Nɨbi Juda bɨ kɨb abe, bɨ mɨnɨm tɨg bɨlokep abe, mɨnɨm agebin aul nɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bɨ yɨm gep tob tɨmel gak ak cɨr gor komɨŋ lak ak nɨŋɨl, ‘Nɨri titi gɨ gesir komɨŋ lɨp?’ agɨl, cɨrop mɨnɨm kɨb agebɨm ar? ");
INSERT INTO kmh_m_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nɨb ak, nɨbi mɨnɨm agnɨg gebin aul nɨŋ tep gɨnɨmɨb. Isrel bin bɨ okok magɨlsek ak rek nep nɨŋ tep gɨnɨmel. Jisas Krais bɨ Nasaret nɨb, cɨr yɨb ne ak nep nɨŋ dɨl, yɨb ne agor, ne gek, bɨ nɨbaul nop pɨs nep komɨŋ lek, tag tep geb nɨŋebɨm. Nɨbi Jisas Krais nop mab bak alaŋ ñag pak lɨpek ak pen God gek kauyaŋ warɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bɨ Jisas nɨbak nop gos nɨŋlɨg gɨ me, God Mɨnɨm ñu kɨl tɨkɨl aglak, ‘Nɨbi bɨ karɨp gep okok, kab par alap, ak kab tɨmel, agɨl, kɨrɨg gɨpek ak, mɨñi karɨp sap nab eyaŋ pɨŋɨl ñɨl mɨdeb,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God ne Jisas yɨb ne nep cɨnop agak nɨŋɨl Jisas ne nep cɨnop dɨ komɨŋ yoknɨmɨŋ rek lɨp. Lɨm dai ar wagɨn aul bɨ ke nɨb alap cɨnop dɨ komɨŋ yoknɨmɨŋ rek ma lɨp, mer yɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Jon kɨri bɨ omal warɨkɨl, ma pɨrɨkɨl, abramek yɨpɨd gɨl nep agrek ak, bɨ kɨb nɨb okok nɨŋɨl, wal yɨb agɨl aglak, “Bɨ omal aul kɨri skul ma agrek ak pen kɨri Jisas eip mɨdɨl nɨg gɨl gebir,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bɨ tob tɨmel gak komɨŋ lak ak nab kɨri sɨŋak mɨdek nɨŋlɨg gɨ, kɨrop mal mɨnɨm ag gɨnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nɨb ak me, kɨri aglak, “Kansol karɨp aul söŋ eyaŋ am mɨdenɨmir,” aglak. Söŋ eyaŋ am mɨder nɨŋlɨg gɨ, kɨri ke ag nɨŋ ag nɨŋ gɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Bɨ omal aul cɨn tari gɨn? Kɨri tap ma gep rek ak ger, Jerusalem bin bɨ magɨlsek bɨr nɨpal. Nɨb ak, kɨri mal tap ma gep rek alap ma gɨpir agjɨn rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pen kɨri amɨl, mɨnɨm nɨbak bin bɨ tɨgoŋ ognap ager, kɨri ak rek nep nɨŋnɨmel rek lɨp. Nɨg gɨp ak, cɨn kɨrop mal mɨnɨm kɨlɨs agɨl agɨn, ‘Jisas yɨb ne ak kɨsen bin bɨ ognap ma agnɨmir, mer yɨb,’ agɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nɨb agɨl, kɨrop mal agel aperek aglak, “Jisas yɨb ak kɨsen ma agnɨmir; bin bɨ ognap Jisas mɨnɨm ak ma ag ñɨnɨmir, mer yɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nɨb agelak, Pita Jon kɨri pen pe agrek, “Cɨr God mɨnɨm nop ak kɨrɨg gɨl, mɨnɨm nɨbep ak dor, God nop tep gɨnɨgab aka mer? Nɨbi ke nɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pen Jisas tari tari gak, mɨnɨm tari tari agak ak, cɨr bin bɨ okok kɨrop ag ñɨ kɨrɨg gɨjɨr rek ma lɨp,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Nɨb agerek, Kansol bɨ kɨb okok gos kɨri ke nɨŋɨl, ‘Bɨ aul mɨ ñɨnjuɨl omal (40) mɨdɨl, mɨñi komɨŋ lɨp aul, bin bɨ okok nɨŋɨl magɨlsek God nop tep agebal. Cɨn bɨ nɨb omal aul kɨrop tap alap genɨgabɨn ak, bin bɨ sɨŋ aul kal onɨgal,’ agɨl, kɨrop mal yokop mɨnɨm kɨlɨs agɨl, ag söŋ yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita Jon kɨrop mal nɨg gɨl ag söŋ yokel, kɨri am Jisas bin bɨ ne okok kɨrop nɨŋɨl, bɨ God nop tap sobok gep bɨ kɨb okok abe, bɨ mɨnɨm tɨg bɨlokep okok abe, mɨnɨm tari tari aglak ak kɨrop ag ñɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ag ñerek, kɨri nɨŋɨl magɨlsek God nop sobok gɨl aglak, “Nak Bɨ Kɨb nokɨm nep mɨdeban. Nak seb kab ar alaŋ gɨ lɨl, lɨm dai wagɨn aul gɨ lɨl, ñɨg solwara gɨ lɨl, tap tari tari mɨdeb okok magɨlsek gɨ lɨl, gɨ lɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bɨrarɨk nep nak gek, Kaun Sɨŋ ne based cɨn Depid nop gos ñek, mɨnɨm nep ak agɨl agak, ‘Juda bin bɨ mer okok kɨri tari gɨnɨg kal jupal? Bin bɨ okok tari gɨnɨg gos nɨŋ tep gɨl mer, mɨnɨm ar nokɨm ag lɨl mɨmɨg mɨnɨm apal? ");
INSERT INTO kmh_m_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kiŋ karɨp lɨm ke ke kod mɨdebal okok abe, gapman bɨ kɨb karɨp lɨm ke ke kod mɨdebal okok abe, mɨnɨm ag ar nokɨm lɨl apal, “God Bɨ Kɨb eip, Mesaia ne eip, kɨrop eip pen pen gɨn,” apal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kiŋ Herod abe, gapman bɨ kɨb Podias Pailot abe, Juda bin bɨ mer okok ognap abe, Isrel bin bɨ sɨŋ aul nɨb ognap abe, Jerusalem aul apɨl, Bɨ Wög Gɨ Ñeb sɨŋ nak ak Jisas, Mesaia ag lɨnak ak nep, mɨnɨm ag ar nokɨm lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pen nak Bɨ kɨlɨs, ned gos nak ke nɨŋɨl agnak, Krais nop nɨg nɨg gɨnɨgal agnak ak me, kɨri nɨg gɨnɨmel rek lak; yokop ak kɨlɨs kɨri ma mɨdobkop. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bɨ Kɨb, mɨñi cɨnop mɨnɨm kɨlɨs tɨmel yɨb agebal ak nak gos nɨŋnɨmɨn. Cɨnop bin bɨ wög gɨ ñeb nak kod mɨdɨl, kɨlɨs nak cɨnop ñek, cɨn ma pɨrɨkɨl, kɨlɨs yɨb gɨl mɨnɨm nak bin bɨ okok kɨrop mɨseŋ ag ñɨn. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bin bɨ tap gɨp okok, nak gek, cɨn Bɨ Wög Gɨ Ñeb sɨŋ nak Jisas yɨb ne agon, kɨrop komɨŋ lɨnɨmɨŋ. Nak gek, cɨn Jisas yɨb ne agon, tap ma gep rek ognap, tap nɨŋep ma nɨŋep rek ognap gɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pen kɨri God nop nɨg gɨ sobok gɨlɨg gɨ mɨdel nɨŋlɨg gɨ, karɨp mɨdelak ak monmon rek dɨl, Kaun Sɨŋ ne apɨl nab kɨrop adaŋ ap ran jakek, ma pɨrɨkɨl, God Mɨnɨm ak kɨlɨs yɨb gɨl ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pen bin bɨ Jisas nop nɨŋ dɨlak nɨb okok, mɨnɨm ar nokɨm agɨl, gos ar nokɨm nɨŋɨl, tap kɨri tap tari mɨdek okok, tap kɨri jɨm ñɨl nep mɨdek, tap cɨn ausek, agɨl ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Bɨ Jisas mɨnɨm dad ameb okok, bin bɨ okok kɨrop mɨnɨm kɨlɨs gɨ agɨl agelɨgɨpal, “Jisas nop ñag pak lel, kɨmɨl warɨkak, nop udɨn cɨn ke nɨŋnok,” agölɨgɨpal nɨŋɨl God kɨrop magɨlsek yɨmɨg yɨb nɨŋɨl dɨ tep yɨb golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kɨrop bɨ ognap tap ulep gɨ ma mɨdek; magɨlsek tap mɨdek. Bin bɨ lɨm dai aka karɨp ognap mɨdek okok, sɨkim gɨ mani dɨl, ");
INSERT INTO kmh_m_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bɨ Jisas mɨnɨm dad ameb okok kɨrop ñölɨgɨpal. Kɨri pen dɨl, bin bɨ tap ma mɨdek okok kɨrop nonɨm lɨ ñölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pen bɨ Lipai wagɨn tɨk damɨl tɨklak bɨ alap yɨb ne Josep. Karɨp lɨm ne Saipras nɨb. Bɨ nɨbak ne bin bɨ ognap kɨrop mɨnɨm sain agɨl ag ñɨ rep gek, kɨri nɨŋɨl gos sek mɨdelɨgɨpal rek, bɨ Jisas mɨnɨm dad ameb okok nop Banabas aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josep lɨm dai ne alap agek, bin bɨ ognap taulak nɨŋɨl mani nɨbak dad apɨl bɨ Jisas mɨnɨm dad ameb okok kɨrop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pen bɨ ber alap mɨderek. Nɨgmɨl yɨb ne ak Ananaias, bin ne yɨb ne ak Sapaira. Ber mal kɨri lɨm dai kɨri alap ager taulak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tauel, Ananaias ne mani nɨbak pɨs kɨd kɨri ke nonɨm lɨl, pɨs kɨd dam Jisas mɨnɨm dad ameb bɨ okok kɨrop ñak. Bine abe nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pen Ananaias mani nɨbak nɨg gɨl dap ñek, Pita agak, “Ananaias, Seten nep gos ñek, nak tom agɨl agesan, ‘Lɨm taupal mani magɨlsek dapebin aul,’ agesan. Mɨnɨm esek agesan nɨbak, Kaun Sɨŋ nop ak rek nep esek agesan. Mani lɨm dai taupal nɨbak pɨs kɨd we gɨl opan. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lɨm dai nɨbak, lɨm dai nak. Sɨkim gɨnɨg, sɨkim gɨpnap; kɨrɨg gɨnɨg, kɨrɨg gɨpnap. Pen lɨm sɨkim gek, mani taulak nɨbak, magɨlsek donɨg, magɨlsek dopnap; ognap nep donɨg, ognap nep dopnap; magɨlsek karɨp nak sɨŋak kɨrɨg onɨg, kɨrɨg opnap. Mɨnɨm ma mɨdobkop. Pen nak mɨnɨm wai ñesan ak, cɨnop bɨ nep mɨnɨm wai ma ñesan; God nop ak rek nep mɨnɨm wai ñesan. Nak ti gɨnɨg nɨg gesan?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pita nɨb agek, Ananaias nɨŋɨl, won nɨbak nep ap yap lɨm eyaŋ pakɨl pɨs nep kɨmak. Nɨg gek nɨŋlɨg gɨ, bin bɨ okok gak nɨbak nɨŋɨl, jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pen bɨ praj okok apɨl, cɨp se par ak walɨj kom kam gɨl, dam tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Pen bine, nɨgmɨl ne kɨmek dam tɨgel gɨlak ak ma nɨŋak. Ne yokop ulep won alap mɨdɨl apjakek, Pita nop agak, “Lɨm dai nɨri ber ak sɨkim gɨrek, mani nɨg aknɨb rek nep taulak aka?” agak. Agek, bine agak, “Taulak ak dowɨp me ak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Agek, Pita nop agak, “Nɨri ber tari gɨnɨg mɨnɨm ag ar nokɨm lɨl nɨg gɨpir? Bɨ Kɨb Kaun ne mɨnɨm esek nɨbak ma nɨŋnɨgab, agɨl, nɨg gɨpir? Nɨŋan! Nagɨmɨl kɨmosɨp, dam tɨgel gɨpal bɨ okok mɨdebal kɨjoŋ wagɨn sɨŋaul. Nep ak rek nep dad amnɨg gebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nɨb agek nɨŋlɨg gɨ, magɨl nɨbak nep, Pita tob wagɨn sɨŋak ap yap lɨm eyaŋ pakɨl kɨmak. Bɨ praj ñon nɨgmɨl nop dam tɨgel gɨlak nɨbak apɨl, bine ak rek nep bɨr pɨs nep kɨmak ak nɨŋɨl, nop dam nɨgmɨl nop tɨgel gɨlak pɨs kɨd tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Krais nop nɨŋ dɨlak bin bɨ okok abe, bin bɨ ognap okok abe, tap gak nɨbak nɨŋɨl, magɨlsek jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bɨ Jisas mɨnɨm dad ameb aknɨb umɨgan alaŋ tap ma gep rek koŋai nep bin bɨ mɨdelak nab sɨŋak gɨ mɨdelak. Pen bin bɨ God Mɨnɨm nɨŋ dɨl Krais nop nɨŋ dɨlak okok, magɨlsek ap mogɨm gölɨgɨpal God sobok gep karɨp söŋ ar “Solomon Karɨp Badak” apal ak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bin bɨ ognap okok, Krais nop nɨŋ dɨlak bin bɨ okok kɨrop nɨŋel, tep gak ak pen, Krais bin bɨ ne mɨdebal okok, cɨn titi gɨl am kɨrop eip mogɨm gɨn, ag gos nɨŋɨl, pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pen per per bin bɨ kɨsen nɨb koŋai yɨb nep, Bɨ Kɨb nop nɨŋ dɨl, bin bɨ ned nɨb okok eip ap jɨm ñɨl mogɨm gölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jerusalem bin bɨ, bɨ Jisas mɨnɨm dad ameb okok gɨlak rek nɨŋɨl, bin bɨ mɨñak gak okok dap kanɨb kɨb gol sɨŋak lɨl, mɨj par mɨgan mɨgan lɨl aglak, “Pita padɨkek, pɨb mɨmɫaŋ ne ak kɨrop pak ñek, kɨrop komɨŋ lɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bin bɨ maŋ karɨp lɨm Jerusalem ulep sɨŋak mɨdelak okok, ak rek nep bin bɨ tap gak okok dɨl, bin bɨ kɨjeki kɨyob ñɨlɨk sek mɨdelak okok dɨl, dolak. Dapelak, kɨrop gel, magɨlsek komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nɨg gelak, bɨ God nop tap sobok gep bɨ kɨb yɨb ak abe, bɨ nɨŋeb ne bɨ Sadyusi okok abe, bɨ Jisas mɨnɨm dad ameb okok kɨri tap ma gep rek nɨg gel yɨb cɨnop ap yonɨgab, agɨl, bɨ okok kɨrop nɨŋel mɨlɨk yowak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kɨrop mɨlɨk yapek, bɨ Jisas mɨnɨm dad ameb okok kɨrop tɨg cɨcɨ lɨl, dam gapman kai kɨrop ñel, mɨñ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mɨñ lɨlak ak, pen ñɨn nɨbak nep kɨslɨm eyaŋ, Bɨ Kɨb agek, ejol alap apɨl, kɨjoŋ ak yɨkɨl, kɨrop poŋ dad söŋ amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Söŋ amel, ejol agak, “Nɨbi God sobok gep karɨp ak amɨl, bin bɨ okok kɨrop, God gek per per komɨŋ mɨdenɨgal mɨnɨm tep ak magɨlsek ag ñɨ tep gɨnɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Agek, mɨñab tɨkak nɨŋlɨg gɨ, God sobok gep karɨp ak amɨl, ejol ak agak rek, bin bɨ okok kɨrop wagɨn gɨl mɨnɨm ag ñɨlak. Nɨg gɨl ag ñel nɨŋlɨg gɨ, God nop tap sobok gep bɨ kɨb yɨb ak abe, bɨ nɨŋeb ne okok abe apjakɨl, bɨ mɨnɨm dɨ bɨlokep okok kɨrop magɨlsek sɨk agel, ap Kansol kɨb ak mogɨm gel, bɨ God sobok gep karɨp kod mɨdep bɨ okok ag yokɨl aglak, “Bɨ Jisas mɨnɨm dad ameb okok mɨñ lɨpɨn ak mɨñi am ulɨk gɨ dowɨm,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Agelak, bɨ God sobok gep karɨp kod mɨdelak bɨ okok mɨñ lep karɨp ak amɨl nɨŋlak, bɨ Jisas mɨnɨm dad ameb okok ma mɨdelak. Kɨri adɨk gɨ apɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Cɨn am nɨpɨn, kɨjoŋ ak gɨñlak rek mɨdosɨp, bɨ kod mɨdep bɨ okok ak rek nep kɨjoŋ wagɨn ak nɨŋ mɨdesal ak pen cɨn kɨjoŋ yɨkɨl, karɨp ñɨlɨk mɨgan eyaŋ amɨl nɨpɨn, bɨ alap ma mɨdosɨp yɨb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nɨb agelak, bɨ God sobok gep karɨp kod mɨdelak bɨ kɨb kɨri ak abe, God nop tap sobok gep bɨ kɨb okok abe, mɨnɨm nɨbak nɨŋɨl, nɨg gɨp tari gɨnɨgab, agɨl, gos par yɨb nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nɨg gɨl gos par nɨŋ mɨdel nɨŋlɨg gɨ, bɨ alap apɨl kɨrop agak, “Bɨ mɨñ lɨpek okok, kɨri am God sobok gep karɨp ak mɨdlɨg gɨ, bin bɨ okok kɨrop mɨnɨm ag ñebal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nɨb agek, bɨ God sobok gep karɨp kod mɨdelak bɨ kɨb kɨri ak, bɨ ne ognap kɨrop ulɨk gɨl, bɨ Jisas mɨnɨm dad ameb nɨb okok kɨrop dɨnɨg amnɨlak. Amɨl, Jerusalem bin bɨ sɨŋ aul cɨnop kab ju paknɨgal, agɨl, kɨrop ma ag gɨlak; kapkap ulɨk gɨ dolak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jisas mɨnɨm dad ameb bɨ okok kɨrop kapkap ulɨk gɨ Kansol ap mogɨm gɨ mɨdelak nab sɨŋak dapel, God nop tap sobok gep bɨ kɨb yɨb ak kɨrop agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Cɨn nɨbep, Jisas mɨnɨm ak ma agnɨmɨb, agɨl, mɨnɨm kɨlɨs gɨ agɨl apɨn ak pen ag mer nɨŋɨl kɨrɨg gɨpɨn. Nɨbi pen amɨl Jerusalem bin bɨ kɨrop magɨlsek Jisas mɨnɨm ak ag ñɨlɨg gɨ, cɨnop ag juɨl agebɨm, ‘Kɨri nep Jisas nop ñag pak lɨlak,’ agebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nɨb agek, Pita bɨ Jisas mɨnɨm dad ameb ognap eip aglak, “Cɨn bin bɨ mɨnɨm apal ak ma dɨnɨgabɨn; God mɨnɨm ne ak nep dɨnɨgabɨn! ");
INSERT INTO kmh_m_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jisas nop mab bak alaŋ ñag pak lem kɨmak ak pen, apɨs based sɨkop sobok gölɨgɨpal God ak nep gek, ne kauyaŋ warɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Warɨkɨl, God ne gek, am karɨp lɨm seb kab ar alaŋ sɨŋak amɨl, God ñɨnmagɨl yɨpɨd pɨs ken mɨdeb. Nɨb ak cɨn nɨpɨn, ne nep Kiŋ mɨdɨl, cɨnop dɨ komɨŋ yoknɨgab. Ne cɨnop Isrel bin bɨ yɨmɨg nɨŋɨl, tap si tap tɨmel gɨpɨn ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gon, ne nɨŋɨl tap tɨmel gɨpɨn okok kɨrɨg gɨl, cɨnop dɨ komɨŋ yoknɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","God gɨp nɨbak, cɨn udɨn magɨl tɨmɨd mɨgan cɨn ke nɨŋɨl, bin bɨ okok kɨrop ag ñobɨn. Bin bɨ mɨnɨm ne nɨŋ dɨl ageb rek nep gɨnɨgal okok, God ne Kaun Sɨŋ ak kɨrop ñek, ne kɨrop ak rek nep mɨnɨm tep nɨbak ag ñɨ tep gek nɨŋnɨgal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bɨ Jisas mɨnɨm dad ameb okok nɨb agelak, bɨ mɨnɨm dɨ bɨlokep ap mogɨm gɨ mɨdelak nɨb okok kal juɨl aglak, “Kɨrop pɨs nep ñag pak lɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nɨb aglak ak pen, nab nɨb sɨŋak bɨ alap mɨdek, yɨb ne ak Gameliel. Ne bɨ Perisi, lo mɨnɨm ag ñeb bɨ kɨri alap. Juda bin bɨ magɨlsek nop nɨŋel tep golɨgɨp. Bɨ Gameliel nɨbak warɨkɨl agak, “Bɨ ñon nɨbaul kɨrop agem söŋ amnɨlaŋ. Yad nɨbep mɨnɨm alap ag ñɨn,” agak. Nɨb agek, bɨ nɨb okok ag söŋ yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bɨ nɨb okok ag söŋ yokel nɨŋlɨg gɨ, Gameliel ne bɨ Kansol okok kɨrop agak, “Isrel bɨ sɨŋ aul, nɨbi bɨ sɨŋ aul kɨrop tari gɨnɨg gebɨm ak, gos nɨŋ tep gɨl gɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nɨbi nɨpɨm, ned bɨ Tudas, yad bɨ kɨb, agɨl agek, mɨnɨm ne agolɨgɨp ak bin bɨ koŋai nep, po hadred rek, nɨŋ dölɨgɨpal. Pen kɨsen bɨ ognap nop ñag pak lel, bin bɨ mɨnɨm nop nɨŋ dölɨgɨpal okok ke ke amel kɨr gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pen kɨsen, yɨb cɨnop dɨlak ñɨn ak, ak rek nep bɨ Judas Galili nɨb ak agak, ‘Cɨn gapman okok eip pen pen gɨl, kɨrop yɨk gɨ yoknɨgabɨn,’ agak. Nɨb agek, bin bɨ koŋai nep mɨnɨm nop dɨl, warɨk gapman eip pen pen gɨlak. Pen mɨd damɨl, bɨ nɨbak nop ak rek nep ñag pak lel, bin bɨ mɨnɨm nop nɨŋ dölɨgɨpal okok ke ke amel kɨr gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nɨb ak me, yad nɨbep agebin, bɨ mɨnɨm kɨb agobɨn sɨŋ aul kɨrop gɨ tɨmel ma gɨnɨmɨb. Kɨrop yokop ag yokem amnɨmel. Mɨnɨm kɨri ke nep agenɨgal ak, kɨb gɨnɨmɨŋ ag mer nɨŋɨl ap yonɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pen God ne ke agek genɨgal ak, nɨbi ke nep tap alap gɨnɨmɨb rek ma lɨnɨgab. Kɨrop gɨ tɨmel gɨn, agenɨgabɨm ak, kɨrop eip pen pen ma gɨnɨgabɨm; God eip pen pen gɨnɨgabɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gameliel nɨb agek, bɨ okok agak rek nɨŋɨl, bɨ Jisas mɨnɨm dad ameb okok kɨrop agel apelak, kɨrop nag dɨ tapɨn magɨl pa gɨs pakɨl, “Jisas mɨnɨm ak kɨsen ma agnɨmɨb, mer yɨb,” agɨl, kɨrop ag yokel amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pen bɨ Jisas mɨnɨm dad ameb okok, cɨnop tari gɨnɨg nɨg gɨpal, agɨl, ma nɨŋlak. God cɨnop Jisas bɨ ne yɨpɨd gɨl, agɨl gek, cɨnop nɨg gɨpal, agɨl, tep gek nɨŋlɨg gɨ, Kansol kɨb nɨbak kɨrɨg gɨl amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amɨl, per per God sobok gep karɨp söŋ ar sɨŋak amɨl, bin bɨ karɨp karɨp okok amɨl, Jisas ne Krais ak mɨnɨm tep ak ag ñölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pen mɨd damɨl, bin bɨ Jisas nop nɨŋ dɨlak okok koŋai yɨb mɨdelak. Pen Juda bin bɨ Grik mɨnɨm nep nɨŋlak okok, Juda bin bɨ kɨri Juda mɨnɨm yɨpɨd gɨl nɨŋlak okok kɨrop ag gɨl aglak, “Bin kaŋɨl kɨri okok kɨrop mani tap magɨl tap okok nonɨm lɨ ñɨ tep gɨpal pen bin kaŋɨl cɨn okok kɨrop nonɨm lɨ tep ma gɨpal,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nɨb agelak, bɨ Jisas mɨnɨm dad ameb aknɨb umɨgan alaŋ okok nɨŋɨl, bin bɨ Jisas nɨŋ dɨlak okok magɨlsek sɨk agel apelak aglak, “Ai mam sɨkop. Cɨn God Mɨnɨm ag ñobɨn ak kɨrɨg gɨl, bin bɨ okok kɨrop tap nonɨm lɨ ñɨnɨgabɨn ak, yɨpɨd gɨl ma gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nɨb ak, nɨbi bɨ aknɨb ar oŋɨd nɨŋɨl ag lem, kɨrop wög nɨbak ag lon, wög nɨbak gɨnɨgal. Pen God Kaun kɨrop ap ran jakɨl gos tep ñɨb bɨ okok nep nɨŋɨl ag lɨnɨmɨb. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Cɨn pen God nop sobok gɨlɨg gɨ, bin bɨ okok kɨrop God Mɨnɨm ak ag ñɨlɨg gɨ, gɨ mɨdonɨgabɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mɨnɨm agelak nɨbak nɨŋel, kɨrop magɨlsek tep gek, bɨ aknɨb ar oŋɨd ag lɨlak. Bɨ nɨb okok alap me Stipen ak. Stipen ne God nop nɨŋ dɨ kɨlɨs yɨb golɨgɨp. Kaun Sɨŋ nop ap ran jakɨl mɨdolɨgɨp. Alap Pilip ak, alap Prokoras ak, alap Naikena ak, alap Timon ak, alap Pamenas ak, alap Nikolas ak. Nikolas ne taun kɨb Adiok nɨb. Ne ned bɨ Juda mer ak pen kɨsen Juda bin bɨ gos nɨŋlak rek nɨŋ dak. Pen kɨsen ne Jisas nop nɨŋ dak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɨ aknɨb ar oŋɨd nɨb okok ag lɨl, kɨrop dam bɨ Jisas mɨnɨm dad ameb okok mɨdelak sɨŋak dapel, kɨri God nop sobok gɨl, ñɨnmagɨl nabɨc kɨrop ar alaŋ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pen kɨri God Mɨnɨm ag ñel, amek nɨŋlɨg gɨ, Jerusalem bin bɨ koŋai yɨb nep Jisas nop nɨŋ dɨlak. Pen bɨ God nop tap sobok gep bɨ okok koŋai yɨb nep Jisas mɨnɨm tep ak nɨŋɨl nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God ne Stipen nop dɨ tep yɨb gɨl, kɨlɨs ne nop ñek, Stipen ne tap ma gep rek okok, tap nɨŋep ma nɨŋep okok, koŋai nep bin bɨ mɨdelak nab sɨŋak golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pen Juda bin bɨ karɨp lɨm ke ke okok nɨb ognap apɨl, Juda mogɨm gep karɨp alap apɨl, God nop sobok gölɨgɨpal; Juda mogɨm gep karɨp nɨbak, “Mɨñi Mɨñ Ma Mɨdobɨn Karɨp” agölɨgɨpal. Bɨ Juda nɨb okok, ognap Sairini taun nɨb, ognap taun kɨb Aleksadria nɨb, ognap Silisia Propins nɨb, ognap Esia Propins nɨb. Kɨri Stipen gak rek nɨŋɨl, kɨlɨs yɨb gɨl nop mɨnɨm pen pen aglak ak pen, ");
INSERT INTO kmh_m_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","God Kaun ne Stipen nop gos tep yɨb ñek nɨŋlɨg gɨ, bɨ Juda okok nop mɨnɨm tari aglak ak, gos nɨŋ tep gɨl pen ak rek nep mɨnɨm tep yɨb agek, nop pen agnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pen kɨri Stipen nop ag mer nɨŋɨl, am bɨ mɨnɨm tom agep ognap kɨrop kamger ag rep gel, kɨri apɨl aglak, “Cɨn nɨpɨn, bɨ aul ne Mosɨs mɨnɨm ñu kɨl tɨkak ak ag juɨl, God nop ag juɨl gɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kɨri mɨnɨm tom nɨbak agelak, bin bɨ yokop okok lɨl, bɨ mɨnɨm tɨg bɨlokep okok lɨl, bɨ lo mɨnɨm ag ñeb bɨ okok lɨl, cɨbur kɨrop ak tɨmel gek, Stipen nop mɨnɨm kɨb agnɨg dam Juda Kansol kɨb mɨdelak okok dad amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Damɨl, bɨ mɨnɨm tom agep ognap sek dapel, kɨri aglak, “Cɨn nɨpɨn, bɨ nɨbaul per nep God sobok gep karɨp sɨŋ aul ag juɨl, Mosɨs lo mɨnɨm ñu kɨl tɨkak ak ag juɨl gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pen ne mɨnɨm alap agosɨp nɨpɨn ak, agɨp, ‘Jisas bɨ Nasaret nɨb ak, kɨsen God sobok gep karɨp aul gɨ tɨmel gɨl genɨgab, Mosɨs mɨnɨm cɨnop ag ñak gɨpɨn ak kɨrɨg gɨl, mɨnɨm kɨsen nɨb dɨl sain gɨnɨgabɨn,’ agɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pen Juda Kansol kɨb mɨdelak bɨ okok, Stipen nop nɨŋ i sek lɨl nɨŋlak, mɨlɨk jo mɨlɨk ne ak ejol mɨlɨk jo mɨlɨk rek lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kɨri mɨnɨm esek nɨbak agel, God nop tap sobok gep bɨ kɨb yɨb ak Stipen nop agak, “Mɨnɨm nep agebal nɨbak nɨŋɨd agebal aka esek agebal?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Agek, Stipen agak, “Bapi mam sɨkop, nɨŋɨm! Based acɨk cɨn Ebraham bɨrarɨk nep taun kɨb Haran ma amnak ñɨn ak, karɨp lɨm Mesopotemia mɨdek won ak, God melɨk tep ke sek mɨdeb ak nop agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Karɨp lɨm nak aul kɨrɨg gɨl, bin bɨ nak okok kɨrɨg gɨl, karɨp lɨm ke yad nep yomnɨgain ak amnɨmɨn,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Agek, Ebraham karɨp lɨm kɨb Kaldia mɨdolɨgɨp ak kɨrɨg gɨl, taun kɨb Haran am mɨdolɨgɨp. Kɨsen Ebraham nap kɨmek, God agek, apɨl karɨp lɨm nɨbi mɨdebɨm nab sɨŋaul mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ñɨn nɨbak God Ebraham nop lɨm dai mɨgan alap ma agak. Apɨl yokop nep mɨdolɨgɨp. Ñɨn nɨbak Ebraham ñɨ pai alap ma tɨkak; yokop nep mɨdolɨgɨp. Pen God Ebraham nop agak, ‘Kɨsen lɨm dai nɨbaul, nak dɨnɨgan. Ñɨ pai nak tɨk donɨgan tɨk dapel amnɨgab okok, lɨm dai nɨbaul ak rek nep dɨl mɨdenɨgal,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pen God mɨnɨm alap agɨl agak, ‘Ñɨ pai nak tɨk donɨgan tɨk dapel amnɨgab okok, amɨl bin bɨ ognap karɨp lɨm okok mɨdel, kɨrop magɨlsek mɨñ lɨl, gɨ tɨmel yɨb gɨl, mɨñ wög rek ag lel, gel nɨŋlɨg gɨ, mɨ aknɨb po hadred (400) yɨnnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pen bin bɨ kɨrop nɨg genɨgal okok, yad pen kɨrop gɨ tɨmel gɨnɨgain. Bin bɨ nak okok, karɨp lɨm nɨbak kɨrɨg gɨl, ap yɨp sobok gɨlɨg gɨ mɨdenɨgal karɨp lɨm aul,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pen God Ebraham nop mɨnɨm kɨlɨs nɨŋɨd alap ag lɨl agak, ‘Ñɨ pai nak tɨk donɨgan tɨk dapel amnɨgab okok, nɨbep kod mɨdenɨgain ak me, ñɨŋaŋ lakañ sek waŋ wak tɨb gɨ rɨk gɨnɨmɨb,’ agak. Agek, kɨsen Ebraham ñɨ ne Aisak nop tɨk dapɨl, ñɨn aknɨb ar oŋɨd mɨdɨl, ñɨn jɨl oŋɨd ak ñɨ ak nop waŋ wak tɨb gɨ rɨkak. Aisak pen Jekop nop tɨk dowak. Jekop ne pen ñɨ aknɨb umɨgan alaŋ okok kɨrop tɨk dapek me, cɨn Isrel bin bɨ wagɨn ke ke mɨdobɨn. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Based acɨk cɨn nɨb okok, nɨmam ned sɨkop okok nɨmam kɨsen Josep nop gos tɨmel nɨŋɨl, mɨlɨk yapek, bɨ ognap ñel, nop tau dad karɨp lɨm Ijip dad amnɨlak. Dad amel, mɨd tep ma gak ak pen God nop saköl ma gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tap mɨker Josep nop apek ak, God ne nɨŋɨl Josep nop kod mɨd tep golɨgɨp. God ne Josep nop gos tep ñɨl gek, Ijip Kiŋ Pero, bɨ Josep aul gos nɨŋ tep yɨb geb, agɨl, nop agek, lɨm dai Ijip abe, karɨp tap ne okok magɨlsek abe, kod mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kɨsen ñɨn alap yuan kɨb yɨb ak, karɨp lɨm Ijip abe, karɨp lɨm cɨn Kenan aul abe apek, based cɨn karɨp lɨm Kenan aul mɨdelak okok tap magɨl pɨyo nɨŋɨl, tap ñɨŋeb alap ma mɨdek, gos par yɨb lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pen nap kɨri Jekop mɨnɨm alap nɨŋak, tap magɨl koŋai nep karɨp lɨm Ijip mɨdek. Nɨb ak nɨŋɨl ñɨ ne okok kɨrop agek, tap magɨl taunɨg Ijip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Am tau dapɨl, ñɨb sakɨl, kauyaŋ pen taunɨg amnɨlak. Amel, nɨmam Josep kɨrop agak, ‘Mam sɨkop, nɨbi yɨp bɨ an, agɨl nɨpɨm? Yad namam nɨbi Josep nep,’ agak. Agek, Ijip Kiŋ Pero mɨnɨm nɨbak nɨŋɨl agak, ‘Ak Josep nɨmam sɨkop ne okok e!’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep pen, bapi yad Jekop, bin bɨ ne okok eip kasek onɨmel, agɨl, mɨnɨm ag yokek, nap Jekop bin bɨ ñɨnjuɨl omal nokɨm adɨk gɨ dam ajɨp pɨs kɨd adaŋ (75) rek dɨl, eip amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nap Jekop nɨg gɨl, karɨp lɨm Ijip am mɨdɨl, kɨmak. Mɨd damɨl, based sɨkop nɨb okok magɨlsek kɨm saklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pen kɨsen ñɨ kɨri okok nap tɨŋɨl damɨl, taun kɨb Sekem tɨgel gɨlak. Cɨp tɨgel nɨbak, based acɨk Ebraham, Hemor ñɨ ne okok kɨrop mani alap ñɨl tauak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pen God Ebraham nop ned gɨnɨgain, agɨl, mɨnɨm ag lak rek gɨnɨg gɨl gak ak me, bin bɨ cɨn Isrel karɨp lɨm Ijip mɨdelak okok, ñɨ pai tɨk damɨl tɨk dam dapɨl gɨl, koŋai yɨb nep mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bin bɨ cɨn Isrel koŋai nep mɨdelak ñɨn nɨbak, karɨp lɨm Ijip ak kiŋ kɨsen nɨb mɨseŋ lak. Kiŋ kɨsen nɨb nɨbak based Josep nop ma nɨŋak ak me, ");
INSERT INTO kmh_m_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","bin bɨ cɨn okok gɨ tɨmel yɨb gɨl, mɨnɨm kɨlɨs agek, ñɨ pai kɨri okok tɨk dapɨl, söŋ ken okok yokel, ke mɨdɨl kɨmelɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nɨg gɨlak ak pen, ñɨn nab nɨb sɨŋak, ber mal ñɨ wak tep yɨb alap tɨk dapɨl, yɨb ne Mosɨs agrek. Ñɨ nɨbak nop takɨn omal nokɨm karɨp ñɨlɨk mɨgan okok nep we ger mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kɨsen ñɨŋaŋ nɨbak nop dam söŋ sɨŋ eyaŋ lɨrek, Pero pai ne ak apɨl, nop nɨŋɨl, dam ñɨ yad, agɨl, yɨmag lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ne nɨg gɨl yɨmag lek, kɨb gek, Ijip bin bɨ kɨri tari tari gölɨgɨpal ak, nop ag ñɨ tep gɨlak. Ne bɨ mɨnɨm kɨlɨs gɨ agɨl, wög kɨlɨs gɨl golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pen Mosɨs mɨ ne aknɨb ñɨnjuɨl omal (40) yɨnek, bin bɨ yad Isrel kɨrop am nɨŋɨl owin agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pen amɨl nɨŋak, Ijip bɨ alap Isrel bɨ alap nop tapɨn magɨl pakek. Mosɨs nɨŋɨl, bɨ Isrel nop dɨ komɨŋ yokɨl, Ijip bɨ ak nop pɨs nep ñag pak lek kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pen Mosɨs gos ne nɨŋak ak, ‘Bin bɨ yad Isrel agnɨgal, “God Mosɨs nop gos ñek, apɨl cɨnop tɨg asɨk yokek, mɨd tep gɨnɨgabɨn,” agnɨgal,’ ag nɨŋak ak pen kɨri gos nɨbak ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pen mɨnek Mosɨs amɨl nɨŋak, Isrel bɨ omal pen pen gerek. Nɨg gerek nɨŋɨl agak, ‘Bɨ aul, nɨri mamɨl mal mɨdebir; pen pen gebir ak kɨrɨg gir!’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Agek, bɨ alap bɨ alap nop pakek ak, Mosɨs nop dɨ okdaŋ yokɨl agak, ‘Nak bɨ an agek, bɨ kɨb mɨdɨl, cɨrop bɨ mɨnɨm tɨg bɨlokep rek kod mɨdeban? ");
INSERT INTO kmh_m_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nak tol Ijip bɨ ak ñag pak lɨnak ak, mɨñi yɨp abe ñag pak lɨnɨg ageban aka?’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nɨb agek, Mosɨs bɨ ñag pak lɨpin nɨbak nɨpal, agɨl, pɨrɨk gɨ am karɨp lɨm Midian amɨl, bɨ yokop alap rek mɨdolɨgɨp. Ñɨn nab nɨb sɨŋak, ne bin dɨl, ñɨ omal tɨk dowak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nɨg gɨl yokop nep mɨdek mɨ ñɨnjuɨl omal (40) yɨnak. Kɨsen ñɨn alap mɨñ mab kab nep mɨdeb Sainai Dɨm ulep sɨŋak mɨdɨl nɨŋak, ejol alap apɨl, mab bɨd nokɨm alap mɨlaŋ gek nab sɨŋak mɨseŋ lek nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nɨg gek Mosɨs nɨŋɨl, tap nɨbak tari geb, agɨl, am ulep sɨŋak apɨl nɨŋek nɨŋlɨg gɨ, Bɨ Kɨb agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nased acɨk Ebraham, Aisak, Jekop, God kɨri yad mɨdebin,’ agak. Nɨb agek, Mosɨs, ak Bɨ Kɨb nep ageb, agɨl, pɨrɨkɨl jep jep dɨl, kɨyan gɨl udɨn ma nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Pen Bɨ Kɨb Mosɨs nop agak, ‘Lɨm dai sɨŋ aul ap mɨdeban rek, tob tɨrɨp nak ak tɨg juan. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ijip bin bɨ okok bin bɨ yad Isrel karɨp lɨm Ijip mɨdebal okok kɨrop gɨ tɨmel yɨb gɨpal, yad nɨpin. Kɨri sɨl agebal ak peyɨg nɨŋɨl, apɨl kɨrop tɨg asɨk yoknɨg opin. Nɨb ak, nak adɨk gɨ Ijip amnoŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Isrel bin bɨ ned Mosɨs nop aglak, ‘Nak bɨ an agek, bɨ kɨb mɨdɨl, cɨrop bɨ mɨnɨm tɨg bɨlokep rek kod mɨdeban?’ aglak. Pen kɨsen, God ejol ne ag yokek apɨl, mab bɨd mɨlaŋ gek nab sɨŋak Mosɨs nop mɨseŋ lek, God ne ke Mosɨs nop bin bɨ kɨb kɨri mɨdɨl kɨrop tɨg asɨk yokaŋ, agɨl, ag yokak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Pen Mosɨs Ijip amɨl, tap ma gep rek ognap sɨŋak gɨl, bin bɨ ne Isrel kɨrop dɨl ñɨg solwara ‘Lakañ’ apal ak amɨl, tap ma gep rek ognap sɨŋak gɨl, kɨsen Isrel bin bɨ poŋ dɨl dam mɨñ mab kab nep mɨdolɨgɨp nab okok amɨl, tap ma gep rek ognap sɨŋak gɨlɨg gɨ mɨdolɨgɨp. Nɨg gɨ mɨdek mɨdek, mɨ ñɨnjuɨl omal (40) yɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mosɨs ne nep me bin bɨ Isrel kɨrop agak, ‘God ne bɨ mɨnɨm ne agep alap, ñɨ nɨbi ke bɨ yad rek alap, ag yokek nɨbep onɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosɨs ne mɨñ mab kab nep mɨdolɨgɨp nab okok mɨdek; ne apɨs based cɨn eip mɨdek; Sainai Dɨm sɨŋak ejol alap apɨl Mosɨs nop mɨnɨm ag ñak. Mosɨs mɨnɨm nɨbak dɨl cɨnop Isrel bin bɨ ag ñɨnɨgab, agɨl, God ne mɨnɨm komɨŋ nɨbak Mosɨs nop ñak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mosɨs mɨnɨm komɨŋ nɨbak ag ñak ak pen based cɨn okok mɨnɨm nɨbak ma dɨlak. Kɨri Mosɨs nop ag juɨl, adɨk gɨ Ijip amnɨn, agɨl, gos ak nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kɨri Mosɨs nɨmam Eron nop aglak, ‘Bɨ nak Mosɨs cɨnop Ijip nɨb dowɨp ak, nop tari gɨp ak ma nɨpɨn. Nɨb ak, nak cɨnop tap god rek ognap gek, bɨ cɨn ognap god gɨnɨgan nɨb okok dɨ ned amel, cɨn kɨsen amnɨn,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ñɨn nɨbak nep, god esek kaj kau ñɨlɨk rek alap gɨ lɨl, yakɨr tap okok pak dap sobok gɨ ñɨlak. Kɨri tap ñɨnmagɨl kɨri ke gɨ lɨlak okok nɨŋɨl, ak god cɨn, agɨl, mɨñ mɨñ gɨlɨg gɨ tap kɨb dagɨl ñɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nɨg gelak, God kɨrop kɨrɨg gɨl agak, ‘Nɨg gɨpal ak, pɨb, takɨn, gap okok abramek sobok gɨlaŋ,’ agak. Ñɨn nɨbak kɨri tap nɨb okok nep sobok gölɨgɨpal ak me, bɨ God mɨnɨm agep alap God Mɨnɨm ak ñu kɨl tɨkɨl agak, ‘Isrel bin bɨ. Nɨbi ned mɨ ñɨnjuɨl omal mɨñ mab kab nep mɨdolɨgɨp nab okok ajölɨgɨpɨm ñɨn ak, kaj kau kaj sipsip tap okok pak yɨp sobok gɨ ma ñölɨgɨpɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nɨbi tap yokop esek omal nɨbi ke gɨ lɨpek ak nop tap pak sobok gɨ dagɨl ñɨlɨg gɨ, gɨ mɨdelɨgɨpɨm. Tap nɨbak, alap Molok agölɨgɨpɨm, alap gap rek gɨ lɨl, Repan agölɨgɨpɨm. Tap god tom nɨb omal nep, sel karɨp gɨ dɨ ajlɨg gɨ, sobok gɨlɨg gɨ mɨdelɨgɨpɨm. Gɨ mɨdelɨgɨpɨm nɨbak, yad nɨbep ag yoken, am mɨñ mɨdenɨgabɨm taun kɨb Babilon beŋ kɨd okok,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Based sɨkop cɨn okok mɨñ mab kab nep mɨdolɨgɨp nab okok mɨdelak ñɨn ak sel karɨp dad ajölɨgɨpal. Sel karɨp nɨbak mɨdek ak nɨŋɨl, God cɨnop eip mɨdeb, agɨl nɨŋölɨgɨpal. Sel karɨp nɨbak, God mɨnɨm agak rek nep gɨ lel mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kɨsen pen bɨ nap sɨkop okok, kɨri sel karɨp nɨbak yes kɨri Josua based sɨkop cɨn okok kɨrop ñel, kɨri dɨlak. Kɨsen, kɨri sel karɨp nɨbak dapelak nɨŋlɨg gɨ, God ne bin bɨ karɨp lɨm sɨŋaul mɨdelak okok pɨŋɨl ju yɨk gɨ yokak. Sel karɨp nɨbak mɨdɨl, mɨd damɨl, kɨsen Depid tɨk dolak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Based Depid, bɨ God nɨŋek tep gak bɨ ak, ne God nop ag nɨŋɨl agak, ‘Nak yau agek, yad karɨp nep tep alap gɨ len, nak God Jekop ned sobok golɨgɨp ak, karɨp nɨbak mɨdenɨgan,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Agek pen God ne yau ma agak. Kɨsen Solomon ne God sobok gep karɨp nɨbak gɨ lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pen God ar i oklaŋ mɨdeb ak, bin bɨ ñɨnmagɨl dɨl gɨ lɨnɨgal karɨp okok ma mɨdenɨgab. Bɨ God mɨnɨm agep alap mɨnɨm nɨbak agɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bɨ Kɨb ak ne agɨp, “Karɨp lɨm seb kab ar alaŋ sɨŋak sea kiŋ yad rek ar sɨŋak bɨsɨg mɨdɨl, lɨm dai wagɨn aul tob yad tau rɨbɨk lɨlɨg gɨ mɨdebin. Yɨp tari karɨp gɨ lem, yad kɨn mɨdenɨm? Yad karɨp sɨŋ akal ake lɨnɨm? ");
INSERT INTO kmh_m_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tap okok magɨlsek ñɨnmagɨl yad ke ma gɨ lɨpin aka?” agak,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Cɨn ke nɨŋ rep gɨpɨn, agɨl, tap si tap tɨmel nep gɨl, God Mɨnɨm ma nɨpɨm. Nased sɨkop gölɨgɨpal rek nep gɨpɨm. Kaun Sɨŋ ne nɨbep gos tep ñek nɨpkep, pen per mer apɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nased sɨkop okok, bɨ God mɨnɨm agep okok kɨrop magɨlsek gɨ tɨmel gɨlak. Bɨ God mɨnɨm agep bɨrarɨk okok, ‘God Bɨ Wög Gɨ Ñeb tep yɨb ak apeb,’ aglak. Pen nased sɨkop okok kɨri bɨ nɨb okok ak rek nep ñag pak lɨlak. Pen mɨñi God Bɨ Wög Gɨ Ñeb tep yɨb nɨbak apek me, nɨbi nop mɨmɨg nɨŋɨl ñag pak lɨpek. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pen God lo mɨnɨm ne ak, ejol ne okok kɨrop ag yokek dapel dɨpek, pen ageb rek nɨŋɨl ma gɨpɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stipen mɨnɨm nɨbak agek nɨŋlɨg gɨ, kɨrop mɨlɨk kal yɨb yapek, meg magɨl su rɨbɨkɨl kal julak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pen Kaun Sɨŋ ne Stipen ap ran jakɨl mɨdek nɨŋlɨg gɨ, ne kɨlan gɨ nɨŋɨl seb kab ar alaŋ sɨŋak nɨŋak, God melɨk tep aknɨb ke yɨb ne mɨdek nɨŋɨl Jisas ne God ñɨnmagɨl yɨpɨd pɨs ken ar ne warɨk mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stipen nɨŋɨl agak, “Nɨŋɨm! Yad nɨŋebin, seb kab ar alaŋ sɨŋak kɨjoŋ yɨk mɨdeb. Bɨ Ñɨ ne ak God ñɨnmagɨl yɨpɨd pɨs ken ar ne warɨk mɨdeb!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Stipen nɨb agek, tɨmɨd kɨri ak ñɨnmagɨl dɨ pɨlɨŋ gɨl, dai magɨlsek warɨkɨl, mɨnɨm bleble agɨl mɨnɨm kɨb yɨb agɨl, pɨg gɨ rɨkɨd ag amɨl ne mɨdek amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nop dɨ cɨcɨ lɨl, dam dam taun kɨb nɨbak söŋ ar eyaŋ dad amnɨlak. Bɨ nop mɨnɨm esek aglak okok kal juɨl, walɨj par kɨri okok tɨg juɨl, bɨ praj Sol mɨdek ulep sɨŋak yokel, ne kod mɨdek nɨŋlɨg gɨ, kɨri Stipen nop kab ju paklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nop nɨg gɨl pakel nɨŋlɨg gɨ, Stipen Bɨ Kɨb nop sɨk par agɨl agak, “Bɨ Kɨb Jisas, kaun magɨl yad dan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nɨb agɨl, kogɨm yɨmɨl, sɨk kɨb par agɨl agak, “Bɨ Kɨb! Yɨp ñag pak lebal aul, tap si tap tɨmel gebal ak nɨŋɨl kɨrɨg gɨnɨmɨn,” agak. Nɨb aglɨg gɨ kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stipen nop kab ju pak lɨlak ñɨn ak, Sol maŋ sɨŋak mɨdɨl, paj agɨl wobi yal yal agak. Ñɨn nɨbak nep, Jerusalem kai wagɨn gɨl, bin bɨ Jisas nɨŋ dɨ mɨdelak okok kɨrop gɨ tɨmel yɨb gelak. Nɨg gelak, bin bɨ Jisas nop nɨŋ dɨ mɨdelak okok kɨri magɨlsek pɨrɨk gɨl, karɨp lɨm Judia okok abe, karɨp lɨm Sameria okok abe, ke ke amnɨlak. Pen bɨ Jisas mɨnɨm dad ameb aknɨb umɨgan alaŋ okok kɨri nep Jerusalem sɨŋak mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pen God Mɨnɨm ageb rek nep gölɨgɨpal bɨ ognap, Stipen nop mapɨn yɨb gek nɨŋɨl sɨl kɨb yɨb aglɨg gɨ, cɨp dam tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol pen, bin bɨ Jisas nɨŋ dɨpal okok gɨ tɨmel yɨb gɨnɨgain, agɨl, karɨp karɨp gɨlɨg gɨ, bin bɨ nɨb okok kɨrop abramek lɨp gɨ dam mɨñ lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bin bɨ Jisas nop nɨŋ dɨ mɨdelak okok pɨrɨk gɨ am karɨp lɨm ke tɨgoŋ tɨgoŋ mɨdelak. Pen nɨb okok am mɨdɨl, Jisas mɨnɨm tep ak dam bin bɨ nɨb okok kɨrop ag ñölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Bɨ nak Pilip ak rek nep amɨl taun kɨb alap karɨp lɨm Sameria sɨŋak mɨdɨl, bin bɨ okok kɨrop, Mesaia owak mɨnɨm tep ak ag ñak. Pilip mɨnɨm agak ak abe, tap ma gep rek gak ak abe nɨŋɨl, mɨnɨm ne tari tari agak ak, tɨmɨd lɨ nɨŋ tep yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilip ne bin bɨ kɨjeki kɨyob ñɨlɨk sek mɨdelak okok koŋai nep gek, tap nɨb okok wal agɨl mɨs amnɨlak. Ne bin bɨ ñɨnmagɨl tob pɨnok gek kalau gak okok koŋai nep abe, bin bɨ tob gɨ go geb mo geb gak okok koŋai nep abe kɨrop gek, komɨŋ lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nɨg gek nɨŋlɨg gɨ, bin bɨ taun nɨbak kɨn mɨdelak okok nɨŋɨl magɨlsek mɨñ mɨñ yɨb gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pen taun kɨb nɨbak bɨ alap kɨn mɨdolɨgɨp, yɨb ne ak Saimon. Ne kɨj gɨl, tap ma gep rek ognap gek, Sameria bin bɨ okok magɨlsek gos par yɨb nɨŋölɨgɨpal. Yad bɨ pobɨŋ yɨb mɨdebin, agolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Saimon ne nɨg gek, bin bɨ yɨb mɨdek okok abe, bin bɨ yɨb ma mɨdek okok abe, Saimon mɨnɨm agak rek nep nɨŋɨl aglak, “Bɨ nɨbaul ne god ‘Kɨlɨs Kɨb’ apɨn ak nep,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tap ma gep rek okok per golɨgɨp nɨŋɨl bin bɨ okok gos par nɨŋɨl, mɨnɨm agolɨgɨp rek nep nɨŋölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pen kɨsen Pilip apɨl, God bin bɨ dɨl karɨp ne seb kab alaŋ sɨŋak kod mɨdenɨgab mɨnɨm tep ak abe, Jisas Krais mɨnɨm tep ne ak abe ag ñek, bin bɨ okok kɨri mɨnɨm nop nɨŋ dɨl, ñɨg paklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon ne ke ak rek nep, Jisas nop nɨŋ dɨl ñɨg pakak. Pilip amek, Saimon nop sain gek nɨŋlɨg gɨ, Pilip tap ma gep aknɨb ke rek gek ak nɨŋɨl, Saimon ne wal yɨb agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bɨ Jisas mɨnɨm dad ameb okok Jerusalem mɨdel nɨŋlɨg gɨ, kɨrop mɨnɨm alap aglak, “Sameria bin bɨ God Mɨnɨm nɨŋ dɨpal,” aglak. Kɨri mɨnɨm nɨbak nɨŋɨl, Pita Jon kɨrop mal ag yokel, karɨp lɨm Sameria amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Amɨl nɨŋrek, bin bɨ okok Jisas nop nɨŋ del, Bɨ Kɨb Jisas yɨb agɨl kɨrop ñɨg pak ñɨlak ak pen Kaun Sɨŋ ne kɨrop ma owak. Nɨb ak, Pita Jon bɨ omal, Kaun Sɨŋ ne kɨrop owaŋ, agɨl, sobok gɨl, ñɨnmagɨl nabɨc cög kɨrop ar alaŋ lel, Kaun Sɨŋ ne kɨrop nokɨm nokɨm owak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kɨri mal ñɨnmagɨl nabɨc cög ar alaŋ ler, God ne Kaun Sɨŋ bin bɨ okok kɨrop ñak ak, Saimon nɨŋɨl, yad ak rek nep gin, agɨl, kɨrop mal mani yomɨl agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Mani aul dɨl, yɨp kɨlɨs nɨbak ñer, yad bin bɨ an an ñɨnmagɨl yad nabɨc cög ar alaŋ len, kɨri ak rek nep Kaun Sɨŋ dɨnɨgal,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nɨb agek, Pita agak, “God tap tep ne yokop ñeb nɨbak, tari gɨnɨg mani taunɨg ageban? Mani nɨbak nak ke eip ki gɨ yonɨgab! ");
INSERT INTO kmh_m_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wög cɨr gobɨr ak nak eip mer. Cɨbur gos mɨdmagɨl nak nɨŋ dɨ mɨdeban ak, God nɨŋek tep ma gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tap si tap tɨmel gɨnɨm, agɨl, gos nɨŋeban ar ak kɨrɨg gɨl, God nop sobok genɨgan ak, gos tɨmel yɨb nɨŋeban nɨbak nɨŋɨl kɨrɨg gɨnɨmɨŋ rek lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yad nɨpin, tap tep kɨri sɨŋak tap yad rek mɨdobkop, agɨl, gos tɨmel nɨŋɨl, tap si tap tɨmel gek ameb. Nɨb ak, nak tap si tap tɨmel gep magɨl ak, mɨñ wög gep bɨ rek mɨdeban. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Agek, Saimon agak, “Nɨr mal Bɨ Kɨb ak nop sobok ger, tap yɨp gɨnɨmɨŋ rek lɨp, agɨl agebir nɨbak ma gɨnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pen Pita eip Jon eip, Jisas kɨrop mal tari tari gak mɨnɨm ak abe, Bɨ Kɨb mɨnɨm tep ak abe, bin bɨ okok kɨrop ag ñɨ sakɨl, adɨk gɨ Jerusalem amnɨg, kanɨb nab okok amlɨg gɨ, karɨp lɨm Sameria nab sɨŋak karɨp tɨrɨg tɨroŋ koŋai nep bin bɨ okok kɨrop Jisas mɨnɨm tep ak ag ñɨlɨg gɨ amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pen Bɨ Kɨb ejol alap apɨl Pilip nop agak, “Jerusalem nɨb taun kɨb Gasa ambal kanɨb par ak amnoŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Agek, Pilip kanɨb agak par nɨbak amɨl nɨŋak, bɨ kɨb alap, kaj hos lɨp gɨ dad ameb tap bad ar alaŋ bɨsɨg gɨl, kanɨb par nɨbak amek. Bɨ nɨbak ne bin kwin Kadaki, karɨp lɨm kɨb Itiopia kod mɨdek bin ak nop wög gɨlɨg gɨ, mani ne ak kod mɨdolɨgɨp. Pen ne Jerusalem God sobok gep karɨp ak amɨl sobok gɨlɨg gɨ mɨd juɨl, ");
INSERT INTO kmh_m_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","adɨk gɨ karɨp lɨm Itiopia amɨl, God Mɨnɨm dai Aisaia ñu kɨl tɨkak ak dɨl, udɨn lɨ nɨŋlɨg gɨ amek. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pen God Kaun Pilip nop agak, “Hos tap bad lɨp gɨ dad ameb adaŋ am ulep bak sɨŋak amɨl, bɨ nɨbak eip amnɨmir,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","God Kaun agak rek nep, Pilip pɨg gɨ rɨkɨd ag ulep bak sɨŋak amɨl nɨŋak, bɨ Itiopia nɨb nɨbak, bɨ God mɨnɨm agep Aisaia God Mɨnɨm dai ñu kɨl tɨkak ak, udɨn lɨ nɨŋlɨg gɨ amek. Pilip nɨŋɨl agak, “Nak mɨj udɨn lɨ nɨŋlɨg gɨ ameban pɨyak ak, mɨnɨm wagɨn ak nɨb ageb, agɨl nɨpan aka mer?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Agek, ne pen agak, “Bin bɨ ognap rek yɨp ag ñel nɨŋɨl rek agnɨm,” agak. Nɨb agɨl ne Pilip nop agak, “Ap ar sɨŋaul bɨsɨgek cɨr eip amnɨr,” agak. Agek, Pilip am ar nɨbak bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bɨ nɨbak God Mɨnɨm dai Aisaia ñu kɨl tɨkak nɨbak udɨn lɨ nɨŋek. Mɨnɨm nɨbak nɨbgɨl mɨdeb: “Ne kaj sipsip poŋ dɨl dam ñag pak lɨpal rek nep mɨdek. Kaj sipsip ñɨlɨk kas tɨkel, wal ma agɨp rek, ne ak rek nep mɨnɨm alap ma agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tap tɨmel alap ma gak ak pen nop mɨnɨm esek agɨl, gɨ tɨmel gɨlak. Nop pɨs nep ñag pak lel kɨmak ak me, kɨsen bɨ an rek mɨdɨl, ‘Nɨb nɨb golɨgɨp,’ agnɨgab?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bɨ kɨb Itiopia nɨb ak mɨnɨm nɨbak nɨŋɨl, Pilip nop agak, “Mɨnɨm ageb nɨbaul, God mɨnɨm agep bɨ ak ne ke ageb aka bɨ ke nɨb alap ageb?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Agek, Pilip God Mɨnɨm dai udɨn lɨ nɨŋesir ak nep wagɨn gɨl ag dam dam, Jisas mɨnɨm tep ak ag ñɨ tep gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pen nɨg gɨl mɨnɨm ag damlɨg gɨ nɨŋrek ñɨg alap mɨdek. Bɨ nɨbak Pilip nop agak, “Ñɨg mɨdeb aul yɨp ñɨg pak ñɨnɨgan aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Agek, Pilip agak, “Nak Krais nop cɨbur gos mɨdmagɨl yad nɨŋɨd nep nɨŋ dɨpin agenɨgan ak, yad nep ñɨg pak ñɨnɨgain,” agak. Agek, bɨ nɨbak pen agak, “Jisas Krais ne God Ñɨ ne mɨdeb ak, yad nɨŋ dɨpin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Agek, kaj hos tap lɨp gɨ dad ameb ar bɨsɨg aperek ak, hos ak sek nɨb sɨŋak lɨl, ñɨg eyaŋ amɨl, Pilip bɨ nɨbak nop ñɨg pak ñak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nɨg gɨl ñɨg pak ñɨl, gol sɨŋak aper nɨŋlɨg gɨ, dai Bɨ Kɨb Kaun ne Pilip nop dɨl, ke mɨgan alap dad amek nɨŋlɨg gɨ, bɨ pobɨŋ nɨbak nop ma nɨŋak. Ne pen mɨñ mɨñ yɨb gɨlɨg gɨ kanɨb ar nɨbak amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pen Bɨ Kɨb Kaun ne Pilip nop dam karɨp lɨm Asotas lek, bin bɨ karɨp lɨm nɨb okok taun ke ke mɨdelak okok kɨrop magɨlsek Jisas mɨnɨm tep ak ag ñɨ dam dam, taun kɨb Sisaria amjakak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pen Sol ne Bɨ Kɨb mɨnɨm tep nɨŋ dɨl kɨsen gölɨgɨpal bin bɨ okok kɨrop ñag pak lin, agɨl, per kɨlɨs yɨb golɨgɨp. Mɨnek alap ne am God nop tap sobok gep bɨ kɨb yɨb ak nop agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Yɨp mɨj ognap ñu kɨl tɨk ñenɨmɨn, yad dam Juda mogɨm gep karɨp ke ke mɨdeb taun kɨb Damaskas amɨl, kɨrop ñɨnɨgain. Mɨj nɨbak ñu kɨl tɨkɨl agnɨmɨn, ‘Taun kɨb Damaskas sɨŋak, nɨbi bin bɨ Jisas nop nɨŋ dɨpal ognap Juda mogɨm gep karɨp okok mɨdenɨmel ak, Sol nop agem, kɨrop mɨñ lɨl Jerusalem donɨmɨŋ,’ agɨl, ñu kɨl tɨknɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol mɨj nɨbak dɨl, Damaskas ulep ulep gek nɨŋlɨg gɨ, dai melɨk seb kab ar alaŋ nɨb ap yapɨl nop nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol kaj hos ar alaŋ nɨb ap yap lɨm eyaŋ pakek nɨŋlɨg gɨ, mɨnɨm alap nop agak, “Sol, Sol, yɨp tari gɨnɨg gɨ per gɨ tɨmel gɨpan?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Agek, Sol agak, “Bɨ Kɨb, nak bɨ an?” agak. Agek, agak, “Yad Jisas, yɨp per gɨ tɨmel gɨpan ak nep agebin. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pen nak warɨkɨl, Damaskas amɨl, bɨ alap apɨl nep mɨnɨm agenɨmɨŋ rek nɨŋɨl gɨnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pen bɨ Sol eip olak okok mɨnɨm magɨl ak nep nɨŋɨl, bɨ nonɨm ak ma nɨŋɨl, gos par yɨb nɨŋɨl mɨnɨm ognap ma aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol pen warɨkɨl udɨn ñɨlɨl nɨŋak, udɨn ne ak pɨs nep kwoi gak. Nɨg gek, bɨ ne eip olak okok ñɨnmagɨl kɨd ne ak dɨl, poŋ dɨl Damaskas amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nop nɨg gɨl udɨn kwoi gek, ñɨg, tap magɨl tap okok ma ñɨbɨl, ñɨn omal nokɨm yokop nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pen Jisas nop nɨŋ dak bɨ alap Damaskas mɨdek, yɨb ne ak Ananaias. Bɨ nɨbak ne nɨgrɨkep nɨŋak, Jisas nop agak, “Ananaias!” agak. Agek agak, “Bɨ Kɨb, yad mɨdebin,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Agek, Jisas agak, “Sol bɨ taun kɨb Tasas nɨb ak, God nop sobok gɨlɨg gɨ, nɨgrɨkep nɨŋɨp, bɨ Ananaias apal ak, nop am dɨ nɨŋosɨp, udɨn ne kwoi gak ak ñɨlɨl nɨŋɨp. Ne mɨñi yɨp sobok gɨlɨg gɨ mɨdeb Judas karɨp ak. Nɨb ak, nak kanɨb ‘Yɨpɨd’ apal ak amɨl, Judas karɨp ak amjakɨl kɨrop agnɨmɨn, ‘Sol nop nɨŋnɨg apebin,’ agnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jisas ne nɨb agek, Ananaias agak, “Bɨ Kɨb. Yad nɨpin bin bɨ koŋai yɨb nep apal, ‘Bɨ Sol nɨbak bin bɨ nep pɨs ken mɨdebal Jerusalem okok kɨrop per gɨ tɨmel yɨb gɨp,’ apal. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne mɨñi Damaskas aul owɨp ak, bɨ God tap sobok gep bɨ kɨb okok mɨj ognap nop ñel, bin bɨ an an yɨb nak agel ar amnɨgab okok, kɨrop mɨñ lin, agɨl, owɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananaias nɨb agek, Bɨ Kɨb nop agak, “Amnoŋ! Bɨ nɨbak wög ognap yad ke nop ag lɨpin. Ne mɨnɨm tep yad ak Isrel bin bɨ kɨrop ag ñɨl, Isrel bin bɨ mer okok kɨrop ag ñɨl, kiŋ okok kɨrop ag ñɨl gɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pen ne yur mab dɨl mɨker kɨb dɨlɨg gɨ wög yad nɨbak gɨnɨgab. Nɨg gɨnɨgab ak yad ke nop ag ñɨ tep gɨnɨgain,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bɨ Kɨb nɨb agek, Ananaias amɨl, Sol mɨdek karɨp ak apjakɨl, mɨgan eyaŋ amɨl, Sol nop nabɨc cög ar alaŋ ñɨnmagɨl lɨl agak, “Mam Sol. Bɨ Kɨb Jisas nep kanɨb nab sɨŋak ap yapɨl mɨseŋ lek nɨŋnak ak, yɨp ag yokosɨp opin aul. Nak udɨn nak kauyaŋ ñɨl nɨŋɨl, Kaun Sɨŋ ne nep am ap ran jaknɨmɨŋ, agɨl, yɨp ag yokosɨp opin me aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias nɨb agek nɨŋlɨg gɨ, tap apab sagaɫ bad rek Sol udɨn nop karɨkɨl mɨdek ak, wal gɨ yapek nɨŋlɨg gɨ, dai udɨn ñɨl nɨŋak. Udɨn ñɨl nɨŋɨl, warɨk amɨl, ñɨg pakak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sol tap ñɨbɨl kɨlɨs dak. Pen Sol ne ñɨn ognap bin bɨ Jisas nop nɨŋ dɨlak okok eip Damaskas kɨn mɨdlɨg gɨ, ");
INSERT INTO kmh_m_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Juda mogɨm gep karɨp okok gɨ tagɨl, Jisas ne God Ñɨ ne mɨdeb mɨnɨm tep ak bin bɨ okok kɨrop ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ne nɨg gɨl ag ñɨ mɨdek nɨŋlɨg gɨ, kɨri nɨŋɨl pak ju dɨlɨg gɨ aglak, “Bɨ aul nep me, Jerusalem bin bɨ Jisas nop nɨŋ dɨlak okok kɨrop gɨ tɨmel golɨgɨp! Mɨñi bin bɨ ognap sek nag lɨ dam, bɨ God sobok gep bɨ kɨb okok kɨrop ñɨnɨm, agɨl, owɨp,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pen Sol Jisas mɨnɨm tep ak ag ñɨ damɨl, Jisas ne nep Mesaia ak mɨnɨm yɨpɨd gɨl yɨb agek, bɨ Juda Damaskas kɨn mɨdelak okok mɨnɨm alap pen agnɨmel rek ma lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pen kɨsen mɨd damɨl, Juda kai ap mogɨm gɨl, mɨnɨm ag ar nokɨm lɨl aglak, “Sol nop ñag pak lɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pen mɨnɨm aglak nɨbak, bɨ alap nɨŋɨl Sol ag ñak. Taun kɨb nɨbak, bɨrarɨk nep kab wari gɨ kɨs kɨs gɨlak ak me, kɨjoŋ tam ajölɨgɨpal okok, Sol nop ñag pak lɨn, agɨl, pɨb nab kɨslɨm eyaŋ ulɨŋɨn lɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nɨg gelak nɨŋɨl Sol bɨ ne okok kɨslɨm nab eyaŋ nop dɨ wad mɨgan pobɨŋ alap yɨgɨl, nag ñon gɨl, lɨp gɨ wari nɨbak mɨgan alap mɨs ken ar alaŋ nɨb lɨm eyaŋ yokel, pɨrɨk gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem amɨl, bin bɨ Jisas pɨs ar mɨdelak okok eip mɨdenɨm, agek pen kɨri nɨŋɨl, bɨ aul Jisas bɨ ne alap mer, cɨnop ñag pak lɨnɨg owɨp, agɨl, jel gek pɨrɨklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nɨg gelak, Banabas ne Sol nop dam bɨ Jisas mɨnɨm dad ameb okok mɨdelak sɨŋak amɨl, kɨrop agak, “Bɨ nɨbaul nop nɨŋɨl ma pɨrɨknɨmɨb. Mɨnek alap taun kɨb Damaskas amlɨg gɨ, kanɨb nab sɨŋak amɨl, Bɨ Kɨb nop nɨŋek, nop mɨnɨm ognap agak. Kɨsen am Damaskas bin bɨ kɨrop ma pɨrɨkɨl, Jisas mɨnɨm tep ak abramek nep ag ñak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas nɨb agek, kɨri Sol nop del, ne kɨrop eip Jerusalem kɨn mɨdɨl, taun kɨb nɨbak mɨgan mɨgan okok amɨl, Jisas mɨnɨm tep ak abramek yɨb nep ag ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Pen bɨ Juda Grik mɨnɨm nɨŋlak okok nop eip mɨnɨm pen pen ag amɨl apɨl gɨl, nop ñag pak lɨn, agɨl, gos ak nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pen bɨ Jisas nop nɨŋ dɨlak ognap mɨnɨm nɨbak nɨŋɨl, nop poŋ dɨl dam taun kɨb Sisaria amɨl yokel, taun kɨb Tasas amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ñɨn nab nɨb sɨŋak, karɨp lɨm Judia, Galili, Sameria okok, bin bɨ Jisas nop nɨŋ dɨlak okok mɨd tep gölɨgɨpal. Kaun Sɨŋ ne kɨrop kod mɨd tep gɨl, kɨlɨs ñek nɨŋlɨg gɨ, kɨri kɨlɨs gɨl, Bɨ Kɨb nop gos nɨŋlɨg gɨ mɨdɨl, bin bɨ ognap sek Jisas mɨnɨm tep ak ag ñel, kɨri ak rek nep Jisas nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita karɨp lɨm ke ke okok gɨ ajlɨg gɨ, bin bɨ Jisas nop nɨŋ dɨlak okok kɨrop am nɨŋ ajolɨgɨp. Nɨg gɨl kɨrop nɨŋ ajɨl, mɨnek alap, bin bɨ Jisas nop nɨŋ dɨlak okok kɨrop nɨŋin, agɨl, karɨp tɨrɨg tɨroŋ Lida amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Karɨp lɨm nɨbak bɨ alap mɨdek, yɨb ne ak Inias. Pen ñɨnmagɨl tob ne okok kalau gek, kau ar ne ak nep kɨn mɨdolɨgɨp mɨ aknɨb jɨl oŋɨd yɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita bɨ nɨbak nop agak, “Inias. Tap nep gɨp ak Jisas gek komɨŋ lɨnɨgab. Warɨkɨl, kau nak ak yad tep gan,” agak. Nɨb agek nɨŋlɨg gɨ, magɨl nɨbak nep Inias nop komɨŋ lek warɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Inias warɨkɨl gɨ tagek nɨŋlɨg gɨ, karɨp tɨrɨg tɨroŋ Lida bin bɨ okok abe, karɨp lɨm Seron bin bɨ okok abe nop nɨŋɨl, Bɨ Kɨb nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pen Pita karɨp tɨrɨg tɨroŋ Lida nɨbak mɨdek nɨŋlɨg gɨ, bin Jisas nop nɨŋ dak alap kɨmak yep taun kɨb Jopa sɨŋak. Bin nɨbak yɨb ne Tabita. Pen Grik mɨnɨm agɨl nop Dokas agölɨgɨpal. Ne bin bɨ okok kɨrop kod mɨd tep gɨl, bin bɨ yɨm gep rek okok kɨrop wög gɨ ñolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bin nɨbak nop tap gek bɨr kɨmek, nop ñɨg pak ñɨl cɨp se dam karɨp ñɨlɨk mɨgan ar alaŋ lɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jisas bin bɨ ne Jopa mɨdelak okok mɨnɨm alap nɨŋlak, Pita ap mɨdek karɨp tɨrɨg tɨroŋ Lida sɨŋak. Lida taun kɨb Jopa ulep sɨŋak mɨdeb nɨŋɨl kɨri bɨ omal kɨrop ag yokel, Pita mɨdek sɨŋak amɨl mɨnɨm kɨlɨs agɨl agrek, “Nak cɨr eip kasek apek amnɨn,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Agerek, Pita kɨrop mal eip Jopa amɨl amjakel nɨŋlɨg gɨ, nop poŋ dɨ dam Tabita kɨmak dam lɨlak karɨp mɨgan ar alaŋ amnɨlak. Pita nop poŋ dɨ dad amel nɨŋlɨg gɨ, bin kaŋɨl ap mɨdelak okok, bin kɨmak nɨbak ned komɨŋ mɨdolɨgɨp ak, walɨj par walɨj ognap kɨrop yokop ñolɨgɨp okok, Pita nop yomlɨg gɨ, sɨl aglɨg gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita pen bin bɨ ap mɨdelak nɨb okok kɨrop ag söŋ eyaŋ yokɨl, kogɨm yɨmɨl, God nop sobok gɨlɨg gɨ, adɨk gɨl, cɨp se nɨŋlɨg gɨ agak, “Tabita, warɨkan!” agak. Agek, Tabita udɨn ñɨl Pita nop nɨŋɨl, warɨk bɨsɨgak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita pen ñɨnmagɨl kɨd ne ak dɨl, tɨg warɨk ñɨl, bin kaŋɨl okok abe, bin bɨ Jisas nop nɨŋ dɨlak okok abe, kɨrop magɨlsek sɨk agek apelak agak, “Tabita aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pen Pita nɨg gek, mɨnɨm nɨbak Jopa bin bɨ magɨlsek nɨŋɨl, bin bɨ koŋai nep Bɨ Kɨb nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pen Pita ne taun kɨb Jopa nɨbak, bɨ kaj kau wak wög golɨgɨp bɨ alap eip ñɨn ognap tapɨn kɨn mɨdölɨgɨpir. Bɨ nɨbak yɨb ne Saimon. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pen ami bɨ okok kɨrop kod mɨdolɨgɨp bɨ kɨb alap taun kɨb Sisaria mɨdolɨgɨp. Yɨb ne ak Konilias. Ami bɨ ne kod mɨdolɨgɨp nɨb okok kɨrop “Itali Ami Bɨ” agölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bɨ kɨb Konilias nɨbak eip, bin bɨ karɨp ne okok eip, God nop nɨŋ dɨlak. Juda bin bɨ tap kɨri ognap ma mɨdolɨgɨp ak, Konilias ne mani tap okok abramek ñolɨgɨp. Pen ne God nop per sobok golɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mɨnek alap pɨb kim gak magɨl ak, Konilias ne nɨgrɨkep nɨŋak, God ejol alap apɨl agak, “Konilias!” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Agek, Konilias pɨrɨkɨl nop nɨŋ i sek lɨl agak, “Bɨ kɨb, yɨp tari ageban?” agak. Agek, ejol ak nop agak, “Nak God nop sobok gɨl, bin bɨ yɨm gep okok kɨrop tap abramek ñɨl gɨpan ak, God nop tep gek nep saköl ma gɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nak bɨ ognap agek, kɨri am taun kɨb Jopa amɨl, bɨ Saimon Pita apal ak nop agel onɨmɨŋ. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ne Saimon, bɨ kaj kau wak wög geb ak eip kɨn mɨdebir ñɨg solwara gol sɨŋak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pen ejol mɨnɨm nɨbak agɨl amek nɨŋlɨg gɨ, Konilias bɨ wög nop gɨ ñölɨgɨpir omal abe, ami bɨ God nop nɨŋ dak alap abe agek apelak, ");
INSERT INTO kmh_m_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kɨrop ejol ak mɨnɨm tari tari agak ak ag ñɨ tep gɨl ag yokek, Jopa amnɨg paŋdɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kɨri am am kanɨb nab sɨŋak kɨnlak. Mɨnek am am, pɨb nab epel magɨl ak, Jopa maŋ maŋ gɨlak. Won nɨbak Pita God nop sobok gɨnɨg amnak karɨp ar alaŋ mɨgan ak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ne amɨl, God nop sobok gɨ mɨdek nɨŋlɨg gɨ, nop yuan kɨb yɨb lak. Pen bin bɨ ne okok tap magɨl dagɨlel nɨŋlɨg gɨ, Pita nop dai alap yomak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pita nop dai ak yomek nɨŋak, seb kab ar alaŋ mɨgan pag yɨkek, wad kɨb alap ñon par omal omal gol pɨs pɨs ñon gɨl mɨdek nab sɨŋak yap yap lɨm wagɨn eyaŋ yowak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wad mɨgan nɨb eyaŋ kaj, kɨmɨn kobri, toi, yakɨr ke ke okok magɨlsek nep mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mɨnɨm alap pen nop agak, “Pita, nak warɨkɨl tap nɨb pɨyak okok pak ñɨŋan,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Agek, Pita pen agak, “Bɨ Kɨb. Mer yɨb! Tari gɨnɨg, ñɨŋan, agɨl ageban? Cɨn Juda bin bɨ tap bɨl gep nɨb okok tap ognap ma ñɨbin yɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Agek, mɨnɨm nɨbak kauyaŋ agak, “Tap tari tari God tap ñɨŋeb, agɨp okok, bɨl gep, agɨl ma agnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gak nɨbak, yɨj omal nokɨm gak. Kɨsen me, tap wad kɨb nɨbak adɨk gɨ seb kab ar alaŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nɨg gek, Pita nɨgrɨkep nɨpin nɨbak tari gɨnɨgab, agɨl, gos par nɨŋ mɨdek nɨŋlɨg gɨ, Konilias bɨ ag yokek nop agnɨg olak bɨ ñon ak kɨjoŋ wagɨn sɨŋak apjaklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Apjakɨl aglak, “Bɨ Saimon Pita sɨŋak mɨdeb aka?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita nɨgrɨkep nɨŋosɨp nɨbak gos nɨŋlɨg gɨ mɨdek nɨŋlɨg gɨ, God Kaun nop agak, “Nak nɨŋan! Bɨ omal nokɨm nep pɨyo nɨŋ apebal. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nɨb ak, warɨkɨl tam sɨŋak eyaŋ amnoŋ. Yad ke kɨrop ag yoken apebal. Nɨb ak, apek eip amnɨn agenɨmel ak, gos par ma nɨŋɨl eip amnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","God Kaun nɨb agek, Pita sɨŋ eyaŋ amɨl bɨ nɨb okok kɨrop agak, “Bɨ pɨyo nɨŋebɨm bɨ ak, yad me aul. Yɨp mɨnɨm alap agnɨg apebɨm aka?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Agek, aglak, “Bɨ kɨb Konilias, ami bɨ okok kɨrop kod mɨdeb bɨ kɨb ak cɨnop ag yokek apobɨn. Ne God nop nɨŋ dɨl, God Mɨnɨm ageb rek gɨp; Juda kai nop nɨŋel kɨrop magɨlsek tep gɨp. Pen ne nɨgrɨkep nɨŋak, God ejol alap apɨl nop agak, ‘Nak bɨ ognap ag yokek, am Saimon Pita nop poŋ dɨ dapel, mɨnɨm agonɨmɨŋ ak nɨŋnɨmɨn,’ agak,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nɨb agerek, Pita kɨrop agek karɨp ñɨlɨk mɨgan eyaŋ amɨl kɨnlak. Mɨnek Pita, bɨ Jopa nɨb Jisas nop nɨŋ dɨlak ognap dɨl, Konilias ag yokak bɨ ñon nɨbak eip am am kanɨb nab sɨŋak kɨnlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mɨnek ak, Sisaria amjakɨl, Konilias karɨp ak amjaklak. Pen Konilias ne Pita apeb, agɨl, bin bɨ ne okok abe, nɨmɨd nɨmam ne okok abe, kɨrop sɨk agek ap mogɨm gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ne amɨl karɨp mɨgan amnɨg gek nɨŋlɨg gɨ, Konilias nop nabɨŋ pakɨl, nop bɨ kɨb, agɨl, am tob wagɨn ne sɨŋak kogɨm yɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nɨg gek nɨŋlɨg gɨ, Pita pen nop tɨg warɨk ñɨl agak, “Nak warɨkan! Yad ak rek nep bɨ alap me aul,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Agek, warɨkek nɨŋlɨg gɨ, mɨnɨm aglɨg gɨ, karɨp ñɨlɨk mɨgan eyaŋ amnɨrek. Amɨl Pita nɨŋak, bin bɨ koŋai nep ap mogɨm gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita kɨrop agak, “Nɨbi ke nɨpɨm, cɨn Juda bin bɨ asɨk mosɨk gɨ tep gɨpɨn. Juda bin bɨ mer okok eip ma ajpɨn; karɨp kɨrop ma ambɨn. Pen yad nɨgrɨkep nɨŋnek, God yɨp mɨnɨm alap agak. Ne mɨnɨm agak nɨbak, yad bin bɨ ognap asɨk mosɨk mɨdebal, agɨl, kɨrop asɨk mosɨk gɨnɨm rek ma lɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nɨb ak nɨŋɨl me, Konilias mɨnɨm ag yokak ak nɨŋɨl ma kɨrɨg gɨpin; agak rek nep nɨŋɨl opin. Nɨb ak, mɨnɨm tari mɨdek ag yoknak opin?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pita nɨb agek, Konilias agak, “Yad menɨk nep me, mɨñi pɨb kim gɨp magɨl ak rek, karɨp ñɨlɨk mɨgan eyaŋ God nop sobok gɨ mɨdlɨg gɨ nɨŋnek, bɨ walɨj tɨd yɨb yɨmak alap apɨl, mɨdenek bak sɨŋak warɨkɨl mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ne yɨp agak, ‘Konilias, nak God nop sobok gɨl, mani tap okok bin bɨ tap ma mɨdeb okok kɨrop abramek ñɨl gɨpan ak, God nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nɨb ak me, bɨ ognap ag yokek, taun kɨb Jopa amɨl, Saimon yɨb ne alap Pita apal ak, nop poŋ dɨ dolaŋ. Ne Saimon bɨ kaj kau wak wög geb ak eip kɨn mɨdebir ñɨg solwara gol sɨŋak,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ejol ak yɨp nɨb agek, yad kasek nep bɨ yad ognap ag yoken, nep am ulɨk gɨ dapesal, yɨp tep gɨp. Cɨn bin bɨ sɨŋaul God eip mɨdobɨn rek, Bɨ Kɨb mɨnɨm kɨrop ag ñɨnɨmɨn, agɨl, nep ag yokek opan ak, mɨñi cɨnop ag ñek nɨŋɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Konilias nɨb agek, Pita agak, “Yad mɨñi nɨpin, God ne, bɨ ulep sɨŋaul nɨb nep bɨ tep, bɨ par okok nɨb bɨ tɨmel, agɨl, ma nɨŋɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Karɨp lɨm ke ke okok nɨb, wagɨn ke ke okok nɨb, bin bɨ an an God nop nɨŋɨl sɨskol dɨl, mɨnɨm ne nɨŋɨl ageb rek gɨnɨgal bin bɨ okok, kɨrop magɨlsek dɨnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pen God ne cɨnop Isrel bin bɨ mɨnɨm tep ag yokak ak nɨpɨm. Yad ke eip jɨm ñɨl mɨdelaŋ, agɨl, God ne Jisas Krais nop ag yokak. Jisas Krais ne nep me, bin bɨ okok magɨlsek Bɨ Kɨb kɨri mɨdeb. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nɨbi ke nɨpɨm, Jon bɨ ñɨg pak ñeb ak, ñɨg pak ñɨlɨg gɨ, mɨnɨm tep nɨbak wagɨn gɨl, karɨp lɨm Galili ag ñak. Nɨg gɨl agek, ag damlɨg, ag damlɨg, bin bɨ karɨp lɨm Isrel mɨdebal okok magɨlsek nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pen nɨbi nɨpɨm, Jisas Nasaret nɨb ak God eip mɨdɨl, Kaun Sɨŋ ak nop ñek, kod mɨdek nɨŋlɨg gɨ, kɨlɨs ne nep dɨl, karɨp lɨm ke ke okok magɨlsek taglɨg gɨ, bin bɨ okok gɨ tep gɨlɨg gɨ, bin bɨ Seten kɨrop gek koslam mɨdelak okok kɨrop gek, komɨŋ lolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Pen Jisas Juda bin bɨ karɨp lɨm kɨri okok gɨ taglɨg gɨ, Jerusalem gɨ taglɨg gɨ, gak gak rek cɨn udɨn cɨn ke nɨŋnok ak agebin. Pen kɨsen nop mab bak alaŋ ñag pak lel kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kɨmak ak pen ñɨn omal mɨdɨl, God gek, ñɨn omal nokɨm ak kauyaŋ warɨkɨl, am mɨseŋ lek udɨn cɨn ke nɨŋnok. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Bin bɨ magɨlsek nop udɨn ma nɨŋlak. God cɨnop bin bɨ ag lak okok nep Jisas nop udɨn nɨŋnok. Ne kɨmɨl warɨkek nɨŋlɨg gɨ, eip mɨdɨl jɨm ñɨl tap ñɨbɨl ñɨg ñɨbonok. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jisas cɨnop agak, ‘Mɨnɨm tep yad ak bin bɨ okok kɨrop ag ñɨl agnɨmɨb, “God agak rek me, kɨsen Jisas bin bɨ komɨŋ mɨdenɨgal okok abe, bin bɨ kɨmnɨgal okok abe, kɨrop magɨlsek mɨnɨm kɨb agnɨgab,” agnɨmɨb,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pen ar nɨbak, bɨ God mɨnɨm agep okok magɨlsek Jisas Krais nop agɨl aglak, ‘Bin bɨ an an Krais yɨb kɨlɨs yɨb ne ak nɨŋ dɨnɨgal okok, tap si tap tɨmel gɨpal ak, God nɨŋɨl kɨrɨg gɨnɨgab,’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pen Pita nɨg gɨl mɨnɨm ag mɨdek nɨŋlɨg gɨ, Kaun Sɨŋ ne bin bɨ nɨŋ mɨdelak okok kɨrop magɨlsek owak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Kaun Sɨŋ kɨrop apek, kɨri mɨnɨm ar ke ke aglɨg gɨ, God yɨb ne agel ar amek, Juda bin bɨ Jisas nop nɨŋ dɨlak Pita eip Jopa nɨb olak okok, God Juda bin bɨ mer okok kɨrop Kaun Sɨŋ ñɨb me ak, agɨl, wal yɨb aglak. Pita pen agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“God ne Kaun Sɨŋ cɨnop ñak rek ak, mɨñi bin bɨ sɨŋ aul kɨrop ak rek nep ñɨb. Nɨb ak, kɨri ñɨg paknɨgaun, agel, bin bɨ ognap kɨrop mer agnɨmel rek ma lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pita nɨb agɨl bɨ ne ognap kɨrop agak, “Nɨbi bin bɨ sɨŋ aul kɨrop Jisas Krais yɨb ne agɨl ñɨg pak ñɨnɨmɨb,” agak. Ñɨg pak ñel nɨŋlɨg gɨ, kɨri aglak, “Pita, nak cɨnop eip ñɨn sɨkol magɨl eñap sɨŋaul mɨdenɨmɨn,” aglak. Agel, ñɨn sɨkol magɨl eñap kɨrop eip kɨn mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pen Jisas mɨnɨm dad ameb bɨ okok abe, karɨp lɨm Judia bin bɨ Jisas nop nɨŋ dɨlak okok abe nɨŋlak, Juda bin bɨ mer okok ognap God Mɨnɨm nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nɨb ak, kɨsen Pita Jerusalem amek, Juda bɨ mer okok ak rek nep wak tɨb gɨ rɨk gɨnɨmel, agölɨgɨpal bɨ okok, Pita nop kal gɨl aglak, ");
INSERT INTO kmh_m_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nak tari gɨnɨg bɨ wak tɨb gɨ rɨk ma gɨpal okok karɨp kɨri amɨl, kɨrop eip tap jɨm ñɨl ñɨban?” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nɨb agelak, Pita taun kɨb Jopa mɨdɨl nɨgrɨkep nɨŋak kesɨm ak kɨrop ag ñɨlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yad taun kɨb Jopa mɨdɨl, God nop sobok gɨ mɨdɨl, nɨgrɨkep nɨŋnek, seb kab ar alaŋ nɨb, wad kɨb alap rek ñon par omal omal gol pɨs pɨs tɨn gɨl mɨdek yap yap wagɨn yad mɨdenek sɨŋak ap yowak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Apek, yad wad nɨbak mɨdek ulep sɨŋak amɨl nɨŋnek, kaj, kɨmɨn kobri, toi, yakɨr okok okok magɨlsek mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pen mɨnɨm alap yɨp agak, ‘Pita, nak warɨkɨl tap nɨb pɨyak okok pak ñɨŋan,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Agek, yad pen agnek, ‘Bɨ Kɨb. Mer yɨb! Tari gɨnɨg, ñɨŋan, agɨl ageban? Cɨn Juda bin bɨ tap bɨl gep nɨb okok tap ognap ma ñɨbin yɨb,’ agnek. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Nɨb agenek, mɨnɨm nɨbak kauyaŋ agak, ‘Tap tari tari God tap ñɨŋeb, agɨp okok, bɨl gep, agɨl ma agnɨmɨn,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gak nɨbak, yɨj omal nokɨm gak. Pen kɨsen tap wad kɨb nɨbak adɨk gɨ seb kab ar alaŋ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Pen magɨl nɨbak nep, bɨ omal nokɨm karɨp kɨn mɨdenek ak apjaklak. Bɨ nɨb okok bɨ kɨb Konilias, Sisaria nɨb ag yokek, yɨp poŋ dɨnɨg olak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","God Kaun yɨp agak, ‘Gos par ma nɨŋɨl, kɨrop eip abramek amnɨmɨn,’ agak. Nɨb agek, yad mam Jisas mɨnɨm nɨŋ dɨpal aknɨb kagol oŋɨd dɨl, cɨn bɨ okok eip Konilias karɨp ne ak amnɨnok. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Amjakon, Konilias kesɨm dɨl agak, ‘Ejol alap apɨl yɨp agak, “Bɨ ognap agenɨmɨn, taun kɨb Jopa amɨl, bɨ alap Saimon Pita apal ak nop poŋ dɨ dolaŋ. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Poŋ dɨ dapel, ne nep mɨnɨm ognap ag ñek, bin bɨ karɨp nak eip mɨdebɨm okok, God nɨbep magɨlsek dɨ komɨŋ yokek, bin bɨ ne mɨdenɨgabɨm,” agak,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Konilias yɨp nɨb agek, yad wagɨn gɨl mɨnɨm ag ñen nɨŋlɨg gɨ, Kaun Sɨŋ ne cɨnop ned owak rek, bin bɨ nɨb okok kɨrop ak rek nep owak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nɨg gek, Bɨ Kɨb cɨnop ned agak mɨnɨm ak gos nɨŋnek. Ne agak, ‘Jon kɨrop ñɨg pak ñak ak pen maŋ mɨdeb, God ne nɨbep Kaun Sɨŋ ak pak ñɨnɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pen cɨn Bɨ Kɨb Jisas Krais nop nɨŋ dɨnok ñɨn ak, God tap tep yɨb cɨnop ñak rek, kɨrop ak rek nep ñak. Nɨb ak, yad titi gɨl God nop, ‘Nɨg ma gɨnɨmɨn,’ apnep?” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita nɨb agek, bɨ nop mɨnɨm kal ag gɨlak okok mɨnɨm agak ak nɨŋɨl, mɨnɨm kal ognap sek ma ag gɨlak. God yɨb agel ar amek nɨŋlɨg gɨ aglak, “Cɨnop nep mer; Juda bin bɨ mer okok ak rek nep, tap si tap tɨmel gɨpal ak, tari gɨnɨg nɨg gɨpɨn, agɨl, nop sobok genɨgal ak, ne nɨŋɨl, tap si tap tɨmel gɨpal okok kɨrɨg gɨl, komɨŋ per mɨdep magɨl ak kɨrop ñɨnɨgab,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pen Stipen nop kab ju pak lɨlak ñɨn nab sɨŋak, bɨ Juda Jerusalem mɨdelak okok, bin bɨ Jisas nop nɨŋ dɨlak okok kɨrop gɨ tɨmel yɨb gel, kɨri pɨrɨk gɨ ke ke amnɨlak. Ognap pɨrɨk gɨ karɨp lɨm Pönisia amnɨlak, ognap pɨrɨk gɨ karɨp lɨm ñɨg tɨb kɨs gak airan Saipras amnɨlak, ognap pɨrɨk gɨ taun kɨb Adiok amnɨlak. Amɨl, Jisas mɨnɨm tep ak Juda bin bɨ mer okok kɨrop ma ag ñɨlak, bin bɨ kɨri ke Juda kai ju am nɨb okok mɨdelɨgɨpal okok kɨrop nep ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pen bin bɨ Jisas mɨnɨm tep ak nɨŋ dɨlak ognap Saipras nɨb, ognap Sairini taun nɨb, pɨrɨk gɨ Adiok amɨl, Bɨ Kɨb Jisas mɨnɨm tep ak Juda bin bɨ mer okok kɨrop ag ñɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bɨ Kɨb kɨlɨs ne ak kɨrop eip mɨdek ak me, bin bɨ okok kɨrop Jisas mɨnɨm tep ak ag ñel, bin bɨ koŋai nep Bɨ Kɨb nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pen Jerusalem bin bɨ Jisas nop nɨŋ dɨlak okok, mɨnɨm nɨbak nɨŋɨl, bɨ kɨri Banabas nop agel, Adiok amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas ne Adiok amjakɨl nɨŋak, God ne bin bɨ nɨb okok yɨmɨg nɨŋlɨg gek, Jisas mɨnɨm tep ak nɨŋ dɨlak. Nɨb ak me, ne mɨñ mɨñ gɨl, kɨrop mɨnɨm ognap sek ag ñɨlɨg gɨ agak, “Bɨ Kɨb nop nɨŋ dɨpɨm ak ma kɨrɨg gɨnɨmɨb; nop nokɨm nep cɨbur gos mɨdmagɨl nɨbi nab adaŋ nɨŋ dɨ kɨlɨs gɨl, cɨg gɨlɨg gɨ nep mɨdenɨmɨb,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas ne bɨ tep yɨb. Kaun Sɨŋ ne Banabas apɨl ap ran jakɨl mɨdek. Ne Jisas mɨnɨm tep ak pɨs nep nɨŋ dak. Ne Jisas mɨnɨm tep ak bin bɨ okok ag ñek, bin bɨ koŋai nep Bɨ Kɨb nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas pen bɨ Sol nop am donɨm, agɨl, taun kɨb Tasas amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Banabas Tasas amjakɨl, Sol nop pɨyo nɨŋɨl, poŋ dɨl adɨk gɨ am Adiok amɨl, mɨ nokɨm nɨbak bin bɨ Jisas nop nɨŋ dɨlak okok kɨrop Jisas mɨnɨm tep ak ag ñɨlɨg gɨ mɨderek. Adiok bin bɨ Jisas Krais nop nɨŋ dɨlak okok, ned yɨb ñɨl Krais Bin Bɨ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ñɨn nab nɨb sɨŋak, bɨ God mɨnɨm agep ognap Jerusalem nɨb Adiok amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Amɨl, God Kaun ne bɨ kɨri alap Agabas nop gos ñek agak, “Yuan kɨb yɨb karɨp lɨm magɨlsek lɨnɨg geb,” agak. Agek, agak rek yuan kɨb yɨb ak, gapman bɨ kɨb Klodias kod mɨdolɨgɨp ñɨn ak owak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nɨg gɨl yuan kɨb lak nɨŋɨl Adiok bin bɨ Jisas nop nɨŋ dɨlak okok aglak, “Bin bɨ Jisas mɨnɨm tep ak nɨŋ dɨpal ognap karɨp lɨm Judia okok mɨdel nɨŋlɨg gɨ, kɨrop yuan kɨb yɨb lɨp ak, cɨn nokɨm nokɨm kɨrop mani ognap mogɨm gɨl ñɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nɨb agɨl, mani lɨ mogɨm gɨl, Banabas eip Sol eip kɨrop ñɨl aglak, “Nɨri bɨ omal mani aul damɨl, Krais bin bɨ ne kod mɨdebal bɨ kɨb okok kɨrop ñɨr,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ñɨn nab nɨb sɨŋak, gapman bɨ kɨb Herod, bin bɨ Jisas nɨŋ dɨlak okok ognap kɨrop gɨ tɨmel gɨl, dam mɨñ lak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ami bɨ ne okok ognap agek, Jon nɨmam Jems nop tu par kɨd dɨl pɨs nep ñag pak lel kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herod agek nɨg gelak, Juda bin bɨ okok nɨŋɨl mɨñ mɨñ gɨlak. Mɨñ mɨñ gɨlak ak, Herod nɨŋɨl, Pita nop ak rek nep agek, nop dam mɨñ lɨlak. Gɨlak nɨbak, Juda bin bɨ Bred Yɨs Sek Ma Ñɨŋeb ñɨn nab sɨŋak gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod Pita nop nɨg gɨl dam mɨñ lɨl, ami bɨ aknɨb jɨl pɨs kɨd adaŋ (16) kɨrop nonɨm lɨ yɨgwu par yɨgwu par lɨl agak, “Pɨb nab kɨslɨm eyaŋ bɨ omal omal nop kod tep gɨ mɨdenɨmɨb,” agak. Herod gos ne ak ke nɨŋɨl agak, “Pasopa ñɨn ak ap padɨkek me, kɨsen Pita nop dam bin bɨ mɨdenɨgal nab sɨŋak amɨl mɨnɨm kɨb agnɨgabɨn,” agɨl gos nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita ne nɨg gɨl mɨñ mɨdek nɨŋlɨg gɨ, bin bɨ Jisas nop nɨŋ dɨlak okok Pita nop gos nɨŋlɨg gɨ, kɨlɨs gɨl God nop sobok gɨlɨg gɨ nep mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pen gapman bɨ kɨb Herod Pita nop mɨnɨm kɨb agnɨm, agɨl, nɨŋak ñɨn nɨbak nep kɨslɨm nab eyaŋ, Pita nop sen omal ñon gɨl, ami bɨ omal pɨs kɨd pɨs kɨd nɨŋ mɨdel nɨŋlɨg gɨ, Pita nab eyaŋ kɨnek. Ami bɨ ognap ak rek nep kɨjoŋ wagɨn sɨŋak nɨŋ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pen dai Bɨ Kɨb ejol ne alap warɨk mɨdek nɨŋlɨg gɨ, mab mɨlaŋ rek am mɨñ lep karɨp ñɨlɨk mɨgan ak sɨkɨd amnak. Ejol nɨbak am Pita nop tɨglem pak nɨŋɨl agak, “Kasek jakan!” agak. Agek, Pita warɨkek nɨŋlɨg gɨ, sen nop ñon gɨlak ak wɨsɨbak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ejol Pita nop agak, “Sɨb nag nak ak pog lɨl, tob tɨrɨp nak pɨyak dɨ lan,” agak. Agek, Pita ejol agak rek nep gek, ejol ak agak, “Walɨj par kɨb nak ak yɨmek, yad eip amnɨr,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Agek, walɨj par kɨb ne ak yɨmɨl, karɨp ñɨlɨk mɨgan mɨdek ak kɨrɨg gɨl, ejol ak eip paŋdɨrek. Ejol gak nɨbak, Pita ne ag nɨŋak e, ak nɨgrɨkep nɨŋebin agɨl nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pen ami sɨkop nɨŋ mɨdelak kɨjoŋ wagɨn omal sɨl gɨl, kɨjoŋ kɨlɨs yɨb ain dɨl gɨlak kɨjoŋ söŋ eyaŋ ak ke yɨkek nɨŋlɨg gɨ, mɨs amnɨrek. Amɨl, kanɨb nab okok amlɨg gɨ Pita nɨŋak, ejol ak ma mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nɨg gek nɨŋɨl Pita agak, “Mɨñi nɨŋ rep gɨpin. Ak Bɨ Kɨb nep, ejol ne ak ag yokek, apɨl gapman bɨ kɨb Herod yɨp mɨñ kɨlɨs lɨp ak wɨsɨb yokɨp. Gapman bɨ kɨb Herod abe, Juda bin bɨ okok abe, tap tɨmel yɨp gɨnɨg gesal ak, gɨnɨmel rek ma lɨp,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nɨb agɨl, gos nɨŋ tep gɨl, bɨ nak Jon Mak nonɨm Maria karɨp ak amnak. Karɨp nɨbak bin bɨ koŋai nep apɨl, God nop sobok gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita apɨl, kɨjoŋ ak pak gu gu gek, pai Roda, karɨp nɨbak wög golɨgɨp ak kɨjoŋ ak yɨknɨg owak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pai nɨbak kɨjoŋ apɨl nɨŋak, Pita meg mɨgan ak nep agek. Ne nɨg nɨŋɨl, mɨñ mɨñ yɨb gɨl, saköl padek kɨjoŋ ma yɨkak; am bin bɨ okok kɨrop agak, “Pita ap mɨdeb söŋ eyaŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Agek, kɨri aglak, “Nak saköl losɨp ageban,” aglak. Nɨb agelak, ne kɨlɨs yɨb gɨl agak, “Esek ma apin; nɨŋɨd yɨb agebin. Pita mɨdeb söŋ eyaŋ,” agak. Agek aglak, “Ak kaun ne ak rek lɨp ap mɨdeb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pen Pita ne kɨjoŋ ak kauyaŋ pak gu gu gek gek gek, am kɨjoŋ ak yɨk yokɨl nɨŋlak, Pita nep mɨdek nɨŋɨl wal yɨb aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wal agel nɨŋlɨg gɨ, Pita kɨrop ñɨn mɨlɨc gɨ ñɨl agak, “Mɨnɨm ma agnɨmɨb!” agak. Nɨb agɨl, mɨñ lep karɨp mɨdek nɨŋlɨg gɨ, God ejol alap ag yokek apɨl, nop tari tari gɨl dowak mɨnɨm ak kɨrop ag ñɨlɨg gɨ agak, “Mɨnɨm nɨbaul Jems abe, bin bɨ Jisas nop nɨŋ dɨpal okok abe, kɨrop ag ñɨnɨmɨb,” agɨl, ke mɨgan alap amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mɨnek mɨñab tɨkek nɨŋlɨg gɨ, ami sɨkop okok Pita ma mɨdek ak nɨŋɨl, tari gɨp, agɨl, ag ap ran ap yaplɨg gɨ mɨdelak. Pɨrɨkɨl, “Akal,” agɨl, pɨyolak ak pen ma nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod ami sɨkop nɨb okok kɨrop, Pita nop kasek pɨyo nɨŋɨl dowɨm, agek, pɨyo mer nɨŋel, kɨrop mɨnɨm kɨb agɨl, mɨnɨm agek, ami bɨ ne ognap ami bɨ nɨb okok pɨs nep ñag pak lɨlak. Kɨsen Herod karɨp lɨm Judia kɨrɨg gɨl, am taun kɨb Sisaria mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod am Sisaria mɨdɨl, taun kɨb omal Taia Saidon bin bɨ okok kɨrop nɨŋek mɨlɨk yowak. Pen Taia Saidon bin bɨ apɨl, bɨ Herod karɨp ne kod mɨdek bɨ Blastas nop sɨl ag ñɨl aglak, “Cɨnop per yuan gek, apɨl Herod karɨp lɨm ne aul tap magɨl tau dad ambɨn sek. Nɨb ak, cɨnop kal kal ma junɨmɨb; kapkap jɨm ñɨl mɨdojɨn,” aglak. Agelak, Blastas ne pen agak, “Ak nɨŋɨd agebɨm,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pen Herod mɨnɨm nɨbak nɨŋɨl, ñɨn alap mɨnɨm agnɨgain, agɨl, ag lak. Kɨsen ag lak ñɨn nɨbak apek, ne kiŋ kai yɨmbal rek walɨj tep tep yɨb okok yɨmɨl, sea kiŋ kɨb ne ar ak bɨsɨg gɨl, bin bɨ okok kɨrop mɨnɨm ag ñak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Herod mɨnɨm nɨbak ag ñek nɨŋlɨg gɨ aglak, “Ak bɨ alap rek ma ageb; god alap rek ageb,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pen Herod mɨnɨm nɨbak nɨŋɨl, “Yɨp mɨnɨm nɨbak rek ma agnɨmɨb; God yɨb ne nep agem ar amnaŋ,” ma agak. Nɨb ak, Bɨ Kɨb ejol ne alap ag yokek, apɨl Herod nop gek, mɨñak kɨb gɨl, kɨsoi lek pɨs nep kɨmak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pen God Mɨnɨm ak ag ñel amek nɨŋlɨg gɨ, karɨp lɨm okok kɨd kɨd amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pen Banabas eip Sol eip Jerusalem mɨdɨl, tari gɨnɨg orok ak bɨr gɨpɨr, agɨl, Jon Mak nop poŋ dɨl adɨk gɨ Adiok amnɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Taun kɨb Adiok nɨb sɨŋak bɨ God mɨnɨm agep bɨ ognap abe, bɨ God mɨnɨm ag ñeb bɨ ognap abe mɨdelak. Bɨ nɨb okok me, alap Banabas; alap Simion. Bɨ Simion nɨbak nop Bɨ Kɨñɨr agölɨgɨpal. Bɨ alap Lusias, ne Sairini taun nɨb. Bɨ alap Maneyen, ne Kiŋ Herod bɨ nɨŋeb ne alap. Pen bɨ alap Sol. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pen ñɨn alap kɨri tap magɨl ma ñɨbɨl, Bɨ Kɨb nop nep sobok gɨ mɨdel nɨŋlɨg gɨ, Kaun Sɨŋ ne kɨrop agak, “Nɨbi Banabas eip Sol eip agem, wög kɨrop ag lɨnek ak ger amnɨmɨŋ,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nɨb agek, kɨri tap magɨl ma ñɨbɨl, God nop sobok gɨl, Banabas eip Sol eip kɨrop ñɨnmagɨl ar alaŋ lɨl, God kɨrop mal kod mɨdeŋ, agɨl, kɨrop ag yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Kaun Sɨŋ ne kɨrop kod mɨdek nɨŋlɨg gɨ, bɨ nak Jon Mak, wög cɨrop sɨkol sɨkol ognap gɨ ñaŋ, agɨl, nop poŋ dɨ Selusia taun ñɨg gol eyaŋ amɨl, ñɨg magöb dɨl, karɨp lɨm ñɨg tɨb kɨs gak airan Saipras amnɨlak. Amɨl, taun kɨb Salamis amɨl, Sol eip Banabas eip Juda mogɨm gep karɨp okok amɨl, bin bɨ okok kɨrop God Mɨnɨm ag ñɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pen bin bɨ Saipras mɨdelak nɨb okok kɨrop God Mɨnɨm ag ñɨ dam dam, taun kɨb Pepos amjakɨl, Juda bɨ alap kɨj coge su juep bɨ alap nabɨŋ pakrek. Bɨ nɨbak yɨb ne Ba-Jisas. Ne mɨnɨm esek agɨl agak, “Yad God mɨnɨm agep bɨ alap,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Taun kɨb Pepos sɨŋak, Saipras gapman bɨ kɨb yɨb kɨn mɨdolɨgɨp, yɨb ne Segias Polas. Bɨ nɨbak ne bɨ gos nɨŋ kɨd yɨb yɨkɨl nɨŋolɨgɨp. Ne Banabas eip Sol eip God Mɨnɨm yɨp ager nɨŋin, agɨl, kɨrop agek apɨl, nop God Mɨnɨm ag ñɨrek. Pen bɨ kɨj coge su juep bɨ ak ne bɨ kɨb nɨbak bɨ nɨŋeb ne alap. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bɨ Ba-Jisas nɨbak, Grik mɨnɨm agɨl nop Elimas agölɨgɨpal. Banabas eip Pol eip kɨri Segias Polas nop God Mɨnɨm tep ak ag ñer, ne tɨmɨd lɨ peyɨg nɨŋ tep gak ak pen, bɨ kɨj su juep bɨ ak nɨŋɨl, Banabas Pol mɨnɨm tɨmel ke gɨ agɨl, Segias Polas Jisas mɨnɨm ak ma nɨŋ dɨnɨmɨŋ, agɨl, nop agak, “Bɨ nɨb omal mɨnɨm esek agebir ak ma nɨŋnɨmɨn,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol yɨb ne alap me Pol agölɨgɨpal. Kaun Sɨŋ ne Pol nop ap ran jakɨl gos tep ñek nɨŋlɨg gɨ, bɨ kɨj su juep bɨ ak nop nɨŋ i sek lɨ mɨdlɨg gɨ agak, ");
INSERT INTO kmh_m_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nak kɨjeki kɨyob ñɨlɨk tɨk dowak; gɨ tɨmel nep gɨpan. Tap tari tari tep mɨdeb ak kɨrɨg gɨl, bin bɨ okok kɨrop esek ar ak nep gɨpan. Nak per per Bɨ Kɨb mɨnɨm nɨŋɨd ne ak dɨl mɨnɨm esek rek lɨpan. Nak ñɨn akal gɨ tɨmel gɨpan ak kɨrɨg gɨnɨgan? ");
INSERT INTO kmh_m_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nɨg gɨpan ak, God gek, ñɨn bad alap udɨn nep kwoi gek pɨb melɨk ma nɨŋnɨgan,” agak. Pol mɨnɨm nɨbak agek, dai Ba-Jisas nɨŋak, kɨmi kɨñɨr rek bad alap udɨn ne pak karɨkek pɨs nep kɨslɨm gak. Nɨg gek, bɨ alap yɨp ñɨnmagɨl dɨ kanɨb yomaŋ, agɨl, tɨg rɨrɨkol gɨlɨg gɨ mɨdek. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Banabas Pol kɨri bɨ omal Bɨ Kɨb mɨnɨm ak nop ag ñerek ak nɨŋɨl, Segias Polas ne wal agak. Nɨb ak, Ba-Jisas gak ak nɨŋɨl, ne Jisas nop nɨŋ dak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pen Pol bɨ ne okok eip ñɨg magöb dɨl, Pepos kɨrɨg gɨl, Pega taun, karɨp lɨm Pampilia sɨŋak amnɨlak. Am mɨdɨl, Jon Mak ne kɨrop mal sɨŋak kɨrɨg gɨl, adɨk gɨ Jerusalem amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kɨri pen Pega taun kɨrɨg gɨl, taun kɨb Adiok, karɨp lɨm Pisidia sɨŋak amnɨrek. Am mɨdɨl, Juda God nop sobok gep ñɨn ak, Juda mogɨm gep karɨp ak amɨl, bɨsɨg mɨderek. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Juda mogɨm karɨp kod mɨdelak bɨ okok warɨkɨl, Mosɨs lo mɨnɨm ñu kɨl tɨkak dai ognap abe, bɨ God mɨnɨm agep okok ñu kɨl tɨklak dai ognap abe, udɨn lɨ nɨŋɨl bin bɨ ap mɨdelak okok kɨrop aglak. Kɨri mɨnɨm ag dai juɨl, bɨ alap ag yokel Banabas Pol bɨsɨg mɨderek sɨŋak amɨl agak, “Mam omal. Bin bɨ sɨŋ aul nɨŋ dep mɨnɨm ognap mɨdonɨmɨŋ ak, cɨnop ag ñer nɨŋɨn,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Agelak, Pol warɨkɨl mɨnɨm agnɨg ñɨnmagɨl dap ranɨl agak, “Nɨbi Juda bin bɨ okok abe, Juda bin bɨ mer God nop sobok gɨpɨm okok abe, mɨnɨm agnɨg gebin aul tɨmɨd lɨ nɨŋɨm. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God ne bɨrarɨk nep apɨs based sɨkop cɨn okok dak. God nɨbak ne Isrel bin bɨ God cɨn me. Kɨsen kɨri karɨp lɨm Ijip am mɨdelak, God kɨrop kod mɨd tep gek, ñɨ pai tɨk dapɨl, koŋai yɨb nep mɨdelak. Bɨ kɨb Pero kɨrop, ma amnɨgabɨm, agak ak pen God kɨlɨs ke yɨb ne ak gɨl, kɨrop poŋ dɨ dapek Ijip mɨs ken olak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kɨri mɨ ñɨnjuɨl omal (40) mɨñ mab kab nep mɨdolɨgɨp nab sɨŋak mɨdɨl, God nop mɨnɨm koŋai yɨb nep aiŋeb lɨ agölɨgɨpal ak pen God kɨrop kod mɨd tep gak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pen ned karɨp lɨm Kenan bin bɨ tɨgoŋ ke ke aknɨb ar oŋɨd mɨdelak, pen God bin bɨ ne kɨrop kod mɨd tep gɨl kɨlɨs ne ñek, bin bɨ tɨgoŋ ke ke aknɨb ar oŋɨd ned mɨdelak okok kɨrop eip pen pen gɨl, yɨk gɨ yokɨl ñag pak lɨl, karɨp lɨm nɨbak karɨp lɨm kɨri ke rek dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kɨri Ijip mɨdel mɨ yɨnak ak wök pagɨl, karɨp lɨm eywo nep nab okok mɨdel mɨ yɨnak ak wök pagɨl, bin bɨ yɨk gɨ yokɨl, karɨp lɨm kɨri dɨlak mɨ yɨnak ak abe wök pagɨl gel me, mɨ aknɨb po hadred pipti (450) yɨnak. “Pen God kɨrop dam karɨp lɨm Kenan sɨŋaul lɨl, bɨ mɨnɨm tɨg bɨlokep ognap ag lek, kɨrop kod mɨdelɨgɨpal. Kɨsen bɨ God mɨnɨm agep Samyuel mɨdek ñɨn ak, ");
INSERT INTO kmh_m_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","bin bɨ Isrel okok kɨri Samyuel nop aglak, ‘Nak kiŋ alap ag lek, cɨnop bin bɨ magɨlsek kod mɨdenɨgab,’ aglak. Agelak, God bɨ nak Kis ñɨ ne Sol nop ag lek, kiŋ kɨri mɨdolɨgɨp. Bɨ nɨbak Benjamin kɨgɨn tɨk damɨl tɨk damɨl tɨk lɨlak. Sol kiŋ kɨri mɨdek, mɨ ñɨnjuɨl omal (40) yɨnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pen kɨsen God ne gek Sol kiŋ ma mɨdek. God ne Depid kiŋ kɨri ag lak. God ne Depid mɨnɨm agɨl agak, ‘Cɨbur gos mɨdmagɨl yad ke gos gɨp rek ak, Jesi ñɨ ne Depid cɨbur gos mɨdmagɨl ne abe aknɨb rek nep gos gɨp; tap tari tari gaŋ ag nɨŋnɨgain ak, ne nɨg aknɨb rek nep gɨnɨgab,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Pen God ne gek, Depid ñɨ pai tɨkek, tɨk dam dapɨl gɨl, Jisas nop tɨk dolak. Nɨb ak, God ned mɨnɨm kɨlɨs ag lak rek, ne Isrel bin bɨ kɨrop Dɨ Komɨŋ Yokep Bɨ alap ag yokak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pen Jisas wagɨn gɨl wög ma gak won ak, Jon ne apɨl, Isrel bin bɨ kɨrop agak, ‘Tap si tap tɨmel gɨpɨm ak, tari gɨnɨg nɨg gɨpɨn, agɨl, kɨrɨg gem, nɨbep ñɨg pak ñɨnɨgain,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon wög ne gɨ dai junɨg gek ñɨn nab ak, bin bɨ okok kɨrop agak, ‘Nɨbi yɨp bɨ an, agɨl, gos nɨŋebɨm? Bɨ Kɨb per kod mɨdebɨm bɨ ak yad mer. Bɨ nɨbak kɨsen onɨgab. Tob tɨrɨp ne ak dɨ nag wɨsɨbnɨm rek ma lɨp,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ai mam yad, nɨbi ognap Ebraham ñɨ pai ne mɨdebɨm; nɨbi ognap Juda bin bɨ mer pen God nop sobok gɨpɨm. Krais bin bɨ dɨ komɨŋ yokep mɨnɨm Jon ag ñɨ mɨdolɨgɨp nɨbak, God ne cɨnop nen agɨl agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem bin bɨ okok abe, bɨ kɨb kɨri okok abe, Jisas ne Krais ak owɨp, agɨl ma nɨŋlak. Jisas nop ñag pak lel kɨmaŋ, aglak ak, God mɨnɨm agep mɨnɨm ñu kɨl tɨklak rek nep gɨlak. Pen God nop sobok gɨnɨg Juda mogɨm gep karɨp per apelɨgɨpal ak, kɨri mɨnɨm ñu kɨl tɨklak nɨbak per per nep nɨŋölɨgɨpal. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ne tap tɨmel alap gɨp aka agɨl, pɨyo mer nɨŋɨl, gapman bɨ kɨb Pailot nop aglak, ‘Nak agek nop ñag pak lɨlaŋ,’ aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pen God Mɨnɨm agak rek, magɨlsek nep Jisas nop gɨlak. Kɨsen bin bɨ ne okok apɨl, cɨp se tɨg asɨk dam kab mɨgan tɨgel gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tɨgel gɨlak ak pen God gek kauyaŋ warɨkak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne warɨkɨl, komɨŋ mɨdek nɨŋlɨg gɨ, bin bɨ ne eip Galili nɨb Jerusalem olak okok, nop ñɨn koŋai nep nɨŋ mɨdelak rek, mɨñi Isrel bin bɨ kɨrop Jisas mɨnɨm tep ak ag ñebal. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Pen cɨr bɨ omal opɨr aul, nɨbep Krais mɨnɨm tep ak ag ñɨnɨg opɨr. God bɨrarɨk nep apɨs based sɨkop cɨn kɨrop mɨnɨm kɨlɨs ag lɨl gɨnɨgain agak mɨnɨm nɨbak nep ");
INSERT INTO kmh_m_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","gos nɨŋ mɨdɨl, God ne Jisas nop dɨ warɨk ñak. Gak nɨbak apɨs based sɨkop okok ma nɨŋlak ak pen cɨn ñɨ pai tɨk lep kɨri okok mɨñi bɨr nɨpɨn. Depid ne God Mɨnɨm dai Sam sɨŋak Kɨmep yɨgwu nab nɨb ñu kɨl tɨkɨl agak, ‘Nak Ñɨ yad. Yad mɨñi Nap nak mɨdebin,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God ne gek, Jisas warɨkak ak me, kɨsen kɨmɨl, mɨb goŋ ki gɨ yap lɨg pak amnɨmɨŋ rek ma lɨp. Mɨnɨm nɨbak God Mɨnɨm dai alap nɨbgɨl mɨdeb: ‘Yad Depid nop mɨnɨm sɨŋ kɨlɨs nɨŋɨd ag lɨnek ak nɨbep nep ñɨnɨgain,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pen God Mɨnɨm dai alap nɨbgɨl mɨdeb: “‘Nak Bɨ Sɨŋ nak kɨrɨg gek, mɨb goŋ ne ki gɨ yap lɨg pak ma amnɨmɨŋ,’ agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Pen Depid ne God wög nop ag lak ak, bin bɨ ne mɨdelɨgɨpal ñɨn nɨbak gɨ damɨl kɨmak. Pen Depid ne kɨmek, nap nɨsed sɨkop kɨrop tɨgel gölɨgɨpal okok dam tɨgel gel, mɨb goŋ ne ki gɨ yap lɨg amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pen God ne gek warɨkak Bɨ nɨbak, mɨb goŋ ne ki gɨ yap lɨg ma amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Nɨb ak, mɨdemam nɨŋɨm. Jisas ne kɨmɨl warɨkak ak me, God tap si tap tɨmel gɨpɨm ak nɨŋɨl kɨrɨg gɨnɨgab mɨnɨm tep ak nɨbep ag ñobɨr. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Cɨn Juda lo mɨnɨm ar ak nep nɨŋɨl genɨgabɨn ak, God tap si tap tɨmel gɨpɨn ak nɨŋ nep mɨdenɨgab. Pen Jisas mab bak alaŋ ñag pak lel kɨmak ak me, cɨn Jisas nop nɨŋ donɨgabɨn ak, God tap si tap tɨmel gɨpɨn ak nɨŋɨl, kɨrɨg gɨl, cɨnop bin bɨ tep yad, agnɨgab. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pen bɨ God mɨnɨm agep okok bɨrarɨk nep aglak rek cɨnop ma gɨnɨmɨŋ, agɨl gos ak nɨŋ rep gɨnɨmɨb. Kɨri aglak, ");
INSERT INTO kmh_m_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nɨbi bin bɨ yɨp aleb aleb ñɨbɨm okok nɨŋɨm! Nɨbi mɨdebɨm magɨl aul, tap ke nɨb alap gɨnɨgain. Tap gɨnɨgain nɨbak nɨbep ned agenɨgal ak, ñɨñɨloŋ lɨ agebal, ag gos nɨŋnɨgabɨm. Nɨb ak, nɨbi pak jep jep dɨl pɨs nep kɨm kɨr gɨnɨmɨb!’ aglak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol eip Banabas eip mɨnɨm nɨbak agɨl, Juda mogɨm gep karɨp nɨbak mɨs amer nɨŋlɨg gɨ, bin bɨ okok aglak, “God nop sobok gep ñɨn kɨsen ak kauyaŋ apɨl, cɨnop mɨnɨm nɨbak ognap sek ag ñɨr,” aglak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bin bɨ okok mogɨm gɨ mɨdelak okok karɨp ak kɨrɨg gɨl, ke ke amel nɨŋlɨg gɨ, Juda bin bɨ yɨpɨd gɨl ognap abe, bin bɨ okok nɨb Juda kai nɨŋ dölɨgɨpal rek nɨŋ dɨlak ognap abe, Pol eip Banabas eip kɨrop kɨsen gɨl amnɨlak. Pol Banabas kanɨb nab sɨŋak amlɨg gɨ kɨrop agrek, “‘God cɨnop yɨmɨg nɨŋɨl dɨ tep gɨp,’ agɨl, gos ar nɨbak nep nɨŋlɨg gɨ mɨdenɨmɨb,” agrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pen Juda God nop sobok gep ñɨn kɨsen ak, bin bɨ taun kɨb nɨbak mɨdelak okok magɨlsek rek, Bɨ Kɨb mɨnɨm nɨŋnɨg ap mogɨm gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pen Juda bɨ kɨb okok bin bɨ koŋai sɨkerek olak ak nɨŋel, mɨlɨk yapek, Pol Banabas kɨrop bɨ omal nɨŋɨl gos tɨmel nɨŋlak. Pol mɨnɨm tari tari bin bɨ okok kɨrop agak ak ag juɨl, yɨb ne ak ag sɨkol gɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Juda bɨ okok nɨg gelak, Pol eip Banabas eip ma pɨrɨkɨl, mɨnɨm pen kɨlɨs gɨl agrek, “God Mɨnɨm tep ak nɨbep Juda bin bɨ ned ag ñɨr, apɨr ak pen nɨbi mɨnɨm tep nɨbak ma dɨl, cɨn komɨŋ per mɨdep magɨl ak nɨŋ dɨjɨn rek ma lɨp, apɨm ak me, mɨñi Juda bin bɨ mer okok kɨrop ag ñɨnɨgabɨr. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tari gɨnɨg: Bɨ Kɨb cɨnop agɨl mɨnɨm nɨg gɨl agak, ‘Yad agen, nɨbi Juda bin bɨ mer okok kɨrop melɨk kɨri mɨdɨl, karɨp lɨm ke ke okok amenɨgabɨm, bin bɨ okok magɨlsek melɨk nɨbak nɨŋel nɨŋlɨg gɨ, yad kɨrop dɨ komɨŋ yoknɨgain,’ agak,” agak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Juda bin bɨ mer okok mɨnɨm nɨbak nɨŋɨl, mɨñ mɨñ gɨl, Bɨ Kɨb mɨnɨm ak, mɨnɨm tep aknɨb ke yɨb, aglak. Nɨb ak, bin bɨ God, per per mɨdenɨmel, agɨl, ag lak okok magɨlsek mɨnɨm tep nɨbak nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pen Bɨ Kɨb mɨnɨm ak, karɨp lɨm nɨb okok magɨlsek agel amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nɨg gak ak, Juda bin bɨ okok nɨŋel mɨlɨk yapek, amɨl Adiok bin pobɨŋ God nop nɨŋ dɨlak ognap abe, bɨ pobɨŋ karɨp lɨm nɨbak kod mɨdelɨgɨpal okok ognap abe, kɨrop agel, kɨri amɨl bin bɨ koŋai nep dapɨl, Pol eip Banabas eip kɨrop gɨ tɨmel gɨl, karɨp lɨm kɨri okok ag mɨs yoklak. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nɨg gɨl ag mɨs yokel, bɨ omal kɨri Adiok kɨrɨg amlɨg gɨ, mɨnɨm tep dam ag ñosɨr ma dɨpɨm, agɨl, tob kɨri acɨp acɨp okok lɨg gɨ yokɨl amɨl, taun kɨb Aikoniam amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pen Kaun Sɨŋ ne bin bɨ Jisas nop nɨŋ dɨlak okok ap ran jakek, kɨri mɨñ mɨñ yɨb gɨlɨg gɨ mɨdelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol eip Banabas eip am taun kɨb Aikoniam kɨn mɨdɨl, Juda mogɨm gep karɨp ak amɨl, mɨnɨm ag ñɨ tep ger nɨŋlɨg gɨ, Juda bin bɨ okok lɨl, Juda bin bɨ mer okok lɨl, koŋai nep Jisas nop nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pen Juda bin bɨ ognap, Jisas mɨnɨm agebir ak ma nɨŋ dɨnɨgabɨn, agɨl, amɨl Juda bin bɨ mer okok kɨrop mɨnɨm nɨŋep ma nɨŋep tom agelak nɨŋɨl kɨri bin bɨ Jisas nɨŋ dɨlak okok kɨrop nɨŋel mɨlɨk kal yowak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pen Pol eip Banabas eip, mɨnɨm nɨbak nɨŋɨl, karɨp lɨm nɨbak ma kɨrɨg amnɨrek. Kɨri sɨŋak nep kɨn mɨdɨl, Bɨ Kɨb mɨnɨm ak kɨlɨs gɨl mɨseŋ nep ag ñölɨgɨpir. Bɨ Kɨb kɨrop mal eip kod mɨdek nɨŋlɨg gɨ, tap ma gep rek ognap, tap nɨŋep ma nɨŋep rek ognap gerek, bin bɨ ognap nɨŋɨl aglak, “Nɨb ak, mɨnɨm agebir nɨbaul nɨŋɨd nep agebir,” agɨl nɨŋlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pen Aikoniam bin bɨ nɨb okok asɨk ke ke lɨl, pɨs ak Juda bin bɨ okok mɨnɨm aglak rek nɨŋ dɨlak, pɨs ak bɨ Jisas mɨnɨm dad ameb okok aglak rek nɨŋ dɨlak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pen Juda bin bɨ ognap okok lɨl, Juda bin bɨ mer ognap okok lɨl, bɨ pobɨŋ kɨri okok abe, Pol eip Banabas eip kɨrop gɨ tɨmel gɨl, kab ju pak lɨn, agɨl, gos ak nɨŋelak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kɨri mal pen mɨnɨm nɨbak nɨŋɨl, pɨrɨk gɨ am taun kɨb omal Listra Debi, karɨp lɨm Likonia sɨŋak amnɨrek. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Amɨl, nɨb okok gɨ ajlɨg gɨ, Krais mɨnɨm tep ak ag ñölɨgɨpir. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pen taun kɨb Listra nɨbak, bɨ alap nonɨm nop tɨk dowak ñɨn ak nep tob tɨmel gek, kanɨb ma tagolɨgɨp bɨ alap mɨdolɨgɨp. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Bɨ nɨbak ne ap bɨsɨg mɨdɨl, Pol mɨnɨm agek ak nɨŋ mɨdek. Pol bɨ nɨbak nop nɨŋ i sek lɨl gos nɨŋak, bɨ nɨbaul, God yɨp gek komɨŋ lɨnɨmɨŋ rek lɨp, ag gos nɨŋeb, agɨl gos nɨŋak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nɨb ak, Pol nop nɨŋɨl, meg mɨgan dap ranɨl agak, “Warɨkan!” agak. Agek, bɨ nɨbak kasek warɨkɨl, tob taulɨg gɨ amnak. ");
INSERT INTO kmh_m_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pol nɨg gek, 