﻿USE sofia;
DROP TABLE IF EXISTS sofia.kmg_vpl;
CREATE TABLE kmg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kmg_vpl WRITE;
INSERT INTO kmg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ŋic bocjaha jaŋe ŋondeŋ-nâŋecko wiac fârine fuawec irec binaŋ birickerâ qâreŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jaŋe binaŋ i mitiŋiczi bapa fuŋfuŋ juhuc wiac fuŋgâtânehec hone manac eku banârembiŋ irec sâcko qâreŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eme noni iŋuc jaha fuŋnaonecteaŋ wiac fua warewec irec aimuŋ mu ikisiŋ ehuc manaku mana-fârerâ Teofilo ŋicbomboŋ-nane gore ninic qâninic qâreŋkekopac. ");
INSERT INTO kmg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Eme i wosehuc šiŋuc mana tarazemec: Dâŋ binaŋ egarekicne i fârine jâmbâŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodezi Judia mâreŋte ŋicwofuŋ juwec, dameŋ ira taha bapa moc juwec šâŋene Zakaria, e Abia ere gie birionec. Ŋonâŋ-ticne Elisabete e Aroŋte tucne tofane. ");
INSERT INTO kmg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jahe Anuture maio bahac fâsâc juhuc sâcmutâc dâŋticne aiakic jaha reŋke-fârehuc jupic. ");
INSERT INTO kmg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eme Elisabete hufiŋ juwecte jahe ɋâric tâmiric juku ŋic ŋokac qizec epic. ");
INSERT INTO kmg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Eme Zakaria juwec ŋic biri i jaŋe taha ufuŋko bâzi ririke gie baniŋte dameŋ-jeŋic maickeme ");
INSERT INTO kmg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","fisirâ gie-jeŋic ru sâc ehuc Zakaria hosâc bâzi rikeocte mucnepie taha ufuŋ maŋnao rašiwec. ");
INSERT INTO kmg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Raširâ hosâc bâzi rikehame ŋic ŋokac omane jaŋe sapamaŋko Wofuŋ numecnehec jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ehame Wofuŋte aŋelozi fuarâ hosâc bâzi ririke alata ŋifecnao fâreopec domawec. ");
INSERT INTO kmg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Domame Zakariazi honerâ fâfârerâ hemâtâckewec. ");
INSERT INTO kmg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iŋuc eme aŋelozi šiŋuc âzâcnewec: “Zakaria, go mi hâwicguoc, Wofuŋzi nunumuge manawecte ŋonâŋge Elisabete motec kiweckerâ roocmu, ere šâŋe Johane muzemec. ");
INSERT INTO kmg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Go šeri ehuc bubiaŋ manacmu, â ŋic bocjahazi fufua-ticnere aŋac-jopaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","E Wofuŋte maio kâcɋene erâ juocmu; â waiŋ me opâ momori irec sowa juocmu. Erâ e neŋgoc bumaŋko fohame Tiri Mârozi maŋticne bâfuseocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eme Israe ŋic boc jaha bârisiec-jopame Wofuŋ Anutu-jeŋic maickeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elia maŋšoɋac â tâpiri focnewec sâc focneha Wofuŋte biŋedâŋ mumuŋic erâ juocmu. Ehuc kâcɋene jaŋere maŋ bârisieme ɋiene jaŋerao iticneocmu, â râŋgeŋne jaŋe ejareme tiŋne jaŋere mamana birire hazec râeniŋmu. Eme ŋic jaŋe mâmâc sâko Wofuŋte šawierâ juniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aŋelozi iŋuc mume manarâ Zakariazi dâŋ šiŋuc bârisiecnewec: “No â ŋonâŋ-nane nâhe ŋic ŋokac qizec, irec dâŋge wemocko manape fârine eocmu?” ");
INSERT INTO kmg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mume aŋelozi šiŋuc âzâcnewec: “Manakic, šâŋe-nane Gabirie, no Anuture maio domaekopac. Eki sorecnume waharâ biŋedâŋ biaŋ gazakopac. ");
INSERT INTO kmg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Irec manac, dâŋnane mi mana šakiekomec irec okacne nâŋguŋ erâ dâŋ tâmiric juhaŋtec dâŋ gazakopac fârinehec eocmu. Dâŋ mukopac i racne mi eocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zakaria e ufuŋko boc jume ŋic ŋokac woŋec-ticne ŋeku manafecne manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iŋuc ehapie šâhec jaŋerao waharâ dâŋ jazaocte eipiewec. Eipieme jaŋe šiŋuc manambiŋ: E taha ufuŋko wiac šâŋe furu moc honejec. Eme eki mezi sâsâc sawa ejarewec, dâŋ ine wemocko jazazac. ");
INSERT INTO kmg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iŋuczi iŋuc juhame gie bapa dameŋ-ticne tarame haeo risie rawec. ");
INSERT INTO kmg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Eme šâhecko ŋonâŋ-ticne motec kiweckewec. Erâ mosa 5 soŋke soŋke juwec. Ehuc šiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wofuŋ e dameŋ bawec i maickeme ehâmo-narerâ mimi bâsuec enarewec.” ");
INSERT INTO kmg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mosa 6 tarame Wofuŋzi aŋelo Gabirie soreme Galilaia mâreŋko Nazarete haeo rawec. ");
INSERT INTO kmg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ira naru ŋokac moc juwec šâŋene Maria, e ŋic moc Dawidire oso gitecne, šâŋene Josefe, ere biŋe mukicne. ");
INSERT INTO kmg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eme aŋelo e Mariarao fuarâ muwec, “Wofuŋte joroc biaŋ, go šeri ec, Wofuŋzi gohec jukac.” ");
INSERT INTO kmg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aŋelozi dâŋ iŋuc mume maname quŋkeme maŋnezi šiŋuc manasuwec: Weniŋucte mu šeri enarekac? ");
INSERT INTO kmg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eme aŋelozi šiŋuc âzâcnewec: “Maria go mi hâwicguoc, Anutuzi honecgume biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Manakic, go motec kiweckerâ rocmu, ere šâŋe Jesu muzemec. ");
INSERT INTO kmg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E kâcɋene jâmbâŋ jume Fekicne sâko ere Ŋokâ mucneniŋmu, â Wofuŋ Anutuzi apa-ticne Dawidi ere ŋeŋetacko râeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eme Jakobore ɋâricfâc guriŋne bajarehuc jume ŋicwofuŋ juju-ticne forašihuc juocmu sanaŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mume Mariazi šiŋuc âzâcnewec: “No ŋic tâmiric jukopacko dâŋ mukic i weniŋuc erâ sanaŋkeocmu?” ");
INSERT INTO kmg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mume aŋelozi dâŋ šiŋuc bâtikiecnewec: “Tiri Mârozi faigao wahaocmu â Fekicne sâko ere tâpirizi neŋgoc ŋesiŋ ŋegareocmu. Eme irec motec rocmu e tiri mucnezo, Anuture Ŋokâ hâcne. ");
INSERT INTO kmg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Erâ moc gazape manac: Âgoge Elisabete e ŋokac qizeczi motec kiweckerâ juhame mosa 6 ekac, e hufiŋ ŋokac mucneeŋgopieŋzi iŋuc ekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutu e wiac moc ezomurâ mi eipieekac.” ");
INSERT INTO kmg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mume Mariazi šiŋuc âzâcnewec: “No Wofuŋte kiŋaŋ naru, irec dâŋ mukic iŋuc hâcne enarezejec.” Iŋuc mume aŋelozi beherâ rawec. ");
INSERT INTO kmg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria e jume mi šoraha biac šawierâ Judaia tiki mâreŋko hae moc ŋewec ira rawec. ");
INSERT INTO kmg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ra fisirâ Zakariare ficko ferâ Elisabete mu šeri ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mu šeri ecneme manahame izia bumaŋnao motec e kiwaewec. Eme Tiri Mârozi Elisabete ere maŋko hurâ fuseme ");
INSERT INTO kmg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","dâŋ bafehuc šiŋuc âzâcnewec: “Ŋokac âgo-nâŋec gore manape sâc moc eme mumbiaŋgukopac â bumaŋgao fuajec fokac e wâc iŋuc jaha mumbiaŋkekopac. ");
INSERT INTO kmg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Go Wofuŋ-nanere neŋgoczi wemo biaŋ-nanere norao warekomec? ");
INSERT INTO kmg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mu šeri enaretec hazec-naneo hume bumaŋ-naneo moteczi kiwaekac. ");
INSERT INTO kmg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Go Wofuŋte biŋedâŋ gazakicne irec fârine fuaocmu manapaŋkemeŋte gore manape šerine ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eme Mariazi kecšiŋuc muwec: “No maŋ qâqâtâc-nanezi Wofuŋ muafeckekopac, ");
INSERT INTO kmg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","â maŋnanezi Anutu bâbâpiaŋ-nane šeri ecnekopac. ");
INSERT INTO kmg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","E kiŋaŋ naru-ticne waha qaqane no bafecnukacte ŋic gurune gurune nore manapie šerine eocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","E bapafârezi norao mâsi sâko bakac hâcne. Ʒâŋe biŋe-ticne tiri jaha fokac. ");
INSERT INTO kmg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Araŋ bacneeŋgopieŋ jaŋe maŋuruc-ticnere erâ mimiŋzi ɋâric ehâmo-jareekac. ");
INSERT INTO kmg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E tâpiri-ticnere fuŋne bâfuahuc maŋfefe jueŋgopieŋ jaŋe bâtâtiec-jopaekac. ");
INSERT INTO kmg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","E ŋicbomboŋ sâko jaŋe popoonec tuŋjopame wahahapie hujukicne jaŋe bafec-joparâ toŋko râec-jopakac. ");
INSERT INTO kmg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E roroc hapetac jaŋe wiac bâmâckehuc jare gumec ekac, â mafa sâkohec behec-jopame qarâ suriŋne juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Erâ Israe kiŋaŋ ŋicfâc-ticne maŋuru-ticnere roroŋ fâre-nârekac. ");
INSERT INTO kmg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Mimiŋnefâc-nâŋec, Abraham â ɋâricfâcne, jurahuc juniŋmu, jaŋe dâŋ jazawec irec fârine fuakac.” ");
INSERT INTO kmg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Eme Maria e mosa jahec â moc Elisabetehec juku hae-ticnao risie rawec. ");
INSERT INTO kmg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabete e dameŋ-ticne maickeme motec rowec. ");
INSERT INTO kmg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eme haefâc-ticne â mame sâkofâc-ticne jaŋe Wofuŋzi maŋuruc-ticnere fuŋne erao bataniŋkewecte manarâ ehec mâmâc bubiaŋ manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Izi šoaŋ gie bapa 8 tarame jaŋe tumaŋnerâ motec sahacnao Wofuŋte ma barâ mamac-ticne Zakaria ere wase bazo mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Eme neŋgoc-ticnezi qatara-jarerâ muwec, “Aricne, šâŋene Johane muzo.” ");
INSERT INTO kmg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mume šiŋuc âzâcnembiŋ: “Hâc, mame sâkofâcge jaŋerao šâŋe wase iŋucne moc mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Qaqatarac erâ Zakaria e motecte šâŋe muocte ecnepie ");
INSERT INTO kmg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tafere ejareme râcnepie fainao šiŋuc qâreŋkewec: “Ʒâŋe-ticne Johane.” Iŋuc qâreŋkeme jaŋe manapie moc eha ");
INSERT INTO kmg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","izia nameŋne risieme dâŋ dâŋ ehuc Anutu muteŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eme hae rârec rârec ŋic jurambiŋ jaŋe dâŋ binaŋ i manapie hâhâwicne ewec. Eme Judaia tiki mâreŋko binaŋ miczi mic nazaŋ gazaŋ efârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Eme manambiŋ jaŋe dâŋ i maŋke juhuc šiŋuc mumbiŋ: “Motec iŋucnezi sokarâ weniŋuc eocmu?” Eme Wofuŋzi dopecke sapec ecneha juwec. ");
INSERT INTO kmg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eme mamac-ticne Zakaria e Tiri Mârozi maŋne fusucmame findaŋdâŋ kecšiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israe ŋic nâŋâc Wofuŋ-nâŋec Anutu muteŋkenaŋ. Eki hâcne ŋicfâc-ticne iqic-nâporâ kitâc-nâpokac. ");
INSERT INTO kmg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ehuc kiŋaŋŋic-ticne Dawidi ere ɋâricfâc nâŋâcnao bâbâpiaŋte wâtuŋ moc âkendâŋnekac. ");
INSERT INTO kmg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mârâc jaha porofetefâc-ticne ejareme findaŋdâŋ mujumbieŋ sâc iŋuc hâcne fuakac. ");
INSERT INTO kmg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Eki kisâ enârehuc qaisoc-nâpoeŋgopieŋ jaŋeraonec hâcne batarac-nâpoocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mimiŋnefâc-nâŋec jaŋehec tiri šâšâfic sanaŋ ewecte manasuc-jopahuc maŋuruc-ticnere iŋuc enâreocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Apa-nâŋec Abraham mupaŋkecnewecte ");
INSERT INTO kmg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","râsifâc-nâŋec jaŋeraonec batarac-nâpoocmu hâcne. Iŋuc enâreme âke mâteŋ-nâpoha ");
INSERT INTO kmg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","maŋfuru â bahac fâsâc juhuc kiŋaŋ qacnehuc juku hâmonšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Erâ motec go hâcne Femicne sâko ere porofete erâ jucmu. ehuc Wofuŋte biŋe muhuc hata bâšâwecnecmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Erâ ŋicfâc-ticne bâbâpiaŋte dâŋ jaza qazuc etecne mana šakiepie sâqocne-jeŋic tâmireocmu. ");
INSERT INTO kmg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutu-nâŋec e maŋuruc-ticne kâcɋene sâko fokacte mume faickonec furic râehuc ");
INSERT INTO kmg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","dapâcko â hâmoc uupicko ŋeŋene nâŋâc bataniŋ-nâpokac. Ehame wamare hata fuame honehuc sâcne âtenaŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eme motec e sahaczi â maŋzi soka sanaŋ ewec. Erâ mâreŋ tuhuo juhame gie dameŋ-ticne maickeme Israe ŋic janerao fua tâcnewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dameŋ ira Roma ŋicwofuŋ sâko Augusto ere micdâŋ kecšiŋuc fuawec: ŋic mâreŋ sâc wose qâreŋ ejarezo. ");
INSERT INTO kmg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Gie iŋucne mârâc mi bakicne, i Qirinio e Siria mâreŋko kia sâko juhame furune fuŋkekicne. ");
INSERT INTO kmg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eme ŋic mâmâc sasawa wose qâreŋ ejareniŋte haefuŋ-jeŋic sâc rafârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Rahapie Josefe e Dawidire ɋâric Galilaia mâreŋko Nasarete haeo juweczi iŋuc jaha Judaia mâreŋko Dawidire haefuŋ Betelehem ira rawec. ");
INSERT INTO kmg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ehuc ŋokac biŋe-ticne Maria ehec mâmâc qâreŋ-jofaniŋte kiwechec jowame rapic. ");
INSERT INTO kmg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Fisirâ juhapire Maria motec roro dameŋ-ticne maickewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Eme mârâc motec-ticne rorâ qoruczi foŋkerâ bulimakao otoo râeme hurâ fowec. Ŋic jaŋe tomafic fusucmambiŋte ŋeŋe fofo basarâ bulimakao ficko ferâ ŋepic hâcne. ");
INSERT INTO kmg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eme hae mâreŋ ijaha ŋic tucne jaŋe ŋafe ira kecɋaŋ gieo lama jaŋere soŋaŋ ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ŋehapie Wofuŋte aŋelo moczi jaŋerao fuame Wofuŋte oŋararaczi batamaec-jopame mâretec hâwic-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eme aŋelozi šiŋuc jazawec: “Ŋoŋe mi hâwic-ŋopaoc, manaŋgopieŋ, no aŋac šeridâŋ bajukopac, irec fârine ŋic mâmâc sasawa fua-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Miŋecgac Bâbâpiaŋ rune Wofuŋ Kristo hâcne, Dawidire haefuŋko fua-ŋarekac. ");
INSERT INTO kmg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eme mutâcne-ŋarepe mananiŋ: Ŋoŋe motec geune jâmbâŋ qoruczi foŋkekicne bulimakao otoo foha ra bâfuaniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dâŋ iŋuc muhame izia sambâŋ momori gurune fufusuc jaha ututuŋ aŋelo âgo-jeŋictao tumaŋnerâ šiŋuc muhuc Anutu muteŋkembiŋ: ");
INSERT INTO kmg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ʒeri mumuteŋ Anutu faic sambâŋko, mâreŋko ŋic âgo jauŋ ejarekac jaŋerao wama fuakac.” ");
INSERT INTO kmg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aŋelo jaŋe sambâŋko risie fepie soŋaŋŋic jaŋe šiŋuc muhuc nazaŋ gazaŋ embiŋ: “Nâŋâc Betelehem haeo ferâ Wofuŋzi dâŋ nâzâkac irec fârine honenaŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iŋuc murâ bâruŋ jaha ferâ Maria â Josefe bâfuac-jofarâ motec geune bulimakao otoo fohame honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Honerâ motecte dâŋ biŋe manambiŋ i mufuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Eme soŋaŋ jaŋere mickonec binaŋ manambiŋ jaŋe warecke-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria eki ine dâŋ i maŋkerâ manatâc qâtâc ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eme soŋaŋ jaŋe risierâ wiac hone manac embiŋ sâc manasurâ Anutu daŋge mumuteŋ ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesu motec fuarâ fohame šoaŋ gie bapa 8 eme motec sahacnao Wofuŋte ma bahuc šâŋene Jesu mumbiŋ. Ʒâŋe i motec e mi fuahame aŋelozi qanaŋ mufuawec. ");
INSERT INTO kmg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Eme Mosere sâcmutâc dâŋ fowec, i reŋkehuc Mariazi bâtâcko juku sahac herâ Josefehec motec Jerusalem haeo baferâ Wofuŋte biŋe qapic. ");
INSERT INTO kmg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wofuŋte sâcmutâc dâŋ kecšiŋuc fowec i hâcne sâsehuc epic: “Mârâc motec fuapie i Wofuŋte biŋe qafârezo.” ");
INSERT INTO kmg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Erâ Wofuŋte sâcmutâc dâŋko hapâ jajahec me buni jajahec bâzi ririkere mukicne i wâc barâ rapic. ");
INSERT INTO kmg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalem haeo ŋic moc juwec šâŋene Simeoŋ. E tiŋne â mitihec juhuc Israe ŋic jaŋerao bâbâmiriŋ fuaocte woŋec juwec. Ehame Tiri Mârozi maŋticnao ŋeŋe juju ehuc ");
INSERT INTO kmg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","dâŋ šiŋuc mufuacnewec: “Go mi hâmohaŋtecne Wofuŋ Kristo fuame honecmu.” ");
INSERT INTO kmg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ŋic e Mârozi ecneme taha ufuŋko fewec. Eme Maria â Josefe jahe sâcmutâc dâŋ reŋkehuc Jesu motec ijaha bafepire ");
INSERT INTO kmg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoŋzi motec hâporâ šiŋuc muhuc Anutu muafeckewec: ");
INSERT INTO kmg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Wofuŋ sâko, šine hâcne šâŋe fâri-nanezi goraonec bâbâpiaŋ honekopacte ");
INSERT INTO kmg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","go kiŋaŋŋicge no micdâŋgere sâcko râecnutec bumâteŋ fuaha rakopac. ");
INSERT INTO kmg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Go bâbâpiaŋ i mâreŋ sâc ŋicne ŋicne jaŋe honeniŋte bâfuakomec. ");
INSERT INTO kmg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Izi qâpuc jaŋere maŋ âke tamaekac â Israe ŋicfâcge jaŋere šâŋe biŋe bafaharekac.” ");
INSERT INTO kmg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Motecte dâŋ iŋuc mume neŋgoc mamac jahecne manapire bipinehec ewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eme Simeoŋzi jambuŋ-jopahuc motec neŋgoc-ticne Maria šiŋuc âzâcnewec: “Manakic, motec kecši erao Israe ŋic fâuckeniŋte mukicne, gâcne jaŋe erao hetakirerâ rândiŋke qa eniŋmu â gâcne jaŋe erao hesiŋnerâ fahareniŋmu, erâ aka-jeŋic râekicnere ro waha âte boc ecneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Erâ gahacne wâc šikare busâqoc hâtânezi buheric bâfua-garezokac. Waic iŋucne fuame ŋic bocjaha maŋjeŋicte fuŋne taniŋkeocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Eme miti ŋokac moc juwec šâŋene Hana. E Fanuere otâ, Ase ere tucne tofane. Naru-ticnao ŋic barâ ehec juhame jara 7 eme hâmome ");
INSERT INTO kmg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","hozec erâ jufeku jara 84 bazurâ ŋokac qizec jâmbâŋ ewec. Ŋokac eki hâcne taha ufuŋko hati jurâ ju ehuc Anuture erâ sowa â nunumu gie bajujec. ");
INSERT INTO kmg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Eme eki hâcne dameŋ ijaha taha ufuŋko fisirâ Anutu mumbiaŋkewec, â Jerusalem rune jaŋere fifirue dameŋte woŋec jumbiŋ, jaŋe Jesu motecte biŋedâŋ jazawec. ");
INSERT INTO kmg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maria â Josefe jahe Wofuŋte sâcmutâc dâŋ mukicne i efârerâ Galilaia mâreŋko Nazarete haeo risie rapic. ");
INSERT INTO kmg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ira juhapire motec e Anutuzi hone jauŋ ecneha soka sanaŋ ehuc mamana sâkohec ewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Maria â Josefe jahe jara sâc aakic hombaŋte Jerusalem haeo fejupirec. ");
INSERT INTO kmg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ehame Jesu motec jara-ticne 12 bazume hombaŋte fefe dameŋ-jeŋic maickeme jowapire mâmâc fembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ferâ juhapie hombaŋ tarame Maria â Josefe jahe Jesu motec hetarapire Jerusalem haeo juhame buc risiepic. ");
INSERT INTO kmg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Risiehuc guru sâko jaŋehec biac bâniejec murâ hatao âgo wiacfâc-jekic jaŋerao basa rahuc juhapire ŋafewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jaŋerao basa-bipierâ hae fureme mocwâc Jerusalem haeo risierâ ira basapic. ");
INSERT INTO kmg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Basahapire gie bapa jahec â moc eme taha ufuŋko bâfuapic. Ira miti qaqazu jaŋere ŋondeŋko ŋehuc dâŋjeŋic manahuc fuŋnere mu wioc ejarewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eme ŋembiŋ jaŋe mâmâc sasawa mamana-ticnere â dâŋticnere wareckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eme jaŋere ŋondeŋko hâcne ŋehame bâfuarâ wodâtâŋnepic. Ehuc neŋgocnezi šiŋuc âzâcnewec: “ŋokâ-mae, go wemocte iŋuc enâctekomec? Manakic, mamacgehec nâhe huacbuc ehuc basacguhuc jukoperec.” ");
INSERT INTO kmg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mume šiŋuc jasawec: “Weniŋuc erâ basacnuhuc jukopirec? No Mamac-nanere gieo jupemurâ munarekicne, i mi manakopirec me?” ");
INSERT INTO kmg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iŋuc mume jahe dâŋ i manapire quŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eme neŋgoc mamac jahec-ticne jahehec Nazarete haeo risierâ ira sâsec-jofahuc juwec. Neŋgoc-ticne eki ine dâŋticne manawec sâc mana maŋ erâ juwec. ");
INSERT INTO kmg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eme Jesu e maŋzi â sahaczi mâmâc soka sanaŋ ehuc juwec. Ehame Anutu mecne â ŋic mecne jaŋe hone ririŋkehuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio e jara 15 Roma ŋicwofuŋ jurakuhame Johanezi gie-ticne fuŋkewec. Dameŋ ira Pontio Pilatozi Judaia mâreŋko kia juwec â Herode eki Galilaia mâreŋko mâreŋ soŋaŋ juwec â ɋâticne Filipo e Ituraia â Trakoniti irec ŋicwofuŋ juwec, â Lisania e Abilene mâreŋko ŋicwofuŋ juwec. ");
INSERT INTO kmg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Á taha bapa sâko jajahec jupic, Hanasi â Kaifa. Ŋic izi hâcne ŋicwofuŋ â taha bapa jurambiŋ dameŋ ira Zakariare ŋokâ Johane mâreŋ burocnao juhame Anutuzi giedâŋ mucnewec. ");
INSERT INTO kmg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Giedâŋ mucneme Jordaŋ šiŋuc ocninuc jufârehuc ŋic maŋjenic bârisierâ Miti Opâ ruapie sâqocne-jeŋic tâmireocte jazawec. ");
INSERT INTO kmg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Porofete Jesajazi irec findaŋdâŋ kecšiŋuc qâreŋkewec fokac: “Mareŋ tuhuo wiwira moc fuakac: Wofuŋte hata bâšâweniŋ, hata-ticne hepie wâneŋkeoc; ");
INSERT INTO kmg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","wâcne wâcne hemase-fârezo, tikine facne hezu hewâneŋ ezo; hehesicne hetiŋnezo â bahacne hefâsâezo. ");
INSERT INTO kmg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eme mâreŋŋic šeŋgoma Anuture bâbâpiaŋ honeniŋmu. “ ");
INSERT INTO kmg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eme ŋic guru sâko Johanerao ra Miti Opâre mupie šiŋuc jazawec: “Homare ɋâric, ŋoŋe sâqocnere okacne fisizo ekac i wisecneniŋte mozi ŋazawec? ");
INSERT INTO kmg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ŋoŋe maŋŋeŋic bârisiehuc irec sâcko fârine bâfuaniŋ me¡ Erâ maŋŋeŋiczi šiŋuc mi muniŋ: Nâŋe Abrahamte ɋâricfâc. No ŋazape mananiŋ: Anutu e muzo murâ sâcne mume qânâ šizi Abrahamte ɋâricfâc fuaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Râric biac jâcfuŋko râekicne. Irec jâc moc fâri tâmiric domame qafararâ šocko rikezo.” ");
INSERT INTO kmg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iŋuc muhuc jazame ŋic jaŋe wiocnerâ mumbiŋ: “Wemo enšepeneŋ?” ");
INSERT INTO kmg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mupie jazawec: “Ŋic moc e ŋaqi jajahec bajurâ âgone ŋaqi tâmiric honerâ moc râcnezejec. Á nânâre iŋuc jaha enšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Eme takesi roro jaŋe iŋuc jaha Miti Opâre fisirâ indiŋkerâ mumbiŋ: “Qaqazu, nâŋe weniŋuc enšepeneŋ?” ");
INSERT INTO kmg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mupie jazawec: “Ŋoŋe mumutâc qâsuahuc ŋic moneŋ mi jowac ronšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Á momori jaŋe iŋuc jaha fisirâ mumbiŋ: “Eme nâŋe wenac enaŋmu?” Mupie jazawec: “Ŋoŋe ŋic jopa qâšâic me qoqoric kosa mi ejarenšepieŋ. Mosare wiac roeŋgopieŋ irec manapie tarazejec.” ");
INSERT INTO kmg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Eme ŋic jaŋe Johanere buâkec ejareme mana kikiwehuc šiŋuc mumbiŋ: “E Kristo ine hâcne mecne.” ");
INSERT INTO kmg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iŋuc mupie mâmâc sasawa dâŋ šiŋuc jazawec: “No opâ rua-ŋarekopac. Râpefuŋ-naneo warehuc jukac, e ine tâpiri sâc moc focnekac. E sâko no iŋucnezi mafahe decnepe mi sâckeocmu. Eki hâcne Tiri Mâro â šoc rua-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","E oofaŋ-ticnehec warerâ nânâfic-ticne emasaŋkeocmu, ehuc nânâ fârine wosâerâ ficko râeme ŋeocmu â jawa rasa wiac ofaŋne behec eme šocsanaŋko šaocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Johanezi uŋdâŋ i â gâcne muhuc ŋic Biŋebiaŋ jazawec. ");
INSERT INTO kmg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jaŋe jazahuc ŋicwofuŋ Herode e iŋuc jaha mumu hehec ecnewec. E ɋaticnere ŋonâŋ, šâŋene Herodia, jâoc rowec â sindaŋ gâcne wâc ewec. ");
INSERT INTO kmg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eme irec fainao qizecne sâko ehuc Johane kâpâcwâru ficko râewec. ");
INSERT INTO kmg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ŋic bocjaha Johanerao fisirâ Miti Opâ ruahapie Jesu e iŋuc jaha rârâ ruawec. Ruarâ numuhame sambâŋ aŋkeme ");
INSERT INTO kmg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tiri Mârozi sahac fârihec erâ hapâ hawario ere faio wahawec. Ehame sambâŋkonec dâŋ šiŋuc wahawec: “Joroc Ŋokâ biaŋ-nane, go hone aŋac agareekopac.” ");
INSERT INTO kmg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu e jara-ticne 30 qâririŋ bazurâ gie-ticne fuŋkewec. Eme ŋic jaŋe ere manapie Josefere ŋokâ ewec. Josefe e Elire ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","e Matatare ɋâric, e Lewire ɋâric, Lewi e Melikire ɋâric, e Janaire ɋâric, e Josefere ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","e Matatiare ɋâric, e Amosire ɋâric, e Nahumte ɋâric, e Esilire ɋâric, e Nagaire ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","e Maatare ɋâric, e Matatiare ɋâric, e Semeiŋte ɋâric, e Josecte ɋâric, e Jodare ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","e Johanaŋte ɋâric, e Resare ɋâric, e Serubabere ɋâric, e Sealitiere ɋâric, e Nerire ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","e Melikire ɋâric, e Adire ɋâric, e Kosamte ɋâric, e Elimadamte ɋâric, e Erere ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","e Jesure ɋâric, e Eliešere ɋâric, e Jorimte ɋâric, e Matatare ɋâric, e Lewire ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","e Simeoŋte ɋâric, e Judare ɋâric, e Josefere ɋâric, e Jonamte ɋâric, e Eliakimte ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","e Meleare ɋâric, e Menare ɋâric, e Matatare ɋâric, e Nataŋte ɋâric, e Dawidire ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","e Isaire ɋâric, e Obedere ɋâric, e Boasire ɋâric, e Salare ɋâric, e Nasoŋte ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","e Aminadare ɋâric, e Adamiŋte ɋâric, e Aranire ɋâric, e Hezoroŋte ɋâric, e Peresere ɋâric, e Judare ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","e Jakobore ɋâric, e Isakare ɋâric, e Abrahamte ɋâric, e Tarare ɋâric, e Nahore ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","e Serugure ɋâric, e Ragaure ɋâric, e Pelegere ɋâric, e Ebere ɋâric, e Selare ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","e Kenaŋte ɋâric, e Arapakisare ɋâric, e Semte ɋâric, e Noare ɋâric, e Lamecte ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","e Metuselare ɋâric, e Enokore ɋâric, e Jaredere ɋâric, e Mahalalere ɋâric, e Kenaŋte ɋâric, ");
INSERT INTO kmg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","e Enosire ɋâric, e Setere ɋâric, e Adamte ɋâric, e Anuturaonec. ");
INSERT INTO kmg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu e Tiri Mârozi maŋne fusucmarâ ecneme Jordaŋ opâ beherâ mâreŋ tuhuo rawec. ");
INSERT INTO kmg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ira ŋafe šoaŋ 40 ju fofo ehuc juhame Sataŋzi esâickehuc juwec. Eme dameŋ ira nânâ tâmiric sasawa juku nânâre hâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ehame Sataŋzi šiŋuc âzâcnewec: “Go Anuture Ŋokâ jukomecko mutec qânâ šizi nânâ eoc me!” ");
INSERT INTO kmg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mume Jesuzi šiŋuc âzâcnewec: “Aricne, dâŋqâreŋ kecšiŋuc fokac: ŋiczi nânâre sawa mi juhâmoocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eme Sataŋzi tiki šoricne mocko jowa ferâ mâreŋte faio ŋicne ŋicne ŋicwofuŋfâc-jeŋichec jurambiŋ i beraŋnea jâutu-fârewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ehuc šiŋuc âzâcnewec: “Tâpiri â šâŋe biŋe fojare rakac keci go gare-fârepemu. I nore meo râekicnere e me e râcnezo murâ sâcne râcnepemu. ");
INSERT INTO kmg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Irec go maŋfuŋ-naneo fodaperâ numu-naretec gore efâreocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mume Jesuzi dâŋ šiŋuc bâtikiecnewec: “Dâŋqâreŋ kecšiŋuc fokac: `Wofuŋ Anutuge dieŋzi herâ numucnezo â e mocjaha kiŋaŋ qacnezo. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eme Sataŋzi Jesu Jerusalem haeo taha ufuŋ bupu faio râerâ šiŋuc âzâcnewec: “Go Anuture Ŋokâ jukomecko širec tara huc. ");
INSERT INTO kmg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dâŋqâreŋ moc šiŋuc hâcne fokac: `E aŋelofâcne mejeŋicko râecgume ŋezicguniŋmu', ");
INSERT INTO kmg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","â moc šiŋuc `Jaŋe mefaio bahucgupie qânâzi kikege mi heocmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Eme Jesuzi šiŋuc âzâcnewec: “Wofuŋ Anutu penaroŋ ecnehuc mi esâickezo.” ");
INSERT INTO kmg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sataŋ e iŋuczi iŋuc eku esâicke tararâ beherâ dameŋ mocte woŋec juwec. ");
INSERT INTO kmg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu e Mârozi neŋgoc ŋesiŋ ŋecnehame Galilaia mâreŋko risiewec. Risieme biŋe-ticne hae sâc rafârewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Eme ira mitificne ficne miti jazame muac baafec ecne-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Juraku sosoka hae-ticne Nazarete ira iŋuc jaha fisirâ sabata hombaŋko mitificko fewec. E hombaŋ sâc iŋuc ejujec. Ferâ miti wose-jareocte fahareme ");
INSERT INTO kmg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","porofete Jesaja ere papia râcnembiŋ. Râcnepie qaratierâ dâŋ šiŋuc fowec i bâfuawec: ");
INSERT INTO kmg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Wofuŋte Mârozi norao waharâ rua-narehuc gie šiŋuc munarewec: ŋic hujukicne Biŋebiaŋ jazazo, kâpâcwâru bacjopakicne firuec-jopazo, šâŋe tiŋtuŋ šâŋe fifi bacjopazo, keke suec suec ejarekicne hefârec-jopazo, ");
INSERT INTO kmg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","â Wofuŋte dameŋ biaŋ maickekac irec biŋedâŋ muzo.” ");
INSERT INTO kmg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Dâŋ iŋuc woserâ papia bazurâ kiŋaŋŋic râcnerâ waha ŋewec. Ŋehame ŋic mitificko ŋembiŋ jaŋe mâmâc sasawa erao šâŋe fifârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eme dâŋ šiŋuc fuŋkerâ jazawec: “Mitidâŋ wosepe manaŋgopieŋ i miŋecgac fârine fuakac.” ");
INSERT INTO kmg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mume jaŋe qâtâc herâ dâŋticne manapie aŋac šizine eme wareckerâ mumbiŋ: “Hâc, e Josefere ŋokâ i!” ");
INSERT INTO kmg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eme eki šiŋuc jazawec: “ŋoŋe nore dâŋ suŋsuŋne qahuc šiŋuc mecne mueŋgopieŋ: Dokta go fuŋnege bataniŋkec, Kafanaum haeo gie batec biŋene manaeŋgopeneŋ, ijaha šira mame sâko haegao batec honenaŋ me!” ");
INSERT INTO kmg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iŋuc murâ muwec: “No jâmbomac ŋazape: Porofete moc e jahacne haefuŋko âgo sâcne mi ecneeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Erâ jâmbomac ŋazape: Elia juhame šoaŋ sâko jara jahec â moc â mosa 6 qakume roroc fuarâ mâreŋ sâckerâ fowec. Eme dameŋ ira Israe mâreŋko hozec bocjaha juipiehapie ");
INSERT INTO kmg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Anutuzi Elia Zarefati haeo Sidoŋ mâreŋko qâpuc hozec moc juwec erao soreme rawec. ");
INSERT INTO kmg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Erâ porofete Elisa juwec dameŋ ira Israe mâreŋko wic sanaŋheczi bocjaha jumbiŋ. Eme jaŋeraonec moczi mi fâsâehame Naemaŋ Siria mâreŋkonec e mocjahazi fâsâewec.” ");
INSERT INTO kmg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iŋuc muhuc jazame mitificko ŋembiŋ jaŋe dâŋ i mana gâpârerâ ");
INSERT INTO kmg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","faharerâ hae râpeo tuŋke hurâ hae-jeŋic ŋewec tiki irec tapinao jowa ferâ hârâc mecko bararâ ira behepie huocte muhapie ");
INSERT INTO kmg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","eki ŋondeŋ-jeŋicko fosiroŋnerâ rawec. ");
INSERT INTO kmg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eme raku Galilaia mâreŋko hae moc šâŋene Kafanaum ira fisirâ sabata hombaŋko miti jaza qazuc ewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eme e runezi miti muŋɋârâŋkehuc mume jaŋe manapie bu ââkecnehec ewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eme mitificko ŋic demoŋ repicnehec moc ŋewec. E Jesu honerâ kâcɋene owackehuc muwec: ");
INSERT INTO kmg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jei, Jesu Nazarete rune, go nâŋere jujuo wemocte warekomec? Go sipiric-nâpocmurâ warekomec me? No šâŋitacgukopac, go Anuture Tiriŋic.” ");
INSERT INTO kmg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iŋuc mume Jesuzi dâŋ mucnerâ muwec, “Go niniŋkerâ ŋickonec wefu rac.” Mume demoŋzi ŋic âtetuŋkeme ŋicŋondeŋko hurâ qaha wefu rawec. Ehuc ŋic e ine qa qâpuriŋ mi ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eme jaŋe bipic-jeŋic tarame nazaŋ gazaŋ erâ mumbiŋ: “Hâc, dâŋ keci weniŋucne? E tâpiri sâkoheczi demoŋ dâŋ jazame wefurâ wiseeŋgopieŋ!” ");
INSERT INTO kmg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eme biŋe-ticne hae rârec rârec rafârewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu e mitifickonec waharâ Simoŋte ficko fewec. Ira Simoŋ safeŋ-ticne huc šocnehec bame fowec. Eme ere erâ Jesu âzâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eme eki fowecko raširâ erao daperâ huc dâŋ mucneme behewec. Eme ŋokac e biac faherâ nânâ rike gumec ejarewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ʒoaŋ ŋetarame ŋic jaŋe âgofâc-jeŋic huc šâichec Jesurao bacjopa warepie qizec-jeŋicko meticne râerâ huc šâic bâniniŋke-jarewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Erâ demoŋ jâpe-jareme ŋicmaŋkonec wefurâ owa kâcɋene ehuc šiŋuc mumbiŋ: “Go Anuture Ŋokâ.” Jaŋe fuŋne-ticne šiŋuc manambiŋ, e Kristo. Eme i mujaŋgeŋkenšipiŋte mu hezuc ejarewec. ");
INSERT INTO kmg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hae fureme fickonec waharâ mâreŋ râricne mocko ra juwec. Eme ŋic jaŋe basaku bâfuarâ jaŋehec juocte sakarezo mupie ");
INSERT INTO kmg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","šiŋuc jazawec: “No hae sâc ŋic Anuture uucmaŋ irec Biŋebiaŋ jazazepac, no gie irec hâcne sorecnukicne.” ");
INSERT INTO kmg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iŋuc murâ Judaŋic jaŋere mitific ŋerawec sâc jufârehuc miti jaza rahuc jujujec. ");
INSERT INTO kmg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ʒoaŋ mocte Jesuzi Genesarete riqic moŋgeŋnao juhame ŋic Anuture dâŋ mananiŋte fisirâ qazu orâŋ mâretec ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ehame moŋgeŋko woke jajahec ŋepic, rune jaŋe ine wokeonec waharâ wasaŋ-jeŋic šurehuc domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Eme Jesuzi woke i hâcne honerâ moc Simoŋte biŋe ira ferâ mume piticne âke sueme rame miti jaza qazuc ehuc ŋewec. ");
INSERT INTO kmg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jaza qazuc efârerâ Simoŋ šiŋuc âzâcnewec: “Riqic šâšâŋiŋko rarâ wasaŋ behepie qowi jowaoc.” ");
INSERT INTO kmg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mume Simoŋzi šiŋuc âzâcnewec: “Qaqazu, nâŋe ŋafe šora wasaŋ behe-bipiehuc qowi moc mi rombeneŋ, gore micte ine sifu mocwâc behepemu.” ");
INSERT INTO kmg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eme wasaŋ behepie qowi bocjaha jâmbâŋ jowame wasaŋ tâcnezo ewec. ");
INSERT INTO kmg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eme fâre-bipierâ âgofâc-jeŋic woke mocko jumbiŋ jaŋe meoric qajarepie ware bafic-jopambiŋ. Ehuc qowi ropie woke jajahec huku fusucmame ŋeutuckezo epic. ");
INSERT INTO kmg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eme Simoŋ Petorozi i honerâ Jesure maŋfuŋko fodaperâ muwec: “Wofuŋ, no ŋic sâqocnere behecnu rac.” ");
INSERT INTO kmg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Qowi guru sâko honerâ e jahacne â ŋic gâcne mâmâc manapie hâhâwicne eme iŋuc hâcne muwec. ");
INSERT INTO kmg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Erâ e jahacne sawa mâcne, âgo jahec-ticne Jakobo â Johane, Ʒebedaiore ŋokâ, jahe iŋuc jaha ejactewec. Eme Jesuzi Simoŋ šiŋuc âzâcnewec: “Go mi hâwicguoc, go qowi rorozi ŋic roro erâ jucmu.” ");
INSERT INTO kmg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iŋuc mume jaŋe woke moŋgeŋko fârepie feme wiac sasawa beherâ Jesu bâjâpembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesu e juku hae mocko fisirâ juhame ŋic moc wicsanaŋzi sahacne banšaŋne-fârewec, eki Jesu honerâ ware maŋfuŋnao šâŋe maine mâreŋko hetutuckerâ šiŋuc muhuc wâsickewec: “Wofuŋ, go bâsomiecnuzo murâ sâcne bâsomiecnucmu.” ");
INSERT INTO kmg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mume Jesuzi meticne sicnerâ sahacne bâuahuc muwec: “Mana-garekopacte fâsâec.” Mume izia sahac-ticne fâsâe-fârewec. ");
INSERT INTO kmg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eme Jesuzi dâŋ šiŋuc âzâcnewec: “Go irec dâŋ binaŋ ŋic mi jazahuc mâc rarâ sahacge taha bapa jâututec honezejec, ehuc fâsâekomecte Mosere micdâŋte bâzi riketec fuŋne mana taranšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Eme ŋic fâsâewec irec biŋe hae sâc rafâreme ŋic jaŋe manarâ mitire mecne â hucte mecne qiŋ qururuŋko Jesurao fisihuc domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Fisihuc boc ecnepie mâreŋ herâricne mocko ra juhuc nunumu gie bawec. ");
INSERT INTO kmg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ʒoaŋ mocko Jesuzi ŋic miti jazahuc juwec. Eme Galilaia mâreŋkonec â Judaia mâreŋkonec â Jerusalem haeonec farisaio â sâcmutâc qaqazu jaŋe fisirâ ŋic jaŋere ŋondeŋko mâmâc ŋembiŋ. Ŋehapie Wofuŋte tâpirizi Jesu neŋgoc ŋesiŋ ŋecnehame ŋic bâpiaŋ-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ehame mi ŋic šeke puriŋ moc kanšeo reŋke warenšepieŋ i¡ Erâ ficko baferâ Jesure maŋfuŋko râeniŋte ŋic jaŋerao hetakirembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Iŋuc erâ fic bupuo baferâ bâropierâ ŋic kanšehec âke suepie ŋicŋondeŋko Jesure maio wahawec. ");
INSERT INTO kmg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iŋuc epie Jesuzi mamanasiŋ-jeŋicte fuŋne hone manac erâ ŋic šeke puriŋ šiŋuc âzâcnewec: “Ŋicmae, sâqocne mutâmire-garekicne.” ");
INSERT INTO kmg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mume miti qaqazu â farisaio jaŋe dâŋ i manarâ maŋjeŋiczi šiŋuc manasumbiŋ: “Hâc, e wemo-ticnere Anutu âkehockekac, sâqocne bâbâtâmire i Anutuzi buc eekac.” ");
INSERT INTO kmg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iŋuc manasupie Jesuzi maŋjeŋicko dâŋ i mana tararâ šiŋuc jazawec: “Maŋŋeŋiczi wemocte dâŋ iŋucne manasuŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gie wenimo izi afecne? Ŋic šeke puriŋ šiŋuc âzâcnezo: `Sâqocnege bâtâmire-garekicneƷ me šiŋuc âzâcnezo: `Fahare rac'? ");
INSERT INTO kmg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ŋic Fâri Wâtuŋne e mâreŋko sâqocne bâtâmireocte tâpiri focnekac irec fuŋne hone tarariŋ.” Iŋuc murâ ŋic šeke puriŋ šiŋuc âzâcnewec: “No gazape faharerâ fofoge rorâ haegao rac.” ");
INSERT INTO kmg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mume izia šâŋe mai-jeŋicko faharerâ fofo-ticne rorâ haeo rahuc Anutu muteŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eme ŋic jaŋe i honerâ manapie hâhâwicne eme warecke sâqorerâ Anutu mucne bacnehuc mumbiŋ: “Miŋecgac wiac šâŋe furu fuame honeŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eme Jesuzi fickonec waharâ hata rawec. Rarâ takesi roro ŋic moc šâŋene Lewi e moneŋfic-ticnao ŋehame honerâ šiŋuc âzâcnewec: “Ware bâjâpecnuc.” ");
INSERT INTO kmg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mume Lewi e wiac-ticne sasawa râpeckehuc fahare Jesu bâjâpewec. ");
INSERT INTO kmg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Erâ Jesure bâzi rikerâ takesi roro â ŋic gâcne hefârec-jopame fisirâ mâmâc nâmbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eme farisaio â miti qaqazu âgofâc-jeŋic jaŋe irec manapie sâqoreme Jesure motecfâc šiŋuc jazambiŋ: “Ŋoŋe wemocte takesi roro ŋic â sâqocne bapa Jaŋehec tiwa bâzi nâŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mupie Jesuzi manarâ šiŋuc jazawec: Ɋiɋicne jaŋe doktare mi mueŋgopieŋ, huchec jaŋe ine mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ŋic tiŋne mâcne, sâqocne bapa hefârec-jopape maŋjeŋic bârisieniŋte wahapo.” ");
INSERT INTO kmg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesuzi iŋuc mume jaŋe dâŋ šiŋuc âzâcnembiŋ: “Johanere motecfâc jaŋe gâbâ jaha nânâ sowa juhuc nunumu gie baeŋgopieŋ â fârisaio jaŋerezi iŋuc jaha eeŋgopieŋ, â go gahacne jaŋe ine nânâ opâ kosa nâeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mupie Jesuzi šiŋuc jazawec: “Ŋicwofuŋ e kikefuŋfâc-ticne jaŋehec juhame ŋoŋe sâcne ejarepie sowa juniŋmu me? ");
INSERT INTO kmg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Juku ŋicwofuŋ jowac ropie basahuc dameŋ ira sowa juniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iŋuc murâ dâŋ herâricne moc šiŋuc jazawec: “Mozi ŋaqi ɋâricnaonec qoruc susuc moc bâtâcnerâ ŋaqi raŋɋanao ɋâtâocmu? Moc e iŋuc erâ muzac ŋaqi ɋâricne maŋgâŋ sipirickezac â qoruc susuc ɋâricnezi ŋaqi raŋɋanao sâctiri jaha ezac. ");
INSERT INTO kmg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Erâ wâc waiŋ opâ ɋâricne šopo raŋɋanao mi qoŋgiŋkepie huekac. Iŋuc eniŋmuo wiaŋ ɋâricnezi šopo raŋɋane âtefâuckeme waiŋ mecne šopo mecne mâmâc sipirickenicmu. ");
INSERT INTO kmg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Irec hâcne waiŋ ɋâricnezi šopo ɋâricnao hume sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Á moc e waiŋ raŋɋane nâku maŋne eweczi waiŋ ɋâricne šiŋuc muhuc qikiŋneocmu: Raŋɋane nâpe aŋacne ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabata hombaŋ mocko Jesu â motecfâc-ticne jaŋe padi gie ŋondeŋko rambiŋ. Rahuc motec jaŋe fârine moc moc bâtâcnerâ mezi šâmurâ nâmbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iŋuc epie farisaio jaŋe honerâ mumbiŋ: “ŋoŋe wemocte sabata hombaŋko wiac mi eene eŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mupie Jesuzi šiŋuc jazawec: “Dawidi â ŋicfâcne nânâre hâmohuc wiac embiŋ, i ŋoŋe wose manac mi eeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawidi e Anuture ufuŋko ferâ poroŋ Anuture biŋe râekicne i rorâ nâhuc ŋicfâcne jareme mâmâc nâmbiŋ. Poroŋ i ŋic omane bâtâc bajarekicne, bâzi ririke ŋic micbuc-jeŋic. Eme i sifu nâmbiŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iŋuc murâ muwec: “Ŋic Fâri Wâtuŋne e sabata hombaŋ irec rune jukac wâc.” ");
INSERT INTO kmg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Eme sabata hombaŋ mocko mitificko ferâ miti jaza qazuc ewec. Ehame ira ŋic moc ŋewec, e me fârene ɋaŋakicne. ");
INSERT INTO kmg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Eme miti qaqazu â farisaio jaŋe hombaŋko ŋic bâpiaŋkeme honerâ dâŋko râeniŋte ruc bahuc ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Eme Jesuzi maŋjeŋicko hone tararâ ŋic mene ɋaŋakicne e šiŋuc âzâcnewec: “Go fahare mai domac.” Mume fahare domawec. ");
INSERT INTO kmg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ehame Jesuzi šiŋuc jazawec: “No wio-ŋarepe muniŋ: Sabata hombaŋko wiac biaŋne me wiac sâqocne ezo, ŋic bâpiaŋ-jopazo me sipiric-jopazo?” ");
INSERT INTO kmg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iŋuc murâ risic forisic honec-joparâ ŋic šiŋuc âzâcnewec: “Mege fâretiŋnec.” Eme ŋic e iŋuc eme meticne sanaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Eme jaŋe i hone manac erâ aariczi maŋjeŋic fusucmame Jesu iŋuc me iŋuc ecneniŋte muc manac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dameŋ ira Jesuzi tikio numuocte fewec. Ferâ ŋafe šora Anutu numucnehec juhame hae furewec. ");
INSERT INTO kmg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hae fureme kikefuŋfâc-ticne hefârec-joparâ jaŋeraonec 12 bâwosâec-joparâ motec bacjopawec, ehuc šâŋe sâko-jeŋic aposolo muwec. ");
INSERT INTO kmg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ʒâŋe bucbuc-jeŋic ine šiŋuc: Simoŋ, šâŋe-ticne moc Petoro â ɋaticne Anderea, erâ Jakobo â Johane, erâ Filipo â Batolomaio, ");
INSERT INTO kmg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","erâ Mataio â Toma, erâ Jakobo Alifaiore ŋokâ â Simoŋ Ʒelote, ");
INSERT INTO kmg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","erâ Juda Jakobore ŋokâ â Juda Karioto haeonec, e juku Jesu doc bawec. ");
INSERT INTO kmg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Eme rocjopame tikionec waharâ wâneŋko fisirâ juhapie kikefuŋfâc-ticne bocjaha â ŋic guru sâko erao tumaŋnembiŋ. Jaŋe Judaia mâreŋkonec â Jerusalem haeonec â Tiro Sidoŋ hâwec moŋgeŋkonec fisipie miti jazawec â huchec ɋiɋicne bacjopawec. ");
INSERT INTO kmg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Erâ demoŋzi areŋ ejarewec jaŋe wâc bâpiaŋ-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eme bâuapie tâpiri-ticne jaŋerao fotâcneme ɋiɋic qambiŋte bâuaniŋte kime iriac mâretec ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Eme Jesuzi motecfâc-ticne jaŋerao šâŋe fihuc šiŋuc muwec: “Hapetac jueŋgopieŋ ŋoŋere manape šerine ekac, ŋoŋe hâcne Anuture uucmaŋ biŋe qaŋarekicne. ");
INSERT INTO kmg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dameŋ šiŋuczia nâ hâmoc ehuc jueŋgopieŋ ŋoŋere manape šerine ekac, ŋoŋe hâcne juku nâ gapec enšoŋgopieŋ. Dameŋ ši ki busâqoc ehuc jueŋgopieŋ ŋoŋere manape šerine ekac, ŋoŋe hâcne juku bubiaŋ bâfuanšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ŋic jaŋe Ŋic Fâri Wâtuŋne ere erâ qaisoc-ŋoparâ jâpe bâsuec eŋarerâ musâqorec-ŋoparâ šâŋe-ŋeŋic musoriŋkeniŋmu, ŋoŋe manariŋ-ŋopakopac. ");
INSERT INTO kmg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wiac iŋucne fuame dameŋ ira šeri bari enšepieŋ. Manaŋgopieŋ, sambâŋko furine afecne mi foŋarekac. Mimiŋnefâc-jeŋic jaŋe porofete sâc ijaha ejare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Moneŋ mafa sâkohec, jei, ŋoŋe juku wemo wiaczi bâmiriŋ-ŋopazokac? ");
INSERT INTO kmg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Dameŋ šiŋuczia nânâ qowi mâririhec jueŋgopieŋ, jei, ŋoŋe juku nânâ basanšoŋgopieŋ. Dameŋ šiŋuczia gâgâwi faio jueŋgopieŋ, jei, ŋoŋe juku ki busâqoc bâfuanšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Muteŋ bâteŋ eŋareeŋgopieŋ, jei, ŋoŋe juku weniŋuc enšoŋgopieŋ? Mimiŋnefâc-jeŋic jaŋe porofete burecne iŋuc jaha muteŋ bâteŋ ejare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Dâŋnane manahuc juŋgopieŋ ŋoŋe ŋazape: Ŋoŋe râsifâc-ŋeŋic âgo jauŋ ejarenšepieŋ, qaisoc-ŋopaeŋgopieŋ jaŋe jauŋ bacjopanšepieŋ, ");
INSERT INTO kmg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","sâwec-ŋopaeŋgopieŋ jaŋe jambuŋ-jopanšepieŋ, musâqorec-ŋopaeŋgopieŋ jaŋere erâ numunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Moczi maucge ŋicfecne qame ŋifecne wâc sicnecnezemec â moczi ŋaqige faine gowac rome e maŋne mâmâc qikiŋnecnezemec. ");
INSERT INTO kmg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Á moczi wiac mocte numu-gareme râcnezemec â moczi wiac moc gowac rome bârisie-gareocte mi fotariezemec. ");
INSERT INTO kmg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ŋoŋe ŋic jaŋe wiac eŋareniŋte manasueŋgopieŋ, sâc ijaha wâc jaŋe ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ŋoŋe maŋjauŋ eŋareeŋgopieŋ jaŋe sawa maŋjauŋ ejareniŋmu, ine wemocko tofane fome juku bazu-ŋarezo? Miti tâmiriczi âgofâc-jeŋic maŋjauŋ ejareeŋgopieŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Á âgo eŋareeŋgopieŋ jaŋe sawa âgo ejareniŋmu, ine wemocko tofane fome juku bazu-ŋarezo? I miti tâmiriczi eeŋgopieŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Okacne bârisie-ŋareniŋmu jaŋe sawa wiac ejarepie wemocko tofane fome juku bazu-ŋarezo? Miti tâmiriczi âgofâc-jeŋic šiŋuc muhuc wiac ejareeŋgopieŋ wâc: Juku sâc ijaha bârisie-nârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Aricne, iŋuc mi ezo, ŋoŋe râsifâc-ŋeŋic âgo jauŋ ejarenšepieŋ. Okacne mi mecne bazu-ŋareniŋmu jaŋe sifu ehâmo-jarehuc wiac qikiŋne-jarenšepieŋ. Iŋuc erâ juku furine ŋemâcne ronšoŋgopieŋ, erâ femicne sâko ere naru motecfâc erâ juniŋmu. Eki hâcne ŋic qâomane â râŋgeŋne jaŋe sifu bâmec bajareekac. ");
INSERT INTO kmg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mamac-ŋeŋiczi buuruc juekacte ŋoŋe iŋuc jaha buuruc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ŋoŋe ŋic okacne dâŋ mi mutara-jarenšepieŋ, eme Anutuzi ŋoŋe iŋuc jaha okacne dâŋ mi mutara-ŋareocmu. Ŋoŋe ŋic kiŋko mi râec-jopanšepieŋ, eme Anutuzi ŋoŋe iŋuc jaha kiŋko mi râec-ŋopaocmu. Ŋoŋe tofa-ŋeŋic ŋic qikiŋne-jarepie Anutuzi tofa-ticne ŋoŋe iŋuc jaha qikiŋne-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ŋoŋe ŋic bâmec bajarepie Anutuzi ŋoŋe iŋuc jaha bâmec baŋareocmu. Ehuc irec sâc jâuruhuc siric-ŋoparâ bašihuc guru fufusuc heŋareocmu. Ŋoŋe sâc bajuhuc ŋic wiac ejareniŋmu, sâc ijaha Anutuzi bajuhuc ŋoŋe eŋareocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iŋuc murâ dâŋ suŋsuŋne moc šiŋuc šuhuckerâ jazawec: “Tiŋtuŋ jajaheczi jojowac erâ mi qâsorierâ mâmâc jaha hârâcko hunicmu me? ");
INSERT INTO kmg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Moteczi qaqazu-ticne sisiricke i mi fokac, motec e wiac mana-hâmorâ qaqazu-ticnere sâc eme taraocmu. ");
INSERT INTO kmg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Go wemocte âgogere šâŋeo gâc i honehuc go gahacne šâŋeo jâcdâkâ fokac ine mi hone tarakomec? ");
INSERT INTO kmg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jâcdâkâ go gahacne šâŋeo foipiehame go weniŋuc âgoge šiŋuc âzâcnetec sâckeocmu: `Âgo, manahaŋ, šâŋegao gâc fokac rogarepe. Ž Burecŋic, gahacne šâŋeo jâcdâkâ fokac i qanaŋ rorâ ie âgogere šâŋeo gâc rotec sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Jâc biaŋnao wemocko fârine sâqocne fuaocmu, me jâc sâqocnao wemocko fârine biaŋne fuaocmu? ");
INSERT INTO kmg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jâcte fuŋne fârinezi bataniŋkeekac. Safeo suc fârine fuame rozo me? Me šaqeŋko saŋ fârine fuame rozo me? ");
INSERT INTO kmg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ŋic biaŋnezi maŋrowaŋ-ticne biaŋnaonec wiac biaŋne utuocmu, ŋic sâqocnezi maŋrowaŋ-ticne sâqocnaonec wiac sâqocne utuocmu. Maŋko wiac fusucmarâ foekac, ijaha micko wefuekac. ");
INSERT INTO kmg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Wemocte mâc micbipiczi Wofuŋ-nâŋec, Wofuŋ-nâŋec i sawa munarehuc dâŋ ŋazaekopac i mi reŋkeeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Moc e nohec juhuc dâŋnane manarâ reŋkeocmu, e mohec sâc hepe mana taraniŋ? ");
INSERT INTO kmg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","E ŋic moc ficsanaŋ bawec ere sâc. Ŋic eki hâcne baocte wâtuŋ šoricne wiseme hume keteŋkeme qiŋ herâ domawec. Erâ fic bâzickeme ŋeha hoemaŋ maickeme mâŋâŋ tâpirihec qarâ fic i sanaŋne bakicnere bâpiewec. ");
INSERT INTO kmg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Á moczi dâŋnane manarâ qataraocmu e ŋic moc fic dodocne bawec ere sâc. Ŋic eki hâcne fic baocte wâtuŋ mâc burec burec wiseme hume fic iriŋ biriŋ bawec. Ehame hoemaŋ maickeme mâŋâŋ tâpirihec warerâ fic âke tuŋkeme rândiŋkerâ qarâ qanšaŋnewec.” ");
INSERT INTO kmg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu e ŋic mitidâŋ i jazaku jaza-fârerâ Kafanaum haeo rawec. ");
INSERT INTO kmg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ira momori soŋaŋ moc ere kiŋaŋ motec hâmozo ehuc fowec. Bomboŋ e motec ere maname biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Irec Jesure biŋe manarâ Judaŋic micne bapa Jesu hefârepie motec huc bâniniŋkecneocte jazawec. ");
INSERT INTO kmg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Eme jaŋe Jesurao fisirâ šiŋuc muhuc âzâcnembiŋ: “Momori soŋaŋ e jume biaŋkeekacte dâŋticne manazemec. ");
INSERT INTO kmg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","E maŋticne Judaŋic nâŋerea domaekac. Erâ mitific-nâŋec fuaocte ekizia moneŋ râeme sâckeme fua-nârewec.” ");
INSERT INTO kmg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iŋuc muhuc âzâcnepie manarâ jaŋehec rawec. Rarâ ficticne bâqiŋkezo ehame momori soŋaŋzi âgofâcne Jesurao sorec-jopahuc dâŋ šiŋuc râeme rawec: “Wofuŋ, go ira domac, no iŋucne mac wemocte iqicnucmu. ");
INSERT INTO kmg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","No nahacne manape mi sâckeme gorao fâzo quŋkepac hâcne. Irec go ira juhuc mâc miczi mutec kiŋaŋ motec-nane ɋiɋic qazejec. ");
INSERT INTO kmg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","No ŋic fekicne jaŋere kiŋaŋ qaqa, eme nore wahamicne momorifâc-nane juŋgopieŋ. Eme jaŋeraonec moc `racƷ âzâcnepe raocmu, moc `warecƷ âzâcnepe wareocmu, â kiŋaŋ motec-nane `gie i bacƷ mupe baocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eme Jesu e dâŋ i manarâ momori soŋaŋ seckecnerâ ŋicguru bâjâpembiŋ jaŋerao fotikierâ šiŋuc jazawec: “No ŋazape mananiŋ, Israe ŋic ŋoŋerao mamanasiŋ sâc iŋucne mi bâfuaekopac.” Iŋuc mume momori soŋaŋ âgofâcne jaŋe risierâ ficko ferâ kiŋaŋ motec ɋiɋic qame honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Juku Jesuzi hae moc šâŋene Naiŋ ira rame motecfâcne â ŋic guru sâko bâjâpembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Eme hae mendâŋko fisihame qâŋɋâŋ moc reŋke wahambiŋ. Hozec moc ŋokâ-ticne mocjaha e hâmowec, e hâcne duckeniŋte haeonec ŋic ŋokac waha-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eme Wofuŋzi hozec honerâ bune sâqoreme muwec, “Mi kioc.” ");
INSERT INTO kmg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iŋuc murâ ra katapa bâuame badomahapie šiŋuc muwec: “Motec, no gazakopac, faharec. ");
INSERT INTO kmg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iŋuc âzâcneme hâmocnezi faharerâ dâŋ dâŋ ewec. Eme Jesuzi neŋgoc-ticnehec juocte râcnewec. ");
INSERT INTO kmg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Eme ŋic jaŋe i honerâ hâwic-jopame Anutu muteŋkerâ šiŋuc mumbiŋ: “Porofete kâcɋene ŋondeŋ-nâŋecko fuawec jukac.” Á gâcnezi mumbiŋ: “Anutu e ŋicfâc-ticne jâmbomac iqic-nâpokac.” Eme irec biŋe Judaia mâreŋko â mâreŋ ŋifec â ŋifec mâmâc qâfâuckerâ rawec. ");
INSERT INTO kmg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johane kâpâcwâru ficko ŋehuc juhame motecfâc-ticne jaŋe wiac fuawec irec dâŋ binaŋ ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Eme dâŋ i manarâ motec jajahec hefârec-jofarâ Wofuŋ šiŋuc muhuc wiocnenicte sorec-jofawec: “Ware-nâreocte mukicne go hâcne me? Me mocte woŋec junšepeneŋ?” ");
INSERT INTO kmg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sorec-jofame motec jahe Jesurao fisirâ mupic: “Johane Miti Opâ fufuŋkezi kecšiŋuc muhuc sorec-nâfokac: Mesia ware-nâreocte mukicne go hâcne me? Me mocte woŋec junšepeneŋ?” ");
INSERT INTO kmg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jesu e aua dameŋ ira ŋic huc šâic bâniniŋke-jarewec â demoŋ jâpe-jarewec â šâŋe tiŋtuŋ šâŋe fifi bacjopawec. ");
INSERT INTO kmg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ehame ŋic jahe fisirâ wiocnepire šiŋuc jasawec: “Ŋohe rarâ wiac hone manac ekopirec irec dâŋ binaŋ Johane ecnehuc šiŋuc âzâcnenic: Tiŋtuŋzi šâŋe fitâcneŋgopieŋ, puriŋzi hata juŋgopieŋ, wicsanaŋheczi fâsâeŋgopieŋ, qepoŋzi dâŋ mamana eŋgopieŋ, hâmokicnezi ɋârerâ fahareŋgopieŋ, â waha qaqanezi Biŋebiaŋ manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eme moc e mana gâpârehuc qiqikiŋ mi enareocmu ere manape šerine ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Eme Johanere motec jahec jahe risierâ rahapire Jesu e ŋic jumbiŋ jaŋe Johanere šiŋuc jazawec: “Ŋoŋe mâreŋ tuhuo wemo honeniŋte rambiŋ? Saparac moc mâŋâŋzi batac bawarec eme honeniŋte rambiŋ me? ");
INSERT INTO kmg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Me ŋic moc ŋaqi-ticne eri qaraweŋnehec honezo rambiŋ? Manaŋgopieŋ, ŋic ŋaqi eri qaraweŋnehec rojueŋgopieŋ jaŋe ŋicwofuŋ ficko wiac âmbâŋ nâhuc foeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Me porofete moc honeniŋte rambiŋ? No ŋazape mananiŋ, ŋic honembiŋ e porofete gâcne jaŋere sâc mâcne, e sâc moc. ");
INSERT INTO kmg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ere hâcne dâŋqâreŋ moc kecšiŋuc fokac: `Manakic, no biŋe mumu ŋicnane sorepe fâ maigao fuaocmu, erâ hatage bâšâwehuc bânie-gareocmu.' ");
INSERT INTO kmg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","No jâmbomac ŋazape, ŋokackonec fuakicne gâcne sasawa jaŋeraonec moczi Johane mi qâhuckekac. Á Anuture uucmaŋ fua tâcneme maŋnao wahakicne juocmuzi sifu e qâhuckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ŋic sasawa erâ takesi roro mâmâc jaŋe dâŋ manarâ Johanere Miti Opâ ruambiŋko Anuture dâŋ dopeckepie fâri fideteŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farisaio â sâcmutâc mamana saric jaŋe ine Johanere Miti Opâ qikiŋnehuc Anuture dâŋ râpeckepie jaŋerao fârimâc ewec. ");
INSERT INTO kmg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ŋicguru ši weni jaŋehec sâc hecjopape? Jaŋe weni jaŋe iŋucne? ");
INSERT INTO kmg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jaŋe naru motec iŋucne. Naru motec jaŋe haeo šoŋao ŋehuc dâŋ šiŋuc mutâc muwarec eeŋgopieŋ: `Gae hepene wemocte mi woŋgopieŋ'” `Ki makuc hepene wemocte mi kioŋgopieŋ! Ž ");
INSERT INTO kmg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Johane Miti Opâ fufuŋke e gie-ticne fuŋkerâ nânâ qowi mi nâhuc sowa jume honerâ mumbiŋ: `E demoŋzi ecnekac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ŋic Fâri Wâtuŋne eki waharâ nânâ qowi nâme honerâ muŋgopieŋ, `Kec e ŋic nâ âmbâŋne, takesi roro â sâqocne bapa Jaŋere âgo. Ž ");
INSERT INTO kmg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Anuture mamana biri ine qâjâpecfâcne jaŋe fuŋne-ticne hewirickepie fâri fideteŋ ewec.” ");
INSERT INTO kmg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisaio moczi Jesu nânâre hefâreme ficticnao ferâ nânâ teboo ŋewec. ");
INSERT INTO kmg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eme hae irec ŋokac sâqocne moczi Jesu e farisaiore ficko feme biŋe manarâ opâ âsu biaŋ moc kiruŋhec baferâ ");
INSERT INTO kmg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","râpefuŋnao domahuc kiome šâŋeuc-ticnezi kikene ruacneme qizec susuc-ticnezi bâkereŋkewec. Erâ kike-ticne muduckerâ opâ âsu ruacnewec. ");
INSERT INTO kmg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ŋokac iŋuc eme farisaio Jesu hefârewec eki honerâ maŋnezi šiŋuc muwec: “Ŋokac šizi wiac ecnekac e sâqocne, Jesu e porofete jurâ muzac fuŋne-ticne mana tarazac.” ");
INSERT INTO kmg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eme Jesuzi šiŋuc âzâcnewec: “Simoŋ, no dâŋ moc gazape manac.” Âzâcneme muwec, “Qaqazu, mutec manape.” ");
INSERT INTO kmg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Eme Jesuzi šiŋuc muwec: “Moneŋŋic moczi ŋic jajahec moneŋ jaba jactewec, moc 500 kina râcnewec â moc 50 kina. ");
INSERT INTO kmg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Eme okacne bazucnenicte moneŋ basapire tofa-ticne qikiŋne-jactewec. Eme jaheraonec mozi moneŋŋicte bubiaŋ fekicne bajuocmu, go more mukomec?” ");
INSERT INTO kmg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wiocneme Simoŋ šiŋuc muwec: “Moneŋ bocjaha qikiŋnecnewec ere mukopac.” Mume Jesuzi šiŋuc âzâcnewec: “Go sâcne mukomec.” ");
INSERT INTO kmg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iŋuc murâ ŋokacto forisierâ Simoŋ šiŋuc âzâcnewec: “Ŋokac kecši honekomec? No ficgao wefupe go kike šušure opâ mi râe-naremec, ŋokac eki ine kike-nane šâŋeuc-ticnezi ruacnerâ qizec susucnezi bâkereŋkekac. ");
INSERT INTO kmg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Goki mi muducnumec, ŋokac eki ine kike-nane šoɋac erâ muduckekac. ");
INSERT INTO kmg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Goki qizec-nane wokemaŋ opâzi mi ruacnemec, ŋokac eki ine kike-nane opâ âsu biaŋzi ruacnekac. ");
INSERT INTO kmg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Irec gazakopac, ŋokac e maŋjauŋ bocjaha enarekacte fuŋne-ticne šiŋuc manac: E sâqocne bocjaha bâtâmirecnekicne. Moc e sâqocne afecne bâtâmirecnekicnezi maŋjauŋ afecne eocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iŋuc murâ ŋokac šiŋuc âzâcnewec: “Sâqocnege bâtâmire-garekicne hâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iŋuc mume ŋic nânâ mâmâc nâhuc ŋembiŋ jaŋe maŋjeŋiczi šiŋuc mumbiŋ: “E mo ŋic mo, irec sâqocne bâtâmirekac?” ");
INSERT INTO kmg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eme Jesuzi ŋokac šiŋuc âzâcnewec: “Mamanasiŋgere biaŋkekomec, buge âke mâteŋkeha ra juzemec.” ");
INSERT INTO kmg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dameŋ irec faicnao Jesuzi hae sâko hae pitic mâmâc fota fotâcne juhuc ŋic miti jaza qazuc erâ Anuture uucmaŋte Biŋebiaŋ jaza jujec. Eme bâjâpehuc jumbiŋ ine šiŋuc: Motecfâcne 12, ");
INSERT INTO kmg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","erâ ŋokac tucne, mârâcko demoŋ â huchec juhapie jâpe bâniniŋ ejarewec. Jaŋeraonec moc Maria Madala haeonec, e demoŋ 7 jâpecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Erâ moc šâŋene Johana, Herodere soŋaŋ Kuza ere ŋonâŋ, erâ Susana erâ ŋokac gâcne. Jaŋe moneŋ mafa fojarewecte e â motecfâcne bâmec bajare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Haene haene irec ŋic Jesurao qaja fuserâ tumaŋnepie honec-joparâ kesaic dâŋ moc šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ŋic moczi wiac hândâŋne tieocte gieo rawec. Tiehame hândâŋne gâcnezi hatao waha heme ŋic jaŋe âtenšaŋnembiŋ. Eme sawa wipezi fisirâ nâfârewec. ");
INSERT INTO kmg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hândâŋne gâcne qânâ siecko hewec. Eme izi hahaŋkekicnere âkešurâ bâpâŋ wefurâ hâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hândâŋne gâcnezi hofâ qinšiŋ ŋondeŋko hewec. Eme âkešurâ wefume hofâ qinšiŋzi iŋuc jaha wefurâ hehâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Á hândâŋne gâcnezi ine mâreŋ guecko herâ fârine bocjaha fuawec, jâcne gâcne irec hândâŋne 100, 100 iŋuc fuawec.” Dâŋ i mutararâ hahaŋne bahuc muwec: “Moc e hazecheczi dâŋ keczi manazejec.” ");
INSERT INTO kmg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Eme motecfâcne jaŋe kesaic dâŋ irec fuŋnere wiocnepie jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Anuture uucmaŋko rarašire dâŋ soŋne i ŋoŋe mananiŋte mukicne, gâcne jaŋe ine kesaic dâŋ mananšepieŋ. Ehuc šâŋe fiipiehuc wiac mi hone taranšepieŋ â hazeczi dâŋ mana-bipiehuc fuŋne mi mana taranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kesaic dâŋ mupac irec fuŋne ine šiŋuc: Anuture dâŋzi hândâŋ ekac. ");
INSERT INTO kmg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hândâŋne hatao hewec sâc iŋucne juniŋmu jaŋe miti manapie maŋjeŋicko huhame izia, mana šakierâ juju bâfuanšipiŋte Sataŋzi fisi ro bawiseekac. ");
INSERT INTO kmg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Hândâŋne qânâ siecko hewec sâc iŋucne juniŋmu, jaŋe miti manarâ izia aŋac-jopaocmu. Eme maŋjeŋicko gâtâ mi bakicnere dameŋ bembeŋne mac bajuhapie eesâic fuame miti râpeckeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hândâŋne hofâ qinšiŋko hewec sâc iŋucne juniŋmu, jaŋe miti mamana i mananiŋmu, erâ sahackopec wiac irec mamaŋ gugutuŋ jupie moneŋ mafa mâriri irec aŋaczi miti hehâmome fârimâc eekac. ");
INSERT INTO kmg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hândâŋne mâreŋ guecko hewec sâc iŋucne juniŋmu, jaŋe miti manarâ maŋjeŋic emasaŋkerâ aimuŋ bajueŋgopieŋ, ehuc ɋic wânšâŋ erâ fârine bâfuaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mo ŋiczi lambe qazerâ kušizi hetutuckeocmu, me ŋeŋe rurumaŋko heme ŋeocmu? I aricne, lambe i ŋeŋe-ticnao hepene ŋehuc fic maŋne âke tamaeme ŋic jaŋe sâcne honehuc feniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wiac soŋsoŋ fokac i foku mi foocmu, i bataniŋkezo, â wiac hemackekicne fokac i foku mi foocmu, i qaratiezo, eme fuŋne jaŋgeŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Moc e wiac râcnekicne bajume kiqecnecnezo, â moc e wiac râcnekicne burec burec bajume jâoc rofârezo. Irec ŋoŋe miti hazec uruc jaha manapaŋkenšepieŋ” ");
INSERT INTO kmg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dameŋ mocko ŋic guru sâko Jesu orâŋkerâ domahapie neŋgoc ɋafâc-ticne warerâ ŋic jaŋerao quŋkerâ taic domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iŋuc epie ŋic moczi honec-joparâ Jesu šiŋuc âzâcnewec: “Neŋgoc ɋafâcge honecguniŋte juwic hae šoŋao domaŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mume Jesuzi ŋic šiŋuc jazawec: “Anuture dâŋ manarâ reŋkeeŋgopieŋ kecšizi neŋgoc ɋafâc-nane eŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ʒoaŋ mocko Jesu â motecfâcne wokeo fembiŋ. Wokeo ferâ šiŋuc jazawec: “Nâŋâc riqic fotâcnerâ ocniŋuc rašinaŋ.” Mume manapie rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Rahuc Jesu guŋte ecneme waha fowec. Fohame mâŋâŋ hâhâwicne qame riqic sâqoreme sirizi wokemaŋko hume riqicko huzo embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eme Jesu wiwickerâ šiŋuc âzâcnembiŋ: Qaqazu qaqazu, nâŋe riqicko huzo eŋgopeneŋ. Mupie fahare mâŋâŋ â siri dâŋ mujacteme niniŋkepire benoŋ bawec. ");
INSERT INTO kmg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eme šiŋuc jazawec: “Ŋoŋe mamanasiŋ-ŋeŋic weni.” Motec jaŋe ine wiac i honerâ tuc ŋeŋe farac erâ mumbiŋ: “Opo, e mo ŋic mo, irec mâŋâŋ â siri dâŋ jasame reŋkekopirec.” ");
INSERT INTO kmg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Eme raku riqic fotâcnerâ Galilaia mâreŋ ŋifecnao Gerasene ŋic jaŋerao fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ira fisirâ tiŋko feme haeonec ŋic moc warewec. Ŋic ere maŋko demoŋ bocjaha jupie dameŋ šora ŋaqi mi rojuwec â ficko mi fojujec. E mâc šâŋeruŋ gieo sasawa qac qâsoric juwec. ");
INSERT INTO kmg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eme Jesu honerâ owackerâ mâreŋko rândiŋke qa erâ dâŋ hahaŋne bahuc šiŋuc muwec: “Jesu, go Anutu femicne sâkore Ŋokâzi wemocte norao warekomec? Go šâic gie mi mac narezemec.” ");
INSERT INTO kmg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesuzi “demoŋ go ŋickonec wefu rac” mume iŋuc hâcne âzâcnewec. Demoŋ e dameŋ šora ŋic maŋne bâpuriŋkeme momori eme ŋic jaŋe me kikene qarâ soŋaŋ-ticne jumbiŋ. Eme demoŋzi ecneme repa hetâc qâtâcnerâ tuhuo wiserâ rajujec. ");
INSERT INTO kmg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eme Jesuzi wiocnerâ muwec: “Ʒâŋege mo?” Wiocneme muwec: “No šâŋe-nane Gurusâko.” Demoŋ bocjahazi ŋicmaŋko jumbiŋ irec. ");
INSERT INTO kmg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eme jaŋe Jesuzi hârâcko sorec-jopame hunšipiŋte mu wâwâsic ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eme mâreŋ ira bec guru sâko qondaŋ gieo jumbiŋ. Irec demoŋ jaŋe mana-jareme becmaŋko huniŋte âzâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Eme mana-jareme ŋickonec wefurâ becmaŋko humbiŋ. Iŋuc epie bec jaŋe heâŋkonec suackerâ ra duŋ riqic ŋewec ira hurâ hâmo-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Eme soŋaŋ jaŋe i honerâ gasacke rarâ ŋic hae gie sâc jurambiŋ dâŋ binaŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jazapie jaŋe ŋic demoŋ guru jâpecnekicne e honeniŋte fisi-fârembiŋ. Jesurao fisirâ honembiŋ: Ŋic demoŋ guruhec juweczi ŋaqihec â mamanahec Jesure maŋfuŋko ŋewec. Honerâ su bipic tatara ejareme domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Domahapie wiac hone manac embiŋ jaŋe ŋic demoŋhec juweczi biaŋkewec irec dâŋ binaŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eme Gerasene mâreŋ irec ŋic jaŋe boc hâwic-jopame Jesu e mâreŋ-jeŋic beherâ raocte âzâcnembiŋ. Âzâcnepie risieocte wokeo feme ");
INSERT INTO kmg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ŋic demoŋ jâpecnekicne eki bâjâpeocte numucnewec. Numucneme Jesuzi šiŋuc muhuc qataracnewec: ");
INSERT INTO kmg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Go wiacfâcge jaŋehec juhuc Anutuzi gorao mâsi sâko bakac irec biŋe ŋic jazazemec.” Mume ŋic e risierâ Jesuzi bâpiaŋkewec irec biŋe haefâc-ticne jaza-fârewec. ");
INSERT INTO kmg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ŋic jaŋe Jesure woŋec juhapie fisime honerâ ofac hecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ehame mitific soŋaŋ moc, šâŋene Jairo, e warerâ Jesure maŋfuŋko fodaperâ mu wâsic ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Otâ-ticne mocjaha jara-ticne 12 eha hâmozo ehuc fowecte Jesu hefârewec. Eme Jesuzi manarâ rahame ŋic jaŋe rošâc bâšâŋiŋ ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Eme ŋondeŋ-jeŋicko ŋokac moc juwec, e soc rohuc juhame jara 12 ewec. Eme dokta jaŋe bafickeniŋte bâipieku behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eme ŋokac eki hâcne Jesure râpefuŋko rarâ ŋaqi-ticne bâuawec. Bâuame izia socticne šickewec. ");
INSERT INTO kmg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eme Jesuzi wiorâ muwec: “Mozi bâuacnukac?” Mume ŋic jaŋe micke-fârepie Petorozi šiŋuc muwec: “Qaqazu, ŋic jaŋe rošâc bâšâŋiŋ egarehuc heuacguŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mume Jesuzi šiŋuc muwec: “Aricne, moczi bâuacnuhame tâpiri-nane rame manapac.” ");
INSERT INTO kmg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eme ŋokac e fuŋne-nane taniŋkekac murâ ɋarac ɋarac qahuc Jesure maŋfuŋko fodaperâ hucticnere dâŋ â bâuarâ izia ɋiɋic qawec irec dâŋ mâmâc mufuame mana-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eme Jesuzi šiŋuc âzâcnewec: “Otâ-mae, mamanasiŋgere biaŋgukac, buge âke mâteŋkeha rac.” ");
INSERT INTO kmg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iŋuc muhuc domahame mitific soŋaŋte fickonec dâŋ šiŋuc warewec: “Otâge hâmokac, irec qaqazu maŋgâŋ mi ecnetec warezejec.” ");
INSERT INTO kmg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eme dâŋ i Jesuzi manarâ soŋaŋ šiŋuc âzâcnewec: “Mi hâwicguoc, manasiŋnutec otâge biaŋkeocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iŋuc murâ ficko fisirâ gâcne hecke-jareme domahapie Petoro, Johane, Jakobo â naru neŋgoc mamac jahecne jaŋe sawa rocjopame rašimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eme ŋic ŋokac ki mamakuc ehuc domahapie šiŋuc jazawec: “Mi kioniŋ, naru e mi hâmojec, e mâc guŋ fokac.” ");
INSERT INTO kmg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eme jaŋe hâmo-jâmbâŋkewec i mana sanaŋkehuc gâwiecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eme Jesuzi naru menao rorâ wiracnerâ muwec: “Naru, go faharec.” ");
INSERT INTO kmg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mume izia maŋ qâqâtâc-ticne risieme faharewec. Fahareme nânâ râcnepie nâocte jazawec. ");
INSERT INTO kmg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eme neŋgoc mamacne jahe manapire hâhâwicne jâmbâŋ ewec. Eme Jesuzi irec biŋe ŋic mi jazaniŋte mu hezuc ejarewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesu e aposolo 12 hefârec-jopame fisipie ŋic demoŋ jâpe-jareniŋte â huc bâniniŋke-jareniŋte tâpiri qikiŋne-jarewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Erâ ŋic Anuture uucmaŋ irec dâŋ jazahuc huchec ɋiɋicne bacjopaniŋte sorec-joparâ ");
INSERT INTO kmg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","dâŋ šiŋuc mutâcne-jarewec: “Ŋoŋe hatao gunu me he me nânâ me moneŋ me ŋaqi jajahec mi bajunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hae mocko fisirâ fic feniŋmu ijaha ŋeŋe juju eku waha ranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Erâ mocko fisipie qikiŋ-ŋopapie hae i râpeckerâ gâc wândoc kike-ŋeŋickonec âteickepie wahame jaŋe fuŋne-jeŋic mananšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iŋuc muhuc jazame jaŋe šawierâ rambiŋ. Ehuc haene haene jufârehuc ŋic miti jazambiŋ â huc šâic bâniniŋke-jarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ŋicwofuŋ Herode e Jesuzi wiac ewec bawec, irec biŋe maname quŋkewec. I ŋic jaŋe kecšiŋuc mumbiŋte ewec: “Johane e hâmockonec ɋârewec juhuc wiac i bakac.” ");
INSERT INTO kmg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gâcnezi ine mumbiŋ, “Eliazi mocwâc fuawec jukac.” Á gâcnezi ine mumbiŋ, “Porofete mimiŋne moczi ɋârewec jukac.” ");
INSERT INTO kmg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mupie manarâ Herodezi šiŋuc muwec: “Johane e noni mupe upene hetâcnembiŋ. Ehame mozi iŋuc eme biŋene manaekopac?” Iŋuc murâ Jesu honeocte boc ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Eme aposolo jaŋe juku risierâ gie bambiŋ irec dâŋ binaŋ Jesu ecnembiŋ. Dâŋ binaŋ ecnepie Jesuzi rocjopame Besaida hae mâreŋko buc juniŋte rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Rapie ŋic jaŋe honec-joparâ bâjâpec-jopambiŋ. Erâ Jesurao fisipie âgo ejareme jumbiŋ. Juhapie Anuture uucmaŋ irec dâŋ jazawec, â huc šâichec ɋiɋicne bacjopawec. ");
INSERT INTO kmg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iŋuc ehuc juhame šoaŋ ŋetarazo eme motecfâcne jaŋe erao rarâ šiŋuc âzâcnembiŋ: “Ʒira tuhuo juŋgopeneŋte go ŋic râec-jopatec hae ŋerakac ira rarâ fic â nânâ bâfuanšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mupie šiŋuc jazawec: “Ŋaŋac moc nânâ gumec-jopaniŋ me!” Eme jaŋe šiŋuc âzâcnembiŋ: “Poroŋ memoc â opâ qowi jajahec iŋuc mac fonârekac. Irec weniŋuc enaŋ? Haeo rarâ ŋic guru sâko ši jaŋere nânâ sâcne furine banaŋmu me?” ");
INSERT INTO kmg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ŋic 5 tauseŋ jumbiŋte motec jaŋe iŋuc mumbiŋ. Mupie šiŋuc jazawec: “Ŋic ejarepie birine birine 50 qâzuckerâ ŋeranšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mume jaŋe ejarepie iŋuc epie ");
INSERT INTO kmg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","poroŋ memoc â opâ qowi jajahec rorâ sambâŋko fime fehame jambuŋkewec. Jambuŋkerâ poroŋ bazurâ motec jareme jaŋe bârâwiŋnerâ ŋic jarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eme jaŋe mâmâc sasawa nâ gapec efârembiŋ. Eme tiwâne ŋerawec, i ropie hurâ sasac 12 fusewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juku Jesu e motecfâc-ticne jaŋehec buc juhuc nunumu gie bawec. Eku wio-jarerâ muwec: “Ŋic jaŋe nore mo mueŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wio-jareme šiŋuc âzâcnembiŋ: “Gâcne jaŋe Johane Miti Opâ fufuŋke mugareeŋgopieŋ, gâcne jaŋe Elia mugareeŋgopieŋ, â gâcne jaŋe porofete mimiŋne moczi ɋârewec jukac, iŋuc mugareeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mupie jaŋacne indiŋ-joparâ muwec, “Á ŋoŋe ine nore mo mueŋgopieŋ?” Eme Petorozi šiŋuc muwec: “Go Anuturaonec Kristo jâmbâŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mume ŋic moc mi mufua-jareniŋte mic muac sanaŋne ejarewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Erâ šiŋuc šuhuckerâ Jazawec: “Ŋic Fâri Wâtuŋnezi Juku šâic serereŋ bocjaha manaocmu. Soŋaŋ â taha bapa micne â miti qaqazu jaŋe e kiarao qikiŋnepie qame hâmorâ šoaŋ jahec â moc eha fahareocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesu e ŋic mâmâc sâko-jeŋic šiŋuc jazawec: “Ŋic moczi no bâjâpecnuzo murâ maŋ sahac-ticnere dâŋ râpeckerâ maripoŋ-ticne šoaŋne šoaŋne hâporâ bâjâpecnuzejec. ");
INSERT INTO kmg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Moc e juju-ticne sakareme sifuckecneocmu â moc e nore erâ qikiŋneme fuacneocmu. ");
INSERT INTO kmg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Moc e mâreŋte wiac sasawa hure-fâreku kinduŋ bânduŋ bajuhame juju-ticne kihâmome sipirickeme wemo wiac fârine focneocmu? ");
INSERT INTO kmg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Moc e no nahacnere me miti-nanere maname mimi gaŋgaŋnehec eocmu, ine Ŋic Fâri Wâtuŋnezi Juku Mamac-ticne â tiri aŋelo jaŋere huririzi uucne erao riŋkehame sambâŋ tatamac-ticnehec fisirâ ŋic iŋucnere iŋuc Jaha maname mimi gaŋgaŋnehec eocmu. ");
INSERT INTO kmg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","No ine jâmbomac ŋazape mananiŋ: Domaŋgopieŋ ši jaŋeraonec gâcne hâmoc mi bâfuahapie Anuture Wofuŋ qâreŋ fua taniŋkeme honenšoŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesu e dâŋ i murâ juhame šoaŋ gie bapa 8 tarame numuocte Petoro â Johane â Jakobo rocjopame tikio fembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ferâ numuhame šâŋe mai-ticne hawarine fuŋmoc ewec. Ehame ŋaqi-ticne tamaerâ ɋaɋac taeŋne jâmbâŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eme mi ŋic jajahec fuarâ ehec dâŋ muc manac enšepieŋ i¡ Ŋic šâŋe-jekic Mose â Elia. ");
INSERT INTO kmg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jahe sambâŋ tatamac-jekichec fisirâ Jesu Jerusalem haeo mâreŋko juju-ticne jutararâ raocmu irec dâŋ mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Muhapie Petoro â âgo jahec-ticne jaŋe guŋ te mâretec ejare-bipieme šâŋe fitâcnerâ Jesu huriri qâreŋ-ticnehec â ŋic jahec ehec domapire honec-jopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eme jahe razo epire Petorozi Jezu šiŋuc âzâcnewec: “Qaqazu, sowine šira juŋgopeneŋ. Irec manatec boze jahec â moc banaŋ, gore moc, Mosere moc â Eliare moc.” E dâŋ mi mana tarahuc iŋuc muwec. ");
INSERT INTO kmg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Muhame karorac moczi waharâ sâoc-jopawec. Sâoc-joparâ foŋjopame motec jaŋe me kike fâfâc ehuc domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eme karorac maŋko dâŋ šiŋuc fuawec: “Keci joroc Ŋokâ-nane, ŋoŋe dâŋticne mananšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Eme dâŋ mana manahuc šâŋe firâ Jesu buc domame honembiŋ. Eme motec jaŋe wiac honembiŋ i dameŋ ira ŋic mi jajaza mâc maŋkerâ jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hae fureme tikionec wahapie ŋic guru sâkozi ehec bâbâfuac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eme izia ŋic jaŋere ŋondeŋkonec moczi šiŋuc muhuc Jesu wâsickewec: “Qaqazu, go dâŋnane manarâ ŋokâ-nane bafickec, e mocjaha mae. ");
INSERT INTO kmg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Manakic, demoŋ moczi hâpome ɋeŋfâfâc jaha owackeekac. Erâ ro fârec ecneme mic tâferu-ticne wefuekac. Eme demoŋzi motec jâpec mi bebehe ba âkejac ecneku mâretec bâdockeekac. ");
INSERT INTO kmg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eme motecfâcge jaŋe jâpecneniŋte numu-jarepe eipiembieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mume Jesuzi šiŋuc muwec: “O ŋicguru mamanasiŋ tâmiric â maŋsanaŋ, no ŋoŋehec hati jurâ ju ehuc âsi qataŋ eŋarepemu me? Ŋokâge bawarec.” ");
INSERT INTO kmg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Eme motec Jesurao barahame demoŋzi fâreme mi kikene miŋgeŋkewec. Eme Jesuzi demoŋ dâŋ mucneme wiseme motec biaŋkeme mamac-ticne râcnewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eme ŋic jaŋe Anutu tâpiri sâko-ticnere fuŋne honerâ warecke sâqorembiŋ. Eme ŋic jaŋe Jesuzi wiac ewec bawec irec wareckehuc juhapie Jesuzi motecfâcne bucko šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Dâŋ ši ŋazape manapaŋkeniŋ, Ŋic Fâri Wâtuŋne e ŋic jaŋere meo feocte dameŋ bembeŋkezo ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iŋuc muhuc jazame motec jaŋe dâŋ i manapie qeŋ bipinehec eme fuŋne kâuc bambiŋ. Erâ wiocneniŋte hâwic-jopame behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Motec jaŋe nâŋâcnaonec mozi micne sâko jukac muhuc hehefaric embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iŋuc epie Jesuzi maŋjeŋicte fuŋne manarâ motec piticne moc rorâ maŋfuŋnao râerâ ");
INSERT INTO kmg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","šiŋuc jazawec: “Moczi motec piticne kecšiŋucne moc nore erâ mamac rau ecneocmu, e no mamac rau enareocmu. Á no mamac rau enareocmuzi sorecnuwec e mâmâc mamac rau ecneocmu. Erâ ŋoŋeraonec moczi wahakicne jâmbâŋ juocmu, ere fekicne muzo.” ");
INSERT INTO kmg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eme Johanezi šiŋuc âzâcnewec: “Qaqazu, nâŋe ŋic moc gore šâŋe muhuc demoŋ jâpec-jopame honembeneŋ, erâ e nâŋerao šuhuckerâ go mi bâjâpecguekacte qataracnembeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mume Jesuzi šiŋuc âzâcnewec: “Mi qataracnezo. Gie-ŋeŋic mi hetâtiecmuzi âgo babafic-ŋeŋic eocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesu e sambâŋko risiocte dameŋ bembeŋkezo ehame Jerusalem haeo raocte mupaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mupaŋkerâ kiŋaŋ sorec-jopame bâniembiŋ. Bânierâ raku Samaria ŋic jaŋere hae mocko fisirâ Jesure biŋe fic moc bâfuaniŋte jazambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Eme Jesu e Jerusalem haeo raocmu, iŋuc manarâ fic sakarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Fic sakarepie motec jahec-ticne Jakobo â Johane jahe i manarâ Jesu wiocnerâ mupic: “Wofuŋ, go manatec mupere sambâŋkonec šoc waharâ šacjopazejec me?” ");
INSERT INTO kmg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mupire forisierâ qatara-jactewec. ");
INSERT INTO kmg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eme hae mocko rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Rahapie ŋic moczi bâfuac-joparâ Jesu šiŋuc âzâcnewec: “Go ira me ira razo mutecne bâjâpecgupemu.” ");
INSERT INTO kmg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mume Jesuzi šiŋuc âzâcnewec: “Qowi jaŋe hawec-jeŋichec, â sawa wipe jaŋe sareŋ-jeŋichec, Ŋic Fâri Wâtuŋne e ine fofo roŋgâŋ basaekac.” ");
INSERT INTO kmg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eme Jesuzi ŋic moc bâfuarâ šiŋuc âzâcnewec: “Go ware bâjâpecnuc.” Mume ŋic e šiŋuc âzâcnewec: “Wofuŋ, manatec qanaŋ rarâ mamac-nane duckezepac.” ");
INSERT INTO kmg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eme Jesuzi šiŋuc âzâcnewec: “Behec-jopatec qâŋɋâŋzia qâŋɋâŋfâc-jeŋic buc ducjopanšepieŋ. Go ine rarâ Anuture uucmaŋ irec dâŋ muromackezemec.” ");
INSERT INTO kmg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ŋic moczi ine Jesu šiŋuc âzâcnewec: “Wofuŋ, no bâjâpecguzore enarekac. Erâ manatec qanaŋ risierâ wiacfâc-nane mâzoc-joparâ warezepac.” ");
INSERT INTO kmg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mume Jesuzi šiŋuc âzâcnewec: “Moc e woke guriŋne bahuc rârâpe fiocmu, iŋucnezi Anuture uucmaŋko gie bapare sâc mi eocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Juku Jesuzi motec 70 bâwosâec-joparâ giedâŋ mujarewec. Ehuc e jahac haene haene raocte muwec ira jajahec jajahec bânierâ raniŋte sorec-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ehuc jaza muwec: “Qa roro giezi kâcɋene, gie bapa ŋic ine afecne. Irec ŋoŋe gie rune numucnepie gie bapa ŋic bâfuac-jopame gie-ticnao ranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ŋoŋe rahuc šiŋuc mananšepieŋ: Lama kâte qâto jaŋere ŋondeŋko mi sosorec-jopane i ŋoŋe sorec-ŋopakopac. ");
INSERT INTO kmg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eme ŋoŋe moneŋ kânoŋ me he me kikehuhu mi amecke ranšepieŋ. Erâ hatao ŋic bâfuac-joparâ dâŋ mi bacjopanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Fic mocko fezo ehuc rune šiŋuc jazanšepieŋ: `Fic kecšira wama fozejec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eme fic ira ŋic moc wamare biŋe jume wamadâŋ-ŋeŋicte fârinezi erao fotâcnerâ foocmu. Arictac eme wamadâŋ-ŋeŋicte fârine ŋoŋerao mocwâc risieocmu. ");
INSERT INTO kmg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fic feniŋmu ijaha ŋeŋe juju ehuc nânâ gumec-ŋopapie nânšepieŋ. Gie bapa ŋic wiac furimâc jare gumec ezo. Ŋoŋe ficbiri mi junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hae mocko fisipie hezu hewâneŋ eŋarehuc nânâ gumec-ŋopapie nânšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Erâ ŋic huchec ɋiɋicne bacjoparâ hae rune šiŋuc jazanšepieŋ: `Anuture uucmaŋzi maic-ŋopakac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hae mocko fisipie qikiŋ-ŋopapie hae šoŋao domahuc šiŋuc jazanšepieŋ: ");
INSERT INTO kmg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","`Gâc wândoc-ŋeŋic kike-nâŋecko bohotakac, i âteickepene waha foŋarezejec. Erâ ine šiŋuc mananiŋ: Anuture uucmaŋzi maic-ŋopame bâsuembieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","No ŋazape mananiŋ: Okac dameŋko Sodom haeonec katucne bawahahuc ejarezo â hae iŋucne jaŋe bafehuc ejarezo. ");
INSERT INTO kmg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Jei Koraziŋ rune, jei Besaida rune, ŋoŋerao mâsi hâhâwicne fuawec, iŋucne Tiro Sidoŋ haeo fuame muzac jaŋe mârâc jaha ki busâqoc ehuc maŋjeŋic bârisienšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Irec juku okac dameŋko Tiro Sidoŋ haeonec katucne bawahahuc ejarezo â ŋoŋe ine katucne bafehuc eŋarezo. ");
INSERT INTO kmg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Erâ Kafanaum rune, go sambâŋko bafecguo me? Aricne, go hârâcko tuŋguzo. ");
INSERT INTO kmg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ŋoŋere dâŋ manaocmuzi nore dâŋ manaocmu. Á ŋoŋe qikiŋ-ŋopaocmuzi no qikiŋnuocmu. No qikiŋnuocmuzi ine sorecnuwec e qikiŋneocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Motec 70 jaŋe juku risierâ šeri ehuc Jesu dâŋ binaŋ šiŋuc ecnembiŋ: “Wofuŋ, gore šâŋe muhuc demoŋ jâpe-jarepene micnâŋec reŋke-jâmbâŋkeŋgopieŋ i!” ");
INSERT INTO kmg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mupie šiŋuc jazawec: “Sataŋ e sambâŋkonec bâbâric iŋucne waha qame honepo. ");
INSERT INTO kmg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Manaŋgopieŋ, ŋoŋe homa â omeqaqa â râsire wiac šârâ hâriŋ irec faio âtepie mi sipiric-ŋopaocte tâpiri râe-ŋarepo. ");
INSERT INTO kmg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eme ŋoŋe ine demoŋzi micŋeŋic reŋkeŋgopieŋ irec mi šeri enšepieŋ, šâŋe-ŋeŋic sambâŋko qâreŋkekicne fokac irec šeri enšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eme dameŋ ijaha Tiri Mârozi Jesu bufahac qacneme šeridâŋ kecšiŋuc muwec: “Mamac, sambâŋ â mâreŋ rune, go mamana-jeŋicte manapie kâcɋene eekac ŋic i jaŋe mitidâŋge hesoŋke-jareekic, â maŋjeŋicte manapie gegecne eekac jaŋe ine mufua-jareekic, eme no irec muteŋgukopac. Go iŋuc fua biaŋ raocte mupaŋkemeŋ hâcne ine. ");
INSERT INTO kmg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wiac sasawa i Mamac-nanezi râe-nare-fârewec Eme ŋic moczi Ŋokâ mi šâŋitaekac, Mamaczi buc šâŋitaekac. Erâ Mamac iŋuc jaha ŋic moczi mi šaŋitaekac, ŋokâzi buc šâŋitaekac. Erâ Ŋokâzi ŋic moc Mamacte fuŋne mufuacneme e wâc šâŋitaocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iŋuc murâ motecfâcne jaŋacne šiŋuc jazawe: “Ŋoŋe wiac šâŋe furu honehuc jueŋgopieŋ irec šeri enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","No ŋazape mananiŋ: Porofete â ŋicwofuŋ bocjaha jaŋe ŋoŋe wiac hone manac eeŋgopieŋ i hone manac eniŋte ejare-bipiehame sifu mi hone manac embiŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sâcmutâc mamana ŋic moczi Jesu šiŋuc muhuc esâickewec: “Qaqazu, no weniŋuc erâ juju sanaŋte biŋe epemu?” ");
INSERT INTO kmg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mume Jesuzi okacne šiŋuc wiocnewec: “Sâcmutâc dâŋ weniŋuc fome woseekic?” ");
INSERT INTO kmg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wiocneme eki muwec: “Go maŋge â qâqâtâcge â tâpirige â mamanasuge i Wofuŋ Anutuge furu jaha qikiŋnecnetec fozejec, erâ go gahacne egareekac, sâc ijaha âgogere egarezejec, dâŋ iŋuc fokâc.” ");
INSERT INTO kmg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mume Jesuzi šiŋuc âzâcnewec: “Go dâŋ sâcne mukomec, i reŋkerâ juju sanaŋte biŋe ecmu.” ");
INSERT INTO kmg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eme ŋic e no maŋsioc tâmiric hawari ezepac muhuc harierâ Jesu šiŋuc wiocnewec: “Eme more manape âgo-nane ezejec?” ");
INSERT INTO kmg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mume Jesuzi binaŋ moc šiŋuc bacnewec: “Ŋic moczi Jerusalem haeonec Jeriko haeo rahuc râsi jaŋere somâmaŋko huwec. Eme jaŋe qarâ ŋaqi â mafa wiac-ticne jâoc rofârerâ behepie hâmozo ehuc fowec. ");
INSERT INTO kmg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fohame taha bapa moczi hata ijaha rarâ hone takirerâ jâuruwec. ");
INSERT INTO kmg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Eki rahame taha ufuŋte kiŋaŋŋic moczi ijaha ra fisirâ hone takirerâ jâuruwec. ");
INSERT INTO kmg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ehame Samaria mâreŋkonec ŋic furune moczi hata raku ŋic bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Erâ honerâ bune sâqoreme maŋfuŋnao rarâ wicticne wokemaŋ â waiŋ opâzi šure foŋ ewec. Erâ becâsic-ticnao râeme feme haeo bararâ tomaficko râerâ jauŋ bawec. ");
INSERT INTO kmg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hae fureme raocte tomafic rune 20 toea râcnehuc šiŋuc muwec: `Go ŋic kecši jauŋ bahuc juzemec, eme moneŋ garekopac mi sâckeme juku risierâ mocwâc šuhucke-garepemu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesu iŋuc murâ muwec: “Ŋic jahec â moc jaŋeraonec wenimo irec manatec ŋic qakicne ere âgo ewec?” ");
INSERT INTO kmg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wiocneme šiŋuc muwec: “Jauŋ bawec eki.” Eme Jesuzi šiŋuc âzâcnewec: “Go rarâ iŋuc hâcne ezemec.” ");
INSERT INTO kmg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu â motecfâcne jaŋe raku hae mocko fisipie ŋokac moc šâŋene Mata eki Jesu ficticnao hefârerâ hezu hewâneŋ ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Eme qoticne moc juwec šâŋene Maria, eki Wofuŋte maŋfuŋko waha ŋehuc miti-ticne manawec. ");
INSERT INTO kmg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata e šegoc giezi niŋgiŋkeme šanšaŋ bumbuŋ domahuc nânâ rike bâmoc ewec. Eku Jesurao rarâ muwec: “Wofuŋ, qonanezi behecnume kiŋaŋ no nahackoaŋ qape honetec mi sâqorekac me? Go âzâcnetec baficnuoc me!” ");
INSERT INTO kmg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mume Jesuzi kecšiŋuc âzâcnewec: “Mata, Mata, go wiac bocjahare mana mezac erâ šocne šâicne ehuc domakic. ");
INSERT INTO kmg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Manakic, wiac afecnezi sâckeocmu, â mocjaha fokac i tâmiric ine sâcne mi jujune. Maria fâri biaŋ hâcne ruckeocte wosâejec, i mi jâoc rozo.” ");
INSERT INTO kmg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesu e mocko ra numuwec. Numuku numu-fâreme motecfâcne jaŋeraonec moczi muwec: “Wofuŋ, Johanezi motecfâcne nunumu qazu-jarewec, iŋuc jaha goki moc qazu-nârec.” ");
INSERT INTO kmg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mume Jesuzi šiŋuc jazawec: “Ŋoŋe numuzo murâ kecšiŋuc numunšepieŋ: Mamac gore šâŋe tiri fozejec. Ware maŋ sâc mâreŋ sâc Wofuŋ enârec. ");
INSERT INTO kmg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʒoaŋ gie bapa sâc nânâ-nâŋec nârezemec. ");
INSERT INTO kmg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kiŋtofa-nâŋec behenârec, nâŋe iŋuc jaha ŋic jaŋere kiŋtofa beheŋgopeneŋ. Eesâicko mi râec-nâpozemec.” ");
INSERT INTO kmg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","I mutararâ moc šiŋuc šuhuckewec: “Ŋoŋeraonec moczi ŋafe šâšâŋiŋko rarâ âgo-ticne wiwickerâ šiŋuc âzâcneocmu: `Âgo-nane, go nânâ jahec â moc mac narec, ");
INSERT INTO kmg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","âgo-nane moczi hata juku norao ware fisime nânâ gumezore basakopac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iŋuc mume fic runezi ficmaŋkoa fohuc muocmu, `Go guŋ wiwic wemocte enârekic, ficmotâc kine bakicne â naru motec guŋ fofâreŋgopieŋ, irec wemocko faharerâ garepemu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesu e iŋuc murâ muwec, “No mupe mananiŋ, fic rune e ââgore mi manacneocmuo ine mic šoɋac-ticnere sifu faharerâ wiac mukac râcneocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Irec noni iŋuc jaha ŋifecne ŋazape mananiŋ: Numuku wiac roniŋmu, basaku fârine bâfuaniŋmu, motâcko heikepie aŋke-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Numuekaczi wiac roekac, basaekaczi fârine bâfuaekac, motâcko heickeekac e rocnezo. ");
INSERT INTO kmg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Me ŋoŋeraonec mo ŋiczi ŋokâ-ticne qowire mucneme irec okacne ɋâsu râcneocmu, ");
INSERT INTO kmg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","me qâqâc hândâŋte mucneme omeqaqa râcneocmu? ");
INSERT INTO kmg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eme ŋoŋe ŋic hehesicne iŋucnezi naru motecfâc-ŋeŋic nânâ mafa biaŋne jare gumec eeŋgopieŋko Mamac-ŋeŋic sambâŋko e sâc moc juekaczi Tiri Mârore numucnepie sâcne mi ŋareocmu me?” ");
INSERT INTO kmg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ŋic moc demoŋzi ecneme nâŋguŋ ewec. Eme Jesuzi ŋic e demoŋ jâpecneme mocwâc dâŋ dâŋ ewec. Iŋuc eme ŋic jaŋe honerâ wareckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eme gâcnezi ere šiŋuc mumbiŋ: “Demoŋ jaŋere ŋicbomboŋ Beezebulu eki neŋgoc ŋesiŋ ŋecnehame demoŋ jâpe-jareekac.” ");
INSERT INTO kmg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gâcne jaŋe ine hesuahuc mumbiŋ: “Go mutec sambâŋko fuŋne qaqa mâsi fuame honenaŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Eme eki maŋjeŋicko mana tararâ jazawec: “Mâreŋ moc ira šika kosa fuame hae sâc rârâsi efârepie tuhu fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sataŋzia fâuckerâ Sataŋ jâpeme gie-ticne weniŋuc sanaŋkerâ foocmu? Ŋoŋe nore šiŋuc muŋgopieŋ: Beezebuluzi neŋgoc ŋecnehame demoŋ jâpe-jareekac, irec mukopac. ");
INSERT INTO kmg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eme no Beezebulu ere neŋgoc ŋesiŋko demoŋ jâpe-jareekopacko, ŋaŋacne motecfâc jaŋe more ŋesiŋko demoŋ jâpe-jareeŋgopieŋ? Jaŋe hâcne qoqoric-ŋeŋicte fuŋne bataniŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Noni ine Anuture tâpirizi demoŋ jâpe-jareekopacko Anuture Wofuŋ qâreŋ ŋoŋerao fuakac hâcne. ");
INSERT INTO kmg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ŋic momorizi sându maro-ticnehec fic hae-ticne soŋaŋkeme wiac-ticne furu foocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ehame tâpiri sâkoheczi fisi hâporâ sându maro mamanac-ticne jâoc rorâ boreŋ mafa-ticne kâdoc qaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Moc e âgo mi enareocmuzi râsi enareocmu, â moc e gie-nane hone maiŋ mi eocmuzi hetâtieocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Demoŋzi ŋickonec wefurâ ra tuhuo miti qatarac juhuc ŋeŋe hae-ticne basaocmu. Basaku muocmu: `Ficnane beherâ warepo ijaha mocwâc risiepe. Ž ");
INSERT INTO kmg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Murâ risierâ honeocmu: Ʒure emasaŋ erâ bâpiaŋkekicne. ");
INSERT INTO kmg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iŋuc fome honerâ ra demoŋ âgofâc-ticne 7, e jahacne sâc mâcne, repipicne jâmbâŋ rocjopame ware fic ijaha ŋeŋe juju eniŋmu. Eme ŋic e mârâc sâqocne juweczi šâhec sâqore-jâmbâŋkeocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dâŋ iŋuc muhuc juhame ŋic ŋondeŋkonec ŋokac moczi wiwic jaha wiracnehuc muwec, “Rocgurâ moŋ gumec guwec ere manape šerine ekac.” Eme Jesuzi manarâ šiŋuc muwec: “I mukomec noni ine Anuture dâŋ manarâ bajuengopieŋ jaŋere hâcne manape šerine ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ŋic bocjaha erao qaja fusepie fuŋkera dâŋ šiŋuc jazawec: “Ŋicguru hehesicne šizi fuŋne qaqa mâsire fotarieeŋgopieŋ. Erâ ŋoŋe mâsi moc mâcne, Jonarao mâsi fuawec i sawa fuame honeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonarao wiac fuawec izi Niniwe haeonec ŋic fuŋne qaqa mâsi ejarewec, iŋuc jaha Ŋic Fâri Wâtuŋne erao wiac fuaocmu izi ŋicguru ši ŋoŋe fuŋne qaqa mâsi eŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Juwic mâreŋkonec ŋokac wofuŋ eki mumu tara dameŋko ŋicguru ši ŋoŋehec faharerâ fuŋne-ŋeŋic ritume katucne roniŋmu. Erâ i mâc mâcne, ŋokac e Salomoraonec mamana fârine roocte mâreŋ qaŋeŋnaonec warewec” eme mananiŋ, ši fuakac e Salomore sâc sirickekac. ");
INSERT INTO kmg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Erâ Niniwe haeonec ŋic jaŋe iŋuc jaha mumu tara dameŋko ŋicguru ši ŋoŋehec faharerâ fuŋne-ŋeŋic ritupie katucne roniŋmu. Erâ i mâc mâcne, Niniwe haeonec jaŋe Jonazi uŋ jazame manarâ maŋjeŋic bârisiembiŋ, â ši domakac e Jona sirickekac. ");
INSERT INTO kmg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ŋoŋe lambe qazerâ mi soŋkeeŋgopieŋ, me kušizi mi hetutuckeeŋgopieŋ, aricne, lambe ŋeŋe-ticnao hepie fic âke tamaeme ŋic ŋoŋe honehuc feeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sahacgere lambe ine šâŋege. šâŋege biaŋne fohuc sahacge batamaecneocmu, šâŋege sâqoreme sahacgezi tiŋtuŋ qaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eme maŋgao tatamac fokac izi dapâc ezacte aimuŋ soŋaŋkehuc juzemec. ");
INSERT INTO kmg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eme maŋ sahacge dapâc tâmiric tatamachec efâreocmuo furu jaha tamaeocmu, lambezi batamaecguekac irec sâc.” ");
INSERT INTO kmg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dâŋ i mutararâ juhame farisaio ŋic moczi Jesu nânâre ficticnao hefârewec. Hefâreme ficticnao ferâ izia nânâ teboo waha ŋewec. ");
INSERT INTO kmg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","I me sahac-ticne qanaŋ mi šurehuc iŋuc ewecte farisaiozi maname mi sâckewec. ");
INSERT INTO kmg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eme irec Wofuŋzi šiŋuc âzâcnewec: “Oi, farisaio ŋoŋe, oto râqâc-ŋeŋic šure ɋaɋackeeŋgopieŋ, maŋŋeŋicko ine nânâ mafare sasec â bâbâsifuczi fusucmakicne. ");
INSERT INTO kmg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","O ŋic mutucne ŋoŋe, wiac sasawa irec sahacne bâfuaweczi maŋne mi bâfuawec me? ");
INSERT INTO kmg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Irec ŋoŋe maŋkonec bâmec gie bâfuanšepieŋ, eme ŋoŋerao wiac sasawa wâwânâŋ tâmiric efâreocmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Oi farisaio, ŋoŋe hâwic-ŋopazac me, ŋoŋe wiac racne, romboc, wifu, qase â iŋucne gâcne i tucne Wofuŋte biŋe qahuc râeeŋgopieŋ, ehuc ŋifecne wiac fârine, mitio mubâtiŋ â Anutu sâsâse ine mi eeŋgopieŋ. Moc reŋkehuc moc reŋkezo. ");
INSERT INTO kmg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Oi farisaio ŋoŋe, mitificko ŋicbomboŋ ŋeŋeoa micne ŋeniŋte mueŋgopieŋ â hatao ŋic ŋokac omanezi bâfuac-ŋoparâ mu šeri eŋareniŋte irec maŋŋeŋic domaekac. ");
INSERT INTO kmg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Oi ŋoŋe šâŋeruŋ rârâŋnekicne iŋucne, ira ŋic Jaŋe mi manahuc fainao rac warec eeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesu e iŋuc mume sâcmutâc mamana ŋic moczi manarâ micnao rorâ šiŋuc muwec: “Qaqazu, go dâŋ iŋuc mutec sâcmutâc mamana nâŋerao wâc qacnekac.” ");
INSERT INTO kmg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mume Jesuzi okacne kecšiŋuc bâtikiecnewec: “Jei, sâcmutâc mamana ŋoŋe wâc hâwic-ŋopazac, ŋoŋe tagi bâmâckerâ ŋic fai-jeŋicko râehuc ŋaŋcne metariŋ jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Jei, mimiŋnefâc-ŋeŋic jaŋe porofete jopa sipiric embiŋ i jaŋere šâŋeruŋ ericke emasaŋ eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iŋuc ehuc mimiŋnefâc-ŋeŋic qâtec-joparâ šika-jeŋicte manapie biaŋkeekac Jaŋe jopa sipiric embiŋ â ŋoŋe ine šâŋeruŋ-jeŋicko ma âkendâŋne-jareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Irec hâcne Anuture mamana birio dâŋ moc šiŋuc fuawec: `No ŋoŋerao porofete â aposolo sorec-jopape fisipie gâcne jopa sipiric â jopa jâpec eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eme irec mârâc jaha ŋic fufua dameŋko fuŋkerâ porofete jopahuc socjeŋic sipiricke warekicne irec kiŋ i ŋoŋerao batarazo. ");
INSERT INTO kmg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ʒika i mârâc jaha Aberao fuŋkerâ sueme sue qawefuku Ʒekaria e taha ufuŋko alata fuŋko qahuc qatarakicne. No jâmbomac mupe mananiŋ, šika irec kiŋ i ŋic guru ši ŋoŋerao. batarazo. ");
INSERT INTO kmg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jei sâcmutâc mamana, ŋoŋe miti mamana tarare ki ŋic jowac rombiŋ. Ŋaŋac motâcko mi rašimbiŋ, â ŋic ŋokac rašizo mumbiŋ i jaŋe aka hejarembiŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dâŋ iŋuc murâ rahame miti qaqazu â farisaio jaŋe fuŋkerâ jume ju ecnehuc mu esâic ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ehuc micnaonec dâŋ moc wahame manapie bahacnehec eme qorickeniŋte ruc sanaŋ barâ jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ehame ŋic jaŋe erao fisi sâqorehuc keketeŋ domahuc kikeo ââtec embiŋ. Iŋuc ehuc domahapie fuŋkerâ motecfâc-ticne qanaŋ dâŋ šiŋuc jazawec: “Ŋoŋe farisaio hâmu goreŋ-jeŋicte bâec bacnehuc paŋsawa junšepieŋ. No maŋsioc-jeŋicte mukopac. ");
INSERT INTO kmg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wiac hemackekicne fokac i foku mi foocmu, i qaratiezo, â wiac soŋsoŋ fokac i foku mi foocmu, i bataniŋkezo. ");
INSERT INTO kmg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ŋoŋe dapâcko dâŋ kamierâ mueŋgopieŋ i juku šoaŋ ɋaɋacko ŋeratieocmu, â ficmaŋko ɋawe faio mueŋgopieŋ i juku šae sâkoo fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Âgofâc-nane, no šiŋuc ŋazape: Sahac-ŋeŋic sawa qarâ irec fainao wiac eŋareniŋte tâpiri basaniŋmu jaŋere mi hâwic-ŋopazejec. ");
INSERT INTO kmg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Á mocte hâwic-ŋopazejec, irec ŋazape mananiŋ: Hârâcko qa sâroc eŋareocte tâpiri focnekac, ere jâmbomac hâwic-ŋopaocte mukopac. ");
INSERT INTO kmg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sawa hehetâc wipe i wiac omane, i furine mi bazo. Eme Anutu e jaŋeraonec mocjaha mac qâoma mi ecneekac. ");
INSERT INTO kmg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Á ŋic ŋoŋerao ine qizec susuc-ŋeŋicte šare i wâc mana-fâreekac. Irec hâwicmâc junšepieŋ, ŋoŋe sawa hehetâc wipe mâcne, ŋoŋe ŋic. ");
INSERT INTO kmg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Erâ moc ŋazape mananiŋ: Moc e ŋic jaŋere maio muɋaɋacnuocmu e ŋic Fâri Wâtuŋnezi iŋuc jaha Anuture aŋelofâc jaŋere maio muɋaɋackeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Á moc e ŋic jaŋere maio mic bacnuocmu, e Ŋic Fâri Wâtuŋnezi iŋuc jaha Anuture aŋelofâc jaŋere maio mic baocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Moc e Ŋic Fâri Wâtuŋne musoriŋkeocmu, e sâqocne i bâtâmirecnezo, â moc e Tiri Mâro musoriŋkeocmu, e sâqocne i mi bâtâmirecnezo. ");
INSERT INTO kmg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Juku mitific-jeŋicko me kia jaŋerao bacŋopa rapie dâŋ ŋifecne weniŋuc munaŋmu muhuc mana mezac mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dameŋ ira dâŋ muniŋmu i Tiri Mârozi mufua-ŋareocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eme ŋic ŋondeŋkonec ŋic moczi Jesu šiŋuc âzâcnewec: “Qaqazu, hahac-nanezi mamacte merâfâc buc bajuekac, irec go âzâcnetec bârâwiŋnerâ tucne no narezejec.” ");
INSERT INTO kmg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mume Jesuzi šiŋuc âzâcnewec: “Mozi no soŋaŋ me kia râecnuwecte norao mukic?” ");
INSERT INTO kmg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iŋuc murâ dâŋ moc šiŋuc šuhuckewec: “Ŋoŋe buchâro junšipiŋte bâec bahuc maŋŋeŋic soŋaŋkenšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iŋuc murâ dâŋ herâricne moc šiŋuc jazawec: “Ŋicbomboŋ moc e kise mâriri sâko fuacnewec. ");
INSERT INTO kmg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Eme maŋticnezi šiŋuc muwec: `Wenac epemu? Kise fârine sâko fic wena guruckepe? Ž ");
INSERT INTO kmg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iŋuc murâ muwec: `Miŋecne manakopac, no kisefic heropierâ ɋâricne bâsokarâ barâ kise mâriri-nane hepe ŋeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Erâ maŋnanezi šiŋuc mupemu: No mâriri sâko fonarekacte ŋemac qamanahuc dameŋ šora aŋacnuha nâhuc juzepac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iŋuc mume Anutuzi šiŋuc âzâcnewec: `Mutuc go, ŋafe ši jaha jujuge gowac rozo. Eme wiac râe qâzuc emeŋ i more eocmu? Ž ");
INSERT INTO kmg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Moc e Anuturaonec maŋ mâriri mi focneha e jahacne biŋe nânâ mafa hure hemârec eocmu, e sâc ijaha fuacneocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Erâ motecfâcne šiŋuc jazawec: “Irec hâcne ŋazakopac, ŋoŋe juju-ŋeŋicte mana mezac ehuc šiŋuc mi munšepieŋ: `Wemo wiac ba nâc enaŋmu? Ž Me sahac-ŋeŋicte mu heŋɋâŋ ehuc šiŋuc mi munšepieŋ: `Wemo wiac rojunaŋmu? Ž ");
INSERT INTO kmg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nânâzi fârine mâcne, juju-ŋeŋiczi fârine, â ŋaqi qoruczi fârine mâcne, sahac-ŋeŋiczi fârine. ");
INSERT INTO kmg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ŋoŋe kâec kâec honecjopaniŋ, jaŋe he sarac mi eeŋgopieŋ â nâ rowaŋ â nâ ukic mi eeŋgopieŋ. Eme Anutuzi sifu nânâ bâfua-jareekac. Ŋoŋe ine wipe mâcne, ŋone ŋic. ");
INSERT INTO kmg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Me tâpiri-ŋeŋic moc fokacko mu waišoc ehuc juju dameŋ-ŋeŋic sâcne moc bâšoraniŋmu me? ");
INSERT INTO kmg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ŋoŋe wiac piticne iŋucnere eipierâ wemocte wiac gâcne sâkore mana mezac boc eeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ŋoŋe firindoac honeniŋ, e ŋaqi qoruc-ticnere gie mi baekac, erâ mupe mananiŋ, Salomo e eri qaraweŋ-ticneheczi hawari biaŋ iŋucne mi rojuwec. ");
INSERT INTO kmg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Eme kâteo âri wiac dodocne, miŋecgac iŋucne fuaekac, â tomâcko iŋucne mârâŋkeekac, i Anutuzi sifu mume hawari biaŋ fuaekac, ehuc ŋoŋere ŋaqi qoruc mi bâfuaocmu muŋgopieŋ, mamanasiŋ gogoroŋ ŋoŋe¡ ");
INSERT INTO kmg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Irec ŋoŋe maŋbahac-ŋopame šiŋuc boc mi munšepieŋ: `Wemo wiac ba nâc enaŋmu? Ž ");
INSERT INTO kmg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","I qâpuc mâreŋ sâc jaŋe maŋ mamanasu-jeŋic ira duckepie foekac. Ŋoŋe wiac i tâmiric sâcne mi juniŋmu, i Mamac-ŋeŋiczi manakac. ");
INSERT INTO kmg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ŋoŋe ine ere uucmaŋ fua tâcneocte maŋŋeŋic râepie domazejec, eme fainao wiac jabane i wâc fua-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Guru pitic ŋoŋe hâwicmâc junšepieŋ, Mamac-ŋeŋic e uucmaŋ izi ɋoroc-ŋopaocte maname sâckewec. ");
INSERT INTO kmg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ŋoŋe wiac foŋarekac i hapetac qikiŋne-jarenšepieŋ, erâ moneŋ kânoŋ sucketâc tâmiric bâfuanšepieŋ, erâ sambâŋko boreŋ šeŋaŋ fofo hati hurenšepieŋ. Ira ŋiczi fiuc mi roŋareniŋmu â wâfuzi mi sipiricke-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ʒeŋaŋ-ŋeŋic foocmu ijaha maŋŋeŋic foocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ŋoŋe kambaŋ-ŋeŋic qarâ lambe-ŋeŋic qazepie šazejec. ");
INSERT INTO kmg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ehuc kiŋaŋ motec jaŋe ŋicwofuŋ-jeŋiczi mâreŋ šorickonec risierâ motâcko heickeme biac rocneniŋte woŋec juniŋmu jaŋe iŋucne enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ŋicwofuŋ e risierâ kiŋaŋ motec maŋɋâri juhapie bâfuac-joparâ jaŋere maname biaŋkeocmu. No jâmbomac ŋazape: E gie qoruc-ticne jomarâ nânâ teboo râec-joparâ nânâ gumec-jopaocte kiŋaŋ qajareocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Me ŋafe šâšâŋiŋko me ŋafe furec hehec-jekicko risierâ maŋɋâri juhapie bâfuac-jopaocmu ine biaŋke-jâmbâŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ŋoŋe fuŋne šiŋuc mananiŋ, hae moc irec ŋic jaŋe râsi ŋafe ira fisiniŋmu, dameŋ iŋuc manarâ maŋɋâri jaha juhuc hae-jeŋic soŋaŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eme Ŋic Fâri Wâtuŋne e iŋuc jaha mi manasuniŋmu dameŋ ira fisiocmure šawierâ junšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesu e dâŋ iŋuc mume Petorozi wiocnerâ muwec: “Wofuŋ go kesaic dâŋ ši bucnâŋecte me mâmâc sâko-nâŋecte mukomec?” ");
INSERT INTO kmg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wiome Wofuŋzi dâŋ moc šiŋuc šuhuckerâ muwec: “Ŋicbomboŋ moczi kiŋaŋ qaqafâc-ticne jaŋere soŋaŋ moc râehuc šiŋuc âzâcneocmu: `No ra juhape go soŋaŋ-jopahuc dameŋkoa nânâ qowi sâcjeŋic jarehuc juzemec. Ž Eme e weniŋuc jume soŋaŋ maŋhec â micrereŋhec mucnezo? ");
INSERT INTO kmg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Soŋaŋ e gie mucnekicne i aijakic jaha bahuc juhame bomboŋ-ticnezi fisiocmu, soŋaŋ iŋucnere manape šerine ekac. ");
INSERT INTO kmg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","No jâmbomac mupe mananiŋ: E ŋic i soŋaŋ kâcɋene râehuc wiac-ticne mâmâc sasawa soŋaŋkeocte mucneocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Me ŋic e soŋaŋ sâqocne juhuctecne maŋnezi šiŋuc muocmu: `Bomboŋ-nane e jâpec mâcne, juku jaha risiezokac. Ž Iŋuc muhuc kiŋaŋ qaqa qa imac ejareocmu, â qâoma erâ wiac kosa ehuc juocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ehuc ŋicbomboŋ-ticne risieocmu dameŋ irec mi mamanasu nâme nikec juocmu, ine ŋicbomboŋ e ututuŋ fisirâ hetâc qâtâcnerâ miti bâbâsifuc ŋic jaŋere jujuo râeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kiŋaŋ motec moc e bomboŋ-ticnere micdâŋ mana-hâmo-bipiehuc qaqatara bâfuaocmu, e šika ŋemâcne kiocmu, ");
INSERT INTO kmg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","â moc e bomboŋ-ticnere micdâŋ kâuc bahuc qaqatara bâfuaocmu, e šika afecne kiocmu. Moc e wiac ŋemâcne râcne tahac ecnekicnezi fârine ŋemâcne jaha bâfuame sâckeocmu. Á moc e gie kâcɋene mucnekicnezi ɋicwânšâŋ kâcɋene jaha bâfuame sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","No mâreŋko šoc ruqepe šaocte wahapo. Erâ i biac bâruŋ-keocte bunane âeckeekac. ");
INSERT INTO kmg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","No opâ moc ruapemurâ munarekicne, eme i epe taraocte maŋnanezi šošoc fificne afecne mi enareekac. ");
INSERT INTO kmg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ŋoŋe nore šiŋuc mi munšepieŋ: `E wama bâfuaocte wahawec. Ž Aricne, no fâfâuc bâfuazore wahapo. ");
INSERT INTO kmg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Irec šiŋuczia fuŋkerâ kecšiŋuc fua raocmu: Fic moc irec ŋic 5 jaŋe fâuckerâ hehewic eniŋmu, ŋifec 2 â ŋifec 3. ");
INSERT INTO kmg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Erâ mame ŋokâ jahe fâuckerâ hehewic enicmu â neŋgoc otâ jahe fâuckerâ hehewic enicmu â jojoŋaozi fâuckerâ hehewic enicmu.” ");
INSERT INTO kmg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iŋuc murâ ŋic ŋokac mâmâc sâko-jeŋic šiŋuc jazawe: “ŋoŋe mâreŋ âke gâpâreme honerâ izia mueŋgopieŋ, `Hoe warekac. Ž Muhapie iŋuc eekac. ");
INSERT INTO kmg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mâreŋ emasaŋkeme honerâ mueŋgopieŋ, `Ʒoaŋ qaocmu. Ž Muhapie iŋuc eekac. ");
INSERT INTO kmg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Burecŋic, ŋoŋe karorac qânikiŋ irec fuŋne manaeŋgopieŋ, â dameŋ širec fuŋne ine wemocte mi mana taraeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ŋoŋe weniŋucte hata tiŋne â hehesicne hone šâŋitac mi eeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Go kisâgehec dâŋŋekic kiarao baranicmu. Eme hatao rahuc qizec qacnetec dâŋŋekic mufâsâezepirec. Iŋuc mi etec kisâgezi kiarao mume eki manarâ momori-ticne ecneme kâpâcwâru ficko râecguocmu. ");
INSERT INTO kmg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","No jâmbomac gazape: Go ira ŋeku mâc mi wefucmu, âgogere tofa bazutec tara-jâmbâŋkeme jaha wefucmu.” ");
INSERT INTO kmg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dameŋ ijaha ŋic gâcne fisirâ juhuc Jesu dâŋ binaŋ šiŋuc ecnembiŋ: “Pilatozi mume momorifâcne jaŋe Galilaia mâreŋkonec ŋic â bâzi ririkere lama bulimakaofâc-jeŋic mâmâc joparâ socjeŋic bâsifuckembiŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dâŋ binaŋ iŋuc ecnepie šiŋuc jazawec: “Ŋoŋe wiac ŋemâcne i ejarekicnere šiŋuc moc mupie: `Kiŋjeŋic Galilaia ŋic gâcne jaŋere kiŋ sirickewec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iŋuc mâcne, gâcne ŋoŋere kiŋ fokac jaha, irec maŋŋeŋic mi bârisieniŋmuo iŋuc jaha sipiricke-fâreniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Me Jerusalemnec ŋic 18 Siloam hârâczi ŋemac-jopawec jaŋere wâc šiŋuc mi munšepieŋ: `Kiŋjeŋic Jerusalem haeonec ŋic gâcne jaŋere kiŋ sirickewec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iŋuc mâcne, gâcne ŋoŋere kiŋ fokac jaha, irec maŋŋeŋic mi bârisieniŋmuo iŋuc jaha sipiricke-fâreniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dâŋ i mutararâ Jesuzi kesaic dâŋ moc kecšiŋuc muwec: “Ŋic moczi jufu-ticnao hâmeŋ moc sarame sokawec. Eme rune e fârine wasaocte ra basa jujec. ");
INSERT INTO kmg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eku jufu soŋaŋ-ticne âzâcnerâ muwec: `No jâc kecširec fârine basahuc juhape jara jahec â moc ekac. Jâc e maŋgâŋ wemocte boc domaocmu, qafaratec qaoc. Ž ");
INSERT INTO kmg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mume soŋaŋzi šiŋuc âzâcnewec: `Bomboŋ, go behehaŋ jara ši domaoc, ehame noni fuŋne kinoŋzi herâ jawa sânšâŋ hepe ");
INSERT INTO kmg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","dameŋ mocte fârine fuaocmu me aricne i honezeperec. Aricne eme šâhec mutec hefarazo. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesu e sabata hombaŋ mocte mitificko ferâ miti jazawec. ");
INSERT INTO kmg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eme mitific ira ŋokac moc ŋewec, e demoŋ moczi ecneme jara 18 ruruhuc jaha ŋeŋe juju ewec, ehuc wemocko moc fâretiŋnezac. ");
INSERT INTO kmg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Eme Jesuzi ŋokac e honerâ hefârerâ muwec: “Ŋokac go fâretiŋnecmurâ mukopac.” ");
INSERT INTO kmg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iŋuc murâ meticne qizecnao râeha izia fâretiŋnerâ Anutu muteŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu e ŋokac i sabata hombaŋko bâpiaŋkewecte mitific soŋaŋzi maname sâqoreme ŋic ŋokac jaza muwec: “Gie bapa 6 fokac ira warepie bâpiaŋ-ŋopazejec, hombaŋko ine misac.” ");
INSERT INTO kmg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mume Jesuzi dâŋ šiŋuc bâtikiecnewec: “Oi burecŋic ŋoŋe, hombaŋko doŋgi bulimakaofâc-ŋeŋic mi fickonec firuec-joparâ opâo bacjopa raeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ŋokac kecši e Abrahamte ɋâric, eme Sataŋzi niŋgiŋkeme jara 18 sâko ŋehuc juwec. Eme noni hombaŋko firuepe mi sâckekac me?” ");
INSERT INTO kmg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iŋuc mume kisâ ecnembiŋzi mimiembiŋ. Á ŋic ŋokac guru sâkozi ine mâsi biaŋ-ticnere šeri embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesu e dâŋ moc kecšiŋuc šuhuckerâ muwec: “Anuture uucmaŋ e wemo wiac iŋucne, wemohec sâc hepe? ");
INSERT INTO kmg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E nemuja hândâŋ iŋucne. Ŋic moczi i jufu-ticnao râeme âkešurâ jâc ewec. Eme sawa wipe jaŋe fisirâ tieŋnao herâ ŋeeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eme moc šuhuckerâ muwec: “Anuture uucmaŋ i wemohec sâc hepe? ");
INSERT INTO kmg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E hâmu goreŋne iŋucne. Ŋokac moczi hâmu goreŋne nânâhec bâsifuckeme aŋac-ticnezi nânâ isiricke-fârewec.” ");
INSERT INTO kmg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu e Jerusalem haeo raocte hae sâko hae pitic rahuc miti jaza qazuc ewec. ");
INSERT INTO kmg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ehame ŋic moczi wiocnerâ muwec: “Wofuŋ, ŋic afecnezi mecne sambâŋko feniŋmu, me weniŋuc?” Eme Jesuzi šiŋuc âzâcnewec: ");
INSERT INTO kmg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Motâc fâŋfâŋnao rašiniŋte sama qamariehuc rašinšepieŋ. No ŋazape mananiŋ: Ŋic bocjahazi rarašire muniŋmu, murâ sifu mi rašiniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Fic rune e motâc herâ ki bame ŋoŋe fisirâ râpenao domahuc heickerâ šiŋuc muniŋmu: `Wofuŋ, motâc ronârec. Ž Mupie šiŋuc ŋazaocmu: `No ŋoŋere kâuc bakopac, ŋoŋe wenirec? Ž ");
INSERT INTO kmg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wio-ŋareme okacne šiŋuc âzâcneniŋmu: `Nâŋe gohec juhuc nânâ opâ nâmbeŋ â hae-nâŋecko miti mutec manambeŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mupie šiŋuc ŋazaocmu: `Ŋazakopac i, ŋoŋe wenirec, no mi manac-ŋopakopac, sâqocne bapa ŋoŋe behecnu-fâreniŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eme Abraham, Isaka, Jakobo â porofete sasawa Anuture uucmaŋko juhapie honec-jopaniŋmu. Á ŋaŋacne ine qikiŋ-ŋopakicnere râpenao mic kikiaric kihuc ki oowa ehuc juniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ehame mâreŋ ŋifec â ŋifec, faic â juwic, irec ŋic fisirâ Anuture uucmaŋko raširâ tiwâ nâ šeri eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Manaŋgopieŋ, šâhecne jaŋeraonec gâcnezi bâbâni eniŋmu, â bâbâni jaŋeraonec gâcnezi šâhecne eniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dameŋ ijaha farisaio ŋic tucne fisirâ šiŋuc muhuc âzâcnembiŋ: “Herodezi guocte mukac irec mâreŋ ši beherâ biac rac.” ");
INSERT INTO kmg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mupie šiŋuc jazawec: “Ŋoŋe risie rarâ qâqâto e nore šiŋuc âzâcneniŋ: `Manakic, no miŋecgac â tomâcko ŋic demoŋ jâpe-jarepemu â ɋiɋicne bacjopapemu, fureme batarapemu. ");
INSERT INTO kmg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Miŋecgac â tomâc fureme hata rahuc juzepac. Porofete moc e Jerusalem haeo mi fisihame qaqane mi fokac. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Iŋuc murâ muwec, “O Jerusalem rune, go hâcne porofete šikazi jopahuc mitiŋic gorao sorec-jopakicne qânâzi hehâmoc-jopaekic. Qâqâczi motecfâcne qânusuc-joparâ fakecnezi ɋoroc-jopaekac, iŋuc jaha noni kikefuŋfâcge wemo afecne maŋfuŋ-naneo qânusuc-jopazo mupe qikiŋne warehuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Irec fic hae-ŋeŋic behepe tuhune fuazokac. Mupe mananiŋ: Ŋoŋe mocwâc mi hohonecnu juraku šiŋuc muhuc honecnunšoŋgopieŋ: `Wofuŋte micte warekac e mumbiaŋkenaŋ. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabata hombaŋ mocko farisaio jaŋere micne bapa moczi Jesu nânâre hefâreme ficticnao fewec. Eme ŋic gâcnezi ijaha mâmâc ŋehuc dâŋticnere ruc bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ehame ŋic moc sisiwiŋ sâko ecneweczi mi ferâ ijaha domazejec i. ");
INSERT INTO kmg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eme Jesuzi honerâ sâcmutâc mamana â farisaio wio-jarerâ muwec: “Ŋoŋe muniŋ, sabata hombaŋko ŋicko bâbâpiaŋ gie bapane fokac me mâcne?” ");
INSERT INTO kmg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mume niniŋkerâ ŋembiŋ. Iŋuc epie menezi ŋic bâuahuc bâpiaŋkerâ soreme rawec. ");
INSERT INTO kmg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eme ficko ŋembiŋ jaŋe šiŋuc jazawec: “Motec me bulimakao-ŋeŋic moc hombaŋko nombâŋko hume behepie ŋeocmu, me hombaŋkoa sifu fârepie wefuocmu?” ");
INSERT INTO kmg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Indiŋ-jopame dâŋ ŋifecne âzâcneniŋte basarâ behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Eme ŋic gâcne nânâre mâmâc hefârec-jopakicne jaŋe ŋeŋe mai jaha maŋjeŋicte erâ biac ŋepie honec-joparâ sâc hehuc dâŋ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Go ŋic moczi tiwâ bâzire hefârecgume maŋgere ŋeŋe mai jaha mi ŋezemec. Iŋuc ehaŋtecne hefârec-jopakicne gâcne jaŋeraonec gore femicne moczi fisime ");
INSERT INTO kmg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tiwâ runezi go šiŋuc gazaocmu: `I ere ŋeŋe, go rârierâ ŋec. Ž Gazame ŋeŋe rârâpe ŋehuc gâgâmârâcmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mâcne, moczi hefârecgume go ŋeŋe rârâpe ŋezemec. Ŋehaŋtecne tiwâ runezi honecgurâ šiŋuc gazaocmu: `Âgo, go ferâ ŋeŋe mai jaha ŋec. Ž Iŋuc gazame ŋic gâcne jaŋere maio bubiaŋ manacmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Moc e e jahacne maŋte feme bawahazo, â moc e e jahacne maŋte wahame bafezo.” ");
INSERT INTO kmg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iŋuc murâ ŋic hefârewec e šiŋuc âzâcnewec: “Go tiwâ bâzi rikerâ âgo bagofâcge me seŋ sâme hahac ɋafâcge me haefâcge fekicne mi hefârec-jopazemec. Jaŋe tiwâ bâzire hefârec-jopatec go iŋuc jaha hefârecgurâ tofa bazu-garepie taraocmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Iŋuc mâcne, tiwâ bâzi rikerâ waha qaqane â kike demba, šeke puriŋ â tiŋtuŋ, iŋucne hefârec-jopazemec. ");
INSERT INTO kmg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eme šiŋucte manariŋguzo: Tofa i mâc fome juku mitiŋic fafahare dameŋ-jeŋicko Anutuzi bazu-gareocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mume nânâ nâhuc ŋembiŋ jaŋeraonec moczi dâŋ i manarâ šiŋuc muwec: “Anuture uucmaŋko nânâ nâocmu ŋic iŋucnere manape šerine ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mume Jesuzi binaŋ moc šiŋuc bawec: “Ŋic moczi tiwâ bâzi sâko qame fisime ŋic bocjaha hefârec-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Erâ wiac bâmocke-fârerâ ŋic šâfo ejarekicne jaŋerao kiŋaŋ motec-ticne soreme rarâ šiŋuc jazawec: `Wiac rike bâmoc efârekicnere wareniŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jazame jaŋe wiac kosao ɋetickehuc qikiŋne-fârembiŋ. Ehuc moc e muwec, `No mâreŋ moc furine bapo izi fârecnukacte honezo rakopac, go irec ŋicbomboŋge âzâcnetec maname mi sâqorezejec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Á moc e muwec, `No bulimakao 10 furine bac-jopapo i ra amec-jopa warepemu, go irec ŋicbomboŋge âzâcnetec maname mi sâqorezejec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Á moc e muwec, `No ŋokac ropore wemocko fâpemu. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Iŋuc mupie kiŋaŋ moteczi risierâ bomboŋ-ticne dâŋ binaŋ ecneme maname gâpârewec. Erâ kiŋaŋ motec-ticne šiŋuc muhuc âzâcne sorec ewec: `Go bâruŋ jaha bozene bozene jufârehuc ŋic roroc qaŋqaŋne â kike demba, šeke puriŋ â tiŋtuŋ rocjopatec warenšepieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Eme kiŋaŋ motec e iŋuc erâ bomboŋ-ticne šiŋuc âzâcnewec: `Bomboŋ, go dâŋ mumec i epac, erâ fic ine fâfâoc fokac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Âzâcneme bomboŋzi šiŋuc muwec: `Irec go mocwâc rarâ haesoŋko ŋic juraŋgopieŋ fotarie-jaretec ware-jâmbâŋkerâ ficnane fusucmanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Erâ ŋazape mananiŋ: Ŋic bâbâni hefârec-jopakicne jaŋe mâc jâmbâŋ ŋenšepieŋ. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Eme ŋic guru sâko jâmbâŋ Jesu bâjâpepie fotikierâ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Moc e nohec juzo murâ neŋgoc mamac, ŋokac motec, hahac ɋa seŋ baŋec jaŋe mi qaisoc-jopaocmu, e motec jâmbâŋ-nane sâcne mi erâ juocmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Moc e jahacne maripoŋ mi hâpora bâjâpecnuocmu, e motec jâmbâŋ-nane sâcne mi erâ juocmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ŋoŋeraonec moczi wapafic sâko baocte qanaŋ furinere manarâ moneŋ-ticne wose biric erâ eene me mi eene irec fuŋne bataniŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Me iŋuc mi ehuc onšoŋ jaha ficticne wiseme hume šaeckerâ moneŋ basarâ beheocmuo ine ŋic jaŋe hone manac erâ mu gâgâwi ecnehuc ");
INSERT INTO kmg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","šiŋuc muniŋmu: `Ŋic keci fazic erâ ficsâko wiseme hume eipierâ beheme ŋekac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ŋicwofuŋ moczi ŋicwofuŋ âgo-ticne qaocte onšoŋ jaha râsi mi raocmu. E qanaŋ šiŋuc muocmu: `Nâŋe ši afecne juŋgopeneŋzi ocni bocjaha juŋgopieŋ jaŋe sâcne jopanaŋmu me mâcne? Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iŋuc murâ e jahacne momorifâc jaŋere maname afeckeme rasi-ticne hae-ticnao juhame biac sahac taha-ticne râecnehuc muocmu, `Wama fuame junac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eme ŋoŋeraonec moc e iŋuc jaha wiac-ticne sasawa mi qikiŋne-fârerâ weniŋuc motec-nane erâ juocmu. ");
INSERT INTO kmg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Hâwec i wiac aŋacne. Á nonocne eme ine weniŋuc ecnepene hâtâne-ticne mocwâc fuaocmu, i aricne i¡ ");
INSERT INTO kmg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Izi iŋuc me iŋuc eene mi fokac, i mâc hoŋkepene raocmu. Moc e hazec-ticneheczi dâŋ kecši manazejec.” ");
INSERT INTO kmg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takesi roro â sâqocne bapa Jesurao miti-ticne mananiŋte mâretec fisi jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Epie farisaio â miti qaqazu jaŋe irec manapie sâqoreme Jesure šiŋuc mumbiŋ: “Ŋic e sâqocne bapa rocjoparâ iqic-joparâ jaŋehec nânâ nâekac.” ");
INSERT INTO kmg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eme irec Jesuzi dâŋ suŋsuŋne moc šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ŋoŋeraonec moc e lama 100 jucneniŋmu. Eme mocsâkoazi qâsorieme beheocmu me? Aricne, e gâcne sâko 99 tuhuo behec-joparâ qâsoriekicne basaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Basaku bâfuarâ bubiaŋ manahuc âsickerâ ");
INSERT INTO kmg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","haeo fisirâ âgofâcne wira-jarerâ muocmu: `Lama-nane qâsoriekicne bâfuakopacte šeri enaŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No ŋazape mananiŋ, ŋic tiŋne 99 maŋ bâbârisiere mi mumu-jarene jaŋere erâ sambâŋko šeri aafecne fuaha sâqocne bapa mocjaha maczi maŋne bârisieme ere erâ sambâŋko šeri fekicne fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ŋokac moczi siliwa moneŋ 10 bajuocmu. Bajuhame mocjaha wahame beheocmu me? Aricne, e waha qazerâ fic ofaŋne qâzuc ehuc basaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Basaku bâfuarâ ŋokac âgofâcne wira-jarerâ šiŋuc jazaocmu: `Moneŋ-nane sifuckejec i bâfuakopacte šeri enaŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mupe mananiŋ, Anuture aŋelofâc jaŋe iŋuc jaha sâqocne bapa mocjahazi mac maŋne bârisieme bubiaŋ manaeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesuzi binaŋ moc šiŋuc bawec: “Ŋic moc ŋokâ jahec-ticne jajahec jupic. ");
INSERT INTO kmg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Juku šâhec ŋokâzi mamac-ticne šiŋuc âzâcnewec: `Mamac, go moneŋ mafa nore biŋe qakicne i narec. Ž Mume moneŋ mafa bâtâc barâ jactewec. ");
INSERT INTO kmg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eme šâhec ŋokâ e gie bapa afecne jurâ mafa wiac-ticne bâmockerâ ame susuckerâ rawec. Erâ ocna sasec gie bahuc nânâ qowire nâ areŋ ehuc moneŋ mafa-ticne ititiŋke-fârewec. ");
INSERT INTO kmg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ititiŋke-fârerâ juhame mâreŋ ira roroc sâko fuawec. Eme motec e kitac qatac eku ");
INSERT INTO kmg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","mâreŋ rune moc erao ra qohotame eki mume susubecfâc-ticne soŋaŋ-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ehuc bec jaŋere nânâ nâocte ecnewec i wâc sakarecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iŋuc juku maŋnezi mumu hehec ecneme šiŋuc muwec: `Mamac-nanere kiŋaŋ qaqa wemo afecne juŋgopieŋ, eme jaŋe nânâ nâqiŋ qâqiŋ ehuc juhapie no ŋokâ-ticnezi šira rorocte sipirickezo ekopac. ");
INSERT INTO kmg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Irec no hae-naneo rarâ mamac-nanerao fisirâ šiŋuc muhuc âzâcnezepac: Mamac, no sâqocne bape kiŋnanezi sambâŋko â gorao ŋemâckekac. ");
INSERT INTO kmg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Irec wemocko ŋokâge mocwâc munarepie jupemu, go mâc kiŋaŋ motecge bacnutec juzepac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iŋuc murâ šawierâ mamac-ticnerao rawec. Raku hae upeo fisihame mamac-ticnezi biac honerâ bune sâqoreme gasacke ra hâpo mumuduc ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eme motec e šiŋuc âzâcnewec: `Mamac, no sâqocne bape kiŋnanezi sambâŋko â gorao ŋemâckekac, irec wemocko ŋokâge mocwâc munarepie jupemu. Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iŋuc mume mamac-ticnezi kiŋaŋ motec jazarâ muwec: `Ŋoŋe picpac jaha ŋaqi biaŋne jâmbâŋ moc baware hecnepie huoc, â megâŋ menao hecnepie feoc, â kikehuhu mâmâc râcneniŋ. ");
INSERT INTO kmg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Erâ bulimakao motecne biuc sâko i hezu rikec epie nâhuc šeri enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ŋokâ-nane e hâmoweczi mocwâc ɋârekac, erâ e qâsorieweczi mocwâc fuakac. Ž Iŋuc mume šeri embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ehame mârâc ŋokâ e gieo juweczi risierâ hae râpeo domahuc gae â šeri mic šonšoŋ manarâ ");
INSERT INTO kmg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","kiŋaŋ motec moc ecneme fisime mu wioc ecnerâ muwec: `Wiac i wemocte? Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eme eki muwec: `Ɋage ware fisikac. Eme sahac furu fisikacte mamac-ŋekiczi mume bulimakao motecne biuc sâko i qa rikec eŋgopeneŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iŋuc âzâcneme mârâc ŋokâ e kimbeŋ qarâ haeo feocte qikiŋnewec. Eme mamac-ticnezi manarâ hae upeo hurâ mu bâmiriŋ ecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ecneme mi mamana šiŋuc muwec: `Manakic, no jara wemo afecne kiŋaŋ qagarehuc juhuc dâŋge moc mi qatara-gareekopac. Eme go noniŋ motecne mac moc mi qikiŋne-naretec âgofâc-nane jaŋehec nâ šeri embeŋ. ");
INSERT INTO kmg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Á šâhec ŋokâge e gore moneŋ mafa sasec gie bahuc sipiricke-fârewec, e iŋucnezi fisime mutec bulimakao motecne biuc sâko i hezu rikec ecneŋgopieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mume mamacnezi šiŋuc âzâcnewec: `Ŋokâ-mae, go dameŋ sâc nohec juwareekiczi wiac mi basaekic, wiac sasawa wirec-nâhec fokac. ");
INSERT INTO kmg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Á ɋage e hâmoweczi mocwâc ɋârekac, erâ e qâsorieweczi mocwâc fuakac, irec šeri bubiaŋ epene sâckekac. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesuzi motecfâc-ticne binaŋ moc šiŋuc bajarewec: “Ŋicbomboŋ sâko moc ere moneŋ mafa soŋaŋ moc juwec. Eme juku ere šiŋuc mupie manawec: `Soŋaŋ e mafa ro bâsifuc eekac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iŋuc manarâ hefârerâ âzâcnewec: `No gore dâŋ weniŋuc mupie manapac? Go iŋucnezi soŋaŋ mocwâc mi jucmurâ mukopacte papiage bawaretec moneŋ mafare fuŋne bataniŋkezo. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mume soŋaŋ e maŋnezi šiŋuc muwec: `Ʒi bomboŋ-nanezi soŋaŋ gie nowac rome wenac epemu? Gie he sarac ezore takicnukac, qafec qawahac juzore mimiekopac. ");
INSERT INTO kmg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Miŋecne manakopac, bomboŋ-nanezi jâpecnume ŋic âgofâc-nane hezu hefâroc enarepie ficjeŋicko ŋeŋe epemurâ wiac ejarezepac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iŋuc murâ bomboŋ-ticnere tofa bajumbiŋ i jaŋe buc buc hefârec-jopawec. Ehuc moc wiocnerâ muwec, `Bomboŋ-nanere tofa gorao wezimuc fokac? Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Eme eki muwec, `Qowitiŋ 100. Ž Mume šiŋuc âzâcnewec: `Ajoc, papia ši rorâ 50 qâreŋkec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Iŋuc murâ moc wiocnewec, `Bomboŋ-nanere tofa gorao wezimuc fokac? Ž Eme eki muwec, `Padi târu 100. Ž Mume šiŋuc âzâcnewec: `Ajoc, papia ši rorâ 80 qâreŋkec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iŋuc eme bomboŋ e manarâ soŋaŋ bâkiri bapa maŋfânâŋ-ticnere muteŋkewec. Miti tâmiric jaŋe âgofâc-jeŋic jaŋehec wiac eniŋte maŋfânâŋ-jeŋic kâcɋene fokac, mitihec ŋoŋe sâc iŋucne mi foŋarekac. ");
INSERT INTO kmg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Irec mupe mananiŋ, ŋoŋe iŋuc jaha moneŋ mafa jawane ŋic qikiŋne-jarepie jaŋe âgo bacŋoparâ juku i babaju dameŋne tarame juju sanaŋ ficjeŋicko hefârec-ŋopapie junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Moc e wiac omane metâo sâcne soŋaŋkeocmu, eki wiac fârine iŋuc jaha metâo sâcne soŋaŋkeocmu. Á moc e wiac omane bâsifuckeocmu, eki wiac fârine iŋuc jaha bâsifuckeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ŋoŋe moneŋ mafa jawane metâo sâcne mi bajupie wiac fârine mozi ŋareocmu? ");
INSERT INTO kmg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Á wiac jaba ŋarekicne i sâcne mi bajupie ŋaŋacne biŋe i mozi ŋareocmu? ");
INSERT INTO kmg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Motec mocjahazi jajahec jahere kiŋaŋ sâcne mi qaocmu. E moc âgo ecnehuc moc hone takireocmu, â moctao qohotahuc moc râpeckeocmu. Ŋoŋe iŋuc jaha Anuture gie mecne â moneŋ mafa qâqâhâc sâko irec gie mecne sâckoa sâcne mi bacjofaniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesu e dâŋ i mume farisaio jaŋe moneŋ mafare sasec embiŋzi manarâ dâŋticne surembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Epie šiŋuc jazawec” “Ŋoŋe hâcne ŋic jaŋere maio tiŋne hawari juniŋte šoɋac eeŋgopieŋ. Anutuzi ine maŋŋeŋicte fuŋne manaekac. Ŋic jaŋe wiac honepie tiŋne hawari eekac, i Anutuzi honeme mamakâcne eekac. ");
INSERT INTO kmg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sâcmutâc dâŋqâhâc â porofete dâŋ irec hata fowareku Johanerao mickewec. Irec faicnao ine Anuture uucmaŋ irec Biŋebiaŋ haŋ barakac. Eme ɋicwânšâŋ eeŋgopieŋzi rašieŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sambâŋ â mâreŋ jahe sirowezo murâ sirowenicmu, â sâcmutâc dâŋ irec huŋgaŋne mac moc mâc foku arictac eene ine mi fokac. ");
INSERT INTO kmg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ŋic moc e ŋonâŋ-ticne beherâ moc roocmu, e šušuhuc-jekic bâtâcnehuc kiŋsâko hureocmu. Á moc e ŋokac behekicne i roocmu, e iŋuc jaha šuhuc bâtâcte kiŋ hureocmu. ");
INSERT INTO kmg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ŋicbomboŋ moc juwec e ŋaqi erinehec furi sâko sasawa rojuwec, erâ šoaŋne šoaŋne tiwa šepec nâ šeri ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ehame ŋic hapetac moc juwec, šâŋene Lazaro. E sahacne wic sasawa. Eme eki ŋicbomboŋte fic rurumaŋko fojujec. ");
INSERT INTO kmg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ehame ŋicbomboŋte fickonec nâkitâc wahame i nâocte aŋac focne jujec. Fohame qâto jaŋe fisirâ wicticne apurumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Eme juku hapetaczi hâmome aŋelo jaŋe jowa ferâ Abrahamte qicfuŋko râepie juwec Eme šâhec ŋicbomboŋ e wâc hâmome duckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eme e hârâcko hurâ šâic fâro sâko manahuc fime feme Abrahamte qicfuŋko Lazaro honewec. ");
INSERT INTO kmg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Honerâ wirahuc muwec: `Abraham mamac-nane, nore buge sâqoreme Lazaro soretec mebotâŋne sawa opâo âke uruckerâ ware nameŋ-naneo bame mâteŋkezejec. No šira šocbâruŋko šâic serereŋ sâqocne manahuc jukopac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mume Abrahamzi muwec: `Ŋokâ-nane manakic, go mâreŋko aŋac faio jumeŋ i tarawec. Á Lazaro busâqoc faio juwec i iŋuc jaha tarawec. Eme irec e bubiaŋhec juekac â go ine šâichec juekic. ");
INSERT INTO kmg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Erâ wâc ŋondeŋ-nâŋecko hârâc sâko domakac, irec šireczi ŋoŋerao wemocko hufâzo â ŋoŋeraoneczi šira wemocko wefuzo. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Eme ŋicbomboŋzi muwec, `Mamac-nane, moc mupe mana-narec” ");
INSERT INTO kmg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ocna nore haeo ɋafâc-nane memoc juŋgopieŋ, jaŋe šâic haeo šira warenšipiŋte Lazaro soretec ra uŋdâŋ hazec qâuŋ jazazejec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mume Abrahamzi muwec, `Aricne, Mose â porofete jaŋere micdâŋ fokac i mananšepieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eme muwec, `Mamac-nane Abraham, iŋuc mâcne, hâmokicne moczi ra jazame maŋjeŋic sâcne bârisieniŋmu. Ž ");
INSERT INTO kmg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eme muwec, `Jaŋe Mose â porofete jaŋere dâŋ qikiŋneeŋgopieŋko hâmokicne moczi ra jazame iŋuc jaha qikiŋneniŋmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesuzi motecfâcne dâŋ moc šiŋuc jazawec: “Sâqocnere suru jâiŋ fufua i fuaocmu. weniŋuc mâc foocmu. Á ŋic moc sâqocnere suru jâiŋ bâfuaocmu, jei, e ine wemo ecnezo¡ ");
INSERT INTO kmg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","E ŋic hujukicne suru jâiŋ ejarezacte buse sâko upenao qonaŋkecnerâ hâwecko sârockepie hume muzac, izi wiac aafecne fuacnekac ezac. ");
INSERT INTO kmg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ŋoŋe soŋaŋ babac ehuc junšepieŋ. Âgoge moczi bahac bâfua-gareme tutuc qacnezemec. Tutuc qacnetec manarâ busâqoc bâfuame kiŋticne behecnezemec. ");
INSERT INTO kmg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Erâ šoaŋ mocjahao bahac arecne 7 bâfua-gararâ arec 7 gorao fisirâ muocmu, `Âgo, iŋuc egarepacte bunane sâqorekac,Ʒ eme go irec sâc jaha wâc kiŋticne behecnehuc juzemec.” ");
INSERT INTO kmg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposolo jaŋe Wofuŋ šiŋuc muhuc numucnembiŋ: “Go mamanasiŋ-nâŋec basawe-nârezemec.” ");
INSERT INTO kmg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mupie Wofuŋzi šiŋuc jazawec: “Mamanasiŋ fârine piicne mac, šocšu hândâŋ iŋucne mac foŋareme muzac, ine nemuja jâc kecocni, ŋeunuckerâ tararâ hâwecko huŋ domaocte âzâcnepie eki micŋeŋic reŋkerâ iŋuc ezac. ");
INSERT INTO kmg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ŋoŋeraonec moc e kiŋaŋ motec-ticne gie baku me bulimakao soŋaŋ juku owâ ririŋte fisime šiŋuc sâcne âzâcneocmu me? `Go ficko wefu ŋehaŋte nânâ rike bâmoc egarepe. Ž ");
INSERT INTO kmg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aricne, e šiŋuc âzâcneocmu: `Ajoc, kambaŋ ɋaɋacne qarâ ŋafere nânâ rike ŋec enaretec nahape šâhec go gahacne rike nâc ezemec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eme kiŋaŋ motec e gie mucnekicne i sawa bame bomboŋ-ticnezi mâc maname taraocmu, â muteŋ bâteŋ ine wemocko ecneocmu. ");
INSERT INTO kmg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eme ŋoŋere fuŋne ijaha fokac. ŋoŋe wiac muŋarekicne i efârerâ šiŋuc munšepieŋ: `Nâŋe kiŋaŋ motec ba bititicne, wiac munârekicne i Sawa mac epârâckeŋgopeneŋ. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu e Jerusalem haeo raocte Galilaia mâreŋ fotâcnerâ Samaria mâreŋ qaŋeŋnao fisiwec. ");
INSERT INTO kmg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Fisirâ hae mocko fehame ŋic wicsanaŋ-jeŋichec 10 jaŋe honerâ taic domahuc ");
INSERT INTO kmg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wira wâwâsic ecnehuc mumbiŋ: “O Qaqazu Jesu, go nâŋere mac buge sâqoreoc.” ");
INSERT INTO kmg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eme honec-joparâ šiŋuc jazawec: “Ŋoŋe rarâ sahac-ŋeŋic taha bapa jowatunšepieŋ.” Mume jaŋe raha rahapie sahac-jeŋic fâsâewec. ");
INSERT INTO kmg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Eme jaŋeraonec mocsâkoazi sahacne fâsâeme honerâ risiewec. Risierâ hahaŋne bahuc Anutu muteŋkehuc ");
INSERT INTO kmg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesure kikefuŋko fodaperâ daŋge âzâcnewec. Eme ŋic e Samaria mâreŋkonec ");
INSERT INTO kmg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Eme Jesuzi šiŋuc muwec: “Ŋic 10 fâsâembieŋ, gâcne sâko 9 jaŋe weni? ");
INSERT INTO kmg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Jaŋe risierâ Anutu daŋge âzâcneniŋte mi muhuc mâc qâoma erâ rahapie ŋic qâpuc keczi e mocjahazi warekac me?” ");
INSERT INTO kmg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iŋuc murâ ŋic e šiŋuc âzâcnewec: “Mamanasiŋgere biaŋkekomec, irec fahare rac.” ");
INSERT INTO kmg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisaio jaŋe Jesu wiocnerâ mumbiŋ: “Anuture uucmaŋ wezimucko fua tâcneocmu?” Eme jazawec: “Anuture uucmaŋ tâtâc mi fuaocmu, ");
INSERT INTO kmg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","irec wemocko honerâ šiŋuc muzo: `O šira fuakac, o ocna fuakac. Ž Manaŋgopieŋ, Anuture uucmaŋ i ŋondeŋ-ŋeŋicko fuawec fokac.” ");
INSERT INTO kmg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Erâ motecfâcne šiŋuc jazawec: “Juku dameŋ moc maickeocmu ira ŋic Fâri Wâtuŋne e šoaŋ mocjaha tâtâcko fuame honeniŋte eŋare-bipieha sifu mi honeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dameŋ ira kecšiŋuc ŋazaniŋmu: `O šira nâŋerao fuakac, o ocna jaŋerao fuakac. Ž Mupie mi ranšepieŋ â manapie jâmbomac mi ezejec. ");
INSERT INTO kmg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bâbâric e sambâŋ ŋifec bâricneme ŋifec qâninipe-fâreekac, irec sâc ŋic Fâri Wâtuŋne ere fifisi fuazokac. ");
INSERT INTO kmg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Qanaŋ ine ŋicguru ši jaŋe Ŋic Fâri Wâtuŋne râpeckepie šâic gie sâko baocte mucnekicne. ");
INSERT INTO kmg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noa juwec dameŋ ira ŋic jaŋe wiac embiŋ ijaha Ŋic Fâri Wâtuŋne ere fifisi dameŋ maickeha enšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jaŋe nânâ qowi nâmbiŋ, huc šocšu nâmbiŋ, ŋokac nareŋ gareŋ embiŋ. Qâoma iŋuc hâcne ehuc juhapie Noa wokeo feme rumi sâkozi fisirâ šeŋgoma bârârâŋ-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Á Loti juwec dameŋ ira iŋuc jaha embiŋ. Jaŋe nânâ qowi huc šocšu i nâmbiŋ, wiac nareŋ gareŋ i embiŋ, gie hesac qasarac i embiŋ, fic gie bapa i bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iŋuc ehuc juhapie Loti e Sodom hae râpeckeme sambâŋkonec kâmbâc â šoc wahame ŋic šeŋgoma sipirickembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ŋic Fâri Wâtuŋne e juku fua taniŋkezokac dameŋ ira ŋic jaŋe sâc ijaha eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Eme ira moc e hae šoŋao juocmuzi ficmaŋ-ticnao mi risie ferâ mafa-ticne rozejec, â moc e gieo juocmuzi haeo mi risiezejec. ");
INSERT INTO kmg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ŋoŋe Loti ŋonâŋ-ticnere manasunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Moc e juju-ticne ŋezickezo mume sifuckecneocmu, â moc e juju-ticne qikiŋneme e fuacneocmu. ");
INSERT INTO kmg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","No mupe mananiŋ, ŋafe ira ŋic jajahec fofo wirec fohapire moc rohuc moc qikiŋnezo. ");
INSERT INTO kmg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ŋokac jajahec nânâ sufiehuc ŋehapire moc rohuc moc qikiŋnezo.  ");
INSERT INTO kmg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ŋic jajahec gieo domahapire moc rohuc moc qikiŋnezo.” ");
INSERT INTO kmg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesu e dâŋ i mufâreme motec jaŋe wiocnerâ mumbiŋ: “Wofuŋ, i wena fuazokac?” Eme muwec, “Âsu gâreczi keŋwipe fârecjopame fisirâ tumaŋneeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eme motecfâcne jaŋe mi rokawehuc šoaŋ gie bapa sâc numecnehuc juniŋte irec Jesuzi binaŋ moc kecšiŋuc bajarewec: ");
INSERT INTO kmg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Hae mocko kia moc juwec, eki Anutu mecne â ŋic mecne araŋ mi bajarewec. ");
INSERT INTO kmg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Eme hae ijaha ŋokac hozec moc juwec, eki kia erao hâcne hati rarâ šiŋuc âzâcne jujec: `Go kisâ-nanere ŋezicnuc. Ž ");
INSERT INTO kmg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Eme kia e hozecte dâŋ dameŋ šora mana takirehuc juwec. Juku maŋnezi šiŋuc muwec: `No Anutu mecne â ŋic mecne araŋ mi bajareekopac i jâmbomac, ");
INSERT INTO kmg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","erâ hozec e micneneŋ sâqocne enarehuc juekacte sifu bafickezepac, juku fisirâ nuzackohec. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wofuŋ e binaŋ i bafârerâ muwec, “Kia râŋgeŋnezi dâŋ muwec i manaŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eme Anuture weniŋuc mueŋgopieŋ, e fuŋfuŋfâc-ticne ŋafe furec wâsickehuc jaha jupie šika ŋondeŋkonec mi batarac-jopaocmu me? Muŋgopieŋ, mana takirehuc juocmu me? ");
INSERT INTO kmg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aricne, e jume mi šoraha batarac-jopaocmu. Ŋic Fâri Wâtuŋne e juku mocwâc fisirâ mâreŋko mamanasiŋ bâfuaocmu me?” ");
INSERT INTO kmg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ŋic gâcne jaŋacne manapie tiŋne eha âgofâc-jeŋic mana wahac-jopambiŋ jaŋere qâqiŋdâŋ moc šiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ŋic jajahec taha ufuŋko ferâ numupic. Moc e farisaio â moc e takesi roro. ");
INSERT INTO kmg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisaio e hâŋ domahuc e jahacnere šiŋuc manasuhuc numuwec: `O Anutu, ŋic gâcne jaŋe šika qaeŋgopieŋ, fiuc serereŋ eeŋgopieŋ, sasec mamakâc eeŋgopieŋ. No jaŋe iŋucne mâcne, me takesi roro kecocni e iŋucne wâc mâcne. Eme no irec hâcne daŋge gazakopac. ");
INSERT INTO kmg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","No Sonda sâc irec gie bapa jajahec sowa juekopac â moneŋ mafa hurerâ teŋkonec wâŋte sâc mitire biŋe qaekopac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Takesi roro eki ine tuturuŋko domahuc fime feocte mimierâ menezi amecne bofackehuc šiŋuc numuwec: `O Anutu, ŋic sâqocne no mi mac behecnuzemec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Manaŋgopieŋ, takesi roro e Anutuzi kiŋticne behecne-fâreme ficticnao risiewec, farisaio e ine focnewec. Moc e jahacne maŋte feme Anutuzi bawahaocmu, â moc e jahacne maŋte wahame Anutuzi bafeocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eme ŋic ŋokac jaŋe ɋiefâc-jeŋic Jesurao amec-jopa rarâ mezi bâuac-jopaocte mupie motec jaŋe hâhâwic hejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesuzi ine hefârec-jopahuc muwec: “ŋoŋe behehapie naru motec norao wareniŋ, mi hecke-jareniŋ. Iŋucne jaŋe hâcne Anuture uucmaŋ biŋe qajarekicne. ");
INSERT INTO kmg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","No jâmbomac ŋazape: Moc e ɋie jaŋere sâc ehuc Anuture uucmaŋ mi biŋeckeocmu, e maŋnao mi rašiocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Eme soŋaŋ moczi Jesu wiocnerâ muwec: “Qaqazu biaŋ, no weniŋuc erâ juju sanaŋte biŋe epemu?” ");
INSERT INTO kmg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuzi muwec, “Biaŋne wemocte munarekomec? Biaŋne rune Anutu mocjaha. ");
INSERT INTO kmg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Erâ go sâcmutâc dâŋ manaekic, kecšiŋuc: Ŋowe ŋonâŋ ŋohe bebehec mi ezepirec, go šika mi qazemec, go fiuc mi rozemec, go micko âkec mi ezemec, go neŋgoc mamac jahecge sâsec-jofazemec.” ");
INSERT INTO kmg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mume soŋaŋzi šiŋuc muwec: “I ɋieo fuŋkerâ reŋke warehuc juekopac.” ");
INSERT INTO kmg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mume Jesuzi manarâ šiŋuc âzâcnewec: “Mocjaha fokac, i ezemec, go rarâ moneŋ mafage ŋic hapetac qikiŋne-jarezemec, eme sambâŋko boreŋ šeŋaŋ fua-gareocmu. Erâ ware bâjâpecnuzemec.” ");
INSERT INTO kmg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eme ŋic e moneŋ mafa ɋâfoŋne focnewecte dâŋ i manarâ bune boc sâqorewec. ");
INSERT INTO kmg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iŋuc eme Jesuzi honerâ muwec, “Moneŋ mafa mâririheczi Anuture uucmaŋko rašiniŋte ququŋkenehec boc eekac. ");
INSERT INTO kmg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelizi buŋic hawecnao raraši i wiac afecne, â moneŋ mafa mâririheczi Anuture uucmaŋko raraši i wiac ŋemâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mume manahuc domambiŋ ŋic i jaŋe mumbiŋ, “Hâc, eme mozi sambâŋko feocmu?” ");
INSERT INTO kmg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eme Jesuzi jazawec, “Wiac ŋiczi eniŋte quŋkeeŋgopieŋ i Anutuzi hatane bâfuaocte mi quŋkeekac.” ");
INSERT INTO kmg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eme Petorozi šiŋuc âzâcnewec: “Manakic, nâŋe wiac-nâŋec sasawa râpecke-fârerâ go bâjâpecgumbeŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mume Jesuzi šiŋuc jazawec: “No jâmbomac ŋazape: Moc e hae-ticne me ŋokac motecfâcne, me hahac ɋa seŋ baŋecfâcne, me neŋgoc mamac jahecne Anuture uucmaŋte erâ behec-jopaocmu, ");
INSERT INTO kmg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","e irec okacne šira mâreŋko wiac fekicne tahackezo, â juku sambâŋko juju sanaŋ tahackezo.” ");
INSERT INTO kmg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu e motecfâcne hefârec-joparâ šiŋuc jazawec: “Manaŋgopieŋ, nâŋâc Jerusalem haeo feŋgopeneŋ. Eme porofete jaŋe Ŋic Fâri Wâtuŋne ere findaŋdâŋ qâreŋkembiŋ i sanaŋke-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","E ŋic qâpuc jaŋere meo feme jaŋe mu ruruc ecnerâ qa imac ecnehuc tâfeckeniŋmu, ");
INSERT INTO kmg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","erâ becsahac biriŋneheczi qa qâšâic ecnerâ qahâmoniŋmu. Eme šoaŋ jahec â moc eha hâmockonec ɋârerâ fahareocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iŋuc mume jaŋe kâuc bambiŋ. Dâŋ i manapie quŋkeme fuŋne mananiŋte mana ririfirembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesu e raku Jeriko hae bâqiŋkewec. Ehame hatamecko ŋic tiŋtuŋ moc nânâ moneŋte numuhuc ŋewec. ");
INSERT INTO kmg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eme ŋic guru sâko hata ira rapie kike fânâŋ-jeŋic manarâ fuŋnere wiojareme ");
INSERT INTO kmg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","mumbiŋ, “Jesu Nazarete haeonec warekac.” ");
INSERT INTO kmg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mupie manarâ hahaŋne bahuc wirarâ muwec, “Jesu go Dawidire ɋâriczi nore mac buge sâqoreoc me!” ");
INSERT INTO kmg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iŋuc eme ŋic bâniembiŋ jaŋe niniŋkerâ ŋeocte dâŋ mucnembiŋ. Eme eki dâŋjeŋic mana takirehuc fotarierâ wirawec, “Go Dawidire ɋâriczi nore mac buge sâqoreoc.” ");
INSERT INTO kmg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eme Jesuzi manarâ hatao domahuc muwec, “Ŋoŋe norao bawareniŋ.” Mume tiŋtuŋzi erao fisime wiocnerâ muwec, ");
INSERT INTO kmg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“No wemo egarepemurâ mukic? `à Eme tiŋtuŋzi muwec, “Wofuŋ, no šâŋe fifihec epere enarekac.” ");
INSERT INTO kmg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mume Jesuzi šiŋuc âzâcnewec: “šâŋege fitâcneoc, mamanasiŋgere biaŋgukac.” ");
INSERT INTO kmg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Muha izia šâŋe fifihec ewec. Erâ Jesu bâjâpehuc Anutu muteŋkewec. Á ŋic wiac i homembiŋzi iŋuc jaha Anutu muteŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu e Jeriko haeo fisirâ fotâcnezo ewec. ");
INSERT INTO kmg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Eme hae ira ŋic moc juwec, šâŋene Zakaio, e takesi roro jaŋere micne, erâ moneŋ mafa sâko-ticnehec juwec. ");
INSERT INTO kmg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eme ŋic eki Jesu hawari-ticne honeocte ecnewec. Erâ e ŋic bembeŋnere ŋicŋondeŋko domahuc tiŋtiŋne-bipiewec. ");
INSERT INTO kmg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iŋuc erâ gagasac jaha ŋic jowaru-fârerâ ra nemuja hahaŋko ferâ ŋehuc šiŋuc muwec: “Jesu šira ware rame honepe.” ");
INSERT INTO kmg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eme Jesu e ira fisirâ fime feme honerâ šiŋuc âzâcnewec: “Zakaio go picpac wahac, no miŋecgac ficgao iqicgupemu.” ");
INSERT INTO kmg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mume izia picpac jaha waharâ bubiaŋ manahuc ficticnao jowame fepic. ");
INSERT INTO kmg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eme ŋic sasawa jaŋe i honerâ mana sâqorerâ mumbiŋ, “E wemocte ŋic sâqocnere ficko fejec fokac.” ");
INSERT INTO kmg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakaio eki ine Jesure maŋfuŋko rarâ muwec: “Manakic, Wofuŋ, moneŋ mafa-nane sâckoa bâtâc barâ tucne ŋic hapetac jarepemu, â ŋic gâcne moneŋ sâc jâuruhuc jowac ropo ine ropo sâc i fohame baferâ okacne bazu-jarepemu.” ");
INSERT INTO kmg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eme Jesuzi muwec: “Ŋic kecši Abrahamte ɋâric jaha, irec ere ficko miŋecgac miti fuame biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ŋic Fâri Wâtuŋne e ŋic sâqorekicne rocjoparâ bâpiaŋ-jopazore wahawec hâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesu e Jerusalem hae bâqiŋkeme ŋic dâŋticne manambiŋzi mumbiŋ, “Ʒi Anuture uucmaŋ fua taniŋkeocte dameŋne maickekac.” ");
INSERT INTO kmg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Eme irec Jesuzi dâŋ suŋsuŋne moc šiŋuc jazawec: “Ŋicbomboŋ moczi, ŋicwofuŋ sâkorao ra mupe mâreŋ soŋaŋ âkendâŋnume risiezepac, muhuc mâreŋ wiwicko rawec. ");
INSERT INTO kmg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Raocte kiŋaŋ motecfâcne 10 hefârec-joparâ moneŋfoŋ mocjaha mocjaha muhuc jarewec: `Ŋoŋe moneŋ ši kime kiŋ qahuc basawehuc juhapie risiezepac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Rahame ŋicfâcne ere takic-jopawecte ŋic kiŋaŋ sorec-jopapie šâhec rarâ ŋicwofuŋ sâko šiŋuc âzâcnembiŋ: `E mâreŋ soŋaŋ-nâŋec mi juocte muŋgopeneŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Eme ŋicwofuŋ sâko e sifu mâreŋ soŋaŋ âkendâŋneme risiewec. Risierâ kiŋaŋ motec moneŋ jarewec jaŋe šiŋuc muhuc hefârec-jopawec: `Moneŋ ŋarepo i giene bahuc hotâckekupie wezimuc fuawec? Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hefârec-jopame kiŋaŋ motec moczi fisirâ muwec, `Bomboŋ, go moneŋfoŋ mocjaha naremeŋ izi furune 10 kime fuawec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mume šiŋuc âzâcnewec: `Sowine kiŋaŋ motec biaŋne, go wiac omanere gie aimuŋ bameŋte noni hae 10 jaŋere soŋaŋ râecgupe juzemec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Iŋuc mume kiŋaŋ motec moczi fisirâ muwec, `Bomboŋ, go moneŋfoŋ mocjaha naremeŋ izi furune 5 kime fuawec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mume šiŋuc âzâcnewec: `Sâcne, go hae 5 jaŋere soŋaŋ juzemec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Eme kiŋaŋ motec moczi fisirâ muwec, `Moneŋfoŋge ši, no qoruczi foŋkerâ aimuŋ râepe fowec. ");
INSERT INTO kmg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Go ŋic gereŋ gereŋne, go gahac wiac mi hurehuc gâcnezi bâfuapie rozo muekic, â go gahac gie he sarac mi ehuc gâcnezi bapie fârine fuame nâzo muekic. Eme no irec araŋ bagarehuc moneŋge aimuŋ bajupo. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mume bomboŋzi šiŋuc âzâcnewec: `Kiŋaŋ motec sâqocne go, gahac dâŋ mumec ijaha bâtikie-garekopac” no ŋic gereŋ gereŋne, no nahac wiac mi hurehuc gâcnezi bâfuapie rozo muekopac, â no nahac gie mi he sarac ehuc gâcnezi bapie fârine fuame nâzo muekopac. ");
INSERT INTO kmg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Go fuŋne-nane iŋuc manahuc moneŋ-nane moneŋŋic jaŋerao râetec jaŋe kime kiŋ qakupie sawehame risierâ rozapo. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iŋuc murâ ŋic domambiŋ jaŋe šiŋuc jazawec: `Ŋoŋe moneŋfoŋ-ticne jâoc rorâ 10 bajukac e râceniŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eme jaŋe mumbiŋ, `Hâc, bomboŋ, e 10 bajukac i! Ž ");
INSERT INTO kmg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eme muwec, `No ŋazape mananiŋ, moc e wiac râcnekicne bajume kiqecnecnezo, â moc e wiac râcnekicne mi bajume jâoc rozo, eme mâc juzejec. ");
INSERT INTO kmg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Râsifâc-nane ŋicwofuŋ-jeŋic mi jupere muŋgopieŋ, ine bacjopa warerâ honehape jopa mizieniŋ. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesu e dâŋ i mufârerâ Jerusalem haeo fisiocte rawec. ");
INSERT INTO kmg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Raku Oliwa tikio ferâ Betefage â Betania hae bâqiŋ-jofawec. Ehuc motecfâcne jaŋeraonec jajahec šiŋuc muhuc sorec-jofawec: ");
INSERT INTO kmg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Hae rajecko ŋekac ira ranic. Rarâ doŋgi motecne niŋgiŋko domakac i bâfuanicmu. Motecne i ŋiczi fainao mi ŋekicne furune. Eme i bâfuarâ firuerâ bareniŋ. ");
INSERT INTO kmg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Firuepire ŋic moczi `wemocte rokopirec? Ž mume šiŋuc muhuc âzâcnenic: `Wofuŋzi irec mukac. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mume motec jahe rarâ muwec sâc bâfuapic. ");
INSERT INTO kmg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eme doŋgi firuepire rune jaŋe mumbiŋ, “Ŋohe wemocte goroŋkekopirec?” ");
INSERT INTO kmg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jahe mupic, “Wofuŋzi irec mume rokoperec.” ");
INSERT INTO kmg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iŋuc murâ Jesurao bararâ fainao ŋaqi-jeŋic râerâ Jesu sâsepie fewec. ");
INSERT INTO kmg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ferâ rame ŋaqi-jeŋic hatao rumacke rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eme Oliwa tiki heâŋnao huhuctecne kikefuŋ gurufâc-ticne jaŋe mâsi-ticne fuŋne fuŋne honembiŋ irec manasurâ šeri ehuc Anutu mucne bacnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ehuc fânâŋkehuc šiŋuc mumbiŋ: “Ŋicwofuŋ-nâŋec Wofuŋte micte warekac e mumbiaŋkenaŋ, faic sambâŋko wama bumâteŋ fokâc â hae faic micne ira šeri mumuteŋ fokac.” ");
INSERT INTO kmg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iŋuc muhuc fânâŋkepie farisaio moc moc ŋicŋondeŋko jumbiŋ jaŋe šiŋuc âzâcnembiŋ: “Qaqazu, qâjâpecfâcge qatara-jaretec beheniŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mupie jazawec, “No ŋazape mananiŋ, jaŋe niniŋkeniŋmuo qânâzi owackeniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Eme rarâ Jesu e Jerusalem hae mai jaha ŋeme hone-fârerâ bune herickeme kiohuc muwec: ");
INSERT INTO kmg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Go akio juhâmocmurâ irec hatane dameŋ šiŋuczia hone taranšaŋ me¡ Go ine šâŋege hâpokicnere wiac mi šâŋitaekic. ");
INSERT INTO kmg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Juku dameŋ moc maicgume râsi jaŋe fisirâ somâcgurâ ŋebâzicgupie nanamaŋ bititi erâ bâŋeŋkecmu. ");
INSERT INTO kmg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Erâ fic šoŋ hae šoŋ egarehuc motecfâcge qâmiziec-jopapie raŋe siaeŋ foraniŋmu. Eme haege ŋetâ qâtâtieme sesucne fuarâ foocmu. Anutuzi maicguha râpeckemeŋ, irec wiac i fua-gareocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dâŋ i mutararâ ra taha ufuŋko fewec. Ferâ wiac nareŋ gareŋ ehuc domambiŋ jaŋe šiŋuc muhuc jâpec-jopawec: ");
INSERT INTO kmg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Fic kecširec dâŋ šiŋuc mukic ne: Ficnane i nunumu fic ŋezejec, ŋoŋe ine epie fiuc sindaŋ jaŋere qânâuŋ-tinac ekac.” ");
INSERT INTO kmg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Eme šoaŋne šoaŋne taha ufuŋko miti jaza qazuc ehuc juwec. Ehame taha bapa micne â miti qaqazu â micne bapa sasawa jaŋe ine qapie arictac eocte dâŋne mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Erâ ŋic omane mâmâc sasawa miti-ticne manarâ erea boc ejarewecte quŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ʒoaŋ gie bapa mocko Jesuzi taha ufuŋko ŋic miti jaza qazuc ehuc juhame taha bapa micne â miti qaqazu â soŋaŋ jaŋe erao rarâ ");
INSERT INTO kmg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","šiŋuc âzâcnembiŋ: Go nâzâc, šira wiac eekic, i more micte eekic? Mozi iŋuc ecmurâ mugareme eekomec?” ");
INSERT INTO kmg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mupie jazawec, “No iŋuc jaha dâŋ moc wio-ŋarepe nazaniŋ, ");
INSERT INTO kmg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Johanere Miti Opâ gie i wenirec fuawec, sambâŋkonec me qickonec? Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iŋuc jazame jaŋe jaŋackoaŋ šiŋuc muhuc nazaŋ gazaŋ embiŋ: “Nâŋâc `sambâŋkonec fuawec, iŋuc mupene muocmu, `Hâc, eme wemocte dâŋticne mi mana šakiembiŋ? Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Me `ŋickonec fuawec', iŋuc mupene ŋic sasawa jaŋe manarâ qânâzi hehâmoc-nâponiŋmu. Jaŋe Johanere manapie porofete fârine ekac i!” ");
INSERT INTO kmg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Irec Jesu šiŋuc âzâcnembiŋ: “Hece, nâŋe Miti Opâ-ticnere fuŋne mi manaŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mupie Jesuzi šiŋuc jazawec: “Wiac murâ sâcne, eme noni iŋuc jaha, more micte šira wiac eekopac, okacne wâc mi ŋazapemu.” ");
INSERT INTO kmg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesu e ŋic dâŋ herâricne moc šiŋuc jazawec: “Ŋic moczi waiŋ gie sarawec. Sara-fârerâ soŋaŋ râec-joparâ mâreŋ wiwicko rarâ ira dameŋ šoricne juwec. ");
INSERT INTO kmg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Juku fârine fufua dameŋ maickeme kiŋaŋ motec moc fârine tucne roocte soreme ra fisime soŋaŋ jaŋe qa imac ecnerâ jâpepie metariŋ risiewec. ");
INSERT INTO kmg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Risieme runezi harierâ kiŋaŋ motec moc soreme rame iŋuc jaha wiac gâgâpâcne ecnerâ jâpepie metariŋ jaha risiewec. ");
INSERT INTO kmg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eme runezi harierâ kiŋaŋ motec moc soreme jaŋerao fisime šâpâ qarâ tuŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iŋuc epie waiŋ gie runezi manarâ muwec: `Ʒi wenac epe? Joroc ŋokâ-nane sorepe rame araŋ bacneniŋmu mecne. Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Eme soŋaŋ jaŋe ine ŋokâ-ticne honerâ nazaŋ gazaŋ erâ mumbiŋ, `Eki hâcne juku gie ši rauckeocmu, murâ qapene gie ši nâŋâcne ezejec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Iŋuc murâ kâteo tuŋke tuŋke rarâ qâhâmombiŋ. Eme gie rune e soŋaŋ weniŋuc ejareocmu? ");
INSERT INTO kmg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Manaŋgopieŋ, e warerâ soŋaŋ iŋucne jopa qâhâmoc ejarerâ gie-ticnao soŋaŋ furune râec-jopaocmu.” Eme jaŋe manarâ mumbiŋ, “Aricne, iŋuc mi ejâmbâŋkezo.” ");
INSERT INTO kmg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mupie Jesuzi hone dendeŋ-jopahuc muwec: “Miti dâŋɋâreŋ moc kecšiŋuc fokac i fuŋne weniŋucte? `Ficbapa ŋic jaŋe wâtuŋ surehuc behembiŋ, wâtuŋ izi mi jâmâ wâtuŋ ezejec i!' ");
INSERT INTO kmg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ŋic moczi jâmâ wâtuŋ ira herâ sahac-ticne imackeocmu, â wâtuŋzi ŋic mocte faio waha qaocmu ine qâgâreckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iŋuc mume miti qaqazu â taha bapa micne jaŋe šoaŋ ijaha kâpâcwâru baniŋte mumbiŋ. Jesu e dâŋ suŋsuŋne jaŋere muwec, i mana tararâ iŋuc ecnezo murâ ŋic jaŋere hâwic-jopame behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eme jaŋe Jesure ruc bahuc doc bapa ŋic erao sorec-jopapie rambiŋ. Eme ŋic izi hâcne miti hawari juhuc Jesu dâŋzi bitiŋ bacnepie kime kiarao râeniŋte ");
INSERT INTO kmg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","mu esâic ecnehuc mumbiŋ: “Qaqazu, nâŋe gore fuŋne manaŋgopeneŋ, go dâŋ sâcne nâza qazuc eekic, erâ fekicne fosâoc-jopahuc dâŋ mi muhasickeekic, ehuc Anuture hata jâmbomacko mutiŋne-nâreekic. ");
INSERT INTO kmg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Irec mutec mananaŋ, Roma ŋicwofuŋ takesi moneŋ râcnepene sâckeekac me mâcne?” ");
INSERT INTO kmg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mupie eeatuc-jeŋicte fuŋne mana tararâ muwec, ");
INSERT INTO kmg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ŋoŋe siliwa moneŋ moc bâfuarâ nowatupie honepe, ira more hawari â qâreŋ fokac?” Eme jaŋe mumbiŋ, “Roma ŋicwofuŋte.” ");
INSERT INTO kmg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eme jazarâ muwec: “Murâ ŋicwofuŋte biŋe i ŋicwofuŋ râcnenšepieŋ, â Anuture biŋe i Anutu râcnenšepieŋ,” ");
INSERT INTO kmg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iŋuc mume jaŋe dâŋticne batackerâ wemocko ŋic jaŋere maio qorickenšapiŋ. Irec mâc wareckerâ dâŋjeŋic fâsâewec. ");
INSERT INTO kmg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jaŋe rahapie sadukaio ŋic gâcne Jesurao fisimbiŋ. Ŋic i jaŋe, hâmockonec fafahare mi fokac, iŋuc muhuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jaŋe hâcne fisirâ Jesu dâŋ šiŋuc muhuc âzâcnembiŋ: “Qaqazu, Mose e dâŋ kecšiŋuc mutâcnewec, `ŋic moczi ŋokac rorâ ɋâric-ticne mi fuahame hâmome ɋanezi hozec-ticne rorâ hahac-ticnere biŋe ɋâric bâfuazejec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eme hahac ɋa 7 jumbiŋ, ehuc mârâc hahac-jeŋic ŋokac rorâ ɋâric tâmiric jurâ hâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hâmome ɋanezi hozec-ticne rorâ iŋuc jaha hâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hâmome ɋaticne moczi hozec i jaha rowec. Iŋuczi iŋuc hahac ɋa 7 jaŋe ŋokac i jaha rorâ ɋâric tâmiric hâmo-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Eme šâhecko hozec-jeŋic iŋuc jaha wâc hâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eme ŋic 7 jaŋe mâmâc sasawa ŋokac ijaha rombiŋte juku fafahare dameŋko more ŋonâŋ ezokac?” ");
INSERT INTO kmg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mupie Jesuzi šiŋuc jazawec: “Dameŋ šiŋuczia šira mâreŋko ŋic ŋokac roroc eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Juku dameŋ sâkoo Anutuzi mana-jareme sâckeha juju sanaŋte ɋârerâ faharenšoŋgopieŋ, ŋic ŋokac i jaŋe ine roroc mocwâc mi enšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wemocte? Jaŋe hâmockonec faharerâ Anuture naru motecfâc ehuc aŋelo jaŋe iŋucne hâmo hetiric mi ehuc furu jaha junšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hâmokicnezi ɋârerâ faharenšoŋgopieŋ, i Mosezi wâc šocbâruŋ jâc dutunao fuawec irec binaŋko mufuawec. E Wofuŋte šiŋuc qâreŋkewec: `E Abraham â Isaka â Jakobo jaŋere Anutu. Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ine hâcne, e hâmokicne jaŋere Anutu mâcne, e ɋâricne juju jaŋere Anutu, eki maname mâmâc sasawa jujune eŋgopeneŋ ekac hâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jesu e iŋuc muhuc jazame miti qaqazu gâcnezi mumbiŋ, “Qaqazu, go dâŋ mutecne biaŋkekac.” ");
INSERT INTO kmg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eme mocwâc mu esâic ecneniŋte manapie ŋemâckeme behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Eme Jesuzi šiŋuc muhuc esâic-jopawec: “Kristo e Dawidire ɋâric mueŋgopieŋ i weniŋucte? ");
INSERT INTO kmg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawidi e jahac miti mânec ɋâreŋkehuc kecšiŋuc muwec: `Wofuŋ e nore Wofuŋ šiŋuc âzâcnewec: Go ware fâre-naneo ŋehaŋte ");
INSERT INTO kmg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","no râsifâcge kikefuŋgao guruc-jopape kikegere ââtesiŋ enšepieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawidi e Wofuŋ-nane mucnewec izi weniŋuc erâ ɋâric-ticne ekac?” ");
INSERT INTO kmg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eme motecfâc-ticne ŋic maioa dâŋ decšiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ŋoŋe miti qaqazu jaŋere juju mi junšepieŋ. Jaŋe ŋaqi šora rojuhuc hatao ŋic bâfuac-jopapie mu šeri ejareniŋte maŋjeŋic domaekac. Ehuc mitificko â tutumaŋ ficko ŋicbomboŋ ŋeŋeoa micne ŋeniŋte mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iŋucnezi hozec jaŋere fic wiac kâŋgâc jowac roeŋgopieŋ, erâ nunumu šorazi hehesicjeŋic hefackeeŋgopieŋ. Ŋic i jaŋe juku okacne hâhâwicne ronšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu e qâhâŋnerâ fime rame mafaŋiczi taha katapao moneŋ-jeŋic râepie hume honewec. ");
INSERT INTO kmg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ehame hozec moczi fisirâ toea jajahec sawa râeme huwec. ");
INSERT INTO kmg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iŋuc eme Jesuzi honerâ jazawec, “No jâmbomac ŋazape: Hozec hapetac kecizi râekac i gâcne sasawa jaŋere sâc jâurukac. ");
INSERT INTO kmg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gâcne jaŋe neŋgocne sâko fojarehame tucne sawa mac râembieŋ. Á hozec e hapetaczi ine focnejec sâc râe-fârerâ mâc jâmbâŋ jukac.” ");
INSERT INTO kmg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tucne jaŋe taha ufuŋ qânâ erineheczi â taha geroŋzi bapie kiseŋ qâseŋ kirâ fowec i honehuc mu warec epie Jesuzi jazawec, ");
INSERT INTO kmg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Fic honeriŋ qâriŋ ecneŋgopieŋ i boc mi ŋeocmu. Dameŋ moc maickeme râsi jaŋe heropiepie ŋetâ qâtâtieme sesucne fuarâ fozokac.” ");
INSERT INTO kmg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eme jaŋe mumbiŋ: “Qaqazu, mukic i wezimucko fuazokac â irec dameŋ bembeŋkeme sowi weniŋucne fuazokac?” ");
INSERT INTO kmg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Eme Jesuzi dâŋ šiŋuc jazawec: “Maŋ bâsifuc eŋarenšipiŋte sawaŋ-ŋeŋic qahuc junšepieŋ. Ŋic bocjaha fuarâ nore šâŋe jaba bajuhuc muniŋmu: `No Kristo. Ž Á gâcnezi muniŋmu: `Dameŋ biac maickekac'. Eme ŋoŋe ŋic iŋucne jaŋere bâjâpecne mi junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Erâ šika biŋe â râsi fânâŋ manarâ jajaŋ bibisac mi enšepieŋ. Wiac iŋucne hâcne qanaŋ fuaocte mukicne, erâ fuame sifu dameŋ biac mi taraocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iŋuc murâ muwec: “Mâreŋne mâreŋne ŋic guru sâko guru pitic jaŋe rârâsi efârerâ ra qa ware qa ehuc qaqac ranšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Erâ homeŋ kâcɋene sâko samarierâ bazokac, erâ roroc â huc mimicne ra fua ware fua ezokac. Erâ sambâŋko sowi â wiac hâhâwicne fuazokac. ");
INSERT INTO kmg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wiac i mi fuahame jaŋe qanaŋ rocŋopaniŋmu â ŋopa jâpec eŋareniŋmu. Erâ wâc dâŋficko â kâpâcwâru ficko râec-ŋopaniŋmu â ŋicwofuŋ â kia jaŋerao bacŋopa raniŋmu, i ŋoŋe nore šâŋe bajuŋgopieŋte iŋuc eŋareniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eme ira fuŋne mumutaniŋ gie maic-ŋopaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eme jaŋere maio domahuc dâŋ weniŋuc mupene sâckeocmu muhuc mana wosâc mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","No nahac mic â mamana baafecke-ŋarepe dâŋ mupie kisâfâc-ŋeŋic jaŋe dâŋŋeŋic bawaharâ qatara-ŋareniŋte eipieniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Erâ omanezi sawa wiac mi eŋareniŋmu, neŋgoc mamac, hahac ɋa, seŋ sâme, âgo bago jaŋe wâc doc bacŋopaniŋmu. Eme ŋoŋeraonec gâcnezi šika kirâ hâmoniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eme ŋic mâmâc sasawa jaŋe šâŋe biŋe-nanere erâ ŋoŋere manapie aaricnehec eocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wiac iŋucne eŋarehapie noni ŋezic-ŋopape qizec susuc-ŋeŋic moc mi sifuckeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dodocke tâmiric juraku juju-ŋeŋic bâfuaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Momori jaŋe fisirâ Jerusalem hae somâckepie honerâ munšepieŋ, Miti hae qizec-nâŋec tuhu eocte dameŋne maickekac à ");
INSERT INTO kmg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eme Judaia mâreŋko juniŋmuzi tiki mâreŋko wiserâ ranšepieŋ, â miti hae qizecko juniŋmuzi iŋuc jaha biac waha wise ranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dameŋ ira hâcne okacne babazu fuaocmu. ehuc mitio dâŋ mukicne i fideteŋ efâreocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jei, ŋokac kiwecheczi â susuonecheczi dameŋ ira weniŋuc enšoŋgopieŋ? Ŋicguru ši jaŋerao kiŋ babatara fuame bâŋeŋkerâ weaŋsicne nâniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Eme râsi jaŋe ŋic gâcne šika mimicnezi jopa miziehuc gâcne mâreŋ sâc amec-jopa rapie kiŋaŋ qaqafâc-jeŋic erâ juniŋmu. Erâ qâpuc jaŋe Jerusalem haeo ima gie bahuc juhapie mâreŋ sâc ŋic qâpuc dameŋ-jeŋic hesackeocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Eme šâhecko šoaŋ mosa bâpiŋko wiac šâŋe furu fuazokac, â mâreŋko hâwec sirizi â temboŋzi fânâŋ sâko eme hazec furu-ŋeŋic fuazokac. ");
INSERT INTO kmg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Erâ wâc sambâŋ qiriŋ qame tâpirine ŋeŋgoroŋkezokac. Eme ŋic jaŋe wiac fua taraocte woŋec juhuc hobu-jeŋic taŋtaŋ âeckehame nokafe tataeŋ erâ domanšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ehame Ŋic Fâri Wâtuŋnezi karorac faio domahuc ɋuŋɋasaŋ bâric bâric-ticnehec fisime hone šâirenšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wiac iŋucne hâcne fuame honerâ qâhâŋnerâ fie ruruckehuc šiŋuc munšepieŋ: `Roroc-nâpo dameŋ maickekac hâcne. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iŋuc murâ dâŋ suŋsuŋne moc šiŋuc šuhuckewec: “Ŋoŋe jâmiŋ â jâc gâcne gâcne honehuc fuŋne mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Jaŋe gitec herâ fiepie honerâ mueŋgopieŋ: `Ʒoaŋ dameŋ maickezo ekac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eme wiac mukopac i fuame honerâ munšepieŋ: `Anuture uucmaŋ fua tâcnezo ekac. Ž ");
INSERT INTO kmg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","No jâmbomac ŋazape: ŋicguru ši jaŋe mi sirowehapie wiac mukicne i deŋke-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sambâŋ â mâreŋ jahe sirowezokopirec, â nore dâŋ ine mi sirowe-jâmbâŋkezokac. ");
INSERT INTO kmg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ŋoŋe nâ areŋ ehuc wiac omanere kirâ utuckerâ juhapie maŋŋeŋic bâzickeme dameŋ sâkozi bitiŋko kiki tinac ututuŋ jâmbâŋ kicŋopazacte sawaŋ-ŋeŋic qahuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dameŋ sâko e mâreŋ sâc ŋic ŋoŋe sâcŋopa-fârerâ acmâc jaha fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Irec ŋoŋe maŋguŋ tâmiric erâ hati numuhuc juhapie wiac fuaocte mukicne izi riric-ŋopame Ŋic Fâri Wâtuŋne e fisime ere maio qiŋ herâ domanšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesu e šoaŋko ŋic taha ufuŋko miti jaza qazuc ehuc juwec. Ehame hae owâeme hae beherâ Oliwa tikio ferâ ira fojujec. ");
INSERT INTO kmg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eme hae fure pârâckeme ŋic ŋokac sasawa jaŋe miti mume mananiŋte biac taha ufuŋko tumaŋne jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Goreŋ sowa juhuc aakic hombaŋ ŋeŋe irec dameŋ bembeŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ehame taha bapa micne â miti qaqazu jaŋe ŋic araŋ bajarembiŋte Jesu weniŋuc ecnepene arictac ezejec muhuc hata basahuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iŋuc ehuc juhapie Sataŋzi Jesure motec moc šâŋene Juda Karioto haeonec ere maŋko hume ");
INSERT INTO kmg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","taha bapa micne â ufuŋte polismaŋ micne jaŋerao rarâ Jesu doc bame roniŋte dâŋ mumocke-jarewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eme jaŋe manarâ bujeŋic biaŋkeme furine moneŋ râcneniŋte mujomirembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mupie dâŋjeŋic reŋkehuc ŋic jaŋe hone manac mi ehapie soŋsoŋko doc bame roniŋte hone qatarac ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ehame goreŋ sowa juhuc aakic lama hezuniŋte hombaŋ maickeme ");
INSERT INTO kmg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesuzi Petoro â Johane šiŋuc muhuc sorec-jofawec: “Ŋohe rarâ aakic lama hezu rikec ehapire fâpene nânšepeŋeŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mume jahe šiŋuc muhuc wiocnepic: “Fic wena hezu rikec ezeperec?” ");
INSERT INTO kmg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eme šiŋuc jasawec: “Mananic, ŋohe haeo ferâ ŋic moc opâ râqâchec bâfuarâ bâjâperâ, ficko feme fenic. ");
INSERT INTO kmg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ferâ fic rune šiŋuc âzâcneniŋ: `Qaqazuzi gore šiŋuc mukac, fic maŋne wena motecfâc-nane jaŋehec aakic lama nanaŋmu? Ž ");
INSERT INTO kmg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iŋuc âzâcnepire fic maŋne kâcɋene moc ŋeŋe fofo wiac rumacke emasaŋ ekicne ŋofatume ira aakic lama rike bâmoc ezepirec.” ");
INSERT INTO kmg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eme jahe rarâ wiac muwec sâc bâfuarâ aakic lama rike bâmoc epic. ");
INSERT INTO kmg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eme nâzo dameŋ maickeme motecfâcne gâcne rocjopame fisirâ nâmbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ehuc šiŋuc jazawec: “Ʒâic dameŋ-nanezi bâmbeŋnuhame aakic lama ši ŋoŋehec nâpemurâ boc enarejec. ");
INSERT INTO kmg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","No mupe mananiŋ: No aakic lama mocwâc mi nânâ juhape Anuture uucmaŋko fâri fideteŋ eocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iŋuc murâ waiŋ râqâc rorâ daŋge murâ šiŋuc jazawec: “Ŋoŋe rorâ nâ nareŋ gareŋ eniŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","No ŋazape, waiŋ opâ mocwâc mi nânâ juhape Anuture uucmaŋ fua tâcnezokac.” ");
INSERT INTO kmg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dâŋ i murâ poroŋ rorâ daŋge murâ bazurâ šiŋuc muhuc jarewec: “Kecši fâri-nane, i ŋoŋere erâ qikiŋnekicne. Nore manasuhuc iŋuc nânšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nânâ nâpie waiŋ râqâc rorâ iŋuc jaha jarehuc muwec: “Râqâc kecšira šâšâfic ɋâricnere socnane ŋekac. I ŋoŋere erâ qikiŋnekicne.Ý ");
INSERT INTO kmg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Erâ manaŋgopieŋ, doc bacnuocmu eki nohec tebo šira wiac mâmâc ro nâc ehuc ŋekoperec. ");
INSERT INTO kmg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ŋic Fâri Wâtuŋne e hata mušâwecnekicne ijaha raocmu. Á doc baocmu e ine, jei okacne mo iŋucne roocmu.” ");
INSERT INTO kmg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iŋuc mume motec jaŋe guru-jeŋickonec mozi i eocmu muhuc wiwioc embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eku wâc motec jaŋe nâŋâcnaonec mozi femicne-nâŋec jukac muhuc hehefaric embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Epie Jesuzi šiŋuc jazawec: “Mâreŋ ŋicwofuŋ jaŋe ŋiczi kiŋaŋ qajareeŋgopieŋ â fekicne sâko jaŋe omanezi mumbiaŋ-jopaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ŋoŋerao ine iŋuc mi fuazejec. Ŋoŋerao kâcɋenezi piticnere sâc juzejec, â micnezi kiŋaŋ qaqare sâcko juzejec. ");
INSERT INTO kmg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Me ŋoŋe muniŋ, wenimo izi fekicne? Nânâ mâc ŋehuc nâocmu eki fekicne, me rike bâmoc eocmu eki fekicne? Mâc ŋehuc nâocmuzi fekicne, i manaeŋgopieŋ. Noni ine ŋoŋere ŋondeŋko kiŋaŋ qaqa iŋucne erâ juekopac. ");
INSERT INTO kmg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ŋoŋe hâcne šârâ hâriŋ maŋko jupe jujufâc-nane jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eme Mamac-nanezi guriŋ bapa gie munarewec iŋuc jaha noni ŋoŋe muŋarekopac, ");
INSERT INTO kmg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ŋoŋe nore uucmaŋko tiwâ nâ šeri eniŋte â ŋicwofuŋ ŋeŋeo ŋehuc Israe ŋicguru 12 jaŋere dâŋ mutaraniŋte. ");
INSERT INTO kmg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoŋ, Simoŋ, padi saja bapie wosâeekac iŋuc jaha Sataŋzi ŋoŋe ere meo fepie saja bacŋopaocte mujec. ");
INSERT INTO kmg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Eme noni ine mamanasiŋge omaezacte gore erâ numupac. Irec go miti hatao mocwâc risierâ qomâfâcge keteŋ-jopazemec.” ");
INSERT INTO kmg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mume Petorozi šiŋuc âzâcnewec: “Wofuŋ, go kâpâcwâruo me hâmocko fâtec fâpemu.” ");
INSERT INTO kmg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eme Jesuzi muwec, “Petoro, no gazape manac, qâqâczi miŋecgac ŋafeo mi dâŋehame goki jahec â moc micnucmu.” ");
INSERT INTO kmg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iŋuc murâ muwec, “Noni moneŋ tâmiric â he tâmiric â kikehuhu tâmiric sorec-ŋopape ra basac qasac moc embiŋ me?” Eme jaŋe mumbiŋ, “Iŋuc aricne jâmbâŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mupie šiŋuc šuhuckewec: “Á dameŋ šiŋuczia ine moc e moneŋ focnekacko ro bajuzejec, â moc e hemotec focnekacko rupe juzejec, â moc e šika basahuc ŋaqi qikiŋneme moc kitâcnecnezejec. ");
INSERT INTO kmg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","No mupe mananiŋ, findaŋdâŋ moc šiŋuc qâreŋkekicne: `E šika qaqa jaŋere guruo râembiŋ', dâŋ i norao fârinehuc eocmu. Erâ nore dâŋ mukicne i mâmâc sasawa sanaŋke-fâreocte dameŋ maickekac hâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mume motec jaŋe šiŋuc âzâcnembiŋ: “Wofuŋ honec, ši šika jajahec fokopirec.” Eme muwec: “Sâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Eme ŋeku Jesu e ŋafe sâc ejujec iŋuc erâ hae beherâ Oliwa tikio feme motec jaŋe bâjâpembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eme jujujecko fisirâ motecfâcne šiŋuc jazawec: “ŋoŋe eesâicko dockenšipiŋte numuniŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iŋuc murâ qânâ wickepene raekac irec sâc rarâ dieŋzi herâ šiŋuc muhuc numuwec: ");
INSERT INTO kmg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mamac, go manatec sâckeme mutec šâic guru šizi nowaruoc. Erâ nore dâŋ mâcne, gore dâŋ sanaŋkezejec.”  ");
INSERT INTO kmg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iŋuc muhame sambâŋkonec aŋelo moczi waharâ basanaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Eme maŋzi šâic hâhâwicne ecneha fotariehuc numuwec. Ehame fofoŋac-ticne soc šâmbâŋ iŋucne tâcnehuc mâreŋko wahawec.Ý ");
INSERT INTO kmg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Numuku faharerâ motecfâcne jaŋerao rarâ honec-jopawec: Jaŋe busâqoczi bâdoc-jopame betaŋkerâ guŋ fombiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Fohapie jazarâ muwec: “Ŋoŋe wemocte guŋ foŋgopieŋ? Eesâicko dockenšipiŋte faharerâ numuniŋ me!” ");
INSERT INTO kmg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iŋuc muhuc domahame mi râsi guru ututuŋ fisinšepieŋ i¡ Eme motec jaŋere âgo moc šâŋene Juda, eki micne bajarehuc Jesurao rarâ muduckewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Muduckeme Jesuzi šiŋuc âzâcnewec: “Juda, go wemocte Ŋic Fâri Wâtuŋne e muduckehuc doc bakomec?” ");
INSERT INTO kmg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eme Jesure kikefuŋfâc jaŋe wiac fuazo eme honerâ mumbiŋ, “Wofuŋ, šikazi jopanaŋ me?” ");
INSERT INTO kmg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iŋuc murâ jaŋeraonec moczi taha bapa sâkore kiŋaŋ motec šikazi qaocte hazecne fâreopec i qatarawec. ");
INSERT INTO kmg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eme Jesuzi i honerâ muwec: “Ŋoŋe beheniŋ.” Iŋuc muhuc ŋic hazec-ticne bâuahuc bâsomiewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Erâ taha bapa micne â ufuŋte polismaî micne â soŋaŋ e roniŋte fisimbiŋ jaŋe šiŋuc jazawec: “Ŋoŋe nore manapie šika qaqa eme šika qaruc-ŋeŋichec fisirâ rocnuŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","No šoaŋne šoaŋne taha ufuŋko ŋoŋehec juekopac, ehame ŋoŋe ira mi rocnumbieŋ. Ʒi ine ŋoŋere dameŋ maickekac â dapâcte tâpiri fua tâcnekac.” ");
INSERT INTO kmg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eme jaŋe Jesu rorâ bararâ taha bapa sâkore ficko bafembiŋ. Ehame Petoro e fisi fâresuc ehuc šâhec rawec. ");
INSERT INTO kmg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eme momori jaŋe sacmaŋko raširâ šoc ruqerâ ruahuc ŋehapie Petoro e iŋuc jaha raširâ ŋondeŋ-jeŋicko ŋewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ŋehame kiŋaŋ naru moczi fisirâ hone dedeŋnehuc muwec, “Ŋic keci ehec juekac wâc.” ");
INSERT INTO kmg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eme Petorozi mic bahuc muwec, “Ŋokac, no e mi honeekopac.” ");
INSERT INTO kmg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iŋuc murâ ŋeme mi šorahame ŋic moczi honerâ muwec, “Go hâcne jaŋere guruonec.” Eme Petorozi muwec, “ŋic go, no aricne.” ");
INSERT INTO kmg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Eme šâhec ŋic moczi fisirâ musanaŋkehuc muwec: “Á ŋic kecši jâmbomac ehec juekac, e Galilaia ŋic jaha.” ");
INSERT INTO kmg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mume Petorozi muwec, “Ŋic go dâŋ mutec kâuc bakopac.” Muhame izia qâqâczi dâŋewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eme Wofuŋzi forisierâ Petororao šâŋe fime Petoro e Wofuŋzi dâŋ šiŋuc âzâcnewec i manasuwec: “Qâqâczi mi dâŋehame go jahec â moc mic bacnucmu.” ");
INSERT INTO kmg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dâŋ i manasurâ bune herickeme ra kio sâqorewec. ");
INSERT INTO kmg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesu soŋaŋkehuc domambiŋ ŋic i jaŋe mu šerec ecnehuc ");
INSERT INTO kmg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","šâŋe maine bâsoŋkerâ qahuc mumbiŋ, “Go porofete jukomeczi ŋic gukac ere šâŋe muc.” ");
INSERT INTO kmg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Erâ âke sisic wiac gâcne mâmâc ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ehapie hae fureme micne guru, taha bapa micne â miti qaqazu hâcne, jaŋe sasawa tumaŋne-fârerâ mupie Jesu guru-jeŋicko bafepie dâŋ šiŋuc âzâcnembiŋ: ");
INSERT INTO kmg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Go Kristo jukomecko mufua-nârec.” Mupie šiŋuc jazawec: “No ŋazape mi mananiŋmu, ");
INSERT INTO kmg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","me indiŋ-ŋopape ŋifecne sâcne wâc mi nazaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ʒi ine ŋic Fâri Wâtuŋne e Anutu tâpiri rune fârenao ŋeocmurâ dameŋne maickekac.” ");
INSERT INTO kmg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mume manarâ mâmâc sasawa šiŋuc âzâcnembiŋ: “Eme go Anuture Ŋokâ ine hâcne?” Eme muwec, “Ine hâcne.” ");
INSERT INTO kmg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mume mumbiŋ: “Wemocte dâŋgie mocwâc banaŋmu, ši e jahacne mickonec wahame manaŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Eme jaŋe ŋeku mâmâc sasawa faharerâ Jesu Pilatorao barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Erao domahuc kecšiŋuc muhuc qorickembiŋ: “Ŋic kecširec fuŋne šiŋuc fokac, e ŋic mâmâc sasawa ɋâiŋ-jopaekac, ehuc Roma ŋicwofuŋte takesi moneŋ mi râeniŋte muac-jopaekac, erâ wâc e jahacnere šiŋuc muekac: No Kristo ŋicwofuŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eme Pilatozi wiocnerâ muwec: “Go Judaŋic jaŋere ŋicwofuŋ me?” Eme Jesuzi muwec: “Ine hâcne mukomec.” ");
INSERT INTO kmg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mume Pilatozi taha bapa micne â ŋic guru sâko mâmâc jazarâ muwec, “No ŋic širec kiŋ basakopac.” ");
INSERT INTO kmg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eme jaŋe fotarierâ mujâmbâŋkehuc mumbiŋ: “E jâmbomac ŋic qafeŋ-jopame dâŋticnezi mâreŋ-nâŋecko haŋ bafâreekac. E Galilaia mâreŋkonecteaŋ fuŋkerâ ewareku šira Judaia mâreŋko ijaha eekac.” ");
INSERT INTO kmg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iŋuc mupie Pilatozi wio-jarerâ muwec, “Ŋic e Galilaia mâreŋkonec me?” ");
INSERT INTO kmg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eme “ine hâcne” mupie Jesu e Herodere gie gaŋkonec, iŋuc manarâ mume Heroderao barambiŋ. Herode e dameŋ ira Jerusalem haeo juwec. ");
INSERT INTO kmg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode e Jesu honerâ bune biaŋkewec. E Jesure biŋe gâbâ manahuc honeocte boc ecne jujec. Erâ wâc mâsi moc bame honeocte aŋac focnewec. ");
INSERT INTO kmg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eme Jesu dâŋ fuŋne fuŋne wiocneme okacne moc mi bâtikiecnewec. ");
INSERT INTO kmg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ehame taha bapa micne â miti qaqazu jaŋe qoricke sanaŋkehuc domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eme Herode â momorifâcne jaŋe Jesu sâckehuc šoraŋ ecnembiŋ. Ehuc Herodezi mume Jesu ŋicbomboŋ ŋaqi moc hecnepie hume Pilatorao mocwâc bârisiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Eme šoaŋ gie bapa ira Pilato â Herode jahe ââgo epic, mârâc jaha ine kikisâ ehuc jupic. ");
INSERT INTO kmg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato e taha bapa micne â ŋic fekicne â ŋic omane jaŋe mâmâc hefârec-jopame fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Eme šiŋuc jazawec: “Ŋoŋe šiŋuc muhuc ŋic kecši norao barâ warembieŋ: `E ŋic qafeŋ-jopaekac. Ž Eme noni ŋoŋere maio fuŋne-ticne bataniŋkepe fâri tâmiric ejec. ");
INSERT INTO kmg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodezi iŋuc jaha erâ mume mocwâc bârisierâ bawareŋgopieŋ. Manaŋgopieŋ, kiŋticnezi hâmocte sâc mi bâfuakac, ");
INSERT INTO kmg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","irec mupe momori jaŋe kâcbiŋzi qapie firuepemu.”  ");
INSERT INTO kmg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kia e hombaŋ dameŋko ŋic moc firue-jare jujec hâcne.Ý ");
INSERT INTO kmg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jaŋe ine micne mic sâc owackerâ mumbiŋ, “E arictac eoc, Baraba ine firue-nârec.” ");
INSERT INTO kmg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba eki ine ŋic gâcne jaŋehec šika qahuc ŋic moc qâhâmome kâpâcwâru ficko râembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Eme Pilato e harierâ jazawec, “No Jesu firuepemu i!” ");
INSERT INTO kmg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mume jaŋe hahaŋne bahuc mumbiŋ, “Maripoŋko hâmooc, maripoŋko hâmooc!” ");
INSERT INTO kmg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eme Pilatozi qatara-jarehame jahec â moc eme jazawec, “Wemo sâqocne bawecte? No manape kiŋticne hâmocte sâc mi ekacte mupe kâcbiŋ sawa kirâ juzejec.” ");
INSERT INTO kmg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eme jaŋe fota qatarierâ micne mic šereŋ musereckerâ owackehuc mumbiŋ, “Maripoŋko hâmooc.” Murâ qâsifu sâko qarâ fetone fehuc kiare dâŋ bawahambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eme Pilatozi dâŋ mumbiŋ irec fârine fuaocte mutarawec. ");
INSERT INTO kmg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ehuc dâŋjeŋic reŋkerâ qaqafeŋte â šikare kâpâcwâruo râekicne ŋic e firue-jarewec â Jesu ine qikiŋne-jarewec. ");
INSERT INTO kmg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jaŋe Jesu baraku hatao ŋic moc bâfuambiŋ, šâŋene Simoŋ, Kirene hae mâreŋkonec. E gieonec wareme rorâ Jesure maripoŋ ɋawenao râepie hâporâ Jesure râpefuŋko rawec. ");
INSERT INTO kmg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Erâ ŋic ŋokac guru sâkozi bâjâpembiŋ Ehuc ŋokac jaŋe kio wâwâsic â mu mamakuc ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Epie Jesuzi fotikierâ šiŋuc jazawec: “Jerusalemnec ŋokac bureŋ, ŋoŋe nore mi kioniŋ. Ŋoŋe â naru motecfâc-ŋeŋic ŋaŋacne kioniŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Manaŋgopieŋ, juku dameŋ moc maickeme šiŋuc munšoŋgopieŋ: `Oi, ŋokac hufiŋne â me sawane jaŋe iŋucne junšapeŋ me! Ž ");
INSERT INTO kmg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Eme dameŋ ira tiki jaŋere šiŋuc muniŋmu: `Ŋoŋe herickerâ waha ŋefac-nâponiŋ', â hârâc jaŋere muniŋmu, `Ŋoŋe fâuckerâ bârârâŋ-nâponiŋ'. ");
INSERT INTO kmg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wiac šiŋucne jâc ɋâricne ecneŋgopieŋko hâmocne weniŋuc ecnezo?” ");
INSERT INTO kmg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eme sâqocne bapa jajahec ehec mâmâc jopaniŋte bacjopa rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eme raku mâreŋ moc šâŋene Utusiec ira fisirâ Jesu maripoŋko qambiŋ, â sâqocne bapa moc ŋifec â moc ŋifec mâmâc jofambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eme Jesuzi numuhuc muwec, “Mamac, jaŋe wiac eŋgopieŋ i fuŋne kâuc baŋgopieŋte kiŋjeŋic behec.” Momori jaŋe ine ŋaqi-ticnere jaŋaczia ɋâsâi qapie âke fuac-jopame sâc rauckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ŋic ine wemo afecne ijaha domahuc wiac hone-fârembiŋ. Ehuc ŋic fekicne jaŋe sâke itic ecnehuc mumbiŋ, “Gâcne bafic-jopaweczi e jahacne sahac bafickeoc me¡ E Kristo Anuture joroc jukacko iŋuc eoc me!” ");
INSERT INTO kmg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Momori jaŋe iŋuc jaha mu ruruc ecnembiŋ, ehuc waiŋ opâ šašacne sicnecnehuc mumbiŋ: ");
INSERT INTO kmg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Go Judaŋic jaŋere ŋicwofuŋ jukomecko sahacge ŋezickec me!” ");
INSERT INTO kmg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eme Jesure qizec botâŋko dâŋqâreŋ šiŋuc râembiŋ: “Ʒi Judaŋic jaŋere ŋicwofuŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Eme sâqocne bapa moczi maripoŋko domahuc bafic-joparâ sâke kiki ecnerâ muwec, “Go iŋucnezi Kristo me? Murâ gahacne sahac batararâ nâhe mâmâc batarac-nâfoc.” ");
INSERT INTO kmg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Iŋuc mume âgonezi dâŋ mucnehuc muwec, “Go šikare biŋe mâmâc ekicnezi Anuture mi hâwicguha iŋuc mukomec? ");
INSERT INTO kmg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nâhâc kiŋnâhecte sâcko wiac sâcne enâctekicne, ŋic kecšizi ine sindaŋ moc mi ewec.” ");
INSERT INTO kmg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iŋuc murâ muwec, “Jesu, go Wofuŋ tâpirigehec juku fisirâ nore manasuzemec.” ");
INSERT INTO kmg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mume Jesuzi šiŋuc âzâcnewec: “No jâmbomac gazape, miŋecgac jaha nohec Paradisio jucmu.” ");
INSERT INTO kmg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Eme 12 kiloë ehame šoaŋ gâpâreme dapâc fuarâ mâreŋ sâckerâ fohame 3 kiloë ewec. ");
INSERT INTO kmg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ehame taha ufuŋko qoruc ââketâc sâko šâšâŋiŋ jaha hâŋ fâucke waharâ qatarawec. ");
INSERT INTO kmg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eme Jesu e wiwic jaha wirahuc muwec, “Mamac, megao maŋ qâqâtâc-nane râekopac.” Iŋuc murâ hâmowec. ");
INSERT INTO kmg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eme momori soŋaŋzi wiac i hone manac efârerâ Anutu mumbiaŋkehuc muwec, “Ŋic kecši e jâmbomac bahacmâc.” ");
INSERT INTO kmg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Erâ ŋic gâcne sâko wiac hone aŋac eniŋte fisimbiŋ jaŋe wiac i sasawa hone manac erâ maŋjeŋiczi tutuc qajarehame risiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesu e jahacne wiacfâc â Galilaia mâreŋkonec ŋokac bâjâperâ warembiŋ jaŋe ine taicko domahuc wiac hone manac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ŋic moc juwec, šâŋene Josefe” hae-ticne Judaia mâreŋko ŋewec, šâŋene Arimataia. Ŋic e micne sâko jumbiŋ jaŋere guruonec, erâ e ŋic wamane â tiŋne. ");
INSERT INTO kmg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Âgofâcne jaŋe Jesu dâŋ qacnehuc šikao râepie maname mi sâckewec, erâ e Anuture uucmaŋ fua tâcneocte woŋec juwec hâcne. ");
INSERT INTO kmg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ŋic eki hâcne Pilatorao rarâ Jesu qâŋɋâŋ-ticnere âzâcnewec. ");
INSERT INTO kmg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Eme manacneme ra maripoŋkonec batararâ qoruc qaŋqaŋzi râpâckerâ bararâ qânâ hâŋko hawec šâŋeruŋte biŋe gufukicne ira Jesure qâŋɋâŋ râewec. Hawec i furu fowec, ira mârâc jaha qâŋɋâŋ moc mi râekicne. ");
INSERT INTO kmg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","I šašawie dameŋte owâ gieo fuawec, sabata hombaŋ maickezo eha. ");
INSERT INTO kmg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ŋokac tucne Jesuhec Galilaia mâreŋkonec warembiŋ jaŋe Josefe bâjâpehuc honehapie Jesure qâŋɋâŋ šâŋeruŋko râewec. ");
INSERT INTO kmg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Eme wiac hone-fârerâ haeo risierâ wokemaŋ âsu biaŋ â kâŋâ wiac bâmockembiŋ. Erâ sabata hombaŋko sâcmutâc dâŋ reŋkehuc ŋemanambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sonda uupicte hae fure pârâckezo ehame ŋokac jaŋe wiac âsu biaŋ bâmockembiŋ i šâŋeruŋko amecke rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ra fisirâ honembiŋ: Qânâ sâko e rârieme hawec aaŋ fowec. ");
INSERT INTO kmg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eme šâŋeruŋ maŋko raširâ Wofuŋ Jesu qâŋɋâŋ-ticne basambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Basarâ weaŋkerâ domahapie ŋic jajahec ŋaqi-jekic bâric bâricnekicne mi maŋfuŋ-jeŋicko fuarâ domazepirec i¡ ");
INSERT INTO kmg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eme ŋokac jaŋe hâwic-jopame dunduŋ domahapie ŋic jahe šiŋuc jazapic: “ŋoŋe wemocte ɋârine jukac e hâmokicne jaŋerao basaŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","E šira mi fokac, e ɋârerâ faharejec, Galilaia mâreŋko juhuc dâŋ kecšiŋuc ŋazawec i manasuniŋ: ");
INSERT INTO kmg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","`Mamac-nanezi ŋic Fâri Wâtuŋne e sâqocne bapa jaŋere meo râeme qapie hâmorâ šoaŋ jahec â moc eha ɋârerâ fahareocmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iŋuc mupire ŋokaŋ jaŋe dâŋ i manasuhuc ");
INSERT INTO kmg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","šâŋeruŋkonec risierâ haeo fisirâ motecfâcne 11 â ŋic ŋokac gâcne dâŋ binaŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ŋokac šâŋe-jeŋic Maria Madala haeonec â Johana â Maria Jakobore neŋgoc erâ âgofâc-jeŋic gâcne mâmâc jumbiŋ. Izi hâcne aposolo biŋedâŋ jazambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jazapie dâŋjeŋic manapie pacgoroŋ dâŋ eme mi mana šakiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Á Petoro e ine fahare šâŋeruŋko gasacke rarâ okarierâ fime rašime qoruc râpâ sawa honewec. Erâ wiac fuawec i mana warec ehuc haeo risie rawec. ");
INSERT INTO kmg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Eme šoaŋ ijaha Jesure kikefuŋfâc jaŋeraonec ŋic jajahec Emausi haeo ranicte rapic. Hae i šoricko mi ŋewec, Judaŋic jaŋe qâqâtâc bembeŋkeme Jerusalem haeonec rârâ šoaŋ otewezo ehame fisi jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eme ŋic jahe hatao rahuc wiac fuawec irec muc manac epic. ");
INSERT INTO kmg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mu gufuc ehuc muc manac rahapire Jesu e jahac rarâ bâfuac-jofame mâmâc rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eme šâŋe-jekic bâsâockekicnere mi hone tarapic. ");
INSERT INTO kmg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iŋuc ehapire wio-jacterâ muwec: “Ŋohe wemo wiacte nazaŋ gazaŋ ehuc jukopirec?” Mume jahe šâŋe mai-jekic sorondoŋ eha domapic. ");
INSERT INTO kmg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ehuc jaheraonec moc šâŋene Keleopa eki muwec, “Jerusalem haeo ŋic hombaŋte fisimbiŋ jaŋe dâŋ biŋe sâko hazec sâc mana-fârehapie go mocjahazi weniŋuc erâ hazec furu jukomec.” ");
INSERT INTO kmg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eme eki wio-jacterâ muwec, “Wemo wiac?” Mume jahe mupic, “Wiac Jesu Nazarete haeonec ere binaŋ. E porofete sâko juhuc Anuture maio â ŋicmaio wiac tâpiri jaha mu bac ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ehame taha bapa micne â fekicnefâc-nâŋec jaŋe hâmoocte mutaracnehuc kiarao râepie mume maripoŋko qambiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nâŋe ine ere mamanac juhuc šiŋuc mumbeŋ: `Eki hâcne Israe ŋic nâŋâc niŋgiŋkonec firuec-nâpozejec. Ž Eme qapie hâmome juhapene biac šoaŋ gie bapa jahec â moc ekac. ");
INSERT INTO kmg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ehame miŋecgac nâŋeraonec ŋokac gâcne bu qâqânduc dâŋ nâzâmbieŋ. Jaŋe furicte šâŋeruŋko rarâ ");
INSERT INTO kmg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","qâŋɋâŋ-ticne basarâ risierâ šiŋuc mumbieŋ: `Aŋelo jajahec fua-nârehuc, Jesu ɋârerâ faharejec, iŋuc nâzâkopirec. Ž ");
INSERT INTO kmg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Eme dâŋ i manarâ nâŋeraonec ŋic âgofâc-nâŋec tucnezi rarâ ŋokac mumbieŋ sâc bâfuambieŋ â e jahacne ine mi honembieŋ.” ");
INSERT INTO kmg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dâŋ iŋuc muhuc âzâcnepire eki muwec: “Porofete jaŋe dâŋ mu qâreŋ embiŋ i ŋoŋe wemocte mutuc â maŋ mâmâcne juhuc mi mana šakieeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kristo e wemocko hâmoc šâic tâmiric juku sambâŋ tatamac-ticnao rašizac?” ");
INSERT INTO kmg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iŋuc murâ Mose â porofete dâŋ erao iticnehuc qâreŋkembiŋ, irec fuŋne ritu-jacte-fârewec. ");
INSERT INTO kmg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eme raku Emausi hae bâqiŋkembiŋ. Ehuc eki hae fotâcnerâ raocte eme ");
INSERT INTO kmg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","jahe sakarehuc mupic, “Ʒoaŋ biac rifireha hae ŋafezo ekacte go nâhehec juc.” Eme jahehec juocte mana-jacteme ficko mâmâc fembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eme nânâ nâniŋte waha ŋerâ poroŋ rorâ jambuŋkehuc bazurâ jactewec. ");
INSERT INTO kmg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ehame šâŋe-jekic raruŋkeme hone tarapic. Hone tarapire izia sipuac ewec. ");
INSERT INTO kmg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eme jahe nazaŋ gazaŋ erâ kecšiŋuc mupic: “Hatao dâŋ nâsâhuc mitire fuŋne ritu-nâcteme bunâhec bâruŋkejec hâcne ine.” ");
INSERT INTO kmg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iŋuc murâ izia faharerâ Jerusalem haeo risie rapic. Ra fisirâ e jahacne motec 11 â âgofâc-jeŋic gâcne tumaŋnerâ ŋehapie bâfuac-jopapire ");
INSERT INTO kmg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","jaŋe biac šiŋuc jasambiŋ: “Wofuŋ e jâmbomac faharerâ Simoŋ fuacnejec.” ");
INSERT INTO kmg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eme jahe iŋuc jaha Wofuŋzi hatao bâfuac-jofarâ ficko poroŋ bazume šâŋitapic, irec dâŋ binaŋ ejarepic. ");
INSERT INTO kmg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Motec jaŋe irec dâŋ binaŋ ehuc ŋehapie Jesu e jahac ŋondeŋ-jeŋicko fuarâ domawec. ");
INSERT INTO kmg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eme jaŋe honerâ fâfârerâ hâwic-jopame mumbiŋ, “Bawezi fuakac.” ");
INSERT INTO kmg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eme eki šiŋuc jazawec: “Ŋoŋe wemocte fâfârerâ maŋjahec eŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ši no nahac jâmbâŋ jukopac, ŋoŋe me kike-nane honeniŋ, ehuc ware bâuacnurâ hone-hâmocnuniŋ, no sahac biuc-nanehec, bawe jaŋe ijeŋichec aricne.” ");
INSERT INTO kmg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dâŋ iŋuc jazarâ, mejahecne â kike jahecne jowatuwec. ");
INSERT INTO kmg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eme jaŋe bujeŋic biaŋkeme dâŋticne mi mamana mâc wareckehuc ŋepie wio-jarerâ muwec: ");
INSERT INTO kmg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","“Nânâ-ŋeŋic moc fokac me?” Eme jaŋe opâ qowi šegoc šakicne moc râcnerâ ");
INSERT INTO kmg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","honehapie ro nâc ewec. ");
INSERT INTO kmg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Erâ šiŋuc jazawec: “No ŋoŋehec juhuc kecšiŋuc ŋaza jupac: `Mosere sâcmutâc dâŋqâhâcko â porofete jaŋere papiao â miti mânecko nore findaŋdâŋ qâreŋkekicne, i fârinehec efâreocmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eme miti papiao dâŋqâreŋ fokac irec fuŋne ritu-jarekume maŋjeŋic uŋtowec. ");
INSERT INTO kmg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ehuc jazawec, “Kristore šiŋuc qâreŋkekicne: `E šâic manaku hâmorâ šoaŋ jahec â moc eha hâmockonec ɋârerâ fahareocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Á šâŋe biŋe-ticne ŋic mâreŋ sâc jaŋerao rame maŋ bâbârisie â sâqocne mumutâmire fua raocte mukicne. Gie i Jerusalem haeo fuŋkerâ barazo. ");
INSERT INTO kmg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wiac irec mumutaniŋ ŋic ŋoŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Erâ manaŋgopieŋ, Mamac-nanezi wiac biŋe qaŋarewec i sorepe waha-ŋareocmu. Irec ŋoŋe hae ši mi behehuc mâc woŋec juhapie faic irec tâpiri heŋarepe huzejec.” ");
INSERT INTO kmg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eme haeonec jowac-jopa rarâ Betania hae mendâŋko fisirâ meticne sicnehuc jambuŋ-jopawec. ");
INSERT INTO kmg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jambuŋ-jopahuc behec-joparâ fewec. ");
INSERT INTO kmg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eme jaŋe bubiaŋ kâcɋene manahuc Jerusalem haeo risiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Risierâ taha ufuŋko hati jurâ ju ehuc Anutu muteŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Micdâŋ e fuŋnao fuŋkerâ juwarehuc juwec. Erâ Micdâŋ e juju-ticne Anuturao foha juhuc juwec. Erâ Micdâŋ e Anutu jaha wâc juwec. ");
INSERT INTO kmg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E hâcne fuŋnao Anutuhec jurâ juwarewec. ");
INSERT INTO kmg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Erâ Micdâŋ e Anuture me wâc ehuc wiac sasawa bâfua-fârewec, â wiac fuawec i e tâmiric moc mi fuawec. ");
INSERT INTO kmg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Erâ juju irec rune erâ juwec. Á juju-ticnezi ŋic tamae-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Eme tatamaczi dapâcko tamaeme dapâczi guriŋkeocte eipiewec. ");
INSERT INTO kmg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ŋic moc fuarâ juwec šâŋene Johane. ");
INSERT INTO kmg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Eki tatamacte biŋedâŋ mufuame ŋic mâmâc sasawa jaŋe tatamac rune manasiŋkeniŋte Anutuzi sorewec. ");
INSERT INTO kmg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johane e jahacne tatamac rune mi juwec, e mâc tatamac runere biŋe muwec. ");
INSERT INTO kmg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tatamac rune ŋic mâreŋ sâc batamaec-jopaekac, eki hâcne dameŋ ira mâreŋko fuarâ juwec. ");
INSERT INTO kmg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","E mâreŋko fufua i fuawec, erâ i sawa mâcne, mâreŋ i ekizia wâc bâfuawec, eme waharâ fuame mâreŋkonec ŋic jaŋe e sifu mi šâŋitambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E jahacne me hofao fisihame gurufâc-ticne jaŋe âgo mi ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Á âgo ecnembiŋ jaŋe ine Anuture naru motecfâc eniŋte hata bâfua-jarewec, i šâŋe-ticne mana maŋ eeŋgopieŋ jaŋe hâcne iŋuc ejareekac. ");
INSERT INTO kmg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jaŋe soc biucte hatao mi fuambiŋ, erâ ŋic mumupaŋte wâc mâcne, jaŋe Anuturaonec fuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Eme Micdâŋ e sahac biuchec fuarâ ŋondeŋ-nâŋecko ŋeŋe juju ewec. Eme nâŋe Wofuŋ qâreŋ-ticne honepene Mamacte ŋokâ jâmbâŋ mocjaha ere Wofuŋ qâreŋ ewec hâcne. E aki anonoc kadahe â dâŋ fâri qizecne bawahawec. ");
INSERT INTO kmg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Fuŋne-ticne ine Johanezi mutaniŋkerâ hahaŋne bahuc kecšiŋuc muwec: “No ere hâcne ŋazapo, šâhec warekac e bâbâni juwec, eki no mi fuahape juwarehuc juwec hâcne.” ");
INSERT INTO kmg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nâŋe sasawa ere rowaŋkonec miti kadahe rorâ ro ehuc jumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mose e sâcmutâc dâŋ nârewec, â Jesu Kristo eki ine aki anonoc â dâŋ fâri qizecne tahac-nâpowec. ");
INSERT INTO kmg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Anutu e ŋic moczi moc mi honewec, Ŋokâ jâmbâŋ mocjaha, Mamacte bufuŋko juekaczi ine biŋe-ticne bawaharâ mufua-nârewec. ");
INSERT INTO kmg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem haeonec Judaŋic jaŋe taha bapa â taha ufuŋte kiŋaŋŋic sorec-jopapie Johanerao rarâ, go mo ŋic mo, muhuc wiocnepie fuŋne-ticne jazawec. ");
INSERT INTO kmg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","E fuŋne-ticne mi hesoŋkehuc mutaniŋkerâ kecšiŋuc jazawec: “No Kristo aricne.” ");
INSERT INTO kmg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mume jaŋe harierâ wiocnembiŋ, “Eme go mo, go Elia me?” Eme muwec, “No e aricne.” Eme mumbiŋ, “Go porofete-nâŋec me?” Mupie muwec, “Aricne.” ");
INSERT INTO kmg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eme jaŋe mumbiŋ: “Wiac go mo? Sorec-nâpopie warembeneŋ, ra weniŋuc jazanaŋmu? Go gahacnere weniŋuc muekic?” ");
INSERT INTO kmg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eme jazarâ muwec: “Porofete Jesajazi mu qâreŋ ewec, i norao sanaŋkekac. No biŋe mumu ŋic, mâreŋ tuhuo juhuc kecšiŋuc muekopac: `Wofuŋte hata bâšâweniŋ!” ");
INSERT INTO kmg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ŋic Johanerao fisimbiŋ i jaŋe farisaio jaŋere guruonec. ");
INSERT INTO kmg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Irec mocwâc indiŋkerâ mumbiŋ: “Go Kristo aricne, â Elia aricne, â porofete aricne, eme wemocte ŋic Miti Opâ rua-jareekic?” ");
INSERT INTO kmg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mupie Johanezi šiŋuc jazawec: “Noni ŋic opâ sawa rua-jareekopac, â ŋondeŋ-ŋeŋicko moc fuawec jukac, ŋoŋe e mi hone taraeŋgopieŋ, ");
INSERT INTO kmg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","eki hâcne râpefuŋ-naneo warehuc jukac, e sâko no iŋucne maczi mafahe decnepe mi sâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wiac i Betania haeo Jordaŋ ocniŋucnao fuawec. Ira hâcne Johanezi juhuc ŋic Miti Opâ rua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hae fureme Jesuzi Johanerao rame taicko honerâ ŋic šiŋuc jazawec: “Honeniŋ, kecocni Anuture lama, eki mâreŋ sâc ŋic sâqocne-jeŋic fainao feme âsickekac. ");
INSERT INTO kmg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ere hâcne kecšiŋuc ŋazapo: `šâhec warekac, e bâbâni juwec, eki no mi fuahape juwarewec. Ž ");
INSERT INTO kmg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","No nahac mârâc e mi hone tarapo. Israe ŋic ŋoŋe biŋe-ticne ŋazape mananiŋte hâcne fisirâ Miti Opâ fuŋkepo.” ");
INSERT INTO kmg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johane e iŋuc murâ muwec: “No Mârozi hapâ hawario sambâŋkonec waharâ fai-ticnao herâ ŋeme honepo. ");
INSERT INTO kmg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No nahac mârâc mi hone tarahape Miti Opâre munareweczi šiŋuc nazawec: `Mâro waharâ fai-ticnao herâ ŋeme honecmu eki ŋic Tiri Mâro rua-jareocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","No i hâcne honepore fuŋne-ticne kecšiŋuc mupo: `Eki hâcne Anuture Ŋokâ. Ž ” ");
INSERT INTO kmg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hae fureme Johane erâ motecfâcne jaŋeraonec jajahec mâreŋ ijaha domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Domahapie Jesu e ijaha fotâcneme honerâ motec jasarâ muwec: “Honenic, Anuture lama kecocni.” ");
INSERT INTO kmg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mume jahe dâŋ i manarâ Jesure râpefuŋko rapic. ");
INSERT INTO kmg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Rapire Jesuzi forisierâ honec-jofarâ muwec” “Ŋohe wemocte warekopirec?” Eme jahe mupic: “Rabi (nâŋâcne dâŋko: Qaqazu), go fic wena jukomec?” ");
INSERT INTO kmg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eme šiŋuc jasawec: “Ware honenic.” Mume jahe bâjâperâ fic honerâ šoaŋ gie bapa ira juweckoa jupic. I šoaŋ otewezo eha iŋuc epic. ");
INSERT INTO kmg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Johanere dâŋ manarâ Jesu bâjâpepic moc šâŋene Anderea, Simoŋ Petoro ɋaticne. ");
INSERT INTO kmg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Eme eki biac hahac-ticne Simoŋ bâfuarâ šiŋuc âzâcnewec: “Nâhe Mesia (Kristo hâcne(c) bâfuakoperec.” ");
INSERT INTO kmg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iŋuc murâ Jesurao jowame rapic. Eme Jesuzi honerâ muwec: “Go Simoŋ, Johanere ŋokâ, gore šâŋe Kefa mukopac” (nâŋâcne dâŋko: Haroŋaŋ). ");
INSERT INTO kmg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hae fureme Jesu e Galilaia mâreŋko raocte šawierâ Filipo bâfuarâ âzâcnewec, “Go bâjâpecnuc.” ");
INSERT INTO kmg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo e Besaida haeonec, Anderea â Petoro jahe hae irecteaŋ. ");
INSERT INTO kmg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Eme Filipozi Natanae bâfuarâ šiŋuc âzâcnewec: “Mose e sâcmutâc dâŋqâhâcko findaŋdâŋ-ticne qâreŋkewec, â porofete jaŋe wâc qâreŋkembiŋ, ŋic e hâcne bâfuaŋgopeneŋ, Jesu, Josefere ŋokâ, Nazarete haeonec.” ");
INSERT INTO kmg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Eme Natanaezi dâŋ šiŋuc bâtikiecnewec: “Nazarete haeonec wemo wiac bipinehec fuaocmu?” Mume Filipozi šiŋuc âzâcnewec: “Murâ ware honec.” ");
INSERT INTO kmg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eme Natanaezi Jesurao ra fisime honerâ muwec, “Honeniŋ, ŋic kecizi Israe ŋic fârine, maŋticnao sioc moc mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Iŋuc mume Natanaezi wiocnerâ muwec: “Go wena jupe honecnumeŋ?” Eme Jesuzi muwec, “Filipozi mi hefârecguhame nemuja fuŋko ŋetec honecgupac.” ");
INSERT INTO kmg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mume Natanaezi šiŋuc âzâcnewec: “Qaqazu, go jâmbomac Anuture ŋokâ, Israe ŋic nâŋere ŋicwofuŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Eme Jesuzi muwec: “Nemuja fuŋko ŋemec i mufua-garepe manasiŋnukomec, manakic, hone manac ekomec ši susucne sawa, fâri ombâŋne miŋecnea hone manac erahuc jucmu.” ");
INSERT INTO kmg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iŋuc murâ muwec, “No jâmbomac jâmbâŋ ŋazape: Ŋoŋe sambâŋ aŋkeme Anuture aŋelofâc jaŋe Ŋic Fâri Wâtuŋne erao fec wahac epie honec-jopaniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Gie bapa jajahec tarame Kana haeo Galilaia mâreŋko ŋic ŋokac jajahec muturec-jofaniŋte irec tiwâ bâzi qapie fisiwec. ");
INSERT INTO kmg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ehuc Jesu neŋgoc-ticne erâ e jahacne â motecfâc-ticne mâmâc hefârec-jopapie fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Eme tumaŋnerâ bâzihec waiŋ nâpie šickeme Jesu neŋgoc-ticnezi e âzâcnerâ muwec: “Waiŋ-jeŋic omaekac.” ");
INSERT INTO kmg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mume Jesuzi šiŋuc âzâcnewec: “Ŋokac, i nâhâcne wiac me? Dameŋ-nane miŋecnea maickeocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eme neŋgoc-ticnezi kiŋaŋ qaqa šiŋuc jazawec: “Wiac mocte ŋazame enšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Eme fic ira opâ pake 6 ŋewec. Judaŋic jaŋe me sahac-jeŋic gâbâ šure jumbieŋte fic sâc opâ pake iŋuc ŋerawec. Pake i piticne mâcne, kâcɋene sâko. ");
INSERT INTO kmg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Eme Jesuzi kiŋaŋ qaqa šiŋuc jazawec: “Ŋoŋe opâ fiarâ pakeo qapie huoc.” Eme jaŋe iŋuc erâ opâ qapie hurâ pake micnao qafârewec. ");
INSERT INTO kmg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Iŋuc epie šiŋuc jazawec: “Ŋoŋe tucne fiarâ nânâ soŋaŋtao baraniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Eme jaŋe fiarâ barahapie opâzi waiŋ eme nânâ soŋaŋzi nâhonerâ kâuc bawec. Kiŋaŋ motec opâ fiarâ pakeo qapie huwec jaŋe sawazi waiŋte fuŋne mana tarambiŋ. Eme nânâ soŋaŋzi ŋic ŋokac bawec, e hefârerâ ");
INSERT INTO kmg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","šiŋuc âzâcnewec: “Qanaŋ waiŋ aŋacne gumec-jopapene nâkupie maŋjeŋic bibiriwazo eme šâhec waiŋ oomane gumec-jopaeŋgopeneŋ, hata-nâŋec iŋuc fokac. Go ine qac qâtikic ehuc aŋacne hefacketec ŋeku šâhec fuakac.” ");
INSERT INTO kmg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesu e Kana haeo Galilaia mâreŋko ira hâcne mâsi bapa gie-ticne fuŋkehuc Wofuŋ qâreŋ-ticnere foŋ bararuŋkewec. Eme motecfâcne jaŋe honerâ e manasiŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Eme Jesu e Kana haeonec Kafanaum haeo rame neŋgoc ɋafâc-ticne â motecfâc-ticne mâmâc bâjâperâ rafârembiŋ. Eme ira boc mi jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judaŋic aakic hombaŋ-jeŋic bembeŋkewecte Jesuzi Jerusalem haeo rafewec. ");
INSERT INTO kmg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Eme taha ufuŋ šuhucnao lama bulimakao â hapâ wiac badomahuc nareŋ gareŋ embiŋ, ehuc irec moneŋ teboo wose biric embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iŋuc epie Jesuzi honec-joparâ repa mizeme šika eme ŋic mecne lama bulimakao mecne jâpec-jopame wisepie moneŋ tie-jarerâ irec tebo herândiŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Erâ hapâ badomambiŋ jaŋe šiŋuc jazawec: “Ŋoŋe Mamac-nanere ficko wiac kosa mi epie situâc fic ezejec.” ");
INSERT INTO kmg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesu e iŋuc eme motecfâcne jaŋe miti papiao dâŋqâreŋ kecšiŋuc fokac irec manasumbiŋ: “Gore ficte erâ bunane šoc šarâ šâfitacnukac.” ");
INSERT INTO kmg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eme Judaŋic jaŋe wiocnerâ mumbiŋ: “Go iŋuc ekomeczi wemo mâsi moc bahuc fuŋnege bataniŋke-nârecmu?” ");
INSERT INTO kmg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Eme micjeŋicko rorâ šiŋuc jazawec: “Ŋoŋe taha ufuŋ kecši heropiepie noni šoaŋ jahec â moc eha mocwâc bâzickepemu.” ");
INSERT INTO kmg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iŋuc muhuc jazame mumbiŋ, “Kâcɋenefâc-nâŋec jaŋe taha ufuŋ ši jara 46 baku bâzickembiŋ, eme goki šoaŋ jahec â moc sawa ira bâzickezo mukomec me?” ");
INSERT INTO kmg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesu eki ine sahac-ticnere ufuŋko ɋetickehuc muwec. ");
INSERT INTO kmg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Juku hâmockonec ɋârerâ fahareme motecfâcne jaŋe dâŋ i manasumbiŋ. Ehuc ufuŋte muwec, â miti papiao ere dâŋ gâcne mukicne, irec mâmâc manapie fârine eha mana šakiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesu e aakic hombaŋko Jerusalem haeo juhuc fuŋne qaqa mâsi bame ŋic bocjahazi honerâ šâŋe-ticne mana sakac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesu e jahac ine ŋic hone tarac-jopa-fârewecte jaŋerao mi fohorewec. ");
INSERT INTO kmg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","E ŋic mocte fuŋne manaocte gâcne mu indiŋ mi ejarewec, e jahaczia ŋic maŋjeŋic hone šâŋitac ejare-fârewec. ");
INSERT INTO kmg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisaio ŋic jaŋere âgo moc juwec šâŋene Nikodemo. E Judaŋic jaŋere micne sâko wâc juwec. ");
INSERT INTO kmg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ŋic eki hâcne Jesu ŋafeo iqickerâ šiŋuc âzâcnewec: “Qaqazu, nâŋe fuŋnege manaeŋgopeneŋ, go qaqazu fârinezi Anuturaonec wahameŋ, go mâsi baekic i ŋic moczi Anutu tâmiric juhuc bapane mi ekac.” ");
INSERT INTO kmg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mume Jesuzi šiŋuc âzâcnewec: “No jâmbomac jâmbâŋ gazape: Moc e harierâ fufua ɋâricne mi fuaocmuzi Anuture uucmaŋ sâcne mi bâfuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Eme Nikodemozi muwec, “Hâc, moc e kâcɋeŋkekicnezi fufua ɋâricne weniŋuc fuaocmu, wemocko neŋgoc bumaŋko mocwâc hume hâsine roocmu?” ");
INSERT INTO kmg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mume Jesuzi šiŋuc âzâcnewec: “No jâmbomac jâmbâŋ gazape: Moc e Opâ â Mârore kiwecko ɋâricne mi fuakicnezi Anuture uucmaŋko sâcne mi rašiocmu. ");
INSERT INTO kmg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ŋickiwecko fuakicnezi ŋic hawari jaha, Mârore kiwecko fuakicnezi Mârore hawari jaha. ");
INSERT INTO kmg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ŋoŋe fufua ɋâricne fuaniŋte mupe go manatec mi quŋkeoc. ");
INSERT INTO kmg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mâŋâŋ e kosa qaekac, eme go fânâŋ-ticne i manaekic, â fuŋne wenirec fuŋkerâ wareekac, â wena rataraekac, ine mi manaekic. Eme moc e Mârore kiwecko fuakicne, e fuŋne-ticne iŋucnea fokac.” ");
INSERT INTO kmg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mume Nikodemozi dâŋ šiŋuc bâtikiecnewec: “I weniŋuc erâ iŋuc ezo?” ");
INSERT INTO kmg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mume Jesuzi šiŋuc âzâcnewec: “Go Israe ŋic jaŋere qaqazuzi irec kâuc bakomec me? ");
INSERT INTO kmg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","No jâmbomac jâmbâŋ gazape: Nâŋe wiac hone manac eeŋgopeneŋ ijaha ŋaza mutâc eeŋgopeneŋ, eme ŋoŋe ine dâŋnâŋec qikiŋneeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wiac mâreŋko fufuane irec mac ŋazape sifu mi mana šakieeŋgopieŋ, eme wiac sambâŋko fufuane irec ŋazape wemo-ŋeŋiczi mana šakieniŋmu? ");
INSERT INTO kmg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ŋic moczi sambâŋko moc mi fewec, Ŋic Fâri Wâtuŋne, sambâŋkonec wahawec, e mocjahazi sambâŋko wâc juekac. ");
INSERT INTO kmg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mose e mârâc jaha mâreŋ sawao homa bâfeŋnewec, iŋuc jaha Ŋic Fâri Wâtuŋne e bâfeŋnezo mukicne. ");
INSERT INTO kmg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Eme e manasiŋkeniŋmu jaŋe juju sanaŋ bâfuaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutu e ŋic ŋoŋere mo iŋucne ecnewecte Ŋokâ jâmbâŋ-ticne mocjaha e râe qikiŋ ecnewec. Eme e manasiŋkeniŋmu jaŋe moc mi sipirickehuc ju ju sanaŋ bâfuaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ŋokâ e ŋic jaŋere kiŋ bataraocte mâcne, ŋic bâpiaŋ-jopaocte Anutuzi soreme wahawec. ");
INSERT INTO kmg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Moc e Ŋokâ manasiŋkekaczi okacnere biŋe mi ekac. Á moc e Ŋokâ mi manasiŋkekaczi ine biac okacnere biŋe ekac. Wemocte? E Anuture ŋokâ jâmbâŋ mocjaha ere šâŋe mana maŋ mi ekac irec. ");
INSERT INTO kmg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Okacnere fuŋne šiŋuc fokac: Tatamaczi ŋic maic-jopame jaŋe tatamac bâsuerâ dapâcte wosâembiŋ, juju bapa-jeŋic sâqocnere iŋuc hâcne embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Moc e sindaŋ eocmuzi tatamac râpeckeocmu, juju bapa-ticnere fuŋne jaŋgeŋkezacte wemocko tatamacko fua taniŋ eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Moc e dâŋ fâri qizecne reŋkeocmuzi ine tatamac maickeocmu, eme eebapa-ticne Anuture micdâŋte sâcko ekicne irec fuŋne taniŋkeocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Eme juku Jesu e motecfâcne rocjopame Jerusalem hae beherâ Judaia qaŋeŋnaopec ra jumbiŋ. Ira jaŋehec juhuc ŋic opâ rua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Johane e mâreŋ moc šâŋene Ainoŋ, Salim haeopec juhuc iŋuc jaha Miti Opâ gie bawec, ira opâ bocjaha fowecte ŋic jaŋe fisipie rua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Johane e dameŋ ira kâpâcwâru ficko mi ŋekicne. ");
INSERT INTO kmg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Eme Judaŋic moczi Johane motecfâc-ticne jaŋehec opâ ruruare mu qaqatarac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Eme motec jaŋe Johanerao rarâ šiŋuc âzâcnembiŋ: “Qaqazu, go Jordaŋ ocniŋucnao juhaŋtecne ŋic moc bâfuacgume fuŋne-ticne mujaŋgeŋkerâ nâzâmeŋ, eki dameŋ šiŋuczia ŋic opâ rua-jareme erao rafâreŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mupie Johanezi šiŋuc jazawec: “Ŋic moc e sambâŋ runezi wiac râcne tahac mi ehame e jahac wemocko kâŋgâc roocmu. ");
INSERT INTO kmg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","No kecšiŋuc muhuc ŋazapo i wemocko mickeniŋmu, `No Kristo aricne, no biŋe mumu-ticne sawa. Ž ");
INSERT INTO kmg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ŋokac biŋe mucnekicne eki hâcne ŋokac rune. Eme ŋokac bahuc šeri kâcɋene šeri eme âgo-ticnezi manarâ bafickehuc bubiaŋ sâko bâfuaocmu wâc. Bubiaŋ i hâcne manapemurâ dameŋne maickekac ši. ");
INSERT INTO kmg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eki fua fehame noni pitiwazepac. ");
INSERT INTO kmg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Faicnec wahaweczi qâhuc-nâpo-fârekac. Moc e mâreŋkonec fuakicnezi mâreŋte biŋe ekac â mâreŋkopec dâŋ muekac. Á sambâŋkonec wahaweczi ine qâhuc-nâpo-fârekac. ");
INSERT INTO kmg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eki wiac hone manac ewec irec dâŋ biŋe muekac. Mume ine ŋic jaŋe dâŋticne qikiŋneeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Á dâŋticne mana maŋ ekac e Anutu mume sasanaŋ jukac dâŋ i dopeckekac. ");
INSERT INTO kmg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anutuzi ŋic sorewec eki Anuture dâŋ jaha muekac. Ŋic iŋucne e Anutuzi Mâro sâc tâmiric qikiŋnecneekac. ");
INSERT INTO kmg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamac e Ŋokâ hone ririŋkehuc ere meo wiac sasawa râe-fârewec. ");
INSERT INTO kmg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Moc e Ŋokâ manasiŋkeocmu e juju sanaŋ šiŋuczia fuacnekac, â moc e Ŋokâre dâŋ bâsuehuc juocmuzi juju sanaŋ mi bâfuaocmu. Iŋucnere faio Anuture kimbeŋ feweczi foocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisaio jaŋe Jesure šiŋuc manambiŋ: “Eki motec rocjoparâ opâ rua-jareekac, i Johanere gurufâc jowaruŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Dâŋ i mâc mumbiŋ, Jesu e jahac ŋic opâ mi rua-jarewec, motec jaŋe mume rua-jarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Eme Wofuŋzi dâŋ iŋucne manarâ Judaia mâreŋ beherâ Galilaia mâreŋko risie rawec. ");
INSERT INTO kmg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Rahuc Samaria mâreŋ fotâcnewec. ");
INSERT INTO kmg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Fotâcnehuc Samariare hae moc šâŋene Sika ira fisiwec. Hae i Jakobozi ŋokâ-ticne Josefe mâreŋ qikiŋnecnewec irec mendâŋko ŋewec. ");
INSERT INTO kmg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Eme ijaha Jakobore opâ nombâŋ fowec wâc. Eme Jesu e ira guŋpiticko fisirâ betaŋkerâ nombâŋmecko waha ŋemanawec. ");
INSERT INTO kmg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ŋehame Samaria ŋokac moczi opâ fiaocte fisiwec. Fisime Jesuzi šiŋuc âzâcnewec: “Go opâ moc gumecnuc.” ");
INSERT INTO kmg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Motecfâcne jaŋe nânâ furine baniŋte haeo fehapie Jesu buc ŋehuc ŋokac opâre âzâcnewec. ");
INSERT INTO kmg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Âzâcneme ŋokac e muwec, “Go Judaŋiczi weniŋuc erâ Samaria ŋokac norao opâre mukic?” Judaŋic â Samaria ŋic jaŋe bâtâcko jujumbieŋte ŋokac e iŋuc muwec. ");
INSERT INTO kmg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eme Jesuzi šiŋuc âzâcnewec: “Go Anutu jauŋ-ticnere fuŋne â opâre gazakopac nore fuŋne mâmâc kâuc bakic. Mana tararâ muzac numu-naretec opâ fifisine garezapo.” ");
INSERT INTO kmg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mume ŋokaczi šiŋuc âzâcnewec: “Bomboŋ, opâ nombâŋ i šoricne, erâ go opâ fifiage aricnere opâ fifisine wenirec fiacmu? ");
INSERT INTO kmg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mimiŋne-nâŋec Jakobo e opâ nombâŋ ši rowec. Erâ e jahacne â ŋokâfâcne â lama bulimakaofâc-ticne jaŋe opâ ši jaha nâhuc jumbiŋ. Goki Jakobore sâc i jâuruhuc opâ moc bâfuacmu?” ");
INSERT INTO kmg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iŋuc mume Jesuzi šiŋuc âzâcnewec: “Opâ ši gapecne tâmiric, irec i hati nârâ nâ ehuc juzo, ");
INSERT INTO kmg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","â nore opâ ine gapecnehec, moc e i nâocmu, e opâre mocwâc mi hâmohuc mâc jurašihuc juocmu. Noni opâ i ŋic moc râcnepe maŋticnao opâ šâŋe bâfuacneme juju sanaŋte šâkâŋko rahuc domaocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mume ŋokaczi šiŋuc muwec: “Bomboŋ, go opâ i naretec nârâ opâre mocwâc mi hâmozepac, ehuc šira gâbâ ware fiahuc domaekopac i behezepac.” ");
INSERT INTO kmg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iŋuc mume Jesuzi šiŋuc âzâcnewec: “Ra ŋowege jowatec warenic.” ");
INSERT INTO kmg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Eme ŋokaczi muwec, “No ŋowe-nane aricne.” Mume Jesuzi muwec, “Go ŋowege aricne, i sâcne mukomec” ");
INSERT INTO kmg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","go ŋic memoc ba behec ejaremeŋ, â šiŋuczia bakomec e gore ŋowe aricne, irec go dâŋ jâmbomac mukomec.” ");
INSERT INTO kmg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mume ŋokaczi šiŋuc âzâcnewec: “ŋicbomboŋ-nane, no miŋecne manakopac, go porofete. ");
INSERT INTO kmg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Irec mutec manape: Kâcɋenefâc-nâŋec jaŋe tiki kecšira Anutu mai ecne jumbieŋ, â Judaŋic ŋoŋe ine Jerusalem haeoa Anutu mai ecnezo, iŋuc mueŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eme Jesuzi šiŋuc muwec: “Ŋokac, no gazape manac: Dameŋ moc bembeŋkekac, i maickeme ŋoŋe Mamac mai ecneniŋmu i tiki kecšira mâcne â Jerusalem haeo wâc mi eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ŋoŋe kâuc bahuc mai ecneeŋgopieŋ, nâŋe ine mana tarahuc mai ecneeŋgopeneŋ. Bâbâpiaŋ i Judaŋic nâŋeraonec. ");
INSERT INTO kmg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dameŋ moc maickeocmu erâ ši biac maickekac hâcne, ira kikefuŋfâc-ticne fârine jaŋe maŋzi â dâŋ fâri qizecnere sâcko Mamac mai ecneniŋmu. Mamac e ŋic iŋucne jaŋere ecneekac. ");
INSERT INTO kmg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu e Mâro fuŋgâtâne, irec e mai ecneeŋgopieŋ ŋoŋe Mâro â dâŋ fâri qizec jahere ŋesiŋko mai ecnenšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mume ŋokaczi šiŋuc âzâcnewec: “No manakopac, Mesia fuaocte mukicne, šâŋene moc Kristo, eki fuarâ wiac sasawa mu bataniŋ enâreocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Eme Jesuzi âzâcnewec: “Dâŋ gazakopac, no hâcne ši.” ");
INSERT INTO kmg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iŋuc muhame motecfâcne fisimbiŋ. Fisirâ ŋokachec muc manac ewec irec wareckembiŋ. Erâ wemo wiacte dâŋ âzâcnekomec, me weniŋucte âzâcnekomec, iŋuc muhuc wiocneniŋte manapie quŋkeme behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eme ŋokac e opâ râqâc-ticne beherâ haeo gasacke rarâ ŋic šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ŋoŋe warerâ ŋic moc honeniŋ, eki epo bapo irec dâŋ mutaniŋke-nare-fârekac. E Kristo wiac moc?” ");
INSERT INTO kmg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eme haeonec waharâ Jesurao fisi-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Eme motec jaŋe šiŋuc âzâcnembiŋ: “Qaqazu, nânâ nâc.” ");
INSERT INTO kmg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mupie jazawec, “Nânâ fuŋmoc fonarekac, i ŋoŋe mi manaŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iŋuc mume motec jaŋackoaŋ nazaŋ gazaŋ erâ mumbiŋ: “Moczi moc nânâ bafisirâ râcnembieŋ me?” ");
INSERT INTO kmg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mupie muwec, “Sorecnuwec ere mic reŋkehuc gie-ticne baku babatara izi nânâ-nane ekac. ");
INSERT INTO kmg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ŋaŋac šiŋuc mueŋgopieŋ: `Mosa 4 tarame nânâ fârine fuaocmu. Ž Á noni ine ŋazape mananiŋ: Ŋoŋe qâhâŋnerâ šâŋe fihuc gie honeniŋ, nânâ fârine fufua dameŋ šine hâcne maickekac. ");
INSERT INTO kmg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ro qânusuc gie baocmuzi furine roocmu, â fârinezi ju ju sanaŋte biŋe eocmu. Eme he sarac ewec â fârine rome fewec jahe mâmâc babafic erâ šeri enicmu. ");
INSERT INTO kmg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ehame dâŋ kecši sanaŋkeocmu: `Moczi he sarac eekac, â moczi fârine rome feekac. Ž ");
INSERT INTO kmg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Noni ŋoŋe he sarac mi embiŋko fârine ropie feocte sorec-ŋopakopac. Gie i gâcnezi bapie fuawec eme ŋoŋe mâc rauckeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Eme Samaria ŋokac e haefâc-ticne šiŋuc jazawec: “Wiac epo bapo i mutaniŋke-nare-fârejec.” Eme dâŋ irec bocjahazi Jesu manasiŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Irec Jesurao fisirâ jaŋehec juocte hefârembiŋ. Eme Jesuzi mana-jarerâ šoaŋ gie bapa jajahec jaŋere haeo juwec. ");
INSERT INTO kmg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eme miti jazame bocjaha jâmbâŋzi mana šakiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ehuc ŋokac šiŋuc âzâcnembiŋ: “Qanaŋ gore dâŋ binaŋte erâ manasiŋkembeneŋ, ši ine nâŋe nâŋâc micticnaonec dâŋ manarâ šiŋuc manapaŋkeŋgopeneŋ: Eki jâmbomac mâreŋ sâc ŋic nâŋâcne Bâbâpiaŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Eme Jesu e jaŋehec gie bapa jajahec jurâ Galilaia mâreŋko rawec. ");
INSERT INTO kmg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesu e jahac qanaŋ šiŋuc mufuawec: “Porofete moc e jahacne hae mâreŋko jume sâcne mi sâseniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Eme Galilaia mâreŋko rafisime Galilaia ŋic jaŋe âgo ecnembiŋ. Ine jaŋe juwicnao mâmâc Jerusalem haeo rarâ aakic hombaŋko gie bame honembiŋte iŋuc ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Eme Kana haeo Galilaia mâreŋko mârâc mume opâzi waiŋ ewec ira hâcne mocwâc risiewec. Eme Kafanaum haeo kia moc juwec, e ŋokâ-ticne hucsâko bame fowec. ");
INSERT INTO kmg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eme Jesu e Judaia mâreŋkonec risierâ Galilaia mâreŋko mocwâc ware fisikac, iŋuc mupie manarâ kia e Kana haeo Jesurao rarâ ŋokâ-ticne hâmozo ehuc fowec irec jowame ranicte numucnewec. ");
INSERT INTO kmg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Eme Jesuzi šiŋuc âzâcnewec: “Ŋoŋe mâsi â wiac šâŋe furu-ŋeŋic sawa honerâ dâŋnane mana šakieeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eme ŋiczi muwec: “Wofuŋ, ŋokâ-nane hâmozacte biac fâzemec.” ");
INSERT INTO kmg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mume Jesuzi šiŋuc âzâcnewec: “Go mâc rac, ŋokâge ɋiɋic qakac.” Eme ŋic e Jesure dâŋ mana šakiehuc risie rawec. ");
INSERT INTO kmg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ehame motec jaŋe kiŋaŋ warerâ šiŋuc âzâcnembiŋ: “Ŋokâge ɋiɋic qajec jukac.” ");
INSERT INTO kmg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mupie ɋiɋic qawec dameŋ irec mu indiŋ ejareme mumbiŋ: “Jacne šoaŋ šâšâŋiŋ ŋehame ira hucticne âke niniŋkejec.” ");
INSERT INTO kmg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Iŋuc mupie ŋiczi fuŋne kecšiŋuc manawec: Dameŋ ira hâcne Wofuŋzi sorecnuhuc mujec, “Ŋokâge ɋiɋic qakac.” Eme e jahacne â garikiŋfâc-ticne Jesu manasiŋke-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesu e Judaia mâreŋkonec Galilaia mâreŋko risierâ fuŋne qaqa mâsi i bame jajahec ewec. ");
INSERT INTO kmg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Juku Judaŋic jaŋere hombaŋ sâko moc maickeme Jesu e Jerusalem haeo rafewec. ");
INSERT INTO kmg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eme Jerusalem haeo Lama Motâcko riqic moc ŋewec šâŋene Betesida Ere mecnao fic memoc ŋerawec. ");
INSERT INTO kmg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Fic ira ŋic huchec â tiŋtuŋ â šeke puriŋ â soc kekereŋhec bocjaha fombiŋ, ehuc opâ qiriŋ qaocte woŋeckembiŋ” ");
INSERT INTO kmg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wofuŋte aŋelo moczi dameŋ ocŋondeŋ sâc riqicko waharâ opâ qâuawec” qâuahame moczi bâbâni opâo huwec e huc ecnewec i niniŋkecneme ɋiɋic qawec.Ý ");
INSERT INTO kmg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Eme moc fowec e puriŋ ecnehuc juhame jara 38 ewec. ");
INSERT INTO kmg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eme Jesuzi ŋic e honerâ dameŋ šora fohuc jukac, iŋuc manarâ wiocnerâ muwec: “Go ɋiɋic qacmurâ egarekac me?” ");
INSERT INTO kmg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Eme puriŋzi muwec, “Bomboŋ, mo ŋic mo junarekaczi opâ qiriŋ qaha riqicko râecnuzac? Á no nahac huzo mupe ine moczi biac âkehocnurâ huekac.” ");
INSERT INTO kmg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mume Jesuzi šiŋuc âzâcnewec: “Go faharerâ fofoge rorâ rac.” ");
INSERT INTO kmg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mume izia sahac-ticne biaŋkeme faharerâ fofo-ticne ameckerâ rawec. Ʒoaŋ ira ine sabata hombaŋ ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Irec Judaŋic jaŋe ŋic ɋiɋic qawec e šiŋuc âzâcnembiŋ: “Miŋecgac hombaŋko fofoge hâpokomec i mi eene.” ");
INSERT INTO kmg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mupie šiŋuc jazawec: “Bâpiaŋnukaczi šiŋuc naza sorec ekac: `Fofoge rorâ rac. Ž ” ");
INSERT INTO kmg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mume wiocnerâ mumbiŋ, “Fofoge rorâ rac gazajec ŋic e šâŋene mo?” ");
INSERT INTO kmg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mupie ŋic biaŋkeweczi kâuc bawec. Jesu e ŋicguru ira domambiŋ jaŋere ŋondeŋko kamierâ rawec. ");
INSERT INTO kmg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Izi šâhec Jesuzi ŋic e taha ufuŋko bâfuarâ uŋ šiŋuc âzâcnewec: “Go sahacge biaŋkejec, eme wiac ŋemâc bâmâcne jâmbâŋ fua-garezacte sâqocne mocwâc mi bazemec.” ");
INSERT INTO kmg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eme ŋic e Jesu hone tararâ ra Judaŋic šiŋuc jazawec: “Ŋic bâpiaŋnukac šâŋene Jesu.” ");
INSERT INTO kmg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesu e sabata hombaŋko gie iŋucne bawecte Judaŋic jaŋe râsi ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Epie Jesuzi šiŋuc jazawec: “Mamac-nane e gie šušuhuc jaha baekac, eme noni iŋuc jaha wâc eekopac.” ");
INSERT INTO kmg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Eme Jesu e sabata hombaŋ hesifuckewec â Anuture Mamac-nane muhuc Anuture sâcko šuhuckewec, Judaŋic jaŋe wiac jajahec irec erâ mana gâpârerâ qaniŋte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Eme Jesuzi dâŋ šiŋuc jazawec: “No jâmbomac jâmbâŋ ŋazape mananiŋ, Ŋokâzi maŋticnere sâcne gie mi baekac, Mamaczi bame sâc honehuc baekac. Eki baekac ijaha Ŋokâzi baekac. ");
INSERT INTO kmg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mamac e Ŋokâ honebâckeekacte gie baekac sâc jâutu-fâreekac, erâ gie ši honeŋgopieŋ sawa mâcne, fekicne sâko jâutume ŋoŋe honerâ wareckeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mamac e hâmokicne wiwic-joparâ bâɋârec-jopaekac, iŋuc jaha Ŋokâzi e me e bâɋârezo murâ bâɋâreocmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Erâ Mamac e ŋic okacnere dâŋ mi mutara-jareekac, gie i Ŋokâre meo râewec. ");
INSERT INTO kmg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eme ŋic jaŋe Mamac sâseeŋgopieŋ iŋuc jaha Ŋokâ sâsenšepieŋ. Moc e Ŋokâ mi sâseocmuzi, Ŋokâ sorewec, Mamac hâcne, e iŋuc jaha mi sâseocmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","No jâmbomac jâmbâŋ ŋazape mananiŋ: Moczi nore dâŋ mana maŋ ehuc, sorecnuwec e manasiŋkeocmu, ŋic e šiŋuczia juju sanaŋhec ekac. E okacnere biŋe mi ee hâmoc râpeckerâ jujuo rašiwec jukac hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","No jâmbomac jâmbâŋ ŋazape mananiŋ: Dameŋ moc maickeocmu, erâ ši biac maickekac hâcne, ira hâmokicnezi Anutu Ŋokâ-ticne ere dâŋ manarâ ɋârerâ juniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mamac e jujure fuŋqizecne, eme Ŋokâ e iŋuc jaha jujure fuŋqizecne eocte qikiŋnecnewec ");
INSERT INTO kmg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Erâ e Ŋic Fâri Wâtuŋne jukacte ŋic,okacnere dâŋ mutara-jareocte mucnewec. ");
INSERT INTO kmg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dâŋ irec manapie mi quŋkezejec. Dameŋ moc bakicne fokac i maickeme šâŋeruŋko foeŋgopieŋ jaŋe ere dâŋ wiwira manarâ wefunšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ehuc juju biaŋne jumbiŋzi juju sanaŋte faharenšoŋgopieŋ, â juju sâqocne jumbiŋzi kiŋte okacne roniŋte faharenšoŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","No nahacne maŋte gie i bapane mi fokac, Mamac-nanere micsâcko sawa okacnere dâŋ mutara-jareekopac. Iŋuc ehuc okacnere gie bape sâckoa eocmu. I no nahacne dâŋ mâcne, sorecnuwec ere dâŋ šaeckeekopac. ");
INSERT INTO kmg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“No nahac fuŋne-nane mutaniŋkepe fârimâc eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Fuŋne-nane i moczi mutaniŋkeocmu, erâ no manakopac, fuŋne-nane mutaniŋkeme fârine eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ŋoŋe Johane mu indiŋ ecnepie dâŋ fâri qizecne mutaniŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Erâ ŋiczi fuŋne-nane mutaniŋkeniŋte ine mi muekopac, ŋoŋe fuŋne-nane manarâ jujure hata âteniŋte irec mâc ŋaŋacnere muekopac. ");
INSERT INTO kmg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johane e jâmbomac lambe sâko erâ tamae-ŋarewec. Ehame ŋoŋe mâc šâziriŋne nacbembeŋ hone aŋac ehuc jumbiŋ sawa. ");
INSERT INTO kmg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Á nore fuŋne mutaniŋkeekac, e Johane iŋucne mâcne, e sâc moc. Mamac gie munarewec, gie irec fârine bâfuape ine Mamaczi sorecnume wahapo irec fuŋne taniŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mamac sorecnuwec eki hâcne fuŋne-nane mutaniŋkewec. Ŋoŋe ine e jahacne mickonec dâŋ mi manambiŋ â hawarine wâc mi honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Erâ ŋoŋe dâŋticne maŋŋeŋicko sâcne mi râepie fohuc juekac. Ŋic sorewec ere dâŋ qikiŋnehuc wemocko iŋuc eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ŋoŋe miti papiao kecšiŋuc muhuc wose gufuc eeŋgopieŋ: Juju sanaŋ ira hâcne soŋkekicne. Erâ izi hâcne nore fuŋne mufuaekac. ");
INSERT INTO kmg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Eme ŋoŋe norao juhuc juju sanaŋhec ee i sifu qikiŋneeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“No ŋiczi sahac mumuteŋ wiac enareniŋte irec mi muekopac. ");
INSERT INTO kmg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ŋoŋere fuŋne ine jâmbomac manaekopac, maŋŋeŋic Anuturea mi domaekac. ");
INSERT INTO kmg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","No Mamac-nanere micte ŋoŋerao wahapo, eme ŋoŋe sifu âgo mi enareeŋgopieŋ. Juku ŋic moc e e jahacne maŋte fisime ine âgo ecneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ŋoŋe ŋaŋaczia mumuteŋ eec ehuc Anutu qâqâhâc sâko ere mumuteŋte mi eŋareekaczi wemocko mamanasiŋhec eniŋmu? ");
INSERT INTO kmg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ŋoŋe nore šiŋuc mi munšepieŋ: Eki Mamactao dâŋnâŋec mugâpâre-nâreocmu. Iŋuc mâcne, ŋoŋe ŋic moctao roweckeeŋgopieŋ, Mose hâcne, eki mugâpâre-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mose e dâŋ qâreŋkewec i nore qâreŋkewec. Eme ŋoŋe ere dâŋ mana šakierâ muzac nore mâmâc mana šakienšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mosere dâŋqâreŋ qikiŋnehuc nore dâŋ wemocko mana šakieniŋmu?” ");
INSERT INTO kmg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesu e dâŋ i mufârerâ Galilaia riqic, Tiberia riqic hâcne, fotâcnerâ ocniŋucnao rašiwec. ");
INSERT INTO kmg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Rašime ŋic ŋokac bocjahazi huc šâichec ɋiɋicne bacjopame honembiŋte bâjâpembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Eme Jesuzi motecfâcne rocjopame tikio ferâ ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dameŋ ira Judaŋic aakic hombaŋ-jeŋic bembeŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Eme Jesuzi šâŋe firâ ŋic guru sâko fisipie honec-joparâ Filipo wiocnerâ muwec, “Poroŋ wenirec furine barâ i sâko gumec-jopapene sâcjopaocmu?” ");
INSERT INTO kmg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E wiac eocte manasume foha mâc esâickewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Eme Filipozi šiŋuc muwec: “20 kinazi poroŋ furine barâ gumec-jopapene mâc hesâsâc-jopaocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mume motecfâcne jaŋeraonec moc, Anderea, Simoŋ Petorore ɋa, eki šiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ʒira motec moc jukac eki poroŋ memoc â opâ qowi jajahec bajukac, erâ ŋic guru sâko jâmbâŋte keci mac izi wemo ezo?” ");
INSERT INTO kmg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eme Jesuzi muwec, “Ŋoŋe ŋic ejarepie qâzuckerâ waha ŋeniŋ.” Eme mâreŋ ira kecɋaŋ fowec i toma âterâ ŋic 5 tauseŋ qâririŋ iŋuczi waha ŋerambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Eme Jesuzi poroŋ rorâ daŋge murâ ŋic ŋerambiŋ jaŋe bâtâc bajarewec â qowi iŋuc jaha mupie sâc jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nârâ gapec-jopame Jesuzi motecfâcne šiŋuc jazawec: “Tiwâne forâ sipirickezacte nuseniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eme jaŋe poroŋ memoc irec tiwâne nusepie sasac 12 hurâ fusewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eme ŋic jaŋe fuŋne qaqa mâsi i hone manac erâ mumbiŋ, “Porofete sâko mâreŋko fuaocte mukicne, šine hâcne jâmbâŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eme jaŋe Jesu orâŋkerâ mezi rorâ ŋicwofuŋ-jeŋic âkendâŋnezo ehapie hone tarac-joparâ behec-joparâ e jahackoaŋ tikio fewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hae owâeme motecfâcne jaŋe riqicmecko humbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hurâ Kafanaum haeo risie raniŋte wokeo fembiŋ. Erâ hae dapâc eme Jesu juhame buc rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ehuc mâŋâŋ sanaŋne domame siri kâcɋene qame rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jaŋe kilometa 4 me 5 irec sâc rakuhapie Jesuzi riqic faio âte âte rarâ woke bâqiŋkeme honerâ fâfârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iŋuc epie wira-jarerâ muwec: “Nâhâc fâkopac, mi hâwic-ŋopaoc.” ");
INSERT INTO kmg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eme wokeo ropie feocte ehapie izia woke mâreŋ razo mumbiŋko fisiwec. ");
INSERT INTO kmg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ŋic guru sâko jaŋe riqic ocniŋucnao fohapie hae furewec. Hae fureme šiŋuc mumbiŋ: “Jacne ŋafeo woke mocsâkoa ŋeme honembeneŋ, ira motecfâcne Jesu beherâ buc ferâ rambieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iŋuc manahuc ŋehapie Tiberia haeonec woke gâcne Wofuŋzi daŋge murâ poroŋ gumec-jopawecko ware fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eme ŋic jaŋe Jesu e jahacne â motecfâcne basac-joparâ wokeo ferâ Kafanaum haeo risie rarâ ira basambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Riqic šiŋucnao basaku bâfuarâ mumbiŋ, “Qaqazu, go wezimucne waremec?” ");
INSERT INTO kmg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wiocnepie šiŋuc jazawec: “No jâmbomac jâmbâŋ mupe mananiŋ, ŋoŋe fuŋne qaqa mâsi bape honeeŋgopieŋ irec mâcne, nânâ gumec-ŋopape nâ gapec embieŋ, irec basacnuŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ŋoŋe gie banšepieŋ, erâ nânâ sisirowenere mâcne, juju sanaŋte nânâ irec giene banšepieŋ. Ŋic Fâri Wâtuŋne eki, Anutu Mamaczi kamac sarahuc âkendâŋnewecte, juju sanaŋte nânâ i sâcne ŋareocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mume dâŋ šiŋuc bâtikiecnembiŋ: “Nâŋe weniŋuc erâ Anuture gie banaŋmu?” ");
INSERT INTO kmg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Eme šiŋuc jazawec: “Ŋic sorewec e manasiŋkezo, izi Anuture gie biŋe-ŋeŋic ekac.” ");
INSERT INTO kmg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mume dâŋ šiŋuc âzâcnembiŋ: “Mo fuŋne qaqa mâsi mo batec honerâ manasiŋgunaŋmu? Mo gie mo bacmu? ");
INSERT INTO kmg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mimiŋnefâc-nâŋec jaŋe mâreŋ sawao mana nâjumbieŋ. Eme irec dâŋqâreŋ šiŋuc fokac: `Sambâŋkonec nânâ jareme nâjumbieŋ. Ž ” ");
INSERT INTO kmg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Eme Jesuzi šiŋuc jazawec: “Jâmbomac jâmbâŋ mupe mananiŋ: Mose e sambâŋkonec nânâ mi bâfua-ŋarewec, Mamac-nanezi sambâŋkonec nânâ fârine ŋareekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nânâ sambâŋkonec waharâ mâreŋŋic juju bâfua-ŋareekac izi Anuturaonec nânâ fârine ekac.” ");
INSERT INTO kmg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mume šiŋuc âzâcnembiŋ: “Wofuŋ, go nânâ mukic i dameŋ sâc nârezemec.” ");
INSERT INTO kmg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Eme šiŋuc jazawec: “Jujure nânâ no hâcne. Moc e norao qohotaocmu e nânâre moc mi hâmoocmu, â moc e no manasiŋnuocmu e opâre moc mi hâmoocmu. ");
INSERT INTO kmg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","No ine ŋazape, ŋoŋe no honecnu-bipiehuc sifu mi manasiŋnueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mamaczi nareekac i jaŋe norao fisi-fâreniŋmu, â norao fisiocmu e mi bâsuepemu. ");
INSERT INTO kmg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sambâŋkonec wahapo i no nahacne micdâŋ dopeckepemurâ mâcne, sorecnuwec ere micdâŋ dopeckepemurâ wahapo. ");
INSERT INTO kmg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mamac-nanezi norao râec-jopaekac ŋic i jaŋe sipirickenšipiŋte hone qâzuc ejareku dameŋ sâkoo furu jaha wiwic-jopape faharenšoŋgopieŋ” sorecnuwec ere micdâŋ iŋuc hâcne fokac. ");
INSERT INTO kmg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ŋokâ hone dendeŋnehuc manasiŋkeniŋmu sâc juju sanaŋ rauckeniŋmu” Mamac-nanere micdâŋ iŋuc hâcne fokac. Eme noni dameŋ sâkoo bâɋârec-jopazokopac.” ");
INSERT INTO kmg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesu e “sambâŋkonec nânâ no hâcne” iŋuc muwecte Judaŋic jaŋe mana sâqorecnehuc dâŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ehuc šiŋuc mumbiŋ: “Wiac Jesu e Josefere ŋokâ, neŋgoc mamac jahec-ticne i nâŋe honec-jofaeŋgopeneŋ. Eme wemocte šiŋuc mukac: `No sambâŋkonec wahapo'?” ");
INSERT INTO kmg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mupie Jesuzi šiŋuc jazarâ muwec: “Ŋoŋe boc mi manapie sâqorezejec. ");
INSERT INTO kmg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ŋic moc e jahacne maŋte norao fifisi i mi fokac, Mamac sorecnuwec eki fâreme fifisine ine fokac. Eme noni ŋic iŋucne e dameŋ sâkoo bâɋârezokopac. ");
INSERT INTO kmg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Porofete jaŋere dâŋqâreŋ šiŋuc fokac: `Anutu e jahac ŋic sasawa miti jaza qazuc eocmu. Ž Irec moc e Mamaczi miti âzâcne qazuc eme manaocmu e norao fisiocmu. ");
INSERT INTO kmg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ŋic moczi moc Mamac honewec i mi fokac, Anuturaonec wahawec e mocjahazi Mamac honewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","No jâmbomac jâmbâŋ ŋazape mananiŋ: Moc e no manasiŋnuocmuzi juju sanaŋhec eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jujure nânâ no hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mimiŋnefâc-ŋeŋic jaŋe mâreŋ sawao mana nâipiehuc hâmo-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Á sambâŋkonec nânâ nârâ mi hâhâmo ine norao fokac ši. ");
INSERT INTO kmg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jujure nânâ sambâŋkonec wahakicne no nahacne hâcne. Irec moc e noraonec nânâ nârâ jurašihuc juocmu sanaŋ. Biuc-nanezi nânâ ekac, i ŋiczi juju bâfuaniŋte ŋarepemu.” ");
INSERT INTO kmg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Eme Judaŋic jaŋaczia mu qaqatarac erâ mumbiŋ, “E weniŋuc erâ biuc-ticne nâreme nanaŋmurâ mukac?” ");
INSERT INTO kmg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Epie Jesuzi šiŋuc jazawec: “No jâmbomac jâmbâŋ ŋazakopac, ŋoŋe Ŋic Fâri Wâtuŋne ere biuc â soc mi nâniŋmuo maŋŋeŋicko juju mi fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Moc e nore biuc â soc nâocmuzi juju sanaŋhec eocmu, eme noni dameŋ sâkoo bâɋârezokopac. ");
INSERT INTO kmg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nore biuc izi nânâ fârine, â nore soc izi opâ fârine. ");
INSERT INTO kmg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nore biuc â soc nâocmuzi no maŋnuocmu â noni e maŋkepemu. ");
INSERT INTO kmg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mamac e juju runezi sorecnume wahapore Mamacte erâ juekopac, eme no nâcnuocmuzi iŋuc jaha nore erâ juocmu. ");
INSERT INTO kmg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sambâŋkonec nânâ irec fuŋne iŋuc fokac. I mimiŋnefâc-ŋeŋic nâmbiŋ iŋucne mâcne. Jaŋe nâipiehuc hâmombiŋ. Á nore nânâ ši nâocmu e ine jurašihuc juocmu sanaŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesu e Kafanaum haeo mitificko juhuc dâŋ i jaza qazuc ewec. ");
INSERT INTO kmg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kikefuŋfâc-ticne jaŋeraonec bocjahazi dâŋ i manarâ mumbiŋ, “Dâŋ kecši manapene ququŋkenehec ekac, i mozi manaocmu?” ");
INSERT INTO kmg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Eme mu takic embiŋ i Jesu e maŋticnezi manarâ šiŋuc jazawec: “Dâŋ i manapie sâqorekac me? ");
INSERT INTO kmg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eme Ŋic Fâri Wâtuŋnezi mârâc juweckoa risie feme manapie weniŋuc eocmu? ");
INSERT INTO kmg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sahacte biuczi juju bâbâfua i mi fokac, juju bâbâfua i Mârore gie. No dâŋ ŋazaekopac i Mârohec â jujuhec. ");
INSERT INTO kmg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Eme ŋoŋeraonec tucnezi ine mana maŋ mi eeŋgopieŋ.” Jesu e miti-ticne qikiŋneniŋmu jaŋe mârâcko mana tarac-jopawec, â doc baocmu e mâmâc mana tarawec, irec dâŋ iŋuc jazawec. ");
INSERT INTO kmg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Erâ dâŋ moc šiŋuc šuhuckerâ muwec: “No irec hâcne kecšiŋuc ŋazapac: Moc e Mamaczi mi baafeckeha norao fisirâ jujune mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eme dameŋ ira kikefuŋfâc-ticne jaŋeraonec bocjahazi jume jujure takic-jopame râpeckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Eme Jesuzi motec fuŋfuŋfâc-ticne 12 indiŋ-joparâ muwec, “Ŋoŋe iŋuc jaha râpecnuzo muŋgopieŋ me?” ");
INSERT INTO kmg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mume Simoŋ Petorozi šiŋuc âzâcnewec: “Wofuŋ, go behecgurâ moc morao ranaŋmu? Go mocjahazi juju sanaŋte dâŋ bajuekic. ");
INSERT INTO kmg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nâŋe go manasiŋguhuc šiŋuc mana-gareeŋgopeneŋ: Go Anuture Tiriŋic hâcne.” ");
INSERT INTO kmg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Eme Jesuzi šiŋuc jazawec: “No motec ŋoŋe 12 rowosâec-ŋopapo. Eme wemocte ŋoŋeraonec moczi Sataŋ ekac?” ");
INSERT INTO kmg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","E Juda Simoŋte ŋokâ Karioto haeonec ere manasuhuc iŋuc muwec. E motec 12 jaŋere guruoneczi hâcne juku šâhecko Jesu doc bawec. ");
INSERT INTO kmg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jerusalem haeonec Judaŋic jaŋe Jesu qaniŋte dâŋ qacnepie Judaia mâreŋ-jeŋic qikiŋnerâ Galilaia mâreŋko sawa rac warec ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ehuc juhame Judaŋic rehac boze hombaŋ-jeŋic bembeŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ehame ɋafâc-ticne šiŋuc âzâcnembiŋ: “Go šawierâ Judaia mâreŋko rarâ, šira mâsi wiac baekic i ocna batec kikefuŋfâcge jaŋe honenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mozi fua tâcnezo murâ soŋsoŋ juhuc gie baocmu? Go gie iŋucne bazo muekicte ra ŋicguruo fua taniŋkerâ batec honeniŋ me!” ");
INSERT INTO kmg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ɋafâc-ticne jaŋe e mi manasiŋkehuc iŋuc mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mupie Jesuzi šiŋuc jazawec: “Ŋoŋe dameŋ kosao wiac ezo murâ sâcne eniŋmu, no ine dameŋ-nane mi maickekac. ");
INSERT INTO kmg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ŋic jaŋe ŋoŋe wemocko qaisoc-ŋopaniŋmu, no ine juju bapa-jeŋic sâqocne i mutaniŋkepe qaisocnueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ŋoŋe hombaŋko raniŋ, no ine dameŋ-nane mi maickekacte šiŋuczia mi rapemu.” ");
INSERT INTO kmg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iŋuc murâ Galilaia mâreŋkoa juwec. ");
INSERT INTO kmg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Eme jaŋe bânierâ rahapie e šâhecko buc kamierâ rawec. ");
INSERT INTO kmg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Eme hombaŋ maickeme Judaŋic micne jaŋe basarâ wiwioc erâ mumbiŋ, “E wena jukac?” ");
INSERT INTO kmg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Á ŋic omane sâko jaŋe ere dâŋ bocjaha mufembiŋ. Ehuc gâcnezi mumbiŋ, “E ŋic biaŋne,” â gâcnezi qatararâ mumbiŋ, “Aricne, e ŋic maŋ bâsifuc ejareekac.” ");
INSERT INTO kmg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Erâ Judaŋic micne jaŋere hâwic-jopame dâŋ tâtâcko mi mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Eme hombaŋ šâšâŋiŋko Jesu e taha ufuŋko ferâ miti jaza qazuc ewec. ");
INSERT INTO kmg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Miti mume Judaŋic micne jaŋe wareckerâ šiŋuc mumbiŋ: “E nâŋâcne mamana ficko mi juweczi weniŋuc erâ mitire fuŋne manaekac?” ");
INSERT INTO kmg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mupie Jesuzi šiŋuc jazawec: “No mitire fuŋne qazu-ŋareekopac i no nahacne mâcne, i sorecnuwec ere. ");
INSERT INTO kmg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Eme mitire fuŋne kecši i Anuturaonec me no nahacnaonec, i Anutu micne reŋkehuc mana tarazo. ");
INSERT INTO kmg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Moc e jahacnaonec manasurâ muocmu, e sahac mumuteŋte hata âteocmu, â moc e gie runere mumuteŋ fuaocte gie baocmu, ere ine sahac fefe tâmiric siocmâc jukac muzo. ");
INSERT INTO kmg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose e sâcmutâc dâŋ mufua-ŋarewec. Á ŋoŋeraonec moczi moc mi reŋkeekac. Eme ŋoŋe wemo wiacte nuzo muŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mume ŋic omane sâko jaŋe mumbiŋ, “Go demoŋzi maŋge bâsifuckekac. Mozi guzo mukac?” ");
INSERT INTO kmg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Eme Jesuzi jazawec, “No mâsi mocjaha bapo irec erâ mu warec boc eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mupe mananiŋ: Mosezi motecfâc-ŋeŋic sahac-jeŋicko ma baniŋte muŋarewec. Erâ i Mosezi mi fuŋkewec, mimiŋne jaŋe fuŋkembiŋ. Eme gie i bapane maickeme sabata hombaŋko wâc baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ine hâcne Mosere sâcmutâc dâŋ huckepie fârimâc ezacte hombaŋko motecfâc-ŋeŋic sahac tofa-jeŋicko gie i baeŋgopieŋ, â no ine ŋicpuriŋ sahac-ticne furu jaha hombaŋko bâpiaŋkepo, irec wemocte mana gâpâre-nareŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ŋoŋe dâŋ onšoŋ jaha sahacne mi muniŋ, mana wosâehuc dâŋ fârine munšapiŋ me!” ");
INSERT INTO kmg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Eme Jerusalem hae rune jaŋe šiŋuc mumbiŋ: “Ŋic qazo mueŋgopieŋ ine hâcne ši. ");
INSERT INTO kmg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hâc, e weniŋuc erâ dâŋ tâtâcko mume micnefâc-nâŋec jaŋe mi qataracneŋgopieŋ? Me jaŋe fuŋne-ticne mana tarahuc manacnepie Kristo ekac mecne? ");
INSERT INTO kmg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Erâ iŋuc wâc mâcne mecne. E fufua-ticnere fuŋne manaŋgopeneŋ. Kristo wareocmu ine ere fuŋne kâuc bafârenaŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesu e taha ufuŋko miti qazu-jarehuc domahame iŋuc mupie hahaŋne bahuc muwec, “Oi ŋoŋe, mana taracnurâ fufua-nanere fuŋne manaeŋgopieŋ, ŋoŋe hâcne. Wahapo i no nahacne maŋte mi wahapo, jâmbomac rune moc jukac eki sorecnume wahapo. Ŋoŋe e kâuc baŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","No ine e jahacne bufuŋkonec sorecnume wahapore e mana tarakopac.” ");
INSERT INTO kmg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iŋuc mume kâpâcwâru baniŋte mumbiŋ. Erâ dameŋ-ticne mi maickewecte mejeŋic mâckeme behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ehame ŋic omane jaŋeraonec bocjahazi fuŋkerâ Jesu manasiŋkembiŋ. Ehuc šiŋuc mumbiŋ: “Kristo fisiocmu, e ŋic šizi mâsi baekac i sirickehuc baocmu me? Aricne, e bafâreekac.” ");
INSERT INTO kmg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ŋic jaŋe dâŋ iŋucne kamierâ mupie farisaio jaŋe manarâ taha bapa micne jaŋehec nazaŋ gazaŋ erâ momori jaŋe Jesu kâpâcwâru baniŋte sorec-jopapie rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Eme Jesuzi ŋic šiŋuc jazawec: “No dameŋ bembeŋne sawa ŋoŋehec jurâ sorecnuwec erao risiepemu. ");
INSERT INTO kmg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Eme ŋoŋe no basacnu-bipiehuc mi bâfuacnuniŋmu. Ra jupemu ira wemocko fâniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Iŋuc mume Judaŋic jaŋe šiŋuc muhuc nazaŋ gazaŋ embiŋ: “E wena rame basa-bipienaŋte mukac? Judaŋic âgofâc-nâŋec Grië mâreŋko juraŋgopieŋ jaŋerao raocte mukac, ehuc Grië miti jazaocte manasuhuc mukac? ");
INSERT INTO kmg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Basacnu-bipiehuc mi bâfuacnuniŋmu, â rapemu ira sâcne mi fâniŋmu, dâŋ iŋucne weniŋucte mukac?” ");
INSERT INTO kmg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Judaŋic jaŋe hombaŋ botâŋne ŋetaraniŋte tutumaŋ sâko ehuc ŋehapie Jesuzi faharerâ domahuc dâŋ wiwic jaha šiŋuc muwec: “Moc e opâre hâmokacko norao warerâ nâzejec. ");
INSERT INTO kmg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Á moc e manasiŋnuhuc juocmu ere bumaŋkonec opâ sâro fifisine wahahuc domaocmu. Miti papiao dâŋ iŋuc hâcne qâreŋkekicne.” ");
INSERT INTO kmg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesu manasiŋkembiŋ jaŋe Mâro biŋe qajarehuc iŋuc muwec. Jesu e dameŋ ira sambâŋ eri tatamac-ticnere maŋnao mi risie fewecte Mâro mi wahawec. ");
INSERT INTO kmg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ŋic jaŋe dâŋ i manarâ Jesure šiŋuc mumbiŋ: “E jâmbomac porofete sâko-nâŋec.” ");
INSERT INTO kmg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Á gâcnezi mumbiŋ, “E Kristo jâmbâŋ.” Mupie tucnezi qatararâ mumbiŋ, “Wiac Kristo e wemocko Galilaia mâreŋkonec fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tiri Papiao dâŋ šiŋuc mukicne: Kristo e Dawidire haefuŋ Betelehem ira oso gitecfâc-ticne jaŋere ŋondeŋkonec fuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ŋic jaŋe Jesure iŋuc muhuc fâuckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eme gâcnezi kâpâcwâru baniŋte murâ mejeŋic mâckeme behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Eme momori jaŋe taha bapa micne â farisaio jaŋerao risiepie wio-jarerâ mumbiŋ: “Ŋoŋe wemocte mi rorâ bawareŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wiopie momori jaŋe mumbiŋ, “E dâŋ muekac, iŋucne ŋic gâcnezi.mumune mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mupie farisaio ŋic jaŋe šiŋuc jazambiŋ: “Me, ŋoŋe iŋuc jaha maŋ bâsifuc eŋarejec? ");
INSERT INTO kmg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Soŋaŋ kâcɋene â farisaio ŋic nâŋeraonec moczi erao moc qohotakac me? ");
INSERT INTO kmg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","I aricne i, ŋic omane guru, sâcmutâc dâŋ mi mamana jaŋe sawa, hârâcte biŋe jaŋe hâcne.” ");
INSERT INTO kmg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Eme âgo-jeŋic moc Nikodemo, mârâc Jesu iqickewec, eki ine šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ŋoŋe muniŋ, ŋic moc fuŋne-ticne mi manahuc â kiŋticne mi honehuc okacnere dâŋ mâc mumutarane, iŋuc ezore sâcmutâc papia-nâŋecko moc qâreŋkekicne fokac me?” ");
INSERT INTO kmg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eme âgofâcne jaŋe šiŋuc mumbiŋ: “Eme go iŋuc jaha Galilaia mâreŋkonec me? Wose gufuc eku šiŋuc manacmu: Galilaia mâreŋkonec porofete fufuane mi fokac.”  ");
INSERT INTO kmg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Eme jaŋe râwiŋnerâ ficjeŋic sâc rafârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu e Oliwa tikio fewec. ");
INSERT INTO kmg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hae fureme irecnec risierâ taha ufuŋko feme ŋic jaŋe erao mâretec tumaŋnembiŋ. Eme ira ŋehuc miti jaza qazuc ewec. ");
INSERT INTO kmg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ehame miti qaqazu â farisaio ŋic jaŋe ŋokac moc boe sau ehuc juhame bâfuakicne e Jesurao bararâ ");
INSERT INTO kmg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","mumbiŋ, “Qaqazu, ŋokac kecši boe sau ehuc juhame bâfuakicne. ");
INSERT INTO kmg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Eme Mose e ŋokac iŋucne qânâzi hehâmoc-jopazore sâcmutâc dâŋko munârewec. Gahac ine weniŋuc mukic?” ");
INSERT INTO kmg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","I mâc esâickepie dâŋ iŋuc me iŋuc mume dâŋko râeniŋte fecnehuc mumbiŋ. Mupie Jesu e daperâ mâreŋko mezi qâreŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qâreŋkehame wiocnerâ wiocne epie qâhâŋnerâ šiŋuc jazawec: “Ŋoŋeraonec moc bahac tâmiric juekaczi fuŋkerâ qânâzi heme henšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iŋuc murâ mocwâc daperâ mâreŋko qâreŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ehame jaŋe dâŋticne manarâ micnezi bânieme moc moc raku rafârembiŋ. Eme ŋokac e Jesure maŋfuŋko buc domame, ");
INSERT INTO kmg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesuzi qâhâŋnerâ wiocnerâ muwec: “Ŋokac, jaŋe wena? Moczi moc okacnere dâŋ mi mugarejec me?” ");
INSERT INTO kmg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Eme ŋokazi muwec, “Wofuŋ, aricne.” Mume muwec, “Eme noni iŋuc jaha okacnere dâŋ mi mugarepemu. Go mâc ra juhuc sâqocne mocwâc mi bazemec.” ");
INSERT INTO kmg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Eme Jesuzi ŋic dâŋ moc šiŋuc šuhuckerâ jazawec: “No mâreŋ sâc ŋic ŋoŋere šoctamac. Eme moc e no bâjâpecnuocmuzi dapâcko mi rahuc juocmu. E jujure tatamac focnehame juocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Iŋuc mume farisaio ŋic jaŋe šiŋuc âzâcnembiŋ: “Ʒi go gahac fuŋnege mutaniŋkekomec, i manapene fârine mi ekac.” ");
INSERT INTO kmg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mupie Jesuzi šiŋuc jazawec: “No nahac fuŋne-nane mutaniŋkepe irec fârimâc mi eekac. No wenirec warepo â wena rapemu irec fuŋne manahuc dâŋ muekopac. Ŋoŋe ine irec â irec mâmâc kâuc baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ŋoŋe fuŋne riritu gie baeŋgopieŋ i sasahac eekac. No ine fuŋne riritu gie mi baekopac. ");
INSERT INTO kmg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Me fuŋne riritu gie bapemuo ine fârinehec eocmu. No fuŋne riritu gie buc bapane mi fokac. Mamac sorecnuwec eki baficnume bapane fokac. ");
INSERT INTO kmg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Eme sâcmutâc dâŋŋeŋicko kecšiŋuc fokac: `Ŋic jajaheczi mocte fuŋne ritupire fârine muzo. Ž ");
INSERT INTO kmg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eme no fuŋne-nane mutaniŋkehape Mamac sorecnuwec eki iŋuc jaha mutaniŋkeekac.” ");
INSERT INTO kmg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dâŋ iŋuc jazame wiocnerâ mumbiŋ, “Mamacge wena?” Eme šiŋuc jazawec: “Ŋoŋe no mi mana taracnuhuc Mamac-nane iŋuc jaha mi mana taraeŋgopieŋ, no mana taracnurâ muzac, Mamac-nane iŋuc jaha mana taranšapiŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu e ufuŋko taha katapa ŋewec maŋne ira miti jaza qazuc ehuc dâŋ i muwec. Eme dameŋ-ticne mi maickewecte wemocko afeckerâ kâpâcwâru banšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Eme Jesu e harierâ šiŋuc jazawec: “No behec-ŋopa rape ŋoŋe basacnurâ sâqocne-ŋeŋichec juku hâmoniŋmu. No ra jupemu ira wemocko fâniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iŋuc mume Judaŋic jaŋe mumbiŋ, `à `No ra jupemu ira wemocko fâniŋmu', iŋuc wemocte mukac? Sahac-ticne qarâ hâmoocte mukac me weniŋuc?” ");
INSERT INTO kmg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Eme Jesuzi šiŋuc jazawec: “Ŋoŋe juwickonec, no faickonec, ŋoŋe mâreŋkonec, no mâreŋkonec mâcne. ");
INSERT INTO kmg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","No irec hâcne ŋazakopac: ŋoŋe sâqocne-ŋeŋichec juku hâmoniŋmu. No jukopac ši fuŋne-nane ŋazaekopac i mi mana šakieniŋmuo, sâqocne-ŋeŋic foŋarehame hâmoniŋmu hâcne.” ");
INSERT INTO kmg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mume wiocnerâ mumbiŋ, “Eme go mo?” Mupie Jesuzi jazawec, “Ŋazaekopac i jâmbâŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No ŋoŋere bahac â kiŋdâŋ bocjaha bajuekopac. Sorecnuwec eki dâŋ fârine muekac, eme noni micticnaonec manapo ijaha šira mâreŋko mufuaekopac.” ");
INSERT INTO kmg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mamac-ticnere iŋuc jazame jaŋe mi mana tarambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Irec Jesuzi šuhuckerâ šiŋuc jazawec: “Ŋoŋe Ŋic Fâri Wâtuŋne bâfeŋnerâ fuŋne-ticne mana taraniŋmu. Erâ no nahacne maŋte wiac mi eekopac, Mamaczi qazu-narewec dâŋ ijaha muekopac, i wâc mana taraniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sorecnuwec e nohec juekac. No dameŋ sâc wiac epe bape maname biaŋkeekacte no mi behecnuekac.” ");
INSERT INTO kmg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dâŋ iŋuc mume ŋic bocjahazi manasiŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eme e manasiŋkembiŋ Judaŋic jaŋe hâcne šiŋuc jazawec: “Ŋoŋe nore dâŋko juhuc ine motec fuŋfuŋfâc-nane eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Eme nore dâŋ fâri qizecne mana tarapie izi batarac-ŋopame niŋgiŋ tâmiric sâcne erâ juniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mume dâŋ šiŋuc bâtikiecnembiŋ: “Nâŋe Abrahamte ɋâricfâc, mozi mo kiŋaŋ qaqafâc-ticne bacnâporâ niŋgiŋ-nâpowecte go šiŋuc mukomec: `Niŋgiŋ tâmiric eniŋmu'?” ");
INSERT INTO kmg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Eme Jesuzi šiŋuc jazawec: “No jâmbomac jâmbâŋ ŋazakopac, moc e sâqocne baocmuzi sâqocnere kiŋaŋ qaqa eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kiŋaŋ qaqazi bomboŋ-ticnere fic haeoa hati mi jurâ ju eocmu, ŋokâzi ine mamac-ticnere fic haeo hati jurašihuc juocmu. ");
INSERT INTO kmg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Irec Ŋokâ eki firuec-ŋopame ŋoŋe jâmbomac niŋgiŋ tâmiric juniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Ŋoŋe Abrahamte ɋâricfâc, i noni manakopac. Eme ŋoŋe ine dâŋnanezi ŋoŋerao hesowariekacte qâhâmocnuzo muŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","No Mamac-nanerao wiac honehuc jupo irec hâcne muekopac, â ŋoŋe ine ŋaŋacne mamactaonec wiac manambiŋ i eeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mume šiŋuc âzâcnembiŋ: “Nâŋe mamac-nâŋec Abraham.” Eme Jesuzi šiŋuc jazawec: “Ŋoŋe Abrahamte ɋâricfâc jurâ muzac e hawari enšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anuturao dâŋ fâri qizecne manapo i ŋazaekopac, ehame ŋoŋe nuzo muŋgopieŋ. Wiac iŋucne Abrahamzi mi ewec. ");
INSERT INTO kmg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ŋoŋe ine ŋaŋacne maŋte hata âteeŋgopieŋ.” Eme jaŋe mumbiŋ, “Nâŋe fiuckonec mi fuambeŋ, Anutu e Mamac-nâŋec mocjaha.” ");
INSERT INTO kmg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mupie Jesuzi šiŋuc jazawec: “Mamac-ŋeŋic Anutu eme muzac, no âgo enarenšapiŋ. No Anuturaonec hâcne wahapo, no nahacne. maŋte mi wahapo, eki sorecnume wahapo. ");
INSERT INTO kmg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Weniŋuc erâ jupie dâŋnanezi maŋŋeŋicko mi huekac? No dâŋ mupe ŋoŋe hazec afec mi manaeŋgopieŋ irec hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ŋoŋe mamac-ŋeŋic Sataŋ, eme ere qafeŋko wiac eeŋgopieŋ. E mârâc jaha ŋic sisipiric juweczi juwareekac. E dâŋ fâri qizecne râpeckewecte maŋticnao jâmbomac dâŋ moc mi fokac. E bureczi nânâ opâ-ticne ewec. E burecŋic â burecte mamac. ");
INSERT INTO kmg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","No ine dâŋ fâri qizecne ŋazaekopacte dâŋnane qikiŋneeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ŋoŋeraonec moczi sâcne nore bahac moc muocmu? Eme no sâc iŋucnezi dâŋ fâri qizecne ŋazape wemocte mi mana šakieeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Moc e Anuture biŋe juocmuzi dâŋticne manaocmu. Ŋoŋe Anuture biŋe mi jueŋgopieŋte dâŋticne qikiŋneeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mume Judaŋic jaŋe dâŋ šiŋuc bâtikiecnembiŋ: “Wiac wemo mueŋgopeneŋ, go Samaria ŋic, go demoŋzi egareekac.” ");
INSERT INTO kmg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Eme Jesuzi šiŋuc jazawec: “No demoŋzi mi enareekac, no Mamac-nane sâseekopac, ŋoŋe ine no ba jawa enareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","No šâŋe biŋe-nanere manabâc erâ mi ŋazakopac. šâŋe biŋe-nane hewirickerâ irec dâŋne mumu ine mocte gie. ");
INSERT INTO kmg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","No jâmbomac jâmbâŋ ŋazape mananiŋ: Moc e nore dâŋ bajuocmuzi hâmoc moc mi maicke-jâmbâŋkeocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iŋuc mume Judaŋic jaŋe kecšiŋuc mumbiŋ: “Demoŋzi egareekac, i jâmbomac. Abraham hâmowec, â porofete jaŋe iŋuc jaha hâmombiŋ, ehame go šiŋuc mukic: `Moc e nore dâŋ bajuocmuzi hâmoc moc mi maickeocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mamac-nâŋec Abraham e sâkozi hâmowec, eme go ere sâc jâuruzo mukomec? Á porofete jaŋe iŋuc jaha wâc hâmombiŋ. Go wemocte sahacge boc bafekomec?” ");
INSERT INTO kmg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mupie Jesuzi šiŋuc jazawec: “No nahac sahac-nane bafepe mi sâckeocmu. Mamac-nane jukac, e Anutu-nâŋec mucneeŋgopieŋ, eki ine muafecnuekac. ");
INSERT INTO kmg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ŋoŋe e mi mana taraeŋgopieŋ, no ine mana taraekopac. Irec no weniŋuc mi mana tarakopac mupemu. I mupe burec eme ŋoŋere sâc ezapo. Aricne, no mana tarahuc dâŋticne bajuekopac. ");
INSERT INTO kmg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mamac-ŋeŋic Abraham e nore šâfo maickeme honeocte aŋac sâko bajuwec. Erâ juku maickeme honerâ šeri ewec.” ");
INSERT INTO kmg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iŋuc mume Judaŋic jaŋe mumbiŋ, “Go jarage 50 mi bazumeŋzi Abraham honemeŋ me?” ");
INSERT INTO kmg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mupie Jesuzi jazawec: “No jâmbomac jâmbâŋ ŋazape: No Abraham mi fuarâ juhame jupozi jukopac.” ");
INSERT INTO kmg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iŋuc mume qânâ rorâ hezo epie e fosiroŋnerâ taha ufuŋkonec wahawec. ");
INSERT INTO kmg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu e hata rahuc ŋic moc neŋgoc bumaŋkonec tiŋtuŋ fuakicne e bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eme motecfâcne jaŋe wiocnerâ mumbiŋ, “Qaqazu, more kiŋte tiŋtuŋ fuawec, e jahacne me neŋgoc mamac jahere?” ");
INSERT INTO kmg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mupie Jesuzi šiŋuc jazawec: “Irec aricne, e jahacne kiŋte me neŋgoc mamac jahere kiŋte mâcne, Anutu tâpiri-ticnere fuŋne erao taniŋkeocte iŋuc fuawec. ");
INSERT INTO kmg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nâŋâc sorecnuwec ere gie šoaŋkoa bahuc junšepeneŋ, ŋafe fuame gie bapane arictac eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","No mâreŋko jupemu sâc šoctamac-nanezi âke tamae-ŋareocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iŋuc murâ mâreŋko tâfeckerâ afe jârickerâ ŋic tiŋtuŋ šâŋene ruacnerâ ");
INSERT INTO kmg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","šiŋuc muhuc sorewec: “Go rarâ Siloam riqicko wânâŋge šurec.” (Siloam i nâŋâcne dâŋko sorekicne.(c) Eme ŋic e rarâ sahac-ticne šurehuc šâŋe fitâcnewec. ");
INSERT INTO kmg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iŋuc erâ risieme âgofâc-ticne jaŋe, â nânâre numu-jarehuc juwec ŋic i jaŋe mâmâc honerâ wiwioc erâ mumbiŋ: “Nânâre numu-nârehuc ŋeŋerâ juekac e hâcne me?” ");
INSERT INTO kmg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eme tucnezi mumbiŋ, “Ine hâcne.” Á tucnezi mumbiŋ, “Aricne, e tinac moc.” Iŋuc mupie e jahac muwec, “No hâcne ši `à ");
INSERT INTO kmg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eme wiocnerâ mumbiŋ, “Weniŋuc erâ šâŋe fitâcnekomec?” ");
INSERT INTO kmg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Eme jazawec, “Ŋic moc šâŋene Jesu eki afe jârickerâ šâŋe-nane ruacnerâ šiŋuc nazajec: `Go Siloam riqicko rarâ sahacge šurec. Ž Eme no rarâ sahac-nane šurerâ šâŋe fifi epac.” ");
INSERT INTO kmg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iŋuc mume wiocnerâ mumbiŋ, “Ŋic e wena jukac?” Eme muwec, “No mi manakopac.” ");
INSERT INTO kmg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Eme ŋic tiŋtuŋ ecnewec e farisaio jaŋerao jowa rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Eme Jesuzi afe jârickerâ šâŋene bâtâcnewec i sabata hombaŋko ewec. ");
INSERT INTO kmg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eme farisaio ŋic jaŋe iŋuc jaha wiocnerâ mumbiŋ, “Go weniŋuc erâ šâŋe fifi emec?” Mupie šiŋuc jazawec: “E šâŋe-nane afe ruacneme no ra sahac-nane šurerâ šâŋe fifi epac.” ");
INSERT INTO kmg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Eme farisaio jaŋeraonec gâcnezi mumbiŋ, “Ŋic e Anuturaonec aricne, e hombaŋ-nâŋec qâsuakac.” Gâcnezi ine mumbiŋ, “E hehesic juhuc muzac mâsi iŋucne wemocko bazac.” Iŋuc muhuc qaqatarac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ehuc ŋic tiŋtuŋ ecnewec e indiŋkerâ mumbiŋ, “Ʒâŋege bâtâcnejec, gahac ere weniŋuc mukic?” Eme muwec, “E porofete.” ");
INSERT INTO kmg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Eme Judaŋic jaŋe ŋic e jâmbomac šâŋe tiŋtuŋ juku šâŋe fifi ejec, iŋuc muhuc maŋjahec erâ neŋgoc mamac jahec-ticne hefârec-jofarâ ");
INSERT INTO kmg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","wio-jacterâ mumbiŋ: “Ŋokâ-ŋekic tiŋtuŋ fuawec mukopirec šine hâcne? E weniŋuc erâ šâŋe fifi ejec?” ");
INSERT INTO kmg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eme neŋgoc mamac jahecne šiŋuc mupic: “E ŋokâ-nâhec, i manakoperec, â tiŋtuŋ fuawec, i wâc manakoperec. ");
INSERT INTO kmg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Erâ weniŋuc erâ šâŋe fifi ejec, me mozi šâŋene bâtâcnejec, ine mi manakoperec. Wiac e soka-fârekicne, irec e jahacne wiocnepie fuŋne-ticne ŋazaoc.” ");
INSERT INTO kmg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","I Judaŋic jaŋere hâwic-jofame iŋuc mupic. Jaŋe dâŋ šiŋuc mujomirembiŋ: “Moc e Jesure Kristo mume miti sakarecnenšepeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Irec hâcne neŋgoc mamac jahec-ticne hâwic-jofame šiŋuc mupic: “E soka tarakicnere e jahacne wiocneniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eme ŋic šâŋe tiŋtuŋ ecnewec e mocwâc hefârerâ šiŋuc âzâcnembiŋ: “Go Anutu muteŋkehuc dâŋenšaŋ, nâŋe ŋic ere fuŋne manaŋgopeneŋ, e hehesicne.” ");
INSERT INTO kmg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mupie šiŋuc jazawec: “E ŋic hehesicne me mâcne, i mi manakopac. Á tiŋtuŋ jupozi šâŋe fifi epac, ine mana-jâmbâŋkekopac.” ");
INSERT INTO kmg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mume harierâ wiocnembiŋ, “Weniŋuc egarejec, weniŋuc erâ šâŋege bâtâcnejec?” ");
INSERT INTO kmg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mupie šiŋuc jazawec: “No ŋazapac i, ŋoŋe ine mi manambieŋ” wemocte hâsine ŋazape mananiŋte muŋgopieŋ? ŋoŋe motecfâcne ezo muŋgopieŋ me?” ");
INSERT INTO kmg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Iŋuc mume haneckerâ mumbiŋ, “Go hâcne motec-ticne, nâŋe ine Mosere motecfâc. ");
INSERT INTO kmg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mose e Anutuzi dâŋ âzâcnewec, i manaŋgopeneŋ, â ŋic e irec me irec fuarâ warewec ine mi manaŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mupie ŋiczi dâŋ šiŋuc bâtikie-jarewec: “Ʒâŋe-nane bâtâcnejec ere fufuare kâuc bapie warec-ŋopakopac. ");
INSERT INTO kmg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nâŋâc kecšiŋuc manaeŋgopeneŋ: Anutu e ŋic hehesicne mi bafic-jopaekac, moc e araŋ bacnehuc micne reŋkeme bafickeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Á ŋic moczi tiŋtuŋ fuakicne moc šâŋe fifi bawec, biŋe iŋucne mâreŋ fufuaonecteaŋ moc mi mana wefukicne. ");
INSERT INTO kmg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Irec ŋic e Anuturaonec mi waharâ muzac, gie iŋucne wemocko bazac.” ");
INSERT INTO kmg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mume šiŋuc âzâcnembiŋ: “Sâqoc qaqocne fuakicne go iŋucnezi miti qazu-nârekomec me?” Iŋuc murâ tuŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tuŋkepie Jesuzi manawec. Erâ bâfuarâ wiocnerâ muwec, “Go Ŋic Fâri Wâtuŋne e manasiŋkekomec?” ");
INSERT INTO kmg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Eme ŋiczi muwec, “Wofuŋ go mukomec e mo? Nowatutec hone tararâ manasiŋkepe.” ");
INSERT INTO kmg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mume Jesuzi šiŋuc âzâcnewec: “Á go honemec, dâŋ gazakopac no hâcne ine.” ");
INSERT INTO kmg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Eme ŋiczi muwec, “Wofuŋ, no manasiŋgukopac”, iŋuc murâ kikefuŋnao fodapewec. ");
INSERT INTO kmg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Eme Jesuzi muwec, “No ŋic fuŋne-ŋeŋic bajaŋgeŋkepemurâ mâreŋko wahapo. Eme irec tiŋtuŋzi šâŋe fifi enšepieŋ â šâŋe fifizi tiŋtuŋ enšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Iŋuc mume farisaio ŋic mâmâc domambiŋ jaŋe manarâ mumbiŋ, “Á nâŋe tiŋtuŋ me?” ");
INSERT INTO kmg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mupie Jesuzi jazawec “Ŋoŋe tiŋtuŋ jurâ muzac kiŋ tâmiric enšapiŋ. Ŋaŋac mueŋgopieŋ, `Nâŋe šâŋe fifi', irec kiŋ foŋareocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesuzi dâŋ šiŋuc muwec: “No jâmbomac jâmbâŋ ŋazape mananiŋ, moc e lama jaŋere sapao feocte motâcko mi rašihuc mocko sac huckerâ huocmu, ere fiuc roro â soroŋ qaqa muzo. ");
INSERT INTO kmg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Moc e motâcko raširâ feocmu, ere ine lama soŋaŋ-jeŋic muzo. ");
INSERT INTO kmg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","E fisime motâc soŋaŋzi honerâ motâc rocneocmu â lama jaŋe dâŋ hawari-ticne mananiŋmu. Eme lamafâc-ticne jaŋere šâŋe wirahuc sapaonec jowac-jopa wahaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","E jahacne biŋefâc jowac-jopa-fâreme waharâ, dâŋ hawari-ticne manaeŋgopieŋte bâjâpeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ŋic furune moc e ine mi bâjâpeniŋmu, e dâŋ hawari-ticne kâuc bahuc hâhâwic bacnerâ wiseniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu e dâŋ suŋsuŋne iŋuc mume jaŋe weniŋucte iŋuc mukac muhuc kâuc bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eme Jesu e harierâ jazawec, “Jâmbomac jâmbâŋ ŋazape mananiŋ, lama jaŋerao fefe irec motâc no. ");
INSERT INTO kmg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","No mi fuahape fuambiŋ jaŋe ine fiuc roro â soroŋ qaqa. Irec lama jaŋe dâŋjeŋic mi manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Motâc no hâcne. Moc e fotâcnurâ rašiocmu, e mi sipirickeocmu. E rašic wefuc ehuc nânâ mâriri bâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Fiuc roro e lama qa sipiric erâ fiuc bawiseocte sawa fisiekac. No ine lama jaŋe juhâc qâhâmoniŋte nânâ bâfuape ɋaŋɋaŋ ɋâriaŋ fojareocte fisipo. ");
INSERT INTO kmg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“No soŋaŋ biaŋne. Soŋaŋ biaŋnezi lama jaŋere erâ juju-ticne qikiŋneocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Soŋaŋ jabane, lama ru jeŋic mi juekaczi ine kâte qâto fisime honerâ lama behec-joparâ wiseocmu. Ehame kâte qâtozi lama ki bâtâtiec ejareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","E soŋaŋ jabanere lama jaŋere manabâc mi eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","No ine soŋaŋ biaŋne juekopac, eme Mamac â no hohonec mamanac eekoperec, ");
INSERT INTO kmg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","irec sâcko no â gurufâc-nane hohonec mamanac eeŋgopeneŋ. Irec no lama jaŋere erâ juju-nane qikiŋnepemu. ");
INSERT INTO kmg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","No lamafâc-nane guru moc juŋgopieŋ, jaŋe sapa širecnec mâcne, eme no jaŋe wâc mâmâc amec-jopa warepe dâŋnane mananiŋmu. Eme lamazi guru mocjaha â soŋaŋzi wâc mocjaha iŋuc fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","No juju-nane qikiŋnerâ mocwâc ropemu, irec Mamaczi nore ecneekac. ");
INSERT INTO kmg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Juju-nane moczi mi nowac roocmu, i no nahacne maŋte qikiŋnepemu. No juju-nane qikiŋnepemurâ â ropemurâ irec tâpiri mâmâc fonarekac. Iŋuc epemurâ Mamac-nanezi munarewec.” ");
INSERT INTO kmg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesu e dâŋ iŋuc mume Judaŋic jaŋe manarâ mocwâc mu qaqatarac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ehuc bocjahazi šiŋuc mumbiŋ: “E demoŋzi ecneme maŋne sifuckekac, dâŋ mume wemocte manahuc juŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gâcnezi ine šiŋuc mumbiŋ: “Demoŋheczi dâŋ iŋucne mi muocmu, me demoŋ moczi ŋic tiŋtuŋ jaŋere šâŋe sâcne bâtâcneocmu me?” ");
INSERT INTO kmg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Judaŋic taha ufuŋ jambuŋkembiŋ irec jara hombaŋ i mâmâteŋ dameŋko maickeme ");
INSERT INTO kmg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesu e taha ufuŋ irec maŋne moc šâŋene Salomo ira rac warec ehuc juhame ");
INSERT INTO kmg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judaŋic jaŋe orâŋkerâ šiŋuc muhuc âzâcnembiŋ: “Go wemocte fuŋnege hesoŋketec maŋjahec boc eeŋgopeneŋ? Go Kristo jukomecko mutaniŋkerâ nâzâc me!” ");
INSERT INTO kmg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Eme Jesuzi šiŋuc jazawec: “No ŋazape mi mana šakieeŋgopieŋ. Mamac-nanere micte gie baekopac izi mutaniŋnuekac. ");
INSERT INTO kmg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Á ŋoŋe ine lamafâc-nane mi erâ juŋgopieŋte dâŋnane mi mana šakiee ŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lamafâc-nane erâ juŋgopieŋ jaŋe dâŋnane manaengopieŋ. Eme noni mana tarac-jopahape bâjâpecnueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eme juju sanaŋ bâfua-jarepe sisipiric tâmiric jurašihuc juniŋmu. Jaŋe nore meonec moczi babatarac-jopane mi fokac. ");
INSERT INTO kmg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mamac-nanezi norao ŋec-jopawec e ŋic â wiac sasawa qâhuc-jopa-fârekac. Eme jaŋe moczi Mamac-nanere meonec sâcne mi batarac-jopaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No â Mamac nâhe mocjaha.” ");
INSERT INTO kmg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iŋuc mume Judaŋic jaŋe qânâ ameckerâ hezo embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iŋuc epie Jesuzi šiŋuc jazawec: “Gie biaŋne fuŋne fuŋne Mamacte ŋesiŋko bape honembieŋ, eme ŋoŋe wenimo irec qânâzi hecnuzo eŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eme Judaŋic jaŋe micnao rorâ šiŋuc âzâcnembiŋ: “Gie biaŋne baekic irec mâcne, go ŋic jaha juekiczi Anutu âkehockehuc gahacnere Anutu muekic, irec qânâzi hecguzo muŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iŋuc mupie Jesuzi šiŋuc jazawec: “Sâcmutâc dâŋŋeŋicko šiŋuc mukicne: `Noni mupo, ŋoŋe nemu'. ");
INSERT INTO kmg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eme mitire dâŋqâreŋ i âke sipuhuc moc mumune mi fokac. Erâ Anuture dâŋ fua-jare jujec iŋucne mac jaŋe nemu mujarewec. ");
INSERT INTO kmg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ehame ši ine no Mamaczi mutiricnurâ sorecnume wahapozi `no Anuture ŊokâƷ iŋuc mupe ŋoŋe wemocte muŋgopieŋ, `Go Anutu âkehockekic'? ");
INSERT INTO kmg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Gie baekopac i honepie Mamac-nanere sâc mi eekacko dâŋnane qikiŋnepie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Me honepie Mamac-nanere sâc eekacko ine dâŋnanere mâcne, gie bapa-nanere erâ šâŋitacnunšepieŋ, ehuc Mamaczi no maŋnuekac â noni Mamac maŋkeekopac irec fuŋne mana taranšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iŋuc mume kâpâcwâru bazo ehuc bârucnepie rawec. ");
INSERT INTO kmg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Eme Jesu e Jordaŋ opâ ocniŋucnao Johanezi mârâc fuŋkerâ ŋic opâ rua-jare jujecko ra juwec. ");
INSERT INTO kmg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ira juhame ŋic bocjahazi erao fisirâ dâŋ šiŋuc mumbiŋ: “Johane e mâsi bapa i mi bawec, â ŋic kecširec dâŋ muwec ine fideteŋ efârekac.” ");
INSERT INTO kmg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eme mâreŋ ira bocjahazi Jesu manasiŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania haeo ŋic moc juwec šâŋene Lazaro, e huc bame fowec. Maria â Mata jahe hahac qozi hae irecteaŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria eki hâcne Wofuŋ opâ âsu biaŋ ruacnerâ qizec susuc-ticnezi kikene bâkereŋkewec. Ɋaticne Lazaro hâcne huc fowec. ");
INSERT INTO kmg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eme jahe hahac qozi Jesurao dâŋ kecšiŋuc muhuc râepire rawec: “Wofuŋ go manac, âgoge huc fokac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eme Jesuzi biŋe manarâ šiŋuc muwec: “Huc irec fârine hâmoc fuaocte mâcne, Anuture mumuteŋ fuaocte mukicne. Anutu ŋokâ-ticne ere sambâŋ qâreŋ fua taniŋkeocte hâcne.” ");
INSERT INTO kmg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mata â qoticne â Lazaro jaŋere Jesuzi ecnewec. ");
INSERT INTO kmg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Eme hucte biŋe manarâ juweckoa gie bapa jajahec mocwâc juwec. ");
INSERT INTO kmg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iŋuc jurâ motecfâcne šiŋuc jazawec: “Warepie Judaia mâreŋko risie ranaŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mume motecfâcne jaŋe šiŋuc âzâcnembiŋ: “Qaqazu, Judaŋic jaŋe juc bânic moc ira qânâzi hecguzo mumbiŋ, eme ši wemocte jaŋerao mocwâc risiezo mukic?” ");
INSERT INTO kmg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mupie Jesuzi šiŋuc jazawec: “Gie bapa dameŋ aua 12 fokac i¡ Moc e šoaŋko hata rahame wiac moczi he âkec mi ecneocmu, e tatamacko wiac sâcne honeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Moc e ŋafeo tatamac basahuc hata rahame ine he âkec ecneocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iŋuc murâ dâŋ moc šiŋuc šuhuckewec: “Âgo-nâŋec Lazaro guŋ fokac, eme no rarâ wiwickepemu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eme motec jaŋe šiŋuc mumbiŋ: “Wofuŋ, guŋ fohuc biaŋkeocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesu e hâmocte dâŋ suŋsuŋne mume jaŋe guŋ jâmbâŋte mukac muhuc mi mana-hâmombiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Irec Jesuzi muɋaɋackerâ jazawec, “Lazaro hâmojec. ");
INSERT INTO kmg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","No ira mi ra juhape hâmojecte ŋoŋere erâ bunane biaŋkekac, ŋoŋe mamanasiŋ fârihec eniŋte wiac i fuajec. ši ine erao ranaŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eme Toma, šâŋene moc Didimo, eki motec âgofâcne šiŋuc jazawec: “Nâŋâc mâmâc rarâ ehec hâmonšepeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lazaro šâŋeruŋko fohame šoaŋ gie bapa jahec â jahec ehame Jesu ra fisiwec. ");
INSERT INTO kmg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania hae i Jerusalem hae irec rašimicne bembeŋko ŋewecte ");
INSERT INTO kmg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","irecnec Judaŋic bocjahazi Mata â Maria ɋajekic hâmowecte soŋgâŋ fâsâc honec-jofazo rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eme Mata e Jesu fisikac mupie manarâ Maria ficko ŋehame ra hatao bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bâfuarâ šiŋuc âzâcnewec: “Wofuŋ, go šira jutec muzac ɋanane mi hâmozac. ");
INSERT INTO kmg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Erâ šiŋuczia gore wâc manakopac, wiac irec me irec Anutu numucnetec mana-gareocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Eme Jesuzi šiŋuc âzâcnewec: “Ɋage ɋârerâ fahareocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mume Matazi šiŋuc muwec: “Juku dameŋ sâkoo ɋârerâ fahareocmu i manakopac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eme Jesuzi šiŋuc âzâcnewec: “Ɋâɋâre â juju rune no, irec moc e no manasiŋnuocmuzi hâmo-bipierâ juocmu, ");
INSERT INTO kmg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","â moc e ɋâricne juhuc manasiŋnuocmuzi hâhâmo tâmiric jurašihuc juocmu sanaŋ. Go dâŋ i mana šakiekomec?” ");
INSERT INTO kmg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eme Matazi muwec: “Go Kristo Anuture Ŋokâzi mâreŋko wahaocte mukicne hâcne, i maŋnanezi mana šakiekopac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dâŋ iŋuc murâ qoticne Maria wiracnerâ saŋucko šiŋuc âzâcnewec: “Qaqazu warejec gore mukac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Eme Mariazi manarâ izia faharerâ Jesurao rawec. ");
INSERT INTO kmg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesu e hae upeo Mata dâŋ âzâcneweckoa domawec. ");
INSERT INTO kmg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Eme Maria e biac faharerâ rame Judaŋic soŋgâŋte ficticnao ŋembiŋ jaŋe šâŋeruŋko kioocte rakac muhuc bâjâpembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Eme Maria e hae upeo hurâ Jesu honerâ kikefuŋnao fodaperâ šiŋuc âzâcnewec: “Wofuŋ, go šira jutec muzac ɋanane mi hâmozac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iŋuc murâ kiome Judaŋic bâjâpembiŋ jaŋe e bafickerâ mâmâc kiombiŋ. Kiopie Jesuzi honec-joparâ mana hâtâwehuc gâgâmârâwec. ");
INSERT INTO kmg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iŋuc erâ wio-jarewec, “Wena duckembieŋ?” Eme jaŋe mumbiŋ, “Wofuŋ ware honec.” ");
INSERT INTO kmg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Eme Jesu šâŋene ruruame šâŋeucne wahawec. ");
INSERT INTO kmg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Eme Judaŋic jaŋe honerâ mumbiŋ, “Honeniŋ, maŋne ere mo iŋucne domawec.” ");
INSERT INTO kmg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Á gâcnezi mumbiŋ, “Tiŋtuŋ moc šâŋene bâtâcneweczi ŋic kecši sâcne mi bâpiaŋkeme ɋiɋic qazac me?” ");
INSERT INTO kmg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eme Jesuzi bune mocwâc hâhâtâwehame šâŋeruŋko ra fisiwec. Qâŋɋâŋ e qânâ hawecko fowec, motâcne qânâ kâcɋenezi âke bâzickekicne. ");
INSERT INTO kmg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Irec Jesuzi šiŋuc muwec: “Qânâ bârârieniŋ.” Mume hâmocnere hahac Mata eki muwec: “Wofuŋ, šoaŋ gie bapa jahec â jahec fowecte âsu fikac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mume Jesuzi šiŋuc âzâcnewec: “Dâŋ gazape mi manamec, go manasiŋnutec Anutu tâpiri-ticnere qâreŋ fuame honecmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eme qânâ bârâriepie Jesuzi faic fime fehame šiŋuc numuwec: “Mamac, go nunumu-nane manamecte daŋge gazakopac. ");
INSERT INTO kmg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Go nunumu-nane dameŋ sâc manaekic i manakopac. No mâc ŋic ši doma raŋgopieŋ jaŋe goki sorecnutec wahapo i maŋjeŋiczi mana šakieniŋte dâŋ iŋuc gazakopac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iŋuc murâ hahaŋne bahuc wirawec, “Lazaro go wahac.” ");
INSERT INTO kmg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mume hâmokicnezi wahawec. Me kikene qoruczi qâfisekicne â šâŋe maine qoruczi foŋkekicne, irec Jesuzi šiŋuc jazawec: “Qoruc goroŋkepie raoc.” ");
INSERT INTO kmg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judaŋic Mariarao fisimbiŋ jaŋeraonec bocjahazi Jesu wiac eme honerâ e manasiŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gâcnezi ine farisaio ŋic jaŋerao rarâ Jesuzi wiac ewec irec dâŋ binaŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Eme taha bapa micne â farisaio ŋic jaŋe dâŋ i manarâ micne bapa hefârec-joparâ šiŋuc mumbiŋ: “Ŋic e mâsi bocjaha bakacte wenac enaŋ? ");
INSERT INTO kmg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nâŋâc qâoma ecnehuc juhapene ŋic jaŋe erao qohota-fârepie Romaŋic jaŋe râsi enârerâ mâreŋ â ŋic nâwoc rofâreniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Eme jaŋere âgo moc, šâŋene Kaifa, jara dameŋ ira taha bapa sâko juwec, eki šiŋuc muwec: “Ŋoŋe maŋ mamanasu tâmiric juŋgopieŋ, ");
INSERT INTO kmg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","erâ šiŋuc wâc mi manaŋgopieŋ: Ŋicguru nâŋâc sipiricke-fârenšipeŋte mocjahazi âkehoc-nâpohuc hâmome izi ŋoŋe wâc bafic-ŋopaocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dâŋ i maŋticnere mi muwec, e jara dameŋ ira taha bapa sâko juwecte fiŋdaŋdâŋ muwec. Jesu e jâmbomac ŋic jaŋere erâ hâmoocte mucnekicne, ");
INSERT INTO kmg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","erâ Judaŋic jaŋere sawa mâcne, Anuture naru motecfâc mâreŋ sâc juraŋgopieŋ jaŋe mâmâc bâtumaŋ-jopame suru mocjaha erâ juniŋte iŋuc mucnekicne. ");
INSERT INTO kmg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Eme micne bapa jaŋe šoaŋ gie bapa ira hâcne Jesu qaniŋte dâŋgie fuŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Irec Jesu e Judaŋic jaŋerao mocwâc mi fua tâcnerâ juwec, e mâreŋ burocne irec mecqaŋeŋao hae moc ŋewec, Eferaim, ira motecfâcne rocjopame ra jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Eme Judaŋic aakic hombaŋ-jeŋic bembeŋkehame hae pitickonec ŋic bocjahazi bahac wâwânâŋ gie-jeŋic baniŋte biac bânierâ Jerusalem haeo rambiŋ ");
INSERT INTO kmg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eme taha ufuŋko Jesu basarâ šiŋuc muhuc nazaŋ gazaŋ embiŋ: “Ŋoŋe weniŋuc muŋgopieŋ, e hombaŋte wareocmu me mâcne?” ");
INSERT INTO kmg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Taha bapa micne â farisaio ŋic jaŋe ine mumupaŋ dâŋ šiŋuc mumbiŋ: “Moc e ŋeŋe juju-ticne honerâ ware mufua-nâreme kâpâcwâru banšepeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aakic hombaŋ juwicnao šoaŋ gie bapa 6 fohame Jesuzi Betania haeo ra fisiwec. E hae ira hâcne Lazaro hâmockonec bâɋârewec. ");
INSERT INTO kmg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eme Jesu tiwâ bâzi rikecnepie Matazi râe bâmoc ejareme Lazarohec mâmâc ŋehuc nâmbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ŋehapie Mariazi kiruŋ moc opâ âsu biaŋ furi sâko jâmbâŋ i rorâ Jesu kikene ruacnerâ qizec susuc-ticnezi bâkereŋkewec. Eme fic âsu biaŋ fifârewec. ");
INSERT INTO kmg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Eme motec jaŋere âgo moc Juda Karioto haeonec docbapa ŋic, eki šiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Opâ âsu izi 30 kina kitâcneme ŋic hapetac jarepene sâckezac me!” ");
INSERT INTO kmg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","E dâŋ i hapetac jaŋere manasuhuc mi muwec, e moneŋ kânoŋ wirec-jeŋic bajuhuc moneŋ hume ro soŋsoŋ ejujec, irec muwec. ");
INSERT INTO kmg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eme Jesuzi muwec, “Ŋoŋe ŋokac dâŋ mi mucneniŋ, e opâ âsu i sahac-nane ruacneme hâmope ducnuniŋte irec biŋe hâcne bajuwec. ");
INSERT INTO kmg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ŋic hapetac dameŋ sâc ŋoŋerao juhuc juniŋmu, no ine ŋoŋerao boc mi jupemu.” ");
INSERT INTO kmg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eme Judaŋic bocjaha jaŋe hae ira jume manarâ ijaha fisimbiŋ. Erâ Jesure sawa mâcne, Lazaro hâmockonec bâɋârewec e mâmâc honeniŋte fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eme irec taha bapa micne jaŋe Lazaro mâmâc qaniŋte dâŋgie bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Judaŋic bocjahazi ere erâ rarâ Jesurao qohotambiŋte iŋuc embiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hae fureme ŋic guru sâko hombaŋte biac Jerusalem haeo fisimbiŋ jaŋe dâŋ biŋe šiŋuc manambiŋ: “Jesu warehuc jukac.” ");
INSERT INTO kmg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dâŋ i manarâ šariŋ bazu amec erâ hatao bâfuaniŋte rambiŋ. Erâ bâfuarâ ofac hecnehuc šiŋuc mumbiŋ: “Ohec, Wofuŋte micte ware-nârekac e mumbiaŋkenaŋ, Israe ŋicwofuŋ ohec!” ");
INSERT INTO kmg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu e doŋgi motecne bâfuacnepie fainao ŋehuc rawec. I findaŋdâŋ kecšiŋuc fokac irec sâcko ewec: ");
INSERT INTO kmg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zioŋte otâ, go mi hâwicguoc; manakic, ŋicwofuŋgezi fakac, doŋgi motecnere âsio fakac.” ");
INSERT INTO kmg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dâŋ i motecfâc-ticne jaŋe mârâc mi mana-hâmombiŋ. Juku Jesu sambâŋ tatamac-ticnao risie feme dâŋ irec manasurâ šiŋuc mana tarambiŋ: I ere qâreŋkekicnere sâc ijaha ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesu e Lazaro wiracneme šâŋeruŋkonec wahame honembiŋ ŋic guru sâko i jaŋe gâcne dâŋ binaŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eme mâsi irec biŋe manambiŋte bocjahazi hatao ra bâfuambiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eme farisaio ŋic jaŋe jaŋackoaŋ šiŋuc muhuc muc manac embiŋ: “Manaŋgopieŋ. ŋoŋe dâŋgie bâipiehapie ŋic mâmâc sasawa erao qohota-fâreŋgopieŋ ine!” ");
INSERT INTO kmg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Judaŋic hombaŋte Jerusalem haeo fisimbiŋ jaŋere ŋondeŋko Grikŋic qâpuc moc moc mâmâc juhuc Anutu mai ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eme jaŋe Filipo Besaida haeonec Galilaia mâreŋkonec erao rarâ šiŋuc âzâcnembiŋ: “Ŋicbomboŋ, nâŋe Jesu honezo muŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mupie Filipozi Anderea âzâcneme mâmâc Jesurao rarâ dâŋ i âzâcnepic. ");
INSERT INTO kmg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Âzâcnepire šiŋuc muwec: “Ŋic Fâri Wâtuŋne huriri qâreŋ-ticne fua tâcneocte šâfo maickekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jâmbomac jâmbâŋ ŋazape mananiŋ, jacgoŋ hândâŋ e mâreŋko mi hurâ mâc foku foocmu, mâreŋte nânâ eme ine fârine bocjaha fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Moc e juju-ticne âgo ecneme sifuckecneocmu, moc e mâreŋko juhuc juju-ticne râsi ecneme juju sanaŋte biŋe focneocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Moc e nore kiŋaŋ qaqa ezo murâ bâjâpecnuzejec, eme no jupemuoa kiŋaŋ qaqa-nanezi juocmu. Moc e no kiŋaŋ qanareocmu, e Mamac-nanezi erickeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ʒi maŋnane fâfârerâ ɋarac ɋarac qakac. Ehame weniŋuc mupemu? `Mamac go dameŋ maicnukac i bâsuecƷ iŋuc mupe? Misac, iŋuc aricne, dameŋ i hâcne maicnuocte mukicne. ");
INSERT INTO kmg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Irec Mamac go mutec šâŋe biŋegere huriri qâreŋ fua tâcnezejec.” Mume sambâŋkonec dâŋ šiŋuc wahawec: “I huriri qâreŋ-ticne fuawec erâ huriri qâreŋ jaha fua raocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Eme ŋicguru domambiŋ jaŋe manarâ mumbiŋ, “Ɋuŋ hejec.” Á gâcnezi mumbiŋ, “Aŋelo moczi dâŋ âzâcnejec.” ");
INSERT INTO kmg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mupie Jesuzi micjeŋicko rorâ šiŋuc jazawec: “Dâŋ i nahacnere mâcne ŋoŋere erâ fuajec. ");
INSERT INTO kmg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ʒi mâreŋko ââke râwiŋ dameŋ maickekacte mâreŋ širec ŋicbomboŋ e hetuŋkezo. ");
INSERT INTO kmg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mâreŋkonec bâfeŋnupie mâreŋ sâc ŋic fârec-jopape norao fisiniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","I hâmoc weniŋucne hâmoocmu irec dâŋ suŋsuŋne iŋuc muwec. ");
INSERT INTO kmg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mume ŋicguru domambiŋ jaŋe šiŋuc âzâcnembiŋ: “Nâŋe mitio dâŋ kecšiŋuc manaeŋgopeneŋ: Kristo e mi hâmohuc jurašihuc juocmu. Eme goki wemocte šiŋuc mukic: `Ŋic Fâri Wâtuŋne e bâfeŋneniŋmu'? Ŋic Fâri Wâtuŋne e mo?” ");
INSERT INTO kmg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Eme Jesuzi dâŋ šiŋuc bâtikie-jarewec: “Ʒoctamac e ŋondeŋ-ŋeŋicko dameŋ bembeŋne mac tamaeocmu. Irec dapâczi foŋŋopazacte šoctamac foŋarehame e maickerâ junšepieŋ. Moc e dapâcko rahuc hata mi hone taraocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Irec šoctamac foŋarehame maŋzi sakarehuc kikefuŋfâc-ticne enšepieŋ.” Jesu e dâŋ iŋuc murâ ra soŋsoŋko juwec. ");
INSERT INTO kmg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesu e mâsi fuŋne fuŋne šâŋe fai-jeŋicko bame hone-bipiehuc sifu erao mi roweckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","I porofete Jesajare dâŋ sanaŋkeocte iŋuc embiŋ. E dâŋ šiŋuc qâreŋkewec: “Wofuŋ, biŋedâŋge mupene mozi mana šakieekac? Á Wofuŋte me i morao fua taniŋkeekac?” ");
INSERT INTO kmg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Erâ Jesure dâŋ mi mana šakiembiŋ i Jesajare dâŋqâreŋ moc fokacte embiŋ ine kecšiŋuc: ");
INSERT INTO kmg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“E šâŋe-jeŋic tiŋtuŋ barâ maŋjeŋic bâzickewec, jaŋe šâŋezi wiac hone taranšipiŋte, â maŋzi wiac mana taranšipiŋte, ehuc maŋjeŋic bârisiepie bâpiaŋ-jopazipore.” ");
INSERT INTO kmg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesaja dâŋ muwec, i Jesu sambâŋ tatamac-ticne honerâ muwec. ");
INSERT INTO kmg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Eme micne bapa jaŋeraonec gâcne jaŋe Jesu manasiŋkembiŋ wâc. Erâ mufuapie farisaio jaŋe miti sakare-jarenšipiŋte hâwic-jopame hesoŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jaŋe šâŋe biŋe-jeŋic ŋic jaŋerao waha qaqane ezacte manapie ŋemâckewec, â Anuturao waha qaqane ezacte manapie afeckewec. ");
INSERT INTO kmg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu e hahaŋne bahuc dâŋ šiŋuc muwec: “Moc e no manasiŋnuocmu, e no sawa mâcne, sorecnuwec e mâmâc manasiŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Á moc e no honecnuocmuzi sorecnuwec e mâmâc honeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","No šoc tatamaczi mâreŋko wahapo, eme moc e no manasiŋnuocmuzi dapâckonec wefuocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Moc e dâŋnane manarâ beheme okacne mi râcnepemu, no ŋic okacne jarepemurâ mâcne, bâpiaŋ-jopapemurâ wahapo. ");
INSERT INTO kmg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Moc e no qikiŋnuhuc dâŋnane beheocmu, e mumutara fuacneocmu, dâŋ muekopac izi juku dameŋ sâkoo mumutara ecneocmu. ");
INSERT INTO kmg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","No dâŋ i no nahacne maŋte mi muekopac, Mamac sorecnuwec e jahac dâŋ mufuapemurâ sâcmutâc enarewec. ");
INSERT INTO kmg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Erâ no manakopac, micdâŋ-ticnezi juju sanaŋ bâfuaekac. Dâŋ muekopac i Mamaczi mutâcne-narewec sâc muekopac.” ");
INSERT INTO kmg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aakic hombaŋ maickehame Jesuzi e jahacnere šiŋuc manawec: No mâreŋ beherâ Mamactao risie fepemurâ dameŋ bembeŋkekac. Iŋuc manarâ mâreŋko wiacfâc-ticne maŋjauŋ ejarewec, i ejare tarahuc hâmoocte muwec. ");
INSERT INTO kmg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Eme ŋafere nânâ nâniŋte tumaŋnehapie wiac kecšiŋuc fuawec: Simoŋ ŋokâ-ticne Juda, Karioto haeonec, e Jesu doc baocte Sataŋzi maŋticnao qafeŋ râewec. ");
INSERT INTO kmg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Á Jesu e šiŋuc manawec: Mamac e wiac sasawa furu qârârie-narekac, eme no Anuturaonec wahapozi mocwâc Anuturao risie fepemu. ");
INSERT INTO kmg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Fuŋne iŋuc manahuc nânâ nâhuc ŋembiŋkonec faharerâ ŋaqi šora faine i hetararâ gie qoruc jomawec. ");
INSERT INTO kmg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Erâ opâ râqâcko qame hume fuŋkerâ motecfâcne kike šure-jarewec. Ehuc gie qoruczi bâkereŋke-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ejare raku Simoŋ Petororao fisime šiŋuc âzâcnewec: “Go Wofuŋzi kike-nane šurezo mukic me?” ");
INSERT INTO kmg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mume Jesuzi šiŋuc âzâcnewec: “Wiac ekopac irec fuŋne šiŋuczia mi manakomec, juku šâhecko manacmu.” ");
INSERT INTO kmg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Eme Petorozi šiŋuc muwec: “Aricne, go kike-nane mi šure-jâmbâŋkecmu.” Mume Jesuzi šiŋuc âzâcnewec: “Noni mi šurecgupe nohec maŋ šušuhuc mi jucmu.” ");
INSERT INTO kmg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eme Petorozi šiŋuc muwec: “Wofuŋ, murâ kike-nane sawa mâcne, me qizec-nane mâmâc šurec.” ");
INSERT INTO kmg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mume Jesuzi šiŋuc âzâcnewec: “Moc e opâ ruarâ šâhec kike-ticne sawa šureme sahacne ɋaɋacne fofâreocmu, eme ŋoŋe iŋuc jaha ɋaɋackembiŋ, erâ ɋaɋacnea mi jufâreŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","E doc bapa-ticne mana tarahuc šiŋuc jazawec: “Ŋoŋe ɋaɋacnea mi jufâreŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kike-jeŋic šure-fârerâ ŋaqi šora-ticne mocwâc heme hume waha ŋehuc šiŋuc jazawec: “No wiac eŋarepac irec fuŋne manaŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ŋoŋe Qaqazu â Wofuŋ munareeŋgopieŋ, erâ iŋeŋic jukopacte sâcne munareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eme no Wofuŋ â Qaqazu-ŋeŋiczi kike-ŋeŋic šure-ŋarepacte ŋaŋaczia iŋuc jaha kike šušurec erahuc jupie sâckezejec. ");
INSERT INTO kmg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mâsi eŋarepac izi juju bapare ma qâreŋ-ŋeŋic eme i honehuc, eŋarepac irec sâc ehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","No jâmbomac jâmbâŋ mupe mananiŋ: Kiŋaŋ moteczi bomboŋ-ticnere sâc sirickerâ jujune i mi fokac, â sorekicnezi sorewec ere sâc sirickerâ jujune i wâc mi fokac. ");
INSERT INTO kmg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Eme dâŋ i manapaŋkerâ irec sâcko jupie no ŋoŋere manape šerine eocmu. ");
INSERT INTO kmg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","No dâŋ mupe mâmâc sasawa mi rocŋopakac. No wenimoi rowosâec-ŋopapo i manakopac. Dâŋqâreŋ moc kecšiŋuc fokac, i sanaŋkeocmu hâcne: Nânâ bâfâuc ecneekopac eki wâc bunaneo bakac. ");
INSERT INTO kmg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Wiac i mi fuahame qanaŋ ŋazakopac, eme šâhec fuame, e Wofuŋzi qanaŋ manahuc muwec, nore iŋuc munšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","No jâmbomac jâmbâŋ ŋazape, moc e gie muŋarekicne ŋoŋe hezu hewâneŋ eŋareocmuzi gie rune no hezu hewâneŋ enareocmu, â moc e no enareocmuzi sorecnuwec e hezu hewâneŋ ecneocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu e dâŋ iŋuc murâ bu šašamaŋne fâuckezo eme mutaniŋkerâ šiŋuc jazawec: “No jâmbomac jâmbâŋ mupe mananiŋ, ŋoŋeraonec moczi no doc bacnuocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iŋuc mume motec jaŋe hohonec efârerâ, i more mukac, muhuc kâuc bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Eme motec moc Jesure maŋfuŋko ŋewec, e bufuŋ jâmbâŋ-ticne, ");
INSERT INTO kmg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","e hâcne Simoŋ Petorozi mezi sâsâc ecnerâ muwec, “Wiocnetec gazaoc, more mukac?” ");
INSERT INTO kmg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eme motec eki hâcne qizec-ticne Jesure amecko fohorerâ muwec, “Wofuŋ go more mukic?” ");
INSERT INTO kmg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Eme Jesuzi muwec, “Poroŋ sicko âke uruckerâ râcnepe nâocmu ere hâcne mukopac.” Iŋuc murâ poroŋ sicko âke uruckerâ Simoŋ ŋokâ-ticne Juda, Karioto haeonec, e râcneme nâwec. ");
INSERT INTO kmg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nâme Sataŋzi maŋne sakioŋkewec. Eme Jesuzi šiŋuc âzâcnewec: “Wiac ezo mukomec, i biac jaha ezemec.” ");
INSERT INTO kmg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dâŋ iŋuc âzâcneme gâcne mâmâc ŋembiŋzi mi mana-hâmombiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ehuc tucnezi šiŋuc mumbiŋ: “Juda e moneŋ kânoŋ wirec-nâŋec bajukacte hombaŋte wiac moc furine baocte sorekac, me ŋic hapetac moneŋ jareocte mukac.” ");
INSERT INTO kmg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Eme Juda e poroŋ nârâ izia ŋafe fuaha rawec. ");
INSERT INTO kmg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Juda rame Jesuzi motec gâcne šiŋuc jazawec: “Ʒi Ŋic Fâri Wâtuŋne e huriri qâreŋ-ticne fuakac, eme ere erâ Anuture huriri qâreŋ mâmâc fuakac. ");
INSERT INTO kmg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ŋic Fâri Wâtuŋnezi Anuture huriri qâreŋ bâfuawecte Anutu e jahac Ŋic Fâri Wâtuŋne ere huriri qâreŋ iŋuc jaha bâfuaocmu, dameŋ mi šorahame biac bâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Motecfâc-nane, no dameŋ bembeŋne mac moc ŋoŋehec jupemu. Eme šâhec basacnuniŋmu. Eme Judaŋic jazapo ijaha ŋoŋe ŋazape: No rapemu ijaha sâcne mi fâniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Eme ši sâcmutâc dâŋ ɋâricne ŋazape: Maŋjauŋ eec enšepieŋ, noni maŋjauŋ eŋare warehuc jupo iŋuc jaha ŋaŋackoaŋ maŋjauŋ eec enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Maŋjauŋ eec epie ŋic jaŋe honec-ŋopapie motecfâc-nane juŋgopieŋ ezejec.” ");
INSERT INTO kmg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Eme Simoŋ Petorozi wiocnerâ muwec, “Wofuŋ, go wena racmu?” Eme Jesuzi muwec, “No rapemu ijaha šiŋuczia sâcne mi fâcmu, juku šâhec ine fâzemec.” ");
INSERT INTO kmg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eme Petorozi šiŋuc muwec: “Wofuŋ, no wemocte šiŋuczia sâcne mi fâpemu? No gore erâ juju-nane sâcne qikiŋnepemu.” ");
INSERT INTO kmg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mume Jesuzi šiŋuc âzâcnewec: “Go nore erâ jujuge qikiŋnezo mukomec me? No jâmbomac jâmbâŋ gazape: Qâqâczi mi dâŋehame goki jahec â moc mic bacnucmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ŋoŋe fâfârerâ maŋŋeŋic mi gâckezejec. Anutu manasiŋkehuc no mâmâc manasiŋnunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mamac-nanere hae qizecko fic bocjaha ŋerakac. Iŋuc mi fome muzac, ŋeŋe hewâneŋke-ŋarezo rapemu, i moc ŋazazapo me? ");
INSERT INTO kmg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Eme ra ŋeŋe hewâneŋke-ŋarerâ mocwâc risie warerâ jowac-ŋopape rarâ no jupemuoa junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Rapemu hata i honeeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mume Tomazi šiŋuc âzâcnewec: “Go wena racmu, i nâŋe mi manaŋgopeneŋ, irec wemocko hata honenaŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Eme Jesuzi šiŋuc âzâcnewec: “Hata â dâŋ fâri qizec â juju irec rune no. No nowarurâ Mamactao fifisi i mi fokac. ");
INSERT INTO kmg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ŋoŋe juwicnao no šâŋitacnurâ muzac Mamac-nane iŋuc jaha šâŋitanšapiŋ. Ʒi ine Mamac-nane šâŋitarâ mana taraŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iŋuc mume Filipozi šiŋuc muwec: “Go Mamac nâwotutec honerâ manapene taraocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eme Jesuzi muwec: “Filipo, no dameŋ šora ŋoŋehec juhape go mi hone tarac-nukomec? Moc e no honecnuekaczi Mamac honeekac. Eme go wemocte šiŋuc mukomec: `Go Mamac nâwotutec honenaŋ'? ");
INSERT INTO kmg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mamaczi no maŋnuekac â noni Mamac maŋkeekopac i mi mana šakiekic me? Dâŋ ŋazaekopac i nahacne maŋte mi ŋazaekopac, Mamaczi nore maŋko juhuc gie-ticne baekac. ");
INSERT INTO kmg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mamaczi no maŋnuekac â noni Mamac maŋkeekopac, dâŋ i manapie fârine ezejec. Me miczi mupe mi sâcŋopakacko wiac bapa-nanere erâ dâŋ i mana šakieniŋ. ");
INSERT INTO kmg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“No jâmbomac jâmbâŋ mupe mananiŋ: No manasiŋnuocmuzi gie baekopac ijaha baocmu. Erâ i sawa mâcne, sâcnane jâuruhuc baocmu. No Mamactao fepemure iŋuc hâcne fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eme ŋoŋe nore šâŋe bajuhuc numupie sâc mana-ŋarehuc epemu. I Mamacte mumuteŋ Ŋokâre erâ fuaocte iŋuc epemu. ");
INSERT INTO kmg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ʒâŋe-nane bajuhuc numu-narepie mana-ŋarehuc epemu. ");
INSERT INTO kmg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Maŋŋeŋic nore qikiŋneeŋgopieŋko micnane reŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eme noni Mamac numucnepe neŋgoc ŋesiŋ-ŋeŋic moc soreme waharâ ŋoŋehec juhuc juocmu sanaŋ. ");
INSERT INTO kmg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dâŋ fâri qizecnere Mâro hâcne. I miti tâmiriczi rorone mi fokac. Jaŋe e mi hone taraeŋgopieŋ â e mi mana taraeŋgopieŋ. E ŋoŋehec juekaczi maŋŋeŋicko hurâ juocmu, irec ŋoŋe e kâuc mi baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","No behec-ŋopape bekâ mâsiŋ erâ mi juniŋmu. No ŋoŋerao risie warepemu. ");
INSERT INTO kmg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dameŋ bembeŋne mac moc fokac, i tarame miti tâmiriczi mocwâc mi honecnuniŋmu. Ŋoŋe ine honecnuniŋmu. No juju sanaŋ jukopac, irec ŋoŋe iŋuc jaha ɋâricne juraniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dameŋ ira, Mamaczi no maŋnuekac â noni ŋoŋe maŋŋopaekopac, â ŋoŋe no maŋnueŋgopieŋ i mana taraniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Moc e micdâŋ-nane bajuhuc sâseocmu, eki maŋjauŋ enareocmu. Eme moc e no maŋjauŋ enareme Mamac-nanezi e iŋuc jaha maŋjauŋ ecneocmu, â no nahac wâc maŋjauŋ ecnehuc fuŋne-nane mutaniŋkecnepemu.” ");
INSERT INTO kmg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iŋuc mume Juda Karioto haeonec ere wasezi wiocnerâ muwec: “Wofuŋ, go weniŋuc erâ fuŋnege nâŋerao sawa bataniŋkehuc ŋic gâcne sâko jaŋe hesoŋke-jarezo mukic?” ");
INSERT INTO kmg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mume Jesuzi dâŋ šiŋuc bâtikiecnewec: “Moc e maŋjauŋ enareocmuzi dâŋnane mana rereŋ eocmu. Eme Mamac-nanezi e iŋuc jaha maŋjauŋ ecneocmu. Eme nâhe mâmâc erao fisirâ ŋeŋe juju enacmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Moc e maŋjauŋ mi enareocmuzi dâŋnane wemocko mana rereŋ eocmu. Erâ dâŋ ŋazaekopac i no nahacnaonec mâcne, i Mamac sorecnuwec eraonec. ");
INSERT INTO kmg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“No nahac ŋoŋehec juhuc dâŋ iŋucne ŋaza qazuc eekopac. ");
INSERT INTO kmg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Eme neŋgoc ŋesiŋ Tiri Mâro hâcne e Mamaczi nore micte soreme waharâ dâŋ sasawa ŋaza qazuc eŋareocmu, â noni ŋazaekopac i heɋâre-ŋare-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","No merâfâc-nane wama ŋarekopac, ŋic wama mâcne, no nahacne wama jâmbâŋ ŋarekopac. Irec maŋŋeŋic mi fâfârerâ gâckezejec. ");
INSERT INTO kmg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","No kecšiŋuc ŋazape manambieŋ: `No rarâ juku ŋoŋerao mocwâc risiepemu. Ž Ŋoŋe maŋŋeŋic nore qikiŋnerâ muzac, ine Mamactao fepemu i manarâ bubiaŋ bâfuanšapiŋ. Mamac e nore femicne jukacte manasuhuc iŋuc enšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ʒi fârine mi fuaha qanaŋ ŋazakopac, irec fuame honerâ mamanasiŋ-ŋeŋic sanaŋkezejec. ");
INSERT INTO kmg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","No ši dâŋ bocjaha mi šuhuckerâ ŋazapemu. Mâreŋ širec ŋicbomboŋ wareocte šawiekac, warerâ norao hetakireocmu. ");
INSERT INTO kmg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Eme Mamac maŋjauŋ ecnehuc gie munarewec baekopac i miti tâmiriczi hone taraniŋte faharepie ranaŋ. ");
INSERT INTO kmg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“No waiŋjâc fuŋqizecne jâmbâŋ, â Mamac-nanezi waiŋ gie rune. ");
INSERT INTO kmg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tieŋne moc norao foipiehuc fârinehec mi eme qâtâcne behec eocmu, â tieŋne moc fârinehec fome gie bacneme soka biaŋ eocte soŋaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ŋoŋe ine miti ŋazape manahuc biac ɋaɋackembiŋ juŋgopieŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eme ŋoŋe no maŋnupie noni ŋoŋe iŋuc jaha maŋŋopapemu. Waiŋ tieŋnezi jâcnehec šušuhuc mi fohuc e jahackoaŋ sawa fârinehec mi eocmu. Eme ŋoŋe iŋuc jaha no mi maŋnuhuc wemocko fârinehec eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Waiŋjâc fuŋqizecne no, tieŋ taeŋne ŋoŋe. Moc e no maŋnuhame noni e maŋkepemu, eme iŋucnezi fârine sâkohec eocmu. Ŋoŋe no tâmiric juhuc wiac eene i mi fokac. ");
INSERT INTO kmg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Moc e no mi maŋnume e behezo, eme waiŋ tieŋne behepie ɋaŋame qâzuckerâ behepie šocko šaekac, sâc ijaha ecnezo. ");
INSERT INTO kmg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ŋoŋe no maŋnuhuc dâŋnane maŋkeniŋmu, eme wiac irec me irec numupie fua-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ŋoŋe fârine sâkohec ehuc motec jâmbâŋfâc-nane erâ jupie Mamac-nanere mumuteŋ fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Mamaczi no maŋjauŋ enareekac, iŋuc jaha noni ŋoŋe maŋjauŋ eŋareekopac. Eme ŋoŋe nore maŋjauŋkoa junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Micdâŋ-nane reŋkehuc ine nore maŋjauŋko juniŋmu, no iŋuc jaha Mamac-nanere micdâŋ reŋkehuc ere maŋjauŋko juekopac. ");
INSERT INTO kmg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nore bubiaŋzi ŋoŋerao fotâcneme ŋoŋerezi fufusuc foocte dâŋ ši ŋaza-fârekopac. Erâ ŋoŋerao fohuc fua sawec ezejec. ");
INSERT INTO kmg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Micdâŋ-nane kecšiŋuc ŋazakopac: Noni maŋjauŋ eŋareekopac, iŋuc jaha ŋaŋaczia maŋjauŋ eec enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Moc e âgofâcne jaŋere riŋ rohuc juju-ticne qaisockeocmu, irec maŋjauŋ fekicne sâko muzo. ");
INSERT INTO kmg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Gie muŋareekopac i bapie honec-ŋopape âgofâc-nane eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","No dameŋ ši kiŋaŋ qaqa mocwâc mi muŋarekopac, mana-ŋarepe âgofâc-nane eŋgopieŋ. Kiŋaŋ qaqazi bomboŋ-ticnere maŋko dâŋ foekac i mi manaekac. Noni ine Mamac-naneraonec dâŋ manapo sâc mufuarâ ŋaza-fârepore honec-ŋopape âgofâc-nane eŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ŋoŋe no mi rowosâecnumbiŋ, noni ŋoŋe rowosâec-ŋopapo, erâ ra juhuc fârine bâfuaniŋte muŋarepo. Eme fârine bâfuapie fofonehec ezejec. Iŋuc erâ nore šâŋe bajuhuc Mamac numucnepie sâc ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Maŋjauŋ eec enšepieŋ, micdâŋ ine hâcne ŋazakopac. ");
INSERT INTO kmg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Miti tâmiriczi qaisoc-ŋopapie šiŋuc munšepieŋ: `Wofuŋ e mârâcko iŋuc hâcne fuŋkerâ qaisockembiŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Miti tâmiric jaŋere guruo rašipie muzac âgo eŋarenšapiŋ. No ine jaŋere guruonec rowosâec-ŋopape eebapa-jeŋic râpeckembiŋte qaisoc-ŋopaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","No dâŋ moc kecšiŋuc ŋazapo irec manasunšepieŋ: Kiŋaŋ qaqazi bomboŋ-ticnere sâc sirickerâ jujune mi fokac. Jaŋe no râsi enarembiŋko ŋoŋe râsi jaha eŋareniŋmu, jaŋe nore dâŋ mana maŋ embiŋko ŋoŋere dâŋ iŋuc jaha mana maŋ eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sorecnuwec e mi šâŋitaeŋgopieŋte nore erâ iŋuc hâcne eŋareniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No jaŋerao mi waharâ fuŋne mi jazape muzac kiŋ tâmiric junšapiŋ. ši ine kiŋjeŋic wemocko murârâŋneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Moc e no qaisocnuekaczi Mamac-nane iŋuc jaha qaisockeekac. ");
INSERT INTO kmg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","No ŋondeŋ-ŋeŋicko mâsi sâko, ŋiczi mi bapane, i mi bazapo muzac kiŋ tâmiric junšapiŋ. ši ine bape hone-fâre-bipiehuc no qaisocnuhuc Mamac-nane iŋuc jaha qaisockeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Iŋuc epie mitio dâŋ moc kecšiŋuc fokac, i sanaŋkekac hâcne: `Jaŋe oma jâmbâŋ qaisocnumbiŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Neŋgoc ŋesiŋ, dâŋ fâri qizecnere Mâro hâcne, Mamactao jukac, e sorepe Mamactaonec waharâ fuŋne-nane mutaniŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Erâ ŋoŋe gie fuŋkepoonec nohec juwarembiŋte iŋuc jaha fuŋne-nane mutaniŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Juku wiac eŋarepie manapie ririsi ezacte dâŋ i qanaŋ ŋazakopac. ");
INSERT INTO kmg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jaŋe mitific sakare-ŋareniŋmu. Erâ wâc dameŋ moc maickeocmu, ira Anuture gie baŋgopeneŋ muhuc qâhâmoc-ŋopaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jaŋe Mamac mecne no mecne mi šâŋitac-nâfoeŋgopieŋte iŋuc eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","No dâŋ qanaŋ ŋazakopac, i sanaŋkeme munšepieŋ: Eki mârâc jaha nâzâwec hâcne. Dâŋ i dameŋ-nane šoricne fohame mârâc biac mi ŋazapo. ");
INSERT INTO kmg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ʒi ine sorecnuwec erao fezo ehape ŋoŋeraonec moczi moc šiŋuc mi wio-narekac: `Go wena racmu? Ž ");
INSERT INTO kmg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dâŋ iŋucne ŋazakopacte mâc busâqoczi maŋŋeŋic fusucmakac. ");
INSERT INTO kmg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","No dâŋ jâmbomac mupe mananiŋ: Risie fepemu i ŋoŋerao fârine fuaocte fepemu. Mi fezapo muzac, neŋgoc ŋesiŋzi mi wahazac. Ferâ ine sorepe wahaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Waharâ ŋic fuŋne bataniŋke-jareme šiŋuc mananiŋmu: Kiŋ fokac â tiŋke biaŋ fokac â okacne dâŋ mumutara fokac. ");
INSERT INTO kmg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kiŋte fuŋne šiŋucko mananiŋmu: Jaŋe no mi manasiŋnueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tiŋke biaŋte fuŋne šiŋucko mananiŋmu: No Mamactao risie fepe mocwâc mi honecnuniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Okacne dâŋ mumutara irec fuŋne šiŋucko mananiŋmu: Mâreŋ širec ŋicbomboŋ okacne dâŋ biac mutaracnekicne. ");
INSERT INTO kmg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Dâŋ ŋaŋazane bocjaha fokac, erâ dameŋ šiŋuczia ŋazape wemocko amecke-fâreniŋmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dâŋ fâri qizecnere Mâro eki ine waharâ dâŋ fâri qizecnere šâkâŋko bâutuc-ŋopaocmu. E jahacne maŋte dâŋ mi ŋazaocmu, mutâcnecnekicne sâc ŋazaocmu, erâ juku wiac fuaocmu i wâc mufua-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dâŋ i no nahacne rowaŋkonec rorâ mujaŋgeŋke-ŋareme nore huriri qâreŋ fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mamactao wiac fokac Irec rune no. Irec hâcne mupac, `Nore rowaŋkonec rorâ mujaŋgeŋke-ŋareocmu.' ");
INSERT INTO kmg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Dameŋ bembeŋne fokac, i tarame rape basacnuniŋmu. Erâ irec faicnao dameŋ bembeŋne jaha wâc fokac, i tarame warepe honecnuniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iŋuc mume motec jaŋe nazaŋ gazaŋ erâ šiŋuc mumbiŋ: “Weniŋucte dâŋ kecšiŋuc mukac? `Dameŋ bembeŋne fokac, i tarame rape basacnuniŋmu, erâ irec faicnao dameŋ bembeŋne jaha wâc fokac, i tarame warepe honecnuniŋmu. Ž Á moc šiŋuc mukac: `Mamactao fepemu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Iŋuc murâ harierâ mumbiŋ: `à `Dameŋ bembeŋne fokac,Ʒ iŋuc wemocte mukac, nâŋe kâuc baŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Wiocnezo epie Jesuzi hone tarac-joparâ šiŋuc jazawec: “Dâŋ kecšiŋuc ŋazapacte muc manac eŋgopieŋ, `Dameŋ bembeŋne fokac, i tarame rape basacnuniŋmu, erâ irec faicnao dameŋ bembeŋne fokac, i tarame warepe honecnuniŋmu. Ž ");
INSERT INTO kmg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","No jâmbomac jâmbâŋ ŋazape: Ŋoŋe ki mamakuc ehapie miti tâmiriczi šeri eniŋmu. Ŋoŋe busâqocko juniŋmu, ehame busâqoc-ŋeŋiczi ŋerisieme bubiaŋ fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ŋokac moc e motec roocte dameŋne maickeme šâic manaocmu. Izi motec rome šâic omaeme, ɋâric fuajec irec bubiaŋ manaocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eme ŋoŋe iŋuc jaha dameŋ šiŋuczia bušâichec juniŋmu. Juhapie mocwâc risierâ honec-ŋopape bubiaŋ bâfuaniŋmu. Eme bubiaŋ i moczi mi qâsua-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Eme dameŋ ira wiac mocte mi kâuc barâ wio-nareniŋmu. No jâmbomac jâmbâŋ ŋazape: Ŋoŋe Mamac wiac mocte numucnepie šâŋe-nanere erâ ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Juwarembiŋ ira nore šâŋe bajuhuc mi numu jumbieŋ. ši ine numurâ ropie bubiaŋ-ŋeŋiczi fua sawec erâ fufuse fozejec. ");
INSERT INTO kmg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Dâŋ ŋaza warehuc jupo i suŋsuŋne qahuc ŋazapo. Juku dameŋ moc maickeocmu ira ine dâŋ suŋsuŋne mi muhuc, Mamacte fuŋne mâc mutaniŋkerâ ŋazapemu. ");
INSERT INTO kmg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dameŋ ira šâŋe-nane bajuhuc numupie noni ŋoŋe bâsâoc-ŋopahuc Mamac ââzâcne i mi epemu. ");
INSERT INTO kmg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","No Mamactaonec wahapo, dâŋ i mana šakiehuc maŋjauŋ enareeŋgopieŋte Mamac e jahac wâc iŋuc jaha maŋjauŋ eŋareekac. ");
INSERT INTO kmg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","No Mamac beherâ mâreŋko wahapo, eme ši mâreŋ beherâ Mamactao mocwâc fekopac.” ");
INSERT INTO kmg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iŋuc mume motec jaŋe šiŋuc âzâcnembiŋ: “Ʒi dâŋ suŋsuŋne mi muhuc mâc mutaniŋkerâ nâzâkomec hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Irec gore šiŋuc manaŋgopeneŋ: Ŋic jaŋe mu wioc mi egarehapie go gahaczia wiac sasawa mana-fâreekic, go Anuturaonec wahameŋ i mana šakieeŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mupie Jesuzi šiŋuc jazawec: “Ŋoŋe miŋecne mana šakieŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dameŋ moc fokac, i biac maickeme no behecnurâ siŋsaŋ qarâ ficŋeŋic sâc rafâreniŋmu. Erâ behecnupie buc mi jupemu, Mamaczi nohec jukacte buc jâmbâŋ mi jupemu. ");
INSERT INTO kmg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nore wamazi ŋoŋerao foocte dâŋ iŋucne ŋazakopac. Ŋoŋe mâreŋko šârâ hâriŋ faio jueŋgopieŋ, eme noni mâreŋte micne momori fozukopacte ŋoŋe hâbi-ŋeŋichec junšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu e dâŋ i mutararâ sambâŋko fime feha šiŋuc muhuc numuwec: “Mamac, dameŋ maickekac. Go Ŋokâgere huriri qâreŋ bâfuatec Ŋokâzi iŋuc jaha gore huriri qâreŋ bâfuazejec. ");
INSERT INTO kmg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Go e mâreŋ sâc ŋic jaŋere rusâko râemeŋ, ehuc ŋic erao ŋec-jopameŋ sâc jaŋe juju sanaŋ bâfua-jareocte mucnemeŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Juju sanaŋte fuŋne ine šiŋuc fokac: Go Anutu fârine mocjaha â soremeŋ, Jesu Kristo hâcne, ŋic jaŋe iŋuc mana tarac-nâfopie juju sanaŋ fua-jareocmu. ");
INSERT INTO kmg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gie munaremeŋ i baku batarape mâreŋko huriri qâreŋge fuakac. ");
INSERT INTO kmg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Mamac, mâreŋ mi fuahame gohec sambâŋ tatamac-nanehec jupo, ijaha ši mocwâc bârisie-naretec rojuzepac. ");
INSERT INTO kmg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Guru sâkoonec ŋic nore bâwosâec-jopameŋ jaŋe biŋedâŋge mujaŋgeŋke-jarepo. I gore biŋe juhapie nore qikiŋ-jopameŋ, eme jaŋe gore dâŋ ropie maŋjeŋic ewec. ");
INSERT INTO kmg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wiac fonarekac i goraonec sasawa, jaŋe i mana taraŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Go dâŋ naremeŋ i jarepe ro sakarec embiŋ. Ehuc goraonec wahapo i manapaŋkembiŋ, â go gahac gie munaremeŋ i mana šakiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“No jaŋere erâ numu-garekopac. Miti tâmiric jaŋere erâ mi numu-garekopac, naremeŋ jaŋere sawa erâ numu-garekopac, jaŋe gore biŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nore biŋezi gore biŋe â gore biŋezi nore biŋe. Eme maŋjeŋicko huriri qâreŋ-nane fuawec fokac. ");
INSERT INTO kmg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","No mâreŋko juju-nane tarakac, jaŋe ine mâreŋko šuhuckerâ juhapie no gorao fâzo ekopac. Tiri Mamac, biŋedâŋge naretec jazapo, eme go hemiriŋ-jopatec dâŋ irec maŋnao junšepieŋ. Eme nâhâc maŋ mocjaha juekoperec, iŋuc jaha jaŋe maŋ mocjaha junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jaŋehec jupo sâc biŋedâŋge naremeŋ izi hemiriŋ-jopape irec maŋnao jumbiŋ. Ehuc soŋaŋ-jopape moc mi sifuckembiŋ. Dâŋqâreŋ sanaŋkeocte hârâcte biŋe mocjahazi sipirickewec. ");
INSERT INTO kmg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ʒi gorao fâzo ehuc šira mâreŋko dâŋ iŋuc gazape nore bubiaŋzi jaŋerao fotâcnerâ ɋârâŋkeme bajunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","No dâŋge jarepe bajupie mâreŋte biŋe jaŋe qaisoc-jopaeŋgopieŋ. No nahac mâreŋte biŋe mi juekopac, iŋuc jaha jaŋe mâreŋte biŋe mi jueŋgopieŋte iŋuc hâcne ejareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Go mâreŋkonec rocjopacmurâ mâcne, sâqocnere ŋezic-jopacmurâ gazakopac. ");
INSERT INTO kmg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","No gâtâ-nane mâreŋko mi bawec, iŋuc jaha jaŋe gâtâ-jeŋic mâreŋko mi bawec. ");
INSERT INTO kmg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gore dâŋ fâri qizecnezi maŋjeŋic furu batec fozejec. Gore mitizi dâŋ fâri qizecne hâcne. ");
INSERT INTO kmg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Goki no mâreŋko gie munaremeŋ, iŋuc jaha noni jaŋe mâreŋko gie mujarepo. ");
INSERT INTO kmg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jaŋe dâŋ fâri qizecnezi maŋjeŋic furu bame juniŋte no nahac wâc jaŋere erâ maŋsahac-nane bâtirirâ râekopac. ");
INSERT INTO kmg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Erâ no jaŋere sawa mi numu-garekopac, miti jazapie manasiŋnuniŋmu jaŋere mâmâc numu-garekopac. ");
INSERT INTO kmg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Jaŋe maŋwirec erâ juniŋte gazakopac. Mamac, go no maŋnuekic â noni go maŋguekopac, iŋuc jaha jaŋe nâhâc maŋnâfonšepieŋ. Iŋuc epie miti tâmiric jaŋe gahac sorecnutec wahapo i manapaŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nâhâc maŋ mocjaha juekoperec, iŋuc jaha jaŋe maŋ mocjaha erâ junšepieŋ. Iŋuc juniŋte hâcne huriri qâreŋ naremeŋ ijaha jarepo. ");
INSERT INTO kmg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","No maŋjopahape go maŋnutec jaŋe maŋzi šâšâfic ehuc hâcbuc erâ junšepieŋ. Iŋuc jupie miti tâmiriczi goki sorecnutec wahapo i mana šakienšepieŋ, â no maŋzi šâficnuhuc jaŋe mâmâc šâfic-jopaekic, i wâc manapaŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mamac, naremeŋ ŋic i jaŋe no jupemuoa juniŋte mukopac. Eme mâreŋ hobeteŋne mi fuahame maŋjauŋ enarehuc sambâŋ tatamac tahacnumeŋ, i hâcne nohec juhuc hone aŋac enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mamac, tiŋne rune, ŋic jaŋe mi mana taracgumbiŋ, noni ine mana taracguekopac, erâ kikefuŋfâc-nane jaŋe gahac sorecnutec wahapo i manapaŋkeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","No biŋedâŋge mutaniŋke-jarepo erâ mutaniŋke-jarehuc jupemu. Eme maŋjauŋ no enaremeŋ ijaha jaŋerao fome maŋjopahuc jupemu.” ");
INSERT INTO kmg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu e nunumu dâŋ i muku mufârerâ motecfâcne rocjopame haeonec hurâ Kidoroŋ opâ herâ, mâreŋ mocko jufu gie fowec, ira rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesu â motecfâcne ira gâbâ tumaŋne jumbieŋte Juda docbapa ŋic e jufu i honewec wâc. ");
INSERT INTO kmg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eme ira hâcne juhapie Judazi kiaraonec momori erâ taha bapa micne â farisaio ŋic jaŋeraonec motec rocjopame waha lambe â šika barâ rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Eme Jesu e wiac ecneniŋmu i mana-fârehuc jufu tofanao ra bâfuac-joparâ wio-jarewec: “Ŋoŋe mo basaŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eme jaŋe mumbiŋ, “Jesu Nazarete rune.” Mupie muwec, “No hâcne ši.” Ehame Juda docbapa ŋic e ŋondeŋ-jeŋicko domawec. ");
INSERT INTO kmg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eme “no hâcne ši” Jesuzi iŋuc jazame jaŋe rârâpe rahuc rândiŋke qambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iŋuc epie hâsine wio-jarerâ muwec: “ŋoŋe mo basaŋgopieŋ?” Eme mumbiŋ, “Jesu Nazarete rune.” ");
INSERT INTO kmg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mupie Jesuzi šiŋuc jazawec: “No ŋazapac i, no hâcne ši. No basacnuŋgopieŋko keci jaŋe behec-jopaniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iŋuc eme dâŋ kecšiŋuc muwec i sanaŋkewec: “Naremeŋ jaŋe soŋaŋ-jopape moc mi sifuckembiŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Eme Simoŋ Petoro e sâqe bajuwec i becsahackonec unuckerâ taha bapa sâko kiŋaŋ motec-ticne hazecne fâreopec i qatarawec. Motec šâŋene Maiko. ");
INSERT INTO kmg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iŋuc eme Jesuzi Petoro šiŋuc âzâcnewec: “Sâqege becsahacko râec huoc. Me šâic guru Mamac-nanezi râe-narekac, i qikiŋnepemurâ mukic?” ");
INSERT INTO kmg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eme soŋaŋ-jeŋiczi mume momori â Judaŋic motecfâc-jeŋic jaŋe Jesu rorâ mene qarâ ");
INSERT INTO kmg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hanasire ficko barambiŋ. Eme dameŋ ira Judaŋic taha bapa sâko-jeŋic juwec, šâŋene Kaifa, eki Hanasire otâ bawec. ");
INSERT INTO kmg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifa eki hâcne Judaŋic šiŋuc jazawec: “Ŋicguru nâŋâc sipiricke-fârenšipeŋte mocjahazi âkehoc-nâporâ hâmome tarazejec.” ");
INSERT INTO kmg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoŋ Petoro â motec âgo-ticne moc jahe Jesu barahapie šâhec rapic. Eme âgo-ticne e ine taha bapa sâkozi hone jujecte Jesu bâjâperâ ficmaŋko mâmâc rašimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petoro eki ine sacrâpeo domawec. Eme âgo-ticnezi taha bapa sâkore ficko jujujecte hurâ sacmotâc soŋaŋ naru e âzâcneme Petoro motâc rocneme sacmaŋko rašiwec. ");
INSERT INTO kmg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Eme motâc soŋaŋ naru eki Petoro honerâ šiŋuc âzâcnewec: “Ŋic kecocnirec motecfâc jaŋere guruonec go moc ine hâcne.” Eme eki muwec, “No aricne.” ");
INSERT INTO kmg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Eme kiŋaŋ motec â momori jaŋe mâmâteŋte šoc ruqerâ ruahuc domahapie Petoro e ŋondeŋ-jeŋicko rarâ iŋuc jaha šoc ruawec. ");
INSERT INTO kmg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Eme taha bapa sâkozi Jesu motec rocjopawec â miti muwec, irec mu indiŋ ecnewec. ");
INSERT INTO kmg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ecneme Jesuzi dâŋ kecšiŋuc bâtikiecnewec: “No dâŋ hofao tâtâc muekopac, Judaŋic mitificko â taha ufuŋko tumaŋnehapie dâŋ jaza qazuc eekopac, soŋsoŋ mi muekopac. ");
INSERT INTO kmg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Irec wemocte no wio-narekic? Dâŋ jazape manaeŋgopieŋ jaŋe ejaretec muekopac sâc gazapie manac.” ");
INSERT INTO kmg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iŋuc mume kiŋaŋ motec doma rambiŋ jaŋeraonec moczi Jesu maucnao qahuc muwec, “Go taha bapa sâko dâŋ iŋucne wemocte âzâcnekomec?” ");
INSERT INTO kmg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Eme Jesuzi dâŋ šiŋuc muwec: “Dâŋ hehesic mukopacko fuŋne mutec manape, â tiŋne mukopacko wemocte nukomec?” ");
INSERT INTO kmg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Eme Hanasizi mume Jesu mene qarâ taha bapa sâko Kaifa erao barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Eme Simoŋ Petoro e ine šoc ruahuc domahame wiocnerâ mumbiŋ, “Motecfâc-ticne jaŋere guruonec go moc ine hâcne mecne?” Eme mic barâ muwec, “No aricne.” ");
INSERT INTO kmg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mume taha bapa sâkore kiŋaŋ motec moc, Petorozi hazecne qatarawec ere qomâ, eki šiŋuc muwec: “Á go jufuo ehec mâmâc jupie honecgupac.” ");
INSERT INTO kmg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eme Petoro e mic bame izia qâqâczi dâŋewec. ");
INSERT INTO kmg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hae fureme Jesu Kaifare fickonec bawaharâ kiarao barambiŋ. Judaŋic jaŋe ine wâwânâŋ erâ aakic hombaŋko bâtâcko junšipiŋte kiare ficko mi fembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ehuc hae šoŋao domapie Pilatozi šaeo waharâ wio-jarerâ muwec: “Ŋic keci wemo kiŋte bawareŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eme jaŋe mumbiŋ, “E sâqocne bapa mi juzac muzac gorao mi bawarenšapeŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mupie Pilatozi šiŋuc jazawec: “Ŋaŋacne sâcmutâc dâŋ sâcko dâŋticne mutaracneniŋ me.” Eme Judaŋic jaŋe mumbiŋ, “Nâŋe ŋic hâmocko rârâec-jopare aka henârekicne.” ");
INSERT INTO kmg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Judaŋic jaŋe iŋuc epie Jesu e jahac hâmoc-ticnere dâŋ muwec, hata i âke fuawec. ");
INSERT INTO kmg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Eme Pilatozi ficmaŋko ferâ Jesu hefârerâ muwec: “Go jâmbomac Judaŋic jaŋere ŋicwofuŋ me?” ");
INSERT INTO kmg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Eme Jesuzi muwec, “Dâŋ i gahacne maŋte mukic me gâcnezi micgao râepie mukic?” ");
INSERT INTO kmg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mume Pilatozi muwec, “Wiac no Judaŋic me? Go gahacne ŋicfâc â taha bapa micne jaŋe norao râecguŋgopieŋ. Go wemo emeŋ?” ");
INSERT INTO kmg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Eme Jesuzi šiŋuc muwec: “No mâreŋ ŋicwofuŋ aricne, mâreŋ ŋicwofuŋ juzapo muzac momorifâc-nane jaŋe šikazi ŋezicnuhapie Judaŋic jaŋe wemocko rocnunšapiŋ. No ine mâreŋ ŋicwofuŋ aricne.” ");
INSERT INTO kmg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eme Pilatozi muwec: “Eme go ŋicwofuŋ fuŋmoc?” Mume Jesuzi muwec, “Ine hâcne mukomec, no ŋicwofuŋ fuŋmoc. No dâŋ fâri qizecne mutaniŋkepemurâ mâreŋko waharâ fuapo. Eme moc e dâŋ fâri qizecne jauŋkeocmuzi dâŋnane âgo ecneocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Eme Pilatozi šiŋuc muwec: “Dâŋ fâri qizecne i wemo wiac moc?” Iŋuc murâ šaeo mocwâc hurâ Judaŋic šiŋuc jazawec: “No ŋic kecširec kiŋ basakopac. ");
INSERT INTO kmg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hata-ŋeŋic moc fokac. Ŋoŋe aakic hombaŋko mupie no kâpâcwâru ŋic moc akicke-ŋareekopac. Eme ši manapie sâckeme Judaŋic ŋicwofuŋ-ŋeŋic akickepe juŋarezejec.” ");
INSERT INTO kmg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eme jaŋe harierâ owackehuc mumbiŋ: “Aricne, e mâcne, Baraba akicke-nârec.” Baraba e ine šikaŋic. ");
INSERT INTO kmg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Eme Pilatozi mume momori jaŋe Jesu becsahac biriŋneheczi qambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Qarâ muc šârâneheczi hendiŋ ba akic erâ qizecnao hecnepie huwec â ŋaqi bâbâroŋ mâmâc hecnepie huwec. ");
INSERT INTO kmg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iŋuc erâ maŋfuŋnao birickerâ domahuc fânâŋkecnehuc mumbiŋ: “Ohec, Judaŋic jaŋere ŋicwofuŋ.” Muhuc mainao qambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eme Pilatozi Judaŋic jaŋerao mocwâc hurâ muwec, “Honeniŋ, no ŋoŋerao jowa wahakopac, no kiŋticne basakopacte ŋaŋac fuŋne-ticne honeniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eme Jesu e muchendiŋ â ŋaqi bâbâroŋ, wiac iŋucnehec waha domame Pilatozi jowaturâ muwec: “Ŋic mac ši honeniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Eme taha bapa micne â ŋicfâc-jeŋic jaŋe honerâ dâŋ ɋeŋɋeŋnehec ehuc mumbiŋ: “Maripoŋko feoc, feoc.” Mupie Pilatozi micjeŋicko rorâ muwec: “No kiŋticne basakopacte ŋoŋe ŋaŋac rorâ maripoŋko qaniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Eme Judaŋic jaŋe šiŋuc mumbiŋ: “E jahacnere no Anuture Ŋokâ muekac, eme ŋic iŋucne jaŋe hâmoniŋte sâcmutâc dâŋnâŋec fokacte hâmozejec.” ");
INSERT INTO kmg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Eme Pilato e dâŋ i manarâ mâretec hâwickewec. ");
INSERT INTO kmg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Eme Jesu mocwâc ficmaŋko jowa ferâ indiŋkerâ muwec: “Go wenirec fuameŋ?” Mume Jesuzi micnao mi rowec. ");
INSERT INTO kmg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Iŋuc eme Pilatozi šiŋuc âzâcnewec: “Go dâŋ mi nazakomec me? Noni mupe jucmu me mupe maripoŋko hâmocmu irec tâpiri râe-narekicne, i mi manakic me?” ");
INSERT INTO kmg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Eme Jesuzi šiŋuc âzâcnewec: “Mâc muzac go nore dâŋ wemocko munšaŋ, nore dâŋ mumure faicnec tâpiri qikiŋne-ŋarekicnere mukomec hâcne. Irec gorao râecnukac ŋic ere kiŋzi gore jâurukac.” ");
INSERT INTO kmg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dâŋ i manarâ Pilatozi Jesu akickezo mume Judaŋic jaŋe owa ruruckerâ mumbiŋ: “Go ŋic e akickerâ Sisare ª âgo mocwâc mi jucmu. Moc e jahacnere ŋicwofuŋ muhuc Sisa âkehockeocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatozi dâŋ i manarâ mume Jesu jowa wahapie dâŋ mumutara ŋeŋe-ticnao waha ŋewec. Ŋeŋe i qânâ šaeo râekicne, eme šae irec šâŋe Judaŋic jaŋe Gabata mujumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Eme Judaŋic jaŋe hae fureme aakic hombaŋ ŋeniŋte teuŋko rašimbiŋ. Ehame qâqâtâc bembeŋkeha Pilato e ŋeŋe-ticnao ŋehuc Judaŋic šiŋuc jazawec: “Honeniŋ, ŋicwofuŋ-ŋeŋic ši.” ");
INSERT INTO kmg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mume jaŋe owa ruruckerâ mumbiŋ: “E arictac eoc, e arictac eoc, maripoŋko feoc.” Eme Pilatozi muwec: “Hâc, eme ŋicwofuŋ-ŋeŋic mupe maripoŋko hâmoocte muŋgopieŋ me?” Mume taha bapa micne jaŋe dâŋ šiŋuc bâtikiecnembiŋ: “Nâŋe ŋicwofuŋ-nâŋec moc aricne, Sisa mocjahazi junarekac.” ");
INSERT INTO kmg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eme Pilatozi mana urue-jarerâ Jesu maripoŋko hâmoocte qikiŋne-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Eme momori jaŋe Jesu rorâ maripoŋ râcnepie hâpome mâreŋ moc šâŋene Utusiec, Judadâŋko Goligata, ira barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bararâ maripoŋko qambiŋ. Erâ sâqocne bapa jajahec mâmâc jofarâ moc ŋifec, moc ŋifec, â Jesu šâšâŋiŋko, iŋuc biric-jopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Eme Pilatozi mume Jesure qizec botâŋko maripoŋko qâreŋ kecšiŋuc râembiŋ: “Jesu Nazarete haeonec Judaŋic jaŋere ŋicwofuŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesu qambiŋ mâreŋ i hae bembeŋko fowecte Judaŋic bocjahazi ira rac warec ehuc qâreŋ i wosembiŋ. Eme qâreŋ i Judadâŋko â Romadâŋko â Grikdâŋko râekicne. ");
INSERT INTO kmg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Eme Judaŋic jaŋere taha bapa micne jaŋe Pilato šiŋuc âzâcnembiŋ: “Go Judaŋic jaŋere ŋicwofuŋ iŋuc mi qâreŋkec E jahacne muwec, no Judaŋic jaŋere ŋicwofuŋ, iŋuc qâreŋkec.” ");
INSERT INTO kmg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Eme Pilatozi muwec: “Qâreŋkepac izia fooc.” ");
INSERT INTO kmg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Eme momori jaŋe Jesu maripoŋko qarâ ŋaqi-ticne faine bâtâcnepie jahec â jahec eme ru sâc embiŋ. Á ŋaqi-ticne maŋne hâfâ iŋucne oorâŋ fukicnere ");
INSERT INTO kmg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","šiŋuc mumbiŋ: “I bâtâcnepene sâqoreocmu, irec ɋâsâi qapene rune âke fuaoc.” Iŋuc epie miti papiao dâŋ moc kecšiŋuc qâreŋkekicne i sanaŋkewec: “Jaŋe ŋaqi-nane faine bâtâc bambiŋ, â maŋnere ine ɋâsâi qambiŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Momori jaŋe iŋuc hâcne embiŋ. Jesure maripoŋ fuŋko ine šiŋuc domambiŋ: Neŋgoc-ticne â neŋgoc-ticnere qo, erâ Maria Kelopa ere ŋonâŋ, â Maria Madala haeonec. ");
INSERT INTO kmg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Eme Jesu e neŋgoc-ticne â motec bufuŋ-ticne domapire honec-jofarâ neŋgoc-ticne šiŋuc âzâcnewec: “Ŋokac, motecge keci hâcne.” ");
INSERT INTO kmg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Iŋuc murâ motec-ticne šiŋuc âzâcnewec: “Neŋgocge keci hâcne.” Eme dameŋ ira Jesure neŋgoc jowame motec jahacne ficko ferâ ŋec juc ewec. ");
INSERT INTO kmg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eme Jesu e gie-ticne tarame manarâ, miti papiao findaŋdâŋ moc fokac i deŋkeocte, šiŋuc muwec: “No opâre enarekac.” ");
INSERT INTO kmg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eme râqâc moc maŋnao waiŋ opâ šašacne ŋewec, ira hâwec sâmbiŋ âke uruckerâ qeŋqeŋko âke kindeŋnerâ micnao iticnepie nâwec. ");
INSERT INTO kmg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Waiŋ opâ nârâ wirahuc muwec: “Batarakopac.” Iŋuc mume qizecne forârieme mâro-ticne wefuwec. ");
INSERT INTO kmg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Eme Judaŋic jaŋe teuŋko rašimbiŋte šiŋuc mumbiŋ: “Tomâcko sabata hombaŋ sâkoo ŋic jopakicne jaŋere qâŋɋâŋ maripoŋko mi domazejec.” Iŋuc murâ Pilato âzâcnepie momori jaŋe ŋic siec-jeŋic qazurâ qâŋɋâŋ-jeŋic bataraniŋte Judaŋic mana-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eme momori jaŋe sâqocne bapa Jesuhec jofakicne mocte siec qazurâ ra mocte siec qazumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iŋuc erâ Jesurao fisirâ honembiŋ: E biac hâmowec. Honerâ siecne mi qaqazu ");
INSERT INTO kmg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","momori moczi tambaraŋne sânduzi âke mârâŋkeme soc â opâ wahawec. ");
INSERT INTO kmg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wiac i šâŋe fâri-ticnezi honewec eki mutaniŋkeme jâmbomac ekac. E manakac, dâŋ i fârine. Irec ŋoŋe mana šakienšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Miti papiao findaŋdâŋ moc kecšiŋuc fokac i sanaŋkeocte wiac i fuawec: “Ŋoŋe siecne mi qazunšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Erâ wâc miti papiao dâŋ moc kecšiŋuc fokac: “Jaŋe âke mârâŋkembiŋ erao šâŋe finšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Josefe Arimataia haeonec e Jesure motec juwec, erâ Judaŋic jaŋere hâwickeme fufua mi juwec, soŋsoŋ juwec. Eki hâcne Pilatorao rarâ Jesu qâŋɋâŋ-ticne bataraocte mufuacnewec. Eme Pilatozi manacneme ra batarawec. ");
INSERT INTO kmg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ehame Nikodemo, ŋafeo Jesu iqickewec, eki wokemaŋ âsu biaŋ â kâŋâ bocjaha amecke rarâ Josefe bafickeme ");
INSERT INTO kmg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesure qâŋɋâŋ ruacnerâ qoruc qaŋqaŋzi râpâckepic. Judaŋic jaŋe qâŋɋâŋfâc-jeŋic iŋuc hâcne ejare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Eme Jesu qambiŋ mâreŋ irec ŋifecnao Jufu gie moc fowec, ira hawec moc šâŋeruŋte biŋe gufukicne fowec. Ira ŋic moc mi ducjopakicne, furu fowec. ");
INSERT INTO kmg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Eme Judaŋic hombaŋte teuŋko rašimbiŋte bembeŋko ira hâcne Jesure qâŋɋâŋ râepic. ");
INSERT INTO kmg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Eme Sonda hae mi fure taniŋkeha Maria Madala haeoneczi šâŋeruŋko rawec. Ra fisirâ honewec: Qânâ e šâŋeruŋkonec bârâriekicne. ");
INSERT INTO kmg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iŋuc honerâ gasacke rarâ Simoŋ Petoro â Jesu motec bufuŋ-ticne jasarâ muwec: “Wofuŋ qâŋɋâŋ-ticne bawisembieŋ, eme wena râembieŋ i nâŋe kâuc baŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Iŋuc mume Petoro â motec âgo-ticne jahe šâŋeruŋko rapic. ");
INSERT INTO kmg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hatao gagasac jaha rahuc âgonezi Petoro âte tariŋkerâ biac ra fisiwec. ");
INSERT INTO kmg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ra fisirâ hawecmaŋko mi rašihuc mâc okarierâ fime rašime qoruc râpâ sawa fome honewec. ");
INSERT INTO kmg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ehame Petoro e šâhec fisirâ maŋnao raširâ qoruc râpâ honewec ");
INSERT INTO kmg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","â qizec-ticnere foŋ moc buc bazukicne fome honewec. ");
INSERT INTO kmg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iŋuc eme motec âgo-ticne bâbâni šâŋeruŋko fisiwec eki raširâ iŋuc jaha hone-fârerâ manapaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Juwicnao ine jahe Jesuzi hâmockonec ɋârerâ fahareocte miti papiao findaŋdâŋ fowec i mi mana tarapic. ");
INSERT INTO kmg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eme jahe haeo mocwâc risie rapic. ");
INSERT INTO kmg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Eme Maria eki šâŋeruŋ sahacnao domahuc kiowec” kiohuc ra motâcko okarierâ šâŋeruŋko fime rašime ");
INSERT INTO kmg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","aŋelo jajahec ŋaqi qaŋqaŋhec Jesure qâŋɋâŋ fofotacnao ŋepire honec-jofawec, moc e qizecne fowecko â moc e kikene fowecko ŋewec. ");
INSERT INTO kmg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eme jahe mupic: “Ŋokac, go wemocte kiokomec?” Eme eki muwec: “Wofuŋ-nanere qâŋɋâŋ mocko bawisepie basakopac.” ");
INSERT INTO kmg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iŋuc murâ forisierâ Jesu jahacne honewec. Honerâ Jesu hawarine mi hone tarawec. ");
INSERT INTO kmg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eme Jesuzi wiocnerâ muwec: “Ŋokac, go wemocte kiokomec? Mo basakic?” Eme eki jufu runezi domakac muhuc šiŋuc âzâcnewec: “Ŋicbomboŋ-nane, goki qâŋɋâŋ mocko bara râemecko mutec manarâ ra rozepac.” ");
INSERT INTO kmg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Eme Jesuzi muwec, “Maria.” Mume e forisierâ Judadâŋko “Rabuni” muwec, nâŋâcne dâŋko qaqazu. ");
INSERT INTO kmg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Eme Jesuzi šiŋuc âzâcnewec: “Bâua basanaŋ mi enarec. No Mamactao miŋecnea fepemu i¡ Go rarâ qomâfâc-nane šiŋuc jazac: Nore Mamaczi ŋoŋere Mamac, â nore Anutuzi ŋoŋere Anutu, eme erao hâcne fepemu.” ");
INSERT INTO kmg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eme Maria Madala haeoneczi risie rarâ motecfâcne šiŋuc jazawec: “No Wofuŋ honepe dâŋ iŋuc nazajec.” ");
INSERT INTO kmg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Eme Sonda hae ŋafeme motec jaŋe Judaŋic jaŋere hâwic-jopame tumaŋnerâ ficmotâc ki bafârerâ ŋembiŋ. Ŋehapie Jesu e ŋondeŋ-jeŋicko fuarâ domahuc jazawec: “Wama ŋoŋerao fozejec.” ");
INSERT INTO kmg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iŋuc murâ mejahecne â tambaraŋne jowatuwec. Eme motec jaŋe Wofuŋ honerâ bujeŋic biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eme harierâ jazawec: “Wama ŋoŋerao fozejec. Mamaczi no sorecnuwec iŋuc jaha noni ŋoŋe sorec-ŋopakopac.” ");
INSERT INTO kmg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iŋuc murâ ficnec-joparâ muwec: “Tiri Mâro ro maŋ eniŋ, ");
INSERT INTO kmg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ŋoŋe ŋic sâqocne-jeŋic mutâmirepie tâmire-jareocmu, mi mutâmirepie fojareocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Motec âgo-jeŋic moc šâŋene Toma, šâŋene moc Didimo, eki mocko juhame Jesuzi fua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eme motec âgofâcne jaŋe biŋedâŋ šiŋuc âzâcnembiŋ: “Nâŋe Wofuŋ honembeneŋ.” Iŋuc mupie muwec: “No nahac šâŋe jâmbâŋ-nanezi menao biriŋ râfu honerâ menanezi râfu bahonerâ tambaraŋne bâuarâ dâŋŋeŋic manape fârine eocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sonda mocwâc fuame motec jaŋe Tomahec mâmâc ficko qâzuckerâ motâc ki bafârerâ ŋembiŋ. ŋehapie Jesu e ŋondeŋ-jeŋicko mocwâc fuarâ domahuc jazawec: “Wama ŋoŋerao fozejec.” ");
INSERT INTO kmg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iŋuc murâ Toma âzâcnewec: “Go memotecgezi menane bahonec â mege sicnerâ tambaraŋ-naneo râec, erâ maŋjahec mocwâc mi ehuc manasiŋnuzemec.” ");
INSERT INTO kmg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Eme Tomazi muwec: “Go Wofuŋ-nane â Anutu-nane.” ");
INSERT INTO kmg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mume Jesuzi šiŋuc âzâcnewec: “Go honecnukomecte manasiŋnukomec, mi honecnuhuc manasiŋnueŋgopieŋ jaŋere manape šerine ekac.” ");
INSERT INTO kmg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mâsi gâcne bocjaha Jesuzi motecfâcne jaŋere šâŋe faio bawec, i papia šira mi qâreŋke-fârekicne. ");
INSERT INTO kmg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Qâreŋkekicne mac kecši ine šiŋucte qâreŋkekicne: Ŋoŋe wose manac erâ Jesu e Kristo, Anuture ŋokâ, dâŋ i mana šakienšepieŋ, erâ e jahacne manasiŋkehuc šâŋe biŋe-ticnere erâ juju sanaŋhec enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Juku motec jaŋe Tiberia riqicko juhapie fua-jarewec. Kecšiŋuc ehapie fua-jarewec: ");
INSERT INTO kmg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jumbiŋ ine Simoŋ Petoro, Toma, šâŋene moc Didimo, Natanae e Galilaia mâreŋko Kana hae ŋewec irecnec, erâ Ʒebedaio ŋokâ jahec-ticne â motecfâcne jaŋeraonec jajahec mocwâc, ŋic iŋuczi jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ehuc Simoŋ Petorozi šiŋuc jazawec: “No qowi rozo rakopac.” Mume mumbiŋ, “Nâŋe gohec mâmâc ranaŋ.” Iŋuc murâ wokeo ferâ rambiŋ. Ra juhuc ŋafe ira qowi mi rombiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Eme riqicko juhapie hae fufurecte Jesuzi moŋgeŋko domawec. Domame Jesu hawarine mi hone tarambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eme Jesuzi wio-jarerâ muwec, “Motec, qowi-ŋeŋic moc fokac me?” Eme jaŋe mumbiŋ: “Aricne.” ");
INSERT INTO kmg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mupie šiŋuc jazawec: “Woke fâreopec wasaŋ behepie qowi jowaocmu.” Mume wasaŋ behepie qowi mâretec jâmbâŋ jowa susuckeme fâre-bipiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eme Jesu motec bufuŋ-ticnezi Petoro šiŋuc âzâcnewec: “I Wofuŋ ine hâcne.” Mume Wofuŋ šâŋe manarâ Simoŋ Petoro e kambaŋ sawa qajuwecte ŋaqi-ticne faine heme hume riqicko rucnewec. ");
INSERT INTO kmg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jaŋe moŋgeŋ heririŋ (100 meta irec sâc(c) jumbiŋte motec gâcne jaŋe woke foickehuc wasaŋ qowihec fâre fâre rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Eme moŋgeŋko ferâ tiŋko wiac šiŋuc honembiŋ: Ʒoc uucko opâ qowi â nânâ šegoc šahuc fowec. ");
INSERT INTO kmg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ra fisipie Jesuzi šiŋuc jazawec: “Qowi rombieŋ i tucne bareniŋ.” ");
INSERT INTO kmg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mume Simoŋ Petorozi wokeo ferâ wasaŋ tiŋko fâreme fewec. Maŋnao qowi kâcɋene 153 fowec, eme sifu mi tâcnewec. ");
INSERT INTO kmg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Eme Jesuzi šiŋuc jazawec: “Ware furic nânâ nâniŋ.” Mume motec jaŋe wemocko šiŋuc wionšapiŋ: “Go mo?” Jaŋe Wofuŋ ine hâcne i mana-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eme Jesuzi warerâ nânâ qowi bâtâc bahuc jarewec. ");
INSERT INTO kmg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","I Jesu e hâmockonec faharerâ motecfâcne fua-jareme jahec â moc ewec. ");
INSERT INTO kmg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Furic nânâ nâpie Jesuzi Simoŋ Petoro šiŋuc muhuc wiocnewec: “Simoŋ Johanere ŋokâ, âgofâcge jaŋe no maŋzi šâficnueŋgopieŋ, go jowarurâ sâc moc šâficnuekic me?” Eme Petorozi muwec, “Wofuŋ, no gore enarekac i manakomec.” Eme Jesuzi muwec: “Go lamafâc-mae soŋaŋ-jopazemec. ");
INSERT INTO kmg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iŋuc murâ mocwâc wiocnewec: “Simoŋ Johanere ŋokâ, go jâmbomac šâficnuekic?” Eme Petorozi muwec: “Wofuŋ, no gore enarekac i manakomec.” Mume Jesuzi muwec: “Go lamafâc-nane jaŋere soŋaŋ juzemec.” ");
INSERT INTO kmg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iŋuc murâ harierâ wiocnewec: “Simoŋ Johanere ŋokâ, go jâmbomac nore egarekac me?” Ʒâšâficte wiocneme jahec â moc eme Petoro e bune sâqoreme muwec: “Wofuŋ, go wiac sasawa mana-fâreekic, no gore enarekac i wâc manakomec.” Mume Jesuzi muwec: “Go lamafâc-nane soŋaŋ-jopazemec. ");
INSERT INTO kmg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jâmbomac jâmbâŋ gazape: Go ŋicmotec juhuc becsahacge jomarâ hata ira me ira razo egareme rajumec. Izi juku ŋicqizec erâ mege bâfeŋnetec ŋic moczi becsahac joma-garerâ mi razo mucmu ira bacgu raocmu.” ");
INSERT INTO kmg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu e iŋuc muhuc Petoro hâmoc-ticnere dâŋ suŋsuŋne âzâcnewec. Hâmoc-ticne fuŋmoczi Anutu muteŋkeocte manasuhuc muwec hâcne. Dâŋ iŋuc murâ šiŋuc âzâcnewec: “Ware bâjâpecnuc.” ");
INSERT INTO kmg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Eme Petoro e fotikierâ Jesu motec bufuŋ-ticnezi râpefuŋnao rame honewec. Motec e aakic lama nâmbiŋko qizec-ticne Jesure amecko fohorerâ wiocnerâ muwec: “Wofuŋ, mozi doc bacguocmu?” ");
INSERT INTO kmg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Eme motec hâcne šâhec rame Petorozi honerâ Jesu wiocnerâ muwec: “Wofuŋ, motec kecšizi ine weniŋuc eocmu?” ");
INSERT INTO kmg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Wiocneme Jesuzi šiŋuc âzâcnewec: “E juhame no risiepemurâ manacnepe fokacko ere dâŋ wemocte mukomec? Go mâc bâjâpecnuc.” ");
INSERT INTO kmg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eme miti mamana gâcne jaŋe šâhec Johanere šiŋuc musifuckembiŋ: “Motec e mi hâmoocmu.” Jesu e ine ere šiŋuc mi muwec: “E mi hâmoocmu.” Dâŋ šiŋuc sawa âzâcnewec: “E juhame no risiepemurâ manacnepe fokacko ere dâŋ wemocte mukomec.” ");
INSERT INTO kmg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Motec eki hâcne wiac ši hone mana tarac eku mutaniŋkehuc papia ši qâreŋkewec. Eme nâŋe ere manaeŋgopeneŋ, dâŋticne fârine jâmbâŋ. ");
INSERT INTO kmg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Eme Jesuzi wiac gâcne gâcne ewec bawec, i wemocko papiao qâreŋke-fârezo. I papiao fofâreme muzac, no manape ŋiczi wowose tarane mi ezac. ");
INSERT INTO kmg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Teofilo, no mârâc dâŋ qâreŋke-garepo, ine Jesuzi gie bawec â miti muwec irec dâŋ binaŋ sasawa egarepo. ");
INSERT INTO kmg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","E gie-ticne fuŋkerâ baraku dameŋ-ticne maickeme Tiri Mârozi ecneme aposolo rowosâec-jopawec jaŋe micrâfâ-ticne jaza tararâ sambâŋko fewec, irec binaŋ hâcne qâreŋke-fârepo. ");
INSERT INTO kmg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","E šâic manaku hâmorâ mocwâc ɋârerâ Jaŋe hâcne šoaŋ gie bapa 40 fua soŋ ejarehuc fuŋne-ticne bajaŋgeŋkeme hone manac embiŋ, â Anuture uucmaŋ irec dâŋ jaza mutâc ewec. ");
INSERT INTO kmg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Erâ jaŋehec ŋec domac ehuc dâŋ šiŋuc jazawec: “Ŋoŋe Jerusalem hae jâpec mi behenšepieŋ, Mamacte biŋedâŋ ŋazape manambiŋ, i fârinehec eocte ira woŋec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Johane e opâ rua-ŋarewec, ši ine dameŋ mi šorahame Tiri Mâro rua-ŋarezo.” ");
INSERT INTO kmg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iŋuc mume, tumaŋnerâ jumbiŋ jaŋe šiŋuc muhuc wiocnembiŋ: “Wofuŋ, go dameŋ ira hâcne Israe ŋic qâzuc-nâpotec mocwâc nâŋe nâŋâcne ŋicwofuŋhec erâ junaŋmu me?” ");
INSERT INTO kmg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mupie šiŋuc jazawec: “Mamac e tâpiri-ticnere erâ dameŋ šoric qândâŋ bawec fokac i ŋoŋe mamanane mi ekac. ");
INSERT INTO kmg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mocjaha Tiri Mârozi ŋoŋerao waharâ tâpiri bâfua-ŋareme biŋe mumufâc-nane eniŋmu. Ehuc Jerusalem haeo bâtâcnerâ miti-nane Judaia â Samaria mâreŋko murâ murakupie mâreŋ qaŋeŋne sâcke-fâreocmu.” ");
INSERT INTO kmg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Dâŋ iŋuc murâ šâŋe fai-jeŋicko afeckerâ fewec. Fehame karoraczi bâsoŋkeme basambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eme sambâŋko fehame firâ râqârehuc domahapie ŋic jajahec ŋaqi qaŋqaŋhec mi jaŋerao fuarâ domazepirec i¡ ");
INSERT INTO kmg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Erâ šiŋuc jazapic: “Galilaia mâreŋkonec ŋicbureŋ, ŋoŋe wemocte sambâŋko fihuc jaha domaŋgopieŋ? Jesu ŋoŋe honehapie behec-ŋoparâ sambâŋko fekac, eki hâcne juku iŋuc jaha wahazokac.” ");
INSERT INTO kmg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Eme aposolo jaŋe Oliwa tikionec risie waharâ rašimicnao Jerusalem hae ŋewec ira rašimbiŋ. Sawane i sabata hombaŋko hata rarane irec sâc. ");
INSERT INTO kmg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Raširâ haeo ferâ ŋeŋe juju ehuc jumbiŋ fic ira fembiŋ. Jumbiŋ ine šiŋuc: Petoro â Johane, Jakobo â Anderea, Filipo â Toma, Batolomaio â Mataio, Jakobo Alifaiore ŋokâ, Simoŋ Ʒelote, erâ Juda Jakobore ŋokâ. ");
INSERT INTO kmg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŋic i jaŋe hâcne maŋ mocjaha erâ nunumu gie šušuhuc jaha bahuc jumbiŋ. Iŋuc ehapie Jesure neŋgoc Maria â ŋokac gâcne â Jesu ɋafâc-ticne jaŋe mâmâc bafic-jopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dameŋ ira Jesure qâjâpecfâc šare-jeŋic 120 qâririŋ iŋuczi tumaŋnerâ ŋehapie Petoro e ŋondeŋ-jeŋicko faharerâ dâŋ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Âgo bureŋ, Juda râsi jowac-jopame Jesu rombiŋ ere dâŋ Tiri Mârozi Dawidi mic ba afec ecneme mu qâreŋ ewec i wemocko mâc fozac. ");
INSERT INTO kmg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juda e nâŋâcnaonec hâcne, â miti gie i e mâmâc mucnekicne. ");
INSERT INTO kmg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Eme ŋic eki šika furizi mâreŋ kitâcnecnewec ira ra qizeczi qârisic hurâ bune qâfâuckeme hone waha-fârewec. ");
INSERT INTO kmg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eme biŋe i Jerusalem haeoneczi mana-fârerâ mâreŋ irec šâŋe Akedama mumbiŋ, nâŋâcne dâŋko Ʒikamâreŋ. ");
INSERT INTO kmg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Miti mânecko šiŋuc hâcne qâreŋkekicne fokac: `Hae-ticne tuhu fuazejec, â ficticnao ŋic moc mi juzejec.' Erâ moc šiŋuc: `Mafa-ticne i furunezi rauckezejec.' ");
INSERT INTO kmg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Eme Jesu ŋondeŋ-nâŋecko jume ju ecnepene ŋic gâcnezi qâsuec-nâpombiŋ, ");
INSERT INTO kmg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ehuc Johanezi Jesu Miti Opâ ruacneme gie-ticne fuŋkewec dameŋ ira erao šuhuckerâ bâjâpehuc juhapene sambâŋko fewec, ŋic iŋucne moczi fuarâ bafic-nâpome, Jesu hâmockonec faharewec irec biŋe mupene haŋ bazejec.” ");
INSERT INTO kmg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petorozi iŋuc jazame ŋic jajahec bâfuac-jofambiŋ. Moc šâŋene Josefe, Basaba mucne jumbieŋ, šâŋene moc Jusito, erâ âgone Matia, ");
INSERT INTO kmg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bâfuac-jofarâ šiŋuc muhuc numumbiŋ: “O Wofuŋ maŋ hohone, go ŋicjahec ši jaheraonec wenimoi bâwosâekomec i nâwotutec mucnepene ");
INSERT INTO kmg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Juda miti â aposolo gie-ticne hetararâ e jahacne hatao rawec ere jujutacko juzejec.” ");
INSERT INTO kmg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iŋuc numurâ miti ɋâsâi qapie Matia âke fuame aposolo 11 jaŋerao šuhuckewec. ");
INSERT INTO kmg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekoso dameŋ maickeha jaŋe mâmâc sasawa fic mocjahao qâzuckerâ ŋefârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ŋehapie sambâŋkonec fânâŋ moc mâŋâŋ hâhâwicne ere fânâŋ tinac ɋeŋfâfâc jaha fânâŋke wahawec. Waharâ fic ŋembiŋ ira raširâ fusucmawec. ");
INSERT INTO kmg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ehame jaŋerao wiac moc hawarine šocnameŋ tinac fuarâ domahuc ŋeratierâ ŋic ŋokac qizec-jeŋic sâc biricke rawec. ");
INSERT INTO kmg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eme Tiri Mârozi maŋjeŋicko hurâ fusucmame dâŋmarac fuŋne fuŋne dâŋembiŋ, Mârozi ru sâc bâfua-jareme dâŋe rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Eme dameŋ ira Jerusalem haeo mâreŋ sâc irecnec Judaŋic mitine jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eme jaŋe fânâŋ sâko i manarâ mâretec fisirâ tumaŋnehuc bipic tatara embiŋ. Ehuc aposolo jaŋe dâŋjeŋic sâc dâŋepie ");
INSERT INTO kmg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","manarâ maŋjeŋic goroŋkeme wareckerâ mumbiŋ, “Ŋic dâŋeŋgopieŋ ši jaŋe Galilaia ŋic sasawa, ");
INSERT INTO kmg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","jaŋe weniŋuc erâ dâŋnâŋec sâc dâŋepie manapene dâŋrune marac efârekac? ");
INSERT INTO kmg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nâŋâc ši Pataŋic â Medeŋic â Elamŋic, erâ Mesopotamia mâreŋkonec â Judaia mâreŋkonec â Kapadokia mâreŋkonec â Ponto mâreŋkonec â Asia mâreŋkonec ");
INSERT INTO kmg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","â Frigia mâreŋkonec â Pamfilia mâreŋkonec â Aigita mâreŋkonec â Africa mâreŋkonec Kirene hae rârec rârec irecnec, nâŋâc Romaŋic ");
INSERT INTO kmg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","â Judaŋic mafa â hae fâri erâ Kretaŋic â Arabia ŋic. Nâŋâc iŋuczi juhuc dâŋnâŋec sâc Anutu mâsi sâko-ticnere biŋedâŋ mupie manaŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ŋic jaŋe iŋuc murâ maŋjeŋic goroŋkeme kâuc barâ nazaŋ gazaŋ erâ mumbiŋ, “I wemo mâsi mo?” ");
INSERT INTO kmg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gâcnezi ine aposolo mufec muriŋ ejarehuc mumbiŋ, “Jaŋe waiŋ opâ gapecmâc nâmbieŋte maŋjeŋic bibiriwakac.” ");
INSERT INTO kmg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Eme Petoro e âgofâcne 11 jaŋehec domahuc dâŋ hahaŋne barâ šiŋuc jazawec “Judaŋic â Jerusalem haeo juŋgopieŋ sasawa, no dâŋ ŋazape hazec-ŋeŋic râerâ mananiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ŋoŋe ŋic kecši jaŋere muŋgopieŋ `Waiŋ opâ nâku maŋjeŋic bibiriwakac. Ž Iŋuc aricne. Hae miŋecne furekacte wemocko waiŋ opâ nanšapeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Porofete Joelezi findaŋdâŋ kecšiŋuc qâreŋkewec i sanaŋkekac hâcne: ");
INSERT INTO kmg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Anutuzi mukac: Juku mâreŋ dameŋne bembeŋkeha, no Mâro-nane ŋic šeŋgoma sâcke-jarepemu; eme otâ ŋokâfâc-ŋeŋic findaŋdâŋ muniŋmu, socɋârifâc-ŋeŋic wiac šâŋe furu honeniŋmu, â ŋic ŋokac qizecfâc-ŋeŋic guŋ fârine mananiŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Erâ kiŋaŋ qaqa ŋic ŋokacfâc-nane dameŋ ira Mâro-nane sâcke-jarepe findaŋdâŋ muniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Erâ mupe faic sambâŋko šâŋe furu wiac fuaocmu, â juwic mâreŋko fuŋne qaqa mâsi fuaocmu, soc â šoc â hosâc rombâŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ʒoaŋ šâŋene hâpoocmu, â mosa šâŋene socsoc eocmu, ehame Wofuŋte dameŋ maickeocmu, dameŋ biaŋ sâko hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eme ira Wofuŋte šâŋe riwaseckeniŋmu, jaŋe sisipirickonec batarac-jopazo.' ");
INSERT INTO kmg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israe ŋicbureŋ no ŋazape mananiŋ: Jesu Nazarete haeonec e Anutuzi neŋgoc ŋesiŋ ŋecnehame ŋondeŋ-ŋeŋicko tâpiri sâko-ticnezi mâsi â wiac šâŋe furu bahuc, Anuturaonec wahawec, irec fuŋne-ticne bataniŋkeme honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E hâcne Anutuzi mârâc jaha maname fowecte hata mutaracnewec irec sâcko ŋoŋe wiac ecnehuc doc barâ ŋic qâpuc jaŋerao râepie maripoŋko qapie hâmowec. ");
INSERT INTO kmg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","E hâcne hâmoczi gozi kime Anutuzi gozi bacneme ɋârerâ faharewec. Hâmoczi e wemocko sakarezac. ");
INSERT INTO kmg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawidizi ere hâcne kecšiŋuc muwec: `No Wofuŋ hone dendeŋnehuc mi beheekopac, e fâre-naneo domahame biric boroc mi epemu. ");
INSERT INTO kmg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Irec bunane biaŋkeme nameŋzi mu šeri ekopac, erâ sahac-nanezi wâc sâcne ŋec foc eocmu. Go mi qaisocnutec hâmoc haeo šâziŋkepemu, â Tiriŋicge mi behetec gârecke šaŋ eocmu. ");
INSERT INTO kmg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Go jujure hata nowatumeŋ, maigao šeri bubiaŋ guru dindiŋ bâfua-narecmu.' ");
INSERT INTO kmg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Âgo bureŋ, no mimiŋne-nâŋec Dawidi ere acmâc ŋazape, e hâmome duckembiŋ, eme šâŋeruŋ-ticne hone manac ehuc jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","E porofete juweczi šiŋuc manawec: Anutu e ɋâricfâc-nane jaŋeraonec moc âkendâŋneme nore ŋicwofuŋ ŋeŋetacko ŋeocte mupaŋke-narewec. ");
INSERT INTO kmg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","I manahuc juwicnao Kristo fafahare-ticnere hâcne muwec, `E hâmoc mi qikiŋnecneocmu â sahac-ticne gârecke šaŋ mi eocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Eme Jesu e hâcne Anutuzi baɋâreme fahareme nâŋe šâŋe fâri-nâŋeczi hone-fârembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Eme Anutu mefârenao risie feme Tiri Mâro biŋe qanâre-kicne e hâcne Mamaczi qikiŋnecneme soreme wahame fuŋne-ticne hone manac eŋgopieŋ šine hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawidi e jahacne sambâŋko mi fewec, mâc dâŋ kecšiŋuc ine muwec: `Wofuŋzi nore Wofuŋ âzâcnewec: Ware fâre-naneo ŋehaŋtec, ");
INSERT INTO kmg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","râsifâcge guruc-jopape kikegere ââtesiŋ enšepieŋ.' ");
INSERT INTO kmg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Irec Israe ŋic mâmâc sasawa šiŋuc mana sanaŋkenšepieŋ: Ŋoŋe Jesu maripoŋko qambiŋ, e Anutuzi Wofuŋ â Kristo âkendâŋne-nârewec jukac.” ");
INSERT INTO kmg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petorozi dâŋ iŋuc jazame maŋjeŋic henšaŋneme e jahacne â aposolo gâcne šiŋuc mu wioc ejarembiŋ: “Ŋic âgofâc, nâŋe weniŋuc epene sâckeocmu?” ");
INSERT INTO kmg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mupie Petorozi šiŋuc jazawec: “Ŋoŋe maŋŋeŋic bârisierâ Jesu Kristo šâŋene biŋeckehuc Miti Opâ ruapie sâqocne-ŋeŋic tâmirezejec, eme Anutuzi Tiri Mâro tahacke-ŋareocmu wâc. ");
INSERT INTO kmg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ŋaŋacne â ɋâricfâc-ŋeŋic â šoricko juraŋgopieŋ, Wofuŋ Anutu-nâŋeczi hefârec-ŋopaocmu sâc, ŋoŋe hâcne Tiri Mâro biŋe qaŋare-fârekicne.” ");
INSERT INTO kmg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petoro e iŋuc murâ dâŋ gâcne šuhuckerâ uŋ sawaŋ ejarehuc šiŋuc jazawec: “Ŋoŋe ŋic bâbâsifucne jaŋere guruonec wiserâ wefupie rocŋopazo.” ");
INSERT INTO kmg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eme šoaŋ gie bapa ira ŋic 3 tauseŋ jaŋe Petorore mitidâŋ mana šakiepie Miti Opâ rua-jarepie Jesure kikefuŋfâc jaŋerao šuhuckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eme aposolo jaŋe miti jaza qazuc epie mananiŋte henširiŋnehuc jumbiŋ, ehuc maŋzi roroc bâmbândeŋ erâ tiwâre â nunumure gâbâ tumaŋne jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Eme ŋic ŋokac šeŋgoma hâwic sahac efârembiŋ â aposolo jaŋe mâsi fuŋne fuŋne bahuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Opâ ruac jaŋe maŋzi šâšâfic erâ wiac sasawa-jeŋic wirec bajumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Á gâcne jaŋe ine jufu mafa wiac-jeŋic qikiŋnepie moneŋ kitâcneme âgofâc-jeŋic waha qaqane wiac basambiŋ sâc bâtâc bajarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jaŋe šoaŋ gie bapa sâc taha ufuŋko maŋ mocjaha erâ tumaŋne jumbieŋ â tiwâ i ficjeŋic sâc nâjumbieŋ. Ehuc nânâ-jeŋic bubiaŋko bâtâc tâmiric nâhuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Erâ Anutu mumbiaŋkehuc jumbiŋ. Iŋuc epie ŋic gâcnezi hone šiziwec-jopambiŋ. Eme Wofuŋ e šoaŋne šoaŋne ŋic mitizi bâpiaŋ-jopahame guru-jeŋicko ro šuhuc ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ʒoaŋ mocko Petoro â Johane jahe owâ gieo nunumu dameŋ maickeme taha ufuŋko fepic. ");
INSERT INTO kmg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ehame ŋic moc neŋgoc bumaŋkonec puriŋ fuakicne e reŋke warembiŋ. Ŋic e âgofâcne jaŋe šoaŋne šoaŋne taha ufuŋte Motâcbiaŋko râepie ŋehuc ŋic ufuŋko fec wahac embiŋ jaŋe bâmec wiacte numu-jare jujec. ");
INSERT INTO kmg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eme Petoro â Johane jahe taha ufuŋko fezo ehapire honec-jofarâ iŋuc jaha numu-jactewec. ");
INSERT INTO kmg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Numu-jacteme jahe e hone dendeŋnepic, ehuc Petorozi šiŋuc âzâcnewec: “Go nâhe honec-nâfoc.” ");
INSERT INTO kmg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mume ŋicpuriŋzi wiac moc narezo mukopirec muhuc nâckâbâc jaha honec-jofawec. ");
INSERT INTO kmg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Iŋuc ehame Petorozi šiŋuc âzâcnewec: “Moneŋ boreŋ wiac no mi fonarekac, wiac mocjaha fonarekac ine garepe roc, Jesu Kristo Nazarete haeonec ere micte gazape fahare hata juc.” ");
INSERT INTO kmg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Iŋuc murâ mefârenao rohuc bafaharewec. Ecneme izia kike bibiric-ticne urueme fu herâ fahare domawec, ");
INSERT INTO kmg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","erâ jahehec mâmâc taha ufuŋko fembiŋ, erâ hata juju-ticnere kiwac qawac ehuc Anutu muteŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eme ŋic sasawa jaŋe hata jume â Anutu muteŋkeme honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ehuc šâŋitarâ mumbiŋ, “Taha ufuŋte Motâcbiaŋko bâmec wiacte numu-nârehuc ŋeekac ine hâcne.” Erâ biaŋkewec irec hone fâfârerâ mâretec seckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Eme Petoro â Johane jaherao qohotame ŋic mâmâc sasawa taha ufuŋ maŋne moc šâŋene Salomo ira jaherao tumaŋne-fârehuc me kirâ domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Iŋuc epie Petorozi honec-joparâ ŋic dâŋ šiŋuc jazawec: “Israe ŋicbureŋ, ŋoŋe wemocte ŋic širec hone warec boc enâctehuc domaŋgopieŋ? Wiac nâhe nâhâcne mitire me tâpirire e hata juju-ticne bâfuacnekoperec me? ");
INSERT INTO kmg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aricne, Abraham â Isaka â Jakobo jaŋere Anutu, mimiŋnefâc-nâŋec jaŋere Anutu, eki hâcne kiŋaŋŋic-ticne Jesu ere Wofuŋ qâreŋ ŋic kecširec faio bâfuame honeŋgopieŋ. Ŋoŋe ine e qaisockerâ qâpuc jaŋerao râembiŋ. Ehame Pilatozi firuezo mume ŋoŋe qikiŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ine hâcne Maŋɋaɋac â Tiŋne rune e qikiŋnehuc šika qaqaŋic akicke-ŋareocte mu bâuruec ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ehuc jujure Micne bapa qambiŋ. Qapie Anutuzi bâɋâreme hâmockonec fahareme šâŋe fâri-nâŋeczi qame honembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eme hone manac ecneeŋgopieŋ ŋic kecši e Jesu šâŋe-ticne manasiŋkepene šâŋe-ticnere tâpirizi bâpiaŋkeme sahac ɋiɋic eme hone-fâreŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Erâ qomâfâc-nane, no manakopac, ŋoŋe â micne bapafâc-ŋeŋic ŋoŋe kâuc bahuc iŋuc embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Iŋuc epie Anutu e Kristo šâic manaku hâmoocte irec dâŋ porofete sasawa jaŋere micko râeme mu qâreŋ embiŋ i hâcne sanaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Irec ŋoŋe maŋŋeŋic bârisierâ juju raŋɋa-ŋeŋic râpeckepie kiŋŋeŋic tâmirezejec. Eme Wofuŋte maio nanaŋ šurec šurec juju irec dameŋ maicke-ŋarezejec. ");
INSERT INTO kmg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Erâ wâc Kristo-ŋeŋic bašawie-ŋarewec, Jesu hâcne, sore-ŋarezejec. ");
INSERT INTO kmg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ʒi ine Jesu e sambâŋzi foŋkeme jukuhame wiac sasawa Anutuzi mârâc jaha jâmbâŋ porofetefâc-ticne micjeŋicko râeme mumbiŋ i fâri fideteŋ eocte dameŋne maickeocmu. ");
INSERT INTO kmg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mose e dâŋ kecšiŋuc muwec: `Wofuŋ Anutu e qomâfâc-ŋeŋic jaŋere ŋondeŋkonec porofete moc no iŋucne bâfua-ŋareme dâŋ ŋazame sâc mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Eme moc e dâŋticne qikiŋneme e qarâ qârârâŋnenšepieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Erâ porofete gâcne Samue jume juwarembiŋ jaŋe iŋuc jaha dameŋ širec dâŋ mu qâreŋ efârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Porofete jumbiŋ jaŋere ɋâricfâc ŋoŋe, erâ Anutuzi mimiŋnefâc-ŋeŋic jaŋehec šâšâfic ewec, šâšâfic irec rune ŋoŋe jaha wâc. Ʒâšâfic i Abraham šiŋuc âzâcnehuc bâfuawec: No ɋâricfâcge jambuŋ-jopape jambuŋ izi mâreŋne mâreŋne ŋic sâcjopa-fârezejec. Ž ");
INSERT INTO kmg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ŋoŋere hâcne Anutuzi qanaŋ manasurâ Ŋokâ-ticne soreme waha fuawec, i ŋoŋe sasawa sindaŋ hata-ŋeŋickonec bârisiec-ŋopahuc jambuŋ-ŋopaocte iŋuc hâcne ewec.” ");
INSERT INTO kmg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petoro â Johane jahe ŋic dâŋ iŋuc jazahuc domahapire taha bapa â ufuŋte polismaî micne â sadukaio ŋic jaŋe mâmâc jaherao fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jahe ŋic miti jazahuc, Jesu e hâmockonec ɋârewec, biŋedâŋ i muiŋnepire manapie sâqoreme ");
INSERT INTO kmg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","rocjofarâ hae biac owâewecte kâpâcwâru ficko râec-jofapie fohapire hae furewec. ");
INSERT INTO kmg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eme Petorozi miti mume manambiŋ jaŋeraonec bocjahazi i mana šakierâ Jesure kikefuŋfâc jaŋerao šuhuckepie ŋic sasawa šare-jeŋic 5 tauseŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hae fureme micne bapa â soŋaŋ â miti qaqazu jaŋe Jerusalem haeo ");
INSERT INTO kmg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","taha bapa sâko Hanasi â Kaifa â Johane â Alesande â kikefuŋfâc-jeŋic jaŋehec tumaŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Erâ mupie aposolo jahe tutumaŋ-jeŋicko bacjofa fembiŋ. Eme mai-jeŋicko domapire esâic-jofarâ mumbiŋ, “Mozi mamac eŋactehuc mu qafeŋ eŋacteme mâsi i bapirec?” ");
INSERT INTO kmg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Eme Petoro e Tiri Mârozi maŋnao fusucmame dâŋ šiŋuc jazawec: “Micne bapa â soŋaŋfâc-nâŋec, mupe mananiŋ: ");
INSERT INTO kmg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nâhe ŋicpuriŋ jauŋkeperec, irec ŋoŋe, mozi neŋgoc ŋesiŋ eŋacteha ŋic bâpiaŋkepirec, muhuc miŋecgac mu gufuc enâcteŋgopieŋko ");
INSERT INTO kmg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mutaniŋkepe ŋoŋe â Israe ŋic mâmâc sasawa mananiŋ: Jesu Kristo Nazarete haeonec, ŋoŋe maripoŋko qapie hâmome Anutuzi hâmockonec bâɋâreme faharewec jukac, ere tâpirire ŋic keci sahac ɋiɋic ejec mai-ŋeŋicko domakac hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ficbapa ŋic ŋoŋe Jesu e wâtuŋ sâqocne muhuc behepie izi hâcne jâmâ wâtuŋ sâko ewec domakac. ");
INSERT INTO kmg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bâbâpiaŋ i ŋic moctao moc mi fokac, â ŋic mocte šâŋe riwaseckehuc bibiaŋkene i wâc mâreŋko mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Eme Petoro â Johane jahe ŋic omane, mamana ficko mi jukicnezi hâhâwic tâmiric micafec jaha dâŋ mupire manarâ wareckembiŋ. Erâ jahe Jesuhec jupic i hone tarac-jofambiŋ, ");
INSERT INTO kmg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","â ŋic sahac ɋiɋic eweczi jaherao domame e wâc honehuc irec dâŋ bâtikie-jacteniŋte basambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Basarâ ejactepie hae šoŋao hurâ domahapire jaŋackoaŋ šiŋuc muhuc nazaŋ gazaŋ embiŋ: ");
INSERT INTO kmg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nâŋâc ŋic jahe weniŋuc ejactenaŋ? Jahe mâsi bapire fua tâcneme Jerusalem haeoneczi biŋene biac mana-fârembieŋ, irec wemocko hemackezo? ");
INSERT INTO kmg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Eme dâŋ i hae sâc haŋ bame mana-fârenšipiŋte mu hâhâwic ejactepene ŋic hâcne šâŋe biŋe-ticne mocwâc mi jaza-jâmbâŋkezepirec.” ");
INSERT INTO kmg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Iŋuc murâ hefârec-jofarâ šiŋuc jasambiŋ: “Ŋohe Jesure šâŋe ŋic mocwâc mi jaza qazuc ejâmbâŋkezepirec.” ");
INSERT INTO kmg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mupie Petoro â Johane jahe dâŋ šiŋuc bâtikie-jarepic: “Ŋoŋe ŋaŋac mana honeniŋ, ŋoŋere dâŋ reŋkehuc Anuture dâŋ qiqikiŋ, irec Anutuzi maname sâckeocmu me? ");
INSERT INTO kmg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wiac hone manac ehuc jumbeŋ i sâcne mi hesoŋkerâ junaŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Iŋuc mupire jaŋe mu hâhâwic dâŋ mocwâc jasahuc râec-jofapie rapic. Haeŋic ŋokac omane jaŋe mâsi i hone manac erâ Anutu mucne bacnembiŋte jaŋerao quŋkehuc aposolo jahe wiac mi ejactembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ŋic sahac ɋiɋic bakicne e puriŋ fohuc juha jara 40 ewec i mana-fârembiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petoro â Johane jahe ŋic tutumaŋkonec waharâ âgo wiacfâc-jekic jaŋerao rarâ taha bapa micne â soŋaŋ jaŋe dâŋ jasambiŋ irec mu binaŋ ehuc jaza-fârepic. ");
INSERT INTO kmg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eme jaŋe i manarâ maŋjeŋic qâzuckerâ Anuturao sâsepie fehame šiŋuc mumbiŋ: “Wofuŋ sâko Wofuŋ, go sambâŋ â mâreŋ â hâwec i wiac fuŋne fuŋne-jeŋichec râemeŋzi ");
INSERT INTO kmg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tiri Mâro ecnetec eki mimiŋne-nâŋec Dawidi, kiŋaŋŋicge hâcne, micne baafeckeme dâŋ šiŋuc muwec: `Oapuc jaŋe wemocte ju fâfânâŋ eeŋgopieŋ, â ŋicne ŋicne dâŋ racne birickeeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wofuŋ â Kristo-ticne râsi ejacteniŋte mâreŋ sâc ŋicwofuŋ jaŋe meo roroc eeŋgopieŋ, â ŋicbomboŋ jaŋe ââte sanaŋ eeŋgopieŋ.' ");
INSERT INTO kmg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Hae kecšira ine jâmbomac tiri Ŋokâge Jesu, Kristo âkendâŋnemeŋ, e râsi ecneniŋte Herode â Pilato jahe ŋic qâpuc jaŋehec â Israe ŋic jaŋehec dâŋ ŋiŋihec embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Erâ gahacne mezi â miczi mu bâmoc emeŋ irec sâcmac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eme Wofuŋ, ši ine mu hâhâwic dâŋjeŋic hone manac ehuc kiŋaŋŋicfâcge hâbi hejaretec mitige hâhâwicmâc munšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ehapie mege sicnetec sahac ɋiɋic â mâsi fuŋne fuŋne tiri kiŋaŋŋicge Jesu ere erâ fua razejec.” ");
INSERT INTO kmg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Iŋuc numupie fic, tumaŋnerâ ŋembiŋ, qiriŋ qiriŋ qawec. Ehame Tiri Mârozi maŋjeŋicko fusucmame Anuture dâŋ micafec jaha ŋic jazambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Opâ ruac guru jaŋe maŋ mocjaha ehuc šâšâfic erâ jumbiŋ. Ehuc wiac fojarewec irec nore gore mi muhuc qâqâhâc mocjaha fojarewec. ");
INSERT INTO kmg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Eme aposolo jaŋe Wofuŋ Jesu hâmockonec faharewec irec biŋedâŋ tâpiri jaha muhuc jumbiŋ. Eme aki anonoc sâkozi sâcjopa-fârerâ fowec. ");
INSERT INTO kmg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Erâ ŋondeŋ-jeŋicko moczi tac qararacne mi juwec. Jufu gie â mafa wiac-jeŋichec jumbiŋ jaŋe i qikiŋnepie moneŋ kitâcne-jareme ");
INSERT INTO kmg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposolo jaŋerao râembiŋ. Eme jaŋe ŋic wiac basapie sâc bârâwiŋnerâ jare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Eme ŋic moc juwec šâŋene Josefe, aposolo jaŋe šâŋene moc Banaba mumbiŋ, nâŋâcne dâŋko Bâmiriŋmotec, e Lewire ɋâric, Kipiro nucko fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ŋic eki jufu-ticne qikiŋneme moneŋ fuame aposolo jaŋerao furu jaha râe-fârewec. ");
INSERT INTO kmg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Eme ŋic moc juwec šâŋene Anania, e ŋonâŋ-ticne Safira ehec muc manac ehuc hae mâreŋ-ticne qikiŋneme moneŋ fua-jacteme ");
INSERT INTO kmg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","mamanac erâ tucne hefackepire fojactewec â tucne sawa ŋiczi aposolo jaŋerao râewec. ");
INSERT INTO kmg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Râeme Petorozi šiŋuc âzâcnewec: “Anania, go wemocte Sataŋzi maŋge bâsifuckeme Tiri Mâro eatuckehuc hae mâreŋgere furi tucne hefackekomec? ");
INSERT INTO kmg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hae mâreŋge fogarezo murâ fogarezac, me qikiŋnerâ furine moneŋ rorâ izi iŋuc me iŋuc ezo murâ enšaŋ. Go weniŋuc erâ maŋgezi surucgume iŋuc emec? Go ŋic nâŋe mâcne, go Anutu eatuckekomec.” ");
INSERT INTO kmg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iŋuc mume Anania e dâŋ mana manahuc rândiŋke qarâ hâmowec. Eme hone manac embiŋ jaŋe hâhâwic sâko fua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Eme ŋicmotec domambiŋ jaŋe qâŋɋâŋ-ticne qoruczi râpâckerâ bara duckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Eme aua 3 tarame ŋonâŋ-ticne biŋe mi mamana, mâc fokac muhuc fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fisime Petorozi šiŋuc wiocnewec: “Hae mâreŋte furine ine mac hâcne warejec?” Eme eki muwec, “Ine mac sawa hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mume Petorozi šiŋuc âzâcnewec: Ŋohe wemocte Wofuŋte Mâro eatuckenicte mamanac epirec? Manakic, ŋowege duckembieŋ motâc râpeo domaŋgopieŋ, jaŋe go iŋuc jaha bacgu ra ducguniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Iŋuc mume izia kikefuŋnao rândiŋke qarâ hâmowec. Eme ŋicmotec jaŋe ficmaŋko ferâ qâŋɋâŋ-ticne honerâ bara ŋowe-ticne duckembiŋko ijaha duckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eme opâ ruac guru â ŋic gâcne biŋe-jekic manambiŋ jaŋerao hâhâwic sâko fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo jaŋe mâsi fuŋne fuŋne bocjaha ŋic jaŋerao bambiŋ. Eme Jesure kikefuŋ jaŋe taha ufuŋ maŋne moc šâŋene Salomo ira maŋ mocjaha erâ tumaŋne jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tumaŋnehapie ŋic gâcnezi araŋ bajarehuc enšaŋauc kosa mi ejare jumbieŋ. Jaŋe opâ ruac jaŋere manapie bipinehec ewec. ");
INSERT INTO kmg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Erâ ŋic â ŋokac gurune gurune miti mana šakiehuc Wofuŋtao šuhucke jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Erâ wâc âgofâc-jeŋic huc šâichec hatao fofo â kanše faio kecšiŋuc muhuc râec-jopambiŋ: Petorozi rac warec eme nâkumuc-ticnezi foninipec-jopazejec. ");
INSERT INTO kmg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Erâ Jerusalem hae rârec rârec ŋic jurambiŋ jaŋe orâŋ bârâŋ fisihuc jumbiŋ. Ehuc huchec â demoŋhecfâc-jeŋic mâmâc amec-jopa fisipie biaŋke-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Eme wiac iŋucne fuame taha bapa sâko e â qaŋeŋfâc-ticne, sadukaio ŋic hâcne, jaŋe maŋzi ruc bahuc ");
INSERT INTO kmg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aposolo mana sâqore-jarerâ rocjoparâ kâpâcwâru fic sâkoo râec-jopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Eme ira fohapie ŋafeo Wofuŋte aŋelozi motâc rojarerâ jowac-jopa hurâ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ŋoŋe taha ufuŋko ferâ ŋic sasawa juju hata kecširec biŋedâŋ jazahuc domanšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iŋuc jazame jaŋe manarâ furicte taha ufuŋko ferâ miti mumbiŋ. Ehame taha bapa sâko e â qaŋeŋfâcne jaŋe qâturerâ ŋic fekicne â Israe ŋic micne guru-jeŋic hefârec-jopapie furu fisimbiŋ. Erâ polismaî jaŋe kâpâcwâru ficko ra aposolo rocjopapie fisiniŋte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eme polismaî jaŋe ra kâpâcwâru ficko basac-joparâ risierâ mumbiŋ, ");
INSERT INTO kmg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nâŋe ra fisirâ motâc kine sanaŋne bakicne honembeneŋ, erâ soŋaŋ jaŋe motâcko domambieŋ wâc. Erâ motâc rorâ ferâ ŋic ine basac-jopambeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dâŋ i mupie ufuŋte polismaî micne â taha bapa micne jaŋe manapie quŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ehapie ŋic moczi fisirâ muwec, “Manaŋgopieŋ, kâpâcwâru ficko râec-jopambieŋ jaŋe ufuŋko ŋic miti jazahuc domaŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mume polismaî micne eki soŋaŋfâcne rocjopame ra aposolo urucko jowac-jopa warembiŋ. Ŋic jaŋe qânâzi hecjopanšipiŋte hâwic-jopame wânšâŋnehec šame kirac mi ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eme micne bapa tutumaŋko râec-jopapie domahapie taha bapa sâkozi dâŋ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nâŋe ŋic hâcne šâŋe biŋe-ticne mi mupie haŋ baocte mic muac mi eŋarembeŋ me? Eme ŋoŋe sifu dâŋ i Jerusalem haeo mocwâc muiŋneŋgopieŋ, ehuc ŋic hâcne ere kiŋ nâŋere faio râezo muŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mume Petoro â aposolo gâcne jaŋe dâŋ šiŋuc bâtikiecnembiŋ: “Ŋicdâŋ reŋkehuc Anuture dâŋ qiqikiŋ i mi fokac. ");
INSERT INTO kmg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ŋoŋe Jesu maripoŋko qarâ qâhâmopie mimiŋnefâc-nâŋec jaŋere Anutuzi bâɋâreme faharewec. ");
INSERT INTO kmg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Fahareme Anutuzi e jahacne mefâreo râerâ micne sâko â bâbâpiaŋ-nâŋec âkendâŋnewec. Eme ši Israe ŋic ŋoŋe maŋŋeŋic bârisiepie sâqocne-ŋeŋic šureocte muekac. ");
INSERT INTO kmg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eme irec biŋe hâcne Tiri Mâro â nâŋe mueŋgopeneŋ. Tiri Mâro e Anutuzi micrereŋfâc-ticne jareekac.” ");
INSERT INTO kmg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dâŋ iŋuc jazame bujeŋic henšaŋneme mana hâtâwerâ aposolo jopaniŋte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Eme tutumaŋ-jeŋicko farisaio ŋic moc ŋewec, šâŋene Gamalie, e sâcmutâc dâŋ qaqazu-jeŋic fekicne. Eki hâcne mume aposolo jaŋe hae šoŋao hurâ juhapie ");
INSERT INTO kmg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","micne bapa âgofâcne šiŋuc jazawec: “Israe ŋicbureŋ, ŋoŋe ŋic i wiac mana wosâehuc ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mârâc ŋic moc šâŋene Teuda eki, no ŋicbomboŋ micne-ŋeŋic, iŋuc mume ŋic 400 erao qohotambiŋ. Eme e jahacne šika kime ŋicfâc-ticne tâtiepie gie-jeŋic omatac fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Erâ šâhec Galilaia mâreŋko ŋic moc šâŋene Juda, e wose qâreŋ enârembiŋ dameŋ ira ŋic gâcne qafeŋ-jopame bâjâpembiŋ. Eme e jahacne qahuc ŋicfâc-ticne jopa qâtâtiec ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Irec ši dâŋ ŋazape mananiŋ: ŋoŋe ŋic ši behec-jopapie juniŋ. Jaŋe dâŋ â gie i maŋjeŋicte mu bac eeŋgopieŋko sifuckerâ arictac eocmu. ");
INSERT INTO kmg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Me Anutuzi neŋgoc ŋesiŋ ejarehame mu bac eeŋgopieŋko bâipiec-jopaniŋmu. Ŋoŋe gie-jeŋic ima bahuc Anutu e jahacne râsi ecnenšipiŋkohec.” ");
INSERT INTO kmg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iŋuc jazame jaŋe manapie sâckeme aposolo ejarepie tutumaŋko fepie kâcbiŋzi jopambiŋ. Joparâ ŋic Jesure šâŋe biŋe mi jazaniŋte muac-joparâ sorec-jopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Sorec-jopapie Wofuŋ e jaŋere maname sâckeha šâŋe-ticnere erâ šika kimbiŋte bubiaŋ manahuc ŋic tutumaŋkonec waharâ rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Erâ šoaŋne šoaŋne taha ufuŋko â ŋicficko Jesu Kristo ere Biŋebiaŋ jaza qazuc erâ mi behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dameŋ ira opâ ruac guru sâko embiŋte nânâ bârâwiŋne-jarehuc Grië opâ ruac jaŋere hozec bâtiric-jopapie Juda opâ ruac jaŋere manapie mi sâckeme dâŋ bâfuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iŋuc epie aposolo 12 jaŋe opâ ruac hetumaŋ-jopa-fârerâ šiŋuc jazambiŋ: “Nâŋe sahackopec gie i dopeckehuc Anuture dâŋ mumu irec gie behepene wahame mi sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Irec ŋic âgofâc, ŋoŋe ŋic 7 ŋaŋacne ŋondeŋko Mâro â mamanahec jupie honec-jopapie sâckeme rowosâec-jopanšepieŋ. Eme nâŋe gie i mujarepene banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nâŋe ine nunumu â miti mumu irec gie paŋšâic jaha banšepeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dâŋ iŋuc mupie opâ ruac jaŋe manapie sâcke-fârewec. Ehuc ŋic šiŋuc bâwosâec-jopambiŋ: Stefano, e maŋnao mamanasiŋ â Tiri Mâro fufusuc fowec, erâ Filipo â Porokoro â Nikano â Timoŋ â Pamena â Nikolao, e Antiokia haeonec ŋic qâpuczi Judaŋic jaŋerao šuhuckewec. ");
INSERT INTO kmg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Eme ŋic i hâcne jaŋe aposolo jaŋere maŋfuŋko birickerâ domapie mejeŋic qizec-jeŋicko râehuc numu jambuŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eme Anuture dâŋzi haŋ bahuc fome Jesure kikefuŋ jaŋerao denaŋne denaŋne šuhuckeme šuhuc erambiŋ. Erâ taha bapa jaŋeraonec wâc bocjahazi miti mana rereŋ embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano e miti â tâpiri bocjaha focnewecte ŋic jaŋerao mâsi fuŋne fuŋne bawec. ");
INSERT INTO kmg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eme Hotâonec mujarembiŋ ŋic i jaŋere mitificko tumaŋne jumbieŋ, jaŋeraonec ŋic gâcne â Kirene ŋic â Alesandria ŋic â Kilikia ŋic â Asia ŋic, iŋuczi qâturerâ Stefano mu qatarac ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eme e dâŋ mana utuckehuc Mârohec mume jaŋere dâŋzi firorieme eipiecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eipierâ ŋic qafeŋ-jopapie jaŋe Stefanore šiŋuc mumbiŋ: “Ŋic e Mose â Anutu musoriŋ-jofame manambeŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iŋuc ehuc ŋic omane â soŋaŋ â miti qaqazu mu âke ɋâfoŋ ejarembiŋ. Erâ Stefano somâckerâ hâporâ micne guru tutumaŋko barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ehuc dâŋ qanaŋ bâmockerâ âgofâc-jeŋic jarepie bajumbiŋ jaŋe ejarepie Stefanore burec ehuc šiŋuc mumbiŋ: “Ŋic e tiri ufuŋ â sâcmutâc dâŋnâŋec surehuc juekac. ");
INSERT INTO kmg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nâŋe kecšiŋuc mume manambeŋ: `Jesu Nazarete haeonec eki hâcne ufuŋ ši ima qahuc sâcmutâc dâŋ Mosezi mufua-nârewec i hetâtieocmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eme tutumaŋko ŋembiŋ ŋic i jaŋe Stefanorao firâ râqârehuc šâŋe maine honepie aŋelo hawari tinac ewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eme taha bapa sâkozi Stefano wiocnerâ muwec, “Dâŋ muŋgopieŋ i jâmbomac me?” ");
INSERT INTO kmg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mume Stefano šiŋuc muwec: “Kâcɋenefâc-nane â âgofâc-nane, dâŋ mupe mananiŋ: Mimiŋne-nâŋec Abraham e Haraŋ haeo mi rahuc Mesopotamia mâreŋko juhame Tatamac Anutuzi fuacnerâ šiŋuc âzâcnewec: ");
INSERT INTO kmg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","`Go mâreŋ qizecge â mame sâkofâcge behec-joparâ noni mâreŋ moc gowatupe ira ra juzemec. Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Eme e dâŋ i manarâ Kaldea mâreŋ-ticne beherâ Haraŋ haeo ra juwec. Ira juhame mamac-ticne hâmome Anutuzi mâreŋ ŋoŋe rauckerâ juŋgopieŋko šira hâcne jowa warewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Jowa warerâ mâreŋ mi qikiŋnecneme rauckewec, aricne, moc mi râcne huŋgaŋke-jâmbâŋkewec. E â ɋâricfâc-ticne šâhec rauckeniŋte biŋe sawa qacnewec. I ɋâric tâmiric juha sifu iŋuc mucnewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ehuc Anutuzi dâŋ moc šiŋuc muwec: `Ɋâricfâcge jaŋe jara 400 mâreŋ furune mocko jaba juhuc kiŋaŋ qaqa erâ sisi hâhâŋ faio junšoŋgopieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Erâ dâŋ moc šiŋuc šuhuckerâ muwec: `Kiŋaŋ qaqafâc-jeŋic bacjopaniŋmu ŋic i okacne jarepe ɋâricfâcge ŋec-jopapie mâreŋ kecšira warerâ no kiŋaŋ qanarehuc junšoŋgopieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eme Abraham e ɋâricfâc-ticne ere biŋe qacjopahuc sahac-jeŋicko ma baocte mucnewecte ŋokâ-ticne Isaka fuarâ fohame šoaŋ gie bapa 8 eme iŋuc hâcne ecnewec. Eme Isakazi Jakobo bâfuawec, â Jakobozi mimiŋnefâc-nâŋec 12 bâfuac-jopawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Eme mimiŋnefâc-nâŋec jaŋe ɋajeŋic Josefe iiŋguuŋ ecneku moneŋte qikiŋnepie Aigita mâreŋko barambiŋ. Ira ra juhame Anutuzi ehec juhuc ");
INSERT INTO kmg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","šârâ hâriŋ faionec batararâ jauŋ â miti tahackecneme Aigita ŋicwofuŋ Farao eki hone biaŋkerâ e jahacne fic hae â Aigita ŋicfâc-ticne mâmâc soŋaŋ-jopahuc juocte ŋicbomboŋ sâko âkendâŋnewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Âkendâŋneme juhame roroc fuarâ Aigita â Kanaaŋ mâreŋko qarâ suriŋkerâ fome hae mâreŋ hâŋkewec. Eme mimiŋnefâc-nâŋec jaŋe nânâre hâmohuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Eku Jakobo e, Aigita mâreŋko nânâ fokac, iŋuc mupie manarâ ŋokâfâcne sorec-jopame ira rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Eme harierâ mocwâc rapie Josefezi hahacfâc-ticne fuŋne-ticne mutaniŋke-jareme Faraozi fufua-ticnere fuŋne wâc manawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eme Josefezi mume mamac-ticne Jakobo â wiacfâc-ticne sasawa, ŋic ŋokac 75, amec-jopa rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eme Jakobo e Aigita mâreŋko rarâ juku hâmowec â ŋokâfâc-ticne mimiŋnefâc-nâŋec jaŋe iŋuc jaha hâmo-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hâmopie qâŋɋâŋfâc-jeŋic Sikemko bacjopa warerâ, Abrahamzi Sikem haeo Hamorore ɋâricfâc jaŋeraonec mâreŋ moc šâŋeruŋte biŋe moneŋzi furine bawec, ira ducjopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Eme Anutuzi Abraham dâŋbiŋe qacnewec i sanaŋkeocte dameŋ bembeŋkezo ehame jaŋe Aigita mâreŋko mâretec sawe mâririackembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iŋuc ehuc juhapie Aigita ŋicwofuŋ furune moc fuawec eki Josefe kâuc bawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eme ŋicwofuŋ eki hâcne mimiŋnefâc-nâŋec doc bacjopahuc sipiric-jopawec. Ehuc mume ɋâricfâc-jeŋic behec-jopapie hâmocko rafârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dameŋ ira hâcne Mose fuawec. Motec e Anutuzi honeme biaŋne jâmbâŋ ewec. Eme mamac-ticnere ficko soŋsoŋ barâ juhapie mosa jahec â moc ewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eku behepie Farao otâ-ticnezi bâfuarâ motec bawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eme Farao ŋicfâc-ticne jaŋe Aigita ŋic jaŋere mamana sasawa qazucnepie mana sanaŋkerâ wiac mume bame bipinehec ewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Juku jara-ticne 40 bazurâ Israe ŋic âgofâc-ticne hone manac ejareocte maŋne afeckeme rawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Rarâ Aigita ŋic moczi Israe ŋic moc qame honerâ âgo-ticne ŋezickehuc Aigita ŋic hâmocne qawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ehuc muwec, no âgofâc-nane Faraore meonec batarac-jopapemurâ Anutuzi gie bakac i mana taraniŋmu. Eme jaŋe ine mi mana tarambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Eme hae fureme mocwâc rarâ Israe ŋic jajahec qaqac ehapire bâfuac-jofarâ mu bârâwiŋ ejactehuc šiŋuc jasawec: `Ŋic jahec, ŋohe ââgozi wemocte rârâsi ekopirec? Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mume ŋic šika fuŋkerâ âgone qaweczi dâŋ šiŋuc bâtikiecnewec: `Go nâhere kia me soŋaŋ mozi râecguwec? ");
INSERT INTO kmg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Jacne Aigita ŋic qamec iŋuc jaha no nuzo mukic me? Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eme Mose e dâŋ i manarâ izia wiserâ ra Midiaŋ mâreŋko ŋic furune jaŋere ŋondeŋko juwec. Erâ ŋokac bame ŋokâ jajahec fuacnepic. ");
INSERT INTO kmg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Eme jara 40 mocwâc juku ra mâreŋ burocnao Sinai tikifuŋko juhame aŋelo moczi jâc dutunao šocbâruŋ maŋko fuacnewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Eme Mose e wemo wiaczi weniŋuc ekac muhuc hone-hâmoocte rame Wofuŋte dâŋ šiŋuc fuawec: ");
INSERT INTO kmg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","`No mimiŋnefâcge jaŋere Anutu, Abraham â Isaka â Jakobo jaŋere Anutu hâcne. Eme Mose e ɋarac ɋarac qahuc dunduŋ dadape domawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Domame Wofuŋzi šiŋuc âzâcnewec: `Mâreŋ âtekomec i tiri mâreŋ, irec kikehuhuge heunuckec. ");
INSERT INTO kmg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ŋicfâc-nane Aigita mâreŋko fific guguriŋ ejarepie kio wâwâsic epie mana wefukupe tarakac. Eme ši batarac-jopapemurâ wahakopac hâcne. Irec go Aigita mâreŋko sorecgupe razemec.' ");
INSERT INTO kmg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ŋic jaŋe Mose qikiŋnehuc šiŋuc âzâcnembiŋ: `Go mozi kia me soŋaŋ-nâŋec râecguwec? Ž Eme Anutuzi ŋic e hâcne micne bapa â babatara-jeŋic eocte muhuc aŋelo-ticne ecneme šocbâruŋ maŋko fuacnerâ gie i mucnewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ehuc soreme ra jowac-jopa warewec. Iŋuc ehuc Aigita mâreŋko â Hâwec Bâbâroŋko â mâreŋ tuhuo mâsi fuŋne fuŋne bahuc juhame jara 40 ewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Erâ Mose ekizia wâc Israe ŋic šiŋuc jazawec: `Anutu e âgofâc-ŋeŋic jaŋere ŋondeŋkonec porofete moc no iŋucne bâfua-ŋareocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Iŋuc muwec. Erâ ekizia wâc mâreŋ burocnao mimiŋnefâc-nâŋec hombaŋ tutumaŋ-jeŋicko juhuc Sinai tikio aŋelo mickonec fofo sanaŋ dâŋ manarâ jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mimiŋnefâc-nâŋec jaŋe ine dâŋticne beherâ e jahacne bâsuerâ Aigita mâreŋko risieniŋte maŋjeŋic domame ");
INSERT INTO kmg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aroŋ šiŋuc âzâcnembiŋ: `Go ɋâŋ qâqâtâc moc banâretec izi bânie-nâreme risienšepeneŋ. Mose Aigita mâreŋkonec jowac-nâpo warewec e sifucke wiac moc ewec mecne. Ž ");
INSERT INTO kmg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iŋuc murâ bulimakao qâqâtâc barâ bâzi rikecnehuc, mejeŋiczi bambiŋ wiac i mu šeri ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","I epie Anutuzi behec-jopame maŋjeŋic sifuckeme mosa bâpiŋ jaŋerao siŋkembiŋ. Eme irec hâcne porofete jaŋere papiao dâŋ šiŋuc fokac: `Israe rune ŋoŋe jara 40 mâreŋ burocnao juhuc qowi bâzi me bâzi gâcne moc rike-narembiŋ me? ");
INSERT INTO kmg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ŋoŋe Molokore qoruc boze reŋke jumbieŋ â nemu Refaŋ ere bâpiŋ hawari bajumbiŋ. Wiac i hâcne numucneniŋte ba akic embiŋ. Irec no Babe ocniŋucnao râec-ŋopapemu.' ");
INSERT INTO kmg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Mimiŋnefâc-nâŋec jaŋe mâreŋ tuhuo miti qoruc boze ŋejarewec i Anutuzi Mose hawarine jâutuhuc mutâcnecnewec sâc bakicne. ");
INSERT INTO kmg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eme boze i hâcne mimiŋnefâc-nâŋec jaŋe tuczi tuc bawareku Josuazi micne bajareme šira qâpuc jaŋere mâreŋko bafisimbiŋ. Bafisipie Anutuzi ŋic qâpuc jopa jâpec ejareme mimiŋnefâc-nâŋec jaŋe mâreŋ rauckerâ miti boze-jeŋic ijaha wâc bapie ŋejarehame Dawidi fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Erâ Dawidi e Jakobore Anutu ere jauŋzi erao fome manahuc ufuŋ bacneocte âzâcnewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Erâ e jahac mâcne, Salomozi Wofuŋ ufuŋ bacnewec. ");
INSERT INTO kmg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Femicne sâko e ine ufuŋ ŋicmezi bakicne ira ŋeŋe juju mi eekac. Porofete micko dâŋ šiŋuc hâcne fuakac: ");
INSERT INTO kmg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","`Sambâŋzi ŋeŋe-nane â mâreŋzi kike ââtesiŋ-nane. Wofuŋzi mukac, fic weniŋucne moc banarepie sâckeocmu. me ŋeŋe fofo weniŋucne moc bâfua-narepie sâcnuocmu? ");
INSERT INTO kmg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","No menanezi wiac sasawa i mi bâfua-fârepo me?' ");
INSERT INTO kmg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Râŋgeŋ qaŋqaŋne ŋoŋe, maŋ hazec-ŋeŋic mi uŋtokicne, mimiŋnefâc-ŋeŋic ejumbieŋ iŋuc jaha ŋoŋe ehuc Tiri Mâro jâpe hetapaic ecnehuc jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mimiŋnefâc-ŋeŋic jaŋe mo porofete mo akickembiŋ me? Aricne, tiŋne rune fuaocte findaŋdâŋ mumbiŋ ŋic i jaŋe wâc mâmâc jopambiŋ. Juku e jahacne doc bahuc qaqa, ine ŋoŋe hâcne embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sâcmutâc daŋŋeŋic aŋelo miczi mukicne i ŋoŋe sifu qâsuambiŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stefanozi dâŋ iŋuc jazame bujeŋic šâšâficne qame aaric sâko manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stefano ine Tiri Mârozi maŋnao fusucmame sambâŋko fime feme Anuture tatamacko Jesu Anutu mefârenao domame honehuc muwec, ");
INSERT INTO kmg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Manaŋgopieŋ, no sambâŋ aŋkeme Ŋic Fâri Wâtuŋne Anutu mefârenao domame honekopac `à ");
INSERT INTO kmg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Iŋuc mume dâŋ ojowa sâko hâsockecnehuc hazecjeŋic bâbâzickerâ izia mâmâc sâko ɋuruŋ herâ hâpo rârierâ tuŋke tuŋke raku ");
INSERT INTO kmg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","hae râpeo fisirâ qânâzi,hembiŋ. Ehuc soŋaŋ jaŋe ŋaqi-jeŋic šoricne hetararâ ŋicmotec moc šâŋene Saulo ere kikefuŋko guruckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Erâ Stefano qânâzi hepie nunumu dâŋ kecšiŋuc muwec: “O Wofuŋ Jesu, go maŋ qâqâtâc-nane roc.” ");
INSERT INTO kmg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Iŋuc murâ dieŋzi herâ mocwâc wiwic jaha muwec, “Wofuŋ go kiŋ kecši behe-jarezemec.” Iŋuc murâ hâmowec. Qapie hâmome Saulozi maname sâckewec. ");
INSERT INTO kmg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Eme dameŋ ijaha Jerusalem haeonec opâ ruac kikefuŋ râsi sâko fuŋke-jarembiŋ. Ejarepie wiserâ râwiŋ qâwiŋ erâ Judaia â Samaria mâreŋko rafârembiŋ. Aposolo jaŋe sawa getâc-jopapie jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Eme ŋic mitine gâcne jaŋe Stefano duckerâ kio mamakuc ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo eki ine opâ ruac ima bacjoparâ ficne ficne ferâ ro fârec ejarehuc kâpâcwâru ficko râec-jopahuc domawec. ");
INSERT INTO kmg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Opâ ruac bâtâtiec-jopakicne jaŋe ine hae sâc juhuc ŋic miti jaza rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Eku Filipozi Samaria ŋic jaŋere hae qizecko fisirâ Kristore biŋedâŋ jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jazame ŋic guru sâko jaŋe dâŋticnere ejareme mana aŋac embiŋ. Ehuc mâsi fuŋne fuŋne bame honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","E demoŋ bocjaha jâpe-jareme ŋicmaŋkonec wefurâ owackehuc wisembiŋ. Erâ wâc šeke puriŋ â kike demba bocjaha sahac ɋiɋic bacjopawec. ");
INSERT INTO kmg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eme irec hae ira šeri kâcɋene fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eme hae ijaha qaŋgec bapa moc juwec, šâŋene Simoŋ. E jahacnere no ŋic fekicne muhuc qaŋgec gie bame Samaria ŋicguru jaŋe honepie bipinehec ewec. ");
INSERT INTO kmg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ehuc fekicne wahakicne jaŋe ere manapie fefene eme šiŋuc mujumbieŋ: “Ŋic kecšizi Anuture tâpiri, Sokawec Sâko mucnekicne, irec hozine hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eme qaŋgec-ticnezi maŋ bâsifuc ejarewecte dameŋ šora erao qohotahuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Juhapie Filipozi Anuture uucmaŋte Biŋebiaŋ â Jesu Kristore dâŋ binaŋ Jazame mana šakierâ ŋic â ŋokac mâmâc Miti Opâ ruambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Iŋuc epie Simoŋ e iŋuc jaha miti mana šakierâ opâ ruarâ Filipore maŋfuŋko juwec, ehuc mâsi fuŋne fuŋne bame hone warec mâretec ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eme Samaria ŋicguru jaŋe Anuture dâŋ ro maŋ epie irec biŋe Jerusalem haeo aposolo jaŋerao rame manambiŋ. Ehuc Petoro â Johane sorec-jofapie rapic. ");
INSERT INTO kmg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ra fisirâ jaŋe Tiri Mârohec eniŋte Wofuŋ numucnepic. ");
INSERT INTO kmg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Juwicnao Tiri Mârozi jaŋerao mi wahawec, jaŋe mâc Jesure šâŋeo šuhuckehuc Miti Opâ sawa ruambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eme aposolo jahe mejekic qizec-jeŋicko râepire jaŋe Tiri Mârohec embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposolo jahe ŋic jaŋere qizec faio mejekic râepire Tiri Mârohec epie Simoŋzi honerâ jaherao moneŋ amecke fisirâ ");
INSERT INTO kmg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","šiŋuc jasawec: “Ŋohe tâpiri i no iŋuc jaha narepire ŋic mocte qizecko menane râepe Tiri Mârohec ezejec.” ");
INSERT INTO kmg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mume Petorozi šiŋuc âzâcnewec: “Go Anuture jauŋ moneŋzi furine bazo mukomecte moneŋgezi gohec mâmâc sisipiricko razac me¡ ");
INSERT INTO kmg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Anutuzi maŋsiocge honekacte tâpiri šizi moc mi hehuŋgaŋguhame mâc jâmbâŋ jucmu. ");
INSERT INTO kmg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Go bâbâsifucge qikiŋnehuc maŋge bârisierâ Wofuŋ numucnetec maŋgao andac sâko bâtâmire-garezejec. ");
INSERT INTO kmg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Go sâqocne hâtânezi hariŋguekac hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Eme Simoŋzi šiŋuc muwec: “Ŋohe ŋahac nore erâ Wofuŋ numucnepire akicnuha wiac mukopirec i mi fua-narezejec.” ");
INSERT INTO kmg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Eme aposolo jahe ŋic ŋokac Wofuŋte dâŋ jaza sanaŋkerâ Jerusalem haeo risiepic. Risiehuc Samaria hae bocjaha Biŋebiaŋ jaza jaza rapic. ");
INSERT INTO kmg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wofuŋte aŋelo moczi Filipo šiŋuc muhuc âzâcnewec: “Go šawierâ juwickopec, Jerusalem haeonec Gaza haeo hueŋgopieŋ hata ira razemec.” Hata i mâreŋ tuhuo fokac. ");
INSERT INTO kmg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Iŋuc muhuc âzâcneme Filipozi šawierâ rawec. Eme Etiopia mâreŋko ŋokac wofuŋ juwec, šâŋene Kandake, ere ŋicbomboŋ â moneŋ mafa soŋaŋ sâko eki Jerusalem haeo Anutu mai ecneocte rafeweckonec ");
INSERT INTO kmg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","risieocte keretacko rahuc porofete Jesaja ere dâŋqâreŋ wosewec. ");
INSERT INTO kmg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iŋuc ehame Mârozi Filipo šiŋuc âzâcnewec: “Ajoc, go ra keretac kecocni bâfuac.” ");
INSERT INTO kmg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mume Filipozi ra bâfuarâ ŋic e porofete Jesaja ere dâŋqâreŋ wosehame manarâ wiocnewec, “Dâŋ wosekomec irec fuŋne manakic me?” ");
INSERT INTO kmg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Eme eki muwec, “Moczi mi nazahame nahackoaŋ wemocko sâcne manapemu?” Iŋuc murâ Filipo âzâcneme keretacko ferâ qâteme ŋepic. ");
INSERT INTO kmg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Dâŋqâreŋ wosewec ine kecšiŋuc: “Lama moc qa hezuc eniŋte baraeŋgopieŋ, me kanšaŋ bâbâtâc ŋic erao fâsâerâ foekac, iŋuc hâcne micticne moc mi aŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bâpitiwambiŋko kiŋ babatara i erao tarawec. Á mâreŋko juju-ticne qâriuŋkewecte qaŋeŋfâcne mozi wose manac ejare-fâreocmu?” ");
INSERT INTO kmg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eme ŋicbomboŋ e Filipo šiŋuc muhuc wiocnewec: “Go mutec manape, porofete e more iŋuc mukac, e jahacnere me ŋic mocte? ");
INSERT INTO kmg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eme Filipo e porofetere dâŋko iticnehuc Jesure Biŋebiaŋ âzâcnewec. ");
INSERT INTO kmg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iŋuc ehuc raku opâo fisipic. Eme ŋicbomboŋzi muwec, “Honec, opâ fokac ši” Miti Opâre mupe sâcne rua-narecmu me?”  ");
INSERT INTO kmg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Eme Filipozi muwec, “Dâŋ gazapac i maŋ hâcbuc mana šakiekomecko sâcne eene.” Eme dâŋ šiŋuc bâtikiecnewec: “Jesu Kristo e Anuture Ŋokâ i mana šakiekopac.”Ý ");
INSERT INTO kmg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iŋuc murâ keretac bâniniŋkerâ Filipo â ŋicbomboŋ opâo hupic. Hurâ Filipozi ruacnewec. ");
INSERT INTO kmg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eme opâonec wefupire Wofuŋte Mârozi Filipo jowa rame ŋicbomboŋzi mocwâc mi honehuc bubiaŋko hata-ticnao rawec. ");
INSERT INTO kmg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo eki ine Asidode haeo fisime honembiŋ. Erâ irecnec fuŋkerâ haene haene miti jaza raku Kaisarea hae bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo e Wofuŋte kikefuŋ râsi ejarehuc ima bacjopaocte maŋšoc-ticne gâmâc gâfâŋ wefuhuc domawec. Ehuc ra taha bapa sâkorao mume ");
INSERT INTO kmg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damasko haeo Judaŋic jumbiŋ jaŋere papia qâreŋkerâ râcnewec. Râcneme rorâ ocna hata ɋârio moc jupie bâfuac-joparâ ŋic mecne ŋokac mecne mejeŋic qarâ Jerusalem haeo bacjopa wareocte rawec. ");
INSERT INTO kmg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Izi raku Damasko hae bâqiŋkezo ehame sambâŋkonec šoc tatamaczi uŋ herâ waha âeckewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Âeckeme mâreŋko rândiŋke qarâ fohuc dâŋ moc šiŋuc manawec: “Saulo, Saulo, go wemocte nu jâpec enarehuc juekic?” ");
INSERT INTO kmg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mume Saulozi wiohuc muwec, “Wofuŋ go mo?” Eme muwec, “Nu jâpec enarehuc juekic Jesu no hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Go faharerâ haeo ratec ira wiac ecmurâ dâŋne gazaniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Eme ŋic ehec jumbiŋ jaŋe dâŋwe tâmiric mâc fâsâerâ domambiŋ, jaŋe dâŋ sawa manambiŋ, â ŋic ine moc mi honembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Eme Saulo e faharerâ šâŋe fiocte fi qeruruc ewec. Iŋuc eme ŋicfâcne jaŋe menao rorâ Damasko haeo barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Eme ira šoaŋ gie bapa jahec â moc tiŋtuŋ jaha fohuc nânâ opâ mi nâwec. ");
INSERT INTO kmg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasko haeo Jesure qâjâpec moc juwec, šâŋene Anania, e Wofuŋzi maŋko fuac ecnehuc wiracnewec, “Anania.” Eme muwec, “Wofuŋ no ši.” ");
INSERT INTO kmg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mume Wofuŋzi šuhuckerâ šiŋuc muwec: “Go hata šâŋene Dândâŋne mueŋgopieŋ ira rarâ Judare ficko ferâ ŋic moc šâŋene Saulo, Taso haeonec, e bâfuazemec. Manakic, e numu-narehuc fokac. ");
INSERT INTO kmg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Erâ maŋticnezi wiac šiŋuc honejec: Ŋic moc šâŋene Anania erao fisirâ šâŋe fifihec eocte mene qizecnao râejec.” ");
INSERT INTO kmg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wofuŋ e dâŋ iŋuc muhuc âzâcneme Ananiazi šiŋuc muwec: “Wofuŋ, ŋic ere mâretec mupie manaekopac, e fuŋfuŋfâcge Jerusalem haeo ba imac wemo afecne ejareekac. ");
INSERT INTO kmg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Erâ šira iŋuc jaha šâŋege riwaseckeeŋgopeneŋ nâŋe repac-nâporâ bacnâpo raocte taha bapa micne jaŋe mucnembiŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mume Wofuŋzi šiŋuc âzâcnewec: “Go sifu rac, ŋic e mefâro-nane, eki hâcne šâŋe biŋe-nane ŋic qâpuc â ŋicwofuŋ â Israe guru jaŋerao barahuc juzejec. ");
INSERT INTO kmg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iŋuc ehame no šâŋe biŋe-nanere erâ šârâ hâriŋ faio juocte qazucnepemu.” ");
INSERT INTO kmg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Eme Anania e rarâ fic mukicne ira ferâ Saulore qizecko meticne râehuc muwec, “Saulo qomâ-nane, Wofuŋ Jesu hatao fua-garewec, eki hâcne sorecnume warekopac, go šâŋe fifi ehuc Tiri Mârohec ecmurâ mukac.” ");
INSERT INTO kmg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Iŋuc muhuc âzâcneme izia šâŋenaonec wiac gagara tinac wahame šâŋe fifi erâ faharerâ mume Miti Opâ ruacnewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ehame nânâ nârâ sanaŋkewec. Saulo e Jesure kikefuŋ Damasko haeo jumbiŋ jaŋehec piticne jurâ ");
INSERT INTO kmg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","izia biac Judaŋic jaŋere mitificko ferâ Jesure biŋe muropiehuc kecšiŋuc jazawec: “Jesu e Anuture Ŋokâ.” ");
INSERT INTO kmg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iŋuc jazame manarâ quŋkecnehuc šiŋuc mumbiŋ: “Jerusalem haeo šâŋe i hâcne riwaseckepie ima bacjopaku šira iŋuc jaha repac-joparâ taha bapa micne jaŋerao bacjopa raocte warewec, izi weniŋuc erâ hec hetikic ekac?” ");
INSERT INTO kmg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eme Saulo e samandiŋkerâ, Jesu e Kristo jâmbâŋ, irec dâŋfuŋne muritu-hâmohuc Damasko haeo Judaŋic jumbiŋ jazame manapie guguru ewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Iŋuc eku Judaŋic jaŋe Saulo qaniŋte mumockembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mumockepie Saulozi biŋe manarâ juhame jaŋe qaniŋte haesac motâcko ŋafe furec soŋsoŋ domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iŋuc epie Jesure qâjâpecfâc jaŋe ŋafeo sasacko ŋiherâ sacrâpeo âke suepie hurâ wisewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Eme raku Jerusalem haeo fisirâ Jesure kikefuŋ jaŋerao šuhuckeocte mume araŋ bacnembiŋ. Ehuc e Jesure motec ewec i manapie Jâmbomac mi ewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Eme Banabazi âgo ecnehuc aposolo jaŋerao jowa rarâ, Wofuŋzi Saulo hatao fuacnerâ dâŋ âzâcneme Damasko haeo Jesure biŋe mutaniŋkewec, irec dâŋ binaŋ ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eme jaŋehec Jerusalem haeo ŋeŋe juju ewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ehuc Wofuŋte šâŋeo âtesiŋnehuc ŋic miti acmeruŋ tâmiric jazawec. Eme Judaŋiczi Grikdâŋ mumu jaŋehec wâc mitire muc manac ehuc dâŋ bâbârisiec embiŋ. Eme ŋic i jaŋe hâcne qazo mupie ");
INSERT INTO kmg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","âgofâcne jaŋe manarâ Kaisarea haeo jowa hurâ ŋepie raku Taso haeo fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Eme opâ ruac kikefuŋ Judaia â Galilaia â Samaria mâreŋko jurambiŋ jaŋerao wama fuawec. Wamao juhuc hehešakiec erâ qaboc-jeŋic qapie hume Wofuŋte maio rumehuc jumbiŋ. Ehuc Tiri Mârozi neŋgoc ŋesiŋ ŋejarehame miti soka ŋedâmârec eme guru-jeŋic ɋâriŋ qawec. ");
INSERT INTO kmg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petoro e hata juku Jesure fuŋfuŋfâc Lida haeo jumbiŋ jaŋerao wâc fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Erâ ira ŋic moc honewec, šâŋene Ainea, e puriŋ erâ fohuc juha jara 8 ewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Eme Petorozi šiŋuc âzâcnewec: “Ainea, Jesu Kristozi ɋiɋicne bacgukacte faharerâ fofoge gahac bâpiaŋkec.” Mume izia faharewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iŋuc eme Lida â Saroŋ heaoneczi honerâ maŋjeŋic bârisierâ Wofuŋte kikefuŋ embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope haeo opâ ruac naru ŋokac moc juwec, šâŋene Tabita, Kâtedâŋko Sâec. E gâcne ehâmo-jarehuc bâmec bocjaha bajarehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eme Petoro mâreŋ ira juhame Tabita e huc fuacneme hâmowec. Hâmome qâŋɋâŋ-ticne šurerâ ficmaŋne mocko baferâ râembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida i Jope hae bembeŋko ŋewecte opâ ruac jaŋe Petorore biŋe manarâ ŋic jajahec erao sorec-jofapie rarâ šiŋuc âzâcnepic: “Go jowacgupere nâŋere haeo biac ranaŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eme Petoro e manarâ šawieme jahehec rambiŋ. Ra fisime qâŋɋâŋ fowecko jowa fembiŋ. Feme ŋokac hozec sasawa jaŋe e orâŋkerâ ki busâqoc ehuc Tabita ɋâricne juhuc ŋaqi ɋâtâ-jarewec i jâutu-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Eme Petorozi ejareme hufârepie dieŋzi herâ numuwec. Numu tararâ qâŋɋâŋ maickeme šiŋuc âzâcnewec: “Tabita go faharec.” Mume šâŋe fitâcnehuc Petoro honerâ fahare ŋewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ŋehame Petorozi menao rohuc âzâcneme fahare domawec. Eme opâ ruac â hozec wira-jareme fepie Tabita ɋâricne bârisie-jarewec. ");
INSERT INTO kmg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Eme irec biŋe Jope haeo haŋ bame bocjahazi Wofuŋtao qohotambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Eme Petoro e ŋic moc šâŋene Simoŋ, becsahac bapa, ere ficko dameŋ šošoricne ŋeŋe juju ewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisarea haeo ŋic moc juwec, šâŋene Konelio, e Italia mâreŋkonec momori jaŋere soŋaŋ juwec. ");
INSERT INTO kmg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Erâ e jahacne â wiacfâc-ticne jaŋe Anutu araŋ bacnehuc rumerâ jujumbieŋ. Ehuc ŋic ŋokac bâmec bocjaha bajarewec, erâ Anuturao gâbâ numu jujec. ");
INSERT INTO kmg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Konelio e iŋuc ekume šoaŋ mocko owâ gieo Anuture aŋelo moczi maŋko fuac ecneme honeha šâŋene wiracnehuc muwec: “Konelio.” ");
INSERT INTO kmg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wiracneme hone dendeŋnehuc fâfârerâ muwec, “Wofuŋ, wemo wiacte?” Eme eki muwec, “Nunumu â bâmecge Anuturao hefâme mana biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Irec go Jope haeo kiŋaŋ sorec-jopatec ra ŋic moc šâŋene Simoŋ, šâŋe-ticne moc Petoro, jowa warenšepieŋ, ");
INSERT INTO kmg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","e wase-ticne Simoŋ, becsahac bapa, ere ficko ŋeŋe juju ekac” fic i hâwecmecko ŋekac.” ");
INSERT INTO kmg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aŋelo e dâŋ i âzâcnerâ rame kiŋaŋ motec jajahec â momorifâc-ticne jaŋeraonec mitine moc hefârec-joparâ ");
INSERT INTO kmg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","dâŋ binaŋ jaza-fârerâ Jope haeo sorec-jopame rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ŋic jaŋe raku hatao fombiŋ. Hae fureme mocwâc raku hae bâmbeŋkezo ehapie šoaŋ šâšâŋiŋko Petorozi numuocte fic maŋne mocko fewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Numuku nânâre hâmorâ mume rike bâmoc ecnehapie Wofuŋzi maŋko fuac ecneme wiac šiŋuc honewec: ");
INSERT INTO kmg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Sambâŋ aŋkeme wiac moc racsâko tinac tofane 4 ira basanaŋkehuc mâreŋko âkesuepie wahawec. ");
INSERT INTO kmg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Maŋnao qowi â homa wiac â wipe fuŋne fuŋne fowec. ");
INSERT INTO kmg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ehame dâŋ moc šiŋuc fuawec: “Ajoc Petoro, hezu nâc ec.” ");
INSERT INTO kmg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Eme Petorozi muwec, “Wofuŋ, misac, no wiac hecke-nârekicne â mamakâcne moc mi nâekopac.” ");
INSERT INTO kmg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mume dâŋ harierâ šiŋuc fuawec: “Anutuzi mušurekac i goki mi surec.” ");
INSERT INTO kmg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Wiac i fuame jahec â moc eme izia racnehec fârepie sambâŋko risie fewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Eme Petoro e wiac šâŋe furu honewec irec maŋ kukumbuc ecnehame Konelio ŋicfâc-ticne jaŋe haeo fisirâ Simoŋ ficticnere wio wio raku bâfuarâ motâcko domahuc ");
INSERT INTO kmg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","wiracne basac ehuc mumbiŋ, “Simoŋ, šâŋene moc Petoro, e fic šira jukac me?” ");
INSERT INTO kmg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Eme Petoro e wiac šâŋe furu-ticnere manatâc qâtâc ehuc jaha juhame Mârozi šiŋuc âzâcnewec: “Manakic, ŋic jahec â moc fisirâ go basacguŋgopieŋ, ");
INSERT INTO kmg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","irec go hurâ jaŋehec racmurâ maŋ bahac mi ezemec, ŋic i noni mupe warembieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Eme Petorozi jaŋerao hurâ muwec, “Basacnuŋgopieŋ no hâcne ši, wemo wiacte wareŋgopieŋ?” ");
INSERT INTO kmg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mume ŋic jaŋe šiŋuc âzâcnembiŋ: “Momori soŋaŋ Konelio, e Anutu araŋ bacnehuc tiŋne juekac, â Judaŋic jaŋe ere manapie sâckeekac, e hâcne tiri aŋelo moczi fuacnerâ go ficticnao hefârecgurâ micgaonec dâŋ manaocte âzâcnewec.” ");
INSERT INTO kmg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iŋuc mupie Petorozi hezu hewâneŋ ejarewec. Fohapie hae fureme e â Jope haeonec opâ ruac gâcne mâmâc ŋic jaŋehec rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jaŋe hatao ŋafe moc forâ raku Kaisarea haeo fisimbiŋ. Konelio e wiacfâcne â âgo qomâfâc-ticne hetumaŋ-jopame woŋec juhapie fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Fisirâ Petorozi ficko fezo ehame Koneliozi ware maŋfuŋnao fodaperâ muac baafec ecnewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ecneme Petorozi ro bafaharehuc šiŋuc âzâcnewec: “Faharec, no ŋic jaha wâc.” ");
INSERT INTO kmg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eme muc manac ehuc ficmaŋko ferâ ŋic tumaŋnerâ ŋepie honec-joparâ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“Ŋoŋe Judaŋic nâŋere fuŋne manaŋgopieŋ, nâŋe ŋic furune ŋoŋehec ââgo â iiqic mi enaŋte aka henârekicne. No ine ŋoŋe wâwânâŋhec â hone suŋgiŋne mi muŋarepemurâ Anutuzi fuŋne naza nowatuc ewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Irec hâcne hefârecnupie warepemurâ mi quŋkepo. Eme ši hefârecnumbiŋ irec mupie manape.” ");
INSERT INTO kmg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Iŋuc mume Koneliozi šiŋuc âzâcnewec: “No wiac šâŋe furu honerâ juwarehape miŋecgac šoaŋ gie bapa jahec â jahec ekac irec dâŋ binaŋ egarepe. No owâ gieo numuhape ŋic moc ŋaqi-ticne tatamacnehec norao fuarâ ");
INSERT INTO kmg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","šiŋuc nazawec: Konelio, Anutuzi nunumuge manarâ bâmecgere mana biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Irec go Jope haeo ŋic sorec-jopatec Simoŋ, šâŋe-ticne moc Petoro, jowa warenšepieŋ. Eki wase-ticne Simoŋ, becsahac bapa, ere ficko ŋeŋe juju ekac” ficticne hâwecmecko ŋekac. ");
INSERT INTO kmg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eme no irec hâcne ŋic sorec-jopape gorao fâmbiŋ. Eme go dâŋnane manarâ warekicte bunane biaŋkekac. Eme ši Wofuŋzi dâŋ gazawec i mutec mananaŋte Anuture maio tumaŋnerâ ŋefâreŋgopeneŋ hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Eme Petoro e micafec erâ šiŋuc jazawec: “Anutu e ŋic nâŋâcne sahac-nâŋeckopec maname feriŋ wahariŋ mi eekac i mana-jâmbâŋkekopac ši. ");
INSERT INTO kmg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ŋic gurune gurune jaŋeraonec gâcnezi e araŋ bacnehuc aimuŋ jupie jaŋere maname mitio rorocjopane eekac. ");
INSERT INTO kmg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Anutu e Israe ŋic nâŋerao dâŋ fârine bâfuawec, irec biŋe ŋoŋe manaeŋgopieŋ” e Jesu Kristo, ŋic sasawa nâŋâcne Wofuŋ hâcne, soreme wamadâŋ biaŋ nâzâ-fârewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Erâ Judaia mâreŋko wiac fuawec, irec biŋe wâc šiŋuc manaeŋgopieŋ: Johane e ŋic Miti Opâre dâŋ jazahame gie qanaŋ Galilaia mâreŋkonec domarâ rawec” ");
INSERT INTO kmg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jesu Nazarete haeonec e ine Anutuzi tâpiri â Tiri Mâro tahackecneme mâreŋ rârecke rac warec ehuc ŋic jauŋ bacjopawec â Sataŋzi bâumbeŋ-jopawec jaŋe bâpiaŋ-jopa-fârewec. Anutuzi dopeckehame gie i hâcne bawec. ");
INSERT INTO kmg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Eme Judaŋic nâŋere mâreŋko â Jerusalem haeo wiac muwec bawec i nâŋe hone manac efârembeŋ. Ehame juku maripoŋko qapie hâmowec. ");
INSERT INTO kmg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Hâmorâ fohame šoaŋ jahec â moc eme Anutuzi bâɋârewec. Bâɋârerâ râeme fua sipuac ewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Erâ ŋic kosa jaŋerao mâcne, ŋic biŋe mumufâc-ticne, Anutuzi mârâc rowosâec-nâpowec, nâŋerao sawa fuawec. Nâŋe hâcne hâmockonec fahareme ehec nâ gugumec â mumac qamanac embeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Erâ Anutuzi e ŋic ɋâricne â hâmokicne mumutara-nâŋec âkendâŋnewec, irec biŋedâŋ ŋic guru sâc mutaniŋkerâ jazanaŋte munârewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Eme e manasiŋkeniŋmu jaŋe šâŋe biŋe-ticnere erâ sâqocne tâmire-jareocmu, i porofete jaŋe mufua-fârembiŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petoro e dâŋ iŋuc muhuc domahame, manahuc ŋembiŋ jaŋerao Tiri Mâro wahawec. ");
INSERT INTO kmg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Eme Judaŋiczi opâ ruac, Petorohec rambiŋ, jaŋe Anutuzi ŋic qâpuc Tiri Mâro tahacke-jareme bipic tatara ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ŋic qâpuc jaŋe dâŋmarac furune dâŋehuc Anutu musokapie manambiŋ hâcne. Eme Petorozi šiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nâŋâc Tiri Mârohec embeŋ, ŋic kecši jaŋe iŋuc jaha fua-jareme Miti Opâ wemocko sakare-jarezo.” ");
INSERT INTO kmg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iŋuc murâ mume ŋicfâcne jaŋe Jesu Kristo ere šâŋeo šuhuc-jopahuc opâ rua-jarembiŋ. Eme jaŋe Miti Opâ ruarâ Petoro sakarepie šoaŋ gie bapa gâcne jaŋehec ŋeŋe juju ewec. ");
INSERT INTO kmg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposolo gâcne â opâ ruac Judaia mâreŋko jumbiŋ, jaŋe qâpuczi wâc Anuture dâŋ ro maŋ embiŋ irec biŋe manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Irec Petorozi Jerusalem haeo risie feme Judaŋiczi opâ ruac jaŋe manacnepie mi sâckeme ");
INSERT INTO kmg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","šiŋuc âzâcnembiŋ: “Go wemocte Mosere ma tâmiric iqic-joparâ jaŋere meonec wiac nâmeŋ?” ");
INSERT INTO kmg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Eme Petorozi wiac fuawec i fuŋnaonecteaŋ qâwirickerâ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“No Jope haeo numuhuc juhape Wofuŋzi maŋko fuac enareme wiac kecšiŋuc honepo: Wiac moc racsâko tinac tofane 4 ira basanaŋkehuc sambâŋkonec âkesuepie wahaku maŋfuŋ-naneo fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wahame findendeŋnehuc hone qârâwiŋ ejarehuc honepo: Maŋnao qowi kosa, micmâŋ â micnehec, erâ homa wiac â sawa wipe fowec. ");
INSERT INTO kmg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ehame norao dâŋ wiwira kecšiŋuc fuawec: `Ajoc Petoro, go hezu nâc ec. Ž ");
INSERT INTO kmg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Eme noni mupo, `Wofuŋ, misac, no wiac hecke-nârekicne â mamakâcne moc mi nâekopac. Ž ");
INSERT INTO kmg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Iŋuc mupe sambâŋkonec dâŋ harierâ šiŋuc fuawec: `Anutuzi wiac mušurekac i goki mi surec. Ž ");
INSERT INTO kmg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wiac iŋuc fuame jahec â moc eme racticnehec fârepie sambâŋko risie fewec. ");
INSERT INTO kmg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Eme manaŋgopieŋ, wiac i arictac ehame izia Kaisarea haeonec ŋic jahec â moc nore kiŋaŋ fârâ fic jumbeŋ ira fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Fisipie Mârozi šiŋuc nazawec: `Go jaŋehec racmurâ maŋbahac mi ec. Ž Eme rape opâ ruac ŋic 6 kecši jaŋe bâjâpecnumbiŋ. Ra fisirâ momori soŋaŋte ficko fepene ");
INSERT INTO kmg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","dâŋ binaŋ kecšiŋuc enârewec: `Nore ficko aŋelozi wefu fua-narerâ šiŋuc nazawec: Go Jope haeo kiŋaŋ sorec-jopatec Simoŋ, šâŋene moc Petoro, jowa warepie ");
INSERT INTO kmg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","dâŋ mume go â wiacfâcge ŋoŋe manarâ biaŋke-fârenšepieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eme no miti jazahape mârâc nâŋâcnao Tiri Mâro wahawec iŋuc jaha jaŋerao wahawec. ");
INSERT INTO kmg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eme no i honerâ Wofuŋzi dâŋ kecšiŋuc muwec i manasupo: `Johanezi opâ rua-ŋarewec, ŋoŋe ine Tiri Mâro rua-ŋarezo. Ž ");
INSERT INTO kmg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Eme nâŋâc Wofuŋ Jesu Kristo manasiŋkehapene wiac tahacke-nârewec, ijaha jaŋe tahacke-jareme no iŋucnezi wemocko Anutu qataracnezapo.” ");
INSERT INTO kmg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iŋuc muhuc jazame jaŋe manarâ maŋjeŋic fâre wahame Anutu muteŋkehuc šiŋuc mumbiŋ: “Opo, Anutu e ŋic qâpuc maŋjeŋic bârisierâ juju sanaŋte biŋe eniŋte wâc mujarekac hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefano qarâ opâ ruac gâcne jopa bâtâtiec ejarepie haha rârâwiŋ qarâ tucnezi Foinike â Kipiro nucko â Antiokia haeo rambiŋ. Ra juhuc miti i Judaŋic sawa jazambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eme ŋondeŋ-jeŋicko Kipiro nuckonec â Kirene mâreŋkonec opâ ruac ŋic jumbiŋ, jaŋe Antiokia haeo fisirâ Grikŋic jaŋehec iŋuc jaha muc manac ehuc Wofuŋ Jesure Biŋebiaŋ jazambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Eme Wofuŋzi tâpiri sicne-jarehame jazapie ŋic guru sâko jaŋe manarâ maŋjeŋic bârisierâ Wofuŋte biŋe embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Eme irec dâŋ Jerusalem kikefuŋ jaŋerao rame manarâ Banaba sorepie Antiokia haeo rawec. ");
INSERT INTO kmg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ra fisirâ Anutu uruc jauŋ-ticne honerâ bubiaŋ manarâ maŋjeŋiczi Wofuŋtao herâŋke sanaŋkeniŋte faŋ qajarewec. ");
INSERT INTO kmg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba e ŋic biaŋne, maŋnao Tiri Mâro â mamanasiŋ fusewec. Eme hae ira ŋic wemo afecnezi Wofuŋtao šuhuckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Eme Banaba e Saulo bâfuaocte Taso haeo rawec. ");
INSERT INTO kmg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ra bâfuarâ jowame Antiokia haeo warepic. Erâ opâ ruac guruo jara moc juhuc ŋic bocjaha miti jaza qazuc epic. Antiokia hae ira hâcne ŋiczi Jesure kikefuŋ jaŋere šâŋe Kristoŋic mufuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dameŋ ira porofete ŋic Jerusalem haeonec Antiokia haeo rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ehuc jaŋeraonec moc, šâŋene Agabo, e Mârozi ecneme mâreŋ sâc roroc sâko fuaocte irec findaŋdâŋ muwec. Eme roroc i ŋicwofuŋ sâko Klaudio juhame fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Eme opâ ruac jaŋe dâŋ i manarâ moneŋ fojarewec sâc bâturerâ Judaia mâreŋko âgofâc-jeŋic jaŋerao râepie raocte mupaŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Erâ moneŋ bâfuambiŋ i Banaba â Saulo jactepie bara opâ ruac soŋaŋ micnefâc-jeŋic jarepic. ");
INSERT INTO kmg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dameŋ ira ŋicwofuŋ Herode e kikefuŋte ŋic ŋokac gâcne jopa sipiric ejareocte kâpâcwâru ficko râec-jopawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ehuc Johane hahac-ticne Jakobo mume šikazi qâhâmombiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Iŋuc eme Judaŋic jaŋe aŋac-jopame honec-joparâ Petoro iŋuc jaha mume goreŋ sowa hombaŋ maickeme kâpâcwâru bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Aakic hombaŋ tarame Judaŋic jowaturâ qaocte manasurâ mume kâpâcwâru ficko râerâ momori 16 jaŋe soŋaŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Eme Petoro e kâpâcwâru ficko fohame kikefuŋ jaŋeraonec nunumu šušuhuc jaha Anuturao fehuc domawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Eme Herode e hae fureme ŋic jowatuocte šâfo maickewec ŋafe ira momori jajahec jahe Petoro kâpâcwâru jajaheczi bândeŋnerâ bafopic, â momori gâcne motâc râpeo soŋaŋ domambiŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ehame ficmaŋko mi Wofuŋte aŋelo moczi ututuŋ fuarâ domame fic tamae-fârezejec i¡ Eme aŋelozi Petoro gâjoŋnao qâuahuc wiwickerâ muwec: “Picpac faharec.” Mume izia Petorore meonec kâpâcwâru ŋeŋgoroŋkerâ wahawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Eme aŋelozi âzâcnewec, “Umbikage jomarâ kikehuhuge hetec huoc.” Iŋuc eme aŋelozi mocwâc âzâcnewec, “Ŋaqige šoricne hetec hume bâjâpecnuc.” ");
INSERT INTO kmg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eme bâjâpehuc aŋelozi wiac ecnewec i maname fârine mâcne, guŋko ecnekicne tinac ewec. ");
INSERT INTO kmg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eme jahe motâc mocko momori domahapie jowaru raši, motâc mocko iŋuc jaha domahapie jowaru raši, eku hae šoŋaopec kimotâc sâko maickepire e jahac aŋkeme hupic. Hurâ hatao rahuc aŋelo e sipuac ewec. ");
INSERT INTO kmg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eme Petoro e maŋne uŋtome šiŋuc muwec: “Ʒi mana-jâmbâŋkekopac, Wofuŋ e aŋelo-ticne soreme Herodere niŋgiŋkonec â Judaŋic jaŋere aarickonec bataracnukac.” ");
INSERT INTO kmg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iŋuc mana tarahuc rarâ Johane Marekore neŋgoc, šâŋene Maria, ere ficko fisiwec. Ira bocjahazi tumaŋnerâ numuhuc ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Eme Petorozi šae motâcko heickeme kiŋaŋ naru moc, šâŋene Rode, e mozi heickekac muhuc waharâ ");
INSERT INTO kmg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petoro dâŋ hawari-ticne manarâ motâc mi roro mâc šeri ehuc ficmaŋko ferâ, Petoro warejec domakac muhuc jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jazame jaŋe manarâ mumbiŋ, “Go maŋge sifuckekac.” Eki ine qizec qahuc muwec, “E jâmbâŋ domakac.” Eme jaŋe mumbiŋ, “I aŋelo-ticnezi mecne.” ");
INSERT INTO kmg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eme Petoro e heickehuc jaha domame motâc rorâ e jahacne honerâ maŋjeŋic omaewec. ");
INSERT INTO kmg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Eme dâŋemâc juniŋte me bazuc ejarerâ Wofuŋzi kâpâcwâru fickonec firuerâ bawahawec irec dâŋ binaŋ ejare-fârerâ muwec, “Ŋoŋe dâŋbiŋe ši Jakobo â âgo gâcne jazaniŋ.” Iŋuc muhuc fâre fâsâerâ mocko rawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hae fureme momori jaŋe Petoro basarâ wemo wiaczi weniŋuc ecnejec muhuc mumutucne embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eme Herodezi bâfuaniŋte mume basa-bipiepie mu indiŋ ejarerâ momori jaŋe soŋaŋ i qâhâmoc-jopaniŋte mutâcne-jarewec. Erâ Judaia mâreŋ beherâ Kaisarea haeo hurâ juwec. ");
INSERT INTO kmg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode e dameŋ ira Tiro â Sidoŋ haeonec râsi ejarewec. Eme hae irec rune jaŋe qâturehuc fisirâ dâŋ mufâsâeniŋte ŋicwofuŋte ŋicbomboŋ, šâŋene Bilasto, mu bâmunaŋ ecnepie bafic-jopawec. Jaŋe wiac nareŋ gareŋ-jeŋic tâcnewecte i mocwâc šuhuckeniŋte iŋuc embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eme Herode e dâŋ bârisie-jareocte šâfo bajarewec i maickeme eri-ticne barâ ŋicwofuŋ ŋeŋe-ticnao waha ŋehuc mu âkeriŋ dâŋ jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jazame ŋic mâmâc sasawa fânâŋkecnehuc šiŋuc mumbiŋ: “Dâŋ i ŋicdâŋ mâcne, i nemure dâŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Eme mi qatara-jarehuc Anutu âkehockewecte Wofuŋte aŋelozi ɋeŋnea qawec. Eme umbeŋzi nanšaŋneme hâmowec. ");
INSERT INTO kmg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Anuture dâŋzi ine qazu qâiŋ erâ haŋ barawec. ");
INSERT INTO kmg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Eme Banaba â Saulo jahe Jerusalem haeo wiac mujactekicne sâc efârerâ Antiokia haeo risienicte Johane Mareko jowapire mâmâc rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokia kikefuŋ maŋnao porofete â qaqazu šiŋuc jumbiŋ: Banaba, â Simoŋ, šâŋe-ticne moc Nige, â Lukio Kirene haeonec, â Manaeŋ, e ŋicwofuŋ Herode ehec mâmâc qâqârândiŋ juhuc sokapic, erâ Saulo. ");
INSERT INTO kmg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Eme šoaŋ mocko sowa juhuc gae mitire tumaŋnehapie Tiri Mârozi dâŋ šiŋuc muwec: “Banaba â Saulo gie mujactepo i banicte bašawiec-jofaniŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mume sowa jurâ mejeŋic qizec-jekicko râehuc numu jambuŋ ejacterâ miti kiŋaŋ râec-jofapie rapic. ");
INSERT INTO kmg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tiri Mârozi iŋuc ehuc sorec-jofame jahe raku Seleukia haeo fisipic. Ira fisirâ wokeo ferâ raku Kipiro nucko fisirâ ");
INSERT INTO kmg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","irec hae qizec Salami ira rarâ Judaŋic jaŋere mitificko ferâ Anuture dâŋ jazapic. Erâ Johane ª e jahehec mâmâc juhuc bafic-jofawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eme nuc fotâcne-fârerâ Pafo haeo fisimbiŋ. Ira fisirâ Judaŋic moc qaŋgec bapa â porofete burecne juwec, šâŋene Barajesu, e bâfuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ŋic e kia moc Seregio Paulo ere 390 juwec. Kia e maŋfânâŋ-ticneheczi Anuture dâŋ manaocte ecneme Banaba â Saulo hefârec-jofawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hefârec-jofame qaŋgec bapa Elima (šâŋe i qaŋgec bapare mujumbieŋ hâcne(c) eki kia miti sakarecnehuc hecke-jactewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Eme Saulo, šâŋene Paulo wâc mumbiŋ, e Tiri Mârozi maŋ ba afec ecneme Elima šiŋuc âzâcnewec: ");
INSERT INTO kmg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Sataŋte ŋic go, tiŋke biaŋte râsi sanaŋ, maŋge eeatuc â sindaŋzi fusucmakicne, go Wofuŋte hata dândâŋ imackeekic i wezimucko behecmu? ");
INSERT INTO kmg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Irec ši Wofuŋ tâpiri-ticnere fuŋne honezemec” go tiŋtuŋ erâ dameŋ ŋondeŋ moc tatamac hohone tâmiric juzemec.” Mume izia šâŋene dapâc eme tiŋtuŋ qahuc mezi bajaŋ qajaŋ erâ menao roniŋte muwec. ");
INSERT INTO kmg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wiac i fuame kiazi honerâ Wofuŋte mitire maname bipinehec eme mana šakiewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo â ŋicfâcne jaŋe Pafo hae beherâ wokeo mocwâc ferâ raku Pamfilia mâreŋko Perege haeo fisimbiŋ. Ira Johanezi behec-joparâ Jerusalem haeo risiewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Eme jaŋe Perege haeonec raku Pisidia mâreŋko Antiokia hae wasene ira fisimbiŋ. Ira juhapie sabata hombaŋ maickeme Judaŋic jaŋere mitificko ferâ ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Eme soŋaŋ jaŋe sâcmutâc dâŋqâhâcte â porofete jaŋere dâŋqâreŋ gâcne wose tararâ šiŋuc jazambiŋ: “Âgo bureŋ, dâŋmiti moc maŋkeŋgopieŋko mupie mananaŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Eme Paulozi faharerâ niniŋkeniŋte mezi bâuruŋ-joparâ šiŋuc jazawec: “Israe ŋicbureŋ ŋoŋe, â gâcne Anutu araŋ bacneeŋgopieŋ, mâmâc ŋazape mananiŋ: ");
INSERT INTO kmg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israe ŋic nâŋâcne Anutu eki mimi apafâc-nâŋec rowosâec-joparâ Aigita mâreŋko juhapie basawec-jopawec. Erâ tâpiri sanaŋ-ticnezi irecnec jowac-jopa warerâ ");
INSERT INTO kmg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","mâreŋ burocnao gume qataŋ ejarehuc juhame jara 40 ewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Erâ Kanaaŋ mâreŋko ŋicguru 7 bâsirowec-joparâ mume apafâc-nâŋec jaŋe mâreŋ i bâtâc barâ ru sâc erâ jumbiŋ. Ehame jara 450 tarawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Eme Kanaaŋ mâreŋko juhapie mumutiŋ ŋic bâfua-jareme jurakupie porofete Samue fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Eme ŋicwofuŋte mupie Anutuzi Benjamiŋte ɋâricfâc jaŋeraonec Kisi ŋokâ-ticne Saulo âkendâŋne-jareme jara 40 micne bajarehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eme e bârârierâ Dawidi ŋicwofuŋ-jeŋic âkendâŋnewec. Erâ ere dâŋ šiŋuc muwec: `No Isaire ŋokâ Dawidi ere maŋnane sâckeme hone wosâepo, eki hâcne mupe rereŋ-nane juocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Eme Dawidi ɋâricfâc-ticne jaŋeraonec Israe ŋic nâŋâcne bâbâpiaŋ moc fuaocte biŋedâŋ mukicne i fârinehec eocte Anutuzi mume Jesu hâcne fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Erâ ŋicŋondeŋko fua tâcneocte qanaŋ Johanezi Israe ŋic sasawa maŋjeŋic bârisierâ Miti Opâ ruaniŋte jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Erâ Johane e hata mucnekicne i âte tarahuc ŋic šiŋuc jazawec: `E muhuc munareeŋgopieŋ ŋic e no aricne. E jahacne šâhec warehuc jukac” e sâko no iŋucnezi mafahe-ticne decnepe mi sâckeocmu.' ");
INSERT INTO kmg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Qomâfâc-nane Abrahamte ɋâricfâc ŋoŋe, erâ gâcne Anutu araŋ bacneeŋgopieŋ, mupe mananiŋ: Bâbâpiaŋ irec dâŋ i nâŋâcnao râekicne. ");
INSERT INTO kmg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem ŋic fekicne wahakicne jaŋe Jesu mi šâŋitahuc šikao feocte mutaracnembiŋ. Jaŋe iŋuc epie porofete jaŋere findaŋdâŋ sabata hombaŋ sâc wose manac eeŋgopeneŋ i deŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jaŋe Jesure kiŋ basa-bipiehuc sifu Pilato qizec qacnepie qâhâmowec. ");
INSERT INTO kmg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eme mitio mukicne sâc etaracnerâ maripoŋkonec batararâ šâŋeruŋ hawecko râembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eme Anutuzi hâmockonec bâɋâreme faharewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Erâ ehec Galilaia mâreŋkonec Jerusalem haeo mâmâc rambiŋ jaŋe šoaŋ gie bapa bocjaha fua-jarewec. Fua-jareme honembiŋ jaŋe ine biŋe mumufâc-ticne embiŋ Juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Eme mimiŋnefâc-nâŋec wiac biŋe qajarekicne ");
INSERT INTO kmg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","i Anutuzi Jesu bâɋâreme ɋâricfâc-jeŋic nâŋâcnao fârinehec ewec, eme irec bubiaŋ dâŋ ŋazaeŋgopeneŋ. Irec hâcne Miti Mânec namba 2 ira dâŋ šiŋuc qâreŋkekicne fokac: `Go hâcne Ŋokâ-nane, no miŋecgac bâfuacgukopac.' ");
INSERT INTO kmg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jesu bâɋâreme faharewec e šâhec hâhâmo i mocwâc mi bâfuaocmu, irec Anutuzi dâŋ kecšiŋuc muwec: `No Dawidi biŋe qacnepo irec fârine fofo sanaŋ i hâcne tahacke-ŋarepemu.' ");
INSERT INTO kmg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Erâ Miti Mânec mocko dâŋ šiŋuc fokac: `Go Tiriŋicge mi behetec gârecke šaŋ eocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dawidire manaeŋgopeneŋ, e Anutuzi gie mucnewec i ŋicfâc-ticne jaŋerao batararâ hâmowec. Hâmome mimi apafâc-ticne jaŋerao râepie gârecke šaŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Á Anutuzi bâɋârewec e ine gârecke šaŋticne tâmiric. ");
INSERT INTO kmg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Qomâfâc-nane, ŋazape mananiŋ. Sâqocne bâbâtâmire i ŋic eki hâcne bâfuawecte irec dâŋzi maic-ŋopakac. ");
INSERT INTO kmg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosere sâcmutâc dâŋzi kiŋŋeŋic guriŋkeocte eipiewec, Jesurao siŋkepie ine sâcne bârârie-ŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Porofete jaŋerao dâŋ šiŋuc fokac i ŋoŋerao sanaŋkezacte uŋ ŋazakopac: ");
INSERT INTO kmg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","`Oi, miti qiqikiŋ, ŋoŋe wareckerâ omaenšepieŋ; no ŋoŋerao gie fuŋmoc bapemu; biŋene manarâ manapie mi bapane eocmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Eme Paulo â Banaba jahe mitifickonec wahapire ŋic jaŋe sabata hombaŋ mocko dâŋ irecteaŋ jazanicte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Eme tutumaŋkonec waharâ Judaŋic bocjaha â qâpuc Judaŋic jaŋere bâjâpecne gâcne jaŋe mâmâc Paulo â Banaba bâjâpec-jofahapie Anuture jauŋko aimuŋ juniŋte mu sawaŋ ejarepic. ");
INSERT INTO kmg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Eme sabata hombaŋ-jeŋic mocwâc maickeme hae irec ŋic Anuture dâŋ mananiŋte mâretec fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Fisipie Judaŋic jaŋe honec-joparâ mana sâqore-jarerâ Paulo dâŋticne mu surec ehuc bawahambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Iŋuc epie Paulo â Banaba jahe mai qanšaŋ dâŋ šiŋuc muhuc jazapic: “Judaŋic ŋoŋe Anuture dâŋ qanaŋ ŋaŋazare mukicne. Ʒi ine ŋaŋac qikiŋnehuc juju sanaŋte biŋe eniŋte mi muŋgopieŋte behec-ŋoparâ qâpuc jaŋerao ranacmu. ");
INSERT INTO kmg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wofuŋ e irec hâcne kecšiŋuc munârewec: `Noni go ŋic qâpuc jaŋere šoctamac râecgupore bâbâpiaŋ-jeŋic juraku mâreŋ qaŋeŋnao jutarazemec. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iŋuc mupire qâpuc jaŋe manarâ bujeŋic biaŋkeme Wofuŋte dâŋ muac baafec ecnembiŋ. Eme juju sanaŋte biŋe eniŋte mana wosâc ejarekicne sâc jaŋe miti mana šakiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Eme mâreŋ ira Wofuŋte dâŋzi haŋ barawec. ");
INSERT INTO kmg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Hae irec ŋic fekicne jaŋere ŋonâŋfâc gâcne Judaŋic jaŋere bâjâpecne jumbiŋ, jaŋe Judaŋiczi qafeŋ-jopahuc hae soŋaŋ mâmâc maŋ bâiŋ ejarembiŋ. Eme babafic erâ Paulo â Banaba râsi ejactehuc hae mâreŋ-jeŋic sakare-jacterâ jâpec-jofapie rapic. ");
INSERT INTO kmg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Rahuc kike-jekickonec gâc wândoc-jeŋic âteickepire wahahame suŋgiŋ-jopahuc Ikonioŋ haeo rapic. ");
INSERT INTO kmg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Rahapire miti mamana jaŋere maŋko šeri bubiaŋ â Tiri Mâro fua babaraŋ fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Eme Ikonioŋ haeo fisirâ iŋuc jaha Judaŋic jaŋere mitificko ferâ miti mupire fârio qawec. Ehame Judaŋic â Grikŋic bocjahazi Jesure kikefuŋ embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judaŋic gâcne jaŋe ine miti qikiŋnehuc hae irec ŋic suruc-jopapie Kristoŋic aaric mana-jarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Eme jahe sifu mosa dameŋ gâcne hae ira juhuctecne Wofuŋtao roweckerâ miti-ticne hâwicmâc muhuc jupic. Ehapire Wofuŋzi akicdâŋ-ticnere fuŋne bataniŋkehuc neŋgoc ŋesiŋ ŋejactehame mâsi fuŋne fuŋne bapic. ");
INSERT INTO kmg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Eme hae irec ŋic jaŋe fâuckehuc tucne Judaŋic jaŋerao qohotambiŋ â tucne jaŋe aposolo jaherao qohotambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Izi šâhecko ŋic qâpuc â Judaŋic gâcne jaŋe aposolo qânâzi he imac ejacteniŋte roroc epie ");
INSERT INTO kmg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","manarâ wiserâ Likaonia mâreŋko rapic. Erâ ira Listera â Derebe â hae gâcnao ");
INSERT INTO kmg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Biŋebiaŋ murahuc jupic. ");
INSERT INTO kmg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Eme Listera haeo ira ŋic moc ŋewec, e kike jahec-ticne ɋaŋakicne. E neŋgoc bumaŋko iŋucne fuarâ hata juju tâmiric mâc ŋejujec. ");
INSERT INTO kmg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Eme Paulozi miti mume manahuc ŋehame erao findendeŋnerâ fuŋne-ticne šiŋuc manawec: Ŋic e bibiaŋte mamanasiŋ sâcne focnekac. ");
INSERT INTO kmg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iŋuc manarâ dâŋ hahaŋne bahuc šiŋuc âzâcnewec: “Go kikegezi âterâ fahare hâŋ domac.” Mume ŋic e furutuc herâ fahare rac warec ewec. ");
INSERT INTO kmg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Eme ŋic guru sâko jaŋe Paulozi mâsi bawec i honerâ micne micširiŋ Likaonia dâŋjeŋicko šiŋuc mumbiŋ: “Nemu jaŋe ŋicsahachec erâ ŋondeŋ-nâŋecko fuambiŋ juŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ehuc Banaba e nemu moc šâŋene Dia ere wase bambiŋ, â Paulo e dâŋ bâtâcnerâ mujujecte nemu moc šâŋene Hermes ere wase bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Eme nemu Dia ere taha bapa eki mume bulimakao â reso eri wiac hae upeo nemure ufuŋ ŋewecko amecke hurâ ŋicjahec jahere bâzi rikezo embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Eme aposolo jahec Banaba â Paulo jahe i manarâ fâfâre sâqorehuc hemâtâc-jofame ŋic bâfâuc bâfâuc-jopa ");
INSERT INTO kmg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","rarâ šiŋuc mupic: “Oi, ŋicbureŋ, ŋoŋe wemo eŋgopieŋ¡ Nâhe ŋic jaha wâc, ŋoŋere sâc. Ŋoŋe nemu burec burec râpec-joparâ Wofuŋ jujune maickeniŋte Biŋebiaŋ-ticne muekoperec hâcne. Eki sambâŋ â mâreŋ â hâwec wiac fuŋne fuŋne-jeŋichec bâfua-fârewec. ");
INSERT INTO kmg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Erâ juwefukicne dameŋ ira ŋic qâpuc mana-jarehame maŋjeŋicte juju hata fuŋne fuŋne bâfuarâ jujumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Erâ qâoma mi eŋarewec, fuŋne-ticne mananiŋte âgo jauŋ eŋarehuc mume hoe šoaŋ sâckoa eme mâriri fuame nâ šeri ejumbieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ŋicjahec jahe dâŋ iŋuc muhuc mu bâmâteŋ ejarehuc qatara-jarekupire bâzi ririke-jacte i behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Eme ira juhapire Antiokia haeonec â Ikonioŋ haeonec Judaŋic fisirâ ŋic mu bâdoc ejarepie babafic erâ Paulo qânâzi hembiŋ. Erâ hâmokac muhuc hae râpeo fâre rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Eme ira fohame opâ ruac jaŋe fisirâ orâŋke âte sâoc ecnehapie ɋârerâ fahare haeo fewec. ");
INSERT INTO kmg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Erâ hae fureme Banabahec Derebe haeo rapic. Rarâ ira Biŋebiaŋ mupire ŋic bocjahazi mana šakiepie Jesure kikefuŋ bacjopapic. Iŋuc erâ hata rapicko ijaha mocwâc risiehuc Listera â Ikonioŋ â Antiokia haeo ª fisi fisi warepic. ");
INSERT INTO kmg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Hae sâc fisihuc Jesure kikefuŋ jaŋe mamanasiŋ hešakierâ juniŋte mu basanaŋ ejare warehuc šiŋuc jazapic: “Nâŋâc šârâ hâriŋ faio juhuc Anuture uucmaŋko rašinaŋte mušâwe-nârekicne.” ");
INSERT INTO kmg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Erâ wâc kikefuŋ gurune gurune soŋaŋ bâwosâe-jarerâ sowa juhuc numu jambuŋ ejarehuc, manasiŋkembiŋ Wofuŋ erao hâcne râec-jopapic. ");
INSERT INTO kmg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Eme Pisidia mâreŋ fotâcnerâ raku Pamfilia mâreŋko fisipic. ");
INSERT INTO kmg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ira fisirâ Perege haeo miti jazarâ Atalia haeo hupic. ");
INSERT INTO kmg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ira hurâ wokeo ferâ raku Antiokia haeo fisipic. Hae ira hâcne opâ ruac jaŋe Wofuŋte jauŋko râec-jofahuc gie mujactepie fuŋkerâ barapic. ");
INSERT INTO kmg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Izi ware fisirâ kikefuŋ hetumaŋ-joparâ, Anutuzi neŋgoc ŋesiŋ ŋejactehame gie bapic, â qâpuc motâc rojareme mamanasiŋhec embiŋ, irec dâŋ binaŋ ejare-fârepic. ");
INSERT INTO kmg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Erâ dameŋ šošoricnea Jesure gurufâc jaŋere ŋondeŋko jupic. ");
INSERT INTO kmg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Judaia mâreŋkonec opâ ruac gâcne Antiokia haeo rarâ kikefuŋte ŋic šiŋuc jazambiŋ: “Ŋoŋe Mosere dâŋ sâcko sahac-ŋeŋicko ma mi bahuc Wofuŋte biŋe sâcne mi eniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Iŋuc muhuc Paulo â Banaba jahehec mufec muwahac ehuc qaqatarac sâko embiŋ. Eku šiŋuc mumockembiŋ: “Paulo â Banaba erâ opâ ruac jaŋeraonec ŋic tucne jaŋe dâŋ i aposolo â mitire micne Jerusalem haeo juŋgopieŋ jaŋerao baranšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Iŋuc murâ kikefuŋzi sorec-jopahuc mâzoc-jopapie rambiŋ. Rahuc Foinike â Samaria mâreŋ fotâcnehuctecne opâ ruac šiŋuc jaza rambiŋ: “Qâpuc bocjahazi mitio rašiŋgopieŋ.” Jazapie manarâ jaŋerao bubiaŋ kâcɋene fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Eme raku Jerusalem haeo fisipie opâ ruac kikefuŋ â aposolo â mitire micne jaŋe mu šeri ejarehapie, Anutuzi neŋgoc ŋesiŋ ŋejarehame miti gie bapie fârinehec ewec, irec dâŋ binaŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Dâŋ binaŋ etara-jarepie opâ ruac gâcne farisaio jaŋere guruoneczi šiŋuc mumbiŋ: “Ŋic qâpuc sahac-jeŋicko ma bazo â Mosere sâcmutâc dâŋ reŋkeniŋte mu hezuc ejarezo. I tâmiric mitio rocjopapie mi sâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Eme aposolo â mitire micne jaŋe dâŋ i muniŋte buc tumaŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tumaŋnerâ dâŋ hec hetikic eku Petorozi faharerâ šiŋuc jazawec: “Qomâfâc-nane, ŋic qâpuc Biŋebiaŋ bâtâcnerâ jajaza ine Anutuzi mârâcko âgo-ŋeŋic no bâwosâecnume jazape manarâ Jesure kikefuŋ embiŋ i ŋoŋe manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Eme Anutu e maŋ hohonezi Judaŋic nâŋâc Tiri Mâro nârewec iŋuc jaha ŋic qâpuc jarehuc fuŋne nâwotuwec. ");
INSERT INTO kmg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jaŋe e manasiŋkepie maŋjeŋic šure bâpiaŋ ejarehuc nâŋâc enârewec sâc ijaha jaŋe ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Irec ŋoŋe wemocte Anuture sâc jâuruhuc tagi ŋemâcne sâko, kâcɋenefâc-nâŋec â nâŋâc deipiembeŋ ijaha qâpuckonec opâ ruac jaŋere faio râezo muŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Iŋuc misac, nâŋâc šiŋuc manaeŋgopeneŋ, bibiaŋke i Judaŋic â qâpuc mâmâc Wofuŋ Jesu aki anonoc-ticnere erâ biaŋkeeŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Eme tumaŋnekicne sasawa jaŋe mâc fâsâerâ ŋefârembiŋ. Ŋehapie Paulo â Banaba jahe Anutuzi gieŋic jucnehapire qâpuc jaŋerao mâsi fuŋne fuŋne bawec irec mu binaŋ ehuc jazapic. ");
INSERT INTO kmg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jazaku jaza-fârepire Jakobozi dâŋ šiŋuc jazawec: “Âgo bureŋ, dâŋ mupe mananiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Anutu e qâpuc guruonec ŋic rocjopame biŋefâc-ticne eniŋte hata bâfuawec, irec dâŋ binaŋ Simoŋzi mume manambeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eme ere dâŋzi findaŋdâŋko iticnekac. Porofete jaŋere dâŋqâreŋ moc kecšiŋuc hâcne fokac: ");
INSERT INTO kmg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","`Noni juku risierânec Dawidire boze šaŋkekicne heɋârepemu â sesucne qâšurerâ šumururuckepemu. ");
INSERT INTO kmg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Eme ŋic šanšaŋne Wofuŋ wira basac ecnenšepieŋ, â ŋic qâpuc biŋefâc-nane erâ iŋuc jaha enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wofuŋ e dâŋ iŋucne mufua wefuhuc juweczi mukac hâcne.' ");
INSERT INTO kmg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Irec no mana wosâerâ šiŋuc mukopac: Qâpuc guruoneczi Anutu maickeŋgopieŋ jaŋe tagi sâko mi râe-jarenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Jaŋe nemuɋâŋte wiac mamakâcne â sasec boe sau â qowi bituakicne â qowisoc, wiac i bâec baniŋte mupaŋkerâ papia qâreŋke-jarenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","I šiŋucte enšepeneŋ: Mosere dâŋ i mimiŋzi ɋâric mârâc jaha fuŋkerâ hae sâc wose warehuc jukicne, â šiŋuczia wâc iŋuc jaha sabata hombaŋ sâc mitificne ficne wose manac eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Eme aposolo â micne jaŋe kikefuŋte ŋic sasawa jazapie manapie sâckeme jaŋeraonec ŋic jajahec bâwosâec-jofambiŋ. Moc šâŋene Juda, šâŋe-ticne moc Basaba, erâ Sila, mitire micne bapa jahe hâcne bâwosâec-jofarâ Paulo â Banaba jahehec mâmâc Antiokia haeo raniŋte sorec-jopambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ehuc papia moc šiŋuc muhuc qâreŋkerâ Jarepie barambiŋ: Qomâfâc-ŋeŋic aposolo â mitire micne nâŋe qomâfâc-nâŋec qâpuc guruonec Antiokia haeo â Siria â Kilikia mâreŋko juŋgopieŋ ŋoŋe mu šeri eŋarehuc papia ši râe-ŋareŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nâŋe mi manahapene širec ŋic gâcne ŋoŋerao fârâ dâŋ ŋazahuc maŋ bâsifuc eŋarepie ŋoŋerao dâŋ fâfâuc fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eme nâŋe i manarâ tumaŋne-fârehuc ŋic jajahec bâwosâec-jofarâ qomâ jahec-nâŋec Banaba â Paulo jahehec sorec-jopapene fâŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ŋic jahe hâcne Wofuŋ-nâŋec Jesu Kristo ere erâ juju-jekic qikiŋnepic. ");
INSERT INTO kmg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Eme ŋic bâwosâec-jofambeneŋ Juda â Sila, jahe fârâ dâŋ i miczi wâc ŋazapire mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tiri Mâro â nâŋe tagi gâcne moc mi šuhuckehuc wiac kecšiŋuc sawa ine râe-ŋarenaŋte mumockembeneŋ: ");
INSERT INTO kmg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ŋoŋe nemuɋâŋte taha bâzi â qowisoc â qowi bituakicne â sasec boe sau i râpecke sanaŋkenšepieŋ. Biaŋne junšepieŋ.' ");
INSERT INTO kmg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Eme kikefuŋ jaŋe ŋic i hâcne jaza mâzoc ejarepie rambiŋ. Raku Antiokia haeo fisirâ opâ ruac guru hetumaŋ-joparâ papia jarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jarepie wose manac erâ âgodâŋ qâreŋke-jarembiŋ irec bujeŋic biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Eme Juda â Sila jahe porofete jupiczi dâŋ bocjaha muhuc mu âkeriŋ ejarerâ mitio dopec-jopapic. ");
INSERT INTO kmg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Eme jaŋehec juju dameŋ i tarame neŋgocfâc-jekic jaŋerao risienicte bubiaŋko râe mâzoc ejactembiŋ.  ");
INSERT INTO kmg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sila e ine jaŋerao juocte muwec. ");
INSERT INTO kmg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo â Banaba jahe Antiokia haeo šuhuckerâ jupic. Ehuc mitiŋic gâcne jaŋehec babafic erâ Wofuŋte dâŋ ŋic Jaza qazuc embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Juku Paulozi Banaba šiŋuc âzâcnewec: “Nâhâc miti kiŋaŋ rahuc Wofuŋte dâŋ mupere hae sâc âgofâc-nâhec fuambiŋ jaŋe weniŋuc juŋgopieŋ i ra hone manac ejarezeperec. ");
INSERT INTO kmg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Iŋuc mume Banaba e Johane Mareko mâmâc raniŋte muwec. ");
INSERT INTO kmg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Eme Mareko e mârâcko jahehec raku Pamfilia mâreŋko gie furunao fisirâ behec-jofarâ risiewecte Paulozi ehec raniŋte maname mi sâckewec. ");
INSERT INTO kmg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ehuc Banabahec mu qaqatarac sanaŋne eku râwiŋnepic. Râwiŋnehuc Banabazi Mareko jowame ra wokeo ferâ Kipiro nucko rapic. ");
INSERT INTO kmg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo e ine Sila rowosâeme opâ ruac jaŋe Wofuŋte jauŋko ŋec-jofahuc mâzoc-jofapie rapic. ");
INSERT INTO kmg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Rahuc Siria â Kilikia mâreŋ fotâcnehuc Jesure kikefuŋ mu basanaŋ ejarepic. ");
INSERT INTO kmg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo â Sila jahe raku Derebe â Listera haeo fisipic. Eme Listera haeo ira Jesure qâjâpec moc juwec šâŋene Timoteo. E neŋgoc-ticne Juda ŋokac opâ ruac â mamac-ticne Grikŋic. ");
INSERT INTO kmg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listera â Ikonioŋ haeonec miti mamana jaŋe Timoteore fuŋne muafeckehuc Paulo âzâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Âzâcnepie Paulo e jume ju eocte âzâcnewec. Eme mâreŋ ira Judaŋic jurambiŋ jaŋe motecte mamac e Grikŋic i mana-fârembiŋ. Irec Paulozi jaŋere erâ sahacnao Mosere ma bawec. ");
INSERT INTO kmg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Eme hae sâc rahuc, aposolo â micne Jerusalem haeo mumupaŋ mumbiŋ, i reŋkeniŋte opâ ruac jaza rapic. ");
INSERT INTO kmg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iŋuc ehuc gie bapire Jesure kikefuŋ jaŋere mamanasiŋ ɋârâŋkewec â šoaŋ sâc qâpuczi jaŋerao ra heacmârec ekupie bocjaha embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Eme Asia mâreŋko miti murazo mupie Tiri Mârozi hecke-jareme Frigia â Galatia mâreŋ fotâcnehuc rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Raku Misia mâreŋ qaŋeŋnao fisirâ ŋifec bâŋorierâ Bitinia mâreŋko razo mupie Jesure Mârozi iŋuc jaha mi mana-jarewec. ");
INSERT INTO kmg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Irec jaŋe Misia mâreŋ qacnerâ raku hâwecmecko Troa haeo fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ira fisirâ ŋafeo Paulo e maŋnezi ŋerisieme wiac kecšiŋuc honewec: Makedonia ŋic moczi erao fuarâ domahuc mu wâsic ecnehuc šiŋuc âzâcnewec: “Go Makedonia mâreŋko fârâ bafic-nâpozemec.” ");
INSERT INTO kmg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo e wiac i honeme šiŋuc mumbeŋ: “Anutu e Makedonia mâreŋko ra Biŋebiaŋ jazanaŋte munârekac hâcne.” Iŋuc murâ izia ranaŋte šawiembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ʒawierâ wokeo ferâ Troa hae beherâ fofotâc raku Samotrake nucko fisimbeŋ. Hae fureme irecnec raku Neapoli haeo fisimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ira wokeonec waharâ raku Filipi haeo fisimbeŋ. I Makedonia mâreŋ irec hae sâko moc, Romaŋic jaŋe hae rune erâ jumbiŋ. Hae ira šoaŋ gâcnao jukupene ");
INSERT INTO kmg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","sabata hombaŋ maickeme hae upeo opâ moc fowec ira šiŋuc muhuc humbeŋ: “Judaŋic numueŋgopieŋ irec toma opâo moc fokacko hurâ honenaŋ.” Iŋuc muhuc hurâ ŋokac tumaŋnerâ juhapie bâfuac-joparâ waha ŋehuc miti jazambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Eme jaŋere guruo ŋokac moczi Anutu araŋ bacnehuc juwec, šâŋene Lidia, e qoruc situâc rune, Tiatira haeonec. Ŋokac e hâcne Wofuŋzi maŋne bâuŋtome Paulole dâŋ hazec hâric manawec. ");
INSERT INTO kmg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Erâ e jahacne â wiacfâc-ticne Miti Opâ ruarâ šiŋuc nâzâwec: “Ŋoŋe honecnupie Wofuŋte biŋe ekopacko nore ficko wefurâ ŋeŋe juju enšepieŋ.” Iŋuc muhuc hotâ-nâreme fembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dameŋ mocko nunumure tomao huhapene kiŋaŋ naru moczi bâfuac-nâpowec. Naru e faŋfaŋ demoŋ-ticnehec juhuc ŋic jaŋere fuŋne mufua jujec, ehuc rufâc-ticne moneŋ mafa bocjaha hure-jare jujec. ");
INSERT INTO kmg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Eme eki hâcne bâfuac-nâporâ Paulo â nâŋe bâjâpec-nâpohuc dâŋ wiwira kecšiŋuc ewec: “Ŋic kecšizi Anutu femicne sâko ere kiŋaŋ qaqa juhuc biaŋkeniŋte hata mušâwe-ŋareeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dâŋ wiwira i sasawa šoaŋne šoaŋne enarekume Paulo e irec takickeme forisierâ demoŋ šiŋuc âzâcnewec: “No Jesu Kristo ere micte gazape ŋokacte maŋkonec wefu rac.” Iŋuc mume izia wefurâ rawec. ");
INSERT INTO kmg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Eme naru rufâc-ticne jaŋe moneŋ mafa fufua-jeŋic arictac eme manarâ Paulo â Sila rocjofarâ ");
INSERT INTO kmg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","hae šâšâŋiŋko kia jaŋerao fârec-jofa rarâ qoric-jofahuc šiŋuc mumbiŋ: “Jahe Judaŋiczi hae-nâŋecko warerâ maŋbâiŋ enârekopirec, ");
INSERT INTO kmg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ehuc mâsi qâreŋ furune, Romaŋiczi mi eene â mi babajune, i hâcne bâfuakopirec.” ");
INSERT INTO kmg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Eme ŋic guru sâko domambiŋ jaŋe aaric mana-jactehuc râsi šâŋe honec-jofapie kiazi ŋaqi-jekic heuc qâunuckerâ mume kâcbiŋzi jofambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kâcbiŋzi mâretec qâtâc bâtâc-jofarâ kâpâcwâru ficko râec-jofarâ soŋaŋ e motâc basanaŋkerâ aimuŋ soŋaŋ-jofaocte âzâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Âzâcnepie kâpâcwâru fic maŋne šâšâŋiŋko râec-jofarâ kike-jekic jâc fifitacko ŋeme kindeŋneme fopic. ");
INSERT INTO kmg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ŋafe šâšâŋiŋko Paulo â Sila jahe Anutu gae nunumu ecnehuc muteŋkepic. Epire kâpâcwâru ŋic gâcnezi micfânâŋ-jekic manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ehame homeŋ sâko ututuŋ bame kâpâcwâru fic sâpene qiriŋ qame motâc aŋke-fârewec â ŋic sasawa kâpâcwâru-jeŋic ŋeŋgoroŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Eme kâpâcwâru ficsoŋaŋzi guŋkonec mana ɋâɋârerâ faharerâ motâc aaŋ doma-fâreme honerâ, kâpâcwâru ŋic wise-fârembieŋ muhuc sâqe-ticne becsahackonec unuckerâ sahac-ticne âeckezo ewec. ");
INSERT INTO kmg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Iŋuc ezo eme Paulozi owackerâ muwec, “Sahacge mi sipirickec, nâŋe furu jaha ŋeŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Eme soŋaŋ e lambere mume wiacfâcne jaŋe râcnepie ficmaŋko ferâ ɋarac ɋarac qahuc Paulo â Sila jahere kikefuŋko fodapewec. ");
INSERT INTO kmg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Erâ ficmaŋkonec jowacjofa waharâ wio-jacterâ muwec, “Ŋicbomboŋ jahec-nane, no weniŋuc erâ biaŋkepemu?” ");
INSERT INTO kmg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Eme jahe šiŋuc âzâcnepic: “Wofuŋ Jesu Kristo manasiŋkehuc go â wiacfâcge biaŋkeniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iŋuc murâ e â wiacfâcne Wofuŋte dâŋ jazapic. ");
INSERT INTO kmg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jazapire soŋaŋzi ŋafeoa hefârec-jofarâ kâcbiŋ micrâfâcne šure-jactewec. Erâ mume e jahacne â wiacfâcne Miti Opâ rua-jarepic. ");
INSERT INTO kmg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Eme e jahacne ficmaŋko râec-jofarâ mume nânâ rike bâmoc ejactembiŋ. Eme e â wiacfâcne Anuture biŋe embiŋte bujeŋic biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hae fureme kia jaŋe polismaî šiŋuc muhuc jaza sorec embiŋ: “Ŋic jahec firuec-jofazo.” ");
INSERT INTO kmg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Eme soŋaŋzi manarâ Paulo šiŋuc âzâcnewec: “No sorec-ŋofape ranicte kia jaŋe dâŋ râepie warekac, irec ŋohe waha rarâ wamao juzepirec.” ");
INSERT INTO kmg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mume Paulozi šiŋuc âzâcnewec: “Jaŋe Romaŋic guruonec fuakicne nâhe dâŋficko mi râec-nâfohuc ŋichofao qâtâc bâtâc-nâforâ kâpâcwâru ficko râec-nâfombieŋ. Eme ši wemocte kamicnea sorec-nâfoŋgopieŋ? Iŋuc aricne, jaŋac ware jowac-nâfopie razeperec.” ");
INSERT INTO kmg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Paulo e dâŋ iŋuc mume polismaî jaŋe risie rarâ kia jazapie jaŋe ŋic jahec Romaŋic guruo fuakicne biŋe i manarâ fâfârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Fâfârerâ ŋic jaherao warerâ mu bâmiriŋ ejacterâ kâpâcwâru fickonec jowac-jofa waharâ hae-jeŋic beherâ ranicte jasambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Eme jahe kâpâcwâru fickonec waharâ Lidia ere ficko rarâ Jesure kikefuŋ honec-joparâ mu sawaŋ ejarerâ rapic. ");
INSERT INTO kmg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Eme Paulo â Sila jahe Amfipoli â Apolonia hae fotâc-jofarâ Tesalonike haeo fisipic. Ira Judaŋic jaŋere mitific moc ŋewec. ");
INSERT INTO kmg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Eme Paulo e ejujec iŋuc erâ sabata hombaŋ jahec â moc mitific-jeŋicko ferâ jaŋehec mitire muc manac ewec. Ehuc miti dâŋqâreŋ gâcne irec fuŋne jaza mutâc ehuc šiŋuc muwec: ");
INSERT INTO kmg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Kristo e hâmorâ fahareocte mitio mukicne hâcne. Eme Jesure šâŋe biŋe ŋazaekopac e Kristo jâmbâŋ hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Eme tucne jaŋe dâŋ i mana šakierâ Paulo â Sila jaherao qohotambiŋ. Erâ Grikŋic Anutu araŋ bacnehuc jumbiŋzi bocjaha jaŋerao wâc šuhuckembiŋ, erâ ŋokac fekicne afecne mâcne. ");
INSERT INTO kmg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Eme ŋic bocjahazi miti manapie Judaŋic jaŋe mana sâqorerâ ŋic otec ɋeticne â râŋgeŋne henusuc-joparâ mu ojowa sâko erâ Jasoŋte ficko Paulo â Sila ŋepicko tumaŋne-fârembiŋ. Tumaŋne-fârerâ ŋicjahec hâcne rocjofarâ ŋichofao râec-jofazo mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Erâ basac-jofarâ Jasoŋ â miti mamana gâcne rocjoparâ hae soŋaŋ jaŋerao fârec-jopa rambiŋ. Ehuc šiŋuc muhuc owac owacke rambiŋ: “Mâreŋne mâreŋne maŋbâiŋ ejareeŋgopieŋ ŋic izi hâcne nâŋerao wâc fisipie ");
INSERT INTO kmg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasoŋzi hezu hewâneŋ ejarekac. Jaŋe Roma ŋicwofuŋte dâŋ qâsuahuc ŋicwofuŋ furune moc Jesu ere biŋe mupie haŋ baekac.” ");
INSERT INTO kmg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Dâŋ iŋuc muhuc haeŋic â soŋaŋ mu qafeŋ ejarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Eme soŋaŋ jaŋe Jasoŋ â âgofâcne ejarepie sahac taha-jeŋic qikiŋne-jarepie râec-jopapie rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Eme miti mamana jaŋe Paulo â Sila ŋafeoa ejactepie Berea haeo rapic. Ira fisirâ Judaŋic jaŋere mitificko ferâ miti mupic. ");
INSERT INTO kmg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Eme hae irec Judaŋic jaŋe urucne, Tesalonike haeonec jaŋe iŋucne mâcne, irec miti maŋafec jaha manambiŋ. Erâ dâŋjekic jâmbomac me burec muhuc šoaŋne šoaŋne gufu koparic ehuc miti papia wose manac embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Eme jaŋeraonec bocjahazi Jesure kikefuŋ embiŋ, erâ Grikŋic â ŋokac fekicne gâcne sâkozi jaŋerao šuhuckembiŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Paulozi Anuture dâŋ Berea haeo muromackeme biŋe Tesalonike haeo rame irec Judaŋiczi manambiŋ. Manarâ Berea haeo warerâ hae rune mu heinšaŋ ejarehuc maŋjeŋic bâiŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Iŋuc epie miti mamana jaŋe Paulo ecnepie hae i beherâ raku hâwecko fisiwec. Sila â Timoteo jahe ine ijaha jupic. ");
INSERT INTO kmg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Eme ŋic jaŋe Paulo jowa raku Ateŋ haeo râepie šiŋuc jazawec: “Ŋoŋe risierâ mupie Sila â Timoteo jahe biac warezepirec.” Eme ŋic jaŋe risiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Eme Paulo e Ateŋ haeo jahere woŋec juhuc ɋâŋ qâqâtâc mâretec ŋerame honerâ maŋne šoc šawec. ");
INSERT INTO kmg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Erâ Judaŋic jaŋere mitificko ferâ Judaŋic jaŋacne â Grikŋic gâcne Judaŋic jaŋere qâjâpecne jumbiŋ jaŋehec mâmâc mitire muc manac embiŋ. Erâ wâc šoaŋne šoaŋne hae šoŋao ŋic bâfuac-joparâ iŋuc jaha miti jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Eme hae ira mamana ŋic jumbiŋ, šâŋe-jeŋic Epikue ŋic â Stoike ŋic. Eme ŋic jaŋe hâcne Paulohec dâŋ mu bâtikic eec embiŋ. Ehuc gâcnezi Paulore šiŋuc mumbiŋ: “Ŋic keci mâc pacgoroŋ enârekac.” Á tucnezi šiŋuc mumbiŋ: “E nemu furunere biŋe mukac tinac i.” Paulo e Jesure biŋe â hâmockonec fafahare irec dâŋ mume Jaŋe iŋuc mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Iŋuc murâ mâreŋ facne moc šâŋene Areo ira jowa ferâ mumbiŋ: “Go dâŋ furune mukomec i weniŋucte mukic, ");
INSERT INTO kmg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","dâŋ i hazec furu-nâŋec, irec fuŋnehec mutec mananaŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateŋ haeonec ŋic, mafa â hae fâri, jaŋe dâŋ biŋe furune manarâ dâŋ ijaha qame qoŋgiŋ ehuc mu binaŋ mâretec ejumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Eme Paulo e Areo dâŋtomao ra domahuc ŋic šiŋuc jazawec: “Ateŋ haeonec ŋicbureŋ, no fuŋne-ŋeŋic šiŋuc honekopac, ŋoŋe nemu bocjaha jaŋere araŋ baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","No hae-ŋeŋicko rac warec ehuc nemuɋâŋfâc-ŋeŋic honec-jopaku alata mocko qâreŋ šiŋuc fome wosepac: `Kecši nemu furune mocte biŋe. Ž Eme nemu furune, mi manahuc kiŋaŋ qacneeŋgopieŋ, Anutu hâcne, ere fuŋne ŋazape mananiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anutu e mâreŋ bâfuarâ fainao wiac sasawa râe-fârewec, eki hâcne sambâŋ â mâreŋ irec rune. ");
INSERT INTO kmg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","E ufuŋ ŋicmezi bakicne ira ŋeŋe juju mi eekac, erâ wâc wiac moc basame ŋiczi gie bacnehuc wiac bâbâfuacne mi fokac. I aricne, ekizia ŋic nâŋâc juju â mâro â wiac sasawa nâre-fâreekac. ");
INSERT INTO kmg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Erâ ŋic ukicne mocjaha bâfuarâ mume eraonec mâreŋ sâc ŋic gurune gurune fua rambeŋ. Erâ fuarâ juranaŋte dameŋ â gaŋ rukec i ekizia munârewec. ");
INSERT INTO kmg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Erâ i maŋnâŋeczi basac qasac eraku Anutu e jahacne bâfuanaŋte manasuhuc iŋuc ewec. E šoricko mâcne, ŋondeŋ-nâŋecko ŋic sâcnâporâ juekac. ");
INSERT INTO kmg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","`Nâŋâc ere jujumaŋko juhuc wiac ebac eeŋgopeneŋ.' Ŋoŋere mamana ŋic gâcnezi wâc šiŋuc mumbiŋ: `Nâŋâc Anuturaonec fuakicne.' ");
INSERT INTO kmg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Eme ŋic jaŋe maŋjeŋicte erâ goì me siliwa me qânâzi ɋâŋ qâqâtâc ba eric eeŋgopieŋ, ine Anuturaonec fuakicne nâŋâc Anuture manapene irec sâc mi ezejec. ");
INSERT INTO kmg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Qâpuc juwefuhapie hone akic eŋare warehuc juwec, irec dameŋ tarawec. ši ine mâreŋ sâc ŋic mâmâc sasawa maŋjeŋic bârisieniŋte mujarekac. ");
INSERT INTO kmg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","E dameŋ bawec fokac, ira mâreŋne mâreŋne ŋic fuŋne-nâŋec bataniŋkerâ okacne sâckoa nâreocmu. Erâ ŋic moc e gie i hâcne baocte âkendâŋnewec, erâ mâreŋŋic sasawa e manapaŋkenaŋte hâmockonec bâɋârewec jukac.” ");
INSERT INTO kmg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Paulo e hâmockonec fafahare irec dâŋ mume gâcnezi mu surec embiŋ, â gâcnezi mumbiŋ, “Dâŋ i dameŋ mocte wâc mutec mananšepeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Iŋuc epie Paulozi behec-joparâ rawec. ");
INSERT INTO kmg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ŋic gâcnezi ine Paulorao qohotahuc Jesure biŋe embiŋ. Jaŋeraonec mumutara ŋic sâko moc šâŋene Dionisio, erâ ŋokac moc šâŋene Damari, erâ gâcne. ");
INSERT INTO kmg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Eme Paulo e Ateŋ hae beherâ Korinti haeo rawec. ");
INSERT INTO kmg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ira Judaŋic moc bâfuawec, šâŋene Aqila, e Pontu mâreŋko fuawec. Erâ ŋonâŋ-ticne Prisila ehec Italia mâreŋko juhapire ŋicwofuŋ sâko Klaudiozi Judaŋic Roma hae sakare-jarehuc jâpec-jopawec. Eme jahe hae i beherâ ɋâricne Korinti haeo rapic. Eme Paulozi jahe iqic-jofawec. ");
INSERT INTO kmg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo e selific bapa, â Aqila e gie ijaha bawecte ficticnao ŋeŋe juju ehuc bafickeme mâmâc bapic. ");
INSERT INTO kmg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Erâ Paulo e sabata hombaŋ sâc Judaŋic jaŋere mitificko ferâ Judaŋic â Grikŋic miti jazahuc mu bâŋgoroŋ ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Eme Sila â Timoteo jahe Makedonia mâreŋkonec warepire Paulozi miti gie paŋšâic bawec, ehuc Jesu e Kristo jâmbâŋ irec fuŋne Judaŋic ritu ɋaɋacke-jarewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Iŋuc ejareme jaŋe dâŋticne bâsuehuc mu supaic ecnepie ŋaqi-ticne itiriŋkeme gâc wândoc wahame šiŋuc jazawec: “Sipirickeniŋmu irec kiŋ nore mâcne, ŋaŋacne eocmu. Irec ši râpec-ŋoparâ qâpuc jaŋerao sawa gie bapemu.” ");
INSERT INTO kmg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Iŋuc murâ ŋic moc šâŋene Titio Justo, e Grikŋiczi Judaŋic jaŋere qâjâpecne juwec, ere ficko ferâ ŋeŋe juju ewec. Ficticne Judaŋic jaŋere mitific heririŋ ŋewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Eme mitificte soŋaŋ šâŋene Krispo e â wiacfâcne jaŋe miti manarâ Jesure kikefuŋ embiŋ. Eme Korinti ŋic jaŋeraonec wâc bocjahazi miti manambiŋ i mana šakierâ Miti Opâ ruambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Eme ŋafe mocko Wofuŋzi Paulo maŋko fuac ecnehuc šiŋuc âzâcnewec: “Go hâhâwic qamaserâ miti murâ mi behezemec, muhuc jaha juzemec. ");
INSERT INTO kmg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","No sabecguhape ŋic jaŋe wiac kosa mi egareniŋmu. Hae šira nore ŋicfâc guru sâko juŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iŋuc muhuc âzâcneme Paulo e hae irec ŋic Anuture dâŋ jaza qazuc ehuc juhame mosa 18 wahawec. ");
INSERT INTO kmg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Eme Galioŋ e Akaia mâreŋko kia sâko erâ juhame Judaŋic jaŋe šâšâfic erâ Paulo râsi ecnehuc kiarao barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bararâ šiŋuc muhuc qorickembiŋ: “Ŋic kecši e sâcmutâc dâŋnâŋec qâsuarâ hata furune moc âtehuc Anutu sâseniŋte ŋic qafeŋ-jopaekac.” ");
INSERT INTO kmg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Eme Paulo e dâŋ ŋifecne muzo ehame Galioŋzi Judaŋic šiŋuc jazawec: “O Judaŋic, ŋic e kiŋbahac wiac ŋemâcne bâfuame muzac dâŋŋeŋic manazapo. ");
INSERT INTO kmg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ŋoŋe ine ŋaŋacne mu qaqazuc dâŋ â ŋicšâŋe wiac â sâcmutâc dâŋ irec dâŋgie râcneŋgopieŋte ŋaŋac mutaranšepieŋ, i nore gie mâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iŋuc murâ jâpec-jopame wahambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Eme jaŋe šeŋgoma mitificte soŋaŋ Sostene hâporâ kiare maio qa imac ecnembiŋ. Eme kiazi hone qâoma ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo e Korinti haeo jufehuc juku opâ ruac mâzoc-joparâ Siria mâreŋko raocte wokeo fewec. Erâ Prisila â Aqila jahe ehec mâmâc rambiŋ. Wokeo fezo ehuc Keŋkereai haeo qizec-ticne rowec. I juwicnao Anuturao mumupaŋ-ticne râerâ qizec mi roro mâc juhame mumupaŋ dameŋ-ticne tarawecte iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Eme irecnec wokeo raku Efeso haeo fisirâ râwiŋnembiŋ. Eme Paulozi Judaŋic jaŋere mitificko ferâ jaŋehec mitire mu bâtikic embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Erâ jaŋehec juocte Judaŋic jaŋe sakarezo mupie qatara-jarehuc šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“No Anutuzi maname ŋoŋerao mocwâc risiepemu.” Iŋuc murâ jaŋehec mâmâzoc erâ Efeso haeo wokeo mocwâc ferâ raku ");
INSERT INTO kmg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kaisarea haeo fisiwec. Ira fisirâ feraku opâ ruac kikefuŋ jaŋehec âgo sahac hâroŋ eec embiŋ. Erâ Antiokia haeo risiewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulo e Antiokia haeo piticne jurâ miti kiŋaŋ mocwâc rawec. Ehuc Galatia â Frigia mâreŋ fotâc-jofahuc Jesure kikefuŋ sasawa mu âkesiŋ ejare rawec. ");
INSERT INTO kmg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ehame Efeso haeo Judaŋic moc fisiwec, šâŋene Apolo. E Alesandria haeo fuawec, ŋic e mamana sâkohec, miti papia woseku mana tara-fârewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Erâ Wofuŋte miti hata qazucnepie i mâmâc manawec. Miti Opâ i Johanere Miti Opâ sawa manaweczi sifu Jesure binaŋ šocmâsâc bâruŋhec ninic jaha ŋic jaza qazuc ewec. ");
INSERT INTO kmg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","E Judaŋic jaŋere mitificko fuŋkerâ miti acmeruŋ tâmiric munširiŋnehuc muwec. Ira miti mume Prisila â Aqila jahe manarâ âgo jauŋ ecnerâ Anuture miti gâcne âzâcne mutâc epic. ");
INSERT INTO kmg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Eme Akaia mâreŋko razo mume mitiŋic jaŋe ocnirec opâ ruac jaŋere papia kecšiŋuc qâreŋkembiŋ: “Ŋic e ŋoŋerao fâme âgo ecnenšepieŋ.” Papia iŋuc qâreŋkerâ râcnepie rawec. Eme raku Korinti haeo fisirâ opâ ruac miti giere mâretec bafic-jopawec. ");
INSERT INTO kmg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ehuc miti papia irec dâŋqâreŋ hewirickerâ Jesu e Kristo jâmbâŋ irec fuŋne hofao mu rituc ehuc Judaŋic jaŋere dâŋ bawahawec. ");
INSERT INTO kmg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo e Korinti haeo juhame Paulozi tiki mâreŋ fotâcne raku Efeso haeo fisirâ miti mamana gâcne bâfuac-joparâ ");
INSERT INTO kmg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","wio-jarehuc muwec, “Ŋoŋe miti manahuc Tiri Mârohec embiŋ me mâcne?” Eme jaŋe mumbiŋ, “Aricne, Tiri Mâro jukac biŋene moc mi manambeŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Iŋuc mupie mocwâc wio-jarewec, “Eme ŋoŋe more šâŋe biŋeo Miti Opâ ruambiŋ?” Mume šiŋuc âzâcnembiŋ: “Nâŋe Johanere Miti Opâ ruambeŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Mupie Paulozi šiŋuc jazawec: “Johane eki ŋic jaŋe maŋjeŋic bârisieniŋte opâ rua-jarehuc šiŋuc jazawec: `Râpefuŋ-naneo warehuc jukac e manasiŋkenšepieŋ. Ž Dâŋ i Jesure muwec.” ");
INSERT INTO kmg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ŋic jaŋe dâŋ i manarâ Wofuŋ Jesu ere šâŋeo šuhuckehuc Miti Opâ ruambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Opâ ruapie Paulozi qizec-jeŋicko meticne râeme Tiri Mâro jaŋerao wahame miti marac furuo muhuc findaŋdâŋ mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ŋic iŋuc embiŋ šare-jeŋic 12 qâririŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Eme Paulo e Judaŋic jaŋere mitificko gâbâ fehuc miti memeŋgaru tâmiric mosa jahec â moc jazahuc juwec, erâ Anuture uucmaŋte jaŋehec mu bâtikic ehuc mu baafec ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Eme ŋic gâcne jaŋe maŋsanaŋ erâ Jesure miti râpeckehuc ŋic tutumaŋko musoriŋkepie Paulozi behec-jopawec. Erâ mitire ejarewec jaŋe qâzuc-joparâ šoaŋne šoaŋne ŋic moc šâŋene Tirano ere mamana ficko miti jaza qazuc ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jara jajahec iŋuc ehuc juhame rârec rârec Judaŋic â Grikŋic Jurambiŋ jaŋe mâmâc sasawa Wofuŋte dâŋ mana-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Erâ Anutuzi Paulo neŋgoc ŋesiŋ ŋecnehame mâsi šâŋe furu-jeŋic bocjaha bawec. ");
INSERT INTO kmg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Eme irec ŋic Jaŋe Paulozi gie qoruc â kereŋ bapa qoruc rojuwec i rorâ huchec jaŋerao barapie bâuarâ ɋiɋic qambiŋ â demoŋ maŋjeŋickonec wisembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ehame Judaŋic riuc bapa gâcne mâreŋ râreckehuc domambiŋ jaŋe penaroŋ erâ Wofuŋ Jesure šâŋezi riuc ripa-jeŋic eocte manasuhuc ŋic demoŋhec šiŋuc jazambiŋ: “Jesu šâŋe biŋe-ticne Paulozi muekac ere micte wisezemec.” ");
INSERT INTO kmg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Taha bapa sâko moc šâŋene Sikeua ere ŋokâfâc 7 jaŋe iŋuc hâcne embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Iŋuc ehuc mupie demoŋzi dâŋ šiŋuc bâtikie-Jarewec: “Jesu manakopac â Paulo wâc manakopac, â ŋoŋe ine wenirec?” ");
INSERT INTO kmg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Iŋuc mume ŋic demoŋheczi momori wânšâŋ erâ motec sasawa Jopa tuŋtuŋ ejarehuc ŋaqi-jeŋic bâsuc qâsuckeme biuctac â soc rurua fahare fickonec waha wisembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Eme wiac irec biŋe Efeso haeo Judaŋic â Grikŋic mana-fârerâ hâbi-jeŋic goroŋkewec. Ehuc Wofuŋ Jesu muteŋ bâteŋ ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Eme miti mamana bocjahazi fisirâ qâpucko wiac ejumbieŋ i buafec jaha mufua-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Á mârâc qaŋgecte gie bajumbieŋ jaŋe qaŋgec papia amecke-fârerâ hofao šocko rikembiŋ. Eme papia irec furine qâhâckepie siliwa moneŋ 50 tauseŋ qâririŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ŋic jaŋe iŋuc epie Wofuŋte dâŋzi ɋiɋicne jaha fua tâcnerâ ŋedâ qâdâmârewec. ");
INSERT INTO kmg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Paulo e gie iŋuc baku bafârerâ Makedonia â Akaia mâreŋ fotâc-jofârâ Jerusalem haeo raocte muwec. Ehuc šiŋuc muwec: “No Jerusalem haeo fisirâ mocwâc ware raku Roma haeo fisizepac.” ");
INSERT INTO kmg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Eme raocte babafic jahec -ticne Timoteo â Erasto sorec-jofame Makedonia mâreŋko bânierâ rapic. E jahacne ine Asia mâreŋkoa mocwâc piticne šuhuckerâ juwec. ");
INSERT INTO kmg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Eme dameŋ ira Efeso haeo mitire erâ hâpo ojowa sâko fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Siliwazi eri wiac bapa ŋic moc juwec, šâŋene Demetrio. Ŋic eki Atemis nemu ufuŋ-ticnere hawari piic piic siliwazi bame feme ŋic jaŋe furine bapie e â gieŋic âgofâcne moneŋ bocjaha fua-jare jujec. ");
INSERT INTO kmg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Eme Demetrio e gieŋic âgofâcne hetumaŋ-joparâ šiŋuc jazawec: “Ŋicbureŋ, ŋoŋe gie-nâŋec izi hâcne moneŋ mafa bâfua-nâreekac i manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Eme ŋic moc warewec jukac, Paulo hâcne, ŋoŋe ere fuŋne hone manac eeŋgopieŋ, e Efeso haeonec â Asia mâreŋ gâcnaonec ŋic wemo afecne maŋ bâsifuc ejarehuc šiŋuc jazaekac: `Ŋicmezi bakicne nemuɋâŋ i wiac fâri tâmiric. Ž ");
INSERT INTO kmg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","E iŋuc eme gie-nâŋec šâŋemâc eocmu sawa mâcne, nemu sâko-nâŋec Atemis ere ufuŋ i qoroc heocmu, erâ Atemis e jahacne šâŋe biŋe wâc rârâŋneocmu. Eme Asia mâreŋkonec â mâreŋ gâcnaonec ŋic mâmâc sasawa araŋ bacneeŋgopieŋ iŋucnere šâŋe biŋe weniŋuc omaeocmu?” ");
INSERT INTO kmg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Demetriozi dâŋ iŋuc jazame manarâ maŋjeŋic aaric fusucmame owackehuc šiŋuc mumbiŋ: “Efeso haeonec Atemis e fekicne sâko!” ");
INSERT INTO kmg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Dâŋ oowac sâko epie haeŋic mâmâc sasawa maŋjeŋic iŋneme kike saoŋ qajareme fisi qâture-fârerâ tutumaŋ toma-jeŋicko rafârembiŋ, ehuc Makedonia ŋic jajahec Paulo bâjâpepic, šâŋe-jekic Gaio â Aristako, jahe rocjofarâ fârec-jofa rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Eme Paulozi manarâ ŋic tutumaŋko razo mume opâ ruac jaŋe sakarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Erâ wâc ŋic fekicne gâcne Paulore âgofâc jumbiŋ jaŋe ŋic tutumaŋko mi raocte mumuac dâŋ erao râepie rawec. ");
INSERT INTO kmg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Eme tutumaŋ tomao ira ŋic jaŋe dâŋ ojowa fetone fepie dâŋ sifuc gafuckewec, ehame gâcne sâkozi wemo wiacte eŋgopieŋ muhuc kâuc bambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ŋic jaŋe iŋuc ehuc domahapie Judaŋic jaŋe âgo-jeŋic moc, šâŋene Alesande, e ŋicguru šâšâŋiŋko domahame mu âke suec ecnepie dâŋšaeo ferâ dâŋ mu bâšâziŋ eocte ŋic me bazuc ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Eme ŋic jaŋe e Judaŋic iŋuc hone tararâ micjeŋic sâc dameŋ šora owa ruruckehuc šiŋuc muhuc domambiŋ: “Efeso haeonec Atemis e fekicne sâko!” ");
INSERT INTO kmg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ekuhapie qâreŋŋic eki dâŋjeŋic bâniniŋkeku bâmâteŋ-joparâ šiŋuc jazawec: “Efeso ŋicbureŋ, hae širec ŋiczi Atemis sâko-nâŋecte ufuŋ â sambâŋkonec ɋâŋticne wahawec irec soŋaŋ rau jueŋgopeneŋ, i mâreŋ wenirecnec moczi kâuc baocmu? ");
INSERT INTO kmg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","I aricne, irec ŋoŋe maŋŋeŋic fâre wahame wiac kosa mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ŋic qoric-jopaŋgopieŋ jaŋe nemu-nâŋecte ufuŋkonec wiac moc ro soŋsoŋ me Atemis mu surec eecne i me embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Me Demetrio â gieŋic âgofâcne jaŋe ŋic mocte manapie sâqorekacko dâŋbahac mumu šâfo maickeme kia juŋgopieŋ jaŋerao munšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Me ŋaŋacne dâŋ moc fokacko micne bapa tutumaŋko baranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ŋoŋe miŋecgac bâbâiŋ epie maŋgâŋko šika fuazo ejec, irec dâŋ ŋicwofuŋ sâkozi manarâ hefârec-nâpome iŋuc me iŋuc âzâcnepene maname tatarane mi fokac.” Qâreŋŋic eki dâŋ iŋuc murâ jazame râwiŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dâŋ ojowa sâko arictac eme Paulozi opâ ruac hefârec-joparâ jaza mâzoc erâ Makedonia mâreŋko rawec. ");
INSERT INTO kmg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mâreŋ i fotâcnehuc opâ ruac jurambiŋ jaŋe mu keteŋ bocjaha ejare rawec. Raku Grië mâreŋko fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ira mosa jahec â moc juku hâwecko hurâ wokeo ferâ Siria mâreŋko razo mume Judaŋic jaŋe somâ râecnepie manarâ Makedonia mâreŋko rawec. ");
INSERT INTO kmg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Eme ŋic šiŋuczi hatao bâjâpembiŋ: Berea haeonec Sopate, e Pirore ŋokâ, Tesalonike haeonec Aristako â Sekundo, Derebenec Gaio, erâ Timoteo, â Asia masunaonec Tikiko â Trofimo. ");
INSERT INTO kmg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ŋic izi bânierâ Troa haeo woŋec-nâŋec jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nâŋe ine goreŋ sowa hombaŋ tarame Filipi haeo wokeo ferâ šoaŋ 5 raku Troa haeo fisimbeŋ. Ira fisirâ šoaŋ gie bapa 7 jumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Eme nâŋe Sondao Ŋafe Tiwâ nanaŋte tumaŋnembeŋ. Ehuc Paulo e hae fureme raocte murâ miti muhuc juhame ŋafe šâŋiŋke-jâmbâŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Fic maŋne ŋembeŋ ira lambe bocjaha šawec. ");
INSERT INTO kmg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ehame motec moc šâŋene Eutiko, e Paulozi miti mume šorame qâqâtâc kataŋko ŋeku guŋ qâmâckewec. Erâ guŋko qâqâtâc kataŋkonec hurâ mâreŋko qarâ fohame bafaharepie hâmocne ewec. Fic maŋne jahec â moc hâŋ bafehuc âke tâcne fekicne irecnec hâcne hurâ qawec. ");
INSERT INTO kmg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Eme Paulozi hurâ motec fofackerâ hâporâ ŋic šiŋuc jazawec: “Ŋoŋe ki ojowa mi eniŋ, e mâro-ticne fuakac.” ");
INSERT INTO kmg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iŋuc murâ ficmaŋko ferâ ŋafe Tiwâ gumec-joparâ nânâ piticne nâwec. Nânâ nârâ jaŋehec mitire muc manac ehuc juhapie hae furewec. Hae fureme behec-joparâ rawec. ");
INSERT INTO kmg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ŋic jaŋe ine motec ɋâreme ficticnao jowa rarâ bujeŋic boc urue biaŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Gâcne nâŋe Paulozi mume wokeo ferâ Aso haeo rambeŋ. E jahacne ine tiŋko fâwec. ");
INSERT INTO kmg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Eme Aso haeo fârâ bâfuac-nâporâ wokeo hefârâ qâsuec-nâpome mâmâc rambeŋ. Raku Mitilene haeo rašimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Irecnec raku hae fureme Ʒintacko Kio nucko fisirâ jâurumbeŋ. Izi raku Mituoc Samo nucko fisimbeŋ. Eme irecnec raku Sekiqanâcko Milete haeo fisimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo e Mâro hombaŋko Jerusalem haeo ra fisiocte muwec. Irec Efeso haeo wokeonec waharâ Asia masunao juhame dameŋ qâtirizacte fofotâc raku Milete haeo fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ira fisirâ kiŋaŋ sorec-jopame Efeso haeo rarâ mitire micne bapa jowac-jopapie warembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Fisipie Paulozi dâŋ šiŋuc jazawec: “No Asia mâreŋko fisirâ izia ŋoŋerao gie-nane fuŋkerâ wiac ehuc jupo, i fuŋnaonecteaŋ mana wareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","No hone suŋgiŋnezi ki busâqochec Wofuŋte kiŋaŋ qahuc jupo, ehuc Judaŋic jaŋe keke suec suec enarehapie râsi faio jupo. ");
INSERT INTO kmg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Erâ dâŋ ŋoŋe ŋaŋazane moc mi bâtiripe fowec, ŋoŋe biaŋkeniŋte mitidâŋ bocjaha hofao â ficne ficne ŋaza qazuc ehuc jupo. ");
INSERT INTO kmg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ehuc Judaŋic â Grikŋic Anutu maickerâ Wofuŋ-nâŋec Jesu Kristo manasiŋkeniŋte maŋqaqa eŋarehuc jupo. ");
INSERT INTO kmg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Eme ši Mârozi maŋnane niŋgiŋko fâreme Jerusalem haeo rakopac. Erâ ocna ra fisipe wiac weniŋucne moc fua-nareocmu i mi mana-hâmokopac. ");
INSERT INTO kmg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mâc kâpâcwâru â bušâic ocna woŋec-nane fokac, i hae sâc fisi fisi jupe Tiri Mârozi mufua-nareekac. ");
INSERT INTO kmg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","No ine juju-nanere manape furi sâko mi ekac, mâc hata mušâwe-narekicne i buafec jaha âte tarapemurâ enarekac, â Anutu aki anonoc-ticnere Biŋebiaŋ muiŋnepemurâ Wofuŋ Jesuzi munarewec, gie i baku bâjomirepemurâ maŋnane domakac. ");
INSERT INTO kmg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Erâ ši moc mupe mananiŋ, no uucmaŋte biŋedâŋ ŋazahuc ŋondeŋ-ŋeŋicko ŋeŋe juju epe honecnueŋgopieŋ izi šâhec šâŋe mai-nane mocwâc mi honeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","No Anutuzi mitire dâŋ šaeckewec i furu jaha ŋaza-fârepo, moc mi hetarape fowec” ");
INSERT INTO kmg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","irec miŋecgac hazec qâuŋ ŋazape mananiŋ, moc e sipirickeme kiŋticne norao mi foocmu. ");
INSERT INTO kmg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Ŋoŋe ŋaŋac soŋaŋ babac ehuc lama gurufâc-ŋeŋic iŋuc jaha sâcne soŋaŋ-jopanšepieŋ. Tiri Mârozi jaŋere micne bapa mucŋopawecte ŋoŋe Wofuŋte kikefuŋfâc, e jahacne soczi kitâc-jopawec, jaŋe hone maiŋ ejarehapie aimuŋ junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","No manakopac, no behec-ŋopape kâte qâto mimicne ŋoŋerao fisirâ lama mi akic-jopaniŋmu, ");
INSERT INTO kmg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","erâ wâc ŋaŋacne ŋondeŋko ŋic fuarâ miti bâsifuckerâ opâ ruaczi jaŋacne eniŋte hume gegetâc ejareniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Irec ŋoŋe rucgereŋ-ŋeŋic junšepieŋ, erâ jara jahec â moc ŋafe furec ki busâqochec uŋsawaŋ buc buc ŋaŋaza i moc mi behepe wahawec, ŋoŋe irec manasuhuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Eme ši Anuturao râec-ŋopahuc uruc jauŋ dâŋticnao guruc-ŋopakopac” e tâpiri runezi hofâ ɋâcgie sâcne eŋareocmu, erâ juku maŋfuru bacjopakicne sasawa jaŋehec sambâŋte huhure i tahac-ŋopame rauckenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","No moneŋ mafare mubâre mi eŋarepo, ");
INSERT INTO kmg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","no nahacne â ŋicfâc-nane nâŋere wiac piticne mejahec-nane šizi hotâckepe fua-narewec, i manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","No wiac fuŋne fuŋne qaŋeŋke-ŋarepo, ehuc gie ɋicwânšâŋ bahuc gegec dodocne jaŋe bâmec bajarezo irec hatane wâc âtehuc ŋowatupo. Eme ŋoŋe ijaha âtehuc Wofuŋ Jesuzi dâŋ kecšiŋuc muwec i manasunšepieŋ: `Bâmec ro nâc eere bubiaŋzi mâcne, bâmec babajare irec bubiaŋzi fârine jâmbâŋ eekac. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo e dâŋ iŋuc mutararâ dieŋzi herâ jaŋehec numuwec. ");
INSERT INTO kmg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Numume kio ŋâŋâtâc boc ehuc hâpo mumuduc ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","E dâŋ kecšiŋuc jazawec: “Ŋoŋe šâŋe mai-nane mocwâc mi honeniŋmu”, irec boc mana hâhâtâwembiŋ. Eme wokeo râembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Eme nâŋe jaŋe hetarac-joparâ fâretiŋ jaha raku Ko nucko fisimbeŋ. Hae fureme Rodo nucko raširâ raku Patara haeo fisimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ira woke moc Foinike mâreŋko raocte šawiehame bâfuarâ ira ferâ rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Raku Kipiro nuc honerâ qanaopec ŋehame mâc jâurumbeŋ. Erâ Siria mâreŋkopec raku Tiro haeo fisimbeŋ. Ira wokezi mafa hesie-fârehame ");
INSERT INTO kmg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","nâŋe haeo ferâ mitiŋic bâfuac-joparâ jaŋehec šoaŋ 7 jumbeŋ. Eme Mârozi ejareme jaŋe Paulo Jerusalem haeo mi raocte mu hezuc ecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ira juhapene rara dameŋ maickeme ŋic ŋokac naru motec mâmâc sasawa moŋgeŋko jowac-nâpopie humbeŋ. Erâ moŋgeŋko dieŋzi herâ numumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Numurâ mâmâzoc erâ wokeo fehapene jaŋe haeo risiembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Eme Tiro haeonec raku Tolemai haeo fisipene wokeo rara i tarawec. Eme ira mitiŋic iqic-joparâ ŋafe mocjaha jaŋehec fombeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Hae fureme raku Kaisarea haeo fisirâ Filipo bâfuambeŋ. Filipo e babafic 7 râec-jopakicne jaŋere guruonec. Ere ficko hâcne fembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","E otâfâcne 4 šeŋoŋ jumbiŋ jaŋe findaŋdâŋ mujumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Eme ira šuhuckerâ juhapene Judaia mâreŋkonec porofete moc šâŋene Agabo e nâŋerao fâ fisiwec. ");
INSERT INTO kmg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Fisirâ Paulo umbika-ticne rorâ izi jahacne me kike qarâ muwec, “Tiri Mâro e kecšiŋuc mukac: `Umbika rune e Jerusalem haeo ra fisime Judaŋic jaŋe šiŋuc hâcne ecnerâ qâpuc jaŋere meo râeniŋmu. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Dâŋ iŋuc mume nâŋe mecne â hae fâri mecne Paulo Jerusalem haeo mi feocte bâmâckehuc âzâcnembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Âzâcnepene šiŋuc muwec: “Wemocte boc kiohuc bu heheric enareŋgopieŋ? No Jerusalem haeo kâpâcwâruo fepere sawa mâcne, Wofuŋ Jesure erâ hâmopere wâc šawiekopac.” ");
INSERT INTO kmg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dâŋ âzâcnepene mi maname beherâ šiŋuc mumbeŋ: `Wofuŋte dâŋ sanaŋkezejec.” ");
INSERT INTO kmg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ʒoaŋ gie bapa gâcne tarame Jerusalem haeo fenaŋte šawiembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Eme Kaisarea haeonec mitiŋic gâcne jaŋe jowac-nâporâ ŋic moc šâŋene Ŋasoŋ, e mitiŋic raŋɋane Kipiro nucko fuawec, ere ficko hâcne râec-nâpombiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Eme raku Jerusalem haeo fisipene irecnec mitiŋic jaŋe 390 jauŋ enârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Eme hae fureme Paulozi Jakobore ficko jowac-nâpome fembeŋ. Ferâ juhapene mitire micne bapa gâcne fisi-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Fisipie Paulozi mejeŋicko barâ, Anutuzi neŋgoc ŋesiŋ ŋecnehame qâpuc jaŋerao miti gie bame fârine fuawec, irec dâŋ binaŋ ninic jaha ejarewec. ");
INSERT INTO kmg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Paulozi dâŋ binaŋ ejare tarame Anutu muteŋkerâ Paulo šiŋuc âzâcnembiŋ: “Manakic, qomâ-nâŋec Paulo, Judaŋic tauseŋ guru wemo afecnezi Jesure kikefuŋ embiŋ juŋgopieŋ. Eme jaŋe mâmâc sasawa sâcmutâc dâŋ šoɋac erâ dopeckeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ehame gore dâŋ šiŋuc wareme manaeŋgopieŋ: `Judaŋic qâpuc jaŋere ŋondeŋko juraŋgopieŋ jaŋe Mosere dâŋ qikiŋneniŋte jazaekac, ehuc ɋiefâc-jeŋic jaŋere sahacko ma mi bajareniŋte muac-jopaekac, â Judaŋic juju hata-nâŋec beheniŋte qafeŋ-jopaekac. Ž ");
INSERT INTO kmg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hae širec ŋic jaŋe gore iŋuc manaeŋgopieŋte weniŋuc ezo? Go Jerusalem haeo waremec irec biŋe mana-fâreniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Irec nâŋe dâŋ moc gazapene ezemec. Nâŋerao ŋic 4 juŋgopieŋ, jaŋe Anuturao mumupaŋ-jeŋic râembiŋte qizec-jeŋic mi bâbâtâc mâc jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Eme nâŋe jaŋerao šuhucgupene jaŋere sâcko wiac ehuc tiwâ bâzi furine bajaretec rikerâ qizec-jeŋic bâtâcnenšepieŋ. Go iŋuc etecne honecgurâ gore šiŋuc mananiŋmu: Dâŋticne wareme manambeŋ i fârimâc, e sâcmutâc dâŋ reŋkehuc juekac wâc. ");
INSERT INTO kmg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Á qâpuckonec opâ ruac jaŋe nemuɋâŋte taha bâzi, qowisoc, qowi bituakicne â sasec boe sau irec sawa bâec baniŋte mupaŋke-jarembeŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Eme Paulo e dâŋjeŋic manarâ ŋic 4 jaŋerao šuhuckeme hae fureme sahac ŋaqi wiac-jeŋic šure emasaŋ erâ taha ufuŋko fembiŋ. Ferâ Paulozi mumupaŋ dameŋ tatarare â bâzi ririkere dâŋ taha bapa jaŋe jazawec. ");
INSERT INTO kmg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ʒoaŋ gie bapa 7 wiac ehuc juniŋte mumbiŋ i tarazo eha Paulozi taha ufuŋko ferâ juhame Asia mâreŋkonec Judaŋic jaŋe e honerâ ŋic mâmâc sasawa maŋjeŋic bâiŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ehuc Paulo rorâ kuku qajarehuc mumbiŋ, “Oe, Israe ŋicbureŋ, ware bafic-nâponiŋ¡ Ŋic šizi mâreŋ sâc jurahuc Judaŋic nâŋâc râsi enârehuc sâcmutâc dâŋnâŋec â ufuŋ-nâŋec ši mu qâsuac ehuc juekac. Erâ wâc ufuŋ-nâŋecko Grikŋic jowac-jopame wefuhuc furufic ši gâc hecneŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Paulo e Efeso haeonec ŋic Trofimo ehec haeo rac warec eme honerâ mana sifuckehuc mumbiŋ, taha ufuŋko jowa wefujec. ");
INSERT INTO kmg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Paulo e iŋuc ecnepie haeŋic mâmâc sasawa kike saoŋ qajareme ɋuruŋ herâ qâture-fârembiŋ. Ehuc ŋic gâcnezi Paulo rorâ ufuŋkonec fâre wahambiŋ. Fâre wahapie izia motâc hembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ŋic jaŋe Paulo rorâ qâhâmozo ehapie biŋe Roma momori jaŋere soŋaŋ sâkorao rame šiŋuc manawec: “Jerusalem ŋic jaŋe mâmâc sasawa râsi roroc eŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Dâŋ iŋuc manarâ izia momori fekicne wahakicne rocjopame ɋuruŋ ɋuruŋ rambiŋ. Eme ŋic jaŋe Paulo qahuc juhapie soŋaŋ sâko â momorifâc-ticne fisipie honec-joparâ behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Eme momori soŋaŋ sâkozi fisirâ Paulo jowac rorâ mume kâpâcwâru jajaheczi bândeŋnembiŋ. Erâ Paulo šâŋe-ticnere â wemo wiac ewec irec iindiŋ gie bawec. ");
INSERT INTO kmg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Eme ŋic jaŋe owage owa-nane epie qâsifuo dâŋ fuŋne sâcne mi mana-hâmohuc mume momori jaŋe Paulo ficjeŋicko barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Eme Paulo e ririo fezo eme ŋic jaŋe orâŋkerâ bâbâzickepie momori jaŋe Paulo hâporâ reŋke fembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ŋic guru sâko jaŋe bâjâpec-jopahuc owac owacke rahuc šiŋuc mumbiŋ: “Ŋic e arictac eoc!” ");
INSERT INTO kmg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Eme Paulo ficmaŋko bafezo ehapie momori soŋaŋ sâko wiocnerâ muwec, “Manatec dâŋ moc gazape?” Mume soŋaŋzi muwec, “Go Grikdâŋ manaekic? ");
INSERT INTO kmg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mârâcko Aigita ŋic moczi šika bâfuaocte râsi 4 tauseŋ rocjopame mâreŋ tuhuo rambiŋ, go ŋic e me moc?” ");
INSERT INTO kmg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Wiocneme Paulozi šiŋuc âzâcnewec: “No Judaŋic, erâ Kilikia mâreŋko Taso hae sâko ŋekac irec rune. Go mana-naretec ŋic dâŋ piticne jazape.” ");
INSERT INTO kmg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Eme manacneme Paulo e riri botâŋko domahuc ŋic me bazuc ejareme dâŋemâc efârepie Judaŋic jaŋacne dâŋkoa kecšiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Âgofâc-nane â kâcɋenefâc-nane, no nahacne fuŋne ŋazape mananiŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Paulo e iŋuc muhuc Judaŋic jaŋacne dâŋko dâŋeme manarâ qiriŋ niniŋ jâmbâŋ efârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Eme šuhuckerâ jazawec: “No Judaŋic, Kilikia mâreŋko Taso haeo fuapo. Erâ hae šira mamana ficko juku sokapo. Qaqazu Gamalie ere maŋfuŋko juhape miti qazu-nareme kâcɋenefâc-nâŋec jaŋere dâŋ aimuŋ anonocke-fârepo. Ehuc ŋoŋe miŋecgac eeŋgopieŋ noni iŋuc jaha Anuture erâ hume kikiŋ faio juhuc sasanaŋ epo. ");
INSERT INTO kmg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ehuc miti ɋâricne ši omaeocte no râsi ecnehuc ŋic mecne ŋokac mecne mâmâc jaha niŋgiŋ-joparâ kâpâcwâru ficko râec-jopahuc jupo. ");
INSERT INTO kmg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Taha bapa sâko â micne bapa guru jaŋe nore fuŋne manaeŋgopieŋ. Jaŋe hâcne âgofâc-nâŋec Damasko haeo jueŋgopieŋ jaŋere papia qâreŋkerâ narepie kecšiŋuc muhuc barapo: No ocna ŋic ŋokac iŋucne bâfuac-joparâ niŋgiŋ-joparâ Jerusalem haeo bacjopa warepe okacne jarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Iŋuc muhuc hata raku šoaŋ šâšâŋiŋko Damasko hae bâqiŋkehape sambâŋkonec šoc tatamac sâkozi uŋ herâ waha âkecnuwec. ");
INSERT INTO kmg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Âkecnuhuc herândiŋnume mâreŋko fohuc dâŋ wiwira kecšiŋuc manapo: `Saulo, Saulo, go wemocte nu jâpec enarehuc jukomec? Ž ");
INSERT INTO kmg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Eme noni mupo, `Wofuŋ go mo? Ž Mupe šiŋuc nazawec: `Nu jâpec enareekic Jesu Nazarete haeonec no hâcne. Ž ");
INSERT INTO kmg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ŋic nohec jumbiŋ jaŋe šoc tatamac sawa honembiŋ, dâŋ nazawec ine mi manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Eme no wiohuc mupo, `Wofuŋ, no wemo epemurâ munarekomec? Ž Mupe Wofuŋzi šiŋuc nazawec: `Go faharerâ Damasko haeo ratec wiac ecmurâ mugarekicne i gazaniŋmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Eme šoc tatamaczi šâŋe-nane âke hâpowecte fipe dapâc eme ŋicfâc-nane jaŋe menaneo rorâ Damasko haeo bacnu rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Hae ira ŋic moc juwec šâŋene Anania, e sâcmutâc dâŋ aimuŋ bâninipehuc jume Judaŋic hae ijaha jumbiŋ jaŋe šeŋgoma ere manapie biaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ŋic izi hâcne norao fâ fisirâ šiŋuc nazawec: `Qomâ-nane Saulo, go šâŋe fitâcnec. Ž Mume izia fitâcnerâ e honepo. ");
INSERT INTO kmg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Eme dâŋ šiŋuc nazawec: `Mimiŋnefâc-nâŋec jaŋere Anutu eki fuŋne-ticne gaza gowatuc eme tiŋne rune honehuc micticnaonec dâŋ manacmurâ rowosâecguwec. ");
INSERT INTO kmg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Eme go wiac hone manac emeŋ irec biŋe mâreŋ sâc ŋic jaza razemec. ");
INSERT INTO kmg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eme ši weniŋuc mâc jutec šoraocmu? Go faharerâ Jesure šâŋe riwasecketec Miti Opâ rua-garepe sâqocnege tâmirezejec.' ");
INSERT INTO kmg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Eme no Jerusalem haeo risierâ taha ufuŋko ferâ numupe maŋnane ŋerisieme Jesu honepo. ");
INSERT INTO kmg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Honepe šiŋuc nazawec: `Hae širec ŋic jaŋe gore mickonec dâŋnane manarâ qikiŋneniŋmu, irec go picpac Jerusalem-konec wiserâ rac. Ž ");
INSERT INTO kmg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mume no dâŋ šiŋuc bâtikiecnepo: `Wofuŋ, no ŋicfâcge kâpâcwâru bacjoparâ mitificne ficne bacjopa ferâ kâcbiŋzi jopahuc jupo, ");
INSERT INTO kmg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","erâ biŋe mumuge Stefano qaniŋte ŋaqi-jeŋic guruckepie soŋaŋke-jarehape qapie manape sâckewec, i hae širec ŋic mana-fâreŋgopieŋte gore biŋe sâcne jazapemu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Iŋuc mupe Wofuŋzi šiŋuc nazawec: `Go šawietec no mâreŋ wiwicko qâpuc jaŋerao sorecgupe razemec. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ŋic jaŋe hazec-jeŋic râehapie Paulozi dâŋ gâcne jazawec. Izi miŋecne dâŋ iŋuc mume ɋeŋɋeŋnea owa ruruckerâ mumbiŋ, “Ŋic iŋucnezi arictac eoc, jume mamakâcne ekac.” ");
INSERT INTO kmg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Iŋuc owackehuc ŋaqi-jeŋic šoricne hetararâ rufe tiepie feme ");
INSERT INTO kmg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","soŋaŋ sâkozi mume momori jaŋe Paulo ficjeŋicko bafembiŋ. Erâ ŋic jaŋe wemo wiacte boc owackecnembieŋ irec fuŋne mufuame manazore kâcbiŋzi qaniŋte mujarewec. ");
INSERT INTO kmg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Eme jaŋe kâcbiŋzi qaniŋte fâretiŋkerâ becsahaczi bândeŋnezo epie Paulozi micne-jeŋic šiŋuc muhuc wiocnewec: “Ŋoŋe Romaŋic fârine dâŋticne mi mutarahuc kâcbiŋzi qapie sâckeocmu me?” ");
INSERT INTO kmg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Iŋuc mume micne-jeŋiczi soŋaŋ sâkorao rarâ âzâcnerâ muwec, “Weniŋuc ezo? Ŋic e Romaŋic fârine.” ");
INSERT INTO kmg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mume soŋaŋ sâkozi Paulorao rarâ wiocnerâ muwec, “Go muc, go jâmbomac Romaŋic fârine?” Eme Paulozi muwec, “I jâmbomac.” ");
INSERT INTO kmg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mume soŋaŋ sâkozi šiŋuc muwec: “No ŋic jabanezi moneŋ bocjaha rope kitâcnume Romaŋic jâmbâŋ epo.” Eme Paulozi muwec, “No ine fufua-nane Romaŋic fuapo.” ");
INSERT INTO kmg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Eme izia Paulo wiac ecnezo mumbiŋ i behembiŋ. Momori soŋaŋ e ine, Paulo e Romaŋic, iŋuc manarâ, no wemocte ŋic iŋucne kâpâcwâru bapac muhuc fâfârewec. ");
INSERT INTO kmg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Hae fureme momori soŋaŋ sâko e Judaŋic jaŋe Paulo wemo wiacte mana sâqorecnembiŋ irec fuŋne jâmbâŋ manaocte taha bapa micne â micne guru furu jaha ejareme tumaŋnembiŋ. Ehame Paulo jowa hurâ tutumaŋ-jeŋicko râewec. ");
INSERT INTO kmg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo e micne bapa hone dendeŋ-jopahuc dâŋ šiŋuc jazawec: “Ŋic âgofâc-nane, no sâcmutâc dâŋ qaqatarare maŋnanezi mumu hehec moc mi enareha Anuture maio juwefuhuc jupozi jukopac.” ");
INSERT INTO kmg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Iŋuc mume taha bapa sâko Anania eki ŋic Paulore maŋfuŋko domambiŋ jaŋe šiŋuc jazawec: “Ŋoŋe masunao qaniŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mume Paulozi šiŋuc âzâcnewec: “Maŋge tâŋzi qakicne go Anutuzi guocmu. Go sâcmutâc dâŋte sâcko norao mumutiŋ gie bazo mukiczi wemocte sâcmutâc dâŋ qâsuahuc nuniŋte jazakic?” ");
INSERT INTO kmg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Iŋuc mume ŋic doma rambiŋ jaŋe šiŋuc âzâcnembiŋ: “Go Anuture taha bapa sâko wemocte musoriŋkekic?” ");
INSERT INTO kmg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Mupie Paulozi šiŋuc muwec: “Âgo bureŋ, e taha bapa sâko jukac i mi manahuc dâŋepac. Mitio dâŋ kecšiŋuc qâreŋkekicne: `Go micne bapa mi musâqorec-jopazemec. Ž No dâŋ i manaekopac.” ");
INSERT INTO kmg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Eme micne guru ŋic tucne sadukaio â tucne farisaio ŋic jumbiŋ, Paulozi i manahuc dâŋ baferâ šiŋuc jazawec: “Ŋicbureŋ, no farisaio ŋic â apa ŋosafâc-nane jaŋe farisaio ŋic jaha jumbiŋ. Hâmockonec fafahare fokac dâŋ i dopeckeekopacte dâŋko râecnuŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Dâŋ iŋuc mume farisaio ŋic â sadukaio ŋic jaŋe qaqatarac epie micne bapa jaŋerao fâfâuc fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadukaio ŋic jaŋe hâmockonec fafahare â aŋelo â sawa qâqâtâc, wiac iŋucne micke-fâreeŋgopieŋ. Farisaio ŋic jaŋe ine irec fârine mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Eme irec tutumaŋ-jeŋicko ojowa sâko bambiŋ. Eku farisaio ŋic jaŋere guruonec miti qaqazu gâcne faharerâ dâŋ fârone kecšiŋuc mumbiŋ: “Nâŋe ŋic kecširec kiŋ manapene aricne ekac” aŋelo me sawa qâqâtâc moczi dâŋ âzâcnewecko weniŋuc moc munaŋmu?” ");
INSERT INTO kmg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Eme fecko fefec mâretec epie momori soŋaŋ sâko e Paulo qâsuckenšipiŋte hâwickeme mume momori jaŋe fisirâ Paulo ŋicŋondeŋkonec fâre waharâ ficjeŋicko barambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Eme ŋafe ira Wofuŋzi Paulo fuacnerâ šiŋuc âzâcnewec: “Go hâbige roc, šira Jerusalem haeo mutaniŋnukomec iŋuc jaha Roma haeo mutaniŋnuzemec.” ");
INSERT INTO kmg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Hae fureme Judaŋic gâcne šâšâfic erâ nânâ sowa jujâmbâŋkeku Paulo qarâ nânâ opâ nâniŋte mumundeŋ embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ŋic šâšâfic erâ iŋuc mumbiŋ šare-jeŋic 40 jâuruwec. ");
INSERT INTO kmg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ŋic jaŋe hâcne taha bapa micne â soŋaŋ jaŋerao rarâ mufua-jarerâ šiŋuc jazambiŋ: “Nâŋe nânâ sowa jujâmbâŋkeku Paulo qarâ wiac nanaŋte mumundeŋ embeneŋ” ");
INSERT INTO kmg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","irec micne bapa ŋoŋe momori soŋaŋ sâkorao dâŋ šiŋuc râepie razejec: `Go Paulo nâŋere tutumaŋko soretec wareme dâŋticne mocwâc muhâmonšepeneŋ. Ž Eme dâŋŋeŋic manarâ iŋuc eme nâŋe Paulo hatao qanaŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Eme Paulo baŋec-ticnezi šikadâŋ i manawec. Manarâ momori ficko rarâ wawa-ticne âzâcnewec. ");
INSERT INTO kmg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Âzâcneme Paulozi momori jaŋere micne moc wiracnerâ šiŋuc âzâcnewec: “Go motec ši momori soŋaŋ sâkorao jowa ratec dâŋ moc âzâcneoc.” ");
INSERT INTO kmg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mume ŋic eki motec soŋaŋ sâkorao jowa rarâ šiŋuc âzâcnewec: “Kâpâcwâru ŋic Paulo eki wira-narerâ nazame motec ši dâŋ gazaocte jowape warekoperec.” ");
INSERT INTO kmg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Iŋuc muhuc âzâcneme soŋaŋ sâkozi motec menao rorâ herâricnao bararâ wiocnerâ muwec, “Dâŋ weniŋuc nazacmu?” ");
INSERT INTO kmg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Eme moteczi šiŋuc âzâcnewec: “Judaŋic jaŋe gorao dâŋ râepie wareocte muc manac embieŋ, jaŋe go Paulo tutumaŋ-jeŋicko jowa rarâ fuŋne-ticne bataniŋke-hâmocmurâ gazaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Gazapie dâŋjeŋic mi manazemec. Ŋic šare-jeŋic 40 jâurukac, iŋuczi Paulo qâhâmoniŋte muŋgopieŋ. Jaŋe nânâ sowa jujâmbâŋkeku Paulo qarâ wiac nâniŋte mumundeŋ embieŋ, erâ biac šawierâ gore dâŋte woŋec juŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Motec e dâŋ iŋuc mume soŋaŋ sâkozi šiŋuc muhuc sorewec: “Go dâŋ mufuarâ nazakomec i ŋic moc mi jazazemec.” ");
INSERT INTO kmg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Eme soŋaŋ sâkozi momori jaŋere micne jajahec hefârec-jofarâ šiŋuc jasawec: “Ŋohe mupire momori kikezi hata rara 200 â becâsicko rara 70 â damu bapa 200 izi šawierâ ŋafere 9 kiloë ehame Kaisarea haeo ranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Erâ Paulore becâsic moc sate hecnenšepieŋ. Eme aimuŋ soŋaŋkehuc kia Feliki erao baranšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iŋuc murâ kiare papia moc šiŋuc muhuc qâreŋkewec: ");
INSERT INTO kmg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Klaudio Lisia noni kia biaŋ-nane Feliki gore papia ši qâreŋkekopac. ");
INSERT INTO kmg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Momori jaŋe ŋic moc bafâŋgopieŋ e Judaŋic jaŋe qazo embiŋ. Eme noni e Romaŋic jâmbâŋ ere iŋuc manahuc momori jaŋehec rarâ mejeŋickonec batarambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Eme dâŋko râembiŋ irec fuŋne manapemurâ micne bapa tutumaŋ-jeŋicko barapo. ");
INSERT INTO kmg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bararâ sâcmutâc dâŋjeŋicte qorickepie šiŋuc manapo: Wiac ewec izi ferâ šika kâpâcwâru bâbâfuane mi ekac. ");
INSERT INTO kmg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eme ŋic gâcne jaŋe somâ barâ Paulo qaniŋte mupie manarâ gorao sorepe fakac hâcne. Á qorickeeŋgopieŋ ŋic i jaŋe iŋuc jaha ejarepe gorao fârâ dâŋticne gazanšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Eme momori jaŋe soŋaŋ-jeŋicte mic reŋkehuc Paulo ŋafeoa jowa raku Antipatri haeo fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Hae fureme momori gâcne jaŋe ficjeŋicko risiehapie becâsicko ŋeŋe jaŋe buc Paulo jowa raku Kaisarea haeo fisimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Fisirâ kia papia râcnehuc Paulo iŋuc jaha ere meo râembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Eme kiazi papia woserâ Paulo mâreŋ qizec-ticnere wiocneme muwec, “No Kilikia mâreŋkonec.” ");
INSERT INTO kmg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Eme kiazi šiŋuc âzâcnewec: “Dâŋko râecguŋgopieŋ ŋic i jaŋe ware fisipie gore dâŋ muzo.” Iŋuc murâ momori jazame Herodere ficko râerâ soŋaŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ʒoaŋ gie bapa 5 tarame taha bapa sâko Anania e â soŋaŋ gâcne â dâŋŋic moc šâŋene Teatulo jaŋe Kaisarea haeo hurâ kiarao Paulore dâŋ muniŋte fuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Eme kiazi mume Paulo fisime Teatulozi e qorickehuc kia dâŋ šiŋuc âzâcnewec: “Kia biaŋ-nâŋec Feliki, go sâcne soŋaŋ-nâpotec wamaoa jueŋgopeneŋ, erâ ŋicguru ši nâŋere manabâc ehuc bafic-nâpotec ");
INSERT INTO kmg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","nâŋerao hae sâc wiac sasawa biaŋkeekacte gore manapene sâcke-hâmoekac. ");
INSERT INTO kmg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Erâ dâŋ mupe šorazacte go uruerâ mana-nâretec dâŋ bembeŋne mac gazape. ");
INSERT INTO kmg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ŋic kecirec manapene boc sâqorekac, e sopa sâwec-ticnehec, Judaŋic mâreŋ sâc juraŋgopieŋ jaŋe maŋbâiŋ ejareekac, erâ Nazarete rune repicnefâc-ticne jaŋere qizec eki hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Eme taha ufuŋ-nâŋec gâc hecnezo ehame rombeŋ, erâ nâŋe sâcmutâc dâŋnâŋecte sâcko wiac ecnenšapeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ehame ine kapiteŋ sâko Lisia eki fisi šocnehec nâwoc rowec. ");
INSERT INTO kmg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ehuc dâŋko râembiŋ ŋic i jaŋe gorao fisi fuaniŋte mujarewec.Ý Eme nâŋe dâŋ gazaŋgopeneŋ i go gahac mu esâic ecnehuc fuŋne sâcne bataniŋkecmu.” ");
INSERT INTO kmg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Dâŋ iŋuc mume Judaŋic jaŋe e bafickehuc dâŋticne dopeckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Eme kiazi Paulo mezi sâsâc ecneme dâŋ šiŋuc muwec: “Go mâreŋ šira jara bocjaha kia juekic i manasuhuc dâŋnane manabâc tâmiric mupemu. ");
INSERT INTO kmg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","No Jerusalem haeo Anutu mai ecnepemurâ ferâ juwarekupe šoaŋ gie bapa 12 sawa ekac, go dâŋ irec maŋjahec erâ ŋic esâic-jopatec gazaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","No taha ufuŋko me mitific gâcnao me miti haeo ŋic jaŋehec mitire mu qaqatarac me ŋic maŋbâiŋ eejare i moc mi epe honecnumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ŋic šizi qoricnuhuc dâŋ gazaŋgopieŋ, irec fârine wemocko gowatuniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Erâ moc mufua-garepe manac: Hata ɋâri sureeŋgopieŋ i âteekopac mueŋgopieŋ, ine jâmbomac eekopac. Erâ jaŋere dâŋmiti bajuhuc sâcmutâc dâŋqâhâcko miti qâreŋkekicne fokac â porofete mu qâreŋ embiŋ i manape fârine ehame mimiŋnefâc-nâŋec jaŋere Anutu kiŋaŋ qacneekopac. ");
INSERT INTO kmg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Erâ juku ŋic biaŋne â sâqocne hâmockonec fafahare maickeocmu, irec ŋic keci jaŋe â no mâmâc mamanac jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Iŋuc ehuc Anuture maio â ŋicmaio bahacmâc jupemurâ rucnane bahuc jaha juekopac. ");
INSERT INTO kmg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Eme no jara bocjaha mâreŋ wiwicko juhuc mitire moneŋ qânusuckeku Jerusalem haeo ŋic âgofâc-nâŋec jaŋerao warepo. ");
INSERT INTO kmg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Erâ bâzi ririkere bašawierâ taha ufuŋko ferâ juhape bâfuacnumbiŋ. Ira ŋicguruo juju me dâŋfânâŋ sâkohec juju ine arictac. ");
INSERT INTO kmg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Asia mâreŋkonec Judaŋic gâcne jaŋe ine iŋuc embiŋ. Jaŋe hâcne nore bahac moc manaŋgopieŋko gorao fisirâ mutaniŋkenšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Me micne bapa tutumaŋko domahape nore bahac moc bâfuambiŋko ŋic domaŋgopieŋ šizi gazaniŋ. ");
INSERT INTO kmg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Jaŋe no dâŋ mocjaha sawa ŋondeŋ-jeŋicko domahuc mupe manapie mi mecne sâckewec, ine hahaŋne bahuc kecšiŋuc jazapo: `Hâmockonec fafahare fokac, dâŋ i dopeckeekopacte gâcnezi dâŋko râecnupie mai-ŋeŋicko domakopac ši. Ž ” ");
INSERT INTO kmg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Kia Feliki e Paulore dâŋ i mi mutarahuc mâc râeme fowec. E miti ɋâricnere biŋe mana-hâmowecte šiŋuc sawa jazawec: “Momori soŋaŋ Lisiazi Jerusalem haeonec wahame dâŋŋeŋic mutarapemu.” ");
INSERT INTO kmg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Iŋuc murâ momori micne šiŋuc âzâcnewec: “Ŋoŋe Paulo soŋaŋkehuc râsi šâŋe mi ecnenšepieŋ, â âgofâcne fisirâ jauŋ bazo mupie mi qatara-jarenšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ʒoaŋ gie bapa tucne jurâ Feliki e Juda guruonec ŋonâŋ-ticne Drusila ehec mâmâc ŋehuc Paulo ecneme hefârâ Kristo Jesu manasiŋkembiŋ irec fuŋne jasawec. ");
INSERT INTO kmg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ehuc tiŋke biaŋ eere â sasecte sowa jujure â okac dameŋte mume Felikizi weaŋkerâ Paulo šiŋuc âzâcnewec: “Sâcne rac, juku nacnere dameŋ sawane moc fua-nareme mocwâc hefârecgupemu.” ");
INSERT INTO kmg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kia e Paulozi moneŋ narezejec muhuc dameŋ sâc hefârerâ ehec dâŋ muc manac ejujec. ");
INSERT INTO kmg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ehame jara jajahec tarame kia moc šâŋene Porkio Festo eki Feliki âkehockewec. Eme Feliki e Judaŋic bubiaŋ qajarehuc Paulo kâpâcwâru ficko ŋehame beherâ rawec. ");
INSERT INTO kmg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festozi kia erâ šoaŋ jahec â moc Jurâ Kaisarea haeonec Jerusalem haeo fewec. ");
INSERT INTO kmg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Fe fisime taha bapa micne â Judaŋic fekicne erao fisirâ Paulore dâŋ âzâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ehuc mana urue-jarerâ mume Paulo Jerusalem haeo fisiocte âzâcnembiŋ. Jaŋe hatao Paulo somâckerâ qaniŋte manasuhuc kia iŋuc âzâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mupie Festozi šiŋuc jazawec: “Paulo e Kaisarea haeo kâpâcwâru ficko ŋekac” eme no ijaha biac mocwâc risie hupemu. ");
INSERT INTO kmg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Paulo bahacdâŋ-ticne muzo murâ ŋoŋeraonec micne bapa nohec mâmâc hurâ munšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Iŋuc murâ šoaŋ 8 me 10 Jerusalem haeo jurâ Kaisarea haeo rahuwec. Izi hae fureme dâŋficko ferâ mume Paulo bafembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ficko feme Jerusalem haeonec Judaŋic jaŋe orâŋkerâ samarierâ qorickehuc domambiŋ. Erâ qoqoricte fârine mi fuawec. ");
INSERT INTO kmg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mupie Paulozi dâŋjeŋic bawahahuc šiŋuc muwec: “No Judaŋic sâcmutâc dâŋjeŋic me taha ufuŋ me Roma ŋicwofuŋ moc mi musuaekopac.” ");
INSERT INTO kmg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Eme Festozi Judaŋic bubiaŋ qajareocte Paulo indiŋkerâ muwec, “Go Jerusalem haeo jowacgu ferâ ira dâŋge mutarape me?” ");
INSERT INTO kmg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Indiŋkeme Paulozi šiŋuc âzâcnewec: “Roma ŋicwofuŋte dâŋfic šine hâcne” nore dâŋ šira mutarazo” go gahac fuŋne-nane manakic, no Judaŋic wiac hehesic moc mi ejarepo. ");
INSERT INTO kmg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","No bahac me kiŋsâko moc bâfuarâ muzac, nuzo mutec sahac-nane mi sakarezapo. Jaŋe ine burecko qoricnuŋgopieŋte moczi moc bubiaŋ qajarehuc jaŋere meo sâcne mi râecnu-jâmbâŋkeocmu. Irec ši Roma ŋicwofuŋzi dâŋnane mutaraocte mukopac.” ");
INSERT INTO kmg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Iŋuc mume Festo e ŋicfâc-ticne jaŋehec muc manac erâ Paulo šiŋuc âzâcnewec: “Ŋicwofuŋ sâkore mukomec, irec ŋicwofuŋ sâkorao razemec.” ");
INSERT INTO kmg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ʒoaŋ gie bapa tucne tarame ŋicwofuŋ Agripa â seŋticne Beanike jahe Kaisarea haeo hurâ Festo âgo bapic. ");
INSERT INTO kmg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Eme jahe šoaŋ gâcne ehec ŋeŋe juju ehapire Festozi Paulore dâŋ binaŋ ecnehuc ŋicwofuŋ šiŋuc âzâcnewec: “Felikizi kâpâcwâru ŋic moc beherâ rame ŋehuc jukac. ");
INSERT INTO kmg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Eme no fisirâ Jerusalem haeo fepe taha bapa micne â Judaŋic jaŋere soŋaŋ jaŋe norao tumaŋnehuc ŋic e qape hâmoocte munarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Munarepie no dâŋ ŋifecne šiŋuc jazapo: `Romaŋic nâŋe qoqoricte sawa ŋic moc šikare mi qikiŋneeŋgopeneŋ. Nâŋe ŋic dâŋko râekicne e mecne â dâŋrune mecne mâmâc hetumaŋ-jopapene ŋifec â ŋifec dâŋ sâckoa mueŋgopieŋ. Ž ");
INSERT INTO kmg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Iŋuc jazape Judaŋic norao warepie izia hae fureme jaŋe â e dâŋficko bâturec-jopapo. ");
INSERT INTO kmg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eme jaŋe ere sâqocne qizecne moc mufuaniŋmu muhape ");
INSERT INTO kmg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","jaŋe miti-jeŋicte hehefaric dâŋ â ŋic hâmokicne moc šâŋene Jesu ere dâŋ bajumbiŋ” ŋic ere hâcne Paulozi šiŋuc muekac: `E faharewec jukac. Ž ");
INSERT INTO kmg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Eme no dâŋ iŋucnere kâuc barâ Paulo Jerusalem haeo feme ira dâŋticne mutarapemurâ âzâcnepo. ");
INSERT INTO kmg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Âzâcnepe Paulo e Roma ŋicwofuŋzi dâŋticne mutaraocte muwec. Eme Paulo e rara dameŋ maickeme mupe Roma ŋicwofuŋtao raocte kâpâcwâru ficko woŋec jukac.” ");
INSERT INTO kmg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Festozi iŋuc muhuc âzâcneme Agripazi muwec: “No ŋic e hâcne dâŋ moc mume manapemurâ enarekac.” Eme Festozi muwec, “Sâcne, tomâcko manazemec.” ");
INSERT INTO kmg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hae fureme Agripa â Beanike jahe eri qaraweŋ-jekichec tutumaŋ ficko fepire momori soŋaŋ kâcɋene â hae irec ŋic fekicne mâmâc bâjâpec-jofarâ fembiŋ. Fefârepie Festozi mume Paulo bafembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Bafepie Festozi dâŋ šiŋuc jazawec: “Ŋicwofuŋ Agripa â ŋicfâc-nane gâcne dâŋ ŋazape mananiŋ. Ŋic domakac ši ere erâ Judaŋic wemo afecnezi Jerusalem haeo fotarie-narehuc wira owac erâ mumbiŋ, `E mi jujâmbâŋkezejec. Ž ");
INSERT INTO kmg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","No ine bahac-ticnere manape šika kiocte irec sâc mi ewec. Eme Roma ŋicwofuŋte muwecte erao sorepe raocmu. ");
INSERT INTO kmg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Erâ dâŋ fârine basahuc ŋicbomboŋ sâkore papia qâreŋkepemurâ fâcke turuŋ ekopac. Eme irec hâcne ŋic kecši e ŋoŋerao â ŋicwofuŋ Agripa gorao râepe domakac. Eme ŋoŋe fuŋne-ticne bataniŋkepie dâŋticne qâreŋkepe razejec. ");
INSERT INTO kmg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","No kâpâcwâru ŋic moc kiŋticnere dâŋ mi qâreŋkehuc Roma haeo mâc sorepe raocte manape quŋkekac.” ");
INSERT INTO kmg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Eme Agripazi Paulo šiŋuc âzâcnewec: “Gahac fuŋnege mutec mananaŋ.” Eme Paulozi meticne sicnerâ dâŋ šiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Judaŋic dâŋzi dâŋ enarehuc jueŋgopieŋ irec ŋifecne ŋicwofuŋ Agripa miŋecgac gore maio mupemurâ bunane biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Go hâcne Judaŋic mitire hehefaric-nâŋecte â wiac eenâŋecte fuŋne manaekic. Irec go mana uruehaŋtec dâŋnane mupe. ");
INSERT INTO kmg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“No motec ɋie-naneoa Jerusalem haeo ŋic âgofâc-nane jaŋere ŋondeŋko juku sokapo. ");
INSERT INTO kmg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Irec Judaŋic mârâc honecnumbiŋzi juju-nanere fuŋne manaeŋgopieŋ. No farisaio ŋic mitire neŋgocne embiŋ Jaŋere guruo hâcne jupo. Eme fuŋne-nane hone manac embiŋzi muzo murâ munšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","No kâpâcwâru ficko foekopac i wiac mocte mâcne, Anutuzi mimiŋnefâc-nâŋec biŋedâŋ jazawec, ");
INSERT INTO kmg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","eme dâŋ i fârinehec eocte Israe ŋicguru 12 jaŋe ŋafe šoaŋ qâqâtiri Anutu tiwâ bâzi rikecnehuc mai ecneeŋgopieŋ, ŋicwofuŋ-nane, biŋedâŋ irec hâcne Judaŋic jaŋe dâŋgie nareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Anutu e hâmokicne bâɋârec-jopaekac, i ŋoŋe wemocte manapie mi eene tinac eekac? ");
INSERT INTO kmg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Erâ no nahacnere mupe, no Jesu Nazarete haeonec ere šâŋe biŋe imackepe sifuckeocte gie-nane ewec. ");
INSERT INTO kmg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Jerusalem haeo iŋuc hâcne epo, ehuc taha bapa micne jaŋerao mupe pasi narepie opâ ruac wemo afecne kâpâcwâru ficne ficne râec-jopahuc jupo. Erâ šika kirâ hâmoniŋte mujarepie dâŋjeŋic dopecke jupac wâc. ");
INSERT INTO kmg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Judaŋic jaŋere mitificne ficne opâ ruac jopahuc jaŋe Jesure šâŋe musoriŋkeniŋte wiac qacne gâpâcne ejare jupac. Erâ no momori wânšâŋ erâ hae šoricko ra jopa jâpec ejare jupac wâc. ");
INSERT INTO kmg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ekupe taha bapa micne jaŋe papia narehuc munarepie Damasko haeo rapemurâ rapo. ");
INSERT INTO kmg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Rakuhape qâqâtâc bembeŋkeha sambâŋkonec šoc tatamac bâricnehuc waha no â ŋicfâc-nane âke tamaec-nâpowec. Opoŋ, ŋicwofuŋ-nane, šoaŋ tatamacne i weweaŋne, â honepo tatamac izi hâhâwicne jâmbâŋ. ");
INSERT INTO kmg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Eme nâŋe mâreŋko rândiŋke qarâ fohuc dâŋ wiwira moc Judadâŋko šiŋuc manambeŋ: `Saulo, Saulo, go wemocte nu jâpec enarehuc juekic? Go šârâ hewâcnetec âkecgume šâic manacmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Eme no šiŋuc mupo: `Wofuŋ go mo? Ž Mupe šiŋuc nazawec: `Nu jâpec enarehuc jukomec Jesu no hâcne. ");
INSERT INTO kmg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Go fahare domac, no ši kiŋaŋ qaqa-nane bacgupemurâ fua-garekopac, irec go ši wiac honekomec â juku gowatupe honecmu irec biŋe mumu-nane erâ juzemec. ");
INSERT INTO kmg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","No ŋicguru ši â ŋic qâpuc jaŋere meonec bataracguhuc jupemu. ");
INSERT INTO kmg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Erâ jaŋerao sorecgupe šâŋe-jeŋic bâtâcnetec dapâc honerâ râpeckerâ tatamac maickenšepieŋ, erâ wâc Sataŋte gie beherâ Anuture enšepieŋ. Eme sâqocne-jeŋic tâmirehame no manasiŋnuhuc ɋaɋackembiŋ jaŋere guruo raširâ sambâŋ kâdoc-jeŋic rauckenšepieŋ.' ");
INSERT INTO kmg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ŋicwofuŋ-nane Agripa, no sambâŋkonec dâŋ mana rereŋ ehuc ");
INSERT INTO kmg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ine qanaŋ Damasko haeonec ŋic â Jerusalem haeonec ŋic erâ wâc Juda mâreŋ rune sasawa â ŋic qâpuc mâmâc maŋjeŋic bârisierâ Anuturao qohotahuc maŋ bâbârisiere fârine bâfuaniŋte irec miti jazahuc jupo. ");
INSERT INTO kmg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Eme iŋuc epore Judaŋic jaŋe taha ufuŋko rocnurâ qâhâmocnuzo embiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Eme Anutu e ŋezicnu warehame miti mupozi muekopac, ehuc ŋic fekicne â wahakicne mâmâc jazaekopac. Erâ dâŋ furune mâcne, porofete â Mose findaŋdâŋ muhuc qâreŋkembiŋ ijaha muekopac. ");
INSERT INTO kmg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kristo e šâic manaku hâmoocte mucnekicne erâ hâmokicne jaŋeraonec micne barâ faharerâ Judaŋic â ŋic qâpuc šâziriŋ dâŋ bâfua-jareocte mucnekicne, dâŋ i hâcne dopeckeekopac.” ");
INSERT INTO kmg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo e fuŋne-ticne mutiŋnehuc dâŋ iŋuc jazame Festozi dâŋ hahaŋne bahuc muwec, “Paulo go maŋge sifuckekac i¡ Papia bocjaha wose qâreŋ ekutec maŋge sifuckewec hâcne.” ");
INSERT INTO kmg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mume Paulozi dâŋ šiŋuc bâtikiecnewec: “Ŋicbomboŋ-nane Festo, no maŋsifuc dâŋ mâcne, no dâŋ tiŋne â fârine mukopac. ");
INSERT INTO kmg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Dâŋ mukopac irec fuŋne ŋicwofuŋzi sâcne manakac, erao hâcne afeckehuc mukopac. Wiac mukopac i soŋsoŋko mi fuawec, irec ŋicwofuŋzi wemocko kâuc baocmu. ");
INSERT INTO kmg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ŋicwofuŋ Agripa, go porofete jaŋere dâŋ mana šakieekic me? No manakopac, go mana šakieekic.” ");
INSERT INTO kmg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Mume Agripazi Paulo šiŋuc âzâcnewec: “Enarekutec mi šoraha Kristoŋic ezipohec ine.” ");
INSERT INTO kmg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Eme Paulozi muwec, “Go â ŋic gâcne miŋecgac dâŋ ši mupe manaŋgopieŋ, ŋoŋe Wofuŋzi bafic-ŋopame mi šoraha no iŋucne ejâmbâŋkeniŋte mukopac, kâpâcwâru ŋic jukopac irec mâcne, mitire mukopac.” ");
INSERT INTO kmg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Iŋuc mume ŋicwofuŋ â kia â Beanike â ŋic gâcne faharerâ râwiŋnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Râwiŋnehuc nazaŋ gazaŋ erâ šiŋuc mumbiŋ: “Ŋic e šika me kâpâcwâru mi hotâckewec.” ");
INSERT INTO kmg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Á Agripazi Festo šiŋuc âzâcnewec: “Ŋic e Roma ŋicwofuŋzi dâŋticne mutaraocte mi mume muzac, go sâcne firuetec ra juzac.” ");
INSERT INTO kmg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italia mâreŋko ranaŋte dameŋ maickeme kiazi mume Roma momori jaŋere soŋaŋ moc šâŋene Julio, eki Paulo â kâpâcwâru ŋic gâcne rocjopame wokeo fembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Woke i Adramiteŋ haeonec, erâ Asia masunao hae biri ŋerawec ira raši-fâreocte mucnekicne. Woke ira hâcne ferâ Makedonia ŋic moc šâŋene Aristako, Tesalonike haeonec, ehec mâmâc rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Hae fureme woke Sidoŋ haeo rašime Juliozi Paulo âgo ecnehuc manacneme haeo raferâ âgofâcne iqic-jopame hata nâsiŋ wiac râcnembiŋ: ");
INSERT INTO kmg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Eme mâŋâŋ rambeŋkonec warewecte ine Kipiro nuc â Asia mâreŋ ŋondeŋ-jekicko rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ehuc Kilikia â Pamfilia mâreŋ hecne hecne raku Mira haeo Likia mâreŋko fisimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ira Alesandria haeonec woke moc ŋewec. Izi Italia mâreŋko razo ewecte momori soŋaŋzi rocnâpome ira fembeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ferâ uneŋ uneŋ ŋe qatarac raku Kinido hae ŋeweckopec fisimbeŋ. Eme mâŋâŋzi bârisiec-nâpome hae i râpeckerâ Kreta nuckopec rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Raku nuc irec masune moc šâŋene Salimone i qatararâ Lasaia hae ramicnao hâwec motec moc fowec, šâŋene Woke Haebiaŋ, ira neneŋ gie baku rašimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Hâwecko dameŋ šora rahuc jumbeŋ erâ wâc hoemaŋ biac maickewec, irec Paulozi uŋdâŋ jazarâ muwec, ");
INSERT INTO kmg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ŋicbureŋ, ši mocwâc ranaŋmu i manape fâsâcne rarane mi ekac, woke herickeme mafa sawa mâcne, ŋic mâmâc hâwecko hunšipeŋte manabâc erâ mukopac.” ");
INSERT INTO kmg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Iŋuc mume momori soŋaŋ eki Paulore dâŋ mana takirehuc kapiteŋ â woke rune jahere dâŋ manawec. ");
INSERT INTO kmg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Eme hâwec motec honepie wokezi ira hoemaŋko sâcne ŋeŋene mi ewec. Irec Kreta nuc irec hâwec motec moc fowec šâŋene Foiniki, ira raširâ ŋehapie hoemaŋ taraocte mumbiŋ. Hâwec motec irec masunezi mula â jowarec mâmâc sâoc-jofawec. ");
INSERT INTO kmg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Eme râpefuŋ-nâŋeckonec mâŋâŋ burec burec mac qame wokeŋic raniŋte murâ aŋga fârepie wefume Kreta nuc heririŋkerâ rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Raha rahapene nuckonec mâŋâŋ hâhâwicne šâŋene kagu, ");
INSERT INTO kmg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","izi qahuc woke qâtuŋkeme bâipieku behepie qâso bâsoriewec. ");
INSERT INTO kmg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Eku nuc piticne moc šâŋene Kauda, irec ŋifecnao rahapene woke gombazi hâwecko huzo eme ");
INSERT INTO kmg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","gie sâko baku fârepene woke faio fewec. Erâ woke fâuckezacte repazi rowaŋauckehuc bândeŋnembeŋ. Eme haroŋaŋ moc šâŋene Siriti, ira fenšipeŋte rac fârepie wahame mâŋâŋzi qâsoriec-nâpome rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Eme mâŋâŋ tâpirinehec qahuc fowecte hae fureme mafa gâcne hâwecko behepie huwec. ");
INSERT INTO kmg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Eme hae mocwâc fureme wokere wâcwiac gâcne iŋuc jaha ropie huwec. ");
INSERT INTO kmg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ŋafe šoaŋ gâcnao mâŋâŋ hâhâwicnehec qahuc domahame šoaŋ me bâpiŋ moc mi fuame honerâ maŋ mamanasu-nâŋec šickeme ši ine mi junaŋmu mumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Eme ŋic jaŋe nânâ qikiŋne-fârerâ juhapie Paulozi ra ŋondeŋ-jeŋicko domahuc šiŋuc jazawec: “Ŋicbureŋ, ŋoŋe dâŋnane manapie muzac, ine Kreta nucko junšapeŋ. Eme wiac hâhâwicne â mafa sisipiric ine mi fua-nârezac. ");
INSERT INTO kmg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ʒi ine sifu hâhâwic qamaseniŋ, ŋiczi mi sipirickenaŋmu, wokezi ine jâmbomac sipirickeocmu. ");
INSERT INTO kmg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Jacne ŋafeo runane Anutu eki kiŋaŋ qaqa-ticne norao aŋelo moc soreme fua-narerâ ");
INSERT INTO kmg_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","šiŋuc nazajec: `Paulo go mi hâwicguoc, go Roma ŋicwofuŋtao fisi-jâmbâŋkecmu, erâ manakic, Anutuzi go ŋezicguhuc ŋic gohec wokeo juŋgopieŋ jaŋe mâmâc gore erâ ŋezic-jopa-fâreocmu. Ž ");
INSERT INTO kmg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Irec, âgofâc-nane, ŋoŋe buŋeŋic biaŋkezejec. No Anuture maŋ jahec mi ekopac, dâŋ nazajec i sanaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wokezi ine nuc mocko ferâ henšaŋneocmu.” ");
INSERT INTO kmg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Eme Adria hâwecko qac qâsoric ehuc juhapene ŋafe šoaŋ 14 eme wokeŋic jaŋe manapie mâreŋ bâqiŋkeŋgopeneŋ tinac ewec. ");
INSERT INTO kmg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Iŋuc manahuc sâc behepie hume 30 meta ewec. Erâ ipec rarâ sâc mocwâc râepie hume 22 meta sawa ewec. ");
INSERT INTO kmg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Eme haroŋaŋko fenšipeŋ muhuc hâwic-jopame woke šâhecnao aŋga 4 behepie hume hae fureocte hejâpehuc ŋembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ŋeku wokeŋic jaŋe woke beherâ wiseniŋte manasuhuc woke gomba râepie hume burec ehuc kecšiŋuc mumbiŋ: “Nâŋe woke masunao aŋga moc behepene huocmu.” ");
INSERT INTO kmg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Iŋuc epie Paulozi momori soŋaŋ â ŋicfâc-ticne šiŋuc jazawec: “Wokeŋic jaŋe wisepie ŋoŋe hâwecko hufâreniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Jazame momori jaŋe woke gombare niŋgiŋ hetâcnepie gomba hâwecko hume behembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Eme hae fureocte woŋec juhuc Paulozi ŋic mâmâc sasawa šiŋuc jazawec: “Ŋoŋe maŋ sahac-ŋeŋic soka fâkic eme nânâ mi nâhuc mâc juhapie miŋecgac šoaŋ 14 ekac. ");
INSERT INTO kmg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Irec ši nânâ nâniŋte ŋazape mi qataraniŋ. Nânâ nâqiŋnerâ sâcne tiŋko ferâ juniŋmu. Qizec susuc-ŋeŋic moc mi waharâ sifuckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Iŋuc murâ hone-fârehapie poroŋ moc rorâ Anutu daŋge âzâcnehuc bazurâ nâwec. ");
INSERT INTO kmg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nâme honerâ maŋjeŋic firieme iŋuc jaha nâfârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ŋic wokeo jumbeŋ šare-nâŋec 276. ");
INSERT INTO kmg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nânâ nâ gapec erâ wokemaŋkonec padi hâwecko behepie hume woke afeckerâ wefuwec. ");
INSERT INTO kmg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Hae fure-fâreme mâreŋ šâŋitaniŋte hone-bipiembiŋ. Ehuc hâwec kenšuŋne moc haroŋaŋ tâmiric honerâ wokezi ira raširâ moŋgeŋko feocte ");
INSERT INTO kmg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ŋic jaŋe aŋga niŋgiŋne hetâcnepie hâwecko hume rac fârepie feme guriŋ goroŋkerâ moŋgeŋkopec ma bahuc rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Guriŋ bâipiehapie woke mâreŋ masunao fewec. Ehuc woke masune kindeŋnerâ sanaŋkehame hâwec siri sâkozi woke šâhecne qanšaŋnewec. ");
INSERT INTO kmg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Woke šaŋkeme kâpâcwâru ŋic jaŋe fifia bahuc wisenšipiŋte momori jaŋe qâhâmoc-jopazo mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Soŋaŋ-jeŋiczi ine Paulore erâ qatara-jarewec. Erâ mume fifia bapa jaŋe qanaŋ hâwecko rucnerâ fifia bahuc tiŋko fembiŋ, ");
INSERT INTO kmg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","â gâcne jaŋe palaŋ faio â wokere dâkâ faio ferâ rambiŋ. Iŋuczi iŋuc ehuc furu jaha tiŋko fefârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tiŋko fefârerâ nuc šâŋene Melite mupie manambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Eme nuc irec rune jaŋe âgo jauŋ bocjaha enârembiŋ. Ehuc hoe mâmâteŋte šocsâko ruqe-nârepie šame ruambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Eme Paulozi nâŋ gagate wiac qânusuckerâ šocko râeme hume irec maŋnaonec homa moc andaŋ mandaŋte wefurâ Paulo menao kiŋ qaŋatie domawec. ");
INSERT INTO kmg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ehame mâreŋ rune jaŋe menao homa domame honerâ nazaŋ gazaŋ erâ mumbiŋ, “Ŋic e šika qaqa jâmbâŋ, hâwecko mi hurâ hâmojecte šira tiŋko wefume okacne fisicnekac.” ");
INSERT INTO kmg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Eme Paulozi homa qatatiŋkeme šocko hume homazi mi kiwec tinac fâsâcne domawec. ");
INSERT INTO kmg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Domahame jaŋe sisiwiŋ fuacneocmu me onšoŋ jaha hâmorâ rândiŋkeocmu muhuc woŋec ŋembiŋ. Ŋekuhapie iŋuc me iŋuc mi ecneme honerâ mumbiŋ, “Ŋic e nemu. “ ");
INSERT INTO kmg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Jumbeŋ irec bembeŋnao ŋicbomboŋ-jeŋic šâŋene Popilio ere hae mâreŋ fowec. Eme ŋic eki hâcne hezu hewâneŋ enâreme ere ficko šoaŋ jahec â moc ŋeŋe juju embeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Juhapene Popilio mamac-ticne huc fuacneme woke socnehec qawec. Eme Paulozi manarâ ficticnao ferâ mene qizecnao râerâ numuhuc bâpiaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Iŋuc eme biŋene manarâ nuc irec ŋic gâcne huc šâic-jeŋichec fisipie iŋuc jaha ɋiɋicne bacjopawec. ");
INSERT INTO kmg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Eme irec okacne ŋic jaŋe bubiaŋ mana-nârehuc uruc jauŋ fekicne enârembiŋ. Erâ rara dameŋ maickeme hata nâsiŋ wiac wokeo râe-nârembiŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nuc ira hâcne juhapene mosa jahec â moc tarame woke furunao fembeŋ. Woke i Alesandria haeonec, qoruc-ticnao nemu hahac ɋa jahere hawari bakicne. Nâŋe jumbeŋko ijaha woke i ŋehuc juhame hoemaŋ tarame ira hâcne ferâ rambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Raku Siraku haeo fisirâ raširâ šoaŋ jahec â moc jumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Irecnec mâŋâŋ hecnehuc bac bâŋoric raku Regioŋ haeo fisimbeŋ. Eme hae fureme râpefuŋ-nâŋecko mula qahuc ficne suec-nâpome ŋafe šoaŋ jajahec sawa raku Puteoli haeo fisimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Fisipene hae irec miti mamanazi hefârec-nâpopie šoaŋ 7 jaŋehec ŋeŋe juju embeŋ. Eme irecnec mocwâc raku Roma haeo fisimbeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Eme hae irec miti mamanazi biŋe-nâŋec biac manambiŋte gâcnezi wareku Apio haeo bâfuac-nâpombiŋ â gâcnezi Tetrabeŋ haeo bâfuac-nâpombiŋ. Eme Paulozi honec-joparâ Anutu daŋge âzâcnerâ bubiaŋ manawec. ");
INSERT INTO kmg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Roma haeo fisipene kiazi mume Paulo kâpâcwâru ficko mi râembiŋ, momori moczi soŋaŋkeha fic omane mocko ŋec juc ewec. ");
INSERT INTO kmg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Juhame šoaŋ jahec â moc eme Judaŋic jaŋere micne hefârec-jopame fisipie dâŋ šiŋuc jazawec: “Âgo bureŋ, no Judaŋic âgofâc-nâŋec mi kisuec-jopapo â mimiŋnefâc-nâŋec jaŋere dâŋ mi qâsuapo. Eme jaŋe sifu Romaŋic jaŋerao qikiŋnupie Jerusalem haeo kâpâcwâru bacnumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Eme Romaŋic jaŋe fuŋne-nane mu rituc ehuc nuniŋte kiŋnane basarâ firuecnuniŋte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ehame Judaŋic jaŋe sanaŋne qatarapie Roma ŋicwofuŋzi dâŋnane mutaraocte mupo, Judaŋic âgofâc-nâŋec jaŋere dâŋ šira bawarerâ mupemurâ ine mi warepo. ");
INSERT INTO kmg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Eme no irec hâcne honec-ŋoparâ ŋoŋehec muc manac enaŋte hefârec-ŋopape fisimbieŋ. No ine Israe ŋic woworic-nâŋec ewec ere erâ kâpâcwâru ŋic epo jukopac ši.” ");
INSERT INTO kmg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Iŋuc muhuc jazame mumbiŋ, “Ocna Judaŋic mâreŋfuŋ-nâŋecko jueŋgopieŋ jaŋe gore dâŋ mi qâreŋke-nârembiŋ me ŋicjeŋic moc mi sorepie ware gore bahacdâŋ mume manambeŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Irec dâŋ bajuekic i go gahac mutec mananaŋte muŋgopeneŋ. Á opâ ruakicne jaŋere šiŋuc manaeŋgopeneŋ: Mâreŋ sâc ŋiczi mu supaic ejareeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Iŋuc murâ šâfo babac embiŋ. Eme i maickeme Judaŋic bocjahazi Paulore ficko tumaŋnembiŋ. Eme Anuture uucmaŋte dâŋ binaŋ uupicte fuŋkerâ jazahuc juhame hae ŋafewec, ehuc Mosere sâcmutâc dâŋqâhâcko â porofete jaŋerao biŋedâŋ qâreŋkekicne fokac i Jesurao fâri fideteŋ ewec, irec fuŋne muhuc maŋuruc qajarewec. ");
INSERT INTO kmg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ejareme ŋic gâcne jaŋe dâŋticne âgo bambiŋ â gâcnezi ine qaisockembiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ehuc mu qaqatarac epie Paulozi dâŋ mocjaha šiŋuc jazawec: “Tiri Mârozi porofete Jesaja ecneme mimiŋnefâc-ŋeŋic sowine dâŋ kecšiŋuc jazawec: ");
INSERT INTO kmg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","`Go rarâ ŋicguru keci šiŋuc jazac: Hazeczi mamana i mananiŋmu, maŋzi mamana tara ine mi eniŋmu. Ʒâŋezi fifi finiŋmu, wiac hohone tara ine mi eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ŋicguru ši jaŋe maŋjeŋic sanaŋkekicne, â hazec-jeŋic bâzickekicne, â šâŋe-jeŋic hâmonšambiŋ. Irec šâŋe-jeŋiczi wiac mi hone taraeŋgopieŋ, â hazec-jeŋiczi wiac mi mana taraeŋgopieŋ, â maŋjeŋiczi wiac mi manasu-hâmoeŋgopieŋ, ehuc maŋjeŋic mi bârisiepie no wemocko bâpiaŋ-jopazapo.' ");
INSERT INTO kmg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Irec no ŋazape mananiŋ, Anutuzi bâbâpiaŋ hata bâfuawec i qâpuc jaŋere biŋe ekac, jaŋe sâcne mana aŋac eniŋmu.”  ");
INSERT INTO kmg_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Iŋuc muhuc jazame Judaŋic jaŋe jaŋackoaŋ mu wioc bocjaha eec ehuc rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Eme Paulozi jara 2 Roma haeo fic omanao juhame ŋic jaŋe iqickehuc jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Iqickepie Anuture uucmaŋte dâŋ binaŋ ejarehuc Wofuŋ Jesu Kristo ere fuŋne hâwicmâc jaha muhezuc tâmiricko jaza qazuc ehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulo no Jesu Kristozi kiŋaŋ qaqa-ticne bacnurâ aposolo-ticne mucnuhuc Anuture Biŋebiaŋ râepe qareŋko raocte rowosâecnuwec. ");
INSERT INTO kmg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Miti i hâcne fuaocte Anutuzi mârâc jaha porofete ejareme irec findaŋdâŋ tiri papiao qâreŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Qâreŋkepie Ŋokâ-ticnerao iticnewec. E sahachec fufua i Dawidi ɋâricfâc-ticne jaŋeraonec fuawec, ");
INSERT INTO kmg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","erâ e maŋɋaɋac bâbâfua Mârohec jujuzi Anuture Ŋokâ jukac, irec fuŋne hâmokonec faharewecko fua taniŋke-jâmbâŋkewec. ");
INSERT INTO kmg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesu Kristo e Wofuŋ-nâŋeczi aki anonoc enarehuc aposolo gie tahacnuwec. Ehuc mâreŋ sâc ŋic miti jazepe mana rereŋ epie Jesure šâŋe biŋe raocte munarewec. ");
INSERT INTO kmg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Eme ŋoŋe jaŋere âgofâc jaha, Jesu Kristore ŋicfâc eniŋte hefârec-ŋopakicne, irec gie i ŋoŋerao iŋuc jaha bapere munarewec. ");
INSERT INTO kmg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Roma haeonec Anuture jorofâc, tiriŋic mucŋopakicne, ŋoŋere hâcne papia ši qâreŋkekopac. Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Miti babaju-ŋeŋicte mâreŋ sâc manapie biaŋkekacte qanaŋ ŋoŋere erâ daŋge mupe Jesu Kristorao qarâ Anutu-nanerao fotâcnekac. ");
INSERT INTO kmg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","No Ŋokâ-ticnere Biŋebiaŋ muhuc maŋnanezi Anutu kiŋaŋ qacnepe fuŋne-nane manakacte ere maio dâŋ ši mupe mananiŋ: ");
INSERT INTO kmg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","No numucneekopac sâc ŋoŋere mâmâc hati manasuekopac, ehuc Anutu maname sâckeme hata bâfua-nareme ŋoŋerao fâpemurâ âzâcneekopac. ");
INSERT INTO kmg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","No ŋoŋe honec-ŋopapere enareekac. Ehuc fârâ maŋte bâmec moc baŋarepe qiŋ herâ juniŋte muekopac. ");
INSERT INTO kmg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Me kecšiŋuc mupe: No ŋoŋerao fâpe mamanasiŋte fârine nowac gowatuŋ ehuc keketeŋ enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Erâ âgofâc-nane, fuŋne-nane kâuc banšipiŋte šiŋuc ŋazape: No ŋicguru gâcne jaŋerao eeckopac iŋuc jaha ŋoŋerao fârâ miti giere fârine piticne bâfuapemurâ hati muekopac. Erâ fâzo mupe sâc wiac gâcnezi niŋgiŋnume juekopac. ");
INSERT INTO kmg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Noni ŋic kosa. Grikŋic â kâte sanaŋ, mamanahec â mutucne mâmâc mitizi tofa bazu-jarepemurâ munarekicne. ");
INSERT INTO kmg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Irec Romaŋic ŋoŋe iŋuc jaha Biŋebiaŋ ŋazapemurâ maŋnanezi afeckeekopac. ");
INSERT INTO kmg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","No Biŋebiaŋte manape mimi gaŋgaŋnehec mi eekac, i Anuture tâpirihec, irec mana sakac eniŋmu sâc bâpiaŋ-jopaocmu, Judaŋic hâcne, erâ Grikŋic mâmâc. ");
INSERT INTO kmg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Biŋebiaŋko hâcne Anuture tiŋne fua taniŋkeekac, i hâcne eki mamanasiŋhec jaŋe tahac-jopaekac, ehame mamanasiŋko utuckeniŋmu. Dâŋqâreŋ šiŋuc hâcne fokac: “Biaŋkekicnezi mamanasiŋte erâ juju hotâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ŋiczi ine Anutu qamaserâ sindaŋ ehuc kike hata-ticne hesifuckeeŋgopieŋte kimbeŋ ticnezi sambâŋkonec fua taniŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Anuture fuŋne gâcne ŋiczi mamanane i manaeŋgopieŋ, Anutu jahac bataniŋke-jarewec. ");
INSERT INTO kmg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Anutu e ŋiczi mi hohonene, â mâreŋ bâfuahuc ine wiac fuŋne fuŋne râewec izi tâpiri sanaŋ-ticne â qâreŋ-ticne bataniŋkeme sâcne hone mana tarac eeŋgopieŋ. Irec ŋic gâcne jaŋe wemocko kâuc bahuc sahac ŋeŋezic dâŋ muniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Jaŋe ine Anutu jukac i mana-bipiehuc mi jukac-tinac eha araŋ mi bacnembiŋ â mucne bacne mi ecnembiŋ, aricne. Jaŋe mumusifuc fuŋne fuŋne bâfuahuc maŋmutuc epie dapâczi foŋjopawec. ");
INSERT INTO kmg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ehuc nâŋe mamanahec juŋgopeneŋ muhuc sâke bâbâc eku maŋmutuc embiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Iŋuc ejareme jaŋe Anutu juju hati e araŋ mi bacnehuc ŋic â wipe â qowi â homa, wiac sisirowene hâcne irec ɋâŋ qâqâtâc barâ araŋ bacnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Iŋuc epie Anutuzi hone suŋgiŋ ejareme maŋzi sasec kosa hurerâ mamakâc ehuc maŋ sahac-jeŋic bâsâqorembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Jaŋe Anutu jâmbomac rune râpeckerâ burec maickembiŋ. Ehuc ru bâbâfua-Jeŋic qikiŋnerâ wiac bâfuakicne araŋ bacnehuc kiŋaŋ qacnembiŋ. Wiac bâfua-fârewec e mumuteŋheczi mumuteŋhec jurašihuc jume sâckeocmu. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ŋic jaŋe e hâcne râpeckembiŋte suŋgiŋ-jopame sasec sâqocne jâmbâŋ bâfuambiŋ. Ehuc ŋokac jaŋe Anutuzi hata muwec i qâsorierâ mi jujuo rambiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Á ŋic jaŋe iŋuc jaha ŋowe ŋonâŋ juju qikiŋnerâ maŋjeŋicko sasecte šocsâko šame jaŋe jaŋackoaŋ mamakâc fuŋmoc bâfuambiŋ. Erâ bâbâsifuc-jeŋicte okacne maŋ sahac sisipiric rombiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Jaŋe Anuture fuŋne mana-bipiehuc enšaŋauc ecnepie suŋgiŋ-jopame maŋjeŋic bâzickeme wiac mi eene i hâcne embiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ehuc wiac hehesicne fuŋne fuŋne hurepie fewec, sindaŋ, andac, râŋgeŋne, erâ maŋjeŋicko iiŋguuŋ â šika â rârâsi â eeatuc, erâ gibioc izi fusucmakicne. ");
INSERT INTO kmg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Jaŋe gupe bapa, micko âkec ŋic, Anutu kisâ eecne, šaubacne, pepecne, sahac mumuteŋ, sâqocnere hata bâbâfua, neŋgoc mamac dâŋ qaqatara, ");
INSERT INTO kmg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","maŋ mamanasu tâmiric juju, doc bapa, uruc jauŋ tâmiric juju. ");
INSERT INTO kmg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wiac iŋucne ehuc sipirickezo, Anuture micdâŋ iŋuc fokac i mana-bipiehuc sifu eeŋgopieŋ, erâ i sawa mâcne, gâcnezi epie hume keteŋ ejareeŋgopieŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Irec ŋic go wemocko fuŋnege murârâŋnecmu? Ŋic gâcnezi bahac bâfuapie mana sâqore-jarehuc gahacne fuŋne bataniŋkeekic hâcne. Mana sâqore-jareekomec, go ijaha hâcne eekomec i¡ ");
INSERT INTO kmg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Eme Anutuzi ŋic iŋuc eeŋgopieŋ jaŋe okacne bazu-jareme sâcke-hâmoekac iŋuc manaŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ŋic go gâcne jaŋere dâŋbahac muhuc ijaha eekic, ehuc “no Anutuzi akicnuocmu” iŋuc mu wiac moc ezic ine¡ ");
INSERT INTO kmg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Me Wofuŋzi buuruc â wama ruaine sâc fekicne egarehuc akicguhuc jume go wemocte manatâc qatakic ehuc juekic? Go maŋge bârisiecmurâ Anutuzi buuruc egareekac i mi mana taraekic me? ");
INSERT INTO kmg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Go maŋsanaŋ erâ maŋge mi bârisiehuc šocfiki bafeku seroŋ batec šoc šaza dameŋko Anuture mumutara dâŋ fârine fua taniŋkeme šâhâmocguocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Anutuzi ŋic eebapa-nâŋecte sâc furine nârezokac hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ŋic eehâmo gie paŋšâic bahuc eri tatamac â juju saric bâfuaniŋte samarieniŋmu jaŋe juju sanaŋ jarezokac. ");
INSERT INTO kmg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ŋic râŋgeŋne dâŋ fâri qizecne bâsuehuc wiac hehesicne bajuniŋmu jaŋerao ine wiac šâšâicne â mimicne bâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Sâqocne bapa sasawa, Judaŋic hâcne â Grikŋic mâmâc, jaŋe šâic serereŋ â hâhâwic sâko fua-jareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Tiŋne Juniŋmu sasawa, Judaŋic hâcne â Grikŋic mâmâc, jaŋe eri tatamac â wama fua-jareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Anutu e ra rowec ware rowec mi focnekac. ");
INSERT INTO kmg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ŋic sâcmutâc dâŋ tâmiric juhuc sâqocne baeŋgopieŋ jaŋe sasawa sâcmutâc dâŋ tâmiric jaha sipirickeniŋmu. Á sâcmutâc dâŋhec juhuc sâqocne baeŋgopieŋ jaŋe sasawa Anutuzi sâcmutâc dâŋte sâcko dâŋjeŋic mutara-jareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Sâcmutâc dâŋ mâc hazeczi mananiŋmu jaŋe Anutuzi honec-jopame tiŋne mi eŋgopieŋ, manarâ reŋkeeŋgopieŋ jaŋe ine tiŋne mujareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ŋic qâpuc sâcmutâc dâŋ mi mufua-jarekicne jaŋe maŋjeŋicte sâcmutâc dâŋ reŋkehuc ine sâcmutâc dâŋ tâmiriczi sâcmutâc dâŋhec tinac eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Iŋuc epie sâcmutâc dâŋ i maŋjeŋicko qâreŋkekicne, irec fuŋne jaŋgeŋkeekac. Sâcmutâc dâŋ maŋjeŋicko qâreŋkekicnere maŋjeŋiczi tutuc qajareekac, erâ wâc maŋ mamanasu-jeŋiczi foc forisic ehuc ŋifec mu qatarac eekac â ŋifec mu bâmiriŋ eekac. ");
INSERT INTO kmg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","I dameŋ sâkore iŋuc eekac. Ira Anutuzi Jesu Kristo ecneme maŋnâŋecko wiac soŋsoŋ fokac irec fuŋne bataniŋkeocmu. No Biŋebiaŋ muekopac irec sâcko bataniŋkeocmu hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Go šâŋege Judaŋic muhuc sâcmutâc dâŋzi roŋgâŋ egareme herâ foekic. Erâ no Anuture fuŋne manakopac muhuc sahac fefe juekic. ");
INSERT INTO kmg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Go Anuture micdâŋ manaekic, erâ sâcmutâc dâŋ qazu-garekicnere keci ezo, keci mi ezo i mana wosâeekic. ");
INSERT INTO kmg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ehuc gahacnere šiŋuc muekic: “No tiŋtuŋ sâcne jowa qataŋ ejarepemu, â dapâcko juŋgopieŋ jaŋe sâcne batamae-jarepemu, ");
INSERT INTO kmg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","â ŋic maŋpuriŋhec jaŋe sâcne jaza bâtiŋ ejarepemu, â ɋiemaŋ jaŋe wiac sâcne qazu-jarepemu. No sâcmutâc dâŋhecte mamana â dâŋfâri irec wamboŋne rauckerâ jukopac i.” ");
INSERT INTO kmg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Go iŋuc muekiczi ŋic gâcne miti qazu-jarehuc gahacne maŋ mi qazucneekic. Go ŋic fiuc mi ronšepieŋ jazahuc gahac fiuc roekic. ");
INSERT INTO kmg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ŋowe ŋonâŋ ŋohe bebehec mi ezepirec jazahuc gahac ŋonâŋge beheekic. Go nemuɋâŋ sureekiczi nemu ufuŋte wiac fiuc roekic. ");
INSERT INTO kmg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Go sâcmutâc dâŋte manasuhuc maŋfefe eekiczi sâcmutâc dâŋ qâsuahuc Anutu gâc hecneekic. ");
INSERT INTO kmg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Irec hâcne kecšiŋuc qâreŋkekicne: “Qâpuc jaŋe ŋoŋere kiŋte erâ Anuture šâŋe musoriŋkeeŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Go sahacgao Anuture ma bakicne i sâcmutâc dâŋ reŋketec fârinehec eocmu. Me sâcmutâc dâŋ qataratec sahacgao ma izi fârimâc eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Erâ dâŋ irec ŋifecne qac qârisic fokac wâc. Ŋic moc ma tâmiriczi sâcmutâc dâŋ reŋkeocmuo mahec tinac eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ehuc ma tâmiric fuarâ juekaczi sâcmutâc dâŋte gie baocmu eki ine fuŋnege rituocmu, miti papia â mahec juhuc sâcmutâc dâŋ qâsuaekic gore fuŋne hâcne rituocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Moc e mâc sahaczi Judaŋic hawari eocmu â sahacko sawa mahec juocmu, iŋucnezi Judaŋic fârine mi eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Maŋzi Judaŋic izi fârine. Á sahacko sâcmutâc dâŋte ma rojuju i mâcne, maŋko Mârore ma rojuju izi fârine. Ŋic iŋucnere ŋiczi mâcne, Anutuzi maname biaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Hâc, eme Judaŋic jaŋe qâpuc jaŋehec sâc mocjaha eŋgopieŋ, â sahacko ma i wiac racne me? ");
INSERT INTO kmg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Iŋuc aricne. Judaŋic jaŋe wiac bocjaha tahac-jopakicne. Jaŋe hâcne Anutuzi biŋedâŋ fuŋne fuŋne jazame irec rune embiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Eme weniŋuc? Judaŋic gâcne jaŋe dâŋte woŋec juku pârâckembiŋte šiŋuc muzo me? “Dodocke-jeŋiczi Anutu mume sasanaŋ-ticne bawahaocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","I aric kereŋne¡ Anutu e buc mume sasanaŋ â ŋic ine mumu dodocne, iŋuc muzo. Miti qâreŋ moc šiŋuc hâcne fokac: “Go mumutiŋgezi dâŋfâri eocmu, â mumutaragezi ɋaɋacne eocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Eme hehesic-nâŋeczi Anutu tiŋne-ticnere fuŋne bajaŋgeŋkekacte weniŋuc muzo? šiŋuc muzo me? “Fuŋne iŋuc fokacte Anutuzi irec okacne nâreme mi sâckeocmu.” (Dâŋ i ŋic mamanare sâcko mukopac.(c) ");
INSERT INTO kmg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","I aric kereŋne¡ Anutu e hehesic-nâŋecte okacne nâreme sâckeocmu. Mâc muzac wemocko mâreŋŋic šeŋgoma dâŋnâŋec sâcne mutarazac. ");
INSERT INTO kmg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Eme ŋifec ine burecdâŋ-nanezi Anuture dâŋfâri dopeckeme šâŋe biŋe-ticne irec erâ fekacko wemocte sifu no wâc sâqocne bapa munarehuc okacne nareekac? ");
INSERT INTO kmg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Erâ wemocte šiŋuc mi mueŋgopeneŋ: “Sâqocne bapene ŋerisierâ fârine biaŋne fuaoc me.” Nâŋe iŋuc mueŋgopeneŋ munârehuc micko âkec enâreeŋgopieŋ hâcne. Dâŋ iŋucne muhuc hata i âteeŋgopieŋ jaŋe okacne fua-jareme sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Eme weniŋuc? Judaŋiczi ŋic gâcne jowarurâ sâc moc juŋgopeneŋ me? I aricne jâmbâŋ. Biac mumbeneŋ, Judaŋic â Grikŋic nânâc mâmâc sâqocnere kiŋaŋ qaeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Dâŋqâreŋ moc šiŋuc hâcne fokac: “Ŋic moczi tiŋne moc mi jukac, aric ɋaɋacne; ");
INSERT INTO kmg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","moczi mamanahec moc mi jukac, moczi Anutu wira basac mi ecneekac. ");
INSERT INTO kmg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Jaŋe qâsoriekicne sasawa, šeŋgoma repirembiŋ; moczi moc wiac biaŋne mi eekac, arictac jâmbâŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Marac-jeŋic i hâmoc qâŋɋâŋ bâbâfua, nameŋ-jeŋic forisieme eatuc dâŋ wefuekac, qotâ marasiŋ kisoŋnerâ jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Bipic-jeŋic sâwec â aaric dâŋte gegerockeekac. ");
INSERT INTO kmg_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ʒikare kike afec jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ima samaki bahuc tuhu bâfuaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Wamare hata ine kâuc baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Á šâŋe mai-jeŋicko Anuture hâhâwic mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nâŋâc šiŋuc manaeŋgopeneŋ: Sâcmutâc dâŋ i dâŋ rune nâŋe nazakicne. I ŋic sasawa fuŋne-nâŋec rituhuc micnâŋec ɋâtâocte ekicne. Eme ŋic mâmâc sasawa kiŋnâŋec Anuturao fua-fârekac. ");
INSERT INTO kmg_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sâcmutâc dâŋte erâ kiŋ nânâwoc ro i Anuturao moc mi fokac. Sâcmutâc dâŋzi sindaŋ-nâŋec bataniŋkeekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Eme irec sâcmutâc dâŋ fohame Anutuzi tiŋne-ticne fua taniŋkeocte hatane moc bâfuawec fokac, hata i sâcmutâc dâŋqâhâcko â porofete jaŋerao wâc biŋedâŋ-ticne mu qâreŋ ekicne. ");
INSERT INTO kmg_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Jesu Kristo manasiŋkehuc kiŋfâsâc erâ juju, hata i hâcne mamanasiŋhec sasawa jaŋere biŋe ekac. Fuŋne-nâŋec bârâwiŋ mi fokac, ");
INSERT INTO kmg_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Nâŋâc mâmâc sasawa sâqorembeŋte Anuture eri tatamacko fifisinere sâc mi eŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ehame Kristo Jesu e kiwiric-nâŋec rowecte Anutuzi aki anonoc-ticnere erâ kiŋfâsâc bacnâpoekac. ");
INSERT INTO kmg_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Eki mume Jesu e socticnezi sâqocne-nâŋecte erâ taha bawec, eme e manasiŋkeniŋmuzi taha i biŋeckeniŋmu. Sâqocne ewarehuc jukicne irec kiŋ i Anutuzi buuruc-ticnere râeme fowarehuc juwecte Jesu hâmocko râewecko tiŋnere fuŋne bataniŋkewec. ");
INSERT INTO kmg_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","E tiŋnere rune juekac, â Jesu manasiŋkeniŋmu jaŋe kiŋfâsâc bacjopaekac, irec fuŋne dameŋ šiŋuczia taniŋkeocte iŋuc hâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Eme mumuteŋ-nâŋec moc fokac me? Aricne, mumuteŋ-nâŋec hetâtiekicne. Wemozi hetâtiewec? Eehâmo giere hatazi me? Aricne, mamanasiŋte hatazi. ");
INSERT INTO kmg_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Irec dâŋ šiŋuc manapene fozejec: Ŋic nâŋâc sâcmutâc dâŋ rereŋkere mâcne, mamanasiŋte erâ kiŋfâsâc fuaeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Me Anutu e Judaŋic nâŋere Anutu sawa, qâpuc jaŋere aricne? Iŋuc mâcne, e qâpuc jaŋere Anutu jaha wâc. ");
INSERT INTO kmg_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","E Anutu-nâŋec mocjaha jukaczi hâcne Judaŋic â qâpuc mâmâc mamanasiŋ-nâŋecte erâ kiŋfâsâc bacnâpoekac. ");
INSERT INTO kmg_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Eme iŋuc muhuc mamanasiŋte erâ sâcmutâc dâŋ hetâtieŋgopeneŋ me? Aric kereŋne, sâcmutâc dâŋ hešakieŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Eme sahackopec mimiŋne-nâŋec Abraham e wemo bâfuawec munaŋmu? ");
INSERT INTO kmg_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","E jahacne eehâmo giere erâ kiŋticne hefâsâewecko ropaŋ sâcne focnezac. Erâ Anuture maio ine arictâc. ");
INSERT INTO kmg_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Miti papiao dâŋ šiŋuc fokac i: “Abraham e Anutu manasiŋkeme irec erâ maname kiŋticne tarawec.” ");
INSERT INTO kmg_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Moc e gie bame furime râcnepene izi katucmâc rârâcne mi ekac, tofa babazucne ekac. ");
INSERT INTO kmg_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Á moc e ine eehâmo gie mi bapa, sâqocne bapa kiŋjeŋic beheekac e manasiŋkeocmu, eme Anutuzi ere hâcne mamanasiŋ-ticnere erâ maname kiŋfâsâc eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawidi e iŋuc jaha Anutuzi ŋic moc eehamo gie mi baha, akickehuc kiŋ behecneocmu ere mu šeri ehuc kecšiŋuc qâreŋkewec: ");
INSERT INTO kmg_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Bahac-jeŋic behekicne, â sâqocne-jeŋic bâtâmirekicne, jaŋere manape šerine ekac; ");
INSERT INTO kmg_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ŋic moc Wofuŋzi manacneme kiŋhec mi eekac, ere manape šerine ekac.” ");
INSERT INTO kmg_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mušeri dâŋ kecši i mahec nâŋere biŋe sawa ekac me ma tâmiric jaŋere mâmâc ekac? Abrahamte šiŋuc manaeŋgopeneŋ: E Anutuzi mamanasiŋ-ticnere erâ kiŋ behecnewec. ");
INSERT INTO kmg_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mo dameŋko behecnewec, mahec juhame me ma tâmitric juhame behecnewec? Mahec mâcne, ma tâmiric juhame behecnewec. ");
INSERT INTO kmg_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","E ma tâmiric juhuc Anutu manasiŋkeme kiŋticne behecnewec irec maqâreŋ šâhec râecnewec. Eme Abraham e iŋuc ehuc ine ma tâmiric jaŋe Anutu manasiŋkehuc kiŋfâsâc eeŋgopieŋ jaŋere micne ewec. ");
INSERT INTO kmg_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Erâ mahec nâŋere micne bapa wâc ewec, erâ mahecte sawa mâcne, e ma tâmiric juhuc mamanasiŋte kike hata âtewec, hata ijaha mimiŋ qâjâpec âtehuc Abraham micne bapa-nâŋec mucnepene sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Anutuzi Abraham â ɋâricfâc-ticne mâreŋ sâko mâreŋ biŋe qajarewec, i sâcmutâc dâŋ rereŋte erâ mâcne, mamanasiŋ-ticnere erâ kiŋticne behehuc iŋuc ecnewec. ");
INSERT INTO kmg_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Eme biŋe qajarekicne hâcne i sâcmutâc dâŋ rune jaŋere ezac muzac, ine mamanasiŋzi wiac jawane ezac â mitio biŋedâŋ feŋec-nâpokicne i fârimâc ezac. ");
INSERT INTO kmg_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sâcmutâc dâŋzi kiŋte okacne fai-nâŋecko râeekac. Sâcmutâc dâŋ tâmiricko ine qaqatara mi fuaekac. ");
INSERT INTO kmg_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Irec hâcne wiac biŋe qanarekicne i mamanasiŋte erâ fuaocmu. Wemocte? I aki anonoczi feŋeŋ râecneme Abrahamte ɋâricfâc sasawa nâŋâcnao sanaŋkeocte. Sâcmutâc dâŋko roweckembiŋ jaŋe sawa mâcne, Abrahamzi mamanasiŋ hata âtewec ijaha âteeŋgopeneŋ nâŋâcnao mâmâc. Eki hâcne Anuture maio apa wirec-nâŋec ekac. ");
INSERT INTO kmg_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Dâŋqâreŋ šiŋuc hâcne fokac: “Noni go ŋic gurune gurune jaŋere mamac ecmurâ mugarepo.” Abraham e ine Anutu manasiŋkehuc šiŋuc manapaŋkewec: “E hâmoc qâŋɋâŋ bâɋârezo murâ bâɋâreocmu â wiac mi fokac i mume fuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","E ŋicguru bocjaha jaŋere mamac ezokac, dâŋ i mana hameŋke-bipiehuc sifu irec mamanac juwec, šiŋuc âzâcnekicnere: “Ɋâricfâcge iŋuc fuanšoŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Erâ wâc e jara-ticne 100 bazukicnezi e jahacne sahac bâmuzuckekicne â Sarare sahac kereŋkekicne i hone-bipiehuc mamanasiŋ-ticne sifu mi ŋeŋgoroŋkewec. ");
INSERT INTO kmg_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Anutuzi biŋedâŋ âzâcnewec i maname fârimâc mi ewec, ehuc mamanasiŋte sanaŋkerâ Anuture maname fekicne sâko ehame šiŋuc muhuc mana utuckewec: ");
INSERT INTO kmg_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Anutu e wiac mocte biŋe qaocmu i fârine sâcne bâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Irec Abraham e mamanasiŋ focnewecte Anutuzi ere maname kiŋfâsâc ewec. ");
INSERT INTO kmg_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Anutuzi maname kiŋfâsâc ewec, dâŋ i Abrahamte sawa mi qâreŋkekicne, nâŋâcnere wâc mâmâc. ");
INSERT INTO kmg_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Wofuŋ-nâŋec Jesu hâmockonec bâɋârewec Anutu hâcne e manasiŋkepene nâŋâcnere iŋuc jaha maname kiŋfâsâc enaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jesu hâcne kiŋbahac-nâŋecte erâ hâmocko râekicne, erâ wâc kiŋfâsâc enaŋte hâmockonec bâɋârekicne. ");
INSERT INTO kmg_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nâŋâc mamanasiŋte erâ kiŋfâsâc embeŋte Jesu Kristorao qohotahuc Anuture wamao juŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Jesu ekizia motâc ronârewecte akio juŋgopeneŋ wâc. Erâ juku Anuture huriri qâreŋ fua tâcneme hone šiziwenaŋmu irec mamanac juhuc mu šeri eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Erâ i sawa mâcne, hume serereŋ jujure wâc mu šeri eeŋgopeneŋ, ehuc šiŋuc manaeŋgopeneŋ: Hume serereŋ jujuzi maŋuruc bâfuaekac, ");
INSERT INTO kmg_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","maŋuruczi sasanaŋ bâfuaekac, sasanaŋzi sambâŋte woworic bâfuaekac. ");
INSERT INTO kmg_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Sambâŋte woworic juocmuzi ine mi qurutuaocmu. Tiri Mâro nârekicne eki Anuture maŋjauŋ maŋnâŋecko qoŋgiŋkewecte mi qurutuanaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kristo e ŋic nâŋâc hâŋ qa otec qa ehuc juhapene dameŋ-ticne maickeme sâqocne bapa nâŋâcne okacne hâmowec. ");
INSERT INTO kmg_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ŋic tiŋne mocte erâ hâhâmo i ŋic nâŋâcnao mi mecne fokac, mâc ŋic biaŋne mocte erâ hâhâmo ine fufuane mecne. ");
INSERT INTO kmg_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Anutu eki ine, sâqocne bâfuahuc bunao bahuc juhapene maŋjauŋ-ticne bâfuahuc mume Kristozi okac-nâŋec hâmowec. ");
INSERT INTO kmg_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Eme ši socticnere erâ kiŋfâsâc embeŋte okac dameŋko roroŋ sasapec sâcne enâre-jâmbâŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nâŋâc Anutu râsi ecnehuc juhapene ŋokâ-ticnere hâmocte erâ miriŋ bacnâpowec. Eme ši miriŋ bacnâpowecko juju-ticnere erâ sâcne juju saricko râec-nâpo-jâmbâŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Erâ i sawa mâcne, Wofuŋ-nâŋec Jesu Kristozi aki bâfuahuc Anutuhec bâturec-nâpowecte Anutu hâcne mu šeri ecneeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Irec šiŋuc mananaŋ: Ŋic mocjahare erâ sâqocne mâreŋko fuawec, â sâqocnere erâ hâmoc fuawec, ehuc ŋic sasawa jaŋerao fotâcnewec. Iŋuc fuame ŋic sasawa sâqore-fârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Sâcmutâc dâŋ mi fuahame sâqocnezi qanaŋ fuarâ fowec.Erâ sâcmutâc dâŋ arictacte mâc forâ fowefuwec. ");
INSERT INTO kmg_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ehame hâmoczi Adamtao fuŋkerâ ŋic juwefumbiŋ jaŋe ŋicbomboŋ ejare warehuc juhame Mose fuawec, ine dâŋ qâhuckehuc Adamte sâc mi bâfuambiŋ jaŋerao wâc sifu fotâcnewec. Adam e hâcne hâmocte micne bapa ehuctecne, šâhecko jujure micne bapa fuaocte mukicne ere sâsâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Aki anonoczi ine dâŋ qaqare sâc mi ekac. Ŋic mocjaha dâŋ qaqa-ticnere bocjahazi hâmo sipiric embiŋ. Ehame Anuture uruc jauŋ i ine ŋic mocjaha Jesu Kristo ere aki anonocte erâ, Adamte dâŋ qaqa sirickehuc, ŋic bocjaha tahac-nâpokicne ");
INSERT INTO kmg_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ŋifec aki anonoc â ŋifec ŋic mocjaha dâŋ qaqa-ticnere fârine jahe sâcjekic bârâwiŋ. Ŋic mocjahare bahaczi hârâcte mumutara bâfuawec, aki anonoczi ine bahac bocjaha qofackehuc kiŋfâsâc bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ŋic mocjaha dâŋ qaqa-ticnere erâ hâmoczi ŋicbomboŋ ewec, ehame ine aki anonoc fofo dunduŋ â kiŋfâsâc katucmâc fufua i ro maŋ eeŋgopeneŋzi ine ŋic mocjaha Jesu Kristo ere erâ juju sanaŋko ŋicbomboŋ ejâmbâŋkerâ junaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Irec šiŋuc: Ŋic mocjahazi dâŋ qaqa bâfuame ŋic mâmâc sasawa hârâcte biŋe embeŋ, iŋuc jaha ŋic mocjaha tiŋne jume kiŋfâsâc ehuc juju biŋecke-fârembeŋ. ");
INSERT INTO kmg_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ŋic mocjahare qaqatarare bocjahazi sâqorembeŋ, iŋuc jaha ŋic mocjahare dâŋrereŋte bocjahazi biaŋkenaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Sâcmutâc dâŋ e ine sâqocnezi ɋârâŋkeocte ŋondeŋnao rašiwec. Eme sâqocnezi fua fehame aki anonoczi sirickehuc meckecnewec. ");
INSERT INTO kmg_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Fârine šiŋuc fuaocte: Sâqocnezi hâmocte uucmaŋko ŋicbomboŋ ewec jukac, iŋuc jaha aki anonoczi ŋicbomboŋ erâ kiŋfâsâc bacnâpohuc juju sanaŋko râec-nâpozejec. I Jesu Kristo Wofuŋ-nâŋec ere erâ iŋuc fuazejec. ");
INSERT INTO kmg_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Eme weniŋuc muzo? Sâqocnere gie bahuc jaha jupene aki anonoczi fua ɋârâŋkehuc sirickezejec, iŋuc muzo me? ");
INSERT INTO kmg_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Iŋuc misac¡ Sâqocne hâmocnembeŋzi wemocko irec maŋnao šuhuckerâ junaŋmu? ");
INSERT INTO kmg_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Me kecšiŋuc mi manaŋgopieŋ? Miti Opâ ruahuc Jesu Kristorao šuhuckembeŋzi hâmoc-ticnao ŋeutuckembeŋ. ");
INSERT INTO kmg_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ine hâcne, nâŋâc Miti Opâ ruahuc Kristohec mâmâc hâmo duduc ekicne, eme Mamac eri tatamac-ticnezi Kristo bâɋâreme hâmockonec faharewec jukac, iŋuc jaha nâŋâc ɋârerâ juju ɋâri moc junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nâŋâc hâmoc-ticnere hawari ehuc erao šuhuckembeŋte fafahare-ticnao sâc i jaha ehuc šuhuckenaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ʒiŋuc manaŋgopeneŋ: Maŋraŋɋa-nâŋec Jesuhec mâmâc maripoŋko qakicne, i maŋsahac-nâŋecko sâqocnere tâpiri ŋeŋgoroŋkeocte â sâqocnere kiŋaŋ mocwâc mi qanaŋte. ");
INSERT INTO kmg_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Moc e hâmome sâqocnere niŋgiŋ ŋetaracneocmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kristohec hâmombeŋko ine ehuc wâc junaŋmu, iŋuc manapaŋkenaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kristore manaŋgopeneŋ, e hâmockonec fahareweczi mocwâc mi hâmoocmu, hâmoczi ŋicbomboŋ mocwâc mi ecneocmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Hâmowec i sâqocnere arec mocjaha hâmome tarawec eme ši jukac i Anuture erâ jukac. ");
INSERT INTO kmg_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Eme ŋoŋe iŋuc jaha ŋaŋacnere manapie sâqocne hâmocnembiŋ ehuc Jesu Kristo ehec Anutu jucneŋgopieŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Sâqocnezi sahac-ŋeŋic sisirowenao ŋicbomboŋ eŋarezo mume mi manacnenšepieŋ, â sahac-ŋeŋiczi sasecte suruc-ŋopame i wâc mi manacnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Erâ wâc me sahac-ŋeŋic i hehesicte mi qikiŋnepie sâqocnere kiŋaŋ qazejec. Aricne, ŋoŋe hâmockonec bâɋârec-ŋopakicnezi Anuture gieo rašinšepieŋ, ehuc mesahac-ŋeŋic Anuture qikiŋnepie tiŋnere kiŋaŋ qazejec. ");
INSERT INTO kmg_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ŋoŋe sâcmutâc dâŋko mâcne, Anuture aki anonocko jueŋgopieŋte sâqocnezi ŋicbomboŋ mi eŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Eme ši wenac ezo? Anuture aki anonocko rašihapene sâcmutâc dâŋte aka râriewecte sâqocne bazo me? Iŋuc aricne¡ ");
INSERT INTO kmg_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Me ŋoŋe šiŋuc mi manaŋgopieŋ me? Ŋicbomboŋ moc maŋ sahac-ŋeŋic qikiŋnecnehuc micne reŋkeniŋmuzi ere kiŋaŋ qaqafâc erâ gie-ticne baniŋmu. Sâqocnezi ŋicbomboŋ-ŋeŋic eme ere kiŋaŋ qahuc juku hâmo sipiric eniŋmu me micrereŋzi ŋicbomboŋ-ŋeŋic eme ere kiŋaŋ qahuc tiŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ŋoŋe sâqocnere kiŋaŋ qaqa juwarembiŋ i tarawec, eme ši mitire hata qazu-ŋarekicne irec sâcko maŋzi manahuc reŋkeeŋgopieŋ irec Anutu muteŋkezo. ");
INSERT INTO kmg_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ŋoŋe sâqocnaonec batarac-ŋopakicnezi tiŋnere kiŋaŋ qaqa embiŋ juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Maŋraŋɋa-ŋeŋic gegec dodocnere ŋicko wiac fokac ira sâc hehuc dâŋ ŋazakopac. Ŋoŋe mârâc jaha me sahac-ŋeŋic qikiŋnepie sasec â sindaŋ irec kiŋaŋ qaqa ehame kosa jujumbieŋ, eme dameŋ šiŋuczia me sahac-ŋeŋic qikiŋnepie tiŋnere kiŋaŋ qaqa ehame maŋfuru erâ junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Sâqocnere kiŋaŋ qaqa jumbiŋko tiŋnere niŋgiŋ mi foŋarewec. ");
INSERT INTO kmg_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Eme dameŋ ira wemo fârine bâfuambiŋ? Fârine hotâckembiŋ irec šiŋuczia manapie miminehec eekac” eme irec faicnao hâmoc bâbâfuane fokac. ");
INSERT INTO kmg_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Dameŋ šiŋuczia ine sâqocnere niŋgiŋ ŋeŋgoroŋkeme Anuture kiŋaŋ qaqa embiŋ juŋgopieŋ, ehuc fârine maŋfuru rombiŋ â šâhec juju sanaŋ bâfuaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Sâqocnere furine hâmoc rozo, â Anutu aki anonoc-ticnere fârine ine Wofuŋ-nâŋec Jesu Kristo erao šuhuckehuc juju sanaŋ rozo. ");
INSERT INTO kmg_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Âgo bureŋ, sâcmutâc dâŋ mamana ŋoŋere mukopac ŋoŋe kecšiŋuc mi manaŋgopieŋ me? Sâcmutâc dâŋ rereŋke i hâmocko taraekac. ");
INSERT INTO kmg_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Irec hâcne ŋokac moc e ŋowene ɋâricne juhame bebehene mi fokac. sâcmutâc dâŋko iŋuc mukicne. Ŋowe-ticne hâmome ine sâcmutâc dâŋko ŋowe ŋonâŋ jahere mukicne i tarakac. ");
INSERT INTO kmg_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ŋokac moc e ŋowe-ticne ɋâricne juhame beherâ ŋic moctao qohotame šuhuc bâtâcte kiŋ hurekac muzo. Ŋowe-ticne hâmome ine sâcmutâczi niŋgiŋ-jofawec niŋgiŋ i tâcneocmu: ehame ŋic moc baocmuo šuhuc bâtâcte kiŋ mi hureocmu. ");
INSERT INTO kmg_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Âgo bureŋ, ŋoŋere fuŋne ijaha fokac. Kristo e sahac-ticne hâmocte qikiŋnewec, erao šuhuckehuc sâcmutâc dâŋ hâmocnembiŋ. Ʒi ine ru mocte embiŋ. Hâmockonec faharewec jukac ere hâcne embiŋ. Irec nâŋâc Anutu fârine bâfuacnenšepeneŋ¡ ");
INSERT INTO kmg_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Juju raŋɋa jujumbeneŋ dameŋ ira sâqocnere sasec i sâcmutâc dâŋzi šocticne ficneme me sahac-nâŋecko gie-ticne bajujec. Iŋuc enâreme hâmo sipiricte fârine bâfuambeŋ. ");
INSERT INTO kmg_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ʒi ine sâcmutâc dâŋ hâmocnepene niŋgiŋ-ticne tarawecko dâŋqâreŋte hata raŋɋane mi âtehuc Mârore hata ɋâricne âteŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Eme ši weniŋuc muzo? Sâcmutâc dâŋ i sâqocne me? I aricne i¡ Mâc sâcmutâc dâŋ tâmiric muzac, no sâqocnere fuŋne mi mana tarazapo. Sâcmutâc dâŋzi šiŋuc mufua-nâreekac: “Go andac mi ezemec.” Dâŋ i mi fome muzac andacte kâuc bazapo. ");
INSERT INTO kmg_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Sâqocne e ine sâcmutâc dâŋzi ŋesiŋ ecnehame maŋnane suruckeme andac fuŋne fuŋne fuawec. Sâcmutâc dâŋqâhâc mi fome muzac sâqocnezi mâc mâteŋkerâ fozac. ");
INSERT INTO kmg_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","No mârâc jaha sâcmutâc dâŋqâhâc tâmiricko sâcne juhâmopo. Izi šâhec sâcmutâc dâŋzi bâfuacnume sâqocnezi maŋnaneo ɋâreme hâmopo. ");
INSERT INTO kmg_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Sâcmutâc dâŋzi enareme juhâmopemurâ mukicne izi hâcne ŋerisierâ šikanehec ewec. ");
INSERT INTO kmg_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ine hâcne sâqocnezi hobeteŋko ŋesiŋnehuc sâcmutâc dâŋte erâ eatucnuhuc qâhâmocnuwec. ");
INSERT INTO kmg_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Erâ ine šiŋuc: Sâcmutâc dâŋqâhâc e bahacmâc, â bâfâuckehuc moc moc mutâcnekicne i wâc bahacmâc â tiŋne â biaŋne. ");
INSERT INTO kmg_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Hâc, eme dâŋ biaŋnezi hâmoc bâfua-narewec? Iŋuc mâcne, sâqocnezi nuwec. Sâqocne fuŋne-ticne taniŋke-jâmbâŋkeocte dâŋ biaŋnezi âki heha hâmocne nuwec. Sâqocnere manapene gâgâpâcne jâmbâŋ eocte sâcmutâc dâŋzi âki heha nuwec. ");
INSERT INTO kmg_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nâŋâc šiŋuc manaŋgopeneŋ: Sâcmutâc dâŋ e Mârore tofa, no ine mâreŋte tofa, sâqocnere hozine. ");
INSERT INTO kmg_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","No eebapa-nanere manape ririsi eekac. No wiac moc ezo enare-bipieme mi eekopac, â wiac sureekopac ine eekopac. ");
INSERT INTO kmg_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Erâ wiac sureekopac i ehuc ine sâcmutâc dâŋzi biaŋne irec fuŋne bataniŋkeekopac. ");
INSERT INTO kmg_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Eme hehesic eekopac i no nahacne maŋte mâcne, sâqocnezi maŋnaneo fohuc surucnume eekopac. ");
INSERT INTO kmg_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","No fuŋne šiŋuc manakopac: Maŋnaneo, sahac biuc-nanere maŋko hâcne, biaŋnezi fic hae mi ewec jukac, wiac biaŋnere mumu I muekopac, â fârine bâbâfua ine arictac. ");
INSERT INTO kmg_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","No wiac biaŋne ezepac muhuc mi eekopac, â wiac sâqocne mi ezepac muhuc ine eekopac. ");
INSERT INTO kmg_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Sâqocne mi ezo muhuc sifu eekopac ine šiŋucte, i no nahac mâcne, sâqocnezi maŋnaneo fic hae ewecte jâiŋko eekopac. ");
INSERT INTO kmg_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Norao sâcmutâc kecšiŋuc fuaekac: Wiac biaŋne ezo muhape sâqocnezi maicnuekac. ");
INSERT INTO kmg_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","No maŋwâmbuŋ-nanezi Anutu sâcmutâc dâŋticnere mana aŋac eekopac. ");
INSERT INTO kmg_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ehame me sahac-naneo sâcmutâc moc fokac izi maŋ mamanasu-nanere dâŋhec rârâsi eekopirec, ehuc niŋgiŋnume sâqocnere sâcmutâc dâŋ me sahac-naneo fic hae ewec ere kâpâcwâru ŋic eekopac ");
INSERT INTO kmg_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ŋic huacbucne no mozi sahac-nane hâmocte biŋe ekicne hetara-nareocmu? ");
INSERT INTO kmg_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Anutu e Wofuŋ-nâŋec Jesu Kristore erâ muteŋkekopac. Eme šiŋuc hâcne: No nahac maŋ mamanasu-nanezi Anuture sâcmutâc dâŋ kiŋaŋ qacneekopac, sahac-nanezi ine sâqocnere sâcmutâc dâŋ kiŋaŋ qacneekopac. ");
INSERT INTO kmg_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Eme Jesu Kristohec jueŋgopieŋ ŋic i jaŋerao sâqocnere okacne mumutara-jare moc mi fufuane. ");
INSERT INTO kmg_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kristo Jesure erâ juju bâfua-nâreekac Mâro hâcne, ere sâcmutâc dâŋzi sâqocne â hâmoc irec sâcmutâc dâŋ bârârie-nârewec. ");
INSERT INTO kmg_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Sâcmutâc dâŋ e maŋraŋɋa-nâŋeczi tâpirine bawahame nâŋâcnao gie bâipiewec. Irec Anutu e šiŋuc ehuc maŋraŋɋa sâqocne-ticnere tâpiri qame wahawec: Ŋokâ-ticne soreme sâqocne bapa nâŋâcne sahac hawari rorâ sâqocnere due bawec. ");
INSERT INTO kmg_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ine maŋraŋɋare hata mâcne, Mârore hata âteeŋgopeneŋ nâŋâcnao sâcmutâc dâŋrereŋ biaŋ fua-fâreocte iŋuc ekicne. ");
INSERT INTO kmg_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Juju raŋɋare hata âteeŋgopieŋ jaŋe maŋ mamanasu-jeŋic juju raŋɋare wiacte foekac, â Mârore hata âteeŋgopieŋ jaŋe maŋ mamanasu-jeŋic Mârore wiacte foekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Maŋraŋɋare wiacte manasuhuc sisipiric bâfuazo, â Mârore wiacte manasuhuc juju â wama bâfuazo. ");
INSERT INTO kmg_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Maŋraŋɋare wiacte mamanasu izi Anutu kisâ ecneekac. Ehuc sâcmutâc dâŋticne mi dapecneekac, i wemo-ticnezi sâcne ezac¡ ");
INSERT INTO kmg_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Maŋraŋɋahec jueŋgopieŋ jaŋere Anutuzi takickeekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Anuture Mârozi maŋŋeŋicko fic hae ewecko ine maŋraŋɋaopec mâcne, Mâroraopec utuckerâ jueŋgopieŋ. Moc e Kristore Mâro tâmiric juocmuzi ere ŋicbiŋe mi juocmu. ");
INSERT INTO kmg_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kristozi maŋŋeŋicko jukacko sahac-ŋeŋiczi sâqocnere erâ hâmoc ruckekac, â maŋ qâqâtâc-ŋeŋiczi ine kiŋfâsâc bacŋopakicnere juju ruckekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Eme Jesu hâmockonec bâɋârewec Anutu hâcne, ere Mârozi maŋŋeŋicko ŋeŋe juju ekacko, Kristo Jesu hâmockonec bâɋâreweczi maŋŋeŋicko Mâro-ticne jukac ere erâ sahac-ŋeŋic hâmocne i iŋuc jaha bâɋâreocmu. ");
INSERT INTO kmg_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Âgo bureŋ, irec hâcne maŋraŋɋazi wemo nâre tahac eekacte nâŋâc tofa bazucnehuc ere wiacko qohotanaŋmu? ");
INSERT INTO kmg_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ŋoŋe maŋraŋɋare wiacko qohotaniŋmuo sipirickeniŋmu. Á Mârore tâpirio sahacte dâŋ qaniŋmuo ine juju sâcne jurašihuc juniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Anuture Mârozi de âsic ejareha jueŋgopieŋ jaŋe hâcne Anuture naru motecfâc. ");
INSERT INTO kmg_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Anutu e Mâro ŋarewec i kiŋaŋ qaqafâcne juhuc harierâ hâhâwic bacneniŋte mâcne, naru motecfâcne erâ juniŋte ŋarewec. Irec hâcne “Mamac biaŋ-nâŋec” muhuc wasickeeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Nâŋâc Anuture naru motecfâc jueŋgopeneŋ, dâŋ i Mârozi maŋnâŋecko musokame manaeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Naru motecfâcne juŋgopeneŋzi Anuture huhure wâc rauckenaŋmu, Kristohec mâmâc wirec rauckenaŋmu. Ʒira mâreŋko ehec šârâ hâriŋ faio junaŋmuo ehec eri tatamac biaŋko mâmâc jaha junaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Sambâŋko Anutuzi eri aŋac bâfua-nâreocmu, i mâreŋko šâic busâqoc fokac ira sâc hepe mamakâc eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Anuture naru motecfâc eri aŋac-nâŋec fua tâcneocte, wiac bâfuac-jopakicne jaŋe irec woŋec juhuc maŋ hâhâŋ ejareekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Wiac omane jaŋe wâc bie gufec hâmo qanšaraŋte maŋnao râec-jopakicne, erâ jaŋacne maŋte mâcne, ŋiczi sahacko râec ejarewec. Erâ jaŋe iŋuc hati fohuc juniŋte mi mujarekicne. ");
INSERT INTO kmg_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Wiac omane jaŋe wâc hâmo qanšaraŋte niŋgiŋ hetararâ firiehuc Anuture naru motecfâc nâŋâcne eri aŋacko šuhuckeniŋmu hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nâŋâc manaŋgopeneŋ, dameŋ i hâcne maickeocte wiac omane jaŋe harac huacbuc ehuc gozi kicjopame šâic manaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Erâ wiac omane jaŋe sawa iŋuc mi eeŋgopieŋ, sambâŋkonec qaqasune Mâro hâcne nârekicne nâŋâc iŋuc jaha, naru motecfâc-ticne juŋgopeneŋ irec fuŋne Anutuzi, sahac-nâŋec bâfiriehuc, bataniŋkeocte woŋec juhuc maŋzi harac huacbuc eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nâŋâc bâpiaŋ-nâpokicne irec fârine tapamaŋko fokâc. Fârine tâtâc fuame muzac harac huacbuc mi enšapeŋ. Wiac i basahuc ine harac huacbuc ezo. ");
INSERT INTO kmg_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Fârine tâtâc mi fuame honeeŋgopeneŋte maŋzi worickehuc woŋec jueŋgopeneŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mâro e wâc gegec dodoc-nâŋecte erâ bafic-nâpoekac. Nâŋâc iŋuc me iŋuc numupene sâckeocmu, i mi mana-hâmoeŋgopeneŋte Mârozi âkehoc-nâporâ saŋuc ŋiczi mi mamanane i qaekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ehame Anutu e maŋ hohonezi Mârore dâŋ manaekac. Mâro e mitiŋic jaŋere okacne Anutu dâŋsâc-ticnao numuekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nâŋâc manaŋgopeneŋ, Anutu maŋzi jauŋkeniŋmu jaŋe wiac izi me izi fua-jarehuc bâbâpiaŋ-jeŋic dopecke-fâreocmu, ine eki hefârec-jopaocte maname fowecte hefârec-jopawec jaŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ŋic qanaŋ honec-jopame sâckewec jaŋe ŋokâ-ticnere hawari eniŋte mucjopawec. Eme ɋafâc-ticne bocjaha ehapene e jahac ine mârâc hahac-nâŋec erâ juocmu. ");
INSERT INTO kmg_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Anutu e ŋic qanaŋ hone wosâec-jopawec sâc hefârec-jopawec. Hefârec-jopawec sâc kiŋfâsâc bacjopawec. Kiŋfâsâc bacjopawec sâc eric-jopawec. ");
INSERT INTO kmg_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Dâŋ irec fuŋne weniŋuc fokac? Anutuzi âgo enârehame mozi râsi enâreocmu? ");
INSERT INTO kmg_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","E ŋokâ-ticne mi sakarehuc nâŋâcnere erâ qaisockeweczi ere erâ wiac sasawa mi sesi qeqeric jaha tahac-nâpoocmu me? ");
INSERT INTO kmg_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Anutu bâwosâecfâc-ticne jaŋe mozi dâŋko râec-jopaocmu? Anutu e jahac kiŋfâsâc bacjopakac. ");
INSERT INTO kmg_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Me mozi tuŋjopaocmu? Kristo Jesu e jahac hâmowec, erâ hâmowec sawa mâcne, e hâmockonec wâc faharerâ Anuture mefâreo feweczi nâŋâcne riŋ rohuc juekac. ");
INSERT INTO kmg_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kristore uruc jauŋkonec wemozi moc batarac-nâpoocmu? Ʒâic busâqoczi me hume serereŋzi me fific guguriŋzi me roroczi me qarâ suriŋnezi me šârâ šâpâzi me šika kâpâcwâruzi? ");
INSERT INTO kmg_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Dâŋqâreŋ kecšiŋuc fokac irec sâcko wiac enâreeŋgopieŋ: “Gore erâ šoaŋne šoaŋne qa imac enâreeŋgopieŋ, lama qa hezuc eejarene jaŋere sâcko râec-nâpoŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Erâ wiac iŋucnezi mi bâdoc-nâpoocmu, aricne, Jesure uruc jauŋko âtesiŋnehuc sasanaŋ fekicne bâfuarâ domaeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Irec no šiŋuc manapaŋkekopac: Hâmoczi me jujuzi, aŋelozi me ŋicbomboŋzi, wiac šiŋucne fofonezi me šâhec fufuanezi, me wiac tâpirineheczi, ");
INSERT INTO kmg_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wiac faicne wawahanezi me juwicnec wewefunezi, wiac izi me izi Anuture uruc jauŋkonec moc mi batarac-nâpo-jâmbâŋkeocmu. Uruc jauŋ i Wofuŋnâŋec Kristo Jesu ere erâ ɋoroc-nâpoekac. ");
INSERT INTO kmg_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","No Kristore ŋiczi burec mi ehuc dâŋ jâmbomac mupe mananiŋ. Tiri Mârozi maŋnane batamaehame mana-jâmbâŋkehuc ŋazape: ");
INSERT INTO kmg_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","No busâqoc fârine manahuc maŋnane wemo afecne fârorockeekac. ");
INSERT INTO kmg_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Judaŋic âgofâc-nane, soctofafâc-nane hâcne, jaŋere erâ no nahac Kristore sacmaŋkonec wawahare sâcne afeckezapo. ");
INSERT INTO kmg_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Jaŋe hâcne Israe ŋic, eme Anutuzi fuŋfuŋfâc-ticne bacjopawec, ehuc tâpiri tatamac-ticne jowatuwec. Erâ jaŋehec šâšâfic erâ sâcmutâc dâŋ mufua-jarewec â mai ecnehuc juniŋte hatane jowatuwec. Erâ wâc biŋedâŋ jazawec. ");
INSERT INTO kmg_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Á mimiŋnefâc-jeŋic jaŋe mitire fuŋqizecne jumbiŋ. Eme Kristozi ŋicsahac rohuc fuawec i jaŋere guruo fuawec. Wiac sasawa irec Wofuŋ jukac, Anutu hâcne, e mumuteŋheczi mumuteŋhec jurašihuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Wiac iŋuc fuawec irec Anuture dâŋ dodocne ewec mi muzo. Israeraonec fuambiŋ jaŋe Israe ŋic fârine ninic mi efârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Á Abrahamte tofafâc jaŋe ɋâricfâc-ticne fârine wâc mi efârembiŋ. Eme irec hâcne dâŋ šiŋuc âzâcnekicne: “Isakare ɋâricfâc jaŋe sawa gore biŋe eniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Dâŋ irec fuŋne šiŋuc fokac: Sahaczi Abrahamtao fuambiŋ sâc Anuture ŋicfâc mi efârembiŋ, biŋedâŋko fuakicne jaŋe sawa Abrahamte ɋâricfâc fârine embiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Biŋedâŋ kecšiŋuc mukicne: “Jara moc tarame Sarazi motec rorâ bajuhame mocwâc warepemu.” ");
INSERT INTO kmg_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Erâ i sawa mâcne, Rebekarao sâc ijaha fuawec. E mimiŋne-nâŋec Isaka ehec juhuc motec jajahec kiwec-jofawec. ");
INSERT INTO kmg_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Eme motec jahe mi fuahuc wiac biaŋne me sâqocne mi ehapire Anutuzi jahere šiŋuc âzâcnewec: “Hahaczi ɋare kiŋaŋ qazejec.” ");
INSERT INTO kmg_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Ine Anutu mumupaŋ-ticne sanaŋkeocte manasuhuc motec juju-jekicte mâcne, e jahacne maŋte ro bârâwiŋ ejactehuc dâŋ i muwec. ");
INSERT INTO kmg_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Irec dâŋ moc šiŋuc hâcne fokac: “No Jakobore enarewec â Esaure takicnuwec.” ");
INSERT INTO kmg_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Eme irec weniŋuc muzo? Anutu erao guriŋ bapa hehesicne moc fokac me? I aric kereŋne. ");
INSERT INTO kmg_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","E Mose dâŋ šiŋuc âzâcnewec: “No ŋic moc akickezo murâ akickepemu â ŋic moc buuruc ecnezo murâ ecnepemu.” ");
INSERT INTO kmg_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Irec ŋicmaŋte me ŋic eebapare mi muzo, Anutu buuruc-ticnere sawa muzo. ");
INSERT INTO kmg_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Anutuzi Farao dâŋ âzâcnewec, irec miti papiao šiŋuc qâreŋkekicne: “No gorao tâpiri-nane bataniŋkepe šâŋe biŋe-nane mâreŋ sâc raocte muhuc âkendâŋgupo hâcne.” ");
INSERT INTO kmg_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Eme irec Anuture šiŋuc manazo: E ŋic moc akickezo murâ akickeocmu â moc e maŋne bâzickezo murâ bâzickeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Eme ŋifecne šiŋuc mecne nazacmu: “Anutu e ŋic nâŋâcne wemocte maname sâqoreekac? E wiac moc ezo mume ŋiczi aka hehecne i mi fokac.” ");
INSERT INTO kmg_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ŋic go wemogere Anuture dâŋ mucmu? Kušizi wemocko kuzi bapa šiŋuc âzâcneocmu: “Go wemocte sâc iŋucne bacnumeŋ?” ");
INSERT INTO kmg_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Me kuši bapa e afe izia kuši gâcne ŋic jaŋere biŋe â gâcne bec qâto jaŋere biŋe bame sâqoreocmu me? ");
INSERT INTO kmg_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Eme Anutu e kuši kimbeŋ-ticnere biŋe, šâhecko qanšaŋ-joparâ behec-jopaocte maname fokac, kuši i jaŋerao šika bâfuahuc tâpiri-ticne bataniŋkeocte sifu bumâteŋ-ticnere erâ jâbu ejare warehuc juekac. ");
INSERT INTO kmg_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Erâ ŋifecne kuši buuruc-ticnere biŋe, juku eri tatamac-ticnao biric-jopaocte maname fokac, kuši i jaŋerao eri aŋac mâriri hejareocte bacjopa juekac. ");
INSERT INTO kmg_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Eme Judaŋic sawa mâcne, qâpuc mâmâc kuši buuruc-ticnere biŋe enaŋte hefârec-nâpoekac. ");
INSERT INTO kmg_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Eme irec porofete Hoseare papiao dâŋticne šiŋuc fokac: “Ŋicguru mi rucjopapo jaŋe `nore ŋicfâcƷ mucjopapemu, â biŋemâc juwec e šâŋene `joroc-naneƷ mucnepemu.” ");
INSERT INTO kmg_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","“Eme `ŋoŋe nore ŋicfâc aricneƷ ŋazakicne, mâreŋ ira wâc šâŋe-jeŋic `Anutu jujunere naru motecfâcƷ fuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Erâ Jesajazi hahaŋne bahuc Israe ŋic jaŋere šiŋuc muwec wâc: “Israe ɋâricfâcne jaŋe hâwecmecko moŋgeŋ fokac irec sâc bâfuazo murâ bâfuaniŋmu, eme sifu uuc šanšaŋne sawazi biaŋkeniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Wofuŋ e mâreŋko dâŋticnere fârine ɋeŋnea bâfuame fideteŋ efâreocmu. ");
INSERT INTO kmg_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Jesajazi findaŋdâŋ moc šiŋuc hâcne muwec: “Sambaŋ momori jaŋere Wofuŋ e ŋicukic moc mi getâc-jopa-nâreme muzac, ine Sodom jaŋere sâc bâfuanšapeŋ, â Gomora jaŋe iŋucne enšapeŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Eme ši weniŋuc muzo? Kecšiŋuc: ŋic qâpuc tiŋke biaŋ eniŋte mi fotariembiŋzi tiŋke biaŋ embiŋ, mamanasiŋte tiŋke biaŋ embiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Á Israe ŋic sâcmutâc dâŋ reŋkehuc tiŋke biaŋ eniŋte fotariembiŋzi sâcmutâc dâŋ bâmâmâckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Wemocte? šiŋucte: Jaŋe mamanasiŋte mâcne, mâc juju bapa-jeŋicte tiŋke biaŋ eniŋte mumbiŋ. Ehuc hatao qânâ fowec ira kike-jeŋic hezumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kecšiŋuc hâcne qâreŋkekicne fokac: “Manakic, no Zioŋ haeo qânâ moc râekopac ira kike-jeŋic hepirickeniŋmu, â buse ŋeŋene moc hekopac ira heariweniŋmu. Eme moczi e manasiŋkeocmu ine mi qurutuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Qomâfâc-nane, Judaŋic âgofâc-nane biaŋkeniŋte maŋnanezi boc enareme Anutu irec numucneekopac. ");
INSERT INTO kmg_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Jaŋe Anutu kiŋaŋ qacneniŋte šoɋac ehuc jueŋgopieŋ i honeekopaczi mukopac. Erâ i hatane kâuc bahuc eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Jaŋe Anuturaonec kiŋfâsâc eere hata fokac i kâuc baeŋgopieŋte jaŋac tiŋke biaŋ eniŋte giene baeŋgopieŋ. Irec Anutu tiŋne rune mi dapecnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ŋiczi mamanasiŋhec erâ kiŋfâsâc bâfuanaŋte Kristozi sâcmutâc dâŋte hata hebâzicke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mose e dâŋ šiŋuc qâreŋkewec: “Ŋic moc e sâcmutâc dâŋte tiŋke biaŋ hata âteocmuzi juju bâfuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Á mamanasiŋte tiŋke biaŋ eere dâŋ ine kecšiŋuc fokac: “Go maŋgezi šiŋuc mi muzemec: Mozi sambâŋko ferâ Kristo bawahaocmu, ");
INSERT INTO kmg_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","me mozi hârâcko hurâ Kristo hâmokicne jaŋeraonec jowa wefuocmu?” ");
INSERT INTO kmg_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Iŋuc mâcne, tiri papiao kecšiŋuc mukicne: “Miti i šoricko mi fokac, i mumugao â mamanagao râekicne.” I mamanasiŋte dâŋ ŋaza qazuc eeŋgopeneŋ irec mukicne. ");
INSERT INTO kmg_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Jesu e Wofuŋ-nane i mumugao foocmu â Anutuzi Jesu hâmockonec bâɋâre-narewec i mamanagao foocmu eme biaŋkerâ jucmu. ");
INSERT INTO kmg_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Maŋzi Jesu manasiŋkehuc kiŋfâsâc ezo, â miczi e mutaniŋkehuc biaŋkezo. ");
INSERT INTO kmg_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Eme irec hâcne miti papiao kecšiŋuc qâreŋkekicne: “E manasiŋkeocmuzi mi qurutuaocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Judaŋic â Grikŋic bârâwiŋ mi eŋgopeneŋ, e mocjahazi Wofuŋ junâre-fâreekac, erâ wiac fuŋne fuŋne hezu henâreekac. ");
INSERT INTO kmg_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Irec hâcne šiŋuc mukicne: “Wofuŋte šâŋe riwaseckeocmuzi biaŋkerâ juocmu.” ");
INSERT INTO kmg_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ririwasecke i e mi manasiŋkeeŋgopieŋzi wemocko eniŋmu? Anutu mamanasiŋke i dâŋticne mi manaeŋgopieŋzi wemocko eniŋmu? Anutu dâŋticne mamana i biŋe mumu tâmiric wemocko eniŋmu? ");
INSERT INTO kmg_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Á biŋe mumu i moczi jaza sorec mi ejarehame wemocko fuaniŋmu? Dâŋqâreŋ šiŋuc hâcne fokac: “Biŋebiaŋ mumuŋic jaŋere kike fânâŋzi maŋ baafec bâfuaekac.” ");
INSERT INTO kmg_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Biŋebiaŋ ine ŋic gâcnezi mana rereŋ mi embiŋ. Jesajazi wâc šiŋuc muwec: “Wofuŋ, biŋedâŋ muhaŋnekicne i mozi mana šakiewec?” ");
INSERT INTO kmg_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Irec šiŋuc manazo: Mamanasiŋ i miti mu manacte fârine, â miti mu manac i Kristore micte fuaekac. ");
INSERT INTO kmg_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Hâc, eme šiŋuc muhuc wiokopac: Jaŋe miti mi manambiŋ me? Iŋuc mâcne, “Micfânâŋ-jeŋiczi mâreŋ sâcke-fârewec â dâŋjeŋiczi mâreŋ qaŋeŋnao fisiwec.” ");
INSERT INTO kmg_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Eme mocwâc wiohuc mukopac: Israe ŋic jaŋe mi mecne mana-hâmombiŋ? Iŋuc mâcne, qanaŋ Mosezi šiŋuc qâreŋkewec i mupe: “No ŋic omane rocjopape siric-ŋopapie iiŋguuŋ ejarenšepieŋ; ŋicguru mutucne hefârec-jopape buŋeŋic gâpârezejec.” ");
INSERT INTO kmg_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Eme šâhec Jesajazi dâŋ bâutuckehuc kecšiŋuc muwec: “Mi basacnuhuc jumbiŋzi bâfuacnumbiŋ, nore mi muhuc jumbiŋ jaŋe maic-jopapo.” ");
INSERT INTO kmg_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Erâ Israe ŋic jaŋere ine šiŋuc mu qâreŋ ewec: “No ŋicguru mana qâomane â mickobacne dameŋ šora meoric qajarehuc jupo.” ");
INSERT INTO kmg_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Eme wiokopac: Anutuzi ŋicfâc-ticne behec-jopawec me? Aricne, iŋuc mi ewec. Noni Israe ŋic jaha wâc, Abrahamte ɋâric, Benjamiŋte guruonec ");
INSERT INTO kmg_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Anutuzi qanaŋ manac-jopawec ŋic i mi behec­ jopawec. Me ŋoŋe Eliare binaŋ miti papiao i wose manac mi eeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","E Israe ŋic jaŋere dâŋ muhuc Anutu šiŋuc âzâcnewec: “Wofuŋ, jaŋe porofetefâcge jopa-fârehuc alatage henšaŋnembiŋ, eme ši buc juhape no wâc nuniŋte muŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Iŋuc mume Anutuzi dâŋ weniŋuc bâtikiecnewec? “No ŋic 7000 sakarec-jopape Baali nemu mi dapecnembiŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Eme dameŋ ši iŋuc jaha Anutuzi aki anonoc-ticnere erâ ŋic tiwâne rowosâec-jopawec juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","I aki anonoc-ticnere iŋuc ejarewecko juju bapa-jeŋicte mi ejarewec. Iŋuc mi eme muzac, ine aki anonoc fârine mi ezac. ");
INSERT INTO kmg_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Eme weniŋuc? Israe ŋic jaŋe wiac fârine bâfuazo mumbiŋ i mi bâfuambiŋ” rowosâec-jopakicne jaŋe sawa bâfuambiŋ, gâcne sâko ine maŋsanaŋ embiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Irec šiŋuc hâcne qâreŋkekicne fokac: “Anutu e maŋjeŋic bâsifuckewec, šâŋe-jeŋic bâhâpowec â hazec-jeŋic qâzic qawec. Iŋuc ejareha jumbiŋzi jueŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Á Dawidizi mu qâreŋ ewec: “Jaŋe nânâ nahapie râsi fisipie fâfâc-jopazejec, Mâreŋko jopaha okacne fisi-jarezejec. ");
INSERT INTO kmg_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Go šâŋe-jeŋic bâhâpotec tiŋtuŋ qanšepieŋ, â râpe-jeŋic bahasicketec miŋgeŋ miŋgeŋ junšepieŋ sanaŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Eme wiokopac: Israe ŋic jaŋe fâfâc-jopawec i waha qâhâmoc-jopaocte iŋuc fuawec me? Iŋuc aricne, jaŋe bâbâpiaŋ râpeckepie qâpuc jaŋere biŋe ewec, ine qâpuc jaŋe manapie Israe ŋic jaŋe honec-joparâ iiŋguuŋ ejareniŋte iŋuc fuawec. ");
INSERT INTO kmg_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Eme miti qiqikiŋ-jeŋiczi mâreŋ sâc ŋic jaŋerao miti mâriri bâfuawecko, â dodocke-jeŋiczi ŋic qâpuc jaŋerao miti šâkâŋ bâfuawecko, opoŋ, juku furu jaha maŋjeŋic bârisiepie fârine mo iŋucne fuazokac! ");
INSERT INTO kmg_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Qâpuckonec opâ ruac ŋoŋe dâŋ ši ŋazape mananiŋ: No qâpuc ŋoŋere aposolo juekopaczi gie-nane baericko bašihuc baekopac, ");
INSERT INTO kmg_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","i soctofafâc-nane âkeriŋ-jopape gâcnezi bâjâpecnuhuc biaŋkeniŋte. ");
INSERT INTO kmg_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Anutuzi Israe ŋic behec-jopame mâreŋ sâc miti fuawec, izi juku rocjopame mi hâmockonec ɋâɋârezi fuazokac me? ");
INSERT INTO kmg_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Nânâ hata qaqasune jambuŋkepene nânâ mâmâc sâcke-fâreekac, â jâc gâtânezi furu fome tieŋne iŋuc jaha furu foocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Eme Anutuzi tieŋne gâcne hetâcne behec ehuc irec dodoma tacko oliwa kâteo fuakicne irec tieŋne go râe šuhuc egarewec. Eme oliwa gâtânere ŋiŋic wokemaŋzi gume hesiwiŋ egarehame, ");
INSERT INTO kmg_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","go tieŋne raŋɋane mi mana pitiwac-jopahuc maŋfefe mi ezemec. Iŋuc ezicte šiŋuc manac: Go gâtâ gume hesiwiŋ mi ecnekomec, gâtâzi go egareekac. ");
INSERT INTO kmg_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Mupe go ŋifecne šiŋuc mecne mucmu: “Anutuzi no hâcne râe šuhuc enareocte tieŋne raŋɋane hetâcne behec ejarewec.” ");
INSERT INTO kmg_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","I mukic mac. Jaŋe miti qiqikiŋ-jeŋicte hetâcne behec ejarekicne â go ine mamanasiŋgere dodomatac-jeŋicko domakomec. Irec go sahacge mi bafehuc rumerâ juzemec. ");
INSERT INTO kmg_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Anutu e oliwa e jahacne tieŋne mi akickewecko go iŋuc jaha mi akicguocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Irec go buuruc-ticnere mecne â fâro-ticnere mecne mi nikecguzejec. Fâro-ticnere fârine i miti râpeckembiŋ jaŋerao fuawec, â buuruc-ticnere fârine i gorao fuawec. Eme go erao qohotahuc jutec fârine i sâcne fogareocmu. Iŋuc mi etec ine go wâc hetâcne behec egareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Erâ wâc tieŋne raŋɋane jaŋe maŋsanaŋ-jeŋic beheniŋmuo Anutuzi mocwâc râe šuhuc ejarezo murâ sâcne ejareocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Eme kâteonec oliwa rocgurâ hae oliwa jâcnao râe šuhuc egareweczi hae oliwa e jahacne tieŋfâc mocwâc šuhuc-jopazo murâ mi quŋkeocmu, i onšoŋ jaha šuhuc-jopaocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Âgofâc-nane, ŋoŋe, kâuc bahuc ŋaŋacne mamanao roweckerâ mana sifuckenšipiŋte dâŋ soŋne ši mufua-ŋarepe. Israe ŋic tucne jaŋe maŋsanaŋ erâ juhapie qâpuc sâko jaŋe mitire maŋko rašiniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Rašihapie šâhec Israe ŋicguru qâqâhâc biaŋke-fâreniŋmu. Ʒiŋuc hâcne qâreŋkekicne fokac: “Zioŋ haeonec Bâbâpiaŋ moc fuarâ Jakoborao jawa âsu gârec ofaŋneme raocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Iŋuc eme no sâqocne-jeŋic šurerâ jaŋehec mocwâc šâšâfic epemu.” ");
INSERT INTO kmg_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Israe ŋic jaŋe qâpuc ŋoŋere erâ Biŋebiaŋte râsi juŋgopieŋ â rowosâec-jopakicnere ine mimiŋnefâc-jeŋic jaŋere erâ Anuture jorocfâc juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Anutu e âgo šâšâfic dâŋsaric-ticne â hehefâre dâŋticne mi dockeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Qâpuc ŋoŋe mârâc jaha maŋsanaŋ erâ jumbiŋ, eme šâhec Israe ŋic jaŋe maŋsanaŋ ehapie Anutuzi buuruc-ticnao râec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Iŋuc jaha jaŋe maŋsanaŋ juhapie Anutuzi buuruc-ticnao ŋec-ŋopawec, i jaŋe wâc buuruc ejareocte iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Anutu e ŋic sasawa bâturec-jopahuc qaqatarao basanaŋ-jopawec, i mâmâc sasawa buuruc-ticnao ŋec-jopaocte iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Opoŋ, Anutu e mitire mâriri â maŋɋârâŋ â mamana saric-ticne irec šâkâŋne mo iŋucne fokac¡ Mumutara-ticnere fuŋne i ŋiczi mi mamanane gie bapa-ticnere hata i ŋiczi mi hohonene. ");
INSERT INTO kmg_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Wofuŋte maŋko dâŋ fokac i mo ŋiczi manawec, me dâŋ muhame mozi bafickerâ muwec?” ");
INSERT INTO kmg_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Me mo ŋiczi e qanaŋ wiac moc qikiŋnecnewecko tofane bazucneocmu?” ");
INSERT INTO kmg_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Wiac sasawa eraonec wareekac â erao siŋkerâ foekac â erao rafâreekac. Mumuteŋzi mumuteŋ i erao šuhuckeme šuhuc forašihuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Âgofâc-nane, no Anutu buuruc-ticnere erâ dâŋ hazec qâuŋ ŋazape mananiŋ. Ŋoŋe sahac-ŋeŋic Anutu qikiŋnecnepie taha bâzi ɋaɋacne â tirine eme honeme biaŋkezejec. Iŋuc ehuc Anutu kiŋaŋ fârine qacnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Erâ juju bapa-ŋeŋiczi miti tâmiric jaŋere sâc mi ezejec. Ŋoŋe maŋ mamanasu-ŋeŋic bâtikiepie hawarine moc eme Anutu micdâŋ-ticnere sâcko gie biaŋne â hohone šiziwene â tirine irec wosâenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Aki anonoc tahacnukicnere mâmâc sasawa ŋazape mananiŋ: Moc e jahacnere maname fefene boc mi ezejec, Anutuzi miti râcnewec sâc i sawa ezejec, sâc jâuruhuc ine mi ezejec. ");
INSERT INTO kmg_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ʒiŋuc mananiŋ: Fâri ombâŋ-nâŋec mocjaha e kiŋaŋ qaqafâc-ticne bocjahazi gie fuŋne fuŋne baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Eme ŋifec Kristorao iŋuc jaha bocjahazi qâfâsâepene fâri ombâŋ mocjaha ekac, erâ me kikefâcne juhuc dodopec eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Mitire tâpire fuŋne fuŋne i aki anonoc nâre tahac ekicne sâc fonâre rakac. Eme irec sâcko gie banšepeneŋ. Irec moc e Anuture micdâŋ mumufuare tâpiri focnekacko mamanasiŋ-ticnere sâcko muzejec. ");
INSERT INTO kmg_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Moc e kiŋaŋ qaqa giere tâpiri focnekaczi gie i bazejec, â moc e qaqazu gie baocmu e irec tâpiri focnekac sâc bazejec. ");
INSERT INTO kmg_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Uŋsawaŋ dâŋ muekac e irec tâpiri focnekacko muzejec, bâmec gie baekac e maŋticne bawahahuc bazejec, moc e micne juocte mucnekicko šoɋachec juzejec, â moc e jauŋ gie baocmuzi buafec jaha bazajec. ");
INSERT INTO kmg_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Jauŋ babac i sahaczi sawa mi enšepieŋ. Wiac sâqocnere mamakâc-ŋopazejec â wiac biaŋnao qohotanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Ŋoŋe ââgo fârine junšepieŋ, erâ sâsâsec eniŋte sisiric efârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Rokac bârokac tâmiric ɋicwânšâŋhec erâ junšepieŋ. Mârore buŋeŋic bâruŋkezejec, ehuc Wofuŋ kiŋaŋ qacnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Sambaŋ worickehuc bubiaŋ junšepieŋ, â šâic busâqocko maŋuruc junšepieŋ. Erâ nunumu gie i uruc šuhuc jaha banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Anuture mitiŋicfâc hume serereŋ jupie hone bafic ejarenšepieŋ. Ŋic fisipie afeckerâ hezu hewâneŋ ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ŋopa jâpec eŋareniŋmu jaŋe jambuŋ-jopanšepieŋ. Micŋeŋickonec sâwecdâŋ mâcne, jambuŋdâŋ sawa wahazejec. ");
INSERT INTO kmg_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bubiaŋ eniŋmu jaŋe qâtec-joparâ bubiaŋ enšepieŋ, kioniŋmu jaŋe qâtec-joparâ kionšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Maŋŋeŋic bâturehuc wiac mocjahare henširiŋnehuc junšepieŋ. Ŋaŋacnere boc mi manapie sâckezejec. ");
INSERT INTO kmg_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Sâqocnere okac babazuc mi enšepieŋ. Ŋic âgo ejareekac ijaha enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ŋicne Ŋicne jaŋehec wamao juju i eene eme ŋoŋe hâcne irec hatane âtenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Âgofâc, kiŋŋeŋic ŋaŋac mi batarahuc Wofuŋ kimbeŋ-ticnere biŋe râepie fozejec. Dâŋ šiŋuc hâcne qâreŋkekicne fokac: “Kiŋ babatara i nore gie, â okacne babazu i no nahac epemu, Wofuŋ e iŋuc mukac.” ");
INSERT INTO kmg_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ŋoŋe ine šiŋuc enšepieŋ: Râsige nânâre hâmome nânâ gumezemec, opâre hâmome opâ gumezemec. Go iŋuc etecne mimiehuc šara marane eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Sâqocnezi go mi bawahacguzejec. Aricne, go wiac biaŋne ehuc sâqocne bawahazemec. ");
INSERT INTO kmg_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ŋic mâmâc sasawa kia gawamaî jaŋere dâŋ reŋkenšepieŋ. Kia gawamaî gie i Anuturaonec. Juraŋgopieŋ jaŋe Anuture micte juraŋgopieŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Irec moc e kia gawamaî jaŋere dâŋ qâsuahuc Anuture dâŋ qâsuaocmu. Erâ qâsuaniŋmu jaŋe okacne roniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ebapa-jeŋic biaŋne jaŋe kia gawamaî jaŋere mi hâwic-jopaekac, sâqocne baeŋgopieŋ jaŋe ine hâwic-jopaekac. Irec go hâhâwic tâmiric juzo murâ wiac biaŋne ezemec. Wiac biaŋne etec gore manapie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kia gawamaî jaŋe Anuture kiŋaŋ qaqa hâcne, ŋezicgupie juhâmocmurâ mujarekicne. Go sâqocne bacmuo ine hâwicguzejec, jaŋe šika maŋgâŋ mi bajueŋgopieŋ. Jaŋe Anuture kiŋaŋ qaqazi sâqocne bapa jaŋerao bâbâtiŋ gie bahuc okacne jareniŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Irec dâŋjeŋic reŋke-jâmbâŋkezo, erâ i okacnere hâhâwicte sawa mâcne, gahacne maŋzi tutuc qagarezacte wâc dâŋjeŋic reŋkezemec. ");
INSERT INTO kmg_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Jaŋe Anutuzi soŋaŋ gie mujarewec i baeŋgopieŋte hâcne ŋoŋe takesi moneŋ râeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Eme ŋoŋe wiac mukicne sâc ejarenšepieŋ: Takesi jajarere mukicne jaŋe takesi jarenšepieŋ, kiŋaŋ qaqajarere mukicne jaŋe kiŋaŋ qajarenšepieŋ, araŋ babajarere mukicne jaŋe araŋ bajarenšepieŋ, sâsâsec-jopare mukicne jaŋe sâsec-jopanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Wiac omanere tofa bazupie tarazejec, maŋjauŋte tofa mocjaha babazuc epie tatarane ine mi fokac. Maŋjauŋhec juekaczi sâcmutâc dâŋ reŋkekac muzo. ");
INSERT INTO kmg_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Sâcmutâc dâŋ šiŋuc mukicne: Ŋowe ŋonâŋ ŋohe bebehec mi ezepirec, go šika mi qazemec, go fiuc mi rozemec, go andac mi ezemec, sâcmutâc dâŋ i erâ gâcne i mâmâc sasawa qâhâckerâ qizecne šiŋuc mukicne: Gahacnere egareekac sâc ijaha âgogere egarezejec. ");
INSERT INTO kmg_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Maŋjauŋhec juocmuzi âgo-ticne sâqocne mi ecneocmu. Irec maŋjauŋzi sâcmutâc dâŋrereŋ fârine ekac. ");
INSERT INTO kmg_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Iŋuc eniŋte muŋarekicne ŋoŋe dameŋ širec fuŋne manaŋgopieŋ, guŋkonec ɋârerâ faharezo irec šâfo maickekac hâcne. Miti fuŋkerâ manambeŋ ira bâbâpiaŋte dameŋ šošoricne fowec, ši ine dameŋ qândâŋkekac. ");
INSERT INTO kmg_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Ŋafe tarazo ekacte hae fureocte furic râekac. Irec dapâcte wiac hetararâ tatamackonec sându maro menâŋecko rašizejec. ");
INSERT INTO kmg_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ʒoaŋ ɋaɋacko jujune pectâc junšepeneŋ, nâ areŋ â tiwâ kadahe me gae wowo â sasec mamakâc me rârâsi â iiriac i mi ezo, aricne. ");
INSERT INTO kmg_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Wofuŋ Jesu Kristo e ŋaqi-ŋeŋic eme rojunšepieŋ Erâ sahac-ŋeŋiczi sasec bâfuazacte mana manahuc jauŋ bacnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Mitio gegec bititicne jueŋgopieŋ jaŋe âgo miriŋ ejarenšepieŋ, ehuc wiac omanere memeŋgaru epie mu qâsuac mi ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Moc e manabâc tâmiric wiac kosa nâekac, moc e ine memeŋgaru ehuc monšaŋ sawa nâekac. ");
INSERT INTO kmg_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Irec wiac kosa nâocmuzi âgo-ticne nâ bâtâc eekac ere maname wawahane mi ezejec, â nâ bâtâc eocmuzi âgo-ticne wiac kosa nâekac ere maname mi sâqorezejec. E Anuture ŋic jaha wâc. ");
INSERT INTO kmg_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Irec go wemogezi mocte kiŋaŋ qaqa miti babaju-ticnere fuŋne mutec sâckeocmu? E sanaŋkeocmu me dockeocmu, i Wofuŋ-ticnere wiac. Erâ e mi dockeocmu, Wofuŋ e sâcne hume keteŋ ecneme qiŋ herâ domaocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Á šoaŋ gie bapare iŋuc jaha, moc e wose bâtâc eocmu, â moc e maname qâfâsâeocmu. Moczi me moczi iŋuc me iŋuc ezo murâ mana sanaŋkehuc ezejec. ");
INSERT INTO kmg_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ʒoaŋ gie bapa wose bâtâc eekaczi Wofuŋte erâ eekac, â nânâ kosa nâekaczi Wofuŋte erâ eekac wâc, ehuc Anutu nânâre daŋge âzâcneekac. Á nâ bâtâc eekaczi iŋuc jaha Wofuŋte erâ eekac, ehuc Anutu daŋge âzâcneekac wâc. ");
INSERT INTO kmg_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nâŋâcnaonec moczi moc e jahacnere mi juekac â e jahacnere mi hâmoekac. ");
INSERT INTO kmg_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Juju i Wofuŋte jueŋgopeneŋ, hâhâmo i Wofuŋte hâmoeŋgopeneŋ. Irec junaŋmu me hâmonaŋmu i Wofuŋtea enaŋmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Irec hâcne Kristozi hâmokicne â ɋâricne mâmâc Wofuŋ enâreocte hâmorâ wâc ɋârewec. ");
INSERT INTO kmg_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Eme go wemogezi âgogere dâŋ mutaracmu? Me go wemogezi âgogere manatec wawahane eocmu? Nâŋâc mâmâc sasawa Anuture maio fuapene dâŋnâŋec mutara-nâreocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ʒiŋuc hâcne qâreŋkekicne fokac: “Wofuŋzi mukac, no jujâmbâŋkekopacte ŋic šeŋgoma dieŋzi henare-fârenšepieŋ â šeŋgoma micjeŋiczi muafecnunšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Irec nâŋâc mâmâc sasawa Anuturao fuŋne-nâŋec munaŋte munârekicne hâcne. ");
INSERT INTO kmg_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Irec nâŋâc dâŋ mumutarac mi enšepeneŋ. Kecšiŋuc ine ezo: Ŋoŋe âgo gâcne maŋ bâsifuc ejarehuc mamana sâqoc bâfua-jarenšipiŋte manabâcko junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","No Wofuŋ Jesuhec juekopaczi šiŋuc mana sanaŋkekopac: Nânâ i me i nâhuc wâwânâŋhec eene mi fokac. Á moc e, wiac kosa nârâ wâwânâŋhec ezo, iŋuc muhuc sifu nâocmu, e ine jâmbomac wâwânâŋhec eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Go ine âgoge nânâre busâqoc bâfuacnetec maŋjauŋ micke-garezo. Âgoge biaŋkeocte Kristozi ere wâc hâmowec, go irec manasuhuc âgoge nânâre erâ ba imac mi ecnezemec. ");
INSERT INTO kmg_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ŋoŋe wiac fârine bajuŋgopieŋ i ŋic gâcnezi musoriŋkenšipiŋte soŋaŋkehuc bajunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Nânâ qowizi Anuture uucmaŋte fârine mi ekac, kiŋfâsâc fufua â wama â Tiri Mâroraonec šeri bubiaŋ izi wiac fârine. ");
INSERT INTO kmg_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Moc e hata i âtehuc Kristo kiŋaŋ qacneme e Anutuzi honeme biaŋkeocmu â ŋic jaŋe ere manapie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Irec hâcne nâŋâc wama foocte â miti maŋ sâc fua bâbâriŋ eocte hehesanaŋ enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Go nânâre erâ Anuture gie ima mi qazemec. Nânâ qowi i biaŋne sasawa, moc e ine, nârâ maŋbâiŋ gie bapemu, iŋuc manahuc sifu nâme sâqorecneocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Go âgoge maŋbâiŋ ecnezicte ere erâ qowi â waiŋ opâ qikiŋnetec sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Go wiac iŋucnere maŋfâsâcge fokac, i Anuture maio bajutec gahacnao sawa fozejec. Mo e wiac mocte maname sâckeha maŋbahac fâfâsâc eme biaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Á moc e mana maŋjahec eipiehuc sifu nâme sâqorecneocmu, e mamanasiŋ faio me ekac irec. Wiac i me i mamanasiŋ faio mi epene bahacnehec eocmu. ");
INSERT INTO kmg_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Sanaŋheczi gegec dodocne âsi qataŋ ejarenšepeneŋ, nâŋec nâŋâcnere mamanac mi junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nâŋâc âgofâc-nâŋec jaŋere mamanac juhuc biaŋkeniŋte â mitio sanaŋkeniŋte bafic-jopanšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kristo e iŋuc jaha e jahacnere mamanac mi juwec. Dâŋqâreŋ moc šiŋuc hâcne fokac: “Go musoriŋgumbiŋ jaŋere mumusoriŋzi nore faio fekac.” ");
INSERT INTO kmg_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Mârâc jaha dâŋ mu qâreŋ embiŋ, i nâŋâc mitire fuŋne mana-hâmonaŋte embiŋ, dâŋqâreŋ izi hâcne basanaŋ-nâpohuc baafec-nâpome wiac biŋe qanarekicne irec mamanac junaŋte qâreŋkekicne. ");
INSERT INTO kmg_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Anutu e babasanaŋ â bâbaafec runezi eŋareme Jesu Kristore sâko maŋ mamanasu mocjaha erâ junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Ehuc maŋŋeŋic â micŋeŋic tureme Wofuŋ Jesu Kristo ere Anutu â Mamac muteŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Irec hâcne Anuture eri qâreŋ fuaocte Kristozi rocŋopawec iŋuc jaha ŋoŋe maŋzi roroc efârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","No kecšiŋucte ŋazakopac: Anutu e mimiŋnefâc-nâŋec biŋedâŋ mujâmbâŋkehuc jazawec i fârinehec eocte Kristozi mahec nâŋere kiŋaŋ qaqa ewec. ");
INSERT INTO kmg_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Erâ wâc ŋic qâpuc jaŋe Anutu buuruc-ticnere erâ muteŋkeniŋte iŋuc ewec. Dâŋqâreŋ šiŋuc hâcne fokac: “No qâpuc jaŋerao muteŋguhuc šâŋege mumbiaŋkepemu.” ");
INSERT INTO kmg_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Erâ dâŋ moc kecšiŋuc fokac: “Ŋic qâpuc ŋoŋe Anuture fuŋfuŋfâc jaŋehec mu šeri enšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Erâ moc šiŋuc: “Qâpuc ŋoŋe šeŋgoma Wofuŋ mucne bacnenšepieŋ, â ŋicne ŋicne jaŋe e muac baafec ecnenšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Erâ Jesajazi dâŋ moc šiŋuc mu qâreŋ ewec: “Jâctuc Isai gitecne fuarâ eki qâpuc Wofuŋ ejareocmu; eme qâpuczi ere mamanac juniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ʒeŋaŋ rune Anutu e mamanasiŋ-ŋeŋicte bubiaŋ â wama bâfua-ŋareme Tiri Mârore tâpirio ŋesiŋnepie sambâŋ šeŋaŋ-ŋeŋicte manariŋ qâriŋ ŋoŋerao fua ŋeiŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Âgofâc-nane, ŋoŋe uruc jauŋ-ŋeŋic fokac â mitire fuŋne i wâc sâcne mana-hâmoŋgopieŋ, irec ŋaŋaczia faŋ qaqac ezo murâ mi bititieniŋmu, i no fuŋne-ŋeŋic iŋuc hâcne mana sanaŋkekopac. ");
INSERT INTO kmg_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Erâ sifu no Anutuzi miti gie tahacnuwecte dâŋ gâcne i mai qanšaŋ Jaha qâreŋke-ŋarehuc mitire manasu-ŋarekopac. ");
INSERT INTO kmg_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Jesu Kristo e qâpuc ŋoŋere miti kiŋaŋŋic râecnuwecte no Anutu Biŋebiaŋ-ticnere taha bapa gie bape Tiri Mârozi maŋfuru bacŋopame Wofuŋte taha biaŋ enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","No Anuture gie baekopac i Jesu Kristore erâ manape fefene eekac. ");
INSERT INTO kmg_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Gie i nahackoaŋ wemo-nanezi bazapo, aricne, Jesu Kristozi neŋgoc ŋenareha qâpuc jaŋe miti mana rereŋ eniŋte miczi â mezi gie bapo. ");
INSERT INTO kmg_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","No tâpiri â mâsihec juhuc Tiri Mâroraonec hâbi rorâ Jerusalem haeonec fuŋkerâ Kristore Biŋebiaŋ mâreŋ râreckehuc muiŋne rakupe Iliriko ŋ mâreŋko mickewec. ");
INSERT INTO kmg_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ehuc gâcne jaŋere hâsinao bazipore Kristore šâŋe biŋe mi ra fisiwecko furunao šocne qapemurâ herâ wâwânšâŋneekopac. ");
INSERT INTO kmg_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Dâŋqâreŋ šiŋuc hâcne fokac irec sâcko eekopac: “Dâŋ binaŋ-ticne mi ejarekicne jaŋe e honeniŋmu, â biŋe-ticne mi manambiŋ jaŋe mamanahec eniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","No fuŋne iŋucte hâcne ŋoŋerao fâpemurâ dameŋ sâc quŋkeekopac. ");
INSERT INTO kmg_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Juwarepo i ŋoŋerao fâpemurâ maŋzi sawa manahuc jupo, ši ine mâreŋ gâcnao gie-nane tarakacte ");
INSERT INTO kmg_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Sipeî mâreŋko razo ehuc ŋoŋerao fisipemurâ manasukopac. Fisipe ŋoŋehec sahac hâroŋ qaqac erâ ŋoŋeraonec moc moczi qâtecnupie mâmâc Sipeî mâreŋko ranšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Dameŋ šiŋuczia ine mitiŋic kiŋaŋ qajarehuc Jerusalem haeo razo ekopac. ");
INSERT INTO kmg_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Makedonia â Akaia kikefuŋ jaŋe Jerusalem haeonec mitiŋic hapetac dopec-jopaniŋte afeckerâ mupaŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Jaŋe buafec-jeŋicte iŋuc epie sâckewec. Qâpuckonec miti mamana jaŋe Jerusalem haeonec mitiŋic jaŋeraonec miti boreŋ rombiŋte tofa jaŋerao fokac. Eme tofa i hâcne bazu-jareniŋte sahackopec wiac jarepie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Eme mumupaŋ-jeŋicte fârine fuawec i no nahac bararâ jarepe tarame ŋoŋerao fotâcnehuc Sipeî mâreŋko rapemu. ");
INSERT INTO kmg_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Erâ no manakopac, ŋoŋerao metariŋ mi fâpemu, Kristoraonec jambuŋ kadahe bafâpemu. ");
INSERT INTO kmg_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Âgofâc-nane, no Wofuŋ-nâŋec Jesu Kristo ere erâ â Mârore Jauŋte erâ hazec qâuŋ ŋazakopac, ŋoŋe nore erâ Anutu numucnehuc juju gie-nanere baficnunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Baficnupie Anutuzi Judaia mâreŋko ŋic jaŋere meonec bataracnuzejec, â Jerusalem haeonec mitiŋic bubiaŋ wiac jarepe aŋac-jopazejec. ");
INSERT INTO kmg_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Izi šâhec Anutuzi manahame bubiaŋko fârâ ŋoŋerao jumanahuc âke mâteŋnuzejec. ");
INSERT INTO kmg_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Anutu wama rune eki ine ŋoŋehec jufârezejec. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ŋokac âgo-nâŋec Foibe, Keŋkereai kikefuŋ bafic-jopahuc juekac, e fâ fisime ");
INSERT INTO kmg_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ŋoŋe mitio munârekicne irec sâcko Wofuŋte erâ hezu hewâneŋ ecnenšepieŋ. Erâ e irec me irec ecneme bafickenšepieŋ. Ŋokac e no nahacne â gâcne mâmâc kiŋaŋ qanârehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Erâ Prisika â Aqila, Kristo Jesu gie-ticnere babafic jahec-nane jahe jasaniŋ, mamanac-nane jaherao fokac. ");
INSERT INTO kmg_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Jahe hâcne nore erâ sahac-jekic qaisockezo epicte no sawa mâcne, hae sâc kikefuŋ nâŋe jahere bubiaŋ bajueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Jahere ficko mitire tumaŋneeŋgopieŋ ŋic ŋokac i jaŋe wâc mu šeri ejarekopac. Âgo-nane Epaineto, Asia mâreŋ masunao micne barâ Kristoŋic ewec, e wâc mu šeri ecnekopac. ");
INSERT INTO kmg_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Maria e wâc mu šeri ecnekopac âzâcneniŋ, e ŋoŋere erâ gie bocjaha bawec. ");
INSERT INTO kmg_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Androniko â Junia, Judaŋic âgo jahec-nane, kâpâcwâru mâmâc bacnâpokicne, jaherao mamanac-nane fokac i jasaniŋ. Jahe ŋic šâŋe biŋeheczi aposolo jaŋere guruo juhuc, no mâc juhape Kristore miti bânierâ manapic. ");
INSERT INTO kmg_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Mitio âgo-nane Ampiliato e wâc mu šeri ecnekopac. ");
INSERT INTO kmg_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Urbano, Kristore giere babafic embeŋ, â Sitaki âgo-nane jahe wâc mu šeri ejactekopac i jasaniŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Apele, Kristore ŋic fârine, â Aristobulo ere wiacfâc jaŋe mu šeri ejarekopac. ");
INSERT INTO kmg_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Judaŋic âgo-nane Herodioŋ erâ Narikiso wiacfâcne gâcne mitio jueŋgopieŋ, jaŋerao mamanac-nane fokac. ");
INSERT INTO kmg_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ŋokac jahec Tirifaina â Tirifosa, Wofuŋte erâ gie sâko bapic, â Peasi e iŋuc jaha Wofuŋte erâ gie paŋšâic bawec, jaŋe mu šeri ejarekopac wâc. ");
INSERT INTO kmg_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Wofuŋte bufuŋ Rufu â neŋgoc-ticne, e no wâc neŋgoc enarewec, jaherao mamanac-nane fokac. ");
INSERT INTO kmg_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asiŋkrito, Filegoŋ, Hereme, Patoroba, Herema â âgofâc-jeŋic jaŋe mu šeri ejare-fârekopac. ");
INSERT INTO kmg_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filologo â ŋokac Julia erâ Nereo â seŋticne â Olumpa â miti ŋic ŋokac jaŋehec jueŋgopieŋ, jaŋe mâmâc mu šeri ejare-fârekopac. ");
INSERT INTO kmg_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ŋaŋac wâc mitio meo babac enšepieŋ. Hae sâc Kristore kikefuŋ jaŋe ŋoŋere mamanac wâc juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Âgofâc, ŋoŋerao fâfâuc bâfuahuc, miti qazu-ŋarekicne i bâsifuckezo eeŋgopieŋ ŋic i jaŋere ruc bahuc dic bajarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Ŋic iŋucne jaŋe Wofuŋ Kristo mâcne, jaŋe jaŋacne hobu kiŋaŋ qacneeŋgopieŋ. Ehuc mumumbiaŋ dâŋ muhuc ŋic ŋokac omane mu bâmiriŋ ejarehuc eatuc-jopaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Miti mana rereŋ-ŋeŋicte biŋe i hae sâc rafârewec. Eme no irec ŋoŋere bubiaŋ manahuc kecšiŋuc eniŋte ŋazape: Wiac biaŋnere maŋafec junšepieŋ â wiac sâqocnere ine maŋ ŋeŋemâc enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Anutu wama rune eki mi šoraha Sataŋ ro bawaha âte ecneocmu. Wofuŋ Jesu Kristo ere aki anonoczi ŋoŋerao fozejec. ");
INSERT INTO kmg_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Babafic-nane Timoteo â Judaŋic âgofâc-nane Lukio â Jasoŋ â Sosipate jaŋe ŋoŋere mamanac juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Teatio no papia ši (Paulore mickonec(c) qâreŋkehuc iŋuc jaha Wofuŋte maio ŋoŋere manasukopac. ");
INSERT INTO kmg_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gaio e no â kikefuŋ mâmâc sasawa hezu hewâneŋ enâreekaczi iŋuc jaha ŋoŋere manasukac Erâ hae soŋaŋ Erasto â âgo-nâŋec Qâto jahe iŋuc jaha eŋarekopirec,  ");
INSERT INTO kmg_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Wofuŋ-nâŋec Jesu Kristo ere aki anonoczi ŋoŋerao fotâcnerâ fozejec. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Anutu e Biŋebiaŋ muekopac â Jesu Kristore dâŋ muromackeekopac irec sâcko mamanasiŋko keteŋ-ŋopaocte tâpiri focnekac. Anutu juju sanaŋ dâŋticne hâcne soŋne fowarehuc jukume ");
INSERT INTO kmg_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","dameŋ šiŋuczia ere micte muropiekicne â ŋicne ŋicne mana rereŋ eniŋte miti papiao bajaŋgeŋkekicne. ");
INSERT INTO kmg_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Eme Anutu hâcne, buc maŋɋârâŋ juekac, erao Jesu Kristore erâ mumuteŋzi mumuteŋ hati forašihuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Anuture micte Jesu Kristore aposolo epo Paulo no hâcne â âgo-nâŋec Sostene ");
INSERT INTO kmg_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","nâhe Korinti haeonec Anuture kikefuŋ ŋoŋere papia ši râekoperec. Ŋoŋe Jesu Kristozi jambuŋ-ŋoparâ tirimoc juniŋte hefârec-ŋopawec. Iŋuc eŋareme ine hae sâc opâ ruac šira â gâcnao Wofuŋ Jesu Kristo šâŋe-ticne riwaseckehuc jueŋgopieŋ jaŋehec mocjaha embiŋ. ");
INSERT INTO kmg_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Anutu e Jesu Kristore erâ aki anonoc sesic-ŋopawecte no ŋoŋere manasuhuc daŋge berec jaha âzâcneekopac. ");
INSERT INTO kmg_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","E miti mumure aafec â mamana fuŋne fuŋne aameo tahac-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","I Kristore mumutaniŋ dâŋzi ŋondeŋ-ŋeŋicko gâtâ bawecte iŋuc fuawec. ");
INSERT INTO kmg_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Eme mitire wiac moc mi basaeŋgopieŋ. Mâc Wofuŋ-nâŋec Jesu Kristo fua taniŋkeocte woŋec mocjaha jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Eki hâcne Wofuŋ-nâŋec Jesu Kristore fifisi dameŋko kiŋfâsâc domaniŋte hefârec-ŋopame juhapie dameŋ-ŋeŋic taraocmu. ");
INSERT INTO kmg_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Anutu e Ŋokâ-ticne Jesu Kristo, Wofuŋ-nâŋec hâcne, erao šuhuckeniŋte hefârec-ŋopaweczi mocmu mocmu-ticne mi fokac. ");
INSERT INTO kmg_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Âgofâc-nane, no Wofuŋ-nâŋec Jesu Kristo šâŋe-ticnere erâ uŋdâŋ ši mupe mananiŋ: Ŋoŋe dâŋ fuŋne fuŋne â fâfâuc mi bâfuanšepieŋ, aricne. Maŋ mamanasu-ŋeŋic bâturepie mocjaha eha junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Âgo bureŋ, no ŋondeŋ-ŋeŋicko dâŋ fuawec fokac i Koloe ere wiacfâc mupie manapo. ");
INSERT INTO kmg_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Dâŋ kecšiŋucte mukopac: Ŋoŋeraonec moczi muekac `no Paulore ŋic', â moczi muekac “no Apolore ŋic”, â moczi muekac “no Kefare ŋic”, â moczi muekac “no Kristore ŋic.” ");
INSERT INTO kmg_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Hâc, i weniŋuc, Kristozi fâuckewec me? Me Paulo noni ŋoŋere erâ, maripoŋko hâmopo? Me Paulo nore šâŋezi hucŋopaha Miti Opâ ruambiŋ? ");
INSERT INTO kmg_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Sowine no nahac Miti Opâ mi rua-ŋarepo, Krisipo â Gaio jahe sawa rua-jactepo. ");
INSERT INTO kmg_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ŋoŋe šiŋuc munšipiŋte: “Ere šâŋezi hucnâpoha Miti Opâ ruambeŋ.” ");
INSERT INTO kmg_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Mâcne, ši moc manasukopac, Stefana ere wiacfâc jaŋe wâc rua-jarepo, gâcne jaŋere ine mi manakopac. ");
INSERT INTO kmg_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kristozi ŋic Miti Opâ rua-jarepemurâ mâcne, Biŋebiaŋ jaza qazuc epemurâ munarewec. Erâ Kristo maripoŋ-ticnere dâŋ tâpirimâc ezacte maŋɋârâŋ dâŋ ericke bâpiaŋ ehuc mi muekopac. ");
INSERT INTO kmg_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Maripoŋte dâŋ i sisipiric hata âteeŋgopieŋzi manapie racne eekac, â bâbâpiaŋ hatao jueŋgopeneŋzi ine manapene Anuturaonec tâpirihec eekac. ");
INSERT INTO kmg_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Dâŋqâreŋ moc šiŋuc hâcne fokac: “No maŋɋârâŋhec jaŋere dâŋ qape wahaocmu â mamana-jeŋichec jaŋere mamana batackepemu.” ");
INSERT INTO kmg_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Eme maŋɋârâŋhec jaŋe weni? Á mana gufu koparic ŋic jaŋe weni? Á dameŋ širec fuŋne mamana jaŋe weni? Anutu e maŋ mamana-jeŋic bahameŋkewec hâcne. ");
INSERT INTO kmg_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Eme Anuture maŋɋârâŋ dâŋbiri fua-bipieha ŋic jaŋe jaŋacne mamanazi Anuture fuŋne šâŋitaniŋte emâmâŋkembiŋ, irec Anutuzi maname sâckeme mitidâŋ mutucne i manarâ biaŋkenaŋte muwec. ");
INSERT INTO kmg_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Judaŋic jaŋe fuŋne qaqa mâsire qizec qaeŋgopieŋ â Grikŋic jaŋe maŋɋârâŋhec eniŋte fotarieeŋqopieŋ, ");
INSERT INTO kmg_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","nâŋe ine Kristo maripoŋko qakicne irec dâŋ mupene Judaŋic jaŋe manapie quŋke sâqoreekac â qâpuc jaŋe manapie dâŋ mutucne eekac, ");
INSERT INTO kmg_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ehame hefârec-jopakicne, Judaŋic mecne Grikŋic mecne, jaŋe ine Kristore manapie Anutu tâpiri-ticnere â maŋɋârâŋ-ticnere hozine eekac. ");
INSERT INTO kmg_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Ŋic jaŋe Anuture mutucne muhapie mutuc-ticnezi ŋic jaŋere mamana jâuruekac â Anuture dodocne muhapie dodocne-ticnezi ŋic jaŋere tâpiri sirickeekac. ");
INSERT INTO kmg_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Âgofâc-nane. ŋic weniŋucne hefârec-ŋopakicne i mana honeniŋ: Sahackopec wiacte maŋɋârâŋhec bocjaha mâcne, tâpirihec bocjaha mâcne, ŋicbomboŋ guruonec bocjaha mâcne. ");
INSERT INTO kmg_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ŋic maio mutucne jueŋgopieŋ jaŋe Anutuzi hefârec-jopahuc maŋɋârâŋhec mimi qaqa ejareekac, â ŋic maio gegec dodocne jueŋgopieŋ jaŋe Anutuzi hefârec-jopahuc tâpirihec mimi qaqa ejareekac, ");
INSERT INTO kmg_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","â ŋic maio omane â hujukicne jueŋgopieŋ jaŋe Anutuzi hefârec-jopaekac, â ŋic maio bebekâne jueŋgopieŋ jaŋe Anutuzi hefârec-jopahuc šai šonšoŋ-jeŋichec jaŋe siŋ qatara-jareekac. ");
INSERT INTO kmg_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Mâreŋŋic moczi Anuture maio sahac-ticne bafezacte iŋuc hâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","E mitio juju-ŋeŋicte bâbâfua i Kristo Jesu râe-nârewec. Kristo e hâcne Anutuzi maŋɋârâŋ dâŋte rowaŋ-nâŋec â kiŋroro-nâŋec â maŋɋaɋac bâbâfua-nâŋec â kikitâc-nâŋec râe-nârewec. ");
INSERT INTO kmg_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Irec dâŋqâreŋ šiŋuc fokac i sanaŋkezejec: “Moc e mumuteŋ dâŋ muzo murâ Wofuŋtao muzejec.” ");
INSERT INTO kmg_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Âgo bureŋ, no ŋoŋerao fisipo ine Anuture mumutaniŋ dâŋ ŋazapemurâ dâŋ ericke bâpiaŋ ehuc me maŋɋârâŋ dâŋ moc muhuc mi ŋazapo. ");
INSERT INTO kmg_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","No šiŋuc mana sanaŋkehuc fâpo: Dâŋ gâcne aricne, Jesu Kristo maripoŋko qakicne ere dâŋ jâmbâŋ jaha muzepac. ");
INSERT INTO kmg_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Erâ ŋoŋerao dodocne enarehame hâhâwic â memezac faio boc jupo. ");
INSERT INTO kmg_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ehuc miti mumu i maŋɋârâŋ dâŋ mu bâpiaŋ ekicne irec sâcko mi mupo, aricne, tâpiri â Mâro ŋoŋerao fuaocte irec sâcko mupo. ");
INSERT INTO kmg_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","I mamanasiŋ-ŋeŋiczi ŋic maŋɋârâŋ dâŋko mâcne, Anuture tâpirio fosiŋneocte iŋuc epo. ");
INSERT INTO kmg_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Maŋɋârâŋ dâŋ hukicne ine maŋjeŋic ɋârâŋkekicne jaŋe jazaeŋgopeneŋ, erâ i mâreŋ kecširec maŋɋârâŋ dâŋ me mâreŋ ŋicbomboŋ sisirowenezi dâŋ hukicne mueŋgopieŋ irec sâc mi eekac, aricne. ");
INSERT INTO kmg_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Nâŋe Anuture dâŋsoŋ hukicne mufuaeŋgopeneŋ. Dâŋ i ŋic nâŋâc taniŋke ɋaɋac enaŋte Anutuzi mârâc jaha dameŋmâc juwecko mu bâmoc ewec. ");
INSERT INTO kmg_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Mâreŋ ŋicbomboŋ jaŋeraonec moczi moc dâŋ hukicne i hâcne mi mana tarambiŋ, mana tararâ muzac eri tatamac Wofuŋ maripoŋko mi qanšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Irec dâŋqâreŋ fokac ine šiŋuc: “Ʒâŋezi mi honekicne â hazeczi mi manakicne, â ŋicmaŋ moczi moc mi manasukicne, Anutuzi maŋjauŋ ecneeŋgopieŋ jaŋere biŋe bâmockewec i hâcne.” ");
INSERT INTO kmg_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nâŋe ine Anutuzi Mâro-ticne ecneme dâŋ i mufua-nârewec. Mâro e wiac sasawa irec fuŋne mana gufuc efâreekac. Anutu e jahacne fuŋne bâutuckekicne i mâmâc manaekac. ");
INSERT INTO kmg_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Mo ŋiczi âgo-ticnere maŋte fuŋne manaocmu? Maŋ rune eki sawa manaocmu. Eme Anutu maŋticnere fuŋne iŋuc jaha ŋic moczi mi manaocmu, Anutu Mâro-ticnezi buc manaocmu. ");
INSERT INTO kmg_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Eme nâŋe ŋickonec mâro i mi rombeŋ, nâŋe Anuturaonec miti kâdoc hone mana tarac enaŋte Anuturaonec Mâro i rombeŋ. ");
INSERT INTO kmg_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nâŋe miti kâdoc irec hâcne mu binaŋ eeŋgopeneŋ. I ŋic maŋɋârâŋheczi mi qazu-nârembiŋ, i Mârozi qazu-nârewec. Eme Mârore dâŋ i Mârore dâŋmaracko mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ŋic Mâro tâmiric moczi ine Anutu Mâro-ticnere dâŋ mi manaocmu. E wemo-ticnezi manaocmu, aricne, e maname dâŋ fârimâc eocmu. I Mâroheczi mamanane sawa eekac. ");
INSERT INTO kmg_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ŋic Mâroheczi wiac sasawa sâcne mana wosâeocmu, ŋic Mâro tâmiriczi ine ere fuŋne kâuc baocmu. ");
INSERT INTO kmg_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Wofuŋ maŋticnere dâŋ i mozi manaweczi sâcne âzâcne mutâc eocmu? Nâŋe ine Kristo maŋbuc-ticnere dâŋ bajuŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Âgofâc-nane, no ŋoŋerao fisirâ ŋic Mârohec dâŋ jajazane i wemocko ŋazazapo? Aricne, ŋic Mâro tâmiric jajazane i Kristore ɋiefâc ŋoŋe ŋazapo. ");
INSERT INTO kmg_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","No nânâ sanaŋne mi ŋarehuc susu sawa gumec-ŋopapo, nânâ sanaŋne wemocko nanšapiŋ. Erâ šiŋuczia nânâ sanaŋne nâniŋte sâc wâc mi eŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Ŋoŋe Mârohec sâcne mi embiŋ. E tâmiric juhuc hâcne iiriac â kikisâ bâfuahuc ŋic omane jaŋe iŋucne jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Ŋoŋe “no Paulore ŋic”, “no Apolore ŋic” mueŋgopieŋte ŋic iŋucne ŋoŋe ŋic omane hâcne muŋarezo. ");
INSERT INTO kmg_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Apolo e mo? Á Paulo no mo? Nâhe kiŋaŋ qaqa sawazi miti ŋazapere manambiŋ. Erâ Wofuŋzi gie munâctewec sâc bapec. ");
INSERT INTO kmg_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","No he sarac epo, Apolo e hofâ gie bawec, â Wofuŋzi ine jambuŋkeme fârine fuawec. ");
INSERT INTO kmg_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Irec he sarac eekac ere mi muzo, â hofâ gie baekac ere mi muzo, jambuŋkeme fârine fuaekac, Anutu hâcne ere mocjaha muzo. ");
INSERT INTO kmg_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","He sarac eekac â hofâ gie baekac jahe sâcjekic mocjaha, furine ine gie-jekicte sâc bârâwiŋ ronicmu. ");
INSERT INTO kmg_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Nâŋe Anuture babafic, ŋoŋe ine Anuture gie â Anuture fic. ");
INSERT INTO kmg_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Anutuzi gie tahacnuwec sâc no ficbapa fârinezi simeŋ wâtuŋ râepe huwec. Eme irec fainao ŋic moczi fic šuhuckerâ baekac. Iŋucnezi mana manahuc bazejec. ");
INSERT INTO kmg_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Wâtuŋ huwec domakac, Jesu Kristo hâcne, e unucke behec erâ moc râepene huhune mi fokac. ");
INSERT INTO kmg_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Eme wâtuŋ irec fainao moczi goì siliwa me qânâ sanaŋzi, me pipisac sopâc bacrehaczi šuhuckerâ baocmu, ine juku fic bapa-ticnere fuŋne taniŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Juku dameŋ sâkoo hâcne fuŋne taniŋkeocmu. Ira šocsâko bâruŋkeocmu, eme šoc izi hâcne ficgiere fuŋne bataniŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ŋic moczi wâtuŋ faio fic baocmu, i šoczi šâipieme furine roocmu. ");
INSERT INTO kmg_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Á ŋic mocte fic šoczi šafâreme furine tâmiric juocmu, e jahacne ine akickezo, akickehuc šockonec batarazo. ");
INSERT INTO kmg_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Ŋoŋe Anuture miti ufuŋ, â Anuture Mârozi maŋŋeŋicko ŋeŋe juju eekac, i mi manaŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ŋic moc e Anuture ufuŋ ima baocmu e Anutuzi wâc ima baocmu. Anuture miti ufuŋ i furu mukicne, eme ufuŋ-ticne i ŋoŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ŋoŋe maŋŋeŋic mi eatuckenšepieŋ. ŋoŋeraonec moc e ŋicdâŋ mana maŋ ehuc mamana-ticnere maname fefene eocmu, iŋucnezi mamana i qikiŋnehuc mutucne erâ mamana fârine bâfuazejec. ");
INSERT INTO kmg_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Mâreŋte maŋɋârâŋ dâŋ i Anutuzi maname fârimâc eekac. Dâŋqâreŋ šiŋuc hâcne fokac: “E ŋic maŋɋârâŋhec jaŋe maŋsioc gie bahapie somâc-jopame somâmaŋ-ticnao hueŋgopieŋ.” ");
INSERT INTO kmg_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Erâ moc šiŋuc: “Wofuŋ e ŋic maŋɋârâŋhec jaŋere dâŋ maname racne eekac.” ");
INSERT INTO kmg_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Irec ŋoŋe mâreŋŋic nâŋere muhuc maŋfefe mi enšepieŋ. Wiac sasawa i ŋoŋere biŋe. ");
INSERT INTO kmg_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Paulo â Apolo â Kefa nâŋe ŋoŋere biŋe. Erâ mâreŋko wiac sasawa, juju me hâhâmo, šiŋuczia fofone â juku fufuane, i ŋoŋere biŋe sasawa. ");
INSERT INTO kmg_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Ŋoŋe ine Kristore biŋe â Kristo eki ine Anuture biŋe. ");
INSERT INTO kmg_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ŋoŋe nâŋere manapie Kristore kiŋaŋ qaqa â Anutu boreŋ šeŋaŋ-ticnere soŋaŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Eme soŋaŋ e ine metâne juocte mucnekicne. ");
INSERT INTO kmg_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Erâ no nahacnere mupe: Ŋoŋe me ŋic tutumaŋ moczi nore dâŋ muniŋmu i manape fârine mi eocmu. Erâ no nahac wâc fuŋne-nane sâcne mi mupemu. ");
INSERT INTO kmg_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","No bahac-nane moc mi manakopac, erâ irec bahacmâc jukopac mi muzo. Nore fuŋne babataniŋ mocjaha jukac, Wofuŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Irec ŋoŋe fuŋne babataniŋte fâro mi enšepieŋ. Wofuŋ e jahac fisirâ wiac soŋsoŋ fokac i wâc hewirickeocmu, â ŋicmaŋko wiac fokac i mâmâc bâfua-fâreocmu. Eme Anutuzi ŋic sasawa sâcjeŋic manahuc mumbiaŋ-jopaocmu. ");
INSERT INTO kmg_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Âgofâc, dâŋ mukopac i Apolo â no nâhe nâhâcnao iticnehuc mukopac. Eme ŋoŋe nâherao fuŋne kecšiŋuc honehuc mana taranšepieŋ: Mitidâŋko sâc mukicne i mi jâuruhuc wiac efezo â mâreŋŋic bafec bawahac enârehuc maŋfefe mi ezo. ");
INSERT INTO kmg_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Me go ŋiczi wiac hezu hegareniŋte mozi mugarewec? Me go wiac fogarekac i wenimoi gare tahac mi ekicne? Aricne, i gare tahac efârekicne, eme go wemocte manatec mi garekicne tinac eme sahacge bafeekic? ");
INSERT INTO kmg_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ŋoŋe ine biac gapec-ŋopakicne, biac mâriri sâkohec embiŋ juŋgopieŋ, nâŋe tâmiric ŋicwofuŋ embiŋ juŋgopieŋ. Jâmbomac ŋicwofuŋ enšapiŋ me, ehuc hefârec- nâpopie ŋoŋerao šuhuckehuc ŋicwofuŋ jaha enšapeŋ. ");
INSERT INTO kmg_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","No manape Anutuzi aposolo nâŋe ŋic jawane jaŋere guruo râec-nâpowec ekac, šikare biŋe ekicne tinac. Mâmâc sâko, aŋelo mecne ŋic mecne, honec-nâpopie mamakucne eeŋgopeneŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Nâŋe Kristore erâ ŋic mutucne embeŋ, ŋoŋe ine Kristorao šuhuckerâ mamana sâkohec embiŋ, nâŋe gegec dodocne, ŋoŋe ine sasanaŋhec, ŋoŋe fekicne, nâŋe ine waha qaqane. ");
INSERT INTO kmg_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Nâŋe nânâ opâre hâmo sipiric embeŋzi eeŋgopeneŋ, erâ ŋaqi tâmiric â šika faio â fic hae tâmiric jumbeŋzi juŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Á wiac piticne hotâckenaŋte nâŋe nâŋâcne mezi gie baeŋgopeneŋ. Musoriŋ-nâpohapie jambuŋ-jopaeŋgopeneŋ, fific guguriŋ enârehapie mana urueeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Musâqorec-nâpohapie mu bâmiriŋ ejareeŋgopeneŋ, nâŋe ŋic mâmâc sâko jaŋere jawa sânšâŋ tinac jumbeŋzi juŋgopeneŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","No mimi qaqa eŋarepere mâcne, no naru motecfâc-mae ŋoŋe uŋ sawaŋ eŋarehuc dâŋ ši qâreŋkekopac. ");
INSERT INTO kmg_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Kristoo wišecfâc-ŋeŋic guruhec juŋareŋgopieŋ mecne, â mamac ine wemocko bocjaha juŋarenšapiŋ, Kristo Jesure erâ Biŋebiaŋ ŋazahuc no mocjahazi mamac-ŋeŋic epo jukopac. ");
INSERT INTO kmg_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Eme irec nore kike hata bâjâpehuc juniŋte hazec qâuŋ ŋazape mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","No irec erâ hâcne Timoteo, Wofuŋko motec biaŋ-mae junarekac, e ŋoŋerao sorepe fakac, fârâ no Kristore miti hata kikefuŋ hae sâc jaza jowatuc eekopac i manasu-ŋareme mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Ŋoŋeraonec gâcnezi e mi wareocmu, nore iŋuc muhuc mukac mupe embiŋ. ");
INSERT INTO kmg_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","No ine Wofuŋzi maname sâckeme mi šoraha ŋoŋerao fâpemu, fârâ mukac mupe eeŋgopieŋ jaŋe dâŋjeŋicte mi muhuc tâpiri-jeŋicte fuŋne bataniŋkepemu. ");
INSERT INTO kmg_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Anuture miti hata i dâŋko mâcne, sasanaŋko fua taniŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Eme ŋoŋe nore weniŋuc muŋgopieŋ? Kâcbiŋhec fâpemurâ muŋgopieŋ, me maŋjauŋ â buuruchec fâpemurâ muŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","No šiŋuc ine jâmbomac mupie manaekopac: Ŋoŋerao mamakâc hâhâwicne, qâpuc jaŋerao mi fufuane, iŋucne fuawec fokac. Ŋic moczi mamac-ticnere ŋonâŋhec juekac, irec mukopac. ");
INSERT INTO kmg_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Eme ŋoŋe wemocte wiac iŋucne fuarâ fohame pepecne eeŋgopieŋ? Ŋoŋe busâqoc manahuc ŋic wiac ewec e behenšapiŋ me¡ ");
INSERT INTO kmg_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","No sahac-nanezi wiwicko juhuc maŋnanezi iqic-ŋoparâ ŋic wiac ewec ere dâŋ ŋondeŋ-ŋeŋicko juhuc tinac kecšiŋuc mutarapo: ");
INSERT INTO kmg_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ŋoŋe Wofuŋ Jesu ere šâŋeo tumaŋnehapie no ere tâpirio ŋesiŋnehuc maŋnanezi iqic-ŋopape ");
INSERT INTO kmg_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ŋic e Sataŋ qikiŋnecnepene maŋ sahac raŋɋa-ticne sipirickezejec, eme Wofuŋ Jesure dameŋ maickeme mâro-ticnezi aakic bâfuazejec. ");
INSERT INTO kmg_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Wiac iŋucne foipiehame sahac-ŋeŋic bafeeŋgopieŋte manape sâqorekac. Bec hâhâtâne i wiac piticnezi fârine ruacneme rikepie isirickeme hâtâne efâreocmu, i mi manaeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Irec hâhâtâne wosâerâ behepie rahame fârine nocne enšepieŋ. Ŋoŋe hâhâtâ-ŋeŋic ŋowac rofârekicne. Nâŋâcne aakic lama okac-nâŋec qakicne wâc, Kristo hâcne. ");
INSERT INTO kmg_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Irec hombaŋ-ticne ŋenaŋte wiac hâhâtâne behenšepeneŋ. Mamakâc â sindaŋ irec hâhâtâne qikiŋnerâ wiac ɋaɋacne â tiŋne irec fârine nocne bajuhuc hombaŋ-ticne ŋezo. ");
INSERT INTO kmg_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","No mârâc papia moc šiŋuc qâreŋke-ŋarepo: “Ŋoŋe sasecŋic jaŋehec wiac nâ nareŋ gareŋ â iiqic mi enšepieŋ”, ");
INSERT INTO kmg_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","i ŋic qâpuczi sasecŋic me bâkiri bapa â fiuc serereŋhec me bawe qaŋgec wiac babaju jueŋgopieŋ jaŋere mi mupo. Jaŋe mâreŋ behehuc behec-jopazo i sawa fokac. ");
INSERT INTO kmg_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","No kecšiŋucte qâreŋke-ŋarepo: Miti mamana âgo-ŋeŋic moczi sasecko sâqoreocmu me bâkiri baocmu, me bawe qaŋgec wiac bajuocmu, me fiuc serereŋ eocmu, ŋic iŋucne behehuc ehec nâ nareŋ gareŋ moc mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","No ŋic râpene jueŋgopieŋ jaŋere dâŋ mumure wemocko qâreŋkezapo. ŋaŋacne ŋondeŋko miti mamana jaŋere bahacdâŋ mupie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Á râpene jueŋgopieŋ jaŋere bahacdâŋ i Anutuzi muocmu. Sâqocne bapa e behepie ŋondeŋ-ŋeŋicko mi juzejec. ");
INSERT INTO kmg_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Ŋoŋeraonec moczi âgo-ticnere bahacdâŋ bajuocmu, e dâŋ i mitiŋic jaŋerao mi rârâe ŋic miti tâmiric jaŋerao râeme sâckeocmu me? ");
INSERT INTO kmg_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Mitiŋic nâŋâc juku miti tâmiric jaŋere dâŋ mutaranaŋmu, i mi manaŋgopieŋ me? Me juku gie iŋucne baniŋte muŋarekicnezi ŋaŋacne dâŋ jawane fuame sâcne mi mutaraniŋmu me? ");
INSERT INTO kmg_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Nâŋâc aŋelo jaŋere dâŋ wâc mutaranšoŋgopeneŋzi wiac omanere dâŋ fuame wemocko bititienaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Wiac omanere dâŋ fuame ŋoŋe wemocte kikefuŋzi mana-jareme wawahane eekac ŋic iŋucne jaŋerao barapie mutara-ŋareeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Ŋoŋe dâŋ i manapie miminehec eocte ŋazakopac. Ŋoŋerao ŋic maŋɋârâŋhec moc mi jukac me? Eme dâŋŋeŋic fuame erao barapie mutiŋne-ŋarezac. ");
INSERT INTO kmg_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ŋoŋe ine iŋuc mi eeŋgopieŋ, aricne, miti mamana moczi âgo-ticnehec dâŋbahac-jekic fuame miti tâmiric jaŋerao barame mutara-jacteniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ŋoŋerao dâŋgie fuaekac izi miti-ŋeŋic bawahaekac. Gâcnezi wiac hehesicne me bâbâsifucne eŋarezo murâ eŋarepie ŋifecpeaŋ fozac me¡ ");
INSERT INTO kmg_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ŋoŋe ine ŋaŋac wiac hehesicne â fiuc serereŋ eeŋgopieŋ, ehuc mitio qomâfâc-ŋeŋic mâmâc ejareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Sâqocne bapazi Anuture uucmaŋko rarašine mi fokac, i mi manaŋgopieŋ me? Ŋoŋe maŋŋeŋic mi eatuckeniŋ, sau bapa, me  bawe qaŋgec babaju, me ŋokac ba behecne, me sasecŋic, me ŋiczia mamakâc eec eene, ");
INSERT INTO kmg_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","me fiuc roro, me bâkiri bapa, me maŋsifuc opâ nâ areŋ eene, me dâŋ bâbâiŋ, me kâŋgâc rohuc šika qaqa, iŋucnezi Anuture uucmaŋko mi rašiniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Eme gâcne ŋoŋe mârâc sâc iŋuc hâcne jujumbieŋ ši ine šurec-ŋopakicne â maŋfuru bacŋopakicne â kiŋfâsâc bacŋopakicne. I Wofuŋ-nâŋec Jesu Kristore šâŋe bajueŋgopieŋte â Anutu-nâŋecte Mârohec jueŋgopieŋte iŋuc eŋarekicne. ");
INSERT INTO kmg_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Wiac sasawa eene fonarekac, erâ wiac sasawa epe izi sâcne mi baficnuocmu. Wiac sasawa eene fonarekac, erâ wiac moczi ŋicbomboŋ enareme irec kiŋaŋ qaqa juju ine misac. ");
INSERT INTO kmg_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Nânâ qowizi hobure biŋe â hobuzi nânâ qowire biŋe. Juku Anutuzi e â e mâmâc imac-jofame arictac enicmu. Sahaczi ine sasecte biŋe mâcne, i Wofuŋte biŋe, Wofuŋ e sahacte ru. ");
INSERT INTO kmg_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Eme Anutuzi Wofuŋ bâɋârewec iŋuc jaha tâpiri-ticnezi nâŋâc bâɋârec-nâpozokac. ");
INSERT INTO kmg_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Sahac-ŋeŋic Kristore kiŋaŋ qaqa, i mi manaŋgopieŋ me? Eme Kristore kiŋaŋ qaqa e weniŋuc qârisiepene sasecte kiŋaŋ qaqa eocmu? Iŋuc aricne. ");
INSERT INTO kmg_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Me ŋoŋe šiŋuc mi manaŋgopieŋ, ŋic moczi ŋokac sâqocne moctao qohotame jahe maŋ sahac mocjaha enicmu. Dâŋqâreŋ šiŋuc hâcne fokac: “Jahe jajaheczi mocjaha erâ junicmu.” ");
INSERT INTO kmg_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Á moc e Wofuŋtao qohotame ehec maŋ qâqâtâc mocjaha enicmu. ");
INSERT INTO kmg_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Ŋoŋe sasec boe sau dic bacnenšepieŋ. Ŋic moczi wiac hehesicne gâcne eocmu izi sahac-ticne mi heuaocmu, â boe sau eocmuzi ine e jahacne sahac bâbieocmu. ");
INSERT INTO kmg_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Me ŋoŋe šiŋuc mi manaŋgopieŋ, sahac-ŋeŋic i Tiri Mârore ufuŋ, e ŋoŋere sahacmaŋko ŋeŋe juju eocte Anutuzi râe-ŋarewec. Ŋoŋe maŋ sahac rune aricne. ");
INSERT INTO kmg_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Ŋoŋe furi-ŋeŋic rokicne. Irec sahac-ŋeŋiczi Anuture šâŋe biŋe dopeckezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ŋoŋe papia râe-narehuc dâŋ wio-narembiŋ, irec šiŋuc mufuape mananiŋ: Ŋic moczi ŋokac tâmiric juzo mume sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Erâ sasecte eesâic fokacte ŋiczi ŋokac rorâ ehec paŋšâic juzejec, â ŋokaczi iŋuc jaha ŋic rorâ ehec paŋšâic juzejec. ");
INSERT INTO kmg_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Eme ŋiczi sahac-ticne i ŋonâŋ-ticne mi sakarecnezejec, â ŋonâŋzi sahac-ticne ŋowe-ticne mi sakarecnezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Ŋonâŋ e sahac-ticnere dâŋ mumu i jahacne mâcne, ŋowe qikiŋnecnekicne, â ŋowe e iŋuc jaha sahac-ticnere dâŋ mumu i jahacne mâcne, ŋonâŋ qikiŋnecnekicne. ");
INSERT INTO kmg_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Ŋowe ŋonâŋ ŋoŋe sahac sasakarec kosa mi enšepieŋ. Mâc nunumure afeckeniŋte qanaŋ muc manac erâ dameŋ bahuc iŋuc epie sâckeocmu. Dameŋ tâmiric mâc jufepie Sataŋzi esâic-ŋopazacte iŋuc mukopac. ");
INSERT INTO kmg_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Ŋic â ŋokac roroc eniŋte mukopac i mana urue-ŋarehuc mukopac, mupaŋke-ŋarehuc mâcne. ");
INSERT INTO kmg_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Nahacne maŋzi šiŋuc mukac: Ŋic sasawa no jukopac iŋuc jufârenšapiŋ me. Anutu e ine tâpiri buc buc tahac-nâpoekac i hatane bârâwiŋ, moc iŋuc â moc iŋuc. ");
INSERT INTO kmg_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Ŋic ŋokac šeŋoŋ â hozec jaŋere ine šiŋuc mukopac: Jaŋe no iŋucne jufepie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Me sasec tâmiric sâcne jujune mi fojarekacko ine sasecte šoczi sipiric-jopazacte ŋowe ŋonâŋ erâ junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ŋowe ŋonâŋ ŋoŋere dâŋ mupe mananiŋ, erâ i nore dâŋ mâcne, i Wofuŋte micdâŋ: Ŋokac moczi ŋowe-ticne mi behezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Á ŋowe-ticne biac behewecko ŋic tâmiric juzejec, me ŋowe-ticnehec mocwâc âgo babac ezepirec. Erâ ŋic moczi iŋuc jaha ŋonâŋ-ticne mi behezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Gâcne jaŋere dâŋ ši mupe manapie Wofuŋte mâcne, no nahacne ezejec: Opâ ruac ŋic moc ere ŋonâŋ qâpuc juocmu, eme ŋokac izi ehec juocte ecneocmuo mi behezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Me opâ ruac ŋokac moc ere ŋowe qâpuc juocmu, eme ŋic izi ehec juocte ecneocmuo mi behezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Ŋic qâpuc erao ŋonâŋ-ticnere jambuŋzi fotâcnewec, â ŋokac qâpuc erao ŋowe-ticnere jambuŋzi fotâcnewec. Eme irec hâcne naru motecfâc-ŋeŋic jambuŋhec embiŋ juŋgopieŋ, I tâmiric muzac qâpuc junšapiŋ. ");
INSERT INTO kmg_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Oapuc ŋiczi me qâpuc ŋokaczi ine âgo-ticne miti mamana beheocte qizec qame mi sakarezejec. Irec niŋgiŋne mi fokac. Anutu e wamao ââgo erâ juniŋte hefârec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Ŋokac go ŋowege miti hatao fâretec wareocmu me mâcne, i moc manakic me? Me ŋic go ŋonâŋge miti hatao fâretec wareocmu me mâcne, i moc manakic me? ");
INSERT INTO kmg_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Moc e Wofuŋzi ju ju bâfuacnewec, â moc e Anutuzi gie mucnewec, sâc ijaha mitio juzejec wâc. No dâŋ iŋuc kikefuŋ hae sâc jaza mutâc eekopac. ");
INSERT INTO kmg_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Moc e mahec juhame Wofuŋzi hefârewecko ma i mi behezejec. Á moc e ma tâmiric juhame Wofuŋzi hefârewecko mare mi muzejec. ");
INSERT INTO kmg_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Mahec juju me ma tâmiric juju izi fârine mâcne, Anuture sâcmutâc dâŋ rereŋ izi fârine ekac. ");
INSERT INTO kmg_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Moc e dodoma ira me ira domahame Wofuŋzi hefârewecko dodoma ijaha domazejec. ");
INSERT INTO kmg_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Go kiŋaŋ qaqa juhaŋtec hefârecguwecko manabâc tâmiric Juzemec. Mâc firuecguzo mupie mi qikiŋnezemec. ");
INSERT INTO kmg_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Moc e kiŋaŋ qaqa juhame Wofuŋzi hefâreme Wofuŋte ŋicfâri ewec Jukac. Á moc e ŋicfâri juhame Wofuŋzi hefâreme Kristore kiŋaŋ qaqa ewec jukac. ");
INSERT INTO kmg_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Ŋoŋe furi-ŋeŋic rokicnere ŋic jaŋere kiŋaŋ qaqa mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Âgo bureŋ, moc e mârâc domahuc miti manawec, biri ijaha dameŋ šiŋuczia domahuc Anuturao qohotazejec. ");
INSERT INTO kmg_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Naru šeŋoŋ jaŋere Wofuŋte micdâŋ mi bajukopac. Erâ Wofuŋzi roroŋ fâre-nareme mitihec epore nahacne dâŋ ŋazape mananiŋ: ");
INSERT INTO kmg_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Dameŋ šiŋuczia šârâ hâriŋ boc fuaekacte ŋic moc ŋonâŋ tâmiric juzo mume manape biaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Á ŋokac biŋe biac mugarekicko ine mi qikiŋnezemec, me go mesawane jukicko ine ŋokacte mi muzemec. ");
INSERT INTO kmg_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Me ŋokac rozo murâ rotec wâc mi sâqoreocmu, â naru šeŋoŋ moczi ŋic rome wâc mi sâqoreocmu. Erâ iŋucnezi sahackopec wiacte hume serereŋ juniŋmu. No ine i tâmiric mac juniŋte enareha mukopac. ");
INSERT INTO kmg_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Âgofâc-nane, dâŋ ši mupe mananiŋ: Dameŋ rifirekac. Eme dameŋ bembeŋne fokacte ŋonâŋhec jueŋgopieŋzi jupie ŋonâŋ tâmiric juju tinac ezejec, ");
INSERT INTO kmg_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","â kioeŋgopieŋzi jupie ki tâmiric tinac ezejec, â šeri eeŋgopieŋzi jupie šeri tâmiric tinac ezejec, â wiac furi baeŋgopieŋzi jupie mafa tâmiric tinac ezejec, ");
INSERT INTO kmg_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","â wiac nâ bac eeŋgopieŋzi jupie i tâmiric tinac ezejec. Mâreŋ hawari qâreŋne ši hone manac eeŋgopeneŋ i siroweocmu ekac, irec hâcne dâŋ i mukopac. ");
INSERT INTO kmg_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ŋoŋe ine wiac omanere mana mezac tâmiric erâ juniŋte manasuhuc mukopac. Ŋonâŋ tâmiriczi Wofuŋte giere mana mezac eocmu, ehuc Wofuŋzi manacneme biaŋkeocte muocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ŋonâŋheczi ine sahackopec wiacte mana mezac eocmu, ehuc ŋonâŋ-ticnezi manacneme biaŋkeocte muocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Iŋuc erâ maŋguru eocmu. Eme ŋokac šeŋoŋ â naru šeŋoŋ jaŋe iŋuc jaha Wofuŋte giere mana mezac eniŋmu, ehuc maŋ sahac-jeŋic Wofuŋte biŋe eocte manasuniŋmu. Á ŋokac ŋoweheczi ine sahackopec wiacte mana mezac eocmu, ehuc ŋowe-ticnezi manacneme biaŋkeocte muocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Ŋoŋe sâcne juhâmoniŋte dâŋ ši ŋazakopac, qaisoc-ŋopahuc mâcne, ŋoŋe kosa mi juhuc maŋ mamanasu-ŋeŋic qâzuckepie Wofuŋtea hâcbuc domaocte mukopac hâcne. ");
INSERT INTO kmg_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Me ŋic moc e otâ-ticne ŋic roronere sâc bâfuaha sakareocte maname mi sâckeme ŋicko râezo murâ râezejec, i mi sâqoreocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ŋic moc e ine maŋticnezi šiŋuc mana sanaŋkeocmu, otâ-nane mâc juzejec, iŋuc murâ maname mi quŋkeocmu, ehuc afeckerâ iŋuc mupaŋkeme sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Irec ŋic moc e otâ-ticne ŋicne ŋicko râeme sâsâckecne eocmu, â moc e otâ-ticne sakareme ine sâcke-hâmoocmu. ");
INSERT INTO kmg_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Ŋokac moc e ŋowe-ticne juocmu sâc gâjoŋnao bohotarâ domazejec. Ŋowe-ticne hâmome ine ŋic moc me moc rozo murâ rozejec, erâ kosa ehuc mâcne, Wofuŋtao roweckehuc ezejec. ");
INSERT INTO kmg_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Ŋowe tâmiric mâc juocmu irec ine manape sâcke-hâmoocmu. I nahacne dâŋ, erâ i Anuture Mâro wâc fonarekacte mukopac. ");
INSERT INTO kmg_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Ʒi nemure tiwâ šepecte mupe. Nâŋâc fuŋne mamana jufâreŋgopeneŋ i manaŋgopeneŋ. Erâ fuŋne mamana saware sahac fefe fuaocmu, maŋjauŋhec juhuc ine hehešakiec erâ sâcne juzo. ");
INSERT INTO kmg_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Moc e mamana-ticne mana sokame ere muzo, mamana fârine mi focnekac. ");
INSERT INTO kmg_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Moc e Anutu maŋjauŋ ecneocmu, e ine Anutuzi manariŋkewec. ");
INSERT INTO kmg_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Nemure tiwâ šepecte ine šiŋuc manaŋgopeneŋ: Nemu e wiac fârine mâcne, Anutu e mocjaha fârine. ");
INSERT INTO kmg_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Nemu sambâŋko me mâreŋko juŋgopieŋ, dâŋ iŋuc mupie nemu â wofuŋ burec burec wemo afecne foraŋgopieŋ ekac. ");
INSERT INTO kmg_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","Á nâŋâc ine Anutu Mamac-nâŋec mocjaha junârekac, eraonec hâcne wiac sasawa fua-fârewec â nâŋâc erea juŋgopeneŋ. Erâ Wofuŋ mocjaha, Jesu Kristo, ere meo wiac sasawa â nâŋâc jufâreŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ŋic gâcne jaŋe ine fuŋne iŋuc sâcne mi mana-hâmoŋgopieŋ. Eme iŋucnezi nemu e wiac fârine muwarehuc juku maŋjeŋic ewecte tiwâ šepec e araŋ bacnehuc manabâcko nâpie maŋjeŋic hegâpâreekac. ");
INSERT INTO kmg_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Anutu e nânâre erâ mi mana-nâreme biaŋkeocmu. Tiwâ šepec qikiŋnepene mi mana wahac-nâpoocmu, me nâpene mi mana-nâreme feocmu. ");
INSERT INTO kmg_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Mâc gâcne ŋoŋe mana jaŋgeŋkehuc nâeŋgopieŋzi âgofâc-ŋeŋic miti afecne fojareekac jaŋe maŋ bâsifuc ejarenšipiŋte manabâc enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Go qarâ sanaŋgere nemu ufuŋko šepecne nâhuc ŋehaŋtec âgoge moc manabâcheczi honecgurâ, nakacte nâpe muhuc mi ijaha nâocmu me? ");
INSERT INTO kmg_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Eme âgoge miti afecne focnekac e Kristore soczia wâc kitâcneweczi gore qarâ sanaŋte mi docke sâqorec eocmu me? ");
INSERT INTO kmg_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Ŋoŋe iŋuc ehuc âgofâc-ŋeŋic wâwânâŋ ejarehuc maŋ bâsifuc ejareniŋmu, ine Kristo wâwânâŋ ecneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Irec no tiwâ šepec nâpe âgo-nanezi irec erâ docke sâqorec ezacte ere manabâc ehuc tiwâ šepec qikiŋnehuc mâc juku hâmozepac. ");
INSERT INTO kmg_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","No niŋgiŋhec juekopac me? No aposolo aricne me? No Wofuŋ-nâŋec Jesu mi honepo me? Gie-nanere fârine Wofuŋte jambuŋko fuakicne i ŋoŋe mi eŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","No gâcne jaŋere aposolo mi mecne juekopac, â ŋoŋere ine jâmbomac juekopac. Aposolo gie-nanere ma Wofuŋte jambuŋko fuakicne i ŋoŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Fuŋne-nanere mueŋgopieŋ jaŋe ine dâŋ šiŋuc bâtikie-jarekopac. ");
INSERT INTO kmg_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Gâcne nâŋe ŋoŋeraonec nânâ opâ mi ronaŋte muac-nâpokicne me? ");
INSERT INTO kmg_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Aposolo tucne â Wofuŋte ɋafâc â Petoro jaŋe ŋonâŋfâc-jeŋic jaŋehec miti kiŋaŋ raeŋgopieŋ, ehame gâcne nâŋe sâc ijaha enaŋte mi mana-nârekicne me? ");
INSERT INTO kmg_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Me no â Banaba nâhe sawa mezi gie bapa behenacte mi mana-nâctekicne me? ");
INSERT INTO kmg_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Me mo momori ŋiczi šikare wiac e jahacne moneŋzi furine baocmu? Me mozi gie he sarac eme fârine fuame mi ro nâc eocmu? Me mozi noniŋ bulimakao gie bahuc jaŋere susu ba nâc mi eocmu? ");
INSERT INTO kmg_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ʒi ŋicdâŋ sawa mukopac me? Sâcmutâc dâŋzi ijaha mi mufuakac me? ");
INSERT INTO kmg_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Mosere sâcmutâc dâŋ moc šiŋuc qâreŋkekicne fokac: “Bulimakaozi gie bagarehuc sopâc kecɋaŋ nâzo mume mi sakarecnezemec. Eme Anutuzi dâŋ i bulimakao jaŋere sawa manasuhuc muwec me? ");
INSERT INTO kmg_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Ŋic nâŋâcne mâmâc mi muwec me? I nâŋâcne hâcne mukicne. Gie he rikec eekaczi mâc mi eekac, fârine fuame nâocte manasuhuc eekac, â sara mamac eekac e iŋuc jaha fârine fuacneocte manasuhuc eekac. ");
INSERT INTO kmg_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Nâŋe ŋoŋerao maŋte wiac sara mamac embeŋko okacne ŋoŋeraonec sahacte wiac ronaŋte manapie ŋemâckekac me? ");
INSERT INTO kmg_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Gâcne jaŋe ŋoŋeraonec nânâ mafa rohapie nâŋe gie fuŋkembeŋzi rorone mi fokac me? Erâ ine Kristo Biŋebiaŋ-ticne aka hecnenšipeŋte ŋoŋeraonec nânâ mafa rorore mukicne i qikiŋnehuc mâc hume serereŋ jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Taha ufuŋko gie baeŋgopieŋ jaŋe taha ufuŋkonec nânâ nâeŋgopieŋ, â alatao bâzi ririke gie baeŋgopieŋ jaŋe alatare wiac nâ bac eeŋgopieŋ, i ŋoŋe mi manaeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Eme Wofuŋ e Biŋebiaŋ mumu ŋic nâŋe iŋuc jaha Biŋebiaŋzi sahacte dope wiac kifua-nâreocte muwec. ");
INSERT INTO kmg_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","No ine hata i mi âteekopac. Erâ ŋoŋe irec sâcko enareniŋte manasuhuc mi qâreŋkekopac, aricne. Hâmoczi rocnuzac irec manape afeckezac, â šeridâŋ-nane i babawaha-nare irec ine manape ŋic moczi mi enare-jâmbâŋkezejec ekac. ");
INSERT INTO kmg_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Biŋebiaŋ muromackeekopac irec mumumbiaŋ dâŋ mupe wemocko sâckeocmu, gie i hâcne nore faio râekicne i¡ Eme hetarepe, jei, Wofuŋzi weniŋuc enareocmu¡ ");
INSERT INTO kmg_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Gie i no nahacne maŋte fuarâ bazapo muzac juku furine rozapo. Nahacne maŋte mi ropore šiŋuc ekac: Micne gie fai-naneo fewec. ");
INSERT INTO kmg_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Hâc, eme wemo furi roekopac? Furine šiŋuc: No miti kiŋaŋ rahuc ŋic Biŋebiaŋ furimâc jazaekopac, ehuc Biŋebiaŋ mumure furi sahackopec wiac rorore mukicne i qikiŋneekopac. ");
INSERT INTO kmg_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","No ŋic sasawa jaŋere kiŋaŋ qaqa mi jukopaczi sifu kiŋaŋ qaqa-jeŋic epo jukopac. I ŋic bocjahazi miti manarâ biaŋkeniŋte manasuhuc epo hâcne. ");
INSERT INTO kmg_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Judaŋic jaŋerao juhuc Judaŋic hawari epo, i Judaŋiczi biaŋkeniŋte. Sâcmutâc dâŋte kiŋaŋ qaeŋgopieŋ jaŋerao juhuc sâcmutâc dâŋte kiŋaŋ qaqa hawari epo, i no nahac sâcmutâc dâŋte kiŋaŋ qahuc mâcne, i kiŋaŋne qaeŋgopieŋzi biaŋkeniŋte epo. ");
INSERT INTO kmg_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Qâpuc sâcmutâc dâŋ tâmiric jaŋerao juhuc sâcmutâc dâŋ tâmiric hawari epo, i Anuture maio sâcmutâc dâŋ tâmiric juhuc mâcne, no Kristore sâcmutâc dâŋ bajuekopac, erâ qâpuc jaŋe biaŋkeniŋte iŋuc epo. ");
INSERT INTO kmg_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Ŋic dodocne jaŋerao juhuc dodocne hawari epo, i dodocnezi biaŋkeniŋte epo. Ŋic fuŋne fuŋne jaŋerao juhuc hawari fuŋne fuŋne epo, i gâcnezi sipirickehapie sifu gâcnezi biaŋkeniŋte. ");
INSERT INTO kmg_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Wiac sasawa i mâc mâcne, Biŋebiaŋzi fua raocte eekopac, erâ no nahac wâc irec kâdoc ropemurâ eekopac. ");
INSERT INTO kmg_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Ŋoŋe kecšiŋuc mi manaŋgopieŋ me? Sâsâc eere hofao ira motec jaŋe gagasa i mâmâc gasacke-fâreniŋmu, â eri roro ine mocsâkoazi mao bâbâni fisirâ roocmu. Eme ŋoŋe iŋuc jaha eri-ŋeŋic roniŋte gasackenšepieŋ ");
INSERT INTO kmg_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Motec jaŋe sasanaŋte sâsâc ehuc sowa fuŋne fuŋne jueŋgopieŋ, jaŋe eri sisirowenere iŋuc eeŋgopieŋ, nâŋâc ine eri fofo sanaŋte iŋuc enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","No nahac wâc gasackeekopac, i ma hone dendeŋnehuc gasackeekopac. No sându-nane sawao kosa mi wickeekopac. ");
INSERT INTO kmg_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","No ŋic miti muromacke-jarehuc juku nahacne rârâricne ezipore sahac-nane ro waha âte ecnehuc ŋicbomboŋ-ticne juekopac. ");
INSERT INTO kmg_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Âgofâc-nane, no mimiŋnefâc-nâŋec wiac embiŋ irec manasu-ŋarepe mananiŋ Jaŋe mâmâc sasawa karoraczi sâoc-jopaha rahuc hâwec fotâcnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Ehuc Mosere ŋicfâc eniŋte karorac â hâweczi miti opâ-jeŋic eme ruambiŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Erâ Mârozi nânâ bâfua-jarewec i jaŋe mâmâc sasawa nârambiŋ, ");
INSERT INTO kmg_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","â Mârozi opâ bâfua-jarewec i wâc mâmâc sasawa nârambiŋ. Mârore qânâzi bâjâpec-jopawec, eraonec hâcne opâ wahame nâmbiŋ, qânâ šâŋene Kristo. ");
INSERT INTO kmg_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Eme sifu Anutuzi gâcne sâko mana sâqore-jareme mâreŋ sawao hâmo sipiric efârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Jaŋerao wiac fuawec i uŋsawaŋ-nâŋec ekac, jaŋe sâqocnere andac embiŋ iŋuc jaha enšipeŋte. ");
INSERT INTO kmg_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Jaŋeraonec gâcnezi nemu qaŋgec wiacte kiŋaŋ qaqa embiŋ, iŋuc wâc mi enšepeneŋ. Dâŋqâreŋ šiŋuc hâcne fokac: “Ŋic jaŋe waha ŋehuc tiwâ šepec nâku faharerâ gae wohuc domambiŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Erâ sasec boe sau wâc mi enšepeneŋ. Jaŋeraonec gâcnezi sasec boe sau embiŋ, ehuc šoaŋ gie bapa ijaha ŋic 23 tauseŋ hâmombiŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Erâ Wofuŋ maŋbâiŋ wâc mi ecnenšepeneŋ. Jaŋeraonec gâcnezi maŋbâiŋ ecnepie homazi kicjopame hâmo sipiric embiŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Erâ kâroŋ wâc mi qanšepeneŋ. Jaŋeraonec gâcnezi kâroŋ qapie sisipiric runezi sipiric-jopawec. ");
INSERT INTO kmg_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Jaŋerao wiac fuawec izi ma âkendâŋnekicne ekac. Eme mâreŋte dameŋ qândâŋkeha juŋgopeneŋ nâŋâcnere uŋsawaŋ muhuc dâŋbinaŋ i hâcne qâreŋkekicne. ");
INSERT INTO kmg_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Irec hâcne moc e jahacnere maname sasanaŋ eekaczi dockezacte rumehuc juzejec. ");
INSERT INTO kmg_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Ŋoŋerao eesâic fua warewec i ŋic tâpiri-ŋeŋicte sâcko fuawec. Erâ Anutu e mume sasanaŋzi eesâic baafeckeme tâpiri-ŋeŋicte sâc mi jâuruocmu. Erâ eesâic fuaocmu sâc âte sâoc-ŋopame sâcne sanaŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Irec hâcne, âgofâc-nane, ŋoŋe nemu qaŋgec wiacte geŋkerâ junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Ŋoŋe maŋ mamanasuhec juŋgopieŋ, irec dâŋ ši mupe ŋaŋac mana honeniŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Râqâcko waiŋ jambuŋkewecte jambuŋkerâ nâhuc Kristore sochec šušuhuc mi eeŋgopeneŋ me? Á poroŋ nâhuc Kristore sahachec šušuhuc mi eeŋgopeneŋ me? ");
INSERT INTO kmg_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Nânâzi mocjaha, i gugumec ehuc ŋic bocjahazi âgo guru mocjaha eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Ŋoŋe sahackopec Israe ŋic juŋgopieŋ jaŋere manasuniŋ. Ŋic taha bâzi nâeŋgopieŋ jaŋe alatahec šušuhuc mi eeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Dâŋ i weniŋucte mukopac? Nemure tiwâ šepec i wiac fârine me? Á nemu e jahacne wâc fârine me? ");
INSERT INTO kmg_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Iŋuc aricne. Qâpuc jaŋe tiwâ šepec rikeeŋgopieŋ i Anuture biŋe mâcne, i demoŋ jaŋere biŋe eekac. Eme no ŋoŋere šiŋuc mukopac: Ŋoŋe demoŋ jaŋehec šušuhuc mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Wofuŋte râqâckonec nâhuc demoŋ jaŋere râqâckonec mâmâc nânâ i sâcne mi eniŋmu. Á Wofuŋte teboonec nâhuc demoŋ jaŋere teboonec mâmâc nânâ i wâc sâcne mi eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Me nâŋâc Wofuŋ maŋbâiŋ ecnenaŋ me? Nâŋâcne tâpirizi ere sirickekac me? ");
INSERT INTO kmg_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Wiac sasawa eene fokac, erâ wiac sasawa epene izi sâcne mi bafic-nâpoocmu. Wiac sasawa eene fokac, erâ wiac sasawa ehuc mitio dodopec eene ine mi fokac. ");
INSERT INTO kmg_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Moc e jahacnere mi manasuhuc, âgo-ticnere manasuzejec. ");
INSERT INTO kmg_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Ŋoŋe buŋko bec qowi furine bazo murâ kosa banšepieŋ, ehuc keci omane me nemure ufuŋkonec, iŋuc muhuc mu manabâc mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Mâreŋ â wiac sasawa mâreŋ fusucmarâ fokac i Wofuŋzi rune Jukac. ");
INSERT INTO kmg_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Qâpuc moczi hezu hewâneŋ eŋareme ficticnao fezo murâ fenšepieŋ, erâ nânâ qowi gumec-ŋopame manabâc tâmiric kosa nâhuc mu wioc mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Á nahapie ŋic moczi šiŋuc moc ŋazaocmu: “Bec ši nemu ufuŋkonec”, eme mi nânšepieŋ. I mufua-ŋareocmu ŋic ere manabâc ehuc qikiŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","I nâpie ŋaŋacne maŋ sâqorezacte mâcne, âgo-ŋeŋicte maŋ sâqorezacte mukopac. No nahacne maŋ manabâc tâmiric fome wemocte moczi e jahacne maŋte sâc norao âke hotaocmu? ");
INSERT INTO kmg_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","No Anutu daŋge âzâcnehuc nunumu faio nâpe moczi wemocte mana sâqore-nareocmu? ");
INSERT INTO kmg_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Irec ŋoŋe nânâ qowi nâniŋte, me i me i eniŋte Anutu mumbiaŋkehuc enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ŋoŋe Judaŋic â Grikŋic â Anuture kikefuŋ jaŋere maio bahacmâc jupie moc mi mana sâqore-ŋarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","No iŋuc jaha ŋic fuŋne fuŋne jaŋe honecnupie sâckeocte juhuc no nahacne wiac biaŋkeocte mâcne, ŋic bocjaha miti manarâ biaŋkeniŋte giene baekopac. ");
INSERT INTO kmg_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","No Kristore hata âtehuc bâjâpeekopac, eme ŋoŋe iŋuc jaha nore hata âtehuc bâjâpecnunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ŋoŋe wiac ebac epo Irec manasu-fârehuc mumutâc dâŋnanere sâcko jueŋgopieŋ, irec manape biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Eme ši moc mupe mananiŋ, Kristo e ŋicte kâcɋene, ŋic e ŋokacte kâcɋene, Anutu e Kristore kâcɋene. ");
INSERT INTO kmg_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Ŋic moc e qârufac rojuhuc numuocmu me Anuture micdâŋ mufuaocmu, e kâcɋene-ticne mimi qaqa ecneocmu. ");
INSERT INTO kmg_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Á ŋokac moczi qârufac tâmiric juhuc numuocmu me Anuture micdâŋ mufuaocmu, e iŋuc jaha kâcɋene-ticne mimi qaqa ecneocmu, erâ ŋokac kosa jujune qizec-jeŋic rokicne jaŋehec sâc mocjaha eocmu. ");
INSERT INTO kmg_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Irec ŋokac moc qârufac tâmiric jume qizec rocnezo. Me ŋokac moc e irec mimierâ qizec susuc-ticne sakareocmuzi qârufac rojuzejec. ");
INSERT INTO kmg_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Ŋic e ine qizectuc juzejec. E Anuture hawari â Anuture eri tofa bakicne irec. Ŋokac e ine ŋicte eri tofa bakicne. ");
INSERT INTO kmg_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Ŋic e ŋokactaonec mi rokicne, ŋokaczi ŋictaonec rokicne. ");
INSERT INTO kmg_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Ŋic e ŋokacte erâ mi bâfuakicne, ŋokac e ine ŋicte erâ bâfuakicne. ");
INSERT INTO kmg_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ŋokac e ŋicte wahamicne jukacte irec ma moc qârufac hâcne rojuzejec, mâc jume aŋelo jaŋe honepie sâqorezacte. ");
INSERT INTO kmg_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Erâ sifu ŋic e mocbuc-ticne juju â ŋokac e mocbuc-ticne juju i Wofuŋte maio mi fokac. ");
INSERT INTO kmg_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Ŋokac e ŋictaonec rokicne, iŋuc wâc ŋiczi ŋokackonec fua sawec eeŋgopeneŋ. Erâ wiac i sasawa Anuturaonec. ");
INSERT INTO kmg_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Ŋoŋe ŋaŋac mana honeniŋ, ŋokac moc qârufac tâmiric juhuc Anutu numucneme sâckeocmu me? ");
INSERT INTO kmg_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Á ŋic moc e qizec susuc šoricne rojume iŋuc jaha honepie mi sâckeocmu, irec fuŋne mârâc miti tâmiric juhuc wâc manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Á ŋokac moc qizec susuc šoricne rojume e ine honepie biaŋkeocmu. Qizec susuc šoricnezi qârufac-ticne eekac. ");
INSERT INTO kmg_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Moc e dâŋ ši qâsuazo murâ šiŋuc manazejec: Mâsi i nâŋe â Anuture kikefuŋ gâcne mi bajueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Wiac moc ši ine mana-ŋarepe bahacnehec eha uŋ sawaŋ eŋarehuc mupe: Ŋoŋe tumaŋnehuc maŋ biaŋ qaqac mi ehuc maŋ bâbâsâqorec eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Erâ mitire tumaŋnepie ŋondeŋ-ŋeŋicko fâfâuc fuaekac, iŋuc nazapie manape jâmbomac tinac ekac. ");
INSERT INTO kmg_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Erâ fâfâuc i mâc mâcne, ŋoŋeraonec wenizi mitio sanaŋkeŋgopieŋ jaŋe fua tâcneniŋte hâcne fuakac. ");
INSERT INTO kmg_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Eme ŋoŋe Wofuŋte Tiwâ nâniŋte tumaŋnerâ hesifuckeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Ŋaŋacne nânâ bafisirâ boki mi bahuc fâro erâ buc buc nâpie moc e hâmoekac â moc e gapecmâc nâekac. ");
INSERT INTO kmg_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Hâc, ŋaŋacne fic basahuc iŋuc eeŋgopieŋ me? Ŋoŋe nânâ opâ nâzo murâ ira nanšapiŋ¡ Wemocte Anuture gurufâc jaŋere manapie wawahane eme hapetac busâqoc ejareeŋgopieŋ? Wemo ŋazape? Mumbiaŋ-ŋopape? Wiac kecirec mi mumbiaŋ-ŋopazo. ");
INSERT INTO kmg_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","No Wofuŋtaonec hâcne ropo i ŋarepo wâc. Ine šiŋuc: Wofuŋ Jesu e Judazi doc bawec ŋafe ira poroŋ rorâ ");
INSERT INTO kmg_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","daŋge murâ bazurâ muwec: “Kecši fâri-nane, ŋoŋere due bahuc qikiŋnekicne. Nore manasuhuc iŋuc nâhuc junšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Poroŋ nâpie waiŋ râqâc iŋuc jaha rorâ šiŋuc muwec: “Râqâc kecšira šâšâfic ɋâricnere socnane ŋekac. Nâniŋmu sâc nore manasuhuc iŋuc nâhuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Ŋoŋe poroŋ â waiŋ i nâniŋmu sâc Wofuŋ hâmoc biŋe-ticne mutaniŋkehuc juhapie risieocmu. ");
INSERT INTO kmg_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Irec moc e poroŋ â Wofuŋte waiŋ i enšaŋauc ecnehuc nâocmu, e Wofuŋ fâri â socticne nâsifuckeme kiŋnehec eocmu. ");
INSERT INTO kmg_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Irec moc e poroŋ â waiŋ nâzo murâ qanaŋ maŋticnere fuŋne hone manac ehuc bajaŋgeŋkerâ nâzejec. ");
INSERT INTO kmg_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Moc e Wofuŋte fâri hone šâŋitac mi ehuc nâocmuzi kiŋticne nâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Ŋoŋe iŋuc hâcne eeŋgopieŋte huc dodoc â huc šâic boc eŋareekac, â gâcnezi biac hâmocko foŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Nâŋâc nâŋâc fuŋne-nâŋec bataniŋkenšapeŋ muzac, Wofuŋzi mi bataniŋkezac. ");
INSERT INTO kmg_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Qâoma epene ine Wofuŋzi fuŋne-nâŋec bataniŋkehuc bâtiŋ-nâpoocmu, miti tâmiric jaŋehec juku behec-nâpome sipirickenšipeŋte iŋuc hâcne enâreocmu. ");
INSERT INTO kmg_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Âgofâc-nane, ŋoŋe tiwâ wirec nâniŋte tumaŋnerâ woŋec ŋehapie fisi-fârepie fuŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Moc e nânâre boc ecneme qanaŋ e jahacne ficko nâzejec, tutumaŋ bâbâsifucne epie okacne fua-ŋarezacte. Dâŋ gâcne i no nahac fârâ mutâcne-ŋarepemu. ");
INSERT INTO kmg_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Âgo bureŋ, Mâroraonec miti kadahe irec fuŋne kâuc banšipiŋte ŋazape mananiŋ. ");
INSERT INTO kmg_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Ŋoŋe mârâc jaha qâpuc juhapie maŋšoc fua-ŋarewec sâc nemuɋâŋ kâpâne jaŋerao ra qohota jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Eme irec ŋifecne mupe mananiŋ: Moc e Anuture Mârozi bufahac qacnehame wemocko muocmu “Jesu go sâwecgukopac”, â moc e Tiri Mârozi bufahac mi qacnehame wemocko muocmu “Jesu e Wofuŋ”. ");
INSERT INTO kmg_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Mitire kadahe fuŋne fuŋne fokac, Mâro ine mocjaha, ");
INSERT INTO kmg_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","mitire kiŋaŋ gie fuŋne fuŋne fokac, gie rune ine Wofuŋ mocjaha, ");
INSERT INTO kmg_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","mitire tâpiri fuŋne fuŋne fokac, tâpiri rune ine Anutu mocjaha. Eki hâcne bâfua-nâre-fâreekac. ");
INSERT INTO kmg_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Mâro e mitio juhâmonaŋte ŋic ru sâc tâpiri-ticne kâdoc qanâreekac. ");
INSERT INTO kmg_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Moc e Mârozi ecneme miti maŋɋârâŋhec muocmu, moc e Mâro izia ecneme sâc mitire fuŋne hukicne muocmu, ");
INSERT INTO kmg_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","moc e Mâro izia ecneme mamanasiŋ sâkohec juocmu, moc e Mâro izia ecneme ŋic huc šâichec ɋiɋicne bacjopaocmu, ");
INSERT INTO kmg_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","erâ moc mâsi baocte tâpiri bâfuacneocmu, moc findaŋdâŋ muocte maŋne bâuŋtoocmu, moc e mâro fuŋne fuŋne šâŋitaocte maŋne batamaeocmu, moc e miti marac furuo muocte micne baafeckeocmu, moc e miti marac furu manarâ ŋic dâjeŋicko bâtikieocte bafickeocmu. ");
INSERT INTO kmg_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Wiac i sasawa Mâro izia bafâreekac, ehuc maŋticnere ŋic ru sâc wiac bârâwiŋne-nâreekac. ");
INSERT INTO kmg_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Ŋic nâŋâc sahac-nâŋeczi mocjaha â sahacte kiŋaŋ qaqafâc ine bocjaha, eme jaŋe bocjahazi qâturepie sahac mocjaha ekac” eme Kristorao sâc ijaha fokac. ");
INSERT INTO kmg_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Mâro mocjahazi nâŋâc Miti Opâo bâturec-nâpome sahac-nâŋecte sâc erâ mocjaha embeŋ. Judaŋic â Grikŋic, kiŋaŋ qaqa â ŋicbomboŋ, nâŋâc Mâro i jaha sasawa ro maŋ efârekicnere mocjaha embeŋ. ");
INSERT INTO kmg_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Eme sahacte kiŋaŋ qaqa iŋuc jaha mocjaha mâcne, bocjaha. ");
INSERT INTO kmg_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Eme kike e wemocko šiŋuc muzac: `No me aricne, irec  sahacte tofa mi ekopac”, iŋuc murâ wemocko sahac beherâ buc juocmu? ");
INSERT INTO kmg_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Me hazeczi wemocko šiŋuc muzac: “No šâŋe aricne, irec sahacte tofa mi ekopac”, iŋuc murâ wemocko sahac beherâ buc juocmu? ");
INSERT INTO kmg_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Sahacko šâŋe sasawa fome muzac sahaczi hazec basazac. Me hazec sasawa fome muzac sâke basazac. ");
INSERT INTO kmg_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Anutu e ine mana tarahuc sahacte kiŋaŋ qaqa gie fuŋne fuŋne mujarewec. ");
INSERT INTO kmg_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Sahacte kiŋaŋ qaqa fuŋne-jeŋic mocjaha efâreme muzac sahac e sâqorerâ arictac ezac. ");
INSERT INTO kmg_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ʒi ine kiŋaŋ qaqazi bocjaha â sahaczi mocjaha. ");
INSERT INTO kmg_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Eme šâŋezi wemocko me âzâcneocmu, “No go tâmiric sâcne jupemu.” Me qizeczi wemocko kike jasaocmu, “No ŋohe tâmiric sâcne jupemu.” ");
INSERT INTO kmg_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Aricne, sahac-nâŋecte tofafâc dodocne jaŋe tâmiric hâcne sâcne mi juzo. ");
INSERT INTO kmg_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Á sahac-nâŋecte tofafâc wawahane jaŋe hâcne hone jauŋ ejareeŋgopeneŋ, â miminehec jaŋe foŋjopapene biaŋne hawari eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Hawari biaŋ jaŋe ine tâtâc foeŋgopieŋ. Anutu e sahac bâfuahuc tofafâcne gâcne wahakicne jaŋe gie fekicne mujarewec. ");
INSERT INTO kmg_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","I sahac-nâŋecte tofafâc fâfâuc mi ehuc kiŋaŋ qaqac sâckoa eniŋte iŋuc hâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Irec tofane moczi šâic maname gâcne jaŋe mâmâc mana-fâreniŋmu, me moczi šeri eme gâcne mâmâc šeri efâreniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Ŋoŋe mâmâc sâko qâturerâ Kristore sahac eŋgopieŋ â buc buc sahac-ticnere kiŋaŋ qaqafâc eŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Anutu e kikefuŋfâc-ticne nâŋâcnao ŋic šiŋuc râec-jopawec: Qanaŋ aposolo, izi porofete, izi qaqazu, erâ ŋic mâsi bapare tâpirihec â ŋic huc šâic bâbâpiaŋ irec tâpirihec, erâ jauŋ bapa, erâ soŋaŋ, erâ dâŋ marac furuo mumu, iŋuc hâcne râec-jopawec. ");
INSERT INTO kmg_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Nâŋâc aposolo sasawa râec-nâpowec me? Me porofete me qaqazu sasawa râec-nâpowec me? Me mâsi bapare tâpiri ");
INSERT INTO kmg_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","me huc šâic bâbâpiaŋ irec tâpiri fonâre-fârekac me? Me dâŋ marac furuo mumu me ŋic dâŋjeŋicko bac bâtikic eene jufâreŋgopeneŋ me? ");
INSERT INTO kmg_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Ŋoŋe mitire kadahe fekicne bâfuaniŋte šoɋac enšepieŋ. Eme noni irec hata biaŋne jâmbâŋ ši ŋowatupe honeniŋ. ");
INSERT INTO kmg_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","No ŋicmaracko me aŋelo maracko miti muzapo, ehuc maŋjauŋ tâmiric juzapo, ine qeŋ goŋgoŋ iŋucne erâ dâŋ fânâŋ sawa ezapo. ");
INSERT INTO kmg_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Me no porofete juhuc dâŋ soŋne mana-fârezapo â mitire šuhucne mana utucke-fârezapo â tiki mupe rârieocte irec sâc mamanasiŋ fonarezac, ehuc maŋjauŋ tâmiric juzapo, ine ŋic jawane ezapo. ");
INSERT INTO kmg_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Me wiac-nane sasawa hapetac bâmec bajarezapo â sahac-nane qikiŋnepe šocte nânâ ezac, ehuc maŋjauŋ tâmiricko ezapo, ine racne efârezac. ");
INSERT INTO kmg_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Maŋjauŋheczi wama ruaine juocmu, maŋjauŋheczi iiŋguuŋ mi eocmu, maŋjauŋheczi penaroŋ mi eocmu, e jahacnere maname fefene mi eocmu ");
INSERT INTO kmg_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","e šaubac tâmiric, iiriac tâmiric, aaric tâmiric, kiŋ babaju tâmiric juocmu” ");
INSERT INTO kmg_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","sâqocnezi haŋ bame busâqoc manaocmu, â mitizi haŋ bame bubiaŋ manaocmu” ");
INSERT INTO kmg_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","maŋjauŋhec e dede ââsic-ticne ɋârâŋne, mamanasiŋ-ticne ɋârâŋne, maŋzi woworic-ticne ɋârâŋne, maŋuruc-ticne ɋârâŋne. ");
INSERT INTO kmg_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Maŋjauŋ i tatarane tâmiric. Findaŋdâŋ mumu i tataranehec, erâ dâŋ marac furuo mumu i wâc tataranehec, â fuŋne mamana i wâc tataranehec. ");
INSERT INTO kmg_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","I šiŋucte: Fuŋne mamana-nâŋec i faisuc â findaŋdâŋ mumu-nâŋec i faisuc jaha wâc. ");
INSERT INTO kmg_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Juku ine wiac fofo dunduŋne fuame wiac faisuc eenezi omaezokac. ");
INSERT INTO kmg_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","No ɋiene juhuc ɋiedâŋ mujupac â ɋiemaŋhec jujupac â ɋie mamana mana jupac. Izi juku ŋic erâ ɋie wiac hetarapo. ");
INSERT INTO kmg_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Dameŋ šiŋuczia wiac honeeŋgopeneŋ i turuŋzi hawari bâtikie-nâreme sisifucne honeeŋgopeneŋ irec sâc, juku ine fârine šâŋeo hehec erâ hone mana tarac ezokopac, i Wofuŋzi no hone mana tarac enarewec irec sâc. ");
INSERT INTO kmg_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Eme fofo sanaŋ foniŋmu ine mamanasiŋ, woworic â maŋjauŋ, jaŋe jahec â moczi. Maŋjauŋzi ine micne ekac. ");
INSERT INTO kmg_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Ŋoŋe maŋjauŋhec juniŋte ɋicwânšâŋ enšepieŋ. Erâ miti kadahe gâcne roniŋte irec wâc šoɋac enšepieŋ, ehuc Anuture micdâŋ mumufuare manapie fefene ezejec. ");
INSERT INTO kmg_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Moc e dâŋ marac furuo muekac e ŋic mi jazahuc Anutu âzâcneekac. E Mârozi ecneme dâŋ marac furuo mume ŋic jaŋe kâuc baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Á Anuture micdâŋ mufuaekaczi ine ŋic faŋ qajareekac â âkesiŋ-jopaekac â buuruc qajareekac. ");
INSERT INTO kmg_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Marac furuo dâŋ muekaczi e jahacne maŋ âkesiŋkeekac, â Anuture micdâŋ mufuaekaczi ine kikefuŋ guru âkesiŋ-jopaekac. ");
INSERT INTO kmg_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Ŋoŋe dâŋ marac furuo mufârepie manape sâckeocmu, Anuture micdâŋ mufuapie ine manape sâcke-hâmoocmu. Anuture micdâŋ mufuaekac ŋic e marac furuo dâŋ mumuŋic ere sâc sirickekac. Mocjaha, marac furuo dâŋ muku kikefuŋ guru bâtikie-jareme manarâ fârine bajupie ine sâcjeŋic mocjaha eocmu. ");
INSERT INTO kmg_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Âgofâc, no ŋoŋerao fârâ marac furuo dâŋ ŋazape wemocko âkesiŋ-ŋopaocmu? No muraruŋ dâŋ me miti hukicne me findaŋdâŋ me mu qaqazuc dâŋ muratie-ŋarepe ine sâcne maŋfâri-ŋeŋic eocmu. ");
INSERT INTO kmg_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Wiac omane, woŋgâŋ mimi ŋokac wiac, i qapie dâŋ hawarine tâtâc mi fuame wemocko šâŋitazo? ");
INSERT INTO kmg_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Me qeŋ kosa qapie dâŋ eme manarâ wemocko “wiac mocte kuku qanâreŋgopieŋ” muhuc ra bafic-jopaniŋmu? ");
INSERT INTO kmg_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Á ŋoŋe iŋuc jaha marac furuo dâŋ foŋnehec mupie gâcnezi wemocko mananiŋmu, i dâŋŋeŋiczi qahameŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Mâreŋ sâc ŋic dâŋmarac fuŋne fuŋne forakac i mamanane sasawa. ");
INSERT INTO kmg_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Mâc noni dâŋmarac moc kâuc bapemuo dâŋ irec runezi nore maname mutucne eocmu, â noni ere iŋuc jaha manape mutucne eocmu. ");
INSERT INTO kmg_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Eme ŋoŋerao fuŋne ijaha fokac. Mârore tâpiri ŋoŋerao fuaocte mueŋgopieŋ i sâcne, erâ i hâcne mitizi kikefuŋ âkesiŋ-jopaocte šoɋac enšepieŋ ");
INSERT INTO kmg_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Irec marac furuo dâŋ muocmu e fuŋne mana-hâmorâ ŋic ŋokac bâtikie-jareocte Wofuŋ numucneme bafickezejec. ");
INSERT INTO kmg_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","No marac furuo numupemu, ine maŋ qâqâtâc-nanezi sawa epemu, â mamana-nanezi mâc foocmu. ");
INSERT INTO kmg_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Eme irec weniŋuc ezo? Kecšiŋuc ezo: No maŋ qâqâtâc-nanezi numume mamana-nanezi mana tararâ miczi mutaniŋkezejec. ");
INSERT INTO kmg_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Me go maŋ qâqâtâcgezi Wofuŋ muteŋketec ŋic omane moczi dâŋge kâuc bahuc wemocko baficgurâ “Jâmbomac” muocmu? ");
INSERT INTO kmg_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Go mumuteŋ dâŋ fârinehec mucmu mecne, erâ âgogezi kâuc baha wemocko maŋne âkesiŋkeocmu? ");
INSERT INTO kmg_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Anutu daŋge âzâcnekopac, marac furuo dâŋ mumu i no ŋoŋere sâc mâcne, sâc fekicne fonarekac. ");
INSERT INTO kmg_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Eme irec manape fârine eme muzac, tutumaŋko marac furuo dâŋ šoricne šora muzo murâ muzapo. Erâ no irec manape wahakac, â mitidâŋ jahec mac sawa mutaniŋkehuc ŋic ŋokac jaza qazuc ee, irec ine manape fekac. ");
INSERT INTO kmg_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Âgofâc, dâŋ mana wosâc eere mamana-ŋeŋiczi ɋie jaŋere sâc mi ezejec, sâqocnere i ɋiene jaŋere sâc enšepieŋ, â mana wosâcte ine maŋ mamana-ŋeŋiczi sokakicne jaŋere sâc ezejec. ");
INSERT INTO kmg_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Sâcmutâc dâŋqâhâcko dâŋ moc šiŋuc qâreŋkekicne fokac: “Wofuŋ e mukac, `No ŋic furune ejarepe jaŋe ŋicguru ši dâŋmarac furunao micdâŋ-nane jazapie i wâc sifu mi mananiŋmu. Ž `à ");
INSERT INTO kmg_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Eme irec ŋifecne mupe: Marac furuo dâŋ mumu i fuŋne qaqa mâsi moc, erâ i opâ ruac jaŋere biŋe mi ekac, i qâpuc jaŋere biŋe, â Anuture micdâŋ mumufua ine qâpuc jaŋere biŋe mâcne, i opâ ruac jaŋere biŋe. ");
INSERT INTO kmg_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Irec kikefuŋ guru tumaŋne-fârehuc mâmâc sasawa marac furuo dâŋ muhapie ŋic omane me qâpuc moczi hefârâ honec-ŋoparâ muocmu: “Maŋsifuc ejarekac.” ");
INSERT INTO kmg_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Á Anuture micdâŋ mufuahuc ŋehapie ŋic qâpuc me omane moczi ŋoŋerao hefârâ miti i manaocmu, ine mâmâc sasawa maŋticnere fuŋne bataniŋkeniŋmu â mumu hehec ecneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Eme maŋticnao wiac hesoŋkeme foekac i fua taniŋkeme šâŋe maine mâreŋko hetutuckerâ Anutu muafeckehuc muocmu, Anutu e jâmbomac ŋoŋehec jukac. ");
INSERT INTO kmg_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Âgo bureŋ, irec weniŋuc? Ŋoŋe tumaŋneniŋte murâ maŋ metariŋ mi fisieŋgopieŋ. Moc e miti gae bafisiekac, moc e mu qaqazuc dâŋ, moc e Anuture micdâŋ furune, moc e marac furu dâŋ, â moc e marac furu dâŋ irec fuŋne. Wiac i sasawa miti fua sawec eŋareocte enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Marac furuo dâŋ muzo murâ boczi mâcne, jajahec me jahec â moc sawazi munšepieŋ. Erâ buc buc mupie sâc moczi fuŋne bâtikierâ ŋazazejec. ");
INSERT INTO kmg_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Bâbâtikie ŋic basaniŋmuo tutumaŋko marac furu dâŋ mi muzo. Moc e muzo murâ bucticne â Anuturao muzejec. ");
INSERT INTO kmg_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Anuture micdâŋ mumufua ine iŋuc jaha ŋic jajahec me jahec â moc munšepieŋ, eme gâcne mana wosâerâ ŋifecne munšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Moc e ŋehame Mârozi maŋticnao miti râeme muzo mume mârâc fuŋkejeczi behezejec. ");
INSERT INTO kmg_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Anuture micdâŋ mumufua i ezo murâ sâcne efârenšepieŋ, ehuc buc buc mupie gâcne sasawa jaŋe mitihec erâ maŋafec bâfuanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Anuture micdâŋ mumufua ŋic mârofâc-jeŋic jaŋe porofete âgofâc-jeŋic jaŋere dâŋ reŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Anutu e hesi qâsifuc Anutu mâcne, e wama Anutu. ");
INSERT INTO kmg_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Kikefuŋ gâcnao mitire tumaŋnehuc ŋokac jaŋe dâŋemâc ŋeeŋgopieŋ, ŋoŋerao iŋuc jaha enšepieŋ. Ŋokac jaŋe iŋuc ehuc wahamicne juniŋte i sâcmutâc dâŋqâhâcko mukicne wâc. ");
INSERT INTO kmg_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Wiac moc manazo ejareme ficjeŋicko ŋowefâc-jeŋic mu wioc ejarenšepieŋ. Ŋokac moczi kikefuŋ tutumaŋko dâŋ mume mimi qaqanehec eocmu. ");
INSERT INTO kmg_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Me Anuture dâŋzi ŋoŋeraonec fuawec? Me ŋoŋe buc manambiŋ? ");
INSERT INTO kmg_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Ŋoŋeraonec moczi e jahacnere maname porofete me ŋic Mârohec eocmu, e dâŋ qâreŋke-ŋarekopac i Wofuŋte mumupaŋ, iŋuc mana tarazejec. ");
INSERT INTO kmg_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Moc e dâŋ ši maname fârine mi eme e mana suazo. ");
INSERT INTO kmg_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Irec, âgofâc, šiŋuc mananiŋ: Ŋoŋe Anuture micdâŋ mumufua irec šoɋac enšepieŋ, â marac furuo dâŋ mumure aka wâc mi henšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Wiac sasawa epie pec sererec â tiŋbenoŋ fozejec. ");
INSERT INTO kmg_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Âgofâc-nane, Biŋebiaŋ ŋazape manambiŋ, erâ wâc bajueŋgopieŋ, irecteaŋ manasu-ŋarepe. ");
INSERT INTO kmg_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Qazu-ŋarepo irec sâckoa bajuŋgopieŋko sâcne bâpiaŋ-ŋopaocmu. Me bajuhapie biac sifucke-ŋare wiac moc ewec? ");
INSERT INTO kmg_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Miti qizecne no narekicne ijaha ŋoŋe ŋarehuc kecšiŋuc muhuc fuŋke-ŋarepo: Kristo e miti papiao mucnekicne irec sâcko erâ sâqocne-nâŋecte okacne hâmowec. ");
INSERT INTO kmg_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","Erâ miti papiao mucnekicne irec sâckoa šâŋeruŋko hurâ šoaŋ jahec â moc eha ɋârerâ faharewec. ");
INSERT INTO kmg_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Faharerâ qanaŋ Kefa fuacnewec, izi motecfâcne 12 fua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Izi mitiŋic šare-jeŋic 500 jâuruwec jaŋe tumaŋnehapie fua-jareme hone-fârembiŋ. Jaŋeraonec bocjahazi ɋâricne juŋgopieŋ, â gâcnezi hâmombiŋ. ");
INSERT INTO kmg_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Izi Jakobo fuacnewec, izi aposolo mâmâc sasawa fua-jarewec. ");
INSERT INTO kmg_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Ʒâhecko ine ombâŋtâc no wâc fua-narewec. ");
INSERT INTO kmg_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","No aposolo waha qaqane jâmbâŋ, no Anuture kikefuŋ guru jopa sipiric ejarepore aposolo šâŋe munarepie mi sâckeekac. ");
INSERT INTO kmg_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","No aposolo epo i Anutu aki anonoc-ticnere erâ epo. Erâ aki anonoc-ticnezi norao racne mi ewec. No gie bapo i gâcne jaŋere sâc jâurukac, erâ no nahac wemo-nanezi bazapo, Anuture aki anonoc norao fowec izi bawec. ");
INSERT INTO kmg_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Eme no mecne jaŋe mecne miti iŋuc hâcne muromackeeŋgopeneŋ, eme ŋoŋe i hâcne manambiŋ bajuŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Kristo e hâmockonec ɋârerâ faharewec, miti iŋuc muhuc ŋazapene wemocte ŋoŋeraonec gâcnezi hâmockonec fafahare mi fokac mueŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Hâmockonec fafahare-nâŋec i mickehuc Kristo fafahare-ticne mâmâc mickezo. ");
INSERT INTO kmg_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Kristo mi faharezacko ine miti mumu-nâŋec fârimâc ezac â mamanasiŋ-ŋeŋic iŋuc jaha fârimâc ezac. ");
INSERT INTO kmg_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Erâ i sawa mâcne. Nâŋe Anuture mumbeŋ, e Kristo hâmockonec bafaharewec. Eme hâmockonec fafahare mi fozacko Anutuzi wemocko Kristo bafaharezac. Irec dâŋ mumbeŋ i Anutu micko itic ecnehuc burecŋicfâc-ticne eŋgopeneŋ ezac. ");
INSERT INTO kmg_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Ŋic hâmockonec mi fahareniŋmu, iŋuc murâ Kristore iŋuc jaha hâmockonec mi faharewec muzo. ");
INSERT INTO kmg_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Kristo e hâmockonec mi faharezacko ine mamanasiŋ-ŋeŋic racne ezac â kiŋŋeŋic foŋarezac, ");
INSERT INTO kmg_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","â Kristo manasiŋkehuc hâmombiŋzi sipirickembiŋ ezac. ");
INSERT INTO kmg_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Nâŋâc mâreŋko šira sawa Kristore mamanac maŋgâŋ junšapeŋko, ine mamakucne fuŋmoc ehuc gâcne siric-jopa-fârenšapeŋ. ");
INSERT INTO kmg_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Erâ iŋuc mâcne, Kristo e jâmbomac hâmockonec ɋârerâ ŋic hâmokicne jaŋere micne barâ faharewec jukac. ");
INSERT INTO kmg_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Ʒiŋucte hâcne: Ŋiczi hâmoc fuŋke-nârewec iŋuc jaha ŋiczi hâmockonec fafahare fuŋke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Adamhec šušuhuc-nâŋec fokacte hâmo-fâreeŋgopeneŋ, iŋuc jaha Kristohec šušuhuc-nâŋec fokacte fahare-fârenšoŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Erâ birine mukicne sâc faharezo: Micne bapazi Kristo, izi fifisi-ticnao Kristore bufuŋfâc, ");
INSERT INTO kmg_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","izi dameŋ taraocmu” Kristo e fekicne â tâpirihec â šoɋac sasanaŋhec bawahac-jopame munaŋke-fârehapie Wofuŋ gie-ticne i Anutu Mamac-ticne bârisiecneme dameŋ taraocmu hâcne. ");
INSERT INTO kmg_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Ʒi ine Wofuŋ gie-ticne bahuc juocmu, juku râsifâc-ticne ro waha âte ejare-fârerâ gie-ticne bataraocmu. ");
INSERT INTO kmg_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Râsi sâko mimic qa imac ecneocmu šâŋene hâmoc. ");
INSERT INTO kmg_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Anutuzi ŋic â wiac sasawa Kristore wahamicnao râec-nâpo-fârewec hâcne. Erâ dâŋ šiŋuc fokac, “Ŋic â wiac sasawa bawahac-joparâ ere wahamicnao guruc-jopa-fârewec”, dâŋ i manapene Anuture mâmâc mukicne mi ezejec. E hâcne Kristore wahamicnao guruc-nâpoweczi rurumaŋnao mi huocmu. ");
INSERT INTO kmg_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Mamac e ŋic â wiac sasawa Ŋokâ rurumaŋnao guruc-nâpo-fâreme Ŋokâ e Mamacte wahamicnao waharâ domaocmu. Eme Anutuzi qâhuc-nâpo-fârerâ juju isiricke-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ŋoŋeraonec gâcnezi hâmokicne jaŋere erâ Miti Opâ ruaeŋgopieŋ, i hâmockonec fafahare mi fokacko wemocte iŋuc eeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Erâ wâc nâŋe ine wemocte šârâ hâriŋ faio gâbâmâc qâmâc jumbeŋzi jueŋgopeneŋ? ");
INSERT INTO kmg_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Âgofâc-nane, Kristo Jesu Wofuŋ-nâŋeczi eri-nane râec-ŋopawec ŋoŋere maio mukopac: No šoaŋ gie bapa sâc hâmoczi bâmbeŋnuha juekopac. ");
INSERT INTO kmg_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","No Efeso haeo qowi mimicne jaŋehec juju gie bapo i ŋicdâŋko siŋkehuc epoo wemo fârine mo fua-nareocmu? Hâmockonec fafahare mi fokacko šiŋuc mupene sâckezac: “Tomâcko moc hâmonšipeŋte miŋecgac jaha nânâ qowi ro nâc qânâc enaŋ.” ");
INSERT INTO kmg_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Moczi moc ba qâsoric eŋarenšipiŋ ine¡ Kosa jujune jaŋerao qohotaocmu e eebapa biaŋne sifuckecneocmu. ");
INSERT INTO kmg_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Ŋoŋe maŋŋeŋic ɋâreme pectâc juhuc sâqocne geŋkenšepieŋ. Ŋoŋeraonec gâcnezi Anuture kâuc baŋgopieŋ, i manarâ mimieniŋte mukopac. ");
INSERT INTO kmg_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Gâcnezi šiŋuc mecne muniŋmu: Hâmokicne jaŋe weniŋuc erâ fahareniŋmu â sahac hawari-jeŋic weniŋucnehec fuaniŋmu? ");
INSERT INTO kmg_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","I dâŋ mutucne” ŋoŋe wiac saraeŋgopieŋ i mâc mi wefuekac, mimiŋne šaŋkeha bâpâŋne wefuekac. ");
INSERT INTO kmg_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Á wiac saraeŋgopieŋ, i borâcne mi saraeŋgopieŋ, hândâŋne sawa saraeŋgopieŋ, jacgoŋ me wiac gâcnere hândâŋ, eme borâcne â rehacne šâhec fuaekac. ");
INSERT INTO kmg_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Eme Anutu e mana tararâ hawari mucnewec ijaha wefurâ fuaekac, hândâŋne sâc hawari fuŋne fuŋne fuaekac. ");
INSERT INTO kmg_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Sahacte fuŋne iŋuc jaha mocjaha mi fokac, ŋic nâŋâcne sahac i moc â bec qowi jaŋere sahac i moc â wipe jaŋere moc â opâ qowi jaŋere moc. ");
INSERT INTO kmg_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Sambâŋko wiac fâri ŋerakac â mâreŋko wiac fâri ŋerakac. Erâ sambâŋko ŋerakac i eri-ticne moc, â mâreŋko ŋerakac i eri-ticne moc. ");
INSERT INTO kmg_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Ʒoaŋ e tatamacne moc, mosa e tatamacne moc, bâpiŋ jaŋe tatamac-jeŋic moc, erâ bâpiŋ tatamac-jeŋic mocjaha mâcne, fuŋne fuŋne fokac. ");
INSERT INTO kmg_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Hâmockonec fafahare irec fuŋne ijaha fokac. Sarakicnezi sisirowene, fahareocmuzi mi sisirowene” ");
INSERT INTO kmg_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","sarakicnezi joŋtawekicne, fahareocmuzi erinehec” sarakicnezi weweaŋne, fahareocmuzi tâpirinehec” ");
INSERT INTO kmg_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","sarakicnezi mâreŋ sahachec, fahareocmuzi sambâŋ sahachec. Mâreŋ sahac fokac, iŋuc jaha sambâŋ sahac fokac. ");
INSERT INTO kmg_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Dâŋ šiŋuc hâcne qâreŋkekicne fokac: “Ŋic mârâc fufua Adam e maŋ qâqâtâchec erâ ɋârewec.” Ʒâhec Adam e ine Mârohec ehuc juju bâbâfua irec rune ewec. ");
INSERT INTO kmg_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Sambâŋte wiaczi mi bâniewec, mâreŋte wiaczi bânieha sambâŋte wiaczi šâhec ewec. ");
INSERT INTO kmg_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Mâreŋŋic e mâreŋzi bakicnere mâreŋkonec ŋic ewec â šâhecŋic e ine sambâŋkonec. ");
INSERT INTO kmg_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Mâreŋkonec ŋic juwec sâc ijaha mâreŋkonec ŋicfâc-ticne jueŋgopeneŋ, â sambâŋkonec juwec sâc ijaha sambâŋte biŋefâc-ticne nâŋâc junaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Eme mâreŋkonec ere hawari rombeŋ, iŋuc jaha sambâŋkonec ere hawari ronaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Âgofâc, dâŋ moc ši mupe mananiŋ: Mâreŋ sahac-nâŋeczi Anuture uucmaŋ sâcne mi rauckeocmu, â wiac gârecke šaŋ eenezi wiac fofo sanaŋ mi wâc rauckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Manaŋgopieŋ, ši dâŋ soŋne moc mufua-ŋarepe: Nâŋâc mi hâmo-fârenaŋmu, hetikierâ hawari moc ee ine šeŋgoma efârenaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Qeŋ mimic dâŋeme ututuŋ, ɋeŋfâfâc jaha iŋuc hâcne enaŋmu. Qeŋ dâŋeme hâmokicnezi faharerâ gârecke šaŋ tâmiric juniŋmu, â ɋâricne junaŋmuzi wâc hetikierâ hawari moc enaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Sahac ši gârecke šaŋ eenezi juju saric i ŋaqi iŋucne  heme huzejec, â hâmocte biŋe ekicnezi juju sanaŋ heme huzejec. ");
INSERT INTO kmg_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Eme gârecke šaŋ eenezi juju saric heme huocmu, â hâmocte biŋe ekicnezi juju sanaŋ heme huocmu, dameŋ ira dâŋ kecšiŋuc qâreŋkekicne i deŋkeocmu: “Jujuzi hâmoc ɋâckewec.” ");
INSERT INTO kmg_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","“Hâmoc go tâpirige weni? Hâmoc go šârâge weni?” ");
INSERT INTO kmg_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Sâqocnezi hâmocte šârâ ekac, â sâcmutâc dâŋte erâ sâqocnezi tâpirinehec ekac. ");
INSERT INTO kmg_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Anutu e Wofuŋ-nâŋec Jesu Kristo ecneme jujure tâpiri bâfua-nâreekacte muteŋkenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Irec âgofâc-mae, ŋoŋe sanaŋkerâ qiŋ herâ domanšepieŋ, ehuc Wofuŋ gie-ticnere dameŋ sâc henširiŋnehuc banšepieŋ. Wofuŋte erâ gie bapie fârimâc mi eocmu, iŋuc manahuc banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Mitiŋic jaŋere moneŋ râezo murâ ine Galatia mâreŋkonec kikefuŋ guru jaza mutâc epo ijaha enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Ŋoŋe moneŋ hotâckekicne irec sâc manahuc Sondane Sondane tucne bâtâc barâ buc buc râe guruc ehuc junšepieŋ, mâc juhapie fâ fisipe moneŋ qânusuckeniŋte âecke guruc enšipiŋte. ");
INSERT INTO kmg_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Ŋoŋerao fâpe ŋic mucjopaniŋmu jaŋe papia jarehuc sorec-jopape bubiaŋte wiac-ŋeŋic Jerusalem haeo baranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Me moneŋ bocjaha eme nohec mâmâc ranšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","No Makedonia mâreŋ fotâcne-fârerâ ŋoŋerao fâpemu, Makedonia mâreŋko boc mi jupemu, i mâc fotâcnepemu. ");
INSERT INTO kmg_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Ŋoŋerao fârâ piticne jupemu, me jufehape hoemaŋ taraocmu mecne. Eme ŋoŋe hatare baficnupie ira me ira razepac. ");
INSERT INTO kmg_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","No dameŋ šiŋuczia mâc fofotâc fâhuc honec-ŋopape mi sâckeocmu, irec Wofuŋzi manaha ŋoŋerao fârâ piticne jupemurâ mukopac. ");
INSERT INTO kmg_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","No ši Efeso haeo juhape Mâro Hombaŋ maickeocmu. ");
INSERT INTO kmg_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Ʒira Wofuŋzi mitire hata bâšâweme gie sâko-nane fuakac. Erâ mitire kisâ bocjaha juŋgopieŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Timoteozi ŋoŋerao fâme âgo ecnepie hâwic sahac mi juzejec. E no Wofuŋte gie baekopac iŋuc jaha baekac. ");
INSERT INTO kmg_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Irec ere manapie wawahane mi ezejec. Erâ aimuŋ ecnerâ bârisiepie norao mocwâc warezejec” no â opâ ruac gâcne woŋec-ticne juŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Âgo-nâŋec Apolo e opâ ruac gâcne jaŋehec ŋoŋerao fâocte âzâcne sorec epe sâcne mi afeckekac” e šiŋuczia mâcne, dameŋ mocte maname sâckeme ŋoŋerao fâocmu. ");
INSERT INTO kmg_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Ŋoŋe rucjaric-ŋeŋic bahuc mamanasiŋko qiŋ henšepieŋ, ehuc hâbi-ŋeŋic rorâ sanaŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Erâ wiac sasawa maŋjauŋhec enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Erâ âgofâc-nane, dâŋ moc ŋazape mananiŋ: Ŋoŋe Stefana â wiacfâc-ticne jaŋere manaeŋgopieŋ, jaŋe Akaia mâreŋko micne barâ miti manambiŋ, erâ mitiŋic ŋoŋerao kiŋaŋ qaqa gie baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Irec ŋoŋe jaŋe mecne â gâcne miti gie bahuc šâic manaeŋgopieŋ honec-jopapie micnefâc-ŋeŋic enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Stefana â Fotunato â Akaiko jaŋe norao fisipie bunane biaŋkewec. Jaŋe ŋoŋere âkehoc dâŋjauŋ enarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Ehuc no â ŋoŋe mâmâc maŋuruc qanârembiŋ. Ŋoŋe ŋic iŋucne jaŋere manapie biaŋkezejec. ");
INSERT INTO kmg_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Asia mâreŋ masunao kikefuŋ guru jaŋe ŋoŋere mamanac juŋgopieŋ. Aqila â Prisika â ficjekicko mitire tumaŋneeŋgopieŋ jaŋe Wofuŋte erâ mu šeri boc eŋareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Opâ ruac mâmâc sasawa mu šeri eŋare-fâreŋgopieŋ. Ŋoŋe ŋaŋac mitio meo babac enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Ʒi Paulo no nahac mu šeri eŋarehuc šâŋe qâreŋ-nane râekopac. ");
INSERT INTO kmg_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Moc e Wofuŋte takickeme hârâcte biŋe ezejec. Wofuŋ-nâŋec go warezemec. ");
INSERT INTO kmg_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Wofuŋ Jesure aki anonoczi ŋoŋerao fozejec. ");
INSERT INTO kmg_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Maŋjauŋ-nanezi Kristo Jesure erâ ŋoŋerao fofârekac. ");
INSERT INTO kmg_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Anuture micdâŋte Jesu Kristore aposolo epo Paulo no hâcne, erâ qomâ-nâŋec Timoteo nâhe Korinti haeonec Anuture kikefuŋ â Akaia mâreŋko mitiŋic juraŋgopieŋ ŋoŋe papia ši qâreŋke-ŋarehuc šiŋuc mukoperec: ");
INSERT INTO kmg_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Wofuŋ-nâŋec Jesu Kristo ere Mamac â Anutu muteŋkenšepeneŋ. E buuruc Mamac â bâbâmiriŋ rune juekac. ");
INSERT INTO kmg_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Ehuc šârâ hâriŋ fuŋne fuŋne enâreme bâmiriŋ-nâpoekac. Eme Anutuzi bâmiriŋ-nâpoekac, bâbâmiriŋ izia nâŋe iŋuc jaha âgo gâcne šârâ hâriŋ fuŋne fuŋne maŋnao juhapie sâcne bâmiriŋ-jopanaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Kristo e šâic manawec irec tofane nâŋerao ɋârâŋne fuaekac, iŋuc jaha bâbâmiriŋ-ticne ɋârâŋnea bâfua-nâreekac. ");
INSERT INTO kmg_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Nâŋerao fific guguriŋ fuaekac, i ŋoŋerao bumâteŋ â bâbâpiaŋ fuaocte fua-nâreekac, â bâbâmiriŋ fua-nâreekac i wâc ŋoŋere erâ fua-nâreekac, ine bâbâmiriŋ izi ŋoŋerao fotâcnerâ dopec-ŋopahame fific guguriŋ nâŋerao fuaekac ijaha ŋoŋerao fuame irec šâic maŋuruc jaha mananiŋte. ");
INSERT INTO kmg_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Eme nâŋe ŋoŋere manabâc mi ehuc šiŋuc manapaŋkeŋgopeneŋ: Ʒârâ hâriŋte kâdoc rohuc bâbâmiriŋte kâdoc mâmâc roeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Nâŋe Asia mâreŋko šârâ hâriŋ faio juwefumbeŋ irec kâuc banšipiŋte mupe mananiŋ: Ira wiac hâhâwicne jâmbâŋ fai-nâŋecko ferâ kimâc-nâpome juju-nâŋecte mâretec mana maŋbahac embeŋ. ");
INSERT INTO kmg_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Eme ši hâmocte biŋe eŋgopeneŋ muhuc maŋnâŋec ŋeŋgoroŋkewec. Erâ i mâc mi fua-nârewec, nâŋe nâŋâcne tâpirire manapene waha qaqane eha Anutu hâmoc qâŋɋâŋ bâɋâreekac e mocjaha manasiŋkenaŋte wiac i fua-nârewec. ");
INSERT INTO kmg_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Eme eki hâcne hâmockonec batarac-nâpowec. Erâ e batarac-nâpoweczi juku wâc batarac-nâpozokac, dâŋ iŋuc mana šakiehuc erao siŋkeeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","Eme ŋoŋe nunumuzi bafic-nâpopie Anutu e buafec-ticnere erâ ŋezic-nâpome micne micne musereckerâ nâŋere erâ daŋge mumuteŋ ecnepie sâckezejec. ");
INSERT INTO kmg_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Nâŋe nâŋâcnere piticne mana biaŋkeeŋgopeneŋ ine kecšiŋucte: Maŋfâsâc â mitio maŋtaniŋ jupene maŋnâŋeczi wiac mocte tutuc mi qanâreekac. Nâŋe miti tâmiric jaŋere maio iŋuc hâcne juhuc miti mamana ŋoŋere maio wâc jujâmbâŋkeeŋgopeneŋ. I mâreŋko maŋɋârâŋ dâŋ fokac ira siŋkehuc mâcne, Anuture uruc jauŋko siŋkehuc eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Nâŋe dâŋ hetac herirec ehuc mâcne, dâŋ fârine sasawa qâreŋke-ŋarepene wose manac eeŋgopieŋ. No manakopac, ŋoŋe šâhec mana tara-jâmbâŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Ine hâcne gâcne ŋoŋe šiŋuc biac mana tarazo eŋgopieŋ: Nâŋe ŋoŋere boreŋfâc â ŋoŋe Wofuŋ Jesu dameŋ sâko-ticnao nâŋere boreŋfâc eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","No dâŋ i hâcne maŋkehuc qanaŋ ŋoŋerao fârâ bubiaŋ qaŋarepemurâ mupo. ");
INSERT INTO kmg_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Erâ fâ honec-ŋoparâ Makedonia mâreŋko razo mupo. Ira ra jurâ mocwâc ŋoŋerao risiepe gâcnezi bâjâpecnupie Judaia mâreŋko ranaŋte manasupo. ");
INSERT INTO kmg_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Eme no iŋuc muhuc âkesac eŋarepo muŋgopieŋ me? Me no ŋic miti tâmiric, irec dâŋ mupaŋkepe moc i fârine â moc i racne eekac? ");
INSERT INTO kmg_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Anutu e jâmbomac rune jukacte dâŋ ŋazapene wemocko racne â fârine ataŋ eocmu? ");
INSERT INTO kmg_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Anuture Ŋokâ Jesu Kristo ere fuŋne i no â Siliwano â Timoteo nâŋe ŋazapene gâcne fârine â gâcne racne iŋuc mi ewec. Aricne, ere fuŋne i fâri fideteŋ sasawa. ");
INSERT INTO kmg_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Anuture biŋedâŋ fuŋne fuŋne i erao hâcne deŋke-fârekac. Irec hâcne esoc-nâpome “Jâmbomac” muhuc Anutu mucne bacneeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Ŋoŋehec Kristorao râec-nâpo sanaŋkewec i Anutu eki hâcne. ");
INSERT INTO kmg_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","Erâ ekizia wâc ma qâreŋ banârehuc šâšâfic-ticne Mâro maŋnâŋecko râeme huwec. ");
INSERT INTO kmg_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","No Korinti haeo fârâ imac-ŋopazipore mi fâpo. Dâŋ i Anutuzi manaha jâmbomac jâmbâŋ mukopac. ");
INSERT INTO kmg_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Erâ nâŋe mitio ŋicbomboŋ eŋarenaŋte mi muŋgopeneŋ, mâc ŋoŋerao bubiaŋ fuaocte babaficko gie baeŋgopeneŋ. Ŋoŋe mamanasiŋko qiŋ herâ domaŋgopieŋ i manakopac. ");
INSERT INTO kmg_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","No ŋoŋerao fârâ busâqoc mocwâc bâfua-ŋarezipore manabâc erâ jupo. ");
INSERT INTO kmg_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Noni busâqoc eŋarehape weni jaŋe bubiaŋ bâfua-nareniŋmu? Busâqoc ecnekicnezi wemocko iŋuc eocmu? ");
INSERT INTO kmg_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","Eme no dâŋ i hâcne šiŋucte qâreŋke-ŋarepo: No fâpe ŋoŋe bubiaŋ bâbâfua-narezi busâqoc bâfua-narenšipiŋ. No nâŋâcnere šiŋuc hâcne manapaŋkepo: Nore bubiaŋzi mâmâc sâko-nâŋec ekac. ");
INSERT INTO kmg_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","No bunane gufeme ŋoŋere šâic wemo afecne manahuc kifaio papia qâreŋke-ŋarepo, i bu ririke eŋarepemurâ mâcne, maŋnane ŋoŋerea sanaŋne domakac, irec fuŋne ŋowatupemurâ epo. ");
INSERT INTO kmg_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Ŋic busâqoc bâfua-nârewec, eki no sawa mâcne, ŋoŋe gâcne mâmâc bâfua-ŋarewec, weniŋuc musokahuc “mâmâc sâko bâfua-ŋarewec” mupemu. ");
INSERT INTO kmg_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Ŋoŋe bocjahazi bâtiŋnehuc wiac ecnembiŋ, i manape tarakac. ");
INSERT INTO kmg_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","Ʒi ine busâqocko juku sipirickezacte kiŋticne behehuc mu bâmiriŋ ecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Irec hâcne harierâ âgo jauŋ ecneniŋte mukopac. ");
INSERT INTO kmg_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","No bâbâtiŋte mârâc qâreŋke-ŋarepo, i dâŋnane sasawa reŋkepie fuŋne taniŋkeocte esâic-ŋopapo. ");
INSERT INTO kmg_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Ŋoŋe ŋic mocte kiŋ behepie no iŋuc jaha behepemu. Kiŋ behekopac (bahac bâfuawec i norao moc qacnewecko behekopac(c) ine ŋoŋere manasuhuc Kristore micte ekopac. ");
INSERT INTO kmg_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","I Sataŋzi eatuc-nâpozacte iŋuc eŋgopeneŋ. E wiac enâreocte manasuekac, irec kâuc mi baŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","No Troa haeo fisihape Kristore Biŋebiaŋ mupemurâ irec hatane Wofuŋzi bâšâwe-narewec. ");
INSERT INTO kmg_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Eme qomâ-nane Tito (e ŋoŋeraonec biac mi risiewecte(c) basahuc maŋhâhâŋ enareme ŋicbureŋ mâzoc-joparâ Makedonia mâreŋko warepo. ");
INSERT INTO kmg_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Opoŋ, Anutu e Kristore gieŋicfâc-ticne nâŋe saoreŋ qahuc bataniŋ-nâpoekac, ehuc enâreme miti-ticnere âsu aŋac biaŋ bâiŋnepene ŋezurâ mâreŋ sâc raekac, irec mumuteŋ sâko ecnezo. ");
INSERT INTO kmg_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Nâŋe Kristore âsu mumundoŋ eŋgopeneŋzi Anutu bâiŋnecnepene ŋic jujure biŋe â sisipiricte biŋe mâmâc jopaekac. ");
INSERT INTO kmg_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Sisipiricte biŋe jaŋe fârepie hurâ hâmoc âsu erâ jopame hâmoeŋgopieŋ, â jujure biŋe jaŋe fârepie hurâ juju âsu erâ âke ɋârec-jopame jueŋgopieŋ. Gie iŋucne mozi bame sâckeocmu? ");
INSERT INTO kmg_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Nâŋe ŋic gâcnezi eeŋgopieŋ iŋuc mi eeŋgopeneŋ. Ŋic gâcne bocjahazi Anuture dâŋte manapie âbârâ gie-jeŋic eekac. Nâŋe ine maŋtaniŋ juhuc Anuture micte â Anuture maio Kristorao qohotahuc miti mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Nâŋe ŋoŋe bâmiriŋ-ŋopanaŋte dâŋ iŋucne mocwâc fuŋkeŋgopeneŋ me? Me ŋic tucnezi eeŋgopieŋ iŋuc erâ ŋoŋerao fisirâ bâbâmiriŋ papia moc ŋowatueŋgopeneŋ? Me ŋoŋe moc qâreŋkerâ nâreeŋgopieeŋ? ");
INSERT INTO kmg_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Iŋuc aricne, papia-nâŋec i ŋoŋe hâcne. Erâ papia I maŋŋeŋicko qâreŋkekicne, ŋic mâmâc sasawa hone wosec eene. ");
INSERT INTO kmg_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Nâŋe ŋoŋerao gie bapene Kristore papia embiŋ, irec fuŋne tâtâc fokac. Erâ papia i tiŋtezi mi qâreŋkekicne, i Anutu jujune ere Mârozi qâreŋkewec, tafe omanao mâcne, ŋicmaŋ tafeo qâreŋkewec. ");
INSERT INTO kmg_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Qacfiric dâŋ iŋucne ine Kristore erâ Anutu manasiŋkepene fonârekac. ");
INSERT INTO kmg_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Gie fârine moc nâŋe nâŋâcnaonec fuaekac iŋuc mu manasuc enaŋte ropaŋ mi fonârekac,wiac epene bibiaŋkene i Anuturaonec sasawa. ");
INSERT INTO kmg_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Anutu eki hâcne bašawiec-nâpome šâšâfic ɋâricnere gie baeŋgopeneŋ. I dâŋqâreŋte giene mâcne, i Mârore gie. Dâŋqâreŋzi hâcne sisipiric bâfua-nâreekac, â Mârozi ine juju bâfua-nâreekac. ");
INSERT INTO kmg_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Miti gie raŋɋane,sisipiricte biŋe mumu hâcne, i qorac tapao qâreŋkekicne, erâ gie i sifu tatamac tâmiric mi fowec. Irec hâcne Mosere šâŋe maio tatamac hâhâwicne fome Israe ŋic jaŋe wemocko ira firâ honenšapiŋ. Erâ tatamac i fofone mâcne. ");
INSERT INTO kmg_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","Miti gie raŋɋanere tatamac iŋuc hâcne fowec.Ehame wemocko miti gie ɋâricne, Mârore biŋe mumu, i tatamac tâmiric foocmu? ");
INSERT INTO kmg_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Sisipiricte biŋe mumu irec giezi tatamac wawahanehec, â kiŋfâsâc eere biŋe mumu irec giezi tatamac fekicne sâkohec. ");
INSERT INTO kmg_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Gie raŋɋanere tatamac i gie ɋâricnere tatamac sâkozi sâockeme weaŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Wiac fotâmireweczi mârâc tatamacnehec fuawec, â wiac forašihuc jujune irec tatamaczi ine fekicne sâko. ");
INSERT INTO kmg_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Mamanac-nâŋec iŋuc fokacte gie maŋafec jaha baeŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ehuc Mose mi sâckeeŋgopeneŋ. E Israe ŋic jaŋe tatamac rârâriene i fotâmirehame honenšipiŋte šâŋe maine foŋkewec. ");
INSERT INTO kmg_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","Eme maŋjeŋic sanaŋkewecte miti raŋɋanezi wâc foŋnehec eweczi eekac. Irec wose manac ehuc mi mana taraeŋgopieŋ. Erâ foŋ i mâc mi raruŋkeocmu, Kristo e mocjahazi bararuŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Jaŋe dameŋ šiŋuczia Mosere dâŋqâreŋ woseeŋgopieŋ sâc maŋjeŋic foŋnehec eekac. ");
INSERT INTO kmg_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Jaŋe maŋjeŋic bârisierâ Wofuŋ maickepie izia foŋ i firue-jareocmu. ");
INSERT INTO kmg_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Wofuŋ e Mâro rune, eme Wofuŋte Mârozi juekacko wiac omaraŋ foekac. ");
INSERT INTO kmg_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Nâŋâc ine šâŋe mai-nâŋec foŋ tâmiric fokacte Wofuŋte tatamaczi âke tamaec-nâpome bâtikiepene wefuekac,ehuc Wofuŋte hawari sâc erâ tatamacheczi tatamachec eeŋgopeneŋ. I Wofuŋ Mâro ere mâsi. ");
INSERT INTO kmg_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Wofuŋ e buafec-ticnere gie iŋucne munârewecte mi pârâweeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Ehuc bahac,mimi fuazacte soŋsoŋko eene, i râpecke-fârembeŋ Me sioc faio juhuc Anuture dâŋ bâbâsifucke i wâc mi eeŋgopeneŋ, aricne Nâŋe Anuture maio miti mutaniŋkehuc ŋic jaŋere maŋ bâmiriŋkepene fuŋne-nâŋec manaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Eme Biŋebiaŋ mueŋgopeneŋ izi foŋnehec moc eekacko ine sisipiricte biŋe jaŋerao sawa foŋnehec eekac. ");
INSERT INTO kmg_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Miti qiqikiŋ jaŋe hâcne mâreŋ širec ŋicbomboŋzi maŋjeŋic bâzickeme wemocko Biŋebiaŋte tatamaczi hume Kristo e Anuture sâc jâmbâŋ jukac muhuc Wofuŋ qâreŋ-ticne šâŋitaniŋmu? ");
INSERT INTO kmg_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Nâŋe miti muhuc nâŋe nâŋâcne dâŋ mi ŋazaeŋgopeneŋ, Jesu Kristo eki Wofuŋ â nâŋe ine Jesure erâ kiŋaŋ qaqafâc-ŋeŋic sawa juŋgopeneŋ, iŋuc ŋazaeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Anutu e mârâc jaha fuŋnao dapâc fohame hae mâreŋ fureocte mume furewec, ekizia hâcne mume maŋnâŋecko mitire tatamaczi uŋ heme Kristore šâŋe maio Anuture huriri qâreŋ fua tâcneha šâŋitambeŋ. ");
INSERT INTO kmg_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Tâpiri šâkâŋ i nâŋerao mâcne, Anuturao fokac, irec fuŋne taniŋkeocte boreŋ šeŋaŋ-ticne kuši mâreŋzi bakicne nâŋerao duckekicne. ");
INSERT INTO kmg_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Hume serereŋ faio juipiehuc sifu docke šaŋ mi eeŋgopeneŋ. Bebekâne juipiehuc sifu mi mana utuckeeŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","fific guguriŋ faio juipiehuc sifu mamac babasa mi eeŋgopeneŋ, qa imac enâre-bipiehapie sifu hâmo sipiric mi eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Iŋuc ehuc sahac-nâŋecko Jesu hâmoc-ticnere ma amecke jueŋgopeneŋ, i Jesu juju-ticnere ma iŋuc jaha sahac-nâŋecko fuaocte hâcne. ");
INSERT INTO kmg_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Ŋic jaŋe Jesure erâ dameŋ oombâŋko gâbâ sipiric-nâpohuc hâmocko râec-nâpoeŋgopieŋ, i Jesu juju-ticnere tâpirizi sahac hâhâmo-nâŋecko fua taniŋkeocte iŋuc fua-nâreekac. ");
INSERT INTO kmg_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Eme šiŋuc fokac: Nâŋerao hâmoczi gie baekac,â ŋoŋerao jujuzi gie baekac. ");
INSERT INTO kmg_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Dâŋqâreŋ moc šiŋuc fokac: “No Wofuŋ manasiŋkeekopacte miti muekopac.” Eme nâŋe dâŋqâreŋ irec sâcko Mârozi esoc-nâpoha Wofuŋ manasiŋkeeŋgopeneŋte miti mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Ehuc šiŋuc manapaŋkeeŋgopeneŋ: Wofuŋ Jesu bâɋârewec eki nâŋe iŋuc jaha Jesuhec bâɋârec-nâporâ ŋoŋehec mâmâc erao râec-nâpoocmu. ");
INSERT INTO kmg_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Nâŋe wiac sasawa i ŋoŋere erâ kecšiŋuc muhuc eeŋgopeneŋ: Mitizi haŋ barahame ŋic bocjahazi manahuc Anutu šeri mumuteŋ sâko ecnepie Izi šuhuckeme šuhuc forahuc fozejec. ");
INSERT INTO kmg_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Nâŋe šiŋuc manahuc mi pârâweeŋgopeneŋ: Sahac-nâŋec bâmuzuckehame maŋnâŋec šoaŋne šoaŋne soka biaŋ eekac. ");
INSERT INTO kmg_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Mâreŋko šâic busâqoc-nâŋec mâmâŋne â tatarane izi eri aŋac biaŋ ŋemâc bâmâcne â fofo sanaŋ bâfua-nârehame guru dindiŋ fonârezokac. ");
INSERT INTO kmg_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Erâ wiac tâtâc fokac irapec mâcne, wiac soŋsoŋ fokac irapec firâ râqârepene i fua-nârezokac. Wiac hohonene izi sisirowene,wiac mi hohonene izi fofo sanaŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Nâŋe šiŋuc manaŋgopeneŋ: Mâreŋte ficboze-nâŋec raruŋkeme Anutuzi sambâŋko ficsanaŋ moc bâfua-nâreocmu, fic i mezi mi bakicne, mâc qiŋ sanaŋ qaŋqaŋ qakicne. ");
INSERT INTO kmg_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Eme nâŋe irec hâcne sambâŋkonec fic i henâreme huocte aŋac-nâpome harac huacbuc ehuc jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Maŋ qâqâtâc-nâŋeczi biuctac ezacte i hâcne rojupene sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Sahac boze-nâŋecko junaŋmu sâc ŋeŋe rârâqâc enâreme hujâi ehuc jueŋgopeneŋ. Nâŋe ŋaqi-nâŋec raŋɋane hetaranaŋte mi enâreekac, i fohame fainao ɋâricne henareme huocte enâreekac. Ehuc hâmocte biŋe ekicne i jujuzi ɋâckeocte mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Wiac biaŋ i fua-nâreocte bâmoc-nâpowec i Anutu eki hâcne, ehuc irec kifac Mâro hâcne râe-nârewec. ");
INSERT INTO kmg_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Nâŋe irec hâcne mana afeckehuc jueŋgopeneŋ. Ehuc šiŋuc manaeŋgopeneŋ: Mâreŋ sahaczi haefuŋ-nâŋec eha jueŋgopeneŋ,i Wofuŋ basahuc mâreŋ jabao jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Dameŋ šiŋuczia maŋzi wiac manasiŋkehuc jujune sawa fokac, fârine hohone aricne. ");
INSERT INTO kmg_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Erâ sifu mana afeckeeŋgopeneŋ. Ehuc sahachec mâreŋ jabao juju i beherâ mame sâko hae-nâŋecko Wofuŋhec juju irec aŋac-nâpoekac. ");
INSERT INTO kmg_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Eme juju i mame sâko haeo me mâreŋ jabao junaŋmu ine kecšiŋuc muhuc ropaŋ eeŋgopeneŋ: Aimuŋ jupene Wofuŋzi honec-nâpome sâckezejec. ");
INSERT INTO kmg_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Ʒiŋuc hâcne manaŋgopeneŋ: Juku šeŋgoma Kristore dâŋ mumutara ŋeŋe fuŋnao fua tâcnepene, sahachec juhuc wiac hurekicne, biaŋne me sâqocne, irec tofa ru sâc bazu-nâreocmu. ");
INSERT INTO kmg_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","Wofuŋ araŋ bacnehuc junaŋte mukicne i manahuc ŋic mu hemiriŋ ejareeŋgopeneŋ. Iŋuc ehapene Anutuzi maŋnâŋec honeekac, â ŋoŋe iŋuc jaha maŋŋeŋiczi fuŋne-nâŋec ŋazame manaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Nâŋe iŋuc mupene manapie nâŋe harierâ bâbâmiriŋ dâŋ muŋgopeneŋ mi ezejec. Nâŋe mâc ŋaza qâmoc eŋgopeneŋ, eme ŋoŋe ŋic gâcne, maŋtac juhuc sahackopec wiacte sawa penaroŋ eeŋgopieŋ, jaŋe dâŋ i jazahuc bâsâoc-nâponšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Nâŋe maŋnâŋec ŋeŋgoroŋkeekacko ine Anutu gie-ticnere erâ ŋeŋgoroŋkeekac, me maŋnâŋec fâretiŋ foekacko ine ŋoŋe mitihec eniŋte iŋuc foekac. ");
INSERT INTO kmg_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Kristore maŋjauŋzi maŋnâŋec fenšoŋkehame juhuc šiŋuc mana sanaŋkeeŋgopeneŋ: Mocjahazi okac-nâŋec hâmowecte mâmâc sâko hâmombeŋ ekac. ");
INSERT INTO kmg_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Mâmâc sâko okac-nâŋec hâmowec ine kecšiŋucte: Juju i nâŋâc nâŋâcnere mâcne, okac-nâŋec hâmorâ faharewec ere erâ junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Irec ši miti dameŋko sahac hawari sawa hohonec erâ šâšâŋitac i sâcne mi enaŋmu. Erâ wâc Kristo iŋuc jaha mârâc sahac hawarine honehuc šâŋitambeŋ, irec sâc šiŋuczia mocwâc mi enaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Irec ŋic moc Kristorao šuhuckeekac e fuŋmoc eekac. Ine wiac raŋɋane omaewec, ŋicbureŋ, wiac ɋâricne fuawec. ");
INSERT INTO kmg_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Wiac i Anuture mâsi sasawa. Eki hâcne Kristozi jahacnehec miriŋ bacnâpowec. Erâ nâŋâc miriŋ babac biŋedâŋ mupene haŋ baocte irec gie munârewec. ");
INSERT INTO kmg_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Ine hâcne Anutu e Kristoo juhuc mâreŋŋic jahacnehec miriŋ bacnâpowec, ehuc kiŋnâŋec behewec. Erâ miriŋ babac dâŋ ŋondeŋ-nâŋecko âkendâŋnewec domakac. ");
INSERT INTO kmg_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Irec nâŋe Kristore biŋe mumuzi Anuture mu baafec dâŋ ŋazaeŋgopeneŋ. Nâŋe Kristo âkehockehuc numu-ŋareeŋgopeneŋ: Anutuhec miriŋ babac enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Sâqocnere kâuc bawec e Anutuzi nâŋâcnere erâ sâqocne bapa mucnewec, i nâŋâc Jesuhec qâfâsâehuc Anuture tiŋne jujufâc enaŋte iŋuc hâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Anuture babaficfâc nâŋe mu âkesiŋ eŋarehuc šiŋuc ŋazaeŋgopeneŋ: “Anuture aki anonoc tahac-ŋopakicne i fârimâc mi ezejec.” ");
INSERT INTO kmg_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Dâŋ šiŋuc hâcne fokac: “No dameŋ biaŋko mana-garepo â bâbâpiaŋ dameŋko baficgupo.” Manaŋgopieŋ,dameŋ biaŋ jâmbâŋ šine hâcne, â bâbâpiaŋ dameŋ iŋuc jaha šine hâcne. ");
INSERT INTO kmg_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Nâŋe ŋic jaŋe gie bapa-nâŋec surenšipiŋte gâŋ ŋezic mi ejareeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Nâŋe Anuture gieŋic jueŋgopeneŋ irec fuŋne bataniŋkehuc wiac šiŋuc eraeŋgopeneŋ: Ʒâicmaŋko maŋuruc jueŋgopeneŋ, šârâ hâriŋ faio jueŋgopeneŋ, fific guguriŋ faio jueŋgopeneŋ, hâhâwic maŋko jueŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","šika faio jueŋgopeneŋ, kâpâcwâru ficko ŋeeŋgopeneŋ, râsi ŋondeŋko jueŋgopeneŋ, giere šâic manaeŋgopeneŋ, guŋɋâri jueŋgopeneŋ, nânâ tâmiricko jueŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","bahac fâsâc jueŋgopeneŋ, mamana tarahec jueŋgopeneŋ, bumâteŋ jueŋgopeneŋ, âgo jauŋ ejareeŋgopeneŋ, Tiri Mârohec jueŋgopeneŋ, maŋjauŋ fârihec jueŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","dâŋ fâri qizecne mueŋgopeneŋ, Anuture tâpirio jueŋgopeneŋ, mitire sându marohec jueŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","mumumbiaŋ â mimi qaqa ŋoŋondeŋko jueŋgopeneŋ, mu bâsâoc â mufec muriŋ ŋoŋondeŋko jueŋgopeneŋ, burecŋic munârehapie siocmâc jueŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","fuŋne-nâŋec basahapie biŋe rarahec jueŋgopeneŋ, hâmozo eeŋgopeneŋzi sifu ɋâricne jueŋgopeneŋ, nâpo sipiric ekicnezi sifu mi omaeeŋgopeneŋ, ");
INSERT INTO kmg_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","busâqoc enârekicnezi sifu bubiaŋko jueŋgopeneŋ. hapetaczi sifu ŋic bocjaha bâmec bajareeŋgopeneŋ, wiac babasanezi sifu mâriri sâkohec jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","O Korinti ŋicbureŋ, maŋnâŋec ŋoŋerea kâcɋene domame micnâŋec afeckekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Maŋzi sanaŋnea šâfic-ŋopaŋgopeneŋ, ŋoŋere maŋjauŋ ine afecne mac fokac. ");
INSERT INTO kmg_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Eme no naru motecfâc-nane ŋoŋe ŋazape: Ŋoŋe okacne bazuhuc iŋuc jaha maŋŋeŋic nâŋere râepie kâcɋenea domazejec. ");
INSERT INTO kmg_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Ŋic qâpuc jaŋe jâcjeŋic reŋkepie ŋoŋe mi bafic-jopanšepieŋ. Tiŋne â hehesic jahe wemocko ââgo enicmu? Me tatamac â dapâc jahe wemocko šâšâfic enicmu? ");
INSERT INTO kmg_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Me Kristo â râsi qizec-ticne jahe wemocko maŋ mocjaha enicmu? Me opâ ruac â qâpuc jaŋe wemocko qâfâsâeniŋmu? ");
INSERT INTO kmg_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Me Anuture ufuŋ â nemuɋâŋ jahe wemocko šušuhuc enicmu? Manaŋgopieŋ, Anutu jujunere ufuŋ i nâŋâc. Anutuzi šiŋuc hâcne muwec: “No ŋondeŋ-jeŋicko ŋeŋe juju epemu, ehuc Anutu-jeŋic ehape jaŋe ŋicfâc-nane junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Irec qâpuc behec-joparâ bâtâcko junšepieŋ, Wofuŋzi iŋuc mukac. Erâ wiac mamakâcne ba bâuac mi enšepieŋ, eme noni hezu hewâneŋ eŋarepemu. ");
INSERT INTO kmg_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","Erâ mamac eŋarehape naru motecfâc-nane erâ junšepieŋ. Wofuŋ bapa-fâre e dâŋ iŋuc mukac.” ");
INSERT INTO kmg_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Âgo bureŋ, wiac iŋucnere biŋe qanârekicnere wiac mamakâcnezi maŋ sahac-nâŋec hegâpâreekac i šure ɋaɋackenšepeneŋ. Erâ Anutu araŋ bacnehuc maŋɋaɋac jaha junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Ŋoŋe maŋŋeŋic mi sakare-nârenšepieŋ. Nâŋe ŋoŋerao wiac hehesic mi embeŋ, me wiac-ŋeŋic ima mi qambeŋ, me wiac-ŋeŋic moc kâŋgâc mi rombeŋ. ");
INSERT INTO kmg_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","No dâŋ i musâqorec-ŋopahuc mi mukopac. No miŋecne mac ŋazapac, maŋnâŋeczi šâfic-ŋopaŋgopeneŋ, i ŋoŋehec mâmâc hâmonaŋte me junaŋte. ");
INSERT INTO kmg_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Maŋnanezi ŋoŋerao siŋkeha wemo afecne muafec-ŋopakopac, no bunane boc bâmiriŋkekicne, šâic busâqocko šeri kâcɋene fua-narekac. ");
INSERT INTO kmg_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Makedonia mâreŋko ware fisirâ wemocko âke uruerâ junšapeŋ. Ʒira sahacte biŋe šika â maŋte biŋe hâhâwic, wiac izi fuarâ sisi hâhâŋ enâreha jumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Bebekâne bâmiriŋ-jopaekac Anutu eki hâcne ine nâŋere bâbâmiriŋte Tito ecneme risiewec. ");
INSERT INTO kmg_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Erâ risiewec irec sawa mâcne, ŋoŋe bubiaŋ dâŋ âzâcnembiŋ, i bafisime manarâ bunâŋec uruewec. Erâ no woricnuhuc jueŋgopieŋ â ki busâqochec jueŋgopieŋ â nore erâ gie-ŋeŋic dopeckehuc šoɋac eeŋgopieŋ, i nâzâme bubiaŋ fekicne manapo. ");
INSERT INTO kmg_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","No mârâc papia moc qâreŋke-ŋarehuc maŋšâic bâfua-ŋarepo, irec bunane mi sâqorekac. Qâreŋkepo ira jâmbomac bunane sâqorewec. Ʒi ine manakopac, i dameŋ bembeŋne sawa maŋšâic bâfua-ŋarewec. ");
INSERT INTO kmg_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Eme ši bubiaŋ manakopac, ine bušâic manambiŋ irec mâcne, bušâiczi ŋoŋerao maŋ bâbârisie bâfuawec, irec bunane biaŋkekac. Anutu mamana-ticnere sâcko bušâic ɋaɋacne manambiŋte dâŋnâŋeczi mi bâsâqorec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Bušâic ɋaɋacne izi maŋ bâbârisie bâfuame ŋiczi biaŋkezo, eme bušâic iŋucne bâfuaocmuzi šâhec irec mi maname sâqoreocmu. Á bušâic gâpâcne, ŋic mamanare sâcko fuaekac, izi ine maŋmutuc bâfuame sipirickezo. ");
INSERT INTO kmg_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Honeniŋ me, bušâic ɋaɋacnezi ŋoŋerao fârine wemo afecne bâfuawec: Fâro, fuŋne babataniŋ, sâqocne bâbâsue, hâhâwic, mu hejâpec, šoɋac, bâbâtiŋ, wiac iŋuc hâcne bâfuawec. Eme sâqocnere hehesoŋ â ŋeŋezic ŋoŋerao mi fokac, irec fuŋne taniŋkewec. ");
INSERT INTO kmg_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Mârâc papia qâreŋke-ŋarepo, i ŋic sâqocne bawec ere erâ mâcne, me sâqocne bajarewec jaŋere erâ wâc mâcne, dâŋ ŋazapene Anuture maio micrereŋ-ŋeŋicte fuŋne taniŋkeocte irec qâreŋke-ŋarepo. Eme ŋoŋe iŋuc hâcne ehuc bunâŋec bâmiriŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Erâ bunâŋec bâmiriŋkembiŋ sawa mâcne, ŋoŋe Tito bubiaŋ qacnepie risieme nâŋe wemo afecne mana biaŋ embeŋ. ");
INSERT INTO kmg_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","No mârâc jaha muafec-ŋopahuc Tito âzâcnepo, dâŋ i burec mi ewec. Ŋoŋe dâŋ ŋazape fârinehec efârewec, iŋuc jaha Tito ŋoŋere mumumbiaŋ dâŋ âzâcnepo i wâc fârinehec jaha ewec. ");
INSERT INTO kmg_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Tito ŋoŋerao fâme araŋ bacnehuc micne reŋkembiŋ, e irec manasuhuc maŋne ŋoŋere boc ecneekac. ");
INSERT INTO kmg_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","No ŋoŋere erâ maŋbahac tâmiric sâcne jupemu, irec bunane biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Âgo bureŋ, Makedonia mâreŋkonec kikefuŋ jaŋerao Anuture jauŋ fuawec irec ŋazanaŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Jaŋe šârâ hâriŋ sâkoo juhuc bahac qahameŋ erâ tac qararacne jueŋgopieŋ, ehame sifu mitire šeri fekicne fojareekacte bubiaŋ wiac ɋâfoŋne bâmockembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","No jaŋere mana-jâmbâŋkekopac, jaŋe jaŋacne maŋte afeckerâ tâpiri-jeŋicte sâc, erâ wâc sâc i jâuruhuc râembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Nâŋe mi ejarehapene jaŋe jaŋac hota-nârehuc mitiŋic jaŋere bubiaŋ wiac bâfuarâ bafic-nâponiŋte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Erâ wiac afecne eniŋmu muhapene šiŋuc embiŋ: Qanaŋ maŋjeŋic Wofuŋ qikiŋnecnerâ nâŋe mâmâc Anuture erâ qikiŋne-nârembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Jaŋe iŋuc embiŋte Titozi ŋoŋerao bubiaŋ gie barâ tofane râewec i bataraocte mucneŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Eme mamanasiŋ â miti mumu â miti fuŋne mamana tara â giere šoɋac â maŋjauŋ eenare, wiac iŋucnere fârine bocjaha bâfuambiŋte bubiaŋ gie mukicne irec iŋuc jaha afeckenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","No hotâ-ŋarehuc mi mukopac, miti mamana gâcne jaŋerao aafec fuawec, eme ŋoŋere maŋjauŋ sâc weniŋucne fokac irec fuŋne taniŋkeocte mukopac. ");
INSERT INTO kmg_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Ŋoŋe Wofuŋ-nâŋec Jesu Kristo uruc jauŋ-ticnere manaeŋgopieŋ, e mâriri sâkoheczi ŋoŋere erâ hapetac ewec, i ŋoŋe hapetac-ticnere erâ mâririhec eniŋte iŋuc hâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Eme ši dâŋ mâc ŋazakopac i reŋkepie fârinehec ezejec. Ŋoŋe hâcne jara raŋɋanao biac moneŋ bâtureniŋte afeckerâ fuŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Eme i šuhuckerâ etarapie aafec-ŋeŋicte fârine, wiac foŋarekac sâc fuazejec. ");
INSERT INTO kmg_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Wiac buafecte rârâe irec mamana biaŋ fuaocmu, rârâe ine moc e focnekac irec sâc râezejec, mi focnekac irec sâc mâcne. ");
INSERT INTO kmg_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Bubiaŋte wiac rârâere mukicne i jaŋe sahac mâteŋ juhapie ŋoŋe šocne šâicne mananiŋte mâcne, ");
INSERT INTO kmg_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ŋoŋere mafa mâririzi dameŋ šiŋuczia jaŋere roroc jâpeme wiac sâckoa fuaocte mukicne, eme juku dameŋ mocko jaŋere mâririzi ŋoŋere roroc jâpeme iŋuc jaha sâckoa fua-ŋarezejec. ");
INSERT INTO kmg_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Dâŋqâreŋ šiŋuc hâcne fokac: “Bocjaha nusembiŋzi mâririhec mi embiŋ, â afecne nusembiŋzi roroc mi embiŋ.” ");
INSERT INTO kmg_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","Anutu e Tito esockeme, maŋnâŋezi ŋoŋere erâ bâruŋkekac sâc ijaha erao fuakacte muteŋkenaŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Nâŋe mucnepene manawec sawa mâcne, e jahac maŋticnere afecke-jâmbâŋkerâ fâzo ekac. ");
INSERT INTO kmg_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Opâ ruac âgo-nâŋec moc, kikefuŋ sasawa jaŋe Biŋebiaŋte gie bapa-ticnere mana biaŋ eeŋgopieŋ, e mâmâc sorepene fâkopirec. ");
INSERT INTO kmg_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Kikefuŋ jaŋe ŋic e hâcne bubiaŋ moneŋ rorore bafic-nâpoocte bâwosâembiŋ. Gie i Wofuŋ sâsehuc buafec-nâŋecte baŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Mumusifuc fuazacte moneŋ sâko i šâŋe šereŋko sosoŋaŋ ehuc ro qâzuc eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Nâŋe wiac epene Wofuŋzia maname biaŋkeocte mâcne, ŋiczi mâmâc manapie sâckeocte mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Nâŋe jahehec âgo-nâŋec moc mâmâc sorec-jopapene fâŋgopieŋ, ŋic e dameŋ gâcnao esâicke honepene šoɋac-ticnere fuŋne taniŋkewec, ši ine ŋoŋere bubiaŋ manahuc šoɋac fekicne bâfuakac. ");
INSERT INTO kmg_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Ŋoŋe Titore manaeŋgopieŋ, e âgo babafic-nane, mâmâc gie bapa ŋicjahec-ŋeŋic jukoperec, â âgo jahec-nâŋec jahere wâc manaŋgopieŋ, jahe kikefuŋ jaŋe sorec-jofaŋgopieŋ, erâ jahe Kristore šuŋe gâpiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Nâŋe ŋoŋe muafec-ŋopaeŋgopeneŋ irec dâŋ i fârinehec eocte ŋic iŋucnezi fâpie âgo jauŋ ejarepie kikefuŋ gâcne jaŋe mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Mitiŋic ehâmo-jarehuc moneŋ jareniŋte i sâcne manaŋgopieŋ, irec wemocte boc qâreŋke-ŋarepemu. ");
INSERT INTO kmg_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Akaia opâ ruac ŋoŋe jara raŋɋanao biac afeckerâ moneŋ bâbâfua fuŋkembiŋ, irec binaŋ Makedonia ŋic bajarepe ŋic gâcne sâko jaŋe šoɋac-ŋeŋicte biŋe manarâ bujeŋic âeckewec. ");
INSERT INTO kmg_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","No muafec-ŋopapo i racne ezacte âgofâc-nane sorec-jopape fâpie mupo iŋuc hâcne erâ šawienšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","No nahac šâhec Makedonia ŋic jaŋehec fâpe moneŋ rârâere bititiepie dâŋnane wawahane eme no â ŋoŋe mâmâc mimienšipeŋ. ");
INSERT INTO kmg_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Irec hâcne ŋic ejarepe bânierâ fâŋgopieŋ. Fâ fisipie bubiaŋ moneŋ râeniŋte nazambiŋ i qanaŋ râe bâmoc epie ŋezejec. Eme micneneŋte moneŋ mâcne, mitire bubiaŋte moneŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Erâ ine šiŋuc mukopac: Moc e wiac afecne he sarac eocmu, e wiac afecnea nâ roroc eocmu, â moc e wiac ŋemâcne he sarac eocmu e wiac ŋemâcnea nâ roroc eocmu. ");
INSERT INTO kmg_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Irec šiŋuc efârezo: Moc e buafec-ticnere sâcko wiac-ticne qikiŋnezejec, jâiŋko me micneneŋte misac. Wiac buafec qikiŋneocmu, ŋic iŋucnere Anutuzi maname biaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Anutu e tâpiri runezi buafec-ticnere jambuŋ-ŋopame mâriri fua-ŋareme ŋaŋacne nâ bac eipiehuc bâmec gie fuŋne fuŋne baniŋte wiac mi basaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Dâŋqâreŋ šiŋuc hâcne fokac: “E kada bahuc ŋic hapetac bâmec bajareekac, â buafec-ticne i tofamâc fohuc juocmu.” ");
INSERT INTO kmg_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Ŋic ukicne bâfua-jareme he sarac eeŋgopieŋ â fârine bâfua-jareme nâ bac eeŋgopieŋ, Anutu e hâcne ŋoŋe wâc he sarac eniŋte ukicne bâfua-ŋarerâ jambuŋkeme buafec-ŋeŋicte fârine fua sawec eocmu. ");
INSERT INTO kmg_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Eme mâriri sâkohec erâ ŋic bâmec fuŋne fuŋne bajarepie jaŋe nâŋâcnere erâ Anutu daŋge mumuteŋ ecneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Ŋoŋe mitiŋic bubiaŋ wiac ejarepie izi roroc-jeŋic jâpeocmu sawa mâcne, izi daŋge mumuteŋ irec mâriri wâc bâfuame Anuturao qacneocmu. ");
INSERT INTO kmg_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Ŋoŋe Kristore Biŋebiaŋ mana rereŋ eeŋgopieŋ irec fuŋne bubiaŋ wiac-ŋeŋiczi bataniŋkeme Jerusalem haeonec mitiŋic â opâ ruac gâcne sasawa jaŋehec ââgo šušuhuc-ŋeŋic fuame Anutu mumbiaŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Erâ ŋoŋerao Anutu miti-ticnere fârine fua sawec ekacte maŋzi šâfic-ŋopahuc ŋoŋere erâ Anutu numucneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Anutu buafec-ticne i wemocko sâcne mutaniŋkezo, irec mâc wareckehuc daŋge âzâcnenaŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Ʒi Paulo noni Kristo bumâteŋ-ticnere â uruc-ticnere erâ ŋazape mananiŋ. Gâcnezi nore mueŋgopieŋ, “Ʒira ware juhuc miriŋdâŋ enâreekac, â ocna ra juhuc momori dâŋ enâreekac.” ");
INSERT INTO kmg_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Âgofâc, ŋoŋerao fâ juhuc momori dâŋ ŋazapemurâ irec mi qafeŋnunšepieŋ. Gâcnezi “sahacte wiacko utuckerâ juekac”, nore iŋuc mueŋgopieŋ, ŋic i jaŋe momori dâŋ jazapemurâ maŋnane afeckekac. ");
INSERT INTO kmg_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Wiac nâŋe sahachec juju i jâmbomac jueŋgopeneŋ, â momori juju ine sahacte hata fokac iŋucko mi jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Sându maro bajuhuc juju gie baeŋgopeneŋ, i mâreŋkonec mâcne, i Anuture tâpiri sanaŋhec. Eme izi râsire sac bazueŋgopeneŋ, â qac momori-ticne qapene wahaekac, ");
INSERT INTO kmg_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","â hârâc huec Anuture dâŋ sirickeekac i qa imac eeŋgopeneŋ, erâ Kristore micrereŋ sawa fuaocte mamana fuŋne fuŋne kâpâcwâru baeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Ŋoŋe micrereŋte afecke-fârehapie nâŋe ŋic gâcne jaŋe qaqatara-jeŋicte bâtiŋ-jopazore woŋec juŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","Wiac moc ši tâtâc fokac i honeniŋ: Ŋoŋe wemocte sahackopec wiac omanere manapie fârine eekac? Ŋoŋeraonec ŋic moczi e jahacnere maname Kristore ŋic fârine eekacko šiŋuc manazejec: E buc Kristore ŋic mi juekac, nâŋe wâc Kristore ŋicfâc jaha jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","Erâ Wofuŋzi giere tâpiri râe-narewec, ŋoŋe âkesiŋ-ŋopapere, sipiric-ŋopapere mâcne, no irec erâ ropaŋdâŋ piticne murašihuc mupe boc mi sâqore-nareocmu. ");
INSERT INTO kmg_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Á papia qâreŋke-ŋareekopac irec manapie mu hâhâwic dâŋ mi ezejec. ");
INSERT INTO kmg_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Ʒiŋuc hâcne munareeŋgopieŋ: “Papiao dâŋ bipinehec â tâpirinehec qâreŋkeekac, sahaczi maic-nâpoekac ine weweaŋne, â dâŋ mumu-ticne ine wawahane.” ");
INSERT INTO kmg_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Ŋic iŋucne jaŋe šiŋuc mananšepieŋ: Nâŋe šoricko juhuc dâŋ qâreŋkeeŋgopeneŋ, dâŋ irec fârine ŋondeŋ-ŋeŋicko juhuc bâfuaeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Ŋic sahac fefe jueŋgopieŋ jaŋerao nâŋe iŋucnezi wemocko šuhuckerâ sâc babac enaŋmu. Ŋic i jaŋe hâcne gâcne nâŋere eebapa irec mi manasuhuc jaŋacnere sawa muhuc sahac fefe dâŋ kosa woseeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","Nâŋe ine Anutuzi giere sâc banârewec iŋuc bafâku ŋoŋerao fisimbeŋ, irec mac manasuhuc mumuafec dâŋ mueŋgopeneŋ, â sâc tâmiricko kosa mumu ine mi eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Nâŋe gie-nâŋecte sâc i mi musokaeŋgopeneŋ, gie rukec-nâŋec i jâmbomac ŋoŋerao fokac, nâŋe hâcne bâbâni ŋoŋerao fisirâ Kristore Biŋebiaŋ qanaŋ ŋazambeŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Nâŋe ŋic gâcne jaŋere gieo kâŋgâc raši domahuc sahac fefe dâŋ kosa mumu i mi eeŋgopeneŋ. Mamanasiŋzi ŋoŋerao fua sawec eme gie rukec-nâŋec bâsokanaŋte ine jâmbomac maŋnâŋec domaha jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Eme ŋic râpe-ŋeŋicko juŋgopieŋ jaŋerao Biŋebiaŋ muranaŋmu. Á ŋic mocte gie fârine rauckehuc pepec dâŋ mumu i mi eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","Moc e mumuteŋ dâŋ muzo murâ Wofuŋte erâ muzejec. ");
INSERT INTO kmg_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Moc e jahacne sahac mumbiaŋkeme e miti fârihec ekac mi mucnezo, Wofuŋzi mumbiaŋkeme miti fârihec ekac muzo. ");
INSERT INTO kmg_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Ŋoŋe manahapie mutucdâŋ piticne ŋazape. Sifu mac mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","No ŋoŋere erâ qizec qaekopac, erâ qizec qaqa dâŋnane i Anuturaonec. Noni ŋoŋe Kristore biŋefâc erâ pectâc juniŋte ŋic mocjaha ehec bâturec-ŋopapo. ");
INSERT INTO kmg_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","Ʒi ine homazi Ewa sioc ecnehuc bâdockewec iŋuc jaha ŋoŋe ŋic gâcnezi eatuc-ŋopapie maŋŋeŋic fâuckeme Kristo râŋgeŋ rocnenšipiŋte manabâc ekopac. ");
INSERT INTO kmg_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","Ŋoŋerao ŋic moczi fisirâ Jesure fuŋne nâŋe ŋazaeŋgopeneŋ ijaha mâcne, hawarine moc ŋazaocmu, â Mâro nâŋeraonec rombiŋ i mâcne, furune moc ŋareocmu, â Biŋebiaŋ nâŋeraonec manambiŋ i mâcne, maracne moc ŋazaocmu, i ŋoŋe mi qatarahuc mâc manapie sâckeekac. ");
INSERT INTO kmg_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","No nahacnere manape norao wiac i me i basahuc aposolo fekicne sâko jaŋere jujuwicnao jukopac mi eekac. ");
INSERT INTO kmg_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","No miti muminširiŋkerâ mumu i mi mecne fonarekac, â mitire fuŋne mamana ine manaekopac, erâ irec fuŋne baratie-fârehuc mâmâc-ŋeŋic bataniŋke-ŋarepo. ");
INSERT INTO kmg_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Me nahac wahamicne juhuc ŋoŋe ikisiŋ-ŋopahuc Anuture Biŋebiaŋ katucmâc ŋazapo i sâqorewec me? ");
INSERT INTO kmg_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Ŋoŋerao miti gie bapemurâ kikefuŋ gâcne jaŋe jâmbomac moneŋ mafa jowac ropo. ");
INSERT INTO kmg_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Ŋoŋerao ine wiac basac bahameŋ juhuc mubâre mi eŋarepo. No batac qatac juhape Makedonia mâreŋkonec âgofâc-nane fisirâ wiac nare gumec embiŋ. Á ŋoŋerao ine mâc juhape nore šâic mi manambiŋ â jufehuc wâc mi mananiŋte mukopac ");
INSERT INTO kmg_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Kristore dâŋfâri maŋnaneo foha mukopac: šeridâŋ inane Akaia mâreŋko moc mi bawaha-narezo. ");
INSERT INTO kmg_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Muŋgopieŋ,ŋoŋere mi enarehame iŋuc eekopac? Iŋuc aricne,i Anutuzi manakac. ");
INSERT INTO kmg_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Wiac eekopac i ehuc jupemu, erâ i mâc mâcne, ŋic gâcne jaŋe Paulore sâcko juŋgopeneŋ muhuc maŋjeŋic bafenšipiŋte siŋ qatara-jareekopac ");
INSERT INTO kmg_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Ŋic iŋucnezi aposolo burecne â miti gie bapa siochec juhuc Kristore aposolofâc nâŋere sahac hawari sawa eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Erâ i wiac furune mi eeŋgopieŋ, Sataŋ e jahacne wâc aŋelo tatamachec jaŋere hawari tinac eekac, ");
INSERT INTO kmg_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","eme irec gie bapa ŋicfâc-ticne jaŋe iŋuc jaha tiŋnere kiŋaŋ qaqa jaŋere hawari rojueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Mupac i mocwâc mupe, nore manapie ŋic mutucne mi ezejec. Erâ sifu muzo murâ muniŋ, ehuc mana-narehapie sahac-nane piticne muteŋkepe ");
INSERT INTO kmg_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","No ši dâŋ mupemu i Wofuŋte micsâcko mi mupemu, mâc mumuteŋ dâŋ fuŋkekicnere sifu mutuc erâ mupemu. ");
INSERT INTO kmg_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Ŋic gâcnezi sahackopec wiacte mumumbiaŋ dâŋ mueŋgopieŋte no iŋuc jaha epemu. ");
INSERT INTO kmg_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","Oi, fuŋne mamana ŋoŋe, gâcnezi mutucdâŋ ŋazapie manapie sâckeekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","Á kiŋaŋ qaqafâc-jeŋic bacŋopapie iŋuc jaha manapie sâckeekac, â ŋowac ro nâc eŋareniŋmu me eatuc-ŋopaniŋmu me ŋicbomboŋ eŋareniŋmu me imac-ŋopaniŋmu, i ŋoŋe manapie sâcke-fâreocmu hâcne. ");
INSERT INTO kmg_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","Nâŋe gegec dodocnezi iŋuc sâko wemocko eŋarenšapeŋ, i mana sâqorehuc mukopac. Moc e wiac irec me irec penaroŋ eocmu, i no ezo murâ sâcne epemu. Dâŋ i mutucne, i mana-bipiehuc mukopac. ");
INSERT INTO kmg_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Jaŋacnere Judaŋic mueŋgopieŋ, no wâc ijaha. Jaŋacnere Israe ŋic mueŋgopieŋ, no wâc ijaha. Jaŋacnere Abrahamte ɋâric mueŋgopieŋ, no wâc ijaha. ");
INSERT INTO kmg_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Jaŋacnere Kristore gieŋic mueŋgopieŋ, no ši sifu maŋmutuc dâŋ mupe, no Kristore gieŋic sâc moc. No giere šâic manaekopac i sâc moc, â kâpâcwâru ficko feekopac i sâc moc, â šika kiekopac i sâc moc, â sipirickezo eekopac i sâc moc. ");
INSERT INTO kmg_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Judaŋic jaŋe dameŋ memoc repazi 39 numbiŋ, ");
INSERT INTO kmg_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","dameŋ jahec â moc kâcbiŋzi nukicne, moc i qânâzi hehâmocnumbiŋ, dameŋ jahec â moc woke hericke fâuc eme hâwecko hurâ hu epo, ŋafe šoaŋ moc woke sâqoreme hâwecko qac qâsoriehuc jupo. ");
INSERT INTO kmg_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Erâ sopâc kâte hârâc tiki fotâcne qâqâwiric bazu bâfeŋ ehuc jupo, opâ rumio šârâ šâpâ faio fehuc jupo, râsi ŋondeŋko šârâ šâpâ faio fepo, Judaŋic ŋondeŋko šârâ šâpâ faio fepo, qâpuc ŋondeŋko šârâ šâpâ faio fepo, ŋic jujuo šârâ šâpâ faio fepo, tuhuo šârâ šâpâ faio fepo, hâwecko šârâ šâpâ faio fepo, mitiŋic burecne jaŋere ŋondeŋko šârâ šâpâ faio fepo. ");
INSERT INTO kmg_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Iŋuczi iŋuc ehuc hume serereŋ â huacbuc qâbucne juwarepo, ehuc ŋafeo guŋɋâri juju,nânâ opâre hâhâmo, hoe mâmâteŋte ɋarac ɋarac qaqa, ŋaqi bilaŋke babasa, iŋuc ehuc juekopac. ");
INSERT INTO kmg_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","Erâ i sawa mâcne, šoaŋne šoaŋne kiŋaŋ fisihuc fâro âkefec enarepie hae sâc kikefuŋ jaŋere mana mezac ehuc juekopac. ");
INSERT INTO kmg_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Wemocko hae moczi qau bititicne juhapie âke uruerâ sâcne jupemu? Wemocko hae moczi qâsoriehapie sâcne ŋemâteŋkepemu? ");
INSERT INTO kmg_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Eme no irec wemo-nane musokapemu? Gegec dodoc-nane mocjaha musokape sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Wofuŋ Jesu ere Anutu â Mamac, e mumuteŋ hatizi dâŋ jâmbomac mukopac i manakac. ");
INSERT INTO kmg_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Damasko haeo juhape ŋicwofuŋ Areta ere kiazi kâpâcwâru bacnuocte hae upeo somâ râewec. ");
INSERT INTO kmg_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Eme irec âgofâc-nane jaŋe kâdocko ŋihecnurâ sacrâpeo âke suecnupie hurâ wisepo. ");
INSERT INTO kmg_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Mumuteŋ dâŋ mupene mi sâckeekac, erâ sifu mupe. Ehuc Wofuŋzi maŋko fuac â maŋbâwiŋ enarewec, irec dâŋ binaŋ epe. ");
INSERT INTO kmg_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","No Kristore ŋic moc manakopac e wiac moc honerâ jukuhame jara 14 ekac. Ŋic e hâcne Wofuŋzi maŋbâwiŋ ecneme sambâŋ namba 3 ira fewec. I sahachec me sahac tâmiric ewec, i no mi manakopac,Anutuzia manakac. ");
INSERT INTO kmg_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","Eme ŋic e Wofuŋzi maŋbâwiŋ ecneme paradisio hâcne ferâ dâŋ miczi mi mumune â mâreŋŋiczi mi mumufuane i manawec. ");
INSERT INTO kmg_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","No ŋic e manakopac, â sahachec juhuc me sahac hetarahuc ewec, i no mi manakopac, Anutuzia manakac. ");
INSERT INTO kmg_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Ŋic ere erâ mumuteŋ dâŋ mupemu, nahacnere mi mupemu, ine muzo murâ gegec dodoc-nane sawa musokapemu. ");
INSERT INTO kmg_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Mumuteŋ dâŋ mupe muzac, i jâmbomac dâŋ muzapore ŋic mutucne mi ezapo. Erâ nore manapie fefene boc ezacte ine mi epemu, wiac mupe bape ŋaŋac hone manac eeŋgopieŋ izia fozejec. ");
INSERT INTO kmg_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Wofuŋzi wiac šâŋe hazec furu nowatuwec, irec maŋnane fezacte sahac biuc-naneo šârâ moc duckewec, i Sataŋte kiŋaŋŋic moc e maŋnanezi boc fezacte mehuhuŋzi hecnuhuc juocte mukicne. ");
INSERT INTO kmg_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Eme behecnuocte Wofuŋ wâsickekuhape jahec â moc ewec. ");
INSERT INTO kmg_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","Eme dâŋ šiŋuc nazawec: “Jauŋ-nanezi sâcguekac â tâpiri-nanezi dodoc rorokacko fua ɋârâŋkeekac.” Irec Kristore tâpirizi norao mâckeocte dodoc rorokac-nanere manape feha mumbiaŋkezepac. ");
INSERT INTO kmg_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Eme Kristore erâ dodoc rorokac epemu me šika kipemu, me hume serereŋ jupemu, me fific guguriŋ â imaŋ gomaŋ faio jupemu, i sifu bubiaŋ manaekopac. No dodoc rorokacko sanaŋkeekopac hâcne. ");
INSERT INTO kmg_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Ʒi mutucdâŋ mupac, i ŋoŋe enarepie mupac. Ŋaŋac mumbiaŋnupie sâckezac. No jawa omane juekopac i manakopac, erâ aposolo fekicne jaŋere wahamicne juju ine mi juekopac. ");
INSERT INTO kmg_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","No ŋoŋerao gie maŋuruc jaha bape mâsi â wiac šâŋe furu â wiac tâpirihec fuahuc izi aposolo fuŋne-nane bataniŋkewec. ");
INSERT INTO kmg_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Eme ŋoŋe wemo basahuc kikefuŋ gâcne jaŋere sâc mi embiŋ? Mâc wiac ŋowac ro nâc ee i mocjaha mi eŋarepo. Hehesic-nane i mi mana sâqore-narenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","No jajahec iqic-ŋopapo, eme ši mocwâc fâpere šawiehuc jukopac. Fârâ mârâc epo ijaha ehuc sahacte dopere mi bâšâic-ŋopapemu. No moneŋ mafa-ŋeŋicte mâcne, ŋaŋacnere harac eekopac. Naru moteczi neŋgoc mamac wiac hure-jareniŋte mi mukicne, neŋgoc mamaczi naru motec hure-jareniŋmu ine sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","No ine maŋ qâqâtâc-ŋeŋic biaŋkeocte moneŋ mafa sawa mâcne, juju-nane wâc qaisockezo afeckekopac. Nore maŋzi ŋoŋere kâcɋene domaha ŋoŋerezi nore piticne domaoc me? ");
INSERT INTO kmg_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Ŋic gâcnezi nore šiŋuc mueŋgopieŋ: Wiac tâtâc nânâwoc ro i mi ewec. Á soŋsoŋko ŋic eatuc-jopahuc wiac jojowac ro i ewec mecne. ");
INSERT INTO kmg_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","Irec ŋoŋe muniŋ, no ŋicfâc-nane ŋoŋerao sorec-jopahuc ejarepe wiac moc ŋowac rombiŋ me? ");
INSERT INTO kmg_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Erâ Tito fâocte mucnepo ehuc opâ ruac moc sorepe jojowac erâ fâpic. Eme Titozi fârâ wiac moc ŋowac rowec me? Nâhe Mâro wirec â hata wirec mi jukoperec me? ");
INSERT INTO kmg_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Dâŋ mueŋgopeneŋ i esecne mana warepie sahac ŋeŋezic dâŋ eekac me? Erâ iŋuc mâcne, nâŋe Kristohec juhuc Anuture maio dâŋ mueŋgopeneŋ, erâ âgofâc, irec me irec mâcne, ŋoŋe âkesiŋ-ŋopanaŋte dâŋ mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","No ŋoŋerao fârâ honec-ŋopape mi sâckezacte, â ŋoŋe nore iŋuc jaha manapie mi sâckezacte manabâc ekopac. Ŋoŋerao kisâ, iiŋguuŋ, kimbeŋ, hehefaric, micko âkec, gupe, penaroŋ, hesi qâsifuc, wiac i fohame fâ bâfuazipore maŋbahacnukac. ");
INSERT INTO kmg_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Ŋoŋeraonec gâcnezi maŋwânâŋ, boe sau, nânâ qowi âmbâŋ nânâ, i ehuc maŋjeŋic mi bârisieeŋgopieŋ, eme iŋuc juhapie ŋoŋerao fâpe Anutu-nanezi bawahacnume ŋic iŋucne jaŋere ki busâqoc ezipore mana mezac ekopac. ");
INSERT INTO kmg_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Ʒi ŋoŋerao mocwâc fâpe jahec â moc eocmu. Fâ fisipe ŋic jajahec me jahec â moczi mocte bahacte fuŋne mupie dâŋticne munaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Ŋic bahachec â gâcne ŋoŋe mâmâc arecne 2 fâpo ira uŋ ŋazapo ijaha wiwicko juhuc mukopac, ši šâhec mocwâc fârâ mi akic-ŋopapemu. ");
INSERT INTO kmg_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","Nore maŋko dâŋ râeme muekopac Kristo hâcne, ere tâpiri fuame honezo mueŋgopieŋte honenšepieŋ. Kristo e ŋoŋerao gie-ticne rorokacne mâcne, tâpirihec baekac. ");
INSERT INTO kmg_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Mârâc jâmbomac rokaweme maripoŋko qambiŋ, ši ine Anuture tâpirihec faharewec jukac. Nâŋe iŋuc jaha ere erâ rokaweeŋgopeneŋ irec ere erâ wâc Anuture tâpirio ŋesiŋnehuc jujure fuŋne ŋoŋerao bajaŋgeŋkenaŋmu. ");
INSERT INTO kmg_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Ŋoŋe mamanasiŋhec jueŋgopieŋ me mâcne, irec maŋŋeŋic esâicke honehuc fuŋne bataniŋkenšepieŋ. Me Jesu Kristozi maŋŋeŋicko juekac irec fârine basaeŋgopieŋ? Iŋuc eeŋgopieŋko sahaczi mitiŋic muŋarezo. ");
INSERT INTO kmg_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Nâŋe ine sahaczi mitiŋic mi jueŋgopeneŋ, iŋuc hone tarac-nâponiŋte worickekopac. ");
INSERT INTO kmg_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Anutuzi soŋaŋ-ŋopame bahac mi bâfuaniŋte numucnehuc jueŋgopeneŋ. Nâŋe honec-nâpopie mitiŋic fârine enaŋmu me mâcne, irec mi mueŋgopeneŋ, ŋoŋe mitidâŋ reŋkepie fârinehec eocte mocjaha mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Nâŋe iŋucnezi wemocko dâŋfâri râsi ecnenaŋmu, âgo ecnenaŋmu sawa fokac. ");
INSERT INTO kmg_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Nâŋe tâpiri basahuc juhapene ŋoŋe tâpirihec juniŋmu i bunâŋec biaŋkeocmu. Erâ maŋŋeŋiczi soka sanaŋ eocte Wofuŋ numucneeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","No ŋoŋerao fârâ šâire-ŋarezipore qanaŋ šoricko juhuc uŋdâŋ qâreŋke-ŋarekopac. Wofuŋzi tâpiri narewec, izi imac-ŋopapemurâ mâcne, hume keteŋ eŋarepemurâ narewec. ");
INSERT INTO kmg_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Erâ dâŋ mutarahuc kecšiŋuc mupe: Ŋoŋe bubiaŋko junšepieŋ, erâ uŋsawaŋ dâŋ manarâ maŋŋeŋic ba emasaŋ enšepieŋ. Ŋoŋe maŋ mocjaha efârerâ wamao junšepieŋ. Eme Anutu e maŋjauŋ â wama runezi ŋoŋehec juocmu. ");
INSERT INTO kmg_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Ŋoŋe mitio meo babac efârenšepieŋ. širec mitiŋiczi manasuc-ŋopa-fâreŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Wofuŋ Jesu Kristore aki anonoc â Anuture maŋjauŋ â Tiri Mârore miriŋ i ŋoŋerao fohuc juzejec. ");
INSERT INTO kmg_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Paulo no aposolo, ŋiczi mi sorecnumbiŋ â ŋic moczi gie wâc mi munarewec, Jesu Kristo â Anutu Mamac e hâmockonec bâɋâreweczi gie i munarewec. ");
INSERT INTO kmg_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","No â âgo gâcne nohec juŋgopieŋ nâŋe kikefuŋ Galatia mâreŋko juraŋgopieŋ ŋoŋe papia ši râe-ŋareŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Anutu Mamac â Wofuŋ-nâŋec Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Jesu e Mamac-nâŋec Anutu ere micte juju sâqocne ši jueŋgopeneŋkonec bâhoc-nâpoocte sindaŋ-nâŋecte erâ sahac-ticne qaisockewec. ");
INSERT INTO kmg_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Irec erao mumuteŋzi mumuteŋ fohuc juzejec. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Ŋoŋe Kristore aki anonocko râec-ŋopahuc hefârec-ŋopawec ehec jupie mi šoraha e râpeckehuc miti fuŋmoc irec hazec rârâe eŋgopieŋ, no irec wareckekopac. ");
INSERT INTO kmg_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Erâ Biŋebiaŋ fuŋmoc wena fokac? I aricne i. Mâc ŋic tucnezi maŋ bâsifuc eŋarehuc Kristore Biŋebiaŋ âke sipueŋgopieŋ, i sawa fokac. ");
INSERT INTO kmg_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Irec nâŋe wâc, me sambâŋkonec aŋelo moczi, Biŋebiaŋ ŋazakicne i âke sipuhuc moc ŋazanaŋmuo, iŋucnezi hârâcte biŋe ezejec. ");
INSERT INTO kmg_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Dâŋ mârâc mumbeŋ ijaha ši wâc mukopac: Moczi Biŋebiaŋ qazu-ŋarekicne i âke sipuhuc moc ŋazaocmu e hârâcte biŋe ezejec. ");
INSERT INTO kmg_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Eme weniŋuc, dâŋ ši mukopac i ŋiczi honecnupie biaŋkeocte me Anutuzi honecnume biaŋkeocte mukopac? No ŋic dape-jarehuc gie bazapo muzac, wemocko Kristore kiŋaŋ qaqa juzapo. ");
INSERT INTO kmg_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Âgofâc-nane, no dâŋ ŋazape mananiŋ: Biŋebiaŋ ŋazapo i ŋickonec mâcne, ");
INSERT INTO kmg_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","erâ wâc ŋiczi mi naza qazuc embiŋ, i Jesu Kristo e jahac mufua-narewec. ");
INSERT INTO kmg_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","No mârâc jaha Judaŋic jaŋere guruo juhuc wiac epo, i ŋoŋe manaeŋgopieŋ. No Anuture kikefuŋfâc jopa jâpec ejarehuc mâretec sipiric-jopapo. ");
INSERT INTO kmg_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Ehuc kâcɋenefâc-nâŋec jaŋere dâŋ mi wahazejec muhuc samac qamandiŋkerâ motec âgofâc-nane siric-jopapo. ");
INSERT INTO kmg_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Eme Anutu e qanaŋ neŋgoc bumaŋko hone wosâecnurâ uruc jauŋ-ticnere erâ hefârec-nuweczi maname sâckeme ");
INSERT INTO kmg_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","Ŋokâ-ticnere biŋedâŋ qâpuc jaŋerao musawepere ere fuŋne bataniŋke-narewec. Iŋuc enareme sahac biuchec jaŋe mu wioc mi ejarepo, ");
INSERT INTO kmg_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","erâ wâc Jerusalem haeo mi ferâ aposolo fuŋkerâ juwarembiŋ jaŋe mi iqic-jopapo. Aricne, no Arabia mâreŋko ra juku Damasko haeo risiepo. ");
INSERT INTO kmg_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Juhape jara 3 tarame Kefa honepemurâ Jerusalem haeo ferâ šoaŋ gie bapa 15 ehec jupo. ");
INSERT INTO kmg_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Aposolo gâcne mi honec-jopapo, Wofuŋ ɋaticne Jakobo e sawa honepo wâc. ");
INSERT INTO kmg_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Dâŋ qâreŋkekopac i Anuture maio jâmbomac muhuc qâreŋkekopac. ");
INSERT INTO kmg_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Iŋuc erâ Siria â Kilikia mâreŋko ra jupo. ");
INSERT INTO kmg_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Á Judaia mâreŋko Kristore kikefuŋ jaŋe ine mi honecnumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Jaŋe nore biŋedâŋ šiŋuc sawa manambiŋ: “Nâpo jâpec enârehuc miti ima qaocte muweczi ŋic miti i hâcne jazahuc juekac.” ");
INSERT INTO kmg_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Iŋuc muhuc nore erâ Anutu muteŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Ehame jara 14 tarame Jerusalem haeo mocwâc fepemurâ Banaba â Tito rocjofape mâmâc fembeŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Erâ i mâc mi epo, Wofuŋzi dâŋ mufua-narehuc bufahac qanareme fepo. Ferâ qâpuc jaŋerao Biŋebiaŋ musaweekopac i mutaniŋke-jarepo. Micne šâŋe biŋehec jaŋe bucko wâc ejarekicne, jaŋe hâcne manapie mi sâckeme gie maŋgâŋ bawefuhuc jupo iŋuc ezacte. ");
INSERT INTO kmg_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Jupe juju-nane Tito e Grikŋizi opâ ruakicne juwec, eme e wâc sahacnao mahec eocte mi mucnembiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Eme nâŋere giemaŋko mitiŋic burecnezi raširâ, nâŋe Kristo Jesure erâ rambaŋ juhapene rucko honetâc-nâporâ Mosere kiŋaŋ qaqa bacnâpozo mueŋgopieŋ, ");
INSERT INTO kmg_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ŋic izi hâcne bawahac-nâpozo mupie nâŋe Biŋebiaŋzi ŋoŋerao bâbâsifucnehec ezacte moc mi docke-jarembeŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Eme ŋic micne jaŋe mârâc jaha iŋuc me iŋuc jumbiŋ, no irec manape hawarine moc mi eekac, Anutuzi iŋuc jaha sahackopec honec-nâpome bârâwiŋ mi eekac. Ŋic micne jaŋe hâcne dâŋ furune mi šuhucke-narembiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Aricne, šiŋuc ine manambiŋ: Anutuzi Petoro ŋic mahec jaŋerao Biŋebiaŋ muiŋneocte mucnewec, iŋuc jaha no ŋic ma tâmiric jaŋerao muiŋnepere munarewec. ");
INSERT INTO kmg_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Ehuc Petoro aposolo gie-ticne baha bafickeme fârinehec ewec, iŋuc jaha no baficnume bape fârinehec jaha wâc ewec. ");
INSERT INTO kmg_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Eme Wofuŋ e gie tahacke-narewec, i Jakobo, Kefa â Johane jaŋe Jesure kikefuŋ guru jaŋere jâcne jumbiŋzi mana tararâ no â Banaba âgo bacnâfohuc menâhecko bambiŋ, erâ nâhe qâpuc jaŋerao gie bahapere jaŋe jaŋac ŋic mahec jaŋerao baniŋte mumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Erâ hapetacfâc-jeŋic ehâmo-jarenaŋte irec sawa nazambiŋ. Eme no irec dâŋ hâcne šoɋac erâ muekopac. ");
INSERT INTO kmg_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Eme Kefazi Antiokia haeo warerâ wiac babahacnehec eme honerâ maiqanšaŋ jaha âzâcnepo. ");
INSERT INTO kmg_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","E qanaŋ qâpuczi opâ ruac jaŋehec nânâ wirec nâwec. Ehame Jakobore ŋicfâc fisipie honec-joparâ mahec jaŋere hâwickeme qâpuckonec opâ ruac bâtâc bajarerâ hone takirec-jopawec. ");
INSERT INTO kmg_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Erâ âkeac ehuc ra rowec ware rowec eme Judaŋic gâcne bafickepie Banaba jaŋerao šuhuckerâ sâc ijaha ewec. ");
INSERT INTO kmg_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Eme Biŋebiaŋte hata fâretiŋ mi âtepie honec-joparâ ŋic gâcne jaŋere maio Kefa šiŋuc âzâcnepo: “Go Judaŋiczi Judaŋic nâŋâcne eebapao mâcne, qâpuc jaŋere eebapao eekic, izi wemocte qâpuc jaŋe Judaŋic nâŋâcne eebapao eniŋte muekic?” ");
INSERT INTO kmg_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Nâŋâc qâpuc kosa jujune jaŋe iŋucne mi fuambeŋ, Judaŋic fuambeŋ. ");
INSERT INTO kmg_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","Erâ ine šiŋuc manaŋgopeneŋ: Ŋiczi sâcmutâc dâŋ reŋkehuc kiŋfâsâc eene mi fokac. Eme Kristo e sâcmutâc dâŋ rereŋkere mâcne, mamanasiŋ-nâŋecte erâ kiŋfâsâc bâcnâpoocte, nâŋâc wâc Jesu Kristo manasiŋkeeŋgopeneŋ. Sâcmutâc dâŋte gie bahuc moczi moc kiŋfâsâc eene mi fokac. ");
INSERT INTO kmg_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Eme Kristorao qohotahuc kiŋfâsâc ezo mueŋgopeneŋzi sifu sâqocne baeŋgopeneŋko weniŋuc muzo? I Kristozi sâqocnere qafeŋ-nâpoekac me? Aricne, iŋuc mi fokac. ");
INSERT INTO kmg_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Á wiac duckepo i mocwâc heɋârepemu, ine jâmbomac qaqatara ŋic epemu. ");
INSERT INTO kmg_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Á sâcmutâc dâŋzi nume hâmocnepo i Anutu jucnepemurâ epo. ");
INSERT INTO kmg_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","No Kristohec maripoŋko nukicne. Eme ši juekopac i no nahacne mâcne, Kristozi maŋnaneo juekac. Sahachec juju i juekopac, erâ Anutu Ŋokâ-ticne manasiŋkehuc e sawa jucneekopac. Eki hâcne maŋjauŋ enarehuc juju-ticne nore due bawec. ");
INSERT INTO kmg_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","No Anutu aki anonoc-ticne mi qâsuakopac. Sâcmutâc dâŋ reŋkehuc kiŋfâsâc eene fozacko Kristo e maŋgâŋko hâmowec ezac. ");
INSERT INTO kmg_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","O Galata ŋic mutucne¡ Ŋoŋe mozi maŋ bâsifuc eŋarewec? Jesu Kristo maripoŋko qakicne ere hawari ŋaza ŋowatuc epe šâŋe fâri-ŋeŋiczi honembiŋ i¡ ");
INSERT INTO kmg_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Wiac mocjahare wio-ŋarepe nazaniŋ: Mâro rombiŋ i weniŋuc ehuc rombiŋ? Sâcmutâc dâŋ reŋkehuc rombiŋ, me miti manarâ mamanasiŋhec ehuc rombiŋ? ");
INSERT INTO kmg_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Maŋmutuc wemocte eŋgopieŋ? Mârore hata fuŋkerâ âtembiŋzi juju raŋɋare hatao rašiŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Wiac fekicne sâko i maŋgâŋ fua-ŋarewec me? ­ jâmbomac fârimâc ewecko. ");
INSERT INTO kmg_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Mâro ŋarehuc wiac tâpirihec ŋoŋerao eekac, eki sâcmutâc dâŋ rereŋte me mamanasiŋ-ŋeŋicte eŋareekac me? ");
INSERT INTO kmg_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Abraham e iŋuc hâcne ecnekicne. E Anutu manasiŋkeme kiŋfâsâc mucnewec. ");
INSERT INTO kmg_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Irec šiŋuc mananiŋ: Mamanasiŋhec jaŋe Abrahamte ɋâricfâc fârine. ");
INSERT INTO kmg_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Ŋic qâpuc jaŋe Anutu manasiŋkepie kiŋfâsâc bacjopaocmu, irec hâcne mârâc jaha manasuhuc Abrahamte Biŋebiaŋ dâŋ šiŋuc mume miti papiao qâreŋkembiŋ: “Qâpuc guru jaŋe gore jambuŋko raši-fâreniŋmu.” ");
INSERT INTO kmg_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Irec hâcne, Abrahamzi mamanasiŋ hata âtewec ijaha âteniŋmuzi ere jambuŋko rašiniŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Á sâcmutâc dâŋte giezi fosiŋ-jeŋic eha juniŋmu jaŋe ine sâwechec eniŋmu. šiŋuc hâcne qâreŋkekicne fokac: “Sâcmutâc birio dâŋ forakac i moc mi qâsuazo. Moc e qâsuaocmuzi sâwec hotâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Sâcmutâc dâŋte maŋnao juhuc Anuturao kiŋfâsâc eene mi fokac, i dâŋ šizi mujaŋgeŋkekac: “Mamanasiŋte erâ biaŋkekicnezi juju hotâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Sâcmutâc dâŋko ine mamanasiŋte moc mi mukicne. Ine šiŋuc mukicne: “Giene bafâreocmuzi juju hotâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Dâŋqâreŋ moc šiŋuc fokac: “Ŋic jâcko ɋetic-jopakicne jaŋe sâwecte biŋe.” Eme Kristo e nâŋâcnere iŋuc hâcne erâ sâwec hotâckewec, ehuc sâcmutâc dâŋte sâwec i bâsue-nârewec. ");
INSERT INTO kmg_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Eme irec Jesu Kristore erâ Abrahamte jambuŋzi ŋicne ŋicne jaŋerao sâcne raocmu. Eme Mâro biŋe qanârekicne ine mamanasiŋhec erâ ronaŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Âgofâc, no wiac omanao sâc hehuc mupe: Ŋic moczi hâmohuc merâfâc-ticne biŋe qajareocmu, i moczi qâsuarâ fainao dâŋ moc mi šuhuckeocmu. ");
INSERT INTO kmg_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Eme miti merâfâc i Abraham â ɋâric-ticne biŋe qajactekicne hâcne. Ɋâricfâc-ticne bocjaha jaŋere mi mukicne, mocjahare mukicne Kristo hâcne. ");
INSERT INTO kmg_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","No kecšiŋucte mukopac: Anutuzi mârâc jaha miti merâfâc irec biŋedâŋ muwec, ehame šâhecko jara 430 tarame sâcmutâc dâŋ mufuawec, eme sâcmutâc dâŋ šâhec mufuakicne izi wemocko biŋedâŋ mârâc mukicne qame wahaocmu. ");
INSERT INTO kmg_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Miti merâfâc i sâcmutâc dâŋte erâ rorone eme muzac ine biŋedâŋte erâ rorone i arictac ezac. Anutuzi ine miti merâfâc i katucmâc-ticnere erâ Abraham biŋe qacnewec. ");
INSERT INTO kmg_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Hâc, eme sâcmutâc dâŋ wemocte mukicne? I qaqatarare mufuakicne, erâ fofo sanaŋ foocte mâcne, Abrahamte ɋâric biŋedâŋ rune fuame rârieocte mukicne. Sâcmutâc dâŋ i aŋelo miczi mukicne â ŋicwirec ere meo râekicne. ");
INSERT INTO kmg_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Ŋicwirec moczi ŋic mocjahare mâcne, bocjaha jaŋere qâqâhâc domaocmu. Anutu eki ine mocjaha. ");
INSERT INTO kmg_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Eme sâcmutâc dâŋzi Anuture biŋedâŋ âkehockeocmu me? Iŋuc aricne. Sâcmutâc dâŋzi ŋicmaŋ mi heɋâreocmu. I eene eme muzac, ine jâmbomac sâcmutâc dâŋte erâ kiŋfâsâc ee i fuazac. ");
INSERT INTO kmg_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Ŋic mâmâc sasawa sâqocnere niŋgiŋko jueŋgopeneŋ, fuŋne-nâŋec iŋuc hâcne miti papiao mufuakicne. Eme irec hâcne Jesu Kristo manasiŋkehuc mitihec erâ biŋedâŋte fârine ronaŋmu, i sawa fokac. ");
INSERT INTO kmg_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Judaŋic nâŋâc mârâc jaha mamanasiŋ tâmiric juhapene sâcmutâc dâŋzi kâpâcwâru bacnâpome niŋgiŋko fokuhapene mamanasiŋte biŋedâŋzi fua tâcnewec. ");
INSERT INTO kmg_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Eme irec sâcmutâc dâŋzi bâbâtiŋ-nâŋec erâ Kristorao râec-nâpowec, i mamanasiŋhec erâ kiŋfâsâc enaŋte iŋuc ekicne. ");
INSERT INTO kmg_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Nâŋâc mamanasiŋte hata fuame i âtepene bâbâtiŋte niŋgiŋ tâcnewec. ");
INSERT INTO kmg_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Eme ŋoŋe Kristo Jesu manasiŋkeŋgopieŋte šeŋgoma Anuture naru motecfâc embiŋ juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Miti Opâ rua-ŋarehuc Kristorao šuhuc-ŋopakicne ŋoŋe mâmâc sasawa Kristozi ŋaqi-ŋeŋic ehame hepie huwec. ");
INSERT INTO kmg_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Eme irec Judaŋic â Grikŋic, fekicne â wahakicne, ŋic â ŋokac, bârâwiŋ juju i tarame ŋoŋe mâmâc sasawa Kristo Jesurao sâc mocjaha embiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Ŋoŋe Kristore biŋe embiŋzi Abrahamte ɋâricfâc fârine juŋgopieŋ, erâ biŋedâŋte sâcko merâfâc-ticne bajuniŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Moc šiŋuc mupe mananiŋ: Motec ɋiene moc e mamac hâmocnere merâfâc raucke-bipiehuc sifu kiŋaŋ motec hawari juocmu. ");
INSERT INTO kmg_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Ehame wawa rau â âgo tofazi merâfâc qâzuckerâ bacne juhapie dameŋ mamaczi bawec i maickeocmu. ");
INSERT INTO kmg_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Nâŋâcne sâc ijaha fokac. Mârâc jaha maŋzi ɋiene juhuc mâreŋte wiac omanere kiŋaŋ qajumbeneŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Eme šâhecko dameŋ bakicne i qosackeme Anutuzi Ŋokâ-ticne soreme ŋokackonec fuawec â sâcmutâc dâŋte kiŋaŋ qawec. ");
INSERT INTO kmg_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","Ine nâŋâc sâcmutâc dâŋte niŋgiŋkonec goroŋ-nâpome Anuture naru motecfâc enaŋte iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Eme ŋoŋe naru motecfâc-ticne eŋgopieŋte Anutuzi Ŋokâ-ticnere Mâro maŋnâŋecko soreme hurâ šiŋuc wirâ wâwâsic eekac: “O Mamac biaŋ.” ");
INSERT INTO kmg_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Irec go kiŋaŋ qaqa-ticne mâcne, motec-ticne juekic. Erâ motec-ticne juhuc Anutu katucmâc-ticnere erâ merâfâc rune wâc juekic. ");
INSERT INTO kmg_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Ŋoŋe mârâc jaha Anuture kâuc bahuc nemu, Wofuŋ fârine mi jujune, jaŋe kiŋaŋ qajare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Eme šâhec Anutuzi hone šâŋitac eŋareme ŋoŋe e wâc hone tarambiŋ. Ehame wiac tâpiri tâmiric â fârimâc i wemocte mocwâc maickehuc kiŋaŋne qaŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Ehuc hombaŋ fuŋne fuŋnere manapie fârine eme ŋeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Gie-nanezi ŋoŋerao fârimâc ezacte mana mezac boc eekopac. ");
INSERT INTO kmg_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Âgofâc-nane, no numu-ŋarehuc mupe: No ŋoŋere sâc epore ŋoŋe nore sâc enšepieŋ. Ŋoŋe ši juwarehuc wiac hehesicne moc mi enarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","Ŋoŋe manaŋgopieŋ, no mârâcko huc šâic enarehame Biŋebiaŋ ŋazapo. ");
INSERT INTO kmg_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Eme sahac dodoc mâretec enareme ŋoŋe nore sifu tatakicne mi eŋarewec â mi mamakâc-ŋopawec. Aricne, ŋoŋe honecnupie Anuture aŋelo tinac epo, opoŋ, Kristo Jesu tinac epe hefârecnumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Joi, dameŋ ira mu šeri embiŋ i weniŋucte omaekac? Ŋoŋe šâŋe hândâŋ-ŋeŋic unuckerâ no nanarene fome muzac enšapiŋ, i jâmbomac manahuc mukopac. ");
INSERT INTO kmg_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Eme dameŋ šiŋuczia dâŋ fârine ŋazape honecnupie râsi-ŋeŋic ekopac me? ");
INSERT INTO kmg_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Ŋic gâcnezi ŋoŋere harac baeŋgopieŋ i âke râwiŋ-nâpopie ŋoŋe jaŋere harac eniŋte manasuhuc eeŋgopieŋ. Ine hâcne sioc ehuc ŋoŋere harac baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Wiac biaŋnere erâ harac ee i biaŋne. Ine ŋoŋerao fârâ juhape sawa mâcne, dameŋ sâc epie biaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Naru motecfâc-nane, no ŋoŋere erâ gozi kicnuha šâic manapo, ijaha harierâ manakopac, erâ Kristore hawari ŋoŋerao fua tâcneocte šâic i mana rahuc jupemu. ");
INSERT INTO kmg_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","No ŋoŋere mana guruc boc ekopacte ŋoŋerao biac fârâ dâŋ mu hetikic ehuc ŋazazore enarekac. ");
INSERT INTO kmg_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Wio-ŋarepe nazaniŋ, sâcmutâc dâŋte kiŋaŋ qazo mueŋgopieŋzi irec papia wose manac mi eeŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Ira hâcne šiŋuc qâreŋkekicne: Abrahamte ŋokâ jajahec fuapic, moc i kiŋaŋ naruzi rowec â moc i ŋonâŋzi rowec. ");
INSERT INTO kmg_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Eme kiŋaŋ naruzi rowec e omanao fuawec, â ŋonâŋzi rowec e Anuture biŋedâŋte sâcko fuawec. ");
INSERT INTO kmg_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Eme dâŋ irec ŋifecne šiŋuc fokac: Ŋokac jahe mitire šâšâfic jajahec irec sâsâcne epic. Ʒâšâfic moc Sinai tikio ekicne, ere kikefuŋzi ine kiŋaŋ qaqa embiŋ, eme irec sâsâcne Hagazi ewec. ");
INSERT INTO kmg_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Haga i Sinai tiki, Arabia mâreŋko ŋekac, irec šâŋe moc. Á Jerusalem hae i Sinai tikihec sâcjekic mocjaha ekopirec, ere kikefuŋ jaŋe kiŋaŋ qaqa jaha wâc eŋgopieŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Á Jerusalem hae faic ŋekac izi Sara ere sâc, hae izi hâcne neŋgoc jâmbâŋ-nâŋec ekac. ");
INSERT INTO kmg_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Dâŋqâreŋ šiŋuc hâcne fokac: “Ŋokac hufiŋne, motec mi roro go bubiaŋ manazemec, gozi mi kicguekac go šeri ehuc kiwaezemec. Ŋokac ŋichec e ɋâric afecne fuacnehapie me sawanezi naru motec bocjaha rocjopaocmu.” ");
INSERT INTO kmg_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Âgofâc-nane, ŋoŋe Isakare sâc erâ biŋedâŋte fuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Eme mârâc jaha motec omanao fuakicnezi Mârore dâŋte fuakicne e râsi ecnewec, sâc ijaha miŋecgac fokac. ");
INSERT INTO kmg_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Eme miti papiao dâŋ weniŋuc fokac? “Kiŋaŋ naru e ŋokâ-ticnehec jâpec-jofatec ranic, kiŋaŋ narure ŋokâzi ŋonâŋte ŋokâhec merâfâc mi rauckezejec.” ");
INSERT INTO kmg_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Âgofâc-nane, nâŋâc kiŋaŋ narure ɋârifâc aricne, nâŋâc ŋonâŋte ɋâricfâc. ");
INSERT INTO kmg_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Niŋgiŋ tâmiric junaŋte Kristozi goroŋ-nâpowec. Irec gâcnezi niŋgiŋko râec-ŋoparâ kiŋaŋ qaqa eniŋte muŋarepie qikiŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","No Paulozi ŋazape mananiŋ, ŋoŋe sahac-ŋeŋicko ma bapie Kristozi ŋoŋerao wiac omane tinac eocmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Mocwâc harierâ ŋaza-jâmbâŋkepe, moc e sahac-ticnao ma baocmuzi sâcmutâc dâŋ gâcne sâko mâmâc hâpo-fâreme sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Sâcmutâc dâŋ reŋkehuc kiŋfâsâc ezo mueŋgopieŋ ŋoŋe Kristohec šâšâfic embiŋ i tâcnekac â aki anonoczi ŋoŋerao fârimâc ekac. ");
INSERT INTO kmg_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Nâŋe ine Mârorao ŋesiŋnehuc mamanasiŋte erâ kiŋfâsâc ee bâfuanaŋte irec mamanac jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Kristo Jesurao fisirâ mahec juju â ma tâmiric juju irec mâmâc jaha fârimâc muzo, mamanasiŋte qâreŋ maŋko fuame irec mocjaha fârine muzo. ");
INSERT INTO kmg_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Ŋoŋe mitire hata sâcne fuŋkerâ âtembiŋ. Âtehapie mozi aka heŋareme dâŋ fâri qizecne râpeckeŋgopieŋ? ");
INSERT INTO kmg_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Hefârec-ŋopawec eki irec esoc qafeŋ mi eŋarekac. ");
INSERT INTO kmg_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Qowi hâhâtâcne pitic siŋgaŋ gaucnezi nânâ sicko hurâ mâmâc sâcke-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Erâ ŋoŋe nore dâŋ mi qikiŋneniŋmu, i Wofuŋte erâ manabâc tâmiric mukopac. Á ŋic izi me izi maŋ bâsifuc eŋareocmu, e kiŋ irec okacne fisicneocmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Âgofâc, no ine mahec eniŋte ŋic jazazapo muzac, wemocko fific guguriŋ moc enarenšapiŋ? Iŋuc jazazapoo maripoŋte mamana gâpâre i mâmâc omaezac. ");
INSERT INTO kmg_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Maŋqaqa eŋareeŋgopieŋ ŋic iŋucnezi sahac-jeŋic hetâc qâtâcnenšapiŋ me! ");
INSERT INTO kmg_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Âgofâc-nane, ŋoŋe niŋgiŋ tâmiric juniŋte hefârec-ŋopakicne, erâ niŋgiŋ tâmiric jujuzi âki eha sahacte dâŋ reŋkeniŋte mâcne, maŋjauŋko kiŋaŋ qaqac eniŋte irec hefârec-ŋopakicne. ");
INSERT INTO kmg_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Irec hâcne sâcmutâc dâŋte qâqâhâc šiŋuc mukicne: “Gahacnere egareekac, sâc ijaha âgogere egarezejec.” ");
INSERT INTO kmg_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Ŋoŋe ine miczi nânâc ehuc kikic qaqac boc erâ oomaec enšipiŋte uŋ ŋazakopac. ");
INSERT INTO kmg_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Erâ ine šiŋuc mukopac: Ŋoŋe Mârore tâpirio siŋkerâ junšepieŋ, iŋuc ehuc maŋraŋɋare sasec gie mi baniŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Maŋraŋɋare aŋaczi hâcne Mâro kisueekac â Mârozi maŋraŋɋa kisueekac, eme jahe hâcne rârâsi epire ŋoŋe wiac ezo mueŋgopieŋ i sâcne mi afeckerâ eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Mârozi jowa baafec eŋareme ine sâcmutâc dâŋzi ŋicbomboŋ mi eŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Maŋraŋɋare gie i soŋsoŋko mi foekac, i šiŋuc fuaekac: Boe sau, mamakâc, nâ areŋ, ");
INSERT INTO kmg_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","nemu araŋ babajare, hafec qaŋgec, rârâsi, sosopec, iiŋguuŋ, kimbeŋ, hehefaric, fâfâuc, rârâwiŋ, ");
INSERT INTO kmg_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","mu kâroŋ, opâ momori me bec qowi âmbâŋ nânâ, erâ wiac gâcne. Wiac iŋucnere mârâc jaha ŋazapo erâ ši mocwâc ŋazape: Sâqocne i baniŋmuzi Anuture uucmaŋko mi rašiniŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Mârore fârine ine kecšiŋuc fuaekac: Maŋjauŋ, bubiaŋ, wama, bumâteŋ, buafec, buuruc, ââgo sanaŋ, ");
INSERT INTO kmg_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ruaine, maŋzi sowa juju. Mârore fârine hâcne irec aka mi fokac. ");
INSERT INTO kmg_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Kristo Jesure biŋe jueŋgopieŋ jaŋe juju raŋɋa-jeŋic sasec â sâqocnere andachec i maripoŋko qapie omaewec. ");
INSERT INTO kmg_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Mârore tâpirire jueŋgopeneŋko Mârore hata jaha âtenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Sahaczi fecko fec ehuc hehesuac mi enšepeneŋ, erâ wâc iiŋguuŋ mi eec enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Âgofâc-nane, ŋic moczi dockerâ bahac bâfuame ŋoŋe Mâroheczi bumâteŋ erâ iŋucne mu bâtiŋ ecnenšepieŋ. Ehuc go gahac eesâicko pârâckezicte rucge bazemec. ");
INSERT INTO kmg_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Wiac kihuhuŋ-ŋopaekac i nowac gowacroŋ ehuc babaficko banšepieŋ. Iŋuc ehuc Kristore sâcmutâc dâŋ sâcne reŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Ŋic moc e wiac fârine moc mi ehuc e jahacnere maname fefene eocmu, iŋucnezi maŋticne fagac ecnekac muzo. ");
INSERT INTO kmg_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Irec moc e jahacne juju bapa hone šâŋitac ezejec. Eme šeridâŋ i e jahacnere erâ fuaocmu, ŋic mocte erâ mâcne. ");
INSERT INTO kmg_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Giere ŋemâc kâdoc qakicne i ru sâc areckezo. ");
INSERT INTO kmg_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Miti ŋaza qazuc eeŋgopieŋ ŋic i jaŋe wiac fuŋne fuŋne boki bahuc jare gumec enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Anutu mu qâtimbuc ecnepie mâc foocmu, iŋuc moc mupie. I aricne jâmbâŋ, ŋic moc gie baocmu e irec fârine juku ijaha roocmu. ");
INSERT INTO kmg_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Moc e maŋraŋɋare gie baocmu, e juku maŋraŋɋa-ticnere fârine sisipiric bâfuaocmu, â moc e Mârore gie baocmu, e juku Mârore fârine juju sanaŋ bâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Wiac biaŋne i rorokac tâmiric enšepeneŋ, eme mi betaŋkenaŋmuo juku dameŋ-ticnao mâriri bâfuanaŋmu. ");
INSERT INTO kmg_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Irec dameŋ-nâŋec fohame ŋic sasawa ehâmo-jarenšepeneŋ. Ehuc mitio âgofâc-nâŋec wiac bafehuc ejarenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Ŋoŋe qâreŋ sâko ši honeniŋ, no nahacne mezi qâreŋke-ŋarekopac. ");
INSERT INTO kmg_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Ŋic gâcne jaŋe sahaczi miti hawari biaŋ erâ ŋoŋe sahacko mahec eniŋte fotarie-ŋareeŋgopieŋ jaŋe Kristo maripoŋ-ticnere erâ fific guguriŋ faio fenšipiŋte iŋuc hâcne eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Sahacko mahec embiŋ ŋic i jaŋe jaŋac wâc sâcmutâc dâŋ mi reŋkeeŋgopieŋ. Jaŋe mâc ŋoŋe mahec erâ jaŋerao šuhuckepie sahac-jeŋic muteŋkeniŋte manasueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","No ine wiac irec mi Irec mâcne, Wofuŋ-nâŋec Jesu Kristo maripoŋ-ticnere biŋedâŋ irec mocjaha mumuteŋ bajuekopac. Ere erâ mâreŋkonec wiaczi maripoŋko hâmo-narewec, â no iŋuc jaha maripoŋko mâreŋkonec wiac hâmocnepo. ");
INSERT INTO kmg_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Sahacko mahec juju me ma tâmiric juju izi fârine aricne, juju ɋâricne izi mocjaha fârine ekac. ");
INSERT INTO kmg_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Gaŋ rukec ira hâcne domaeŋgopieŋ sâc ŋoŋerao wama â buuruc fotâcnerâ fozejec, erâ Anuture Israe ŋic jaŋerao mâmâc. ");
INSERT INTO kmg_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Ʒi moczi moc neneŋ gie mocwâc mi narezejec. No Wofuŋ Jesure râfu qâreŋ sahac-naneo fome bajuekopac. ");
INSERT INTO kmg_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Âgofâc-nane, Wofuŋ-nâŋec Jesu Kristore aki anonoczi maŋŋeŋicko fozejec. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Paulo no Anuture micte Jesu Kristore aposolo epozi Efeso haeonec mitiŋic, Kristo Jesu manasiŋkeeŋgopieŋ hâcne, ŋoŋere papia ši râekopac ");
INSERT INTO kmg_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnera fozejec. ");
INSERT INTO kmg_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Wofuŋ-nâŋec Jesu Kristo ere Anutu â Mamac, eki sambâŋkonec miti jambuŋ-ticne fuŋne fuŋne Kristore erâ nâre tahac ewecte mumbiaŋkenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Eki mârâc jaha jâmbâŋ mâreŋte hobeteŋne mi fuahame mai-ticnao maŋfuru â bahacmâc junaŋte Kristore erâ mana wosâc enârewec. ");
INSERT INTO kmg_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","E qanaŋ maname fowecte hâcne Jesu Kristore erâ maŋjauŋ enârehuc naru motecfâc-ticne erâ junaŋte buafec-ticnere mupaŋke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","E joroc Ŋokâ-ticnere erâ aki anonoc biaŋ-ticne tahac-nâpowecte muteŋ bâteŋ ecnenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Jesu e socticnezi kitâc-nâpowecte sâqocne bâbâtâmire fua-nârewec, i aki anonoc-ticnere šâkâŋ fokac irec sâc hâcne. ");
INSERT INTO kmg_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Eme šâkâŋ-ticnao maŋɋârâŋ â mamana fâri bâmâckehuc qoŋgiŋke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Ehuc maŋbuc-ticnere dâŋ, qanaŋ maname biaŋkeme šiŋuc âkendâŋnewec i mujaŋgeŋke-nârewec: ");
INSERT INTO kmg_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","“No guriŋne bahape dameŋ maŋkepo i qosackeme Kristozi wiac sasawa, sambâŋko mecne mâreŋko mecne, qâturehuc irec fuŋqizecne ezejec.” ");
INSERT INTO kmg_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Ere erâ, wiac sasawa maŋticnere mupaŋkerâ baekaczi mârâc jaha hone wosâec-nâporâ miti merâfâc rauckenaŋte munârewec. ");
INSERT INTO kmg_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Eme irec Kristore mamanac jumbeŋ jueŋgopeneŋzi Anutu šâŋe rara-ticnere mumuteŋfâc erâ junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Eme ŋoŋe iŋuc jaha dâŋ fâri qizecne, bâbâpiaŋ-ŋeŋicte Biŋebiaŋ hâcne, ro maŋ ehuc Kristo manasiŋkepie Tiri Mâro qanaŋ biŋe qanarekicne i ŋareme maqâreŋhec embiŋ. ");
INSERT INTO kmg_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Sambâŋko huhure biŋe-nâŋec fokac, irec šâšâficne Mâro nârekicne. Eme Anutu šâŋe rara-ticnere mumuteŋ sâko fuaocte biŋefâc-ticne nâŋâcnao Mârozi bâbâpiaŋ gie fuŋkewec i batarazokac. ");
INSERT INTO kmg_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Eme ŋoŋe Wofuŋ Jesu manasiŋkeeŋgopieŋ â mitiŋic âgofâc-nâŋec maŋjauŋ ejareeŋgopieŋ, irec biŋedâŋ manapore ");
INSERT INTO kmg_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ŋoŋere dameŋ sâc manasuhuc Wofuŋ daŋge mumuteŋ ecneekopac. ");
INSERT INTO kmg_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Ehuc ŋoŋere šiŋuc numuekopac: Wofuŋ Jesu Kristo ere Anutu, eri tatamac Mamac hâcne, eki Mâro ŋareme izi maŋɋârâŋhec bacŋoparâ Wofuŋte fuŋne mufua-ŋareme mana taranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Erâ maŋšâŋe-ŋeŋic bâtâcneme ine Wofuŋzi rocŋopahuc sambâŋ šeŋaŋ biŋe qaŋarewec, irec manapie fârine ezejec, â fuŋfuŋfâc-ticne ŋoŋe huhure šâŋe rara biaŋ kadahe ŋarewec, irec wâc manapie fârine ezejec, ");
INSERT INTO kmg_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","â mamanasiŋhec nâŋâcnao tâpiri soka makakicne i teqâ saki-ticnezi gie baekac sâc bâfuawec, irec iŋuc jaha manapie fârine ezejec. ");
INSERT INTO kmg_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","Tâpiri irec fuŋne Kristo hâmockonec bâɋârerâ sambâŋko mefâre-ticnao râehuc bataniŋkewec. ");
INSERT INTO kmg_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Ehuc kia gawamaî â ŋicwofuŋ â fekicne fuŋne fuŋne jaŋere femicne sâko râewecte mâreŋko â sambâŋko šâŋe biŋe fokac izi gâkowakac, dameŋ šiŋucziare sawa mâcne, iŋuc fohuc juocmu sanaŋ. ");
INSERT INTO kmg_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Erâ wiac sasawa maŋfuŋnao heteckehuc kike-ticnere rurumaŋko guruc-jopahuc qizec-jeŋic eocte âkendâŋnerâ kikefuŋ gurufâcne jaŋerao râewec. ");
INSERT INTO kmg_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Eme jaŋe me kikefâc-ticne ehapie ŋihe umbiŋ ejarehuc fofotâc juhuc wiac sasawa sâcke raekac. ");
INSERT INTO kmg_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Ŋoŋe mârâc jaha sindaŋ hârindaŋ ehuc hâmocne jujumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Ine mâreŋte juju hata maŋnao juhuc saware tâpiri irec ŋicbomboŋ erao qohota jumbieŋ. Ere mârozi hâcne dameŋ šiŋuczia wâc qaqatara ŋic jaŋerao gie baekac. ");
INSERT INTO kmg_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Nâŋâc mârâc jaha jaŋere sâc jaha jufârehuc maŋraŋɋa-nâŋecte aŋac bâjâpembeŋ. Ehuc sahac-nâŋecte â maŋ mamanasu-nâŋecte dâŋ reŋkehuc gâcne jaŋe iŋucne kimbeŋte biŋefâc embeŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Anutu eki buuruc-ticne bocjaha fokacte maŋjauŋ kâcɋene enârehuc ");
INSERT INTO kmg_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","qaqatara-nâŋecte erâ hâmokicne nâŋâc Kristohec mâmâc bâɋârec-nâpowec. Manaŋgopieŋ, katucmâc-ticnere erâ bâpiaŋ-ŋopawec ŋoŋe. ");
INSERT INTO kmg_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","E Kristo Jesuhec bâɋârec-nâporâ ehec mâmâc sambâŋte jujuo ŋec-nâpowec hâcne. ");
INSERT INTO kmg_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","i nacnere mocko šiŋuc fuaocte ewec: Aki anonoc-ticnere rowaŋ sâko i Kristo Jesuo maŋuruc qanârehuc qaratie-nâreocmu. ");
INSERT INTO kmg_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Manaŋgopieŋ, e aki anonoc eŋarehuc mamanasiŋ-ŋeŋicte erâ bâpiaŋ-ŋopawec, i ŋaŋacnere mâcne, Anutu buafec-ticnere iŋuc eŋarewec. ");
INSERT INTO kmg_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Mo gie mo bambiŋte iŋuc eŋarezac, i aricne. Irec sahac mumuteŋ moc mi fuazejec. ");
INSERT INTO kmg_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Nâŋâc Anuture metofafâc, eki Kristo Jesuo bâfuac-nâpowec hâcne, erâ hata biaŋne Anutuzi hâcne mušâwe-nârewec i âtehuc junaŋte munârewec. ");
INSERT INTO kmg_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Ŋoŋe mârâc jaha qâpuc jujumbieŋ, irec manasuhuc junšepieŋ. Eme dameŋ ira ma tâmiric juhapie Judaŋic jaŋe sahac-jeŋicko maheczi šâgu muŋare jumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Dameŋ ira Kristo tâmiric jumbiŋ, erâ Israe ŋic jaŋe hae fâri juhapie ŋoŋe mafa jumbiŋ, â jaŋe fuŋfuŋfâc-ticne bacjopame biŋedâŋ-ticne bajuhapie ŋoŋe šoŋifecfâc-ticne erâ metariŋ jumbiŋ, erâ maŋzi wiac fârine moc mi worickehuc Anutu tâmiric hâcne jumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Dameŋ šiŋuczia ine ŋoŋe kâteo jumbiŋzi Kristo Jesurao šuhuckehuc Kristo socticnere erâ haeo fisimbiŋ jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","E jahac wama-nâŋec juekac. E ŋic jâcne jajahec ŋondeŋ-jekicko rârâsizi aka sanaŋ fowec i qâropiehuc, mocjaha bacjofawec. ");
INSERT INTO kmg_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Ine sâcmutâc dâŋqâhâcko bâtâc â mumuac bocjaha mukicne i e jahacne sahac qaisockehuc bârâriewec. Ehuc ŋic jâcne jajahec jahere dodoma tacko ŋic ɋâricne mocjaha ine e jahac fuarâ domahuc wama bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","E maripoŋlo hâmowecko ŋic jâcne jajahec fâri ombâŋ mocjahao qâturec-nâpohuc Anutuhec miriŋ bacnâpowec, ehuc rârâsi qame wahawec. ");
INSERT INTO kmg_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Erâ fisirâ kâteo jukicne ŋoŋe â haeo jukicne nâŋe mâmâc wamare biŋedâŋ nâzâme manambeŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Erâ wâc hata bâšâwe-nârewecte nâŋâc Mâro mocjaha rauckerâ Mamactao fisieŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Eme irec dameŋ šiŋuczia mafa â jaba mocwâc mi jueŋgopieŋ, ŋoŋe mitiŋic gâcne jaŋehec hae fâri â Anuture kikefuŋfâc embiŋ juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Ŋoŋe aposolo â porofete jaŋe wâtuŋ ŋokacne ehuc decŋopapie doma raŋgopieŋ, â Jesu Kristozi wâtuŋ ŋicne ekac. ");
INSERT INTO kmg_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Erao ŋicne ŋicne šuhucke itic epene Wofuŋte furu ufuŋ fua feekac. ");
INSERT INTO kmg_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Mârozi ŋoŋe iŋuc jaha erao râe šuhuc eŋareme Anuture fic eŋgopieŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Eme Paulo no irec hâcne qâpuc ŋoŋere erâ Kristo Jesure kâpâcwâru ŋic epo jukopac. ");
INSERT INTO kmg_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Ŋoŋe nore manambiŋ, Anutuzi uruc jauŋ-ticnere erâ ŋoŋerao miti gie bapemurâ munarewec. ");
INSERT INTO kmg_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Munarehuc dâŋ soŋne mufua-narewec, dâŋ i hâcne biac bembeŋne qâreŋkepac, ");
INSERT INTO kmg_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ŋoŋe i wosehuc, no Kristore dâŋ soŋne maŋzi hone raruŋkekopac iŋuc sâcne mananiŋmu. ");
INSERT INTO kmg_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Dâŋ soŋne i mârâc jaha ŋic juwarembiŋ jaŋerao mi mufuakicne, tiri aposolo â porofete nâŋerao šâhec Mârozi mufuawec. ");
INSERT INTO kmg_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Dâŋ soŋne kecšiŋuc: Biŋebiaŋte fârine qâpuc ŋoŋe Judaŋic nâŋehec sâc mocjaha â guru mocjaha erâ Kristo Jesurao biŋedâŋ deŋkewec i mâmâc rauckerâ bajuniŋte mukicne. ");
INSERT INTO kmg_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Eme Biŋebiaŋ irec kiŋaŋ qaqa jupemurâ Anutuzi uruc jauŋ-ticnere erâ tâpiri sâko-ticnere fuŋne norao bataniŋkewec. Dâŋ soŋnere fârine Jesuzi bâfuawec ");
INSERT INTO kmg_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Kristorao mâriri sâko fofone fokac irec dâŋ soŋne qâpuc mutaniŋke-jarepemurâ irec gie biaŋ mitiŋic wawahane jâmbâŋ no hâcne munarekicne. ");
INSERT INTO kmg_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Dâŋ soŋne muraruŋkepere mukicne, i Anutu bapafâre e maŋbuc-ticnere dameŋne dameŋne baju warehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Ʒi ine Anutuzi kikefuŋ gurufâc-ticne nâŋâcnao maŋɋârâŋ-ticnere fârine qaratiekume qâreŋne fuŋne fuŋne fuame sambâŋko ira fekicne â tâpirihec jaŋe wâc hone šâŋitac eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Anutu e mârâc jaha dameŋ tâmiricko maŋnezi dâŋ mupaŋkewec irec fârine hâcne Wofuŋ-nâŋec Kristo Jesu sorehuc bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Eme eki hâcne hata bâšâwe-nâreme e manasiŋkehuc hâhâwic tâmiric Anutu maickeeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Irec šiŋuc ŋazape mananiŋ: No ŋoŋere erâ fific guguriŋ faio jupe irec maŋŋeŋic mi wahazejec, aricne, ŋoŋe irec manapie eri qoqonaŋ-ŋeŋic ezejec. ");
INSERT INTO kmg_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Irec hâcne sambâŋko â mâreŋko ŋic guru sâc jueŋgopeneŋ ");
INSERT INTO kmg_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","nâŋâcne Mamac fârine e dieŋzi hecnehuc ŋoŋere erâ numucnehuc šiŋuc muekopac: ");
INSERT INTO kmg_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Anutu e hahaŋnehec sâkozi Mâro ecneme tâpiri bâfua-ŋareme maŋŋeŋiczi soka sanaŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Eme Kristo manasiŋkepie maŋŋeŋicko ŋeŋe juju ezejec. Eme ere maŋjauŋko gâtâ barâ qiŋ herâ domanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Ehuc mitiŋic gâcne sasawa jaŋehec mâmâc mitire fuŋne botâŋne, hâŋne otecne. i afeckerâ mana taranšepieŋ, ");
INSERT INTO kmg_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","erâ wâc Kristore maŋjauŋ, ŋic mamana jâuru-fâreekac, i sifu mana-hâmonšepieŋ. Ehame Anuturao maŋ mâriri fufusuc fokac izi bâfusec-ŋopazejec. ");
INSERT INTO kmg_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Tâpiri-ticnere fuŋne nâŋâcnao bataniŋkeekac Anutu hâcne, e wiac bapa-ticnezi nunumu-nâŋec â mamanasu-nâŋec siricke-fâreekacte ");
INSERT INTO kmg_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","kikefuŋko â Kristo Jesurao mumuteŋ-ticne mimiŋzi ɋâric šuhuckeme šuhuc fofehuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","No Wofuŋte kâpâcwâru ŋiczi faŋ qaŋarehuc ŋazape: Wiac fekicnere hefârec-ŋopakicne irec sâcko junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Ehuc maŋhuhuŋ â buuruc â bumâteŋ juhuc maŋjauŋko dedec ââsic enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Erâ Mâro e wamare muczi qâzuc-ŋoparâ dâtâc-ŋopawec, i qâtâcnenšipiŋte ruc babac ehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Fâri ombâŋzi mocjaha â Mârozi mocjaha erâ wâc sambâŋ šeŋaŋ mocjahare biŋe qaŋarehuc hefârec-ŋopakicne. ");
INSERT INTO kmg_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Ine hâcne, Wofuŋzi mocjaha, mamanasiŋzi mocjaha, Miti Opâzi mocjaha. ");
INSERT INTO kmg_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Erâ Anutu e Mamac wirec-nâŋec mocjaha, eki mâmâc sasawa qâhuc-nâpokac erâ maŋnâŋec sâc tâpiri sicne-nâreekac â mâŋnâŋec sâc ŋeŋe juju eekac. ");
INSERT INTO kmg_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Kristo e ŋicne ŋicne mitire kâdoc nârewec sâc bajueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Irec hâcne dâŋqâreŋ moc šiŋuc fokac: “E faic jâmbâŋ fehuc kâpâcwâru ŋic bacjopa rawec, e ŋic wiac tahac-jopawec.” ");
INSERT INTO kmg_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","“Faic fewec”, i mâc mi mukicne, mâreŋko juwic jâmbâŋ wahaweckonec risie fewec. ");
INSERT INTO kmg_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","E wahaweczia risierâ sambâŋne sambâŋne fotâcnerâ fewec, i sambâŋ â mâreŋ fusucmarâ jufâreocte fewec hâcne. ");
INSERT INTO kmg_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Erâ ekizia wâc ŋic gâcne aposolo râec-nâpowec, gâcne porofete, gâcne miti kiŋaŋ ŋic, gâcne lama guru jaŋere soŋaŋ â qaqazu, ");
INSERT INTO kmg_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","i mitiŋic ŋokac bašawiec-jopapene kikefuŋte kiŋaŋ qaqa gie bapie Kristore me kike fâri ombâŋ soka sanaŋ eocte ŋic iŋuc râec-nâpowec. ");
INSERT INTO kmg_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Iŋuczi iŋuc gie bakupene mamanasiŋ-nâŋec â Anutu ŋokâ-ticnere fuŋne mamana-nâŋec i niniweme maŋ mocjaha enšepeneŋ. Ehuc mitio sosoka-nâŋecte sâc mukicne i Kristore rowaŋkonec tâpiri fârehuc fua sokac eku ŋic kâcɋene erâ bâfuanšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Nâŋâc ɋiene hati mi ee sanaŋkerâ juhapene eeatuc ŋic jaŋe sioc enârepie gibioc dâŋ â mumusifuc-jeŋicte mâŋâŋzi ba bâsoriŋ â qac qârândiŋ moc mi enârezejec. ");
INSERT INTO kmg_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Aricne, nâŋâc dâŋfâri paŋšâic bajupene maŋjauŋ-nâŋeczi fua sawec ehame qizec-nâŋec Kristo erao šuhucke sanaŋkenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Erao šuhuckepene ruazi ŋeturec-nâporâ bândeŋ-nâpome ɋâɋâdoc erâ me sahac-ticne eeŋgopeneŋ. Ehuc tofafâc-ticne erâ tâpiri fonâreekac sâc gie bahuc maŋjauŋko soka sawec enaŋmu. ");
INSERT INTO kmg_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","No Wofuŋte maio ŋaza-jâmbâŋkepe: Ŋoŋe qâpuc, maŋ mamanasu-jeŋic wiac jawanere foekac, jaŋere sâc mi junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Jaŋe maŋjeŋic dapâc ekicnere mutuc â maŋsanaŋ erâ Anuture juju râpeckembiŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Eme maŋjeŋic šickeme nânâ qowire nâ areŋ ehuc sasec mamakâc fuŋne fuŋne takicmâc ebac eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Ŋoŋe ine juju iŋucne juniŋte Kristore fuŋne mi qazu-ŋarekicne. ");
INSERT INTO kmg_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Ŋoŋe fuŋne-ticne qazu-ŋarekicko Jesurao dâŋfâri kecšiŋuc fokac i hâcne manambiŋ: ");
INSERT INTO kmg_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Qâpuc juju râpeckerâ maŋraŋɋa-ŋeŋic burec ehuc sasecko sipirickeekac, i heunuckenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Erâ mâro manacnepie mamanasu-ŋeŋic heɋârehame ");
INSERT INTO kmg_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","maŋɋâri hepie huzejec. I hâcne Anuture hawari iŋucne tiŋne â furu jâmbâŋ bâfuakicne. ");
INSERT INTO kmg_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Irec ŋoŋe burec beherâ dâŋ jâmbomac sasawa nazaŋ gazaŋ enšepieŋ, nâŋâc qoqomâ efâreŋgopeneŋte. ");
INSERT INTO kmg_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Kimbeŋko mi sâqorenšepieŋ. Kimbeŋ aaric mi bajuhapie šoaŋ ŋeutuckezejec. ");
INSERT INTO kmg_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Erâ Sataŋ mi mana uruecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Fiuc rorozi fiuc qikiŋnerâ meticnezi gie šoɋac bahuc nânâ mafa bâfuarâ waha qaqane boki bajarezejec. ");
INSERT INTO kmg_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Dâŋ simbiŋne micŋeŋickonec mi wahazejec, dâŋ biaŋne sawa, ine dodopec eere hatane fuame mupie ŋic âgo bacjopazejec. ");
INSERT INTO kmg_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Anuture Tiri Mâro mi qaisockenšepieŋ, e hâcne roroc-nâpo dameŋko maqâreŋ-ŋeŋic eocte tahac-ŋopakicne. ");
INSERT INTO kmg_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Râsidâŋ, kimbeŋ aaric, mu ojowa, susurec, erâ wiac gâgâpâcne gâcne i ŋondeŋ-ŋeŋicko mi fuazejec. ");
INSERT INTO kmg_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Ŋoŋe ââgo erâ eehâmoc ehuc kiŋ bebehec enšepieŋ, Anutu e iŋuc jaha Kristore erâ kiŋŋeŋic behewec. ");
INSERT INTO kmg_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Ŋoŋe joroc naru motecfâcne juŋgopieŋzi Anutu sâckehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Erâ maŋjauŋhec junšepieŋ. Kristo e iŋuc jaha maŋjauŋ enârehuc nâŋâcnere erâ sahac-ticne qaisockerâ Anutu taha bâzi biaŋ ecnewec. ");
INSERT INTO kmg_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Boe sau, sasec mamakâc, buchâro, irec saŋuc wâc mitiŋic ŋoŋere ŋondeŋko mi fuazejec. ");
INSERT INTO kmg_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Dâŋ miminehec, mutucdâŋ, dâŋ simbiŋne, i epie sâqoreocmu. Daŋge mumuteŋ ine epie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ŋoŋe šiŋuc mana sanaŋkenšepieŋ: Boe sau ŋic â sasec mamakâchec â buchâro, nemu qaŋgec ŋic hâcne, jaŋe Kristo â Anutu uucmaŋ-ticnao ŋeŋe basaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Eatuc-ŋopahuc siocdâŋ ŋazapie manapie fârine mi ezejec. Sâqocne iŋucnere hâcne Anuturaonec okacne qaqatara ŋic jaŋerao fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Irec ŋoŋe mi bafic-jopanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Ŋoŋe mârâc jaha dapâchec jujumbieŋ, ši ine Wofuŋtao fisirâ tatamachec embiŋ juŋgopieŋ. Irec tatamacte ɋâricfâc erâ irec hawari junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Tatamacte fârine fuaekac i maŋbiaŋhec juju â tiŋne ju ju â jâmbomac dâŋ mumu. ");
INSERT INTO kmg_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Wiac ezo murâ ine Wofuŋzi maname biaŋkeocmu me mâcne, i qanaŋ mana wosâerâ enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Gâcnezi dapâcte wiac jawane epie mi qâsuec-jopanšepieŋ, aricne. Ŋoŋe irec tapa qararuŋkehuc qatara-jarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Wiac soŋsoŋko eeŋgopieŋ i mu bâuac epene miminehec jaha eocmu. ");
INSERT INTO kmg_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Wiac iŋucne tapane qararuŋkepene tatamaczi âeckeme fuaocmu. Eme tâtâc fuakac wiac izi wâc tatamac bâfuaocmu. ");
INSERT INTO kmg_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Irec hâcne šiŋuc mukicne: “Guŋ foekiczi faharec, â hâmockonec ɋârec, eme Kristozi batamaecguocmu.” ");
INSERT INTO kmg_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Ŋoŋe juju bapa-ŋeŋicte ruc bahuc junšepieŋ. Erâ mutuc matacne mâcne, maŋ mamanasuhec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Dameŋ šira sâqocnezi haŋ bawec fokacte dameŋ gâcne mi behehuc gie šoɋachec banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Maŋ tâmiric tinac mi junšepieŋ, Wofuŋzi gie muŋareekac i hone šâŋitac enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Waiŋ opâ wiacte âmbâŋ mi enšepieŋ, izi maŋ sisipiric gie. Mârore ine âmbâŋ enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Mârozi esoc-ŋopaocmu sâc gae mânec hehuc maŋ nareŋ gareŋ enšepieŋ. Á maŋŋeŋicko Wofuŋ gaezi â musizi mu šeri ecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Erâ Wofuŋ-nâŋec Jesu Kristore erâ dameŋ sâc Anutu Mamac wiac fuŋne fuŋnere daŋge mumuteŋ ecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Ŋoŋe Kristo araŋ bacnehuc micrereŋ eec efârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Ŋonâŋ ŋoŋe Wofuŋte rereŋfâc juŋgopieŋ iŋuc jaha ŋowefâc-ŋeŋic jaŋere junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Ŋowezi ŋonâŋte qizec ekac hâcne, iŋuc jaha Kristozi kikefuŋte qizec ekac, ehuc me sahac-ticnere bâbâpiaŋ wâc ekac. ");
INSERT INTO kmg_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Eme kikefuŋzi Kristore mic reŋkeekac, iŋuc jaha ŋonâŋ jaŋe ŋowefâc-jeŋic jaŋere mic dameŋ sâc reŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Ŋowe ŋoŋe ŋonâŋfâc-ŋeŋic maŋjauŋ ejarenšepieŋ. Kristo e iŋuc jaha kikefuŋ-ticne maŋjauŋ ecnehuc ere due bawec. ");
INSERT INTO kmg_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Erâ kikiruhucne â sâfânehec â wâc wiac gâcnehec juzacte mitidâŋzi opâ umbiŋkeha šurehuc jambuŋkerâ ");
INSERT INTO kmg_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ericke bâpiaŋ ecnerâ e jahacne biŋe furu â bahacmâc juocte mucnewec. ");
INSERT INTO kmg_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Eme ŋowe jaŋe jaŋacne sahac jauŋ bacneeŋgopieŋ, sâc ijaha ŋonâŋfâc-jeŋic bajarenšepieŋ. Moc e ŋonâŋ-ticne maŋjauŋ ecnehuc e jahacne sahac mâmâc ecneocmu. ");
INSERT INTO kmg_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Ŋic moczi moc sahac-ticne râsi mi eecne, gume jauŋ ecnehuc jaha juekac, Kristozi kikefuŋ ecnehuc juekac iŋuc” ");
INSERT INTO kmg_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","nâŋâc me sahac-ticnere tofafâc juŋgopeneŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","“Irec hâcne ŋic moczi neŋgoc mamac jahec-ticne behec-jofarâ ŋonâŋ-ticnerao qohotame jahe maŋ sahac mocjaha erâ junicmu.” ");
INSERT INTO kmg_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","I dâŋ soŋne, qame hukicne. Ine Kristo â Kikefuŋ jahere muhuc mukopac. ");
INSERT INTO kmg_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Ŋoŋe ine ŋic sasawa sahac-ŋeŋic jauŋ baeŋgopieŋ sâc ijaha ŋonâŋfâc-ŋeŋic jauŋ bacjopanšepieŋ. Á ŋokac ine ŋowefâc-ŋeŋic araŋ bajarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Naru motec ŋoŋe Wofuŋte erâ neŋgoc mamacfâc-ŋeŋic jaŋere dâŋ reŋkenšepieŋ. Izi hata biaŋne. ");
INSERT INTO kmg_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","“Go neŋgoc mamac jahecge sâsec-jofazemec”, i sâcmutâc dâŋ fekicne, erâ biŋedâŋ-ticne šiŋuc šuhuckerâ mukicne: ");
INSERT INTO kmg_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","“Iŋuc erâ mâreŋko dameŋ šora juhâc qâhâmocmu.” ");
INSERT INTO kmg_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Mamac ŋoŋe naru motecfâc-ŋeŋic aaric bâfuanšipiŋte wiac kosa mi ejarenšepieŋ. Ŋoŋe mitio jaza bâtiŋ â uŋ sawaŋ ejarehuc soŋaŋ-jopahapie sokanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Kiŋaŋ qaqa ŋoŋe mâreŋ ŋicbomboŋfâc-ŋeŋic araŋ bajarehuc, maŋŋeŋiczi qâzuc foha, Kristo ecneŋgopieŋ tinac, mana mezac ehuc micjeŋic reŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Ŋoŋe ŋicbomboŋfâc-ŋeŋic maizi qambaraŋ ejarepie honec-ŋopapie biaŋkeocte mâcne, nâŋe Kristore kiŋaŋ qaqa, iŋuc muhuc Anutuzi hata muwec i maŋafec jaha âtenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Ŋic jaŋere manasuhuc aricne, Wofuŋte manasuhuc gie-ŋeŋic tatakic tâmiric banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Ŋoŋe manaeŋgopieŋ, moc e kiŋaŋ qaqa me ŋicbomboŋ juhuc wiac biaŋne ehuc juocmu, e Wofuŋzi okacne sâc ijaha bazucneocmu. ");
INSERT INTO kmg_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Erâ ŋicbomboŋ ŋoŋe kiŋaŋ qaqafâc-ŋeŋic iŋuc jaha ehâmo-jarenšepieŋ, ehuc mu imac mi ejarenšepieŋ. Erâ šiŋuc mananšepieŋ: Kiŋaŋ qaqa â ŋicbomboŋ ine sambâŋko Wofuŋ wirec-ŋeŋic jukac, e ra rowec ware rowec mi focnekac. ");
INSERT INTO kmg_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Mutarahuc mupe: Wofuŋtao roweckepie tâpiri sâko-ticnezi ŋoŋerao fotâcneme qaboc-ŋeŋichec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Erâ Anuturaonec sându maro šika wiac ro barâ juhapie Sataŋzi rucko râsi fisi-ŋareme hâbi-ŋeŋic rorâ jâpenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Ŋoŋe manaŋgopieŋ, nâŋâc râsi sahac biuchec jaŋehec šika qaqa mi eeŋgopeneŋ, aricne, ŋicbomboŋ sâko â momori sanaŋ, dameŋ ši dapâc fokac irec guriŋ bapa, demoŋ sâqocne sambâŋ rurumaŋko jueŋgopieŋ, jaŋe râsi enâreeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Irec Anuturaonec sându maro šika wiac ro bajuhuc šika dameŋko qiŋ herâ domahapie râsi jaŋe bâipiec-ŋoparâ wisenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Ŋoŋe kecšiŋuc domanšepieŋ: Dâŋ fâri qizecnezi umbika-ŋeŋic eme jomanšepieŋ, kiŋfâsâczi maruku-ŋeŋic eme rufanšepieŋ, ");
INSERT INTO kmg_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","wamare Biŋebiaŋ bašawiehuc badomanšepieŋ, izi kikehuhu hepie hume âte sanaŋkeŋgopieŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Erâ neŋgocne sâko ine mamanasiŋzi maro-ŋeŋic eme dameŋ sâc he bâfeŋnerâ domahapie sâqocne runere šoc tepe moteczi kisowarierâ hâpozejec. ");
INSERT INTO kmg_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Erâ wâc aeŋdu šâŋene bâbâpiaŋ hepie huzejec, â Mâroraonec šika, Anuture dâŋ hâcne, i bajunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Ŋoŋe šâfo sâc Mârore tâpirio Wofuŋ šušuhuc jaha numucnehuc wâsickenšepieŋ, erâ qâoma mi ehuc rucjaric-ŋeŋic banšepieŋ, erâ hae sâc mitiŋic guru jaŋere nunumu gie banšepieŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Erâ nore mâmâc numuhuc jupie Wofuŋzi micnane baafeckeme Biŋebiaŋ soŋsoŋ fowec i asa feferaŋko mutaniŋkezepac. ");
INSERT INTO kmg_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","No irec biŋe mumu kâpâcwâruo foekopaczi hâhâwic tâmiric mutaniŋkepe sâckezejec. ");
INSERT INTO kmg_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Juju-nanere fuŋne â gie baekopac i kâuc banšipiŋte Tikikozi fârâ dâŋ binaŋ eŋare-fâreocmu, e âgo biaŋ-nâŋec â Wofuŋte kiŋaŋ qaqa micrereŋhec. ");
INSERT INTO kmg_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Eki nâŋere dâŋ binaŋ eŋarehuc bubiaŋ qaŋareocte sorepe fakac hâcne. ");
INSERT INTO kmg_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Anutu Mamac â Wofuŋ Jesu Kristo eki âgofâc-nane ŋoŋe wama bâfua-ŋarehuc mamanasiŋ-ŋeŋic basanaŋkeme maŋjauŋhec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Wofuŋ-nâŋec Jesu Kristo erao qohota sanaŋkeeŋgopieŋ ŋoŋerao aki anonoczi fozejec. ");
INSERT INTO kmg_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Paulo â Timoteo, Jesu Kristore kiŋaŋ qaqa, nâhe Filipi haeonec Kristo Jesure mitiŋic ŋokac â soŋaŋ babafic ŋoŋere papia ši râekoperec. ");
INSERT INTO kmg_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","No ŋoŋere manasuhuc Sâc Anutu-nane daŋge âzâcneekopac. ");
INSERT INTO kmg_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Ŋoŋe Biŋebiaŋ manahuc izia nâŋehec qâturerâ giene bawarehuc jumbiŋ, ");
INSERT INTO kmg_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","eme irec numuekopac sâc mâmâc-ŋeŋicte bubiaŋ manahuc Wofuŋ daŋge numumu ecneekopac. ");
INSERT INTO kmg_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Erâ šiŋuc manapaŋkekopac, gie biaŋ ŋoŋerao fuŋkeweczi baku bataraha Jesu Kristo fifisi dameŋ-ticne maickezokac. ");
INSERT INTO kmg_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","No ŋoŋe sasawa iŋuc mana-ŋarekopac i fuŋne šiŋucte sâckekac: No šira kâpâcwâru ficko Biŋebiaŋte erâ dâŋgie bahuc feŋeŋ râecnepe ŋoŋe sasawa baficnuhuc ŋesiŋ ŋenareeŋgopieŋ” eme no irec hâcne maŋnanezi šâfic-ŋopaekopac. ");
INSERT INTO kmg_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Jesu Kristozi maŋjauŋ enâreekac ira hesiŋnehuc no ŋoŋere erâ maŋhâhâŋ boc enareekac, i Anutuzi manaha jâmbomac mukopac. ");
INSERT INTO kmg_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Erâ maŋjauŋ-ŋeŋiczi maŋ mamanasu â mamana wosâc-ŋeŋic bâsoka raocte numuhuc juekopac. ");
INSERT INTO kmg_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Eme ŋoŋe wiac fâri wâmbuŋne hone šâŋitac erâ Kristo fifisi-ticnere manasuhuc maŋtaniŋ â bahacmâc junšepieŋ, ");
INSERT INTO kmg_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ehuc Jesu Kristozi hume keteŋ eŋareme mitire fârine mâririhec bâfuapie Anuture šeri mumuteŋ ezejec. ");
INSERT INTO kmg_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Âgofâc-nane, kâuc banšipiŋte ŋazape, no šira wiac fua-narewec izi Biŋebiaŋ hatacke hâmoocte fuawec. ");
INSERT INTO kmg_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","No Kristore erâ kâpâcwâru ŋic epo, dâŋ izi šira kia â momori â ŋic gâcne jaŋere hazecko hufârewec. ");
INSERT INTO kmg_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Eme kâpâcwâruo ŋehape širecnec âgofâc-nâŋec gâcne sâko jaŋe Wofuŋte manasuhuc afeckerâ Anuture dâŋ hâhâwic tâmiric mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Tucne Kristore miti i iiŋguuŋko â hehefaricko mueŋgopieŋ, â tucnezi ine buurucko mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","I jaŋe mueŋgopieŋ ine no šira fohuc Biŋebiaŋ ŋezickeekopac irec maŋjauŋ enarehuc mueŋgopieŋ, ");
INSERT INTO kmg_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","â gâcnezi ine sioc ehuc iiriacko Kristore šâŋe muromackeeŋgopieŋ, i kâpâcwâru-nanere faio bušâic bâfua-nareniŋte eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Erâ iŋuc me iŋuc, miti qâtiŋ ehuc muniŋmu me jâmbomacko muniŋmu irec wemocte boc muzo, mâc Kristore dâŋzi haŋ baocmu izi fârine, eme i fuakacte bunane biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Erâ šiŋuc muhuc bubiaŋ hati jupemu: Ŋoŋe nore erâ nunumu gie bapie Jesu Kristore Mârozi baficnume wiac kecšizi bubiaŋ bâfua-nareocmu. ");
INSERT INTO kmg_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Erâ mimi mi bâfuapemu, i manapaŋkepe šickeha maŋzi worickehuc jupemu. Ewarepo iŋuc erapemu, jujure me hâhâmore sahac-nane maŋafec jaha Kristo qikiŋnecnepe izi mumuteŋ-ticne ezejec. ");
INSERT INTO kmg_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Kristozi juju-nane ekac â hâmoczi wiac fekicne bâfua-nareocmu. ");
INSERT INTO kmg_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Me mâreŋko šuhuckerâ jupemu, ine giere fârine mocwâc bâfuapemu. Irec wenimoire afeckepe muhuc maŋguru ekopac. ");
INSERT INTO kmg_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","No mocte â mocte mâmâc enarekac. Mâreŋ beherâ Kristo bâfuarâ ehec juju irec aŋacnukac, izi hâcne wiac fekicne. ");
INSERT INTO kmg_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Á ŋoŋe bekâ enšipiŋte ine ŋoŋere erâ mâreŋko mocwâc šuhuckerâ jupe sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Eme irec hâcne šiŋuc manapaŋkekopac: No mi hâhâmo ŋoŋehec jupemu, erâ bafic-ŋopape mamanasiŋ-ŋeŋic ɋârâŋkeme bubiaŋhec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Á ŋoŋerao mocwâc fârâ jupe nore erâ Jesu Kristo muteŋkeeŋgopieŋzi hati erâ muteŋkenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Mocjaha, ŋoŋe kikefuŋte maio Kristore furu Biŋebiaŋ irec sâcko junšepieŋ. Erâ maŋ mocjaha ehuc šâšâfic erâ keketeŋ domahuc Biŋebiaŋte juju gie bapie fârâ honec-ŋopazepac, me taicko juhuc biŋe-ŋeŋic manazepac. ");
INSERT INTO kmg_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Keketeŋ epie kisâfâc-ŋeŋic hâhâwic heŋarepie hâbi-ŋeŋic mi goroŋkezejec. Iŋuc epie Anutuzi jaŋe behec-jopaocmu â ŋoŋe rocŋopaocmu irec fuŋne bataniŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Anutuzi Kristo wiac ecneniŋte mana-ŋarewec i manasiŋkeniŋte sawa mâcne, ere erâ šâic fâro faio juniŋte mâmâc mana-ŋarewec. ");
INSERT INTO kmg_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Eme no mârâcko juju gie bape honecnumbiŋ â šiŋuczia bape biŋene manaeŋgopieŋ, juju gie ijaha ŋoŋe baeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Ŋoŋerao Kristore erâ sawaŋ qaqac me maŋjauŋko muketeŋ, me Mârohec šâšâfic, me miriŋ â buuruc, wiac i sasawa fokacko ");
INSERT INTO kmg_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","bubiaŋ-nane ferâ foocte mamanasu-ŋeŋic qâturenšepieŋ, erâ maŋzi šâšâfic ehuc mocjaha efârerâ wiac irecteaŋ henširiŋnehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Ŋoŋe hehefaricko â sahac mumuteŋko wiac mi enšepieŋ, moc e jahacne maŋ bawahahuc âgofâcne jaŋere maname fezejec. ");
INSERT INTO kmg_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Erâ moc e jahacne wiac embiaŋkeocte sawa mâcne, âgofâcne jaŋere fua biaŋ eocte mâmâc manasuzejec. ");
INSERT INTO kmg_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Kristo Jesure maŋ mamanasu fowec, iŋuc jaha ŋoŋerezi fozejec. ");
INSERT INTO kmg_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","E Anutu juju juweczi ine, Anuture sâcko juekopac weniŋuc behepemu, iŋuc muhuc mi sakarewec. ");
INSERT INTO kmg_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Aricne, e juju-ticne hetararâ kiŋaŋ qaqa hawari rohuc ŋic iŋucne fuawec, â eebapa-ticne honepie ŋic nâŋâcne sâc ewec. ");
INSERT INTO kmg_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","E wahakicne erâ juhuc micrereŋte hata âte raku hâmoc maickewec, maripoŋko hâmoc hâcne. ");
INSERT INTO kmg_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Iŋuc ewecte Anutuzi bafehuc fekicne sâko âkendâŋnewec. Âkendâŋnerâ šâŋe biŋe-ticne fuŋmoc izi haŋ bahuc ŋic šâŋe biŋe getâcke-fâreocte mucnewec. ");
INSERT INTO kmg_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Eme sambâŋko â mâreŋko â mâreŋ jujuwicnao jueŋgopieŋ jaŋe šeŋgoma Jesure šâŋe muhuc dieŋzi hecnenšepieŋ ");
INSERT INTO kmg_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","â micne mic sâc Jesu Kristo e Wofuŋ jukac iŋuc musereckenšepieŋ. Eme mumuteŋ izi Anutu Mamacte biŋe ezejec. ");
INSERT INTO kmg_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Jorocfâc-nane, ŋoŋe dameŋ sâc micrereŋ eeŋgopieŋ, ŋoŋehec juhape sawa mâcne, taicko juhape wâc ejâmbâŋkeeŋgopieŋ, irec bâbâpiaŋ-ŋeŋicte fârine bâfuaniŋte mezac-ŋopaha fotac qatarienšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Anutu e jahac hâcne, honec-ŋopame biaŋkeocte aafecke mecne fârine bâbâfua mecne irec tâpiri ŋareekac. ");
INSERT INTO kmg_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Ŋoŋe wiac sasawa kâroŋ â maŋguru tâmiric enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","Erâ bahacmâc â maŋtaniŋ junšepieŋ, ehuc ŋicguru bac bâŋoricne â qaqaharicne jaŋere dapâc ŋondeŋko Anuture naru motecfâc maŋɋaɋac erâ juhuc bâpiŋ iŋucne tamaenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","Tamaehuc jujure dâŋ paŋnea bajunšepieŋ. Iŋuc epie juku Kristo fifisi dameŋ-ticnao, šâic mi mana-bipiepo â gie mi bâipiepo, irec fuŋne taniŋkeme šeri bubiaŋ manazepac. ");
INSERT INTO kmg_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","No mamanasiŋ-ŋeŋic Anutu taha bacnehuc sahac-nane due bapemuo sifu irec šeri ehuc ŋoŋehec bubiaŋ manapemu. ");
INSERT INTO kmg_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Á ŋoŋe iŋuc jaha šeri ehuc nohec bubiaŋ mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Wofuŋ Jesuzi maname sâckeme Timoteo biac ŋoŋerao sorepe fâocte mukopac. Eme ŋoŋere dâŋ biŋe moc risie wareme manarâ bunane mâteŋkezejec. ");
INSERT INTO kmg_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Ŋic e iŋucne moc mi junareŋgopieŋ, eki jâmbomac ŋoŋere manoniehuc maŋticnezi dopec-ŋopaocmu. ");
INSERT INTO kmg_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Ŋic gâcne jaŋe jaŋacnere sawa manasuhuc Jesu Kristo gie-ticnere mi mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Timoteo ine juju-ticnere fuŋne manaeŋgopieŋ, ŋokâzi mamac-ticne bafickeekac iŋuc jaha no Biŋebiaŋte giere baficnuekac. ");
INSERT INTO kmg_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Eme no nahacnao wiac iŋuc me iŋuc fuaocmu i mana-hâmorâ e hâcne biac sorepe fâocmu. ");
INSERT INTO kmg_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Erâ Wofuŋzi mana-nareme no nahac wâc mi šoraha ŋoŋerao fâpemu, iŋuc manakopac. ");
INSERT INTO kmg_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","No wiac basahuc juhape ŋoŋe Epafodito sorepie ware dope hutuŋ enarewec, ehuc qomâ-nane â babafic-nane â momori âgo-nane juekac, e sifu bârisie-ŋarezo mukopac. ");
INSERT INTO kmg_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","E huc bame biŋene manambiŋ, eme ere manabâc enšipiŋte ŋoŋere maŋhâhâŋ ecnekac. ");
INSERT INTO kmg_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","E huc ŋemâcne bame hâmozo ewec. Anutuzi ine ehâmocnewec, erâ e sawa mâcne, norao busâqoczi busâqoc fuazacte no mâmâc ehâmo-narewec. ");
INSERT INTO kmg_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Ŋoŋe honerâ buŋeŋic biaŋkeocte â no iŋuc jaha manabâc tâmiric jupemurâ e mi sakarehuc šiŋuczia râepe fakac. ");
INSERT INTO kmg_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Irec fâme bubiaŋ manacnehuc Wofuŋte erâ âgo ecnenšepieŋ. Ŋoŋe ŋic iŋucne hâcne sâsec-jopanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","E Kristore giere erâ hâmozo ewec. Ŋoŋere okacne kiŋaŋ qanareocte sahac-ticne qaisockewec. ");
INSERT INTO kmg_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Âgofâc-nane, moc mupe. Wofuŋte erâ bubiaŋhec junšepieŋ. Dâŋ hâsine ijaha qâreŋke-ŋarezore manape mi quŋkekac, â ŋoŋe ine hume keteŋ eŋarezejec. ");
INSERT INTO kmg_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Ŋoŋe qâto jaŋere rucsoŋaŋ junšepieŋ, miti gie bapa bâbâsifucne, sahac hehetâc ŋic jaŋere rucsoŋaŋ hâcne junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Anutu maŋzi kiŋaŋ qacneeŋgopeneŋ â Kristo Jesurao qohotaeŋgopeneŋ â mamanasiŋ-nâŋec sahacko mi râeeŋgopeneŋ, nâŋâc hâcne ma fârine bajueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","No nahac sahacko siŋkezo murâ sâcne ezapo. Ŋic gâcne jaŋe sahacko siŋkeeŋgopieŋ no ijaha ezo murâ siric-jopazapo. ");
INSERT INTO kmg_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","No fuarâ fohape šoaŋ 8 eme sahac-naneo ma bambiŋ, no Israe ŋicguruonec, Benjamiŋte ɋâric, no Judaŋiczi Judaŋic jaŋeraonec fuakicne hâcne, sâcmutâc dâŋte neŋgocne farisaio ŋic jupo, ");
INSERT INTO kmg_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","šoɋac-nanere erâ kikefuŋ jaŋere râsi epo, sâcmutâc dâŋ sâcko tiŋne juju â bahacmâc jupo. ");
INSERT INTO kmg_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Eme no mârâc wiac bajuhuc manape fârine ewec, i šâhec ine Kristore erâ manape racne ewec. ");
INSERT INTO kmg_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","No Wofuŋ-nane Kristo Jesu ere fuŋne hone šâŋitâc erâ manape furi sâko eme wiac mârâc epo bapo irec jâmbomac manape racne eekac. No Kristo rauckepemurâ ere erâ wiac sasawa ho jawa muhuc qikiŋne-fârepo. ");
INSERT INTO kmg_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","No erao qohotahuc, sâcmutâc reŋkehuc kiŋfâsâc bâbâfua i mâcne. Kristo manasiŋkehuc kiŋfâsâc juju irec enareekac. Mamanasiŋhec jupe Anutuzi kiŋnanere maname tatara, irec mukopac. ");
INSERT INTO kmg_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Erâ no Kristo maŋzi hemiriŋkepe fafahare-ticnere tâpiri norao fuame šâic manawecko šuhuckerâ ehec manazepac. Eku hâmoc-ticnere hawari wâc bâfuazepac. ");
INSERT INTO kmg_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","Iŋuc eerâ raku hâmockonec fafahare bâfuapere enareekac. ");
INSERT INTO kmg_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","No nahacnere šiŋuc mi mukopac: Biac mao fisirâ eri bâfuapo. Mâc Kristo Jesuzi no rocnuwecte eri bâfuapemurâ hata gagasa i gasackeekopac ");
INSERT INTO kmg_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Âgofâc-nane, eri biac bâfuarâ ropo, i no nahacnere manape iŋuc mi ekac Kecšiŋuc ine eekopac: Wiac hetarapo i râpeckeekopac, â wiac mai-naneo râekicne irec menane sicneekopac, ");
INSERT INTO kmg_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","ehuc Anutuzi Jesu Kristore erâ sambâŋte hefârecnuhuc mao eri râe-narewec, i bâfuapemurâ šâŋezi hone dendeŋnehuc gasackeekopac. ");
INSERT INTO kmg_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Soka tarakicne nâŋâc mâmâc sasawa wiac irecteaŋ hâcne henširiŋnehuc junšepeneŋ. Eme wiac mocte manapie hatane moc ekacko Anutuzi maŋŋeŋic batamaeme mana taraniŋmu. ");
INSERT INTO kmg_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Mâc hata âte warembeŋ ijaha âte ranšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Âgofâc-nane bânie-ŋarepe honecnuhuc ijaha bâjâpecnunšepieŋ. Á ŋic gâcne sâc ijaha juhuc bânie-ŋareeŋgopieŋ jaŋerao wâc šâŋe fihuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Ŋic tucne jaŋere ŋaza warehuc jupo, ši ine ki busâqochec mocwâc ŋazape: Jaŋe Kristo maripoŋ-ticne râsi ecneeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Ŋic i jaŋe hâcne sisipiric bâfuaniŋmu. Hobu-jeŋiczi wofuŋ ejareekac, â wiac mimineheczi bubiaŋ qajareekac, â mâreŋkonec wiac maŋ mamanasu-jeŋic rofâreekac. ");
INSERT INTO kmg_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Nâŋâc ine sambâŋ hae irec fârine, eme irecnec hâcne bâbâpiaŋ-nâŋec Wofuŋ Jesu Kristo, e waharâ rocnâpoocte woŋec jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","E ŋic â wiac sasawa bawahac-joparâ jahacne rurumaŋko guruc-jopaocte tâpiri focnekac, tâpiri izi sahac-nâŋec waha qaqane bâtikieme e jahacne sahac iŋucne tatamac huririnehec eocmu. ");
INSERT INTO kmg_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Âgo biaŋfâc-nane, maŋnane ŋoŋere boc ecneekac, ŋoŋe hâcne eri bubiaŋfâc-nane, ŋoŋe Wofuŋtao qohota sanaŋkenšepieŋ, jorocfâc-mae. ");
INSERT INTO kmg_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Euodia â Sintike ŋokac jahec jahe Wofuŋte erâ maŋ mocjaha erâ juzepirec. ");
INSERT INTO kmg_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Á babafic fâri-nane go ine ŋokac jahec hâcne hone maiŋ ejactezemec. Jahe mecne â Kelemento â âgo gâcne jaŋe Biŋebiaŋte giere dopecnumbiŋ. Ʒâŋe-jeŋic juju sanaŋte papia qizecko fofârekac. ");
INSERT INTO kmg_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Ŋoŋe Wofuŋte erâ šeri bubiaŋ manahuc junšepieŋ, no harierâ mupe, šeri bubiaŋ mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Wofuŋzi bâqiŋ-nâpokacte ŋic sasawa wamane ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Wiac irec me irec mana mezac mi ee maŋŋeŋicte dâŋ fuŋne fuŋne i Anutu daŋge nunumu ecnehuc mutaniŋkecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Eme Anuture wama e ŋic mamana sirickeekaczi maŋ mamanasu-ŋeŋic qâzuckeme Kristore fosanaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Erâ âgofâc, dâŋ moc mupe: Wiac fârine â wiac araŋ bapanehec, wiac tiŋne â wiac ɋaɋacne, wiac hohone šiziwene â wiac mamana šiziwene, wiac eesaricne â wiac bubiaŋ bâbâfuane, wiac i sasaware henširiŋnehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","No wiac mu qazuc â ŋaza ŋowatuc epe hone manac embiŋ, ijaha ehuc jupie Anutu wama runezi ŋoŋehec juocmu. ");
INSERT INTO kmg_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Ŋoŋe ŋondeŋne moc mâc juwareku ši nore mocwâc manasurâ buafec-ŋeŋicte ehâmo-narembiŋ, irec manape Wofuŋtao qacneme bubiaŋ kâcɋene manakopac. Ŋoŋe nore mamanasu i manasumbiŋ, mâc wiac enareniŋte hata basarâ quŋkembiŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","No kâroŋ qaŋarehuc mi mukopac, no wiac i me i basarâ mâc juhuc manape mi sâqoreekac. ");
INSERT INTO kmg_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","No qafec qawahac juju me fofo dunduŋ fonareha juju, iŋuc me iŋuc juzo murâ sâcne jupemu. Nâ gapehec juju â natac qatac juju, mâriri faio juju â roroc faio juju, irec fuŋne mâmâc manaekopac. ");
INSERT INTO kmg_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Tâpiri nareme sanaŋkeekopac, ere erâ jupe bape sâcke-fâreekac. ");
INSERT INTO kmg_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Ŋoŋe ine busâqocko juhape ehâmo-narembiŋte manape biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Filipi haeonec ŋic ŋokac ŋoŋe manaŋgopieŋ, no Biŋebiaŋte gie fufuŋke dameŋko Makedonia mâreŋ behepoo kikefuŋ gâcnezi mâc juhapie ŋoŋe buc nohec nareŋ gareŋ embeŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Erâ Tesalonike haeo juhape sahacte wiaczi dopecnuhuc jumbiŋ wâc. ");
INSERT INTO kmg_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","No moneŋ mafare mi mukopac, mâc miti-ŋeŋicte fârine fuaocte mukopac, eme fârine izi ŋoŋeraopec hamârekao hâcne. ");
INSERT INTO kmg_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Ʒi wiac bâfuacnu-fârewec, bocjaha fonarekac. Epafoditozi ŋoŋeraonec wiac bafisi-nareme mâririhec epo jukopac. Ŋoŋe no wiac enarembiŋ, irec manape Wofuŋ taha bâzi biaŋ âsu mumundoŋnehec ecnembiŋ ekac. ");
INSERT INTO kmg_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Anutu-nane e mâriri bâbâfuazi Kristo Jesure erâ wiac hezu heŋareme hâmoc huriaŋ tâmiric juniŋmu. ");
INSERT INTO kmg_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Anutu Mamac-nâŋec erao ine mumuteŋzi mumuteŋ forašihuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","No Kristo Jesure erâ manasuc-ŋopakopac, i mitiŋic ŋokac jaza-fârenšepieŋ. Á âgofâc-nane nohec juŋgopieŋ jaŋe wâc manasuc-ŋopaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Mitiŋic sasawa â Sisare ŋicfâc jaŋe wâc boc manasuc-ŋopaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Wofuŋ Jesu Kristo ere aki anonoczi maŋ qâqâtâc-ŋeŋicko fofârezejec. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Paulo no Anuture micte Jesu Kristore aposolo epo, erâ âgo-nâŋec Timoteo, ");
INSERT INTO kmg_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","nâhe Kolosai haeonec mitiŋic â âgofâc-nâhec Kristorao qohotaŋgopieŋ ŋoŋe papia ši râe-ŋarekoperec. Anutu Mamac-nâŋec eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Nâŋe Wofuŋ-nâŋec Jesu Kristo ere Mamac Anutu hâcne ŋoŋere erâ dameŋ sâc daŋge nunumu ecneeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Ŋoŋe Kristo Jesu manasiŋkeeŋgopieŋ â mitiŋic hae gâcnaonec maŋjauŋ ejareeŋgopieŋ irec mecne, ");
INSERT INTO kmg_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","â sambâŋ miti šeŋaŋ ŋoŋere biŋe râekicne irec mâmâc Anutu muteŋkeeŋgopeneŋ. Ŋoŋe miti šeŋaŋte kâuc mi baeŋgopieŋ. Dâŋ fâri qizecne Biŋebiaŋ hâcne ŋoŋerao fuawec irec biŋe mârâc manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Biŋebiaŋ i mâreŋ sâc fua bâbâriŋ rahuc fârinehec eekac. Eme Anutu akidâŋ-ticne ŋoŋerao fâme jâmbomacko mana maŋ embiŋ, dameŋ ira ŋoŋerao iŋuc jaha fârinehec ewec. ");
INSERT INTO kmg_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Joroc âgo babafic-nâŋec Epafara, Kristore kiŋaŋ qaqa micrereŋhec, eki qazu-ŋareme manambiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Erâ ekizia wâc, Mârozi ŋoŋerao maŋjauŋ bâfuawec, irec dâŋ binaŋ enârewec. ");
INSERT INTO kmg_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Eme nâŋe dâŋ binaŋ-ŋeŋic manarâ izia fuŋkerâ Anutuzi maŋ mamana-ŋeŋic bâsokame micdâŋ-ticnere â Mârore maŋɋârâŋ dâŋ mana taraniŋte numucne warehuc jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Wofuŋzi iŋuc hâcne eŋareme ju ju-ŋeŋiczi fuŋne-ticne mutaniŋkeme honec-ŋopame biaŋkezejec. Á mitio gie fuŋne fuŋne fokac, i bahuc irec fârine bâfuanšepieŋ, ehuc Anuture fuŋne mana ɋârâŋke rahuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Erâ Anuture tâpiri mu wawarec-ticnehec izi âkesiŋ-ŋopame hâbi sâko hepie hume juhapie fai-ŋeŋicko wiac ŋemâcne feme sâc docke pârâc tâmiric bumâteŋ jaha de domahuc bubiaŋ mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Erâ Mamac-nâŋec e faic tatamacko merâfâc-ticne râe-nârewec, i mitiŋic nâŋâc ru sâc enaŋte bâmoc-nâpoekacte buafec jaha daŋge âzâcnenšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Anutu e dâpac runere tâpirionec batarac-nâporâ joroc Ŋokâ-ticnere uucmaŋko râec-nâpowec. ");
INSERT INTO kmg_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Ŋokâ-ticne eki hâcne sâqocne-nâŋec tâmireote kiwiric-nâŋec rowec. ");
INSERT INTO kmg_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Anutu soŋne ere hawari tâtâc fufua Ŋokâ-ticne hâcne. E wiac sasawa mi fuahame micne barâ juweczi juwec. ");
INSERT INTO kmg_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Ere jujuo wiac sasawa sambâŋko â mâreŋko fua-fârewec, wiac hohonene â mi hohonene, ŋic me aŋelo ɋuŋɋasaŋhec me tâpirihec, fekicne sâko me araŋ bapa-jarene, i mâmâc sasawa ere tâpirio â ere biŋe fuakicne. ");
INSERT INTO kmg_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","E wiac sasawa irec juwicnao juwec erâ wiac sasawa irec micne sâko, erâ wiac sasawa ere dope sisiŋko fowarehuc juekac. ");
INSERT INTO kmg_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Erâ e me sahac-ticne, kikefuŋ-ticne hâcne, nâŋâcne qizec juekac. Erâ fufuŋke ŋic, hâmockonec micne barâ faharewec, ehuc wiac sasawa irec jâcne ewec. ");
INSERT INTO kmg_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Anutu e juju â tâpiri-ticnere rowaŋ Ŋokârao guru fufusuc foocte maname sâckewec. ");
INSERT INTO kmg_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Erâ wiac sasawa sambâŋko â mâreŋko Anutu jahacnehec miriŋ bacnâpoocte mucneme eki hâcne maripoŋko socticnezi wama bâfuahuc iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Ŋoŋe mârâc jaha Anutu râpeckerâ nâme nikecne erâ sâqocne fuŋne fuŋne bahuc maŋšârâhec jujumbieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Eme Kristo sahac biuchec fuarâ hâmoc-ticnezi miriŋ bacŋoparâ Anuture maio furu â maŋɋaɋac â bahac fâsâc juniŋte râec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Eme irec ŋoŋe mamanasiŋko qiŋ herâ domahuc, Biŋebiaŋzi woworic bâfua-ŋarewec i sifucke-ŋarezacte biric borocne mi enšepieŋ. Biŋebiaŋ i ŋoŋe qazu-ŋarekicne, erâ ŋoŋe sawa mâcne, ŋicne ŋicne mâreŋ sâc jaza rakicne. Paulo no hâcne irec kiŋaŋŋic juekopac. ");
INSERT INTO kmg_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","No ŋoŋere erâ šâic serereŋ faio juekopac irec ši manape biaŋkeekac. Kristozi me sahac-ticne, kikefuŋ-ticne hâcne, ere erâ šâic serereŋ manawec, šâic irec tofanao šuhuckehuc mamanane fokacte nore sahacko fehuc micne qazejec. ");
INSERT INTO kmg_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","No Anutu dâŋbiri-ticnere sâcko kikefuŋte kiŋaŋ qaqa erâ ŋoŋerao micdâŋ-ticnere qaqazu gie batarapemurâ munarekicne. ");
INSERT INTO kmg_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Dâŋ i dameŋne dameŋne soŋne fome mimiŋzi ɋâric mi mamana mâc juwefuhuc jumbiŋ, eme dameŋ šiŋuczia ine mitiŋicfâc-ticne mufua-nârekicne. ");
INSERT INTO kmg_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Erâ qâpuc jaŋerao dâŋ soŋnere mâriri biaŋ sâko fuakac i mitiŋicfâc-ticne mutaniŋke-nârekac. Kristo maŋŋeŋicko juekac e hâcne dâŋ soŋnere fârine â sambâŋ šeŋaŋ irec hozine. ");
INSERT INTO kmg_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Ere fuŋne mutaniŋkehuc ŋicne ŋicne uŋ sawaŋ ejarerâ maŋɋârâŋ dâŋ sasawa jaza qazuc eeŋgopeneŋ, i Kristoo ŋic fârine epie erao guruc-jopanaŋte iŋuc eeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Ere tâpirizi eferenšoŋnume gie i hâcne fotariehuc baekopac. ");
INSERT INTO kmg_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","No ŋazape mananiŋ, ŋoŋe mecne â Laodikea haeonec â ŋic gâcne šâŋe mai-nane mi honembiŋ, ŋoŋere šâic afecne mi manaekopac. ");
INSERT INTO kmg_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Ŋoŋe maŋŋeŋiczi âte tâcnerâ roroc efâreme Anutu dâŋsoŋ-ticnere fuŋne, Kristo hâcne, mana maŋ ehuc mana utuckerâ mana taranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","Erao hâcne maŋɋârâŋ â mamana tara irec šâkâŋne soŋkekicne fokac. ");
INSERT INTO kmg_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Moczi moc mu hemiriŋ eŋarehuc maŋ bâsifuc eŋarenšipiŋte dâŋ mukopac. ");
INSERT INTO kmg_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","No sahac-nanezi wiwicko juekopac, maŋnanezi ine ŋoŋehec juhuc ŋoŋe Kristo manasiŋkehuc šišimic erâ sosoŋaŋko domapie honec-ŋoparâ bunane biaŋkekac. ");
INSERT INTO kmg_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Ŋoŋe Kristo Jesu Wofuŋ eŋareocte rombiŋ erao qohotahuc junšepieŋ, ");
INSERT INTO kmg_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ehuc eraoa gâtâ barâ fua-hâmonšepieŋ, â mamanasiŋte hata ŋaza ŋowatuc ekicne ijaha âte sanaŋkerâ daŋge mumuteŋ ecnehuc jupie ferâ fe ehuc fozejec. ");
INSERT INTO kmg_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Moczi moc ŋickonec mamana dâŋ, eeatuc dâŋ racne hâcne, qazu-ŋarehuc maŋŋeŋic bawisenšipiŋte rucŋeŋic banšepieŋ. Dâŋ iŋucne i mimiŋne jaŋere maŋko fuac dâŋ â mâreŋte wiac tâpirihec ira roweckehuc mueŋgopieŋ, Kristorao siŋkehuc mâcne. ");
INSERT INTO kmg_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Manaŋgopieŋ, Anuture sâc i Kristo maŋ sahac-ticnao qaja fuserâ qâniniwerâ fokac. ");
INSERT INTO kmg_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Irec ŋoŋe erao wiac moc mi basaniŋmu, eki hâcne micne â fekicne sasawa jaŋere qizecne. ");
INSERT INTO kmg_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Eraonec maŋeŋic wâc rombiŋ, mezi sahacko ma bapa i mâcne, juju-ŋeŋic raŋɋane heunuckehuc Kristore maqâreŋhec embiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Ihec eniŋte Miti Opâ rua-ŋarehuc ere hâmocko šuhuc-ŋopakicne, erâ Anutu e tâpiri-ticnezi Kristo hâmockonec bâɋârewec, tâpiri ijaha manasiŋkepie ŋoŋerao fotâcneme fafahare-ticnao wâc šuhuc-ŋopakicne. ");
INSERT INTO kmg_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Ŋoŋe mârâc jaha ma tâmiric juhuc sâqocne kosa barâ hâmocne juhapie Anutu e kiŋŋeŋic behehuc Kristohec bâɋârec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Erâ dâŋ qaqatara-nâŋec qâreŋkekicne i âke sifuckehuc irec kiŋ papia i bâsuckerâ maripoŋko ɋetickeme arictâc ewec. ");
INSERT INTO kmg_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Iŋuc ehuc fekicne â tâpirihec hâbi-jeŋic bâŋgoroŋkerâ saoreŋ qahuc fuŋne-jeŋic bataniŋkewec. ");
INSERT INTO kmg_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Ŋic moczi nânâ qowi soware me sabata hombaŋ me mosa hombaŋ i me i ŋeŋere me mi ŋeŋere mu supaic mi eŋarezejec. ");
INSERT INTO kmg_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Wiac iŋucnere nâkumucne muzo, fârine šâhec fuaocte irec nâkumucnezi qanaŋ bâniewec. Á fârine ine Kristorao fuawec fokac. ");
INSERT INTO kmg_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Ŋic gâcnezi maŋhuhuŋ hawari erâ juhuc aŋelo araŋ bajareeŋgopieŋ, â maŋnâŋec ŋerisieme wiac honeeŋgopeneŋ muhuc irec manapie fârine eme sahac-jeŋic maŋgâŋ mušoraeŋgopieŋ, ŋic iŋucne jaŋe boreŋ fâri-ŋeŋic mi ŋowac ronšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Jaŋe hâcne Kristorao sâcne mi siŋkeeŋgopieŋ. Eki qizec-nâŋec â nâŋâc me sahac-ticne. Eme qizeckonec ruazi fâuckerâ wahahuc me kike fâri ombâŋ-ticne basanaŋ-nâpohuc bândeŋ-nâpoekac. Ehuc gume hesiwiŋ enâreme soka sanaŋte tâpiri Anuturaonec fua-nâreekac. ");
INSERT INTO kmg_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Ŋoŋe Kristore hâmocko šuhuckehuc mâreŋte wiac tâpirihec râpeckembiŋko wemocte mâreŋte hae fâri juhuc tinac sâcmutâc dâŋticne reŋkeeŋgo-pieŋ? ");
INSERT INTO kmg_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","Dâŋ kecšiŋuc: “Keci mi bâuac, keci mi nâc, keci mi roc.” ");
INSERT INTO kmg_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Wiac nâ bac erâ bebehene hâcne, irec kibâtâc dâŋ i ŋiczi maŋjeŋicte manasurâ mu qaqazuc eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Ŋic iŋucnezi maŋɋârâŋ hawari erâ “bâtâcko â sowa juhuc sahac bâpitiwazo” iŋuc mupie dâŋ izi fârine tinac eekac. Erâ wiac iŋucnezi fârine aricne, izi sasec aka sâcne mi hecneocmu. ");
INSERT INTO kmg_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Ŋoŋe Kristo fafahare-ticnao šuhuckembiŋko ine faic Anuture maŋfuŋko Kristo jukacko wiac fokac, irec henširiŋnehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Mâreŋko wiac fokac irec mâcne, faic wiac fokac irec maŋ mamanasu-ŋeŋic râepie fozejec. ");
INSERT INTO kmg_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Ŋoŋe hâmombiŋ hâcne, eme juju-ŋeŋic Kristohec Anuturao soŋkekicne fokac. ");
INSERT INTO kmg_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Juku Kristo e juju runâŋeczi fua taniŋkeme ŋoŋe iŋuc jaha ehec mâmâc tatamac huririnao fua taniŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Wiac kecšiŋucte ine sowa juhuc sahac-ŋeŋic bâhâmonšepieŋ: Boe sau, maŋwânâŋ, bu gâgâpâcne, sasec sâqocne, buchâro, i eocmu e sahac-ticnezi wofuŋ ecnekac muzo. ");
INSERT INTO kmg_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Wiac i sasaware Anuturaonec okacne fisiocmu. ");
INSERT INTO kmg_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Ŋoŋe mârâcko iŋuc jaha wiac i bajupie maŋ fâri-ŋeŋic ejujec. ");
INSERT INTO kmg_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Ʒi ine wiac iŋucne sasawa hetaranšepieŋ. Ehuc aaric, kimbeŋ, râŋgeŋ bârâŋgeŋ, dâŋ gâgâpâcne â simbiŋne i qikiŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Burec eec i wâc mi enšepieŋ. Maŋraŋɋa-ŋeŋic mâsi qâqâreŋ-ticnehec heunucke behec erâ ");
INSERT INTO kmg_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","maŋɋâri-ŋeŋic hepie hume rojuŋgopieŋ. Maŋ i hâcne bâbâfuazi bâpiaŋkeme mamanahec erâ e jahacne hawari iŋucne fuahuc jukac. ");
INSERT INTO kmg_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Irec bârâwiŋ juju i tarawec, Grikŋic â Judaŋic, mahec â ma tâmiric, hâwecŋic â kâte sanaŋ, kiŋaŋ qaqa â ŋicbomboŋ, mâmâc sasawa Kristozi qâhâc-nâporâ micne junâre-fâreekac. ");
INSERT INTO kmg_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Eme Anuture biŋefâc, e jahac maŋjauŋ eŋarehuc rowosâec-ŋopawec, ŋoŋe buuruc â buafec â maŋhuhuŋ â miriŋ â bumâteŋ izi ŋaqi-ŋeŋic eme hepie hume rojunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Ŋoŋe aakic enšepieŋ, â ŋondeŋ-ŋeŋicko dâŋ fuame kiŋ bebehec enšepieŋ. Wofuŋzi kiŋ behe-ŋarewec iŋuc jaha eec enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Eme wiac sasawa irec fainao maŋjauŋ bajupie izi wiac bâture-fârehuc ematauckezejec. ");
INSERT INTO kmg_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Erâ Kristore wamazi maŋŋeŋicko guriŋne bazejec. Ŋoŋe wamahec erâ me sahac mocjahao juniŋte rocŋopakicne hâcne. Erâ wâc daŋge mumuteŋ ehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Kristore dâŋzi ŋondeŋ-ŋeŋicko sawe mâririackezejec. Eme maŋɋârâŋ dâŋ fuŋne fuŋne qaqazuc ehuc faŋ qaqac enšepieŋ. Erâ miti gae mânec i Mârozi baafec-ŋopaha maŋŋeŋiczi Anutu muteŋkehuc hecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Eme maŋzi me mezi wiac ezo murâ i Wofuŋ Jesu manasiŋkehuc enšepieŋ, ehuc ere erâ Anutu Mamac daŋge âzâcnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Ŋokac ŋoŋe ŋowefâc-ŋeŋic jaŋere rereŋfâc junšepieŋ, Wofuŋte biŋe ekicnezi iŋuc epie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Ŋic ŋoŋe ŋonâŋfâc-ŋeŋic maŋjauŋ ejarenšepieŋ, šâšâicne ine mi ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Naru motec ŋoŋe neŋgoc mamacfâc-ŋeŋic dâŋ mupie sâc reŋkenšepieŋ, iŋuc epie Wofuŋzi maname biaŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Mamac ŋoŋe naru motecfâc-ŋeŋic hâwic sahac enšipiŋte aaricko wiac mi ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Kiŋaŋ qaqa ŋoŋe mâreŋ ŋicbomboŋfâc-ŋeŋic jaŋere mic reŋke-fârenšepieŋ, maizi qambaraŋ ejarepie ŋiczi sawa honec-ŋopapie sâckeocte mâcne, maŋsiocmâc Wofuŋ araŋ bacnehuc epie sâckeomu. ");
INSERT INTO kmg_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Gie-ŋeŋic sasawa i ŋic jaŋere erâ mâcne, Wofuŋte erâ aafec faio banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Kecšiŋuc manahuc: Gie furi sambâŋko merâfâc fokac i Wofuŋtaonec roniŋmu. Irec Wofuŋ Kristo ere kiŋaŋ qaqafâc juŋgopieŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Moc e gie-ticne bâsâqoreocmu, e irec okacne jaha roocmu. Wofuŋtao ra rowec ware rowec mi fokac. ");
INSERT INTO kmg_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Ŋicbomboŋ ŋoŋe kiŋaŋ qaqafâc-ŋeŋic wiac sâkoa etiŋnehuc ejarenšepieŋ, ehuc ŋaŋacne femicne Wofuŋ sambâŋko jukac i manasunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Paŋšâic jaha numuhuc junšepieŋ. Erâ rucgereŋ juhuc daŋge nunumu enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Erâ nâŋere wâc numupie Anutuzi mitire hata bâšâwe-nâreme Kristore dâŋ soŋne mufuanšepeneŋ. Dâŋ irec hâcne niŋgiŋko fokopac. ");
INSERT INTO kmg_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Nunumuzi dopecnupie dâŋ afeckehuc mujaŋgeŋkepe sâckezejec. ");
INSERT INTO kmg_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Qâpuc jaŋehec bâbâfuac erâ wiac mana tara-hâmohuc enšepieŋ. Ehuc gie bapa dameŋ mi sipirickenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Dâŋŋeŋic hâwec ruacnepie aŋacne ezejec. Eme ŋic dâŋ iŋuc me iŋuc bâtikie-jareniŋte mi bititienšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","No nahacne dâŋ binaŋ i Tikikozi eŋareocmu. E joroc âgo babafic-nâŋec â Wofuŋte kiŋaŋ qaqa micrereŋhec. ");
INSERT INTO kmg_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","E hâcne juju-nâŋecte dâŋ binaŋ eŋarehuc mu âkeriŋ eŋareocte ŋoŋerao sorepe fakac. ");
INSERT INTO kmg_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Erâ Onesimo, miti mamana âgo biaŋ-nâŋec, ŋoŋere haeonec, e mâmâc ecnepe fârâ širec dâŋ binaŋ eŋare-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Kâpâcwâru ŋic âgo-nane Aristako â Banaba nafe-ticne Mareko â Jesu, šâŋe-ticne moc Justo, jaŋe manasu-ŋareŋgopieŋ. Mareko ere sâcmutâc eŋarepo, fâ fisiocmuo âgo ecnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Ŋic i jaŋe sawa Judaŋic jaŋeraonec fuakicnezi Anutu uucmaŋ-ticnere giere baficnueŋgopieŋ, ehuc bubiaŋ qanareeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Erâ ŋoŋere haeonec ŋic moc Epafara, Kristore kiŋaŋ qaqa, ere mamanac ŋoŋerao fokac, erâ ŋoŋe sanaŋkerâ Anuture micsâcko juhuc wiac mana tararâ etiŋneniŋte dameŋ sâc nunumuzi dopec-ŋopaekac. ");
INSERT INTO kmg_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","No fuŋne-ticne manakopac, e ŋoŋere mecne erâ Laodikea haconec â Hierapoli haeonec mitiŋic jaŋere mecne mâmâc šâic gie wemo afecne baekac. ");
INSERT INTO kmg_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Luka dokta biaŋ-nâŋec â Dema jahe mu šeri eŋarekopirec. ");
INSERT INTO kmg_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Erâ no Laodikea haeonec mitiŋic â Nimfasi â wiacfâcne mu šeri ejarekopac i mufua-jarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Papia ši ŋic ŋokac wose-jarepie mana-fârepie Laodikea haeonec kikefuŋ jaŋerao râepie rame wosenšepieŋ. Á jaŋere moc qâreŋkepo iŋuc jaha ŋarepie wosenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Arikipo e šiŋuc âzâcnenšepieŋ: “Miti gie Wofuŋzi neŋgoc ŋeha mugarekicne i aijakic jaha bâhâmozemec.” ");
INSERT INTO kmg_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Paulo no nahacne šâŋe qâreŋ ši râekopac. Kâpâcwâru ŋic nore manasunšepieŋ. Aki anonoczi ŋoŋerao fozejec. ");
INSERT INTO kmg_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Paulo, Siliwano â Timoteo nâŋe Tesalonike haeonec kikefuŋ, Anutu Mamac â Wofuŋ Jesu Kristo ere ŋicfâc, ŋoŋere papia ši râeŋgopeneŋ. Aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Nâŋe dameŋ sâc ŋoŋere erâ Anutu daŋge âzâcneeŋgopeneŋ, erâ nunumu gie bahuc sâc ŋoŋere manasu-fâreeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Ŋoŋe mamanasiŋ-ŋeŋicte fârine bâfuaeŋgopieŋ â maŋjauŋte bâmec gie baeŋgopieŋ â Wofuŋ-nâŋec Jesu Kristo paŋšâic jaha worickeeŋgopieŋ, irec Mamac-nâŋec Anutu ere maio hati manasurâ mufuahuc âzâcneeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Âgofâc, nâŋe manaŋgopeneŋ, Anutuzi maŋjauŋ eŋarehuc rowosâec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Iŋuc eŋarewecte Biŋebiaŋ bafârâ ŋazapene dâŋ sawa mi ewec, i tâpirihec â Tiri Mârohec â buâkecnehec ewec. Ŋoŋerao jumbeŋko ŋoŋere erâ wiac ebac embeŋ i manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Eme nâŋe bâjâpec-nâpombiŋ, bâjâpec-nâpohuc Wofuŋ e jahacne mâmâc bâjâpembiŋ. Ehuc miti i fific guguriŋ faio Tiri Mârozi bufahac qaŋarehame ro maŋ embiŋ. ");
INSERT INTO kmg_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Ŋoŋe iŋuc ehuc Makedonia â Akaia mâreŋkonec miti mamana jaŋe micne bajarehuc fuŋne qazu-jarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Ŋoŋeraonec hâcne Wofuŋte dâŋzi haŋ barahuc Makedonia â Akaia mâreŋko fuawec, erâ i sawa mâcne, ŋoŋe Anutu manasiŋkembiŋ irec dâŋ biŋe i hae sâc mana-fârepie nâŋe jajazane moc mi fuawec. ");
INSERT INTO kmg_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Jaŋe jaŋac ŋoŋerao gie bapene fârine fuawec irec dâŋ nâzâeŋgopieŋ. Erâ ŋoŋe nemuɋâŋ râpeckerâ Anutu jujune â fârine maickerâ ŋicfâc-ticne embiŋ, ");
INSERT INTO kmg_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","erâ Ŋokâ-ticne Jesu hâmockonec bâɋârekicne, e juku sambâŋkonec waharâ okac dameŋko ŋezic-nâpozokac, ere šawiehuc jueŋgopieŋ, irec dâŋ binaŋ-ŋeŋic hae sâc eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Âgofâc-nane, ŋoŋerao fisirâ gie bapene fârimâc mi ewec i ŋaŋac manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Qanaŋ Filipi haeo qa imac enârembiŋ i manaŋgopieŋ wâc. Enârepie sifu mi dockembeŋ. Aricne, Anuturao roweckepene bubiaŋ qanâreme afeckerâ ŋoŋerao fârâ Anuture Biŋebiaŋ i juju gie sâko bahuc mufua-ŋarembeŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Babaafec dâŋ mueŋgopeneŋ i mamana sifuc faio mâcne, me maŋsifuc faio mâcne, me kege wage eŋarehuc mâcne” ");
INSERT INTO kmg_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Anutuzi honec-nâpome sâckeme Biŋebiaŋ muromackenaŋte betoŋ-nâpowec irec sâc mueŋgopeneŋ. Ŋiczi mana-nârepie biaŋkeocte aricne, Anutu e maŋ hohonezi mana-nâreme biaŋkeocte mocjaha mueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Ŋoŋe nâŋere manaeŋgopieŋ, nâŋe bâbâmiriŋ dâŋ moc mi ŋazambeŋ mitio ake hehuc moneŋ mafare andac i wâc mi embeŋ, i Anutuzi manaha mukopac. ");
INSERT INTO kmg_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Kristore aposolo nâŋe mana-nârepie feme sâckeocmu i manahuc sifu ŋoŋe me hae gâcnaonec ŋicbomboŋ eŋarenaŋte mi mumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Aricne, neŋgoc moczi kogocfâcne hemiriŋ-jopaekac, iŋuc jaha nâŋe ŋoŋerao juhuc eŋarembeŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Aŋac-nâŋec ŋoŋerao fowecte Anuture Biŋebiaŋ ŋaŋazare sawa mâcne, ŋoŋere erâ juju-nâŋec qiqikiŋ irec mâmâc afeckembeŋ, maŋnâŋec ŋoŋerao âeckewec irec. ");
INSERT INTO kmg_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Âgofâc, micneneŋ eŋarepene takic-ŋopazacte ŋafe furec sahacte gie mâmâc šocne fârone bahuc domambeŋ, i ehuc Anuture Biŋebiaŋ ŋazambeŋ, ŋoŋe irec manasueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Nâŋe maŋtaniŋ â tiŋne â bahacmâc juhuc miti mamana ŋoŋe wiac eŋarembeŋ, i ŋoŋe mecne â Anutu mecne fuŋne-nâŋec manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Erâ moc šiŋuc wâc manaŋgopieŋ: Mamac moczi naru motecfâcne ejareekac, sâc ijaha nâŋe ŋoŋe eŋarehuc buc buc mu sawaŋ dâŋ ŋazambeŋ â esoc qafeŋ eŋarembeŋ â šiŋuc mušakiehuc ŋazambeŋ: ");
INSERT INTO kmg_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","“Uucmaŋ-ticne â eri tatamac-ticne rauckeniŋte hefârec-ŋopaekac Anutu hâcne, ere ŋicfâc fârine erâ irec sâcko junšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Nâŋe Anuture dâŋ ŋazapene manapie ŋicdâŋ mi ewec. Eme iŋuc sâcne manambiŋ, i Anuture dâŋ jâmbâŋ, eki miti mamana ŋoŋerao gie baekac. Eme nâŋe irec hâcne Anutu daŋge mumuteŋ kuduc jaha ecnehuc jueŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Âgofâc-nane, ŋoŋe Anuture kikefuŋ Judaia mâreŋko Kristo Jesurao qohotambiŋ jaŋehec sâc mocjaha embiŋ. Jaŋe Judaŋiczi jopa qâšâic ejarembiŋ iŋuc jaha âgofâc-ŋeŋic gâcnezi ŋoŋe ŋopa qâšâic eŋarembiŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Judaŋic jaŋe Wofuŋ Jesu â porofete iŋuc jaha qâhâmoc-jopambiŋ, erâ wâc nâŋe nâpo jâpec enârembiŋ. Jaŋe Anutu âgo mi ecneeŋgopieŋ â ŋicne ŋicne kisuec-jopaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Ehuc qâpuc miti jazapene manarâ biaŋkenšipiŋte aka henareeŋgopieŋ. Jaŋe iŋuczi iŋuc ehuc sâqocne faio fefec hefekupie kiŋjeŋicte sâc micne qame Anuture kimbeŋ fisi-jarewec. ");
INSERT INTO kmg_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Âgofâc, nâŋe behec-ŋopambeŋ, erâ maŋzi mâcne, sahaczi dameŋ ŋondeŋ ši ŋoŋe tâmiric juhuc huacbuc eŋgopeneŋte mocwâc honec-ŋopanaŋte boc enâreekac. ");
INSERT INTO kmg_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Eme irec fârâ iqic-ŋopanaŋte mumbeŋ, Paulo no nahac dameŋ moc â moc fâzo mupe Sataŋzi aka henarewec. ");
INSERT INTO kmg_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Ŋoŋere aŋac-nâpoekac i šiŋucte: Wofuŋ-nâŋec Jesu ere fifisi dameŋko weni jaŋe gie fâri-nâŋec â šeri-nâŋec â eri-nâŋec eniŋmu? Ŋoŋe wâc enâreniŋmu hâcne. ");
INSERT INTO kmg_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Ŋoŋe mumuteŋ-nâŋec â bubiaŋ-nâŋec. ");
INSERT INTO kmg_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Ŋoŋere maŋhâhâŋ boc enarekume nâŋe gâcnezi sifu Ateŋ haeo buc juhuc ");
INSERT INTO kmg_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Timoteo sorepene behec-nâporâ ŋoŋerao fâwec. E âgo-nâŋec â Anuture gieŋic juhuc Kristore Biŋebiaŋ muekaczi fârâ mitio hume keteŋ eŋarehuc faŋ qaŋareocte mucnembeŋ. ");
INSERT INTO kmg_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Ŋoŋe šârâ hâriŋ faio juhuc dockenšipiŋte iŋuc embeŋ. Ŋoŋe manaŋgopieŋ, miti mâteŋne juhuc mananaŋte mi munârekicne. ");
INSERT INTO kmg_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Nâŋe ŋoŋerao juhuc qanaŋ dâŋ šiŋuc ŋazambeŋ: “Ʒika biac fai-nâŋecko feocmu.” Eme dâŋ i sanaŋkewec, i manaŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Eme eesâic runezi bârokawec-ŋopame gie-nanere fârine omaezacte maŋ kukumbuc boc enareme jupe bape sâqoreme ŋic e miti babaju-ŋeŋicte fuŋne manaocte sorepe fâwec. ");
INSERT INTO kmg_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Eme ši Timoteo e risie warerâ mamanasiŋ â maŋjauŋ-ŋeŋicte biŋe biaŋ nâzâwec” Erâ nâŋere boc manasueŋgopieŋ, â nâŋe ŋoŋe honec-ŋopazo muhapene ŋoŋe iŋuc jaha nâŋe honec-nâpozo mueŋgopieŋ, dâŋ i nâzâ-fârewec. ");
INSERT INTO kmg_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Âgofâc, nâŋe šârâ hâriŋ â bušâiczi maŋnâŋec hehâriŋkeme juhapene miti babaju-ŋeŋicte dâŋzi bunâŋec bâuruewec. ");
INSERT INTO kmg_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Ŋoŋe Wofuŋ heme hariŋ ecnehuc sanaŋkeeŋgopieŋ i manahuc maŋnâŋec fie ruruckekac. ");
INSERT INTO kmg_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Ŋoŋere erâ Anuture maio bubiaŋ sâko manaeŋgopeneŋte Anutu daŋge mo iŋucne ecnepene sâckeocmu? ");
INSERT INTO kmg_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Mâc mana-nâreha ŋoŋerao fârâ hohonec erâ miti gâcne forakac i moc šuhucke-ŋarenaŋte ŋafe furec mu wâwâsic ecneeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Mamac-nâŋec Anutu â Wofuŋ-nâŋec Jesu e jahac hata bâfua-nâreme ŋoŋerao fânšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Ŋoŋerao ine Wofuŋzi maŋjauŋ-ŋeŋic bâŋɋârâŋkeme ŋedâmâreme ŋaŋackoaŋ â gâcne jaŋehec eec enšepieŋ” nâŋe iŋuc jaha ŋoŋe eŋareeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Erâ Anutuzi maŋŋeŋic keteŋkeme ŋoŋe Mamac-nâŋecte maio bahacmâc â maŋfuru juhapie Wofuŋ-nâŋec Jesu tiŋnefâc-ticne sasawa jaŋehec fisizejec. ");
INSERT INTO kmg_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Âgofâc-nane, Wofuŋ Jesure erâ uŋ sawaŋ eŋarehuc moc šiŋuc ŋazapene mananiŋ: Mitio juju bapa-ŋeŋiczi Anutu âgo ecneocte fuŋne ŋaza qazuc embeŋ, ijaha junšepieŋ. Mitio juju i sâcne jueŋgopieŋ, mâc juŋɋârâŋkeniŋte ŋazaŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Wofuŋ Jesure micte dâŋ ŋaza qâmoc embeŋ, irec kâuc mi baŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Anutu e šiŋuc hâcne muekac: Boe sau qikiŋnehuc maŋɋaɋac junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Ŋoŋerao moczi e jahacne ŋonâŋ maŋɋaɋacko â pectâcko rauckezejec, ");
INSERT INTO kmg_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","sasecte šocbâruŋko misac, i ŋic qâpuc Anuture kâuc baeŋgopieŋzi eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Moczi moc aka huckehuc wiac iŋucnao âgo-ticne mi eatuckezejec. Wofuŋ e wiac irec okacne bazu-fâreocmu” nâŋe dâŋ i mârâc jaha mujomirerâ ŋazambeŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Maŋwânâŋhec junaŋte aricne, maŋɋaɋac junaŋte Anutuzi hefârec-nâpowec. ");
INSERT INTO kmg_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Irec moc e dâŋ i bâsueocmu, e ŋic moc mâcne, Anuctu e jahacne bâsueocmu, Tiri Mâro maŋŋeŋicko râeekac e hâcne bâsueocmu. ");
INSERT INTO kmg_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Ŋoŋe miti mamanazi maŋzi jauŋ babac eniŋte wemocte boc qâreŋke-ŋarenaŋmu, Anutu e jahac maŋzi jauŋ babac eniŋte fuŋne ŋaza ŋowatuc ewec. ");
INSERT INTO kmg_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Erâ ŋoŋe Makedonia mâreŋ hae sâc opâ ruac juraŋgopieŋ jaŋe maŋjauŋ ejarehuc jueŋgopieŋ. Erâ sifu mocwâc ɋârâŋkeocte ŋazaŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Erâ dâŋ moc šiŋuc ŋaza qâmoc embeŋ: Rac warec juhuc dâŋ ojowa mi ee, hae-ŋeŋicko ŋezurâ ŋehuc mezi gie muŋarekicne aijakic jaha baniŋte ɋicwânšâŋ enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Ehuc qâpuc jaŋere maio roroc tâmiric pectâc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Âgofâc, ŋoŋe hâmokicne jaŋere kâuc bârâ, miti tâmiriczi maŋjeŋic šickeme ki mamakuc eeŋgopieŋ iŋuc enšipiŋte ŋazapene mananiŋ: ");
INSERT INTO kmg_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Nâŋâc Jesu hâmorâ faharewec dâŋ i maŋkerâ šiŋuc mananšepeneŋ: Anutu e Jesu ecneme hâmokicne jaŋe e jahacnehec amec-jopa fisiocmu. ");
INSERT INTO kmg_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Á moc i Wofuŋ e jahacne micdâŋ ŋazanaŋ: Mâreŋko ɋâricne juhapene fisiocmu nâŋâc hâmokicne mi siric-jopanaŋmu. ");
INSERT INTO kmg_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Wofuŋ e sambâŋkonec wahaocte ine dâŋ wiwira â aŋelo qizecte micšonšoŋ â Anuture qeŋfânâŋ fuahame wahaocmu. Wahame Kristo manasiŋkehuc hâmombiŋ jaŋe bâbâni fahareniŋmu. ");
INSERT INTO kmg_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Faharepie ɋâricne junaŋmu, tiwâne hâcne, izi jaŋerao šuhuckepene karoraczi bafec-nâpome sawao Wofuŋhec bâbâfuac enaŋmu. Erâ Wofuŋhec juhuc junaŋmu sanaŋ. ");
INSERT INTO kmg_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Ŋoŋe dâŋ i hâcne muc manac ehuc maŋ bâbâmâteŋ enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Âgofâc-nane, dameŋte â šâfore dâŋ wemocte moc qâreŋke-ŋare mu? ");
INSERT INTO kmg_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Ŋaŋac šiŋuc sâcne manaŋgopieŋ: Râsi jaŋe ŋafeo ututuŋ fisieŋgopieŋ, iŋuc jaha dameŋ-ticne ɋeŋfâfâc jaha maickeocmu. ");
INSERT INTO kmg_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Eme ŋic jaŋe aki wama sâko fokac muhuc mana fâsâerâ juhapie wiac hâhâwicnezi acmâc jaha fisi-jareocmu. Ŋokac kiwechec moc e gozi onšoŋ jaha kime fâfâreocmu, iŋuc jaha ŋic iŋucne jaŋe wiac onšoŋ jaha fua-jareme wemocko moc wiseniŋmu. ");
INSERT INTO kmg_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Âgofâc, ŋoŋe ine dapâcko mi juŋgopieŋ, irec wemocko Wofuŋte dameŋzi râsi iŋucne erâ ututuŋ maic-ŋopame bipic tatara eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Ŋoŋe tatamacte â šoaŋte kikefuŋ ekicne, nâŋâc ŋafere me dapâcte biŋe aricne. ");
INSERT INTO kmg_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Irec ŋic gâcnezi guŋ fopie qâtec-joparâ guŋ mi fonšepeneŋ, rucgereŋ-nâŋec bahuc maŋte sowa junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Guŋ fofo jaŋe ŋafeo foeŋgopieŋ gae wowo jaŋe ŋafeo wohuc bâbâsifuc bâfuaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Ʒoaŋte biŋe ekicne nâŋâc ine maŋte sowa junšepeneŋ, ehuc mamanasiŋ â maŋjauŋ izi maruku enârezejec, â bâbâpiaŋte woworiczi dunâŋec ezejec. ");
INSERT INTO kmg_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","I šiŋucte: Anutu e kimbeŋ-ticnere fârine hotâckenaŋte mâcne, Wofuŋ-nâŋec Jesu Kristore erâ bâbâpiaŋ rauckenaŋte muekac. ");
INSERT INTO kmg_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","E hâcne okac-nâŋec hâmowec, i hâmohuc me ɋâricne juhuc ehec mâmâc junaŋte iŋuc ewec ");
INSERT INTO kmg_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Ŋoŋe irec hâcne faŋ qaqac â hehe šakiec eeŋgopieŋ iŋuc jaha ehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Âgo bureŋ, wiac mocte esoc-ŋopaŋgopeneŋ: Ŋoŋerao šâic gie baeŋgopieŋ â Wofuŋte erâ micne baŋareeŋgopieŋ â mu bâtiŋ eŋareŋgopieŋ i jaŋe sâsec-jopanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Ehuc gie-jeŋicte erâ maŋjauŋ ejarehuc mana-jarepie fejâmbâŋkezejec. Erâ wâc wama qaqac ehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Âgofâc, hazec qâuŋ dâŋ moc ŋazape mananiŋ. Ŋic kosa jujune jaŋe uŋ sawaŋ ejarenšepieŋ, ŋic manabâcne jaŋe mu âkeriŋ ejarenšepieŋ, betaŋkekicne jaŋe dopec-jopanšepieŋ, erâ mâmâc hezu hemiriŋ ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Sâqocnere okac babazuc enšipiŋte sosoŋaŋ enšepieŋ. Ŋaŋackoaŋ â ŋic gâcne sasawa jaŋehec eehâmoc erâ erahuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Bubiaŋ faio jurâ jurahuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Nunumu moc mi hetaranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Wiac irec me irec daŋge mumuteŋ enšepieŋ, i Kristo Jesure erâ eniŋte Anutuzi muŋarekac. ");
INSERT INTO kmg_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Mârore šoc mi hehâponšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Anuture micdâŋ mufua-ŋarepie mana qâoma mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Dâŋ sasawa mana wosâerâ bâtâc banšepieŋ, â biaŋne eme bajunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Sâqocne fuŋne fuŋne ine qikiŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Anutu wama rune e jahac šure bâpiaŋ eŋareme maŋfuru ejâmbâŋkenšepieŋ, eme mâro â maŋ qâqâtâc â sahac-ŋeŋic furu fohame Wofuŋ-nâŋec Jesu Kristo ere fifisi dameŋko bahacmâc domanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Hefârec-ŋopakac e mume sasanaŋ, irec gie-ticne baku batarocmu. ");
INSERT INTO kmg_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Âgofâc, ŋoŋe nâŋere erâ numunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Opâ ruac ŋoŋe mitio meo babac efârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","No Wofuŋte maio ŋaza sanaŋkepe: ŋoŋe papia kecši opâ ruac mâmâc sasawa wose-jarepie mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Wofuŋ-nâŋec Jesu Kristo ere aki anonoczi ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Paulo, Siliwano â Timoteo nâŋe Tesalonike haeonec kikefuŋ guru, Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo ere ŋicfâc, ŋoŋere papia ši râeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Anutu Mamac â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Âgofâc, maŋnâŋeczi jâiŋ-nâpome ŋoŋere erâ Anutu dameŋ sâc daŋge âzâcneeŋgopeneŋ. Mamanasiŋ-ŋeŋic boc fua ɋârâŋ eekac, â maŋjauŋ-ŋeŋic fua sawec eme qame qoŋgiŋ eeŋgopieŋ. Eme irec Anutu daŋge âzâcnepene i jâmbomac sâckeekac. ");
INSERT INTO kmg_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Erâ ŋoŋe fific guguriŋ eŋarepie šâic busâqochec juhuc mamanasiŋ-ŋeŋic mi ŋeŋgoroŋkeha sifu sanaŋkerâ jueŋgopieŋ, irec dâŋ binaŋ hae sâc Anuture kikefuŋfâc ejareeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Ŋoŋe wiac fua-ŋareekac, irec šiŋuc muzo: Anutuzi okac dameŋko wiac sâckoa enâreocmu, irec sâsâcne ši qanaŋ fuakac. Anutuzi ŋoŋere maname sâckeme uucmaŋ-ticnao rarašire sâc bâfuaniŋte šârâ hâriŋ faio jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Eme juku Anutu mana wosâc-ticne tiŋne fokac irec sâc enâreocmu: Ŋoŋe šâic fâro eŋareeŋgopieŋ jaŋe šâic fâro jaha bâfua-jareocmu, ");
INSERT INTO kmg_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","â šâic fâro manaeŋgopieŋ ŋoŋe ine nâŋehec mâmâc bâgunuc-nâpoocmu. I juku Wofuŋ Jesu e aŋelo guru hâhâwicne jaŋehec sambâŋkonec waha fua tâcneocmu ira iŋuc enâreocmu. ");
INSERT INTO kmg_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","E šocbâruŋko waharâ ŋic Anuture kâuc baeŋgopieŋ â Wofuŋ Jesu Biŋebiaŋ-ticne mana rereŋ mi eeŋgopieŋ jaŋe okacne jareocmu. ");
INSERT INTO kmg_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Ŋic i jaŋe Anutuzi furine sisipiric sanaŋ jarehuc šâŋe mai-ticnaonec â tâpiri-ticnere huriri biaŋkonec bârâriec-jopaocmu. ");
INSERT INTO kmg_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Eme dameŋ ira fuŋfuŋfâc-ticne jaŋerao eri tatamac-ticne fuaocmu, â miti-ticne ro maŋ embiŋ jaŋe hone warec ecneniŋmu. Ŋoŋe ine mumutaniŋ dâŋnâŋec mana šakiembiŋ hâcne. ");
INSERT INTO kmg_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Irec hâcne ŋoŋere erâ dameŋ sâc numuhuc šiŋuc mueŋgopeneŋ: Anutu-nâŋec e hefârec-ŋopaweczi irec sâcko juniŋte bašawiec-ŋopazejec, erâ tâpiri-ticnezi dopec-ŋopahame wiac biaŋnere mu manasuc ehuc mamanasiŋte gie fâri bâfua-fârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Iŋuc epie Wofuŋ-nâŋec Jesu ere šâŋe qâreŋzi ŋoŋerao fua jaŋgeŋkezejec, â ŋoŋe iŋuc jaha erao taniŋke biaŋ enšepieŋ. I Anutu-nâŋec â Wofuŋ Jesu Kristo eki aki anonoc-ticnere iŋuc eŋarezejec. ");
INSERT INTO kmg_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Âgofâc, Wofuŋ-nâŋec Jesu Kristo fifisi-ticnere â ehec bâbâfuac ee irec dâŋne moc ŋazapene mananiŋ. ");
INSERT INTO kmg_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Ŋic gâcne jaŋe Wofuŋte dameŋ maickekac muhuc Mârorao muhotaniŋmu, me nâŋe micko itic enâreniŋmu me papia-nâŋecte mu ɋetic eniŋmu, eme ŋoŋe mi mutuc erâ fâfârepie maŋŋeŋic hockezejec. ");
INSERT INTO kmg_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Eatuc dâŋ iŋuc me iŋuc ŋazapie mi mananšepieŋ. Wofuŋ dameŋ-ticne maickezo eha qanaŋ miti ima qaqa sâko fuaocmu, erâ sindaŋŋic sisipiricte biŋe eki hâcne fua tâcneocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Eme šâŋene Anutu me miti wiac mueŋgopieŋ i sasawa râsi ecnehuc qâhuckerâ ro waha âte ecne-fâreocmu. Erâ Anuture ufuŋko ferâ ŋehuc e jahacnere muocmu, “No Anutu.” ");
INSERT INTO kmg_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","No ŋoŋerao juhuc irec hâcne ŋazapo, i moc manasuŋgopieŋ me? ");
INSERT INTO kmg_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Dameŋ šiŋuczia aka fokac, i manaŋgopieŋ, i hâcne rârieme dameŋ-ticnao fua tâcneocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Ʒi ine sindaŋzi soŋsoŋko biac gie-ticne baekac. Á aka hecneekac e rârieme sindaŋŋic fua tâcneocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Eme Wofuŋ Jesu e micrombâŋ-ticnezi qarâ fifisi-ticnere šâziriŋnezi imackeocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Ŋic e Sataŋzi neŋgoc ŋesiŋ ŋecnehame tâpiri wiac fuŋne fuŋnehec fuarâ burecko mâsi â qaŋgec wiac šâŋe furu baocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Erâ ŋic gâcne, dâŋ fâri qizecne manarâ bibiaŋke i qaisockerâ sisipiricte biŋe eeŋgopieŋ, jaŋe sâqocnere maŋ bâsifuc ejareocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Ŋic jaŋe iŋuc eeŋgopieŋte Anutuzi eeatuc neŋgoc qizecne sâko mume fuame burecko qohotaniŋmu hâcne. ");
INSERT INTO kmg_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","I mâc mâcne, dâŋ fâri qizecne qikiŋnerâ wiac hehesicnere aŋac-jopaekac, ŋic i jaŋe okacne fisi-jareocte iŋuc hâcne eocmu. ");
INSERT INTO kmg_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Âgofâc-nâŋec, Wofuŋte jorocfâc, ŋoŋe Mârozi baɋaɋac-ŋopame dâŋ fâri qizecnao qohotahuc biaŋkeniŋte Anutuzi mârâc jaha rowosâec-ŋopawec, irec daŋge hati âzâcnenaŋte maŋnâŋeczi jâiŋ-nâpoekac. ");
INSERT INTO kmg_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Irec hâcne Biŋebiaŋ ŋazapene manarâ Wofuŋ-nâŋec Jesu Kristo eri tatamac-ticne rauckeniŋte hefârec-ŋopawec. ");
INSERT INTO kmg_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Eme irec âgofâc ŋoŋe sanaŋkerâ dâŋ miczi â papiazi ŋaza qazuc embeŋ i paŋšâic bajunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Wofuŋ-nâŋec Jesu Kristo â Anutu Mamac-nâŋec eki maŋjauŋ enârehuc katucmâc-ticnere erâ bubiaŋ fofo sanaŋ bâfua-nârewec â šeŋaŋ fâri woŋec-nâŋec râewec, ");
INSERT INTO kmg_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","eki hâcne maŋŋeŋic bâinaŋkerâ dopec-ŋopame dâŋfâri â gie fâri i ŋoŋerao mi wahazejec. ");
INSERT INTO kmg_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Âgofâc, dâŋ moc fokac mananiŋ: Nâŋere erâ numupie Wofuŋte dâŋzi fofotâc haŋ barame qâreŋ biaŋ-ticne ŋoŋerao fuawec iŋuc jaha fua razejec. ");
INSERT INTO kmg_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Erâ ŋic maŋbâiŋ bâbâfuane â sindaŋne jaŋere erâ Anutuzi ŋezic-nâpoocte nunumuzi wâc bafic-nâponšepieŋ. Miti i ŋiczi furu ninic ro maŋ mi eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Wofuŋzi ine mume sasanaŋ, irec hume keteŋ eŋarehuc sâqocne runere roroŋ sasapec eŋareocmu. ");
INSERT INTO kmg_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Ŋoŋe dâŋ ŋazapene reŋkerâ reŋke rahuc juniŋmu, irec Wofuŋte erâ ŋoŋere maŋjahec mi eŋgopeneŋ ");
INSERT INTO kmg_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Wofuŋzi maŋŋeŋic jowame Anuture maŋ jauŋko â Kristore bumâteŋko iticnezejec. ");
INSERT INTO kmg_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Âgofâc, Wofuŋ-nâŋec Jesu Kristo ere micte ŋazapene mananiŋ, dâŋ qazu-ŋarembeŋ i opâ ruac gâcnezi mi reŋkehuc kosa jueŋgopieŋ, ŋic i jaŋehec mi junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Nâŋe hata fuŋkerâ âte-ŋarembeŋ ijaha bâjâpec-nâponiŋte kâuc mi baŋgopieŋ. Nâŋe ŋoŋerao ojoŋ mi jumbeŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Erâ ŋoŋeraonec nânâ furimâc mi nâmbeŋ, aricne, nânâ mafare micneneŋ eŋarenšipeŋte ŋafe furec mezi gie šocnehec bahuc šâic manambeŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Erâ iŋuc enaŋte mi munârekicne, nâŋe qaŋeŋ-ŋopahuc fuŋne ŋowatupene nâŋere mimiŋ qâjâpec juniŋte iŋuc eŋarembeŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Ŋoŋerao juhuc šiŋuc hâcne boc ŋazambeŋ: Ojoŋ juocmuzi nânâ mi nâzejec. ");
INSERT INTO kmg_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Eme ši ŋoŋeraonec dâŋ šiŋuc wareme manambeŋ: Ŋic gâcnezi gie-jeŋic hetârarâ qâoma erâ jueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Ŋic iŋucne jaŋe Wofuŋ Jesu Kristore micte uŋdâŋ šiŋuc jazapene mana-jâmbâŋkenšepieŋ: Ŋezu ŋewâneŋ erâ gie-jeŋic bapie fârine fuame jaŋacneonec nânšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Âgofâc, ŋoŋe ine eehâmo gie tatakic tâmiric banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ʒi papiao dâŋ qâreŋke-ŋareŋgopeneŋ, i ŋic moczi qikiŋneme fuŋne-ticne mujaŋgeŋkerâ behepie buc juhuc mimiezejec. ");
INSERT INTO kmg_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Râsi ecneniŋte mi mukopac, âgo-nâŋec muhuc mu bâtiŋ ecnehuc tutuc qacnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Wofuŋ e wama runezi ine wama bâfua-ŋareme ŋoŋerao dameŋ sâc sâcke-fârerâ fozejec. Wofuŋ e ŋoŋehec jufârezejec. ");
INSERT INTO kmg_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Ʒi Paulo no nahacne mezi šâŋe qâreŋ-nane râekopac. Papia qâreŋkeekopac sâc ma izi fuaekac. Iŋuc hâcne qâreŋkeekopac. ");
INSERT INTO kmg_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Wofuŋ-nâŋec Jesu Kristo ere aki anonoczi ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Paulo no Anutu bâbâpiaŋ-nâŋecte micte â Kristo Jesu mamanac-nâŋecte micte Kristo Jesure aposolo juekopaczi ");
INSERT INTO kmg_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","mitio motec jâmbâŋ-nane Timoteo go papia ši qâreŋke-garekopac. Anutu Mamac â Wofuŋ-nâŋec Kristo Jesu eraonec aki anonoc â uruc jauŋ â wama gorao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","No Makedonia mâreŋko razo ehuc gazapo iŋuc ezemec, ehuc Efeso haeo šuhuckerâ juhuc, ŋic tucnezi miti musifuckeeŋgopieŋ jaŋe qatara-jaretec behenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Jaŋe nemu binaŋ bahuc ŋic gaŋne gaŋne juwefumbiŋ irec fuŋne qapie rašic wefuc eme mu qaqataranehec fuaekac. Iŋuc epie Anutu manasiŋkehuc kiŋaŋ qaqacne i wahame sâqoreekac. ");
INSERT INTO kmg_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Miti mumure fârine ine šiŋuc fuame sâckeocmu: Maŋtaniŋ â maŋšuruc â maŋ mamanasiŋhec juhuc maŋjauŋ bâfuazo. ");
INSERT INTO kmg_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Ŋic tucnezi ine miti hata i qâsorierâ dâŋ jawane fârimâc bâfuambiŋ bajuŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Erâ jaŋacnere šiŋuc mueŋgopieŋ: Nâŋe Mosere sâcmutâc dâŋ irec qaqazu, iŋuc murâ dâŋ kosa muhuc irec sasanaŋ bâfuaeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Nâŋâc sâcmutâc dâŋte šiŋuc manaeŋgopeneŋ: I dâŋ biaŋne, erâ fuŋneticne mana-hâmohuc bajuzo. ");
INSERT INTO kmg_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Fuŋne-ticne ine šiŋuc fokac: Sâcmutâc dâŋ i ŋic bahacmâc jaŋere biŋe mi ekac, ŋic sindaŋne, râŋgeŋne, araŋ bapa tâmiric, sâqocne bapa, maŋwânâŋhec, šaubacne, neŋgoc mamac sisipiric, šika qaqa, ");
INSERT INTO kmg_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","boe sau ŋic, ŋiczia ŋicko sasec gie bapa, ŋic ŋokac fiuc rocjoparâ gâcne qikiŋne-jarehuc moneŋ bâbâfua, burecŋic, Wofuŋte šâŋe muhuc burecko mumupaŋ ee, erâ wiac gâcne moc dâŋ fari biaŋ râsi ecneekac, wiac iŋucne eeŋgopieŋ jaŋere hâcne sâcmutâc dâŋ mukicne. ");
INSERT INTO kmg_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Anutu juju aŋac rune ere Biŋebiaŋ eri tatamacnehec tahacnukicne izi hâcne iŋuc mufuakac. ");
INSERT INTO kmg_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Tâpiri narehuc basanaŋnuwec Wofuŋ-nâŋec Kristo Jesu e daŋge âzâcneekopac. Eki mana-nareme sâckeme betoŋnuhuc miti gie munarewec hâcne. ");
INSERT INTO kmg_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Juwicnao e musoriŋkehuc ŋicfâcne râsi ejarerâ jopa qâšâic ejarehape sifu iŋuc enarewec. No Wofuŋte fuŋne kâuc bahuc mamanasiŋ-nane tâmiricte iŋuc epore akicnuwec. ");
INSERT INTO kmg_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Eme Wofuŋ-nâŋecte aki anonoczi norao qaja fuseme Kristo Jesuraonec mamanasiŋ â maŋjauŋhec epo. ");
INSERT INTO kmg_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Jesu Kristo e sâqocne bapa bâpiaŋ-nâpoocte mâreŋko wahawec, dâŋ i fârine jâmbâŋ â mâmâc sâko ro maŋ eenere sâc. Sâqocne bapa jaŋere micne no hâcne. ");
INSERT INTO kmg_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Eme Jesu Kristo e akicnurâ, uruc jauŋ-ticne ŋemâcne fokac, irec fuŋne norao furu jaha bataniŋkewec i mâc mâcne, ŋic šâhec mâsi i hâcne norao honerâ e manasiŋkerâ juju sanaŋko fisiniŋte iŋuc enarewec. ");
INSERT INTO kmg_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Juju sanaŋte Wofuŋ Sâko, mi hâhâmone â mi hohonene, Anutu sâko mocjaha hâcne, ere šâŋe biŋe â eri tatamac forašihuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Motec-nane Timoteo, qanaŋ gore findaŋdâŋ fuawec irec sâcko dâŋ mutâcne-garekicne i hâcne râe-garekopac. Go i bajuhuc momori gie biaŋ sanaŋkerâ bazemec. ");
INSERT INTO kmg_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Erâ mamanasiŋge fošakierâ fohame maŋge soŋaŋketec ɋaɋacnea fozejec. Ŋic tucnezi maŋɋaɋac juju râpeckembiŋte mamanasiŋ-jeŋic ŋeŋgoroŋkeme qâsoriembiŋ. ");
INSERT INTO kmg_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Jaŋeraonec moc Himenaio â moc Alesande, eme jahe Sataŋzi bâšâic-jofakume mumusoriŋ-jekic behenicte erao râec-jofapo. ");
INSERT INTO kmg_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","No bâbâni dâŋ moc gaza qâmoc epe: Nunumu wâwâsic â daŋge mumuteŋ izi ŋaŋacne â ŋic gâcne sasawa dopec-jopahuc ");
INSERT INTO kmg_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","ŋicwofuŋ â kia gawamaî mâmâc dopec-jopanšepieŋ. Eme soŋaŋ-nâpohapie wamao mâteŋne â mitine juhâmopene ŋiczi mana-nârepie fezejec. ");
INSERT INTO kmg_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Izi biaŋkeocmu, â bâbâpiaŋ-nâŋec Anutu e irec maname sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Eki ŋic mâmâc sasawa biaŋkerâ dâŋ fâri qizecne mana maŋ eniŋte muekac hâcne. ");
INSERT INTO kmg_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Anutu mocjaha hâcne junârekac, erâ Anutu â ŋic ŋondeŋ-nâŋecko ŋicwirec-nâŋec mocjaha Jesu Kristo e ŋic ekicnezi junâre-fârekac. ");
INSERT INTO kmg_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Eki hâcne juju-ticne qikiŋnehuc mâmâc sâko kiwiric-nâŋec rowec, irec biŋezi dameŋ-ticnao haŋ baocte. ");
INSERT INTO kmg_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","No irec biŋe mumu â aposolo jupemurâ râecnukicne, erâ ŋic qâpuc dâŋ fâri qizecne â mamanasiŋte fuŋne jaza mutâc epemurâ qaqazu gie munarekicne. Dâŋ i burec mâcne, jâmbomac mukopac. ");
INSERT INTO kmg_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Ŋic jaŋere mukopac, jaŋe hae sâc aaric â maŋjahec tâmiric juhuc mejeŋic ɋaɋacne foha Anuturao sicnerâ numunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Á ŋokac jaŋere mukopac, jaŋe ŋaqi aickerâ rojuhuc rume rume jupie izi eri-jeŋic ezejec, â qizec susuc-jeŋicko mâsi qâreŋ ee, me eri wiac furi sâko qoqonaŋ, me ŋaqi hohonebâcne ro juju ine mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Ŋokac mitio juzo muŋgopieŋzi eehâmo gie bapie sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Ŋokac jaŋe wahamicne juhuc niniŋkerâ hazec râehuc mamana gie banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Ŋokaczi qaqazu gie baocte me ŋic qâhuc-jopaocte mi manacnekopac, e mâc rumerâ juzejec. ");
INSERT INTO kmg_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Adam e bâbâni bâfuakicne â Ewa ine šâhec. ");
INSERT INTO kmg_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Adam e eesaic rune mi manacnewec, ŋokaczi ine manacnerâ qaqatara bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Ŋokaczi motec roro-ticnere biaŋkeocmu, ine mamanasiŋhec â maŋjauŋhec erâ maŋɋaɋac juniŋmu ŋokac i jaŋe iŋuc hâcne eniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Moc e mitire micne bapa juocte muocmu, e gie furi sâkore ecnekac muzo, dâŋ i jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Eme mitire micne bapazi bahacmâc juhuc ŋokac mocjahahec juzejec, erâ maŋsowa juzejec, eesifuc tâmiric metâne juzejec, jauŋhec juzejec, qaqazu gie basarickehuc bapane, ");
INSERT INTO kmg_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","waiŋ opâ âmbâŋ mi nâzejec, šikafac aricne, urucne â wamane juzejec, moneŋ mafare mubâre mi ezejec, ");
INSERT INTO kmg_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","e jahacne wiacfâc sâcne soŋaŋ-jopazejec erâ pectâc juhuc naru motecfâcne mu bâtiŋ ejareme micrereŋhec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Moc e wiacfâc-ticne sâcne mi soŋaŋ-jopaocmu, e wemocko Anuture kikefuŋ mamac ejareocmu. ");
INSERT INTO kmg_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Erâ opâ ruac ɋâricne moczi mitire micne bapa mi juzejec, iŋucnezi penaroŋ eme Sataŋzi doc bazacte. ");
INSERT INTO kmg_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Ŋic ŋokac kikefuŋko mi rašimbiŋ jaŋe wâc manacnepie sâckeekac ŋic iŋucnezi mitire micne juzejec, jaŋe musoriŋkepie Sataŋzi maŋne bâsifuckeme ere bitiŋko kizacte. ");
INSERT INTO kmg_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Babafic jaŋe iŋuc jaha ŋic metâne junšepieŋ, nameŋ sosohoc mi junšepieŋ, waiŋ opâ nâ âmbâŋ mi enšepieŋ, moneŋ mafare mubâre mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Miti boreŋ soŋsoŋ fowarehuc juwec i maŋɋaɋacko duckepie fozejec. ");
INSERT INTO kmg_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Jaŋe wâc qanaŋ ba esâic ejarezo” eme fuŋne-jeŋic hone manac epie sâckeme gie jarezo. ");
INSERT INTO kmg_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Ŋonâŋfâc-jeŋic jaŋe iŋuc jaha metâne junšepieŋ, gupe micko âkec mi enšepieŋ, maŋsowa juhuc wiac sasawa mu bac epie fâri fideteŋ efârezejec. ");
INSERT INTO kmg_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Babafic moc e ŋokac mocjahahec juzejec. Naru motecfâc-ticne â wiacfâc-ticne sâcne soŋaŋ-jopazejec. ");
INSERT INTO kmg_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Eme babafic moc e gie-ticne bame biaŋkeme maŋte juju šae biaŋne bâfuaocmu â Kristo Jesurao qohotahuc giere afecke-hâmoocmu. ");
INSERT INTO kmg_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","No gorao biac fâpemurâ manasuhuc sifu kecšiŋucte dâŋ ši qâreŋke-garekopac: ");
INSERT INTO kmg_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Wiac moczi niŋgiŋnume jupe šorame Anuture ficko ju bac ezore fuŋne kâuc bazic. Anutu jujune ere kikefuŋfâc jaŋe hâcne ficticne erâ wâc dâŋ fâri qizecnere gumi â hobeteŋne juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Miti-nâŋecte fuŋne qame hukicne mutaniŋkeeŋgopeneŋ i qeŋ bipinehec: E sahacko fua tâcnekicne, Mârozi fuŋne bataniŋkekicne, aŋelozi honekicne, qâpucko biŋene mukicne, mâreŋ sâc mana maŋ ekicne, eri tatamacko bafekicne. ");
INSERT INTO kmg_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Mâro e qanaŋ šiŋuc mujaŋgeŋkerâ muekac: Juku šâhec ŋic tucnezi miti beherâ maŋ bâsifuc bâbâfua jaŋere eeatuc dâŋko â demoŋ jaŋere burecdâŋko qohotaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Ine burecŋiczi maŋjeŋic šukiwic bakicnere ŋic eatuc-jopahuc šiŋuc jazaeŋgopieŋ: ");
INSERT INTO kmg_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","“Ŋokac mi rohuc ŋicšeŋoŋ juzo â nânâ gâcne mi nâhuc irec sowa juzo.” Nânâ i Anutuzi râe-fârewec, erâ mamanasiŋhec juhuc dâŋfâri mana maŋ embeŋzi daŋge âzâcnehuc nanaŋte muwec. ");
INSERT INTO kmg_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Anuturaonec wiac fuakicne i biaŋne sasawa. Erâ daŋge âzâcnehuc nâ bac eeŋgopeneŋko qaqatarene mi fokac. ");
INSERT INTO kmg_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","I Anuture dâŋzi â nunumuzi jambuŋkekicne hâcne. ");
INSERT INTO kmg_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Go opâ ruac dâŋ i jaza qâmoc ecmu, ine Jesu Kristore kiŋaŋŋic dâŋ rereŋhec jucmu, ehuc mamanasiŋte dâŋ â mitire dâŋfuŋne fârine mana rereŋ ewaremeŋ izi maŋgere nâqiŋ eha jucmu. ");
INSERT INTO kmg_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Á qeŋokac qizec dâŋ wose murarane ine qikiŋnezemec. Go Wofuŋ manasiŋkehuc jucmurâ maŋzi aafec bazemec. ");
INSERT INTO kmg_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Sahacte aafec gie bapa izi fâfârine, â maŋ baafeckehuc Wofuŋ manariŋ qâriŋ eecne ine fârine. Izi šira mâreŋko â juku sambâŋko juju bâfua-nâreocte mukicne. ");
INSERT INTO kmg_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Dâŋ i fârine jâmbâŋ â mâmâc sâko ro maŋ eenere sâc. ");
INSERT INTO kmg_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Irec fârine hâcne ronaŋte gie amec fâfâuc baeŋgopeneŋ, ine mumusoriŋzi fai-nâŋecko feipieha Anutu jujune ere mamanacko juhuc eeŋgopeneŋ. E hâcne mâreŋ sâc ŋic jaŋere bâbâpiaŋ juekaczi mamana hec nâŋâcne ejâmbâŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Dâŋ mukopac sasawa i jaza mutâc ezemec. ");
INSERT INTO kmg_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Go motec ɋâri jukic irec ŋic jaŋe gore manapie wawahane mi ezejec. Go maŋjauŋhec â mamanasiŋhec â maŋɋaɋachec jutec miti mumugezi â juju bapagezi opâ ruac guru hata jowatuzejec. ");
INSERT INTO kmg_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Woŋec-nane juhuc miti wose qazuc â jaza qâmoc ehuc juzemec. ");
INSERT INTO kmg_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Micne bapa jaŋe Mâroraonec dâŋ mufuahuc mejeŋic qizecgao râehuc jambuŋgumbiŋ, jambuŋ irec fârine sifucke-garezacte bâiŋ basawec ezemec. ");
INSERT INTO kmg_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Go irec mana mezac ehuc giege bašihuc batec fârine fuarâ fua ehuc fome hone-fârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Gahacne maŋ sahac soŋaŋkehuc mitire dâŋfuŋne furu mimic foŋareocte mâmâc soŋaŋkezemec. Go i hâcne paŋšâic bajuzemec. Iŋuc ecmuo ine dâŋge manaeŋgopieŋ jaŋe mecne â go gahacne mâmâc juju biaŋko fisiniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Ŋicqizec moc dâŋ âzâcnemurâ fâfâcnehec mi ecnezemec, mamac-nane muhuc urucko mu tutuc ecnezemec, ŋicmotec hahac ɋafâc-nane muhuc sâcjeŋicko jaza bâtiŋ ejarezemec. ");
INSERT INTO kmg_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Ŋokac qizec neŋgocfâc-nane muhuc iŋuc jaha uruc jauŋdâŋ jazazemec, ŋokac sahac ɋâri seŋfâc-nane muhuc rucge bahuc dâŋ wiac jazazemec. ");
INSERT INTO kmg_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Hozec sâsec-jopahuc dâŋjeŋic dopeckezemec, hozec jâmbâŋ jaŋere mukopac. ");
INSERT INTO kmg_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Hozec moc naru motec me ŋosafâcne juniŋmu, ine jaŋe qanaŋ jaŋacne ficko miti gie bahuc ŋic ŋokac qizefâc-jeŋic jauŋ-jopanšepieŋ, ehuc juwicnao wiac ejarekicne irec tofa bazunšepieŋ. Anutu e irec maname sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Hozec fârine ine e jahackoaŋ juhuc Anuturao roweckeekac, ehuc ŋafe furec nunumu wâwâsic ecneekac. ");
INSERT INTO kmg_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Á hozec moc sasec gie baocmu ere ine ɋâricnezi hâmocne mucnezo. ");
INSERT INTO kmg_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Dâŋ i wâc jaza sanaŋketec manarâ bahacmâc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Moc e wiacfâcne â soctofafâcne hone jauŋ kime dopec mi ejareocmu e miti beherâ qâpuc sanaŋ ewec mucnezo. ");
INSERT INTO kmg_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Hozec moc jara-ticne 60 bazuwec, erâ ŋic mocjahahec juwec, iŋucne sawa šâŋe-ticne bâmec papiao râezo. ");
INSERT INTO kmg_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Erâ eehâmo gie bawec me mâcne, irec fuŋne taniŋkeocte kecšiŋuc mu wioc ezo: Naru motec rocjoparâ gume jowac ejarewec me mâcne? Erao ŋic furune fisipie hezu hewâneŋ ejarewec me mâcne? Mitiŋic bâmec bajarewec me aricne? Jauŋ gie fuŋne fuŋne bawec me mâcne? Fuŋne-jeŋic iŋuc hâcne manazo. ");
INSERT INTO kmg_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Hozec sahac ɋâri jaŋe šâŋe-jeŋic bâmec papiao feocte mupie ine qatara-jarezemec. Iŋucne jaŋe sasecte ejareme Kristo qâoma ecnerâ ŋicte sahac bapa eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Erâ mârâc dâŋ mupaŋkembiŋ i qâsuapie bahacnehec eekac. ");
INSERT INTO kmg_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Erâ wâc gie tâmiricte ficbiri juhuc oma qâoma erâ jueŋgopieŋ, erâ i sawa mâcne, dâŋ jawane â simbiŋne kosa wosepie feekac. ");
INSERT INTO kmg_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Irec no šiŋuc mukopac: Hozec sahac ɋâri jaŋe ŋic mocwâc rorâ naru motec rocjoparâ dete mamac â ro rikec qâ rikec enšepieŋ. Iŋuc ehuc jupie kisâ jaŋe sâqocnere ojowa baniŋmurâ dâŋ basarâ behenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Hozec gâcne jaŋe ine biac hata qâsoriembiŋ Sataŋ bâjâpeeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Hozec moc e miti ŋokac mocte ficko juhuc gie bafickeme ine eki bâmec bacnezejec, â qâqâhâc-jeŋickonec mi rozejec, qâqâhâc-jeŋic i hozec waha qaqane jaŋere ezejec. ");
INSERT INTO kmg_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Soŋaŋzi gie-jeŋic bapie biaŋkeme wiac bafehuc ehâmo-jarezo, ine miti mumu â qaqazu gie paŋšâic baeŋgopieŋ jaŋe hâcne iŋuc ejarezo. ");
INSERT INTO kmg_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Miti papiao dâŋqâreŋ šiŋuc hâcne fokac: “Bulimakaozi gi bagarehuc sopâc kecɋaŋ nâzo mume mi sakarecnezemec.” Erâ moc šiŋuc: “Gie bapa ŋic e furi fuacneme sâckeocmu.” ");
INSERT INTO kmg_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Ŋic mocjahazi soŋaŋ moc dâŋko râezo mume mi manacnezemec, ŋic 2 me 3 jaŋe mupie ine manarâ giene bazemec. ");
INSERT INTO kmg_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Moczi bahac bâfuame âgo guru jaŋere maio mu bâtiŋ ecnetec gâcne jaŋe manahuc hâwic-jopazejec wâc. ");
INSERT INTO kmg_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","No Anutu â Jesu Kristo ere maio â aŋelo bufuŋfâc-ticne jaŋere maio kecšiŋuc mupaŋke-garekopac: Dâŋ gaza qâmoc ekopac i aimuŋ soŋaŋkehaŋ moc mi wahazejec, ehuc maŋgere ŋic ŋokac wiac sâctiri moc mi ejarezemec. ");
INSERT INTO kmg_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Go ŋic miti giere fâro ehuc biac mi jambuŋ-jopazemec, jaŋere kiŋzi gore faio fezacte. Gahacne maŋ sahac soŋaŋketec ɋaɋacnea fozejec. ");
INSERT INTO kmg_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Go bukiki â huc šâic gâbâ egareekacte opâ sawa mi nâzemec, waiŋ opâ afecne mac nâzemec wâc. ");
INSERT INTO kmg_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Ŋic tucne jaŋere sâqocne i fuŋne babataniŋ dameŋ mi maickeha qanaŋ fua taniŋkeekac, tucne jaŋere soŋsoŋ foku šâhec fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Eme eehâmo gie i iŋuc jaha fua taniŋkeekac, â iŋuc mi eekacko soŋsoŋ foku šâhec fua taniŋkeocmu. ");
INSERT INTO kmg_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Kiŋaŋ qaqa juŋgopieŋ jaŋe sasawa bomboŋfâc-jeŋic sâsec-jopahuc rume-jarenšepieŋ, Anuture šâŋe biŋe babawaha â miti susure fuazacte iŋuc enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Erâ bomboŋfâc-jeŋic gâcne opâ ruac jaŋe ine šiŋuc mi muhuc bawahac­ jopanšepieŋ: “Mitio sâcnâŋec mocjaha eŋgopeneŋ.” Aricne, “bomboŋfâc-nâŋec jaŋe Wofuŋ manasiŋkepie âgo jauŋ ejareekacte ehâmo-nâreeŋgopieŋ”, iŋuc muhuc kiŋaŋ maŋafec jaha qajarepie sâckeocmu. Go dâŋ i jaza mutâc ehuc faŋ qajarezemec. ");
INSERT INTO kmg_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Moc e dâŋ i âke sipurâ moc muhuc Wofuŋ-nâŋec Jesu Kristo ere dâŋbiaŋ qikiŋnehuc miti hatare sâcmutâc râpeckeekac ere šiŋuc muzo: ");
INSERT INTO kmg_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","E maŋgâc erâ sahac-ticne bafehuc dâŋ giŋkeme giŋ bašihuc muraocmu, izi sasec-ticne eocmu hâcne. Eme irec iiŋguuŋ, hehefaric, mumusoriŋ, qoqoric, ");
INSERT INTO kmg_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","erâ wâc mu qaqatarac hati fuaekac. Ŋic iŋucne jaŋe maŋjeŋic sifuckerâ mamana-jeŋic šikeme, moneŋ mafa fua-nârezejec muhuc miti bajuniŋte mueŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Miti babajuzi jâmbomac sahacte dope bâbâfua-nârene, mocjaha mukâroŋ tâmiric bajunšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","šiŋuc manasunšepeneŋ: Fuanaŋte mâreŋko metariŋ warembeŋ, juku hâmonaŋte iŋuc jaha metariŋ jaha ranaŋmu. ");
INSERT INTO kmg_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Eme irec hâcne nânâ wiac â ŋaqi qoruc fonâreme manapene sâckeha junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Moneŋ mafa sâko qâhâckezo muniŋmu, jaŋe eesâicte wiwiticko feniŋmu, erâ wiac omane fuŋne fuŋnere sasec bâfuarâ mana utuckehuc sipirickeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Moneŋ mafare andaczi sâqocne gâcnere jâcne hâcne. Ŋic tucnezi irec harac ehuc miti hata qâsorierâ bušâic sâko bâfuambiŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Anuture ŋic go wiac iŋucne geŋkezemec. Ehuc tiŋke biaŋ erâ mitihec â mamanasiŋhec â maŋjauŋhec â sasanaŋhec â buuruchec ecmurâ irec fotac qatariezemec. ");
INSERT INTO kmg_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Erâ mamanasiŋte juju gie biaŋ bazemec. Baku juju sanaŋte hešakiezemec. Go irec hâcne hefârecgukicne, erâ go gahac iŋuc ecmurâ ŋic tutumaŋko mupaŋketec manambiŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Anutu wiac sasawa juju bâfua-jareekac ere maio â Jesu Kristo kia Pilatorao mumupaŋ fârine muwec ere maio musanaŋke-garekopac: ");
INSERT INTO kmg_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","Go sâcmutâc dâŋ mugarekicne i bâbâsifuc tâmiric â bâbâbiene tâmiric reŋkehuc juhaŋte Wofuŋ-nâŋec Jesu Kristo fisizejec. ");
INSERT INTO kmg_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Irec dameŋ maickeme juju aŋac â tâpiri buc focneekac Anutu hâcne, eki motâc rome fua taniŋkeocmu. E ŋicwofuŋ jaŋere Wofuŋ Sâko â fekicne jaŋere Fekicne. ");
INSERT INTO kmg_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","E bucticne hâhâmo tâmiriczi, tatamac moczi moc mi rarašine irec maŋnao juekac. E ŋic moczi moc mi honekicne erâ mi honezo. Mumumbiaŋ â tâpiri focneweczi focnehuc juocmu sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ŋic mâreŋte moneŋ mafa ɋâfoŋne fojarekac jaŋe jazatec sahac-jeŋic mi bafehuc wiac sisirowenere manapie izi hobeteŋne-jeŋic eme ira mi âtesiŋnenšepieŋ. Anutu e mâriri bâfua-nâreme nâ bac ehuc jueŋgopeneŋ erao âtesiŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Erâ mu jaretec buafec â bokifac erâ eehâmo gie bahuc mitire fârine bocjaha bâfuanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Ehuc hobeteŋne-jeŋic moc fofo sanaŋ i bâfuarâ juju fârine rauckenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","O Timoteo, go merâfâc garekicne i soŋaŋkehuc bajuzemec. Erâ dâŋ jawane â fârimâc, ŋic gâcnezi bajuhuc šâŋene “dâŋ qame hukicne” mueŋgopieŋ, i qikiŋnezemec. ");
INSERT INTO kmg_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Ŋic tucnezi dâŋ ira hâcne qohotahuc mamanasiŋte hata qâsoriembiŋ. Aki anonoczi ŋoŋerao fozejec. ");
INSERT INTO kmg_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Paulo no Anuture micte, Kristo Jesuzi juju bâfuawec irec biŋedâŋ muiŋnepemurâ Kristo Jesure aposolo epozi ");
INSERT INTO kmg_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","Timoteo motec biaŋ-nane gore papia ši qâreŋkekopac. Anutu Mamac â Wofuŋ-nâŋec Kristo Jesu eraonec aki anonoc, uruc jauŋ â wama gorao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Mamac ŋosafâc-nane jaŋe maŋfâsâc juhuc tuczi tuc Anuture kiŋaŋ qawarekupie ɋâric-jeŋic noni iŋuc jaha eekopaczi daŋge âzâcnehuc nunumuo šušuhuc ŋafe furec manasucguhuc juekopac. ");
INSERT INTO kmg_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Nore ki busâqoc emeŋ, irec manasurâ honecguhuc bubiaŋ sâko manapemurâ enareekac. ");
INSERT INTO kmg_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Erâ mamanasiŋ fârine fogarekac, irec wâc manasuekopac, mamanasiŋ i hâcne mimige Loisi â neŋgocge Eunike jaherao foweczi gorao wâc fotâcnewec fokac i manakopac. ");
INSERT INTO kmg_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Eme no irec hâcne manasu-gararâ mupe: No menane qizecgao râepe Anutuzi jambuŋ tahacguwec i hehâroŋketec šocne fuazejec. ");
INSERT INTO kmg_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Ehuc šiŋuc manasuzemec: Anutu e hâbi-nâŋec goroŋkeocte mâro mi nârewec, tâpirihec â maŋ jauŋhec â maŋsowahec enaŋte nârewec. ");
INSERT INTO kmg_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Irec go Wofuŋ-nâŋecte biŋe mutaniŋkecmurâ mimi gaŋgaŋ mi ezemec, erâ kâpâcwâru ŋicticne nore dâŋ mucmurâ acmeruŋ wâc mi ezemec. Go Anutuzi tâpiri gareme sâc no qâsuecnurâ Biŋebiaŋte erâ šârâ hâriŋ faio juzemec. ");
INSERT INTO kmg_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Eki hâcne bâpiaŋ-nâporâ tiridâŋ-ticnezi hefârec-nâpowec. I biaŋ-nâŋecte mâcne, e jahac maname fowecte aki anonoc-ticnere erâ iŋuc enârewec. I mârâc jaha jâmbâŋ Kristo Jesure erâ biŋe qanârekicne. ");
INSERT INTO kmg_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Eme fârine fufua ine dameŋ ši bâbâpiaŋ-nâŋec Kristo Jesu wahame fua tâcnewec. Eki hâcne hâmoc qâmizierâ juju â wiac fofo sanaŋ Biŋebiaŋko bajaŋgeŋke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Eme no irec biŋe mumu â aposolo â qaqazu jupemurâ munarekicne. ");
INSERT INTO kmg_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","No irec hâcne šârâ hâriŋ faio juekopac, ehuc mi mimieekopac. No manasiŋkeekopac ere maŋjahec mi eekopac, aricne, no šiŋuc manapaŋkeekopac, e tâpiriheczi šeŋaŋ-nane sâcne soŋaŋke-narehame dameŋ sâko maickezokac. ");
INSERT INTO kmg_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Dâŋ fârine irec biri-ticne qazu-garepo ijaha bâjâpezemec, i Kristo Jesu manasiŋkehuc â maŋzi jauŋkehuc iŋuc ezemec. ");
INSERT INTO kmg_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Tiri Mâro maŋnâŋecko juekac eki neŋgoc ŋegarehame miti kâdoc qârârie-garekicne, i aimuŋ soŋaŋketec fogarezejec. ");
INSERT INTO kmg_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Asia mâreŋko behecnu-fârembiŋ i manameŋ, Figelo â Hemogene jahe mâmâc. ");
INSERT INTO kmg_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Wofuŋ e Onesiforo ere wiacfâc maŋuruc qajarezejec. Mamac-jeŋiczi kâpâcwâru ŋic nore mi takickeha bubiaŋ hati qanarehuc juwec. ");
INSERT INTO kmg_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","E Roma haeo fisirâ šoɋac basacnuku bâfuacnuwec. ");
INSERT INTO kmg_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Wofuŋzi manaha dameŋ sâko Wofuŋtao uruc jauŋ bâfuazejec. E Efesoo wâc kiŋaŋ qaqa gie wemo afecne bawec i go gahac hone manac emeŋ. ");
INSERT INTO kmg_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Kristo Jesuzi aki anonoc tahacguwec i go motec-nanezi bajuhuc qabocge qame huzejec ");
INSERT INTO kmg_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Ŋic bocjahazi hone manac ehapie gie gaza gowatuc epo, gie i hâcne ŋic tucne Wofuŋte hatao jueŋgopieŋ â miti munusuŋkeniŋte tâpiri fojarekac iŋucne jaŋe qazu-jaretec banšepieŋ wâc ");
INSERT INTO kmg_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Go Kristo Jesure momori ŋic sanaŋne juhuc irec šârâ hâriŋ kâdocge rocmurâ mi takicguzejec. ");
INSERT INTO kmg_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Moc e momori gie baocmuzi wemocko sahackopec gie fuŋne fuŋne ameckeocmu. E momori jaŋere birio râeweczi wiac honeme sâckeocmu i sawa eocte muocmu. ");
INSERT INTO kmg_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Moc e sisiric gie bahuc sâcmutâc qâsuaocmuzi furine mi roocmu. ");
INSERT INTO kmg_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Moc e he sarac ehuc šâic-ticne manaocmuzi nânâ fârine micne barâ bâsurâ nâme sâckeocmu. ");
INSERT INTO kmg_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Dâŋ gazakopac i manatâc qâtâc ezemec. Wofuŋ eki maŋge bâwiŋkeme mana tara-fârezemec. ");
INSERT INTO kmg_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Go Jesu Kristore mamanac juzemec” e Dawidire ɋâriczi hâmockonec ɋârerâ faharewec” Biŋebiaŋ-ticne iŋuc hâcne muekopac. ");
INSERT INTO kmg_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Biŋebiaŋ irec erâ šâic fâro manaekopac, erâ wâc sâqocne bapa iŋucne niŋgiŋnumbiŋ ŋekopac Anuture dâŋ ine mi niŋgiŋkekicne. ");
INSERT INTO kmg_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","No šâic gie sasawa i Anutu bâwosâefâc-ticne jaŋere erâ ŋetâcneekopac, jaŋe Kristo Jesure bâbâpiaŋzi ŋihe umbiŋ ejareha eri tatamac fofone mâmâc rauckeniŋte iŋuc eekopac hâcne ");
INSERT INTO kmg_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Dâŋ šiŋuc fokac i jâmbomac: Ere hâmocko šuhuckembeŋko juju-ticnao iŋuc jaha šuhuckenaŋmu, ");
INSERT INTO kmg_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","šâic mana takirenaŋmuo ehec guriŋ bapa gie wâc banaŋmu. E mic banaŋmuo eki iŋuc jaha mic bacnâpoocmu. ");
INSERT INTO kmg_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Mumupaŋ-nâŋeczi dockeocmuo ere mumupaŋzi sanaŋkeocmu. Moc murâ moc mu i erao mi fokac. ");
INSERT INTO kmg_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Go dâŋ i heɋâre-jarerâ Anuture maio mujomirehuc jaza sanaŋketec dâŋ racnere mu iigoc mi enšepieŋ. I wiac fârimâc, iŋuc ehuc miti mamana sipiric-jopaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Anutuzi mana-gareme sâckeocte šoɋachec juhuc giege bazemec, ehuc dâŋ fâri qizecne fâretiŋ jaha mujaŋgeŋkehuc jutec mimizi gieŋic gore faio mi fezejec. ");
INSERT INTO kmg_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Á dâŋ jawanere ojowane bapie mi bafic-jopazemec. Iŋuc eeŋgopieŋzi eraku miti beheniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Burecdâŋ-jeŋiczi biac wicbâroŋ iŋucne erâ ŋedâmâreocmu. Ŋic iŋucne jaŋeraonec moc Himenaio â moc Fileto. ");
INSERT INTO kmg_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Jahe dâŋ fâri beherâ mukopirec, fafahare i biac fuawec. Iŋuc muhuc ŋic gâcne miti ba imac ejarekopirec. ");
INSERT INTO kmg_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Anutuzi qânâ wâtuŋ râeme huwec ine qiŋ herâ domakac. Maqâreŋ-ticne šiŋuc fokac: Wofuŋzi biŋefâc-ticne šâŋitac-jopaekac Erâ moc šiŋuc “Wofuŋte šâŋe bajuŋgopieŋ jaŋe šeŋgoma bâbâsifuc râpeckenšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Ufuŋ sâkoo râqâc wiac goì â siliwazi bakicne i sawa mâcne, jâczi â mâreŋzi bakicne i mâmâc ŋekac. Râqâc gâcnao wiac furi sâkozi huocmu. gâcnao wiac omanezi huocmu. ");
INSERT INTO kmg_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Moc e bâbâsifuc wiac qikiŋneme maŋne ɋaɋackeme râqâc furi sâko eme ufuŋ runezi jambuŋkerâ bajuhuc izi gie biaŋ fuŋne fuŋne baocmu. ");
INSERT INTO kmg_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Socɋârizi wiac fuŋne fuŋnere andac eeŋgopieŋ i bâec bazemec. Ehuc maŋjeŋic biaŋkekicnezi Wofuŋ mu wâwâsic ecneeŋgopieŋ jaŋe bafic-jopatec tiŋke biaŋ eere â mamanasiŋte â maŋjauŋte â wamare henširiŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Mugufuc dâŋ mutucne â racne igockezemec, irec fârine mu qaqatarac sawa fuaekac i manakic. ");
INSERT INTO kmg_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Wofuŋte kiŋaŋŋiczi mu hehefaric mi ezejec, e ŋic sasawa âgo ejarehuc miti micafec qazu-jarezejec, â pepecne ecnepie wiac aaricko mi ejarezejec” ");
INSERT INTO kmg_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","erâ ŋic maŋrâŋgeŋ ine urucko mu bâtiŋ ejareme Anutu e jahac moc bawahac-jopame maŋjeŋic bârisierâ dâŋfâri šâŋitanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Eme maŋjeŋic uŋtome, Sataŋte dâŋ reŋkeniŋte wiwitic-ticnao kicjopawec i hetaranšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Go šiŋuc manazemec: Dameŋ tarazo eha sâqocnezi sawe mâririackeocmu. ");
INSERT INTO kmg_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Ŋic kecšiŋucne juniŋmu hâcne: Jaŋe jaŋacnere sawa manoniehuc juju, moneŋ sasec, ruruc bâbâcne, sahac mumuteŋ, musurecne, neŋgoc mamac dâŋ qaqatara, nâme nikecne, araŋ bapa tâmiric, ");
INSERT INTO kmg_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","maŋjauŋ tâmiric, kiŋ babaju, micko âkechec, nâ areŋne, qicqucne, wiac biaŋne qaqaisoc, ");
INSERT INTO kmg_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","docbapa, enšaŋaucne, pepecne, sasecte aŋac kâcɋene bajuhuc Anuture aŋac mi mamana, ");
INSERT INTO kmg_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","sahaczi miti hawari juhuc mitio sasanaŋ tâmiric juju. Iŋucne hâcne jupie honec-joparâ râpec-jopazemec. ");
INSERT INTO kmg_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Ŋic mukopac jaŋeraonec tucnezi kamierâ ficbiri juhuc ŋokac kosane, bahac fuŋne fuŋne bâfuambiŋ â saseczi ejareme ra qa ware qa eeŋgopieŋ, iŋucnezi jaŋere eniŋte mu bâdoc ejareeŋgopieŋ” ");
INSERT INTO kmg_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","ŋokac dameŋ sâc mamana gie bahuc dâŋ fâri qizecnere fuŋne mi mana taraeŋgopieŋ iŋucne hâcne. ");
INSERT INTO kmg_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Mârâc jaha Jaŋe â Jambere jahe Mosere dâŋ bawahapic, iŋuc jaha ŋic mukopac jaŋe maŋjeŋic sifuckekicnere mamanasiŋte hata kâuc bahuc mutuc eeŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Erâ wiac eejeŋic wemocko boc efeniŋmu. Mutuc-jeŋicte fuŋne taniŋkeme ŋic sasawa hone-fâreniŋmu, Jaŋe Jambere jaherao fuawec iŋuc. ");
INSERT INTO kmg_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Go jupe juju-nanezi ine miti mumu-nane, juju-nane, giebapa-nane, mamanasiŋ-nane, buuruc-nane, maŋjauŋ-nane, sasanaŋ-nane, ");
INSERT INTO kmg_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","fific guguriŋ-nane â šârâ hâriŋ-nane, irec hatane âtehuc bâjâpecnuekic. Antiokia haeo â Ikonioŋ haeo â Listera haeo fific guguriŋ enarepie šâic serereŋ mo iŋucne manapo¡ Eme Wofuŋzi sifu wiac iŋucnaonec bataracnuwec. ");
INSERT INTO kmg_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Erâ ŋic gâcne wâc Kristo Jesurao qohotahuc miti hata âteniŋmu jaŋe mâmâc fific guguriŋ fua-jare-fâreocmu. ");
INSERT INTO kmg_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Ŋic repicne â eeatucne jaŋe ine jaŋacnao â gâcne jaŋerao eeatuc gie bafeku repire sanaŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Go ine dâŋ qazu-garekicne â maŋge ekicne ira qohotahuc juzemec. Dâŋ moraonec romeŋ i kâuc mi bakomec. ");
INSERT INTO kmg_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Erâ go ɋieocnecteaŋ tiri papia wose manac ewefuhuc juekicte izi maŋge batamaeha Kristo Jesu manasiŋkehuc bâbâpiaŋ sâcne bâfuacmu. ");
INSERT INTO kmg_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Miti papia i Anutu Mâro-ticnere qafeŋko fua-fârewec, eme irec wose manac epene mitire fuŋne qazu-nâreekac â mu tutuc enâreekac â mu bâtiŋ enâreekac â tiŋne hata nâwotuekac. ");
INSERT INTO kmg_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","Iŋuc enârehuc bašawiec-nâpokume nâŋâc Anuture ŋicfâri erâ eehâmo gie fuŋne fuŋne sâcne bâfuanaŋmu. ");
INSERT INTO kmg_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","No Anuture maio â Kristo Jesu, juku Wofuŋ tâpirihec fisirâ ɋâricne â hâmokicne dâŋnâŋec mutaraocmu, ere maio gazapaŋkepe manac: ");
INSERT INTO kmg_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Go miti muminširiŋkezemec, ehuc ŋic irec ejareha me mi ejareha ɋicwânšâŋ jaha jazazemec. Erâ ŋic mu tutuc â mu bâtiŋ â mu sawaŋ ejarehuc qaqazu giege uneŋko tatakic tâmiric bazemec. ");
INSERT INTO kmg_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Juku dameŋ moc maickeme miti riucdâŋ manapie joŋtaweme qikiŋneniŋmu. Qikiŋnerâ miti hazecte nâpene-jeŋic sawa eme qaqazu mana wosâc ejarepie maŋjeŋic sâckeme iŋucnea guruhec rocjopaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Ehuc mitidâŋ fârine râpeckerâ nemu binaŋko qohotaniŋmu. ");
INSERT INTO kmg_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Go ine dameŋ sâc maŋtiec juzemec, šârâ hâriŋzi faigao feme sanaŋkezemec, Biŋebiaŋ muromackezemec, gie mugarekicne i basarickezemec. ");
INSERT INTO kmg_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","No ine biac due bazo ekopac, rara dameŋ-nane bembeŋkekac. ");
INSERT INTO kmg_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","No juju gie biaŋ batarakopac, hata-nane âte wareku mao fisikopac, mamanasiŋ-nane soŋaŋkehape mi ŋeŋgoroŋkewec. ");
INSERT INTO kmg_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Eme ši sambâŋte eri hendiŋ biŋe-nane râekicne fokac, i juku dameŋ sâkoo Wofuŋ, mumutara tiŋne eki narezokac, erâ no sawa mâcne, fifisi-ticnere aŋac-jopaha jueŋgopieŋ jaŋe mâmâc jarezokac. ");
INSERT INTO kmg_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Go fâro barâ norao biac warezemec. ");
INSERT INTO kmg_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Dema e mâreŋkopec wiac irec mana kikiwerâ behecnurâ Tesalonike haeo fâwec, Kereske e Galatiao rawec, â Tito e Dalimatia mâreŋko fâwec. ");
INSERT INTO kmg_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Ʒi Lukahec buc jukoperec. Mareko jowatec mâmâc warezepirec. E giere sâcne baficnuocmu. ");
INSERT INTO kmg_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Tikiko ine sorepe Efeso haeo fâwec. ");
INSERT INTO kmg_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Warezo ehuc hata ŋaqi-nane Troa haeo Karpo ere ficko hetarapo i bawarezemec, erâ papia-nane qizecne â rehacne mâmâc amecke warezemec. ");
INSERT INTO kmg_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Aeŋzi wiac bapa ŋic Alesande e sâqocne bocjaha enarewec, irec Wofuŋzi juku okacne bazucneocmu. ");
INSERT INTO kmg_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Dâŋnâŋec mâretec ro waha âte ewec. Go ere sawaŋge qazemec. ");
INSERT INTO kmg_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Dâŋgie-nane bâbâni fuawec dameŋ ira âgo moczi dâŋte mi baficnuwec, aricne, jaŋe behecnu-fârembiŋ” kiŋjeŋic mi fojarezejec. ");
INSERT INTO kmg_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Wofuŋ eki ine miti musawe tarape qâpuc jaŋe mana-fâreniŋte dopecnurâ basanaŋnuwec, ehuc laioŋte mickonec bataracnuwec. ");
INSERT INTO kmg_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Wofuŋ e sâqocne irec me irec ŋezicnurâ sambâŋ uucmaŋ-ticnao râecnuocmu. Erao eri tatamac forahuc juzejec sanaŋ. Jâmbomac. ");
INSERT INTO kmg_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","No Prisika â Aqila â Onesiforo wiacfâc-ticne mâmâc manasu-jare-fârekopac, i jazazemec. ");
INSERT INTO kmg_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erasto e Korinti haeo juwec â Trofimo e huc bame Milete haeo hetarapo. ");
INSERT INTO kmg_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Go hoemaŋ dameŋ mi maickeha biac warezemec. Eubulozi manasu-garekac, erâ wâc Pudeŋ â Lino â Klaudia â âgo sasawa jaŋe iŋuc jaha manasu-gareŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Wofuŋzi maŋ qâqâtâcgehec juzejec. Aki anonoczi ŋoŋerao fozejec. ");
INSERT INTO kmg_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Paulo, Anuture kiŋaŋŋic â Jesu Kristore aposolo, no gie munarekicne i Anuture bâwosâecfâc jaŋe mamanasiŋhec eniŋte â dâŋ fâri qizecne mitio fokac i mana taraniŋte” ");
INSERT INTO kmg_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","ehuc juju sanaŋte biŋedâŋ, Anutu burec tâmiriczi mârâc jaha dameŋ mi fowecko muwec, i manahuc juju sanaŋ worickehuc juniŋte. ");
INSERT INTO kmg_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Dâŋticne i hâcne dameŋ-ticnao mufuahuc Anutu bâbâpiaŋ-nâŋeczi noni muromackepemurâ mupaŋke-narewec. ");
INSERT INTO kmg_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Eme mamanasiŋ wirec fonârekacte motec jâmbâŋ-nane jukomec Tito go hâcne papia ši râe-garekopac. Anutu Mamac â bâbâpiaŋ-nâŋec Kristo Jesu eraonec aki anonoc â wama gorao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Gie tofane fokac i bataracmurâ Kreta nucko hetaracgupo, irec gazapo iŋuc ehuc hae sâc soŋaŋ râec-jopa razemec. ");
INSERT INTO kmg_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Ŋic moc bahac fâsâc â ŋokac mocjahahec juocmu, erâ naru motecfâcne mitihec â šaubac tâmiric â pepecne tâmiric juniŋmu, ŋic iŋucne râec-jopazemec. ");
INSERT INTO kmg_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Micne bapa moc e Anuture gie soŋaŋkeekaczi bahacmâc juzejec, ehuc pepecne tâmiric â šâšâicne tâmiric â waiŋ âmbâŋ mi nânâ â šikare aafec tâmiric â moneŋ mafare sasec tâmiric, iŋuc juzejec. ");
INSERT INTO kmg_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Erâ jauŋhec â wiac biaŋne sasawa dodopecke â wama ruaine, tiŋne, araŋ bapanehec â sowa bâtâchec juzejec. ");
INSERT INTO kmg_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Mitidâŋ mu qaqazuc ehuc hatane basanaŋkekicne i paŋnea bajuzejec. Eme izi tâpiri râcneme dâŋ fâri biaŋ ŋic qazu-jarehuc mu sawaŋ ejarezejec â miti âke sipueŋgopieŋ jaŋere dâŋ bawahazejec. ");
INSERT INTO kmg_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Ŋic bocjahazi râŋgeŋne â dâŋ racne mumu â eeatuc-jeŋichec juŋgopieŋ, Judaŋiczi opâ ruac jaŋerao wemo afecnezi iŋuc juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Ŋic izi hâcne moneŋ mafare erâ, mumusifuc-jeŋic qatarakicne i musawehuc garikiŋ gâcne furu jaha ba sipiric ejareeŋgopieŋ” ŋic iŋucne jaŋere mic qâbâzickezo. ");
INSERT INTO kmg_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Kreta jaŋacne porofete moczi šiŋuc muwec: “Kreta ŋic jaŋe burec hati, qowi mimicne â wiac âmbâŋ nânâ.” ");
INSERT INTO kmg_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","No dâŋ i manape jâmbomac ekac. Irec go mu bâtiŋ sanaŋne ejaretec mamanasiŋzi bâɋârec-jopame ɋiɋic qanšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Ehuc Judaŋic jaŋere mamana gufuc dâŋ racne â ŋic dâŋfâri râpeckembiŋ jaŋere sâcmutâc dâŋ mi mananšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Maŋɋaɋachec jueŋgopieŋzi wiac sasaware manapie ɋaɋacne eekac. Á sâqocnezi maŋjeŋic bâbiekume mamanasiŋ tâmiric embiŋ jueŋgopieŋ, jaŋe ine mamana â maŋjeŋic mâmâc wâwânâŋhec efârewecte wiac mocte manapie ɋaɋacne mi eekac. ");
INSERT INTO kmg_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Jaŋe, Anuture fuŋne manaeŋgopeneŋ, miczi iŋuc muhapie eebapa-jeŋiczi ine mickeekac. Jaŋe ŋic mamakâcne â dâŋ qaqatara, â gie biaŋne moc bapanere sâc mâcne. ");
INSERT INTO kmg_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Go ine miti riucdâŋ fokac irec sâcko jaza mutâc ezemec. ");
INSERT INTO kmg_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Ehuc mutec ŋic kâcɋene jaŋe sowa bâtâc â metâne â wama ruaine jupie mamanasiŋ â maŋjauŋ â maŋuruc furu fojarezejec. ");
INSERT INTO kmg_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Erâ ŋokac kâcɋene iŋuc jaha jazatec miti ŋokac fârine erâ gupe micko âkec tâmiric â nârâmbe tâmiric juhuc juju biaŋte qaqazu enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Ehuc ŋokac socɋâri jaza mutâc epie ŋowe ɋiefâc-jeŋic jauŋ biaŋne ejarenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","Erâ mimihec erâ sasec tâmiric juhuc nâ qofac â wiac bâpiaŋke emasaŋ ehuc ŋowefâc-jeŋic sâsec-jopanšepieŋ. I Anuture dâŋ susure fuazacte iŋuc enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Ŋicmotec iŋuc jaha esoc-jopatec sowa bâtâc-jeŋichec junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Ehuc go gahac wiac biaŋne sasawa irec micne bajarehuc eehâmo gie batec honerâ bâjâpecgunšepieŋ. Miti mutiŋnehuc â bâmâckehuc jazazemec. ");
INSERT INTO kmg_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Erâ hata sanaŋ fokac irec sâcko musaricketec kisâ jaŋere maŋ henšaŋneme jaŋe burec enâreniŋte dâŋ basarâ behenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Kiŋaŋ qaqa jazatec bomboŋfâc-jeŋic jaŋere dâŋ reŋke-fârehuc kiŋaŋ biaŋne qajarenšepieŋ, ehuc micjeŋicko mi ronšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Erâ fiuc serereŋ tâmiric juhuc wiac-jeŋic hone qâzuc ehâmonšepieŋ. Iŋuc ehuc bâbâpiaŋ-nâŋec Anutu dâŋticne ba eric ecneniŋmu. ");
INSERT INTO kmg_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Mâreŋ sâc ŋic biaŋkenaŋte Anuture aki anonoczi bâtâcne bâtimuŋ ewec. ");
INSERT INTO kmg_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Erâ izi bâfiriec-nâpohuc bâtiŋ-nâpohame qâpuc hata â wiac jawanere andac i qikiŋnerâ mâreŋ šira wama ruaine â tiŋne â mitine junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Iŋuc juhuc Anutu sâko â bâbâpiaŋ-nâŋec Kristo Jesu ere eri tatamac fua tâcneme juju aŋacko fisinaŋte irec mamanac junšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Eki hâcne nâŋâcnere due bahuc sindaŋkonec bâhoc-nâpowec, erâ fuŋfuŋfâc-ticne juhuc mitire fârine šoɋac erâ bâfuanaŋte šure bâpiaŋ enârewec. ");
INSERT INTO kmg_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Go paŋšâic erâ dâŋ i hâcne jazahuc mu sawaŋ â mu bâtiŋ ejarezemec. Ŋic jaŋe go mi hucgunšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Go dâŋ heɋâre-jarehuc jazatec ŋic jaŋe kia gawamaî â fekicne araŋ bajarehuc dâŋjeŋic reŋkenšepieŋ, erâ gie biaŋne fuŋne fuŋne fokac irec afeckerâ banšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Erâ mumusoriŋ â dâŋ mumuc mi enšepieŋ. Aricne, wamane juhuc ŋic maŋuruc ejare-fârenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Nâŋâc mârâc jaha iŋuc jaha maŋmutuc erâ râŋgeŋne juhuc qac qâsoric ejumbeneŋ. Erâ sasec fuŋne fuŋne irec kiŋaŋ qahuc sindaŋ â iiŋguuŋ bâfuarâ mamakâcne erâ kikisuec ejumbeneŋ. ");
INSERT INTO kmg_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Izi šâhec ine bâbâpiaŋ-nâŋec Anutu uruc jauŋ â buafec-ticne fua tâcneme ");
INSERT INTO kmg_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","eki nâŋâc tiŋne juhuc gie moc bambeŋte mâcne, buuruc-ticnere erâ juju ɋârire opâzi â Tiri Mâroraonec fufua ɋâricnezi bâpiaŋ-nâpowec. ");
INSERT INTO kmg_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","E bâbâpiaŋ-nâŋec Jesu Kristore erâ Tiri Mâro afecne mi qoŋgiŋke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","I nâŋâc Kristore aki anonocte erâ kiŋnâŋec fâsâeme juju sanaŋte mamanac juku rauckenaŋte iŋuc enârewec. ");
INSERT INTO kmg_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Dâŋ i jâmbomac, eme go ɋicwânšâŋ erâ âkendâŋnetec Anutu manasiŋkeeŋgopieŋzi eehâmo gie baniŋte šoɋac enšepieŋ. I wiac biaŋne, i epie ŋic jauŋ bacjopaocmu. ");
INSERT INTO kmg_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Á mugufuc dâŋ jawane â fuŋne qaqa dâŋbiri â sâcmutâc dâŋte mu qaqatarac â bac bârisic ine geŋkezemec. I wiac racne â fârimâc. ");
INSERT INTO kmg_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Ŋic hâme âkefâucne moc uŋdâŋ mocjaha me jajahec âzâcnetecne qikiŋneme behetec buc juzejec. ");
INSERT INTO kmg_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Go manakic, ŋic iŋucne e qaqaharicne, maŋnezi mumu hehec ecne-bipieha sâqocne baekac. ");
INSERT INTO kmg_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","No Atema me Tikiko sorepe gorao fâ fisime biac Nikopoli haeo ware bâfuacnuzemec, no hae ira hâcne hoemaŋko juzo mukopac. ");
INSERT INTO kmg_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Sâcmutâc mamana ŋic Ʒena â Apolo jahe miti kiŋaŋ ranicte nânâ mafa wiac bâmocke-jactetec wiac mi basahuc bititiezepirec. ");
INSERT INTO kmg_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Ŋicfâc-nâŋec jaŋe wâc eehâmo gie baku maŋjeŋic ezejec, eme sahacte dope babasa fuaocmu sâc jauŋ gie bapie miti-jeŋiczi fârinehec ezejec. ");
INSERT INTO kmg_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Ŋic nohec jueŋgopieŋ jaŋe sasawa go manasu-gareŋgopieŋ. Mitio âgo enâreeŋgopieŋ jaŋe manasu-jareŋgopeneŋ irec wâc jazazemec. Aki anonoczi sâcŋopa-fârezejec. ");
INSERT INTO kmg_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Paulo, Kristo Jesure kâpâcwâru ŋic no, â âgo-nâŋec Timoteo, nâhe Filemoŋ joroc babafic-nâhec gore papia ši râekoperec” ");
INSERT INTO kmg_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","erâ wâc ŋokac âgo-nâhec Apia â momori âgo-nâhec Akipo, erâ Filemoŋ gore ficko mitire tumaŋneeŋgopieŋ ŋoŋere mâmâc râekoperec. ");
INSERT INTO kmg_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Mamac-nâŋec Anutu â Wofuŋ Jesu Kristo eraonec aki anonoc â wama ŋoŋerao fotâcnerâ fozejec. ");
INSERT INTO kmg_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","No nunumuo gore manasuhuc sâc Anutu-nane daŋge âzâcneekopac. ");
INSERT INTO kmg_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","Go Wofuŋ Jesurao â mitiŋic jaŋerao maŋge domakac â jaŋere mamanac juekic irec biŋe manakopac hâcne. ");
INSERT INTO kmg_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Eme go mamanasiŋko nâŋehec maŋ mocjaha emeŋte wiac biaŋne Kristoraonec fua-nârewec fokac i sasawa mana taracmurâ numuekopac. ");
INSERT INTO kmg_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Âgo-nane,go mitiŋic bubiaŋ qajareekomec, irec no maŋjauŋgere bunane urueme wemo afecne šeri epo. ");
INSERT INTO kmg_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Go wiac ecmurâ i no Kristore micte mupaŋke-garezo murâ sâcne afeckerâ ezapo, ");
INSERT INTO kmg_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","erâ sifu maŋjauŋte erâ mâc mu hemunaŋ egarehuc mupe” ŋicqizec Paulo no hâcne, erâ dameŋ ši wâc Kristo Jesure kâpâcwâru ŋic epozi, ");
INSERT INTO kmg_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","no motec-mae Onesimo, kâpâcwâru ficko juhape fua-narewec, ere gazakopac. ");
INSERT INTO kmg_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","E mârâcko jugareme mi sâckewec, ši ine no â go mâmâc junâcteme sâckekac. ");
INSERT INTO kmg_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Buhândâŋ-nane e hâcne sifu bârisie-garepe fakac ");
INSERT INTO kmg_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","No Biŋebiaŋte erâ kâpâcwâru ficko ŋehape gore âkehoc kiŋaŋ qanareocte sakarezo mupo. ");
INSERT INTO kmg_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Erâ go mi manahaŋtecne sakarepe urucko mâcne, jâiŋko qikiŋne-narezicte manabâc ehuc bârisie-garekopac. ");
INSERT INTO kmg_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Behecgume e tâmiric piticne jumeŋ, i fuŋne šiŋucte mecne, risie-garerâ gohec jusanaŋkeocte. ");
INSERT INTO kmg_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Kiŋaŋ qaqage sawa mâcne, mitio âgoge erâ juocte fagarekac. No hâcne iŋucne junarewec, â go ine fehuc jugareocmu i šiŋucte: Sahaczi gore juweczi Wofuŋte erâ bufuŋge ekac. ");
INSERT INTO kmg_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Go nore manatec âgoge ekopacko ine e hefârockehuc manatec Paulo hefârockekopac ezejec. ");
INSERT INTO kmg_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Wiac moc sipiricke-garewecko me tofage moc erao fokacko ine nore muzemec. ");
INSERT INTO kmg_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Paulo no hâcne ši qâreŋke-garekopac, okacne bazu-garepemu. No nahacne tofa wâc gorao kâcɋene fokac, noraonec hâcne fuameŋ i” erâ irec wemocte boc mupemu. ");
INSERT INTO kmg_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Âgo-nane, go Wofuŋte erâ wiac buafec tahacnucmurâ enarekac. Kristore erâ bubiaŋ qanarezemec. ");
INSERT INTO kmg_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Go micrereŋge fokac i manahuc dâŋ ši qâreŋke-garekopac. Erâ manakopac, gazakopac i sawa mi ehuc maŋgere gâcne šuhuckecmu. ");
INSERT INTO kmg_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Ŋoŋe nunumuzi bataracnupie Wofuŋzi no bâriesiecnu-ŋareme fâpemurâ mukopac, eme go irec ŋeŋe hewâneŋke-narezemec. ");
INSERT INTO kmg_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Kristo Jesure kâpâcwâru ŋic âgo-nane Epafra e manasu-garekac. ");
INSERT INTO kmg_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Erâ babaficfâc-nane Mareko, Aristako, Dema â Luka jaŋe iŋuc jaha manasu-gareŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Wofuŋ Jesu Kristo ere aki anonoczi maŋŋeŋicko fozejec. ");
INSERT INTO kmg_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","Anutu e mârâc jaha porofete ejareme jaŋe mimiŋnefâc-nâŋec dâŋ hawarine fuŋne fuŋne â hatane fuŋne fuŋne jaza warekuhapie ");
INSERT INTO kmg_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","ine šâhec tataranao, dameŋ šira hâcne, Ŋokâ ecneme dâŋ nâzâwec. ŋokâ e wiac sasawa irec rune juocte mucnewec, ehec hâcne wiac bâfua-fârepic. ");
INSERT INTO kmg_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","Anutu eri tatamac-ticnere qâreŋ erao fuawec fokacte â ju ju-ticnere sâc juekacte tâpiri dâŋticnezi wiac sasawa dope siŋsiŋ ecneha foekac. Eki sâqocne šure bataniŋ gie bafârerâ faic fekicne sâko ere fâreo fewec ŋekac. ");
INSERT INTO kmg_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","Aŋelo hucjopa-fârewec jukac, irec sâcko aŋelo šâŋe siricke-fârehuc šâŋe fekicne hotâckewec. ");
INSERT INTO kmg_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","Anutuzi mo aŋelo mo kecšiŋuc moc âzâcnewec: “Go hâcne ŋokâ-nane, no miŋecgac bâfuacgukopac”? Me kecšiŋuc: “Noni Mamac ecnerâ jupemu â eki Ŋokâ enarerâ juzejec”? ");
INSERT INTO kmg_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Moc ine juku mârâc fufua e mâreŋko râeme wahaocmu irec dâŋ šiŋuc muwec: “Anuture aŋelofâc jaŋe dieŋzi hecne-fârenšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","Aŋelo jaŋere kecšiŋuc mukicne: “E aŋelofâcne hawari-jeŋic bâtikieme mâŋâŋ eeŋgopieŋ, â kiŋaŋ qaqafâcne hawari-jeŋic bâtikieme šocbâruŋ eeŋgopieŋ ");
INSERT INTO kmg_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","Ŋokâre ine šiŋuc mukicne: “Anutu go ŋicwofuŋ ŋeŋege i ŋeŋe sanaŋ ŋerašihuc juocmu, â ŋicwofuŋ gunuge i bâbâtiŋ gunu biaŋ. ");
INSERT INTO kmg_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Go tiŋnere egareekac â hehesic ine râsi ecneekic. Irec Anutu, gore Anutu, eki šeri wokemaŋ rua-garewec, i âgofâcge jaŋere sâc jâuruhuc rua-garewec.” ");
INSERT INTO kmg_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","Moc šiŋuc mucnekicne: “Wofuŋ go fufuŋkenao mâreŋte hobeteŋ râemeŋ, â sambâŋne sambâŋne jaŋe megere qâreŋ. ");
INSERT INTO kmg_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Jaŋe siroweniŋmu, go ine jusanaŋkekic, jaŋe ŋaqi iŋucne raŋɋaŋkeniŋmu. ");
INSERT INTO kmg_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","Ŋaqi iŋucne epie goki bataforiec-jopacmu, eme jaŋe hawari moc eniŋmu. Goki ine juekic ijaha juekic, â jara dameŋge i moc mi taraocmu.” ");
INSERT INTO kmg_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Anutu e mo aŋelo mo šiŋuc moc âzâcnewec: “Ware fâre-naneo ŋehaŋtec râsifâcge guruc-jopape kikegere ââtesiŋ enšepieŋ”? ");
INSERT INTO kmg_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","Aŋelo sasawa jaŋe mârozi kiŋaŋ qaqa, ŋic bâbâpiaŋ rauckeniŋte mukicne jaŋe bafic-jopaniŋte sorec-jopakicne. ");
INSERT INTO kmg_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","Irec nâŋâc ma bâtirinšipeŋte dâŋ manambeŋ i mocwâc paŋšâic mana sakac enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","Aŋelo mickonec dâŋ mukicne i mupaŋkekicne, eme huhucke â qaqatara fuame okacnehec ejujec, ");
INSERT INTO kmg_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","izi wemocko bâbâpiaŋ dâŋ fekicne qikiŋnepene okacmâc foocmu? I Wofuŋ e jahac qanaŋ mufuawec, eme hazec fâri-jeŋiczi manambiŋ jaŋe muwarekupie sanaŋke-nârewec. ");
INSERT INTO kmg_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","Ehame Anutu e jahac wâc mâsi â tâpiri wiac šâŋe furu bâfuahuc dâŋ i dopeckehuc Tiri Mârore taha biaŋ manawec sâc kâdoc qajarehuc feŋeŋ râecnewec. ");
INSERT INTO kmg_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","Hae mâreŋ šâhec fuaocmu, dâŋne muŋgopeneŋ hâcne, i Anutuzi aŋelo jaŋe guriŋne baniŋte mi muwec. ");
INSERT INTO kmg_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","Mitiŋic moczi irec dâŋ mutaniŋkewec ine šiŋuc: “Go ŋic e wemomac-ticnere manasucneekic, â ŋicte ɋâric e wemo-ticnere hone maiŋ ecneekic? ");
INSERT INTO kmg_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","Go dameŋ ŋondeŋ bembeŋne mac aŋelo jaŋere wahamicnao juocte mucnemeŋ, go tatamac â šâŋe biŋezi erickemeŋ, ");
INSERT INTO kmg_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","ehuc wiac sasawa kike-ticnere rurumaŋko râemeŋ.” Anutu e wiac sasawa ŋicte rurumaŋko râewec, i bâtâc mi bahuc wiac furu jaha qikiŋnecne-fârewec ekac. Dameŋ šiŋuczia ine wiac šeŋgoma ŋicte rurumaŋko guruckekicne i mi honeeŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","Jesu ine honeŋgopeneŋ, e dameŋ ŋondeŋ bembeŋne mac aŋelo jaŋere wahamicne juhuc hâmocte šâic manawecte tatamac â šâŋe biŋe tahackekicne hâporâ jukac. E Anutuzi aki anonoc enâreocte mume hâmoc hâtâne ŋic sasawa nâŋâcnere erâ manawec hâcne. ");
INSERT INTO kmg_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","Wiac sasawa irec rune â bâbâfua e naru motecfâcne bocjaha eri tatamac-ticnao jowac-jopaocte manasuhuc bâbâpiaŋ-jeŋicte micne bapa e šâic serereŋ gie baku mao fisiocte mucnewec i sâcke-hâmowec. ");
INSERT INTO kmg_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","Eme maŋfuru bacjopakac e mecne â furu bacjopakicne jaŋe mecne Mamac-jeŋic mocjaha, irec ɋafâc-nane mujareocte maname mi quŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","Dâŋticne šiŋuc hâcne fokac: “No šâŋe biŋege ɋafâc-nane muromacke-jarepe, kikefuŋ guruo šeri mumuteŋ egarepe.” ");
INSERT INTO kmg_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","Erâ moc šiŋuc: “No erao roweckehuc jupemu.” Erâ moc šiŋuc: “Ʒi no erâ Anutuzi ɋie guru narewec nâŋe mâmâc juŋgopeneŋ.” ");
INSERT INTO kmg_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","Eme ɋie jaŋe sahac biuchec sasawa jueŋgopieŋte eki ijaha wâc rowec. I e jahacne hâmoczi hâmoc rune Sataŋ hâcne tâpiri-ticne qame goroŋkewecte, ");
INSERT INTO kmg_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","erâ wâc hâmocte hâhâwiczi niŋgiŋ-jopame dameŋ-jeŋic sâc kâpâcwâru ficko ŋejumbieŋ jaŋe batarac-jopaocte iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","Wiac i aŋelo kime dopec mi ejareekac i, e Abrahamte ɋâricfâc nâŋâc kime dopec enâreekac. ");
INSERT INTO kmg_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","Eme irec hâcne ɋafâc-ticne jaŋehec sâc mocjaha jâmbâŋ eocte mucnekicne, hatane gâcne moc mi fowec. I taha bapa sâko urucne â hazec hâricne erâ Anuture maio taha gie bahuc ŋic ŋokac nâŋâcne sâqocne šure tâmireocte iŋuc ewec jukac hâcne. ");
INSERT INTO kmg_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","E jahac šâic manahuc eesâicko rašiwecte ŋic eesâic fua-nâreha sâcne bafic-nâpoekac. ");
INSERT INTO kmg_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","Mitiŋic âgofâc-nane, sambâŋte mâmâc hefârec-ŋopakicne, ŋoŋe miti kiŋaŋ ŋic â taha bapa sâko Jesu, šâŋene murâ rereŋ eeŋgopeneŋ, erao findendeŋnenšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","Eki gie runere mume rereŋ juwec, Mosezi Anuture ficko juwec irec sâc juwec hâcne. ");
INSERT INTO kmg_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","Fic baekac ere šâŋe biŋezi ficte šâŋe biŋe jâuruekac, sâc ijaha Jesu šai šonšoŋ-ticnezi Mosere sirickekac. ");
INSERT INTO kmg_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","Ficne ficne i bâbâfua-ticnehec, wiac sasawa irec bâbâfua ine Anutu. ");
INSERT INTO kmg_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","Mose e Anuture ficko jufârehuc mume rereŋ gie bawec, i dâŋ šâhec fufuanere biŋe muocte kiŋaŋ qaqa juwec. ");
INSERT INTO kmg_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","Kristo e ine ŋokâzi fic rune jukac. Ficticne nâŋâc hâcne. Erâ i mâc mâcne, wiac biŋe qanârekicne irec mamanac paŋšâic â bubiaŋko juhapene taraocmu, ine ficticne eŋgopeneŋ muzo. ");
INSERT INTO kmg_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","Irec Tiri Mârozi dâŋ šiŋuc muwec i nâŋâcne biŋe ekac: “Ŋoŋe miŋecgac dâŋticne manaŋgopieŋko, ");
INSERT INTO kmg_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","tuhuo eesâic fuame aaricko ekicne, maŋsanaŋ iŋuc mi enšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","Mimiŋnefâc-ŋeŋic jaŋe ira wiac bapa-nane jara 40 honembiŋ, erâ sifu pepecne enarehuc esâicnumbiŋ. ");
INSERT INTO kmg_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","Eme no irec manape gâpâreme jaŋere šiŋuc mupo: `Jaŋe maŋjeŋiczi raŋɋa raŋɋa qâsorieeŋgopieŋ, jaŋe nore hata moc mi hone manac embiŋ.' ");
INSERT INTO kmg_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","Iŋucte kimbeŋ qajarehuc mumupaŋ dâŋ šiŋuc mupo: `Jaŋe nore jujumana hae mâreŋko moc mi rašinšepieŋ'.” ");
INSERT INTO kmg_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","Âgofâc-nane, ŋoŋeraonec moc e miti qikiŋnehuc maŋ gâgâpâc erâ Anutu jujune râpeckezacte soŋaŋ babac ehuc junšepieŋ. ");
INSERT INTO kmg_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","Erâ šoaŋne šoaŋne miŋecgaczi miŋegac forahuc juocmu sâc faŋ qaqac enšepieŋ, sâqocnere eeatuczi ŋoŋeraonec ŋic moc ecneme maŋbâzic ezackohec. ");
INSERT INTO kmg_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","Nâŋâc Kristore miti kâdoc babaju, ine fuŋkehuc manasiŋkembeŋ mamanasiŋ i paŋnea bajuku mao fisinaŋmuzi eŋgopeneŋ. ");
INSERT INTO kmg_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","Dâŋ šiŋuc fokac: “Ŋoŋe miŋecgac dâŋticne manaŋgopieŋko, aaricko ekicne, maŋsanaŋ iŋuc mi enšepieŋ”, ");
INSERT INTO kmg_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","ine weni jaŋe dâŋticne mana-bipiehuc aaric bâfuambiŋ? I mockoneczi mâcne, Mosezi micne bajareme Aigita mâreŋkonec warembiŋ ŋicguru i sasawa jaŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","Me weni jaŋere Anutuzi maname gâpâreme jara 40 tarawec? I sâqocne bahuc mâreŋ tuhuo hâmo sipiric embiŋ jaŋere hâcne iŋuc ewec. ");
INSERT INTO kmg_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","Erâ weni jaŋere mumupaŋ dâŋ šiŋuc muwec: Nore jujumana hae mâreŋko mi rašinšepieŋ? I dâŋticne qahuc jumbiŋ jaŋere hâcne muwec. ");
INSERT INTO kmg_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","Irec šiŋuc honeŋgopeneŋ: Jaŋe miti qiqikiŋ-jeŋicte quŋkerâ mi rašimbiŋ. ");
INSERT INTO kmg_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","Jujumana hae mâreŋ-ticnao rašinaŋte mukicne. biŋedâŋ i mi hetâtieme omaewec, irec ŋoŋeraonec moczi hatao sifuckezacte mezac-nâpozejec. ");
INSERT INTO kmg_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","Biŋe biaŋ dâŋ jaŋe jazakicne sâc ijaha nâŋâc nazakicne. Jaŋe ine dâŋ i manarâ maŋjeŋicko mi râepie hurâ fowecte jaŋerao fârimâc ewec. ");
INSERT INTO kmg_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","Nâŋâc miti mana šakieeŋgopeneŋzi jujumana hae mâreŋko rašieŋgopeneŋ. E šiŋuc muwec: “No kimbeŋ qajarehuc mumupaŋ dâŋ šiŋuc mupo: Jaŋe nore jujumana hae mâreŋko moc mi rašinšepieŋ”, i mâreŋ hobeteŋne râehuc wiac sasawa bafârerâ sifu iŋuc muwec. ");
INSERT INTO kmg_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","Irec šoaŋ namba 7 irec dâŋ moc šiŋuc muwec: “Anutu e wiac sasawa bafârereâ šoaŋ 7 ira jumanawec.” ");
INSERT INTO kmg_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","Ehame faic honembeneŋ ine šiŋuc muwec: “Jaŋe nore jujumana hae mâreŋko moc mi rašinšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","Eme ši ŋic gâcnezi jujumana hae mâreŋko rarašinere hata fokac jaha, â mârâc rarašire biŋe biaŋ jazakicne jaŋe qikiŋnehuc mi rašimbiŋ” ");
INSERT INTO kmg_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","irec “miŋecgac” šâfo i mocwâc bahuc šâhec Dawidire micko dâŋ mupac i râeme šiŋuc muwec: “Ŋoŋe miŋecgac dâŋticne manaŋgopieŋko maŋbâzic mi junšepieŋ.” ");
INSERT INTO kmg_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","Josuazi jujumana hae mâreŋ fârine bâfua-jareme muzac, Anutuzi šâhec dameŋ mocte mi muzac. ");
INSERT INTO kmg_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","Irec šiŋuc mananšepeneŋ: Anuture ŋicfâc jaŋere jujumana hombaŋ moc fokac. ");
INSERT INTO kmg_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","Anutuzi gie batararâ jumanawec, iŋuc jaha ŋic moc Anuture jujumanao rašiocmuzi gie-ticne hetararâ jumanaocmu. ");
INSERT INTO kmg_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","Eme nâŋâcnaonec moczi docke sâqorec erâ ŋic mârâc qaqatara hata âtembiŋ ijaha âtezacte jujumana hae mâreŋko rašinaŋte šoɋac enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","Anuture dâŋ i jujuhec â tâpirihec, erâ sâqe moc bune râpene micnehec irec sâc jâuruhuc mictara jâmbâŋ. Izi nâhuku qâqâtâc â maŋ, bibiric â siec wamboŋ šušuhuc-jeŋic nâtâcneekac, ehuc maŋte mamanasu â mamana wosâc irec fuŋne bataniŋkeekac. ");
INSERT INTO kmg_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","Eme wiac bâfuakicne moczi moc Anuture maio soŋsoŋ mi foekac, erao wiac sasawa tâtâc â foŋ tâmiric foekac. Erao hâcne dâŋgie banaŋmu. ");
INSERT INTO kmg_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","Taha bapa sâko hahaŋnehec moc junârekac, e sambâŋ fotâcne-fârerâ fewec jukac, Jesu Anuture Ŋokâ hâcne, eme iŋucne junârekacte šâŋe-ticne murâ rereŋ enšepeneŋ. ");
INSERT INTO kmg_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","Erâ taha bapa sâko-nâŋec e dodocne enâreme hone qâoma mi enâreekac, nâŋâcnao eesâic fuaekac iŋuc jaha wâc erao eesâic fuŋne fuŋne fuawec, eesâicko dodocke mocjaha ine mi ewec. ");
INSERT INTO kmg_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","Irec nâŋâc aki anonoc ŋeŋe rowaŋnao maŋafec jaha fisihuc junšepeneŋ, eme wiac izi me izi maic maic-nâpoha eki buuruc enârehuc aki anonoc-ticnere erâ bafic-nâpozejec. ");
INSERT INTO kmg_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","Mâreŋŋic nâŋâcnaonec taha bapa sâko rowosâec-jopakicne sasawa jaŋe ŋic jaŋere erâ Anutu fuacnehuc kiŋ bahacte taha bâzi rikecne niŋte râec-jopakicne. ");
INSERT INTO kmg_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","Taha bapa iŋucne e jahac ŋic dodocne jukacte ŋic mutucne â qâsoriekicne sâcne urucne ejareekac. ");
INSERT INTO kmg_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","Erâ fuŋne iŋucte ŋic jaŋere kiŋ bahacte mecne â e jahacne mâmâc taha bâzi rikeocte mukicne ");
INSERT INTO kmg_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","Gie fekicne i ŋic moczi maŋticnere mi rorâ bapane, taha bapa ŋic moc e Anutuzi rowosâerâ gie mucneme sâcne baocmu, Aroŋ iŋuc hâcne ecnewec ");
INSERT INTO kmg_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","Eme Kristo e iŋuc jaha e jahacne maname fefene eha taha bapa sâko mi ewec, i Anutuzi šiŋuc muhuc mucnewec: “Go hâcne Ŋokâ-nane, no miŋecgac bâfuacgukopac.” ");
INSERT INTO kmg_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","Erâ dâŋ moc šiŋuc muwec: “Goki Melikisede ere sâcko taha bapa jurašihuc jucmu sanaŋ.” ");
INSERT INTO kmg_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","Jesu e mâreŋko juwec dameŋ ira, hâmockonec bataraocte tâpiri focnewec erao numuhuc kio wâwâsic kâcɋene ecnewec. Ehuc Anutu araŋ bacnewecte manacnewec. ");
INSERT INTO kmg_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","E ŋokâ juwec, erâ sifu šâic gie baku micrereŋte fuŋne mana tarawec. ");
INSERT INTO kmg_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","Erâ wiac emataucke-fârerâ mume rereŋfâc-ticne sasawa jaŋere bâbâpiaŋ tatara tâmiric bâfuawec. ");
INSERT INTO kmg_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","E hâcne taha bapa sâko erâ Melikisede ere sâcko juocte Anutuzi mucnewec. ");
INSERT INTO kmg_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","Irec dâŋ bocjaha fokac, erâ ŋoŋe hazecfâŋ juŋgopieŋte ŋaza mutâc epemurâ manape ŋemâckekac. ");
INSERT INTO kmg_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","Ŋoŋe dameŋ šora miti mana wareeŋgopieŋzi gâcne qazu-jarepie sâckezac” eme iŋucne ŋoŋe miti maine i mocwâc qaqazu-ŋarenere sâc eŋgopieŋ. Ŋoŋe nânâ sanaŋnere sâc aricne, susu nânâre sâc sawa juŋgopieŋ. ");
INSERT INTO kmg_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","Susu nâeŋgopieŋ jaŋe ine ɋiene mujarezo, iŋucnezi dâŋ fârine wemocko mana taraniŋmu? ");
INSERT INTO kmg_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","Nânâ sanaŋne i sokakicne jaŋere biŋe, maŋ mamanasu-jeŋic fua tâcneme biaŋne sâqocne mana wosâeeŋgopieŋ jaŋere biŋe hâcne. ");
INSERT INTO kmg_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","Irec nâŋâc ši Kristore dâŋ maine, fufuŋkeo mumune, i râepene foha dâŋ hukicne, wiac efehuc mumune, i moc šuhuckenaŋ. Wemocte miti hobeteŋne i hâsine râehuc maŋ bâbârisie â juju raŋɋa bebehe â Anutu mamanasiŋ, ");
INSERT INTO kmg_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","â Miti Opâ â qizecko me rârâe â hâmockonec fafahare â bâtâc sanaŋ irec dâŋ mocwâc fuŋkezo? ");
INSERT INTO kmg_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","Anutuzi maname sâckeme dâŋ moc šuhuckenaŋ. ");
INSERT INTO kmg_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","Ŋic mitizi maŋjeŋic batamaeme sambâŋkonec nânâ nâhonembiŋ â Tiri Mârohec embiŋ, ");
INSERT INTO kmg_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","erâ Anuture dâŋbiaŋ â juju sanaŋte tâpiri mana aŋac embiŋ, ");
INSERT INTO kmg_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ŋic iŋucne jaŋe miti behe sanaŋkehuc Anuture Ŋokâ jaŋacne maŋte mocwâc maripoŋko qahuc mamakâc ecnepie mitio bâbârisiec-jopane mi fokac. ");
INSERT INTO kmg_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","Mâreŋ moc hoezi gâbâ hehuc bâgunuckekume, ŋic sara mamac eeŋgopieŋ jaŋere biŋe nânâ monšaŋ bâfuaekac, i Anutu jambuŋ-ticnere fârine fuacneekac. ");
INSERT INTO kmg_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","Á mâreŋ mocko hofâ qinšiŋ sawa fuaocmu, ine fârimâc ekacte sâwec fâreme juku šoczi šaocmu. ");
INSERT INTO kmg_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","Âgofâc, no dâŋ mukopac i ŋoŋe sipirickeniŋmu manahuc mâcne, mitio biaŋke-hâmoniŋmu, iŋuc manahuc mukopac. ");
INSERT INTO kmg_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","Anutu e eesifucne mâcne” ŋoŋe ere erâ ŋicfâc-ticne hone bafic ejarehuc jauŋ bacjopambiŋ erâ eeŋgopieŋ jaha irec wemocko nikeckeocmu. ");
INSERT INTO kmg_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","Ŋoŋe šiŋuc eniŋte enârekac: ŋoŋe mâmâc sasawa sâc ijaha ɋicwânšâŋ epie sambâŋ šeŋaŋ bâbâfuare buâkec mi omaezejec, fofehame dameŋ tarazejec. ");
INSERT INTO kmg_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","Eme mi rokawehuc, mitiŋic gâcne mamanasiŋ â sasanaŋhec juhuc wiac biŋec-nâpokicne rauckeeŋgopieŋ, jaŋere hata âteniŋmu. ");
INSERT INTO kmg_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","Jaŋeraonec moc Abraham e Anutuzi biŋedâŋ âzâcnerâ femicne mocte maio mupaŋkeocte basarâ e jahacnao râehuc mupaŋkewec. ");
INSERT INTO kmg_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","Ehuc šiŋuc muwec: “No jambuŋgurâ jambuŋgu epemu â basawecgurâ basawecgu epemu.” ");
INSERT INTO kmg_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","Eme Abraham e mumupaŋ dâŋ irec woŋec tatakic tâmiriŋ juku fârine rowec. ");
INSERT INTO kmg_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","Ŋiczi fekicne moc ere maio mumupaŋ dâŋ mupene mu qaqatarac eene mi fuaocmu. ");
INSERT INTO kmg_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","Irec Anutu e ŋic biŋe qajareme maŋjahec enšipiŋte, maŋticnezi sanaŋkeha muwec irec fuŋne bataniŋkehuc biŋedâŋ irec fainao mumupaŋ dâŋ šuhuckewec. ");
INSERT INTO kmg_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","Anutu e burec tâmiriczi dâŋsanaŋ jajahec âkendâŋ-jofahuc nâŋâcnao suru râewec, i ere dapeŋko rašimbeŋzi wiac biŋe qanârekicne irec fârine fotarierâ ronaŋte manasuhuc ewec. ");
INSERT INTO kmg_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","Biŋe qanârekicne irec fârinezi juju-nâŋecte aŋga sanaŋne â tâtâcne tâmiric iŋucne ekac, erâ aŋga izi faic qoruc ââketâc irec râpenao râekicne fokac. ");
INSERT INTO kmg_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","Ââketâc i micne bapa-nâŋec Jesu eki bânie-nârehuc fotâcnerâ maŋnao rašiwec. E Melikisede ere sâcko taha bapa erâ jusanaŋkeekaczi iŋuc ewec hâcne. ");
INSERT INTO kmg_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","Melikisede e hâcne Salem haere 