﻿USE sofia;
DROP TABLE IF EXISTS sofia.kma_vpl;
CREATE TABLE kma_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kma_vpl WRITE;
INSERT INTO kma_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yisa Masia chɔɔŋkʋʋlɩŋ saara wʋnna: die ʋ yiwo Davidi haagɩŋ ta Davidi dɩaŋ dɩ yi Abarahami haagɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarahami die dɩ mɩɩrɩ Aziki, ta Aziki dɩaŋ dɩ mɩɩrɩ Jakobu, ta Jakobu dɩaŋ dɩ mɩɩrɩ Juda aŋaŋ ʋ nɩmballɩ. ");
INSERT INTO kma_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda die mɩɩrɩ wa Perezi aŋaŋ Zera ta ba nuŋ dɩ yi Tamari: Perezi die mɩɩrɩ wa Hezironi, ta Hezironi die mɩɩrɩ wa Rami. ");
INSERT INTO kma_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rami die mɩɩrɩ wa Aminadabi, Aminadabi die mɩɩrɩ wa Naasoni, ta Naasoni die dɩ mɩɩrɩ Salimoni. ");
INSERT INTO kma_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni die mɩɩrɩ wa Buasi vuodieke nuŋ dɩ yine Rahabi; ta Buasi dɩaŋ dɩ mɩɩrɩ wa Obedi, vuodieke nuŋ dɩ yine Rufi; ta Obedi dɩaŋ dɩ mɩɩrɩ wa Jese. ");
INSERT INTO kma_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese die mɩɩrɩ wa naaŋ Davidi. Davidi dɩaŋ die mɩɩrɩ wa Solomoni, vuodieke nuŋ die dɩ yine Yuriya kpihɔgʋ. ");
INSERT INTO kma_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni die mɩɩrɩ wa Rehobuami, ta Rehobuami dɩaŋ dɩ mɩɩrɩ Abia, ta Abia dɩaŋ dɩ mɩɩrɩ Asa. ");
INSERT INTO kma_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa die mɩɩrɩ wa Jehosafati, ta Jehosafati dɩaŋ dɩ mɩɩrɩ Jorami, ta Jorami dɩaŋ dɩ mɩɩrɩ Yuzaya. ");
INSERT INTO kma_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yuzaya die mɩɩrɩ wa Jotami, ta Jotami dɩaŋ dɩ mɩɩrɩ Ahazi, ta Ahazi dɩaŋ dɩ mɩɩrɩ Hezekaya. ");
INSERT INTO kma_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekaya die mɩɩrɩ wa Manase, ta Manase dɩaŋ dɩ mɩɩrɩ Amoni, ta Amoni dɩaŋ dɩ mɩɩrɩ Josaya, ");
INSERT INTO kma_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ta Josaya die mɩɩrɩ wa Jekonaya aŋaŋ ʋ nɩmballɩ, saŋŋa gie die ba yigi Izara vuosi a bɩrɩŋ ba yɔŋɩsɩ a yaa ba ga Babiloni tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Die ba yalla ba ga Babiloni tɩŋgbaŋ ma kʋaŋ chaaŋ, Jekonaya die dɩ mɩɩrɩ Salatieli, ta Salatieli dɩaŋ dɩ mɩɩrɩ Zerubabeli. ");
INSERT INTO kma_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli die dɩ mɩɩrɩ Abuyidi, ta Abuyidi dɩaŋ dɩ mɩɩrɩ Eliakimi, ta Eliakimi dɩaŋ dɩ mɩɩrɩ Azori. ");
INSERT INTO kma_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori die mɩɩrɩ wa Zadoki, ta Zadoki dɩaŋ dɩ mɩɩrɩ Achimi, ta Achimi dɩaŋ dɩ mɩɩrɩ Eludi. ");
INSERT INTO kma_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eludi die mɩɩrɩ wa Eliaza, ta Eliaza dɩaŋ dɩ mɩɩrɩ Matani, ta Matani dɩaŋ dɩ mɩɩrɩ Jakobu. ");
INSERT INTO kma_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobu die mɩɩrɩ wa Josefu, vuodieke die dɩ yine Meri chʋrʋ, ta Meri dɩ mɩɩrɩna Yisa vuodieke ba wasɩnana Ŋmɩŋ vuovʋarɩkɩŋ Masia wa. ");
INSERT INTO kma_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Die dɩ nyɩnna Abarahami saŋŋa a ga tʋga Davidi saŋŋa die yiwo chɔɔŋkʋʋlɩba baŋ aŋaŋ banɩɩsa. Davidi saŋŋa a ga tʋga saŋŋa dieke die ba yigine be a bɩrɩŋ ba yɔŋɩsɩ a yaa ba ga Babiloni die yiwo chɔɔŋkʋʋlɩba baŋ aŋaŋ banɩɩsa. Die dɩ nyɩŋ saŋŋa mi a yaa a ga tʋga Masia maarɩŋ saŋŋa die yiwo chɔɔŋkʋʋlɩba baŋ aŋaŋ banɩɩsa. ");
INSERT INTO kma_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Die ba mɩɩrɩna Yisa Masia die wonde. Yisa nuŋ daa die wone Josefu ama die ba ye ka faarɩ tamba, ta Meri die dɩ mɩŋŋɩ sɩba dɩ ʋ yigi wo nyuuti, die Ŋmɩŋ Halɩkasɩka die vana ʋ yigi kanɩŋ nyuuti mi. ");
INSERT INTO kma_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josefu die yiwo daa dieke die dɩ mɩŋŋɩna a dɩɩsa Ŋmɩŋ sieŋ, ta die ʋ ka yaala ʋ nagɩ Meri a yi viivi me vuoŋ mana nine me. Naa chɩaŋ ma die ʋ yile ʋ sʋŋ ma dɩ ʋ lɔbɩrɩ a zeti wo. ");
INSERT INTO kma_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Die ʋ yilinene naa, Ŋmɩŋ malaka die dɩ nyɩŋ ʋ jigiŋ daansa ma a baarɩ, “Josefu, vuodieke dɩ nyɩnna Davidi buuriŋ ma, da zeti fʋ balla fʋ nagɩ Meri a bɩrɩŋ fʋ hɔgʋ wa. Dama Ŋmɩŋ Halɩkasɩka yɩna wa nyuutiti. ");
INSERT INTO kma_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ʋ nan mɩɩrɩ bʋadembiŋ aŋ nɩ wa wa Yisa, dama ʋ nan vʋarɩ ʋ vuosi a nyɩŋ ba tʋmbɩatɩ ma ma.” ");
INSERT INTO kma_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wɩaha gie mana die keŋ yi mɩŋ sɩba Ŋmɩŋ die dɩ vana ʋ naazʋalɩba wʋnyɩ die dɩ balɩna die wo, dɩ ");
INSERT INTO kma_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hɔgʋ dieke dɩ zɩna dembiŋ nan yigi nyuuti a mɩɩrɩ bʋadembiŋ aŋ ʋ saaŋ yi Emmanueli.” (Emmanueli chɩaŋ wone “Ŋmɩŋ bie tɩ jigiŋ”.) ");
INSERT INTO kma_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Die wɩa die Josefu die dɩ hagɩna ʋ daansaha ma die ʋ faarɩ Meri sɩba Ŋmɩŋ malakaka die dɩ bala wa dɩ ʋ yi die wo. ");
INSERT INTO kma_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama die Josefu aŋaŋ Meri die ka dʋagɩ taŋ a ga tʋgɩ saŋŋa dieke die ʋ mɩɩrɩna ʋ bʋadembike. Josefu die dɩ yɩ wa saarɩ, dɩ Yisa. ");
INSERT INTO kma_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Die ba mɩɩrɩna Yisa tɩŋ kaanɩ ba wasɩnana Betilehemi, Judia tɩŋgbaŋ ma ma, saŋka mi Herodi die yine naaŋ. Die ba mɩɩrɩna Yisa kʋaŋ chaaŋ die dɩ ka yʋasɩya, dembisi bataŋ die dɩ nyɩŋ ŋmɩŋ pɔsɩŋ chaaŋ a keŋ Jerusalemi, ");
INSERT INTO kma_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a dɩ dɩa a pɩasa, “Sɩa ba mɩɩrɩ bʋanyaalɩ dieke dɩ balla ʋ yi Juu vuosisi naaŋ wa? Tɩ ye wo ʋ chɩŋmarɩka dɩ nyɩnna ŋmɩŋ pɔsɩŋ chaaŋ, tɩ dɩ a keŋ dɩ tɩ jɩaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Die naaŋ Herodi die dɩ wʋnna naa wa, die wʋnɩŋ aŋaŋ vuoŋ mana die dɩ benne Jerusalemi ma ma sʋgɩtɩ dɩ chʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Die ʋ wa Ŋmɩŋ jɩamɩŋ nɩŋŋandɩɩsɩrɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba mana a lagɩŋ tamba a die a pɩasɩ ba dɩ, “Sɩa ba baa ba mɩɩrɩ gbɩgbatɩtaantʋ Masia wa?” ");
INSERT INTO kma_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Die ba baarɩ, “Betilehemi tɩŋ, Judia tɩŋgbaŋ ma ma. Naa, Ŋmɩŋ naazʋalɩba die dɩ maagɩ. ");
INSERT INTO kma_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Fʋnɩŋ Betilehemi dɩ benne Judia tɩŋgbaŋ ma, ka yi tɩgɩbiŋ dama fʋ sʋŋ naaŋ wʋnyɩ dɩ baa ʋ nyɩŋ a keŋ a dɩ n vuosisi dɩ benne Izara tɩŋgbaŋka ma nɩŋŋa.’ ” ");
INSERT INTO kma_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Naa chɩaŋ ma die naaŋ Herodi die dɩ wa chaamba die dɩ nyɩnna ŋmɩŋ pɔsɩŋ chaakʋ a lɔbɩrɩ a juu juoŋ me a pɩasɩ ba saŋŋa dieke gbaŋ gbaŋ chɩŋmarɩkʋ die dɩ nyɩnna. ");
INSERT INTO kma_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Womi die ʋ taaŋ ba dɩ ba ga Betilehemi aŋaŋ wɩaha gie: “Nɩ gamma a kpaŋŋɩ nɩ gbaŋ a mɩŋŋɩ a daansɩ a yaalɩ bʋa wa jigiŋ amʋ nɩ keŋ a ye ʋ benne jigidieke nɩ vaa n tɩbɩŋ wʋŋ amʋ n gbaŋ n ga a jɩaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Die ba nyɩnna mi a gara wa, sieŋ me die ba bɩ ye chɩŋmarɩka gbaŋ gbaŋ die dɩ pɔsɩna a nyɩŋ ŋmɩŋ pɔsɩŋ chaakʋ, die ba yene ke wo ba sʋgɩtɩ die dɩ paalɩ fɩalɩ, ka dɩ ba nɩŋŋa a ga zie tigidieke me bʋa wa dɩ benne wo sikpeŋ. ");
INSERT INTO kma_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Die ba ga a juu tigiri me a ye bʋa wa aŋaŋ ʋ nuŋ Meri; die ba sʋʋŋ a gbirigi a jɩaŋ bʋa wa, a yuori ba bʋlɔga a vʋarɩ piini a yɩ wa; die a yiwo salɩma aŋaŋ tulaari dieke ba wasɩnana farankinsinsi aŋaŋ tulaari dieke ba wasɩnana miri. ");
INSERT INTO kma_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Die Ŋmɩŋ dɩ balɩ a yɩ ba ba daansa ma sɩba ba da keŋ yiŋŋi a ga naaŋ Herodi jigiri, die ba nyɩŋ a daagɩ siegaaŋ a kuli ba tɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Die sɩsɩbɩrɩba dɩ yiŋŋine a ga ta Ŋmɩŋ malaka die dɩ nyɩŋ Josefu jigiŋ ʋ daansa ma a die a balɩ wa, “Herodi nan dɩ yaala bʋa wa dɩ ʋ kʋʋ wa. Naa chɩaŋ ma hagɩ a nagɩ bʋa wa aŋaŋ ʋ nuŋ wo a chɩgɩ a ga Ijipiti a bemme mi a ga tʋgɩ saŋŋa dieke n baaŋ nan balɩ fʋ dɩ fʋ nyɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josefu die dɩ hagɩ yuku mi a nagɩ bʋa wa aŋaŋ ʋ nuŋ wo a ga Ijipiti tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Die ʋ bie wo mi dene a ga tʋgɩ saŋŋa dieke naaŋ Herodi die dɩ kpine. Naa die yiye mɩŋ amʋ Nabidie Ŋmɩŋ die dɩ vana ʋ naazʋa wʋnyɩ dɩ balɩ die wo keŋ yi wusie, a baarɩ dɩ, “Die n vʋarɩ wa n bʋa Ijipiti me.” ");
INSERT INTO kma_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Die Herodi die dɩ mɩŋŋɩna dɩ chaaŋ diekemba die dɩ nyɩnna ŋmɩŋ pɔsɩkɩrɩ die gaaŋ wa wa die ʋ jɩɩ sɩnyɩɩrɩŋ. Die ʋ yɩ nʋaŋ dɩ ba kʋʋ ballɩnyaalɩ dembisi mana dɩ benne Betilehemi aŋaŋ ka tɩgɩbɩsɩ mana mana. Die ba kʋʋ ballɩ dembisi dieke die dɩ yine ballɩnyaalɩsɩ a ga tʋgɩ bɩna ale ballɩ dama sɩsɩbɩrɩba die baarɩ dɩ ba yene chɩŋmarɩka ka bɩna ale wʋnna. ");
INSERT INTO kma_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naa die yiye mɩŋ a yi Ŋmɩŋ naazʋa Jerimaya die dɩ balla wudiekemba wo dɩ yi wusie. Die ʋ baarɩ, ");
INSERT INTO kma_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama tɩŋ ma ba wʋŋ watɩ, kpaŋ aŋaŋ sʋgɩchʋʋsɩŋ, ta Rachali dɩ kʋma ʋ ballɩ wɩa, ba halɩŋ wa a jɩɩ, dama ʋ ballɩ die kpiye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Naaŋ Herodi die dɩ kenne a kpi, ka kʋaŋ chaaŋ die Ŋmɩŋ malaka die dɩ nyɩŋ Josefu jigiŋ ʋ daansa ma ma Ijipiti ma ");
INSERT INTO kma_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a baarɩ, “Hagɩ nagɩ bʋa wa aŋaŋ ʋ nuŋ wo a yiŋŋi a ga Izara tɩŋgbaŋ ma, dama vuodieke die dɩ yaalala ba kʋʋ wa wa kpiye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naa chɩaŋ ma Josefu die dɩ hagɩ a nagɩ bʋa wa aŋaŋ ʋ nuŋ wo a yiŋŋi a ga Izara tɩŋgbaŋ ma ma. ");
INSERT INTO kma_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama die ʋ wʋnna dɩ Akelusi die zene ʋ chɔɔŋ Herodi naŋ ma a dii Judia naarɩ, die ŋmaamɩŋ die yalla wa aŋaŋ ʋ baaŋ nan yiŋŋi a ga mi; ta Ŋmɩŋ dɩ bɩ a dagɩ wa ʋ daansa sʋŋ dɩ ʋ ga Galili tɩŋgbaŋ ma ma. ");
INSERT INTO kma_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Die ʋ ga kalɩ tɩŋgbaŋ kaanɩ ba wasɩnana Nazeriti ma ma. Naa chɩaŋ ma die Ŋmɩŋ naazʋalɩba die dɩ balla wudiekemba wo die dɩ keŋ a yi wusie, dɩ: “Ba nan dɩ wasa wa Nazeriti vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saŋka mi, Jɔɔn, vuodieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ die bie wo haagɩŋ ma Judia tɩŋgbaŋ ma a mʋʋla Ŋmɩŋ wʋvɩɩnaha a balla ");
INSERT INTO kma_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","dɩ “Nɩ chɩgɩ a nyɩŋ nɩ tʋntʋmbɩatɩ ma dama Ŋmɩŋ naarɩ diile saŋŋa gbigiye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Die Ŋmɩŋ naazʋa Azaya die wɔŋ maagɩ Jɔɔn wa wɩaha mɩŋ dɩ, “Vuoŋ benne haagɩŋ ma a keese a mʋʋla ‘Nɩ wʋnsɩ tɩ Yɔmʋtieŋ keniŋ sieti ta vaa a tʋgɩsɩ a yɩ wa.’ ” ");
INSERT INTO kma_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔɔn die yeegi wo nyɔgɩnɩ kobiti jayeekiŋ ta bɩ bɔbɩ gbanɩŋ ʋ chɩaŋ ma ta ʋ nyindiike die dɩ yi sankpara aŋaŋ siesi. ");
INSERT INTO kma_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Saŋka mi vuosi die dɩ nyɩŋ Jerusalemi aŋaŋ Judia aŋaŋ Jɔɔdani mʋgɩrɩ gelegele a gara ʋ jigiŋ ");
INSERT INTO kma_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","a balla ba tʋntʋmbɩatɩ ta ʋ sɩɩ ba Ŋmɩŋ nyaabʋ Jɔɔdani mʋgɩrɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ama die ʋ kenne ye ta Farasisi aŋaŋ Sadusisi, vuosi pam gbaŋ die dɩ kienene ʋ jigiŋ dɩ ʋ sɩɩ ba Ŋmɩŋ nyaabʋ die ʋ balɩ a yɩ ba dɩ, “Nɩnɩŋ nyinvuukehe gie! Mɩnɩa kpaana nɩ dɩ nɩ chɩgɩ nyɩŋ Ŋmɩŋ sɩnyɩɩrɩ dieke dɩ bala ka keŋ nɩ ma wa? ");
INSERT INTO kma_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nɩ yime wudiekemba dɩ baaŋ nan dagɩ sɩba nɩ chɩgɩ a nyɩŋ nɩ tʋntʋmbɩatɩtɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ta nɩ da nɩgɩma nɩ nyʋʋŋ a baarɩ nɩ yiwo Abarahami haagɩsɩ, nɩ vaa n balɩ nɩ, Ŋmɩŋ nan bɩagɩ a yiŋŋi tanaha gie a bɩrɩŋ Abarahami haagɩsɩ. ");
INSERT INTO kma_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lɩaka wɔŋ yi siri mɩŋ a gbarɩ dɩ ka chɩa tɩɩsɩsɩ; tɩɩ dieke dɩ kana ka nyɩŋ nyɩŋnyɩŋka vɩɩna ba nan chɩa ka a taaŋ a nagɩ yi boliŋ me. ");
INSERT INTO kma_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Manɩŋ n sɩa wa aŋaŋ nyaaŋ, ka dagɩ sɩba nɩ chɩgɩ a nyɩŋ nɩ tʋntʋmbɩatɩ ma wa, ama vuodieke dɩ baaŋ nan keŋ n kʋaka tɩaŋ wa manɩŋ; n ka tʋgɩ vuodieke dɩ baaŋ nan chii ʋ nɩɩra gbaŋ: wʋnɩŋ nɩŋ ʋ baaŋ nan nagɩ Ŋmɩŋ Halɩkasɩ aŋaŋ boliŋ a sɩɩ nɩ sʋgɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ʋ yallɩ wa ʋ kpalɩchaarɩkɩŋ dɩ ʋ chaarɩ zaakpeeti mana mana a nyɩŋ zaaha ma, ʋ nan lagɩsɩ zaaha mana a yi bumbuŋ me ta nagɩ zaakpeetiti a yi boli dieke dɩ kana ka kpise me.” ");
INSERT INTO kma_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Womi Yisa die dɩ nyɩŋ Galili a keŋ Jɔɔn jigiŋ Jɔɔdani mʋgɩrɩ ma dɩ ʋ sɩɩ wa Ŋmɩŋ nyaabʋ. ");
INSERT INTO kma_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama ta Jɔɔn die dɩ ka saagɩya ta balɩ wa, “Manɩŋ n tɩnna mʋ n keŋ fʋ jigiŋ aŋ fʋ sɩɩ mɩŋ, ama ta fʋnɩŋ fʋ kieŋ n jigiŋ?” ");
INSERT INTO kma_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ama ta die Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Vaa ka yi die lele, dama dɩ mʋ tɩ yi tʋnvɩɩna mana mana Ŋmɩŋ dɩ yaalala tɩ yi wo.” Jɔɔn die dɩ wa saagɩ. ");
INSERT INTO kma_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Die ʋ dene a sɩɩ Yisa Ŋmɩŋ nyaabʋ a kpatɩ wa, lele womi Yisa dɩ dene nyɩŋ nyaabʋ ma, ŋmɩŋsikpeŋ die dɩ yuori die ʋ ye Ŋmɩŋ Haalɩŋ dɩ kenne sʋʋna ʋ sikpeŋ sɩba ŋmarɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Womi lɔlɩŋ die dɩ nyɩŋ ŋmɩŋsikpeŋ a baarɩ, “N Bʋachotiŋ wʋnna, wʋnɩŋ n nine dɩ suuli.” ");
INSERT INTO kma_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Womi die Ŋmɩŋ Haalɩbʋ die dɩ nagɩ Yisa a yallɩ wa a ga haagɩŋ ma dɩ Sitaani ga magɩsɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Die ʋ bie wo mi a ka dii jaaŋ mana ŋmɩntʋasɩ aŋaŋ yugiti baŋɩsɩ-nɩɩsa ta die kɔŋ die dɩ wa a yallɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta die Sitaani die dɩ keŋ ʋ jigiŋ a baarɩ, “Dɩɩ yi fʋ seŋ yi Ŋmɩŋ Bʋa, vaa tanaha gie bɩrɩŋ nyindiike.” ");
INSERT INTO kma_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ama ta die Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Ŋmɩŋ gbaŋkʋ baarɩ vuota kaaŋ bɩagɩ a beri nyindiike nyɩɩna ma wɩa, ama wudieke mana mana Ŋmɩŋ dɩ balala.” ");
INSERT INTO kma_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Womi Sitaani die dɩ yaa Yisa a ga Jerusalemi tɩgɩkasɩ ma ma a yallɩ wa a ga a zieŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sikpeŋ ");
INSERT INTO kma_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ta die a balɩ a yɩ wa dɩ, “Fʋ seŋ a yiwo Ŋmɩŋ Bʋa fʋ nagɩ fʋ gbaŋ a taaŋ, dama Ŋmɩŋ gbaŋkʋ baarɩ, ‘Ŋmɩŋ nan vaa ʋ malakasisi fʋ wɩa, aŋ ba nagɩ ba nuusi a tʋgɩ a tuo fʋ amʋ halɩ fʋ naatalɩ gbaŋ kaaŋ gbi tanaha.’ ” ");
INSERT INTO kma_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yisa die dɩ yiŋŋi a balɩ a yɩ wa dɩ, “Ama Ŋmɩŋ gbaŋkʋ gbaŋ gbaŋ bɩ a baarɩ, ‘Vuoŋ da a keŋ magɩsɩ ʋ Yɔmʋtieŋ Nabidie Ŋmɩŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Womi Sitaani wa die dɩ bɩ a chii Yisa a yallɩ wa a ga zieŋ taŋkpeŋkpɩɩŋ sikpeŋ a dagɩ Yisa dʋnɩa tɩgɩsɩ mana mana aŋaŋ ka nyinti mana ta balɩ a yɩ wa dɩ, ");
INSERT INTO kma_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“N nan nagɩ nyinti gie mana a yɩ fʋ, dɩɩ yi fʋ keŋ a sʋʋŋ a gbirigi a jɩaŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Womi Yisa die dɩ yiŋŋi a balɩ a yɩ wa dɩ, “Sitaani, gamma ta va mɩŋ. Ka maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ a baarɩ ‘Vuota jɩama ʋ Yɔmʋtieŋ Nabidie Ŋmɩŋ nyɩɩna ma a bɩ dɩa ʋ nyɩɩna ma.’ ” ");
INSERT INTO kma_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Die wɩa Sitaani die dɩ ga ta die a va wa, ta malakasi die dɩ keŋ a suŋŋi wo. ");
INSERT INTO kma_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Die Yisa die dɩ wʋnna dɩ ba yigi Jɔɔn a yi dansarɩka sʋŋ, die ʋ nyɩŋ a ga Galili me. ");
INSERT INTO kma_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Die ʋ tʋgɩ Nazeriti tɩŋ ama die ʋ ka yʋasɩya mi ta die tɩaŋ ga Kapenɔmi tɩgɩdieke die dɩ gbigine mʋgɩkpɩɩŋ kaanɩ, Zebuluni aŋaŋ Nafitali tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Naa die yine amʋ Ŋmɩŋ naazʋa Azaya die dɩ balla wudieke wo keŋ a yi wusie. ");
INSERT INTO kma_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebuluni tɩŋ aŋaŋ Nafitali tɩgɩsɩ dɩ benne Jɔɔdani mʋgɩrɩ mi wo chaaŋ ta bɩ gbigi mʋgɩkpɩɩrɩ: Galili tɩŋ dieke vuodiekemba dɩ kana ka yi Juu vuosisi dɩ kala mi; ");
INSERT INTO kma_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","vuodiekemba dɩ benne lɩmɩŋ ma nan ye chaankpeŋkpɩɩŋ ta vuodiekemba dɩaŋ die dɩ benne kuŋ lɩmɩŋ ma, bolibu nan chaaŋ a yi ba sikpigile me.” ");
INSERT INTO kma_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Saŋka mi yaa gamma die Yisa dɩ piili a balla Ŋmɩŋ wɩa a baarɩ, “Nɩ chɩgɩ a nyɩŋ nɩ tʋmbɩatɩ ma dama Ŋmɩŋ naarɩ diile saŋŋa gbigiye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Die Yisa die dɩ chʋnnana Galili mʋgɩkpɩɩrɩ gaarɩ die ʋ ye daa wʋnyɩ aŋaŋ ʋ nɩmbʋa, die ba yiwo Simoni (vuodieke die ba wasɩnana Piita wa) aŋaŋ ʋ nɩmbʋa Andurusi, ta ba taana nɩɩŋ mʋgɩkpɩɩrɩ ma dama die ba yiwo zaasɩyigiriŋ. ");
INSERT INTO kma_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Die ʋ balɩ a yɩ ba dɩ, “Nɩ keŋ a dɩa mɩŋ aŋ n vaa nɩ sʋgɩma vuotaŋ a kiere Ŋmɩŋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Die ba va ba nɩɩtɩ lagɩ lagɩ ta die a dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Die ʋ nyɩnna mi a ga nɩŋŋa bɩta, ʋ bɩ ye daa wʋnyɩ aŋaŋ ʋ nɩmbʋa bɩbra, Jemisi aŋaŋ Jɔɔn, Zebedi ballɩ. Die banɩŋ aŋaŋ ba chɔɔŋ wa die benne ba haarɩkʋ ma a wʋnsa ba nɩɩtɩ, Yisa die dɩ wa ba, womi ");
INSERT INTO kma_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","die ba va ba chɔɔŋ aŋaŋ haarɩkʋ lagɩ lagɩ ta die a dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisa die dɩ dɩa Galili mana mana sʋŋ a daga ba Ŋmɩŋ jɩamɩŋ juone sʋŋ Ŋmɩŋ wɩa ta die a gbaanna vuodiekemba mana die dɩ yalla yʋagɩtɩ mana mana. ");
INSERT INTO kma_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Die ba mʋʋlɩ ʋ saaŋ Siria tɩŋgbaŋ mana mana ma ma. Naa chɩaŋ ma vuosi die dɩ chii vuodiekemba die dɩ yalla yʋagɩtɩ mana mana a keŋ ʋ jigiŋ; jɩmbɩatɩ die dɩ yalla bataŋ, bataŋ die dɩ yallɩ kpeŋkpeŋsi aŋaŋ vuodiekemba nyɩŋgbanɩŋ die dɩ kpine ta die ʋ gbaaŋ ba mana. ");
INSERT INTO kma_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Daadaŋ pam die dɩ nyɩŋ Galili aŋaŋ Tɩgɩsɩ-baŋ aŋaŋ Jerusalemi aŋaŋ Judia aŋaŋ Jɔɔdani gaarɩ mi wo chaaŋ tɩgɩsɩ die dɩ keŋ a dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisa die dɩ yene daadamba die ʋ jʋalɩ a kalɩ kunkogiŋ sikpeŋ ta ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ ");
INSERT INTO kma_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","die ʋ piili a daga ba Ŋmɩŋ wɩa a baarɩ: ");
INSERT INTO kma_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sʋgɩfɩalɩŋ bemme vuodiekemba dɩ sɩbɩna dɩ ba yiwo zɔɔlɩntieliŋ Ŋmɩŋ jigiŋ, Ŋmɩŋ naarɩ yiwo ba sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vuodiekemba dɩ kʋnnana wa, sʋgɩfɩalɩŋ yiwo ba sɩɩtɩ, dama Ŋmɩŋ nan halɩŋ ba sʋgɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vuodiekemba dɩ sʋʋna ba gbaŋ, sʋgɩfɩalɩŋ yiwo ba sɩɩtɩ dama dʋnɩa mana nan yi ba sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vuodieke nine dɩ ŋmɩntɩ ta ba sʋgɩtɩ dɩ yaala ba yi Ŋmɩŋ dʋŋŋʋ, sʋgɩfɩalɩŋ nan yi ba sɩɩtɩ, dama Ŋmɩŋ nan yɩ ba ba sʋgɩtɩ die dɩ ŋmɩntɩna jadieke wɩa. ");
INSERT INTO kma_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vuodiekemba dɩ chɩgɩnana ba chanchaalɩŋ zɔɔlɩŋ, sʋgɩfɩalɩŋ yiwo ba sɩɩtɩ, dama banɩŋ ba Ŋmɩŋ dɩaŋ dɩ nan chɩgɩ zɔɔlɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vuodiekemba dɩ yalla sʋgɩyɩalɩŋ, sʋgɩfɩalɩŋ yiwo ba sɩɩtɩ dama ba nan daansɩ a ye Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vuodiekemba dɩ gurinene waagɩŋ, sʋgɩfɩalɩŋ yiwo ba sɩɩtɩ, dama banɩŋ ba Ŋmɩŋ nan wa ba ʋ ballɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vuodiekemba dɩ dɩna Ŋmɩŋ ta ba mugisi be, sʋgɩfɩalɩŋ yiwo ba sɩɩtɩ, dama Ŋmɩŋ naarɩ yiwo ba sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Vuosi dɩ keŋ a zɩa nɩ ta mugisi nɩ ta chɩba ŋmɩnchɩbɩsɩ a yɩa nɩ ta bala wʋbɩatɩ yiri yiri a yɩa nɩ nɩ dɩna n kʋaŋ wɩa, sʋgɩfɩalɩŋ yiwo nɩ sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ba keŋ a yi die wo nɩ yallɩma sʋgɩfɩalɩŋ pam dama nɩ nyʋarɩ nan dɩ dala pam Ŋmɩŋ tigiri me; die gbaŋ gbaŋ die ba mugisi Ŋmɩŋ naazʋalɩba die dɩ benne kʋrɩŋ ma wa. ");
INSERT INTO kma_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nɩ sɩɩ sɩba yasɩ tɩŋgbaŋka gie me. Ama yasɩ dɩ a keŋ a chʋʋsɩ a waarɩ ka nansɩŋ, lalɩa ka bɩ baa ka yi a bɩ ye ka nansɩbʋ? Dɩ dagɩ sɩba ka wo nyʋarɩ; sie ba nagɩha a siti taaŋ tɩŋgbaŋ ma aŋ vuosi chʋŋ a ma. ");
INSERT INTO kma_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nɩnɩŋ nɩ sɩɩ sɩba tɩŋgbaŋka gie popoli; tɩŋ dieke ba mɩna a zieŋ kunkogiŋ sikpeŋ ka bɩagɩ a lɔbɩra. ");
INSERT INTO kma_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta vuoŋ ka chɔgɩsa popoli ta naga kpalɩ a bubike ama ʋ ŋaaŋ nagɩ ka a saagɩ wa jaaŋ ma jigidieke ka baaŋ nan chaaŋ a yɩ vuodiekemba mana dɩ benne tigiri me ");
INSERT INTO kma_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nɩnɩŋ nɩ bie gie; nɩ chaaŋ a yɩ vuoŋ mana, ta ba ye nɩ tʋnvɩɩna ta bɩrɩma nɩ Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nɩ da keŋ yilime sɩba n keŋ dɩ n kpisi Ŋmɩŋ mɩraha aŋaŋ Ŋmɩŋ naazʋalɩba dagɩkʋ; n ka keŋ dɩ n kpisihe mɩŋ, ama n keŋye mɩŋ dɩ n saagɩha aŋaŋ wusie. ");
INSERT INTO kma_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nɩ vaa n balɩ nɩ wusie, tɩŋgbaŋka gie aŋaŋ ŋmɩŋsikpeŋ nan tɩaŋ ga ama Ŋmɩŋ mɩraha bɩta gbaŋ kaaŋ bɩa sie a mana keŋ yi kpatɩ. ");
INSERT INTO kma_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naa chɩaŋ ma vuodieke dɩ a keŋ a yi a chʋʋsɩ Ŋmɩŋ mɩraha kaanɩ gbaŋ ta bɩ daga ʋ chanchaalɩba die wo ʋ nan wɩarɩ kʋaŋ Ŋmɩŋ naarɩ ma, ama vuodieke dɩ dɩ mɩraha ta mɩŋŋɩ dagɩ ʋ chanchaalɩŋ die, wʋnɩŋ ʋ baaŋ nan yi vuokpɩɩŋ Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dama manɩŋ n balɩ nɩ, sie nɩ tʋnvɩɩna dala a tɩaŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi vuosisi tʋnvɩɩna, dɩ daa die, nɩ kaaŋ bɩagɩ a juu Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nɩ wʋŋya die ba balla kʋrɩŋ ma dɩ, ‘Da a keŋ a kʋʋ vuoŋ, fʋ a keŋ a kʋʋ vuoŋ ba nan chii fʋ ga naalɩaŋ a dii fʋ sarɩya.’ ");
INSERT INTO kma_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama lele, nɩ vaa n balɩ nɩ, vuodieke mana dɩ a keŋ jɩɩ sɩnyɩɩrɩŋ a yi vuosi (yɔrɩ yɔrɩ), ba nan dii ʋ sarɩya, sarɩya daaŋ. Vuodieke mana dɩ a keŋ a zɩa vuoŋ dɩ, ‘Fʋnɩŋ vuotɔkʋ gie’ ba nan chii fʋ ga naalɩaŋ a ga dii fʋ sarɩya. Vuodieke mana dɩaŋ dɩ keŋ a zɩa ʋ nɩmbʋa dɩ, ‘Gaamʋka gie’ nan daansɩ bie wɩa ma, ta juu boli dieke dɩ wone kpatɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Die wɩa vuodieke dɩ a keŋ juu Ŋmɩŋ jɩamɩŋ tigiŋ a yaala ʋ nagɩ piini a yɩ Ŋmɩŋ ta tɩɩnsɩ sɩba ʋ nɩmbʋa yaa wɩɩŋ aŋaŋ wa, ");
INSERT INTO kma_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ʋ vaa ʋ piinike dʋaŋ Ŋmɩŋ jɩamɩŋ juoku nɩŋŋa, ta yiŋŋi a ga ʋ nɩmbʋa wa jigiŋ ba wʋnsɩ wɩarɩ ta ʋ yiŋŋi a keŋ nagɩ ʋ piinike a yɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Fʋnɩŋ aŋaŋ vuoŋ dɩ a keŋ yaa wɩɩŋ ta gara naalɩaŋ aŋ nɩ ga wʋnsɩ, kpaŋŋɩ fʋ gbaŋ aŋ nɩ wʋnsɩ wɩarɩ nɩ yene bie sieŋ me; dɩ daa die ʋ nan yaa fʋ a ga sarɩyadiiru wo jigiŋ aŋ ʋ dɩaŋ ʋ nagɩ fʋ a yi dansarɩka vuosi dɩdaansɩrɩba nuusi me aŋ ba nagɩ fʋ yi dansarɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wusie maŋ bala yɩa fʋ, kaaŋ bɩ nyɩŋ mi sie fʋ keŋ tuŋ ligire dieke mana ba bala dɩ fʋ tuŋ wo. ");
INSERT INTO kma_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nɩ wʋŋya die ba bala ‘Da a keŋ a dʋagɩ vuoŋ hɔgʋ.’ ");
INSERT INTO kma_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama manɩŋ n bala nɩ lele dɩ vuodieke mana dɩ a keŋ daansɩ hɔgʋ ta yaa lɔla aŋaŋ wa ʋ yi wo hɔgʋkpana tʋʋma ʋ sʋŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dɩ yiwo fʋ nuudiigiŋ chaaŋ nimbiŋ vana fʋ yi bɩaŋ, vʋarɩka taaŋ dama dɩ kpɩa fʋ wone nimbiŋ kaanɩ aŋaŋ Ŋmɩŋ dɩ baaŋ nan nagɩ fʋ nyɩŋgbanɩŋ mana a yi boli dieke dɩ wone kpisiŋ me. ");
INSERT INTO kma_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dɩ yiwo fʋ nuudiigiŋ yinene fʋ tʋma tʋmbɩatɩ, fʋ gobike a vigi taaŋ, dama dɩ kpɩa pam fʋ baaŋ nan waarɩ fʋ nuubalɩmɩŋ aŋaŋ fʋ nyɩŋgbanɩŋ mana dɩ baaŋ nan juu boliŋ me. ");
INSERT INTO kma_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Die ba bɩ baarɩ dɩ, ‘Vuodieke mana dɩ baa ʋ zeti ʋ hɔgʋ sie ʋ yɩ wa gbanɩŋ a balɩ wa dɩ ʋ zeti wo mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama lele, manɩŋ n bala nɩ dɩ vuodieke dɩ a keŋ zeti ʋ hɔgʋ ta hɔgʋ wa ka dʋaga dembisi, wʋnɩŋ ʋ yine hɔgʋ wa dɩ ga a dʋaga dembisi; ta dembiŋ dieke dɩaŋ dɩ keŋ faarɩ hɔgʋ dieke ba zetine wo gbaŋ tʋŋ wa hɔgʋkpana tʋʋma. ");
INSERT INTO kma_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nɩ bɩ wʋŋ die ba bala a yɩ kʋrɩŋ vuosi dɩ, ‘Da a keŋ a hʋʋ aŋaŋ ŋmɩnchɩbɩsɩ ama fʋ keŋ hʋʋ a yɩ Ŋmɩŋ dɩ mʋ fʋ yi die gbaŋ gbaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama manɩŋ n balɩ nɩ, dɩ nɩ sɩmma nɩ hʋʋ gbaŋ; da keŋ a baarɩ, ‘N hʋʋ ŋmɩŋsikpeŋ’ dama dɩ yiwo Ŋmɩŋ naarɩ jigiberisikiŋ; ");
INSERT INTO kma_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","yaa fʋ hʋʋ tɩŋgbaŋka gie, dama ka yiwo Ŋmɩŋ naatala jigizielikiŋ; yaa fʋ hʋʋ Jerusalemi dama ka yiwo Nabidie Ŋmɩŋ tɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Da a keŋ a hʋʋ fʋ gbaŋ gbaŋ fʋ sikpeŋ gbaŋ, dama kaaŋ bɩagɩ a yi fʋ sikpeŋ zoosi kaanɩ gbaŋ bɩrɩŋ jayɩalɩŋ yaa jasɔbɩlɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nɩ ko vaa aŋ nɩ ‘Wa’, yi nɩ ‘Wa’, ta nɩ ‘Aayɩ’ yi nɩ ‘Aayɩ’ dama nɩ hʋʋ jaaŋ a gʋtɩ, die nyɩŋ wa Sitaani jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nɩ wʋŋya die ba bala dɩ, ‘Vuoŋ dɩ a keŋ a vʋʋ fʋ nimbiŋ fʋ dɩaŋ fʋ vʋʋ ʋ nimbiŋ a tuŋ hamɩŋ; ta vuoŋ dɩ a keŋ a vʋʋ fʋ nyɩŋ fʋ dɩaŋ fʋ vʋʋ ʋ nyɩŋ a tuŋ hamɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama manɩŋ lele n balɩ nɩ, nɩ da keŋ tuŋ nɩ chanchaaŋ hamɩŋ; vuoŋ dɩ keŋ a nɩgɩ fʋ nuudiigiŋ kaamɩŋ ma fʋ yiŋŋi fʋ nuugalɩ kaamɩŋ dɩaŋ a yɩ wa aŋ ʋ nɩgɩ; ");
INSERT INTO kma_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","vuoŋ dɩ keŋ nagɩ fʋ a ga naalɩaŋ me, a yaala ʋ gbatɩ fʋ jayeekibiŋ, fʋ nagɩ fʋ jayeekikpeŋkpɩɩŋ a gʋtɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Vuoŋ dɩ a keŋ a mugisi fʋ dɩ fʋ chii ʋ chiiti chʋŋ mali balɩmɩŋ fʋ chii a chʋŋ malisi ale. ");
INSERT INTO kma_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vuodieke mana dɩ a keŋ a jʋʋsɩ fʋ jaaŋ fʋ yɩ wa ta da a keŋ a mʋŋ wa, vuodieke mana dɩ yaalala ʋ paŋŋɩ jaaŋ fʋ jigiŋ fʋ paŋŋɩ wa da keŋ mʋŋ wa. ");
INSERT INTO kma_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Die nɩ wʋŋya ba bala dɩ, ‘Nɩ yaalɩma nɩ zʋalɩŋ, ta hama nɩ dataasɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama manɩŋ lele n bala nɩ dɩ, nɩ chome nɩ dataasɩ wɩa ta jʋʋsɩma Ŋmɩŋ a yɩma vuodiekemba dɩ mugisinene nɩ, ");
INSERT INTO kma_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","aŋ die vaa nɩ seŋ yi tɩ Chɔɔŋ dieke dɩ benne arɩzanna ma ballɩ, dama ʋ yinene ŋmɩŋ dɩ pɔsa a yɩa vuobɩatɩ aŋaŋ vuovɩɩna mana ta bɩ vasa nɩɩŋ dɩ nɩa a yɩa vuodiekemba dɩ yinene vɩɩnɩŋ aŋaŋ vuodiekemba dɩ yinene bɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dama fʋ yaala vuodiekemba dɩ yaalala fʋ nyɩɩna, bie nyʋarɩ fʋ baaŋ fʋ ye a nyɩŋ Ŋmɩŋ jigiŋ? Daa die gbaŋ gbaŋ vuobɩatɩ die dɩ yie? ");
INSERT INTO kma_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ta fʋ a keŋ waasa fʋ zʋalɩŋ nyɩɩna ma bie wʋvɩɩna fʋ yie a tɩaŋ fʋ chanchaalɩba? Daa die vuodiekemba dɩ kana a ka dɩ Ŋmɩŋ mɩraha dɩ yie? ");
INSERT INTO kma_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Die wɩa nɩ bemme vɩɩnɩŋ sɩba nɩ Chɔɔŋ Nabidie Ŋmɩŋ dɩ benne die wo arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nɩ da keŋ suŋŋi zɔɔlɩntieliŋ dɩ vuosi ye nɩ, dama nɩ keŋ a yi die nɩ kaaŋ ye nyʋarɩ a nyɩŋ nɩ Chɔɔŋ Ŋmɩŋ dɩ benne arɩzanna ma jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Die wɩa, fʋ keŋ yaala fʋ nagɩ piini a yɩ zɔɔlɩntieŋ, da keŋ mʋʋlɩ ka sɩba gɩgaantɩba dɩ ŋaana yie die wo Ŋmɩŋ jɩamɩŋ juone me aŋaŋ tɩgɩsɩ sʋŋ dɩ vuota ye ba tʋnvɩɩna ta bɩrɩ ba wa. Wusie maŋ bala nɩ, ba wɔŋ ye ba nyʋarɩ mana mɩŋ, ");
INSERT INTO kma_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ama fʋ a keŋ yɩ zɔɔlɩntieŋ piini da keŋ vaa fʋ zʋa vɩɩnɩŋ gbaŋ sɩmma ka wɩa. ");
INSERT INTO kma_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Amʋ ka yi wʋlɔbɩrɩkɩŋ ta fʋ Chɔɔŋ Ŋmɩŋ vuodieke dɩ yesinene lɔbɩrɩŋ ma nan tuŋ fʋ ((yeŋ me.)) ");
INSERT INTO kma_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Fʋ keŋ yaala fʋ jʋʋsɩ Ŋmɩŋ, da a keŋ a yi sɩba gɩgaantɩba dɩ yinene die wo, dama banɩŋ ba cho dɩ ba zie Ŋmɩŋ jɩamɩŋ juone me aŋaŋ siekpara ma tɩka sʋŋ a jʋʋsɩma Ŋmɩŋ dɩ vuosi ye be. Wusie maŋ bala nɩ ba wɔŋ ye ba tune mana mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama fʋ keŋ a baa fʋ jʋʋsɩ Ŋmɩŋ, juu fʋ juoŋ me ta ligi sanʋarɩ, ta jʋʋsɩ fʋ chɔɔŋ Ŋmɩŋ vuodieke dɩ benne lɔbɩrɩŋ ma, aŋ fʋ Chɔɔŋ wa Ŋmɩŋ dɩ yene wudieke fʋ yine lɔbɩrɩŋ ma wa tuŋ fʋ ((yeŋ me.)) ");
INSERT INTO kma_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Fʋ a keŋ jʋʋsa Ŋmɩŋ da keŋ jʋʋsɩma aŋaŋ wʋbalɩkɩ wagɩtɩ sɩba vuodiekemba dɩ jɩannana bugile; banɩŋ ba yile sɩba ba keŋ jʋʋsɩ aŋaŋ wʋbalɩkɩ wagɩtɩ ba bugilehe nan wʋŋ ba. ");
INSERT INTO kma_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nɩ da keŋ a sɩɩ sɩba banɩŋ, dama nɩ chɔɔŋ Ŋmɩŋ wɔŋ sɩba jadieke nɩ yaalala ta nɩ ye ka jʋʋsɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Naa wana mʋ nɩ jʋʋsɩ Ŋmɩŋ: ‘Tɩ chɔɔŋ dieke dɩ benne arɩzanna ma: Vaa aŋ ba bɩrɩ fʋ saaŋ kasɩka; ");
INSERT INTO kma_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Vaa aŋ fʋ naarɩ keŋ; vaa fʋ dʋŋŋʋ yi tɩŋgbaŋka gie me sɩba ka sɩna die arɩzanna ma wa ");
INSERT INTO kma_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yɩ tɩ jinne nyindiike dieke tɩ yaalala. ");
INSERT INTO kma_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nagɩ tɩ hamɩŋ a chaa tɩ, sɩba tɩ nagɩna vuodiekemba dɩ tʋnna tɩ tʋmbɩatɩ a chaa ba wa. ");
INSERT INTO kma_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Da a keŋ vaa tɩ juu magɩsɩ dieke dɩ hagɩrɩna ma, ama ta vʋarɩ tɩ a nyɩŋ wʋbɩaŋ ma. ((Dama fʋnɩŋ fʋ sɩna naarɩ aŋaŋ yiko aŋaŋ jɩlɩma yaa gamma haahuu. Wusie.))’ ");
INSERT INTO kma_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nɩ keŋ nagɩ nɩ chanchaalɩŋ wʋbɩatɩ a chaa ba, nɩ Chɔɔŋ dieke dɩ benne arɩzanna ma dɩaŋ nan nagɩ nɩ tʋmbɩatɩ a chaa nɩ. ");
INSERT INTO kma_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama nɩ ka nagɩ nɩ chanchaalɩŋ wʋbɩatɩ a chaa ba, die nɩŋ nɩ Chɔɔŋ dɩaŋ kaaŋ nagɩ nɩ wʋbɩatɩ a chaa nɩ. ");
INSERT INTO kma_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ta fʋ a keŋ a bɔbɩ nʋaŋ dɩaŋ, da keŋ chʋʋsɩ fʋ nine chaaŋ sɩba gɩgaantɩba dɩ yine die wo, dama banɩŋ ba chʋʋsɩ wa ba nine chaaŋ dɩ vuoŋ mana ye sɩba ba bɔbɩ wa nʋaŋ. Wusie maŋ bala nɩ ba wɔŋ ye wo ba nyʋarɩ. ");
INSERT INTO kma_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Fʋ a keŋ a bɔbɩ nʋaŋ fʋ nɩɩtɩ fʋ nine chaaŋ ta chasɩ fʋ sikpeŋ zoosi, ");
INSERT INTO kma_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","amʋ vuosi kaaŋ mɩŋŋɩ a baarɩ bɔba nʋaŋ, ntaala fʋ Chʋa Ŋmɩŋ nyɩɩna ma, vuodieke dɩ benne lɔbɩrɩŋ ma sɩmma. Amʋ fʋ Chʋa Ŋmɩŋ dieke dɩ yesinene jadieke fʋ yinene lɔbɩrɩŋ ma a yɩa wa nan tuŋ fʋ ((yeŋ me.)) ");
INSERT INTO kma_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Da keŋ a yaalɩma nyinti a lɔbɩrɩma tɩŋgbaŋka gie me, jigidieke nyɩnyʋgɩka aŋaŋ tʋgɩŋ dɩ baaŋ nan chʋʋsɩha; ta gaarɩŋ dɩ baaŋ nan bɩagɩ awɩ a juu a gaarɩ. ");
INSERT INTO kma_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama lɔbɩrɩma fʋ nyinti arɩzanna ma, jigidieke nyɩnyʋgɩka aŋaŋ tʋgɩŋ dɩ kana ka bɩagɩ chʋʋsaha; ta gaarɩŋ dɩ ka bɩagɩ awɩa a juu a gaara; ");
INSERT INTO kma_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","jigidieke fʋ nyinti dɩ benne, mi fʋ sʋŋ dɩaŋ dɩ beri. ");
INSERT INTO kma_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Fʋ nine yine fʋ nyɩŋgbanɩŋ popoli. Die wɩa fʋ nine dɩ keŋ vɩɩna, fʋ nyɩŋgbanɩŋ mana nan suuli aŋaŋ chaanɩŋ; ");
INSERT INTO kma_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ama fʋ nine dɩ keŋ a ka vɩɩna, fʋ nyɩŋgbanɩŋ mana nan dɩ bie lɩmɩŋ ma. Die wɩa chaaŋ dieke dɩ benne fʋ ma ma dɩ keŋ yi lɩmɩŋ, lɩmɩŋkʋ nan dɩ dala pam. ");
INSERT INTO kma_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Vuobalɩmɩŋ kaaŋ bɩagɩ a jɩama naalɩŋ bale. Ʋ nan haa wʋnyɩ ta chome wʋnyɩ, yaa ʋ nan yɩ wʋnyɩ jɩlɩma ta wʋnyɩ ʋ nine kaaŋ dɩ suuli. Vuoŋ kaaŋ bɩagɩ a jɩama Ŋmɩŋ aŋaŋ ligire. ");
INSERT INTO kma_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Naa chɩaŋ ma wɩa maŋ bala nɩ da vaa ka mugisi nɩ aŋaŋ jadieke nɩ baaŋ nan dii aŋaŋ nɩ baaŋ nan nyuu a bemme nɩ miivoli me; nɩ da bɩ vaa dɩ mugisi nɩ, nɩ nyɩŋgbanɩŋ dɩ baaŋ nan yeegi jadieke. Mɩsɩ ka tɩaŋ nyindiike? Ta nyɩŋgbanɩŋ ka tɩaŋ nyiŋyeeke? ");
INSERT INTO kma_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nɩ daansɩ a ye nembisi dɩ yʋgɩnana; a ka bʋra; a ka bɩ gobe ta nagɩ yie napooti me, ama nɩ Chɔɔŋ dieke dɩ benne arɩzanna ma wa daansɩnana ha. Nɩ ka yaa nyʋarɩ a tɩaŋ nembisi? ");
INSERT INTO kma_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nɩ jabɩa baaŋ nan bɩagɩ a gʋtɩ ʋ gbaŋ ʋ miivoli bɩta ʋ wuyilimugisike wɩa. ");
INSERT INTO kma_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bɩa yine nɩ mugisi nɩ gbaŋ yaa gamma nyiŋyeeke wɩa? Nɩ daansɩ a ye tɩɩwute aŋaŋ ka vɩɩnɩŋ: ama a ka tʋma a yaala ka wute. ");
INSERT INTO kma_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ama n balɩ nɩ, halɩ naaŋ Solomoni aŋaŋ ʋ nyiŋyeeki vɩɩna mana die ka yeegi jayeekiŋ ka vɩɩna a tʋgɩ tɩɩwutehe gie. ");
INSERT INTO kma_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ŋmɩŋ yinene huuti dɩ vɩɩna, nyindieke dɩ benne jinne ta soriŋ ba jʋʋ ha a taaŋ wa, ʋ kaaŋ wa a faasɩ yeegi nɩ nyiŋyeeke? Ʋ kaaŋ bɩagɩ a yeegi nɩ? Nɩnɩŋ vuodiekemba yada dɩ kana a ka dala! ");
INSERT INTO kma_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Die wɩa nɩ da vaa dɩ mugisi nɩ ta yilime, ‘Bɩa tɩ nan dii?’ Yaa ‘Bɩa tɩ nan nyuu?’ Yaa ‘Bɩa tɩ nan yeegi?’ ");
INSERT INTO kma_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vuodieke dɩ kana ka sɩba Ŋmɩŋ ŋaana chɩga a yaala nyinti gie mana, ama nɩ Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma sɩba a baarɩ dɩ nɩ yaalaha mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ama nɩ woliŋ yaalɩma Ŋmɩŋ naarɩ aŋaŋ wudieke Ŋmɩŋ dɩ yaalala wɩa ta ʋ nan nagɩ nyindiekemba nɩ yaalɩnana mana a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Die wɩa da keŋ vaa soriŋ wɩa mugisi nɩ dama soriŋ nan dɩ yallɩ ka gbaŋ gbaŋ mugisikiŋ. Daaŋ mana yaa ka wumugisi dieke dɩ mʋgɩsɩna ka mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nɩ da keŋ a dii nɩ chanchaalɩŋ sarɩya, amʋ Ŋmɩŋ dɩaŋ da keŋ dii nɩ sarɩya, ");
INSERT INTO kma_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","dama nɩ dine nɩ chanchaalɩŋ sarɩyaha die wo, die gbaŋ gbaŋ Ŋmɩŋ dɩ nan dii nɩ sarɩya; ta nɩ magɩsɩna die a yɩa nɩ chanchaalɩŋ die gbaŋ gbaŋ Ŋmɩŋ dɩaŋ dɩ nan magɩsɩ a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Bɩa yine fʋ daansa yese mɩnchɩɩbɩŋ dieke dɩ benne fʋ chanchaaŋ nimbiŋ me, ta a ka yese dakʋʋlɩ dieke dɩ benne fʋ gbaŋ gbaŋ fʋ nimbiŋ me? ");
INSERT INTO kma_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Baa fʋ yiwo lalɩa a balɩ a yɩ fʋ nɩmbʋa, ‘Ko vaa n vʋarɩ mɩnchɩɩbɩŋ dieke dɩ benne fʋ nimbiŋ me’ ta daaŋ dakʋʋlɩ dieke dɩ benne fʋ gbaŋ gbaŋ fʋ nimbiŋ me wɩa? ");
INSERT INTO kma_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fʋnɩŋ gɩgaantʋ wa gie, woliŋ a vʋarɩ dakʋʋlɩ dieke dɩ benne fʋ ninehe me wo amʋ fʋ mɩŋŋɩ a yesime vɩɩnɩŋ a vʋarɩ mɩnchɩɩbɩŋ dieke dɩ benne fʋ nɩmbʋa wa nimbiŋ me wo. ");
INSERT INTO kma_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Da nagɩ jadieke dɩ yine Ŋmɩŋ tʋaŋ a yɩ gbaasɩ, dama a baa a yiŋŋi a dʋŋ fʋ mɩŋ; da keŋ a nagɩ jadieke dɩ yalla nyʋarɩ a yɩ perukusi, dama a nan tɩbɩtɩbɩha aŋaŋ tantɩ. ");
INSERT INTO kma_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nɩ jʋʋsɩma Ŋmɩŋ, ta ʋ nan nagɩ a yɩ nɩ; nɩ daansɩma ta nɩ nan ye; nɩ kpaasɩma gbɩabɩkʋ ta ʋ nan yuori a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dama vuodieke mana dɩ jʋʋsɩnana Ŋmɩŋ tuose mɩŋ; ta vuodieke dɩaŋ mana dɩ yaalɩnana yese mɩŋ; vuodieke dɩaŋ dɩ kpaasɩnana gbɩabɩkʋ ka yuore a yɩa wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nɩnɩŋ chʋalɩba, nɩ mɩnɩa ʋ bʋa dɩ nan jʋʋsɩ wa nyindiike aŋ ʋ nagɩ taŋ a yɩ wa? ");
INSERT INTO kma_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yaa nɩ mɩnɩa ʋ bʋa nan jʋʋsɩ wa zaasɩŋ aŋ ʋ nagɩ javʋʋkɩŋ a yɩ wa? ");
INSERT INTO kma_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ta dɩɩ yi nɩnɩŋ vuobɩatɩ gie dɩ sɩba nɩ nagɩ nyɩnvɩɩna a yɩ nɩ ballɩ, die nɩŋ nɩ Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma nan faasɩ yɩ vuodieke mana dɩ jʋʋsɩ wa nyɩnvɩɩna. ");
INSERT INTO kma_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Yime fʋ chanchaalɩŋ wudieke fʋ baaŋ nan dɩ yaala ba yime a yɩma fʋ; dama Ŋmɩŋ mɩraha aŋaŋ Ŋmɩŋ naazʋalɩba dagɩkʋ dɩ dagɩna die wonde. ");
INSERT INTO kma_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nɩ jume sanʋabike dama sanʋa dieke dɩ gana a ga a juu boli dieke dɩ wone kpatɩ ma wa tɩɩlɩ mɩŋ, ta ka sieŋ dɩ bɩ vɩɩna aŋaŋ chɔnɩŋ; ta vuosi pam dɩ daagɩ mi juo. ");
INSERT INTO kma_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama miivoli sanʋakʋ yiwo jabɩŋ, ta ka sieku dɩaŋ dɩ tʋa aŋaŋ chɔnɩŋ; ta vuosi bɩta juunene mi. ");
INSERT INTO kma_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nɩ sɩmma ŋmɩnchɩbɩsɩ naazʋalɩba wɩa, ba kieŋ nɩ jigiŋ sɩba yiise, ama ba yiwo haaŋgbaasɩ wusie. ");
INSERT INTO kma_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ba tʋʋma nan yi nɩ sɩmma ba; ba yese jɩa haŋgɔɔsɩ me a kpaa? Yaa kɩnkama ngbere jigiŋ a kpaa? ");
INSERT INTO kma_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tɩɩvɩɩna mana nyɩna nyɩŋnyɩŋka vɩɩna, ama tɩɩ dieke dɩ wone nyʋarɩ mana ŋaaŋ nyɩŋ wa nyɩŋnyɩŋkɩbɩatɩ. ");
INSERT INTO kma_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tɩɩvɩɩnɩŋ kaaŋ nyɩŋ nyɩŋnyɩŋkɩbɩatɩ; ta tɩɩ dieke dɩ wone nyʋarɩ dɩaŋ kaaŋ nyɩŋ nyɩŋnyɩŋkɩvɩɩna. ");
INSERT INTO kma_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tɩɩ dieke mana dɩaŋ dɩ kana a ka nyɩna nyɩŋnyɩŋkɩvɩɩna ba nan chɩaka a taaŋ boliŋ me. ");
INSERT INTO kma_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Naa chɩaŋ ma nɩ nan dɩ sɩba ŋmɩnchɩbɩsɩ naazʋalɩba ba tʋʋma ma. ");
INSERT INTO kma_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Da vuodieke mana dɩ wasɩnana mɩŋ, ‘N Yɔmʋtieŋ, N Yɔmʋtieŋ’, balla ʋ juu arɩzanna naarɩ ma, sie vuodiekemba nyɩɩna dɩ yinene n Chʋa Ŋmɩŋ dieke dɩ benne arɩzanna ma wa choti. ");
INSERT INTO kma_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sarɩya diile daarɩ dɩ keŋ tʋgɩ, daadaaŋ pam nan ballɩ a yɩ mɩŋ, ‘N Yɔmʋtieŋ, N Yɔmʋtieŋ, die fʋ saaŋ ma tɩ balla Ŋmɩŋ wɩa, die fʋ saaŋ ma die tɩ yaga jɩmbɩatɩtɩ vuosi ma, die fʋ saaŋ ma die tɩ yie mamachi tʋʋma.’ ");
INSERT INTO kma_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Saŋka mi n nan yiŋŋi balɩ ba, ‘N ka sɩba nɩ, nɩnɩŋ tʋntʋmbɩatɩ vuosi gie, nɩ gamma!’ ");
INSERT INTO kma_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Naa chɩaŋ ma vuodieke mana dɩ wʋnna manɩŋ n wɩaha gie ta dɩɩsaha nɩasɩ wa dembiyɩantieŋ dieke dɩ mɩna ʋ tigiŋ a zieŋ taŋ sikpeŋ me wo. ");
INSERT INTO kma_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nɩɩŋ die dɩ paalɩ a nɩɩ, mʋga dɩ kpaa, ta bʋlɔgɩsɩŋ die dɩ faasɩ a nɩgɩ tigiri, ama tigiri die ka nanya, dama die ka zene taŋ ma wa chɩaŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama vuodieke mana dɩ wʋnnana manɩŋ n wɩaha gie ta ka dɩɩsaha nɩasɩ wa dembigaamʋ dieke dɩ mɩna ʋ tigiŋ a zieŋ tambʋsɩŋ sikpeku. ");
INSERT INTO kma_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nɩɩŋ die dɩ paalɩ a nɩɩ, mʋga dɩ kpaa, ta bʋlɔgɩsɩŋ die dɩ paalɩ nɩgɩ tigiri, tigiri die dɩ nan a ŋmʋʋrɩ!” ");
INSERT INTO kma_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Die Yisa die dɩ balɩna wɩaha gie a kpatɩ, die dɩ yi daadamba mamachi aŋaŋ ʋ dagɩkʋ, ");
INSERT INTO kma_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dama die ʋ dagɩ sɩba vuodieke dɩ yalla yiko, ta ka dagɩ ba sɩba mɩraha dɩdagɩrɩba die dɩ dagɩnana die wo. ");
INSERT INTO kma_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisa die dɩ nyɩna kunkogiri me a keŋ sʋʋŋ, daadaŋ pam die dɩ dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Womi gamɩŋ wʋnyɩ die dɩ keŋ a gbigiri ʋ nɩŋŋa a baarɩ, “N Yɔmʋtieŋ, fʋ yaala nan bɩagɩ a gbaaŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yisa die dɩ tɩɩntɩ ʋ nuuŋ a gbɩ daa wa ta balɩ dɩ, “N saagɩya, fʋ gamɩŋ kpatɩya mɩŋ!” Lele womi ta daa wa dɩ ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yisa die dɩ balɩ a yɩ wa, “Wʋmma, sɩmma fʋ keŋ a balɩ vuoŋ wɩaha gie. Ama gamma a ga nagɩ fʋ gbaŋ a dagɩ Ŋmɩŋ kɩkaabɩtʋ wa a vaa ʋ jɩɩŋ fʋ aŋ fʋ kaabɩ kaabɩ dieke Mosisi die dɩ balla dɩ nɩ kaabɩ wa amʋ vuoŋ mana sɩmma a baarɩ ye alaafɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Die Yisa die dɩ gana a ga juu Kapenɔmi, die Romanisi sojasisi nyɩŋkʋraha wʋnyɩ die dɩ keŋ ʋ jigiŋ a jʋʋsɩ wa ta a baarɩ, ");
INSERT INTO kma_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Jakʋʋŋ, n tʋntʋntʋ wʋnyɩ paalɩna a yʋagɩ; ʋ nyɩŋgbanɩŋ mana dɩ kpi, ta ʋ die wahala pam, ta dʋa juoŋ me.” ");
INSERT INTO kma_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yisa die dɩ balɩ wa, “N nan ga a ga gbaaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Die ʋ yiŋŋi a balɩ, “Aayɩ, n Yɔmʋtieŋ, n ka tʋgɩ vuodieke fʋ mʋna fʋ keŋ n tigiŋ, ama fʋnɩŋ ko yɩ nʋaŋ aŋ ʋ ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Dama manɩŋ n gbaŋ n yaa wa n nyɩŋkʋra, ta yallɩ sojasi ba dɩɩ n kʋaŋ. N ŋaaŋ balɩ a yɩ geŋ wo, ‘Gamma’ aŋ ʋ ga, ta balɩ a yɩ geŋ wo ‘Kiere’ aŋ ʋ keŋ; ta bɩ vaa n yɔmʋ yi wudieke n yaalala.” ");
INSERT INTO kma_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisa die dɩ wʋnna naa die dɩ yi wo mamachi, die ʋ ballɩ a yɩ vuodiekemba die dɩna ʋ kʋaka, “Wusie maŋ bala nɩ, n ye ka ye vuodieke dɩ yine mɩŋ yadaka gie chanchaaŋ nɩnɩŋ Izara vuosi me gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N bala nɩ, daadaŋ pam nan nyɩŋ ŋmɩŋ pɔsɩkɩŋ aŋaŋ ŋmɩŋ juukiŋ a keŋ ta banɩŋ aŋaŋ Abarahami aŋaŋ Aziki aŋaŋ Jakobu nan lagɩŋ a kalɩ a die nyindiike arɩzanna ma ma; ");
INSERT INTO kma_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ama nɩnɩŋ die dɩ yine naarɩ vuosisi, ba nan nagɩ nɩ a vigi taaŋ yeŋ me lɩmɩŋ ma; mi nɩ nan dɩ kʋma ta ŋɔba nɩ nyɩna.” ");
INSERT INTO kma_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Die Yisa die dɩ yiŋŋi a balɩ a yɩ Romanisisi sojasisi jakʋʋrɩ, “Kulime ta ka nan yi sɩba fʋ yine yada dɩ ka nan yi die wo.” Ta ʋ tʋntʋntʋ wa die dɩ seŋ ye gbaamɩŋ lele womi. ");
INSERT INTO kma_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Die Yisa ga wa Piita tigiŋ, mi die ʋ ye Piita hanɩɩŋ hɔgʋ dɩ yʋagɩna a dʋa aŋaŋ nyɩŋgbaŋ tuuliŋ. ");
INSERT INTO kma_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Die Yisa die dɩ gbɩ ʋ nuuŋ; ta nyɩŋgbaŋ tuulibu die dɩ kpatɩ, die ʋ hagɩ a yi ba chaantɩ. ");
INSERT INTO kma_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dɩnɩŋ daarɩ mi jɩŋmɩŋ, vuosi die dɩ chii daadaŋ pam die jɩmbɩatɩ die dɩ yalla ba a keŋ Yisa jigiŋ; die ʋ yagɩ jɩmbɩatɩtɩ ba ma aŋaŋ jabalɩkɩŋ ta gbaaŋ vuodiekemba mana dɩ yʋagɩna. ");
INSERT INTO kma_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Die ʋ yiwo naa amʋ Ŋmɩŋ naazʋa Azaya die dɩ balla wudieke wo keŋ a yi wusie dɩ, “Ʋ gbaŋ gbaŋ die dɩ tuo tɩ nyɩŋgbaŋ tuuliŋ aŋaŋ tɩ yʋagɩtɩ a chii a ga.” ");
INSERT INTO kma_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Die Yisa die dɩ yene dɩ kpɩkpaakʋ geliŋ wo wo die ʋ yɩ ʋ kʋaŋandɩɩsɩrɩba nʋaŋ, dɩ ba tɩaŋ ga mʋgɩkpɩɩrɩ gaarɩ mi wo. ");
INSERT INTO kma_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Die Ŋmɩŋ mɩraha dɩdagɩrɩba wʋnyɩ die dɩ keŋ ʋ jigiŋ a baarɩ, “Dɩdagɩrʋ, N nan dɩ dɩ fʋ a ga jigidieke mana fʋ ganana.” ");
INSERT INTO kma_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Gbaanchʋra yaa vɔrɩtɩ a juo, nembisi dɩaŋ dɩ yaa tʋʋsɩ a juo ama manɩŋ vuota Bʋa wo jigidʋagɩsɩkɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tɔ, ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ dɩaŋ die dɩ keŋ baarɩ, “N Yɔmʋtieŋ, vaa n ye woliŋ kuli a ga a guu n chʋa.” ");
INSERT INTO kma_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yisa die dɩ balɩ wa, “Dɩa mɩŋ, ta vaa kunti guu a gbaŋ gbaŋ a kunti.” ");
INSERT INTO kma_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisa die dɩ ga a juu haarɩŋ wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ ga. ");
INSERT INTO kma_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Die dɩ ka yʋasɩya ta bʋlɔgɩsɩkpeŋkpɩɩŋ die dɩ piili a nɩga mʋgɩkpɩɩrɩ ma, nyaabʋ dɩ poŋŋi a juo haarɩkʋ ma a yalla bʋ suuli haarɩkʋ; ama saŋka mi die Yisa die gʋʋra mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ʋ kʋaŋandɩɩsɩrɩba die dɩ ga sʋgɩrɩ wa a baarɩ, “Tɩ Yɔmʋtieŋ, gbatɩ tɩ a taaŋ, ta tɩ baa tɩ sʋʋŋ wa nyaabʋ chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yisa die dɩ yiŋŋi a balɩ ba, “Dɩ bɩa ŋmaamɩŋ dɩ faasɩ a yallɩ nɩ die, nɩnɩŋ vuodiekemba yada dɩ kana ka dala.” Womi die ʋ hagɩ a natɩ bʋlɔgɩsɩbʋ aŋaŋ nyaabʋ poŋŋiku dɩ a fɩalɩ, mi mana die dɩ seŋ a fɩalɩ sɔmm. ");
INSERT INTO kma_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Die dɩ yi be mamachi, ba pɩasa taŋ dɩ, “Daa lalɩa wʋnna? Halɩ bʋlɔgɩsɩŋ aŋaŋ nyaaŋ poŋŋiŋ dɩ wʋmma yɩa wa.” ");
INSERT INTO kma_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yisa die dɩ kenne tʋgɩ Gadara tɩŋ ma mʋgɩkpɩɩrɩ mi wo chaakʋ, die dembisi bale jɩmbɩatɩ die dɩ yalla dɩ nyɩŋ jigidieke ba gunene vuosi a keŋ tuoli wo. Die ba wɩa paalɩ yaa wa ŋmaamɩŋ die wɩa vuoŋ die ka bɩagɩ daaga mi. ");
INSERT INTO kma_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Womi bʋnyɩ die ba faasɩ keese, “Fʋnɩŋ Ŋmɩŋ Bʋa, bɩa fʋ yaala tɩ jigiŋ. Keŋ dɩ fʋ mugisi tɩ mɩŋ ta saŋka mi wa tʋgɩ?” ");
INSERT INTO kma_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Die perukusi a taŋ die ziene a gbigi mi a die. ");
INSERT INTO kma_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jɩmbɩatɩtɩ die dɩ jʋʋsɩ Yisa a baarɩ, “Fʋ keŋ yagɩ tɩ, fʋ vaa tɩ ga juu perukusisi me.” ");
INSERT INTO kma_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yisa die dɩ balɩ a yɩ ha, “Nɩ gamma.” Die wɩa die a nyɩŋ dembisi bale wo me, a ga a juu perukusisi sʋŋ; Die perukusisi mana dɩ chɩgɩ birrr sʋʋŋ tanɩ chɩaŋ a ga nan mʋgɩkpɩɩrɩ ma ta nyaabʋ dɩ dii he. ");
INSERT INTO kma_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vuodiekemba die dɩ daansɩnana perukusisi die dɩ chɩgɩ a ga tɩka sʋŋ a mʋʋlɩ wudieke die dɩ yine wo, aŋaŋ jɩmbɩatɩ die dɩ nyɩna dembisi bale wo me die. ");
INSERT INTO kma_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naa chɩaŋ ma, vuoŋ mana die dɩ nyɩŋ tɩka ma a tuole Yisa; die ba yene wo wo die ba jʋʋsɩ wa dɩ ʋ nyɩŋ ba tɩŋgbaŋka ma. ");
INSERT INTO kma_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Womi Yisa die dɩ yiŋŋi a juu haarɩkʋ a yiŋŋi a jʋalɩ mʋgɩkpɩɩrɩ gaarɩ mi wo a kuli ʋ gbaŋ gbaŋ ʋ tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Die vuosi bataŋ die dɩ chii daa wʋnyɩ nyɩŋgbanɩŋ die dɩ kpine; ta ʋ dʋa kalɩŋŋa ma a yallɩ wa a keŋ ʋ jigiŋ. Die Yisa die dɩ yene ba paala a yallɩ yada dieke wo, die ʋ balɩ a yɩ yʋagɩtieŋ wo, “N bʋa, dii sikimiŋ; n nagɩ fʋ tʋmbɩatɩ a chaa fʋ.” ");
INSERT INTO kma_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Womi Ŋmɩŋ mɩraha dɩdagɩrɩba die dɩ yile ba sʋgɩtɩ ma dɩ “Daa wa gie bala sɩba ʋ yiwo Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yisa die dɩ mɩŋŋɩ ba sʋŋanyile die a pɩasɩ ba dɩ, “Bɩa nɩ yile sʋŋanyilibɩatɩ die? ");
INSERT INTO kma_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A jabɩa yine mɔlɩ ‘Fʋ baaŋ nan balɩ a yɩ wa, n nagɩ fʋ tʋmbɩatɩ a chaa fʋ’ yaa fʋ baaŋ nan balɩ ‘Hagɩ a chʋŋ’? ");
INSERT INTO kma_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","N nan wa a dagɩ aŋ nɩ sɩmma a baarɩ manɩŋ vuota Bʋa yaa yiko dʋnɩa ma ma a nan bɩagɩ a nagɩ vuosi tʋmbɩatɩ a chaa ba”. Die wɩa die ʋ balɩ a yɩ yʋagɩtieŋ wo, “Hagɩ a nagɩ fʋ kalɩŋŋa a kulime.” ");
INSERT INTO kma_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Daa wa die dɩ hagɩ a kuli tigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Die kpɩkpaakʋ die dɩ yene die wo, die ŋmaamɩŋ die dɩ yigi be, ta die bɩrɩ Ŋmɩŋ ʋ nagɩna yikoke mi dɩ sɩna naa a yɩ vuota. ");
INSERT INTO kma_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisa die dɩ nyɩnna mi a chʋŋ gara die ʋ ye daa wʋnyɩ die ba wasɩnana Matiwo, ta ʋ kalɩ ʋ tʋʋma jigiŋ lampotuosiriŋ juoŋ me. Die ʋ balɩ a yɩ wa “Hagɩ a dɩa mɩŋ.” Die ʋ hagɩ dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yisa die dɩ gana Matiwo tigiri a ga die nyindiikehe, mi lampotuosiriŋ pam aŋaŋ vuodiekemba dɩ kana a ka dɩ Juu vuosi mɩraha die dɩ keŋ a gʋtɩ Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba ma ma a die aŋaŋ ba. ");
INSERT INTO kma_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasisi bataŋ die dɩ yene die wo die ba pɩasɩ Yisa kʋaŋandɩɩsɩrɩba dɩ, “Bɩa yine nɩ dɩdagɩrʋ wa dɩ die aŋaŋ vuosi gie?” ");
INSERT INTO kma_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisa die dɩ wʋŋ ba pɩasɩkʋ, a die a yiŋŋi a balɩ a yɩ ba dɩ, “Vuodiekemba dɩ yalla alaafɩa ka yaala gbɩgbaantʋ, sie vuodiekemba dɩ yʋagɩna. ");
INSERT INTO kma_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nɩ gamma Ŋmɩŋ gbaŋkʋ ma a daansɩ ye wɩɩrɩ gie chɩaŋ dɩ, ‘Zɔɔlɩŋ chɩgɩŋ maŋ yaala daa dɔŋɩsɩ kaabɩŋ.’ N ka keŋye dɩ n wa sʋgɩyɩalɩntieliŋ ama n keŋ dɩ n wa wa tʋmbɩatɩtieliŋ.” ");
INSERT INTO kma_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Womi Jɔɔn vuodieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ Yisa jigiŋ a pɩasɩ wa dɩ, “Bɩa yine tɩnɩŋ aŋaŋ Farasisi dɩ bɔba nʋaŋ saŋŋa mana ama ta fʋ kʋaŋandɩɩsɩrɩba ka wɔŋ a bɔba?” ");
INSERT INTO kma_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yisa die dɩ yiŋŋi a pɩasɩ ba dɩ, “Nɩ tɩŋ yaala chaaŋ diekemba dɩ gana hɔgʋ faarɩŋ bemme aŋaŋ sʋgɩchʋʋsɩŋ saŋŋa dieke ba ŋaaŋ hɔgʋ wa tieŋ dɩ lagɩsɩna a beri wo? Die kaaŋ bɩagɩ a yi. Ama saŋŋa nan keŋ ba nan nagɩ hɔgʋ wa tieŋ a nyɩŋ ba jigiŋ, saŋka mi ba nan wa bɔbɩ nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Vuoŋ kaaŋ saagɩ a nagɩ garɩhaalɩŋ garɩchɔɔtɩŋ a baalɩ a ligi garɩkʋʋŋ vɔrɩŋ, dama garɩhaalɩkʋ gie nan chɩɩrɩ ta vaa garɩkʋʋrɩ, aŋ ka vɔrɩkʋ wa a faasɩ a dalɩma. ");
INSERT INTO kma_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yaa nɩ yeye ta vuoŋ nagɩ daahaalɩŋ a suu gbanɩŋ koliti diekemba dɩ yine nyɩŋkʋra ma? Dama ʋ yi die, daabʋ nan kʋŋ a chɩɩrɩ kolititi aŋ daabʋ aŋaŋ kolititi mana taaŋ yɔrɩ. Ama ʋ ŋaaŋ nagɩ wa daahaalɩŋ a suu gbanɩŋ koliti diekemba dɩ yine nyɩŋhaala aŋ a mana vɩɩŋma.” ");
INSERT INTO kma_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisa die dɩ balala naa ta die Juu vuosi jakʋʋŋ wʋnyɩ die dɩ keŋ a gbirigi ʋ nɩŋŋa a baarɩ, “Lele n havʋʋbiŋ dɩ kpi ama keŋ a nagɩ fʋ nuuŋ a dɩɩsɩ ʋ sikpeŋ aŋ ʋ hagɩ.” ");
INSERT INTO kma_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naa wɩa die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ hagɩ a dɩ ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hɔgʋ wʋnyɩ zɩŋ die dɩ nyɩna ʋ nyɩŋgbanɩŋ ma dee bɩna baŋ aŋaŋ ale; die dɩ dɩ Yisa kʋaŋ a die a gbi Yisa jayeekiri kʋanʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Die ʋ yile ʋ sʋŋ ma, “Maŋ gbi ʋ jayeekiri, n nan ye gbaanɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yisa die dɩ yiŋŋi a ye wo ta baarɩ, “N lɩa, vaa fʋ sʋŋ dʋa, fʋ yada gbaanna fʋ.” Saŋka mi gbaŋ gbaŋ hɔgʋ wa die dɩ ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ta die Yisa die dɩ wana a ga jakʋʋrɩ tigiri, a ye hanye chɩarɩba aŋaŋ vuodiekemba dɩ kʋnnana kumbu, ");
INSERT INTO kma_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","die ʋ baarɩ “Vuoŋ mana tɩaŋ a nyɩŋ. Havʋʋbike ka kpiye, ʋ ta ko a gʋʋra mɩŋ.” Die vuosi mana die dɩ dɔŋ laatɩ a laa wa. ");
INSERT INTO kma_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Die daadamba dɩ wana a nyɩŋ yenni me wo, Yisa die dɩ ga a juu havʋʋbike dɩ dʋana jigidieke a yigi ʋ nuuŋ me die ʋ hagɩ a zie. ");
INSERT INTO kma_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Die ba mʋʋlɩ wɩɩrɩ gie tɩŋgbaŋka ma mana. ");
INSERT INTO kma_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisa die dɩ nyɩnna mi a chʋŋ gara dembisi bale die dɩ yine yɩɩsɩ die dɩ dɩ ʋ kʋaŋ a nata a bala dɩ, “Fʋnɩŋ naaŋ Davidi haagɩŋ, chɩgɩ tɩ zɔɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Die Yisa die dɩ gana a ga a juu juoŋ kaanɩ yɩɩsɩ bale wo die dɩ keŋ ʋ jigiŋ, die ʋ pɩasɩ ba, “Nɩ tuo a dii dɩ n nan bɩagɩ yi naa?” Ta ba baarɩ, “Tɩ Yɔmʋtieŋ, wa.” ");
INSERT INTO kma_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Die wɩa ʋ nagɩ ʋ nuusi a gbi gbi ba nine ta baarɩ, “Nɩ tuone a dii die wo ka yi a yɩ nɩ.” ");
INSERT INTO kma_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Die ba ninehe die dɩ yuori. Yisa die dɩ kpaaŋ ba aŋaŋ nɩŋŋmɩna dɩ, “Nɩ da keŋ a balɩ a yɩ vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama die ba nyɩŋ a mʋʋlɩ Yisa wɩa tɩka mana ma. ");
INSERT INTO kma_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Die ba nyɩnnana, vuosi bataŋ die dɩ yaa daa wʋnyɩ die jɩmbɩaŋ die dɩ yalla wa ʋ ka bɩagɩ bala wɩa a keŋ Yisa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yisa die dɩ yagɩ jɩmbɩakʋ a nyɩŋ daa wa ma, die ʋ wa bɩagɩ bala wɩa. Die dɩ paalɩ a yi vuoŋ mana mana mamachi ba baarɩ, “Tɩ ye ka ye mamachi ka gie chanchaaŋ Izara vuosi tɩŋ ma ma.” ");
INSERT INTO kma_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama ta die Farasisi mba die dɩ baarɩ, “Jɩmbɩatɩtɩ naaŋ wa yɩnana wa hagɩrɩbʋ ʋ bɩagɩ yaga jɩmbɩatɩ.” ");
INSERT INTO kma_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisa die dɩ dɩa ga tɩgɩkpɩɩma aŋaŋ tɩŋkpaŋŋɩsɩ mana mana, a die a ga Ŋmɩŋ jɩamɩŋ juone me a daga Ŋmɩŋ naarɩ wʋvɩɩna a yɩa vuosi ta gbaama yʋagɩtɩ yiri yiri mana. ");
INSERT INTO kma_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Die ʋ yene kpɩkpaakʋ, zɔɔlɩŋ die dɩ yigi wo, dama die ba yiwo zɔɔlɩntieliŋ ta wo susuŋŋiŋ mana ta nɩasɩ yiise dɩ wone yiyagɩrʋ. ");
INSERT INTO kma_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Die wɩa die ʋ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba, “Zaaha bieye mɩŋ ta dala ama zaagobiribe ka dala. ");
INSERT INTO kma_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Die wɩa nɩ jʋʋsɩ zaaha tieŋ aŋ ʋ gʋtɩ tʋntʋntɩŋ aŋ ba keŋ gobihe.” ");
INSERT INTO kma_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisa die dɩ wa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a lagɩsɩ ʋ jigiŋ a yɩ ba yiko dɩ ba vʋarɩma jɩmbɩatɩ ta gbaama yʋagɩtɩ yiri yiri aŋaŋ vuodiekemba dɩ yʋagɩna yʋagɩbɩatɩ mana mana. ");
INSERT INTO kma_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ʋ tʋntʋntɩba baŋ aŋaŋ bale wo saara wʋnna; Simoni, (vuodieke ba bɩna a wasa Piita) aŋaŋ ʋ nɩmbʋabiŋ Andurusi; aŋaŋ Jemisi aŋaŋ ʋ nɩmbʋabiŋ Jɔɔn, Zebedi ballɩ; ");
INSERT INTO kma_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","aŋaŋ Filipi aŋaŋ Batolomiwo; aŋaŋ Tomasi aŋaŋ Matiwo, vuodieke die dɩ yine lampotuosiru wo; aŋaŋ Jemisi vuodieke dɩ yine Alifusi bʋa aŋaŋ Tadeusi, ");
INSERT INTO kma_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aŋaŋ Simoni vuodieke dɩ yaala banɩŋ Juu vuosi yalla ba gbaŋ aŋaŋ Judasi Asikaroti, vuodieke die dɩ bala ʋ posi Yisa chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ta Yisa die dɩ tʋŋ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo ta kpaaŋ ba, “Nɩ sɩmma nɩ keŋ a ga vuodiekemba dɩ kana a ka yi Juu vuosi buuriŋ yaa nɩ ga juu Samaria vuosi tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama nɩ gamma Izara vuosi jigiŋ nyɩɩna, ba sɩna sɩba yii diekemba dɩ bana. ");
INSERT INTO kma_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nɩ ganana wa nɩ balɩma Ŋmɩŋ wɩarɩ gie; ‘Ŋmɩŋ naarɩ diile saŋŋa gbigiye mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nɩ gbaama vuodiekemba dɩ yʋagɩna, ta nɩ vaa kunti hagɩ kuŋ me, ta gbaaŋ vuodiekemba gamɩŋ yʋagɩŋ dɩ yalla ba, ta yagɩ jɩmbɩatɩ vuosi ma. Nɩ tuo wo yɔrɩ die wɩa nɩ gbaŋ nɩ nagɩ a yɩ yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nɩ da a keŋ nagɩ ligire. Nɩ sɩmma nɩ keŋ a nagɩ kobu gbaŋ a su nɩ ligire bʋlɔga ma; ");
INSERT INTO kma_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nɩ da keŋ a nagɩ bʋlɔga a gamma nɩ sieku; yaa nɩ pɔgɩlɩ jayeeki gaaŋ a gʋtɩ jadieke nɩ yeegine ma wa, yaa nɩɩrɩ gaasɩ a gʋtɩ nyindiekemba nɩ suune womi, yaa nɩ pɔgɩlɩ daaŋgbanɩŋ. Dama dɩ mʋ aŋ tʋntʋntʋ dii ʋ tʋʋma jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nɩ a keŋ a tʋgɩ tɩgɩkpɩɩŋ yaa tɩgɩbiŋ, nɩ juu a yaalɩ vuodieke dɩ yaalala ʋ tuo nɩ aŋ nɩ bemme ʋ jigiŋ a ga tʋgɩ saŋŋa dieke nɩ baaŋ nan nyɩŋ mi. ");
INSERT INTO kma_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɩ a keŋ a juu tigidieke mana nɩ waasɩ ba vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tigiri mi vuosi dɩ a keŋ a mɩŋŋɩ a tuo nɩ, nɩ vaa nɩ waasɩkʋ aŋaŋ nɩ sʋgɩfɩalɩŋ wɩarɩ ka ma ama ba a keŋ a ka a mɩŋŋɩ a tuo nɩ, nɩ vaa nɩ sʋgɩfɩalɩŋ yiŋŋi keŋ nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ta vuodieke mana dɩ ka tuo nɩ yaa dɩ ka wʋŋ nɩ wʋbalɩkaha nɩ kpaantɩ nɩ naatala tankɔlɩŋ a taaŋ mi saŋŋa dieke nɩ nyɩnnana kanɩŋ tigiri yaa tɩka ma. ");
INSERT INTO kma_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Wusie maŋ bala nɩ daa dieke Ŋmɩŋ dɩ baaŋ nan dii vuosi sarɩya, die tɩka vuosi tɩbɩdatɩŋ nan faasɩ tɩaŋ Sodomi aŋaŋ Gomoraya vuosi tɩbɩdatɩkʋ. ");
INSERT INTO kma_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nɩ wʋmma, n tʋma nɩ sɩba yii diekemba dɩ benne gbaanchʋra sʋnsʋŋ. Die wɩa nɩ yalla yɩaŋ sɩba nyinvuuke ta nɩ bemme sɔmm sɩba ŋmarɩsɩ. ");
INSERT INTO kma_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nɩ sɩmma nɩ gbaŋ aŋaŋ vuotaŋ wɩa, dama ba nan yigi nɩ a yaa nɩ ga sarɩya diile vuosi jigiŋ, ta bɩ nɩgɩ nɩ ba Ŋmɩŋ jɩamɩŋ juone sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba nan nagɩ nɩ a ga tɩka nyɩŋkʋra aŋaŋ naalɩba jige n saaŋ wɩa aŋ nɩ balɩ Ŋmɩŋ wʋvɩɩnaha a yɩ banɩŋ aŋaŋ vuodiekemba dɩ kana ka yi Juu vuosi. ");
INSERT INTO kma_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ama ba keŋ yaa nɩ ga aŋ ba dii nɩ sarɩya nɩ da vaa dɩ mugisi nɩ aŋaŋ nɩ baaŋ nan balɩ die yaa nɩ baaŋ nan yiŋŋi ba die; dama saŋka mi Ŋmɩŋ Haalɩŋ nan yɩ nɩ wudieke nɩ baaŋ nan yiŋŋi a balɩ. ");
INSERT INTO kma_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Dama wudiekemba nɩ bala a baa nɩ balɩ wa kaaŋ nyɩŋ nɩ jigiŋ, ama nɩ Chɔɔŋ Ŋmɩŋ Haalɩbʋ nan dɩ bie nɩ sʋŋ a bala. ");
INSERT INTO kma_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Saŋka mi vuosi nan nagɩ ba gbaŋ gbaŋ ba nɩmballɩ a yɩ dɩ ba kʋʋ ba, chʋalɩŋ gbaŋ nan yi die gbaŋ gbaŋ a yɩ ba ballɩ. Ballɩ dɩaŋ nan yiŋŋi a wagɩ ba chʋalɩŋ aŋaŋ ba nɩɩlɩŋ ta nagɩ ba a yɩ dɩ ba kʋʋ ba. ");
INSERT INTO kma_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta vuosi mana nan dɩ haa nɩ, nɩ dɩna n kʋaŋ wɩa. Ama vuodieke mana dɩ a keŋ a bɩagɩ a tuoli wɩaha a ga a tʋgɩ kpatɩkʋ nan ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ta ba keŋ mugisi nɩ tɩŋ kaanɩ ma, nɩ chɩgɩ a ga tɩgɩgaaŋ. Wusie maŋ bala nɩ, nɩ kaaŋ bɩagɩ kpatɩ nɩ tʋʋmaha Izara tɩgɩsɩ mana ma ta manɩŋ Vuota Bʋa keŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Bʋbʋgɩrʋ ka tɩaŋ ʋ dɩdagɩrʋ; yɔmʋ dɩaŋ ka tɩaŋ ʋ tieŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Die wɩa dɩ mʋ aŋ bʋbʋgɩrʋ sɩmma sɩba ʋ dɩdagɩrɩ wa; ta yɔmʋ dɩaŋ sɩɩ sɩba ʋ tieŋ wo. Ba a keŋ a wa tigiŋ tieŋ jɩmbɩatɩ naaŋ wa Beelizebuli, die nɩŋ lalɩa ba baa ba wa ʋ dembe? ");
INSERT INTO kma_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Die wɩa, nɩ da a keŋ chɩgɩma vuotaŋ ŋmaamɩŋ, dama jadieke mana dɩ lɔbɩrɩna lele nan daansɩ nyɩŋ yaalɩŋ, ta wʋlɔbɩrɩkɩŋ mana dɩaŋ nan nyɩŋ yaalɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wudieke n balala nɩ lɩmɩŋ ma wa, nɩ balɩ ka yaalɩŋ ma; ta wudieke n pʋsɩna balɩ yɩ nɩ wa, nɩ balɩ ka yaalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nɩ da keŋ a chɩgɩma vuodiekemba dɩ baaŋ nan bɩagɩ a kʋʋ nɩ nyɩŋgbaŋka, ama ta kaaŋ bɩagɩ a kʋʋ nɩ haalɩbʋ; ama nɩ chɩgɩma Ŋmɩŋ vuodieke dɩ baaŋ nan bɩagɩ a kʋʋ nɩ nyɩŋgbaŋka aŋaŋ nɩ haalɩbʋ mana boli dieke dɩ wone kpatɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ba daa nembisi ale wo kobu, ama dɩ ka yi tɩ Chɔɔŋ Ŋmɩŋ dʋŋŋʋ, a kaanɩ mana kaaŋ nan tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nɩnɩŋ nɩŋ, Ŋmɩŋ sɩba nɩ zoosi nʋaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Die wɩa nɩ da chɩgɩma ŋmaamɩŋ; dama nɩ yaa nyʋarɩ a tɩaŋ nembisi pam. ");
INSERT INTO kma_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Vuodieke mana dɩ a keŋ a vʋarɩ ʋ gbaŋ vuosi me dɩ ʋ yiwo n vuoŋ, die gbaŋ gbaŋ maŋ nan vʋarɩ wa yaalɩŋ ma n Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama vuodieke dɩ baarɩ ʋ ka yi n vuoŋ vuosi jigiŋ, die gbaŋ gbaŋ maŋ nan balɩ dɩ n ka sɩba wa n Chɔɔŋ dieke dɩ benne arɩzanna ma jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nɩ da keŋ a yilime sɩba sʋgɩfɩalɩŋ maŋ yaa keŋ tɩŋgbaŋka gie vuosi jigiŋ; Aayɩ, n ka keŋ aŋaŋ sʋgɩfɩalɩŋ, ama n keŋ wo aŋaŋ puole. ");
INSERT INTO kma_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N keŋ dɩ n yiwo ballɩ dembisi tuoli ba chʋalɩŋ, ta havʋʋbisi tuoli ba nɩɩlɩŋ, lɩahaalʋ tuoli ʋ nuŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Vuota dataasɩ nan yi ʋ gbaŋ gbaŋ ʋ tigiŋ vuosi. ");
INSERT INTO kma_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Vuodieke mana dɩ chone ʋ chɔɔŋ yaa ʋ nuŋ a tɩaŋ mɩŋ ka mʋ ʋ yi n kʋaŋandɩɩsɩrʋ; vuodieke dɩaŋ dɩ chone ʋ naahaalʋ yaa ʋ havʋʋbiŋ a tɩaŋ mɩŋ ka mʋ ʋ yi n kʋaŋandɩɩsɩrʋ. ");
INSERT INTO kma_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Vuodieke mana dɩaŋ dɩ kana ka vigi ʋ dagarɩkɩŋ a dɩa mɩŋ ka mʋ ʋ yi n kʋaŋandɩɩsɩrʋ. ");
INSERT INTO kma_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Vuodieke mana dɩ yaalala dɩ ʋ gbatɩ ʋ gbaŋ gbaŋ ʋ miivoli nan waarɩ ka; ama vuodieke nɩŋ mana dɩ keŋ waarɩ ʋ miivoli n wɩa wʋnɩŋ nɩŋ nan daansɩ ye ke. ");
INSERT INTO kma_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Vuodieke mana dɩ mɩŋŋɩna a tuo nɩ chaantɩ, mɩŋŋɩ tuo mɩŋ mɩŋ; ta vuodieke dɩaŋ dɩ mɩŋŋɩna tuo mɩŋ, mɩŋŋɩ tuo wo Ŋmɩŋ dieke dɩ tʋnna mɩŋ wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Vuodieke mana dɩaŋ dɩ a keŋ a mɩŋŋɩ a tuo Ŋmɩŋ naazʋa chaantɩ ʋ yine Ŋmɩŋ naazʋa wɩa, nan daansɩ tuo Ŋmɩŋ naazʋa tune; vuodieke dɩaŋ mana dɩ mɩŋŋɩ a tuo sʋgɩyɩalɩntieŋ chaantɩ ʋ yine sʋgɩyɩalɩntieŋ wɩa, nan daansɩ tuo sʋgɩyɩalɩntieŋ tune. ");
INSERT INTO kma_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nɩ sɩmma a baarɩ vuodieke mana dɩ a keŋ a yuori nyasʋnsʋŋ a yɩ n kʋaŋandɩɩsɩrɩba gie wʋnyɩ dɩ ʋ yine n kʋaŋandɩɩsɩrʋ wɩa nan daansɩ ye tune.” ");
INSERT INTO kma_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Die Yisa dɩ dagɩna wɩaha gie a yi ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a kpatɩ wa die ʋ nyɩŋ mi a ga tɩgɩ diekemba die dɩ gbigine mi a bala ta daga Ŋmɩŋ wɩa mi. ");
INSERT INTO kma_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jɔɔn dieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ die bie wo dansarɩka sʋŋ, ta die a wʋŋ Yisa Masia tʋʋma wɩa; die ʋ tʋŋ ʋ kʋaŋandɩɩsɩrɩŋ bataŋ Yisa jigiŋ ");
INSERT INTO kma_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","dɩ ba ga pɩasɩ wa, “Fʋnɩŋ fʋ yine vuodieke dɩ balla ʋ keŋ wo yaa tɩ chɩsɩma vuogaaŋ bɩbra?” ");
INSERT INTO kma_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yisa die dɩ yiŋŋi a balɩ ba, “Nɩ yiŋŋi a ga balɩ Jɔɔn wudieke nɩ wʋnnana ta yese wudiekemba; ");
INSERT INTO kma_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","dɩ nɩ ye ta yɩɩsɩ nine dɩ yuorine, gbarɩgɩsɩ dɩ chʋŋ, ta vuodiekemba die dɩ yʋagɩna gamɩŋ ye wo gbaamɩŋ, tɩkpaara tieŋ dɩ wʋmma, ta kunti dɩ hagɩna kuŋ me, ta zɔɔlɩntieliŋ dɩ wʋmma Ŋmɩŋ wʋbalɩkɩ vɩɩnaha. ");
INSERT INTO kma_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ta sʋgɩfɩalɩŋ bie vuodieke nɩŋ mana dɩ kana ka chɩɩlɩya mɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Die Jɔɔn kʋaŋandɩɩsɩrɩba die dɩ yiŋŋine a gara wa, Yisa die dɩ piili a bala yɩa kpɩkpaakʋ Jɔɔn wɩa, “Die nɩ nyɩnna a ga Jɔɔn jigiŋ haagɩrɩ ma wa, bɩa die nɩ tɩŋ a yaala nɩ ye? Die nɩ tɩŋ yile a baarɩ nɩ ye hʋʋtɩ bʋlɔgɩsɩŋ dɩ nɩgɩnana? ");
INSERT INTO kma_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bɩa die nɩ nyɩŋ ga nɩ ye? Daa dɩ yeegine nyiŋyeekivɩɩna? Vuodieke dɩ yeegine nyiŋyeekivɩɩna bie wo naalɩsɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nɩ balɩ mɩŋ, bɩa die nɩ nyɩŋ ga nɩ ye? Die nɩ yile sɩba nɩ nan ye Ŋmɩŋ naazʋa? Wusie, n bala nɩ, nɩ ye vuodieke dɩ tɩanna Ŋmɩŋ naazʋa. ");
INSERT INTO kma_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jɔɔn wɩa die ba maagɩ Ŋmɩŋ gbaŋkʋ ma a baarɩ, ‘N tʋntʋntʋ wʋnna n baa n tʋŋ wa mɩŋ aŋ ʋ woliŋ dɩa fʋ nɩŋŋa a ga yuori sieku a yɩ fʋ.’ ” ");
INSERT INTO kma_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta Yisa dɩ bɩ a balɩ ba dɩ, “Wusie maŋ bala nɩ ba ye ka mɩɩrɩ vuodieke dɩ tɩanna Jɔɔn dieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ, ama vuodieke dɩ yine vuobiŋ Ŋmɩŋ naarɩ ma tɩaŋ wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A nyɩŋ saŋŋa dieke Jɔɔn die dɩ balala Ŋmɩŋ wɩaha gie a keŋ tʋgɩ jinne, vuodiekemba nine dɩ ŋmɩntɩna Ŋmɩŋ naarɩ juule wɩa, pɔgɩlɩha aŋaŋ nɩŋŋmɩna dɩ ba juu aŋaŋ hagɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ŋmɩŋ naazʋalɩba mana aŋaŋ Ŋmɩŋ mɩraha die balɩ ʋ naarɩ gie wɩa ta Jɔɔn dɩ wa keŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta nɩ a keŋ a yaala nɩ tuo wɩaha dii, Jɔɔn yine Ŋmɩŋ naazʋa Elaja, vuodieke die dɩ balla ʋ keŋ wo. ");
INSERT INTO kma_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Vuodieke dɩ yallɩ tɩba ʋ wʋŋ.” ");
INSERT INTO kma_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Lele, bɩa maŋ baa n nagɩ jinne vuosi gie a magɩsɩ? Ba nɩasɩ wa ballɩbɩsɩ dɩ kalla nyʋʋgɩtɩ jige, a wasa tamba. ");
INSERT INTO kma_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tɩ wɩwa wɩɩŋ a yɩ nɩ ama nɩ ka sieye, ta tɩ chɩa hanye a yɩ nɩ ama nɩ ka kʋŋya.’ ");
INSERT INTO kma_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jɔɔn die dɩ keŋ ta bɔba nʋaŋ ta ka nyuu daaŋ vuosi dɩ baarɩ dɩ, ‘Jɩmbɩaŋ yalla wa.’ ");
INSERT INTO kma_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta manɩŋ vuota Bʋa die dɩ keŋ, a die ta nyuo, vuosi dɩ baarɩ, ‘Nɩ ye daa wa gie ʋ yiwo wutulitieŋ aŋaŋ daanyuru, ta yi lampotuosiriŋ aŋaŋ vuobɩatɩ zʋa.’ Ama Ŋmɩŋ dɩ tʋnna die wo dagɩya sɩba ʋ yaa yɩaŋ vɩɩnɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vuodiekemba die dɩ benne tɩgɩ diekemba ma ma Yisa die dɩ yine ʋ mamachi wɩa die, ta ka chɩgɩ a nyɩŋ ba tʋmbɩatɩ ma, die wɩa die ʋ galɩŋ ba. ");
INSERT INTO kma_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Die ʋ baarɩ dɩ, “Wʋbɩaŋ bie nɩnɩŋ Korazini vuosi me! Wʋbɩaŋ bie nɩnɩŋ Befisada vuosi ma ma! Dama mamachi wudieke n yine nɩ tɩgɩsɩ ma, maŋ tɩŋ a yi die Taya aŋaŋ Sidoni ma ma, vuodiekemba dɩ benne mi wo tɩŋ nan vaa ba tʋmbɩatɩ ta nagɩ vaatɩ aŋaŋ tanyeeliŋ a bʋʋlɩ ba gbaŋ aŋ die dagɩ sɩba ba chɩgɩ nyɩŋ ba tʋmbɩatɩ ma ma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nɩ vaa n balɩ nɩ, dɩ daa dieke Ŋmɩŋ dɩ baaŋ nan dii vuosi sarɩya nɩ tɩbɩdatɩŋ nan faasɩ dala pam a tɩaŋ Taya aŋaŋ Sidoni vuosi sarɩya. ");
INSERT INTO kma_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta nɩnɩŋ Kapenɔmi vuosi aŋaŋ nɩ kɔtɩna nɩ gbaŋ gbaŋ ŋmɩŋsikpeŋ mana, Ŋmɩŋ nan vigi nɩ a taaŋ kunti jigiberisikiŋ dama mamachi diekemba die n yine nɩ jigiri die dɩ tɩŋ yi Sodomi ma ma dɩ mʋna naa a tɩŋ ye beri a ga tʋgɩ jinne. ");
INSERT INTO kma_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ama n bala nɩ, sarɩyaka diile daraaŋ nɩ tɩbɩdatɩŋ nan faasɩ dala a tɩaŋ Sodomi vuosi tɩbɩdatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Saŋka mi Yisa die dɩ baarɩ, “N Chʋa Ŋmɩŋ, vuodieke dɩ yine ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie tieŋ, n bɩra fʋ, dama fʋnɩŋ lɔbɩrɩ wɩaha gie yɩantieliŋ aŋaŋ sɩsɩbɩrɩŋ jigiŋ ama ta yuori he a yɩ ballɩbɩsɩ; ");
INSERT INTO kma_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","dama die fʋ tʋma fʋ tʋʋma a yie fʋ nansɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“N Chʋa Ŋmɩŋ nagɩ wa jaaŋ mana a yɩ mɩŋ; vuoŋ ka sɩba manɩŋ Ŋmɩŋ Bʋa wa sie n Chɔɔŋ wa Ŋmɩŋ, vuoŋ dɩaŋ ka sɩba n Chɔɔŋ wa Ŋmɩŋ sie manɩŋ Ŋmɩŋ Bʋa wa aŋaŋ vuodiekemba n yaala n nagɩ wa a dagɩ. ");
INSERT INTO kma_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nɩ keŋ n jigiŋ nɩnɩŋ vuodiekemba dɩ chiine chiidʋnsa aŋ n yɩ nɩ voosiŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nɩ nagɩ n chiiti a chii ta nɩ bʋgɩrɩ a nyɩŋ n ma dama n yiwo vuodieke dɩ sʋʋna n gbaŋ tɩŋgbaŋ ta mɩŋŋɩ pɔgɩlɩ n gbaŋ ta nɩ nan ye voosiŋ. ");
INSERT INTO kma_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Dama n kʋaŋ dɩɩsɩŋ ka tʋa ta n chiiti dɩaŋ dɩ ka dʋnsɩ.” ");
INSERT INTO kma_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Die dɩ yine daraa ale kʋaŋ chaaŋ die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba dɩ chʋŋ tɩanna zaa kʋaŋ ma davʋʋsɩkɩrɩ daraaŋ; ta kɔŋ die dɩ yallɩ ʋ kʋaŋandɩɩsɩrɩba, die wɩa die ba piili a gobe zaaha yɩaga ŋɔba. ");
INSERT INTO kma_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasisi bataŋ die dɩ yene die wo ba balɩ a yɩ Yisa, “Daansɩ fʋ kʋaŋandɩɩsɩrɩba dɩ yinene wudieke tɩ mɩraha dɩ kana ka yɩ sieŋ dɩ tɩ yime davʋʋsɩkɩrɩ daraaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Die Yisa dɩ yiŋŋi a balɩ ba, “Nɩ ye ka karɩŋ Ŋmɩŋ gbaŋkʋ sʋŋ Davidi dɩ yine wudieke saŋŋa dieke kɔŋ dɩ yalla wa aŋaŋ ʋ kʋaŋanvuosisi? ");
INSERT INTO kma_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Die ʋ ga a juu wo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma wʋnɩŋ aŋaŋ ʋ kʋaŋanvuosisi dɩ nagɩ paanʋ dieke die ba nagɩna a yɩ Ŋmɩŋ a ŋɔbɩ wudieke die Ŋmɩŋ mɩraha dɩ kana ka yɩ sieŋ dɩ vuogaaŋ ŋɔbɩ, die paanʋ sie Ŋmɩŋ jɩamɩŋ nɩŋŋandɩɩsɩrɩba nyɩŋkʋra nyɩɩna. ");
INSERT INTO kma_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yaa nɩ ka karɩŋ Ŋmɩŋ mɩraha gbaŋkʋ ma, dɩ davʋʋsɩkɩrɩ daaŋ mana Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha dɩ benne Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma ŋaaŋ tʋma tʋʋma mi davʋʋsɩkɩrɩ daaŋ mana a chʋsa mɩraha ama ta wo chʋʋsɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ama n bala nɩ vuodieke dɩ tɩanna Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ benne giena. ");
INSERT INTO kma_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dɩ maagɩya Ŋmɩŋ gbaŋkʋ ma dɩ, ‘Ŋmɩŋ yaala zɔɔlɩnchɩgɩrɩŋ a tɩaŋ nɩ kaaba.’ Nɩ tɩŋ sɩba wɩɩrɩ gie chɩaŋ, nɩ tɩŋ kaaŋ dɩ galɩma vuodiekemba dɩ kana ka chʋʋsɩya; ");
INSERT INTO kma_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","dama manɩŋ vuota Bʋa wa yine davʋʋsɩkɩrɩ daarɩ tieŋ.” ");
INSERT INTO kma_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisa die nyɩŋ mi a ga juu ba Ŋmɩŋ jɩamɩŋ juoŋ kaanɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta daa wʋnyɩ die benne mi a yaa nuukpiikiŋ. Vuosi bataŋ die benne mi a yaala sieti dɩ ba ye Yisa chʋʋsɩŋ ta galɩŋ wa, die wɩa die ba pɩasɩ wa, “Tɩ mɩraha yɩ sieŋ mɩŋ dɩ vuoŋ gbaaŋ yʋagɩtieŋ davʋʋsɩkɩrɩ daraaŋ?” ");
INSERT INTO kma_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Die ʋ yiŋŋi a balɩ ba dɩ, “Nɩ wʋnyɩ dɩ keŋ yallɩ yiisiŋ ka nan goliŋ me davʋʋsɩkɩrɩ daraaŋ, ʋ tɩŋ kaaŋ yigi ke a vʋarɩ ka a nyɩŋ goliku me? ");
INSERT INTO kma_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nɩ ka sɩba a baarɩ vuota yaa nyʋarɩ a tɩaŋ yiisiŋ mɩŋ, die wɩa tɩ mɩraha yɩ tɩ sieŋ dɩ tɩ suŋŋi vuoŋ davʋʋsɩkɩrɩ daraaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Die ʋ balɩ a yɩ nuukpiikiri tieŋ dɩ, “Tɩɩrɩ fʋ nuuke.” Die ʋ tɩɩrɩ ka die ka mana dɩ tɩɩntɩ, a sɩɩ sɩba kaanɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ama die Farasisi die dɩ nyɩŋ saŋ ba baaŋ kʋʋ Yisa dene. ");
INSERT INTO kma_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Die Yisa die dɩ sɩbɩna ba saŋkʋ wɩaha die ʋ nyɩŋ mi, ta vuosi pam die dɩ dɩ ʋ kʋaŋ. Die ʋ gbaaŋ yʋagɩtieliŋ mana, ");
INSERT INTO kma_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ta kpaaŋ ba dɩ ba da keŋ a balɩ a yɩ ba chanchaalɩŋ ʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Die ʋ yiwo naa amʋ Ŋmɩŋ naazʋa Azaya die dɩ bala die wo keŋ yi wusie. ");
INSERT INTO kma_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nɩ ye, n bʋavʋarɩkɩŋ wʋnna, wʋnɩŋ maŋ faasɩ cho, ʋ ma n sʋŋ dɩ fɩalɩ. N nan nagɩ n Halɩkasɩka a yi ʋ ma, aŋ ʋ balɩ vuodiekemba dɩ kana ka yi Juu vuosi dɩ ba nan ye gbatɩtaanɩŋ n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ʋ kaaŋ dɩ nɩga nɩnhagɩrɩŋ yaa a nata yaa a zie sieti me faasɩ bala wɩa pam pam. ");
INSERT INTO kma_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ʋ kaaŋ wɩɩ yɩbɩkʋʋkɩŋ dieke dɩ goorine a tɩɩntɩ yaa a kpisi popoli dieke dɩ kana a ka mɩŋŋɩ a die. Ntaala ʋ yi wusie sarɩya diile keŋ ye nyaŋŋɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ʋ saaŋ wɩa, vuodiekemba dɩ kana a ka yi Juu vuosi nan dɩ yallɩ tama.” ");
INSERT INTO kma_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Womi vuosi bataŋ die dɩ chii daa wʋnyɩ dɩ yine yɩɩ aŋaŋ gaamʋ dama jɩmbɩaŋ die yalla wa; ta Yisa die dɩ gbaaŋ wa, die ʋ bɩagɩ a bala wɩa ta yese. ");
INSERT INTO kma_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Die dɩ yi daadamba mana mamachi aŋaŋ Yisa die dɩ yine die wo wɩa, die ba pɩasa taŋ dɩ, “Daa wa gie yiwo Naaŋ Davidi haagɩŋ yaa?” ");
INSERT INTO kma_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama Farasisi die dɩ wʋnna naa, die ba baarɩ dɩ, “Jɩmbɩatɩ naaŋ wa Beelizebuli die yine daa wa gie yiko dɩ ʋ vʋarɩma jɩmbɩatɩ vuosi ma.” ");
INSERT INTO kma_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yisa die dɩ mɩŋŋɩ ba yilinene wudieke ta yiŋŋi a balɩ ba dɩ, “Tɩŋgbaŋ dieke mana dɩ puonene ka gbaŋ a waga taŋ kaaŋ faasɩ a yʋasɩ. Tigidieke dɩaŋ yaa buuri dieke dɩ puonene ka gbaŋ a waga taŋ nan nan. ");
INSERT INTO kma_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dɩɩ yi sɩba Sitaani vʋarɩna Sitaani vuosi sʋŋ, dɩ dagɩ sɩba ʋ yiŋŋi a waga ta puo wo ʋ gbaŋ; lalɩa ʋ naarɩ dɩ baa ka zie? ");
INSERT INTO kma_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dɩ yiwo Beelizebuli yɩnana mɩŋ yiko maŋ vʋara jɩmbɩatɩ vuosi ma, ta nɩnɩŋ nɩŋ mɩnɩa yɩnana nɩ vuosisi yiko dɩ ba vʋarɩmaha? Nɩ vuosi gbaŋ gbaŋ tʋʋma daga sɩba nɩ wo wusie. ");
INSERT INTO kma_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama manɩŋ nɩŋ, Ŋmɩŋ Halɩkasɩka yinene maŋ vʋara jɩmbɩatɩ vuosi ma; die dagɩna sɩba Ŋmɩŋ naarɩ keŋ nɩ jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Vuoŋ kaaŋ bɩagɩ a wɩɩ a juu hagɩrɩtieŋ tigiŋ a vaarɩ ʋ nyinti, ntaala ʋ woliŋ a bɔbɩ wa ta wa bɩagɩ a vaarɩ ʋ nyintiti. ");
INSERT INTO kma_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Vuodieke mana dɩ kana ka zie n kʋaŋ waga mɩŋ mɩŋ; ta vuodieke mana dɩ kana ka suŋŋi mɩŋ a lagɩsa vuosi n jigiŋ yiwo vuodieke dɩ jatɩnana ba. ");
INSERT INTO kma_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Naa chɩaŋ ma, maŋ bala nɩ, Ŋmɩŋ nan nagɩ a chaa vuotaŋ wʋbɩatɩ aŋaŋ wʋbɩa diekemba ʋ balala mana; ama vuodieke mana dɩ balɩ wʋbɩaŋ a yɩ Ŋmɩŋ Halɩkasɩka, Ŋmɩŋ kaaŋ nagɩ ʋ taalɩ a chaa wa. ");
INSERT INTO kma_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Vuodieke dɩaŋ mana mana dɩ keŋ balɩ wʋbɩaŋ a yɩ manɩŋ vuota Bʋa wa Ŋmɩŋ nan nagɩ ʋ taalɩ a chaa wa; ama vuodieke nɩŋ mana dɩ keŋ balɩ wʋbɩaŋ a yɩ Ŋmɩŋ Halɩkasɩka, Ŋmɩŋ kaaŋ wɔŋ nagɩ ʋ taalɩ a chaa wa dʋnɩa ka gie me yaa dʋnɩa dieke dɩ bala ka keŋ wo.” ");
INSERT INTO kma_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ta Yisa die dɩ bɩ balɩ dɩ, “Dɩɩ yi ta tɩɩŋ dɩ vɩɩna, ka nyɩna nyɩŋnyɩŋka vɩɩna; ama dɩɩ yi ta tɩɩŋ dɩ ka vɩɩna, ka ŋaaŋ nyɩŋ wa nyɩŋnyɩŋka bɩatɩ dama tɩɩŋ nyɩŋnyɩŋka ma ba sɩba ka. ");
INSERT INTO kma_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nɩnɩŋ nyinvuuke buuribu gie, nɩ yine vuobɩatɩ die, lalɩa wʋbalɩkɩ vɩɩna dɩ nan bɩagɩ a nyɩŋ nɩ nʋa ma? Dama jadieke vuota dɩ yiline ʋ sʋŋ ma die nyɩnnana ʋ nʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vuovɩɩnɩŋ yie wʋvɩɩna, dama ʋ sʋŋ vɩɩna mɩŋ; ta vuobɩaŋ dɩaŋ dɩ yie wʋbɩatɩ dama ʋ sʋkʋ ka vɩɩna. ");
INSERT INTO kma_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“N bala nɩ, sarɩya diile daraaŋ Ŋmɩŋ nan dii vuosi sarɩya sɩba die ba balala wʋtɔgɩtɩ mana wɩa, ");
INSERT INTO kma_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","dama vuoŋ mana wʋbalɩka bala ka vʋarɩ wa dɩnda daarɩ mi yaa ʋ wʋbalɩka dɩaŋ bala ka chʋʋsɩ wa.” ");
INSERT INTO kma_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Womi mɩraha dɩdagɩrɩba bataŋ aŋaŋ Farasisi bataŋ die dɩ balɩ Yisa dɩ, “Dɩdagɩrʋ tɩ yaala fʋ yiwo mamachi wɩɩŋ aŋ tɩ ye.” ");
INSERT INTO kma_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ama die ʋ yiŋŋi a balɩ, “Lele vuosi dɩ yine vuobɩatɩ ta ka bɩ jɩama Ŋmɩŋ yaalala ba ye mamachi wɩɩŋ; ama n kaaŋ wɔŋ yi mamachi wɩɩŋ a yɩ ba; Ŋmɩŋ naazʋa Jona dagɩŋ chanchaaŋ nyɩɩna maŋ nan dagɩ ba. ");
INSERT INTO kma_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Die Jona dɩ benne zaasɩkpɩɩkʋ sʋkʋ ma ŋmɩntʋasɩ aŋaŋ yuŋ a ga tʋgɩ daraa ataa wa, die gbaŋ gbaŋ manɩŋ vuota Bʋa dɩaŋ dɩ nan dɩ beri tɩŋgbaŋka gie chɩaŋ ŋmɩntʋasɩ aŋaŋ yuŋ a ga tʋgɩ daraa ataa. ");
INSERT INTO kma_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sarɩya diile daraaŋ Nineva vuosi nan hagɩ zie a galɩŋ nɩ, dama Jona dɩ mʋʋlɩna Ŋmɩŋ wɩa a yɩ ba wa die ba va ba tʋmbɩatɩ mɩŋ; n bala nɩ, vuodieke dɩ tɩanna Jona benne gie. ");
INSERT INTO kma_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sarɩya diile daraaŋ Siaba hɔgʋ naaŋ wa nan hagɩ a zie a galɩŋ nɩ dama die ʋ paalɩ nyɩŋ wa tɩgɩ saasaa a ga dɩ ʋ wʋŋ naaŋ Solomoni yɩaŋ wʋbalɩkaha, ama n bala nɩ vuodieke dɩ tɩanna naaŋ Solomoni benne giena. ");
INSERT INTO kma_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Dɩɩ yi ta jɩmbɩaŋ dɩ keŋ nyɩŋ vuota ma, ka ŋaaŋ dɩa wa jigikʋʋkɩŋ a yaala jigiŋ dɩ ka voosi, ka ka yeye; ");
INSERT INTO kma_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ʋ ŋaaŋ balɩ a yɩ wa ʋ gbaŋ gbaŋ dɩ, ‘N nan yiŋŋi a ga n tigidieke n vana wa.’ Die wɩa ka ŋaaŋ yiŋŋi ga mi a ye dɩ vuoŋ wo mi, ta ka sʋŋ mana saarɩya a wʋnsɩ vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ka ŋaaŋ wa nyɩŋ mɩŋ a ga a chii jɩmbɩatɩ diekemba dɩ tɩanna ka gbaŋ gbaŋ ayʋpɔyɩ aŋ a ga bemme mi. Naa chɩaŋ ma daa wa beriŋ nan faasɩ chʋʋsɩ pam a tɩaŋ die ʋ sɩna die wo. Naa bala ka yi a yɩ lele gie vuobɩatɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisa die ye ko bala wɩa a yɩa vuotamba ta ʋ nuŋ aŋaŋ ʋ nɩmballɩ dɩ keŋ tʋgɩ. Die ba zie wo yeŋ me ta tʋŋ vuoŋ dɩ ʋ wa wa aŋ ba balɩ wɩa. ");
INSERT INTO kma_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Die wɩa vuoŋ wʋnyɩ die dɩ balɩ wa dɩ, “Daansɩ ye, fʋ naa aŋaŋ fʋ nɩmballɩ zie yeŋ me ta yaala ba aŋaŋ fʋ balɩ wɩa.” ");
INSERT INTO kma_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yisa die dɩ yiŋŋi a baarɩ, “Mɩnɩa yine n naa? Mɩnɩa yine n nɩmballɩ?” ");
INSERT INTO kma_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Womi ʋ nagɩ ʋ nuuŋ a dɩɩŋ ʋ kʋaŋandɩɩsɩrɩba ta baarɩ, “Ye, n naa aŋaŋ n nɩmballɩ wʋnna. ");
INSERT INTO kma_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dama vuodieke mana dɩ yinene wudieke n Chʋa Ŋmɩŋ dɩ benne arɩzanna ma choti wʋnɩŋ ʋ yine n nɩmbʋa aŋaŋ n taa aŋaŋ n naa.” ");
INSERT INTO kma_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dɩnɩŋ daarɩ mi Yisa die dɩ nyɩŋ tigiri me a ga mʋgɩkpɩɩrɩ chaaŋ a sʋʋŋ kalɩ mi dɩ ʋ dagɩ. ");
INSERT INTO kma_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta daadamba die dɩ geline wo die faasɩ dala mɩŋ, die wɩa die ʋ ga juu haarɩŋ a kalɩ ka sʋŋ, ta die daadamba die dɩ zie mʋgɩkpɩɩrɩ kʋanʋarɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Die ʋ nagɩ wa nandaga a balɩ ba wɩa pam dɩ, “Daa wʋnyɩ die hagɩna daaŋ kaanɩ a ga dɩ ʋ bʋrɩ ʋ nyɩŋbʋra. ");
INSERT INTO kma_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Die ʋ bʋrɩnana nyɩŋbʋrɩkaha kʋaŋ ma wa, ataŋ die dɩ nan sieŋ me, nembisi die dɩ keŋ a dii he. ");
INSERT INTO kma_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ataŋ dɩaŋ die dɩ nan taŋ sikpeŋ jigidieke tantɩ die dɩ kana ka faasɩ dala. Die nyɩŋbʋrɩkaha die dɩ nyʋʋŋ lagɩ lagɩ dama tantɩ die ka faasɩ dala wa wɩa, ");
INSERT INTO kma_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ama die ŋmɩŋ die dɩ nyɩŋ a faasɩ tʋa a mana die dɩ ko dama a dagɩrɩsɩ die ka sʋʋŋya die wɩa a mana die dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta ataŋ dɩaŋ die dɩ nan haŋgɔɔsɩ dagɩrɩsɩ ma, ta a mana die dɩ lagɩsɩ nyʋʋŋ a bɩrɩŋ, ama haŋgɔɔsɩsɩ die dɩ nyagɩ nyɩŋbʋraha. ");
INSERT INTO kma_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ataŋ dɩaŋ die dɩ nan tɩŋgbaŋ vɩɩnɩŋ ma die a mɩŋŋɩ yi bie; ataŋ die yi bie kɔbɩga kɔbɩga ataŋ dɩaŋ baŋɩsɩ-yʋaba yʋaba ataŋ dɩaŋ baŋɩsɩ-taa taa.” ");
INSERT INTO kma_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yisa die dɩ balɩ a kpatɩ ba dɩ, “Vuodieke mana dɩ yalla tɩba ʋ wʋmma.” ");
INSERT INTO kma_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Die wɩa die ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a pɩasɩ wa dɩ, “Bɩa wɩa fʋ naga nandaga bala yɩa ba?” ");
INSERT INTO kma_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Die ʋ yiŋŋi a balɩ ba dɩ, “Nɩnɩŋ nɩŋ Ŋmɩŋ yɩ nɩ sieŋ dɩ nɩ sɩmma wʋlɔbɩrɩkɩŋ wɩa yaa gamma ʋ naarɩ wɩa ama banɩŋ ba nɩŋ ʋ ka yɩ ba sieŋ. ");
INSERT INTO kma_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Vuodieke dɩ sɩbɩna Ŋmɩŋ wɩa, wʋnɩŋ ʋ yenene a gʋta aŋ ʋ faasɩ yallɩma pam, ama vuodieke dɩ wone, ʋ nan waarɩ bɩta dieke ʋ yalla gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wudieke wɩa n nagɩnana nandaga a daga ba yiwo, ba daansa mɩŋ ama ba ka yese, ta chɩɩsa a wʋmma, ama ba ka sɩba a chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Die wɩa Ŋmɩŋ naazʋa Azaya die dɩ balla wudieke wo keŋ yi wusie ba wɩɩrɩ ma. Die ʋ balɩ dɩ Ŋmɩŋ baarɩ, ‘Vuosisi gie nan seŋ wʋŋ, ama ba kaaŋ dɩ sɩba a chɩasɩ, ba nan seŋ daansɩ ama ba kaaŋ dɩ sɩba jadieke ba yene wo chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dama vuosi gie yɩaŋ ligiye mɩŋ ta ba tɩba dɩaŋ dɩ hagɩrɩ, ta ba bɩ ligi ba nine, dama ba ka yaala ba ye jaaŋ, ta ka bɩ yaala ba wʋŋ wɩɩŋ, ta ka yaala ba yɩaŋ yuori, ta ka bɩ yaala ba vaa ba wʋbɩatɩ aŋ n gbaaŋ ba.’ ");
INSERT INTO kma_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nɩnɩŋ nɩŋ nɩ yaa sikpeŋ nansɩŋ, dama nɩ nine yese mɩŋ ta nɩ tɩba dɩaŋ dɩ wʋmma wɩa. ");
INSERT INTO kma_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ama n balɩ nɩ wusie, Ŋmɩŋ naazʋalɩŋ aŋaŋ vuodiekemba die dɩ chɩgɩnana Ŋmɩŋ pam tɩŋ yaala ba ye jadieke nɩ yene wo ama ba ka yeke; ta tɩŋ bɩ yaala ba tɩŋ wʋŋ wudieke nɩ wʋnna wa ama ba ka wʋŋ ka. ");
INSERT INTO kma_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nɩ wʋmma ta bʋgɩrɩ bʋbʋrɩtʋ nandagɩrɩ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vuodieke dɩ keŋ wʋŋ Ŋmɩŋ naarɩ wʋvɩɩnaha gie ta ka sɩba a chɩasɩ, Sitaani ŋaaŋ keŋ vʋarɩ wa wudieke dɩ juune ʋ sʋŋ ma; die yine nyɩŋbʋrɩ dieke dɩ nanna sieku me. ");
INSERT INTO kma_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nyɩŋbʋrɩ diekemba dɩ nanna tanjaalɩka sikpeku sɩɩ sɩba vuodieke dɩ ŋaana a wʋŋ Ŋmɩŋ wɩaha ta tuohe lagɩ lagɩ aŋaŋ sʋgɩfɩalɩŋ; ");
INSERT INTO kma_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ama wɩaha ka sʋʋna ba sʋgɩtɩ ma ta a yʋasa. Die wɩa wahala yaa mugisiŋ dɩ keŋ wɩaha wɩa, ba ŋaaŋ nagɩ wɩaha a taaŋ bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nyɩŋbʋrɩ diekemba dɩ nanna haŋgɔɔsɩ jigiri sɩɩ sɩba vuodiekemba dɩ ŋaana wʋŋ Ŋmɩŋ wɩaha, ama ta tɩŋgbaŋka gie wahala aŋaŋ nyinti yaalɩŋ nyagɩ wɩaha ʋ wʋnna wa ʋ sʋŋ ma, ta ka ka nyɩnna nyɩŋnyɩŋka. ");
INSERT INTO kma_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ama nyɩŋbʋrɩ diekemba dɩaŋ die dɩ nanna tɩŋgbaŋ vɩɩŋkʋ ma sɩɩ sɩba vuodiekemba dɩ ŋaana wʋŋ wɩaha ta sɩba a chɩasɩ; ta nyɩŋ nyɩŋnyɩŋka, a taŋ kɔbɩga kɔbɩga bataŋ dɩaŋ baŋɩsɩ-yʋaba yʋaba bataŋ dɩaŋ baŋɩsɩ-taa taa.” ");
INSERT INTO kma_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Die Yisa dɩ bɩ a taaŋ ba nandagɩŋ dɩ, “Ŋmɩŋ naarɩ sɩɩ sɩba daa wʋnyɩ die dɩ bʋrɩna zaabʋrɩvɩɩna ʋ kʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ama yuŋ kaanɩ vuoŋ mana die dɩ gʋʋrɩnana ʋ dataaŋ die dɩ ga a ga bʋrɩ huuti a gʋtɩ ʋ zaaha ma ta yiŋŋi ga. ");
INSERT INTO kma_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Die zaaha die dɩ bɩrɩna a piili dɩ a yi sikpigile die huutiti dɩaŋ die dɩ hagɩ. ");
INSERT INTO kma_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Daa wa tʋntʋntɩŋ die dɩ keŋ ʋ jigiŋ a pɩasɩ wa dɩ, ‘Jakʋʋŋ, daa zaabʋrɩvɩɩna die fʋ bʋrɩ fʋ kʋakʋ ma? Ama sɩa huutiti dɩ nyɩŋ?’ ");
INSERT INTO kma_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Die ʋ baarɩ dɩ, ‘Dataaŋ wʋnyɩ yine die.’ Die ba pɩasɩ wa ‘Yaala tɩ ga a vʋʋ huutiti mɩŋ?’ ");
INSERT INTO kma_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ʋ baarɩ, ‘Aayɩ, dama nɩ a keŋ a vʋa huutiti nɩ nan gʋtɩ a vʋʋ zaaha ataŋ. ");
INSERT INTO kma_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Die wɩa nɩ vaa zaaha aŋaŋ huutiti mana lagɩsɩ bɩrɩŋ a ga tʋgɩ gobiŋ saŋŋa. Saŋka mi n nan balɩ zaagobiribe; nɩ woliŋ vʋʋ huutiti ta bɔbɩha a huubɔba a jʋʋha boliŋ; ta lagɩsɩ zaaha a nagɩha a yi n napooti me.’ ” ");
INSERT INTO kma_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisa die dɩ bɩ a taaŋ ba nandagɩŋ bɩbra dɩ, “Ŋmɩŋ naarɩ sɩɩ sɩba kaŋmɩnɩŋ biŋ daa dɩ nagɩna a ga bʋrɩ ʋ kʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka yine nyɩŋbʋrɩka mana jabɩŋ, ama ka keŋ bɩrɩŋ ka yine vapɔgɩtɩ mana jakpɩɩŋ. Ka ŋaaŋ bɩrɩŋ wa tɩɩŋ ta nembisi keŋ yʋga a tose ka chagɩsa ma.” ");
INSERT INTO kma_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisa die dɩ bɩ a taaŋ ba nandagɩŋ bɩbra dɩ, “Ŋmɩŋ naarɩ sɩɩ sɩba dabɔtɩ hɔgʋ dɩ nagɩna a lagɩsɩ paanʋ zɔŋ dieke dɩ dala ma aŋ bʋ mana kʋŋ a yiri die wo.” ");
INSERT INTO kma_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisa die taaŋ wa nandaga a bala wɩaha gie mana mana a yɩ daadamba: Die ʋ ka bala wɩɩŋ a yɩa ba ta ka ka yi nandagɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Die ʋ yiwo naa amʋ Ŋmɩŋ naazʋa wʋnyɩ die dɩ bala wudieke wo keŋ yi wusie, dɩ “Maŋ a keŋ n bala wɩɩŋ n nan nagɩ nandaga a balɩ ba, n nan balɩ ba wudieke mana die dɩ lɔbɩrɩna a nyɩŋ dʋnɩa dɩ piiline a keŋ tʋgɩ jinne.” ");
INSERT INTO kma_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Die Yisa die dɩ va daadamba mi ta ga a juu tigidieke mi die ʋ benne. Ta ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a baarɩ, “Dagɩ tɩ huutiti nandagɩrɩ chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ta ʋ balɩ ba dɩ, “Manɩŋ vuota Bʋa yine vuodieke die dɩ bʋrɩna nyɩŋbʋrɩvɩɩnaha. ");
INSERT INTO kma_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kʋakʋ dɩaŋ yine dʋnɩa, nyɩŋbʋrɩvɩɩnaha dɩaŋ yine vuodiekemba dɩ benne Ŋmɩŋ naarɩ ma, ta huutiti dɩaŋ yine Sitaani vuosi. ");
INSERT INTO kma_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dataa dieke dɩaŋ dɩ bʋrɩna huutiti yine Sitaani; gobiku saŋka dɩaŋ yine dʋnɩa kpatɩ saŋŋa, gogobiribe dɩaŋ yine Ŋmɩŋ malakasi. ");
INSERT INTO kma_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Sɩba die ba lagɩsɩna huutiti a jʋʋha bolibu die wo, die dɩ baa dɩ sɩmma dʋnɩa kpatɩŋ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manɩŋ vuota Bʋa nan daansɩ tʋŋ n malakasi aŋ ba ga vʋarɩ a nyɩŋ n naarɩ ma vuodiekemba die dɩ yinene vuosi dɩ yie bɩaŋ aŋaŋ vuobɩatɩ mana, ");
INSERT INTO kma_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","aŋ ba nagɩ ba a taaŋ boliŋ me, mi ba nan dɩ kʋma ta ŋɔba ba nyɩna. ");
INSERT INTO kma_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ama saŋŋa mi ŋmɩŋchɩgɩrɩba mana nan dɩ bie n Chʋa wa Ŋmɩŋ naarɩ ma a chaaŋ sɩba ŋmɩŋ dɩ chaannana die wo. Vuodieke dɩ yaa tɩba ʋ wʋmma. ");
INSERT INTO kma_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ŋmɩŋ naarɩ sɩɩ sɩba jadɩɩŋ dieke die dɩ gune tɩŋgbaŋ ma vuoŋ kʋaŋ ma. Ta daa wʋnyɩ dɩ keŋ ye ke, a kpɩarɩ tantɩ a ligi ke, ta ga aŋaŋ sʋgɩfɩalɩŋ a ga nagɩ ʋ yalla nyindieke mana a daa a yiŋŋi keŋ daa kʋakʋ. ");
INSERT INTO kma_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ŋmɩŋ naarɩ bɩ sɩɩ sɩba nyugidiiru dɩ dɩna dɩdɩa yaala nyielevɩɩna dɩ ʋ daa. ");
INSERT INTO kma_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Die ʋ ga ye kaanɩ dɩ faasɩna vɩɩna die ʋ ga a ga nagɩ ʋ nyinti mana a daa ta keŋ daa ka. ");
INSERT INTO kma_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ŋmɩŋ naarɩ bɩ sɩɩ sɩba, zaasɩŋ nɩɩŋ ba nagɩna a vigi taaŋ nyaaŋ ma ka yigi zaasɩŋ yiri yiri nɩŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ka suuline wo zaasɩyigiribe dɩ datɩ ka nyɩŋ gaaŋ ma, a sʋʋŋ kalɩ a lugi zaasɩvɩɩnaha a yi kparɩŋ ma ama ta nagɩ zaasɩbɩatɩtɩ a vigi taaŋ wa. ");
INSERT INTO kma_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Naa dɩ baa dɩ sɩmma dʋnɩa kpatɩŋ daraaŋ. Ŋmɩŋ malakasi nan keŋ a lugi vuobɩatɩtɩ a nyɩŋ vuovɩɩna ma, ");
INSERT INTO kma_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ta nagɩ vuobɩatɩtɩ a vigi taaŋ boliŋ me. Mi ba nan dɩ kʋma ta ŋɔba ba nyɩna.” ");
INSERT INTO kma_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Die Yisa die dɩ pɩasɩ ba, “Nɩ sɩba wɩaha gie chɩasɩ mɩŋ?” Die ba baarɩ “Wa.” ");
INSERT INTO kma_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Die ʋ yiŋŋi a balɩ ba, “Die wɩa, Ŋmɩŋ mɩra dɩdagɩrʋ dieke mana dɩ bʋgɩrɩnana n dagɩkʋ yaa gamma Ŋmɩŋ naarɩ wɩa ta mɩŋŋɩ sɩba a chɩasɩ sɩɩ sɩba tigiŋ tieŋ dieke dɩ vʋarɩna nyɩŋhaala aŋaŋ nyɩŋkʋra a nyɩŋ ʋ nyinti ma.” ");
INSERT INTO kma_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisa die dɩ taanna nandagaha gie a kpatɩ, die ʋ nyɩŋ mi ");
INSERT INTO kma_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a yiŋŋi a ga ʋ gbaŋ gbaŋ ʋ tɩŋ, mi die ʋ ga daga vuosi Ŋmɩŋ wɩa ba Ŋmɩŋ jɩamɩŋ juoŋ me. Die ʋ dagɩkʋ dɩ yi vuodiekemba dɩ wʋnnana wa mamachi. Die ba pɩasa taŋ dɩ, “Sɩa ʋ ye yɩabʋ gie? Sɩa ʋ ye yiko ke gie a yie mamachi wɩaha gie?” ");
INSERT INTO kma_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Daa kampɩnta wa bʋa wa wondie? Daa ʋ nuŋ yine Meri, ta ʋ nɩmballɩ dɩ yi Jemisi aŋaŋ Josefu aŋaŋ Simoni aŋaŋ Judasi? ");
INSERT INTO kma_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Da ʋ tamba benne giena wa? Sɩa ʋ ye genhe mana?” ");
INSERT INTO kma_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Die wɩa die ba zeti wo. Yisa die dɩ balɩ a yɩ ba dɩ, “Ba yɩa Ŋmɩŋ naazʋa jɩlɩma jigiŋ mana mana mɩŋ, ntaala ʋ gbaŋ gbaŋ ʋ tɩŋ aŋaŋ ʋ gbaŋ gbaŋ ʋ tigiŋ vuosi jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Die ʋ ka yi mamachi wɩa pam mi dama die ba ka yi wo yada wɩa. ");
INSERT INTO kma_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Saŋka mi naaŋ Herodi vuodieke die dɩ yine Galili naaŋ wa die dɩ wʋŋ Yisa wɩa. ");
INSERT INTO kma_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Die ʋ balɩ a yɩ ʋ nyɩŋkʋraha dɩ, “Ʋ seŋ yiwo Jɔɔn vuodieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ hagɩna kuŋ me, die wɩa ʋ yallɩ hagɩrɩbʋ mi a yie mamachi wɩa dene.” ");
INSERT INTO kma_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Die Herodi die yɩ wa nʋaŋ ba yigi Jɔɔn a bɔbɩ wa ta nagɩ wa a yi dansarɩka sʋŋ, die ʋ nɩmbʋa Filipi hɔgʋ Herodiasi wɩa die ʋ yi die. ");
INSERT INTO kma_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Dama Jɔɔn die ŋaaŋ bala yɩa wa mɩŋ dɩ, “Dɩ ka mʋ fʋ faarɩ Herodiasi.” ");
INSERT INTO kma_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Naaŋ Herodi die yaala ʋ kʋʋ Jɔɔn, ta die chɩga Juu vuosisi, dama die ba sɩba a baarɩ Jɔɔn die yiwo Ŋmɩŋ naazʋa. ");
INSERT INTO kma_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Die ba mɩɩrɩna naaŋ Herodi daa dieke die dɩ keŋ tʋgɩ, ʋ yi chaantɩ, ta Herodiasi hɔgʋlɩa die dɩ keŋ sie daadamba mana nɩŋŋa, die naaŋ Herodi sʋŋ die dɩ paalɩ fɩalɩ, ");
INSERT INTO kma_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","die ʋ yɩ wa nʋaŋ a baarɩ, “N hʋʋya, n nan yɩ fʋ jadieke mana fʋ bala dɩ yaala.” ");
INSERT INTO kma_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Die wɩa hɔgʋlɩa wa nuŋ dɩ dagɩ wa jadieke ʋ baaŋ pɩasɩ, die ʋ yiŋŋi ga balɩ naaŋ Herodi dɩ, “Gobi Jɔɔn vuodieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ sikpeŋ a yi tasɩŋ ma a keŋ yɩ mɩŋ lele.” ");
INSERT INTO kma_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Naaŋ wa sʋŋ die dɩ chʋʋsɩ, ama die ʋ hʋʋna daadamba nɩŋŋa wɩa die ʋ yɩ nʋaŋ dɩ ba yi havʋʋbike dɩ yaalala die wo. ");
INSERT INTO kma_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Die wɩa die ba gobi Jɔɔn sikpeŋ dansarika sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Die ba chii sikpeku aŋaŋ tasɩŋ a keŋ yɩ havʋʋbike, ta ʋ dɩaŋ dɩ chiike a ga yɩ ʋ nuŋ. ");
INSERT INTO kma_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Die Jɔɔn kʋaŋandɩɩsɩrɩba die dɩ keŋ a nagɩ ʋ nyɩŋgbaŋka a ga guu, ta die a ga a balɩ Yisa. ");
INSERT INTO kma_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Die Yisa dɩ wʋnna Jɔɔn kʋʋla wɩaha die ʋ juu haarɩŋ a nyɩŋ mi a ga jigidieke vuoŋ dɩ wone. Die vuosisi dɩ wʋnna naa, die ba va ba tɩgɩsɩ ta chʋŋ nagɩsɩ a dɩ ʋ kʋaŋ a ga ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yisa die dɩ kenne nyɩnna haarɩkʋ ma ta ye daadamba zɔɔlɩŋ die dɩ yigi wo pam, die ʋ gbaaŋ vuodiekemba die dɩ yʋagɩna ba sʋŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jɩŋmɩŋ die dɩ tʋgɩna, ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a balɩ dɩ, “Ŋmɩŋ gbige nannɩŋ mɩŋ ta giena dɩaŋ dɩ yi haagɩŋ; die wɩa vaa vuotamba aŋ ba ga tɩgɩbɩsɩsɩ a yaalɩ nyindiike a dii.” ");
INSERT INTO kma_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yisa die dɩ yiŋŋi a balɩ dɩ, “Ba ka mʋ ba ga. Nɩnɩŋ nɩ gbaŋ gbaŋ nɩ yɩ ba jaaŋ aŋ ba dii.” ");
INSERT INTO kma_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Die ba baarɩ, “Paanʋ golime anʋ aŋaŋ zaasɩtɩ ale nyɩɩna tɩ yallɩ giena.” ");
INSERT INTO kma_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yisa die dɩ baarɩ, “Nɩ yaa ha a keŋ giena.” ");
INSERT INTO kma_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Die ʋ balɩ a yɩ vuotamba dɩ ba sʋʋŋ kala huutiti ma; ta die a nagɩ paanʋ golime anʋ wa aŋaŋ zaasɩtɩ ale wo, a daansɩ ŋmɩŋsikpeŋ ta die a pagɩ Ŋmɩŋ. Die ʋ gbieri gbieri paanʋsɩsɩ a nagɩ ha a yɩ ʋ kʋaŋandɩɩsɩrɩba, die ba nagɩ ha a yɩ vuosisi. ");
INSERT INTO kma_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vuoŋ mana dɩ dii ta tɩalɩ tɩalɩ. Die ʋ kʋaŋandɩɩsɩrɩba die dɩ vaarɩ nyintɩalɩkaha a suuli kparɩsɩ baŋ aŋaŋ ale. ");
INSERT INTO kma_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vuodiekemba die dɩ dine die yiwo dembisi tuse anʋ, ama die ba ka bɩɩsɩ hɔgʋba aŋaŋ ballɩ a gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Die Yisa die dɩ vaa ʋ kʋaŋandɩɩsɩrɩba dɩ juu haarɩkʋ a garɩsɩ a ga mʋgɩkpɩɩrɩ mi wo chaakʋ, ta wɩarɩ dɩ ʋ taaŋ vuosisi aŋ ba kuli. ");
INSERT INTO kma_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Die ʋ taanna vuosisi a kpatɩ wa, die ʋ ga a jʋalɩ kunkogiŋ dɩ ʋ jʋʋsɩ Ŋmɩŋ. Yuŋ die dɩ ga tʋgɩ ta ʋ bie mi ʋ nyɩɩna ma; ");
INSERT INTO kma_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","saŋka gie ta haarɩkʋ die bie wo saasaa mʋgɩkpɩɩrɩ sʋnsʋŋ aŋaŋ sʋnsʋŋ nyapoŋiku yaa ka dɔma dama bʋlɔgɩsɩŋ die nɩgɩnana ka. ");
INSERT INTO kma_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yaa gamma kparaaŋ kpaŋ saŋŋa die Yisa die dɩ chʋŋ nyaabʋ sikpeŋ a keŋ ʋ kʋaŋandɩɩsɩrɩba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Die ba yene wo ʋ chʋnnana nyaabʋ sikpeku ŋmaamɩŋ die dɩ yigi be. Die ba baarɩ, “Kogiŋ wonde” ta faasɩ keesi. ");
INSERT INTO kma_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ama Yisa dɩ balɩ wɩa a yɩ ba bʋnyɩ a baarɩ, “Nɩ da vaa ŋmaamɩŋ yalla nɩ, wo manɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ta Piita dɩ baarɩ, “N Yɔmʋtieŋ dɩ yiwo fʋnɩŋ fʋ vaa aŋ n chʋŋ nyaabʋ sikpeŋ a haarɩ fʋ.” ");
INSERT INTO kma_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yisa dɩ baa, “Kiere.” Naa chɩaŋ ma Piita die dɩ nyɩŋ haarɩkʋ ma a piili chʋŋ nyaabʋ sikpeŋ a gara ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama die ʋ yene bʋlɔgɩsɩbʋ dɩ faasɩna nɩgɩ wa ŋmaamɩŋ die dɩ yigi wo die ʋ piili a sʋʋna nyaabʋ chɩaŋ. Die ʋ keesi a baarɩ, “N Yɔmʋtieŋ gbatɩ mɩŋ taaŋ!” ");
INSERT INTO kma_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yisa die dɩ deeŋ nuuŋ a yigi wo bʋnyɩ ta baarɩ, “Fʋnɩŋ yada dɩ kana ka dala vuoke gie, bie yine fʋ chɩɩlɩ?” ");
INSERT INTO kma_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba mana die dɩ juu haarɩkʋ sʋŋ die bʋlɔgɩsɩbʋ die dɩ nan. ");
INSERT INTO kma_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ta vuodieke dɩ benne haarɩkʋ sʋŋ die dɩ keŋ gbirigi a jɩama Yisa ta baarɩ, “Wusie, seŋ yiwo Ŋmɩŋ Bʋa.” ");
INSERT INTO kma_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Die ba garɩsɩ mʋgɩkpɩɩrɩ a keŋ Genezariti tɩŋgbaŋ ma, ");
INSERT INTO kma_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","mi vuosi die dɩ mɩŋŋɩ Yisa. Die wɩa die ba mʋʋlɩ a yɩ vuosi mana, ta ba chii vuodiekemba mana die dɩ yʋagɩna a keŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Die ba jʋʋsɩ wa dɩ ʋ ko a vaa vuodiekemba dɩ yʋagɩna wa ko a gbɩ ʋ jayeekiri kʋanʋaŋ; die vuodiekemba mana die dɩ gbɩna ka wa die ye wo gbaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Womi Farasisi bataŋ aŋaŋ mɩraha dɩdagɩrɩba die dɩ nyɩŋ Jerusalemi a keŋ Yisa jigiŋ a pɩasɩ wa dɩ, ");
INSERT INTO kma_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dɩ yiwo lalɩa fʋ kʋaŋandɩɩsɩrɩba dɩ ka dɩɩsa tɩ chɔɔŋkʋʋlɩba die dɩ dagɩna die wo? Ba ka nɩta ba nuusi ta die.” ");
INSERT INTO kma_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yisa die dɩ yiŋŋi a pɩasɩ ba, “Ta dɩ yiwo lalɩa nɩnɩŋ nɩ zeti Ŋmɩŋ mɩraha ta dɩ nɩ chɔɔŋkʋʋlɩba dagɩkʋ? ");
INSERT INTO kma_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ŋmɩŋ die baarɩ, ‘Yɩma fʋ chʋa aŋaŋ fʋ naa jɩlɩma’ ta ‘Vuodieke mana dɩ a keŋ zɩa ʋ chɔɔŋ yaa ʋ nuŋ mʋ ba kʋʋ wa.’ ");
INSERT INTO kma_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama nɩ daga a baarɩ dɩ vuoŋ dɩ a keŋ a yallɩ jadieke ʋ baaŋ nan nagɩ a suŋŋi ʋ nuŋ yaa ʋ chɔɔŋ ta baarɩ dɩ ‘Nyinti gie bɩrɩŋ wa Ŋmɩŋ sɩɩtɩ’; ");
INSERT INTO kma_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ka ka bɩ yiwo mugisiŋ dɩ ʋ yɩma ba jɩlɩma ta yɩ ba jaaŋ. Naa nɩ zeti Ŋmɩŋ mɩraha ta dɩ nɩ gbaŋ gbaŋ nɩ dagɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nɩnɩŋ gɩgaantɩba gie! Ŋmɩŋ naazʋa Azaya die yaa wusie die ʋ bala nɩ wɩa die. Die Ŋmɩŋ baarɩ dɩ ");
INSERT INTO kma_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Vuosi gie yɩa mɩŋ jɩlɩma aŋaŋ ba nʋa, ama ba sʋgɩtɩ dɩ bie saasaa aŋaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba jɩama mɩŋ wa yɔrɩ dama ba daga vuosi vuota mɩra sɩba a yiwo manɩŋ n mɩra.’ ” ");
INSERT INTO kma_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Womi Yisa die dɩ wa kpɩkpaakʋ a keŋ ʋ jigiŋ a bala yɩ ba, “Nɩ wʋmma ta sɩmma a chɩasɩ! ");
INSERT INTO kma_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Da jadieke dɩ junene vuota nʋaŋ ma yinene wo dɩgɩntɩ Ŋmɩŋ jigiŋ ama jadieke dɩ nyɩnana ʋ nʋaŋ ma yinene wo dɩgɩntɩ Ŋmɩŋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Womi ʋ kʋaŋandɩɩsɩrɩba dɩ keŋ ʋ jigiŋ a pɩasɩ wa dɩ, “Fʋ sɩba a baarɩ Farasisi vuosisi dɩ wʋnna fʋ balɩkʋ ba jɩɩ wa sɩnyɩɩrɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ʋ die dɩ yiŋŋi a balɩ ba, “Tɩɩ dieke mana n Chɔɔŋ dieke dɩ benne arɩzanna ma dɩ kana ka suuye sie ba keŋ vʋʋka a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Die wɩa vaa ba aŋ ba ga dama ba sɩɩ sɩba yɩɩsɩ ta data taŋ. Yɩɩ dɩ a keŋ data ʋ chanchaaŋ sie ba mana nan guoliŋ me.” ");
INSERT INTO kma_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piita die yiŋŋi a baarɩ: “Dagɩ tɩ nandagɩrɩ gie chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Nɩ gbaŋ nɩ ka sɩba n wʋbalɩka gie chɩasɩ? ");
INSERT INTO kma_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nɩ ka sɩba a baarɩ jadieke mana dɩ junene vuota nʋaŋ ma gara ʋ nyuuti ma ta daaga ʋ nyɩŋgbanɩŋ a nyɩna? ");
INSERT INTO kma_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama wudiekemba vuota dɩ balala ʋ nʋaŋ ma nyɩna ʋ sʋŋ, die yinene vuota dɩgɩntɩ. ");
INSERT INTO kma_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dama vuota sʋŋ ma sʋŋanyilibɩatɩ dɩ nyɩna, sɩba vuota kʋʋla, daakpana aŋaŋ hɔgʋkpana yaalɩŋ, aŋaŋ gaarɩŋ aŋaŋ ŋmɩnchɩbɩsɩ aŋaŋ kʋagaarɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Genhe yinene vuota dɩgɩntɩ; ama da nuudɩgɩntɩ diile yinene vuota dɩgɩntɩ.” ");
INSERT INTO kma_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisa die dɩ nyɩŋ mi a ga Taya aŋaŋ Sidoni tɩŋgbaŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Die wɩa Keenani hɔgʋ wʋnyɩ die dɩ benne mi chaakʋ die dɩ keŋ Yisa jigiŋ a wa wa dɩ, “N Yɔmʋtieŋ Davidi haagɩŋ chɩgɩ mɩŋ zɔɔlɩŋ! Jɩmbɩaŋ yalla n havʋʋbiŋ, dɩ a paalɩ a mugisi wo pam.” ");
INSERT INTO kma_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama Yisa die ka balɩ wɩɩŋ mana a yɩ wa. Die ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a balɩ wa dɩ ʋ yagɩ wa; dama ʋ dɩ tɩ mɩŋ a yie watɩ. ");
INSERT INTO kma_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Womi Yisa die dɩ yiŋŋi balɩ ba dɩ, “Izara vuodiekemba dɩ sɩna sɩba yii diekemba dɩ bana, banɩŋ ba jigiŋ nyɩɩna Ŋmɩŋ dɩ tʋŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ta hɔgʋ wa die dɩ a keŋ a gbirigi Yisa nɩŋŋa a baarɩ, “N Yɔmʋtieŋ, suŋŋi mɩŋ!” ");
INSERT INTO kma_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yisa die dɩ yiŋŋi a baarɩ, “Dɩ ka mʋ dɩ vuoŋ nagɩ ballɩbɩsɩ nyindiike a yɩ gbaasɩ.” ");
INSERT INTO kma_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Die wɩa hɔgʋ wa die dɩ yiŋŋi a baarɩ, “N Yɔmʋtieŋ ka yiwo wusie, ama gbaaŋ diekemba dɩ dʋana ba tieŋ nɩŋŋa ŋaaŋ nagɩ nyindiike chɔɔta dieke dɩ nannana ʋ nɩŋŋa a die.” ");
INSERT INTO kma_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Naa chɩaŋ wɩa Yisa die dɩ balɩ wa, “Yiwo hɔgʋ dieke yada dɩ dala! Fʋ yaalala jadieke wo nan yi a yɩ fʋ.” Lele womi ʋ hɔgʋlɩa wa dɩ ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisa die dɩ nyɩŋ mi a ga Galili mʋgɩkpɩɩrɩ chaaŋ. Die a jʋalɩ a kalɩ kunkogiŋ me. ");
INSERT INTO kma_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta kpɩkpaaŋ die dɩ a keŋ ʋ jigiŋ aŋaŋ gbilisi aŋaŋ yɩɩsɩ aŋaŋ gbarɩgɩsɩ aŋaŋ gaantɩŋ aŋaŋ vuodiekemba mana dɩ yʋagɩna yʋagɩtɩ yiri yiri mana a nagɩ ba dʋaŋ ʋ nɩŋŋa; die ʋ gbaaŋ ba. ");
INSERT INTO kma_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kpɩkpaakʋ die dɩ yene ta gaantɩba balɩ wɩa, ta gbarɩgɩsɩ dɩ chʋŋ, ta gbilisi dɩ ye alaafɩa, yɩɩsɩ dɩ yese wo die dɩ yi be mamachi. Die ba bɩrɩ Izara vuosi Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisa die dɩ wa ʋ kʋaŋandɩɩsɩrɩba a keŋ ʋ jigiŋ a baarɩ dɩ, “Zɔɔlɩŋ yigi mɩŋ mɩŋ aŋaŋ vuosi gie wɩa, dama ba bie wo n jigiŋ daraa ataa, ta lele ba wo jaaŋ ba baaŋ dii. N ka yaala n vaa ba kuli ta ka yɩ ba nyindiike, dama ba nan keŋ chaa sieŋ me.” ");
INSERT INTO kma_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ʋ kʋaŋandɩɩsɩrɩba dɩ pɩasɩ wa, “Sɩa tɩ nan ye nyindiike haagɩrɩ gie me a yɩ kpɩkpaakʋ gie?” ");
INSERT INTO kma_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yisa die dɩ pɩasɩ ba, “Paanʋsɩ aŋmɩa nɩ yallɩ?” Ba baarɩ, “Paanʋsɩ golime ayʋpɔyɩ aŋaŋ zaasɩbɩsɩ bɩta.” ");
INSERT INTO kma_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naa chɩaŋ wɩa Yisa die dɩ yi kpɩkpaakʋ nʋaŋ dɩ ba sʋʋŋ kala tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Die ʋ nagɩ paanʋ golime ayʋpɔyɩ wa aŋaŋ zaasɩbɩsɩsɩ a bɩrɩ Ŋmɩŋ ta die gbieri gbieri he a nagɩ ha a yɩ ʋ kʋaŋandɩɩsɩrɩba die ba nagɩha a yɩ vuosisi. ");
INSERT INTO kma_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Die ba mana dɩ dii ta tɩalɩ tɩalɩ. Ʋ kʋaŋandɩɩsɩrɩba die dɩ vaarɩ nyintɩalɩkaha a suuli kparɩsɩ ayʋpɔyɩ. ");
INSERT INTO kma_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Die dembiŋ diekemba die dɩ dine wo die yiwo vuosi tuse anɩɩsa, ama die ba ka bɩɩsɩ hɔgʋba aŋaŋ ballɩ. ");
INSERT INTO kma_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Die Yisa dɩ wa a taaŋ kpɩkpaakʋ ta die juu haarɩŋ a ga Magadani tɩŋgbaŋ chaaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Die Farasisi aŋaŋ Sadusisi vuosi bataŋ die dɩ keŋ Yisa jigiŋ. Die ba yaala ba yigi wo mɩŋ, die chɩaŋ ma die ba pɩasɩ wa dɩ ʋ yi mamachi wɩɩŋ a yɩ ba aŋ ka dagɩ sɩba Ŋmɩŋ die zie wo ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ama die ʋ yiŋŋi a balɩ dɩ, “Nɩɩŋmara dɩ keŋ ŋmɩntɩ jɩŋmɩŋ nɩ ŋaaŋ baarɩ, ‘Soriŋ jigiri nan dɩ vɩɩna.’ ");
INSERT INTO kma_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta sʋkʋleeliŋ dɩaŋ nɩɩŋmara dɩ keŋ ŋmɩntɩ ta bɩ sɩbɩ nɩ ŋaaŋ baarɩ, ‘Nɩɩŋ baa ka nɩɩŋ mɩŋ.’ Nɩ nan bɩagɩ a daansɩ nɩɩŋmara ta balɩ wudieke dɩ balla ka yi ama nɩ kaaŋ dɩ sɩba wudieke dɩ yinene lele chɩasɩ! ");
INSERT INTO kma_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nɩnɩŋ, lele vuosi nɩ yiwo vuobɩatɩ ta ka dɩsa Ŋmɩŋ, nɩ yaala nɩ ye wo mamachi wɩɩŋ; ama n kaaŋ wɔŋ yi wɩɩŋ a yɩ nɩ; ama mamachi dieke nyɩɩna n baaŋ nan nagɩ a yɩ nɩ yiwo Jona mamachi ka.” Die ʋ balla die a yɩ ba, ta die ga ta va ba. ");
INSERT INTO kma_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ gasɩna mʋgɩkpɩɩrɩ a ga mi wo chaakʋ, die ʋ kʋaŋandɩɩsɩrɩba die dɩ daaŋ ta ka nagɩ paanʋ. ");
INSERT INTO kma_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yisa die dɩ balɩ a yɩ ba, “Nɩ sɩmma Farasisi aŋaŋ Sadusisi dabɔtɩ wɩa.” ");
INSERT INTO kma_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Die ba a bala a yɩa taŋ a baarɩ, “Dɩ yiwo tɩ kana ka nagɩ paanʋ wɩa ʋ bala die wo.” ");
INSERT INTO kma_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yisa die dɩ mɩŋŋɩna ba balala wudieke wo die ʋ pɩasɩ ba, “Nɩnɩŋ vuodiekemba nɩ yada dɩ kana ka dala, bɩa nɩ bala yɩa taŋ nɩ wone paanʋ wɩa? ");
INSERT INTO kma_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nɩ ye ka sɩba ka chɩaŋ? Nɩ ka tɩɩnsɩ die n nagɩna paanʋ golime anʋ a yɩ dembisi tuse anʋ wa? Die kparɩsɩ aŋmɩa die nɩ vaarɩ nyintɩalɩkaha a suuli? ");
INSERT INTO kma_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ta die n nagɩ paanʋ golime ayʋpɔyɩ a yɩ dembisi tuse anɩɩsa wa, kparɩsɩ aŋmɩa die nɩ vaarɩ? ");
INSERT INTO kma_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bɩa yine nɩ yile dɩ paanʋ wɩa maŋ bala nɩ? ‘Nɩ sɩmma Farasisi aŋaŋ Sadusisi dabɔtɩ wɩa!’ ” ");
INSERT INTO kma_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Die ba wa a sɩba a baarɩ dɩ ʋ ka bala ba dɩ ba sɩmma yaa gamma dabɔtɩ dieke ba yalla a yɩa paanʋ sʋŋ ama dɩ ba sɩmma Farasisi aŋaŋ Sadusisi dagɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisa die dɩ ga Siisiria Filipi tɩŋ chaaŋ, die ʋ pɩasɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Mɩnɩa vuosisi dɩ baarɩ manɩŋ vuota Bʋa wa yiye?” ");
INSERT INTO kma_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Die ba baarɩ, “Bataŋ baarɩ yiwo Jɔɔn vuodieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ, bataŋ dɩaŋ baarɩ yiwo Elaja ta bataŋ dɩaŋ dɩ baarɩ yiwo Jerimaya yaa Ŋmɩŋ naazʋalɩba wʋnyɩ die dɩ benne kʋrɩŋ ma wa.” ");
INSERT INTO kma_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta ʋ pɩasɩ ba, “Ta nɩnɩŋ mɩnɩa nɩ baarɩ n yiye?” ");
INSERT INTO kma_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Womi Simoni Piita dɩ baarɩ, “Fʋ yine miivolitieŋ Ŋmɩŋ Bʋa Masia wa, vuodieke ʋ vʋarɩna.” ");
INSERT INTO kma_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yisa die dɩ yiŋŋi a balɩ wa, “Fʋnɩŋ Simoni, Jona bʋa, sʋgɩfɩalɩŋ bemme fʋ ma, dama daa vuota yuori wɩarɩ gie a dagɩ fʋ ama dɩ yiwo n Chʋa Ŋmɩŋ dieke dɩ benne arɩzanna ma wa. ");
INSERT INTO kma_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","N bala fʋ, fʋnɩŋ fʋ yiwo Piita ta tanjaalɩka gie sikpeŋ maŋ nan nagɩ n vuosi zieŋ, ta kuŋ gbaŋ kaaŋ bɩagɩ a nyaŋŋɩ ba. ");
INSERT INTO kma_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N nan yɩ fʋ Ŋmɩŋ naarɩ sanʋaŋ safɩbie; die wɩa jadieke mana fʋ baarɩ dɩ chʋarɩ tɩŋgbaŋka gie me die gbaŋ gbaŋ jaabʋ nan dɩ chʋarɩ arɩzanna ma; ta jadieke mana fʋ baarɩ ka ka chʋarɩ tɩŋgbaŋka gie me, die gbaŋ gbaŋ jaabʋ kaaŋ dɩ chʋarɩ arɩzanna ma.” ");
INSERT INTO kma_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Womi Yisa die dɩ kpaaŋ ʋ kʋaŋandɩɩsɩrɩba aŋaŋ nɩŋŋmɩna dɩ ba da keŋ balɩ vuoŋ dɩ ʋ yine Masia wa. ");
INSERT INTO kma_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A nyɩŋ saŋka mi yaa gamma, Yisa die dɩ piili a bala a yuore ʋ kʋaŋandɩɩsɩrɩba dɩ, “Sie n ga Jerusalemi a ga dii wahala a nyɩŋ tɩka nyɩŋkʋraha aŋaŋ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba nuusi me. Ba nan kʋʋ mɩŋ ama daraa ataa daraaŋ Ŋmɩŋ nan hagɩ mɩŋ a nyɩŋ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piita die dɩ nagɩ wa a nyɩŋ lʋgɩŋ a piili a galɩma wa a baarɩ dɩ, “N Yɔmʋtieŋ, Ŋmɩŋ da vaa die yi. Naa kaaŋ daaŋ yi fʋ.” ");
INSERT INTO kma_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yisa die dɩ yiŋŋi a balɩ a yɩ Piita, “Fʋnɩŋ Sitaani wa gie hagɩ gie ta va mɩŋ. Yiwo taŋgbiŋkiŋ n sieŋ me dama fʋ sʋŋanyilehe gie yiwo vuota sʋŋanyile ama daa Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Womi ʋ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Vuodieke mana dɩ yaala ʋ dɩa n kʋaŋ, sie ʋ zeti ʋ gbaŋ a nagɩ ʋ dagarɩkɩŋ a dɩa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dama vuodieke nɩŋ mana dɩ kana ka saagɩya dɩ ʋ nagɩ ʋ miivoli a yɩ mɩŋ nan waarɩ ka, ama vuodieke nɩŋ mana dɩ keŋ waarɩ ʋ miivoli n wɩa wʋnɩŋ nɩŋ nan daansɩ ye ke. ");
INSERT INTO kma_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bɩa vuota dɩ baa ʋ ye, ʋ yallɩ dʋnɩa nyinti mana ta waarɩ ʋ miivoli, bɩa nyʋarɩ ʋ baa ʋ ye? Vuoŋ nan bɩagɩ nagɩ jaaŋ a daa ʋ miivoli? ");
INSERT INTO kma_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dama manɩŋ vuota Bʋa baa n yiŋŋi keŋ mɩŋ aŋaŋ n Chʋa Ŋmɩŋ hagɩrɩŋ, aŋaŋ ʋ malakasi, ta saŋŋa mi n nan tuŋ vuoŋ mana yaa gamma ʋ tʋnna die. ");
INSERT INTO kma_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wusie maŋ bala nɩ, vuosi bataŋ bie gie ba kaaŋ kpi sie ba keŋ ye manɩŋ vuota Bʋa naarɩ diile saŋŋa.” ");
INSERT INTO kma_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Daraa ayʋaba kʋaŋ chaaŋ die Yisa die dɩ nagɩ Piita, aŋaŋ Jemisi aŋaŋ ʋ nɩmbʋa Jɔɔn, a yaa ba ga jʋalɩ taŋbɩrɩŋkɩŋ sikpeŋ me, ba nyɩɩna. ");
INSERT INTO kma_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Womi ʋ nyɩŋgbanɩŋ die dɩ tarɩgɩ ba nɩŋŋa. Ʋ nine dɩ chaaŋ sɩba ŋmɩŋ ta ʋ nyiŋyeeke dɩ yɩantɩ sɩba chaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta ba ye Mosisi aŋaŋ Elaja dɩ nyɩnna bʋnyɩ ba jigiŋ a bala wɩa aŋaŋ Yisa. ");
INSERT INTO kma_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Die wɩa Piita die dɩ balɩ a yɩ Yisa dɩ, “N Yɔmʋtieŋ dɩ vɩɩna tɩ benne giena. Fʋ tɩŋ nan saagɩ, n tɩŋ nan kpii viisi ataa giena, ta kaanɩ fʋ jaaŋ, ta kaanɩ yi Mosisi jaaŋ ta kaanɩ dɩaŋ dɩ yi Elaja jaaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Die Piita die dɩ yene ko bala wɩaha, nɩɩŋmaayɩalɩŋ dɩ keŋ ligi be, ta lɔlɩŋ dɩ nyɩŋ nɩɩŋmaakʋ ma a baarɩ, “N Bʋachoti wʋnna, ʋ ma n sʋŋ dɩ paalɩ a fɩalɩ, nɩ wʋmma a yɩma wa.” ");
INSERT INTO kma_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ wʋnna lɔlɩkʋ die ŋmaamɩŋ dɩ faasɩ a yigi be, die ba gbirigi tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yisa die dɩ keŋ ba jigiŋ a gbi gbi ba ta baarɩ, “Nɩ hagɩ zie. Da nɩ chɩgɩma ŋmaamɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Die wɩa die ba kɔtɩ ba sikpigile a daansɩ ta ka ye vuoŋ mi, sie Yisa nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Die ba nyɩnna tanɩ ma a keŋ sʋʋna wa, Yisa die dɩ kpaaŋ ba dɩ, “Nɩ sɩmma nɩ keŋ a balɩ vuoŋ nɩ yene wudieke wo, a ga tʋgɩ saŋŋa dieke manɩŋ Vuota Bʋa dɩ balla ʋ hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasɩ wa dɩ, “Bɩa wɩa mɩraha dɩdagɩrɩba dɩ baarɩ dɩ sie Elaja woliŋ keŋ Masia ma?” ");
INSERT INTO kma_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Die ʋ yiŋŋi a balɩ dɩ, “Ka yiwo wusie dɩ sie Elaja woliŋ keŋ, amʋ ʋ wʋnsɩ wɩɩŋ mana a mɩŋŋɩ zieŋ. ");
INSERT INTO kma_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama manɩŋ n bala nɩ dɩ, Elaja wɔŋ keŋ mɩŋ ama ta vuosi dɩ ka mɩŋŋɩ wa, ta yi wo yɔrɩ yɔrɩ die ba yaalala die wo. Die gbaŋ gbaŋ ba nan yi manɩŋ vuota Bʋa aŋ n dii wahala ba nuusi me.” ");
INSERT INTO kma_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Womi ʋ kʋaŋandɩɩsɩrɩba die dɩ mɩŋŋɩ a baarɩ Jɔɔn dieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ wɩa ʋ bala die. ");
INSERT INTO kma_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba bataa wa dɩ yiŋŋine a ga kpɩkpaakʋ jigiri daa wʋnyɩ die dɩ keŋ a gbirigi Yisa nɩŋŋa, ");
INSERT INTO kma_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","a baarɩ, “N Yɔmʋtieŋ chɩgɩ n bʋa dembike gie zɔɔlɩŋ, dama ʋ yiwo kpenkpennantʋ, die dɩ paalɩ a mugisi wo a yi ʋ nanna boliŋ me yaa nyaaŋ sʋŋ daaŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Maŋ yaa wa keŋ fʋ kʋaŋandɩɩsɩrɩba jigiŋ, ama die ba ka bɩagɩ a gbaaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yisa dɩ yiŋŋi a balɩ ba, “Nɩnɩŋ lele vuosi gie dɩ wone yada ta bɩ yi vuodiekemba dɩ kana ka dɩɩsa Ŋmɩŋ, nɩ yaala n bemme nɩ jigiŋ a ga tʋgɩ saŋŋa bɩa? Nɩ yaala n yaa wa suguru aŋaŋ nɩ a ga tʋgɩ saŋŋa bɩa? Nɩ yaa bʋa wa a keŋ giena.” ");
INSERT INTO kma_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yisa die dɩ natɩ jɩmbɩakʋ die ka nyɩŋ bʋa wa ma, die bʋa wa dɩ ye a laafɩa lele womi. ");
INSERT INTO kma_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ka kʋaŋ chaaŋ die Yisa kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a pɩasɩ wa, “Bɩa wɩa tɩ ka bɩagɩ a yagɩ jɩmbɩakʋ?” ");
INSERT INTO kma_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Die ʋ yiŋŋi a balɩ ba, “Dɩ yiwo nɩ yada dɩ kana ka dala wɩa. Wusie maŋ bala nɩ, nɩ yi Ŋmɩŋ yada ka dala sɩba kaŋmɩŋ biŋ, nɩ nan bɩagɩ a balɩ yɩ tanɩ gie ‘Vʋʋ a nyɩŋ giena a ga nan mi aŋ ka vʋʋ’; nɩ nan bɩagɩ yi jaaŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","((Ama jɩmbɩaŋ sɩba naa, nɩ kaaŋ bɩagɩ a yagɩ sie nɩ bɔba nʋaŋ ta jʋʋsa Ŋmɩŋ.))” ");
INSERT INTO kma_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Die Yisa kʋaŋandɩɩsɩrɩba mana die dɩ lagɩsɩna Galili mi, die ʋ balɩ a yɩ ba dɩ, “Ba nan nagɩ manɩŋ Vuota Bʋa a yi vuosi nuusi me ");
INSERT INTO kma_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aŋ ba kʋʋ mɩŋ ama daraa ataa daraaŋ n nan hagɩ kumbu me.” Die ʋ kʋaŋandɩɩsɩrɩba sʋgɩtɩ die dɩ paalɩ a chʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ gana Kapenɔmi, Ŋmɩŋ juokpeŋkpɩɩkʋ lampotuosiribe dɩ keŋ Piita jigiŋ a pɩasɩ dɩ, “Dɩdagɩrʋ wa tune Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ lampoke mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta Piita die dɩ baarɩ, wa, ʋ tune mɩŋ. Piita die dɩ gana a juu tigiri me die Yisa die woliŋ balɩ wɩaha, ta pɩasɩ wa dɩ, “Simoni lalɩa fʋ yile? Ba mba tunene lampo a yɩa tɩŋgbaŋka gie naakpɩɩma ha? Tɩŋgbaŋka vuosi yaa chaanɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta ʋ yiŋŋi a baarɩ “Chaanɩŋ.” Yisa die dɩ yiŋŋi a baarɩ, “Dɩ mʋ mɩŋ, dɩ dagɩ sɩba tɩŋgbaŋka vuosi ka mʋ dɩ ba tuŋ. ");
INSERT INTO kma_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama tɩ kana ka yaala tɩ chʋʋsɩ ba sʋgɩtɩ wɩa, ga mʋgɩkpɩɩrɩ ma a ga taaŋ kagɔntɩ ta datɩ zaasɩ dieke fʋ wolinne a yigi, fʋ yuori ka nʋaŋ nan ye ligire biŋ dieke dɩ baaŋ nan bɩagɩ a tuŋ manɩŋ aŋaŋ fʋ ma; ta fʋ nagɩ ka a tuŋ be.” ");
INSERT INTO kma_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Saŋka mi ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a pɩasa wa dɩ, “Mɩnɩa yine vuokpɩɩŋ Ŋmɩŋ naarɩ ma?” ");
INSERT INTO kma_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Die ʋ wa bʋabiŋ a vaa ʋ zie ba nɩŋŋa, ");
INSERT INTO kma_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ta balɩ dɩ, “Wusie maŋ bala nɩ, vuodieke nɩŋ dɩ kana ka tarɩgɩ ʋ beriŋ a sɩɩ sɩba bʋabiŋ beriŋ, ʋ kaaŋ wɔŋ juu Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Die wɩa vuodieke nɩŋ mana dɩ sʋʋna ʋ gbaŋ tɩŋgbaŋ sɩba bʋabike gie, wʋnɩŋ ʋ balla ʋ yi vuokpɩɩŋ Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Vuodieke dɩaŋ mana dɩ mɩŋŋɩna a tuose bʋabike gie chanchaaŋ n saaŋ ma, mɩŋŋɩ tuose mɩŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ballɩbɩ diekemba dɩ yine mɩŋ yada wa gie, vuodieke dɩ yi ba yi bɩaŋ, ba tɩŋ bɔbɩ nɩɩŋ a yi ʋ nyie ta nagɩ wa taaŋ mʋgɩkpɩɩrɩ ma ta nyaabʋ dɩ dii wo dɩ tɩŋ nan dɩ kpɩa. ");
INSERT INTO kma_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wʋbɩaŋ nan dɩ beri tɩŋgbaŋka gie vuodieke dɩ gaanana ba chanchaalɩŋ dɩ yie bɩaŋ wɩa. Magɩsɩŋ nan keŋ ama wʋbɩaŋ bie vuodieke dɩ yinene a kieŋ vuosi mi wo. ");
INSERT INTO kma_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Dɩ yiwo fʋ nuuŋ yaa fʋ nachɩgɩsɩŋ yinene fʋ yie tʋmbɩatɩ die nɩŋ fʋ gobike a vigi taaŋ. Dama dɩ kpɩa fʋ baaŋ nan dɩ yallɩ nuubalɩmɩŋ yaa nachɩgɩbalɩmɩŋ a juu miivoli dieke dɩ wone kpatɩ ma a tɩaŋ fʋ baaŋ nan dɩ yallɩ nuusi mana aŋaŋ nachɩgɩsɩ mana ta Ŋmɩŋ nagɩ fʋ a vigi taaŋ boli dieke dɩ wone kpatɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dɩ bɩ yiwo fʋ nimbiŋ dɩaŋ yinene fʋ tʋma tʋmbɩatɩ fʋ vʋarɩka a vigi taaŋ dama dɩ kpɩa fʋ baaŋ nan juu miivoli dieke dɩ wone kpatɩŋ ma aŋaŋ nimbibalɩmɩŋ a tɩaŋ fʋ baaŋ nan dɩ yallɩ nine ale ta Ŋmɩŋ nagɩ fʋ a taaŋ boli dieke dɩ wone kpatɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nɩ sɩmma nɩ da keŋ a daansɩ ballɩbɩsɩ gie wʋnyɩ yɔrɩ. Ama wusie maŋ balɩ nɩ, ba malakasisi bie wo Ŋmɩŋ dieke dɩ benne arɩzanna ma jigiŋ saŋŋa mana. ");
INSERT INTO kma_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","((Manɩŋ Vuota Bʋa keŋye dɩ n keŋ gbatɩ vuodieke dɩ bana wa a taaŋ.)) ");
INSERT INTO kma_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Dɩɩ yi ta vuoŋ dɩ yallɩ yiise kɔbɩga, ta kaanɩ dɩ bɩa, lalɩa nɩ yile ʋ nan yi? Ʋ nan vaa baŋɩsɩ-wayɩ aŋaŋ awayɩ wa a zieŋ kunkogiŋ sikpeŋ ta yaalɩ jadieke dɩ bana wa. ");
INSERT INTO kma_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wusie maŋ balɩ nɩ, ʋ keŋ ye ke ʋ nan dɩ yallɩ sʋgɩfɩalɩŋ yiibalɩŋka gie wɩa a tɩaŋ yiise baŋɩsɩ-wayɩ aŋaŋ wayɩ dɩ kana ka baya wa. ");
INSERT INTO kma_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Die gbaŋ gbaŋ nɩ Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma wa dɩ ka yaala ballɩbɩsɩ gie wʋnyɩ bɩa. ");
INSERT INTO kma_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Fʋ nɩmbʋa dɩ keŋ tʋŋ fʋ bɩaŋ, ga ʋ jigiŋ saŋŋa dieke ʋ benne ʋ nyɩɩna ma a balɩ wa wudieke ʋ yine. Dɩɩ yi ʋ saagɩ ʋ tʋnna die, nɩ bɩ yiwo nɩmballɩ bɩbra die. ");
INSERT INTO kma_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama ʋ a keŋ ka yaala ʋ wʋŋ a yɩ fʋ, fʋ nagɩ vuobalɩmɩŋ yaa vuosi bale a gʋtɩ fʋ ma aŋ nɩ ga ʋ jigiŋ, aŋ vuosi bale wo yaa bataa wa wʋŋ wɩarɩ ta yi fʋ siaratieliŋ. ");
INSERT INTO kma_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ʋ bɩ ka yaala ʋ wʋŋ a yɩ ba, fʋ balɩ a yɩ Ŋmɩŋ jɩamɩŋ vuosi mana, dɩɩ yi ʋ ka bɩ wʋŋ a yɩ Ŋmɩŋ jɩamɩŋ vuosisi, nɩ va wa aŋ ʋ yi sɩba vuodieke dɩ kana ka jɩama Ŋmɩŋ yaa lampotuosiru. ");
INSERT INTO kma_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Wusie maŋ balɩ nɩ, jadieke dɩ baa dɩ chʋarɩ tɩŋgbaŋka gie me die gbaŋ gbaŋ nan dɩ chʋarɩ arɩzanna ma; ta jadieke dɩ kana ka chʋarɩ tɩŋgbaŋka gie me die gbaŋ gbaŋ jaabʋ kaaŋ dɩ chʋarɩ arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“N bɩ bala nɩ, nɩnɩŋ nɩ vuosi bale dɩ yi nʋabalɩmɩŋ tɩŋgbaŋka gie me a jʋʋsɩ n Chʋa Ŋmɩŋ dieke dɩ benne arɩzanna ma jaaŋ, ʋ nan yi nɩ yaalala die a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dama jigidieke mana vuosi bale yaa bataa dɩ lagɩsɩna n saaŋ ma, mi maŋ gʋtɩ a bie ba sʋŋ.” ");
INSERT INTO kma_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Die Piita die dɩ keŋ Yisa jigiŋ a pɩasɩ wa, “N Yɔmʋtieŋ, dɩɩ yi n nɩmbʋa dɩ yi mɩŋ bɩaŋ, bʋŋmɩa maŋ baa n nagɩ a chaa wa? Bʋyʋpɔyɩ?” ");
INSERT INTO kma_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yisa dɩ yiŋŋi a balɩ wa, “Aayɩ, daa bʋyʋpɔyɩ ama baŋɩsɩ-yʋpɔyɩ jigiŋ ayʋpɔyɩ. ");
INSERT INTO kma_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Dama Ŋmɩŋ naarɩ sɩɩ sɩba naaŋ wʋnyɩ dɩ wana ʋ tigiŋ yɔŋɩsɩ dɩ ʋ bɩɩsɩ ba hamɩŋ ligire dɩ mʋna die. ");
INSERT INTO kma_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Die ʋ piiline a bɩɩsa ba ba yaa daa wʋnyɩ a keŋ ʋ jigiŋ, die ʋ dii wo ʋ hamɩŋ ligire tuse tuse pam. ");
INSERT INTO kma_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Die ʋ kaaŋ dɩ bɩagɩ a tuŋ; naa chɩaŋ ma naaŋ wa die dɩ a baarɩ ba nagɩ wa aŋaŋ ʋ hɔgʋ aŋaŋ ʋ ballɩ aŋaŋ nyindiekemba ʋ yalla mana a daa a keŋ tuŋ hannɩ. ");
INSERT INTO kma_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ama yɔmʋ wa die dɩ gbirigi naaŋ wa nɩŋŋa a jʋʋsɩ wa a baarɩ, ‘Dii suguru, n nan tuŋ fʋ jaaŋ mana.’ ");
INSERT INTO kma_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ta zɔɔlɩŋ die dɩ yigi naaŋ wa die ʋ nagɩ hannɩ a chaa wa, ta va ʋ ga. ");
INSERT INTO kma_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Womi yɔmʋ wa die dɩ nyɩŋ a ga haarɩ ʋ yɔmʋ chanchaaŋ die dɩ dine ʋ hamɩŋ ligire bɩta, die ʋ yigi ʋ nyie ta balɩ wa, ‘Tuŋ mɩŋ n hannɩ lele!’ ");
INSERT INTO kma_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ʋ chanchaaka die dɩ a gbirigi ʋ nɩŋŋa a jʋʋsɩ wa a baarɩ, ‘Dii suguru n nan tuŋ fʋ!’ ");
INSERT INTO kma_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ama ta die ʋ zeti ta baarɩ ba yigi wo a ga a yi dansarɩka ma a ga tʋgɩ saŋŋa dieke ʋ baaŋ nan tuŋ hannɩ. ");
INSERT INTO kma_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Die ʋ yɔmʋ chanchaalɩba die dɩ yene die wo die ba sʋgɩtɩ dɩ paalɩ chʋʋsɩ die ba ga balɩ ba naaŋ wa wudieke mana dɩ yine. ");
INSERT INTO kma_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naaŋ wa die dɩ wa wa ʋ juu; ʋ piili a zɩa wa a baarɩ dɩ, ‘Fʋnɩŋ vuobɩakʋ gie die n nagɩ hannɩ dieke fʋ dinene a chaa fʋ mɩŋ dama die jʋʋsɩ mɩŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dɩ tɩŋ mʋ fʋ chɩgɩ wa fʋ chanchaaka zɔɔlɩŋ sɩba die n chɩgɩna fʋ zɔɔlɩŋ die wo gbaŋ gbaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Die sɩnyɩɩrɩŋ dɩ paala yallɩ naaŋ wa ʋ nagɩ daa wa a yi dansarɩka sʋŋ dɩ ʋ dii wahala a ga tʋgɩ saŋŋa dieke ʋ baaŋ nan tuŋ hannɩ mana.” ");
INSERT INTO kma_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nandagɩrɩ gie kʋaŋ chaaŋ die Yisa dɩ balɩ dɩ, “Dɩɩ yi fʋ ka nagɩ a chaa fʋ chanchaalɩŋ aŋaŋ fʋ sʋŋ mana die gbaŋ gbaŋ n Chʋa Ŋmɩŋ dieke dɩ benne arɩzanna ma wa dɩ nan yi fʋ.” ");
INSERT INTO kma_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Die Yisa die dɩ balla wɩaha a kpatɩ naa, ʋ nyɩŋ Galili a ga Judia tɩŋgbaŋ dieke dɩ benne Jɔɔdani mʋgɩrɩ chaakʋ. ");
INSERT INTO kma_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ta kpɩkpaaŋ die dɩ dɩ ʋ kʋaŋ die ʋ gbaaŋ vuodiekemba dɩ yʋagɩna mi. ");
INSERT INTO kma_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ta Farasisi bataŋ dɩ a keŋ ʋ jigiŋ a yaala ba magɩsɩ wa, ta pɩasɩ wa, “Tɩ mɩraha yɩ sieŋ dɩ dembiŋ zeti ʋ hɔgʋ ta ʋ ka yi wɩɩŋ mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yisa die dɩ yiŋŋi balɩ ba, “Nɩ ka karɩŋ Ŋmɩŋ gbaŋkʋ dɩ bala die wo? Dɩ ‘Piiliku me, Ŋmɩŋ die naanna vuota, dembiŋ aŋaŋ hɔgʋ, ");
INSERT INTO kma_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ta baarɩ, Naa chɩaŋ ma dembiŋ aŋaŋ hɔgʋ nan va ba chʋalɩŋ aŋaŋ ba nɩɩlɩŋ ta faarɩ taŋ ta ba vuosi bale wo lagɩŋ a yi nyɩŋgbaŋ balɩmɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naa chɩaŋ wɩa ba ka bɩ yi vuosi bale, ba wa yiwo vuobalɩmɩŋ. Die wɩa jadieke Ŋmɩŋ dɩ nagɩna a lagɩŋ taŋ, vuota ka mʋ ʋ puoke.” ");
INSERT INTO kma_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Die Farasisi die dɩ pɩasɩ wa, “Bɩa wɩa Mosisi die dɩ yɩ mɩra dɩ dembiŋ dɩ a keŋ a baa ʋ zeti ʋ hɔgʋ sie ʋ woliŋ a yɩ wa gbanɩŋ a baarɩ dɩ ʋ ka bɩ yaala wa?” ");
INSERT INTO kma_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Nɩ tɩba dɩ hagɩrɩna wɩa die Mosisi die dɩ yɩ nɩ sieŋ dɩ nɩ nan bɩagɩ a zeti nɩ hɔɔŋ. Ama piiliku me da die ka sɩɩ. ");
INSERT INTO kma_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wusie maŋ bala nɩ, vuodieke mana dɩ keŋ zeti ʋ hɔgʋ da daakpana tʋʋma wɩa ta faarɩ hɔgʋ gaaŋ ʋ yiwo hɔgʋkpana tʋʋma; ((ta vuodieke dɩaŋ dɩ faarɩna hɔgʋ wa yiwo hɔgʋkpana tʋʋma)).” ");
INSERT INTO kma_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ta ʋ kʋaŋandɩɩsɩrɩba die dɩ balɩ a yɩ wa dɩ, “Dɩ yiwo naa benne dembiŋ aŋaŋ hɔgʋ sʋnsʋŋ die nɩŋ dembiŋ dɩ ka faarɩ hɔgʋ dɩ kpɩa.” ");
INSERT INTO kma_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ʋ yiŋŋi balɩ ba dɩ, “Da vuoŋ mana baaŋ bɩagɩ a tuo dagɩkʋ gie sie vuodiekemba Ŋmɩŋ dɩ yɩna ba sieŋ dɩ ba tuohe wo. ");
INSERT INTO kma_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dama wɩa pam chɩaŋ ma dembisi bataŋ dɩ ka faara hɔɔŋ; bataŋ ba ŋaaŋ mɩɩrɩ ba ta ba ka yi dembisi; bataŋ dɩaŋ vuota yine be die; ta bataŋ dɩaŋ Ŋmɩŋ naarɩ wɩa ba zete; ama vuodieke dɩ nan bɩagɩ a tuo dagɩkʋ gie, ʋ tuoke vɩɩnɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Die vuosi bataŋ die dɩ chii ba ballɩ a keŋ Yisa jigiŋ dɩ ʋ nagɩ ʋ nuusi a diisi ba ma ta jʋʋsɩ Ŋmɩŋ a yɩ ba ama die ʋ kʋaŋandɩɩsɩrɩba die dɩ nata ba. ");
INSERT INTO kma_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ta Yisa die dɩ balɩ a yɩ ba, “Nɩ vaa ballɩbɩsɩsɩ keŋ n jigiŋ ta nɩ da kagɩ ba sieŋ dama ba chanchaalɩŋ sɩna Ŋmɩŋ naarɩ.” ");
INSERT INTO kma_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Die ʋ nagɩ ʋ nuusi a diisi diisi ba ma ta die chʋŋ ga. ");
INSERT INTO kma_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Saŋka mi dalʋakɩŋ wʋnyɩ die dɩ keŋ Yisa jigiŋ a pɩasɩ wa dɩ, “Dɩdagɩrʋ, lalɩa maŋ nan yi ta ye miivoli dieke dɩ wone kpatɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Bɩa wɩa fʋ pɩasa mɩŋ wʋvɩɩna wɩa? Vuobalɩmɩŋ nyɩɩna ma vɩɩŋ na; ama fʋ yaala fʋ ye miivoli dieke dɩ wone kpatɩŋ fʋ dɩa mɩraha.” ");
INSERT INTO kma_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta daa wa die dɩ pɩasɩ Yisa, “Mɩrɩ bɩaŋtɩ?” Ta ʋ balɩ wa dɩ, “Da keŋ a kʋʋ vuoŋ; da keŋ a yaalɩ vuoŋ hɔgʋ; da keŋ a gaarɩ; da keŋ a yi ŋmɩnchɩbɩsɩ siaratieŋ; ");
INSERT INTO kma_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yɩma fʋ chʋa aŋaŋ fʋ naa jɩlɩma; ta chome fʋ chanchaaŋ sɩba fʋ chone fʋ gbaŋ gbaŋ die wo.” ");
INSERT INTO kma_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta dalʋakɩrɩ die dɩ yiŋŋi a balɩ wa, “N wɔŋ a dɩɩ mɩraha gie mana mɩŋ. Wʋbɩa bɩna a tɩalɩ dɩ n yi a gʋtɩ?” ");
INSERT INTO kma_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta Yisa die dɩ a yiŋŋi a balɩ wa dɩ, “Fʋ yaala fʋ bɩrɩŋ vuovɩɩnɩŋ wusie ga a ga nagɩ fʋ nyinti mana a daa ta nagɩ ligirehe a yɩ zɔɔlɩntieliŋ ta fʋ bɩrɩŋ ligiretieŋ arɩzanna ma, ta fʋ keŋ a dɩa n kʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Die dalʋakɩrɩ dɩ wʋnna naa wa ʋ sʋŋ dɩ chʋʋsɩ ʋ chʋŋ ga, dama die ʋ faasɩ yiwo nyintitieŋ. ");
INSERT INTO kma_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naa chɩaŋ ma Yisa die dɩ a balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Wusie maŋ balɩ nɩ, dɩ nan dɩ tʋa dɩ ligiretieŋ juu Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","N bala nɩ bɩbra, dɩ nan yi mɔlɩ dɩ nyɔgɩnɩ daagɩ garɩyɩɩŋ vɔrɩŋ ma a nyɩŋ a tɩaŋ ligiretieŋ dɩ baaŋ nan juu Ŋmɩŋ naarɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ wʋnna naa die dɩ paalɩ a yi be mamachi die ba pɩasa taŋ dɩ, “Mɩnɩa baaŋ nan bɩagɩ a ye gbatɩtaanɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Die Yisa dɩ kɔtɩ ʋ sikpeŋ a daansɩ ba ta die balɩ yɩ ba dɩ, “Vuota nɩŋ jigiŋ dɩ tʋa mɩŋ, ama Ŋmɩŋ nɩŋ nan bɩagɩ a yi jaaŋ mana.” ");
INSERT INTO kma_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Die Piita die dɩ yiŋŋi a balɩ wa dɩ, “Tɩnɩŋ nɩŋ tɩ va wa tɩ nyinti mana ta keŋ dɩ fʋ. Bɩa yine tɩ nyʋarɩ?” ");
INSERT INTO kma_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Wusie maŋ bala nɩ, saŋŋa dieke manɩŋ vuota Bʋa dɩ keŋ kalɩ n naara gbaŋtɩ ma aŋaŋ hagɩrɩŋ dʋnɩa haalɩkʋ ma, nɩnɩŋ die dɩ yine n kʋaŋandɩɩsɩrɩba dɩaŋ nan dɩ kalɩ naara gbaŋtɩ baŋ aŋaŋ ale mi a dii Izara buuriŋ baŋ aŋaŋ ale wo sarɩya. ");
INSERT INTO kma_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta vuodieke mana dɩ vana ʋ tigiŋ yaa ʋ nɩmballɩ yaa ʋ chɔɔŋ yaa ʋ nuŋ yaa ʋ ballɩ yaa ʋ kʋatɩ n wɩa, ʋ nan daansɩ ye a chanchaaŋ kɔbɩga kɔbɩga, ta bɩ ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama vuosi pam die dɩ wolinne a bie nɩŋŋa nan wɩarɩ kʋaŋ ta vuosi pam die dɩ wɩarɩna kʋaŋ nan tɩaŋ nɩŋŋa.” ");
INSERT INTO kma_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ŋmɩŋ naarɩ sɩɩ sɩba tigiŋ tieŋ dieke dɩ nyɩnna sʋkʋleeliŋ a yaala vuosi dɩ ʋ nagɩ aŋ ba keŋ tʋŋ ʋ kʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Die wʋnɩŋ aŋaŋ ba die dɩ a balɩ a zieŋ dɩ ʋ nan tuŋ be dɩnda daarɩ mi tune; die ba ga piili kpɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Die dɩ wa tʋga hawa awayɩ saŋŋa, tigiŋ tieŋ wo dɩ bɩ nyɩŋ a ga a ga ye vuosi bataŋ ba zene nyʋʋŋ jigiŋ ta ka yie wɩɩŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta ʋ balɩ a yɩ ba, ‘Nɩ gbaŋ nɩ ga a ga tʋŋ tʋʋma n kʋakʋ ma, ta n nan tuŋ nɩ tuŋ dieke dɩ mʋna.’ ");
INSERT INTO kma_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Die wɩa die ba ga. Die dɩ tʋgɩna agbaa saŋŋa die ʋ bɩ yi die gbaŋ gbaŋ, ta agbaa die dɩ tɩanna hawasɩ ataa kʋaŋ chaaŋ, die ʋ bɩ yi die gbaŋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Die dɩ wa tʋga jɩŋmɩŋ (agbaa kʋaŋ chaaŋ hawasɩ anʋ wonde), die ʋ bɩ a ga nyʋʋkʋ chaaŋ a ye dembisi bataŋ dɩ zene mi ta ka tʋma tʋʋmɩŋ mana. Die ʋ pɩasɩ ba dɩ, ‘Bɩa nɩ zie giena yɔrɩ damʋʋmɩŋ ta ka yie wɩɩŋ?’ ");
INSERT INTO kma_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Die ba yiŋŋi a balɩ wa dɩ, ‘Vuoŋ ka keŋ nagɩ tɩ dɩ tɩ ga tʋŋ ʋ tʋʋma.’ Die wɩa ʋ balɩ ba, ‘Nɩ gbaŋ nɩ ga a ga tʋŋ tʋʋma n kʋakʋ ma.’ ");
INSERT INTO kma_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Die ŋmɩŋ dɩ nanna, tigiritieŋ wo dɩ wa ʋ tʋntʋntɩba jakʋʋŋ dɩ, ‘Ga wa tʋntʋntɩba a tuŋ be ba tune, piili a nyɩŋ vuodiekemba dɩ kenne kʋaka a ga tʋgɩ vuodiekemba dɩ wolinne wo.’ ");
INSERT INTO kma_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ta ʋ tʋntʋntʋ jakʋʋrɩ die dɩ tuŋ vuodiekemba dɩ wɩarɩna kʋaka a keŋ wo dɩnda daarɩ mi tune. ");
INSERT INTO kma_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Die wɩa die dɩ kenne a tʋgɩ vuodiekemba dɩ kenne sʋkʋleeliku, die ba yile dɩ ba tune nan dɩ dala ama die ʋ tuŋ ba gbaŋ dɩnda daarɩ mi tune. ");
INSERT INTO kma_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Die ba tuo ba ligirehe a kpatɩ die ba piili a vʋʋna ta galɩma tigiritieŋ wo, ");
INSERT INTO kma_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a baarɩ, ‘Vuosi gie wɩarɩ wa kʋaŋ a keŋ kʋakʋ, agbaa kʋaŋ hawasɩ anʋ saŋŋa ta kʋa hawa balɩmɩŋ, ama tɩnɩŋ tɩ dine wahala a ga a gbalɩgɩ a nyɩŋ sʋkʋʋŋ mana, ta ŋmɩnnɩ dɩ nɩgɩ tɩ pam, ama tɩnɩŋ aŋaŋ banɩŋ dɩ lagɩsɩ a tuo tuŋ balɩmɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Die tigiritieŋ wo dɩ yiŋŋi a balɩ ba wʋnyɩ, ‘N zʋa, wʋmma, n ka nyɩrɩ nɩ, dama tɩ tɩŋ balɩ zie mɩŋ nɩ saagɩ dɩnda daarɩ mi tune. ");
INSERT INTO kma_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Die wɩa nagɩ fʋ tʋaŋ a ga tigiŋ. Manɩŋ n yaala n tuŋ wo nɩ aŋaŋ vuodieke dɩ kenne kʋaka bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N wo sieŋ dɩ n nagɩ n ligirehe a yi wudieke n yaalala? Yaa wa sʋgɩbɩaŋ dama n kana ka mʋma wɩa?’ ” ");
INSERT INTO kma_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yisa die dɩ taanna nandagɩrɩ a kpatɩ wa kʋaŋ chaaŋ ta ʋ balɩ ba dɩ, “Die wɩa vuodiekemba dɩ benne kʋaŋ nan dɩ bie nɩŋŋa ta vuodiekemba dɩ benne nɩŋŋa wɩarɩ kʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Die Yisa die dɩ jʋalɩna a gara Jerusalemi, die ʋ wa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a nyɩŋ lʋgɩŋ a die a balɩ a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nɩ wʋmma, tɩ jʋalɩ a gara Jerusalemi ma, jigidieke ba balla ba nagɩ manɩŋ vuota Bʋa a yi Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ mɩraha dɩdagɩrɩba nuusi me, aŋ ba dii n sarɩya a baarɩ dɩ n chʋʋsɩya amʋ ba kʋʋ mɩŋ, ");
INSERT INTO kma_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ta nagɩ mɩŋ a yi vuodiekemba dɩ kana a ka yi Juu vuosi nuusi me aŋ ba vʋarɩ mɩŋ fala, ta nɩgɩ mɩŋ aŋaŋ kpaasɩŋ ta kpaasɩ mɩŋ a diisi dagarɩkʋ ma, aŋ n kpi ama a daraa ataa ma n nan hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Womi Zebedi hɔgʋ die dɩ chii ʋ ballɩ bale a keŋ Yisa jigiŋ, ta gbirigi ʋ nɩŋŋa ta jʋʋsɩ wa suŋŋiŋ. ");
INSERT INTO kma_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yisa die dɩ pɩasɩ wa dɩ, “Bɩa fʋ yaala?” Die ʋ yiŋŋi balɩ wa, “Yɩ mɩŋ nʋaŋ dɩ n ballɩ gie wʋnyɩ nan daansɩ kalɩ fʋ nuudiigiŋ chaaŋ ta wʋnyɩ dɩaŋ fʋ nuugalɩ chaaŋ saŋŋa dieke fʋ keŋ dii fʋ naarɩ.” ");
INSERT INTO kma_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ta Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Nɩ zɩ nɩ jʋʋsɩnana jadieke. Nɩ nan bɩagɩ a chii chiiti dieke n balla n chii wo?” Die ba yiŋŋi a balɩ wa dɩ, “Wa, tɩ nan bɩagɩ.” ");
INSERT INTO kma_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yisa die dɩ balɩ a yɩ ba dɩ, “Wusie, nɩ nan chii chiiti dieke n bala n chii wo, ama n wo sieŋ dɩ n vʋarɩ vuodiekemba dɩ mʋna ba kala n nuudiigiŋ aŋaŋ n nuugalɩ chaaŋ. Jigehe gie zie gbarɩ wa vuodiekemba n Chʋa Ŋmɩŋ gbaŋ gbaŋ die dɩ vʋarɩna dɩ ba kala mi.” ");
INSERT INTO kma_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Die ʋ kʋaŋandɩɩsɩrɩ tɩalɩkaha die dɩ wʋnna naa, die ba jɩɩ sɩnyɩɩrɩŋ a yi ba bale wo. ");
INSERT INTO kma_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Naa chɩaŋ wɩa Yisa die dɩ wa ba mana a lagɩsɩ taŋ ʋ jigiŋ a balɩ ba, “Nɩ gbaŋ nɩ sɩba a baarɩ vuodiekemba dɩ daansɩnana vuosi tɩŋgbaŋka gie me ŋaaŋ daga wa ba gbaŋ ta nyɩŋkʋraha dɩaŋ ŋaaŋ pɔgɩlɩ wa ba vuosi aŋaŋ nɩŋŋmɩna. ");
INSERT INTO kma_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama nɩnɩŋ die wo, nɩ sʋnsʋŋ vuodieke dɩ yaala nyɩŋkʋrɩtɩ, sie ʋ nagɩ ʋ gbaŋ a bɩrɩŋ wabʋ a tʋma a yɩma vuoŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Vuodieke dɩaŋ dɩ bɩ yaala ʋ bemme nɩŋŋa, sie ʋ nagɩ ʋ gbaŋ a bɩrɩŋ nɩ mana yɔmʋ, ");
INSERT INTO kma_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","sɩba manɩŋ vuota Bʋa dɩ sɩna die wo, dama n ka keŋye dɩ vuosi tʋma a yɩma mɩŋ ama n keŋye dɩ n tʋŋ yɩ vuosi, ta bɩ kpi a yi vuosi pam ye gbatɩtaanɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ nyɩnana Jeriko me, die kpɩkpaaŋ die dɩ dɩ Yisa kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta yɩɩsɩ bale die dɩ kalɩ sieku nʋaŋ a wʋŋ dɩ Yisa keŋ tɩanna mɩŋ, die wɩa die ba piili a keese a baarɩ, “Tɩ Yɔmʋtieŋ, naaŋ Davidi haagɩŋ chɩgɩ tɩ zɔɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ama kpɩkpaakʋ die dɩ natɩ ba dɩ ba tarɩ watɩ, ama ta die ba wa a faasɩ a keese, “Tɩ Yɔmʋtieŋ, Davidi haagɩŋ, chɩgɩ tɩ zɔɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yisa die dɩ zie ta wa ba a keŋ pɩasɩ ba dɩ, “Bɩa nɩ yaala n yi a yɩ nɩ?” ");
INSERT INTO kma_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba yiŋŋi a balɩ wa, “Tɩ Yɔmʋtieŋ, tɩ yaala fʋ yuori wo tɩ nine.” ");
INSERT INTO kma_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ta zɔɔlɩŋ die dɩ yigi Yisa, ta ʋ gbi gbi ba ninehe, die ba ninehe die dɩ yuori yuori, ta ba dɩ ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Die ba kenne a keŋ gbigi Jerusalemi ta keŋ Betifeji tɩŋ, tɩŋ dieke die dɩ benne kunkogiŋ dieke ba wasɩnana Olivi Tɩɩsɩ Kunkogiŋ lʋgɩŋ. Yisa die dɩ tʋŋ ʋ kʋaŋandɩɩsɩrɩba bale dɩ ba ga nɩŋŋa ");
INSERT INTO kma_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta balɩ ba, “Nɩ gamma tɩŋkpaŋka dɩ benne nɩ nɩŋŋa, womi nɩ nan ye bonnɩɩŋ dɩ bɔbɩna zie ta ka bʋa dɩ zie mi; nɩ forisike a yaa ha a keŋ n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dɩɩ yi ta vuoŋ dɩ pɩasɩ nɩ wɩɩŋ, nɩ balɩ wa, nɩ Yɔmʋtieŋ yaalala ka, ta ʋ nan vaa nɩ yaa ha keŋ.” ");
INSERT INTO kma_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wɩaha gie mana die keŋ yi mɩŋ sɩba die Ŋmɩŋ dɩ vana ʋ naazʋalɩba wʋnyɩ die dɩ balɩna die wo dɩ ");
INSERT INTO kma_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nɩ balɩ Zayɔni tɩka vuosi dɩ, ‘Ye, nɩ naaŋ wa kieŋ nɩ jigiŋ. Ʋ yiwo vuodieke dɩ sʋʋna ʋ gbaŋ tɩŋgbaŋ, ta jʋala boŋ dieke dɩ yi bonpɔlɩ.’ ” ");
INSERT INTO kma_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ ga yi wudieke Yisa die dɩ balla ba dɩ ba yi wo. ");
INSERT INTO kma_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Die ba yaa bonɩɩkʋ aŋaŋ ka bʋa a keŋ, a nagɩ ba nyinyeeke a diisi a kʋasɩ ta Yisa dɩ jʋalɩ. ");
INSERT INTO kma_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kpɩkpaakʋ vuosi bataŋ die dɩ nagɩ ba nyinyeeke a jatɩ sieku me, ta bataŋ dɩaŋ dɩ chɩa tɩɩsɩ naasɩ a jatɩ sieku me. ");
INSERT INTO kma_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta kpɩkpaaŋ dieke dɩ benne ʋ nɩŋŋa aŋaŋ vuodiekemba dɩ benne ʋ kʋaŋ dɩ nata a baarɩ, “Hozaana! Nɩ bɩrɩma Davidi haagɩrɩ gie. Ŋmɩŋ yi alibarika a yɩ vuodieke dɩ kennene ʋ saaŋ ma. Nɩ faasɩ natɩma hozaana ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Die Yisa die dɩ gana a ga juu Jerusalemi, tɩka vuosi mana die dɩ hagɩ a zie a pɩasa taŋ dɩ, “Mɩnɩa wʋnna?” ");
INSERT INTO kma_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kpɩkpaakʋ die dɩ yiŋŋi balɩ ba dɩ, “Yisa, vuodieke dɩ yine Ŋmɩŋ naazʋa ta nyɩŋ Nazeriti, Galili tɩŋgbaŋ ma wa.” ");
INSERT INTO kma_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ta Yisa die dɩ ga a juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a yagɩ vuodiekemba mana die dɩ daanana aŋaŋ vuodiekemba die dɩ yalla nyinti a daa mi; die ʋ kpaŋŋɩ vuodiekemba dɩ tarɩgɩnana ligirehe teebulisi a bubi bubi aŋaŋ vuodiekemba die dɩ yalla ŋmarɩsɩ a daa wa chɩasɩ a bubi, ");
INSERT INTO kma_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ta die a balɩ ba dɩ, “Dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ wʋnɩŋ Ŋmɩŋ baarɩ, ‘N tigiri gie nan dɩ wasa Ŋmɩŋ jʋʋsɩŋ jigiŋ’ ama nɩnɩŋ nɩ nagɩ ka a bɩrɩŋ gaarɩŋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Die yɩɩsɩ aŋaŋ gbarɩgɩsɩ die dɩ keŋ ʋ jigiŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma die ʋ gbaaŋ ba mana. ");
INSERT INTO kma_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ama die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba die dɩ jɩɩ sɩnyɩɩrɩŋ die ba yene ʋ yinene mamachi wɩaha ta bɩ wʋŋ ballɩbɩsɩsɩ dɩ natɩnana Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a baarɩ, “Hozaana, nɩ bɩrɩma Davidi haagɩrɩ gie die wo!” ");
INSERT INTO kma_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Die ba pɩasɩ wa, “Wʋŋ wudieke ba balala wa mɩŋ?” Ta ʋ yiŋŋi a balɩ ba, “Wa, ama dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ, ‘Fʋ yine ballɩbɩsɩsɩ aŋaŋ ballɩnyaalɩsɩ dɩ bɩra fʋ vɩɩnɩŋ.’ Nɩ ye ka karɩŋ wɩaha gie Ŋmɩŋ gbaŋkʋ sʋŋ?” ");
INSERT INTO kma_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yisa die dɩ va ba, ta nyɩŋ tɩka sʋŋ a ga Betani, die a dʋa mi tʋŋ dɩ vʋŋ. ");
INSERT INTO kma_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tʋŋ die dɩ vʋʋna sʋkʋleeliŋ die ʋ yiŋŋi a gara tɩka sʋŋ, die kɔŋ die dɩ yallɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Die ʋ ye kɩnkamɩŋ tɩɩŋ dɩ zene gbigi sieku nʋaŋ die ʋ ga ka jigiŋ, ama die ʋ ka ye jaaŋ mana ka sikpeŋ sie vaatɩ nyɩɩna ma. Na chɩaŋ ma die ʋ balɩ yɩ tɩɩka dɩ, “Kaaŋ bɩ nyɩŋ nyɩŋnyɩŋka!” Lele womi tɩɩka mana die dɩ ko. ");
INSERT INTO kma_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ʋ kʋaŋandɩɩsɩrɩba die dɩ yene naa wa die dɩ yi be mamachi. Die ba pɩasa taŋ, “Lalɩa kɩnkamɩŋ tɩɩka dɩ ko lagɩ lagɩ die?” ");
INSERT INTO kma_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Wusie maŋ bala nɩ, dɩɩ yi nɩ yi Ŋmɩŋ yada ta ka chɩɩlɩya nɩ nan bɩagɩ a yi wudieke n yine yɩ kɩnkamɩŋ tɩɩka gie; daa genke nyɩɩna ma, nɩ nan bɩagɩ a balɩ yɩ kunkogiri gie dɩ, vʋʋ a ga nan mʋgɩkpɩɩrɩ ma aŋ ka seŋ yi. ");
INSERT INTO kma_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dɩɩ yi nɩ yi Ŋmɩŋ yada nɩ nan ye jadieke mana nɩ jʋʋsɩnana a yaala.” ");
INSERT INTO kma_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisa die dɩ yiŋŋi a keŋ juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma, ta die daga vuosi Ŋmɩŋ wɩaha, die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Juu vuosisi nyɩŋkʋra die dɩ keŋ ʋ jigiŋ a pɩasɩ wa dɩ, “Bɩa yiko fʋ yaa yie wɩaha gie? Mɩnɩa yɩna fʋ yiko ke gie?” ");
INSERT INTO kma_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta Yisa dɩ yiŋŋi a balɩ ba, “N nan pɩasɩ nɩ wʋbalɩmɩŋ, dɩɩ yi nɩ bɩagɩ a balɩ mɩŋ ka chɩaŋ, n nan balɩ nɩ yiko dieke a yalla a yie wɩaha gie: ");
INSERT INTO kma_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jɔɔn vuodieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ, Ŋmɩŋ die yɩna wa yiko yaa vuota?” Ba piili a nɩga nɩnhagɩrɩŋ dɩ, “Bɩa tɩ baa tɩ balɩ? Tɩ keŋ a baarɩ ‘Ŋmɩŋ jigiŋ’, ʋ nan yiŋŋi a balɩ tɩ dɩ, ‘Ta bɩa wɩa nɩ ka yi wo yada?’ ");
INSERT INTO kma_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama tɩ keŋ baarɩ ka nyɩŋ vuota jigiŋ, tɩ chɩga ŋmaamɩŋ aŋaŋ wudieke kpɩkpaakʋ dɩ baaŋ yi, dama vuoŋ mana die yi yada dɩ Jɔɔn seŋ yiwo Ŋmɩŋ naazʋa.” ");
INSERT INTO kma_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Die wɩa die ba yiŋŋi a balɩ Yisa dɩ, “Tɩ ka sɩba.” Die ʋ balɩ yɩ ba, “Die nɩŋ n kaaŋ balɩ nɩ vuodieke dɩ yɩna mɩŋ yiko maŋ yaa yie tʋʋmaha gie.” ");
INSERT INTO kma_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A kʋaŋ chaaŋ Yisa dɩ pɩasɩ ba dɩ, “Lalɩa nɩ yile yaa gamma wɩarɩ gie? Daa wʋnyɩ die yalla ballɩ bale, ta die balɩ a yɩ jakʋʋrɩ dɩ, ‘N bʋa, ga kʋakʋ ma a tʋŋ tʋʋma jinne.’ ");
INSERT INTO kma_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bʋa wa die dɩ yiŋŋi a balɩ wa, ‘N kaaŋ ga’ ama ka kʋaŋ chaaŋ ʋ tarɩgɩ ʋ sʋŋanyile ta ga kʋakʋ. ");
INSERT INTO kma_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Die chɔɔŋ wa dɩ ga bʋabike jigiŋ a balɩ die gbaŋ gbaŋ a yɩ wa, ʋ yiŋŋi a balɩ dɩ, ‘N chʋa n nan ga’, ama die ʋ ka gaya.” ");
INSERT INTO kma_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yisa die dɩ taanna nandagɩrɩ gie a kpatɩ die ʋ pɩasɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Juu vuosisi nyɩŋkʋraha dɩ, “Ballɩ bale wo gie, ba jabɩa yine ʋ chɔɔŋ dɩ yaalala dene?” Die ba yiŋŋi a baarɩ, “Jakʋʋrɩ.” Yisa die dɩ balɩ a yɩ ba dɩ, “Wusie maŋ bala nɩ, lampotuosiribe aŋaŋ vuodiekemba dɩ dʋaga hɔgʋkpana yaa daakpana nan woliŋ a juu Ŋmɩŋ naarɩ ma nɩ ma. ");
INSERT INTO kma_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dama Jɔɔn dieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ die keŋ nɩ jigiŋ a dagɩ nɩ sievɩɩŋkʋ ama die nɩ ka yi wo yada, ama lampotuosiribe aŋaŋ hɔgʋkpana aŋaŋ daakpana die dɩ yi wo yada. Die nɩ yene wɩaha gie mana kʋaŋ chaaŋ, nɩ ka tarɩgɩ nɩ sʋŋanyile ta yi wo yada.” ");
INSERT INTO kma_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yisa die dɩ bɩ a balɩ ba, “Nɩ bɩ wʋŋ nandagɩŋ kaanɩ bɩbra. Tigiŋ tieŋ wʋnyɩ die benne a sʋʋ tɩɩ diekemba dɩ baaŋ nan nyɩŋ nyɩŋnyɩŋka ʋ kʋaŋ ma, a nagɩ daatɩ a kpie giliŋke, ta die a wʋnsɩ vɔrɩŋ, jigidieke ba baaŋ dɩ ŋmʋa nyɩŋnyɩŋka nyaabʋ a yie, ta kpii vɩɩŋ mi. Ta nagɩ kʋakʋ a yɩ tʋntʋntɩba nuusi me dɩ ba daansɩma. Dɩɩ yi a keŋ ŋmɩntɩ dɩ ba kpaa a yɩ wa ta kpaa ba tʋaŋ. Ka kʋaŋ chaaŋ die ʋ dɩa a ga tɩŋ kaanɩ. ");
INSERT INTO kma_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Die nyɩnyɩŋkaha kpaala saŋŋa die dɩ kenne tʋgɩ die ʋ tʋŋ ʋ yɔŋɩsɩ dɩ ba ga tʋntʋntɩba jigiŋ a ga tuo ʋ tʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ama ta tʋntʋntɩba dɩ yigi ʋ yɔŋɩsɩsɩ a nɩgɩ wʋnyɩ pam ta kʋʋ wʋnyɩ ta taa wʋnyɩ dɩaŋ aŋaŋ tana. ");
INSERT INTO kma_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Daa wa dɩ bɩ tʋŋ yɔŋɩsɩ bataŋ a tɩaŋ vuodiekemba ʋ wolinne a tʋŋ wa, ta tʋntʋntɩba dɩ yi be die gbaŋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kʋaŋ kʋaŋ chaaŋ ʋ tʋŋ ʋ gbaŋ gbaŋ ʋ Bʋadembiŋ. A baarɩ, ‘N sɩba baarɩ ba nan yɩ n bʋa wa jɩlɩma.’ ");
INSERT INTO kma_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama tʋntʋntɩba die dɩ yene ʋ bʋa wa die ba balɩ yɩ tamba, ‘Ʋ faarɩ diiru wo wʋnna, nɩ vaa tɩ kʋʋ wa ta nyinti bɩrɩŋ tɩ sɩɩtɩ!’ ");
INSERT INTO kma_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ta die ba yigi wo a nagɩ wa a nyɩŋ kʋakʋ lʋgɩŋ a kʋʋ wa.” ");
INSERT INTO kma_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yisa die dɩ taanna nandagɩrɩ gie a kpatɩ die ʋ pɩasɩ ba, “Die wɩa kʋakʋ tieŋ dɩ keŋ keŋ bɩa ʋ baa ʋ yi tʋntʋntɩba mi?” ");
INSERT INTO kma_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ba yiŋŋi balɩ wa dɩ, “Ʋ nan kʋʋ banɩŋ tʋntʋmbɩatɩ tielibe ta nagɩ kʋakʋ a yɩ vuogaasɩ, vuodiekemba dɩ baaŋ nan yɩ wa ʋ nyɩŋnyɩŋkaha tʋaŋ a kpaala saŋŋa.” ");
INSERT INTO kma_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yisa dɩ balɩ yɩ ba, “Nɩ ye ka karɩŋ Ŋmɩŋ gbaŋkʋ sʋŋ die dɩ maagɩna die wo? Dɩ maagɩya dɩ ‘Taŋ dieke mɩmɩɩrɩba die dɩ zetine ta baarɩ ba ka yaala ka wa die dɩ yiŋŋi a keŋ yi gɔŋgɔŋyʋgɩrɩŋ taŋ vɩɩnɩŋ, Nabidie Ŋmɩŋ yine die ta a faasɩ yi tɩ mamachi!’ ” ");
INSERT INTO kma_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Die wɩa Yisa die dɩ balɩ a yɩ ba, “Wusie maŋ balɩ nɩ, Ŋmɩŋ nan gbatɩ ʋ naarɩ a nyɩŋ nɩ jigiŋ ta nagɩ a yɩ vuodiekemba dɩ baaŋ nan vaa ʋ dii ka nyʋarɩ. ");
INSERT INTO kma_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","((Ama vuodieke dɩ nanna tanɩ gie sikpeŋ nan ŋmabɩ ŋmabɩ ama vuodieke tanɩ dɩ keŋ nan ʋ sikpeŋ ʋ nan nʋŋ nʋŋ sɩba zɔŋ.))” ");
INSERT INTO kma_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Farasisi die dɩ wʋnna nandagaha die ba mɩŋŋɩ sɩba banɩŋ ba wɩa Yisa die taaŋ nandagɩrɩ. ");
INSERT INTO kma_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Die ba yaala ba yigi wo, ama die ba chɩga kpɩkpaakʋ ŋmaamɩŋ dama vuosi die yi yada a baarɩ dɩ Yisa yiwo Ŋmɩŋ naazʋa. ");
INSERT INTO kma_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisa die dɩ bɩ nagɩ nandaga a balɩ wɩa a yɩ vuosisi dɩ, ");
INSERT INTO kma_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ŋmɩŋ naarɩ sɩɩ sɩba naaŋ wʋnyɩ die dɩ wʋnsɩna hɔgʋhaalʋ banwʋla dɩ ʋ yɩ ʋ bʋa. ");
INSERT INTO kma_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ta die tʋŋ ʋ yɔŋɩsɩ dɩ ba ga balɩ vuodiekemba ʋ wone a posi wo dɩ ba keŋ banwʋlaka, ama die ba ka yaala ba keŋ. ");
INSERT INTO kma_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Die ʋ bɩ tʋŋ yɔŋɩsɩ bataŋ ta balɩ ba dɩ, ‘Nɩ gamma a ga balɩ vuodiekemba die n wone a posi wo dɩ chaantɩ nyindiike yi siri mɩŋ; n wɔŋ kʋʋ narapɔlɩka aŋaŋ naara narɩka ta a mana yi wo siri; die wɩa nɩ keŋ a keŋ dii banwʋlaka chaantɩ!’ ");
INSERT INTO kma_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama die ʋ posine vuodiekemba ba die ka tɔgɩŋ wa ta die ga ba tʋʋma jige; wʋnyɩ dɩ ga ʋ kʋaŋ, ta wʋnyɩ dɩaŋ dɩ ga ʋ nyinti daala jigiŋ nyʋʋŋ ma, ");
INSERT INTO kma_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ta bataŋ dɩaŋ die dɩ yigi ʋ yɔŋɩsɩsɩ a nɩgɩ nɩgɩ ba ta kʋʋ ba. ");
INSERT INTO kma_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Die naaŋ wa dɩ jɩɩ sɩnyɩɩrɩŋ pam; ʋ tʋŋ ʋ sojasi ba ga kʋʋ vuokʋʋlaha ta jʋʋ ba tɩka boliŋ. ");
INSERT INTO kma_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A kʋaŋ chaaŋ die naaŋ wa dɩ wa ʋ yɔŋɩsɩsɩ a balɩ ba dɩ, ‘N hɔgʋhaalʋ banwʋlaka chaantɩ yi siri mɩŋ, ama vuodiekemba n wone a posi wo ka mʋ dɩ ba keŋ. ");
INSERT INTO kma_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Die wɩa nɩ wa gamma tɩka sʋŋ siekpɩɩma ma, a wa vuodieke mana nɩ baaŋ nan tuoli dɩ ba keŋ a dii laalɩkʋ chaantɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Die ʋ yɔŋɩsɩsɩ dɩ nyɩŋ ga siekpɩɩma ma, a ga wa vuodiekemba mana ba yene, vuovɩɩna aŋaŋ vuobɩatɩ mana; ta die ba keŋ a suuli banwʋlaka tigiri me. ");
INSERT INTO kma_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ta Naaŋ wa die dɩ keŋ dɩ ʋ daansɩ ye vuodiekemba dɩ kenne banwʋlaka, die ʋ ye daa wʋnyɩ dɩ benne vuosi sʋnsʋŋ ta ka yeegi banwʋla nyiŋyeeke. ");
INSERT INTO kma_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta Naaŋ wa dɩ pɩasɩ wa, ‘N zʋa yiwo lalɩa a keŋ juu giena ta ka yeegi banwʋlaka nyiŋyeeke?’ Ama daa wa die ka balɩ wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Womi naaŋ wa die dɩ balɩ yɩ ʋ yɔŋɩsɩ, ‘Nɩ bɔbɩ ʋ nuusi aŋaŋ ʋ nagɩsɩ a nagɩ wa a taaŋ yeŋ me lɩmɩŋ ma. Mi ʋ nan dɩ kʋma ta ŋɔba nyɩna.’ ” ");
INSERT INTO kma_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisa die dɩ taanna nandagɩrɩ a kpatɩ, ʋ balɩ ba dɩ, “Ŋmɩŋ wa wa vuosi pam, ama ʋ nan vʋarɩ vuosi bɩta.” ");
INSERT INTO kma_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Die Farasisi vuosi die dɩ nyɩŋ a ga a lagɩsɩ tamba a yaala sieti dɩ ba yigi Yisa aŋaŋ wʋpɩasɩka. ");
INSERT INTO kma_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Die ba tʋŋ ba kʋaŋandɩɩsɩrɩba bataŋ aŋaŋ Herodi vuosi bataŋ Yisa jigiŋ. Die ba pɩasɩ wa dɩ, “Dɩdagɩrʋ, tɩ sɩba a baarɩ bala wusie, ta daga vuosi Ŋmɩŋ sieti aŋaŋ wusie, ta ka tɔgɩma vuosi, dama fʋ ka tɔgɩma vuota dɩ sɩna die. ");
INSERT INTO kma_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Die wɩa, balɩ tɩ, lalɩa fʋ yile yaa gamma lampo tuniŋ wɩa? Tɩ mɩraha yɩ sieŋ mɩŋ dɩ tɩ tumme lampo a yɩma Roma tɩŋgbaŋ naaŋ wa Siiza yaa tɩ daa tumme?” ");
INSERT INTO kma_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ta Yisa die dɩ wɔŋ sɩba ba sʋŋanyilibɩatɩ, die wɩa die ʋ balɩ dɩ, “Nɩnɩŋ gɩgaantɩba gie, bɩa nɩ yaala nɩ magɩsɩ mɩŋ? ");
INSERT INTO kma_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nɩ nagɩ ligiribiŋ dieke nɩ balla nɩ nagɩ a tuŋ lampoke a dagɩ mɩŋ.” Die ba yaa ligire bini a keŋ yɩ wa, ");
INSERT INTO kma_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","die ʋ pɩasɩ ba dɩ, “Mɩnɩa nine chaaŋ aŋaŋ ʋ saaŋ diisine ka ma die?” ");
INSERT INTO kma_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Die ba yiŋŋi baarɩ, “Naaŋ Siiza.” Die chɩaŋ ma die Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Die nɩŋ nɩ tuŋ a yɩ naaŋ Siiza jadieke dɩ yine ʋ sɩɩtɩ ta tuŋ yɩ Ŋmɩŋ jadieke dɩ yine Ŋmɩŋ sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Die ba wʋnna naa wa die dɩ yi be mamachi, die ba va wa ta ga. ");
INSERT INTO kma_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dɩnɩŋ daarɩ mi gbaŋ gbaŋ die Sadusi vuosi bataŋ die dɩ keŋ Yisa jigiŋ. (Banɩŋ ba balala dɩ kunti kaaŋ hagɩ kuŋ me.) ");
INSERT INTO kma_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Die a baarɩ, “Dɩdagɩrʋ, Mosisi die balɩ dɩ dembiŋ dɩ keŋ faarɩ hɔgʋ ta kpi ta wo ballɩ, sie ʋ nɩmbʋa faarɩ kpihɔgʋ wa a mɩɩrɩ ballɩ a yɩ vuodieke dɩ kpine wo. ");
INSERT INTO kma_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Die nɩmballɩ bayʋpɔyɩ die benne. Die jakʋʋrɩ dɩ faarɩ hɔgʋ ta kpi ta wo ballɩ, ta ʋ nɩmbʋa dɩ faarɩ kpihɔgʋ wa. ");
INSERT INTO kma_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Die gbaŋ gbaŋ die dɩ yi ʋ nɩmbʋa die dɩ diisine bule wo a yaa ga tʋgɩ vuodieke die dɩ diisine bʋtaa wa, a yaa die a ga kpatɩ dembisi bayʋpɔyɩ wa mana. ");
INSERT INTO kma_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka kʋaŋ kʋaŋ chaaŋ hɔgʋ wa dɩaŋ die dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Die wɩa, dɩɩ yi ta kunti hagɩŋ daaŋ dɩ keŋ tʋgɩ, mɩnɩa hɔgʋ baaŋ yi wo? Dama ba mana die faarɩ wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yisa die dɩ yiŋŋi a balɩ ba, “Nɩ baya mɩŋ, dama nɩ ka sɩba Ŋmɩŋ gbaŋkʋ, ta bɩ ka sɩba Ŋmɩŋ dɩ yalla hagɩrɩŋ dene. ");
INSERT INTO kma_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Dama kunti dɩ keŋ hagɩ kuŋ me ba nan dɩ sɩɩ sɩba malakasi dɩ benne arɩzanna ma, ta hɔgʋ faarɩŋ aŋaŋ dembiŋ yallɩŋ kaaŋ dɩ beri. ");
INSERT INTO kma_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yaa gamma kunti hagɩŋ ma nɩ ye ka karɩŋ wudieke Ŋmɩŋ dɩ bala a yɩ nɩ wa ʋ gbaŋkʋ ma? ");
INSERT INTO kma_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Dɩ ‘Manɩŋ n yine Ŋmɩŋ dieke Abarahami aŋaŋ Aziki aŋaŋ Jakobu dɩ jɩannana.’ Vuosi gie die kpiye mɩŋ ama ba ye ko bie ba mɩsɩ ma dama Ŋmɩŋ ka yi kunti Ŋmɩŋ ama vuodiekemba dɩ benne ba mɩsɩ ma?” ");
INSERT INTO kma_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Die kpɩkpaakʋ dɩ wʋnna naa, die dɩ yi be mamachi aŋaŋ ʋ dagɩkʋ. ");
INSERT INTO kma_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Die Farasisi dɩ wʋnna dɩ Yisa nyɩŋbalɩkaha die nyaŋŋɩ Sadusisi die ba lagɩsɩ tamba a keŋ. ");
INSERT INTO kma_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba wʋnyɩ die dɩ yine mɩraha dɩdagɩrʋ dɩ magɩsɩ wa aŋaŋ wʋpɩasɩkɩŋ dɩ, ");
INSERT INTO kma_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Dɩdagɩrʋ, mɩrɩ bɩa tɩanna mɩraha mana?” ");
INSERT INTO kma_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yisa die dɩ yiŋŋi a baarɩ dɩ, “ ‘Chome fʋ Yɔmʋtieŋ Nabidie Ŋmɩŋ aŋaŋ fʋ sʋŋ mana aŋaŋ fʋ haalɩŋ mana aŋaŋ fʋ sʋŋanyile mana.’ ");
INSERT INTO kma_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Genke yine mɩrɩ dieke dɩ benne nɩŋŋa ta bɩ tɩaŋ mɩraha mana. ");
INSERT INTO kma_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta jadieke dɩaŋ dɩ diisine bule wo dɩaŋ bɩ yiwo nɩŋŋmɩna a gʋtɩ, ‘Chome fʋ chanchaaŋ sɩba fʋ gbaŋ gbaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosisi mɩraha mana aŋaŋ Ŋmɩŋ naazʋalɩba dagɩtɩ mana diisi wo mɩraha ale wo gie me.” ");
INSERT INTO kma_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Saŋŋa dieke ta Farasisi dɩ lagɩsɩna tamba die Yisa dɩ pɩasɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Bɩa nɩ yile yaa gamma Ŋmɩŋ vuovʋarɩkɩrɩ Masia wa wɩa? Mɩnɩa bʋa yine wo?” Ba yiŋŋi balɩ wa “Ʋ yiwo Davidi haagɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Die Yisa dɩ pɩasɩ ba, “Ta bɩa yine saŋŋa dieke Davidi die dɩ suuline aŋaŋ Ŋmɩŋ Haalɩbʋ die dɩ wasa wa dɩ, n ‘Yɔmʋtieŋ?’ Ta baarɩ ");
INSERT INTO kma_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nabidie Ŋmɩŋ die bala n Yɔmʋtieŋ; Kala n nuudiigiŋ chaaŋ, a ga tʋgɩ saŋŋa dieke n baaŋ nan nagɩ fʋ dataasɩ a yi fʋ nuusi me.’ ");
INSERT INTO kma_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dɩɩ yi ta Davidi die dɩ wasa Masia wa dɩ ‘N Yɔmʋtieŋ’, dɩ bɩ baa dɩ yiwo lalɩa Masia wa bɩ yi Davidi haagɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Die ba wʋnyɩ mana die ka bɩagɩ a yiŋŋi a balɩ wɩɩŋ, die wɩa a nyɩŋ dɩnda daarɩ mi yaa gamma vuoŋ die ka bɩ yaa sikimiŋ a baaŋ nan bɩagɩ a pɩasɩ Yisa wʋpɩasɩka. ");
INSERT INTO kma_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Die Yisa die dɩ balɩ a yɩ kpɩkpaakʋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba dɩ; ");
INSERT INTO kma_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mɩraha dɩdagɩrɩba aŋaŋ Farasisi yine vuodiekemba ba yɩna sieŋ dɩ ba yiŋŋi balɩma Mosisi mɩraha chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Die chɩaŋ ma dɩ vɩɩna aŋ nɩ saagɩ ta dɩa ba dagɩna nɩ die mana, ama nɩ sɩmma nɩ keŋ yime wudieke ba yinene, dama ba ka dɩ wudieke ba balala wa. ");
INSERT INTO kma_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba ŋaaŋ vaa wa vuosi chii chiidʋnsa, chii dieke dɩ dʋnsɩna a yɩa ba, ama ba ka saaga a suŋŋe be aŋ ba chii chiititi. ");
INSERT INTO kma_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wudieke mana ba yinene, ba yie mɩŋ dɩ vuota ye be. Ye, ba nagɩna Ŋmɩŋ mɩraha dɩ maagɩna bɩta gbanbisi me a bɔbɩ yi ba die aŋaŋ ba nuusi me ta a faasɩ dala dala die; bɩ ye ba nyiŋyeeki wagɩtɩ kʋaŋ nʋa dɩ wagɩrɩna ta faasɩ teeli die. ");
INSERT INTO kma_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Dɩɩ yi ba dʋʋga jige ba ŋaaŋ yaala ba kala sikpeŋkpɩɩma tieliŋ jigikasɩka; ta ba keŋ ga Ŋmɩŋ jɩamɩŋ juone jigiŋ, ba ŋaaŋ yaala ba kala vuokpɩɩma jigikasɩka; ");
INSERT INTO kma_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ta bɩ yaala ba waasɩma ba aŋaŋ jɩlɩma nyʋgɩtɩ jige ta wasɩma ba ‘Dɩdagɩrʋ.’ ");
INSERT INTO kma_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama nɩnɩŋ nɩŋ da keŋ yi ba wasɩma nɩ ‘Dɩdagɩrʋ’ dama nɩ mana yiwo nɩmballɩ aŋaŋ taŋ ta yaa nɩ Dɩdagɩrʋ balɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ta nɩ daa keŋ wa vuoŋ tɩŋgbaŋka gie me ‘Chɔɔŋ’ dama nɩ yaa wa Chɔɔŋ balɩmɩŋ; wʋnɩŋ ʋ yiwo Ŋmɩŋ dieke dɩ benne arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɩ daa bɩ vaa vuosi wa nɩ ba ‘Nɩŋŋandɩɩsɩrɩba’ dama nɩ yaa wa nɩ Nɩŋŋandɩɩsɩrɩ balɩmɩŋ wʋnɩŋ ʋ yine Yisa Masia. ");
INSERT INTO kma_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Vuodieke dɩ yine vuokpɩɩŋ nɩ sʋŋ ʋ yi ʋ gbaŋ nɩ tʋntʋntʋ. ");
INSERT INTO kma_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ama vuodieke dɩ kɔtɩna ʋ gbaŋ ŋmɩŋsikpeŋ, Ŋmɩŋ nan dansɩ sʋʋŋ wa tɩŋgbaŋ; ama vuodieke dɩ sʋʋna ʋ gbaŋ tɩŋgbaŋ Ŋmɩŋ nan daansɩ kɔtɩ wa ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ta Yisa dɩ bɩ balɩ dɩ, “Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba yine gɩgaantɩba dɩ nan dɩ bɩaŋ a yɩ nɩ, dama nɩnɩŋ nɩ ligi wo Ŋmɩŋ naarɩ sanʋarɩ dɩ vuosi daa juu. Nɩ gbaŋ ka baa nɩ juu, ama ta kaga vuodiekemba dɩ yaalala ba juu wo. ");
INSERT INTO kma_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","((Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba yine gɩgaantɩba, wʋbɩaŋ bie nɩ ma, dama nɩ gbata kpihɔgʋba tige, ta jʋʋsa Ŋmɩŋ a yʋasa ta gaama sɩba nɩ yiwo vuodiekemba dɩ chɩgɩnana Ŋmɩŋ. Die wɩa nɩ tɩbɩdatɩŋ nan dɩ faasɩ dala pam.)) ");
INSERT INTO kma_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba yine gɩgaantɩba, wʋbɩaŋ bie nɩ ma, dama nɩ gasa mʋgɩkpɩɩma ta chʋŋ gara tɩŋgbaŋɩsɩ ta yaala vuodieke dɩ baaŋ nan tarɩgɩ ʋ beriŋ a dɩa nɩ kʋaŋ, dɩɩ yi nɩ keŋ ye vuoŋ, nɩ ŋaaŋ yiwo ʋ tʋmbɩatɩ dieke dɩ yalla wa a gara Sitaani boliŋ me bɩ gʋtɩ die bule sɩba nɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nɩnɩŋ yɩɩsɩ dɩdatɩrɩŋ, wʋbɩaŋ bie nɩ ma! Nɩ daga vuosi dɩ, ‘Dɩɩ yi ta vuoŋ dɩ huu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ, dɩ ka yi nɩŋŋmɩna, ama dɩɩ yi ʋ keŋ huu ligire dieke dɩ benne juoku me wo sie ʋ yi dene.’ ");
INSERT INTO kma_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nɩnɩŋ yɩɩsɩ aŋaŋ gaantɩŋ, nyinti ale wo gie a jabɩa yine nɩŋŋmɩna, ligirehe yaa Ŋmɩŋ juokpeŋkpɩɩkʋ die dɩ yine ligirehe dɩ yi Ŋmɩŋ sɩɩtɩ? ");
INSERT INTO kma_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta nɩ bɩ daga dɩ, ‘Dɩɩ yi vuoŋ dɩ huu kaabɩŋ koriŋ, ka ka yi nɩŋŋmɩna, ama ʋ keŋ huu kaabɩŋ dɔŋ dɩ diisine koriku me wo, sie ʋ yi dene gbaŋ gbaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nɩ seŋ yiwo yɩɩsɩ wusie. Nyinti ale wa a jabɩa yine nɩŋŋmɩna, kaabɩŋ dɔŋkʋ yaa koriku dɩ yine kaabɩkʋ dɔnka die dɩ yi Ŋmɩŋ sɩɩtɩ? ");
INSERT INTO kma_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Die wɩa dɩɩ yi ta vuoŋ dɩ huu kaabɩkʋ koriku, dɩ dagɩ sɩba ʋ huu kanɩŋ aŋaŋ jadieke mana dɩ diisine ka ma. ");
INSERT INTO kma_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta dɩɩ yi vuoŋ dɩ huu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ, dɩ dagɩya sɩba ʋ huu kanɩŋ aŋaŋ Ŋmɩŋ, vuodieke dɩ benne ka ma. ");
INSERT INTO kma_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dɩɩ bɩ yi vuoŋ dɩ huu arɩzanna, ʋ huu wa Ŋmɩŋ naarɩ gbaŋtɩtɩ aŋaŋ vuodieke dɩ kalala ka ma. ");
INSERT INTO kma_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba die yine gɩgaantɩŋ, wʋbɩaŋ bie nɩ ma. Nɩ naga nanjʋʋsɩ aŋaŋ bʋŋʋ aŋaŋ neeri aŋaŋ nyinti a taŋ baŋ sʋŋ a nagɩ kaanɩ a yɩa Ŋmɩŋ, ama ta va jadieke dɩ yine nɩŋŋmɩna ʋ mɩraha ma; sɩba wusie sarɩya diile, aŋaŋ zɔɔlɩŋ chɩgɩla aŋaŋ yada yiile. Genhe die mʋna nɩ yime, ta da va hanɩŋ ba yiile. ");
INSERT INTO kma_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nɩnɩŋ yɩɩsɩ diekemba dɩ datɩnana nɩ chanchaalɩŋ naa, nɩ ŋaaŋ vʋara nanjʋʋŋ nyaaŋ ma a taaŋ ama ta nyɩa nyɔgɩnɩ aŋaŋ nyaabʋ! ");
INSERT INTO kma_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba nɩ yiwo gɩgaantɩŋ, wʋbɩaŋ bie nɩ ma, dama nɩ daaraa nɩ nyanyuuli kpala aŋaŋ nɩ tɩmbala kʋasɩ, ama a sʋgɩtɩ dɩ suuli aŋaŋ gbatɩŋ aŋaŋ halɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nɩnɩŋ Farasisi mba yine yɩɩsɩ, nɩ woliŋ a daarɩ nɩ nyanyuuli kpalaha aŋaŋ nɩ tɩmbalaha sʋgɩtɩ, ta a kʋasɩ dɩaŋ nan daarɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba nɩ yiwo gɩgaantɩŋ, wʋbɩaŋ bie nɩ ma. Dama nɩ sɩɩ sɩba vɔrɩtɩ dieke ba mɩɩ a penti zie, ta a kʋasɩ dɩ vɩɩna ama ta a sʋgɩtɩ dɩ suuli aŋaŋ vuota kɔba aŋaŋ nyʋʋgɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Die gbaŋ gbaŋ ta vuosi yese nɩ yeŋ me ta nɩ vɩɩna, ama nɩ sʋgɩtɩ dɩ suuli aŋaŋ ŋmɩnchɩbɩsɩ aŋaŋ bɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nɩnɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi mba nɩ yiwo gɩgaantɩŋ, wʋbɩaŋ bie nɩ ma. Nɩ mɩa Ŋmɩŋ naazʋalɩba vɔrɩtɩ, ta penti zieŋ, ta yi jadieke dɩ baaŋ nan tɩɩnsɩ vuosi yaa gamma vuodiekemba die dɩ chɩgɩnana Ŋmɩŋ kuŋ wɩa, ");
INSERT INTO kma_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ta baarɩ dɩ, die tɩ tɩŋ beri tɩ chɔɔŋkʋʋlɩŋ saŋka, tɩ tɩŋ kaaŋ yi wudieke ba yine wo ta kʋʋ Ŋmɩŋ naazʋalɩba. ");
INSERT INTO kma_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Die wɩa nɩ seŋ a saagɩ mɩŋ dɩ nɩ yine vuodiekemba die dɩ kʋna Ŋmɩŋ naazʋalɩba wo haagɩsɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Die wɩa nɩ chɔɔŋkʋʋlɩba die dɩ piiline a yie tʋmbɩatɩ die wo, nɩ yi he a kpatɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nɩnɩŋ nyinvuuke aŋaŋ nyinvuuke ballɩ. Nɩ baa nɩ yiwo lalɩa a chɩgɩ nyɩŋ tɩbɩdatɩŋ boli dieke dɩ wone kpisiŋ sʋŋ? ");
INSERT INTO kma_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Die wɩa n bala nɩ dɩ, n nan tʋŋ Ŋmɩŋ naazʋalɩŋ aŋaŋ sɩsɩbɩrɩŋ aŋaŋ dɩdagɩrɩŋ nɩ jigiŋ, ama nɩ nan kʋʋ bataŋ, ta kpaasɩ bataŋ a diisi dagarɩkɩŋ ma aŋ ba kpi, ta nɩgɩ bataŋ Ŋmɩŋ jɩamɩŋ juone me ta dɩ ba nagɩsɩ a nyɩŋ tɩŋ kaanɩ a ga tɩŋ kaanɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Naa chɩaŋ ba kʋna vuodiekemba dɩ chɩgɩnana Ŋmɩŋ tɩbɩdatɩŋ nan keŋ nɩ ma, a nyɩŋ Abeli a tʋgɩ Berakia bʋa Zakaria ma, vuodieke die nɩ kʋna Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ aŋaŋ kaabɩŋ koriku sʋnsʋkʋ. ");
INSERT INTO kma_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wusie maŋ bala nɩ, lele gie vuosi nan daansɩ ye tɩbɩdatɩŋ tʋmbɩatɩ gie mana wɩa. ");
INSERT INTO kma_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Nchʋanaawee, Jerusalemi vuosi, nɩnɩŋ vuodiekemba dɩ kʋna Ŋmɩŋ naazʋalɩba, ta bɩ taa vuodiekemba ʋ tʋnna nɩ jigiŋ wo tana, bʋŋmɩa maŋ mɩa, a yaala dɩ n lagɩsɩ nɩ bʋnyɩ sɩba kpɩanɩɩŋ dɩ ŋaana lagɩsɩ ka ballɩ ka chobiti chɩaŋ ta nɩ ka saaga. ");
INSERT INTO kma_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ye, Ŋmɩŋ va nɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ta ka zie yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N bala nɩ, a nyɩŋ jinne yaa gamma, nɩ kaaŋ bɩ ye mɩŋ bɩbra a ga tʋgɩ saŋŋa dieke nɩ baaŋ nan balɩ dɩ, ‘Ŋmɩŋ alibarika bie vuodieke dɩ kennene tɩ Yɔmʋtieŋ saaŋ ma.’ ” ");
INSERT INTO kma_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisa die dɩ nyɩŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ jigiŋ a chʋŋ gara, die ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a balɩ wa, ye Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ dɩ vɩɩna die. ");
INSERT INTO kma_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Die ʋ pɩasɩ ba dɩ, “Nɩ ye nyinti gie mana mɩŋ? Wusie maŋ bala nɩ, ba nan kpaŋŋɩ a mana a taaŋ tɩŋgbaŋ ma, ta taŋ balɩmɩŋ gbaŋ kaaŋ wɩarɩ a sʋgɩ ka chanchaaŋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisa die dɩ sʋʋna a kalɩ kunkogiŋ dieke ba wasɩnana Olivi Tɩɩsɩ kunkogiŋ sikpeŋ die ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ ba nyɩɩna a pɩasɩ wa, “Balɩ tɩ saŋŋa dieke genhe mana dɩ bala a yi aŋaŋ wudieke dɩ bala ka yi a dagɩ sɩba fʋ kieŋku aŋaŋ dʋnɩa kpatɩŋ gbigiye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Die ʋ yiŋŋi a balɩ ba, “Nɩ sɩmma aŋ vuoŋ da keŋ gaaŋ nɩ, ");
INSERT INTO kma_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","dama vuosi pam nan nagɩ n saaŋ a keŋ a baarɩ banɩŋ ba yine manɩŋ Masia wa ta gaaŋ vuosi pam. ");
INSERT INTO kma_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɩ nan wʋŋ tɔntɩ watɩ nɩ chaaŋ aŋaŋ saasaa wɩa, ama nɩ da vaa ŋmaamɩŋ yalla nɩ, dama sie wɩaha gie yi, ama a ka dagɩ sɩba dʋnɩa kpatɩkʋ keŋye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vuosi buuriŋ nan wagɩ taŋ, naalɩŋ nan wagɩ naalɩŋ. Kɔŋ aŋaŋ tɩŋgbaŋ dɔmɩŋ nan dɩ bie jigiŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wɩaha gie mana nan dɩ sɩɩ sɩba maarɩŋ yʋagɩŋ piiliŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Saŋka mi ba nan yigi nɩ a nagɩ nɩ yɩ aŋ ba vaa nɩ dii wahala, ta kʋʋ nɩ. Tɩŋgbaŋɩsɩ mana nan dɩ haa nɩ dama nɩ dɩna n kʋaŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Saŋka mi vuosi pam nan zeti n kʋaŋ dɩɩsɩŋ, ba nan posi tamba chɩasɩ ta haa tamba. ");
INSERT INTO kma_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta ŋmɩnchɩbɩsɩ naazʋalɩba nan keŋ a gaaŋ vuosi pam. ");
INSERT INTO kma_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bɩaŋ dɩ bala ka dalɩma tɩŋgbaŋka gie wɩa, ta vuosi pam choti nan dɩ sʋnsɩ. ");
INSERT INTO kma_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama vuodieke nɩŋ mana dɩ dine sikimiŋ a ga tʋgɩ wahalaka gie kpatɩŋ nan ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta ba nan mʋʋlɩ Ŋmɩŋ naarɩ wʋvɩɩnaha gie dʋnɩa ka gie mana mana ma, dɩ vuoŋ mana wʋŋ, ta dʋnɩa ka kpatɩŋ ye keŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nɩ nan ye ‘Jachʋʋsɩ’ dieke ta Ŋmɩŋ naazʋa Danieli die dɩ balla ka wɩa wa dɩ, genke Ŋmɩŋ dɩ chʋarɩŋ, ka nan dɩ zie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ.” (Vuodieke mana dɩ a keŋ a karɩŋ wɩaha gie, ʋ sɩmma a chɩasɩ.) ");
INSERT INTO kma_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Saŋka mi vuodiekemba dɩ benne Judia ma ma wa, chɩgɩ a ga jʋalɩ tana sikpeŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ta vuodieke dɩaŋ dɩ keŋ bie ʋ mampili sikpeŋ da keŋ sʋʋŋ tɩŋgbaŋ dɩ ʋ juu juoku a nagɩ ʋ nyinti. ");
INSERT INTO kma_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta vuodieke dɩaŋ dɩ keŋ bie ʋ kʋaŋ ma, ʋ da keŋ kuli dɩ ʋ nagɩ ʋ jayeekiŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Saŋka mi hɔgʋ nyuutitieliŋ aŋaŋ vuodieke dɩ yalla ballɩnyaalɩsɩ nan dii wahala pam! ");
INSERT INTO kma_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nɩ jʋʋsɩma Ŋmɩŋ aŋ ʋ da keŋ yi wahalaha keŋ yɩbɩŋ saŋŋa yaa davʋʋsɩkɩrɩ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dama saŋka mi wo, wahala pam nan dɩ beri; Ŋmɩŋ die dɩ naanna dʋnɩa a keŋ tʋgɩ jinne, kanɩŋ wahalaka mi ye ka keŋye; ta kanɩŋ wahalaka mi kaaŋ bɩ keŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ŋmɩŋ dɩ tɩŋ ka gobi daraaha a taaŋ vuoŋ tɩŋ kaaŋ ye gbatɩtaanɩŋ; ama ʋ vuovʋarɩkaha wɩa ta ʋ nan gobi daraaha a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Saŋka mi dɩɩ yi vuoŋ dɩ a keŋ a balɩ nɩ dɩ, ‘Nɩ ye, Masia wa wʋnna yaa ʋ benne mi wo’, nɩ daa keŋ yi wo yada; ");
INSERT INTO kma_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","dama saŋka mi ŋmɩnchɩbɩsɩ Masiasi aŋaŋ ŋmɩnchɩbɩsɩ naazʋalɩba nan keŋ nyɩŋ a tʋŋ mamachi wɩa dɩ ba gaaŋ vuodiekemba Ŋmɩŋ dɩ vʋarɩna wa gbaŋ, ba tɩŋ nan bɩagɩ. ");
INSERT INTO kma_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nɩ wʋmma! N wɔŋ balɩ nɩ mɩŋ ta saŋka ye ka tʋgɩya. ");
INSERT INTO kma_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Die wɩa, ba keŋ balɩ nɩ, ‘Ye, ʋ bie wo haagɩŋ ma!’ Nɩ da keŋ ga mi yaa ba keŋ a balɩ nɩ, ‘Ye, ʋ bie wo juoku me!’ Nɩ da keŋ yi yada; ");
INSERT INTO kma_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","dama manɩŋ vuota Bʋa keniŋ nan dɩ sɩɩ sɩba nɩɩŋ dɩ ŋaana nyɩgɩsɩ a nyɩŋ ŋmɩŋ pɔsɩŋ a ga tʋgɩ ŋmɩŋ nanɩŋ chaakʋ die wo. ");
INSERT INTO kma_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Jigidieke jakpiikiŋ nyʋʋgɩŋ dɩ benne, mi zuuti dɩ lagɩma. ");
INSERT INTO kma_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wahalaha mi kʋaŋ chaaŋ ta ŋmɩŋ nan sɩbɩ, chɩɩkʋ kaaŋ bɩ chaaŋ; ta chɩŋmarɩsɩsɩ nan nyɩŋ ŋmɩŋsikpeŋ a nan ta nyindieke dɩ benne ŋmɩŋsikpeŋ nan dɔŋ a lagɩŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Saŋka mi ta vuosi nan ye manɩŋ vuota Bʋa wa yiŋŋi kieŋku siara ŋmɩŋsikpeŋ, buuri dieke mana dɩ benne tɩŋgbaŋka gie me nan kʋŋ, ta ye manɩŋ vuota Bʋa dɩ benne nɩɩŋmara ma ŋmɩŋsikpeŋ a keŋ sʋʋna aŋaŋ yiko chuulikpeŋkpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Malaka nan wɩɩ wɩɩŋ, ta n tʋŋ n malakasisi aŋ ba ga dʋnɩa lʋga a nɩɩsa mana mana a lagɩsɩ n vuovʋarɩkaha dieke dɩ benne tɩŋgbaŋka gie lʋga a nɩɩsa wa mana. ");
INSERT INTO kma_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nɩ vaa chunchule tɩɩka dagɩ nɩ yɩaŋ. Ka nagɩsɩ dɩ keŋ pɔsa ta vaatɩ dɩ nyɩnna nɩ sɩmma a baarɩ yɩbɩŋ gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nɩ bɩ a keŋ ye ta nyinti gie yie naa gbaŋ gbaŋ nɩ sɩmma a baarɩ n keniŋ gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wusie maŋ bala nɩ, lele vuosi kaaŋ kpi a kpatɩ ta wɩaha gie mana keŋ yi. ");
INSERT INTO kma_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋ nan keŋ a tɩaŋ ga, ama n wʋbalɩkaha kaaŋ tɩaŋ naa daa. ");
INSERT INTO kma_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ama vuoŋ ka sɩba daarɩ yaa saŋŋa dieke n baaŋ keŋ; malakasi dieke dɩ benne arɩzanna ma dɩaŋ ka sɩba, manɩŋ Ŋmɩŋ Bʋa gbaŋ ka sɩba, sie n Chʋa Ŋmɩŋ nyɩɩna sɩbɩna. ");
INSERT INTO kma_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Die dɩ sɩna die wo Nowa saŋka dɩ nan dɩ sɩɩ die manɩŋ vuota Bʋa wa keniŋ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa saŋŋa, saŋŋa dieke nyaakpɩɩbʋ dɩ yene ka keŋye, vuosi die dɩ die ta nyuo, ta faara hɔɔŋ, ta naga ba hɔgɩlɩasɩ a yɩa chʋllɩŋ, a ga tʋgɩ daa dieke Nowa dɩ june haarɩkpɩɩkʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta vuosi gie die ka sɩba wudieke dɩ yinene a tʋgɩ saŋŋa dieke nyaabʋ dɩ kenne dii ba mana. Die dɩ baa dɩ sɩmma saŋŋa dieke manɩŋ vuota Bʋa wa dɩ bala n keŋ wo. ");
INSERT INTO kma_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Saŋka mi dembisi bale nan dɩ tʋma kʋakʋ ma, ta n nan nagɩ wʋnyɩ ta va wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hɔɔŋ bale nan dɩ nʋma zaa nɩa ma, ta n nagɩ wʋnyɩ ta va wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Die wɩa nɩ gbara dama nɩ zɩ daa dieke manɩŋ nɩ Yɔmʋtieŋ dɩ bala n keŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ama nɩ sɩmma wɩɩrɩ gie chɩaŋ; dɩɩ yi ta tigiŋ tieŋ dɩ keŋ sɩba saŋŋa dieke gaarʋ dɩ bala ʋ keŋ yuŋ ʋ tigiŋ me, ʋ tɩŋ nan dɩ gbarɩ ta kaaŋ vaa ʋ wɩɩ ʋ tigiri a juu a gaarɩ. ");
INSERT INTO kma_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Die wɩa dɩ vɩɩna ta nɩ gbaŋ nɩ yi siri saŋŋa mana dama manɩŋ vuota Bʋa nan keŋ saŋŋa dieke nɩ kana ka yile dɩ n nan keŋ wo. ");
INSERT INTO kma_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yɔmʋ bɩa yine yɩantieŋ ta yie ʋ Yɔmʋtieŋ dɩ dagɩna dɩ ʋ yi wudieke? Wʋnɩŋ ʋ yine vuodieke ʋ Yɔmʋtieŋ dɩ nan vʋarɩ dɩ ʋ daansɩma ʋ yɔmʋ chanchaalɩba ta yɩma ba ba nyindiike saŋŋa dieke dɩ mʋna. ");
INSERT INTO kma_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dɩɩ yi ta ʋ Yɔmʋtieŋ dɩ keŋ tigiŋ ta ye wo ta ʋ tʋma die wo gbaŋ, sʋgɩfɩalɩŋ nan dɩ bie ʋ ma. ");
INSERT INTO kma_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Wusie maŋ bala nɩ, ʋ nan nagɩ wa a zieŋ dɩ ʋ daansɩma ʋ nyinti mana mana. ");
INSERT INTO kma_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama ʋ yi yɔmʋbɩaŋ, ʋ nan dɩ yile ʋ sʋŋ ma dɩ ʋ Yɔmʋtieŋ wo kaaŋ keŋ lagɩ lagɩ, ");
INSERT INTO kma_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ta piili a nɩga ʋ yɔmʋ chanchaalɩba ta wʋnɩŋ ʋ nan dɩ die ta nyuo aŋaŋ daanyuuriŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ʋ Yɔmʋtieŋ wo nan yiŋŋi keŋ daa dieke aŋaŋ saŋŋa dieke ʋ kana ka yile dɩ ʋ nan keŋ. ");
INSERT INTO kma_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ʋ keŋ keŋ, ʋ nan datɩ ʋ tɩbɩŋ ta nagɩ wa a gʋtɩ gɩgaantɩba ma; mi ʋ nan dɩ kʋma ta ŋɔba nyɩna. ");
INSERT INTO kma_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ŋmɩŋ naarɩ wɩa nan dɩ sɩɩ sɩba hɔgʋlɩaŋ baŋ dieke die dɩ nagɩna ba popolisi a ga dɩ ba ga tuoli hɔgʋ faarɩtʋ die wo. ");
INSERT INTO kma_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hɔgʋlɩaŋ baŋ wa sʋŋ, banʋ die yiwo gaantɩŋ, ta banʋ wa dɩaŋ dɩ yi sɩsɩbɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gaantɩba die dɩ nagɩ ba popolisi ama ta die ka nagɩ kpaaŋ a gʋtɩ pɔgɩlɩ, ");
INSERT INTO kma_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ama ta sɩsɩbɩrɩba die dɩ nagɩ kpaaŋ a siti siti a yi kɔlɩbɩsɩ ma a gʋtɩ pɔgɩlɩ aŋaŋ popolisi. ");
INSERT INTO kma_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Die hɔgʋ faarɩtʋ wa die dɩ yʋasɩ keniŋ, die gbieŋ die dɩ yigi be, ba mana die dɩ gʋʋrɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ta die tanseese die ba wʋŋ kuli; ‘Hɔgʋ faarɩtʋ wa wʋnna! Nɩ keŋ nyɩŋ a tuoli wo!’ ");
INSERT INTO kma_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Saŋka mi hɔgʋlɩaba baŋka mana die dɩ hagɩ a ŋmɩɩlɩ ba popoli dɩ jʋalɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Die hɔgʋlɩa gaantɩba die dɩ jʋʋsɩ sɩsɩbɩrɩba dɩ, ‘Nɩ kaaŋ yɩ tɩ nɩ kpaabʋ bɩta? Dama tɩ popolisi yaala a kpi mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ta sɩsɩbɩrɩba die dɩ yiŋŋi balɩ ba dɩ, ‘Aayɩ, bʋ kaaŋ tʋgɩ tɩnɩŋ aŋaŋ nɩ mana. Nɩ gamma vuodiekemba dɩ yalla daa wa jigiŋ a daa bʋtaŋ yɩ nɩ gbaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Saŋŋa dieke hɔgʋlɩa gaantɩba dɩ benne sieŋ me a gara dɩ ba daa kpaabʋ, ta hɔgʋ faarɩtʋ wa dɩ keŋ nyɩŋ. Sɩsɩbɩrɩba banʋ wa die dɩ yine siri wo die dɩ dɩ hɔgʋ faarɩtʋ wa a ga juu tigidieke banwʋlaka die dɩ benne, ta die ba ligi sanʋarɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ka kʋaŋ chaaŋ hɔgʋlɩa gaantɩba die dɩ a keŋ tʋgɩ, a zie sanʋarɩ jigiŋ a wasa, ‘Tɩ Yɔmʋtieŋ, tɩ Yɔmʋtieŋ, yuori sanʋarɩ a yɩ tɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ama ta hɔgʋ faarɩtʋ wa dɩ yiŋŋi balɩ ba dɩ, ‘Wusie maŋ bala nɩ, n ka sɩba nɩ.’ ” ");
INSERT INTO kma_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Die Yisa dɩ bɩ balɩ ba dɩ, “Die wɩa, nɩ sɩmma, dama nɩ ka sɩba daa dieke yaa saŋŋa dieke manɩŋ nɩ Yɔmʋtieŋ dɩ bala n keŋ. ");
INSERT INTO kma_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ŋmɩŋ naarɩ wɩa nan bɩ sɩɩ sɩba tigiŋ tieŋ wʋnyɩ die dɩ bala ʋ dɩa, ta wa ʋ yɔŋɩsɩ a tɩa ba ligire dɩ ba tuo a dime nyʋʋŋ. ");
INSERT INTO kma_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Die ʋ yɩ ba wʋnyɩ mana ʋ sɩbɩna ʋ kpaŋŋɩnana ʋ gbaŋ dene; die ʋ nagɩ salɩma ligiribie tuse tuse anʋ a yɩ wʋnyɩ, ta die a nagɩ tuse tuse ale a yɩ wʋnyɩ dɩaŋ, ta die a bɩ a nagɩ tusibalɩmɩŋ a yɩ wʋnyɩ dɩaŋ. Ta die a nyɩŋ a ga ʋ dɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Die yɔmʋ dieke die dɩ tuone tuse anʋ wa die dɩ nyɩŋ lagɩ lagɩ a nagɩ ligirehe a tʋŋ tʋʋma a bɩ a ye tuse anʋ gbaŋ gbaŋ a gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Vuodieke die dɩ tuone tuse ale wo gbaŋ die dɩ nagɩha a tʋŋ tʋʋma a ye tuse ale a gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama yɔmʋ dieke die dɩ tuone tusibalɩŋka die dɩ ga a tuu vɔrɩŋ a nagɩ ʋ Yɔmʋtieŋ ligirehe a lɔbɩrɩ mi. ");
INSERT INTO kma_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Die dɩ wana a yʋasɩ pam, tigiri tieŋ wo die dɩ yiŋŋi a keŋ, ta wa ʋ yɔŋɩsɩ dɩ ba keŋ aŋ ʋ biisi, ta ʋ ye ba yene nyʋarɩ a mʋ die. ");
INSERT INTO kma_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ta vuodieke die dɩ tuone tuse anʋ wa die dɩ a keŋ a juu saŋka mi, a nagɩ tuse anʋ dieke ʋ bɩna a ye wo, ta baarɩ, ‘N Yɔmʋtieŋ, die yɩ mɩŋ wa salɩma ligiribie tuse anʋ, ama n bɩ ye wo nyʋarɩ tuse anʋ a gʋtɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Die ʋ Yɔmʋtieŋ dɩ balɩ wa, ‘Kpaŋŋɩ fʋ gbaŋ, fʋnɩŋ yiwo yɔmʋvɩɩnɩŋ, ta bɩ tʋma vɩɩnɩŋ; mɩŋŋɩ pɔgɩlɩ wa nyinti bɩta wa gie, die wɩa n nan nagɩ pam a yi fʋ nuusi me. Sʋgɩfɩalɩ dieke n yalla, yiwo manɩŋ aŋaŋ fʋ sɩɩtɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ta die vuodieke dɩaŋ die dɩ tuone tuse ale wo die dɩ keŋ a juu a baarɩ, ‘N Yɔmʋtieŋ, ye, die fʋ yɩ mɩŋ wa salɩma ligire bie tuse ale, ama n dii wo nyʋʋŋ a ye nyʋarɩ tuse ale a gʋtɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ʋ Yɔmʋtieŋ wo dɩ balɩ wa, ‘Kpaŋŋɩ fʋ gbaŋ, fʋ yiwo yɔmʋvɩɩnɩŋ ta bɩ tʋma vɩɩnɩŋ, mɩŋŋɩ pɔgɩlɩ wa nyinti bɩta wa gie, die wɩa n nan nagɩ pam a yi fʋ nuusi me. Sʋgɩfɩalɩ dieke n yalla, yiwo manɩŋ aŋaŋ fʋ sɩɩtɩ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Die yɔmʋ dieke dɩaŋ dɩ tuone tusibalɩŋka die dɩ keŋ a juu a baarɩ, ‘N Yɔmʋtieŋ, n sɩba dɩ fʋnɩŋ yiwo nyɩnyɩrɩtʋ, a gobe jigidieke fʋ kana a ka bʋrɩya, ta bɩ lagɩsa nyindiike jigidieke die fʋ kana a ka jatɩ nyɩŋbʋra. ");
INSERT INTO kma_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Die wɩa ŋmaamɩŋ die yalla mɩŋ die maŋ nyɩŋ a nagɩ fʋ ligirebu a lɔbɩrɩ tɩŋgbaŋ. Die wɩa, ka wʋnna, tuo fʋ jaaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Die wɩa ʋ Yɔmʋtieŋ wo die dɩ yiŋŋi a balɩ wa dɩ, ‘Fʋnɩŋ yɔmʋtɔgʋ aŋaŋ walɩnkpɩatieŋ; sɩba baarɩ n yiwo vuodieke dɩ gobinene jigidieke n kana ka bʋrɩya ta lagɩsa nyindiike jigidieke n kana ka jatɩ nyɩŋbʋra, ");
INSERT INTO kma_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","die nɩŋ bɩa yine ta fʋ ka nagɩ n ligirebu a paŋŋɩ aŋ ba yiŋŋi tuŋ mɩŋ aŋaŋ nyʋarɩ? N tɩnna a keŋ naa wa n tɩŋ nan tuo n jaabʋ ta nyʋarɩ diisi ka ma. ");
INSERT INTO kma_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Die wɩa nɩ tuo ligirebu a nyɩŋ ʋ jigiŋ a nagɩ ka yɩ vuodieke dɩ yalla tuse baŋ wa. ");
INSERT INTO kma_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dama vuodieke mana dɩ yalla nyinti, ba nan ye nyinti pam a gʋtɩ amʋ ba faasɩ yallɩma pam. Ta vuodieke dɩaŋ dɩ wone jaaŋ ba nan tuo bɩta gbaŋ ʋ yalla wa a nyɩŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ama yɔmʋtɔgʋ wa nɩŋ, nɩ nagɩ wa a vigi taaŋ yeŋ me lɩmɩŋ ma, jigidieke ʋ baaŋ nan kʋŋ ta ŋɔba nyɩna.’ ");
INSERT INTO kma_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Manɩŋ vuota Bʋa dɩ keŋ keŋ aŋaŋ n hagɩrɩŋ aŋaŋ n malakasisi n nan dɩ kalɩ n naara gbanɩŋ ma aŋaŋ jɩlɩma pam. ");
INSERT INTO kma_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Saŋka mi dʋnɩa vuosi mana mana nan lagɩsɩ n nɩŋŋa, mi n nan puo be bule, sɩba yiyagɩrʋ dɩ ŋaana a puo yiise a nyɩŋ bie sʋŋ die wo. ");
INSERT INTO kma_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","N nan nagɩ yiisehe a zieŋ n nuudiigiŋ chaaŋ, ta nagɩ biehe a zieŋ n nuugalɩ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Saŋka mi manɩŋ naaŋ wa nan balɩ yɩ vuodiekemba dɩ benne n nuudiigiri chaakʋ dɩ, ‘Nɩnɩŋ vuodiekemba n Chʋa Ŋmɩŋ dɩ yine alibarika yɩ, nɩ keŋ a juu naarɩ dieke ta Ŋmɩŋ die dɩ naanna a gbarɩ nɩ a nyɩŋ dʋnɩa piiliŋ me, ");
INSERT INTO kma_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","dama kɔŋ die yalla mɩŋ die nɩ yɩ mɩŋ nyindiike; ta nyanyuule die dɩ yalla mɩŋ, die nɩ yɩ mɩŋ nyaaŋ maŋ nyu. Die n yiwo chaanʋ ta nɩ mɩŋŋɩ a tuo mɩŋ nɩ tige me a yi mɩŋ chaantɩ. ");
INSERT INTO kma_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Die n chʋŋ wa yɔrɩ die nɩ yɩ mɩŋ garɩtɩ, ta die maŋ yʋagɩ ta nɩ suŋŋi mɩŋ, die maŋ juu dansarɩka sʋŋ ta nɩ keŋ kaagɩ mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Womi ŋmɩŋchɩgɩrɩba gie nan yiŋŋi a pɩasɩ mɩŋ dɩ, ‘Tɩ Yɔmʋtieŋ, saŋŋa bɩa die tɩ ye fʋ ta kɔŋ yallɩ fʋ ta tɩ yɩ fʋ nyindiike? Yaa saŋŋa bɩa die tɩ ye fʋ ta nyanyuule dɩ yallɩ fʋ ta tɩ yɩ fʋ nyaaŋ fʋ nyu? ");
INSERT INTO kma_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Saŋŋa bɩa die tɩ ye fʋ ta fʋ yi chaanʋ die tɩ tuo fʋ tɩ tige me a yi fʋ chaantɩ? Yaa saŋŋa bɩa die tɩ ye fʋ ta chʋŋ yɔrɩ ta tɩ yɩ fʋ garɩtɩ? ");
INSERT INTO kma_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Saŋŋa bɩa die tɩ ye fʋ ta yʋagɩ ta tɩ suŋŋi fʋ? Yaa fʋ benne dansarɩka sʋŋ tɩ keŋ kaagɩ fʋ?’ ");
INSERT INTO kma_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ta manɩŋ Naaŋ wa nan yiŋŋi balɩ ba dɩ, ‘Wusie maŋ bala nɩ, wudieke die nɩ yine a yɩ vuodieke dɩ yine zɔɔlɩntieŋ nɩ nɩmballɩ sʋnsʋŋ wʋnyɩ wa die nɩ yi a yɩ wa manɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ka kʋaŋ chaaŋ n nan yiŋŋi a balɩ a yɩ vuodiekemba dɩ benne n nuugalɩ ka chaakʋ, ‘Nɩnɩŋ vuobɩatɩ gie, nɩ vɩɩna aŋaŋ tɩbɩdatɩŋ, nɩ chʋnna ga ta va mɩŋ. Nɩ gamma a ga juu boli dieke dɩ kana a ka kpise ta Ŋmɩŋ dɩ wʋnsɩna a gbarɩ Sitaani aŋaŋ ʋ vuosi wo. ");
INSERT INTO kma_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dama kɔŋ die yallɩ mɩŋ ta die nɩ mʋŋ mɩŋ nyindiike, ta nyanyuule die dɩ yallɩ mɩŋ ama die nɩ mʋŋ mɩŋ nyaaŋ. ");
INSERT INTO kma_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Die n yine chaanʋ, ta nɩ ka saagɩ a tuo mɩŋ nɩ tige me, ta die maŋ chʋŋ yɔrɩ ta nɩ mʋŋ mɩŋ garɩtɩ, ta die yʋagɩ ta nɩ ka suŋŋi mɩŋ, die maŋ juu dansarɩka ta nɩ ka keŋ kaagɩ mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Saŋka mi ba nan yiŋŋi a pɩasɩ mɩŋ dɩ, ‘Tɩ Yɔmʋtieŋ, saŋŋa bɩa die tɩ ye fʋ ta kɔŋ die dɩ yallɩ fʋ, yaa nyanyuule die dɩ yallɩ fʋ, yaa fʋ yi chaanʋ, yaa fʋ chʋŋ yɔrɩ, yaa fʋ yʋagɩ, yaa fʋ bie dansarɩka sʋŋ ta tɩ ka suŋŋi fʋ?’ ");
INSERT INTO kma_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Saŋka mi n nan yiŋŋi a balɩ ba dɩ, ‘Wusie n bala nɩ, die nɩ zetine nɩ suŋŋi zɔɔlɩntieŋ nɩ nɩmballɩ sʋnsʋŋ wʋnyɩ wa, die manɩŋ nɩ zeti suŋŋiŋ dene.’ ");
INSERT INTO kma_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Vuosi gie nan ga juu tɩbɩdatɩ dieke dɩ wone kpatɩŋ ma, ama ŋmɩŋchɩgɩrɩba nan ga juu miivoli dieke dɩ wone kpatɩŋ sʋŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisa die dɩ balla wɩaha gie mana a kpatɩ die ʋ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, ");
INSERT INTO kma_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nɩ sɩba a baarɩ dɩ vʋntʋŋ yine gasɩtɩaŋkʋ dʋʋga, ta ba nan nagɩ manɩŋ vuota Bʋa a yi vuosi nuusi me dɩ ba kpaasɩ mɩŋ a dɩɩsɩ dagarɩkʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Saŋka mi die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Juu vuosi nyɩŋkʋra die dɩ lagɩŋ taŋ Kayafasi tigiri me, vuodieke die dɩ yine Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ. ");
INSERT INTO kma_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Die ba saŋ ba baaŋ yi die a lɔbɩrɩ a yigi Yisa a kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Die ba baarɩ, “Tɩ ka mʋ tɩ yigi wo dʋʋgaka saŋŋa, tɩ yi die vuosisi nan yi watɩ aŋ waagɩŋ nan.” ");
INSERT INTO kma_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Die Yisa die benne Betani tɩka ma wa, Simoni vuodieke die dɩ yine gamɩŋ tigiŋ me wo, ");
INSERT INTO kma_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","die hɔgʋ wʋnyɩ dɩ keŋ ʋ jigiŋ a pɔgɩlɩ tulaari bʋnyɩ ligire dɩ faasɩna a tʋa a sitibu a yi Yisa sikpeŋ me saŋŋa dieke ʋ kala a die nyindiike. ");
INSERT INTO kma_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ yene naa, die ba jɩɩ sɩnyɩɩrɩŋ. Die ba pɩasa taŋ dɩ, “Bɩa ʋ chʋʋsa tulaaribu die? ");
INSERT INTO kma_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tulaaribu gie tɩŋ nan bɩagɩ daa ligirikpɩɩma a nagɩ ligirehe a suŋŋi zɔɔlɩntieliŋ!” ");
INSERT INTO kma_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisa die dɩ mɩŋŋɩ wudieke ba balala, ta balɩ a yɩ ba dɩ, “Bɩa nɩ mugise hɔgʋ wa gie dene? Wʋvɩɩnɩŋ ʋ yi a yɩ mɩŋ dene. ");
INSERT INTO kma_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Zɔɔlɩntieliŋ nɩŋ nan dɩ beri nɩ jigiŋ daaŋ mana ama manɩŋ n kaaŋ dɩ bie nɩ jigiŋ daaŋ mana. ");
INSERT INTO kma_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tulaari dieke ʋ sitine a yi n ma wa, ʋ yi a gbarɩ wa n guule. ");
INSERT INTO kma_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wusie maŋ bala nɩ, jigidieke mana ba bala ba mʋʋlɩ Ŋmɩŋ wɩaha gie tɩŋgbaŋka gie me, ba nan balɩ wudieke ʋ yine wo a tɩɩnsɩ ʋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Saŋka mi Yisa kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo wʋnyɩ, vuodieke die dɩ dine Judasi Asikaroti wa die dɩ nyɩŋ a ga Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha jigiŋ ");
INSERT INTO kma_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a baarɩ, “Bɩa nɩ nan yɩ mɩŋ dɩɩ yi maŋ dagɩ nɩ nɩ baaŋ nan yi die a yigi Yisa wa?” Die ba biisi salɩmayɩala ligiribie baŋɩsɩ-taa a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Die a nyɩŋ daarɩ mi Judasi die wa a paalɩ a yaala sievɩɩnɩŋ dɩ ʋ nagɩ Yisa a yi ba nuusi me. ");
INSERT INTO kma_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta paanʋ dieke die ba kana a ka yi dabɔtɩ dʋʋga piiliku daarɩ, ta Yisa kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a pɩasɩ wa, “Sɩa fʋ yaala tɩ ga wʋnsɩ a yɩ fʋ a gbara gasɩtɩaŋkʋ dʋʋga nyindiike daraaŋ?” ");
INSERT INTO kma_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Die ʋ yiŋŋi a balɩ ba dɩ, “Nɩ gamma tɩka sʋŋ daa wʋnyɩ tigiŋ a balɩ wa dɩ, ‘Tɩ dɩdagɩrʋ tʋnna tɩ dɩ tɩ keŋ balɩ fʋ dɩ ʋ saŋŋa gbigiye mɩŋ, ta ʋ yaala wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba dii gasɩtɩaŋkʋ dʋʋgaka nyindiikehe fʋ tigiŋ me.’ ” ");
INSERT INTO kma_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ dɩ ʋ bala ba die wo, ta wʋnsɩ gasɩtɩaŋkʋ dʋʋgaka diile siri. ");
INSERT INTO kma_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jɩŋmɩŋ die dɩ tʋgɩna, Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo die dɩ sʋʋŋ kalɩ dɩ ba dii. ");
INSERT INTO kma_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Die ba dinene wo Yisa die dɩ balɩ ba dɩ, “Wusie maŋ bala nɩ, nɩ wʋnyɩ bala ʋ posi n chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Die ʋ kʋaŋandɩɩsɩrɩba sʋgɩtɩ die dɩ paalɩ chʋʋsɩ, die ba piili a pɩasa wa wʋnyɩ wʋnyɩ, dɩ “N Yɔmʋtieŋ, wusie n ka yi tama dɩ manɩŋ fʋ daga die?” ");
INSERT INTO kma_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ʋ yiŋŋi a balɩ ba dɩ, “Vuodieke maŋ aŋaŋ wa dɩ lune kpalɩ gie mi wo bala ʋ posi n chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Manɩŋ vuota Bʋa nan kpi sɩba Ŋmɩŋ gbaŋkʋ die dɩ dagɩna die wo, ama wʋbɩaŋ bie vuodieke dɩ bala ʋ posi n chɩaŋ wa ma! Ba tɩŋ ka mɩɩrɩ dɩ tieŋ gbaŋ dɩ tɩŋ nan dɩ kpɩa.” ");
INSERT INTO kma_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Saŋka mi Judasi vuodieke die dɩ bala ʋ posi ʋ chɩaka gbaŋ dɩ baarɩ, “Dɩdagɩrʋ, manɩŋ fʋ daga?” Yisa die dɩ yiŋŋi a balɩ wa, “Wa, dɩ yiwo fʋnɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Die ba yene ko die, Yisa die dɩ nagɩ paanʋ, a waasɩ Ŋmɩŋ ta yi ke gbieri gbieri a nagɩha a yɩ ʋ kʋaŋandɩɩsɩrɩba, ta baarɩ, “Nɩ tuo a dii. N nyɩŋgbanɩŋ wʋnna.” ");
INSERT INTO kma_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ta die bɩ nagɩ nyaaŋchibiŋ aŋaŋ daaŋ, a pagɩ Ŋmɩŋ ta die a nagɩ ka a yɩ ba ta baarɩ, “Nɩ mana tuo a nyu. ");
INSERT INTO kma_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gembu yine n zɩŋ dieke dɩ bala ka yi Ŋmɩŋ nʋarɩ zie aŋaŋ wusie, zɩŋ dieke dɩ bala ka nyɩŋ n nyɩŋgbanɩŋ ma vuosi pam wɩa, aŋ ka vaa Ŋmɩŋ vaa a chaa ba tʋmbɩatɩ. ");
INSERT INTO kma_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N bala nɩ, n kaaŋ bɩ nyu daabʋ gie, sie daa dieke manɩŋ aŋaŋ nɩ dɩ bala tɩ lagɩsɩ a nyu daahaalɩbʋ n Chʋa Ŋmɩŋ naarɩ ma, ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Die ba wa chɩa Ŋmɩŋ jɩamɩŋ yɩlɩ, ka kʋaŋ chaaŋ ba chʋŋ ga Olivi Tɩɩsɩ kunkogiri me. ");
INSERT INTO kma_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Saŋka mi die Yisa dɩ balɩ a yɩ ba dɩ, “Yuku gie nɩ mana nan chɩgɩ ta va mɩŋ, dama dɩ maagɩya Ŋmɩŋ gbaŋkʋ ma dɩ ‘Ŋmɩŋ nan kʋʋ yiyagɩrʋ wa ta yiisehe ʋ yagɩnana wa jaasɩ jigiŋ mana.’ ");
INSERT INTO kma_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama maŋ a keŋ hagɩ kuŋ me, ka kʋaŋ chaaŋ n nan woliŋ nɩ nɩŋŋa a ga Galili tɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ta Piita die dɩ a yiŋŋi a balɩ wa dɩ, “Dɩɩ yi ta vuoŋ mana dɩ chɩgɩ ta va fʋ, ama manɩŋ n kaaŋ chɩgɩ ta va fʋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yisa die dɩ yiŋŋi a balɩ a yɩ wa dɩ, “Wusie maŋ bala fʋ, jinne yuku gie, kparaaŋ nan keŋ baa ka kʋmma, ta chiisi mɩŋ wo bʋtaa ma dɩ zɩ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piita die dɩ yiŋŋi a balɩ wa dɩ, “Dɩɩ yi maŋ ŋaŋ fʋ dɩ baa tɩ kpi gbaŋ, n kaaŋ chiisi dɩ n zɩ fʋ.” Die ʋ kʋaŋandɩɩsɩrɩba mana die dɩ balɩ die gbaŋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ ga jigidieke die ba wasɩnana Getisemani, die ʋ balɩ a yɩ ba dɩ, “Nɩ kala giena ta n ga nɩ nɩŋŋa a ga jʋʋsɩ Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta die nagɩ Piita aŋaŋ Zebedi ballɩ bale wo a gʋtɩ ʋ ma. Die ʋ sʋŋ die dɩ faasɩ a chʋʋsɩ, ");
INSERT INTO kma_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","die ʋ balɩ a yɩ ba, “Sʋgɩchʋʋsɩ dieke dɩ benne ʋ sʋŋ ma wa faasɩ dala mɩŋ a yaala ka kʋʋ mɩŋ. Nɩ kala gie ta yesime aŋaŋ manɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Die ʋ chʋŋ a ga nɩŋŋa bɩta, a gbirigi tɩŋgbaŋ ta jʋʋsɩ Ŋmɩŋ dɩ, “N Chʋa Ŋmɩŋ, dɩ tɩŋ nan bɩagɩ a yi, fʋ vʋarɩ mɩŋ a nyɩŋ wahalaka gie me! Ama daa vaa n dʋŋŋʋ yi, ama vaa fʋ dʋŋŋʋ yi.” ");
INSERT INTO kma_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Die ʋ yiŋŋi ga ʋ kʋaŋandɩɩsɩrɩba bataa wa jigiŋ ta ye ta ba gʋʋra; die ʋ pɩasɩ Piita, “Die wɩa nɩ kaaŋ bɩagɩ a yesime aŋaŋ mɩŋ saŋŋa bɩta gbaŋ? ");
INSERT INTO kma_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nɩ yesime ta jʋʋsɩma Ŋmɩŋ amʋ nɩ da keŋ juu magɩsɩŋ ma, dama nɩ haalɩtɩtɩ yaala a yi jadieke dɩ vɩɩna, ama nɩ nyɩŋgbaŋɩsɩsɩ ka hagɩrɩ.” ");
INSERT INTO kma_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Die ʋ bɩ yiŋŋi a ga ʋ bule ma a jʋʋsɩ Ŋmɩŋ dɩ, “N Chʋa Ŋmɩŋ, dɩɩ yi wahala dieke dɩ kienene naa dɩ kaaŋ bɩagɩ a tɩaŋ, sie n diike, fʋ vaa fʋ dʋŋŋʋ yi.” ");
INSERT INTO kma_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Die ʋ bɩ yiŋŋi keŋ, ta ʋ kʋaŋandɩɩsɩrɩba die bɩ gʋʋra dama gbieŋ die dɩ faasɩna yallɩ ba pam. ");
INSERT INTO kma_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Die ʋ bɩ va ba, ta ga a jʋʋsɩ Ŋmɩŋ bʋtaa ma a balɩ ʋ wolinne a jʋʋsa wudieke wo. ");
INSERT INTO kma_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Saŋka mi die ʋ yiŋŋi a ga ʋ kʋaŋandɩɩsɩrɩba jigiŋ a keŋ pɩasɩ ba dɩ, “Nɩ ye ko a gʋʋra ta voose mɩŋ? Nɩ ye, saŋka gbigiye mɩŋ. Ba nan nagɩ wa manɩŋ vuota Bʋa a yi vuobɩatɩ nuusi me. ");
INSERT INTO kma_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nɩ hagɩ aŋ tɩ ga. Nɩ ye, daa dieke dɩ posine n chɩaka gbigiye mɩŋ!” ");
INSERT INTO kma_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ʋ nʋaŋ die ye ka nan tɩŋgbaŋ, ta Judasi, ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo wʋnyɩ dɩ keŋ tʋgɩ mi, aŋaŋ kpɩkpaaŋ, bataŋ dɩ pɔgɩlɩ jɩbɩwagɩtɩ ta bataŋ dɩaŋ dɩ pɔgɩlɩ dengbile, die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Juu vuosi nyɩŋkʋraha tʋnna ba. ");
INSERT INTO kma_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasi vuodieke die dɩ posine ʋ chɩaka aŋaŋ vuosisi die wɔŋ balɩ zieŋ mɩŋ dɩ, “Maŋ keŋ a mʋgɩsɩ vuodieke kaamɩŋ, daa dieke nɩ yaalala wonde, nɩ yigi wo.” ");
INSERT INTO kma_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judasi die dɩ kenne tʋgɩ, ʋ ga Yisa nɩŋŋa a baarɩ, “Dɩdagɩrʋ, aŋ fʋ ŋmɩɩ”, ta mʋgɩsɩ ʋ kaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yisa die dɩ yiŋŋi a balɩ wa, “N zʋa, yi fʋ balla fʋ yi die wo lagɩ lagɩ!” Womi die ba a keŋ a mɩŋŋɩ yigi wo. ");
INSERT INTO kma_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Die ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ dɩ vʋarɩ jɩbɩwaŋ a chɩa gobi Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ yɔmʋ tɩbɩŋ a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Die Yisa die dɩ balɩ wa, “Nagɩ fʋ jɩbɩwaŋkʋ a yiŋŋi a sʋʋ ka fɔgʋ ma, dama vuodieke dɩ wagɩnana aŋaŋ jɩbɩŋ, ŋaaŋ kpi wo jɩbɩka kuŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nɩ ka sɩba a baarɩ n tɩŋ nan bɩagɩ a wa n Chʋa Ŋmɩŋ dɩ ʋ suŋŋi mɩŋ, aŋ bʋnyɩ ʋ tɩŋ nan tʋŋ malakasi a tɩaŋ tuse baŋ aŋaŋ ale? ");
INSERT INTO kma_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama maŋ yi die, lalɩa wudieke dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma wa dɩ naa nan yiwo, keŋ yi wusie?” ");
INSERT INTO kma_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Womi Yisa die dɩ pɩasɩ kpɩkpaakʋ dɩ, “Nɩ mʋ dɩ nɩ keŋ wo aŋaŋ jɩbɩwagɩtɩ aŋaŋ dengbile dɩ nɩ keŋ a yigi mɩŋ sɩba n yiwo gbɩgbatɩrʋ? Daaŋ mana die n bie wo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a daga ta nɩ ka yigi mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama naa mana yiye mɩŋ amʋ wudieke Ŋmɩŋ naazʋalɩba dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma wa keŋ yi wusie.” Die ʋ kʋaŋandɩɩsɩrɩba mana dɩ chɩgɩ ta va wa. ");
INSERT INTO kma_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Vuodiekemba die dɩ yigine Yisa wa die dɩ yallɩ wa a ga Kayafasi tigiŋ, vuodieke die dɩ yine Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ, mi die mɩraha dɩdagɩrɩba aŋaŋ tɩka nyɩŋkʋraha dɩ lagɩŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Die ba yalla Yisa a gara wa, die Piita dɩ dɩ ʋ kʋaŋ a bie saasaa, a ga tʋgɩ Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ gbaaŋ sʋŋ. Die ʋ juu gbaŋkʋ sʋŋ aŋaŋ tʋntʋntɩba dɩ ʋ ye wudieke dɩ balla ka yi. ");
INSERT INTO kma_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ nyɩŋkʋraha mana die dɩ yaala dɩ ba ye vuodieke dɩ baaŋ chɩbɩ ŋmɩnchɩbɩsɩ yaa gamma wudieke Yisa dɩ yine aŋ ba nagɩ a baarɩ dɩ ʋ chʋʋsɩya mɩŋ ta kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Daadaŋ pam die dɩ keŋ nɩŋŋa a chɩbɩ ŋmɩnchɩbɩsɩ a yɩ wa, ama die mana yɔrɩ, die ba ka ye wudieke ba baaŋ nan nagɩ a yigi wo. Ka kʋaŋ kʋaŋ chaaŋ die dembisi bale die dɩ keŋ nɩŋŋa a baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Daa wa gie die baarɩ dɩ ʋ nan bɩagɩ a kpaŋŋɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ a taaŋ ta yiŋŋi mɩɩ ka daraa ataa daraaŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Die Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ dɩ hagɩ zie a baarɩ, “Wo wɩɩŋ a baa fʋ balɩ yaa gamma wudieke ba balla yaa gamma fʋ wɩa naa?” ");
INSERT INTO kma_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama die Yisa dɩ tarɩ. Ta Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ dɩ bɩ pɩasɩ wa, “Balɩ tɩ miivolitieŋ Ŋmɩŋ saaŋ ma, fʋ yine Vuovʋarɩkɩŋ Masia wa ta bɩ yi Ŋmɩŋ Bʋadembike?” ");
INSERT INTO kma_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yisa die dɩ yiŋŋi a balɩ wa, “Wa, fʋnɩŋ fʋ balla. Ama n bala nɩ, a nyɩŋ jinne yaa gamma nɩ nan daansɩ ye manɩŋ vuota Bʋa ta n kalɩ Nabidie Ŋmɩŋ nuudiigiŋ chaaŋ, ta bɩ ye ta n bie nɩɩŋmara sʋŋ a keŋ sʋʋna.” ");
INSERT INTO kma_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Die Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ dɩ datɩ ʋ gbaŋ gbaŋ ʋ nyinyeeke a chɩɩrɩ ta natɩ dɩ, “Ʋ naga ʋ gbaŋ a magɩsa Ŋmɩŋ! Tɩ ka bɩ yaala daansɩa. Nɩ mana wɔŋ wʋŋ ʋ nagɩna ʋ gbaŋ a magɩsa Ŋmɩŋ die. ");
INSERT INTO kma_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lalɩa nɩ yile?” Die ba yiŋŋi a baarɩ, “Ʋ mʋ ʋ kpi mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Womi die ba piile a tɩɩra nɩntɔbɩtɩ a yie ʋ nine me, ta nɩgɩ wa; ta vuodiekemba die dɩ falala wa wa ");
INSERT INTO kma_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dɩ baarɩ, “Fʋnɩŋ Masia, bugi a dagɩ vuodieke dɩ nɩgɩna fʋ wa.” ");
INSERT INTO kma_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piita die dɩ kala Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ gbaakʋ ma wa, die tigiri mi havʋʋbiŋ tʋntʋntʋ wʋnyɩ die dɩ keŋ ʋ jigiŋ a keŋ balɩ dɩ, “Fʋ gbaŋ die gʋtɩ wa Yisa vuodieke dɩ nyɩnna Galili wo ma.” ");
INSERT INTO kma_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama ta Piita die dɩ baarɩ ʋ ka sɩba wa ba mana nɩŋŋa. Dɩ, “N ka sɩba vuodieke nɩ balala wa wɩa.” ");
INSERT INTO kma_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Die ʋ nyɩŋ ga yeŋ me, mi havʋʋbiŋ tʋntʋntʋ wʋnyɩ die dɩ bɩ ye wo a balɩ yɩ vuosisi dɩ, “Daa wa gie dɩaŋ die gʋtɩ wa Yisa vuodieke dɩ nyɩnna Nazeriti wa ma.” ");
INSERT INTO kma_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Die Piita die dɩ bɩ chiisike aŋaŋ huusi dɩ, “N ka sɩba daa wa!” ");
INSERT INTO kma_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Die dɩ bɩna a yi bɩta, vuodiekemba dɩ zene mi wo dɩ keŋ Piita jigiŋ a balɩ wa dɩ, “Wusie, yiwo ba wʋnyɩ dama fʋ bala sɩba Galili vuoŋ!” ");
INSERT INTO kma_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Womi Piita dɩ huu dɩ, “Ŋmɩŋ datɩ n tɩbɩŋ dɩɩ yi maŋ ka bala wusie! N ka sɩba daa wa mi!” Womi kparaaŋ die dɩ kʋŋ, ");
INSERT INTO kma_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","die Piita dɩ tɩɩnsɩ wudieke Yisa dɩ bala a yɩ wa wa dɩ, “Kparaaŋ nan keŋ baa ka kʋmma, nan chiisi mɩŋ bʋtaa dɩ ka sɩba mɩŋ.” Ta Piita die dɩ nyɩŋ a kʋŋ pam. ");
INSERT INTO kma_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Die tʋŋ dɩ vʋʋna sʋkʋleeliŋ, die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Juu vuosi nyɩŋkʋra die dɩ saŋ ba baaŋ yi die a kʋʋ Yisa. ");
INSERT INTO kma_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Die ba bɔbɩ wa aŋaŋ chɔrɩma, a nagɩ wa a ga tɩŋgbaŋka jakʋʋŋ die ba wasɩnana Paliti jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Die Judasi, vuodieke die dɩ posine Yisa chɩaka dɩ wʋnna ba dine ʋ sarɩya a baarɩ ʋ chʋʋsɩya amʋ ba kʋʋ wa wa, die ʋ sʋŋ dɩ faasɩ chʋʋsɩ; die ʋ wa nagɩ salɩnyɩala ligire bie baŋɩsɩ-taa wa a yaa a yiŋŋi ga yɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha. ");
INSERT INTO kma_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta baarɩ, “N tʋŋ wa bɩaŋ dama n posi wo vuodieke dɩ wone taalɩ chɩaŋ.” Die ba yiŋŋi a balɩ wa, “Tɩnɩŋ tɩ baga bɩ beri genke ma mɩŋ? Fʋnɩŋ fʋ wɩa wondie!” ");
INSERT INTO kma_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Die wɩa Judasi die dɩ nagɩ ligirehe a vigi taaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ, ta die a nyɩŋ a ga a taaŋ ʋ gbaŋ guuŋ. ");
INSERT INTO kma_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha die dɩ vaarɩ ligirehe ta baarɩ, “Gembu wa yiwo zɩŋ ligire, ta tɩ mɩraha ka yɩ sieŋ dɩ tɩ nagɩha a gʋtɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ligirehe sʋŋ.” ");
INSERT INTO kma_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Die wɩa die ba saŋ dɩ ba nagɩ ligirebu a daa kpagɩwʋnsɩrʋ tɩŋgbaŋ, dɩ ba gume chaanɩŋ mi. ");
INSERT INTO kma_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Die wɩa ba ye a wasa tɩŋgbaŋka mi dɩ “Zɩŋ tɩŋgbaŋ” a keŋ tʋgɩ jinne die. ");
INSERT INTO kma_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Die dɩ keŋ yi wusie Ŋmɩŋ naazʋa Jerimaya die dɩ balla wudieke wo dɩ, “Ba nagɩ wa salɩnyɩala ligire bie baŋɩsɩ-taa dieke die Izara vuosi bataŋ die dɩ nagɩna a daa wa, ");
INSERT INTO kma_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a nagɩbʋ a daa kpagɩwʋnsɩrʋ tɩŋgbaŋ, sɩba n Yɔmʋtieŋ Ŋmɩŋ dɩ dagɩna mɩŋ dene.” ");
INSERT INTO kma_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisa die zie wo tɩŋgbaŋka jakʋʋrɩ Paliti nɩŋŋa; ta Paliti die pɩasɩ wa dɩ, “Fʋnɩŋ, fʋ yine Juu vuosi naaŋ wa?” Yisa die dɩ yiŋŋi a balɩ, “Wa, fʋnɩŋ fʋ balala.” ");
INSERT INTO kma_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha nɩŋ die dɩ galɩnnana wa, die ʋ ka balɩ ba wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Die Paliti dɩ bɩ pɩasɩ wa dɩ, “Ka wʋmma ba galɩnnana fʋ die mana?” ");
INSERT INTO kma_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama Yisa die ka yiŋŋi a balɩ wa wɩɩŋ, die wɩa die dɩ paalɩ yi Paliti mamachi. ");
INSERT INTO kma_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dɩɩ yi gasɩtɩanɩŋ dʋʋga saŋŋa dɩ keŋ tʋgɩ tɩka jakʋʋrɩ ŋaaŋ vʋarɩ wa vuobalɩmɩŋ dansarɩka sʋŋ, vuodieke vuosisi dɩ yaalala a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Saŋka mi daa wʋnyɩ die benne dansarɩka sʋŋ ba wasa wa Barabasi, die vuoŋ mana die dɩ sɩba ʋ wɩa aŋaŋ ʋ tʋmbɩatɩ. ");
INSERT INTO kma_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Die wɩa die vuosisi die dɩ lagɩŋna wa, Paliti die dɩ pɩasɩ ba dɩ, “Mɩnɩa nɩ yaala n vʋarɩ dansarɩka ka sʋŋ a taaŋ a yɩ nɩ? Barabasi yaa Yisa, vuodieke dɩ dine Masia wa?” ");
INSERT INTO kma_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Dama Paliti die sɩba a baarɩ haasɩ wɩa die ba yigi Yisa a keŋ yɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Die Paliti die dɩ sʋʋna kala ʋ sarɩya diile chɩaka ma wa, die ʋ hɔgʋ die dɩ tʋŋ ʋ jigiŋ dɩ, “Vʋarɩ fʋ nuusi a nyɩŋ Ŋmɩŋ vuovɩɩŋka wɩa ma, dama diene wo yuku die n die wo wahala pam n daansa sʋŋ yaa gamma ʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ta Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha die dɩ bala a yɩa vuosisi dɩ ba balɩ Paliti dɩ ʋ vʋarɩ Barabasi a taaŋ ta vaa ba kʋʋ Yisa. ");
INSERT INTO kma_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ta Paliti die dɩ bɩ pɩasɩ dɩ, “Vuosi bale wo gie, mɩnɩa nɩ yaala n vʋarɩ a taaŋ?” Die ba yiŋŋi a baarɩ, “Barabasi.” ");
INSERT INTO kma_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta Paliti die dɩ bɩ pɩasɩ ba dɩ, “Lalɩa nɩ wa yaala n yi Yisa vuodieke ba wasɩnana Masia ka?” Ba mana die dɩ yiŋŋi a baarɩ, “Kpaasɩ wa diisi dagarɩkʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ama Paliti die dɩ yiŋŋi pɩasɩ ba dɩ, “Bɩa wʋbɩaŋ ʋ yi?” Die ba piili a faasɩ nata dɩ, “Kpaasɩ wa a diisi dagarɩkʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Die Paliti die dɩ mɩŋŋɩna dɩ dɩ ka bɩ amʋ dɩ ʋ balɩ wɩɩŋ dama ba nan yi watɩ ta waagɩŋ nan, die ʋ nagɩ nyaaŋ a nɩɩtɩ ʋ nuusi vuosisi nɩŋŋa ta baarɩ dɩ, “N nuuŋ wo daa wa gie kumbu me! Nɩ wɩɩŋ wonde.” ");
INSERT INTO kma_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta vuosi mana dɩ yiŋŋi a balɩ wa, “Wa, vaa ʋ zɩŋ bemme tɩnɩŋ aŋaŋ tɩ ballɩ ma!” ");
INSERT INTO kma_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Die wɩa Paliti die dɩ vʋarɩ Barabasi a taaŋ a yɩ ba, ta die a yi ba nɩgɩ Yisa aŋaŋ kpaasɩŋ ta nagɩ wa yɩ dɩ ba ga kpaasɩ wa dagarɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Die Paliti sojasisi die nagɩ Yisa a ga juu gbaakʋ sʋŋ ta sojasisi mana dɩ giliŋ wo. ");
INSERT INTO kma_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Die ba yi ʋ nyiŋyeekehe awʋrɩ ta die a nagɩ jayeekiwaŋ ŋmɩnɩŋ a yeegi wo, ");
INSERT INTO kma_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ta die a nagɩ haŋgɔɔsɩ a wʋnsɩ sibubiŋ a nagɩ ka a bubi wo ta a nagɩ daaŋgbanɩŋ a yɩ ʋ nuudiigiŋ me, ta die a wa gbirigi ʋ nɩŋŋa a vʋarɩ wa fala, die a baarɩ dɩ, “Juu vuosi naaŋ wa, tɩ waasa fʋ!” ");
INSERT INTO kma_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Die ba tɩɩrɩ nɩntɔbɩtɩ a yi wo ta tuo daa dieke ba nagɩna a yɩ wa wa a nɩgɩ ʋ sikpeŋ me. ");
INSERT INTO kma_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Die ba vʋarɩna wa falaha a kpatɩ wa die ba tuo jayeeki dieke ba nagɩna a yɩ wa wa ta nagɩ ʋ gbaŋ gbaŋ ʋ jayeekiŋ a yeegi wo. Die ba yaa wa nyɩŋ dɩ ba ga kpaasɩ wa dagarɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Die ba ganana wa die ba tuoli daa wʋnyɩ dɩ nyɩnna Saarini ba wasa wa Simoni, die ba mugisi wo dɩ ʋ tuo Yisa dagarɩkʋ a chii. ");
INSERT INTO kma_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Die ba a keŋ a tʋgɩ jigidieke die ba wasɩnana Goligota wa, ka chɩaŋ yine “Sikpeŋ kogilike jigiŋ”, ");
INSERT INTO kma_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","mi die ba nagɩ daa dieke ba lagɩna aŋaŋ nyɩntʋatɩ a yɩ wa dɩ ʋ nyuu, ama die ʋ lannabʋ wa die ʋ zeti bʋ nyuule. ");
INSERT INTO kma_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Die ba kpaasɩna wa dagarɩkʋ ma a kpatɩ wa, die ba nagɩ ʋ nyiŋyeeke a puo taŋ aŋaŋ chaachaa, ");
INSERT INTO kma_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","die ba sʋʋŋ kalɩ a gbarɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Die ba maagɩ wudieke ba bala dɩ ʋ yine a chʋʋsɩ wa a marɩ ʋ dagarɩkʋ sikpeŋ; naa die ba maagɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Die ba bɩ kpaasɩ wa gbɩgbatɩrɩŋ bale dagarɩsɩ ma a gʋtɩ ʋ ma, die wʋnyɩ die bie wo ʋ nuudiigiŋ chaaŋ ta wʋnyɩ dɩaŋ die dɩ bie ʋ nuugalɩ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vuodiekemba die dɩ tɩannana wa die vige ba sikpigile ta die taana wa jome, ");
INSERT INTO kma_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a baarɩ dɩ, “Fʋnɩŋ fʋ baarɩ nan kpaŋŋɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ a taaŋ, ta nagɩ daraa ataa a yiŋŋi mɩɩ ka, gbatɩ fʋ gbaŋ a taaŋ. Fʋ yi Ŋmɩŋ Bʋa, fʋ keŋ sʋʋŋ dagarɩkʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Naa gbaŋ gbaŋ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba aŋaŋ tɩka nyɩŋkʋraha dɩ vʋarɩ wa fala, ");
INSERT INTO kma_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ta die baarɩ dɩ, “Die ʋ gbatɩ wa ʋ chanchaalɩŋ a taana ama ʋ kaaŋ bɩagɩ a gbatɩ ʋ gbaŋ gbaŋ a taaŋ! Dɩɩ yi ʋ seŋ yi Izara vuosi naaŋ wa, ʋ keŋ sʋʋŋ dagarɩkʋ ma aŋ tɩ yiwo yada. ");
INSERT INTO kma_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ʋ tuo wo Ŋmɩŋ dii ta baarɩ ʋ yiwo Ŋmɩŋ Bʋa. Dɩɩ yi Ŋmɩŋ dɩ yaala wa, nɩ vaa tɩ ye sɩba ʋ nan gbatɩ wa a taaŋ lele!” ");
INSERT INTO kma_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Die gbaŋ gbaŋ gbɩgbatɩrɩŋ diekemba die ba kpaasɩna a gʋtɩ ʋ ma wa dɩ zɩa wa. ");
INSERT INTO kma_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ŋmɩŋ dɩ wana a tʋgɩ sikpeŋ sʋnsʋŋ, tɩŋgbaŋka mana mana die dɩ sibi. Die ka sibi wo dee a ga tʋgɩ ŋmɩŋgbɩlɩkɩŋ hawasɩ ataa saŋŋa. ");
INSERT INTO kma_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Awasɩ ataa wa saŋŋa die Yisa dɩ faasɩ keesi ta natɩ dɩ “Eli, Eli lema sabakitani?” Ka chɩaŋ wone “N Ŋmɩŋ, n Ŋmɩŋ, bɩa yine fʋ va mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Vuodiekemba die dɩ zene mi wo ta wʋŋ wa wa die ba baarɩ dɩ “Ʋ wasa Elaja!” ");
INSERT INTO kma_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba wʋnyɩ die dɩ chɩgɩ lagɩ lagɩ a ga nagɩ gbara alʋ daŋmɩɩsɩŋ ma a nagɩka a sagɩ daaŋ sikpeŋ ta a kɔtɩ yɩ wa dɩ ʋ mʋgɩsɩ. ");
INSERT INTO kma_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ama ʋ chanchaalɩba dɩ baarɩ dɩ, “Vaa wa aŋ tɩ ye sɩba Elaja nan keŋ a gbatɩ wa a taaŋ?” ");
INSERT INTO kma_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ta Yisa die dɩ bɩ a faasɩ a keesi ta kpi. ");
INSERT INTO kma_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Saŋka mi die garɩ dieke die dɩ sagɩna Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma wa a puoke bule wo die dɩ puo bule a nyɩŋ ka sikpeŋ me a ga a tʋgɩ ka chɩaŋ ma ta tɩŋgbaŋ dɩ dɔŋ ta tankpɩɩma dɩ ŋmabɩ ŋmabɩ, ");
INSERT INTO kma_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kunti vɔrɩtɩ die dɩ yuori yuori ta vuodiekemba die dɩ kpine ta yi Ŋmɩŋ vuosisi bataŋ pam die dɩ hagɩ kunti me, ");
INSERT INTO kma_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","die ba nyɩŋ ba vɔrɩtɩ ma; ta Yisa die hagɩna kumbu me kʋaŋ chaaŋ die ba ga Jerusalemi ta vuosi pam die dɩ ye be aŋaŋ ba nine. ");
INSERT INTO kma_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Die sojasisi jakʋʋrɩ aŋaŋ sojasi dieke die dɩ gʋtɩna ʋ ma a gbarɩ Yisa wa die dɩ yene tɩŋgbaŋka dɔŋkʋ aŋaŋ wudieke dɩ yine wo, die ŋmaamɩŋ die dɩ yigi be, ba baarɩ, “Wusie, die ʋ seŋ yiwo Ŋmɩŋ Bʋa!” ");
INSERT INTO kma_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hɔgʋba pam dieke die dɩ dɩna Yisa kʋaŋ a nyɩŋ Galili ta suŋŋi wo wo die dɩ zie saasaa a jɩɩma wudieke dɩ yinene wo. ");
INSERT INTO kma_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bataŋ die yiwo Meri Magidalini aŋaŋ Jemisi aŋaŋ Josefu nuŋ Meri, aŋaŋ Zebedi ballɩ nuŋ. ");
INSERT INTO kma_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Die dɩ tʋgɩna jɩŋmɩŋ chaaŋ ligiretieŋ wʋnyɩ die dɩ nyɩnna Arimatia, ʋ saaŋ dɩ yine Josefu, die ʋ gbaŋ ʋ yiwo Yisa kʋaŋandɩɩsɩrʋ. ");
INSERT INTO kma_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Die ʋ ga Paliti jigiŋ a ga jʋʋsɩ wa Yisa nyɩŋgbaŋka, die Paliti dɩ yɩ nʋaŋ dɩ ba nagɩ nyɩŋgbaŋka a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Naa wɩa die Josefu die dɩ nagɩ ʋ nyɩŋgbaŋka, a yallɩ garɩhaalɩ yɩalɩŋ a muuri wo ");
INSERT INTO kma_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a nagɩ wa a dʋaŋ ʋ gbaŋ gbaŋ vɔrɩhaalɩ dieke ʋ tune taŋ lʋgɩŋ. Ta die biliŋ taŋ kpeŋkpɩɩŋ a keŋ ligi vɔrɩkʋ nʋaŋ ta die yiŋŋi. ");
INSERT INTO kma_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ta die Meri Magidalini aŋaŋ Meri wʋnɩŋ wa die kalɩ wa mi a daansa vɔrɩkʋ. ");
INSERT INTO kma_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tʋŋ die dɩ vʋʋna dɩnɩŋ daarɩ mi, die dɩ yine banɩŋ Juu vuosi davʋʋsɩkɩrɩ daaŋ, ta Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Farasisi die dɩ ga Paliti jigiŋ, ");
INSERT INTO kma_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","a die baarɩ, “Jakʋʋŋ tɩ tɩɩnsɩya dɩ saŋŋa dieke ŋmɩnchɩbɩtieŋ wo die dɩ benne ʋ miivoli me wo, die ʋ baarɩ, ‘N nan hagɩ kuŋ me daraa ataa daraaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Die wɩa yɩ nʋaŋ aŋ ba mɩŋŋɩ gbara ʋ vɔrɩkʋ a ga tʋgɩ daraa ataa wa daraaŋ. Dɩ daa die ʋ kʋaŋandɩɩsɩrɩba nan keŋ a gaarɩ ʋ nyɩŋgbaŋka, ta balɩ yɩ vuosisi dɩ ʋ hagɩ wa kuŋ me. Ta kʋaŋaŋ ŋmɩnchɩbɩsɩ gie nan wa a tɩaŋ bʋmbʋŋaŋ jaabʋ.” ");
INSERT INTO kma_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paliti die dɩ balɩ ba, “Nɩ nagɩ gbɩgbarɩtɩŋ aŋ ba ga a mɩŋŋɩ gbara vɔrɩkʋ, nɩ baaŋ nan bɩagɩ a gbaraka die mana.” ");
INSERT INTO kma_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Die wɩa, die ba ga a nagɩ gbɩgbarɩtɩŋ a ga ba ga gbarɩ vɔrɩkʋ, ta die a bʋʋlɩ tantɩ a mɩŋŋɩ taarɩ. ");
INSERT INTO kma_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Die Juu vuosi davʋʋsɩkɩrɩ daarɩ dɩ tɩanna, tʋŋ die dɩ vʋʋna Alasiri daaŋ sʋkʋleeliŋ ta Meri Magidalini aŋaŋ Meri wʋnɩŋ wa die dɩ ga dɩ ba daansɩ vɔrɩkʋ. ");
INSERT INTO kma_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta tɩŋgbaŋ die dɔŋ pam bʋnyɩ, dama die Ŋmɩŋ malaka die nyɩnna ŋmɩŋsikpeŋ a keŋ sʋʋŋ, a biliŋ tanɩ a kalɩ ka ma. ");
INSERT INTO kma_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Die ʋ nyɩŋgbanɩŋ die nyɩgɩsa sɩba nɩɩnyɩgɩsɩŋ ta ʋ nyiŋyeeke die dɩ yɩantɩ sɩba chɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ŋmaamɩŋ die dɩ yigi vuodiekemba die dɩ gbarɩna vɔrɩkʋ, die ba cheeli ta nan nan sɩba kunti. ");
INSERT INTO kma_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Die malakaka die dɩ balɩ a yɩ hɔgʋbaha, “Nɩnɩŋ nɩ da vaa ŋmaamɩŋ yalla nɩ, n sɩba dɩ nɩ yaala Yisa vuodieke die ba kpaasɩna dagarɩkʋ ma wa. ");
INSERT INTO kma_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ʋ wo giena ʋ hagɩ kumbu me sɩba die ʋ balla die wo. Nɩ keŋ a ye jigidieke die ʋ dʋana wa. ");
INSERT INTO kma_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɩ gamma lagɩ lagɩ a balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ ʋ hagɩ kuŋ me mɩŋ ta dɩ nɩ nɩŋŋa a gara Galili, mi nɩ nan ye wo. Wusie maŋ bala nɩ.” ");
INSERT INTO kma_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Die wɩa hɔgʋbaha die dɩ nyɩŋ vɔrɩkʋ jigiŋ lagɩ lagɩ aŋaŋ ŋmaamɩŋ ta bɩ yaa sʋgɩfɩalɩŋ pam ta chɩgɩ a ga balɩ ʋ kʋaŋandɩɩsɩrɩba. ");
INSERT INTO kma_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Die ba ganana wa Yisa die dɩ tuoli be sieŋ me a waasɩ ba; die ba gbirigi ʋ nɩŋŋa ta jɩaŋ wa. ");
INSERT INTO kma_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ta ʋ balɩ a yɩ ba, “Nɩ da vaa ŋmaamɩŋ yalla nɩ, nɩ ga a balɩ n nɩmballɩlɩ dɩ ba gamma Galili me, mi ba nan ye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Die hɔgʋba die yene be sieŋ me a gara, ta sojasisi bataŋ die dɩ gbarɩna vɔrɩkʋ dɩ yiŋŋi a ga tɩka ma a balɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha wudieke dɩ yine. ");
INSERT INTO kma_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha dɩ lagɩsɩ a saŋ; a nagɩ ligire pam a yɩ sojasisi, ");
INSERT INTO kma_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","a balɩ ba, “Nɩ balɩ dɩ ʋ kʋaŋandɩɩsɩrɩba kenne tanseese saŋŋa dieke tɩ dʋana gʋʋra a keŋ gaarɩ ʋ nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ta dɩɩ yi tɩka jakʋʋrɩ dɩ wʋŋ naa, tɩ nan ligi nɩ ʋ jigiŋ ta vʋarɩ nɩ wɩa ma.” ");
INSERT INTO kma_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Die gbɩgbarɩtɩba dɩ tuo ligirehe ta die ga balɩ vuosi wudieke ba balla dɩ ba balɩ wa. Die wɩa ta Juu vuosi die dɩ tuo wudieke ba bala wa a dii a keŋ tʋgɩ jinne. ");
INSERT INTO kma_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Die Yisa kʋaŋandɩɩsɩrɩba baŋ aŋaŋ kaanɩ wa die dɩ ga Galili kunkogiri me, jigidieke Yisa die dɩ bala ba dɩ ba ga wa. Mi die ba ye wo. ");
INSERT INTO kma_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Die ba yene wo die ba gbirigi a jɩaŋ wa ama bataŋ die dɩ chɩɩlɩ wa. ");
INSERT INTO kma_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Die ʋ keŋ gbigi be a baarɩ dɩ, “Ŋmɩŋ yɩ mɩŋ wa ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie yiko mana mana mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Die wɩa nɩ gamma tɩŋgbaŋka gie vuosi buuriŋ mana jigiŋ a yi be n kʋaŋandɩɩsɩrɩŋ, ta sɩma ba Ŋmɩŋ nyaabʋ n Chʋa Ŋmɩŋ saaŋ ma, aŋaŋ manɩŋ ʋ Bʋadembiŋ saaŋ ma, aŋaŋ Ŋmɩŋ Halɩkasɩka saaŋ ma, ");
INSERT INTO kma_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ta nɩ dagɩma ba aŋ ba saagɩ dɩa wudieke n dagɩna nɩ wa mana. Ama nɩ tɩɩnsɩ dɩ n nan dɩ bie nɩ jigiŋ saŋŋa mana a ga tʋgɩ dʋnɩa kpatɩŋ.”");
INSERT INTO kma_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ŋmɩŋ Bʋadembiŋ Yisa Masia wɩa die dɩ piiline dene wʋnna. ");
INSERT INTO kma_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sɩba Ŋmɩŋ naazʋa Azaya die dɩ maagɩna die wo: “Ŋmɩŋ baarɩ dɩ, ‘Nɩ ye, n baaŋ n tʋŋ wa n tʋntʋntʋ aŋ ʋ woliŋ a dɩa fʋ nɩŋŋa a wʋnsɩ fʋ sieti a yɩ fʋ.’ ");
INSERT INTO kma_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Vuoŋ benne haagɩŋ ma a keese a mʋʋla ‘Nɩ wʋnsɩ tɩ Yɔmʋtieŋ keniŋ sieti ta vaa a tʋgɩsɩ a yɩ wa.’ ” ");
INSERT INTO kma_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jɔɔn vuodieke die dɩ sɩnana vuotamba Ŋmɩŋ nyaabʋ die bie wo haagɩŋ ma a mʋʋla a yɩa vuotamba dɩ ba vaa ba wʋbɩatɩ ta ʋ sɩɩ ba Ŋmɩŋ nyaaŋ aŋ Ŋmɩŋ vaa a chaa ba ba wʋbɩatɩ. ");
INSERT INTO kma_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ta vuotamba pam die dɩ nyɩŋ Judia tɩŋgbaŋ ma aŋaŋ Jerusalemi tɩŋgbaŋ ma, a keŋ Jɔɔn jigiŋ a balɩ ba tʋmbɩatɩ tʋʋma a yɩ Ŋmɩŋ ta Jɔɔn dɩ sɩɩ ba Ŋmɩŋ nyaaŋ Jɔɔdani mʋgɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔɔn die yeegi wo nyiŋyeeki diekemba die ba nagɩna nyɔgɩnɩ kobiti a wʋnsɩ, ta bɩ bɔbɩ gbanɩŋ ʋ chɩaŋ ma, die ʋ nyindiike die dɩ yi sankpara aŋaŋ siesi. ");
INSERT INTO kma_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Die ʋ balɩ a yɩ vuosisi dɩ, “Vuodieke dɩ hagɩrɩna a tɩaŋ mɩŋ balla ʋ keŋ n kʋaŋ chaaŋ, n ka tʋgɩ vuodieke dɩ baaŋ nan gbirigi ʋ nɩŋŋa ta vʋarɩ ʋ nɩɩra guune gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Manɩŋ n sɩa wa aŋaŋ nyaaŋ, ama wʋnɩŋ ʋ balla ʋ nagɩ Ŋmɩŋ Haalɩŋ a sɩɩ nɩ sʋgɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Die dɩ ka yʋasɩya die Yisa dɩ nyɩŋ Nazeriti tɩŋ dɩ benne Galili me wo a keŋ Jɔɔn jigiŋ, ta Jɔɔn die dɩ sɩɩ wa Ŋmɩŋ nyaaŋ Jɔɔdani mʋgɩrɩ ma. ");
INSERT INTO kma_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yisa die dɩ nyɩnnana nyaabʋ ma wa ʋ ye ŋmɩŋsikpeŋ dɩ yuorine, Ŋmɩŋ Haalɩŋ dɩ keŋ a sʋʋna ʋ sikpeŋ me sɩba ŋmarɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta lɔlɩŋ dɩ nyɩŋ ŋmɩŋsikpeŋ a baarɩ, “Fʋnɩŋ fʋ yine n Bʋachoti; fʋnɩŋ n nine dɩ suuli.” ");
INSERT INTO kma_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ŋmɩŋ Haalɩbʋ die dɩ nagɩ Yisa a ga haagɩŋ ma; Die ʋ bie wo haagɩrɩ ma a ga tʋgɩ daraa baŋɩsɩ-nɩɩsa, ta Sitaani die dɩ magɩsɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yisa aŋaŋ haagɩŋ nɩŋ dɔŋɩsɩ die benne mi; ama ta Ŋmɩŋ malakaka die dɩ sʋʋŋ a suŋŋi wo. ");
INSERT INTO kma_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Die ba yigine Jɔɔn a yi dansarɩka ma kʋaŋ chaaŋ, Yisa die ga wa Galili me a bala Ŋmɩŋ wʋvɩɩnaha mi ");
INSERT INTO kma_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a baarɩ “Saŋŋa dieke Ŋmɩŋ naarɩ dɩ balla ka keŋ wo gbigiye mɩŋ, die wɩa nɩ yi Ŋmɩŋ wʋvɩɩnaha gie yada ta va nɩ wʋbɩatɩ.” ");
INSERT INTO kma_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yisa die dɩ chʋnnana Galili mʋgɩkpɩɩrɩ lʋgɩrɩ die ʋ ye Simoni aŋaŋ ʋ nɩmbʋa Andurusi, ta ba taana nɩɩŋ mʋgɩkpɩɩrɩ ma dama die ba yiwo zaasɩyigiriŋ. ");
INSERT INTO kma_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ʋ balɩ ba, “Nɩ dɩa mɩŋ ta n nan vaa nɩ sʋgɩma vuosi a kiere n jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lagɩ lagɩ ba vaa ba nɩɩtɩ ta hagɩ a dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta bɩ ga nɩŋŋa bɩta ta a ye Jemisi aŋaŋ ʋ nɩmbʋa Jɔɔn, Zebedi ballɩ, ta ba bie wo ba haarɩŋ sʋŋ a wʋnsa ba nɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ʋ wa ba, die ba va ba chɔɔŋ wa Zebedi aŋaŋ vuosisi die dɩ tʋnnana a yɩa ba wa ta hagɩ a dɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ ga tɩŋ kaanɩ ba wasɩnana Kapenɔmi; ta Juu vuosi davʋʋsɩkɩrɩ daraaŋ dɩ keŋ ba ga Ŋmɩŋ jʋʋsɩŋ juoku me, ʋ piili a daga vuosisi Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ʋ dagɩkʋ gie die dɩ yi be mamachi pam, dama ʋ dagɩ ba sɩba vuodieke dɩ yalla yiko, die ka ka sɩɩ sɩba Ŋmɩŋ mɩraha dɩdagɩrɩba die dɩ ŋaana a daga ba wa. ");
INSERT INTO kma_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Womi ta dembi dieke jɩmbɩakʋ dɩ yalla wa die dɩ keŋ a juu Ŋmɩŋ jʋʋsɩŋ juoku sʋŋ, ");
INSERT INTO kma_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","a keesi pam ta baarɩ dɩ, “Yisa, vuodieke dɩ nyɩnna Nazeriti, bɩa fʋ yaala tɩ jigiŋ? Keŋ dɩ fʋ chʋʋsɩ tɩ mɩŋ? N sɩba vuodieke dɩ yine fʋ, yiwo Ŋmɩŋ tʋntʋŋ kasɩ vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ama ta Yisa die dɩ natɩ wa, “Tarɩ watɩ ta va wa!” ");
INSERT INTO kma_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jɩmbɩakʋ die dɩ paalɩ a dɔŋ ʋ nyɩŋgbanɩŋ pam ta taaŋ keesiŋ pam ta die nyɩŋ ʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Die, die dɩ yi ba mana mamachi ta ba pɩasa ba chanchaalɩŋ dɩ, “Bɩa wʋnna? A yiwo wʋhaala? Ʋ yaa yiko ta yɩa jɩmbɩatɩ nʋaŋ ta a tuose nʋarɩ!” ");
INSERT INTO kma_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Naa chɩaŋ wɩa, Yisa saaŋ die dɩ dɩa Galili tɩŋgbaŋ mana. ");
INSERT INTO kma_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Die ba dene a nyɩŋ Ŋmɩŋ jʋʋsɩŋ juoku sʋŋ die wʋnɩŋ aŋaŋ Jemisi aŋaŋ Jɔɔn die dɩ ga a juu Simoni aŋaŋ Andurusi tigiŋ me. ");
INSERT INTO kma_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ta Simoni hanɩɩŋ hɔgʋ die dɩ dʋa a yʋagɩ, die ʋ nyɩŋgbanɩŋ dɩ faasɩ tuuli, ba balɩ Yisa ʋ yʋagɩbʋ gie wɩa. ");
INSERT INTO kma_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yisa dɩ ga a yigi ʋ nuuŋ ta suŋŋi wo ʋ hagɩ kalɩ, ʋ yʋagɩbʋ mana dɩ kpatɩ ta ʋ nyɩŋgbanɩŋ mana dɩ fɩalɩ, ta die ʋ hagɩ a yi chaantɩ a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta dɩnda daarɩ mi ŋmɩŋ die dɩ june, vuotamba die dɩ chii yʋagɩtieliŋ aŋaŋ vuodiekemba jɩmbɩatɩ dɩ yalla ba a kieŋ Yisa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta tɩka gie vuosi mana die dɩ lagɩsɩ a keŋ suuli tigiri me. ");
INSERT INTO kma_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Die ʋ vaa vuodiekemba die dɩ yʋagɩna yʋagɩtɩ yiri yiri mana dɩ ye gbaamɩŋ, ta bɩ yagɩ jɩmbɩatɩ vuotamba pam ma, ama ʋ ka saaga dɩ jɩmbɩatɩ balɩ wɩɩŋ, dama die a sɩba vuodieke ʋ yine mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yisa die dɩ woliŋ a nyɩŋ tigiri gie me ta kparaasɩ ye ka kʋma, ta ga haagɩŋ ma a ga jʋʋsa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ta Simoni aŋaŋ ʋ chanchaalɩba die dɩ dɩa a yaala ʋ jigiŋ, ");
INSERT INTO kma_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","die ba yene wo wo ba balɩ wa, “Vuoŋ mana yaala ba ye jigidieke fʋ benne.” ");
INSERT INTO kma_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ama ta Yisa die dɩ yiŋŋi a balɩ ba, “Sie tɩ ga tɩŋkpaŋŋɩsɩ diekemba dɩ gbigine giena wa. Ntaala n balɩ Ŋmɩŋ wɩa mi gbaŋ, dama die wɩa maŋ keŋ.” ");
INSERT INTO kma_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naa chɩaŋ wɩa die ʋ dɩdɩa Galili tɩka mana mana, a ga bala Ŋmɩŋ wɩa Ŋmɩŋ jʋʋsɩŋ juone nɩŋ mana ta die a yaga jɩmbɩatɩ vuosi me. ");
INSERT INTO kma_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dembiŋ wʋnyɩ die dɩ gobine gamɩŋ die dɩ keŋ a gbirigi Yisa nɩŋŋa, ta jʋʋsɩ wa dɩ ʋ suŋŋi wo. Gaŋkʋ nɩŋ die dɩ baarɩ, “Dɩɩ yi fʋ dʋŋŋʋ fʋ gbaaŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Zɔɔlɩŋ die dɩ yigi Yisa ʋ tɩɩntɩ ʋ nuuŋ a gbɩ wa ta balɩ wa, “N saagɩya. Fʋ yʋagɩbʋ kpatɩya mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Womi lagɩ lagɩ daa wa yʋagɩbʋ die dɩ kpatɩ bʋnyɩ, ʋ nyɩŋgbaŋka die dɩ bɩ yiŋŋi a sɩɩ sɩba die ʋ nyɩŋgbaŋka die dɩ wolinne a sɩɩ die wo. ");
INSERT INTO kma_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Womi Yisa die dɩ yi ʋ ga lagɩ lagɩ ama ta a paalɩ a balɩ wa aŋaŋ nɩŋŋmɩna dɩ, ");
INSERT INTO kma_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Wʋmma, sɩmma fʋ keŋ a balɩ vuoŋ wɩaha gie. Ama gamma a ga nagɩ fʋ gbaŋ a dagɩ Ŋmɩŋ kɩkaabɩtʋ wa a vaa ʋ jɩɩŋ fʋ aŋ fʋ kaabɩ kaabɩ dieke Ŋmɩŋ die dɩ balla Mosisi yaa gamma gbaanɩŋ jigiri, aŋ vuoŋ mana seŋ a sɩmma a baarɩ wusie fʋ yʋagɩtɩtɩ kpatɩya mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama daa wa die dɩ ga a bala wɩaha gie jigiŋ mana mana. Wusie, die ʋ seŋ ga a balɩ wa die amʋ Yisa die ka bɩ a bɩagɩ juu tɩka sʋŋ vuosi me. Ta wɩarɩ jigidieke vuosi die dɩ worine, vuosi die dɩ nyɩna jigiŋ mana mana a kieŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ʋ bɩ yiŋŋi ga Kapenɔmi die vuosi dɩ wʋŋ dɩ ʋ bie mi. ");
INSERT INTO kma_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Die vuosi die dɩ keŋ ʋ jigiŋ. Die wɩa jigiŋ die bɩ wori aŋaŋ vuogaasɩ dɩ baaŋ nan dɩ beri, die juoku mana suuliye mɩŋ aŋaŋ yeŋ me mana. Die ʋ bala Ŋmɩŋ wɩa a yɩa ba. ");
INSERT INTO kma_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Womi ta dembisi banɩɩsa wonde a chii vuodieke nyɩŋgbanɩŋ mana dɩ kpine a kieŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Die daadamba dɩ dala wa chɩaŋ ma die ba ka bɩagɩ a yaa wa tʋgɩ ʋ jigiŋ. Ba yuori toli mampili dieke ma ma Yisa Masia dɩ benne wo. Ba wana yuori toli mampili me a kpatɩ wa, ba nagɩ daa wa aŋaŋ giliŋgiliŋke a yaa sʋʋŋ dʋaŋ Yisa nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yisa die dɩ ye ta ba tuo wo dii mɩŋ, ʋ balɩ daa wa, “N bʋa, n nagɩ fʋ taalɩ a chaa fʋ.” ");
INSERT INTO kma_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Die vuodiekemba dɩ dagɩnana Ŋmɩŋ mɩraha die bie mi a yile ");
INSERT INTO kma_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","dɩ “Wʋbɩa daa wa gie dɩ bala die? Ʋ bala sɩba ʋ yi wo Ŋmɩŋ. Vuobɩa baaŋ nan nagɩ vuoŋ taalɩ a chaa wa ntaala Ŋmɩŋ nyɩɩna?” ");
INSERT INTO kma_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ta Yisa die dɩ wɔŋ mɩŋŋɩ ba sʋŋanyile, a balɩ ba dɩ, “Dɩ bɩa nɩ yile nɩ sʋŋ ma die? ");
INSERT INTO kma_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wʋbɩa yine mɔlɩ? Fʋ baaŋ nan balɩ a yɩ vuodieke nyɩŋgbanɩŋ dɩ kpine, ‘N nagɩ fʋ taalɩ a chaa fʋ?’ Yaa fʋ baaŋ nan balɩ ‘Hagɩ nagɩ fʋ giliŋgiliŋke a chʋŋ?’ ");
INSERT INTO kma_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","N nan wa a dagɩ aŋ nɩ sɩmma a baarɩ manɩŋ Vuota Bʋa yaa yiko dʋnɩa ma ma a nan bɩagɩ a nagɩ vuosi tʋmbɩatɩ a chaa ba.” Die wɩa die ʋ balɩ a yɩ vuodieke nyɩŋgbanɩŋ die dɩ kpine wo, ");
INSERT INTO kma_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“N bala fʋ, hagɩ a nagɩ fʋ giliŋgiliŋke, a kuli.” ");
INSERT INTO kma_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ʋ hagɩ bʋnyɩ a nagɩ ʋ giliŋgiliŋke, a chʋŋ ba mana nine me. Die ba yene wo die wo, ka paalɩ a yi be mamachi. Ba baarɩ, “Tɩ bɩra Ŋmɩŋ. Tɩ ye ka ye wɩɩŋ ka nɩasɩ naa.” ");
INSERT INTO kma_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ka kʋaŋ chaaŋ Yisa dɩ bɩ yiŋŋi ga mʋgɩkpɩɩrɩ gie lʋgɩŋ ta vuosi pam dɩ lagɩsɩ ʋ jigiŋ a giliŋ wo, ta ʋ daga ba Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Die ʋ dɩna chʋŋ wa die ʋ ga haarɩ lampotuosiru wʋnyɩ Liiva, vuodieke die dɩ yine Alifusi bʋadembiŋ, ta ʋ kalɩ ʋ tʋʋma juoŋ me. Yisa die dɩ balɩ a yɩ wa, “Hagɩ a dɩa n kʋaŋ”, Liiva die dɩ hagɩ a dɩɩ ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Die kʋaŋ chaaŋ Yisa die dɩ die nyindiike Liiva tigiŋ me, lampotuosiriŋ pam aŋaŋ vuodiekemba dɩ kana ka dɩ Juu vuosisi mɩraha pam die dɩdɩ Yisa kʋaŋ. Ba pam die dɩ keŋ a gʋtɩ ba ma aŋaŋ ʋ kʋaŋandɩɩsɩrɩba nyindiikehe jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mɩra dɩdagɩrɩba bataŋ die dɩ yine Farasisi die dɩ yene Yisa aŋaŋ lampotuosiribe aŋaŋ vuodiekemba dɩ kana ka dɩ Juu vuosisi mɩraha die dɩ lagɩsɩna tamba a die nyindiikehe, die ba pɩasɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Bɩa yine wʋnɩŋ aŋaŋ vuodiekemba dɩ kana ka dɩ Juu vuosisi mɩraha mi chanchaalɩŋ dɩ lagɩsa a die?” ");
INSERT INTO kma_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisa die dɩ wʋŋ ba ta balɩ ba dɩ, “Vuodiekemba dɩ yalla alaafɩa ka yaala gbɩgbaantʋ, sie vuodiekemba dɩ yʋagɩna. Dɩ ka yi vuovɩɩna wɩa maŋ keŋ, wʋbɩatɩtieliŋ wɩa maŋ keŋ.” ");
INSERT INTO kma_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saŋŋa kaanɩ, Jɔɔn vuodieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ kʋaŋandɩɩsɩrɩba aŋaŋ vuosi bataŋ ba wasɩnana Farasisi die dɩ bɔba nʋaŋ. Vuosi bataŋ die dɩ keŋ Yisa jigiŋ a pɩasɩ wa dɩ, “Bɩa yine Jɔɔn kʋaŋandɩɩsɩrɩba aŋaŋ Farasisi dɩ bɔba nʋaŋ, ta fʋnɩŋ nɩŋ fʋ kʋaŋandɩɩsɩrɩba dɩ ka bɔba?” ");
INSERT INTO kma_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yisa die dɩ yiŋŋi a balɩ ba, “Nɩ tɩŋ yaala chaaŋ diekemba dɩ gana hɔgʋ faarɩŋ ma bɔbɩ nʋaŋ? Banɩŋ aŋaŋ hɔgʋ wa tieŋ dɩ lagɩsɩna a beri wo, die kaaŋ bɩagɩ a yi. ");
INSERT INTO kma_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama saŋŋa nan keŋ ba nan nagɩ hɔgʋ wa tieŋ a nyɩŋ ba jigiŋ, saŋka mi ba nan wa bɔbɩ nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Vuoŋ kaaŋ saagɩ a nagɩ garɩhaalɩŋ garɩchɔɔtɩŋ a baalɩ a ligi garɩkʋʋŋ vɔrɩŋ, dama garɩhaalɩkʋ gie nan chɩɩrɩ ta vaa garɩkʋʋrɩ, aŋ ka vɔrɩkʋ wa a faasɩ a dalɩma. ");
INSERT INTO kma_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yaa nɩ yeye ta vuoŋ nagɩ daahaalɩŋ a sʋʋ gbanɩŋ koliti diekemba dɩ yine nyɩŋkʋra ma? Dama ʋ yi die daabʋ nan kʋŋ a chɩɩrɩ kolititi aŋ daabʋ aŋaŋ kolititi mana taaŋ yɔrɩ. Ama ʋ ŋaaŋ nagɩ wa daahaalɩŋ a sʋʋ gbanɩŋ koliti diekemba dɩ yine nyɩŋhaala ma.” ");
INSERT INTO kma_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tɔ, Juu vuosi davʋʋsɩkɩrɩ daraaŋ, Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ chʋŋ tɩanna zaa kʋaŋ ma. Die ba ganana wa die ʋ kʋaŋandɩɩsɩrɩba die dɩ gobe zaapakɩtɩ a yɩaga ŋɔba ta gara. ");
INSERT INTO kma_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Die wɩa Farasisi vuosi die dɩ pɩasɩ dɩ, “Ye, bɩa wɩa ba yie wudieke tɩ mɩraha dɩ kana ka saaga dɩ ba yi davʋʋsɩkɩrɩ daraaŋ?” ");
INSERT INTO kma_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yisa die dɩ yiŋŋi a pɩasɩ ba, “Nɩ ye ka karɩŋ Ŋmɩŋ gbaŋkʋ sʋŋ Davidi aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ yine wudieke kɔŋ die dɩ yalla ba wa? Kɔŋ die yigine wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba, ");
INSERT INTO kma_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","die wɩa die ʋ ga a juu Ŋmɩŋ tigiri me a ŋɔbɩ paanʋ dieke die ba nagɩna a yɩ Ŋmɩnnɩ. Saŋka mi Abiata die yine Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ. Ama tɩ mɩra die ka baarɩ vuogaasɩ ŋɔbɩha sie Ŋmɩŋ kɩkaabɩtɩba nyɩɩna ma; ama ta Davidi die dɩ ŋɔbɩ paanʋkʋ gie, halɩ ta die a nagɩ ataŋ a yɩ ʋ kʋaŋandɩɩsɩrɩba gbaŋ ba ŋɔbɩ.” ");
INSERT INTO kma_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Womi die ʋ balɩ a kpatɩ ba dɩ, “Vuotaŋ wɩa Ŋmɩŋ dɩ naaŋ davʋʋsɩkɩrɩ ama daa davʋʋsɩkɩrɩ daarɩ wɩa ʋ naaŋ vuotaŋ. ");
INSERT INTO kma_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Die wɩa, manɩŋ vuota Bʋadembiŋ yine davʋʋsɩkɩrɩ daraaŋ jakʋʋŋ.” ");
INSERT INTO kma_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saŋŋa kaanɩ bɩbra Yisa dɩ bɩ yiŋŋi ga Ŋmɩŋ jɩamɩŋ juoku me. Daa wʋnyɩ dɩaŋ die benne mi a yallɩ nuukpiikiŋ. ");
INSERT INTO kma_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farasisi vuosi dɩaŋ die benne mi a yaala wɩɩŋ ba nagɩ a yigi Yisa, die wɩa die ba paalɩ a paala wa dɩ ba ye sɩba ʋ nan gbaaŋ daa wa davʋʋsɩkɩrɩ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yisa dɩ balɩ a yɩ nuukpiikiri tieŋ, “Keŋ tɩaŋ a zie nɩŋŋa.” ");
INSERT INTO kma_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yisa dɩ pɩasɩ daadamba, “Bɩa mʋna tɩ yi davʋʋsɩkɩrɩ daraaŋ? Tɩ mʋ tɩ yi vɩɩnɩŋ yaa, tɩ yi bɩaŋ? Tɩ mʋ tɩ gbatɩ miivoli yaa, tɩ kʋʋ?” Ama die ba ka bɩagɩ ye wɩɩŋ a balɩ. ");
INSERT INTO kma_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yisa die dɩ jɩɩ sɩnyɩɩrɩŋ ta daansɩ ba a keŋ tɩaŋ aŋaŋ die mana yɔrɩ ta die ʋ chɩgɩ ba zɔɔlɩŋ dama die ba yiwo vuotɔgɩtɩ. Womi ʋ balɩ daa wa, “Tɩɩrɩ fʋ nuuke.” ");
INSERT INTO kma_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ʋ tɩɩrɩka, a ye gbaanɩŋ. Farasisi vuosi die dɩ nyɩŋ lagɩŋkʋ jigiŋ a ga ba aŋaŋ naaŋ Herodi vuosi dɩ ye tamba a lagɩŋ taŋ a yaala sieti ba baaŋ nan nagɩ a kʋʋ Yisa. ");
INSERT INTO kma_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ hagɩ a sʋʋŋ ga mʋgɩkpɩɩrɩ lʋgaha ta vuotamba pam die dɩ dɩɩ ʋ kʋaŋ, vuodiekemba die dɩ nyɩnna Galili aŋaŋ Judia, ");
INSERT INTO kma_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aŋaŋ Jerusalemi aŋaŋ Idumia aŋaŋ Jɔɔdani mʋgɩŋ gaaŋ aŋaŋ Taya aŋaŋ Sadoni tɩŋgbaŋ ma, ta ba dala pam ta lagɩsɩ ʋ jigiŋ; die ba wʋnna dɩ ʋ yi wo tʋntʋnkpɩɩma wɩa, die ba keŋ ʋ jigiŋ mʋgɩkpɩɩrɩ lʋgɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta ʋ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ ba nagɩ haarɩŋ a yɩ wa aŋ ʋ juu a kala ta dagɩ vuosi gie Ŋmɩŋ wɩa, amʋ ba kaaŋ bɩagɩ a kpaŋŋɩ wa, ");
INSERT INTO kma_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","dama die ʋ yine yʋagɩtieliŋ pam die dɩ ye gbaama wɩa, die dɩ yi vuodiekemba mana mana dɩ yʋagɩna die dɩ kieŋ dɩ ba gbɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vuodiekemba jɩmbɩatɩ die dɩ yalla dɩ keŋ ye wo saŋŋa mana, ba ŋaaŋ nan wa ʋ nɩŋŋa ta nata ta baarɩ dɩ, “Fʋnɩŋ yiwo Ŋmɩŋ Bʋadembiŋ.” ");
INSERT INTO kma_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta ʋ die dɩ balɩ ba aŋaŋ nɩŋŋmɩna dɩ ba da keŋ mʋʋlɩ a yɩ vuosi. ");
INSERT INTO kma_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Naa kʋaŋ chaaŋ Yisa die dɩ jʋalɩ taŋ sikpeŋ ta wa wa vuodiekemba ʋ yaalɩnana dɩ ba keŋ, die ba keŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yisa die dɩ vʋarɩ vuosi baŋ aŋaŋ bale, a wa ba tʋntʋntɩba, dɩ ba bemme mi ʋ jigiŋ aŋ ʋ tʋmma ba, ba mʋʋlɩma ʋ wʋvɩɩnaha, ");
INSERT INTO kma_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ta bɩ yallɩma yiko a vʋarɩma jɩmbɩatɩ vuotamba ma. ");
INSERT INTO kma_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Vuotamba baŋ aŋaŋ bale dieke ʋ vʋarɩna Saara wʋnna; Simoni, vuodieke Yisa die yɩna wa Piita aŋaŋ ");
INSERT INTO kma_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemisi aŋaŋ ʋ nɩmbʋa Jɔɔn, vuodiekemba die dɩ yine Zebedi ballɩ; ta Yisa die dɩ yɩ ba Bʋanejesi, ka chɩaŋ yiwo nɩɩŋ natɩŋ ballɩ; ");
INSERT INTO kma_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","aŋaŋ Andurusi aŋaŋ Filipi, aŋaŋ Batolomiwo, aŋaŋ Matiwo, aŋaŋ Tomasi, aŋaŋ Jemisi vuodieke die dɩ yine Alifusi bʋa aŋaŋ Tadeusi, aŋaŋ Simoni vuodieke die dɩ yaalala banɩŋ Juu vuosi yallɩma ba gbaŋ ");
INSERT INTO kma_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aŋaŋ Judasi Asikaroti vuodieke die dɩ nyɩnna Yisa kʋaka. ");
INSERT INTO kma_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Naa kʋaŋ chaaŋ Yisa die dɩ kuli; ta daadamba pam die dɩ lagɩsɩ wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba jigiŋ ta die ka yaa saŋŋa dɩ ba dii nyindiike. ");
INSERT INTO kma_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ʋ tigiŋ vuosi die dɩ wʋnna die wo, ba keŋ dɩ ba yigi wo, dama vuotamba die bala dɩ ʋ yi wo yɩɩŋyaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Die Ŋmɩŋ mɩra dɩdagɩrɩba die dɩ nyɩnna Jerusalemi die dɩ baarɩ dɩ, “Jɩmbɩatɩ naaŋ wa Beelizebuli die yalla wa ʋ bɩagɩ vʋara jɩmbɩatɩ daadamba ma, dɩ yiwo Beelizebuli yiko wɩa.” ");
INSERT INTO kma_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Die Yisa die dɩ wa dɩdagɩrɩba gie dɩ ba keŋ ʋ jigiŋ, ta die yɩ ba nandagɩŋ, a pɩasɩ ba dɩ, “Sitaani nan saagɩ a vʋara ʋ gbaŋ vuosi me? ");
INSERT INTO kma_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Naaŋ vuosi dɩ yiŋŋi a waga tamba, ba naarɩ kaaŋ bɩagɩ a zie. ");
INSERT INTO kma_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ta dɩɩ yi tigiŋ vuosi dɩ yiŋŋi a waga tamba, ba tigiri kaaŋ bɩagɩ a zie. ");
INSERT INTO kma_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ta Sitaani dɩ yiŋŋi a waga aŋaŋ ʋ gbaŋ ʋ kaaŋ bɩagɩ a zie, ʋ kpatɩŋ wonde. ");
INSERT INTO kma_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Vuoŋ wori a baaŋ bɩagɩ a ga hagɩrɩtieŋ tigiŋ me a ga gaarɩ ʋ nyinti, sie ʋ woliŋ bɔbɩ wa ta ka kʋaŋ chaaŋ ʋ bɩ gaarɩ ʋ tigiŋ nyinti mana.” ");
INSERT INTO kma_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yisa dɩ bɩ balɩ ba dɩ, “Wusie maŋ bala nɩ, Ŋmɩŋ nan vaa chaa vuosi ba wʋbɩatɩ aŋaŋ ba wʋtɔgɩbɩatɩ mana; ");
INSERT INTO kma_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ama vuodieke mana dɩ balɩ wʋtɔgɩbɩatɩ a yɩ Ŋmɩŋ Haalɩŋ, Ŋmɩŋ kaaŋ bɩ nagɩ ʋ taalɩ a chaa wa naada yaa gamma haahuu.” ");
INSERT INTO kma_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisa die balɩ wa wɩaha gie, dama die ba baarɩ dɩ, “Jɩmbɩaŋ die yalla wa.” ");
INSERT INTO kma_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Saŋka mi Yisa nuŋ wo aŋaŋ ʋ nɩmballɩ die dɩ keŋ ta zie yeŋ me, ta tʋŋ vuoŋ dɩ ʋ wa wa mi. ");
INSERT INTO kma_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Daadamba die dɩ taanna a giliŋ wo wo die dɩ balɩ a yɩ wa, “Fʋ naa aŋaŋ fʋ nɩmballɩ bie yeŋ me a yaala fʋ.” ");
INSERT INTO kma_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ʋ pɩasɩ ba dɩ, “Mɩnɩa yine n naa, ta mɩnɩa yine n nɩmballɩ?” ");
INSERT INTO kma_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta daansɩ daadamba die dɩ kalla ʋ jigiri ta baarɩ dɩ, “N nuŋ aŋaŋ n nɩmballɩ benne giena. ");
INSERT INTO kma_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vuodieke mana dɩ yinene Ŋmɩŋ choti, wʋnɩŋ ʋ yine n nɩmbʋa aŋaŋ n taa aŋaŋ n nuŋ.” ");
INSERT INTO kma_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Saŋŋa kaanɩ bɩbra die Yisa die dɩ kalɩ a daga wɩa Galili mʋgɩkpɩɩrɩ lʋgɩŋ chaaŋ. Daadamba die dɩ gilinne wo die paalɩ a dala mɩŋ die wɩa die ʋ hagɩ a ga juu haarɩkʋ sʋŋ a bie nyaaŋ sʋŋ, ta vaa vuosisi a zieŋ nyaabʋ kʋanʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Die ʋ nagɩ nandaga a dagɩ ba wɩa pam. ");
INSERT INTO kma_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ʋ dagɩkʋ sʋŋ die ʋ balɩ a yɩ ba dɩ: “Nɩ wʋmma, daa wʋnyɩ die nyɩnna a ga dɩ ʋ bʋrɩ ʋ kʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Die ʋ bʋrɩnana ʋ kʋakʋ ma wa, nyɩŋbʋraha ataŋ die dɩ nan sieku me, nembisi die dɩ keŋ diihe. ");
INSERT INTO kma_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nyɩŋbʋra ataŋ die dɩ nan tanjaalɩŋ ma jigidieke tantɩ pam die dɩ worine. Nyɩŋbʋraha die dɩ nyʋʋŋ lagɩ lagɩ, dama tantɩ die ka dala. ");
INSERT INTO kma_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ŋmɩŋ die dɩ zie die a mana die dɩ kpi dama die a dagɩrɩsɩ ka sʋʋŋya. ");
INSERT INTO kma_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ataŋ die dɩ nan haŋgɔɔsɩ dagɩrɩsɩ ma, haŋgɔɔsɩ die dɩ bɩrɩŋ a nyagɩha a ka bɩagɩ yi nyɩŋbʋra. ");
INSERT INTO kma_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ama ta nyɩŋbʋraha ataŋ dɩaŋ dɩ nan tɩŋgbaŋ vɩɩnɩŋ ma a mɩŋŋɩ a nyʋʋŋ, a bɩrɩŋ a yi nyɩŋbʋra. Ataŋ die nyɩŋ wa zaabie baŋɩsɩ-taa taa, ataŋ dɩaŋ dɩ nyɩŋ baŋɩsɩ-yʋaba yʋaba, ta ataŋ dɩaŋ kɔbɩga kɔbɩga.” ");
INSERT INTO kma_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Womi die Yisa dɩ balɩ ba, “Die wɩa vuodieke mana dɩ yallɩ tɩba a nan wʋŋ, ʋ wʋmma.” ");
INSERT INTO kma_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yisa die dɩ yine ʋ nyɩɩna a kalɩ, vuodiekemba die dɩ benne mi a wʋŋ ʋ balɩkʋ bataŋ die dɩ lagɩŋ a gʋtɩ ʋ kʋaŋandɩɩsɩrɩba ma a ga ʋ jigiŋ a balɩ wa dɩ ʋ dagɩ ba nandagɩrɩ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yisa die dɩ yiŋŋi a balɩ ba, “Nɩnɩŋ Ŋmɩŋ naarɩ wʋlɔbɩrɩkɩŋ maŋ baa n dagɩ nɩ dene, ama vuotɩalɩkaha nɩŋ nan wʋŋ wɩaha gie mana mana nandaga sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Amʋ ‘Ba nan dɩ daansa a daansa ama ba kaaŋ ye jaaŋ; ba nan wʋŋ a bɩ wʋŋ a gʋtɩ ama ba kaaŋ dɩ sɩba ka chɩaŋ. Dama ba keŋ a sɩba a chɩasɩ ba nan yiŋŋi a keŋ Ŋmɩŋ jigiŋ, aŋ Ŋmɩŋ tɩŋ nagɩ ba tʋmbɩatɩ a chaa ba.’ ” ");
INSERT INTO kma_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Womi Yisa die dɩ pɩasɩ ba, “Die nɩŋ nɩ ka sɩba nandagɩrɩ gie chɩaŋ? Nɩ wa baa nɩ yi wo lalɩa a sɩmma nandagaha mana chɩasɩ? ");
INSERT INTO kma_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bʋbʋrɩtʋ wa nɩasɩ wa vuodieke dɩ balala Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nyindiekemba die dɩ nanna sieku me wo yi wo vuodiekemba dɩ ŋaana a wʋŋ Ŋmɩŋ wɩaha ama dɩ ka yʋasa ta Sitaani keŋ vʋarɩha ba ma. ");
INSERT INTO kma_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vuosi bataŋ dɩaŋ nɩasɩ wa nyɩŋbʋra diekemba die dɩ nanna taŋjaalɩka sikpeku; saŋŋa dieke mana ba keŋ a wʋŋ Ŋmɩŋ wʋbalɩkaha dɩ ka yʋasa ta ba mɩŋŋɩ a tuohe aŋaŋ sʋgɩfɩalɩŋ, ");
INSERT INTO kma_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ama a ka dʋaga ba sʋgɩtɩ ma a yʋasa, dama wɩɩrɩ gie ka sʋʋŋ ba sʋgɩtɩ ma ma, die wɩa ba keŋ mugisi be yaa wahala dɩ keŋ juu be wɩaha gie chɩaŋ ma ba ŋaaŋ nagɩha a taaŋ mɩŋ lagɩ lagɩ. ");
INSERT INTO kma_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bataŋ dɩaŋ nɩasɩ wa nyindiekemba die dɩ nanna haŋgɔɔsɩ dagɩrɩsɩ ma wa. Vuosi gie ŋaaŋ wʋŋ wa Ŋmɩŋ wʋbalɩkaha, ");
INSERT INTO kma_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ama dʋnɩaka gie wumugisike, aŋaŋ ligire yaalɩŋ aŋaŋ nyinti yiri yiri yaalɩŋ ŋaaŋ juu ba sʋŋ mɩŋ a nyagɩ wɩaha amʋ a kaaŋ nyɩŋ nyɩŋnyɩŋka. ");
INSERT INTO kma_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ama vuota diekemba dɩ nɩasɩna nyɩnbʋrɩ diekemba die dɩ nanna tɩŋgbaŋ vɩɩnɩŋ ma, ba wʋma wɩaha gie ta tuo dii, ta yie vɩɩnɩŋ. Bataŋ dɩ nyɩna baŋɩsɩ-taa taa, ta bataŋ dɩaŋ dɩ nyɩna baŋɩsɩ-yʋaba yʋaba, ta bataŋ dɩaŋ dɩ nyɩna kɔbɩga kɔbɩga.” ");
INSERT INTO kma_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisa die dɩ bɩ a pɩasɩ ba dɩ, “Vuoŋ nan chogisi popoli a zieŋ juoŋ sʋŋ ta ligike aŋaŋ kpalɩ, yaa ta nagɩka a zieŋ gado chɩaŋ? Aayɩ, ʋ nan nagɩka a zieŋ jaaŋ sikpeŋ. ");
INSERT INTO kma_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jadieke mana dɩ lɔbɩrɩna nan nyɩŋ yaalɩŋ ma, ta jadieke mana jaaŋ dɩ bubine nan dɩ bie yeŋ me. ");
INSERT INTO kma_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Die wɩa vuodieke dɩ yaa tɩba a nan wʋŋ, ʋ wʋmma.” ");
INSERT INTO kma_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Die ʋ bɩ balɩ a gʋtɩ ba, “Nɩ chɩɩsɩma a wʋmma nɩ wʋnnana wudiekemba ba, sie diekemba nɩ dɩɩsɩna a die vuosi sarɩya, Ŋmɩŋ baa ʋ dɩ wa hanɩŋ sieti mi gbaŋ gbaŋ a dii nɩ sarɩya. Ama Ŋmɩŋ nɩŋ sietiti nan paalɩ a tʋa a tɩaŋ nɩ sietiti. ");
INSERT INTO kma_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vuodiekemba dɩ yalla nan ye a gʋtɩ ama vuodieke dɩ wone jaaŋ, halɩ bɩta dieke gbaŋ ʋ yalla wa ʋ nan waarɩka.” ");
INSERT INTO kma_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisa die dɩ bɩ a baarɩ dɩ, “Ŋmɩŋ naarɩ nɩasɩ wa sɩba vuoŋ dɩ bʋrɩna ʋ nyɩŋbʋra ʋ kʋaŋ ma, ");
INSERT INTO kma_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ʋ ŋaaŋ gʋʋra yuŋ ta haga sʋkʋʋŋ ta a nyuuŋ ye mɩŋ ta bɩrɩma; ama ʋ zɩ a yinene die a nyuune ta bɩrɩma wa. ");
INSERT INTO kma_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tɩŋgbaŋka gbaŋ gbaŋ yinene nyɩŋbʋraha dɩ nyuune ta bɩrɩma a nyɩnna bie. Nyɩŋbʋraha daakʋ ŋaana a woliŋ a bɩrɩŋ, kʋaŋ chaaŋ ka pɔsɩ vaatɩ ta kʋaŋ kʋaŋ ka sikpeku mana mana nyɩŋ bie. ");
INSERT INTO kma_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nyɩŋbʋraha dɩ keŋ a bii kʋakʋ tieŋ ŋaaŋ nagɩ wa ʋ jɩbɩŋ a piili a gobe dama a gobiŋ saŋŋa tʋgɩya mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisa die dɩ pɩasɩ ba dɩ, “Bɩa jaaŋ tɩ baa tɩ nagɩ Ŋmɩŋ naarɩ a magɩsɩ? Yaa nandagɩ bɩa tɩ baa tɩ nagɩ a dagɩ ka chɩaŋ aŋ vuoŋ mana sɩmma? ");
INSERT INTO kma_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ka sɩɩ sɩba kaŋmɩnɩŋ biŋ vuoŋ dɩ nagɩna a bʋrɩ tɩŋgbaŋ ma, ka yi jabɩŋ a tɩaŋ nyɩŋbʋra mana mana dʋnɩa ma ma, ");
INSERT INTO kma_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ama dɩ ka yʋasa ta ka nyuuŋ a bɩrɩŋ a tɩaŋ dʋnɩa vapɔgɩtɩ mana. Ka ŋaaŋ faasɩ yaa wa dachagɩsɩkpɩɩma pam aŋaŋ nembisi dɩ baaŋ nan bɩagɩ a yʋgɩ ba tuosi ka sikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisa die nagɩ wa nandaga nɩasa sɩba naa, a dagɩ ba Ŋmɩŋ wɩa pam. Die ʋ dagɩ ba wa nandaga diekemba ba baaŋ nan dɩ sɩba a chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Die ʋ ka balɩ wɩɩŋ a yɩa ba ta ka nagɩ nandagɩŋ a balɩ, ama saŋŋa dieke nɩŋ mana die wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba nyɩɩna ma dɩ keŋ a kalɩ, ʋ ŋaaŋ dagɩ ba mɩŋ nandagaha mana chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dɩnɩŋ daarɩ mi gbaŋ gbaŋ jɩŋmɩŋ, Yisa die dɩ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba, “Nɩ vaa tɩ jʋalɩ a tɩaŋ a ga mʋgɩkpɩɩrɩ gaarɩ mi wo chaakʋ.” ");
INSERT INTO kma_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Die wɩa die ba va daadamba mi ta die a juu haarɩkʋ Yisa die wone bie ka sʋŋ, banɩŋ aŋaŋ Yisa dɩ ga. Haarɩsɩ ataŋ gbaŋ die benne mi. ");
INSERT INTO kma_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Womi bʋlɔgɩsɩkpeŋkpɩɩŋ die dɩ piili a nɩga; nyaabʋ die dɩ poŋŋi a juo haarɩkʋ sʋŋ. Die wɩa die haarɩkʋ die dɩ yaala ka suuli aŋaŋ nyaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yisa die bie wo haarɩkʋ kʋaŋ a nagɩ ʋ sikpeŋ a kpagɩlɩ dafere a gʋʋra. Ʋ kʋaŋandɩɩsɩrɩba dɩ sʋgɩrɩ wa a baarɩ, “Dɩdagɩrʋ, dɩ ka mugisi fʋ tɩ balla tɩ kpi naa?” ");
INSERT INTO kma_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yisa die dɩ hagɩ a yɩ bʋlɔgɩsɩbʋ nʋaŋ, “Vaa nɩgɩŋ” ta balɩ a yɩ nyaaŋ poŋŋiku dɩaŋ “Zie dene.” Bʋlɔgɩsɩbʋ die dɩ nan, mi mana die dɩ paalɩ fɩalɩ. ");
INSERT INTO kma_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Womi die Yisa die dɩ pɩasɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Bɩa yine ŋmaamɩŋ dɩ yallɩ nɩ, nɩ ye ko wo yada?” ");
INSERT INTO kma_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ama ta ŋmaamɩŋ die dɩ paalɩ a yallɩ ba, die ba pɩasa tamba, “Mɩnɩa yine daa wa gie? Halɩ bʋlɔgɩsɩŋ aŋaŋ nyaaŋ poŋŋiŋ dɩ wʋma ʋ wʋbalɩka yɩa wa.” ");
INSERT INTO kma_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ jʋalɩ a keŋ tʋgɩ Galili mʋgɩkpɩɩrɩ chaakʋ mi, Gerasa tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yisa die dɩ dene nyɩnna haarɩkʋ sʋkʋ, lele womi daa wʋnyɩ dɩ nyɩnna jigidieke ba lɔbɩrɩnana vuosi dɩ keŋ a haarɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jɩmbɩaŋ die yalla wa, daa wa gie die dɩ ga gʋʋra kunti vɔrɩtɩtɩ ma, die ba ka bɩagɩ a bɔbɩ wa a dʋaŋ aŋaŋ chɔrɩma. ");
INSERT INTO kma_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dama ba keŋ bɔbɩ wa ʋ nuusi aŋaŋ ʋ nagɩsɩ ʋ ŋaaŋ kpaa kpaa chɔrɩmaha mɩŋ ʋ nuusi me ta wɩɩ kʋʋtɩtɩ ʋ nagɩsɩ ma. Die ʋ paalɩ a hagɩrɩ mɩŋ aŋaŋ vuoŋ dɩ baaŋ nan nyaŋŋɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Daaŋ mana sʋkʋʋŋ aŋaŋ yuŋ ʋ ŋaaŋ dɩ chʋŋ wa vɔrɩtɩ aŋaŋ kunkogehe me a nata ta naga tana a gobe ʋ nyɩŋgbanɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Die ʋ bie wo saasaa ta die a ye Yisa, die wɩa die ʋ chɩgɩ a ga gbirigi ʋ dune me Yisa nɩŋŋa, ");
INSERT INTO kma_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ta faasɩ a taaŋ keesiŋ a baarɩ dɩ, “Nabidie Ŋmɩŋ Bʋadembiŋ Yisa, bɩa fʋ yaala n jigiŋ, Ŋmɩŋ wɩa daa keŋ datɩ n tɩbɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Die ʋ balɩ wa die dama Yisa die balɩ a yɩ jɩmbɩakʋ mɩŋ dɩ, “Vaa daa wa gie.” ");
INSERT INTO kma_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yisa die dɩ pɩasɩ wa dɩ, “Fʋ saaŋ?” Daa wa dɩ baarɩ dɩ, “N saaŋ yine ‘Dala’, dama tɩ faasɩ a dala mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta die ʋ ye ko a jʋʋsa Yisa dɩ ʋ da keŋ a yagɩ ba a nyɩŋ lʋgɩrɩ mi chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Perukusi pam die gbigine mi a die nyinti kunkogiri mi chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jɩmbɩakʋ die dɩ jʋʋsɩ Yisa dɩ, “Vaa tɩ gamma perukusisi jigiŋ a ga juu ba sʋgɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Die chɩaŋ ma die Yisa dɩ yi die jɩmbɩakʋ die dɩ nyɩŋ daa wa ma a ga juu perukusisi ma. Perukusisi die yiwo sɩba tuse tuse ale a mana mana die dɩ chɩgɩ a dɩɩ jigidieke dɩ golinne wo a ga a juu mʋgɩkpɩɩrɩ sʋŋ, nyaabʋ die dɩ dii he. ");
INSERT INTO kma_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dembiŋ diekemba die dɩ jɩɩnana perukusisi die chɩgɩ a ga tɩka sʋŋ aŋaŋ ka tɩŋkpaŋŋɩsɩ a balɩ wɩɩrɩ gie a yɩ ba. Vuosi die dɩ nyɩŋ a ga a ye wudieke die dɩ yine wo. ");
INSERT INTO kma_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Die ba ga Yisa jigiŋ a ye daa dieke die jɩmbɩakʋ die dɩ yalla wa ta ʋ kallɩ wa mi a yeegi nyiŋyeeke ta ʋ sikpeŋ dɩ mɩŋŋɩ a tʋma, ŋmaamɩŋ die dɩ yallɩ ba mana mana. ");
INSERT INTO kma_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vuodiekemba die dɩ yene wudieke die dɩ yine wo die dɩ piili a bala a yɩa vuosi wudieke dɩ yine daa dieke die jɩmbɩakʋ die dɩ yalla wa aŋaŋ perukusisi. ");
INSERT INTO kma_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Die wɩa die vuosi dɩ piili a jʋʋsa Yisa dɩ ʋ nyɩŋ ba tɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yisa die dɩ gana a juu haarɩkʋ ma wa daa dieke die jɩmbɩakʋ die dɩ yalla wa die dɩ jʋʋsɩ wa dɩ, “Vaa manɩŋ aŋaŋ fʋ ga.” ");
INSERT INTO kma_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama Yisa die dɩ ka saagɩya, ta yiŋŋi a balɩ wa dɩ, “Yiŋŋi a ga fʋ dembe jigiŋ a balɩ ba Nabidie Ŋmɩŋ dɩ yaalala fʋ wɩa dene ta piili a yi wudieke a yɩ fʋ.” ");
INSERT INTO kma_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Die wɩa daa wa die dɩ nyɩŋ a ga tɩŋkpaŋŋɩsɩ baŋ wa mana mana a balɩ wudieke Yisa die dɩ yine a yɩ wa wa. Vuodiekemba mana mana die dɩ wʋnna ʋ balɩkʋ die dɩ yi be mamachi. ");
INSERT INTO kma_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisa die dɩ bɩ yiŋŋi a jʋalɩ a ga mʋgɩkpɩɩrɩ gaarɩ mi wo chaaŋ, daadaŋ pam die dɩ keŋ mili wo. ");
INSERT INTO kma_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Daa wʋnyɩ ba wasɩnana Jaarusi, ta die yi Juu vuosi Ŋmɩŋ jɩamɩŋ juoku nyɩŋkʋraha wʋnyɩ die dɩ keŋ mi. Die ʋ dene ye Yisa wa, ʋ nan a gbirigi ʋ dune me, ");
INSERT INTO kma_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ta jʋʋsa wa aŋaŋ nɩŋŋmɩna ta baarɩ dɩ, “N hɔgʋlɩabiŋ faasɩna a yʋagɩ. N jʋʋsa fʋ, keŋ a nagɩ fʋ nuusi a diisi ʋ ma aŋ ʋ ye alaafɩa a bemme ʋ mɩsɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Womi Yisa aŋaŋ wa die dɩ gara, daadaŋ pam die faasɩna a dɩ wa a gara die wɩa die ba kpaŋŋɩ wa jigiŋ mana mana. ");
INSERT INTO kma_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hɔgʋ wʋnyɩ die benne mi zɩŋ dɩ nyɩna ʋ nyɩŋgbanɩŋ ma, die dɩ faasɩ a wʋŋ wa mɩŋ bɩna baŋ aŋaŋ ale. ");
INSERT INTO kma_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Die ʋ paalɩ a ga wa gbɩgbaantɩŋ pam jige dɩ ʋ ye gbaamɩŋ. Die ʋ dii ʋ ligire mana mana a ga kpatɩ, ama ʋ tɩŋ baaŋ nan ye alaafɩaka die dɩ wa a paalɩ a mugise wo daaŋ mana mana. ");
INSERT INTO kma_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Die ʋ wʋnna Yisa wɩa wa die ʋ ga ʋ jigiŋ a dɩɩ ʋ kʋaŋ daadamba sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Die ʋ balɩ a yɩ ʋ gbaŋ dɩ, “Maŋ tɩŋ a ko a bɩagɩ a gbɩ ʋ nyiŋyeekehe gie n tɩŋ nan ye alaafɩa.” ");
INSERT INTO kma_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Die ʋ gbɩ Yisa nyiŋyeekehe gie die ʋ nyɩŋbaŋka zɩmbʋ dɩ gobi bʋnyɩ, die ʋ mɩŋŋɩ ʋ sʋŋ ma sɩba ʋ wahala mana nyɩŋya mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Die dɩ dene a yi, Yisa die dɩ mɩŋŋɩ lagɩ lagɩ sɩba hagɩrɩŋ nyɩŋ ʋ ma ma mɩŋ. Die wɩa die ʋ yiŋŋi a pɩasɩ daadamba dɩ, “Mɩnɩa gbɩna n nyiŋyeekehe?” ");
INSERT INTO kma_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ʋ kʋaŋandɩɩsɩrɩba die dɩ yiŋŋi balɩ dɩ, “Ye daadamba dɩ milinene fʋ die, dɩ bɩa fʋ pɩasa dɩ mɩnɩa gbɩna fʋ?” ");
INSERT INTO kma_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama ta Yisa dɩ ye ko a daansa a tɩanna dɩ ʋ ye vuodieke dɩ yine die wo. ");
INSERT INTO kma_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hɔgʋ wa die dɩ sɩbɩna wudieke die dɩ yine wo die ʋ keŋ a cheele aŋaŋ ŋmaamɩŋ ta gbirigi ʋ dune me a balɩ wusie a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yisa die dɩ balɩ wa, “N lɩa, fʋ yadaka gbaaŋ fʋ. Gamma aŋaŋ sʋgɩdʋagɩŋ, fʋ yʋagɩbʋ kaaŋ bɩ a yiŋŋi a keŋ.” ");
INSERT INTO kma_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisa die dɩ yene ko bala naa wa, tʋntʋntɩŋ bataŋ die dɩ nyɩŋ Jaarusi tigiŋ a keŋ balɩ wa dɩ, “Fʋ lɩa wa yʋagɩbʋ chʋʋsɩya mɩŋ, dɩ bɩa fʋ bɩ a daama dɩdagɩrʋ wa bɩbra?” ");
INSERT INTO kma_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yisa baga die wo ba balɩkʋ sʋŋ ta die a balɩ a yɩ Jaarusi dɩ, “Da vaa ŋmaamɩŋ yalla fʋ, fʋnɩŋ ko tuo dii.” ");
INSERT INTO kma_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Womi die ʋ yi Piita aŋaŋ Jemisi, aŋaŋ Jemisi nɩmbʋa Jɔɔn nyɩɩna ma die dɩ dɩɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Die ba gana a tʋgɩ Jaarusi tigiri, die Yisa die dɩ ye jigiŋ mana die dɩ chine a zie naanyʋŋʋlʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Die ʋ ga a juu a pɩasɩ ba dɩ, “Dɩ bɩa watɩ gie mana? Dɩ bɩa nɩ kʋma? Bʋa wa ka kpiye, ʋ ta ko gʋʋra mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Die ba piili a vʋara wa fala. Die wɩa die ʋ yagɩ ba mana a nyɩŋ ta die a wa bʋa wa chɔɔŋ aŋaŋ ʋ nuŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba ba bataa wa a ga juu jigidieke bʋa wa die dɩ dʋana wa. ");
INSERT INTO kma_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Die ʋ yigi ʋ nuuŋ me ta balɩ a yɩ wa, “Talɩta kumi”, ka chɩaŋ wone “Havʋʋbiŋ n baa fʋ hagɩ.” ");
INSERT INTO kma_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Die ʋ hagɩ bʋnyɩ a dɩdɩ chʋŋ chʋŋ. (Die ʋ yiwo bɩna baŋ aŋaŋ ale bʋa.) Naa die dɩ yine wo, die dɩ paalɩ a yi be mamachi pam. ");
INSERT INTO kma_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ama Yisa dɩ yɩ ba nʋaŋ ta paalɩ balɩ ba dɩ ba daa keŋ a balɩ a yɩ vuoŋ ta balɩ ba dɩ ba yaalɩ jaaŋ a yɩ bʋa wa aŋ ʋ dii. ");
INSERT INTO kma_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisa die dɩ yiŋŋi a ga ʋ tɩŋ, ta ʋ kʋaŋandɩɩsɩrɩba die dɩ dɩ ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Davʋʋsɩkɩrɩ daaŋ die ʋ ga juu Ŋmɩŋ jɩamɩŋ juoku me a piili a daga kpɩkpaakʋ die dɩ benne mi Ŋmɩŋ wɩa. Daadamba die dɩ wʋnna ʋ dagɩkʋ die dɩ yi ba mana mana mamachi, die ba pɩasa taŋ dɩ, “Sɩa ʋ ye wɩaha gie mana? Bɩa yɩaŋ wʋnna Ŋmɩŋ dɩ nagɩ a yɩ wa? Halɩ ʋ tʋmma mamachi tʋʋma. ");
INSERT INTO kma_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Daa ʋ yine kampɩnta ka? Daa Meri bʋa wa wonde? Daa ʋ yine Jemisi aŋaŋ Josefu aŋaŋ Judasi aŋaŋ Simoni mɩɩ wa? Daa ʋ tamba benne giena wa?” Ta ba zeti wo wo. ");
INSERT INTO kma_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Ba yɩa Ŋmɩŋ naazʋa jɩlɩma jigiŋ mana mana mɩŋ ama ʋ gbaŋ gbaŋ ʋ tɩŋ vuosi aŋaŋ ʋ gbaŋ gbaŋ ʋ nɩmballɩ aŋaŋ ʋ gbaŋ gbaŋ deŋ ka yɩa wa jɩlɩma.” ");
INSERT INTO kma_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Die ʋ ka bɩagɩ a tʋŋ mamachi tʋʋma pam mi ama ntaala yʋagɩtielibe bɩta die ʋ bɩagɩ a nagɩ ʋ nuusi a diisi ba ma die ba ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Die dɩ paalɩ yi wo mamachi, die ba wone yadaka wɩa. Womi Yisa die dɩ ga tɩŋkpaŋŋɩsɩ die dɩ benne mi chaakʋ a daga vuosisi. ");
INSERT INTO kma_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Die ʋ wa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a lagɩsɩ taŋ a tʋŋ ba bale bale. Die ʋ yɩ ba yiko dieke die dɩ tɩanna jɩmbɩatɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ta die a yɩ ba nʋarɩ gie dɩ, “Daa nɩ pɔgɩlɩ jaaŋ a gamma nɩ dɩasɩsɩ ntaala, daaŋgbanɩŋ nyɩɩna ma. Nɩ daa keŋ a pɔgɩlɩ nyindiike, nɩ daa keŋ a pɔgɩlɩ bʋlɔgɩŋ nɩ daa keŋ a suu ligire nɩ jafasɩ ma. ");
INSERT INTO kma_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nɩ suu nɩɩra ama nɩ daa keŋ pɔgɩlɩ nyiŋyeeke a gʋtɩ nyiŋyeeki diekemba nɩ balla nɩ yeegi wo me.” ");
INSERT INTO kma_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Die ʋ bɩ a balɩ a gʋtɩ ba dɩ, “Ba keŋ a mɩŋŋɩ a tuo nɩ jigidieke mana mana nɩ bemme tigiri me a ga tʋgɩ saŋŋa dieke nɩ balla nɩ nyɩŋ tɩka ma. ");
INSERT INTO kma_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ama nɩ keŋ a tʋgɩ jigidieke ba keŋ a ka tuo nɩ yaa ba ka wʋŋ nɩ wʋbalɩka nɩ nyɩŋ mi ta pɩsɩ nɩ naatala kɔlɩŋ mi. Aŋ naa yi wɩɩŋ a gbara ba.” ");
INSERT INTO kma_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Die ba nyɩŋ a ga a bala vuosi dɩ ba chɩgɩ a nyɩŋ ba tʋmbɩatɩ ma. ");
INSERT INTO kma_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Die ba vʋarɩ jɩmbɩatɩ pam vuosi me ta die a duuri yʋagɩtieliŋ aŋaŋ kpaaŋ ta die gbaaŋ ba. ");
INSERT INTO kma_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tɔ, Naaŋ Herodi die dɩ wʋŋ Yisa wɩaha gie dama ʋ saaŋ die dɩa wa jigiŋ mana mɩŋ. Vuosi bataŋ die balɩ dɩ Jɔɔn vuodieke dɩ sɩnana vuosi aŋaŋ Ŋmɩŋ nyaabʋ hagɩna kuŋ me a yiŋŋi keŋ. Die wɩa ʋ yaa hagɩrɩbʋ a tʋma mamachi tʋʋmaha gie. ");
INSERT INTO kma_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ama bataŋ die dɩ baarɩ dɩ, “Ʋ yiwo Ŋmɩŋ tʋntʋntʋ Elaja.” Bataŋ dɩ baarɩ dɩ “Ʋ yiwo Ŋmɩŋ tʋntʋntɩba sɩba daa daa saŋka tʋntʋntɩba wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Naaŋ Herodi die dɩ wʋnna die ʋ baarɩ dɩ, “Ʋ yiwo Jɔɔn vuodieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ. Die n yi ba gobi wo ʋ sikpeŋ ama ʋ yiŋŋi a keŋ wo ʋ mɩsɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Naaŋ Herodi gbaŋ gbaŋ die yɩna nʋaŋ dɩ ba yigi Jɔɔn a bɔba wa a nagɩ wa a yi dansarɩka sʋŋ. Herodi die yi wo die dama die wʋnɩŋ Herodi die faarɩ wa Herodiasi vuodieke ʋ kana ka mʋ ʋ faarɩ dama ʋ nɩmbʋa Filipi hɔgʋ die wonde. ");
INSERT INTO kma_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔɔn vuodieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ die ŋaaŋ a bala Herodi daaŋ daaŋ mana dɩ, “Dɩ wo sieŋ aŋaŋ fʋ baaŋ nan faarɩ fʋ nɩmbʋa hɔgʋ.” ");
INSERT INTO kma_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Naa chɩaŋ wɩa die Herodiasi die dɩ jɩɩ sɩnyɩɩrɩŋ a yɩ Jɔɔn, ta die a yaala ʋ kʋʋ wa, ama Herodi wɩa die ʋ ka bɩagɩ, dama Herodi gbaŋ die ka saaga. ");
INSERT INTO kma_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodi die chɩga Jɔɔn, dama die ʋ sɩba a baarɩ Jɔɔn die yiwo vuovɩɩnɩŋ ta dɩgɩntɩ die dɩ wo ʋ sʋŋ. Die wɩa die ʋ ka yaala wɩɩŋ yi wo. Aŋaŋ die ʋ ŋaana wʋŋ Jɔɔn wʋbalɩkaha a daama wa mana yɔrɩ, die ʋ ŋaaŋ yaala ʋ wʋmma ʋ wʋbalɩka. ");
INSERT INTO kma_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kʋaŋ kʋaŋ chaaŋ die Herodiasi daaŋ die dɩ keŋ. Herodi maarɩŋ daraaŋ die dɩ keŋ tʋgɩ, die ʋ digi nyindiike pam ta wa tɩka nyɩŋkʋraha mana aŋaŋ sojasi nyɩŋkʋraha aŋaŋ Galili tɩŋ nyɩŋkʋraha a lagɩsɩ taŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Die Herodiasi hɔgʋlɩa die dɩ keŋ a sie dɩ paalɩ a yi naaŋ Herodi aŋaŋ ʋ chaamba mana mana sʋgɩtɩ die dɩ fɩalɩ. Naa chɩaŋ wɩa die naaŋ wa die dɩ pɩasɩ havʋʋbike dɩ, “Bɩa fʋ yaala n yɩ fʋ? N nan yɩ fʋ jadieke mana mana fʋ yaalala.” ");
INSERT INTO kma_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A kaa kaatɩ pam ta a balɩ a yɩ bʋa wa “N hʋʋya, jadieke mana mana fʋ yaalala, n nan yɩ fʋ halɩ fʋ yaala n puo n naarɩ a nagɩ bʋnyɩ a yɩ fʋ n nan yi.” ");
INSERT INTO kma_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Die wɩa die bʋa wa die dɩ nyɩŋ a ga pɩasɩ ʋ nuŋ dɩ, “N baarɩ n yaala bɩa?” Ʋ yiŋŋi a balɩ wa dɩ, “Baarɩ dɩ yaala Jɔɔn dieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ sikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Die wɩa die bʋa wa dɩ chɩgɩ a ga naaŋ wa jigiŋ lagɩ lagɩ a baarɩ dɩ, “N yaala fʋ gobi Jɔɔn dieke die dɩ sɩnana vuosisi Ŋmɩŋ nyaabʋ sikpeŋ a diisi kpalɩ ma a yɩ mɩŋ lelele.” ");
INSERT INTO kma_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Naa die dɩ yi naaŋ wa sʋŋ die dɩ paalɩ a chʋʋsɩ pam, ama die ʋ kaaŋ bɩagɩ a zeti dama ʋ kaana kaatɩ diekemba ʋ chaamba nɩŋŋa wa wɩa. ");
INSERT INTO kma_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Die wɩa die ʋ yi vuodiekemba die dɩ gbarɩna wa wʋnyɩ nʋaŋ dɩ ʋ yaa Jɔɔn sikpeŋ a keŋ lagɩ lagɩ. Tʋntʋntʋ wa die dɩ nyɩŋ a ga dansarɩka sʋŋ a gobi Jɔɔn sikpeŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A die a nagɩ ka a diisi kpalɩ ma a yallɩka a keŋ a yɩ havʋʋbike, havʋʋbike die dɩ nagɩ ka a yɩ ʋ nuŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Die Jɔɔn kʋaŋandɩɩsɩrɩba die dɩ wʋnna, die ba ga a nagɩ Jɔɔn nyɩŋgbaŋka a ga guu. ");
INSERT INTO kma_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yisa tʋntʋntɩba baŋ aŋaŋ bale die ʋ tʋnna wa die dɩ yiŋŋi a keŋ a balɩ wa wudiekemba mana ba yine aŋaŋ ba dagɩna. ");
INSERT INTO kma_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Vuosi pam die kienene ta yiŋŋe, die wɩa die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die wo saŋŋa aŋaŋ ba baaŋ nan dii nyindiike. Die wɩa die Yisa die dɩ balɩ a yɩ ba dɩ, “Nɩnɩŋ nɩ vaa aŋ tɩ ga haagɩyeŋ dieke nɩ baaŋ nan voosi.” ");
INSERT INTO kma_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Die wɩa die ba gbaŋ gbaŋ die ba juu haarɩŋ a gara jigidieke vuoŋ die dɩ wone. ");
INSERT INTO kma_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama daadaŋ pam die dɩ ye be ba ganana, a mɩŋŋɩ ba. Die wɩa die ba chɩgɩ aŋaŋ nagɩsɩ a nyɩŋ tɩgɩsɩ mana mana, a woliŋ a ga a tʋgɩ jigidieke Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ ganana wa. ");
INSERT INTO kma_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Die Yisa die dɩ nyɩnna haarɩkʋ sʋŋ ta die a ye kpɩkpaakʋ ba wɩa dɩ yaa wa zɔɔlɩŋ, dama die ba nɩasɩ wa yii diekemba dɩ wone yiyagɩrʋ. Die wɩa die ʋ piili a daga ba wɩa pam. ");
INSERT INTO kma_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Die jɩŋmɩŋ die dɩ tʋgɩna, die ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ a balɩ yɩ wa dɩ, “Ŋmɩnnɩ wɔŋ a juu mɩŋ ta giena dɩaŋ dɩ yi jigidieke jadiikiŋ dɩ worine ba baaŋ daa a dii. ");
INSERT INTO kma_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Vaa vuosi ga tɩŋkpaŋŋɩsɩ aŋaŋ kʋaŋ diekemba dɩ gbigine giena wa a yaalɩ jaaŋ a dii ba gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Nɩnɩŋ nɩ gbaŋ gbaŋ nɩ yaalɩ jaaŋ a yɩ ba aŋ ba dii.” Die ba pɩasɩ wa, yaala tɩ nagɩ sɩba dʋnɩa mana ligire a yaalɩ jaaŋ a yɩ ba aŋ ba dii? ");
INSERT INTO kma_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naa chɩaŋ wɩa die Yisa die dɩ pɩasɩ ba dɩ, “Paanʋsɩ aŋmɩa nɩ yallɩ? Nɩ ga a ga daansɩ a ye.” Die ba gana a ga daansɩ ta yiŋŋi a keŋ wo die ba balɩ a yɩ wa dɩ, “Paanʋsɩ anʋ aŋaŋ zaasɩtɩ ale.” ");
INSERT INTO kma_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yisa die dɩ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ ba yi vuosisi mana puo puo a lagɩsɩ a kala kala hɔɔyebiti me. ");
INSERT INTO kma_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Die wɩa die ba lagɩsɩ a kalɩ kalɩ, bataŋ baŋɩsɩ-nʋ nʋ bataŋ dɩaŋ kɔbɩga kɔbɩga. ");
INSERT INTO kma_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Womi Yisa die dɩ nagɩ paanʋsɩ anʋ wa aŋaŋ zaasɩtɩ ale wo, a daansɩ ŋmɩŋsikpeŋ ta pagɩ Ŋmɩŋ. Ʋ yi paanʋsɩsɩ a gbieri gbieri ta nagɩha a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ ba tuohe a tɩa tɩa a yɩ vuosisi. Die ʋ bɩ nagɩ zaasɩtɩtɩ ale wo a gbieri gbieri a yɩ ba mana mana. ");
INSERT INTO kma_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ba mana mana die dɩ dii a chagɩ, ta tɩalɩ tɩalɩ. ");
INSERT INTO kma_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ vaarɩ vaarɩ paanʋsɩ aŋaŋ zaasɩtɩ tɩalɩkaha a suuli kparɩsɩ baŋ aŋaŋ ale. ");
INSERT INTO kma_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dembiŋ diekemba die dɩ ŋɔbɩna paanʋsɩsɩ aŋaŋ zaasɩtɩtɩ die yiwo dembisi tuse tuse anʋ. ");
INSERT INTO kma_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yisa die dɩ yi ʋ kʋaŋandɩɩsɩrɩba die dɩ juu haarɩkʋ lagɩ lagɩ a dɩ ʋ nɩŋŋa a gara mʋgɩkpɩɩrɩ gaarɩ a ga Befisada, ta die ʋ wa a taanna vuosisi. ");
INSERT INTO kma_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Die ʋ taanna vuosisi a kpatɩ wa die ʋ jʋalɩ ga kunkogiŋ me dɩ ʋ jʋʋsɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Die jɩŋmɩŋ die dɩ tʋgɩna, haarɩkʋ die bie wo mʋgɩkpɩɩrɩ sʋŋ aŋaŋ sʋŋ ta Yisa dɩ a ye bie tɩŋgbaŋ ma ʋ nyɩɩna. ");
INSERT INTO kma_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Die ʋ ye ta ʋ kʋaŋandɩɩsɩrɩba die wahala aŋaŋ haarɩkʋ dɔmɩŋ, dama bʋlɔgɩsɩŋ die nɩgɩnana ba a gara kʋaŋ kʋaŋ. Die wɩa die dɩ gana a tʋgɩ kparaasɩ kpaŋ sʋkʋleeliŋ, Yisa die dɩ chʋŋ nyaabʋ sikpeŋ a kieŋ ba jigiŋ. Die ʋ chʋŋ a tɩanna ba ma ");
INSERT INTO kma_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ama die ba ye wo ta ʋ chʋŋ nyaabʋ sikpeŋ. Die ba yene dɩ ʋ chʋŋ nyaabʋ sikpeku die ba keesi ta yi tama sɩba dɩ yiwo kogiŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dama die ba mana die dɩ yene wo ŋmaamɩŋ die yigine be. Yisa die dɩ a balɩ a yɩ ba bʋnyɩ dɩ, “Nɩ yigi sikimiŋ, wo manɩŋ nɩ da vaa ŋmaamɩŋ yigi nɩ.” ");
INSERT INTO kma_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Womi die ʋ juu a gʋtɩ ba ma haarɩkʋ ma, bʋlɔgɩsɩbʋ die dɩ nan sɔmm. Die dɩ paalɩ a yi ʋ kʋaŋandɩɩsɩrɩba mamachi pam ");
INSERT INTO kma_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","dama die ba ka sɩba die ʋ nagɩ paanʋsɩsɩ a yɩ vuosisi ba dii wo chɩaŋ. Ba sʋgɩtɩ ye ko bie wo lɩmɩŋ ma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Die ba ga a ga a tʋgɩ mʋgɩkpɩɩrɩ gaarɩ a keŋ jʋalɩ Genezariti tɩŋgbaŋ ma, a bɔbɩ haarɩkʋ mi. ");
INSERT INTO kma_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Die ba nyɩnana haarɩkʋ ma vuosisi die dɩ mɩŋŋɩ Yisa bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naa chɩaŋ wɩa die ba chɩgɩ ga juu tɩŋgbaŋka mana a chii yʋagɩtieliŋ a diisi ba kalɩŋasɩ sikpeŋ a ga jigidieke mana die ba wʋnna dɩ Yisa gaya wa. ");
INSERT INTO kma_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jigidieke mana die ʋ gana tɩŋkpaŋŋɩsɩ yaa tɩŋkpɩɩma vuosi ŋaaŋ chii wo ba yʋagɩtieliŋ a ga nyugiti ma ta jʋʋsa wa dɩ ʋ ko a vaa yʋagɩtielibe gbɩ ʋ nyiŋyeeke kʋanʋaŋ, vuodiekemba mana mana die dɩ gbɩna ka die ye wo alaafɩa. ");
INSERT INTO kma_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tɔ, Farasisi aŋaŋ mɩra dɩdagɩrɩba bataŋ die dɩ nyɩnna Jerusalemi a keŋ die dɩ taaŋ giliŋ Yisa atɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Die ba daansɩ a ye ta ʋ kʋaŋandɩɩsɩrɩba die nyindiike aŋaŋ nuudɩgɩnta. Dama die ba ka nɩtɩ ba nuusi sɩba Farasisi vuosi die dɩ bala dɩ vuosi nɩtɩma ba nuusi die wo. ");
INSERT INTO kma_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Dama Farasisi aŋaŋ Juu vuosi mana die ka die nyindiike yɔrɩ yɔrɩ sie ba wɔŋ nɩtɩ ba nuusi vɩɩnɩŋ sɩba die ba chɔɔŋkʋʋlɩŋ mɩra dɩ dagɩna die wo.) ");
INSERT INTO kma_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba keŋ nyɩŋ nyugiti jige a keŋ, ba ka die sie ba nɩtɩ ba nuusi ta dɩɩsa ba chɔɔŋkʋʋlɩŋ wɩa, sɩba nyanyuule kpala daarɩŋ aŋaŋ gbiesi daarɩŋ aŋaŋ kalɩŋasɩ sugiriŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Naa chɩaŋ wɩa die Farasisi aŋaŋ mɩra dɩdagɩrɩba die dɩ pɩasɩ Yisa dɩ bɩa yine fʋ kʋaŋandɩɩsɩrɩba dɩ ka dɩɩsa sie diekemba tɩ chɔɔŋkʋʋlɩba die dɩ nagɩna a yɩ tɩ wa ta die nyinti aŋaŋ nuudɩgɩnta. ");
INSERT INTO kma_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Ŋmɩŋ naazʋa Azaya die yaa wusie die ʋ bala nɩnɩŋ gɩgaantɩba gie wɩa sɩba ka maagɩna die wo dɩ: ‘Ŋmɩŋ baarɩ dɩ vuosi gie yɩa mɩŋ jɩlɩma aŋaŋ ba nʋa ama ba sʋgɩtɩ dɩ bie saasaa aŋaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dɩ yi wo yɔrɩ ba jɩama mɩŋ dama ba daga vuota ba gbaŋ gbaŋ ba mɩra sɩba a yiwo manɩŋ n mɩra.’ ” ");
INSERT INTO kma_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nɩ zeti wo Ŋmɩŋ mɩra ta dɩɩsa vuotaŋ mɩra. ");
INSERT INTO kma_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yisa die dɩ bɩ a balɩ a gʋtɩ ba dɩ “Nɩ yaa wa yɩaŋ sɩbɩŋ a zeti Ŋmɩŋ mɩra ta bɩagɩ a daga nɩ gbaŋ gbaŋ nɩ yaala wudiekemba. ");
INSERT INTO kma_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosisi die baarɩ dɩ, ‘Yɩma fʋ chʋa aŋaŋ fʋ naa jɩlɩma vuodieke nɩŋ mana dɩ keŋ a kaa kaatɩ a yɩ ʋ chɔɔŋ yaa ʋ nuŋ mʋ ba kʋʋ wa mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama nɩnɩŋ nɩ baarɩ dɩ ‘Vuoŋ dɩ keŋ a balɩ a yɩ ʋ chɔɔŋ yaa ʋ nuŋ dɩ jadieke mana dɩ yine n sɩɩtɩ maŋ tɩŋ nan nagɩ a suŋŋi nɩ bɩrɩŋ wa Ŋmɩŋ jaaŋ.’ ");
INSERT INTO kma_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Die nɩŋ nɩnɩŋ Farasisi yɩa vuosi sieŋ dɩ ba da keŋ suŋŋi ba chʋalɩŋ yaa ba nɩɩlɩŋ nɩ dagɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naa dɩ a keŋ a yi die nɩŋ nɩ chʋsa Ŋmɩŋ wʋbalɩkaha, nɩ dagɩnana vuosi die wo sʋŋ. Nɩ yie wɩa pam a nɩasa die.” ");
INSERT INTO kma_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Womi Yisa die dɩ bɩ a wa daadamba bɩbra a keŋ ʋ jigiŋ, ta balɩ a yɩ ba dɩ, “Nɩ mana mana chɩɩsɩma a wʋmma mɩŋ ta sɩmma n wʋbalɩkaha chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jadieke vuotaŋ dɩ dinene a yie ʋ sʋŋ ma ka bɩagɩ a yie wo dɩgɩntɩ ama wudieke dɩ nyɩnnana ʋ nʋaŋ ma yine ʋ yaa dɩgɩntɩ. ");
INSERT INTO kma_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","((Naa chɩaŋ ma vuodieke mana dɩ yaa tɩbɩŋ a nan wʋŋ ʋ wʋmma.))” ");
INSERT INTO kma_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Die ʋ vana daadamba ta kuli tigiŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasɩ wa nandagɩrɩ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yisa die dɩ pɩasɩ ba dɩ, “Nɩ gbaŋ nɩ ka sɩba ka chɩaŋ? Nɩ ka sɩba sɩba dɩ jadieke dɩ junene vuotaŋ nʋaŋ ma ka bɩagɩ yie wo ʋ yalla dɩgɩntɩ. ");
INSERT INTO kma_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dama a juu wo ʋ nyuuti ma a daaga nyɩŋgbaŋka a nyɩnna ama da ʋ sʋŋ ma.” (Yisa balɩkʋ die dagɩya sɩba jadiikiŋ mana ka chʋarɩ.) ");
INSERT INTO kma_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Die ʋ ye a ko bala a gʋta dɩ “Wudieke dɩ nyɩnnana vuotaŋ sʋŋ yine ʋ yaa dɩgɩntɩ. ");
INSERT INTO kma_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dama ʋ sʋŋ ma sʋŋanyilibɩatɩ sɩba hɔɔŋ yaalɩŋ aŋaŋ dembisi yaalɩŋ, aŋaŋ gaarɩŋ aŋaŋ vuotaŋ kʋʋla, ");
INSERT INTO kma_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aŋaŋ jome aŋaŋ kalinbaani aŋaŋ sugigoliŋ wuyiike aŋaŋ halɩ aŋaŋ gaanta aŋaŋ baga wori wuyiike. ");
INSERT INTO kma_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wʋbɩatɩ gie mana mana nyɩnna vuotaŋ sʋŋ a yie wo ʋ bɩrɩma vuodɩgɩntɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisa die dɩ nyɩŋ mi a ga tɩŋ kaanɩ die dɩ bene Taya tɩŋgbaŋ ma, die ʋ ga a juu tigiŋ kaanɩ sʋŋ ta die a ka yaala vuoŋ ye wo, ama die ʋ ka bɩagɩ a lɔbɩrɩ ʋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Hɔgʋ wʋnyɩ die benne mi ta jɩmbɩatɩ die dɩ yallɩ ʋ havʋʋbiŋ, die ʋ wʋnna dɩ Yisa die bie mi die ʋ chɩgɩ a keŋ gbirigi Yisa nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hɔgʋ wa die ka yi Juu vuoŋ, die ba mɩɩrɩ wa wa Fonisia, Siria tɩŋgbaŋ ma ma. Die ʋ jʋʋsɩ Yisa dɩ ʋ yagɩ jɩmbɩatɩtɩ ʋ bʋa wa ma ma. ");
INSERT INTO kma_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ama Yisa die yiŋŋi a balɩ wa dɩ, “Vaa tɩ woliŋ a yɩ ballɩbɩsɩ ba nyindiike, dɩ wo sieŋ aŋaŋ tɩ baaŋ nan nagɩ ballɩbɩsɩ nyindiike a yɩ gbaasɩ.” ");
INSERT INTO kma_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hɔgʋ wa die dɩ yiŋŋi a baarɩ dɩ, “N Yɔmʋtieŋ, ka yiwo wusie, ama gbaasɩsɩ die dɩ dʋana teebulisi chɩaŋ gbaŋ naga ballɩbɩsɩ nyindiike chɔɔta die dɩ nannana.” ");
INSERT INTO kma_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naa chɩaŋ wɩa Yisa die dɩ balɩ a yɩ hɔgʋ wa dɩ, “Fʋ mɩŋŋɩna balɩ balɩkʋ gie wɩa nan bɩagɩ a kuli, jɩmbɩakʋ nyɩŋ fʋ bʋa wa ma mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Die ʋ yiŋŋi a kuli ta ʋ bʋa wa dʋa gado sikpeŋ jɩmbɩatɩtɩ die dɩ seŋ a nyɩŋ ʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisa die dɩ wa a nyɩŋ Taya tɩŋgbaŋ ma a daagɩ Sadoni a chʋŋ a daagɩ tɩgɩsɩ baŋka sʋgɩtɩ a ga Galili mʋgɩkpɩɩrɩ ma. ");
INSERT INTO kma_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Vuosi bataŋ die dɩ yaa daa wʋnyɩ die dɩ kana a ka mɩŋŋɩ bala wɩa a keŋ Yisa jigiŋ a jʋʋsɩ wa dɩ ʋ nagɩ ʋ nuusi a diisi ʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yisa die dɩ yigi daa wa nuuŋ me a yaa wa nyɩŋ lʋgɩŋ ta vaa daadamba. Yisa die dɩ nagɩ ʋ nuubisi a yi daa wa tɩba ma, ta tɩɩrɩ nɩntɔbɩtɩ ta gbɩ daa wa jiliŋ. ");
INSERT INTO kma_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Womi Yisa die dɩ daansɩ ŋmɩŋsikpeŋ ta paalɩ a voosi ta a balɩ a yɩ wa dɩ, “Effata!” Ka chɩaŋ wone, “Yuori!” ");
INSERT INTO kma_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Daa wa tɩbaha sʋŋ die dɩ yuori bʋnyɩ ʋ wʋmma wʋbalɩka ta bɩagɩ a bala wɩa vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Womi Yisa die dɩ yɩ ba mana mana nʋaŋ dɩ ba sɩmma ba keŋ a balɩ wɩɩrɩ mi a yɩ vuoŋ. Ama saŋŋa dieke mana die Yisa dɩ a keŋ a balɩ die, die dɩ wana a faasɩ a yie ba bala wɩɩrɩ jigiŋ mana. ");
INSERT INTO kma_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vuodiekemba mana die dɩ wʋnna die dɩ yi be mamachi pam pam. Die ba baarɩ dɩ, “Ʋ mɩŋŋɩ a yi wɩɩrɩ mana vɩɩnɩŋ vɩɩnɩŋ. Halɩ ʋ yi vuodiekemba mana dɩ kana a ka bɩagɩ a wʋmma wɩa dɩ wʋmma ta vuodieke dɩ kana ka bɩagɩ bala wɩa dɩ bala.” ");
INSERT INTO kma_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Die dɩ ka yʋasɩya ta daadaŋ pam bɩbra die dɩ keŋ a lagɩsɩ Yisa jigiŋ. Jadiikiŋ die wori aŋaŋ ba baaŋ dii, Yisa die dɩ wa ʋ kʋaŋandɩɩsɩrɩba a balɩ a yɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Zɔɔlɩŋ yigi mɩŋ mɩŋ pam aŋaŋ vuosi gie dama manɩŋ aŋaŋ ba daraa ataa wʋnna, ba ka bɩ yaa jaaŋ aŋaŋ ba baaŋ dii. ");
INSERT INTO kma_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Maŋ keŋ yi ba kuli ta ka dii jaaŋ bataŋ nan chaa sieŋ me dama ba nyɩŋ wa saasaa.” ");
INSERT INTO kma_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ʋ kʋaŋandɩɩsɩrɩba dɩ pɩasɩ wa dɩ, “Haagɩrɩ gie me, sie vuoŋ dɩ baa ʋ ye jaaŋ a yɩ daadamba gie mana aŋ ba dii?” ");
INSERT INTO kma_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ʋ pɩasɩ ba dɩ, “Paanʋsɩ aŋmɩa nɩ yallɩ?” Ba baarɩ dɩ, “A bayʋpɔyɩ.” ");
INSERT INTO kma_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yisa die dɩ balɩ daadamba dɩ ba sʋʋŋ kala tɩŋgbaŋ, ta nagɩ paanʋsɩ ayʋpɔyɩ wa a bɩrɩ Ŋmɩŋ, ta yi tɩa tɩa a nagɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ ba nagɩ a yɩ daadamba, ba yi dene. ");
INSERT INTO kma_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Die ba bɩ yaa zaasɩbɩsɩ bɩta ba jigiŋ. Yisa dɩ nagɩha a bɩrɩ Ŋmɩŋ ta nagɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ ba bɩ tuo a tɩa tɩa a yɩ daadamba. ");
INSERT INTO kma_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vuoŋ mana die diye mɩŋ ta tɩalɩ tɩalɩ, vuosisi die yiwo sɩba vuosi tuse tuse anɩɩsa. ");
INSERT INTO kma_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ʋ kʋaŋandɩɩsɩrɩba die dɩ vaarɩna nyindiike tɩalɩkaha, die a suuli wo kparɩsɩ ayʋpɔyɩ. Yisa die dɩ wa taaŋ vuosisi ba kuli, ");
INSERT INTO kma_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ta die wa juu haarɩŋ lagɩ lagɩ wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba ba ga Dalimanuta tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasisi bataŋ die dɩ keŋ ʋ jigiŋ, a piili nɩga nɩnhagɩrɩŋ. Die ba yaala ba yigi wo mɩŋ, die wɩa die ba baarɩ dɩ ʋ yi mamachi a dagɩ sɩba Ŋmɩŋ tʋnna wa. ");
INSERT INTO kma_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yisa dɩ voosi pam ta pɩasɩ, dɩ bɩa lele gie vuosi dɩ pɩasa a yaala mamachi tʋʋma? Ʋ baarɩ dɩ wusie, n kaaŋ yi mamachi wɩɩŋ aŋ vuosi gie ye. ");
INSERT INTO kma_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta die ʋ va ba ta yiŋŋi a juu haarɩkʋ ba nagɩ ga a gara mʋgɩkpɩɩrɩ gaarɩ kaanɩ wa ma. ");
INSERT INTO kma_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Die ʋ kʋaŋandɩɩsɩrɩba die daaŋya aŋaŋ ba baaŋ pɔgɩlɩ nyindiike. Die ba pɔgɩlɩ wa paanʋ balɩmɩŋ nyɩɩna haarɩkʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yisa die dɩ yɩ ba nʋaŋ a baarɩ, dɩ ba sɩmma Farasisi aŋaŋ Herodi vuosi wɩa. ");
INSERT INTO kma_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Die ba piili a bala a yɩa tamba, ʋ balla naa dama tɩ wo paanʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yisa die dɩ mɩŋŋɩ ba wʋbalɩkaha, ta pɩasɩ ba, dɩ bɩa nɩ bala sɩba nɩ wo paanʋ wɩa? Nɩ ye ka yeye, yaa nɩ ye ka sɩba, dɩ bɩa nɩ wo sʋŋanyile dene? ");
INSERT INTO kma_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nɩ yaa nine, ama nɩ ka yese. Nɩ yaa tɩba, ama bɩa wɩa nɩ ka wʋmma? Nɩ ka tɩɩnsa ");
INSERT INTO kma_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","die n nagɩna paanʋsɩ anʋ a puo puo a yɩ vuosi tuse anʋ wa nyintɩalɩkaha kparɩsɩ aŋmɩa die nɩ vaarɩ a suuli? Ba baarɩ “Kparɩsɩ baŋ-ale.” ");
INSERT INTO kma_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta die n nagɩna paanʋsɩ ayʋpɔyɩ a puo puo a yɩ vuosi tuse anɩɩsa wa nyintɩalɩkaha kparɩsɩ aŋmɩa die nɩ vaarɩ? Ba baarɩ kparɩsɩ ayʋpɔyɩ ");
INSERT INTO kma_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ʋ pɩasɩ ba, ta nɩ ye ka sɩba? ");
INSERT INTO kma_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Die ba tʋgɩna Befisada ma vuosi bataŋ die yaa dembiŋ yɩɩ a keŋ jʋʋsɩ wa, ta baarɩ dɩ ʋ gbɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Die ʋ yigi yɩɩ wa nuuŋ me a yaa wa nyɩŋ tɩka ma. Atɩɩrɩ nɩntɔbɩtɩ a yi yɩɩ wa nine me, ta nagɩ ʋ nuusi a diisi ʋ ma ta pɩasɩ wa dɩ, “Bɩagɩ ye jaaŋ mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Daa wa dɩ daansɩ sikpeŋ ta baarɩ dɩ, “Wa, n ye vuosi ama ba nɩasɩ wa tɩɩsɩ dɩ dɩna dɩ chʋŋ chʋŋ.” ");
INSERT INTO kma_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yisa dɩ bɩ nagɩ ʋ nuusi a diisi daa wa ninehe me, saŋka mi nɩŋ daa wa nine dɩ yuori, ʋ ye jaaŋ mana kasɩ. ");
INSERT INTO kma_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yisa dɩ balɩ wa dɩ ʋ kulime ta yɩ wa nʋaŋ dɩ, “Da keŋ yiŋŋi ga tɩka ma.” ");
INSERT INTO kma_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die gara tɩŋkpaŋŋɩsɩ die dɩ gbigine Siisiria Filipi tɩŋ ma. Sieku me ʋ pɩasɩ ba dɩ, “Nɩ balɩ mɩŋ, mɩnɩa vuosi dɩ baarɩ n yi ye?” ");
INSERT INTO kma_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba baarɩ dɩ, “Bataŋ baarɩ yiwo Jɔɔn die dɩ kenne a keŋ a sɩɩ vuosi Ŋmɩŋ nyaabʋ, bataŋ dɩaŋ dɩ baarɩ Elaja, ta bataŋ dɩaŋ dɩ baarɩ yiwo Ŋmɩŋ tʋntʋntʋ wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yisa dɩ pɩasɩ ʋ kʋaŋandɩɩsɩrɩba ta “Nɩnɩŋ nɩŋ mɩnɩa nɩ baarɩ n yiye?” Piita dɩ baarɩ dɩ, “Yiwo Gbɩgbatɩtaantʋ Masiaka.” ");
INSERT INTO kma_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mi, Yisa dɩ yɩ ba nʋaŋ dɩ, “Nɩ da keŋ a balɩ vuoŋ n wɩa.” ");
INSERT INTO kma_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ta wa piili a daga ʋ kʋaŋandɩɩsɩrɩba dɩ, “Sie manɩŋ vuota Bʋadembike dii wahala pam, ta nyɩŋkʋra aŋaŋ Ŋmɩŋ kɩkaabɩtɩba aŋaŋ Ŋmɩŋ tigiri me mɩra dɩdagɩrɩba keŋ zeti mɩŋ, a bɩ kʋʋ mɩŋ ama daraa ataa daraaŋ n nan hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Die ʋ paalɩ balɩ ba mɩŋ, die ʋ ka lɔbɩrɩ ba. Die Piita die dɩ yaa wa ga lʋgɩŋ a ga galɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama Yisa dɩ yiŋŋi a daansa ʋ kʋaŋandɩɩsɩrɩba ta kpaaŋ Piita a baarɩ dɩ, “Fʋnɩŋ Sitaani wa gie hagɩ giena. Fʋ sʋŋanyile yiwo vuota sʋŋanyile daa Ŋmɩŋ sʋŋanyile.” ");
INSERT INTO kma_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yisa die dɩ wa wa daadamba aŋaŋ ʋ kʋaŋandɩɩsɩrɩba a balɩ ba dɩ, “Vuodieke mana dɩ keŋ a yaala ʋ dɩa n kʋaŋ sie ʋ daaŋ ʋ gbaŋ gbaŋ ʋ wɩa ta nagɩ ʋ kuŋ dagarɩkɩŋ a dɩa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vuodieke nɩŋ mana dɩ yaalala ʋ gbatɩ ʋ gbaŋ gbaŋ ʋ miivoli nan waarɩ ka, ama vuodieke dɩ a keŋ waarɩ ʋ miivoli n wɩa aŋaŋ Ŋmɩŋ wʋvɩɩna wɩa nan ye ke. ");
INSERT INTO kma_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bɩa vuoŋ dɩ baa ʋ ye, ʋ keŋ a ye dʋnɩa mana mana nyinti ta waarɩ ʋ miivoli? Wusie ");
INSERT INTO kma_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jaaŋ wori vuotaŋ dɩ nan bɩagɩ a nagɩ a gbatɩ ʋ miivoli. ");
INSERT INTO kma_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lele gie vuosi yi wo bɩaŋ ta ka dɩa Ŋmɩŋ. Vuodieke dɩ a keŋ chɩga viivi a ka balɩ manɩŋ aŋaŋ n dagɩkʋ gie vuosi gie jigiŋ, die nɩŋ manɩŋ vuota Bʋadembiŋ nan daaŋ chɩgɩ dɩ tieŋ gbaŋ viivi maŋ keŋ keŋ aŋaŋ n Chʋa Ŋmɩŋ hagɩrɩŋ aŋaŋ ʋ kasɩ malakasisi dɩ n yaa wa a ga gʋtɩ n vuosi me.” ");
INSERT INTO kma_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisa dɩ bɩ balɩ ba dɩ, “N bala nɩ, bataŋ bie giena ba kaaŋ kpi ntaala ba keŋ a ye Ŋmɩŋ naarɩ keniŋ aŋaŋ ka hagɩrɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Daraa ayʋaba kʋaŋ chaaŋ Yisa dɩ wa Piita aŋaŋ Jemisi aŋaŋ Jɔɔn, a dɩ ba nɩŋŋa a yaa ba a jʋalɩ taŋkpeŋkpɩɩŋ sikpeŋ, jigidieke vuoŋ die dɩ wone mi. Die ba daansɩnana ba keŋ a ye ta Yisa tarɩgɩya mɩŋ, ");
INSERT INTO kma_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ʋ nyɩŋsuuke die dɩ yɩantɩ ta nyɩgɩsa, a paalɩ yɩantɩ tɩaŋ vuota dɩ baaŋ nan bɩagɩ a sugiri jaaŋ ka yɩantɩ die dʋnɩa ma. ");
INSERT INTO kma_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mi ʋ kʋaŋandɩɩsɩrɩba Piita aŋaŋ Jɔɔn aŋaŋ Jemisi dɩ ye Elaja aŋaŋ Mosisi vuodiekemba die dɩ kpine kʋrɩŋ ma wa aŋaŋ Yisa dɩ balala wɩa. ");
INSERT INTO kma_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Die wɩa, Piita die dɩ balɩ Yisa dɩ, “Dɩdagɩrʋ, dɩ vɩɩna tɩ benne giena. Tɩ nan kpii viisi ataa, fʋ kaanɩ, Mosisi kaanɩ, Elaja dɩaŋ kaanɩ.” ");
INSERT INTO kma_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ŋmaamɩŋ die faasɩna a yigi ʋ kʋaŋandɩɩsɩrɩba wɩa, Piita die dɩ zɩ ʋ baaŋ balɩ die. ");
INSERT INTO kma_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Womi nɩɩŋmara dɩ keŋ sʋʋŋ ligi be, ta lɔlɩŋ dɩ nyɩŋ nɩɩŋmaraha ma ma a bala dɩ, “N Bʋadembiŋ dieke n chone wʋnna, nɩ wʋmma a yɩma wa.” ");
INSERT INTO kma_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Die ba yiŋŋi a daansɩ lʋga lagɩ lagɩ ta ba ka ye vuoŋ sie banɩŋ aŋaŋ Yisa nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Die ba kenne a sʋʋna tanɩ ma wa, Yisa dɩ yɩ ba nʋaŋ dɩ, “Da nɩ keŋ a balɩ vuoŋ nɩ yene die, sie manɩŋ vuota Bʋadembiŋ dɩ keŋ a hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Die ba saagɩ a yɩ wa ama ta wa piili a bala tamba wɩɩrɩ wɩa, ta baarɩ dɩ, “Ʋ balala kumbu hagɩŋ ma wa, ka chɩaŋ?” ");
INSERT INTO kma_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lele mi ba pɩasɩ Yisa dɩ, “Bɩa yine Ŋmɩŋ mɩra dɩdagɩrɩba dɩ baarɩ sie Elaja woliŋ keŋ ta ka kʋaŋ chaaŋ Masia wa dɩaŋ keŋ?” ");
INSERT INTO kma_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yisa dɩ baarɩ dɩ, “Wusie Elaja baa ʋ woliŋ keŋ mɩŋ a keŋ wʋnsɩ wɩɩŋ mana a zieŋ, ta bɩa Ŋmɩŋ wɩa dɩ wa daga sɩba vuota Bʋadembiŋ nan faasɩ gbalɩgɩ ta ba bɩ zeti wo? ");
INSERT INTO kma_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nɩ vaa n balɩ nɩ, Elaja wɔŋ keŋ mɩŋ vuosi dɩ yi wo ba dʋŋŋʋ sɩba Ŋmɩŋ wʋbalɩka die dɩ dagɩna ʋ wɩa die wo.” ");
INSERT INTO kma_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Die banɩŋ ba ga haarɩ ʋ kʋaŋandɩɩsɩrɩŋ tɩalɩkaha ta daadaŋ giliŋ be, Ŋmɩŋ mɩra dɩdagɩrɩba bataŋ dɩ nɩga nɩnhagɩrɩŋ aŋaŋ ba. ");
INSERT INTO kma_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Die vuosisi dɩ yene Yisa dɩ faasɩ a yi be wuboŋkeŋ ba chɩgɩ ga ʋ jigiŋ a waasɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yisa dɩ pɩasa ʋ kʋaŋandɩɩsɩrɩba dɩ bɩa wɩɩŋ wɩa nɩ ŋaŋ ba dɩ nɩga nɩnhagɩrɩŋ? ");
INSERT INTO kma_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Daadamba sʋŋ daa wʋnyɩ dɩ baarɩ dɩ, “Dɩdagɩrʋ, n yaa wa n Bʋadembiŋ a keŋ fʋ jigiŋ, dama jɩmbɩatɩ die yalla wa ta ʋ ka bɩagɩ a bala wɩa. ");
INSERT INTO kma_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jɩmbɩatɩ gie dɩ keŋ a hagɩ a ŋaaŋ nagɩ wa taaŋ mɩŋ, ta fʋnfʋgɩtɩ dɩ bie ʋ nʋaŋ ma, ʋ nyɩna ŋaaŋ chɩa wa taŋ ta ʋ nyɩŋgbanɩŋ mana dɩ hagɩrɩ. Die maŋ balɩ fʋ kʋaŋandɩɩsɩrɩba dɩ ba gbaaŋ wa die ba bɩlɩ waarɩ.” ");
INSERT INTO kma_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yisa dɩ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ wo yada, lalɩa nɩ bɩ yaala maŋ ŋaŋ nɩ bemme a yʋasɩ, nɩ yaa bʋa wa a keŋ n jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba yaa bʋa wa a keŋ ʋ jigiŋ. Die jɩmbɩakʋ dɩ yene Yisa, ka yi bʋa wa dɩ chaa, die wɩa a yi ʋ nan tɩŋgbaŋ a bilime mi, ta fʋnfʋgɩtɩ dɩ nyɩnna ʋ nʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yisa dɩ pɩasɩ bʋa wa chɔɔŋ wa dɩ, “Bɩna aŋmɩa wʋnna a yalla wa?” Ʋ chɔɔŋ wa dɩ baarɩ “Die ʋ yine bʋabiŋ mana. ");
INSERT INTO kma_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Daaŋ mana jɩmbɩakʋ ŋaaŋ yaala ka kʋʋ wa mɩŋ, ka ŋaaŋ vigi wo mɩŋ a taanna boliŋ me aŋaŋ nyaaŋ ma. Chɩgɩ tɩ zɔɔlɩŋ ta fʋ suŋŋi tɩ, fʋ nan bɩagɩ suŋŋi!” ");
INSERT INTO kma_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yisa dɩ balɩ daa wa dɩ, “Bɩa fʋ bala fʋ nan bɩagɩ suŋŋi! Wɩɩŋ wori a nyaŋŋa vuodieke dɩ yalla yada.” ");
INSERT INTO kma_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bʋa wa chɔɔŋ wa dɩ keesi bʋnyɩ, ta baarɩ dɩ, “N yaa yada mɩŋ ama n yadaka ka dala, suŋŋi mɩŋ aŋ bʋ dalɩma.” ");
INSERT INTO kma_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yisa die ye ta daadamba gbigiye ʋ yɩ lɔlɩŋ dɩ, “N baarɩ, jɩmbɩakʋ dieke dɩ yine bʋa wa dɩ ka wʋmma wa ta bala wɩaha, nyɩŋ ʋ ma ta da bɩ yiŋŋi a juu ʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jɩmbɩakʋ dɩ keesi ta nagɩ bʋa wa a nɩgɩ tɩŋgbaŋ pemm ta die faasɩ a datɩ wa ta nyɩŋ ʋ ma, bʋa wa dɩ nɩasɩ kuŋ, vuoŋ mana die dɩ baarɩ dɩ ʋ kpiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama Yisa die dɩ yigi ʋ nuuŋ me a suŋŋi wo ʋ hagɩ zie. ");
INSERT INTO kma_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Die Yisa dɩ yiŋŋine a juu juoŋ me ʋ kʋaŋandɩɩsɩrɩba dɩ pɩasɩ wa dɩ, “Bɩa die yine tɩ ka bɩagɩ a yagɩ jɩmbɩakʋ?” ");
INSERT INTO kma_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Die ʋ balɩ ba dɩ, “Ŋmɩŋ jʋʋsɩŋ nyɩɩna nan bɩagɩ a yagɩ jɩmbɩatɩ dɩ nɩasɩna naa, jaaŋ bɩ wori.” ");
INSERT INTO kma_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Die ba nyɩŋ mi a ga Galili me, Yisa die ka yaala vuoŋ sɩmma ba benne jigidieke, ");
INSERT INTO kma_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dama die ʋ daga ʋ kʋaŋandɩɩsɩrɩba mɩŋ. Die ʋ balɩ ba dɩ, “Ba nan nagɩ manɩŋ Vuota Bʋadembiŋ wa a yɩ vuosi nuusi me aŋ ba kʋʋ mɩŋ, ama ka daraa ataa kʋaŋ chaaŋ n nan hagɩ kumbu me.” ");
INSERT INTO kma_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Die ba ka sɩba ʋ dagɩkʋ chɩaŋ ama ŋmaamɩŋ die yalla ba aŋaŋ ba baaŋ nan pɩasɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ba keŋ Kapenɔmi a juu juoŋ a kpatɩ, ʋ pɩasɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Bɩa wɩɩŋ nɩ tɩŋ yaa nɩga nɩnhagɩrɩbʋ sieku me wo?” ");
INSERT INTO kma_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Die ba ka yaala ba balɩ wa dama die ba nɩga nɩnhagɩrɩŋ dɩ ba jabɩa yine jakʋʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yisa die dɩ sʋʋŋ kalɩ ta wa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo, a balɩ ba, vuodieke mana dɩ yaala ʋ yi jakʋʋŋ sie ʋ wɩarɩ kʋaŋ ta nagɩ ʋ gbaŋ a yi vuoŋ mana yɔmʋ. ");
INSERT INTO kma_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Die ʋ wa bʋabiŋ a nagɩ wa zieŋ ba nɩŋŋa a nagɩ ʋ nuusi a diisi ʋ ma ta balɩ ba. ");
INSERT INTO kma_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Vuodieke nɩŋ mana dɩ a keŋ saagɩ a tuo bʋabike gie chanchaaŋ n saaŋ ma tuose mɩŋ, vuodieke nɩŋ mana dɩaŋ dɩ tuosine mɩŋ, tuo wo vuodieke dɩ tʋnna mɩŋ wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jɔɔn die dɩ balɩ a yɩ Yisa dɩ, “Dɩdagɩrʋ, die tɩ ye wo vuoŋ dɩ yagɩnana jɩmbɩatɩ vuoŋ me fʋ saaŋ ma, die tɩ balɩ wa dɩ ʋ vaa dama die ʋ ka yi tɩ wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yisa dɩ balɩ ba, “Daa nɩ yi ʋ vaa dama, vuoŋ dɩ bɩagɩ a yie mamachi wɩa n saaŋ ma ka kʋaŋ chaaŋ ʋ kaaŋ bɩagɩ a balɩ wɩɩŋ a chʋʋsa n saaŋ. ");
INSERT INTO kma_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dama vuodieke mana dɩ kana ka waga tɩ gʋtɩ wa tɩ ma. ");
INSERT INTO kma_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wusie maŋ bala nɩ naa, vuodieke nɩŋ mana dɩ kenne yɩ nɩ nyaaŋ nɩ nyuu dama nɩ dɩ wa ʋ kʋaŋ nan daansɩ ye ka nyʋarɩ.” ");
INSERT INTO kma_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yisa dɩ baarɩ, “Vuoŋ dɩ a keŋ yi ballɩbɩsɩ gie wʋnyɩ dɩ tuone mɩŋ a dii wo dɩ yi wʋbɩaŋ, dɩ tɩŋ nan dɩ kpɩa ba nagɩna nɩɩŋ a bɔbɩ a yeegi ʋ nyie ta nagɩ wa a taaŋ nyaakpɩɩbʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dɩɩ yi fʋ nuuŋ yinene fʋ yie wʋbɩatɩ fʋ gobike taaŋ, dama dɩ kpɩa fʋ baaŋ nan juu arɩzanna aŋaŋ nuubalɩmɩŋ, aŋaŋ fʋ baaŋ juu boli dieke me dɩ wone kpatɩŋ aŋaŋ nuusi ale. ");
INSERT INTO kma_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","((Jigidieke zɩŋzʋa dɩ benne ba sʋŋ a die ta ka kpie, ta bolibu dɩaŋ ka kpise.)) ");
INSERT INTO kma_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Dɩɩ yi fʋ naŋ yinene fʋ yie wʋbɩatɩ fʋ gobike taaŋ dama dɩ kpɩa fʋ baaŋ juu arɩzanna aŋaŋ naŋ gobiŋ a tɩaŋ fʋ baaŋ dɩ yallɩ nagɩsɩ ale ta juu boliŋ me. ");
INSERT INTO kma_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","((Jigidieke zɩŋzʋa dɩ benne ba sʋŋ a die ta ka kpie, ta bolibu dɩaŋ ka kpise.)) ");
INSERT INTO kma_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dɩ bɩ yiwo fʋ niŋ dɩaŋ yine fʋ yie wʋbɩatɩ vʋarɩka taaŋ, dama, dɩ kpɩa fʋ baaŋ nan juu arɩzanna aŋaŋ nimbalɩmɩŋ a tɩaŋ fʋ baaŋ nan juu boliŋ me aŋaŋ nine ale. ");
INSERT INTO kma_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jigidieke zɩŋzʋa dɩ benne ba sʋŋ a die ta ka kpie, ta bolibu dɩaŋ ka kpise. ");
INSERT INTO kma_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ŋmɩŋ nan daansɩ nagɩ boliŋ a wʋnsɩ vuoŋ mana sɩba ba ŋaana naga yasɩ a wʋnsa kaabɩŋ nɔŋ die wo. ");
INSERT INTO kma_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Yasɩ nansɩ mɩŋ, ama ka nansɩbʋ dɩ keŋ nyɩŋ, lalɩa ka bɩ baa ka ye ka nansɩbʋ bɩbra? “Nɩ bemme aŋaŋ taŋ sɩba yasɩ nansɩbʋ aŋ nɩ bemme aŋaŋ sʋgɩfɩalɩŋ aŋaŋ tamba.” ");
INSERT INTO kma_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisa die dɩ nyɩŋ mi a garɩsɩ Jɔɔdani mʋgɩrɩ a ga Judia tɩŋgbaŋ ma; daadaŋ pam die dɩ bɩ a keŋ giliŋ wo, ʋ dagɩ ba sɩba ʋ ŋaana wɔŋ daga die wo. ");
INSERT INTO kma_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farasisi die dɩ keŋ mi a yaala ba magɩsɩ wa, a pɩasɩ wa dɩ, dagɩ tɩ, dɩ yaa sieŋ mɩŋ tɩ mɩra sʋŋ dembiŋ zeti ʋ hɔgʋ mɩŋ? ");
INSERT INTO kma_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yisa gbaŋ dɩ pɩasɩ ba dɩ, “Lalɩa Mosisi die dɩ balɩ nɩ?” ");
INSERT INTO kma_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Die ba baarɩ dɩ, “Mosisi die baarɩ dembiŋ dɩ keŋ yaala ʋ zeti ʋ hɔgʋ ʋ ŋaaŋ maagɩ wa gbanɩŋ a yɩ wa a dagɩ sɩba ʋ zeti wo mɩŋ, ta vaa wa aŋ ʋ ga.” ");
INSERT INTO kma_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yisa dɩ balɩ ba dɩ, “Nɩ wɩa die tʋa mɩŋ wɩa Mosisi die dɩ yɩ nɩ nʋarɩ mi. ");
INSERT INTO kma_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama dʋnɩa piiliŋ, Ŋmɩŋ die naaŋ wa ‘dembiŋ aŋaŋ hɔgʋ.’ ");
INSERT INTO kma_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Naa chɩaŋ ma dembiŋ aŋaŋ hɔgʋ nan vaa ba chʋalɩŋ aŋaŋ ba nɩɩlɩŋ ta faarɩ taŋ aŋ ba bale wo gie nan lagɩŋ ");
INSERT INTO kma_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yi vuobalɩmɩŋ, da vuosi bale bɩbra. ");
INSERT INTO kma_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Die wɩa Ŋmɩŋ dɩ keŋ nagɩ jadieke a lagɩŋ, vuota ka mʋ ʋ puoke.” ");
INSERT INTO kma_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Die ba yiŋŋine kuli tigiŋ ʋ kʋaŋandɩɩsɩrɩba dɩ pɩasɩ wa wɩɩrɩ wɩa. ");
INSERT INTO kma_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ʋ balɩ ba dɩ “Dembiŋ dieke dɩ zeti ʋ hɔgʋ ta bɩ faarɩ hɔgʋ gaaŋ juu wo hɔgʋ dieke ʋ zetine wo taalɩ ma. ");
INSERT INTO kma_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hɔgʋ dieke dɩaŋ dɩ zeti ʋ chʋrʋ ta bɩ yallɩ dembiŋ gaaŋ ʋ gbaŋ; juu ʋ chʋrʋkʋrɩ taalɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vuosi bataŋ die dɩ yaa ballɩ a keŋ dɩ Yisa gbɩ ba, ʋ kʋaŋandɩɩsɩrɩba dɩ yaga ba. ");
INSERT INTO kma_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Die Yisa dɩ mɩŋŋɩna, ʋ jɩɩ sɩnyɩɩrɩŋ ta balɩ ba dɩ, “Nɩ vaa ballɩbɩsɩsɩ kiere n jigiŋ, daa nɩ yagɩma ba dama Ŋmɩŋ naarɩ yiwo ba die wo sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Vuodieke mana dɩ a keŋ ka tuo Ŋmɩŋ naarɩ sɩba bʋabiŋ die dɩ tuone nyinti die nɩŋ ʋ kaaŋ juu mi.” ");
INSERT INTO kma_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Die ʋ wa nagɩ ba ʋ nuusi me ta nagɩ ʋ nuusi a diisi diisi ba ma ta yi alibarika a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Die Yisa die dɩ dene hagɩ dɩ ʋ dɩa, daa wʋnyɩ dɩ chɩgɩ a keŋ gbirigi ʋ nɩŋŋa ta pɩasɩ wa dɩ, “Dɩdagɩrʋ vɩɩnɩŋ, lalɩa maŋ nan yi a ye miivoli dieke dɩ wone kpatɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yisa dɩ pɩasɩ wa dɩ, “Bɩa fʋ wasa mɩŋ vuovɩɩnɩŋ? Vuovɩɩnɩŋ wori ntaala Ŋmɩŋ nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fʋnɩŋ sɩba Ŋmɩŋ mɩraha mɩŋ. ‘Da keŋ kʋʋ vuoŋ, da keŋ yaalɩ vuoŋ hɔgʋ, da keŋ gaarɩ, da keŋ yi ŋmɩnchɩbɩsɩ daansɩatieŋ, da keŋ nyɩrɩ vuoŋ, yɩma fʋ chʋa aŋaŋ fʋ naa jɩlɩma.’ ” ");
INSERT INTO kma_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Daa wa dɩ balɩ Yisa dɩ, “Dɩdagɩrʋ n yine bʋabiŋ mana a yaa ga mʋʋna n dɩɩ sieti gie mana mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yisa dɩ daansɩ wa aŋaŋ choti, ta balɩ wa, wʋbalɩmɩŋ tɩala fʋ, “Kulime a daa jadieke mana fʋ yalla a nagɩ ligirehe a yɩ zɔɔlɩntieliŋ, ta nan yi nyintitieŋ arɩzanna ma, ta fʋ keŋ a dɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Daa wa die dɩ wʋnna naa ʋ sʋŋ dɩ paalɩ chʋʋsɩ, ʋ nine chaatɩ dɩ tarɩgɩ dama die ʋ faasɩ yiwo ligiretieŋ, die ʋ kuli tigiŋ aŋaŋ sʋgɩchʋʋsɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yisa dɩ yiŋŋi a daansɩ ʋ kʋaŋandɩɩsɩrɩba ta baarɩ dɩ, “Dɩ tʋa pam aŋaŋ ligiretieŋ dɩ baaŋ nan juu Ŋmɩŋ naarɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Die dɩ yi ʋ kʋaŋandɩɩsɩrɩba mamachi ʋ balɩkʋ ma, ta Yisa dɩ bɩ balɩ bɩbra dɩ, “N ballɩ, Ŋmɩŋ naarɩ juule wɩa tʋa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nyɔgɩnɩ dɩ baaŋ yi die a garɩ nyɩŋ garɩyɩɩŋ vɔrɩŋ ma wa ka tʋa a tʋgɩ ligiretieŋ dɩ baaŋ nan yi die a juu Ŋmɩŋ naarɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Die ʋ kʋaŋandɩɩsɩrɩba dɩ wʋnna naa, dɩ bɩ faasɩ yi be mamachi, ba wa pɩasa taŋ dɩ, “Die nɩŋ mɩnɩa bala ʋ ye gbatɩtaanɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yisa dɩ daansɩ ba ta baarɩ dɩ, “Vuotaŋ kaaŋ bɩagɩ a yi die ama Ŋmɩŋ nan bɩagɩ a yi dama Ŋmɩŋ jigiŋ wɩɩŋ wori a tʋa.” ");
INSERT INTO kma_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piita dɩ pɩasɩ dɩ, “Ta tɩnɩŋ nɩŋ, tɩ nagɩna jaaŋ mana a taaŋ ta dɩ fʋ wa?” ");
INSERT INTO kma_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yisa dɩ balɩ ba dɩ, “Vaa n balɩ nɩ, vuodieke mana dɩ vana ʋ tigiŋ, yaa ʋ nɩmballɩ yaa ʋ nuŋ yaa ʋ chɔɔŋ yaa ʋ ballɩ yaa ʋ kʋatɩ n wɩa aŋaŋ Ŋmɩŋ wʋvɩɩnaha wɩa ");
INSERT INTO kma_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nan daansɩ ye nyinti saŋka gie a tɩaŋ ʋ nagɩna nyindiekemba a taaŋ wa. Ʋ nan ye tige, aŋaŋ nɩmballɩ aŋaŋ nɩɩlɩŋ aŋaŋ ballɩ aŋaŋ kʋatɩ kɔbɩga kɔbɩga tɩŋgbaŋka gie me ta tuo mugisiŋ a gʋtɩ ta saŋŋa dieke dɩ kienene wo ʋ nan ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama vuodiekemba dɩ benne nɩŋŋa lele nan wɩarɩ kʋaŋ ta vuodiekemba dɩ benne kʋaŋ lele nan tɩaŋ nɩŋŋa.” ");
INSERT INTO kma_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Die ba wa bie wo sieŋ me a gara Jerusalemi, Yisa die dɩna nɩŋŋa, die dɩ yi ʋ kʋaŋandɩɩsɩrɩba mamachi ta ŋmaamɩŋ dɩ yallɩ vuodiekemba die dɩ dɩna ba kʋaka. Yisa die dɩ bɩ wa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a ga lʋgɩŋ a balɩ ba wudiekemba die dɩ bala a yi wo. ");
INSERT INTO kma_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ʋ balɩ ba dɩ, “Nɩ daansɩma, tɩ gara Jerusalemi, jigidieke ba baaŋ nagɩ manɩŋ vuota Bʋadembiŋ a ga yɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Ŋmɩŋ mɩraha dɩdagɩrɩŋ nuusi me aŋ ba dii mɩŋ sarɩya ta baarɩ dɩ n chʋʋsɩya dɩ ba kʋʋ mɩŋ, ta nagɩ mɩŋ a yɩ vuodiekemba dɩ kana ka yi Juu vuosi ");
INSERT INTO kma_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","dɩ ba vʋarɩ mɩŋ fala, a tɩɩrɩ nɩntɔbɩtɩ a yɩ mɩŋ, a nɩgɩ mɩŋ aŋaŋ kpaasɩŋ ta kʋʋ mɩŋ ama daraa ataa daraaŋ n nan hagɩ kumbu me.” ");
INSERT INTO kma_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Womi Jemisi aŋaŋ Jɔɔn, Zebedi ballɩ dɩ keŋ Yisa jigiŋ a baarɩ, “Dɩdagɩrʋ, wɩɩŋ benne tɩ yaala fʋ yi a yɩ tɩ.” ");
INSERT INTO kma_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yisa dɩ pɩasɩ ba dɩ, “Bɩa nɩ yaala n yi a yɩ nɩ?” ");
INSERT INTO kma_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba baarɩ dɩ, “Tɩ yaala saŋŋa dieke fʋ keŋ baa fʋ dii fʋ naarɩ aŋaŋ hagɩrɩŋ tɩ ŋaŋ fʋ gʋtɩ kala, wʋnyɩ kala fʋ nuugalɩ wʋnyɩ fʋ nuudiigiŋ.” ");
INSERT INTO kma_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yisa dɩ balɩ ba, “Nɩ zɩ nɩ jʋʋsɩnana jadieke wo chɩaŋ, nɩ nan bɩagɩ a chii chii diekemba n balla n chii wo? Nɩ nan bɩagɩ a gbalɩgɩ gbalɩgɩ diekemba n baaŋ nan gbalɩgɩ wa?” ");
INSERT INTO kma_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba baarɩ “Wa, tɩ nan bɩagɩ.” Yisa dɩ balɩ ba dɩ, “Wusie nɩ nan chii n chiititi, ta bɩ gbalɩgɩ gbalɩgɩ diekemba n balla n gbalɩgɩ wa, ");
INSERT INTO kma_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ama n wo sieŋ dɩ n dagɩ sɩba geŋ wo baaŋ nan kalɩ n nuudiigiŋ, ta geŋ wo kala n nuugalɩ. Ŋmɩŋ bala ʋ nagɩ jigehe gie a yɩ vuodiekemba wɩa ʋ wʋnsɩna wa.” ");
INSERT INTO kma_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Die ʋ kʋaŋandɩɩsɩrɩba banɩŋ, baŋ wa die dɩ wʋnna naa die ba jɩɩ sɩnyɩɩrɩŋ a yɩ Jemisi aŋaŋ Jɔɔn. ");
INSERT INTO kma_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Die wɩa die Yisa dɩ wa ba mana a lagɩsɩ taŋ ta balɩ ba nɩ sɩba baarɩ vuodiekemba dɩ daansɩnana vuosi tɩŋgbaŋka gie ŋaaŋ dagɩ wa ba gbaŋ ta nyɩŋkʋra dɩaŋ ŋaaŋ pɔgɩlɩ wa ba vuosi aŋaŋ nɩŋŋmɩna, ");
INSERT INTO kma_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ama nɩnɩŋ nɩŋ, nɩ sʋnsʋŋ vuodieke dɩ yaalala nyɩŋkʋrɩtɩ, sie ʋ nagɩ ʋ gbaŋ a bɩrɩŋ yɔmʋ banɩŋ ba mana sʋnsʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Vuodieke dɩaŋ dɩ bɩ yaala ʋ bemme nɩŋŋa sie ʋ nagɩ ʋ gbaŋ a bɩrɩŋ vuoŋ mana yɔmʋ, ");
INSERT INTO kma_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","dama Ŋmɩŋ Bʋadembiŋ gbaŋ ka keŋye dɩ vuosi yi ʋ yɔŋɩsɩ, ama wʋnɩŋ ʋ balla ʋ yi vuoŋ mana yɔmʋ, a kpi a gbatɩ vuosi pam a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Die ba kenne a keŋ tʋgɩ tɩŋ kaanɩ ba wasɩnana Jariko, Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba dɩ wa nyɩna tɩka ma daadaŋ pam die dɩdɩ ba kʋaŋ. Daa yɩɩ wʋnyɩ ba wasɩnana Batimiisi, Timiisi bʋa dɩ kalɩ sieku me a jʋʋsa. ");
INSERT INTO kma_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Die ʋ wʋnna dɩ Yisa vuodieke dɩ nyɩnna Nazeriti die benne mi wo, ʋ piili a keesi “Yisa, Davidi haagɩŋ chɩgɩ mɩŋ zɔɔlɩŋ!” ");
INSERT INTO kma_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Die daadamba pam dɩ natɩ wa ta baarɩ dɩ ʋ tarɩ watɩ, yɩɩ wa dɩ wa faasɩ a keesi “Yisa, Davidi haagɩŋ chɩgɩ mɩŋ zɔɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yisa dɩ zie ta baarɩ dɩ, “Nɩ wa wa.” Die wɩa die ba wa yɩɩ wa a balɩ wa dɩ, “Hagɩ zie, ʋ wasa fʋ.” ");
INSERT INTO kma_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ʋ nagɩ ʋ nyinyeeke a vigi taaŋ, ta chɩgɩ ga Yisa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yisa dɩ pɩasɩ wa dɩ, “Bɩa fʋ yaala n yi a yɩ fʋ?” Yɩɩ wa dɩ baarɩ “Dɩdagɩrʋ, n yaala n bɩ yiŋŋi yesime mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yisa dɩ balɩ wa dɩ, “Gamma, fʋ yada gbaanna fʋ.” Lele womi ta ʋ ninehe dɩ yuori ʋ wa dɩ Yisa kʋaŋ sieku me. ");
INSERT INTO kma_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Die ba gana a ga tʋga Jerusalemi ba keŋ Betifiji aŋaŋ Betani tɩgɩsɩ, tɩgɩsɩ gie die bie wo kunkogiŋ dieke ba wasɩnana Olivi Tɩɩsɩsɩ lʋgɩŋ, Yisa dɩ tʋŋ ʋ kʋaŋandɩɩsɩrɩba bale ta ");
INSERT INTO kma_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","balɩ ba dɩ, “Nɩ gamma tɩŋkpaŋŋɩ dieke dɩ benne nɩ nɩŋka, nɩ die keŋ a juu tɩka ma nɩ nan ye bonpɔlɩ dɩ bɔbɩna zie vuoŋ dɩ ye ka jʋalɩ ka, nɩ forisike a yaa keŋ giena. ");
INSERT INTO kma_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vuoŋ dɩ a keŋ keŋ pɩasɩ nɩ, dɩ bɩa nɩ yi dene, nɩ balɩ wa dɩ, tɩ Yɔmʋtieŋ yaalala ka, ama ʋ nan yiŋŋi a yaa ka a keŋ lele.” ");
INSERT INTO kma_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Die ba ga a ye bonpɔlɩka dɩ ka zie sieku me a bɔbɩ juoŋ kaanɩ sanʋaŋ ma. Die ba forisinene ke ");
INSERT INTO kma_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vuosi bataŋ die zie mi, a pɩasɩ ba dɩ, “Bɩa nɩ yie, nɩ forise bonpɔlɩka mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ba balɩ ba Yisa die dɩ bala die wo gbaŋ gbaŋ, die wɩa vuosisi die dɩ vaa ba yaa a ga. ");
INSERT INTO kma_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Die ba yaa bonpɔlɩka a keŋ Yisa jigiŋ a nagɩ ba garɩtɩ a diisi ka sikpeŋ Yisa die dɩ wa jʋalɩ kalɩ ka sikpeŋ. ");
INSERT INTO kma_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vuosi pam die dɩ nagɩ ba gaatɩ a jaatɩ sieku me bataŋ dɩaŋ dɩ nagɩ vaatɩ ba chɩana nyɩŋ haagɩŋ ma a jaata sieku me. ");
INSERT INTO kma_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vuodiekemba die dɩ benne ʋ nɩŋŋa aŋaŋ ʋ kʋaŋ, die dɩ wa a piili keesiŋ, “Tɩ Yɔmʋtieŋ, hozaana gbatɩ tɩ a taaŋ lele. Ŋmɩŋ yi alibarika a yɩ vuodieke dɩ kienene wʋnɩŋ Ŋmɩŋ saaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ŋmɩŋ bɩ yi alibarika a yɩ tɩ chɔɔŋkʋʋŋ Davidi naarɩ dieke dɩ kienene wo ma. Hozaana! Ŋmɩŋ, vuodieke dɩ benne ŋmɩŋsikpeŋ, gbatɩ tɩ taaŋ leleke gie.” ");
INSERT INTO kma_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yisa die dɩ ga tʋgɩ Jerusalemi, a ga Ŋmɩŋ jɩamɩŋ juoku sʋŋ, a daansɩ jaaŋ mana ka sʋŋ. Ama saŋŋa dieke ŋmɩŋ dɩ yaala ka nan die ʋ ŋaŋ ʋ kʋaŋandɩɩsɩrɩba, baŋ aŋaŋ bale wo die dɩ nyɩŋ ga Betani. ");
INSERT INTO kma_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tʋŋ die dɩ vʋnna ba nyɩŋ Betani a kieŋ, kɔŋ die dɩ yallɩ Yisa, ");
INSERT INTO kma_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","die ʋ ye kɩnkamɩŋ tɩɩŋ dɩ gana ga zie ŋaŋ vaatɩ, die ʋ ga ʋ daansɩ ye sɩba ka yaa nyɩŋnyɩŋka mɩŋ. Die ʋ tʋgɩna mi die ʋ ye wo vaatɩ nyɩɩna ka sikpeŋ, dama ka saŋŋa die ye ka tʋgɩya aŋaŋ ka baaŋ nan nyɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yisa dɩ balɩ a yɩ tɩɩka dɩ, “Vuoŋ kaaŋ bɩ ye nyɩŋnyɩŋka fʋ ma a dii bɩbra.” Die ʋ kʋaŋandɩɩsɩrɩba dɩ wʋŋ ʋ bala wa. ");
INSERT INTO kma_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Die ba gana ga tʋgɩ Jerusalemi, Yisa dɩ ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma, a piili a yaga vuodiekemba die dɩ yalla nyinti a daa aŋaŋ vuodiekemba die dɩ daanana nyintiti ta kpaŋŋɩ vuodiekemba dɩ yalla ligire a tarɩga aŋaŋ vuodiekemba die dɩ yalla ŋmarɩsɩ a daa teebulisi a bubi bubi. ");
INSERT INTO kma_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta ka saagɩya dɩ vuoŋ chii jaaŋ a daagɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gbaakʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Die ʋ wa dagɩ vuosisi ta baarɩ, “Ŋmɩŋ wɩa baarɩ, Ŋmɩŋ tigiŋ baa ka yiwo Ŋmɩŋ jʋʋsɩŋ jigiŋ a yɩ vuoŋ mana, ta nɩ nagɩ ka a bɩrɩŋ gaarɩŋ tigiŋ?” ");
INSERT INTO kma_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Ŋmɩŋ mɩraha dɩdagɩrɩba die dɩ wʋnna naa wa, die ba piili a yaala sieti dɩ ba kʋʋ Yisa. Die ba chɩga wa mɩŋ, dama die ʋ dagɩkʋ die yi daadamba mana mamachi mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Die jɩŋmɩŋ dɩ tʋgɩna Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ nyɩŋ mi. ");
INSERT INTO kma_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tuŋ die dɩ vʋnna sʋkʋleeliŋ, ba chʋŋ sieku me die ba ye tɩɩ dieke Yisa die dɩ kana a yɩ wa, die ka mana dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piita die dɩ tɩɩnsɩ wudieke die dɩ yine wo ta balɩ a yɩ Yisa dɩ, “Dɩdagɩrʋ, daansɩ, tɩɩka die fʋ kana a yi wa kpiye!” ");
INSERT INTO kma_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yisa dɩ balɩ ba dɩ, “Nɩ yi Ŋmɩŋ yada. Nɩ keŋ a yi Ŋmɩŋ yada, ");
INSERT INTO kma_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","nan bɩagɩ a balɩ a yɩ kunkogiri gie, vʋʋ a ga nan nyaakpɩɩbʋ ma, fʋ gbaŋ gbaŋ fʋ keŋ a balɩ die ta ka chɩɩlɩya fʋ sʋŋ ma, yi yada sɩba fʋ bala die wo nan yi, aŋ ka yi a yɩ fʋ. ");
INSERT INTO kma_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Vaa n balɩ nɩ, naa chɩaŋ ma nɩ keŋ a jʋʋsa Ŋmɩŋ a yaala jaaŋ nɩ tuo a dii sɩba ye ke mɩŋ, aŋ ka yi nɩ jaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta nɩ keŋ a zie jʋʋsa Ŋmɩŋ ta vuodieke mana dɩ yine nɩ bɩaŋ, nɩ vaa ʋ taalɩ a chaa wa aŋ nɩ Chɔɔŋ Nabidie Ŋmɩŋ dɩ benne arɩzanna ma dɩaŋ nan nagɩ nɩ taalɩ a chaa nɩ. ");
INSERT INTO kma_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","((Ama nɩ keŋ a ka nagɩ nɩ chanchaalɩŋ wʋbɩatɩ a chaa ba, nɩ chɔɔŋ dieke dɩaŋ dɩ benne arɩzanna ma kaaŋ nagɩ nɩ wʋbɩatɩ a chaa nɩ.))” ");
INSERT INTO kma_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Die ba bɩna a yiŋŋi keŋ tʋgɩ Jerusalemi Yisa die dɩ juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩŋ ma a dɩ chʋŋ, Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Ŋmɩŋ mɩraha dɩdagɩrɩba aŋaŋ tɩŋgbaŋka nyɩŋkʋra bataŋ dɩ keŋ ʋ jigiŋ, ");
INSERT INTO kma_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a pɩasɩ wa dɩ, “Bɩa yiko fʋ yaa yie nyinti gie? Mɩnɩa yɩna fʋ kanɩŋ yiko ke mi?” ");
INSERT INTO kma_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yisa dɩ balɩ ba dɩ, “Nɩ vaa n pɩasɩ nɩ wʋbalɩmɩŋ amʋ nɩ keŋ bɩagɩ a mɩŋŋɩ balɩ mɩŋ ka chɩaŋ, n nan balɩ nɩ vuodieke yiko n yalla a tʋma nyinti gie wo. ");
INSERT INTO kma_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nɩ balɩ mɩŋ Jɔɔn die ye wo yiko sɩa a yaa sɩa vuosisi Ŋmɩŋ nyaabʋ, sɩa yiko ke mi die dɩ nyɩŋ, Ŋmɩŋ jigiŋ yaa vuotaŋ jigiŋ?” ");
INSERT INTO kma_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Die ba yiŋŋi a pɩasa taŋ dɩ, “Tɩ baa tɩ balɩ wa lalɩa? Tɩ keŋ baarɩ bʋ nyɩŋ wa Ŋmɩŋ jigiŋ, ʋ nan baarɩ, bɩa die wana yi tɩ ka yi Jɔɔn yada? ");
INSERT INTO kma_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tɩ nan bɩagɩ baarɩ, vuotaŋ jigiŋ?” (Die ŋmaamɩŋ die yalla ba aŋaŋ vuosisi, dama vuoŋ mana die baarɩ Jɔɔn die yiwo Ŋmɩŋ dɩ tʋnna vuodieke.) ");
INSERT INTO kma_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Die ba balla wudieke a yɩ Yisa die wone “Tɩ zɩ.” Yisa dɩ balɩ ba dɩ, “Die nɩŋ n gbaŋ n kaaŋ balɩ nɩ jigidieke n yene yiko ke gie a yie nyintiti gie.” ");
INSERT INTO kma_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisa die dɩ taanna ba nandaga dɩ, “Daa wʋnyɩ die benne a suu tɩɩsɩ dieke dɩ nyɩnana bie, ta mɩɩ gaamɩŋ a geliŋke, ta die a tuu vɔrɩŋ jigidieke ba baaŋ nan dɩ ŋmʋa nyɩŋ biehe nyaabʋ a yie: ta die a mɩɩ jagɩŋ kʋakʋ ma, ta die nagɩ kʋakʋ a yɩ tʋntʋntɩŋ nuusi me dɩ ba daansɩma ka. Dɩ ka diile saŋŋa dɩ a keŋ tʋgɩ ba kpaa a yɩ wa ta dɩaŋ wa kpaa ba tʋaŋ. Ta die wa nagɩ kʋakʋ a yɩ ba ta dɩa ga jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tɩɩsɩsɩ bie saŋŋa die dɩ tʋgɩna ka nyɩŋ ʋ tʋŋ ʋ yɔmʋ dɩ ʋ ga vuodiekemba dɩ benne kʋakʋ ma a tuo ʋ tʋaŋ a keŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Vuosisi die dɩ yigi yɔmʋ wa, a nɩgɩ wa, ta yi ʋ yiŋŋi a ga aŋaŋ nuuwɩaga. ");
INSERT INTO kma_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tɩɩsɩsɩ tieŋ die dɩ bɩ tʋŋ yɔmʋ wʋnyɩ bɩbra, vuosisi die dɩ nɩgɩ ʋ sikpeŋ me ta nagɩ wa a yi viivi me. ");
INSERT INTO kma_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tɩɩsɩsɩ tieŋ die dɩ bɩ tʋŋ ʋ yɔmʋ wʋnyɩ bɩbra die ba kʋʋ wa. Die ba yi ʋ yɔŋɩsɩ pam dene gbaŋ gbaŋ a nɩga bataŋ ta kʋa bataŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Vuodieke nyɩɩna die dɩ tɩala daa wa dɩ baaŋ nan tʋŋ die wone ʋ gbaŋ gbaŋ ʋ bʋadembiŋ dieke ʋ yaalala ʋ wɩa. Kʋaŋ chaaŋ die ʋ tʋŋ wa ta baarɩ ‘N yi yada dɩ ba nan yɩ n bʋa wa jɩlɩma.’ ");
INSERT INTO kma_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama vuosisi gie die dɩ balɩ a yɩ tamba, ‘Kʋakʋ tieŋ gbaŋ gbaŋ bʋadembiŋ wʋnna, nɩ kiere aŋ tɩ kʋʋ wa, ta ʋ sɩɩtɩ yi tɩ nyinti.’ ");
INSERT INTO kma_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Die ba yigi bʋa wa a kʋʋ wa ta nagɩ wa vigi taaŋ kʋakʋ kʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yisa die dɩ pɩasɩ ba dɩ, “Lalɩa kʋakʋ tieŋ dɩ baa ʋ yi? Ʋ nan keŋ kʋʋ vuosisi gie ta nagɩ kʋakʋ a yɩ vuogaasɩ. ");
INSERT INTO kma_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nɩ ye ka karɩŋ a wʋŋ wɩɩrɩ gie? Dɩ ‘Taŋ dieke mɩmɩɩrɩba die dɩ zetine ta baarɩ ba ka yaala ka wa die dɩ yiŋŋi a keŋ yi gɔŋgɔŋyʋgɩrɩŋ taŋ vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ŋmɩŋ yine die; ka faasɩ yi tɩ mamachi.’ ” ");
INSERT INTO kma_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Juu vuosi nɩŋŋandɩɩsɩrɩba die dɩ yaala sieŋ dɩ ba yigi wo, dama die ba sɩba a baarɩ ba wɩa die ʋ taaŋ nandagɩrɩ gie. Ama die ba chɩga daadamba ta die vaa wa ta ga. ");
INSERT INTO kma_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Die ba tʋŋ Farasisi vuosi aŋaŋ Herodi vuosi bataŋ dɩ ba ga pɩasɩ wa wʋpɩasɩka ta ye dɩ ʋ nan balɩ wʋbɩaŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Die ba ga Yisa jigiŋ a baarɩ dɩ, “Dɩdagɩrʋ, tɩ sɩba a baarɩ bala wusie, ta ka chɩɩlɩ vuosi sʋŋanyilike. Fʋnɩŋ bala wusie yaa gamma Ŋmɩŋ dɩ yaala vuotaŋ sɩmma die ta ka daansa yese vuoŋ dɩ sɩna die. Balɩ tɩ, dɩ mʋ dɩ tɩ tumme lampo a yɩma Roma naaŋ wa mɩŋ? Tɩ tumme yaa tɩ zeti?” ");
INSERT INTO kma_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ama Yisa die mɩŋŋɩ dɩ ba paalɩya mɩŋ ta pɩasɩ ba dɩ, “Bɩa nɩ yaala nɩ magɩsɩ mɩŋ? Nɩ yaa ligiribiŋ a keŋ aŋ n ye ke.” ");
INSERT INTO kma_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba yaa a keŋ ʋ pɩasɩ ba dɩ, “Mɩnɩa nine chaaŋ aŋaŋ ʋ saaŋ benne ka ma dene?” Ba baarɩ dɩ, “Naaŋ Siiza.” ");
INSERT INTO kma_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yisa die dɩ wa baarɩ dɩ, “Tɔ, nɩ tuŋ naaŋ wa dɩ mʋna ʋ tuo dene ta tuŋ Ŋmɩŋ dɩaŋ dɩ mʋna ʋ tuo dene.” Yisa wɩa die dɩ yi be mamachi. ");
INSERT INTO kma_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Womi Sadusisi, vuosi bataŋ dɩ balla dɩ vuoŋ kaaŋ hagɩ kuŋ me, dɩ ga Yisa jigiŋ a ga pɩasɩ wa dɩ, ");
INSERT INTO kma_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Dɩdagɩrʋ, Mosisi die nagɩna mɩrɩka gie a yɩ tɩ: dɩ dembiŋ dɩ a keŋ kpi ta vaa ʋ hɔgʋ ta wo ballɩ, dɩ daa wa nɩmbʋa mʋ ʋ faarɩ wa kpihɔgʋ wa amʋ ba mɩɩrɩ ballɩ aŋ ba yi vuodieke dɩ kpine ballɩ. ");
INSERT INTO kma_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tɔ, saŋŋa kaanɩ dembisi bayʋpɔyɩ die benne a yi nɩmballɩ: jakʋʋrɩ chaaŋ die dɩ faarɩ hɔgʋ ta kpi ta wo ballɩ. ");
INSERT INTO kma_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Die wɩa vuodieke die dɩ diisine jakʋʋrɩ ma die dɩ faarɩ hɔgʋ wa gbaŋ ta kpi ta vaa hɔgʋ wa ta wo ballɩ. Dene gbaŋ gbaŋ die dɩ bɩ a yi vuodieke die dɩ diisine bʋtaa wa ma. ");
INSERT INTO kma_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aŋaŋ tɩalɩka ha mana. Ba bayʋpɔyɩ wa mana die faarɩ hɔgʋ wa mɩŋ ta kpi ta wo ballɩ, ka kʋaŋ kʋaŋ chaaŋ hɔgʋ wa gbaŋ die dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lele, kuŋ hagɩŋ daraaŋ ba mana dɩ a keŋ hagɩ, ba jabɩa balla ʋ sɩmma hɔgʋ wa? Ba bayʋpɔyɩ wa mana die faarɩna wa mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yisa dɩ balɩ ba dɩ, “Nɩ ka sɩba wusie! Dama nɩ zɩ Ŋmɩŋ gbanɩŋ wɩa yaa Ŋmɩŋ hagɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kunti dɩ a keŋ hagɩ kuŋ me, ba nan dɩ sɩɩ sɩba malakasi dɩ benne arɩzanna ma dene wo, ta hɔɔŋ faarɩŋ yaa dembiŋ yallɩŋ kaaŋ dɩ beri. ");
INSERT INTO kma_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Dɩ tɩalɩ kunti hagɩŋ nɩŋ wɩa nɩ ka karɩŋ Mosisi gbaŋkʋ yaa gamma tɩɩka diile wɩa? Dɩ maagɩya mɩŋ dɩ Ŋmɩŋ die balɩ a yɩ Mosisi dɩ, ‘N yiwo Abarahami Ŋmɩŋ, Aziki Ŋmɩŋ aŋaŋ Jakobu Ŋmɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Vuosi gie die wɔŋ kpi mɩŋ ama ba ye ko bie wo ba mɩsɩ ma dama Ŋmɩŋ ka yiwo kunti Ŋmɩŋ ʋ yiwo vuodiekemba dɩ benne ba mɩsɩ ma ma Ŋmɩŋ. Nɩ daga vuosi dɩ kunti kaaŋ bɩ hagɩ wa ka yi wusie.” ");
INSERT INTO kma_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Vuodiekemba die dɩ dagɩnana Ŋmɩŋ mɩraha wʋnyɩ die bie mi a wʋŋ ba balɩkʋ. Die ʋ yeye sɩba Yisa die mɩŋŋɩ dagɩ Sadusisi vuosisi pɩasɩkʋ chɩaŋ, die wɩa die ʋ keŋ mi aŋaŋ wʋpɩasɩkɩŋ dɩ, “Mɩra bɩa tɩanna mɩraha mana.” ");
INSERT INTO kma_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yisa dɩ balɩ wa dɩ, “Jadieke dɩ tɩanna a mana wʋnna ‘Wʋmma, Izara vuosi! Nabidie Ŋmɩŋ nyɩɩna yine tɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Chome Ŋmɩŋ aŋaŋ fʋ sʋŋ mana aŋaŋ fʋ yɩaŋ mana aŋaŋ fʋ sʋŋanyile mana aŋaŋ fʋ hagɩrɩŋ mana.’ ");
INSERT INTO kma_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jadieke dɩ gʋtɩna bule wone, chome fʋ chanchaaŋ sɩba fʋ chone fʋ gbaŋ gbaŋ dene. Mɩra bɩ wori a tɩaŋ mɩra ale wo gie.” ");
INSERT INTO kma_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Daa wa dɩ balɩ Yisa dɩ, “Kpaŋŋɩ fʋ gbaŋ dɩdagɩrʋ! Dɩ yiwo wusie fʋ balɩ baarɩ Nabidie Ŋmɩŋ nyɩɩna ma yine Ŋmɩŋ dɩ ŋmɩŋ bɩ wori a gʋtɩ ʋ ma sie ʋ nyɩɩna ma wa, ");
INSERT INTO kma_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","dɩ vuota yaalɩma Ŋmɩŋ aŋaŋ ʋ sʋŋ mana, aŋaŋ ʋ sʋŋanyile mana aŋaŋ ʋ hagɩrɩŋ mana, ta yaalɩma ʋ chanchaaŋ sɩba ʋ yaalala ʋ gbaŋ gbaŋ dene wo. Fʋ baaŋ tuo mɩra ale wo gie dɩ tɩaŋ fʋ baaŋ nan kʋa dɔŋɩsɩ ta jʋʋ a yɩ Ŋmɩŋ ta bɩ kaaba nyinti yɩa Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisa die dɩ yene ta daa wa mɩŋŋɩ a balɩ wa, ʋ balɩ a yɩ wa, “Fʋnɩŋ aŋaŋ Ŋmɩŋ naarɩ ka yʋa.” Na kʋaŋ chaaŋ vuoŋ die bɩ wo sikimiŋ a baaŋ pɩasɩ wa wʋpɩasɩkɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisa die dɩ dagɩnana Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ʋ pɩasɩ ba, wʋpɩasɩkɩrɩ gie dɩ, “Dɩ yiwo lalɩa Ŋmɩŋ mɩra dɩdagɩrɩba dɩ baarɩ dɩ vuovʋarɩkɩŋ Masia wa baa ʋ yi wo Davidi haagɩŋ? ");
INSERT INTO kma_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ŋmɩŋ Halɩkasɩka die june Davidi ma a yi ʋ baarɩ: ‘Ŋmɩŋ dɩ balɩ a yɩ n Yɔmʋtieŋ: Kala n nuudiigiri gie chaaŋ a ga tʋgɩ saŋŋa dieke n baaŋ nagɩ fʋ dataasɩ a yi fʋ nuuŋ me.’ ");
INSERT INTO kma_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi gbaŋ gbaŋ dɩ wasa wa ‘N Yɔmʋtieŋ’ Dɩ baa dɩ yiwo lalɩa ʋ bɩ yi Davidi haagɩŋ?” Daadaŋ pam die kalla a gbɩlɩŋ tɩba a wʋmma ʋ dagɩkʋ aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ʋ dagɩkʋ sʋŋ die ʋ baarɩ dɩ, “Nɩ sɩmma vuodiekemba dɩ dagɩnana Ŋmɩŋ mɩraha, ba nan dɩ yaala ba yeegi guuwagɩtɩ a chʋmma gilime, ta yaala ba wasɩma ba aŋaŋ jɩlɩma nyʋgɩtɩ ma ");
INSERT INTO kma_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ba keŋ juu Ŋmɩŋ jɩamɩŋ juone me, ba yaala vuokpɩɩma jigikasɩka, ba keŋ lagɩ laalɩŋ jigiŋ ba yaala sikpeŋ kpɩɩmatieliŋ jigikasɩka. ");
INSERT INTO kma_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Naa ba ŋaaŋ a nyɩra kpihɔgʋba ta gbata ba nyinti mana, ta jʋʋsa jʋʋsɩ wagɩtɩ sɩba ba chɩga Ŋmɩŋ. Vuodiekemba dɩ yinene dene nan faasɩ ye tɩbɩdatɩŋ pam.” ");
INSERT INTO kma_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisa die kalɩ a gbigi wo jigidieke ba nagɩna ligire a yɩa Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a daansa ba nagɩnana ba ligire a yɩa, ligiretieliŋ pam die dɩ nagɩ ligire pam a yɩ: ");
INSERT INTO kma_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Womi kpihɔgʋ zɔɔlɩntieŋ dɩ keŋ a nyɩŋ a nagɩ tɔgɩfaasɩ ale a yɩ. ");
INSERT INTO kma_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yisa dɩ wa ʋ kʋaŋandɩɩsɩrɩba a balɩ a yɩ ba dɩ, “N bala nɩ kpihɔgʋ zɔɔlɩntieŋ wo gie nagɩ ligire pam a yi a tɩaŋ banɩŋ ba mana, ");
INSERT INTO kma_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","dama banɩŋ ba mana nagɩ wa ligire a yi ta tɩalɩ ligire pam, ama wʋnɩŋ nɩŋ aŋaŋ ʋ zɔɔlɩbʋ mana ʋ nagɩ wa ʋ yalla die mana a yɩ, ta ka tɩalɩ ligire dieke ʋ baaŋ nan dii gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisa die dɩ nyɩnnana Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ dɩ baarɩ dɩ, “Dɩdagɩrʋ, ye mamachi tige die ba mɩna aŋaŋ mamachi tana.” ");
INSERT INTO kma_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yisa dɩ balɩ wa dɩ, “Ye mamachi nyinti gie, taŋ balɩmɩŋ gbaŋ kaaŋ tɩalɩ a bie ka jigiberisikiŋ ba nan kpaŋŋɩ a mana taaŋ.” ");
INSERT INTO kma_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Die Yisa dɩ ga a kalɩ Olivi Tɩɩsɩ kunkogiŋ me ta Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ die bie wo ka nɩŋŋa. Die Piita aŋaŋ Jemisi aŋaŋ Jɔɔn aŋaŋ Andurusi die dɩ keŋ ʋ jigiŋ saŋŋa dieke ʋ benne ʋ nyɩɩna ma wa. ");
INSERT INTO kma_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ba pɩasɩ wa dɩ, “Balɩ tɩ saŋŋa dieke wɩaha gie dɩ balla a yi.” Bɩ balɩ tɩ “Wudieke dɩ balla a dagɩ sɩba wɩaha gie mana baa a yi mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yisa dɩ balɩ ba dɩ, “Nɩ sɩmma dɩ vuoŋ gaaŋ nɩ. ");
INSERT INTO kma_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vuosi pam nan keŋ n saaŋ ma a baarɩ ‘N wone wo’, a gaaŋ vuosi pam. ");
INSERT INTO kma_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɩ keŋ a wʋŋ tɔntɩ wɩa aŋaŋ tɔntɩ wʋbalɩka nɩ da keŋ vaa ŋmaamɩŋ yalla nɩ. Wɩaha gie nan yi ama a kaaŋ dagɩ sɩba dakpatɩkɩrɩ daarɩ keŋye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Buuriŋ nan wagɩ buuriŋ, tɩŋkpaŋŋɩsɩ nan wagɩ tamba, tɩŋgbaŋ nan dɩ dɔma, vuosi nan kpi kɔŋ ama geŋhe baa a yiwo wahalaha piiliŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nɩ daansɩma nɩ gbaŋ, ba nan yigi nɩ a ga naalɩba jigiŋ. Ba nan nɩgɩ nɩ Ŋmɩŋ jɩamɩŋ juone jige, ba nan yi nɩ zie nyɩŋkʋra aŋaŋ naalɩba nɩŋŋa n wɩa, aŋ nɩ balɩ ba Ŋmɩŋ wɩa, ");
INSERT INTO kma_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ama sie Ŋmɩŋ wʋvɩɩnɩŋ tʋgɩ tɩgɩsɩ mana ta dakpatɩkɩrɩ ye keŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba keŋ a yigi nɩ a ga naalɩŋ jigiŋ, nɩ da keŋ vaa ka yi nɩ sʋgɩchʋʋsɩŋ aŋaŋ nɩ baaŋ nan balɩ die, ama saŋka dɩ a keŋ tʋgɩ nɩ balɩ wudieke mana Ŋmɩŋ dɩ bala nɩ balɩ. Dama wudiekemba nɩ balla nɩ balɩ wa kaaŋ yi nɩ wʋbalɩka, a baa a nyɩŋ wa Ŋmɩŋ Haalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vuosi nan nagɩ ba gbaŋ gbaŋ ba nɩmballɩ a yɩ dɩ ba kʋʋ ba, chʋalɩŋ gbaŋ nan yi die gbaŋ gbaŋ a yɩ ba ballɩ. Ballɩ dɩaŋ nan yiŋŋi a wagɩ ba chʋalɩŋ aŋaŋ ba nɩɩlɩŋ ta nagɩ ba a yɩ dɩ ba kʋʋ ba. ");
INSERT INTO kma_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vuoŋ mana nan haa nɩ n wɩa, ama vuodieke dɩ a keŋ bɩagɩ tuoli a mana a ga tʋgɩ dakpatɩkɩrɩ nan ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nɩ nan ye ‘Jabɩaŋ’ dɩ zene jigidieke ka kana ka mʋ ka zie.” (Vuoŋ mana dɩ a keŋ karɩŋ wɩaha gie kpaŋŋɩ ʋ gbaŋ a sɩmma ka chɩaŋ). “Saŋka mi vuodiekemba dɩ benne Judia tɩŋgbaŋ ma nɩ chɩgɩ ga kunkogiŋ me. ");
INSERT INTO kma_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Vuoŋ dɩ a keŋ bie ʋ mampili sikpeŋ ʋ da keŋ a sʋʋŋ a juu tigiri me dɩ ʋ nagɩ jaaŋ a ga. ");
INSERT INTO kma_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Vuodieke dɩ benne kʋaŋ ma da keŋ a kuli tigiŋ a nagɩ ʋ nyiŋyeeke. ");
INSERT INTO kma_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bɩa wʋbɩaŋ balla ka bemme hɔgʋ nyuutitieliŋ me aŋaŋ vuodiekemba dɩ yalla ballɩnyaalɩsɩ! ");
INSERT INTO kma_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nɩ jʋʋsɩma Ŋmɩŋ amʋ wɩaha gie da keŋ a yi yɩbɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Daraaha mi wahala nan faasɩ a tɩaŋ Ŋmɩŋ dɩ naanna dʋnɩa dɩ yaa ga mʋʋna wahala. Wahala dɩaŋ kaaŋ bɩ beri a tɩaŋ naa. ");
INSERT INTO kma_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ŋmɩŋ die dɩ tɩŋ ka gobi daraaha, dɩ mʋna vuoŋ tɩŋ kaaŋ ye gbatɩtaanɩŋ ama ʋ vuovʋarɩkaha wɩa ʋ gobi daraaha. ");
INSERT INTO kma_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Saŋka mi vuoŋ dɩ a keŋ balɩ a yɩ fʋ dɩ, ‘Ye, Ŋmɩŋ vuovʋarɩkɩŋ, Masia wa bie giena yaa ʋ bie mi!’ Da keŋ a tuo wo a dii. ");
INSERT INTO kma_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dama saŋka mi ŋmɩnchɩbɩsɩ Masiasi aŋaŋ ŋmɩnchɩbɩsɩ naazʋalɩba nan keŋ nyɩŋ a tʋŋ mamachi wɩa dɩ ba gaaŋ vuodiekemba Ŋmɩŋ dɩ vʋarɩna wa gbaŋ, ba tɩŋ nan bɩagɩ. ");
INSERT INTO kma_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nɩ mɩŋŋɩ a yalla nɩ gbaŋ, n balɩ nɩ wɩɩŋ mana ta daarɩ ye ka tʋgɩya. ");
INSERT INTO kma_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Wahalaha kʋaŋ chaaŋ ŋmɩnnɩ nan sɩbɩ, chɩɩkʋ kaaŋ bɩ yɩantɩ. ");
INSERT INTO kma_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chɩŋmarɩsɩsɩ nan nyɩŋ ŋmɩŋsikpeŋ a nan, ta nyindieke mana dɩ benne ŋmɩŋsikpeŋ dɔŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Saŋka mi vuosi nan ye vuota Bʋadembiŋ dɩ nyɩnna nɩɩŋmara ma a keŋ sʋʋna aŋaŋ yiko pam aŋaŋ chuulikpeŋkpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ʋ nan tʋŋ malakasisi dɩ ba dɩ dɩa dʋnɩa lʋga mana a lagɩsɩ Ŋmɩŋ vuovʋarɩkaha jigiŋ mana. ");
INSERT INTO kma_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nɩ vaa chunchule tɩɩka dagɩ nɩ yɩaŋ. Ka nagɩsɩ dɩ keŋ pɔsa ta vaatɩ dɩ nyɩnna nɩ sɩmma a baarɩ yɩbɩŋ gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Die gbaŋ gbaŋ dɩ sɩɩ, nɩ bɩ a keŋ a ye ta nyinti gie yie nɩ sɩmma a baarɩ n keniŋ gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wusie nyinti gie mana nan yi ta vuodiekemba mana dɩ benne dʋnɩa mama lele ye kpi. ");
INSERT INTO kma_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋ nan keŋ a tɩaŋ, ama n wʋbalɩka kaaŋ tɩaŋ naa da. ");
INSERT INTO kma_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ama vuoŋ ka sɩba daa dieke yaa saŋŋa dieke wɩaha gie dɩ baaŋ nan yi. Malakasisi gbaŋ gbaŋ dɩ benne arɩzanna ma aŋaŋ manɩŋ vuota Bʋadembiŋ ka sɩba daa dieke sie Ŋmɩŋ nyɩɩna sɩbɩna. ");
INSERT INTO kma_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nɩ gbara, a daansɩma, dama nɩ ka sɩba saŋka dɩ baaŋ nan keŋ saŋŋa dieke wo. ");
INSERT INTO kma_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dɩ baa dɩ sɩmma sɩba daa wʋnyɩ dɩ dɩna a ga tɩŋ, ta vaa ʋ tʋntʋntɩŋ aŋaŋ ba wʋnyɩ mana tʋʋmɩŋ. Ta balɩ dɩ vuodieke dɩ gbarɩnana dɩ ʋ gbara. ");
INSERT INTO kma_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Die wɩa nɩ gbara dama nɩ ka sɩba tigiritieŋ dɩ kienene saŋŋa dieke. Dɩ nan bɩagɩ a yi jɩŋmɩŋ yaa tanseese, yaa kparaaŋ kpaŋ saŋŋa yaa tʋnvʋʋnɩŋ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ʋ a keŋ bʋnyɩ ʋ da keŋ haarɩ fʋ ta gʋʋra. ");
INSERT INTO kma_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","N balla wudieke a yɩ nɩ wa, n balɩ a yɩ wa vuoŋ mana dɩ ʋ gbara!” ");
INSERT INTO kma_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Die dɩ wa tɩalɩ wa daraa ale aŋaŋ gasɩtɩaŋkʋ dʋʋga aŋaŋ daraa diekemba ba dinene paanʋ diekemba ba ŋaana ka yie dabɔtɩ bʋ ma wa piili, ta Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ vuodiekemba die dɩ dagɩnana Ŋmɩŋ mɩraha die dɩ yaala sieŋ aŋ ba maansɩ a yigi Yisa a kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Die ba baarɩ dɩ, “Tɩ ka mʋ tɩ yigi wo dʋʋgaka saŋŋa, dɩ daa die vuosisi nan yi watɩ aŋ waagɩŋ nan.” ");
INSERT INTO kma_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yisa die bie wo Betani, Simoni, vuodieke die dɩ yine gamɩŋ tigiŋ me. Yisa die dɩ kalɩ a die nyindiike ta hɔgʋ wʋnyɩ dɩ a keŋ juu a pɔgɩlɩ tulaari bʋnyɩ ligire die dɩ faasɩna a tʋa ta yaa nyʋʋgɩvɩɩnɩŋ, a yuori kɔlɩbɩka a sitibu a yi Yisa sikpeŋ me. ");
INSERT INTO kma_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vuodiekemba die dɩ benne mi wo bataŋ dɩ jɩɩ sɩnyɩɩrɩŋ a bala a yɩa tamba dɩ, “Bɩa yine ʋ chʋʋsa tulaaribu? ");
INSERT INTO kma_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bʋ tɩŋ nan bɩagɩ a nagɩ a daa ligire pam aŋ tɩ tɩŋ nan nagɩ ligirehe a yɩ zɔɔlɩntieliŋ.” Ta die ba zɩa hɔgʋ wa. ");
INSERT INTO kma_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama Yisa die dɩ balɩ ba dɩ, “Nɩ vaa wa sɔmm, bɩa yine nɩ daama wa? Wʋvɩɩnɩŋ ʋ yi a yɩ mɩŋ dene, ");
INSERT INTO kma_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","nɩ ŋaŋ zɔɔlɩntieliŋ nan dɩ beri daaŋ mana, nɩ keŋ yaala saŋŋa dieke mana nɩ nan suŋŋi be ama n kaaŋ dɩ beri nɩ jigiŋ daaŋ mana. ");
INSERT INTO kma_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ʋ yiwo wudieke ʋ bɩagɩna, ʋ siti wo tulaari a yi n nyɩŋgbanɩŋ ma a gbarɩ saŋŋa dieke ba baaŋ nan guu mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nɩ tuo a dii sɩba jigidieke mana Ŋmɩŋ wʋvɩɩna dɩ baaŋ nan tʋgɩ dʋnɩa mana ma ma, ba nan dɩ bala ʋ yine wudieke wo gie a tɩɩnsa ʋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Womi Judasi Asikaroti, ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo wʋnyɩ dɩ nyɩŋ a ga Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra jigiŋ dɩ ʋ posi Yisa chɩaŋ a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Die ba wʋnna ʋ kenne wudieke wɩa wa, die ba sʋgɩtɩ dɩ fɩalɩ ta yɩ wa lɔlɩŋ dɩ ba nan yɩ wa ligire. Judasi die dɩ wa piili a yaala sievɩɩnɩŋ ʋ baaŋ yi die a nagɩ Yisa a yi ba nuusi me. ");
INSERT INTO kma_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dʋʋgaka bʋmbʋŋaŋ daarɩ, daa dieke daaŋ die ba kʋnana gasɩtɩaŋkʋ yiisehe, Yisa kʋaŋandɩɩsɩrɩba die dɩ pɩasɩ wa dɩ, “Sɩa fʋ yaala tɩ ga wʋnsɩ a gbara gasɩtɩaŋkʋ nyindiikehe a yɩ fʋ?” ");
INSERT INTO kma_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Die ʋ tʋŋ ʋ kʋaŋandɩɩsɩrɩba bale ta balɩ ba dɩ, “Nɩ ga a juu tɩka ma nɩ nan haarɩ daa wʋnyɩ dɩ chine jaaŋ aŋaŋ nyaaŋ, nɩ dɩa wa ");
INSERT INTO kma_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","a ga juu tigidieke me ʋ junene a balɩ tigiritieŋ: ‘Dɩdagɩrʋ wa baarɩ, juoŋ beri mɩŋ manɩŋ aŋaŋ n kʋaŋandɩɩsɩrɩba dɩ baa tɩ dii gasɩtɩaŋkʋ nyindiikehe?’ ");
INSERT INTO kma_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mi ʋ nan dagɩ juokpeŋkpɩɩŋ dɩ benne sikpeŋ me a yallɩ jaaŋ mana a gbarɩ, mi nɩ nan wʋnsɩ wɩɩŋ mana a gbara.” ");
INSERT INTO kma_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ʋ kʋaŋandɩɩsɩrɩba die dɩ ga tɩka ma a ye wɩɩŋ mana die ʋ balla dene gbaŋ gbaŋ. Die ba wʋnsɩ gasɩtɩaŋkʋ nyindiikehe mi. ");
INSERT INTO kma_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jɩŋmɩŋ die dɩ tʋgɩna, Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo die dɩ keŋ mi. ");
INSERT INTO kma_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Die ba gana ga kalɩ a die Yisa dɩ baarɩ dɩ, “N bala nɩ, nɩ wʋnyɩ balla ʋ posi n chɩaŋ, vuodieke aŋaŋ mɩŋ dɩ dinene.” ");
INSERT INTO kma_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ʋ kʋaŋandɩɩsɩrɩba sʋgɩtɩ die dɩ chʋʋsɩ ba pɩasa wa wʋnyɩ wʋnyɩ, a baarɩ dɩ, “Wusie, n ka yi tama dɩ manɩŋ fʋ daga dene?” ");
INSERT INTO kma_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yisa dɩ balɩ ba dɩ, “Dɩ yiwo nɩ baŋ aŋaŋ bale wo gie sʋnsʋŋ wʋnyɩ, vuodieke aŋaŋ mɩŋ dɩ lagɩŋna a luo kpalɩ gie me. ");
INSERT INTO kma_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vuota Bʋadembiŋ nan kpi sɩba Ŋmɩŋ wɩa dɩ dagɩna die wo, ama bɩa wʋbɩaŋ balla ka bemme dembiŋ dieke dɩ balla ʋ posi n chɩaka! Ba tɩŋ ka mɩɩrɩ wa gbaŋ dɩ tɩŋ nan dɩ kpɩa a yɩ wa.” ");
INSERT INTO kma_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Die ba ye ko die mɩŋ Yisa dɩ nagɩ paanʋkʋ a bɩrɩ Ŋmɩŋ a yi ke gbieri gbieri a nagɩ a yɩ ba ta baarɩ dɩ, “Nɩ nagɩ, n nyɩŋgbanɩŋ wʋnna.” ");
INSERT INTO kma_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ta ʋ bɩ nagɩ nyaaŋchibiŋ aŋaŋ daaŋ a bɩrɩ Ŋmɩŋ a yi ke ta nagɩ a yɩ ba, ba mana dɩ nyuu ka ma. ");
INSERT INTO kma_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yisa dɩ balɩ ba dɩ, “N Zɩŋ wʋnna, bʋ balla bʋ nyɩŋ a yɩ vuosi pam, bʋ balla bʋ dagɩ sɩba Ŋmɩŋ yɩ wa nʋahaalɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɩ vaa n balɩ nɩ wusie, n kaaŋ bɩ a nyuu daabʋ gie sie daa dieke n baaŋ nan nyuu daahaalɩbʋ Ŋmɩŋ naarɩ ma.” ");
INSERT INTO kma_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Die ba wa chɩa Ŋmɩŋ jɩamɩŋ yɩlɩ ka kʋaŋ chaaŋ ba chʋŋ ga Olivi Tɩɩsɩ kunkogiri me. ");
INSERT INTO kma_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yisa dɩ balɩ ba dɩ, “Nɩ mana nan chɩgɩ ta va mɩŋ, dama Ŋmɩŋ wʋbalɩka dagɩya dɩ Ŋmɩŋ nan kʋʋ yiyagɩrʋ wa ta yiisehe puo taŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama maŋ a keŋ hagɩ kuŋ me, ka kʋaŋ chaaŋ n nan woliŋ nɩ nɩŋŋa a ga Galili tɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piita dɩ balɩ Yisa dɩ, “Manɩŋ n kaaŋ chɩgɩ ta va fʋ, halɩ vuoŋ mana dɩ chɩgɩ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yisa dɩ balɩ a yɩ Piita dɩ, “Vaa n balɩ fʋ wusie, jinne yuku gie kparaaŋ nan keŋ a baarɩ ka kʋmma bule ta baarɩ zɩ mɩŋ wa bʋtaa.” ");
INSERT INTO kma_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piita dɩ wa faasɩ bɩ balɩ dɩ, “Manɩŋ aŋaŋ fʋ dɩ keŋ baa tɩ kpi gbaŋ n kaaŋ baarɩ n zɩ fʋ!” Ʋ kʋaŋandɩɩsɩrɩ tɩalɩkaha die dɩ balɩ dene gbaŋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Die ba tʋgɩna jigiŋ kaanɩ ba wasɩnana Gatisimani, Yisa dɩ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ kala gie ta n jʋʋsɩ Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta die ʋ yi Piita aŋaŋ Jemisi aŋaŋ Jɔɔn dɩ dɩ wa. Die ʋ sʋŋ dɩ faasɩ chʋʋsɩ sɩba ʋ baa ʋ kpi mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ʋ balɩ ba, “N sʋgɩchʋʋsɩkʋ wa faasɩ dala mɩŋ, a ga yaala ka kʋʋ mɩŋ, nɩ wɩarɩ gie ta yesime.” ");
INSERT INTO kma_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Die ʋ chʋŋ a ga nɩŋŋa bɩta a nagɩ ʋ gbaŋ a taaŋ tɩŋgbaŋ, ta jʋʋsɩ Ŋmɩŋ dɩ, “Dɩ tɩŋ nan bɩagɩ a yi, gbalɩgɩsɩ gie saŋŋa tɩŋ tɩaŋ ta va mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ʋ bɩ baarɩ dɩ, “N chʋa, n chʋa, wɩɩŋ ka bɩagɩ fʋ, nagɩ gbalɩgɩsɩsɩ gie ta fʋ va mɩŋ, ama da n dʋŋŋʋ, vaa fʋ dʋŋŋʋ yi.” ");
INSERT INTO kma_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Die ʋ yiŋŋi a ga ʋ kʋaŋandɩɩsɩrɩba bataa wa jigiŋ ta ba gʋʋra, ʋ pɩasɩ Simoni Piita dɩ, “Simoni, gʋʋra mɩŋ? Tɩŋ kaaŋ bɩagɩ a yesime bɩta gbaŋ?” ");
INSERT INTO kma_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ʋ balɩ ba dɩ, “Nɩ mana hagɩ a gbara ta jʋʋsɩma Ŋmɩŋ, amʋ nɩ da keŋ a jʋʋ magɩsɩŋ ma. Nɩ sʋgɩtɩ yaala nɩ yi wudieke dɩ mʋna, ama nɩ nyɩŋgbaŋka wo hagɩrɩŋ.” ");
INSERT INTO kma_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ʋ bɩ a yiŋŋi a ga jʋʋsɩ a bala wɩaha mi gbaŋ gbaŋ ");
INSERT INTO kma_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ta bɩ yiŋŋi a keŋ ʋ kʋaŋandɩɩsɩrɩba jigiŋ a ye be ba gʋʋrɩnana; dama gbieŋ die yalla ba pam die ba zɩ ba baaŋ balɩ wa die. ");
INSERT INTO kma_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Die ʋ yiŋŋi a keŋ bʋtaa kʋaŋ chaaŋ, ʋ balɩ ba dɩ, “Nɩ ye ko gʋʋra mɩŋ ta voose? Dɩ mʋ! Nɩ daansɩma, saŋka tʋgɩya mɩŋ dɩ ba nagɩ vuota Bʋadembiŋ wa a yi vuobɩatɩ nuusi me. ");
INSERT INTO kma_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nɩ hagɩ tɩ ga. Nɩ daansɩ gie, daa dieke dɩ balla ʋ posi n chɩaka wʋnna.” ");
INSERT INTO kma_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Die ʋ ye ko balla wɩa ta Judasi, ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo sʋŋ wʋnyɩ dɩ keŋ. Die ʋ ŋaŋ daadaŋ pam die kenne, bataŋ dɩ pɔgɩlɩ time bataŋ dɩaŋ dɩ pɔgɩlɩ dengbile. Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ vuodiekemba die dagɩnana Ŋmɩŋ mɩraha aŋaŋ tɩka nyɩŋkʋra die tʋnna ba. ");
INSERT INTO kma_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasi aŋaŋ ba wɔŋ balɩ zieŋ mɩŋ dɩ, “Maŋ a keŋ mʋgɩsɩ vuodieke kaamɩŋ, daa dieke nɩ yaalala wa ʋ wondene, nɩ yigi wo a mɩŋŋɩ pɔgɩlɩ wa a yaa wa a ga.” ");
INSERT INTO kma_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judasi die dɩ dene tʋgɩ mi ʋ ga Yisa jigiŋ a baarɩ dɩ, “Dɩdagɩrʋ!” Ta mʋgɩsɩ ʋ kaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Die wɩa die ba yigi wo a mɩŋŋɩ pɔgɩlɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ʋ kʋaŋandɩɩsɩrɩba die dɩ zene mi wo wʋnyɩ dɩ vʋarɩ jɩbɩŋ a gobi Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra yɔmʋ wʋnyɩ tɩbɩŋ a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yisa die dɩ pɩasɩ ba dɩ, “Nɩ nagɩ wa manɩŋ a bɩrɩŋ wa gaarʋ a wa nagɩ time aŋaŋ dengbile a keŋ nɩ yigi mɩŋ? ");
INSERT INTO kma_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Daaŋ mana die n bie wo nɩ jigiŋ a daga nɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma, ta nɩ ka yigi mɩŋ. Ama sie Ŋmɩŋ wʋbalɩka keŋ a yi wusie.” ");
INSERT INTO kma_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Die ʋ kʋaŋandɩɩsɩrɩba mana die dɩ dɩna ʋ kʋaka dɩ chɩgɩ ta va wa. ");
INSERT INTO kma_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dalʋakɩŋ wʋnyɩ die dɩ bɔbɩ garɩŋ nyɩɩna a dɩ Yisa kʋaŋ, die ba yaala ba yigi wo ta yigi ʋ garɩŋ ta garɩkʋ dɩ forisi ");
INSERT INTO kma_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ʋ va garɩkʋ ba nuusi me ta chɩgɩ yɔrɩ a ga. ");
INSERT INTO kma_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Die ba yaa Yisa a ga Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ tigiŋ, die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ tɩŋgbaŋka mana nyɩŋkʋra aŋaŋ vuodiekemba die dɩ dagɩnana Ŋmɩŋ mɩraha die dɩ lagɩsɩ mi. ");
INSERT INTO kma_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piita die bie wo saasaa a dɩ ba kʋaŋ a ga juu Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ gbaakʋ ma. Die ʋ kalɩ mi aŋaŋ gbɩgbarɩtʋ a weeli boliŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ nyɩŋkʋraha mana die dɩ yaala ba yaalɩ Yisa wʋbɩaŋ amʋ ba kʋʋ wa ta die yaalɩ a waarɩ. ");
INSERT INTO kma_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vuosi pam die dɩ chibi ŋmɩnchɩbɩsɩ a yɩ wa ama ba ŋmɩnchɩbɩsɩ die dɩ ka dɩ tamba. ");
INSERT INTO kma_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mi bataŋ die dɩ hagɩ a chibi ŋmɩnchɩbɩsɩ gie a yɩ wa: ");
INSERT INTO kma_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Die tɩ wʋŋya ʋ balla dɩ, “N nan kpaŋŋɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gie vuota dɩ nagɩna ʋ nuusi a mɩɩ a taaŋ, ama ka daraa ataa kʋaŋ chaaŋ n nan mɩɩ kaanɩ, vuota nuuŋ dɩ kana ka mɩɩ ka.” ");
INSERT INTO kma_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aŋaŋ die mana yɔrɩ ba ŋmɩnchɩbɩsɩ die dɩ ka dɩa tamba. ");
INSERT INTO kma_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Womi Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ dɩ hagɩ a zie ba jigiŋ a pɩasɩ Yisa dɩ, “Wo wʋbalɩkɩŋ balɩŋ yaa gamma wɩaha gie vuosisi dɩ balala wa?” ");
INSERT INTO kma_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama Yisa die dɩ tarɩ ta ka yuori ʋ nʋaŋ. Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ dɩ bɩ pɩasɩ Yisa dɩ, “Fʋ yine Masia, Nabidie Ŋmɩŋ Bʋadembiŋ wa?” ");
INSERT INTO kma_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yisa dɩ baarɩ dɩ, “N yine wo, nɩ nan ye vuota Bʋadembiŋ dɩ kala Nabidie Ŋmɩŋ nuudiigiŋ chaaŋ a kieŋ aŋaŋ ŋmɩŋsikpeŋ nɩɩŋmara.” ");
INSERT INTO kma_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ dɩ jɩɩ sɩnyɩɩrɩŋ ta chɩɩrɩ ʋ nyiŋyeeke ta baarɩ dɩ, “Tɩ ka bɩ yaala daansɩatieliŋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nɩ wʋŋ ʋ zana Ŋmɩŋ, lalɩa nɩ balɩ?” Die ba mana dɩ saagɩ dɩ ʋ chʋʋsɩya mɩŋ, dɩ die wɩa ba kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bataŋ die dɩ piili a tɩɩra nɩntɔbɩtɩ a yie Yisa. Die ba mʋʋ ʋ nine ta nɩgɩ wa, ta pɩasɩ wa dɩ ʋ bʋgɩ a ye vuodieke dɩ nɩgɩna wa. Vuodiekemba die dɩ gbarɩna dɩ nagɩ wa ta fala wa. ");
INSERT INTO kma_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piita die ye bie wo gbaakʋ ma, ta Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ tʋntʋntɩba hɔgʋ wʋnyɩ die dɩ keŋ mi. ");
INSERT INTO kma_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Die ʋ yene Piita dɩ weelinene bolibu ʋ mɩŋŋɩ daansɩ wa ta baarɩ dɩ, “Fʋ gbaŋ die gʋtɩ wa Yisa, Nazeriti vuoke me.” ");
INSERT INTO kma_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ama Piita dɩ baarɩ, “Aayɩ, N ka sɩba fʋ balala wudieke wo. N ka sɩba ka chɩaŋ.” Ta chʋŋ a ga sanʋarɩ tʋŋ. ");
INSERT INTO kma_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Die hɔgʋ wa gie die dɩ yene womi, ʋ piili a bala a yɩa vuodiekemba die dɩ zene mi dɩ, “Daa wa gie gbaŋ yiwo Yisa kʋaŋandɩɩsɩrɩba wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ama Piita dɩ baarɩ dɩ, “Aayɩ” bɩbra. Die dɩ yine sʋaa vuodiekemba die dɩ zene mi dɩ balɩ Piita bɩbra, “Kaaŋ bɩagɩ a baarɩ ka yi Yisa kʋaŋandɩɩsɩrɩba wʋnyɩ, dama fʋ gbaŋ nyɩŋ wa Galili.” ");
INSERT INTO kma_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piita die dɩ hʋʋ dɩ, “Ŋmɩŋ datɩ n tɩbɩŋ maŋ keŋ ka bala wusie! N ka sɩba daa dieke nɩ balala wa.” ");
INSERT INTO kma_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Womi kparaaka die dɩ kʋŋ ka bule ma ma. Piita die dɩ tɩɩnsɩ Yisa die dɩ balla wudiekemba a yɩ wa wa: “Kparaaŋ nan keŋ a baarɩ ka kʋmma bule wo ta baarɩ zɩ manɩŋ bʋtaa.” Die ʋ piili kpaŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tʋŋ die dɩ vʋnna sʋkʋleeliŋ, Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩŋgbaŋka nyɩŋkʋra aŋaŋ Ŋmɩŋ mɩra dɩdagɩrɩba aŋaŋ nyɩŋkʋra mana die dɩ balɩ a zieŋ ba balla ba yi wudieke. Die ba bɔbɩ Yisa a yaa wa a ga Paliti jigiŋ a nagɩ wa a yi Paliti nuusi me. ");
INSERT INTO kma_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paliti dɩ pɩasɩ wa dɩ, “Fʋnɩŋ fʋ yine Juu vuosisi naaŋ wa?” Yisa dɩ baarɩ dɩ, “Wa, fʋ balɩna.” ");
INSERT INTO kma_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha die dɩ balɩ wʋbɩatɩ pam yaa gamma Yisa ma. ");
INSERT INTO kma_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Paliti dɩ bɩ pɩasɩ Yisa bɩbra dɩ, “Ka baa fʋ balɩ wɩɩŋ? Ye ba balla dɩ yi wudiekemba!” ");
INSERT INTO kma_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yisa die dɩ bɩ tarɩ bɩbra, die dɩ yi Paliti mamachi. ");
INSERT INTO kma_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Die dɩ yiwo ba buuriŋ wɩɩŋ dɩ gasɩtɩanɩŋ dʋʋga saŋŋa mana ba dagɩ vuobalɩmɩŋ dansarɩka sʋŋ aŋ Paliti vʋarɩ wa a taaŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Saŋka mi daa wʋnyɩ die dine Barabasi a bie dansarɩka sʋŋ ʋ ŋaŋ vuosi bataŋ. Die ba wagɩ wa Paliti vuosi a yalla ba gbatɩ Juu vuosi a nyɩŋ Paliti vuosisi nuusi me, waagɩbʋ sʋŋ die vuosi bataŋ die dɩ kpi, die wɩa die ba ligi be. ");
INSERT INTO kma_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Daadamba die dɩ lagɩŋ a balla Paliti dɩ ʋ yi ʋ ŋaana a wɔŋ yie die wo a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Paliti die dɩ pɩasɩ ba dɩ, “Nɩ yaala n vʋarɩ Juu vuosisi naaŋ wa a yɩ nɩ?” ");
INSERT INTO kma_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Die ʋ paalɩ sɩba a baarɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha die yaa wa Yisa a keŋ a yɩ wa mɩŋ dama die ba yiwo sugigolitieliŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama Ŋmɩŋ jɩamɩŋ nyɩŋkʋraha die dɩ hagɩ a zie vuosi me a balɩ ba dɩ ba baarɩ Paliti vʋarɩ Barabasi a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Paliti dɩ bɩ pɩasɩ daadamba dɩ, “Ta bɩa nɩ wa yaala n yi vuodieke nɩ wasɩnana Juu vuosisi naaŋ wa?” ");
INSERT INTO kma_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Die ba yiŋŋi a natɩ a baarɩ dɩ, “Kpaasɩ wa a diisi dagarɩkʋ ma!” ");
INSERT INTO kma_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ama Paliti die dɩ pɩasɩ ba dɩ, “Taalɩ bɩa ʋ yi?” Ba bɩ faasɩ natɩ dɩ, “Kpaasɩ wa a diisi dagarɩkʋ ma.” ");
INSERT INTO kma_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paliti die yaala daadamba sʋŋ fɩalɩ die wɩa ʋ vʋarɩ Barabasi a yɩ ba. Ta die wa yi sojasisi dɩ nɩgɩ Yisa aŋaŋ kpaasɩŋ ta wa nagɩ wa a yɩ dɩ ba ga kpaasɩ wa dagarɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Die sojasisi dɩ wa nagɩ Yisa a juu Paliti gbaakʋ ma ta wa sojasi tɩalɩkaha. ");
INSERT INTO kma_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Die ba nagɩ guuŋmɩnɩŋ a yeegi wo, ta nagɩ haŋgɔɔsɩ a wʋnsɩ sibubiŋ a bubi ʋ sikpeŋ me. ");
INSERT INTO kma_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta piili a waasa wa dɩ, “Juu vuosisi naaŋ, dʋa dʋa!” ");
INSERT INTO kma_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Die ba nɩgɩ ʋ sikpeŋ me aŋaŋ daaŋ, a tɩɩrɩ nɩntɔbɩtɩ a yi wo ta gbirigi ba dune me a yie sɩba ba jɩama ba naaŋ wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Die ba vʋarɩna wa falaha a kpatɩ wa ba yiŋŋi a vʋarɩ garɩguuŋmɩmbʋ ta nagɩ ʋ gbaŋ gbaŋ ʋ nyiŋyeeke a yeegi wo. Ta yaa wa a gara dɩ ba ga kpaasɩ wa dagarɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Die ba ganana wa ba ga tuoli Simoni, Alekizanda aŋaŋ Rufusi chɔɔŋ, die ʋ yiwo Sayireni tɩŋgbaŋ vuoŋ ta ʋ nyɩŋ jigiŋ a keŋ a juo tɩka ma ba mugisi wo ʋ tuo dagarɩkʋ a chii. ");
INSERT INTO kma_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Die ba yaa Yisa a ga jigidieke ba wasɩnana Gɔlɩgɔta (ka chɩaŋ wone sikpeŋkogilike jigiŋ). ");
INSERT INTO kma_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mi vuosi bataŋ die dɩ nagɩ daaŋ aŋaŋ tɩɩŋ dieke ba wasɩnana mɩrɩ a lagɩŋ taŋ a yɩ wa, die ʋ zeti bʋ nyuule. ");
INSERT INTO kma_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Die ba kpaasɩ wa a diisi dagarɩkʋ ma ta nagɩ ʋ nyiŋyeeke a puo dʋaŋ ta yi chaachaa ba wʋnyɩ mana dɩ baaŋ nan ye die. ");
INSERT INTO kma_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Die ba kpaasɩ wa wa sʋkʋʋŋ hawasɩ awayɩ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Die ba nagɩ gbanɩŋ a maagɩ wɩɩrɩ gie wɩa ba kpaasɩna wa a diisi dagarɩkʋ sikpeŋ dɩ, ");
INSERT INTO kma_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Die ba bɩ kpaasɩ wa gaarɩŋ bale dagarɩsɩ ma a gʋtɩ ʋ ma, wʋnyɩ dɩ bie ʋ nuudiigiŋ ta wʋnyɩ wa dɩaŋ dɩ bie ʋ nuugalɩ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","((Naa die yine sɩba Ŋmɩŋ gbanɩŋ die dɩ maagɩna dene dɩ, “Die ba nagɩ wa a gʋtɩ vuobɩatɩ ma.”)) ");
INSERT INTO kma_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vuodiekemba die dɩ tɩannana die ŋaaŋ vigi wo ba sikpigile ta taanna jome Yisa ma dɩ, “Aha! Die fʋ bala nan kpaŋŋɩ Ŋmɩŋ Jɩamɩŋ juokpeŋkpɩɩkʋ a taaŋ ta daraa ataa kʋaŋ fʋ mɩɩ ka wa! ");
INSERT INTO kma_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Lele keŋ a sʋʋŋ dagarɩkʋ sikpeŋ a gbatɩ fʋ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Ŋmɩŋ mɩraha dɩdagɩrɩba gbaŋ die dɩ vʋara Yisa fala ta bala a yɩa taŋ dɩ, “Die bɩagɩ a gbata bataŋ ta kaaŋ bɩagɩ a gbatɩ fʋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nɩ vaa tɩ ye Masia wa, Izara vuosisi naaŋ wa nan keŋ a sʋʋŋ dagarɩkʋ ma aŋ tɩ yi wo yada!” Die gaarɩŋ bale diekemba ba kpaasɩna a gʋtɩ ʋ ma wa gbaŋ die zɩa wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Die ŋmɩŋ dɩ wana a ga tʋgɩ sikpeŋ sʋnsʋŋ, tɩŋgbaŋka mana mana die dɩ sibi. Die ka sibi wo dee a ga tʋgɩ ŋmɩŋgbɩlɩkɩŋ hawasɩ ataa saŋŋa. ");
INSERT INTO kma_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hawasɩ ataa wa kʋaŋ chaaŋ Yisa dɩ faasɩ a keesi a baarɩ dɩ, “Eloyi, Eloyi lema Sabakitani?” Ka chɩaŋ wone, “N Ŋmɩŋ, n Ŋmɩŋ, bɩa yine fʋ va mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Die vuodiekemba die dɩ zene mi wo bataŋ dɩ wʋnna naa, ba baarɩ dɩ, “Nɩ wʋmma, ʋ wasa Elaja.” ");
INSERT INTO kma_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba wʋnyɩ die dɩ chɩgɩ a ga nagɩ gbara alʋ daŋmɩɩsɩŋ ma ta nagɩ ka sagɩ daaŋ ma a yaa ka a yɩ Yisa dɩ ʋ tuo nyuu, ta baarɩ dɩ, “Lele nɩ wa vaa ʋ nyɩɩna aŋ tɩ ye sɩba Elaja nan keŋ a sʋʋŋ wa dagarɩkʋ ma?” ");
INSERT INTO kma_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yisa die dɩ faasɩ keesi ta kpi. ");
INSERT INTO kma_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Die garɩ dieke die dɩ sagɩna a puo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ bule wo, die dɩ puo bule a nyɩŋ sikpeŋ mi a keŋ sʋʋŋ chɩaŋ ma. ");
INSERT INTO kma_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Die sojasisi jakʋʋŋ dieke die dɩ zene mi a ye Yisa dɩ keesine dene wo ta kpi wo dɩ baarɩ dɩ, “Daa wa gie die seŋ yiwo Ŋmɩŋ Bʋa.” ");
INSERT INTO kma_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hɔɔŋ bataŋ die gana a ga zie saasaa ta daansa. Meri Magidalini aŋaŋ Salome aŋaŋ Meri vuodieke dɩ yine Jemisi bike aŋaŋ Josefu nuŋ die gʋtɩna hɔgʋba sʋŋ a zie mi. ");
INSERT INTO kma_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hɔgʋba gie die dɩ wa Yisa a suŋŋi wo saŋŋa dieke die ʋ benne Galili me. Hɔgʋ diekemba die dɩ dɩna wa a ga Jerusalemi gbaŋ die gʋtɩ bie mi. ");
INSERT INTO kma_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dɩnɩŋ daarɩ mi jɩŋmɩŋ die dɩ tʋgɩna, Josefu vuodieke dɩ nyɩnna Arimatia die dɩ keŋ a tʋgɩ mi. ");
INSERT INTO kma_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josefu die yiwo vuodieke die ba yɩnana jɩlɩma Juu vuosisi nyɩŋkʋraha sʋŋ ta die ʋ chɩɩsa Ŋmɩŋ naarɩ dɩ baaŋ nan keŋ saŋŋa dieke. Dɩnɩŋ daarɩ mi ba gɔmɩsɩ a gbarɩ davʋʋsɩkɩrɩ daraaŋ. Die Josefu die dɩ dɩ dembisi ta ga Paliti jigiŋ a jʋʋsɩ wa dɩ ʋ vaa ʋ nagɩ Yisa nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Die dɩ yiwo Paliti mamachi ʋ wʋnna dɩ Yisa wɔŋ kpi mɩŋ. Paliti die dɩ wa sojasisi jakʋʋrɩ a pɩasɩ sɩba Yisa kpi yʋasɩ mɩŋ? ");
INSERT INTO kma_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Die sojaka die dɩ balla wa dɩ Yisa kpiye mɩŋ, ʋ balɩ a yɩ Josefu dɩ ʋ nan bɩagɩ a ga nagɩ Yisa nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefu die dɩ daa garɩŋ a nagɩ Yisa nyɩŋgbaŋka a sʋʋŋ dagarɩkʋ ma ta a vili Yisa nyɩŋgbaŋka a nagɩ ka a dʋaŋ ba tune vɔrɩŋ dieke taŋ lʋgɩŋ ma. Ta die wa nagɩ taŋkpeŋkpɩɩŋ a ligi vɔrɩkʋ nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magidalini aŋaŋ Meri vuodieke dɩ yine Josefu nuŋ die zie a daansa mɩŋ, a die ye ba nagɩna Yisa a dʋaŋ jigidieke wo. ");
INSERT INTO kma_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Die davʋʋsɩkɩrɩ daarɩŋ die dɩ tɩanna, Meri Magidalini aŋaŋ Meri vuodieke dɩ yine Jemisi nuŋ aŋaŋ Salome die dɩ daa tulaari dɩ ba yaa a ga a duuri Yisa nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Alasiri daraaŋ sʋkʋleeliŋ, die ba ga ʋ vɔrɩkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Die ba chʋnnana sieku me wo ba pɩasa taŋ dɩ, “Mɩnɩa balla ʋ biliŋ tanɩ vɔrɩkʋ nʋarɩ ma a yɩ tɩ?” ");
INSERT INTO kma_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(Tanɩ die yiwo taŋkpeŋkpɩɩŋ.) Die ba daansɩ a ye ta tanɩ wɔŋ a biliŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Die wɩa die ba juu vɔrɩkʋ ma a ye dalʋakɩŋ wʋnyɩ dɩ kalla nuudiigiri chaaŋ a yeegi nyɩŋyɩala, ŋmaamɩŋ die dɩ yigi be. ");
INSERT INTO kma_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Daa wa die dɩ baarɩ dɩ, “Nɩ da vaa ŋmaamɩŋ yalla nɩ. Nɩ yaala Yisa, vuodieke dɩ nyɩnna Nazeriti wa, die ba kpaasɩna dagarɩkʋ ma wa, ama ʋ wo giena ʋ hagɩ kuŋ me mɩŋ! Nɩ daansɩ gie, giena die ba nagɩ wa a dʋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nɩ gamma a balɩ ʋ kʋaŋandɩɩsɩrɩba aŋaŋ Piita: ʋ baa ʋ dɩa nɩ nɩŋŋa a gamma Galili me; nɩ nan ye wo mi sɩba die ʋ balla nɩ die wo.” ");
INSERT INTO kma_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Die wɩa die dɩ yi ŋmaamɩŋ aŋaŋ mamachi die dɩ juu be, ba chɩgɩ a nyɩŋ vɔrɩkʋ ma. Die ba ka balɩ vuoŋ wɩɩŋ, dama ŋmaamɩŋ die yalla ba. (( ");
INSERT INTO kma_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Die Yisa dɩ hagɩna kumbu me wo dɩnɩŋ daarɩ mi sʋkʋʋŋ die ʋ woliŋ nyɩŋ wa Meri Magidalini jigiŋ vuodieke ma die ʋ yagɩna jɩmbɩatɩ ayʋpɔyɩ wa. ");
INSERT INTO kma_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meri Magidalini die dɩ ga a balɩ Yisa zʋalɩŋ die dɩ faasɩna kʋmma aŋaŋ sʋgɩchʋʋsɩkʋ dɩ Yisa hagɩ kuŋ me mɩŋ. ");
INSERT INTO kma_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Die ba wʋnna Meri Magidalini dɩ balla dɩ Yisa hagɩya mɩŋ wa, ta wʋnɩŋ ʋ ye wo wo, die ba ka yi wo yada. ");
INSERT INTO kma_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Naa kʋaŋ chaaŋ die ʋ kʋaŋandɩɩsɩrɩba bale die dɩ nyɩŋ tɩka sʋŋ a chʋŋ sieŋ me. Die ʋ tarɩgɩ ʋ gbaŋ a nyɩŋ ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Die ba yiŋŋi a ga balɩ banɩŋ ba, ama die ba ka yi be yada. ");
INSERT INTO kma_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kʋaŋ kʋaŋ chaaŋ Yisa die dɩ nyɩŋ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ kaanɩ wa jigiŋ ta ba die. Die ʋ galɩŋ ba dɩ ba yine sikpeŋ hagɩrɩtieliŋ ba kana ka tuo dii vuodiekemba die dɩ balla ba dɩ ba ye wo ʋ hagɩna kumbu me wo. ");
INSERT INTO kma_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ʋ bɩ balɩ ba dɩ, “Nɩ gamma dʋnɩa mana mana a balɩ Ŋmɩŋ wʋvɩɩnaha a yɩ vuoŋ mana. ");
INSERT INTO kma_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Vuodieke mana dɩ a keŋ a tuo mɩŋ a dii ta nɩ sɩɩ wa Ŋmɩŋ nyaaŋ nan ye gbatɩtaanɩŋ, ama vuodieke mana dɩ a keŋ a ka tuo mɩŋ a dii Ŋmɩŋ nan dii dɩ tieŋ sarɩya a baarɩ ʋ chʋʋsɩya. ");
INSERT INTO kma_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wɩaha gie nan dɩ dɩ vuodiekemba dɩ bala ba tuo mɩŋ a dii wo: ba nan dɩ yaga jɩmbɩatɩ n saaŋ ma: ba nan dɩ bala wʋbalɩkɩ gaasɩ. ");
INSERT INTO kma_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba nan dɩ naga nyinvuuke aŋaŋ ba nuusi, ta nyuu batɩgɩsɩ ta wɩɩŋ kaaŋ yi be. Ba nan nagɩ ba nuusi a diisi yʋagɩtieliŋ me aŋ ba ye alaafɩa.” ");
INSERT INTO kma_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yisa die dɩ balla wɩaha a kpatɩ wa, die Ŋmɩŋ dɩ nagɩ wa a jʋalɩ Arɩzanna ma, Yisa dɩ ga kalɩ ʋ nuudiigiŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ ga a dagɩ jigiŋ mana, Ŋmɩŋ die dɩ suŋŋi be a yɩ ba hagɩrɩŋ aŋ ba yi mamachi tʋʋma a dagɩ sɩba ba wɩaha die yiwo wusie.))");
INSERT INTO kma_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","N zʋa Tiwofilusi: Vuosi pam kpaŋŋɩna ba gbaŋ a maagɩ wudiekemba die dɩ yine tɩ sʋnsʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Die ba maagɩ wa wudiekemba vuodiekemba die dɩ benne piiliku me wo dɩ yene ta balɩ tɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naa chɩaŋ ma die n gbaŋ gbaŋ die n mɩŋŋɩna a pɩasɩ a sɩba wɩaha gie mana chɩasɩsɩ a piiliku me wo aŋaŋ a ganana die wo, ta yile dɩ dɩ nan dɩ vɩɩna n mɩŋŋɩna maagɩ a dɩɩsɩna die a yɩ fʋ. ");
INSERT INTO kma_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","N yiwo naa amʋ fʋ sɩmma wudiekemba mana ba dagɩna fʋ wa chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saŋŋa dieke Herodi die dɩ yine Judia naakpeŋkpɩɩka, die Ŋmɩŋ kɩkaabɩtʋ wʋnyɩ die benne ba wasa wa Zakaria, die ʋ nyɩŋ wa Abija, Ŋmɩŋ kɩkaabɩtʋ buuriŋ ma; die ʋ hɔgʋ Elizabeti dɩaŋ die yiwo Arɔni haagɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ba bale wo mana beriŋ die vɩɩna mɩŋ Ŋmɩŋ jigiŋ, ta ba mɩŋŋɩ a dɩ Ŋmɩŋ mɩraha aŋaŋ ʋ sieti mana. ");
INSERT INTO kma_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama die ba wo ballɩ dama Elizabeti die yiwo hɔgʋpɩrɩŋ, ta ʋ ŋaŋ Zakaria mana die dɩ faasɩ kʋrɩŋ aŋaŋ ba baaŋ mɩɩrɩ. ");
INSERT INTO kma_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Daaŋ kaanɩ Zakaria aŋaŋ ʋ chaakʋ tʋʋma saŋŋa dɩ keŋ tʋgɩ, ta die ʋ ga tʋmma a yɩa Ŋmɩŋ, sɩba ʋ ŋaana yie die wo. ");
INSERT INTO kma_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Die ba taa wa daraa a vʋarɩ wa sɩba banɩŋ Ŋmɩŋ kɩkaabɩtɩba dagɩŋ dɩ sɩna die, dɩ ba vʋarɩ vuodieke dɩ baaŋ nan juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a jʋʋ Ŋmɩŋ nyɩnnyʋʋgaha. Die ba taa daraaha ta die Zakaria die dɩ dii. Die wɩa die ʋ ga juu juoku, ");
INSERT INTO kma_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ta daadamba die dɩ zie yenni me a jʋʋsa Ŋmɩŋ saŋŋa dieke ʋ jʋnana nyɩnnyʋʋgaha. ");
INSERT INTO kma_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Womi Ŋmɩŋ malaka die dɩ keŋ a nyɩŋ ʋ jigiŋ a zie Ŋmɩŋ koriku nuudiigiŋ chaaŋ jigidieke ʋ jʋna nyɩnnyʋʋgaha. ");
INSERT INTO kma_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Die Zakaria dɩ yene wo wo die ʋ sɩkpaaŋ dɩ vʋʋ ta ŋmaamɩŋ dɩ yigi wo. ");
INSERT INTO kma_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama ta malakaka die dɩ balɩ a yɩ wa dɩ, “Zakaria, da vaa ŋmaamɩŋ yalla fʋ! Ŋmɩŋ wʋŋ fʋ jʋʋsɩkʋ mɩŋ, ta fʋ hɔgʋ Elizabeti nan mɩɩrɩ bʋadembiŋ a yɩ fʋ, ta nɩ nan wa wa Jɔɔn. ");
INSERT INTO kma_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Fʋ sʋŋ nan faasɩ fɩalɩ fʋ bʋa wa mɩɩrɩŋ wɩa ta vuosi pam dɩaŋ sʋgɩtɩ nan fɩalɩ ba mɩɩrɩna wa wɩa, ");
INSERT INTO kma_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","dama ʋ baa ʋ yiwo vuokpɩɩŋ Nabidie Ŋmɩŋ nɩŋŋa. Ʋ ka baa ʋ nyu daaŋ yaa daahagɩrɩŋ. Ʋ nan suuli aŋaŋ Ŋmɩŋ Haalɩŋ a nyɩŋ saŋŋa dieke ʋ nuŋ dɩ yalla ʋ nyuuti. ");
INSERT INTO kma_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ʋ nan yi Izara vuosi pam yiŋŋi keŋ ba Yɔmʋtieŋ Ŋmɩŋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ʋ nan dɩ yallɩ Ŋmɩŋ Haalɩŋ aŋaŋ hagɩrɩŋ sɩba Ŋmɩŋ naazʋa Elaja die dɩ yalla hagɩrɩbʋ die wo. Ʋ nan woliŋ tɩ Yɔmʋtieŋ, ʋ nan yi vuosi yaalɩma ba ballɩ bɩbra, ta yi vuodiekemba dɩ kana ka dɩɩ Ŋmɩŋ aŋ ba yaala ba tuo ʋ nʋaŋ, ʋ nan bɩ yi aŋ vuosi yi siri a gbara ba Yɔmʋtieŋ keniŋ.” ");
INSERT INTO kma_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria die dɩ balɩ a yɩ malakaka dɩ, “Lalɩa maŋ baaŋ yi a sɩmma a baarɩ naa bala ka yi? Dama n yiwo daajakʋʋŋ, ta n hɔgʋ dɩaŋ dɩ faasɩ a kʋrɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malakaka die dɩ yiŋŋi a balɩ wa dɩ, “Manɩŋ, n yiwo Gabiriali, vuodieke dɩ kalla Ŋmɩŋ nɩŋŋa; ta ʋ tʋŋ mɩŋ dɩ n keŋ balɩ wʋvɩɩnaha gie a yɩ fʋ. ");
INSERT INTO kma_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ama ka tuo n wɩaha dii wudieke dɩ bala ka yi saŋŋa dieke dɩ mʋna. Fʋ kana ka tuo mɩŋ dii wo wɩa, kaaŋ bɩagɩ a balɩ wɩa a ga tʋgɩ daa dieke wɩaha dɩ balla a keŋ yi wusie.” ");
INSERT INTO kma_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ama daadamba die dɩ zie a chɩɩsa Zakaria ta yile dɩ bɩa ʋ yʋasɩ die Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Die ʋ kenne a nyɩŋ wa, die ʋ ka bɩagɩ a balɩ wɩa a yɩ ba. Die ba mɩŋŋɩ dɩ ʋ ye wo wɩɩŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ. Die ʋ kana ka bɩagɩ bala wɩaha, die ʋ nagɩ ʋ nuusi a dagɩ ba wɩa. ");
INSERT INTO kma_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Die ʋ tʋʋma saŋŋa Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma dɩ tɩanna wa, die ʋ yiŋŋi kuli. ");
INSERT INTO kma_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Naa kʋaŋ chaaŋ ʋ hɔgʋ Elizabeti die dɩ yigi nyuuti, ta die lɔbɩrɩ ʋ gbaŋ tigiri me a ga tʋgɩ chɩɩtɩ anʋ, ");
INSERT INTO kma_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ta die ʋ keŋ balɩ a yɩ ʋ gbaŋ dɩ, “N Yɔmʋtieŋ Ŋmɩŋ tʋnna naa a yɩ mɩŋ, ta chɩgɩ mɩŋ zɔɔlɩŋ a vʋarɩ mɩŋ viivi me.” ");
INSERT INTO kma_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeti nyuuti chɩɩtɩ ayʋaba ma Ŋmɩŋ die dɩ tʋŋ ʋ malaka Gabiriali ʋ ga tɩŋ kaanɩ dɩ benne Galili tɩŋgbaŋ ma ba wasɩnana Nazeriti, ");
INSERT INTO kma_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dɩ ʋ yaa tʋntʋmɩŋ a ga yɩ havʋʋbiŋ wʋnyɩ die dɩ zɩna dembiŋ ta die baa ʋ yallɩ daa wʋnyɩ ba wasɩnana Josefu, vuodieke die dɩ yine naaŋ Davidi haagɩŋ. Havʋʋbike saaŋ die yine Meri. ");
INSERT INTO kma_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Die malakaka dɩ keŋ ʋ jigiŋ a baarɩ dɩ, “Sʋgɩdʋagɩŋ bie fʋ ma, tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ bie fʋ jigiŋ ta yi alibarika a yi fʋ pam!” ");
INSERT INTO kma_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri sɩkpaaŋ die dɩ faasɩ vʋʋ yaa gamma malakaka wʋbalɩkaha ma, die ʋ yile wɩaha chɩasɩ dɩ sɩna die. ");
INSERT INTO kma_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malakaka die dɩ balɩ a yɩ wa dɩ, “Meri, daa vaa ŋmaamɩŋ yalla fʋ dama Ŋmɩŋ sʋŋ fɩalɩ fʋ ma. ");
INSERT INTO kma_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nan yigi nyuuti a mɩɩrɩ bʋadembiŋ aŋ nɩ wa wa Yisa. ");
INSERT INTO kma_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ʋ baa ʋ yiwo vuokpɩɩŋ ta ba wasɩma wa Nabidie Ŋmɩŋ Bʋa. Tɩ Yɔmʋtieŋ Ŋmɩŋ nan yiwo naakpeŋkpɩɩŋ sɩba ʋ chɔɔŋkʋʋŋ Davidi die dɩ sɩna die wo, ");
INSERT INTO kma_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ʋ baa ʋ yiwo Jakobu haagɩsɩ sʋŋ naakpeŋkpɩɩŋ haahuu, ta ʋ naarɩ wo kpatɩŋ!” ");
INSERT INTO kma_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri dɩ pɩasɩ malakaka dɩ, “N zɩ dembiŋ, ta naa baa ka lɩa a yi?” ");
INSERT INTO kma_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Die malakaka die dɩ yiŋŋi a balɩ a yɩ wa dɩ, “Ŋmɩŋ Halɩkasɩka nan keŋ a sʋʋŋ fʋ ma, ta Ŋmɩŋ hagɩrɩbʋ nan ligi fʋ. Naa chɩaŋ ma ba nan wa bʋakasɩ wa Ŋmɩŋ bʋa. ");
INSERT INTO kma_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ama sɩmma a baarɩ fʋ sʋgɩtaa Elizabeti vuodieke dɩ kʋrɩnna wa, lele ʋ yigi wo nyuuti, chɩɩta ayʋaba wʋnna a baa ʋ mɩɩrɩ bʋadembiŋ, wʋnɩŋ vuodieke die ba wasɩnana wa hɔgʋpɩrɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","dama wɩɩŋ wori Ŋmɩŋ dɩ kaaŋ bɩagɩ a yi.” ");
INSERT INTO kma_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri die dɩ baarɩ dɩ, “Tɔ, manɩŋ n yiwo Ŋmɩŋ yɔmʋ, die yi a yɩ mɩŋ sɩba fʋ bala die wo.” Die malakaka die dɩ wa a nyɩŋ a ga ta va wa. ");
INSERT INTO kma_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ka kʋaŋ chaaŋ Meri die dɩ yi siri lagɩ lagɩ a ga tɩŋ kaanɩ Judia ma, Judia tɩŋgbaŋ yaa wa kunkoge, ");
INSERT INTO kma_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","mi ʋ ga juu Zakaria tigiŋ me a waasɩ Elizabeti. ");
INSERT INTO kma_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti die dɩ wʋnna Meri waasɩkʋ, bʋanyaalɩka die dɩ dɔŋ ʋ nyuuti ma. Womi die Ŋmɩŋ Haalɩbʋ die dɩ suuli Elizabeti, ");
INSERT INTO kma_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","die ʋ faasɩ a keesi ŋmɩŋsikpeŋ a baarɩ dɩ, “Ŋmɩŋ alibarika bie fʋ ma a tɩaŋ hɔgʋba mana, ta bɩ bie bʋa dieke fʋ balla fʋ mɩɩrɩ wa ma! ");
INSERT INTO kma_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bɩa yine ta n Yɔmʋtieŋ nuŋ dɩ keŋ n jigiŋ giena? ");
INSERT INTO kma_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","N dene a wʋŋ fʋ waasɩkʋ, bʋanyaalɩ dieke dɩ benne n nyuuti ma wa dɩ dɔŋ aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Fʋnɩŋ vuodieke dɩ tuone a dii dɩ Ŋmɩŋ dɩ bala wudieke wo nan keŋ yi wusie, sʋgɩfɩalɩŋ yiwo fʋ sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Die wɩa Meri die dɩ baarɩ: “N bɩra Ŋmɩŋ n sʋŋ ma, ");
INSERT INTO kma_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ta yaa sʋgɩfɩalɩŋ Ŋmɩŋ vuodieke dɩ yine n Gbɩgbatɩtaantʋ ma, ");
INSERT INTO kma_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","dama ʋ chɩgɩ wa manɩŋ vuodieke dɩ yine ʋ hɔgʋlɩa yɔmʋ zɔɔlɩŋ. A nyɩŋ jinne yaa gamma, vuota mana nan baarɩ n yiwo sʋgɩfɩalɩŋ tieŋ, ");
INSERT INTO kma_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dama hagɩrɩtieŋ Nabidie Ŋmɩŋ tʋŋ wa tʋnkpɩɩma a yɩ mɩŋ, ʋ saaŋ yine kasɩ. ");
INSERT INTO kma_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ʋ bɩ yaa zɔɔlɩŋ aŋaŋ vuota diekemba dɩ chɩgɩnana wa saŋŋa mana. ");
INSERT INTO kma_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ʋ tɩɩntɩ wa ʋ nuuŋ a tʋŋ hagɩrɩŋ tʋʋma, ta chʋʋsɩ kalinbaantieliŋ wʋsaŋka. ");
INSERT INTO kma_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ta wuri naakpɩɩma ba naalɩŋ ma, ta kɔtɩ wabɩtɩ, ");
INSERT INTO kma_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ta yi vuodiekemba kɔŋ dɩ yalla nyindiiki vɩɩna ta vaa nyintitieliŋ dɩ ga aŋaŋ nuuwɩaga. ");
INSERT INTO kma_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta dɩ nʋa dieke die ʋ yɩna tɩ chɔɔŋkʋʋlɩba Izara vuosisi die dɩ yine ʋ tʋntʋntɩba, ta suŋŋi be. ");
INSERT INTO kma_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ta bɩ tɩɩnsɩ, a chɩgɩ Abarahami aŋaŋ ʋ haagɩsɩ zɔɔlɩŋ yaa gamma haahuu!” ");
INSERT INTO kma_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri die yiwo chɩɩtɩ ataa Elizabeti jigiŋ ta die viiri kuli. ");
INSERT INTO kma_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Die Elizabeti maarɩŋ daaŋ die dɩ tʋgɩ die ʋ mɩɩrɩ Bʋadembiŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Die ʋ jʋjʋrɩtamba aŋaŋ ʋ maarɩŋ die dɩ wʋnna wʋvɩɩŋ dieke Ŋmɩŋ dɩ yine a yɩ wa wa ba mana sʋgɩtɩ die dɩ fɩalɩ. ");
INSERT INTO kma_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Die bʋanyaalɩka die dɩ tʋgɩna daraa anɩɩ die ba baa ba gobi ʋ kɔlɩ, die ba yaala ba nagɩ wa ʋ chɔɔŋ saaŋ Zakaria a yɩ wa, ");
INSERT INTO kma_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ama die ʋ nuŋ wo die dɩ baarɩ dɩ, “Aayɩ! Ʋ saaŋ nan yi Jɔɔn.” ");
INSERT INTO kma_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ta ba balɩ a yɩ wa dɩ, “Nɩ tigiri me vuoŋ wori ʋ saaŋ dɩ yi Jɔɔn!” ");
INSERT INTO kma_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Womi die ba nagɩ ba nuusi a dagɩ dagɩtɩ a pɩasɩ ʋ chɔɔŋ wa saaŋ dieke ʋ yaala ba nagɩ yɩ bʋa wa. ");
INSERT INTO kma_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Die ʋ nagɩ ʋ nuusi a balɩ ba dɩ ba yɩ wa gbanɩŋ, die ba nagɩ a yɩ wa, ʋ maagɩ dɩ, “Bʋa wa saaŋ yine Jɔɔn!” Die dɩ yi vuoŋ mana mamachi. ");
INSERT INTO kma_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lele womi Zakaria die dɩ bɩagɩ a balɩ wɩa bɩbra ta die a piili a bɩra Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Die ŋmaamɩŋ die dɩ yigi ʋ jʋjʋrɩtamba mana, wɩaha gie die dɩ mʋʋlɩ a ga tɩgɩ diekemba dɩ benne Judia kunkogiŋ me mana. ");
INSERT INTO kma_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vuodieke mana die dɩ wʋnna wɩɩrɩ gie mana die dɩ yile a pɩasa taŋ dɩ, “Vuobɩa bʋa wa dɩ baa ʋ bɩrɩŋ?” Dama die ba wɔŋ ye dɩ Ŋmɩŋ hagɩrɩŋ bie ʋ ma. ");
INSERT INTO kma_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ŋmɩŋ Halɩkasɩka die dɩ suuli bʋa wa chɔɔŋ, Zakaria, die ʋ yiŋŋi balɩ Ŋmɩŋ wɩa dɩ, ");
INSERT INTO kma_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nɩ vaa tɩ bɩrɩ tɩ Yɔmʋtieŋ, vuodieke dɩ yine tɩnɩŋ Izara vuosi Ŋmɩnnɩ, dama ʋ keŋye mɩŋ a keŋ suŋŋi ʋ vuosi a gbatɩ ba a taaŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ʋ yɩ tɩ wa gbɩgbatɩ hagɩrɩtieŋ ta ʋ yi Ŋmɩŋ tʋntʋntʋ Davidi haagɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kʋrɩŋ ma wa Nabidie Ŋmɩŋ die vaa wa ʋ naazʋalɩŋ kasɩmba dɩ balɩ naa dɩ, ");
INSERT INTO kma_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ʋ nan gbatɩ tɩ a nyɩŋ tɩ dataasɩ nuusi me aŋaŋ vuodiekemba mana dɩ hana tɩ ");
INSERT INTO kma_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","die ʋ bɩ baarɩ ʋ nan chɩgɩ tɩ chɔɔŋkʋʋlɩŋ zɔɔlɩŋ, ta ʋ kaaŋ wɔŋ daaŋ ʋ nʋakasɩka, ");
INSERT INTO kma_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","nʋa dieke die ʋ yɩna tɩ chɔɔŋkʋʋŋ Abarahami wa. ");
INSERT INTO kma_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Die ʋ hʋʋ dɩ ʋ nan gbatɩ tɩ a nyɩŋ tɩ dataasɩ nuusi me amʋ tɩ nan bɩagɩ a jɩaŋ wa ta ŋmaamɩŋ wo tɩ, ");
INSERT INTO kma_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ta bɩ vaa tɩ yi vuokasɩ aŋaŋ vuovɩɩna ʋ nɩŋŋa tɩ mɩsɩ ma mana. ");
INSERT INTO kma_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta Fʋnɩŋ n bʋa, ba nan wa fʋ Nabidie Ŋmɩŋ naazʋa. Nan woliŋ tɩ Yɔmʋtieŋ nɩŋŋa a wʋnsɩ ʋ sieŋ a yɩ wa, ");
INSERT INTO kma_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ta balɩ ʋ vuosi dɩ ʋ nan gbatɩ ba a taaŋ saŋŋa dieke ʋ balla ʋ nagɩ ba taalɩ a chaa ba wa. ");
INSERT INTO kma_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wusie, tɩ Nabidie Ŋmɩŋ chɩga zɔɔlɩŋ ta ʋ baga dɩ bie tɩ ma ta tɩ gbatɩtaanɩŋ daraaŋ nan dɩ sɩɩ sɩba ŋmɩŋ pɔsɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ka nan chaaŋ nyɩŋ ŋmɩŋsikpeŋ a yɩ vuodiekemba mana dɩ benne lɩmɩŋ ma aŋaŋ vuodiekemba dɩ gbigine kuŋ; ka nan bɩ chaaŋ tɩ nagɩsɩ ma aŋ tɩ dɩa sʋgɩdʋagɩŋ sieku.” ");
INSERT INTO kma_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ka kʋaŋ chaaŋ bʋa wa die dɩ bɩrɩma aŋaŋ Ŋmɩŋ sɩbɩŋ, ta die keŋ ga haagɩŋ ma a ga bie mi dee a ga tʋgɩ saŋŋa dieke die ʋ vʋarɩna ʋ gbaŋ Izara vuosi me. ");
INSERT INTO kma_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Saŋka mi die naalɩba jakʋʋŋ Ɔgusitusi die dɩ yɩ nʋaŋ dɩ ba bɩɩsɩ vuodiekemba mana dɩ benne Romani tɩŋgbaŋ mana mana ma ma. ");
INSERT INTO kma_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Die bɩɩsɩkʋ die dɩ bunne a yi wo, die Kirinusi die yine naaŋ Siria tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Die wɩa vuoŋ mana die dɩ yiŋŋi a ga ʋ tɩŋ dɩ ba bɩɩsɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Naa chɩaŋ ma Josefu die nyɩŋ wa Nazeriti Galili tɩŋgbaŋ ma a ga Betilehemi, Judia ma ma jigidieke die ba mɩɩrɩna naaŋ Davidi. Josefu die ga wa mi dama die ʋ yiwo naaŋ Davidi haagɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Die ʋ ga wa mi aŋaŋ Meri vuodieke die ʋ balla ʋ faarɩ wa, dɩ ba bɩɩsɩ ba, saŋka mi Meri die yaa wa nyuuti, ");
INSERT INTO kma_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","die ba yene bie Betilehemi tɩŋ ma wa, ʋ maarɩŋ saŋŋa dɩ tʋgɩ. ");
INSERT INTO kma_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Die ʋ mɩɩrɩ ʋ hɔgʋlɩa bʋa dembiŋ, die ʋ nagɩ garɩŋ a vili wo a nagɩ wa dʋaŋ dɔŋɩsɩ nyindiike kpalɩ ma dama chaamba juonehe mana die suuliye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Die yiyagɩrɩŋ bataŋ die benne tɩka mi chaakʋ a daansa ba yiise hagɩrɩŋ ma yuku mi. ");
INSERT INTO kma_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta die tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ malaka wʋnyɩ die dɩ a keŋ a sʋʋŋ ba jigiŋ, ta tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ chuulikpeŋkpɩɩŋ die dɩ chaaŋ a giliŋ be. Die ŋmaamɩŋ die dɩ faasɩ a yigi be, ");
INSERT INTO kma_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ama ta malakaka die dɩ balɩ a yɩ ba dɩ, “Nɩ da vaa ŋmaamɩŋ yalla nɩ! N yallɩ wa wʋvɩɩnɩŋ a keŋ dɩ n yɩ nɩ, wudieke dɩ baaŋ nan yi vuoŋ mana sʋgɩfɩalɩŋ pam. ");
INSERT INTO kma_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yuku gie ba mɩɩrɩ wa nɩ Gbɩgbatɩtaantʋ vuodieke dɩ yine Ŋmɩŋ vuovʋarɩkɩŋ Masia wa, naaŋ Davidi tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Naa balla ka dagɩ nɩ dɩ ka seŋ yiwo wusie: nɩ nan ye ba nagɩna garɩŋ a vili bʋanyaalɩŋ a dʋaŋ dɔŋɩsɩ nyindiike kpalɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Womi die malakasi pam die dɩ nyɩŋ arɩzanna ma a keŋ a gʋtɩ wʋnɩŋ wa ma ma, ba chɩa yɩla a bɩra Ŋmɩŋ dɩ ");
INSERT INTO kma_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nɩ kɔtɩ Nabidie Ŋmɩŋ vuodieke dɩ benne arɩzanna ma saaŋ ŋmɩŋsikpeŋ, ta sʋgɩdʋagɩŋ bemme ʋ vuovʋarɩka ma tɩŋgbaŋka gie me.” ");
INSERT INTO kma_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Die malakasisi die dɩ vaa yiyagɩrɩba ta yiŋŋi a ga arɩzanna ma, yiyagɩrɩba die dɩ balɩ a yɩ tamba dɩ, “Nɩ vaa tɩ ga Betilehemi ma ma a ye wudieke dɩ yine mi, ta Nabidie Ŋmɩŋ dɩ balɩ a yɩ tɩ wa.” ");
INSERT INTO kma_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Die wɩa die ba yi lagɩ lagɩ a ga a ye Meri aŋaŋ Josefu; ta bʋanyaalɩka die dɩ dʋa dɔŋɩsɩ nyindiike kpalɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Die ba yene wo wo, die ba balɩ ba wudieke malakaka die dɩ balla yaa gamma bʋa wa wɩa. ");
INSERT INTO kma_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vuodieke mana die dɩ wʋnna yiyagɩrɩba die dɩ balla die wo, die dɩ faasɩ yi be mamachi, ");
INSERT INTO kma_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ama Meri die dɩ tɩɩnsɩ wɩaha gie mana ta faasɩ a yile ʋ sʋŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ka kʋaŋ chaaŋ die yiyagɩrɩba die dɩ yiŋŋi a ga ba yiise jigiŋ. Die ba ganana die ba chɩa yɩla a bɩra Ŋmɩŋ aŋaŋ wudieke ba wʋnna ta ye; die dɩ seŋ yiwo wudieke malakaka die dɩ bala a yɩ ba wa. ");
INSERT INTO kma_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ba mɩɩrɩna bʋa wa ʋ daraa anɩɩ daraaŋ, die ba gobi ʋ kɔlɩ ta yɩ wa saaŋ Yisa, saaŋ dieke malakaka die dɩ yɩna ta ba ye yigi ʋ nyuutiti. ");
INSERT INTO kma_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Die saŋka dɩ tʋgɩ dɩ Josefu aŋaŋ Meri yi Mosisi mɩraha die dɩ dagɩna die wo, dɩ ba yi kaaba a wʋnsɩ ba gbaŋ Ŋmɩŋ jigiŋ. Die wɩa die ba nagɩ bʋa wa a ga Jerusalemi dɩ ba nagɩ wa a yɩ tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","sɩba ba maagɩna die tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ mɩraha ma dɩ, “Hɔgʋlɩa ŋaŋ Bʋadembiŋ nɩŋ mana yiwo tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta ba kaabɩ sɩba tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ mɩraha dɩ dagɩna die dɩ, “Ba nagɩ ŋmarɩbɩsɩ ale yi kaabɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Saŋka mi daa wʋnyɩ die benne Jerusalemi ma ma ʋ saaŋ die dɩ yi Simiani. Die ʋ yiwo vuovɩɩnɩŋ a chɩga Ŋmɩŋ ta Ŋmɩŋ Halɩkasɩka dɩ bie ʋ ma, die ʋ chɩɩsa saŋŋa dieke Ŋmɩŋ dɩ balla ʋ gbatɩ Izara vuosi a taaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Die Ŋmɩŋ Halɩkasɩka die dɩ bala wa dɩ ʋ kaaŋ kpi sie ʋ keŋ ye Ŋmɩŋ vuovaʋrɩkɩrɩ Masia wa. ");
INSERT INTO kma_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Womi Ŋmɩŋ Halɩkasɩka die dɩ vaa Simiani die dɩ ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ. Die Yisa chɔɔŋ aŋaŋ ʋ nuŋ die dɩ yalla wa a keŋ juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋkʋ dɩ ba yi a yɩ wa wudieke Ŋmɩŋ mɩraha die dɩ dagɩna wa, ");
INSERT INTO kma_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiani die dɩ tuo bʋa wa ʋ nuusi me ta die a pagɩ Ŋmɩŋ dɩ, ");
INSERT INTO kma_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“N Yɔmʋtieŋ, ka daaŋ fʋ nʋarɩ vaa manɩŋ fʋ tʋntʋntʋ kpi ta wa kuli aŋaŋ sʋgɩdʋagɩŋ, sɩba die fʋ bala mɩŋ die wo; ");
INSERT INTO kma_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","dama n gbaŋ gbaŋ n nine ye Gbɩgbatɩtaantʋ wa, vuodieke fʋ tʋnna wa, ");
INSERT INTO kma_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","vuodieke fʋ vʋarɩna a zieŋ a yɩ buuriŋ mana wa. ");
INSERT INTO kma_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ʋ nan yi chaanɩŋ ta dagɩ vuodiekemba dɩ kana ka yi Juu vuosi fʋ sieŋ, ta nan bɩ yi vuosi yɩma fʋ vuosisi Izara tieliŋ jɩlɩma.” ");
INSERT INTO kma_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiani balɩkʋ yaa gamma bʋa wa wɩa, die dɩ yi bʋa wa chɔɔŋ aŋaŋ ʋ nuŋ mamachi. ");
INSERT INTO kma_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiani die dɩ jʋʋsɩ Ŋmɩŋ dɩ Ŋmɩŋ yi alibarika a yɩ ba ta balɩ yɩ bʋa wa nuŋ Meri dɩ, “Ŋmɩŋ vʋarɩna bʋa wa gie dɩ ʋ keŋ aŋ Izara vuosi pam nan yɔrɩ; ta ba pam dɩaŋ keŋ ye gbatɩtaanɩŋ. Wʋnɩŋ ʋ baa ʋ yiwo dagɩtɩ a nyɩŋ Ŋmɩŋ jigiŋ aŋ vuosi pam nan balɩ a chʋʋsɩ ka, ");
INSERT INTO kma_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","amʋ vuosi pam sʋŋanyile nan nyɩŋ yeŋ me ama wɩɩŋ nan yi ta chʋʋsɩ fʋ gbaŋ gbaŋ fʋ sʋŋ pam.” ");
INSERT INTO kma_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Die Ŋmɩŋ naazʋa jakʋʋŋ wʋnyɩ die benne mi ta yi hɔgʋ, ʋ saaŋ die yine Anna vuodieke dɩ yine Fanueli bʋa ta bɩ yi Aseri buuriŋ vuoŋ, die ʋ yiwo hɔgʋjakʋʋŋ ta die a yallɩ chʋrʋ bɩna ayʋpɔyɩ nyɩɩna, ");
INSERT INTO kma_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ta ʋ chʋrʋ wa die dɩ kpi ta va wa kpihɔgʋ ta ʋ beri bɩna baŋɩsɩ-nɩɩ aŋaŋ anɩɩsa saŋka mi: ama die saŋŋa mana ʋ ŋaaŋ bie wo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ a jɩama Ŋmɩŋ a bɔba nʋaŋ ta jʋʋsa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saŋka mi gbaŋ gbaŋ die ʋ keŋ haarɩ ba ta bɩrɩ Ŋmɩŋ, ta balɩ bʋa wa wɩa a yɩ vuodiekemba mana die dɩ chɩɩsɩnana saŋŋa dieke Ŋmɩŋ dɩ bala ʋ gbatɩ Jerusalemi vuosi a taaŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Die Josefu aŋaŋ Meri die dɩ yine wudiekemba Ŋmɩŋ mɩraha dɩ dagɩna wa a kpatɩ wa die ba yiŋŋi kuli ba tɩŋ Nazeriti, Galili me. ");
INSERT INTO kma_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta bʋa wa die dɩ bɩrɩŋ aŋaŋ hagɩrɩŋ ta yaa yɩaŋ pam, ta Ŋmɩŋ sʋŋ die dɩ fɩalɩ aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bɩŋ nɩŋ mana Yisa chɔɔŋ aŋaŋ ʋ nuŋ ŋaaŋ ga wa Jerusalemi a ga dii gasɩtɩaŋkʋ dʋʋgaka. ");
INSERT INTO kma_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yisa die dɩ tʋgɩna bɩna baŋ aŋaŋ ale die ba ga dɩ ba dii dʋʋgaka sɩba ba ŋaana a wɔŋ gara die wo. ");
INSERT INTO kma_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dʋʋgaka kʋaŋ chaaŋ die Yisa chɔɔŋ aŋaŋ ʋ nuŋ die dɩ yiŋŋine a kule die ʋ wɩarɩ Jerusalemi ma ama die ba ka sɩba; ");
INSERT INTO kma_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Die ba yile dɩ ʋ gʋtɩ wa daadamba ma, die wɩa die ba chʋŋ damʋʋmɩŋ ta wa piili a yaala wa ba vuosi aŋaŋ ba zʋalɩŋ jige; ");
INSERT INTO kma_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ama die ba ka ye wo, die wɩa die ba yiŋŋi ga Jerusalemi a yaala wa mi. ");
INSERT INTO kma_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ka daraa ataa daraaŋ die ba ye wo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ, ʋ kalɩ aŋaŋ Juu vuosi dɩdagɩrɩba a wʋmma wudieke ba balala ta pɩasa ba wʋpɩasɩka. ");
INSERT INTO kma_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Die dɩ yiwo vuodiekemba mana die dɩ wʋnnana wa mamachi aŋaŋ ʋ yɩaŋ aŋaŋ ʋ yiŋŋi balɩkʋ. ");
INSERT INTO kma_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Die ʋ chɔɔŋ aŋaŋ ʋ nuŋ die dɩ ye wo mi, die dɩ yi be mamachi pam; ʋ nuŋ die dɩ balɩ wa dɩ, “N bʋa, bɩa fʋ yi tɩ naa? Manɩŋ aŋaŋ fʋ chʋa sʋgɩtɩ paalɩ chʋʋsɩ mɩŋ tɩ dɩ dɩa a yaala fʋ!” ");
INSERT INTO kma_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Die ʋ yiŋŋi a balɩ dɩ, “Bɩa yine nɩ tɩŋ dɩ dɩa a yaala mɩŋ? Nɩ ka sɩba a baarɩ dɩ mʋ dɩ n bemme n Chʋa tigiŋ me?” ");
INSERT INTO kma_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama die ba ka sɩba ʋ balɩkʋ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Die Yisa die dɩ yiŋŋi a ga Nazeriti aŋaŋ ba a saaga yɩa ba. Ʋ nuŋ die dɩ tɩɩnsa wɩaha gie mana ʋ sʋŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisa die dɩ bɩrɩma a gʋta aŋaŋ yɩaŋ ta Ŋmɩŋ aŋaŋ vuota sʋgɩtɩ dɩ fɩala ʋ ma. ");
INSERT INTO kma_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saŋŋa dieke Naalɩba jakʋʋŋ Taberisi die dɩ dine naarɩ bɩna baŋ aŋaŋ anʋ wa, ta Pontiwosi Paliti gbaŋ die yiwo Judia nɩŋŋandɩɩsɩrʋ, ta Herodi gbaŋ die dɩ yi Galili naajakʋʋŋ, ta ʋ nɩmbʋa Filipi die yine Ituria aŋaŋ Tirakonitisi naajakʋʋŋ, ta Lasaniasi die dɩ yi Abilene naajakʋʋŋ, ");
INSERT INTO kma_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ta Anasi aŋaŋ Kayafasi die yine Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra. Saŋka gie Ŋmɩŋ die dɩ nagɩ ʋ wɩa a yɩ Jɔɔn, Zakaria bʋa wa; die ʋ bie wo haagɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Die wɩa Jɔɔn die dɩ dɩ Jɔɔdani mʋgɩkpɩɩrɩ lʋga mana a mʋʋla a yɩa vuosi dɩ ba chɩgɩ nyɩŋ ba tʋntʋmbɩatɩ ma aŋ ʋ sɩɩ ba Ŋmɩŋ nyaabʋ aŋ Ŋmɩŋ nagɩ ba tʋntʋmbɩatɩ a chaa ba. ");
INSERT INTO kma_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sɩba dɩ maagɩna die Ŋmɩŋ naazʋa Azaya gbaŋkʋ ma dɩ, “Vuoŋ benne haagɩŋ ma a keese a mʋʋla: ‘Nɩ wʋnsɩ tɩ Yɔmʋtieŋ keniŋ sieti ta vaa a tʋgɩsɩ a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gbaga mana nan suuli, ta tana aŋaŋ kunkoge mana jatɩ. Siegɔnte mana nan tʋgɩsɩ ta siebalɔtɩ mana nan mɩŋŋɩ vɩɩna. ");
INSERT INTO kma_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ta tɩŋgbaŋka gie vuosi mana nan ye Ŋmɩŋ dɩ baa nan gbatɩ ba a taaŋ dene.’ ” ");
INSERT INTO kma_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Daadaŋ pam die dɩ keŋ Jɔɔn jigiŋ dɩ ʋ sɩɩ ba Ŋmɩŋ nyaaŋ, die ʋ balɩ a yɩ ba dɩ, “Nɩnɩŋ nyinvuukehe gie! Mɩnɩa kpaana nɩ dɩ nɩ chɩgɩ nyɩŋ Ŋmɩŋ sɩnyɩɩrɩ dieke dɩ bala ka keŋ nɩ ma wa? ");
INSERT INTO kma_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nɩ yime wudiekemba dɩ baaŋ dagɩ dɩ nɩ seŋ chɩgɩ nyɩŋ nɩ tʋntʋmbɩatɩ ma. Ta nɩ da yilime nɩ sʋgɩtɩ ma dɩ Abarahami yiwo tɩ chɔɔŋkʋʋŋ. N bala nɩ, Ŋmɩŋ nan bɩagɩ a vaa tanaha gie bɩrɩŋ Abarahami haagɩsɩ. ");
INSERT INTO kma_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lɩaka wɔŋ yi siri a gbarɩ dɩ ka chɩa tɩɩsɩsɩ; tɩɩ dieke dɩ kana ka nyɩŋ nyɩŋnyɩŋka vɩɩna ba nan chɩa ka a taaŋ a nagɩ yi boliŋ me.” ");
INSERT INTO kma_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Die daadamba die dɩ pɩasɩ wa dɩ, “Bɩa tɩ wa mʋ tɩ yi?” ");
INSERT INTO kma_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jɔɔn die dɩ yiŋŋi a balɩ ba, “Vuodieke mana dɩ yalla nyinyeeke ale mʋ dɩ ʋ nagɩ kaanɩ a yɩ vuodieke dɩ wone, ta vuodieke dɩaŋ mana dɩ yalla nyindiike mʋ ʋ yi die gbaŋ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mi lampotuosiriŋ bataŋ dɩ keŋ dɩ ʋ sɩɩ ba Ŋmɩŋ nyaabʋ ta die a pɩasɩ wa dɩ, “Dɩdagɩrʋ, lalɩa tɩ ba tɩ yi?” ");
INSERT INTO kma_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ʋ yiŋŋi a balɩ ba dɩ, “Nɩ da keŋ tuo a tɩaŋ nɩ mʋna nɩ tuo die.” ");
INSERT INTO kma_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta sojasi bataŋ dɩaŋ die dɩ pɩasɩ wa dɩ, “Ta tɩnɩŋ nɩŋ, bɩa tɩ mʋ tɩ yi?” Die ʋ yiŋŋi a balɩ ba dɩ, “Nɩ da mugisi vuosi a tuo ba ligire yaa a chibi ŋmɩnchɩbɩsɩ a yɩ vuosi, ama nɩ vaa nɩ nine suuli nɩ tune.” ");
INSERT INTO kma_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta vuosi die dɩ piili a yile ba sʋgɩtɩ ma ta yaa tama Jɔɔn ma, dɩ ʋ nan keŋ a yi Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa. ");
INSERT INTO kma_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Die wɩa Jɔɔn die balɩ a yɩ ba mana dɩ, “Manɩŋ n sɩwa nɩ aŋaŋ nyaaŋ ama vuodieke dɩ tɩanna mɩŋ kieŋ, n ka tʋgɩ vuodieke dɩ baaŋ forisi ʋ nɩɩra guune gbaŋ. Wʋnɩŋ ʋ nan nagɩ Ŋmɩŋ Halɩkasɩka aŋaŋ boliŋ a sɩɩ nɩ sʋgɩtɩ. ");
INSERT INTO kma_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ʋ yallɩ wa ʋ kpalɩchaarɩkɩŋ ʋ nuuŋ me dɩ ʋ chaarɩ zaaha ta nagɩ zaabiehe a yi ʋ bumbuŋ me ta nagɩ zaakpeetiti a yi boli dieke dɩ kana ka kpise me.” ");
INSERT INTO kma_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jɔɔn die dɩ mʋʋlɩna wʋvɩɩnaha gie a yɩa vuosisi, die ʋ balɩ wɩa yiri yiri a kpaaŋ ba dɩ ba tarɩgɩ ba beriŋ. ");
INSERT INTO kma_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama die ʋ galɩŋ naaŋ Herodi nɩŋ dama die ʋ gbatɩ wa ʋ gbaŋ gbaŋ ʋ nɩmbʋa hɔgʋ Herodiasi a faarɩ ta bɩ yi wʋbɩatɩ pam. ");
INSERT INTO kma_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","A kʋaŋ chaaŋ die ʋ bɩ yi wʋbɩaŋ a gʋtɩ a ma, ta ligi Jɔɔn dansarɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Saŋŋa dieke Jɔɔn die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ, die Yisa dɩ keŋ ʋ jigiŋ dɩ ʋ sɩɩ ʋ gbaŋ. Mi Yisa die dɩ jʋʋsa Ŋmɩŋ, ŋmɩŋsikpeŋ die dɩ yuori, ");
INSERT INTO kma_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ta Ŋmɩŋ Halɩkasɩka die dɩ keŋ sʋʋŋ ʋ sikpeŋ aŋaŋ nyɩŋgbanɩŋ sɩba ŋmarɩŋ. Ta lɔlɩŋ dɩ nyɩŋ ŋmɩŋsikpeŋ a baarɩ dɩ, “Fʋnɩŋ fʋ yine n Bʋachoti; fʋnɩŋ n nine dɩ suuli.” ");
INSERT INTO kma_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisa die yiwo bɩna baŋɩsɩ-taa ta die a piili ʋ tʋʋma. Vuosi die yile sɩba ʋ yiwo Josefu bʋa; ta Josefu chɔɔŋ die yine Heli, ");
INSERT INTO kma_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ta Heli chɔɔŋ die yine Matati, ta Matati chɔɔŋ die yine Liiva, ta Liiva chɔɔŋ die yine Meliki, ta Meliki chɔɔŋ die yine Janayi, ta Janayi chɔɔŋ die yine Josefu, ");
INSERT INTO kma_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ta Josefu chɔɔŋ die yine Matatiasi, ta Matatiasi chɔɔŋ die yine Amosi, ta Amosi chɔɔŋ die yine Nahumi, ta Nahumi chɔɔŋ die yine Esili, ta Esili chɔɔŋ die yine Nagayi, ");
INSERT INTO kma_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ta Nagayi chɔɔŋ die yine Maati, ta Maati chɔɔŋ die yine Matatiasi, ta Matatiasi chɔɔŋ die yine Semeni, ta Semeni chɔɔŋ die yine Joseki, ta Joseki chɔɔŋ die yine Joda, ");
INSERT INTO kma_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ta Joda chɔɔŋ die yine Johanani, ta Johanani chɔɔŋ die yine Resa, ta Resa chɔɔŋ die yine Zerubabeli, ta Zerubabeli chɔɔŋ die yine Sialitili, ta Sialitili chɔɔŋ die yine Neri, ");
INSERT INTO kma_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ta Neri chɔɔŋ die yine Meliki, ta Meliki chɔɔŋ die yine Addi, Addi chɔɔŋ die yine Kosami, ta Kosami chɔɔŋ die yine Elimadami, ta Elimadami chɔɔŋ die yine Eri, ");
INSERT INTO kma_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ta Eri chɔɔŋ die yine Josua, ta Josua chɔɔŋ die yine Eliaza, ta Eliaza chɔɔŋ die yine Jorimi, ta Jorimi chɔɔŋ die yine Matati, ta Matati chɔɔŋ die yine Liiva, ");
INSERT INTO kma_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ta Liiva chɔɔŋ die yine Simiani, ta Simiani chɔɔŋ die yine Juda, ta Juda chɔɔŋ die yine Josefu, ta Josefu chɔɔŋ die yine Jonami, ta Jonami chɔɔŋ die yine Elayakimi, ");
INSERT INTO kma_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ta Elayakimi chɔɔŋ die yine Melia, ta Melia chɔɔŋ die yine Mena, ta Mena chɔɔŋ die yine Matata, ta Matata chɔɔŋ die yine Nafani, ta Nafani chɔɔŋ die yine Davidi, ");
INSERT INTO kma_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ta Davidi chɔɔŋ die yine Jese, ta Jese chɔɔŋ die yine Obedi, ta Obedi chɔɔŋ die yine Boazi, ta Boazi chɔɔŋ die yine Salimoni, ta Salimoni chɔɔŋ die yine Nasoni, ");
INSERT INTO kma_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ta Nasoni chɔɔŋ die yine Aminadabi, ta Aminadabi chɔɔŋ die yine Adimini, ta Adimini chɔɔŋ die yine Arini, ta Arini chɔɔŋ die yine Hezironi, ta Hezironi chɔɔŋ die yine Perezi, ta Perezi chɔɔŋ die yine Juda, ");
INSERT INTO kma_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ta Juda chɔɔŋ die yine Jakobu, ta Jakobu chɔɔŋ die yine Aziki, ta Aziki chɔɔŋ die yine Abarahami, ta Abarahami chɔɔŋ die yine Tera, ta Tera chɔɔŋ die yine Nahori, ");
INSERT INTO kma_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ta Nahori chɔɔŋ die yine Serugi, ta Serugi chɔɔŋ die yine Rewo, ta Rewo chɔɔŋ die yine Pelegi, ta Pelegi chɔɔŋ die yine Eberi, ta Eberi chɔɔŋ die yine Sela, ");
INSERT INTO kma_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ta Sela chɔɔŋ die yine Kayinani, ta Kayinani chɔɔŋ die yine Afakisadi, ta Afakisadi chɔɔŋ die yine Siami, ta Siami chɔɔŋ die yine Nowa, ta Nowa chɔɔŋ die yine Lameki, ");
INSERT INTO kma_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ta Lameki chɔɔŋ die yine Metusila, ta Metusila chɔɔŋ die yine Enɔki, ta Enɔki chɔɔŋ die yine Jaredi, ta Jaredi chɔɔŋ die yine Mahalaleeli, ta Mahalaleeli chɔɔŋ die yine Keenani, ");
INSERT INTO kma_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ta Keenani chɔɔŋ die yine Enosi, ta Enosi chɔɔŋ die yine Sefi, ta Sefi chɔɔŋ die yine Adami, ta Adami chɔɔŋ die yine Nabidie Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Womi Yisa die dɩ nyɩŋ Jɔɔdani mʋgɩkpɩɩrɩ chaaŋ, ta suuli aŋaŋ Ŋmɩŋ Halɩkasɩka, Halɩkasɩka die dɩ vaa ʋ ga haagɩŋ ma, ");
INSERT INTO kma_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mi die Sitaani die dɩ magɩsɩ wa a ga tʋgɩ daraa baŋɩsɩ-nɩɩsa. Saŋka mi mana die ʋ ka dii jaaŋ mana, die wɩa ka kʋaŋ chaaŋ kɔŋ die dɩ yallɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sitaani die dɩ balɩ wa dɩ, “Dɩɩ yi fʋ seŋ yi Ŋmɩŋ bʋa fʋ vaa tanɩ gie bɩrɩŋ nyindiike.” ");
INSERT INTO kma_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yisa dɩ yiŋŋi a balɩ wa dɩ, “Dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ ‘Da nyindiike nyɩɩna ma wɩa vuota dɩ beri.’ ” ");
INSERT INTO kma_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mi Sitaani dɩ bɩ nagɩ wa a jʋalɩ ŋmɩŋsikpeŋ a dagɩ wa dʋnɩa ka gie mana lagɩ lagɩ, ");
INSERT INTO kma_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ta balɩ wa dɩ, “N nan nagɩ yikoke gie aŋaŋ nyinti gie mana a yɩ fʋ, die ba nagɩ yɩ mɩŋ mɩŋ ta n nan bɩagɩ nagɩha a yɩ vuodieke mana n yaalala. ");
INSERT INTO kma_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","N nan nagɩ yikoke gie aŋaŋ nyinti gie mana a yɩ fʋ dɩɩ yi fʋ sʋʋŋ gbirigi a jɩaŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yisa dɩ yiŋŋi a balɩ wa dɩ, “Dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ, ‘Vuota jɩama tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ nyɩɩna ma ta bɩ dɩa ʋ nyɩɩna ma!’ ” ");
INSERT INTO kma_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Die Sitaani dɩ bɩ nagɩ wa a ga Jerusalemi a nagɩ wa a jʋalɩ zieŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sikpeŋ me, ta balɩ wa dɩ, “Fʋ seŋ yi Ŋmɩŋ Bʋa yʋgɩ a chigisi tɩŋgbaŋ, ");
INSERT INTO kma_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","dama dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ, ‘Ŋmɩŋ nan vaa ʋ malakasisi mɩŋŋɩ daansɩma fʋ.’ ");
INSERT INTO kma_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dɩ bɩ maagɩ dɩ, ‘Ba nan tuoli a tuo fʋ ba nuusi me amʋ fʋ naabɩŋ da keŋ a gbɩŋ taŋ aŋ fʋ ye daŋŋa.’ ” ");
INSERT INTO kma_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ta Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ, ‘Vuoŋ da keŋ magɩsɩ tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Die Sitaani die dɩ magɩsɩna wa a jɩɩ wa die ʋ va wa ta ga, sie saŋŋa dieke ʋ baaŋ nan ye sieŋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ka kʋaŋ chaaŋ Yisa die dɩ yiŋŋi ga Galili, ta die a suuli aŋaŋ Ŋmɩŋ Halɩkasɩka hagɩrɩŋ. Die ba mʋʋlɩ ʋ wɩa tɩŋgbaŋka lʋga mana. ");
INSERT INTO kma_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Die ʋ dagɩ ba Ŋmɩŋ wɩa ba Ŋmɩŋ jɩamɩŋ juone me; ta vuoŋ mana dɩ bɩrɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","A kʋaŋ chaaŋ Yisa die dɩ ga Nazeriti, jigidieke die ba wubine wo ʋ ga bɩrɩŋ vuota. Ta die davʋʋsɩkɩrɩ daarɩ die ʋ ga juu Ŋmɩŋ jɩamɩŋ juoŋ me sɩba ʋ wone yie die wo. Die ʋ hagɩ a zie dɩ ʋ karɩŋ Ŋmɩŋ gbaŋkʋ, ");
INSERT INTO kma_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ta die ba nagɩ Ŋmɩŋ gbaŋ dieke Ŋmɩŋ naazʋa Azaya die dɩ maagɩna a keŋ yɩ wa. Die ʋ yuori ke a ye jigidieke ba maagɩna dɩ, ");
INSERT INTO kma_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nabidie Ŋmɩŋ Haalɩŋ bie n ma, dama ʋ vʋarɩ mɩŋ mɩŋ dɩ n mʋʋlɩ wʋvɩɩnaha a yɩ zɔɔlɩntieliŋ. Ʋ tʋŋ mɩŋ mɩŋ dɩ ga balɩ yɔŋɩsɩ dɩ n nan vʋarɩ ba a nyɩŋ yɔrɩ, ta bɩ balɩ yɩɩsɩ dɩ ba nan ye, ta bɩ vʋarɩ vuodiekemba dɩ benne mugisiŋ me a taaŋ yɔrɩ, ");
INSERT INTO kma_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ta bɩ mʋʋlɩ dɩ saŋŋa tʋgɩya mɩŋ dɩ Nabidie Ŋmɩŋ gbatɩ ʋ vuosi a taaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yisa die dɩ karɩnna a kpatɩ wa die ʋ pili gbaŋkʋ a yiŋŋi a nagɩ ka a yɩ Ŋmɩŋ jɩamɩŋ tʋntʋntʋ, ta sʋʋŋ kalɩ. Ta vuodiekemba mana die dɩ benne Ŋmɩŋ jɩamɩŋ juoku me wo die dɩ jɩɩma wa. ");
INSERT INTO kma_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Womi Yisa die dɩ piili a bala ba dɩ, “Wudieke n karɩnna Ŋmɩŋ gbaŋkʋ sʋkʋ, keŋ yi wusie jinne, sɩba nɩ wʋnnana die wo.” ");
INSERT INTO kma_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Die ba mana sʋgɩtɩ die dɩ fɩalɩ aŋaŋ wa ta ba bɩra wa, die dɩ yi be mamachi aŋaŋ wudiekemba ʋ bala wa. Die ba pɩasa taŋ dɩ, “Daa ʋ yine Josefu bʋa wa?” ");
INSERT INTO kma_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Womi Yisa die dɩ balɩ a yɩ ba dɩ, “N ka chɩɩlɩya dɩ nɩ nan balɩ mɩŋ nandagɩrɩ gie dɩ, ‘Gbɩgbaantʋ gbaaŋ fʋ gbaŋ.’ Nɩ nan bɩ balɩ a yɩ mɩŋ dɩ n yi mamachi tʋnkpɩɩma n gbaŋ gbaŋ n tɩŋ ma sɩba nɩ wʋnnana dɩ n yiye Kapenɔmi ma wa. ");
INSERT INTO kma_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wusie maŋ bala nɩ dɩ, vuosi ka tuose Ŋmɩŋ naazʋa ʋ gbaŋ gbaŋ ʋ tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wusie, kpihɔgʋba pam die benne Izara tɩŋgbaŋ ma, saŋŋa dieke Elaja die dɩ benne wo, saŋka mi die nɩɩŋ dɩ ka nɩɩya bɩna ataa aŋaŋ chɩɩtɩ ayʋaba, ta kɔŋkpɩɩŋ dɩ keŋ nan tɩŋgbaŋka mana ma, ");
INSERT INTO kma_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ama Ŋmɩŋ die ka tʋŋ Elaja ba wʋnyɩ mana jigiŋ; die ʋ tʋŋ wa wa kpihɔgʋ dieke dɩ benne Zarefati Sadoni tɩŋ ma wa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Saŋŋa dieke Ŋmɩŋ naazʋa Elasa die dɩ benne wo gama pam die benne Izara tɩŋ ma, ama ba wʋnyɩ mana die ka ye gbaamɩŋ sie Naamani vuodieke dɩ yine Siria dembiŋ, wʋnɩŋ ʋ nyɩɩna ma die yene gbaamɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Die vuodiekemba mana die dɩ benne Ŋmɩŋ jɩamɩŋ juoku me wo ta wʋŋ Yisa balɩkʋ gie, die dɩ jɩɩ sɩnyɩɩrɩŋ pam aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Die ba hagɩ a yagɩ wa a nyɩŋ tɩka a yaa wa ga kunkogi dieke ba mɩna ba tɩka a zie wo sikpeŋ a yaala ba kpaŋŋɩ wa a taaŋ gɔɔlɩkʋ sʋŋ, ");
INSERT INTO kma_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ama die ʋ nyɩɩgɩ ba sʋnsʋŋ a chʋŋ ga. ");
INSERT INTO kma_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ka kʋaŋ chaaŋ ta Yisa die dɩ ga Kapenɔmi dieke dɩ benne Galili tɩŋgbaŋ ma wa, davʋʋsɩkɩrɩ daarɩ die ʋ juu Ŋmɩŋ jɩamɩŋ juoku me a piili daga vuosi Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ʋ dagɩkʋ die dɩ yi be mamachi pam dama die ʋ bala aŋaŋ yiko. ");
INSERT INTO kma_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta daa wʋnyɩ jɩmbɩaŋ die dɩ yalla ta ʋ bie Ŋmɩŋ jɩamɩŋ juoku me die dɩ faasɩ keesi ŋmɩŋsikpeŋ dɩ, ");
INSERT INTO kma_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Fʋnɩŋ Yisa, vuodieke dɩ nyɩnna Nazeriti, bɩa fʋ yaala tɩ jigiŋ? Keŋ dɩ fʋ chʋʋsɩ tɩ mɩŋ? N sɩba vuodieke dɩ yine fʋ, yiwo Ŋmɩŋ tʋntʋnkasɩ vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ta Yisa die dɩ natɩ jɩmbɩakʋ dɩ, “Tarɩ watɩ ta keŋ nyɩŋ daa wa ma.” Die jɩmbɩakʋ dɩ nagɩ daa wa taaŋ tɩŋgbaŋ ba mana nɩŋŋa ta keŋ nyɩŋ ʋ ma, aŋaŋ ka nagɩna wa a taaŋ tɩŋgbaŋ mana die ka ka yɩ wa daŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Die dɩ yi vuotamba mana mamachi die ba pɩasa tamba dɩ, “Bɩa balɩŋ wʋnna? Ta ʋ yaa yiko aŋaŋ hagɩrɩŋ a yɩa jɩmbɩatɩ nʋa, ta a nyɩna vuosi ma.” ");
INSERT INTO kma_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Die wɩa die ba mʋʋlɩ Yisa saaŋ tɩka ma mana. ");
INSERT INTO kma_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Saŋka mi Yisa die dɩ nyɩŋ Ŋmɩŋ jɩamɩŋ juoku me a ga Simoni tigiŋ. Die Simoni hanɩɩŋ hɔgʋ die dɩ dʋa a yʋagɩ, ʋ nyɩŋgbanɩŋ die dɩ faasɩ tʋʋlɩ, die ba jʋʋsɩ Yisa dɩ ʋ suŋŋi wo. ");
INSERT INTO kma_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ta Yisa die dɩ ga a ga zie jigidieke ʋ dʋana wa, ta yɩ yʋagɩbʋ nʋaŋ, die yʋagɩbʋ dɩ va wa; ta hɔgʋ wa dɩ hagɩ bʋnyɩ a yi ba chaantɩ. ");
INSERT INTO kma_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Die ŋmɩŋ die dɩ june a kpatɩ, vuodiekemba mana die dɩ yalla yʋagɩtieliŋ ba tige me ba yʋagɩ yʋagɩtɩ yiri yiri die dɩ chii be a keŋ Yisa jigiŋ. Die ʋ nagɩ ʋ nuusi a diisi diisi ba mana ma die ba mana dɩ ye gbaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ta ʋ bɩ yi ta jɩmbɩatɩ dɩ nyɩŋ vuosi pam ma, die a nyɩnana wa die a taaŋ keesiŋ ŋmɩŋsikpeŋ dɩ, “Fʋnɩŋ fʋ yine Ŋmɩŋ Bʋa wa.” Ama die ʋ ka bɩ saagɩ dɩ a balɩ wɩɩŋ, dama a sɩba baarɩ ʋ yiwo Ŋmɩŋ Vuovʋarɩkɩŋ Masia wa. ");
INSERT INTO kma_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Die tuŋ die dɩ vʋnna die Yisa die dɩ nyɩŋ tɩka ma a ga haagɩŋ ma; die vuosisi die dɩdɩ dɩa a yaala wa, die ba kenne a ye wo wo, die ba ka bɩ yaala ʋ ga ta va ba. ");
INSERT INTO kma_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama die ʋ balɩ ba dɩ, “Sie n ga tɩgɩhanɩŋ ba a ga balɩ Ŋmɩŋ wʋvɩɩna yaa gamma ʋ naarɩ keniŋ wɩa mi gbaŋ, dama die wɩa Ŋmɩŋ dɩ tʋŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naa chɩaŋ ma die ʋ dɩdɩ dɩa Judia tɩgɩsɩ ta juo Ŋmɩŋ jɩamɩŋ juone me a daga vuosi wɩaha. ");
INSERT INTO kma_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Daaŋ kaanɩ Yisa die dɩ ga a zie Genezariti gbagɩkpɩɩkʋ kʋanʋaŋ a bala Ŋmɩŋ wɩa ta daadaŋ pam dɩ taaŋ giliŋ wo a wʋmma wɩaha. ");
INSERT INTO kma_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Die ʋ ye haarɩsɩ ale die dɩ zene gbagɩrɩ kʋanʋaŋ, zaasɩyigiribe die vanaha ta die a ga sugire ba nɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yisa die dɩ juu haarɩsɩ kaanɩ, die dɩ yine Simoni jaaŋ ta balɩ wa dɩ ʋ kpaŋŋɩ ka a ga nyaabʋ sʋŋ bɩta. Yisa die dɩ wa a kalɩ haarɩkʋ sʋŋ a daga kpɩkpaakʋ Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Die ʋ dagɩna kpatɩ wa, die ʋ balɩ Simoni dɩ, “Kpaŋŋɩ haarɩkʋ ka ga jigidieke dɩ goline ta nɩ vigi nɩ nɩɩtɩtɩ nyaabʋ sʋŋ a yigi zaasɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni die dɩ yiŋŋi balɩ wa dɩ, “Jakʋʋŋ, tɩ tʋŋ wa yuku mana ama tɩ ka yigi jaaŋ. Tɔ, fʋ bala naa wa wɩa, n nan vigi nɩɩtɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Die Simoni aŋaŋ ʋ chanchaalɩba die dɩ vigi ba nɩɩtɩ a yigi zaasɩŋ pam, ta ba nɩɩtɩ die dɩ yaala a kpaa kpaa. ");
INSERT INTO kma_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Naa chɩaŋ ma, die ba wa ba chanchaalɩba die dɩ benne haarɩ kanɩŋ wa ma wa dɩ ba keŋ a suŋŋi be. Die ba keŋ vʋarɩ zaasɩbʋ a suuli ba haarɩsɩ ale wo mana, ta haarɩsɩsɩ dɩ wa dunsi a yaala a sʋʋŋ nyaabʋ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Die Simoni Piita die dɩ yene wudieke die dɩ yine wo ʋ gbigiri Yisa nɩŋŋa a baarɩ dɩ, “N Yɔmʋtieŋ, n yiwo tʋntʋmbɩatɩtieŋ. N ka vɩɩna dɩ n gbigi fʋ. Va mɩŋ ta ga”, ");
INSERT INTO kma_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","dama die ba yigine zaasɩŋ pam wa die yine Simoni Piita aŋaŋ ʋ zʋalɩba mana mamachi ");
INSERT INTO kma_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","aŋaŋ ʋ chanchaalɩba, Jemisi aŋaŋ Jɔɔn vuodiekemba dɩ yine Zebedi ballɩ. Ta Yisa dɩ balɩ a yɩ Simoni dɩ, “Da vaa ŋmaamɩŋ yalla fʋ, a nyɩŋ jinne yaa gamma nan ga a sʋgɩma vuosi a kiere n jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Die wɩa die ba kpaŋŋɩ ba haarɩsɩsɩ a jʋalɩ gaaŋ a va jaaŋ mana ta dɩ Yisa kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saŋŋa kaanɩ Yisa die bie tɩŋ kaanɩ ma ta daa wʋnyɩ dɩ bie mɩŋ a yallɩ gamɩŋ. Die ʋ yene Yisa wa die ʋ nagɩ ʋ gbaŋ a taaŋ tɩŋgbaŋ ʋ nɩŋŋa a jʋʋsɩ wa dɩ, “N Yɔmʋtieŋ, dɩɩ yi fʋ dʋŋŋʋ fʋ gbaaŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yisa die dɩ tɩɩntɩ ʋ nuuŋ a gbɩ daa wa ta balɩ dɩ, “N saagɩya, fʋ gamɩŋ kpatɩya mɩŋ.” Lele womi daa wa ganɩ dɩ kpatɩ bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Die wɩa Yisa die dɩ kpaaŋ wa dɩ, “Da keŋ balɩ vuoŋ wɩɩrɩ gie, ama ga a ga nagɩ fʋ gbaŋ a dagɩ Ŋmɩŋ kɩkaabɩtʋ wa ta kaabɩ kaabɩ dieke Mosisi die dɩ dagɩna wa yaa gamma gamɩŋ gbaanɩŋ wɩa, aŋ vuoŋ mana sɩmma sɩba dɩ lele fʋ gaŋkʋ kpatɩya mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ama die ba faasɩ mʋʋlɩ Yisa saaŋ jigiŋ mana, ta kpɩkpaaŋ die dɩ keŋ ʋ jigiŋ dɩ ba wʋŋ wudieke ʋ balala, ta ye gbaamɩŋ a nyɩŋ ba yʋagɩtɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama die ʋ ŋaaŋ ga wa haagɩŋ ma a ga jʋʋsa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Saŋŋa kaanɩ die Yisa dɩ daga vuosi Ŋmɩŋ wɩa, ta Farasisi aŋaŋ mɩraha dɩdagɩrɩba die dɩ kalɩ mi, die ba nyɩŋ wa Galili tɩgɩsɩ mana aŋaŋ Judia tɩgɩsɩ mana aŋaŋ Jerusalemi a keŋ Yisa jigiŋ. Die Nabidie Ŋmɩŋ hagɩrɩŋ die dɩ bie ʋ ma dɩ ʋ gbaaŋ yʋagɩtieliŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Die dembisi bataŋ die dɩ chii daa wʋnyɩ nyɩŋgbanɩŋ die dɩ kpine kalɩŋŋa ma a mɩa dɩ ba nagɩ wa juu tigiri me a nagɩ wa dʋaŋ Yisa nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ama die vuosi die dɩ dala wa die ba ka bɩagɩ nagɩ wa juu, die wɩa die ba chii wo a jʋalɩ mampili sikpeŋ a chɩa a yuori vɔrɩŋ a nagɩ wa aŋaŋ kalɩŋka a sʋʋŋ dʋaŋ vuosi sʋnsʋŋ Yisa nɩŋŋa ");
INSERT INTO kma_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yisa die dɩ yene ba yine wo yada dene wo, ʋ balɩ yɩ daa wa dɩ, “N zʋa n nagɩ fʋ taalɩ a chaa fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ta mɩraha dɩdagɩrɩba aŋaŋ Farasisi vuosisi die dɩ piili a yile ba sʋgɩtɩ ma dɩ, “Mɩnɩa yine daa wa gie a bala sɩba ʋ yiwo Ŋmɩŋ? Vuobɩa baaŋ nan nagɩ vuoŋ taalɩ a chaa wa, ntaala Ŋmɩŋ nyɩɩna?” ");
INSERT INTO kma_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Die Yisa dɩ mɩŋŋɩ ba sʋŋanyile ta pɩasɩ ba dɩ, “Bɩa nɩ yile wɩaha gie nɩ sʋgɩtɩ ma? ");
INSERT INTO kma_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Genhe jabɩa yine mɔlɩ, fʋ baaŋ balɩ dɩ, ‘N nagɩ fʋ taalɩ a chaa’ yaa ‘Hagɩ a chʋŋ’? ");
INSERT INTO kma_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","N nan wa a dagɩ aŋ nɩ sɩmma a baarɩ manɩŋ vuota Bʋa yaa yiko dʋnɩa mama a nan bɩagɩ a nagɩ vuosi tʋmbɩatɩ a chaa ba.” Die wɩa die ʋ balɩ a yɩ nyɩŋgbaŋkpiikiri tieŋ wo “N bala fʋ, hagɩ a nagɩ fʋ kalɩŋŋa a ga tigiŋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lele womi daa wa die dɩ hagɩ ba mana nɩŋŋa a nagɩ ʋ kalɩŋŋa a kuli ta bɩra Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Die dɩ yi vuoŋ mana mamachi pam ta ŋmaamɩŋ die dɩ yigi be, die ba pagɩ Ŋmɩŋ a bala dɩ, “Tɩ ye mamachi wɩa jinne.” ");
INSERT INTO kma_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A kʋaŋ chaaŋ ta Yisa die dɩ nyɩŋ a ye lampotuosiru ba wasɩnana Liiva ta ʋ kalɩ jigidieke ba tuosinene lampoke juoŋ me. Yisa dɩ balɩ a yɩ wa dɩ, “Dɩa mɩŋ!” ");
INSERT INTO kma_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Die Liiva die dɩ hagɩ a vaa jaaŋ mana ta dɩ ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liiva die dɩ paalɩ a yi chaantɩ ʋ tigiŋ me a yɩ Yisa; ta die lampotuosiriŋ pam aŋaŋ vuosi bataŋ die dɩ lagɩsɩ die aŋaŋ ba. ");
INSERT INTO kma_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Die Farasisi bataŋ aŋaŋ ba mɩraha dɩdagɩrɩ bataŋ die dɩ yine Farasisi die dɩ keŋ pɩasa Yisa kʋaŋandɩɩsɩrɩba dɩ, “Bɩa nɩ die ta nyuo aŋaŋ lampotuosiriŋ aŋaŋ tʋntʋmbɩatɩ tieliŋ?” ");
INSERT INTO kma_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yisa die dɩ yiŋŋi a balɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Manɩŋ n ka keŋ dɩ n balɩ vuodiekemba dɩ yine vuovɩɩna dɩ ba vaa ba tʋmbɩatɩ ama n keŋ dɩ n balɩ tʋntʋmbɩatɩ tieliŋ dɩ ba vaa ba tʋmbɩatɩ.” ");
INSERT INTO kma_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Die vuosi bataŋ die dɩ balɩ Yisa dɩ, “Jɔɔn kʋaŋandɩɩsɩrɩba ŋaaŋ bɔba nʋaŋ ta jʋʋsa Ŋmɩŋ saŋŋa mana, ta Farasisi mba kʋaŋandɩɩsɩrɩba dɩ yie die gbaŋ gbaŋ ama fʋ kʋaŋandɩɩsɩrɩba ŋaaŋ die mɩŋ ta nyuo saŋŋa mana.” ");
INSERT INTO kma_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Nɩ tɩŋ yaala chaaŋ diekemba dɩ gana hɔgʋ faarɩŋ ma bɔba nʋaŋ, banɩŋ aŋaŋ hɔgʋ wa tieŋ dɩ lagɩsɩna a beri wo? Die kaaŋ bɩagɩ a yi. ");
INSERT INTO kma_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama saŋŋa nan keŋ ba nan nagɩ hɔgʋ wa tieŋ a nyɩŋ ba jigiŋ, saŋka mi ba nan wa bɔbɩ nʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisa die dɩ bɩ taaŋ ba nandagɩrɩ gie dɩ, “Vuoŋ kaaŋ saagɩ a chɩɩrɩ garɩhaalɩŋ ta nagɩ ka garɩchɔɔtɩŋ a baalɩ a ligi garɩkʋʋŋ vɔrɩŋ, dama ʋ yi die ʋ nan chʋʋsɩ garɩhaalɩkʋ ta garɩhaalɩkʋ aŋaŋ garɩkʋʋrɩ kaaŋ dɩ mʋ taŋ. ");
INSERT INTO kma_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yaa nɩ yeye ta vuoŋ nagɩ daahaalɩŋ asʋ gbanɩŋ koliti diekemba dɩ yine nyɩŋkʋra ma? Dama ʋ yi die daabʋ nan kʋŋ a chɩɩrɩ kolititi aŋ daabʋ aŋaŋ kolititi mana taaŋ yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ama sie ʋ nagɩ daahaalɩŋ asʋ gbanɩŋ koliti diekemba dɩ yine nyɩŋhaala ma. ");
INSERT INTO kma_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dɩɩ yi ta vuoŋ dɩ nyuu daakʋʋŋ, ʋ keŋ ye daahaalɩŋ ʋ ka bɩ yaala, ʋ ŋaaŋ baarɩ dɩ ‘Daakʋʋrɩ nansɩna.’ ” ");
INSERT INTO kma_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Davʋʋsɩkɩrɩ daaŋ kaanɩ die Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ chʋŋ tɩanna zaa kʋaŋ ma, ta ʋ kʋaŋandɩɩsɩrɩba die dɩ gobe zaapakɩtɩ a yɩaga ŋɔba. ");
INSERT INTO kma_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ta Farasisi bataŋ die dɩ pɩasɩ ba dɩ, “Bɩa nɩ yie wudieke tɩ mɩraha dɩ dagɩna dɩ tɩ da yi davʋʋsɩkɩrɩ daaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yisa die a pɩasɩ ba dɩ, “Nɩ ye ka karɩŋ Ŋmɩŋ gbaŋkʋ sʋŋ Davidi die dɩ yine die wo? Kɔŋ die yalla wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba, ");
INSERT INTO kma_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","die ʋ ga Ŋmɩŋ jɩamɩŋ juoku sʋŋ a ga nagɩ paanʋ dieke ba nagɩna a yɩ Ŋmɩŋ a ŋɔbɩ ta bɩ nagɩ yɩ ʋ kʋaŋandɩɩsɩrɩba ba ŋɔbɩ. Ama tɩ mɩraha die ka yɩ sieŋ dɩ vuoŋ ŋɔbɩha sie Ŋmɩŋ kɩkaabɩtʋ nyɩɩna ma.” ");
INSERT INTO kma_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yisa die dɩ bɩ balɩ ba dɩ, “Manɩŋ vuota Bʋa yine davʋʋsɩkɩrɩ daarɩ tieŋ.” ");
INSERT INTO kma_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Davʋʋsɩkɩrɩ daaŋ kaanɩ bɩbra Yisa die dɩ ga juu Ŋmɩŋ jɩamɩŋ juoku a daga Ŋmɩŋ wɩa, ta daa wʋnyɩ die dɩ bie mi ʋ nuudiigiŋ die dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta die Ŋmɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisi bataŋ die dɩ bie mi a yaala sieti dɩ ba galɩŋ Yisa, die wɩa die ba daansa wa dɩ ba ye dɩ ʋ nan gbaaŋ wa davʋʋsɩkɩrɩ daarɩ. ");
INSERT INTO kma_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama Yisa die mɩŋŋɩ ba sʋŋanyilehe ta balɩ yɩ daa dieke nuuke dɩ kpine wo dɩ, “Hagɩ a zie vuoŋ mana nɩŋŋa.” Die wɩa die ʋ hagɩ a zie mi. ");
INSERT INTO kma_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Die Yisa dɩ balɩ a yɩ ba dɩ, “Nɩ vaa n pɩasɩ nɩ, bɩa tɩ mɩraha dɩ baa tɩ yime davʋʋsɩkɩrɩ daraaŋ? Dɩ tɩ suŋŋi vuosi yaa tɩ chʋʋsɩ ba? Tɩ gbatɩma vuoŋ mɩsɩ taamma yaa tɩ kʋʋ ba?” ");
INSERT INTO kma_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Die wɩa ʋ daansɩ ba mana a tɩaŋ, ta die balɩ yɩ nuukpiikiri tieŋ dɩ, “Tɩɩntɩ fʋ nuuke.” Die ʋ tɩɩntɩ ʋ nuuke die ka bɩ hagɩrɩ bɩbra. ");
INSERT INTO kma_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama Ŋmɩŋ mɩraha dɩdagɩrɩba aŋaŋ Farasisisi die dɩ jɩɩ sɩnyɩɩrɩŋ, a piili a bala yɩa taŋ ba baaŋ yi Yisa dene. ");
INSERT INTO kma_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Saŋka mi Yisa die dɩ ga jʋalɩ kunkogiŋ dɩ ʋ jʋʋsɩ Ŋmɩŋ, a die jʋʋsɩ Ŋmɩŋ kanɩŋ yuku mi mana. ");
INSERT INTO kma_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Die tuŋ dɩ vʋnna die ʋ wa ʋ kʋaŋanvuosi a keŋ lagɩsɩ ʋ jigiŋ a vʋarɩ vuosi baŋ-ale, a wa ba tʋntʋntɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Die ʋ vʋarɩ wa Simoni (vuodieke ʋ wasɩnana Piita) aŋaŋ Simoni nɩmbʋabiŋ Andurusi aŋaŋ Jemisi aŋaŋ Jɔɔn aŋaŋ Filipi aŋaŋ Batolomiwo, ");
INSERT INTO kma_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","aŋaŋ Matiwo aŋaŋ Tomasi aŋaŋ Alifusi bʋadembiŋ Jemisi aŋaŋ Simoni vuodieke die dɩ yaala banɩŋ Juu vuosi yallɩma ba gbaŋ wa, ");
INSERT INTO kma_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","aŋaŋ Judasi vuodieke die dɩ yine Jemisi bʋa wa aŋaŋ Judasi Asikaroti vuodieke die dɩ posine Yisa chɩaka. ");
INSERT INTO kma_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisa die dɩ keŋ sʋʋŋ kunkogiri me aŋaŋ ba, die a ga zie tɩŋgbaŋ dieke dɩ mʋna taŋ; ta die ʋ kʋaŋanvuosi pam die dɩ bie mi; vuosi pam die dɩ nyɩŋ Judia chaaŋ mana aŋaŋ Jerusalemi aŋaŋ Taya aŋaŋ Sadoni mana tɩgɩsɩ die dɩ gbigine mʋgɩkpɩɩrɩ, ");
INSERT INTO kma_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","die ba keŋye mɩŋ dɩ ba wʋŋ ʋ wʋbalɩka ta bɩ yaala ʋ gbaaŋ ba. Vuodiekemba die jɩmbɩatɩ die dɩ yalla ba gbaŋ die keŋye mɩŋ, die ʋ gbaaŋ ba. ");
INSERT INTO kma_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Die vuosi mana die dɩ mɩa dɩ ba gbɩ wa, dama hagɩrɩŋ die nyɩna ʋ ma a gbaama ba mana. ");
INSERT INTO kma_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Saŋka mi die Yisa die dɩ daansɩ ʋ kʋaŋandɩɩsɩrɩba ta baarɩ dɩ, “Nɩnɩŋ zɔɔlɩntieliŋ sʋgɩfɩalɩŋ yiwo nɩ sɩɩtɩ, dama Ŋmɩŋ naarɩ yiwo nɩ sɩɩtɩ! ");
INSERT INTO kma_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nɩnɩŋ vuodiekemba kɔŋ dɩ yalla lele, sʋgɩfɩalɩŋ yiwo nɩ sɩɩtɩ, dama nɩ nan keŋ chagɩ. Nɩnɩŋ vuodiekemba dɩ kʋnnana lele, sʋgɩfɩalɩŋ yiwo nɩ sɩɩtɩ, dama nɩ nan daansɩ a laa. ");
INSERT INTO kma_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Vuosi dɩ keŋ haa nɩ ta zeti nɩ ta zɩa nɩ ta chʋʋsa nɩ saara, dama nɩ dɩna manɩŋ vuota Bʋa wɩa, sʋgɩfɩalɩŋ yiwo nɩ sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nɩ yallɩma sʋgɩfɩalɩŋ ta seme dama nɩ nyʋarɩ nan daansɩ dala Ŋmɩŋ naarɩ ma; die gbaŋ gbaŋ die ba chʋalɩba die dɩ yi Ŋmɩŋ naazʋalɩba. ");
INSERT INTO kma_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nɩnɩŋ nyintitieliŋ, wʋbɩaŋ bie nɩ ma, dama nɩ wɔŋ ye nɩ choti jaaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nɩnɩŋ vuodiekemba dɩ chagɩna lele, wʋbɩaŋ bie nɩ ma, dama kɔŋ nan daansɩ yigi nɩ. “Nɩnɩŋ vuodiekemba dɩ lanana lele, wʋbɩaŋ bie nɩ ma, dama nɩ nan daansɩ ye sʋgɩchʋʋsɩŋ aŋaŋ kpaŋ. ");
INSERT INTO kma_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Nɩnɩŋ vuodiekemba vuosi mana dɩ bɩrɩnana, wʋbɩaŋ bie nɩ ma; dama die gbaŋ gbaŋ ba chɔɔŋkʋʋlɩba die dɩ bɩrɩ ŋmɩnchɩbɩsɩ naazʋalɩba. ");
INSERT INTO kma_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ama n bala nɩnɩŋ vuodiekemba dɩ wʋnnana n balɩkʋ gie, nɩ chome nɩ dataasɩ ta yime wʋvɩɩna a yɩma vuodiekemba dɩ hana nɩ. ");
INSERT INTO kma_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ta vuodiekemba dɩ kanana kaatɩ a yɩa nɩ, nɩ balɩ ba dɩ ‘Ŋmɩŋ suŋŋi be’, ta jʋʋsɩma Ŋmɩŋ a yɩma vuodiekemba dɩ yinene nɩ bɩaŋ ");
INSERT INTO kma_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Dɩɩ yi vuoŋ dɩ keŋ falɩ fʋ kaamɩŋ fʋ yiŋŋi kaanɩ wa gbaŋ a yɩ wa aŋ ʋ falɩ. Dɩɩ yi vuoŋ dɩ keŋ a nagɩ fʋ jayeekikpeŋkpɩɩŋ fʋ vaa ʋ nagɩ fʋ jayeekibiŋ a gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Vuodieke nɩŋ mana dɩ keŋ jʋʋsɩ fʋ jaaŋ fʋ yɩ wa, ta vuoŋ dɩ keŋ gbatɩ fʋ jaaŋ da keŋ dɩa a ga tuo. ");
INSERT INTO kma_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wudieke fʋ yaala vuosi yi a yɩ fʋ, fʋ yi die a yɩ fʋ chanchaalɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Dɩɩ yi fʋ cho vuodiekemba dɩ chone fʋ nyɩɩna ma, bɩa Ŋmɩŋ dɩ baa ʋ nagɩ gʋtɩ fʋ? Tʋntʋmbɩatɩ tieliŋ gbaŋ cho wo vuodiekemba dɩ chone be. ");
INSERT INTO kma_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta dɩɩ yi fʋ yie vɩɩnɩŋ a yɩa vuodiekemba dɩ yinene vɩɩnɩŋ a yɩa fʋ bɩa Ŋmɩŋ dɩ baa ʋ nagɩ a gʋtɩ fʋ? Tʋntʋmbɩatɩ tieliŋ gbaŋ yie die. ");
INSERT INTO kma_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dɩɩ yi fʋ paŋŋa vuodiekemba fʋ sɩbɩna dɩ ba nan yiŋŋi tuŋ fʋ, bɩa Ŋmɩŋ dɩ baa ʋ nagɩ a gʋtɩ fʋ? Tʋntʋmbɩatɩ tieliŋ gbaŋ paŋŋa die a yɩa ba chanchaalɩŋ ta yiŋŋi tuose ba nyinti. ");
INSERT INTO kma_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Die wɩa nɩ chome nɩ dataasɩ ta yime vɩɩnɩŋ a yɩma ba. Ta dɩɩ yi nɩ paŋŋɩ vuoŋ jaaŋ ka ga yʋasɩ, da vaa nɩ sʋgɩtɩ chʋʋsɩ a wɩa, dama nɩ nyʋarɩ nan daansɩ dala, ta nɩ nan bɩ yi Nabidie Ŋmɩŋ ballɩ. Dama wʋnɩŋ ʋ yie wʋvɩɩna a yɩa vuodiekemba nine dɩ kana ka suule wudieke ʋ yinene a yɩa ba aŋaŋ vuobɩatɩ mana. ");
INSERT INTO kma_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nɩ chɩgɩma zɔɔlɩŋ sɩba nɩ Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma dɩ chɩgɩnana zɔɔlɩŋ dene wo. ");
INSERT INTO kma_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Da keŋ a dii vuoŋ sarɩya amʋ Ŋmɩŋ da keŋ dii fʋ sarɩya, da keŋ balɩ a chʋʋsɩ vuoŋ amʋ Ŋmɩŋ da keŋ balɩ a chʋʋsɩ fʋ. Nagɩ fʋ chanchaalɩŋ taalɩ a chaa ba amʋ Ŋmɩŋ dɩaŋ nagɩ fʋ taalɩ a chaa fʋ. ");
INSERT INTO kma_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yɩma vuosi amʋ Ŋmɩŋ dɩaŋ nagɩ yɩ fʋ. Dɩ nan dɩ sɩɩ sɩba Ŋmɩŋ dɩ baaŋ nan nagɩ ʋ kuruba a mɔgɩsɩ zaa, ta ka keŋ suuli aŋaŋ ka kʋanʋaŋ mana aŋ ʋ jɩɩ jɩɩ ta dɔŋ dɔŋ ta a keŋ suuli a jaasa aŋ ʋ nagɩ a yɩ fʋ, fʋ baaŋ nan bɩagɩ a pɔgɩlɩ dene. Fʋ nagɩna fʋ kuruba a mɔgɩsa nyinti a yɩa vuosi die, Ŋmɩŋ gbaŋ nan mɔgɩsɩ die a yɩ fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ka kʋaŋ chaaŋ Yisa die dɩ taaŋ ba nandagɩrɩ gie dɩ, “Yɩɩ nan bɩagɩ a datɩ ʋ chanchaaŋ? Ba mana kaaŋ nan goliŋ me? ");
INSERT INTO kma_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Bʋbʋgʋrʋ dɩaŋ ka tɩaŋ ʋ dɩdagɩrʋ; ama bʋbʋgʋrʋ dɩaŋ dɩ keŋ mɩŋŋɩ a bʋgɩrɩ a kpatɩ ʋ nan dɩ sɩɩ sɩba ʋ dɩdagɩrɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bɩa fʋ daansa a yese mɩnchɩɩbɩŋ dieke dɩ benne fʋ chanchaaŋ nimbiŋ me ta ka ye dakʋʋlɩ dieke dɩ benne fʋ gbaŋ gbaŋ fʋ nimbiŋ me? ");
INSERT INTO kma_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Lalɩa fʋ baa fʋ yi a balɩ yɩ fʋ chanchaaŋ dɩ, ‘N zʋa, vaa n vʋarɩ ŋmɩnchɩɩbɩŋ dieke dɩ benne fʋ nimbiŋ me’, ta ka ye dakʋʋlɩ dieke dɩ benne fʋ gbaŋ gbaŋ fʋ nimbiŋ me? Fʋnɩŋ gɩgaantʋ wa gie, woliŋ nagɩ dakʋʋlɩ dieke dɩ benne fʋ gbaŋ gbaŋ fʋ nimbiŋ me amʋ fʋ mɩŋŋɩ ye a vʋarɩ ŋmɩnchɩɩbɩŋ dieke dɩ benne fʋ chanchaaka nimbiŋ me wo.” ");
INSERT INTO kma_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Tɩɩvɩɩnɩŋ ka wala nyɩŋnyɩŋkɩbɩatɩ, ta tɩɩ dieke dɩ yʋagɩna ka wala nyɩŋnyɩŋka vɩɩna. ");
INSERT INTO kma_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tɩɩŋ nyɩŋnyɩŋka ma ba sɩba ka. Ba ka yese kɩnkamɩŋ haŋgɔɔsɩ jigiŋ a tʋʋra, yaa taama jɩa jigiŋ a tʋʋra. ");
INSERT INTO kma_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Vuovɩɩnɩŋ yie tʋnvɩɩna dama ʋ sʋŋ vɩɩna mɩŋ; ta vuobɩaŋ dɩaŋ dɩ yie tʋmbɩatɩ dama ʋ sʋŋ suuli wo aŋaŋ wʋbɩatɩ. Jadieke dɩ benne vuoŋ sʋŋ ma kanɩŋ ʋ bala. ");
INSERT INTO kma_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bɩa nɩ wasa mɩŋ nɩ Yɔmʋtieŋ ta ka yie wudieke n yaalala? ");
INSERT INTO kma_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vuodieke mana dɩ kienene n jigiŋ ta wʋmma n wʋbalɩkaha ta dɩha, n nan dagɩ nɩ ʋ sɩna die. ");
INSERT INTO kma_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wʋnɩŋ ʋ sɩɩ sɩba daa wʋnyɩ die dɩ mɩna ʋ tigiŋ, ta die woliŋ a tuu tɩŋgbaŋ a sʋʋŋ a ga tʋgɩ taŋ ta dʋaŋ nyabɩlɩŋ tanɩ sikpeŋ. Ka kʋaŋ chaaŋ nɩɩŋ dɩ keŋ nɩɩ pam ta mʋgɩŋ dɩ kpaa ta nyaabʋ dɩ keŋ nɩgɩ tigiri, ama die tigiri ka nanya dama die ʋ mɩŋŋɩ mɩɩ ka mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama vuodieke mana dɩ wʋnnana n wɩaha gie ta ka dɩha sɩɩ sɩba daa wʋnyɩ die dɩ mɩna ʋ tigiŋ a zieŋ tambʋsɩŋ me ta ka dʋaŋ nyabɩlɩŋ ka chɩaŋ wa, ta die nɩɩŋ dɩ nɩɩ mʋgɩŋ dɩ kpaa, ta nyaaŋ dɩ keŋ nɩgɩ tigiri, die ka nan bʋnyɩ. Bɩa chʋʋsɩbɩaŋ wʋnna!” ");
INSERT INTO kma_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Die Yisa die dɩ dagɩna vuosisi a kpatɩ wa die ʋ nyɩŋ a ga Kapenɔmi tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mi Romanisi sojasi jakʋʋŋ wʋnyɩ die dɩ bie mi a yallɩ ʋ tʋntʋntʋ ʋ chone pam, die yʋagɩŋ dɩ yigi wo ʋ gbigi kuŋ. ");
INSERT INTO kma_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Die jakʋʋrɩ dɩ wʋŋ Yisa wɩa, a tʋŋ Juu vuosi nyɩŋkʋra bataŋ dɩ ba ga a wa wa dɩ ʋ keŋ a gbaaŋ ʋ tʋntʋntʋ wa. ");
INSERT INTO kma_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Die ba keŋ Yisa jigiŋ a jʋʋsɩ wa aŋaŋ nɩŋŋmɩna a baarɩ dɩ, “Daa wa gie mʋ dɩ fʋ suŋŋi wo, ");
INSERT INTO kma_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","dama ʋ cho tɩ tɩŋgbaŋka gie vuosi, ta mɩɩ Ŋmɩŋ jɩamɩŋ juoŋ a yɩ tɩ.” ");
INSERT INTO kma_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Die wɩa Yisa die dɩ dɩ ba kʋaŋ a ga. Die ʋ gana a gbige tigiri, jakʋʋrɩ die dɩ tʋŋ ʋ zʋalɩŋ dɩ ba keŋ balɩ wa dɩ, “N Yɔmʋtieŋ daa mugisi fʋ gbaŋ a kiere, dama n ka mʋ dɩ fʋ keŋ juu n tigiŋ me. ");
INSERT INTO kma_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Die wɩa maŋ ka keŋ fʋ jigiŋ n gbaŋ gbaŋ wa. Ama ko yɩ nʋaŋ aŋ n tʋntʋntʋ wa ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Dama manɩŋ n gbaŋ n yaa wa n nyɩŋkʋra, ta yallɩ sojasi ba dɩɩ n kʋaŋ. N ŋaaŋ balɩ a yɩ geŋ wo, gamma aŋ ʋ ga, ta balɩ a yɩ geŋ wo kiere aŋ ʋ keŋ; ta bɩ vaa n yɔmʋ yi wudieke n yaalala.” ");
INSERT INTO kma_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisa die dɩ wʋnna naa die dɩ paalɩ a yi wo mamachi, die ʋ yiŋŋi a balɩ yɩ kpɩkpaakʋ die dɩ dɩna ʋ kʋaka dɩ, “N bala nɩ, n ye ka ye vuoŋ dɩ yine mɩŋ yada sɩba naa Izara vuosi sʋŋ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Die sojasi jakʋʋrɩ zʋalɩba die dɩ yiŋŋi a ga ʋ tigiri me a ye ʋ tʋntʋntʋ wa dɩ yene alaafɩa. ");
INSERT INTO kma_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Die tuŋ dɩ vʋʋna Yisa die dɩ ga tɩŋ kaanɩ ba wasɩnana Neeni, ta ʋ kʋaŋandɩɩsɩrɩba aŋaŋ kpɩkpaakʋ die dɩ dɩ ʋ kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Die ʋ dene a ga tʋgɩ tɩka nʋaŋ, die ʋ ye kpɩkpaaŋ dɩ nyɩna tɩka sʋŋ a chii kuŋ dɩ ba ga guu. Vuodieke die dɩ kpine wo die yiwo kpihɔgʋ wʋnyɩ bʋabalɩmɩŋ, die ʋ yiwo dembiŋ. Kpihɔgʋ wa gbaŋ die bie kpɩkpaakʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Die Yisa die dɩ yene kpihɔgʋ wa zɔɔlɩŋ die dɩ yigi wo ʋ balɩ a yɩ wa dɩ, “Da kʋmma!” ");
INSERT INTO kma_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ta die dɩ a ga a gbɩ tɩaka, ta vuodiekemba die dɩ chine wo wo dɩ zie. Yisa die dɩ balɩ dɩ, “Dalʋakɩŋ hagɩ!” ");
INSERT INTO kma_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Die kumbu miivoli die dɩ yiŋŋi keŋ, ta ʋ hagɩ kalɩ a piili bala wɩa. Yisa die dɩ yiŋŋi a nagɩ wa yɩ ʋ nuŋ. ");
INSERT INTO kma_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Die ŋmaamɩŋ die dɩ yigi vuodiekemba mana die dɩ benne mi, ba mana die dɩ bɩrɩ Ŋmɩŋ, a baarɩ dɩ, “Ŋmɩŋ naazʋakpeŋkpɩɩŋ keŋ nyɩŋ tɩ jigiŋ mɩŋ”; ta bala taŋ dɩ, “Ŋmɩŋ keŋ sʋʋŋ a suŋŋi ʋ vuosi mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yisa wɩaha gie die dɩ mʋʋlɩ ga Judia tɩŋ mana aŋaŋ tɩgɩ diekemba mana dɩ gbigine mi. ");
INSERT INTO kma_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ka kʋaŋ chaaŋ Jɔɔn dieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ kʋaŋandɩɩsɩrɩba die dɩ ga a balɩ wa wɩaha gie mana. Die ʋ wa vuosi bale ʋ kʋaŋandɩɩsɩrɩba sʋŋ, ");
INSERT INTO kma_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a tʋŋ ba tɩ Yɔmʋtieŋ Yisa jigiŋ dɩ ba ga pɩasɩ wa dɩ, “Fʋnɩŋ fʋ yine vuodieke dɩ balla ʋ keŋ wo yaa tɩ ye chɩɩsɩma vuogaaŋ bɩbra?” ");
INSERT INTO kma_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Die ba kenne tʋgɩ Yisa jigiri, die ba balɩ wa dɩ, “Jɔɔn dieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ tʋnna tɩ dɩ tɩ keŋ pɩasɩ fʋ dɩ, ‘Fʋnɩŋ fʋ yine vuodieke ʋ bala dɩ ʋ nan keŋ wo yaa tɩ ye chɩɩsɩma vuogaaŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kanɩŋ saŋka mi gbaŋ gbaŋ Yisa die dɩ gbaaŋ vuosi pam, yʋagɩtieliŋ aŋaŋ vuodiekemba yʋagɩtɩ die dɩ faasɩna a hagɩrɩ, ta vʋarɩ jɩmbɩatɩ vuosi pam ma, ta die vaa yɩɩsɩ pam nine dɩ yuori. ");
INSERT INTO kma_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Die ʋ yiŋŋi a balɩ Jɔɔn tʋntʋntɩba dɩ, “Nɩ yiŋŋi a ga balɩ Jɔɔn wudieke nɩ wʋnnana ta yese wudiekemba; dɩ nɩ ye ta yɩɩsɩ nine dɩ yuorine, gbarɩgɩsɩ dɩ chʋŋ, ta vuodiekemba die dɩ yʋagɩna gamɩŋ ye wo gbaamɩŋ, tɩkpaara tieŋ dɩ wʋmma, ta kunti dɩ haga kuŋ me, ta zɔɔlɩntieliŋ dɩ wʋmma Ŋmɩŋ wʋbalɩkɩ vɩɩnaha. ");
INSERT INTO kma_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta sʋgɩfɩalɩŋ bie vuodieke dɩ kana ka chɩɩlɩ mɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jɔɔn tʋntʋntɩba die dɩ yiŋŋine a ga a kpatɩ wa, Yisa die dɩ piili a pɩasa kpɩkpaakʋ yaa gamma Jɔɔn wɩa dɩ, “Die nɩ gana Jɔɔn jigiri hagɩrɩ ma wa, bɩa die nɩ yile dɩ nɩ nan ye? Die nɩ yile dɩ nɩ nan ye hʋʋtɩ bʋlɔgɩsɩŋ dɩ nɩgɩnana? ");
INSERT INTO kma_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yaa bɩa die nɩ nyɩŋ ga nɩ ye? Dembiŋ dɩ yeegine nyiŋyeeki vɩɩna? Vuodiekemba dɩ yeeginene nyiŋyeeki vɩɩna ta bie ba dʋŋŋʋ bie wo naaleesi me. ");
INSERT INTO kma_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nɩ balɩ mɩŋ, vuobɩa die nɩ nyɩŋ ga nɩ ye wo? Nɩ tɩŋ yile dɩ nɩ nan ye Ŋmɩŋ naazʋa yaa? Wusie maŋ bala nɩ, Jɔɔn nɩŋ tɩaŋ naazʋa. ");
INSERT INTO kma_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dama Jɔɔn die yine vuodieke Ŋmɩŋ die dɩ bala ʋ gbaŋkʋ sʋŋ dɩ, ‘Manɩŋ n nan tʋŋ n tʋntʋntʋ aŋ ʋ woliŋ dɩa fʋ nɩŋŋa a wʋnsɩ fʋ keniŋ sieku a dʋaŋ fʋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yisa die dɩ bɩ balɩ ba a gʋtɩ dɩ, “Manɩŋ n bala nɩ, ba ye ka mɩɩrɩ vuoŋ dɩ tɩanna Jɔɔn, ama vuodieke dɩ wɩarɩna kʋaŋ Ŋmɩŋ naarɩ ma tɩaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Ta Vuoŋ mana aŋaŋ lampotuosiribe die dɩ saagɩ dɩ Nabidie Ŋmɩŋ vɩɩna, dama die ba wʋŋ Jɔɔn mʋʋlɩŋ, ta vaa ʋ sɩɩ ba Ŋmɩŋ nyaabʋ. ");
INSERT INTO kma_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama Farasisi aŋaŋ vuodiekemba die dɩ dagɩnana Ŋmɩŋ mɩraha die dɩ zeti Ŋmɩŋ dɩ sanna die a yɩ ba, dama die ba ka saagɩ dɩ Jɔɔn sɩɩ ba Ŋmɩŋ nyaabʋ.) ");
INSERT INTO kma_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ta Yisa die dɩ bɩ balɩ ba dɩ, “Nɩnɩŋ leleke gie vuosi, bɩa maŋ nan nagɩ a magɩsɩ nɩ? Vuoŋ bɩa yine nɩ? ");
INSERT INTO kma_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nɩ nɩasɩ wa ballɩbɩsɩ dɩ kalla nyʋʋŋ jigiŋ a nata wasa tamba, ‘Tɩ wɩa wɩɩŋ a yɩa nɩ ama nɩ ka sie, ta chɩa hanye a yɩa nɩ ama nɩ ka kʋma.’ ");
INSERT INTO kma_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nɩnɩŋ leleke gie vuosi nɩasɩ wa ballɩbɩsɩ gie dama Jɔɔn die dɩ kenne ta ka die nyindiike gbaŋ gbaŋ ta ka nyuo daaŋ ta nɩ baarɩ dɩ ʋ yiwo yɩɩŋyaaŋ; ");
INSERT INTO kma_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ta manɩŋ vuota Bʋa dɩ keŋ die ta nyuo, nɩ baarɩ ‘Ye, ʋ yiwo wutulitieŋ aŋaŋ daanyuru; ta bɩ yi lampotuosiriŋ aŋaŋ tʋntʋmbɩatɩ tieliŋ zʋa.’ ");
INSERT INTO kma_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ama vuodiekemba dɩ tuone Ŋmɩŋ yɩaŋ daga dɩ dɩ yiwo wusie.” ");
INSERT INTO kma_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Die Farasisi wʋnyɩ die dɩ wa Yisa dɩ ʋ keŋ aŋ ba dii nyindiike ʋ tigiŋ me. Die Yisa die dɩ ga daa wa tigiri me, ba mana dɩ lagɩŋ kalɩ a die. ");
INSERT INTO kma_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Die hɔgʋ wʋnyɩ die benne tɩka ma a dʋaga dembisi die dɩ wʋŋ dɩ Yisa bie daa wa tigiri me a die nyindiike, die wɩa ʋ yaa kɔlɩba aŋaŋ tulaari dieke ligire dɩ faasɩna tʋa, ");
INSERT INTO kma_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","a die a keŋ a gbigiri Yisa nagɩsɩ chɩaŋ, a kʋma ʋ nintaantɩ dɩ nanna Yisa naatala ma. Die Yisa naatala die dɩ sʋnsɩ ta die hɔgʋ wa die dɩ nagɩ ʋ sikpeŋ zoosi a chɩtɩ ha ta die a mɔgɩsɩ ʋ naatala ta sɩɩtɩ tulaaribu a yi he. ");
INSERT INTO kma_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Die Farasisi dieke die dɩ wana Yisa wa die dɩ yene naa ʋ yile ʋ sʋŋ ma dɩ, “Dɩɩ yi daa wa gie dɩ seŋ yi Ŋmɩŋ naazʋa wusie, ʋ tɩŋ nan dɩ sɩba hɔgʋ wa gie dɩ yine vuodieke. Ʋ tɩŋ nan dɩ sɩba a baarɩ dɩ ʋ yiwo tʋntʋmbɩatɩ tieŋ.” ");
INSERT INTO kma_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Die wɩa Yisa die dɩ balɩ Farasisi wa dɩ, “Simoni n yaa wɩɩŋ n baa n balɩ fʋ.” Ta Simoni die dɩ yiŋŋi baarɩ, “Dɩdagɩrʋ balɩ mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yisa die dɩ balɩ wa dɩ, “Die dembisi bale die yalla vuodieke dɩ paŋŋɩnana ligire hamɩŋ. Wʋnyɩ die dii wo ligire bie kɔbɩsɩ-nʋ hamɩŋ, ta wʋnyɩ dɩaŋ die dɩ dii ligire bie baŋɩsɩ-nʋ hamɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Die ba wʋnyɩ mana die ka bɩagɩ tuŋ wo, die wɩa die ʋ nagɩ chaa ba mana dɩ ba gamma. Lele, ba jabɩa balla ʋ chome wo pam?” ");
INSERT INTO kma_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni die dɩ yiŋŋi balɩ wa dɩ, “N yi tama vuodieke hannɩ die dɩ faasɩna a dala wa.” Yisa die dɩ balɩ wa dɩ, “Fʋnɩŋ balɩ wa wusie.” ");
INSERT INTO kma_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Die ʋ yiŋŋi a daansɩ hɔgʋ wa ta balɩ yɩ Simoni dɩ, “Ye hɔgʋ wa gie? N kenne juu fʋ tigiri gie me, ka yɩ mɩŋ nyaaŋ dɩ n nɩtɩ n naatala ama hɔgʋ wa gie nɩtɩ wa n naatala aŋaŋ ʋ nintaantɩ ta chɩtɩha aŋaŋ ʋ sikpeŋ zoosi. ");
INSERT INTO kma_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ama fʋnɩŋ nɩŋ ka mɔgɩsɩ mɩŋ, ama wʋnɩŋ nɩŋ ʋ ka vaa n naatala mɔgɩsɩŋ n kenne a juu giena wa. ");
INSERT INTO kma_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta ka bɩ nagɩ kpaaŋ a duuri n sikpeŋ, ama wʋnɩŋ nɩŋ ʋ siti wo tulaari a yi n naatala ma. ");
INSERT INTO kma_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","N bala nɩ, n nagɩ wa ʋ tʋmbɩatɩ pam wa mana a chaa wa; die wɩa ʋ cho mɩŋ pam wa, ama vuodieke n nagɩna a chaa wa bɩta, wʋnɩŋ ʋ gbaŋ chome mɩŋ bɩta.” ");
INSERT INTO kma_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Die wɩa Yisa die dɩ balɩ a yɩ hɔgʋ wa dɩ, “N nagɩ fʋ taalɩ a chaa fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ta vuodiekemba die dɩ kala a gʋtɩ ba die wo die dɩ yile ba sʋgɩtɩ ma dɩ, “Mɩnɩa wʋnna a bɩagɩ naga vuosi taalɩ a chaa ba?” ");
INSERT INTO kma_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ta Yisa die dɩ balɩ a yɩ hɔgʋ wa dɩ, “Fʋ yada gbatɩna fʋ a taaŋ, gamma aŋaŋ sʋgɩdʋagɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naa kʋaŋ chaaŋ Yisa die dɩdɩ dɩa tɩgɩkpɩɩma aŋaŋ tɩŋkpaŋŋɩsɩ a bala Ŋmɩŋ wʋvɩɩnaha yaa gamma Ŋmɩŋ naarɩ wɩa. Ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale die dɩ wa mɩŋ a ga, ");
INSERT INTO kma_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","aŋaŋ hɔgʋba bataŋ die ʋ vʋarɩna jɩmbɩatɩ ta gbaaŋ bataŋ yʋagɩtɩ; die ba yiwo, Meri Magidalini vuodieke die ʋ vʋarɩna jɩmbɩatɩ bayʋpɔyɩ ʋ ma: ");
INSERT INTO kma_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bataŋ die yiwo Chuza hɔgʋ wa, Johana (Chuza die yiwo Herodi tigiri tʋntʋntɩba jakʋʋŋ) aŋaŋ Susana aŋaŋ hɔgʋ ba pam. Die hɔgʋba gie die naga ba gbaŋ gbaŋ ba nyinti a suŋŋe Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba. ");
INSERT INTO kma_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Die daadaaŋ pam die dɩ nyɩna tɩgɩsɩ tɩgɩsɩ pam a kieŋ Yisa jigiŋ, ta kpɩkpaakʋ die dɩ keŋ lagɩsɩ a taaŋ a giliŋ Yisa, die ʋ taaŋ ba nandagɩrɩ gie dɩ: ");
INSERT INTO kma_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Daa wʋnyɩ die nyɩna ga ʋ kʋaŋ dɩ ʋ ga bʋrɩ nyɩŋbʋra. Die ʋ bʋrɩnana wa a taŋ die dɩ nan sieŋ me die ba tɩbɩha tɩanna ta nembisi die dɩ keŋ nagɩha dii. ");
INSERT INTO kma_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ataŋ dɩaŋ die dɩ nan taŋ sikpeŋ jigidieke tantɩ die kana ka dala, die a nyune wo die a jigi dama tɩŋgbaŋka die ka sʋnsɩ. ");
INSERT INTO kma_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ataŋ dɩaŋ die dɩ nan haŋgɔɔsɩ dagɩrɩsɩ ma die a mana die dɩ lagɩsɩ nyuŋ, haŋgɔɔsɩ die dɩ nyagɩ ha. ");
INSERT INTO kma_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta ataŋ dɩaŋ die dɩ nan tɩŋgbaŋ vɩɩnɩŋ ma, ta die a nyuŋ a bɩrɩŋ ta nyɩŋ bie kɔbɩga kɔbɩga.” Yisa die dɩ wa balɩ ba a kpatɩ dɩ, “Vuodieke dɩ yalla tɩba ta nan wʋŋ ʋ wʋmma!” ");
INSERT INTO kma_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka kʋaŋ chaaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasɩ wa nandagɩrɩ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ʋ yiŋŋi a balɩ ba dɩ, “Nɩnɩŋ nɩŋ Ŋmɩŋ vaa nɩ sɩba ʋ naarɩ wʋlɔbɩrɩkɩrɩ mɩŋ, ama banɩŋ ba nɩŋ ʋ taana ba nandaga, dɩ ba daansɩ ama ba da keŋ ye, ta wʋŋ ama ta kaaŋ dɩ sɩba a chɩasɩ.” ");
INSERT INTO kma_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nandagɩrɩ chɩaŋ wʋnna: Nyɩŋbʋraha yine Ŋmɩŋ wʋbalɩka ha. ");
INSERT INTO kma_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nyɩŋbʋrɩ dieke dɩ nanna sieku me wo nɩasɩ wa vuodiekemba dɩ ŋaana wʋŋ Ŋmɩŋ wɩaha, ama Sitaani keŋ a nagɩ wɩa ha a nyɩŋ ba sʋgɩtɩ ma, amʋ ba da keŋ tuo dii ta ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nyindiekemba dɩ nanna tanɩ sikpeŋ nɩasɩ wa vuodiekemba dɩ ŋaana wʋŋ wɩaha aŋaŋ sʋgɩfɩalɩŋ, ama a ka sʋʋna ba sʋgɩtɩ ma, ba ŋaaŋ yiwo yada bɩta, ama saŋŋa dieke magɩsɩŋ dɩ keŋ keŋ ba ŋaaŋ nagɩha taaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nyɩŋbʋrɩ dieke dɩ nanna haŋgɔɔsɩ dagɩrɩsɩ jigiri nɩasɩ wa vuodiekemba dɩ ŋaana wʋŋ wɩaha ama tɩŋgbaŋka wumugisike aŋaŋ nyinti yaalɩŋ keŋ juu a nyagɩ ha, amʋ a da keŋ bɩrɩŋ a nyɩŋ bie. ");
INSERT INTO kma_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ama nyindiekemba dɩ nanna tɩŋgbaŋ vɩɩkʋ ma wa nɩasɩ wa vuodiekemba dɩ ŋaana wʋŋ wɩaha ta tuohe aŋaŋ sʋgɩvɩɩnɩŋ ta mɩŋŋɩ pɔgɩlɩ ha keŋ keŋ ta bɩ yaa hanɩa, ta nyɩŋ bie vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Vuosi ka chɔgɩsa popoli ta naga kpalɩ a bubi ke yaa a naga ka a ziele gado chɩaŋ. Ama ba ŋaaŋ nagɩ ka mɩŋ a sagɩ popoli daaŋ ma amʋ vuosisi dɩ keŋ juu ba ye ka chaaŋkʋ. ");
INSERT INTO kma_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wudieke mana dɩ lɔbɩrɩna nan daansɩ a keŋ nyɩŋ yeŋ ta wudieke mana dɩaŋ dɩ ligine nan keŋ yuori ta nyɩŋ chaanɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Die wɩa nɩ sɩmma nɩ wʋnnana Ŋmɩŋ wɩa die, dama vuodieke mana dɩ wʋnnana ta mɩŋŋɩ pɔgɩlɩ ka ba nan yɩ wa pam a gʋtɩ, ama vuodieke dɩ wʋnnana ta ka mɩŋŋɩ pɔgɩlɩ ha, ba nan tuo bɩta gbaŋ ʋ yilinene dɩ ʋ yalla wa a nyɩŋ ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Womi Yisa nuŋ aŋaŋ ʋ nɩmballɩ die dɩ keŋ, ama die ba ka bɩagɩ a gbigi wo dama vuosi die dala mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Vuoŋ wʋnyɩ die dɩ balɩ a yɩ Yisa dɩ, “Fʋ naa aŋaŋ fʋ nɩmballɩ zie yeŋ me ta yaala ba ye fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yisa die dɩ balɩ a yɩ ba mana dɩ, “Manɩŋ n naa aŋaŋ n nɩmballɩ yine vuodiekemba dɩ wʋnnana Ŋmɩŋ wɩaha ta dɩ ha.” ");
INSERT INTO kma_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Daaŋ kaanɩ Yisa aŋaŋ kʋaŋandɩɩsɩrɩba die dɩ juu haarɩŋ sʋŋ, die ʋ balɩ a yɩ ba dɩ, “Nɩ vaa tɩ jʋalɩ ga gbagɩrɩ mi wo gaarɩ.” Die wɩa die ba piili sieŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Die ba benne haarɩkʋ sʋŋ a gara Yisa die dɩ gʋʋra. Ta bʋlɔgɩsɩkpeŋkpɩɩŋ die dɩ keŋ bʋnyɩ a nɩga gbagɩrɩ ma, die haarɩkʋ dɩ yaala ka suuli aŋaŋ nyaaŋ, die ba bie wʋbɩaŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ta die ʋ kʋaŋandɩɩsɩrɩba dɩ keŋ a sʋgɩrɩ wa a baarɩ dɩ, “Jakʋʋŋ, jakʋʋŋ tɩ bie kuŋ me.” Yisa die dɩ hagɩ a natɩ bʋlɔgɩsɩbʋ aŋaŋ nyaaŋ poŋŋikiri a mana die dɩ fɩalɩ sɔmm. ");
INSERT INTO kma_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Womi die ʋ balɩ yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ ka yi mɩŋ yada?” Ta ŋmaamɩŋ die dɩ yigi be, ka bɩ yi be mamachi ba pɩasa taŋ dɩ, “Manɩa wʋnna? Ta nata bʋlɔgɩsɩŋ aŋaŋ nyaaŋ ta a tuose ʋ nʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ta die ba keŋ tʋgɩ Gerasa tɩŋ ma a zie ta vaa Galili tɩŋ ba kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Die Yisa die dɩ kenne nyɩŋ haarɩkʋ ma wa, ta Gerasa daa wʋnyɩ die jɩmbɩatɩ dɩ yalla wa dɩ keŋ tuoli wo. Die ʋ beri wo die a yʋasɩ ta ka yeegi garɩŋ yaa dʋa tigiŋ me ama die ʋ bie wo jigidieke ba guunene vuosi haagɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Saŋŋa dieke ʋ yene Yisa wa die ʋ faasɩ keesi a nan ʋ nɩŋŋa a faasɩ nata aŋaŋ lɔlɩkpɩɩŋ dɩ, “Yisa, Nabidie Ŋmɩŋ dieke dɩ benne arɩzanna ma Bʋa, bɩa fʋ yaala n jigiŋ? N jʋʋsa fʋ da keŋ a datɩ n tɩbɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Die ʋ balɩ wa naa dama Yisa die yɩ wa jɩmbɩatɩ nʋaŋ dɩ a nyɩŋ ʋ ma. Die saŋŋa pam die a ŋaaŋ mugise wo mɩŋ aŋaŋ ba ŋaana a bɔbɩ wa aŋaŋ chɔrɩma ʋ nagɩsɩ aŋaŋ nuusi mana yɔrɩ, jɩmbɩatɩtɩ ŋaaŋ vaa ʋ kpaa ha mɩŋ ta nagɩ wa juu haagɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yisa die dɩ pɩasɩ daa wa dɩ, “Fʋ saaŋ?” Die ʋ baarɩ, “N saaŋ yine ‘Dala’ ” ka chɩaŋ yine jɩmbɩatɩ pam die bie ʋ ma. ");
INSERT INTO kma_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Womi jɩmbɩatɩ die dɩ jʋʋsa wa aŋaŋ nɩŋŋmɩna dɩ ʋ da vaa a ga juu vɔrɩgoli me. ");
INSERT INTO kma_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Die perukusi pam die benne kunkogiŋ lʋgɩŋ a die; ta jɩmbɩatɩtɩ die dɩ jʋʋsɩ Yisa dɩ ʋ vaa a ga juu perukusisi, die ʋ yɩ he sieŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Die wɩa jɩmbɩatɩ die dɩ nyɩŋ daa wa ma a ga juu perukusisi mana, die a mana die dɩ chɩgɩ daagɩ kunkogiri lʋgɩŋ a sʋʋŋ ga nan mʋgɩkpɩɩrɩ ma nyaabʋ die dɩ dii he. ");
INSERT INTO kma_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Die vuodiekemba die dɩ daansɩnana perukusisi die dɩ yene wudieke dɩ yine wo die ba chɩgɩ ga tɩka sʋŋ aŋaŋ kʋatɩ ma a mʋʋlɩ wɩarɩ. ");
INSERT INTO kma_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Die vuosi die dɩ nyɩŋ a ga dɩ ba ye wudieke dɩ yine wo. Die ba keŋ Yisa jigiŋ a ye daa wa ʋ vʋarɩna jɩmbɩatɩ ʋ ma wa ʋ jigiŋ ʋ yeegi jayeekiŋ ta ʋ sikpeŋ dɩ mɩŋŋɩ a tʋma, ŋmaamɩŋ die dɩ yigi ba mana. ");
INSERT INTO kma_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vuodiekemba mana die dɩ yene Yisa dɩ gbaanna daa wa die wo die ba balɩ vuosisi. ");
INSERT INTO kma_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Die wɩa vuodiekemba mana die dɩ benne Gerasa tɩŋ ma die dɩ keŋ Yisa jigiŋ a jʋʋsɩ wa dɩ ʋ nyɩŋ ba tɩka ma, dama ŋmaamɩŋ die faasɩna a yigi be mɩŋ. Die wɩa Yisa die dɩ juu haarɩkʋ dɩ ʋ ga; ");
INSERT INTO kma_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","mi daa dieke die ʋ gbaanna wa die dɩ jʋʋsɩ wa dɩ ʋ vaa ʋ dɩa ʋ kʋaŋ, ama Yisa die dɩ balɩ wa dɩ, ");
INSERT INTO kma_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Yiŋŋi kuli fʋ tigiŋ a ga mʋʋlɩ tʋnkpɩɩŋ dieke Ŋmɩŋ dɩ yine a yɩ fʋ.” Die wɩa daa wa die dɩ ga tɩka sʋŋ mana a balla Yisa die dɩ yine wudieke mana a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Die Yisa dɩ wana a yiŋŋi a ga gbagɩrɩ mi wo chaakʋ, kpɩkpaaŋ die dɩ tuoli wo aŋaŋ sʋgɩfɩalɩŋ a yi wo aŋsɩa dama die ba mana die chɩɩsa wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Womi daa wʋnyɩ ba wasɩnana Jaarusi dɩ keŋ tʋgɩ, die ʋ yiwo Ŋmɩŋ jɩamɩŋ juoku jakʋʋŋ. Die ʋ keŋ gbirigi Yisa nɩŋŋa a jʋʋsɩ wa dɩ ʋ keŋ wʋnɩŋ ʋ tigiŋ, ");
INSERT INTO kma_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","dama die ʋ bʋabalɩmɩŋ die dɩ yine havʋʋbiŋ ta yi bɩna baŋ aŋaŋ ale die yʋagɩna a gbigi kuŋ. Die Yisa die dɩ ganana wa, kpɩkpaaŋ die dɩ giliŋ wo jigiŋ mana. ");
INSERT INTO kma_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kpɩkpaakʋ sʋŋ hɔgʋ wʋnyɩ die benne ʋ nyɩŋgbanɩŋ dɩ nyɩna zɩŋ dene bɩna baŋ aŋaŋ ale, die ʋ nagɩ ʋ yalla jadieke mana mana a yɩ gbɩgbaantɩŋ, ama die ba wʋnyɩ mana ka bɩagɩ a gbaaŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Die ʋ daagɩ kpɩkpaakʋ sʋŋ a keŋ Yisa kʋaŋ a gbɩ ʋ jayeekiri kʋanʋaŋ, lele womi die ʋ zɩmbʋ dɩ gobi bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mi die Yisa dɩ pɩasɩ dɩ, “Mɩnɩa gbɩna mɩŋ?” Die ba mana die dɩ chiisi, ta Piita die dɩ baarɩ dɩ, “Jakʋʋŋ, kpɩkpaakʋ giliŋ fʋ mɩŋ ta dɩ dɩa chʋa fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama ta Yisa die dɩ baarɩ dɩ, “Vuoŋ gbɩ mɩŋ mɩŋ dama n sɩba dɩ hagɩrɩŋ nyɩŋ n ma.” ");
INSERT INTO kma_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Die hɔgʋ wa die dɩ mɩŋŋɩna dɩ ʋ kaaŋ bɩagɩ a lɔbɩrɩ wa, die wɩa die ʋ keŋ a cheele ta gbigiri Yisa nɩŋŋa. Mi die ʋ balɩ Yisa vuoŋ mana nine me wudieke wɩa ʋ gbɩna wa wa ta ye gbaamɩŋ die bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yisa dɩ balɩ a yɩ wa dɩ, “N lɩa, fʋ yada gbaanna fʋ. Gamma aŋaŋ sʋgɩdʋagɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Die Yisa dɩ yene ko bala wɩaha gie, vuoŋ wʋnyɩ die dɩ nyɩŋ jakʋʋrɩ tigiŋ a keŋ a balɩ wa dɩ, “Fʋ lɩa wa kpiye; da mugisi Dɩdagɩrʋ wa bɩbra.” ");
INSERT INTO kma_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ama Yisa die dɩ wʋŋ ta balɩ yɩ Jaarusi dɩ, “Da vaa ŋmaamɩŋ yalla fʋ; fʋnɩŋ ko yi yada ta havʋʋbike nan ye alaafɩa.” ");
INSERT INTO kma_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yisa die dɩ keŋ a juu tigiri me, die ʋ ka yi vuoŋ dɩ dɩ ʋ kʋaŋ sie Piita, aŋaŋ Jɔɔn aŋaŋ Jemisi aŋaŋ havʋʋbike chɔɔŋ aŋaŋ ʋ nuŋ nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vuoŋ mana mi die dɩ kʋma ta die zɔɔlɩŋ bʋa wa wɩa. Yisa die dɩ balɩ ba dɩ, “Nɩ da kʋmma, bʋa wa ka kpiye ʋ ko gʋʋra mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Die vuosisi die dɩ laa wa dama die ba sɩba a baarɩ dɩ bʋa wa kpiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ama Yisa die dɩ yigi ʋ nuuŋ me ta baarɩ dɩ, “N, bʋa hagɩ!” ");
INSERT INTO kma_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Die ʋ yiŋŋi keŋ ʋ mɩsɩ ma ta hagɩ zie bʋnyɩ. Die dɩ yi bʋa wa chɔɔŋ aŋaŋ ʋ nuŋ wo mamachi, Yisa die dɩ balɩ ba dɩ ba yɩ bʋa wa jaaŋ aŋ ʋ dii. Ama Yisa die dɩ kpaaŋ ba dɩ ba da keŋ balɩ vuoŋ wudieke dɩ yine wo. ");
INSERT INTO kma_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ka kʋaŋ chaaŋ Yisa die dɩ wa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a lagɩsɩ ʋ jigiŋ ta yɩ ba hagɩrɩŋ aŋaŋ yiko dɩ ba vʋarɩma jɩmbɩatɩ ta gbaama yʋagɩtɩ vuosi me. ");
INSERT INTO kma_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ta die tʋŋ ba dɩ ba ga mʋʋlɩ Ŋmɩŋ naarɩ wɩaha ta gbaaŋ yʋagɩtieliŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta die balɩ ba dɩ, “Nɩ da nagɩ jaaŋ mana a ga nɩ sieku; nɩ da nagɩ daaŋgbanɩŋ yaa bʋlɔgɩŋ yaa nyindiike yaa ligire aŋaŋ jayeekiŋ a gʋtɩ nɩ wone yeegi jadieke wo me. ");
INSERT INTO kma_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɩ keŋ a juu tigidieke mana nɩ bemme mi a ga tʋgɩ saŋŋa dieke nɩ bala nɩ nyɩŋ tɩka ma. ");
INSERT INTO kma_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jigidieke mana ba kana ka tuo nɩ aŋaŋ sʋgɩfɩalɩŋ, saŋŋa dieke nɩ keŋ nyɩnna tɩka ma nɩ pɩsɩ nɩ nagɩsɩ tankɔlɩŋ a taaŋ mi aŋ ka dagɩ sɩba ba yi chʋʋsɩ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Die wɩa ʋ kʋaŋandɩɩsɩrɩba die dɩ nyɩŋ a dɩ dɩa tɩŋkpaŋŋɩsɩ mana a mʋʋla Ŋmɩŋ wʋvɩɩnaha ta gbaama vuosi jige mana. ");
INSERT INTO kma_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Die Herodi vuodieke die dɩ yine Galili tɩŋgbaŋka mana naajakʋʋŋ die dɩ wʋŋ wudiekemba mana die dɩ yinene, die a paalɩ mugisi wo dama vuosi bataŋ die baarɩ dɩ Jɔɔn vuodieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ hagɩna kuŋ me, ");
INSERT INTO kma_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bataŋ dɩaŋ dɩ baarɩ dɩ Elaja yiŋŋine a keŋ, ta bataŋ dɩaŋ dɩ baarɩ dɩ Ŋmɩŋ naazʋalɩŋ die dɩ benne kʋrɩŋ ma wa wʋnyɩ yiŋŋine keŋ ʋ mɩsɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ta Herodi die dɩ baarɩ dɩ, “Die n yi ba gobi wo Jɔɔn sikpeŋ ama mɩnɩa yine daa wa gie maŋ wʋmma ʋ wɩa dɩ ʋ yie wɩaha gie?” Die ʋ mɩa dɩ ʋ ye Yisa. ");
INSERT INTO kma_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Die Yisa tʋntʋntɩba die dɩ yiŋŋi a keŋ a balɩ wa wudiekemba mana die ba yine. Die ʋ nagɩ ba, ba ga tɩŋ kaanɩ ba wasɩnana Befisada ba nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ama kpɩkpaakʋ die dɩ wʋŋ ta tʋʋ ʋ poli. Die ʋ yene be ba kienene die ʋ tuo be aŋaŋ sʋgɩfɩalɩŋ, ta dagɩ ba Ŋmɩŋ wɩa yaa gamma ʋ naarɩ ma ta gbaaŋ vuodiekemba die dɩ yaalala gbaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Saŋŋa dieke ŋmɩnnɩ die dɩ fɩalɩnana wa, ʋ tʋntʋntɩba baŋ aŋaŋ bale wo die dɩ keŋ ʋ jigiŋ a baarɩ dɩ, “Vaa vuosisi ga tɩgɩsɩ aŋaŋ tɩŋkpaŋŋɩsɩ diekemba dɩ gbine amʋ ba nan yallɩ nyindiike aŋaŋ jigidʋagɩsɩkɩŋ, dama giena yiwo haagɩyeŋ.” ");
INSERT INTO kma_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ama Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Nɩnɩŋ nɩ gbaŋ gbaŋ nɩ yɩ ba jaaŋ aŋ ba dii.” Die ba yiŋŋi balɩ wa dɩ, “Tɩ yaa wa paanʋ golime anʋ aŋaŋ zaasɩbɩsɩ ale nyɩɩna ma. Fʋnɩŋ yaala tɩ ga da wa nyindiike a yɩ kpɩkpaakʋ gie mana?” ");
INSERT INTO kma_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Die dembisi dieke die dɩ benne mi die yiwo sɩba tuse anʋ.) Yisa die dɩ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ vaa vuosisi puo puo a kala baŋɩsɩ-nʋ nʋ.” ");
INSERT INTO kma_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ yi die ta vaa ba sʋʋŋ kalɩ. ");
INSERT INTO kma_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ta ʋ nagɩ paanʋsɩ golime anʋ wa aŋaŋ zaasɩbɩsɩ ale wo, a daansɩ ŋmɩŋsikpeŋ ta pagɩ Ŋmɩŋ ta yi he gbieri gbieri a nagɩ ha yɩ ʋ kʋaŋandɩɩsɩrɩba ba nagɩ tɩa tɩa vuosisi. ");
INSERT INTO kma_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Die ba mana dɩ dii a chagɩ ta tɩalɩ tɩalɩ, ʋ kʋaŋandɩɩsɩrɩba die dɩ vaarɩ nyɩŋ tɩalɩkaha a suuli kparɩsɩ baŋ ale. ");
INSERT INTO kma_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Saŋŋa kaanɩ Yisa die dɩ jʋʋsa Ŋmɩŋ ʋ nyɩɩna ma, ta ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ ʋ jigiŋ, die ʋ pɩasɩ ba dɩ, “Mɩnɩa kpɩkpaakʋ dɩ baa n yiye?” ");
INSERT INTO kma_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Die ba yiŋŋi balɩ wa dɩ, “Bataŋ baarɩ fʋ yiwo Jɔɔn vuodieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ, bataŋ dɩaŋ dɩ baarɩ dɩ fʋ yiwo Elaja, ta bataŋ dɩaŋ dɩ baarɩ, Ŋmɩŋ naazʋalɩba wʋnyɩ die dɩ benne kʋrɩŋ ma wa yiŋŋine a keŋ ʋ mɩsɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Die ʋ pɩasɩ ba dɩ, “Ta nɩnɩŋ nɩŋ mɩnɩa nɩ baarɩ n yiye?” Piita dɩ yiŋŋi balɩ wa dɩ, “Fʋnɩŋ fʋ yine Ŋmɩŋ vuovʋarɩkɩŋ, Masia wa.” ");
INSERT INTO kma_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mi Yisa die dɩ kpaaŋ ba aŋaŋ nɩŋŋmɩna dɩ ba da keŋ balɩ vuoŋ wɩarɩ gie, ");
INSERT INTO kma_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ta die bɩ a baarɩ dɩ, “Sie manɩŋ vuotaŋ Bʋa wa dii wahala pam, ta tɩka nyɩŋkʋra aŋaŋ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Ŋmɩŋ tigiri mi mɩra dɩdagɩrɩba dɩ keŋ zeti mɩŋ, a bɩ kʋʋ mɩŋ ama daraa ataa daraaŋ n nan hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Die ʋ balɩ yɩ ba mana mana dɩ, “Vuodieke mana dɩ a keŋ yaala ʋ dɩa n kʋaŋ sie ʋ daaŋ ʋ gbaŋ gbaŋ ʋ wɩa, ta viigi ʋ dagarɩkɩrɩ daaŋ mana a dɩa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ama vuodieke nɩŋ mana dɩ yaala ʋ gbatɩ ʋ gbaŋ gbaŋ ʋ mɩsɩ nan waarɩ ka, ama vuodieke nɩŋ mana dɩ waarɩna ʋ mɩsɩ n wɩa nan ye ke. ");
INSERT INTO kma_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bɩa vuoŋ dɩ baa ʋ ye ʋ a keŋ a ye dʋnɩa mana nyinti ama ta waarɩ ʋ gbaŋ gbaŋ ʋ mɩsɩ? ");
INSERT INTO kma_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vuodieke dɩ a keŋ chɩga viivi a ka balɩ manɩŋ aŋaŋ n dagɩkʋ gie vuosi jigiŋ, die nɩŋ manɩŋ vuotaŋ Bʋa maŋ keŋ keŋ aŋaŋ n hagɩrɩŋ aŋaŋ n Chʋa Ŋmɩŋ hagɩrɩŋ aŋaŋ ʋ malakasisi hagɩrɩŋ n nan daaŋ chɩgɩ dɩ tieŋ gbaŋ viivi dɩ n yaa wa a gʋtɩ n vuosi ma. ");
INSERT INTO kma_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wusie maŋ bala nɩ, vuosi bataŋ bie giena ba kaaŋ kpi ntaala ba keŋ ye Ŋmɩŋ naarɩ keniŋ.” ");
INSERT INTO kma_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Die ʋ balla wɩaha gie a kpatɩ wa, a kʋaŋ chaaŋ die dɩ yi daraa anɩɩ, die ʋ nagɩ Piita aŋaŋ Jɔɔn aŋaŋ Jemisi a gʋtɩ ʋ ma a ga jʋalɩ taŋ sikpeŋ dɩ ba jʋʋsɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Die ʋ jʋʋsɩnana Ŋmɩnnɩ ʋ nine chaaŋ die dɩ tarɩgɩ ta ʋ nyiŋyeeke die dɩ faasɩ yɩantɩ ta nyɩgɩsa. ");
INSERT INTO kma_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Womi die dembisi bale die dɩ nyɩŋ mi, Ŋmɩŋ naazʋalɩŋ Mosisi aŋaŋ Elaja ");
INSERT INTO kma_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ta die bala aŋaŋ Yisa yaa gamma ʋ kuŋ wɩa aŋaŋ ʋ bala ʋ kpi die Jerusalemi ma, ta yi Ŋmɩŋ choti. ");
INSERT INTO kma_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ama Piita aŋaŋ ʋ chanchaalɩba die faasɩ gʋʋra mɩŋ, ama die ba hagɩna wa die ba ye chaankpeŋkpɩɩŋ dɩ giline Yisa, ta ba bɩ ye dembisi bale dɩ zene aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Die dembisisi dɩ nyɩnnana Yisa jigiri, Piita die dɩ balɩ a yɩ wa dɩ, “Jakʋʋŋ, dɩ vɩɩna mɩŋ tɩ benne giena. Tɩ nan wʋnsɩ viisi ataa, aŋ kaanɩ yi fʋ jaaŋ, aŋ kaanɩ dɩaŋ yi Mosisi jaaŋ, kaanɩ Elaja dɩaŋ jaaŋ.” Die Piita paalɩ ka sɩba wudieke ʋ balala. ");
INSERT INTO kma_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Die ʋ yene ko bala wɩaha, nɩɩŋmaaŋ die dɩ keŋ a ligi be, ta ŋmaamɩŋ die dɩ yigi be ba benne ka sʋkʋ. ");
INSERT INTO kma_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Die lɔlɩŋ die dɩ nyɩŋ nɩɩŋmaakʋ sʋŋ a baarɩ dɩ, “N Bʋadembiŋ wʋnna, wʋnɩŋ maŋ vʋarɩ, nɩ wʋmma wa.” ");
INSERT INTO kma_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Die lɔlɩkʋ dɩ balɩna a kpatɩ wa, die ba ye Yisa dɩ zene ʋ nyɩɩna ma. Die ʋ kʋaŋandɩɩsɩrɩba die dɩ tarɩ yaa gamma ba yene wudieke wo, ta ka balɩ vuoŋ saŋka mi wudieke ba yene wo. ");
INSERT INTO kma_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Die ka tʋnvʋʋsa Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ keŋ sʋʋŋ tanɩ ma, kpɩkpaaŋ die dɩ tuoli wo. ");
INSERT INTO kma_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mi daa wʋnyɩ die dɩ bie kpɩkpaakʋ ma ta faasɩ wa Yisa dɩ, “Dɩdagɩrʋ! N jʋʋsa fʋ, keŋ daansɩ n dalʋabike gie; dama ʋ yiwo n bʋa balɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jɩmbɩaŋ yalla wa, ka keŋ hagɩ ka ŋaaŋ yi ʋ faasɩ keese ta nagɩ wa a taaŋ tɩŋgbaŋ sɩba kpenkpennantʋ ta fʋnfʋgɩtɩ dɩ nyɩna ʋ nʋaŋ ma, ka mugisi wa mɩŋ ta ka vasa wa a yʋasa. ");
INSERT INTO kma_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Maŋ jʋʋsɩ fʋ kʋaŋandɩɩsɩrɩba dɩ ba vʋarɩ ka ama ba ka bɩagɩ.” ");
INSERT INTO kma_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yisa dɩ yiŋŋi a balɩ ba dɩ, “Nɩnɩŋ lele vuosi gie dɩ wone yada ta bɩ yi vuodiekemba dɩ kana ka dɩa Ŋmɩnnɩ, nɩ yaala n bemme nɩ jigiŋ a ga tʋgɩ saŋŋa bɩa? Nɩ yaala n yaa wa suguru aŋaŋ nɩ a ga tʋgɩ saŋŋa bɩa?” Ta die balɩ a yɩ daa wa dɩ, “Yaa bʋa wa a keŋ giena.” ");
INSERT INTO kma_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Die bʋa wa dɩ kienene wo jɩmbɩakʋ dɩ nagɩ wa a taaŋ tɩŋgbaŋ ta die ʋ cheele. Yisa die dɩ natɩ jɩmbɩakʋ, ta gbaaŋ bʋa wa ta yiŋŋi nagɩ wa yɩ ʋ chɔɔŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Die dɩ yi vuosisi mana mamachi yaa gamma Ŋmɩŋ dɩ dagɩna hagɩrɩŋ dene. Die ʋ yinene wudieke wo dɩ ko yie vuosisi mamachi, saŋka mi die ʋ balɩ yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nɩ yuori nɩ tɩba a wʋŋ vɩɩnɩŋ wudieke n bala n balɩ nɩ naa; ba nan daansɩ nagɩ manɩŋ vuota Bʋa a nagɩ yi vuota nuusi me.” ");
INSERT INTO kma_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama ta die ba ka sɩba ka wɩɩrɩ chɩaŋ, dama Ŋmɩŋ die ligi ba yɩaŋ dɩ ba da sɩmma ka chɩaŋ; ta die ŋmaamɩŋ dɩ bɩ yalla ba dɩ ba pɩasɩ wa ka chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ka kʋaŋ chaaŋ die ʋ kʋaŋandɩɩsɩrɩba dɩ nɩga nɩnhagɩrɩŋ yaa gamma ba jabɩa yine vuokpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ta Yisa die dɩ mɩŋŋɩ ba sʋŋanyile, die wɩa die ʋ nagɩ bʋabiŋ a vaa ʋ keŋ zie ʋ jigiŋ, ");
INSERT INTO kma_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ta balɩ ba dɩ, “Vuodieke mana dɩ a keŋ a mɩŋŋɩ a tuo bʋa wa gie n saaŋ ma, ʋ mɩŋŋɩ tuo mɩŋ mɩŋ; ta fʋ mɩŋŋɩ tuo mɩŋ, mɩŋŋɩ tuo wo vuodieke dɩ tʋnna mɩŋ wa. Ama vuodieke dɩ nagɩna ʋ gbaŋ a bɩrɩŋ bʋabiŋ nɩ mana sʋŋ wʋnɩŋ ʋ yine vuokpɩɩŋ a tɩaŋ nɩ mana.” ");
INSERT INTO kma_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔɔn die dɩ balɩ a yɩ Yisa dɩ, “Jakʋʋŋ, die tɩ ye wo vuoŋ dɩ yagɩnana jɩmbɩatɩ vuoŋ ma fʋ saaŋ ma, die tɩ balɩ wa dɩ ʋ vaa dama die ʋ ka yi tɩ wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yisa die dɩ balɩ yɩ ba dɩ, “Nɩ da kagɩma wa, dama vuodieke mana dɩ kana a waga nɩ, ʋ gʋtɩ wa nɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Die saŋka dɩ gbigine dɩ Yisa yiŋŋi a jʋalɩ arɩzanna wa, die ʋ dii sikimiŋ a nyɩŋ a gara Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Die ʋ woliŋ a tʋŋ tʋntʋntɩŋ dɩ ba ga Samaria vuosi tɩŋkpaŋŋɩ kaanɩ ma a yi jaaŋ mana siri a zieŋ wo, ");
INSERT INTO kma_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ama tɩka vuosi die ka saagɩ ʋ keŋku dama die ba sɩba dɩ ʋ gara Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ta ʋ kʋaŋandɩɩsɩrɩba Jemisi aŋaŋ Jɔɔn die dɩ yene naa wa die ba pɩasɩ wa dɩ, “Tɩ Yɔmʋtieŋ, fʋ yaala tɩ yi boliŋ nyɩŋ ŋmɩŋsikpeŋ a keŋ dii be?” ");
INSERT INTO kma_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ama ta Yisa die dɩ yiŋŋi a daansɩ ba ta galɩŋ ba, ");
INSERT INTO kma_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ta die ba ga tɩŋkpaŋŋɩ gaaŋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Die ba ganana wa daa wʋnyɩ die dɩ balɩ a yɩ Yisa dɩ, “N nan dɩ dɩ fʋ a ga jigidieke mana fʋ ganana.” ");
INSERT INTO kma_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Gbaanchʋra yaa vɔrɩtɩ a juo, nembisi dɩaŋ dɩ yaa tʋʋsɩ a juo ama manɩŋ vuota Bʋa wo jigidʋagɩsɩkɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Die ʋ bɩ balɩ yɩ daa wʋnyɩ dɩaŋ dɩ, “Dɩa mɩŋ.” Ama daa wa die dɩ baarɩ dɩ, “N Yɔmʋtieŋ, vaa n woliŋ, a ga a ga guu n chʋa.” ");
INSERT INTO kma_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ta Yisa die dɩ yiŋŋi balɩ wa dɩ, “Vaa kunti guu ba gbaŋ gbaŋ ba kunti. Fʋnɩŋ gamma a ga mʋʋlɩ yɩ vuosi Ŋmɩŋ naarɩ wɩa.” ");
INSERT INTO kma_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ta wʋnyɩ dɩaŋ dɩ baarɩ dɩ, “N Yɔmʋtieŋ, n nan dɩdɩ fʋ ama vaa n woliŋ ga tigiŋ a taaŋ n deŋ.” ");
INSERT INTO kma_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Die Yisa dɩ yiŋŋi a balɩ wa dɩ, “Vuoŋ kaaŋ bɩagɩ a pɔgɩlɩ naakʋʋŋ a kʋa ta yiŋŋi daansa ʋ kʋaŋ. Dɩɩ yi vuoŋ dɩ daansa die, ʋ ka mʋ aŋaŋ Ŋmɩŋ naarɩ tʋʋma tʋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Naa kʋaŋ chaaŋ die Yisa die dɩ vʋarɩ dembisi baŋɩsɩ-yʋpɔyɩ aŋaŋ bale ta tʋŋ ba ba balele dɩ ba woliŋ ga tɩgɩdieke aŋaŋ jigidieke ʋ gbaŋ gbaŋ ʋ yinene siri dɩ ʋ ga. ");
INSERT INTO kma_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Die ʋ balɩ a yɩ ba dɩ, “Zaaha biye mɩŋ ta dala ama zaagobiribe ka dala. Die wɩa nɩ jʋʋsɩ zaaha tieŋ aŋ ʋ gʋtɩ tʋntʋntɩŋ aŋ ba keŋ gobihe. ");
INSERT INTO kma_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɩ gamma! N tʋma nɩ, nɩ nan dɩ sɩɩ sɩba yiibisi dɩ benne gbaanchʋra sʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ama nɩ da keŋ a nagɩ ligire yaa bʋlɔgɩŋ yaa nɩɩra, ta nɩ da bɩ chʋʋsɩma saŋŋa a waasɩma vuosi sieŋ me. ");
INSERT INTO kma_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ama tigidieke nɩŋ mana nɩ keŋ a juu nɩ woliŋ a baarɩ, ‘Sʋgɩdʋagɩŋ bemme tigiri gie vuosi me.’ ");
INSERT INTO kma_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dɩɩ yi ta tigiŋ tieŋ wo dɩ yaala sʋgɩdʋagɩŋ, ʋ nan mɩŋŋɩ tuo nɩ. Ama ʋ ka yi die nɩ sʋgɩdʋagɩkʋ nan yiŋŋi keŋ nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dɩɩ yi nɩ keŋ juu tigiri me, nɩ bemme mi ta dime ta nyume jadieke mana ba nagɩna yɩ nɩ. Dama tʋntʋntʋ mana mʋ ʋ tuo ʋ tune. Nɩ da tarɩgɩma nɩ tigiberisikiŋ. ");
INSERT INTO kma_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dɩɩ yi nɩ ga juu tɩŋ diekemba mana ba mɩŋŋɩ tuo nɩ, nɩ dii jadieke mana ba keŋ nagɩ yɩ nɩ, ");
INSERT INTO kma_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ta gbaaŋ yʋagɩtieliŋ mana dɩ benne mi, ta balɩ yɩ ba dɩ, ‘Ŋmɩŋ naarɩ keŋ a gbigi nɩ mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama dɩɩ yi nɩ keŋ juu tɩŋ dieke ba ka mɩŋŋɩ tuo nɩ, nɩ nyɩŋ a ga ba siekpɩɩma ma a balɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tɩ nagɩsɩ dɩ yigine tankɔlɩ dieke nɩ tɩka gie me tɩ pɩsɩha a taaŋ ta taana nɩ. Ama nɩ sɩmma wɩɩrɩ gie, dɩ Ŋmɩŋ naarɩ wɔŋ keŋ a gbigi nɩ mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","N bala nɩ dɩ sarɩya diile daaŋ, tɩka mi vuosi tɩbɩdatɩŋ nan tɩaŋ Sodomi tɩŋ vuosi tɩbɩdatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Wʋbɩaŋ bie nɩnɩŋ Korazini vuosi ma; wʋbɩaŋ bie nɩnɩŋ Befisada vuosi mama; dama mamachi wudieke n yine nɩ tɩgɩsɩ ma wa, maŋ tɩŋ a yi die Taya aŋaŋ Sidoni ma ma, vuodiekemba dɩ benne mi wo tɩŋ nan vaa ba tʋmbɩatɩ a yʋasɩ ta nagɩ vaatɩ aŋaŋ tanyeeliŋ a bʋʋlɩ ba gbaŋ aŋ die dagɩ sɩba ba chɩgɩ nyɩŋ ba tʋmbɩatɩ ma ma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Daa dieke Ŋmɩŋ dɩ baaŋ nan dii vuosi sarɩya, nɩ tɩbɩdatɩŋ nan faasɩ dala pam a tɩaŋ Taya aŋaŋ Sidoni vuosi sarɩya. ");
INSERT INTO kma_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta nɩnɩŋ Kapenɔmi vuosi, Ŋmɩŋ nan kɔtɩ nɩ ŋmɩŋsikpeŋ? Aayɩ, ʋ nan vigi nɩ a taaŋ kunti jigiberisikiŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Saŋka mi die ʋ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Vuodieke mana dɩ wʋnnana nɩ balɩkʋ, ʋ wʋŋ wa manɩŋ; ama vuodieke dɩ keŋ zeti nɩ, zeti wo manɩŋ; ta vuodieke dɩaŋ dɩ zetine manɩŋ zeti wo Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Die dembisi baŋɩsɩ-yʋpɔyɩ aŋaŋ bale wo die dɩ yiŋŋi keŋ Yisa jigiŋ aŋaŋ sʋgɩfɩalɩŋ ta balɩ wa dɩ, “Tɩ Yɔmʋtieŋ, fʋ saaŋ hagɩrɩŋ ma jɩmbɩatɩ saagɩ wa tɩ nʋa.” ");
INSERT INTO kma_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ta ʋ yiŋŋi balɩ ba dɩ, “N ye wo Sitaani dɩ nyɩna ŋmɩŋsikpeŋ a keŋ nan sɩba nɩɩnyɩgɩsɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nɩ wʋmma, n yi nɩ wa yiko dɩ nɩ chʋmma nyinvuuke aŋaŋ chɩakʋrɩtɩ ma ta bɩ nyaŋŋɩ nɩ dataaŋ Sitaani hagɩrɩŋ mana; ta wɩɩŋ kaaŋ yi nɩ. ");
INSERT INTO kma_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nɩ da yallɩma sʋgɩfɩalɩŋ dɩ jɩmbɩatɩ saagɩ nɩ nʋa nyɩɩna ma, ama nɩ yallɩma sʋgɩfɩalɩŋ dama ba maagɩ nɩ saara arɩzanna ma.” ");
INSERT INTO kma_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kanɩŋ saŋka mi Ŋmɩŋ Halɩkasɩka die dɩ yɩ Yisa sʋgɩfɩalɩŋ ʋ baarɩ dɩ, “N Chʋa Ŋmɩŋ, vuodieke dɩ yine ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie tieŋ, n bɩra fʋ, dama fʋnɩŋ lɔbɩrɩ wɩaha gie yɩantieliŋ aŋaŋ sɩsɩbɩrɩŋ jigiŋ ama ta yuori he a yɩ ballɩbɩsɩ; dama die fʋ tʋma fʋ tʋʋma a yie fʋ nansɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ta Yisa die dɩ bɩ baarɩ dɩ, “N Chʋa Ŋmɩŋ nagɩ wa jaaŋ mana a yɩ mɩŋ; vuoŋ ka sɩba manɩŋ Ŋmɩŋ Bʋa wa sie n Chɔɔŋ wa Ŋmɩŋ, vuoŋ dɩaŋ ka sɩba n Chɔɔŋ wa Ŋmɩŋ sie manɩŋ Ŋmɩŋ Bʋa wa aŋaŋ vuodiekemba n yaala n nagɩ wa a dagɩ.” ");
INSERT INTO kma_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Womi Yisa die yiŋŋi a tuoli ʋ kʋaŋandɩɩsɩrɩba ta balɩ yɩ ba nyɩɩna ma dɩ, “Nɩ yaa sikpeŋ nansɩŋ dama nɩ nine ye wudieke nɩ yesinene wo! ");
INSERT INTO kma_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N bala nɩ dɩ Ŋmɩŋ naazʋalɩŋ pam aŋaŋ naalɩŋ pam die yaala ba ye wudieke nɩ yesinene wo, ama die ba ka ye ke, ta die bɩ yaala ba wʋŋ wudieke nɩ wʋnnana wa, ama die ba ka wʋŋ ka.” ");
INSERT INTO kma_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Die daaŋ kaanɩ mɩraha dɩdagɩrɩba wʋnyɩ dɩ keŋ dɩ ʋ magɩsɩ Yisa ta pɩasɩ wa dɩ, “Dɩdagɩrʋ, lalɩa maŋ baa n yi a ye miivoli dieke dɩ wone kpatɩŋ?” ");
INSERT INTO kma_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yisa die dɩ yiŋŋi a pɩasɩ wa dɩ, “Lalɩa dɩ maagɩ Ŋmɩŋ gbaŋkʋ ma? Lalɩa fʋ sɩba a chɩaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Daa wa dɩ yiŋŋi a baarɩ dɩ, “Yaalɩma fʋ Yɔmʋtieŋ Nabidie Ŋmɩŋ aŋaŋ fʋ sʋŋ mana aŋaŋ fʋ haalɩŋ mana aŋaŋ fʋ hagɩrɩŋ mana aŋaŋ fʋ sʋŋanyile mana, ta bɩ chome fʋ chanchaaŋ sɩba fʋ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yisa die dɩ yiŋŋi balɩ wa dɩ, “Mɩŋŋɩ balɩ mɩŋ, yime naa ta nan ye miivoli dieke dɩ wone kpatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama die mɩraha dɩdagɩrʋ wa dɩ bɩ yaala ʋ dagɩ dɩ ʋ yaa wusie, die wɩa die ʋ bɩ pɩasɩ Yisa dɩ, “Mɩnɩa yine n chanchaaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Daa wʋnyɩ die nyɩnna Jerusalemi a sʋʋŋ gara Jeriko; die gbɩgbatɩrɩŋ die dɩ yigi wo a wuuri ʋ nyinti ta nɩgɩ wa ʋ ga gbigi kuŋ ba va wa taaŋ ta chʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka kʋaŋ chaaŋ die Ŋmɩŋ jɩamɩŋ nɩŋŋandɩɩsɩrʋ wʋnyɩ die dɩ sʋʋŋ gara sieku me ta keŋ ye daa wa dɩ dʋana sieku me, die ʋ gʋa daagɩ sieku lʋgɩŋ a chʋŋ ga. ");
INSERT INTO kma_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Die gbaŋ gbaŋ Liiva vuoŋ die dɩ sʋʋŋ gara mi a ye daa wa dɩ dʋana ʋ gʋa daagɩ sieku lʋgɩŋ a chʋŋ ga. ");
INSERT INTO kma_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ama ta Samaria vuoŋ die dɩ chʋŋ sieku me a keŋ ye wo, zɔɔlɩŋ die dɩ yigi wo. ");
INSERT INTO kma_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Die ʋ ga ʋ jigiŋ a siti tɩɩŋ a yi ʋ kʋjagaha ta bɔbɩha aŋaŋ garɩchɔɔtɩ. Ta die a nagɩ wa a kalɩŋ ʋ gbaŋ gbaŋ ʋ bʋnɩŋ ma a yaa wa a ga chaanɩŋ juone me a daansɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Die tʋŋ dɩ vʋnna die ʋ nagɩ ligire a yɩ vuodieke die dɩ jɩɩnana jigiri ta balɩ wa dɩ, ‘Daansɩma wa, ta maŋ keŋ yiŋŋi kieŋ n nan tuŋ fʋ ligire dieke fʋ nagɩna a gʋtɩ daansɩ wa.’ ” ");
INSERT INTO kma_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisa die dɩ balla naa a kpatɩ wa, ʋ pɩasɩ wa dɩ, “Dembisi bataa wa gie ba jabɩa fʋ yile dɩ ʋ dagɩ sɩba vuodieke gbɩgbatɩrɩba dɩ gbatɩna ʋ nyintiti yiwo ʋ chanchaaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Die ʋ baarɩ dɩ, “Vuodieke dɩ chɩgɩna wa zɔɔlɩbʋ.” Ta Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Die nɩŋ gamma a ga yi die gbaŋ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka kʋaŋ chaaŋ Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ gara ba sieŋ a ga tʋgɩ tɩŋkpaŋŋɩ kaanɩ, ta die hɔgʋ wʋnyɩ ba wasɩnana Maata die tuo Yisa aŋaŋ sʋgɩfɩalɩŋ ʋ tigiŋ me. ");
INSERT INTO kma_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Die ʋ yallɩ wa ʋ taa ba wasa wa Meri; die Meri die dɩ sʋʋŋ kalɩ Yisa nɩŋŋa a wʋmma wudieke ʋ balala wa. ");
INSERT INTO kma_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ama Maata die dɩ mɩa aŋaŋ chaantɩ, ta die a keŋ balɩ Yisa dɩ “N Yɔmʋtieŋ, n mɩa mɩŋ aŋaŋ chaantɩ n nyɩɩna ma, ta ntaa wa dɩ ka suŋŋe mɩŋ, fʋ baga wo ka ma? Balɩ wa dɩ ʋ keŋ suŋŋi mɩŋ!” ");
INSERT INTO kma_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ama tɩ Yɔmʋtieŋ Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Maata n sɩba a baarɩ mɩa mɩŋ aŋaŋ nyinti pam, a mugise fʋ ta chʋʋsa fʋ sʋŋ, ");
INSERT INTO kma_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ama wʋbalɩmɩŋ nyɩɩna mʋna fʋ yaalɩ; Meri nɩŋ vʋarɩ wa wudieke dɩ vɩɩna, ta vuoŋ kaaŋ tuo ke a nyɩŋ ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Daaŋ kaanɩ Yisa die dɩ ga jigiŋ kaanɩ a jʋʋsa Ŋmɩŋ, die ʋ kpatɩna wa ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ die dɩ balɩ wa dɩ, “Tɩ Yɔmʋtieŋ dagɩ tɩ tɩ bala tɩ jʋʋsɩma Ŋmɩŋ dene sɩba Jɔɔn die dɩ dagɩna ʋ kʋaŋandɩɩsɩrɩba die wo.” ");
INSERT INTO kma_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yisa die dɩ balɩ a yɩ ba dɩ, “Naa mʋna dɩ nɩ jʋʋsɩma Ŋmɩŋ; Tɩ Chʋa Ŋmɩŋ: Vaa aŋ ba yɩ fʋ saaŋ kasɩka jɩlɩma; Vaa aŋ fʋ naarɩ keŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yɩ tɩ daaŋ mana nyindiike dieke tɩ yaalala. ");
INSERT INTO kma_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nagɩ tɩ tʋmbɩatɩ a chaa tɩ, sɩba tɩ nagɩna vuodiekemba dɩ tʋnna tɩ tʋmbɩatɩ a chaa ba wa. Da keŋ vaa tɩ juu magɩsɩ dieke dɩ hagɩrɩna ma.” ");
INSERT INTO kma_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Saŋka mi Yisa die dɩ balɩ ba dɩ, “Dɩɩ yi ta nɩ wʋnyɩ yallɩ zʋa ta ga ʋ jigiŋ tanseese, a baarɩ dɩ, ‘N zʋa, paŋŋɩ mɩŋ paanʋ golime ataa, ");
INSERT INTO kma_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","dama chaanʋ wʋnyɩ kenne n jigiŋ maŋ wo jadiikiŋ n baaŋ nagɩ a yɩ wa.’ ");
INSERT INTO kma_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ta dɩɩ yi fʋ zʋa wa dɩ bie juoku sʋŋ ta yiŋŋi balɩ fʋ dɩ, ‘Da mugisime mɩŋ! N wɔŋ kparɩ sanʋarɩ mɩŋ ta manɩŋ aŋaŋ n ballɩ wɔŋ gʋʋra mɩŋ; N kaaŋ bɩagɩ a hagɩ a yɩ fʋ jaaŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N bala nɩ dɩɩ yi daa wa dɩ ka hagɩya a yɩ fʋ jaaŋ nɩ yine zʋalɩŋ wɩa, ama dɩɩ yi fʋ ka chɩga viivi ta jʋʋsa wa ʋ nan hagɩ a yɩ fʋ jadieke mana fʋ yaalala fʋ mugisinene wo wɩa. ");
INSERT INTO kma_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Die wɩa n bala nɩ, nɩ jʋʋsɩma Ŋmɩŋ, ta ʋ nan nagɩ a yɩ nɩ; nɩ daansɩma ta nɩ nan ye; nɩ kpaasɩma gbɩabɩkʋ ta ʋ nan yuori a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dama vuodieke mana dɩ jʋʋsɩnana Ŋmɩŋ tuose mɩŋ; ta vuodieke dɩaŋ mana dɩ yaalɩnana yese mɩŋ; vuodieke dɩaŋ dɩ kpaasɩnana gbɩabɩkʋ ka yuore a yɩa wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nɩnɩŋ chʋalɩŋ nɩ jabɩa bʋa dɩ nan jʋʋsɩ wa zaasɩŋ aŋ ʋ nagɩ javʋʋkɩŋ a yɩ wa? ");
INSERT INTO kma_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yaa mɩnɩa bʋa dɩ nan jʋʋsɩ wa gɩlɩ aŋ ʋ nagɩ chɩakʋrɔŋ a yɩ wa? ");
INSERT INTO kma_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ta dɩɩ yi nɩnɩŋ vuobɩatɩ gie dɩ sɩba nɩ nagɩ nyɩnvɩɩna a yɩ nɩ ballɩ, die nɩŋ nɩ Chɔɔŋ Ŋmɩŋ dieke dɩ benne arɩzanna ma wa nan faasɩ nagɩ ʋ Halɩkasɩka a yɩ vuodiekemba dɩ jʋʋsɩnana a yaala ka wa.” ");
INSERT INTO kma_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Die daa wʋnyɩ die benne ta jɩmbɩaŋ die dɩ yallɩ wa ta ʋ ka bɩagɩ bala wɩa, ta Yisa die dɩ vʋarɩ ka, daa wa dɩ wa piili a bala wɩa. Die dɩ yi kpɩkpaakʋ mamachi pam, ");
INSERT INTO kma_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ama bataŋ die dɩ baarɩ dɩ, “Jɩmbɩatɩ naaŋ wa Beelizebuli yɩna wa hagɩrɩbʋ ʋ bɩagɩ a vʋara jɩmbɩatɩ dene.” ");
INSERT INTO kma_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bataŋ dɩaŋ die dɩ yaala ba magɩsɩ wa, die wɩa die ba balɩ wa dɩ ʋ yi mamachi wɩɩŋ a dagɩ sɩba Ŋmɩŋ sɩba ʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama Yisa die dɩ mɩŋŋɩ ba sʋŋanyile ta balɩ yɩ ba dɩ, “Naaŋ dieke dɩ puone a yiŋŋi waga ka gbaŋ kaaŋ yʋasɩ, ta tigi dieke vuosi dɩaŋ dɩ puone a yiŋŋi waga ka gbaŋ nan nan. ");
INSERT INTO kma_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Die dɩ baa ka yi dɩ yi Sitaani dɩ puo ta yiŋŋi waga ka gbaŋ gbaŋ, ka naarɩ ka baa ka zie. Nɩ baarɩ dɩ jɩmbɩatɩ naaŋ wa Beelizebuli yɩna mɩŋ hagɩrɩŋ maŋ yie naa; ");
INSERT INTO kma_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","dɩɩ yi naa maŋ vʋara jɩmbɩatɩtɩ, ta nɩnɩŋ nɩŋ, mɩnɩa yɩnana nɩ kʋaŋandɩɩsɩrɩba hagɩrɩŋ ba vʋara ha? Nɩ gbaŋ gbaŋ nɩ kʋaŋandɩɩsɩrɩba nan dagɩ dɩ nɩ wo wusie. ");
INSERT INTO kma_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama manɩŋ, Ŋmɩŋ hagɩrɩŋ maŋ nagɩ vʋara jɩmbɩatɩ vuosi ma, die dagɩna sɩba Ŋmɩŋ naarɩ wɔŋ keŋ nɩ jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Dɩɩ yi daahagɩrʋ dɩ yi siri a gbarɩ ʋ tigiŋ aŋaŋ dembisi ŋaŋ nyinti, ʋ nyinti mana nan mɩŋŋɩ beri. ");
INSERT INTO kma_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama dɩɩ yi vuodieke dɩ hagɩrɩna a tɩaŋ wa dɩ keŋ tuoli wo ʋ tigiŋ me, ʋ nan nyaŋŋɩ wa ta gbatɩ ʋ dembisi ŋaŋ nyintiti ta bɩ chii ʋ nyintiti. ");
INSERT INTO kma_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Vuodieke mana dɩ kana ka zie n kʋaŋ waga mɩŋ mɩŋ; ta vuodieke dɩaŋ dɩ kana ka suŋŋi mɩŋ a lagɩsa vuosi n jigiŋ jata ba mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Dɩɩ yi ta jɩmbɩaŋ dɩ keŋ nyɩŋ vuota ma, ka ŋaaŋ dɩa wa jigikʋʋkɩŋ a yaala jigiŋ dɩ ka voosi, ka ka yeye; ʋ ŋaaŋ balɩ a yɩ wa ka gbaŋ gbaŋ dɩ, ‘N nan yiŋŋi a ga n tigidieke n vana wa.’ ");
INSERT INTO kma_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Die wɩa ka ŋaaŋ yiŋŋi ga wa mi a ye ta ka sʋŋ mana saarɩya a wʋnsɩ vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ka ŋaaŋ wa nyɩŋ mɩŋ a ga a chii jɩmbɩatɩ diekemba dɩ tɩanna ka gbaŋ gbaŋ ayʋpɔyɩ aŋ a ga bemme mi. Naa chɩama daa wa beriŋ nan faasɩ chʋʋsɩ pam a tɩaŋ die ʋ sɩna die wo.” ");
INSERT INTO kma_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisa die dɩ bala wɩaha gie a kpatɩ wa, ta hɔgʋ wʋnyɩ die dɩ bie kpɩkpaakʋ sʋŋ a faasɩ balɩ wa dɩ, “Sʋgɩfɩalɩŋ bie hɔgʋ dieke dɩ mɩɩrɩna fʋ ta fʋ nyʋʋsɩ ʋ bɩɩsɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ta Yisa die dɩ yiŋŋi balɩ wa dɩ, “Vuodiekemba dɩ wʋnnana Ŋmɩŋ wɩaha ta dɩha wa, banɩŋ sʋgɩfɩalɩŋ dɩ bie ba ma.” ");
INSERT INTO kma_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Die kpɩkpaakʋ dɩ giline Yisa wa die ʋ bɩ balɩ ba dɩ, “Lele wo gie vuosi yiwo vuobɩatɩ ta yaala ba ye mamachi wɩɩŋ; ama n kaaŋ wɔŋ yi mamachi wɩɩŋ a yɩ ba; sie Ŋmɩŋ naazʋa Jona dagɩŋ chanchaaŋ nyɩɩna ma maŋ nan dagɩ ba. ");
INSERT INTO kma_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wudieke dɩ yine Jona die dagɩna Nineva vuosi dɩ Ŋmɩŋ tʋnna wa, die gbaŋ gbaŋ bala ka yi manɩŋ vuota Bʋa ta dagɩ nɩnɩŋ leleke gie vuosi dɩ Ŋmɩŋ tʋnna mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sarɩya diile daraaŋ Sɩaba hɔgʋ naaŋ wa nan hagɩ a zie a galɩŋ nɩ dama die ʋ paalɩ nyɩŋ wa tɩgɩ saasaa a ga dɩ ʋ wʋŋ naaŋ Solomoni yɩaŋ wʋbalɩkaha, ama n bala nɩ vuodieke dɩ tɩanna naaŋ Solomoni benne giena. ");
INSERT INTO kma_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sarɩya diile daraaŋ Nineva vuosi nan hagɩ zie a galɩŋ nɩ, dama Jona dɩ mʋʋlɩna Ŋmɩŋ wɩa a yɩ ba wa die ba va wa ba tʋmbɩatɩ; n bala nɩ, vuodieke dɩ tɩanna Jona benne gie.” ");
INSERT INTO kma_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Vuoŋ ka chɔgɩsa popoli ta nagɩ ka a lɔbɩra yaa a nagɩ kpalɩ a bubike ama ʋ ŋaaŋ nagɩ ka a sagɩ wa jadieke dɩ jʋalɩna ma, amʋ vuosi dɩ keŋ juu ba nan ye ka chaaŋkʋ. ");
INSERT INTO kma_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fʋ nine yine fʋ nyɩŋgbanɩŋ popoli. Die wɩa fʋ nine dɩ keŋ vɩɩna, fʋ nyɩŋgbanɩŋ mana nan suuli aŋaŋ chaanɩŋ; ama fʋ nine dɩ keŋ a ka vɩɩna, fʋ nyɩŋgbanɩŋ mana nan dɩ bie lɩmɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɩ wa sɩmma dɩ chaaŋ dieke dɩ benne nɩ ma wa da keŋ bɩrɩŋ lɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Die wɩa dɩɩ yi fʋ nyɩŋgbanɩŋ mana dɩ suuli aŋaŋ chaanɩŋ, ta jigiŋ dɩ ka bie lɩmɩŋ ma, ka mana nan mɩŋŋɩ chaaŋ farrɩtata a nɩasɩ popoli dɩ ŋaana a chaaŋ yɩ fʋ die wo.” ");
INSERT INTO kma_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Die Yisa die dɩ balla wɩaha gie a kpatɩ wa, ta Farasisi vuoŋ wʋnyɩ die dɩ wa wa dɩ ʋ keŋ aŋ wʋnɩŋ aŋaŋ wa dii nyindiike, die wɩa die ʋ ga a ga a kalɩ dɩ ʋ dii nyindiike he. ");
INSERT INTO kma_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Die dɩ yi Farasisi vuoke mamachi, Yisa die dɩ kana ka nɩɩtɩ ʋ nuusi ta yaala ʋ dii nyindiike he. ");
INSERT INTO kma_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ta tɩ Yɔmʋtieŋ Yisa dɩ balɩ wa dɩ, “Nɩnɩŋ Farasisi vuosi nɩ ŋaaŋ daaraa nɩ nyachibisi aŋaŋ nɩ tɩmbala kʋasɩ, ama ta nɩ sʋgɩtɩ dɩ suuli aŋaŋ halɩ aŋaŋ sʋgɩtʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nɩnɩŋ gaantɩba gie! Daa Ŋmɩŋ dieke die dɩ naanna a kʋasɩsɩ naanna a sʋgɩtɩtɩ gbaŋ? ");
INSERT INTO kma_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yɩma zɔɔlɩntieliŋ jadieke dɩ benne nɩ nyachibisi me aŋaŋ nɩ tɩmbala ma aŋ jaaŋ mana yɩantɩ a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nɩnɩŋ Farasisi mba, wʋbɩaŋ bie nɩ ma. Nɩ naga nanjʋʋŋ aŋaŋ bʋŋʋ aŋaŋ neeri aŋaŋ nyinti a taŋ baŋ sʋŋ a nagɩ kaanɩ a yɩa Ŋmɩŋ, ama ta va jadieke dɩ yine nɩŋŋmɩna ʋ mɩraha ma; sɩba wusie sarɩya diile ta ka cho Ŋmɩŋ. Genhe die mʋna nɩ yime, a gʋtɩ nɩ yɩnana Ŋmɩŋ nyinti baŋ sʋŋ kaanɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nɩnɩŋ Farasisi, wʋbɩaŋ bie nɩ ma, dama nɩ yaala vuokpɩɩma jigikasɩka Ŋmɩŋ jɩamɩŋ juone me, ta bɩ yaala ba wasɩma nɩ aŋaŋ jɩlɩma nyʋgɩtɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wʋbɩaŋ bie nɩ ma, dama nɩ sɩɩ sɩba kunti vɔrɩtɩ dɩ lɔbɩrɩna vuosi dɩ ka yesehe ta chʋŋ a ma.” ");
INSERT INTO kma_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Die wɩa mɩraha dɩdagɩrɩba wʋnyɩ dɩ balɩ yɩ wa dɩ, “Dɩdagɩrʋ, fʋ bala naa nɩŋ zɩa wa tɩ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yisa die dɩ yiŋŋi a balɩ dɩ, “Nɩnɩŋ mɩraha dɩdagɩrɩba wʋbɩaŋ bie nɩ gbaŋ nɩ ma dama nɩ chie vuosi chiidʋnsa dɩ faasɩna a dʋnsɩ aŋaŋ ba baaŋ chii ama nɩ gbaŋ gbaŋ nɩ ka suŋŋi be dɩ ba chii. ");
INSERT INTO kma_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wʋbɩaŋ bie nɩ ma, dama nɩ ka tuose Ŋmɩŋ naazʋalɩba wʋbalɩkaha ama ta mɩa ta wʋnsa ba kunti vɔrɩtɩ a vɩɩna, banɩŋ die ba yine naazʋalɩŋ diekemba nɩ chɔɔŋkʋʋlɩba die dɩ kʋna wa ta nɩ gbaŋ nɩ ka tuose Ŋmɩŋ naazʋalɩba wʋbalɩkaha. ");
INSERT INTO kma_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nɩ yine wudieke wo, die dagɩna vuosi dɩ nɩ seŋ saagɩ wudieke nɩ chɔɔŋkʋʋlɩba dɩ yine wo, dama die ba kʋʋ wa Ŋmɩŋ naazʋalɩba ta nɩ dɩaŋ dɩ mɩa ba vɔrɩtɩ. ");
INSERT INTO kma_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Naa chɩaŋ ma, die yɩantieŋ Ŋmɩŋ die dɩ baarɩ dɩ, ‘N nan tʋŋ naazʋalɩŋ aŋaŋ tʋntʋntɩŋ ba jigiŋ, ta ba nan kʋʋ bataŋ ta mugisi bataŋ dɩaŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Die wɩa n nan datɩ leleke gie vuosi tɩba aŋaŋ ba kʋna naazʋalɩba a nyɩŋ dʋnɩa piiliku, ");
INSERT INTO kma_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","a nyɩŋ die ba kʋna Abeli a ga tʋgɩ Zakaria, vuodieke die ba kʋna Ŋmɩŋ kaabɩŋ koriku aŋaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋnsʋkʋ. N bala nɩ wusie, leleke gie vuosi nan ye tɩbɩdatɩŋ yaa gamma vuosi gie mana kumbu wɩa. ");
INSERT INTO kma_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nɩnɩŋ mɩraha dɩdagɩrɩba, wʋbɩaŋ bie nɩ ma, dama nɩ ligi wo Ŋmɩŋ wɩa dɩ vuosi da keŋ sɩmma a chɩasɩ, ama nɩ gbaŋ nɩ zeti wo a sɩbɩŋ, ta kaga vuodiekemba dɩ mɩnana dɩ ba sɩmma ha.” ");
INSERT INTO kma_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Die Yisa dɩ bala ʋ nyɩŋ mi wo ta mɩraha dɩdagɩrɩba aŋaŋ Farasisi dɩ jɩɩ sɩnyɩɩrɩŋ aŋaŋ wa, die ba piili a pɩasa wa wʋpɩasɩka pam yaa gamma ʋ balɩkʋ ma, ");
INSERT INTO kma_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","a mɩa yaala dɩ ʋ balɩ a chʋʋsɩ aŋ ba yigi wo. ");
INSERT INTO kma_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Womi die vuosi tuse tuse die dɩ lagɩŋ ta die a tɩba tamba nagɩsɩ ma, die Yisa die dɩ woliŋ a piili a bala a yɩa ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ sɩmma Farasisi vuosi beriku dama ba yiwo gɩgaantɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jadieke mana dɩ lɔbɩrɩna lele nan daansɩ nyɩŋ yaalɩŋ ma, ta wʋlɔbɩrɩkɩŋ mana dɩaŋ nan nyɩŋ yaalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Die wudieke mana nɩ bala lɩmɩŋ ma ba nan daansɩ wʋŋ ka yaalɩŋ ma; ta wudieke dɩaŋ nɩ pɔsɩna a balɩ juoŋ me nan daansɩ a mʋʋlɩ yaalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“N zʋalɩŋ, n bala nɩ, nɩ da chɩgɩma vuosi ŋmaamɩŋ, dama ba nan bɩagɩ kʋʋ nɩ nyɩŋgbanɩŋ ama ka kʋaŋ chaaŋ ba kaaŋ bɩagɩ a yi nɩ wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","N kpaama nɩ yaa gamma vuodieke nɩ mʋna nɩ chɩgɩ: Nɩ chɩgɩma Nabidie Ŋmɩŋ, vuodieke dɩ baaŋ bɩagɩ kʋʋ nɩ ta bɩ yaa yiko a baaŋ nan bɩagɩ a nagɩ nɩ a taaŋ boli dieke dɩ wone kpisiku me wo. Wusie maŋ bala nɩ dɩ nɩ chɩgɩma wʋnɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ba ka daa nembisi anʋ wa kɔbɩsɩ-le? Ama ta Ŋmɩŋ ka daamma a kaanɩ mana wɩa. ");
INSERT INTO kma_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nɩnɩŋ nɩŋ Ŋmɩŋ sɩba nɩ sikpeŋ zoosi nʋaŋ mɩŋ. Die wɩa nɩ da chɩgɩma ŋmaamɩŋ; dama nɩ yaa nyʋarɩ a tɩaŋ nembisisi pam. ");
INSERT INTO kma_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“N bala nɩ; vuodieke mana dɩ a keŋ a vʋarɩ ʋ gbaŋ vuosi me dɩ ʋ yiwo n vuoŋ, die gbaŋ gbaŋ manɩŋ vuota Bʋa dɩ nan vʋarɩ wa yaalɩŋ ma Ŋmɩŋ malakasisi nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama vuodieke dɩ baarɩ ʋ ka yi n vuoŋ vuosi jigiŋ, die gbaŋ gbaŋ manɩŋ vuota Bʋa dɩ nan balɩ dɩ n ka sɩba wa Ŋmɩŋ malakasisi nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ta vuodieke dɩaŋ mana mana dɩ keŋ balɩ wʋbɩaŋ yaa gamma manɩŋ vuota Bʋa wa Ŋmɩŋ nan nagɩ ʋ taalɩ a chaa wa; ama vuodieke nɩŋ mana dɩ keŋ balɩ wʋbɩaŋ yaa gamma Ŋmɩŋ Halɩkasɩka ma, Ŋmɩŋ kaaŋ wɔŋ nagɩ ʋ taalɩ a chaa wa. ");
INSERT INTO kma_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ama ba keŋ yaa nɩ ga Ŋmɩŋ jɩamɩŋ juone me yaa tɩŋgbaŋka nyɩŋkʋra yaa nyɩŋkʋra jige dɩ ba dii nɩ sarɩya nɩ da vaa dɩ mugisi nɩ aŋaŋ nɩ baaŋ nan balɩ die yaa a gbatɩ nɩ gbaŋ a taaŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Saŋŋa dɩ keŋ tʋgɩ Ŋmɩŋ Halɩkasɩka nan dagɩ nɩ wudieke nɩ baaŋ nan balɩ.” ");
INSERT INTO kma_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mi daa wʋnyɩ die dɩ bie kpɩkpaakʋ ma ta balɩ yɩ Yisa dɩ, “Dɩdagɩrʋ, balɩ yɩ n mɩɩ wa, dɩ ʋ vaa maŋ ŋaŋ wa puo faarɩ dieke tɩ chɔɔŋ dɩ vana a zieŋ tɩ wo.” ");
INSERT INTO kma_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Die Yisa die dɩ yiŋŋi a balɩ wa dɩ, “N zʋa, mɩnɩa yɩna mɩŋ sieŋ dɩ n dii nɩ sarɩya yaa dɩ n puo nɩ faarɩ a yɩ nɩ bale wo gie?” ");
INSERT INTO kma_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Die Yisa dɩ bɩ balɩ a yɩ ba mana dɩ, “Nɩ sɩmma nyinti yaalɩŋ wɩa, daa nyinti pam bala ka yɩ vuota miivoli.” ");
INSERT INTO kma_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Womi die ʋ taaŋ ba nandagɩrɩ gie dɩ, “Nyintitieŋ wʋnyɩ die yalla ʋ kʋaŋ, ta ka yɩa wa nyindiike pam; ");
INSERT INTO kma_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Die ʋ piili a yile ʋ sʋŋ ma dɩ, ‘N baaŋ yiwo lalɩa, dama n wo jigiŋ n baaŋ nan nagɩ n nyindiike mana a yi.’ ");
INSERT INTO kma_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Die ʋ balɩ yɩ ʋ gbaŋ dɩ, ‘Naa maŋ nan yi; n nan ŋmabɩ n bɔmbɔntɩtɩ ta mɩɩ nyɩŋkpɩɩma, ta nagɩ n zaaha aŋaŋ n nyinti mana a yi mi’. ");
INSERT INTO kma_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta wa balɩ yɩ n gbaŋ gbaŋ dɩ, ‘Sikpeŋ nansɩtieŋ, n yaa nyindiike pam n baaŋ nan dii a tʋgɩ bɩna pam. Die wɩa n nan dɩ voose ta die ta nyuo ta yaa sʋgɩfɩalɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama Ŋmɩŋ die dɩ balɩ a yɩ wa dɩ, ‘Fʋnɩŋ gaaŋkʋ gie, jinne yuku gie, baa fʋ waarɩ wa fʋ mɩsɩ, aŋ tɩ ye vuodieke dɩ bala ʋ nagɩ fʋ nyinti gie mana fʋ wʋnsɩna a zie wo?’ ");
INSERT INTO kma_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Tɔ, vuodieke nɩŋ mana dɩ yaalɩnana nyinti a yɩa ʋ gbaŋ, ama ta wo nyinti Ŋmɩŋ jigiŋ, nan daansɩ sɩɩ sɩba daa gaaŋkʋ gie.” ");
INSERT INTO kma_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Die Yisa die dɩ balɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Die wɩa n bala nɩ dɩ nɩ da vaa nɩ beriŋ mugisi nɩ yaa gamma jadieke nɩ baaŋ nan dii yaa jadieke nɩ baaŋ nan yeegi, ");
INSERT INTO kma_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","dama mɩsɩ tɩaŋ nyindiike, ta nyɩŋgbaŋka dɩaŋ dɩ tɩaŋ nyiŋyeeke. ");
INSERT INTO kma_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nɩ daansɩma nembisisi, a ka bʋra yaa a gobe; a dɩaŋ a wo nyindiike bɔmbɔntɩ ama Ŋmɩŋ yɩnana ha nyindiike; nɩ ka yaa nyʋarɩ pam a tɩaŋ nembisi? ");
INSERT INTO kma_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nɩ jabɩa baaŋ nan bɩagɩ a nagɩ bɩna a gʋtɩ ʋ bɩna ma ʋ mɩsɩ wɩa dɩ mugisine wo wɩa? ");
INSERT INTO kma_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nɩ kana ka bɩagɩ a yi wubike gie, bɩa nɩ mugisi nɩ gbaŋ aŋaŋ nyintialɩkaha. ");
INSERT INTO kma_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nɩ daansɩ tɩɩwute aŋaŋ a vɩɩnɩŋ; ama a ka tʋma yaa a yaala nyiŋyeeke yɩa a gbaŋ. Ama n bala nɩ, naaŋ Solomoni aŋaŋ ʋ nyinti aŋaŋ ʋ nyiŋyeekivɩɩna mana, die wo jayeekiŋ ka vɩɩna a tʋgɩ tɩɩwutehe kaanɩ. ");
INSERT INTO kma_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dɩɩ yi naa, Ŋmɩŋ dɩ yɩa huuti a vɩɩnɩŋ, nyindiekemba dɩ ŋaana beri jinne ama soriŋ boliŋ diihe wo, ʋ kaaŋ yɩ nɩ nyiŋyeeke? Nɩnɩŋ vuodiekemba yada dɩ kana a ka dala wa gie! ");
INSERT INTO kma_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Na chɩaŋ ma nɩ da vaa dɩ mugisi nɩ aŋaŋ jadieke nɩ baaŋ nan dii yaa nyuu. ");
INSERT INTO kma_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vuodieke dɩ kana ka sɩba Ŋmɩŋ ŋaana chɩga a yaala nyinti gie mana, ama nɩ Chɔɔŋ Ŋmɩŋ sɩba a baarɩ dɩ nɩ yaala ha mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Die wɩa nɩ vaa nɩ baga bemme Ŋmɩŋ naarɩ ma ta ʋ nan nagɩ nyinti gie mana a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nɩnɩŋ n vuosi dieke dɩ kana ka dala naa, nɩ da vaa ŋmaamɩŋ yalla nɩ, dama nɩ Chɔɔŋ Ŋmɩŋ yaa wa sʋgɩfɩalɩŋ aŋaŋ ʋ bala ʋ nagɩ naarɩ dieke a yɩ nɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Die wɩa nɩ nagɩ nɩ nyinti mana nɩ yalla a daa a nagɩ ligirehe yɩ zɔɔlɩntieliŋ, ta nɩ nan ye nyinti dɩ wone kpatɩŋ, nyinti nan dɩ bie arɩzanna ma, ta kaaŋ vʋarɩ, dama gaarɩŋ kaaŋ gbigi mi, ta nyɩnyʋgɩka kaaŋ chʋʋsɩha. ");
INSERT INTO kma_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dama jigidieke fʋ nyinti dɩ benne, mi dɩaŋ fʋ sʋŋ dɩ beri. ");
INSERT INTO kma_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nɩ yi siri a gbara wudiekemba dɩ kienene ta nɩ vaa nɩ popolisi chaaŋ, ");
INSERT INTO kma_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","sɩba yɔŋɩsɩ diekemba dɩ chɩɩsɩnana ba tieŋ dɩ ʋ nyɩŋ hɔgʋ faarɩtʋ banwʋla ma a keŋ wo, amʋ ʋ keŋ keŋ kpaasɩ sanʋarɩ ba nan yuorike lagɩ lagɩ a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sʋgɩfɩalɩŋ bie yɔŋ diekemba ba tieŋ dɩ kenne a haarɩ ba ta ba chɩɩsa wa. Wusie maŋ bala nɩ, ba tieŋ wo nan vaa ba kala ta yi ba nyindiike aŋ ba dii. ");
INSERT INTO kma_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dɩɩ yi ba tieŋ dɩ keŋ keŋ, tanseese yaa kparaaŋ kpaŋ saŋŋa ta ye ta ba chɩɩsa wa, sʋgɩfɩalɩŋ nan dɩ bie ba ma. ");
INSERT INTO kma_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nɩ sɩmma genke, dɩɩ yi tigiŋ tieŋ dɩ sɩba saŋŋa dieke gaarʋ dɩ bala ʋ keŋ ʋ tigiŋ me, ʋ kaaŋ vaa gaarʋ wa wɩɩ ʋ tigiri a juu; ʋ nan dɩ gbarɩ. ");
INSERT INTO kma_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɩnɩŋ nɩ gbaŋ nɩ yi siri a gbara, dama manɩŋ vuota Bʋa nan keŋ saŋŋa dieke nɩ kana ka yile dɩ n nan keŋ.” ");
INSERT INTO kma_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Womi Piita die dɩ pɩasɩ wa dɩ, “Tɩ Yɔmʋtieŋ, tɩnɩŋ fʋ taana nandagɩrɩ gie a yɩa yaa vuoŋ mana?” ");
INSERT INTO kma_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ta tɩ Yɔmʋtieŋ Yisa die dɩ yiŋŋi balɩ wa dɩ, “Yɔmʋ bɩa yine yɩaŋ tieŋ ta yie ʋ Yɔmʋtieŋ dɩ dagɩna dɩ ʋ yi wudieke? Wʋnɩŋ ʋ yine vuodieke ʋ Yɔmʋtieŋ dɩ nan vʋarɩ dɩ ʋ daansɩma ʋ yɔmʋ chanchaalɩba ta yɩma ba nyindiike saŋŋa dieke dɩ mʋna. ");
INSERT INTO kma_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dɩɩ yi ta ʋ Yɔmʋtieŋ dɩ keŋ tigiŋ ta ye wo ta ʋ tʋma die wo gbaŋ gbaŋ, sʋgɩfɩalɩŋ nan dɩ bie ʋ ma. ");
INSERT INTO kma_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wusie maŋ bala nɩ, ʋ nan nagɩ wa a zieŋ dɩ ʋ daansɩma ʋ nyinti mana mana, ");
INSERT INTO kma_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ama ʋ yi yɔmʋbɩaŋ, ʋ nan dɩ yile ʋ sʋŋ ma dɩ ʋ Yɔmʋtieŋ wo kaaŋ keŋ lagɩ lagɩ, ta piili a nɩga ʋ yɔmʋ chanchaalɩba ta wʋnɩŋ ʋ nan dɩ die ta nyu bugi. ");
INSERT INTO kma_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ʋ Yɔmʋtieŋ wo nan yiŋŋi keŋ daa dieke aŋaŋ saŋŋa dieke ʋ kana ka yile dɩ ʋ nan keŋ. Ʋ keŋ keŋ, ʋ nan datɩ ʋ tɩbɩŋ pam ta yi wo sɩba ʋ ŋaana yie vuodiekemba dɩ zetinene nʋaŋ die wo. ");
INSERT INTO kma_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yɔmʋ dieke dɩ sɩbɩna jadieke ʋ tieŋ dɩ yaalala ʋ yi, ta ka yi siri dɩ ʋ yi wudieke ʋ tieŋ wo dɩ yaalala, nan ye tɩbɩdatɩŋ aŋaŋ tɩbɩtɩ pam, ");
INSERT INTO kma_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ama yɔmʋ dieke dɩ kana ka sɩba wudieke ʋ tieŋ wo dɩ yaalala, ta yi wɩɩŋ chʋʋsɩ, ba nan tɩbɩ wa bɩta ta va wa. Vuodieke ba yɩna pam ba nan pɩasɩ pam a nyɩŋ wʋnɩŋ ʋ jigiŋ; ta vuodieke dɩaŋ ba nagɩna pam pam a yi ʋ nuusi me, ba nan pɩasɩ pam a nyɩŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Manɩŋ n keŋye mɩŋ dɩ keŋ taaŋ boliŋ tɩŋgbaŋka ma, dɩ tɩŋ nan yi mɩŋ nansɩŋ dɩɩ yi dɩ tɩŋgbaŋka wɔŋ die. ");
INSERT INTO kma_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ŋmɩŋ nyaaŋ sɩɩla dieke n bala n sɩɩ wa vaa n sʋŋ dɩ chʋʋsɩ mɩŋ, sie ka keŋ yi a tɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɩ yile dɩ n keŋye mɩŋ aŋaŋ sʋgɩdʋagɩŋ tɩŋgbaŋka ma? Aayɩ. N bala nɩ, n keŋye mɩŋ aŋaŋ puole. ");
INSERT INTO kma_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","A nyɩŋ jinne yaa gamma, vuosi banʋ nan dɩ bie tigiŋ me, ta keŋ puo; ba bataa nan chʋʋsɩ bale wo, ta bale wo dɩaŋ chʋʋsɩ bataa wa. ");
INSERT INTO kma_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chʋalɩŋ nan keŋ chʋʋsɩ ba ballɩ dembisi, ta ballɩ dembisi dɩaŋ keŋ chʋʋsɩ ba chʋalɩŋ; nɩɩlɩŋ dɩaŋ nan keŋ chʋʋsɩ ba hɔgʋlɩaba ta hɔgʋlɩaba dɩaŋ keŋ chʋʋsɩ ba nɩɩlɩŋ; nɩɩlɩŋ nan keŋ chʋʋsɩ ba lɩahalɩtɩ, ta lɩahalɩtɩ dɩaŋ nan keŋ chʋʋsɩ ba nɩɩlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Womi Yisa die dɩ balɩ yɩ kpɩkpaakʋ dɩ, “Nɩ keŋ yese nɩɩŋmaaŋ ŋmɩŋ nanɩŋ chaaŋ nɩ ŋaaŋ baarɩ dɩ, nɩɩŋ baa ka nɩɩ mɩŋ aŋ ka seŋ nɩɩ. ");
INSERT INTO kma_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nɩ a keŋ a ye ta bʋlɔgɩsɩŋ nɩga nyɩnna nuudiigiŋ chaaŋ nɩ ŋaaŋ baarɩ dɩ jigiri nan dɩ tuuli aŋ ka keŋ yi. ");
INSERT INTO kma_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nɩnɩŋ gɩgaantɩba gie, nɩ ŋaaŋ bɩagɩ a daansɩ tɩŋgbaŋka aŋaŋ ŋmɩŋsikpeŋ wudieke dɩ yinene ta dagɩ a chɩasɩ, ta bɩa yine nɩ ka bɩagɩ sɩba lele saŋka gie chɩasɩ? ");
INSERT INTO kma_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bɩa yine nɩ ka bɩagɩ a sɩba wudieke dɩ mʋna dɩ nɩ yi a yi? ");
INSERT INTO kma_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dɩɩ yi vuoŋ dɩ yaa fʋ gara naalɩaŋ, kpaŋŋɩ fʋ gbaŋ aŋ nɩ wʋnsɩ wɩɩrɩ nɩ yene bie sieku me wo, dɩ daa die ʋ nan yaa fʋ ga vuodieke dɩ dinene sarɩyaka jigiŋ aŋ sarɩya diiru wo nagɩ fʋ a yi dansarika dɩdaansɩrɩba jakʋʋŋ nuusi me aŋ ʋ nagɩ fʋ yi dansarɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N bala nɩ, kaaŋ keŋ nyɩŋ mi a ga tʋgɩ saŋŋa dieke fʋ baaŋ nan tuŋ ba bala fʋ tuŋ ligire dieke wo mana.” ");
INSERT INTO kma_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Saŋka mi vuosi bataŋ die dɩ bie mi a balɩ Yisa yaa gamma Paliti dɩ kʋna Galili vuosi saŋŋa dieke die ba kaabɩna yɩa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yisa die dɩ yiŋŋi a pɩasɩ ba dɩ, “Nɩ yile dɩ Galili vuosisi die ba kʋna wa tʋmbɩatɩ die faasɩ dala mɩŋ a tɩaŋ ba chanchaalɩba mi? ");
INSERT INTO kma_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aayɩ; ama n bala nɩ, dɩɩ yi nɩ ka chɩgɩ nyɩŋ nɩ tʋntʋmbɩatɩ ma, nɩ nan kpi sɩba ba kpine die wo. ");
INSERT INTO kma_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloami jarɩnbɩsa die dɩ nanna a kʋʋ vuosi baŋ aŋaŋ anɩɩ wo, nɩ yile dɩ die vuosi tʋmbɩatɩ die tɩaŋ ba chanchaalɩba die dɩ benne Jerusalemi ma wa? ");
INSERT INTO kma_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aayɩ, ama n bala nɩ, dɩɩ yi nɩ ka chɩgɩ nyɩŋ nɩ tʋntʋmbɩatɩ ma nɩ mana gbaŋ nan kpi.” ");
INSERT INTO kma_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Womi Yisa die dɩ taaŋ ba nandagɩrɩ gie dɩ, “Daa wʋnyɩ die sone tɩɩnyɩŋkɩŋ ʋ kʋaŋ ma, ta die ga a yaala nyɩŋnyɩŋka ka sikpeŋ me dɩ ʋ kpaa, ama die ʋ ka yeye. ");
INSERT INTO kma_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Die wɩa die ʋ balɩ a yɩ vuodieke dɩ daansɩnana ʋ kʋakʋ dɩ, ‘Ye, bɩna ataa wʋnna maŋ chʋŋ kieŋ gie a yaala nyɩŋnyɩŋka tɩɩka sikpeŋ ta ka yeye. Chɩaka taaŋ, bɩa wɩa ka nan dɩ zie a chʋʋsa tɩŋgbaŋka?’ ");
INSERT INTO kma_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ama dɩdaansɩrʋ wa die dɩ yiŋŋi bala wa dɩ, ‘Jakʋʋŋ, vaa ka bɩmbalɩmɩŋ a gʋtɩ ta n nan tuu a giliŋke a yi hʋʋsɩŋ a yi ka chɩaŋ ma, ");
INSERT INTO kma_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","aŋ tɩ ye ka nan nyɩŋ nyɩŋnyɩŋka bɩŋ chaaŋ? Ka ka nyɩŋya n nan chɩaka taaŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Davʋʋsɩkɩrɩ daarɩ Yisa die dɩ bie Ŋmɩŋ jɩamɩŋ juoŋ me a daga; ");
INSERT INTO kma_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ta hɔgʋ wʋnyɩ die dɩ bie mi jɩmbɩaŋ die dɩ bie ʋ ma a vaa ʋ bɩrɩŋ gbarɩgɩŋ bɩna baŋ aŋaŋ anɩɩ. Die ʋ guriye mɩŋ a ka bɩagɩ hagɩziele. ");
INSERT INTO kma_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisa die dɩ yene wo die ʋ wa wa a keŋ nyɩŋ a balɩ a yɩ wa dɩ, “Hɔgʋ, fʋ yʋagɩbʋ vaa fʋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ta die nagɩ ʋ nuuŋ a diisi ʋ ma, ta lele womi, die ʋ tɩɩntɩ ta bɩrɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Die Ŋmɩŋ jɩamɩŋ juoku jakʋʋŋ die dɩ jɩɩ sɩnyɩɩrɩŋ, dama Yisa die dɩ gbaanna hɔgʋ wa davʋʋsɩkɩrɩ daarɩ wɩa; die wɩa die ʋ balɩ vuosisi dɩ, “Daraa ayʋaba benne bakɔyɩ ma dɩ tɩ yaa a tʋmma, die wɩa nɩ kiere hanɩŋ daraa mi aŋ ʋ gbaaŋ nɩ, ama da keŋ davʋʋsɩkɩrɩ daarɩ dɩ ʋ gbaaŋ nɩ.” ");
INSERT INTO kma_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ta tɩ Yɔmʋtieŋ Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Nɩnɩŋ gɩgaantɩba gie, nɩ wʋnyɩ ŋaaŋ a forisi wo nɩ niige yaa nɩ bonsi a yaa ga a yɩ ha nyaaŋ davʋʋsɩkɩrɩ daaŋ. ");
INSERT INTO kma_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta hɔgʋ wa gie dɩ yine Abarahami haagɩŋ vuodieke Sitaani dɩ bɩrɩŋ wa yɔmʋ bɩna baŋ aŋaŋ anɩɩ, dɩ ka mʋ dɩ n gbatɩ wa taaŋ davʋʋsɩkɩrɩ daarɩ?” ");
INSERT INTO kma_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisa die dɩ bala naa wa viivi die dɩ yigi ʋ dataasɩ mana; ta kpɩkpaakʋ sʋgɩtɩ die dɩ fɩalɩ aŋaŋ mamachi wudiekemba ʋ yinene wo. ");
INSERT INTO kma_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ka kʋaŋ chaaŋ Yisa die dɩ pɩasɩ ba dɩ, “Ŋmɩŋ naarɩ sɩɩ sɩba bɩa? Bɩa maŋ baaŋ nagɩ a magɩsɩ ka? ");
INSERT INTO kma_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka nɩasɩ wa kaŋmɩŋ biŋ, daa wʋnyɩ dɩ nagɩna a ga bʋrɩ ʋ kʋaŋ ma, die ka bɩrɩŋ a ga bɩrɩŋ tɩɩŋ nembisi die dɩ yʋga a tuusi ka sikpeŋ me.” ");
INSERT INTO kma_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ta Yisa die dɩ bɩ pɩasɩ ba dɩ, “Bɩa maŋ baaŋ nagɩ Ŋmɩŋ naarɩ a magɩsɩ? ");
INSERT INTO kma_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ka nɩasɩ wa dabɔtɩ hɔgʋ dɩ nagɩna a lagɩŋ paanʋ zɔŋ dieke dɩ dala ma aŋ bʋ mana dɩ yiri wo.” ");
INSERT INTO kma_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Saŋŋa dieke Yisa die dɩ benne sieŋ me a gara Jerusalemi wa, die ʋ daagɩ tɩgɩkpɩɩma aŋaŋ tɩŋkpaŋŋɩsɩ a daga vuosi Ŋmɩŋ wɩa; ");
INSERT INTO kma_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","die vuoŋ wʋnyɩ die dɩ pɩasɩ wa dɩ, “Jakʋʋŋ, vuodiekemba dɩ bala ba ye gbatɩtaaŋkʋ ba nan yi bɩta yaa ba nan dɩ dala?” Yisa die dɩ balɩ a yɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Sie nɩ kpaŋŋɩ nɩ gbaŋ a dɩa sanʋabike a juu mi. N bala nɩ, vuosi pam nan daansɩ mɩa dɩ ba juu ama ba nan waarɩ ka juule. ");
INSERT INTO kma_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tigiri tieŋ dɩ keŋ hagɩ a ligi sanʋarɩ, ta nɩ wɩarɩ a zie yene me, ta kpaasa sanʋarɩ a wasa a baarɩ dɩ, ‘Jakʋʋŋ yuori sanʋarɩ a yɩ tɩ’, ama saŋka mi ʋ nan yiŋŋi a balɩ nɩ dɩ ‘N ka sɩba jigidieke dɩ nyɩnna.’ ");
INSERT INTO kma_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Saŋka mi nɩ nan yiŋŋi a balɩ wa dɩ, ‘Tɩnɩŋ aŋaŋ fʋ die dinene ta nyuo, ta fʋ dagɩ tɩ Ŋmɩŋ wɩa tɩ tɩŋ ma.’ ");
INSERT INTO kma_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ama ʋ nan daansɩ bɩ a baarɩ, ‘N ka sɩba jigidieke nɩ nyɩnna.’ Ta balɩ nɩ, ‘Nɩ gamma ta va manɩŋ, nɩnɩŋ vuobɩatɩ gie mana.’ ");
INSERT INTO kma_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ta n nan nagɩ nɩ a taaŋ yeŋ me; ta nɩ nan ye Abarahami aŋaŋ Aziki aŋaŋ Jakobu aŋaŋ Ŋmɩŋ naazʋalɩba mana, ta ba bie Ŋmɩŋ naarɩ ma, ta nɩ nan dɩ kʋma ta ŋɔba nɩ nyɩna. ");
INSERT INTO kma_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vuosi nan daansɩ nyɩŋ ŋmɩŋ pɔsɩkɩŋ aŋaŋ ŋmɩŋ juukiŋ aŋaŋ nuudiigiŋ aŋaŋ nuugalɩ chaaŋ a keŋ kalɩ Ŋmɩŋ naarɩ ma a dii nyindiike. ");
INSERT INTO kma_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","N baaŋaa, vuosi bataŋ dieke dɩ wɩarɩna kʋaŋ lele nan keŋ bie nɩŋŋa, ta vuosi bataŋ dieke dɩ benne nɩŋŋa lele nan keŋ wɩarɩ kʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Saŋka mi gbaŋ gbaŋ Farasisi vuosi bataŋ die dɩ keŋ Yisa jigiŋ a balɩ a yɩ wa dɩ, “Sie fʋ nyɩŋ giena a ga jigigaaŋ, dama naaŋ Herodi yaala ʋ kʋʋ fʋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ta Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Wʋnɩŋ Ŋmɩndarɩka gie, nɩ ga balɩ wa dɩ, ‘N nan dɩ vʋara jɩmbɩatɩ ta gbaama vuosi jinne aŋaŋ soriŋ, ta daraa ataa wa daraaŋ n nan kpatɩ n tʋʋma.’ ");
INSERT INTO kma_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ama a nyɩŋ jinne aŋaŋ soriŋ aŋaŋ vʋntʋŋ dɩ mʋ dɩ n bemme sieŋ me, dama dɩ ka mʋ dɩ ba kʋʋ Ŋmɩŋ naazʋa jigigaaŋ sie Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Nchʋanaawee, Jerusalemi vuosi, nɩnɩŋ vuodiekemba dɩ kʋna Ŋmɩŋ naazʋalɩba, ta bɩ taa vuodiekemba ʋ tʋnna nɩ jigiŋ wo tana a kʋʋ wa, bʋŋmɩa maŋ mɩa a yaala dɩ n lagɩsɩ nɩ bʋnyɩ sɩba kpɩanɩɩŋ dɩ ŋaana lagɩsɩ ka ballɩ ka chobiti chɩaŋ ta nɩ ka saaga. ");
INSERT INTO kma_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ye, Ŋmɩŋ vaa nɩ jɩamɩŋ juokpeŋkpɩɩkʋ ta ka zie yɔrɩ. N bala nɩ, a nyɩŋ jinne yaa gamma, nɩ kaaŋ bɩ ye mɩŋ bɩbra a ga tʋgɩ saŋŋa dieke nɩ baaŋ nan balɩ dɩ, ‘Alibarika bie vuodieke dɩ kennene Nabidie Ŋmɩŋ saaŋ ma.’ ” ");
INSERT INTO kma_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Davʋʋsɩkɩrɩ daaŋ kaanɩ Yisa die dɩ ga Farasisi nyɩŋkʋra wʋnyɩ tigiŋ dɩ ʋ dii nyindiike, die vuosisi die dɩ mɩŋŋɩ a daansa wa. ");
INSERT INTO kma_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mi yʋagɩtieŋ wʋnyɩ dɩ keŋ ʋ jigiŋ, die ʋ nagɩsɩ aŋaŋ ʋ nuusi mʋrɩna. ");
INSERT INTO kma_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Die wɩa Yisa die dɩ pɩasɩ Farasisi aŋaŋ mɩraha dɩdagɩrɩba dɩ, “Tɩ mɩraha saagɩya mɩŋ dɩ tɩ gbaaŋ davʋʋsɩkɩrɩ daraaŋ yaa tɩ da gbaaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ama die ba tarɩ. Yisa die dɩ nagɩ ʋ nuuŋ a gbɩ daa wa ta gbaaŋ wa ta vaa ʋ ga. ");
INSERT INTO kma_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ta die a balɩ yɩ ba, “Dɩɩ yi nɩ wʋnyɩ dɩ yallɩ boniŋ yaa naagɩŋ ka nan buluŋ me davʋʋsɩkɩrɩ daarɩ kaaŋ yi lagɩ lagɩ a ga a vʋarɩ ka?” ");
INSERT INTO kma_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ama die ba ka bɩagɩ a yiŋŋi a balɩ wa wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mi Yisa die yene chaamba dɩ vʋarɩnana vuokpɩɩma jigikasɩha, ʋ kpaaŋ ba dɩ; ");
INSERT INTO kma_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Dɩɩ yi ba keŋ a wa fʋ dɩ fʋ keŋ banwʋla ma, da keŋ ga kala vuokpɩɩma jigikasɩka, dama dɩ nan bɩagɩ yi ta ba wa wa vuodieke dɩ tɩanna fʋ ");
INSERT INTO kma_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","aŋ vuodieke dɩ wana nɩ wa nan keŋ fʋ jigiŋ a balɩ fʋ dɩ, ‘Hagɩ ta yɩ wa fʋ jigikasɩkɩrɩ.’ Mi nan dii viivi ta ga kalɩ vuosi kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama ba keŋ a wa fʋ, ga kala vuosi kʋanʋaŋ, amʋ vuodieke dɩ wana fʋ dɩ keŋ keŋ ʋ nan balɩ a yɩ fʋ dɩ, ‘N zʋa, keŋ jʋalɩ kala vuokpɩɩma jigikasɩkɩrɩ ma.’ Mi nan ye jɩlɩma fʋ chanchaalɩba mana jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dama vuodieke mana dɩ kɔtɩna ʋ gbaŋ Ŋmɩŋ nan sʋʋŋ wa tɩŋgbaŋ, ama vuodieke dɩ sʋʋna ʋ gbaŋ tɩŋgbaŋ, Ŋmɩŋ nan kɔtɩ wa ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mi Yisa die dɩ balɩ a yɩ vuodieke die dɩ wana wa wa dɩ, “Dɩɩ yi fʋ keŋ yaa dʋʋga, da keŋ wa fʋ zʋalɩŋ yaa fʋ nɩmballɩ yaa fʋ maarɩŋ yaa fʋ chanchaalɩŋ ligire tieliŋ, dama fʋ wa ba ba dɩaŋ ba nan yiŋŋi a wa fʋ a yiŋŋi tuŋ fʋ wudieke fʋ yine wo. ");
INSERT INTO kma_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama fʋ keŋ yaa dʋʋga wa zɔɔlɩntieliŋ aŋaŋ gbarɩgɩsɩ aŋaŋ gbɩlɩsɩ aŋaŋ yɩɩsɩ, ");
INSERT INTO kma_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ta nan ye alibarika, dama ba kaaŋ bɩagɩ a yiŋŋi tuŋ fʋ, Ŋmɩŋ nan tuŋ fʋ saŋŋa dieke vuovɩɩna dɩ keŋ hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Die vuodiekemba dɩ dinene aŋaŋ Yisa wʋnyɩ dɩ wʋnnana Yisa balɩkʋ ʋ balɩ a yɩ wa dɩ, “Sʋgɩfɩalɩŋ bie vuodiekemba dɩ bala ba daansɩ kala Ŋmɩŋ naarɩ ma a dii nyindiike!” ");
INSERT INTO kma_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yisa die dɩ yiŋŋi balɩ wa dɩ, “Daa wʋnyɩ die benne a keŋ yaala ʋ dii dʋʋgakpeŋkpɩɩŋ, ta die a posi vuosi pam. ");
INSERT INTO kma_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Die dʋʋgaka diile saŋŋa die dɩ gbigine wo, die ʋ tʋŋ ʋ tʋntʋntʋ dɩ ʋ ga balɩ vuodiekemba ba wone a posi wo dɩ, ‘Nɩ keŋ, jaaŋ mana yi siri mɩŋ!’ ");
INSERT INTO kma_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama ba mana die dɩ piili a bala wudieke wɩa ba kana kaaŋ bɩagɩ a keŋ. Die bʋmbʋŋaŋ vuoke dɩ baarɩ dɩ, ‘N daa wa tɩŋgbaŋ ta dɩ mʋ dɩ n ga ye ke, die wɩa yɩ mɩŋ sieŋ aŋ n ga.’ ");
INSERT INTO kma_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta wʋnyɩ dɩaŋ die dɩ baarɩ dɩ, ‘N daa wa naakʋaka baŋ; die wɩa yɩ mɩŋ sieŋ aŋ n yaa ha a ga magɩsɩ ye.’ ");
INSERT INTO kma_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wʋnyɩ dɩaŋ die dɩ baarɩ dɩ, ‘N faarɩ wa hɔgʋ daraa gie nʋaŋ die wɩa n kaaŋ bɩagɩ keŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Die tʋntʋntʋ wa die dɩ yiŋŋi ga a balɩ ʋ tieŋ wo wɩaha gie mana. Die ʋ tieŋ wo dɩ jɩɩ sɩnyɩɩrɩŋ ta balɩ yɩ ʋ tʋntʋntʋ wa dɩ, ‘Nyɩŋ lagɩ lagɩ a ga tɩka sieti me a wa zɔɔlɩntieliŋ aŋaŋ gbarɩgɩsɩ aŋaŋ yɩɩsɩ aŋaŋ gbɩlɩsɩ a yaa ba viiri keŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ka kʋaŋ chaaŋ tʋntʋntʋ wa dɩ keŋ baarɩ dɩ, ‘Jakʋʋŋ, fʋ bala dɩ n yi wudieke wo, n yiye mɩŋ, ama yɩalɩŋ yene bie juoku sʋŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Die wɩa ʋ tieŋ wo dɩ balɩ wa dɩ, ‘Bɩ nyɩŋ ga tɩka lʋga a daansɩ siekpɩɩma aŋaŋ siebisisi me, a yaalɩ vuosi a keŋ juu amʋ n tigiri nan suuli. ");
INSERT INTO kma_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ama vuodiekemba die n wolinne a posi wo wʋnyɩ gbaŋ nʋaŋ kaaŋ laŋ n dʋʋgaka nyindiike he.’ ” ");
INSERT INTO kma_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Saŋŋa kaanɩ, die kpɩkpaaŋ pam die dɩdɩ Yisa, die ʋ yiŋŋi a balɩ yɩ ba dɩ. ");
INSERT INTO kma_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Vuodieke mana dɩ yaala ʋ bemme n jigiŋ, sie ʋ chome mɩŋ a tɩaŋ ʋ chone ʋ chɔɔŋ aŋaŋ ʋ nuŋ aŋaŋ ʋ hɔgʋ aŋaŋ ʋ ballɩ aŋaŋ ʋ nɩmballɩ aŋaŋ ʋ gbaŋ gbaŋ miivoli die. Dɩ daa die ʋ kaaŋ bɩagɩ a yi n kʋaŋandɩɩsɩrʋ. ");
INSERT INTO kma_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta vuodieke dɩaŋ mana dɩ kana ka viigi ʋ kuŋ dagarɩkɩŋ a dɩ n kʋaŋ, kaaŋ bɩagɩ a yi n kʋaŋandɩɩsɩrʋ. ");
INSERT INTO kma_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dɩɩ yi vuoŋ dɩ yaala ʋ mɩɩ tigikpɩɩŋ, sie ʋ woliŋ a kala a sɩmma ka ligire nʋaŋ, a sɩmma baarɩ ʋ ligire nan tʋgɩ yaa ka kaaŋ tʋgɩ. ");
INSERT INTO kma_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dama ʋ ka yi die, ta piili tigiri ta keŋ ka bɩagɩ a mɩɩ ka kpatɩ, ta vuosi dɩ yese ke ta sɩba baarɩ ʋ ka bɩagɩ mɩɩ ka kpatɩ, ba nan vʋarɩ wa fala. ");
INSERT INTO kma_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ba nan baarɩ dɩ, ‘Daa wa gie die piiliye mɩŋ dɩ ʋ mɩɩ ama ʋ ka bɩagɩ kpatɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Dɩɩ yi naaŋ dɩ yaa vuosi tuse baŋ a nyɩŋ gara ʋ wagɩ ʋ chanchaaŋ dɩ yalla tuse baŋɩsɩ-le, ʋ nan woliŋ kalɩ a daansɩ ʋ gbaŋ ye dɩ ʋ yaa hagɩrɩŋ a baaŋ nan bɩagɩ a tuoli ʋ chanchaaka. ");
INSERT INTO kma_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dɩɩ yi ʋ wo hagɩrɩŋ ʋ nan tʋŋ tʋntʋntɩŋ aŋ ba woliŋ dɩa ʋ nɩŋŋa a nagɩ vaaŋ a dagɩ ʋ chanchaaka dɩ ʋ kaaŋ bɩagɩ a wagɩ wa.” ");
INSERT INTO kma_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yisa die dɩ balɩ kpatɩ ba dɩ, “Die gbaŋ gbaŋ nɩ wʋnyɩ mana dɩ kaaŋ bɩagɩ a yi n kʋaŋandɩɩsɩrʋ sie ʋ nagɩ nyinti mana a taaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yasɩ nansɩ mɩŋ, ama dɩɩ yi ka nansɩbʋ dɩ nyɩŋ, lalɩa ka bɩ baa ka ye ka nansɩbʋ bɩbra? ");
INSERT INTO kma_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A ka bɩ vɩɩna dɩ fʋ nagɩ ka a taaŋ fʋ kʋaŋ ma yaa fʋ nagɩ ka a gʋtɩ hʋʋsɩŋ ma. Sie fʋ nagɩ ka a taaŋ. Vuodieke dɩ yaa tɩba ʋ wʋmma.” ");
INSERT INTO kma_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Die saŋŋa kaanɩ lampotuosiriŋ pam aŋaŋ tʋntʋmbɩatɩ tieliŋ die dɩ keŋ Yisa jigiŋ dɩ ba wʋŋ ʋ wʋbalɩka ha. ");
INSERT INTO kma_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ama Farasisi aŋaŋ mɩraha dɩdagɩrɩba dɩ piili a vʋʋna wɩa dɩ, “Daa wa gie tuose tʋntʋmbɩatɩ tieliŋ ta die aŋaŋ ba.” ");
INSERT INTO kma_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naa chɩaŋ ma Yisa die dɩ taaŋ ba nandagɩrɩ gie dɩ, ");
INSERT INTO kma_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dɩɩ yi nɩ wʋnyɩ dɩ yaa yiise kɔbɩga ta a kaanɩ dɩ bɩa, bɩa ʋ baa ʋ yi? Sie ʋ vaa yiise baŋɩsɩ-wayɩ aŋaŋ awayɩ wa dɩ dinene jigidieke wo, ta ga a yaalɩ jabalɩŋka dɩ bana wa a ga tʋgɩ saŋŋa dieke ʋ baaŋ nan ye ke. ");
INSERT INTO kma_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dɩɩ yi ʋ keŋ ye ke ʋ sʋŋ ŋaaŋ fɩalɩ mɩŋ, ta nagɩ ka viigi, ");
INSERT INTO kma_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ta chii ke a kuli tigiŋ. Saŋka mi ʋ nan wa ʋ zʋalɩŋ aŋaŋ ʋ jʋjʋrɩtamba a lagɩsɩ a balɩ yɩ ba dɩ ‘Nɩ yallɩma sʋgɩfɩalɩŋ, dama n ye wo n yii dieke dɩ bana wa.’ ” ");
INSERT INTO kma_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Die wɩa Yisa dɩ bɩ bala ba dɩ “Tʋntʋmbɩatɩ vuobalɩmɩŋ dɩ chɩgɩ nyɩŋ ʋ tʋntʋmbɩatɩ ma, sʋgɩfɩalɩŋ nan dɩ beri arɩzanna ma ʋ wɩa a tɩaŋ ka bala ka sɩmma die vuovɩɩna baŋɩsɩ-wayɩ aŋaŋ awayɩ dieke dɩ yilinene dɩ dɩ ka mʋ dɩ ba chɩgɩ nyɩŋ ba tʋmbɩatɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yaa dɩ yi hɔgʋ dɩ yaa ligiribie baŋ, ta a kaanɩ dɩ bɩa, lalɩa ʋ baa ʋ yi? Sie ʋ chɔgɩsɩ popoli ta mɩŋŋɩ saarɩ ʋ juoku ta mɩŋŋɩ daansɩ jigiŋ mana a ga tʋgɩ saŋŋa dieke ʋ baaŋ nan ye ke. ");
INSERT INTO kma_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ʋ keŋ a ye ke ʋ ŋaaŋ wa wa ʋ zʋalɩŋ aŋaŋ ʋ jʋjʋrɩtamba a lagɩsɩ a balɩ a yɩ ba dɩ, ‘Nɩ yallɩma sʋgɩfɩalɩŋ, dama n ye wo n ligiribiŋ dieke dɩ bana wa.’ ");
INSERT INTO kma_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Die wɩa Yisa die dɩ bɩ balɩ ba, dɩɩ yi tʋntʋmbɩatɩ tieliŋ wʋnyɩ dɩ chɩgɩ nyɩŋ ʋ tʋntʋmbɩatɩ ma, Ŋmɩŋ malakasisi nan dɩ yaa sʋgɩfɩalɩŋ pam ʋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Womi Yisa die dɩ bɩ balɩ dɩ, “Daa wʋnyɩ die yalla dembibisi bale, ");
INSERT INTO kma_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ta bʋabike chaaŋ die dɩ balɩ a yɩ ʋ chɔɔŋ wa dɩ, ‘N chʋa, n yaala fʋ nagɩ n balla n daansɩ dii faarɩ dieke a yɩ mɩŋ.’ Saŋka mi ʋ chɔɔŋ wa die dɩ puo faarɩ ka a yɩ ba bale wo. ");
INSERT INTO kma_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Die dɩ ka yʋasɩya bʋabike die dɩ nagɩ ʋ nyinti mana a daa, ta nagɩ ligirehe a dɩa, a ga tɩgɩ saasaa. Mi die ʋ ga dii ligirehe yɔrɩ yɔrɩ a kpatɩ. ");
INSERT INTO kma_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Die ʋ dine jaaŋ mana a kpatɩ wa, die kɔŋkpeŋkpɩɩŋ die dɩ nan tɩŋgbaŋka mana ma, die dɩ paalɩ a wʋŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Die wɩa die ʋ ga bie daa wʋnyɩ tigiŋ tɩŋgbaŋka ma, daa wa die dɩ yaa wa ga ʋ kʋaŋ ma dɩ ʋ daansɩma ʋ perukusi. ");
INSERT INTO kma_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Die ʋ tɩŋ yaala ʋ dii perukusisi nyindiikehe a chagɩ ama vuoŋ die ka yɩ wa jaaŋ. ");
INSERT INTO kma_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ka kʋaŋ chaaŋ die ʋ keŋ mɩŋŋɩ a yili, ‘N chʋa tʋntʋntɩba mana yese nyindiike a die ta tɩala, ta giena maŋ baa n kpi aŋaŋ kɔŋ. ");
INSERT INTO kma_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dɩ sɩna die wo, n nan hagɩ a ga n chʋa jigiŋ a balɩ wa dɩ, N chʋa, n yi bɩaŋ ta chʋʋsɩ Ŋmɩŋ aŋaŋ fʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","N ka bɩ mʋ fʋ wa mɩŋ fʋ bʋa; daansɩma mɩŋ sɩba fʋ tʋntʋntɩba kaanɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Die wɩa die ʋ hagɩ a ga ʋ chɔɔŋ wa jigiŋ. “Die ʋ yene bie sieku me a gara wa, ʋ chɔɔŋ wa die dɩ ye wo, zɔɔlɩŋ die dɩ yigi wo pam, die ʋ chɩgɩ ga a gurigi wo. ");
INSERT INTO kma_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Die bʋa wa dɩ baarɩ dɩ, ‘N chʋa, n yi bɩaŋ Ŋmɩŋ aŋaŋ fʋ jigiŋ. N ka bɩ mʋ dɩ fʋ wa mɩŋ fʋ bʋa.’ ");
INSERT INTO kma_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama ʋ chɔɔŋ wa die dɩ wa ʋ tʋntʋntɩba a balɩ ba dɩ, ‘Nɩ yi lagɩ lagɩ a nagɩ jayeekivɩɩka a keŋ yeegi wo, ta nagɩ nuupiriŋ a keŋ yi ʋ nuuŋ me, ta nagɩ nɩɩra a suu wo; ");
INSERT INTO kma_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ta ga nagɩ narapɔlɩ dieke dɩ narɩna a keŋ kʋʋ aŋ tɩ dii dʋʋga. ");
INSERT INTO kma_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Dama die n yile dɩ n bʋa wa gie kpiye mɩŋ, ama ta ʋ bie ʋ mɩsɩ ma, ta bɩ yile dɩ ʋ baya mɩŋ, ama ʋ yiŋŋi keŋ mɩŋ.’ Die wɩa die ba piili a die dʋʋgaka aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ama saŋka mi, die ʋ bʋa jakʋʋrɩ die ye bie wo kʋakʋ ma. Die ʋ kienene tigiri a keŋ gbigi tigiri, die ʋ wʋŋ yɩlaha aŋaŋ siele he. ");
INSERT INTO kma_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Die wɩa die ʋ wa tʋntʋntɩba wʋnyɩ a pɩasɩ wa wudieke dɩ yinene tigiri me. ");
INSERT INTO kma_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Die ʋ yiŋŋi balɩ wa dɩ, ‘Fʋ nɩmbʋa wa yiŋŋi keŋ mɩŋ, fʋ chʋa wa dɩ kʋʋ narapɔlɩ dieke dɩ narɩna, dama ʋ yiŋŋi keŋ mɩŋ aŋaŋ alaafɩa.’ ");
INSERT INTO kma_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Die bʋa jakʋʋrɩ die dɩ jɩɩ sɩnyɩɩrɩŋ, ta zeti dɩ ʋ kaaŋ juu gbaakʋ sʋŋ; die wɩa die ʋ chɔɔŋ dɩ keŋ nyɩŋ a jʋʋsɩ wa dɩ ʋ keŋ juu, ");
INSERT INTO kma_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ama die ʋ yiŋŋi balɩ ʋ chɔɔŋ wa dɩ, ‘Ye, bɩnaha gie mana n tʋma a yɩa fʋ mɩŋ sɩba yɔmʋ, ta saaga fʋ nʋaŋ, ama ka yi mɩŋ biibiŋ gbaŋ dɩ n kʋʋ a wa n zʋalɩŋ aŋ tɩ dii ta yallɩma sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Fʋ bʋa wa gie nɩŋ die chʋʋsɩna fʋ nyinti mana hɔgʋba ma wa, dɩ keŋ tigiŋ fʋ kʋʋ narapɔlɩ narɩkɩŋ a yɩ wa.’ ");
INSERT INTO kma_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ʋ chɔɔŋ wa die dɩ yiŋŋi a balɩ wa dɩ, ‘N bʋa, saŋŋa mana fʋ bie wo n jigiŋ, ta jadieke mana n yalla die dɩ yi fʋ sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama dɩ mʋ tɩ dime dʋʋga ta yallɩma sʋgɩfɩalɩŋ dama die tɩ yile dɩ fʋ nɩmbʋa wa gie kpiye mɩŋ, ama ta ʋ bie ʋ mɩsɩ ma, ta bɩ yile dɩ ʋ baya mɩŋ, ama lele tɩ ye wo mɩŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisa die dɩ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Ligiretieŋ wʋnyɩ die benne a yallɩ tʋntʋntʋ jakʋʋŋ ʋ daansa ʋ nyinti, die ba keŋ balɩ wa dɩ ʋ die ʋ ligirehe yɔrɩ yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Die wɩa die ʋ wa wa a balɩ wa dɩ, ‘Bɩa yine maŋ wʋmma fʋ wɩa dene? Kaaŋ bɩ yi n tʋʋma jakʋʋŋ, die wɩa biisi n nyinti mana aŋ n ye.’ ");
INSERT INTO kma_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ta tʋʋma jakʋʋrɩ die dɩ yile dɩ, ‘Bɩa maŋ baa n yi? N jakʋʋrɩ baa ʋ vʋarɩ mɩŋ mɩŋ tʋʋma ma. N ka hagɩrɩ a baaŋ nan kʋa, ta chɩga viivi n baaŋ nan jʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","N sɩba wudieke n baaŋ nan yi lele amʋ maŋ keŋ waarɩ tʋʋmaha vuosi nan tuo mɩŋ ba tige me.’ ");
INSERT INTO kma_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Die wɩa die ʋ wa vuodiekemba mana die dɩ dine ʋ jakʋʋrɩ hamɩŋ wʋnyɩ wʋnyɩ. Die ʋ pɩasɩ bʋmbʋŋaŋ vuoke dɩ, ‘N jakʋʋrɩ hamɩŋ aŋmɩa benne fʋ jigiŋ?’ ");
INSERT INTO kma_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Die ʋ yiŋŋi a balɩ wa dɩ, ‘Kpaatɩ gbiesi kɔbɩsɩ-nɩɩ.’ Daa wa dɩ balɩ wa dɩ, ‘Hamɩŋ gbanɩŋ wʋnna tuo kala lagɩ lagɩ a yiŋŋi maagɩ kɔbɩsɩ-nɩɩsa.’ ");
INSERT INTO kma_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta balɩ wʋnyɩ dɩaŋ, ‘Aŋmɩa fʋ gbaŋ fʋ dii?’ Ʋ yiŋŋi balɩ wa dɩ, ‘Zaa bɔtʋsɩ kobɩga.’ Ta daa wa dɩ balɩ, ‘Fʋ hamɩŋ gbanɩŋ wʋnna, yiŋŋi maagɩ baŋɩsɩ-nɩɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Die ligiretieŋ wo die dɩ wʋnna ʋ tʋʋmaha jakʋʋrɩ nyɩnyɩrɩtʋ wa dɩ yine die wo, die ʋ bɩrɩ wa, dama ʋ tʋŋ wa aŋaŋ yɩaŋ.” Yisa die dɩ balɩ ba dɩ, “Vuodiekemba dɩ dɩna tɩŋgbaŋka gie sieku yaa yɩaŋ ba sʋnsʋŋ a tɩaŋ vuodiekemba dɩ dɩna chaaŋkʋ sieŋ dɩ yalla die wo. ");
INSERT INTO kma_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Manɩŋ, n bala nɩ, nɩ nagɩ tɩŋgbaŋka gie ma ligire a yime wudieke Ŋmɩŋ dɩ yaalala, amʋ a keŋ kpatɩ saŋŋa dieke ʋ nan tuo nɩ arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Vuodieke mana dɩ mɩŋŋɩna tʋma tʋnbɩŋ vɩɩnɩŋ, nan bɩagɩ mɩŋŋɩ tʋŋ tʋnkpɩɩŋ vɩɩnɩŋ, ta vuodieke dɩaŋ dɩ nyɩrɩnana aŋaŋ ligiribiŋ, nan dɩ nyɩra aŋaŋ ligirikpɩɩma. ");
INSERT INTO kma_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dɩɩ yi fʋ nyɩra aŋaŋ tɩŋgbaŋka gie ligire, Ŋmɩŋ nan nagɩ arɩzanna ligire a yi fʋ nuusi me? ");
INSERT INTO kma_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ta dɩɩ yi fʋ nyɩra aŋaŋ vuoŋ nyinti, mɩnɩa bala ʋ yɩ fʋ fʋ tʋaŋ? ");
INSERT INTO kma_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yɔmʋ kaaŋ bɩagɩ a jɩama naalɩŋ bale. Ʋ nan haa wʋnyɩ ta chome wʋnyɩ, yaa ʋ nan yɩ wʋnyɩ jɩlɩma ta wʋnyɩ ʋ nine kaaŋ dɩ suuli. Vuoŋ kaaŋ bɩagɩ a jɩama Ŋmɩŋ aŋaŋ ligire.” ");
INSERT INTO kma_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Die Farasisisi die dɩ wʋŋ wɩaha gie mana, ta die a vʋara Yisa fala, dama die ba yaala ligire wɩa pam. ");
INSERT INTO kma_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Die Yisa dɩ balɩ a yɩ ba dɩ, “Nɩnɩŋ nɩ yine vuodiekemba dɩ yinene nɩ gbaŋ sɩba vuovɩɩna vuosi nɩŋŋa, ama Ŋmɩŋ sɩba nɩ sʋgɩtɩ ma. Dama jadieke vuota dɩ yilinene dɩ ka yaa nyʋarɩ pam wa, Ŋmɩŋ jigiŋ nɩŋ ka yiwo jatɔgʋ. ");
INSERT INTO kma_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosisi mɩraha aŋaŋ Ŋmɩŋ naazʋalɩba die dɩ maagɩna wudiekemba ba die beri mɩŋ a keŋ tʋgɩ Jɔɔn vuodieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ saŋka, a nyɩŋ Jɔɔn keniŋ saŋka ba mʋʋla Ŋmɩŋ wʋvɩɩna yaa gamma ʋ naarɩ ma, ta vuoŋ mana dɩ mɩa dɩ ba juu mi. ");
INSERT INTO kma_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie nan keŋ tɩaŋ ga ama Ŋmɩŋ mɩraha wʋbiŋ gbaŋ kaaŋ tɩaŋ ga. ");
INSERT INTO kma_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Daa dieke mana dɩ keŋ zeti ʋ hɔgʋ ta yiŋŋi faarɩ hɔgʋ gaaŋ yiwo hɔgʋkpana tʋʋma, ta dembiŋ dieke dɩaŋ dɩ faarɩna hɔgʋ wa yiwo hɔgʋkpana tʋʋma.” ");
INSERT INTO kma_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ta Yisa die dɩ bɩ balɩ ba dɩ, “Nyintitieŋ wʋnyɩ die benne a yeegi nyiŋyeeki dieke dɩ yalla ligire pam ta bie ʋ dʋŋŋʋ aŋaŋ sʋgɩfɩalɩŋ daaŋ mana. ");
INSERT INTO kma_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta die daa zɔɔlɩntieŋ wʋnyɩ dɩaŋ die benne ba wasa wa Lazurusi, ta die ʋ yaa kʋjaga pam. Die ba ŋaaŋ yaa wa a keŋ dʋaŋ nyintitieŋ wo sanʋaŋ ma, ");
INSERT INTO kma_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","die ʋ ŋaaŋ yaala ʋ dii wo nyintitieŋ wo nyindiiki chʋata dɩ ŋaana nanna tɩŋgbaŋ; die gbaasɩ gbaŋ dɩ keŋ lansa ʋ kʋjagaha. ");
INSERT INTO kma_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“A kʋaŋ chaaŋ zɔɔlɩntieŋ wo die dɩ kpi, malakasi die dɩ keŋ chii wo a ga Abarahami jigiŋ arɩzanna ma. Ta nyintitieŋ wo dɩaŋ dɩ keŋ kpi, die ba guu wo. ");
INSERT INTO kma_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Die ʋ ga bie kpiiliŋ jigiberisikiŋ, die dɩ wʋmma wa pam. Die ʋ daansɩ a ye Abarahami saasaa, ta Lazurusi kalɩ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Die wɩa die nyintitieŋ wo die dɩ natɩ a wa dɩ, ‘N chʋa Abarahami, chɩgɩ mɩŋ zɔɔlɩŋ ta fʋ tʋŋ Lazurusi ŋaŋ ʋ ga nagɩ nuubiŋ a luo nyaaŋ ma a keŋ gbi n jiliŋ, dama n paalɩ die wahala bolibu gie me.’ ");
INSERT INTO kma_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama Abarahami die dɩ balɩ wa dɩ, ‘N bʋa, tɩɩnsɩ dɩ die fʋ benne fʋ mɩsɩ ma wa, die ye wo nyɩnvɩɩna, ta Lazurusi dɩ ye nyɩnbɩatɩ mana, ama lele ʋ bie wo nansɩŋ ma giena ta fʋ bie wahala ma. ");
INSERT INTO kma_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta wudieke dɩ gʋtɩna yine, gulikpeŋkpɩɩŋ benne tɩnɩŋ aŋaŋ fʋ sʋnsʋŋ, die wɩa vuodiekemba dɩ benne gie a yaala ba gasɩ a keŋ fʋ jigiri kaaŋ bɩagɩ, ta vuodieke dɩ benne fʋ jigiri dɩ yaala ba gasɩ a keŋ tɩ jigiŋ dɩaŋ kaaŋ bɩagɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Die nyintitieŋ wo dɩ balɩ wa dɩ, ‘Jakʋʋŋ Abarahami, die nɩŋ n jʋʋsa fʋ, tʋŋ Lazurusi aŋ ʋ ga n chʋa tigiŋ me, ");
INSERT INTO kma_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","n yaa wa n nɩmballɩ banʋ, vaa ʋ ga a ga kpaaŋ ba amʋ ba gbaŋ ba da keŋ keŋ wahalaka gie jigiŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Die Abarahami dɩ baarɩ dɩ, ‘Fʋ nɩmballɩ yaa Mosisi aŋaŋ Ŋmɩŋ naazʋalɩba wɩa Ŋmɩŋ gbaŋkʋ ma. Ba wʋmma ha.’ ");
INSERT INTO kma_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ta nyintitieŋ wo dɩ yiŋŋi balɩ wa dɩ, ‘Jakʋʋŋ Abarahami, aayɩ, die nyɩɩna ma ka mʋ; ama dɩɩ yi vuoŋ dɩ nyɩŋ kuŋ me a ga ba jigiŋ ba nan chɩgɩ nyɩŋ ba tʋntʋmbɩatɩ ma.’ ");
INSERT INTO kma_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ama die Abarahami dɩ balɩ wa dɩ, ‘Dɩɩ yi ba kaaŋ wʋŋ Mosisi aŋaŋ Ŋmɩŋ naazʋalɩba dɩ maagɩna wudieke Ŋmɩŋ gbaŋkʋ ma wa, ba kaaŋ tarɩgɩ ba sʋŋanyile dɩɩ yi ta vuoŋ dɩ hagɩ kuŋ me gbaŋ a ga ba jigiŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Womi Yisa dɩ balɩ yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ da yilime dɩ magɩsɩŋ kaaŋ keŋ; ama wʋbɩaŋ bie vuodiekemba dɩ vanana ba chanchaalɩŋ dɩ yie bɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ba tɩŋ nagɩ nɩɩŋ a bɔbɩ a yeegi ʋ nyie a nagɩ wa a taaŋ nyaakpɩɩŋ ma dɩ tɩŋ nan dɩ kpɩa a tɩaŋ ʋ baaŋ nan yi ballɩbɩsɩ gie wʋnyɩ yi bɩaŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Die wɩa nɩ yigi nɩ gbaŋ! “Dɩɩ yi fʋ nɩmbʋa dɩ yi fʋ bɩaŋ, kpaaŋ wa; ama dɩɩ yi ʋ baarɩ dɩ ʋ chʋʋsɩ fʋ mɩŋ, fʋ nagɩ ʋ taalɩ a chaa wa. ");
INSERT INTO kma_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dɩɩ yi ʋ yi fʋ bɩaŋ bʋyʋpɔyɩ dabalɩmɩŋ, ama ta yiŋŋi keŋ fʋ jigiŋ bʋyʋpɔyɩ a baarɩ dɩ ʋ chʋʋsɩya, fʋ nagɩ ʋ taalɩ a chaa wa.” ");
INSERT INTO kma_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Saŋŋa kaanɩ die tɩ Yɔmʋtieŋ Yisa tʋntʋntɩba dɩ balɩ yɩ wa dɩ, “Vaa tɩ yadaka gʋtɩ.” ");
INSERT INTO kma_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Die ʋ yiŋŋi balɩ ba dɩ, “Dɩɩ yi nɩ yaa yada sɩba kaŋmɩŋ biŋ, nɩ nan bɩagɩ a balɩ yɩ tɩɩkpɩɩka gie dɩ, ‘Vʋʋ a ga nan nyaakpɩɩbʋ gie me’ aŋ ka seŋ a tuo fʋ nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Dɩɩ yi ta nɩ wʋnyɩ dɩ yallɩ tʋntʋntʋ ta ʋ kʋa yaa ta daansa yiise, ta ʋ keŋ nyɩŋ kʋaŋ a keŋ tigiŋ, nan balɩ wa dɩ, ‘Keŋ lagɩ a keŋ kala dii nyindiike?’ ");
INSERT INTO kma_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aayɩ, nan balɩ wa dɩ, ‘Vʋarɩ fʋ kʋaŋ nyinti ta yeegi nyɩnvɩɩna a yi n nyindiike a zieŋ mɩŋ aŋ n keŋ dii ta nyuu, ka kʋaŋ chaaŋ fʋ gbaŋ fʋ dii ta nyuu.’ ");
INSERT INTO kma_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Fʋ yile dɩ jakʋʋrɩ nan waasɩ tʋntʋntʋ wa ʋ yine wudieke ʋ bala wa dɩ ʋ yi wo? Aayɩ. ");
INSERT INTO kma_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Die gbaŋ dɩ sɩɩ nɩ jigiŋ, saŋŋa dieke nɩ keŋ tʋŋ tʋŋ dieke Ŋmɩŋ dɩ bala dɩ nɩ yiwo a kpatɩ, nɩ balɩ dɩ, ‘Tɩ yiwo tʋntʋntɩŋ nyɩɩna. Tɩnɩŋ tɩ yiwo wudieke dɩ mʋna tɩ yi nyɩɩna.’ ” ");
INSERT INTO kma_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisa die dɩ ganana Jerusalemi die ʋ daagɩ Samaria aŋaŋ Galili sʋnsʋŋ aŋaŋ sʋnsʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Die ʋ gana ga juo tɩŋkpaŋŋɩ kaanɩ; ta gama baŋ die dɩ keŋ tuoli wo mi. Die ba zie saasaa, ");
INSERT INTO kma_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ta faasɩ natɩ a baarɩ dɩ, “Jakʋʋŋ Yisa, chɩgɩ tɩ zɔɔlɩŋ!” ");
INSERT INTO kma_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yisa die dɩ ye be ta balɩ yɩ ba dɩ, “Nɩ gamma Ŋmɩŋ kɩkaabɩtʋ jigiŋ aŋ ba jɩɩŋ nɩ ye.” Die ba benne sieku me a gara wa die ba ye gbaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ta die ba wʋnyɩ die dɩ yiŋŋi keŋ Yisa jigiŋ dama die ʋ sɩba a baarɩ dɩ Yisa gbaanna wa, a keŋ bɩrɩ Ŋmɩŋ aŋaŋ lɔlɩkpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A die nagɩ ʋ gbaŋ a taaŋ Yisa nɩŋŋa ta waasa wa; ama die daa wa die yiwo Samaria vuoŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yisa die dɩ pɩasɩ dɩ, “Daa vuosi baŋ die yene gbaamɩŋ? Ama bawayɩ wa bie sɩa? ");
INSERT INTO kma_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba wʋnyɩ ka keŋ dɩ ba bɩrɩ Ŋmɩŋ sie chaanʋ wa gie?” ");
INSERT INTO kma_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ta die wa balɩ daa wa dɩ, “Hagɩ a ga, fʋ yada gbaanna fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mi die Farasisi bataŋ die dɩ pɩasɩ Yisa saŋŋa dieke Ŋmɩŋ naarɩ dɩ balla ka keŋ. Die ʋ yiŋŋi balɩ ba dɩ, “Ka ka yi sɩba nɩ nan daansɩ a ye Ŋmɩŋ naarɩ dɩ balla ka keŋ die. ");
INSERT INTO kma_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Vuoŋ wori a baaŋ baarɩ dɩ, ‘Daansɩ, ka wʋnna’, yaa ‘Ka benne mi wo’; dama Ŋmɩŋ naarɩ bie nɩ sʋgɩtɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mi die ʋ balɩ yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Saŋŋa kieŋ nɩ nan dɩ yaala nɩ ye manɩŋ vuota Bʋa keniŋ, ama nɩ kaaŋ ye. ");
INSERT INTO kma_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ba nan daansɩ balɩ nɩ, ‘Ye, ʋ benne mi wo’ yaa ‘Ye, ʋ bie giena.’ Ama nɩ da keŋ nyɩŋ a dɩ dɩa yaalɩma mɩŋ; ");
INSERT INTO kma_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","dama manɩŋ vuota Bʋa keniŋ nan dɩ sɩɩ sɩba nɩɩnyɩgɩsɩŋ dɩ ŋaana nyɩgɩsɩ a chaaŋ ŋmɩŋsikpeŋ mana a nyɩŋ tɩŋ chɩaŋ a ga tʋgɩ tɩŋ sikpeŋ die wo. ");
INSERT INTO kma_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama sie n woliŋ dii wahala pam ta leleke gie vuosi bɩ zeti mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Die dɩ sɩna die Nowa saŋka, die gbaŋ gbaŋ dɩ baa dɩ sɩmma manɩŋ vuota Bʋa keniŋ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Die Nowa saŋka, vuosi die die mɩŋ ta nyuo ta faara hɔɔŋ, ta naga ba hɔgʋlɩaŋ a yɩa chʋllɩŋ, ta die a ga tʋgɩ daa dieke Nowa dɩ juune haarɩkpɩɩkʋ, ta die nyaakpɩɩbʋ die dɩ keŋ kʋʋ vuoŋ mana die dɩ wone haarɩkpɩɩkʋ ma wa. ");
INSERT INTO kma_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Loti saŋŋa gbaŋ die sɩɩ wa die; die vuoŋ mana die dɩ die ta nyuo, ta daa a yalla, ta bʋra ta mɩa tige; ");
INSERT INTO kma_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ama daa dieke Loti die dɩ nyɩnna Sodomi tɩka, ta boliŋ aŋaŋ maafajiribi die dɩ nyɩŋ ŋmɩŋsikpeŋ a keŋ kʋʋ ba mana. ");
INSERT INTO kma_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Naa dɩ baa dɩ sɩmma daa dieke manɩŋ vuota Bʋa dɩ balla n keŋ wo. ");
INSERT INTO kma_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Dɩnɩŋ daarɩ mi daa dieke dɩ benne mampili sikpeŋ da keŋ a sʋʋŋ ʋ juoku sikpeŋ dɩ ʋ ga a nagɩ ʋ nyinti; ta vuodieke dɩaŋ dɩ benne ʋ kʋaŋ ma da keŋ yiŋŋi a kuli tigiŋ dɩ ʋ ga a nagɩ ʋ nyinti. ");
INSERT INTO kma_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nɩ tɩɩnsɩ Loti hɔgʋ wa wɩaha. ");
INSERT INTO kma_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Vuodieke mana dɩ kpaŋŋɩnana ʋ gbaŋ dɩ ʋ gbatɩ ʋ miivoli nan waarɩ ka, ama vuodieke mana dɩ waarɩna ʋ miivoli n wɩa nan daansɩ ye ke. ");
INSERT INTO kma_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","N bala nɩ, saŋŋa dieke n baaŋ nan keŋ wo, vuosi bale nan dɩ dʋa jadʋakɩbalɩmɩŋ ma, ta n nagɩ wʋnyɩ ta vaa wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hɔɔŋ bale nan dɩ nʋma zaa nɩa ma, ta n nagɩ wʋnyɩ ta vaa wʋnyɩ. (( ");
INSERT INTO kma_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Saŋka mi dembisi bale nan dɩ tʋma kʋaŋ ma, ta n nan nagɩ wʋnyɩ ta vaa wʋnyɩ.))” ");
INSERT INTO kma_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ta ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasɩ wa dɩ, “Tɩ Yɔmʋtieŋ, sɩa?” Ta ʋ yiŋŋi balɩ ba dɩ, “Jigidieke jakpiikiŋ dɩ benne, mi zuuti dɩ lagɩsa.” ");
INSERT INTO kma_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Saŋka mi Yisa die dɩ taaŋ ba nandagɩrɩ gie dɩ ʋ dagɩ ba dɩ dɩ mʋ ba jʋʋsɩma Ŋmɩŋ saŋŋa mana, ta da keŋ gbalɩgɩma, die ʋ balɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Sarɩya diiru wʋnyɩ die benne tɩŋ kaanɩ ma, die ʋ ka chɩga Ŋmɩŋ ta ka bɩ yɩa vuota jɩlɩma. ");
INSERT INTO kma_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta kpihɔgʋ wʋnyɩ dɩaŋ die benne tɩka ma, a chʋŋ gara daa wa jigiŋ a jʋʋsa wa dɩ, ‘Dii n wɩɩrɩ gie a yɩ mɩŋ aŋaŋ vuodieke dɩ mugisinene mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ama die sarɩya diiru wo die ka saaga, ta ka kʋaŋ chaaŋ die ʋ yile dɩ, ‘N ka wɔŋ chɩga Ŋmɩŋ yaa a yɩa vuota jɩlɩma, ");
INSERT INTO kma_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ama kpihɔgʋ wa gie dɩ faasɩna daama mɩŋ wɩa, n ko baa n dii ʋ sarɩya ka a yɩ wa mɩŋ, dɩ daa die ʋ nan dɩ kieŋ daaŋ mana ta vaa n gbalɩgɩ aŋaŋ wa.’ ” ");
INSERT INTO kma_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tɩ Yɔmʋtieŋ die baarɩ dɩ, “Nɩ wʋmma wudieke sarɩya diiru wo dɩ kana ka chɩga Ŋmɩŋ dɩ balla. ");
INSERT INTO kma_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta lele, Ŋmɩŋ kaaŋ dii sarɩya a yɩ ʋ vuovʋarɩka, vuodiekemba dɩ jʋʋsɩnana wa ŋmɩntʋasɩ aŋaŋ yuŋ dɩ ʋ suŋŋi be wo? Ʋ nan dɩ yʋasa dɩ ʋ suŋŋi be? ");
INSERT INTO kma_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N bala nɩ, ʋ nan dii sarɩya a yɩ ba, ta yi ke lagɩ lagɩ. Manɩŋ vuota Bʋa dɩ keŋ keŋ saŋŋa dieke, n nan ye vuodieke dɩ yine mɩŋ yada tɩŋgbaŋka gie me?” ");
INSERT INTO kma_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yisa die dɩ bɩ a taaŋ nandagɩrɩ gie a yɩ vuodiekemba dɩ bala dɩ ba yiwo vuovɩɩna, ama ta ka yɩa ba chanchaalɩŋ jɩlɩma. ");
INSERT INTO kma_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Die ʋ baarɩ dɩ, “Dembisi bale die nyɩnna a ga Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ dɩ ba jʋʋsɩ Ŋmɩŋ; wʋnyɩ die yiwo Farasisi vuoŋ, wʋnɩŋ wa dɩaŋ dɩ yi lampotuosiru. ");
INSERT INTO kma_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Die Farasisi vuoke dɩ ga zie lʋgɩŋ a jʋʋsɩ Ŋmɩŋ ʋ sʋŋ ma dɩ, ‘Ŋmɩŋ, n waasa fʋ, dama n ka yi tʋntʋmbɩatɩ tieŋ sɩba n chanchaalɩba. N ka yi halɩ tieŋ, n ka yi ŋmɩŋchɩbɩtieŋ yaa dembiŋ dieke dɩ yaala hɔɔŋ. N bɩ waasa fʋ dama n ka sɩɩ sɩba lampotuosiru wo gie. ");
INSERT INTO kma_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","N ŋaaŋ bɔba nʋaŋ daraa ale daraa yʋpɔyɩ mana sʋŋ, ta yɩa fʋ n nyinti baŋ mana sʋŋ kaanɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama die lampotuosiru wo die dɩ ga a zie saasaa, ta ka yaala ʋ kɔtɩ ʋ sikpeŋ ŋmɩŋsikpeŋ, ta vigi ʋ sikpeŋ ta baarɩ dɩ, ‘Nabidie Ŋmɩŋ, chɩgɩ mɩŋ zɔɔlɩŋ, dama n yiwo tʋntʋmbɩatɩ tieŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisa die dɩ bɩ baarɩ dɩ, “N bala nɩ, die dɩ yiwo lampotuosiru wo Ŋmɩŋ dɩ tuo ʋ jʋʋsɩŋ daa Farasi vuoke; dama vuodieke mana dɩ kɔtɩna ʋ gbaŋ ŋmɩŋsikpeŋ, Ŋmɩŋ nan sʋʋŋ wa tɩŋgbaŋ; ta vuodieke dɩaŋ dɩ sʋʋna ʋ gbaŋ tɩŋgbaŋ, Ŋmɩŋ nan kɔtɩ wa ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Die vuosi bataŋ die dɩ chii ba ballɩnyaalɩsɩ a keŋ Yisa jigiŋ dɩ ʋ nagɩ ʋ nuusi a dɩɩsɩ dɩɩsɩ ba ma, ama die ʋ kʋaŋandɩɩsɩrɩba dɩ yene naa wa, die dɩ nata ba. ");
INSERT INTO kma_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ta Yisa die dɩ wa ballɩbɩsɩsɩ dɩ ba kiere ʋ jigiŋ, ta balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ vaa ballɩbɩsɩsɩ kiere n jigiŋ ta nɩ da kagɩ ba sieŋ dama ba chanchaalɩŋ sɩna Ŋmɩŋ naarɩ. ");
INSERT INTO kma_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wusie maŋ bala nɩ, vuodieke mana dɩ kana ka tuo Ŋmɩŋ naarɩ sɩba bʋabiŋ, kaaŋ wɔŋ juu ke.” ");
INSERT INTO kma_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Saŋka mi jakʋʋŋ wʋnyɩ die dɩ keŋ Yisa jigiŋ a pɩasɩ wa dɩ, “Dɩdagɩrʋ vɩɩnɩŋ, lalɩa maŋ nan yi ta ye miivoli dieke dɩ wone kpatɩŋ?” ");
INSERT INTO kma_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Bɩa wɩa fʋ wasa mɩŋ vuovɩɩnɩŋ? Vuoŋ wori a yi vuovɩɩnɩŋ, sie Ŋmɩŋ nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wɔŋ sɩba Ŋmɩŋ mɩraha: ‘Da keŋ yaalɩ vuoŋ hɔgʋ yaa vuoŋ chʋrʋ, da keŋ a kʋʋ vuoŋ, da keŋ a gaarɩ, da keŋ yi ŋmɩnchɩbɩsɩ daansɩatieŋ, yɩma fʋ chʋa aŋaŋ fʋ naa jɩlɩma.’ ” ");
INSERT INTO kma_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Die daa wa dɩ yiŋŋi a balɩ dɩ, “N yine bʋabiŋ mana a yaa ga mʋʋna, n dɩɩ mɩraha gie mana mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yisa die dɩ wʋnna naa, die ʋ balɩ yɩ wa dɩ, “Wʋbalɩmɩŋ tɩala fʋ. Nagɩ fʋ nyinti mana a daa ta nagɩ ligirehe a yɩ zɔɔlɩntieliŋ, ta nan dɩ yallɩ nyinti arɩzanna ma; ta a kʋaŋ chaaŋ fʋ keŋ dɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ama daa wa die dɩ wʋnna naa, ʋ sʋŋ die dɩ paalɩ chʋʋsɩ, dama die ʋ faasɩ yallɩ wa nyinti pam. ");
INSERT INTO kma_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisa die dɩ mɩŋŋɩ dɩ ʋ sʋŋ chʋʋsɩya mɩŋ, ta baarɩ dɩ, “Dɩ tʋa pam dɩ nyintitieliŋ juu Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dɩ faasɩ tʋa mɩŋ dɩ nyintitieŋ juu Ŋmɩŋ naarɩ ma a tɩaŋ nyɔgɩnɩ dɩ baaŋ nan daagɩ garɩyɩɩŋ vɔrɩŋ ma a nyɩŋ dene.” ");
INSERT INTO kma_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Die vuodiekemba die dɩ wʋnna wa wa die dɩ pɩasɩ dɩ, “Die nɩŋ manɩa baaŋ nan ye gbatɩtaanɩŋ?” ");
INSERT INTO kma_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Wudieke vuota dɩ kana kaaŋ bɩagɩ a yi, Ŋmɩŋ nɩŋ nan bɩagɩ a yi.” ");
INSERT INTO kma_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ta Piita dɩ balɩ wa dɩ, “Ye, die tɩ va wa tɩ nyinti mana ta keŋ dɩ fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yisa die dɩ yiŋŋi a balɩ yɩ ba dɩ, “Wusie maŋ bala nɩ, vuodieke mana dɩ vana ʋ tigiŋ yaa ʋ hɔgʋ yaa ʋ nɩmballɩ yaa ʋ chɔɔŋ aŋaŋ nuŋ yaa ʋ ballɩ Ŋmɩŋ naarɩ wɩa, ");
INSERT INTO kma_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nan bɩ ye he pam tɩŋgbaŋka gie me a tɩaŋ ʋ vana nyindiekemba ba, saŋŋa dieke dɩ kienene wo, ʋ nan ye miivoli dieke dɩ wone kpatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Womi Yisa die dɩ yaa ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo a nyɩŋ lʋgɩŋ a balɩ ba dɩ, “Nɩ wʋmma, tɩ gara Jerusalemi, jigidieke ba bala ba yi manɩŋ vuota Bʋa wudiekemba mana die Ŋmɩŋ naazʋalɩba dɩ maagɩna yaa gamma n wɩa wa, ");
INSERT INTO kma_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","dama ba nan nagɩ mɩŋ a yɩ vuodiekemba dɩ kana a ka yi Juu vuosi nuusi me, dɩ ba vʋarɩ mɩŋ fala ta bɩ zɩa mɩŋ ta tɩɩrɩ nɩntɔbɩtɩ a yi mɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","a nɩgɩ mɩŋ aŋaŋ kpaasɩŋ ta kʋʋ mɩŋ ama daraa ataa daraaŋ n nan hagɩ kumbu me.” ");
INSERT INTO kma_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama die ʋ kʋaŋandɩɩsɩrɩba die ka sɩba wɩaha kaanɩ gbaŋ chɩaŋ, dama Ŋmɩŋ die ligi wo ba yɩaŋ, die yine die ba ka sɩba wudieke ʋ balala wa chɩasɩ. ");
INSERT INTO kma_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisa die dɩ kenne gbige Jeriko daa yɩɩ wʋnyɩ die dɩ kalɩ sieku nʋaŋ a jʋʋsa. ");
INSERT INTO kma_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Die ʋ wʋnna ta kpɩkpaakʋ chʋŋ tɩanna wa, die ʋ pɩasɩ dɩ, “Bɩa yinene?” ");
INSERT INTO kma_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Die ba balɩ wa dɩ, “Yisa, vuodieke dɩ yine Nazeriti vuoke tɩannana.” ");
INSERT INTO kma_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Die ʋ faasɩ wa dɩ, “Yisa, Davidi haagɩŋ, chɩgɩ mɩŋ zɔɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ama vuodiekemba die dɩ benne nɩŋka die dɩ natɩ wa ta balɩ wa dɩ ʋ tarɩ watɩ, ama die ʋ faasɩ nata dɩ, “Davidi haagɩŋ, chɩgɩ mɩŋ zɔɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Die wɩa Yisa die dɩ zie ta yɩ nʋaŋ dɩ ba yaa daa wa a keŋ ʋ jigiŋ. Die ʋ kenne a gbigi wo, Yisa die dɩ pɩasɩ wa dɩ, ");
INSERT INTO kma_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bɩa fʋ yaala n yi a yɩ fʋ?” Die ʋ yiŋŋi baarɩ dɩ, “N Yɔmʋtieŋ, n yaala fʋ yuori n ninehe mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mi Yisa die dɩ balɩ wa dɩ, “Yesime, fʋ yine yada ka wɩa fʋ ye gbaamɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lele womi die ʋ ninehe dɩ yuori, die ʋ dɩ Yisa ta bɩra Ŋmɩŋ. Die kpɩkpaakʋ dɩ yene wo wo, die ba mana dɩ bɩrɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ka kʋaŋ chaaŋ Yisa die dɩ ga a juu Jeriko a chʋŋ tɩanna. ");
INSERT INTO kma_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta daa wʋnyɩ die dɩ bie mi ba wasa wa Zakiyosi, die ʋ yiwo lampotuosiriŋ jakʋʋŋ, ta die yaa nyinti pam. ");
INSERT INTO kma_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Die ʋ mɩa ʋ ye Yisa dɩ yine vuodieke, ama die ʋ yine vuogobiri wɩa die ʋ ka bɩagɩ ye wo dama vuosi die dala mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Die wɩa die ʋ chɩgɩ a dɩ kpɩkpaakʋ nɩŋŋa a ga jʋalɩ chunchuliŋ tɩɩŋ dɩ ʋ ye Yisa, dama die ʋ gara mi chaaŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisa die dɩ kenne a tʋgɩ mi wo, ʋ daansɩ ŋmɩŋsikpeŋ ta balɩ yɩ wa dɩ, “Zakiyosi, keŋ sʋʋŋ lagɩ lagɩ. Sie n yi fʋ chaanʋ jinne.” ");
INSERT INTO kma_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ta Zakiyosi die dɩ yi lagɩ lagɩ a keŋ sʋʋŋ ta waasɩ wa aŋaŋ sʋgɩfɩalɩkpeŋkpɩɩŋ ta yaa wa ga ʋ tigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ta vuodiekemba mana die dɩ yene wo die dɩ piili a vʋʋna wɩa dɩ, “Daa wa gie ga bɩrɩŋ wa chaanʋ tʋntʋmbɩatɩ tieŋ wo tigiŋ me.” ");
INSERT INTO kma_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A kʋaŋ chaaŋ die Zakiyosi dɩ hagɩ a zie a balɩ yɩ tɩ Yɔmʋtieŋ Yisa dɩ, “N Yɔmʋtieŋ, wʋmma, n nan puo nyindiekemba n yalla bule ta nagɩ kaanɩ a yɩ zɔɔlɩntieliŋ; ta dɩɩ yi maŋ nyɩrɩ wa vuoŋ, n nan yiŋŋi tuŋ wo die bʋnɩɩsa.” ");
INSERT INTO kma_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yisa die dɩ balɩ wa dɩ, “Gbatɩtaanɩŋ keŋ tigiri gie vuosi me jinne, dama fʋ gbaŋ yiwo Abarahami haagɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Manɩŋ vuota Bʋa keŋye mɩŋ dɩ n yaalɩ vuodiekemba dɩ bana ta ye be a gbatɩ ba taaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Die vuosi die dɩ yene a wʋmma wɩaha gie wo, Yisa die dɩ bɩ a taaŋ ba nandagɩŋ, dama die ba yile dɩ Yisa dɩ gbigine Jerusalemi wɩa, Ŋmɩŋ naarɩ die baa ka keŋ wo lagɩ lagɩ. ");
INSERT INTO kma_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Die wɩa die ʋ baarɩ dɩ, “Daa jakʋʋŋ wʋnyɩ die gana tɩŋgbaŋ saasaa dɩ ba ga kalɩŋ wa naa, ta ʋ yiŋŋi keŋ tigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Die ʋ balla ʋ ga wa die ʋ wa ʋ tʋntʋntɩŋ baŋ, ta yɩ yɩ ba salɩma bie kaanɩ kaanɩ, ta balɩ yɩ ba dɩ, ‘Nɩ nagɩ ligirehe gie a tʋŋ tʋʋma a ga tʋgɩ saŋŋa dieke n baaŋ nan viiri keŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ama die ʋ tɩka vuosi die ka yaala ʋ wɩa, die wɩa die ba tʋŋ tʋntʋntɩŋ dɩ ba ga balɩ naakpɩɩka dɩ ba ka yaala daa wa gie yi ba naaŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ama die daa jakʋʋrɩ dɩ ga dii naarɩ ta yiŋŋi keŋ tigiŋ. Die ʋ kenne wo, die ʋ wa ʋ tʋntʋntɩba die ʋ yɩna ba ligirehe a lagɩsɩ, dɩ ʋ yaala ʋ ye ba yene nyʋarɩ die a gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nɩŋŋaŋ vuoke die dɩ keŋ a baarɩ dɩ, ‘Jakʋʋŋ, n ye wo salɩma bie baŋ a gʋtɩ fʋ yɩna mɩŋ jadieke wo ma.’ ");
INSERT INTO kma_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Die jakʋʋrɩ dɩ baarɩ dɩ, ‘Kpaŋŋɩ fʋ gbaŋ, yiwo tʋntʋntʋ vɩɩnʋ. Fʋ mɩŋŋɩna a pɔgɩlɩ jabike wɩa, n nan nagɩ tɩgɩsɩ baŋ a yi fʋ nuusi me.’ ");
INSERT INTO kma_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Die vuodieke dɩ diisine wo dɩ keŋ a baarɩ dɩ, ‘Jakʋʋŋ, n ye wo salɩma ligire bie anʋ a gʋtɩ jadieke fʋ yɩna mɩŋ wa ma.’ ");
INSERT INTO kma_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jakʋʋrɩ die dɩ balɩ a yɩ geŋ wo dɩaŋ dɩ, ‘N nan nagɩ tɩgɩsɩ anʋ a yi fʋ nuusi me.’ ");
INSERT INTO kma_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Wʋnyɩ dɩaŋ dɩ keŋ a baarɩ dɩ, ‘Jakʋʋŋ fʋ ligire bini wʋnna, die n nagɩ vili wo gachɔɔtɩŋ ma a nagɩ lɔbɩrɩ, ");
INSERT INTO kma_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","dama die n chɩga fʋ wa ŋmaamɩŋ, dama yiwo vuodieke wɩa dɩ tʋana. Naga jadieke dɩ kana a ka yi fʋ jaaŋ, ta gobe jadieke fʋ kana ka bʋrɩya.’ ");
INSERT INTO kma_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ta jakʋʋrɩ die dɩ balɩ yɩ wa dɩ, ‘Fʋnɩŋ tʋntʋntɩ bɩaŋ, n nan nagɩ fʋ gbaŋ gbaŋ fʋ wʋbalɩka a dii fʋ sarɩya. Sɩba a baarɩ n yiwo vuodieke wɩa dɩ tʋana, ta naga jadieke dɩ kana ka yi n jaaŋ, ta gobe jadieke n kana ka bʋrɩya. ");
INSERT INTO kma_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bɩa yine ta fʋ ka nagɩ n ligirebu a paŋŋɩ aŋ ba yiŋŋi tuŋ mɩŋ aŋaŋ nyʋarɩ? Amʋ n tɩnna a keŋ naa n tɩŋ nan tuoke aŋaŋ nyʋarɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Womi die jakʋʋrɩ dɩ balɩ a yɩ vuodiekemba dɩ zene mi wo dɩ, ‘Nɩ tuo ligire bini a nyɩŋ ʋ jigiŋ ta nagɩ gʋtɩ vuodieke dɩ yalla ligire bie baŋ wa.’ ");
INSERT INTO kma_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Die ba yiŋŋi balɩ wa dɩ, ‘Jakʋʋŋ, ʋ wɔŋ yaa wa ligire bie baŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Die ʋ yiŋŋi a balɩ ba dɩ, ‘N bala nɩ, vuodieke dɩ yalla nyinti, ba nan yɩ wa pam a gʋtɩ, ama vuodieke dɩ wone wo jaaŋ, bɩta gbaŋ ʋ yalla wa ba nan tuoke a nyɩŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tɔ, lele n dataasɩ diekemba die dɩ kana ka yaala dɩ n dii naarɩ, nɩ ga yaa ba keŋ giena a kʋʋ ba n nɩŋŋa.’ ” ");
INSERT INTO kma_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisa die dɩ bala wɩaha a kpatɩ wa, die ʋ dɩ ba nɩŋŋa ba gara Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Die ʋ kenne gbigi Betifiji aŋaŋ Betani tɩgɩsɩ die dɩ benne kunkogiŋ dieke ba wasɩnana Olivi tɩɩsɩ kunkogiri, die ʋ tʋŋ ʋ kʋaŋandɩɩsɩrɩba bale a balɩ yɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nɩ gamma tɩŋkpaŋŋɩ dieke dɩ benne nɩ nɩŋŋa wa, nɩ die keŋ juo nɩ nan ye bonpɔlɩ dɩ bɔbɩna zie ta vuoŋ dɩ ye ka jʋalɩ ka. Nɩ forisi ke a yaa ka a keŋ giena. ");
INSERT INTO kma_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta dɩɩ yi vuoŋ dɩ pɩasɩ nɩ dɩ, ‘Bɩa nɩ forisi ke?’ Nɩ balɩ wa dɩ, ‘Tɩ Yɔmʋtieŋ yaalala ka.’ ” ");
INSERT INTO kma_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Die ba ga a ye wudieke gbaŋ gbaŋ die Yisa dɩ bala a yɩ ba wa. ");
INSERT INTO kma_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Die ba forisinene bonpɔlɩka, ka tieŋ die dɩ pɩasɩ ba dɩ, “Bɩa nɩ forise bonpɔlɩka?” ");
INSERT INTO kma_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Die ba yiŋŋi a balɩ wa dɩ, “Tɩ Yɔmʋtieŋ yaalala ka”, ");
INSERT INTO kma_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ta die ba datɩ ka a yaa ka a keŋ Yisa jigiŋ. Ta die ʋ kʋaŋandɩɩsɩrɩba die dɩ nagɩ gaatɩ a diisi bonka sikpeŋ ta suŋŋi Yisa dɩ jʋalɩ kalɩ ka ma. ");
INSERT INTO kma_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Die ʋ jʋalɩna a gara wa vuosisi dɩ nagɩ ba gaatɩ a jaatɩ sieku me. ");
INSERT INTO kma_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Die ʋ kenne a gbigi jigidieke sieku dɩ sʋʋna gara Olivi kunkogiri jigiri, ʋ kʋaŋanvuosi mana die dɩ piili a bɩra Ŋmɩŋ aŋaŋ sʋgɩfɩalɩŋ, ta bɩra wa aŋaŋ lɔlɩkpɩɩma yaa gamma mamachi wʋkpɩɩma dieke ba yene wo dɩ, ");
INSERT INTO kma_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ŋmɩŋ yi alibarika yi naaŋ dieke dɩ kienene Nabidie Ŋmɩŋ saaŋ ma. Sʋgɩdʋagɩŋ bemme arɩzanna ma, ta nɩ kɔtɩ Ŋmɩŋ saaŋ sikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mi Farasisi bataŋ die dɩ benne kpɩkpaakʋ ma wa die dɩ balɩ yɩ Yisa dɩ, “Dɩdagɩrʋ, balɩ fʋ kʋaŋanvuosisi dɩ ba tarɩ watɩ.” ");
INSERT INTO kma_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “N bala nɩ, dɩɩ yi ba tarɩ, ama tanaha dɩ dʋana wa nan dɩ nata a bɩra Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Die ʋ kenne gbigi Jerusalemi ta ye ke wo die ʋ kʋŋ ka wɩa, ");
INSERT INTO kma_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ta baarɩ dɩ, “Dɩ yiwo bɩaŋ dɩ jinne nɩ vuosi ka sɩba wudieke dɩ baaŋ dɩ yaa sʋgɩdʋagɩŋ a keŋ ba jigiŋ. Lele ka lɔbɩrɩya mɩŋ ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jerusalemi, saŋŋa nan keŋ fʋ dataasɩ nan mɩɩ gaamɩŋ a giliŋ fʋ lʋga mana dɩ ba tuoli fʋ. Sojasi nan taaŋ giliŋ fʋ jigiŋ mana. ");
INSERT INTO kma_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba nan ŋmabɩ fʋ mana ta kʋʋ fʋ vuosi. Ba nan chʋʋsɩ nɩ tige mana ta taŋ balɩmɩŋ kaaŋ wɩarɩ a beri ka jigiberisikiŋ. Naa mana nan keŋ yi dama nɩ kana ka mɩŋŋɩ saŋŋa dieke Ŋmɩŋ dɩ kenne dɩ ʋ gbatɩ nɩ a taaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ka kʋaŋ chaaŋ Yisa die dɩ ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ a piili a yaga vuodiekemba die dɩ daanana nyinti mi wo, ");
INSERT INTO kma_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ta bala yɩa ba dɩ, “Dɩ maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ Ŋmɩŋ baarɩ dɩ, ‘N tigiŋ baa ka yiwo Ŋmɩŋ jʋʋsɩŋ jigiŋ.’ Ama nɩ nagɩ ka a bɩrɩŋ wa gaarɩŋ jigiberisikiŋ?” ");
INSERT INTO kma_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Die daaŋ mana Yisa die bie wo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a daga vuosi Ŋmɩŋ wɩa. Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba aŋaŋ tɩka nyɩŋkʋraha die dɩ mɩa dɩ ba kʋʋ wa, ");
INSERT INTO kma_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ama die ba ka ye sie dieke ba baaŋ daagɩ yi die, dama vuotamba mana die chɩɩsa wʋmma ʋ wʋbalɩkaha ta ka yaala ba waarɩ ʋ wʋbalɩkaha kaanɩ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Daaŋ kaanɩ Yisa die dɩ bie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a daga vuotamba ta mʋʋla Ŋmɩŋ wʋvɩɩnaha a yɩa vuosi, ta Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba aŋaŋ tɩka nyɩŋkʋraha die dɩ keŋ ʋ jigiŋ, ");
INSERT INTO kma_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","a pɩasɩ wa dɩ, “Balɩ tɩ, mɩnɩa yiko me fʋ yie wɩaha gie? Mɩnɩa yɩna fʋ kanɩŋ yiko ke mi?” ");
INSERT INTO kma_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “N gbaŋ n baa n pɩasɩ nɩ wa wʋpɩasɩkɩŋ. Nɩ balɩ mɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jɔɔn vuodieke die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ, Ŋmɩŋ die yɩna wa kanɩŋ yiko ke mi yaa vuota?” ");
INSERT INTO kma_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Die ba piili a bala yɩa taŋ dɩ, “Wʋbɩa tɩ baa tɩ balɩ? Dɩɩ yi tɩ baarɩ dɩ Ŋmɩŋ yɩna wa yiko ke mi, ʋ nan baarɩ dɩ ta bɩa wɩa die tɩ ka yiwo yada? ");
INSERT INTO kma_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ta tɩ bɩ baarɩ dɩ, dɩ vuota die yɩna wa, kpɩkpaakʋ gie mana nan taa tɩ tana dama ba yi yada dɩ Jɔɔn die yiwo Ŋmɩŋ naazʋa.” ");
INSERT INTO kma_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Die wɩa die ba yiŋŋi balɩ dɩ, “Tɩ ka sɩba jigidieke die ka nyɩnna.” ");
INSERT INTO kma_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yisa die dɩ yiŋŋi a balɩ yɩ ba dɩ, “Die nɩŋ, n gbaŋ n kaaŋ balɩ nɩ, vuodieke dɩ yɩna mɩŋ yiko ke gie maŋ yaa yie wɩaha gie.” ");
INSERT INTO kma_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Womi Yisa die dɩ taaŋ vuotamba nandagɩrɩ gie dɩ, “Daa wʋnyɩ die sone tɩɩsɩ dɩ nyɩnana bie ʋ kʋaŋ ma, ta die nagɩ ka a yɩ tʋntʋntɩŋ nuusi me ta dɩa a ga jigiŋ a ga yʋasɩ. ");
INSERT INTO kma_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Die a kpaala saŋŋa dɩ tʋgɩ ʋ tʋŋ ʋ yɔmʋ tʋntʋntɩba jigiŋ dɩ ʋ ga tuo ʋ tʋaŋ a keŋ. Ama die tʋntʋntɩba die dɩ nɩgɩ ʋ yɔmʋ wa ta vaa ʋ yiŋŋi ga aŋaŋ nuuwɩaga. ");
INSERT INTO kma_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Die wɩa die ʋ bɩ tʋŋ yɔmʋ gaaŋ, tʋntʋntɩba die dɩ nɩgɩ wa ta nagɩ wa yi viivi me ta vaa ʋ viiri ga aŋaŋ nuuwɩaga. ");
INSERT INTO kma_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Womi die ʋ bɩ tʋŋ yɔmʋ dieke dɩ gʋtɩna bʋtaa ma, die ba yɩ wa daŋŋa ta vigi wa taaŋ. ");
INSERT INTO kma_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Womi kʋakʋ tieŋ die dɩ baarɩ dɩ ‘Bɩa maŋ baa yi? Die nɩŋ lele n nan tʋŋ n gbaŋ gbaŋ n bʋa dieke n chone. Wʋnɩŋ nɩŋ ba nan yɩ wa jɩlɩma.’ ");
INSERT INTO kma_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama die tʋntʋntɩba dɩ yene wo wo die ba balɩ yɩ taŋ dɩ, ‘Kʋakʋ tieŋ faarɩ diiru wʋnna. Nɩ vaa tɩ kʋʋ wa ta ʋ faarɩ yi tɩ sɩɩtɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Die wɩa die ba nagɩ wa a nyɩŋ kʋakʋ ma a ga kʋʋ wa.” Yisa die dɩ pɩasɩ ba dɩ, “Bɩa kʋakʋ tieŋ dɩ nan yi tʋntʋntɩba gie? ");
INSERT INTO kma_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ʋ nan keŋ a kʋʋ banɩŋ vuosi mi ta nagɩ kʋakʋ a yɩ vuogaasɩ.” Die vuosisi die dɩ wʋnna naa wa, ba baarɩ dɩ “Ŋmɩŋ nagɩ die a ga saasaa.” ");
INSERT INTO kma_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yisa die dɩ daansɩ ba ta pɩasɩ ba dɩ, “Ŋmɩŋ wɩɩrɩ gie chɩaŋ? Dɩ ‘Taŋ dieke mɩmɩɩrɩba die dɩ zetine ta baarɩ ba ka yaala ka wa die yine gɔŋgɔŋyʋgɩrɩŋ taŋ vɩɩnɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Vuodieke dɩ nanna tanɩ gie sikpeŋ nan ŋmabɩ ŋmabɩ ama vuodieke tanɩ dɩ keŋ nan ʋ sikpeŋ ʋ nan nʋŋ nʋŋ sɩba zɔŋ.” ");
INSERT INTO kma_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Die mɩraha dɩdagɩrɩba aŋaŋ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha die dɩ mɩŋŋɩna dɩ ba wɩa Yisa dɩ taana nandagɩrɩ gie wo, die ba mɩa dɩ ba yigi wo mi, ama die ba chɩga vuotamba ŋmaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Die wɩa die ba maansa daansa wa, die ba bɩ a yɩ mɩmaansɩ daansɩrɩba ligire dɩ ba ga Yisa jigiŋ a ga gaaŋ wa sɩba ba yiwo vuovɩɩna, ta pɩasɩ wa wʋpɩasɩka ta ye dɩ ʋ nan balɩ a chʋʋsɩ aŋ ba yigi wo a ga tɩka jakʋʋrɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Die mɩmaansɩ daansɩrɩba dɩ balɩ yɩ Yisa dɩ, “Dɩdagɩrʋ, tɩ sɩba baarɩ wudieke fʋ balala ta daga wa yiwo wusie, ta ka luge ama a daga Ŋmɩŋ sieŋ aŋaŋ wusie. ");
INSERT INTO kma_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Balɩ tɩ, tɩ mɩraha yɩ sieŋ mɩŋ dɩ tɩ tumme lampo a yɩma Romani tɩŋ naaŋ wa Siiza yaa tɩ da tumme?” ");
INSERT INTO kma_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama Yisa die dɩ mɩŋŋɩ ba sanna die wo, ta balɩ yɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nagɩ ligiribiŋ a dagɩ mɩŋ. Mɩnɩa nine chaaŋ aŋaŋ ʋ saaŋ diisine ka ma?” Die ba baarɩ dɩ, “Naaŋ Siiza.” ");
INSERT INTO kma_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ta Yisa dɩ balɩ yɩ ba dɩ, “Die nɩŋ nɩ nagɩ yɩ Naaŋ Siiza jadieke dɩ yine ʋ sɩɩtɩ ta nagɩ yɩ Ŋmɩŋ dɩaŋ jadieke dɩ yine Ŋmɩŋ sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Die ba ka bɩagɩ a yigi wo aŋaŋ wɩɩŋ vuosisi nɩŋŋa, die ʋ yiŋŋi balɩkʋ die yine be mamachi die ba ka bɩagɩ a balɩ wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Die Sadusisi bataŋ die dɩ keŋ Yisa jigiŋ; banɩŋ die ba balala dɩ vuosi kaaŋ daansɩ hagɩ kuŋ me; die ba pɩasɩ wa dɩ, ");
INSERT INTO kma_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Dɩdagɩrʋ, Mosisi die maagɩna mɩrɩka gie a yɩ tɩ dɩ, dɩɩ yi ‘Dembiŋ dɩ keŋ faarɩ ʋ hɔgʋ ta kpi ta wo ballɩ, dɩ mʋ daa wa mi nɩmbʋa faarɩ kpihɔgʋ wa amʋ ʋ mɩɩrɩ ballɩ a yɩ vuodieke dɩ kpine wo.’ ");
INSERT INTO kma_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Die dembisi bayʋpɔyɩ die benne a yi nɩmballɩ, jakʋʋrɩ chaaŋ die dɩ faarɩ hɔgʋ, ta ka mɩɩrɩ ballɩ ta kpi; ");
INSERT INTO kma_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","womi vuodieke dɩ diisine bule wo dɩ faarɩ hɔgʋ wa, ta ka mɩɩrɩ ballɩ ta kpi; ");
INSERT INTO kma_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","vuodieke dɩaŋ dɩ diisine bʋtaa gbaŋ dɩ faarɩ wa ta kpi ta ka mɩɩrɩ ballɩ. Vuotɩalɩkaha mana die dɩ faarɩ hɔgʋ wa ta kpi ta ka mɩɩrɩ ballɩ. ");
INSERT INTO kma_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ka kʋaŋ kʋaŋ chaaŋ hɔgʋ wa dɩaŋ dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lele, kuŋ hagɩŋ daraaŋ mɩnɩa hɔgʋ bala ʋ yi wo? Dama ba bayʋpɔyɩ wa mana die faarɩ wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Tɩŋgbaŋka gie vuosi faara hɔɔŋ ta naga ba lɩaŋ yɩa chʋllɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ama vuodiekemba dɩ mʋna aŋaŋ kuŋ hagɩŋ ta nan keŋ hagɩ a bemme dʋnɩa haalɩkʋ ma wa, ka faara hɔɔŋ yaa a naga ba lɩaŋ yɩ chʋllɩŋ, ");
INSERT INTO kma_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","dama ba kaaŋ bɩ kpi bɩbra; ba nan dɩ sɩɩ sɩba malakasi, ta bɩ yi Ŋmɩŋ ballɩ dama ba hagɩ wa kuŋ me. ");
INSERT INTO kma_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosisi gbaŋ die dagɩya dɩ kunti nan daansɩ a hagɩ kuŋ me. Mosisi die dɩ maagɩna yaa gamma tɩɩka diilehe, die ʋ wa wa tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ dɩ, ‘Abarahami Ŋmɩŋ aŋaŋ Aziki Ŋmɩŋ aŋaŋ Jakobu Ŋmɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Vuosi gie die wɔŋ kpi mɩŋ ama ba ye ko bie wo ba mɩsɩ ma dama Ŋmɩŋ ka yi wo kunti Ŋmɩŋ, ʋ yiwo vuodiekemba dɩ benne ba mɩsɩ ma ma Ŋmɩŋ, dama ʋ nɩŋŋa ba mana dɩ beri ba mɩsɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Die wɩa mɩraha dɩdagɩrɩba bataŋ dɩ balɩ a yɩ Yisa dɩ, “Dɩdagɩrʋ, mɩŋŋɩ a balɩ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Die wɩa die ba chɩga dɩ ba bɩ pɩasɩ wa wʋpɩasɩkɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yisa die dɩ balɩ yɩ ba dɩ, “Lalɩa ba baarɩ dɩ Ŋmɩŋ vuovʋarɩkɩrɩ Masia wa baa ʋ yiwo Davidi haagɩŋ? ");
INSERT INTO kma_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dama Ŋmɩŋ gbaŋkʋ sʋŋ, Davidi gbaŋ gbaŋ die maagɩya yɩla gbaŋkʋ sʋŋ dɩ ‘Nabidie Ŋmɩŋ die balɩ a yɩ n Yɔmʋtieŋ dɩ: kala n nuudiigiri gie chaaŋ ");
INSERT INTO kma_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","a ga tʋgɩ saŋŋa dieke n baaŋ nan nagɩ fʋ dataasɩ a yi fʋ nuusi me.’ ");
INSERT INTO kma_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidi die wasa Masia wa dɩ, ‘N Yɔmʋtieŋ’, ta lalɩa Masia wa dɩ bɩ baa ʋ yi Davidi haagɩŋ?” ");
INSERT INTO kma_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Die vuosi mana dɩ wʋnnana Yisa wa, die ʋ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, ");
INSERT INTO kma_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nɩ sɩmma vuodiekemba dɩ dagɩnana Ŋmɩŋ mɩraha, ba nan dɩ yaala ba yeegi guuwagɩtɩ a chʋmma giliŋ me, ta yaala ba wasɩma ba aŋaŋ jɩlɩma nyugiti ma, ba keŋ juu Ŋmɩŋ jɩamɩŋ juone me, ba ŋaaŋ yaala vuokpɩɩma jigikasɩka, ba keŋ laalɩŋ jigiŋ ba yaala sikpeŋ kpɩɩmatieliŋ jigikasɩka. ");
INSERT INTO kma_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Banɩŋ ba nyɩra kpihɔgʋba ta gbata ba nyinti mana, ta jʋʋsa Ŋmɩŋ aŋaŋ jʋʋsɩwagɩtɩ sɩba ba chɩga Ŋmɩŋ. Ba tɩbɩdatɩŋ nan faasɩ dala pam.” ");
INSERT INTO kma_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Womi Yisa die dɩ daansɩ tɩaŋ ye nyintitieliŋ dɩ nagɩnana piinisi a yie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ligire kpalɩ ma; ");
INSERT INTO kma_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ta die bɩ ye kpihɔgʋ zɔɔlɩntieŋ gbaŋ dɩ nagɩna kobusi ligiribie ale a yie kpalɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ta Yisa die baarɩ dɩ, “Wusie maŋ bala nɩ, kpihɔgʋ zɔɔlɩntieŋ wo gie nagɩ wa pam a yi a tɩaŋ vuoŋ mana, ");
INSERT INTO kma_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","dama ba mana vʋarɩ a nyɩŋ wa ba nyinti pam ma, ama kpihɔgʋ zɔɔlɩntieŋ wo gie nɩŋ nagɩ wa jadieke ʋ bala ʋ dii a keŋ yi.” ");
INSERT INTO kma_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Die bataŋ die dɩ bala yaa gamma Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ wɩa, die ba bala yaa gamma ka vɩɩnɩŋ aŋaŋ tanvɩɩna aŋaŋ piini dieke ba nagɩna a yɩ Ŋmɩnnɩ. Yisa die dɩ baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nɩ yene nyinti gie mana wa, ama saŋŋa kieŋ ta taŋ balɩmɩŋ gbaŋ kaaŋ wɩarɩ ka jigiberisikiŋ; a mana nan nan tɩŋgbaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Die ʋ bala wɩaha gie die ba pɩasɩ dɩ, “Dɩdagɩrʋ, saŋŋa bɩa naa dɩ baa dɩ yi? Ta bɩa balla ka yi a dagɩ dɩ saŋka tʋgɩya mɩŋ dɩ ka yi?” ");
INSERT INTO kma_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yisa die dɩ baarɩ dɩ, “Nɩ sɩmma ta nɩ da keŋ vaa ba gaaŋ nɩ. Vuosi pam nan keŋ aŋaŋ n saaŋ a baarɩ ‘Manɩŋ n yine Masia wa ta saŋka gbigiye mɩŋ.’ Ama nɩ da keŋ dɩa ba. ");
INSERT INTO kma_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nɩ nan wʋŋ tɔntɩ aŋaŋ waagɩŋ wɩa, ama nɩ da keŋ vaa ŋmaamɩŋ yalla nɩ, dama sie wɩaha gie woliŋ yi ama a ka dagɩ sɩba dʋnɩa kpatɩŋ nan keŋ lele ke gie.” ");
INSERT INTO kma_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Die ʋ bɩ balɩ a yɩ ba dɩ, “Buuriŋ nan wagɩ buuriŋ, ta naalɩŋ dɩaŋ wagɩ taŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tɩŋgbaŋ dɔmɩŋ aŋaŋ kɔŋ aŋaŋ yʋagɩbɩatɩ nan keŋ tɩŋgbaŋka gie lʋga mana mana. Vuosi nan ye mamachi wʋkpɩɩma dɩ bala ka vaa ŋmaamɩŋ juu be ŋmɩŋsikpeŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ama ta geŋhe mana keŋ yiwo, ba nan yigi nɩ ta vaa nɩ dii wahala, ta nagɩ nɩ yɩ Ŋmɩŋ jɩamɩŋ juone nyɩŋkʋra aŋ ba dii nɩ sarɩya, ta nagɩ nɩ yi dansarɩka sʋŋ; ta bɩ nagɩ nɩ a ga naalɩŋ jige aŋaŋ tɩŋgbaŋka nyɩŋkʋra jigiŋ n wɩa. ");
INSERT INTO kma_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Naa bala ka yɩ nɩ sieŋ aŋ nɩ balɩ n wɩa a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Die wɩa nɩ yi siri ta da vaa dɩ mugisi nɩ aŋaŋ nɩ baaŋ nan balɩ wudiekemba a gbatɩ nɩ gbaŋ a taaŋ; ");
INSERT INTO kma_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","dama saŋka mi n nan yɩ nɩ yɩaŋ aŋaŋ wudieke nɩ baaŋ nan balɩ, amʋ nɩ dataasɩ kaaŋ bɩagɩ nyaŋŋɩ nɩ wʋbalɩka yaa a chiisi nɩ. ");
INSERT INTO kma_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ama nɩ chʋalɩŋ aŋaŋ nɩ nɩɩlɩŋ aŋaŋ nɩ nɩmballɩ aŋaŋ nɩ tigiŋ vuosi aŋaŋ nɩ zʋalɩŋ nan keŋ a nyɩŋ nɩ kʋaŋ a posi nɩ chɩaŋ, aŋ ba kʋʋ nɩ bataŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta vuoŋ mana nan keŋ haa nɩ, dama nɩ dɩna n kʋaŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama nɩ sikpeŋ zuobalɩmɩŋ gbaŋ kaaŋ bɩa. ");
INSERT INTO kma_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dɩɩ yi nɩ ka zeti n kʋaŋ dɩɩsɩŋ nɩ nan keŋ ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ama saŋŋa dieke nɩ keŋ ye ta sojasi taaŋ giliŋ Jerusalemi, nɩ nan dɩ sɩba a baarɩ ka chʋʋsɩŋ saŋŋa gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Saŋka mi vuodiekemba dɩ benne Judia tɩŋ ma chɩgɩ ga tana sikpeŋ; ta vuodiekemba dɩ benne Jerusalemi chɩgɩ a nyɩŋ, ta vuodiekemba dɩaŋ dɩ benne tɩŋkpaŋŋɩsɩsɩ dɩaŋ da a keŋ a juu tɩka ma ");
INSERT INTO kma_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","dama saŋka mi yiwo tɩbɩdatɩŋ saŋŋa. Wɩaha gie mana nan keŋ yi sɩba die dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma die wo. ");
INSERT INTO kma_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Saŋka mi wʋbɩaŋ nan dɩ bie hɔgʋ nyuutitieliŋ aŋaŋ hɔgʋ diekemba dɩ yalla ballɩnyaalɩsɩ, dama wahala pam balla ka keŋ tɩka gie me, ta Ŋmɩŋ sɩnyɩɩrɩŋ nan keŋ vuosi gie me. ");
INSERT INTO kma_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ta sojasi nan keŋ kʋʋ bataŋ aŋaŋ takoobi, ta nagɩ bataŋ a ga tɩgɩsɩ a va ba bɩrɩŋ yɔŋɩsɩ. Ta vuodiekemba dɩ kana ka yi Juu vuosi nan tɩbɩ tɩbɩ ta dɩdɩa Jerusalemi ma a ga tʋgɩ saŋŋa dieke ba saŋŋa dɩ baaŋ kpatɩ. ");
INSERT INTO kma_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ta dagɩtɩ nan dɩ bie ŋmɩnnɩ ma aŋaŋ chɩɩkʋ ma aŋaŋ chɩŋmarɩsɩ ma. Ta tɩŋgbaŋka gie me sʋgɩchʋʋsɩŋ nan keŋ tɩŋgbaŋɩsɩ mana ma, ta ŋmaamɩŋ nan dɩ beri yaa gamma mʋgɩkpɩɩrɩ poŋŋiku wɩa. ");
INSERT INTO kma_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ta nyindiekemba dɩ benne ŋmɩŋsikpeŋ nan dɔndɔŋ a lagɩŋ taŋ, die wɩa ŋmaamɩŋ nan juu vuosi a va ba chaa, ta nan dɩ chɩɩsa wudieke dɩ kienene tɩŋgbaŋka ma wa. ");
INSERT INTO kma_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Saŋka mi ba nan ye manɩŋ vuota bʋa dɩ nyɩnnana nɩɩŋmara sʋŋ aŋaŋ hagɩrɩkpeŋkpɩɩŋ aŋaŋ chaankpeŋkpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wɩaha gie dɩ keŋ piili a yie, nɩ yigi sikimiŋ dama nɩ gbatɩtaanɩŋ saŋŋa gbigiye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yisa die dɩ taaŋ ba nandagɩrɩ gie dɩ, “Nɩ daansɩ chunchuleke tɩɩka aŋaŋ tɩɩsɩ mana. ");
INSERT INTO kma_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nɩ keŋ ye tɩɩsɩsɩ vaatɩ ta a tʋsa nɩ ŋaaŋ mɩŋŋɩ mɩŋ dɩ yɩbɩŋ gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Die gbaŋ gbaŋ nɩ keŋ ye ta wɩaha gie yie, nɩ nan dɩ sɩba a baarɩ Ŋmɩŋ naarɩ gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Wusie maŋ bala nɩ, leleke gie vuosi kaaŋ kpi a kpatɩ ta wɩaha gie mana keŋ yi. ");
INSERT INTO kma_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie nan keŋ tɩaŋ ga, ama n wʋbalɩka kaaŋ tɩaŋ ga naa daa. ");
INSERT INTO kma_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nɩ gbara nɩ gbaŋ ta da keŋ a wɩarɩ dʋʋga diile me aŋaŋ daaŋ nyuule me aŋaŋ wumugisike me, dɩ daa die, n keŋku nan keŋ pirigi nɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dɩnda daarɩ nan nan bubi tɩŋgbaŋka gie vuosi mana sɩba taŋ chachabɩ. ");
INSERT INTO kma_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nɩ gbara ta jʋʋsɩma Ŋmɩŋ saŋŋa mana dɩ ʋ yɩ nɩ hagɩrɩ dieke dɩ baaŋ nan va nɩ nyaŋŋɩ wɩaha gie mana dɩ balla a yi wo. Ta bɩ bɩagɩ a zie manɩŋ vuota Bʋa wa nɩŋŋa.” ");
INSERT INTO kma_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Die daaŋ mana Yisa die ŋaaŋ bie wo Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a daga vuosi Ŋmɩŋ wɩa, ta jɩŋmɩŋ mana ʋ ŋaaŋ nyɩŋ a bie wo kunkogi dieke ba wasɩnana Olivisi Tɩɩsɩ kunkogiri me; ");
INSERT INTO kma_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ama sʋkʋʋŋ mana vuosi mana ŋaaŋ nyɩŋ mɩŋ a ga Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a ga wʋmma ʋ wʋbalɩkaha. ");
INSERT INTO kma_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Die saŋka die dɩ gbigi dɩ ba dii dʋʋga dieke ba ŋaana ŋɔba paanʋ dieke ba kana ka nagɩ dabɔtɩ a yi wo, die ba wasa kanɩŋ dʋʋgaka mi gasɩtɩanɩŋ dʋʋga, ");
INSERT INTO kma_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ta die Ŋmɩŋ kɩkaabɩtɩba aŋaŋ mɩraha dɩdagɩrɩba die dɩ mɩa a yaala sieti dɩ ba kʋʋ Yisa, ama die ba chɩga daadamba ŋmaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Womi Sitaani die dɩ juu Judasi vuodieke die ba wasɩnana Asikaroti ta bɩ yi Yisa kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Die wɩa wʋnɩŋ Judasi die dɩ ga balɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ ba sojasi nyɩŋkʋraha ʋ baaŋ nan yi die a vaa ba yigi Yisa. ");
INSERT INTO kma_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Die ba sʋgɩtɩ dɩ fɩalɩ ta die ba baarɩ ba nan yɩ wa ligire. ");
INSERT INTO kma_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Die Judasi die dɩ saagɩ ta wa piili a yaala sie dieke ʋ baaŋ nan nagɩ Yisa a yi ba nuusi me saŋŋa dieke kpɩkpaaŋ dɩ worine. ");
INSERT INTO kma_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Die ba dinene paanʋ dieke ba kana ka nagɩ dabɔtɩ a yi wo saŋŋa dieke ba ŋaana kʋa yiisehe a yie gasɩtɩaŋkʋ dʋʋga nyindiikehe dɩ keŋ tʋgɩ, ");
INSERT INTO kma_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yisa die dɩ tʋŋ Piita aŋaŋ Jɔɔn aŋaŋ nʋarɩ gie dɩ, “Nɩ ga a yi tɩ gasɩtɩaŋkʋ dʋʋga nyindiikehe siri aŋ tɩ dii.” ");
INSERT INTO kma_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Die ba pɩasɩ wa dɩ, “Sɩa fʋ yaala tɩ ga a yi he siri?” ");
INSERT INTO kma_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ʋ baarɩ dɩ, “Nɩ wʋmma, nɩ ganana tɩka sʋkʋ nɩ nan haarɩ daa wʋnyɩ dɩ chine jaaŋ aŋaŋ nyaaŋ, nɩ dɩa wa a ga juu tigidieke me ʋ junene wo, ");
INSERT INTO kma_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","a balɩ tigiri tieŋ dɩ, ‘Dɩdagɩrʋ wa baarɩ, chaamba juodieke manɩŋ aŋaŋ n kʋaŋandɩɩsɩrɩba dɩ balla tɩ dii gasɩtɩaŋkʋ nyindiikehe bie sɩa?’ ");
INSERT INTO kma_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ʋ nan dagɩ juokpeŋkpɩɩŋ dɩ benne sikpeŋ me a yallɩ jaaŋ mana a gbarɩ, mi nɩ nan yi nyindiikehe.” ");
INSERT INTO kma_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Die ba nyɩŋ ga a ye jaaŋ mana sɩba Yisa die dɩ balla ba wa die wo, die wɩa die ba yi gasɩtɩaŋkʋ dʋʋgaka nyindiikehe mi. ");
INSERT INTO kma_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Die gasɩtɩaŋkʋ dʋʋga nyindiikehe diile saŋŋa dɩ tʋgɩna, Yisa die dɩ ga kalɩ aŋaŋ ʋ tʋntʋntɩba baŋ aŋaŋ bale wo dɩ ba dii. ");
INSERT INTO kma_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Die ʋ balɩ a yɩ ba dɩ, “N paalɩ yaala mɩŋ dɩ n dii gasɩtɩaŋkʋ gie dʋʋga nyindiikehe aŋaŋ nɩ ta wahalaka ye keŋ n ma. ");
INSERT INTO kma_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","N bala nɩ, n kaaŋ bɩ dii he bɩbra a yaa ga tʋgɩ saŋŋa dieke wusie diile he dɩ bala dɩ yi Ŋmɩŋ naarɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Womi die ʋ tuo nyaaŋ chibiŋ aŋaŋ daaŋ ta bɩrɩ Ŋmɩŋ ta baarɩ dɩ, “Nɩ tuo geŋke a tɩa yɩ taŋ a nyuu; ");
INSERT INTO kma_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","N bala nɩ, a nyɩŋ jinne yaa gamma, n kaaŋ bɩ nyuu daabʋ gie sie Ŋmɩŋ naarɩ keŋ keŋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Die ʋ bɩ nagɩ paanʋ ta bɩrɩ Ŋmɩŋ ta gbieri gbieri ke a nagɩ yɩ ba ta baarɩ dɩ, “N nyɩŋgbanɩŋ wʋnna maŋ baa n nagɩ aŋ ba kʋʋ mɩŋ nɩ wɩa. Nɩ yime naa a tɩɩnsɩma n wɩa.” ");
INSERT INTO kma_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Die gbaŋ gbaŋ die ba dine kpatɩ wa ʋ nagɩ nyaaŋchibike aŋaŋ daabʋ a baarɩ dɩ, “Nyaaŋchibike aŋaŋ daabʋ gie yiwo Ŋmɩŋ nʋahaalɩ dieke n ziene aŋaŋ n zɩmbʋ dɩ nyɩnna wa a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ama nɩ ye, vuodieke dɩ balla ʋ posi n chɩaka kalɩ wa gie a lagɩŋ a die aŋaŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Manɩŋ vuota Bʋa nan seŋ kpi sɩba Ŋmɩŋ dɩ sanna die wo, ama wʋbɩaŋ bie vuodieke dɩ balla ʋ posi n chɩaka.” ");
INSERT INTO kma_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Womi die ba piili a pɩasa tamba ba jabɩa balla ʋ yi die. ");
INSERT INTO kma_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Die nɩnhagɩrɩŋ die dɩ nan ʋ kʋaŋandɩɩsɩrɩba sʋnsʋŋ dɩ ba jabɩa balla ʋ yi jakʋʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yisa die dɩ balɩ a yɩ ba dɩ, “Tɩŋgbaŋka gie naalɩŋ ŋaaŋ pɔgɩlɩ ba vuosi aŋaŋ nɩŋŋmɩna ta vuodiekemba dɩ yine tɩŋgbaŋka nyɩŋkʋra yaala ba wasɩma ba vuoŋ mana zʋa. ");
INSERT INTO kma_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama nɩnɩŋ dɩ ka baa dɩ sɩma die. Vuodieke dɩ yine vuokpɩɩŋ nɩ sʋnsʋŋ, sie ʋ yi sɩba bʋabiŋ, ta nɩŋŋandɩɩsɩrʋ wa yi sɩba tʋntʋntʋ. ");
INSERT INTO kma_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mɩnɩa yine vuokpɩɩŋ a tɩaŋ ʋ chanchaalɩŋ, vuodieke dɩ kala a die yaa vuodieke dɩ tɩanana nyindiikehe? Dɩ yiwo vuodieke dɩ kala die wo, ama manɩŋ n bie nɩ sʋnsʋŋ sɩba tʋntʋntʋ wa. ");
INSERT INTO kma_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nɩnɩŋ nɩ yine vuodiekemba dɩ benne n jigiŋ n wumugisikehe ma saŋŋa ma ma. ");
INSERT INTO kma_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","N chʋa Ŋmɩŋ die dɩ kalɩnna mɩŋ naarɩ gie wo, die gbaŋ gbaŋ maŋ nan yɩ nɩ kanɩŋ naarɩ mi. ");
INSERT INTO kma_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nɩ nan dii ta nyuu aŋaŋ manɩŋ n naarɩ ma, ta kalɩ naagbaŋtɩ ma a dii Izara buurisi baŋ aŋaŋ ale wo sarɩya.” ");
INSERT INTO kma_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tɩ Yɔmʋtieŋ die dɩ balɩ yɩ Simoni Piita dɩ, “Simoni, Simoni, wʋmma, Sitaani jʋʋsa wa sieŋ dɩ ʋ magɩsɩ nɩ ta chaarɩ nɩ sɩba ba ŋaana a chaarɩ zaa aŋ ʋ ye dɩ nɩ yiwo zaa bie yaa zaavɔntɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama fʋnɩŋ Simoni n jʋʋsɩ wa Ŋmɩŋ a yɩ fʋ dɩ fʋ yadaka da keŋ sʋʋŋ tɩŋgbaŋ, ta fʋ keŋ a yiŋŋi a keŋ n jigiŋ fʋ kpaŋŋɩsɩma fʋ nɩmballɩlɩ.” ");
INSERT INTO kma_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piita die dɩ yiŋŋi a balɩ wa dɩ, “N Yɔmʋtieŋ, n yi siri dɩ n juu dansarɩka aŋaŋ fʋ, ta kpi aŋaŋ fʋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Piita, n bala fʋ, kparaaŋ nan keŋ baa ka kʋmma ta fʋnɩŋ chiisi wo bʋtaa dɩ zɩ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Womi Yisa die dɩ pɩasɩ ba dɩ, “Die n tʋnna nɩ die nɩ ga ta ka pɔgɩlɩ ligire jasʋʋkɩŋ aŋaŋ bʋlɔgɩŋ aŋaŋ nɩɩraha die nɩ waarɩ jaaŋ mɩŋ?” Die ba yiŋŋi baarɩ dɩ, “Aayɩ.” ");
INSERT INTO kma_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yisa die dɩ baarɩ dɩ, “Ama lele nɩŋ, vuodieke mana dɩ yalla ligire jasʋʋkɩŋ yaa bʋlɔgɩŋ ʋ nagɩ ka, ta vuodieke dɩ kana ka yallɩ takoobi, ʋ nagɩ ʋ jayeekiŋ a daa a daa kaanɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","N bala nɩ, dɩ maagɩya Ŋmɩŋ gbaŋkʋ ma dɩ ‘Ba nagɩ wa mɩŋ a gʋtɩ vuobɩatɩ ma.’ Die wɩa, die gbaŋ gbaŋ ba nan yi mɩŋ, dama wudieke mana ba maagɩna yaa gamma n ma Ŋmɩŋ gbaŋkʋ ma wa nan keŋ yi wusie.” ");
INSERT INTO kma_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Die ʋ kʋaŋandɩɩsɩrɩba dɩ baarɩ dɩ, “Tɩ Yɔmʋtieŋ, ye, takoobisi ale wʋnna.” Die ʋ yiŋŋi a baarɩ dɩ, “Dɩ mʋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Die ʋ nyɩŋ mi a ga Olivi Tɩɩsɩ kunkogiŋ me sɩba ʋ ŋaana yie die wo; ta die ʋ kʋaŋandɩɩsɩrɩba die dɩ dɩ ʋ kʋaŋ a ga. ");
INSERT INTO kma_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Die ʋ tʋgɩna mi wo, die ʋ balɩ a yɩ ba dɩ, “Nɩ jʋʋsɩma Ŋmɩŋ amʋ nɩ da keŋ juu magɩsɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Die ʋ chʋŋ ga ba nɩŋŋa bɩta a sʋʋŋ gbirigi a jʋʋsɩ Ŋmɩŋ dɩ, ");
INSERT INTO kma_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“N Chʋa Ŋmɩŋ, dɩɩ yi fʋ dʋŋŋʋ fʋ vʋarɩ mɩŋ a nyɩŋ wʋbɩa dieke dɩ kienene n ma naa, ama vaa fʋ dʋŋŋʋ yi da manɩŋ n dʋŋŋʋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Womi malaka die dɩ nyɩŋ arɩzanna ma a keŋ a kpaŋŋɩsɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Die ʋ benne sʋgɩchʋʋsɩŋ ma wa die ʋ faasɩ a jʋʋsɩ Ŋmɩŋ aŋaŋ nɩŋŋmɩna, die ʋ walɩŋ die dɩ nanna tɩŋgbaŋ sɩba zɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Die ʋ kenne hagɩ Ŋmɩŋ jʋʋsɩkʋ ma wa die ʋ yiŋŋi ga ʋ kʋaŋandɩɩsɩrɩba jigiŋ, ta ye ta ba gʋʋra, dama sʋgɩchʋʋsɩŋ die vana ba gbalɩgɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Die ʋ pɩasɩ ba dɩ, “Bɩa wɩa nɩ gʋʋra? Nɩ hagɩ a jʋʋsɩma Ŋmɩŋ amʋ nɩ da keŋ a juu magɩsɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisa die ye ko bala wɩa ta ye kpɩkpaaŋ dɩ kienene. Ta Judasi ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ die dɩna ba nɩŋŋa, a die keŋ Yisa jigiŋ dɩ ʋ mʋgɩsɩ ʋ kaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ama ta die Yisa die dɩ pɩasɩ wa dɩ, “Judasi, mʋgɩsɩ wa n kaamɩŋ dɩ fʋ nyɩŋ manɩŋ vuota Bʋa kʋaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Die Yisa kʋaŋandɩɩsɩrɩba die dɩ yene wudieke dɩ bala ka yiwo, ba pɩasɩ wa dɩ, “Tɩ Yɔmʋtieŋ, tɩ wagɩ ba aŋaŋ takoobisi?” ");
INSERT INTO kma_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ama ta ba wʋnyɩ dɩ wɔŋ yi lagɩ a gobi Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ yɔmʋ nuudiigiŋ chaaŋ tɩbɩŋ a taaŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama Yisa die dɩ baarɩ dɩ, “Dɩ mʋ”, ta die a nagɩ daa wa tɩbɩrɩ a yiŋŋi a marɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Die Yisa dɩ pɩasɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ ba sojasisi nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha dɩ kenne dɩ ba yigi wo wo dɩ, “N yiwo gbɩgbatɩrʋ nɩ keŋ aŋaŋ takoobisi aŋaŋ dengbile dɩ nɩ yigi mɩŋ? ");
INSERT INTO kma_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Manɩŋ die n bie nɩ jigiŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma daaŋ mana ta nɩ ka mɩa dɩ nɩ yigi mɩŋ. Ama saŋka gie yiwo nɩ sɩɩtɩ aŋaŋ Sitaani dɩ yine lɩmɩŋ hagɩrɩtieŋ wo sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mi die ba yigi Yisa a yaa wa a ga Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ tigiŋ, ta Piita die dɩ bie saasaa ta dɩ ba. ");
INSERT INTO kma_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Die ba chɔgɩsɩ wa boliŋ gbaakʋ sʋnsʋŋ a kalɩ a giliŋbu a weele, Piita die dɩ ga gʋtɩ ba a kalɩ. ");
INSERT INTO kma_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Die tʋntʋntɩba havʋʋbiŋ wʋnyɩ die dɩ ye Piita dɩ kala bolibu jigiŋ, die ʋ keŋ a mɩŋŋɩ daansɩ wa die ta keŋ baarɩ dɩ, “Daa wa gie gbaŋ die gʋtɩ wa Yisa ma.” ");
INSERT INTO kma_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama Piita die dɩ chiisike dɩ, “N lɩa, n ka wɔŋ sɩba wa.” ");
INSERT INTO kma_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Die dɩ yi sʋaa, daa wʋnyɩ dɩaŋ die dɩ ye wo a baarɩ dɩ, “Fʋnɩŋ, fʋ gbaŋ yiwo ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ?” Ama die Piita dɩ yiŋŋi balɩ wa dɩ, “N nɩmbʋa, n ka yi ba wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Die dɩ bɩ yi sʋaa daa gaaŋ dɩ bɩ keŋ a baarɩ dɩ, “Wusie, daa wa gie gbaŋ die beri aŋaŋ wa dama ʋ gbaŋ yiwo Galili vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piita die baarɩ dɩ, “N nɩmbʋa, manɩŋ n ka wɔŋ sɩba wudieke fʋ balala wa.” Die ʋ yene ko bala wɩaha, kparaaŋ die dɩ kʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ta tɩ Yɔmʋtieŋ Yisa die dɩ yiŋŋi a daansɩ Piita nine me, ta Piita die dɩ tɩɩnsɩ wudieke tɩ Yɔmʋtieŋ Yisa die dɩ balɩ yɩ wa wa dɩ, “Kparaaŋ nan keŋ baa ka kʋmma soriŋ sʋkʋʋŋ ta baarɩ zɩ mɩŋ bʋtaa mama.” ");
INSERT INTO kma_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Die Piita dɩ nyɩŋ yeŋ me a kʋŋ pam. ");
INSERT INTO kma_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Die vuodiekemba die dɩ gbarɩna Yisa wa die dɩ vʋarɩ wa fala ta nɩgɩ wa, ");
INSERT INTO kma_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ta nagɩ jaaŋ a bɔbɩ ʋ nine chaaŋ ta nɩgɩ wa ta balɩ wa dɩ, “Bʋgɩ a dagɩ vuodieke dɩ nɩgɩna fʋ wa.” ");
INSERT INTO kma_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta die ba balɩ wɩa pam a chʋʋsa ʋ saaŋ ta zɩa wa. ");
INSERT INTO kma_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Die tʋŋ dɩ vʋnna, die Juu vuosi nyɩŋkʋraha aŋaŋ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba die dɩ lagɩŋ taŋ nyɩŋkʋra lagɩmɩŋ jigiŋ, die ba yaa Yisa a keŋ ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Die ba pɩasɩ wa dɩ, “Balɩ tɩ, fʋnɩŋ fʋ yine Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa?” Die Yisa dɩ yiŋŋi baarɩ dɩ, “Dɩɩ yi maŋ balɩ nɩ, nɩ kaaŋ yi mɩŋ yada, ");
INSERT INTO kma_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ama n dɩaŋ maŋ pɩasɩ nɩ wʋpɩasɩkɩŋ nɩ kaaŋ saagɩ a yiŋŋi mɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama a nyɩŋ lele yaa gamma manɩŋ vuota Bʋa nan daansɩ kalɩ Hagɩrɩtieŋ Nabidie Ŋmɩŋ nuudiigiŋ chaaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Die ba mana dɩ pɩasɩ wa dɩ, “Die nɩŋ fʋ yine Ŋmɩŋ Bʋa wa?” Ʋ yiŋŋi baarɩ dɩ, “Sɩba nɩ balla die wo.” ");
INSERT INTO kma_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Womi die ba baarɩ dɩ, “Tɩ ka bɩ yaala daansɩatieliŋ bɩbra. Tɩ gbaŋ gbaŋ tɩ wʋŋ ʋ nʋaŋ wʋbalɩka mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Die daadamba mana dɩ hagɩ a yaa Yisa a ga naaŋ Paliti jigiŋ, ");
INSERT INTO kma_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","mi die ba piili a bala a chʋʋsa wa dɩ, “Tɩ ye daa wa gie dɩ balala tɩ vuosi dɩ ba da tuŋ lampo a yɩ naaŋ Siiza ta bɩ baarɩ dɩ ʋ yiwo Ŋmɩŋ Vuovʋarɩkɩŋ Masia ta bɩ yi naaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Die wɩa Paliti die dɩ pɩasɩ wa dɩ, “Fʋ yine Juu vuosi naaŋ wa?” Yisa dɩ yiŋŋi a balɩ wa dɩ, “Sɩba fʋ balla die wo.” ");
INSERT INTO kma_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Womi Paliti die dɩ balɩ yɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ kpɩkpaakʋ dɩ, “Manɩŋ n ka ye daa wa gie dɩ chʋʋsɩna die.” ");
INSERT INTO kma_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ama die ba faasɩ a kpaŋŋɩ ba gbaŋ dɩ, “Ʋ dagɩkʋ vaa wa vuosi dɩ yie watɩ aŋaŋ waagɩŋ. Die ʋ woliŋ piili wo Galili me ta die ga Judia tɩgɩsɩ mana mana ta wa keŋ giena.” ");
INSERT INTO kma_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Die Paliti die dɩ wʋnna naa ʋ pɩasɩ dɩ, “Daa wa gie yiwo Galili vuoŋ?” ");
INSERT INTO kma_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Die ʋ mɩŋŋɩna dɩ Yisa nyɩŋ wa Galili tɩŋgbaŋ dieke Herodi dɩ daansɩnana wa, die ʋ vaa ba yaa wa ga Herodi jigiŋ, dama wʋnɩŋ Herodi die bie wo Jerusalemi kanɩŋ saŋka mi. ");
INSERT INTO kma_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Die Herodi ŋaaŋ wʋmma Yisa wɩa, ta die yaala ʋ ye wo. Die wɩa die ʋ yene wo wo ʋ sʋŋ die dɩ fɩalɩŋ, ta die yaala Yisa yi mamachi wɩɩŋ aŋ ʋ ye. ");
INSERT INTO kma_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Die wɩa die ʋ pɩasɩ Yisa wʋpɩasɩka pam, ama ʋ ka tɔgɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba die zie mi ta faasɩ bala a chʋʋsa Yisa. ");
INSERT INTO kma_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Die Herodi aŋaŋ ʋ sojasisi die dɩ vʋarɩ Yisa fala ta yiwo wʋbɩatɩ pam, ta die nagɩ garɩvɩɩnɩŋ a yeegi wo ta nagɩ wa yiŋŋi ga Paliti jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Die dɩnda daarɩ gbaŋ gbaŋ Herodi aŋaŋ Paliti dɩ yi zʋalɩŋ, dama die ba yiwo dataasɩ aŋaŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paliti die dɩ wa Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ ba tɩka nyɩŋkʋraha aŋaŋ vuosisi, ");
INSERT INTO kma_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a balɩ a yɩ ba dɩ, “Nɩnɩŋ nɩ yalla daa wa gie a keŋ n jigiŋ a baarɩ dɩ ʋ gaama vuosi ba waga wagɩtɩ, ama lele n dii wo ʋ sarɩya nɩ nɩŋŋa ta ka ye wudieke nɩ bala dɩ ʋ yi chʋʋsɩ wa. ");
INSERT INTO kma_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodi gbaŋ ka ye wudieke ʋ yine chʋʋsɩ, die wɩa ʋ vaa ba yiŋŋi nagɩ wa a keŋ n jigiri. Nɩ yeye? Daa wa gie ka yi wɩɩŋ mana amʋ kuŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Die wɩa n nan yi ba tɩbɩ wa aŋaŋ kpaasɩŋ ta vaa ʋ ga.” ");
INSERT INTO kma_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","((Die ba gasɩtɩaŋkʋ dʋʋga saŋŋa mana Paliti ŋaaŋ vʋarɩ wa vuobalɩmɩŋ a nyɩŋ dansarɩka sʋŋ a taaŋ a yɩ ba.)) ");
INSERT INTO kma_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Die kpɩkpaakʋ mana dɩ natɩ dɩ, “Kʋʋ daa wa gie. Vʋarɩ Barabasi a yɩ tɩ yɔrɩ.” ");
INSERT INTO kma_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Die ba nagɩ wa Barabasi a yi dansarɩka sʋŋ dama ʋ vaa wa watɩ aŋaŋ waagɩŋ dɩ nan tɩka sʋŋ aŋaŋ ʋ vuosi kʋʋla wɩa. ");
INSERT INTO kma_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ama Paliti die yaala ʋ vaa wa Yisa a taaŋ yɔrɩ die wɩa die ʋ bɩ balɩ yɩ kpɩkpaakʋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama ta ba ye ko nata dɩ, “Kpaasɩ wa dagarɩkɩrɩ ma, Kpaasɩ wa dagarɩkɩrɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Paliti die dɩ pɩasɩ ba ʋ bʋtaa ma dɩ, “Bɩa wʋbɩaŋ ʋ yi? Manɩŋ n ka ye wudieke ʋ yine amʋ kuŋ. Die wɩa n nan vaa ba tɩbɩ wa aŋaŋ kpaasɩŋ ta vaa ʋ ga.” ");
INSERT INTO kma_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama die ba ye ko nata aŋaŋ lɔlɩkpɩɩma dɩ ba kpaasɩ Yisa a diisi dagarɩkɩrɩ ma; die ba natɩkʋ die dɩ keŋ nyaŋŋɩ Paliti. ");
INSERT INTO kma_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Die wɩa Paliti die dɩ yɩ ba sieŋ dɩ ba yi ba dʋŋŋʋ. ");
INSERT INTO kma_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Die ʋ vʋarɩ daa dieke ba yaalala wa a taaŋ, vuodieke die dɩ vana watɩ aŋaŋ waagɩŋ dɩ nan tɩka ma wa ta bɩ kʋʋ vuosisi, ta nagɩ Yisa a yɩ ba dɩ ba yi wo ba dʋŋŋʋ. ");
INSERT INTO kma_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Die sojasisi die dɩ nagɩ Yisa a ga, die ba ganana wa ba ga tuoli daa wʋnyɩ ba wasɩnana Simoni, vuodieke die dɩ nyɩnna Sayireni, die ʋ nyɩŋ wa tɩŋkpaŋa a keŋ juo Jerusalemi sʋŋ. Die ba yigi wo, a nagɩ Yisa dagarɩkɩrɩ a chii wo ta vaa ʋ chiike a dɩ Yisa kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Die daadaaŋ pam die dɩdɩ Yisa kʋaŋ, die hɔɔŋ bataŋ die gʋtɩna ba ma a kʋma ʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Jerusalemi hɔɔŋ, nɩ da kʋmma n wɩa ama nɩ kʋmma nɩ gbaŋ gbaŋ nɩ wɩa aŋaŋ nɩ ballɩ. ");
INSERT INTO kma_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Dama saŋŋa kieŋ vuosi dɩ nan baarɩ dɩ, ‘Hɔgʋ pɩrɩsɩ vuodiekemba dɩ kana ka mɩɩrɩ ballɩ ta yɩ ba bɩɩsɩŋ banɩŋ ba yaa sʋgɩfɩalɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kanɩŋ saŋka mi vuosi dɩ nan balɩ a yɩ tana dɩ, ‘Nan tɩ ma.’ Ta balɩ yɩ kunkogehe dɩ ‘Nan tɩ ma a ligi tɩ.’ ");
INSERT INTO kma_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Dama dɩɩ yi ba yie naa a yɩa mɩŋ, vuodieke dɩ kana ka yi wɩɩŋ a chʋʋsɩ, die nɩŋ lalɩa ba baa ba yi vuodiekemba dɩ yine a chʋʋsɩ?” ");
INSERT INTO kma_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Die ba nagɩ tʋntʋmbɩatɩ tieliŋ bale gbaŋ a gʋtɩ Yisa ma dɩ ba ga kʋʋ ba. ");
INSERT INTO kma_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Die ba kenne a tʋgɩ jigidieke die ba wasɩnana Sikpeŋkogilike jigiŋ, mi die ba kpaasɩ Yisa a diisi dagarɩkɩrɩ ma, ta die kpaasɩ tʋntʋmbɩatɩ tieliŋ bale wo dagarɩsɩ ma, ta kaanɩ die dɩ bie ʋ nuudiigiŋ chaaŋ ta kaanɩ dɩaŋ ʋ nuugalɩ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yisa die dɩ baarɩ dɩ, “N Chʋa Ŋmɩŋ, nagɩ chaa vuosi gie, dama ba zɩ ba yinene wudieke wo chɩaŋ.” Die ba puo ʋ gaatɩ a tɩa taŋ aŋaŋ chaachaa. ");
INSERT INTO kma_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Die vuosi dɩ zie mi a daansa ta Juu vuosi nyɩŋkʋraha dɩ vʋara wa fala dɩ, “Die ʋ gbatɩ wa vuosi a taaŋ, dɩɩ yi ʋ seŋ yi Ŋmɩŋ Vuovʋarɩkɩŋ Masia wa, ʋ gbatɩ ʋ gbaŋ a taaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojasisi gbaŋ die dɩ vʋara wa fala; die ba nagɩ daŋmɩɩsɩŋ a yɩ wa, ");
INSERT INTO kma_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ta baarɩ dɩ, “Dɩɩ yi fʋ yi Juu vuosi naaŋ, fʋ gbatɩ fʋ gbaŋ a taaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Die ba maagɩ maagɩŋ a diisi dagarɩkʋ ma dɩ, ");
INSERT INTO kma_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Saŋka mi tʋntʋmbɩatɩ tielibe wʋnyɩ die ba kpaasɩna a gʋtɩ wa die dɩ taana wa jome dɩ, “Da fʋ yine Masia wa? Gbatɩ fʋ gbaŋ aŋaŋ tɩ a taaŋ.” ");
INSERT INTO kma_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama wʋnyɩ wa die dɩ galɩŋ wa dɩ, “Fʋnɩŋ ka chɩga Ŋmɩŋ? Dama tɩ mana bie wo tɩbɩdatɩ balɩmɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tɩnɩŋ nɩŋ tɩ tɩbɩdatɩkʋ mʋ mɩŋ, dama wudieke tɩ yine wo tune tɩ tuose dene, ama daa wa gie nɩŋ ka yi wɩɩŋ a chʋʋsɩ.” ");
INSERT INTO kma_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ta die a balɩ yɩ Yisa dɩ, “Yisa, tɩɩnsɩ n wɩa saŋŋa dieke fʋ keŋ dii fʋ naarɩ.” ");
INSERT INTO kma_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Wusie maŋ bala fʋ, jinne manɩŋ aŋaŋ fʋ nan dɩ bie Paradasi ma.” ");
INSERT INTO kma_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Die dɩ yiwo ŋmɩntʋasɩ, ŋmɩnnɩ die dɩ ka chaana ta tɩŋgbaŋka mana die dɩ sibi a ga tʋgɩ ŋmɩnnɩ dɩ gbɩlɩnna bimbilimiŋ ataa saŋŋa; ");
INSERT INTO kma_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ta die garɩ dieke die dɩ sagɩna Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋkʋ die dɩ puo bule. ");
INSERT INTO kma_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yisa die dɩ keŋ a keesi aŋaŋ lɔlɩkpɩɩŋ a baarɩ dɩ, “N Chʋa Ŋmɩŋ, fʋ nuusi me maŋ naga n haalɩŋ yie.” Die ʋ balɩ wa naa ta kpi. ");
INSERT INTO kma_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Die sojasisi jakʋʋrɩ die dɩ yene wudieke dɩ yine wo die ʋ bɩrɩ Ŋmɩŋ a baarɩ dɩ, “Wusie, daa wa gie seŋ yiwo vuovɩɩnɩŋ.” ");
INSERT INTO kma_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Die vuodiekemba mana dɩ lagɩsɩna mi dɩ ba daansɩ wudieke dɩ yinene wo dɩ yene wudiekemba dɩ yine wo ba mana die dɩ yiŋŋi ga tigiŋ aŋaŋ sʋgɩchʋʋsɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ama ʋ zʋalɩba mana aŋaŋ hɔgʋ diekemba dɩ dɩna wa a nyɩŋ Galili wo die dɩ zie saasaa a daansa wudiekemba mana dɩ yinene wo. ");
INSERT INTO kma_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Die daa wʋnyɩ die benne ba wasa wa Josefu, die ʋ nyɩŋ wa Juu vuosi tɩŋ ba wasɩnana Arimatia. Die ʋ yiwo vuovɩɩnɩŋ ta bɩ dɩɩ Ŋmɩŋ ta die a chɩɩsa Ŋmɩŋ naarɩ keniŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Die ʋ yiwo Juu vuosi nyɩŋkʋra wʋnyɩ, ama die ʋ ka saagɩ wudieke ʋ chanchaalɩba die dɩ sanna wa ta yi wo. ");
INSERT INTO kma_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Die ʋ ga Paliti nɩŋŋa a ga jʋʋsɩ wa Yisa nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Die ʋ nagɩ Yisa nyɩŋgbaŋka, a yallɩ garɩ haalɩyɩalɩŋ a veli wo a yaa ka a ga dʋaŋ vɔrɩhaalɩ dieke ba votine taŋ ma, ta ye ka guu vuoŋ mi. ");
INSERT INTO kma_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Die dɩ yiwo Alɩzuma daraaŋ ta davʋʋsɩkɩrɩ daarɩ dɩ yaala ka piili. ");
INSERT INTO kma_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hɔgʋ diekemba die dɩ dɩna Yisa a nyɩŋ Galili wo die dɩ dɩ Josefu a ga a ye vɔrɩkʋ aŋaŋ ba dʋana Yisa nyɩŋgbaŋka dene ka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Die ba yiŋŋi ga tigiŋ a ga wʋnsɩ kpaanyʋga aŋaŋ tulaarisi. Die ba voosi davʋʋsɩkɩrɩ daraaŋ sɩba ba mɩraha dɩ dagɩna dene wo. ");
INSERT INTO kma_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Die Alasiri daraaŋ sʋkʋleeliŋ, ta hɔgʋba ha die dɩ ga vɔrɩkʋ jigiŋ aŋaŋ ba tulaari diekemba ba wʋnsɩna wa. ");
INSERT INTO kma_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Die ba kenne tʋgɩ vɔrɩkʋ jigiri die ba ye ta taŋ dieke ba nagɩna a ligi vɔrɩkʋ nʋarɩ biliŋye, ");
INSERT INTO kma_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","die wɩa die ba juu vɔrɩkʋ sʋŋ ama die ba ka ye tɩ Yɔmʋtieŋ Yisa nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Die ba zene a yile wɩɩrɩ gie wo, dembisi bale die dɩ keŋ zie ba jigiŋ bʋnyɩ ta yeegi nyiŋyeeke dɩ nyɩgɩsɩnana sɩba nɩɩnyɩgɩsɩŋ; ");
INSERT INTO kma_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","die ŋmaamɩŋ die dɩ yigi hɔgʋba ha ta ba sʋʋŋ gbirigi tɩŋgbaŋ, ama dembisi bale wo die dɩ pɩasɩ ba dɩ, “Bɩa nɩ dɩ dɩa yaala vuodieke dɩ benne ʋ mɩsɩ ma kunti jigiŋ? ");
INSERT INTO kma_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ʋ wo giena, ʋ hagɩya. Nɩ tɩɩnsɩ wudieke die ʋ balla a yɩ nɩ wa saŋŋa dieke ʋ benne Galili me wo; ");
INSERT INTO kma_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","dɩ ‘Ba nan yigi wʋnɩŋ vuota Bʋa a nagɩ yi vuobɩatɩ nuusi me aŋ ba kpaasɩ wa dagarɩkɩŋ ma aŋ ʋ kpi; ama ʋ nan hagɩ kuŋ me ka daraa ataa daraaŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Womi die hɔgʋbaha dɩ tɩɩnsɩ ʋ wʋbalɩka ha, ");
INSERT INTO kma_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ta die nyɩŋ vɔrɩkʋ jigiŋ a yiŋŋi kuli, a balɩ wɩaha gie mana a yɩ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ kaanɩ wa aŋaŋ vuodiekemba dɩ benne mi mana. ");
INSERT INTO kma_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Die hɔgʋba ha saara die wone Meri Magidalini aŋaŋ Juanna aŋaŋ Jemisi nuŋ Meri; banɩŋ aŋaŋ hɔgʋ diekemba die dɩ gʋtɩna ba ma wa die balɩna wɩaha gie a yɩ Yisa tʋntʋntɩba. ");
INSERT INTO kma_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama tʋntʋntɩba die dɩ yile wudieke ba balala wa yiwo wʋtɔgʋ ta die ka tuo be dii. ");
INSERT INTO kma_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama Piita die dɩ hagɩ a chɩgɩ ga vɔrɩkʋ jigiŋ; a sʋʋŋ a zʋʋrɩ a daansɩ ta ka ye jaaŋ mana sie kumbu garɩkʋ nyɩɩna ma. Ta die a yiŋŋi ga tigiŋ, ta wudieke dɩ yine wo dɩ paalɩ yi wo mamachi. ");
INSERT INTO kma_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Die dɩnɩŋ daarɩ mi gbaŋ gbaŋ ba sʋŋ vuosi die dɩ gara tɩŋkpaŋŋɩ kaanɩ ba wasɩnana Emawusi, kanɩŋ aŋaŋ Jerusalemi die yiwo mali ayʋpɔyɩ. ");
INSERT INTO kma_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Die ba chʋnnana wa, die ba die azama yaa gamma wudiekemba mana dɩ yine wo. ");
INSERT INTO kma_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Die ba dinene azama aŋaŋ taŋ die wo, Yisa gbaŋ gbaŋ die dɩ keŋ gbigi be a chʋŋ aŋaŋ ba; ");
INSERT INTO kma_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ama Ŋmɩŋ die chɔrɩna ba, ba ka mɩŋŋɩ Yisa. ");
INSERT INTO kma_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yisa die dɩ pɩasɩ ba dɩ, “Bɩa nɩ chʋŋ bala?” Die ba yiŋŋi a zie zie aŋaŋ sʋgɩchʋʋsɩŋ. ");
INSERT INTO kma_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ba wʋnyɩ die ba wasɩnana Kulopasi dɩ pɩasɩ wa dɩ, “Fʋnɩŋ fʋ nyɩɩna ma fʋ yine chaanʋ a bie Jerusalemi ka gie me ta ka sɩba wudieke dɩ yinene daraa gie nʋaŋ?” ");
INSERT INTO kma_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Die ʋ pɩasɩ dɩ, “Wʋbɩaŋtɩ?” Die ba yiŋŋi balɩ wa dɩ, “Yaa gamma Nazeriti vuoke Yisa wa; die daa wa gie die yiwo Ŋmɩŋ naazʋa ta yaa hagɩrɩŋ pam ʋ wʋbalɩka ma aŋaŋ ʋ tʋʋma ma Ŋmɩŋ aŋaŋ vuota nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ta tɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩŋgbaŋka nyɩŋkʋraha dɩ nagɩ wa yɩ sarɩya diiriŋ ba dii wo sarɩya ta baarɩ dɩ ʋ mʋ dɩ ʋ kpi; die ba kpaasɩ wa a diisi dagarɩkɩrɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ama tɩnɩŋ die tɩ yaa yada dɩ ʋ balla ʋ yi vuodieke dɩ baaŋ gbatɩ tɩnɩŋ Izara vuosi a nyɩŋ tɩ dataasɩ nuusi me. A bɩ gʋtɩ, wɩaha dɩ yine ka daraa ataa wʋnna. ");
INSERT INTO kma_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Die wɩa gbaŋ tɩ sʋŋ hɔgʋba bataŋ balɩ tɩ wa wɩɩŋ ka paalɩ yi tɩ mamachi, dama ba ga wa vɔrɩkʋ jigiŋ sʋkʋleeliku gie, ");
INSERT INTO kma_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ama ba ka ye ʋ nyɩŋgbaŋka. Ba yiŋŋine a keŋ wo, ba baarɩ dɩ banɩŋ ba ye wo Ŋmɩŋ malakasi aŋaŋ ba nine; ta malakasi dɩ balɩ ba dɩ Yisa bie ʋ mɩsɩ ma. ");
INSERT INTO kma_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Die wɩa tɩ bataŋ dɩ ga vɔrɩkʋ jigiŋ a ga ye wudieke gbaŋ gbaŋ hɔgʋba dɩ balla wa ama banɩŋ ba ka ye Yisa.” ");
INSERT INTO kma_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Womi Yisa die dɩ balɩ a yɩ ba dɩ, “Bɩa yine nɩ ka sɩba nyinti gie chɩasɩ? Lalɩa nɩ sʋnsɩ aŋaŋ nɩ baaŋ nan tuo wudiekemba mana Ŋmɩŋ naazʋalɩba dɩ balla wa a dii! ");
INSERT INTO kma_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dɩ yiwo talasɩ dɩ Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa dii wahalaha gie ta wa ye jɩlɩma.” ");
INSERT INTO kma_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Womi Yisa die piili a dagɩ ba wudieke Ŋmɩŋ gbaŋkʋ sʋŋ mana dɩ balla yaa gamma ʋ wɩa, ta piili Mosisi dɩ maagɩna wudiekemba aŋaŋ Ŋmɩŋ naazʋalɩba maagɩŋ mana. ");
INSERT INTO kma_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Die ba kenne a gbigi tɩŋkpaŋŋɩ dieke banɩŋ ba ganana wa, Yisa die dɩ paalɩ yi sɩba ʋ tɩaŋ gara nɩŋŋa, ");
INSERT INTO kma_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ama die ba jʋʋsɩ wa dɩ, “Bemme giena aŋaŋ tɩ, dama ŋmɩnnɩ wɔŋ nanna mɩŋ ta jigiri dɩaŋ dɩ sibe.” Die wɩa die ʋ juu a wɩarɩ ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Die ʋ ga kalɩ dɩ ʋ dii nyindiike aŋaŋ ba, a die nagɩ paanʋ a bɩrɩ Ŋmɩŋ a yi ke gbieri gbieri a nagɩ yɩa ba. ");
INSERT INTO kma_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Womi die ba nine dɩ yuori die ba mɩŋŋɩ wa. Lele wo mi die ʋ nyɩɩgɩ ba nine me. ");
INSERT INTO kma_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Die ba bala a yɩa taŋ dɩ, “Die ʋ balala tɩ sieku me a daga tɩ wudiekemba dɩ maagɩna Ŋmɩŋ gbaŋkʋ sʋŋ die wo, die tɩ ka yaa sʋgɩfɩalɩŋ pam?” ");
INSERT INTO kma_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Die ba hagɩ bʋnyɩ a yiŋŋi ga Jerusalemi a ga haarɩ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ kaanɩ wa aŋaŋ vuosi bataŋ dɩ lagɩsɩna taŋ. ");
INSERT INTO kma_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ balɩ ba dɩ, “Tɩ Yɔmʋtieŋ seŋ a hagɩ kuŋ me aŋaŋ wusie, ta nyɩŋ Simoni jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Womi vuosi bale wo gie dɩaŋ dɩ balɩ ba wudieke mana dɩ yine sieku me aŋaŋ ba mɩŋŋɩna tɩ Yɔmʋtieŋ saŋŋa dieke ʋ yine paanʋkʋ gbieri gbieri die wo. ");
INSERT INTO kma_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Die ba yine ko bala wɩaha gie yɩa ba wa, lele wo mi Yisa gbaŋ gbaŋ dɩ keŋ zie ba sʋnsʋŋ ta balɩ a yɩ ba dɩ, “Sʋgɩdʋagɩŋ bemme nɩ ma.” ");
INSERT INTO kma_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Die ba cheele aŋaŋ ŋmaamɩŋ, dama die ba yile dɩ ba ye wo kogiŋ. ");
INSERT INTO kma_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ama ta die ʋ balɩ a yɩ ba dɩ, “Bɩa nɩ sɩkpara dɩ nɩga? Bɩa chɩɩlɩŋ dɩ bie nɩ ma? ");
INSERT INTO kma_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nɩ daansɩ ye n nuusi aŋaŋ n nachɩgɩsa a ye dɩ dɩ yiwo manɩŋ wusie. Nɩ gbɩ mɩŋ a ye dɩ dɩ yiwo manɩŋ. Kogiŋ wo nyɩŋgbanɩŋ aŋaŋ kɔba, sɩba nɩ yene mɩŋ n yalla nyɩŋgbanɩŋ aŋaŋ kɔba die wo.” ");
INSERT INTO kma_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Die ʋ balla wɩaha gie a kpatɩ wa, die ʋ nagɩ ʋ nuusisi aŋaŋ ʋ nachɩgɩsa a dagɩ ba. ");
INSERT INTO kma_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ama die ba ye ka tuo dii dɩ dɩ yiwo wʋnɩŋ; dama die dɩ paalɩ yi be wo sʋgɩfɩalɩŋ aŋaŋ mamachi dɩ wɩɩrɩ yiwo wusie. Die ʋ pɩasɩ ba dɩ, “Nɩ yaa nyindiike giena a baaŋ nan dii?” ");
INSERT INTO kma_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Die ba nagɩ zaasɩ dieke ba digine a yɩ wa, ");
INSERT INTO kma_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","die ʋ nagɩ a ŋɔbɩ ba nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta die a balɩ a yɩ ba dɩ, “Nɩ tɩɩnsɩma n wʋbalɩka die n balla a yɩ nɩ saŋŋa dieke die n benne nɩ jigiri dɩ wɩaha mana ba maagɩna Mosisi gbaŋkʋ ma wa aŋaŋ Ŋmɩŋ naazʋalɩba gbaŋtɩ ma wa aŋaŋ Ŋmɩŋ gbaŋ dieke ba wasɩnana yɩla gbaŋkʋ, dɩ dɩ yi talasɩ dɩ a mana keŋ yi wusie.” ");
INSERT INTO kma_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Die ʋ wa yuori ba yɩaŋ dɩ ba sɩmma wudieke dɩ maagɩna wa Ŋmɩŋ gbaŋkʋ ma wa chɩasɩ, ");
INSERT INTO kma_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ta balɩ ba dɩ, “Dɩ maagɩya dɩ Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa nan dii wahala ta kpi ta hagɩ kuŋ me ka daraa ataa daraaŋ, ");
INSERT INTO kma_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","dɩ ba mʋʋlɩ a yɩ vuosi ʋ saaŋ ma, dɩɩ yi ba vaa ba tʋntʋmbɩatɩ Ŋmɩŋ nan vaa a chaa ba; dɩ ba woliŋ a mʋʋlɩma wɩaha a yɩma Jerusalemi vuosi ta bɩ mʋʋlɩ a yɩ buuriŋ mana.” ");
INSERT INTO kma_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Die ʋ bɩ balɩ ba dɩ, “Nɩnɩŋ nɩ yine wɩaha gie daansɩa tieliŋ. ");
INSERT INTO kma_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Manɩŋ n baaŋ yɩ nɩ wa N Chʋa Ŋmɩŋ Halɩkasɩka die ʋ yɩna nʋarɩ dɩ ʋ nan yɩ nɩ wa. Ama nɩ chɩɩsɩma Jerusalemi ma a ga tʋgɩ saŋŋa dieke Ŋmɩŋ Halɩkasɩka dɩ balla ʋ nyɩŋ ŋmɩŋsikpeŋ a keŋ nɩ ma wa.” ");
INSERT INTO kma_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Die Yisa dɩ yaa ba nyɩŋ tɩka sʋŋ a yaa ba ga Betani, mi die ʋ kɔtɩ ʋ nuusi ba ma a yi alibarika a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Die ʋ yinene alibarika a yɩa ba wa, die ʋ nyɩŋ ba jigiŋ ta jʋalɩ ga arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Die ba jɩaŋ wa ta die yiŋŋi a ga Jerusalemi aŋaŋ sʋgʋfɩalɩŋ pam. ");
INSERT INTO kma_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta die a bie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma saŋŋa mana a bɩra Ŋmɩŋ saaŋ.");
INSERT INTO kma_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kʋrɩŋ ma wa, ta jaaŋ die dɩ ye wone wo, ama Ŋmɩŋ Nʋawɩɩŋ, vuodieke dɩ yine Yisa Masia, die wɔŋ beri mɩŋ aŋaŋ Ŋmɩŋ. Ta bɩ yi Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Piiliku me wo Ŋmɩŋ Nʋawɩɩrɩ gie wɔŋ beri mɩŋ aŋaŋ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Die Ŋmɩŋ die dɩ naaŋ jaaŋ mana a nyɩŋ ʋ ma, ta jaaŋ die wori Ŋmɩŋ dɩ naaŋ ta ka ka nyɩŋ ʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ʋ ma die miivoli dɩ bɩ beri, ʋ naga a yɩa vuota, ta miivolike mi dɩ yi vuota chaanɩŋ, ");
INSERT INTO kma_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ta chaana tɩŋgbaŋka gie vuota lɩmɩŋ ma, ta lɩmɩŋkʋ dɩ ka bɩagɩ a lige chaaŋkʋ. ");
INSERT INTO kma_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ŋmɩŋ die dɩ tʋŋ daa wʋnyɩ ba wasɩnana Jɔɔn, ");
INSERT INTO kma_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","dɩ ʋ keŋ a keŋ balɩ vuosi dɩ Yisa Masia yine vuota chaanɩŋ, dɩ ba yi Yisa wa yada. ");
INSERT INTO kma_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wʋnɩŋ Jɔɔn womi die ka yi chaaŋkʋ, ama die ʋ ko keŋ mɩŋ dɩ ʋ keŋ balɩ vuosi chaaŋkʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yisa wa gie yine wusie chaaŋ dieke die dɩ kenne tɩŋgbaŋka gie me, ta chaana vuota mana ma. ");
INSERT INTO kma_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Die ʋ keŋ wo dʋnɩa ka gie me, aŋaŋ Ŋmɩŋ die dɩ naanna dʋnɩaka gie a nyɩŋ ʋ ma wa yɔrɩ, tɩŋgbaŋka gie vuosi die ka mɩŋŋɩ wa. ");
INSERT INTO kma_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Die ʋ kenne tɩŋgbaŋka gie me wo, die ʋ bie wo ʋ gbaŋ gbaŋ vuosi Izara vuosi jigiŋ, ama die ba ka tuo wo. ");
INSERT INTO kma_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama vuodiekemba mana die dɩ tuone wo ta yi wo yada wa ta nagɩ ba gbaŋ a yɩ wa wa, banɩŋ die ʋ yɩ ba sieŋ ba bɩrɩŋ Ŋmɩŋ ballɩ. ");
INSERT INTO kma_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ŋmɩŋ gbaŋ gbaŋ die vana ba bɩrɩŋ ʋ ballɩ daa vuota die vana ba bɩrɩŋ Ŋmɩŋ ballɩ saŋŋa dieke ba mɩɩrɩna ba wa. ");
INSERT INTO kma_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Saŋŋa dieke Ŋmɩŋ Nʋawɩɩrɩ die dɩ kenne ta yi vuota wa, die ʋ beri mɩŋ aŋaŋ tɩ tɩŋgbaŋka gie me, ta die suuli aŋaŋ zɔɔlɩnchɩgɩla aŋaŋ wusie dagɩŋ. Die tɩ ye ʋ chaankpeŋkpɩɩŋ mɩŋ, ta kanɩŋ chaankpeŋkpɩɩkʋ mi die nyɩŋ wa ʋ Chɔɔŋ Ŋmɩŋ jigiŋ mɩŋ, dama ʋ yine ʋ Bʋa dembiŋ balɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Saŋŋa dieke Jɔɔn vuodieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ dɩ kenne ye wo wo, die ʋ balɩ ʋ wɩa ta natɩ dɩ, “Vuodieke wɩa die n balala nɩ dɩ, ‘Ʋ nan keŋ n kʋaŋ chaaŋ ama ʋ tɩaŋ mɩŋ mɩŋ dama ʋ wɔŋ beri mɩŋ ta ba ye mɩɩrɩ mɩŋ wa, wʋnna.’ ” ");
INSERT INTO kma_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ʋ suuline aŋaŋ zɔɔlɩnchɩgɩla wɩa ʋ yɩa tɩ suŋŋiŋ a gʋta suŋŋiŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosisi die yɩ tɩ Ŋmɩŋ mɩraha mɩŋ, ama Yisa Masia nɩŋ die keŋ aŋaŋ zɔɔlɩnchɩgɩla aŋaŋ wusie dagɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Vuoŋ wori a ye ye Ŋmɩŋ; ama ʋ gbaŋ gbaŋ Bʋadembiŋ balɩŋka vuodieke dɩ benne ʋ lʋgɩŋ wa ta bɩ mʋ wa, wʋnɩŋ ʋ yuorine a dagɩ tɩ Ŋmɩŋ dɩ sɩna dene. ");
INSERT INTO kma_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Die Juu vuosi nyɩŋkʋra die dɩ benne Jerusalemi ma wa die dɩ tʋŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Liiva vuosi Jɔɔn jigiŋ dɩ ba ga pɩasɩ wa dɩ, “Mɩnɩa yine fʋ?” ");
INSERT INTO kma_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Die ʋ ka zetiye dɩ ʋ kaaŋ yiŋŋi balɩ ba wɩɩŋ, ama ta die balɩ yuori be dɩ, “Daa manɩŋ n yine Ŋmɩŋ Vuovʋarɩkɩrɩ, Masia wa.” ");
INSERT INTO kma_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Die wɩa die ba pɩasɩ wa dɩ, “Die nɩŋ, mɩnɩa yine fʋ? Yiwo Elaja?” Jɔɔn die dɩ yiŋŋi a balɩ ba dɩ, “Aayɩ, n ka yi wo.” Die ba bɩ pɩasɩ wa dɩ, “Fʋ yine Ŋmɩŋ naazʋa wa?” Ʋ yiŋŋi balɩ ba dɩ, “Aayɩ, n ka bɩ yi wo.” ");
INSERT INTO kma_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Die wɩa ba bɩ pɩasɩ wa dɩ, “Ta mɩnɩa yine fʋ? Balɩ tɩ vuodieke fʋ yine aŋ tɩ ga balɩ vuodiekemba dɩ tʋnna tɩ wa. Lalɩa fʋ balɩ yaa gamma fʋ ma?” ");
INSERT INTO kma_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔɔn die dɩ yiŋŋi balɩ ba aŋaŋ wudieke Ŋmɩŋ naazʋa Azaya die dɩ bala dɩ, “Manɩŋ n yiwo lɔlɩ dieke dɩ benne haagɩŋ ma a nata dɩ Nɩ wʋnsɩ sietʋgɩsɩka a yɩ tɩ Yɔmʋtieŋ.” ");
INSERT INTO kma_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Die tʋntʋntɩba die nyɩŋ wa Farasisi vuosi jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ta die bɩ pɩasɩ Jɔɔn dɩ, “Dɩɩ yi fʋ ka yi Masia wa, ta ka bɩ yi Elaja, ta ka bɩ yi Ŋmɩŋ naazʋa wa, bɩa wɩa fʋ sɩa vuosi Ŋmɩŋ nyaabʋ?” ");
INSERT INTO kma_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔɔn dɩ yiŋŋi balɩ ba dɩ, “Manɩŋ n sɩa vuosi aŋaŋ nyaaŋ, ama vuoŋ bie nɩ sʋŋ ta nɩ ka sɩba wa. ");
INSERT INTO kma_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wʋnɩŋ ʋ yiwo vuodieke dɩ bala ʋ keŋ n kʋaŋ chaaŋ, ta maŋ ka mʋ dɩ n forisi ʋ nɩɩra guune gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wɩaha gie mana die yiye mɩŋ Betani tɩŋ ma, Jɔɔdani mʋgɩrɩ ŋmɩŋ pɔsɩŋ chaaŋ. Mi die Jɔɔn die dɩ sɩa vuosi Ŋmɩŋ nyaabʋ. ");
INSERT INTO kma_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ka tʋnvʋʋsa, Jɔɔn die dɩ ye Yisa dɩ kienene ʋ jigiŋ, ʋ baarɩ dɩ, “Ye, Ŋmɩŋ kaabɩŋ Yiipɔlɩka wʋnna, wʋnɩŋ ʋ bala ʋ vʋarɩ tɩŋgbaŋka gie vuosi bɩaŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ʋ yine vuodieke wɩa die n balala wa dɩ, ‘Daa wʋnyɩ nan keŋ n kʋaŋ chaaŋ ta tɩaŋ mɩŋ dama ʋ wɔŋ beri mɩŋ ta ba ye mɩɩrɩ mɩŋ wa.’ ");
INSERT INTO kma_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Die n ka sɩba wa, ama die n keŋye mɩŋ a sɩa vuosi aŋaŋ Ŋmɩŋ nyaaŋ amʋ Izara vuosi mana nan sɩba wa.” ");
INSERT INTO kma_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ta Jɔɔn dɩ bɩ balɩ a yɩ vuosisi dɩ, “Saŋŋa dieke die n kana ka sɩba vuodieke ʋ yine wo, ama Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ dɩ n keŋ sɩɩ vuosisi ʋ nyaabʋ die dɩ balɩ mɩŋ dɩ, ‘Vuodieke fʋ keŋ ye ta n Halɩkasɩka dɩ keŋ sʋʋŋ kalɩ ta wɩarɩ beri aŋaŋ wa, fʋ sɩmma a baarɩ wʋnɩŋ ʋ yine vuodieke dɩ bala ʋ nagɩ n Halɩkasɩka a sɩma vuosi sʋgɩtɩ. Ta die maŋ seŋ ye Ŋmɩŋ Halɩkasɩka, ta ʋ nyɩŋ ŋmɩŋsikpeŋ a keŋ sʋʋŋ, ta nɩasɩ ŋmarɩŋ a keŋ sʋʋŋ kalɩ Yisa ma ta wɩarɩ beri aŋaŋ wa.’ ");
INSERT INTO kma_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naa maŋ ye, ta bala nɩ dɩ wʋnɩŋ ʋ yiwo Ŋmɩŋ Bʋadembike.” ");
INSERT INTO kma_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka tʋnvʋʋsa bɩbra Jɔɔn die dɩ bɩ zie mi aŋaŋ ʋ kʋaŋandɩɩsɩrɩŋ bale, ");
INSERT INTO kma_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ta keŋ ye Yisa dɩ chʋnnana a tɩanna, ʋ baarɩ dɩ, “Ye, Ŋmɩŋ Yiipɔlɩka wʋnna.” ");
INSERT INTO kma_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Die ʋ kʋaŋandɩɩsɩrɩba bale wo die dɩ wʋnna ʋ balala wa, die dɩ vaa wa ta dɩ Yisa kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yisa die dɩ keŋ yiŋŋi a daansɩ ʋ kʋaŋ a ye ba dɩna wa, ʋ pɩasɩ ba dɩ, “Bɩa nɩ yaala?” Die ba yiŋŋi balɩ wa dɩ, “Dɩdagɩrʋ, tɩ yaala tɩ sɩmma fʋ benne jigidieke wo?” ");
INSERT INTO kma_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yisa dɩ yiŋŋi balɩ ba dɩ, “Nɩ keŋ a ye jigidieke n benne wo.” Die wɩa die ba dɩ wa a ga a ye jigidieke ʋ benne, ta die bie ʋ jigiŋ daarɩ mana. (Die dɩ yiwo ŋmɩntʋasɩ bimbilimiŋ anɩɩsa saŋŋa.) ");
INSERT INTO kma_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Vuosi bale dieke die dɩ wʋnna Jɔɔn balɩkʋ ta die dɩ Yisa kʋaka wʋnyɩ die yine Andurusi, die ʋ yiwo Simoni Piita nɩmbʋa. ");
INSERT INTO kma_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Die ʋ nyɩna Yisa jigiri kʋaŋ chaaŋ die ʋ ga lagɩ lagɩ a ga yaalɩ ʋ nɩmbʋa Simoni jigiŋ a balɩ wa dɩ, “Tɩ ye Masia wa mɩŋ.” (Masia chɩaŋ yiwo “Ŋmɩŋ Vuovʋarɩkɩŋ.”) ");
INSERT INTO kma_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Womi die ʋ nagɩ Simoni a ga Yisa jigiŋ. Yisa die dɩ daansɩ wa die, ta balɩ dɩ, “Yiwo Simoni vuodieke dɩ yine Jɔɔn bʋadembiŋ, ama fʋ saaŋ nan bɩ yi Siifasi.” (Siifasi aŋaŋ Piita mana yiwo bʋnyɩ, a chɩaŋ yiwo “Taŋ”.) ");
INSERT INTO kma_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Die ka tʋnvʋʋsa Yisa die dɩ yaala dɩ ʋ ga Galili, ta die ga jigidieke Filipi die dɩ benne a ga balɩ yɩ wa dɩ, “Keŋ dɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi die nyɩŋ wa Befisada, tɩgɩdieke Andurusi aŋaŋ Piita dɩ nyɩnna. ");
INSERT INTO kma_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi dɩaŋ die dɩ ga yaalɩ Nataniali jigiŋ a balɩ yɩ wa dɩ, “Tɩ ye vuodieke Mosisi dɩ maagɩna ʋ wɩa Ŋmɩŋ mɩraha gbaŋkʋ ma wa, ta Ŋmɩŋ naazʋalɩba dɩaŋ dɩ maagɩ ʋ wɩaha. Ʋ yiwo Yisa, vuodieke dɩ yine Josefu bʋadembiŋ ta nyɩŋ Nazeriti wa.” ");
INSERT INTO kma_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniali die dɩ baarɩ dɩ, “Nazeriti? Wʋvɩɩnɩŋ nan bɩagɩ nyɩŋ Nazeriti?” Filipi die dɩ yiŋŋi balɩ wa dɩ, “Keŋ a ye.” ");
INSERT INTO kma_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yisa die dɩ yene Nataniali dɩ kienene ʋ jigiri, die ʋ balɩ naa yaa gamma ʋ ma dɩ, “Izara vuoŋ wusie wʋnna dama ʋ yiwo burichini vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniali die dɩ pɩasɩ wa dɩ, “Yiwo lalɩa a sɩba mɩŋ?” Yisa die dɩ yiŋŋi balɩ wa dɩ, “Filipi die dɩ yene ka wa fʋ wa, ta maŋ wɔŋ ye fʋ, fʋ benne kɩnkamɩŋ tɩɩka chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mi Nataniali die dɩ balɩ wa dɩ, “Dɩdagɩrʋ, yiwo Ŋmɩŋ Bʋa ta bɩ yi Izara naaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yisa die dɩ pɩasɩ wa dɩ, “N bala fʋ dɩ n ye fʋ mɩŋ saŋŋa dieke fʋ benne kɩnkamɩŋ tɩɩka chɩaka wɩa fʋ yi mɩŋ yada? Nan dɩ yese wʋkpɩɩma pam a tɩaŋ naa. ");
INSERT INTO kma_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wusie maŋ bala nɩ, nɩ nan ye arɩzanna dɩ yuorine, ta Ŋmɩŋ malakasi dɩ keŋ a sʋʋna Vuota Bʋa ma, ta jʋala gara ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ka daraa ataa daraaŋ die ba yaa hɔgʋhaalʋ banwʋla siele Keenani tɩŋ ma, Galili tɩŋgbaŋ ma. Die Yisa nuŋ die bie mi ");
INSERT INTO kma_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ta die ba wa Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba gbaŋ dɩ ba keŋ banwʋlaka jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Die banwʋlaka daa dieke ba nyunene wo dɩ kenne kpatɩ wa, Yisa nuŋ die dɩ balɩ a yɩ Yisa dɩ, “Banwʋlaka daabʋ kpatɩya mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yisa die dɩ yiŋŋi balɩ wa dɩ, “N naa, bɩa fʋ yaala n yi? N saŋŋa ye ka tʋgɩya.” ");
INSERT INTO kma_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yisa nuŋ die dɩ balɩ tʋntʋntɩba dɩ benne mi wo dɩ, “Nɩ yi wudieke ʋ bala nɩ dɩ nɩ yi.” ");
INSERT INTO kma_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Die nyaaŋ gbiesi ayʋaba die zene mi, nyindiekemba Juu vuosisi dɩ yinene nyaaŋ a yie ta yɔɔra nɩta, sɩba ba jɩamɩŋ dɩ sɩna die wo, die a kaanɩ mana die bɩagɩ juo nyaaŋ sɩba galonsi baŋɩsɩ-le yaa baŋɩsɩ-taa. ");
INSERT INTO kma_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisa die dɩ balɩ a yɩ tʋntʋntɩba dɩ, “Nɩ yi nyaaŋ suuli gbiesisi.” Die wɩa die ba yi nyaaŋ a suulihe pili pili. ");
INSERT INTO kma_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Womi die ʋ balɩ a yɩ ba dɩ, “Nɩ yuori bʋtaŋ a yaa ga yɩ banwʋlaka jakʋʋrɩ.” Die ba yi die, ");
INSERT INTO kma_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","die jakʋʋrɩ dɩ laŋ nyaabʋ ta ye bʋ tarɩgɩna a yi daaŋ, ama die ʋ ka sɩba jigidieke daabʋ die dɩ nyɩnna, ama tʋntʋntɩba die dɩ yuorine nyaabʋ die dɩ sɩba. Die wɩa die ʋ wa daa dieke die dɩ faarɩna hɔgʋ wa ");
INSERT INTO kma_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a balɩ yɩ wa dɩ, “Vuoŋ mana ŋaaŋ woliŋ a tɩa wa daa dieke dɩ nansɩna, ta ka kʋaŋ chaaŋ vuodiekemba ʋ wana dɩ keŋ nyu a bugi ʋ wa tɩa daa dieke dɩ kana ka nansɩ wa. Ama fʋnɩŋ nɩŋ nagɩ wa daa dieke dɩ nansɩna wa a lɔbɩrɩ a keŋ tʋgɩ saŋka gie?” ");
INSERT INTO kma_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Naa die yiwo Yisa bʋmbʋŋaŋ mamachi wʋkpɩɩŋ. Die ʋ yi ke wo Keenani tɩŋ ma, Galili tɩŋgbaŋ ma. Naa die dagɩ vuosisi ʋ yalla Ŋmɩŋ yiko die; die wɩa ʋ kʋaŋandɩɩsɩrɩba die dɩ yi wo yada. ");
INSERT INTO kma_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ka kʋaŋ chaaŋ Yisa aŋaŋ ʋ nuŋ aŋaŋ ʋ nɩmballɩ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ ga Kapenɔmi a ga bie mi daraa ale. ");
INSERT INTO kma_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Die Juu vuosi gasɩtɩaŋkʋ dʋʋga saŋŋa die gbigiye mɩŋ, die wɩa Yisa die dɩ ga Jerusalemi dɩ ʋ ga dii dʋʋgaka mi. ");
INSERT INTO kma_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Die ʋ kenne mi wo, ʋ ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ, a ye dembisi dɩ yalla niige aŋaŋ yiise aŋaŋ ŋmarɩsɩ a daa, ta bataŋ dɩ kalɩ ba teebulisi me a tarɩga ligire. ");
INSERT INTO kma_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Die ʋ nagɩ guune a ŋmʋ kpaasɩŋ a yagɩ dɔŋɩsɩsɩ mana a nyɩŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma, ta die kpaŋŋɩ vuodiekemba dɩ tarɩgɩna ligirehe teebulisi a bubi bubi ta ligiribiehe die dɩ nan a jaasɩ. ");
INSERT INTO kma_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A balɩ yɩ vuodiekemba dɩ yalla ŋmarɩsɩ a daa wa dɩ, “Nɩ nagɩha a nyɩŋ giena! Nɩ da nagɩ n Chʋa tigiŋ a bɩrɩŋ nyʋŋ!” ");
INSERT INTO kma_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mi die ʋ kʋaŋandɩɩsɩrɩba dɩ tɩɩnsɩ dɩ Ŋmɩŋ gbaŋkʋ baarɩ dɩ, “N nine ŋmɩntɩya yaa gamma fʋ tigiri gie wɩa pam.” ");
INSERT INTO kma_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Die Juu vuosi nyɩŋkʋraha die dɩ yiŋŋi keŋ ʋ jigiŋ aŋaŋ wʋpɩasɩkɩŋ dɩ, “Bɩa mamachi wɩɩŋ fʋ nan yi aŋ ka dagɩ dɩ yaa yiko dɩ fʋ yi wɩaha gie?” ");
INSERT INTO kma_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Nɩ kpaŋŋɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gie a taaŋ ta n nan nagɩ daraa ataa a bɩ mɩɩ ka.” ");
INSERT INTO kma_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Die Juu vuosisi dɩ yiŋŋi balɩ dɩ, “Bɩna baŋɩsɩ-nɩɩsa aŋaŋ ayʋaba ba nagɩ mɩɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gie, ta fʋnɩŋ fʋ baarɩ nan nagɩ daraa ataa a mɩɩ ka?” ");
INSERT INTO kma_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩŋ dieke Yisa dɩ balala wa yiwo ʋ gbaŋ gbaŋ ʋ nyɩŋgbanɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ŋmɩŋ die dɩ sʋgɩrɩna wa a nyɩŋ kumbu me kʋaŋ chaaŋ wa, ʋ kʋaŋandɩɩsɩrɩba die dɩ tɩɩnsɩ dɩ ʋ balɩ wɩɩrɩ gie mɩŋ, ta die yi Ŋmɩŋ gbaŋkʋ aŋaŋ Yisa die dɩ bala wudieke wo yada. ");
INSERT INTO kma_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Die Yisa die dɩ yene bie Jerusalemi ma wa gasɩtɩaŋkʋ saŋka vuosi pam die dɩ ye ʋ tʋnna mamachi wʋkpɩɩmaha ta yiwo yada. ");
INSERT INTO kma_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama Yisa die dɩ ka nagɩ ʋ gbaŋ a yɩ ba, dama die ʋ sɩba vuota mana sʋŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Die vuoŋ ka mʋ ʋ dagɩ wa vuota dɩ sɩna dene dama ʋ wɔŋ sɩba vuota beriŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Die daa wʋnyɩ die benne ba wasa wa Nikodimosi. Die ʋ yiwo Juu vuosi nɩŋŋandɩɩsɩrɩba wʋnyɩ, ta bɩ yi Farasi vuoŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yuŋ kaanɩ die ʋ ga Yisa jigiŋ a ga balɩ wa dɩ, “Dɩdagɩrʋ, tɩ sɩba a baarɩ yiwo dɩdagɩrɩ dieke Ŋmɩŋ dɩ tʋnna, dama vuoŋ wori a nan bɩagɩ tʋŋ tʋnkpɩɩŋ dieke fʋ tʋnnana naa, ntaala Ŋmɩŋ bie ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Wusie maŋ bala fʋ, vuoŋ wori a baaŋ bɩagɩ juu Ŋmɩŋ naarɩ ma, ntaala ba yiŋŋi mɩɩrɩ wa.” ");
INSERT INTO kma_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimosi die dɩ pɩasɩ wa dɩ, “Lalɩa ba baa ba yiŋŋi mɩɩrɩ vuodieke dɩ kana ka yi bʋabiŋ? Dama ʋ kaaŋ bɩ bɩagɩ a juu ʋ nuŋ nyuuti ma aŋ ba bɩ mɩɩrɩ wa bɩbra.” ");
INSERT INTO kma_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Womi Yisa die dɩ yiŋŋi balɩ wa dɩ, “Wusie maŋ bala fʋ, dɩ vuoŋ kaaŋ bɩagɩ juu Ŋmɩŋ naarɩ ma ntaala ʋ ye mɩɩrɩŋ bule, die yine Ŋmɩŋ Halɩkasɩka aŋaŋ Ŋmɩŋ nyaaŋ sɩɩla wɩa. ");
INSERT INTO kma_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vuota nɩŋ mɩɩra vuota ama Halɩkasɩka mɩɩra haalɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Die wɩa da vaa ka yi fʋ mamachi n bala fʋ dɩ, ‘Sie ba bɩ mɩɩrɩ nɩ wa.’ ");
INSERT INTO kma_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bʋlɔgɩsɩŋ nɩga gara jigidieke ka yaalala, ŋaaŋ wʋŋ wa ka dɔntɩ ama ta ka sɩba jigidieke ka nyɩnna yaa ka ganana. Die gbaŋ gbaŋ vuodiekemba mana Ŋmɩŋ Halɩkasɩka dɩ mɩɩrɩna dɩ sɩɩ.” ");
INSERT INTO kma_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimosi die dɩ pɩasɩ wa dɩ, “Lalɩa naa dɩ baa ka yi?” ");
INSERT INTO kma_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Yiwo Izara vuosi dɩdagɩrɩkpɩɩŋ ta ka sɩba wɩaha chɩasɩ? ");
INSERT INTO kma_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wusie maŋ bala fʋ, tɩ bala nɩ wudieke tɩ sɩbɩna, ta bɩ bala nɩ wudieke tɩ yene, ama nɩ ka tuose tɩ wɩaha. ");
INSERT INTO kma_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dɩɩ yi nɩ ka yi mɩŋ yada yaa gamma tɩŋgbaŋka gie wudiekemba n bala nɩ wa, die nɩŋ maŋ balɩ nɩ arɩzanna ma wɩa nɩ baa nɩ yiwo lalɩa a yi yada? ");
INSERT INTO kma_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Vuoŋ ye ka jʋalɩ ga arɩzanna ma sie manɩŋ Vuota Bʋa vuodieke dɩ nyɩnna arɩzanna ma a keŋ sʋʋŋ wa.” ");
INSERT INTO kma_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosisi die dɩ nagɩna kʋʋtɩ javʋʋkɩŋ a bɔbɩ a marɩ daaŋkʋ ta kɔtɩ ka zie haagɩŋ ma dene wo, die gbaŋ gbaŋ ba baa ba kɔtɩ manɩŋ Vuota Bʋa wa ŋmɩŋsikpeŋ, ");
INSERT INTO kma_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","amʋ vuodieke mana dɩ yine mɩŋ yada nan ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dama Ŋmɩŋ dɩ faasɩna cho tɩŋgbaŋka gie vuosi wɩa; die ʋ yɩ tɩ ʋ Bʋabalɩmɩŋ amʋ vuodieke mana dɩ yi Bʋadembike gie yada ʋ kaaŋ daansɩ kpi, ama ʋ nan ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dama Ŋmɩŋ die ka tʋŋ ʋ Bʋa wa dɩ ʋ keŋ dii tɩŋgbaŋka gie vuosi sarɩya ama dɩ ʋ keŋ a gbatɩ ba taaŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Vuodieke mana dɩ yine Ŋmɩŋ Bʋa wa yada Ŋmɩŋ kaaŋ dii ʋ sarɩya a chʋʋsɩ wa, ama vuodieke mana dɩ kana ka yi wo yada nɩŋ, Ŋmɩŋ wɔŋ dii ʋ sarɩya ta baa ʋ chʋʋsɩya mɩŋ, dama ʋ kana ka yi wʋnɩŋ Ŋmɩŋ Bʋabalɩŋka yada wa wɩa. ");
INSERT INTO kma_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wudieke wɩa Ŋmɩŋ die dɩ dine ba sarɩya ta baarɩ ba chʋʋsɩya yiwo naa; Ŋmɩŋ Bʋadembike die keŋye mɩŋ dɩ ʋ yuori wo tɩŋgbaŋka gie vuosi nine ama ta tɩŋgbaŋka gie vuosi dɩ yaala lɩmɩŋ a tɩaŋ chaanɩŋ, dama ba tʋnnana tʋntʋmbɩatɩ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Vuodieke nɩŋ mana dɩ yinene bɩaŋ hawa chaanɩŋ ta ka yaala ʋ gbigi chaanɩŋ, dama ʋ ka yaala ʋ tʋmbɩatɩtɩ nyɩŋ yaalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama vuodieke nɩŋ mana dɩ tʋnnana wudieke dɩ mʋna kieŋ wo chaanɩŋ ma, dɩ vuoŋ mana sɩmma a baarɩ Ŋmɩŋ beri ʋ tʋʋma mana ma. ");
INSERT INTO kma_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Genke kʋaŋ chaaŋ Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ ga Judia tɩŋgbaŋ ma, die ʋ yi daraa ale aŋaŋ ba, ta sɩa vuosi Ŋmɩŋ nyaaŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Saŋka mi Jɔɔn, vuodieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ die ye ka juu dansarɩka ma, ta bie Enoni, jigidieke nyaaŋ die dɩ faasɩna dala, ta vuosi die dɩ kieŋ ʋ jigiŋ ʋ sɩa ba Ŋmɩŋ nyaabʋ. Enoni die dɩ ka yʋa aŋaŋ Salimi. ");
INSERT INTO kma_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Daaŋ kaanɩ die Juu vuoŋ wʋnyɩ die dɩ piili a nɩga nɩnhagɩrɩŋ aŋaŋ Jɔɔn kʋaŋandɩɩsɩrɩba yaa gamma Ŋmɩŋ jɩamɩŋ nyaaŋ sɩɩla wɩa. ");
INSERT INTO kma_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Die wɩa die ba ga Jɔɔn jigiŋ a ga balɩ wa dɩ, “Dɩdagɩrʋ, vuodieke die dɩ benne aŋaŋ fʋ Jɔɔdani mʋgɩrɩ mi wo chaakʋ, daa dieke die fʋ bala dɩ ʋ yiwo Ŋmɩŋ Vuovʋarɩkɩrɩ, tɩ wʋŋ dɩ ʋ gbaŋ ʋ sɩa vuosi Ŋmɩŋ nyaaŋ, ta vuoŋ mana dɩ gara ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔɔn die dɩ yiŋŋi balɩ ba dɩ, “Vuoŋ kaaŋ bɩagɩ a yi wɩɩŋ ntaala Ŋmɩŋ vʋarɩna wa. ");
INSERT INTO kma_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nɩ gbaŋ gbaŋ nɩ yiwo n daansɩatieliŋ dɩ die n balɩya dɩ, manɩŋ n ka yi ‘Ŋmɩŋ Vuovʋarɩkɩŋ Masia wa, ama manɩŋ Ŋmɩŋ dɩ woliŋ a tʋŋ dɩ n dɩa ʋ nɩŋŋa a keŋ yi ʋ keniŋ siri.’ ");
INSERT INTO kma_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hɔgʋhaalʋ wa yiwo hɔgʋfaarɩtʋ wa sɩɩtɩ. Hɔgʋfaarɩtʋ wa zʋa ŋaaŋ zie mɩŋ, dɩɩ yi ʋ keŋ wʋŋ ʋ lɔlɩŋ, ʋ sʋŋ ŋaaŋ fɩalɩ mɩŋ. Die gbaŋ gbaŋ maŋ yaa sʋgɩfɩalɩŋ pam Masia wa wɩa. ");
INSERT INTO kma_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dɩ mʋ wʋnɩŋ Masia wa saaŋ jʋalɩma ta manɩŋ n saaŋ sʋʋma tɩŋgbaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Vuodieke dɩ nyɩnna ŋmɩŋsikpeŋ tɩaŋ vuoŋ mana mɩŋ, ama vuodiekemba dɩ nyɩna tɩŋgbaŋka gie, banɩŋ ba yiwo tɩŋgbaŋka gie tieliŋ, ta bala vuota wʋbalɩka. Vuodieke dɩ nyɩnna ŋmɩŋsikpeŋ tɩaŋ vuoŋ mana, ");
INSERT INTO kma_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","a bɩ gʋtɩ ʋ bala wudieke ʋ yene ta wʋŋ, ama vuoŋ ka tuose ʋ wɩaha. ");
INSERT INTO kma_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ta vuodieke mana dɩ tuone ʋ wɩaha dagɩya dɩ Ŋmɩŋ wɩa yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ŋmɩŋ Bʋadembiŋ dieke ʋ tʋnna wa balala Ŋmɩŋ wɩa, dama Ŋmɩŋ yi ʋ Bʋadembike Halɩkasɩ dieke dɩ dala ta wo magɩsɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ŋmɩŋ cho wo ʋ Bʋa wa ta nagɩ jaaŋ mana a yi ʋ nuusi me. ");
INSERT INTO kma_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Vuodieke nɩŋ mana dɩ yine Ŋmɩŋ Bʋa wa yada, yaa miivoli dieke dɩ wone kpatɩŋ, ama vuodieke nɩŋ mana dɩ kana a yi Bʋa wa yada kaaŋ ye miivoli mi, ama Ŋmɩŋ sɩnyɩɩrɩŋ nan dɩ bie ʋ ma yaa gamma haahuu. ");
INSERT INTO kma_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tɔ, die Farasisi vuosisi dɩ wʋŋ dɩ Yisa yese vuosi pam a sɩa ba Ŋmɩŋ nyaabʋ, ta ba yie ʋ kʋaŋandɩɩsɩrɩŋ a tɩaŋ Jɔɔn. ");
INSERT INTO kma_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wusie, die Yisa gbaŋ gbaŋ die ka sɩa vuosisi Ŋmɩŋ nyaabʋ ama die dɩ yiwo ʋ kʋaŋandɩɩsɩrɩba die sɩnana ba. ");
INSERT INTO kma_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Die Yisa die dɩ wʋnna wudieke vuosi dɩ balala yaa gamma ʋ ma wa, die ʋ nyɩŋ Judia tɩŋgbaŋ ma ta yiŋŋi ga Galili tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Die dɩ yi talasɩ dɩ ʋ daagɩ Samaria tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Die ʋ daagɩ mi a keŋ tʋgɩ tɩŋ kaanɩ ba wasɩnana Sayika, Samaria tɩŋgbaŋ ma, mi die ka yʋa aŋaŋ kʋaŋ dieke Jakobu die dɩ nagɩna a yɩ ʋ Bʋa Josefu wa. ");
INSERT INTO kma_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Die buluŋ dieke die dɩ yine Jakobu sɩɩtɩ wa die bie mi, die Yisa dɩ gbalɩgɩ aŋaŋ chɔmbʋ ta sʋʋŋ kalɩ buluke chɩaŋ. Die dɩ yiwo ŋmɩntʋasɩ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Die Samaria hɔgʋ wʋnyɩ dɩ keŋ dɩ ʋ yuori nyaaŋ, Yisa die dɩ balɩ yɩ wa dɩ, “Yɩ mɩŋ nyaaŋ aŋ n nyu.” ");
INSERT INTO kma_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Saŋka mi die ʋ kʋaŋandɩɩsɩrɩba die ga wa tɩka sʋŋ dɩ ba daa nyindiike. ");
INSERT INTO kma_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Juu vuosi die ka saaga dɩ ba lagɩŋ dii ta nyuo aŋaŋ Samaria vuosi a nyɩna kpalɩbalɩmɩŋ ma. Die wɩa Samaria hɔgʋ wa die dɩ yiŋŋi a pɩasɩ dɩ, “Fʋnɩŋ yiwo Juu vuoŋ ta manɩŋ maŋ yi Samaria vuoŋ, lalɩa fʋ jʋʋsa mɩŋ dɩ n yɩ fʋ nyaaŋ?” ");
INSERT INTO kma_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Dɩɩ yi fʋ tɩŋ sɩba piini dieke Ŋmɩŋ dɩ yaala ʋ yɩ fʋ, ta bɩ sɩba vuodieke n yine ta jʋʋsa fʋ nyaaŋ naa, tɩŋ nan pɩasɩ mɩŋ dɩ n yɩ fʋ miivoli nyaabʋ mi, ta n tɩŋ nan yɩ fʋ.” ");
INSERT INTO kma_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hɔgʋ wa die dɩ baarɩ dɩ, “Jakʋʋŋ, wo gʋʋga, ta buluke dɩ gole, sɩa fʋ baa fʋ ye miivoli nyaabʋ? ");
INSERT INTO kma_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tɩ chɔɔŋkʋʋŋ Jakobu die tune buluke gie a yɩ tɩ, ta wʋnɩŋ aŋaŋ ʋ ballɩ aŋaŋ ʋ dɔŋɩsɩ mana dɩ nyu a nyɩŋ ka ma. Yile dɩ tɩaŋ Jakobu mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yisa die dɩ yiŋŋi balɩ wa dɩ, “Vuodieke nɩŋ mana dɩ nyune nyaabʋ gie, nyanyuule nan bɩ yigi wo; ");
INSERT INTO kma_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ama vuodieke nɩŋ mana dɩ nyune nyaaŋ dieke n bala n yɩ wa, nyanyuule kaaŋ bɩ yigi wo. Nyaaŋ dieke n bala n yɩ wa wa nan bɩrɩŋ buluŋ ʋ sʋŋ ma a yɩa wa nyaaŋ dieke dɩ yɩnana miivoli, ta yɩ wa miivoli dieke dɩ wone kpatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hɔgʋ wa die dɩ balɩ yɩ wa dɩ, “Jakʋʋŋ, yɩ mɩŋ nyaabʋ gie a mʋ nyanyuule kaaŋ bɩ yigi mɩŋ ta n kaaŋ bɩ a keŋ gie a yuori nyaaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yisa die dɩ balɩ yɩ wa dɩ, “Ga a ga wa fʋ chʋrʋ aŋ nɩ viiri keŋ giena.” ");
INSERT INTO kma_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ʋ balɩ wa dɩ, “N wo chʋrʋ.” Yisa die dɩ yiŋŋi balɩ wa dɩ, “Fʋnɩŋ balɩ wa wusie, fʋ bala dɩ wo chʋrʋ wa. ");
INSERT INTO kma_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Dama die yallɩ wa chʋllɩŋ banʋ ta daa dieke fʋ benne ʋ jigiŋ lele wo dɩ ka seŋ yi fʋ chʋrʋ. Balɩ mɩŋ wa wusie.” ");
INSERT INTO kma_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hɔgʋ wa die dɩ baarɩ dɩ, “Jakʋʋŋ, n sɩba a baarɩ yiwo Ŋmɩŋ naazʋa. ");
INSERT INTO kma_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tɩnɩŋ Samaria vuosi chɔɔŋkʋʋlɩŋ die jɩama Ŋmɩŋ kunkogiri gie sikpeŋ ama nɩnɩŋ Juu vuosi baarɩ dɩ Jerusalemi ma yine jigidieke dɩ mʋna tɩ jɩaŋ Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yisa dɩ balɩ yɩ wa dɩ, “N taa, yi n wɩɩrɩ gie yada, saŋŋa kieŋ ta vuota dɩ kaaŋ jɩaŋ tɩ Chɔɔŋ Ŋmɩŋ kunkogiri gie sikpeŋ yaa Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nɩnɩŋ Samaria vuosi ka sɩba vuodieke nɩ jɩanna ama tɩnɩŋ Juu vuosi nɩŋ sɩba vuodieke tɩ jɩanna mɩŋ dama gbatɩtaanɩŋ wɩa nyɩŋ wa Juu vuosi jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama saŋŋa kieŋ, ta wɔŋ keŋ mɩŋ, saŋŋa dieke vuodiekemba dɩ senne jɩama tɩ chɔɔŋ Ŋmɩŋ wa nan seŋ jɩaŋ wa ʋ Halɩkasɩka hagɩrɩŋ ma ta sɩmma vuodieke ʋ yine, dama banɩŋ vuosi mi tɩ Chɔɔŋ dɩ yaala dɩ ba jɩama wa. ");
INSERT INTO kma_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ŋmɩŋ yiwo Haalɩŋ, ta vuodiekemba dɩ jɩanna wa mʋ ba jɩama wa aŋaŋ wusie, ʋ Halɩkasɩka hagɩrɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hɔgʋ wa die dɩ balɩ wa dɩ, “N sɩba a baarɩ Masia wa vuodieke ba wasɩnana Ŋmɩŋ Vuovʋarɩkɩrɩ nan keŋ, ta ʋ keŋ keŋ ʋ nan dagɩ tɩ wɩaha gie mana chɩasɩ.” ");
INSERT INTO kma_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yisa die dɩ yiŋŋi balɩ wa dɩ, “Manɩŋ n wonde, vuodieke dɩ balala wɩa aŋaŋ fʋ naa.” ");
INSERT INTO kma_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Womi die ʋ kʋaŋandɩɩsɩrɩba die dɩ yiŋŋi keŋ, die dɩ yi be mamachi pam ʋ balala wɩa aŋaŋ hɔgʋ wa, ama ba wʋnyɩ mana die ka pɩasɩ hɔgʋ wa dɩ, “Bɩa fʋ yaala?” Yaa a pɩasɩ Yisa dɩ “Bɩa fʋ bala wɩa aŋaŋ hɔgʋ wa?” ");
INSERT INTO kma_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Womi hɔgʋ wa die dɩ vaa ʋ kpagɩrɩ mi, ta yiŋŋi ga tɩka sʋŋ a balɩ yɩ vuosisi dɩ, ");
INSERT INTO kma_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nɩ keŋ ye daa dieke dɩ bala mɩŋ wudiekemba mana n yine. Ʋ baaŋ yi Ŋmɩŋ Vuovʋarɩkɩrɩ?” ");
INSERT INTO kma_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Die wɩa, die ba nyɩŋ tɩka ma a ga Yisa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Saŋka mi die Yisa kʋaŋandɩɩsɩrɩba die dɩ jʋʋsa wa dɩ, “Dɩdagɩrʋ dii nyindiike.” ");
INSERT INTO kma_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yisa die dɩ yiŋŋi balɩ ba dɩ, “N yaa wa nyindiike a baaŋ dii ta nɩ ka sɩba bʋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Die wɩa, ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasa taŋ dɩ, “Dɩ baaŋ yi vuoŋ yalla nyindiike a keŋ yɩ wa?” ");
INSERT INTO kma_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yisa die dɩ balɩ a yɩ ba dɩ, “Manɩŋ n nyindiike yi wo dɩ n yi vuodieke dɩ tʋnna mɩŋ wa dʋŋŋʋ a kpatɩ, ʋ tʋʋmaha ʋ nagɩna yɩ mɩŋ dɩ n tʋŋ wa. ");
INSERT INTO kma_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nɩnɩŋ nɩ ŋaaŋ bala dɩ, ‘Chɩɩtɩ a nɩɩsa tɩala ta zaaha gobiku tʋgɩ.’ Ama n bala nɩ dɩ nɩ mɩŋŋɩ a daansɩ kʋatɩtɩ, zaaha bieye mɩŋ aŋaŋ gobiŋ. ");
INSERT INTO kma_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ta zaagobiribe nan daansɩ tuo ba tune, ta zaa dieke ba gobinene wo, banɩŋ ba yine vuota diekemba dɩ baaŋ daansɩ ye miivoli dieke dɩ wone kpatɩŋ, ta vuodiekemba dɩ bʋrɩna wa aŋaŋ vuodiekemba dɩ gobine mana nan daansɩ yaa sʋgɩfɩalɩŋ zaaha wɩa. ");
INSERT INTO kma_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Dɩ yiwo wusie ba balla dɩ, ‘Bataŋ bʋrɩnana ta bataŋ dɩaŋ dɩ gobe.’ ");
INSERT INTO kma_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N tʋma nɩ dɩ nɩ ga gobi jigidieke nɩ kana ka bʋrɩya; vuosi bataŋ die kʋna ta nɩ keŋ die ka nyʋarɩ.” ");
INSERT INTO kma_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Die Samaria vuosi pam die dɩ wʋŋ hɔgʋ wa dɩ bala dɩ, “Yisa balɩ mɩŋ mɩŋ wudiekemba mana n yine”, ta die yi Yisa yada. ");
INSERT INTO kma_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Die wɩa die ba kenne ʋ jigiri, ba jʋʋsɩ wa dɩ ʋ wɩarɩ a bemme ba jigiŋ; die wɩa Yisa die dɩ wɩarɩ ba jigiŋ damʋʋma ale. ");
INSERT INTO kma_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vuosi pam die dɩ yiwo yada a gʋtɩ aŋaŋ wudieke ʋ balla wa, ");
INSERT INTO kma_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ta balɩ a yɩ hɔgʋ wa dɩ, “Lele tɩ yi yada mɩŋ, daa wudieke fʋ balla wa wɩa ama tɩ gbaŋ gbaŋ tɩ wʋŋ wa mɩŋ ta sɩba a baarɩ ʋ seŋ yiwo dʋnɩa ka gie gbɩgbatɩtaantʋ.” ");
INSERT INTO kma_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Die ka daraa ale kʋaŋ chaaŋ, Yisa die dɩ nyɩŋ mi a ga Galili tɩŋgbaŋ ma, ");
INSERT INTO kma_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","dama die ʋ wɔŋ baarɩ dɩ, “Ŋmɩŋ naazʋa wo jɩlɩma ʋ gbaŋ gbaŋ ʋ tɩŋgbaŋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Die ʋ gana a ga tʋgɩ Galili wo, mi vuosi die dɩ mɩŋŋɩ tuo wo chaantɩ dama die ba ga Jerusalemi mɩŋ a ga dii gasɩtɩaŋkʋ dʋʋgaka ta die ye ʋ yine wudiekemba mana dʋʋga ka saŋŋa. ");
INSERT INTO kma_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Die ʋ benne Galili tɩŋgbaŋ ma wa, ta die keŋ ga Keenani tɩŋ ma, jigidieke die ʋ vana nyaabʋ dɩ bɩrɩŋ daabʋ. Ta jakʋʋŋ wʋnyɩ dɩ bie Kapenɔmi ma ʋ bʋa dɩ yʋagɩ. ");
INSERT INTO kma_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Die ʋ wʋnna dɩ Yisa nyɩŋ Judia a keŋ Galili me wo, die ʋ ga Yisa jigiŋ a jʋʋsɩ wa dɩ ʋ keŋ Kapenɔmi a keŋ gbaaŋ ʋ bʋa wa dɩ yaalɩnana ʋ kpi wo. ");
INSERT INTO kma_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yisa die dɩ balɩ a yɩ wa dɩ, “Nɩ kaaŋ yi yada ntaala nɩ ye dagɩtɩ mamachi wʋkpɩɩma.” ");
INSERT INTO kma_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jakʋʋrɩ die dɩ baarɩ dɩ, “Jakʋʋŋ kiere dɩ daa die n bʋa wa nan kpi.” ");
INSERT INTO kma_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yisa die dɩ balɩ a yɩ wa dɩ, “Gamma, fʋ bʋa wa nan ye gbaamɩŋ.” Daa wa die dɩ yi Yisa yada ta ga. ");
INSERT INTO kma_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Die ʋ bene sieku me a gara wa, ʋ tʋntʋntɩŋ die dɩ tuoli wo sieku mi a balɩ wa dɩ, “Fʋ bʋa wa ye alaafɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ʋ pɩasɩ ba saŋŋa dieke ʋ bʋa wa dɩ yene alaafɩa wa, ba baarɩ dɩ, “Nyɩŋgbaŋ tuulibu va wa mɩŋ dienewo ŋmɩntʋasɩ bimbilimiŋ balɩmɩŋ saŋŋa.” ");
INSERT INTO kma_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bʋa wa chɔɔŋ wa die dɩ tɩɩnsɩ dɩ saŋka mi gbaŋ gbaŋ die Yisa dɩ balɩ wa dɩ, “Fʋ bʋa wa nan ye gbaamɩŋ.” Die wɩa wʋnɩŋ aŋaŋ ʋ tigiŋ vuosi mana die dɩ yi Yisa yada. ");
INSERT INTO kma_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mamachi wʋkpɩɩka gie die gʋtɩna bule Yisa dɩ yine ʋ nyɩnna Judia a ga Galili tɩŋgbaŋ ma wa. ");
INSERT INTO kma_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka kʋaŋ chaaŋ, Yisa die dɩ jʋalɩ ga Jerusalemi dɩ ʋ dii Juu vuosi dʋʋga kaanɩ. ");
INSERT INTO kma_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalemi ma, gbagɩŋ kaanɩ die dʋna aŋaŋ nyaaŋ a gbigi Yiise Sanʋaŋ, ta Juu vuosi jabalɩkɩŋ ma, ba wasa ka Befizata, ta die yaa lɩɩfaasɩ anʋ. ");
INSERT INTO kma_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mi die yʋagɩtieliŋ pam die dɩ ŋaaŋ dʋaga, bataŋ die yiwo yɩɩsɩ, bataŋ dɩ yi gbɩlɩsɩ, bataŋ dɩaŋ dɩ yi nyɩŋgbaŋ kpiititieliŋ. ((Die ba dʋa a chɩɩsa mɩŋ dɩ nyaabʋ dɔŋ, ");
INSERT INTO kma_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","dama saŋŋa ataŋ Ŋmɩŋ Malaka ŋaaŋ keŋ sʋʋŋ mɩŋ a dɔŋ nyaabʋ ta yʋagɩtieŋ dieke dɩ wolinne a ga nan nyaabʋ ma ŋaaŋ ye wo gbaamɩŋ a nyɩŋ yʋagɩ dieke mana ʋ yalla ma.)) ");
INSERT INTO kma_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Daa wʋnyɩ die dɩ bie mi a yʋagɩ die bɩna baŋɩsɩ-taa aŋaŋ anɩɩ. ");
INSERT INTO kma_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisa die dɩ ye wo ʋ dʋna mi ta mɩŋŋɩ dɩ ʋ yʋagɩ yʋasɩ mɩŋ, die wɩa die ʋ balɩ a yɩ wa dɩ, “Yaala fʋ ye alaafɩa mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Daa yʋagɩtieŋ wo die dɩ baarɩ dɩ, “Jakʋʋŋ, n wo vuoŋ mana giena ʋ baaŋ nagɩ mɩŋ a yi nyaabʋ ma dɩɩ yi nyaabʋ dɩ keŋ dɔŋ; maŋ keŋ mɩa dɩ n juu bʋ sʋŋ, vuogaaŋ ŋaaŋ woliŋ mɩŋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yisa die dɩ balɩ a yɩ wa dɩ, “Hagɩ a nagɩ fʋ kalɩŋŋa a chʋmma.” ");
INSERT INTO kma_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lele womi daa wa die dɩ ye alaafɩa; ta nagɩ ʋ kalɩŋŋa a dɩɩ chʋŋ. Daa dieke wɩɩrɩ gie die dɩ yine wo die yiwo davʋʋsɩkɩrɩ daaŋ, ");
INSERT INTO kma_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","die wɩa Juu vuosi nyɩŋkʋraha die dɩ ballɩ a yɩ daa dieke dɩ yene gbaaŋkʋ dɩ, “Davʋʋsɩkɩŋ daaŋ wʋnna. Tɩ mɩraha ka yɩ sieŋ dɩ fʋ chii fʋ kalɩŋŋa.” ");
INSERT INTO kma_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Die daa wa die dɩ yiŋŋi a balɩ ba dɩ, “Daa dieke dɩ gbaanna mɩŋ wa balɩ mɩŋ mɩŋ dɩ, ‘Nagɩ fʋ kalɩŋŋa a chʋmma.’ ” ");
INSERT INTO kma_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba pɩasɩ wa dɩ, “Mɩnɩa yine daa dieke dɩ balla fʋ dɩ fʋ nagɩ fʋ kalɩŋŋa a chʋmma wa?” ");
INSERT INTO kma_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama daa wa die ka sɩba vuodieke dɩ gbaanna wa, dama kpɩkpaaŋ die benne mi ta Yisa die dɩ wɔŋ nyɩŋ mi a ga. ");
INSERT INTO kma_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ka kʋaŋ chaaŋ die Yisa die dɩ ye daa wa Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a balɩ a yɩ wa dɩ, “Ye, lele ye alaafɩa mɩŋ, die wɩa vaa fʋ tʋntʋmbɩatɩtɩ, dɩ daa die wʋbɩaŋ dɩ tɩanna naa nan keŋ fʋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yisa die dɩ balla aŋaŋ daa wa a kpatɩ wa kʋaŋ chaaŋ, daa wa die dɩ nyɩŋ mi a ga balɩ Juu vuosi nyɩŋkʋraha dɩ dɩ yiwo Yisa die gbaanna wa wa. ");
INSERT INTO kma_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta nyɩŋkʋraha die dɩ piili a mugise Yisa dama ʋ gbaanna daa wa davʋʋsɩkɩrɩ daarɩ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “N Chʋa Ŋmɩŋ tʋma mɩŋ saŋŋa mana ta n gbaŋ dɩ tʋma die.” ");
INSERT INTO kma_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yisa balɩkʋ gie die dɩ vaa Juu vuosi nyɩŋkʋraha dɩ faasɩ a ŋmɩntɩ niŋ dɩ ba kʋʋ wa, daa ʋ chʋʋsɩna davʋʋsɩkɩrɩ daarɩ mɩrɩka nyɩɩna ma wɩa ama ʋ balla dɩ Ŋmɩŋ yiwo ʋ chɔɔŋ wa, ka dagɩ dɩ ʋ naga wa ʋ gbaŋ a magɩsa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Die wɩa Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Wusie maŋ bala nɩ: Manɩŋ Bʋa wa kaaŋ bɩagɩ a yi wɩɩŋ n gbaŋ gbaŋ n dʋŋŋʋ ma ama n yie wudieke n yene n Chʋa wa dɩ yinene. Dama n Chʋa wa dɩ yinene wudieke wo, kanɩŋ manɩŋ Bʋa wa dɩaŋ dɩ yie. ");
INSERT INTO kma_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dama n Chʋa dɩ faasɩna cho mɩŋ wɩa ʋ dagɩ mɩŋ wudieke mana wʋnɩŋ ʋ gbaŋ gbaŋ dɩ yinene. Ʋ nan dagɩ mɩŋ wʋkpɩɩma diekemba dɩ tɩanna naa, aŋ a yi nɩ mamachi. ");
INSERT INTO kma_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sɩba n Chʋa dɩ vasɩnana kunti dɩ haga kunti me wo, ta yɩa ba miivoli die wo, die gbaŋ gbaŋ manɩŋ vuodieke dɩ yine Bʋa wa dɩ yɩa vuodiekemba n yaalala miivoli. ");
INSERT INTO kma_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","N Chʋa ka die vuoŋ sarɩya, ama ʋ yɩ wa manɩŋ ʋ Bʋa wa sieŋ dɩ n dii vuosi sarɩya, ");
INSERT INTO kma_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","amʋ vuoŋ mana yɩma mɩŋ jɩlɩma sɩba ba yɩnana n Chʋa Ŋmɩŋ jɩlɩma dene wo. Vuodieke nɩŋ mana dɩ kana ka yɩ mɩŋ jɩlɩma ka dagɩ sɩba ʋ ka yɩa n Chʋa Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ wa jɩlɩma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Wusie maŋ bala nɩ, vuodieke nɩŋ mana dɩ wʋnna n wɩaha gie ta yi vuodieke dɩ tʋnna mɩŋ wa yada yaa wa miivoli dieke dɩ wone kpatɩŋ, ta Ŋmɩŋ kaaŋ bɩ dii ʋ sarɩya a chʋʋsɩ wa, ama ʋ wɔŋ nyɩŋ wa kuŋ me a juu miivoli me mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Wusie maŋ bala nɩ, saŋŋa kieŋ ta ka wɔŋ keŋ mɩŋ ta kunti nan wʋŋ manɩŋ Ŋmɩŋ Bʋa wa lɔlɩŋ, ta vuodiekemba mana dɩ wʋnna n lɔlɩkʋ nan ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","N Chʋa Ŋmɩŋ dɩ sɩna miivoli a yɩa vuosi dene wo, die gbaŋ gbaŋ ʋ yɩ manɩŋ ʋ Bʋa wa dɩ n sɩmma miivoli a yɩma vuosi. ");
INSERT INTO kma_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta bɩ yɩ mɩŋ yiko dɩ n dii vuosi sarɩya, dama n yi wo Vuota Bʋa. ");
INSERT INTO kma_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nɩ da vaa ka yi nɩ mamachi, saŋŋa kieŋ ta vuodiekemba mana dɩ kpine nan daansɩ wʋŋ n lɔlɩŋ, ");
INSERT INTO kma_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ta hagɩ kuŋ me; ta vuodiekemba dɩ yine vɩɩnɩŋ nan hagɩ ta ye miivoli dieke dɩ wone kpatɩŋ, ta vuodiekemba dɩaŋ dɩ yine wʋbɩatɩtɩ nan hagɩ aŋ n dii ba sarɩya ta baarɩ ba chʋʋsɩya. ");
INSERT INTO kma_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Manɩŋ n kaaŋ bɩagɩ a yi wɩɩŋ aŋaŋ n gbaŋ gbaŋ yiko, n die vuosi sarɩya sɩba Ŋmɩŋ dɩ balala mɩŋ die, ta n sarɩyaka dɩ yi wusie, dama n ka mɩa dɩ n yi wudieke n sʋŋ dɩ yaalɩnana, ama n yaala dɩ n yiwo wudieke vuodieke dɩ tʋnna mɩŋ wa dɩ yaalɩnana. ");
INSERT INTO kma_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Dɩɩ yi maŋ dii n gbaŋ gbaŋ n siara, vuosi kaaŋ tuo a dii dɩ dɩ yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ama vuoŋ benne a bala vuosi yaa gamma vuodieke n yine. Wʋnɩŋ ʋ yiwo Ŋmɩŋ, ta maŋ sɩba dɩ ʋ balɩkʋ yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Die nɩ tʋŋ wa tʋntʋntɩŋ Jɔɔn vuodieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ jigiŋ, ta ʋ gbaŋ die dɩ balɩ wusie yaa gamma n ma. ");
INSERT INTO kma_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dɩ ka yi talasɩ dɩ vuoŋ balɩ wɩa yaa gamma n ma, ama n balɩ nɩ naa amʋ nɩ nan ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔɔn die sɩɩ sɩba popoli dɩ ŋaana die ta chaana, ta die nɩ nagɩ saŋŋa bɩta a dii nansɩŋ ʋ chaaŋkʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ama mamachi wʋkpɩɩma diekemba n tʋnnana, hanɩŋ daga n siara a tɩaŋ wudieke Jɔɔn die dɩ balala yaa gamma n ma wa. Tʋnkpɩɩma diekemba n tʋnnana wa yiwo tʋŋ dieke n Chʋa Ŋmɩŋ dɩ nagɩna a yɩ mɩŋ dɩ n tʋŋ, ta tʋʋmaha dɩ yi siara a dagɩ dɩ n Chʋa Ŋmɩŋ tʋnna mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“A bɩ gʋtɩ, n Chʋa Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ wa gbaŋ yiwo n siara. Ta nɩ ye ka wʋŋ ʋ lɔlɩŋ yaa a ye wo aŋaŋ nɩ nine, ");
INSERT INTO kma_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ta nɩ ka nagɩ ʋ wɩaha a yi nɩ sʋgɩtɩ ma, dama nɩ ka yi vuodieke ʋ tʋnna wa yada. ");
INSERT INTO kma_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Nɩ ŋaaŋ karɩma Ŋmɩŋ gbaŋkʋ mɩŋ ta yile dɩ nɩ nan ye miivoli dieke dɩ wone kpatɩŋ a ma, ta Ŋmɩŋ gbaŋkʋ mi dɩ bala n wɩa, ");
INSERT INTO kma_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ama ta nɩ zeti dɩ nɩ keŋ n jigiŋ aŋ n yɩ nɩ miivoli mi. ");
INSERT INTO kma_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“N ka yaala bɩrɩŋ vuota jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","N wɔŋ sɩba mɩŋ dɩ nɩ ka wɔŋ cho Ŋmɩŋ nɩ sʋgɩtɩ ma. ");
INSERT INTO kma_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N keŋye mɩŋ n Chʋa Ŋmɩŋ saaŋ ma, ta nɩ ka tuo mɩŋ. Ama dɩɩ yi vuoŋ dɩ keŋ ʋ gbaŋ gbaŋ saaŋ ma, nɩ tuose wo mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɩ yaala nɩ ye bɩrɩŋ a nyɩmma tamba jigiŋ ama nɩ ka mɩa dɩ nɩ ye bɩrɩŋ a nyɩmma Ŋmɩŋ balɩŋka jigiŋ. Die wɩa nɩ ka yi mɩŋ yada wa. ");
INSERT INTO kma_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nɩ da yilime dɩ n nan galɩŋ nɩ n Chʋa Ŋmɩŋ nɩŋŋa. Dama vuodieke dɩ balla ʋ galɩŋ nɩ, wʋnɩŋ ʋ yine Mosisi, vuodieke nɩ yine yada wa. ");
INSERT INTO kma_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Dɩɩ yi die nɩ seŋ yi Mosisi maagɩkʋ yada, nɩ tɩŋ nan yi mɩŋ yada, dama die ʋ maagɩya mɩŋ yaa gamma n wɩa. ");
INSERT INTO kma_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama nɩ kana ka yi wudieke ʋ maagɩna yada wa, lalɩa nɩ baa nɩ yi n wʋbalɩkaha gie yada?” ");
INSERT INTO kma_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Naa kʋaŋ chaaŋ Yisa die dɩ nyɩŋ mi a garɩsɩ Galili gbagɩkpɩɩŋ dieke ba bɩna wasa Tiberisi wo. ");
INSERT INTO kma_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Die kpɩkpaaŋ die dɩ dɩ wa, dama die ba ye ʋ mamachi tʋnkpɩɩma diekemba ʋ yine wo ta yi yʋagɩtieliŋ dɩ ye gbaamɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ta Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ jʋalɩ kunkogiŋ a kalɩ. ");
INSERT INTO kma_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Saŋka mi ta Juu vuosi gasɩtɩaŋkʋ dʋʋgaka die gbigiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisa die dɩ kala wa die ʋ keŋ ye kpɩkpaaŋ dɩ kienene ʋ jigiŋ. Die ʋ pɩasɩ Filipi dɩ, “Sɩa tɩ nan ye nyindiike a daa a yɩ vuosi gie mana?” ");
INSERT INTO kma_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Die ʋ pɩasa naa, dɩ ʋ magɩsɩ Filipi a ye, dama die ʋ wɔŋ sɩba wudieke ʋ bala ʋ yi mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ta Filipi die dɩ yiŋŋi balɩ wa dɩ, “Dɩɩ yi tɩ yaala dɩ tɩ daa paanʋ a yɩ vuosi gie, bʋ ligire nan tɩaŋ salɩma ligire bie kɔbɩsɩ-le, ta vuoŋ mana ye ye bɩta.” ");
INSERT INTO kma_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ ba wasɩna Andurusi ta yi Simoni Piita nɩmbʋa wa die dɩ baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bʋa wʋnyɩ benne giena a yaa paanʋ golime anʋ aŋaŋ zaasɩbɩsɩ ale. Ama a kaaŋ bɩagɩ a yi vuosi gie mana wɩɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yisa die dɩ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Vaa vuosisi sʋʋŋ kala tɩŋgbaŋ.” Hʋʋbɩsɩ pam die benne mi, ta vuosisi dɩ sʋʋŋ kalɩ tɩŋgbaŋ, ta dembisi die yiwo tuse anʋ mi. ");
INSERT INTO kma_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yisa die dɩ nagɩ paanʋ golimehe a bɩrɩ Ŋmɩŋ ta die nagɩ a yɩ ba tɩa tɩa a yɩ vuodiekemba dɩ kala mi wo. Ta die bɩ nagɩ zaasɩbɩsɩsɩ a yi die gbaŋ gbaŋ, ba mana die dɩ dii a tʋgɩ ba yaalɩnana dene. ");
INSERT INTO kma_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Die ba mana die dɩ dine a chagɩ wa, ʋ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ vaarɩ nyintɩalɩkaha mana ta da vaa a taaŋ yɔrɩ.” ");
INSERT INTO kma_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Die wɩa die ba vaarɩ vuosisi dɩ dine paanʋ golime anʋ ta tɩalɩ tɩalɩ wa a suuli kparɩsɩ baŋ aŋaŋ ale. ");
INSERT INTO kma_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Die vuodiekemba dɩ benne mi ta ye Yisa dɩ yine mamachi wʋkpɩɩka gie wo die dɩ baarɩ dɩ, “Wusie, daa wa seŋ yiwo Ŋmɩŋ naazʋa dieke Mosisi dɩ bala dɩ ʋ nan keŋ dʋnɩa ka gie me wo.” ");
INSERT INTO kma_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yisa die dɩ mɩŋŋɩ dɩ ba yie siri dɩ ba keŋ a yigi wo aŋaŋ hagɩrɩŋ a yi wo naaŋ; die wɩa die ʋ bɩ yiŋŋi jʋalɩ ga kunkogiri me a ga bie ʋ nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Die jɩŋmɩŋ die dɩ tʋgɩna, ʋ kʋaŋandɩɩsɩrɩba die dɩ sʋʋŋ ga gbagɩkpɩɩrɩ ma, ");
INSERT INTO kma_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","a nagɩ haarɩŋ a garɩsɩ gbagɩkpɩɩrɩ a yiŋŋi gara Kapenɔmi. Yuŋ die dɩ sibe ta Yisa die dɩ ye ka keŋ gʋtɩ ba ma. ");
INSERT INTO kma_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Saŋka gie bʋlɔgɩsɩkpeŋkpɩɩŋ die dɩ nɩga ta dɔma nyaabʋ. ");
INSERT INTO kma_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Die Yisa kʋaŋandɩɩsɩrɩba die dɩ dɔŋ a ga sɩba malisi ataa yaa anɩɩsa, ta die keŋ ye Yisa dɩ chʋnnana nyaabʋ sikpeŋ a keŋ gbige haarɩkʋ, ta ŋmaamɩŋ die dɩ yigi be. ");
INSERT INTO kma_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yisa die dɩ balɩ ba dɩ, “Nɩ da vaa ŋmaamɩŋ yalla nɩ, dɩ yiwo manɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Die ba nagɩ wa aŋaŋ sʋgɩfɩalɩŋ a yi haarɩkʋ ma, ta lele womi ba haarɩkʋ die dɩ ga tʋgɩ gbagɩkpɩɩrɩ nʋaŋ jigidieke chaaŋ die ba ganana wa. ");
INSERT INTO kma_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ka tʋnvʋʋsa die kpɩkpaaŋ dieke die dɩ wɩarɩna gbagɩkpɩɩrɩ mi wo chaakʋ die dɩ ye dɩ haarɩ balɩmɩŋ nyɩɩna ma tɩalɩna mi. Die ba sɩba dɩ dienewo Yisa ka juu haarɩkʋ a ga aŋaŋ ʋ kʋaŋandɩɩsɩrɩba, dama die ba gaya mɩŋ ta va wa. ");
INSERT INTO kma_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Die haarɩsɩ ataŋ die dɩ nyɩŋ Tiberisi a keŋ zie gbagɩkpɩɩrɩ kʋanʋaŋ jigidieke die tɩ Yɔmʋtieŋ dɩ nagɩna paanʋkʋ a bɩrɩ Ŋmɩŋ ta kpɩkpaakʋ dɩ dii wo. ");
INSERT INTO kma_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Die kpɩkpaakʋ dɩ yene ta Yisa aŋaŋ ʋ kʋaŋandɩɩsɩrɩba wo mi wo, die ba juu haarɩsɩ mi a ga Kapenɔmi a dɩ dɩa yaala Yisa. ");
INSERT INTO kma_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Die vuosisi die dɩ jʋalɩna a ye Yisa gbagɩkpɩɩrɩ mi chaakʋ, die ba pɩasɩ wa dɩ, “Dɩdagɩrʋ, saŋŋa bɩa fʋ keŋ giena?” ");
INSERT INTO kma_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Wusie maŋ bala nɩ, nɩnɩŋ nɩ dɩ dɩa a yaala mɩŋ da nɩ yene mamachi dagɩtɩ wɩa ama die n yɩna nɩ nyindiike nɩ dii chagɩ wa wɩa. ");
INSERT INTO kma_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nɩ da tʋmma tʋʋma nyindiike diekemba dɩ chʋʋsɩnana wɩa, ama nɩ tʋmma tʋʋma nyindiike diekemba dɩ yɩnana vuosi miivoli dieke dɩ wone kpatɩŋ wɩa. Manɩŋ Vuota Bʋa nan yɩ nɩ kanɩŋ nyindiike mi, dama n Chʋa Ŋmɩŋ yɩna mɩŋ kanɩŋ yiko dɩ n yɩma nɩ.” ");
INSERT INTO kma_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Die wɩa die ba pɩasɩ wa dɩ, “Bɩa tɩ ba tɩ tʋŋ aŋ ka yi Ŋmɩŋ tʋʋma?” ");
INSERT INTO kma_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Ŋmɩŋ yaala nɩ yiwo vuodieke ʋ tʋnna wa yada.” ");
INSERT INTO kma_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Die ba yiŋŋi balɩ dɩ, “Mamachi wʋbɩa fʋ nan yi aŋ tɩ ye ta yi fʋ yada? Bɩa fʋ baa fʋ yi? ");
INSERT INTO kma_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tɩ chɔɔŋkʋʋlɩba die dii wo nyindiike dieke ba wasɩnana maana saŋŋa dieke ba benne hagɩrɩ ma, sɩba ba maagɩna Ŋmɩŋ gbaŋkʋ ma die wo dɩ, ‘Ʋ yɩ ba wa nyindiike a nyɩŋ arɩzanna ma dɩ ba dii.’ ” ");
INSERT INTO kma_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yisa die dɩ baarɩ dɩ, “Wusie maŋ bala nɩ, daa Mosisi die yɩna nɩ nyindiike a nyɩŋ arɩzanna ma wa, ama dɩ yiwo n Chʋa Nabidie Ŋmɩŋ, wʋnɩŋ ʋ yɩna nɩ wusie nyindiike dieke dɩ nyɩna arɩzanna ma wa. ");
INSERT INTO kma_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nyindiike dieke Ŋmɩŋ dɩ yɩnana nɩ wa, yiwo vuodieke dɩ nyɩna arɩzanna a keŋ sʋʋŋ ta yɩa dʋnɩaka gie vuosi miivoli wo.” ");
INSERT INTO kma_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Die ba baarɩ, “Jakʋʋŋ, yɩma tɩ nyindiike gie daaŋ mana.” ");
INSERT INTO kma_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yisa die dɩ balɩ yɩ ba dɩ, “Manɩŋ n yine miivoli nyindiikehe. Vuodieke dɩ kienene n jigiŋ, kɔŋ kaaŋ bɩ yigi wo, ta vuodieke dɩaŋ dɩ yi mɩŋ yada nyanyuule kaaŋ yigi wo. ");
INSERT INTO kma_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","N wɔŋ balɩ nɩ dɩ nɩ ye mɩŋ mɩŋ, ama nɩ ka yi mɩŋ yada. ");
INSERT INTO kma_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ama vuodieke nɩŋ mana n Chʋa Ŋmɩŋ dɩ nagɩna yɩ mɩŋ, nan keŋ n jigiŋ a yi mɩŋ yada, ta n kaaŋ yagɩ vuodieke nɩŋ dɩ kienene n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Dama n nyɩŋ wa arɩzanna ma a keŋ sʋʋŋ dɩ n yi Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ dʋŋŋʋ daa manɩŋ n dʋŋŋʋ. ");
INSERT INTO kma_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wʋnɩŋ Ŋmɩŋ die dɩ tʋnna mɩŋ wa, ʋ choti yiwo dɩ n daa vaa vuodiekemba ʋ nagɩna yɩ mɩŋ wa wʋnyɩ bɩa, ama a keŋ sʋgɩrɩ ba mana a nyɩŋ kuŋ me dʋnɩa kpatɩŋ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wudieke n Chʋa dɩ yaalala wʋnna; dɩ vuodiekemba mana dɩ yene ʋ Bʋa wa ta yiwo yada wa, yallɩma miivoli dieke dɩ wone kpatɩŋ; ta n nan daansɩ sʋgɩrɩ ba mana a nyɩŋ kuŋ me dʋnɩa kpatɩŋ daraaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Die Juu vuosisi die dɩ piili a vʋʋna wɩa, die ʋ bala dɩ, “Manɩŋ n yine nyiindiike dɩ nyɩna arɩzanna ma a keŋ sʋʋŋ wa.” ");
INSERT INTO kma_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Die ba pɩasa tamba dɩ, “Daa daa wa gie yine Josefu bʋa, Yisa wa? Ta tɩ sɩba ʋ chɔɔŋ aŋaŋ ʋ nuŋ wo? Lalɩa ʋ baarɩ dɩ ʋ nyɩŋ wa arɩzanna ma a keŋ sʋʋŋ?” ");
INSERT INTO kma_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Nɩ vaa vʋʋnɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Vuoŋ kaaŋ bɩagɩ keŋ n jigiŋ, ntaala n Chʋa Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ wa yaa wa keŋ, ta n nan daansɩ sʋgɩrɩ wa a nyɩŋ kuŋ me dʋnɩa kpatɩŋ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ŋmɩŋ naazʋalɩba die maagɩya Ŋmɩŋ gbaŋkʋ sʋŋ dɩ, ‘Ŋmɩŋ nan dagɩ vuota mana.’ Ta vuodieke mana dɩ wʋnna n Chʋa Ŋmɩŋ ta tuose ʋ wɩaha, wʋnɩŋ ʋ kieŋ wo n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Vuoŋ ye ka ye n Chʋa Ŋmɩŋ, sie manɩŋ vuodieke dɩ nyɩnna ʋ jigiŋ nyɩɩna ma yene wo. ");
INSERT INTO kma_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Wusie maŋ bala nɩ, vuodieke dɩ yine mɩŋ yada, wʋnɩŋ ʋ yaa wa miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Manɩŋ n yine miivoli nyindiikehe. ");
INSERT INTO kma_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nɩ chɔɔŋkʋʋlɩba die dii wo maana hagɩrɩ ma, ama ta die kpi. ");
INSERT INTO kma_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama nyindiike dieke dɩ nyɩnna arɩzanna ma a keŋ sʋʋŋ nɩŋ, vuodieke dɩ dine he kaaŋ kpi. ");
INSERT INTO kma_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Manɩŋ n yine miivoli nyindiikehe die dɩ nyɩnna arɩzanna ma a keŋ sʋʋŋ wa. Vuodieke dɩ dine nyindiikehe gie, nan dɩ yaa miivoli dieke dɩ wone kpatɩŋ. Nyindiike gie yiwo n nyɩŋgbanɩŋ, kanɩŋ maŋ baa n nagɩ yɩ amʋ tɩŋgbaŋka gie vuosi nan dɩ yaa miivoli.” ");
INSERT INTO kma_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wɩɩrɩ gie die dɩ vaa Juu vuosi dɩ piili a nɩga nɩnhagɩrɩŋ ta pɩasa taŋ dɩ, “Lalɩa daa wa gie dɩ baa ʋ yi a yɩ tɩ ʋ nyɩŋgbanɩŋ aŋ tɩ ŋɔbɩ?” ");
INSERT INTO kma_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yisa die dɩ balɩ a yɩ ba dɩ, “Wusie maŋ bala nɩ, ntaala nɩ ŋɔbɩ manɩŋ Vuota Bʋa nyɩŋgbanɩŋ ta nyu n zɩmbʋ, nɩ kaaŋ dɩ yaa miivoli nɩ ma. ");
INSERT INTO kma_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Vuodieke nɩŋ mana dɩ ŋɔbɩna n nyɩŋgbanɩŋ ta nyu n zɩmbʋ yaa wa miivoli dieke dɩ wone kpatɩŋ, ta n nan daansɩ sʋgɩrɩ wa a nyɩŋ kuŋ me dʋnɩa kpatɩŋ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","N nyɩŋgbanɩŋ yine wusie nyindiike ta n zɩmbʋ dɩ yi wusie nyiŋnyuuke. ");
INSERT INTO kma_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Vuodieke dɩ ŋɔbɩna n nyɩŋgbanɩŋ ta nyu n zɩmbʋ bie wo n ma, ta n dɩaŋ maŋ bie ʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“N Chʋa Ŋmɩŋ vuodieke dɩ sɩna miivoli tʋnna mɩŋ, ta ʋ wɩa maŋ yallɩ miivoli. Die gbaŋ gbaŋ dɩ sɩɩ, vuodieke dɩ ŋɔbɩna n nyɩŋgbaŋka nan dɩ yaa miivoli n wɩa. ");
INSERT INTO kma_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Manɩŋ n yine nyindiike dieke dɩ nyɩna arɩzanna ma a keŋ wo. Ta vuodieke nɩŋ mana dɩ dine nyindiikehe, nan dɩ bie ʋ mɩsɩ ma yaa gamma haahuu; hanɩŋ nyindiikehe mi ka sɩɩ sɩba nyindiike dieke nɩ chɔɔŋkʋʋlɩba dɩ dine ama ta keŋ kpi wo.” ");
INSERT INTO kma_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisa die balɩ wa naa saŋŋa dieke die ʋ dagɩnana Kapenɔmi Ŋmɩŋ jɩamɩŋ juoku me wo. ");
INSERT INTO kma_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yisa kʋaŋandɩɩsɩrɩba pam die dɩ wʋnna ʋ dagɩkʋ gie die ba baarɩ dɩ, “Dagɩkʋ gie faasɩ hagɩrɩ mɩŋ. Mɩnɩa baaŋ bɩagɩ tuoke?” ");
INSERT INTO kma_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Vuoŋ die ka balɩ Yisa, ama die ʋ mɩŋŋɩ dɩ ʋ kʋaŋandɩɩsɩrɩba vʋʋna wɩa yaa gamma wudieke ʋ bala wa. Die ʋ pɩasɩ ba dɩ, “Wɩɩrɩ gie vaa nɩ yaala nɩ yiŋŋi mɩŋ? ");
INSERT INTO kma_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Dɩɩ yi nɩ ye manɩŋ Vuota Bʋa dɩ jʋalɩna a gara arɩzanna jigidieke n nyɩnna keŋ wo, lalɩa nɩ baa nɩ yili? ");
INSERT INTO kma_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ŋmɩŋ Halɩkasɩka yɩnana vuota miivoli, ama vuota gbaŋ gbaŋ kaaŋ bɩagɩ yi naa. Wʋbalɩkɩ diekemba n bala a yɩ nɩ wa yaa wa Ŋmɩŋ Haalɩŋ dieke dɩ yɩnana vuosi miivoli a kieŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama nɩ bataŋ ka yi yada.” Yisa die wɔŋ sɩba mɩŋ a nyɩŋ piiliku me vuodiekemba dɩ kana ka baa ba yiwo yada aŋaŋ vuodieke dɩ bala ʋ posi ʋ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Die ʋ balɩ gʋtɩ dɩ, “Naa wɩa maŋ balɩ nɩ dɩ vuoŋ kaaŋ bɩagɩ a keŋ n jigiŋ ntaala n Chʋa Ŋmɩŋ yɩ wa sieŋ dɩ ʋ keŋ.” ");
INSERT INTO kma_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Naa wɩa die ʋ dɩdɩɩsɩrɩba pam die dɩ yiŋŋi ta ka bɩ dɩ ʋ kʋaŋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Die wɩa Yisa die dɩ pɩasɩ ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo dɩ, “Ta nɩ gbaŋ nɩ nan va mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ta Simoni Piita die dɩ yiŋŋi a balɩ dɩ, “Tɩ Yɔmʋtieŋ, mɩnɩa jigiŋ tɩ baa tɩ ga? Fʋnɩŋ fʋ yalla wʋbalɩka dieke dɩ yɩnana miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ta lele tɩ yi fʋ yada mɩŋ ta sɩba a baarɩ fʋ yine Ŋmɩŋ vuokasɩ wa.” ");
INSERT INTO kma_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Nɩnɩŋ vuosi baŋ aŋaŋ bale wa gie, manɩŋ n vʋarɩna nɩ, ama nɩ wʋnyɩ yiwo Sitaani sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Die ʋ bala yaa gamma Judasi vuodieke dɩ yine Simoni Asikaroti bʋa wa wɩa. Wʋnɩŋ ʋ yiwo ʋ kʋaŋandɩɩsɩrɩŋ baŋ aŋaŋ bale wo wʋnyɩ, ta die baa ʋ keŋ posi ʋ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Naa kʋaŋ chaaŋ Yisa die dɩ dɩa Galili tɩŋgbaŋ ma; ta die ka dɩa Judia tɩŋgbaŋ ma dama Juu vuosi nyɩŋkʋraha die yaala ba kʋʋ wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Die Juu vuosi dʋʋga dieke ba wasɩna jaga dʋʋgaka die dɩ gbigi, ");
INSERT INTO kma_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","die wɩa Yisa nɩmballɩ die dɩ balɩ a yɩ wa dɩ, “Nyɩŋ gie a ga Judia tɩŋgbaŋ ma amʋ fʋ kʋaŋandɩɩsɩrɩba dɩ benne mi wo nan ye tʋŋ dieke fʋ tʋnnana. ");
INSERT INTO kma_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vuodieke dɩ yaalɩnana vuosi sɩmma ʋ wɩa ka lɔbɩra wudieke ʋ yinene. Fʋ yinene wɩaha gie wo, vaa dʋnɩa mana sɩmma fʋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ʋ nɩmballɩ gbaŋ die ka yiwo yada. ");
INSERT INTO kma_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yisa die dɩ balɩ a yɩ ba dɩ, “N saŋŋa ye ka keŋye. Ama nɩnɩŋ nɩŋ saŋŋa mana mʋ a yi nɩ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nɩnɩŋ nɩŋ, dʋnɩaka gie vuosi ka haa nɩ, ama ba haa mɩŋ mɩŋ dama n balala dɩ wudieke ba yinene wo yiwo bɩaŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nɩnɩŋ nɩ gamma dʋʋgaka, manɩŋ n ka gara dʋʋgaka gie dama n saŋŋa ye ka tʋgɩya.” ");
INSERT INTO kma_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Die ʋ balɩ ba naa, ta wɩarɩ bie Galili me. ");
INSERT INTO kma_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Die Yisa nɩmballɩ die dɩ gana dʋʋgaka kʋaŋ chaaŋ, Yisa gbaŋ die dɩ ga; ama die ʋ ka ga yaalɩŋ ma ama die ʋ lɔbɩrɩ a ga mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Die Juu vuosi nyɩŋkʋraha die dɩ dɩdɩa a yaala wa dʋʋgaka ma, ta die pɩasa vuosi dɩ, “Sɩa daa wa dɩ beri?” ");
INSERT INTO kma_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Die vuosi pam die bie mi a pʋʋsa bala ʋ wɩa; bataŋ die dɩ baarɩ dɩ, “Ʋ yiwo vuovɩɩnɩŋ”, bataŋ dɩaŋ dɩ baarɩ dɩ, “Aayɩ, ʋ gaama vuosi mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama ba wʋnyɩ die ka yuori balɩ ʋ wɩa dama die ba chɩga Juu vuosi nyɩŋkʋraha mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Die dʋʋgaka die tʋgɩ wa sʋnsʋŋ ta die Yisa dɩ ga Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a piili a daga vuosi Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Die Juu vuosi nyɩŋkʋraha die dɩ wʋnna wa, die dɩ yi be mamachi, ba pɩasa dɩ, “Lalɩa daa wa gie dɩ yi a sɩba wɩa dene ta ka ga tɩ siikusi?” ");
INSERT INTO kma_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Wudieke n dagɩna wa ka yi n gbaŋ gbaŋ n dagɩŋ, ama a nyɩŋ wa Ŋmɩŋ jigiŋ, vuodieke dɩ tʋnna mɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Vuodieke mana dɩ yaalɩnana ʋ yi wudieke Ŋmɩŋ dɩ yaalala nan dɩ sɩba dɩ wudieke n dagɩnana wa nyɩŋ wa Ŋmɩŋ jigiŋ yaa n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Vuodieke dɩ balala ʋ gbaŋ gbaŋ ʋ dagɩŋ mɩa mɩŋ dɩ ʋ ye bɩrɩŋ a yɩ ʋ gbaŋ, ama vuodieke dɩ yaalala dɩ ʋ yi aŋ vuodieke dɩ tʋnna wa wa ye bɩrɩŋ yiwo wusietieŋ ta wʋbɩaŋ dɩ wo ʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Daa Mosisi die yɩna nɩ mɩraha? Ama nɩ wʋnyɩ ka dɩ ha. Ta bɩa nɩ mɩa dɩ nɩ kʋʋ mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kpɩkpaakʋ die dɩ yiŋŋi balɩ dɩ, “Fʋnɩŋ yaa wa jɩmbɩaŋ fʋ ma. Mɩnɩa mɩnana ʋ kʋʋ fʋ?” ");
INSERT INTO kma_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Manɩŋ n yiwo mamachi wʋkpeŋkpɩɩŋ davʋʋsɩkɩrɩ daaŋ, dɩ yi nɩ mamachi. ");
INSERT INTO kma_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ama Mosisi die yɩna nɩ nʋaŋ dɩ nɩ gobime nɩ ballɩdembisi kɔlaha (Daa Mosisi die piiline ke, ama nɩ chɔɔŋkʋʋlɩba die piiline ke), nɩ ŋaaŋ gobi be mɩŋ davʋʋsɩkɩrɩ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Dɩɩ yi nɩ gobe Bʋadembiŋ davʋʋsɩkɩrɩ daraaŋ amʋ nɩ kaaŋ chʋʋsɩ Mosisi mɩraha, bɩa wɩa nɩ jɩa sɩnyɩɩrɩŋ aŋaŋ mɩŋ n gbaanna daa wa davʋʋsɩkɩrɩ daarɩ? ");
INSERT INTO kma_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nɩ daa daansɩ vuoŋ dɩ sɩna dene ta dii wo ʋ sarɩya, ama dii wo ʋ sarɩya aŋaŋ wudieke dɩ mʋna.” ");
INSERT INTO kma_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemi vuosi bataŋ die dɩ baarɩ dɩ, “Daa daa wa gie ba mɩa dɩ ba kʋʋ wa? ");
INSERT INTO kma_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ye, ʋ bala yeŋ me ta vuoŋ dɩ ka bala wa wɩɩŋ. Dɩ baaŋ yi dɩ nyɩŋkʋraha mɩŋŋɩya mɩŋ dɩ ʋ yiwo Ŋmɩŋ Vuovʋarɩkɩŋ, Masia wa? ");
INSERT INTO kma_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tɩ sɩba daa wa dɩ nyɩnna jigidieke; ama dɩɩ yi ta Ŋmɩŋ Vuovʋarɩkɩŋ, Masia wa dɩ keŋ keŋ, vuoŋ kaaŋ dɩ sɩba jigidieke ʋ nyɩnna.” ");
INSERT INTO kma_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Die Yisa die dɩ yene daga vuosisi Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma wa, die ʋ keŋ balɩ aŋaŋ lɔlɩkpɩɩŋ dɩ, “Nɩnɩŋ nɩ yile dɩ nɩ sɩba mɩŋ mɩŋ, ta bɩ yile dɩ nɩ sɩba jigidieke n nyɩnna? Manɩŋ n ka keŋ giena aŋaŋ n gbaŋ gbaŋ n yiko, ama vuodieke dɩ tʋnna mɩŋ wa yiwo wusie tieŋ. Nɩnɩŋ nɩ ka sɩba wa, ");
INSERT INTO kma_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ama manɩŋ n sɩba wa mɩŋ, dama n nyɩŋ wa ʋ jigiŋ, wʋnɩŋ ʋ tʋnna mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Womi die ba mɩa dɩ ba yigi wo, ama vuoŋ die ka bɩagɩ yigi wo dama ʋ yigiŋ saŋŋa die ye ka tʋgɩya. ");
INSERT INTO kma_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ama kpɩkpaakʋ sʋŋ vuosi pam die dɩ yiwo yada, ta baarɩ dɩ, “Ŋmɩŋ vuovʋarɩkɩrɩ Masia wa dɩ keŋ keŋ, ʋ nan tʋŋ mamachi wʋkpɩɩma a tɩaŋ daa wa gie dɩ tʋnna naa?” ");
INSERT INTO kma_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Die Farasisi vuosisi die dɩ wʋŋ kpɩkpaakʋ dɩ pʋʋsɩna a bala wɩaha gie yaa gamma Yisa ma wa, die wɩa die banɩŋ aŋaŋ ba kɩkaabɩtɩba nyɩŋkʋraha die dɩ tʋŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gbɩgbarɩtɩŋ bataŋ dɩ ba ga a yigi Yisa. ");
INSERT INTO kma_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yisa die dɩ baarɩ dɩ, “N nan dɩ bie nɩ jigiŋ daraa ale ama ka kʋaŋ chaaŋ n nan yiŋŋi ga vuodieke dɩ tʋnna mɩŋ wa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɩ nan dɩ dɩa a yaala mɩŋ ama nɩ kaaŋ ye mɩŋ, dama jigidieke n bala n bemme wo nɩ kaaŋ bɩagɩ a keŋ mi.” ");
INSERT INTO kma_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juu vuosi nyɩŋkʋraha die dɩ pɩasa taŋ dɩ, “Sɩa ʋ baa ʋ ga ta tɩ kaaŋ ye wo? Ʋ baa ʋ ga wa Giriiki vuosi tɩgɩ diekemba Juu vuosisi dɩ benne wo a dagɩ Giriiki vuosisi? ");
INSERT INTO kma_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ʋ baarɩ dɩ, ‘Nɩ nan dɩ dɩdɩa a yaala mɩŋ ama nɩ kaaŋ ye mɩŋ’, ta ‘Nɩ kaaŋ bɩagɩ ga jigidieke n bala n bemme wo’, wɩɩrɩ gie chɩaŋ?” ");
INSERT INTO kma_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Die dʋʋgaka dakpatɩkɩrɩ daraaŋ die yiwo daakpɩɩŋ. Dɩnɩŋ daarɩ mi Yisa die dɩ hagɩ zie a balɩ aŋaŋ lɔlɩkpɩɩŋ dɩ, “Vuodieke nɩŋ mana nyanyuule dɩ yalla, ʋ keŋ n jigiŋ a nyu. ");
INSERT INTO kma_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dama Ŋmɩŋ gbaŋkʋ baarɩ dɩ, ‘Vuodieke nɩŋ mana dɩ yine mɩŋ yada, miivoli nyaaŋ nan dɩ paala a nyɩŋ ʋ ma.’ ” ");
INSERT INTO kma_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisa die balɩ wa naa yaa gamma Ŋmɩŋ Halɩkasɩka ma, Haalɩŋ dieke vuodiekemba dɩ yine wo yada dɩ bala ba keŋ ye wo. Die saŋka mi ta Ŋmɩŋ ye ka yɩ vuosi Halɩkasɩka mi, dama saŋŋa mi ta ʋ ye ka kɔtɩ Yisa ŋmɩŋsikpeŋ. ");
INSERT INTO kma_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Die daadamba pam die dɩ wʋŋ ʋ bala die wo ta baarɩ dɩ, “Daa wa gie seŋ yiwo Ŋmɩŋ naazʋa wusie.” ");
INSERT INTO kma_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta bataŋ dɩ baarɩ dɩ, “Ʋ yiwo Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa.” Ama bataŋ dɩaŋ dɩ baarɩ dɩ, “Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa kaaŋ nyɩŋ Galili me. ");
INSERT INTO kma_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ŋmɩŋ gbaŋkʋ dagɩya dɩ Masia baa ʋ yiwo naaŋ Davidi haagɩŋ ta ba nan mɩɩrɩ wa Betilehemi ma tɩgɩ dieke die Davidi dɩ benne.” ");
INSERT INTO kma_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Naa wɩa vuosisi die dɩ puo yaa gamma Yisa ma. ");
INSERT INTO kma_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Die bataŋ dɩ yaala ba yigi wo ama vuoŋ die ka gbɩ wa. ");
INSERT INTO kma_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Die gbɩgbarɩtɩba die dɩ yiŋŋi ga kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Farasisi vuosisi jigiŋ, die ba pɩasɩ ba dɩ, “Bɩa yine nɩ ka yaa wa a keŋ?” ");
INSERT INTO kma_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gbɩgbarɩtɩba dɩ yiŋŋi balɩ ba dɩ, “Vuoŋ ye ka balɩ wɩa sɩba daa wa dɩ bala die wo.” ");
INSERT INTO kma_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farasisi vuosisi dɩ pɩasɩ ba dɩ, “Ʋ gaaŋ nɩ gbaŋ mɩŋ yaa? ");
INSERT INTO kma_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nɩ ye ye ta nyɩŋkʋraha wʋnyɩ yaa Farasisi vuoŋ yi wo yada? ");
INSERT INTO kma_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kpɩkpaakʋ gie dɩ kana ka sɩba Ŋmɩŋ mɩraha wɩa, Ŋmɩŋ nan chʋʋsɩ ba.” ");
INSERT INTO kma_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimosi die yiwo Farasisi vuosi wʋnyɩ, die ʋ yiwo vuodieke dɩ wolinne a ga Yisa jigiŋ. Die ʋ balɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tɩ mɩraha ka yi sieŋ dɩ tɩ dii vuoŋ sarɩya a baarɩ ʋ chʋʋsɩya ta ye ka wʋŋ wa ta ye wudieke ʋ yine.” ");
INSERT INTO kma_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Die ba yiŋŋi pɩasɩ wa dɩ, “Fʋ gbaŋ nyɩŋ wa Galili yaa? Karɩŋ Ŋmɩŋ gbaŋkʋ ta nan ye dɩ Ŋmɩŋ naazʋa ye ka nyɩŋ Galili tɩŋgbaŋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","((Womi vuoŋ mana die dɩ ga tigiŋ, ama Yisa die dɩ jʋalɩ ga Olivisi Tɩɩsɩ kunkogiri me. ");
INSERT INTO kma_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Die ka sʋkʋleeliŋ die ʋ yiŋŋi ga Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma. Die vuosi pam die dɩ taaŋ a giliŋ wo, die ʋ sʋʋŋ kalɩ a piili a daga ba. ");
INSERT INTO kma_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Die mɩraha dɩdagɩrɩba bataŋ aŋaŋ Farasisi vuosisi bataŋ die dɩ yaa hɔgʋ wʋnyɩ die dɩ dʋagɩna aŋaŋ dembiŋ dieke dɩ kana ka yi ʋ chʋrʋ a keŋ juu ta vaa ʋ zie ba mana nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ta die balɩ a yɩ Yisa dɩ, “Dɩdagɩrʋ, tɩ yigi wo hɔgʋ wa gie ta ʋ dʋa aŋaŋ dembiŋ dieke dɩ kana ka yi ʋ chʋrʋ. ");
INSERT INTO kma_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tɩ mɩraha sʋŋ Mosisi die baarɩ dɩ hɔgʋ wa mi chanchaaŋ mʋ ba taa wa aŋaŋ tana a kʋʋ mɩŋ, ta fʋnɩŋ, lalɩa fʋ balɩ?” ");
INSERT INTO kma_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Die ba balɩ wa naa dɩ ba ye ʋ nan balɩ wʋbɩaŋ aŋ ba galɩŋ wa. Ama Yisa die dɩ sʋʋŋ a zʋʋrɩ a nagɩ ʋ nuubiŋ a maaga wɩa tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Die ba ye a pɩasa Yisa wɩa yaa gamma hɔgʋ wa ma. Womi Yisa die dɩ hagɩ zie a baarɩ dɩ, “Vuodieke dɩ yene ka yi bɩaŋ, die vuoke woliŋ a nagɩ taŋ a taa wa.” ");
INSERT INTO kma_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ta die a bɩ sʋʋŋ zʋʋrɩ a maaga tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Die ba wʋnna balɩkʋ naa wa, die ba mana die dɩ nyɩŋ mi wʋnyɩ wʋnyɩ, nyɩŋkʋraha die wolinne nyɩŋ, ta die va Yisa ta hɔgʋ wa die dɩ ye zie mi. ");
INSERT INTO kma_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yisa die dɩ hagɩ zie a pɩasɩ hɔgʋ wa dɩ, “Ba bie sɩa? Vuoŋ ka tɩalɩya dɩ ʋ balɩ a chʋʋsɩ fʋ?” ");
INSERT INTO kma_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ʋ yiŋŋi baarɩ dɩ, “Jakʋʋŋ, vuoŋ ka tɩalɩya.” Ta Yisa die dɩ baarɩ dɩ, “N gbaŋ n kaaŋ balɩ a chʋʋsɩ fʋ, gamma ama da bɩ yi bɩaŋ bɩbra.”)) ");
INSERT INTO kma_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yisa die dɩ balɩ a yi vuosisi bɩbra dɩ, “Manɩŋ n yiwo tɩŋgbaŋka gie vuosi chaanɩŋ, ta vuodieke mana dɩ dɩna n kʋaŋ nan dɩ yaa chaaŋ dieke dɩ chaana ʋ beriŋ, ta ʋ kaaŋ dɩ dɩa mɩa lɩmɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ta Farasisi vuosisi die dɩ balɩ a yɩ wa dɩ, “Fʋ nyɩɩna ma fʋ balala yaa gamma fʋ ma, ta wudieke fʋ balala wa dɩ yi yɔrɩ.” ");
INSERT INTO kma_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Dɩɩ yi maŋ bala yaa gamma n ma, ama wudieke n bala wa yiwo wusie, dama n sɩba jigidieke n nyɩnna keŋ mɩŋ ta bɩ sɩba jigidieke n ganana. Ama nɩnɩŋ nɩ ka sɩba jigidieke n nyɩnna aŋaŋ jigidieke n ganana. ");
INSERT INTO kma_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nɩnɩŋ nɩ die vuoŋ sarɩya yaa gamma vuota chʋara dɩ sɩna dene, ama manɩŋ n ka die vuoŋ sarɩya. ");
INSERT INTO kma_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dɩɩ yi maŋ keŋ baa n dii vuoŋ sarɩya, n nan dii ʋ sarɩya aŋaŋ wusie, dama n ka die sarɩya n nyɩɩna ma ama n Chʋa vuodieke dɩ tʋnna mɩŋ wa bie n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dɩ maagɩya nɩ mɩra sʋŋ dɩ dɩɩ yi vuosi bale dɩ dii siara ta balɩ wʋbalɩmɩŋ wudieke ba bala wa yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Manɩŋ n bala yaa gamma n ma, ta n Chʋa vuodieke dɩ tʋnna mɩŋ dɩaŋ dɩ bala yaa gamma n ma.” ");
INSERT INTO kma_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Die ba pɩasɩ wa dɩ, “Fʋ Chʋa wa bie sɩa?” Ta Yisa die dɩ yiŋŋi balɩ ba dɩ, “Nɩ seŋ ka sɩba mɩŋ yaa n Chʋa wa. Dɩɩ yi nɩ tɩŋ sɩba mɩŋ nɩ tɩŋ nan dɩ sɩba ʋ Chʋa gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisa die balɩ wa wɩaha gie mana saŋŋa dieke ʋ dagɩnana vuosisi Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma jigidieke Ŋmɩŋ piini adaka dɩ benne wo; ama vuoŋ die ka yigi wo, dama ʋ yigiŋ saŋŋa die ye ka tʋgɩya. ");
INSERT INTO kma_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yisa die dɩ bɩ a balɩ ba dɩ, “Manɩŋ n nan ga, ta nɩ nan dɩ dɩa a yaala mɩŋ ama nɩ kaaŋ ye mɩŋ, ta nan keŋ kpi aŋaŋ nɩ wʋbɩatɩ. Nɩ kaaŋ bɩagɩ ga jigidieke n ganana.” ");
INSERT INTO kma_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Die wɩa Juu vuosi nyɩŋkʋraha die dɩ pɩasa taŋ dɩ, “Ʋ baarɩ dɩ, ‘Nɩ kaaŋ bɩagɩ a ga jigidieke n ganana wa.’ Ʋ yaala ʋ kʋʋ wa ʋ gbaŋ yaa?” ");
INSERT INTO kma_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yisa die dɩ bɩ bala gʋtɩ dɩ, “Nɩnɩŋ nɩ yiwo tɩŋgbaŋka gie sɩɩtɩ, ama manɩŋ n yiwo arɩzanna sɩɩtɩ. Nɩnɩŋ nɩ nyɩŋ wa tɩŋgbaŋka gie me, ama manɩŋ n ka nyɩŋ tɩŋgbaŋka gie me. ");
INSERT INTO kma_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Die wɩa maŋ balɩ nɩ dɩ nɩ nan kpi aŋaŋ nɩ tʋntʋmbɩatɩ. Ta dɩɩ yi nɩ ka yi mɩŋ yada dɩ n yiwo vuodieke n yine wo nɩ seŋ kpi aŋaŋ nɩ tʋntʋmbɩatɩ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Die ba pɩasɩ wa dɩ, “Manɩa yine fʋ?” Yisa die dɩ yiŋŋi balɩ ba dɩ, “N yiwo vuodieke n balala nɩ a nyɩŋ piiliku me dɩ n yiye wo. ");
INSERT INTO kma_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wɩa pam benne maŋ tɩŋ nan balɩ a chʋʋsɩ nɩ; ama vuodieke dɩ tʋnna mɩŋ wa yiwo wusietieŋ ta manɩŋ n bala dʋnɩa ka gie vuosi wudieke n wʋnna a nyɩna ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ama vuosisi die ka sɩba dɩ ʋ bala ba yaa gamma ʋ Chɔɔŋ Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Die wɩa Yisa die dɩ balɩ ba dɩ, “Saŋŋa dieke nɩ keŋ kɔtɩ manɩŋ Vuota Bʋa ŋmɩŋsikpeŋ, saŋka mi nɩ nan mɩŋŋɩ dɩ n yiwo vuodieke n yine, ta sɩba dɩ n ka yie wɩɩŋ aŋaŋ n gbaŋ gbaŋ n yiko, ama n bala wudieke n Chʋa dɩ dagɩna mɩŋ dɩ n balɩ wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wʋnɩŋ vuodieke dɩ tʋnna mɩŋ wa bie n jigiŋ. Ʋ ka va mɩŋ dama n yie wudieke dɩ nannana ʋ sʋŋ saŋŋa mana mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Vuosi pam die dɩ wʋŋ ʋ balala wɩaha gie wo, ta yi wo yada. ");
INSERT INTO kma_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Die Yisa die dɩ balɩ yi Juu vuodiekemba dɩ yine wo yada dɩ, “Dɩɩ yi nɩ dɩ n dagɩkʋ, nɩ seŋ yiwo n kʋaŋandɩɩsɩrɩŋ; ");
INSERT INTO kma_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ta nɩ nan dɩ sɩba wusieke ta wusieke nan gbatɩ nɩ taaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Die ba yiŋŋi balɩ wa dɩ, “Tɩnɩŋ tɩ yiwo Abarahami haagɩsɩ ta ye ka yi vuoŋ yɔŋɩsɩ. Lalɩa fʋ bala dɩ, ‘Tɩ nan ye gbatɩtaanɩŋ?’ ” ");
INSERT INTO kma_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yisa die dɩ balɩ a yɩ ba dɩ, “Wusie maŋ bala nɩ, vuodieke nɩŋ mana dɩ yinene bɩaŋ yiwo bɩaŋ yɔmʋ. ");
INSERT INTO kma_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yɔmʋ nɩŋ ka gʋtɩ ʋ tieŋ deŋ me, ama tigiŋ bʋa nɩŋ gʋtɩ wa deŋ me yaa gamma haahuu. ");
INSERT INTO kma_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dɩɩ yi manɩŋ Ŋmɩŋ Bʋa wa dɩ gbatɩ nɩ a taaŋ, nɩ nan seŋ ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N sɩba dɩ nɩ yiwo Abarahami haagɩsɩ, ama nɩ mɩa dɩ nɩ kʋʋ mɩŋ mɩŋ, dama nɩ ka yaala nɩ tuo n dagɩkʋ. ");
INSERT INTO kma_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Manɩŋ n bala wudieke n Chʋa dɩ dagɩna mɩŋ mɩŋ, ama nɩnɩŋ nɩ yie wudieke nɩ chɔɔŋ dɩ bala nɩ.” ");
INSERT INTO kma_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba yiŋŋi balɩ wa dɩ, “Tɩ chɔɔŋ yiwo Abarahami.” Ta Yisa die dɩ yiŋŋi balɩ ba dɩ, “Dɩɩ yi nɩ seŋ yi Abarahami ballɩ nɩ nan dɩ yie wudiekemba die ʋ yine wo mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ama nɩ yaala nɩ kʋʋ mɩŋ mɩŋ n balala nɩ wusie dieke Ŋmɩŋ dɩ nagɩna a yɩ mɩŋ wa mɩŋ. Abarahami nɩŋ die ka yi wɩɩŋ sɩba naa. ");
INSERT INTO kma_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nɩ yie wudieke gbaŋ gbaŋ nɩ chɔɔŋ dɩ yinene wo.” Die ba yiŋŋi balɩ wa dɩ, “Ŋmɩŋ gbaŋ gbaŋ yine tɩ chɔɔŋ dieke nyɩɩna ma tɩ yalla, ta tɩ yi ʋ ballɩ wusie.” ");
INSERT INTO kma_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yisa die dɩ balɩ a yɩ ba dɩ, “Ŋmɩŋ dɩ tɩŋ seŋ yi nɩ chɔɔŋ nɩ nan dɩ cho mɩŋ, dama n nyɩŋ wa Ŋmɩŋ jigiŋ ta wa bie gie lele wo gie. N ka keŋye aŋaŋ n gbaŋ gbaŋ hagɩrɩŋ ama wʋnɩŋ ʋ tʋnna mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bɩa wɩa nɩ ka sɩba wudieke n balala wa chɩaŋ? Dɩ yiwo nɩ kana ka bɩagɩ wʋmma wudieke n balala wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nɩnɩŋ nɩ yiwo nɩ chɔɔŋ, Sitaani ballɩ ta yaala nɩ yime nɩ chɔɔŋ wa choti. Piiliku me wo die ʋ yiwo vuokʋʋrʋ, ta bɩ wo wusie, dama wusie wo ʋ ma halɩ bɩta gbaŋ. Ʋ keŋ chɩba ŋmɩnchɩbɩsɩ ka ŋaaŋ yiwo ʋ tʋntʋŋkʋra, dama ʋ yiwo ŋmɩnchɩbɩtieŋ, ta ŋmɩnchɩbɩsɩ mana nyɩŋ wa ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","N balala nɩ wusieke wɩa, die wɩa nɩ ka yi n balɩkʋ yada wa. ");
INSERT INTO kma_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nɩ jabɩa baaŋ bɩagɩ dagɩ n wʋbɩaŋ? Dɩɩ yi maŋ bala wusie, bɩa wɩa nɩ ka yi mɩŋ yada? ");
INSERT INTO kma_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Vuodieke dɩ nyɩnna Ŋmɩŋ jigiŋ wʋmma Ŋmɩŋ wʋbalɩka mɩŋ; ama nɩnɩŋ nɩŋ nɩ ka nyɩŋ Ŋmɩŋ jigiŋ, die wɩa nɩ zeti dɩ nɩ wʋŋ wa.” ");
INSERT INTO kma_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Die Juu vuosi die dɩ yiŋŋi balɩ Yisa dɩ, “Tɩ ka yaa wusie tɩ bala dɩ yiwo Samaria vuoŋ ta jɩmbɩaŋ dɩ yallɩ fʋ wa?” ");
INSERT INTO kma_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Jɩmbɩaŋ ka yallɩ mɩŋ. Manɩŋ n yɩ wa n Chʋa Ŋmɩŋ jɩlɩma ta nɩnɩŋ nɩ daansa mɩŋ yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Manɩŋ n ka yaala bɩrɩŋ a yɩa n gbaŋ. Ama Ŋmɩŋ yaalala ka yɩa mɩŋ, ta ʋ bɩ yi wusie sarɩyadiiru. ");
INSERT INTO kma_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wusie maŋ bala nɩ, vuodieke mana dɩ dɩna n wɩaha kaaŋ wɔŋ kpi.” ");
INSERT INTO kma_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ta Juu vuosisi die dɩ balɩ a yɩ wa dɩ, “Lele tɩ wa sɩba a baarɩ dɩ jɩmbɩaŋ yalla fʋ. Abarahami die kpiye mɩŋ, ta Ŋmɩŋ naazʋalɩba dɩaŋ die dɩ kpi, ama baarɩ dɩ, ‘Vuodieke nɩŋ mana dɩ dɩna n wɩaha kaaŋ wɔŋ kpi.’ ");
INSERT INTO kma_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tɩ chɔɔŋ Abarahami die kpiye mɩŋ, tɩ yaa tama dɩ ka yile dɩ tɩaŋ Abarahami mɩŋ? Ŋmɩŋ naazʋalɩba gbaŋ die kpiye mɩŋ. Mɩnɩa fʋ yile dɩ yiye?” ");
INSERT INTO kma_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Maŋ tɩŋ bɩra n gbaŋ, n bɩrɩkʋ nan yi yɔrɩ. Ama vuodieke dɩ bɩrɩnana mɩŋ yiwo n Chʋa, vuodieke gbaŋ gbaŋ nɩ bala dɩ ʋ yiwo nɩ Ŋmɩnnɩ. ");
INSERT INTO kma_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nɩnɩŋ nɩ ye ka sɩba wa, ama manɩŋ n sɩba wa mɩŋ. Dɩɩ yi maŋ baarɩ dɩ n ka sɩba wa, n nan bɩrɩŋ ŋmɩnchɩbɩtieŋ sɩba nɩnɩŋ. Ama n sɩba wa mɩŋ ta dɩ ʋ wɩaha. ");
INSERT INTO kma_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nɩ chɔɔŋ Abarahami die yaa sʋgɩfɩalɩŋ pam, ʋ bala ʋ ye saŋŋa dieke n bala n keŋ tɩŋgbaŋka gie me wo; die ʋ seŋ ye ke mɩŋ, ta ʋ sʋŋ die dɩ fɩalɩ.” ");
INSERT INTO kma_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Juu vuosisi die dɩ balɩ a yɩ wa dɩ, “Ye ka tʋgɩ bɩna baŋɩsɩ-nʋ, lalɩa fʋ yi ye Abarahami?” ");
INSERT INTO kma_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Wusie maŋ bala nɩ, ba kenne mɩra Abarahami wa, ta n wɔŋ beri mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Die wɩa, ba nagɩ tana dɩ ba taa wa, ama Yisa die lɔbɩrɩ ʋ gbaŋ ta nyɩŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisa die dɩ chʋnnana a gara wa die ʋ ye daa wʋnyɩ ba mɩrɩna wa ta ʋ yi yɩɩ. ");
INSERT INTO kma_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasɩ wa dɩ, “Dɩdagɩrʋ, mɩnɩa tʋntʋmbɩatɩ wɩa ba mɩɩrɩ daa wa ta ʋ yi yɩɩ? Wʋnɩŋ yaa ʋ chɔɔŋ aŋaŋ ʋ nuŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Daa wʋnɩŋ yaa ʋ chɔɔŋ aŋaŋ ʋ nuŋ bɩaŋ taasɩna ʋ yɩɩsɩsɩ. Ʋ yɩɩŋya mɩŋ dɩ n vaa ʋ nine yuori amʋ vuosi ye Ŋmɩŋ tʋnkpɩɩma. ");
INSERT INTO kma_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yuŋ dɩ yene ka sibiye naa, tɩ mʋ tɩ tʋmma vuodieke dɩ tʋnna mɩŋ wa tʋʋma; dama yuŋ dɩ keŋ sibi vuoŋ kaaŋ bɩagɩ a tʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","N yene bie tɩŋgbaŋka gie me nɩŋ, n yine ka vuosi chaanɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yisa dɩ bala naa kʋaŋ chaaŋ, die ʋ tɩɩrɩ nɩntɔbɩtɩ a yi tantɩ ma, a bʋʋlɩbʋ a nagɩ tɩrɩgɩ daa wa nine, ");
INSERT INTO kma_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ta balɩ a yɩ wa dɩ, “Gamma a ga nɩtɩ fʋ nine Siloami gbagɩrɩ ma.” (Siloami chɩaŋ yine “Tʋŋya”.) Die wɩa daa wa die dɩ ga, a ga nɩtɩ ʋ nine ta yese, ta viiri kuli tigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Die ʋ jʋjʋrʋtaŋ aŋaŋ vuodiekemba die dɩ wone a ye wo ta ʋ jʋʋsa wa die dɩ pɩasa taŋ dɩ, “Daa daa wa gie ŋaana a kala gie a jʋʋsa wa?” ");
INSERT INTO kma_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bataŋ die dɩ baarɩ dɩ, “Ʋ wondene” Ama bataŋ dɩ baarɩ dɩ, “Aayɩ daa ʋ wondie, ʋ ta nɩasɩ wa mɩŋ.” Die daa wa gbaŋ gbaŋ dɩ baarɩ dɩ, “Manɩŋ n yine daa wa mi.” ");
INSERT INTO kma_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Die ba pɩasɩ wa dɩ, “Lalɩa fʋ yi ta fʋ ninehe dɩ yuori?” ");
INSERT INTO kma_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ʋ yiŋŋi a balɩ ba dɩ, “Daa dieke saaŋ dɩ dine Yisa wa bʋʋlɩna tantɩ a nagɩ a tɩrɩgɩ n ninehe, ta balɩ dɩ, ‘Gamma Siloami gbagɩrɩ ma a nɩtɩ fʋ nine.’ Die wɩa die maŋ ga, n dene nɩtɩ a kpatɩ wa maŋ bɩagɩ a yese.” ");
INSERT INTO kma_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Die ba pɩasɩ wa dɩ, “Sɩa ʋ beri?” Ʋ yiŋŋi a balɩ ba dɩ, “N ka sɩba.” ");
INSERT INTO kma_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Die wɩa die ba nagɩ daa wa ga Farasisi vuosisi jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Daa dieke die Yisa die dɩ bʋʋlɩ tantɩ a yuori daa wa ninehe die yiwo davʋʋsɩkɩrɩ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ta Farasisi vuosisi die dɩ bɩ pɩasɩ daa wa ʋ ninehe dɩ yuorine dene. Ʋ balɩ ba dɩ, “Ʋ bʋʋlɩ wa tantɩ a tɩrɩgɩ n nine, maŋ nɩtɩ ha ta yese.” ");
INSERT INTO kma_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farasisi vuosisi bataŋ dɩ baarɩ dɩ, “Yisa wa ka nyɩŋ Ŋmɩŋ jigiŋ, dama ʋ ka dɩɩ davʋʋsɩkɩrɩ daarɩ mɩraha.” Ama ba bataŋ dɩ baarɩ dɩ, “Lalɩa tʋntʋmbɩatɩ tieŋ dɩ baaŋ bɩagɩ tʋŋ mamachi wʋkpɩɩka gie?” Die wɩa die ba nɩga nɩnhagɩrɩŋ aŋaŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Die ba bɩ pɩasɩ daa wa dɩ, “Daa dieke dɩ yuorine fʋ ninehe, bɩa fʋ yile yaa gamma ʋ ma?” Daa wa dɩ yiŋŋi balɩ dɩ, “Ʋ yiwo Ŋmɩŋ naazʋa.” ");
INSERT INTO kma_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Die Juu vuosi nyɩŋkʋraha die ye ka yi yada dɩ die ʋ yiwo yɩɩ ama ta wa yese lele. Die wɩa die ba wa daa wa chɔɔŋ wa aŋaŋ ʋ nuŋ a keŋ, ");
INSERT INTO kma_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","a pɩasɩ ba dɩ, “Nɩ bʋa wa wʋnna? Wʋnɩŋ nɩ baarɩ dɩ nɩ mɩɩrɩ wa ta ʋ yɩɩŋya wa? Ta lalɩa ʋ bɩagɩ yese lele?” ");
INSERT INTO kma_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ʋ chɔɔŋ aŋaŋ ʋ nuŋ dɩ yiŋŋi balɩ dɩ, “Tɩ sɩba a baarɩ dɩ ʋ yiwo tɩ bʋa, ta sɩba dɩ tɩ mɩɩrɩ wa ta ʋ yɩɩŋya mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama tɩ ka sɩba wudieke dɩ yine ʋ bɩagɩ yese lele, ta ka bɩ sɩba vuodieke dɩ yuorine ʋ ninehe. Nɩ pɩasɩ wa dama ʋ ka yi bʋabiŋ, ʋ nan bɩagɩ balɩ yɩ ʋ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Die ʋ chɔɔŋ aŋaŋ ʋ nuŋ wo die balɩ wa naa, dama die ba chɩga Juu vuosi nyɩŋkʋraha ŋmaamɩŋ, dama die ba wɔŋ saŋ mɩŋ dɩ vuodieke nɩŋ mana dɩ balala dɩ Yisa yine Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa, ba nan vʋarɩ wa a nyɩŋ ba Ŋmɩŋ jɩamɩŋ juoku me. ");
INSERT INTO kma_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Die wɩa ba balɩ dɩ, “Ʋ ka yi bʋabiŋ, nɩ pɩasɩ wa.” ");
INSERT INTO kma_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Die ba wa daa dieke nine dɩ yuorine wo ka bule me a balɩ wa dɩ, “Hʋʋ Ŋmɩŋ nɩŋŋa dɩ baa fʋ balɩ wa wusie. Tɩ sɩba a baarɩ Yisa yiwo tʋntʋmbɩatɩ tieŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Daa wa die dɩ yiŋŋi a balɩ ba dɩ, “Manɩŋ n ka sɩba dɩ ʋ yiwo tʋntʋmbɩatɩ tieŋ yaa ʋ ka yiye. Ama wʋbalɩŋ dieke n sɩbɩna yine die n yiwo yɩɩ, ama lele n yese mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba bɩ pɩasɩ wa dɩ, “Lalɩa ʋ yi ta yuori fʋ ninehe?” ");
INSERT INTO kma_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ʋ yiŋŋi balɩ ba dɩ, “N wɔŋ balɩ nɩ mɩŋ ta nɩ ka wʋmma. Bɩa nɩ yaala n bɩ balɩ nɩ bɩbra? Nɩ gbaŋ nɩ yaala nɩ bɩrɩŋ wa ʋ kʋaŋandɩɩsɩrɩŋ yaa?” ");
INSERT INTO kma_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Die ba wa zɩa wa ta baarɩ dɩ, “Fʋnɩŋ yiwo vuoke me kʋaŋandɩɩsɩrʋ, ama tɩnɩŋ tɩ yiwo Mosisi kʋaŋandɩɩsɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tɩnɩŋ tɩ sɩba a baarɩ dɩ Ŋmɩŋ die balɩ wa wɩa a yɩ Mosisi, ama vuoke gie nɩŋ ta ka wɔŋ sɩba jigidieke ʋ nyɩnna.” ");
INSERT INTO kma_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Daa wa dɩ yiŋŋi balɩ dɩ, “Bɩa mamachi wɩɩŋ wʋnna! Nɩ ka sɩba ʋ nyɩnna jigidieke, ama wʋnɩŋ ʋ yuorine n ninehe mɩŋ! ");
INSERT INTO kma_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tɩ sɩba a baarɩ Ŋmɩŋ ka wʋmma tʋntʋmbɩatɩ tieliŋ jʋʋsɩŋ; ama ʋ wʋmma yɩa vuodieke dɩ jɩanna wa ta yie wudiekemba ʋ yaalɩnana mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A nyɩŋ dʋnɩa piiliku me, tɩ ye ka wʋŋ dɩ vuoŋ yuori vuodieke ba mɩɩrɩna wa ta ʋ yi yɩɩ nine. ");
INSERT INTO kma_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dɩɩ yi daa wa gie dɩ ka nyɩŋ Ŋmɩŋ jigiŋ, ʋ tɩŋ kaaŋ bɩagɩ a yi wɩɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Die ba yiŋŋi balɩ wa dɩ, “Fʋnɩŋ ba mɩɩrɩ fʋ mɩŋ aŋaŋ bɩaŋ, mɩnɩa yine fʋ, fʋ yaala fʋ dagɩ tɩ?” Ta die yagɩ wa a nyɩŋ Ŋmɩŋ jɩamɩŋ juoku me. ");
INSERT INTO kma_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yisa die dɩ wʋŋ dɩ ba yagɩ wa daa wa a nyɩŋ Ŋmɩŋ jɩamɩŋ juoku me, die ʋ yaalɩ ʋ jigiŋ a ye wo, a pɩasɩ wa dɩ, “Yi Vuota Bʋa yada mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Daa wa die dɩ yiŋŋi a pɩasɩ wa dɩ, “Jakʋʋŋ, mɩnɩa yine Vuota Bʋa wa? Dagɩ mɩŋ amʋ n nan yi wo yada.” ");
INSERT INTO kma_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yisa die dɩ yiŋŋi balɩ wa dɩ, “Fʋnɩŋ wɔŋ ye wo mɩŋ, ta ʋ yine vuodieke dɩ balala wɩa aŋaŋ fʋ leleke giena.” ");
INSERT INTO kma_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Daa wa dɩ baarɩ dɩ, “N Yɔmʋtieŋ n yi fʋ yada mɩŋ.” Ta die sʋʋŋ gbirigi Yisa nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yisa die dɩ baarɩ dɩ, “Manɩŋ n keŋ wo tɩŋgbaŋka gie me dɩ n dii vuota sarɩya, amʋ vuodiekemba dɩ yɩɩŋna wa nan dɩ yese ta vuodiekemba dɩaŋ dɩ yesinene wo nan yɩɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Die Farasisi vuosi bataŋ die dɩ benne mi wo ta wʋŋ wudieke ʋ bala wa die dɩ pɩasɩ wa dɩ, “Tɩ gbaŋ tɩ yɩɩŋya mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yisa die dɩ baarɩ dɩ, “Dɩɩ yi nɩ tɩŋ wo ninyuoriŋ, nɩ tɩŋ kaaŋ dɩ yaa bɩaŋ, ama nɩ bala dɩ nɩ yaa ninyuoriku nɩŋ, nɩ yaa bɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisa die dɩ bɩ balɩ ba dɩ, “Wusie maŋ bala nɩ, vuodieke nɩŋ dɩ kana ka daagɩ yiise juoku sanʋarɩ a juu ama ta daagɩ paŋ a juu yiwo gaarʋ aŋaŋ gbɩgbatɩrʋ. ");
INSERT INTO kma_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ama vuodieke dɩ daagɩnana sanʋarɩ a juo wo yiwo yiisehe yiyagɩrʋ. ");
INSERT INTO kma_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sanʋagbarɩtʋ wa ŋaaŋ yuori wo sanʋarɩ a yɩ wa aŋ ʋ juu, ta ʋ wa ʋ gbaŋ gbaŋ ʋ yiisehe saara ba ŋaaŋ wʋmma ʋ lɔlɩŋ ta ʋ yaa ba nyɩna. ");
INSERT INTO kma_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ʋ keŋ yaa ha a keŋ nyɩŋ, ʋ ŋaaŋ dɩ wa a nɩŋŋa ta yiisehe dɩ dɩ ʋ kʋaŋ, dama a sɩba ʋ lɔlɩŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ama a kaaŋ wɔŋ a dɩ chaanʋ kʋaŋ, a nan chɩgɩ ta va wa, dama a ka sɩba ʋ lɔlɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisa die taaŋ ba nandagɩrɩ gie ama die ba ka sɩba wudieke ʋ balala ba wa chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Die wɩa Yisa dɩ bɩ bala ba dɩ, “Wusie maŋ bala nɩ, manɩŋ n yine yiisehe juoku sanʋaŋ. ");
INSERT INTO kma_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vuodiekemba mana die dɩ wolinne a keŋ n ma wa yiwo gaarɩŋ aŋaŋ gbɩgbatɩrɩŋ, ta yiisehe dɩ ka wʋŋ a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Manɩŋ n yine sanʋarɩ, vuodieke nɩŋ mana dɩ daagɩna n ma a juu nan ye gbatɩtaanɩŋ. Ʋ nan keŋ juu ta nyɩna, ta yese nyindiike vɩɩna. ");
INSERT INTO kma_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gaarʋ nɩŋ keŋye dɩ ʋ keŋ gaarɩ yiisehe, ta kʋʋ ha, ta bɩ chʋʋsɩ ha. Manɩŋ, n keŋye mɩŋ dɩ a ye miivoli dieke dɩ yine miivoli wusie ke. ");
INSERT INTO kma_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Manɩŋ n yiwo yiyagɩrɩvɩɩnʋ, ta yiyagɩrɩvɩɩnʋ kpinene ʋ yiise wɩa. ");
INSERT INTO kma_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ama vuodieke nɩŋ dɩ yagɩnana yiise ligire wɩa, ta ka yi yiyagɩrʋ wusie, ta ka bɩ sɩɩ yiisehe nɩŋ, dɩɩ yi ʋ keŋ ye gbaanchʋŋ dɩ kieŋ saŋŋa dieke, sie ʋ chɩgɩ ta vaa yiisehe; ta gbaanchʋrɩ keŋ yigi he ta yiise tɩalɩkaha chɩgɩ jaasɩ. ");
INSERT INTO kma_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ʋ ŋaaŋ chɩga dama ʋ yaga yiisehe ligire wɩa, ta ʋ baga wo yiisehe me. ");
INSERT INTO kma_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Manɩŋ n yiwo yiyagɩrɩvɩɩnʋ; Sɩba n Chʋa Ŋmɩŋ dɩ sɩbɩna mɩŋ, ta n gbaŋ maŋ sɩba wa die wo, die gbaŋ gbaŋ dɩ sɩɩ, n sɩba n yiise, ta yiisehe dɩaŋ dɩ sɩba mɩŋ, ta maŋ yi siri dɩ n kpi a wɩa. ");
INSERT INTO kma_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N yaa yiise ataŋ, ama hanɩŋ a wo yiise juoku gie me. Sie n yaa a dɩaŋ a keŋ, ta a nan tuo n nʋaŋ, ta a mana bɩrɩŋ yiise buuri balɩmɩŋ, ta yaa yiyagɩbalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“N Chʋa Ŋmɩŋ cho mɩŋ mɩŋ dama n yi siri dɩ n kpi, ta ka kʋaŋ chaaŋ n bɩ ye miivoli. ");
INSERT INTO kma_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Vuoŋ wori a nan bɩagɩ vʋarɩ n miivoli, ntaala n yɩ wa sieŋ. N yaa yiko a nan bɩagɩ nagɩ yi, ta bɩ yaa yiko a nan bɩagɩ keŋ n mɩsɩ ma. Naa n Chʋa die dɩ balɩ mɩŋ dɩ n yi.” ");
INSERT INTO kma_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Die ʋ wʋbalɩkaha gie die dɩ yi Juu vuosisi dɩ bɩ puo bɩbra. ");
INSERT INTO kma_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba pam die dɩ baarɩ dɩ, “Jɩmbɩaŋ yalla wa ta ʋ juo yɩɩŋyaatɩ. Bɩa wɩa nɩ wʋmma wa?” ");
INSERT INTO kma_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama bataŋ die dɩ baarɩ dɩ, “Vuodieke jɩmbɩaŋ dɩ yalla kaaŋ bɩagɩ balɩ wɩa sɩba naa. Lalɩa vuodieke jɩmbɩaŋ dɩ yalla dɩ nan bɩagɩ a yuori yɩɩsɩ nine?” ");
INSERT INTO kma_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Die saŋŋa dɩ tʋgɩ dɩ ba dii ba dʋʋga dieke ba ŋaana bɩra Ŋmɩŋ ba jɩamɩŋ juokpeŋkpɩɩkʋ wɩa wa. Dʋʋga ka die dii wo Jerusalemi ma. Saŋka mi die yiwo tafaaŋ ");
INSERT INTO kma_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ta Yisa die dɩ dɩ dɩa lɩɩfaaŋ dieke ba wasɩnana Solomoni lɩɩfaaka, dɩ benne Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma wa. ");
INSERT INTO kma_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Vuosisi die dɩ taaŋ a giliŋ wo ta pɩasɩ wa dɩ, “Fʋnɩŋ yaala tɩ chɩɩsɩ mɩŋ a ga tʋgɩ wa saŋŋa bɩa? Balɩ tɩ wusie: Fʋ yine Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa?” ");
INSERT INTO kma_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “N wɔŋ balɩ nɩ mɩŋ, ama nɩ ka yi mɩŋ yada. Tʋŋ diekemba n tʋnnana wa aŋaŋ n Chʋa Ŋmɩŋ yikoke, dagɩnana vuodieke n yine. ");
INSERT INTO kma_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama nɩ ka yi yada dama nɩ ka yi n yiise. ");
INSERT INTO kma_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","N yiisehe wʋmma n lɔlɩŋ; ta maŋ sɩba ha ta a dɩ n kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Manɩŋ n yɩa ha miivoli dieke dɩ wone kpatɩŋ, ta a kaaŋ wɔŋ kpi; ta vuoŋ dɩ kaaŋ bɩagɩ a gbatɩ ha a nyɩŋ n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","N Chʋa Ŋmɩŋ nagɩna ha a yi n nuusi me, ta wʋnɩŋ ʋ tɩaŋ vuoŋ mana mɩŋ. Die wɩa vuoŋ wori a baaŋ bɩagɩ a gbatɩ ha a nyɩŋ n Chʋa wa nuusi me ");
INSERT INTO kma_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Manɩŋ aŋaŋ n Chʋa Ŋmɩŋ yiwo jabalɩmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Womi Juu vuosisi die dɩ bɩ nagɩ tana dɩ ba taa wa, ");
INSERT INTO kma_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ama Yisa die dɩ balɩ ba dɩ, “Manɩŋ n yi wo wʋvɩɩna dieke n Chʋa Ŋmɩŋ dɩ nagɩna a yɩ mɩŋ dɩ n yi pam nɩ jigiŋ, a jabɩa wɩa nɩ yaala nɩ taa mɩŋ tana?” ");
INSERT INTO kma_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta ba yiŋŋi a balɩ wa dɩ, “Tɩ ka baa tɩ taa fʋ tana aŋaŋ fʋ yinene wʋvɩɩnaha wɩa, ama fʋ nagɩna fʋ gbaŋ a magɩsa Ŋmɩŋ wɩa. Fʋnɩŋ ko yiwo vuota, ama ta mɩa dɩ fʋ nagɩ fʋ gbaŋ a bɩrɩŋ Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Dɩ maagɩya nɩ gbaŋ gbaŋ nɩ mɩra dieke dɩ benne Ŋmɩŋ gbaŋkʋ sʋŋ wa dɩ, wʋnɩŋ Ŋmɩŋ die baarɩ dɩ, ‘Sarɩya diiribe yiwo n ballɩ’, ");
INSERT INTO kma_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ta tɩ sɩba a baarɩ wudieke Ŋmɩŋ gbaŋkʋ dɩ bala wa yiwo wusie yaa gamma haahuu; ta wʋnɩŋ Ŋmɩŋ dɩ wasa vuodiekemba ʋ nagɩna ʋ wɩaha a yɩ wa ʋ ballɩ. ");
INSERT INTO kma_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Manɩŋ nɩŋ, n Chʋa Ŋmɩŋ vʋarɩna mɩŋ a tʋŋ mɩŋ tɩŋgbaŋka gie me. Ta lalɩa nɩ nan bɩagɩ a baarɩ dɩ n zɩa Ŋmɩŋ aŋaŋ n balala dɩ n yiwo Ŋmɩŋ Bʋa wa? ");
INSERT INTO kma_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Die nɩŋ nɩ da yi mɩŋ yada dɩɩ yi maŋ ka tʋma n Chʋa Ŋmɩŋ tʋʋmaha. ");
INSERT INTO kma_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama dɩɩ yi maŋ tʋʋmaha ta nɩ ka yi mɩŋ yada, nɩ tɩŋ mʋ nɩ yiwo n tʋʋmaha yada amʋ nɩ nan dɩ sɩba dɩ n Chʋa Ŋmɩŋ bie n ma ta n dɩaŋ maŋ bie ʋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Die ba bɩ mɩa dɩ ba yigi wo, ama die ʋ bɩa ta vaa ba, ");
INSERT INTO kma_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ta die bɩ garɩsɩ Jɔɔdani mʋgɩrɩ a ga jigidieke Jɔɔn die dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ ta die bie mi. ");
INSERT INTO kma_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vuosi pam die dɩ keŋ ʋ jigiŋ a bala yɩa tamba dɩ, “Jɔɔn die ka yi mamachi wʋkpɩɩma ama wudieke mana ʋ bala yaa gamma daa wa gie ma die yi wusie.” ");
INSERT INTO kma_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Die mi vuosi pam die dɩ yi wo yada. ");
INSERT INTO kma_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Die daa wʋnyɩ saaŋ die dine Lazurusi ta ʋ bie Betani ma, ta die dɩ keŋ yʋagɩ. Betani die yiwo tɩŋ dieke Meri aŋaŋ ʋ nɩmbʋa Maata dɩ benne. ");
INSERT INTO kma_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri wa gie die yine vuodieke die dɩ sitine tulaarika a yi tɩ Yɔmʋtieŋ nagɩsɩ ma wa ta chɩtɩbʋ aŋaŋ ʋ sikpeŋ zoosisi; die dɩ yiwo ʋ nɩmbʋa Lazurusi die dɩ yʋagɩna wa. ");
INSERT INTO kma_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Die ʋ tamba Meri aŋaŋ Maata die dɩ tʋŋ balɩ Yisa dɩ, “Tɩ Yɔmʋtieŋ, fʋ zʋa dieke fʋ faasɩna a cho wo yʋagɩ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yisa die dɩ wʋnna naa wa, ʋ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Yʋagɩbʋ gie ka baa ka yi Lazurusi miivoli kpatɩŋ, ama dɩ yiwo wudieke vuosi dɩ nan bɩrɩ Ŋmɩŋ saaŋ ka wɩa, ta bɩ bɩrɩ manɩŋ Ŋmɩŋ Bʋa saaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisa die cho wo Maata aŋaŋ ʋ nɩmballɩ Meri aŋaŋ Lazurusi mɩŋ, ");
INSERT INTO kma_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ama die ʋ wʋnna tʋntʋŋkʋ dɩ Lazurusi yʋagɩ wa, die ʋ wɩarɩ a bie jigidieke die ʋ benne wo damʋʋma ale. ");
INSERT INTO kma_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ta die keŋ a balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ vaa tɩ yiŋŋi ga Judia.” ");
INSERT INTO kma_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ʋ kʋaŋandɩɩsɩrɩba die dɩ baarɩ dɩ, “Dɩdagɩrʋ, daraa ale ka gie, mi vuosi die yaala ba taa fʋ aŋaŋ tana a kʋʋ mɩŋ, bɩa wɩa fʋ bɩ yaala fʋ ga mi?” ");
INSERT INTO kma_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Chaanɩŋ ŋaaŋ beri mɩŋ a nyɩŋ sʋkʋʋŋ a tʋgɩ jɩŋmɩŋ. Dɩɩ yi vuoŋ dɩ chʋŋ ŋmɩntʋasɩ ʋ kaaŋ gbɩŋ nan, dama ʋ yese tɩŋgbaŋka gie chaanɩŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama dɩɩ yi ʋ chʋŋ yuŋ ʋ nan gbɩŋ nan dama chaanɩŋ wori.” ");
INSERT INTO kma_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yisa die bala wa naa, ta bɩ balɩ gʋtɩ dɩ, “Tɩ zʋa Lazurusi gʋʋra mɩŋ, ama n nan ga a sʋgɩrɩ wa.” ");
INSERT INTO kma_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ʋ kʋaŋandɩɩsɩrɩba dɩ yiŋŋi a balɩ wa dɩ, “Tɩ Yɔmʋtieŋ, dɩɩ yi ʋ gʋʋra nɩŋ ʋ nan ye alaafɩa.” ");
INSERT INTO kma_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ama Yisa die daga dɩ Lazurusi kpiye mɩŋ ama ʋ kʋaŋandɩɩsɩrɩba die yile dɩ ʋ daga dɩ Lazurusi gʋʋra mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Die wɩa die ʋ yuori balɩ ba dɩ, “Lazurusi kpiye mɩŋ; ");
INSERT INTO kma_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ama nɩ wɩa n yaa wa sʋgɩfɩalɩŋ die n wone ʋ jigiri amʋ nɩ nan yi mɩŋ yada. Nɩ vaa tɩ ga ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Die Tomasi, vuodieke ba wasɩnana (Yiibiri) dɩ balɩ yi ʋ chanchaalɩba dɩ, “Nɩ vaa tɩ mana ga aŋaŋ wa, amʋ dɩɩ yi kuŋ, tɩ kpi aŋaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yisa die dɩ gana gbigi Betani wa, die ʋ wʋŋ dɩ ba gune Lazurusi ka daraa anɩɩsa wonde. ");
INSERT INTO kma_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani die ka yʋa aŋaŋ Jerusalemi; die ka yʋasɩ die yiwo sɩba mali ale, ");
INSERT INTO kma_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","die wɩa Juu vuosi pam die dɩ keŋ dɩ ba waasɩ Maata aŋaŋ Meri ta yɩ ba suguru yaa gamma ba nɩmbʋa kumbu wɩa. ");
INSERT INTO kma_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Die Maata dɩ wʋnna dɩ Yisa kieŋ wo, die ʋ nyɩŋ ga dɩ ʋ tuoli wo sieŋ me, ama Meri die dɩ wɩarɩ tigiŋ me. ");
INSERT INTO kma_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata die dɩ balɩ yɩ Yisa dɩ, “N Yɔmʋtieŋ, dɩɩ yi fʋ tɩŋ bie wo giena n nɩmbʋa wa gie tɩŋ kaaŋ kpi. ");
INSERT INTO kma_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama n sɩba dɩ lele gbaŋ Ŋmɩŋ nan yɩ fʋ jadieke mana fʋ jʋʋsɩna wa.” ");
INSERT INTO kma_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yisa die dɩ balɩ wa dɩ, “Fʋ nɩmbʋa wa nan hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata die dɩ yiŋŋi a balɩ wa dɩ, “N sɩba mɩŋ dɩ ʋ nan daansɩ hagɩ kuŋ me dʋnɩa kpatɩŋ daraaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yisa die dɩ balɩ dɩ, “Manɩŋ n yine vuodieke dɩ sʋgɩrɩnana kunti ta yɩa ba miivoli. Vuodieke nɩŋ dɩ yi mɩŋ yada, ʋ nan dɩ yallɩ miivoli, ʋ kpi gbaŋ; ");
INSERT INTO kma_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ta vuodieke dɩaŋ dɩ benne ʋ mɩsɩ ma ta yi mɩŋ yada kaaŋ wɔŋ kpi. Yi wɩɩrɩ gie yada mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Die ʋ yiŋŋi baarɩ dɩ, “Wa, n Yɔmʋtieŋ, n yi yada dɩ fʋnɩŋ fʋ yine Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa ta bɩ yi Ŋmɩŋ Bʋa, vuodieke dɩ bala ʋ keŋ tɩŋgbaŋka gie wo.” ");
INSERT INTO kma_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata die dɩ bala wɩaha a kpatɩ kʋaŋ chaaŋ, die ʋ yiŋŋi ga a lɔbɩrɩ a wa ʋ nɩmbʋa Meri, a balɩ wa dɩ, “Dɩdagɩrʋ wa bie giena ta pɩasa fʋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meri die dɩ wʋnna naa, die ʋ hagɩ a yi lagɩ lagɩ a nyɩŋ dɩ ʋ ga tuoli wo sieŋ me. ");
INSERT INTO kma_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yisa die dɩ ye ka tʋgɩ tɩŋkpaŋka sʋŋ, die ʋ ye bie wo jigidieke Maata dɩ tuoline wo. ");
INSERT INTO kma_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Die Juu vuodiekemba die dɩ benne tigiri me ta yɩa Meri suguru wo dɩ yene ʋ hagɩna a yi lagɩ lagɩ a nyɩnna wa die ba dɩ ʋ kʋaŋ. Die ba yile dɩ ʋ gara vɔrɩkʋ jigiŋ dɩ ʋ kʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Die Meri dɩ tʋgɩna jigidieke Yisa dɩ benne wo, ta ye wo wo, die ʋ sʋʋŋ gbirigi ʋ nɩŋŋa ta baarɩ dɩ, “N Yɔmʋtieŋ, dɩɩ yi fʋ tɩŋ bie giena n nɩmbʋa wa gie tɩŋ kaaŋ kpi.” ");
INSERT INTO kma_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yisa die dɩ ye ʋ kʋnnana ta Juu vuodiekemba dɩaŋ dɩ dɩna ʋ kʋaŋ a keŋ wo gbaŋ dɩ kʋnnana wa; die ʋ sʋŋ dɩ chʋʋsɩ pam. ");
INSERT INTO kma_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ta die pɩasɩ ba dɩ, “Sɩa nɩ gu wo?” Die ba yiŋŋi a balɩ wa dɩ, “Tɩ Yɔmʋtieŋ, keŋ a ye mi.” ");
INSERT INTO kma_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yisa die dɩ kʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Die wɩa Juu vuosisi dɩ baarɩ dɩ, “Nɩ ye ʋ faasɩna a cho Lazurusi dene.” ");
INSERT INTO kma_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama bataŋ dɩaŋ dɩ baarɩ dɩ, “Daa ʋ yuorine daa yɩɩ wa ninehe? Ʋ tɩŋ kaaŋ bɩagɩ a kagɩ aŋ Lazurusi da kpi?” ");
INSERT INTO kma_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisa sʋŋ die dɩ faasɩ a chʋʋsɩ, ta ʋ ga vɔrɩkʋ jigiŋ. Die ka yiwo taŋ lʋgɩŋ vɔrɩŋ ba nagɩ taŋ a ligi ka nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yisa die dɩ baarɩ dɩ, “Nɩ nagɩ tanɩ a nyɩŋ vɔrɩkʋ ma.” Maata, vuodieke dɩ kpine wo taa wa dɩ baarɩ dɩ, “N Yɔmʋtieŋ, ʋ nan dɩ nyʋʋgɩ dama tɩ gune wo daraa anɩɩsa wʋnna.” ");
INSERT INTO kma_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Womi Yisa dɩ balɩ a yɩ wa dɩ, “N ka balɩ fʋ dɩ dɩɩ yi fʋ yi yada nan ye Ŋmɩŋ dɩ yalla hagɩrɩŋ dene?” ");
INSERT INTO kma_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Die wɩa die ba nagɩ tanɩ a nyɩŋ vɔrɩkʋ nʋaŋ, Yisa die dɩ daansɩ ŋmɩŋsikpeŋ ta baarɩ dɩ, “N Chʋa Ŋmɩŋ, n waasa fʋ dɩ fʋ wʋnnana n jʋʋsɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N sɩba a baarɩ saŋŋa mana tuose n jʋʋsɩŋ mɩŋ, ama n bala naa vuosi gie wɩa, amʋ ba nan yi yada dɩ fʋ tʋnna mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Die ʋ balla naa a kpatɩ wa, die ʋ wa aŋaŋ lɔlɩkpɩɩŋ dɩ, “Lazurusi, keŋ nyɩŋ!” ");
INSERT INTO kma_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Womi Lazurusi die dɩ keŋ nyɩŋ, logiti die dɩ veli ʋ nuusi aŋaŋ ʋ nagɩsɩ ta garɩbɩŋ die dɩ bɔbɩ ʋ nine. Yisa die dɩ balɩ a yɩ ba dɩ, “Nɩ forisi gatɩtɩ ta vaa ʋ ga.” ");
INSERT INTO kma_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Die vuodiekemba dɩ kenne dɩ ba waasɩ Meri wa pam die dɩ ye wudieke Yisa dɩ yine wo ta yi wo yada. ");
INSERT INTO kma_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama ba bataŋ die dɩ yiŋŋi ga Farasisi vuosisi jigiŋ a balɩ ba wudieke Yisa dɩ yine. ");
INSERT INTO kma_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Die wɩa Farasisi vuosisi aŋaŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha die dɩ lagɩŋ taŋ a baarɩ dɩ, “Bɩa tɩ nan yi? Nɩ ye mamachi tʋŋ dieke daa wa gie dɩ tʋnnana. ");
INSERT INTO kma_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dɩɩ yi tɩ va wa ʋ tʋma a gara, vuoŋ mana nan keŋ yi wo yada ta Romani nyɩŋkʋraha nan keŋ a chʋʋsɩ tɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ aŋaŋ tɩŋgbaŋka gie mana.” ");
INSERT INTO kma_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Die ba wʋnyɩ saaŋ dɩ dine Kayafasi ta ʋ yi ba kɩkaabɩtɩba jakʋʋŋ bini mi die dɩ baarɩ dɩ, “Nɩnɩŋ nɩ ka sɩba wɩɩŋ! ");
INSERT INTO kma_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nɩ ka sɩba a baarɩ dɩ kpɩa dɩ vuobalɩmɩŋ tuo vuosi gie mana kuŋ a kpi a tɩaŋ tɩŋgbaŋka gie vuosi mana dɩ baaŋ kpi?” ");
INSERT INTO kma_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Die ʋ ka balɩ naa aŋaŋ ʋ gbaŋ gbaŋ ʋ yɩaŋ, ama die ʋ yine kɩkaabɩtɩba jakʋʋrɩ bini mi wo, die ʋ bʋga bala mɩŋ dɩ Yisa baa ʋ tuo wo Juu vuosi kuŋ a kpi, ");
INSERT INTO kma_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","daa ba nyɩɩna ma, ama ka baa ka yaa wa Ŋmɩŋ ballɩ diekemba dɩ jaasɩna tɩŋgbaŋka gie mana ma wa a keŋ lagɩsɩ taŋ a yi be jabalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Die wɩa a nyɩŋ daarɩ mi yaa gamma die Juu vuosisi dɩ saŋ dɩ ba kʋʋ Yisa. ");
INSERT INTO kma_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Die wɩa Yisa die ka bɩ dɩ dɩa yaalɩŋ ma Judia tɩŋgbaŋ ma, ta die nyɩŋ mi a ga tɩŋ kaanɩ dɩ gbigine hagɩyeŋ ba wasa ka Efarimi, ta die bie mi aŋaŋ ʋ kʋaŋandɩɩsɩrɩba. ");
INSERT INTO kma_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Die Juu vuosi dʋʋga dieke ba wasɩnana gasɩtɩaŋkʋ dɩ gbigi, die vuosi pam die dɩ nyɩŋ tɩgɩsɩ tɩgɩsɩ a jʋalɩ ga Jerusalemi dɩ ba wʋnsɩ ba gbaŋ ta dʋʋgaka ye tʋgɩ. ");
INSERT INTO kma_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Die vuosisi die dɩ lagɩŋna Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma wa, die ba dɩ dɩa yaala Yisa ta pɩasa taŋ dɩ, “Bɩa nɩ yile? Ʋ ka baa ʋ keŋ dʋʋgaka yaa?” ");
INSERT INTO kma_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ama kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Farasisi vuosisi die wɔŋ yɩ wa nʋaŋ dɩ vuodieke dɩ keŋ ye jigidieke Yisa dɩ benne ʋ keŋ a yɩ ba doose amʋ ba nan yigi wo. ");
INSERT INTO kma_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Die daraa ayʋaba die dɩ tɩala dɩ gasɩtɩaŋkʋ dʋʋgaka tʋgɩ wa, Yisa die dɩ ga Betani jigidieke Lazurusi die dɩ benne wo, vuodieke Yisa dɩ sʋgɩrɩna a nyɩŋ kumbu me wo. ");
INSERT INTO kma_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mi die ba digi nyindiike a yɩ wa, die Maata dɩ suŋŋi a tɩa nyindiikehe, Lazurusi die yiwo vuodiekemba dɩ dinene aŋaŋ Yisa wa wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Womi Meri die dɩ nagɩ kɔlɩba aŋaŋ tulaari dieke ligire dɩ faasɩna a tʋa a sitibu a yi Yisa nagɩsɩ ma, ta nagɩ ʋ sikpeŋ zoosi a chɩtɩ bʋ, ta tulaaribu nyuugiŋ dɩ suuli tigiri mana. ");
INSERT INTO kma_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Die Yisa kʋaŋandɩɩsɩrɩba wʋnyɩ ba wasɩnana Judasi Asikaroti, vuodieke die dɩ bala ʋ keŋ posi Yisa chɩaka die dɩ baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bɩa wɩa ba ka nagɩ tulaaribu a daa salɩnyɩala kɔbɩsɩ-taa ta nagɩ ligirebu a yɩ zɔɔlɩntieliŋ?” ");
INSERT INTO kma_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Die ʋ ka balɩ naa ʋ baga dɩ benne zɔɔlɩntieliŋ ma wɩa, ama die ʋ yine gaarʋ wɩa. Die ʋ pɔgɩlɩna ba ligire bʋlɔgɩŋ ta die gaara. ");
INSERT INTO kma_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ama Yisa die dɩ baarɩ dɩ, “Nɩ vaa Meri sɔmm! Ʋ yiwo naa a gbarɩ n guule daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nɩnɩŋ nɩ aŋaŋ zɔɔlɩntieliŋ nan dɩ beri saŋŋa mana, ama manɩŋ nɩŋ n kaaŋ dɩ beri aŋaŋ nɩ saŋŋa mana.” ");
INSERT INTO kma_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Die vuosi pam die dɩ wʋŋ dɩ Yisa keŋ Betani ma, die wɩa die ba ga mi. Die ba ka ga mi Yisa nyɩɩna ma wɩa, ama die ba yaala ba ye wo Lazurusi, vuodieke Yisa dɩ sʋgɩrɩna a nyɩŋ kumbu me wo. ");
INSERT INTO kma_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Naa wɩa kɩkaabɩtɩba nyɩŋkʋraha die dɩ saŋ dɩ ba kʋʋ Lazurusi gbaŋ; ");
INSERT INTO kma_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","dama die Lazurusi kumbu hagɩkʋ wɩa die Juu vuosi pam dɩ zeti ba kɩkaabɩtɩba nyɩŋkʋraha ama ta gara Yisa jigiŋ a yie wo yada. ");
INSERT INTO kma_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Die ka tʋnvʋʋsa die kpɩkpaakʋ die dɩ kenne gasɩtɩaŋkʋ dʋʋgaka die dɩ wʋŋ dɩ Yisa kieŋ wo Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Die wɩa die ba chɩa vaatɩ a nyɩŋ ga dɩ ba tuoli wo sieŋ a faasɩ nata dɩ, “Hozaana, Ŋmɩŋ yi alibarika a yɩ vuodieke dɩ kienene wʋnɩŋ Ŋmɩŋ saaŋ ma! Ŋmɩŋ bɩ yi alibarika a yi Izara naaŋ wa ma.” ");
INSERT INTO kma_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yisa die wɔŋ vaa ba yaalɩ wa boniŋ die ʋ jʋalɩ a kalɩ ka ma, sɩba dɩ maagɩna die Ŋmɩŋ gbaŋkʋ ma dɩ: ");
INSERT INTO kma_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zayɔni tɩŋ vuosi nɩ da vaa ŋmaamɩŋ yalla nɩ ye, nɩ naaŋ wa kieŋ, ta jʋalɩ bonpɔlɩ.” ");
INSERT INTO kma_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Saŋka mi die ʋ kʋaŋandɩɩsɩrɩba die ka sɩba wɩɩrɩ gie chɩaŋ; ama Ŋmɩŋ die dɩ kenne a sʋgɩrɩ Yisa a nyɩŋ kumbu me wo die ba tɩɩnsɩ dɩ Ŋmɩŋ gbaŋkʋ balɩ wa die yaa gamma ʋ ma, ta bɩ tɩɩnsɩ dɩ ba yiwo dene a yɩ wa. ");
INSERT INTO kma_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Die vuodiekemba die dɩ benne Yisa jigiri ta ʋ wa Lazurusi a nyɩŋ vɔrɩkʋ ma ta sʋgɩrɩ wa a nyɩŋ kumbu me wo die dɩ mʋʋla wudieke dɩ yine wo. ");
INSERT INTO kma_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Die wɩa kpɩkpaaŋ die dɩ nyɩŋ dɩ ba tuoli wo sieŋ me, dama die ba wʋŋya mɩŋ ʋ yine mamachika gie. ");
INSERT INTO kma_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Die Farasisi vuosi dɩ bala yɩa taŋ dɩ, “Tɩ kaaŋ bɩagɩ a yi wɩɩŋ lele. Ye, tɩŋgbaŋka gie vuosi mana dɩ wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Die Giriiki vuosi bataŋ die gʋtɩ wa vuodiekemba dɩ gana Jerusalemi dɩ ba ga jɩaŋ Ŋmɩŋ gasɩtɩaŋkʋ dʋʋgaka saŋka. ");
INSERT INTO kma_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Die ba ga Filipi jigiŋ vuodieke die dɩ nyɩnna Befisada tɩŋ, Galili tɩŋgbaŋ ma, a balɩ wa dɩ, “Jakʋʋŋ, tɩ yaala tɩ ye wo Yisa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi dɩaŋ dɩ ga balɩ Andurusi, ba bale wo dɩaŋ dɩ ga balɩ Yisa. ");
INSERT INTO kma_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yisa dɩ yiŋŋi balɩ ba dɩ, “Saŋŋa dieke Ŋmɩŋ dɩ bala ʋ kɔtɩ Vuota Bʋa wa ŋmɩŋsikpeŋ tʋgɩya mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wusie maŋ bala nɩ, dɩɩ yi ba bʋrɩ zabɩŋ tɩŋgbaŋ ma ka ŋaaŋ nyuuŋ mɩŋ ta zabɩnɩ kpi. Ka kʋaŋ chaaŋ zaaha bɩrɩŋ a nyɩŋ nyɩŋnyɩŋka pam. Ama ba ka bʋrɩ zabɩŋ ka kaaŋ kpi, ta kaaŋ bɩ a nyɩŋ nyɩŋnyɩŋka. Ama ka nan yiwo zabɩmbalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Vuodieke nɩŋ mana dɩ chone ʋ mɩsɩ nan waarɩ ka; ama vuodieke nɩŋ mana dɩ kana a cho ʋ gbaŋ gbaŋ ʋ mɩsɩ tɩŋgbaŋka gie me nan daansɩ ye miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Vuodieke nɩŋ mana dɩ yaala ʋ tʋŋ n tʋʋma mʋ ʋ dɩ wa n kʋaŋ, amʋ ʋ nan dɩ bie jigidieke n benne wo. Ta n Chʋa Ŋmɩŋ nan kɔtɩ vuodieke dɩ tʋnnana n tʋʋmaha ŋmɩŋsikpeŋ.” ");
INSERT INTO kma_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yisa die baarɩ dɩ, “Lele n sʋŋ faasɩ chʋʋsɩ mɩŋ, ta bɩa maŋ baaŋ n balɩ? N balɩ dɩ, ‘N Chʋa Ŋmɩŋ daa vaa wahalaka gie keŋ n ma yaa?’ Ama die wɩa maŋ keŋ, dɩ n keŋ a dii wahalaka gie. ");
INSERT INTO kma_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","N Chʋa Ŋmɩŋ vaa fʋ saarɩ ye bɩrɩŋ!” Womi lɔlɩŋ die dɩ nyɩŋ ŋmɩŋsikpeŋ a baarɩ dɩ, “N saaŋ wɔŋ ye bɩrɩŋ mɩŋ, ta nan bɩ ye bɩrɩŋ bɩbra.” ");
INSERT INTO kma_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Die kpɩkpaaŋ dieke dɩ zene mi ta wʋŋ lɔlɩkʋ, bataŋ dɩ baarɩ dɩ, “Nɩɩŋ natɩna” Bataŋ dɩaŋ dɩ, “Ŋmɩŋ malaka bala wɩa a yɩ wa.” ");
INSERT INTO kma_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ama Yisa die dɩ yiŋŋi a balɩ ba dɩ, “Daa n wɩa lɔlɩkʋ gie dɩ balɩ wɩa naa, ama dɩ yiwo nɩ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Saŋŋa dieke Ŋmɩŋ dɩ bala ʋ dii tɩŋgbaŋka vuosi sarɩya keŋye mɩŋ, ta saŋŋa dieke Ŋmɩŋ dɩ bala ʋ vigi tɩŋgbaŋka gie nɩŋŋandɩɩsɩrʋ Sitaani a taaŋ wa dɩaŋ dɩ tʋgɩ. ");
INSERT INTO kma_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ba keŋ kɔtɩ mɩŋ ŋmɩŋsikpeŋ saŋŋa dieke, n nan vaa vuota mana keŋ n jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ʋ balɩkʋ gie dagɩ wa ʋ bala ʋ kpi kuŋ dieke. ");
INSERT INTO kma_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Die kpɩkpaakʋ dɩ yiŋŋi balɩ wa dɩ, “Ŋmɩŋ gbaŋkʋ dagɩ tɩ dɩ Ŋmɩŋ vuovʋarɩkɩrɩ Masia wa baa ʋ bemme mɩŋ yaa gamma haahuu. Ta lalɩa fʋ bala dɩ sie ba kɔtɩ Vuota Bʋa wa ŋmɩŋsikpeŋ? Mɩnɩa yine Vuota Bʋa wa gie?” ");
INSERT INTO kma_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yisa die dɩ yiŋŋi balɩ ba dɩ, “Chaaŋkʋ nan dɩ bie nɩ jigiŋ saŋŋa bɩta. Die wɩa nɩ chʋmma ka ma ka yene bie nɩ jigiri amʋ lɩmɩŋ kaaŋ keŋ ligi nɩ, dama vuodieke dɩ chʋnnana lɩmɩŋ ma ka sɩba jigidieke ʋ ganana. ");
INSERT INTO kma_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Die wɩa nɩ yi vuodieke dɩ yɩnana chaaŋkʋ yada ʋ yene a bie nɩ jigiŋ naa, ta nɩ nan yi vuodiekemba dɩ benne chaaŋkʋ ma.” Die Yisa die dɩ bala naa a kpatɩ kʋaŋ chaaŋ die ʋ nyɩŋ kpɩkpaakʋ jigiŋ a ga lɔbɩrɩ. ");
INSERT INTO kma_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aŋaŋ die ʋ tʋnna mamachi tʋnkpɩɩmaha ba jigiri mana yɔrɩ, die ba ka yi wo yada. ");
INSERT INTO kma_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Naa die dɩ vaa wudieke Ŋmɩŋ naazʋa Azaya dɩ bala wa dɩ keŋ yi wusie, die ʋ baarɩ dɩ: “Tɩ Yɔmʋtieŋ, mɩnɩa tuone tɩ wɩaha? Ta mɩnɩa tɩ Yɔmʋtieŋ dɩ yuori ʋ hagɩrɩbʋ a dagɩ?” ");
INSERT INTO kma_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Die vuosisi mi die ka bɩagɩ yi Yisa yada dama Ŋmɩŋ naazʋa Azaya gbaŋ die bɩ baarɩ dɩ: ");
INSERT INTO kma_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ŋmɩŋ vaa ba yɩɩŋ mɩŋ, ta ligi ba sʋŋanyile, amʋ ba nine kaaŋ dɩ yese, ta ba kaaŋ dɩ sɩba wɩaha chɩasɩ, ta yiŋŋi keŋ manɩŋ Ŋmɩŋ n jigiŋ aŋ n gbaaŋ ba.” ");
INSERT INTO kma_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Azaya die balɩ wa naa, dama die ʋ wɔŋ ye wo Yisa chaankpeŋkpɩɩŋ ta die balɩ yaa gamma ʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Die saŋka mi die Juu vuosi nyɩŋkʋraha pam gbaŋ die yi Yisa yada mɩŋ; ama die ba chɩga Farasisi vuosi ŋmaamɩŋ ta die ka bala yaalɩŋ ma amʋ ba kaaŋ yagɩ ba nyɩŋ ba Ŋmɩŋ jɩamɩŋ juoku me. ");
INSERT INTO kma_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Naa dagɩya dɩ Juu vuosi nyɩŋkʋraha die yaala vuota bɩrɩŋ a tɩaŋ Ŋmɩŋ bɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yisa die dɩ balɩ aŋaŋ lɔlɩkpɩɩŋ dɩ, “Vuodieke nɩŋ mana dɩ yine mɩŋ yada ka yi wo n nyɩɩna ma yada, ama ʋ yi wo vuodieke dɩ tʋnna mɩŋ wa gbaŋ yada. ");
INSERT INTO kma_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta vuodieke dɩ yenene mɩŋ, yese vuodieke dɩ tʋnna mɩŋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Manɩŋ n keŋ wo tɩŋgbaŋka gie me dɩ n yi chaanɩŋ a yɩ vuosi, amʋ vuodieke mana dɩ yine mɩŋ yada kaaŋ wɩarɩ a bie lɩmɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Vuodieke nɩŋ mana dɩaŋ dɩ wʋnna n wɩaha ta ka dɩɩ ha, daa manɩŋ n bala n dii ʋ sarɩya, dama n ka keŋ tɩŋgbaŋka gie me dɩ n dii vuosi sarɩya, ama n keŋye mɩŋ dɩ n gbatɩ ba a taaŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ta vuodieke dɩ zetine mɩŋ ta ka tuo n wɩaha, sarɩya diiru benne a baa ʋ keŋ dii wo ʋ sarɩya; wudieke n balla wa bala a keŋ dii ʋ sarɩya dʋnɩa kpatɩŋ daraaŋ. ");
INSERT INTO kma_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wudieke n balala ka nyɩŋ n jigiŋ, ama n bala wudieke n Chʋa Ŋmɩŋ, vuodieke dɩ tʋnna mɩŋ wa dɩ bala dɩ n balɩ. ");
INSERT INTO kma_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta n sɩba a baarɩ ʋ wɩaha yɩa vuosi miivoli dieke dɩ wone kpatɩŋ. Wudieke n bala naa, hanɩŋ n Chʋa Ŋmɩŋ dɩ balɩ dɩ n balɩ.” ");
INSERT INTO kma_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Saŋŋa dieke die gasɩtɩaŋkʋ dʋʋgaka die dɩ yene ka piiliye wo, ama Yisa die dɩ sɩba a baarɩ dɩ ʋ saŋŋa tʋgɩya mɩŋ, dɩ ʋ nyɩŋ tɩŋgbaŋka gie me a yiŋŋi ga ʋ Chɔɔŋ jigiŋ. Ta die cho ʋ gbaŋ gbaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ benne tɩŋgbaŋka gie me, ta die yaala ʋ dagɩ ba ʋ faasɩna cho be die. ");
INSERT INTO kma_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Saŋka mi wʋnɩŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die die nyindiike; Sitaani die dɩ wɔŋ woliŋ a yi Judasi Asikaroti vuodieke dɩ yine Simoni bʋa wa dɩ yile dɩ ʋ posi Yisa chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ama Yisa nɩŋ die sɩba a baarɩ ʋ Chɔɔŋ Ŋmɩŋ nagɩ wa jaaŋ mana a yi ʋ nuusi me mɩŋ, ta bɩ sɩba a baarɩ dɩ ʋ nyɩŋ wa ʋ Chɔɔŋ Ŋmɩŋ jigiŋ mɩŋ, ta nan yiŋŋi ga ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Die wɩa die ʋ hagɩ nyindiikehe me, ta wuri ʋ jayeekiŋ a dʋaŋ, ta nagɩ bʋdʋba a bɔbɩ ʋ chɩaŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ka kʋaŋ chaaŋ die ʋ siti nyaaŋ a yi tasɩŋ ma ta piili a nɩta ʋ kʋaŋandɩɩsɩrɩba naatala ta die naga bʋdʋbɩka dɩ benne ʋ chɩaka ma wa a bilige ba naatalaha. ");
INSERT INTO kma_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta die keŋ tʋgɩ Simoni Piita jigiŋ, Piita die dɩ pɩasɩ wa dɩ, “N Yɔmʋtieŋ, yaala fʋ nɩɩtɩ wa n naatala mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Lele nɩŋ, kaaŋ dɩ sɩba wudieke n yinene wo chɩaŋ, ama ka kʋaŋ chaaŋ nan dɩ sɩba.” ");
INSERT INTO kma_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Womi Piita dɩ balɩ wa dɩ, “Manɩŋ nɩŋ kaaŋ nɩɩtɩ n naatala naada.” Yisa dɩ balɩ wa dɩ, “Dɩɩ yi maŋ ka nɩɩtɩ fʋ naatala kaaŋ bɩ yi n kʋaŋandɩɩsɩrʋ.” ");
INSERT INTO kma_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Die wɩa Simoni Piita die dɩ balɩ wa dɩ, “N Yɔmʋtieŋ, die nɩŋ da keŋ a nɩɩtɩ n naatala nyɩɩna ma, ama nɩɩtɩ n nuusi aŋaŋ n sikpeŋ a gʋtɩ.” ");
INSERT INTO kma_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yisa die dɩ balɩ wa dɩ, “Vuodieke nɩŋ dɩ wone a sɩɩ nyaaŋ, die vuoke bɩ wo dɩgɩntɩ. Die wɩa ka ka yi talasɩ dɩ ʋ bɩ sɩɩ, sie ʋ nɩɩtɩ ʋ naatala nyɩɩna ma. Nɩ mana bɩ wo dɩgɩntɩ, ntaala vuobalɩmɩŋ nyɩɩna ma yalla dɩgɩntɩ.” ");
INSERT INTO kma_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yisa die wɔŋ sɩba vuodieke dɩ bala ʋ posi ʋ chɩaŋ mɩŋ. Die wɩa die ʋ baarɩ dɩ, “Vuobalɩmɩŋ nyɩɩna yalla dɩgɩntɩ.” ");
INSERT INTO kma_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yisa die dɩ nɩtɩna ba naatala ha a kpatɩ wa, ʋ bɩ nagɩ ʋ jayeekiŋ a yeegi, ta yiŋŋi keŋ kalɩ nyindiikehe jigiŋ, ta pɩasɩ ba dɩ, “Nɩ sɩba wudieke n yinene a yɩ nɩ wa chɩaŋ mɩŋ? ");
INSERT INTO kma_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nɩ wasa mɩŋ Dɩdagɩrʋ aŋaŋ nɩ Yɔmʋtieŋ, dɩ mʋ mɩŋ dɩ nɩ wasɩnana mɩŋ die, dama n seŋ yi mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Manɩŋ n yine nɩ Yɔmʋtieŋ aŋaŋ nɩ Dɩdagɩrʋ ta nɩtɩ nɩ naatalaha gie, nɩ gbaŋ nɩ mʋ nɩ nɩtɩma taŋ naatala. ");
INSERT INTO kma_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Manɩŋ n yi a dagɩ nɩ mɩŋ dɩ nɩ yime sɩba n yine a yɩ nɩ dene wo. ");
INSERT INTO kma_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wusie maŋ bala nɩ, yɔmʋ wori a tɩaŋ ʋ tieŋ ta tʋntʋntʋ dɩaŋ dɩ wori a tɩaŋ vuodieke dɩ tʋnna wa wa. ");
INSERT INTO kma_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lele nɩ sɩba wusieke gie, nɩ nan dɩ yaa sʋgɩfɩalɩŋ pam dɩɩ yi nɩ yie he. ");
INSERT INTO kma_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“N ka bala yaa gamma nɩ mana wɩa, n sɩba nɩnɩŋ vuodieke n vʋarɩna mɩŋ. Sie wudieke dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma keŋ yi wusie. Dɩ maagɩya mɩŋ dɩ, ‘Vuodieke dɩ dinene nyindiike aŋaŋ mɩŋ wa yiŋŋe a tuole mɩŋ mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","N bala nɩ wɩɩrɩ gie ta ka wa keŋ yi, amʋ ka keŋ yi nɩ nan yi yada dɩ n yiwo vuodieke n yine. ");
INSERT INTO kma_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Wusie maŋ bala nɩ, vuodieke nɩŋ mana dɩ tuone vuodieke nɩŋ mana n tʋnna wa tuo wo n gbaŋ, ta vuodieke nɩŋ mana dɩ tuone mɩŋ, tuo wo vuodieke dɩ tʋna mɩŋ wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Die Yisa dɩ bala wɩɩrɩ gie kʋaŋ chaaŋ, die ʋ sʋŋ dɩ chʋʋsɩ pam, die ʋ balɩ yuori be dɩ, “Wusie maŋ bala nɩ, nɩ wʋnyɩ bala ʋ posi n chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ʋ kʋaŋandɩɩsɩrɩba die dɩ yiŋŋi daansa taŋ ta ka sɩba vuodieke ʋ dagɩnana wa. ");
INSERT INTO kma_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Die ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ die ʋ faasɩna cho die dɩ kalɩ a gbigi wo. ");
INSERT INTO kma_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Die Simoni Piita die dɩ kamɩsɩ wa a balɩ wa dɩ, “Pɩasɩ wa ye vuodieke ʋ dagɩnana.” ");
INSERT INTO kma_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Die ʋ kʋaŋandɩɩsɩrɩ wa mi die dɩ vɩɩsɩ a gbigi Yisa a pɩasɩ wa dɩ, “N Yɔmʋtieŋ, mɩnɩa wonde?” ");
INSERT INTO kma_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yisa die dɩ yiŋŋi balɩ wa dɩ, “Maŋ keŋ nagɩ paanʋkʋ a sugi jɩɩtɩ ma a nagɩ yɩ vuodieke wo, wʋnɩŋ vuoke mi wonde.” Die wɩa ʋ nagɩ paanʋkʋ a sugi jɩɩtɩtɩ a nagɩ yɩ Judasi vuodieke die dɩ yine Simoni Asikaroti bʋa wa. ");
INSERT INTO kma_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Die Judasi die dɩ dene tuo paanʋkʋ a kpatɩ, Sitaani die dɩ juu wo. Womi Yisa dɩ balɩ wa dɩ, “Yi lagɩ lagɩ a yi wudieke fʋ bala fʋ yi wo.” ");
INSERT INTO kma_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ama ba wʋnyɩ die ka sɩba wudieke Yisa dɩ bala a yɩ wa wa chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Die Judasi dɩ pɔgɩlɩnana ba ligire bʋlɔgɩrɩ wɩa die ba bataŋ dɩ yile dɩ Yisa balɩ wa mɩŋ dɩ ʋ ga daa jadieke ba bala ba nagɩ dii gasɩtɩaŋkʋ dʋʋgaka yaa ʋ ga nagɩ ligire a yɩ zɔɔlɩntielibe. ");
INSERT INTO kma_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasi die dɩ dene tuo paanʋkʋ die ʋ nyɩŋ bʋnyɩ. Die dɩ yiwo yuŋ. ");
INSERT INTO kma_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judasi die dɩ gana kʋaŋ chaaŋ, Yisa die dɩ baarɩ dɩ, “Lele gie, manɩŋ Vuota Bʋa wa nan ye bɩrɩŋ, ta n ma Ŋmɩŋ dɩ nan ye bɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dɩɩ yi Ŋmɩŋ dɩ ye bɩrɩŋ n ma, die nɩŋ dɩ kaaŋ yʋasɩ ʋ nan vaa manɩŋ Vuota Bʋa gbaŋ ye bɩrɩŋ ʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","N ballɩ, n kaaŋ bɩ bie nɩ jigiŋ a yʋasɩ. Nɩ nan dɩ dɩa a yaala mɩŋ, ama lele n bala nɩ wudieke n bala a yɩ Juu vuosisi nyɩŋkʋraha dɩ, ‘Nɩ kaaŋ bɩagɩ a ga jigidieke n ganana wa.’ ");
INSERT INTO kma_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ta lele, n wa yɩa nɩ wa mɩrɩhaalɩŋ: nɩ chome taŋ. N chone nɩ dene wo nɩ mʋ nɩ chome taŋ dene. ");
INSERT INTO kma_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Dɩɩ yi nɩ yaa choti aŋaŋ taŋ, die nɩŋ vuoŋ mana nan dɩ sɩba dɩ nɩ yiwo n kʋaŋandɩɩsɩrɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Piita die dɩ pɩasɩ wa dɩ, “N Yɔmʋtieŋ, sɩa fʋ gara?” Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Lele jigidieke n ganana wa kaaŋ bɩagɩ dɩ n kʋaŋ ama kʋaŋ chaaŋ nan keŋ.” ");
INSERT INTO kma_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piita die dɩ bɩ pɩasɩ wa dɩ, “N Yɔmʋtieŋ, bɩa wɩa maŋ kaaŋ bɩagɩ dɩ fʋ kʋaŋ lele? Manɩŋ n yi siri dɩ n zie fʋ naŋ ma a kpi.” ");
INSERT INTO kma_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yisa die dɩ bɩ pɩasɩ wa dɩ, “Fʋnɩŋ seŋ yi siri mɩŋ dɩ fʋ zie n naŋ ma a kpi? Wusie maŋ bala fʋ, kparaaŋ nan keŋ baa ka kʋmma ta chiisi wo bʋtaa dɩ ka sɩba mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisa die dɩ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Nɩ da vaa nɩ sʋgɩtɩ chʋʋsɩ. Nɩ yi Ŋmɩŋ yada ta bɩ yi n gbaŋ yada. ");
INSERT INTO kma_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Juone pam bie n Chʋa Ŋmɩŋ tigiŋ me ta maŋ gara dɩ n wʋnsɩ a yɩ nɩ. Dɩ tɩŋ ka yi wusie n tɩŋ kaaŋ balɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Maŋ keŋ ga a wʋnsɩ a kpatɩ kʋaŋ chaaŋ, n nan viiri keŋ a nagɩ nɩ a ga jigidieke n benne wo, amʋ nɩ nan dɩ bie jigidieke n benne wo. ");
INSERT INTO kma_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nɩ sɩba sie dieke dɩ ganana jigidieke n ganana wa.” ");
INSERT INTO kma_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi die dɩ pɩasɩ wa dɩ, “N Yɔmʋtieŋ, tɩ ka sɩba jigidieke fʋ ganana wa, die wɩa lalɩa tɩ baa tɩ yi a ye sieku a ga mi?” ");
INSERT INTO kma_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yisa dɩ yiŋŋi a balɩ wa dɩ, “Manɩŋ n yine sieku aŋaŋ wusieke aŋaŋ miivoli. Vuoŋ wori a baaŋ bɩagɩ keŋ n Chʋa Ŋmɩŋ jigiŋ ntaala ʋ daagɩ n ma. ");
INSERT INTO kma_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dɩɩ yi nɩ tɩŋ sɩba mɩŋ, nɩ tɩŋ nan dɩ sɩba n Chʋa wa gbaŋ. Ama a nyɩŋ jinne yaa gamma nɩ sɩba wa ta ye wo mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi die dɩ balɩ wa dɩ, “N Yɔmʋtieŋ, wudieke tɩ yaala wʋnna, dagɩ tɩ fʋ Chʋa wa.” ");
INSERT INTO kma_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yisa dɩ yiŋŋi balɩ wa dɩ, “Filipi, n bie nɩ jigiŋ a yʋasɩ mɩŋ, ama fʋ ka sɩba mɩŋ? Vuodieke nɩŋ mana dɩ yene mɩŋ ye n Chʋa wa mɩŋ. Bɩa wɩa fʋ baarɩ dɩ, ‘Dagɩ tɩ fʋ Chʋa wa’? ");
INSERT INTO kma_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipi, ka yi yada dɩ n bie wo n Chʋa wa ma, ta n Chʋa dɩ bie n ma.” Yisa die dɩ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Wudiekemba n bala nɩ wa ka nyɩŋ n jigiŋ, ama a nyɩŋ wa n Chʋa Ŋmɩŋ jigiŋ. Wʋnɩŋ ʋ benne n ma maŋ tʋma tʋʋmaha gie. ");
INSERT INTO kma_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Die wɩa, nɩ yi mɩŋ yada dɩ n bie wo n Chʋa Ŋmɩŋ ma, ta n Chʋa Ŋmɩŋ dɩaŋ dɩ bie n ma. Dɩ daa die, ama nɩ yi mɩŋ yada mamachi tʋŋ diekemba n tʋnnana wa wɩa. ");
INSERT INTO kma_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wusie maŋ bala nɩ, vuodieke mana dɩ yine mɩŋ yada nan tʋŋ tʋŋ diekemba n tʋnnana wa, ta ʋ tʋʋma gbaŋ nan tɩaŋ n tʋʋmaha, dama n gara n Chʋa Ŋmɩŋ jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta n nan yi wudieke mana nɩ jʋʋsɩna a yaala n saaŋ ma, amʋ wʋnɩŋ Ŋmɩŋ nan ye bɩrɩŋ n wɩa. ");
INSERT INTO kma_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dɩɩ yi nɩ jʋʋsɩ mɩŋ jadieke mana n saaŋ ma, n nan yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Dɩɩ yi nɩ cho mɩŋ, nɩ nan dɩ dɩ n mɩraha, ");
INSERT INTO kma_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ta n nan jʋʋsɩ n Chʋa Ŋmɩŋ aŋ ʋ yɩ nɩ Halɩkasɩka aŋ ʋ suŋŋime nɩ ta bemme nɩ jigiŋ saŋŋa mana. ");
INSERT INTO kma_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Halɩkasɩka nan dagɩ nɩ wudieke dɩ yine wusie. Tɩŋgbaŋka gie vuosi kaaŋ bɩagɩ a tuo Halɩkasɩka dama ba ka yese wo yaa a sɩba wa. Ama nɩnɩŋ nɩŋ, nɩ sɩba Halɩkasɩka vuodieke dɩ benne nɩ jigiŋ ta nan dɩ bie nɩ jigiŋ yaa gamma haahuu wo. ");
INSERT INTO kma_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Maŋ keŋ ga n kaaŋ vaa nɩ sɩba bikpiisi. N nan viiri a keŋ nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dɩ kaaŋ yʋasɩ tɩŋgbaŋka gie vuosi kaaŋ bɩ ye mɩŋ bɩbra, ama nɩnɩŋ nɩ nan ye mɩŋ. Dama n nan dɩ beri n mɩsɩ ma; die wɩa nɩ gbaŋ nɩ nan dɩ bie nɩ mɩsɩ ma. ");
INSERT INTO kma_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Maŋ keŋ yiŋŋi a keŋ n mɩsɩ ma, nɩ nan dɩ sɩba dɩ n bie wo n Chʋa wa ma, ta nɩ dɩaŋ nɩ bie n ma sɩba n benne nɩ ma dene wo. ");
INSERT INTO kma_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Vuodiekemba dɩ tuosinene n mɩraha ta dɩ ha banɩŋ ba yine vuodiekemba dɩ chone mɩŋ; ta n Chʋa nan dɩ cho be, ta n gbaŋ n nan dɩ cho be ta yuori a dagɩ ba vuodieke n yine.” ");
INSERT INTO kma_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasi (vuoke gie ka yi Judasi Asikaroti wa) dɩ pɩasɩ wa dɩ, “N Yɔmʋtieŋ, bɩa yine fʋ bala dɩ nan yuori fʋ gbaŋ a dagɩ tɩ, ama kaaŋ yuori fʋ gbaŋ a dagɩ tɩŋgbaŋka gie vuosi?” ");
INSERT INTO kma_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Vuodieke nɩŋ mana dɩ chone mɩŋ nan dɩ dɩɩ n dagɩkʋ. Ta n Chʋa Ŋmɩŋ nan dɩ cho wo, ta manɩŋ aŋaŋ n Chʋa nan keŋ ʋ jigiŋ a bemme aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ama vuodieke nɩŋ mana dɩ kana ka cho mɩŋ ka dɩɩ n dagɩkʋ. Wudiekemba nɩ wʋnna wa ka nyɩŋ wa n gbaŋ gbaŋ n jigiŋ, ama a nyɩŋ wa n Chʋa Ŋmɩŋ vuodieke dɩ tʋnna mɩŋ wa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“N bala wɩaha gie mana a yɩa nɩ n yene bie nɩ jigiŋ naa. ");
INSERT INTO kma_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama Susuŋŋiru, Ŋmɩŋ Halɩkasɩka vuodieke n Chʋa Ŋmɩŋ dɩ bala ʋ tʋŋ n saaŋ ma wa, nan dagɩ nɩ jaaŋ mana ta vaa nɩ tɩɩnsɩ wudiekemba mana n bala nɩ wa. ");
INSERT INTO kma_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Sʋgɩdʋagɩŋ maŋ yɩa nɩ daa sʋgɩdʋagɩ dieke dɩ yine sɩba tɩŋgbaŋka gie sʋgɩdʋagɩŋ. Die wɩa, nɩ daa vaa jaaŋ mugisi nɩ yaa ŋmaamɩŋ yalla nɩ. ");
INSERT INTO kma_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nɩ wɔŋ a wʋŋ n bala nɩ dɩ ‘N gara mɩŋ ama n nan viiri keŋ nɩ jigiŋ.’ Dɩɩ yi nɩ seŋ cho mɩŋ, nɩ nan dɩ yaa sʋgɩfɩalɩŋ dɩ n yiŋŋi gara n Chʋa Ŋmɩŋ jigiŋ, dama ʋ tɩaŋ mɩŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N bala nɩ wɩaha gie lele ta a wa yi, amʋ a keŋ yi, nɩ nan yi yada. ");
INSERT INTO kma_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","N kaaŋ balɩ aŋaŋ nɩ a yʋasɩ, dama tɩŋgbaŋka gie naaŋ Sitaani kieŋ mɩŋ, ama ʋ wo n hagɩrɩŋ, ");
INSERT INTO kma_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ama n yaala tɩŋgbaŋka gie vuosi sɩmma dɩ n cho n Chʋa Ŋmɩŋ aŋaŋ wusie; die wɩa maŋ yie jaaŋ mana sɩba ʋ dagɩna mɩŋ dene wo. “Nɩ vaa tɩ gamma.” ");
INSERT INTO kma_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ka kʋaŋ chaaŋ Yisa die dɩ balɩ a yɩ ʋ kʋaŋandɩɩsɩrɩba dɩ, “Manɩŋ n yine tɩɩ dieke dɩ nyɩnnana nyɩŋnyɩŋka wusie, ta n Chʋa Ŋmɩŋ dɩ yi ka wʋnwʋnsɩrʋ. ");
INSERT INTO kma_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naŋ dieke mana dɩ kana ka nyɩŋ nyɩŋnyɩŋka ʋ chɩaka taana mɩŋ; ama ta wʋnsa naŋ dieke dɩ nyɩnnana nyɩŋnyɩŋkaha amʋ a nan dɩ vɩɩna a nyɩŋ nyɩŋnyɩŋka pam. ");
INSERT INTO kma_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lele nɩnɩŋ nɩ yiwo vuovɩɩna wudiekemba n balla a yɩ nɩ wa wɩa. ");
INSERT INTO kma_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nɩ wɩarɩ a bemme aŋaŋ mɩŋ ta n gbaŋ n nan wɩarɩ a beri aŋaŋ nɩ. Tɩɩŋ naŋ ka bɩagɩ nyɩnna nyɩŋnyɩŋka ka gbaŋ; ntaala ka taasɩ aŋaŋ tɩɩka. Die gbaŋ gbaŋ dɩ sɩɩ, nɩ kaaŋ bɩagɩ a nyɩŋ nyɩŋnyɩŋka ntaala nɩ wɩarɩ n ma. ");
INSERT INTO kma_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Manɩŋ n yine nyɩŋnyɩŋka tɩɩka ta nɩ yi ka nagɩsɩ. Vuodieke nɩŋ mana dɩ wɩarɩna n ma, ta n dɩaŋ maŋ bie ʋ ma, nan nyɩŋ nyɩŋnyɩŋka pam, dama maŋ ka gʋtɩ nɩ ma nɩ kaaŋ bɩagɩ yi wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Vuodieke nɩŋ mana dɩ kana ka wɩarɩ a bie n ma ba nan chɩa wa a taaŋ. Ʋ nan dɩ sɩɩ sɩba naakʋʋka ba lagɩsɩna a juu boliŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dɩɩ yi nɩ wɩarɩ n ma, ta n wɩaha dɩ wɩarɩ nɩ ma, die nɩŋ nɩ jʋʋsɩ Ŋmɩŋ jadieke nɩ yaalala nɩ nan ye. ");
INSERT INTO kma_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dɩɩ yi nɩ nyɩnna nyɩŋnyɩŋka vɩɩna pam, hanɩŋ a bala a dagɩ dɩ nɩ seŋ yiwo n kʋaŋandɩɩsɩrɩba aŋaŋ wusie, ta n Chʋa Ŋmɩŋ nan ye bɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“N cho nɩ sɩba n Chʋa Ŋmɩŋ dɩ chone mɩŋ dene wo; nɩ wɩarɩ n ma aŋ n choti bemme nɩ ma. ");
INSERT INTO kma_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Dɩɩ yi nɩ tuo n nʋarɩ, nɩ nan wɩarɩ n chome me sɩba n tuone n Chʋa Ŋmɩŋ nʋarɩ ta wɩarɩ ʋ chome me dene wo. ");
INSERT INTO kma_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“N bala naa a yɩa nɩ dɩ sʋgɩfɩalɩ dieke n yalla wa chanchaaŋ nan dɩ bie nɩ ma, amʋ nɩ nan suuli aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","N mɩra wʋnna; nɩ chome taŋ sɩba n chone nɩ dene wo. ");
INSERT INTO kma_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Chotikpeŋkpɩɩŋ bɩ wori a tɩaŋ vuoŋ dɩ tuone ʋ zʋalɩŋ kuŋ a kpi. ");
INSERT INTO kma_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Dɩɩ yi nɩ yi wudieke n dagɩna nɩ, nɩ yiwo n zʋalɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N ka bɩ wasa nɩ n tʋntʋntɩŋ bɩbra dama tʋntʋntʋ ka sɩba wudieke ʋ jakʋʋŋ dɩ yilinene. Ama n wasa nɩ n zʋalɩŋ dama n balɩ nɩ wudieke mana n wʋnna a nyɩŋ n Chʋa Ŋmɩŋ jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nɩnɩŋ daa nɩ vʋarɩna mɩŋ, ama n vʋarɩna nɩ a yɩ nɩ tʋʋma dɩ nɩ ga nyɩŋ nyɩŋnyɩŋka pam, ta nyɩŋnyɩŋka mi yi nyindieke dɩ baaŋ dɩ beri haahuu. Ta n Chʋa Ŋmɩŋ nan yɩ nɩ jadieke mana nɩ jʋʋsɩnana yaala n saaŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","N mɩra wʋnna maŋ yɩa nɩ; nɩ chome taŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Dɩɩ yi tɩŋgbaŋka vuosi dɩ haa nɩ, nɩ tɩɩnsɩ dɩ die ba woliŋ haa mɩŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dɩɩ yi nɩ tɩŋ yi tɩŋgbaŋka gie vuosi, tɩŋgbaŋka gie vuosi tɩŋ nan dɩ cho nɩ sɩba ba chone ba gbaŋ dene wo. Ama n vʋarɩ nɩ mɩŋ a nyɩŋ tɩŋgbaŋka ma ta nɩ ka yi ka sɩɩtɩ; die wɩa tɩŋgbaŋka gie vuosi dɩ haa nɩ wa. ");
INSERT INTO kma_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɩ tɩɩnsɩ wudieke n bala nɩ wa dɩ, ‘Yɔmʋ wori a tɩaŋ ʋ tieŋ.’ Dɩɩ yi die ba mugisi mɩŋ, ba nan mugisi nɩ gbaŋ; ta dɩɩ yi die ba tuo n dagɩkʋ ba nan tuo nɩ gbaŋ nɩ dagɩkʋ. ");
INSERT INTO kma_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba nan seŋ a mugisi nɩ dama nɩ yine n sɩɩtɩ wɩa, dama ba ka sɩba Ŋmɩŋ, vuodieke dɩ tʋnna mɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Die maŋ tɩŋ ka keŋye a balɩ wɩa a yɩ ba, die ba tɩŋ kaaŋ dɩ yaa bɩaŋ mana. Ama lele n kenne a balɩ wɩa a yɩ ba naa, sieŋ bɩ wori ba baaŋ nan bɩagɩ a lɔbɩrɩ ba tʋmbɩatɩ. ");
INSERT INTO kma_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Vuodieke nɩŋ dɩ hana mɩŋ haa wa n Chʋa wa gbaŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Maŋ tɩŋ ka yi tʋnkpɩɩma dieke vuoŋ dɩ yene ka yiye ba jigiŋ, ba tɩŋ kaaŋ dɩ yaa bɩaŋ. Ama lele ba yeye mɩŋ ta ye haa manɩŋ aŋaŋ n Chʋa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Naa yiye mɩŋ dɩ ka vaa wudieke dɩ maagɩna ba mɩraha ma wa keŋ yi wusie, die ba maagɩya dɩ, ‘Ba haa mɩŋ wa yɔrɩ’. ");
INSERT INTO kma_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“N nan tʋŋ Susuŋŋiru nɩ jigiŋ, vuodieke dɩ yine Ŋmɩŋ Halɩkasɩka ta daga wusie dagɩkʋ. Ʋ nan nyɩŋ n Chʋa Ŋmɩŋ jigiŋ a keŋ nɩ jigiŋ, ta balɩ wɩa yaa gamma n ma. ");
INSERT INTO kma_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta nɩ gbaŋ nɩ nan balɩ wɩa yaa gamma n ma, dama nɩ bie wo n jigiŋ a nyɩŋ saŋŋa dieke n piiline n tʋʋmaha mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“N bala nɩ naa, amʋ nɩ kaaŋ keŋ zeti n dɩɩsɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba nan keŋ yagɩ nɩ a nyɩŋ ba Ŋmɩŋ jɩamɩŋ juone me. Ta saŋŋa nan keŋ ta vuodieke dɩ keŋ a kʋʋ nɩ ʋ tieŋ nan dɩ yile dɩ ʋ tʋma die a yɩa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba nan keŋ yi wɩaha gie mana dama ba ka sɩba n Chʋa Ŋmɩŋ yaa manɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ama n bala nɩ naa amʋ saŋŋa dɩ keŋ tʋgɩ dɩ ba yi wɩaha gie, nɩ nan tɩɩnsɩ dɩ n wɔŋ balɩ nɩ mɩŋ. “Die n ka balɩ nɩ wɩaha gie piiliku me, dama die n bie wo nɩ jigiŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ama lele nɩŋ n yiŋŋi a gara n Chʋa, vuodieke dɩ tʋnna mɩŋ wa jigiŋ. Ama nɩ wʋnyɩ ka pɩasa mɩŋ jigidieke n ganana. ");
INSERT INTO kma_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ama lele n bala nɩ wɩaha gie wo, nɩ yaa sʋgɩchʋʋsɩŋ pam. ");
INSERT INTO kma_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wusie maŋ bala nɩ, dɩ vɩɩna a yɩ nɩ dɩ n ga, dama dɩɩ yi maŋ ka gaya, Susuŋŋiru wo kaaŋ keŋ nɩ jigiŋ. Ama maŋ ga n nan tʋŋ wa nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ʋ keŋ keŋ saŋŋa dieke wo, ʋ nan dagɩ tɩŋgbaŋka gie vuosi wusie yaa gamma bɩaŋ ma. Ta bɩ dagɩ ba wusie yaa gamma Ŋmɩŋchɩgɩla aŋaŋ wusie yaa gamma Ŋmɩŋ sarɩya diile. ");
INSERT INTO kma_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ʋ nan dagɩ ba dɩ ba yaa bɩaŋ ba kana ka yi mɩŋ yadaka wɩa. ");
INSERT INTO kma_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A bɩ gʋtɩ, ʋ nan dagɩ ba Ŋmɩŋchɩgɩla dɩ sɩna die, dama n gara n Chʋa Ŋmɩŋ jigiŋ, ta nɩ kaaŋ bɩ ye mɩŋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A bɩ dagɩ ba yaa gamma Ŋmɩŋ sarɩya diile, dama Ŋmɩŋ wɔŋ dii tɩŋgbaŋka gie naaŋ wa Sitaani sarɩya ta chʋʋsɩ wa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N yaa wɩa pam dɩ n balɩ nɩ, ama lele a nan dɩ dala pam dɩ nɩ pɔgɩlɩ. ");
INSERT INTO kma_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama Ŋmɩŋ Halɩkasɩka vuodieke dɩ dagɩnana wusieke dɩ keŋ keŋ, ʋ nan dagɩ nɩ wusie mana. Ʋ kaaŋ dɩ bala aŋaŋ ʋ gbaŋ gbaŋ yiko, ama ʋ nan dɩ bala wudiekemba ʋ wʋnnana a nyɩnna Ŋmɩŋ jigiŋ, ta balɩ nɩ wudiekemba dɩ bala a keŋ a yi. ");
INSERT INTO kma_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ʋ nan vaa n ye bɩrɩŋ, dama ʋ nan nagɩ wa n wɩa a balɩ a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jadieke mana n Chʋa dɩ sɩna yiwo n sɩɩtɩ, die wɩa maŋ baarɩ Ŋmɩŋ Halɩkasɩka nan dɩ naga n wɩa a daga nɩ. ");
INSERT INTO kma_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Dɩɩ yi sʋaa nɩ kaaŋ ye mɩŋ, ta dɩ bɩ yi sʋaa nɩ nan ye mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Die ʋ kʋaŋandɩɩsɩrɩba die dɩ pɩasa taŋ dɩ, “Wɩɩrɩ gie chɩaŋ? Ʋ baarɩ dɩ, ‘Dɩɩ yi sʋaa nɩ kaaŋ ye mɩŋ, ta dɩ bɩ yi sʋaa, nɩ nan ye mɩŋ’; Ta bɩ baarɩ dɩ, ‘Dama n gara n Chʋa jigiŋ.’ ");
INSERT INTO kma_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Die ba pɩasa taŋ dɩ, ‘Sʋaa ka chɩaŋ?’ Tɩ ka sɩba wudieke ʋ balala wa chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yisa die dɩ mɩŋŋɩ dɩ ba yaala ba pɩasɩ wa mɩŋ, die wɩa die ʋ balɩ a yɩ ba dɩ, “N baarɩ dɩ, ‘Dɩɩ yi sʋaa nɩ kaaŋ ye mɩŋ, ta dɩɩ bɩ yi sʋaa nɩ nan ye mɩŋ.’ Wɩɩrɩ gie nɩ pɩasa tamba ta yaala nɩ sɩmma ka chɩaŋ? ");
INSERT INTO kma_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wusie maŋ bala nɩ, nɩ nan keŋ kʋma ta die zɔɔlɩŋ ama tɩŋgbaŋka gie vuosi nan dɩ yaa sʋgɩfɩalɩŋ; nɩ sʋgɩtɩ nan keŋ chʋʋsɩ, ama nɩ sʋgɩchʋʋsɩkʋ nan keŋ bɩrɩŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Dɩ nan dɩ sɩɩ sɩba hɔgʋ dɩ ŋaana baa ʋ mɩɩrɩ ta ʋ sʋŋ dɩ chʋʋsɩ dene wo, dama ʋ wahala saŋŋa tʋgɩya mɩŋ, ama ʋ mɩɩrɩ kpatɩ ʋ ŋaaŋ daaŋ mɩŋ ʋ wahala ka mɩŋ, dama ʋ ŋaaŋ yaa wa sʋgɩfɩalɩŋ ʋ mɩɩrɩna bʋa a keŋ tɩŋgbaŋka gie me wo wɩa. ");
INSERT INTO kma_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Die dɩ sɩɩ aŋaŋ nɩ, lele nɩ sʋgɩtɩ chʋʋsɩya mɩŋ, ama n nan bɩ ye nɩ bɩbra ta nɩ nan dɩ yaa sʋgɩfɩalɩŋ pam, sʋgɩfɩalɩ dieke vuoŋ dɩ kana kaaŋ bɩagɩ a tuoke a nyɩŋ nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Dɩnɩŋ daarɩ dɩ keŋ tʋgɩ, nɩ kaaŋ jʋʋsɩ mɩŋ a yaala jaaŋ. Wusie maŋ bala nɩ, n Chʋa Ŋmɩŋ nan yɩ nɩ jadieke mana nɩ jʋʋsɩna a yaala n saaŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ama a yaa keŋ tʋgɩ jinne, nɩ ye ka jʋʋsɩ a yaala jaaŋ n saaŋ ma. Nɩ jʋʋsɩ ta nɩ nan ye, amʋ nɩ nan dɩ yaa sʋgɩfɩalɩŋ pam. ");
INSERT INTO kma_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“N bala nɩ wɩaha gie aŋaŋ nandaga, ama saŋŋa kieŋ n kaaŋ bɩ nagɩ nandaga a balɩ yɩ nɩ ama n nan balɩ yuori nɩ yaa gamma n Chʋa Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Saŋka dɩ keŋ tʋgɩ nɩ nan jʋʋsɩ n Chʋa n saaŋ ma, n ka baarɩ n nan zie nɩ naŋ ma a jʋʋsɩ wa. ");
INSERT INTO kma_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Dama n Chʋa Ŋmɩŋ gbaŋ cho nɩ mɩŋ, dama nɩ cho mɩŋ mɩŋ, ta yi yada dɩ n nyɩŋ wa n Chʋa wa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wusie, die n nyɩŋ wa n Chʋa wa jigiŋ ta keŋ sʋʋŋ tɩŋgbaŋka gie me, ta lele n nyɩnna tɩŋgbaŋka gie me a yiŋŋi gara ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Womi ʋ kʋaŋandɩɩsɩrɩba dɩ balɩ wa dɩ, “Ye, lele ʋ wa yuori balɩ tɩ mɩŋ ta ka naga nandaga. ");
INSERT INTO kma_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lele tɩ wa sɩba dɩ sɩba jaaŋ mana mɩŋ, ta ka bɩ mʋ dɩ vuoŋ pɩasɩ fʋ wʋpɩasɩka. Lele tɩ yi yada mɩŋ dɩ seŋ nyɩŋ wa Ŋmɩŋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yisa die dɩ yiŋŋi a pɩasɩ ba dɩ, “Lele nɩ wa yi yada mɩŋ? ");
INSERT INTO kma_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saŋŋa kieŋ, ta ka wɔŋ keŋ mɩŋ, ta nɩ mana nan jaasɩ a ga nɩ tige nɩ tige ta n wɩarɩ n nyɩɩna ma. Ama n kaaŋ seŋ a wɩarɩ n nyɩɩna ma, n Chʋa Ŋmɩŋ nan dɩ bie n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","N balɩ nɩ wɩaha gie amʋ nɩ nan dɩ yaa sʋgɩdʋagɩŋ n wɩa. Tɩŋgbaŋka gie me nɩ nan dii wahala ama nɩ dii sikimiŋ dama n wɔŋ nyaŋŋɩ tɩŋgbaŋka mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisa die dɩ bala wɩaha gie a kpatɩ wa, die ʋ daansɩ ŋmɩŋsikpeŋ ta baarɩ dɩ, “N Chʋa, saŋka tʋgɩya mɩŋ. Vaa manɩŋ fʋ Bʋa Dembike ye bɩrɩŋ, amʋ n gbaŋ n nan vaa fʋ ye bɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Dama fʋ yɩna mɩŋ vuota mana yiko dɩ n yɩ vuodiekemba fʋ nagɩna a yɩ mɩŋ wa miivoli dieke dɩ wone kpatɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Miivoli dieke dɩ wone kpatɩŋ yiwo dɩ vuosi sɩmma fʋnɩŋ vuodieke dɩ yine wusie Ŋmɩŋ, ta ŋmɩŋ bɩ wori, ta bɩ sɩba manɩŋ Yisa Masia, vuodieke fʋ tʋnna wa. ");
INSERT INTO kma_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N vaa fʋ ye bɩrɩŋ tɩŋgbaŋka gie me aŋaŋ n kpatɩna wudiekemba mana fʋ yɩ mɩŋ dɩ n yi wo. ");
INSERT INTO kma_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","N Chʋa, yɩ mɩŋ bɩrɩŋ fʋ nɩŋŋa lele, bɩrɩ dieke die n yalla saŋŋa dieke die n benne fʋ jigiŋ ta fʋ ye ka naaŋ dʋnɩaka gie wo. ");
INSERT INTO kma_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Vuodiekemba fʋ nagɩna a yɩ mɩŋ wa, n vaa ba sɩba fʋ mɩŋ. Die ba yiwo fʋ sɩɩtɩ, ta fʋ nagɩ ba a yɩ mɩŋ, ta ba tuo fʋ wɩaha. ");
INSERT INTO kma_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ta lele, ba sɩba dɩ jadieke mana fʋ nagɩna a yɩ mɩŋ wa nyɩŋ wa fʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Dama n nagɩ wa wudiekemba fʋ nagɩna a yɩ mɩŋ wa a yɩ ba ta ba tuohe; ba sɩba dɩ dɩ yiwo wusie dɩ n nyɩŋ wa fʋ jigiŋ, ta bɩ yi yada dɩ fʋ tʋnna mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Lele, n jʋʋsa a yɩa ba. N ka jʋʋsa a yɩa tɩŋgbaŋka gie vuosi mana, ama n jʋʋsa yɩa vuodiekemba fʋ nagɩna a yɩ mɩŋ wa, dama ba yiwo fʋ sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vuodiekemba mana n yalla yiwo fʋ sɩɩtɩ, ta vuodiekemba mana fʋ yalla dɩ yi n sɩɩtɩ, ta maŋ yese bɩrɩŋ ba wɩa. ");
INSERT INTO kma_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ta lele n kieŋ wo fʋ jigiŋ, ta kaaŋ bɩ a bie tɩŋgbaŋka gie me, ama banɩŋ nɩŋ ba bie wo tɩŋgbaŋka ma. N Chʋa, vuodieke dɩ yine kasɩ, mɩŋŋɩ gbara ba aŋaŋ fʋ saarɩ hagɩrɩbʋ, saaŋ dieke fʋ nagɩna a yɩ mɩŋ wa ta daa vaa wɩɩŋ yi be, amʋ ba nan yi jabalɩmɩŋ sɩba maŋ aŋaŋ fʋ dɩ yine jabalɩmɩŋ dene wo. ");
INSERT INTO kma_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Die n yene bie ba jigiŋ, die n mɩŋŋɩ gbarɩ ba mɩŋ aŋaŋ fʋ saarɩ hagɩrɩbʋ, saaŋ dieke fʋ nagɩna a yɩ mɩŋ wa. Die n gbarɩ ba mɩŋ ta ba wʋnyɩ dɩ ka baya ntaala vuodieke dɩ yine Sitaani sɩɩtɩ wa. Naa die yiye mɩŋ amʋ wudieke dɩ maagɩna fʋ gbaŋkʋ ma wa nan keŋ a yi wusie. ");
INSERT INTO kma_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lele, n kieŋ wo fʋ jigiŋ ama n bala wɩaha gie n yene bie tɩŋgbaŋka gie me wo, amʋ ba sʋgɩtɩ nan suuli aŋaŋ sʋgɩfɩalɩ dieke n yalla wa chanchaaŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Die n nagɩ fʋ wɩaha a yɩ ba mɩŋ, ta tɩŋgbaŋka gie vuosi dɩ haa ba ba kana ka yi tɩŋgbaŋka gie sɩɩtɩ wa wɩa, sɩba n gbaŋ dɩ kana ka yi tɩŋgbaŋka gie sɩɩtɩ die wo. ");
INSERT INTO kma_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","N ka jʋʋsa fʋ dɩ fʋ vʋarɩ ba a nyɩŋ tɩŋgbaŋka gie me ama n jʋʋsa fʋ dɩ fʋ mɩŋŋɩ gbarɩ ba a nyɩŋ wʋbɩatɩtieŋ, Sitaani nuusi me. ");
INSERT INTO kma_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","N kana ka yi tɩŋgbaŋka gie sɩɩtɩ dene wo, die gbaŋ ba gbaŋ dɩ ka yi tɩŋgbaŋka sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Fʋ wʋbalɩkaha yi wo wusie, die wɩa vaa wusieke gie seŋ yi ba yi fʋ sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Die fʋ tʋnna mɩŋ tɩŋgbaŋka gie dene wo, die maŋ tʋma ba tɩŋgbaŋka gie me. ");
INSERT INTO kma_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ba wɩa n naga n gbaŋ yɩa fʋ, dɩ ba yi fʋ gbaŋ gbaŋ fʋ sɩɩtɩ aŋaŋ wusie. ");
INSERT INTO kma_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“N ka jʋʋsa a yɩa ba nyɩɩna ma, ama n jʋʋsa yɩa vuodiekemba dɩ bala ba keŋ yi mɩŋ yada yaa gamma ba wʋbalɩka ma. ");
INSERT INTO kma_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","N Chʋa, n jʋʋsa mɩŋ dɩ ba mana yi jabalɩmɩŋ. Vaa ba bemme tɩ ma sɩba fʋ benne n ma ta n dɩaŋ maŋ bie fʋ ma dene wo. Vaa ba yi jabalɩmɩŋ amʋ tɩŋgbaŋka gie nan yi yada dɩ fʋ tʋnna mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Sʋgɩyɩalɩŋ beri dieke die fʋ yɩna mɩŋ wa, kanɩŋ maŋ nagɩ yɩa ba, amʋ ba yi jabalɩmɩŋ sɩba fʋnɩŋ aŋaŋ mɩŋ dɩ yine jabalɩmɩŋ dene wo. ");
INSERT INTO kma_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","N bie wo ba ma, ta fʋ dɩaŋ fʋ bie n ma, amʋ ba nan keŋ yi jabalɩmɩŋ aŋ tɩŋgbaŋka gie vuosi sɩmma dɩ fʋ tʋnna mɩŋ, ta fʋ cho be sɩba fʋ chone mɩŋ dene wo. ");
INSERT INTO kma_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“N Chʋa, fʋnɩŋ fʋ nagɩna ba a yɩ mɩŋ, n yaala ba bemme n jigiŋ, jigidieke n bala n bemme, amʋ ba nan ye fʋ kɔtɩna n saaŋ dene, dama wɔŋ cho mɩŋ mɩŋ ta ye naaŋ tɩŋgbaŋka gie. ");
INSERT INTO kma_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","N Chʋa, sʋgɩyɩalɩŋ tieŋ, tɩŋgbaŋka gie vuosi ka sɩba fʋ, ama manɩŋ n sɩba fʋ mɩŋ, ta n kʋaŋandɩɩsɩrɩba gie dɩ sɩba dɩ fʋ tʋnna mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N balɩ ba fʋ sɩna dene, ta n nan dɩ bala ba yaa gamma, amʋ choti dieke fʋ yalla aŋaŋ mɩŋ wa nan dɩ bie ba ma, ta n dɩaŋ n nan dɩ bie ba ma.” ");
INSERT INTO kma_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisa die dɩ jʋʋsɩna Ŋmɩŋ jʋʋsɩkʋ gie a kpatɩ wa, die ʋ nyɩŋ mi aŋaŋ ʋ kʋaŋandɩɩsɩrɩba ba ga garɩsɩ Kidironi lʋaka. Die kʋaŋ die benne mi, ta ga juu mi. ");
INSERT INTO kma_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Die Judasi vuodieke dɩ posine Yisa chɩaka die dɩ sɩba mi dama Yisa die ŋaaŋ lagɩsa mi aŋaŋ ʋ kʋaŋandɩɩsɩrɩba. ");
INSERT INTO kma_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Die wɩa Judasi die dɩ ga kʋakʋ mi aŋaŋ Romani sojasi aŋaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gbɩgbarɩtɩ diekemba kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Farasisi vuosisi dɩ tʋnna. Die ba yaa wa popolisi aŋaŋ kamɔla aŋaŋ ba jɩbɩwagɩtɩ. ");
INSERT INTO kma_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yisa die dɩ wɔŋ sɩba wudieke dɩ bala ka yi wo, die wɩa die ʋ pɩasɩ ba dɩ, “Mɩnɩa nɩ yaala?” ");
INSERT INTO kma_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Die ba yiŋŋi balɩ wa dɩ, “Yisa, vuodieke dɩ nyɩnna Nazeriti wa.” Die ʋ baarɩ dɩ, “Manɩŋ n yine wʋnɩŋ?” Die Judasi, vuoke dɩ posine ʋ chɩaka die zie wo mi aŋaŋ ba. ");
INSERT INTO kma_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Die Yisa dɩ bala dɩ, “N yine wʋnɩŋ wa”, die ba chʋŋ a nyɩŋ kʋaŋ a nan tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yisa die dɩ bɩ pɩasɩ ba dɩ, “Mɩnɩa nɩ dɩ dɩa yaala?” Ba baarɩ dɩ, “Yisa, vuodieke dɩ nyɩnna Nazeriti wa.” ");
INSERT INTO kma_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yisa die dɩ baarɩ dɩ, “N wɔŋ balɩ nɩ mɩŋ dɩ n yine wʋnɩŋ. Dɩɩ yi nɩ dɩ dɩa a yaala manɩŋ, die nɩŋ nɩ vaa n kʋaŋandɩɩsɩrɩba gie ga.” ");
INSERT INTO kma_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Die ʋ balɩ wa naa amʋ wudieke die ʋ bala wa nan keŋ yi wusie, die ʋ baarɩ dɩ, “N Chʋa, n ka vaa vuodiekemba fʋ nagɩna a yɩ mɩŋ wʋnyɩ dɩ bɩa.” ");
INSERT INTO kma_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saŋka mi ta Simoni Piita die dɩ yaa jɩbɩwaŋ, die ʋ vʋarɩ ka a viisi a gobi kɩkaabɩtɩba jakʋʋrɩ yɔmʋ wʋnyɩ nuudiigiŋ tɩbɩŋ a taaŋ. Die yɔmʋ wa saaŋ die yine Malikusi. ");
INSERT INTO kma_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yisa die dɩ balɩ a yi Piita dɩ, “Nagɩ fʋ jɩbɩka a yi ka fɔgʋkʋ ma. Yile mɩŋ dɩ n ka yaala dɩ n dii wahala dieke n Chʋa dɩ nagɩna a zieŋ mɩŋ wo?” ");
INSERT INTO kma_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Die Romani sojasisi aŋaŋ ba jakʋʋŋ aŋaŋ Juu vuosi Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gbɩgbarɩtɩba die dɩ yigi Yisa a bɔbɩ wa, ");
INSERT INTO kma_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ta woliŋ yaa wa a ga Anasi jigiŋ. Anasi die yiwo Kayafasi hanɩɩŋ, Kayafasi die yine kɩkaabɩtɩba jakʋʋŋ kanɩŋ bɩnɩŋ mi. ");
INSERT INTO kma_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Die wʋnɩŋ ʋ bala Juu vuosi nyɩŋkʋraha dɩ dɩ vɩɩna vuobalɩmɩŋ tuo vuosisi mana kuŋ a kpi wo. ");
INSERT INTO kma_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Die Simoni Piita aŋaŋ ʋ chanchaaŋ Yisa kʋaŋandɩɩsɩrɩŋ wʋnyɩ die dɩ dɩ Yisa kʋaŋ. Die kʋaŋandɩɩsɩrʋ wa gie die yi wo vuodieke kɩkaabɩtɩba jakʋʋrɩ dɩ sɩbɩna. Die wɩa die ʋ dɩ Yisa kʋaŋ a ga juu kɩkaabɩtɩba jakʋʋrɩ gbaakʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Piita die dɩ wɩarɩ a zie yeŋ me. Die kʋaŋandɩɩsɩrʋ wa mi, vuodieke kɩkaabɩtɩba jakʋʋrɩ dɩ sɩbɩna wa die dɩ yiŋŋi a ga a balɩ wɩa aŋaŋ havʋʋbɩ dieke dɩ zene sanʋarɩ tɩŋ wa ta yaa Piita a keŋ juu. ");
INSERT INTO kma_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Die havʋʋbike dɩ pɩasɩ Piita dɩ, “Ka yiwo daa wa mi kʋaŋandɩɩsɩrɩba wʋnyɩ?” Piita die dɩ baarɩ dɩ, “Aayɩ, n ka yi ba wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Die watɩ benne die wɩa tʋntʋntɩba aŋaŋ gbɩgbarɩtɩba die dɩ chɔgɩsɩ boliŋ a zie a weele. Piita die dɩ ga ba jigiŋ a zie weele. ");
INSERT INTO kma_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Die kɩkaabɩtɩba jakʋʋrɩ die dɩ pɩasɩ Yisa yaa gamma ʋ kʋaŋandɩɩsɩrɩba aŋaŋ ʋ dagɩkʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Die n daga vuosi yaalɩŋ ma, ta daga Ŋmɩŋ jɩamɩŋ juone me aŋaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma jigidieke Juu vuosi mana dɩ ŋaana a lagɩŋsa wa. Manɩŋ die n ka lɔbɩrɩ a balɩ wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ta bɩa wɩa fʋ pɩasa mɩŋ? Pɩasɩ vuodiekemba dɩ wʋnnana mɩŋ wa. Dama ba sɩba wudieke n bala wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Die Yisa die dɩ bala naa wa, die gbɩgbarɩtɩba wʋnyɩ dɩ zene gbigi wo die dɩ falɩ wa ta baarɩ dɩ, “Die ba bala wɩa a yɩa kɩkaabɩtɩba jakʋʋŋ?” ");
INSERT INTO kma_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Die Yisa die dɩ yiŋŋi a balɩ dɩ, “Dɩɩ yi wʋbɩaŋ maŋ balɩ, balɩ vuoŋ mana giena dɩ dɩ yiwo bɩaŋ, ama dɩɩ yi wusie aŋaŋ wudieke n bala wa, bɩa wɩa fʋ nɩga mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Womi Anasi die dɩ vaa ba nagɩ Yisa a ga Kayafasi jigiŋ, vuodieke dɩ yine kɩkaabɩtɩba jakʋʋrɩ; ta die ba ye bɔbɩ Yisa. ");
INSERT INTO kma_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Piita die ye zie wo mi a weele bolibu, womi die ba pɩasɩ wa dɩ, “Ka yiwo daa wa mi kʋaŋandɩɩsɩrɩba wʋnyɩ?” Ama Piita die dɩ chiisi ta baarɩ dɩ, “Aayɩ, n ka yi ba wʋnyɩ.” ");
INSERT INTO kma_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Die kɩkaabɩtɩba jakʋʋrɩ yɔŋɩsɩ wʋnyɩ, vuodieke nɩmbʋa Piita dɩ gobine ʋ tɩbɩrɩ dɩ pɩasɩ wa dɩ, “Die n ka ye fʋ aŋaŋ wa kʋakʋ ma?” ");
INSERT INTO kma_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta Piita die dɩ bɩ chiisi. Lele womi kparaaŋ dɩ kʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Die ba nagɩ Yisa a nyɩŋ Kayafasi tigiŋ me a yaa wa ga tɩŋgbaŋka jakʋʋrɩ vuodieke die dɩ dine Paliti tigiŋ. Die sʋkʋleeliŋ die wonde. Die Juu vuosi die ka juu ʋ tigiri dama die ba yaala ba mɩŋŋɩ a pɔgɩlɩ ba gbaŋ vɩɩnɩŋ Ŋmɩŋ nɩŋŋa, amʋ ba nan bɩagɩ dii gasɩtɩaŋkʋ dʋʋgaka. ");
INSERT INTO kma_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Die wɩa Paliti die dɩ nyɩŋ a ga ba jigiŋ, a pɩasɩ ba dɩ, “Bɩa nɩ baa daa wa gie yiye?” ");
INSERT INTO kma_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Die ba yiŋŋi a balɩ wa dɩ, “Ʋ tɩŋ ka yi wɩɩŋ, tɩ tɩŋ kaaŋ yaa wa keŋ fʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ta Paliti dɩ balɩ a yɩ ba dɩ, “Nɩ gbaŋ gbaŋ nɩ yaa wa a ga dii ʋ sarɩya nɩ mɩraha dɩ dagɩna dene.” Die Juu vuosi nyɩŋkʋraha dɩ yiŋŋi baarɩ dɩ, “Tɩ wo sieŋ dɩ tɩ kʋʋ vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Naa die yiye mɩŋ, amʋ Yisa die dɩ balla dɩ ʋ nan keŋ kpi kuŋ dieke wo keŋ yi wusie. ");
INSERT INTO kma_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Die Paliti die dɩ yiŋŋi juu tigiri sʋŋ ta wa Yisa a pɩasɩ wa dɩ, “Fʋ yine Juu vuosi naaŋ wa?” ");
INSERT INTO kma_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yisa die dɩ yiŋŋi a pɩasɩ wa dɩ, “Fʋ gbaŋ gbaŋ fʋ wʋpɩasɩkɩŋ wʋnna yaa vuosi bala fʋ yaa gamma n ma?” ");
INSERT INTO kma_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paliti die dɩ yiŋŋi a baarɩ dɩ, “Yi tama n yiwo Juu vuoŋ yaa? Dɩ yiwo fʋ gbaŋ gbaŋ fʋ vuosi aŋaŋ ba kɩkaabɩtɩba jakʋʋrɩ yalla fʋ a keŋ n jigiŋ. Bɩa fʋ yi?” ");
INSERT INTO kma_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yisa die baarɩ dɩ, “N naarɩ ka yi tɩŋgbaŋka gie sɩɩtɩ, ka tɩŋ yiwo tɩŋgbaŋka gie sɩɩtɩ n dɩdɩɩsɩrɩba tɩŋ nan wagɩ dɩ Juu vuosisi da yigi mɩŋ. Aayɩ, n naarɩ ka yi tɩŋgbaŋka gie sɩɩtɩ.” ");
INSERT INTO kma_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Die Paliti die dɩ pɩasɩ wa dɩ, “Die nɩŋ seŋ yiwo naaŋ?” Die Yisa dɩ baarɩ dɩ, “Wa, fʋnɩŋ fʋ balla dɩ n yiwo naaŋ. Ba mɩɩrɩ mɩŋ mɩŋ a keŋ tɩŋgbaŋka gie me wʋbalɩmɩŋ wɩa, dɩ n balɩ yaa gamma wusieke me. Ta vuodieke nɩŋ mana dɩ yine wusieke sɩɩtɩ dɩ wʋma mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paliti die dɩ pɩasɩ dɩ, “Bɩa yine wusie?” Balɩkʋ gie kʋaŋ chaaŋ die ʋ nyɩŋ ga Juu vuosi nyɩŋkʋraha jigiŋ, a baarɩ dɩ, “N ka ye wudieke daa wa dɩ yine a chʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama nɩ chʋaraha sʋŋ n ŋaaŋ vʋarɩ wa dansarɩka vuoŋ a yɩa nɩ gasɩtɩaŋkʋ dʋʋga saŋŋa mana. Nɩ yaala n vʋarɩ wa Juu naaŋ wa a yɩ nɩ yɔrɩ?” ");
INSERT INTO kma_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Die ba yiŋŋi balɩ wa aŋaŋ lɔlɩkpɩɩŋ dɩ, “Aayɩ, daa wʋnɩŋ, tɩ yaala Barabasi.” Barabasi die yiwo gbɩgbatɩrʋ. ");
INSERT INTO kma_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Womi Paliti die dɩ vaa ba tɩbɩ Yisa aŋaŋ kpaasɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ta sojasisi die dɩ nagɩ haŋgɔɔsɩ a wʋnsɩ sibubiŋ a nagɩ a bubi wo, a nagɩ jayeekiwaŋ ŋmɩnɩŋ a yeegi wo, ");
INSERT INTO kma_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","a keŋ bala dɩ, “Juu vuosi naaŋ wa tɩ waasa fʋ”, ta die fala wa. ");
INSERT INTO kma_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Die Paliti dɩ bɩ nyɩŋ vuosisi jigiŋ bɩbra a balɩ ba dɩ, “Nɩ ye, n nan yaa wa a keŋ nyɩŋ a yɩ nɩ aŋ nɩ sɩmma dɩ manɩŋ a ka ye wudieke ʋ yine a chʋʋsɩ.” ");
INSERT INTO kma_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Die Yisa dɩ kenne nyɩŋ ta bubi haŋgɔɔsɩ sibubike ta yeegi jayeekiwaŋ ŋmɩnka, Paliti die dɩ balɩ a yɩ ba dɩ, “Daa wa wʋnna.” ");
INSERT INTO kma_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Die kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ ba Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gbɩgbarɩtɩba die dɩ yene Yisa wa ba nata dɩ, “Nɩ kpaasɩ wa dagarɩkɩŋ ma, nɩ kpaasɩ wa dagarɩkɩŋ ma.” Ama Paliti die dɩ yiŋŋi a balɩ ba dɩ, “Nɩ gbaŋ gbaŋ nɩ nagɩ wa a ga kpaasɩ wa dagarɩkʋ ma. Dama manɩŋ n ka ye wudieke ʋ yine a chʋʋsɩ.” ");
INSERT INTO kma_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Die kpɩkpaakʋ dɩ yiŋŋi a balɩ wa dɩ, “Ʋ baarɩ dɩ ʋ yiwo Ŋmɩŋ Bʋa! Tɩ mɩraha dɩ baarɩ dɩ ʋ mʋ ba kʋʋ wa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Paliti die dɩ wʋnna ba bala naa wa, die ŋmaamɩŋ dɩ bɩ faasɩ yigi wo. ");
INSERT INTO kma_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Die ʋ yiŋŋi juu gbaakʋ sʋŋ a pɩasɩ Yisa dɩ, “Sɩa fʋ nyɩŋ?” Ama Yisa die ka yiŋŋi balɩ wa wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ta Paliti dɩ bɩ a pɩasɩ wa dɩ, “Kaaŋ tɔgɩŋ mɩŋ? Sɩmma dɩ n yaa yiko a baaŋ bɩagɩ a vaa fʋ ga yɔrɩ, ta bɩ nan bɩagɩ vaa ba kpaasɩ fʋ dagarɩkɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yisa die dɩ yiŋŋi a balɩ dɩ, “Fʋnɩŋ yaa wa yiko n ma dama Ŋmɩŋ nagɩna ka a yɩ fʋ. Die wɩa vuodieke dɩ nagɩna mɩŋ a keŋ yi fʋ nuusi me bɩaŋ tɩaŋ fʋ mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Paliti die dɩ wʋnna naa wa, die ʋ mɩa dɩ ʋ tɩŋ vaa Yisa ga yɔrɩ. Ama Juu vuosisi die dɩ nata bala wa dɩ, “Dɩɩ yi fʋ vaa ʋ ga yɔrɩ, die nɩŋ ka yi naaŋ Siiza zʋa, dama vuodieke nɩŋ mana dɩ bala dɩ ʋ yiwo naaŋ yiwo naakpeŋkpɩɩŋ Siiza dataaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Die Paliti dɩ wʋnna naa wa, die ʋ yaa Yisa a keŋ nyɩŋ yeŋ me a sʋʋŋ kalɩ ʋ sarɩya diile gbaŋtɩ ma jigidieke ba wasɩnana Taŋ Koriŋ. (Juu vuosi jabalɩkɩŋ ma ba wasa ka Gabata.) ");
INSERT INTO kma_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Die ka yiwo ŋmɩntʋasɩ, ta die ka tʋnvʋʋsa dɩ baa dɩ yi gasɩtɩaŋkʋ dʋʋgaka daraaŋ. Paliti die dɩ balɩ a yɩ Juu vuosisi dɩ, “Nɩ naaŋ wa wʋnna.” ");
INSERT INTO kma_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Die ba yiŋŋi natɩ a baarɩ dɩ, “Kʋʋ wa! Kʋʋ wa! Kpaasɩ wa dagarɩkɩŋ ma.” Paliti die dɩ pɩasɩ ba dɩ, “Nɩ yaala n kpaasɩ wa nɩ naaŋ wa dagarɩkʋ ma?” Die kɩkaabɩtɩba nyɩŋkʋraha die dɩ baarɩ dɩ, “Tɩ wo naakpɩɩŋ a gʋtɩ naaŋ Siiza ma.” ");
INSERT INTO kma_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Womi Paliti die dɩ nagɩ Yisa a yɩ dɩ ba ga kpaasɩ wa dagarɩkɩŋ ma. Die wɩa sojasisi die dɩ nagɩ Yisa. ");
INSERT INTO kma_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Die ʋ chii ʋ dagarɩkʋ ba yaa wa a nyɩŋ gara jigidieke ba wasɩnana “Sikpeŋkogiliŋ jigiŋ.” (Juu vuosi jabalɩkɩŋ ma ba wasa ka Goligota). ");
INSERT INTO kma_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mi die ba kpaasɩ wa dagarɩkʋ ma; ta die bɩ kpaasɩ dembisi bale dagarɩsɩ ma a gʋtɩ Yisa ma, ta wʋnyɩ mana die dɩ bie ʋ lʋgɩŋ ta ʋ bie ba sʋnsʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paliti die dɩ maagɩ a diisi jaaŋ ma a nagɩ a kpaasɩ a marɩ Yisa dagarɩkʋ dɩ, ");
INSERT INTO kma_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Juu vuosi pam die dɩ karɩŋ wɩɩrɩ gie dama jigidieke die ba kpaasɩna Yisa dagarɩkʋ ma die ka yʋa aŋaŋ Jerusalemi. Die ba maagɩ wɩɩrɩ wa Juu vuosi aŋaŋ Romani vuosi aŋaŋ Giriiki vuosi nyɩŋbalɩka ma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Die Juu vuosi kɩkaabɩtɩba nyɩŋkʋraha die dɩ balɩ a yɩ Paliti dɩ, “Bɩa wɩa fʋ maagɩ dɩ ʋ yine Juu vuosi naaŋ wa? Tɩŋ mʋ fʋ maagɩ wa dɩ, ‘Daa wa baarɩ ʋ yine Juu vuosi naaŋ wa.’ ” ");
INSERT INTO kma_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paliti die dɩ yiŋŋi balɩ ba dɩ, “Wudieke n maagɩna wa wo tarɩgɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Die sojasisi die dɩ kpaasɩna Yisa dagarɩkʋ ma kʋaŋ chaaŋ, die ba nagɩ ʋ nyiŋyeeke a puo bʋnɩɩsa, ba wʋnyɩ mana die dɩ nagɩ kaanɩ. A kʋaŋ chaaŋ ba bɩ nagɩ ʋ jayeekiwaŋ dieke dɩ benne sʋŋ ma ba yʋgɩna jamʋʋmɩŋ, ta wo baalɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Die sojasisi die dɩ balɩ a yɩ taŋ dɩ, “Nɩ da vaa tɩ chɩɩrɩ ka; ama nɩ vaa tɩ taa chaachaa a ye vuodieke dɩ bala ʋ dii ke.” Naa die yiye mɩŋ amʋ wudieke Ŋmɩŋ gbaŋkʋ dɩ balla wa nan keŋ a yi wusie dɩ; “Die ba puo n gatɩ a yɩ tamba Ta taa chaachaa n jayeekiwaŋ dieke dɩ benne sʋŋ ma wɩa.” Naa sojasisi die dɩ yi. ");
INSERT INTO kma_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Die Yisa nuŋ die zie mi a gbigi dagarɩkɩrɩ, wʋnɩŋ aŋaŋ ʋ nɩmbʋa Meri vuodieke die dɩ yine Kilopasi hɔgʋ wa, aŋaŋ Meri vuodieke dɩ nyɩnna Magidalini. ");
INSERT INTO kma_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yisa die dɩ ye ʋ nuŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩ dieke ʋ faasɩna cho dɩ zene mi wo, die wɩa die ʋ balɩ yɩ ʋ nuŋ wo dɩ, “Geŋ wo wana a yi fʋ Bʋadembiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta balɩ ʋ kʋaŋandɩɩsɩrʋ wa dɩ, “Fʋ dɩaŋ fʋ naa wʋnna.” A nyɩŋ dɩnɩŋ daarɩ mi, ʋ kʋaŋandɩɩsɩrʋ wa mi, dɩ nagɩ Yisa nuŋ ʋ ga bie ʋ tigiŋ me. ");
INSERT INTO kma_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ka kʋaŋ chaaŋ Yisa die dɩ mɩŋŋɩ dɩ wɩɩŋ mana wa kpatɩ mɩŋ, die ʋ baarɩ dɩ, “Nyanyuule yalla mɩŋ.” Die ʋ balɩ wa naa amʋ wudieke dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma wa nan keŋ yi wusie. ");
INSERT INTO kma_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Die kpagɩŋ die zene mi aŋaŋ daŋmɩɩsɩŋ die ba nagɩ gbaara a lu bʋ ma, a nagɩ saagɩ daaŋ sikpeŋ a kɔtɩ ka jʋalɩ a gbɩ ʋ nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Die Yisa dɩ nyune bʋ a kpatɩ wa, die ʋ baarɩ dɩ, “Dɩ kpatɩya mɩŋ!” Ta die nagɩ ʋ haalɩŋ a yɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Die ka tʋnvʋʋsa baa ka yiwo Juu vuosi davʋʋsɩkɩrɩ daraaŋ aŋaŋ gasɩtɩaŋkʋ dʋʋgaka daraaŋ. Die ka yiwo daakpɩɩŋ a yɩ Juu vuosisi, ta die ka yaala vuodiekemba ba kpaasɩna dagarɩsɩ ma nyɩŋgbanɩŋ wɩarɩ mi dɩnɩŋ daarɩ mi. Die wɩa die ba jʋʋsɩ Paliti dɩ ʋ vaa ba wɩɩ ba nagɩsɩ ta nagɩ ba nyɩŋgbanɩŋ a keŋ sʋʋŋ tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Die sojasisi die dɩ woliŋ a wɩɩ dembisi bale wo ba kpaasɩna mi wo nagɩsɩ. ");
INSERT INTO kma_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Die ba kenne tʋgɩ Yisa wa, die ba ye ta ʋ wɔŋ a kpi mɩŋ, die wɩa die ba ka wɩɩ ʋ nagɩsɩ. ");
INSERT INTO kma_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ta sojasi wʋnyɩ die dɩ tɔbɩ Yisa lʋgɩŋ aŋaŋ ʋ timiŋ. Lele womi zɩŋ aŋaŋ nyaaŋ die dɩ keŋ nyɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tɩ sɩba a baarɩ wɩɩrɩ gie yiwo wusie dama vuodieke dɩ yene ke wo balla. Lele nɩ gbaŋ nɩ nan bɩagɩ yi yada. ");
INSERT INTO kma_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wɩaha gie mana yiye mɩŋ amʋ wudieke Ŋmɩŋ gbaŋkʋ dɩ bala wa nan keŋ yi wusie, die ka baarɩ dɩ, “Ba kaaŋ wɩɩ ʋ kɔbɩŋ kaanɩ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ta Ŋmɩŋ gbaŋkʋ dɩ bɩ balɩ jigiŋ kaanɩ dɩ, “Vuosi nan keŋ daansa vuodieke ba tɔbɩna ʋ lʋgɩŋ aŋaŋ timiŋ.” ");
INSERT INTO kma_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ka kʋaŋ chaaŋ Josefu vuodieke dɩ nyɩnna Arimatia die dɩ jʋʋsɩ Paliti dɩ ʋ nagɩ Yisa nyɩŋgbaŋka. Die Josefu die yiwo Yisa dɩdɩɩsɩrʋ, ama die ʋ lɔbɩrɩ a dɩ wa mɩŋ, dama die ʋ chɩga Juu vuosi nyɩŋkʋraha ŋmaamɩŋ mɩŋ. Paliti die dɩ yɩ wa sieŋ die wɩa Josefu die dɩ a nagɩ nyɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ta Nikodimosi vuodieke die dɩ gana Yisa jigiŋ yuŋ kaanɩ wa, die beline Josefu, ta pɔgɩlɩ nyɩnnyʋʋgɩvɩɩna dieke ba bala ba nagɩ yi Yisa nyɩŋgbaŋka, die a yiwo sɩba gbarɩgbɩnɩ baŋ anʋ. (Die ba nagɩ wa nyindieke ba wasɩnana miri aŋaŋ alosi a wʋnsɩ ha.) ");
INSERT INTO kma_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Die ba bale wo die dɩ nagɩ Yisa nyɩŋgbaŋka a veli ke aŋaŋ garɩhaalɩ yɩalɩŋ aŋaŋ nyɩnnyʋʋgaha, sɩba die Juu vuosisi kuŋ guule chʋara dɩ dagɩna die. ");
INSERT INTO kma_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Die ba kpaasɩna Yisa jigidieke wo, kʋaŋ die bene mi, ta vɔrɩŋ die dɩ wɔŋ bie mi ta die ba ye ka guu vuoŋ kanɩŋ vɔrɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Die tʋŋ dɩ bala ka vʋŋ, dɩ Juu vuosi davʋʋsɩkɩrɩ daraaŋ wa, ta vɔrɩkʋ dɩaŋ die dɩ gbigi mi wo, die wɩa die ba guu wo mi. ");
INSERT INTO kma_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ta Juu vuosi davʋʋsɩkɩrɩ daraaŋ die dɩ keŋ tɩaŋ, ta Alasiri daraaŋ sʋkʋleeliŋ ta die dɩ ye sibi, Meri Magidalini die dɩ ga Yisa vɔrɩkʋ jigiŋ, ta die a ye taŋ dieke ba nagɩna a ligi vɔrɩkʋ nʋaŋ dɩ biline. ");
INSERT INTO kma_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Die wɩa die ʋ chɩgɩ a ga Simoni Piita aŋaŋ Yisa kʋaŋandɩɩsɩrɩ dieke Yisa dɩ faasɩna a cho wo jigiŋ, ta balɩ ba dɩ, “Ba vʋarɩ wa tɩ Yɔmʋtieŋ a nyɩŋ vɔrɩkʋ ma, ta tɩ ka sɩba jigidieke ba nagɩna wa a ga dʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Die Piita aŋaŋ Yisa kʋaŋandɩɩsɩrʋ wa mi die dɩ chɩga gara, ");
INSERT INTO kma_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ama Yisa kʋaŋandɩɩsɩrʋ wa mi die dɩ faasɩ a chɩgɩ a tɩaŋ Piita a woliŋ a ga tʋgɩ vɔrɩkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Die wʋnɩŋ kʋaŋandɩɩsɩrʋ mi die dɩ sʋʋŋ zʋʋrɩ a ye garɩhaalɩ yɩalɩkʋ ba nagɩna guu Yisa wa dɩ dʋana ama die ʋ ka juu vɔrɩkʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Womi Simoni Piita, vuodieke dɩ wɩarɩna kʋaka dɩ keŋ tʋgɩ, a juu vɔrɩkʋ sʋŋ a ye garɩkʋ dɩ dʋana, ");
INSERT INTO kma_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aŋaŋ garɩ dieke ba nagɩna vili Yisa sikpeku. Die garɩkʋ mi die kpeŋ ba kpenne ka dene wo a vili ʋ sikpeku a dʋa ka nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ka kʋaŋ chaaŋ kʋaŋandɩɩsɩrʋ wa mi die dɩ wolinne a tʋgɩ wa gbaŋ die dɩ juu vɔrɩkʋ sʋŋ a ye ta yi yada. ");
INSERT INTO kma_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ama die ba ye ka sɩba wudieke dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma chɩaŋ, dɩ Yisa nan hagɩ kuŋ me wo. ");
INSERT INTO kma_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Womi die ʋ kʋaŋandɩɩsɩrɩba dɩ yiŋŋi a kuli. ");
INSERT INTO kma_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ama Meri nɩŋ die dɩ wɩarɩ a zie vɔrɩkʋ jigiŋ a kʋma. Die ʋ kʋnana wa die ʋ sʋʋŋ zʋʋrɩ a daansɩ vɔrɩkʋ sʋŋ ");
INSERT INTO kma_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a ye malakasi bale dɩ yeegine nyɩŋyɩala wʋnyɩ dɩ kalɩ jigidieke die ba nagɩna Yisa nyɩŋgbaŋka a dʋaŋ wa sikpeŋ chaaŋ ta wʋnyɩ dɩaŋ dɩ kalɩ ʋ nagɩsɩ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Die ba pɩasɩ wa dɩ, “Hɔgʋ, bɩa wɩa fʋ kʋma?” Ʋ yiŋŋi a balɩ ba dɩ, “Ba nagɩ wa n Yɔmʋtieŋ ta maŋ ka sɩba jigidieke ba nagɩna wa a ga dʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Die ʋ balla naa a kpatɩ wa, die ʋ yiŋŋi a ye Yisa dɩ zene mi, ama die ʋ ka mɩŋŋɩya dɩ dɩ yiwo Yisa. ");
INSERT INTO kma_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yisa die dɩ pɩasɩ wa dɩ, “N taa, bɩa wɩa fʋ kʋma? Mɩnɩa fʋ dɩ dɩa yaala?” Meri nɩŋ die yile dɩ dɩ yiwo kʋakʋ tʋntʋntʋ, ta die balɩ a yɩ wa dɩ, “Jakʋʋŋ, dɩɩ yi fʋ nagɩna wa, dagɩ mɩŋ jigidieke fʋ nagɩna wa a ga dʋaŋ aŋ n ga nagɩ wa.” ");
INSERT INTO kma_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yisa die dɩ baarɩ dɩ “Meri”, die Meri die dɩ yiŋŋi a tuoli wo a wa wa Juu vuosi jabalɩkɩŋ ma dɩ, “Raboni!” (Ka chɩaŋ yine “Dɩdagɩrʋ”.) ");
INSERT INTO kma_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yisa die dɩ balɩ a yɩ wa dɩ, “Da keŋ a gbɩ mɩŋ, dama n ye ka yiŋŋi ga ŋmɩŋsikpeŋ n Chʋa jigiŋ, ama ga a ga balɩ n nɩmballɩlɩ dɩ n yiŋŋi gara n Chʋa vuodieke dɩ yine nɩ gbaŋ nɩ Chɔɔŋ wa jigiŋ; wʋnɩŋ ʋ bɩna a yi n Ŋmɩŋ aŋaŋ nɩ gbaŋ nɩ Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Die wɩa Meri Magidalini die dɩ ga a ga Yisa dɩdɩɩsɩrɩba jigiŋ a balɩ ba dɩ ʋ ye wo tɩ Yɔmʋtieŋ wo. Ta balɩ ba wudieke ʋ bala wa wa. ");
INSERT INTO kma_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Die Alasirika mi daraaŋ yuŋ, Yisa kʋaŋandɩɩsɩrɩba die dɩ lagɩsɩ taŋ a bie juoŋ me ta kparɩ, dama die ba chɩga Juu vuosi nyɩŋkʋraha ŋmaamɩŋ mɩŋ. Womi Yisa die dɩ keŋ zie ba sʋnsʋŋ, a baarɩ dɩ, “Sʋgɩdʋagɩŋ bemme nɩ ma.” ");
INSERT INTO kma_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Die ʋ balla naa a kpatɩ wa, die ʋ nagɩ ʋ nuusisi vɔrɩtɩtɩ aŋaŋ ʋ lʋgɩŋ vɔrɩkʋ a dagɩ ba. Die ʋ kʋaŋandɩɩsɩrɩba die dɩ yene wo wo, ba sʋgɩtɩ dɩ paalɩ fɩalɩ. ");
INSERT INTO kma_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Womi Yisa die dɩ bɩ balɩ a yɩ ba dɩ, “Sʋgɩdʋagɩŋ bemme nɩ ma. N Chʋa Ŋmɩŋ dɩ tʋnna mɩŋ dene wo, die gbaŋ maŋ tʋma nɩ.” ");
INSERT INTO kma_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ʋ balɩ die ta die voosi a yi ba ma a baarɩ dɩ, “Nɩ tuo Ŋmɩŋ Halɩkasɩka. ");
INSERT INTO kma_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dɩɩ yi nɩ nagɩ vuoŋ tʋmbɩatɩ a chaa wa, ʋ seŋ ye tʋmbɩatɩ naachaala mɩŋ, ama dɩɩ yi nɩ ka nagɩ vuoŋ tʋmbɩatɩ a chaa wa, ʋ kaaŋ seŋ ye tʋmbɩatɩ naachaala.” ");
INSERT INTO kma_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ama ʋ kʋaŋandɩɩsɩrɩba baŋ aŋaŋ bale wo wʋnyɩ ba wasɩnana Tomasi, ta ba bɩ wasa wa Yiibiri die wo ba jigiŋ saŋŋa dieke Yisa dɩ kenne wo. ");
INSERT INTO kma_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Die ʋ kʋaŋandɩɩsɩrɩ banɩŋ ba dɩ bala wa dɩ, “Tɩ ye tɩ Yɔmʋtieŋ mɩŋ.” Tomasi die dɩ balɩ ba dɩ, “Dɩɩ yi maŋ ka ye yɩɩmaha vɔrɩtɩ ʋ nuusi me ta nagɩ n nuubisi a yi kʋjagɩlagɩsɩ ma ta nagɩ n nuuŋ a yi lʋgɩrɩ kʋjagɩlagɩsɩ ma, n kaaŋ yi yada.” ");
INSERT INTO kma_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ka daraa anɩɩ daraaŋ bɩbra, Yisa kʋaŋandɩɩsɩrɩba die dɩ lagɩsɩ taŋ a bie juoŋ me, Tomasi die bie ba jigiŋ saŋka gie, ta die ba bɩ kparɩ sanʋaha. Die sanʋaha die kparɩya mɩŋ ama Yisa die dɩ keŋ a zie ba sʋnsʋŋ, a baarɩ dɩ, “Sʋgɩdʋagɩŋ bemme nɩ ma, ");
INSERT INTO kma_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ta balɩ Tomasi dɩ, ‘Nagɩ fʋ nuubiŋ a nagɩ yi giena, ta daansɩ n nuusi ta nagɩ fʋ nuuŋ a yi n lʋgɩrɩ ma, ta daa bɩ chɩɩlɩ ama ta yi mɩŋ yada.’ ” ");
INSERT INTO kma_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi die dɩ yiŋŋi balɩ wa dɩ, “Fʋ yine n Yɔmʋtieŋ aŋaŋ n Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yisa die dɩ pɩasɩ wa dɩ, “Fʋ yene mɩŋ wɩa fʋ yi yada? Sʋgɩfɩalɩŋ bie vuodiekemba dɩ kana ka ye mɩŋ ta yi mɩŋ yada ma.” ");
INSERT INTO kma_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisa die yi mamachi wɩa ataŋ pam ʋ kʋaŋandɩɩsɩrɩba nine me ta ba ka maagɩha a yi gbaŋkʋ gie me. ");
INSERT INTO kma_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama wudieke ba maagɩna gbaŋkʋ gie me, ba maagɩya dɩ nɩ yi yada dɩ Yisa yine Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa, ta bɩ yi Ŋmɩŋ Bʋadembiŋ. Dɩɩ yi fʋ yi wo yada, nan dɩ yaa miivoli ʋ saaŋ ma. ");
INSERT INTO kma_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Genke kʋaŋ chaaŋ Yisa die dɩ bɩ nyɩŋ ʋ kʋaŋandɩɩsɩrɩba jigiŋ, gbagɩkpɩɩŋ dieke ba wasɩnana Taberisi ma. Naa die ʋ nagɩna ʋ gbaŋ a dagɩ ba: ");
INSERT INTO kma_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Die Simoni Piita aŋaŋ Tomasi (vuodieke die ba bɩna wasa Yiibiri) aŋaŋ Nataniali, (vuodieke dɩ nyɩnna Keenani dieke dɩ benne Galili tɩŋgbaŋ ma wa), aŋaŋ Zebedi ballɩlɩ, aŋaŋ Yisa kʋaŋandɩɩsɩrɩŋ bale bataŋ, die lagɩsɩna. ");
INSERT INTO kma_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Womi Simoni Piita dɩ balɩ a yɩ ba dɩ, “N gara zaasɩŋ yigiŋ.” Die ba balɩ wa dɩ, “Tɩ nan ga aŋaŋ fʋ.” Die wɩa die ba juu haarɩŋ, ama kanɩŋ yuku mi die ba ka yigi jaaŋ mana. ");
INSERT INTO kma_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ka sʋkʋleeliŋ Yisa die dɩ keŋ zie gbagɩrɩ nʋaŋ ama ʋ kʋaŋandɩɩsɩrɩba die ka mɩŋŋɩya dɩ dɩ yiwo wʋnɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Die ʋ wa ba dɩ, “N zʋamba, nɩ ka yigi zaasɩŋ?” Ta ba yiŋŋi balɩ wa, wa. ");
INSERT INTO kma_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Die ʋ baarɩ dɩ, “Nɩ nagɩ nɩ nɩɩkʋ a taaŋ haarɩkʋ nuudiigiŋ chaaŋ, ta nɩ nan yigi ataŋ.” Die wɩa die ba nagɩ nɩɩkʋ a taaŋ, ta die ka bɩagɩ a datɩ ka a keŋ jʋalɩ, dama die ka faasɩ yigi wo zaasɩŋ pam. ");
INSERT INTO kma_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yisa kʋaŋandɩɩsɩrʋ dieke ʋ faasɩna cho wo dɩ balɩ a yɩ Piita dɩ, “Dɩ yiwo tɩ Yɔmʋtieŋ wo.” Die Simoni Piita dɩ wʋnna dɩ dɩ yiwo tɩ Yɔmʋtieŋ wo, ʋ nagɩ ʋ jayeekiŋ a yeegi (dama die ʋ wuuri wo ʋ nyinti mɩŋ) ta die yugi a sʋʋŋ nyaabʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Die kʋaŋandɩɩsɩrɩ banɩŋ ba die dɩ dɔŋ haarɩkʋ a keŋ gbagɩrɩ nʋaŋ ta haarɩkʋ dɩ data nɩɩkʋ dɩ suuline aŋaŋ zaasɩbʋ, dama die ba ka yʋa aŋaŋ gaaŋ, ba aŋaŋ gaaŋ die yiwo sɩba naŋ magɩsa kɔbɩga. ");
INSERT INTO kma_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Die ba tʋgɩna gaarɩ die ba ye paanʋ aŋaŋ bolikaala, ta zaasɩŋ dɩ diisi bolikaalaha ma. ");
INSERT INTO kma_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Womi Yisa die dɩ balɩ ba dɩ, “Nɩ yaa zaasɩ dieke nɩ yigine wo ataŋ a keŋ.” ");
INSERT INTO kma_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Die wɩa, Simoni Piita die dɩ juu haarɩkʋ a datɩ nɩɩkʋ a keŋ jʋalɩ gaaŋ, ka suuli aŋaŋ zaasɩkpɩɩma; die ba bɩɩsɩ ha a yi nyinti kɔbɩga aŋaŋ baŋɩsɩ-nʋ aŋaŋ ataa. Aŋaŋ die a dala wa mana, ama nɩɩkʋ die ka chɩɩrɩya. ");
INSERT INTO kma_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yisa die dɩ balɩ a yɩ ba dɩ, “Nɩ keŋ a ŋɔbɩ.” Ama ʋ kʋaŋandɩɩsɩrɩba wʋnyɩ gbaŋ die wo sikimiŋ dɩ ʋ pɩasɩ wa dɩ, “Mɩnɩa yine fʋ?” Dama die ba sɩba dɩ dɩ yiwo tɩ Yɔmʋtieŋ wo. ");
INSERT INTO kma_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Die wɩa die Yisa die dɩ nagɩ paanʋkʋ a nagɩ yɩ ba, ta bɩ nagɩ zaasɩbʋ dɩaŋ a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Naa die yiwo bʋtaa ma Yisa dɩ nyɩnna ʋ kʋaŋandɩɩsɩrɩba jigiŋ ʋ kumbu hagɩŋ kʋaŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Die ba dine a kpatɩ kʋaŋ chaaŋ, Yisa die dɩ pɩasɩ Simoni Piita dɩ, “Simoni, fʋnɩŋ Jɔɔn bʋa, fʋ cho mɩŋ mɩŋ a tɩaŋ nyinti gie mana?” Die ʋ yiŋŋi baarɩ dɩ, “Wa, n Yɔmʋtieŋ, sɩba a baarɩ n cho fʋ mɩŋ.” Yisa dɩ balɩ wa dɩ, “Die nɩŋ daansɩma n yiipɔlaha.” ");
INSERT INTO kma_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yisa die dɩ bɩ pɩasɩ wa bule me dɩ, “Simoni, fʋnɩŋ Jɔɔn bʋa, cho mɩŋ mɩŋ?” Ʋ yiŋŋi baarɩ dɩ, “Wa, n Yɔmʋtieŋ sɩba dɩ n cho fʋ mɩŋ.” Yisa dɩ balɩ a yɩ wa dɩ, “Daansɩma n yiise.” ");
INSERT INTO kma_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yisa die dɩ pɩasɩ wa ka bʋtaa ma dɩ, “Simoni, fʋnɩŋ Jɔɔn bʋa, cho mɩŋ mɩŋ?” Ta Piita sʋŋ dɩ chʋʋsɩ, dama Yisa die pɩasɩ wa mɩŋ bʋtaa ma dɩ, “Cho mɩŋ mɩŋ.” Die ʋ yiŋŋi balɩ wa dɩ, “N Yɔmʋtieŋ, sɩba wɩɩŋ mana mɩŋ, ta bɩ sɩba dɩ n cho fʋ mɩŋ.” Yisa die dɩ balɩ yɩ wa dɩ, “Daansɩma n yiise. ");
INSERT INTO kma_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wusie maŋ bala fʋ: Die fʋ yine dalʋakɩrɩ, die aŋ bɔba fʋ gbanɩŋ mɩŋ a gara jigidieke mana fʋ yaalɩnana, ama fʋ keŋ kʋrɩŋ, nan tɩɩrɩ fʋ nuusi aŋ vuogaaŋ bɔbɩ fʋ fʋ gbanɩŋ ta yaa fʋ ga jigidieke fʋ kana ka yaala dɩ fʋ ga.” ");
INSERT INTO kma_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yisa die balɩ wa naa, a dagɩ Piita dɩ bala ʋ kpi kuŋ dieke ta vaa Ŋmɩŋ saaŋ ye bɩrɩŋ dene. Ka kʋaŋ chaaŋ Yisa dɩ balɩ wa dɩ, “Dɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piita die dɩ yiŋŋi a ye Yisa kʋaŋandɩɩsɩrʋ dieke ʋ faasɩna a cho wo dɩ dɩna ba. Wʋnɩŋ die ʋ kalla a gbigi Yisa wa saŋŋa dieke die ba dinene nyindiikehe, ta die pɩasɩ wa dɩ, “N Yɔmʋtieŋ, mɩnɩa bala ʋ posi fʋ chɩaka?” ");
INSERT INTO kma_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Die Piita dɩ yene wo, die ʋ pɩasɩ Yisa dɩ, “N Yɔmʋtieŋ, ta daa wa gie dɩaŋ?” ");
INSERT INTO kma_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yisa die dɩ yiŋŋi a balɩ wa dɩ, “Dɩɩ yi maŋ yaala ʋ bemme ʋ mɩsɩ ma a ga tʋgɩ saŋŋa dieke n balla n yiŋŋi keŋ wo, ka ye fʋ wo sɩa?” Fʋnɩŋ ko dɩa mɩŋ. ");
INSERT INTO kma_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Die wɩa die ka mʋʋlɩ Yisa dɩdɩɩsɩrɩba sʋŋ dɩ, wʋnɩŋ kʋaŋandɩɩsɩrʋ wa mi ka baa ʋ kpi. Ama Yisa die ka balɩ dɩ ʋ ka baa ʋ kpi; ama die ʋ baarɩ dɩ, “Dɩɩ yi maŋ yaala ʋ bemme ʋ mɩsɩ ma a ga tʋgɩ saŋŋa dieke n bala n yiŋŋi keŋ wo, ka ye fʋ sɩa?” ");
INSERT INTO kma_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wʋnɩŋ kʋaŋandɩɩsɩrʋ wa gie yine vuodieke dɩ bala wɩaha gie mana, ta bɩ maagɩha, ta tɩ sɩba dɩ wudieke ʋ balala wa yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisa die yiwo wɩa pam a gʋtɩ wudiekemba dɩ maagɩna gbaŋkʋ gie me. Dɩɩ yi ba tɩŋ maagɩ a mana a yi gbaŋtɩ ma, n yile dɩ yaalɩŋ kaaŋ dɩ bie tɩŋgbaŋka gie me a baaŋ nan juu.");
INSERT INTO kma_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","N zʋa Tiwofilusi: N bʋmbʋŋaŋ gbaŋkʋ ma die n maagɩ wa wudiekemba mana Yisa dɩ yinene ta dagɩ vuosi a nyɩŋ saŋŋa dieke die ʋ piiline ʋ tʋʋma ");
INSERT INTO kma_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","a yaa ga tʋgɩ daa dieke Ŋmɩŋ dɩ yalla wa ga arɩzanna ma. Die ʋ yene ka gaya wa die ʋ dagɩ vuodiekemba ʋ vʋarɩna a yi ʋ tʋntʋntɩba aŋaŋ Ŋmɩŋ Halɩkasɩka hagɩrɩŋ, ba baaŋ dɩ tʋma dene. ");
INSERT INTO kma_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Die ʋ kuŋ kʋaŋ chaaŋ die ʋ nagɩ daraa baŋɩsɩ-nɩɩsa a nagɩ ʋ gbaŋ daga ba, die dɩ seŋ dagɩ dɩ dɩ ka yi chɩɩla dɩ ʋ bie wo ʋ mɩsɩ ma, die ba ŋaaŋ yese wo mɩŋ, ta die ʋ balɩ ba wɩa yaa gamma Ŋmɩŋ naarɩ ma. ");
INSERT INTO kma_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Die saŋŋa kaanɩ, die ʋ dinene aŋaŋ ba wa, die ʋ yɩ ba nʋarɩ gie dɩ, “Nɩ daa keŋ a nyɩŋ Jerusalemi, ama nɩ chɩɩsɩma Halɩkasɩka dieke n Chʋa dɩ yɩna nʋaŋ dɩ ʋ nan yɩ nɩ wa, wudieke wɩa n wone a balɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jɔɔn nɩŋ die sɩɩ wa vuosi aŋaŋ nyaaŋ, ama daraa gie nʋaŋ Ŋmɩŋ Halɩkasɩka nan suuli nɩ.” ");
INSERT INTO kma_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Die Yisa tʋntʋntɩba die dɩ lagɩsɩna aŋaŋ Yisa wa, die ba pɩasɩ wa dɩ, “Tɩ Yɔmʋtieŋ, saŋka gie fʋ baa fʋ gbatɩ tɩnɩŋ Izara vuosi a nyɩŋ Romani vuosi nuusi me ta yiŋŋi a yɩ tɩ tɩ naarɩ?” ");
INSERT INTO kma_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Die Yisa dɩ balɩ ba dɩ, “Ŋmɩŋ ka yɩ nɩ sieŋ dɩ nɩ sɩmma saŋŋa aŋaŋ daa dieke wɩaha gie dɩ balla a yi, sie ʋ nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama saŋŋa dieke ʋ Halɩkasɩka dɩ baaŋ keŋ a sʋʋŋ nɩ ma wa, nɩ nan ye hagɩrɩŋ, ta nan yi n siaratieliŋ Jerusalemi ma, aŋaŋ Judia tɩŋgbaŋ mana aŋaŋ Samaria tɩŋgbaŋ mana aŋaŋ dʋnɩa ka gie lʋga mana mana ma.” ");
INSERT INTO kma_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Die ʋ bala wɩaha gie a kpatɩ wa, die ba ye Ŋmɩŋ dɩ vana ʋ jʋalɩ gara ŋmɩŋsikpeŋ, ba daansa wa, ta die nɩɩŋmara wɩa ba ka bɩ bɩagɩ a ye wo. ");
INSERT INTO kma_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Die ba ye ko a zie a daansa ŋmɩŋsikpeŋ ʋ gana wa, womi dembisi bale dɩ yeegi nyɩŋyɩala a keŋ a zie ba jigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a pɩasɩ ba dɩ, “Nɩnɩŋ Galili dembisi, bie nɩ zie giena a daansa ŋmɩŋsikpeŋ dene? Yisa wa gie dɩ nyɩna nɩ jigiŋ a jʋalɩ a ga arɩzanna naa wa, ʋ nan daansɩ a yiŋŋi a keŋ sɩba nɩ yene wo ʋ jʋalɩna a ga arɩzanna die wo.” ");
INSERT INTO kma_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Womi die Yisa tʋntʋntɩba dɩ yiŋŋi a nyɩŋ Olivi Tɩɩsɩ kunkogiri me a ga Jerusalemi. Mi aŋaŋ Jerusalemi die yiwo sɩba mali chɩbɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Die ba gana a ga juu Jerusalemi wa, die ba ga juu juodieke me ba benne wo: Vuodiekemba die dɩ benne mi die wone Piita aŋaŋ Jɔɔn aŋaŋ Jemisi aŋaŋ Andurusi aŋaŋ Filipi aŋaŋ Tomasi aŋaŋ, Batolomiwo aŋaŋ Matiwo aŋaŋ Alifusi bʋa Jemisi aŋaŋ Simoni, vuodieke die dɩ yaala banɩŋ Juu vuosi yallɩma ba gbaŋ wa aŋaŋ Judasi, Jemisi bʋa. ");
INSERT INTO kma_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Die ba ŋaaŋ lagɩma saŋŋa mana aŋaŋ hɔgʋba bataŋ aŋaŋ Yisa nuŋ Meri aŋaŋ Yisa nɩmballɩ a jʋʋsa Ŋmɩŋ aŋaŋ sʋgɩbalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Die ka daraa ale kʋaŋ chaaŋ, ta Yisa kʋaŋandɩɩsɩrɩŋ sɩba vuosi kɔbɩga aŋaŋ baŋɩsɩ-le die dɩ lagɩsɩ kalɩ, ta Piita die dɩ hagɩ a zie ba sʋŋ ");
INSERT INTO kma_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","a baarɩ dɩ, “N nɩmballɩ, sie wudieke Ŋmɩŋ Halɩkasɩka die dɩ vana Davidi dɩ maagɩ Ŋmɩŋ gbaŋkʋ ma wa yaa gamma Judasi wɩaha keŋ yi wusie. Judasi wa die yine vuodieke dɩ dagɩna vuosisi ba yigi Yisa wa. ");
INSERT INTO kma_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ama Yisa die vʋarɩna tɩnɩŋ aŋaŋ wʋnɩŋ dɩ tɩ tʋma Ŋmɩŋ tʋŋ dieke tɩ tʋnna aŋaŋ wa.” ");
INSERT INTO kma_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judasi tʋmbɩatɩ nyʋarɩ ligirehe die ʋ nagɩ a daa tɩŋgbaŋ, me gbaŋ die ʋ nan kpi, ta ʋ nyɩŋgbanɩŋ die dɩ natɩ yuori ʋ nyuubie mana die dɩ nyɩŋ a jaasɩ. ");
INSERT INTO kma_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Vuodiekemba mana die dɩ benne Jerusalemi ma die dɩ wʋŋ ka wɩa. Naa chɩaŋ ma die ba wasa mi ba wʋbalɩkɩŋ ma dɩ Akelidama, ka chɩaŋ wone “Zɩŋ tɩŋgbaŋ.”) ");
INSERT INTO kma_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Dama “Dɩ maagɩya Yɩla gbaŋ dieke dɩ benne Ŋmɩŋ gbaŋkʋ sʋŋ dɩ, ‘Vaa ʋ jigiri yi jigizetikiŋ; da vaa vuoŋ bemme ka ma.’ Dɩ bɩ a maagɩ dɩaŋ bɩbra dɩ, ‘Vaa vuogaaŋ zie ʋ nagɩsɩ ma a tʋma ʋ tʋʋmaha.’ ");
INSERT INTO kma_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Die wɩa dɩ mʋ tɩ vʋarɩ vuodiekemba die dɩ dɩna tɩnɩŋ aŋaŋ Yisa a dɩa saŋŋa mana wa wʋnyɩ ");
INSERT INTO kma_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a piili a nyɩŋ saŋŋa dieke Jɔɔn vuodieke dɩ sɩnana vuosi Ŋmɩŋ nyaabʋ a yaa ga tʋgɩ saŋŋa dieke die Yisa dɩ jʋalɩna a ga arɩzanna ta va tɩ wa, aŋ ʋ gʋtɩ tɩ ma aŋ tɩ dii Yisa kumbu hagɩŋ tʋʋma daansɩa.” ");
INSERT INTO kma_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Die wɩa die ba vʋarɩ vuosi bale; Josefu vuodieke die ba wasɩnana Baasabasi (Ta ba bɩ wasa Jusitusi), aŋaŋ Matiasi. ");
INSERT INTO kma_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Womi die ba jʋʋsɩ Ŋmɩŋ dɩ, “Tɩ Yɔmʋtieŋ, fʋnɩŋ fʋ sɩbɩna vuoŋ mana sʋŋ dɩ sɩna die, die wɩa tɩ Yɔmʋtieŋ, dagɩ tɩ vuosi bale wa gie sʋŋ fʋ vʋarɩna vuodieke ");
INSERT INTO kma_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","dɩ ʋ yi tʋntʋntʋ a zie jigidieke Judasi dɩ vana ta ga jigidieke dɩ mʋna dɩ ʋ bemme wo.” ");
INSERT INTO kma_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Die ba jʋʋsɩna Ŋmɩŋ a kpatɩ wa, die ba yi chaachaa dɩ ba vʋarɩ saara ale wo kaanɩ, die chaachaaka dɩ ga nan Matiasi ma, die ba nagɩ wa gʋtɩ Yisa tʋntʋntɩba baŋ aŋaŋ kaanɩ wa ma. ");
INSERT INTO kma_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Die dʋʋga dieke ba wasɩnana Pentikosi wa dɩ tʋgɩna Yisa kʋaŋandɩɩsɩrɩŋ mana die dɩ lagɩsɩ taŋ jigibalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Womi die watɩ dɩ nyɩŋ ŋmɩŋsikpeŋ a dɔma sɩba bʋlɔgɩsɩ kpeŋkpɩɩŋ dɩ nɩgɩnana ta die keŋ suuli juodieke ba kala wa mana. ");
INSERT INTO kma_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ta die ba ye jaaŋ sɩba bolinyaatɩ dɩ nyɩna a keŋ a kalɩ ba wʋnyɩ mana sikpeŋ me, ");
INSERT INTO kma_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ta die Ŋmɩŋ Halɩkasɩka die dɩ suuli ba mana, die ba piili a bala wʋbalɩkɩ gaasɩ diekemba ba kana ka wʋma sɩba Ŋmɩŋ Halɩkasɩka dɩ dagɩna ba dene. ");
INSERT INTO kma_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Die Juu vuosi die dɩ dɩna Ŋmɩŋ die dɩ bie Jerusalemi saŋka mi, die ba nyɩŋ wa tɩgɩsɩ mana dʋnɩa ma a keŋ mi. ");
INSERT INTO kma_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Die ba wʋnna watɩ gie die wo, die kpɩkpaaŋ dɩ lagɩsɩ mi, die dɩ yi ba mana mamachi dama die Yisa kʋaŋandɩɩsɩrɩba die bala wʋbalɩkɩ gaasɩ, ba wʋnyɩ mana dɩ wʋmma ʋ jabalɩkɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Die dɩ yi be mamachi pam die ba pɩasɩ taŋ dɩ, “Vuosisi gie dɩ balala naa, ntaa ba mana yiwo Galili vuosi? ");
INSERT INTO kma_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ta bɩa yine tɩ wʋnyɩ mana dɩ wʋmma ba ʋ gbaŋ gbaŋ ʋ wʋbalɩka ma? ");
INSERT INTO kma_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tɩ bataŋ nyɩŋ wa Patia aŋaŋ Midia aŋaŋ Elami aŋaŋ Mesopotamia aŋaŋ Judia aŋaŋ Kapadosia aŋaŋ Pontusi aŋaŋ Asia, ");
INSERT INTO kma_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","aŋaŋ Firigia, aŋaŋ Pamifilia aŋaŋ Ijipiti aŋaŋ Libia chaakʋ tɩgɩsɩ dɩ gbigine Sayireni; ta tɩ bataŋ dɩaŋ dɩ nyɩŋ Romi, ");
INSERT INTO kma_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ta tɩ bataŋ Juu vuosi, ta bataŋ dɩaŋ dɩ yi buurigaasɩ diekemba dɩ tarɩgɩna ba jɩamɩŋ ta dɩ Juu vuosi Ŋmɩŋ, ta tɩ bataŋ dɩaŋ dɩ nyɩŋ Kireeti aŋaŋ Arabia, ama tɩ mana wʋmma ba balala tɩ gbaŋ gbaŋ tɩ jabalɩkɩŋ ma, ta bɩra Ŋmɩŋ yaa gamma mamachi wʋkpɩɩma ʋ yine.” ");
INSERT INTO kma_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Die dɩ yi be mamachi pam die ba ko pɩasa taŋ dɩ, “Wɩɩrɩ gie chɩaŋ yiwo bɩa?” ");
INSERT INTO kma_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama ta bataŋ die dɩ laa ba ta vʋarɩ ba fala a baarɩ dɩ, “Ba nyuu wo daaŋ a bugi.” ");
INSERT INTO kma_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Womi Piita die dɩ hagɩ ʋ chanchaalɩba baŋ aŋaŋ kaanɩ wa sʋnsʋŋ a zie kpɩkpaakʋ nɩŋŋa; ta die a balɩ aŋaŋ lɔlɩkpɩɩŋ a yɩa kpɩkpaakʋ dɩ, “N chanchaalɩŋ Juu vuosi aŋaŋ nɩ vuodiekemba mana dɩ benne Jerusalemi, nɩ wʋmma mɩŋ ta vaa n bala nɩ wɩɩrɩ gie chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nɩ yile dɩ vuosi gie bugiye mɩŋ, ama ba ka bugiye, dama dɩ ye yiwo sʋkʋʋŋ hawasɩ awayɩ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ama wudieke nɩ yene wo yiwo wudieke Ŋmɩŋ naazʋa Joweli die dɩ balɩ dɩ ka nan keŋ yi, dɩ, ");
INSERT INTO kma_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ŋmɩŋ baarɩ dɩ; Dʋnɩa kpatɩŋ saŋŋa, naa maŋ nan yi: n nan daansɩ vaa n Haalɩbʋ sʋʋŋ vuoŋ mana ma; ta nɩ dembibisi aŋaŋ nɩ hɔgʋlɩasɩ nan bʋgɩ balɩ manɩŋ Ŋmɩŋ wʋbalɩka, ta nɩ nahaalɩŋ aŋaŋ daa nyɩŋkʋra nan sɩba wusie yaa gamma Ŋmɩŋ wɩa ba daansa ma. ");
INSERT INTO kma_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Saŋka mi n nan tʋŋ n Haalɩbʋ vuodiekemba dɩ tʋnnana wudieke n yaalala ma, dembisi aŋaŋ hɔgʋba mana, ta ba gbaŋ nan daansɩ bʋgɩ balɩ n wʋbalɩkaha. ");
INSERT INTO kma_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","N nan keŋ tʋŋ tʋnkpɩɩma ŋmɩŋsikpeŋ aŋaŋ mamachi dagɩtɩ tɩŋgbaŋka gie me, ta zɩŋ aŋaŋ boliŋ aŋaŋ nyusi nan daansɩ beri, ");
INSERT INTO kma_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","saŋka mi Ŋmɩŋ nan sɩbɩ, ta chɩɩkʋ dɩaŋ nan tarɩgɩ a ŋmɩntɩ sɩba zɩŋ, naa nan yi ta tɩ Yɔmʋtieŋ ye yiŋŋi keŋ tɩŋgbaŋka gie me a dii vuosi sarɩya; ta ʋ yiŋŋi keniŋ daraaŋ nan yi daakpeŋkpɩɩŋ; ");
INSERT INTO kma_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ta vuodieke mana dɩ keŋ jʋʋsɩ wa ʋ saaŋ ma nan ye gbatɩtaanɩŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Die Piita dɩ bɩ baarɩ dɩ, “Nɩnɩŋ Izara vuosi, nɩ wʋmma wudieke n yaala n balɩ nɩ yaa gamma Yisa vuodieke dɩ yine Nazeriti vuoke wɩa; nɩ gbaŋ gbaŋ nɩ sɩba a baarɩ Ŋmɩŋ die vana die ʋ tʋma mamachi tʋnkpɩɩma aŋaŋ dagɩtɩ mi nɩ jigiŋ, ta a dagɩ sɩba Ŋmɩŋ die tʋnna wa. ");
INSERT INTO kma_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ama Ŋmɩŋ gbaŋ gbaŋ die sɩba wudieke dɩ bala ka yi, ta die a saŋ a nagɩ Yisa a yɩ nɩ nuusi me, ta yi nɩ vuobɩatɩ dɩ kpaasɩ wa a dɩɩsɩ dagarɩkʋ ma a kʋʋ wa, ka dagɩ sɩba nɩnɩŋ nɩ senne kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama die ʋ kpine wo ta ye bie kuŋ nuusi me wo, ta Ŋmɩŋ die dɩ gbatɩ wa a nyɩŋ kuŋ nuusi me, dama kuŋ die wo hagɩrɩŋ dɩ ka pɔgɩlɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dama Davidi die balɩ wɩa yaa gamma ʋ ma dɩ, ‘N sɩba a baarɩ dɩ n Yɔmʋtieŋ Ŋmɩŋ beri aŋaŋ mɩŋ saŋŋa mana, ta bɩ zie n kʋaŋ ta suŋŋe mɩŋ amʋ n kaaŋ ye daŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Naa chɩaŋ ma n yaa sʋgɩfɩalɩŋ ta bala sʋgɩfɩalɩ wʋbalɩka. Maŋ keŋ kpi gbaŋ, ama n nan dɩ yaa tama Ŋmɩŋ dɩ balla ʋ yi wudieke a yɩ mɩŋ wɩa, ");
INSERT INTO kma_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","dama ʋ kaaŋ vaa n haalɩbʋ wɩarɩ kpiiliŋ tigiŋ. N yiwo ʋ vuovʋarɩkɩŋ, ta ʋ kaaŋ saagɩ aŋ n nyɩŋgbanɩŋ keŋ hʋʋgɩ vɔrɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ta bɩ dagɩ mɩŋ miivoli sieti, ta fʋ benne n jigiri dɩaŋ dɩ yɩa mɩŋ sʋgɩfɩalɩŋ pam.’ ” ");
INSERT INTO kma_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ta Piita dɩ bɩ balɩ dɩ, “N nɩmballɩ, n baa n balɩ yuori nɩ mɩŋ, yaa gamma tɩ chɔɔŋkʋʋŋ Davidi wɩa. Die ʋ kpiye mɩŋ ba guu wo, ta ʋ vɔrɩŋ dɩ ye bie giena a keŋ tʋgɩ jinne. ");
INSERT INTO kma_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Die ʋ yiwo Ŋmɩŋ naazʋa, ta die sɩba dɩ Ŋmɩŋ yɩ wa nʋaŋ dɩ, dɩɩ yi ʋ kpi, ʋ nan daansɩ vʋarɩ ʋ haagɩsɩ wʋnyɩ aŋ ʋ kala ʋ naagbaŋtɩ ma. ");
INSERT INTO kma_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidi die sɩba wudieke Ŋmɩŋ die dɩ balla ʋ yi, ta die balɩ wɩa yaa gamma Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa kuŋ hagɩŋ wɩa, dɩ: ‘Ŋmɩŋ Vuovʋarɩkɩrɩ kaaŋ daansɩ wɩarɩ kpiiliŋ tigiŋ; ta ʋ nyɩŋgbanɩŋ dɩaŋ kaaŋ hʋʋgɩ vɔrɩŋ ma.’ ” ");
INSERT INTO kma_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ta Piita dɩ bɩ baarɩ dɩ, “Yisa wa gie Ŋmɩŋ die dɩ va ʋ hagɩ kuŋ me, ta tɩ mana dɩ yi ʋ kumbu hagɩŋ daansɩatieliŋ. ");
INSERT INTO kma_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta Ŋmɩŋ dɩ bɩ kɔtɩ wa ʋ jʋalɩ kalɩ ʋ nuudiigiŋ chaaŋ, ʋ kala wa Ŋmɩŋ dɩ yɩ wa ʋ Halɩkasɩka die ʋ yɩna nʋaŋ dɩ ʋ nan yɩ tɩ wa ʋ vaa bʋ keŋ sʋʋŋ tɩ ma. Lele dɩ yiwo Halɩkasɩka nɩ yese ta wʋmma tɩ jigiŋ dene. ");
INSERT INTO kma_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Die Davidi dɩ kpine wo, die ʋ ka jʋalɩ ga arɩzanna ma aŋaŋ nyɩŋgbanɩŋ: ama ta die ʋ baarɩ dɩ; ‘Tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ balɩ a yɩ n Yɔmʋtieŋ dɩ: Kala n nuudiigiŋ chaaŋ ");
INSERT INTO kma_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","a ga tʋgɩ saŋŋa dieke n baaŋ nagɩ fʋ dataasɩ a yi fʋ nuusi me.’ ");
INSERT INTO kma_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Die wɩa dɩ vɩɩna ta nɩnɩŋ Izara vuosi mana sɩmma dɩ Yisa wa gie, die nɩ vana ba kpaasɩ dagarɩkʋ ma wa, wʋnɩŋ ta Nabidie Ŋmɩŋ dɩ dagɩ dɩ wʋnɩŋ ʋ yine Vuovʋarɩkɩŋ Masia wa, ta bɩ yi tɩ Yɔmʋtieŋ.” ");
INSERT INTO kma_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Die vuosi gie dɩ wʋnna naa wa die ba sʋgɩtɩ dɩ faasɩ chʋʋsɩ pam. Die wɩa ba pɩasɩ Piita aŋaŋ ʋ chanchaalɩba dɩ, “Tɩ nɩmballɩ, bɩa tɩ baa tɩ yi?” ");
INSERT INTO kma_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piita die dɩ balɩ a yɩ ba dɩ, “Sie nɩ mana vaa nɩ tʋmbɩatɩ, aŋ tɩ sɩɩ nɩ Ŋmɩŋ nyaabʋ Yisa Masia saaŋ ma, amʋ Ŋmɩŋ nagɩ nɩ tʋmbɩatɩ a chaa nɩ, ta ʋ yɩ nɩ ʋ piini dieke dɩ yine Ŋmɩŋ Halɩkasɩka. ");
INSERT INTO kma_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dama Ŋmɩŋ die yɩ nʋaŋ dɩ ʋ nan nagɩ ʋ Halɩkasɩ a yɩ nɩnɩŋ aŋaŋ nɩ ballɩ, aŋaŋ vuodiekemba dɩ benne saasaa, aŋaŋ vuodiekemba mana tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ dɩ baaŋ wa aŋ ba tuo ʋ nʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ka kʋaŋ chaaŋ, Piita die dɩ balɩ ba wɩa pam ta kpaaŋ ba aŋaŋ nɩŋŋmɩna dɩ, “Nɩ vʋarɩ nɩ gbaŋ a nyɩŋ Ŋmɩŋ tɩbɩdatɩ dieke dɩ kienene lele gie vuobɩatɩ gie ma wa.” ");
INSERT INTO kma_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Die ba pam die dɩ tuo Piita wʋbalɩkaha a dii, die ba yiwo sɩba vuosi tuse ataa, ta ba sɩɩ ba Ŋmɩŋ nyaabʋ, ta ba gʋtɩ ba ma. ");
INSERT INTO kma_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Die saŋŋa mana ba ŋaaŋ bʋgɩra a nyɩna tʋntʋntɩba jigiŋ, ta die a lagɩma a pɔgɩla taŋ aŋaŋ nʋabalɩmɩŋ, ta lagɩma die nyindiike, ta bɩ lagɩma a jʋʋsa Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ta ŋmaamɩŋ die dɩ yallɩ vuoŋ mana; tʋntʋntɩba die dɩ yi mamachi tʋnkpɩɩma pam aŋaŋ Ŋmɩŋ hagɩrɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Die Yisa kʋaŋanvuosi mana die dɩ pɔgɩlɩ taŋ aŋaŋ nʋabalɩmɩŋ ta tɩa ba nyinti a yɩa taŋ. ");
INSERT INTO kma_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta die a naga ba faarɩ a daa a naga ligirehe a tɩa a yɩa taŋ, dɩ mʋna vuoŋ mana tuo die. ");
INSERT INTO kma_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Daaŋ mana ba ko lagɩma taŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a jɩama Ŋmɩŋ ama ba nyɩŋ mi, ba ŋaaŋ gara taŋ tige a lagɩŋ die nyindiike aŋaŋ sʋgɩfɩalɩŋ aŋaŋ sʋgɩyɩalɩŋ aŋaŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ta saŋŋa mana ba ŋaaŋ bɩra Ŋmɩŋ, ta vuoŋ mana die dɩ yallɩ sʋgɩfɩalɩŋ aŋaŋ ba. Ta daaŋ mana tɩ Yɔmʋtieŋ ŋaaŋ vasa vuosi dɩ yese gbatɩtaanɩŋ ta gʋta ba ma. ");
INSERT INTO kma_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Daaŋ kaanɩ Piita aŋaŋ Jɔɔn die dɩ gara Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma, Ŋmɩŋ jʋʋsɩŋ saŋŋa, agbaa kʋaŋ chaaŋ hawasɩ ataa saŋŋa die wonde. ");
INSERT INTO kma_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Womi sanʋarɩ tɩŋ, sanʋaŋ dieke die ba wasɩnana “Sanʋavɩɩka” daa wʋnyɩ die dɩ yine gbarɩgɩŋ ʋ mɩsɩ mana ma ma die dɩ kalɩ mi. Daaŋ mana die ba ŋaaŋ chii wo mɩŋ a keŋ kalɩŋ sanʋarɩ gie tɩŋ ʋ dɩ jʋʋsa vuodiekemba dɩ juunene Ŋmɩŋ juoku me ligire. ");
INSERT INTO kma_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Die ʋ yene Piita aŋaŋ Jɔɔn dɩ balla ba juu wo, ʋ jʋʋsɩ ba ligire. ");
INSERT INTO kma_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Die ba mana dɩ yiŋŋi a daansɩ wa die, womi Piita die dɩ baarɩ dɩ, “Daansɩma tɩ.” ");
INSERT INTO kma_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Die wɩa die ʋ daansa ba ta yaa tama sɩba ʋ nan ye jaaŋ a nyɩŋ ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ama Piita die dɩ balɩ a yɩ wa dɩ, “Tɩ wo ligire, ama tɩ nan yɩ fʋ jadieke tɩ yalla. Manɩŋ n yɩ fʋ nʋaŋ Yisa Masia vuodieke dɩ yine Nazeriti vuoke saaŋ ma, hagɩ chʋŋ” ");
INSERT INTO kma_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ta yigi ʋ nuudiigiŋ me a suŋŋi wo ʋ hagɩ zie. Lele womi daa wa nagɩsɩ aŋaŋ ʋ naachɩgɩsa dɩ ye hagɩrɩŋ; ");
INSERT INTO kma_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ʋ hagɩ a yʋgɩ a zie ʋ nagɩsɩ ma a dɩ dɩa a chʋŋ chʋŋ. Womi die ʋ dɩ ba kʋaŋ a juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a chʋŋ ta yʋga a bɩra Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Die vuosi mana dɩ yene wo ʋ chʋnnana ta bɩra Ŋmɩnnɩ, ");
INSERT INTO kma_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","die ba mɩŋŋɩ wa dɩ vuodieke dɩ ŋaana kala Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sanʋarɩ tɩka jigidieke ba wasɩnana “Sanʋavɩɩka ” a jʋʋsa wa wonde, die dɩ yi be mamachi aŋaŋ ŋmaamɩŋ aŋaŋ wudieke dɩ yine a yɩ wa wa. ");
INSERT INTO kma_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Die daa wa die dɩ goori Piita aŋaŋ Jɔɔn a yallɩ, die dɩ yi vuosi mana mamachi ba chɩgɩ ga ba jigiŋ, jigidieke die ba wasɩnana “Solomoni Lɩɩfaaŋ” wa. ");
INSERT INTO kma_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piita die dɩ yene vuosisi ʋ pɩasɩ ba dɩ, “Nɩnɩŋ Izara vuosi, bɩa wɩɩrɩ gie dɩ yi nɩ mamachi? Ta bɩa nɩ daansa tɩ sɩba dɩ yiwo tɩ gbaŋ gbaŋ tɩ hagɩrɩŋ yaa tɩ wʋvɩɩna wɩa tɩ yi daa wa gie dɩ chʋŋ? ");
INSERT INTO kma_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nabidie Ŋmɩŋ, vuodieke die Abarahami aŋaŋ Aziki aŋaŋ Jakobu die dɩ jɩanna wa, ta bɩ yi Ŋmɩŋ dieke tɩ chʋalɩba die dɩ jɩanna wa, wʋnɩŋ ʋ kɔtɩna ʋ Tʋntʋntʋ Yisa ŋmɩŋsikpeŋ aŋaŋ ʋ gbaŋ gbaŋ hagɩrɩŋ. Wʋnɩŋ die nɩ nagɩ a yɩ tɩ nyɩŋkʋraha nuusi me, ta zeti wo Paliti nɩŋŋa saŋŋa dieke Paliti die dɩ yaalala dɩ ʋ vaa ʋ ga yɔrɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Die ʋ yiwo Ŋmɩŋ vuoŋ ta bɩ yi vuovɩɩnɩŋ ama die nɩ zeti wo mɩŋ ta balɩ Paliti dɩ ʋ vʋarɩ vuokʋʋrʋ wa a yɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Die wɩa, nɩnɩŋ die nɩ yine ba kʋʋ Miivoliyɩɩrʋ wa; ama Ŋmɩŋ die dɩ vaa ʋ hagɩ kuŋ me, ta tɩnɩŋ tɩ yine wɩɩrɩ gie daansɩatieliŋ. ");
INSERT INTO kma_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dɩ yiwo Yisa wa saarɩ yiko tɩ wa dɩ yi daa wa gbaamɩŋ. Gbarɩgɩrɩ gie yiwo vuodieke nɩ wone sɩba ta bɩ yese wo, ama ʋ keŋ ye gbaamɩŋ, dama ʋ yine Yisa saaŋ yada wa wɩa. Ʋ yine Yisa saaŋ yada wɩa ʋ ye gbaamɩŋ ta zie nɩ mana nɩŋŋa naa. ");
INSERT INTO kma_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Lele n nɩmballɩ, n sɩba a baarɩ wudieke nɩnɩŋ aŋaŋ nɩ nyɩŋkʋraha dɩ yine ba kʋʋ Yisa wa, die nɩ ka sɩba wudieke die nɩ yinene chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ama Ŋmɩŋ die wɔŋ balɩ ʋ wɩɩrɩ a yɩ ʋ naazʋalɩba, ta ba gbaŋ die dɩ balɩ a yɩ vuosi dɩ sie ʋ Vuovʋarɩkɩrɩ Masia wa dii wahala. Die ʋ vaa ka seŋ yi wusie sɩba nɩ yine die wo. ");
INSERT INTO kma_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Die wɩa nɩ vaa nɩ tʋntʋmbɩatɩ ta yiŋŋi a keŋ Ŋmɩŋ jigiŋ amʋ ʋ nagɩ nɩ tʋmbɩatɩ a chaa nɩ, ");
INSERT INTO kma_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ta ʋ nan bɩ yɩ nɩ haalɩtɩ voosiŋ, ta bɩ tʋŋ Yisa Masia nɩ jigiŋ, vuodieke ʋ wone a vʋarɩ wa a yɩ nɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ama sie Yisa wa wɩarɩ arɩzanna ma a ga tʋgɩ saŋŋa dieke Ŋmɩŋ dɩ bala ʋ wʋnsɩ jaaŋ mana sɩba die ʋ vana ʋ naazʋalɩkasɩ mba die dɩ benne kʋrɩŋ ma wa dɩ balɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Die gbaŋ Mosisi dɩ baarɩ dɩ, ‘Tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ nan daansɩ yɩ nɩ naazʋa sɩba ʋ tʋnna mɩŋ naa, ta ʋ nan yi nɩ gbaŋ gbaŋ nɩ vuoŋ. Nɩnɩŋ nɩ mʋ nɩ wʋmma wudieke mana ʋ balala nɩ. ");
INSERT INTO kma_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Vuodieke mana dɩ kana ka wʋmma wudieke mana wʋnɩŋ naazʋa wa mi dɩ balala, Ŋmɩŋ nan vʋarɩ die vuoke a nyɩŋ ʋ vuosi me ta chʋʋsɩ wa.’ ");
INSERT INTO kma_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ta Ŋmɩŋ naazʋalɩŋ banɩŋ ba aŋaŋ naazʋa Samuli aŋaŋ vuodiekemba die dɩ kenne ʋ kʋaŋ chaatɩ ta die bala Ŋmɩŋ wɩaha die wɔŋ balɩ wudieke dɩ yinene daarɩ gie nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ŋmɩŋ nʋa diekemba die ʋ yɩna ʋ naazʋalɩba, yiwo nɩ sɩɩtɩ, a bɩ gʋtɩ, nʋa dieke Ŋmɩŋ dɩ yɩna nɩ chɔɔŋkʋʋlɩba gbaŋ yiwo nɩ sɩɩtɩ. Dama die ʋ balɩ wa Abarahami dɩ, ‘Fʋ haagɩŋ wʋnyɩ ma, maŋ nan daagɩ a yi alibarika yɩ tɩŋgbaŋka gie vuosi mana.’ ");
INSERT INTO kma_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Die wɩa Ŋmɩŋ dɩ vʋarɩ ʋ Tʋntʋntʋ Masia wa ta woliŋ tʋŋ wa nɩ jigiŋ, dɩ ʋ vaa nɩ chɩgɩ a nyɩŋ nɩ tʋntʋmbɩatɩ ma ta ye alibarika ka.” ");
INSERT INTO kma_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Die Piita aŋaŋ Jɔɔn die dɩ yene ko bala wɩa a yɩa vuosisi, die Ŋmɩŋ kɩkaabɩtɩba aŋaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sojasisi jakʋʋŋ aŋaŋ Sadusisi vuosi dɩ keŋ ba jigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","dama die ba jɩɩ wa sɩnyɩɩrɩŋ a yɩ Piita aŋaŋ Jɔɔn, dɩ ba dagɩnana vuosisi dɩ Yisa die hagɩ kuŋ me wɩa, ka dagɩ sɩba kunti nan daansɩ hagɩ kuŋ me. ");
INSERT INTO kma_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Die wɩa die ba yigi be a nagɩ ba a yi dansarɩka sʋŋ dɩ tʋŋ vʋŋ, dama yuŋ die wɔŋ a sibe mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ama daadaŋ diekemba die dɩ wʋnna Piita aŋaŋ Jɔɔn balɩkʋ die dɩ yi Yisa yada ta yi Yisa kʋaŋandɩɩsɩrɩŋ. Ta vuodiekemba die dɩ dɩna Yisa dɩ yi sɩba vuosi tuse anʋ. ");
INSERT INTO kma_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tʋŋ die dɩ vʋnna, Juu vuosi nɩŋŋandɩɩsɩrɩba aŋaŋ ba nyɩŋkʋra aŋaŋ mɩraha dɩdagɩrɩba die dɩ lagɩŋ taŋ ba lagɩmɩŋ jigiŋ Jerusalemi ma, ");
INSERT INTO kma_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","die ba lagɩŋ aŋaŋ Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ Anasi aŋaŋ Kayafasi aŋaŋ Jɔɔn aŋaŋ Alekizanda aŋaŋ Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ tigiŋ vuosi bataŋ. ");
INSERT INTO kma_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Die ba yi Piita aŋaŋ Jɔɔn dɩ keŋ zie ba sʋnsʋŋ ta ba pɩasa ba dɩ, “Bɩa hagɩrɩŋ nɩ yallɩ, ta mɩnɩa saaŋ ma nɩ yie wɩaha gie?” ");
INSERT INTO kma_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Womi Ŋmɩŋ Halɩkasɩka die dɩ hagɩ Piita ma ʋ yiŋŋi a balɩ ba dɩ “Nɩnɩŋ nɩŋŋandɩɩsɩrɩŋ aŋaŋ nyɩŋkʋra, ");
INSERT INTO kma_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","dɩɩ yi nɩ pɩasa tɩ jinne yaa gamma wʋvɩɩŋ dieke tɩ yine a yɩ gbarɩgɩrɩ gie aŋaŋ ʋ yene gbaamɩŋ dene, ");
INSERT INTO kma_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","die nɩŋ, nɩ mana aŋaŋ Izara vuosi mana sɩmma dɩ dɩ yiwo Nazeriti vuoke Yisa Masia saaŋ ma ta daa wa gie dɩ ye gbaamɩŋ ta zie nɩ nɩŋŋa naa. Yisa wo mi die nɩ yi ba kpaasɩ wa dagarɩkʋ ma a kʋʋ wa wa ama ta Ŋmɩŋ dɩ vaa ʋ hagɩ kumbu me wo. ");
INSERT INTO kma_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wʋnɩŋ ʋ yine vuodieke Ŋmɩŋ gbaŋkʋ dɩ balɩ ʋ wɩaha dɩ ‘Taŋ dieke nɩnɩŋ mɩmɩɩrɩba dɩ zetine wo yiŋŋine a keŋ bɩrɩŋ gɔŋgɔŋyʋgɩrɩŋ taŋ vɩɩnɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ta vuoŋ saaŋ bɩ wori tɩŋgbaŋka gie me ta Ŋmɩŋ dɩ yɩ vuosi dɩ tɩ ye gbatɩtaanɩŋ, sie Yisa nyɩɩna ma.” ");
INSERT INTO kma_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Die lagɩŋkʋ vuosi dɩ yene Piita aŋaŋ Jɔɔn dɩ dine dembisi dene wo, ta die ba bɩ mɩŋŋɩ dɩ Piita aŋaŋ Jɔɔn die yiwo vuodiekemba dɩ kana ka sɩba gbanɩŋ die dɩ yi be mamachi, ba mɩŋŋɩ dɩ die banɩŋ aŋaŋ Yisa die benne. ");
INSERT INTO kma_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ama die ba yene daa dieke die dɩ yene gbaaŋkʋ dɩ ziene Piita aŋaŋ Jɔɔn jigiri die ba ka bɩagɩ balɩ wɩɩŋ a chʋʋsɩ ba. ");
INSERT INTO kma_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Die wɩa die ba vaa ba ye nyɩŋ lagɩŋkʋ jigiŋ, ta ba wa ye taŋ, ");
INSERT INTO kma_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ta pɩasa taŋ dɩ, “Bɩa tɩ nan yi dembisi gie? Dama vuodieke mana dɩ benne Jerusalemi ma sɩba mamachi wudieke ba yine, ta tɩ kaaŋ bɩagɩ chiisike. ");
INSERT INTO kma_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama nɩ vaa aŋ tɩ kpaaŋ ba dɩ ba daa bɩ wa Yisa saaŋ a yɩ vuoŋ, amʋ vuosi kaaŋ wʋŋ Yisa wɩɩrɩ gie.” ");
INSERT INTO kma_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Die wɩa die ba bɩ wa ba a keŋ juu a balɩ ba dɩ “Nɩ sɩmma nɩ bɩ nagɩ Yisa saaŋ a balɩ yaa dagɩ vuoŋ bɩbra.” ");
INSERT INTO kma_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama Piita aŋaŋ Jɔɔn die dɩ yiŋŋi a balɩ ba dɩ, “Nɩnɩŋ nɩ gbaŋ gbaŋ nɩ yilime dɩ bɩa mʋna Ŋmɩŋ jigiŋ? Tɩ saagɩ a yɩ nɩ ta zeti Ŋmɩŋ nʋaŋ yaa? ");
INSERT INTO kma_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dama tɩ kaaŋ bɩagɩ vaa wudieke tɩ gbaŋ gbaŋ tɩ yene ta wʋŋ wa balɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ta die lagɩŋkʋ nyɩŋkʋraha die dɩ bɩ kpaaŋ ba aŋaŋ nɩŋŋmɩna ta vaa ba ga yɔrɩ, dama die ba ka ye wɩɩŋ ba baaŋ nagɩ a datɩ ba tɩbɩŋ, dama vuosisi die faasɩ bala mɩŋ ta bɩra Ŋmɩŋ saaŋ aŋaŋ wudieke dɩ yine wo. ");
INSERT INTO kma_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Daa dieke die dɩ yene mamachi gbaaŋkʋ die tɩaŋ bɩna baŋɩsɩ-nɩɩsa. ");
INSERT INTO kma_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Die ba dine vaa Piita aŋaŋ Jɔɔn wa, die ba yiŋŋi ga ba chanchaalɩba jigiŋ a balɩ ba wudieke Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ aŋaŋ nyɩŋkʋraha dɩ bala ba wa. ");
INSERT INTO kma_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Die ba wʋnna naa wa, die ba mana die dɩ lagɩsɩ taŋ aŋaŋ sʋgɩbalɩmɩŋ a jʋʋsɩ Ŋmɩŋ dɩ “Tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ, fʋ naana ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie, mʋgɩkpɩɩma aŋaŋ nyindiekemba dɩ benne a ma, ");
INSERT INTO kma_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","die Halɩkasɩka ma fʋ dagɩ tɩ chɔɔŋkʋʋŋ Davidi vuodieke die dɩ yine fʋ tʋntʋntʋ, ta die ʋ bʋgɩ balɩ fʋ Halɩkasɩ yiko me dɩ ‘Bɩa yine vuodiekemba dɩ kana a ka yi Juu vuosi dɩ pɩrɩ aŋaŋ sɩnyɩɩrɩŋ, ta Izara vuosi dɩ sama saŋ tɔgɩtɩ ");
INSERT INTO kma_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ta tɩŋgbaŋka gie naara aŋaŋ ba nyɩŋkʋra dɩ lagɩsɩ taŋ a tuole dɩ ba wagɩ aŋaŋ Nabidie Ŋmɩŋ aŋaŋ ʋ Vuovʋarɩkɩrɩ Masia wa.’ ");
INSERT INTO kma_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Dɩ yiwo wusie dɩ, Herodi aŋaŋ Pontiwosi Paliti aŋaŋ vuodiekemba dɩ kana a ka yi Juu vuosi aŋaŋ Izara vuosi die seŋ lagɩsɩ mɩŋ tɩka ma ta saŋ dɩ ba kʋʋ kasɩ tʋntʋntʋ Yisa, vuodieke die fʋ vʋarɩna a zie wo. ");
INSERT INTO kma_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Die ba lagɩsɩya mɩŋ dɩ ba yi wudieke mana fʋ hagɩrɩŋ aŋaŋ fʋ yaalɩŋ ma fʋ wone a saŋ dɩ ka nan yi wo. ");
INSERT INTO kma_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ta lele tɩ Yɔmʋtieŋ, ye vuosi gie dɩ ŋaana a juo tɩ ŋmaamɩŋ dene, ta vaa tɩnɩŋ vuodiekemba dɩ yine fʋ yɔŋɩsɩ balɩma fʋ wɩaha gie aŋaŋ dembisi pam, ");
INSERT INTO kma_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ta tɩɩntɩ fʋ nuuŋ ta yɩ yʋagɩtieliŋ ye gbaamɩŋ, ta vaa tɩ yime mamachi wʋkpɩɩma pam aŋaŋ fʋ kasɩ tʋntʋntʋ Yisa saaŋ hagɩrɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Die ba dine a jʋʋsɩ Ŋmɩŋ a kpatɩ wa, jigidieke ba lagɩŋna wa dɩ dɔŋ, ta Ŋmɩŋ Halɩkasɩka die dɩ suuli ba mana die ba piili a bala Ŋmɩŋ wɩaha aŋaŋ sʋgɩhagɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Saŋka mi Yisa kʋaŋandɩɩsɩrɩŋ mana die dɩ lagɩŋ taŋ aŋaŋ sʋŋanyili balɩmɩŋ aŋaŋ sʋgɩbalɩmɩŋ, ta tɩa ba nyinti a yɩa taŋ. Vuoŋ die ka baarɩ dɩ ʋ sɩɩwa jaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Die saŋŋa mi tʋntʋntɩba die dɩdɩ tɩ Yɔmʋtieŋ Yisa kumbu hagɩŋ daansɩa, ta daansɩaka die yaa hagɩrɩŋ pam, ta Ŋmɩŋ die dɩ yi alibarika pam a yi ba mana ma. ");
INSERT INTO kma_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Die vuoŋ wo ba sʋŋ a waarɩ jaaŋ, dama vuodiekemba die dɩ yalla ba gbaŋ gbaŋ kʋatɩ yaa tige ŋaaŋ nagɩha a daa mɩŋ a yaa ligirehe, ");
INSERT INTO kma_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a keŋ tʋntʋntɩba jigiŋ, ta ba nagɩ tɩa a yɩ vuoŋ mana ʋ yaala dene. ");
INSERT INTO kma_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Die daa wʋnyɩ die bie mi ʋ saaŋ dɩ dɩ Josefu, ta die yi Liiva buuriŋ vuoŋ, ta ba mɩɩrɩ wa Saapurusi, vuodieke tʋntʋntɩba dɩ wasɩnana Banabasi (ka chɩaŋ yine susuŋŋiru), ");
INSERT INTO kma_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","die dɩ keŋ nagɩ ʋ kʋaŋ a daa, a yaa ligirehe a keŋ a yɩ tʋntʋntɩba. ");
INSERT INTO kma_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ama daa wʋnyɩ gbaŋ die benne a dɩ Ananiasi ta ʋ hɔgʋ dɩaŋ dɩ dɩ Safara. Die ba nagɩ ba faarɩ a daa, ");
INSERT INTO kma_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ta die nagɩ ligirehe a taŋ a lɔbɩrɩ, ta ʋ hɔgʋ wa dɩ sɩba ha wɩa, ta die nagɩ ligire tɩalɩka ha a yaa ga yɩ tʋntʋntɩba ha. ");
INSERT INTO kma_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piita die dɩ pɩasɩ wa dɩ, “Ananiasi, bɩa fʋ vaa Sitaani dɩ juu fʋ sʋŋ a nyaŋŋɩ fʋ, ta yi fʋ chɩbɩ ŋmɩnchɩbɩsɩ a yɩ Ŋmɩŋ Halɩkasɩka ta nagɩ ligirehe a taŋ fʋ tuone a nyɩŋ kʋakʋ ma fʋ nagɩna a daa wa? ");
INSERT INTO kma_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Die fʋ yene ka nagɩ ka a daa wa, die ka ka yiwo fʋ sɩɩtɩ? Ta die fʋ nagɩna ka a daa wa, ligirehe die ka yi fʋ sɩɩtɩ? Ta bɩa yine fʋ yile fʋ sʋŋ ma a yi naa? Fʋnɩŋ fʋ ka chɩbɩ ŋmɩnchɩbɩsɩ a yɩ wa vuota, ama fʋ chɩbɩ yɩ wa Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Die Ananiasi die dɩ wʋnna naa, die dɩ kpi a nan. Die ŋmaaŋkpeŋkpɩɩŋ dɩ juu vuodiekemba mana die dɩ wʋnna ʋ kumbu wɩaha. ");
INSERT INTO kma_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Womi dalʋaka die dɩ keŋ nyɩŋ a muuri ʋ nyɩŋgbaŋka aŋaŋ garɩŋ a chii wo a nyɩŋ a ga guu. ");
INSERT INTO kma_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ka kʋaŋ chaaŋ hawasɩ ataa, ʋ hɔgʋ wa die dɩ keŋ juu jigidieke Piita die benne wo, ta ka sɩba wudieke dɩ yine. ");
INSERT INTO kma_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ta Piita dɩ pɩasɩ ʋ gbaŋ dɩ “Balɩ mɩŋ, fʋnɩŋ aŋaŋ fʋ chʋrʋ wa dɩ nagɩna nɩ kʋakʋ a daa wa ta tuo ligirehe a mana wʋnna?” Die ʋ yiŋŋi a balɩ wa dɩ “Wa, bʋ mana wʋnna.” ");
INSERT INTO kma_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Die wɩa Piita die dɩ pɩasɩ wa dɩ, “Bɩa fʋnɩŋ aŋaŋ fʋ chʋrʋ wa dɩ yi nʋabalɩmɩŋ dɩ nɩ magɩsɩ Tɩ Yɔmʋtieŋ Halɩkasɩka. Daa diekemba dɩ guune fʋ chʋrʋ wa, bie wo sanʋarɩ tɩŋ lele, ta ba nan chii fʋ gbaŋ a nyɩŋ a ga guu.” ");
INSERT INTO kma_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lele womi die ʋ kpi a nan tɩŋgbaŋ, ta dalʋakaha die dɩ a keŋ juu a ye dɩ ʋ kpiye mɩŋ, ba chii wo a nyɩŋ a ga guu ʋ chʋrʋ wa lʋgɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Saŋŋa mi die ŋmaaŋkpeŋkpɩɩŋ die dɩ juu Yisa kʋaŋandɩɩsɩrɩŋ mana aŋaŋ vuodiekemba die dɩ wʋnna wɩaha. ");
INSERT INTO kma_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Saŋŋa mi tʋntʋntɩba die dɩ tʋma mamachi tʋnkpɩɩma pam vuosisi jigiŋ. Ta Yisa kʋaŋandɩɩsɩrɩŋ mana die dɩ ŋaaŋ lagɩsɩ taŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ, Solomoni lɩɩfaaka jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ama vuodiekemba dɩ kana ka yi Yisa kʋaŋandɩɩsɩrɩŋ dɩ wo sikimiŋ a baaŋ gaaŋ ba gbaŋ a gʋtɩ ba ma, ama ta die yɩa ba jɩlɩma pam, ");
INSERT INTO kma_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ama dembisi aŋaŋ hɔgʋba pam die dɩ yi tɩ Yɔmʋtieŋ yada ta gʋtɩ ʋ kʋaŋandɩɩsɩrɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Die tʋntʋntɩba dɩ yinene wudiekemba ba wɩa, vuosi die dɩ chii yʋagɩtieliŋ a nyɩŋ sieti ma, a nagɩ ba dʋaŋ gadosi aŋaŋ kalɩŋasɩ ma a mʋ Piita dɩ keŋ chʋŋ tɩanna ʋ ligisiŋ nan nan ba ma aŋ ba ye gbaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ta die kpɩkpaaŋ die dɩ nyɩŋ tɩŋkpaŋŋɩsɩ die dɩ gbine Jerusalemi a yaa ba yʋagɩtieliŋ aŋaŋ vuodiekemba jɩmbɩatɩ dɩ yalla a keŋ, die ba mana dɩ ye gbaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Die wɩa Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ aŋaŋ ʋ kʋaŋandɩɩsɩrɩŋ mana aŋaŋ Sadusisi vuosi bataŋ pam die dɩ yaa sʋgɩbɩaŋ aŋaŋ tʋntʋntɩba, ta die yɩ ");
INSERT INTO kma_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ba ga yigi be a kparɩ ba dansarɩka ma. ");
INSERT INTO kma_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama yuku me Ŋmɩŋ malaka die dɩ keŋ sʋʋŋ a yuori dansarɩka ka sanʋaha dɩ tʋntʋntɩba keŋ nyɩŋ, ta balɩ yi ba dɩ, ");
INSERT INTO kma_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nɩ gamma a ga zie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a balɩ vuosisi miivoli haalɩkʋ gie wɩa mana.” ");
INSERT INTO kma_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Die tʋntʋntɩba die dɩ tuo ʋ nʋarɩ, die sʋkʋleeliŋ die ba ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a piili a daga vuosi wɩaha. Die Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ aŋaŋ ʋ kʋaŋandɩɩsɩrɩba die dɩ wa Juu vuosi nyɩŋkʋra mana a lagɩŋ taŋ, ta die yi nʋaŋ dɩ ba ga dansarɩka ka sʋŋ a ga vʋarɩ tʋntʋntɩba a keŋ ba nɩŋŋa, ");
INSERT INTO kma_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ama die ba gana tʋgɩ dansarɩka ka sʋkʋ die ba ka ye be ta yiŋŋi ga lagɩŋkʋ jigiŋ a ga baarɩ dɩ ");
INSERT INTO kma_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tɩ gana a tʋgɩ dansarɩka ka jigiŋ, tɩ ye ka mɩŋŋɩ kparɩ mɩŋ keŋ keŋ, ta gbɩgbarɩtɩba dɩ zie sanʋaha tɩŋ a gbarɩ, ama tɩ yuorine sanʋaha ta vuoŋ mana wo ka sʋŋ.” ");
INSERT INTO kma_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sojasisi jakʋʋrɩ dɩ wʋnna naa wa, die dɩ yi be mamachi ba yile wudieke dɩ yine wo. ");
INSERT INTO kma_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Womi vuoŋ wʋnyɩ die dɩ keŋ juu mi a baarɩ dɩ, “Nɩ ye, daa diekemba nɩ nagɩna a yi dansarɩka ma wa zie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a daga vuosi Ŋmɩŋ wɩa.” ");
INSERT INTO kma_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Die wɩa sojasisi jakʋʋrɩ die dɩ nagɩ ʋ dembisi ba ga yaa tʋntʋntɩba keŋ, ama die ba ka vʋarɩ ba aŋaŋ hagɩrɩŋ, dama die ba chɩgɩ ŋmaamɩŋ dɩ vuosi nan taa ba tana. ");
INSERT INTO kma_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Die ba yalla ba keŋ wo, die ba vaa ba keŋ zie lagɩŋkʋ nɩŋŋa, ta Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ balɩ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Die tɩ yɩ nɩ wa nʋaŋ aŋaŋ nɩŋŋmɩna, dɩ nɩ da keŋ dagɩ vuosi Yisa saaŋ ma, ama nɩ ye wudieke nɩ yine, nɩ nagɩ dagɩkʋ a mʋʋlɩ Jerusalemi mana, ta yaala nɩ yi tɩ Yisa kʋkʋʋrɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ta Piita aŋaŋ tʋntʋntɩba banɩŋ ba dɩ yiŋŋi balɩ ba dɩ “Sie tɩ saagɩ Ŋmɩŋ nʋaŋ ta daa vuota nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tɩ chɔɔŋkʋʋlɩŋ Ŋmɩŋ die vana Yisa dɩ hagɩ kuŋ me, die nɩ kpaasɩna wa dagarɩkʋ ma wa ta kʋʋ wa wa. ");
INSERT INTO kma_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ŋmɩŋ die dɩ kɔtɩ wa a jʋalɩ wa a kalɩŋ ʋ nuudiigiŋ a yiwo Nɩŋŋandɩɩsɩrʋ aŋaŋ Gbɩgbatɩtaantʋ, dɩ ʋ yɩ Izara vuosi sieŋ dɩ ba chɩgɩ nyɩŋ ba tʋntʋmbɩatɩ ma aŋ Ŋmɩŋ nagɩ ba tʋmbɩatɩ a chaa ba. ");
INSERT INTO kma_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tɩnɩŋ aŋaŋ Ŋmɩŋ Halɩkasɩka yine Yisa kumbu hagɩŋ daansɩa tieliŋ; Ŋmɩŋ dɩ nagɩna Haalɩ dieke wo a yɩa vuodieke mana dɩ tuone ʋ nʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Die nyɩŋkʋraha die dɩ wʋnna naa, die ba jɩɩ sɩnyɩɩrɩŋ pam dɩ ba kʋʋ tʋntʋntɩba. ");
INSERT INTO kma_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama Farasisi vuoŋ wʋnyɩ die benne lagɩŋkʋ me ta ʋ saaŋ dɩ dɩ Gamalia, ta yi mɩraha dɩdagɩrʋ, vuoŋ mana die dɩ yɩa wa jɩlɩma pam; die dɩ hagɩ lagɩŋkʋ ma a balɩ ba dɩ ba yaa tʋntʋntɩba a nyɩŋ aŋ ka yi sʋaa. ");
INSERT INTO kma_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Die ʋ wa balɩ yɩ ba dɩ “N chanchaalɩŋ Izara vuosi, nɩ sɩmma aŋaŋ nɩ bala nɩ yi vuosi gie wudieke wo. ");
INSERT INTO kma_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Saŋŋa dieke dɩ tɩanna wa, Tudasi die hagɩya a baarɩ dɩ ʋ yiwo vuokpɩɩŋ ta die vuosi sɩba kɔbɩsɩ-nɩɩsa die dɩ dɩ ʋ kʋaŋ, ama vuosi bataŋ die dɩ keŋ kʋʋ wa, die ʋ kʋaŋandɩɩsɩrɩba mana die dɩ chɩgɩ a jaasɩ jigiŋ mana, ta ʋ tʋʋmaha mana die dɩ yi yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Naa kʋaŋ chaaŋ, ta Judasi, vuodieke dɩ yine Galili vuoke gbaŋ die dɩ keŋ vuosi bɩɩsɩkʋ saŋŋa, die ʋ tarɩgɩ vuosi bataŋ yɩaŋ ta daadaŋ pam die dɩ dɩ ʋ gbaŋ, ta vuosi die dɩ keŋ kʋʋ ʋ gbaŋ, ta ʋ kʋaŋandɩɩsɩrɩba mana die dɩ chɩgɩ a jaasɩ jigiŋ mana. ");
INSERT INTO kma_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Die wɩa, leleke gie wɩɩrɩ nɩŋ, n kpaama nɩ dɩ nɩ ko vaa vuosi gie sɔmm ta vaa ba ga, dama dɩɩ yi ta ba tʋʋmaha dɩ yiwo vuota tʋʋma ka nan daansɩ kpatɩ. ");
INSERT INTO kma_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama dɩɩ yi ta ka yi Ŋmɩŋ tʋʋma, nɩ kaaŋ bɩagɩ a nyaŋŋɩ ba; nɩnɩŋ nɩ nan keŋ ye ta nɩ waga aŋaŋ Ŋmɩŋ.” Die lagɩŋkʋ die dɩ tuo Gamalia kpaaŋkʋ, ");
INSERT INTO kma_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ta die yiŋŋi a wa tʋntʋntɩba a keŋ juu, ta vaa ba tɩbɩ ba aŋaŋ kpaasɩŋ, ta yɩ ba nʋaŋ dɩ ba da keŋ wɔŋ a balɩ wɩɩŋ Yisa saaŋ ma, ta die vaa ba ga yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Die wɩa, tʋntʋntɩba die dɩ nyɩŋ lagɩŋkʋ jigiŋ aŋaŋ sʋgɩfɩalɩŋ, dama Ŋmɩŋ die yene be ba mʋna wahala diile Yisa saaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ta die daaŋ mana ba ŋaaŋ gara Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma, ta bɩ gara vuosi tige me a daga ta mʋʋla wʋvɩɩnaha dɩ Yisa yine Ŋmɩŋ Vuovʋarɩkɩrɩ, Masia wa. ");
INSERT INTO kma_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Saŋŋa mi die Yisa kʋaŋandɩɩsɩrɩŋ die dɩ gʋtɩnana wa, ta vʋʋnɩŋ dɩ keŋ keŋ Juu vuodiekemba dɩ balala Giriiki jabalɩkɩŋ aŋaŋ Juu vuodiekemba die dɩ bala ba gbaŋ gbaŋ jabalɩkɩŋ sʋnsʋŋ, dama vuodiekemba die dɩ balala Giriiki jabalɩkɩrɩ die baarɩ dɩ daaŋ mana ba ŋaana tɩa nyindiikehe ba kpihɔgʋba ka tuose sɩba vuodiekemba dɩ bala Juu jabalɩkɩrɩ. ");
INSERT INTO kma_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Die wɩa tʋntʋntɩba baŋ aŋaŋ ale wo die wa Yisa kʋaŋandɩɩsɩrɩŋ a lagɩsɩ taŋ a baarɩ dɩ “Dɩ ka mʋ dɩ tɩ vaa Ŋmɩŋ wɩa mʋʋlɩŋ ta wɩarɩ nyindiike tɩala ma. ");
INSERT INTO kma_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Die wɩa n nɩmballɩ, nɩ daansɩ nɩ sʋŋ a vʋarɩ dembisi ba bayʋpɔyɩ nɩ sɩbɩna a baarɩ ba beriŋ vɩɩna, ta yaa yɩaŋ ta suuli wo aŋaŋ Ŋmɩŋ Halɩkasɩka, aŋ tɩ nagɩ tʋʋmaha gie yɩ ba nuusi me, ");
INSERT INTO kma_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ta tɩ nagɩ tɩnɩŋ tɩ saŋŋa a yi Ŋmɩŋ jʋʋsɩŋ mi aŋaŋ Ŋmɩŋ wɩa dagɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ta Yisa kʋaŋandɩɩsɩrɩŋ mana die yaa sʋgɩfɩalɩŋ aŋaŋ tʋntʋntɩba balɩkʋ. Die wɩa ba vʋarɩ Sitiiveni vuodieke die yallɩ yada pam ta Ŋmɩŋ Halɩkasɩka dɩ suuli wo aŋaŋ Filipi aŋaŋ Porokorusi aŋaŋ Nikanori aŋaŋ Timoni aŋaŋ Pamenasi aŋaŋ Nikolasi, vuodieke die nyɩna Antiyoku, ta die dɩ ka yi Juu vuoŋ, ama die dɩ tarɩgɩ ʋ jɩamɩŋ ta dɩa Juu vuosi jɩaŋkʋ. ");
INSERT INTO kma_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Die ba yaa ba ga tʋntʋntɩba jigiŋ, ta tʋntʋntɩba die dɩ nagɩ ba nuusi a diisi ba sikpigile me ta jʋʋsɩ Ŋmɩŋ yɩ ba. ");
INSERT INTO kma_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naa kʋaŋ chaaŋ Ŋmɩŋ wɩa die dɩ bɩ mʋʋlɩ a ga jigiŋ mana, ta Yisa kʋaŋandɩɩsɩrɩŋ die dɩ gʋta lagɩ lagɩ Jerusalemi ma, ta Ŋmɩŋ kɩkaabɩtɩba pam die dɩ saagɩ Yisa wʋvɩɩnaha ta yiwo yada. ");
INSERT INTO kma_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiiveni die dɩ ye Ŋmɩŋ suŋŋiŋ aŋaŋ hagɩrɩŋ pam, ta die dɩ yie mamachi tʋnkpɩɩma vuosisi sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama die dembisi bataŋ die dɩ ka tuo wo. Vuodiekemba die dɩ nɩga nɩnhagɩrɩŋ aŋaŋ Sitiiveni die yiwo Juu vuodiekemba dɩ yine yɔŋɩsɩ, ta die ba vʋarɩ ba a nyɩŋ ba yɔŋɩsɩ ma. Die ba nyɩŋ wa Sayireni aŋaŋ Alekizandira, banɩŋ aŋaŋ Juu vuosi bataŋ die dɩ nyɩna Silisia aŋaŋ Asia ma. Die ba gbaŋ ba yaa wa ba Ŋmɩŋ jɩamɩŋ juoŋ. ");
INSERT INTO kma_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama Ŋmɩŋ Halɩkasɩka die dɩ yɩ Sitiiveni yɩaŋ pam, die ba ka bɩagɩ a nyaŋŋɩ wa aŋaŋ ʋ wʋbalɩkaha. ");
INSERT INTO kma_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Die ba kana ka bɩagɩ a nyaŋŋɩ wa wɩa, die ba ga kpalɩ dembisi bataŋ dɩ ba balɩ dɩ “Tɩnɩŋ tɩ wʋŋ wa ʋ balala a chʋʋsa Mosisi aŋaŋ Ŋmɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba bala naa wɩa, ta vuosisi aŋaŋ nyɩŋkʋraha aŋaŋ mɩraha dɩdagɩrɩba dɩ jɩɩ sɩnyɩɩrɩŋ ta ga Sitiiveni jigiŋ a yigi wo a yaa wa ga ba nyɩŋkʋra lagɩŋkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Womi die ba yaa dembisi bataŋ dɩ ba chɩbɩ ŋmɩnchɩbɩsɩ a yɩ wa. Die ba baarɩ “Daa wa gie ŋaaŋ bala saŋŋa mana a chʋʋsa Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ aŋaŋ Mosisi mɩraha; ");
INSERT INTO kma_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","dama tɩ wʋŋ wa ʋ bala dɩ Yisa vuodieke dɩ yine Nazeriti vuoke nan kpaŋŋɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gie a taaŋ, ta tarɩgɩ chʋara diekemba Mosisi dɩ yɩna tɩ wa.” ");
INSERT INTO kma_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Vuodiekemba mana die dɩ kala lagɩŋkʋ jigiri die dɩ mɩɩrɩgɩ ba nine a daansa Sitiiveni, ta die ye ʋ ninechaaŋ dɩ tarɩgɩ a sɩɩ sɩba malaka ninechaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Die wɩa Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ die dɩ pɩasɩ Sitiiveni dɩ “Ka seŋ yiwo wusie?” ");
INSERT INTO kma_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiiveni die dɩ yiŋŋi a balɩ dɩ “N nɩmballɩ aŋaŋ n chʋalɩŋ, nɩ wʋmma mɩŋ, saŋŋa dieke tɩ chɔɔŋkʋʋŋ Abarahami dɩ yene bie Mesopotamia ma ta ye ka hagɩ ga Harani ma, ta hagɩrɩtieŋ Nabidie Ŋmɩŋ die dɩ nyɩŋ ʋ jigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ta balɩ wa dɩ ‘Vaa fʋ deŋ aŋaŋ fʋ tɩŋgbaŋ ta ga tɩŋgbaŋ dieke n balla n dagɩ fʋ wa.’ ");
INSERT INTO kma_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Die wɩa die ʋ nyɩŋ ʋ tɩŋgbaŋka ma a ga bie Harani ma. Ʋ chɔɔŋ wa kuŋ kʋaŋ chaaŋ, ta Ŋmɩŋ die dɩ vaa ʋ hagɩ a keŋ kalɩ tɩŋgbaŋka gie me jigidieke nɩ benne lele naa. ");
INSERT INTO kma_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ama Ŋmɩŋ die ka yɩ wa tɩŋgbaŋka halɩ bɩta gbaŋ dɩ ʋ sɩna, ama ta die yɩ wa nʋaŋ dɩ ʋ nan daansɩ nagɩ ka a yɩ wa, ta ka nan yi wʋnɩŋ aŋaŋ ʋ haagɩsɩ sɩɩtɩ. Saŋŋa dieke Ŋmɩŋ die dɩ yine nʋarɩ gie wo ta Abarahami die wo bʋa. ");
INSERT INTO kma_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naa die Ŋmɩŋ dɩ balɩ yɩ wa dɩ, ‘Fʋ haagɩsɩ nan daansɩ beri tɩŋgbaŋ gaaŋ ma, mi ba nan yi yɔŋɩsɩ, aŋ ba mugisi be pam bɩna kɔbɩsɩ-nɩɩsa. ");
INSERT INTO kma_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama manɩŋ n nan daansɩ datɩ tɩŋgbaŋ dieke vuosi ba bala ba tʋŋ a yɩa wa tɩbɩŋ, ka kʋaŋ chaaŋ ba nan keŋ a nyɩŋ kanɩŋ tɩŋgbaŋka mi a keŋ tɩka gie me a jɩama mɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Womi Ŋmɩŋ die yɩ Abarahami nʋaŋ, ta die dagɩ wa nʋarɩ dagɩtɩ, dɩ wʋnɩŋ aŋaŋ ʋ haagɩsɩ gobi ba kɔla. Die Abarahami dɩ keŋ mɩɩrɩ Aziki, ta die gobi ʋ kɔlɩ ka daraa nɩɩ daraaŋ. Ka kʋaŋ chaaŋ Aziki dɩaŋ dɩ mɩɩrɩ Jakobu ta gobi ʋ kɔlɩ, ta Jakobu dɩaŋ dɩ gobi ʋ ballɩ baŋ aŋaŋ bale die dɩ yine tɩ chɔɔŋkʋʋlɩkpɩɩma wa kɔla. ");
INSERT INTO kma_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Die Jakobu ballɩlɩ die dɩ keŋ haa ba nɩmbʋa Josefu ta die nagɩ wa a daa a yɩ vuosi bataŋ ba yaa wa ga Ijipiti tɩŋgbaŋ ma a bɩrɩŋ wa yɔmʋ. Ama Ŋmɩŋ die bie ʋ jigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ta die vʋarɩ wa a nyɩŋ wumugisike mana ma, ta die dɩ yɩ wa yɩaŋ ta yi Ijipiti naaŋ wa Faro dɩ yaala ʋ wɩa ta yi wo jakʋʋŋ Ijipiti tɩŋgbaŋ ma, ta bɩ yi wo jakʋʋŋ ʋ tigiŋ me. ");
INSERT INTO kma_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ka kʋaŋ chaaŋ kɔŋkpɩɩŋ die dɩ keŋ nan Ijipiti aŋaŋ Keenani tɩŋgbaŋɩsɩ mana ma, die ba dii wahala pam, ta tɩ chɔɔŋkʋʋlɩba die ka ye nyindiike. ");
INSERT INTO kma_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Die wɩa die Jakobu dɩ wʋnna dɩ nyindiike bie Ijipiti ma wa die ʋ tʋŋ ʋ ballɩlɩ, tɩ chɔɔŋkʋʋlɩba mi, die ba bʋmbʋŋaŋ garɩŋ wonde. ");
INSERT INTO kma_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Die ba garɩŋ bule wo ma wa Josefu die dɩ nagɩ ʋ gbaŋ a dagɩ ʋ nɩmballɩlɩ, mi Faro die dɩ mɩŋŋɩ Josefu deŋ. ");
INSERT INTO kma_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ka kʋaŋ chaaŋ Josefu die dɩ tʋŋ a wa ʋ chɔɔŋ Jakobu aŋaŋ ʋ deŋ mana dɩ ba keŋ Ijipiti ma; die ba mana die yiwo vuosi baŋɩsɩ-yʋpɔyɩ aŋaŋ banʋ. ");
INSERT INTO kma_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Die wɩa Jakobu aŋaŋ ʋ dembe mana die dɩ hagɩ a ga Ijipiti, mi die wʋnɩŋ aŋaŋ ʋ ballɩ dembisi die dɩ kpi. ");
INSERT INTO kma_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Die ba nagɩ ba nyɩŋgbanɩŋ a yiŋŋi a ga Saakemi a ga guu vɔrɩŋ dieke Abarahami die dɩ dana a nyɩŋ Hamori buuriŋ jigiŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Die dɩ wana a gbigi dɩ Ŋmɩŋ yi suuli ʋ nʋarɩ die ʋ yɩna Abarahami wa, die tɩ vuosisi die dɩ benne Ijipiti ma wa die dɩ wa faasɩ dala pam. ");
INSERT INTO kma_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka kʋaŋ chaaŋ vuoŋ wʋnyɩ die dɩ keŋ dii Ijipiti naarɩ, ama wʋnɩŋ die ʋ ka sɩba Josefu wɩa. ");
INSERT INTO kma_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Die naaŋ wa die dɩ pɔgɩlɩ tɩ vuosi aŋaŋ bɩaŋ, ta die mugise be dɩ ba vʋarɩ ba ballɩnyaalɩsɩ ba tige me a taaŋ aŋ ba kpi. ");
INSERT INTO kma_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Die ba keŋ mɩɩrɩ Mosisi, ta die ʋ vɩɩna pam, ta Ŋmɩŋ nine die dɩ suuli wo. Die ʋ bie wo ʋ chɔɔŋ tigiŋ me chɩɩtɩ ataa, ");
INSERT INTO kma_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","die ba kenne nagɩ wa a nyɩŋ ba tigiri me saŋŋa dieke wo, die naaŋ wa hɔgʋlɩa die dɩ keŋ a nagɩ wa a wubi wo, ta yiwo ʋ gbaŋ gbaŋ ʋ bʋa. ");
INSERT INTO kma_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Die ba dagɩ Mosisi yɩaŋ dieke mana Ijipiti vuosisi dɩ yalla, die ʋ keŋ bɩrɩŋ vuodieke dɩ sɩbɩna wʋbalɩka ta tʋma hagɩrɩŋ tʋʋma. ");
INSERT INTO kma_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Die Mosisi die dɩ tʋgɩ bɩna baŋɩsɩ-nɩɩsa Ijipiti vuosi jigiŋ, die ʋ yile daaŋ kaanɩ dɩ ʋ ga a waasɩ ʋ gbaŋ gbaŋ buuriŋ Izara vuosisi. ");
INSERT INTO kma_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Die ʋ ganana wa die ʋ ye Ijipiti vuoŋ dɩ mugisinene Izara vuoŋ, die ʋ ga dɩ ʋ gbatɩ wa a taaŋ, ta die a kʋʋ Ijipiti vuoke. ");
INSERT INTO kma_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Die ʋ yile sɩba ʋ gbaŋ gbaŋ ʋ vuosi nan mɩŋŋɩ sɩba Ŋmɩŋ baa ʋ nagɩ wa wʋnɩŋ a tʋŋ a gbatɩ ba a taaŋ, ama die ba ka mɩŋŋɩ die. ");
INSERT INTO kma_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ka tʋnvʋʋsa, Mosisi die dɩ bɩ ye Izara vuosi bale dɩ wagɩnana, die ʋ yaala ʋ wʋnsɩ ba sʋnsʋŋ, ta balɩ ba dɩ, ‘N zʋamba, nɩ yiwo nɩmballɩ, bɩa nɩ waga taŋ die?’ ");
INSERT INTO kma_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama vuodieke die dɩ yaala waagɩbʋ die dɩ kpaŋŋɩ Mosisi a taaŋ lʋgɩŋ, ta die a pɩasɩ wa dɩ ‘Mɩnɩa yine fʋ tɩ jakʋʋŋ aŋaŋ tɩ sarɩyadiiru?’ ");
INSERT INTO kma_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Fʋnɩŋ fʋ yaala fʋ kʋʋ mɩŋ mɩŋ sɩba diene wo fʋ kʋna Ijipiti vuoke?’ ");
INSERT INTO kma_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosisi die dɩ wʋnna naa, die ʋ chɩgɩ a nyɩŋ Ijipiti tɩŋgbaŋ ma a ga bie Midiani tɩŋgbaŋ ma, ta die dɩ keŋ faarɩ hɔgʋ a mɩɩrɩ ballɩ dembisi bale mi. ");
INSERT INTO kma_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Bɩna baŋɩsɩ-nɩɩsa kʋaŋ chaaŋ, die ʋ ga haagɩŋ daaŋ kaanɩ a ga tʋgɩ Sanayi kunkogiŋ jigiŋ ta ye bolinyaaŋ dɩ dinene haŋgɔɔsɩ tɩɩŋ, ta Ŋmɩŋ malaka die dɩ nyɩŋ bolibu sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","“Die ʋ yene die wo, die dɩ yiwo mamachi, die ʋ chʋŋ a ga gbigi dɩ ʋ mɩŋŋɩ a daansɩ ka, ta die a wʋŋ tɩ Yɔmʋtieŋ Ŋmɩŋ lɔlɩŋ, ta ka bala wa dɩ; ");
INSERT INTO kma_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Manɩŋ n yiwo Ŋmɩŋ dieke fʋ chɔɔŋkʋʋlɩŋ dɩ jɩanna, Abarahami aŋaŋ Aziki aŋaŋ Jakobu Ŋmɩŋ.’ Mosisi die dɩ wʋnna naa, die ʋ cheeli aŋaŋ ŋmaamɩŋ ta ka bɩ yaala ʋ daansɩ mi. ");
INSERT INTO kma_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ta tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ die dɩ balɩ a yɩ wa dɩ ‘Vʋarɩ fʋ nɩɩraha, dama jigidieke fʋ zene wo yiwo jigikasɩ. ");
INSERT INTO kma_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wusie, manɩŋ n yeye mɩŋ n vuosisi dɩ dinene wahala die Ijipiti me, ta wʋŋ ba kpaŋ. Die wɩa maŋ a keŋ sʋʋŋ dɩ n gbatɩ ba a taaŋ. Die wɩa n nan yiŋŋi tʋŋ fʋ Ijipiti me.’ ");
INSERT INTO kma_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mosisi wo gie die yine vuodieke Izara vuosisi die dɩ zetine wo, ta die pɩasɩ wa dɩ ‘Mɩnɩa yine fʋ tɩ jakʋʋŋ aŋaŋ tɩ sarɩyadiiru?’ Ama wʋnɩŋ Ŋmɩŋ die dɩ vʋarɩ dɩ ʋ yi ba nɩŋŋandɩɩsɩrʋ ta gbatɩ ba taaŋ, ta malaka dieke dɩ nyɩna wʋnɩŋ Mosisi jigiri bolinyaabʋ ma haŋgɔɔsɩ tɩɩka jigiri die suŋŋi wo. ");
INSERT INTO kma_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Die wʋnɩŋ Mosisi die yine vuodieke die dɩ vʋarɩna ba a nyɩŋ Ijipiti tɩŋgbaŋ ma, die ʋ bɩ tʋŋ mamachi tʋnkpɩɩma Ijipiti tɩŋgbaŋ ma aŋaŋ saŋŋa dieke die ba gana a garɩsɩ Mʋgɩkpɩɩŋmɩnbʋ wa, aŋaŋ saŋŋa dieke die ba benne haagɩŋ ma wa bɩna baŋɩsɩ-nɩɩsa wa. ");
INSERT INTO kma_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosisi wo gie die bala a yɩ Izara vuosisi dɩ, ‘Ŋmɩŋ nan daansɩ tʋŋ nɩ jigiŋ ʋ naazʋa wʋnyɩ sɩba ʋ tʋnna mɩŋ, ʋ nan yi nɩ gbaŋ gbaŋ nɩ buuriŋ.’ ");
INSERT INTO kma_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wʋnɩŋ Mosisi wo gie die dɩ benne aŋaŋ tɩ Izara vuosisi lagɩŋkʋ ma haagɩŋ ma. Die ʋ bie wo aŋaŋ tɩ chɔɔŋkʋʋlɩba aŋaŋ malaka dieke die dɩ bala wɩa a yɩ wa kunkogiŋ dieke ba wasɩna Sinayi wa. Mi die ʋ tuo Ŋmɩŋ miivoli wʋbalɩkaha dɩ ʋ nagɩ a yɩ tɩ chɔɔŋkʋʋlɩŋ aŋaŋ tɩ. ");
INSERT INTO kma_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ama die tɩ chɔɔŋkʋʋlɩba die dɩ zeti ta ka dɩ wa dama ba sʋŋanyile die yiŋŋi ga wa Ijipiti me, ");
INSERT INTO kma_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","die wɩa die ba balɩ a yi Arɔni dɩ ‘Mɩɩ ŋmɩŋ a yɩ tɩ aŋ ka dɩa tɩ nɩŋŋa. Tɩnɩŋ tɩ ka sɩba wudieke dɩ yine Mosisi, vuodieke dɩ nagɩna tɩ a nyɩŋ Ijipiti ma wa.’ ");
INSERT INTO kma_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Saŋka mi die ba mɩɩ buuŋ sɩba naraabɩŋ, a kaaba a yɩa ka, ta die die dʋʋga ta bɩra jadieke ba gbaŋ gbaŋ ba mɩna wa aŋaŋ nuusisi. ");
INSERT INTO kma_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Die wɩa Ŋmɩŋ die dɩ vaa ba a taaŋ dɩ ba jɩama chɩŋmarɩsɩ, sɩba die dɩ maagɩna die wo Ŋmɩŋ naazʋalɩba gbaŋkʋ ma wa, dɩ Ŋmɩŋ baarɩ dɩ: ‘Izara vuosi, die nɩ kʋnana dɔŋɩsɩ ta kaaba haagɩŋ ma bɩna baŋɩsɩ-nɩɩsa wa, daa manɩŋ die nɩ kaaba yɩa. ");
INSERT INTO kma_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Die nɩ ŋaana naga buuŋ Moloki vɩɩŋ ta bɩ naga chɩŋmarɩŋ Refani nɩasɩŋ ta a yi bugile ta jɩama. Naa chɩaŋ ma n nan vaa nɩ dataasɩ vʋara nɩ a nyɩŋ nɩ tɩŋ ma a yaa nɩ a ga saasaa a poli Babiloni.’ ");
INSERT INTO kma_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tɩ chɔɔŋkʋʋlɩba die kpi wo Ŋmɩŋ vɩɩŋ haagɩrɩ ma ta die daga dɩ Ŋmɩŋ bie ba jigiŋ. Die ba wʋnsɩ ka mɩŋ sɩba Ŋmɩŋ die dɩ balla Mosisi die wo. Die ka sɩɩ sɩba Ŋmɩŋ die dɩ vana Mosisi die dɩ yene ke die wo. ");
INSERT INTO kma_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ka kʋaŋ chaaŋ die tɩ chɔɔŋkʋʋlɩba die dɩ keŋ nagɩ vɩɩkʋ a yɩ ba ballɩ, ta ba tuo ke a yaa ka gara, ta banɩŋ aŋaŋ Josua die dɩ keŋ keŋ gie ta gbatɩ tɩŋgbaŋ diekemba die buuri gaasɩ die dɩ sɩna. Ŋmɩŋ die dɩ benne ba nɩŋŋa a yagɩ vuosisi a taaŋ wa ta die viiku bie gie deŋ deŋ a keŋ tʋgɩ Davidi saŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidi beriŋ die dɩ suuli Ŋmɩŋ nine, ta die keŋ jʋʋsɩ dɩ ʋ vaa ʋ mɩɩ tigiŋ a yɩ wʋnɩŋ Ŋmɩŋ vuodieke die dɩ ʋ chɔɔŋkʋʋŋ Jakobu Ŋmɩnnɩ. ");
INSERT INTO kma_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama wʋnɩŋ Davidi bʋadembiŋ Solomoni die dɩ keŋ mɩɩ die tigiri. ");
INSERT INTO kma_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Tɩ sɩba a baarɩ Nabidie Ŋmɩŋ ka bie tige diekemba vuota dɩ mɩna. Naa sɩɩ sɩba Ŋmɩŋ naazʋa die dɩ bala dɩ ");
INSERT INTO kma_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tɩ Yɔmʋtieŋ Nabidie Ŋmɩŋ baarɩ ŋmɩŋsikpeŋ yine n naarɩ gbanɩŋ ta tɩŋgbaŋka gie dɩaŋ dɩ yi n nagɩsɩ jigizielikiŋ. Nɩ nan bɩagɩ a mɩɩ tɩgɩ dieke dɩ mʋna mɩŋ a yɩ mɩŋ? Yaa jigidieke n baaŋ nan voosi? ");
INSERT INTO kma_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Daa manɩŋ die n naana nyinti gie mana?’ ");
INSERT INTO kma_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Nɩnɩŋ nɩ yiwo tɩbɩhagɩrɩtieliŋ, ta nɩ sʋŋanyile dɩ yʋa aŋaŋ Ŋmɩŋ pam ta nɩ ka saaga dɩ nɩ wʋŋ Ŋmɩŋ wɩa. Nɩnɩŋ nɩ zetine Ŋmɩŋ Haalɩbʋ sɩba nɩ chɔɔŋkʋʋlɩba die dɩ zetine die wo. ");
INSERT INTO kma_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ŋmɩŋ naazʋa wʋnyɩ die wori ta nɩ chɔɔŋkʋʋlɩŋ dɩ ka mugisiye. Ta bɩ kʋʋ Ŋmɩŋ tʋntʋntɩba diekemba die dɩ bʋgɩna balɩ Ŋmɩŋ Vuokasɩka Masia wa keniŋ wɩa. Ta lele nɩ yine vuodiekemba dɩ posine ʋ chɩaŋ ta kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nɩnɩŋ nɩ yine vuodiekemba die dɩ tuone Ŋmɩŋ mɩraha a nyɩŋ malakasisi jigiŋ, ama ta ka saaga a dɩa ha.” ");
INSERT INTO kma_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Die lagɩŋkʋ vuosi die dɩ wʋnna Sitiiveni balɩkʋ die ba jɩɩ sɩnyɩɩrɩŋ pam ta ŋɔba ba nyɩna. ");
INSERT INTO kma_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama die Ŋmɩŋ Halɩkasɩka die dɩ suuli Sitiiveni, ʋ kɔtɩ ʋ sikpeŋ a daansɩ ŋmɩŋsikpeŋ a ye Ŋmɩŋ chuulikpeŋkpɩɩŋ ta ye Yisa dɩ zene Ŋmɩŋ nuudiigiŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Die ʋ baarɩ dɩ, “Ye, n ye arɩzanna sanʋaŋ dɩ yuorine ta vuota Bʋa wa dɩ zie Ŋmɩŋ nuudiigiŋ chaaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Die ba wʋnna na ba keesi aŋaŋ lɔlɩkpɩɩŋ, ta nagɩ ba nuusi a ligi ba tɩba. Womi ba mana die dɩ chɩgɩ a keŋ taaŋ a giliŋ wo bʋnyɩ, ");
INSERT INTO kma_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a datɩ wa nyɩŋ tɩka lʋgɩŋ a piili a taa wa tana. Die vuodiekemba die dɩ taana wa tana wa die dɩ vʋarɩ ba nyinyeeke dʋaŋ dalʋakɩŋ wʋnyɩ die dɩ dine Sɔɔli dɩ ʋ daansɩma ha. ");
INSERT INTO kma_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Die ba taanana wa die ta die ʋ keŋ wa tɩ Yɔmʋtieŋ dɩ, “N Yɔmʋtieŋ Yisa, tuo n haalɩŋ!” ");
INSERT INTO kma_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ta sʋʋŋ gbirigi ta keesi aŋaŋ lɔlɩkpɩɩŋ dɩ, “N Yɔmʋtieŋ, da keŋ nagɩ ba taalɩ gie a chʋʋsɩ ba.” Die ʋ balɩ wa naa ta kpi. ");
INSERT INTO kma_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ta Sɔɔli die dɩ saagɩna ʋ kʋʋla wɩa. Dɩnɩŋ daarɩ mi gbaŋ gbaŋ die mugisibɩaŋ die dɩ nan Yisa kʋaŋandɩɩsɩrɩŋ die dɩ benne Jerusalemi ma; ta ba mana die dɩ nyɩŋ a jaasɩ ga Judia aŋaŋ Samaria lʋga mana ama ta va tʋntʋntɩba nyɩɩna mi. ");
INSERT INTO kma_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Vuodiekemba die dɩ jɩanna Ŋmɩŋ bataŋ die dɩ guu Sitiiveni ta faasɩ kʋŋ ʋ kumbu. ");
INSERT INTO kma_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ama Sɔɔli die dɩ yaala ʋ chʋʋsɩ Yisa kʋaŋandɩɩsɩrɩba, ta die gara tige tige, ta yige Yisa kʋaŋandɩɩsɩrɩŋ, dembisi aŋaŋ hɔgʋba mana a keŋ nyɩna ta a yaa ba a lige dansarɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yisa kʋaŋandɩɩsɩrɩŋ diekemba die dɩ jaasɩ wa die dɩ ga jigiŋ mana a ga mʋʋla Yisa wɩaha. ");
INSERT INTO kma_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ta Filipi die dɩ sʋʋŋ ga Samaria tɩka ma a ga mʋʋlɩ Ŋmɩŋ Vuovʋarɩkɩŋ Masia wɩa a yɩ mi vuosisi. ");
INSERT INTO kma_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Die daadamba pam mi die dɩ keŋ a mɩŋŋɩ a yuori ba tɩba a wʋŋ Filipi balɩkʋ, ta bɩ ye ʋ yinene mamachi wudieke wo. ");
INSERT INTO kma_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Die jɩmbɩatɩ pam die dɩ chɩgɩ a nyɩŋ daadaŋ pam ma aŋaŋ keesiŋ pam; ta die nyɩŋgbaŋ kpiikiŋ tieliŋ aŋaŋ gbarɩsɩ pam die dɩ ye gbaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Die wɩa die sʋgɩfɩalɩŋ die dɩ bie Samaria tɩŋ mana ma. ");
INSERT INTO kma_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Daa wʋnyɩ gbaŋ die benne tɩka ma ba wasa wa Simoni ta yaa tɩɩŋ, saŋŋa a taŋ ʋ ŋaaŋ yie mamachi wuyiike ta a yie vuosisi mamachi, ta die a bala dɩ ʋ yiwo vuokpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vuodiekemba mana dɩ benne tɩka ma, zɔɔlɩntieliŋ aŋaŋ vuokpɩɩma mana die dɩ yɩa wa jɩlɩma ta wʋmma a yɩa wa. Die ba bala dɩ “Simoni yiwo vuodieke ŋmɩŋ dieke ba wasanana ‘Yiko Ŋmɩŋ dɩ tarɩgɩna.’ ” ");
INSERT INTO kma_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Die ba wʋmma a yɩa wa dama die ʋ yi wo mamachi wuyiikehe a yʋasɩ ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama die Filipi dɩ keŋ a mʋʋlɩ Ŋmɩŋ naarɩ wʋvɩɩnaha aŋaŋ Yisa wɩa, dembisi aŋaŋ hɔɔŋ die dɩ saagɩ ʋ mʋʋlɩkʋ, ta ʋ sɩɩ ba Ŋmɩŋ nyaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni gbaŋ gbaŋ die dɩ yi Filipi balɩkʋ yada, die ʋ sɩɩ wa Ŋmɩŋ nyaaŋ. Die ʋ dɩ Filipi kʋaŋ a yese mamachi wʋkpɩɩŋ diekemba ʋ yinene, dɩ yi wo mamachi. ");
INSERT INTO kma_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Die Yisa tʋntʋntɩba die dɩ benne Jerusalemi dɩ wʋŋ dɩ Samaria vuosi tuo wo Ŋmɩŋ wɩaha a dii, die ba tʋŋ Piita aŋaŋ Jɔɔn ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Die ba gana a ga tʋgɩ mi, die ba jʋʋsɩ Ŋmɩŋ a yɩ ba dɩ ba tuo Ŋmɩŋ Halɩkasɩka, ");
INSERT INTO kma_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","dama die Ŋmɩŋ Halɩkasɩka die ye ka keŋ a sʋʋŋ ba wʋnyɩ mana ma; die ba ko sɩɩ ba wa Ŋmɩŋ nyaabʋ tɩ Yɔmʋtieŋ Yisa saaŋ ma nyɩɩna. ");
INSERT INTO kma_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Womi Piita aŋaŋ Jɔɔn die dɩ nagɩ ba nuusi a dɩɩsɩ ba ma ta ba tuo Ŋmɩŋ Halɩkasɩka. ");
INSERT INTO kma_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni die dɩ ye dɩ tʋntʋntɩba dɩ nagɩna ba nuusi a dɩɩsɩ ba ma ta Ŋmɩŋ dɩ yɩ ba Halɩkasɩka, die wɩa die ʋ nagɩ ligire a yaala ʋ yɩ Piita aŋaŋ Jɔɔn, ");
INSERT INTO kma_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ta baarɩ “Nɩ yɩ mɩŋ gbaŋ yiko ka gie amʋ maŋ keŋ nagɩ n nuuŋ a dɩɩsɩ vuodieke mana ma, ʋ nan tuo Ŋmɩŋ Halɩkasɩka.” ");
INSERT INTO kma_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama Piita die dɩ yiŋŋi balɩ wa dɩ “Fʋnɩŋ nan kpi yɔrɩ aŋaŋ fʋ ligirehe dama fʋ yile dɩ fʋ nan bɩagɩ a daa Ŋmɩŋ piini aŋaŋ ligire. ");
INSERT INTO kma_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Die wɩa fʋ nuuŋ wo tɩ tʋʋma ma, dama fʋ sʋŋanyile ka vɩɩna Ŋmɩŋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Die wɩa chɩgɩ a nyɩŋ fʋ sʋŋanyilibɩatɩ gie me, ta jʋʋsɩ tɩ Yɔmʋtieŋ Ŋmɩŋ amʋ ʋ nagɩ fʋ sʋŋanyilibɩakʋ gie a chaa fʋ, ");
INSERT INTO kma_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","dama n yeye ta fʋ suuli wo aŋaŋ sʋgɩbɩaŋ ta bɩaŋ dɩ suuli fʋ.” ");
INSERT INTO kma_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Womi Simoni die dɩ balɩ a yɩ Piita aŋaŋ Jɔɔn dɩ, “Nɩ jʋʋsɩ tɩ Yɔmʋtieŋ a yɩ mɩŋ, amʋ nyinti gie wʋnyɩ mana nɩ bala wa da keŋ keŋ n ma.” ");
INSERT INTO kma_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Die ba bala wudieke tɩ Yɔmʋtieŋ dɩ yine aŋaŋ ʋ wʋvɩɩnaha a kpatɩ, die ba yiŋŋi a ga Jerusalemi. Die ba ganana die ba mʋʋla Ŋmɩŋ wʋvɩɩnaha Samaria tɩŋkpaŋŋɩsɩ pam ma. ");
INSERT INTO kma_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Die tɩ Yɔmʋtieŋ malaka die dɩ keŋ a balɩ a yɩ Filipi dɩ “Hagɩ a ga a daagɩ sie dieke dɩ nyɩna Jerusalemi ta sʋʋŋ gara Gaza wa.” Ba ka bɩ daaga sieku gie lele. ");
INSERT INTO kma_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Die wɩa die ʋ hagɩ a piili chɔnɩŋ, die ʋ ganana ʋ ga tuoli Ituopia daayaabɩŋ sieku me ta ʋ kule. Die ʋ yiwo vuokpɩɩŋ ta daansɩ Ituopia hɔgʋ naaŋ wa ligire. Die ʋ ga wa Jerusalemi a ga jɩaŋ Ŋmɩŋ, ");
INSERT INTO kma_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ta wa yiŋŋi kuli tigiŋ ta kalɩ ʋ toriku me ta duune dɩ data ka ta ʋ karɩma gbaŋ dieke Ŋmɩŋ naazʋa Azaya dɩ maagɩna. ");
INSERT INTO kma_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Die Ŋmɩŋ Halɩkasɩka die dɩ balɩ a yɩ Filipi dɩ “Vɩɩsɩ gbigi torikuke.” ");
INSERT INTO kma_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Womi Filipi die dɩ chɩgɩ a ga gbigike a wʋŋ daa wa dɩ karɩnnana gbaŋ dieke Ŋmɩŋ naazʋa Azaya dɩ maagɩna wa. Die ʋ pɩasɩ wa dɩ “Fʋ sɩba wudieke fʋ karɩnnana chɩaŋ mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ta ʋ yiŋŋi balɩ wa dɩ, “N baaŋ yi wo lalɩa a sɩmma ka chɩaŋ, ntaala vuoŋ dagɩ mɩŋ?” Die wɩa ʋ jʋʋsɩ Filipi dɩ ʋ keŋ jʋalɩ kala torikuke me aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Die ʋ karɩnnana wudieke wo yiwo naa dɩ: “Die ʋ nɩasɩ wa yii dieke ba yalla a ga dɩ ba kɔrɩgɩ, ta die beri sigisigi sɩba yiipɔlɩ dieke ba ŋaana gobe ka kobiti ka beri sigisigi die, die ʋ ka yuori ʋ nʋaŋ a balɩ wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Die ba yiwo viivi, ta zeti dɩ ba kaaŋ dii ʋ sarɩya vɩɩnɩŋ. Ta vuoŋ wori a baaŋ nan bɩagɩ a balɩ ʋ haagɩsɩ wɩa, dama die ba woliŋ vʋarɩ wa ʋ miivoli a nyɩŋ tɩŋgbaŋka gie me.” ");
INSERT INTO kma_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Daa wa die dɩ pɩasɩ Filipi dɩ, “Balɩ mɩŋ, mɩnɩa wɩa naazʋa wa die dɩ bala wa? Ʋ gbaŋ gbaŋ ʋ wɩa yaa vuogaaŋ?” ");
INSERT INTO kma_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Die Filipi dɩ piili a nyɩŋ daa wa die dɩ karɩnna jigidieke wo ʋ gbaŋ gbaŋ a balɩ wa Ŋmɩŋ wʋvɩɩnaha yaa gamma Yisa wɩa. ");
INSERT INTO kma_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Die ba sʋʋna gara sieku me wo, die ba keŋ tʋgɩ jigiŋ kaanɩ nyaaŋ bʋtaŋ dɩ dʋa, daa wa die dɩ baarɩ, “Ye, nyaaŋ wʋnna bɩa bala ka kagɩ mɩŋ amʋ n daa sɩɩ Ŋmɩŋ nyaaŋ?” (( ");
INSERT INTO kma_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ta Filipi die dɩ balɩ wa, “Dɩɩ yi fʋ yi Yisa Masia yada aŋaŋ fʋ sʋŋ mana, n nan bɩagɩ sɩɩ fʋ.” Die ʋ yiŋŋi balɩ dɩ, “N yi yada dɩ Yisa Masia yiwo Ŋmɩŋ Bʋadembiŋ mɩŋ.”)) ");
INSERT INTO kma_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Die daayaabɩrɩ dɩ yi ta duunehe dɩ zie, ta wʋnɩŋ aŋaŋ Filipi die dɩ sʋʋŋ ga nyaabʋ ma, Filipi die dɩ sɩɩ wa Ŋmɩŋ nyaabʋ. ");
INSERT INTO kma_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Die ba kenne nyɩŋ nyaabʋ ma wa, tɩ Yɔmʋtieŋ Haalɩŋ die dɩ nagɩ Filipi a nyɩŋ mi bʋnyɩ, ta daa wa die ka bɩ ye wo bɩbra, ta die chʋŋ kule aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipi die dɩ keŋ ye ta ʋ bie Azotusi a die dɩ dɩa ka tɩgɩsɩ mana a mʋʋla Ŋmɩŋ wʋvɩɩnaha, yaa die a ga tʋgɩ Siisiria. ");
INSERT INTO kma_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tɔ, Sɔɔli die ko nɩga nyuŋ dɩ ʋ nan dɩ mugise ta kʋa tɩ Yɔmʋtieŋ Yisa kʋaŋandɩɩsɩrɩŋ, die ʋ ga Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ jigiŋ ");
INSERT INTO kma_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a balɩ wa dɩ ʋ yɩ wa gbaŋtɩ aŋ a dagɩ vuodieke dɩ yine wo aŋaŋ yiko dieke ʋ yalla aŋ ʋ ga Damasikusi a ga dagɩ Ŋmɩŋ jɩamɩŋ juone me nyɩŋkʋra a mʋ dɩɩ yi ʋ keŋ ye vuodieke dɩ dɩna sie dieke Yisa dɩ dagɩna, hɔgʋ yaa dembiŋ ʋ nan bɩagɩ yigi be a yaa ba a yiŋŋi keŋ Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Die ʋ benne sieku me a gara Damasikusi ta keŋ gbigi tɩka, die chaanɩŋ die dɩ nyɩŋ ŋmɩŋsikpeŋ a keŋ chaaŋ giliŋ wo bʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Womi die ʋ nan tɩŋgbaŋ ta wʋŋ lɔlɩŋ dɩ balala a yɩa wa dɩ, “Sɔɔli, Sɔɔli, bɩa yine fʋ mugise mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Die ʋ pɩasɩ dɩ, “Mɩnɩa yine fʋ n Yɔmʋtieŋ?” Lɔlɩkʋ die dɩ baarɩ dɩ, “Manɩŋ Yisa, vuodieke fʋ mugisinene wo. ");
INSERT INTO kma_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ama hagɩ a ga tɩka sʋŋ, mi ba nan dagɩ fʋ wudieke fʋ mʋna fʋ yi.” ");
INSERT INTO kma_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saŋka mi dembiŋ diekemba die dɩ ganana aŋaŋ Sɔɔli wa die dɩ wɩarɩ zie surumm. Die ba wʋŋ wa lɔlɩkʋ ama die ba ka ye vuoŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ta Sɔɔli die dɩ hagɩ tɩŋgbaŋka ma a yuori ʋ nine ama ta ka yese. Die wɩa die ba yigi ʋ nuuŋ me a yaa wa a ga Damasikusi. ");
INSERT INTO kma_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Damʋʋma ataa die ʋ ka bɩagɩ yese. Die daraa gie nɩŋ mana die ʋ ka dii jaaŋ yaa a nyuu jaaŋ mana. ");
INSERT INTO kma_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Die Yisa dɩdɩɩsɩrʋ wʋnyɩ die benne Damasikusi ma ba wasa wa Ananiasi, ta tɩ Yɔmʋtieŋ die dɩ wa wa daansa sʋŋ dɩ, “Ananiasi!” Die ʋ yiŋŋi a baarɩ dɩ, “Manɩŋ n wʋnna n Yɔmʋtieŋ.” ");
INSERT INTO kma_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tɩ Yɔmʋtieŋ dɩ balɩ a yɩ wa dɩ, “Gɔmɩsɩ ga sie dieke ba wasɩnana Sieŋ-tʋgɩsɩkʋ ma a ga Judasi tigiŋ me a pɩasɩ daa dieke dɩ nyɩna Taasusi ʋ saaŋ dɩ dɩ Sɔɔli wa wɩa. Ʋ jʋʋsa Ŋmɩŋ lele gie. ");
INSERT INTO kma_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Die Sɔɔli daansa sʋŋ, ʋ ye daa wʋnyɩ ba wasɩnana Ananiasi dɩ kenne juu a nagɩ ʋ nuusi a diisi ʋ ma, a mʋ ʋ nan bɩ yese bɩbra.” ");
INSERT INTO kma_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiasi die dɩ yiŋŋi balɩ dɩ, “N Yɔmʋtieŋ, vuosi pam wɔŋ balɩ mɩŋ daa wa gie wɩa, yaa gamma wʋbɩaŋ diekemba ʋ yinene fʋ vuosi dɩ benne Jerusalemi ma wa. ");
INSERT INTO kma_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ta ʋ wa keŋ giena aŋaŋ Ŋmɩŋ kɩkaabɩtʋ yiko dɩ ʋ yigi vuodieke mana dɩ wasɩnana fʋ saaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama ta tɩ Yɔmʋtieŋ die dɩ balɩ dɩ, “Fʋnɩŋ fʋ ko gamma, dama wʋnɩŋ maŋ vʋarɩ dɩ ʋ tʋma n tʋʋma, ta vaa buurigaasɩ aŋaŋ ba naakpɩɩma aŋaŋ Izara vuosi mana sɩmma n saaŋ: ");
INSERT INTO kma_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ta manɩŋ n nan dagɩ wa gbalɩgɩ diekemba mana ʋ bala ʋ gbalɩgɩ n saaŋ chɩaŋ ma.” ");
INSERT INTO kma_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Die wɩa Ananiasi die dɩ ga a ga juu tigiri me a nagɩ ʋ nuusi a diisi Sɔɔli ma, ta baarɩ dɩ, “N nɩmbʋa Sɔɔli, tɩ Yɔmʋtieŋ Yisa vuodieke dɩ nyɩna fʋ jigiŋ sieku me wo saŋŋa dieke fʋ kennene giena wa tʋnna mɩŋ amʋ fʋ nan bɩ ye bɩbra ta suuli aŋaŋ Ŋmɩŋ Halɩkasɩka.” ");
INSERT INTO kma_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lele womi jaaŋ kaanɩ die dɩ sɩna sɩba zaasɩŋ hagɩtɩ die dɩ nyɩŋ Sɔɔli nine me a nan, die ʋ bɩ bɩagɩ yese bɩbra. Die ʋ hagɩ a zie, ta ba sɩɩ wa Ŋmɩŋ nyaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Die ʋ dii nyindiike ta ʋ hagɩrɩŋ dɩ yiŋŋi keŋ. Saŋka mi Sɔɔli die dɩ wɩarɩ Yisa dɩdɩɩsɩrɩŋ dɩ benne Damasikusi ma wa jigiŋ daraa ale, ");
INSERT INTO kma_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ta die ga Ŋmɩŋ jɩamɩŋ juone me lagɩ lagɩ a ga mʋʋla Yisa wɩa dɩ, “Yisa seŋ yiwo Ŋmɩŋ Bʋa.” ");
INSERT INTO kma_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vuodiekemba mana die dɩ wʋnna wa wa die dɩ yi be mamachi ta ba pɩasa dɩ, “Da daa wa gie die benne Jerusalemi ma a kʋa vuodiekemba die dɩ wasɩnana saarɩ gie wo? Ʋ ka keŋ giena dɩ ʋ yigi wo Yisa dɩdɩɩsɩrɩŋ ta nagɩ ba a yiŋŋi ga yɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha?” ");
INSERT INTO kma_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ama ta Sɔɔli mʋʋlɩkʋ die dɩ a ko gʋta aŋaŋ Ŋmɩŋ hagɩrɩŋ, ʋ mʋʋlɩkʋ die dɩ dagɩ dɩ Yisa seŋ yiwo Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa ta chɩɩla die dɩ wori: die wɩa Juu vuosi diekemba die benne Damasikusi die ka bɩagɩ a balɩ wa wɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Die daraa pam die dɩ tɩaŋ, ta Juu vuosisi die dɩ lagɩsɩ taŋ a saŋ dɩ ba kʋʋ wa; ");
INSERT INTO kma_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ama die vuoŋ dɩ balɩ wa wudieke ba sanna dɩ ba yi wo. Die ŋmɩntʋasɩ aŋaŋ yuŋ mana die ba ŋaaŋ gbarɩ wa tɩka sanʋa mana ma dɩ ba kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ama yuŋ kaanɩ ʋ kʋaŋandɩɩsɩrɩba dɩ nagɩ wa a yi kparɩŋ ma a nagɩ wa a daagɩ tɩka paŋ sikpeŋ a nyɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Womi Sɔɔli die dɩ ga Jerusalemi a mɩa dɩ ʋ nagɩ ʋ gbaŋ a lagɩŋ Yisa kʋaŋandɩɩsɩrɩba ma, ama die ba ka yiwo yada dɩ lele, ʋ wa yiwo Yisa kʋaŋandɩɩsɩrʋ, ta die wa chɩgɩ wa ŋmaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ta Banabasi die dɩ keŋ suŋŋi wo a yaa wa ga tʋntʋntɩba jigiŋ, a balɩ ba Sɔɔli die dɩ yene tɩ Yɔmʋtieŋ Yisa sieŋ me ta ʋ balɩ wɩa a yɩ wa dene. Die ʋ bɩ balɩ ba Sɔɔli die dɩ dine dembisi a mʋʋla Yisa wɩa Damasikusi ma dene. ");
INSERT INTO kma_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Die wɩa Sɔɔli die dɩ beri aŋaŋ ba ta die dɩ dɩa Jerusalemi jige mana a mʋʋla tɩ Yɔmʋtieŋ saaŋ aŋaŋ dembisi. ");
INSERT INTO kma_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Die ʋ bɩ bala aŋaŋ Juu vuodiekemba dɩ bala Giriiki jabalɩkɩŋ yaa gamma Yisa wɩa, ama die ba nɩga nɩnhagɩrɩŋ aŋaŋ wa, ta mɩa dɩ ba kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ama saŋŋa dieke ta Yisa dɩdɩɩsɩrɩŋ die dɩ mɩŋŋɩna naa die ba nagɩ wa a sʋʋŋ ga Siisiria ta vaa ʋ kuli Taasusi me. ");
INSERT INTO kma_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Womi die Yisa kʋaŋandɩɩsɩrɩba dieke dɩ benne Judia aŋaŋ Galili aŋaŋ Samaria mana ma die ka bɩ ye mugisiŋ. Die Ŋmɩŋ Halɩkasɩka die dɩ yɩ ba hagɩrɩŋ ta kpaŋŋɩsɩ ba, die ba gʋta ta beri aŋaŋ Ŋmɩŋ chɩgɩla. ");
INSERT INTO kma_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ka kʋaŋ chaaŋ Piita die dɩ dɩa a ga jigiŋ mana, ta die keŋ sʋʋŋ ga dɩ ʋ kaagɩ Ŋmɩŋ vuosi die dɩ benne Liida. ");
INSERT INTO kma_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mi die ʋ ye daa wʋnyɩ ba wasɩnana Aniasi, die ʋ nyɩŋgbanɩŋ die kpine ta ʋ ka bɩagɩ haga ʋ jadʋakɩŋ ma bɩna anɩɩ. ");
INSERT INTO kma_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piita die dɩ balɩ a yɩ wa dɩ, “Aniasi, Yisa Masia gbaannana fʋ, hagɩ ta wʋnsɩ fʋ jadʋakɩrɩ.” Lele womi die ʋ hagɩ a zie. ");
INSERT INTO kma_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Die vuodiekemba mana die dɩ benne Liida aŋaŋ Saroni ma die dɩ ye wo die dɩ tarɩgɩ ba beriŋ, ta dɩ tɩ Yɔmʋtieŋ sieŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Hɔgʋ wʋnyɩ dɩaŋ die dɩ benne Joopa ma ba wasa wa Tabita, ama Giriiki jabalɩkɩŋ ba wasa wa Dɔkasi, ka chɩaŋ yine “Haabiiŋ” ta die a yi Yisa dɩdɩɩsɩrʋ. Die ʋ nagɩ ʋ saŋŋa mana a yie wʋvɩɩna yɩa vuosi ta suŋŋi zɔɔlɩntieliŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Die saŋka mi yʋagɩŋ die dɩ yigi wo die ʋ kpi. Die ba sɩɩ wa nyaaŋ ta nagɩ wa a jʋalɩ dʋaŋ jarɩnbɩsa juoŋ me. ");
INSERT INTO kma_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joopa die ka faasɩ yʋa aŋaŋ Liida; die wɩa die Yisa dɩdɩɩsɩrɩba die dɩ wʋnna dɩ Piita bie Liida ma wa die ba tʋŋ dembisi bale ʋ jigiŋ dɩ ba ga balɩ wa dɩ, “Tɩ jʋʋsa fʋ yi lagɩ lagɩ a keŋ tɩ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Die wɩa Piita die dɩ yi siri wʋnɩŋ aŋaŋ ba die dɩ ga. Die ʋ gana a ga tʋgɩ wa ba nagɩ wa jʋalɩ ga juoku me. Mi kpihɔgʋba mana die dɩ taaŋ giliŋ Piita a kʋma ta daga wa nyinyeeki diekemba Dɔkasi die dɩ baalɩna yɩ ba wa saŋŋa dieke ʋ benne ʋ mɩsɩ ma wa. ");
INSERT INTO kma_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ama Piita die dɩ yagɩ ba mana dɩ nyɩŋ juoku me, ta die sʋʋŋ a gbirigi ʋ dune me a jʋʋsɩ Ŋmɩŋ, ta die yiŋŋi a daansɩ kumbu ta baarɩ dɩ, “Tabita, hagɩ!” Die ʋ yuori ʋ nine a ye Piita, ta die hagɩ a kalɩ. ");
INSERT INTO kma_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piita die dɩ tɩɩntɩ ʋ nuuŋ a suŋŋi wo ʋ hagɩ zie ta wa kpihɔgʋbaha aŋaŋ Yisa dɩdɩɩsɩrɩŋ banɩŋ ba a nagɩ wa dagɩ ba dɩ ʋ yiŋŋi keŋ wo ʋ miivoli me mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wɩɩrɩ gie die dɩ dɩa ga Joopa mana ma ta vuosi pam die dɩ yi tɩ Yɔmʋtieŋ Yisa yada ta dɩ ʋ sieŋ. ");
INSERT INTO kma_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piita die dɩ wɩarɩ a bie Joopa ma a yʋasɩ; die ʋ bie wo daa wʋnyɩ die dɩ wʋnsɩnana gbaŋtɩ ba wasa wa Simoni tigiŋ me mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Die daa wʋnyɩ die benne Siisiria ma ba wasa wa Koniliawosi, die ʋ yiwo sojasisi jakʋʋŋ ta pɔgɩlɩ sojasisi kɔbɩga ʋ chaakʋ ma. Die ba wasa ʋ chaakʋ Itali tɩŋgbaŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Die wʋnɩŋ aŋaŋ ʋ deŋ mana die jɩama Ŋmɩŋ ta chɩga Ŋmɩŋ. Die ʋ kpaŋŋɩ ʋ gbaŋ pam a suŋŋe Juu vuosi zɔɔlɩntielibe, ta die jʋʋsa Ŋmɩŋ saŋŋa mana. ");
INSERT INTO kma_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Daaŋ kaanɩ die agbaa die dɩ nɩgɩna a tɩaŋ hawasɩ ataa die ʋ daansɩ a ye Ŋmɩŋ malaka dɩ kenne juu ʋ jigiŋ a balɩ a yɩ wa dɩ, “Koniliawosi.” ");
INSERT INTO kma_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniliawosi die dɩ yene malakaka die ŋmaamɩŋ dɩ yigi wo, ta ʋ baarɩ dɩ “N Yɔmʋtieŋ, dɩ bɩa?” Die malakaka dɩ yiŋŋi a balɩ wa dɩ, “Ŋmɩŋ tuo fʋ jʋʋsɩŋ mɩŋ aŋaŋ fʋ yɩnana zɔɔlɩntieliŋ piini diekemba ta bɩ tɩɩnsɩ fʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lele, tʋŋ dembisi bataŋ aŋ ba ga Joopa ma a ga wa daa wʋnyɩ saaŋ dɩ dine Simoni Piita. ");
INSERT INTO kma_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ʋ yiwo chaanʋ a bie gbaŋwʋnsɩrʋ dieke ba wasɩnana Simoni tigiŋ, ta ʋ tigiri dɩ gbigi mʋgɩkpɩɩrɩ.” ");
INSERT INTO kma_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Die malakaka die dɩ balala wɩaha a yɩa wa die dɩ yiŋŋi ga ta va wa, womi die Koniliawosi die dɩ wa ʋ tʋntʋntɩŋ bale aŋaŋ sojasisi wʋnyɩ, vuodieke die dɩ jɩanna Ŋmɩŋ ta bɩ yi ʋ gbaŋ gbaŋ gbɩgbarɩtʋ wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Die ʋ balɩ ba wudieke dɩ yine, ka kʋaŋ chaaŋ ʋ tʋŋ ba Joopa ma ma. ");
INSERT INTO kma_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ka tʋnvʋʋsa die ba benne sieku me a gara wa a keŋ gbigi Joopa, saŋka mi Piita die dɩ ga jʋalɩ kɔsʋŋ sikpeŋ agbaa saŋŋa dɩ ʋ jʋʋsɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kɔŋ die dɩ keŋ yigi wo, die ʋ yaala jaaŋ dɩ ʋ dii; die ba yene dige nyindiikehe die ʋ daansɩ. ");
INSERT INTO kma_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ta die a ye ŋmɩŋsikpeŋ dɩ yuorine, ta jaaŋ kaanɩ dɩ keŋ sʋʋna a sɩɩ sɩba garɩteelikiŋ ba yigine ka kʋanʋa anɩɩsa wa a yaa keŋ sʋʋna tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Die ka ma dɔŋɩsɩ yiri yiri aŋaŋ nyindiekemba dɩ vuunene tɩŋgbaŋ aŋaŋ nembisi. ");
INSERT INTO kma_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ta die ʋ wʋŋ lɔlɩŋ dɩ balala a yɩa wa dɩ, “Piita, hagɩ a kʋʋ a ŋɔbɩ!” ");
INSERT INTO kma_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ama Piita dɩ yiŋŋi balɩ dɩ, “N Yɔmʋtieŋ, aayɩ, n ye ka ŋɔbɩ jadieke tɩ chʋarɩna.” ");
INSERT INTO kma_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Die lɔlɩkʋ dɩ bɩ balɩ yɩ wa bɩbra dɩ, “Da keŋ wa jadieke Ŋmɩŋ dɩ yine kasɩ jadɩngɩtɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Naa die yiwo bʋtaa, ta die jaabʋ dɩ yiŋŋi a ga jʋalɩ ŋmɩŋsikpeŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piita die ye ko yile ʋ daansɩkʋ chɩaŋ, die Koniliawosi die dɩ tʋnna dembiŋ diekemba ba die dɩ ye Simoni tigiri dɩ benne jigidieke a keŋ zie ka sanʋarɩ tɩŋ, ");
INSERT INTO kma_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","a wa a pɩasɩ dɩ, “Chaanʋ bie giena ʋ saaŋ dɩ dɩ Simoni Piita mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ama Piita die ye ko mɩa ʋ baaŋ yi die a sɩba daansɩkʋ chɩaŋ, ta Ŋmɩŋ Haalɩŋ dɩ balɩ yɩ wa dɩ, “Wʋmma dembisi bataa bie giena a dɩ dɩa a yaala fʋ. ");
INSERT INTO kma_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Die wɩa hagɩ a sʋʋŋ ga ta da chɩɩlɩ dɩ fʋ aŋaŋ ba ga, dama manɩŋ n tʋnna ba.” ");
INSERT INTO kma_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Naa chɩaŋ ma, Piita die dɩ sʋʋŋ a ga balɩ dembisisi dɩ, “Manɩŋ nɩ yaala wa. Bɩa wɩa nɩ keŋ?” ");
INSERT INTO kma_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ta ba yiŋŋi balɩ dɩ, “Jakʋʋŋ Koniliawosi tʋnna tɩ. Ʋ yiwo vuovɩɩnɩŋ ta jɩama Ŋmɩŋ ta Juu vuosi mana dɩ faasɩ yɩa wa jɩlɩma pam. Ŋmɩŋ malakasisi kaanɩ die dɩ balɩ a yɩ wa dɩ ʋ wa fʋ a keŋ ʋ tigiŋ me amʋ ʋ nan wʋŋ wudieke fʋ yalla dɩ fʋ balɩ.” ");
INSERT INTO kma_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Die Piita dɩ yaa ba a juu gbaaŋ, die ba dʋa mi tʋŋ dɩ vʋŋ. Tʋŋ die dɩ vʋʋna ʋ yi siri wʋnɩŋ aŋaŋ ba dɩ ga; die ʋ chanchaalɩba bataŋ die dɩ benne Joopa ma wa die dɩ beeli wo. ");
INSERT INTO kma_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Die ka tʋnvʋʋsa die ba ga tʋgɩ Siisiria ma, jigidieke Koniliawosi aŋaŋ ʋ deŋ aŋaŋ ʋ zʋalɩŋ die dɩ kalɩna a chɩɩsa wa. ");
INSERT INTO kma_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Die Piita die dɩ dɩna baa ʋ juu gbaaŋkʋ sʋŋ, ta Koniliawosi die dɩ keŋ tuoli wo sanʋarɩ ma, ta sʋʋŋ gbirigi ʋ nɩŋŋa aŋaŋ jɩlɩma. ");
INSERT INTO kma_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama ta Piita die dɩ baarɩ dɩ, “Hagɩ, dama n gbaŋ gbaŋ n yiwo vuota.” ");
INSERT INTO kma_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piita die ko bala wɩa a yɩa Koniliawosi ta die a ga juo tigiri me, a die ye vuosi pam dɩ lagɩsɩna a kalɩ. ");
INSERT INTO kma_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Die ʋ balɩ a yɩ ba dɩ, “Nɩ gbaŋ gbaŋ nɩ sɩba a baarɩ tɩnɩŋ Juu vuosi mɩra ka yɩ wa sieŋ dɩ tɩ lagɩŋ yaa a kaagɩ vuodieke dɩ kana a ka yi Juu vuoŋ, ama Ŋmɩŋ dagɩ mɩŋ dɩ n daa zetime vuoŋ ʋ kana ka yi Juu vuoke wɩa. ");
INSERT INTO kma_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Die wɩa nɩ tʋnna a wa mɩŋ wa maŋ keŋ ta ka zetiye. Lele nɩ vaa n pɩasɩ nɩ, ‘Bɩa wɩa nɩ tʋŋ a wa mɩŋ?’ ” ");
INSERT INTO kma_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koniliawosi die dɩ baarɩ dɩ, “Deeri kanɩŋ wa saŋka gie gbaŋ gbaŋ agbaa dɩ nɩgɩna a tɩaŋ hawasɩ ataa die maŋ jʋʋsa Ŋmɩŋ n tigiri me, womi maŋ ye daa wʋnyɩ dɩ yeegine nyɩŋnyɩgɩsa dɩ kenne zie n nɩŋŋa, ");
INSERT INTO kma_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a baarɩ dɩ, ‘Koniliawosi! Ŋmɩŋ wʋŋ fʋ jʋʋsɩŋ ta tɩɩnsɩ piini dieke fʋ yɩnana zɔɔlɩntielibe. ");
INSERT INTO kma_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Die wɩa, tʋŋ vuoŋ aŋ ʋ ga Joopa ma a ga wa daa wʋnyɩ ba wasɩna Simoni Piita. Ʋ yiwo chaanʋ a bie Simoni gbaŋwʋnsɩrʋ wa tigiŋ me vuodieke tigiri dɩ gbigine mʋgɩrɩ.’ ");
INSERT INTO kma_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Die wɩa maŋ tʋŋ a wa fʋ lagɩ lagɩ wa, ta fʋ dɩaŋ fʋ kpaŋŋɩ fʋ gbaŋ a keŋ. Tɔ, tɩ mana bie wo Ŋmɩŋ nɩŋŋa dɩ tɩ wʋŋ wudieke mana tɩ Yɔmʋtieŋ dɩ yɩna fʋ nʋaŋ dɩ fʋ balɩ tɩ.” ");
INSERT INTO kma_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Die wɩa Piita die dɩ piili a bala dɩ, “Lele n wa sɩba dɩ dɩ yiwo wusie dɩ Ŋmɩŋ ka luge, ");
INSERT INTO kma_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ama ʋ tuose buuriŋ nɩŋ mana vuodieke dɩ chɩgɩnana wa ta yie wudieke dɩ mʋna. ");
INSERT INTO kma_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nɩ sɩba dɩ Ŋmɩŋ die yɩ wa Izara vuosi wudieke dɩ dagɩna wʋvɩɩnaha wɩa, dɩ Yisa Masia ma tɩnɩŋ aŋaŋ Ŋmɩŋ dɩ bɩ nansɩ aŋaŋ taŋ; wʋnɩŋ Yisa Masia yiwo tɩ mana Yɔmʋtieŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nɩ wɔŋ sɩba wudieke mana die dɩ yine Judia mana ma ma mɩŋ. Die wɩaha gie mana die piili wo Galili me, Jɔɔn die dɩ bala dɩ vuoŋ mana tuo Ŋmɩŋ nyaaŋ sɩɩla kʋaŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ŋmɩŋ die nagɩ wa ʋ Halɩkasɩka aŋaŋ hagɩrɩŋ a yɩ Yisa, vuodieke dɩ nyɩna Nazeriti wa. Die ʋ bie wo Yisa jigiŋ saŋŋa dieke die ʋ dɩna dɩ dɩa a tʋma tʋnvɩɩna a yɩa vuosi ta gbaama vuodiekemba die dɩ benne Sitaani nuusi me. ");
INSERT INTO kma_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tɩ mana die ye Yisa die dɩ yine wudieke Jerusalemi tɩŋ ma aŋaŋ Juu vuosi tɩgɩhanɩŋ ba mana, ta tɩ yiwo ʋ daansɩatieliŋ. Die ba kpaasɩ wa wa dagarɩkɩŋ ma die ʋ kpi. ");
INSERT INTO kma_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama ta Ŋmɩŋ die dɩ sʋgɩrɩ wa kumbu me daraa ataa daraaŋ ta yi ʋ hagɩ ta tɩ ye wo ʋ seŋ yi vuota. ");
INSERT INTO kma_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Daa vuoŋ mana die yene wo. Die dɩ yiwo tɩnɩŋ vuodiekemba die Ŋmɩŋ dɩ vʋarɩna dɩ tɩ yi ʋ daansɩa tieliŋ die yene wo, ta die die ta nyuo aŋaŋ wa ʋ kumbu sʋgɩrɩŋ kʋaŋ chaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ŋmɩŋ die yɩ tɩ nʋaŋ dɩ tɩ mʋʋlɩ aŋaŋ nɩŋŋmɩna a yɩma vuosi dɩ Yisa yine vuodieke ʋ vʋarɩna dɩ ʋ yi vuodiekemba dɩ benne ba mɩsɩ ma aŋaŋ kunti sarɩya diiru. ");
INSERT INTO kma_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ŋmɩŋ naazʋamba mana die baarɩ dɩ vuodieke nɩŋ mana dɩ yine Yisa yada, Ŋmɩŋ nan nagɩ ʋ taalɩ a chaa wa Yisa wa saaŋ ma.” ");
INSERT INTO kma_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piita die dɩ yene ko bala wɩaha ta die Ŋmɩŋ Halɩkasɩ die dɩ keŋ a sʋʋŋ vuodiekemba mana die dɩ wʋnnana ʋ wʋbalɩkaha ma. ");
INSERT INTO kma_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Die dɩ yi Yisa dɩdɩɩsɩrɩŋ diekemba dɩ yine Juu vuosi ta beeli Piita a nyɩŋ Joopa a keŋ wo mamachi aŋaŋ Ŋmɩŋ die dɩ nagɩna ʋ piini dieke dɩ yine ʋ Halɩkasɩka a yɩ vuodiekemba dɩ kana ka yi Juu vuosi wo. ");
INSERT INTO kma_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dama die ba wʋŋ ba dɩaŋ ba balɩnana wʋbalɩkɩ gaasɩ ta bɩra Ŋmɩŋ saaŋ. Womi Piita dɩ baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Vuosi gie tuo wo Ŋmɩŋ Halɩkasɩka sɩba die tɩ tuone die wo, vuoŋ beri a baaŋ bɩagɩ kagɩ ba dɩ ba daa sɩɩ Ŋmɩŋ nyaaŋ?” ");
INSERT INTO kma_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Die wɩa die ʋ yɩ nʋaŋ dɩ ba sɩɩ ba; die ba sɩɩ ba Ŋmɩŋ nyaaŋ Yisa Masia saaŋ ma. Die wɩa die ba balɩ Piita dɩ ʋ wɩɩrɩ ba jigiŋ daraa ale. ");
INSERT INTO kma_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Saŋka mi die Yisa tʋntʋntɩba aŋaŋ Yisa dɩdɩɩsɩrɩba die dɩ benne Judia lʋga mana die dɩ wʋŋ dɩ vuodiekemba dɩ kana ka yi Juu vuosisi gbaŋ tuo Ŋmɩŋ wɩaha. ");
INSERT INTO kma_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Die wɩa Piita die dɩ yiŋŋine a keŋ Jerusalemi ma, Juu vuosi vuodiekemba die dɩ yine Yisa dɩdɩɩsɩrɩŋ bataŋ dɩ piili a nɩga nɩnhagɩrɩŋ aŋaŋ wa. Die ba yaala vuodiekemba dɩ kana ka yi Juu vuosi ta yi Yisa dɩdɩɩsɩrɩŋ gobi ba kɔla, ");
INSERT INTO kma_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ta baarɩ dɩ, “Fʋnɩŋ ga bie wo vuodiekemba dɩ kana ka yi Juu vuosi ta die aŋaŋ ba gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Womi Piita die dɩ piili a bala ba wudieke gbaŋ gbaŋ die dɩ yine dɩ: ");
INSERT INTO kma_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Die n bie wo Joopa tɩŋ ma a jʋʋsa Ŋmɩŋ ta keŋ a ye ŋmɩŋsikpeŋ dɩ yuorine ta jaaŋ kaanɩ dɩ sɩna sɩba garɩteelikiŋ dɩ kenne sʋʋŋ n jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Die n daansɩna ka sʋkʋ die maŋ ye tigiŋ dɔŋɩsɩ aŋaŋ haagɩŋ dɔŋɩsɩ aŋaŋ nyinvuuke aŋaŋ nembisi. ");
INSERT INTO kma_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ta die maŋ wʋŋ lɔlɩŋ dɩ balala yɩa mɩŋ dɩ, ‘Piita, hagɩ a kʋʋ nyinti gie a ŋɔbɩ.’ ");
INSERT INTO kma_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Die maŋ yiŋŋi a balɩ dɩ, ‘N Yɔmʋtieŋ n kaaŋ bɩagɩ yi die, n ye ka ŋɔbɩ jadieke tɩ chʋarɩna.’ ");
INSERT INTO kma_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ta lɔlɩkʋ dɩ bɩ nyɩŋ arɩzanna ma a balɩ yɩ mɩŋ bɩbra dɩ, ‘Dɩɩ yi Ŋmɩŋ dɩ keŋ baa dɩ jaaŋ vɩɩna aŋaŋ diile da keŋ baa ka ka mʋ aŋaŋ diile.’ ");
INSERT INTO kma_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Naa die yiwo die bʋtaa, ta jaabʋ mana die dɩ yiŋŋi ga arɩzanna ma. ");
INSERT INTO kma_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Lele womi dembisi bataa die dɩ nyɩna Siisiria dɩ keŋ zie tigi dieke n benne wo sanʋarɩ tɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Die wɩa Ŋmɩŋ Halɩkasɩka die dɩ balɩ yɩ mɩŋ dɩ n gamma aŋaŋ ba ta da vaa ka mugisi mɩŋ. Womi Yisa dɩdɩɩsɩrɩŋ bayʋaba diekemba die dɩ benne Joopa ma die dɩ beeli mɩŋ tɩ ga Siisiria a ga Koniliawosi tigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ʋ balɩ tɩ dɩ Ŋmɩŋ malaka nyɩnna ʋ jigiŋ. Dɩ ʋ tʋŋ aŋ ba ga Joopa a ga wa vuoŋ wʋnyɩ saaŋ dɩ dine Simoni Piita. ");
INSERT INTO kma_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dɩ Piita wa nan balɩ wa wʋnɩŋ aŋaŋ ʋ tigiŋ vuosi mana dɩ baaŋ nan yi die a ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Die n piiline a bala wa, die Ŋmɩŋ Halɩkasɩ die dɩ a keŋ a sʋʋŋ ba ma sɩba die dɩ kenne sʋʋŋ tɩ ma piiliku me wo. ");
INSERT INTO kma_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mi die maŋ tɩɩnsɩ tɩ Yɔmʋtieŋ Yisa die dɩ balla dɩ, ‘Jɔɔn die sɩwa aŋaŋ nyaaŋ ama Ŋmɩŋ nan sɩɩ nɩ aŋaŋ ʋ Halɩkasɩka.’ ");
INSERT INTO kma_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dɩɩ yi Ŋmɩŋ dɩ yɩ banɩŋ vuodiekemba dɩ kana ka yi Juu vuosi piini dieke die ʋ yɩna tɩ saŋŋa dieke die tɩ yine tɩ Yɔmʋtieŋ Yisa Masia yada wa; mɩnɩa yine mɩŋ dɩ n kagɩ Ŋmɩŋ dɩ ʋ da yi wudieke ʋ yaalala ʋ yi?” ");
INSERT INTO kma_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Die ba wʋnna Piita balɩkʋ wa, die ba ka bɩ nɩgɩ nɩnhagɩrɩŋ ta piili a bɩra Ŋmɩŋ a bala dɩ, “Lele Ŋmɩŋ vaa vuodiekemba dɩ kana ka yi Juu vuosi dɩ ba vaa ba tʋmbɩatɩ ta yi Yisa dɩdɩɩsɩrɩŋ ta ye miivoli dieke dɩ wone kpatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Die Sitiiveni kʋʋla kʋaŋ chaaŋ mugisibɩaŋ die dɩ keŋ Yisa dɩdɩɩsɩrɩŋ ma die ba chɩgɩ jaasɩ jigiŋ mana. Die bataŋ die chɩgɩ ga Fonisia aŋaŋ Saapurusi aŋaŋ Antiyoku ta die mʋʋla Yisa wɩa a yɩa Juu vuosi nyɩɩna ma. ");
INSERT INTO kma_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama Yisa dɩdɩɩsɩrɩŋ dieke dɩ yine Saapurusi vuosi aŋaŋ Saarini vuosi die dɩ ga Antiyoku a ga mʋʋla tɩ Yɔmʋtieŋ Yisa wʋvɩɩnaha a yɩa vuodiekemba dɩ kana ka yi Juu vuosi. ");
INSERT INTO kma_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Die Ŋmɩŋ hagɩrɩŋ die dɩ bie ba jigiŋ, die vuosi pam die dɩ tarɩgɩ ba beriŋ ta yi Yisa yada. ");
INSERT INTO kma_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Die Yisa dɩdɩɩsɩrɩŋ diekemba dɩ benne Jerusalemi ma wa dɩ wʋŋ wudieke dɩ yinene wo, ta die tʋŋ Banabasi Antiyoku ma. ");
INSERT INTO kma_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Die ʋ gana a ga tʋgɩ mi a ye Ŋmɩŋ dɩ suŋŋine be die wo, ʋ sʋŋ die dɩ fɩalɩ ta die ʋ kpaŋŋɩsɩ ba mana dɩ ba da vaa Yisa kʋaŋ dɩɩsɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi die yiwo vuovɩɩnɩŋ ta yaa yada pam ta suuli aŋaŋ Ŋmɩŋ Halɩkasɩka, die vuosi pam die dɩ keŋ yi Yisa yada ta bɩrɩŋ ʋ dɩdɩɩsɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Die Banabasi dɩ ga Taasusi dɩ ʋ yaalɩ Sɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Die ʋ yene wo wo, die ʋ yaa wa a yiŋŋi keŋ Antiyoku, mi ba bale wo mana die dɩ nagɩ biŋ mʋʋmɩŋ a lagɩma aŋaŋ Yisa dɩdɩɩsɩrɩba ta dagɩ vuosi pam mi Ŋmɩŋ wɩa. Die dɩ yiwo Antiyoku ma die ba woliŋ wa Yisa dɩdɩɩsɩrɩŋ dɩ, “Kirisito vuosi.” ");
INSERT INTO kma_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Die saŋka mi gbaŋ gbaŋ die Ŋmɩŋ naazʋalɩŋ bataŋ die dɩ benne Jerusalemi ma dɩ keŋ Antiyoku. ");
INSERT INTO kma_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ba wʋnyɩ saaŋ die yine Agabusi, ta Ŋmɩŋ Haalɩŋ die dɩ suŋŋi wo ʋ balɩ dɩ kɔŋ bɩaŋ nan nan jigiŋ mana dʋnɩa ma. Die dɩ keŋ yi mɩŋ saŋŋa dieke Kolodiasi dɩ yine naakpɩɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Die Yisa dɩdɩɩsɩrɩŋ dɩ benne Antiyoku ma wa die dɩ saŋ dɩ ba nan suŋŋi ba nɩmballɩ diekemba dɩ benne Judia ma, dɩ vuoŋ mana chɩasɩ ʋ baaŋ nan bɩagɩ die. ");
INSERT INTO kma_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Die ba yi die a nagɩ ligirehe a tʋŋ Banabasi aŋaŋ Sɔɔli dɩ ba yaa ga yɩ Yisa dɩdɩɩsɩrɩŋ nyɩŋkʋraha dɩ benne Judia ma. ");
INSERT INTO kma_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Saŋka gie mi gbaŋ gbaŋ naakpɩɩŋ Herodi die dɩ mugise Yisa dɩdɩɩsɩrɩba bataŋ. ");
INSERT INTO kma_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Die ʋ yi sojasi nʋaŋ ba gobi Jemisi, Jɔɔn nɩmbʋa sikpeŋ aŋaŋ jɩbɩwaŋ. ");
INSERT INTO kma_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Die ʋ yene ta Juu vuosi sʋgɩtɩ fɩalɩya wa aŋaŋ wudieke ʋ yine wo, die ʋ vaa ba yigi Piita saŋŋa dieke ba dinene paanʋ dieke ba kana ka naga dabɔtɩ a yie wo dʋʋgaka. ");
INSERT INTO kma_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Die ʋ yigine Piita wa kpatɩ wa ʋ yi ba ligi wo dansarɩka ma ta yɩ nʋaŋ dɩ sojasi lagɩmɩŋ lagɩmɩŋ bʋnɩɩsa gbara wa a tarɩgɩma taŋ. Die lagɩmɩŋ mana die yiwo sojasi banɩɩsa. Ta a yile sɩba ʋ vʋarɩ wa gasɩtɩaŋkʋ dʋʋgaka saŋŋa a dii ʋ sarɩya yaalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Die wɩa, die Piita die dɩ bie dansarɩka ma ta Yisa kʋaŋandɩɩsɩrɩba die dɩ faasɩ a jʋʋsa Ŋmɩŋ a yɩa wa. ");
INSERT INTO kma_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Die tʋŋ dɩ bala ka vʋŋ aŋ Herodi nagɩ Piita a yɩ vuosisi, dɩnɩŋ daarɩ yuku mi die Piita dɩ ye ko bɔbɩ aŋaŋ chɔrɩma a dʋa gʋʋra sojasi bale sʋnsʋŋ. Die ba bɔbɩ chɔrɩmaha kaanɩ aŋaŋ sojasi wʋnyɩ ʋ nuudiigiŋ chaaŋ ta kaanɩ dɩaŋ dɩ bɔbɩ ʋ nuugalɩ chaaŋ sojasi ta sojasisi bataŋ dɩaŋ dɩ gbarɩ dansarɩkaka sanʋadaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Womi ta Ŋmɩŋ malaka die dɩ keŋ nyɩŋ, ta chaanɩŋ dɩ chaaŋ dansarɩka ka ma. Die malakaka dɩ dɔŋ dɔŋ Piita bɩŋkpɩaŋ ma a sugiri wa ta baarɩ dɩ, “Hagɩ lagɩ lagɩ!” Ta ʋ hagɩ. Die ʋ hagɩna wa, chɔrɩma ha dɩ nyɩŋ ʋ nuusi me a nan. ");
INSERT INTO kma_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malakaka dɩ balɩ wa dɩ, “Mɩŋŋɩ bɔbɩ fʋ gbanɩŋ ta sʋʋ fʋ nɩɩra.” Piita dɩ yi die. Die malakaka dɩ bɩ balɩ dɩ, “Yeegi fʋ jayeekiŋ a dɩa mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piita die dɩ dɩ malakaka a nyɩŋ dansarɩka ka ma, ama die ʋ ka sɩba dɩ ʋ daansa mɩŋ yaa ka seŋ yie mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Die ba ga garɩsɩ nɩŋŋaŋ sojasisi die dɩ gbarɩna wa aŋaŋ banɩŋ ba die dɩ diisine wo ta die keŋ tʋgɩ kʋʋtɩ gbɩabɩ dieke dɩ benne gaamɩŋ ma die dɩ yuorinene a juo tɩka sʋŋ, die ka gbaŋ gbaŋ ka yuori. Die ba chʋŋ a nyɩŋ a chʋŋ a sʋʋna siekpɩɩkʋ ma womi malakaka die dɩ bɩa ta va Piita. ");
INSERT INTO kma_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Die Piita dɩ wa mɩŋŋɩ wudieke dɩ yinene wo ta baarɩ dɩ, “Lele n sɩba a baarɩ dɩ seŋ yiwo wusie, dɩ Ŋmɩŋ tʋnna ʋ malaka ʋ keŋ vʋarɩ mɩŋ a nyɩŋ Naaŋ Herodi nuusi me, ta bɩ vʋarɩ mɩŋ a nyɩŋ Juu vuosisi die dɩ yilinene dɩ ba yi mɩŋ die wo mana mana ma ma.” ");
INSERT INTO kma_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Die ʋ mɩŋŋɩna naa wa, die ʋ ga Jɔɔn Maki nuŋ Meri tigiŋ. Die vuosi pam die lagɩsɩna mi a jʋʋsa Ŋmɩŋ ");
INSERT INTO kma_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piita die dɩ ga kpaasɩ sanʋarɩ ta havʋʋbiŋ wʋnyɩ die dɩ yine tʋntʋntʋ mi ta Roda die dɩ keŋ dɩ ʋ ye vuodieke dɩ kpaasɩnana wa. ");
INSERT INTO kma_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Die ʋ mɩŋŋɩna Piita lɔlɩkʋ die dɩ yiwo nansɩŋ die ʋ chɩgɩ a yiŋŋi a ga ta ka yuori sanʋarɩ, a nata a baarɩ dɩ, “Piita zie sanʋarɩ tɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Die ba balɩ wa dɩ, “Juo yɩɩŋyaatɩ.” Ama die ʋ kpaŋŋɩ ʋ gbaŋ a bala dɩ dɩ yiwo wusie. Die ba baarɩ dɩ, “Dɩ nan yiwo ʋ malaka.” ");
INSERT INTO kma_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ta Piita die dɩ ye ko a kpaasa sanʋarɩ, die ba ga yuori a ye wo, die dɩ yi be mamachi. ");
INSERT INTO kma_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Die ʋ kɔtɩ ʋ nuuŋ dɩ ba tarɩ watɩ, ta balɩ ba tɩ Yɔmʋtieŋ dɩ yine die a vʋarɩ wa a nyɩŋ dansarɩka ka sʋŋ. Ta die balɩ dɩ, “Nɩ balɩ Jemisi aŋaŋ Yisa dɩdɩɩsɩrɩ banɩŋ ba wudieke dɩ yine.” A kʋaŋ chaaŋ ʋ nyɩŋ mi a ga jigigaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Die tuŋ dɩ vʋʋna sʋkʋʋŋ die dɩ faasɩ mugisi sojasisi die dɩ gbarɩna wa. Die ba pɩasa taŋ dɩ, “Bɩa yine Piita wa?” ");
INSERT INTO kma_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Naaŋ Herodi die dɩ yɩ nʋaŋ dɩ ba yaalɩ wa, ama die ba ka ye wo. Die wɩa die ʋ vaa ba pɩasɩ gbɩgbarɩtɩba wʋpɩasɩka ta die yi nʋaŋ dɩ ba kʋʋ ba. Naa kʋaŋ chaaŋ, Naaŋ Herodi die dɩ nyɩŋ Judia a sʋʋŋ ga Siisiria a die yi daraa ale mi. ");
INSERT INTO kma_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodi die dɩ jɩɩ sɩnyɩɩrɩŋ aŋaŋ Taya aŋaŋ Sidoni vuosi; die wɩa die ba lagɩŋ taŋ dɩ ba ga ye wo. Die ba woliŋ ye Bilasitusi dɩ ʋ suŋŋi be, die ʋ yiwo vuodieke die dɩ yine naaŋ wa tigiri nyɩŋkʋraha wʋnyɩ. Die ba keŋ ga Herodi jigiŋ a ga nɩgɩ nɩɩpɔɔŋ dɩ ʋ vaa sʋgɩfɩalɩŋ bemme ba sʋnsʋŋ dama Taya aŋaŋ Sidoni die yese ba nyindiike a nyɩna naaŋ Herodi tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Die naaŋ Herodi die vʋarɩ daaŋ a zieŋ, die daarɩ dɩ tʋgɩna wa Herodi die dɩ yeegi ʋ naala nyiŋyeekikpɩɩma, ta nyɩŋ kalɩ ʋ naaŋ gbaŋtɩ mama ta balɩ wɩa a yɩ vuosisi. ");
INSERT INTO kma_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Die vuosisi die dɩ natɩ a baarɩ dɩ, “Ʋ lɔlɩkʋ sɩɩ sɩba ŋmɩŋ daa vuota.” ");
INSERT INTO kma_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lele wo mi Ŋmɩŋ malaka die dɩ vaa yʋagɩbɩaŋ dɩ yigi wo, die ʋ nyuuti die dɩ suuli aŋaŋ gbarɩtɩ a nyuo wo ʋ kpi dama die ʋ ka yi Ŋmɩŋ kanɩŋ jɩlɩma ka mi. ");
INSERT INTO kma_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ama saŋka mi die vuosi pam die dɩ wʋŋ wɩaha ta yi yada. ");
INSERT INTO kma_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Saŋŋa dieke Banabasi aŋaŋ Sɔɔli die dɩ kpatɩna ba tʋʋmaha dieke die ba gana dɩ ba yiwo, die ba nagɩ Jɔɔn Maki a gʋtɩ ba ma a nyɩŋ Jerusalemi a ga Antiyoku. ");
INSERT INTO kma_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiyoku ma, die Ŋmɩŋ naazʋalɩŋ aŋaŋ dɩdagɩrɩŋ bataŋ die bie wo Yisa dɩdɩɩsɩrɩŋ sʋŋ: die ba yine Banabasi aŋaŋ Simiani (vuodieke die ba wasɩnana Daasɔbɩlɩŋ), aŋaŋ Lususi, vuodieke dɩ nyɩna Sarene aŋaŋ Manani (vuodieke die ba lagɩŋ na a wubi aŋaŋ Naaŋ Herodi die ba yine ballɩbɩsɩ) aŋaŋ Sɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Daaŋ kaanɩ die ba jɩanna tɩ Yɔmʋtieŋ ta bɔbɩ nʋaha, Ŋmɩŋ Halɩkasɩka die dɩ balɩ a yɩ ba dɩ, “Nɩ vʋarɩ Banabasi aŋaŋ Sɔɔli aŋ ba tʋŋ tʋŋ dieke wɩa n wana ba wa dɩ ba tʋŋ wa.” ");
INSERT INTO kma_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Naa kʋaŋ chaaŋ die ba bɩ bɔbɩ nʋa ta jʋʋsɩ Ŋmɩŋ ta nagɩ ba nuusi a dɩɩsɩ ba ma ta die taaŋ ba ba ga. ");
INSERT INTO kma_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Saŋŋa dieke Ŋmɩŋ Halɩkasɩka die dɩ tʋnna Banabasi aŋaŋ Sɔɔli wa dɩ ba ga tʋŋ ʋ tʋʋmaha, die ba sʋʋŋ ga Selusia ma a nagɩ haarɩŋ a ga Salamasi, tɩgɩdieke die benne Saapurusi tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Die ba tʋgɩna Salamisi ma wa die ba ga juu Juu vuosi Ŋmɩŋ jɩamɩŋ juone me a ga mʋʋlɩ Ŋmɩŋ wɩaha mi. Die Jɔɔn Maki die bie mi a yi ba susuŋŋiru. ");
INSERT INTO kma_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ka kʋaŋ chaaŋ die ba nyɩŋ Salamisi ma ta die a dɩa a tɩaŋ ga tʋgɩ Pafosi. Mi die ba haarɩ daa wʋnyɩ die dɩ yine yuŋaŋvuoŋ ʋ saaŋ dɩ dɩ Bajaasusi, ta yi Juu vuodieke die dɩ gaanana vuosi dɩ ʋ yiwo Ŋmɩŋ naazʋa. ");
INSERT INTO kma_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Die ʋ yiwo tɩŋgbaŋka mi jakʋʋŋ Sejusi Pɔɔlusi zʋa. Die jakʋʋrɩ die yiwo yɩantieŋ ta die tʋŋ wa Banabasi aŋaŋ Sɔɔli dɩ ba keŋ a balɩ Ŋmɩŋ wɩa aŋ ʋ wʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ama die yuŋaŋvuoke, vuodieke die dɩ dine Elimasi Giriiki jabalɩkɩŋ ma wa die ka saagɩ a yɩ ba: ta die mɩa dɩ ʋ kagɩ jakʋʋrɩ aŋ ʋ daa keŋ yi Yisa yada. ");
INSERT INTO kma_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Womi die Ŋmɩŋ Halɩkasɩ die dɩ suuli Sɔɔli vuodieke die dɩ bɩna a dɩ Pɔɔli, die ʋ daansɩ yuŋaŋvuoke die ");
INSERT INTO kma_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ta balɩ wa dɩ, “Fʋnɩŋ fʋ yiwo Sitaani bʋa ta bɩ yi tʋnvɩɩna mana dataaŋ ta suuli aŋaŋ wʋbɩatɩ yiri yiri mana, ta mɩa saŋŋa mana dɩ fʋ tarɩgɩ Ŋmɩŋ wusie wʋbalɩkaha a yi ŋmɩnchɩbɩsɩ. ");
INSERT INTO kma_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lele Ŋmɩŋ baa ʋ datɩ fʋ tɩbɩŋ ta vaa fʋ yɩɩŋ ta kaaŋ dɩ yese daraa ale.” Lele womi die mɩɩlɩgɩsɔbɩlɩŋ dɩ nan daa wa nine me ta ʋ dɩ dɩa a gaba a yaala vuodieke dɩ baaŋ nan yigi ʋ nuuŋ me. ");
INSERT INTO kma_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Die jakʋʋrɩ dɩ yene wudieke dɩ yine wo, die ʋ yi Yisa yada, dama die dɩ faasɩ yiwo mamachi aŋaŋ wudieke ba dagɩnana yaa gamma tɩ Yɔmʋtieŋ ma wa. ");
INSERT INTO kma_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Naa kʋaŋ chaaŋ die Pɔɔli aŋaŋ ʋ chanchaalɩba die dɩ nagɩ haarɩŋ a nyɩŋ Pafosi me a ga Pega dɩ benne Pamifilia tɩŋgbaŋ ma, mi die Jɔɔn Maki dɩ vaa ba ta yiŋŋi ga Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Die ba nyɩŋ Pega a tɩaŋ ga Antiyoku dɩ benne Pisidia tɩŋgbaŋ ma. Die davʋʋsɩkɩrɩ daarɩ die ba ga juu Ŋmɩŋ jɩamɩŋ juoku me a sʋʋŋ kalɩ. ");
INSERT INTO kma_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Die ba karɩnna Mosisi mɩraha sʋŋ aŋaŋ Ŋmɩŋ naazʋalɩba maagɩkʋ sʋŋ a kpatɩ wa, Ŋmɩŋ jɩamɩŋ juoku sʋŋ nyɩŋkʋraha dɩ balɩ ba dɩ, “Tɩ nɩmballɩ, dɩɩ yi nɩ yaa wʋvɩɩna a baaŋ nan balɩ yɩ vuosisi gie nɩ balɩ.” ");
INSERT INTO kma_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Womi Pɔɔli die dɩ hagɩ zie ta a kɔtɩ ʋ nuuŋ ta piili a bala dɩ: “Nɩnɩŋ Izara vuosi aŋaŋ vuodiekemba mana dɩ jɩanna Ŋmɩŋ dieke Izara vuosi dɩ jɩanna, nɩ wʋmma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tɩnɩŋ Izara vuosi Ŋmɩŋ die vʋarɩna tɩ chɔɔŋkʋʋlɩba a yi ba faasɩ dala saŋŋa dieke die ba benne Ijipiti me a yi chaamba wa. Wʋnɩŋ Ŋmɩŋ die vʋarɩna ba a nyɩŋ mi aŋaŋ ʋ hagɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ta die daansɩ ba bɩna baŋɩsɩ-nɩɩsa saŋŋa dieke die ba benne hagɩrɩ ma, aŋaŋ ba dene ka tuo ʋ nʋarɩ mana. ");
INSERT INTO kma_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Die ka kʋaŋ chaaŋ die ʋ chʋʋsɩ buuriŋ ayʋpɔyɩ die dɩ benne Keenani tɩŋgbaŋ ma ta die vaa ʋ gbaŋ gbaŋ ʋ vuosi Izara vuosi dɩ sɩɩ. ");
INSERT INTO kma_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Wɩaha gie mana die yiye mɩŋ bɩna kɔbɩsɩ-nɩɩsa aŋaŋ baŋɩsɩ-nʋ sʋnsʋŋ. “Saŋŋa dieke ba sɩna tɩŋgbaŋka, Ŋmɩŋ die dɩ yɩ ba nɩŋŋandɩɩsɩrɩŋ dɩ ba dii ba nɩŋŋa a ga tʋgɩ saŋŋa dieke Ŋmɩŋ naazʋa Samuli dɩ kenne. ");
INSERT INTO kma_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Naa kʋaŋ chaaŋ die ba bɩ keŋ pɩasɩ Ŋmɩŋ naazʋa Samuli dɩ ʋ yɩ ba naaŋ, die wɩa, Ŋmɩŋ die dɩ vʋarɩ Sɔɔli, Kisi bʋa vuodieke dɩ nyɩna Benjamani buuriŋ ma dɩ ʋ yi ba naaŋ. Die ʋ yiwo ba naaŋ bɩna baŋɩsɩ-nɩɩsa. ");
INSERT INTO kma_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Die Ŋmɩŋ dɩ keŋ wuuri ʋ naarɩ ta vaa Davidi dɩ dii naarɩ. Naa die Ŋmɩŋ dɩ balɩ yaa gamma Davidi ma dɩ, ‘Davidi, Jese bʋa wa yine daa dieke chanchaalɩŋ n yaalala, ʋ yie wudieke mana n yaalala dɩ ʋ yi.’ ");
INSERT INTO kma_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ŋmɩŋ die dɩ yɩ nʋaŋ dɩ Davidi haagɩsɩ ma vuoŋ wʋnyɩ bala ʋ keŋ a gbatɩ Izara vuosi a taaŋ, wʋnɩŋ vuoke mi yine Yisa. ");
INSERT INTO kma_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ama Jɔɔn die dɩ woliŋ keŋ a mʋʋlɩ a yi Izara vuosi mana dɩ ba vaa ba tʋmbɩatɩ aŋ ʋ sɩɩ ba Ŋmɩŋ nyaabʋ, ka kʋaŋ chaaŋ Yisa die dɩ wa keŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Die Jɔɔn tʋʋmaha die dɩ gbine kpatɩŋ die ʋ pɩasɩ vuosisi dɩ, ‘Mɩnɩa nɩ yile dɩ yi ye? N ka yi Ŋmɩŋ Vuovʋarɩkɩŋ Masia wa. Nɩ wʋmma, wʋnɩŋ ʋ baa ʋ keŋ wo n kʋaŋ chaaŋ ta maŋ ka mʋ dɩ n vʋarɩ ʋ nɩɩra gbaŋ.’ ");
INSERT INTO kma_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Lele, nɩnɩŋ Abarahami haagɩsɩ aŋaŋ nɩnɩŋ vuodieke dɩ kana ka yi Juu vuosi ta bie giena a jɩama Ŋmɩŋ, nɩ wʋmma wudieke Ŋmɩŋ dɩ yɩna tɩ dɩ ka daga tɩ baaŋ nan yi die a ye gbatɩtaanɩŋ dama ka yiwo vuoŋ mana sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Die vuodiekemba die dɩ benne Jerusalemi ma aŋaŋ ba nyɩŋkʋraha die ka sɩba a baarɩ dɩ Yisa yine Gbɩgbatɩtaantʋ wa, ta ka bɩ sɩba Ŋmɩŋ naazʋalɩba wʋbalɩkaha ba ŋaana karɩma davʋʋsɩkɩŋ daaŋ mana wa chɩaŋ. Die wɩa die ba balɩ a chʋʋsɩ wa sɩba Ŋmɩŋ naazʋalɩba die dɩ bala die wo. ");
INSERT INTO kma_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aŋaŋ die ba kana a ka ye wudieke ʋ yine a chʋʋsɩ wa ta mʋ dɩ ba kʋʋ wa wa mana, ama die ba balɩ a yɩ Paliti dɩ ʋ yi ba kʋʋ wa. ");
INSERT INTO kma_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Die ba yine wo wudiekemba mana Ŋmɩŋ gbaŋkʋ dɩ bala yaa gamma ʋ ma wa a kpatɩ wa, die ba nagɩ wa a keŋ sʋʋŋ dagarɩkʋ ma a nagɩ wa a ga sʋʋŋ dʋaŋ vɔrɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama ta Ŋmɩŋ die dɩ sʋgɩrɩ wa kumbu me. ");
INSERT INTO kma_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Die ʋ nyɩŋ vuodiekemba die dɩ dɩna ʋ kʋaŋ a nyɩŋ Galili a keŋ tʋgɩ Jerusalemi wa jigiŋ daraa pam. Lele banɩŋ ba wana yi ʋ daansɩatieliŋ vuosisi jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ŋmɩŋ die yɩ wa tɩ chɔɔŋkʋʋlɩba nʋaŋ, ta tɩ bie gie dɩ tɩ bala nɩ wʋvɩɩnaha, ");
INSERT INTO kma_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","dɩ ʋ seŋ yi he mɩŋ a yɩ tɩ tɩnɩŋ vuodiekemba dɩ yine ba haagɩsɩ aŋaŋ ʋ sʋgɩrɩna Yisa a nyɩŋ kumbu me wo. Die Ŋmɩŋ gbaŋkʋ sʋŋ, yɩla die dɩ gʋtɩna bule wa ma dɩ wʋnɩŋ Ŋmɩŋ dɩ baarɩ dɩ, ‘Fʋnɩŋ fʋ yine n Bʋadembiŋ, ta jinne n nan dagɩ vuosi dɩ n seŋ yiwo fʋ Chʋa.’ ");
INSERT INTO kma_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ta Ŋmɩŋ die dɩ bɩ baarɩ dɩ ʋ nan sʋgɩrɩ Yisa kuŋ me ta ʋ kaaŋ bɩ kpi bɩbra. Sɩba Ŋmɩŋ die dɩ bala dɩ, ‘N nan yɩ nɩ nʋaŋ kasɩ dieke gbaŋ gbaŋ die n yɩna Davidi wo.’ ");
INSERT INTO kma_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ta yɩlaha gbaŋkʋ sʋŋ bɩbra Davidi die balɩ Ŋmɩŋ dɩ, ‘Fʋ kaaŋ vaa fʋ Vuokasɩ wa nyɩŋgbanɩŋ hʋʋgɩ vɔrɩŋ ma.’ ");
INSERT INTO kma_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Die Davidi dɩ benne ʋ mɩsɩ ma wa die ʋ dɩ wa Ŋmɩŋ. Die ʋ kpine wo ba guu wo ba buuriŋ vuota jigiguusikiŋ ta ʋ nyɩŋgbanɩŋ dɩ hʋʋgɩ. ");
INSERT INTO kma_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama Ŋmɩŋ die sʋgɩrɩ wa Yisa a nyɩŋ kuŋ me ta ʋ nyɩŋgbanɩŋ die dɩ ka hʋʋgɩya. ");
INSERT INTO kma_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Die wɩa n nɩmballɩ, n yaala nɩ sɩmma dɩ dɩɩ yi nɩ yi Yisa yada Ŋmɩŋ nan nagɩ nɩ wʋbɩatɩ a chaa nɩ. Ama Mosisi mɩraha nɩŋ kaaŋ bɩagɩ a gbatɩ nɩ a nyɩŋ nɩ wʋbɩatɩ ma. ");
INSERT INTO kma_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ama vuodieke mana dɩ yine Yisa yada ye wo gbatɩtaanɩŋ a nyɩŋ bɩaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nɩ sɩmma dɩ wudieke Ŋmɩŋ naazʋalɩba dɩ bala wa da keŋ yi nɩ. Die ba baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Wʋmma, nɩnɩŋ kalinbaantieliŋ, vaa a ka yi nɩ mamachi aŋ nɩ kpi! Nɩnɩŋ vuodiekemba dɩ vʋarɩnana Ŋmɩŋ fala ha aŋaŋ ʋ bala wudieke wo N nan yi wɩɩŋ nɩ yene bie nɩ mɩsɩ ma ta nɩ kaaŋ tuo dii dɩɩ yi vuoŋ dɩ keŋ dagɩ nɩ a chɩasɩ gbaŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Die Pɔɔli aŋaŋ Banabasi die dɩ nyɩnana lagɩŋkʋ jigiri, vuosisi die dɩ jʋʋsɩ ba dɩ ba viiri keŋ davʋʋsɩkɩrɩ daa dieke dɩ kienene wo a faasɩ dagɩ ba wɩaha gie bɩbra. ");
INSERT INTO kma_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Die lagɩŋkʋ die dɩ hagɩna wa, Juu vuosi pam aŋaŋ vuodiekemba die dɩ kana ka yi Juu vuosisi ama ta tarɩgɩ ba jɩamɩŋ ta dɩ Juu vuosi jɩaŋkʋ, die ba mana die dɩdɩ Pɔɔli aŋaŋ Banabasi kʋaŋ. Die Pɔɔli aŋaŋ Banabasi die dɩ kpaaŋ ba pam dɩ ba kpaŋŋɩ ba gbaŋ a dɩa Ŋmɩŋ die aŋ ʋ chɩgɩ ba zɔɔlɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kʋaŋ chaaŋ davʋʋsɩkɩrɩ daarɩ die dɩ tʋgɩna die dɩ ko sɩɩ sɩba tɩka vuosi mana die gana dɩ ba wʋŋ Ŋmɩŋ wɩaha. ");
INSERT INTO kma_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Die Juu vuosi die dɩ yene kpɩkpaakʋ die dɩ yi be sʋgɩyɔɔŋ pam. Die ba zɩa Pɔɔli ta bala chʋʋsa wudieke mana ʋ balala. ");
INSERT INTO kma_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ama Pɔɔli aŋaŋ Banabasi die dɩ wa a faasɩ bala aŋaŋ sikimiŋ dɩ, “Dɩ yiwo talasɩ dɩ tɩ woliŋ balɩ Ŋmɩŋ wɩaha a yɩ nɩnɩŋ Juu vuosi ta wa balɩ vuogaasɩ. Ama nɩnɩŋ nɩ zeti wɩaha mɩŋ ta bɩ yile dɩ nɩ ka mʋ aŋaŋ miivoli dieke dɩ wone kpatɩŋ wɩa, die yine tɩ vasa nɩ, ta gara vuodiekemba dɩ kana ka yi Juu vuosi jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dama nʋarɩ gie Ŋmɩŋ dɩ yɩ tɩ dɩ: ‘Manɩŋ n vʋara fʋ mɩŋ dɩ fʋ yi chaanɩŋ a yi vuodiekemba dɩ kana ka yi Juu vuosisi, amʋ dʋnɩa mana ye gbatɩtaanɩŋ.’ ” ");
INSERT INTO kma_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Die vuodiekemba die dɩ kana ka yi Juu vuosi dɩ wʋnna naa wa, ba sʋgɩtɩ dɩ fɩalɩ, ba bɩrɩ Ŋmɩŋ wʋbalɩkaha. Ta vuodiekemba mana Ŋmɩŋ dɩ vʋarɩna dɩ ba ye miivoli dieke dɩ wone kpatɩkʋ dɩ yi Yisa Masia yada. ");
INSERT INTO kma_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ta tɩ Yɔmʋtieŋ Yisa wɩa die dɩ dɩa mi tɩgɩsɩ mana mana. ");
INSERT INTO kma_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Naa kʋaŋ chaaŋ Juu vuosisi nɩŋŋandɩɩsɩrɩba dɩ ga tɩka dembisi dieke dɩ yine vuokpɩɩma aŋaŋ hɔgʋkpɩɩma die dɩ jɩanna Ŋmɩŋ ta ba yie ba jɩlɩma pam, a vaa ba sɩnyɩɩrɩŋ dɩ hagɩ yaa gamma Pɔɔli aŋaŋ Banabasi ma, ta piili yaala wɩa a yɩa ba a yagɩ ba a nyɩŋ tɩŋgbaŋka mi lʋgɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Die wɩa Pɔɔli aŋaŋ Banabasi die dɩ kpaantɩ ba nataala taŋkɔlɩŋ a taaŋ tɩka mi dɩ ka yi dagɩtɩ bɩaŋ a yɩ ba ta die ga Yikonumi tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ta Yisa dɩdɩɩsɩrɩba dɩ benne Antiyoku ma wa die dɩ suuli aŋaŋ Halɩkasɩka aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Die Pɔɔli aŋaŋ Banabasi dɩ kenne tʋgɩ Yikonumi ma, die ba ga Juu vuosi Ŋmɩŋ jɩamɩŋ juoŋ me a ga mʋʋlɩ Yisa wʋvɩɩna mi sɩba die ba yine die Antiyoku ma wa, ta vuosi pam die yi Yisa yada, bataŋ die yiwo Juu vuosi bataŋ dɩaŋ dɩ yi vuodiekemba dɩ kana ka yi Juu vuosi. ");
INSERT INTO kma_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama ta Juu vuodiekemba dɩ kana ka yi Yisa yada wa dɩ balɩ vuodiekemba dɩ kana ka yi Juu vuosisi dɩ ba da keŋ tuo dii, ta die balɩ ba dɩ wudieke ba bala yaa gamma Yisa ma ka yi wusie. Die wɩa vuodiekemba die dɩ kana ka yi Juu vuosisi dɩ jɩɩ sɩnyɩɩrɩŋ aŋaŋ Yisa dɩdɩɩsɩrɩba die dɩ benne mi wo. ");
INSERT INTO kma_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔɔli aŋaŋ Banabasi die dɩ bie mi daraa pam ta die a faasɩ bala Yisa wɩa aŋaŋ dembisi. Die Ŋmɩŋ die dɩ yɩ ba hagɩrɩŋ die ba tʋŋ mamachi tʋʋma, ta die dagɩ dɩ ba wɩaha yaa gamma ʋ zɔɔlɩnchɩgɩlaha seŋ yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Die tɩka vuosi die dɩ puo bule, bataŋ die dɩ dɩɩ Juu vuosisi kʋaŋ ta bataŋ dɩaŋ dɩdɩ tʋntʋntɩba kʋaŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Die wɩa vuodiekemba dɩ kana ka yi Juu vuosi bataŋ aŋaŋ Juu vuosisi aŋaŋ ba nɩŋŋandɩɩsɩrɩŋ bataŋ die dɩ saŋ dɩ ba yi Pɔɔli aŋaŋ Banabasi bɩaŋ ta taa ba aŋaŋ tana a kʋʋ. ");
INSERT INTO kma_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ama tʋntʋntɩba bale wo dɩ mɩŋŋɩna wudieke dɩ yinene wo die ba maansɩ a nyɩŋ chɩgɩ a ga Likaonia tɩŋgbaŋ ma. Die ba ga wa Lisitira aŋaŋ Debe tɩgɩsɩ aŋaŋ tɩŋkpaŋŋɩsɩ diekemba dɩ gbigine mi. ");
INSERT INTO kma_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mi die ba mʋʋlɩ Ŋmɩŋ wʋvɩɩnaha. ");
INSERT INTO kma_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisitira ma daa wʋnyɩ die dɩ beri a yi gbarɩgɩŋ a nyɩŋ ʋ ballɩbɩsɩ me ta ka bɩagɩ chʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ta die kalɩ mi a wʋmma Pɔɔli wʋbalɩkaha. Pɔɔli die dɩ daansɩ wa die a ye dɩ ʋ yaa yada Yisa ma ta nan bɩagɩ ye gbaamɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Die wɩa Pɔɔli dɩ natɩ aŋaŋ lɔlɩkpɩɩŋ dɩ, “Hagɩ a zie fʋ nagɩsɩ ma!” Daa wa die dɩ hagɩ a yugi a zie ta piili a chʋŋ gilime. ");
INSERT INTO kma_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Die kpɩkpaakʋ dɩ yene wudieke Pɔɔli dɩ yine wo, ba piili a nata ba gbaŋ gbaŋ jabalɩkɩŋ ma dɩ, “Tɩ ŋmɩnaha bɩrɩŋ wa vuota a keŋ sʋʋŋ tɩ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Womi vuosisi die dɩ yi Banabasi saaŋ dɩ Zusi ta Pɔɔli dɩaŋ dɩ Hemisi dama die ʋ yine vuodieke dɩ balla wʋbalɩkaha. ");
INSERT INTO kma_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Die Zusi jɩamɩŋ juoku die zie gbigi wo sanʋa dieke dɩ kenne juu tɩka sʋŋ, die ka bʋkaabɩtʋ aŋaŋ kpɩkpaakʋ dɩ yaa naarasɩ aŋaŋ tɩɩwute a keŋ mi dɩ ba yi kaaba a yɩ Banabasi aŋaŋ Pɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ama Banabasi aŋaŋ Pɔɔli die dɩ wʋnna ba bala ba yi wudieke wo, die ba chɩɩrɩ ba nyinyeeke aŋaŋ sʋgɩchʋʋsɩŋ ta chɩgɩ juu kpɩkpaakʋ sʋŋ a nata dɩ: ");
INSERT INTO kma_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bɩa nɩ yie die? Tɩ yiwo vuota sɩba nɩnɩŋ! Tɩ keŋ wo gie dɩ tɩ mʋʋlɩ Yisa wʋvɩɩnaha aŋ nɩ chɩgɩ nyɩŋ wʋtɔgɩtɩ gie me a keŋ Nabidie Ŋmɩŋ jigiŋ, vuodieke dɩ naanna arɩzanna aŋaŋ tɩŋgbaŋ aŋaŋ nyaakpɩɩbʋ aŋaŋ nyindiekemba mana dɩ benne a sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Saŋŋa dieke dɩ tɩanna wa Ŋmɩŋ die vaa buuriŋ mana dɩ yie ba dʋŋŋʋ. ");
INSERT INTO kma_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ama saŋŋa gie ʋ daga dɩ ʋ seŋ beri mɩŋ aŋaŋ wʋvɩɩŋ diekemba ʋ yinene wo; ʋ yɩnana nɩ nɩɩŋ a nyɩna ŋmɩŋsikpeŋ ta vasa nyinti dɩ bɩrɩma, a yie nɩ nyindiike ta vasa nɩ sʋgɩtɩ dɩ fɩala.” ");
INSERT INTO kma_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Banabasi aŋaŋ Pɔɔli die dɩ bala wudieke wo mana yɔrɩ, die dɩ hagɩrɩ mɩŋ dɩ ba kagɩ ba dɩ ba da yi kaaba a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ka kʋaŋ chaaŋ die Juu vuosi nɩŋŋandɩɩsɩrɩŋ bataŋ die dɩ nyɩŋ Antiyoku dieke dɩ benne Pisidia tɩŋgbaŋ ma aŋaŋ Yikonumi a keŋ balɩ a yiŋŋi kpɩkpaakʋ sʋgɩtɩ ba jɩɩ sɩnyɩɩrɩŋ aŋaŋ Pɔɔli. Ta die taa wa tana a datɩ wa nyɩŋ tɩka lʋgɩŋ ta yile dɩ ʋ kpiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama Yisa dɩdɩɩsɩrɩba die dɩ keŋ taaŋ a giliŋ wo die ʋ keŋ hagɩ zie a yiŋŋi ga tɩka sʋŋ. Ka tʋnvʋʋsa die wʋnɩŋ aŋaŋ Banabasi dɩ nyɩŋ ga Debe ma. ");
INSERT INTO kma_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Die Pɔɔli aŋaŋ Banabasi dɩ mʋʋlɩ Yisa wʋvɩɩnaha Debe ma ta die ye vuosi pam ba yi Yisa yada. Womi die ba yiŋŋi ga Lisitira a nyɩŋ mi ga Yikonumi ta bɩ nyɩŋ mi a ga Antiyoku dɩ benne Pisidia ma. ");
INSERT INTO kma_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Die ba kpaaŋ Yisa dɩdɩɩsɩrɩba ta jʋʋsɩ ba dɩ ba ko yi yada dene. Die ba balɩ ba dɩ, “Dɩ mʋ tɩ tuoli wahala ta ye juu Ŋmɩŋ naarɩ ma.” ");
INSERT INTO kma_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɔɔli aŋaŋ Banabasi die dɩ vʋarɩ nɩŋŋandɩɩsɩrɩŋ Yisa dɩdɩɩsɩrɩba lagɩmɩŋ lagɩmɩŋ mana ma. Womi die ba bɔbɩ nʋa a jʋʋsɩ Ŋmɩŋ dɩ Ŋmɩŋ suŋŋi nɩŋŋandɩɩsɩrɩba mi. ");
INSERT INTO kma_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pɔɔli aŋaŋ Banabasi die dɩ daagɩ Pisidia tɩŋgbaŋ ma a ga Pamifilia tɩŋgbaŋ ma, ");
INSERT INTO kma_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","mi die ba mʋʋlɩ Yisa wɩaha Pega tɩŋ ma. Womi die ba sʋʋŋ ga Atalia ma, ");
INSERT INTO kma_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ta die a wa nyɩŋ mi a nagɩ haarɩŋ a yiŋŋi ga Antiyoku dɩ benne Siria ma. Mi die Yisa dɩdɩɩsɩrɩŋ die wɔŋ nagɩ ba yi Ŋmɩŋ nuusi me dɩ ʋ suŋŋi be ba tʋʋma ma. Ta lele ba wa tʋŋ tʋʋmaha kpatɩ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Die ba kenne a tʋgɩ Antiyoku wa die ba lagɩsɩ Yisa dɩdɩɩsɩrɩba mana. A die a balɩ ba wudieke mana Ŋmɩŋ dɩ suŋŋine be ba yi, aŋaŋ ʋ yuorine sieŋ a yɩ vuodiekemba dɩ kana ka yi Juu vuosi dɩ ba yi Yisa yada a yi ʋ dɩdɩɩsɩrɩŋ dene. ");
INSERT INTO kma_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ama die ba wɩarɩ mi aŋaŋ Yisa dɩdɩɩsɩrɩba a yʋasɩ. ");
INSERT INTO kma_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Saŋŋa mi vuosi bataŋ die dɩ nyɩŋ Judia ma a keŋ Antiyoku ma a die a piili a daga Yisa dɩdɩɩsɩrɩba dɩ ba kaaŋ bɩagɩ ye gbatɩtaantɩŋ sie ba gobi ba kɔla sɩba Mosisi die dɩ dagɩna dene wo. ");
INSERT INTO kma_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Die Pɔɔli aŋaŋ Banabasi aŋaŋ ba die dɩ faasɩ a nɩgɩ nɩnhagɩrɩŋ pam yaa gamma wɩɩrɩ gie ba dagɩnana wa, die ba vʋarɩ Pɔɔli aŋaŋ Banabasi aŋaŋ Yisa dɩdɩɩsɩrɩba bataŋ a tʋŋ ba Jerusalemi ma dɩ ba ga ye Yisa tʋntʋntɩba aŋaŋ ʋ dɩdɩɩsɩrɩŋ nyɩŋkʋraha yaa gamma wɩɩrɩ gie wɩa. ");
INSERT INTO kma_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Die vuodiekemba Yisa dɩdɩɩsɩrɩba dɩ tʋnna wa die dɩ daagɩ Fonisia aŋaŋ Samaria a bala yɩa Yisa dɩdɩɩsɩrɩba dɩ benne mi dɩ vuodiekemba dɩ kana ka yi Juu vuosi bataŋ tarɩgɩ wa ba beriŋ a bɩrɩŋ Yisa dɩdɩɩsɩrɩŋ. Wɩɩrɩ gie die dɩ yi Yisa dɩdɩɩsɩrɩba sʋgɩfɩalɩŋ pam. ");
INSERT INTO kma_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Die ba gana a ga tʋgɩ Jerusalemi wa die Yisa dɩdɩɩsɩrɩba aŋaŋ tʋntʋntɩba aŋaŋ ba nyɩŋkʋra die dɩ tuo be chaantɩ. Die wɩa Pɔɔli aŋaŋ Banabasi die dɩ balɩ ba wudieke mana Ŋmɩŋ dɩ suŋŋine be ba tʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama Farasisi bataŋ die dɩ yine Yisa dɩdɩɩsɩrɩŋ die dɩ hagɩ zie a baarɩ dɩ, “Dɩ yiwo talasɩ dɩ buuri gaasɩ dɩ yine Yisa yada wa gobi ba kɔla ta bɩ dɩa Mosisi mɩraka.” ");
INSERT INTO kma_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Die wɩa, die tʋntʋntɩba aŋaŋ Yisa dɩdɩɩsɩrɩba nɩŋŋandɩɩsɩrɩba dɩ lagɩsɩ taŋ dɩ ba daansɩ jabalɩkɩrɩ. ");
INSERT INTO kma_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Die ba balɩ ka a yʋasɩ aŋaŋ taŋ, ta Piita die dɩ keŋ hagɩ a baarɩ dɩ, “N zʋalɩŋ, nɩ sɩba dɩ saŋŋa dieke dɩ tɩanna wa Ŋmɩŋ die vʋarɩ mɩŋ mɩŋ a nyɩŋ nɩ ma dɩ n mʋʋlɩ Yisa wʋvɩɩnaha a yɩ vuodiekemba dɩ kana ka yi Juu vuosisi, amʋ ba nan wʋŋ ta yi Yisa yada ta bɩrɩŋ ʋ dɩdɩɩsɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ta Ŋmɩŋ, vuodieke dɩ sɩbɩna vuota sʋŋ die dɩ dagɩ dɩ ʋ tuo be mɩŋ ta yɩ ba Halɩkasɩka sɩba die ʋ yɩna tɩ die wo. ");
INSERT INTO kma_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Die Ŋmɩŋ die ka luge tɩnɩŋ aŋaŋ ba, dama die ba yine Yisa yada wa wɩa, die wɩa Ŋmɩŋ dɩ nagɩ ba tʋmbɩatɩ a chaa ba. ");
INSERT INTO kma_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bɩa nɩ yaala nɩ magɩsɩ Ŋmɩŋ? Bɩa nɩ yaala nɩ yi buurigaasɩ diekemba dɩ bɩrɩnna Yisa dɩdɩɩsɩrɩŋ pɔgɩlɩ mɩɩrɩ dieke tɩnɩŋ aŋaŋ tɩ chɔɔŋkʋʋlɩŋ dɩ kana ka bɩagɩ pɔgɩlɩ? ");
INSERT INTO kma_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ama tɩ Yɔmʋtieŋ Yisa die chɩgɩ tɩ wa zɔɔlɩŋ tɩ ye gbatɩtaanɩŋ tɩ yine wo yada wa wɩa sɩba buurigaasɩ die.” ");
INSERT INTO kma_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Die vuoŋ mana die dɩ tarɩ ta wʋmma Banabasi aŋaŋ Pɔɔli die dɩ balala yaa gamma Ŋmɩŋ dɩ yɩna ba hagɩrɩŋ ba tʋŋ mamachi tʋʋma a yɩ vuodiekemba dɩ kana ka yi Juu vuosi dene. ");
INSERT INTO kma_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Die ba bala naa a kpatɩ, Jemisi die dɩ baarɩ dɩ: “N nɩmballɩ, nɩ wʋmma mɩŋ! ");
INSERT INTO kma_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni Piita wɔŋ balɩ tɩ, Ŋmɩŋ dɩ wolinne a ga vuodiekemba dɩ kana ka yi Juu vuosi jigiŋ a vʋarɩ bataŋ ba bɩrɩŋ ʋ gbaŋ gbaŋ ʋ vuosi dene. ");
INSERT INTO kma_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Naa, Ŋmɩŋ naazʋalɩba wʋbalɩka die dɩ dagɩ sɩba dɩ maagɩna Ŋmɩŋ gbaŋtɩ ma dɩ, ");
INSERT INTO kma_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Naa kʋaŋ chaaŋ manɩŋ Nabidie Ŋmɩŋ nan yiŋŋi a keŋ, a keŋ mɩɩ Davidi tɩgɩdieke dɩ nanna wa. N nan mɩɩ ka a zie a nyɩŋ ka chʋʋsɩŋ ma ta vaa ka hagɩrɩma bɩbra. ");
INSERT INTO kma_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ta vuota mana nan keŋ n jigiŋ aŋaŋ vuodiekemba mana dɩ kana ka yi Juu vuosi ta maŋ wa dɩ ba yi n vuosi wo. ");
INSERT INTO kma_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Naa Nabidie Ŋmɩŋ die dɩ balɩ, wʋnɩŋ vuodieke dɩ vana ba sɩba wɩɩrɩ gie a nyɩŋ kʋrɩŋ ma wa.’ ” ");
INSERT INTO kma_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jemisi die dɩ bɩ balɩ a gʋtɩ dɩ, “Dɩ yiwo manɩŋ n sʋŋanyile dɩ tɩ da mugisi buurigaasɩsɩ dɩ yiŋŋine a dɩ Ŋmɩŋ sieŋ aŋaŋ wudieke dɩ tʋana. ");
INSERT INTO kma_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama dɩ mʋ dɩ tɩ maagɩ gbanɩŋ a balɩ ba dɩ ba da keŋ dii jadiiki dieke ba kaabɩna a yi bugile, ta balɩ ba dɩ ba yigi ba gbaŋ aŋaŋ daakpana yaa hɔgʋkpana tʋʋma, ta bɩ daa ŋɔbɩma dɔŋ diekemba ba ŋmʋna kʋʋ ta daa bɩ ŋɔbɩma zɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mosisi mɩraha nɩŋ, ba karɩŋ ha mɩŋ Ŋmɩŋ jɩamɩŋ juone me davʋʋsɩkɩrɩ daaŋ mana kʋrɩŋ ma wa, ta mʋʋlaha tɩŋ mana ma.” ");
INSERT INTO kma_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Die wɩa die tʋntʋntɩba aŋaŋ nɩŋŋandɩɩsɩrɩba aŋaŋ Yisa dɩdɩɩsɩrɩba mana die dɩ yigi zieŋ dɩ ba vʋarɩ dembisi bataŋ aŋ ba dɩa Pɔɔli aŋaŋ Banabasi a ga Antiyoku. Die ba vʋarɩ wa Silasi aŋaŋ Judasi vuodieke saaŋ dɩ bɩna yi Basabasi, vuosi bale wa gie die yiwo Yisa dɩdɩɩsɩrɩba nɩŋŋandɩɩsɩrɩŋ bataŋ ba yɩa jɩlɩma. ");
INSERT INTO kma_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Die ba maagɩ wa gbanɩŋ dɩ: Tɩnɩŋ Yisa tʋntʋntɩba aŋaŋ Yisa dɩdɩɩsɩrɩŋ nɩŋŋandɩɩsɩrɩŋ maagɩna gbaŋkʋ gie a waasa nɩnɩŋ tɩ nɩmballɩ diekemba dɩ kana ka yi Juu vuosi ta bie Antiyoku aŋaŋ Siria aŋaŋ Silisia ma mana. ");
INSERT INTO kma_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tɩ wʋŋya dɩ tɩ vuosi bataŋ keŋ nɩ jigiŋ, a balɩ wɩa ataŋ dɩ mugisi nɩ pam ta chʋʋsɩ nɩ sʋgɩtɩ, ama tɩnɩŋ tɩ ka tʋŋ ba nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Die wɩa tɩ mana dɩ lagɩsɩ a saagɩ dɩ tɩ vʋarɩ dembisi bataŋ a tʋŋ ba aŋaŋ tɩ nɩmballɩ choti Banabasi aŋaŋ Pɔɔli nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Vuosi gie, Judasi aŋaŋ Silasi, yiwo vuodiekemba die dɩ nagɩna ba mɩsɩ a dʋaŋ talɩma tɩ Yɔmʋtieŋ Yisa Masia wɩaha gie wɩa. ");
INSERT INTO kma_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judasi aŋaŋ Silasi nan bɩ balɩ nɩ ka chɩaŋ, wudiekemba tɩ maagɩnana wa. ");
INSERT INTO kma_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ŋmɩŋ Halɩkasɩka die dagɩ tɩ mɩŋ dɩ tɩ da keŋ nagɩ mɩrɩ gaasɩ a gʋtɩ nɩ bɩbra. ");
INSERT INTO kma_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Wudieke dɩ kana ka mʋ dɩ nɩ yi wʋnna: Nɩ da keŋ a dii jadiiki dieke mana ba nagɩna a yi kaaba a yɩ bugile, nɩ da keŋ ŋɔbɩ zɩŋ, nɩ da keŋ ŋɔbɩma dɔŋ dieke ba ŋmʋna kʋʋ, ta bɩ yigi nɩ gbaŋ aŋaŋ daakpana aŋaŋ hɔgʋkpana tʋʋma ma. Dɩɩ yi nɩ dɩ wɩaha gie, dɩ nan dɩ vɩɩna a yɩ nɩ. A mana wonde. ");
INSERT INTO kma_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Die ba tʋŋ ba, ba sʋʋŋ ga Antiyoku, mi die ba lagɩsɩ Yisa dɩdɩɩsɩrɩba mana ta nagɩ gbaŋkʋ a yɩ ba. ");
INSERT INTO kma_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Die vuosisi dɩ karɩŋ gbaŋkʋ gie, ba sʋgɩtɩ die dɩ fɩalɩ aŋaŋ ka kpaŋŋɩsɩna ba dene wo. ");
INSERT INTO kma_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Die Judasi aŋaŋ Silasi, vuodiekemba dɩ yine Ŋmɩŋ naazʋalɩŋ die bie ba jigiŋ a yʋasɩ ta die a balɩ wɩa pam a kpaŋŋɩsɩ ba ta yi ba yada dɩ bɩ hagɩrɩ a gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Die ba bie mi a yʋasɩ, ka kʋaŋ chaaŋ Yisa dɩdɩɩsɩrɩba dɩ benne mi wo dɩ taaŋ ba dɩ ba waasɩ tigiŋ, ba yiŋŋi ga vuodiekemba dɩ tʋnna ba jigiŋ. (( ");
INSERT INTO kma_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama ta Silasi die dɩ wɩarɩ mi.)) ");
INSERT INTO kma_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Die Pɔɔli aŋaŋ Banabasi gbaŋ die dɩ yʋasɩ Antiyoku ma, mi banɩŋ aŋaŋ vuosi pam die dɩ daga ta mʋʋla tɩ Yɔmʋtieŋ Yisa wɩa a yɩa vuosi. ");
INSERT INTO kma_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Die dɩ yʋasɩna bɩta Pɔɔli die dɩ balɩ yi Banabasi dɩ, “Vaa aŋ tɩ yiŋŋi ga a kaagɩ tɩ Yisa dɩdɩɩsɩrɩ diekemba dɩ benne tɩgɩ diekemba mana die tɩ mʋʋlɩna tɩ Yɔmʋtieŋ Yisa wɩaha a ye ba sɩna dene.” ");
INSERT INTO kma_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi die dɩ yaala ʋ nagɩ Jɔɔn Maki a gʋtɩ ba ma aŋ ba ga. ");
INSERT INTO kma_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama Pɔɔli die ka yaala dene dama Maki die ka kpatɩ tʋʋmaha aŋaŋ ba ta die vaa ba Pamifilia ma ta yiŋŋi kuli. ");
INSERT INTO kma_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Die Pɔɔli aŋaŋ Banabasi dɩ nɩgɩ nɩnhagɩrɩŋ ta die puo taŋ. Banabasi die dɩ nagɩ Maki ba nagɩ haarɩŋ a ga Saapurusi. ");
INSERT INTO kma_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ta Pɔɔli dɩaŋ dɩ nagɩ Silasi ta Yisa dɩdɩɩsɩrɩba die dɩ nagɩ ba yi Ŋmɩŋ nuusi me dɩ Ŋmɩŋ suŋŋi be. ");
INSERT INTO kma_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Die ba chʋŋ daagɩ Siria aŋaŋ Silisia chaaŋ ma a kpaŋŋɩsa Yisa dɩdɩɩsɩrɩba. ");
INSERT INTO kma_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ka kʋaŋ chaaŋ Pɔɔli aŋaŋ Silasi die dɩ yiŋŋi ga Debe aŋaŋ Lisitira ma, mi die ba haarɩ Yisa dɩdɩɩsɩrʋ wʋnyɩ ba wasɩnana Timoti. Ʋ nuŋ gbaŋ die yiwo Yisa dɩdɩɩsɩrʋ. Die ʋ nuŋ wo yiwo Juu vuoŋ ta ʋ chɔɔŋ dɩ yi Giriiki vuoŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Die Yisa dɩdɩɩsɩrɩba die dɩ benne Lisitira aŋaŋ Ikonumi ma wa die dɩ balɩ wʋvɩɩna yaa gamma Timoti ma. ");
INSERT INTO kma_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔɔli die dɩ yaala ʋ nagɩ Timoti a gʋtɩ ʋ ma aŋ ba dɩa ʋ dɩasɩsɩ, die wɩa die ʋ gobi ʋ kɔlɩ. Die ʋ yi wo die dama Juu vuodiekemba die dɩ benne mi chaakʋ die sɩba a baarɩ Timoti chɔɔŋ yiwo Giriiki vuoŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Die ba dɩna dɩdɩa tɩgɩsɩsɩ, die ba bala a yɩa Yisa dɩdɩɩsɩrɩba mɩrɩ diekemba Yisa tʋntʋntɩba aŋaŋ Yisa dɩdɩɩsɩrɩba nyɩŋkʋraha dɩ benne Jerusalemi ma wa dɩ ziene wo, ta die balɩ ba dɩ ba dɩa ha. ");
INSERT INTO kma_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Die wɩa Yisa dɩdɩɩsɩrɩba yada die dɩ gʋtɩ ta die daaŋ mana vuosi pam dɩ yie yada a gʋta Yisa dɩdɩɩsɩrɩba ma. ");
INSERT INTO kma_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Die Pɔɔli aŋaŋ ʋ zʋalɩba die dɩ dɩa a daagɩ Firigia aŋaŋ Galasia chaakʋ, ama Ŋmɩŋ Halɩkasɩka die ka vaa ba balɩ Yisa wɩa Asia tɩŋgbaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Die ba gana ga tʋgɩ Misia, die ba mɩa dɩ ba juu Bitinia tɩŋ ma, ama Yisa Halɩkasɩka die ka yɩ ba sieŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Die wɩa die ba daagɩ Misia ma a sʋʋŋ ga Tiroasi ma. ");
INSERT INTO kma_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Dɩnɩŋ daarɩ yuku mi, Pɔɔli die dɩ ye ʋ daansa ma vuoŋ wʋnyɩ dɩ nyɩna Masedonia a keŋ zie a jʋʋsa wa dɩ, “Keŋ Masedonia ma a keŋ suŋŋi tɩ!” ");
INSERT INTO kma_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔli daansaha kʋaŋ chaaŋ, die tɩ gɔmɩsɩ lagɩ lagɩ dɩ tɩ nyɩŋ ga Masedonia, dama die tɩ ye a baarɩ Ŋmɩŋ balɩ tɩ dɩ tɩ ga Masedonia chaakʋ a ga mʋʋlɩ Yisa wʋvɩɩnaha a yɩma vuosi mi. ");
INSERT INTO kma_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Die tɩ nagɩ haarɩŋ a nyɩŋ Tirosi a daagɩ ga Samotirasi, ka tʋnvʋʋsa die tɩ ga Niipolisi. Mi die tɩ vaa haarɩkʋ, ");
INSERT INTO kma_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ta nyɩŋ mi a ga Filipi me, jigidieke die dɩ yine tɩgɩkpɩɩŋ Masedonia tɩŋgbaŋ ma. Die ka yiwo Romani vuosi sɩɩtɩ. Die tɩ yi daraa a ŋmɩna mi. ");
INSERT INTO kma_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ka davʋʋsɩkɩrɩ daarɩ die tɩ nyɩŋ tɩka sʋŋ a ga jigidieke dɩ gbigine mʋgɩrɩ, die tɩ yile dɩ Juu vuosi Ŋmɩŋ jʋʋsɩŋ jigiŋ nan dɩ bie mi. Ta die sʋʋŋ kalɩ a bala wɩa aŋaŋ hɔgʋ diekemba dɩ kenne mi wo. ");
INSERT INTO kma_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ba wʋnyɩ saaŋ die yine Lidia, die ʋ nyɩŋ wa Tiatira tɩŋ ma ta yaa garɩŋmɩnɩ diekemba dɩ yalla ligire pam a daa ta die bɩ yi vuodieke dɩ jɩanna Ŋmɩŋ. Ŋmɩŋ die yuori ʋ sʋŋ dɩ ʋ wʋŋ wudieke Pɔɔli dɩ balala wa. ");
INSERT INTO kma_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Die tɩ sɩɩ wʋnɩŋ aŋaŋ ʋ tigiŋ vuosi Ŋmɩŋ nyaaŋ. Ka kʋaŋ chaaŋ ʋ jʋʋsɩ tɩ dɩ, “Dɩɩ yi nɩ sɩba dɩ n seŋ yi tɩ Yɔmʋtieŋ yada aŋaŋ wusie nɩ keŋ a bemme n tigiŋ.” Die tɩ saagɩ ʋ jʋʋsɩkʋ. ");
INSERT INTO kma_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Daaŋ kaanɩ die tɩ keŋ bɩ gara Ŋmɩŋ jʋʋsɩŋ jigiŋ, a tuoli havʋʋbiŋ wʋnyɩ dɩ yine yɔmʋ. Die ʋ yaa wa jɩmbɩaŋ ʋ ma ka yɩa wa hagɩrɩŋ ʋ bɩagɩ bala soriŋ daaŋ wɩa. Die ʋ yie naa a yese ligire pam a yɩa ʋ tieliŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Havʋʋbike gie die dɩdɩ Pɔɔli aŋaŋ tɩ kʋaŋ a nata ŋmɩŋsikpeŋ a bala dɩ, “Dembisi gie yiwo Nabidie Ŋmɩŋ dɩ benne ŋmɩŋsikpeŋ wo tʋntʋntɩŋ. Ba bala nɩ wudieke nɩ baaŋ yi a ye gbatɩtaanɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Die ʋ ko bala naa daraa pam. Ka kʋaŋ chaaŋ Pɔɔli die dɩ keŋ jɩɩ sɩnyɩɩrɩŋ a yiŋŋi a balɩ yi jɩmbɩakʋ dɩ, “Yisa Masia saaŋ ma, n yɩ fʋ nʋaŋ, nyɩŋ ʋ ma!” Lele womi jɩmbɩakʋ die dɩ nyɩŋ ʋ ma. ");
INSERT INTO kma_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Die ʋ tielibe dɩ yene dɩ sie dieke ba nagɩna yese ligirehe chʋʋsɩya wa die ba yigi Pɔɔli aŋaŋ Silasi a datɩ ba ga sarɩya diile jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Die ba balɩ a yɩ Romani nyɩŋkʋraha dɩ, “Dembisi gie yiwo Juu vuosi ta yaala ba chʋʋsɩ tɩ tɩka. ");
INSERT INTO kma_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba daga tɩ wudiekemba tɩnɩŋ Romani vuosi dɩ kana ka mʋ dɩ tɩ yi.” ");
INSERT INTO kma_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Die kpɩkpaakʋ die dɩ benne me gbaŋ die gʋtɩ a yaala ba nɩgɩ Pɔɔli aŋaŋ Silasi. Womi die Romani nyɩŋkʋraha die dɩ wuuri Pɔɔli aŋaŋ Silasi nyinyeeke ta yɩ nʋaŋ dɩ ba vɩɩrɩ ba aŋaŋ kpaasɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Die ba faasɩna a vɩɩrɩ ba a kpatɩ wa, ba nagɩ ba a yi dansarɩka ma, ta die balɩ dansarɩka gbɩgbarɩtʋ wa dɩ ʋ mɩŋŋɩ gbara ba vɩɩnɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Die gbɩgbarɩtʋ wa die dɩ yi sɩba ba bala wa dene. Die ʋ nagɩ ba a yi dansarɩka sʋŋ saasaa ta bɔbɩ ba nagɩsɩ aŋaŋ chɔrɩma a yaa ga bɔbɩ dakʋʋlɩkpɩɩma juoku sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sɩba yuŋ tanseese, Pɔɔli aŋaŋ Silasi die dɩ jʋʋsa Ŋmɩŋ ta chɩa yɩla a bɩra Ŋmɩŋ, ta ba dansarɩka jujuri taŋ dɩ wʋmma ba. ");
INSERT INTO kma_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Lele wo mi tɩŋbaŋka die dɩ dɔŋ bʋnyɩ dansarɩka juoku chɩaŋ. Lagɩ lagɩ ka sanʋaha dɩ yuori ta chɔrɩmaha die dɩ kpaa kpaa dansarɩka jujuribe mana nuusi aŋaŋ ba nagɩsɩ ma ta nan. ");
INSERT INTO kma_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Die dansarɩka gbɩgbarɩtʋ wa die dɩ hagɩna a ye ta sanʋaha yuori ye wo, die ʋ yile dansarɩkaka jujuribe mana chɩgɩ bɩa mɩŋ. Womi die ʋ datɩ a vʋarɩ takoobi dɩ ʋ kʋʋ ʋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ama ta Pɔɔli die dɩ faasɩ a natɩ dɩ, “Da keŋ a yi fʋ gbaŋ daŋŋa ta tɩ mana bie giena.” ");
INSERT INTO kma_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Die gbɩgbarɩtʋ wa die dɩ pɩasɩ a yaalɩ popoli a chɩgɩ juu dansarɩka sʋŋ ta sʋʋŋ gbirigi Pɔɔli aŋaŋ Silasi nɩŋŋa ta ʋ nyɩŋgbanɩŋ mana dɩ cheeli. ");
INSERT INTO kma_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Womi die ʋ dii ba nɩŋŋa a yaa ba a keŋ nyɩŋ ta pɩasɩ ba dɩ, “Nyɩŋkʋra, bɩa maŋ nan yi a ye gbatɩtaanɩŋ?” ");
INSERT INTO kma_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba yiŋŋi a balɩ wa dɩ, “Yi tɩ Yɔmʋtieŋ Yisa yada, ta nan ye gbatɩtaanɩŋ, fʋnɩŋ aŋaŋ fʋ deŋ mana.” ");
INSERT INTO kma_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Womi Pɔɔli aŋaŋ Silasi dɩ balɩ wa aŋaŋ vuodiekemba mana dɩ benne ʋ tigiŋ me Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yuku mi gbaŋ gbaŋ die gbɩgbarɩtʋ wa die dɩ nagɩ ba a ga sugiri ba kʋjagaha, ka kʋaŋ chaaŋ die ba sɩɩ wʋnɩŋ aŋaŋ ʋ tigiŋ vuosi mana Ŋmɩŋ nyaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ta die ʋ wa nagɩ Pɔɔli aŋaŋ Silasi a ga ʋ tigiŋ me a die yɩ ba nyindiike ba dii. Die wʋnɩŋ aŋaŋ ʋ deŋ mana sʋgɩtɩ die dɩ fɩalɩ dama die ba wa yiwo Ŋmɩŋ yada. ");
INSERT INTO kma_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Die ka tʋnvʋʋsa Romani nyɩŋkʋraha die dɩ tʋŋ ba susuŋŋiriŋ dɩ ba ga balɩ gbɩgbarɩtʋ wa dɩ ʋ vaa Pɔɔli aŋaŋ Silasi ga. ");
INSERT INTO kma_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Die gbɩgbarɩtʋ wa dɩ balɩ a yi Pɔɔli dɩ, “Nyɩŋkʋraha yɩ wa nʋaŋ dɩ n vaa fʋnɩŋ aŋaŋ Silasi ga yɔrɩ. Die wɩa nɩ gamma aŋaŋ sʋgɩfɩalɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama ta Pɔɔli die dɩ yiŋŋi balɩ a yɩ susuŋŋiribe dɩ, “Tɩ gbaŋ tɩ yiwo vuodiekemba Romani vuosi dɩ yɩna tɩ sieŋ, ta Romani nyɩŋkʋraha die dɩ ka dii tɩ sarɩya ama ta vaa ba vɩɩrɩ tɩ aŋaŋ kpaasɩŋ yaalɩŋ ma, ta nagɩ tɩ a yi dansarɩka sʋŋ. Lele ba yile dɩ ba nan bɩagɩ a lɔbɩrɩ vʋarɩ tɩ a taaŋ? Aayɩ, ba kaaŋ bɩagɩ, sie ba keŋ gie ba gbaŋ gbaŋ a vʋarɩ tɩ.” ");
INSERT INTO kma_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Die susuŋŋiribe dɩ gana a balɩ nyɩŋkʋraha wudieke Pɔɔli aŋaŋ Silasi dɩ bala wa, die ŋmaamɩŋ die dɩ yigi be. ");
INSERT INTO kma_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Die wɩa die ba ga Pɔɔli aŋaŋ Silasi jigiŋ a ga nɩgɩ nuupɔɔŋ. Die ba dɩɩ ba nɩŋŋa a yaa ba a keŋ nyɩŋ dansarɩka ka sʋŋ ta die balɩ ba dɩ ba jʋʋsa ba ba nyɩŋ tɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ta Pɔɔli aŋaŋ Silasi die dɩ nyɩŋ mi a ga Lidia tigiŋ me. Mi die ba ye Yisa dɩdɩɩsɩrɩŋ ta kpaaŋ ba ta wa nyɩŋ tɩka ma. ");
INSERT INTO kma_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Die Pɔɔli aŋaŋ Silasi die dɩ dɩa a daagɩ Amifipolisi aŋaŋ Apolonia ma a ga tʋgɩ Tesalonika. Mi die Juu vuosi Ŋmɩŋ jɩamɩŋ juoŋ die dɩ beri. ");
INSERT INTO kma_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔɔli die dɩ ga juu juoku me ta jɩama Ŋmɩŋ sɩba ʋ ŋaana yie dene wo. Ta die nagɩ davʋʋsɩkɩrɩ daraa ataa a balɩ Ŋmɩŋ wɩa a yɩ vuosisi. Die ʋ nagɩ wa Ŋmɩŋ gbaŋkʋ, ");
INSERT INTO kma_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","a daga ba dɩ Masia wa mʋ ba kʋʋ wa mɩŋ, ama ʋ nan hagɩ kuŋ me. Pɔɔli dɩ balɩ ba dɩ Yisa wa yine Masia ka ʋ balala wa. ");
INSERT INTO kma_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Die bataŋ die dɩ tuo Pɔɔli dɩ bala wudieke wo a dii ta die bɩrɩŋ Yisa dɩdɩɩsɩrɩŋ a gʋtɩ Pɔɔli aŋaŋ Silasi ma. Die vuodiekemba dɩ kana ka yi Juu vuosi ama ta jɩama Juu vuosi jɩaŋkʋ bataŋ aŋaŋ hɔgʋkpɩɩma pam die dɩ tuo wɩɩrɩ dii. ");
INSERT INTO kma_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Juu vuosi die dɩ yene dɩ vuosi pam gʋta Pɔɔli aŋaŋ Silasi ma wa, die ba jɩɩ sɩnyɩɩrɩŋ aŋaŋ ba, die wɩa die ba lagɩsɩ vuotɔgɩtɩ nyʋkʋ jigiŋ a yi kpɩkpaaŋ. Die ba yie watɩ ta piili yaala waagɩŋ ta die ga a ligi daa wʋnyɩ ba wasɩnana Jasoni tigiŋ a yaala Pɔɔli aŋaŋ Silasi dɩ ba vʋarɩ ba a yɩ vuosisi. ");
INSERT INTO kma_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama die ba kenne ta ka ye be wo die ba yigi Jasoni aŋaŋ Yisa dɩdɩɩsɩrɩba bataŋ a yaa ba ga tɩka nyɩŋkʋra jigiŋ ta natɩ dɩ, “Pɔɔli aŋaŋ Silasi dɩ dɩa a chʋʋsa tɩgɩsɩ. Lele ta wa keŋ giena ");
INSERT INTO kma_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ta Jasoni dɩ tuo be chaantɩ ʋ tigiŋ me. Ba mana chʋʋsa naakpɩɩka mɩraha ta baarɩ dɩ naakpɩɩŋ wʋnyɩ benne ba wasa wa Yisa.” ");
INSERT INTO kma_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ba nyɩŋkʋraha aŋaŋ vuotamba dɩ wʋnna naa, die dɩ faasɩ mugisi be. ");
INSERT INTO kma_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Die wɩa nyɩŋkʋraha dɩ vaa Jasoni aŋaŋ Yisa dɩdɩɩsɩrɩba banɩŋ ba dɩ tuŋ ligire ta die ba vaa ba ba ga. ");
INSERT INTO kma_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yuŋ die dɩ kenne a sibi, die Yisa dɩdɩɩsɩrɩba die dɩ vaa Pɔɔli aŋaŋ Silasi dɩ nyɩŋ ga Beria ma. Die ba gana a ga tʋgɩ mi wo ba ga juu Juu vuosi Ŋmɩŋ jɩamɩŋ juoŋ me. ");
INSERT INTO kma_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria vuosi die dɩ faasɩ yaala ba wʋŋ Ŋmɩŋ wɩaha a tɩaŋ Tesalonika vuosisi. Die ba wʋmma wɩaha aŋaŋ ba sʋgɩtɩ mana ta die daaŋ mana ba karɩma Ŋmɩŋ gbaŋkʋ dɩ ba ye dɩ wɩaha yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ba vuosi pam die dɩ yi yada a bɩrɩŋ Yisa dɩdɩɩsɩrɩŋ. Giriiki hɔgʋkpɩɩma aŋaŋ dembisi pam gbaŋ die dɩ yi Yisa yada. ");
INSERT INTO kma_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Die Juu vuosi die dɩ benne Tesalonika ma wa die dɩ wʋnna dɩ Pɔɔli bala Ŋmɩŋ wɩa Beria ma wa die ba bɩ ga mi a piili a bala chʋʋsa Pɔɔli a yɩa kpɩkpaakʋ ta vaa ba jɩɩ sɩnyɩɩrɩŋ aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Lele womi Yisa dɩdɩɩsɩrɩba die dɩ taaŋ Pɔɔli aŋaŋ dembisi dɩ sʋʋŋ ga mʋgɩkpɩɩrɩ chaaŋ ama Silasi aŋaŋ Timoti die dɩ wɩarɩ a bie Beria ma. ");
INSERT INTO kma_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dembisi bataŋ die dɩ ga aŋaŋ Pɔɔli a ga tʋgɩ Atensi ta die yiŋŋi aŋaŋ tʋntʋmɩŋ a keŋ balɩ Silasi aŋaŋ Timoti dɩ ba keŋ wʋnɩŋ Pɔɔli jigiŋ lagɩ lagɩ. ");
INSERT INTO kma_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Die Pɔɔli dɩ chɩɩsɩnana Silasi aŋaŋ Timoti Atensi ma wa die ʋ sʋŋ dɩ faasɩ chʋʋsɩ ʋ yene dɩ tɩka suuli wo aŋaŋ bugile. ");
INSERT INTO kma_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Die wɩa die ʋ ga Juu vuosi jɩamɩŋ jigiŋ a bala yɩa banɩŋ aŋaŋ vuodiekemba mana dɩ jɩanna aŋaŋ ba. Ta daaŋ mana ʋ bala a yɩa vuodiekemba ʋ haarɩna nyʋkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bataŋ die yiwo Epikuriani aŋaŋ Sitoyiki dɩdagɩrɩŋ ta die nɩga nɩnhagɩrɩŋ aŋaŋ Pɔɔli. Bataŋ die dɩ baarɩ dɩ, “Bɩa vuodieke dɩ bala dɩ ʋ yiwo sɩsɩbɩrʋ wa gie dɩ yaala ʋ dagɩ?” Ta bataŋ dɩaŋ die dɩ baarɩ dɩ, “Ʋ bala tɩŋgbaŋ gaasɩ bugile wɩa.” Die ba balɩ wa naa dama Pɔɔli die bala Yisa aŋaŋ kuŋ hagɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Die wɩa die ba yaa wa a ga tɩka nyɩŋkʋra lagɩmɩŋ jigiŋ ba wasɩnana Aropagusi a baarɩ dɩ, “Balɩ tɩ fʋ dagɩhaalɩkʋ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tɩ wʋŋya fʋ bala wʋhaala a taŋ ta wa yaala tɩ sɩmma a chɩasɩ.” ");
INSERT INTO kma_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Dama Atensi vuosi aŋaŋ chaamba dieke mana die dɩ benne mi die yaala ba nagɩ ba saŋŋa mana a balɩma ta wʋmma wʋhaala wɩa.) ");
INSERT INTO kma_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Die Pɔɔli dɩ hagɩ zie lagɩŋkʋ nɩŋŋa a baarɩ dɩ: “Atensi vuosi, n yeye dɩ nɩ yiwo vuodiekemba dɩ jɩanna ŋmɩna pam aŋaŋ nɩŋŋmɩna. ");
INSERT INTO kma_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Dama n chʋnnana a gilime tɩka sʋŋ a daansa jigidiekemba nɩ jɩanna wa, maŋ ye kaabɩŋ koriŋ kaanɩ ba maagɩna ka ma dɩ, ‘Ŋmɩŋ Dieke Tɩ Zɩna.’ Nɩ jɩama Ŋmɩnnɩ gie ta ka mɩŋŋɩ sɩba wa. N yaala n balɩ nɩ mɩŋ ʋ wɩa. ");
INSERT INTO kma_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ŋmɩnnɩ gie naanna dʋnɩa aŋaŋ nyindiekemba mana dɩ benne ka sʋŋ. Ta yi ŋmɩŋsikpeŋ aŋaŋ tɩŋgbaŋka gie tieŋ ta ka bie Ŋmɩŋ jɩamɩŋ juone me vuota dɩ nagɩna ba nuusi a mɩɩ. ");
INSERT INTO kma_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ʋ ka yaala suŋŋiŋ a nyɩna vuoŋ mana jigiŋ, ʋ yɩnana vuota miivoli aŋaŋ voosiŋ aŋaŋ jaaŋ mana. ");
INSERT INTO kma_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ŋmɩŋ die naaŋ wa vuota yiri yiri mana a nyɩŋ chɔɔŋkʋbalɩmɩŋ ma ta vaa ba bie tɩŋgbaŋka gie mana ma. Ʋ gbaŋ gbaŋ die ʋ ziene saŋŋa dieke aŋaŋ jigidieke buuriŋ mana dɩ baaŋ nan dɩ beri. ");
INSERT INTO kma_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ŋmɩŋ die yiwo naa amʋ tɩ nan yaalɩ ʋ jigiŋ a ye wo, dama ʋ ka yʋa aŋaŋ tɩ wʋnyɩ mana, ");
INSERT INTO kma_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ta yɩa tɩ hagɩrɩŋ tɩ baaŋ dɩ beri ta dɩ dɩa chʋŋ ta bɩ yi vuodiekemba tɩ yine. ‘Tɩ yiwo ʋ ballɩ’, sɩba vuoŋ wʋnyɩ die dɩ bala die wo. ");
INSERT INTO kma_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tɩ wana yi ʋ ballɩ naa tɩ ka mʋ tɩ yilime dɩ ʋ sɩɩ sɩba buuŋ vuoŋ dɩ nagɩna salɩma yaa taŋ mɩɩ. Ʋ ka sɩɩ sɩba jadieke vuota dɩ yiline ta mɩɩ. ");
INSERT INTO kma_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Saŋŋa dieke dɩ tɩanna wa ta vuosi die dɩ ka sɩba Ŋmɩŋ wa, die ʋ ka naga ba taalɩ. Ama lele wo ʋ baarɩ vuodieke mana dɩ benne jigidieke mana vaa ba tʋmbɩatɩ ta yiŋŋi keŋ ʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dama ʋ vʋarɩ wa daaŋ a zieŋ ʋ baaŋ nan dii dʋnɩa vuosisi mana sarɩya aŋaŋ wusie. Ta vʋarɩ Yisa dɩ ʋ dii sarɩya ka a yɩ wa. Ŋmɩŋ dagɩ tɩ mɩŋ dɩ ka seŋ yiwo wusie aŋaŋ ʋ sʋgɩrɩna Yisa a nyɩŋ kuŋ me wo.” ");
INSERT INTO kma_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Die ba wʋnna kumbu hagɩkʋ wa wɩa bataŋ dɩ vʋara Pɔɔli fala ta bataŋ dɩ baarɩ, “Tɩ yaala fʋ bɩ a balɩ die tɩ wʋŋ.” ");
INSERT INTO kma_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Die wɩa Pɔɔli die nyɩŋ lagɩŋkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dembisisi bataŋ die dɩ ʋ kʋaŋ ta yi Yisa yada. Ba sʋŋ die wone Diyonisusi die ʋ yiwo Aropagusisi vuosi wʋnyɩ aŋaŋ hɔgʋ dieke saaŋ dɩ dine Damerisi aŋaŋ vuosi bataŋ. ");
INSERT INTO kma_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Naa kʋaŋ chaaŋ Pɔɔli die dɩ nyɩŋ Atensi ma a ga Korinti ma, ");
INSERT INTO kma_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","mi die ʋ haarɩ Juu daa wʋnyɩ ba wasɩnana Akuyila ama die ba mɩɩrɩ wa wa Pontusi ma, ta die nyɩŋ Itali aŋaŋ ʋ hɔgʋ Pirisila, dama naakpɩɩŋ Kolodiawosi die yɩ wa nʋaŋ dɩ Juu vuosi mana nyɩŋ Roma tɩŋgbaŋ ma. Ta Pɔɔli die dɩ ga dɩ ʋ ye be, ");
INSERT INTO kma_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ta die ye dɩ ba yiwo gbaŋwʋnsɩrɩŋ sɩba ʋ gbaŋ gbaŋ. Die wɩa die ʋ wɩarɩ ba jigiŋ ba lagɩsa tʋma. ");
INSERT INTO kma_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ta davʋʋsɩkɩrɩ daaŋ mana Pɔɔli ŋaaŋ ga wa Juu vuosisi Ŋmɩŋ jɩamɩŋ juone me a bala yɩa Juu vuosisi aŋaŋ buurigaasɩsɩ a yaala ʋ tarɩgɩ ba. ");
INSERT INTO kma_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ama Silasi aŋaŋ Timoti die dɩ nyɩna Masedonia a keŋ kʋaŋ chaaŋ die ʋ nagɩ ʋ saŋŋa mana a mʋʋla a yɩa Juu vuosisi dɩ Yisa yine Ŋmɩŋ Vuovʋarɩkɩŋ Masia wa. ");
INSERT INTO kma_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ka kʋaŋ chaaŋ die ba yiŋŋi a waga wa ta zɩa wa. Die wɩa die ʋ kpaantɩ ʋ nyinyeeke taŋkɔlɩŋ a taaŋ ta balɩ ba dɩ, “Dɩɩ yi nɩ keŋ waarɩ nɩ miivoli, ka wa chii wo nɩ sikpeŋ me. N nuuŋ bɩ wo mi. A nyɩŋ jinne yaa gamma sie n vaa nɩ ta ga mʋʋlɩ Yisa wɩaha a yɩ buurigaasɩsɩ.” ");
INSERT INTO kma_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Die wɩa die ʋ nyɩŋ mi a ga daa wʋnyɩ ba wasɩnana Titusi Jusitusi tigiŋ. Die ʋ ka yi Juu vuoŋ ama ta jɩama Ŋmɩŋ ta ʋ tigiŋ die dɩ gbigi Juu vuosi Ŋmɩŋ jɩamɩŋ juoku. ");
INSERT INTO kma_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipusi vuodieke die yine Ŋmɩŋ jɩamɩŋ juoku nɩŋŋandɩɩsɩrʋ die dɩ yi Yisa yada, wʋnɩŋ aŋaŋ ʋ deŋ mana; ta vuodiekemba dɩ benne Korinti ma die dɩ wʋŋ wɩaha ta yi yada ta die ba sɩɩ ba Ŋmɩŋ nyaabʋ. ");
INSERT INTO kma_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Yuŋ kaanɩ Pɔɔli die dɩ daansɩ, ta Ŋmɩŋ dɩ baarɩ dɩ, “Da keŋ vaa ŋmaamɩŋ yalla fʋ, fʋnɩŋ ko a mʋʋlɩma n wɩaha ta da keŋ vaa, ");
INSERT INTO kma_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","dama n bie wo fʋ jigiŋ, vuoŋ wori a baaŋ nan bɩagɩ a yi fʋ daŋŋa, dama n yaa vuosi pam tɩka gie me.” ");
INSERT INTO kma_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Die wɩa Pɔɔli die dɩ bie mi biŋ aŋaŋ chɩɩtɩ ayʋaba a daga vuosisi Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Die saŋŋa dieke Galiwo die dɩ yine Akaya tɩŋgbaŋ jakʋʋrɩ, die Juu vuosi nɩŋŋandɩɩsɩrɩba bataŋ die dɩ lagɩsɩ a yigi Pɔɔli ta die a yaa wa ga sarɩya diile jigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","a ga baarɩ dɩ, “Daa wa gie mɩa dɩ ʋ vaa tɩ vuosisi jɩama Ŋmɩŋ sie dieke tɩ mɩrɩka dɩ kana ka yɩ sieŋ.” ");
INSERT INTO kma_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔli die baa ʋ balɩ wɩɩŋ ta Galiwo dɩ balɩ a yɩ Juu vuosisi dɩ, “Nɩ wʋmma, nɩnɩŋ Juu vuosi dɩ tɩŋ yi daa wa dɩ yiwo wʋbɩaŋ n tɩŋ nan wʋŋ a yɩ nɩ, ");
INSERT INTO kma_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ama ka yine nɩnhagɩrɩŋ yaa gamma wʋbalɩka aŋaŋ saara aŋaŋ nɩ gbaŋ gbaŋ nɩ mɩraha wɩa nɩŋ, n kaaŋ dii a die sarɩya nɩ gbaŋ gbaŋ nɩ wʋnsɩ wɩɩrɩ.” ");
INSERT INTO kma_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ta die yagɩ ba a nyɩŋ sarɩya diilehe juoku me. ");
INSERT INTO kma_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Die wɩa kpɩkpaakʋ die dɩ yigi Sosetenesi vuodieke dɩ yine Ŋmɩŋ jɩamɩŋ juoku nɩŋŋandɩɩsɩrɩ wa a nɩgɩ wa sarɩya diile juoku nɩŋŋa, ama Galiwo baga die wo ba ma. ");
INSERT INTO kma_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔli die dɩ bie Korinti tɩŋ ma aŋaŋ Yisa dɩdɩɩsɩrɩba daraa pam, ta die vaa ba ta nagɩ Pirisila aŋaŋ Akuyila a gʋtɩ ʋ ma ba nagɩ haarɩŋ a dɔŋ gara Siria. Die ba yaalala dɩ ba ga wa Pɔɔli die dɩ wɔŋ ʋ sikpeŋ Senkiria ma dama die ʋ yɩ wa nʋaŋ Ŋmɩŋ nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Die ba ga a tʋgɩ Efesusi, Pɔɔli die dɩ vaa Pirisila aŋaŋ Akuyila mi. Ta die ga Juu vuosi Ŋmɩŋ jɩamɩŋ juoku ma ta die dɩ balɩ Yisa wɩa aŋaŋ vuosisi. ");
INSERT INTO kma_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Die ba balɩ dɩ ʋ bemme ba jigiŋ a yʋasɩ ama die ʋ zeti. ");
INSERT INTO kma_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ama die ʋ taaŋ ba ta baarɩ dɩ, “Dɩɩ yi Ŋmɩŋ dʋŋŋʋ n nan yiŋŋi keŋ nɩ jigiŋ.” Ta die yiŋŋi keŋ juu haarɩkʋ a ga. ");
INSERT INTO kma_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Die ʋ kenne tʋgɩ Siisiria ma die ʋ tɩaŋ ga Jerusalemi a ga waasɩ Yisa dɩdɩɩsɩrɩba mi ta sʋʋŋ ga Antiyoku, ");
INSERT INTO kma_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","die ʋ yi daraa ale mi, ta die nyɩŋ mi a ga Galasia aŋaŋ Firigia chaatɩ a suŋŋe Yisa dɩdɩɩsɩrɩba mana mi dɩ ba yada gʋtɩ. ");
INSERT INTO kma_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Die Juu daa wʋnyɩ die ba wasɩnana Apolosi die dɩ keŋ Efesusi, die ba mɩɩrɩ wa wa Alekizandira tɩŋ ma. Die ʋ yiwo vuodieke dɩ sɩbɩna balɩŋ ta bɩ sɩba Ŋmɩŋ gbaŋkʋ wɩa pam. ");
INSERT INTO kma_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Die ʋ mɩŋŋɩ bʋgɩrɩ tɩ Yɔmʋtieŋ Yisa wɩaha, ta balɩ ha aŋaŋ sʋgɩfɩalɩŋ pam. Ta wudieke ʋ dagɩnana yaa gamma Yisa ma wa die dɩ yi wusie, ama wudieke die ʋ sɩbɩna die yine Jɔɔn wʋbalɩka yaa gamma Ŋmɩŋ nyaabʋ sɩɩla wɩa nyɩɩna. ");
INSERT INTO kma_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolosi die dɩ piili a bala Ŋmɩŋ wɩaha Juu vuosi Ŋmɩŋ jɩamɩŋ juoŋ me ta ka chɩga ŋmaamɩŋ. Ama Pirisila aŋaŋ Akuyila die dɩ wʋnna ʋ balɩkʋ die ba nagɩ wa ga ba tigiŋ a mɩŋŋɩ a dagɩ wa sie dieke Ŋmɩŋ dɩ dagɩna dɩ tɩ dɩaha. ");
INSERT INTO kma_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Naa kʋaŋ chaaŋ die Apolosi die dɩ saŋ dɩ ʋ ga Akaya ma, die wɩa Yisa dɩdɩɩsɩrɩba die dɩ benne Efesusi ma dɩ maagɩ gbanɩŋ a yɩ Yisa dɩdɩɩsɩrɩba die dɩ benne mi wo dɩ ba tuo wo chaantɩ. Die ʋ gana a ga tʋgɩ mi wo die ʋ suŋŋi vuodiekemba mana dɩ yine yada Ŋmɩŋ zɔɔlɩŋ chɩgɩla wɩa. ");
INSERT INTO kma_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Die wʋnɩŋ aŋaŋ Juu vuosisi die dɩ faasɩ nɩgɩ nɩnhagɩrɩŋ pam yaalɩŋ ma ta die ʋ nagɩ Ŋmɩŋ gbaŋkʋ wɩa a dagɩ ba dɩ Yisa yine Ŋmɩŋ Vuovʋarɩkɩrɩ Masia wa ta die nyaŋŋɩ ba. ");
INSERT INTO kma_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Die Apolosi die dɩ yene bie Korinti ma wa, Pɔɔli nɩŋ die dɩ ga Galasia aŋaŋ Firigia chaatɩ a ga Efesusi. Mi die ʋ haarɩ Yisa dɩdɩɩsɩrɩŋ bataŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ta die pɩasɩ ba dɩ, “Die nɩ yine Yisa yada wa die Halɩkasɩka keŋ nɩ ma mɩŋ?” Die ba yiŋŋi a baarɩ dɩ, “Aayɩ, tɩ ye ka wɔŋ wʋŋ Ŋmɩŋ Halɩkasɩka wɩa.” ");
INSERT INTO kma_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pɔɔli die dɩ pɩasɩ dɩ, “Die nɩŋ ba sɩna nɩ Ŋmɩŋ nyaabʋ wa chɩaŋ?” Ba yiŋŋi a baarɩ dɩ, “Ba sɩɩ tɩ sɩba Jɔɔn die dɩ ŋaana sɩa vuosi die wo.” ");
INSERT INTO kma_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔɔli die dɩ yiŋŋi baarɩ dɩ, “Jɔɔn die sɩa vuosi Ŋmɩŋ nyaaŋ ka dagɩ dɩ ba chɩgɩ nyɩŋ ba wʋbɩatɩ ma ta yiŋŋi keŋ Ŋmɩŋ jigiŋ. Ama ta die a bɩ balɩ ba dɩ vuoŋ wʋnyɩ kieŋ ʋ kʋaŋ chaaŋ dɩ ba yiwo yada. Yisa die yine vuodieke Jɔɔn dɩ balala yaa gamma wa.” ");
INSERT INTO kma_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Die ba wʋnna naa wa, die ba sɩɩ ba Ŋmɩŋ nyaabʋ tɩ Yɔmʋtieŋ Yisa saaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ta Pɔɔli die dɩ nagɩ ʋ nuusi a diisi ba ma ta Ŋmɩŋ Halɩkasɩka die dɩ keŋ a sʋʋŋ ba ma, die ba bala nyɩŋbalɩkɩ haala, ta bala wudiekemba dɩ nyɩnna Ŋmɩŋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Die ba yiwo sɩba dembisi baŋ aŋaŋ ale. ");
INSERT INTO kma_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔɔli die dɩ chʋŋ gara Ŋmɩŋ jɩamɩŋ juoku me die chɩɩtɩ ataa ta daga vuosisi yaa gamma Ŋmɩŋ naarɩ wɩa ta ka chɩga ŋmaamɩŋ ta die mɩa dɩ ʋ tarɩgɩ ba yɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama vuosisi bataŋ die yiwo sikpeŋ hagiritieliŋ ta zeti dɩ ba kaaŋ tuo a dii ta die balɩ wʋbɩatɩ pam yaa gamma sie dieke tɩ Yɔmʋtieŋ dɩ dagɩna wa kpɩkpaakʋ nine me. Naa chɩaŋ ma Pɔɔli die dɩ vaa ba ta nagɩ Yisa dɩdɩɩsɩrɩba ba ga Tiranusi dagɩŋ juoŋ me ta daga mi daaŋ mana. ");
INSERT INTO kma_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Die ʋ dagɩ wa die bɩna ale ta vuodiekemba mana die dɩ benne Asia tɩŋgbaŋka ma wa ta yi Juu vuosi yaa buurigaasɩ die dɩ wʋŋ tɩ Yɔmʋtieŋ wɩaha. ");
INSERT INTO kma_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Saŋka mi Ŋmɩŋ die dɩ yɩ Pɔɔli hagɩrɩŋ ʋ tʋma mamachi tʋnkpɩɩma. ");
INSERT INTO kma_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Die vuosi bataŋ die dɩ nagɩ garɩ diekemba dɩ gbɩna Pɔɔli nyɩŋgbanɩŋ a chiihe gara vuodiekemba dɩ yʋagɩna jigiŋ ta garɩtɩ gie dɩ vasa be yese alaafɩa, ta jɩmbɩatɩ dɩ nyɩna ba ma. ");
INSERT INTO kma_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Die Juu dembisi bataŋ die dɩ piili a dɩdɩa a mɩa dɩ ba vʋarɩ jɩmbɩatɩ vuosi ma aŋaŋ tɩ Yɔmʋtieŋ saaŋ ma. Die ba ŋaŋ balɩ yɩ jɩmbɩatɩtɩ dɩ “N yɩa nɩ nʋaŋ, Yisa dieke Pɔɔli dɩ balala ʋ wɩaha saaŋ ma dɩ nɩ keŋ nyɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Die Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ ba wasɩnana Sikeva ballɩ bayʋpɔyɩ dɩ yie naa. ");
INSERT INTO kma_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ama jɩmbɩakʋ die dɩ balɩ a yɩ ba dɩ, “N sɩba vuodieke Yisa dɩ yine ta wʋŋ Pɔɔli wɩa, ta nɩnɩŋ nɩŋ mɩnɩa yine nɩ?” ");
INSERT INTO kma_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Womi daa dieke jɩmbɩatɩ dɩ yalla wa die dɩ yugi a jʋalɩ ba a nɩgɩ ba pam ta yi ba daŋŋa a chɩɩrɩ ba garɩtɩ, ba chɩgɩ nyɩŋ tigiri me yɔrɩ. ");
INSERT INTO kma_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Die Juu vuosisi aŋaŋ buurigaasɩsɩ dɩ benne Efesusi ma wa dɩ wʋŋ naa wa, die dɩ yi be ŋmaamɩŋ pam ta bɩrɩ tɩ Yɔmʋtieŋ Yisa saaŋ pam. ");
INSERT INTO kma_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Die Yisa dɩdɩɩsɩrɩba pam die dɩ piili a bala wʋbɩatɩ diekemba ba yine a yɩa vuosisi yaalɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ta vuodieke die dɩ yalla yuŋ die chii ba gbaŋtɩ a keŋ nyɩŋ a jʋʋ ha daadamba nine me. Die gbaŋtɩ gie ligire die yi sɩba ligire bie tuse baŋɩsɩ-nʋ. ");
INSERT INTO kma_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Naa chɩaŋ ma tɩ Yɔmʋtieŋ wɩaha die dɩ mʋʋlɩ ga jigiŋ mana ta bɩ gʋta aŋaŋ hagɩrɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Genhe mana kʋaŋ chaaŋ die Ŋmɩŋ Halɩkasɩka die dɩ vaa Pɔɔli dɩ saŋ dɩ ʋ ga kaagɩ Masedonia aŋaŋ Akaya ta tɩaŋ ga Jerusalemi. Ta die baarɩ “Maŋ keŋ nyɩŋ mi n nan ga Romi.” ");
INSERT INTO kma_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Die wɩa die ʋ tʋŋ ʋ susuŋŋiru bale, Timoti aŋaŋ Erasitusi dɩ ba ga Masedonia ma, ama die ʋ wɩarɩ Asia tɩŋgbaŋ ma daraa ale. ");
INSERT INTO kma_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Saŋka mi die wumugisike pam die dɩ nan yaa gamma sie dieke tɩ Yɔmʋtieŋ dɩ dagɩna wɩa. ");
INSERT INTO kma_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Die macheeri wʋnyɩ ba wasɩnana Demetirusi, die ʋ naga siliva a wʋnsa juobisi sɩba ba ŋmɩŋ Diana jɩamɩŋ juoku, ta die tʋʋmaha dɩ yɩa ʋ tʋntʋntɩba nyʋarɩ pam. ");
INSERT INTO kma_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Die wɩa die ʋ wa ʋ tʋntʋntɩba mana aŋaŋ vuodieke dɩ tʋnnana ʋ tʋʋmaha chanchaaŋ a lagɩsɩ a balɩ yɩ ba dɩ, “N zʋamba, nɩ sɩba a baarɩ tɩ yese tɩ nyʋarɩ a nyɩna tɩ tʋʋmaha gie mi. ");
INSERT INTO kma_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nɩ gbaŋ gbaŋ nɩ yeye ta wʋŋ wudieke Pɔɔli dɩ yinene. Ʋ baarɩ dɩ ŋmɩna diekemba vuota dɩ wʋnsɩna ka yi ŋmɩna, ta bɩagɩ a tarɩgɩ vuosi pam yɩaŋ Efesusi ma giena aŋaŋ Asia lʋga mana. ");
INSERT INTO kma_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Vuosi nan piili a bala wʋbɩatɩ yaa gamma tɩ tʋʋmaha, ba kaaŋ bɩ yɩ Diana jɩamɩŋ juoku jɩlɩma, ŋmɩŋ dieke Asia aŋaŋ dʋnɩa mana dɩ jɩanna. Ba nan daaŋ tɩ ŋmɩŋ kpɩɩkʋ Diana wɩa.” ");
INSERT INTO kma_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Die kpɩkpaakʋ dɩ wʋnna naa wa ba jɩɩ sɩnyɩɩrɩŋ ta piili a nata dɩ, “Tɩnɩŋ Efesusi vuosi ŋmɩŋ Diana yiwo ŋmɩŋ kpɩɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ta tɩka mana die dɩ dɔŋ. Ta ba yigi Gayusi aŋaŋ Arisitakusi vuodiekemba die dɩ dɩna Pɔɔli a nyɩŋ Masedonia a keŋ wo a nagɩ ba ga tɩka lagɩmɩŋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔɔli die dɩ yaala ʋ nyɩŋ ga a balɩ wɩa a yɩ vuosisi ama Yisa dɩdɩɩsɩrɩba die ka yɩ wa sieŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Die tɩka nyɩŋkʋraha bataŋ die dɩ yine Pɔɔli zʋalɩŋ die dɩ tʋŋ vuoŋ dɩ ʋ keŋ a balɩ wa dɩ ʋ da keŋ keŋ lagɩŋkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Saŋka mi die vuodiekemba die dɩ benne lagɩŋkʋ jigiri die dɩ nata tɔra tɔra ta vuoŋ mana ka sɩba wudieke ʋ yinene, ta pam dɩaŋ dɩ ka sɩba lagɩŋkʋ chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ta Juu vuosisi nɩŋŋandɩɩsɩrɩba pam die kpaŋŋɩ daa wʋnyɩ ba wasɩnana Alekizanda a nyɩŋ zieŋ kpɩkpaakʋ nɩŋŋa a piili a bala wa wudieke ʋ baaŋ nan balɩ. Ta Alekizanda die dɩ kɔtɩ ʋ nuuŋ ŋmɩŋsikpeŋ ta mɩa dɩ ʋ dagɩ wudieke dɩ yinene wo chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama kpɩkpaakʋ die dɩ mɩŋŋɩna dɩ ʋ yiwo Juu vuoke ba mana die dɩ natɩ die hawasɩ ale dɩ “Tɩnɩŋ Efesusi ŋmɩnnɩ Diana yiwo ŋmɩŋ kpɩɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ka kpatɩŋ ta tɩka jakʋʋŋ dɩ yi kpɩkpaakʋ dɩ tarɩ watɩ, ta baarɩ dɩ, “Nɩnɩŋ Efesusi vuosi, mɩnɩa benne dʋnɩa ka gie me ta ka sɩba dɩ Efesusi vuosi gbarɩna ta daansa Diana ŋmɩŋ kpɩɩŋ juoku. Mɩnɩa kana ka sɩba dɩ ʋ buubu die dɩ nyɩnna ŋmɩŋsikpeŋ a keŋ sʋʋŋ wa bie wo giena? ");
INSERT INTO kma_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Vuoŋ wori a baaŋ bɩagɩ a chiisi wɩɩrɩ gie, die wɩa nɩ fɩalɩ nɩ gbaŋ ta nɩ da keŋ yi wudieke dɩ kana ka mʋ. ");
INSERT INTO kma_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nɩ chii wo vuosi gie keŋ juu gie, vuodiekemba dɩ kana ka gaarɩ tɩ jɩaŋkʋ juoku jaaŋ yaa a balɩ wʋbɩatɩ a yɩ tɩ ŋmɩŋ Diana. ");
INSERT INTO kma_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dɩɩ yi Demetirusi aŋaŋ ʋ tʋntʋntɩba dɩ yaa wɩɩŋ aŋaŋ vuosi gie, tɩ yaa sarɩya diile juone aŋaŋ sarɩya diiriŋ, nɩ vaa ba yaa ba wɩa ga mi. ");
INSERT INTO kma_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ama dɩɩ yi nɩ yaala nɩ yi wɩɩŋ a tɩaŋ die, die nɩŋ dɩ mʋ nɩ yaa wɩɩrɩ keŋ wo tɩka nyɩŋkʋra nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Romani vuosi nan bɩagɩ galɩŋ tɩ yaa gamma wudieke tɩ yine jinne wo. Dama tɩ gbaŋ gbaŋ tɩ kaaŋ bɩagɩ a balɩ watɩtɩ gie chɩaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Die ʋ bala naa a kpatɩ kʋaŋ chaaŋ ʋ taaŋ vuosisi. ");
INSERT INTO kma_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Die watɩtɩ dɩ tɩanna kʋaŋ chaaŋ Pɔɔli die dɩ wa Yisa dɩdɩɩsɩrɩba a kpaŋŋɩsɩ ba ta die taaŋ ba ta nyɩŋ ga Masedonia. ");
INSERT INTO kma_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Die ʋ dɩa ga mi chaakʋ tɩgɩsɩ mana a kpaŋŋɩsa Yisa dɩdɩɩsɩrɩba aŋaŋ wɩa pam. Ka kpatɩŋ die ʋ wa ga Giriisi, ");
INSERT INTO kma_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ta die bie mi a ga tʋgɩ chɩɩtɩ ataa. Ka kʋaŋ chaaŋ die ʋ gɔmɩsɩ dɩ ʋ ga Siiria ta die mɩŋŋɩ dɩ Juu vuosisi saŋya mɩŋ a gbarɩ wa; naa chɩaŋ mana die ʋ saŋ dɩ ʋ yiŋŋi a daagɩ Masedonia a ga. ");
INSERT INTO kma_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Die vuodiekemba die dɩ gʋtɩna ʋ ma wa die yiwo Sopata, Pirusi bʋa ta nyɩŋ Beria aŋaŋ Arisitakusi aŋaŋ Sekondusi vuodiekemba die dɩ nyɩnna Tesalonika. A nagɩ Gayusi vuodieke dɩ nyɩnna Debe, aŋaŋ Tichikusi aŋaŋ Tirofimusi vuodiekemba die dɩ nyɩnna Asia tɩŋgbaŋ ma aŋaŋ Timoti. ");
INSERT INTO kma_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Die ba woliŋ dii tɩ nɩŋŋa ga a chɩɩsa tɩ Tiroasi ma. ");
INSERT INTO kma_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Die dʋʋga dieke ba dinene paanʋ ta ka nagɩ dabɔtɩ a yi dɩ kenne a tɩaŋ wa kʋaŋ chaaŋ, die tɩ nagɩ haarɩŋ a nyɩŋ Filipi, a gara Tiroasi. Daraa anʋ kʋaŋ chaaŋ die tɩ ga haarɩ ba Tiroasi ma, ta die bie mi daraa ayʋpɔyɩ. ");
INSERT INTO kma_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Die ka davʋʋsɩkɩrɩ daraaŋ jɩŋmɩŋ, die tɩ lagɩsɩ taŋ dɩ tɩ dii tɩ Yɔmʋtieŋ nyindiike. Pɔɔli die dɩ bala Ŋmɩŋ wɩa a yɩa vuosisi die a ga tʋgɩ tanseese dama die ʋ baa ʋ nyɩŋ wa tɩka ma ka tʋnvʋʋsa. ");
INSERT INTO kma_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Die popolisi pam die benne juodieke ma tɩ lagɩsɩna jarɩnbɩsaka sikpeku. ");
INSERT INTO kma_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Die dalʋakɩŋ wʋnyɩ die ba wasɩnana Yutikusi die dɩ kalɩ a takɔrɔ ma, ta Pɔɔli die dɩ balala wɩaha gbieŋ die dɩ faasɩ yigi Yutikusi. Ta die keŋ gʋʋrɩ ta yiŋŋi nan kʋaŋ a nyɩŋ jarɩnbɩsaka bʋtaa wa ma a keŋ nan tɩŋgbaŋ. Die ba sʋʋŋ nagɩ wa ta ʋ kpiye mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Die Pɔɔli die dɩ sʋʋŋ ga a sʋʋŋ zʋʋrɩ Yutikusi ma a nagɩ wa aŋaŋ ʋ nuusi ta baarɩ dɩ, “Nɩ da vaa nɩ sʋgɩtɩ chʋʋsɩ ta ʋ ka kpiye.” ");
INSERT INTO kma_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pɔɔli die dɩ wa jʋalɩ ga jarɩnbɩsaka sikpeŋ a gbieri paanʋ tɩ aŋaŋ wa dɩ ŋɔbɩ. Ka kʋaŋ chaaŋ ʋ bɩ mʋʋlɩ Ŋmɩŋ wɩaha die tʋŋ die dɩ ga vʋʋŋ ta ʋ wa ga. ");
INSERT INTO kma_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Die Yisa dɩdɩɩsɩrɩŋ die dɩ ga nagɩ dalʋagɩkɩrɩ ta ʋ bie ʋ mɩsɩ ma, ba yaa wa a kuli tigiŋ aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pɔɔli die dɩ saŋ dɩ ʋ chʋŋ nagɩsɩ a ga Asosi ama tɩ vuotɩalɩkaha die dɩ nagɩ haarɩŋ a woliŋ ga mi, mi die tɩ baa tɩ nagɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Die ʋ haarɩna tɩ Asosi ma die ʋ keŋ juu haarɩkʋ die tɩ dɔŋ ga Mitilene. ");
INSERT INTO kma_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ka tʋnvʋʋsa die tɩ keŋ jigiŋ kaanɩ dɩ gbine Kiyosi ta ka tʋnvʋʋsa dɩaŋ die tɩ ga tʋgɩ Samosi. Ka tʋŋ die dɩ bɩ vʋŋ tɩ ga tʋgɩ Militusi. ");
INSERT INTO kma_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔɔli die wɔŋ saŋ mɩŋ dɩ ʋ dɔŋ tɩaŋ Efesusi dama die ʋ ka yaala ʋ yʋasɩ Asia tɩŋgbaŋ ma. Die ʋ yaala lagɩ lagɩ dɩ ʋ ga tʋgɩ Jerusalemi ʋ tɩŋ nan bɩagɩ a tʋgɩ dʋʋga dieke ba wasɩnana Pentikosi daraaŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Die Pɔɔli die dɩ tʋŋ tʋntʋmɩŋ a nyɩŋ Militusi dɩ Yisa dɩdɩɩsɩrɩŋ nyɩŋkʋraha mana die dɩ benne Efesusi keŋ haarɩ wa mi. ");
INSERT INTO kma_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Die ba kenne tʋgɩ mi wo ʋ balɩ ba dɩ, “Nɩ sɩba wudieke mana n yine saŋŋa dieke n wolinne a keŋ Asia ma ta bie nɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Die Juu vuosi bataŋ die dɩ saŋ yaa gamma n ma ta die vaa maŋ dii wahala aŋaŋ zɔɔlɩŋ pam. Ama die maŋ tʋma Ŋmɩŋ tʋʋma ta sʋʋna n gbaŋ tɩŋgbaŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Die n mʋʋlɩnana Ŋmɩŋ wɩaha yaalɩŋ ma wa aŋaŋ nɩ tige me wo, die n ka lɔbɩrɩ wudieke dɩ baaŋ suŋŋi nɩ. ");
INSERT INTO kma_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Die n balɩ Juu vuosisi aŋaŋ buurigaasɩsɩ dɩ ba vaa tʋntʋmbɩatɩ yiile ta dɩa Ŋmɩŋ sieŋ ta yi tɩ Yɔmʋtieŋ Yisa yada. ");
INSERT INTO kma_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ama lele n tuone Ŋmɩŋ Halɩkasɩ nʋarɩ wɩa maŋ gara Jerusalemi ama ta ka sɩba wudieke dɩ baaŋ nan yi mɩŋ mi. ");
INSERT INTO kma_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ama n dɩna dɩ dɩa tɩgɩsɩ mana Ŋmɩŋ Halɩkasɩka ŋaŋ balɩ yɩ mɩŋ dɩ dansarɩka juule aŋaŋ wahala gbara mɩŋ Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama n ka daansɩya ta n mɩsɩ yiwo jaaŋ, dama manɩŋ n yaala n tʋŋ tʋŋ dieke tɩ Yɔmʋtieŋ Yisa dɩ yɩna mɩŋ wa a kpatɩ, ta tʋʋmaha yiwo dɩ n mʋʋlɩma wʋvɩɩŋ dieke dɩ dagɩnana Ŋmɩŋ zɔɔlɩnchɩgɩla wa. ");
INSERT INTO kma_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Die n dɩ dɩa mɩŋ jige a mʋʋla Ŋmɩŋ naarɩ wɩa a yɩa nɩ. Ta lele, n sɩba a baarɩ nɩ wʋnyɩ kaaŋ bɩ ye mɩŋ bɩbra. ");
INSERT INTO kma_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Die wɩa jinne n bala nɩ aŋaŋ nɩŋŋmɩna dɩ dɩɩ yi nɩ wʋnyɩ dɩ bɩa n nuuŋ bɩ wo ʋ ma. ");
INSERT INTO kma_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Dama manɩŋ n bala nɩ wudieke mana Ŋmɩŋ dɩ yaalala dɩ nɩ sɩmma. ");
INSERT INTO kma_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Die wɩa nɩ mɩŋŋɩ pɔgɩlɩ nɩ gbaŋ aŋaŋ Yisa dɩdɩɩsɩrɩba Ŋmɩŋ Halɩkasɩka dɩ nagɩna yi nɩ nuusi me dɩ nɩ yi ba nɩŋŋandɩɩsɩrɩba ta daansɩma ba wa. Nɩ yi sɩba yiyagɩrɩŋ a yɩ Yisa dɩdɩɩsɩrɩba. Dɩ yiwo banɩŋ vuodiekemba ʋ gbatɩna a taaŋ aŋaŋ ʋ gbaŋ gbaŋ ʋ Bʋadembiŋ Yisa zɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N sɩba a baarɩ n garɩŋ kʋaŋ chaaŋ vuobɩatɩ bataŋ nan keŋ a chʋʋsɩ Yisa dɩdɩɩsɩrɩba bataŋ sɩba gbaanchʋra dɩ ŋaana yige yiise dene wo. ");
INSERT INTO kma_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ta saŋŋa bɩ kieŋ ta vuosi bataŋ nan daansɩ nyɩŋ nɩ gbaŋ gbaŋ nɩ jigiŋ a chɩɩba ŋmɩŋchɩbɩsɩ dɩ ba tarɩgɩ Yisa dɩdɩɩsɩrɩba yɩaŋ aŋ ba dɩa ba. ");
INSERT INTO kma_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Die wɩa nɩ gbara nɩ gbaŋ ta tɩɩnsɩma die n kpaanana nɩ aŋaŋ nɩntaantɩ yuŋ aŋaŋ ŋmɩntʋasɩ die bɩna ataa wa. ");
INSERT INTO kma_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Lele manɩŋ n nagɩ nɩ yie Ŋmɩŋ nuusi me aŋaŋ ʋ zɔɔlɩnchɩgɩla wɩaha, wɩɩrɩ gie nan bɩagɩ suŋŋi nɩ ta yɩ nɩ jadieke dɩ yine nɩ sɩɩtɩ sɩba Ŋmɩŋ vuosi. ");
INSERT INTO kma_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nɩ gbaŋ nɩ sɩba a baarɩ n ka wɔŋ yaala vuoŋ ligire yaa ʋ nyinyeeke. ");
INSERT INTO kma_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nɩ gbaŋ gbaŋ nɩ sɩba a baarɩ dɩ die n nagɩ wa n nuusi gie a tʋma tʋʋma a yaala jadieke manɩŋ aŋaŋ n chanchaalɩba dɩ yaalala. ");
INSERT INTO kma_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Die n yine wudieke mana, dagɩya dɩ nɩ yallɩma nɩŋŋmɩna aŋaŋ tʋʋma ta bɩagɩ a suŋŋime wabɩtɩ, ta tɩɩnsɩma tɩ Yɔmʋtieŋ Yisa die dɩ bala dɩ, ‘Sʋgɩfɩalɩŋ pam nan yi vuodieke dɩ yɩnana piini a tɩaŋ vuodieke dɩ tuosinene.’ ” ");
INSERT INTO kma_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔɔli die dɩ balɩna naa a kpatɩ wa kʋaŋ chaaŋ, die ʋ sʋʋŋ gbirigi aŋaŋ ba ta jʋʋsɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Die ba yaala ba taaŋ wa saŋŋa dieke wo, zɔɔlɩŋ die dɩ yigi ba mana ba mana die dɩ kʋma ta nagɩ ba nuusi a goori wo. ");
INSERT INTO kma_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Die ba sʋgɩtɩ die faasɩ chʋʋsɩ mɩŋ aŋaŋ ʋ bala ba dɩ “Nɩ kaaŋ bɩ ye mɩŋ bɩbra.” Die ba beeli wo a ga haarɩkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Die tɩ balɩ a taaŋ ba ta nagɩ haarɩŋ a ga Kosi. Ka tʋnvʋʋsa die tɩ ga tʋgɩ Rodesi, ta bɩ nyɩŋ mi a nagɩ haarɩkʋ a ga Patara. ");
INSERT INTO kma_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mi die tɩ ye haarɩŋ dɩ ganana Fonisia tɩŋgbaŋ ma, die tɩ juuke a ga. ");
INSERT INTO kma_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Saŋŋa dieke tɩ kenne yese Saapurusi tɩ daagɩ tɩ nuugalɩ chaaŋ a ga Taya, Siiria tɩŋgbaŋ ma. Mi die ba baa ba vʋarɩ chiititi a nyɩŋ haarɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Mi die tɩ ye Yisa dɩdɩɩsɩrɩba bataŋ ta die bie ba jigiŋ a ga tʋgɩ daraa ayʋpɔyɩ. Ŋmɩŋ Halɩkasɩka die dɩ vaa ba balɩ Pɔɔli dɩ ʋ da keŋ ga Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ama daraa ayʋpɔyɩ wa kʋaŋ chaaŋ die tɩ bɩ piili chɔnɩŋ bɩbra. Die dembisisi mana aŋaŋ ba hɔgʋba aŋaŋ ba ballɩ die dɩ beeli tɩ a nyɩŋ tɩka ma a ga tʋgɩ mʋgɩrɩ nʋaŋ, mi die tɩ mana die dɩ sʋʋŋ a gbirigi a jʋʋsɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Die tɩ wana a balɩ taaŋ tamba wa die tɩ juu haarɩkʋ ta ba yiŋŋi kuli tigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Die tɩ nagɩ haarɩkʋ a nyɩŋ Taya a ga Tolemayisi. Mi die tɩ ga waasɩ Yisa dɩdɩɩsɩrɩba ta wɩarɩ ba jigiŋ dabalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ka tʋnvʋʋsa die tɩ ga tʋgɩ Siisiria ta die ga juu Filipi vuodieke die dɩ mʋʋlɩnana Yisa wʋvɩɩnaha tigiŋ ta die bie mi. Die ʋ yiwo dembisi bayʋpɔyɩ diekemba die ba vʋarɩna Jerusalemi ma dɩ ba yi susuŋŋiribe wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Die ʋ yaa wa hɔgʋlɩaŋ banɩɩsa vuodiekemba dɩ yene ka yallɩya, ta ba gbaŋ die dɩ bala Ŋmɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Die tɩ bie mi daraa pam ta Ŋmɩŋ naazʋa wʋnyɩ ba wasɩnana Agabusi die dɩ nyɩŋ Judia ma a keŋ mi. ");
INSERT INTO kma_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Die ʋ keŋ tɩ jigiŋ a nagɩ Pɔɔli gbanɩŋ a bɔbɩ ʋ gbaŋ gbaŋ ʋ nuusi aŋaŋ ʋ nagɩsɩ ta baarɩ dɩ, “Naa Ŋmɩŋ Halɩkasɩka dɩ balɩ dɩ Juu vuosi nan bɔbɩ gbaŋkʋ gie tieŋ sɩba naa Jerusalemi ma, ta nagɩ wa yi buuri gaasɩsɩ nuusi me.” ");
INSERT INTO kma_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Die tɩ wʋnna naa, tɩnɩŋ aŋaŋ vuoŋ banɩŋ ba mana die dɩ jʋʋsɩ Pɔɔli dɩ ʋ da keŋ a ga Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ama die ʋ yiŋŋi a balɩ tɩ dɩ, “Bɩa nɩ kʋma ta chʋʋsa n sʋŋ? N ka yiwo siri dɩ ba bɔbɩ mɩŋ Jerusalemi ma nyɩɩna ma, ama n yiwo siri dɩ n kpi mi tɩ Yɔmʋtieŋ Yisa wɩa.” ");
INSERT INTO kma_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Die tɩ kana ka bɩagɩ a balɩ a tarɩgɩ ʋ sʋŋ wɩa, die tɩ baarɩ dɩ, “Tɩ Yɔmʋtieŋ vaa fʋ dʋŋŋʋ yi.” ");
INSERT INTO kma_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Die tɩ yine daraa aŋmɩna mi kʋaŋ chaaŋ die tɩ gɔmɩsɩ tɩ nyinti a nyɩŋ ga Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ta Yisa dɩdɩɩsɩrɩŋ bataŋ die nyɩna Siisari wa gbaŋ die dɩ tɩ a ga mi, ta yaa tɩ ga Minasoni tigiŋ me, mi die tɩ baa tɩ bemme. Manasoni die nyɩŋ wa Saapurusi ta die yi Yisa dɩdɩɩsɩrɩkʋraha wʋnyɩ. ");
INSERT INTO kma_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Die tɩ gana a ga tʋgɩ Jerusalemi wa, Yisa dɩdɩɩsɩrɩba die dɩ mɩŋŋɩ a tuo tɩ chaantɩ aŋaŋ sʋgɩfɩalɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ka tuŋ vʋʋsa Pɔɔli die dɩ nagɩ tɩ dɩ tɩ ga waasɩ Jemisi. Die Yisa dɩdɩɩsɩrɩba nyɩŋkʋraha mana die bie mi. ");
INSERT INTO kma_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔɔli die dɩ waasɩ ba mana ta balɩ ba wudiekemba mana Ŋmɩŋ dɩ yine a yɩ vuodiekemba dɩ kana ka yi Juu vuosisi, wʋnɩŋ Pɔɔli tʋʋma wɩa. ");
INSERT INTO kma_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Die ba wʋnna naa kʋaŋ chaaŋ die ba mana dɩ bɩrɩ Ŋmɩŋ ta die balɩ Pɔɔli dɩ, “Tɩ nɩmbʋa Pɔɔli, sɩba a baarɩ Juu vuosi tuse tuse bɩrɩna Yisa dɩdɩɩsɩrɩŋ ta ba mana dɩ bɩ dɩ Mosisi mɩraha keŋ keŋ keŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ama ba balɩ ba mɩŋ fʋ wɩa dɩ daga Juu vuodiekemba mana dɩ benne buurigaasɩ tɩŋgbaŋ ma wa dɩ ba vaa Mosisi mɩraha taaŋ, ta bɩ balɩ dɩ ba da gobi ba dembibisi kɔla ta da bɩ dɩa Juu vuosi chʋaraha. ");
INSERT INTO kma_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bɩa tɩ baaŋ yi lele ba wʋnna dɩ keŋye naa? ");
INSERT INTO kma_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Die wɩa yi wudieke tɩ bala fʋ. Dembisi banɩɩsa benne giena ta kaa kaatɩ aŋaŋ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Die wɩa gamma aŋaŋ ba a ga wʋnsɩ nɩ gbaŋ ta tuŋ ba wʋnsɩkʋ ligirehe ta nɩ wa wʋŋ nɩ sikpigile. Fʋ yi naa vuoŋ mana nan dɩ sɩba dɩ wudieke ba bala yaa gamma fʋ ma wa ka yi wusie, ba nan dɩ sɩba a baarɩ fʋ gbaŋ dɩ Mosisi mɩraha mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ama buurigaasɩsɩ die dɩ bɩrɩna Yisa dɩdɩɩsɩrɩba nɩŋ tɩ wɔŋ maagɩ wa gbanɩŋ a yɩ ba dɩ ba da keŋ a dii nyindiike dieke ba kaabɩna a yɩ bugile, yaa a ŋɔbɩma zɩŋ yaa dɔŋ dieke ba ŋmʋna a kʋʋ, ta bɩ vʋarɩ ba gbaŋ a nyɩŋ daakpana aŋaŋ hɔgʋkpana tʋʋma ma.” ");
INSERT INTO kma_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Naa chɩaŋ ma ka tʋnvʋʋsa Pɔɔli die dɩ nagɩ dembisi wʋnɩŋ aŋaŋ banɩŋ mana die dɩ wʋnsɩ ba gbaŋ ta juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ ma a dagɩ daa dieke ba bala ba wʋnsɩ ba gbaŋ a kpatɩ wa aŋaŋ saŋŋa dieke ba bala ba kaabɩ a yi ba wʋnyɩ mana. ");
INSERT INTO kma_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Die daraa ayʋpɔyɩ daraaŋ dɩ gbinene die Juu vuosi bataŋ die dɩ nyɩna Asia tɩŋgbaŋ ma die dɩ ye Pɔɔli Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ ta die wa kpɩkpaaŋ a keŋ lagɩŋ ta piili a tuole wo. ");
INSERT INTO kma_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ta die nata dɩ, “Juu vuosi! Nɩ suŋŋi tɩ. Daa wa gie dɩna dɩ dɩa a bala wʋbɩatɩ yaa gamma tɩ tɩŋgbaŋka gie aŋaŋ Mosisi mɩraha aŋaŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gie. Ta lele a bɩ nagɩ vuodiekemba dɩ kana ka yi Juu vuosi a keŋ juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ gie a yi ke dɩgɩntɩ.” ");
INSERT INTO kma_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Die ba balɩ wa naa dama, die ba ye wo Tirofimusi vuodieke dɩ nyɩna Efesusi aŋaŋ Pɔɔli tɩka sʋŋ ta yile dɩ Pɔɔli nagɩ wa mɩŋ a ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Die tɩka mana die dɩ dɔŋ ta vuosi mana dɩ chɩgɩ a keŋ lagɩsɩ taŋ a yigi Pɔɔli a datɩ wa a nyɩŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ. Die lele wo mi die ba ligi Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sanʋaha mana. ");
INSERT INTO kma_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Die ba wa mɩa dɩ ba kʋʋ Pɔɔli. Womi Romani sojasisi jakʋʋŋ die dɩ wʋŋ dɩ waagɩŋ bala ka nan Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Die ʋ yi lagɩ lagɩ a nagɩ sojasi aŋaŋ nyɩŋkʋra bataŋ ba chɩgɩ ga jigidieke kpɩkpaakʋ dɩ lagɩsɩna wa. Die kpɩkpaakʋ dɩ dene a ye jakʋʋrɩ aŋaŋ sojasisi die ba vaa Pɔɔli nɩgɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Die sojasisi jakʋʋrɩ die dɩ ga a ga yigi Pɔɔli ta vaa ba bɔbɩ wa chɔrɩsɩ ale ta pɩasɩ ba dɩ, “Mɩnɩa yine daa wa gie? Ta bɩa ʋ yi?” ");
INSERT INTO kma_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Die kpɩkpaakʋ dɩ nata tɔra tɔra. Die ba watɩ wɩa die sojasi jakʋʋrɩ dɩ ka bɩagɩ sɩba wudieke dɩ yine, die wɩa die ʋ yɩ ʋ sojasi nʋaŋ dɩ ba yaa Pɔɔli a jʋalɩ ga ba sojasisi jigiberisikiri. ");
INSERT INTO kma_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Die ba kenne tʋgɩ ka sanʋarɩ kpɩkpaakʋ die dɩ wa faasɩ tʋagɩ die wɩa sojasisi die dɩ nagɩ Pɔɔli a chii. ");
INSERT INTO kma_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Die kpɩkpaakʋ die dɩ dɩɩ ba kʋaŋ a nata dɩ, “Nɩ kʋʋ wa! Nɩ kʋʋ wa!” ");
INSERT INTO kma_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Die sojasisi die dɩ bala ba yaa wa juu wo, ʋ pɩasɩ jakʋʋrɩ dɩ, “N nan bɩagɩ a balɩ wɩɩŋ a yɩ fʋ?” Jakʋʋrɩ die dɩ pɩasɩ wa dɩ, “Lalɩa fʋ yi a bɩagɩ bala Giriiki jabalɩkɩŋ? ");
INSERT INTO kma_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Daa fʋ yine Ijipiti vuoke die dɩ vana waagɩŋ dɩ nan tɩŋgbaŋka mi saŋŋa dieke dɩ tɩanna wa ta die dɩ vuokʋʋla tuse anɩɩsa nɩŋŋa a yaa ba juu hagɩyeŋ?” ");
INSERT INTO kma_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔɔli die dɩ yiŋŋi balɩ dɩ, “Manɩŋ n yiwo Juu vuoŋ, ta ba mɩɩrɩ mɩŋ Taasusi ma, tɩgɩkpɩɩŋ dieke dɩ benne Silisia tɩŋgbaŋ ma. N jʋʋsa fʋ, yi mɩŋ sieŋ aŋ n balɩ wɩa a yɩ kpɩkpaakʋ.” ");
INSERT INTO kma_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Die sojasisi jakʋʋrɩ die dɩ yi wa sieŋ, die Pɔɔli dɩ hagɩ zie a nagɩ ʋ nuuŋ a diiŋ kpɩkpaakʋ ta balɩ ba dɩ ba tarɩ watɩ. Die ba tarɩna watɩtɩ Pɔɔli die dɩ nagɩ Juu vuosi jabalɩkɩŋ a bala wɩa a yɩa ba: ");
INSERT INTO kma_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“N chʋamba aŋaŋ n zʋalɩŋ nɩ wʋmma wudieke n bala n balɩ a yɩ nɩ wa.” ");
INSERT INTO kma_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Die ba wʋnna ʋ bala Juu vuosi jabalɩkɩŋ a yɩa ba wa, die ba tarɩ sɔmm. Womi Pɔɔli dɩ baarɩ dɩ, ");
INSERT INTO kma_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“N yiwo Juu vuoŋ, ta ba mɩɩrɩ mɩŋ Tasusi tɩŋ dieke dɩ benne Silisia tɩŋgbaŋ ma, ama ta ba wubi mɩŋ Jerusalemi ka gie mi. N dɩdagɩrʋ die yiwo Gamaliali ta die ʋ mɩŋŋɩ a dagɩ mɩŋ tɩ chɔɔŋkʋʋlɩba mɩraha. Ta die maŋ paalɩ dɩa Ŋmɩŋ aŋaŋ nɩŋŋmɩna sɩba nɩ mana dɩ dɩna die wo jinne. ");
INSERT INTO kma_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ta die mugise vuodieke mana die dɩ dɩna tɩ Yɔmʋtieŋ sieku ta kʋʋ bataŋ gbaŋ. Ta die yigi ba dembisi bataŋ aŋaŋ hɔgʋba bataŋ a ligi be dansarɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ŋmɩŋ kɩkaabɩtɩba jakʋʋrɩ aŋaŋ tɩka nyɩŋkʋraha nan dii siara dɩ dɩ yiwo wusie. Die ba ŋaaŋ yɩ mɩŋ gbaŋtɩ gbaŋ dɩ n yaa ga Juu vuosi nɩŋŋandɩɩsɩrɩba die dɩ benne Damasikusi ma wa jigiŋ, amʋ n nan bɩagɩ yigi vuodiekemba dɩ dɩna tɩ Yɔmʋtieŋ sieku mi a yaa ba a yiŋŋi keŋ Jerusalemi aŋ ba datɩ ba tɩbɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Die daaŋ kaanɩ yaa gamma agbaa saŋŋa die maŋ ga gbige Damasikusi, womi die chaankpeŋkpɩɩŋ die dɩ nyɩgɩsɩ bʋnyɩ a chaaŋ giliŋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Die maŋ nan tɩŋgbaŋ ta die wʋŋ lɔlɩŋ dɩ balala a yɩa mɩŋ dɩ, ‘Sɔɔli, Sɔɔli bɩa wɩa fʋ mugise mɩŋ?’ ");
INSERT INTO kma_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Die maŋ yiŋŋi a balɩ dɩ, ‘Mɩnɩa yine fʋ n Yɔmʋtieŋ?’ Ta die ʋ yiŋŋi a balɩ mɩŋ dɩ, ‘Manɩŋ n yiwo Yisa, Nazeriti vuoke, manɩŋ n yine vuodieke fʋ mugisinene wo.’ ");
INSERT INTO kma_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Die vuodiekemba die dɩ beelinene mɩŋ die ye chaaŋkʋ ama die ba ka wʋŋ lɔlɩkʋ. ");
INSERT INTO kma_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Die maŋ pɩasɩ dɩ, ‘N Yɔmʋtieŋ, bɩa fʋ yaala n yi?’ Womi die ʋ balɩ a yɩ mɩŋ dɩ, ‘Hagɩ a ga Damasikusi, dɩɩ yi fʋ keŋ tʋgɩ mi ba nan dagɩ fʋ fʋ bala fʋ yi wudieke.’ ");
INSERT INTO kma_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Die chaaŋkʋ die faasɩ nyɩgɩsɩ mɩŋ die maŋ yɩɩŋ. Die wɩa manɩŋ aŋaŋ vuodiekemba dɩ chʋnnana wa die dɩ datɩ n nuuŋ a yaa mɩŋ a ga Damasikusi ma. ");
INSERT INTO kma_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Daa wʋnyɩ die benne mi ba wasa wa Ananiasi. Die ʋ yiwo vuodieke dɩ jɩanna Ŋmɩŋ aŋaŋ wusie ta dɩ Mosisi mɩraha ta Juu vuosisi mana die dɩ benne Damasikusi ma die faasɩ yɩa wa jɩlɩma. ");
INSERT INTO kma_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Die ʋ keŋ a zie n jigiŋ ta baarɩ dɩ, ‘N zʋa Sɔɔli, yesime bɩbra.’ Lele womi die maŋ bɩagɩ yese. ");
INSERT INTO kma_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Womi Ananiasi die dɩ balɩ a yɩ mɩŋ dɩ, ‘Ŋmɩŋ dieke tɩ chɔɔŋkʋʋlɩba dɩ jɩanna wa vʋarɩna fʋ dɩ fʋ sɩmma wudieke ʋ yaalala dɩ fʋ yi. Ʋ vʋarɩ fʋ mɩŋ dɩ fʋ ye Masia wa ta bɩ wʋŋ ʋ gbaŋ gbaŋ ʋ lɔlɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Dɩ mʋ fʋ balɩ vuoŋ mana wudieke fʋ yene ta wʋŋ wa. ");
INSERT INTO kma_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ta lele bɩa fʋ bɩ chɩɩsa? Hagɩ aŋ n sɩɩ fʋ Ŋmɩŋ nyaabʋ, aŋ Ŋmɩŋ vaa fʋ wʋbɩatɩ a chaa fʋ fʋ jʋʋsɩna wa wɩa.’ ");
INSERT INTO kma_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ta die maŋ yiŋŋi ga Jerusalemi a ga juu Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ dɩ n jʋʋsɩ Ŋmɩŋ. Mi die maŋ daansɩ ");
INSERT INTO kma_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","a ye tɩ Yɔmʋtieŋ dɩ bala a yɩa mɩŋ dɩ, ‘Yi lagɩ lagɩ a nyɩŋ Jerusalemi ma, dama dɩɩ yi fʋ bala ba n wɩaha ba kaaŋ tuo dii.’ ");
INSERT INTO kma_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Die maŋ yiŋŋi a balɩ dɩ, ‘N Yɔmʋtieŋ ba wɔŋ sɩba dɩ die n ŋaaŋ gara Ŋmɩŋ jɩamɩŋ juone me a yige ta nɩga vuodiekemba dɩ tuone fʋ a dii wo. ");
INSERT INTO kma_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ta saŋŋa dieke die ba kʋna fʋ daansɩatieŋ Sitiiveni wa die n gbaŋ bie mi ta saagɩ dɩ ba kʋʋ wa, ta die zie a gbarɩ kʋkʋʋrɩba nyinyeeke.’ ");
INSERT INTO kma_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ama die tɩ Yɔmʋtieŋ die dɩ balɩ a yɩ mɩŋ dɩ n gamma, ta yɩ mɩŋ nʋaŋ dɩ ʋ nan yaa mɩŋ a ga saasaa vuodiekemba dɩ kana ka yi Juu vuosisi jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Die kpɩkpaakʋ die dɩ wʋmma Pɔɔli a ga tʋgɩ saŋŋa dieke ʋ bala naa a kpatɩ wa. Womi die ba piili a nata dɩ, “Nɩ kʋʋ daa wa gie ʋ ka mʋ dɩ ʋ bemme ʋ mɩsɩ ma.” ");
INSERT INTO kma_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Die ba keese ta naga ba garɩtɩ viise ŋmɩŋsikpeŋ ta yɔɔra tantɩ a taana ŋmɩŋsikpeŋ. ");
INSERT INTO kma_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Die Romani sojasisi jakʋʋrɩ die dɩ yɩ nʋaŋ dɩ ba nagɩ Pɔɔli a juu juoku me ta tɩbɩ wa aŋaŋ kpaasɩŋ. Amʋ ʋ nan balɩ wudieke ʋ yine wo ta Juu vuosi gie dɩ nata aŋaŋ wa. ");
INSERT INTO kma_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Die ba bɔbɩ wa a dʋaŋ dɩ ba tɩbɩ wa wa die ʋ pɩasɩ sojasisi nyɩŋkʋraha wʋnyɩ dɩ zene mi dɩ, “Mɩra yɩ sieŋ mɩŋ dɩ nɩ tɩbɩ vuodieke Romani naaŋ wa dɩ yɩna wa sieŋ ta ye ka dii ʋ sarɩya?” ");
INSERT INTO kma_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Die sojasisi jakʋʋrɩ dɩ wʋnna naa wa die ʋ ga ba nɩŋŋandɩɩsɩrʋ jigiŋ a baarɩ dɩ, “Bɩa fʋ yie? Daa wa gie yiwo vuodieke ta Romani naaŋ wa dɩ yɩna wa sieŋ.” ");
INSERT INTO kma_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sojasisi nyɩŋkʋra nɩŋŋandɩɩsɩrʋ wa die dɩ ga Pɔɔli jigiŋ a pɩasɩ wa dɩ, “Balɩ mɩŋ, yiwo vuodieke ta Romani naaŋ wa dɩ yɩna sieŋ?” Pɔɔli die dɩ yiŋŋi a baarɩ dɩ, “Wa.” ");
INSERT INTO kma_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Sojasisi nyɩŋkʋra nɩŋŋandɩɩsɩrʋ wa dɩ baarɩ dɩ, “Manɩŋ n tʋŋ wo ligire pam ta wa bɩrɩŋ vuodieke Romani naaŋ dɩ yɩna sieŋ.” Ama Pɔɔli die dɩ yiŋŋi a balɩ wa dɩ, “Manɩŋ nɩnɩŋ ba wɔŋ mɩɩrɩ mɩŋ mɩŋ aŋaŋ kanɩŋ sieku.” ");
INSERT INTO kma_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Die dembiŋ diekemba dɩ mɩnana dɩ ba tɩbɩ wa ta pɩasɩ wa wʋpɩasɩka ha die dɩ yiŋŋi kʋaŋ lagɩ lagɩ. Ta die ŋmaamɩŋ die yigi sojasisi nyɩŋkʋraha nɩŋŋandɩɩsɩrʋ wa gbaŋ die ʋ mɩŋŋɩna dɩ ʋ vaa ba bɔbɩ wa vuodieke Romani naaŋ wa dɩ yɩna wa sieŋ aŋaŋ chɔrɩmaha wɩa. ");
INSERT INTO kma_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Die ka tʋnvʋʋsa die sojasisi nyɩŋkʋraha nɩŋŋandɩɩsɩrʋ wa dɩ yaala ʋ mɩŋŋɩ wudieke wɩa Juu vuosisi nɩŋŋandɩɩsɩrɩba die dɩ bala dɩ Pɔɔli yi chʋʋsɩ mɩŋ. Die wɩa die ʋ vaa ba vʋarɩ chɔrɩmaha Pɔɔli ma ta die yɩ nʋaŋ dɩ Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha lagɩŋ. Womi die ʋ yaa Pɔɔli a keŋ juu ta vaa ʋ zie ba nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔɔli die dɩ daansɩ nyɩŋkʋraha die dɩ lagɩsɩna wa nine mi die ta die keŋ a baarɩ dɩ, “N nɩmballɩ, n ka chɩɩlɩya n sʋŋ ma yaa gamma n beriŋ Ŋmɩŋ nɩŋŋa a yaa keŋ tʋgɩ jinne.” ");
INSERT INTO kma_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Die Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ Ananiasi die dɩ yɩ vuodiekemba dɩ zene Pɔɔli lʋgɩrɩ nʋaŋ dɩ ba nɩgɩ ʋ nʋaŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔɔli die dɩ balɩ a yɩ wa dɩ, “Fʋnɩŋ gaamɩŋ dieke ba pentine jayɩalɩŋ a zieŋ, Ŋmɩŋ nan nɩgɩ fʋnɩŋ. Kalɩ wa giena a die mɩŋ sarɩya aŋaŋ Mosisi mɩraha ta bɩ balɩ dɩ ba nɩgɩ mɩŋ ta chʋʋsɩ mɩraha dama tɩ mɩraha ka yi sieŋ dɩ ba nɩgɩ vuoŋ.” ");
INSERT INTO kma_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Dembiŋ diekemba dɩ zene gbigi Pɔɔli wa die dɩ balɩ wa dɩ, “Fʋ ka sɩba a baarɩ dɩ zɩa wa Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ?” ");
INSERT INTO kma_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔɔli die dɩ yiŋŋi a balɩ ba dɩ, “N nɩmballɩ, n ka sɩba a baarɩ dɩ ʋ yiwo Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ. Ŋmɩŋ gbaŋkʋ balɩ tɩ dɩ tɩ da keŋ a balɩ wʋbɩatɩ a yɩ tɩ nɩŋŋandɩɩsɩrɩba.” ");
INSERT INTO kma_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Die Pɔɔli dɩ mɩŋŋɩna dɩ lagɩŋkʋ nyɩŋkʋraha bataŋ die yiwo Sadusisi ta bataŋ dɩaŋ dɩ yi Farasisi die ʋ baarɩ dɩ, “N nɩmballɩ n yiwo Farasi vuoŋ ta bɩ yi Farasisi vuoŋ bʋa. Ba die mɩŋ sarɩya giena dama n tuo dii mɩŋ dɩ kunti nan daansɩ hagɩ kuŋ me.” ");
INSERT INTO kma_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Die ʋ bala naa kpatɩ wa, nɩnhagɩrɩŋ die dɩ nan Farasisi aŋaŋ Sadusisi sʋnsʋŋ ta die ba puo bule. ");
INSERT INTO kma_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Dama die Sadusisi vuosisi die tuo dii dɩ kunti kaaŋ daansɩ hagɩ kuŋ mi ta bɩ baarɩ dɩ malakasi yaa haalɩtɩ wori: Ama Farasisi vuosisi nɩŋ die tuo wo wɩa ataa wa gie mana a dii.) ");
INSERT INTO kma_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Die wɩa die ba wa faasɩ nata ta mɩraha dɩdagɩrɩba bataŋ die dɩ yine Farasisi vuosisi die dɩ hagɩ zie ta baarɩ dɩ, “Tɩnɩŋ tɩ ka ye wudieke daa wa gie dɩ yine chʋʋsɩ, dɩ nan bɩagɩ yi haalɩŋ yaa malaka bala wɩaha a yɩa wa.” ");
INSERT INTO kma_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Die nɩnhagɩrɩbʋ die dɩ wa faasɩ ga tʋa ta ŋmaamɩŋ die dɩ yigi sojasisi nyɩŋkʋraha nɩŋŋandɩɩsɩrʋ wa dɩ ba nan keŋ yi Pɔɔli daŋŋa. Die wɩa die ʋ yɩ nʋaŋ dɩ ʋ sojasisi juu kpɩkpaakʋ sʋŋ a gbatɩ Pɔɔli a taaŋ a nagɩ wa a yiŋŋi ga ba jigiberisikiri. ");
INSERT INTO kma_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ka yuŋ tɩ Yɔmʋtieŋ die dɩ keŋ zie Pɔɔli jigiŋ a baarɩ dɩ, “Da vaa ŋmaamɩŋ yalla fʋ, sɩba die fʋ bala n wɩa die Jerusalemi ma wa die gbaŋ gbaŋ fʋ nan balɩ n wɩa Romi ma.” ");
INSERT INTO kma_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ka tʋnvʋʋsa sʋkʋʋŋ Juu vuosi bataŋ die lagɩsɩ a saŋ. Die ba hʋʋ dɩ ba kaaŋ dii jadiikiŋ yaa a nyu nyaaŋ a ga tʋgɩ saŋŋa dieke ba baaŋ nan kʋʋ Pɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Die vuodiekemba die dɩ sanna wa die tɩaŋ vuosi baŋɩsɩ-nɩɩsa. ");
INSERT INTO kma_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Die wɩa die ba ga Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ tɩka nyɩŋkʋraha jigiŋ a baarɩ dɩ, “Tɩ lagɩŋ hʋʋ mɩŋ dɩ tɩ kaaŋ dii jaaŋ mana a ga tʋgɩ saŋŋa dieke tɩ baaŋ nan kʋʋ Pɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Die wɩa nɩnɩŋ aŋaŋ lagɩŋkʋ nyɩŋkʋraha ga Romani sojasisi jakʋʋrɩ jigiŋ a paalɩ balɩ sɩba nɩ yaala nɩ paalɩ ye wudieke ʋ yine a chʋʋsɩ. Ta balɩ ba dɩ ba yaa wa keŋ nɩ sarɩya diile jigiŋ. Ama tɩ nan yi siri dɩ tɩ kʋʋ wa ta ʋ wa keŋ juu giena.” ");
INSERT INTO kma_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ama die Pɔɔli taa bʋa die dɩ wʋŋ ba saŋkʋ, die wɩa die ʋ ga sojasisi jigiberisikiri a balɩ Pɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pɔɔli die dɩ wʋnna naa wa die ʋ wa sojasisi nyɩŋkʋraha wʋnyɩ a balɩ yɩ wa dɩ, “Yaa dalʋakɩrɩ gie a ga jakʋʋrɩ jigiŋ, ta ʋ yaa wa wɩɩŋ a baa ʋ balɩ wa.” ");
INSERT INTO kma_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ta nyɩŋkʋraha wʋnyɩ wa die dɩ ʋ nɩŋŋa a yaa wa a ga jakʋʋrɩ jigiŋ a balɩ wa dɩ, “Pɔɔli vuodieke dɩ benne dansarɩka ma wa wana mɩŋ, a balɩ mɩŋ dɩ n yaa dalʋakɩrɩ gie a keŋ fʋ jigiŋ dama ʋ yaa wɩɩŋ a baa ʋ balɩ fʋ.” ");
INSERT INTO kma_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jakʋʋrɩ die dɩ yigi ʋ nuuŋ me a yaa wa nyɩŋ lʋgɩŋ a pɩasɩ wa dɩ, “Bɩa wɩɩŋ fʋ yaala fʋ balɩ mɩŋ?” ");
INSERT INTO kma_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ʋ yiŋŋi a balɩ wa dɩ, “Dembisi bataŋ sannana dɩ ba keŋ balɩ fʋ dɩ soriŋ fʋ yaa Pɔɔli a keŋ sʋʋŋ Juu vuosisi nyɩŋkʋra lagɩŋkʋ jigiŋ. Ba nan paalɩ yi sɩba ba yaala ba sɩmma wudieke ʋ paalɩ a yi chʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama da keŋ a tɔgɩŋ ba dama dembisi tɩaŋ baŋɩsɩ-nɩɩsa lɔbɩrɩna a gbarɩ wa. Dama ba hʋʋya mɩŋ dɩ ba kaaŋ dii jaaŋ yaa a nyuu nyaaŋ a ga tʋgɩ saŋŋa dieke ba baaŋ nan kʋʋ wa. Ta lele ba wa yiwo siri dɩ ba yi wudiekemba ba sanna wa ta chɩɩsa wudieke fʋ baaŋ nan balɩ.” ");
INSERT INTO kma_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Jakʋʋrɩ die dɩ baarɩ dɩ, “Da keŋ balɩ vuoŋ mana dɩ balɩ mɩŋ wɩɩrɩ gie.” Ta die taaŋ wa ʋ ga. ");
INSERT INTO kma_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Womi die jakʋʋrɩ die dɩ wa ʋ nyɩŋkʋra bale a balɩ ba dɩ, “Nɩ vʋarɩ sojasi kɔbɩsɩ-le aŋaŋ duunjʋalɩtɩŋ baŋɩsɩ-yʋpɔyɩ aŋaŋ tɩŋtaarɩŋ kɔbɩsɩ-le aŋ ba ga Siisiria yuku gie yaa gamma bimbilimiŋ awayɩ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ta nɩ yaalɩ duune a yɩ Pɔɔli aŋ ʋ jʋalɩ ta nɩ mɩŋŋɩ a daansɩma wa a yaa ga tʋgɩ vuokpɩɩŋ Felikisi jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jakʋʋrɩ die dɩ maagɩ gbanɩŋ dɩ: ");
INSERT INTO kma_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Manɩŋ Kolodiasi Lisiasi waasa fʋnɩŋ vuokpɩɩŋ Felikisi. ");
INSERT INTO kma_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Juu vuosi bataŋ die yigine daa wa gie a mɩa dɩ ba kʋʋ wa. Ama die n mɩŋŋɩna dɩ ʋ yiwo vuodieke Romani naaŋ wa dɩ yɩna sieŋ, die wɩa maŋ aŋaŋ n sojasi bataŋ dɩ ga gbatɩ wa taaŋ. ");
INSERT INTO kma_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Die n tɩŋ yaala n sɩmma wudieke ba bala dɩ ʋ yi chʋʋsɩ wa, die wɩa die maŋ yaa wa a ga ba nyɩŋkʋra lagɩŋkʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Die maŋ mɩŋŋɩ dɩ ʋ ka yi wudieke dɩ mʋna dɩ ba kʋʋ wa yaa ba nagɩ wa yi dansarɩka sʋŋ; die ba balala wudieke a galɩma wa die yiwo ba gbaŋ gbaŋ ba mɩraha wɩa. ");
INSERT INTO kma_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Die maŋ wʋŋ dɩ Juu vuosi bataŋ sama mɩŋ dɩ ba kʋʋ wa, maŋ tʋŋ dɩ ba yaa wa keŋ fʋ jigiŋ. Ta balɩ vuodiekemba dɩ galɩnnana wa dɩ ba yaa wɩɩrɩ a keŋ fʋ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sojasisi die dɩ yi wudieke jakʋʋrɩ die dɩ bala wa, ta die nagɩ Pɔɔli yuku mi a yaa ga Antipatirisi tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ka tʋnvʋʋsa die sojasisi die dɩ chʋnna nagɩsɩsɩ die dɩ yiŋŋi a keŋ ba jigiberisikiri ta vaa duunjʋalɩtɩba dɩ ba gamma aŋaŋ Pɔɔli. ");
INSERT INTO kma_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Die ba nagɩ wa a ga Siisiria ta die nagɩ gbaŋkʋ a yɩ vuokpɩɩkʋ Felikisi ta nagɩ Pɔɔli yi ʋ nuusi me. ");
INSERT INTO kma_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Vuokpɩɩkʋ die dɩ karɩŋ gbaŋkʋ ta die pɩasɩ Pɔɔli tɩgɩdieke ʋ nyɩna. Die ʋ mɩŋŋɩna dɩ Pɔɔli nyɩŋ wa Silisia tɩŋgbaŋ ma wa, ");
INSERT INTO kma_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ʋ baarɩ dɩ, “N nan wʋŋ fʋ wɩaha dɩɩ yi vuodiekemba dɩ galɩnnana fʋ wa dɩ keŋ.” Die ʋ balɩna kʋaŋ chaaŋ die ʋ yɩ nʋaŋ dɩ ba yaa Pɔɔli a ga yi naaŋ Herodi tigiŋ me a gbarɩ wa sɩba dansarɩka vuoŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ka daraa anʋ kʋaŋ chaaŋ Ŋmɩŋ kɩkaabɩtɩba jakʋʋŋ Aniasi aŋaŋ ba nyɩŋkʋraha bataŋ aŋaŋ lɔya wʋnyɩ ba wasɩnana Tetulusi die dɩ ga Siisiria ta ga vuokpɩɩŋ Felikisi jigiŋ dɩ ba balɩ wudieke Pɔɔli dɩ yine a chʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Die wɩa die ba wa Pɔɔli a keŋ juu ta Tetulusi die dɩ wa bala Pɔɔli dɩ yine wudieke wo dɩ: “Jakʋʋŋ Felikisi, fʋ wɩa yine tɩ tɩŋgbaŋka gie dɩ fɩalɩ ta fʋ baga dɩ benne tɩ ma wɩa fʋ wʋnsa tɩŋgbaŋka. ");
INSERT INTO kma_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tɩ mana nine suuliye aŋaŋ wudieke fʋ yinene wo ta tɩ waasa fʋ. ");
INSERT INTO kma_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","N ka yaala n chʋʋsɩ fʋ saŋŋa ama ko dii suguru aŋaŋ tɩ ta fʋ wʋŋ tɩ wɩaha gie bɩta. ");
INSERT INTO kma_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tɩ ye ta daa wa gie yiwo vuobɩaŋ ta yi jigiŋmabɩrʋ ta vasa Juu vuosisi dɩ waga tɩŋgbaŋka gie mana. Wʋnɩŋ ʋ bɩ yiwo Nazarenesi jɩamɩŋ nɩŋŋandɩɩsɩrʋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Die ʋ mɩa dɩ ʋ chʋʋsɩ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ, die wɩa tɩ yigi wo. ((Die tɩ tɩŋ yaala tɩ dii ʋ sarɩya aŋaŋ tɩ gbaŋ gbaŋ tɩ mɩraha dɩ dagɩna die wo ");
INSERT INTO kma_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ama ta sojasisi jakʋʋŋ Lisiasi die dɩ keŋ juu aŋaŋ tʋaŋ a gbatɩ wa nyɩŋ tɩ jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Naa kʋaŋ chaaŋ Lisiasi die dɩ yi nʋaŋ dɩ vuodiekemba dɩ balala dɩ ʋ yiwo bɩabʋ keŋ fʋ nɩŋŋa.)) Dɩɩ yi fʋ pɩasɩ daa wa gie fʋ gbaŋ nan dɩ sɩba wudieke tɩ balala dɩ ʋ yiwo mana yiwo wusie.” ");
INSERT INTO kma_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Die Juu vuosisi die dɩ lagɩsɩna mi die dɩ baarɩ dɩ wɩaha mana yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mi die naaŋ wa die dɩ nagɩ ʋ nuuŋ a diiŋ Pɔɔli dɩ ʋ balɩ wɩa. Die ʋ piili dɩ: “N sɩba a baarɩ fʋ yine tɩnɩŋ Juu vuosi sarɩya diiru bɩna pam, die wɩa n yaa sʋgɩfɩalɩŋ dɩ n balɩ vʋarɩ n gbaŋ fʋ naalɩakʋ gie me. ");
INSERT INTO kma_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Dɩɩ yi fʋ yaala, nan bɩagɩ a pɩasɩ a sɩmma dɩ ka ka tɩaŋ daraa baŋ aŋaŋ ale die maŋ jʋalɩ ga Jerusalemi dɩ n ga jɩaŋ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Die Juu vuosisi die ka ye mɩŋ ta n nɩga nɩnhagɩrɩŋ aŋaŋ vuoŋ Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ yaa a lagɩsa vuosi a vasa ba sɩnyɩɩrɩŋ dɩ haga Ŋmɩŋ jɩamɩŋ juone me yaa tɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ba kaaŋ bɩagɩ a dagɩ dɩ ŋmɩnchɩbɩsɩ dieke ba chɩbɩna a yɩ mɩŋ wa yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Manɩŋ n bala nɩ dɩ sie dieke n dɩna ta Juu vuosisi dɩ bala dɩ die sieku ka vɩɩna wa ama manɩŋ n ye ko jɩama tɩ chɔɔŋkʋʋlɩŋ Ŋmɩnnɩ. Wudieke mana dɩ maagɩna Mosisi mɩraha gbaŋtɩ sʋŋ aŋaŋ Ŋmɩŋ naazʋalɩba gbaŋtɩ sʋŋ wa, n yi a mana yada mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N yaa tama sɩba vuosi gie, dɩ Ŋmɩŋ nan daansɩ vaa vuovɩɩna yaa vuobɩatɩ hagɩ kuŋ me. ");
INSERT INTO kma_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Die wɩa n mɩa mɩŋ dɩ n yi wudieke dɩ mʋna Ŋmɩŋ aŋaŋ vuota nɩŋŋa ta ka chɩɩlɩya n sʋŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Die n nyɩna Jerusalemi a yʋasɩ wa wɩa, maŋ yiŋŋi ga aŋaŋ piini dɩ n yɩ zɔɔlɩntieliŋ mi ta bɩ yi kaaba a yɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Die n wʋnsɩna n gbaŋ a kpatɩ wa ta die bie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋkʋ ta die yie kaabaha die ba juu ye mɩŋ. Saŋka mi ta vuosi ye ka dala mi ta watɩ die dɩ wori. ");
INSERT INTO kma_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama Juu vuosi bataŋ die dɩ nyɩna Asia tɩŋgbaŋ ma gbaŋ die bie mi saŋka mi: ta dɩɩ yi die ba ye n chʋʋsɩŋ ka tɩŋ mʋ ba keŋ gie a keŋ balɩ chʋʋsɩ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yaa vaa vuodiekemba dɩ benne gie dagɩ wudieke a yine a chʋʋsɩ saŋŋa dieke n zene ba nyɩŋkʋraha nɩŋŋa wa. ");
INSERT INTO kma_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Die ba ka ye wudieke n chʋʋsɩna ntaala wʋbalɩmɩŋ nyɩɩna ma maŋ balɩ ba sʋŋ dɩ, ‘Nɩ die mɩŋ sarɩya jinne dama n tuone a dii dɩ kunti nan daansɩ hagɩ kuŋ me wo.’ ” ");
INSERT INTO kma_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikisi die sɩba tɩ Yɔmʋtieŋ sieti wɩa ta die vaa wɩɩrɩ ta baarɩ dɩ, “N nan balɩ wudieke n yalla dɩ yi sojasisi jakʋʋŋ Lisiasi dɩ keŋ tʋgɩ.” ");
INSERT INTO kma_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ta die yi soja dieke dɩ gbarɩna Pɔɔli nʋaŋ dɩ ʋ gbarɩ wa, ama ta vaa Pɔɔli bemme ʋ dʋŋŋʋ ta vaa ʋ zʋalɩŋ yɩma wa jadieke ʋ yaalala. ");
INSERT INTO kma_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Daraa a ŋmɩna kʋaŋ chaaŋ, jakʋʋŋ Felikisi dɩ keŋ aŋaŋ ʋ hɔgʋ Dirusila, vuodieke dɩ yine Juu vuoŋ ta die vaa ba wa Pɔɔli ʋ keŋ, ta Pɔɔli die dɩ bala yaa gamma vuoŋ dɩ baaŋ nan yi Yisa Masia yada dene. Ta wʋnɩŋ Felikisi die dɩ wʋmma. ");
INSERT INTO kma_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama Pɔɔli die dɩ bɩ bala yaa gamma vɩɩnɩŋ yiile aŋaŋ yigi n gbaŋ aŋaŋ dʋnɩa kpatɩ sarɩya diile wɩaha, ŋmaamɩŋ die dɩ yigi jakʋʋŋ Felikisi ʋ baarɩ dɩ, “Lele nan bɩagɩ ga. N nan bɩ wa fʋ maŋ keŋ ye sieŋ.” ");
INSERT INTO kma_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ama Felikisi saŋka mi die yile dɩ Pɔɔli nan kpalɩ wa aŋaŋ ligire, die wɩa ʋ ŋaŋ wa wa mɩŋ, ʋ aŋaŋ wa dɩ bala wɩa. ");
INSERT INTO kma_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ka bɩna ale kʋaŋ chaaŋ Posiwosi Fesitusi die dɩ tuo vuokpɩɩŋ Filikisi naŋ ma a zie. Ama vuokpɩɩŋ Filikisi die dɩ balla ʋ vaa tʋʋmaha, die ʋ yaala Juu vuosi yallɩma sʋgɩfɩalɩŋ aŋaŋ wa, die wɩa die ʋ vaa Pɔɔli dansarɩka sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Jakʋʋŋ Fesitusi die dɩ kenne Siisiria, ka daraa ataa kʋaŋ chaaŋ ʋ nyɩŋ mi ta jʋalɩ ga Jerusalemi. ");
INSERT INTO kma_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mi die Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha aŋaŋ Juu vuosi nyɩŋkʋraha die dɩ keŋ Fesitusi jigiŋ a chɩbɩ ŋmɩnchɩbɩsɩ a yɩ Pɔɔli ta die jʋʋsɩ Fesitusi dɩ ");
INSERT INTO kma_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ʋ vaa Pɔɔli keŋ Jerusalemi ma. Die ba jʋʋsɩ wa dɩ ʋ yi naa dama die ba wɔŋ saŋ mɩŋ dɩ ba lɔbɩrɩ a kʋʋ Pɔɔli sieŋ me mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesitusi die dɩ yiŋŋi a balɩ dɩ, “Pɔɔli bemme dansarɩka sʋŋ Siisiria, ta n gbaŋ n nan yiŋŋi a ga mi daraa ale ka gie nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Die wɩa, nɩ vaa nɩ nɩŋŋandɩɩsɩrɩba bataŋ ga aŋaŋ mɩŋ Siisiria a ga balɩ wudieke ʋ yine, dɩɩ yi ʋ yi wɩɩŋ a chʋʋsɩ.” ");
INSERT INTO kma_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitusi die dɩ bɩ dii daraa anɩɩ yaa daraa baŋ ba jigiŋ ta die nyɩŋ ga Siisiria. Ka tʋnvʋʋsa die ʋ juu kalɩ ʋ sarɩya diile gbaŋtɩ ma ta yɩ nʋaŋ dɩ ba yaa Pɔɔli keŋ juu. ");
INSERT INTO kma_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Die Pɔɔli dɩ kenne juu wo die Juu vuodiekemba dɩ nyɩna Jerusalemi a keŋ wo dɩ zie a giliŋ wo, a piili bala wʋbɩatɩ a chʋʋsa wa, ama die ba ka bɩagɩ dagɩ dɩ ba wɩɩrɩ yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Die wɩa Pɔɔli die dɩ bala dɩ ʋ gbatɩ ʋ gbaŋ dɩ, “Manɩŋ n ka yi wɩɩŋ a chʋʋsɩ Juu vuosi mɩraha yaa Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ jaaŋ yaa Romani vuosi naakpɩɩka.” ");
INSERT INTO kma_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ama Fesitusi die dɩ yaala ʋ yi aŋ Juu vuosisi sʋŋ fɩalɩ, die wɩa die ʋ pɩasɩ Pɔɔli dɩ, “Nan dɩ yaala fʋ ga Jerusalemi aŋ n ga dii fʋ sarɩya aŋaŋ wɩaha gie mi?” ");
INSERT INTO kma_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔɔli die dɩ baarɩ dɩ, “Aayɩ, n yaala Romani naakpɩɩŋ gbaŋ dii n sarɩya. N ka yi wɩɩŋ a chʋʋsɩ Juu vuosisi sɩba fʋ gbaŋ gbaŋ fʋ sɩbɩna dene. ");
INSERT INTO kma_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Dɩɩ yi maŋ chʋʋsɩ wa ba mɩraha ta yi wudieke dɩ mʋna kuŋ n tɩŋ kaaŋ baarɩ nɩ da kʋʋ mɩŋ. Ama dɩɩ yi wudieke ba bala dɩ n yiye wo dɩ ka yi wusie, vuoŋ wori a baaŋ nan bɩagɩ a nagɩ mɩŋ a yi ba nuusi me. Ama lele n jʋʋsa dɩ nɩ vaa Romani naakpɩɩŋ Siiza gbaŋ gbaŋ dii n sarɩya.” ");
INSERT INTO kma_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Womi Fesitusi aŋaŋ lagɩŋkʋ nyɩŋkʋraha dɩ ye taŋ ta ʋ yiŋŋi balɩ dɩ, “Fʋnɩŋ jʋʋsɩya mɩŋ dɩ nan nagɩ fʋ wɩɩrɩ a poli ga naakpɩɩŋ Siiza jigiŋ, die wɩa ba yaa fʋ ga ʋ jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Die daraa ale kʋaŋ chaaŋ, naaŋ Agiripa aŋaŋ ʋ hɔgʋ Beniisi dɩ keŋ Siisiria dɩ ba kaagɩ jakʋʋŋ Fesitusi. ");
INSERT INTO kma_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Die ba yine daraa ŋmɩna mi, ta Fesitusi die dɩ keŋ balɩ Pɔɔli dɩ benne wudieke ma a yɩ naaŋ Agiripa dɩ, “Felikisi vaa wa daa wʋnyɩ giena dansarɩka sʋŋ, ");
INSERT INTO kma_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ta die maŋ ga Jerusalemi Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋra aŋaŋ Juu vuosi nyɩŋkʋra dɩ keŋ n jigiŋ a baarɩ dɩ n dii ʋ sarɩya a baarɩ dɩ ʋ chʋʋsɩya. ");
INSERT INTO kma_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ama die maŋ yiŋŋi balɩ ba dɩ tɩnɩŋ Romanisi mɩra wo sieŋ dɩ ba nagɩ vuodieke vuosi dɩ balala dɩ ʋ yiwo wʋbɩaŋ a yi ba nuusi me, ta ba ye ka yaa wa ga sarɩya diile jigiŋ ta wʋnɩŋ aŋaŋ ba tuoli taŋ dɩ ʋ balɩ a vʋarɩ ʋ gbaŋ. ");
INSERT INTO kma_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Die wɩa die ba kenne giena wa die n ka chʋʋsɩ saŋŋa, ka tʋnvʋʋsa die maŋ juu kalɩ n sarɩya gbaŋtɩ ma ta yɩ nʋaŋ dɩ ba yaa Pɔɔli a keŋ. ");
INSERT INTO kma_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","“Ama vuodiekemba die dɩ balala a chʋʋsa wa wa dɩ hagɩna zie dɩ ba balɩ wudieke ʋ yine wo, die ba ka balɩ wʋbɩaŋ diekemba n yilinene dɩ ba nan balɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ama die ka yiwo nɩnhagɩrɩŋ ba nɩgɩna aŋaŋ wa yaa gamma ba gbaŋ gbaŋ ba jɩamɩŋ aŋaŋ daa wʋnyɩ die dɩ kpine ta ʋ saaŋ dɩ dɩ Yisa wɩa, vuodieke Pɔɔli dɩ bala dɩ ʋ bie ʋ mɩsɩ ma. ");
INSERT INTO kma_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","“Die n zɩ n baaŋ nan dii sarɩyaka dene wɩa, die maŋ pɩasɩ Pɔɔli dɩ ʋ nan dɩ yaala ʋ ga Jerusalemi aŋ n dii wo sarɩya mi. ");
INSERT INTO kma_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama die ʋ baarɩ dɩ ba vaa ʋ bemme dansarɩka ma a ga tʋgɩ saŋŋa dieke Romani naakpɩɩka dɩ baaŋ nan dii ʋ sarɩya ka. Die wɩa die maŋ yɩ nʋaŋ dɩ ba nagɩ wa yi dansarɩka sʋŋ giena a ga tʋgɩ saŋŋa dieke n baaŋ nan yaa wa a ga Romani naakpɩɩka jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Womi naaŋ Agiripa dɩ balɩ yɩ Fesitusi dɩ, “N gbaŋ n yaala n wʋŋ daa wa wɩaha a nyɩŋ ʋ gbaŋ gbaŋ ʋ nʋaŋ ma.” Fesitusi die dɩ yiŋŋi balɩ dɩ, “Nan wʋŋ wa soriŋ.” ");
INSERT INTO kma_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ka tʋnvʋʋsa naaŋ aŋaŋ ʋ hɔgʋ Beniisi die dɩ bɔbɩ aŋaŋ nyinyeeki dʋnsa a keŋ juu lagɩŋkʋ juoku me. Die sojasisi nyɩŋkʋra aŋaŋ tɩka nyɩŋkʋra die dɩ dɩɩ ba kʋaŋ a keŋ juu mi. Fesitusi die dɩ yɩ nʋaŋ ba yaa Pɔɔli keŋ juu. ");
INSERT INTO kma_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesitusi die dɩ baarɩ dɩ, “Naaŋ Agiripa aŋaŋ vuodiekemba mana dɩ benne gie nɩ daansɩ daa wa gie. Juu vuodiekemba mana dɩ benne Jerusalemi aŋaŋ Siisiria keŋ wo n jigiŋ ta nata dɩ ʋ mʋ kuŋ. ");
INSERT INTO kma_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ama manɩŋ n ka ye wudieke ʋ yine a chʋʋsɩ ta mʋ kuŋ. Ta ʋ gbaŋ dɩ bala dɩ tɩ yaa wa ga Romani naakpɩɩka jigiŋ aŋ ʋ dii wo ʋ sarɩya ka. Die wɩa n saŋya mɩŋ dɩ n yaa wa ga Romi. ");
INSERT INTO kma_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama n paalɩ wo wudieke n baaŋ nan maagɩ yaa gamma daa wa gie wɩa a yaa ga yɩ Romanisi naakpɩɩka. Die wɩa maŋ yaa wa keŋ nɩ mana nɩŋŋa aŋaŋ fʋnɩŋ naaŋ Agiripa. Tɩ keŋ balɩ wɩɩrɩ gie kpatɩ n nan wa yaa wɩɩŋ aŋ n maagɩ. ");
INSERT INTO kma_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Dama dɩ wo chɩaŋ aŋ n vaa dansarɩka vuoŋ ga naakpɩɩka jigiŋ ta kaaŋ bɩagɩ dagɩ wudieke ʋ yine chʋʋsɩ.” ");
INSERT INTO kma_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Womi Agiripa die dɩ balɩ yɩ Pɔɔli dɩ, “N yɩ fʋ sieŋ dɩ fʋ balɩ a vʋarɩ fʋ gbaŋ.” Pɔɔli die dɩ nagɩ ʋ nuuŋ a diiŋ ta baarɩ dɩ: ");
INSERT INTO kma_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Naaŋ Agiripa! N sʋŋ fɩalɩya mɩŋ fʋ yɩna mɩŋ sieku gie dɩ n balɩ a vʋarɩ n gbaŋ fʋ nɩŋŋa jinne, yaa gamma wudiekemba mana n gbaŋ gbaŋ n vuosi dɩ bala dɩ n yi chʋʋsɩ wa. ");
INSERT INTO kma_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Fʋnɩŋ fʋ sɩbɩna tɩnɩŋ Juu vuosi mɩraha aŋaŋ wudiekemba dɩ yine tɩ nɩnhagɩrɩŋ mana. Die wɩa n jʋʋsa fʋ, dii suguru ta fʋ wʋmma wudieke n bala n balɩ naa. ");
INSERT INTO kma_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Die n yine bʋabiŋ a yaa ga mʋʋna Juu vuosi mana wɔŋ sɩba die n benne die n tɩŋgbaŋ ma aŋaŋ Jerusalemi ma. ");
INSERT INTO kma_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ba wɔŋ sɩba a yʋasɩ. Dɩɩ yi ba yaala ba nan bɩagɩ dagɩ fʋ dɩ die n gʋtɩ wa Farasisi diekemba die dɩ mɩŋŋɩna a dɩa Ŋmɩŋ mɩraha. ");
INSERT INTO kma_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ama lele ba die mɩŋ sarɩya dama n yaa tama aŋaŋ nʋa dieke Ŋmɩŋ dɩ yɩna tɩ chɔɔŋkʋʋlɩba kʋrɩŋ ma wa. ");
INSERT INTO kma_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nʋarɩ gie wɩa ta tɩnɩŋ Juu vuosi buuriŋ baŋ aŋaŋ ale die dɩ yaa tama ta yile dɩ tɩ nan daansɩ yeke. Die wɩa tɩ jɩama Ŋmɩŋ aŋaŋ nɩŋŋmɩna ŋmɩntʋasɩ aŋaŋ yuŋ mana. Jakʋʋŋ Agiripa, tamaka gie wɩa Juu vuosisi dɩ bala dɩ n chʋʋsɩya mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bɩa wɩa dɩ hagɩrɩ a yɩ nɩ dɩ nɩ tuo a dii dɩ Ŋmɩŋ vasa kunti dɩ haga kuŋ me? ");
INSERT INTO kma_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Piiliku me die n gbaŋ n mɩa mɩŋ dɩ n yi wɩɩŋ mana a chʋʋsɩ Yisa vuodieke dɩ nyɩna Nazeriti wa saaŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Naa die maŋ yi Jerusalemi ma ma. Die maŋ tuose yiko gbanɩŋ a nyɩna Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha jigiŋ ta die yige Ŋmɩŋ vuosi pam a yie dansarɩka sʋŋ. Ba keŋ dii ba sarɩya ta baarɩ dɩ ba kʋʋ ba n gbaŋ gbaŋ ŋaŋ gʋta wa vuodiekemba dɩ bala dɩ ba kʋʋ ba wa ma. ");
INSERT INTO kma_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","“Saŋŋa mana n ŋaŋ mugisi be mɩŋ Ŋmɩŋ jɩamɩŋ juone me dɩ ba chiisi dɩ ba ka dɩ Yisa. Die ba wɩa dɩ paala yaa mɩŋ sɩnyɩɩrɩŋ wɩa maŋ gara tɩŋgbaŋ gaasɩ a yaala ba jigiŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Naa wɩa, daaŋ kaanɩ die maŋ gara Damasikusi dɩ n mugisi Yisa dɩdɩɩsɩrɩŋ aŋaŋ yiko dieke Ŋmɩŋ kɩkaabɩtɩba nyɩŋkʋraha die yɩna mɩŋ ta bɩ yɩ mɩŋ nʋaŋ dɩ n yi wo. ");
INSERT INTO kma_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Jakʋʋŋ Agiripa, die ka yiwo ŋmɩŋsikpeŋ ta maŋ bie sieŋ me a gara, ta die keŋ ye chaanɩŋ nyɩŋ ŋmɩŋsikpeŋ a chaana a tɩaŋ ŋmɩŋ, ta nyɩgɩsa ta taaŋ giliŋ mɩŋ aŋaŋ n siechɔntɩ chanchaalɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Die tɩ mana die dɩ nan tɩŋgbaŋ, ta die maŋ wʋŋ lɔlɩŋ dɩ balɩ tɩnɩŋ Juu vuosi jabalɩkɩŋ ma dɩ, ‘Sɔɔli Sɔɔli, bɩa wɩa fʋ mugise mɩŋ? Dɩ yiwo gaantɩŋ fʋ wagɩnana aŋaŋ manɩŋ.’ ");
INSERT INTO kma_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Die maŋ yiŋŋi pɩasɩ dɩ, ‘N Yɔmʋtieŋ, mɩnɩa yine fʋ?’ Ta tɩ Yɔmʋtieŋ die dɩ yiŋŋi a baarɩ dɩ, ‘Manɩŋ Yisa fʋ mugise die. ");
INSERT INTO kma_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ama hagɩ a zie fʋ nagɩsɩ ma. N nyɩŋ fʋ jigiŋ dama fʋnɩŋ maŋ vʋarɩ dɩ fʋ yi n tʋntʋntʋ. Yime siara a balɩ vuosi wudieke fʋ yene yaa gamma n wɩa jinne aŋaŋ wudieke n baaŋ nan dagɩ fʋ soriŋ daaŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N nan daansɩ gbatɩ fʋ a nyɩŋ Juu vuosi nuusi me aŋaŋ buurigaasɩ dieke jigiŋ n bala n tʋŋ fʋ nuusi me. ");
INSERT INTO kma_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Fʋnɩŋ yiwo vuodieke dɩ bala ʋ yuori ba nine a vʋarɩ ba nyɩŋ lɩmɩŋ ma a ga chaanɩŋ ma, a bɩ vʋarɩ ba a nyɩŋ Sitaani nuusi me aŋ ba juu Ŋmɩŋ nuusi me, aŋ ʋ vaa ba wʋbɩatɩ a chaa ba aŋ ba gʋtɩ vuodiekemba Ŋmɩŋ dɩ vʋarɩna wa ma, dama ba yine mɩŋ yada wa wɩa.’ ");
INSERT INTO kma_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Die wɩa, naaŋ Agiripa, die n ka zetiye die n yene daansɩ dieke a nyɩŋ arɩzanna ma wa. ");
INSERT INTO kma_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Die n woliŋ a mʋʋlɩ Ŋmɩŋ wʋvɩɩnaha a yɩ Damasikusi vuosi, ta die nyɩŋ ga Jerusalemi aŋaŋ Judia tɩgɩsɩ mana. Naa kʋaŋ chaaŋ maŋ ga mʋʋlɩ a yɩ vuodiekemba dɩ kana ka yi Juu vuosisi. Wudieke n balla a yɩa vuosisi gie mana yiwo, ba vaa ba tʋmbɩatɩ ta dɩa Ŋmɩŋ sieŋ, ta tʋmma tʋnvɩɩna aŋ ka dagɩ sɩba ba seŋ vaa ba tʋmbɩatɩ aŋaŋ wusie. ");
INSERT INTO kma_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","“Naa wɩa die Juu vuosisi die dɩ yigi mɩŋ, die n ŋaana bie Ŋmɩŋ jɩamɩŋ juokpeŋkpɩɩkʋ sʋŋ, ta die yaala ba kʋʋ mɩŋ wa. ");
INSERT INTO kma_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama Ŋmɩŋ suŋŋine mɩŋ dene a keŋ tʋgɩ jinne daarɩ gie maŋ zie dɩ n balɩ wusie a yɩ vuoŋ mana, wabɩtɩ aŋaŋ hagɩrɩtieliŋ. Wudieke n bala aŋaŋ wudieke Ŋmɩŋ naazʋalɩŋ aŋaŋ Mosisi die dɩ balla a nan yiwo, yiwo jabalɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","N balɩ ba Ŋmɩŋ Vuovʋarɩkɩŋ Masia wa die dɩ bala ʋ gbalɩgɩ gbalɩgɩ dieke ta kpi, ta wʋnɩŋ ʋ balla ʋ yi bʋmbʋŋaŋ vuodieke dɩ bala ʋ woliŋ a hagɩ kuŋ me, die wɩa ʋ nan balɩ yɩ Juu vuosisi aŋaŋ vuodiekemba dɩ kana ka yi Juu vuosisi dɩ ba nan bɩagɩ ye gbatɩtaanɩŋ. Naa nan yi sɩba chaanɩŋ a yɩ ba.” ");
INSERT INTO kma_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔɔli die dɩ balala dɩ ʋ gbatɩ ʋ gbaŋ a taaŋ wa, Fesitusi die dɩ natɩ wa a baarɩ dɩ: “Pɔɔli, yiwo yɩɩŋyaaŋ! Fʋ bʋgɩrɩna nyinti pam wa yine fʋ juu yɩɩŋyaatɩ die!” ");
INSERT INTO kma_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ta Pɔɔli die yiŋŋi a balɩ wa dɩ, “Jakʋʋŋ Fesitusi, n ka juu yɩɩŋyaatɩ! Wudieke n balɩnana yiwo wusie ta bɩ yaa chɩaŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Jakʋʋŋ Agiripa, n yaa sikimiŋ ta nan bɩagɩ balɩ a yɩ fʋ dama fʋ gbaŋ fʋ sɩbɩna ha wɩa, ta bɩ yi yada dɩ wɩaha gie yaa gamma Yisa wa ka lɔbɩrɩ fʋ jigiŋ, dama wudieke die yine wo die ka yi lɩmɩŋ ma.” ");
INSERT INTO kma_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Die Pɔɔli dɩ bɩ balɩ a yɩ naaŋ Agiripa dɩ, “Fʋnɩŋ, yi Ŋmɩŋ naazʋalɩŋ wʋbalɩkaha yada mɩŋ? N wɔŋ sɩba a baarɩ fʋ yi yada mɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ta naaŋ Agiripa die dɩ yiŋŋi balɩ Pɔɔli dɩ, “Aŋaŋ fʋ wʋbalɩka bɩta ka gie fʋ yile dɩ nan bɩagɩ tarɩgɩ mɩŋ a yi Yisa dɩdɩɩsɩrʋ?” ");
INSERT INTO kma_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔɔli die dɩ yiŋŋi a balɩ wa dɩ, “Wʋbalɩkɩ waŋ yaa wʋbalɩkɩ gobiŋ, manɩŋ n Ŋmɩŋ jʋʋsɩŋ yiwo dɩ fʋnɩŋ aŋaŋ vuosi gie mana die dɩ wʋnna n wʋbalɩkaha jinne wo bɩrɩŋ Yisa dɩdɩɩsɩrɩŋ sɩba manɩŋ ntaala dansarɩka gie nyɩɩna ma n ka yaala nɩ juu.” ");
INSERT INTO kma_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Womi naaŋ Agiripa aŋaŋ jakʋʋŋ Fesitusi aŋaŋ Beniisi aŋaŋ vuodieke mana die dɩ benne ba jigiŋ die dɩ hagɩ nyɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ama die ba bala ba nyɩŋ wa die ba baarɩ dɩ, “Daa wa gie ka yi wʋbɩaŋ kaanɩ gbaŋ. Ʋ ka mʋ ba kʋʋ wa yaa ba nagɩ wa a yi dansarɩka sʋŋ.” ");
INSERT INTO kma_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ta naaŋ Agiripa die dɩ balɩ yɩ jakʋʋŋ Fesitusi dɩ, “Tɩ tɩŋ nan bɩagɩ a vʋarɩ daa wa gie a taaŋ dɩɩ yi die ʋ tɩŋ ka poli ʋ wɩɩrɩ gie a ga naakpeŋkpɩɩŋ Siiza jigiŋ.” ");
INSERT INTO kma_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Die ba kenne saŋ dɩ ba nagɩ Pɔɔli a ga Romi, Itali tɩŋ ma, die ba nagɩ wa aŋaŋ dansarɩka vuosi bataŋ a yɩ Romani sojasisi jakʋʋŋ wʋnyɩ nuuŋ me ba wasɩnana wa Julusi, die ʋ benne sojasisi chaakʋ die ba wasɩnana Naalɩba jakʋʋŋ Chaakʋ. ");
INSERT INTO kma_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tɩ mana die dɩ ga juu haarɩ dieke die dɩ nyɩna Adiramitiwomi, dama die haarɩkʋ die wɔŋ yi siri dɩ ka nyɩŋ Siisiria a ga Asia tɩŋgbaŋ ma tɩgɩ diekemba die dɩ gbɩgɩna mʋgɩkpɩɩrɩ. Ta Masedonia vuoŋ, Arisitakusi, vuodieke dɩ nyɩna Tesalonika die gʋtɩ wa tɩ ma. ");
INSERT INTO kma_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ka tʋnvʋʋsa die tɩ tʋgɩ Sidoni. Sojasisi jakʋʋŋ, Julusi die mɩŋŋɩ a pɔgɩlɩ Pɔɔli ta die yɩ wo sieŋ dɩ ʋ ga ʋ zʋalɩŋ jigiŋ aŋ ba yi wa ʋ nyɩŋyaalɩka. ");
INSERT INTO kma_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Die tɩ nyɩna Sidoni ta bʋlɔgɩsɩŋ die dɩ nɩga a tuole tɩ, die wɩa die tɩ dɔŋ daagɩ Saapurusi tɩŋgbaŋ chaakʋ, ta tɩŋgbaŋka die dɩ kagɩ tɩ a nyɩŋ bʋlɔgɩsɩkʋ ma. ");
INSERT INTO kma_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Die tɩ dɔŋ tɩaŋ ga Silisia aŋaŋ Pamifilia tɩŋgbaŋ chaakʋ ta ga tʋgɩ Mira tɩŋ, Lisia tɩŋgbaŋ mama, ta sʋʋŋ mi. ");
INSERT INTO kma_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mi die sojasisi jakʋʋrɩ die dɩ ye haarɩ dieke dɩ nyɩna Alekizandira a tɩaŋ a gara Itali tɩŋgbaŋ, ʋ vaa tɩ juu kanɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Die tɩ dɔŋ sɔmm sɔmm daraa pam a keŋ paalɩ gbalɩgɩ ta ye keŋ tʋgɩ Kinidusi tɩŋ ma. Bʋlɔgɩsɩbʋ die dɩ faasɩ tuoli tɩ mi chaakʋ wɩa die tɩ ka bɩagɩ dɔŋ gara mi. Die wɩa die tɩ daagɩ ga Kireeti tɩŋgbaŋ lʋgɩŋ. Dama mi die bʋlɔgɩsɩbʋ die dɩ ka faasɩ hagɩrɩ, die tɩ keŋ gbigi Salimoni, Kireeti tɩŋgbaŋ ma, a ga. ");
INSERT INTO kma_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Die tɩ dɔma sɔmm sɔmm mʋgɩkpɩɩrɩ kʋanʋaŋ ta die wa keŋ tʋgɩ jigidieke ba wasɩnana “Haarɩtɩ zielivɩɩnɩŋ jigiŋ” mi die ka yʋa aŋaŋ Lisia tɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Die tɩ yʋasɩna mi wɩa die saŋŋa dieke mʋgɩkpɩɩrɩ haarɩŋ dɔmɩŋ dɩ faasɩna yaa daanpɔyɩ dɩ wone keŋ tʋgɩ. Saŋka dɩaŋ ta Juu vuosi dʋʋga daakpeŋkpɩɩŋ dieke die ba kaabɩna ba wʋbɩatɩ naa chaala die tɩanya mɩŋ. Die wɩa Pɔɔli die dɩ kpaaŋ ba dɩ, ");
INSERT INTO kma_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“N zʋalɩŋ, n sɩba a baarɩ tɩ sieku gie nan yi daanpɔyɩ, tɩ chiititi aŋaŋ tɩ haarɩkʋ nan chʋʋsɩ ta vuosi bataŋ nan waarɩ ba mɩsɩ gbaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama die sojasi jakʋʋrɩ baga die wo wudieke Pɔɔli die dɩ bala wa ma dama die ʋ wʋmma yie haarɩkʋ jakʋʋrɩ aŋaŋ ka tieŋ wo. ");
INSERT INTO kma_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Die haarɩsɩ jigizielikiri die ka vɩɩna aŋaŋ ba zie mi tafaaŋ saŋŋa, die wɩa ba jusu die baarɩ dɩ ba hagɩ mi a gamma Fonisi. Mi die yiwo Kireeti tɩŋgbaŋ tɩŋ ta haarɩsɩ jigizielikiri die dɩ bie mi a tuoli ŋmɩŋ jʋʋkɩŋ chaaŋ, ta die ba yaala ba bemme mi tafaaŋ saŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Saŋŋa mi die ba ye bʋlɔgɩsɩŋ dɩ nɩgɩnana nyɩna ba nuugalɩ chaaŋ a kieŋ sɔmm sɔmm, ta die ba yile dɩ ka yi wo bʋlɔgɩsɩvɩɩnɩŋ wudieke dɩ baaŋ nan suŋŋine be sɩba ba sanna die wo. Die wɩa die ba datɩ kʋʋdʋnsɩ dieke dɩ yigine haarɩkʋ dɩ zie wo a yi haarɩkʋ sʋŋ a dɔma gbige Kireeti mʋgɩkpɩɩrɩ kʋanʋaŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ama die dɩ ka yʋasɩya ta bʋlɔgɩsɩkpeŋkpɩɩŋ die dɩ nɩga nyɩna ŋmɩŋ pɔsɩŋ chaaŋ a keŋ sʋʋna mʋgɩkpɩɩrɩ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Die bʋlɔgɩsɩbʋ die dɩ keŋ hʋbʋbʋ haarɩkʋ ma, ta die dɩ hagɩrɩ pam aŋaŋ vuoŋ dɩ baaŋ nan bɩagɩ dɔŋ haarɩkʋ a tuolibu, die wɩa die tɩ vaa mɩsɩ ta vaa bʋlɔgɩsɩbʋ dɩ yaa haarɩkʋ chʋŋ gara. ");
INSERT INTO kma_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Die bʋlɔgɩsɩbʋ die dɩ yaa tɩ ga tɩaŋ tɩgɩbɩŋ dieke ba wasɩnana Kɔda wa jigiŋ. Die tɩ tɩannana die tɩgɩbɩka die dɩ kagɩ bʋlɔgɩsɩbʋ die dɩ wa kpɩa. Die tɩ mɩɩ a bɩagɩ a yigi haarɩbike dieke dɩ taasɩna haarɩkpɩɩkʋ ma wa. ");
INSERT INTO kma_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Die ba datɩ ka a juu haarɩkpɩɩkʋ ma a nagɩ guune a mɩŋŋɩ bɔbɩ giliŋ haarɩkpɩɩkʋ keŋ keŋ. Die ba chɩga ŋmaamɩŋ dɩ ba nan ga gbigi Libia tɩŋgbaŋ ma, jigidieke nyaabʋ dɩ kana ka goli wo. Die wɩa die ba datɩ haarɩkʋ garɩkʋ a sʋʋŋ ta vaa bʋlɔgɩsɩbʋ dɩ bɩ yaa haarɩkʋ chʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Die bʋlɔgɩsɩkpɩɩbʋ dɩ ye ko nɩga, die wɩa ka tʋnvʋʋsa die ba piili a vʋara haarɩkʋ chiititi a taana. ");
INSERT INTO kma_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Die ka tʋnvʋʋsa bɩbra ba vʋarɩ haarɩkʋ gbaŋ gbaŋ nyintiti aŋaŋ ba nuusi a vigi taana nyaabʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Die dɩ yi daraa pam ta tɩ ka yese ŋmɩnnɩ yaa chɩŋmarɩsɩsɩ, nɩɩŋmara die dɩ ligine ŋmɩŋsikpeŋ wɩa. Ta bʋlɔgɩsɩbʋ die ye ko faasɩ nɩga ta die tɩ bɩ wo tama dɩ tɩ nan ye gbatɩtaanɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Die dɩ faasɩna a yʋasɩ ta vuosisi die ka dii jaaŋ, ta Pɔɔli dɩ hagɩ zie ba nɩŋŋa a baarɩ dɩ, “N zʋalɩŋ, dɩ tɩŋ mʋ nɩ tuo n nʋarɩ ta da dɔŋ nyɩŋ Kireeti, tɩ tɩŋ kaaŋ juu daanpɔyɩ aŋaŋ wahala ka gie me. ");
INSERT INTO kma_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama lele n wa jʋʋsa nɩ dɩ nɩ yigi sikimiŋ ta nɩ wʋnyɩ mana kaaŋ waarɩ ʋ mɩsɩ; ama haarɩkʋ nyɩɩna bala ka chʋʋsɩ. ");
INSERT INTO kma_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Dama dienewo yuku Ŋmɩŋ dieke dɩ sɩna mɩŋ ta maŋ jɩama wa malaka die keŋ wo n jigiŋ, ");
INSERT INTO kma_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","a keŋ balɩ mɩŋ dɩ, ‘Pɔɔli, da vaa ŋmaamɩŋ yalla fʋ. Sie ba nagɩ fʋ a ga zie naalɩba jakʋʋŋ Siiza jigiŋ aŋ ʋ dii fʋ sarɩya; fʋ wɩa Ŋmɩŋ baa ʋ gbatɩ wa vuodiekemba dɩ benne haarɩkʋ gie me a taaŋ.’ ");
INSERT INTO kma_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Die wɩa n zʋalɩŋ, nɩ dii sikimiŋ, dama n yi Ŋmɩŋ yada mɩŋ dɩ wudieke ʋ bala mɩŋ wa nan seŋ yi. ");
INSERT INTO kma_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ama bʋlɔgɩsɩbʋ nan kpaŋŋɩ tɩ a ga zieŋ tɩŋgbaŋ gaaŋ ta nyaaŋ dɩ giline kʋanʋaŋ.” ");
INSERT INTO kma_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Die ka yugiti baŋ-anɩɩsa die wonde ta bʋlɔgɩsɩbʋ die ye ko kpaŋŋa tɩ chʋŋ Miditerana mʋgɩkpɩɩrɩ sʋŋ. Ama yaa gamma ka tanseese haarɩ dɔntɩba dɩ mɩŋŋɩ dɩ tɩ gbige gaaŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Die wɩa die ba nagɩ jamagɩsɩŋ a magɩsɩ nyaabʋgoliŋ a die ye ta nyaabʋ goliŋ yiwo sɩba naŋ magɩsa kobɩga aŋaŋ baŋɩsɩ-le: die dɩ bɩ yi sʋaa die ba bɩ yi die gbaŋ gbaŋ ta ye ta bʋ goli yiwo naŋ magɩsɩŋ baŋɩsɩ-wayɩ. ");
INSERT INTO kma_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ŋmaamɩŋ die dɩ yigi be dama die ba yile dɩ ba haarɩkʋ nan keŋ jʋalɩ tana. Die wɩa die ba nagɩ kʋʋdʋnsa anɩɩsa dieke dɩ datɩnana haarɩkʋ dɩ ziele wo a yi nyaaŋ sʋŋ haarɩkʋ kʋaŋ ta die jʋʋsa Ŋmɩŋ dɩ tʋnvʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Die haarɩ dɔntɩba die dɩ yaala ba chɩgɩ ta vaa haarɩkʋ die wɩa die ba vʋarɩ haarɩbike a yi nyaabʋ sʋŋ ta paalɩ yie sɩba ba baa ba ga vʋarɩ wa kʋʋdʋnsɩha a taŋ taaŋ nyaabʋ sʋŋ haarɩkʋ nɩŋŋa. ");
INSERT INTO kma_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ama Pɔɔli die dɩ balɩ sojasisi jakʋʋrɩ aŋaŋ sojasisi dɩ, “Dɩɩ yi haarɩ dɔntɩba gie dɩ ka wɩarɩ kalɩ haarɩkʋ sʋŋ, nɩ wʋnyɩ mana kaaŋ ye gbatɩtaanɩŋ.” ");
INSERT INTO kma_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Die wɩa die sojasisi die dɩ gobi gobi guuŋ dieke dɩ bɔbɩna haarɩbike a yallɩ wa ta vaa ka nan nyaabʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Die tuŋ bɩlla vʋʋnɩŋ ta die Pɔɔli die dɩ jʋʋsɩ ba mana dɩ ba dii nyindiike, die ʋ baarɩ dɩ, “Daraa baŋ anɩɩsa wʋnna ŋmaamɩŋ dɩ yallɩ nɩ ta nɩ ka dii jaaŋ mana. ");
INSERT INTO kma_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Die wɩa n wa jʋʋsa nɩ ko dii nyindiike, dama ka yiwo jadieke dɩ baaŋ nan yi nɩ hagɩrɩŋ. Nɩ wʋnyɩ kaaŋ wɔŋ ye daŋŋa.” ");
INSERT INTO kma_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔɔli dɩ bala naa kpatɩ kʋaŋ chaaŋ die ʋ nagɩ paanʋ a bɩrɩ Ŋmɩŋ ba mana nɩŋŋa a yi ke gbieri a piili ŋɔba. ");
INSERT INTO kma_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Die ba dii sikimiŋ ta wa dii nyindiike. ");
INSERT INTO kma_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Die tɩ mana die yiwo vuosi kɔbɩsɩ-le aŋaŋ baŋɩsɩ-yʋpɔyɩ aŋaŋ ba yʋaba a bie haarɩkʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Die vuoŋ mana dɩ dine a chagɩ kʋaŋ chaaŋ die ba vʋarɩ paanʋ zaa tɩalɩkaha a taaŋ nyaabʋ sʋŋ amʋ haarɩkʋ da dʋnsɩma. ");
INSERT INTO kma_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Die tʋŋ dɩ vʋʋŋ, haarɩ dɔntɩba die dɩ ye tɩŋgbaŋka ama ta ka mɩŋŋɩ mi, ama ta ye gbagɩŋ kaanɩ mʋgɩkpɩɩrɩ lʋgɩŋ ta ka yallɩ gaaŋ ba yile dɩ ba tɩŋ nan bɩagɩ ba yi haarɩkʋ ga mi a ga fɩrɩ tambʋsɩkʋ me. ");
INSERT INTO kma_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Die wɩa die ba chɩa gobi kʋʋdʋnsaha guune a vaa ha a sʋʋŋ ga nyaabʋ chɩaŋ, ta bɩ forisi guuŋ diekemba dɩ bɔbɩna daa diekemba ba yalla a dɔma wa ta die kɔtɩ garɩ dieke dɩ benne haarɩkʋ nɩŋka amʋ bʋlɔgɩsɩbʋ nan dɩ nɩga a kpaŋŋa haarɩkʋ a gara nɩŋŋa. Die ba keŋ gbigi mʋgɩrɩ kʋanʋaŋ. ");
INSERT INTO kma_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama haarɩkʋ nɩŋŋa die dɩ ga gbeŋ tambʋsɩbʋ ta faasɩ fɩrɩ ta nyapoŋiku dɩ keŋ a nɩgɩ ka kʋaka a ŋmʋʋrɩ ŋmʋʋrɩ. ");
INSERT INTO kma_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tɔ, sojasisi die dɩ saŋ dɩ ba kʋʋ dansarɩka jujuribe amʋ ba wʋnyɩ gbaŋ kaaŋ suo jʋalɩ gaaŋ a chɩgɩ bɩa. ");
INSERT INTO kma_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama sojasisi jakʋʋrɩ die yaala ʋ gbatɩ Pɔɔli a taaŋ. Die wɩa die ʋ kagɩ ba dɩ ba daa yi die. Ama die ʋ yɩ nʋaŋ dɩ vuodiekemba mana dɩ sɩbɩna suolehe nan nyaabʋ ma a suo jʋalɩ gaaŋ; ");
INSERT INTO kma_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ta vuo tɩalɩkaha dɩ kana ka sɩba suolehe yigi haarɩkʋ daatɩtɩ a jʋalɩ. Naa die tɩ yi tɩ mana dɩ jʋalɩ gaaŋ ta wɩɩŋ dɩ ka yi tɩ. ");
INSERT INTO kma_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Die tɩ kenne a jʋalɩ gaarɩ ta wɩɩŋ dɩ ka yi tɩ wo, die tɩ mɩŋŋɩ dɩ tɩŋgbaŋka mi saaŋ yiwo Malita. ");
INSERT INTO kma_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Die tɩka vuosi die mɩŋŋɩ tuo tɩ, dama saŋŋa mi nɩɩŋ die nɩɩnana ta watɩ die faasɩ beri die wɩa die ba chɔgɩsɩ boliŋ dɩ tɩ weeli ta yi tɩ aŋsɩa. ");
INSERT INTO kma_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Die Pɔɔli die dɩ lagɩsɩ daatɩ a nagɩha taana bolibu me, womi die javʋʋkɩŋ die dɩ keŋ nyɩŋ daatɩ ma bolibu dɩ tʋʋlɩna wɩa a dʋŋ Pɔɔli ta nagɩ ka gbaŋ vili ʋ nuuŋ. ");
INSERT INTO kma_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Die tɩŋgbaŋka vuosi die dɩ ye javʋʋkɩrɩ die dɩ leeŋinene Pɔɔli nuuŋ me ta die bala yɩa tamba dɩ, “Daa wa gie nan yi vuokʋʋrʋ, aŋaŋ ʋ gbatɩna ʋ gbaŋ a nyɩŋ mʋgɩkpɩɩrɩ wa ma, ama bugile kaaŋ vaa ʋ bemme ʋ mɩsɩ ma.” ");
INSERT INTO kma_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama Pɔɔli die dɩ kpaantɩ javʋʋkɩrɩ a taaŋ bolibu me ta wɩɩŋ mana dɩ ka yi wo. ");
INSERT INTO kma_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Die vuosisi die dɩ yile dɩ ʋ nan fʋʋsɩ yaa ʋ nan nan bʋnyɩ a kpi. Die ba yilinene die wo a keŋ gbalɩgɩ ta wɩɩŋ mana ka yi wo wo, die ba tarɩgɩ ba sʋŋanyile ta baarɩ dɩ, “Daa wa gie yiwo buuŋ.” ");
INSERT INTO kma_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Mi die ka yʋa aŋaŋ tɩŋgbaŋka naaŋ Pubiluwosi kʋatɩ. Die ʋ mɩŋŋɩ tuo tɩ chaantɩ ta die tɩ yi ʋ chaanɩŋ daraa ataa. ");
INSERT INTO kma_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pubiluwosi chɔɔŋ die dɩ dʋa a yʋagɩ, nyɩŋgbaŋ tʋʋla aŋaŋ chʋʋrɩŋ die yalla wa. Ta Pɔɔli die dɩ ga juu ʋ juoku me a nagɩ ʋ nuuŋ a diisi ʋ ma a jʋʋsɩ Ŋmɩŋ yɩ wa die ʋ ye alaafɩa. ");
INSERT INTO kma_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Naa kʋaŋ chaaŋ yʋagɩtieliŋ die dɩ benne tɩŋgbaŋka ma die dɩ keŋ Pɔɔli jigiŋ die ʋ gbaaŋ ba mana. ");
INSERT INTO kma_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Die ba yɩ tɩ piinisi pam ta die tɩ balla tɩ ga wa ba nagɩ jadieke mana tɩ yaalala a yi haarɩkʋ sʋŋ. ");
INSERT INTO kma_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Die tɩ benne mi chɩɩtɩ ataa kʋaŋ chaaŋ die tɩ nagɩ haarɩ dieke ba wasɩnana Ŋmɩŋyɩɩba wa ta die dɩ nyɩna Alekizandira ta bie Malita tafaaŋ saŋka mi wo. ");
INSERT INTO kma_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Die tɩ ga tʋgɩ tɩŋ dieke ba wasɩnana Sarakusi ta die yi daraa ataa mi, ");
INSERT INTO kma_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ta die bɩ nagɩ haarɩkʋ a ga tʋgɩ tɩŋ dieke ba wasɩnana Regumi wa. Ka tʋnvʋʋsa die bʋlɔgɩsɩŋ dɩ piili a nɩga nyɩna nuugalɩ chaaŋ, ta ka daraa ale daraaŋ die tɩ keŋ tʋgɩ Putiwoli tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mi die tɩ ye Yisa dɩdɩɩsɩrɩba bataŋ, die ba balɩ tɩ dɩ tɩ wɩarɩ ba jigiŋ daraa ayʋpɔyɩ. Die tɩ keŋ nyɩŋ mi a ga Romi. ");
INSERT INTO kma_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Die Yisa dɩdɩɩsɩrɩba die dɩ benne Romi wa die dɩ wʋŋ tɩ wɩa ta die keŋ tuoli tɩ sieŋ Apiyusi nyʋŋ ma, ta bataŋ dɩaŋ dɩ keŋ tuoli tɩ chaanɩŋ juone ataa dieke die dɩ gbine Romi wa. Pɔɔli die dɩ yene be wo die dɩ kpaŋŋɩsɩ wa ta ʋ bɩrɩ Ŋmɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Die tɩ gana a ga tʋgɩ Romi die ba yɩ Pɔɔli sieŋ dɩ ʋ bemme ʋ dʋŋŋʋ ta vaa soja balɩmɩŋ gbara wa. ");
INSERT INTO kma_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Daraa ataa kʋaŋ chaaŋ Pɔɔli die dɩ wa Juu vuosi nɩŋŋandɩɩsɩrɩba a lagɩsɩ. Die ba lagɩsɩna wa ʋ balɩ a yɩ ba dɩ, “N nɩmballɩ, aŋaŋ die n kana ka yi wɩɩŋ mana a chʋʋsɩ tɩ vuosisi yaa ta chʋʋsɩ tɩ chɔɔŋkʋʋlɩba chʋaraha, die ba nagɩ mɩŋ yi wo dansarɩka sʋŋ Jerusalemi ma, ta nagɩ mɩŋ yi Romani vuosi nuusi me. ");
INSERT INTO kma_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Die ba pɩasɩ mɩŋ wudieke n yine a chʋʋsɩ ta die yaala ba vʋarɩ mɩŋ, dama die ba mɩŋŋɩya dɩ n ka yi wudieke dɩ mʋna dɩ ba kʋʋ mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama Juu vuosisi nɩŋŋandɩɩsɩrɩba die dɩ ka saagɩya, die wɩa die maŋ baarɩ dɩ n nan nagɩ n wɩɩrɩ a poli a keŋ naaŋ jakʋʋŋ Siiza jigiŋ, ama n wo wɩɩŋ a baaŋ balɩ chʋʋsɩ n gbaŋ gbaŋ n vuosi. ");
INSERT INTO kma_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Die wɩa maŋ baaŋ n ye nɩ a balɩ nɩ wɩɩrɩ. N mʋʋlɩnana Ŋmɩŋ Vuovʋarɩkɩrɩ wɩaha, vuodieke tɩnɩŋ Juu vuosi dɩ yalla tama wa, die wɩa ba bɔbɩ mɩŋ aŋaŋ chɔrɩmaha gie.” ");
INSERT INTO kma_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ta ba balɩ a yɩ wa dɩ, “Tɩnɩŋ tɩ ka tuo gbanɩŋ a nyɩŋ Judia yaa gamma fʋ ma, ta vuoŋ ka nyɩŋ a keŋ gie aŋaŋ wɩɩrɩ yaa a balɩ wʋbɩaŋ yaa gamma fʋ ma. ");
INSERT INTO kma_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama tɩ nan dɩ yaala tɩ sɩmma fʋ sʋŋanyile. Tɩ wɔŋ sɩba a baarɩ dɩ jigiŋ mana vuosi bala a chʋʋsa jɩamɩŋ dieke fʋ dɩna wa.” ");
INSERT INTO kma_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Die wɩa die ba nagɩ daaŋ zieŋ aŋaŋ Pɔɔli. Dɩnɩŋ daarɩ mi daadaŋ pam dɩ keŋ a lagɩsɩ Pɔɔli die dɩ benne jigiŋ dieke wo. Die ʋ dagɩ ba Ŋmɩŋ naarɩ wɩa a nyɩŋ sʋkʋʋŋ a ga tʋgɩ yuŋ, ta die mɩa dɩ ʋ tarɩgɩ ba sʋgɩtɩ dɩ ba tuo Yisa, ta die vʋara wɩa a nyɩna Mosisi mɩraha ma aŋaŋ Ŋmɩŋ naazʋalɩba die dɩ maagɩna wudiekemba ba. ");
INSERT INTO kma_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Die bataŋ sʋgɩtɩ die dɩ tarɩgɩ aŋaŋ ʋ wʋbalɩkaha ma ama bataŋ die dɩ ka tuo dii. ");
INSERT INTO kma_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Die wɩa die ba hagɩ mi aŋaŋ nɩnhagɩrɩŋ aŋaŋ taŋ yaa gamma wʋbalɩkaha gie. Pɔɔli die dɩ balɩ dɩ, “Saŋŋa dieke Ŋmɩŋ Halɩkasɩka die dɩ vana Ŋmɩŋ naazʋa Azaya die balɩ yɩ tɩ chɔɔŋkʋʋlɩba wa, die ʋ balɩ wusie mɩŋ. ");
INSERT INTO kma_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Die ʋ baarɩ dɩ, ‘Ga a balɩ naa yɩ vuosi gie dɩ: Nɩ nan keŋ wʋŋ a bɩ wʋŋ ama dɩ kaaŋ dɩ sɩba a chɩaŋ; ta nɩ nan keŋ daansɩ a bɩ daansɩ ama nɩ kaaŋ ye, ");
INSERT INTO kma_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","dama vuosi gie yiwo yɩaŋkpiititieliŋ, ta bɩ ligi ba tɩba dɩ ba kaaŋ wʋŋ, ta bɩ muo ba nine dɩ ba da yesime. Dɩɩ yi die ba ka muo ba nine ba tɩŋ nan ye, ba tɩŋ ka bɩ ligi ba tɩba, ba tɩŋ nan wʋŋ, ta ba tɩŋ ka bɩ yi yɩaŋkpititieliŋ ba tɩŋ nan dɩ sɩba wɩaha gie chɩasɩ. Ta ba tɩŋ nan yiŋŋi keŋ n jigiŋ aŋ n gbaaŋ ba.’ ” ");
INSERT INTO kma_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔɔli die dɩ bɩ balɩ dɩ, “Nɩ sɩmma a baarɩ dɩ Ŋmɩŋ wɩaha yaa gamma ʋ gbatɩtaaŋkʋ tʋgɩ vuodiekemba dɩ kana ka yi Juu vuosisi jigiŋ mɩŋ, ta ba nan wʋŋ.” (( ");
INSERT INTO kma_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔɔli die dɩ bala naa a kpatɩ Juu vuosisi die dɩ hagɩ a nɩga nɩnhagɩrɩŋ pam aŋaŋ taŋ.)) ");
INSERT INTO kma_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔli die dɩ tuŋ ligire a yɩ jigidieke ʋ benne wo a bie mi bɩna ale ta mɩŋŋɩ tuose chaaŋ diekemba mana dɩ kienene ʋ jigiŋ dɩ ba ye wo. ");
INSERT INTO kma_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ta die mʋʋlɩ wɩa yaa gamma Ŋmɩŋ naarɩ ma, ta daga vuosi tɩ Yɔmʋtieŋ Yisa Masia wɩa, ta bala ʋ dʋŋŋʋ aŋaŋ sikimiŋ.");
INSERT INTO kma_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Gbaŋkʋ gie nyɩŋ wa manɩŋ Pɔɔli vuodieke dɩ yine Yisa Masia tʋntʋntʋ, ta bɩ yi tʋntʋntʋ dieke Ŋmɩŋ dɩ vʋarɩna dɩ n mʋʋlɩ ʋ wʋvɩɩnaha jigiŋ mana wa jigiŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ŋmɩŋ die woliŋ yɩ wa nʋaŋ yaa gamma ʋ wʋvɩɩnaha gie ma, ta ʋ naazʋalɩŋ die dɩ mʋʋlɩha, sɩba a maagɩna dene ʋ kasɩ gbaŋkʋ ma wa. ");
INSERT INTO kma_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Wʋvɩɩnaha gie daga yaa gamma ʋ Bʋa wa; wʋnɩŋ ʋ yine tɩ Yɔmʋtieŋ Yisa Masia; die ʋ bɩrɩŋ wa vuota, ta ba mɩɩrɩ wa ʋ yi naaŋ Davidi haagɩŋ, ");
INSERT INTO kma_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ta Halɩkasɩka die dɩ dagɩ aŋaŋ hagɩrɩŋ dɩ Yisa seŋ yiwo Ŋmɩŋ Bʋa ʋ kumbu hagɩŋ wɩa. ");
INSERT INTO kma_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ʋ wɩa Ŋmɩŋ die dɩ yɩ mɩŋ sieŋ dɩ n yi ʋ tʋntʋntʋ, ta maŋ nagɩ ʋ saaŋ a gara buuriŋ mana jigiŋ, ta vasa ba yie wo yada ta tuose ʋ nʋaŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nɩnɩŋ vuodiekemba dɩ benne Romi ma wa gbaŋ gʋtɩ wa vuodiekemba Ŋmɩŋ dɩ wana dɩ ba bɩrɩŋ Yisa Masia sɩɩtɩ wa ma mɩŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Die wɩa n maaga gbaŋkʋ gie a yɩa nɩ vuodiekemba mana dɩ benne Romi tɩŋ ma, ta Ŋmɩŋ dɩ cho nɩ ta wa nɩ dɩ nɩ yi ʋ gbaŋ gbaŋ ʋ vuosi wa. Tɩ Chɔɔŋ Ŋmɩŋ aŋaŋ tɩ Yɔmʋtieŋ Yisa Masia suŋŋi nɩ ta yɩ nɩ sʋgɩdʋagɩŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Wudieke n yaalala dɩ n woliŋ balɩ wʋnna, n waasa Ŋmɩŋ Yisa Masia saaŋ ma, nɩ mana wɩa, dama tɩŋgbaŋka gie vuosi mana wʋmma nɩ yada ka wɩa. ");
INSERT INTO kma_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ŋmɩŋ yine n siaratieŋ dɩ n ka va Ŋmɩŋ jʋʋsɩŋ nɩ wɩa. Wʋnɩŋ ʋ yine vuodieke n jɩannana aŋaŋ n sʋŋ mana ta mʋʋla wʋvɩɩnaha yaa gamma ʋ Bʋa wa ma. ");
INSERT INTO kma_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Maŋ keŋ jʋʋsa Ŋmɩŋ saŋŋa mana, n ŋaaŋ jʋʋsɩ wa mɩŋ dɩ dɩɩ yi ʋ dʋŋŋʋ, ʋ yɩ mɩŋ sieŋ aŋ n keŋ kaagɩ nɩ. ");
INSERT INTO kma_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","N faasɩ yaala n suŋŋi nɩ aŋ nɩ tuo Ŋmɩŋ Halɩkasɩka piini dieke dɩ baaŋ vaa nɩ mɩŋŋɩ a zie ta yaa hagɩrɩŋ ʋ dɩɩsɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Wudieke n dagɩnana wa yiwo naa, dɩ manɩŋ aŋaŋ nɩnɩŋ vuodiekemba dɩ yine yada wa nan bɩagɩ a kpaŋŋɩsɩ taŋ tɩ yada ka ma. ");
INSERT INTO kma_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","N nɩmballɩ, n yaala nɩ sɩmma dɩ n mɩya mɩŋ saŋŋa pam dɩ n keŋ kaagɩ nɩ ama wɩa a taŋ dɩ kaga mɩŋ. N yaala n yi vuodiekemba dɩ benne nɩ jigiŋ tɩ Yɔmʋtieŋ sɩɩtɩ sɩba n yine vuogaasɩ jigiŋ dene wo. ");
INSERT INTO kma_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Dɩ yiwo talasɩ dɩ n balɩ vuosi mana wʋvɩɩnaha wɩa, vuodiekemba nine dɩ yuorine aŋaŋ vuodiekemba nine dɩ kana ka yuoriye, aŋaŋ vuodiekemba dɩ yalla yɩaŋ aŋaŋ vuodiekemba dɩ wone yɩaŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Die wɩa maŋ cheele dɩ n mʋʋlɩ wʋvɩɩnaha a yɩ nɩnɩŋ vuodiekemba dɩ benne Romi tɩŋ ma. ");
INSERT INTO kma_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Viivi ka yallɩ mɩŋ n mʋʋlɩnana wʋvɩɩnaha, dama dɩ yiwo Ŋmɩŋ hagɩrɩ dieke dɩ gbatɩnana vuodiekemba mana dɩ yine Yisa yada a taana; ka woliŋ yiwo Juu vuosi sɩɩtɩ, ta bɩ yi buuriŋ mana sɩɩtɩ. ");
INSERT INTO kma_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Wʋvɩɩnaha daga dɩ Ŋmɩŋ baarɩ dɩ vuoŋ yiwo vuovɩɩnʋ ʋ nɩŋŋa ʋ yada yiile wɩa, genke nyɩŋ wa yaalɩŋ ma a yɩ vuodiekemba dɩ yine Yisa yada, sɩba dɩ maagɩna Ŋmɩŋ gbaŋkʋ ma dene wo dɩ, “Vuodieke dɩ yine vuovɩɩnʋ Ŋmɩŋ nɩŋŋa ʋ yadaka wɩa, dɩ tieŋ nan dɩ yaa miivoli dieke dɩ wone kpatɩŋ.” ");
INSERT INTO kma_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ŋmɩŋ dagɩ vuota dɩ ʋ jɩɩ wa sɩnyɩɩrɩŋ aŋaŋ ba, dama ba yie wʋbɩatɩ ta ka dɩ ʋ sieŋ, ta ba wʋbɩatɩ dɩ vaa vuosi dɩ ka sɩba wusieke. ");
INSERT INTO kma_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ŋmɩŋ data ba tɩba, dama wudieke dɩ mʋna dɩ vuota sɩmma yaa gamma ʋ ma wa, ʋ yuori dagɩ ba mɩŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Saŋŋa dieke Ŋmɩŋ dɩ naanna tɩŋgbaŋka gie wo a keŋ tʋgɩ jinne, ʋ naaŋkʋ ma ba sɩba ʋ beri dieke vuota nine dɩ kana kaaŋ bɩagɩ a ye, ta bɩ sɩba dɩ ʋ yaa hagɩrɩ dieke dɩ wone kpatɩŋ, ta seŋ yi Ŋmɩŋ. Die wɩa, ba bɩ wo sieŋ Ŋmɩŋ nɩŋŋa a baaŋ baarɩ dɩ ba ka sɩba ba wʋbɩatɩ. ");
INSERT INTO kma_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ba sɩba Ŋmɩŋ mɩŋ, ama ba ka yɩa wa jɩlɩma dieke ba mʋna dɩ ba yɩ wa, ta bɩ ka waasa wa. Ama ba sʋŋanyile yiwo sʋŋanyilibɩatɩ, ta ba sʋgɩtɩ dɩ suuli aŋaŋ wʋtɔgɩtɩ aŋaŋ lɩmɩŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ba baarɩ dɩ ba yaa wa yɩaŋ ama ba yiwo gaantɩŋ; ");
INSERT INTO kma_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ba tɩnna mʋ ba jɩama Ŋmɩŋ dieke dɩ benne saŋŋa mana wa, ba vaya mɩŋ ta jɩama ŋmɩna diekemba vuota dɩ wʋnsɩna a nɩasɩ vuota yaa nembisi yaa dɔŋɩsɩ yaa nyinvuuke. ");
INSERT INTO kma_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Die wɩa Ŋmɩŋ dɩ va ba, ta ba yie tʋntʋmbɩatɩ diekemba ba sʋgɩtɩ dɩ yaalala, ta yie viivi wɩa aŋaŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ta nagɩ wudieke dɩ yine Ŋmɩŋ wusieke a taaŋ, ta saagɩ yɩ ŋmɩnchɩbɩsɩ, ta tarɩgɩ a jɩama wudieke Ŋmɩŋ dɩ naanna, ta vaa wʋnɩŋ Ŋmɩŋ vuodieke dɩ naanna ha ta mʋ dɩ tɩ bɩrɩ wa wa yaa gamma haahuu wo. Wusie. ");
INSERT INTO kma_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Die wɩa, Ŋmɩŋ dɩ vaa ba, ta ba yie ba dʋŋŋʋ dɩ yalla viivi, ta ba hɔgʋba dɩ ka bɩ yaala ba dʋagɩma aŋaŋ dembisi ta yiŋŋi a dʋaga aŋaŋ taŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Die gbaŋ gbaŋ ta dembisi dɩ ka bɩ yaala ba dʋagɩma aŋaŋ hɔgʋba, ta yiŋŋi dʋaga aŋaŋ taŋ, ta ba faasɩ yaa lɔla pam aŋaŋ taŋ. Dembisi dɩ yie nyinti ataŋ die dɩ yalla viivi aŋaŋ taŋ, die wɩa ba yese tɩbɩdatɩ dieke ba mʋna ba wʋbɩatɩtɩ wɩa. ");
INSERT INTO kma_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Vuota die dɩ kana ka yaala ʋ sɩmma Ŋmɩŋ wɩa, ʋ vaa ba aŋaŋ ba tʋmbɩatɩ, ta ba yie tʋŋ dieke dɩ kana ka vɩɩna. ");
INSERT INTO kma_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ba sʋgɩtɩ suuliye mɩŋ aŋaŋ tʋmbɩatɩ yiri yiri, sɩba bɩaŋ aŋaŋ halɩ, ta yie bɩaŋ a yɩa taŋ, ta yaa sʋgɩbɩaŋ, ta kʋa taŋ, ta waga aŋaŋ taŋ, ta chɩba ŋmɩnchɩbɩsɩ, ta yile wʋbɩatɩ a yɩa taŋ, ta gaara taŋ kʋasɩ, ");
INSERT INTO kma_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ta bala chʋʋsa taŋ, ta yi Ŋmɩŋ dataasɩ, ta zɩa wa taŋ, ta yaa kalinbaani, ta kule, ta yaala sieti dɩ ba yi bɩaŋ, ta ka yɩa ba chʋalɩŋ aŋaŋ ba nɩɩlɩŋ jɩlɩma; ");
INSERT INTO kma_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ta bɩ wo yɩaŋ ba ma, ta ka bɩ bala wusie, ta wo choti ta ka chɩga zɔɔlɩŋ. ");
INSERT INTO kma_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ba sɩba a baarɩ Ŋmɩŋ mɩraha dagɩya dɩ vuodiekemba dɩ yinene wɩaha gie nyʋarɩ yiwo kuŋ, ama hanɩŋ ba ko yie, ta bɩ yaa sʋgɩfɩalɩŋ aŋaŋ vuodiekemba dɩ yinene he wo. ");
INSERT INTO kma_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","N zʋamba, dɩɩ yi nɩ die vuosi sarɩya, fʋ sɩɩ die mana kaaŋ bɩagɩ baarɩ ka yi bɩaŋ. Dama dɩɩ yi fʋ die vuosi sarɩya ama ta yie wudieke ba yinene gbaŋ gbaŋ, die nɩŋ, die fʋ gbaŋ gbaŋ fʋ sarɩya. ");
INSERT INTO kma_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tɩ sɩba a baarɩ Ŋmɩŋ nan keŋ dii vuodiekemba dɩ yine die sarɩya, ta ʋ sarɩya diilehe yiwo wusie. ");
INSERT INTO kma_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Fʋ dagɩnana vuosi dɩ yinene tʋmbɩatɩ dene wo, ama ta yie die, yile dɩ Ŋmɩŋ kaaŋ ye ta datɩ fʋ tɩbɩŋ? ");
INSERT INTO kma_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Yaa fʋ nine ka suuliye chotikpɩɩkʋ aŋaŋ suguru pam dieke Ŋmɩŋ dɩ yalla aŋaŋ tɩnɩŋ wa? Ka sɩba a baarɩ dɩ wudieke wɩa Ŋmɩŋ dɩ chɩgɩna nɩ zɔɔlɩŋ yiwo ʋ yaala nɩ yiŋŋi keŋ ʋ jigiri? ");
INSERT INTO kma_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ama fʋ sikpeŋ hagɩrɩ mɩŋ, die wɩa fʋ ka saagɩ fʋ vaa tʋntʋmbɩatɩ tʋʋma, die wɩa gʋta fʋ tɩbɩdatɩ dieke fʋ bala fʋ keŋ a ye daa dieke Ŋmɩŋ sɩnyɩɩrɩŋ dɩ bala ka keŋ a nyɩŋ yaalɩŋ ma, aŋ ʋ keŋ dii vuosi sarɩya aŋaŋ wusie wo. ");
INSERT INTO kma_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Dama Ŋmɩŋ nan tuŋ vuoŋ mana yaa gamma ʋ tʋnna dene. ");
INSERT INTO kma_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Vuodiekemba dɩ yinene vɩɩnɩŋ t